﻿USE sofia;
DROP TABLE IF EXISTS sofia.engULB_vpl;
CREATE TABLE engULB_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES engULB_vpl WRITE;
INSERT INTO engULB_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","In the beginning, God created the heavens and the earth. ");
INSERT INTO engULB_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","The earth was without form and empty. Darkness was upon the surface of the deep. The Spirit of God was moving above the surface of the waters. ");
INSERT INTO engULB_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","God said, “Let there be light,” and there was light. ");
INSERT INTO engULB_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","God saw the light, that it was good. He divided the light from the darkness. ");
INSERT INTO engULB_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","God called the light “day,” and the darkness he called “night.” This was evening and morning, the first day. ");
INSERT INTO engULB_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","God said, “Let there be an expanse between the waters, and let it divide the waters from the waters.” ");
INSERT INTO engULB_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","God made the expanse and divided the waters which were under the expanse from the waters which were above the expanse. It was so. ");
INSERT INTO engULB_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","God called the expanse “sky.” This was evening and morning, the second day. ");
INSERT INTO engULB_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","God said, “Let the waters under the sky be gathered together to one place, and let the dry land appear.” It was so. ");
INSERT INTO engULB_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","God called the dry land “earth,” and the gathered waters he called “seas.” He saw that it was good. ");
INSERT INTO engULB_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","God said, “Let the earth sprout vegetation: plants yielding seed and fruit trees bearing fruit whose seed is in the fruit, each according to its own kind.” It was so. ");
INSERT INTO engULB_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","The earth produced vegetation, plants producing seed after their kind, and trees bearing fruit whose seed was in it, after their kind. God saw that it was good. ");
INSERT INTO engULB_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","This was evening and morning, the third day. ");
INSERT INTO engULB_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","God said, “Let there be lights in the sky to divide the day from the night and let them be as signs, for seasons, for days and years. ");
INSERT INTO engULB_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Let them be lights in the sky to give light upon the earth.” It was so. ");
INSERT INTO engULB_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","God made the two great lights, the greater light to rule the day, and the lesser light to rule the night. He made the stars also. ");
INSERT INTO engULB_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","God set them in the sky to give light upon the earth, ");
INSERT INTO engULB_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","to rule over the day and over the night, and to divide the light from the darkness. God saw that it was good. ");
INSERT INTO engULB_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","This was evening and morning, the fourth day. ");
INSERT INTO engULB_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","God said, “Let the waters be filled with great numbers of living creatures, and let birds fly above the earth in the expanse of the sky.” ");
INSERT INTO engULB_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","God created the great sea creatures, as well as every living creature after its kind, creatures that move and which fill the waters everywhere, and every winged bird after its kind. God saw that it was good. ");
INSERT INTO engULB_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","God blessed them, saying, “Be fruitful and multiply, and fill the waters in the seas. Let birds multiply on the earth.” ");
INSERT INTO engULB_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","This was evening and morning, the fifth day. ");
INSERT INTO engULB_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","God said, “Let the earth produce living creatures, each according to its own kind, livestock, creeping things, and beasts of the earth, each according to its own kind.” It was so. ");
INSERT INTO engULB_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","God made the beasts of the earth after their kind, the livestock after their kinds, and everything that creeps upon the ground after its kind. He saw that it was good. ");
INSERT INTO engULB_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","God said, “Let us make man in our image, after our likeness. Let them have dominion over the fish of the sea, over the birds of the sky, over the livestock, over all the earth, and over every creeping thing that creeps on the earth.” ");
INSERT INTO engULB_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","God created man in his own image. In his own image he created him. Male and female he created them. ");
INSERT INTO engULB_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","God blessed them and said to them, “Be fruitful, and multiply. Fill the earth, and subdue it. Have dominion over the fish of the sea, over the birds of the sky, and over every living thing that moves upon the earth.” ");
INSERT INTO engULB_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","God said, “See, I have given you every plant yielding seed which is upon the surface of all the earth, and every tree with fruit which has seed in it. They will be food to you. ");
INSERT INTO engULB_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","To every beast of the earth, to every bird of the heavens, and to everything that creeps upon the earth, and to every creature that has the breath of life I have given every green plant for food.” It was so. ");
INSERT INTO engULB_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","God saw everything that he had made. Behold, it was very good. This was evening and morning, the sixth day. ");
INSERT INTO engULB_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Then the heavens and the earth were finished, and all the living things that filled them. ");
INSERT INTO engULB_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","On the seventh day God came to the end of his work which he had done, and so he rested on the seventh day from all his work. ");
INSERT INTO engULB_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","God blessed the seventh day and sanctified it, because in it he rested from all his work which he had done in his creation. ");
INSERT INTO engULB_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","These were the events concerning the heavens and the earth, when they were created, on the day that Yahweh God made the earth and the heavens. ");
INSERT INTO engULB_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","No bush of the field was yet in the earth, and no plant of the field had yet sprouted, for Yahweh God had not caused it to rain upon the earth, and there was no man to cultivate the ground. ");
INSERT INTO engULB_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","But a mist went up from the earth and watered the whole surface of the ground. ");
INSERT INTO engULB_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yahweh God formed man from the dust of the ground, and breathed into his nostrils the breath of life, and man became a living being. ");
INSERT INTO engULB_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Yahweh God planted a garden eastward, in Eden, and there he put the man whom he had formed. ");
INSERT INTO engULB_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Out of the ground Yahweh God made every tree to grow that is pleasant to the sight and good for food. This included the tree of life that was in the midst of the garden, and the tree of the knowledge of good and evil. ");
INSERT INTO engULB_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","A river went out of Eden to water the garden. From there it divided and became four rivers. ");
INSERT INTO engULB_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","The name of the first is Pishon. It is the one which flows throughout the whole land of Havilah, where there is gold. ");
INSERT INTO engULB_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","The gold of that land is good. There are also bdellium and the onyx stone. ");
INSERT INTO engULB_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","The name of the second river is Gihon. This one flows throughout the whole land of Cush. ");
INSERT INTO engULB_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","The name of the third river is Tigris, which flows east of Ashur. The fourth river is the Euphrates. ");
INSERT INTO engULB_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Yahweh God took the man and put him into the garden of Eden to work it and to maintain it. ");
INSERT INTO engULB_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Yahweh God commanded the man, saying, “From every tree in the garden you may freely eat. ");
INSERT INTO engULB_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","But from the tree of the knowledge of good and evil you may not eat, for on the day that you eat from it, you will surely die.” ");
INSERT INTO engULB_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Then Yahweh God said, “It is not good that the man should be alone. I will make him a helper suitable for him.” ");
INSERT INTO engULB_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Out of the ground Yahweh God formed every animal of the field and every bird of the sky. Then he brought them to the man to see what he would call them. Whatever the man called each living creature, that was its name. ");
INSERT INTO engULB_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","The man gave names to all the livestock, to all the birds of the sky, and to every beast of the field. But for the man himself there was found no helper suitable for him. ");
INSERT INTO engULB_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Yahweh God caused a deep sleep to fall upon the man, so the man slept. Yahweh God took one of his ribs and closed up the flesh where he took the rib. ");
INSERT INTO engULB_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","With the rib that Yahweh God had taken from the man, he made a woman and brought her to the man. ");
INSERT INTO engULB_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","The man said, “This time, this one is bone of my bones, and flesh of my flesh. She will be called 'woman,' because she was taken out of man.” ");
INSERT INTO engULB_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Therefore a man will leave his father and his mother, he will be united to his wife, and they will become one flesh. ");
INSERT INTO engULB_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","They were both naked, the man and his wife, but were not ashamed. ");
INSERT INTO engULB_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Now the serpent was more shrewd than any other beast of the field which Yahweh God had made. He said to the woman, “Has God really said, 'You must not eat from any tree of the garden'?” ");
INSERT INTO engULB_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","The woman said to the serpent, “We may eat the fruit from the trees of the garden, ");
INSERT INTO engULB_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","but concerning the fruit of the tree which is in the middle of the garden, God said, 'You may not eat it, nor may you touch it, or you will die.'” ");
INSERT INTO engULB_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","The serpent said to the woman, “You will surely not die. ");
INSERT INTO engULB_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","For God knows that the day you eat it your eyes will be opened, and you will be like God, knowing good and evil.” ");
INSERT INTO engULB_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","When the woman saw that the tree was good for food, and that it was a delight to the eyes, and that the tree was desirable to make one wise, she took some of its fruit and ate it. Then she also gave some to her husband who was with her, and he ate it. ");
INSERT INTO engULB_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","The eyes of both of them were opened, and they knew that they were naked. They sewed fig leaves together and made coverings for themselves. ");
INSERT INTO engULB_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","They heard the sound of Yahweh God walking in the garden in the cool of the day, so the man and his wife hid themselves from the presence of Yahweh God among the trees of the garden. ");
INSERT INTO engULB_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Yahweh God called to the man and said to him, “Where are you?” ");
INSERT INTO engULB_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","The man said, “I heard you in the garden, and I was afraid, because I was naked. So I hid myself.” ");
INSERT INTO engULB_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","God said, “Who told you that you were naked? Have you eaten from the tree that I commanded you not to eat from?” ");
INSERT INTO engULB_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","The man said, “The woman whom you gave to be with me, she gave me fruit from the tree, and I ate it.” ");
INSERT INTO engULB_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Yahweh God said to the woman, “What is this you have done?” The woman said, “The serpent lied to me, and I ate.” ");
INSERT INTO engULB_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Yahweh God said to the serpent, “Because you have done this, cursed are you alone among all the livestock and all the beasts of the field. It is on your stomach that you will go, and it is dust that you will eat all the days of your life. ");
INSERT INTO engULB_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","I will put hostility between you and the woman, and between your seed and her seed. He will bruise your head, and you will bruise his heel.” ");
INSERT INTO engULB_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","To the woman he said, “I will greatly multiply your pain in having children; it is in pain that you will give birth to children. Your desire will be for your husband, but he will rule over you.” ");
INSERT INTO engULB_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","To Adam he said, “Because you have listened to the voice of your wife, and have eaten from the tree, concerning which I commanded you, saying, 'You may not eat from it,' cursed is the ground because of you; through painful work you will eat from it all the days of your life. ");
INSERT INTO engULB_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","It will produce thorns and thistles for you, and you will eat the plants of the field. ");
INSERT INTO engULB_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","By the sweat of your face you will eat bread, until you return to the ground, for out of it you were taken. For dust you are, and to dust you will return.” ");
INSERT INTO engULB_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","The man called his wife's name Eve because she was the mother of all the living. ");
INSERT INTO engULB_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Yahweh God made for Adam and for his wife garments of skins and clothed them. ");
INSERT INTO engULB_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Yahweh God said, “Now the man has become like one of us, knowing good and evil. So now he must not be allowed to reach out with his hand, take from the tree of life, eat it, and live forever.” ");
INSERT INTO engULB_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Therefore Yahweh God sent him out from the garden of Eden, to cultivate the ground from which he had been taken. ");
INSERT INTO engULB_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","So God drove the man out of the garden, and he placed cherubim at the east of the garden of Eden, and a flaming sword that turned every way, in order to guard the way to the tree of life. ");
INSERT INTO engULB_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","The man slept with Eve his wife. She conceived and gave birth to Cain. She said, “I have produced a man with Yahweh's help.” ");
INSERT INTO engULB_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Then she gave birth to his brother Abel. Now Abel became a shepherd, but Cain cultivated the soil. ");
INSERT INTO engULB_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","It came about that in the course of time Cain brought some of the fruit of the ground as an offering to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","As for Abel, he brought some of the firstborn of his flock and some of the fat. Yahweh accepted Abel and his offering, ");
INSERT INTO engULB_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","but Cain and his offering he did not accept. So Cain was very angry, and he scowled. ");
INSERT INTO engULB_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yahweh said to Cain, “Why are you angry and why are you scowling? ");
INSERT INTO engULB_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","If you do what is right, will you not be accepted? But if you do not do what is right, sin crouches at the door and desires to control you, but you must rule over it.” ");
INSERT INTO engULB_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Cain spoke to Abel his brother. It came about that while they were in the fields, Cain rose up against Abel his brother and killed him. ");
INSERT INTO engULB_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Then Yahweh said to Cain, “Where is Abel your brother?” He said, “I do not know. Am I my brother's keeper?” ");
INSERT INTO engULB_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Yahweh said, “What have you done? Your brother's blood is calling out to me from the ground. ");
INSERT INTO engULB_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Now cursed are you from the ground, which has opened its mouth to receive your brother's blood from your hand. ");
INSERT INTO engULB_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","When you cultivate the ground, from now on it will not yield to you its strength. A fugitive and a wanderer you will be in the earth.” ");
INSERT INTO engULB_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Cain said to Yahweh, “My punishment is greater than I can bear. ");
INSERT INTO engULB_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Indeed, you have driven me out this day from this ground, and I will be hidden from your face. I will be a fugitive and a wanderer in the earth, and whoever finds me will kill me.” ");
INSERT INTO engULB_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Yahweh said to him, “If anyone kills Cain, vengeance will be taken on him sevenfold.” Then Yahweh put a mark on Cain, so that if anyone found him, that person would not attack him. ");
INSERT INTO engULB_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","So Cain went out from the presence of Yahweh and lived in the land of Nod, on the east of Eden. ");
INSERT INTO engULB_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Cain slept with his wife and she conceived. She gave birth to Enoch. He built a city and named it after his son Enoch. ");
INSERT INTO engULB_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","To Enoch was born Irad. Irad became the father of Mehujael. Mehujael became the father of Methushael. Methushael became the father of Lamech. ");
INSERT INTO engULB_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamech took for himself two wives. The name of the one was Adah, and the name of the other was Zillah. ");
INSERT INTO engULB_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adah gave birth to Jabal. He was the father of those who lived in tents who have livestock. ");
INSERT INTO engULB_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","His brother's name was Jubal. He was the father of those who play the harp and pipe. ");
INSERT INTO engULB_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","As for Zillah, she bore Tubal-Cain, the forger of tools of bronze and iron. The sister of Tubal-Cain was Naamah. ");
INSERT INTO engULB_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamech said to his wives, “Adah and Zillah, listen to my voice; you wives of Lamech, listen to what I say. For I have killed a man for wounding me, a young man for bruising me. ");
INSERT INTO engULB_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","If Cain is avenged seven times, then Lamech will be avenged seventy-seven times.” ");
INSERT INTO engULB_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam slept with his wife again, and she bore another son. She called his name Seth and said, “God has given me another son in the place of Abel, for Cain killed him.” ");
INSERT INTO engULB_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","A son was born to Seth and he called his name Enosh. At that time people began to call on the name of Yahweh. ");
INSERT INTO engULB_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","This is the record of the descendants of Adam. On the day that God created mankind, he made them in his own likeness. ");
INSERT INTO engULB_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Male and female he created them. He blessed them and named them mankind when they were created. ");
INSERT INTO engULB_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","When Adam had lived 130 years, he became the father of a son in his own likeness, after his image, and he called his name Seth. ");
INSERT INTO engULB_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","After Adam became the father of Seth, he lived eight hundred years. He became the father of more sons and daughters. ");
INSERT INTO engULB_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam lived 930 years, and then he died. ");
INSERT INTO engULB_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","When Seth had lived 105 years, he became the father of Enosh. ");
INSERT INTO engULB_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","After he became the father of Enosh, he lived 807 years and became the father of more sons and daughters. ");
INSERT INTO engULB_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seth lived 912 years, and then he died. ");
INSERT INTO engULB_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","When Enosh had lived ninety years, he became the father of Kenan. ");
INSERT INTO engULB_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","After he became the father of Kenan, Enosh lived 815 years. He became the father of more sons and daughters. ");
INSERT INTO engULB_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enosh lived 905 years, and then he died. ");
INSERT INTO engULB_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","When Kenan had lived seventy years, he became the father of Mahalalel. ");
INSERT INTO engULB_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","After he became the father of Mahalalel, Kenan lived 840 years. He became the father of more sons and daughters. ");
INSERT INTO engULB_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan lived 910 years, and then he died. ");
INSERT INTO engULB_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","When Mahalalel had lived sixty-five years, he became the father of Jared. ");
INSERT INTO engULB_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","After he became the father of Jared, Mahalalel lived 830 years. He became the father of more sons and daughters. ");
INSERT INTO engULB_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalel lived 895 years, and then he died. ");
INSERT INTO engULB_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","When Jared had lived 162 years, he became the father of Enoch. ");
INSERT INTO engULB_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","After he became the father of Enoch, Jared lived eight hundred years. He became the father of more sons and daughters. ");
INSERT INTO engULB_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jared lived 962 years, and then he died. ");
INSERT INTO engULB_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","When Enoch had lived sixty-five years, he became the father of Methuselah. ");
INSERT INTO engULB_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enoch walked with God three hundred years after he became the father of Methuselah. He became the father of more sons and daughters. ");
INSERT INTO engULB_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enoch lived 365 years. ");
INSERT INTO engULB_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoch walked with God, and then he was gone, for God took him. ");
INSERT INTO engULB_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","When Methuselah had lived 187 years, he became the father of Lamech. ");
INSERT INTO engULB_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","After he became the father of Lamech, Methuselah lived 782 years. He became the father of more sons and daughters. ");
INSERT INTO engULB_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Methuselah lived 969 years. Then he died. ");
INSERT INTO engULB_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","When Lamech had lived 182 years, he became the father of a son. ");
INSERT INTO engULB_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","He called his name Noah, saying, “This one will give us rest from our work and from the painful labor of our hands, which we must do because of the ground that Yahweh has cursed.” ");
INSERT INTO engULB_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamech lived 595 years after he became the father of Noah. He became the father of more sons and daughters. ");
INSERT INTO engULB_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamech lived 777 years. Then he died. ");
INSERT INTO engULB_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","After Noah had lived five hundred years, he became the father of Shem, Ham, and Japheth. ");
INSERT INTO engULB_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","It came about when mankind began to multiply on the earth and daughters were born to them, ");
INSERT INTO engULB_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","that the sons of God saw that the daughters of mankind were attractive. They took for themselves wives, any of them that they chose. ");
INSERT INTO engULB_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Yahweh said, “My spirit will not remain in mankind forever, for they are flesh. They will live 120 years.” ");
INSERT INTO engULB_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Giants were on the earth in those days, and also afterward. This happened when the sons of God married daughters of men, and they had children with them. These were the mighty men of old, men of renown. ");
INSERT INTO engULB_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yahweh saw that the wickedness of mankind was great in the earth, and that every inclination of the thoughts of their hearts was only evil continually. ");
INSERT INTO engULB_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yahweh regretted that he had made mankind on the earth, and it grieved him to his heart. ");
INSERT INTO engULB_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","So Yahweh said, “I will wipe away mankind whom I have created from the surface of the earth; both mankind and the larger animals, and creeping things and birds of the heavens, for I am sorry that I have made them.” ");
INSERT INTO engULB_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","But Noah found favor in the eyes of Yahweh. ");
INSERT INTO engULB_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","These were the events concerning Noah. Noah was a righteous man, and blameless among the people of his time. Noah walked with God. ");
INSERT INTO engULB_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noah became the father of three sons: Shem, Ham, and Japheth. ");
INSERT INTO engULB_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","The earth was corrupt before God, and it was filled with violence. ");
INSERT INTO engULB_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","God saw the earth; behold, it was corrupt, for all flesh had corrupted their way upon the earth. ");
INSERT INTO engULB_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","God said to Noah, “I can see that it is time to put an end to all flesh, for the earth is filled with violence through them. Indeed, I will destroy them with the earth. ");
INSERT INTO engULB_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Make for yourself an ark of cypress wood. Make rooms in the ark, and cover it with pitch within and without. ");
INSERT INTO engULB_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","This is how you will make it: The length of the ark is to be three hundred cubits; the breadth of it is to be fifty cubits, and the height of it is to be thirty cubits. ");
INSERT INTO engULB_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Make a roof for the ark, and finish it at a cubit from the top of the side. Place a door in the side of the ark and make a lower, a second, and a third deck. ");
INSERT INTO engULB_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Listen, I am about to bring the flood of waters upon the earth, to destroy all flesh that has in it the breath of life from under heaven. Everything that is on the earth will die. ");
INSERT INTO engULB_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","But I will establish my covenant with you. You will come into the ark, you, and your sons, and your wife, and your sons' wives with you. ");
INSERT INTO engULB_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Of every living creature of all flesh, two of every kind you must bring into the ark, to keep them alive with you, both male and female. ");
INSERT INTO engULB_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Of the birds after their kind, and of the larger animals after their kind, of every creeping thing of the ground after its kind, two of every sort will come to you, to keep them alive. ");
INSERT INTO engULB_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Gather for yourself every kind of food that is eaten and store it, so that it will be food for you and for them.” ");
INSERT INTO engULB_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","So Noah did this. According to all that God commanded him, so he did. ");
INSERT INTO engULB_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yahweh said to Noah, “Come, you and all your household, into the ark, for I have seen that you are righteous before me in this generation. ");
INSERT INTO engULB_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Of every clean animal you will bring with you seven males and seven females. From the animals that are not clean, of them bring two, the male and his mate. ");
INSERT INTO engULB_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Also of the birds of the sky, bring seven males and seven females, to preserve their offspring upon the surface of all the earth. ");
INSERT INTO engULB_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","For in seven days I will cause it to rain upon the earth for forty days and forty nights. I will destroy from off the surface of the ground every living thing that I have made.” ");
INSERT INTO engULB_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noah did all that Yahweh commanded him. ");
INSERT INTO engULB_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noah was six hundred years old when the flood came upon the earth. ");
INSERT INTO engULB_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noah, his sons, his wife, and his sons' wives went into the ark together because of the waters of the flood. ");
INSERT INTO engULB_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Clean animals and unclean animals, birds, and everything that creeps upon the ground, ");
INSERT INTO engULB_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","two by two, male and female, came to Noah and went into the ark, just as God had commanded Noah. ");
INSERT INTO engULB_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","It came about that after the seven days, the waters of the flood came upon the earth. ");
INSERT INTO engULB_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","In the six hundredth year of Noah's life, in the second month, on the seventeenth day of the month, on the same day, all the fountains of the great deep burst open, and the windows of heaven were opened. ");
INSERT INTO engULB_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","The rain began and fell on the earth for forty days and forty nights. ");
INSERT INTO engULB_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","On that very same day Noah and his sons, Shem, Ham, and Japheth, and Noah's wife, and the three wives of his sons with them, entered into the ark. ");
INSERT INTO engULB_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","They entered along with each wild animal according to its kind, and each sort of livestock according to its kind, and each creeping thing that creeps upon the earth according to its kind, and every sort of bird according to its kind, each kind of creature with wings. ");
INSERT INTO engULB_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Two of all flesh in which was the breath of life came to Noah and entered into the ark. ");
INSERT INTO engULB_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","The animals that went in were male and female of all flesh; they entered in just as God had commanded him. Then Yahweh shut the door after them. ");
INSERT INTO engULB_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Then the flood came upon the earth for forty days, and the water increased and lifted the ark and raised it above the earth. ");
INSERT INTO engULB_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","The waters completely covered over the earth, and the ark floated upon the surface of the water. ");
INSERT INTO engULB_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","The waters rose greatly on the earth so that all the high mountains that were under the entire sky were covered. ");
INSERT INTO engULB_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","The waters rose fifteen cubits above the tops of the mountains. ");
INSERT INTO engULB_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","All living beings that moved upon the earth died—birds, livestock, wild animals, all the living creatures that lived in great numbers upon the earth, and all mankind. ");
INSERT INTO engULB_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","All living creatures who lived on the land, who breathed the breath of life through their noses, died. ");
INSERT INTO engULB_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","So every living thing that was on the surface of the earth was wiped out, from mankind to the larger animals, to creeping things, and to birds of the sky. They were all destroyed from the earth. Only Noah and those with him in the ark were left. ");
INSERT INTO engULB_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","The waters stayed upon the earth for a hundred and fifty days. ");
INSERT INTO engULB_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","God considered Noah, all the wild animals, and all the livestock that were with him in the ark. God made a wind blow over the earth, and the waters started going down. ");
INSERT INTO engULB_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","The fountains of the deep and the windows of heaven were closed, and it stopped raining. ");
INSERT INTO engULB_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","The flood waters went down slowly from the earth, and after the end of a hundred and fifty days the waters had gone down. ");
INSERT INTO engULB_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","The ark came to rest in the seventh month, on the seventeenth day of the month, upon the mountains of Ararat. ");
INSERT INTO engULB_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","The waters continued to go down until the tenth month. On the first day of the month, the tops of the mountains appeared. ");
INSERT INTO engULB_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","It came about after forty days that Noah opened the window of the ark which he had made. ");
INSERT INTO engULB_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","He sent out a raven and it flew back and forth until the waters were dried up from the earth. ");
INSERT INTO engULB_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Then he sent out a dove to see if the waters had gone down from the surface of the earth, ");
INSERT INTO engULB_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","but the dove found no place to rest her foot, and she returned to him in the ark, for the waters were still covering the whole earth. He reached out with his hand, and took and brought her into the ark with him. ");
INSERT INTO engULB_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","He waited another seven days and again he sent out the dove from the ark. ");
INSERT INTO engULB_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","The dove returned to him in the evening. Look! In her mouth was a freshly plucked olive leaf. So Noah knew that the waters had gone down from the earth. ");
INSERT INTO engULB_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","He waited another seven days, and sent out the dove again. She did not return again to him. ");
INSERT INTO engULB_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","It came about in the six hundred and first year, in the first month, on the first day of the month, that the waters were dried up from off the earth. Noah removed the covering of the ark, looked out, and saw that, behold, the surface of the ground was dry. ");
INSERT INTO engULB_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","In the second month, on the twenty-seventh day of the month, the earth was dry. ");
INSERT INTO engULB_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","God said to Noah, ");
INSERT INTO engULB_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Go out of the ark, you, your wife, your sons, and your sons' wives with you. ");
INSERT INTO engULB_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Take out with you every living creature of all flesh that is with you—the birds, the animals, and every creeping thing that creeps upon the earth—so that they may grow unto very large numbers of living creatures throughout the earth, be fruitful, and multiply upon the earth.” ");
INSERT INTO engULB_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","So Noah went out with his sons, his wife, and his sons' wives with him. ");
INSERT INTO engULB_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Every living creature, every creeping thing, and every bird, everything that moves on the earth, according to their families, left the ark. ");
INSERT INTO engULB_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noah built an altar to Yahweh. He took some of the clean animals and some of the clean birds, and offered burnt offerings on the altar. ");
INSERT INTO engULB_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yahweh smelled the pleasing aroma and said in his heart, “I will not again curse the ground because of mankind, even though the intentions of their hearts is evil from childhood. Nor will I again destroy everything living, as I have done. ");
INSERT INTO engULB_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","While the earth remains, seed time and harvest, cold and heat, summer and winter, and day and night will not cease.” ");
INSERT INTO engULB_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Then God blessed Noah and his sons, and said to them, “Be fruitful, multiply, and fill the earth. ");
INSERT INTO engULB_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","The fear of you and the dread of you will be upon every living animal on the earth, upon every bird of the sky, upon everything that goes low on the ground, and upon all the fish of the sea. They are given into your hand. ");
INSERT INTO engULB_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Every moving thing that lives will be food for you. Just as I gave you the green plants, I now give you everything. ");
INSERT INTO engULB_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","But you must not eat meat with its life—that is its blood—in it. ");
INSERT INTO engULB_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","But for your blood, the life that is in your blood, I will require payment. From the hand of every animal I will require it. From the hand of any man, that is, from the hand of one who has murdered his brother, I will require an accounting for the life of that man. ");
INSERT INTO engULB_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Whoever sheds man's blood, by man will his blood be shed, for it was in the image of God that he made man. ");
INSERT INTO engULB_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","As for you, be fruitful and multiply, spread throughout the earth and multiply on it.” ");
INSERT INTO engULB_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Then God spoke to Noah and to his sons with him, saying, ");
INSERT INTO engULB_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“As for me, listen! I am going to confirm my covenant with you and with your descendants after you, ");
INSERT INTO engULB_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","and with every living creature that is with you, with the birds, the livestock, and every creature of the earth with you, from all that came out of the ark, to every living creature on the earth. ");
INSERT INTO engULB_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","I hereby confirm my covenant with you, that never again will all flesh be destroyed by the waters of a flood. Never again will there be a flood to destroy the earth.” ");
INSERT INTO engULB_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","God said, “This is the sign of the covenant which I am making between me and you and every living creature that is with you, for all future generations: ");
INSERT INTO engULB_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","I have set my rainbow in the cloud, and it will be the sign of the covenant between me and the earth. ");
INSERT INTO engULB_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","It will come about when I bring a cloud over the earth and the rainbow is seen in the cloud, ");
INSERT INTO engULB_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","then I will call to mind my covenant, which is between me and you and every living creature of all flesh. The waters will never again become a flood to destroy all flesh. ");
INSERT INTO engULB_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","The rainbow will be in the clouds and I will see it, in order to remember the everlasting covenant between God and every living creature of all flesh that is on the earth.” ");
INSERT INTO engULB_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Then God said to Noah, “This is the sign of the covenant that I have confirmed between me and all flesh that is on the earth.” ");
INSERT INTO engULB_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","The sons of Noah that came out of the ark were Shem, Ham, and Japheth. Ham was the father of Canaan. ");
INSERT INTO engULB_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","These three were the sons of Noah, and from these the whole earth was populated. ");
INSERT INTO engULB_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noah began to be a farmer, and he planted a vineyard. ");
INSERT INTO engULB_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","He drank some of the wine and became drunk. He was lying uncovered in his tent. ");
INSERT INTO engULB_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Then Ham, the father of Canaan, saw the nakedness of his father and told his two brothers outside. ");
INSERT INTO engULB_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","So Shem and Japheth took a robe and laid it upon both their shoulders, and walked backwards and covered the nakedness of their father. Their faces were turned the other way, so they did not see their father's nakedness. ");
INSERT INTO engULB_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","When Noah awoke from his wine, he learned what his youngest son had done to him. ");
INSERT INTO engULB_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","So he said, “Cursed be Canaan. May he be a servant to his brothers' servants.” ");
INSERT INTO engULB_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","He also said, “May Yahweh, the God of Shem, be blessed, and may Canaan be his servant. ");
INSERT INTO engULB_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","May God extend the territory of Japheth, and let him make his home in the tents of Shem. May Canaan be his servant.” ");
INSERT INTO engULB_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","After the flood, Noah lived three hundred fifty years. ");
INSERT INTO engULB_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","All the days of Noah were nine hundred fifty years, and then he died. ");
INSERT INTO engULB_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","These were the descendants of the sons of Noah, that is, Shem, Ham, and Japheth. Sons were born to them after the flood. ");
INSERT INTO engULB_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","The sons of Japheth were Gomer, Magog, Madai, Javan, Tubal, Meshech, and Tiras. ");
INSERT INTO engULB_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","The sons of Gomer were Ashkenaz, Riphath, and Togarmah. ");
INSERT INTO engULB_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","The sons of Javan were Elishah, Tarshish, Kittim, and Dodanim. ");
INSERT INTO engULB_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","From these the coastland peoples separated and went into their lands, every one with its own language, according to their clans, by their nations. ");
INSERT INTO engULB_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","The sons of Ham were Cush, Mizraim, Put, and Canaan. ");
INSERT INTO engULB_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","The sons of Cush were Seba, Havilah, Sabtah, Raamah, and Sabteka. The sons of Raamah were Sheba and Dedan. ");
INSERT INTO engULB_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cush became the father of Nimrod, who was the first conqueror on the earth. ");
INSERT INTO engULB_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","He was a mighty hunter before Yahweh. That is why it is said, “Like Nimrod, a mighty hunter before Yahweh.” ");
INSERT INTO engULB_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","The first centers of his kingdom were Babel, Erech, Akkad, and Kalneh, in the land of Shinar. ");
INSERT INTO engULB_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Out of that land he went to Assyria and built Nineveh, Rehoboth Ir, Calah, ");
INSERT INTO engULB_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","and Resen, which was between Nineveh and Calah. It was a large city. ");
INSERT INTO engULB_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraim became the father of the Ludites, the Anamites, the Lehabites, the Naphtuhites, ");
INSERT INTO engULB_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","the Pathrusites, the Kasluhites (from whom the Philistines came), and the Caphtorites. ");
INSERT INTO engULB_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaan became the father of Sidon, his firstborn, and of Heth, ");
INSERT INTO engULB_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","also of the Jebusites, the Amorites, the Girgashites, ");
INSERT INTO engULB_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","the Hivites, the Arkites, the Sinites, ");
INSERT INTO engULB_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","the Arvadites, the Zemarites, and the Hamathites. Afterward the clans of the Canaanites spread out. ");
INSERT INTO engULB_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","The border of the Canaanites was from Sidon, in the direction of Gerar, as far as Gaza, and as one goes toward Sodom, Gomorrah, Admah, and Zeboyim, as far as Lasha. ");
INSERT INTO engULB_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","These were the sons of Ham, by their clans, by their languages, in their lands, and in their nations. ");
INSERT INTO engULB_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sons also were born to Shem, the older brother of Japheth. Shem was also the ancestor of all the people of Eber. ");
INSERT INTO engULB_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","The sons of Shem were Elam, Ashur, Arphaxad, Lud, and Aram. ");
INSERT INTO engULB_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","The sons of Aram were Uz, Hul, Gether, and Meshech. ");
INSERT INTO engULB_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arphaxad became the father of Shelah, and Shelah became the father of Eber. ");
INSERT INTO engULB_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber had two sons. The name of the one was Peleg, for in his days the earth was divided. His brother's name was Joktan. ");
INSERT INTO engULB_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan became the father of Almodad, Sheleph, Hazarmaveth, Jerah, ");
INSERT INTO engULB_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO engULB_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO engULB_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havilah, and Jobab. All these were the sons of Joktan. ");
INSERT INTO engULB_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Their territory was from Mesha, all the way to Sephar, the mountain of the east. ");
INSERT INTO engULB_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","These were the sons of Shem, according to their clans and their languages, in their lands, according to their nations. ");
INSERT INTO engULB_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","These were the clans of the sons of Noah, according to their genealogies, by their nations. From these the nations separated and went over the earth after the flood. ");
INSERT INTO engULB_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Now the whole earth used one language and had the same words. ");
INSERT INTO engULB_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","As they journeyed in the east, they found a plain in the land of Shinar and they settled there. ");
INSERT INTO engULB_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","They said to one another, “Come, let us make bricks and bake them thoroughly.” They had brick instead of stone and tar as mortar. ");
INSERT INTO engULB_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","They said, “Come, let us build ourselves a city and a tower whose top will reach to the sky, and let us make a name for ourselves. If we do not, we will be scattered across the surface of the whole earth.” ");
INSERT INTO engULB_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","So Yahweh came down to see the city and the tower which the descendants of Adam had built. ");
INSERT INTO engULB_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Yahweh said, “Look, they are one people with the same language, and they are beginning to do this! Soon nothing that they intend to do will be impossible for them. ");
INSERT INTO engULB_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Come, let us go down and confuse their language there, so that they may not understand each other.” ");
INSERT INTO engULB_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","So Yahweh scattered them from there across the surface of all the earth and they stopped building the city. ");
INSERT INTO engULB_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Therefore, its name was called Babel, because there Yahweh confused the language of the whole earth and from there Yahweh scattered them abroad over the surface of all the earth. ");
INSERT INTO engULB_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","These were the descendants of Shem. Shem was a hundred years old, and he became the father of Arphaxad two years after the flood. ");
INSERT INTO engULB_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Shem lived five hundred years after he became the father of Arphaxad. He also became the father of other sons and daughters. ");
INSERT INTO engULB_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","When Arphaxad had lived thirty-five years, he became the father of Shelah. ");
INSERT INTO engULB_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arphaxad lived 403 years after he became the father of Shelah. He also became the father of other sons and daughters. ");
INSERT INTO engULB_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","When Shelah had lived thirty years, he became the father of Eber. ");
INSERT INTO engULB_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Shelah lived 403 years after he became the father of Eber. He also became the father of other sons and daughters. ");
INSERT INTO engULB_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","When Eber had lived thirty-four years, he became the father of Peleg. ");
INSERT INTO engULB_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eber lived 430 years after he became the father of Peleg. He also became the father of other sons and daughters. ");
INSERT INTO engULB_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","When Peleg had lived thirty years, he became the father of Reu. ");
INSERT INTO engULB_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peleg lived 209 years after he became the father of Reu. He also became the father of other sons and daughters. ");
INSERT INTO engULB_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","When Reu had lived thirty-two years, he became the father of Serug. ");
INSERT INTO engULB_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Reu lived 207 years after he became the father of Serug. He also became the father of other sons and daughters. ");
INSERT INTO engULB_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","When Serug had lived thirty years, he became the father of Nahor. ");
INSERT INTO engULB_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serug lived two hundred years after he became the father of Nahor. He also became the father of other sons and daughters. ");
INSERT INTO engULB_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","When Nahor had live twenty-nine years, he became the father of Terah. ");
INSERT INTO engULB_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahor lived 119 years after he became the father of Terah. He also became the father of other sons and daughters. ");
INSERT INTO engULB_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","After Terah had lived seventy years, he became the father of Abram, Nahor, and Haran. ");
INSERT INTO engULB_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Now these were the descendants of Terah. Terah became the father of Abram, Nahor, and Haran, and Haran became the father of Lot. ");
INSERT INTO engULB_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran died in the presence of his father Terah in the land of his birth, in Ur of the Chaldeans. ");
INSERT INTO engULB_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram and Nahor took wives. The name of Abram's wife was Sarai and the name of Nahor's wife was Milkah, a daughter of Haran, who was the father of Milkah and Iskah. ");
INSERT INTO engULB_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Now Sarai was barren; she had no child. ");
INSERT INTO engULB_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah took Abram his son, Lot the son of his son Haran, and Sarai his daughter-in-law, his son Abram's wife, and together they left Ur of the Chaldeans, to go into the land of Canaan. But they came to Haran and stayed there. ");
INSERT INTO engULB_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah lived 205 years and then died in Haran. ");
INSERT INTO engULB_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Now Yahweh said to Abram, “Go from your country, and from your relatives, and from your father's household, to the land that I will show you. ");
INSERT INTO engULB_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","I will make of you a great nation, and I will bless you, and make your name great, and you will be a blessing. ");
INSERT INTO engULB_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","I will bless those who bless you, but whoever dishonors you I will curse. Through you will all the families of the earth be blessed.” ");
INSERT INTO engULB_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","So Abram went, as Yahweh had told him to do, and Lot went with him. Abram was seventy-five years old when he left Haran. ");
INSERT INTO engULB_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram took Sarai, his wife, Lot, his brother's son, all their possessions that they had accumulated, and the people that they had acquired in Haran. They left to go into the land of Canaan, and came to the land of Canaan. ");
INSERT INTO engULB_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram passed through the land as far as Shechem, to the oak of Moreh. At that time the Canaanites lived in the land. ");
INSERT INTO engULB_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yahweh appeared to Abram, and said, “To your descendants I will give this land.” So there Abram built an altar to Yahweh, who had appeared to him. ");
INSERT INTO engULB_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","From there he moved to the hill country to the east of Bethel, where he pitched his tent, with Bethel to the west and Ai to the east. There he built an altar to Yahweh and called on the name of Yahweh. ");
INSERT INTO engULB_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Then Abram continued journeying, going toward the Negev. ");
INSERT INTO engULB_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","There was a famine in the land, so Abram went down into Egypt to stay, for the famine was severe in the land. ");
INSERT INTO engULB_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","When he was about to enter into Egypt, he said to Sarai his wife, “See here, I know that you are a beautiful woman. ");
INSERT INTO engULB_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","When the Egyptians see you they will say, 'This is his wife,' and they will kill me, but they will keep you alive. ");
INSERT INTO engULB_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Say that you are my sister, so that it may be well with me because of you, and so that my life will be spared because of you.” ");
INSERT INTO engULB_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","It came about that when Abram entered into Egypt, the Egyptians saw that Sarai was very beautiful. ");
INSERT INTO engULB_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","The princes of Pharaoh saw her, and praised her to Pharaoh, and the woman was taken into Pharaoh's household. ");
INSERT INTO engULB_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Pharaoh treated Abram well for her sake, and gave him sheep, oxen, male donkeys, male servants, female servants, female donkeys, and camels. ");
INSERT INTO engULB_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Then Yahweh afflicted Pharaoh and his house with great plagues because of Sarai, Abram's wife. ");
INSERT INTO engULB_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Pharaoh summoned Abram, and said, “What is this that you have done to me? Why did you not tell me that she was your wife? ");
INSERT INTO engULB_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Why did you say, 'She is my sister,' so that I took her to be my wife? Now therefore, here is your wife. Take her, and go your way.” ");
INSERT INTO engULB_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Then Pharaoh gave orders to his men concerning him, and they sent him away, along with his wife and all that he had. ");
INSERT INTO engULB_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","So Abram went up from Egypt and went into the Negev, he, his wife, and all that he had. Lot also went with them. ");
INSERT INTO engULB_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Now Abram was very rich in animals, in silver, and in gold. ");
INSERT INTO engULB_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","He continued on his journey from the Negev to Bethel, to the place where his tent had been before, between Bethel and Ai. ");
INSERT INTO engULB_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","He went to the place where the altar was that he had built previously. Here he called on the name of Yahweh. ");
INSERT INTO engULB_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Now Lot, who was traveling with Abram, also had flocks, herds, and tents. ");
INSERT INTO engULB_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","The land was not able to support them both living close together, because their possessions were very many, so that they could not stay together. ");
INSERT INTO engULB_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Also, there was a dispute between the herdsmen of Abram's animals and the herdsmen of Lot's animals. The Canaanites and the Perizzites were living in the land at that time. ");
INSERT INTO engULB_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","So Abram said to Lot, “Let there be no strife between you and me, and between your herdsmen and my herdsmen; after all, we are family. ");
INSERT INTO engULB_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Is not the whole land before you? Go ahead and separate yourself from me. If you go to the left, then I will go to the right. Or if you go to the right, then I will go to the left.” ");
INSERT INTO engULB_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","So Lot looked around, and saw that the whole plain of the Jordan was well watered everywhere all the way to Zoar, like the garden of Yahweh, like the land of Egypt. This was before Yahweh destroyed Sodom and Gomorrah. ");
INSERT INTO engULB_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","So Lot chose for himself all the plain of the Jordan and traveled east, and the relatives separated from each other. ");
INSERT INTO engULB_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram lived in the land of Canaan, and Lot lived among the cities of the plain. He set up his tents as far away as Sodom. ");
INSERT INTO engULB_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Now the men of Sodom were very wicked sinners against Yahweh. ");
INSERT INTO engULB_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Yahweh said to Abram after Lot had departed from him, “Look from the place where you are standing to the north, south, east, and west. ");
INSERT INTO engULB_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","All this land which you see, I will give to you and to your descendants forever. ");
INSERT INTO engULB_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","I will make your descendants as abundant as the dust of the earth, so that if a man could count the dust of the earth, then your descendants could also be counted. ");
INSERT INTO engULB_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Arise, walk through the length and breadth of the land, for I will give it to you.” ");
INSERT INTO engULB_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","So Abram picked up his tent, and came and lived by the oaks of Mamre, which are in Hebron, and there built an altar to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","It came about in the days of Amraphel, king of Shinar, Arioch, king of Ellasar, Kedorlaomer, king of Elam, and Tidal, king of Goiim, ");
INSERT INTO engULB_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","that they made war against Bera, king of Sodom, Birsha, king of Gomorrah, Shinab, king of Admah, Shemeber, king of Zeboyim, and the king of Bela (also called Zoar). ");
INSERT INTO engULB_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","These latter five kings joined together in the Valley of Siddim (also called the Salt Sea). ");
INSERT INTO engULB_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Twelve years they had served Kedorlaomer, but in the thirteenth year they rebelled. ");
INSERT INTO engULB_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Then in the fourteenth year, Kedorlaomer and the kings who were with him came and attacked the Rephaim in Ashteroth Karnaim, the Zuzites in Ham, the Emites in Shaveh Kiriathaim, ");
INSERT INTO engULB_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","and the Horites in their hill country of Seir, as far as El Paran, which is near the desert. ");
INSERT INTO engULB_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Then they turned and came to En Mishpat (also called Kadesh), and defeated all the country of the Amalekites, and also the Amorites who lived in Hazezon Tamar. ");
INSERT INTO engULB_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Then the king of Sodom, the king of Gomorrah, the king of Admah, the king of Zeboyim, and the king of Bela (also called Zoar) went out and prepared for battle in the Valley of Siddim ");
INSERT INTO engULB_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","against Kedorlaomer, king of Elam, Tidal, king of Goiim, Amraphel, king of Shinar, Arioch, king of Ellasar; four kings against the five. ");
INSERT INTO engULB_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Now the Valley of Siddim was full of tar pits, and as the kings of Sodom and Gomorrah fled, they fell in there. Those who were left fled to the mountains. ");
INSERT INTO engULB_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","So the kings took all the goods of Sodom and Gomorrah and all their provisions, and went their way. ");
INSERT INTO engULB_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","When they went, they also took Lot, Abram's brother's son, who was living in Sodom, along with all his possessions. ");
INSERT INTO engULB_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","One who had escaped came and told Abram the Hebrew. He was living by the oaks that belonged to Mamre, the Amorite, who was the brother of Eshkol and Aner, who were all allies of Abram. ");
INSERT INTO engULB_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Now when Abram heard that enemies had captured his relative, he led out his 318 trained men who had been born in his house, and he pursued them as far as Dan. ");
INSERT INTO engULB_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","He divided his men against them at night and attacked them, and pursued them as far as Hobah, which is north of Damascus. ");
INSERT INTO engULB_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Then he brought back all the possessions, and also brought back his relative Lot and his goods, as well as the women and the other people. ");
INSERT INTO engULB_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","After Abram returned from defeating Kedorlaomer and the kings who were with him, the king of Sodom went out to meet him at the Valley of Shaveh (also called the King's Valley). ");
INSERT INTO engULB_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melchizedek, king of Salem, brought out bread and wine. He was priest of God Most High. ");
INSERT INTO engULB_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","He blessed him saying, “Blessed be Abram by God Most High, Creator of heaven and earth. ");
INSERT INTO engULB_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Blessed be God Most High, who has given your enemies into your hand.” Then Abram gave him a tenth of everything. ");
INSERT INTO engULB_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","The king of Sodom said to Abram, “Give me the people, and take the goods for yourself.” ");
INSERT INTO engULB_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram said to the king of Sodom, “I have lifted up my hand to Yahweh, God Most High, Creator of heaven and earth, ");
INSERT INTO engULB_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","that I will not take a thread, a sandal strap, or anything that is yours, so that you can never say, 'I have made Abram rich.' ");
INSERT INTO engULB_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","I will take nothing except what the young men have eaten and the share of the men that went with me. Let Aner, Eshkol, and Mamre take their portion.” ");
INSERT INTO engULB_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","After these things the word of Yahweh came to Abram in a vision, saying, “Fear not, Abram! I am your shield and your very great reward.” ");
INSERT INTO engULB_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram said, “Lord Yahweh, what will you give me, since I continue childless, and the heir of my house is Eliezer of Damascus?” ");
INSERT INTO engULB_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram said, “Since you have given me no descendant, see, the steward of my house is my heir.” ");
INSERT INTO engULB_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Then, behold, the word of Yahweh came to him, saying, “This man will not be your heir; but rather the one who will come from your own body will be your heir.” ");
INSERT INTO engULB_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Then he brought him outside, and said, “Look toward heaven, and number the stars, if you are able to number them.” Then he said to him, “So will your descendants be.” ");
INSERT INTO engULB_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","He believed Yahweh, and he counted it to him as righteousness. ");
INSERT INTO engULB_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","He said to him, “I am Yahweh, who brought you out of Ur of the Chaldeans, to give you this land to inherit it.” ");
INSERT INTO engULB_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","He said, “Lord Yahweh, how will I know that I will inherit it?” ");
INSERT INTO engULB_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Then he said to him, “Bring me a heifer three years old, a female goat three years old, a ram three years old, a dove, and a young pigeon.” ");
INSERT INTO engULB_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","He brought him all these, and cut them in two, and placed each half opposite the other, but he did not divide the birds. ");
INSERT INTO engULB_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","When the birds of prey came down upon the carcasses, Abram drove them away. ");
INSERT INTO engULB_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Then when the sun was going down, Abram fell sound asleep and, behold, a deep and terrifying darkness overwhelmed him. ");
INSERT INTO engULB_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Then Yahweh said to Abram, “Know for certain that your descendants will be strangers in a land that is not theirs, and will be enslaved and oppressed for four hundred years. ");
INSERT INTO engULB_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","I will judge that nation that they will serve, and afterward they will come out with abundant possessions. ");
INSERT INTO engULB_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","But you will go to your fathers in peace, and you will be buried in a good old age. ");
INSERT INTO engULB_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","In the fourth generation they will come here again, for the iniquity of the Amorites has not yet reached its limit.” ");
INSERT INTO engULB_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","When the sun had gone down and it was dark, behold, a smoking fire pot and a flaming torch passed between the pieces. ");
INSERT INTO engULB_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","On that day Yahweh made a covenant with Abram, saying, “To your descendants I hereby give this land, from the river of Egypt to the great river, the Euphrates— ");
INSERT INTO engULB_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","the Kenites, the Kenizzites, the Kadmonites, ");
INSERT INTO engULB_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","the Hittites, the Perizzites, the Rephaites, ");
INSERT INTO engULB_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","the Amorites, the Canaanites, the Girgashites, and the Jebusites.” ");
INSERT INTO engULB_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Now Sarai, Abram's wife, had not borne any children for him, but she had a female servant, an Egyptian, whose name was Hagar. ");
INSERT INTO engULB_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","So Sarai said to Abram, “See, Yahweh has kept me from having children. Go sleep with my servant. It may be that I will have children by her.” Abram listened to the voice of Sarai. ");
INSERT INTO engULB_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","It was after Abram had lived ten years in the land of Canaan that Sarai, Abram's wife, gave Hagar, her Egyptian servant, to her husband as a wife. ");
INSERT INTO engULB_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","So he had relations with Hagar, and she conceived. When she saw that she had conceived, she looked with contempt on her mistress. ");
INSERT INTO engULB_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Then Sarai said to Abram, “This wrong on me is because of you. I gave my servant woman into your embrace, and when she saw that she had conceived, I was despised in her eyes. Let Yahweh judge between me and you.” ");
INSERT INTO engULB_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","But Abram said to Sarai, “See here, your servant woman is in your power, do to her what you think best.” So Sarai dealt harshly with her, and she fled from her. ");
INSERT INTO engULB_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","The angel of Yahweh found her by a spring of water in the wilderness, the spring that is on the way to Shur. ");
INSERT INTO engULB_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","He said, “Hagar, Sarai's servant, where did you come from and where are you going?” Then she said, “I am fleeing from my mistress Sarai.” ");
INSERT INTO engULB_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","The angel of Yahweh said to her, “Return to your mistress, and submit yourself to her authority.” ");
INSERT INTO engULB_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Then the angel of Yahweh said to her, “I will greatly multiply your descendants, so that they will be too numerous to count.” ");
INSERT INTO engULB_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","The angel of Yahweh also said to her, “Behold, you are pregnant and will bear a son, and you will call his name Ishmael, because Yahweh has heard your affliction. ");
INSERT INTO engULB_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","He will be a wild donkey of a man. He will be hostile against every man, and every man will be hostile to him, and he will live apart from all his brothers.” ");
INSERT INTO engULB_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Then she gave this name to Yahweh who spoke to her, “You are the God who sees me,” for she said, “Do I really continue to see, even after he has seen me?” ");
INSERT INTO engULB_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Therefore the well was called Beer Lahai Roi; behold, it is between Kadesh and Bered. ");
INSERT INTO engULB_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagar gave birth to Abram's son, and Abram named his son, whom Hagar bore, Ishmael. ");
INSERT INTO engULB_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram was eighty-six years old when Hagar bore Ishmael to Abram. ");
INSERT INTO engULB_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","When Abram was ninety-nine years old, Yahweh appeared to Abram and said to him, “I am God Almighty. Walk before me, and be blameless. ");
INSERT INTO engULB_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Then I will confirm my covenant between me and you, and will multiply you exceedingly.” ");
INSERT INTO engULB_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram bowed low with his face to the ground and God talked with him, saying, ");
INSERT INTO engULB_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“As for me, behold, my covenant is with you. You will be the father of a multitude of nations. ");
INSERT INTO engULB_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","No longer will your name be Abram, but your name will be Abraham—for I appoint you to be the father of a multitude of nations. ");
INSERT INTO engULB_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","I will make you exceedingly fruitful, and I will make nations of you, and kings will descend from you. ");
INSERT INTO engULB_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","I will establish my covenant between me and you and your descendants after you, throughout their generations for an everlasting covenant, to be God to you and to your descendants after you. ");
INSERT INTO engULB_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","I will give to you, and to your descendants after you, the land where you have been living, all the land of Canaan, for an everlasting possession, and I will be their God.” ");
INSERT INTO engULB_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Then God said to Abraham, “As for you, you must keep my covenant, you and your descendants after you throughout their generations. ");
INSERT INTO engULB_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","This is my covenant, which you must keep, between me and you and your descendants after you: Every male among you must be circumcised. ");
INSERT INTO engULB_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","You must be circumcised in the flesh of your foreskin, and this will be the sign of the covenant between me and you. ");
INSERT INTO engULB_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Every male among you that is eight days old must be circumcised, throughout your people's generations. This includes him who is born into your household and him who is bought with money from any foreigner who is not one of your descendants. ");
INSERT INTO engULB_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","He who is born into your household and he who is bought with your money must be circumcised. Thus my covenant will be in your flesh for an everlasting covenant. ");
INSERT INTO engULB_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Any uncircumcised male who is not circumcised in the flesh of his foreskin will be cut off from his people. He has broken my covenant.” ");
INSERT INTO engULB_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","God said to Abraham, “As for Sarai your wife, do not call her Sarai any more. Instead, her name will be Sarah. ");
INSERT INTO engULB_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","I will bless her, and I will give you a son by her. I will bless her, and she will become the mother of nations. Kings of peoples will come from her.” ");
INSERT INTO engULB_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Then Abraham bowed low with his face to the ground, and laughed, and said in his heart, “Can a child be born to a man who is a hundred years old? How can Sarah, who is ninety years old, bear a son?” ");
INSERT INTO engULB_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abraham said to God, “Oh that Ishmael might live before you!” ");
INSERT INTO engULB_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","God said, “No, but Sarah your wife will bear you a son, and you must name him Isaac. I will establish my covenant with him as an everlasting covenant with his descendants after him. ");
INSERT INTO engULB_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","As for Ishmael, I have heard you. Behold, I hereby bless him, and will make him fruitful, and will multiply him abundantly. He will be the father of twelve leaders of tribes, and I will make him become a great nation. ");
INSERT INTO engULB_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","But my covenant I will establish with Isaac, whom Sarah will bear to you at this time in the next year.” ");
INSERT INTO engULB_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","When he had finished talking with him, God went up from Abraham. ");
INSERT INTO engULB_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Then Abraham took Ishmael his son, and all those who were born into his household, and all those who were bought with his money, every male among the men of Abraham's household, and circumcised the flesh of their foreskin in that same day, as God had said to him. ");
INSERT INTO engULB_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham was ninety-nine years old when he was circumcised in the flesh of his foreskin. ");
INSERT INTO engULB_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ishmael his son was thirteen years old when he was circumcised in the flesh of his foreskin. ");
INSERT INTO engULB_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","On the very same day Abraham and Ishmael his son were both circumcised. ");
INSERT INTO engULB_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","All the men of his household were circumcised with him, including those born into the household and those bought with money from a foreigner. ");
INSERT INTO engULB_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Yahweh appeared to Abraham by the oaks of Mamre, as he sat in the tent doorway in the heat of the day. ");
INSERT INTO engULB_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","He looked up and, behold, he saw three men standing across from him. When he saw them, he ran to meet them from the tent door and bowed low to the ground. ");
INSERT INTO engULB_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","He said, “Lord, if I have found favor in your eyes, do not pass by and leave your servant. ");
INSERT INTO engULB_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Let a little water be brought, wash your feet, and rest yourselves under the tree. ");
INSERT INTO engULB_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Let me bring a little food, so that you may refresh yourselves. Afterwards you can go your way, since you have come to your servant.” They replied, “Do as you have said.” ");
INSERT INTO engULB_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Then Abraham quickly went into the tent to Sarah, and said, “Hurry, get three seahs of fine flour, knead it, and make bread.” ");
INSERT INTO engULB_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Then Abraham ran to the herd, and took a calf that was tender and good, and gave it to the servant, and he hurried to prepare it. ");
INSERT INTO engULB_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","He took curds and milk, and the calf that had been prepared, and placed the food before them, and he stood by them under the tree while they ate. ");
INSERT INTO engULB_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","They said to him, “Where is Sarah your wife?” He replied, “There, in the tent.” ");
INSERT INTO engULB_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","He said, “I will certainly return to you in the springtime, and see, Sarah your wife will have a son.” Sarah was listening in the tent doorway, which was behind him. ");
INSERT INTO engULB_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Now Abraham and Sarah were old, very advanced in age, and Sarah had passed the age when women could bear children. ");
INSERT INTO engULB_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","So Sarah laughed to herself, saying to herself, “After I am worn-out and my master is old, will I now have this pleasure?” ");
INSERT INTO engULB_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Yahweh said to Abraham, “Why did Sarah laugh and say, 'Will I really bear a child, when I am old'? ");
INSERT INTO engULB_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Is anything too hard for Yahweh? At the time appointed by me, in the spring, I will return to you. About this time next year Sarah will have a son.” ");
INSERT INTO engULB_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Then Sarah denied it and said, “I did not laugh,” for she was afraid. He replied, “No, you did laugh.” ");
INSERT INTO engULB_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Then the men arose to leave and looked down toward Sodom. Abraham went with them to see them on their way. ");
INSERT INTO engULB_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","But Yahweh said, “Should I hide from Abraham what I am about to do, ");
INSERT INTO engULB_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","since Abraham will indeed become a great and mighty nation, and all the nations of the earth will be blessed in him? ");
INSERT INTO engULB_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","For I have chosen him so that he may instruct his children and his household after him to keep the way of Yahweh, to do righteousness and justice, so that Yahweh may bring upon Abraham what he has said to him.” ");
INSERT INTO engULB_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Then Yahweh said, “Because the outcry against Sodom and Gomorrah is so great, and because their sin is so serious, ");
INSERT INTO engULB_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","I will now go down there and see the outcry against her that has come to me, whether they have really done it. If not, I will know.” ");
INSERT INTO engULB_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","So the men turned from there, and went toward Sodom, but Abraham remained standing before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Then Abraham approached and said, “Will you sweep away the righteous with the wicked? ");
INSERT INTO engULB_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Perhaps there are fifty righteous within the city. Will you sweep it away and not spare the place for the sake of the fifty righteous that are there? ");
INSERT INTO engULB_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Far be it from you to do such a thing, killing the righteous with the wicked, so that the righteous should be treated the same as the wicked. Far be it from you! Will not the Judge of all the earth do what is just?” ");
INSERT INTO engULB_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yahweh said, “If I find in Sodom fifty righteous within the city, then I will spare the whole place for their sake.” ");
INSERT INTO engULB_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham answered and said, “Look, I have undertaken to speak to my Lord, even though I am only dust and ashes! ");
INSERT INTO engULB_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","What if there are five less than fifty righteous? Will you destroy the whole city for lack of five?” Then he said, “I will not destroy it, if I find there forty-five.” ");
INSERT INTO engULB_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","He spoke to him yet again, and said, “What if there are forty found there?” He replied, “I will not do it for the forty's sake.” ");
INSERT INTO engULB_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","He said, “Please do not be angry, Lord, so I may speak. Perhaps thirty will be found there.” He replied, “I will not do it, if I find thirty there.” ");
INSERT INTO engULB_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","He said, “Look, I have undertaken to speak to my Lord! Perhaps twenty will be found there.” He replied, “I will not destroy it for the twenty's sake.” ");
INSERT INTO engULB_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","He said, “Please do not be angry, Lord, and I will speak this one last time. Perhaps ten will be found there.” Then he said, “I will not destroy it for the ten's sake.” ");
INSERT INTO engULB_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Yahweh went on his way as soon as he had finished talking with Abraham, and Abraham returned home. ");
INSERT INTO engULB_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","The two angels came to Sodom in the evening, while Lot was sitting at the gate of Sodom. Lot saw them, arose to meet them, and bowed down with his face to the ground. ");
INSERT INTO engULB_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","He said, “Please my masters, I urge you to turn aside into your servant's house, stay for the night, and wash your feet. Then you can rise up early and go on your way.” They replied, “No, we will spend the night in the town square.” ");
INSERT INTO engULB_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","But he urged them strongly, so they went with him, and entered into his house. He prepared a meal and baked unleavened bread, and they ate. ");
INSERT INTO engULB_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","But before they lay down, the men of the city, the men of Sodom, surrounded the house, both young and old, all the men from every part of the city. ");
INSERT INTO engULB_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","They called to Lot, and said to him, “Where are the men that came in to you tonight? Bring them out to us, that we may sleep with them.” ");
INSERT INTO engULB_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","So Lot went out the door to them and shut the door after himself. ");
INSERT INTO engULB_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","He said, “I beg you, my brothers, do not act so wickedly. ");
INSERT INTO engULB_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Look, I have two daughters who have not slept with any man. Let me, I beg you, bring them out to you, and you do to them whatever is good in your eyes. Only do nothing to these men, because they have come under the shadow of my roof.” ");
INSERT INTO engULB_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","They said, “Stand back!” They also said, “This one came here to live as a foreigner, and now he has become our judge! Now we will deal worse with you than with them.” They pressed hard against the man, against Lot, and came near to break down the door. ");
INSERT INTO engULB_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","But the men reached out their hands and brought Lot into the house with them and shut the door. ");
INSERT INTO engULB_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Then Lot's visitors struck with blindness the men who were outside the door of the house, both young and old, so that they became exhausted when they were trying to find the door. ");
INSERT INTO engULB_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Then the men said to Lot, “Do you have anyone else here? Any sons-in-law, your sons and your daughters, and whoever you have in the city, get them out of here. ");
INSERT INTO engULB_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","For we are about to destroy this place, because the accusations against it before Yahweh have become so loud that he has sent us to destroy it.” ");
INSERT INTO engULB_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot went out and spoke to his sons-in-law, the men who had promised to marry his daughters, and said, “Quick, get out of this place, for Yahweh is about to destroy the city.” But to his sons-in-law he seemed to be joking. ");
INSERT INTO engULB_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","When the morning dawned, the angels urged Lot, saying, “Get going, take your wife and your two daughters that are here, so you are not swept away in the punishment of the city.” ");
INSERT INTO engULB_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","But he lingered. So the men grabbed his hand, and the hand of his wife, and the hands of his two daughters, because Yahweh was merciful to him. They brought them out, and set them outside the city. ");
INSERT INTO engULB_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","When they had brought them out, one of the men said, “Run for your lives! Do not look back, or stay anywhere on the plain. Escape to the mountains so you are not swept away.” ");
INSERT INTO engULB_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lot said to them, “No, please, my masters! ");
INSERT INTO engULB_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Your servant has found favor in your eyes, and you have shown me great kindness in saving my life, but I cannot escape to the mountains, because the disaster will overtake me, and I will die. ");
INSERT INTO engULB_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Look, that city over there is near enough to flee to, and it is a little one. Please, let me escape there (is it not a little one?), and my life will be saved.” ");
INSERT INTO engULB_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","He said to him, “Alright, I am granting this request also, that I will not destroy the city which you have mentioned. ");
INSERT INTO engULB_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Hurry! Escape there, for I cannot do anything until you arrive there.” Therefore the city was called Zoar. ");
INSERT INTO engULB_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","The sun had risen upon the earth when Lot reached Zoar. ");
INSERT INTO engULB_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Then Yahweh rained down upon Sodom and Gomorrah sulfur and fire from Yahweh out of the sky. ");
INSERT INTO engULB_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","He destroyed those cities, and all the plain, and all the inhabitants of the cities, and the plants that grew on the ground. ");
INSERT INTO engULB_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","But Lot's wife, who was behind him, looked back, and she became a pillar of salt. ");
INSERT INTO engULB_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abraham got up early in the morning and went to the place where he had stood before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","He looked down toward Sodom and Gomorrah and toward all the land of the plain. He looked and behold, smoke was rising from the land like the smoke of a furnace. ");
INSERT INTO engULB_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","So when God destroyed the cities of the plain, God called Abraham to mind. He sent Lot out of the midst of the destruction when he destroyed the cities in which Lot had lived. ");
INSERT INTO engULB_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","But Lot went up from Zoar to live in the mountains with his two daughters, because he was afraid to live in Zoar. So he lived in a cave, he and his two daughters. ");
INSERT INTO engULB_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","The firstborn said to the younger, “Our father is old, and there is no man anywhere to sleep with us according to the way of all the world. ");
INSERT INTO engULB_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Come, let us make our father drink wine, and we will sleep with him, so that we may extend our father's line.” ");
INSERT INTO engULB_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","So they made their father drink wine that night. Then the firstborn went in and slept with her father; he did not know when she lay down, nor when she arose. ");
INSERT INTO engULB_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","The next day the firstborn said to the younger, “Listen, last night I slept with my father. Let us make him drink wine tonight also, and you should go in and sleep with him, so that we may extend our father's line.” ");
INSERT INTO engULB_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","So they made their father drink wine that night also, and the younger went and slept with him. He did not know when she lay down, nor when she arose. ");
INSERT INTO engULB_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","So both the daughters of Lot were pregnant by their father. ");
INSERT INTO engULB_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","The firstborn gave birth to a son, and named him Moab. He became the ancestor of the Moabites of today. ");
INSERT INTO engULB_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","As for the younger daughter, she also gave birth to a son, and named him Ben-Ammi. He became the ancestor of the people of Ammon of today. ");
INSERT INTO engULB_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham journeyed from there toward the land of the Negev, and lived between Kadesh and Shur. He was a foreigner living in Gerar. ");
INSERT INTO engULB_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham said concerning Sarah his wife, “She is my sister.” So Abimelech king of Gerar sent for Sarah and took her. ");
INSERT INTO engULB_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","But God came to Abimelech in a dream in the night, and said to him, “Behold, you are a dead man because of the woman whom you have taken, for she is a man's wife.” ");
INSERT INTO engULB_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Now Abimelech had not come near her and he said, “Lord, would you kill even a righteous nation? ");
INSERT INTO engULB_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Did he not himself say to me, 'She is my sister?' Even she herself said, 'He is my brother.' I have done this in the integrity of my heart and the innocence of my hands.” ");
INSERT INTO engULB_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Then God said to him in the dream, “Yes, I also know that in the integrity of your heart you did this, and I also kept you from sinning against me. Therefore I did not allow you to touch her. ");
INSERT INTO engULB_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Therefore, return the man's wife, for he is a prophet. He will pray for you, and you will live. But if you do not restore her, know that you and all who are yours will surely die.” ");
INSERT INTO engULB_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimelech rose early in the morning and called all of his servants to himself. He told all these things to them, and the men were very afraid. ");
INSERT INTO engULB_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Then Abimelech called for Abraham and said to him, “What have you done to us? How have I sinned against you, that you have brought on me and on my kingdom a great sin? You have done to me that which ought not to be done.” ");
INSERT INTO engULB_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelech said to Abraham, “What prompted you to do this thing?” ");
INSERT INTO engULB_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham said, “Because I thought, 'Surely there is no fear of God in this place, and they will kill me because of my wife.' ");
INSERT INTO engULB_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Besides, she is indeed my sister, the daughter of my father, but not the daughter of my mother; and she became my wife. ");
INSERT INTO engULB_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","When God caused me to leave my father's house and travel from place to place, I said to her, 'You must show me this faithfulness as my wife: At every place where we go, say about me, “He is my brother.”'” ");
INSERT INTO engULB_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Then Abimelech took sheep and oxen, and male and female slaves, and gave them to Abraham. Then he returned Sarah, Abraham's wife, to him. ");
INSERT INTO engULB_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelech said, “Look, my land is before you. Settle wherever it pleases you.” ");
INSERT INTO engULB_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","To Sarah he said, “Look, I have given your brother a thousand pieces of silver. It is to cover any offense against you in the eyes of all that are with you, and before everyone, you are completely made right.” ");
INSERT INTO engULB_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Then Abraham prayed to God, and God healed Abimelech, his wife, and his female slaves so that they were able to have children. ");
INSERT INTO engULB_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","For Yahweh had caused all the women of the household of Abimelech to be completely infertile, because of Sarah, Abraham's wife. ");
INSERT INTO engULB_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yahweh paid attention to Sarah as he had said he would, and Yahweh did for Sarah just as he had promised. ");
INSERT INTO engULB_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sarah conceived and bore a son to Abraham in his old age, at the set time of which God had spoken to him. ");
INSERT INTO engULB_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham named his son, the one who had been born to him, whom Sarah bore to him, Isaac. ");
INSERT INTO engULB_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abraham circumcised his son Isaac when he was eight days old, just as God had commanded him. ");
INSERT INTO engULB_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham was one hundred years old when his son Isaac was born to him. ");
INSERT INTO engULB_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarah said, “God has made me laugh; every one who hears will laugh with me.” ");
INSERT INTO engULB_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","She also said, “Who would have said to Abraham that Sarah would nurse children, and yet I have borne him a son in his old age!” ");
INSERT INTO engULB_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","The child grew and was weaned, and Abraham made a great feast on the day that Isaac was weaned. ");
INSERT INTO engULB_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sarah saw the son of Hagar the Egyptian, whom she had borne to Abraham, mocking. ");
INSERT INTO engULB_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","So she said to Abraham, “Drive out this slave woman and her son, for the son of this slave woman will not be heir with my son, with Isaac.” ");
INSERT INTO engULB_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","This thing was very grievous to Abraham because of his son. ");
INSERT INTO engULB_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","But God said to Abraham, “Do not be grieved because of the lad, and because of your servant woman. Listen to her words in all she says to you about this matter, because it is through Isaac that your descendants will be named. ");
INSERT INTO engULB_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","I will also make the son of the servant woman into a nation, because he is your descendant.” ");
INSERT INTO engULB_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abraham rose up early in the morning, took bread and a skin of water, and gave it to Hagar, putting it on her shoulder. He gave her the boy and sent her away. She departed and wandered in the wilderness of Beersheba. ");
INSERT INTO engULB_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","When the water in the waterskin was gone, she abandoned the child under one of the bushes. ");
INSERT INTO engULB_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Then she went, and sat down a short distance from him, about the distance of a bowshot away, for she said, “Let me not look upon the death of the child.” As she sat there across from him, she lifted up her voice and wept. ");
INSERT INTO engULB_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","God heard the voice of the lad, and the angel of God called to Hagar out of heaven, and said to her, “What troubles you, Hagar? Do not be afraid, for God has heard the voice of the lad where he is. ");
INSERT INTO engULB_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Get up, raise up the lad, and encourage him; for I will make him into a great nation.” ");
INSERT INTO engULB_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Then God opened her eyes, and she saw a well of water. She went and filled the skin with water, and gave the lad a drink. ");
INSERT INTO engULB_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","God was with the lad, and he grew. He lived in the wilderness and became an archer. ");
INSERT INTO engULB_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","He lived in the wilderness of Paran, and his mother got a wife for him from the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","It came about at that time that Abimelech and Phicol the captain of his army spoke to Abraham, saying, “God is with you in all that you do. ");
INSERT INTO engULB_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Now therefore swear to me here by God that you will not deal falsely with me, nor with my offspring, nor with my descendants. Show to me and to the land in which you have been staying the same covenant faithfulness that I have shown to you.” ");
INSERT INTO engULB_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham said, “I swear.” ");
INSERT INTO engULB_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Abraham also complained to Abimelech concerning a well of water that Abimelech's servants had seized from him. ");
INSERT INTO engULB_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelech said, “I do not know who has done this thing. You did not tell me before now; I have not heard of it until today.” ");
INSERT INTO engULB_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","So Abraham took sheep and oxen and gave them to Abimelech, and the two men made a covenant. ");
INSERT INTO engULB_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Then Abraham set seven female lambs of the flock by themselves. ");
INSERT INTO engULB_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelech said to Abraham, “What is the meaning of these seven female lambs that you have set by themselves?” ");
INSERT INTO engULB_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","He replied, “These seven female lambs you will receive from my hand, so that it may be a witness for me, that I dug this well.” ");
INSERT INTO engULB_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","So he called that place Beersheba, because there they both swore an oath. ");
INSERT INTO engULB_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","They made a covenant at Beersheba, and then Abimelech and Phicol, the captain of his army, returned to the land of the Philistines. ");
INSERT INTO engULB_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham planted a tamarisk tree in Beersheba. There he worshiped Yahweh, the eternal God. ");
INSERT INTO engULB_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham remained as a foreigner in the land of the Philistines many days. ");
INSERT INTO engULB_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","It came about after these things that God tested Abraham. He said to him, “Abraham!” Abraham said, “Here I am.” ");
INSERT INTO engULB_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Then God said, “Take your son, your only son, whom you love, Isaac, and go to the land of Moriah. Offer him there as a burnt offering upon one of the mountains there, which I will tell you about.” ");
INSERT INTO engULB_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","So Abraham rose early in the morning, saddled his donkey, and took two of his young men with him, along with Isaac his son. He cut the wood for the burnt offering, then set out on his journey to the place that God had told him about. ");
INSERT INTO engULB_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","On the third day Abraham looked up and saw the place afar off. ");
INSERT INTO engULB_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abraham said to his young men, “Stay here with the donkey, and I and the lad will go over there. We will worship and come again to you.” ");
INSERT INTO engULB_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Then Abraham took the wood for the burnt offering and put it on Isaac his son. He took in his own hand the fire and the knife; and they went both of them together. ");
INSERT INTO engULB_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaac spoke to Abraham his father and said, “My father,” and he said, “Here I am, my son.” He said, “See, here is the fire and the wood, but where is the lamb for the burnt offering?” ");
INSERT INTO engULB_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham said, “God himself will provide the lamb for the burnt offering, my son.” So they went on, both of them together. ");
INSERT INTO engULB_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","When they came to the place that God had told him about, Abraham built an altar there and laid the wood on it. Then he bound Isaac his son, and laid him on the altar, on top of the wood. ");
INSERT INTO engULB_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abraham reached out with his hand and took up the knife to kill his son. ");
INSERT INTO engULB_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Then the angel of Yahweh called to him from heaven and said, “Abraham, Abraham!” and he said, “Here I am.” ");
INSERT INTO engULB_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","He said, “Do not lay your hand upon the lad, nor do anything to harm him, for now I know that you fear God, seeing that you have not withheld your son, your only son, from me.” ");
INSERT INTO engULB_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham looked up and behold, behind him was a ram caught in the bushes by his horns. Abraham went and took the ram and offered him up as a burnt offering instead of his son. ");
INSERT INTO engULB_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","So Abraham called that place, “Yahweh will provide,” and it is said to this day, “On the mountain of Yahweh it will be provided.” ");
INSERT INTO engULB_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","The angel of Yahweh called to Abraham a second time from heaven ");
INSERT INTO engULB_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","and said—this is Yahweh's declaration—by myself I have sworn that because you have done this thing, and have not withheld your son, your only son, ");
INSERT INTO engULB_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","I will surely bless you and I will greatly multiply your descendants as the stars of the heavens, and as the sand which is upon the seashore; and your descendants will possess the gate of their enemies. ");
INSERT INTO engULB_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Through your offspring all the nations of the earth will be blessed, because you have obeyed my voice.” ");
INSERT INTO engULB_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","So Abraham returned to his young men, and they departed and went together to Beersheba, and he lived at Beersheba. ");
INSERT INTO engULB_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","It came about after these things that Abraham was told, “Milkah has borne children, as well, to your brother Nahor.” ");
INSERT INTO engULB_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","They were Uz his firstborn, Buz his brother, Kemuel the father of Aram, ");
INSERT INTO engULB_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Hazo, Pildash, Jidlaph, and Bethuel. ");
INSERT INTO engULB_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethuel became the father of Rebekah. These were the eight children that Milkah bore to Nahor, Abraham's brother. ");
INSERT INTO engULB_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","His concubine, whose name was Reumah, also bore Tebah, Gaham, Tahash, and Maacah. ");
INSERT INTO engULB_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah lived a hundred and twenty-seven years. These were the years of the life of Sarah. ");
INSERT INTO engULB_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sarah died in Kiriath Arba, that is, Hebron, in the land of Canaan. Abraham mourned and wept for Sarah. ");
INSERT INTO engULB_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Then Abraham rose up and went from his dead wife, and spoke to the sons of Heth, saying, ");
INSERT INTO engULB_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“I am a foreigner among you. Please grant me a property for a burial place among you, so that I may bury my dead.” ");
INSERT INTO engULB_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","The sons of Heth answered Abraham, saying, ");
INSERT INTO engULB_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Listen to us, my master. You are a prince of God among us. Bury your dead in the choicest of our tombs. None of us will refuse you his tomb, so that you may bury your dead.” ");
INSERT INTO engULB_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham arose and bowed down to the people of the land, to the sons of Heth. ");
INSERT INTO engULB_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","He spoke to them, saying, “If you agree that I should bury my dead, then hear me and plead with Ephron son of Zohar, for me. ");
INSERT INTO engULB_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Ask him to sell me the cave of Machpelah, which he owns, which is at the end of his field. For the full price let him sell it to me publicly as a property for a burial place.” ");
INSERT INTO engULB_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Now Ephron was sitting among the sons of Heth, and Ephron the Hittite answered Abraham in the hearing of the sons of Heth, of all those who had come into the gate of his city, saying, ");
INSERT INTO engULB_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“No, my master, hear me. I give you the field, and the cave that is in it. I give it to you in the presence of the sons of my people. I give it to you to bury your dead.” ");
INSERT INTO engULB_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Then Abraham bowed himself down before the people of the land. ");
INSERT INTO engULB_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","He spoke to Ephron in the hearing of the people of the land, saying, “But if you are willing, please hear me. I will pay for the field. Take the money from me, and I will bury my dead there.” ");
INSERT INTO engULB_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ephron answered Abraham, saying, ");
INSERT INTO engULB_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Please, my master, listen to me. A piece of land worth four hundred shekels of silver, what is that between me and you? Bury your dead.” ");
INSERT INTO engULB_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham listened to Ephron and Abraham weighed out to Ephron the amount of silver that he had spoken in the hearing of the sons of Heth, four hundred shekels of silver, according to the standard measurement of the merchants. ");
INSERT INTO engULB_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","So the field of Ephron, which was in Machpelah, which was next to Mamre, that is, the field, the cave that was in it, and all the trees that were in the field and all around its border, passed ");
INSERT INTO engULB_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","to Abraham by purchase in the presence of the sons of Heth, before all those who had come into the gate of his city. ");
INSERT INTO engULB_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","After this, Abraham buried Sarah his wife in the cave of the field of Machpelah, which is next to Mamre, that is, Hebron, in the land of Canaan. ");
INSERT INTO engULB_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","So the field and the cave in it passed to Abraham as a property for a burial place from the sons of Heth. ");
INSERT INTO engULB_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Now Abraham was very old and Yahweh had blessed Abraham in all things. ");
INSERT INTO engULB_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraham said to his servant, the one who was the oldest of his household and who was in charge of all that he had, “Put your hand under my thigh ");
INSERT INTO engULB_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","and I will make you swear by Yahweh, the God of heaven and the God of the earth, that you will not get a wife for my son from the daughters of the Canaanites, among whom I make my home. ");
INSERT INTO engULB_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","But you will go to my country, and to my relatives, and get a wife for my son Isaac.” ");
INSERT INTO engULB_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","The servant said to him, “What if the woman will not be willing to follow me to this land? Must I take your son back to the land from which you came?” ");
INSERT INTO engULB_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham said to him, “Make sure that you do not take my son back there! ");
INSERT INTO engULB_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yahweh, the God of heaven, who took me from my father's house and from the land of my relatives, and who promised me with a solemn oath saying, 'To your offspring I will give this land,' he will send his angel before you, and you will get a wife for my son from there. ");
INSERT INTO engULB_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","But if the woman is not willing to follow you, then you will be free from this oath of mine. Only you are not to take my son back there.” ");
INSERT INTO engULB_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","So the servant put his hand under the thigh of Abraham his master, and swore to him concerning this matter. ");
INSERT INTO engULB_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","The servant took ten of his master's camels and departed. He also took with him all kinds of gifts from his master. He departed and went to the region of Aram Naharaim, to the city of Nahor. ");
INSERT INTO engULB_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","He made the camels kneel down outside the city by the well of water. It was evening, the time that women go out to draw water. ");
INSERT INTO engULB_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Then he said, “Yahweh, God of my master Abraham, grant me success today and show covenant faithfulness to my master Abraham. ");
INSERT INTO engULB_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Look, here I am standing by the spring of water, and the daughters of the men of the city are coming out to draw water. ");
INSERT INTO engULB_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Let it happen like this. When I say to a young woman, 'Please lower your pitcher so that I may drink,' and she says to me, 'Drink, and I will water your camels too,' then let her be the one that you have appointed for your servant Isaac. By this I will know that you have shown covenant faithfulness to my master.” ");
INSERT INTO engULB_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","It came about that even before he had finished speaking, behold, Rebekah came out with her water pitcher on her shoulder. Rebekah was born to Bethuel son of Milkah, the wife of Nahor, Abraham's brother. ");
INSERT INTO engULB_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","The young woman was very beautiful and a virgin. No man had slept with her. She went down to the spring and filled her pitcher, and came up. ");
INSERT INTO engULB_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Then the servant ran to meet her and said, “Please give me a little drink of water from your pitcher.” ");
INSERT INTO engULB_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","She said, “Drink, my master,” and she quickly let down her pitcher on her hand, and gave him a drink. ");
INSERT INTO engULB_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","When she had finished giving him a drink, she said, “I will draw water for your camels also, until they have finished drinking.” ");
INSERT INTO engULB_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","So she hurried and emptied her pitcher into the trough, then ran again to the well to draw water, and drew water for all his camels. ");
INSERT INTO engULB_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","The man watched her in silence to see whether Yahweh had prospered his journey or not. ");
INSERT INTO engULB_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","As the camels finished drinking, the man brought out a gold nose ring weighing half a shekel, and two gold bracelets for her arms weighing ten shekels, ");
INSERT INTO engULB_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","and asked, “Whose daughter are you? Tell me please, is there room in your father's house for us to spend the night?” ");
INSERT INTO engULB_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","She said to him, “I am the daughter of Bethuel son of Milkah, whom she bore to Nahor.” ");
INSERT INTO engULB_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","She also said to him, “We have plenty of both straw and feed, and also room for you to spend the night.” ");
INSERT INTO engULB_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Then the man bowed down and worshiped Yahweh. ");
INSERT INTO engULB_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","He said, “Blessed be Yahweh, the God of my master Abraham, who has not forsaken his covenant faithfulness and his trustworthiness toward my master. As for me, Yahweh has led me directly to the house of my master's relatives.” ");
INSERT INTO engULB_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Then the young woman ran and told her mother's household about all of these things. ");
INSERT INTO engULB_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Now Rebekah had a brother, and his name was Laban. Laban ran to the man who was out at the road by the spring. ");
INSERT INTO engULB_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","When he had seen the nose ring and the bracelets on his sister's arms, and when he had heard the words of Rebekah his sister, “This is what the man said to me,” he went to the man, and, behold, he was standing by the camels at the spring. ");
INSERT INTO engULB_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Then Laban said, “Come, you blessed of Yahweh. Why are you standing outside? I have prepared the house, and a place for the camels.” ");
INSERT INTO engULB_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","So the man came to the house and he unloaded the camels. The camels were given straw and feed, and water was provided to wash his feet and the feet of the men who were with him. ");
INSERT INTO engULB_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","They set food before him to eat, but he said, “I will not eat until I have said what I have to say.” So Laban said, “Speak on.” ");
INSERT INTO engULB_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","He said, “I am Abraham's servant. ");
INSERT INTO engULB_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yahweh has blessed my master very much and he has become great. He has given him flocks and herds, silver and gold, male servants and female servants, and camels and donkeys. ");
INSERT INTO engULB_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sarah, my master's wife, bore a son to my master when she was old, and he has given everything that he owns to him. ");
INSERT INTO engULB_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","My master made me swear, saying, 'You must not get a wife for my son from the daughters of the Canaanites, in whose land I make my home. ");
INSERT INTO engULB_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Instead, you must go to my father's family, and to my relatives, and get a wife for my son.' ");
INSERT INTO engULB_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","I said to my master, 'Perhaps the woman will not follow me.' ");
INSERT INTO engULB_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","But he said to me, 'Yahweh, before whom I walk, will send his angel with you and he will prosper your way, so that you will get a wife for my son from among my relatives and from my father's family line. ");
INSERT INTO engULB_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","But you will be free from my oath if you come to my relatives and they will not give her to you. Then you will be free from my oath.' ");
INSERT INTO engULB_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","So I arrived today at the spring, and said, 'O Yahweh, God of my master Abraham, please, if you do indeed intend to make my journey successful— ");
INSERT INTO engULB_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","here I am, standing by the spring of water—let the young woman who comes out to draw water, the woman to whom I say, “Please give me a little water from your pitcher to drink,” ");
INSERT INTO engULB_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","the woman who says to me, “Drink, and I will also draw water for your camels”—let her be the woman whom you, Yahweh, have chosen for my master's son.' ");
INSERT INTO engULB_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Even before I had finished speaking in my heart, behold, Rebekah came out with her pitcher on her shoulder and she went down to the spring and drew water. So I said to her, 'Please give me a drink.' ");
INSERT INTO engULB_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","She quickly lowered her pitcher from her shoulder and said, 'Drink, and I will give your camels water also.' So I drank, and she watered the camels also. ");
INSERT INTO engULB_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","I asked her and said, 'Whose daughter are you?' She said, 'The daughter of Bethuel, Nahor's son, whom Milkah bore to him.' Then I put the ring in her nose and the bracelets on her arms. ");
INSERT INTO engULB_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Then I bowed down and worshiped Yahweh, and blessed Yahweh, the God of my master Abraham, who had led me by the right way to find the daughter of my master's relative for his son. ");
INSERT INTO engULB_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Now therefore, if you are prepared to show covenant faithfulness and trustworthiness to my master, tell me. But if not, tell me, so that I may turn to the right hand or to the left.” ");
INSERT INTO engULB_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Then Laban and Bethuel answered and said, “The thing has come from Yahweh; we cannot speak to you either bad or good. ");
INSERT INTO engULB_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Look, Rebekah is before you. Take her and go, so she may be the wife of your master's son, as Yahweh has spoken.” ");
INSERT INTO engULB_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","When Abraham's servant heard their words, he bowed himself down to the ground to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","The servant brought out articles of silver and articles of gold, and clothing, and gave them to Rebekah. He also gave precious gifts to her brother and to her mother. ");
INSERT INTO engULB_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Then he and the men who were with him ate and drank. They stayed there overnight, and when they arose in the morning, he said, “Send me away to my master.” ");
INSERT INTO engULB_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Her brother and her mother said, “Let the young woman stay with us for a few more days, at least ten. After that she may go.” ");
INSERT INTO engULB_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","But he said to them, “Do not hinder me, since Yahweh has prospered my way. Send me on my way so that I may go to my master.” ");
INSERT INTO engULB_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","They said, “We will call the young woman and ask her.” ");
INSERT INTO engULB_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","So they called Rebekah and asked her, “Will you go with this man?” She replied, “I will go.” ");
INSERT INTO engULB_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","So they sent their sister Rebekah, along with her female servant, on her journey with Abraham's servant and his men. ");
INSERT INTO engULB_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","They blessed Rebekah, and said to her, “Our sister, may you be the mother of thousands of ten thousands, and may your descendants possess the gate of those who hate them.” ");
INSERT INTO engULB_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Then Rebekah arose, and she and her servant girls mounted the camels, and followed the man. Thus the servant took Rebekah, and went his way. ");
INSERT INTO engULB_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Now Isaac was living in the Negev, and had just returned from Beer Lahai Roi. ");
INSERT INTO engULB_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Isaac went out to meditate in the field in the evening. When he looked up and saw, behold, there were camels coming! ");
INSERT INTO engULB_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekah looked, and when she saw Isaac, she jumped down from the camel. ");
INSERT INTO engULB_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","She said to the servant, “Who is that man who is walking in the field to meet us?” The servant said, “It is my master.” So she took her veil, and covered herself. ");
INSERT INTO engULB_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","The servant recounted to Isaac all the things that he had done. ");
INSERT INTO engULB_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Then Isaac brought her into his mother Sarah's tent and took Rebekah, and she became his wife, and he loved her. So Isaac was comforted after his mother's death. ");
INSERT INTO engULB_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham took another wife; her name was Keturah. ");
INSERT INTO engULB_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","She bore him Zimran, Jokshan, Medan, Midian, Ishbak, and Shuah. ");
INSERT INTO engULB_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan became the father of Sheba and Dedan. The descendants of Dedan were the Assyrian people, the Letush people, and the Leum people. ");
INSERT INTO engULB_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian's sons were Ephah, Epher, Hanok, Abida, and Eldaah. All these were Keturah's descendants. ");
INSERT INTO engULB_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham gave all that he owned to Isaac. ");
INSERT INTO engULB_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","However, while he was still living, he gave gifts to the sons of his concubines and sent them to the land of the east, away from Isaac, his son. ");
INSERT INTO engULB_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","These were the days of the years of Abraham's life which he lived, 175 years. ");
INSERT INTO engULB_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abraham breathed his last and died at a good old age, an old man with a full life, and he was gathered to his people. ");
INSERT INTO engULB_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Isaac and Ishmael, his sons, buried him in the cave of Machpelah, in the field of Ephron son of Zohar the Hittite, which is near Mamre. ");
INSERT INTO engULB_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","This field Abraham had bought from the sons of Heth. Abraham was buried there with Sarah his wife. ");
INSERT INTO engULB_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","After the death of Abraham, God blessed Isaac his son, and Isaac lived near Beer Lahai Roi. ");
INSERT INTO engULB_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Now these were the descendants of Ishmael, Abraham's son, whom Hagar the Egyptian, Sarah's servant, bore to Abraham. ");
INSERT INTO engULB_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","These were the names of Ishmael's sons, according to their birth order: Nebaioth—the firstborn of Ishmael, Kedar, Adbeel, Mibsam, ");
INSERT INTO engULB_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massa, ");
INSERT INTO engULB_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Naphish, and Kedemah. ");
INSERT INTO engULB_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","These were Ishmael's sons, and these were their names, by their villages, and by their encampments; twelve princes according to their tribes. ");
INSERT INTO engULB_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","These were the years of the life of Ishmael, 137 years. He breathed his last and died, and was gathered to his people. ");
INSERT INTO engULB_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","They lived from Havilah to Ashhur, which is near Egypt, as one goes toward Assyria. They lived in hostility with each other. ");
INSERT INTO engULB_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","These were the events concerning Isaac, Abraham's son. Abraham became the father of Isaac. ");
INSERT INTO engULB_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac was forty years old when he took as his wife Rebekah, the daughter of Bethuel the Aramean of Paddan Aram, the sister of Laban the Aramean. ");
INSERT INTO engULB_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaac prayed to Yahweh for his wife because she was childless, and Yahweh answered his prayer, and Rebekah his wife conceived. ");
INSERT INTO engULB_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","The children struggled together within her, and she said, “Why is this happening to me?” She went to ask Yahweh about this. ");
INSERT INTO engULB_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yahweh said to her, “Two nations are in your womb, and two peoples will be separated from within you. One people will be stronger than the other, and the older will serve the younger.” ");
INSERT INTO engULB_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","When it was time for her to give birth, behold, there were twins in her womb. ");
INSERT INTO engULB_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","The first child came out red all over like a hairy garment. They called his name Esau. ");
INSERT INTO engULB_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","After that, his brother came out. His hand was grasping Esau's heel. He was called Jacob. Isaac was sixty years old when his wife bore them. ");
INSERT INTO engULB_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","The boys grew up, and Esau became a skillful hunter, a man of the field; but Jacob was a quiet man, who spent his time in the tents. ");
INSERT INTO engULB_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Now Isaac loved Esau because he ate the animals that he had hunted, but Rebekah loved Jacob. ");
INSERT INTO engULB_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Jacob cooked some stew. Esau came in from the field, and he was weak from hunger. ");
INSERT INTO engULB_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esau said to Jacob, “Feed me with that red stew. Please, I am exhausted!” That is why his name was called Edom. ");
INSERT INTO engULB_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacob said, “First sell me your birthright.” ");
INSERT INTO engULB_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau said, “Look, I am about to die. What good is the birthright to me?” ");
INSERT INTO engULB_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jacob said, “First swear to me,” so Esau swore an oath and in that way he sold his birthright to Jacob. ");
INSERT INTO engULB_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Jacob gave Esau bread and stew of lentils. He ate and drank, then got up and went on his way. In this manner Esau despised his birthright. ");
INSERT INTO engULB_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Now a famine happened in the land, besides the first famine that had been in the days of Abraham. Isaac went to Abimelech, king of the Philistines at Gerar. ");
INSERT INTO engULB_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Now Yahweh appeared to him and said, “Do not go down to Egypt; live in the land that I tell you to live in. ");
INSERT INTO engULB_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Stay in this very land, and I will be with you and will bless you; for to you and to your descendants, I will give all these lands, and I will fulfill the oath that I swore to Abraham your father. ");
INSERT INTO engULB_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","I will multiply your descendants like the stars of heaven, and will give to your descendants all these lands. Through your descendants all the nations of the earth will be blessed. ");
INSERT INTO engULB_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","I will do this because Abraham obeyed my voice and kept my instructions, my commandments, my statutes, and my laws.” ");
INSERT INTO engULB_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","So Isaac settled in Gerar. ");
INSERT INTO engULB_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","When the men of the place asked him about his wife, he said, “She is my sister.” He feared to say, “She is my wife,” because he thought, “The men of this place will kill me to get Rebekah, because she is so beautiful.” ");
INSERT INTO engULB_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","After Isaac had been there a long time, Abimelech king of the Philistines happened to look out of a window. He saw, behold, Isaac was caressing Rebekah, his wife. ");
INSERT INTO engULB_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelech called Isaac to him and said, “Look, certainly she is your wife. Why did you say, 'She is my sister'?” Isaac said to him, “Because I thought someone might kill me to get her.” ");
INSERT INTO engULB_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelech said, “What is this you have done to us? One of the people might easily have slept with your wife, and you would have brought guilt upon us.” ");
INSERT INTO engULB_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","So Abimelech warned all the people and said, “Whoever touches this man or his wife will surely be put to death.” ");
INSERT INTO engULB_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaac planted crops in that land and reaped in the same year a hundredfold, because Yahweh blessed him. ");
INSERT INTO engULB_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","The man became rich, and grew more and more until he became very great. ");
INSERT INTO engULB_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","He had many sheep and cattle, and a large household. The Philistines envied him. ");
INSERT INTO engULB_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Now all the wells that his father's servants had dug in the days of Abraham his father, the Philistines stopped them up by filling them with earth. ");
INSERT INTO engULB_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimelech said to Isaac, “Go away from us, for you are much mightier than we.” ");
INSERT INTO engULB_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","So Isaac departed from there and settled in the Valley of Gerar, and lived there. ");
INSERT INTO engULB_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Once again Isaac dug out the wells of water, which they had dug in the days of Abraham his father. The Philistines had stopped them up after Abraham's death. Isaac called the wells by the same names that his father had called them. ");
INSERT INTO engULB_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","When Isaac's servants dug in the valley, they found there a well of flowing water. ");
INSERT INTO engULB_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","The herdsmen of Gerar quarreled with Isaac's herdsmen, and said, “This water is ours.” So Isaac called that well “Esek,” because they had quarreled with him. ");
INSERT INTO engULB_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Then they dug another well, and they quarreled over that, too, so he gave it the name of “Sitnah.” ");
INSERT INTO engULB_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","He left there and dug yet another well, but they did not quarrel over that one. So he called it Rehoboth, and he said, “Now Yahweh has made room for us, and we will prosper in the land.” ");
INSERT INTO engULB_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Then Isaac went up from there to Beersheba. ");
INSERT INTO engULB_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Yahweh appeared to him that same night and said, “I am the God of Abraham your father. Do not fear, for I am with you and will bless you and multiply your descendants, for my servant Abraham's sake.” ");
INSERT INTO engULB_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaac built an altar there and called on the name of Yahweh. There he pitched his tent, and his servants dug a well. ");
INSERT INTO engULB_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Then Abimelech went to him from Gerar, with Ahuzzath, his friend, and Phicol, the captain of his army. ");
INSERT INTO engULB_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaac said to them, “Why are you coming to me, since you hate me and have sent me away from you?” ");
INSERT INTO engULB_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Then they said, “We have clearly seen that Yahweh has been with you. So we decided that there should be an oath between us, yes, between us and you. So let us make a covenant with you, ");
INSERT INTO engULB_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","that you will do us no harm, just as we have not harmed you, and as we have treated you well and have sent you away in peace. Indeed, you are blessed by Yahweh.” ");
INSERT INTO engULB_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","So Isaac made a feast for them, and they ate and drank. ");
INSERT INTO engULB_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","They rose early in the morning and swore an oath with each other. Then Isaac sent them away, and they left him in peace. ");
INSERT INTO engULB_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","That same day Isaac's servants came and told him about the well that they had dug. They said, “We have found water.” ");
INSERT INTO engULB_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","He called the well Shibah, so the name of that city is Beersheba to this day. ");
INSERT INTO engULB_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","When Esau was forty years old, he took a wife, Judith the daughter of Beeri the Hittite, and also Basemath the daughter of Elon the Hittite. ");
INSERT INTO engULB_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","They brought sorrow to Isaac and Rebekah. ");
INSERT INTO engULB_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","When Isaac was old and his eyes were dim so that he could not see, he called Esau, his older son, and said to him, “My son.” He said to him, “Here I am.” ");
INSERT INTO engULB_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","He said, “See here, I am old. I do not know the day of my death. ");
INSERT INTO engULB_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Therefore take your weapons, your quiver and your bow, and go out to the field and hunt game for me. ");
INSERT INTO engULB_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Make delicious food for me, the sort that I love, and bring it to me so I can eat it and bless you before I die.” ");
INSERT INTO engULB_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Now Rebekah heard it when Isaac spoke to Esau his son. Esau went to the field to hunt for game and bring it back. ");
INSERT INTO engULB_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekah spoke to Jacob her son and said, “See here, I heard your father speak to Esau your brother. He said, ");
INSERT INTO engULB_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","'Bring me game and make me delicious food, that I may eat it and bless you in the presence of Yahweh before my death.' ");
INSERT INTO engULB_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Now therefore, my son, obey my voice as I command you. ");
INSERT INTO engULB_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Go to the flock, and bring me two good young goats; and I will make delicious food from them for your father, just like he loves. ");
INSERT INTO engULB_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","You will take it to your father, so that he may eat it, so that he may bless you before his death.” ");
INSERT INTO engULB_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jacob said to Rebekah his mother, “See, Esau my brother is a hairy man, and I am a smooth man. ");
INSERT INTO engULB_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Perhaps my father will touch me, and I will seem to him as a deceiver. I will bring a curse upon me and not a blessing.” ");
INSERT INTO engULB_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","His mother said to him, “My son, let any curse fall on me. Just obey my voice, and go, bring them to me.” ");
INSERT INTO engULB_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","So Jacob went and got the young goats and brought them to his mother, and his mother made delicious food, just like his father loved. ");
INSERT INTO engULB_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rebekah took the best clothes of Esau, her older son, which were with her in the house, and put them on Jacob, her younger son. ");
INSERT INTO engULB_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","She put the skins of the young goats on his hands and on the smooth part of his neck. ");
INSERT INTO engULB_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","She put the delicious food and the bread that she had prepared into the hand of her son Jacob. ");
INSERT INTO engULB_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jacob went to his father and said, “My father.” He said, “Here I am; who are you, my son?” ");
INSERT INTO engULB_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacob said to his father, “I am Esau your firstborn; I have done as you said to me. Now sit up and eat some of my game, that you may bless me.” ");
INSERT INTO engULB_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaac said to his son, “How is it that you have found it so quickly, my son?” He said, “Because Yahweh your God brought it to me.” ");
INSERT INTO engULB_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaac said to Jacob, “Come near me, so I may touch you, my son, and learn whether you are my true son Esau or not.” ");
INSERT INTO engULB_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jacob went over to Isaac his father; and Isaac touched him and said, “The voice is Jacob's voice, but the hands are the hands of Esau.” ");
INSERT INTO engULB_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isaac did not recognize him, because his hands were hairy, like his brother Esau's hands, so Isaac blessed him. ");
INSERT INTO engULB_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","He said, “Are you really my son Esau?” He replied, “I am.” ");
INSERT INTO engULB_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isaac said, “Bring the food to me, and I will eat of your game, so that I may bless you.” Jacob brought the food to him. Isaac ate, and Jacob brought him wine, and he drank. ");
INSERT INTO engULB_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Then his father Isaac said to him, “Come near now and kiss me, my son.” ");
INSERT INTO engULB_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Jacob came near and kissed him, and he smelled the smell of his clothes and blessed him. He said, “See, the smell of my son is like the smell of a field that Yahweh has blessed. ");
INSERT INTO engULB_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","May God give you a portion of the dew of heaven, a portion of the fatness of the earth, and plenty of grain and new wine. ");
INSERT INTO engULB_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","May peoples serve you and nations bow down to you. Be master over your brothers, and may your mother's sons bow down to you. May every one who curses you be cursed; may every one who blesses you be blessed.” ");
INSERT INTO engULB_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","As soon as Isaac had finished blessing Jacob, and Jacob had scarcely gone out from the presence of Isaac his father, Esau his brother came in from his hunting. ");
INSERT INTO engULB_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","He also made delicious food and brought it to his father. He said to his father, “Father, get up and eat some of your son's game, so that you may bless me.” ");
INSERT INTO engULB_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaac his father said to him, “Who are you?” He said, “I am your son, your firstborn, Esau.” ");
INSERT INTO engULB_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaac trembled very much and said, “Who was it that hunted this game and brought it to me? I ate it all before you came, and I have blessed him. Indeed, he will be blessed.” ");
INSERT INTO engULB_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","When Esau heard the words of his father, he cried with a very great and bitter cry, and said to his father, “Bless me, me also, my father.” ");
INSERT INTO engULB_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isaac said, “Your brother came here deceitfully and has taken away your blessing.” ");
INSERT INTO engULB_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau said, “Is he not rightly named Jacob? For he has cheated me these two times. He took away my birthright, and, see, now he has taken away my blessing.” Then he said, “Have you not reserved a blessing for me?” ");
INSERT INTO engULB_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac answered and said to Esau, “Look, I have made him your master, and I have given to him all his brothers as servants, and I have given him grain and new wine. What more can I do for you, my son?” ");
INSERT INTO engULB_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau said to his father, “Have you not even one blessing for me, my father? Bless me, even me too, my father.” Esau wept loudly. ");
INSERT INTO engULB_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Isaac his father answered and said to him, “Look, the place where you live will be far from the richness of the earth, away from the dew of the sky above. ");
INSERT INTO engULB_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","By your sword you will live, and you will serve your brother. But when you rebel, you will shake his yoke from off your neck.” ");
INSERT INTO engULB_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau hated Jacob because of the blessing that his father had given him. Esau said in his heart, “The days of mourning for my father are near; after that I will kill my brother Jacob.” ");
INSERT INTO engULB_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","The words of Esau her older son were told to Rebekah. So she sent and called Jacob her younger son and said to him, “See, your brother Esau is consoling himself about you by planning to kill you. ");
INSERT INTO engULB_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Now therefore, my son, obey me and flee to Laban, my brother, in Haran. ");
INSERT INTO engULB_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Stay with him for a while, until your brother's fury subsides, ");
INSERT INTO engULB_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","until your brother's anger turns away from you, and he forgets what you have done to him. Then I will send and bring you back from there. Why should I lose you both in one day? ");
INSERT INTO engULB_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebekah said to Isaac, “I am weary of life because of the daughters of Heth. If Jacob takes one of the daughters of Heth as a wife, like these women, some of the daughters of the land, what good will my life be to me?” ");
INSERT INTO engULB_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaac called Jacob, blessed him, and commanded him, “You must not take a wife from the Canaanite women. ");
INSERT INTO engULB_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Arise, go to Paddan Aram, to the house of Bethuel your mother's father, and take a wife from there, one of the daughters of Laban, your mother's brother. ");
INSERT INTO engULB_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","May God Almighty bless you, make you fruitful and multiply you, so that you may become a multitude of peoples. ");
INSERT INTO engULB_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","May he give you the blessing of Abraham, to you, and to your descendants after you, that you may inherit the land where you have been living, which God gave to Abraham.” ");
INSERT INTO engULB_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","So Isaac sent Jacob away. Jacob went to Paddan Aram, to Laban son of Bethuel the Aramean, the brother of Rebekah, Jacob's and Esau's mother. ");
INSERT INTO engULB_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Now Esau saw that Isaac had blessed Jacob and sent him away to Paddan Aram, to take a wife from there. He also saw that Isaac had blessed him and given him a command, saying, “You must not take a wife from the women of Canaan.” ");
INSERT INTO engULB_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Esau also saw that Jacob had obeyed his father and his mother, and had gone to Paddan Aram. ");
INSERT INTO engULB_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau saw that the women of Canaan did not please Isaac his father. ");
INSERT INTO engULB_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","So he went to Ishmael, and took, besides the wives that he had, Mahalath the daughter of Ishmael, Abraham's son, the sister of Nebaioth, to be his wife. ");
INSERT INTO engULB_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob left Beersheba and went toward Haran. ");
INSERT INTO engULB_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","He came to a certain place and stayed there all night, because the sun had set. He took one of the stones in that place, put it under his head, and lay down in that place to sleep. ");
INSERT INTO engULB_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","He dreamed and saw a stairway set up on the earth. Its top reached to heaven and the angels of God were ascending and descending on it. ");
INSERT INTO engULB_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Behold, Yahweh stood above it and said, “I am Yahweh, the God of Abraham your father, and the God of Isaac. The land on which you are lying, I will give to you and to your descendants. ");
INSERT INTO engULB_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Your descendants will be like the dust of the earth, and you will spread far out to the west, to the east, to the north, and to the south. Through you and through your descendants will all the families of the earth be blessed. ");
INSERT INTO engULB_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Behold, I am with you, and I will keep you wherever you go. I will bring you into this land again; for I will not leave you. I will do all that I have promised to you.” ");
INSERT INTO engULB_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jacob awoke out of his sleep, and he said, “Surely Yahweh is in this place, and I did not know it.” ");
INSERT INTO engULB_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","He was afraid and said, “How terrifying is this place! This is none other than the house of God. This is the gate of heaven.” ");
INSERT INTO engULB_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Jacob arose early in the morning and took the stone that he had put under his head. He set it up as a pillar and poured oil upon the top of it. ");
INSERT INTO engULB_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","He called the name of that place Bethel, but the name of the city originally was Luz. ");
INSERT INTO engULB_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jacob vowed a vow, saying, “If God will be with me and will protect me on this road on which I am walking, and will give me bread to eat, and clothes to wear, ");
INSERT INTO engULB_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","so that I return safely to my father's house, then Yahweh will be my God. ");
INSERT INTO engULB_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Then this stone that I have set up as a pillar will be a sacred stone. From everything that you give me, I will surely give a tenth back to you.” ");
INSERT INTO engULB_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Then Jacob went on his journey and came to the land of the people of the east. ");
INSERT INTO engULB_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","As he looked, he saw a well in the field, and, behold, three flocks of sheep were lying there by it. For out of that well they would water the flocks, and the stone over the well's mouth was large. ");
INSERT INTO engULB_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","When all the flocks had gathered there, the shepherds would roll the stone from the well's mouth and water the sheep, and then put the stone again over the well's mouth, back in its place. ");
INSERT INTO engULB_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob said to them, “My brothers, where are you from?” They replied, “We are from Haran.” ");
INSERT INTO engULB_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","He said to them, “Do you know Laban son of Nahor?” They said, “We know him.” ");
INSERT INTO engULB_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","He said to them, “Is he well?” They said, “He is well, and, look there, Rachel his daughter is coming with the sheep.” ");
INSERT INTO engULB_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jacob said, “See, it is the middle of the day. It is not the time for the flocks to be gathered together. You should water the sheep and then go and let them graze.” ");
INSERT INTO engULB_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","They said, “We cannot water them until all the flocks are gathered together. The men will then roll the stone from the well's mouth, and we will water the sheep.” ");
INSERT INTO engULB_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","While Jacob was still speaking with them, Rachel came with her father's sheep, for she was tending them. ");
INSERT INTO engULB_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","When Jacob saw Rachel, the daughter of Laban, his mother's brother, and the sheep of Laban, his mother's brother, Jacob came over, rolled the stone from the well's mouth, and watered the flock of Laban, his mother's brother. ");
INSERT INTO engULB_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Jacob kissed Rachel and wept loudly. ");
INSERT INTO engULB_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jacob told Rachel that he was her father's relative, and that he was Rebekah's son. Then she ran and told her father. ");
INSERT INTO engULB_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","When Laban heard the news about Jacob his sister's son, he ran to meet him, embraced him, kissed him, and brought him to his house. Jacob told Laban all these things. ");
INSERT INTO engULB_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban said to him, “You are indeed my bone and my flesh.” Then Jacob stayed with him for about one month. ");
INSERT INTO engULB_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Then Laban said to Jacob, “Should you serve me for nothing because you are my relative? Tell me, what will your wages be?” ");
INSERT INTO engULB_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Now Laban had two daughters. The name of the older was Leah, and the name of the younger was Rachel. ");
INSERT INTO engULB_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leah's eyes were tender, but Rachel was beautiful in form and appearance. ");
INSERT INTO engULB_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob loved Rachel, so he said, “I will serve you seven years for Rachel, your younger daughter.” ");
INSERT INTO engULB_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban said, “It is better that I give her to you, than that I should give her to another man. Stay with me.” ");
INSERT INTO engULB_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","So Jacob served seven years for Rachel; and they seemed to him only a few days, for the love he had for her. ");
INSERT INTO engULB_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Then Jacob said to Laban, “Give me my wife, for my days have been completed—so that I may marry her!” ");
INSERT INTO engULB_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","So Laban gathered together all the men of the place and made a feast. ");
INSERT INTO engULB_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","In the evening, Laban took Leah his daughter and brought her to Jacob, who slept with her. ");
INSERT INTO engULB_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban gave his female servant Zilpah to his daughter Leah, to be her servant. ");
INSERT INTO engULB_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","In the morning, behold, it was Leah! Jacob said to Laban, “What is this you have done to me? Did I not serve you for Rachel? Why then have you tricked me?” ");
INSERT INTO engULB_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban said, “It is not our custom to give the younger daughter before the firstborn. ");
INSERT INTO engULB_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Complete the bridal week of this daughter, and we will give you the other also in return for serving me another seven years.” ");
INSERT INTO engULB_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacob did so, and completed Leah's week. Then Laban gave him Rachel his daughter as his wife also. ");
INSERT INTO engULB_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban also gave Bilhah to his daughter Rachel, to be her servant. ");
INSERT INTO engULB_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","So Jacob slept with Rachel, too, but he loved Rachel more than Leah. So Jacob served Laban for seven more years. ");
INSERT INTO engULB_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Yahweh saw that Leah was not loved, so he opened her womb, but Rachel was childless. ");
INSERT INTO engULB_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leah conceived and bore a son, and she called his name Reuben. For she said, “Because Yahweh has looked upon my affliction; surely now my husband will love me.” ");
INSERT INTO engULB_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Then she conceived again and bore a son. She said, “Because Yahweh has heard that I am unloved, he has therefore given me this son also,” and she called his name Simeon. ");
INSERT INTO engULB_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Then she conceived again and bore a son. She said, “Now this time will my husband be attached to me, because I have borne him three sons.” Therefore his name was called Levi. ");
INSERT INTO engULB_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","She conceived again and bore a son. She said, “This time I will praise Yahweh.” Therefore she called his name Judah; then she stopped having children. ");
INSERT INTO engULB_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","When Rachel saw that she bore Jacob no children, Rachel envied her sister. She said to Jacob, “Give me children, or I will die.” ");
INSERT INTO engULB_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jacob's anger burned against Rachel. He said, “Am I in the place of God, who has kept you from having children?” ");
INSERT INTO engULB_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","She said, “See, there is my servant Bilhah. Sleep with her, so she might give birth to children on my knees, and I will have children by her.” ");
INSERT INTO engULB_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","So she gave him her servant Bilhah as a wife, and Jacob slept with her. ");
INSERT INTO engULB_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhah conceived and bore Jacob a son. ");
INSERT INTO engULB_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Then Rachel said, “God has vindicated me, and he has heard my voice and given me a son.” For this reason she called his name Dan. ");
INSERT INTO engULB_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilhah, Rachel's servant, conceived again and bore Jacob a second son. ");
INSERT INTO engULB_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rachel said, “With mighty wrestlings have I wrestled with my sister and have prevailed.” She called his name Naphtali. ");
INSERT INTO engULB_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","When Leah saw that she had stopped having children, she took Zilpah, her servant, and gave her to Jacob as a wife. ");
INSERT INTO engULB_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpah, Leah's servant, bore Jacob a son. ");
INSERT INTO engULB_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leah said, “This is fortunate!” so she called his name Gad. ");
INSERT INTO engULB_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Then Zilpah, Leah's servant, bore Jacob a second son. ");
INSERT INTO engULB_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leah said, “I am happy! For the daughters will call me happy.” So she called his name Asher. ");
INSERT INTO engULB_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Reuben went in the days of wheat harvest and found mandrakes in the field. He brought them to his mother Leah. Then Rachel said to Leah, “Give me some of your son's mandrakes.” ");
INSERT INTO engULB_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leah said to her, “Is it a small matter to you, that you have taken away my husband? Do you now want to take away my son's mandrakes, too?” Rachel said, “Then he will sleep with you tonight, in exchange for your son's mandrakes.” ");
INSERT INTO engULB_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Jacob came from the field in the evening. Leah went out to meet him and said, “You must sleep with me tonight, for I have hired you with my son's mandrakes.” So Jacob slept with Leah that night. ");
INSERT INTO engULB_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","God listened to Leah, and she conceived and bore Jacob a fifth son. ");
INSERT INTO engULB_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leah said, “God has given me my wages, because I gave my servant woman to my husband.” She called his name Issachar. ");
INSERT INTO engULB_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leah conceived again and bore a sixth son to Jacob. ");
INSERT INTO engULB_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leah said, “God has given me a good gift. Now my husband will honor me, because I have borne him six sons.” She called his name Zebulun. ");
INSERT INTO engULB_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Afterwards she bore a daughter and called her name Dinah. ");
INSERT INTO engULB_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","God called Rachel to mind and listened to her. He caused her to become pregnant. ");
INSERT INTO engULB_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","She conceived and bore a son. She said, “God has taken away my shame.” ");
INSERT INTO engULB_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","She called his name Joseph, saying, “Yahweh has added to me another son.” ");
INSERT INTO engULB_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","After Rachel had borne Joseph, Jacob said to Laban, “Send me away, so that I may go to my own home and to my country. ");
INSERT INTO engULB_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Give me my wives and my children for whom I have served you, and let me go, for you know the service I have given you.” ");
INSERT INTO engULB_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban said to him, “If now I have found favor in your eyes, wait, because I have learned by using divination that Yahweh has blessed me for your sake.” ");
INSERT INTO engULB_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Then he said, “Name your wages, and I will pay them.” ");
INSERT INTO engULB_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jacob said to him, “You know how I have served you, and how your livestock have fared with me. ");
INSERT INTO engULB_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","For you had little before I came, and it has increased abundantly. Yahweh has blessed you wherever I worked. Now when will I provide for my own household also?” ");
INSERT INTO engULB_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","So Laban said, “What will I pay you?” Jacob said, “You will not give me anything. If you will do this thing for me, I will again feed your flock and keep it. ");
INSERT INTO engULB_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Let me walk through all your flock today, removing from it every speckled and spotted sheep, and every black one among the sheep, and the spotted and speckled among the goats. These will be my wages. ");
INSERT INTO engULB_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","My integrity will testify for me later on, when you come to check on my wages. Every one that is not speckled and spotted among the goats, and black among the sheep, if any are found with me, will be considered to be stolen.” ");
INSERT INTO engULB_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban said, “Agreed. Let it be according to your word.” ");
INSERT INTO engULB_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","That day Laban removed the male goats that were striped and spotted, and all the female goats that were speckled and spotted, every one that had white in it, and all the black ones among the sheep, and gave them into the hand of his sons. ");
INSERT INTO engULB_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Laban also put three days' journey between himself and Jacob. So Jacob kept tending the rest of Laban's flocks. ");
INSERT INTO engULB_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jacob took fresh cut branches of fresh poplar, and of the almond and of the plane tree, and peeled white streaks in them, and made the white inner wood appear that was in the sticks. ");
INSERT INTO engULB_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Then he set the sticks that he had peeled in front of the flocks, in front of the watering troughs where they came to drink. They conceived when they came to drink. ");
INSERT INTO engULB_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","The flocks bred in front of the sticks; and the flocks produced striped, speckled, and spotted young. ");
INSERT INTO engULB_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jacob separated out these lambs, but made the rest of them face toward the striped animals and all the black sheep in the flock of Laban. Then he separated out his flocks for himself alone and did not put them together with Laban's flocks. ");
INSERT INTO engULB_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Whenever the stronger sheep in the flock were breeding, then Jacob would lay the sticks in the watering troughs before the eyes of the flock, so that they might conceive among the sticks. ");
INSERT INTO engULB_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","But when the feebler animals in the flock came, he did not put the sticks in front of them. So the feebler animals were Laban's, and the stronger were Jacob's. ");
INSERT INTO engULB_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","The man became very prosperous. He had large flocks, female servants and male servants, and camels and donkeys. ");
INSERT INTO engULB_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Now Jacob heard the words of Laban's sons, that they said, “Jacob has taken away all that was our father's, and it is from our father's possessions that he has gotten all this wealth.” ");
INSERT INTO engULB_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jacob saw the look on Laban's face. He saw that his attitude toward him had changed. ");
INSERT INTO engULB_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Then Yahweh said to Jacob, “Return to the land of your fathers and to your relatives, and I will be with you.” ");
INSERT INTO engULB_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jacob sent and called Rachel and Leah to the field to his flock ");
INSERT INTO engULB_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","and said to them, “I see your father's attitude toward me has changed, but the God of my father has been with me. ");
INSERT INTO engULB_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","You know that it is with all my strength that I have served your father. ");
INSERT INTO engULB_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Your father has deceived me and changed my wages ten times, but God has not permitted him to hurt me. ");
INSERT INTO engULB_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","If he said, 'The speckled animals will be your wages,' then all the flock bore speckled young. If he said, 'The striped will be your wages,' then the whole flock bore striped young. ");
INSERT INTO engULB_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","In this way God has taken away the livestock of your father and given them to me. ");
INSERT INTO engULB_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Once at the time of breeding season, I saw in a dream the male goats that were mating with the flock. The male goats were striped, speckled, and spotted. ");
INSERT INTO engULB_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","The angel of God said to me in the dream, 'Jacob.' I said, 'Here I am.' ");
INSERT INTO engULB_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","He said, 'Lift up your eyes and see all the male goats that are breeding with the flock. They are striped, speckled, and spotted, for I have seen everything that Laban is doing to you. ");
INSERT INTO engULB_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","I am the God of Bethel, where you anointed a pillar, where you made a vow to me. Now rise up and leave this land and return to the land of your birth.'” ");
INSERT INTO engULB_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rachel and Leah answered and said to him, “Is there any portion or inheritance for us in our father's house? ");
INSERT INTO engULB_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Are we not treated by him as foreigners? For he has sold us and has also completely devoured our money. ");
INSERT INTO engULB_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","For all the riches that God has taken away from our father are now ours and our children's. Now then, whatever God has said to you, do it.” ");
INSERT INTO engULB_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Then Jacob arose and placed his sons and his wives upon the camels. ");
INSERT INTO engULB_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","He drove all his livestock ahead of him, along with all his property, including the livestock he had acquired in Paddan Aram. Then he set out to go to his father Isaac in the land of Canaan. ");
INSERT INTO engULB_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","When Laban had gone to shear his sheep, Rachel stole her father's household gods. ");
INSERT INTO engULB_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jacob also deceived Laban the Aramean, by not telling him that he was leaving. ");
INSERT INTO engULB_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","So he fled with all that he had and quickly passed over the River, and headed toward the hill country of Gilead. ");
INSERT INTO engULB_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","On the third day Laban was told that Jacob had fled. ");
INSERT INTO engULB_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","So he took his relatives with him and pursued him for a seven days' journey. He overtook him in the hill country of Gilead. ");
INSERT INTO engULB_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Now God came to Laban the Aramean in a dream at night and said to him, “Be careful that you speak to Jacob neither good nor bad.” ");
INSERT INTO engULB_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban overtook Jacob. Now Jacob had pitched his tent in the hill country. Laban also camped with his relatives in the hill country of Gilead. ");
INSERT INTO engULB_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban said to Jacob, “What have you done, that you deceived me and carried away my daughters like prisoners of war? ");
INSERT INTO engULB_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Why did you flee secretly and trick me and did not tell me? I would have sent you away with celebration and with songs, with tambourine and with harps. ");
INSERT INTO engULB_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","You did not allow me to kiss my grandsons and my daughters good bye. Now you have done foolishly. ");
INSERT INTO engULB_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","It is in my power to do you harm, but the God of your father spoke to me last night and said, 'Be careful that you speak to Jacob neither good nor bad.' ");
INSERT INTO engULB_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Now you have gone away because you longed to return to your father's house. But why did you steal my gods?” ");
INSERT INTO engULB_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacob answered and said to Laban, “Because I was afraid and thought that you would take your daughters from me by force I left secretly. ");
INSERT INTO engULB_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Whoever has stolen your gods will not continue to live. In the presence of our relatives, identify whatever with me is yours and take it.” For Jacob did not know that Rachel had stolen them. ");
INSERT INTO engULB_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban went into Jacob's tent, into Leah's tent, and into the tent of the two female servants, but he did not find them. He went out of Leah's tent and entered into Rachel's tent. ");
INSERT INTO engULB_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Now Rachel had taken the household gods, put them in a camel's saddle, and sat upon them. Laban searched the whole tent, but did not find them. ");
INSERT INTO engULB_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","She said to her father, “Do not be angry, my master, that I cannot stand up before you, for I am having my period.” So he searched but did not find his household gods. ");
INSERT INTO engULB_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jacob was angry and argued with Laban. He said to him, “What is my offense? What is my sin, that you have hotly pursued after me? ");
INSERT INTO engULB_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","For you have searched all my possessions. What have you found of all your household goods? Set them here before our relatives, so that they may judge between us two. ");
INSERT INTO engULB_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","For twenty years I have been with you. Your ewes and your female goats have not miscarried, nor have I eaten any rams from your flocks. ");
INSERT INTO engULB_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","What was torn by beasts I did not bring to you. Instead, I bore the loss of it. You always made me pay for every missing animal, whether stolen by day or stolen by night. ");
INSERT INTO engULB_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","There I was; in the day the heat consumed me, and the frost by night; and I went without sleep. ");
INSERT INTO engULB_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","These twenty years I have been in your household. I worked for you fourteen years for your two daughters, and six years for your flock. You have changed my wages ten times. ");
INSERT INTO engULB_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Unless the God of my father, the God of Abraham, and the one Isaac fears, had been with me, surely now you would have sent me away empty-handed. God has seen my oppression and how hard I worked, and he rebuked you last night.” ");
INSERT INTO engULB_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban answered and said to Jacob, “The daughters are my daughters, the grandchildren are my grandchildren, and the flocks are my flocks. All that you see is mine. But what can I do today to these my daughters, or to their children whom they have borne? ");
INSERT INTO engULB_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","So now, let us make a covenant, you and I, and let it be for a witness between you and me.” ");
INSERT INTO engULB_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","So Jacob took a stone and set it up as a pillar. ");
INSERT INTO engULB_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Jacob said to his relatives, “Gather stones.” So they took stones and made a pile. Then they ate there by the pile. ");
INSERT INTO engULB_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban called it Jegar Saha Dutha, but Jacob called it Galeed. ");
INSERT INTO engULB_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban said, “This pile is a witness between me and you today.” Therefore its name was called Galeed. ");
INSERT INTO engULB_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","It is also called Mizpah, because Laban said, “May Yahweh watch between you and me, when we are out of sight one from another. ");
INSERT INTO engULB_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","If you mistreat my daughters, or if you take any wives besides my daughters, although no one else is with us, see, God is witness between you and me.” ");
INSERT INTO engULB_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban said to Jacob, “Look at this pile, and look at the pillar, which I have set between you and me. ");
INSERT INTO engULB_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","This pile is a witness, and the pillar is a witness, that I will not pass beyond this pile to you, and that you will not pass beyond this pile and this pillar to me, to do harm. ");
INSERT INTO engULB_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","May the God of Abraham, and the god of Nahor, the gods of their father, judge between us.” Jacob swore by the Fear of his father Isaac. ");
INSERT INTO engULB_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Jacob offered a sacrifice on the mountain and called his relatives to eat a meal. They ate and spent the entire night on the mountain. ");
INSERT INTO engULB_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Early in the morning Laban got up, kissed his grandsons and his daughters and blessed them. Then Laban left and returned home. ");
INSERT INTO engULB_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob also went on his way, and the angels of God met him. ");
INSERT INTO engULB_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","When Jacob saw them, he said, “This is God's camp,” so he called the name of that place Mahanaim. ");
INSERT INTO engULB_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacob sent messengers on ahead of him to his brother Esau in the land of Seir, in the region of Edom. ");
INSERT INTO engULB_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","He commanded them, saying, “This is what you will say to my master Esau: This is what your servant Jacob says: 'I have been staying with Laban, and have delayed my return until now. ");
INSERT INTO engULB_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","I have oxen, donkeys, and flocks, male servants, and female servants. I have sent this message to my master, so that I may find favor in your eyes.'” ");
INSERT INTO engULB_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","The messengers returned to Jacob and said, “We went to your brother Esau. He is coming to meet you, and four hundred men are with him.” ");
INSERT INTO engULB_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Then Jacob was very afraid and upset. So he divided the people who were with him into two camps, and also the flocks, the herds, and the camels. ");
INSERT INTO engULB_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","He said, “If Esau comes to one camp and attacks it, then the camp that is left will escape.” ");
INSERT INTO engULB_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Jacob said, “God of my father Abraham, and God of my father Isaac, Yahweh, who said to me, 'Return to your country and to your kindred, and I will prosper you,' ");
INSERT INTO engULB_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","I am not worthy of all your acts of covenant faithfulness and of all the trustworthiness that you have done for your servant. For with only my staff I passed over this Jordan, and now I have become two camps. ");
INSERT INTO engULB_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Please rescue me from the hand of my brother, from the hand of Esau, for I am afraid of him, that he will come and attack me and the mothers with the children. ");
INSERT INTO engULB_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","But you said, 'I will certainly make you prosper. I will make your descendants like the sand of the sea, which cannot be numbered for their number.'” ");
INSERT INTO engULB_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jacob stayed there that night. He took some of what he had with him as a gift for Esau, his brother: ");
INSERT INTO engULB_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","two hundred female goats and twenty male goats, two hundred ewes and twenty rams, ");
INSERT INTO engULB_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","thirty milking camels and their colts, forty cows and ten bulls, twenty female donkeys and ten male donkeys. ");
INSERT INTO engULB_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","These he gave these into the hand of his servants, every herd by itself. He said to his servants, “Go on ahead of me and put a space between each of the herds.” ");
INSERT INTO engULB_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","He instructed the first servant, saying, “When Esau my brother meets you and asks you, saying, 'To whom do you belong? Where are you going? Whose animals are these that are in front of you?' ");
INSERT INTO engULB_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Then you will say, 'They are your servant Jacob's. They are a gift sent to my master Esau. See, he is also coming after us.'” ");
INSERT INTO engULB_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Jacob also gave instructions to the second group, the third, and all the men who followed the herds. He said, “You will say the same thing to Esau when you meet him. ");
INSERT INTO engULB_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","You must also say, 'Your servant Jacob is coming after us.'” For he thought, “I will appease him with the gifts that I am sending ahead of me. Then later, when I will see him, perhaps he will receive me.” ");
INSERT INTO engULB_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","So the gifts went on ahead of him. He himself stayed that night in the camp. ");
INSERT INTO engULB_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Jacob got up during the night, and he took his two wives, his two women servants, and his eleven sons. He sent them across the ford of the Jabbok. ");
INSERT INTO engULB_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","In this way he sent them across the stream along with all his possessions. ");
INSERT INTO engULB_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jacob was left alone, and a man wrestled with him until daybreak. ");
INSERT INTO engULB_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","When the man saw that he could not defeat him, he struck Jacob's hip. Jacob's hip was dislocated as he wrestled with him. ");
INSERT INTO engULB_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","The man said, “Let me go, for the dawn is breaking.” Jacob said, “I will not let you go unless you bless me.” ");
INSERT INTO engULB_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","The man said to him, “What is your name?” Jacob said, “Jacob.” ");
INSERT INTO engULB_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","The man said, “Your name will no longer be called Jacob, but Israel. For you have struggled with God and with men and have prevailed.” ");
INSERT INTO engULB_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jacob asked him, “Please tell me your name.” He said, “Why is it that you ask my name?” Then he blessed him there. ");
INSERT INTO engULB_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jacob called the name of the place Peniel for he said, “I have seen God face to face, and my life is delivered.” ");
INSERT INTO engULB_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","The sun rose on Jacob as he passed Peniel. He was limping because of his hip. ");
INSERT INTO engULB_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","That is why to this day the people of Israel do not eat the ligaments of the hip which are at the hip joint, because the man injured those ligaments while dislocating Jacob's hip. ");
INSERT INTO engULB_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jacob looked up and, behold, Esau was coming, and with him were four hundred men. Jacob divided the children among Leah, Rachel, and the two female servants. ");
INSERT INTO engULB_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Then he put the female servants and their children in front, followed by Leah and her children, and followed by Rachel and Joseph last of all. ");
INSERT INTO engULB_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","He himself went on ahead of them. He bowed toward the ground seven times, until he came near to his brother. ");
INSERT INTO engULB_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esau ran to meet him, embraced him, hugged his neck, and kissed him. Then they wept. ");
INSERT INTO engULB_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","When Esau looked up, he saw the women and the children. He said, “Who are these people with you?” Jacob said, “The children whom God has graciously given your servant.” ");
INSERT INTO engULB_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Then the female servants came forward with their children, and they bowed down. ");
INSERT INTO engULB_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Next Leah also and her children came forward and bowed down. Finally Joseph and Rachel came forward and bowed down. ");
INSERT INTO engULB_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau said, “What do you mean by all these groups that I met?” Jacob said, “To find favor in the sight of my master.” ");
INSERT INTO engULB_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esau said, “I have enough, my brother. Keep what you have for yourself.” ");
INSERT INTO engULB_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jacob said, “No, please, if I have found favor in your eyes, then accept my gift from my hand, for indeed, I have seen your face, and it is like seeing the face of God, and you have accepted me. ");
INSERT INTO engULB_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Please accept my gift that was brought to you, because God has dealt graciously with me, and because I have enough.” Thus Jacob urged him, and Esau accepted it. ");
INSERT INTO engULB_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Then Esau said, “Let us be on our way. I will go before you.” ");
INSERT INTO engULB_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jacob said to him, “My master knows that the children are young, and that the sheep and the cattle are nursing their young. If they are driven hard even one day, all the animals will die. ");
INSERT INTO engULB_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Please let my master go on ahead of his servant. I will travel more slowly, at the pace of the livestock that are before me, and at the pace of the children, until I come to my master in Seir.” ");
INSERT INTO engULB_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau said, “Let me leave with you some of my men who are with me.” But Jacob said, “Why do that? Let me find favor in the sight of my lord.” ");
INSERT INTO engULB_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","So Esau that day started on his way back to Seir. ");
INSERT INTO engULB_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jacob traveled to Succoth, built himself a house, and made shelters for his livestock. Therefore the name of the place is called Succoth. ");
INSERT INTO engULB_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","When Jacob came from Paddan Aram, he arrived safely at the city of Shechem, which is in the land of Canaan. He camped near the city. ");
INSERT INTO engULB_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Then he bought the piece of ground where he had pitched his tent from the sons of Hamor, Shechem's father, for a hundred pieces of silver. ");
INSERT INTO engULB_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","There he set up an altar and called it El Elohe Israel. ");
INSERT INTO engULB_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Now Dinah, Leah's daughter whom she bore to Jacob, went out to meet the young women of the land. ");
INSERT INTO engULB_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Shechem son of Hamor the Hivite, the prince of the land, saw her and he grabbed her, assaulted her, and slept with her. ");
INSERT INTO engULB_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","He was drawn to Dinah, the daughter of Jacob. He loved the young woman and spoke tenderly to her. ");
INSERT INTO engULB_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Shechem spoke to his father Hamor, saying, “Get this young woman for me as a wife.” ");
INSERT INTO engULB_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Now Jacob heard that he had defiled Dinah his daughter. His sons were with his livestock in the field, so Jacob held his peace until they came. ");
INSERT INTO engULB_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamor the father of Shechem went out to Jacob to speak with him. ");
INSERT INTO engULB_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","The sons of Jacob came in from the field when they heard of the matter. The men were offended. They were very angry because he had disgraced Israel by forcing himself on Jacob's daughter, for such a thing should not have been done. ");
INSERT INTO engULB_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor spoke with them, saying, “My son Shechem loves your daughter. Please give her to him as a wife. ");
INSERT INTO engULB_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Intermarry with us, give your daughters to us, and take our daughters for yourselves. ");
INSERT INTO engULB_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","You will live with us, and the land will be open to you to live and trade in, and to acquire property.” ");
INSERT INTO engULB_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Shechem said to her father and to her brothers, “Let me find favor in your eyes, and whatever you tell me I will give. ");
INSERT INTO engULB_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ask me for as great a bride price and gift as you will, and I will give whatever you say to me, but give me the young woman as a wife.” ");
INSERT INTO engULB_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","The sons of Jacob answered Shechem and Hamor his father with deceit, because Shechem had defiled Dinah their sister. ");
INSERT INTO engULB_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","They said to them, “We cannot do this thing, to give our sister to anyone who is uncircumcised; for that would be a disgrace to us. ");
INSERT INTO engULB_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Only on this condition will we agree with you: If you will become circumcised as we are, if every male among you is circumcised. ");
INSERT INTO engULB_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Then will we give our daughters to you, and we will take your daughters to ourselves, and we will live with you and become one people. ");
INSERT INTO engULB_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","But if you do not listen to us and become circumcised, then we will take our sister and we will leave.” ");
INSERT INTO engULB_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Their words pleased Hamor and his son Shechem. ");
INSERT INTO engULB_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","The young man did not delay to do what they said, because he delighted in Jacob's daughter, and because he was the most honored person in all his father's household. ");
INSERT INTO engULB_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor and Shechem his son went to the gate of their city and spoke with the men of their city, saying, ");
INSERT INTO engULB_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“These men are at peace with us, so let them live in the land and trade in it for, really, the land is large enough for them. Let us take their daughters as wives, and let us give them our daughters. ");
INSERT INTO engULB_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Only on this condition will the men agree to live with us and become one people: If every male among us is circumcised, as they are circumcised. ");
INSERT INTO engULB_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Will not their livestock and their property—all their animals be ours? So let us agree with them, and they will live among us.” ");
INSERT INTO engULB_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","All the men of the city listened to Hamor and Shechem, his son. Every male was circumcised. ");
INSERT INTO engULB_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","On the third day, when they were still in pain, two of the sons of Jacob (Simeon and Levi, Dinah's brothers), each took his sword and they attacked the city that was certain of its security, and they killed all the males. ");
INSERT INTO engULB_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","They killed Hamor and his son Shechem with the edge of the sword. They took Dinah from Shechem's house and went away. ");
INSERT INTO engULB_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","The other sons of Jacob came to the dead bodies and looted the city, because the people had defiled their sister. ");
INSERT INTO engULB_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","They took their flocks, their herds, their donkeys, and everything in the city and in the surrounding fields with ");
INSERT INTO engULB_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","all their wealth. All their children and their wives, they captured. They even took everything that was in the houses. ");
INSERT INTO engULB_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Jacob said to Simeon and Levi, “You have brought trouble on me, to make me stink to the inhabitants of the land, the Canaanites and the Perizzites. I am few in number. If they gather themselves together against me and attack me, then I will be destroyed, I and my household.” ");
INSERT INTO engULB_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","But Simeon and Levi said, “Should Shechem have dealt with our sister as with a prostitute?” ");
INSERT INTO engULB_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","God said to Jacob, “Arise, go up to Bethel, and stay there. Build an altar there to God, who appeared to you when you fled from Esau your brother.” ");
INSERT INTO engULB_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Then Jacob said to his household and to all who were with him, “Put away the foreign gods that are among you, purify yourselves, and change your clothes. ");
INSERT INTO engULB_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Then let us depart and go up to Bethel. I will build an altar there to God, who answered me in the day of my distress, and has been with me wherever I have gone.” ");
INSERT INTO engULB_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","So they gave to Jacob all the foreign gods that were in their hand, and the rings that were in their ears. Jacob buried them under the oak that was near Shechem. ");
INSERT INTO engULB_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","As they traveled, God made panic to fall on the cities that were around them, so those people did not pursue the sons of Jacob. ");
INSERT INTO engULB_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","So Jacob arrived at Luz (that is, Bethel), which is in the land of Canaan, he and all the people who were with him. ");
INSERT INTO engULB_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","He built an altar there and called the place El Bethel, because there God had revealed himself to him, when he was fleeing from his brother. ");
INSERT INTO engULB_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Deborah, Rebekah's nurse, died. She was buried down from Bethel under the oak tree, so it was called Allon Bakuth. ");
INSERT INTO engULB_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","When Jacob came from Paddan Aram, God appeared to him again and blessed him. ");
INSERT INTO engULB_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","God said to him, “Your name is Jacob, but your name will no longer be called Jacob. Your name will be Israel.” So God called his name Israel. ");
INSERT INTO engULB_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","God said to him, “I am God Almighty. Be fruitful and multiply. A nation and a company of nations will come from you, and kings will be among your descendants. ");
INSERT INTO engULB_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","The land that I gave to Abraham and Isaac, I will give to you. To your descendants after you I also give the land.” ");
INSERT INTO engULB_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","God went up from him in the place where he spoke with him. ");
INSERT INTO engULB_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jacob set up a pillar in the place where God had spoken to him, a pillar of stone. He poured out a drink offering over it and poured oil on it. ");
INSERT INTO engULB_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jacob called the name of the place where God spoke with him, Bethel. ");
INSERT INTO engULB_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","They journeyed on from Bethel. While they were still some distance from Ephrath, Rachel went into labor. She had hard labor. ");
INSERT INTO engULB_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","While she was in hardest labor, the midwife said to her, “Do not be afraid, for now you will have another son.” ");
INSERT INTO engULB_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","As she was dying, with her dying breath she named him Ben-Oni, but his father called him Benjamin. ");
INSERT INTO engULB_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rachel died and was buried on the way to Ephrath (that is, Bethlehem). ");
INSERT INTO engULB_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob set up a pillar upon her grave. It is the marker of Rachel's grave to this day. ");
INSERT INTO engULB_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israel traveled on and pitched his tent beyond the watchtower of the flock. ");
INSERT INTO engULB_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","While Israel was living in that land, Reuben slept with Bilhah his father's concubine, and Israel heard of it. Now Jacob had twelve sons. ");
INSERT INTO engULB_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","His sons by Leah were Reuben, Jacob's firstborn, and Simeon, Levi, Judah, Issachar, and Zebulun. ");
INSERT INTO engULB_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","His sons by Rachel were Joseph and Benjamin. ");
INSERT INTO engULB_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","His sons by Bilhah, Rachel's female servant, were Dan and Naphtali. ");
INSERT INTO engULB_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","The sons of Zilpah, Leah's female servant, were Gad and Asher. All these were the sons of Jacob who were born to him in Paddan Aram. ");
INSERT INTO engULB_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob came to Isaac, his father, in Mamre in Kiriath Arba (the same as Hebron), where Abraham and Isaac had lived. ");
INSERT INTO engULB_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaac lived for one hundred eighty years. ");
INSERT INTO engULB_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isaac breathed his last and died, and was gathered to his ancestors, an old man full of days. Esau and Jacob, his sons, buried him. ");
INSERT INTO engULB_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","These were the descendants of Esau (also called Edom). ");
INSERT INTO engULB_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau took his wives from the Canaanites. These were his wives: Adah the daughter of Elon the Hittite; Oholibamah the daughter of Anah, the granddaughter of Zibeon the Hivite; ");
INSERT INTO engULB_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","and Basemath, Ishmael's daughter, sister of Nebaioth. ");
INSERT INTO engULB_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adah bore Eliphaz to Esau, and Basemath bore Reuel. ");
INSERT INTO engULB_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibamah bore Jeush, Jalam, and Korah. These were the sons of Esau who were born to him in the land of Canaan. ");
INSERT INTO engULB_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau took his wives, his sons, his daughters, and all the members of his household, his livestock—all his animals, and all his possessions, which he had gathered in the land of Canaan, and went into a land away from his brother Jacob. ");
INSERT INTO engULB_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","He did this because their possessions were too many for them to stay together. The land where they had settled could not support them because of their livestock. ");
INSERT INTO engULB_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","So Esau, also known as Edom, settled in the hill country of Seir. ");
INSERT INTO engULB_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","These were the descendants of Esau, the ancestor of the Edomites in the hill country of Seir. ");
INSERT INTO engULB_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","These were the names of Esau's sons: Eliphaz son of Adah, the wife of Esau; Reuel son of Basemath, the wife of Esau. ");
INSERT INTO engULB_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","The sons of Eliphaz were Teman, Omar, Zepho, Gatam, and Kenaz. ");
INSERT INTO engULB_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna, a concubine of Eliphaz, Esau's son, bore Amalek. These were the grandsons of Adah, Esau's wife. ");
INSERT INTO engULB_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","These were the sons of Reuel: Nahath, Zerah, Shammah, and Mizzah. These were the grandsons of Basemath, Esau's wife. ");
INSERT INTO engULB_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","These were the sons of Oholibamah, Esau's wife, who was the daughter of Anah and the granddaughter of Zibeon. She bore to Esau Jeush, Jalam, and Korah. ");
INSERT INTO engULB_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","These were the clans among Esau's descendants: the descendants of Eliphaz, the firstborn of Esau: Teman, Omar, Zepho, Kenaz, ");
INSERT INTO engULB_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gatam, and Amalek. These were the clans descended from Eliphaz in the land of Edom. They were the grandsons of Adah. ");
INSERT INTO engULB_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","These were the clans from Reuel, Esau's son: Nahath, Zerah, Shammah, Mizzah. These were the clans descended from Reuel in the land of Edom. They were the grandsons of Basemath, Esau's wife. ");
INSERT INTO engULB_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","These were the clans of Oholibamah, Esau's wife: Jeush, Jalam, Korah. These are the clans that descended from Esau's wife Oholibamah, daughter of Anah. ");
INSERT INTO engULB_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","These were the sons of Esau (who was known as Edom), and these were their chiefs. ");
INSERT INTO engULB_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","These were the sons of Seir the Horite, the inhabitants of the land: Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO engULB_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, and Dishan. These were the clans of the Horites, the inhabitants of Seir in the land of Edom. ");
INSERT INTO engULB_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","The sons of Lotan were Hori and Heman, and Timna was Lotan's sister. ");
INSERT INTO engULB_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","These were the sons of Shobal: Alvan, Manahath, Ebal, Shepho, and Onam. ");
INSERT INTO engULB_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","These were the sons of Zibeon: Aiah and Anah. This is Anah who found the hot springs in the wilderness, as he was pasturing donkeys of Zibeon his father. ");
INSERT INTO engULB_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","These were the children of Anah: Dishon and Oholibamah, the daughter of Anah. ");
INSERT INTO engULB_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","These were the sons of Dishon: Hemdan, Eshban, Ithran, and Keran. ");
INSERT INTO engULB_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","These were the sons of Ezer: Bilhan, Zaavan, and Akan. ");
INSERT INTO engULB_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","These were the sons of Dishan: Uz and Aran. ");
INSERT INTO engULB_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","These were the clans of the Horites: Lotan, Shobal, Zibeon, and Anah, ");
INSERT INTO engULB_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishon, Ezer, Dishan: These were clans of the Horites, according to their clan lists in the land of Seir. ");
INSERT INTO engULB_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","These were the kings who reigned in the land of Edom before any king reigned over the Israelites: ");
INSERT INTO engULB_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela son of Beor, reigned in Edom, and the name of his city was Dinhabah. ");
INSERT INTO engULB_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","When Bela died, then Jobab son of Zerah of Bozrah, reigned in his place. ");
INSERT INTO engULB_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","When Jobab died, Husham who was of the land of the Temanites, reigned in his place. ");
INSERT INTO engULB_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","When Husham died, Hadad son of Bedad who defeated the Midianites in the land of Moab, reigned in his place. The name of his city was Avith. ");
INSERT INTO engULB_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","When Hadad died, then Samlah of Masrekah reigned in his place. ");
INSERT INTO engULB_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","When Samlah died, then Shaul of Rehoboth by the river reigned in his place. ");
INSERT INTO engULB_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","When Shaul died, then Baal-Hanan son of Akbor reigned in his place. ");
INSERT INTO engULB_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","When Baal-Hanan son of Akbor, died, then Hadar reigned in his place. The name of his city was Pau. His wife's name was Mehetabel, the daughter of Matred, the granddaughter of Me Zahab. ");
INSERT INTO engULB_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","These were the names of the heads of clans from Esau's descendants, according to their clans and their regions, by their names: Timna, Alvah, Jetheth, ");
INSERT INTO engULB_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibamah, Elah, Pinon, ");
INSERT INTO engULB_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar, ");
INSERT INTO engULB_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, and Iram. These were the clan heads of Edom, according to their settlements in the land they possessed. This was Esau, the father of the Edomites. ");
INSERT INTO engULB_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob lived in the land where his father was staying, in the land of Canaan. ");
INSERT INTO engULB_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","These were the events concerning Jacob. Joseph, who was a young man seventeen years old, was guarding the flock with his brothers. He was with the sons of Bilhah and with the sons of Zilpah, his father's wives. Joseph brought an unfavorable report about them to their father. ");
INSERT INTO engULB_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Now Israel loved Joseph more than all his sons because he was the son of his old age. He made him a beautiful garment. ");
INSERT INTO engULB_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","His brothers saw that their father loved him more than all his brothers. They hated him and would not speak kindly to him. ");
INSERT INTO engULB_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Joseph dreamed a dream, and he told his brothers about it. They hated him even more. ");
INSERT INTO engULB_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","He said to them, “Please listen to this dream which I dreamed. ");
INSERT INTO engULB_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Behold, we were tying bundles of grain in the field and behold, my bundle rose and stood upright, and behold, your bundles came around and bowed down to my bundle.” ");
INSERT INTO engULB_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","His brothers said to him, “Will you really reign over us? Will you actually rule over us?” They hated him even more for his dreams and for his words. ");
INSERT INTO engULB_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","He dreamed another dream and told it to his brothers. He said, “Look, I have dreamed another dream: The sun and the moon and eleven stars bowed down to me.” ");
INSERT INTO engULB_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","He told it to his father just as to his brothers, and his father rebuked him. He said to him, “What is this dream that you have dreamed? Will your mother and I and your brothers actually come to bow down to the ground to you?” ");
INSERT INTO engULB_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","His brothers were jealous of him, but his father kept the matter in mind. ");
INSERT INTO engULB_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","His brothers went to tend their father's flock in Shechem. ");
INSERT INTO engULB_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israel said to Joseph, “Are not your brothers tending the flock in Shechem? Come, and I will send you to them.” Joseph said to him, “I am ready.” ");
INSERT INTO engULB_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","He said to him, “Go now, see whether it is well with your brothers and well with the flock, and bring me word.” So Jacob sent him out of the Valley of Hebron, and Joseph went to Shechem. ");
INSERT INTO engULB_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","A certain man found Joseph. Behold, Joseph was wandering in a field. The man asked him, “What do you seek?” ");
INSERT INTO engULB_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Joseph said, “I am seeking my brothers. Tell me, please, where they are tending the flock.” ");
INSERT INTO engULB_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","The man said, “They left this place, for I heard them say, 'Let us go to Dothan.'” Joseph went after his brothers and found them at Dothan. ");
INSERT INTO engULB_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","They saw him from a distance, and before he came near to them, they plotted against him to kill him. ");
INSERT INTO engULB_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","His brothers said to one another, “Look, this dreamer is approaching. ");
INSERT INTO engULB_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Come now, therefore, let us kill him and cast him into one of the pits. We will say, 'A wild animal has devoured him.' We will see what will become of his dreams.” ");
INSERT INTO engULB_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Reuben heard it and rescued him from their hand. He said, “Let us not take his life.” ");
INSERT INTO engULB_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Reuben said to them, “Shed no blood. Throw him into this pit that is in the wilderness, but lay no hand upon him”—that he might rescue him out of their hand to bring him back to his father. ");
INSERT INTO engULB_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","It came about that when Joseph reached his brothers, they stripped him of his beautiful garment. ");
INSERT INTO engULB_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","They took him and threw him into the pit. The pit was empty with no water in it. ");
INSERT INTO engULB_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","They sat down to eat bread. They lifted up their eyes and looked, and, behold, a caravan of Ishmaelites was coming from Gilead, with their camels bearing spices and balm and myrrh. They were traveling to carry them down to Egypt. ");
INSERT INTO engULB_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Judah said to his brothers, “What profit is it if we kill our brother and cover up his blood? ");
INSERT INTO engULB_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Come, and let us sell him to the Ishmaelites and not lay our hands upon him. For he is our brother, our flesh.” His brothers listened to him. ");
INSERT INTO engULB_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","The Midianite merchants passed by. His brothers drew Joseph up and lifted him up out of the pit. They sold Joseph to the Ishmaelites for twenty pieces of silver. The Ishmaelites carried Joseph into Egypt. ");
INSERT INTO engULB_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Reuben returned to the pit, and, behold, Joseph was not in the pit. He tore his clothes. ");
INSERT INTO engULB_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","He returned to his brothers and said, “The boy is not there! And I, where can I go?” ");
INSERT INTO engULB_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","They slaughtered a goat and then took Joseph's garment and dipped it into the blood. ");
INSERT INTO engULB_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Then they brought it to their father and said, “We found this. Please see whether it is your son's clothing or not.” ");
INSERT INTO engULB_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jacob recognized it and said, “It is my son's clothing. A wild animal has devoured him. Joseph has certainly been torn to pieces.” ");
INSERT INTO engULB_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jacob tore his garments and put sackcloth upon his loins. He mourned for his son many days. ");
INSERT INTO engULB_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","All his sons and daughters rose up to comfort him, but he refused to be comforted. He said, “Indeed I will go down to Sheol mourning for my son.” His father wept for him. ");
INSERT INTO engULB_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","The Midianites sold him in Egypt to Potiphar, an officer of Pharaoh, the captain of the bodyguard. ");
INSERT INTO engULB_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","It came about at that time that Judah left his brothers and stayed with a certain Adullamite, whose name was Hirah. ");
INSERT INTO engULB_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","He met there a daughter of a Canaanite man whose name was Shua. He married her and slept with her. ");
INSERT INTO engULB_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","She became pregnant and had a son. He was named Er. ");
INSERT INTO engULB_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","She became pregnant again and had a son. She called his name Onan. ");
INSERT INTO engULB_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","She again had a son and called his name Shelah. It was at Kezib where she gave birth to him. ");
INSERT INTO engULB_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judah found a wife for Er, his firstborn. Her name was Tamar. ");
INSERT INTO engULB_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Er, Judah's firstborn, was wicked in the sight of Yahweh. Yahweh killed him. ");
INSERT INTO engULB_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Judah said to Onan, “Sleep with your brother's wife. Do the duty of a brother-in-law to her, and raise up a child for your brother.” ");
INSERT INTO engULB_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan knew that the child would not be his. Whenever he slept with his brother's wife, he spilled the semen on the ground so he would not have a child for his brother. ");
INSERT INTO engULB_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","What he did was evil in the sight of Yahweh. Yahweh killed him also. ");
INSERT INTO engULB_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Then Judah said to Tamar, his daughter-in-law, “Remain a widow in your father's house until Shelah, my son, grows up.” For he feared, “He might also die, just like his brothers.” Tamar left and lived in her father's house. ");
INSERT INTO engULB_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","After a long time, Shua's daughter, the wife of Judah, died. Judah was comforted and went up to his sheepshearers at Timnah, he and his friend Hirah the Adullamite. ");
INSERT INTO engULB_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamar was told, “Look, your father-in-law is going up to Timnah to shear his sheep.” ");
INSERT INTO engULB_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","She took off the clothing of her widowhood and covered herself with her veil and wrapped herself. She sat in the gate of Enaim, which is by the road to Timnah. For she saw that Shelah had grown up but she had not been given to him as a wife. ");
INSERT INTO engULB_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","When Judah saw her he thought that she was a prostitute because she had covered her face. ");
INSERT INTO engULB_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","He went to her by the road and said, “Come, please let me sleep with you”—for he did not know that she was his daughter-in-law—and she said, “What will you give me so you can sleep with me?” ");
INSERT INTO engULB_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","He said, “I will send you a young goat from the flock.” She said, “Will you give me a pledge until you send it?” ");
INSERT INTO engULB_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","He said, “What pledge can I give you?” She replied, “Your seal and cord, and the staff that is in your hand.” He gave them to her and slept with her, and she became pregnant by him. ");
INSERT INTO engULB_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","She got up and went away. She took off her veil and put on the clothing of her widowhood. ");
INSERT INTO engULB_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Judah sent the young goat by his friend the Adullamite in order that he might receive the pledge back from the woman's hand, but he did not find her. ");
INSERT INTO engULB_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Then the Adullamite asked the men of the place, “Where is the cultic prostitute who was at Enaim by the road?” They said, “There has not been a cultic prostitute here.” ");
INSERT INTO engULB_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","He returned to Judah and said, “I did not find her. Also, the men of the place said, 'There has not been a cultic prostitute here.'” ");
INSERT INTO engULB_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Judah said, “Let her keep the things, that we not be put to shame. Indeed, I sent this young goat, but you did not find her.” ");
INSERT INTO engULB_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","It came about after about three months that it was told to Judah, “Tamar your daughter-in-law has committed prostitution, and indeed, she is pregnant by it.” Judah said, “Bring her here and let her be burned.” ");
INSERT INTO engULB_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","When she was brought out, she sent to her father-in-law a message, “By the man who owns these I am pregnant.” She said, “Determine please whose these are, the seal and cords and staff.” ");
INSERT INTO engULB_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judah recognized them and said, “She is more righteous than I am, since I did not give her as a wife to Shelah, my son.” He did not sleep with her again. ");
INSERT INTO engULB_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","It came about at the time for her to give birth that, behold, twins were in her womb. ");
INSERT INTO engULB_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","It came about as she was giving birth one put out a hand, and the midwife took a scarlet thread and tied it on his hand and said, “This one came out first.” ");
INSERT INTO engULB_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","But then he drew back his hand, and, behold, his brother came out first. The midwife said, “How you have broken out!” So he was named Perez. ");
INSERT INTO engULB_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Then his brother came out, who had the scarlet thread upon his hand, and he was named Zerah. ");
INSERT INTO engULB_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Joseph was brought down to Egypt. Potiphar, an official of Pharaoh who was captain of the guard and an Egyptian, bought him from the Ishmaelites, who had brought him down there. ");
INSERT INTO engULB_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yahweh was with Joseph and he became a prosperous man. He lived in the house of his Egyptian master. ");
INSERT INTO engULB_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","His master saw that Yahweh was with him and that Yahweh prospered everything that he did. ");
INSERT INTO engULB_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Joseph found favor in his sight. He served Potiphar. Potiphar made Joseph manager over his house, and everything that he possessed, he put under his care. ");
INSERT INTO engULB_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","It came about from the time that he made him manager over his house and over everything he possessed, that Yahweh blessed the Egyptian's house because of Joseph. The blessing of Yahweh was on everything that Potiphar had in the house and in the field. ");
INSERT INTO engULB_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potiphar put everything that he had under Joseph's care. He did not have to think about anything except the food that he ate. Now Joseph was handsome and attractive. ");
INSERT INTO engULB_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","It came about after this that his master's wife lusted for Joseph. She said, “Sleep with me.” ");
INSERT INTO engULB_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","But he refused and said to his master's wife, “Look, my master does not pay attention to what I do in the house, and he has put everything that he owns under my care. ");
INSERT INTO engULB_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","No one is greater in this house than I am. He has not kept back anything from me but you, because you are his wife. How then can I do this great wickedness and sin against God?” ");
INSERT INTO engULB_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","She spoke to Joseph day after day, but he refused to sleep with her or to be with her. ");
INSERT INTO engULB_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","It came about one day that he went into the house to do his work. None of the men of the house were there in the house. ");
INSERT INTO engULB_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","She caught him by his clothes and said, “Sleep with me.” He left his clothing in her hand, fled, and went outside. ");
INSERT INTO engULB_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","It came about, when she saw that he had left his clothing in her hand and had fled outside, ");
INSERT INTO engULB_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","that she called to the men of her house and told them, “See, Potiphar has brought in a Hebrew to mock us. He came in to me to sleep with me, and I screamed. ");
INSERT INTO engULB_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","It came about when he heard me scream, that he left his clothing with me, fled, and went outside.” ");
INSERT INTO engULB_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","She set his clothing next to her until his master came home. ");
INSERT INTO engULB_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","She told him this explanation, “The Hebrew servant whom you brought to us, came in to mock me. ");
INSERT INTO engULB_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","It came about that when I screamed, he left his clothing with me and fled outside.” ");
INSERT INTO engULB_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","It came about that, when his master heard the explanation his wife told him, “This is what your servant did to me,” he became very angry. ");
INSERT INTO engULB_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Joseph's master took him and put him in prison, the place where the king's prisoners were confined. He was there in the prison. ");
INSERT INTO engULB_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","But Yahweh was with Joseph and showed covenant faithfulness to him. He gave him favor in the sight of the prison warden. ");
INSERT INTO engULB_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","The prison warden gave into Joseph's hand all the prisoners who were in the prison. Whatever they did there, Joseph was in charge of it. ");
INSERT INTO engULB_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","The prison warden did not worry about anything that was in his hand, because Yahweh was with him. Whatever he did, Yahweh prospered. ");
INSERT INTO engULB_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","It came about that after these things, the cupbearer of the king of Egypt and king's baker offended their master, the king of Egypt. ");
INSERT INTO engULB_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Pharaoh was angry with his two officials, the chief of the cupbearers and the chief of the bakers. ");
INSERT INTO engULB_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","He put them in custody in the house of the captain of the guard, in the same prison where Joseph was confined. ");
INSERT INTO engULB_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","The captain of the guard assigned Joseph to them, and he served them. They remained in custody for some time. ");
INSERT INTO engULB_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Both of them dreamed a dream—the cupbearer and the baker of the king of Egypt who were confined in the prison—each man had his own dream in the same night, and each dream had its own interpretation. ");
INSERT INTO engULB_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Joseph came to them in the morning and saw them. Behold, they were sad. ");
INSERT INTO engULB_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","He asked Pharaoh's officials who were with him in custody in his master's house, saying, “Why do you look so sad today?” ");
INSERT INTO engULB_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","They said to him, “We have both dreamed a dream and no one can interpret it.” Joseph said to them, “Do not interpretations belong to God? Tell me, please.” ");
INSERT INTO engULB_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","The chief of the cupbearers told his dream to Joseph. He said to him, “In my dream, behold, a vine was in front of me. ");
INSERT INTO engULB_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","In the vine were three branches. As it budded, its blossoms came out and the clusters of grapes ripened. ");
INSERT INTO engULB_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Pharaoh's cup was in my hand. I took the grapes and squeezed them into Pharaoh's cup, and I placed the cup into Pharaoh's hand.” ");
INSERT INTO engULB_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Joseph said to him, “This is the interpretation of it. The three branches are three days. ");
INSERT INTO engULB_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Within three days Pharaoh will lift up your head and restore you to your office. You will put Pharaoh's cup into his hand, just as when you were his cupbearer. ");
INSERT INTO engULB_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","But think of me when it goes well with you, and please show kindness to me. Mention me to Pharaoh and bring me out of this prison. ");
INSERT INTO engULB_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","For indeed I was abducted out of the land of the Hebrews. Here also have I done nothing that they should put me in this dungeon.” ");
INSERT INTO engULB_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","When the chief of the bakers saw that the interpretation was favorable, he said to Joseph, “I also had a dream, and, behold, three baskets of bread were on my head. ");
INSERT INTO engULB_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","In the top basket there were all kinds of baked goods for Pharaoh, but the birds ate them out of the basket on my head.” ");
INSERT INTO engULB_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Joseph answered and said, “This is the interpretation. The three baskets are three days. ");
INSERT INTO engULB_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Within three days Pharaoh will lift up your head from you and will hang you on a tree. The birds will eat your flesh off you.” ");
INSERT INTO engULB_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","It came about on the third day that it was Pharaoh's birthday. He made a feast for all his servants. He lifted up the head of the chief of the cupbearers and the head of the chief of the bakers, among his servants. ");
INSERT INTO engULB_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","He restored the chief of the cupbearers to his responsibility, and he put the cup into Pharaoh's hand again. ");
INSERT INTO engULB_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","But he hanged the chief of the bakers, just as Joseph had interpreted to them. ");
INSERT INTO engULB_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Yet the chief cupbearer did not remember Joseph, but forgot about him. ");
INSERT INTO engULB_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","It came about at the end of two full years that Pharaoh had a dream. Behold, he stood by the Nile. ");
INSERT INTO engULB_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Behold, seven cows came up out of the Nile, desirable and fat, and they grazed in the reeds. ");
INSERT INTO engULB_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Behold, seven other cows came up after them out of the Nile, undesirable and thin. They stood by the other cows on the bank of the river. ");
INSERT INTO engULB_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Then the undesirable and thin cows ate the seven desirable and fat cows. Then Pharaoh woke up. ");
INSERT INTO engULB_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Then he slept and dreamed a second time. Behold, seven heads of grain came up on one stalk, wholesome and good. ");
INSERT INTO engULB_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Behold, seven heads, thin and scorched by the east wind, sprouted up after them. ");
INSERT INTO engULB_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","The thin heads swallowed up the seven wholesome and full heads. Pharaoh woke up, and, behold, it was a dream. ");
INSERT INTO engULB_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","It came about in the morning that his spirit was troubled. He sent and called for all the magicians and wise men of Egypt. Pharaoh told them his dreams, but there was no one who could interpret them to Pharaoh. ");
INSERT INTO engULB_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Then the chief cupbearer said to Pharaoh, “Today I am thinking about my offenses. ");
INSERT INTO engULB_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pharaoh was angry with his servants, and put me in custody in the house of the captain of the guard, the chief baker and me. ");
INSERT INTO engULB_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","We dreamed a dream the same night, he and I. We dreamed each man according to the interpretation of his dream. ");
INSERT INTO engULB_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","There was with us there a young Hebrew man, a servant of the captain of the guard. We told him and he interpreted for us our dreams. He interpreted for each of us according to his dream. ");
INSERT INTO engULB_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","It came about as he interpreted for us, so it happened. Pharaoh restored me to my post, but the other one he hanged.” ");
INSERT INTO engULB_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Then Pharaoh sent and called for Joseph. They quickly took him out of the dungeon. He shaved himself, changed his clothes, and came in to Pharaoh. ");
INSERT INTO engULB_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pharaoh said to Joseph, “I had a dream, but there is no interpreter for it. But I have heard about you, that when you hear a dream you can interpret it.” ");
INSERT INTO engULB_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseph answered Pharaoh, saying, “It is not in me. God will answer Pharaoh with favor.” ");
INSERT INTO engULB_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Pharaoh spoke to Joseph, “In my dream, behold, I stood on the bank of the Nile. ");
INSERT INTO engULB_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Behold, seven cows came up out of the Nile, fat and desirable, and they grazed among the reeds. ");
INSERT INTO engULB_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Behold, seven other cows came up after them, weak, very undesirable, and thin. I never saw in all the land of Egypt such undesirableness like them. ");
INSERT INTO engULB_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","The thin and undesirable cows ate up the first seven fat cows. ");
INSERT INTO engULB_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","When they had eaten them up, it could not be known that they had eaten them, for they were still as undesirable as before. Then I awoke. ");
INSERT INTO engULB_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","I looked in my dream, and, behold, seven heads came up upon one stalk, full and good. ");
INSERT INTO engULB_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Behold, seven more heads—withered, thin, and scorched by the east wind—sprang up after them. ");
INSERT INTO engULB_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","The thin heads swallowed up the seven good heads. I told these dreams to the magicians, but there was none that could explain it to me.” ");
INSERT INTO engULB_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Joseph said to Pharaoh, “The dreams of Pharaoh are the same. What God is about to do, he has declared to Pharaoh. ");
INSERT INTO engULB_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","The seven good cows are seven years, and the seven good heads are seven years. The dreams are the same. ");
INSERT INTO engULB_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","The seven thin and undesirable cows that came up after them are seven years, and also the seven thin heads scorched by the east wind will be seven years of famine. ");
INSERT INTO engULB_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","That is the thing which I spoke to Pharaoh. What God is about to do he has revealed to Pharaoh. ");
INSERT INTO engULB_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Look, seven years of great abundance will come throughout all the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Seven years of famine will come after them, and all the abundance will be forgotten in the land of Egypt, and the famine will devastate the land. ");
INSERT INTO engULB_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","The abundance will not be remembered in the land because of the famine that will follow, for it will be very severe. ");
INSERT INTO engULB_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","That the dream was repeated to Pharaoh is because the matter has been established by God, and God will soon do it. ");
INSERT INTO engULB_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Now let Pharaoh look for a man discerning and wise, and put him over the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Let Pharaoh appoint officials over the land, and let them take a fifth of the crops of Egypt in the seven abundant years. ");
INSERT INTO engULB_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Let them gather all the food of these good years that are coming and store up grain under the authority of Pharaoh, for food to be used in the cities. They should preserve it. ");
INSERT INTO engULB_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","The food will be a supply for the land for the seven years of famine which will be in the land of Egypt. In this way the land will not be devastated by the famine.” ");
INSERT INTO engULB_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","This advice was good in the eyes of Pharaoh and in the eyes of all his servants. ");
INSERT INTO engULB_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Pharaoh said to his servants, “Can we find such a man as this, in whom is the Spirit of God?” ");
INSERT INTO engULB_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","So Pharaoh said to Joseph, “Since God has shown you all this, there is none so discerning and wise as you. ");
INSERT INTO engULB_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","You will be over my house, and according to your word will all my people be ruled. Only in the throne will I be greater than you.” ");
INSERT INTO engULB_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Pharaoh said to Joseph, “See, I have put you over all the land of Egypt.” ");
INSERT INTO engULB_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Pharaoh took off his signet ring from his hand and put it upon Joseph's hand. He clothed him with clothes of fine linen, and put a gold chain on his neck. ");
INSERT INTO engULB_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","He had him ride in the second chariot which he possessed. Men shouted before him, “Bend the knee.” Pharaoh put him over all the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Pharaoh said to Joseph, “I am Pharaoh, and apart from you, no man will lift his hand or his foot in all the land of Egypt.” ");
INSERT INTO engULB_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Pharaoh called Joseph's name “Zaphenath-Paneah.” He gave him Asenath, the daughter of Potiphera priest of On, as a wife. Joseph went out over the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joseph was thirty years old when he stood before Pharaoh, king of Egypt. Joseph went out from the presence of Pharaoh, and went throughout all the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","In the seven bountiful years the land produced abundantly. ");
INSERT INTO engULB_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","He gathered up all the food of the seven years that was in the land of Egypt and put the food in the cities. He put into each city the food from the fields that surrounded it. ");
INSERT INTO engULB_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Joseph stored up grain like the sand of the sea, so much that he stopped counting, because it was beyond counting. ");
INSERT INTO engULB_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Joseph had two sons before the years of famine came, whom Asenath, the daughter of Potiphera priest of On, bore to him. ");
INSERT INTO engULB_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph called the name of his firstborn Manasseh, for he said, “God has made me forget all my trouble and all my father's household.” ");
INSERT INTO engULB_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","He called the name of the second son Ephraim, for he said, “God has made me fruitful in the land of my affliction.” ");
INSERT INTO engULB_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","The seven years of abundance that was in the land of Egypt came to an end. ");
INSERT INTO engULB_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","The seven years of famine began, as Joseph had said. There was famine in all lands, but in all the land of Egypt there was food. ");
INSERT INTO engULB_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","When all the land of Egypt was famished, the people loudly called on Pharaoh for food. Pharaoh said to all the Egyptians, “Go to Joseph and do what he says.” ");
INSERT INTO engULB_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","The famine was over all the face of the whole land. Joseph opened all the storehouses and sold to the Egyptians. The famine was severe in the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","All the earth was coming to Egypt to buy grain from Joseph, because the famine was severe in all the earth. ");
INSERT INTO engULB_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Now Jacob became aware that there was grain in Egypt. He said to his sons, “Why do you look at one another?” ");
INSERT INTO engULB_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","He said, “See here, I have heard that there is grain in Egypt. Go down there and buy for us from there so we may live and not die.” ");
INSERT INTO engULB_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Joseph's ten brothers went down to buy grain from Egypt. ");
INSERT INTO engULB_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","But Benjamin, Joseph's brother, Jacob did not send with his brothers, for he feared that harm might come to him. ");
INSERT INTO engULB_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","The sons of Israel came to buy among those who came, for the famine was in the land of Canaan. ");
INSERT INTO engULB_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Now Joseph was the governor over the land. He was the one who sold to all the people of the land. Joseph's brothers came and bowed down to him with their faces to the ground. ");
INSERT INTO engULB_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Joseph saw his brothers and recognized them, but he disguised himself to them and spoke harshly with them. He said to them, “Where have you come from?” They said, “From the land of Canaan to buy food.” ");
INSERT INTO engULB_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Joseph recognized his brothers, but they did not recognize him. ");
INSERT INTO engULB_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Then Joseph remembered the dreams he had dreamed about them, and he said to them, “You are spies! You have come to see the undefended parts of the land.” ");
INSERT INTO engULB_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","They said to him, “No, my master. Your servants have come to buy food. ");
INSERT INTO engULB_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","We are all one man's sons. We are honest men. Your servants are not spies.” ");
INSERT INTO engULB_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","He said to them, “No, you have come to see the undefended parts of the land.” ");
INSERT INTO engULB_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","They said, “We your servants are twelve brothers, the sons of one man in the land of Canaan. See, the youngest is this day with our father, and one brother is no longer alive.” ");
INSERT INTO engULB_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Joseph said to them, “It is what I said to you; you are spies. ");
INSERT INTO engULB_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","By this you will be tested. By the life of Pharaoh, you will not leave here, unless your youngest brother comes here. ");
INSERT INTO engULB_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Send one of yourselves and let him get your brother. You will remain in prison, that your words may be tested, whether there is truth in you.” ");
INSERT INTO engULB_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","He put them all in custody for three days. ");
INSERT INTO engULB_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Joseph said to them on the third day, “Do this and live, for I fear God. ");
INSERT INTO engULB_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","If you are honest men, let one of your brothers be confined in this prison, but you go, carry grain for the famine of your houses. ");
INSERT INTO engULB_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Bring your youngest brother to me so your words will be verified and you will not die.” So they did so. ");
INSERT INTO engULB_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","They said to one another, “We are truly guilty concerning our brother in that we saw the distress of his soul when he pleaded with us and we would not listen. Therefore this distress has come upon us.” ");
INSERT INTO engULB_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reuben answered them, “Did I not tell you, 'Do not sin against the boy,' but you would not listen? Now, see, his blood is required of us.” ");
INSERT INTO engULB_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","They did not know that Joseph understood them, for there was an interpreter between them. ");
INSERT INTO engULB_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","He turned from them and wept. He returned to them and spoke to them. He took Simeon from among them and bound him before their eyes. ");
INSERT INTO engULB_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Then Joseph commanded his servants to fill his brothers' bags with grain, and to put every man's money back into his sack, and to give them provisions for the journey. It was done for them. ");
INSERT INTO engULB_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","The brothers loaded their donkeys with their grain and departed from there. ");
INSERT INTO engULB_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","As one of them opened his sack to give his donkey feed in the lodging place, he saw his money. Behold, it was in the opening of his sack. ");
INSERT INTO engULB_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","He said to his brothers, “My money has been put back. Look at it; it is in my sack.” Their hearts sank and they turned trembling to one another, saying, “What is this that God has done to us?” ");
INSERT INTO engULB_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","They went to Jacob, their father in the land of Canaan and told him all that had happened to them. They said, ");
INSERT INTO engULB_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“The man, the lord of the land, spoke roughly with us and thought that we were spies in the land. ");
INSERT INTO engULB_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","We said to him, 'We are honest men. We are not spies. ");
INSERT INTO engULB_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","We are twelve brothers, sons of our father. One is no longer alive, and the youngest is this day with our father in the land of Canaan.' ");
INSERT INTO engULB_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","The man, the lord of the land, said to us, 'By this I will know that you are honest men. Leave one of your brothers with me, take grain for the famine in your houses, and go your way. ");
INSERT INTO engULB_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Bring your youngest brother to me. Then I will know that you are not spies, but that you are honest men. Then I will release your brother to you, and you will trade in the land.'” ");
INSERT INTO engULB_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","It came about as they emptied their sacks, that, behold, every man's bag of silver was in his sack. When they and their father saw their bags of silver, they were afraid. ");
INSERT INTO engULB_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jacob their father said to them, “You have bereaved me of my children. Joseph is no longer alive, Simeon is gone, and you will take Benjamin away. All these things are against me.” ");
INSERT INTO engULB_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Reuben spoke to his father, saying, “You may kill my two sons if I do not bring Benjamin back to you. Put him in my hands, and I will bring him to you again.” ");
INSERT INTO engULB_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Jacob said, “My son will not go down with you. For his brother is dead and he alone is left. If harm comes to him on the road in which you go, then you will bring down my gray hair with sorrow to Sheol.” ");
INSERT INTO engULB_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","The famine was severe in the land. ");
INSERT INTO engULB_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","It came about when they had eaten the grain that they had brought out of Egypt, their father said to them, “Go again; buy us some food.” ");
INSERT INTO engULB_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Judah told him, “The man solemnly warned us, 'You will not see my face unless your brother is with you.' ");
INSERT INTO engULB_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","If you send our brother with us, we will go down and buy you food. ");
INSERT INTO engULB_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","But if you do not send him, we will not go down. For the man said to us, 'You will not see my face unless your brother is with you.'” ");
INSERT INTO engULB_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israel said, “Why did you treat me so badly by telling the man that you had another brother?” ");
INSERT INTO engULB_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","They said, “The man asked details about us and our family. He said, 'Is your father still alive? Do you have another brother?' We answered him according to these questions. How could we have known that he would say, 'Bring your brother down?'” ");
INSERT INTO engULB_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Judah said to Israel his father, “Send the boy with me. We will rise and go that we may live and not die, both we, you, and also our children. ");
INSERT INTO engULB_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","I will be a guarantee for him. You will hold me responsible. If I do not bring him back to you and set him before you, then let me bear the blame forever. ");
INSERT INTO engULB_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","For if we had not delayed, surely by now we would have come back here a second time.” ");
INSERT INTO engULB_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Their father Israel said to them, “If it be so, now do this. Take some of the best products of the land in your bags. Carry down to the man a gift—some balm and honey, spices and myrrh, pistachio nuts and almonds. ");
INSERT INTO engULB_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Take double money in your hand. The money that was returned in the opening of your sacks, carry again in your hand. Perhaps it was a mistake. ");
INSERT INTO engULB_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Take also your brother. Rise and go again to the man. ");
INSERT INTO engULB_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","May God Almighty give you mercy before the man, so that he may release to you your other brother and Benjamin. If I am bereaved of my children, I am bereaved.” ");
INSERT INTO engULB_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","The men took this gift, and in their hand they took double the amount of money, along with Benjamin. They got up and went down to Egypt and stood before Joseph. ");
INSERT INTO engULB_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","When Joseph saw Benjamin with them, he said to the steward of his house, “Bring the men into the house, slaughter an animal and prepare it, for the men will eat with me at noon.” ");
INSERT INTO engULB_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","The steward did as Joseph said. He brought the men to Joseph's house. ");
INSERT INTO engULB_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","The men were afraid because they were brought to Joseph's house. They said, “It is because of the money that was returned in our sacks the first time we were brought in, that he may seek an opportunity against us. He might arrest us and take us as slaves, and take our donkeys.” ");
INSERT INTO engULB_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","They approached the steward of Joseph's house, and they spoke to him at the door of the house, ");
INSERT INTO engULB_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","saying, “My master, we came down the first time to buy food. ");
INSERT INTO engULB_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","It came about, when we reached the lodging place, that we opened our sacks, and, behold, every man's money was in the opening of his sack, our money in full weight. We have brought it back in our hands. ");
INSERT INTO engULB_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Other money we have also brought down in our hand to buy food. We do not know who put our money in our sacks.” ");
INSERT INTO engULB_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","The steward said, “Peace be to you, do not fear. Your God and the God of your father must have put your money in your sacks. I received your money.” The steward then brought Simeon out to them. ");
INSERT INTO engULB_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","The steward took the men into Joseph's house. He gave them water, and they washed their feet. He gave feed to their donkeys. ");
INSERT INTO engULB_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","They prepared the gifts for Joseph's coming at noon, for they had heard that they would eat there. ");
INSERT INTO engULB_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","When Joseph came home, they brought the gifts which were in their hand into the house, and bowed down before him to the ground. ");
INSERT INTO engULB_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","He asked them about their welfare and said, “Is your father well, the old man of whom you spoke? Is he still alive?” ");
INSERT INTO engULB_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","They said, “Your servant our father is well. He is still alive.” They prostrated themselves and bowed down. ");
INSERT INTO engULB_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","When he lifted up his eyes he saw Benjamin his brother, his mother's son, and he said, “Is this your youngest brother of whom you spoke to me?” Then he said, “May God be gracious to you, my son.” ");
INSERT INTO engULB_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Joseph hurried to go out of the room, for he was deeply moved about his brother. He sought somewhere to weep. He went to his room and wept there. ");
INSERT INTO engULB_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","He washed his face and came out. He controlled himself, saying, “Serve the food.” ");
INSERT INTO engULB_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","The servants served Joseph by himself and the brothers by themselves. The Egyptians there ate with him by themselves because the Egyptians could not eat bread with the Hebrews, for that is detestable to the Egyptians. ");
INSERT INTO engULB_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","The brothers sat before him, the firstborn according to his birthright, and the youngest according to his youth. The men were astonished together. ");
INSERT INTO engULB_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Joseph sent portions to them from the food in front of him. But Benjamin's portion was five times as much as any of his brothers. They drank and were merry with him. ");
INSERT INTO engULB_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Joseph commanded the steward of his house, saying, “Fill the men's sacks with food, as much as they can carry, and put every man's money in his sack's opening. ");
INSERT INTO engULB_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Put my cup, the silver cup, in the sack's opening of the youngest, and also his money for the grain.” The steward did as Joseph had said. ");
INSERT INTO engULB_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","The morning dawned, and the men were sent away, they and their donkeys. ");
INSERT INTO engULB_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","When they were out of the city but were not yet far off, Joseph said to his steward, “Get up, follow after the men, and when you overtake them, say to them, 'Why have you returned evil for good? ");
INSERT INTO engULB_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Is this not the cup from which my master drinks, and the cup that he uses for divination? You have done evil, this thing that you have done.'” ");
INSERT INTO engULB_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","The steward overtook them and spoke these words to them. ");
INSERT INTO engULB_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","They said to him, “Why does my master speak such words as these? Far be it from your servants that they would do such a thing. ");
INSERT INTO engULB_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Look, the money that we found in our sacks' openings, we brought again to you out of the land of Canaan. How then could we steal out of your master's house silver or gold? ");
INSERT INTO engULB_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","With whomever of your servants it is found, let him die, and we also will be my master's slaves.” ");
INSERT INTO engULB_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","The steward said, “Now also let it be according to your words. He with whom the cup is found will be my slave, and you others will be innocent.” ");
INSERT INTO engULB_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Then each man hurried and brought his sack down to the ground, and each man opened his sack. ");
INSERT INTO engULB_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","The steward searched. He began with the oldest and finished with the youngest, and the cup was found in Benjamin's sack. ");
INSERT INTO engULB_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Then they tore their clothes. Each man loaded his donkey and returned to the city. ");
INSERT INTO engULB_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Judah and his brothers came to Joseph's house. He was still there, and they bowed before him to the ground. ");
INSERT INTO engULB_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Joseph said to them, “What is this that you have done? Do you not know that a man like me practices divination?” ");
INSERT INTO engULB_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judah said, “What can we say to my master? What can we speak? Or how can we justify ourselves? God has found out the iniquity of your servants. Look, we are my master's slaves, both we and he also in whose hand the cup was found.” ");
INSERT INTO engULB_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Joseph said, “Far be it from me that I should do so. The man in whose hand the cup was found, that person will be my slave, but as for you others, go up in peace to your father.” ");
INSERT INTO engULB_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Then Judah came near to him and said, “My master, please let your servant speak a word in my master's ears, and do let your anger burn against your servant, for you are just like Pharaoh. ");
INSERT INTO engULB_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","My master asked his servants, saying, 'Do you have a father or a brother?' ");
INSERT INTO engULB_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","We said to my master, 'We have a father, an old man, and a child of his old age, a little one. But his brother is dead, and he alone is left of his mother, and his father loves him.' ");
INSERT INTO engULB_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Then you said to your servants, 'Bring him down to me that I may see him.' ");
INSERT INTO engULB_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","After that, we said to my master, 'The boy cannot leave his father. For if he should leave his father his father would die.' ");
INSERT INTO engULB_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Then you said to your servants, 'Unless your youngest brother comes down with you, you will not see my face again.' ");
INSERT INTO engULB_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Then it came about when we went up to your servant my father, we told him the words of my master. ");
INSERT INTO engULB_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Our father said, 'Go again, buy us some food.' ");
INSERT INTO engULB_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Then we said, 'We cannot go down. If our youngest brother is with us, then will we go down, for we will not be able to see the man's face unless our youngest brother is with us.' ");
INSERT INTO engULB_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Your servant my father said to us, 'You know that my wife bore me two sons. ");
INSERT INTO engULB_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","One of them went out from me and I said, “Surely he is torn in pieces, and I have not seen him since.” ");
INSERT INTO engULB_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Now if you also take this one from me, and harm comes to him, you will bring down my gray hair with sorrow to Sheol.' ");
INSERT INTO engULB_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Now, therefore, when I come to your servant my father, and the lad is not with us, since his life is bound up in the boy's life, ");
INSERT INTO engULB_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","it will come about, when he sees the boy is not with us, he will die. Your servants will bring down the gray hair of your servant our father with sorrow to Sheol. ");
INSERT INTO engULB_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","For your servant became a guarantee for the boy to my father and said, 'If I do not bring him to you, then I will bear the guilt to my father forever.' ");
INSERT INTO engULB_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Now therefore, please let your servant stay instead of the boy as slave to my master, and let the boy go up with his brothers. ");
INSERT INTO engULB_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","For how can I go up to my father if the boy is not with me? I am afraid to see the evil that would come on my father.” ");
INSERT INTO engULB_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Then Joseph could not control himself before all the servants who stood by him. He said loudly, “Everyone must leave me.” So no servant stood by him when Joseph made himself known to his brothers. ");
INSERT INTO engULB_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","He wept loudly, the Egyptians heard it, and the house of Pharaoh heard of it. ");
INSERT INTO engULB_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Joseph said to his brothers, “I am Joseph. Is my father still alive?” His brothers could not answer him, for they were shocked in his presence. ");
INSERT INTO engULB_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Then Joseph said to his brothers, “Come near to me, please.” They came near. He said, “I am Joseph your brother, whom you sold into Egypt. ");
INSERT INTO engULB_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Do not be grieved or angry with yourselves that you sold me here, for God sent me ahead of you to preserve life. ");
INSERT INTO engULB_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","For these two years the famine has been in the land, and there are still five years in which there will be neither plowing nor harvest. ");
INSERT INTO engULB_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","God sent me ahead of you to preserve you as a remnant in the earth, and to keep you alive by a great deliverance. ");
INSERT INTO engULB_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","So now it was not you who sent me here but God, and he has made me a father to Pharaoh, master of all his house, and ruler of all the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Hurry and go up to my father and say to him, 'This is what your son Joseph says, “God has made me master of all Egypt. Come down to me, do not delay. ");
INSERT INTO engULB_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","You will live in the land of Goshen, and you will be near me, you and your children and your children's children, and your flocks and your herds, and all that you have. ");
INSERT INTO engULB_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","I will provide for you there, for there are still five years of famine, so that you do not come to poverty, you, your household, and all that you have.”' ");
INSERT INTO engULB_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Look, your eyes see, and the eyes of my brother Benjamin, that it is my mouth that speaks to you. ");
INSERT INTO engULB_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","You will tell my father about all my honor in Egypt and of all that you have seen. You will hurry and bring my father down here.” ");
INSERT INTO engULB_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","He hugged his brother Benjamin's neck and wept, and Benjamin wept on his neck. ");
INSERT INTO engULB_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","He kissed all his brothers and wept over them. After that his brothers talked with him. ");
INSERT INTO engULB_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","The news of the matter was told in Pharaoh's house: “Joseph's brothers have come.” It pleased Pharaoh and his servants very much. ");
INSERT INTO engULB_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pharaoh said to Joseph, “Say to your brothers, 'Do this: Load your animals and go to the land of Canaan. ");
INSERT INTO engULB_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Get your father and your households and come to me. I will give you the good of the land of Egypt, and you will eat the fat of the land.' ");
INSERT INTO engULB_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Now you are commanded, 'Do this, take carts out of the land of Egypt for your children and for your wives. Get your father and come. ");
INSERT INTO engULB_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Do not be concerned about your possessions, for the good of all the land of Egypt is yours.'” ");
INSERT INTO engULB_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","The sons of Israel did so. Joseph gave them carts, according to the command of Pharaoh, and gave them provisions for the journey. ");
INSERT INTO engULB_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","To all of them he gave each man changes of clothing, but to Benjamin he gave three hundred pieces of silver and five changes of clothing. ");
INSERT INTO engULB_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","For his father he sent this: ten donkeys loaded with the good things of Egypt; and ten female donkeys loaded with grain, bread, and other supplies for his father for the journey. ");
INSERT INTO engULB_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","So he sent his brothers away and they left. He said to them, “See that you do not quarrel on the journey.” ");
INSERT INTO engULB_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","They went up out of Egypt and came to the land of Canaan, to Jacob their father. ");
INSERT INTO engULB_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","They told him saying “Joseph is still alive, and he is ruler over all the land of Egypt.” His heart was astonished, for he could not believe what they told him. ");
INSERT INTO engULB_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","They told him all the words of Joseph that he had said to them. When Jacob saw the carts that Joseph had sent to carry him, the spirit of Jacob their father revived. ");
INSERT INTO engULB_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israel said, “It is enough. Joseph my son is still alive. I will go and see him before I die.” ");
INSERT INTO engULB_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israel made his journey with all that he had and went to Beersheba. There he offered sacrifices to the God of his father Isaac. ");
INSERT INTO engULB_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","God spoke to Israel in a vision at night, saying, “Jacob, Jacob.” He said, “Here I am.” ");
INSERT INTO engULB_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","He said, “I am God, the God of your father. Do not fear to go down to Egypt, for there I will make you a great nation. ");
INSERT INTO engULB_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","I will go down with you into Egypt, and I will surely bring you up again and Joseph will close your eyes with his own hand.” ");
INSERT INTO engULB_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Jacob rose up from Beersheba. The sons of Israel transported Jacob their father, their children, and their wives, in the carts that Pharaoh had sent to carry him. ");
INSERT INTO engULB_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","They took their livestock and their possessions that they had accumulated in the land of Canaan. They came into Egypt, Jacob and all his descendants with him. ");
INSERT INTO engULB_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","He brought with him to Egypt his sons and his sons' sons, his daughters and his sons' daughters, and all his descendants. ");
INSERT INTO engULB_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","These were the names of the children of Israel who came to Egypt: Jacob and his sons, Reuben, Jacob's firstborn; ");
INSERT INTO engULB_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","the sons of Reuben, Hanok, Pallu, Hezron, and Karmi; ");
INSERT INTO engULB_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","the sons of Simeon, Jemuel, Jamin, Ohad, Jakin, Zohar, and Shaul, the son of a Canaanite woman; ");
INSERT INTO engULB_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","and the sons of Levi, Gershon, Kohath, and Merari. ");
INSERT INTO engULB_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","The sons of Judah were Er, Onan, Shelah, Perez, and Zerah, (but Er and Onan had died in the land of Canaan). The sons of Perez were Hezron and Hamul. ");
INSERT INTO engULB_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","The sons of Issachar were Tola, Puah, Lob, and Shimron; ");
INSERT INTO engULB_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","The sons of Zebulun were Sered, Elon, and Jahleel ");
INSERT INTO engULB_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","These were the sons of Leah whom she bore to Jacob in Paddan Aram, along with his daughter Dinah. His sons and his daughters numbered thirty-three. ");
INSERT INTO engULB_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","The sons of Gad were Zephon, Haggi, Shuni, Ezbon, Eri, Arodi, and Areli. ");
INSERT INTO engULB_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","The sons of Asher were Imnah, Ishvah, Ishvi, and Beriah; and Serah was their sister. The sons of Beriah were Heber and Malkiel ");
INSERT INTO engULB_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","These were the sons of Zilpah, whom Laban had given to Leah his daughter. These sons she bore to Jacob—sixteen in all. ");
INSERT INTO engULB_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","The sons of Jacob's wife Rachel were Joseph and Benjamin. ");
INSERT INTO engULB_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","In Egypt Manasseh and Ephraim were born to Joseph by Asenath, the daughter of Potiphera priest of On. ");
INSERT INTO engULB_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","The sons of Benjamin were Bela, Beker, Ashbel, Gera, Naaman, Ehi, Rosh, Muppim, Huppim, and Ard. ");
INSERT INTO engULB_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","These were the sons of Rachel who were born to Jacob—fourteen in all. ");
INSERT INTO engULB_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","The son of Dan was Hushim. ");
INSERT INTO engULB_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","The sons of Naphtali were Jahziel, Guni, Jezer, and Shillem. ");
INSERT INTO engULB_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","These were the sons born to Jacob by Bilhah, whom Laban gave to Rachel his daughter—seven in all. ");
INSERT INTO engULB_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","All those who went to Egypt with Jacob, who were his descendants, not counting Jacob's sons' wives, were sixty-six in all. ");
INSERT INTO engULB_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","With the two sons of Joseph who were born to him in Egypt, the members of his family who went to Egypt were seventy in all. ");
INSERT INTO engULB_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob sent Judah ahead of him to Joseph to show the way before him to Goshen, and they came to the land of Goshen. ");
INSERT INTO engULB_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joseph prepared his chariot and went up to meet Israel his father in Goshen. He saw him, hugged his neck, and wept on his neck a long time. ");
INSERT INTO engULB_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israel said to Joseph, “Now let me die, since I have seen your face, that you are still alive.” ");
INSERT INTO engULB_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Joseph said to his brothers and to his father's house, “I will go up and tell Pharaoh, saying, 'My brothers and my father's house, who were in the land of Canaan, have come to me. ");
INSERT INTO engULB_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","The men are shepherds, for they have been keepers of livestock. They have brought their flocks, their herds, and all that they have.' ");
INSERT INTO engULB_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","It will come about, when Pharaoh calls you and asks, 'What is your occupation?' ");
INSERT INTO engULB_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","that you should say, 'Your servants have been keepers of livestock from our youth until now, both we, and our forefathers.' Do this so that you may live in the land of Goshen, for every shepherd is an abomination to the Egyptians.” ");
INSERT INTO engULB_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Then Joseph went in and told Pharaoh, “My father and my brothers, their flocks, their herds, and all that they own, have arrived from the land of Canaan. See, they are in the land of Goshen.” ");
INSERT INTO engULB_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","He took five of his brothers and introduced them to Pharaoh. ");
INSERT INTO engULB_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Pharaoh said to his brothers, “What is your occupation?” They said to Pharaoh, “Your servants are shepherds, as our ancestors.” ");
INSERT INTO engULB_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Then they said to Pharaoh, “We come as temporary residents in the land. There is no pasture for your servants' flocks, because the famine is severe in the land of Canaan. So now, please let your servants live in the land of Goshen.” ");
INSERT INTO engULB_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Then Pharaoh spoke to Joseph, saying, “Your father and your brothers have come to you. ");
INSERT INTO engULB_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","The land of Egypt is before you. Settle your father and your brothers in the best region, the land of Goshen. If you know any capable men among them, put them in charge of my livestock.” ");
INSERT INTO engULB_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Then Joseph brought in Jacob his father and presented him to Pharaoh. Jacob blessed Pharaoh. ");
INSERT INTO engULB_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Pharaoh said to Jacob, “How long have you lived?” ");
INSERT INTO engULB_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacob said to Pharaoh, “The years of my travels are a hundred and thirty. The years of my life have been few and painful. They have not been as long as those of my ancestors.” ");
INSERT INTO engULB_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Then Jacob blessed Pharaoh and went out from his presence. ");
INSERT INTO engULB_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Then Joseph settled his father and his brothers. He gave them a territory in the land of Egypt, the best of the land, in the land of Rameses, as Pharaoh had commanded. ");
INSERT INTO engULB_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Joseph provided food for his father, his brothers, and all his father's household, according the number of their dependents. ");
INSERT INTO engULB_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Now there was no food in all the land; for the famine was severe. The land of Egypt and the land of Canaan wasted away because of the famine. ");
INSERT INTO engULB_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Joseph gathered all the money that was in the land of Egypt and in the land of Canaan, by selling grain to the inhabitants. Then Joseph brought the money to Pharaoh's palace. ");
INSERT INTO engULB_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","When all the money of the lands of Egypt and Canaan was spent, all the Egyptians came to Joseph saying, “Give us food! Why should we die in your presence because our money is gone?” ");
INSERT INTO engULB_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Joseph said, “If your money is gone, bring your livestock and I will give you food in exchange for your livestock.” ");
INSERT INTO engULB_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","So they brought their livestock to Joseph. Joseph gave them food in exchange for the horses, for the flocks, for the herds, and for the donkeys. He fed them with bread in exchange for all their livestock that year. ");
INSERT INTO engULB_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","When that year was ended, they came to him the next year and said to him, “We will not hide from my master that our money is all gone, and the herds of cattle are my master's. There is nothing left in the sight of my master, except our bodies and our land. ");
INSERT INTO engULB_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Why should we die before your eyes, both we and our land? Buy us and our land in exchange for food, and we and our land will be servants to Pharaoh. Give us seed that we may live and not die, and that the land may not become desolate.” ");
INSERT INTO engULB_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","So Joseph bought all the land of Egypt for Pharaoh. For every Egyptian sold his field, because the famine was very severe. In this way, the land became Pharaoh's. ");
INSERT INTO engULB_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","As for the people, he made them slaves from one end of Egypt's border to the other end. ");
INSERT INTO engULB_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","It was only the land of the priests that Joseph did not buy, because the priests were given an allowance. They ate from the allotment which Pharaoh gave them. Therefore they did not sell their land. ");
INSERT INTO engULB_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Then Joseph said to the people, “See, I have bought you and your land today for Pharaoh. Now here is seed for you, and you will plant the land. ");
INSERT INTO engULB_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","At the harvest, you must give a fifth to Pharaoh, and four parts will be your own, for seed of the field and for food for your households and your children.” ");
INSERT INTO engULB_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","They said, “You have saved our lives. May we find favor in your eyes. We will be Pharaoh's servants.” ");
INSERT INTO engULB_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","So Joseph made it a statute which is in effect in the land of Egypt to this day, that one-fifth belongs to Pharaoh. Only the land of the priests did not become Pharaoh's. ");
INSERT INTO engULB_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","So Israel lived in the land of Egypt, in the land of Goshen. His people gained possessions there. They were fruitful and multiplied greatly. ");
INSERT INTO engULB_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob lived in the land of Egypt seventeen years, so the years of Jacob's life were one hundred forty-seven years. ");
INSERT INTO engULB_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","When the time approached for Israel to die, he called his son Joseph and said to him, “If now I have found favor in your eyes, put your hand under my thigh, and show me faithfulness and trustworthiness. Please do not bury me in Egypt. ");
INSERT INTO engULB_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","When I sleep with my fathers, you will carry me out of Egypt and bury me in my forefathers' burial place.” Joseph said, “I will do as you have said.” ");
INSERT INTO engULB_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Israel said, “Swear to me,” and Joseph swore to him. Then Israel bowed down at the head of his bed. ");
INSERT INTO engULB_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","It came about after these things, that one said to Joseph, “Look, your father is sick.” So he took with him his two sons, Manasseh and Ephraim. ");
INSERT INTO engULB_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","When Jacob was told, “Look, your son Joseph has arrived to see you,” Israel gathered strength and sat up in bed. ");
INSERT INTO engULB_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jacob said to Joseph, “God Almighty appeared to me at Luz in the land of Canaan. He blessed me ");
INSERT INTO engULB_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","and said to me, 'Behold, I will make you fruitful, and multiply you. I will make of you an assembly of nations. I will give this land to your descendants as an everlasting possession.' ");
INSERT INTO engULB_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Now your two sons, who were born to you in the land of Egypt before I came to you into Egypt, they are mine. Ephraim and Manasseh will be mine, just as Reuben and Simeon are mine. ");
INSERT INTO engULB_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","The children you have after them will be yours; they will be listed under the names of their brothers in their inheritance. ");
INSERT INTO engULB_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","But as for me, when I came from Paddan, to my sorrow Rachel died in the land of Canaan on the way, while there was still some distance to go to Ephrath. I buried her there on the way to Ephrath” (that is, Bethlehem). ");
INSERT INTO engULB_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","When Israel saw Joseph's sons, he said, “Whose are these?” ");
INSERT INTO engULB_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph said to his father, “They are my sons, whom God has given me here.” Israel said, “Bring them to me, that I may bless them.” ");
INSERT INTO engULB_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Now Israel's eyes were failing because of his age, so he could not see. So Joseph brought them near to him, and he kissed them and embraced them. ");
INSERT INTO engULB_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israel said to Joseph, “I never expected to see your face again, but God has even allowed me to see your children.” ");
INSERT INTO engULB_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Joseph brought them out from between Israel's knees, and then he bowed with his face to the earth. ");
INSERT INTO engULB_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Joseph took them both, Ephraim in his right hand toward Israel's left hand, and Manasseh in his left hand toward Israel's right hand, and brought them close to him. ");
INSERT INTO engULB_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Israel reached out with his right hand and laid it upon Ephraim's head, who was the younger, and his left hand upon Manasseh's head. He crossed his hands, for Manasseh was the firstborn. ");
INSERT INTO engULB_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Israel blessed Joseph, saying, “The God before whom my fathers Abraham and Isaac walked, the God who has cared for me to this day, ");
INSERT INTO engULB_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","the angel who has protected me from all harm, may he bless these boys. May my name be named in them, and the name of my fathers Abraham and Isaac. May they grow into a multitude on the earth.” ");
INSERT INTO engULB_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","When Joseph saw his father place his right hand upon the head of Ephraim, it displeased him. He took his father's hand to move it from Ephraim's head to Manasseh's head. ");
INSERT INTO engULB_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Joseph said to his father, “Not so, my father; for this is the firstborn. Put your right hand upon his head.” ");
INSERT INTO engULB_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","His father refused and said, “I know, my son, I know. He also will become a people, and he also will be great. Yet his younger brother will be greater than he, and his descendants will become a multitude of nations.” ");
INSERT INTO engULB_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Israel blessed them that day with these words, “The people of Israel will pronounce blessings by your names saying, 'May God make you like Ephraim and like Manasseh'.” In this way, Israel put Ephraim before Manasseh. ");
INSERT INTO engULB_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Israel said to Joseph, “See, I am about to die, but God will be with you, and will bring you back to the land of your fathers. ");
INSERT INTO engULB_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","To you, as one who is above your brothers, I give to you the mountain slope that I took from the Amorites with my sword and my bow.” ");
INSERT INTO engULB_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Then Jacob called for his sons, and said: “Gather yourselves together, that I may tell you what will happen to you in the future. ");
INSERT INTO engULB_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Assemble yourselves and listen, you sons of Jacob. Listen to Israel, your father. ");
INSERT INTO engULB_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Reuben, you are my firstborn, my might, and the beginning of my strength, outstanding in dignity, and outstanding in power. ");
INSERT INTO engULB_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Uncontrollable as rushing water, you will not have the preeminence, because you went up to your father's bed. Then you defiled it; you went up to my couch. ");
INSERT INTO engULB_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon and Levi are brothers. Weapons of violence are their swords. ");
INSERT INTO engULB_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","O my soul, do not come into their council; do not join in their meetings, for my heart has too much honor for that. For in their anger they killed men. It was for pleasure that they hamstrung oxen. ");
INSERT INTO engULB_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","May their anger be cursed, for it was fierce—and their fury, for it was cruel. I will divide them in Jacob and scatter them in Israel. ");
INSERT INTO engULB_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judah, your brothers will praise you. Your hand will be on the neck of your enemies. Your father's sons will bow down before you. ");
INSERT INTO engULB_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judah is a lion's cub. My son, you have gone up from your victims. He stooped down, he crouched like a lion, like a lioness. Who would dare to awaken him? ");
INSERT INTO engULB_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","The scepter will not depart from Judah, nor the ruler's staff from between his feet, until Shiloh comes. The nations will obey him. ");
INSERT INTO engULB_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Binding his donkey to the vine, and his donkey's colt to the choice vine, he has washed his garments in wine, and his robe in the blood of grapes. ");
INSERT INTO engULB_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","His eyes will be as dark as wine, and his teeth as white as milk. ");
INSERT INTO engULB_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulun will live by the shore of the sea. He will be a harbor for ships, and his border will extend to Sidon. ");
INSERT INTO engULB_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issachar is a strong donkey, lying down between the sheepfolds. ");
INSERT INTO engULB_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","He sees a good resting place and the pleasant land. He will bend his shoulder to the burden and become a servant for the task. ");
INSERT INTO engULB_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan will judge his people as one of the tribes of Israel. ");
INSERT INTO engULB_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan will be a snake beside the road, a poisonous snake in the path that bites the horse's heels, so that his rider falls backward. ");
INSERT INTO engULB_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","I wait for your salvation, Yahweh. ");
INSERT INTO engULB_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad—raiders will attack him, but he will attack them at their heels. ");
INSERT INTO engULB_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asher's food will be rich, and he will provide royal delicacies. ");
INSERT INTO engULB_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naphtali is a doe let loose; he will have beautiful fawns. ");
INSERT INTO engULB_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joseph is a fruitful bough, a fruitful bough near a spring, whose branches climb over the wall. ");
INSERT INTO engULB_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","The archers will attack him and shoot at him and harass him. ");
INSERT INTO engULB_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","But his bow will remain steady, and his hands will be skillful because of the hands of the Mighty One of Jacob, because of the name of the Shepherd, the Rock of Israel. ");
INSERT INTO engULB_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","The God of your father will help you and the Almighty God will bless you with blessings of the sky above, blessings of the deep that lies beneath, and blessings of the breasts and womb. ");
INSERT INTO engULB_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","The blessings of your father are greater than the blessings of the ancient mountains or the desirable things of the ancient hills. May they be on the head of Joseph, even upon the crown of the head of the prince of his brothers. ");
INSERT INTO engULB_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin is a hungry wolf. In the morning he will devour the prey, and in the evening he will divide the plunder.” ");
INSERT INTO engULB_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","These are the twelve tribes of Israel. This is what their father said to them when he blessed them. Each one he blessed with an appropriate blessing. ");
INSERT INTO engULB_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Then he instructed them and said to them, “I am about to go to my people. Bury me with my forefathers in the cave that is in the field of Ephron the Hittite, ");
INSERT INTO engULB_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","in the cave that is in the field of Machpelah, which is near Mamre in the land of Canaan, the field that Abraham bought for a burial place from Ephron the Hittite. ");
INSERT INTO engULB_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","There they buried Abraham and Sarah his wife; there they buried Isaac and Rebekah his wife; and there I buried Leah. ");
INSERT INTO engULB_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","The field and the cave that is in it were purchased from the people of Heth.” ");
INSERT INTO engULB_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","When Jacob finished these instructions to his sons, he pulled his feet into the bed, breathed his last, and went to his people. ");
INSERT INTO engULB_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Then Joseph was so distressed that he collapsed on the face of his father, and he wept over him, and he kissed him. ");
INSERT INTO engULB_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Joseph commanded his servants the physicians to embalm his father. So the physicians embalmed Israel. ");
INSERT INTO engULB_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","They took forty days, for that was the full time for embalming. The Egyptians wept for him seventy days. ");
INSERT INTO engULB_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","When the days of weeping were over, Joseph spoke to the house of Pharaoh, saying, “If now I have found favor in your eyes, please speak to Pharaoh, saying, ");
INSERT INTO engULB_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","'My father made me swear, saying, “See, I am about to die. Bury me in my tomb that I dug for myself in the land of Canaan. There you will bury me.” Now let me go up and bury my father, and then I will return.'” ");
INSERT INTO engULB_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pharaoh answered, “Go and bury your father, as he made you swear.” ");
INSERT INTO engULB_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Joseph went up to bury his father. All the officials of Pharaoh went with him—the elders of his household, all the senior officials of the land of Egypt, ");
INSERT INTO engULB_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","with all Joseph's household and his brothers, and his father's household. But their children, their flocks, and their herds were left in the land of Goshen. ");
INSERT INTO engULB_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Chariots and horsemen also went with him. It was a very large group of people. ");
INSERT INTO engULB_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","When they came to the threshing floor of Atad on the other side of the Jordan, they mourned with very great and grievous sorrow. There Joseph made a seven-day mourning for his father. ");
INSERT INTO engULB_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","When the inhabitants of the land, the Canaanites, saw the mourning in the floor of Atad, they said, “This is a very sad occasion for the Egyptians.” That is why the place was called Abel Mizraim, which is beyond the Jordan. ");
INSERT INTO engULB_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","So his sons did for Jacob just as he had instructed them. ");
INSERT INTO engULB_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","His sons carried him to the land of Canaan and buried him in the cave in the field of Machpelah, near Mamre. Abraham had bought the cave with the field for a burial place. He had bought it from Ephron the Hittite. ");
INSERT INTO engULB_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","After he had buried his father, Joseph returned into Egypt, he, along with his brothers, and all who had accompanied him to bury his father. ");
INSERT INTO engULB_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","When Joseph's brothers saw that their father was dead, they said, “What if Joseph holds on to anger against us and wants to repay us in full for all the evil we did to him?” ");
INSERT INTO engULB_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","So they commanded the presence of Joseph, saying, “Your father gave instructions before he died, saying, ");
INSERT INTO engULB_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","'Tell Joseph this, “Please forgive the transgression of your brothers and their sin when they did evil to you.”' Now please forgive the servants of the God of your father.” Joseph wept when they spoke to him. ");
INSERT INTO engULB_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","His brothers also went and lay facedown before him. They said, “See, we are your servants.” ");
INSERT INTO engULB_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","But Joseph answered them, “Do not be afraid. Am I in the place of God? ");
INSERT INTO engULB_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","As for you, you meant to harm me, but God meant it for good, to preserve the lives of many people, as you see today. ");
INSERT INTO engULB_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","So now do not be afraid. I will provide for you and your little children.” He comforted them in this way and spoke kindly to their hearts. ");
INSERT INTO engULB_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Joseph lived in Egypt, together with his father's family. He lived one hundred ten years. ");
INSERT INTO engULB_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Joseph saw Ephraim's children to the third generation. He also saw the children of Machir son of Manasseh, who were placed on the knees of Joseph. ");
INSERT INTO engULB_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Joseph said to his brothers, “I am about to die; but God will surely come to you and lead you up out of this land to the land which he swore to give to Abraham, to Isaac, and to Jacob.” ");
INSERT INTO engULB_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Then Joseph made the people of Israel swear an oath. He said, “God will surely come to you. At that time you must carry up my bones from here.” ");
INSERT INTO engULB_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","So Joseph died, 110 years old. They embalmed him and he was placed in a coffin in Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","These are the names of the sons of Israel who came into Egypt with Jacob, each with his household: ");
INSERT INTO engULB_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuben, Simeon, Levi, and Judah, ");
INSERT INTO engULB_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issachar, Zebulun, and Benjamin, ");
INSERT INTO engULB_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naphtali, Gad, and Asher. ");
INSERT INTO engULB_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","All the people who were descendants of Jacob were seventy in number. Joseph was already in Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Then Joseph, all his brothers, and all that generation died. ");
INSERT INTO engULB_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","The Israelites were fruitful, increased greatly in numbers, and became very strong; the land was filled with them. ");
INSERT INTO engULB_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Now then a new king arose over Egypt, one who did not know about Joseph. ");
INSERT INTO engULB_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","He said to his people, “Look, the Israelites are more numerous and stronger than we are. ");
INSERT INTO engULB_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Come, let us deal with them wisely, otherwise they will continue to grow in numbers, and if war breaks out, they will join our enemies, fight against us, and leave the land.” ");
INSERT INTO engULB_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","So they put taskmasters over them to oppress them with hard labor. The Israelites built store cities for Pharaoh: Pithom and Rameses. ");
INSERT INTO engULB_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","But the more the Egyptians oppressed them, the more the Israelites increased in numbers and spread. So the Egyptians began to dread the Israelites. ");
INSERT INTO engULB_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","The Egyptians made the Israelites work rigorously. ");
INSERT INTO engULB_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","They made their lives bitter with hard service with mortar and brick, and with all kinds of work in the fields. All their required work was hard. ");
INSERT INTO engULB_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Then the king of Egypt spoke to the Hebrew midwives; the name of the one was Shiphrah, and the other Puah. ");
INSERT INTO engULB_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","He said, “When you assist the Hebrew women on the birthstool, observe when they give birth. If it is a son, then you must kill him; but if it is a daughter, then she may live.” ");
INSERT INTO engULB_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","But the midwives feared God and did not do as the king of Egypt ordered them; instead, they let the baby boys live. ");
INSERT INTO engULB_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","The king of Egypt summoned the midwives and said to them, “Why have you done this, and let the baby boys live?” ");
INSERT INTO engULB_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","The midwives answered Pharaoh, “The Hebrew women are not like the Egyptian women. They are vigorous and have finished giving birth before a midwife comes to them.” ");
INSERT INTO engULB_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","God protected these midwives. The people increased in numbers and became very strong. ");
INSERT INTO engULB_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Because the midwives feared God, he gave them families. ");
INSERT INTO engULB_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Pharaoh ordered all his people, “You must throw every son that is born into the river, but every daughter you will let live.” ");
INSERT INTO engULB_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Now a man of the tribe of Levi married a woman of Levi. ");
INSERT INTO engULB_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","The woman became pregnant and gave birth to a son. When she saw that he was a healthy boy, she hid him for three months. ");
INSERT INTO engULB_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","But when she could no longer hide him, she took a papyrus basket and sealed it with bitumen and pitch. Then she put the child in it and placed it among the reeds in the water along the side of the river. ");
INSERT INTO engULB_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","His sister stood at a distance to see what would happen to him. ");
INSERT INTO engULB_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Pharaoh's daughter came down to bathe at the river while her attendants walked along by the riverside. She saw the basket among the reeds and sent her attendant to get it. ");
INSERT INTO engULB_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","When she opened it, she saw the child. Behold, the baby was crying. She had compassion on him and said, “This is certainly one of the Hebrews' children.” ");
INSERT INTO engULB_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Then the baby's sister said to Pharaoh's daughter, “Should I go and find you a Hebrew woman to nurse the child for you?” ");
INSERT INTO engULB_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Pharaoh's daughter said to her, “Go.” So the young girl went and got the child's mother. ");
INSERT INTO engULB_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Pharaoh's daughter said to the baby's mother, “Take this child and nurse him for me, and I will pay you wages.” So the woman took the child and nursed him. ");
INSERT INTO engULB_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","When the child grew older, she brought him to Pharaoh's daughter, and he became her son. She named him Moses and said, “Because I drew him from the water.” ");
INSERT INTO engULB_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","When Moses had grown up, he went out to his people and observed their hard work. He saw an Egyptian striking a Hebrew, one of his own people. ");
INSERT INTO engULB_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","He looked this way and that way, and when he saw that there was no one there, he killed the Egyptian and hid his body in the sand. ");
INSERT INTO engULB_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","He went out the next day, and, behold, two Hebrew men were fighting. He said to the one who was in the wrong, “Why are you hitting your companion?” ");
INSERT INTO engULB_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","But the man said, “Who made you a leader and judge over us? Are you planning to kill me as you killed that Egyptian?” Then Moses became afraid and said, “What I did has certainly become known to others.” ");
INSERT INTO engULB_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Now when Pharaoh heard about it, he tried to kill Moses. But Moses fled from Pharaoh and stayed in the land of Midian. There he sat down by a well. ");
INSERT INTO engULB_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Now the priest of Midian had seven daughters. They came, drew water, and filled the troughs to water their father's flock. ");
INSERT INTO engULB_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","The shepherds came and tried to drive them away, but Moses went and helped them. Then he watered their flock. ");
INSERT INTO engULB_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","When the girls went to Reuel their father, he said, “Why are you home so early today?” ");
INSERT INTO engULB_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","They said, “An Egyptian rescued us from the shepherds. He even drew water for us and watered the flock.” ");
INSERT INTO engULB_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","He said to his daughters, “So where is he? Why did you leave the man? Call him so he can eat a meal with us.” ");
INSERT INTO engULB_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moses agreed to stay with the man, who also gave him his daughter Zipporah in marriage. ");
INSERT INTO engULB_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","She bore a son, and Moses called his name Gershom; he said, “I have been a resident in a foreign land.” ");
INSERT INTO engULB_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","A long time later, the king of Egypt died. The Israelites groaned because of the slave labor. They cried out for help, and their pleas went up to God because of their bondage. ");
INSERT INTO engULB_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","When God heard their groaning, God called to mind his covenant with Abraham, with Isaac, and with Jacob. ");
INSERT INTO engULB_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","God saw the Israelites, and he understood their situation. ");
INSERT INTO engULB_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Now Moses was still shepherding the flock of Jethro his father-in-law, the priest of Midian. Moses led the flock to the far side of the wilderness and arrived at Horeb, the mountain of God. ");
INSERT INTO engULB_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","There the angel of Yahweh appeared to him in a flame of fire in a bush. Moses looked, and behold, the bush was burning, but the bush was not burned up. ");
INSERT INTO engULB_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Moses said, “I will turn aside and see this amazing thing, why the bush is not burned up.” ");
INSERT INTO engULB_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","When Yahweh saw that he had turned aside to look, God called to him out of the bush and said, “Moses, Moses.” Moses said, “Here I am.” ");
INSERT INTO engULB_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","God said, “Do not come any closer! Take off your shoes from your feet, for the place where you are standing is ground that is set apart to me.” ");
INSERT INTO engULB_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","He added, “I am the God of your father, the God of Abraham, the God of Isaac, and the God of Jacob.” Then Moses covered his face, for he was afraid to look at God. ");
INSERT INTO engULB_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Yahweh said, “I have certainly seen the suffering of my people who are in Egypt. I have heard their shouts because of their taskmasters, for I know about their suffering. ");
INSERT INTO engULB_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","I have come down to free them from the Egyptians' power and to bring them up from that land to a good, large land, to a land flowing with milk and honey; to the region of the Canaanites, Hittites, Amorites, Perizzites, Hivites, and Jebusites. ");
INSERT INTO engULB_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Now the shouts of the people of Israel have come to me. Moreover, I have seen the oppression caused by the Egyptians. ");
INSERT INTO engULB_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Now then, I will send you to Pharaoh so that you may bring my people, the Israelites, out of Egypt.” ");
INSERT INTO engULB_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","But Moses said to God, “Who am I, that I should go to Pharaoh and bring the Israelites from Egypt?” ");
INSERT INTO engULB_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","God replied, “I will certainly be with you. This will be a sign to you that I have sent you. When you have brought the people out of Egypt, you will worship me on this mountain.” ");
INSERT INTO engULB_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moses said to God, “When I go to the Israelites and tell them, 'The God of your ancestors has sent me to you,' and when they say to me, 'What is his name?' what should I say to them?” ");
INSERT INTO engULB_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","God said to Moses, “I AM THAT I AM.” God said, “You must say to the Israelites, 'I AM has sent me to you.'” ");
INSERT INTO engULB_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","God also said to Moses, “You must say to the Israelites, 'Yahweh, the God of your ancestors, the God of Abraham, the God of Isaac, and the God of Jacob, has sent me to you. This is my name forever, and this is how I will be kept in mind for all generations.' ");
INSERT INTO engULB_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Go and gather the elders of Israel together. Say to them, 'Yahweh, the God of your ancestors, the God of Abraham, of Isaac, and of Jacob, has appeared to me and said, “I have indeed observed you and have seen what has been done to you in Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","I have promised to bring you up from the oppression in Egypt to the land of the Canaanites, Hittites, Amorites, Perizzites, Hivites, and Jebusites, a land flowing with milk and honey.”' ");
INSERT INTO engULB_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","They will listen to you. You and the elders of Israel must go to the king of Egypt, and you must tell him, 'Yahweh, the God of the Hebrews, has met with us. So now let us go three days' journey into the wilderness, in order that we may sacrifice to Yahweh, our God.' ");
INSERT INTO engULB_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","But I know that the king of Egypt will not let you go, unless his hand is forced. ");
INSERT INTO engULB_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","I will reach out with my hand and attack the Egyptians with all the miracles that I will do among them. After that, he will let you go. ");
INSERT INTO engULB_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","I will grant this people favor from the Egyptians, so when you leave, you will not go empty-handed. ");
INSERT INTO engULB_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Every woman will ask for silver and gold jewels and for clothing from her Egyptian neighbors and any women staying in her neighbors' houses. You will put them on your sons and daughters. In this way you will plunder the Egyptians.” ");
INSERT INTO engULB_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moses answered, “But what if they do not believe me or listen to me but say instead, 'Yahweh has not appeared to you'?” ");
INSERT INTO engULB_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Yahweh said to him, “What is that in your hand?” Moses said, “A staff.” ");
INSERT INTO engULB_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Yahweh said, “Throw it on the ground.” Moses threw it on the ground, and it became a snake. Moses ran back from it. ");
INSERT INTO engULB_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Yahweh said to Moses, “Reach out and take it by the tail.” So he reached out and took hold of the snake. It became a staff in his hand again. ");
INSERT INTO engULB_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“This is so they may believe that Yahweh, the God of their ancestors, the God of Abraham, the God of Isaac, and the God of Jacob, has appeared to you.” ");
INSERT INTO engULB_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Yahweh also said to him, “Now put your hand inside your robe.” So Moses put his hand inside his robe. When he brought it out, behold, his hand was leprous, as white as snow. ");
INSERT INTO engULB_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Yahweh said, “Put your hand inside your robe again.” So Moses put his hand inside his robe, and when he brought it out, he saw that it was made healthy again, like the rest of his flesh. ");
INSERT INTO engULB_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Yahweh said, “If they do not believe you—if they do not pay attention to the first sign of my power or believe in it, then they will believe the second sign. ");
INSERT INTO engULB_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","If they do not believe even these two signs of my power, or listen to you, then take some water from the river and pour it on the dry land. The water that you take will become blood on the dry land.” ");
INSERT INTO engULB_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Then Moses said to Yahweh, “Lord, I have never been eloquent, neither in the past nor since you spoke to your servant. I am slow of speech and slow of tongue.” ");
INSERT INTO engULB_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Yahweh said to him, “Who is it who made man's mouth? Who makes a man mute or deaf or seeing or blind? Is it not I, Yahweh? ");
INSERT INTO engULB_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","So now go, and I will be with your mouth and teach you what to say.” ");
INSERT INTO engULB_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","But Moses said, “Lord, please send anyone else, anyone whom you wish to send.” ");
INSERT INTO engULB_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Then Yahweh became angry with Moses. He said, “What about Aaron, your brother, the Levite? I know that he can speak well. Moreover, he is coming to meet you, and when he sees you, he will be glad in his heart. ");
INSERT INTO engULB_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","You will speak to him and put the words to say into his mouth. I will be with your mouth and with his mouth, and I will show you both what to do. ");
INSERT INTO engULB_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","He will speak to the people for you. He will be your mouth, and you will be to him like me, God. ");
INSERT INTO engULB_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","You will take in your hand this staff. With it you will do the signs.” ");
INSERT INTO engULB_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","So Moses went back to Jethro his father-in-law and said to him, “Let me go so I may return to my relatives who are in Egypt and see if they are still alive.” Jethro said to Moses, “Go in peace.” ");
INSERT INTO engULB_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Yahweh said to Moses in Midian, “Go, return to Egypt, for all the men who were trying to take your life are dead.” ");
INSERT INTO engULB_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Moses took his wife and his sons and put them on a donkey. He returned to the land of Egypt, and he took the staff of God in his hand. ");
INSERT INTO engULB_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Yahweh said to Moses, “When you go back to Egypt, see that you do before Pharaoh all the wonders that I have put in your power. But I will harden his heart, and he will not let the people go. ");
INSERT INTO engULB_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","You must say to Pharaoh, 'This is what Yahweh says: Israel is my son, my firstborn, ");
INSERT INTO engULB_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","and I say to you, “Let my son go, so he may worship me.” But since you have refused to let him go, I will certainly kill your son, your firstborn.'” ");
INSERT INTO engULB_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Now on the way, when they stopped for the night, Yahweh met Moses and tried to kill him. ");
INSERT INTO engULB_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Then Zipporah took a flint knife and cut off the foreskin of her son, and touched it to his feet. Then she said, “Surely you are a bridegroom to me by blood.” ");
INSERT INTO engULB_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","So Yahweh let him alone. She said, “You are a bridegroom of blood” because of the circumcision. ");
INSERT INTO engULB_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Yahweh said to Aaron, “Go into the wilderness to meet Moses.” Aaron went, met him at the mountain of God, and kissed him. ");
INSERT INTO engULB_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moses told Aaron all the words of Yahweh that he had sent him to say and about all the signs of Yahweh's power that he had commanded him to do. ");
INSERT INTO engULB_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Then Moses and Aaron went and gathered together all the elders of the Israelites. ");
INSERT INTO engULB_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaron spoke all the words that Yahweh had spoken to Moses. He also displayed the signs of Yahweh's power in the sight of the people. ");
INSERT INTO engULB_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","The people believed. When they heard that Yahweh had observed the Israelites and that he had seen their oppression, then they bowed their heads and worshiped him. ");
INSERT INTO engULB_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","After these things happened, Moses and Aaron went to Pharaoh and said, “This is what Yahweh, the God of Israel, says: 'Let my people go, so they can have a festival for me in the wilderness.'” ");
INSERT INTO engULB_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Pharaoh said, “Who is Yahweh? Why should I listen to his voice and let Israel go? I do not know Yahweh; moreover, I will not let Israel go.” ");
INSERT INTO engULB_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","They said, “The God of the Hebrews has met with us. Let us go on a three-day journey into the wilderness and sacrifice to Yahweh our God so that he does not attack us with plague or with the sword.” ");
INSERT INTO engULB_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","But the king of Egypt said to them, “Moses and Aaron, why are you taking the people from their work? Go back to your work.” ");
INSERT INTO engULB_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","He also said, “There are now many people in our land, and you are making them stop their work.” ");
INSERT INTO engULB_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","On that same day, Pharaoh gave a command to the people's taskmasters and foremen. He said, ");
INSERT INTO engULB_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Unlike before, you must no longer give the people straw to make bricks. Let them go and gather straw for themselves. ");
INSERT INTO engULB_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","However, you must still demand from them the same number of bricks as they made before. Do not accept any fewer, because they are lazy. That is why they are calling out and saying, 'Allow us to go and sacrifice to our God.' ");
INSERT INTO engULB_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Increase the workload for the men so that they keep at it and pay no more attention to deceptive words.” ");
INSERT INTO engULB_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","So the people's taskmasters and foremen went out and informed the people. They said, “This is what Pharaoh says: 'I will no longer give you any straw. ");
INSERT INTO engULB_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","You yourselves must go and get straw wherever you can find it, but your workload will not be reduced.'” ");
INSERT INTO engULB_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","So the people scattered throughout all the land of Egypt to gather stubble for straw. ");
INSERT INTO engULB_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","The taskmasters kept urging them and saying, “Finish your work, just as when straw was given to you.” ");
INSERT INTO engULB_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Pharaoh's taskmasters beat the Israelite foremen, those same men whom they had put in charge of the workers. The taskmasters kept asking them, “Why have you not produced all the bricks required of you, either yesterday and today, as you used to do in the past?” ");
INSERT INTO engULB_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","So the Israelite foremen came to Pharaoh and cried out to him. They said, “Why are you treating your servants this way? ");
INSERT INTO engULB_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","No straw is being given to your servants anymore, but they are still telling us, 'Make bricks!' We, your servants, are even beaten now, but it is the fault of your own people.” ");
INSERT INTO engULB_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","But Pharaoh said, “You are lazy! You are lazy! You say, 'Allow us to go sacrifice to Yahweh.' ");
INSERT INTO engULB_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","So now go back to work. No more straw will be given to you, but you must still make the same number of bricks.” ");
INSERT INTO engULB_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","The Israelite foremen saw that they were in trouble when they were told, “You must not reduce the daily number of bricks.” ");
INSERT INTO engULB_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","They met Moses and Aaron, who were standing outside the palace, as they went away from Pharaoh. ");
INSERT INTO engULB_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","They said to Moses and Aaron, “May Yahweh look at you and punish you, because you have made us offensive in the sight of Pharaoh and his servants. You have put a sword in their hand to kill us.” ");
INSERT INTO engULB_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Moses went back to Yahweh and said, “Lord, why have you caused trouble for this people? Why did you send me in the first place? ");
INSERT INTO engULB_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ever since I came to Pharaoh to speak to him in your name, he has caused trouble for this people, and you have not set your people free at all.” ");
INSERT INTO engULB_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Then Yahweh said to Moses, “Now you will see what I will do to Pharaoh. You will see this, for he will let them go because of my strong hand. Because of my strong hand, he will drive them out of his land.” ");
INSERT INTO engULB_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","God spoke to Moses and said to him, “I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","I appeared to Abraham, to Isaac, and to Jacob as God Almighty; but by my name, Yahweh, I was not known to them. ");
INSERT INTO engULB_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","I also established my covenant with them, in order to give them the land of Canaan, the land where they lived as non-citizens, the land in which they wandered about. ");
INSERT INTO engULB_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Moreover, I have heard the groaning of the Israelites whom the Egyptians have enslaved, and I have called to mind my covenant. ");
INSERT INTO engULB_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Therefore, say to the Israelites, 'I am Yahweh. I will bring you out from slavery under the Egyptians, and I will free you from their power. I will rescue you with a display of my power, and with mighty acts of judgment. ");
INSERT INTO engULB_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","I will take you to myself as my people, and I will be your God. You will know that I am Yahweh your God, who brought you out from slavery under the Egyptians. ");
INSERT INTO engULB_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","I will bring you into the land that I swore to give to Abraham, to Isaac, and to Jacob. I will give it to you as a possession. I am Yahweh.'” ");
INSERT INTO engULB_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","When Moses told this to the Israelites, they would not listen to him because of their discouragement about their harsh slavery. ");
INSERT INTO engULB_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Then Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Go tell Pharaoh, king of Egypt, to let the people of Israel go from his land.” ");
INSERT INTO engULB_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Moses said to Yahweh, “If the Israelites have not listened to me, why will Pharaoh listen to me, since I am not good at speaking?” ");
INSERT INTO engULB_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Yahweh spoke to Moses and to Aaron. He gave them a command for the Israelites and for Pharaoh, king of Egypt, to bring the Israelites out of the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","These were the heads of their fathers' houses: The sons of Reuben, the firstborn of Israel, were Hanok, Pallu, Hezron, and Karmi. These were the clan ancestors of Reuben. ");
INSERT INTO engULB_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","The sons of Simeon were Jemuel, Jamin, Ohad, Jakin, Zohar, and Shaul—the son of a Canaanite woman. These were the clan ancestors of Simeon. ");
INSERT INTO engULB_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Here are listed the names of the sons of Levi, together with their descendants. They were Gershon, Kohath, and Merari. Levi lived until he was 137 years old. ");
INSERT INTO engULB_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","The sons of Gershon were Libni and Shimei. ");
INSERT INTO engULB_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","The sons of Kohath were Amram, Izhar, Hebron, and Uzziel. Kohath lived until he was 133 years old. ");
INSERT INTO engULB_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","The sons of Merari were Mahli and Mushi. These became the clan ancestors of the Levites, together with their descendants. ");
INSERT INTO engULB_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram married Jochebed, his father's sister. She bore him Aaron and Moses. Amram lived 137 years and then died. ");
INSERT INTO engULB_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","The sons of Izhar were Korah, Nepheg, and Zichri. ");
INSERT INTO engULB_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","The sons of Uzziel were Mishael, Elzaphan, and Sithri. ");
INSERT INTO engULB_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron married Elisheba, daughter of Amminadab, sister of Nahshon. She bore him Nadab and Abihu, Eleazar and Ithamar. ");
INSERT INTO engULB_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","The sons of Korah were Assir, Elkanah, and Abiasaph. These were the clan ancestors of the Korahites. ");
INSERT INTO engULB_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazar, Aaron's son, married one of the daughters of Putiel. She bore him Phinehas. These were the heads of the fathers' houses among the Levites, together with their descendants. ");
INSERT INTO engULB_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","These two men were the Aaron and Moses to whom Yahweh said, “Bring out the Israelites from the land of Egypt, by their groups of fighting men.” ");
INSERT INTO engULB_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Aaron and Moses spoke to Pharaoh, king of Egypt, to allow them bring out the Israelites from Egypt. These were the same Moses and Aaron. ");
INSERT INTO engULB_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","When Yahweh spoke to Moses in the land of Egypt, ");
INSERT INTO engULB_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","he said to him, “I am Yahweh. Say to Pharaoh, king of Egypt, everything that I will tell you.” ");
INSERT INTO engULB_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","But Moses said to Yahweh, “I am not good at speaking, so why will Pharaoh listen to me?” ");
INSERT INTO engULB_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Yahweh said to Moses, “See, I have made you like a god to Pharaoh. Aaron your brother will be your prophet. ");
INSERT INTO engULB_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","You will say everything that I command you to say. Aaron your brother will speak to Pharaoh so that he will let the people of Israel go from his land. ");
INSERT INTO engULB_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","But I will harden Pharaoh's heart, and I will display many signs of my power, many wonders, in the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","But Pharaoh will not listen to you, so I will put my hand on Egypt and bring out my groups of fighting men, my people, the descendants of Israel, out of the land of Egypt by great acts of punishment. ");
INSERT INTO engULB_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","The Egyptians will know that I am Yahweh when I reach out with my hand on Egypt and bring out the Israelites from among them.” ");
INSERT INTO engULB_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moses and Aaron did so; they did just as Yahweh commanded them. ");
INSERT INTO engULB_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moses was eighty years old, and Aaron eighty-three years old when they spoke to Pharaoh. ");
INSERT INTO engULB_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yahweh said to Moses and to Aaron, ");
INSERT INTO engULB_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“When Pharaoh says to you, 'Do a miracle,' then you will say to Aaron, 'Take your staff and throw it down before Pharaoh, so that it may become a snake.'” ");
INSERT INTO engULB_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Then Moses and Aaron went to Pharaoh, and they did just as Yahweh had commanded. Aaron threw down his staff before Pharaoh and his servants, and it became a snake. ");
INSERT INTO engULB_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Then Pharaoh also called for his wise men and sorcerers. They did the same thing by their magic. ");
INSERT INTO engULB_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Each man threw down his staff, and the staffs became snakes. But Aaron's staff swallowed up their snakes. ");
INSERT INTO engULB_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Pharaoh's heart was hardened, and he did not listen, just as Yahweh had foretold. ");
INSERT INTO engULB_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Yahweh said to Moses, “Pharaoh's heart is hard, and he refuses to let the people go. ");
INSERT INTO engULB_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Go to Pharaoh in the morning when he goes out to the water. Stand on the riverbank to meet him, and take in your hand the staff that had turned into a snake. ");
INSERT INTO engULB_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Say to him, 'Yahweh, the God of the Hebrews, has sent me to you to say, “Let my people go, so that they may worship me in the wilderness. Until now you have not listened.” ");
INSERT INTO engULB_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Yahweh says this: “By this you will know that I am Yahweh. I am going to strike the water of the Nile River with the staff that is in my hand, and the river will be turned to blood. ");
INSERT INTO engULB_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","The fish that are in the river will die, and the river will stink. The Egyptians will not be able to drink water from the river.”'” ");
INSERT INTO engULB_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Then Yahweh said to Moses, “Say to Aaron, 'Take your staff and reach out with your hand over the waters of Egypt, and over their rivers, streams, pools, and all their ponds, so that their water may become blood. Do this so that there will be blood throughout all the land of Egypt, even in containers of wood and stone.'” ");
INSERT INTO engULB_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moses and Aaron did as Yahweh commanded. Aaron raised the staff and struck the water in the river, in the sight of Pharaoh and his servants. All the water in the river turned to blood. ");
INSERT INTO engULB_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","The fish in the river died, and the river began to stink. The Egyptians could not drink water from the river, and the blood was everywhere in the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","But the magicians of Egypt did the same thing with their magic. So Pharaoh's heart was hardened, and he refused to listen to Moses and Aaron, just as Yahweh had said would happen. ");
INSERT INTO engULB_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Then Pharaoh turned and went into his house. He did not even pay attention to this. ");
INSERT INTO engULB_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","All the Egyptians dug around the river for water to drink, but they could not drink the water of the river itself. ");
INSERT INTO engULB_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Seven days passed after Yahweh had attacked the river. ");
INSERT INTO engULB_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Then Yahweh spoke to Moses, “Go to Pharaoh and tell him, 'Yahweh says this: “Let my people go so that they may worship me. ");
INSERT INTO engULB_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","If you refuse to let them go, I will afflict all your country with frogs. ");
INSERT INTO engULB_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","The river will swarm with frogs. They will come up and go into your house, your bedroom, and your bed. They will go into your servants' houses. They will go onto your people, into your ovens, and into your kneading bowls. ");
INSERT INTO engULB_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","The frogs will attack you, your people, and all your servants.”'” ");
INSERT INTO engULB_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Yahweh said to Moses, “Say to Aaron, 'Reach out with your hand and your staff over the rivers, the streams, and the pools, and bring the frogs up over the land of Egypt.'” ");
INSERT INTO engULB_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aaron reached out with his hand over Egypt's waters, and the frogs came up and covered the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","But the magicians did the same with their magic; they brought up frogs over the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Then Pharaoh called for Moses and Aaron and said, “Pray to Yahweh for him to take away the frogs from me and my people. Then I will let the people go, that they may sacrifice to him.” ");
INSERT INTO engULB_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moses said to Pharaoh, “You can have the privilege of telling me when I should pray for you, your servants, and your people, so that the frogs may be removed from you and your houses and stay only in the river.” ");
INSERT INTO engULB_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Pharaoh said, “Tomorrow.” Moses said, “Let it be as you say, so that you may know that there is no one like Yahweh, our God. ");
INSERT INTO engULB_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","The frogs will go from you, your houses, your servants, and your people. They will stay only in the river.” ");
INSERT INTO engULB_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Moses and Aaron went out from Pharaoh. Then Moses cried out to Yahweh concerning the frogs that he had brought on Pharaoh. ");
INSERT INTO engULB_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Yahweh did as Moses asked: The frogs died in the houses, courts, and fields. ");
INSERT INTO engULB_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","The people gathered them together in heaps, and the land stank. ");
INSERT INTO engULB_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","But when Pharaoh saw that there was relief, he hardened his heart and did not listen to Moses and Aaron, just as Yahweh had said that he would do. ");
INSERT INTO engULB_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Yahweh said to Moses, “Say to Aaron, 'Reach out with your staff and strike the dust on the ground, that it may become gnats throughout all the land of Egypt.'” ");
INSERT INTO engULB_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","They did so: Aaron reached out with his hand and his staff. He struck the dust on the ground. Gnats came onto man and beast. All the dust on the ground became gnats throughout the whole land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","The magicians tried with their magic to produce gnats, but they could not. There were gnats on man and beast. ");
INSERT INTO engULB_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Then the magicians said to Pharaoh, “This is the finger of God.” But Pharaoh's heart was hardened, so he refused to listen to them. It was just as Yahweh had said Pharaoh would do. ");
INSERT INTO engULB_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Yahweh said to Moses, “Get up early in the morning and stand in front of Pharaoh as he goes out to the river. Say to him, 'Yahweh says this: “Let my people go so that they may worship me. ");
INSERT INTO engULB_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","But if you do not let my people go, I will send swarms of flies on you, your servants, and your people, and into your houses. The Egyptians' houses will be full of swarms of flies, and even the ground on which they stand will be full of flies. ");
INSERT INTO engULB_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","But on that day I will treat the land of Goshen differently, the land in which my people are living, so that no swarms of flies will be there. This will happen so that you may know that I am Yahweh in the midst of this land. ");
INSERT INTO engULB_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","I will make a distinction between my people and your people. This sign of my power will take place tomorrow.”'” ");
INSERT INTO engULB_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Yahweh did so, and thick swarms of flies came into Pharaoh's house and into his servants' houses. Throughout the whole land of Egypt, the land was ruined because of the swarms of flies. ");
INSERT INTO engULB_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Pharaoh called for Moses and for Aaron and said, “Go, sacrifice to your God in our own land.” ");
INSERT INTO engULB_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moses said, “It is not right for us to do so, for the sacrifices we make to Yahweh our God are something disgusting to the Egyptians. If we make sacrifices right before their eyes that are disgusting to the Egyptians, will they not stone us? ");
INSERT INTO engULB_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","No, it is a three days' journey into the wilderness that we must make, in order to sacrifice to Yahweh our God, as he commands us.” ");
INSERT INTO engULB_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Pharaoh said, “I will allow you to go and sacrifice to Yahweh your God in the wilderness. Only you must not go very far away. Pray for me.” ");
INSERT INTO engULB_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moses said, “As soon as I go out from you, I will pray to Yahweh that the swarms of flies may leave you, Pharaoh, and your servants and people tomorrow. But you must not deal deceitfully any more by not letting our people go to sacrifice to Yahweh.” ");
INSERT INTO engULB_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Moses went out from Pharaoh and prayed to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Yahweh did as Moses asked; and he removed the swarms of flies from Pharaoh, his servants, and his people. Not one remained. ");
INSERT INTO engULB_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","But Pharaoh hardened his heart this time also, and he did not let the people go. ");
INSERT INTO engULB_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Then Yahweh said to Moses, “Go to Pharaoh and tell him, 'Yahweh, the God of the Hebrews, says this: “Let my people go so that they may worship me.” ");
INSERT INTO engULB_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","But if you refuse to let them go, if you still keep them back, ");
INSERT INTO engULB_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","then Yahweh's hand will be on your cattle in the fields and on the horses, donkeys, camels, herds, and flocks, and it will cause a terrible disease. ");
INSERT INTO engULB_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Yahweh will treat Israel's cattle and Egypt's cattle differently and no animal that belongs to the Israelites will die. ");
INSERT INTO engULB_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Yahweh has fixed a time; he has said, “It is tomorrow that I will do this thing in the land.”'” ");
INSERT INTO engULB_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Yahweh did this the next day: All the cattle of Egypt died, but none of the Israelites' animals died, not one animal. ");
INSERT INTO engULB_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Pharaoh investigated, and, behold, not even one animal of the Israelites died. But his heart was stubborn, so he did not let the people go. ");
INSERT INTO engULB_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Then Yahweh said to Moses and to Aaron, “Take some handfuls of ashes from a kiln. You, Moses, must throw the ashes up into the air while Pharaoh is watching. ");
INSERT INTO engULB_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","They will become fine dust over all the land of Egypt. They will cause blisters and sores to break out on people and animals throughout all the land of Egypt.” ");
INSERT INTO engULB_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","So Moses and Aaron took ashes from a kiln and stood in front of Pharaoh. Then Moses threw the ashes up into the air. The ashes caused blisters and sores to break out on people and animals. ");
INSERT INTO engULB_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","The magicians could not resist Moses because of the blisters, because the blisters were on them and on all the other Egyptians. ");
INSERT INTO engULB_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Yahweh hardened Pharaoh's heart, so Pharaoh did not listen to Moses and Aaron. This was just as Yahweh had said to Moses that Pharaoh would do. ");
INSERT INTO engULB_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Then Yahweh said to Moses, “Get up early in the morning, stand in front of Pharaoh, and say to him, 'Yahweh, the God of the Hebrews, says this: “Let my people go so that they may worship me. ");
INSERT INTO engULB_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","For this time I will send all my plagues on you yourself, on your servants and your people. I will do this so that you may know that there is no one like me in all the earth. ");
INSERT INTO engULB_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","By now I could have reached out with my hand and attacked you and your people with disease, and you would have been eradicated from the land. ");
INSERT INTO engULB_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","But it was for this reason I allowed you to survive: In order to show you my power, so that my name may be proclaimed throughout all the earth. ");
INSERT INTO engULB_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","You are still lifting yourself up against my people by not letting them go. ");
INSERT INTO engULB_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Listen! Tomorrow about this time I will bring a very strong hail storm, such as has not been seen in Egypt since the day it was begun until now. ");
INSERT INTO engULB_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Now then, send men and gather your cattle and everything you have in the fields to a safe place. Every man and animal that is in the field and is not brought home—the hail will come down on them, and they will die.”'” ");
INSERT INTO engULB_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Then those of Pharaoh's servants who believed in Yahweh's message hurried to bring their slaves and cattle into the houses. ");
INSERT INTO engULB_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","But those who did not take Yahweh's message seriously left their slaves and cattle in the fields. ");
INSERT INTO engULB_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Then Yahweh said to Moses, “Reach out with your hand toward the sky so that there will be hail in all the land of Egypt, on people, on animals, and on all the plants in the fields throughout the land of Egypt.” ");
INSERT INTO engULB_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moses reached out with his staff toward the sky, and Yahweh sent thunder, hail, and lightning to the ground. He also rained hail on the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","So there were hail and lightning mixed with hail, very severe, such as had not been in all the land of Egypt since it became a nation. ");
INSERT INTO engULB_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Throughout all the land of Egypt, the hail struck everything in the fields, both people and animals. It struck every plant in the fields and broke every tree. ");
INSERT INTO engULB_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Only in the land of Goshen, where the Israelites lived, was there no hail. ");
INSERT INTO engULB_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Then Pharaoh sent men to summon Moses and Aaron. He said to them, “I have sinned this time. Yahweh is righteous, and I and my people are wicked. ");
INSERT INTO engULB_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Pray to Yahweh, because the mighty thunderbolts and hail are too much. I will let you go, and you will stay here no longer.” ");
INSERT INTO engULB_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moses said to him, “As soon as I leave the city, I will spread my hands out to Yahweh. The thunder will stop, and there will not be any more hail. In this way you will know that the earth belongs to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","But as for you and your servants, I know that you do not yet really honor Yahweh God.” ");
INSERT INTO engULB_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Now the flax and the barley were ruined, for the barley was maturing in the ear, and the flax was in bloom. ");
INSERT INTO engULB_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","But the wheat and the spelt were not harmed because they were later crops. ");
INSERT INTO engULB_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","When Moses had left Pharaoh and the city, he spread out his hands to Yahweh; the thunder and hail stopped, and the rain came down no more. ");
INSERT INTO engULB_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","When Pharaoh saw that the rain, hail, and thunder had ceased, he sinned again and hardened his heart, together with his servants. ");
INSERT INTO engULB_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Pharaoh's heart was hardened, so he did not let the people of Israel go. This was the way that Yahweh had said to Moses that Pharaoh would act. ");
INSERT INTO engULB_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Yahweh said to Moses, “Go to Pharaoh, for I have hardened his heart and the hearts of his servants. I have done this to show these signs of my power among them. ");
INSERT INTO engULB_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","I have also done this so that you may tell your children and grandchildren the things I have done, how I have harshly treated Egypt, and how I have given various signs of my power among them. In this way you will know that I am Yahweh.” ");
INSERT INTO engULB_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","So Moses and Aaron went to Pharaoh and said to him, “Yahweh, the God of the Hebrews, says this: 'How long will you refuse to humble yourself before me? Let my people go so that they may worship me. ");
INSERT INTO engULB_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","But if you refuse to let my people go, listen, tomorrow I will bring locusts into your land. ");
INSERT INTO engULB_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","They will cover the surface of the ground so that no one will be able to see the earth. They will eat the remains of whatever escaped from the hail. They will also eat every tree that grows for you in the fields. ");
INSERT INTO engULB_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","They will fill your houses, those of all your servants, and those of all the Egyptians—something neither your father nor your grandfather ever saw, nothing ever seen since the day that they were on the earth to this present day.'” Then Moses left and went out from Pharaoh. ");
INSERT INTO engULB_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Pharaoh's servants said to him, “How long will this man be a menace to us? Let the Israelites go so that they may worship Yahweh their God. Do you not yet realize that Egypt is destroyed?” ");
INSERT INTO engULB_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Moses and Aaron were brought again to Pharaoh, who said to them, “Go worship Yahweh your God. But what people will go?” ");
INSERT INTO engULB_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moses said, “We will go with our young and with our old, with our sons and our daughters. We will go with our flocks and herds, for we must hold a festival for Yahweh.” ");
INSERT INTO engULB_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Pharaoh said to them, “May Yahweh indeed be with you, if I ever let you go and your little ones go. Look, you have some evil in mind. ");
INSERT INTO engULB_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","No! Go, just the men among you, and worship Yahweh, for that is what you want.” Then Moses and Aaron were driven out from Pharaoh's presence. ");
INSERT INTO engULB_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Then Yahweh said to Moses, “Reach out with your hand over the land of Egypt to the locusts, that they may attack the land of Egypt and eat every plant in it, everything that the hail has left.” ");
INSERT INTO engULB_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moses reached out with his staff over the land of Egypt, and Yahweh brought an east wind over the land all that day and night. When it was morning, the east wind had brought the locusts. ");
INSERT INTO engULB_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","The locusts went through all the land of Egypt and infested all parts of it. Never before had there been such a swarm of locusts in the land, and nothing like this will come after it. ");
INSERT INTO engULB_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","They covered the surface of the whole land so that it was darkened. They ate every plant in the land and all the fruit of the trees that the hail had left. Throughout all the land of Egypt, no living green plant remained, nor any tree or plant in the fields. ");
INSERT INTO engULB_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Then Pharaoh quickly summoned Moses and Aaron and said, “I have sinned against Yahweh your God and against you. ");
INSERT INTO engULB_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Now then, forgive my sin this time, and pray to Yahweh your God that he will take this death away from me.” ");
INSERT INTO engULB_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","So Moses went out from Pharaoh and prayed to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Yahweh brought a very strong west wind that picked up the locusts and drove them into the Sea of Reeds; not a single locust remained in all the territory of Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","But Yahweh hardened Pharaoh's heart, and Pharaoh did not let the Israelites go. ");
INSERT INTO engULB_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Then Yahweh said to Moses, “Reach out with your hand toward the sky, so that there may be darkness over the land of Egypt, darkness that may be felt.” ");
INSERT INTO engULB_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moses reached out with his hand toward the sky, and there was a thick darkness in all the land of Egypt for three days. ");
INSERT INTO engULB_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","No one could see anyone else; no one left his home for three days. However, all the Israelites had light in the place where they lived. ");
INSERT INTO engULB_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Pharaoh summoned Moses and said, “Go worship Yahweh. Even your families may go with you, but your flocks and herds must remain behind.” ");
INSERT INTO engULB_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","But Moses said, “You must also give us animals for sacrifices and burnt offerings so that we may sacrifice them to Yahweh our God. ");
INSERT INTO engULB_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Our cattle must also go with us; not a hoof of them may be left behind, for we must take them to worship Yahweh our God. For we do not know with what we must worship Yahweh until we arrive there.” ");
INSERT INTO engULB_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","But Yahweh hardened Pharaoh's heart, and he would not let them go. ");
INSERT INTO engULB_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Pharaoh said to Moses, “Go from me! Be careful about one thing, that you do not see me again, for on the day you see my face, you will die.” ");
INSERT INTO engULB_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moses said, “You yourself have spoken. I will not see your face again.” ");
INSERT INTO engULB_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Then Yahweh said to Moses, “There is still one more plague that I will bring on Pharaoh and Egypt. After that, he will let you go from here. When he finally lets you go, he will drive you away completely. ");
INSERT INTO engULB_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Instruct the people that every man and woman is to ask of his or her neighbor for articles of silver and articles of gold.” ");
INSERT INTO engULB_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Now Yahweh had made the Egyptians eager to please the Israelites. Moreover, the man Moses was very impressive in the sight of Pharaoh's servants and the people of Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moses said, “Yahweh says this: 'About midnight I will go throughout Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","All the firstborn in the land of Egypt will die, from the firstborn of Pharaoh, who sits on his throne, to the firstborn of the slave girl who is behind the handmill grinding it, and to all the firstborn of the cattle. ");
INSERT INTO engULB_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Then there will be a great wailing throughout all the land of Egypt, such as has never been nor ever will be again. ");
INSERT INTO engULB_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","But not even a dog will bark against any of the people of Israel, against either man or beast. In this way you will know that I am treating the Egyptians and the Israelites differently.' ");
INSERT INTO engULB_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","All these servants of yours, Pharaoh, will come down to me and bow down to me. They will say, 'Go, you and all the people who follow you!' After that I will go out.” Then he went out from Pharaoh in great anger. ");
INSERT INTO engULB_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Yahweh said to Moses, “Pharaoh will not listen to you. This is so that I will do many amazing things in the land of Egypt.” ");
INSERT INTO engULB_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moses and Aaron did all these wonders before Pharaoh. But Yahweh hardened Pharaoh's heart, and Pharaoh did not let the people of Israel go out of his land. ");
INSERT INTO engULB_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Yahweh spoke to Moses and Aaron in the land of Egypt. He said, ");
INSERT INTO engULB_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“For you, this month will be the start of months, the first month of the year to you. ");
INSERT INTO engULB_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Tell the assembly of Israel, 'On the tenth day of this month they must each take a lamb or young goat for themselves, each family doing this, a lamb for each household. ");
INSERT INTO engULB_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","If the household is too small for a lamb, the man and his next door neighbor are to take lamb or young goat meat that will be enough for the number of the people. It should be enough for everyone to eat, so they must take enough meat to feed them all. ");
INSERT INTO engULB_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Your lamb or young goat must be without blemish, a one-year-old male. You may take one of the sheep or goats. ");
INSERT INTO engULB_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","You must keep it until the fourteenth day of that month. Then the whole assembly of Israel must kill these animals at twilight. ");
INSERT INTO engULB_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","You must take some of the blood and put it on the two side doorposts and on the tops of the doorframes of the houses in which you will eat the meat. ");
INSERT INTO engULB_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","You must eat the meat that night, after first roasting it over a fire. Eat it with bread made without yeast, along with bitter herbs. ");
INSERT INTO engULB_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Do not eat it raw or boiled in water. Instead, roast it over fire with its head, legs and inner parts. ");
INSERT INTO engULB_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","You must not let any of it be left over until morning. You must burn whatever is left over in the morning. ");
INSERT INTO engULB_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","This is how you must eat it: with your belt fastened, your shoes on your feet, and your staff in your hand. You must eat it hurriedly. It is Yahweh's Passover. ");
INSERT INTO engULB_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Yahweh says this: I will go through the land of Egypt in that night and attack all the firstborn of man and animal in the land of Egypt. I will bring punishment on all the gods of Egypt. I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","The blood will be a sign on your houses for my coming to you. When I see the blood, I will pass over you when I attack the land of Egypt. This plague will not come on you and destroy you. ");
INSERT INTO engULB_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","This day will become a memorial day for you, which you must observe as a festival for Yahweh. It will always be a law for you, throughout your people's generations, that you must observe this day. ");
INSERT INTO engULB_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","You will eat bread without yeast during seven days. On the first day you will remove the yeast from your houses. Whoever eats leavened bread from the first day until the seventh day, that person must be cut off from Israel. ");
INSERT INTO engULB_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","On the first day there will be an assembly that is set apart to me, and on the seventh day there will be another such gathering. No work will be done on these days, except the cooking for everyone to eat. That must be the only work that may be done by you. ");
INSERT INTO engULB_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","You must observe this Festival of Unleavened Bread because it is on this day that I will have brought your people, armed group by armed group, out of the land of Egypt. So you must observe this day throughout your people's generations. This will always be a law for you. ");
INSERT INTO engULB_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","You must eat unleavened bread from twilight of the fourteenth day in the first month of the year, until twilight of the twenty-first day of the month. ");
INSERT INTO engULB_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","During these seven days, no yeast must be found in your houses. Whoever eats bread made with yeast must be cut off from the community of Israel, whether that person is a foreigner or someone born in your land. ");
INSERT INTO engULB_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","You must eat nothing made with yeast. Wherever you live, you must eat bread made without yeast.'” ");
INSERT INTO engULB_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Then Moses summoned all the elders of Israel and said to them, “Go and select lambs or kids that will be enough to feed your families and kill the Passover lamb. ");
INSERT INTO engULB_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Then take a bunch of hyssop and dip it in the blood that will be in a basin. Apply the blood in the basin to the top of the doorframe and the two doorposts. None of you is to go out of the door of his house until the morning. ");
INSERT INTO engULB_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","For Yahweh will pass through to attack the Egyptians. When he sees the blood on the top of the doorframe and on the two doorposts, he will pass over your door and not permit the destroyer to come into your houses to attack you. ");
INSERT INTO engULB_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","You must observe this event. This will always be a law for you and your descendants. ");
INSERT INTO engULB_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","When you enter the land that Yahweh will give you, just as he has promised to do, you must observe this act of worship. ");
INSERT INTO engULB_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","When your children ask you, 'What does this act of worship mean?' ");
INSERT INTO engULB_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","then you must say, 'It is the sacrifice of Yahweh's Passover, because Yahweh passed over the Israelites' houses in Egypt when he attacked the Egyptians. He set our households free.'” Then the people bowed down and worshiped Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","The Israelites went and did exactly as Yahweh had commanded Moses and Aaron. ");
INSERT INTO engULB_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","It happened at midnight that Yahweh attacked all the firstborn in the land of Egypt, from the firstborn of Pharaoh, who sat on his throne, to the firstborn of the person in prison and all the firstborn of cattle. ");
INSERT INTO engULB_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Pharaoh got up in the night—he, all his servants, and all the Egyptians. There was loud lamenting in Egypt, for there was not a house where there was not someone dead. ");
INSERT INTO engULB_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Pharaoh summoned Moses and Aaron in the night and said, “Get up, get out from among my people, you and the Israelites. Go, worship Yahweh, as you have said you wanted to do. ");
INSERT INTO engULB_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Take your flocks and your herds, as you have said, and go, and also bless me.” ");
INSERT INTO engULB_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","The Egyptians were in a great hurry to send them out of the land, for they said, “We will all die.” ");
INSERT INTO engULB_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","So the people took their dough without adding any yeast. Their kneading bowls were already tied up in their clothes and on their shoulders. ");
INSERT INTO engULB_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Now the people of Israel did as Moses told them. They asked the Egyptians for articles of silver, articles of gold, and clothing. ");
INSERT INTO engULB_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Yahweh made the Egyptians eager to please the Israelites. So the Egyptians gave them whatever they asked for. In this way, the Israelites plundered the Egyptians. ");
INSERT INTO engULB_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","The Israelites journeyed from Rameses to Succoth. They numbered about 600,000 men on foot, in addition to the women and children. ");
INSERT INTO engULB_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","A mixed multitude also went with them, together with flocks and herds, a very large number of livestock. ");
INSERT INTO engULB_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","They baked bread without yeast in the dough that they brought from Egypt. It was without yeast because they had been driven out of Egypt and could not delay to prepare food. ");
INSERT INTO engULB_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","The Israelites had lived in Egypt for 430 years. ");
INSERT INTO engULB_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","At the end of 430 years, on that very day, all of Yahweh's armed groups went out from the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","This was a night to stay awake, for Yahweh to bring them out from the land of Egypt. This was Yahweh's night to be observed by all the Israelites throughout their people's generations. ");
INSERT INTO engULB_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yahweh said to Moses and Aaron, “Here is the rule for the Passover: No foreigner may share in eating it. ");
INSERT INTO engULB_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","However, every Israelite's slave, bought with money, may eat it after you have circumcised him. ");
INSERT INTO engULB_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Foreigners and hired servants must not eat any of the food. ");
INSERT INTO engULB_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","The food must be eaten in one house. You must not carry any of the meat out of the house, and you must not break any bone of it. ");
INSERT INTO engULB_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","All the community of Israel must observe the festival. ");
INSERT INTO engULB_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","If a foreigner lives with you and wants to observe the Passover to Yahweh, all his male relatives must be circumcised. Then he may come and observe it. He will become like the people who were born in the land. However, no uncircumcised person may eat any of the food. ");
INSERT INTO engULB_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","This same law will apply to both the native born and to the foreigner who lives among you.” ");
INSERT INTO engULB_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","So all the Israelites did exactly as Yahweh had commanded Moses and Aaron. ");
INSERT INTO engULB_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","It came about that very day that Yahweh brought Israel out of the land of Egypt by their armed groups. ");
INSERT INTO engULB_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Then Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Set apart to me all the firstborn, every firstborn male among the Israelites, both of people and animals. The firstborn belongs to me.” ");
INSERT INTO engULB_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moses said to the people, “Call this day to mind, the day on which you came out from Egypt, out of the house of slavery, for by Yahweh's strong hand he brought you out from this place. No bread with yeast may be eaten. ");
INSERT INTO engULB_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","You are going out of Egypt on this day, in the month of Aviv. ");
INSERT INTO engULB_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","When Yahweh brings you into the land of the Canaanites, Hittites, Amorites, Hivites, and the Jebusites, the land that he swore to your ancestors to give you, a land flowing with milk and honey—then you must observe this act of worship in this month. ");
INSERT INTO engULB_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","For seven days you must eat bread without yeast; on the seventh day there will be a feast to honor Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Bread without yeast must be eaten throughout the seven days; no bread with yeast may be seen among you. No yeast may be seen with you within any of your borders. ");
INSERT INTO engULB_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","On that day you are to say to your children, 'This is because of what Yahweh did for me when I came out of Egypt.' ");
INSERT INTO engULB_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","This will be a reminder for you on your hand, and a reminder on your forehead. This is so the law of Yahweh may be in your mouth, for with a strong hand Yahweh brought you out of Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Therefore you must keep this law at its appointed time from year to year. ");
INSERT INTO engULB_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","When Yahweh brings you into the land of the Canaanites, as he swore to you and to your ancestors to do, and when he gives the land to you, ");
INSERT INTO engULB_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","you must set apart to Yahweh the first offspring of every womb. All the firstborn offspring of your animals that are males, will belong to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Every firstborn of a donkey you must buy back with a lamb. If you do not buy it back, then you must break its neck. But each of your firstborn males among all your sons—you must buy them back. ");
INSERT INTO engULB_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","When your son asks you later, 'What does this mean?' then you are to tell him, 'It was by a strong hand that Yahweh brought us out from Egypt, from the house of slavery. ");
INSERT INTO engULB_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","When Pharaoh stubbornly refused to let us go, Yahweh killed all the firstborn in the land of Egypt, both the firstborn of people and the firstborn of animals. That is why I sacrifice to Yahweh the firstborn male of every animal, and why I buy back the firstborn of my sons.' ");
INSERT INTO engULB_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","This will become a reminder on your hands, and a reminder on your forehead, for it was by a strong hand Yahweh brought us out of Egypt.” ");
INSERT INTO engULB_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","When Pharaoh let the people go, God did not lead them by way of the land of the Philistines, although that land was nearby. For God said, “Perhaps the people will change their minds when they experience war and will then return to Egypt.” ");
INSERT INTO engULB_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","So God led the people around through the wilderness to the Sea of Reeds. The Israelites went up out of the land of Egypt armed for battle. ");
INSERT INTO engULB_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moses took the bones of Joseph with him, for Joseph had made the Israelites solemnly swear and said, “God will surely rescue you, and you must carry away my bones with you.” ");
INSERT INTO engULB_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","The Israelites journeyed from Succoth and camped at Etham on the edge of the wilderness. ");
INSERT INTO engULB_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Yahweh went before them by day in a pillar of cloud to lead them on the way. By night he went in a pillar of fire to give them light. In this way they could travel by day and by night. ");
INSERT INTO engULB_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Yahweh did not take away from before the people the daytime pillar of cloud or the nighttime pillar of fire. ");
INSERT INTO engULB_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Then Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Say to the Israelites that they should turn and camp before Pi Hahiroth, between Migdol and the sea, before Baal Zephon. You are to camp by the sea opposite Pi Hahiroth. ");
INSERT INTO engULB_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Pharaoh will say about the Israelites, 'They are wandering in the land. The wilderness has closed in on them.' ");
INSERT INTO engULB_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","I will harden Pharaoh's heart, and he will pursue them. I will get honor because of Pharaoh and all his army. The Egyptians will know that I am Yahweh.” So the Israelites camped as they were instructed. ");
INSERT INTO engULB_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","When the king of Egypt was told that the Israelites had fled, the minds of Pharaoh and his servants turned against the people. They said, “What have we done? We have released Israel from serving us.” ");
INSERT INTO engULB_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Then Pharaoh got his chariots ready and took his army with him. ");
INSERT INTO engULB_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","He took six hundred chosen chariots and all the other chariots of Egypt, with officers on all of them. ");
INSERT INTO engULB_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Yahweh hardened the heart of Pharaoh, king of Egypt, and the king pursued the Israelites. Now the Israelites had gone away in triumph. ");
INSERT INTO engULB_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","But the Egyptians pursued them, together with all his horses and chariots, his horsemen, and his army. They overtook the Israelites camping by the sea beside Pi Hahiroth, before Baal Zephon. ");
INSERT INTO engULB_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","When Pharaoh came close, the Israelites looked up and were surprised. The Egyptians were marching after them, and they were terrified. The Israelites cried out to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","They said to Moses, “Is it because there were no graves in Egypt, that you have taken us away to die in the wilderness? Why have you treated us like this, bringing us out of Egypt? ");
INSERT INTO engULB_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Is this not what we told you in Egypt? We said to you, 'Leave us alone, so we can work for the Egyptians.' It would have been better for us to work for them than to die in the wilderness.” ");
INSERT INTO engULB_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moses said to the people, “Do not be afraid. Stand still and see the rescue that Yahweh will provide for you today. For you will never see again the Egyptians whom you see today. ");
INSERT INTO engULB_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yahweh will fight for you, and you will only have to stand still.” ");
INSERT INTO engULB_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Then Yahweh said to Moses, “Why are you, Moses, continuing to call out to me? Tell the Israelites to go forward. ");
INSERT INTO engULB_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Lift up your staff, reach out with your hand over the sea and divide it in two, so that the people of Israel may go through the sea on dry ground. ");
INSERT INTO engULB_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Be aware that I will harden the Egyptians' hearts so they will go after them. I will get honor because of Pharaoh and all his army, his chariots, and his horsemen. ");
INSERT INTO engULB_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Then the Egyptians will know that I am Yahweh when I have gotten honor because of Pharaoh, his chariots, and his horsemen.” ");
INSERT INTO engULB_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","The angel of God, who went before the Israelites, moved and went behind them. The pillar of cloud moved from before them and went to stand behind them. ");
INSERT INTO engULB_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","The cloud came between the camp of Egypt and the camp of Israel. It was a dark cloud to the Egyptians, but it lit the night for the Israelites, so one side did not come near the other all night. ");
INSERT INTO engULB_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moses reached out with his hand over the sea. Yahweh drove the sea back by a strong east wind all that night and made the sea into dry land. In this way the waters were divided. ");
INSERT INTO engULB_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","The Israelites went into the middle of the sea on dry ground. The waters formed a wall for them on their right hand and on their left. ");
INSERT INTO engULB_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","The Egyptians pursued them. They went after them into the middle of the sea—all Pharaoh's horses, chariots, and horsemen. ");
INSERT INTO engULB_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","But in the early morning hours, Yahweh looked down on the Egyptian army through the pillar of fire and cloud. He caused panic among the Egyptians. ");
INSERT INTO engULB_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Their chariot wheels were clogged, and the horsemen drove with difficulty. So the Egyptians said, “Let us flee from Israel, for Yahweh is fighting for them against us.” ");
INSERT INTO engULB_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Yahweh said to Moses, “Reach out with your hand over the sea so that the waters may come back onto the Egyptians, their chariots, and their horsemen.” ");
INSERT INTO engULB_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","So Moses reached out with his hand over the sea, and it returned to its normal course when the morning appeared. The Egyptians fled into the sea, and Yahweh drove the Egyptians into the middle of it. ");
INSERT INTO engULB_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","The waters came back and covered Pharaoh's chariots, horsemen, and his entire army that had followed the chariots into the sea. No one survived. ");
INSERT INTO engULB_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","However, the Israelites walked on dry land in the middle of the sea. The waters were a wall for them on their right hand and on their left. ");
INSERT INTO engULB_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","So Yahweh saved Israel that day out of the hand of the Egyptians, and Israel saw dead Egyptians on the seashore. ");
INSERT INTO engULB_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","When Israel saw the great power that Yahweh used against the Egyptians, the people honored Yahweh, and they trusted in Yahweh and in his servant Moses. ");
INSERT INTO engULB_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Then Moses and the people of Israel sang this song to Yahweh. They sang, “I will sing to Yahweh, for he has triumphed gloriously; the horse and its rider he has thrown into the sea. ");
INSERT INTO engULB_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yahweh is my strength and song, and he has become my salvation. This is my God, and I will praise him, my father's God, and I will exalt him. ");
INSERT INTO engULB_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yahweh is a warrior; Yahweh is his name. ");
INSERT INTO engULB_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","He has thrown Pharaoh's chariots and army into the sea. Pharaoh's chosen officers were drowned in the Sea of Reeds. ");
INSERT INTO engULB_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","The depths covered them; they went down into the depths like a stone. ");
INSERT INTO engULB_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Your right hand, Yahweh, is glorious in power; your right hand, Yahweh, has shattered the enemy. ");
INSERT INTO engULB_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","In great majesty you overthrew those who rose up against you. You sent out your wrath; it consumed them like stubble. ");
INSERT INTO engULB_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","By the blast of your nostrils the waters were piled up; the flowing waters stood upright in a heap; the deep water was congealed in the heart of the sea. ");
INSERT INTO engULB_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","The enemy said, 'I will pursue, I will overtake, I will share out the plunder; my desire will be satisfied on them; I will draw my sword; my hand will destroy them.' ");
INSERT INTO engULB_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","But you blew with your wind, and the sea covered them; they sank like lead in the mighty waters. ");
INSERT INTO engULB_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Who is like you, Yahweh, among the gods? Who is like you, majestic in holiness, honored in praises, doing miracles? ");
INSERT INTO engULB_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","You reached out with your right hand, and the earth swallowed them. ");
INSERT INTO engULB_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","In your covenant loyalty you have led the people you have rescued. In your strength you have led them to the holy place where you live. ");
INSERT INTO engULB_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","The peoples will hear, and they will tremble; terror will seize the inhabitants of Philistia. ");
INSERT INTO engULB_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Then the chiefs of Edom will fear; the soldiers of Moab will shake; all the inhabitants of Canaan will melt away. ");
INSERT INTO engULB_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Terror and dread will fall on them. Because of your arm's power, they will become as still as a stone until your people pass by, Yahweh— until the people you have rescued pass by. ");
INSERT INTO engULB_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","You will bring them and plant them on the mountain of your inheritance, the place, Yahweh, that you have made to live in, the sanctuary, our Lord, that your hands have built. ");
INSERT INTO engULB_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yahweh will reign forever and ever.” ");
INSERT INTO engULB_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","For Pharaoh's horses went with his chariots and horsemen into the sea. Yahweh brought back the waters of the sea on them. But the Israelites walked on dry land in the middle of the sea. ");
INSERT INTO engULB_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Miriam the prophetess, sister of Aaron, picked up a tambourine, and all the women went out with tambourines, dancing along with her. ");
INSERT INTO engULB_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam sang to them: “Sing to Yahweh, for he has triumphed gloriously. The horse and his rider he has thrown into the sea.” ");
INSERT INTO engULB_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Then Moses led Israel onward from the Sea of Reeds. They went out into the wilderness of Shur. They traveled for three days into the wilderness and found no water. ");
INSERT INTO engULB_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Then they came to Marah, but they could not drink the water there because it was bitter. So they called that place Marah. ");
INSERT INTO engULB_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","So the people complained to Moses and said, “What can we drink?” ");
INSERT INTO engULB_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Moses cried out to Yahweh, and Yahweh showed him a tree. Moses threw it into the water, and the water became sweet to drink. It was there that Yahweh gave them a strict law, and it was there that he tested them. ");
INSERT INTO engULB_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","He said, “If you carefully listen to the voice of Yahweh your God, and do what is right in his eyes, and if you give ear to his commands and obey all his laws—I will put on you none of the diseases that I put on the Egyptians, for I am Yahweh who heals you.” ");
INSERT INTO engULB_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Then the people came to Elim, where there were twelve springs of water and seventy palm trees. They camped there by the water. ");
INSERT INTO engULB_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","The people journeyed on from Elim, and all the community of Israelites came to the wilderness of Sin, which is between Elim and Sinai, on the fifteenth day of the second month after their departure from the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","The whole community of Israelites complained against Moses and Aaron in the wilderness. ");
INSERT INTO engULB_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","The Israelites said to them, “If only we had died by Yahweh's hand in the land of Egypt when we were sitting by the pots of meat and were eating bread to the full. For you have brought us out into this wilderness to kill our whole community with hunger.” ");
INSERT INTO engULB_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Then Yahweh said to Moses, “I will rain down bread from heaven for you. The people will go out and gather a day's portion every day so that I may test them to see whether or not they will walk in my law. ");
INSERT INTO engULB_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","It will come about on the sixth day, that they will gather twice as much as what they gathered every day before, and they will cook what they bring in.” ");
INSERT INTO engULB_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Then Moses and Aaron said to all the people of Israel, “In the evening you will know that it is Yahweh who has brought you out from the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","In the morning you will see Yahweh's glory, for he hears your complaining against him. Who are we for you to complain against us?” ");
INSERT INTO engULB_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Moses also said, “You will know this when Yahweh gives you meat in the evening and bread in the morning to the full—for he has heard the complaints that you speak against him. Who are Aaron and I? Your complaints are not against us; they are against Yahweh.” ");
INSERT INTO engULB_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Moses said to Aaron, “Say to all the community of the people of Israel, 'Come near before Yahweh, for he has heard your complaints.'” ");
INSERT INTO engULB_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","It came about, as Aaron spoke to the whole community of the people of Israel, that they looked toward the wilderness, and, behold, Yahweh's glory appeared in the cloud. ");
INSERT INTO engULB_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Then Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“I have heard the complaints of the people of Israel. Speak to them and say, 'In the evening you will eat meat, and in the morning you will be filled with bread. Then you will know that I am Yahweh your God.'” ");
INSERT INTO engULB_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","It came about in the evening that quails came up and covered the camp. In the morning the dew lay round about the camp. ");
INSERT INTO engULB_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","When the dew was gone, there on the surface of the wilderness were thin flakes like frost on the ground. ");
INSERT INTO engULB_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","When the people of Israel saw it, they said one to another, “What is it?” They did not know what it was. Moses said to them, “It is the bread that Yahweh has given you to eat. ");
INSERT INTO engULB_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","This is the command that Yahweh has given: 'You must gather, each one of you, the amount you need to eat, an omer for each person of the number of your people. This is how you will gather it: Gather enough to eat for every person who lives in your tent.'” ");
INSERT INTO engULB_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","The people of Israel did so. Some gathered more, some gathered less. ");
INSERT INTO engULB_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","When they measured it with an omer measure, those who had gathered much had nothing left over, and those who had gathered little had no lack. Each person gathered enough to meet their need. ");
INSERT INTO engULB_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Then Moses said to them, “No one must leave any of it until morning.” ");
INSERT INTO engULB_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","However, they did not listen to Moses. Some of them left some of it until morning, but it bred worms and became foul. Then Moses became angry with them. ");
INSERT INTO engULB_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","They gathered it morning by morning. Each person gathered enough to eat for that day. When the sun became hot, it melted. ");
INSERT INTO engULB_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","It came about that on the sixth day they gathered twice as much bread, two omers for each person. All the leaders of the community came and told this to Moses. ");
INSERT INTO engULB_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","He said to them, “This is what Yahweh has said: 'Tomorrow is a solemn rest, a holy Sabbath in Yahweh's honor. Bake what you want to bake, and boil what you want to boil. All that remains over, set it aside for yourselves until morning.'” ");
INSERT INTO engULB_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","So they set it aside until morning, as Moses had instructed. It did not become foul, nor was there any worm in it. ");
INSERT INTO engULB_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moses said, “Eat that food today, for today is a day reserved as a Sabbath to honor Yahweh. Today you will not find it in the fields. ");
INSERT INTO engULB_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","You will gather it during six days, but the seventh day is the Sabbath. On the Sabbath there will be no manna.” ");
INSERT INTO engULB_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","It came about on the seventh day that some of the people went out to gather manna, but they found none. ");
INSERT INTO engULB_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Then Yahweh said to Moses, “How long will you refuse to keep my commandments and my laws? ");
INSERT INTO engULB_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","See, Yahweh has given you the Sabbath. So on the sixth day he is giving you bread for two days. Each of you must stay in his own place; no one must go out from his place on the seventh day.” ");
INSERT INTO engULB_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","So the people rested on the seventh day. ");
INSERT INTO engULB_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","The people of Israel called that food “manna.” It was white like coriander seed, and its taste was like wafers made with honey. ");
INSERT INTO engULB_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moses said, “This is what Yahweh has commanded: 'Let an omer of manna be kept throughout your people's generations so that your descendants might see the bread with which I fed you in the wilderness, after I brought you out from the land of Egypt.'” ");
INSERT INTO engULB_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Moses said to Aaron, “Take a pot and put an omer of manna into it. Preserve it before Yahweh to be kept throughout the people's generations.” ");
INSERT INTO engULB_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","As Yahweh commanded Moses, Aaron stored it beside the covenant decrees in the ark. ");
INSERT INTO engULB_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","The people of Israel ate manna forty years until they came to inhabited land. They ate it until they came to the borders of the land of Canaan. ");
INSERT INTO engULB_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Now an omer is a tenth of an ephah. ");
INSERT INTO engULB_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","The whole community of the Israelites journeyed from the wilderness of Sin, following Yahweh's instructions. They camped at Rephidim, but there was no water for the people to drink. ");
INSERT INTO engULB_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","So the people blamed Moses for their situation and said, “Give us water to drink.” Moses said, “Why do you quarrel with me? Why do you test Yahweh?” ");
INSERT INTO engULB_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","The people were very thirsty, and they complained against Moses. They said, “Why have you brought us up out of Egypt? To kill us and our children and our cattle with thirst?” ");
INSERT INTO engULB_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Then Moses cried out to Yahweh, “What should I do with this people? They are almost ready to stone me.” ");
INSERT INTO engULB_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yahweh said to Moses, “Go on ahead of the people, and take with you some elders of Israel. Take with you the staff with which you struck the river, and go. ");
INSERT INTO engULB_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","I will stand before you there on the rock at Horeb, and you will strike the rock. Water will come out of it for the people to drink.” Then Moses did so in the sight of the elders of Israel. ");
INSERT INTO engULB_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","He called that place Massah and Meribah because of the Israelites' complaining, and because they had tested the Lord by saying, “Is Yahweh among us or not?” ");
INSERT INTO engULB_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Then an army of the Amalek people came and attacked Israel at Rephidim. ");
INSERT INTO engULB_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","So Moses said to Joshua, “Choose some men and go out. Fight with Amalek. Tomorrow I will stand on top of the hill with the staff of God in my hand.” ");
INSERT INTO engULB_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","So Joshua fought Amalek as Moses had instructed, while Moses, Aaron, and Hur went up to the top of the hill. ");
INSERT INTO engULB_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","While Moses was holding his hands up, Israel was winning; when he let his hands rest, Amalek would begin to win. ");
INSERT INTO engULB_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","When Moses' hands became heavy, Aaron and Hur took a stone and put it under him for him to sit on. At the same time, Aaron and Hur held his hands up, one person on one side of him, and the other person on the other side. So Moses' hands were held steady until the sun went down. ");
INSERT INTO engULB_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","So Joshua defeated the people of Amalek with the sword. ");
INSERT INTO engULB_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Yahweh said to Moses, “Write this in a book and read it in Joshua's hearing, because I will completely blot out the memory of Amalek from under the skies.” ");
INSERT INTO engULB_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Then Moses built an altar and he called it “Yahweh is my banner.” ");
INSERT INTO engULB_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","He said, “For a hand was lifted up to the throne of Yahweh—that Yahweh will wage war with Amalek from generation to generation.” ");
INSERT INTO engULB_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jethro, the priest of Midian, Moses' father-in-law, heard of all that God had done for Moses and for Israel his people. He heard that Yahweh had brought Israel out of Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Jethro, Moses' father-in-law, took Zipporah, Moses' wife, after he had sent her home, ");
INSERT INTO engULB_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","and her two sons; the name of the one son was Gershom, for Moses had said, “I have been a foreigner in a foreign land.” ");
INSERT INTO engULB_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","The name of the other was Eliezer, for Moses had said, “My ancestor's God was my help. He rescued me from Pharaoh's sword.” ");
INSERT INTO engULB_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jethro, Moses' father-in-law, came with Moses' sons and his wife to Moses in the wilderness where he was camped at the mountain of God. ");
INSERT INTO engULB_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","He said to Moses, “I, your father-in-law Jethro, am coming to you with your wife and her two sons.” ");
INSERT INTO engULB_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moses went out to meet his father-in-law, bowed down, and kissed him. They asked about each other's welfare and then went into the tent. ");
INSERT INTO engULB_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moses told his father-in-law all that Yahweh had done to Pharaoh and the Egyptians for Israel's sake, about all the hardships that had come to them along the way, and how Yahweh had rescued them. ");
INSERT INTO engULB_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jethro rejoiced over all the good that Yahweh had done for Israel, in that he had rescued them from the hand of the Egyptians. ");
INSERT INTO engULB_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jethro said, “May Yahweh be praised, for he has rescued you from the hand of the Egyptians and from the hand of Pharaoh, and delivered the people from the hand of the Egyptians. ");
INSERT INTO engULB_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Now I know that Yahweh is greater than all the gods, because when the Egyptians treated the Israelites arrogantly, God rescued his people.” ");
INSERT INTO engULB_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Jethro, Moses' father-in-law, brought a burnt offering and sacrifices for God. Aaron and all the elders of Israel came to eat a meal before God with Moses' father-in-law. ");
INSERT INTO engULB_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","On the next day Moses sat down to judge the people. The people stood around him from morning until evening. ");
INSERT INTO engULB_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","When Moses' father-in-law saw all that he did for the people, he said, “What is this that you are doing with the people? Why is it that you sit alone and all the people stand about you from morning until evening?” ");
INSERT INTO engULB_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moses said to his father-in-law, “The people come to me to ask for God's direction. ");
INSERT INTO engULB_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","When they have a dispute, they come to me. I decide between one person and another, and I teach them God's statutes and laws.” ");
INSERT INTO engULB_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Moses' father-in-law said to him, “What you are doing is not very good. ");
INSERT INTO engULB_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","You will surely wear yourselves out, you and the people who are with you. This burden is too heavy for you. You are not able to do it by yourself. ");
INSERT INTO engULB_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Listen to me. I will give you advice, and God will be with you, because you are the people's representative to God, and you bring their disputes to him. ");
INSERT INTO engULB_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","You must teach them his statutes and laws. You must show them the way to walk and the work to do. ");
INSERT INTO engULB_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Furthermore, you must choose capable men from all the people, men who honor God, men of truth who hate unjust gain. You must put them over people, to be leaders in charge of thousands, hundreds, fifties, and of tens. ");
INSERT INTO engULB_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","They will judge the people in all routine cases, but the difficult cases they will bring to you. As for all the small cases, they can judge those themselves. In that way it will be easier for you, and they will carry the burden with you. ");
INSERT INTO engULB_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","If you do this, and if God commands you to do so, then you will be able to endure, and the entire people will be able to go home satisfied.” ");
INSERT INTO engULB_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","So Moses listened to his father-in-law's words and did everything that he had said. ");
INSERT INTO engULB_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Moses chose capable men from all Israel and made them heads over the people, leaders in charge of thousands, hundreds, fifties, and tens. ");
INSERT INTO engULB_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","They judged the people in normal circumstances. The difficult cases they brought to Moses, but they themselves judged all the small cases. ");
INSERT INTO engULB_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Then Moses let his father-in-law leave, and Jethro went back into his own land. ");
INSERT INTO engULB_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","In the third month after the people of Israel had gone out from the land of Egypt, on the same day, they came to the wilderness of Sinai. ");
INSERT INTO engULB_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","After they left Rephidim and came to the wilderness of Sinai, they camped in the wilderness in front of the mountain. ");
INSERT INTO engULB_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moses went up to God. Yahweh called to him from the mountain and said, “You must tell the house of Jacob, the people of Israel: ");
INSERT INTO engULB_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","You have seen what I did to the Egyptians, how I carried you on eagles' wings and brought you to myself. ");
INSERT INTO engULB_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Now then, if you obediently listen to my voice and keep my covenant, then you will be my special possession from among all peoples, for all the earth is mine. ");
INSERT INTO engULB_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","You will be a kingdom of priests and a holy nation for me. These are the words that you must speak to the people of Israel.” ");
INSERT INTO engULB_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","So Moses came and summoned the elders of the people. He set before them all these words that Yahweh had commanded him. ");
INSERT INTO engULB_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","All the people answered together and said, “We will do everything that Yahweh has said.” Then Moses came to report the people's words to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Yahweh said to Moses, “I will come to you in a thick cloud so that the people may hear when I speak with you and may also believe you forever.” Then Moses told the people's words to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Yahweh said to Moses, “Go to the people. Today and tomorrow you must set them apart to me, and make them wash their garments. ");
INSERT INTO engULB_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Be ready for the third day, for on the third day Yahweh will come down to Mount Sinai. ");
INSERT INTO engULB_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","You must set boundaries all around the mountain for the people. Say to them, 'Be careful that you do not go up the mountain or touch its border. Whoever touches the mountain will surely be put to death.' ");
INSERT INTO engULB_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","No one's hand must touch such a person. Instead, he must certainly be stoned or shot. Whether it is a person or an animal, he must be put to death. When the trumpet sounds a long blast, they may come up to the foot of the mountain.” ");
INSERT INTO engULB_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Then Moses went down from the mountain to the people. He set apart the people to Yahweh and they washed their garments. ");
INSERT INTO engULB_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","He said to the people, “Be ready on the third day; do not go near your wives.” ");
INSERT INTO engULB_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","On the third day, when it was morning, there were thunder and lightning bolts and a thick cloud on the mountain, and the sound of a very loud trumpet. All the people in the camp trembled. ");
INSERT INTO engULB_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moses brought the people out of the camp to meet God, and they stood at the foot of the mountain. ");
INSERT INTO engULB_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Mount Sinai was completely covered with smoke because Yahweh descended on it in fire and smoke. The smoke went up like the smoke of a furnace, and the whole mountain shook violently. ");
INSERT INTO engULB_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","When the sound of the trumpet grew louder and louder, Moses spoke, and God answered him in a voice. ");
INSERT INTO engULB_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yahweh came down on Mount Sinai, to the top of the mountain, and he summoned Moses to the top. So Moses went up. ");
INSERT INTO engULB_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Yahweh said to Moses, “Go down and warn the people not to break through to me to look, or many of them will perish. ");
INSERT INTO engULB_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Let the priests also who come near to me set themselves apart—prepare themselves for my coming—so that I do not attack them.” ");
INSERT INTO engULB_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moses said to Yahweh, “The people cannot come up to Mount Sinai, for you commanded us: 'Set boundaries around the mountain and set it apart to Yahweh.'” ");
INSERT INTO engULB_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yahweh said to him, “Go, get down the mountain, and bring up Aaron with you, but do not let the priests and the people break through the barrier to come up to me, or I will attack them.” ");
INSERT INTO engULB_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","So Moses went down to the people and spoke to them. ");
INSERT INTO engULB_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","God spoke all these words: ");
INSERT INTO engULB_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“I am Yahweh your God, who brought you out of the land of Egypt, out of the house of slavery. ");
INSERT INTO engULB_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","You must have no other gods before me. ");
INSERT INTO engULB_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","You must not make for yourself a carved figure nor the likeness of anything that is in heaven above, or that is in the earth beneath, or that is in the water below. ");
INSERT INTO engULB_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","You must not bow down to them or worship them, for I, Yahweh your God, am a jealous God. I punish the ancestors' wickedness by bringing punishment on the descendants, to the third and the fourth generation of those who hate me. ");
INSERT INTO engULB_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","But I show covenant faithfulness to thousands of those who love me and keep my commandments. ");
INSERT INTO engULB_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","You must not take the name of Yahweh your God, in vain, for I will not hold guiltless anyone who takes my name in vain. ");
INSERT INTO engULB_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Remember the Sabbath day, to set it apart to me. ");
INSERT INTO engULB_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","You must labor and do all your work for six days. ");
INSERT INTO engULB_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","But the seventh day is a Sabbath for Yahweh your God. On it you must not do any work, you, or your son, or your daughter, or your male servant, or your female servant, or your cattle, or the foreigner who is within your gates. ");
INSERT INTO engULB_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","For in six days Yahweh made the heavens and earth, the sea, and everything that is in them, and rested on the seventh day. Therefore Yahweh blessed the Sabbath day and set it apart. ");
INSERT INTO engULB_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Honor your father and your mother, so that you may live a long time in the land that Yahweh your God is giving you. ");
INSERT INTO engULB_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","You must not murder anyone. ");
INSERT INTO engULB_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","You must not commit adultery. ");
INSERT INTO engULB_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","You must not steal from anyone. ");
INSERT INTO engULB_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","You must not give false testimony against your neighbor. ");
INSERT INTO engULB_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","You must not covet your neighbor's house; you must not covet your neighbor's wife, his male servant, his female servant, his ox, his donkey, or anything that belongs to your neighbor.” ");
INSERT INTO engULB_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","All the people saw the thundering and the lightning, and heard the voice of the trumpet, and saw the mountain smoking. When the people saw it, they trembled and stood far off. ");
INSERT INTO engULB_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","They said to Moses, “Speak to us, and we will listen; but do not let God speak to us, or we will die.” ");
INSERT INTO engULB_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moses said to the people, “Do not be afraid, for God has come to test you so that the honor of him may be in you, and so that you do not sin.” ");
INSERT INTO engULB_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","So the people stood far off, and Moses approached the thick darkness where God was. ");
INSERT INTO engULB_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Yahweh said to Moses, “This is what you must tell the Israelites: 'You yourselves have seen that I have talked with you from heaven. ");
INSERT INTO engULB_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","You will not make for yourselves other gods alongside me, gods of silver or gods of gold. ");
INSERT INTO engULB_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","You must make an earthen altar for me, and you must sacrifice on it your burnt offerings, fellowship offerings, sheep, and oxen. In every place where I cause my name to be honored, I will come to you and bless you. ");
INSERT INTO engULB_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","If you make me an altar of stone, you must not build it of cut stones, for if you use your tools on it, you will have defiled it. ");
INSERT INTO engULB_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","You must not go up to my altar on steps, so that your nakedness is not exposed.'” ");
INSERT INTO engULB_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Now these are the decrees that you must set before them: ");
INSERT INTO engULB_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","'If you buy a Hebrew servant, he is to serve for six years, and in the seventh year he will go free without paying anything. ");
INSERT INTO engULB_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","If he came by himself, he must go free by himself; if he is married, then his wife must go free with him. ");
INSERT INTO engULB_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","If his master gave him a wife and she bore him sons or daughters, the wife and her children will belong to her master, and he must go free by himself. ");
INSERT INTO engULB_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","But if the servant plainly says, “I love my master, my wife, and my children; I will not go out free,” ");
INSERT INTO engULB_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","then his master must bring him to God. The master must bring him to a door or doorpost, and his master must bore his ear through with an awl. Then the servant will serve him for life. ");
INSERT INTO engULB_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","If a man sells his daughter as a female servant, she must not go free as the male servants do. ");
INSERT INTO engULB_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","If she does not please her master, who has designated her for himself, then he must let her be bought back. He has no right to sell her to a foreign people. He has no such right, since he has treated her deceitfully. ");
INSERT INTO engULB_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","If her master designates her as a wife for his son, he must treat her the same as if she were his daughter. ");
INSERT INTO engULB_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","If he takes another wife for himself, he must not diminish her food, clothing, or her marital rights. ");
INSERT INTO engULB_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","But if he does not provide these three things for her, then she can go free without paying any money. ");
INSERT INTO engULB_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Whoever strikes a man so that he dies, that person must surely be put to death. ");
INSERT INTO engULB_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","If the man did not do it with premeditation, but instead by accident, then I will fix a place to where he can flee. ");
INSERT INTO engULB_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","If a man willfully attacks his neighbor and kills him according to a cunning plan, then you must take him, even if he is at God's altar, so that he may die. ");
INSERT INTO engULB_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Whoever hits his father or mother must surely be put to death. ");
INSERT INTO engULB_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Whoever kidnaps a person—whether the kidnapper sells him, or that person is found in his hand—that kidnapper must be put to death. ");
INSERT INTO engULB_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Whoever curses his father or his mother must surely be put to death. ");
INSERT INTO engULB_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","If men fight and one hits the other with a stone or with his fist, and that person does not die, but is confined to his bed; ");
INSERT INTO engULB_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","then if he recovers and is able to walk about using his staff, the man who struck him must pay for the loss of his time; he must also pay for his complete recovery. But that man is not guilty of murder. ");
INSERT INTO engULB_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","If a man hits his male servant or his female servant with a staff, and if the servant dies as a result of the blow, then that man must surely be punished. ");
INSERT INTO engULB_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","However, if the servant lives for a day or two, the master must not be punished, for he will have suffered the loss of the servant. ");
INSERT INTO engULB_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","If men fight together and hurt a pregnant woman so that she miscarries, but there is no other injury to her, then the guilty man must surely be fined as the woman's husband demands it from him, and he must pay as the judges determine. ");
INSERT INTO engULB_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","But if there is serious injury, then you must give a life for a life, ");
INSERT INTO engULB_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","an eye for an eye, a tooth for a tooth, a hand for a hand, a foot for a foot, ");
INSERT INTO engULB_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","a burn for a burn, a wound for a wound, or a bruise for a bruise. ");
INSERT INTO engULB_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","If a man hits the eye of his male servant or of his female servant and destroys it, then he must let the servant go free in compensation for his eye. ");
INSERT INTO engULB_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","If he knocks out a tooth of his male servant or female servant, he must let the servant go free as compensation for the tooth. ");
INSERT INTO engULB_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","If an ox gores a man or a woman to death, the ox must surely be stoned, and its flesh must not be eaten; but the ox's owner must be acquitted of guilt. ");
INSERT INTO engULB_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","But if the ox had a habit of goring in the past, and its owner was warned but did not keep it in, and the ox has killed a man or a woman, that ox must be stoned, and its owner also must be put to death. ");
INSERT INTO engULB_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","If a payment is required for his life, he must pay whatever he is required to pay. ");
INSERT INTO engULB_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","If the ox has gored a man's son or daughter, the ox's owner must do what this decree requires him to do. ");
INSERT INTO engULB_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","If the ox gores a male servant or a female servant, the ox's owner must pay thirty shekels of silver, and the ox must be stoned. ");
INSERT INTO engULB_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","If a man opens a pit, or if a man digs a pit and does not cover it, and an ox or a donkey falls into it, ");
INSERT INTO engULB_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","the owner of the pit must repay the loss. He must give money to the dead animal's owner, and the dead animal will become his. ");
INSERT INTO engULB_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","If one man's ox hurts another man's ox so that it dies, then they must sell the live ox and divide its price, and they must also divide the dead ox. ");
INSERT INTO engULB_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","But if it was known that the ox had a habit of goring in time past, and its owner has not kept it in, he must surely pay ox for ox, and the dead animal will become his own. ");
INSERT INTO engULB_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","If a man steals an ox or a sheep and kills it or sells it, then he must pay five oxen for one ox, and four sheep for one sheep. ");
INSERT INTO engULB_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","If a thief is found breaking in, and if he is struck so that he dies, in that case no guilt for murder will attach to anyone on his account. ");
INSERT INTO engULB_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","But if the sun has risen before he breaks in, guilt for murder will attach to the person who kills him. A thief must make restitution. If he has nothing, then he must be sold for his theft. ");
INSERT INTO engULB_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","If the stolen animal is found alive in his possession, whether it is an ox, a donkey, or a sheep, he must pay back double. ");
INSERT INTO engULB_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","If a man grazes his livestock in a field or vineyard and lets his animal loose, and it grazes in another man's field, he must make restitution from the best of his own field and from the best of his own vineyard. ");
INSERT INTO engULB_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","If a fire breaks out and spreads in thorns so that stacked grain, or standing grain, or a field is consumed, the one who started the fire must surely make restitution. ");
INSERT INTO engULB_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","If a man gives money or goods to his neighbor for safe keeping, and if it is stolen out of the man's house, if the thief is found, that thief must pay double. ");
INSERT INTO engULB_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","But if the thief is not found, then the owner of the house must come before the judges to see whether he has put his own hand on his neighbor's property. ");
INSERT INTO engULB_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","For every dispute about something, whether it is an ox, a donkey, a sheep, clothing, or any other missing thing about which one says, “This belongs to me,” the claim of both parties must come before the judges. The man whom the judges find guilty must pay double to his neighbor. ");
INSERT INTO engULB_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","If a man gives his neighbor a donkey, an ox, a sheep, or any animal to keep, and if it dies or is hurt or is carried away without anyone seeing it, ");
INSERT INTO engULB_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","an oath to Yahweh must be taken by them both, as to whether or not one person has put his hand on his neighbor's property. The owner must accept this, and the other will make no restitution. ");
INSERT INTO engULB_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","But if it was stolen from him, the other must make restitution to the owner for it. ");
INSERT INTO engULB_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","If an animal was torn in pieces, let the other man bring the animal as evidence. He will not have to pay for what was torn. ");
INSERT INTO engULB_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","If a man borrows any animal from his neighbor and the animal is injured or dies without the owner being with it, the other man must surely make restitution. ");
INSERT INTO engULB_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","But if the owner was with it, the other man will not have to pay; if the animal was hired, it will be paid for by its hiring fee. ");
INSERT INTO engULB_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","If a man seduces a virgin who is not engaged, and if he sleeps with her, he must surely make her his wife by paying the bride wealth required for this. ");
INSERT INTO engULB_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","If her father completely refuses to give her to him, he must pay money equal to the bride wealth of virgins. ");
INSERT INTO engULB_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","You must not allow a sorceress to live. ");
INSERT INTO engULB_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Whoever sleeps with a beast must surely be put to death. ");
INSERT INTO engULB_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Whoever sacrifices to any god except to Yahweh must be completely destroyed. ");
INSERT INTO engULB_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","You must not wrong a foreigner or oppress him, for you were foreigners in the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","You must not mistreat any widow or fatherless child. ");
INSERT INTO engULB_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","If you afflict them at all, and if they call out to me, I will surely hear their call. ");
INSERT INTO engULB_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","My anger will burn, and I will kill you with the sword; your wives will become widows, and your children will become fatherless. ");
INSERT INTO engULB_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","If you lend money to any of my people among you who are poor, you must not be like a moneylender to him or charge him interest. ");
INSERT INTO engULB_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","If you take your neighbor's garment in pledge, you must return it to him before the sun goes down, ");
INSERT INTO engULB_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","for that is his only covering; it is his garment for his body. What else can he sleep in? When he calls out to me, I will hear him, for I am compassionate. ");
INSERT INTO engULB_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","You must not blaspheme me, God, nor curse a ruler of your people. ");
INSERT INTO engULB_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","You must not hold back offerings from your harvest or your winepresses. You must give to me the firstborn of your sons. ");
INSERT INTO engULB_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","You must also do the same with your oxen and your sheep. For seven days they may remain with their mothers, but on the eighth day you must give them to me. ");
INSERT INTO engULB_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","You will be people that are set apart for me. So you must not eat any meat that was torn by animals in the field. Instead, you must throw it to the dogs. ");
INSERT INTO engULB_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","You must not give a false report about anyone. Do not join with a wicked man to be a dishonest witness. ");
INSERT INTO engULB_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","You must not follow a crowd to do evil, nor may you bear witness while siding with the crowd in order to pervert justice. ");
INSERT INTO engULB_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","You must not show favoritism to a poor man in his lawsuit. ");
INSERT INTO engULB_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","If you meet your enemy's ox or his donkey going astray, you must bring it back to him. ");
INSERT INTO engULB_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","If you see the donkey of someone who hates you fallen to the ground under its load, you must not leave that person. You must surely help him with his donkey. ");
INSERT INTO engULB_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Do not thrust aside justice for your poor in his lawsuit. ");
INSERT INTO engULB_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Do not join others in making false accusations, and do not kill the innocent or righteous, for I will not acquit the wicked. ");
INSERT INTO engULB_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Never take a bribe, for a bribe blinds those who see, and perverts honest people's words. ");
INSERT INTO engULB_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","You must not oppress a foreigner, since you know the life of a foreigner, for you were foreigners in the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","For six years you will sow seed on your land and gather in its produce. ");
INSERT INTO engULB_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","But in the seventh year you will leave it unplowed and fallow, so that the poor among your people may eat. What they leave, the wild animals will eat. You will do the same with your vineyards and olive orchards. ");
INSERT INTO engULB_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","During six days you will do your work, but on the seventh day you must rest. Do this so that your ox and your donkey may have rest, and so that your female slave's son and any foreigner may rest and be refreshed. ");
INSERT INTO engULB_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Pay attention to everything that I have said to you. Do not mention the names of other gods, nor let their names be heard from your mouth. ");
INSERT INTO engULB_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","You must travel to hold a festival for me three times every year. ");
INSERT INTO engULB_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","You are to observe the Festival of Unleavened Bread. As I commanded you, you will eat unleavened bread for seven days. At that time, you will appear before me in the month of Aviv, which is fixed for this purpose. It was in this month that you came out from Egypt. But you must not appear before me empty-handed. ");
INSERT INTO engULB_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","You must observe the Festival of Harvest, the firstfruits of your labors when you sowed seed in the fields. Also you must observe the Festival of Ingathering at the end of the year, when you gather in your produce from the fields. ");
INSERT INTO engULB_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","All your males must appear before the Lord Yahweh three times every year. ");
INSERT INTO engULB_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","You must not offer the blood from sacrifices made to me with bread containing yeast. The fat from the sacrifices at my festivals must not remain all night until the morning. ");
INSERT INTO engULB_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","You must bring the choicest firstfruits from your land into my house, the house of Yahweh your God. You must not boil a young goat in its mother's milk. ");
INSERT INTO engULB_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","I am going to send an angel before you to guard you on the way, and to bring you to the place that I have prepared. ");
INSERT INTO engULB_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Be attentive to him and obey him. Do not provoke him, for he will not pardon your transgressions. My name is on him. ");
INSERT INTO engULB_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","If you indeed obey his voice and do everything that I tell you, then I will be an enemy to your enemies and an adversary to your adversaries. ");
INSERT INTO engULB_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","My angel will go before you and bring you to the Amorites, Hittites, Perizzites, Canaanites, Hivites, and the Jebusites. I will destroy them. ");
INSERT INTO engULB_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","You must not bow down to their gods, worship them, or do as they do. Instead, you must completely overthrow them and smash their stone pillars in pieces. ");
INSERT INTO engULB_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","You must worship Yahweh your God, and he will bless your bread and water. I will remove sickness from among you. ");
INSERT INTO engULB_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","No woman will be barren or will miscarry her young in your land. I will give you long lives. ");
INSERT INTO engULB_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","I will send fear of myself on those into whose land you advance. I will kill all the people whom you meet. I will make all your enemies turn their backs to you in fright. ");
INSERT INTO engULB_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","I will send hornets before you that will drive out the Hivites, Canaanites, and the Hittites from before you. ");
INSERT INTO engULB_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","I will not drive them out from before you in one year, or the land would become abandoned, and the wild animals would become too many for you. ");
INSERT INTO engULB_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Instead, I will drive them out little by little from before you until you become fruitful and inherit the land. ");
INSERT INTO engULB_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","I will fix your borders from the Sea of Reeds to the Sea of the Philistines, and from the wilderness to the Euphrates River. I will give you victory over the land's inhabitants. You will drive them out before yourselves. ");
INSERT INTO engULB_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","You must not make a covenant with them or with their gods. ");
INSERT INTO engULB_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","They must not live in your land, or they would make you sin against me. If you worship their gods, this will surely become a trap for you.'” ");
INSERT INTO engULB_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Then Yahweh said to Moses, “Come up to me—you, Aaron, Nadab, Abihu, and seventy of Israel's elders, and worship me at a distance. ");
INSERT INTO engULB_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Moses alone may come near to me. The others must not come near, nor may the people come up with him.” ");
INSERT INTO engULB_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moses went and told the people all of Yahweh's words and decrees. All the people answered with one voice and said, “We will do all the words that Yahweh has said.” ");
INSERT INTO engULB_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Then Moses wrote down all of Yahweh's words. Early in the morning, Moses built an altar at the foot of the mountain and arranged twelve stone pillars, so that the stones would represent the twelve tribes of Israel. ");
INSERT INTO engULB_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","He sent some Israelite young men to offer burnt offerings and sacrifice fellowship offerings of oxen to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moses took half of the blood and put it into basins; he sprinkled the other half onto the altar. ");
INSERT INTO engULB_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","He took the book of the Covenant and read it aloud to the people. They said, “We will do all that Yahweh has spoken. We will be obedient.” ");
INSERT INTO engULB_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Then Moses took the blood and sprinkled it onto the people. He said, “This is the blood of the covenant that Yahweh has made with you by giving you this promise with all these words.” ");
INSERT INTO engULB_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Then Moses, Aaron, Nadab, Abihu, and seventy of Israel's elders went up the mountain. ");
INSERT INTO engULB_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","They saw the God of Israel. Under his feet there was a pavement made of sapphire stone, as clear as the sky itself. ");
INSERT INTO engULB_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","God did not lay a hand on the Israelite leaders. They saw God, and they ate and drank. ");
INSERT INTO engULB_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Yahweh said to Moses, “Come up to me on the mountain and stay there. I will give you the tablets of stone and the law and commandments that I have written, so that you may teach them.” ");
INSERT INTO engULB_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","So Moses set out with his assistant Joshua and went up the mountain of God. ");
INSERT INTO engULB_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Moses had said to the elders, “Stay here and wait for us until we come to you. Aaron and Hur are with you. If anyone has a dispute, let him go to them.” ");
INSERT INTO engULB_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","So Moses went up the mountain, and the cloud covered it. ");
INSERT INTO engULB_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Yahweh's glory settled on Mount Sinai, and the cloud covered it for six days. On the seventh day he called to Moses from within the cloud. ");
INSERT INTO engULB_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","The appearance of Yahweh's glory was like a devouring fire on the top of the mountain in the eyes of the Israelites. ");
INSERT INTO engULB_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moses entered the cloud and went up the mountain. He was up the mountain for forty days and forty nights. ");
INSERT INTO engULB_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Yahweh said to Moses, ");
INSERT INTO engULB_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Tell the Israelites to take an offering for me from every person who is motivated by a willing heart. You must receive these offerings for me. ");
INSERT INTO engULB_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","These are the offerings that you must receive from them: gold, silver, and bronze; ");
INSERT INTO engULB_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","blue, purple, and scarlet material; fine linen; goats' hair; ");
INSERT INTO engULB_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ram skins dyed red and sea cow hides; acacia wood; ");
INSERT INTO engULB_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","oil for the sanctuary lamps; spices for the anointing oil and the fragrant incense; ");
INSERT INTO engULB_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","onyx stones and other precious stones to be set for the ephod and breastpiece. ");
INSERT INTO engULB_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Let them make me a sanctuary so that I may live among them. ");
INSERT INTO engULB_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","You must make it exactly as I will show you in the plans for the tabernacle and for all its equipment. ");
INSERT INTO engULB_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","They are to make an ark of acacia wood. Its length must be two and a half cubits; its width will be one cubit and a half; and its height will be one cubit and a half. ");
INSERT INTO engULB_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","You must cover it inside and out with pure gold, and you must make on it a border of gold around its top. ");
INSERT INTO engULB_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","You must cast four rings of gold for it, and put them on the ark's four feet, with two rings on one side of it, and two rings on the other side. ");
INSERT INTO engULB_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","You must make poles of acacia wood and cover them with gold. ");
INSERT INTO engULB_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","You must put the poles into the rings on the ark's sides, in order to carry the ark. ");
INSERT INTO engULB_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","The poles must remain in the rings of the ark; they must not be taken from it. ");
INSERT INTO engULB_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","You must put into the ark the covenant decrees that I will give you. ");
INSERT INTO engULB_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","You must make an atonement lid of pure gold. Its length must be two and a half cubits, and its width must be a cubit and a half. ");
INSERT INTO engULB_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","You must make two cherubim of hammered gold for the two ends of the atonement lid. ");
INSERT INTO engULB_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Make one cherub for one end of the atonement lid, and the other cherub for the other end. They must be made as one piece with the atonement lid. ");
INSERT INTO engULB_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","The cherubim must spread out their wings upward and overshadow the atonement lid with them. The cherubim must face one another and look toward the center of the atonement lid. ");
INSERT INTO engULB_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","You must put the atonement lid on top of the ark, and you must put into the ark the covenant decrees that I am giving you. ");
INSERT INTO engULB_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","It is at the ark that I will meet with you. I will speak with you from my position above the atonement lid. It will be from between the two cherubim over the ark of the testimony that I will speak to you about all the commands I will give you for the Israelites. ");
INSERT INTO engULB_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","You must make a table of acacia wood. Its length must be two cubits; its width must be one cubit, and its height must be a cubit and a half. ");
INSERT INTO engULB_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","You must cover it with pure gold and put a border of gold around the top. ");
INSERT INTO engULB_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","You must make a surrounding frame for it one handbreadth wide, with a surrounding border of gold for the frame. ");
INSERT INTO engULB_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","You must make for it four rings of gold and attach the rings to the four corners, where the four feet were. ");
INSERT INTO engULB_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","The rings must be attached to the frame to provide places for the poles, in order to carry the table. ");
INSERT INTO engULB_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","You must make the poles out of acacia wood and cover them with gold so that the table may be carried with them. ");
INSERT INTO engULB_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","You must make the dishes, spoons, pitchers, and bowls to be used to pour out drink offerings. You must make them of pure gold. ");
INSERT INTO engULB_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","You must regularly set the bread of the presence on the table before me. ");
INSERT INTO engULB_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","You must make a lampstand of pure hammered gold. The lampstand is to be made with its base and shaft. Its cups, its leafy bases, and its flowers are to be all made of one piece with it. ");
INSERT INTO engULB_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Six branches must extend out from its sides—three branches must extend from one side, and three branches of the lampstand must extend from the other side. ");
INSERT INTO engULB_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","The first branch must have three cups made like almond blossoms, with a leafy base and a flower, and three cups made like almond blossoms in the other branch, with a leafy base and a flower. It must be the same for all six branches extending out from the lampstand. ");
INSERT INTO engULB_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","On the lampstand itself, the central shaft, there must be four cups made like almond blossoms, with their leafy bases and the flowers. ");
INSERT INTO engULB_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","There must be a leafy base under the first pair of branches—made as one piece with it, and a leafy base under the second pair of branches—also made as one piece with it. In the same way there must be a leafy base under the third pair of branches, made as one piece with it. It must be the same for all six branches extending out from the lampstand. ");
INSERT INTO engULB_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Their leafy bases and branches must all be one piece with it, one beaten piece of work of pure gold. ");
INSERT INTO engULB_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","You must make the lampstand and its seven lamps, and set up its lamps for them to give light from it. ");
INSERT INTO engULB_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","The tongs and their trays must be made of pure gold. ");
INSERT INTO engULB_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Use one talent of pure gold to make the lampstand and its accessories. ");
INSERT INTO engULB_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Be sure to make them after the pattern that you are being shown on the mountain. ");
INSERT INTO engULB_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","You must make the tabernacle with ten curtains made from fine linen and blue, purple, and scarlet wool with the designs of cherubim. This will be the work of a very skilled craftsman. ");
INSERT INTO engULB_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","The length of each curtain must be twenty-eight cubits, the width four cubits. All the curtains must be of the same size. ");
INSERT INTO engULB_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Five curtains must be joined to each other, and the other five curtains must also be joined to each other. ");
INSERT INTO engULB_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","You must make loops of blue along the outer edge of the end curtain of one set. In the same way, you must do the same along the outer edge of the end curtain in the second set. ");
INSERT INTO engULB_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","You must make fifty loops on the first curtain, and you must make fifty loops on the end curtain in the second set. Do this so that the loops will be opposite to each other. ");
INSERT INTO engULB_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","You must make fifty clasps of gold and join the curtains together with them so that the tabernacle becomes united. ");
INSERT INTO engULB_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","You must make curtains of goats' hair for a tent over the tabernacle. You must make eleven of these curtains. ");
INSERT INTO engULB_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","The length of each curtain must be thirty cubits, and the width of each curtain must be four cubits. Each of the eleven curtains must be of the same size. ");
INSERT INTO engULB_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","You must join five curtains to each other and the other six curtains to each other. You must double over the sixth curtain in the front of the tent. ");
INSERT INTO engULB_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","You must make fifty loops on the edge of the end curtain of the first set, and fifty loops on the edge of the end curtain that joins the second set. ");
INSERT INTO engULB_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","You must make fifty bronze clasps and put them into the loops. Then you join the tent together so that it may be one piece. ");
INSERT INTO engULB_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","The leftover half curtain, that is, the overhanging part remaining from the tent's curtains, must hang at the back of the tabernacle. ");
INSERT INTO engULB_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","There must be one cubit of curtain on one side, and one cubit of curtain on the other side—that which is left over of the length of the tent's curtains must hang over the sides of the tabernacle on one side and on the other side, to cover it. ");
INSERT INTO engULB_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","You must make for the tabernacle a covering of ram skins dyed red, and another covering of fine leather to go above that. ");
INSERT INTO engULB_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","You must make upright frames out of acacia wood for the tabernacle. ");
INSERT INTO engULB_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","The length of each frame must be ten cubits, and its width must be one and a half cubits. ");
INSERT INTO engULB_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","There must be two wooden pegs in each frame for joining the frames to each other. You are to make all the tabernacle's frames in this way. ");
INSERT INTO engULB_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","When you make the frames for the tabernacle, you must make twenty frames for the south side. ");
INSERT INTO engULB_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","You must make forty silver bases to go under the twenty frames. There must be two bases under the first frame to be its two pedestals, and also two bases under each of the other frames for their two pedestals. ");
INSERT INTO engULB_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","For the second side of the tabernacle, on the north side, you must make twenty frames ");
INSERT INTO engULB_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","and their forty silver bases. There must be two bases under the first frame, two bases under the next frame, and so on. ");
INSERT INTO engULB_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","For the back side of the tabernacle on the west side, you must make six frames. ");
INSERT INTO engULB_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","You must make two frames for the back corners of the tabernacle. ");
INSERT INTO engULB_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","These frames must be separate at the bottom, but joined at the top to the same ring. It must be this way for both of the back corners. ");
INSERT INTO engULB_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","There must be eight frames, together with their silver bases. There must be sixteen bases in all, two bases under the first frame, two bases under the next frame, and so on. ");
INSERT INTO engULB_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","You must make crossbars of acacia wood—five for the frames of the one side of the tabernacle, ");
INSERT INTO engULB_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","five crossbars for the frames of the other side of the tabernacle, and five crossbars for the frames for the back side of the tabernacle to the west. ");
INSERT INTO engULB_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","The crossbar in the center of the frames, that is, halfway up, must reach from end to end. ");
INSERT INTO engULB_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","You must cover the frames with gold. You must make their rings of gold, for them to serve as holders for the crossbars, and you must cover the bars with gold. ");
INSERT INTO engULB_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","You must set up the tabernacle by following the plan you were shown on the mountain. ");
INSERT INTO engULB_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","You must make a curtain of blue, purple, and scarlet wool, and of fine linen, with designs of cherubim, the work of a skillful workman. ");
INSERT INTO engULB_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","You must hang it on four pillars of acacia wood covered with gold. These pillars must have hooks of gold set on four silver bases. ");
INSERT INTO engULB_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","You must hang up the curtain under the clasps, and you must bring in the ark of the testimony. The curtain is to separate the holy place from the most holy place. ");
INSERT INTO engULB_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","You must put the atonement lid on the ark of the testimony, which is in the most holy place. ");
INSERT INTO engULB_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","You must place the table outside the curtain. You must place the lampstand opposite the table on the south side of the tabernacle. The table must be on the north side. ");
INSERT INTO engULB_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","You must make a hanging for the tent entrance. You must make it out of blue, purple, and scarlet material and fine twined linen, the work of an embroiderer. ");
INSERT INTO engULB_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","For the hanging, you must make five pillars of acacia and cover them with gold. Their hooks must be of gold, and you must cast five bronze bases for them. ");
INSERT INTO engULB_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","You must make the altar of acacia wood, five cubits long and five cubits wide. The altar must be square and three cubits high. ");
INSERT INTO engULB_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","You must make extensions of its four corners shaped like ox horns. The horns will be made as one piece with the altar, and you must cover them with bronze. ");
INSERT INTO engULB_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","You must make equipment for the altar: pots for ashes, and also shovels, basins, meat forks, and firepans. You must make all these utensils with bronze. ");
INSERT INTO engULB_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","You must make a grate for the altar, a network of bronze. Make a bronze ring for each of the grate's four corners. ");
INSERT INTO engULB_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","You must put the grate under the ledge of the altar, halfway down to the bottom. ");
INSERT INTO engULB_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","You must make poles for the altar, poles of acacia wood, and you must cover them with bronze. ");
INSERT INTO engULB_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","The poles must be put into the rings, and the poles must be on the two sides of the altar, to carry it. ");
INSERT INTO engULB_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","You must make the altar hollow, out of planks. You must make it in the way you were shown on the mountain. ");
INSERT INTO engULB_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","You must make a courtyard for the tabernacle. There must be hangings on the south side of the courtyard, hangings of fine twined linen one hundred cubits long. ");
INSERT INTO engULB_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","The hangings must have twenty posts, with twenty bronze bases. There must also be hooks attached to the posts, as well as silver rods. ");
INSERT INTO engULB_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Likewise along the north side, there must be hangings one hundred cubits long with twenty posts, twenty bronze bases, hooks attached to the posts, and silver rods. ");
INSERT INTO engULB_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Along the courtyard on the west side there must be a curtain fifty cubits long. There must be ten posts and ten bases. ");
INSERT INTO engULB_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","The courtyard must also be fifty cubits long on the east side. ");
INSERT INTO engULB_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","The hangings for one side of the entrance must be fifteen cubits long. They must have three posts with three bases. ");
INSERT INTO engULB_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","The other side must also have hangings fifteen cubits long. They must have their three posts and three bases. ");
INSERT INTO engULB_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","The courtyard gate must be a curtain twenty cubits long. The curtain must be made of blue, purple, and scarlet material and fine twined linen, the work of an embroiderer. It must have four posts with four bases. ");
INSERT INTO engULB_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","All the courtyard posts must have silver rods, silver hooks, and bronze bases. ");
INSERT INTO engULB_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","The length of the courtyard must be one hundred cubits, the width fifty cubits, and the height five cubits with fine twined linen hangings all along, and bases of bronze. ");
INSERT INTO engULB_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","All the equipment to be used in the tabernacle, and all the tent pegs for the tabernacle and courtyard must be made of bronze. ");
INSERT INTO engULB_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","You must command the people of Israel to bring olive oil, pure and pressed, for the lamps so they may burn continually. ");
INSERT INTO engULB_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","In the tent of meeting, outside the curtain that is in front of the tabernacle that contains the ark of testimony, Aaron and his sons must keep the lamps burning before Yahweh, from evening to morning. This requirement will be a lasting ordinance throughout the generations of the people of Israel. ");
INSERT INTO engULB_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Call to yourself Aaron your brother and his sons—Nadab, Abihu, Eleazar, and Ithamar—from among the Israelites so that they may serve me as priests. ");
INSERT INTO engULB_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","You must make for Aaron, your brother, garments that are set apart to me. These garments will be for his honor and splendor. ");
INSERT INTO engULB_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","You must speak to all people who are wise in heart, those whom I have filled with the spirit of wisdom, so that they may make Aaron's garments to set him apart to serve me as my priest. ");
INSERT INTO engULB_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","The garments that they must make are a breastpiece, an ephod, a robe, a coat of woven work, a turban, and a sash. They must make these garments that are set them apart to me. They will be for your brother Aaron and his sons so that they may serve me as priests. ");
INSERT INTO engULB_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Craftsmen must use fine linen that is gold, blue, purple, and scarlet. ");
INSERT INTO engULB_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","They must make the ephod of gold, of blue, purple, and scarlet wool, and of fine-twined linen. It must be the work of a skillful craftsman. ");
INSERT INTO engULB_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","It must have two shoulder pieces attached to its two upper corners. ");
INSERT INTO engULB_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Its finely-woven waistband must be like the ephod; it must be made of one piece with the ephod, made of fine twined linen that is gold, blue, purple, and scarlet. ");
INSERT INTO engULB_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","You must take two onyx stones and engrave on them the names of Israel's twelve sons. ");
INSERT INTO engULB_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Six of their names must be on one stone, and six names must be on the other stone, in order of the sons' birth. ");
INSERT INTO engULB_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","With the work of an engraver in stone, like the engraving on a signet, you must engrave the two stones with the names of Israel's twelve sons. You must mount the stones in settings of gold. ");
INSERT INTO engULB_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","You must put the two stones on the shoulder pieces of the ephod, to be stones to remind Yahweh of Israel's sons. Aaron will carry their names before Yahweh on his two shoulders as a reminder to him. ");
INSERT INTO engULB_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","You must make settings of gold ");
INSERT INTO engULB_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","and two braided chains of pure gold like cords, and you must attach the chains to the settings. ");
INSERT INTO engULB_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","You must make a breastpiece for decision making, the work of a skillful workman, fashioned like the ephod. Make it of gold, of blue, purple, and scarlet wool, and of fine linen. ");
INSERT INTO engULB_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","It is to be square. You must fold the breastpiece double. It must be one span long and one span wide. ");
INSERT INTO engULB_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","You must place in it four rows of precious stones. The first row must have a ruby, a topaz, and a garnet. ");
INSERT INTO engULB_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","The second row must have an emerald, a sapphire, and a diamond. ");
INSERT INTO engULB_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","The third row must have a jacinth, an agate, and an amethyst. ");
INSERT INTO engULB_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","The fourth row must have a beryl, and an onyx, and a jasper. They must be mounted in gold settings. ");
INSERT INTO engULB_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","The stones must be arranged by the names of Israel's twelve sons, each in order by name. They must be like the engraving on a signet ring, each name standing for one of the twelve tribes. ");
INSERT INTO engULB_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","You must make on the breastpiece chains like cords, braided work of pure gold. ");
INSERT INTO engULB_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","You must make two rings of gold for the breastpiece and must attach them to the two ends of the breastpiece. ");
INSERT INTO engULB_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","You must attach the two golden chains to the two corners of the breastpiece. ");
INSERT INTO engULB_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","You must attach the other ends of the two braided chains to the two settings. Then you must attach those to the shoulder pieces of the ephod at its front. ");
INSERT INTO engULB_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","You must make two rings of gold, and you must put them on the other two corners of the breastpiece, on the edge next to the inner border. ");
INSERT INTO engULB_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","You must make two more gold rings, and you must attach them to the bottom of the two shoulder pieces of the front of the ephod, close to its seam above the finely-woven waistband of the ephod. ");
INSERT INTO engULB_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","They must tie the breastpiece by its rings to the ephod's rings with a blue cord, so that it might be attached just above the ephod's woven waistband. This is so that the breastpiece might not become unattached from the ephod. ");
INSERT INTO engULB_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","When Aaron goes into the holy place, he must carry the names of the people of Israel over his heart in the breastpiece for decision making, as a continuing memorial before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","You are to put the Urim and the Thummim in the breastpiece for decision making, so they may be over Aaron's heart when he goes in before Yahweh. Thus Aaron will always carry the means for making decisions for the people of Israel over his heart before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","You will make the robe of the ephod entirely of blue fabric. ");
INSERT INTO engULB_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","It must have an opening for the head in the middle. The opening must have a woven edge round about so that it does not tear. This must be the work of a weaver. ");
INSERT INTO engULB_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","On the bottom hem, you must make pomegranates of blue, purple, and scarlet yarn all around. Gold bells must be between them all around. ");
INSERT INTO engULB_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","There must be a golden bell and a pomegranate, a golden bell and a pomegranate—and so on—all around the hem of the robe. ");
INSERT INTO engULB_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","The robe is to be on Aaron when he serves, so that its sound can be heard when he goes into the holy place before Yahweh and when he leaves. This is so that he does not die. ");
INSERT INTO engULB_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","You must make a plate of pure gold and engrave on it, like the engraving on a signet, “Holy to Yahweh.” ");
INSERT INTO engULB_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","You must attach this plate by a blue cord to the front of the turban. ");
INSERT INTO engULB_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","It must be on Aaron's forehead; he must always bear any guilt that might attach to the offering of the holy gifts that the Israelites set apart to Yahweh. The turban must be always on his forehead so that Yahweh may accept their gifts. ");
INSERT INTO engULB_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","You must make the coat with fine linen, and you must make a turban of fine linen. You must also make a sash, the work of an embroiderer. ");
INSERT INTO engULB_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","For Aaron's sons you must make coats, sashes, and headbands for their honor and splendor. ");
INSERT INTO engULB_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","You must clothe Aaron your brother, and his sons with him. You must anoint them, ordain them, and set them apart to me, so that they may serve me as priests. ");
INSERT INTO engULB_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","You must make for them linen undergarments to cover their naked flesh, that will cover them from the waist to the thighs. ");
INSERT INTO engULB_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaron and his sons must wear these garments when they enter the tent of meeting or when they approach the altar to serve in the holy place. They must do this so they would not be guilty or else they would die. This is a permanent law for Aaron and his descendants after him. ");
INSERT INTO engULB_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Now this is what you must do to set them apart to me so that they may serve me as priests. Take one young bull and two rams without blemish, ");
INSERT INTO engULB_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","bread without yeast, and cakes without yeast mixed with oil. Also take wafers without yeast rubbed with oil. Make the wafers using fine wheat flour. ");
INSERT INTO engULB_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","You must put them into a single basket, bring them in the basket, and present them with the bull and the two rams. ");
INSERT INTO engULB_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","You must present Aaron and his sons at the entrance to the tent of meeting. You must wash Aaron and his sons in water. ");
INSERT INTO engULB_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","You must take the garments and clothe Aaron with the coat, the robe of the ephod, the ephod, and the breastpiece, fastening the finely-woven waistband of the ephod around him. ");
INSERT INTO engULB_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","You must set the turban on his head and put the holy crown on the turban. ");
INSERT INTO engULB_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Then take the anointing oil and pour it on his head, and in this way anoint him. ");
INSERT INTO engULB_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","You must bring his sons and put coats on them. ");
INSERT INTO engULB_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","You must clothe Aaron and his sons with sashes and put headbands on them. The work of the priesthood will belong to them by permanent law. In this way you must consecrate Aaron and his sons for them to serve me. ");
INSERT INTO engULB_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","You must all bring the bull before the tent of meeting, and Aaron and his sons must lay their hands on its head. ");
INSERT INTO engULB_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","You must kill the bull before Yahweh at the entrance to the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","You must take some of the bull's blood and put it on the horns of the altar with your finger, and you must pour out the rest of the blood at the base of the altar. ");
INSERT INTO engULB_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","You must take all the fat that covers the inner parts, and also take the covering of the liver and the two kidneys with the fat that is on them; burn it all on the altar. ");
INSERT INTO engULB_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","But as for the bull's flesh, as well as its skin and dung, you must burn it up outside the camp. It will be a sin offering. ");
INSERT INTO engULB_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","You must also take the one ram, and Aaron and his sons must lay their hands on its head. ");
INSERT INTO engULB_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","You must kill the ram, then take its blood and sprinkle it on all sides of the altar. ");
INSERT INTO engULB_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","You must cut the ram into pieces and wash its inner parts and its legs, and you must put the inner parts, together with its pieces and with its head, ");
INSERT INTO engULB_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","on the altar. Then burn the whole ram. It will be a burnt offering to Yahweh, a sweet aroma, an offering made to Yahweh by fire. ");
INSERT INTO engULB_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","You must then take the other ram, and Aaron and his sons must lay their hands on its head. ");
INSERT INTO engULB_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Then you must kill the ram and take some of its blood. Put it on the tip of Aaron's right ear, and on the tip of his sons' right ears, on the thumb of their right hands, and on the great toe of their right feet. Then you must sprinkle the blood against the altar on every side. ");
INSERT INTO engULB_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","You must take some of the blood that is on the altar and some of the anointing oil, and sprinkle it all on Aaron and on his garments, and also on his sons and on their garments. Aaron will then be set apart for me, as well as his garments, his sons and his sons' garments with him. ");
INSERT INTO engULB_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","You must take the ram's fat, the fat tail, the fat that covers the inner parts, the covering of the liver, the two kidneys and the fat on them, and the right thigh—for this ram is for the priests' consecration to me. ");
INSERT INTO engULB_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Take one loaf of bread, one cake of bread made with oil, and one wafer out of the basket of bread without yeast that is before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","You must put these in Aaron's hands and in the hands of his sons and wave them before me for a wave offering before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","You must then take the food from their hands and burn it on the altar with the burnt offering. It will produce a sweet aroma for me; it will be an offering made to me by fire. ");
INSERT INTO engULB_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","You must take the breast of Aaron's ram of dedication and wave it for a wave offering before Yahweh, and it will be your share. ");
INSERT INTO engULB_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","You must set apart to me the breast of the wave offering that is waved, and the thigh that is the contribution for the priests—both the breast that was waved and the thigh that was contributed for Aaron and his sons. ");
INSERT INTO engULB_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","This will be a perpetual ordinance for Aaron and his sons. It will be a contribution from the people of Israel to give to Yahweh from their peace offerings. ");
INSERT INTO engULB_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","The holy garments of Aaron must also be reserved for his sons after him. They are to be anointed in them and ordained to me in them. ");
INSERT INTO engULB_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","The priest who succeeds him from among his sons, who comes into the tent of meeting to serve me in the holy place, is to wear those garments for seven days. ");
INSERT INTO engULB_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","You must take the ram for the installation of the priests to me and boil its meat in a holy place. ");
INSERT INTO engULB_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaron and his sons must eat the ram's meat and the bread that is in the basket at the entrance to the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","They must eat the meat and bread that were given to atone for them and to ordain them, to be set apart to me. No one else may eat that food, because they must treat it as consecrated to me, reserved for me. ");
INSERT INTO engULB_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","If any of the meat of the ordination offering, or any of the bread, remains to the next morning, then you must burn it. It must not be eaten because it has been set apart to me. ");
INSERT INTO engULB_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","In this way, by following all that I have commanded you to do, you must treat Aaron and his sons. For seven days you must prepare them. ");
INSERT INTO engULB_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Every day you must offer a bull as a sin offering for atonement. You must purify the altar by making atonement for it, and you must anoint it in order to set it apart to me. ");
INSERT INTO engULB_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","For seven days you must make atonement for the altar and set it apart it to Yahweh. Then the altar will be completely set apart to me. Whatever touches the altar will be set apart to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","You must regularly offer on the altar every day two lambs a year old. ");
INSERT INTO engULB_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","One lamb you must offer in the morning, and the other lamb you must offer about sundown. ");
INSERT INTO engULB_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","With the first lamb, offer a tenth of an ephah of fine flour mixed with the fourth part of a hin of oil from pressed olives, and the fourth part of a hin of wine as a drink offering. ");
INSERT INTO engULB_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","You must offer the second lamb about sunset. You must offer the same grain offering as in the morning, and the same drink offering. These will produce a sweet aroma for me; it will be an offering made to me by fire. ");
INSERT INTO engULB_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","These must be regular burnt offerings throughout your generations, at the entrance to the tent of meeting before Yahweh, where I will meet with you to speak to you there. ");
INSERT INTO engULB_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","That is where I will meet with the Israelites; the tent will be set apart for me by my glory. ");
INSERT INTO engULB_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","I will set apart the tent of meeting and the altar for these to belong to me alone. I will also set apart Aaron and his sons to serve me as priests. ");
INSERT INTO engULB_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","I will live among the Israelites and will be their God. ");
INSERT INTO engULB_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","They will know that I am Yahweh, their God, who brought them out from the land of Egypt so that I might live among them. I am Yahweh, their God. ");
INSERT INTO engULB_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","You must make an altar to burn incense. You must make it with acacia wood. ");
INSERT INTO engULB_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Its length must be one cubit, and its width one cubit. It must be square, and its height must be two cubits. Its horns must be made as one piece with it. ");
INSERT INTO engULB_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","You must cover the incense altar with pure gold—its top, its sides, and its horns. You must make a surrounding border of gold for it. ");
INSERT INTO engULB_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","You must make two golden rings to be attached to it under its border on its two opposite sides. The rings must be holders for poles to carry the altar. ");
INSERT INTO engULB_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","You must make the poles of acacia wood, and you must cover them with gold. ");
INSERT INTO engULB_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","You must put the incense altar before the curtain that is by the ark of the testimony. It will be before the atonement lid that is over the ark of the testimony, where I will meet with you. ");
INSERT INTO engULB_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Aaron must burn fragrant incense every morning. He must burn it when he tends the lamps, ");
INSERT INTO engULB_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","and Aaron lights the lamps again in the evening so incense will burn on it regularly before Yahweh, throughout your generations. ");
INSERT INTO engULB_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","But you must offer no other incense on the incense altar, nor any burnt offering or grain offering. You must pour no drink offering on it. ");
INSERT INTO engULB_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aaron must make atonement on its horns once a year. With the blood of the sin offering he will make atonement for it once a year throughout your generations. It is completely set apart to Yahweh.” ");
INSERT INTO engULB_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Then Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“When you take a census of the Israelites, then each person must give a ransom for his life to Yahweh. You must do this after you count them, so that there will be no plague among them when you count them. ");
INSERT INTO engULB_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Everyone who is counted in the census is to pay half a shekel of silver, according to the weight of the shekel of the sanctuary (a shekel is the same as twenty gerahs). This half shekel will be an offering to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Everyone who is counted, from twenty years old and up, must give this offering to me. ");
INSERT INTO engULB_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","When the people give this offering to me to make atonement for their lives, the rich must not give more than the half shekel, and the poor must not give less. ");
INSERT INTO engULB_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","You must receive this atonement money from the Israelites and you must allocate it to the work of the tent of meeting. It must be a reminder to the Israelites before me, to make atonement for your lives.” ");
INSERT INTO engULB_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Then Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“You must also make a large bronze basin with a bronze stand, a basin for washing. You must put it between the tent of meeting and the altar, and you must put water in it. ");
INSERT INTO engULB_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaron and his sons must wash their hands and their feet with the water in it. ");
INSERT INTO engULB_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","When they go into the tent of meeting or when they go near to the altar to serve me by burning an offering, they must wash with water so that they do not die. ");
INSERT INTO engULB_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","They must wash their hands and feet so that they do not die. This must be a permanent law for Aaron and his descendants throughout their people's generations.” ");
INSERT INTO engULB_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Then Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Take these fine spices: five hundred shekels of flowing myrrh, 250 shekels of sweet-smelling cinnamon, 250 shekels of sweet-smelling cane, ");
INSERT INTO engULB_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","five hundred shekels of cassia, measured by the weight of the shekel of the sanctuary, and one hin of olive oil. ");
INSERT INTO engULB_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","You must make holy anointing oil with these ingredients, the work of a perfumer. It will be a holy anointing oil, reserved for me. ");
INSERT INTO engULB_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","You must anoint the tent of meeting with this oil, as well as the ark of the testimony, ");
INSERT INTO engULB_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","the table and all its utensils, the lampstand and its equipment, the incense altar, ");
INSERT INTO engULB_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","the altar for burnt offerings with all its equipment, and the basin with its stand. ");
INSERT INTO engULB_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","You must set them apart to me so that they may be holy to me. Anything that touches them will also be holy. ");
INSERT INTO engULB_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","You must anoint Aaron and his sons and set them aside to me so that they may serve me as priests. ");
INSERT INTO engULB_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","You must say to the Israelites, 'This must be an anointing oil that is set apart to Yahweh throughout your people's generations. ");
INSERT INTO engULB_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","It must not be applied to people's skin, nor must you make any oil like it with the same formula, because it is set apart to Yahweh. You must regard it in this manner. ");
INSERT INTO engULB_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Whoever makes perfume like it, or whoever puts any of it on someone, that person must be cut off from his people.'” ");
INSERT INTO engULB_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Yahweh said to Moses, “Take spices—stacte, onycha, and galbanum—sweet spices along with pure frankincense, each in equal amounts. ");
INSERT INTO engULB_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Make it into the form of incense, blended by a perfumer, seasoned with salt, pure and set apart. ");
INSERT INTO engULB_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","You will grind it into a very fine mixture. Put part of it in front of the ark of the testimony, which is in the tent of meeting, where I will meet with you. You will regard it as very holy to me. ");
INSERT INTO engULB_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","As for this incense that you will make, you must not make any with the same formula for yourselves. It must be most holy to you. ");
INSERT INTO engULB_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Whoever makes anything like it to use as a perfume must be cut off from his people.” ");
INSERT INTO engULB_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Then Yahweh spoke to Moses and said, ");
INSERT INTO engULB_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“See, I have called by name Bezalel son of Uri son of Hur, from the tribe of Judah. ");
INSERT INTO engULB_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","I have filled Bezalel with my Spirit, to give him wisdom, understanding, and knowledge, for all kinds of craftsmanship, ");
INSERT INTO engULB_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","to make artistic designs and to work in gold, silver, and bronze; ");
INSERT INTO engULB_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","also to cut and set stones and to carve wood—to do all kinds of craftsmanship. ");
INSERT INTO engULB_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","In addition to him, I have appointed Oholiab son of Ahisamak, from the tribe of Dan. I have put skill into the hearts of all who are wise so that they may make all that I have commanded you. This includes ");
INSERT INTO engULB_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","the tent of meeting, the ark of the testimony, the atonement lid on the ark, and all the furniture of the tent— ");
INSERT INTO engULB_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","the table and its utensils, the pure lampstand with all its equipment, the incense altar, ");
INSERT INTO engULB_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","the altar for burnt offerings with all its equipment, and the large basin with its base. ");
INSERT INTO engULB_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","This also includes the finely-woven garments—the holy garments for Aaron the priest and those of his sons, reserved for me so that they may serve as priests. ");
INSERT INTO engULB_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","This also includes the anointing oil and the sweet incense for the holy place. These craftsmen must make all these things just as I have commanded you.” ");
INSERT INTO engULB_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Then Yahweh spoke to Moses and said, ");
INSERT INTO engULB_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Tell the Israelites: 'You must certainly keep Yahweh's Sabbath days, for these will be a sign between him and you throughout your people's generations so that you may know that he is Yahweh, who sets you apart for himself. ");
INSERT INTO engULB_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","So you must keep the Sabbath, for it must be treated by you as holy, reserved for him. Everyone who defiles it must surely be put to death. Whoever works on the Sabbath, that person must surely be cut off from his people. ");
INSERT INTO engULB_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Work will be done for six days, but the seventh day is to be a Sabbath of complete rest, holy before Yahweh. Whoever does any work on the Sabbath day must surely be put to death. ");
INSERT INTO engULB_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Therefore the Israelites must keep the Sabbath. They must observe it throughout their people's generations as a permanent law. ");
INSERT INTO engULB_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","The Sabbath will always be a sign between Yahweh and the Israelites, for in six days Yahweh made heaven and earth, and on the seventh day he rested and was refreshed.'” ");
INSERT INTO engULB_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","When God had finished talking with Moses on Mount Sinai, he gave him two tablets of covenant decrees, made of stone, written on by his own hand. ");
INSERT INTO engULB_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","When the people saw that Moses delayed in coming down the mountain, they gathered around Aaron and said to him, “Come, make us an idol that will go before us. As for this Moses, the man who brought us up out of the land of Egypt, we do not know what has happened to him.” ");
INSERT INTO engULB_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","So Aaron said to them, “Take off the golden rings that are on your wives' ears, and the ears of your sons and daughters, and bring them to me.” ");
INSERT INTO engULB_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","All the people took off the golden rings that were on their ears and brought them to Aaron. ");
INSERT INTO engULB_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","He received the gold from them, fashioned it in a mold, and made it into a molded calf. Then the people said, “Israel, this is your god who brought you up out of the land of Egypt.” ");
INSERT INTO engULB_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","When Aaron saw this, he built an altar before the calf and made a proclamation; he said, “Tomorrow will be a festival in Yahweh's honor.” ");
INSERT INTO engULB_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","The people arose early the next day and offered burnt offerings and brought fellowship offerings. Then they sat down to eat and to drink, and then got up to carouse in wild celebration. ");
INSERT INTO engULB_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Then Yahweh spoke to Moses, “Go quickly, for your people, whom you brought up out of the land of Egypt, have corrupted themselves. ");
INSERT INTO engULB_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","They have quickly left the way that I commanded them. They have molded for themselves a calf and have worshiped it and sacrificed to it. They have said, 'Israel, this is your god who brought you up out of the land of Egypt.'” ");
INSERT INTO engULB_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Then Yahweh said to Moses, “I have seen this people. Look, they are a stiff-necked people. ");
INSERT INTO engULB_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Now then, do not try to stop me. My anger will burn hot against them, so I will destroy them. Then I will make a great nation from you.” ");
INSERT INTO engULB_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","But Moses tried to calm down Yahweh his God. He said, “Yahweh, why does your anger burn against your people, whom you have brought out of the land of Egypt with great power and with a mighty hand? ");
INSERT INTO engULB_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Why should the Egyptians say, 'He led them out with evil intent, to kill them in the mountains and to destroy them from the face of the earth?' Turn from your burning anger and relent from this punishment on your people. ");
INSERT INTO engULB_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Call to mind Abraham and Isaac and Israel, your servants, to whom you swore by your own self and said to them, 'I will make your descendants as many as the stars in the heavens, and I will give to your descendants all this land of which I have spoken. They will inherit it forever.'” ");
INSERT INTO engULB_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Then Yahweh relented from the punishment that he had said he would inflict on his people. ");
INSERT INTO engULB_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Then Moses turned around and went down the mountain, carrying the two tablets of the covenant decrees in his hand. The tablets were written on both their sides, on both the front and the back. ");
INSERT INTO engULB_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","The tablets were God's own work, and the writing was God's own writing, engraved on the tablets. ");
INSERT INTO engULB_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","When Joshua heard the noise of the people as they shouted, he said to Moses, “There is the noise of combat in the camp.” ");
INSERT INTO engULB_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","But Moses said, “It is not the sound of a victor, and not the sound of defeated people, but the sound of singing that I hear.” ");
INSERT INTO engULB_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","When Moses approached the camp, he saw the calf and the people dancing. He became very angry. He threw the tablets out of his hands and broke them at the bottom of the mountain. ");
INSERT INTO engULB_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","He took the calf that the people had made, burned it, ground it to powder, and poured it into the water. Then he made the people of Israel drink it. ");
INSERT INTO engULB_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Then Moses said to Aaron, “What did this people do to you, that you have brought such a great sin on them?” ");
INSERT INTO engULB_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron said, “Do not let your anger burn hot, my master. You know these people, how they are set on doing evil. ");
INSERT INTO engULB_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","They said to me, 'Make us a god who will go before us. As for this Moses, the man who brought us up out of the land of Egypt, we do not know what has happened to him.' ");
INSERT INTO engULB_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","So I said to them, 'Whoever has any gold, let him take it off.' They gave me the gold and I threw it into the fire, and out came this calf.” ");
INSERT INTO engULB_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moses saw that the people were running wild (for Aaron had let them get out of control, causing their enemies to mock them). ");
INSERT INTO engULB_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Then Moses stood at the entrance to the camp and said, “Whoever is on Yahweh's side, come to me.” All the Levites gathered around him. ");
INSERT INTO engULB_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","He said to them, “Yahweh, the God of Israel, says this: 'Let each man fasten his sword on his side and go back and forth from entrance to entrance throughout the camp, and kill his brother, his companion, and his neighbor.'” ");
INSERT INTO engULB_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","The Levites did what Moses ordered. That day about three thousand of the people died. ");
INSERT INTO engULB_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moses said to the Levites, “You have been placed into Yahweh's service today, for each of you has taken action against his son and his brother, so Yahweh might give you a blessing today.” ");
INSERT INTO engULB_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","The next day Moses said to the people, “You have committed a very great sin. Now I will go up to Yahweh. Perhaps I can make atonement for your sin.” ");
INSERT INTO engULB_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Moses returned to Yahweh and said, “Oh, these people have committed a great sin and made themselves an idol of gold. ");
INSERT INTO engULB_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","But now, please forgive their sin; but if you do not, blot me out of the book that you have written.” ");
INSERT INTO engULB_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Yahweh said to Moses, “Whoever has sinned against me, that person I will blot out of my book. ");
INSERT INTO engULB_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","So now go, lead the people to the place of which I have spoken to you. See, my angel will go before you. But on the day that I punish them, I will punish them for their sin.” ");
INSERT INTO engULB_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Yahweh sent a plague on the people because they had made the calf, the one that Aaron made. ");
INSERT INTO engULB_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Then Yahweh spoke to Moses, “Go from here, you and the people whom you have brought up out of the land of Egypt. Go to the land about which I made an oath to Abraham, to Isaac, and to Jacob, when I said, 'I will give it to your descendants.' ");
INSERT INTO engULB_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","I will send an angel before you, and I will drive out the Canaanites, Amorites, Hittites, Perizzites, Hivites, and Jebusites. ");
INSERT INTO engULB_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Go to that land, which is flowing with milk and honey, but I will not go up with you, because you are a stubborn people. I might destroy you on the way.” ");
INSERT INTO engULB_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","When the people heard these troubling words, they mourned, and no one put on any jewelry. ");
INSERT INTO engULB_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Yahweh had said to Moses, “Say to the Israelites, 'You are a stubborn people. If I went among you for even one moment, I would destroy you. So now, take off your jewelry so that I may decide what to do with you.'” ");
INSERT INTO engULB_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","So the Israelites wore no jewelry from Mount Horeb onward. ");
INSERT INTO engULB_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moses took a tent and pitched it outside the camp, some distance from the camp. He called it the tent of meeting. Everyone who asked Yahweh for anything went out to the tent of meeting, outside the camp. ");
INSERT INTO engULB_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","When Moses would go out to the tent, all the people would stand up at their tent entrances and look at Moses until he had gone inside. ");
INSERT INTO engULB_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Whenever Moses entered the tent, the pillar of cloud would come down and stand at the tent entrance, and Yahweh would speak with Moses. ");
INSERT INTO engULB_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Whenever all the people saw the pillar of cloud stand at the entrance to the tent, they would get up and worship, every man at his own tent entrance. ");
INSERT INTO engULB_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Yahweh would speak to Moses face to face, as a man speaks to his friend. Then Moses would return to the camp, but his servant Joshua son of Nun, a young man, would stay in the tent. ");
INSERT INTO engULB_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moses said to Yahweh, “See, you have been saying to me, 'Take this people on their journey,' but you have not let me know whom you will send with me. You have said, 'I know you by name, and you have also found favor in my eyes.' ");
INSERT INTO engULB_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Now if I have found favor in your eyes, show me your ways so that I may know you and continue to find favor in your eyes. Remember that this nation is your people.” ");
INSERT INTO engULB_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Yahweh answered, “My own presence will go with you, and I will give you rest.” ");
INSERT INTO engULB_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moses said to him, “If your presence does not go with us, do not take us up from here. ");
INSERT INTO engULB_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","For otherwise, how will it be known that I have found favor in your eyes, I and your people? Will it not only be if you go with us so that I and your people are different from all the other peoples that are on the surface of the earth?” ");
INSERT INTO engULB_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Yahweh said to Moses, “I will also do this thing that you have requested, for you have found favor in my eyes, and I know you by name.” ");
INSERT INTO engULB_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Moses said, “Please show me your glory.” ");
INSERT INTO engULB_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Yahweh said, “I will make all my goodness pass before you, and I will proclaim my name 'Yahweh' before you. I will be gracious to whom I will be gracious, and I will show mercy on whom I will show mercy.” ");
INSERT INTO engULB_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","But Yahweh said, “You may not see my face, for no one can see me and live.” ");
INSERT INTO engULB_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Yahweh said, “See, here is a place by me; you will stand on this rock. ");
INSERT INTO engULB_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","While my glory passes by, I will put you in a crevice of the rock and cover you with my hand until I have passed by. ");
INSERT INTO engULB_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Then I will take away my hand, and you will see my back, but my face will not be seen.” ");
INSERT INTO engULB_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Yahweh said to Moses, “Cut two tablets of stone like the first tablets. I will write on these tablets the words that were on the first tablets, the tablets that you broke. ");
INSERT INTO engULB_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Be ready by morning and come up Mount Sinai, and present yourself there to me on the mountain top. ");
INSERT INTO engULB_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","No one is to come up with you. Do not let anyone else be seen anywhere on the mountain. No flocks or herds are even to graze in front of the mountain.” ");
INSERT INTO engULB_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","So Moses cut two tablets of stone like the first ones, and he got up early in the morning and went up Mount Sinai, as Yahweh had instructed him. Moses carried the tablets of stone in his hand. ");
INSERT INTO engULB_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Yahweh came down in the cloud and stood with Moses there, and he pronounced the name “Yahweh.” ");
INSERT INTO engULB_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Yahweh passed by before him and proclaimed, “Yahweh, Yahweh, God is merciful and gracious, slow to anger, and abounding in covenant faithfulness and trustworthiness, ");
INSERT INTO engULB_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","keeping covenant faithfulness for thousands of generations, forgiving iniquities, transgressions, and sins. But he will by no means clear the guilty. He will bring the punishment for the fathers' sin on their children and on their children's children, as far as the third and fourth generations.” ");
INSERT INTO engULB_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moses quickly bowed his head to the ground and worshiped. ");
INSERT INTO engULB_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Then he said, “If now I have found favor in your eyes, my Lord, please go among us, for this people is stubborn. Pardon our iniquity and our sin, and take us as your inheritance.” ");
INSERT INTO engULB_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Yahweh said, “See, I am about to make a covenant. Before all your people, I will do marvels such as have not been done in all the earth nor in any nation. All the people among you will see my deeds, for it is a fearful thing that I am doing with you. ");
INSERT INTO engULB_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Obey what I command you today. I am about to drive out before you the Amorites, Canaanites, Hittites, Perizzites, Hivites, and Jebusites. ");
INSERT INTO engULB_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Be careful not to make a covenant with the inhabitants of the land where you are going, or they will become a trap among you. ");
INSERT INTO engULB_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Instead, you must break down their altars, smash their stone pillars, and cut down their Asherah poles. ");
INSERT INTO engULB_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","For you must worship no other god, for Yahweh, whose name is Jealous, is a jealous God. ");
INSERT INTO engULB_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","So be careful not to make a covenant with the inhabitants of the land, for they prostitute themselves to their gods, and they sacrifice to their gods. Then one of them will invite you and you will eat some of his sacrifice, ");
INSERT INTO engULB_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","and then you will even take some of his daughters for your sons, and his daughters will prostitute themselves to their gods, and they will make your sons prostitute themselves to their gods. ");
INSERT INTO engULB_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Do not make for yourselves gods of molten metal. ");
INSERT INTO engULB_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","You must keep the Festival of Unleavened Bread. As I commanded you, you must eat bread without yeast for seven days at the fixed time in the month of Aviv, for it was in the month of Aviv you came out from Egypt. ");
INSERT INTO engULB_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","All the firstborn are mine, even every male firstborn of your cattle, both of oxen and sheep. ");
INSERT INTO engULB_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","You must buy back the firstborn of a donkey with a lamb, but if you do not buy it back, then you must break its neck. You must buy back all the firstborn of your sons. No one may appear before me empty-handed. ");
INSERT INTO engULB_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","You may work for six days, but on the seventh day you must rest. Even at plowing time and in harvest, you must rest. ");
INSERT INTO engULB_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","You must observe the Festival of Weeks with the first yield of the wheat harvest, and you must observe the Festival of Ingathering at the year's end. ");
INSERT INTO engULB_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Three times a year all your men must appear before Lord Yahweh, the God of Israel. ");
INSERT INTO engULB_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","For I will drive out nations before you and expand your borders. No one will desire to have your land as their own when you go up to appear before Yahweh your God three times in a year. ");
INSERT INTO engULB_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","You must not offer the blood of my sacrifice with any yeast, nor may any meat from the sacrifice at the Festival of the Passover be left over to the morning. ");
INSERT INTO engULB_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","You must bring the best of the firstfruits from your fields to my house. You must not boil a young goat in its mother's milk.” ");
INSERT INTO engULB_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Yahweh said to Moses, “Write down these words, for in accordance with these words I have made a covenant with you and with Israel.” ");
INSERT INTO engULB_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moses was there with Yahweh for forty days and nights; he did not eat any food nor drink any water. He wrote on the tablets the words of the covenant, the Ten Commandments. ");
INSERT INTO engULB_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","When Moses came down from Mount Sinai with the two tablets of the covenant decrees in his hand, he did not know that the skin of his face had become radiant while speaking with God. ");
INSERT INTO engULB_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","When Aaron and the Israelites saw Moses, the skin of his face was shining, and they were afraid to come near him. ");
INSERT INTO engULB_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","But Moses called to them, and Aaron and all the leaders of the community came up to him. Then Moses spoke with them. ");
INSERT INTO engULB_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","After this, all the people of Israel came up to Moses, and he told them all the commands that Yahweh had given him on Mount Sinai. ");
INSERT INTO engULB_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","When Moses had finished speaking with them, he put a veil over his face. ");
INSERT INTO engULB_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Whenever Moses went before Yahweh to speak with him, he would remove the veil, until he came out. When he came out, he would tell the Israelites what he was commanded to say. ");
INSERT INTO engULB_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","When the Israelites saw Moses' face shining, he would put the veil over his face again until he went back in to speak with Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moses assembled all the community of the Israelites and said to them, “These are the things that Yahweh has commanded you to do. ");
INSERT INTO engULB_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","On six days work may be done, but for you, the seventh day must be a holy day, a Sabbath day of complete rest, holy to Yahweh. Whoever does any work on that day must be put to death. ");
INSERT INTO engULB_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","You must not light a fire in any of your homes on the Sabbath day.” ");
INSERT INTO engULB_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moses spoke to all the community of the Israelites, saying, “This is the thing that Yahweh commanded. ");
INSERT INTO engULB_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Take an offering for Yahweh, all of you who have a willing heart. Bring an offering to Yahweh—gold, silver, bronze, ");
INSERT INTO engULB_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","blue, purple, and scarlet wool and fine linen; goats' hair; ");
INSERT INTO engULB_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ram skins dyed red and sea cow hides; acacia wood; ");
INSERT INTO engULB_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","oil for the sanctuary lamps, spices for the anointing oil and the fragrant incense, ");
INSERT INTO engULB_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","onyx stones and other precious stones to be set for the ephod and breastpiece. ");
INSERT INTO engULB_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Every skilled man among you is to come and make everything that Yahweh has commanded— ");
INSERT INTO engULB_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","the tabernacle with its tent, its covering, its clasps, frames, bars, posts, and bases; ");
INSERT INTO engULB_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","also the ark with its poles, the atonement lid, and the curtain to conceal it. ");
INSERT INTO engULB_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","They brought the table with its poles, all its utensils, and the bread of the presence; ");
INSERT INTO engULB_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","the lampstand for the lights, with its accessories, its lamps, and the oil for the lamps; ");
INSERT INTO engULB_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","the incense altar with its poles, the anointing oil and the fragrant incense; the hanging for the tabernacle entrance; ");
INSERT INTO engULB_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","the altar for burnt offerings with its bronze grate and its poles and utensils; and the large basin with its base. ");
INSERT INTO engULB_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","They brought the hangings for the courtyard with its posts and bases, and the curtain for the courtyard entrance; ");
INSERT INTO engULB_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","and the tent pegs for the tabernacle and courtyard, together with their ropes. ");
INSERT INTO engULB_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","They brought the finely-woven garments for serving in the holy place, the holy garments for Aaron the priest and his sons, for them to serve as priests.” ");
INSERT INTO engULB_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Then all the tribes of Israel left and went away from Moses's presence. ");
INSERT INTO engULB_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Everyone whose heart stirred him up and whom his spirit made willing came and brought an offering to Yahweh for the construction of the tabernacle, for all the items of service in it, and for the holy garments. ");
INSERT INTO engULB_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","They came, both men and women, all who had a willing heart. They brought brooches, earrings, rings, and ornaments, all kinds of gold jewelry. They all presented offerings of gold as a wave offering to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Everyone who had blue, purple, or scarlet wool, fine linen, goat hair, ram skins dyed red, or sea cow skins brought them. ");
INSERT INTO engULB_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Everyone making an offering of silver or bronze brought it as an offering to Yahweh, and everyone who had acacia wood for any use in the work brought it. ");
INSERT INTO engULB_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Every skilled woman spun wool with her hands and brought what she had spun—blue, purple, or scarlet wool, or fine linen. ");
INSERT INTO engULB_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","All the women whose hearts stirred them up and who had skill spun goats' hair. ");
INSERT INTO engULB_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","The leaders brought onyx stones and other gems to be set into the ephod and the breastpiece; ");
INSERT INTO engULB_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","they brought spices and oil for the lamps, for the anointing oil, and for the fragrant incense. ");
INSERT INTO engULB_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","The Israelites brought a freewill offering to Yahweh; every man and woman whose heart was willing brought materials for all the work that Yahweh had commanded through Moses to be made. ");
INSERT INTO engULB_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Moses said to the Israelites, “See, Yahweh has called by name on Bezalel son of Uri son of Hur, from the tribe of Judah. ");
INSERT INTO engULB_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","He has filled Bezalel with his Spirit, to give him wisdom, understanding, and knowledge, for all kinds of craftsmanship, ");
INSERT INTO engULB_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","to make artistic designs and to work in gold, silver, and bronze; ");
INSERT INTO engULB_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","also to cut and set stones and to carve wood—to do all kinds of design and craftsmanship. ");
INSERT INTO engULB_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","He has put it in his heart to teach, both he and Oholiab son of Ahisamak, from the tribe of Dan. ");
INSERT INTO engULB_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","He has filled them with skill to do all kinds of work, to work as craftsmen, as engravers, as embroiderers in blue, purple, and scarlet wool and fine linen, and as weavers. They are craftsmen in all sorts of work, and they are artistic designers. ");
INSERT INTO engULB_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","So Bezalel and Oholiab and every skilled person to whom Yahweh has given skill and ability to know how to do any work in the construction of the holy place are to do the work according to all that Yahweh has commanded.” ");
INSERT INTO engULB_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moses summoned Bezalel, Oholiab, and every skillful person in whose mind Yahweh had given skill, and whose heart stirred within him to come and do the work. ");
INSERT INTO engULB_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","They received from Moses all the offerings that the Israelites had brought for constructing the holy place. The people were still bringing freewill offerings every morning to Moses. ");
INSERT INTO engULB_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","So all the skilled people working on the holy place came from the work that they had been doing. ");
INSERT INTO engULB_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","The craftsmen told Moses, “The people are bringing much more than enough for doing the work that Yahweh has commanded us to do.” ");
INSERT INTO engULB_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","So Moses instructed that no one in the camp should bring any more offerings for the construction of the holy place. Then the people stopped bringing these gifts. ");
INSERT INTO engULB_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","They had more than enough materials for all the work. ");
INSERT INTO engULB_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","So all the craftsmen among them constructed the tabernacle with ten curtains made from fine linen and blue, purple, and scarlet wool with the designs of cherubim. This was the work of Bezalel, the very skilled craftsman. ");
INSERT INTO engULB_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","The length of each curtain was twenty-eight cubits, the width four cubits. All the curtains were of the same size. ");
INSERT INTO engULB_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Bezalel joined five curtains to each other, and the other five curtains he also joined to each other. ");
INSERT INTO engULB_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","He made loops of blue along the outer edge of the end curtain of one set, and he did the same along the outer edge of the end curtain in the second set. ");
INSERT INTO engULB_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","He made fifty loops on the first curtain and fifty loops on the edge of the end curtain in the second set. So the loops were opposite to each another. ");
INSERT INTO engULB_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","He made fifty gold clasps and joined the curtains together with them so that the tabernacle became united. ");
INSERT INTO engULB_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Bezalel made curtains of goat hair for a tent over the tabernacle; he made eleven of these curtains. ");
INSERT INTO engULB_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","The length of each curtain was thirty cubits, and the width of each curtain was four cubits. Each of the eleven curtains was of the same size. ");
INSERT INTO engULB_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","He joined five curtains to each other and the other six curtains to each other. ");
INSERT INTO engULB_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","He made fifty loops on the edge of the end curtain of the first set, and fifty loops along the edge of the end curtain that joined the second set. ");
INSERT INTO engULB_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Bezalel made fifty bronze clasps to join the tent together so that it might be one piece. ");
INSERT INTO engULB_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","He made for the tabernacle a covering of ram skins dyed red, another covering of fine leather to go above that. ");
INSERT INTO engULB_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Bezalel made vertical frames out of acacia wood for the tabernacle. ");
INSERT INTO engULB_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","The length of each frame was ten cubits, and the width of each frame was one and a half cubits. ");
INSERT INTO engULB_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Each frame had two wooden pegs for joining the frames together. He did this for all the frames of the tabernacle. ");
INSERT INTO engULB_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","He made the frames for the tabernacle in this way: twenty frames for the south side. ");
INSERT INTO engULB_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Bezalel made forty silver bases to go under the twenty frames. There were two bases under one frame to join the frames together, and also two bases under each of the other frames to join frames together. ");
INSERT INTO engULB_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","For the second side of the tabernacle, on the north side, he made twenty frames ");
INSERT INTO engULB_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","and their forty silver bases. There were two bases under the first frame, two bases under the next frame, and so on. ");
INSERT INTO engULB_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","For the back of the tabernacle on the west, Bezalel made six frames. ");
INSERT INTO engULB_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","He made two frames for the back corners of the tabernacle. ");
INSERT INTO engULB_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","These frames were separate at the bottom, but joined at the top in one ring. He made two of them in this way for the two corners. ");
INSERT INTO engULB_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","There were eight frames, together with their silver bases. There were sixteen bases in all, two bases under the first frame, two bases under the next frame, and so on. ");
INSERT INTO engULB_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Bezalel made crossbars of acacia wood—five for the frames of the one side of the tabernacle, ");
INSERT INTO engULB_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","five crossbars for the frames of the other side of the tabernacle, and five crossbars for the frames for the back side of the tabernacle to the west. ");
INSERT INTO engULB_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","He made the crossbar in the center of the frames, that is, halfway up, to reach from end to end. ");
INSERT INTO engULB_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","He covered the frames with gold. He made their rings of gold, for them to serve as holders for the crossbars, and he covered the bars with gold. ");
INSERT INTO engULB_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Bezalel made the curtain of blue, purple, and scarlet wool, and of fine linen, with designs of cherubim, the work of a skillful workman. ");
INSERT INTO engULB_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","He made for the curtain four pillars of acacia wood, and he covered them with gold. He also made gold hooks for the pillars, and he cast for them four silver bases. ");
INSERT INTO engULB_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","He made a hanging for the tent entrance. It was made of blue, purple, and scarlet wool, using fine linen, the work of an embroiderer. ");
INSERT INTO engULB_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","He also made the hanging's five pillars with hooks. He covered their tops and their rods with gold. Their five bases were made of bronze. ");
INSERT INTO engULB_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalel made the ark of acacia wood. Its length was two and a half cubits; its width was one cubit and a half; and its height was one cubit and a half. ");
INSERT INTO engULB_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","He covered it inside and out with pure gold and made for it a border of gold around its top. ");
INSERT INTO engULB_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","He cast four rings of gold for its four feet, with two rings on one side of it, and two rings on the other side. ");
INSERT INTO engULB_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","He made poles of acacia wood and covered them with gold. ");
INSERT INTO engULB_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","He put the poles into the rings on the ark's sides, in order to carry the ark. ");
INSERT INTO engULB_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","He made an atonement lid of pure gold. Its length was two and a half cubits, and its width was one and a half cubits. ");
INSERT INTO engULB_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Bezalel made two cherubim of hammered gold for the two ends of the atonement lid. ");
INSERT INTO engULB_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","One cherub was for one end of the atonement lid, and other cherub was for the other end. They were made as one piece with the atonement lid. ");
INSERT INTO engULB_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","The cherubim spread out their wings upward and overshadowed the atonement lid with them. The cherubim faced one another and looked toward the center of the atonement lid. ");
INSERT INTO engULB_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Bezalel made the table of acacia wood. Its length was two cubits, its width was one cubit, and its height was one and a half cubits. ");
INSERT INTO engULB_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","He covered it with pure gold and put a border of pure gold around the top. ");
INSERT INTO engULB_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","He made a surrounding frame for it one handbreadth wide, with a surrounding border of gold for the frame. ");
INSERT INTO engULB_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","He cast for it four rings of gold and attached the rings to the four corners, where the four feet were. ");
INSERT INTO engULB_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","The rings were attached to the frame to provide places for the poles, in order to carry the table. ");
INSERT INTO engULB_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","He made the poles out of acacia wood and covered them with gold, in order to carry the table. ");
INSERT INTO engULB_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","He made the objects that would be on the table—the dishes, spoons, the bowls, and pitchers to be used to pour out the offerings. He made them out of pure gold. ");
INSERT INTO engULB_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","He made the lampstand of pure hammered gold. He made the lampstand with its base and shaft. Its cups, its leafy bases, and its flowers were all made of one piece with it. ");
INSERT INTO engULB_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Six branches extended out from its sides—three branches extended from one side, and three branches of the lampstand extended from the other side. ");
INSERT INTO engULB_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","The first branch had three cups made like almond blossoms, with a leafy base and a flower, and three cups made like almond blossoms in the other branch, with a leafy base and a flower. It was the same for all six branches extending out from the lampstand. ");
INSERT INTO engULB_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","On the lampstand itself, the central shaft, there were four cups made like almond blossoms, with their leafy bases and the flowers. ");
INSERT INTO engULB_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","There was a leafy base under the first pair of branches—made as one piece with it, and a leafy base under the second pair of branches—also made as one piece with it. In the same way there was a leafy base under the third pair of branches, made as one piece with it. It was the same for all six branches extending out from the lampstand. ");
INSERT INTO engULB_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Their leafy bases and branches were all one piece with it, one beaten piece of work of pure gold. ");
INSERT INTO engULB_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Bezalel made the lampstand and its seven lamps, its tongs and their trays of pure gold. ");
INSERT INTO engULB_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","He made the lampstand and its accessories with one talent of pure gold. ");
INSERT INTO engULB_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Bezalel made the incense altar. He made it with acacia wood. Its length was one cubit, and its width one cubit. It was square, and its height was two cubits. Its horns were made as one piece with it. ");
INSERT INTO engULB_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","He covered the incense altar with pure gold—its top, its sides, and its horns. He also made a surrounding border of gold for it. ");
INSERT INTO engULB_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","He made two golden rings to be attached to it under its border on its two opposite sides. The rings were holders for poles to carry the altar. ");
INSERT INTO engULB_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","He made the poles of acacia wood, and he covered them with gold. ");
INSERT INTO engULB_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","He made the holy anointing oil and the pure fragrant incense, the work of a perfumer. ");
INSERT INTO engULB_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bezalel made the altar for burnt offerings of acacia wood. It was five cubits long and five cubits wide—a square—and three cubits high. ");
INSERT INTO engULB_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","He made extensions of its four corners shaped like ox horns. The horns were made of one piece with the altar, and he covered it with bronze. ");
INSERT INTO engULB_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","He made all the equipment for the altar—pots for ashes, shovels, basins, meat forks, and firepans. He made all this equipment with bronze. ");
INSERT INTO engULB_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","He made a grate for the altar, a network of bronze to be placed under the ledge, halfway down to the bottom. ");
INSERT INTO engULB_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","He cast four rings for the four corners of the bronze grate, as holders for the poles. ");
INSERT INTO engULB_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Bezalel made poles of acacia wood and covered them with bronze. ");
INSERT INTO engULB_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","He put the poles through the rings on the sides of the altar, to carry it. He made the altar hollow, out of planks. ");
INSERT INTO engULB_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Bezalel made the large bronze basin with a bronze stand. He made the basin out of mirrors belonging to the women who served at the entrance to the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","He also made the courtyard. The hangings on the south side of the courtyard were of fine linen, one hundred cubits long. ");
INSERT INTO engULB_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","The hangings had twenty posts, with twenty bronze bases. There were hooks attached to the posts, as well as silver rods. ");
INSERT INTO engULB_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Likewise along the north side, there were hangings one hundred cubits long with twenty posts, twenty bronze bases, hooks attached to the posts, and silver rods. ");
INSERT INTO engULB_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","The hangings of the west side were fifty cubits long, with ten posts and bases. The hooks and rods of the posts were silver. ");
INSERT INTO engULB_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","The courtyard was also fifty cubits long on the east side. ");
INSERT INTO engULB_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","The hangings for one side of the entrance were fifteen cubits long. They had three posts with three bases. ");
INSERT INTO engULB_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","On the other side of the entrance of the courtyard were also hangings fifteen cubits long, with three posts and three bases. ");
INSERT INTO engULB_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","All the hangings around the courtyard were made of fine linen. ");
INSERT INTO engULB_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","The bases for the posts were made of bronze. The hooks and rods for the posts were made of silver, and the covering for the tops of the posts was also made of silver. All the courtyard posts were covered with silver. ");
INSERT INTO engULB_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","The curtain at the courtyard gate was twenty cubits long. The curtain was made of blue, purple, and scarlet linen, fine twined linen, and was twenty cubits long. It was twenty cubits in length and five cubits in height, like the courtyard curtains. ");
INSERT INTO engULB_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","It had four bronze bases and silver hooks. The covering for their tops and its rods were made of silver. ");
INSERT INTO engULB_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","All the tent pegs for the tabernacle and courtyard were made of bronze. ");
INSERT INTO engULB_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","This is the inventory of the tabernacle, the tabernacle of the covenant decrees, as it was taken following Moses' instructions. It was the work of the Levites under the direction of Ithamar son of Aaron the priest. ");
INSERT INTO engULB_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezalel son of Uri son of Hur, from the tribe of Judah, made everything that Yahweh had commanded Moses. ");
INSERT INTO engULB_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Oholiab son of Ahisamak, from the tribe of Dan, worked with Bezalel as an engraver, as a skillful workman, and as an embroiderer in blue, purple, and scarlet wool, and in fine linen. ");
INSERT INTO engULB_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","All the gold that was used for the project, in all the work connected with the holy place—the gold from the wave offering—was twenty-nine talents and 730 shekels, measured by the standard of the sanctuary shekel. ");
INSERT INTO engULB_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","The silver given by the community weighed one hundred talents and 1,775 shekels, according to the sanctuary shekel, ");
INSERT INTO engULB_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","or one beka per man, which is half a shekel, measured by the sanctuary shekel. This figure was reached on the basis of every person who was counted in the census, those twenty years old and older—603,550 men in all. ");
INSERT INTO engULB_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","One hundred talents of silver were cast for the bases of the holy place and the curtain's bases—one hundred bases, one talent for each base. ");
INSERT INTO engULB_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","With the remaining 1,775 shekels of silver, Bezalel made the hooks for the posts, covered the tops of the posts, and made the rods for them. ");
INSERT INTO engULB_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","The bronze from wave offering weighed seventy talents and 2,400 shekels. ");
INSERT INTO engULB_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","With this he made the bases for the entrance to the tent of meeting, the bronze altar, its bronze grate, all the equipment for the altar, ");
INSERT INTO engULB_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","the bases for the courtyard, the bases for the courtyard entrance, all the tent pegs for the tabernacle, and all the tent pegs for the courtyard. ");
INSERT INTO engULB_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","With the blue, purple, and scarlet wool, they made finely-woven garments for service in the holy place. They made Aaron's garments for the holy place, as Yahweh had commanded Moses. ");
INSERT INTO engULB_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Bezalel made the ephod of gold, of blue, purple, and scarlet wool, and of fine twined linen. ");
INSERT INTO engULB_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","They hammered gold sheets and cut them into wires, to work them into the blue, purple, and scarlet wool, and into the fine linen, the work of a skillful workman. ");
INSERT INTO engULB_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","They made shoulder pieces for the ephod, attached at its two upper corners. ");
INSERT INTO engULB_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Its finely-woven waistband was like the ephod; it was made of one piece with the ephod, made of fine twined linen that was gold, blue, purple, and scarlet, just as Yahweh had commanded Moses. ");
INSERT INTO engULB_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","They crafted the onyx stones, enclosed in settings of gold, set with engravings as on a signet, and engraved with the names of Israel's twelve sons. ");
INSERT INTO engULB_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Bezalel put them on the shoulder pieces of the ephod, as stones to remind Yahweh of Israel's twelve sons, as Yahweh had commanded Moses. ");
INSERT INTO engULB_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","He made the breastpiece, the work of a skillful workman, fashioned like the ephod. He made it of gold, of blue, purple, and scarlet wool, and of fine linen. ");
INSERT INTO engULB_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","It was square. They folded the breastpiece double. It was one span long and one span wide. ");
INSERT INTO engULB_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","They set in it four rows of precious stones. The first row had a ruby, a topaz, and a garnet. ");
INSERT INTO engULB_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","The second row had an emerald, a sapphire, and a diamond. ");
INSERT INTO engULB_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","The third row had a jacinth, an agate, and an amethyst. ");
INSERT INTO engULB_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","The fourth row had a beryl, an onyx, and a jasper. The stones were mounted in gold settings. ");
INSERT INTO engULB_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","The stones were arranged by the names of Israel's twelve sons, each in order by name. They were like the engraving on a signet ring, each name standing for one of the twelve tribes. ");
INSERT INTO engULB_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","On the breastpiece they made chains like cords, braided work of pure gold. ");
INSERT INTO engULB_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","They made two settings of gold and two gold rings, and they attached the two rings to the two corners of the breastpiece. ");
INSERT INTO engULB_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","They put the two braided chains of gold in the two rings at the corners of the breastpiece. ");
INSERT INTO engULB_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","They attached the other two ends of the braided chains to the two settings. They attached them to the shoulder pieces of the ephod at its front. ");
INSERT INTO engULB_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","They made two rings of gold and put them on the two other corners of the breastpiece, on the edge next to the inner border. ");
INSERT INTO engULB_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","They made two more gold rings and attached them to the bottom of the two shoulder pieces of the front of the ephod, close to its seam above the finely-woven waistband of the ephod. ");
INSERT INTO engULB_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","They tied the breastpiece by its rings to the ephod's rings with a blue cord, so that it might be attached just above the ephod's finely-woven waistband. This was so that the breastpiece might not become unattached from the ephod. This was done as Yahweh had commanded Moses. ");
INSERT INTO engULB_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Bezalel made the robe of the ephod entirely of blue fabric, the work of a weaver. ");
INSERT INTO engULB_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","It had an opening for the head in the middle. The opening had a woven edge round about so that it did not tear. ");
INSERT INTO engULB_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","On the bottom hem, they made pomegranates of blue, purple, and scarlet yarn and of fine linen. ");
INSERT INTO engULB_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","They made bells of pure gold, and they put the bells between the pomegranates all around on the bottom edge the robe, between the pomegranates— ");
INSERT INTO engULB_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","a bell and a pomegranate, a bell and a pomegranate—on the edge of the robe for Aaron to serve in. This was as Yahweh had commanded Moses. ");
INSERT INTO engULB_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","They made the coats of fine linen for Aaron and for his sons. ");
INSERT INTO engULB_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","They made the turban of fine linen, the ornate headbands of fine linen, the linen undergarments of fine linen, ");
INSERT INTO engULB_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","and the sash of fine linen and of blue, purple, and scarlet yarn, the work of an embroiderer. This was as Yahweh had commanded Moses. ");
INSERT INTO engULB_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","They made the plate of the holy crown of pure gold; they engraved on it, like the engraving on a signet, “Holy to Yahweh.” ");
INSERT INTO engULB_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","They attached to the turban a blue cord to the top of the turban. This was as Yahweh had commanded Moses. ");
INSERT INTO engULB_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","So the work on the tabernacle, the tent of meeting, was finished. The people of Israel did everything. They followed all the instructions that Yahweh had given to Moses. ");
INSERT INTO engULB_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","They brought the tabernacle to Moses—the tent and all its equipment, its clasps, frames, bars, posts, and bases; ");
INSERT INTO engULB_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","the covering of ram skins dyed red, the covering of sea cow leather, and the curtain to conceal ");
INSERT INTO engULB_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","the ark of the testimony, as well as the poles and the atonement lid. ");
INSERT INTO engULB_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","They brought the table, all its utensils, and the bread of the presence; ");
INSERT INTO engULB_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","the lampstand of pure gold and its lamps in a row, with its accessories and the oil for the lamps; ");
INSERT INTO engULB_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","the golden altar, the anointing oil and the fragrant incense; the hanging for the tabernacle entrance; ");
INSERT INTO engULB_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","the bronze altar with its bronze grate and its poles and utensil and the large basin with its base. ");
INSERT INTO engULB_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","They brought the hangings for the courtyard with its posts and bases, and the curtain for the courtyard entrance; its ropes and tent pegs; and all the equipment for the service of the tabernacle, the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","They brought the fine woven garments for serving in the holy place, the holy garments for Aaron the priest and his sons, for them to serve as priests. ");
INSERT INTO engULB_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Thus the people of Israel did all the work as Yahweh had commanded Moses. ");
INSERT INTO engULB_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moses examined all the work, and, behold, they had done it. As Yahweh had commanded, in that way they did it. Then Moses blessed them. ");
INSERT INTO engULB_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Then Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“On the first day of the first month of the new year you must set up the tabernacle, the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","You must place the ark of the testimony in it, and you must shield the ark with the curtain. ");
INSERT INTO engULB_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","You must bring in the table and set in order the things that belong on it. Then you must bring in the lampstand and set up the lamps. ");
INSERT INTO engULB_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","You must put the golden incense altar before the ark of the testimony, and you must put the curtain at the entrance to the tabernacle. ");
INSERT INTO engULB_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","You must put the altar for burnt offerings in front of the entrance to the tabernacle, the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","You must put the large basin between the tent of meeting and the altar and you must put water in it. ");
INSERT INTO engULB_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","You must set up the courtyard around it, and you must hang up the curtain at the courtyard entrance. ");
INSERT INTO engULB_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","You must take the anointing oil and anoint the tabernacle and everything that is in it. You must set it apart and all its furnishings to me; then it will be holy. ");
INSERT INTO engULB_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","You must anoint the altar for burnt offerings and all its utensils. You must set apart the altar to me and it will become very holy to me. ");
INSERT INTO engULB_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","You must anoint the bronze basin and its base and set it apart to me. ");
INSERT INTO engULB_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","You are to bring Aaron and his sons to the entrance of the tent of meeting and you must wash them with water. ");
INSERT INTO engULB_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","You are to clothe Aaron with the garments that are set apart to me, anoint him and set him apart so that he may serve as my priest. ");
INSERT INTO engULB_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","You are to bring his sons and clothe them with coats. ");
INSERT INTO engULB_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","You must anoint them as you anointed their father so that they may serve me as priests. Their anointing will make for them a permanent priesthood throughout their people's generations.” ");
INSERT INTO engULB_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","This is what Moses did; he followed all that Yahweh had commanded him. He did all these things. ");
INSERT INTO engULB_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","So the tabernacle was set up on the first day of the first month in the second year. ");
INSERT INTO engULB_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moses set up the tabernacle, put its bases in place, set up its frames, attached its bars, and set up its pillars and posts. ");
INSERT INTO engULB_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","He spread the covering over the tabernacle and put tent over it, as Yahweh had commanded him. ");
INSERT INTO engULB_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","He took the covenant decrees and put them into the ark. He also placed the poles on the ark and put the atonement lid on it. ");
INSERT INTO engULB_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","He brought the ark into the tabernacle. He set up the curtain for it to shield the ark of the testimony, as Yahweh had commanded him. ");
INSERT INTO engULB_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","He put the table into the tent of meeting, on the north side of the tabernacle, outside the curtain. ");
INSERT INTO engULB_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","He placed the bread in order on the table before Yahweh, as Yahweh had commanded him. ");
INSERT INTO engULB_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","He put the lampstand into the tent of meeting, across from the table, on the south side of the tabernacle. ");
INSERT INTO engULB_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","He lit the lamps before Yahweh, as Yahweh had commanded him. ");
INSERT INTO engULB_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","He put the golden incense altar into the tent of meeting in front of the curtain. ");
INSERT INTO engULB_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","He burned fragrant incense on it, as Yahweh had commanded him. ");
INSERT INTO engULB_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","He hung the curtain at the tabernacle entrance. ");
INSERT INTO engULB_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","He put the altar for the burnt offering at the entrance to the tabernacle, the tent of meeting. He offered on it the burnt offering and the grain offering, as Yahweh had commanded him. ");
INSERT INTO engULB_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","He placed the basin between the tent of meeting and the altar, and he put water in it for washing. ");
INSERT INTO engULB_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moses, Aaron, and his sons washed their hands and their feet from the basin ");
INSERT INTO engULB_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","whenever they would go into the tent of meeting and whenever they would go up to the altar. They washed themselves, as Yahweh had commanded Moses. ");
INSERT INTO engULB_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Moses set up the courtyard around the tabernacle and the altar. He set up the curtain at the courtyard entrance. In this way, Moses finished the work. ");
INSERT INTO engULB_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Then the cloud covered the tent of meeting, and Yahweh's glory filled the tabernacle. ");
INSERT INTO engULB_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moses was not able to enter the tent of meeting because the cloud had settled on it, and because Yahweh's glory filled the tabernacle. ");
INSERT INTO engULB_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Whenever the cloud was taken up from over the tabernacle, the people of Israel would set out on their journey. ");
INSERT INTO engULB_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","But if the cloud did not rise up from the tabernacle, then the people would not travel. They would stay until the day that it was lifted up. ");
INSERT INTO engULB_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","For Yahweh's cloud was over the tabernacle by day, and his fire was over it by night, in plain view of all the people of Israel throughout their journey. ");
INSERT INTO engULB_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Yahweh called to Moses and spoke to him from the tent of meeting, saying, ");
INSERT INTO engULB_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Speak to the people of Israel and tell them, 'When any man from among you brings an offering to Yahweh, bring as your offering one of your animals, either from the herd or from the flock. ");
INSERT INTO engULB_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","If his offering is a burnt offering from the herd, he must offer a male without blemish. He is to offer it at the entrance of the tent of meeting, so that it may be accepted before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","He is to lay his hand on the head of the burnt offering, and then it will be accepted on his behalf to make atonement for himself. ");
INSERT INTO engULB_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Then he must kill the bull before Yahweh. Aaron's sons, the priests, will present the blood and sprinkle it on the altar that is at the entrance of the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Then he must skin the burnt offering and cut it to pieces. ");
INSERT INTO engULB_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Then the sons of Aaron the priest will put fire on the altar and place wood to feed the fire. ");
INSERT INTO engULB_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Aaron's sons, the priests, are to place the pieces, the head and the fat, in order on the wood that is on the fire which is on the altar. ");
INSERT INTO engULB_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","But its inner parts and its legs he must wash with water. Then the priest will burn everything on the altar as a burnt offering. It will produce a sweet aroma for me; it will be an offering made to me by fire. ");
INSERT INTO engULB_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","If his offering for the burnt offering is from the flock, one of the sheep or one of the goats, he must offer a male without blemish. ");
INSERT INTO engULB_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","He must kill it on the north side of the altar before Yahweh. Aaron's sons, the priests, will sprinkle its blood on every side of the altar. ");
INSERT INTO engULB_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Then he must cut it into pieces, with its head and its fat, and the priest will lay them in order on the wood that is on the fire, which is on the altar, ");
INSERT INTO engULB_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","but the inner parts and the legs he must wash with water. Then the priest will offer the whole, and burn it on the altar. It is a burnt offering, and it will produce a sweet aroma for Yahweh; it will be an offering made to him by fire. ");
INSERT INTO engULB_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","If his offering to Yahweh is to be a burnt offering of birds, then he must bring as his offering either a dove or a young pigeon. ");
INSERT INTO engULB_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","The priest must bring it to the altar, wring off its head, and burn it on the altar. Then its blood must be drained out on the side of the altar. ");
INSERT INTO engULB_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","He must remove its crop with its contents, and throw it beside the altar on the east side, in the place for the ashes. ");
INSERT INTO engULB_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","He must tear it open by its wings, but he must not divide it into two parts. Then the priest will burn it on the altar, on the wood that is on the fire. It will be a burnt offering, and it will produce a sweet aroma for Yahweh; it will be an offering made to him by fire. ");
INSERT INTO engULB_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","When anyone brings a grain offering to Yahweh, his offering must be fine flour, and he will pour oil on it and put incense on it. ");
INSERT INTO engULB_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","He is to take the offering to Aaron's sons the priests, and there the priest will take out a handful of the fine flour with the oil and the incense on it. Then the priest will burn the offering on the altar as a representative offering. It will produce a sweet aroma for Yahweh; it will be an offering made to him by fire. ");
INSERT INTO engULB_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Whatever is left of the grain offering will belong to Aaron and his sons. It is very holy to Yahweh from the offerings to Yahweh made by fire. ");
INSERT INTO engULB_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","When you offer a grain offering without yeast that is baked in an oven, it must be soft bread of fine flour mixed with oil, or hard bread without yeast, which is spread with oil. ");
INSERT INTO engULB_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","If your grain offering is baked with a flat iron pan, it must be of fine flour without yeast that is mixed with oil. ");
INSERT INTO engULB_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","You are to divide it into pieces and pour oil on it. This is a grain offering. ");
INSERT INTO engULB_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","If your grain offering is cooked in a pan, it must be made with fine flour and oil. ");
INSERT INTO engULB_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","You must bring the grain offering made from these things to Yahweh, and it will be presented to the priest, who will bring it to the altar. ");
INSERT INTO engULB_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Then the priest will take some from the grain offering as a representative offering, and he will burn it on the altar. It will be an offering made by fire, and it will produce a sweet aroma for Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","What is left of the grain offering will belong to Aaron and his sons. It is very holy to Yahweh from the offerings to Yahweh made by fire. ");
INSERT INTO engULB_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","No grain offering that you offer to Yahweh is to be made with yeast, for you must burn no leaven, nor any honey, as an offering made by fire to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","You will offer them to Yahweh as an offering of firstfruits, but they will not be used to produce a sweet aroma on the altar. ");
INSERT INTO engULB_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","You must season each of your grain offerings with salt. You must never allow the salt of the covenant of your God to be missing from your grain offering. With all your offerings you must offer salt. ");
INSERT INTO engULB_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","If you offer a grain offering of firstfruits to Yahweh, offer fresh grain that is roasted with fire and then crushed into meal. ");
INSERT INTO engULB_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Then you must put oil and incense on it. This is a grain offering. ");
INSERT INTO engULB_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Then the priest will burn part of the crushed grain and oil and incense as a representative offering. This is an offering made by fire to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","If someone offers a sacrifice which is a fellowship offering of an animal from the herd, whether male or female, he must offer an animal without blemish before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","He will lay his hand on the head of his offering and kill it at the door of the tent of meeting. Then Aaron's sons the priests will sprinkle its blood on the sides of the altar. ");
INSERT INTO engULB_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","The man will offer the sacrifice of a fellowship offering by fire to Yahweh. The fat that covers or is connected to the inner parts, ");
INSERT INTO engULB_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","and the two kidneys and the fat that is on them by the loins, and the lobe of the liver, with the kidneys—he will remove all of this. ");
INSERT INTO engULB_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Aaron's sons will burn that on the altar with the burnt offering, which is on the wood that is on the fire. This will produce a sweet aroma for Yahweh; it will be an offering made to him by fire. ");
INSERT INTO engULB_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","If the man's sacrifice of a fellowship offering to Yahweh is from the flock; male or female, he must offer a sacrifice without blemish. ");
INSERT INTO engULB_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","If he offers a lamb for his sacrifice, then he must offer it before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","He will lay his hand on the head of his sacrifice and kill it before the tent of meeting. Then Aaron's sons will sprinkle its blood on the sides of the altar. ");
INSERT INTO engULB_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","The man will offer the sacrifice of fellowship offerings as an offering made by fire to Yahweh. The fat, the entire fat tail cut away close to the backbone, and the fat that covers the inner parts and all the fat that is near the inner parts, ");
INSERT INTO engULB_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","and the two kidneys and the fat that is with them, which is by the loins, and the lobe of the liver, with the kidneys—he will remove all of this. ");
INSERT INTO engULB_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Then the priest will burn it all on the altar as a burnt offering of food to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","If the man's offering is a goat, then he will offer it before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","He must lay his hand on the head of the goat and kill it before the tent of meeting. Then the sons of Aaron will sprinkle its blood on the sides of the altar. ");
INSERT INTO engULB_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","The man will offer his sacrifice made by fire to Yahweh. He will remove the fat that covers the inner parts, and all the fat near the inner parts. ");
INSERT INTO engULB_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","He will also remove the two kidneys and the fat that is with them, which is by the loins, and the lobe of the liver with the kidneys. ");
INSERT INTO engULB_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","The priest will burn all that on the altar as a burnt offering of food, to produce a sweet aroma. All the fat belongs to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","It will be a permanent statute throughout your people's generations in every place you make your home, that you must not eat fat or blood.'” ");
INSERT INTO engULB_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Tell the people of Israel, 'When anyone sins without wanting to sin, doing any of the things that Yahweh has commanded not to be done, and if he does something that is prohibited, the following must be done. ");
INSERT INTO engULB_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","If it is the high priest who sins so as to bring guilt on the people, then let him offer for his sin which he has committed a young bull without blemish to Yahweh as a sin offering. ");
INSERT INTO engULB_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","He must bring the bull to the entrance of the tent of meeting before Yahweh, lay his hand on its head, and kill the bull before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","The anointed priest will take some of the blood of the bull and take it to the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","The priest will dip his finger into the blood and sprinkle some of it seven times before Yahweh, before the curtain of the most holy place. ");
INSERT INTO engULB_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Then the priest will put some of the blood on the horns of the altar of fragrant incense before Yahweh, which is in the tent of meeting, and he will pour out all the rest of the blood of the bull at the base of the altar for burnt offerings, which is at the entrance of the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","He will cut away all the fat of the bull of the sin offering; the fat that covers the inner parts, all the fat that is attached to the inner parts, ");
INSERT INTO engULB_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","the two kidneys and the fat that is on them, which is by the loins, and the lobe of the liver, with the kidneys—he will cut away all this. ");
INSERT INTO engULB_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","He will cut it all away, just as he cuts it off from the bull of the sacrifice of peace offerings. Then the priest will burn these parts on the altar for burnt offerings. ");
INSERT INTO engULB_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","The skin of the bull and any remaining meat, with its head and with its legs and its inner parts and its dung, ");
INSERT INTO engULB_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","all the rest of the parts of the bull—he will carry all these parts outside the camp to a place that they have cleansed for me, where they pour out the ashes; they will burn those parts there on wood. They must burn those parts where they pour out the ashes. ");
INSERT INTO engULB_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","If the whole assembly of Israel sins without wanting to sin, and the assembly is unaware that they have sinned and done any of the things which Yahweh has commanded not to be done, and if they are guilty, ");
INSERT INTO engULB_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","then, when the sin they have committed becomes known, then the assembly must offer a young bull for a sin offering and bring it before the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","The elders of the assembly will lay their hands on the head of the bull before Yahweh, and the bull will be killed before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","The anointed priest will bring some of the blood of the bull to the tent of meeting, ");
INSERT INTO engULB_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","and the priest will dip his finger in the blood and sprinkle it seven times before Yahweh, before the curtain. ");
INSERT INTO engULB_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","He will put some of the blood on the horns of the altar that is before Yahweh, which is in the tent of meeting, and he will pour out all the blood at the base of the altar for burnt offerings, which is at the entrance of the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","He will cut off all the fat from it and burn it on the altar. ");
INSERT INTO engULB_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","That is what he must do with the bull. Just as he did with the bull of the sin offering, so will he also do with this bull, and the priest will make atonement for the people, and they will be forgiven. ");
INSERT INTO engULB_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","He will carry the bull outside the camp and burn it as he burned the first bull. This is the sin offering for the assembly. ");
INSERT INTO engULB_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","When a ruler sins without intending to sin, doing any one of all the things that Yahweh his God has commanded not to be done, and he is guilty, ");
INSERT INTO engULB_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","then his sin which he has committed is made known to him, he must bring for his sacrifice a goat, a male without blemish. ");
INSERT INTO engULB_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","He will lay his hand on the head of the goat and kill it in the place where they kill the burnt offering before Yahweh. This is a sin offering. ");
INSERT INTO engULB_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","The priest will take the blood of the sin offering with his finger and put it on the horns of the altar for burnt offerings, and he will pour out its blood at the base of the altar of burnt offering. ");
INSERT INTO engULB_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","He will burn all the fat on the altar, just like the fat of the sacrifice of peace offerings. The priest will make atonement for the ruler concerning his sin, and the ruler will be forgiven. ");
INSERT INTO engULB_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","If anyone of the common people sins without intending to sin, doing any of the things which Yahweh has commanded him not to be done, and when he realizes his guilt, ");
INSERT INTO engULB_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","then his sin which he has committed is made known to him, then he will bring a goat for his sacrifice, a female without blemish, for the sin that he has committed. ");
INSERT INTO engULB_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","He will lay his hand on the head of the sin offering and kill the sin offering at the place of burnt offering. ");
INSERT INTO engULB_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","The priest will take some of the blood with his finger and put it on the horns of the altar for burnt offerings. He will pour out all the rest of the blood at the base of the altar. ");
INSERT INTO engULB_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","He will cut away all the fat, just as the fat is cut away from off the sacrifice of peace offerings. The priest will burn it on the altar to produce a sweet aroma for Yahweh. The priest will make atonement for the man, and he will be forgiven. ");
INSERT INTO engULB_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","If the man brings a lamb as his sacrifice for a sin offering, he will bring a female without blemish. ");
INSERT INTO engULB_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","He will lay his hand on the head of the sin offering and kill it for a sin offering at the place where they kill the burnt offering. ");
INSERT INTO engULB_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","The priest will take some of the blood of the sin offering with his finger and put it on the horns of the altar for burnt offerings, and he will pour out all its blood at the base of the altar. ");
INSERT INTO engULB_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","He will cut away all the fat, just as the fat of the lamb is cut away from the sacrifice of peace offerings, and the priest will burn it on the altar on top of the offerings of Yahweh made by fire. The priest will make atonement for him for the sin he has committed, and the man will be forgiven. ");
INSERT INTO engULB_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","If anyone sins because he does not testify when he has witnessed something about which he is required to testify, whether he has seen it or heard about it, he will be responsible. ");
INSERT INTO engULB_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Or if anyone touches anything God has designated as unclean, whether it be the carcass of an unclean wild animal or the carcass of any livestock that has died, or creeping animal, even if the person did not intend to touch it, he is unclean and guilty. ");
INSERT INTO engULB_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Or if he touches the uncleanness of someone, whatever that uncleanness is, and if he is unaware of it, then he will be guilty when he learns about it. ");
INSERT INTO engULB_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Or if anyone swears rashly with his lips to do evil, or to do good, whatever it is that a man swears rashly with an oath, even if he is unaware of it, when he learns about it, then he will be guilty, in any of these things. ");
INSERT INTO engULB_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","When someone is guilty in any of these things, he must confess whatever sin he has committed. ");
INSERT INTO engULB_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Then he must bring his guilt offering to Yahweh for the sin that he has committed, a female animal from the flock, either a lamb or a goat, for a sin offering, and the priest will make atonement for him concerning his sin. ");
INSERT INTO engULB_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","If he cannot afford to buy a lamb, then he can bring as his guilt offering for his sin two doves or two young pigeons to Yahweh, one for a sin offering and the other for a burnt offering. ");
INSERT INTO engULB_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","He must bring them to the priest, who will offer one for the sin offering first—he will wring off its head from its neck but will not remove it completely from the body. ");
INSERT INTO engULB_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Then he will sprinkle some of the blood of the sin offering on the side of the altar, and he will drain the rest of the blood out at the base of the altar. This is a sin offering. ");
INSERT INTO engULB_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Then he must offer the second bird as a burnt offering, as described in the instructions, and the priest will make atonement for him for the sin that he has committed, and the person will be forgiven. ");
INSERT INTO engULB_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","But if he cannot afford to buy two doves or two young pigeons, then he must bring as his sacrifice for his sin a tenth of an ephah of fine flour for a sin offering. He must not put oil or any incense on it, for it is a sin offering. ");
INSERT INTO engULB_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","He must bring it to the priest, and the priest will take a handful of it as a representative offering and then burn it on the altar, on top of the offerings made by fire for Yahweh. This is a sin offering. ");
INSERT INTO engULB_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","The priest will make atonement for any sin that the person has committed, and that person will be forgiven. The leftovers from the offering will belong to the priest, as with the grain offering.'” ");
INSERT INTO engULB_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Then Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“If anyone sins and acts unfaithfully in regard to the things that belong to Yahweh, but did so unintentionally, then he must bring his guilt offering to Yahweh. This offering must be a ram without blemish from the flock; its value must be appraised in silver shekels—the shekel of the sanctuary—as a guilt offering. ");
INSERT INTO engULB_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","He must satisfy Yahweh for what he had done wrong in connection with what is holy, and he must add one-fifth to it and give it to the priest. Then the priest will make atonement for him with the ram of the guilt offering, and that person will be forgiven. ");
INSERT INTO engULB_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","If anyone sins and does anything that Yahweh has commanded not to be done, even if he was unaware of it, he is still guilty and must carry his own guilt. ");
INSERT INTO engULB_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","He must bring a ram without blemish out of the flock, worth the current value, as a guilt offering to the priest. Then the priest will make atonement for him concerning the sin he has committed, of which he was unaware, and he will be forgiven. ");
INSERT INTO engULB_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","It is a guilt offering, and he is certainly guilty before Yahweh.” ");
INSERT INTO engULB_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“If anyone sins and acts unfaithfully against Yahweh by deceiving his neighbor regarding something held in trust, or was left in his care, or about something that was stolen, or if he has oppressed his neighbor, ");
INSERT INTO engULB_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","or he has found something that his neighbor lost and lies about it, or if he swears falsely, or in any matters like these by which people sin, ");
INSERT INTO engULB_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","and if he has sinned and is found to be guilty, he must restore whatever he took by robbery or oppression, or that which was entrusted to him, or that which was lost but that he had found. ");
INSERT INTO engULB_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","In addition, in any matter in which he swore falsely, he must restore it in full and he must add one-fifth of the value of it and pay it all to the owner on the day that he is found guilty. ");
INSERT INTO engULB_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Then he must bring his guilt offering to Yahweh, a ram without blemish from the flock that is worth the current value, as a guilt offering to the priest. ");
INSERT INTO engULB_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","The priest will make atonement for him before Yahweh, and he will be forgiven concerning whatever he has become guilty of doing.” ");
INSERT INTO engULB_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Then Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Command Aaron and his sons, saying, 'This is the law of the burnt offering: The burnt offering must be on the hearth of the altar all night until morning, and the fire of the altar will be kept burning. ");
INSERT INTO engULB_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","The priest will put on his linen clothes, and he will also put on his linen underclothes. He will pick up the ashes that are left after the fire has consumed the burnt offering on the altar, and he will put the ashes beside the altar. ");
INSERT INTO engULB_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","He will take off his garments and put on other garments to carry the ashes outside the camp to a place that is clean. ");
INSERT INTO engULB_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","The fire on the altar will be kept burning. It must not go out, and the priest will burn wood on it every morning. He will arrange the burnt offering as required on it, and he will burn on it the fat of the peace offerings. ");
INSERT INTO engULB_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Fire must be kept burning on the altar continually. It must not go out. ");
INSERT INTO engULB_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","This is the law of the grain offering. The sons of Aaron will offer it before Yahweh before the altar. ");
INSERT INTO engULB_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","The priest will take up a handful of the fine flour of the grain offering and of the oil and the incense which is on the grain offering, and he will burn it on the altar to produce a sweet aroma as a representative offering. ");
INSERT INTO engULB_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Aaron and his sons will eat whatever is left of the offering. It must be eaten without yeast in a holy place. They will eat it in the courtyard of the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","It must not be baked with yeast. I have given it as their part of my offerings made by fire. It is most holy, as the sin offering and the guilt offering. ");
INSERT INTO engULB_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","For all time to come throughout your people's generations, any male descended from Aaron may eat it as his share, taken from the offerings of Yahweh made by fire. Whoever touches them will become holy.'” ");
INSERT INTO engULB_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","So Yahweh spoke to Moses again, saying, ");
INSERT INTO engULB_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“This is the offering of Aaron and of his sons, which they will offer to Yahweh on the day when each son is anointed: a tenth part of an ephah of fine flour as a regular grain offering, half of it in the morning and half of it in the evening. ");
INSERT INTO engULB_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","It will be made with oil in a baking pan. When it is soaked, you will bring it in. In baked pieces you will offer the grain offering to produce a sweet aroma for Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","The son of the high priest who is becoming the new high priest from among his sons will offer it. As commanded forever, all of it shall be burned to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Every grain offering of the priest will be completely burned up. It must not be eaten.” ");
INSERT INTO engULB_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Yahweh spoke to Moses again, saying, ");
INSERT INTO engULB_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Speak to Aaron and to his sons, saying, 'This is the law of the sin offering: The sin offering must be killed at the place where the burnt offering is killed before Yahweh. It is most holy. ");
INSERT INTO engULB_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","The priest who offers it for sin will eat it. It must be eaten in a holy place in the courtyard of the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Whatever touches its meat will become holy, and if the blood is sprinkled on any garment, you must wash it, the part that was sprinkled on, in a holy place. ");
INSERT INTO engULB_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","But the clay pot in which it is boiled must be broken. If it is boiled in a bronze pot, it must be scrubbed and rinsed clean in water. ");
INSERT INTO engULB_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Any male among the priests may eat some of it because it is most holy. ");
INSERT INTO engULB_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","But any sin offering whose blood is brought into the tent of meeting to make atonement in the holy place must not be eaten. It must be burned. ");
INSERT INTO engULB_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","This is the law of the guilt offering. It is most holy. ");
INSERT INTO engULB_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","They must kill the guilt offering in the place for killing it, and they must sprinkle its blood against every side of the altar. ");
INSERT INTO engULB_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","All the fat in it will be offered: the fat tail, the fat that is over the inner parts, ");
INSERT INTO engULB_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","the two kidneys and the fat on them, which is next to the loins, and what covers the liver, with the kidneys—all this must be removed. ");
INSERT INTO engULB_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","The priest must burn these parts on the altar as an offering made with fire to Yahweh. This is the guilt offering. ");
INSERT INTO engULB_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Every male among the priests may eat part of this offering. It must be eaten in a holy place because it is most holy. ");
INSERT INTO engULB_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","The sin offering is like the guilt offering. The same law applies to both of them. They belong to the priest who makes atonement with them. ");
INSERT INTO engULB_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","The priest who offers anyone's burnt offering may have for himself the hide of that offering. ");
INSERT INTO engULB_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Every grain offering that is baked in an oven, and every such offering that is cooked in a frying pan or in a baking pan will belong to the priest who offers it. ");
INSERT INTO engULB_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Every grain offering, either dry or mixed with oil, will belong equally to all the descendants of Aaron. ");
INSERT INTO engULB_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","This is the law of the sacrifice of peace offerings which people will offer to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","If anyone offers it in order to give thanks, then he must offer it with a sacrifice of cakes made without yeast, but mixed with oil, of cakes made without yeast, but spread with oil, and of cakes made with fine flour that is mixed with oil. ");
INSERT INTO engULB_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Also for the purpose of giving thanks, he must offer with his peace offering cakes of bread made with yeast. ");
INSERT INTO engULB_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","He is to offer one of each kind of these sacrifices as an offering presented to Yahweh. It will belong to the priests who sprinkle the blood of the peace offerings onto the altar. ");
INSERT INTO engULB_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","The person presenting a peace offering for the purpose of giving thanks must eat the meat of his offering on the day of the sacrifice. He must not leave any of it until the next morning. ");
INSERT INTO engULB_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","But if the sacrifice of his offering is for the purpose of a vow, or for the purpose of a freewill offering, the meat must be eaten on the day that he offers his sacrifice, but whatever remains of it may be eaten on the next day. ");
INSERT INTO engULB_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","However, whatever meat of the sacrifice remains on the third day must be burned. ");
INSERT INTO engULB_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","If any of the meat of the sacrifice of one's peace offering is eaten on the third day, it will not be accepted, neither will it be credited to the one who offered it. It will be a disgusting thing, and the person who eats it will carry the guilt of his sin. ");
INSERT INTO engULB_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Any meat that touches an unclean thing must not be eaten. It must be burned. As for the rest of the meat, anyone who is clean may eat it. ");
INSERT INTO engULB_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","However, an unclean person who eats any meat from the sacrifice of a peace offering that belongs to Yahweh—that person must be cut off from his people. ");
INSERT INTO engULB_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","If anyone touches any unclean thing—whether uncleanness of man, or of unclean beast, or of some unclean and disgusting thing, and if he then eats some of the meat of a sacrifice of peace offering that belongs to Yahweh, that person must be cut off from his people.'” ");
INSERT INTO engULB_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Then Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Speak to the people of Israel and say, 'You must eat no fat of an ox or a sheep or a goat. ");
INSERT INTO engULB_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","The fat of an animal that died without being a sacrifice, or the fat of an animal torn by wild animals, may be used for other purposes, but you must certainly not eat it. ");
INSERT INTO engULB_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Whoever eats the fat of an animal that men can offer as a sacrifice by fire to Yahweh, that person must be cut off from his people. ");
INSERT INTO engULB_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","You must eat no blood whatsoever in any of your houses, whether it is from a bird or an animal. ");
INSERT INTO engULB_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Whoever eats any blood, that person must be cut off from his people.'” ");
INSERT INTO engULB_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","So Yahweh spoke to Moses and said, ");
INSERT INTO engULB_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Speak to the people of Israel and say, 'He who offers the sacrifice of a peace offering to Yahweh must bring part of his sacrifice to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","The offering for Yahweh to be made by fire, his own hands must bring it. He must bring the fat with the breast, so that the breast may be waved as a wave offering before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","The priest must burn the fat on the altar, but the breast will belong to Aaron and his descendants. ");
INSERT INTO engULB_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","You must give the right thigh to the priest as an offering presented out of the sacrifice of your peace offerings. ");
INSERT INTO engULB_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","The priest, one of Aaron's descendants, who offers the blood of the peace offerings and the fat—he will have the right thigh as his share of the offering. ");
INSERT INTO engULB_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","For I have taken from the people of Israel, the breast of the wave offering, and the thigh that is the contribution, and they have been given to Aaron the priest and his sons as their regular share. ");
INSERT INTO engULB_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","This is the share for Aaron and his descendants from the offerings for Yahweh made by fire, on the day when Moses presented them to serve Yahweh in the work of priest. ");
INSERT INTO engULB_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","This is the share that Yahweh commanded to be given them from the people of Israel, on the day that he anointed the priests. It will always be their share throughout all generations. ");
INSERT INTO engULB_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","This is the law of the burnt offering, of the grain offering, of the sin offering, of the guilt offering, of the consecration offering, and of the sacrifice of peace offerings, ");
INSERT INTO engULB_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","about which Yahweh gave commands to Moses on Mount Sinai on the day that he commanded the people of Israel to offer their sacrifices to Yahweh in the wilderness of Sinai.'” ");
INSERT INTO engULB_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Take Aaron and his sons with him, the garments and the anointing oil, the bull for the sin offering, the two rams, and the basket of unleavened bread. ");
INSERT INTO engULB_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Assemble all the assembly at the entrance to the tent of meeting.” ");
INSERT INTO engULB_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","So Moses did as Yahweh commanded him, and the assembly came together at the entrance to the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Then Moses said to the assembly, “This is what Yahweh has commanded to be done.” ");
INSERT INTO engULB_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Moses brought Aaron and his sons and washed them with water. ");
INSERT INTO engULB_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","He put on Aaron the tunic and tied the sash around his waist, clothed him with the robe and put the ephod on him, and then he tied the ephod around him with the finely-woven waistband and bound it to him. ");
INSERT INTO engULB_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","He placed the breastpiece on him, and in the breastpiece he put the Urim and the Thummim. ");
INSERT INTO engULB_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","He set the turban on his head, and on the turban, in front, he set the golden plate, the holy crown, as Yahweh had commanded him. ");
INSERT INTO engULB_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Moses took the anointing oil, anointed the tabernacle and everything in it and set them apart to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","He sprinkled the oil on the altar seven times, and anointed the altar and all its utensils, and the washbasin and its base, to set them apart to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","He poured some of the anointing oil on Aaron's head and anointed him to set him apart. ");
INSERT INTO engULB_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Moses brought Aaron's sons and clothed them with tunics. He tied sashes around their waists and wrapped linen cloth around their heads, as Yahweh had commanded him. ");
INSERT INTO engULB_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Moses brought the bull for the sin offering, and Aaron and his sons laid their hands on the head of the bull that they had brought for the sin offering. ");
INSERT INTO engULB_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","He killed it, and he took the blood and put it on the horns of the altar with his finger, purified the altar, poured out the blood at the base of the altar, and set it apart for God in order to make atonement for it. ");
INSERT INTO engULB_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","He took all the fat that was on the inner parts, the covering of the liver, and the two kidneys and their fat, and Moses burned it all on the altar. ");
INSERT INTO engULB_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","But the bull, its hide, its meat, and its dung he burned outside the camp, as Yahweh had commanded him. ");
INSERT INTO engULB_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Moses presented the ram for the burnt offering, and Aaron and his sons laid their hands on the head of the ram. ");
INSERT INTO engULB_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","He killed it and sprinkled its blood against every side of the altar. ");
INSERT INTO engULB_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","He cut the ram into pieces and burned the head and the pieces and the fat. ");
INSERT INTO engULB_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","He washed the inner parts and the legs with water, and he burned the whole ram on the altar. It was a burnt offering and produced a sweet aroma, an offering made by fire to Yahweh as Yahweh had commanded Moses. ");
INSERT INTO engULB_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Then Moses presented the other ram, the ram of consecration, and Aaron and his sons laid their hands on the head of the ram. ");
INSERT INTO engULB_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Aaron killed it, and Moses took some of its blood and put it on the tip of Aaron's right ear, on the thumb of his right hand, and on the big toe of his right foot. ");
INSERT INTO engULB_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","He brought Aaron's sons, and he put some of the blood on the tip of their right ear, on the thumb of their right hand, and on the big toe of their right foot. Then Moses sprinkled its blood against every side of the altar. ");
INSERT INTO engULB_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","He took the fat, the fat tail, all the fat that was on the inner parts, the covering of the liver, the two kidneys and their fat, and the right thigh. ");
INSERT INTO engULB_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Out of the basket of bread without yeast that was before Yahweh, he took one loaf without yeast, and one loaf of oiled bread, and one wafer, and placed them on the fat and on the right thigh. ");
INSERT INTO engULB_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","He put it all in the hands of Aaron and in the hands of his sons and waved them before Yahweh as a wave offering. ");
INSERT INTO engULB_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Then Moses took them from off their hands and burned them on the altar for the burnt offering. They were a consecration offering and produced a sweet aroma. It was an offering made by fire to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moses took the breast and waved it as a wave offering to Yahweh. It was Moses' share of the ram for the priests' ordination, as Yahweh had commanded him. ");
INSERT INTO engULB_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Moses took some of the anointing oil and the blood that was on the altar; he sprinkled these on Aaron, on his clothes, on his sons, and on his sons' clothes with him. In this way he set apart Aaron and his clothes, and his sons and their clothes to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","So Moses said to Aaron and to his sons, “Boil the meat at the entrance to the tent of meeting, and there eat it and the bread that is in the basket of consecration, as I commanded, saying, 'Aaron and his sons will eat it.' ");
INSERT INTO engULB_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Whatever remains of the meat and of the bread you must burn. ");
INSERT INTO engULB_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","You must not go out from the entrance of the tent of meeting for seven days, until the days of your ordination are fulfilled. For Yahweh will consecrate you for seven days. ");
INSERT INTO engULB_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","What has been done this day— Yahweh has commanded to be done to make atonement for you. ");
INSERT INTO engULB_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","You will stay day and night for seven days at the entrance to the tent of meeting, and keep the command of Yahweh, so you will not die, because this is what I have been commanded.” ");
INSERT INTO engULB_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","So Aaron and his sons did all the things which Yahweh had commanded them through Moses. ");
INSERT INTO engULB_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","On the eighth day Moses called Aaron and his sons and the elders of Israel. ");
INSERT INTO engULB_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","He said to Aaron, “Take a calf from the herd for a sin offering, and a ram without blemish for a burnt offering, and offer them before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","You must speak to the people of Israel and say, 'Take a male goat for a sin offering and a calf and a lamb, both a year old and without blemish, for a burnt offering; ");
INSERT INTO engULB_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","also take an ox and a ram for peace offerings to sacrifice before Yahweh, and a grain offering mixed with oil, because today Yahweh will appear to you.'” ");
INSERT INTO engULB_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","So they brought all that Moses commanded to the tent of meeting, and all the assembly of Israel approached and stood before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Then Moses said, “This is what Yahweh commanded you to do, so that his glory may appear to you.” ");
INSERT INTO engULB_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Moses said to Aaron, “Come near the altar and offer your sin offering and burnt offering, and make atonement for yourself and for the people, and offer the sacrifice for the people to make atonement for them, as Yahweh has commanded.” ");
INSERT INTO engULB_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","So Aaron went near the altar and killed the calf for the sin offering, which was for himself. ");
INSERT INTO engULB_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","The sons of Aaron presented the blood to him, and he dipped his finger into it and put it on the horns of the altar; then he poured out the blood at the base of the altar. ");
INSERT INTO engULB_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","However, he burned the fat, the kidneys, and the covering of the liver on the altar as a sin offering, as Yahweh had commanded Moses. ");
INSERT INTO engULB_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","The meat and the hide he burned outside the camp. ");
INSERT INTO engULB_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Aaron killed the burnt offering, and his sons gave him the blood, which he splashed against every side of the altar. ");
INSERT INTO engULB_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Then they gave him the burnt offering, piece by piece, together with the head, and he burned them on the altar. ");
INSERT INTO engULB_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","He washed the inner parts and the legs and burned them on top of the burnt offering on the altar. ");
INSERT INTO engULB_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Aaron presented the people's sacrifice—a goat, then took it as the sacrifice for their sin and killed it; he sacrificed it for sin, as he had done with the first goat. ");
INSERT INTO engULB_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","He presented the burnt offering and offered it as Yahweh had commanded. ");
INSERT INTO engULB_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","He presented the grain offering; he filled his hand with it and burned it on the altar, along with the morning's burnt offering. ");
INSERT INTO engULB_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","He killed also the ox and the ram, the sacrifice for the peace offering, which was for the people. Aaron's sons gave him the blood, which he sprinkled against every side of the altar. ");
INSERT INTO engULB_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","However, they cut out the fat of the bull and the ram, the fat tail, the fat that covers the inner parts, the kidneys, and the covering of the liver. ");
INSERT INTO engULB_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","They took the parts that were cut out and put these on the breasts, and then Aaron burned the fat on the altar. ");
INSERT INTO engULB_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Aaron waved the breasts and the right thigh as a wave offering before Yahweh, as Moses had commanded. ");
INSERT INTO engULB_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Then Aaron lifted up his hands toward the people and blessed them; then he came down from offering the sin offering, the burnt offering, and the peace offering. ");
INSERT INTO engULB_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moses and Aaron went into the tent of meeting, then came out again and blessed the people, and the glory of Yahweh appeared to all the people. ");
INSERT INTO engULB_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Fire came out from Yahweh and consumed the burnt offering and the fat on the altar. When all the people saw this, they shouted and lay facedown. ");
INSERT INTO engULB_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadab and Abihu, sons of Aaron, each took his censer, put fire in it, and then incense. Then they offered unapproved fire before Yahweh, which he had not commanded them to offer. ");
INSERT INTO engULB_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","So fire came out from before Yahweh and devoured them, and they died before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Then Moses said to Aaron, “This is what Yahweh was talking about when he said, 'I will reveal my holiness to those who come near me. I will be glorified before all the people.'” Aaron did not say anything. ");
INSERT INTO engULB_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Moses called Mishael and Elzaphan, the sons of Uzziel the uncle of Aaron, and said to them, “Come here and carry your brothers out of the camp from before the tabernacle.” ");
INSERT INTO engULB_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","So they came near and carried them, still wearing their priestly tunics, out of the camp, as Moses had instructed. ");
INSERT INTO engULB_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Then Moses said to Aaron and to Eleazar and to Ithamar, his sons, “Do not let your hair on your heads hang loosely, and do not tear your clothes, so that you may not die, and so that Yahweh may not be angry with all the assembly. But allow your relatives, the entire house of Israel, to mourn for those whom the fire of Yahweh has set ablaze. ");
INSERT INTO engULB_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","You must not go out from the entrance of the tent of meeting, or you will die, for the anointing oil of Yahweh is on you.” So they acted according to Moses' instructions. ");
INSERT INTO engULB_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Yahweh spoke to Aaron, saying, ");
INSERT INTO engULB_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Do not drink wine or strong drink, you, or your sons who remain with you, when you go into the tent of meeting, so you will not die. This will be a permanent statute throughout your people's generations, ");
INSERT INTO engULB_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","to distinguish between the holy and the common, and between the unclean and the clean, ");
INSERT INTO engULB_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","so that you may teach the people of Israel all the statutes that Yahweh has commanded through Moses.” ");
INSERT INTO engULB_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Moses spoke to Aaron and to Eleazar and to Ithamar, his remaining sons, “Take the grain offering that remains from the offerings to Yahweh made by fire, and eat it without yeast beside the altar, for it is most holy. ");
INSERT INTO engULB_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","You must eat it in a holy place, because it is your share and your sons' share of the offerings to Yahweh made by fire, for this is what I have been commanded to tell you. ");
INSERT INTO engULB_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","The breast that is waved and the thigh that is presented to Yahweh, you must eat in a clean place acceptable to God. You and your sons and daughters with you should eat those portions, for they are given as your share and your sons' share out of the sacrifices of the fellowship offerings of the people of Israel. ");
INSERT INTO engULB_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","The thigh that is presented and the breast that is waved, they must bring with the offerings of fat made by fire, to wave before Yahweh. They will be yours and your sons' with you as a share forever, as Yahweh has commanded.” ");
INSERT INTO engULB_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Then Moses asked about the goat for the sin offering, and found that it was burned up. So he was angry with Eleazar and Ithamar, the remaining sons of Aaron; he said, ");
INSERT INTO engULB_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Why have you not eaten the sin offering in the area of the tabernacle, since it is most holy, and since Yahweh has given it to you to take away the iniquity of the assembly, to make atonement for them before him? ");
INSERT INTO engULB_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Look, its blood was not brought inside the tabernacle, so you should certainly have eaten it in the tabernacle area, as I commanded.” ");
INSERT INTO engULB_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Then Aaron answered Moses, “See, today they made their sin offering and burnt offering before Yahweh, and this thing has happened to me today. If I had eaten the sin offering today, would it have been pleasing in the sight of Yahweh?” ");
INSERT INTO engULB_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","When Moses heard that, he was satisfied. ");
INSERT INTO engULB_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Yahweh spoke to Moses and to Aaron, saying, ");
INSERT INTO engULB_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Speak to the people of Israel, saying, 'These are the living things which you may eat among all the animals that are on the earth. ");
INSERT INTO engULB_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","You may eat any animal that has a split hoof and that also chews the cud. ");
INSERT INTO engULB_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","However, some animals either chew the cud or have a split hoof, and you must not eat them, animals such as the camel, because it chews the cud but does not have a split hoof. So the camel is unclean to you. ");
INSERT INTO engULB_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Also the rock badger, because it chews the cud but does not have a split hoof, it is also unclean to you. ");
INSERT INTO engULB_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","The rabbit, because it chews the cud, but does not have a split hoof, is unclean to you. ");
INSERT INTO engULB_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","The pig, although it has a split hoof, does not chew the cud, is unclean to you. ");
INSERT INTO engULB_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","You must not eat any of their meat, nor touch their carcasses. They are unclean to you. ");
INSERT INTO engULB_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","The animals living in the water that you may eat are all those that have fins and scales, whether in the ocean or in the rivers. ");
INSERT INTO engULB_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","But all living creatures that do not have fins and scales in the ocean or rivers, including all that move in the water and all the living creatures that are in the water— they must be detested by you. ");
INSERT INTO engULB_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Since they must be detested, you must not eat of their meat; also, their carcasses must be detested. ");
INSERT INTO engULB_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Whatever has no fins or scales in the water must be detested by you. ");
INSERT INTO engULB_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","The birds you must detest and that you must not eat are these: the eagle, the vulture, ");
INSERT INTO engULB_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","the kite, any kind of falcon, ");
INSERT INTO engULB_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","every kind of raven, ");
INSERT INTO engULB_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","the horned owl and the screech owl, the seagull, and any kind of hawk. ");
INSERT INTO engULB_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","You must also detest the little owl and the great owl, the cormorant, ");
INSERT INTO engULB_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","the white owl and the barn owl, the osprey, ");
INSERT INTO engULB_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","the stork, any kind of heron, the hoopoe, and also the bat. ");
INSERT INTO engULB_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","All winged insects that walk on four legs are detestable to you. ");
INSERT INTO engULB_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Yet you may eat any of the flying insects that also walk on four legs if they have jointed legs for hopping on the ground. ");
INSERT INTO engULB_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","You may also eat any kind of locust, katydid, cricket, or grasshopper. ");
INSERT INTO engULB_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","But all the flying insects that have four feet must be detested by you. ");
INSERT INTO engULB_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","You will become unclean until evening by these animals if you touch a carcass of one of them. ");
INSERT INTO engULB_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Whoever picks up one of their carcasses must wash his clothes and remain unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Every animal which has a split hoof that is not completely divided or which does not chew the cud is unclean to you. Everyone who touches them will be unclean. ");
INSERT INTO engULB_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Whatever walks on its paws among all the animals that walk on all four legs, they are unclean to you. Whoever touches such a carcass will be unclean until the evening. ");
INSERT INTO engULB_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Whoever picks up such a carcass must wash his clothes and be unclean until the evening. These animals will be unclean to you. ");
INSERT INTO engULB_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Of the animals that creep on the ground, these are the animals that will be unclean to you: the weasel, the rat, every kind of large lizard, ");
INSERT INTO engULB_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","the gecko, the monitor lizard, the lizard, the skink, and the chameleon. ");
INSERT INTO engULB_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Of all the animals that creep, these are the animals which will be unclean to you. Whoever touches them when they are dead will be unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","If any of them dies and falls on anything, that thing will be unclean, whether it is made of wood, cloth, leather, or sackcloth. Whatever it is and whatever it is used for, it must be put into water; it will be unclean until evening. Then it will be clean. ");
INSERT INTO engULB_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","For every clay pot into or onto which any unclean animal falls, whatever is in the pot will become unclean, and you must destroy that pot. ");
INSERT INTO engULB_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Any food that could be eaten but has water on it from such a pot is unclean. Any liquid that is for drinking from such a pot is unclean. ");
INSERT INTO engULB_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Anything that one of their carcasses falls on becomes unclean; if it is an oven or small stove, it must be broken to pieces. They are unclean and they must remain unclean to you. ");
INSERT INTO engULB_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","A spring or cistern for collecting water remains clean; but anyone who touches their carcass is unclean. ");
INSERT INTO engULB_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","If any part of their carcass falls upon any seeds for planting, those seeds will still be clean. ");
INSERT INTO engULB_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","But if water is put on the seeds, and if any part of their carcass falls on them, then they will be unclean to you. ");
INSERT INTO engULB_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","If any animal that you may eat dies, then he who touches the carcass will be unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Whoever eats any of that carcass must wash his clothes and be unclean until evening. Anyone who picks up such a carcass will wash his clothes and be unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Every animal that creeps on the ground is to be detested; it must not be eaten. ");
INSERT INTO engULB_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Whatever crawls on its belly, and whatever walks on all four legs, or whatever has many feet—all the animals that creep on the ground, these you must not eat, for they are to be detested. ");
INSERT INTO engULB_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","You must not make yourselves unclean with any living creatures that creep; you must not make yourselves unclean with them, that you should be made impure by them. ");
INSERT INTO engULB_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","For I am Yahweh your God. You are to keep yourselves holy, therefore, and be holy, because I am holy. You must not defile yourselves with any kind of animal that moves about on the ground. ");
INSERT INTO engULB_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","For I am Yahweh, who brought you up out of the land of Egypt, to be your God. You must therefore be holy, for I am holy. ");
INSERT INTO engULB_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","This is the law regarding the animals, the birds, every living creature that moves in the waters, and of every creature that creeps on the ground, ");
INSERT INTO engULB_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","for which a distinction is to be made between the unclean and the clean, and between the living things that may be eaten and the living things that may not be eaten.'” ");
INSERT INTO engULB_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Yahweh said to Moses, ");
INSERT INTO engULB_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Speak to the people of Israel, saying, 'If a woman conceives and gives birth to a male child, then she will be unclean for seven days, just as she is unclean during the days of her monthly period. ");
INSERT INTO engULB_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","On the eighth day the flesh of a baby boy's foreskin must be circumcised. ");
INSERT INTO engULB_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Then the mother's purification from her bleeding will continue for thirty-three days. She must not touch any holy thing or come into the tabernacle area until the days of her purification are finished. ");
INSERT INTO engULB_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","But if she gives birth to a female child, then she will be unclean for two weeks, as she is during her period. Then the mother's purification will continue for sixty-six days. ");
INSERT INTO engULB_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","When the days of her purification are finished, for a son or for a daughter, she must bring a one year old lamb as a burnt offering, and a young pigeon or dove as a sin offering, to the entrance of the tent of meeting, to the priest. ");
INSERT INTO engULB_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Then he will offer it before Yahweh and make atonement for her, and she will be cleansed from the flow of her blood. This is the law regarding a woman who gives birth to either a male or a female child. ");
INSERT INTO engULB_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","If she is not able to afford a lamb, then she must take two doves or two young pigeons, one as a burnt offering and the other as a sin offering, and the priest will make atonement for her; then she will be clean.'” ");
INSERT INTO engULB_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Yahweh spoke to Moses and to Aaron, saying, ");
INSERT INTO engULB_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“When anyone has on the skin of his body a swelling or scab or a bright spot, and it becomes infected and there is a skin disease in his body, then he must be brought to Aaron the high priest, or to one of his sons the priests. ");
INSERT INTO engULB_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Then the priest will examine the disease in the skin of his body. If the hair in the diseased area has turned white, and if the disease appears to be deeper than just on the skin, then it is an infectious disease. After the priest examines him, he must pronounce him unclean. ");
INSERT INTO engULB_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","If the bright spot in his skin is white, and the appearance of it is no deeper than the skin, and if the hair in the diseased area has not turned white, then the priest must isolate the one with the disease for seven days. ");
INSERT INTO engULB_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","On the seventh day, the priest must examine him to see if in his opinion the disease is not any worse, and if it has not spread in the skin. If it has not, then the priest must isolate him seven days more. ");
INSERT INTO engULB_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","The priest will examine him again on the seventh day to see if the disease is better and has not spread farther in the skin. If it has not, then the priest will pronounce him clean. It is a rash. He must wash his clothes, and then he is clean. ");
INSERT INTO engULB_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","But if the rash has spread in the skin after he has shown himself to the priest for his cleansing, he must then show himself to the priest again. ");
INSERT INTO engULB_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","The priest will examine him to see if the rash has spread farther in the skin. If it has spread, then the priest must pronounce him unclean. It is an infectious disease. ");
INSERT INTO engULB_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","When an infectious skin disease is in someone, then he must be brought to the priest. ");
INSERT INTO engULB_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","The priest will examine him to see if there is a white swelling in the skin, if the hair has turned white, or if there is raw flesh in the swelling. ");
INSERT INTO engULB_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","If there is, then it is a chronic skin disease, and the priest must pronounce him unclean. He will not isolate him, because he is already unclean. ");
INSERT INTO engULB_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","If the disease breaks out widely in the skin and covers all the skin of the person with the disease from his head to his feet, as far as it appears to the priest, ");
INSERT INTO engULB_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","then the priest must examine him to see if the disease has covered all his body. If it has, then the priest must pronounce the person who has the disease as clean. If it has all turned white, then he is clean. ");
INSERT INTO engULB_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","But if raw flesh appears on him, he will be unclean. ");
INSERT INTO engULB_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","The priest must look at the raw flesh and pronounce him unclean because the raw flesh is unclean. It is an infectious disease. ");
INSERT INTO engULB_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","But if the raw flesh turns white again, then the person must go to the priest. ");
INSERT INTO engULB_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","The priest will examine him to see if the flesh has turned white. If it has then the priest will pronounce that person to be clean. ");
INSERT INTO engULB_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","When a person has a boil on the skin and it has healed, ");
INSERT INTO engULB_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","and in place of the boil there is white swelling or a bright spot, reddish-white, then it must be shown to the priest. ");
INSERT INTO engULB_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","The priest will examine it to see if it appears deeper under the skin, and if the hair there has turned white. If so, then the priest must pronounce him unclean. It is an infectious disease, if it has developed in the place where the boil was. ");
INSERT INTO engULB_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","But if the priest examines it and sees that there is no white hair in it, and that it is not under the skin but has faded, then the priest must isolate him for seven days. ");
INSERT INTO engULB_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","If it spreads widely in the skin, then the priest must pronounce him unclean. It is an infectious disease. ");
INSERT INTO engULB_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","But if the bright spot stays in its place and has not spread, then it is the scar of the boil, and the priest must pronounce him clean. ");
INSERT INTO engULB_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","When the skin has a burn and the raw flesh of the burn has become a reddish-white or white spot, ");
INSERT INTO engULB_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","then the priest will examine it to see if the hair in that spot has turned white, and if it appears to be deeper than the skin. If it has, then it is an infectious disease. It has broken out in the burn, and the priest must pronounce him unclean. It is an infectious disease. ");
INSERT INTO engULB_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","But if the priest examines it and finds that there is no white hair in the spot, and it is not under the skin but has faded, then the priest must isolate him for seven days. ");
INSERT INTO engULB_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Then the priest must examine him on the seventh day. If it has spread widely in the skin, then the priest must pronounce him unclean. It is an infectious disease. ");
INSERT INTO engULB_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","If the spot stays in its place and has not spread in the skin but has faded, then it is a swelling from the burn, and the priest must pronounce him clean, for it is nothing more than the scar of the burn. ");
INSERT INTO engULB_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","If a man or woman has an infectious disease on the head or chin, ");
INSERT INTO engULB_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","then the priest must examine the person for an infectious disease to see if it appears to be deeper than the skin, and if there is yellow, thin hair in it. If there is, then the priest must pronounce him unclean. It is an itch, an infectious disease on the head or the chin. ");
INSERT INTO engULB_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","If the priest examines the itching disease and sees that it is not under the skin, and if there is no black hair in it, then the priest will isolate the person with the itching disease for seven days. ");
INSERT INTO engULB_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","On the seventh day the priest will examine the disease to see if it has spread. If there is no yellow hair, and if the disease appears to be only skin deep, ");
INSERT INTO engULB_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","then he must be shaved, but the diseased area must not be shaved, and the priest must isolate the person with the itching disease for seven more days. ");
INSERT INTO engULB_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","On the seventh day the priest will examine the disease to see if it has stopped spreading in the skin. If it appears to be no deeper than the skin, then the priest must pronounce him clean. The person must wash his clothes, and then he will be clean. ");
INSERT INTO engULB_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","But if the itching disease has spread widely in the skin after the priest said he was clean, ");
INSERT INTO engULB_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","then the priest must examine him again. If the disease has spread in the skin, the priest does not need to seek for yellow hair. The person is unclean. ");
INSERT INTO engULB_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","But if in the priest's view the itching disease has stopped spreading and black hair has grown in the area, then the disease has healed. He is clean, and the priest must pronounce him clean. ");
INSERT INTO engULB_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","If a man or a woman has white spots on the skin, ");
INSERT INTO engULB_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","then the priest must examine the person to see if the spots are a dull white, which is only a rash that has broken out in the skin. He is clean. ");
INSERT INTO engULB_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","If a man's hair has fallen out of his head, he is bald, but he is clean. ");
INSERT INTO engULB_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","If his hair has fallen out of the front part of his head, and if his forehead is bald, he is clean. ");
INSERT INTO engULB_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","But if there is a reddish-white sore on his bald head or forehead, it is an infectious disease that has broken out. ");
INSERT INTO engULB_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Then the priest must examine him to see if the swelling of the diseased area on his bald head or forehead is reddish-white, like the appearance of an infectious disease in the skin. ");
INSERT INTO engULB_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","If it is, then he has an infectious disease and he is unclean. The priest must surely pronounce him unclean because of his disease on his head. ");
INSERT INTO engULB_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","The person who has an infectious disease must wear torn clothes, his hair must hang loosely, and he must cover his face up to his nose and call out, 'Unclean, unclean.' ");
INSERT INTO engULB_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","All the days that he has the infectious disease he will be unclean. Because he is unclean with a disease that can spread, he must live alone. He must live outside the camp. ");
INSERT INTO engULB_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","A garment that is contaminated with mildew, whether it is a wool or linen garment, ");
INSERT INTO engULB_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","or anything woven or knitted from wool or linen, or leather or anything made with leather— ");
INSERT INTO engULB_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","if there is a greenish or reddish contamination in the garment, the leather, the woven or knitted material, or anything made of leather, then it is a mildew that spreads; it must be shown to the priest. ");
INSERT INTO engULB_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","The priest must examine the item for mildew; he must isolate anything that has mildew for seven days. ");
INSERT INTO engULB_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","He must examine the mildew again on the seventh day. If it has spread in the garment or anything woven or knitted from wool or linen material, or leather or anything in which leather is used, then it is harmful mildew, and the item is unclean. ");
INSERT INTO engULB_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","He must burn the garment, or anything woven or knitted from wool or linen material, or leather or anything made with leather, anything in which the harmful mildew is found, for it can lead to disease. The item must be completely burned up. ");
INSERT INTO engULB_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","If the priest examines the item and sees that the mildew has not spread in the garment or material woven or knitted from wool or linen, or leather goods, ");
INSERT INTO engULB_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","then he will command them to wash the item in which the mildew was found, and he must isolate it for seven more days. ");
INSERT INTO engULB_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Then the priest will examine the item after the mildewed item was washed. If the mildew has not changed its color, even though it has not spread, it is unclean. You must burn the item, no matter where the mildew has contaminated it. ");
INSERT INTO engULB_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","If the priest examines the item, and if the mildew has faded after it was washed, then he must tear out the contaminated part from the garment or from the leather, or from the woven or knitted material. ");
INSERT INTO engULB_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","If the mildew still appears in the garment, either in the woven or knitted material, or in anything made of leather, it is spreading. You must burn any item that has the mildew. ");
INSERT INTO engULB_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","The garment or anything woven or knitted from wool or linen material, or leather or anything made with leather—if you wash the item and the mildew is gone, then the item must be washed a second time, and it will be clean. ");
INSERT INTO engULB_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","This is the law about mildew in a garment of wool or linen, or anything woven or knitted from wool or linen material, or leather or anything made with leather, so that you may pronounce it clean or unclean.” ");
INSERT INTO engULB_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“This will be the law for the diseased person on the day of his cleansing. He must be brought to the priest. ");
INSERT INTO engULB_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","The priest will go out of the camp to examine the person to see if the infectious skin disease is healed. ");
INSERT INTO engULB_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Then the priest will command that the one to be cleansed must take two live, clean birds, cedar wood, scarlet yarn, and hyssop. ");
INSERT INTO engULB_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","The priest will command him to kill one of the birds over fresh water that is in a clay pot. ");
INSERT INTO engULB_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","The priest will then take the live bird and the cedar wood, and the scarlet yarn and the hyssop, and he will dip all these things, including the live bird, in the blood of the bird that was killed over the fresh water. ");
INSERT INTO engULB_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Then the priest will sprinkle this water seven times onto the person who is to be cleansed from the disease, and then the priest will pronounce him to be clean. Then the priest will release the living bird into the open fields. ");
INSERT INTO engULB_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","The person who is being cleansed will wash his clothes, shave off all his hair, and bathe himself in water, and then he will be clean. After that he must come into the camp, but he will live outside his tent for seven days. ");
INSERT INTO engULB_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","On the seventh day he must shave all his hair off his head, and he must also shave off his beard and eyebrows. He must shave off all his hair, and he must wash his clothes and bathe himself in water; then he will be clean. ");
INSERT INTO engULB_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","On the eighth day he must take two male lambs without blemish, one female lamb a year old without blemish, and three-tenths of an ephah of fine flour mixed with oil as a grain offering, and one log of oil. ");
INSERT INTO engULB_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","The priest who cleanses him will stand the person who is to be cleansed, along with those things, before Yahweh at the entrance to the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","The priest will take one of the male lambs and offer it as a guilt offering, together with the log of oil; he will wave them for a wave offering before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","He must kill the male lamb in the place where they kill the sin offerings and the burnt offerings, in the area of the tabernacle, for the sin offering belongs to the priest, as does the guilt offering, because it is most holy. ");
INSERT INTO engULB_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","The priest will take some of the blood of the guilt offering and put it on the tip of the right ear of the person who is to be cleansed, on the thumb of his right hand, and on the big toe of his right foot. ");
INSERT INTO engULB_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Then the priest will take oil from the log and pour it into the palm of his own left hand, ");
INSERT INTO engULB_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","and dip his right finger in the oil that is in his left hand, and sprinkle some of the oil with his finger seven times before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","The priest will put the rest of the oil in his hand on the tip of the right ear of the person to be cleansed, on the thumb of his right hand, and on the big toe of his right foot. He must put this oil on top of the blood from the guilt offering. ");
INSERT INTO engULB_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","As for the rest of the oil that is in the priest's hand, he will put it on the head of the person who is to be cleansed, and the priest will make atonement for him before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Then the priest will offer the sin offering and make atonement for him who is to be cleansed because of his uncleanness, and afterward he will kill the burnt offering. ");
INSERT INTO engULB_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Then the priest will offer the burnt offering and the grain offering on the altar. The priest will make atonement for the person, and then he will be clean. ");
INSERT INTO engULB_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","However, if the person is poor and cannot afford these sacrifices, then he may take one male lamb as a guilt offering to be waved, to make atonement for himself, and one-tenth of an ephah of fine flour mixed with oil as a grain offering, and a log of oil, ");
INSERT INTO engULB_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","together with two doves or two young pigeons, such as he is able to get; one bird will be a sin offering and the other a burnt offering. ");
INSERT INTO engULB_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","On the eighth day he must bring them for his cleansing to the priest, to the entrance to the tent of meeting, before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","The priest will take the lamb for an offering, and he will take with it the log of olive oil, and he will lift them high as he presents them to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","He will kill the lamb for the guilt offering, and he will take some of the blood of the guilt offering and put it on the tip of the right ear of the one who is to be cleansed, on the thumb of his right hand, and on the big toe of his right foot. ");
INSERT INTO engULB_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Then the priest will pour some of the oil into the palm of his own left hand, ");
INSERT INTO engULB_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","and he will sprinkle with his right finger some of the oil that is in his left hand seven times before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","The priest will then put some of the oil that is in his hand on the tip of the right ear of the one who is to be cleansed, on the thumb of his right hand, and on the big toe of his right foot, the same places where he put the blood of the guilt offering. ");
INSERT INTO engULB_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","He will put the rest of the oil that is in his hand on the head of the one who is to be cleansed, to make atonement for him before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","He must offer one of the doves or young pigeons, such as the person has been able to get— ");
INSERT INTO engULB_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","one as a sin offering and the other as a burnt offering, along with the grain offering. Then the priest will make atonement for the one who is to be cleansed before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","This is the law for a person in whom there is an infectious skin disease, who is not able to afford the standard offerings for his cleansing.” ");
INSERT INTO engULB_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Yahweh spoke to Moses and to Aaron, saying, ");
INSERT INTO engULB_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“When you have come into the land of Canaan which I gave to you as a possession, and if I put mildew that spreads in a house in the land of your possession, ");
INSERT INTO engULB_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","then he who owns the house must come and tell the priest. He must say, 'There seems to me to be something like mildew in my house.' ");
INSERT INTO engULB_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Then the priest will command that they empty the house before he goes in to see the evidence of mildew, so that nothing in the house will be made unclean. Afterward the priest must go in to see the house. ");
INSERT INTO engULB_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","He must examine the mildew to see if it is in the house walls, and to see whether it appears greenish or reddish in the depressions in the wall's surface. ");
INSERT INTO engULB_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","If the house does have mildew, then the priest will go out of the house and shut the door to the house for seven days. ");
INSERT INTO engULB_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Then the priest will return again on the seventh day and examine it to see if the mildew has spread in the walls of the house. ");
INSERT INTO engULB_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","If it has, then the priest will command that they take out the stones in which the mildew has been found and throw them into an unclean place outside the city. ");
INSERT INTO engULB_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","He will require all the inside walls of the house to be scraped, and they must take the contaminated material that is scraped off outside the city and dump it into the unclean place. ");
INSERT INTO engULB_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","They must take other stones and put them in the place of the stones that were removed, and they must use new clay to plaster the house. ");
INSERT INTO engULB_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","If mildew comes again and breaks out in the house in which the stones have been taken away and the walls have been scraped and then replastered, ");
INSERT INTO engULB_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","then the priest must come in and examine the house to see if mildew has spread in the house. If it has, then it is harmful mildew, and the house is unclean. ");
INSERT INTO engULB_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","The house must be torn down. The stones, timber, and all the plaster in the house must be carried away out of the city to the unclean place. ");
INSERT INTO engULB_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","In addition, whoever goes into the house during the time it is closed up will be unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Anyone who slept in the house must wash his clothes, and anyone who ate in the house must wash his clothes. ");
INSERT INTO engULB_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","If the priest enters the house to examine it to see whether the mildew has spread in the house after the house was plastered, then, if the mildew is gone, he will pronounce the house clean. ");
INSERT INTO engULB_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Then the priest must take two birds to cleanse the house, and cedar wood, and scarlet yarn, and hyssop. ");
INSERT INTO engULB_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","He will kill one of the birds over fresh water in a clay jar. ");
INSERT INTO engULB_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","He will take the cedar wood, the hyssop, the scarlet yarn, and the live bird, and dip them in the blood of the killed bird, into the fresh water, and sprinkle the house seven times. ");
INSERT INTO engULB_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","He will cleanse the house with the blood of the bird and with the fresh water, with the live bird, the cedar wood, the hyssop, and the scarlet yarn. ");
INSERT INTO engULB_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","But he will let the live bird go out of the city into the open fields. In this way he must make atonement for the house, and it will be clean. ");
INSERT INTO engULB_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","This is the law for all types of infectious skin disease and things that cause such disease, and for an itch, ");
INSERT INTO engULB_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","and for mildew in clothing and in a house, ");
INSERT INTO engULB_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","for swelling, for a rash, and for a bright spot, ");
INSERT INTO engULB_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","to determine when any of these cases is unclean or when it is clean. This is the law for infectious skin diseases and mildew.” ");
INSERT INTO engULB_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Yahweh spoke to Moses and to Aaron, saying, ");
INSERT INTO engULB_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Speak to the people of Israel, and say to them, 'When any man has an infected fluid that comes out of his body, he becomes unclean. ");
INSERT INTO engULB_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","His uncleanness is due to this infected fluid. Whether his body flows with fluid or is stopped up, it is unclean. ");
INSERT INTO engULB_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Every bed on which he lies will be unclean, and everything on which he sits will be unclean. ");
INSERT INTO engULB_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Whoever touches his bed must wash his clothes and bathe himself in water, and be unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Anyone who sits on anything on which the man with the flow of infected fluid sat, that person must wash his clothes and bathe himself in water, and he will be unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Anyone who touches the body of the one who has a flow of infected fluid must wash his clothes and bathe himself in water, and be unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","If the person who has such a flow of fluid spits on someone who is clean, then that person must wash his clothes and bathe himself in water, and he will be unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Any saddle which he who has a flow rides upon will be unclean. ");
INSERT INTO engULB_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Whoever touches anything that was under that person will be unclean until evening, and anyone who carries those things must wash his clothes and bathe himself in water; he will be unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Whomever he who has such a flow touches without first having rinsed his hands in water, the person who was touched must wash his clothes and bathe himself in water, and he will be unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Any clay pot that the one with such a flow of fluid touches must be broken, and every container of wood must be rinsed in water. ");
INSERT INTO engULB_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","When he who has a flow is cleansed from his flow, then he must count for himself seven days for his cleansing; then he must wash his clothes and bathe his body in running water. Then he will be clean. ");
INSERT INTO engULB_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","On the eighth day he must take two doves or two young pigeons and come before Yahweh at the entrance to the tent of meeting; there he must give the birds to the priest. ");
INSERT INTO engULB_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","The priest must offer them, one as a sin offering and the other as a burnt offering, and the priest must make atonement for him before Yahweh for his flow. ");
INSERT INTO engULB_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","If any man has an emission of semen, then he must bathe his whole body in water; he will be unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Every garment or leather on which there is semen must be washed with water; it will be unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","If a woman and a man sleep together and there is a transfer of semen to her, they must both bathe themselves in water; they will be unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","When a woman menstruates, her impurity will continue for seven days, and whoever touches her will be unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Everything she lies on during her period will be unclean; everything that she sits on will also be unclean. ");
INSERT INTO engULB_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Whoever touches her bed must wash his clothes and bathe himself in water; that person will be unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Whoever touches anything that she sits on must wash his clothes and bathe himself in water; that person will be unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Whether it is on the bed or on anything on which she sits, if he touches it, that person will be unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","If any man sleeps with her, and if her impure flow touches him, he will be unclean for seven days. Every bed on which he lies will be unclean. ");
INSERT INTO engULB_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","If a woman has a flow of blood for many days that is not in the time of her menstruation, or if she has a flow beyond the time of her menstruation, during all the days of the flow of her uncleanness, she will be as if she were in the days of her period. She is unclean. ");
INSERT INTO engULB_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Every bed on which she lies all during her flow of blood will be to her just like the bed on which she lies during her menstruation, and everything on which she sits will be unclean, just like the uncleanness of her menstruation. ");
INSERT INTO engULB_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Whoever touches any of those things will be unclean; he must wash his clothes and bathe himself in water, and he will be unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","But if she is cleansed from her flow of blood, then she will count for herself seven days, and after that she will be clean. ");
INSERT INTO engULB_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","On the eighth day she will take to her two doves or two young pigeons and bring them to the priest at the entrance to the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","The priest will offer one bird as a sin offering and the other as a burnt offering, and he will make atonement for her before Yahweh for her unclean flow of blood. ");
INSERT INTO engULB_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","This is how you must separate the people of Israel from their uncleanness, so they will not die due to their uncleanness, by defiling my tabernacle, where I live among them. ");
INSERT INTO engULB_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","These are the regulations for anyone who has a flow of fluid, for any man whose semen goes out of him and makes him unclean, ");
INSERT INTO engULB_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","for any woman who has a menstrual period, for anyone with a flow of fluid, whether male or female, and for any man who sleeps with an unclean woman.'” ");
INSERT INTO engULB_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Yahweh spoke to Moses—this was after the death of Aaron's two sons, when they had gone near to Yahweh and then died. ");
INSERT INTO engULB_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Yahweh said to Moses, “Speak to Aaron your brother and tell him not to come at just any time into the most holy place inside the curtain, before the atonement lid that is on the ark. If he does, he will die, because I appear in the cloud over the atonement lid. ");
INSERT INTO engULB_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","So here is how Aaron must come into the most holy place. He must enter with a young bull as a sin offering, and a ram as a burnt offering. ");
INSERT INTO engULB_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","He must put on the holy linen tunic, and he must put the linen undergarments on himself, and he must wear the linen sash and linen turban. These are the holy garments. He must bathe his body in water and then dress himself with these clothes. ");
INSERT INTO engULB_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","He must take from the assembly of the people of Israel two male goats as a sin offering and one ram as a burnt offering. ");
INSERT INTO engULB_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Then Aaron must present the bull as the sin offering, which will be for himself, to make atonement for himself and his family. ");
INSERT INTO engULB_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Then he must take the two goats and set them before Yahweh at the entrance to the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Then Aaron must cast lots for the two goats, one lot for Yahweh, and the other lot for the scapegoat. ");
INSERT INTO engULB_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aaron must then present the goat on which the lot fell for Yahweh, and offer that goat as a sin offering. ");
INSERT INTO engULB_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","But the goat on which the lot fell for the scapegoat must be brought alive before Yahweh, to make atonement by sending him away as a scapegoat into the wilderness. ");
INSERT INTO engULB_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Then Aaron must present the bull for the sin offering, which will be for himself. He must make atonement for himself and for his family, so he must kill the bull as a sin offering for himself. ");
INSERT INTO engULB_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Aaron must take a censer full of coals of fire from off the altar before Yahweh, with his hands full of finely ground sweet incense, and bring these things inside the curtain. ");
INSERT INTO engULB_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","There he must put the incense on the fire before Yahweh so that the cloud from the incense may cover the atonement lid over the covenant decrees. He must do this so he will not die. ");
INSERT INTO engULB_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Then he must take some of the blood of the bull and sprinkle it with his finger on the front of the atonement lid. He must sprinkle some of the blood with his finger seven times before the atonement lid. ");
INSERT INTO engULB_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Then he must kill the goat for the sin offering that is for the people and bring its blood inside the curtain. There he must do with the blood as he did with the blood of the bull: He must sprinkle it on the atonement lid and then before the atonement lid. ");
INSERT INTO engULB_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","He must make atonement for the holy place because of the unclean actions of the people of Israel, and because of their rebellion and all their sins. He must also do this for the tent of meeting, where Yahweh lives among them, in the presence of their unclean actions. ");
INSERT INTO engULB_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","No one must be in the tent of meeting when Aaron enters it to make atonement in the most holy place, and until he comes out and has finished making atonement for himself and for his family, and for all the assembly of Israel. ");
INSERT INTO engULB_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","He must go out to the altar that is before Yahweh and make atonement for it, and he must take some of the bull's blood and some of the goat's blood and put it on the horns of the altar all around. ");
INSERT INTO engULB_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","He must sprinkle some of the blood on it with his finger seven times to cleanse it and set it apart to Yahweh, away from the unclean actions of the people of Israel. ");
INSERT INTO engULB_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","When he has finished atoning for the most holy place, the tent of meeting, and the altar, he must present the live goat. ");
INSERT INTO engULB_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aaron must lay both his hands on the head of the live goat and confess over him all the wickedness of the people of Israel, all their rebellion, and all their sins. Then he must put that sinfulness on the head of the goat and send the goat away in the care of a man who is ready to lead the goat into the wilderness. ");
INSERT INTO engULB_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","The goat must carry on himself all the people's wickedness to a solitary place. There in the wilderness, the man must let the goat go free. ");
INSERT INTO engULB_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Then Aaron must go back into the tent of meeting and take off the linen garments that he had put on before going into the most holy place, and he must leave those garments there. ");
INSERT INTO engULB_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","He must bathe his body in water in a holy place, and put on his normal garments; then he must go out and offer his burnt offering and the burnt offering for the people, and in this way make atonement for himself and for the people. ");
INSERT INTO engULB_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","He must burn the fat of the sin offering on the altar. ");
INSERT INTO engULB_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","The man who let the scapegoat go free must wash his clothes and bathe his body in water; after that, he may come back into the camp. ");
INSERT INTO engULB_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","The bull for the sin offering and the goat for the sin offering, whose blood was brought in to make atonement in the holy place, must be carried outside the camp. There they must burn their hides, flesh, and dung. ");
INSERT INTO engULB_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","The man who burns those parts must wash his clothes and bathe his body in water; after that, he may come back into the camp. ");
INSERT INTO engULB_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","It will always be a statute for you that in the seventh month, on the tenth day of the month, you must humble yourselves and do no work, whether the native born or a foreigner who is living among you. ");
INSERT INTO engULB_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","This is because on this day atonement will be made for you, to cleanse you from all your sins so you will be clean before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","It is a solemn Sabbath of rest for you, and you must humble yourselves and do no work. This will always be a statute among you. ");
INSERT INTO engULB_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","The high priest, the one who will be anointed and ordained to be high priest in his father's place, he must make this atonement and put on the linen garments, that is, the holy garments. ");
INSERT INTO engULB_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","He must make atonement for the most holy place; he must make atonement for the tent of meeting and for the altar, and he must make atonement for the priests and for all the people of the assembly. ");
INSERT INTO engULB_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","This will always be a statute for you, to make atonement for the people of Israel because of all their sins, once in every year.” This was done as Yahweh commanded Moses. ");
INSERT INTO engULB_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Speak to Aaron and to his sons, and to all the people of Israel. Tell them what Yahweh has commanded: ");
INSERT INTO engULB_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","'Any man from Israel who kills an ox, lamb, or goat in the camp, or who kills it outside the camp, in order to sacrifice it— ");
INSERT INTO engULB_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","if he does not bring it to the entrance of the tent of meeting to offer it as a sacrifice to Yahweh before his tabernacle, that man is guilty of bloodshed. He has shed blood, and that man must be cut off from among his people. ");
INSERT INTO engULB_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","The purpose of this command is so that the people of Israel will bring their sacrifices to Yahweh at the entrance to the tent of meeting, to the priest to be sacrificed as fellowship offerings to Yahweh, instead of offering sacrifices in an open field. ");
INSERT INTO engULB_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","The priest will sprinkle the blood on Yahweh's altar at the entrance to the tent of meeting; he will burn the fat for it to produce a sweet aroma for Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","The people must no longer offer their sacrifices to goat idols, for which they act as prostitutes. This will be a permanent statute for them throughout their people's generations.' ");
INSERT INTO engULB_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","You must say to them, 'Any man of Israel, or any foreigner who lives among them, who offers a burnt offering or sacrifice ");
INSERT INTO engULB_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","and does not bring it to the entrance of the tent of meeting in order to sacrifice it to Yahweh, that man must be cut off from his people. ");
INSERT INTO engULB_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","If any person of the house of Israel, or any foreigner who lives among them consumes any blood, I will set my face against that person who consumes blood and I will cut him off from among his people. ");
INSERT INTO engULB_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","For the life of an animal is in its blood. I have given its blood to you to make atonement on the altar for your lives, because it is the blood that makes atonement, for it is the blood that atones for the life. ");
INSERT INTO engULB_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Therefore I said to the people of Israel that no one among you must eat blood, neither may any foreigner who lives among you eat blood. ");
INSERT INTO engULB_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Anyone of the people of Israel, or any of the foreigners who live among them, who hunts and kills an animal or bird that may be eaten, that person must pour out its blood and cover the blood with earth. ");
INSERT INTO engULB_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","For the life of each creature is its blood. That is why I said to the people of Israel, “You must not eat the blood of any creature, for the life of every living creature is its blood. Whoever eats it must be cut off.” ");
INSERT INTO engULB_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Every person who eats an animal that has died or that has been torn by wild animals, whether that person is native born or a foreigner living among you, he must wash his clothes and bathe himself in water, and he will be unclean until the evening. Then he will be clean. ");
INSERT INTO engULB_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","But if he does not wash his clothes or bathe his body, then he must carry his guilt.'” ");
INSERT INTO engULB_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Speak to the people of Israel and say to them, 'I am Yahweh your God. ");
INSERT INTO engULB_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","You must not do the things that the people do in Egypt, where you lived previously. You must not do the things that the people do in Canaan, the land to which I am taking you. Do not follow their customs. ");
INSERT INTO engULB_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","My laws are what you must do, and my commandments are what you must keep, so that you walk in them, because I am Yahweh your God. ");
INSERT INTO engULB_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Therefore you must keep my decrees and my laws. If a person obeys them, he will live because of them. I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","No one must sleep with any close relative to uncover his nakedness. I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Do not dishonor your father by sleeping with your mother. She is your mother! You must not dishonor her. ");
INSERT INTO engULB_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Do not sleep with any of your father's wives; you must not dishonor your father like that. ");
INSERT INTO engULB_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Do not sleep with any sister of yours, whether she is the daughter of your father or the daughter of your mother, whether she was raised at your home or distant from you. You must not sleep with your sisters. ");
INSERT INTO engULB_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Do not sleep with your son's daughter or with your daughter's daughter. That would be your own shame. ");
INSERT INTO engULB_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Do not sleep with your father's wife's daughter, who was born of your father. She is your sister, and you must not sleep with her. ");
INSERT INTO engULB_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Do not sleep with your father's sister. She is a close relative to your father. ");
INSERT INTO engULB_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Do not sleep with your mother's sister. She is a close relative to your mother. ");
INSERT INTO engULB_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Do not dishonor the brother of your father by sleeping with his wife. Do not go near her for that purpose; she is your aunt. ");
INSERT INTO engULB_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Do not sleep with your daughter-in-law. She is your son's wife; do not sleep with her. ");
INSERT INTO engULB_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Do not sleep with your brother's wife; do not dishonor him in this way. ");
INSERT INTO engULB_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Do not sleep with a woman and her daughter, or with her son's daughter or her daughter's daughter. They are close relatives to her, and sleeping with them would be wicked. ");
INSERT INTO engULB_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","You must not marry your wife's sister as a second wife and sleep with her while your first wife is alive. ");
INSERT INTO engULB_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Do not sleep with a woman during her menstruation. She is unclean during that time. ");
INSERT INTO engULB_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Do not sleep with your neighbor's wife and defile yourself with her in this way. ");
INSERT INTO engULB_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","You must not give any of your children to put them into the fire, so that you sacrifice them to Molech, because you must not profane the name of your God. I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Do not sleep with other men as with a woman. This would be wicked. ");
INSERT INTO engULB_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Do not sleep with any animal and defile yourself with it. No woman must consider sleeping with any animal. This would be perversion. ");
INSERT INTO engULB_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Do not defile yourselves in any of these ways, for in all these ways the nations are defiled, the nations that I will drive out from before you. ");
INSERT INTO engULB_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","The land became defiled, so I punished their sin, and the land vomited out its inhabitants. ");
INSERT INTO engULB_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","You, therefore, must keep my commandments and decrees, and you must not do any of these detestable things, neither the native-born Israelite nor the foreigner who lives among you. ");
INSERT INTO engULB_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","For this is the wickedness that the people in the land have committed, those who lived here before you, and now the land is defiled. ");
INSERT INTO engULB_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Therefore be careful so that the land does not vomit you up also after you have defiled it, as it vomited out the people who were before you. ");
INSERT INTO engULB_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Whoever does any of these detestable things, the persons who do such things will be cut off from among their people. ");
INSERT INTO engULB_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Therefore you must keep my command not to practice any of these detestable customs which were practiced here before you, so that you do not defile yourselves by them. I am Yahweh your God.'” ");
INSERT INTO engULB_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Speak to all the assembly of the people of Israel and say to them, 'You must be holy, for I Yahweh your God am holy. ");
INSERT INTO engULB_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Everyone must respect his mother and his father, and you must keep my Sabbaths. I am Yahweh your God. ");
INSERT INTO engULB_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Do not turn to worthless idols, nor make for yourselves gods out of metal. I am Yahweh your God. ");
INSERT INTO engULB_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","When you offer a sacrifice of fellowship offerings to Yahweh, you must offer it that you may be accepted. ");
INSERT INTO engULB_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","It must be eaten the same day you offer it, or on the next day. If anything remains until the third day, it must be burned up with fire. ");
INSERT INTO engULB_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","If it is eaten at all on the third day, it is unclean meat; it must not be accepted, ");
INSERT INTO engULB_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","and everyone who eats it must carry his own guilt because he has defiled what is holy to Yahweh, and that person must be cut off from his people. ");
INSERT INTO engULB_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","When you reap the harvest of your land, you must not completely reap the corners of your field, neither will you gather all the produce of your harvest. ");
INSERT INTO engULB_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","You must not gather every grape from your vineyard, nor gather the grapes that have fallen on the ground in your vineyard. You must leave them for the poor and for the foreigner. I am Yahweh your God. ");
INSERT INTO engULB_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Do not steal. Do not lie. Do not deceive each other. ");
INSERT INTO engULB_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Do not swear by my name falsely and profane the name of your God. I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Do not oppress your neighbor or rob him. The wages of a hired servant must not stay with you all night until the morning. ");
INSERT INTO engULB_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Do not curse the deaf or put a stumbling block before the blind. Instead, you must fear your God. I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Do not cause judgment to be false. You must not show favoritism to someone because he is poor, and you must not show favoritism to someone because he is important. Instead, judge your neighbor righteously. ");
INSERT INTO engULB_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Do not walk around spreading slander among your people, but seek to protect your neighbor's life. I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Do not hate your brother in your heart. You must honestly rebuke your neighbor so as not to share in sin because of him. ");
INSERT INTO engULB_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Do not take vengeance or hold any grudge against any of your people, but instead love your neighbor as yourself. I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","You must keep my commands. Do not try to breed your animals with different kinds of other animals. Do not mix two different kinds of seeds when planting your field. Do not wear clothing made of two kinds of material mixed together. ");
INSERT INTO engULB_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Whoever sleeps with a slave girl who is promised to a husband, but who has not been ransomed or given her freedom, they must be punished. They must not be put to death because she was not free. ");
INSERT INTO engULB_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","A man must bring his guilt offering to Yahweh to the entrance to the tent of meeting—a ram as a guilt offering. ");
INSERT INTO engULB_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Then the priest will make atonement for him with the ram for the guilt offering before Yahweh, for the sin that he has committed. Then the sin which he has committed will be forgiven. ");
INSERT INTO engULB_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","When you come into the land and have planted all kinds of trees for food, then you must regard the fruit they produce as forbidden to be eaten. The fruit must be forbidden to you for three years. It must not be eaten. ");
INSERT INTO engULB_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","But in the fourth year all the fruit will be holy, an offering of praise to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","In the fifth you may eat the fruit, having waited so that the trees might produce more. I am Yahweh your God. ");
INSERT INTO engULB_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Do not eat any meat with blood still in it. Do not consult spirits about the future, and do not seek to control others by supernatural powers. ");
INSERT INTO engULB_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","You will not round off the corners of the hair on the sides of your head or shave off the edge of your beard. ");
INSERT INTO engULB_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Do not cut your body for the dead or put tattoo marks on your body. I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Do not disgrace your daughter by making her a prostitute, or the nation will fall to prostitution and the land will become full of wickedness. ");
INSERT INTO engULB_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","You must keep my Sabbaths and honor the sanctuary of my tabernacle. I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Do not turn to those who talk with the dead or with spirits. Do not seek them out, or they will defile you. I am Yahweh your God. ");
INSERT INTO engULB_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","You must rise before the gray-headed person and honor the presence of an old man. You must fear your God. I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","If a foreigner lives among you in your land, you must not do him any wrong. ");
INSERT INTO engULB_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","The foreigner who lives with you must be to you like the native-born Israelite who lives among you, and you must love him as yourself, because you were foreigners in the land of Egypt. I am Yahweh your God. ");
INSERT INTO engULB_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Do not use false measures when measuring length, weight, or quantity. ");
INSERT INTO engULB_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","You must use just scales, just weights, a just ephah, and a just hin. I am Yahweh your God, who brought you out of the land of Egypt. ");
INSERT INTO engULB_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","You must obey all my decrees and all my laws, and do them. I am Yahweh.'” ");
INSERT INTO engULB_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Say to the people of Israel, 'Anyone among the people of Israel, or any foreigner who lives in Israel who gives any of his children to Molech, must certainly be put to death. The people in the land must stone him with stones. ");
INSERT INTO engULB_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","I also will set my face against that man and will cut him off from among his people because he has given his child to Molech, so as to defile my holy place and profane my holy name. ");
INSERT INTO engULB_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","If the people of the land close their eyes to that man when he gives any of his children to Molech, if they do not put him to death, ");
INSERT INTO engULB_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","then I myself will set my face against that man and his clan, and I will cut him off and everyone else who prostitutes himself in order to play the harlot with Molech. ");
INSERT INTO engULB_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","The person who turns to those who talk with the dead, or to those who talk with spirits so as to prostitute themselves with them, I will set my face against that person; I will cut him off from among his people. ");
INSERT INTO engULB_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Therefore consecrate yourselves and be holy, because I am Yahweh your God. ");
INSERT INTO engULB_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","You must keep my commands and carry them out. I am Yahweh who sets you apart as holy. ");
INSERT INTO engULB_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Everyone who curses his father or his mother must surely be put to death. He has cursed his father or his mother, so he is guilty and deserves to die. ");
INSERT INTO engULB_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","The man who commits adultery with another man's wife, that is, anyone who commits adultery with his neighbor's wife—the adulterer and the adulteress must both certainly be put to death. ");
INSERT INTO engULB_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","If a man lies with his father's wife, he uncovers his father's nakedness. Both the son and his father's wife must certainly be put to death. Their blood is upon them. ");
INSERT INTO engULB_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","If a man sleeps with his daughter-in-law, both of them must certainly be put to death. They have committed perversion. They are guilty and deserve to die. ");
INSERT INTO engULB_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","If a man sleeps with another man, as with a woman, both of them have done something detestable. They must surely be put to death. They are guilty and deserve to die. ");
INSERT INTO engULB_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","If a man marries a woman and also marries her mother, this is wickedness. They must be burned, both he and the women, so that there will be no wickedness among you. ");
INSERT INTO engULB_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","If a man sleeps with an animal, he must surely be put to death, and you must kill the animal. ");
INSERT INTO engULB_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","If a woman approaches any animal to sleep with it, you must kill the woman and the animal. They must certainly be put to death. They are guilty and deserve to die. ");
INSERT INTO engULB_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","If a man sleeps with his sister, a daughter of his father or a daughter of his mother, and he uncovers her nakedness, and she sees his nakedness, it is a shameful thing. They must be cut off from the presence of their people, because he has slept with his sister. He must carry his guilt. ");
INSERT INTO engULB_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","If a man sleeps with a woman during her menstrual period and has slept with her, he has uncovered the flow of her blood, the source of her blood. Both the man and woman must be cut off from among their people. ");
INSERT INTO engULB_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","You must not sleep with your mother's sister, or with your father's sister, because you would disgrace your close relative. You must carry your own guilt. ");
INSERT INTO engULB_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","If a man sleeps with his aunt, he has dishonored his uncle. They will bear responsibility for their sin, and they will die without children. ");
INSERT INTO engULB_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","If a man marries his brother's wife while his brother is still living, that is disgraceful. He has dishonored his brother, and I will take away from their children any property they may have inherited from their parents. ");
INSERT INTO engULB_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","You must therefore keep all my statutes and all my decrees; you must obey them so that the land into which I am bringing you to live will not vomit you up. ");
INSERT INTO engULB_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","You must not walk in the customs of the nations that I will drive out before you, for they have done all these things, and I detest them. ");
INSERT INTO engULB_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","I said to you, “You will inherit their land; I will give it to you to possess, a land flowing with milk and honey. I am Yahweh your God, who has separated you from the other peoples. ");
INSERT INTO engULB_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","You must therefore distinguish between the clean animals and the unclean, and between the unclean birds and the clean. You must not defile yourselves with unclean animals or birds or with any creature that crawls along the ground, which I have separated as unclean from you. ");
INSERT INTO engULB_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","You must be holy, for I, Yahweh, am holy, and I have separated you from the other peoples, for you belong to me. ");
INSERT INTO engULB_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","A man or a woman who talks with the dead or who talks with spirits must certainly be put to death. The people must stone them with stones. They are guilty and deserve to die.'” ");
INSERT INTO engULB_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Yahweh said to Moses: “Speak to the priests, the sons of Aaron, and say to them, 'No one among you shall make himself unclean for those who die among his people, ");
INSERT INTO engULB_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","except for his closest relatives—his mother, his father, his son, his daughter, his brother, ");
INSERT INTO engULB_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","or his virgin sister who is dependent on him, since she has no husband—for her he may make himself unclean. ");
INSERT INTO engULB_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","But he must not make himself unclean for other relatives and so defile himself. ");
INSERT INTO engULB_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Priests must not shave their heads or shave off the corners of their beards, nor cut their bodies. ");
INSERT INTO engULB_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","They must be holy to their God and not disgrace the name of their God, because the priests offer Yahweh's food offerings, the bread of their God. Therefore the priests must be holy. ");
INSERT INTO engULB_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","They must not marry any woman who is a prostitute and who is defiled, and they must not marry a woman divorced from her husband, for they are separate for their God. ");
INSERT INTO engULB_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","You will set him apart, for he is the one who offers bread to your God. He must be holy to you, because I, Yahweh who makes you holy, am holy. ");
INSERT INTO engULB_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Any daughter of any priest who defiles herself by becoming a prostitute disgraces her father. She must be burned. ");
INSERT INTO engULB_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","The one who is the high priest among his brothers, on whose head the anointing oil has been poured, and who has been consecrated to wear the special garments of the high priest, must not wear his hair loose or tear his clothes. ");
INSERT INTO engULB_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","He must not go anywhere that a dead body is present and defile himself, even for his father or his mother. ");
INSERT INTO engULB_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","The high priest must not leave the sanctuary area of the tabernacle or profane the sanctuary of his God, because he has been consecrated as high priest by the anointing oil of his God. I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","The high priest must marry a virgin as his wife. ");
INSERT INTO engULB_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","He must not marry a widow, a divorced woman, or a woman who is a prostitute. He will not marry these kinds of women. He may only marry a virgin from his own people, ");
INSERT INTO engULB_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","so he will not defile his children among his people, for I am Yahweh, who makes him holy.'” ");
INSERT INTO engULB_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Speak to Aaron and tell him, 'Whoever of your descendants throughout their generations has a bodily defect, he must not approach to offer the food to his God. ");
INSERT INTO engULB_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Any man who has a bodily defect must not approach Yahweh, such as a blind man or a man who is unable to walk, one who is disfigured or deformed, ");
INSERT INTO engULB_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","a man with a crippled hand or foot, ");
INSERT INTO engULB_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","a man who has a hump in his back or is abnormally thin or short, or a man with a defect in his eyes, or with a disease, sore, scabs, or whose testicles have been crushed. ");
INSERT INTO engULB_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","No man among the descendants of Aaron the priest with a bodily defect may come near to perform the offerings made by fire for Yahweh. Such a man has a bodily defect; he must not come near to offer the bread of his God. ");
INSERT INTO engULB_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","He may eat the food of his God, whether some of the most holy or some of the holy. ");
INSERT INTO engULB_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","However, he must not enter inside the curtain or come near the altar, because he has a bodily defect, so that he does not defile my holy place, for I am Yahweh, who makes them holy.'” ");
INSERT INTO engULB_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","So Moses spoke these words to Aaron, to his sons, and to all the people of Israel. ");
INSERT INTO engULB_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Speak to Aaron and to his sons, tell them to keep away from the holy things of the people of Israel, which they set apart to me. They must not profane my holy name. I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Say to them, 'If any of your descendants throughout your generations approaches the holy things that the people of Israel have set apart to Yahweh, while he is unclean, that person must be cut off from before me: I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","None of the descendants of Aaron who has an infectious skin disease, or an infection flowing from his body, may eat any of the sacrifices made to Yahweh until he is clean. Whoever touches anything unclean through contact with the dead, or by contact with a man who has a flow of semen, ");
INSERT INTO engULB_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","or whoever touches any creeping animal that makes him unclean, or any person who makes him unclean, whatever kind of uncleanness it may be— ");
INSERT INTO engULB_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","then the priest who touches anything unclean will be unclean until evening. He must not eat any of the holy things, unless he has bathed his body in water. ");
INSERT INTO engULB_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","When the sun has set, he will then be clean. After sunset he may eat from the holy things, because they are his food. ");
INSERT INTO engULB_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","He must not eat anything found dead or killed by wild animals, by which he would defile himself. I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","The priests must follow my instructions, or they will be guilty of sin and could die for profaning me. I am Yahweh who makes them holy. ");
INSERT INTO engULB_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","No one outside the priest's family, including guests of a priest or his hired servants, may eat anything that is holy. ");
INSERT INTO engULB_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","But if a priest buys any slave with his own money, that slave may eat from the things set apart to Yahweh. The priest's family members and slaves born in his house, they also may eat with him from those things. ");
INSERT INTO engULB_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","If a priest's daughter married someone who is not a priest, she may not eat any of the holy contribution offerings. ");
INSERT INTO engULB_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","But if a priest's daughter is a widow, or divorced, and if she has no child, and if she returns to live in her father's house as in her youth, she may eat from her father's food. But no one who is not in the priestly family may eat from the priest's food. ");
INSERT INTO engULB_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","If a man eats a holy food without knowing it, then he must repay the priest for it; he must add one-fifth to it and give it back to the priest. ");
INSERT INTO engULB_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","The people of Israel must not profane the holy things that they have raised high and presented to Yahweh, ");
INSERT INTO engULB_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","and cause themselves to carry the sin that would make them guilty of eating the holy food, for I am Yahweh who makes them holy.'” ");
INSERT INTO engULB_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Speak to Aaron and his sons, and to all the people of Israel. Say to them, 'Any Israelite, or an alien living in Israel, when they present a sacrifice—whether it is to fulfill a vow, or whether it is a freewill offering, or they present to Yahweh a burnt offering, ");
INSERT INTO engULB_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","if it is to be accepted, they must offer a male animal without blemish from the cattle, sheep, or goats. ");
INSERT INTO engULB_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","But you must not offer whatever has a blemish. I will not accept it on your behalf. ");
INSERT INTO engULB_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Whoever offers a sacrifice of fellowship offerings from the herd or the flock to Yahweh to fulfill a vow, or as a freewill offering, it must be unblemished to be accepted. There must be no defect in the animal. ");
INSERT INTO engULB_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","You must not offer animals that are blind, disabled, or maimed, or that have warts, sores, or scabs. You must not offer these to Yahweh as a sacrifice by fire on the altar. ");
INSERT INTO engULB_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","You may present as a freewill offering an ox or a lamb that is deformed or small, but an offering like that will not be accepted for a vow. ");
INSERT INTO engULB_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Do not offer any animal to Yahweh that has bruised, crushed, torn, or cut testicles. Do not do this within your land. ");
INSERT INTO engULB_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","You must not present the bread of your God from the hand of a foreigner. Those animals are deformed and have defects in them, they will not be accepted for you.'” ");
INSERT INTO engULB_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Yahweh spoke to Moses and said, ");
INSERT INTO engULB_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“When a calf or a sheep or a goat is born, it must remain seven days with its mother. Then from the eighth day on, it may be accepted as a sacrifice for an offering made by fire to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Do not kill a cow or ewe along with its young, both on the same day. ");
INSERT INTO engULB_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","When you sacrifice a thank offering to Yahweh, you must sacrifice it in an acceptable way. ");
INSERT INTO engULB_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","It must be eaten on the same day that it is sacrificed. You must leave none of it until the next morning. I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","So you must keep my commandments and carry them out. I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","You must not profane my holy name. I must be acknowledged as holy by the people of Israel. I am Yahweh who makes you holy, ");
INSERT INTO engULB_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","who brought you out of the land of Egypt to be your God: I am Yahweh.” ");
INSERT INTO engULB_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Yahweh spoke to Moses: ");
INSERT INTO engULB_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Speak to the people of Israel, and say to them, 'These are the appointed festivals for Yahweh, which you must proclaim as holy assemblies; they are my regular festivals. ");
INSERT INTO engULB_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","You may work for six days, but the seventh day is a Sabbath of complete rest, a holy assembly. You must do no work because it is a Sabbath for Yahweh in all the places where you live. ");
INSERT INTO engULB_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","These are the appointed festivals of Yahweh, the holy assemblies that you must announce at their appointed times: ");
INSERT INTO engULB_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","In the first month, on the fourteenth day of the month at twilight, is Yahweh's Passover. ");
INSERT INTO engULB_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","On the fifteenth day of the same month is the Festival of Unleavened Bread for Yahweh. For seven days you must eat unleavened bread. ");
INSERT INTO engULB_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","The first day you must set apart to gather together; you will not do any of your regular work. ");
INSERT INTO engULB_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","You will present a food offering to Yahweh for seven days. The seventh day is an assembly set apart to Yahweh, and on that day you must not do any regular work.'” ");
INSERT INTO engULB_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Speak to the people of Israel and say to them, 'When you have come into the land that I will give you, and when you reap its harvest, then you must bring a bundle of the firstfruit of the grain to the priest. ");
INSERT INTO engULB_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","He will raise the bundle of grain before Yahweh and present it to him, for it to be accepted on your behalf. It is on the day after the Sabbath that the priest will raise it and present it to me. ");
INSERT INTO engULB_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","On the day when you raise the bundle of grain and present it to me, you must offer a male lamb one year old and without blemish as a burnt offering to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","The grain offering must be two-tenths of an ephah of fine flour mixed with oil, an offering made by fire to Yahweh, to produce a sweet aroma, and with it a drink offering of wine, a fourth of a hin. ");
INSERT INTO engULB_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","You must eat no bread, nor roasted or fresh grain, until the same day you have brought this offering to your God. This will be a permanent statute throughout your people's generations, in every place that you live. ");
INSERT INTO engULB_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Beginning from the day after the Sabbath—that was the day you brought the bundle of grain as the wave offering—count seven full weeks. ");
INSERT INTO engULB_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","You must count fifty days, which would be the day after the seventh Sabbath. Then you must present an offering of new grain to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","You must bring out of your houses two loaves made from two-tenths of an ephah. They must be made from fine flour and baked with yeast; they will be a wave offering of the firstfruits to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","You must present with the bread seven lambs one year old and without blemish, one young bull, and two rams. They must be a burnt offering to Yahweh, with their grain offering and their drink offerings, an offering made by fire and producing a sweet aroma for Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","You must offer one male goat for a sin offering, and two male lambs a year old for a sacrifice, as fellowship offerings. ");
INSERT INTO engULB_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","The priest must wave them together with the bread of the firstfruits before Yahweh, and present them to him as an offering with the two lambs. They will be holy offerings to Yahweh for the priest. ");
INSERT INTO engULB_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","You must make a proclamation on that same day. There will be a holy assembly, and you must do no ordinary work. This will be a permanent statute throughout your people's generations in all the places where you live. ");
INSERT INTO engULB_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","When you reap the harvest of your land, you must not completely reap the corners of your fields, and you must not gather the gleanings of your harvest. You must leave them for the poor and for the foreigner. I am Yahweh your God.'” ");
INSERT INTO engULB_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Speak to the people of Israel and say, 'In the seventh month, the first day of that month will be a solemn rest for you, a memorial with the blowing of trumpets, and a holy assembly. ");
INSERT INTO engULB_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","You must do no ordinary work, and you must offer a sacrifice made by fire to Yahweh.'” ");
INSERT INTO engULB_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Then Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Now the tenth day of this seventh month is the Day of Atonement. It is to be a holy assembly, and you must humble yourselves and present to Yahweh an offering by fire. ");
INSERT INTO engULB_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","You must do no work on that day because it is the Day of Atonement, to make atonement for yourselves before Yahweh your God. ");
INSERT INTO engULB_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Whoever does not humble himself on that day must be cut off from his people. ");
INSERT INTO engULB_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Whoever does any work on that day, I, Yahweh, will destroy him from among his people. ");
INSERT INTO engULB_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","You must do no work of any kind on that day. This will be a permanent statute throughout your people's generations in all the places where you live. ");
INSERT INTO engULB_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","This day must be to you a Sabbath of solemn rest, and you must humble yourselves the ninth day of the month at the evening. From evening to evening you are to observe your Sabbath.” ");
INSERT INTO engULB_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Speak to the people of Israel, saying, 'On the fifteenth day of the seventh month will be the Festival of Shelters for Yahweh. It will last seven days. ");
INSERT INTO engULB_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","On the first day there must be a holy assembly. You must do no ordinary work. ");
INSERT INTO engULB_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","For seven days you must offer a sacrifice made by fire to Yahweh. On the eighth day there must be a holy assembly, and you must make a sacrifice offered with fire to Yahweh. This is a solemn assembly, and you must not do any ordinary work. ");
INSERT INTO engULB_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","These are the appointed festivals for Yahweh, which you must proclaim as holy assemblies to offer sacrifice by fire to Yahweh, a burnt offering and a grain offering, sacrifices and drink offerings, each on its own day. ");
INSERT INTO engULB_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","These festivals will be in addition to the Sabbaths of Yahweh and your gifts, all your vows, and all your freewill offerings that you give to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Regarding the Festival of Shelters, on the fifteenth day of the seventh month, when you have gathered in the fruits of the land, you must keep this festival of Yahweh for seven days. The first day will be a solemn rest, and the eighth day will also be a solemn rest. ");
INSERT INTO engULB_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","On the first day you must take the best fruit from the trees, branches of palm trees, and leafy branches of thick trees, and willows from streams, and you will rejoice before Yahweh your God for seven days. ");
INSERT INTO engULB_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","For seven days each year, you must celebrate this festival for Yahweh. This will be a permanent statute throughout your people's generations in all the places where you live. You must celebrate this festival in the seventh month. ");
INSERT INTO engULB_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","You must live in small shelters for seven days. All native-born Israelites must live in small shelters for seven days, ");
INSERT INTO engULB_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","so that your descendants, generation after generation, may learn how I made the people of Israel live in such shelters when I led them out of the land of Egypt. I am Yahweh your God.'” ");
INSERT INTO engULB_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","In this way, Moses announced to the people of Israel the appointed festivals for Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Command the people of Israel to bring you pure oil beaten from olives to be used in the lamp, that the light may burn continually. ");
INSERT INTO engULB_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Outside the curtain before the covenant decrees in the tent of meeting, Aaron must continually, from evening to morning, keep the lamp lit before Yahweh. This will be a permanent statute throughout your people's generations. ");
INSERT INTO engULB_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","The high priest must always keep the lamps lit before Yahweh, the lamps on the lampstand of pure gold. ");
INSERT INTO engULB_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","You must take fine flour and bake twelve loaves with it. There must be two-tenths of an ephah in each loaf. ");
INSERT INTO engULB_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Then you must set them in two rows, six in a row, on the table of pure gold before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","You must put pure incense along each row of loaves as a representative offering. This incense will be burnt for Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Every Sabbath day the high priest must regularly set out the bread before Yahweh on behalf of the people of Israel, as a sign of an everlasting covenant. ");
INSERT INTO engULB_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","This offering will be for Aaron and his sons, and they are to eat it in a place that is holy, for it is a portion from the offerings to Yahweh made by fire.” ");
INSERT INTO engULB_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Now it happened that the son of an Israelite woman, whose father was an Egyptian, went among the people of Israel. This son of the Israelite woman fought against an Israelite man in the camp. ");
INSERT INTO engULB_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","The son of the Israelite woman blasphemed the name of Yahweh and cursed God, so the people brought him to Moses. His mother's name was Shelomith, the daughter of Dibri, from the tribe of Dan. ");
INSERT INTO engULB_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","They held him in custody until Yahweh himself should declare his will to them. ");
INSERT INTO engULB_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Then Yahweh spoke to Moses, saying, ");
INSERT INTO engULB_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Take the man who has cursed God outside the camp. All who heard him must lay their hands on his head, and then the entire assembly must stone him. ");
INSERT INTO engULB_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","You must explain to the people of Israel and say, 'Whoever curses his God must carry his own guilt. ");
INSERT INTO engULB_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","He who blasphemes the name of Yahweh must surely be put to death. All the assembly must certainly stone him, whether he is a foreigner or a native-born Israelite. If anyone blasphemes the name of Yahweh, he must be put to death. ");
INSERT INTO engULB_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","If anyone strikes down another human being, he must certainly be put to death. ");
INSERT INTO engULB_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","If anyone strikes down someone's animal, he must pay it back, life for life. ");
INSERT INTO engULB_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","If anyone injures his neighbor, it must be done to him as he did to his neighbor: ");
INSERT INTO engULB_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","fracture for fracture, eye for eye, tooth for tooth. As he has caused an injury to a person, so must it also be done to him. ");
INSERT INTO engULB_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Anyone who kills an animal must pay it back, and anyone who kills a person must be put to death. ");
INSERT INTO engULB_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","You must have the same law for both the foreigner and the native-born Israelite, for I am Yahweh your God.'” ");
INSERT INTO engULB_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","So Moses spoke to the people of Israel, and the people brought the man outside the camp, the one who had cursed Yahweh. They stoned him with stones. The people of Israel carried out the command of Yahweh to Moses. ");
INSERT INTO engULB_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Yahweh spoke to Moses on Mount Sinai, saying, ");
INSERT INTO engULB_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Speak to the people of Israel and say to them, 'When you come into the land that I give you, then the land must be made to keep a Sabbath for Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","You must plant your field for six years, and for six years you must prune your vineyard and gather the produce. ");
INSERT INTO engULB_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","But in the seventh year, a Sabbath of solemn rest for the land must be observed, a Sabbath for Yahweh. You must not plant your field or prune your vineyard. ");
INSERT INTO engULB_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","You must not conduct an organized harvest of whatever grows by itself, and you must not conduct an organized harvest of whatever grapes grow on your unpruned vines. This will be a year of solemn rest for the land. ");
INSERT INTO engULB_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Whatever the unworked land grows during the Sabbath year will be food for you. You, your male and female servants, your hired servants and the foreigners who live with you may gather food, ");
INSERT INTO engULB_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","and your livestock and also wild animals may eat whatever the land produces. ");
INSERT INTO engULB_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","You must count off seven Sabbaths of years, that is, seven times seven years, so that there will be seven Sabbaths of years, totaling forty-nine years. ");
INSERT INTO engULB_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Then you must blow a loud trumpet everywhere on the tenth day of the seventh month. On the Day of Atonement you must blow a trumpet throughout all your land. ");
INSERT INTO engULB_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","You must set apart the fiftieth year to Yahweh and proclaim liberty throughout the land to all its inhabitants. It will be a Jubilee for you, in which property and slaves must be returned to their families. ");
INSERT INTO engULB_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","The fiftieth year will be a Jubilee for you. You must not plant or conduct an organized harvest. Eat whatever grows by itself, and gather the grapes that grow on the unpruned vines. ");
INSERT INTO engULB_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","For it is a Jubilee, which will be holy for you. You must eat the produce that grows by itself out of the fields. ");
INSERT INTO engULB_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","You must return everyone to his own property in this year of Jubilee. ");
INSERT INTO engULB_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","If you sell any land to your neighbor or buy any land from your neighbor, you must not cheat or wrong each other. ");
INSERT INTO engULB_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","If you buy land from your neighbor, consider the number of years and crops that can be harvested until the next Jubilee. Your neighbor selling the land must consider that also. ");
INSERT INTO engULB_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","A larger number of years until the next Jubilee will increase the value of land, and a smaller number of years until the next Jubilee will decrease the value, because the number of harvests the land will produce for the new owner is related to the number of years before the next Jubilee. ");
INSERT INTO engULB_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","You must not cheat or wrong one another; instead, you must honor your God, for I am Yahweh your God. ");
INSERT INTO engULB_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Therefore you must obey my decrees, keep my laws, and carry them out. Then you will live in the land in safety. ");
INSERT INTO engULB_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","The land will yield its produce, and you will eat your fill and live there in safety. ");
INSERT INTO engULB_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","You might say, “What will we eat during the seventh year? Look, we cannot plant or gather our produce.” ");
INSERT INTO engULB_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","I will command my blessing to come upon you in the sixth year, and it will produce harvest enough for three years. ");
INSERT INTO engULB_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","You will plant in the eighth year and continue to eat from the previous years' produce and the stored food. Until the harvest of the ninth year comes in, you will be able to eat from the provisions stored in the previous years. ");
INSERT INTO engULB_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","The land must not be sold to a new permanent owner, because the land is mine. You are all foreigners and temporary residents on my land. ");
INSERT INTO engULB_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","You must observe the right of redemption for all the land that you acquire; you must allow the land to be bought back by the family from whom you bought it. ");
INSERT INTO engULB_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","If your fellow Israelite became poor and for that reason sold some of his property, then his nearest relative may come and buy back the property that he sold to you. ");
INSERT INTO engULB_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","If a man has no relative to redeem his property, but if he has prospered and has the ability to redeem it, ");
INSERT INTO engULB_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","then he may calculate the years since the land was sold and repay the balance to the man to whom he sold it. Then he may return to his own property. ");
INSERT INTO engULB_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","But if he is not able to get the land back for himself, then the land he has sold will remain in the ownership of the one who bought it until the year of Jubilee. At the year of Jubilee, the land will be returned to the man who sold it, and the original owner will return to his property. ");
INSERT INTO engULB_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","If a man sells a house in a walled city, then he may buy it back within a whole year after it was sold. For a full year he will have the right of redemption. ");
INSERT INTO engULB_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","If the house is not redeemed within a full year, then the house in the walled city will become the permanent property of the buyer and his descendants. It is not to be returned in the year of Jubilee. ");
INSERT INTO engULB_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","But the houses of the villages that have no wall around them will be considered as the field of the land. They may be redeemed, and they must be returned during the year of Jubilee. ");
INSERT INTO engULB_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","However, the houses owned by the Levites in their cities may be redeemed at any time. ");
INSERT INTO engULB_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","If one of the Levites does not redeem a house he sold, then the house that was sold in the city where it is located must be returned in the year of Jubilee, for the houses of the cities of the Levites are their property among the people of Israel. ");
INSERT INTO engULB_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","But the fields around their cities may not be sold because they are the permanent property of the Levites. ");
INSERT INTO engULB_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","If your fellow countryman becomes poor, so that he can no longer provide for himself, then you must help him as you would help a foreigner or anyone else living as an outsider among you. ");
INSERT INTO engULB_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Do not charge him interest or try to profit from him in any way, but honor your God so that your brother may keep living with you. ");
INSERT INTO engULB_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","You must not give him a loan of money and charge interest, nor sell him your food to earn a profit. ");
INSERT INTO engULB_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","I am Yahweh your God, who brought you out of the land of Egypt, in order that I might give you the land of Canaan, and that I might be your God. ");
INSERT INTO engULB_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","If your fellow countryman has become poor and sells himself to you, you must not make him work like a slave. ");
INSERT INTO engULB_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Treat him as a hired servant. He must be like someone living temporarily with you. He will serve with you until the year of Jubilee. ");
INSERT INTO engULB_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Then he will go away from you, he and his children with him, and he will return to his own family and to his fathers' property. ");
INSERT INTO engULB_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","For they are my servants whom I brought out of the land of Egypt. They will not be sold as slaves. ");
INSERT INTO engULB_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","You must not rule over them harshly, but you must honor your God. ");
INSERT INTO engULB_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","As for your male and female slaves, whom you can obtain from the nations who live around you, you may buy slaves from them. ");
INSERT INTO engULB_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","You may also buy slaves from the foreigners who are living among you, that is, from their families who are with you, children who have been born in your land. They may become your property. ");
INSERT INTO engULB_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","You may provide such slaves as an inheritance for your children after you, to hold as property, and make them slaves for life, but you must not rule over your brothers among the people of Israel with harshness. ");
INSERT INTO engULB_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","If a foreigner or someone living temporarily with you has become wealthy, and if one of your fellow Israelites has become poor and sells himself to that foreigner, or to someone in a foreigner's family, ");
INSERT INTO engULB_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","after your fellow Israelite has been bought, he may be bought back. Someone in his family may redeem him. ");
INSERT INTO engULB_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","It might be the person's uncle, or his uncle's son, who redeems him, or anyone who is his close relative from his family. Or, if he has become prosperous, he may redeem himself. ");
INSERT INTO engULB_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","He must bargain with the man who bought him; they must count the years from the year he sold himself to his purchaser until the year of Jubilee. The price of his redemption must be figured in keeping with the rate paid to a hired servant, for the number of years he might continue to work for the one who bought him. ");
INSERT INTO engULB_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","If there are still many years until the year of Jubilee, he must pay back as the price for his redemption an amount of money that is in proportion to the number of those years. ");
INSERT INTO engULB_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","If there are only a few years to the year of Jubilee, then he must bargain with his purchaser to reflect the number of years left before the year of Jubilee, and he must pay for his redemption in keeping with the number of years. ");
INSERT INTO engULB_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","He is to be treated like a man hired year by year. You must make sure he is not treated with harshness. ");
INSERT INTO engULB_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","If he is not redeemed by these means, then he must serve until the year of Jubilee, he and his children with him. ");
INSERT INTO engULB_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","To me the people of Israel are servants. They are my servants whom I brought out of the land of Egypt. I am Yahweh your God.'” ");
INSERT INTO engULB_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“You must make no idols, and you must not lift up a carved figure or a sacred stone pillar, and you must not place any carved stone image in your land to which you bow down, for I am Yahweh your God. ");
INSERT INTO engULB_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","You must keep my Sabbaths and honor my sanctuary. I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","If you walk in my laws and keep my commandments and obey them, ");
INSERT INTO engULB_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","then I will give you rain in its season; the land will yield its produce, and the trees of the field will yield their fruit. ");
INSERT INTO engULB_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Your threshing will continue to the time of the grape harvest, and the grape harvest will extend to the planting season. You will eat your bread to the full and live safely where you make your home in the land. ");
INSERT INTO engULB_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","I will give peace in the land; you will lie down with nothing to make you afraid. I will take the dangerous animals away from the land, and the sword will not pass through your land. ");
INSERT INTO engULB_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","You will chase your enemies, and they will fall before you by the sword. ");
INSERT INTO engULB_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Five of you will chase away a hundred, and a hundred of you will chase ten thousand; your enemies will fall before you by the sword. ");
INSERT INTO engULB_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","I will look at you with favor and make you fruitful and multiply you; I will establish my covenant with you. ");
INSERT INTO engULB_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","You will eat food stored a long time. You will have to bring out the stored food because you will need the room for the new harvest. ");
INSERT INTO engULB_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","I will place my tabernacle among you, and I will not detest you. ");
INSERT INTO engULB_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","I will walk among you and be your God, and you will be my people. ");
INSERT INTO engULB_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","I am Yahweh your God, who brought you out of the land of Egypt, so that you would not be their slaves. I have broken the bars of your yoke and made you to walk standing up straight. ");
INSERT INTO engULB_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","But if you will not listen to me, and will not obey all these commandments, ");
INSERT INTO engULB_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","and if you reject my decrees and detest my laws, so that you will not obey all my commandments, but break my covenant— ");
INSERT INTO engULB_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","—if you do these things, then I will do this to you: I will inflict terror on you, diseases and fever that will destroy the eyes and will drain away your life. You will plant your seeds for nothing, because your enemies will eat their produce. ");
INSERT INTO engULB_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","I will set my face against you, and you will be overpowered by your enemies. Men who hate you will rule over you, and you will run away, even when no one is chasing you. ");
INSERT INTO engULB_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","If after all this you do not listen to me, then I will punish you seven times as severely for your sins. ");
INSERT INTO engULB_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","I will break your pride in your power. I will make the sky over you like iron and your land like bronze. ");
INSERT INTO engULB_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Your strength will be used up for nothing, because your land will not produce its harvest, and your trees in the land will not produce their fruit. ");
INSERT INTO engULB_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","If you walk against me and will not listen to me, I will bring seven times more blows on you, in proportion to your sins. ");
INSERT INTO engULB_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","I will send dangerous animals against you, which will steal your children, destroy your cattle, and make you few in number. So your roads will become deserted. ");
INSERT INTO engULB_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","If in spite of these things you still do not accept my correction and you continue to walk in opposition to me, ");
INSERT INTO engULB_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","then I will also walk in opposition to you, and I myself will punish you seven times because of your sins. ");
INSERT INTO engULB_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","I will bring a sword on you that will execute vengeance for breaking the covenant. You will be gathered together inside your cities, and I will send a disease among you there, and then you will be delivered into the hand of your enemy. ");
INSERT INTO engULB_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","When I cut off your food supply, ten women will be able to bake your bread in one oven, and they will distribute your bread by weight. You will eat but not be satisfied. ");
INSERT INTO engULB_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","If you do not listen to me despite these things, but continue to walk against me, ");
INSERT INTO engULB_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","then I will walk against you in anger, and I will punish you even seven more times as much for your sins. ");
INSERT INTO engULB_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","You will eat the flesh of your sons; you will eat the flesh of your daughters. ");
INSERT INTO engULB_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","I will destroy your high places, cut down your incense altars, and throw your corpses on the corpses of your idols, and I myself will abhor you. ");
INSERT INTO engULB_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","I will turn your cities into ruins and destroy your sanctuaries. I will not be pleased with the aroma of your offerings. ");
INSERT INTO engULB_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","I will devastate the land. Your enemies who will live there will be shocked at the devastation. ");
INSERT INTO engULB_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","I will scatter you among the nations, and I will draw out my sword and follow you. Your land will be abandoned, and your cities will be ruined. ");
INSERT INTO engULB_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Then the land will enjoy its Sabbaths for as long as it lies abandoned and you are in your enemies' lands. During that time, the land will rest and enjoy its Sabbaths. ");
INSERT INTO engULB_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","As long as it lies abandoned, it will have rest, which will be the rest that it did not have with your Sabbaths, when you lived in it. ");
INSERT INTO engULB_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","As for those of you who are left in your enemies' lands, I will send fear into your hearts so that even the sound of a leaf blowing in the wind will startle you, and you will flee as though you were fleeing from the sword. You will fall, even when no one is chasing you. ");
INSERT INTO engULB_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","You will stumble over each other as though you were running from the sword, even though no one is chasing you. You will have no power to stand before your enemies. ");
INSERT INTO engULB_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","You will perish among the nations, and your enemies' land will itself devour you. ");
INSERT INTO engULB_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Those who are left among you will waste away in their sins, there in your enemies' lands, and because of their fathers' sins they will waste away as well. ");
INSERT INTO engULB_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Yet if they confess their sins and their fathers' sin, and their treason by which they were unfaithful to me, and also their walking against me— ");
INSERT INTO engULB_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","which caused me to turn against them and I brought them into the land of their enemies—if their uncircumcised hearts become humbled, and if they accept the punishment for their sins, ");
INSERT INTO engULB_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","then will I call to mind my covenant with Jacob, my covenant with Isaac, and my covenant with Abraham; also, I will call the land to mind. ");
INSERT INTO engULB_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","The land will be abandoned by them, so it will be pleased with its Sabbaths while it lies abandoned without them. They will have to pay the penalty for their sins because they themselves rejected my decrees and detested my laws. ");
INSERT INTO engULB_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Yet despite all this, when they are in their enemies' land, I will not reject them, neither will I detest them so as to completely destroy them and do away with my covenant with them, for I am Yahweh their God. ");
INSERT INTO engULB_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","But for their sakes I will call to mind the covenant with their ancestors, whom I brought out of the land of Egypt in the sight of the nations, so that I might be their God. I am Yahweh.” ");
INSERT INTO engULB_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","These are the commandments, decrees, and laws that Yahweh made between himself and the people of Israel at Mount Sinai through Moses. ");
INSERT INTO engULB_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Yahweh spoke to Moses and said, ");
INSERT INTO engULB_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Speak to the people of Israel and say to them, 'If anyone makes a special vow to Yahweh, use the following valuations. ");
INSERT INTO engULB_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Your standard value for a male from twenty to sixty years old must be fifty shekels of silver, after the shekel of the sanctuary. ");
INSERT INTO engULB_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","For a female of the same ages your standard value must be thirty shekels. ");
INSERT INTO engULB_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","From five years to twenty years old your standard value for a male must be twenty shekels, and for the female ten shekels. ");
INSERT INTO engULB_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","From one month old to five years your standard value for a male must be five shekels of silver, and for a female three shekels of silver. ");
INSERT INTO engULB_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","From sixty years old and up for a male your standard value must be fifteen shekels, and for a female ten shekels. ");
INSERT INTO engULB_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","But if the person making the vow cannot pay the standard value, then the person being given must be presented to the priest, and the priest will value that person by the amount the one making the vow is able to afford. ");
INSERT INTO engULB_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","If someone wants to sacrifice an animal to Yahweh, and if Yahweh accepts it, then that animal will be set apart to him. ");
INSERT INTO engULB_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","The person must not alter or change such an animal, a good one for a bad one or a bad for a good. If he does at all change one animal for another, then both it and the one for which it is exchanged become holy. ");
INSERT INTO engULB_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","However, if what the person has vowed to give Yahweh is in fact unclean, so that Yahweh will not accept it, then the person must bring the animal to a priest. ");
INSERT INTO engULB_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","The priest will value it, by the market value of the animal. Whatever value the priest places on the animal, that will be its value. ");
INSERT INTO engULB_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","If the owner wishes to redeem it, then a fifth of its value is to be added to its redemption price. ");
INSERT INTO engULB_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","When a man sets apart his house as a holy gift to Yahweh, then the priest will set its value as either good or bad. Whatever the priest values it, so it will be. ");
INSERT INTO engULB_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","But if the owner who set apart his home wishes to redeem it, he must add a fifth of its value to its redemption price, and it will belong to him. ");
INSERT INTO engULB_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","If a man sets apart some of his own land, then the valuation of it will be in proportion to the amount of seed required to plant it—a homer of barley will be valued at fifty shekels of silver. ");
INSERT INTO engULB_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","If he sets apart his field during the year of Jubilee, the valuation of it will stand. ");
INSERT INTO engULB_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","But if he sets apart his field after the year of Jubilee, then the priest must calculate the value of the field by the number of years that remain until the next year of Jubilee, and the valuation of it must be reduced. ");
INSERT INTO engULB_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","If the man who set apart the field wishes to redeem it, then he must add a fifth to the valuation, and it will belong to him. ");
INSERT INTO engULB_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","If he does not redeem the field, or if he has sold the field to another man, it cannot be redeemed any more. ");
INSERT INTO engULB_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Instead, the field, when it is released in the year of Jubilee, will be a holy gift to Yahweh, like the field that has been completely given to Yahweh. It will belong to the priest. ");
INSERT INTO engULB_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","If a man sets apart a field that he has bought, but that field is not part of his family's land, ");
INSERT INTO engULB_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","then the priest will figure the valuation of it up to the year of Jubilee, and the man must pay its value on that day as a holy gift to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","In the year of Jubilee, the field will return to the man from whom it was bought, to the land's owner. ");
INSERT INTO engULB_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","All the valuations must be set by the weight of the sanctuary shekel. Twenty gerahs must be the equivalent of one shekel. ");
INSERT INTO engULB_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","No one may set apart the firstborn among animals, since the firstborn already belongs to Yahweh; whether ox or sheep, it is Yahweh's. ");
INSERT INTO engULB_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","If it is an unclean animal, then the owner may buy it back at the valuation of it, and a fifth must be added to that value. If the animal is not redeemed, then it is to be sold at the set value. ");
INSERT INTO engULB_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","But nothing that a man devotes to Yahweh, from all that he has, whether human or animal, or his family land, may be sold or redeemed. Everything that is devoted is very holy to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","No ransom may be paid for the person who is devoted for destruction. That person must be put to death. ");
INSERT INTO engULB_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","All the tithe of the land, whether grain grown on the land or fruit from the trees, is Yahweh's. It is holy to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","If a man redeems any of his tithe, he must add a fifth to its value. ");
INSERT INTO engULB_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","As for every tenth of the herd or the flock, whatever passes under the shepherd's rod, one-tenth must be set apart to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","The shepherd must not search for the better or the worse animals, and he must not substitute one for another. If he changes it at all, then both it and that for which it is changed will be holy. It cannot be redeemed.'” ");
INSERT INTO engULB_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","These are the commandments that Yahweh gave at Mount Sinai to Moses for the people of Israel. ");
INSERT INTO engULB_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Yahweh spoke to Moses in the tent of meeting in the wilderness of Sinai. This happened on the first day of the second month during the second year after the people of Israel had come out from the land of Egypt. Yahweh said, ");
INSERT INTO engULB_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Conduct a census of all the men of Israel in each clan, in their fathers' families. Count them by name. Count every male, each man ");
INSERT INTO engULB_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","who is twenty years old or older. Count all who can fight as soldiers for Israel. You and Aaron must record the number of men in their armed groups. ");
INSERT INTO engULB_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","A man from each tribe, a clan head, must serve with you as his tribe's leader. Each leader must lead the men who will fight for his tribe. ");
INSERT INTO engULB_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","These are the names of the leaders who must fight with you: From the tribe of Reuben, Elizur son of Shedeur; ");
INSERT INTO engULB_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","from the tribe of Simeon, Shelumiel son of Zurishaddai; ");
INSERT INTO engULB_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","from the tribe of Judah, Nahshon son of Amminadab; ");
INSERT INTO engULB_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","from the tribe of Issachar, Nethanel son of Zuar; ");
INSERT INTO engULB_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","from the tribe of Zebulun, Eliab son of Helon; ");
INSERT INTO engULB_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","from the tribe of Ephraim son of Joseph, Elishama son of Ammihud; from the tribe of Manasseh, Gamaliel son of Pedahzur; ");
INSERT INTO engULB_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","from the tribe of Benjamin, Abidan son of Gideoni; ");
INSERT INTO engULB_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","from the tribe of Dan, Ahiezer son of Ammishaddai; ");
INSERT INTO engULB_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","from the tribe of Asher, Pagiel son of Okran; ");
INSERT INTO engULB_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","from the tribe of Gad, Eliasaph son of Deuel; ");
INSERT INTO engULB_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","and from the tribe of Naphtali, Ahira son of Enan.” ");
INSERT INTO engULB_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","These were the men appointed from the people. They led their ancestors' tribes. They were the leaders of the clans in Israel. ");
INSERT INTO engULB_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Moses and Aaron took these men, who were recorded by name, ");
INSERT INTO engULB_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","and along with these men they assembled all the men of Israel on the first day of the second month. Then each man twenty years old and older identified his ancestry. He had to name the clans and families descended from his ancestors. ");
INSERT INTO engULB_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Then Moses recorded their numbers in the wilderness of Sinai, as Yahweh had commanded him to do. ");
INSERT INTO engULB_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","From the descendants of Reuben, Israel's firstborn, were counted all the names of each and every man twenty years old or older able to go to war, from the records of their ancestor's clans and families. ");
INSERT INTO engULB_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","They counted 46,500 men from the tribe of Reuben. ");
INSERT INTO engULB_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","From the descendants of Simeon were counted all the names of each and every man twenty years old or older able to go to war, from the records of their ancestor's clans and families. ");
INSERT INTO engULB_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","They counted 59,300 men from the tribe of Simeon. ");
INSERT INTO engULB_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","From the descendants of Gad were counted all the names of each and every man twenty years old or older able to go to war, from the records of their ancestor's clans and families. ");
INSERT INTO engULB_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","They counted 45,650 men from the tribe of Gad. ");
INSERT INTO engULB_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","From the descendants of Judah were counted all the names of each and every man twenty years old or older able to go to war, from the records of their ancestor's clans and families. ");
INSERT INTO engULB_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","They counted 74,600 men from the tribe of Judah. ");
INSERT INTO engULB_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","From the descendants of Issachar were counted all the names of each and every man twenty years old or older able to go to war, from the records of their ancestor's clans and families. ");
INSERT INTO engULB_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","They counted 54,400 men from the tribe of Issachar. ");
INSERT INTO engULB_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","From the descendants of Zebulun were counted all the names of each and every man twenty years old or older able to go to war, from the records of their ancestor's clans and families. ");
INSERT INTO engULB_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","They counted 57,400 men from the tribe of Zebulun. ");
INSERT INTO engULB_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","From the descendants of Ephraim son of Joseph were counted all the names of each and every man twenty years old or older able to go to war, from the records of their ancestor's clans and families. ");
INSERT INTO engULB_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","They counted 40,500 men from the tribe of Ephraim. ");
INSERT INTO engULB_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","From the descendants of Manasseh son of Joseph were counted all the names of each and every man twenty years old or older able to go to war, from the records of their ancestor's clans and families. ");
INSERT INTO engULB_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","They counted 32,200 men from the tribe of Manasseh. ");
INSERT INTO engULB_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","From the descendants of Benjamin were counted all the names of each and every man twenty years old or older able to go to war, from the records of their ancestor's clans and families. ");
INSERT INTO engULB_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","They counted 35,400 men from the tribe of Benjamin. ");
INSERT INTO engULB_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","From the descendants of Dan were counted all the names of each and every man twenty years old or older able to go to war, from the records of their ancestor's clans and families. ");
INSERT INTO engULB_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","They counted 62,700 from the tribe of Dan. ");
INSERT INTO engULB_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","From the descendants of Asher were counted all the names of each and every man twenty years old or older able to go to war, from the records of their ancestor's clans and families. ");
INSERT INTO engULB_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","They counted 41,500 men from the tribe of Asher. ");
INSERT INTO engULB_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","From the descendants of Naphtali were counted all the names of each and every man twenty years old or older able to go to war, from the records of their ancestor's clans and families. ");
INSERT INTO engULB_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","They counted 53,400 from the tribe of Naphtali. ");
INSERT INTO engULB_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Moses and Aaron counted all these men, together with the twelve men who were leading the twelve tribes of Israel. ");
INSERT INTO engULB_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","So all the men of Israel from twenty years old and older, all who could fight in war, were counted in each of their families. ");
INSERT INTO engULB_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","They counted 603,550 men. ");
INSERT INTO engULB_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","But the men who were descended from Levi were not counted, ");
INSERT INTO engULB_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","because Yahweh had said to Moses, ");
INSERT INTO engULB_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“You must not count the tribe of Levi or include them in the total of the people of Israel. ");
INSERT INTO engULB_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Instead, assign the Levites to care for the tabernacle of the covenant decrees, and to care for all the furnishings in the tabernacle and for everything in it. The Levites must carry the tabernacle, and they must carry the tabernacle's furnishings. They must care for the tabernacle and make their camp around it. ");
INSERT INTO engULB_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","When the tabernacle is to move to another place, the Levites must take it down. When the tabernacle is to be set up, the Levites must set it up. Any stranger who comes near the tabernacle must be killed. ");
INSERT INTO engULB_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","When the people of Israel set up their tents, each man must do so near the banner that belongs to his armed group. ");
INSERT INTO engULB_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","However, the Levites must set up their tents around the tabernacle of the covenant decrees so that my anger does not come upon the people of Israel. The Levites must care for the tabernacle of the covenant decrees.” ");
INSERT INTO engULB_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","The people of Israel did all these things. They did everything that Yahweh commanded through Moses. ");
INSERT INTO engULB_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Yahweh spoke again to Moses and Aaron. He said, ");
INSERT INTO engULB_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Each one of the Israelites must camp around his standard, with the banners of their fathers' houses. They will camp around the tent of meeting on every side. ");
INSERT INTO engULB_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Those will be camping on the east of the tent of meeting, where the sun rises, they are the camp of Judah and they are camping under their standard. Nahshon son of Amminadab is the leader of the people of Judah. ");
INSERT INTO engULB_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","The number of the people of Judah is 74,600. ");
INSERT INTO engULB_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","The tribe of Issachar must camp next to Judah. Nethanel son of Zuar must lead the army of Issachar. ");
INSERT INTO engULB_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","The number in his division is 54,400 men. ");
INSERT INTO engULB_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","The tribe of Zebulun must camp next to Issachar. Eliab son of Helon must lead the army of Zebulun. ");
INSERT INTO engULB_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","The number in his division is 57,400. ");
INSERT INTO engULB_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","All the number of the camp of Judah is 186,400. They will set out first. ");
INSERT INTO engULB_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","On the south side will be the camp of Reuben under their standard. The leader of the camp of Reuben is Elizur son of Shedeur. ");
INSERT INTO engULB_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","The number in his division is 46,500. ");
INSERT INTO engULB_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Simeon is camping next to Reuben. The leader of the people of Simeon is Shelumiel son of Zurishaddai. ");
INSERT INTO engULB_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","The number in his division is 59,300. ");
INSERT INTO engULB_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","The tribe of Gad is next. The leader of the people of Gad is Eliasaph son of Deuel. ");
INSERT INTO engULB_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","The number in his division is 45,650. ");
INSERT INTO engULB_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","The number of all the men assigned to the camp of Reuben, according to their divisions, is 151,450. They will set out second. ");
INSERT INTO engULB_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Next, the tent of meeting must go out from the camp with the Levites in the middle of all the camps. They must go out from the camp in the same order as they come into the camp. Every man must be in his place, by his banner. ");
INSERT INTO engULB_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","The divisions of the camp of Ephraim under their standard. The leader of the people of Ephraim is Elishama son of Ammihud. ");
INSERT INTO engULB_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","The number in his division is 40,500. ");
INSERT INTO engULB_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Next to them is the tribe of Manasseh. The leader of Manasseh is Gamaliel son of Pedahzur. ");
INSERT INTO engULB_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","The number in his division is 32,200. ");
INSERT INTO engULB_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Next will be the tribe of Benjamin. The leader of Benjamin is Abidan son of Gideoni. ");
INSERT INTO engULB_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","The number in his division is 35,400. ");
INSERT INTO engULB_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","All those numbered in the camp of Ephraim is 108,100. They will set out third. ");
INSERT INTO engULB_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","On the north will be the divisions of the camp of Dan. The leader of the people of Dan is Ahiezer son of Ammishaddai. ");
INSERT INTO engULB_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","The number in his division is 62,700. ");
INSERT INTO engULB_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","The people of the tribe of Asher camp next to Dan. The leader of Asher is Pagiel son of Okran. ");
INSERT INTO engULB_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","The number in his division is 41,500. ");
INSERT INTO engULB_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","The tribe of Naphtali is next. The leader of Naphthali is Ahira son of Enan. ");
INSERT INTO engULB_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","The mnumber in his division is 53,400. ");
INSERT INTO engULB_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","All those numbered in the camp with Dan is 157,600. They will go out from the camp last, under their banner.” ");
INSERT INTO engULB_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","These are the Israelites, numbered according to their families. All those counted in their camps, by their divisions, are 603,550. ");
INSERT INTO engULB_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","But Moses and Aaron did not count the Levites among the people of Israel. This was as Yahweh had commanded Moses. ");
INSERT INTO engULB_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","The people of Israel did everything that Yahweh commanded Moses. They camped by their banners. They went out from the camp by their clans, in the order of their ancestor's families. ");
INSERT INTO engULB_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Now this is the history of the descendants of Aaron and Moses when Yahweh spoke with Moses on Mount Sinai. ");
INSERT INTO engULB_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","The names of Aaron's sons were Nadab the firstborn, and Abihu, Eleazar, and Ithamar. ");
INSERT INTO engULB_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","These are the names of the sons of Aaron, the priests who were anointed and who were ordained to serve as priests. ");
INSERT INTO engULB_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","But Nadab and Abihu fell dead before Yahweh when they offered to him unacceptable fire in the wilderness of Sinai. Nadab and Abihu had no children, so just Eleazar and Ithamar served as priests with Aaron their father. ");
INSERT INTO engULB_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Yahweh spoke to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Bring the tribe of Levi and present them to Aaron the priest for them to help him. ");
INSERT INTO engULB_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","They must perform the duties on behalf of Aaron and the whole community before the tent of meeting. They must serve in the tabernacle. ");
INSERT INTO engULB_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","They must care for all the furnishings in the tent of meeting, and they must help the tribes of Israel to carry out the tabernacle service. ");
INSERT INTO engULB_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","You must give the Levites to Aaron and his sons. They are wholly given to help him serve the people of Israel. ");
INSERT INTO engULB_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","You must appoint Aaron and his sons as priests, but any foreigner who comes near must be put to death.” ");
INSERT INTO engULB_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Yahweh spoke to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Look, I have taken the Levites from among the people of Israel. I have done this instead of taking each firstborn male who is born among the people of Israel. The Levites belong to me. ");
INSERT INTO engULB_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","All the firstborn belong to me. On the day that I attacked all the firstborn in the land of Egypt, I set apart for myself all the firstborn in Israel, both people and animals. They belong to me. I am Yahweh.” ");
INSERT INTO engULB_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Yahweh spoke to Moses in the wilderness of Sinai. He said, ");
INSERT INTO engULB_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Count the descendants of Levi in each family, in their clans. Count every male who is one month old and older.” ");
INSERT INTO engULB_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Moses counted them, following the word of Yahweh, just as he was commanded to do. ");
INSERT INTO engULB_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","The names of Levi's sons were Gershon, Kohath, and Merari. ");
INSERT INTO engULB_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","The clans coming from Gershon's sons were Libni and Shimei. ");
INSERT INTO engULB_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","The clans coming from Kohath's sons were Amram, Izhar, Hebron, and Uzziel. ");
INSERT INTO engULB_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","The clans coming from Merari's sons were Mahli and Mushi. These are the clans of the Levites, listed clan by clan. ");
INSERT INTO engULB_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","The clans of the Libnites and the Shimeites come from Gershon. These are the clans of the Gershonites. ");
INSERT INTO engULB_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","All the males from a month old and older were counted, totaling 7,500. ");
INSERT INTO engULB_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","The clans of the Gershonites must camp on the west side of the tabernacle. ");
INSERT INTO engULB_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Eliasaph son of Lael must lead the clans of the descendants of the Gershonites. ");
INSERT INTO engULB_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","The family of Gershon must care for the tent of meeting including the tabernacle. They must care for the tent, its covering, and the curtain used as the entrance to the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","They must care for the courtyard hangings, the curtain at the courtyard entrance—the courtyard that surrounds the sanctuary and the altar. They must care for the ropes of the tent of meeting and for everything in it. ");
INSERT INTO engULB_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","These clans come from Kohath: the clan of the Amramites, the clan of the Izharites, the clan of the Hebronites, and the clan of the Uzzielites. These clans belong to the Kohathites. ");
INSERT INTO engULB_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","8,600 males have been counted aged one month old and older to take care of the things that belong to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","The Kohath clans must camp on the south side of the tabernacle. ");
INSERT INTO engULB_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Elizaphan son of Uzziel must lead the clans of the Kohathites. ");
INSERT INTO engULB_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","They must care for the ark, the table, the lampstand, the altars, the holy things that are used in their service, the curtain, and all the work around it. ");
INSERT INTO engULB_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Eleazar son of Aaron the priest must lead the men who lead the Levites. He must supervise the men who care for the holy place. ");
INSERT INTO engULB_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Two clans have come from Merari: the clan of the Mahlites and the clan of the Mushites. These clans have come from Merari. ");
INSERT INTO engULB_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","6,200 males have been counted aged one month old and older. ");
INSERT INTO engULB_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Zuriel son of Abihail must lead the clans of Merari. They must camp on the north side of the tabernacle. ");
INSERT INTO engULB_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","The descendants of Merari must care for the framing of the tabernacle, the crossbars, posts, bases, all the hardware, and everything related to them, including ");
INSERT INTO engULB_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","the pillars and posts of the courtyard that surround the tabernacle, with their sockets, pegs, and ropes. ");
INSERT INTO engULB_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Moses and Aaron and his sons must camp on the east side of the tabernacle, in front of the tent of meeting, toward the sunrise. They are responsible for the fulfillment of the duties of the sanctuary and the duties of the people of Israel. Any foreigner who approaches the sanctuary must be put to death. ");
INSERT INTO engULB_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Moses and Aaron counted all the males in the clans of Levi who were aged one month old and older, just as Yahweh commanded. They counted twenty-two thousand men. ");
INSERT INTO engULB_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Yahweh said to Moses, “Count all the firstborn males of the people of Israel who are aged one month old and older. List their names. ");
INSERT INTO engULB_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","You must take the Levites for me—I am Yahweh—instead of all the firstborn of the people of Israel, and the livestock of the Levites instead of the firstborn of the livestock of the descendants of Israel.” ");
INSERT INTO engULB_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Moses counted all the firstborn people of Israel as Yahweh had commanded him to do. ");
INSERT INTO engULB_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","He counted all the firstborn males by name, aged one month old and older. He counted 22,273 men. ");
INSERT INTO engULB_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Again, Yahweh spoke to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Take the Levites instead of all the firstborn among the people of Israel, and take the Levites' livestock instead of the people's livestock. The Levites belong to me—I am Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","You must collect five shekels for the redemption of each of the 273 firstborn people of Israel who exceed the number of the Levites. ");
INSERT INTO engULB_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","You must use the shekel of the sanctuary as your standard weight. The shekel equals twenty gerahs. ");
INSERT INTO engULB_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","You must give the price of redemption that you paid to Aaron and his sons.” ");
INSERT INTO engULB_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","So Moses collected the payment of redemption from those who exceeded the number of those redeemed by the Levites. ");
INSERT INTO engULB_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Moses collected the money from the firstborn of the people of Israel. He collected 1,365 shekels, weighing with the shekel of the sanctuary. ");
INSERT INTO engULB_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Moses gave the redemption money to Aaron and to his sons. Moses did everything he was told to do by Yahweh's word, as Yahweh had commanded him. ");
INSERT INTO engULB_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Yahweh spoke to Moses and to Aaron. He said, ");
INSERT INTO engULB_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Conduct a census of the male descendants of Kohath from among the Levites, by their clans and families. ");
INSERT INTO engULB_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Count all the men who are thirty to fifty years old. These men must join the company to serve in the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","The descendants of Kohath must take care of the most holy things reserved for me in the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","When the camp prepares to move forward, Aaron and his sons must go into the tent, take down the curtain that separates the most holy place from the holy place and cover the ark of the testimony with it. ");
INSERT INTO engULB_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","They must cover the ark with sea cow skins. They must spread a blue cloth over it. They must insert the poles to carry it. ");
INSERT INTO engULB_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","They are to spread a blue cloth on the table of the bread of the presence. On it they must put the dishes, spoons, bowls, and jars for pouring. Bread must always continue to be on the table. ");
INSERT INTO engULB_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","They must cover them with a scarlet cloth and again with sea cow skins. They must insert poles to carry the table. ");
INSERT INTO engULB_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","They must take a blue cloth and cover the lampstand, along with its lamps, tongs, trays, and all the jars of oil for the lamps. ");
INSERT INTO engULB_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","They must put the lampstand and all its accessories into a covering of sea cow skins, and they must put it on a carrying frame. ");
INSERT INTO engULB_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","They must spread a cloth of blue on the gold altar. They must cover it with a covering of sea cow skins, and then insert the carrying poles. ");
INSERT INTO engULB_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","They must take all the equipment for the work in the holy place and wrap it in a blue cloth. They must cover it with sea cow skins and put the equipment on the carrying frame. ");
INSERT INTO engULB_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","They must remove the ashes from the altar and spread a purple cloth on the altar. ");
INSERT INTO engULB_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","They must put on the carrying frame all the equipment that they use in the work of the altar. These objects are the firepans, forks, shovels, bowls, and all the other equipment for the altar. They must cover the altar with sea cow skins and then insert the carrying poles. ");
INSERT INTO engULB_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","When Aaron and his sons have completely covered the holy place and all its equipment, and when the camp moves forward, then the descendants of Kohath must come to carry the holy place. If they touch the holy instruments, they must die. This is the work of the descendants of Kohath, to carry the furnishings in the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Eleazar son of Aaron the priest oversees the care of the oil for the light, the sweet incense, the regular grain offering, and the anointing oil. He oversees the care of the entire tabernacle and all that is in it, the holy place and its equipment.” ");
INSERT INTO engULB_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Yahweh spoke to Moses and to Aaron. He said, ");
INSERT INTO engULB_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Do not allow the Kohathite tribal clans to be removed from among the Levites. ");
INSERT INTO engULB_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Protect them, that they may live and not die, by doing this. When they approach the most holy things ");
INSERT INTO engULB_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","they must not go in to see the holy place even for a moment, or they must die. Aaron and his sons must go in, and then Aaron and his sons must assign each of the Kohathites to his work, to his special tasks.” ");
INSERT INTO engULB_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Yahweh spoke again to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Conduct a census of the descendants of Gershon also, by their ancestor's families and by their clans. ");
INSERT INTO engULB_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Count those who are thirty years old to fifty years old. Count all of them who will join the company to serve in the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","This is the work of the clans of the Gershonites, when they serve and what they carry. ");
INSERT INTO engULB_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","They must carry the curtains of the tabernacle, the tent of meeting, its covering, the covering of sea cow skin that is on it, and the curtains for the entrance to the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","They must carry the curtains of the court, the curtain for the doorway of the court's gate, which is near the tabernacle and near the altar, their ropes, and all the instruments for their service. Whatever should be done with these things, they must do it. ");
INSERT INTO engULB_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Aaron and his sons must direct all the service of the descendants of the Gershonites, in everything that they transport, and in all their service. You must assign them to all their responsibilities. ");
INSERT INTO engULB_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","This is the service of the clans of the descendants of the Gershonites for the tent of meeting. Ithamar son of Aaron the priest must lead them in their service. ");
INSERT INTO engULB_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","You must count the descendants of Merari by their clans, and order them by their ancestor's families, ");
INSERT INTO engULB_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","from thirty years old and older up to fifty years old. Count everyone who is going to join the company and serve in the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","This is their responsibility and their work in all their service for the tent of meeting. They must care for the framing of the tabernacle, its crossbars, posts, and sockets, ");
INSERT INTO engULB_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","along with the posts of the courtyard around the tabernacle, their sockets, pegs, and their ropes, with all their hardware. List by name the articles they must carry. ");
INSERT INTO engULB_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","This is the service of the clans of the descendants of Merari, what they are to do for the tent of meeting, under the direction of Ithamar son of Aaron the priest.” ");
INSERT INTO engULB_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Moses and Aaron and the leaders of the community counted the descendants of the Kohathites by the clans of their ancestor's families. ");
INSERT INTO engULB_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","They counted them from thirty years old and older up to fifty years old. They counted everyone who would join the company to serve in the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","They counted 2,750 men by their clans. ");
INSERT INTO engULB_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Moses and Aaron counted all the men in the clans and families of the Kohathites who serve in the tent of meeting. In doing this, they obeyed what Yahweh had commanded them to do through Moses. ");
INSERT INTO engULB_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","The descendants of Gershon were counted in their clans, by their ancestor's families, ");
INSERT INTO engULB_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","from thirty to fifty years old, everyone who would join the company to serve in the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","All the men, counted by their clans and their ancestor's families, numbered 2,630. ");
INSERT INTO engULB_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Moses and Aaron counted the clans of the descendants of Gershon who would serve in the tent of meeting. In doing this, they obeyed what Yahweh had commanded them to do through Moses. ");
INSERT INTO engULB_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","The descendants of Merari were counted in their clans by their ancestor's families, ");
INSERT INTO engULB_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","from thirty to fifty years old, everyone who would join the company to serve in the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","All the men, counted by their clans and their ancestor's families, numbered 3,200. ");
INSERT INTO engULB_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Moses and Aaron counted all these men, the descendants of Merari. In doing this, they obeyed what Yahweh had commanded them to do through Moses. ");
INSERT INTO engULB_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","So Moses, Aaron, and the leaders of Israel counted all the Levites by their clans in their ancestral families ");
INSERT INTO engULB_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","from thirty to fifty years old. They counted everyone who would do work in the tabernacle, and who would carry and care for the items in the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","They counted 8,580 men. ");
INSERT INTO engULB_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","At Yahweh's command, Moses counted each man, keeping count of each by the type of work he was assigned to do. He counted each man by the kind of responsibility he would bear. In doing this, they obeyed what Yahweh had commanded them to do through Moses. ");
INSERT INTO engULB_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Yahweh spoke to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Command the people of Israel to send away from the camp everyone with an infectious skin disease, and everyone who has an oozing sore, and whoever is unclean through touching a dead body. ");
INSERT INTO engULB_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Whether male or female, you must send them out of the camp. They must not defile the camp, because I live in it.” ");
INSERT INTO engULB_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","The people of Israel did so. They sent them out of the camp, as Yahweh commanded Moses. The people of Israel obeyed Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Again Yahweh spoke to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Speak to the people of Israel. When a man or woman commits any sin such as people do to one another, and is unfaithful to me, that person is guilty. ");
INSERT INTO engULB_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Then he must confess the sin that he has done. He must completely pay back the price of his guilt and add to the price one-fifth more. He must give this to the one he has wronged. ");
INSERT INTO engULB_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","But if the wronged person has no close relative to receive the payment, he must pay the price for his guilt to me through a priest, along with a ram to atone for himself. ");
INSERT INTO engULB_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Every offering of the people of Israel, the things that are set aside and brought to the priest by the people of Israel, will belong to him. ");
INSERT INTO engULB_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","The offerings of every person will be for the priest; if anyone gives anything to the priest, it will belong to him.” ");
INSERT INTO engULB_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Again, Yahweh spoke to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Speak to the people of Israel. Say to them, 'Suppose that a man's wife turns away and sins against her husband. ");
INSERT INTO engULB_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","Then suppose that another man sleeps with her. In that case, she is defiled. Even if her husband does not see it or know about it, and even if no one catches her in the act and there is no one to testify against her, ");
INSERT INTO engULB_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","nevertheless, a spirit of jealousy might still inform the husband that his wife is defiled. However, a spirit of jealousy might falsely come on a man when his wife is not defiled. ");
INSERT INTO engULB_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","In such cases, the man must bring his wife to the priest. The husband must take an offering required on her behalf, a tenth of an ephah of barley flour. He must pour no oil on it and put no frankincense on it, because it is a grain offering of jealousy, a grain offering for remembering, as a reminder of the iniquity. ");
INSERT INTO engULB_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","The priest must bring her near and place her before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","The priest must take a jar of holy water and take dust from the floor of the tabernacle. He must put the dust into the water. ");
INSERT INTO engULB_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","The priest will set the woman before Yahweh and he will untie the hair on the woman's head. He will put into her hands the grain offering of remembrance, which is the grain offering of suspicion. The priest will hold in his hand the bitter water that can bring a curse. ");
INSERT INTO engULB_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","The priest will put the woman under an oath and say to her, 'If no other man had sexual relations with you, and if you have not gone astray and committed impurity, then you will be free from this bitter water that can bring a curse. ");
INSERT INTO engULB_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","But if you, a woman under her husband, have gone astray, if you are defiled, and if some other man has slept with you, ");
INSERT INTO engULB_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","then, (the priest must cause the woman to swear an oath that can bring down a curse on her, and then he must continue speaking to the woman) 'Yahweh will make you into a curse that will be shown to your people to be such. This will happen if Yahweh causes your thigh to waste away and your abdomen to swell. ");
INSERT INTO engULB_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","This water that brings the curse will go into your stomach and make your abdomen swell and your thighs waste away.' The woman is to reply, 'Yes, let that happen if I am guilty.' ");
INSERT INTO engULB_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","The priest must write these curses on a scroll, and then he must wash away the written curses into the bitter water. ");
INSERT INTO engULB_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","The priest must make the woman drink the bitter water that brings the curse. The water that brings the curse will enter her and become bitter. ");
INSERT INTO engULB_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","The priest must take the grain offering of jealousy out of the woman's hand. He must hold up the grain offering before Yahweh and bring it to the altar. ");
INSERT INTO engULB_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","The priest must take a handful of the grain offering as a representative offering, and burn it on the altar. Then he must give the woman the bitter water to drink. ");
INSERT INTO engULB_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","When he gives her the water to drink, if she is defiled because she has committed a sin against her husband, then the water that brings the curse will enter her and become bitter. Her abdomen will swell and her thigh will waste away. The woman will be cursed among her people. ");
INSERT INTO engULB_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","But if the woman is not defiled and if she is clean, then she must be free. She will be able to conceive children. ");
INSERT INTO engULB_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","This is the law of jealousy. It is the law for a woman who strays away from her husband and is defiled. ");
INSERT INTO engULB_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","It is the law for a man with a spirit of jealousy when he is jealous of his wife. He must bring the woman before Yahweh, and the priest must do to her everything that this law of jealousy describes. ");
INSERT INTO engULB_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","The man will be free from guilt for bringing his wife to the priest. The woman must bear any guilt she might have.” ");
INSERT INTO engULB_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Yahweh spoke to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Speak to the people of Israel. Say to them, 'When a man or a woman separates himself to Yahweh with a special vow of a Nazirite, ");
INSERT INTO engULB_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","he must keep himself from wine and strong drink. He must not drink vinegar made from wine or from strong drink. He must not drink any grape juice or eat fresh grapes or raisins. ");
INSERT INTO engULB_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","In all the days that he is separate to me, he must eat nothing that is made from grapes, including everything made from the seeds to their skins. ");
INSERT INTO engULB_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","During all the time of his vow of separation, no razor is to be used on his head until the days of his separation to Yahweh are fulfilled. He must be set apart to Yahweh. He must let the hair grow long on his head. ");
INSERT INTO engULB_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","During all the time that he separates himself to Yahweh, he must not come near a dead body. ");
INSERT INTO engULB_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","He must not make himself unclean even for his father, mother, brother, or sister, if they die. This is because he is separated to God, as everyone can see by his long hair. ");
INSERT INTO engULB_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","During all the time of his separation he is holy, reserved for Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","If someone very suddenly dies beside him and defiles his consecrated head, then he must shave his head on the day of his purification—on the seventh day he must shave it. ");
INSERT INTO engULB_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","On the eighth day he must bring two doves or two young pigeons to the priest at the entrance to the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","The priest must offer one bird as a sin offering and the other as a burnt offering. These will atone for him because he sinned by being near the dead body. He must consecrate his head again on that day. ");
INSERT INTO engULB_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","He must set himself apart to Yahweh for the days of his consecration. He must bring a male lamb one year old as a guilt offering. The days before he defiled himself must not be counted, because his consecration was defiled. ");
INSERT INTO engULB_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","This is the law about the Nazirite for when the time of his separation is complete. He must be brought to the entrance of the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","He must present his offering to Yahweh. He must offer as a burnt offering a male lamb one year old and without blemish. He must bring as a sin offering a female lamb one year old and without blemish. He must bring a ram as a fellowship offering that is without blemish. ");
INSERT INTO engULB_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","He must also bring a basket of bread made without yeast, loaves of fine flour mixed with oil, wafers without yeast rubbed with oil, together with their grain offering and drink offerings. ");
INSERT INTO engULB_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","The priest must present them before Yahweh. He must offer his sin offering and burnt offering. ");
INSERT INTO engULB_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","With the basket of unleavened bread, he must present the ram as a sacrifice, the fellowship offering to Yahweh. The priest must present also the grain offering and the drink offering. ");
INSERT INTO engULB_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","The Nazirite must shave his head indicating his separation to God at the entrance to the tent of meeting. He must take the hair from his head and put it on the fire that is under the sacrifice of fellowship offerings. ");
INSERT INTO engULB_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","The priest must take the boiled shoulder of the ram, one loaf of bread without yeast out of the basket, and one wafer without yeast. He must place them into the hands of the Nazirite after he has shaved his head indicating separation. ");
INSERT INTO engULB_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","The priest must wave them as an offering before Yahweh, a holy portion for the priest, together with the breast that was waved and the thigh that was presented for the priest. After that, the Nazirite may drink wine. ");
INSERT INTO engULB_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","This is the law for the Nazirite who vows his offering to Yahweh for his separation. Whatever else he may give, he must keep the obligations of the vow he has taken, to keep the promise indicated by the law for the Nazirite.'” ");
INSERT INTO engULB_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Again Yahweh spoke to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Speak to Aaron and to his sons. Say, 'You must bless the people of Israel in this way. You must say to them, ");
INSERT INTO engULB_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“May Yahweh bless you and keep you. ");
INSERT INTO engULB_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","May Yahweh make his face shine on you and be gracious to you. ");
INSERT INTO engULB_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","May Yahweh look on you with favor and give you peace.”' ");
INSERT INTO engULB_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","It is in this way that they must give my name to the people of Israel. Then I will bless them.” ");
INSERT INTO engULB_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","On the day that Moses completed the tabernacle, he anointed it and set it apart to Yahweh, together with all of its furnishings. He did the same for the altar and all its utensils. He anointed them and set them apart to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","On that day, the leaders of Israel, the heads of their ancestor's families, offered sacrifices. These men were leading the tribes. They had overseen the counting of the men in the census. ");
INSERT INTO engULB_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","They brought their offerings before Yahweh. They brought six covered carts and twelve oxen. They brought one cart for every two leaders, and each leader brought one ox. They presented these things in front of the tabernacle. ");
INSERT INTO engULB_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Then Yahweh spoke to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Accept the offerings from them and use the offerings for the work in the tent of meeting. Give the offerings to the Levites, to each one as his work needs them.” ");
INSERT INTO engULB_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Moses took the carts and the oxen, and he gave them to the Levites. ");
INSERT INTO engULB_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","He gave two carts and four oxen to the descendants of Gershon, because of what their work needed. ");
INSERT INTO engULB_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","He gave four carts and eight oxen to the descendants of Merari, in the care of Ithamar son of Aaron the priest. He did this because of what their work required. ");
INSERT INTO engULB_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","But he gave none of those things to the descendants of Kohath, because theirs would be the work related to the things that belong to Yahweh that they would carry on their own shoulders. ");
INSERT INTO engULB_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","The leaders offered their goods for the dedication of the altar on the day that Moses anointed the altar. The leaders offered their sacrifices in front of the altar. ");
INSERT INTO engULB_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Yahweh said to Moses, “Each leader must offer on his own day his sacrifice for the dedication of the altar.” ");
INSERT INTO engULB_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","On the first day, Nahshon son of Amminadab, of the tribe of Judah, offered his sacrifice. ");
INSERT INTO engULB_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","His sacrifice was one silver platter weighing 130 shekels and one silver bowl weighing seventy shekels, by the standard weight of the sanctuary shekel. Both of these objects were full of fine flour mixed with oil for a grain offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","He gave one gold dish that weighed ten shekels and was full of incense. ");
INSERT INTO engULB_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","He gave as a burnt offering one young bull, one ram, and a one-year-old male lamb. ");
INSERT INTO engULB_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","He gave one male goat as a sin offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","He gave two oxen, five rams, five male goats, and five male lambs that were a year old, as the sacrifice for a fellowship offering. This was the sacrifice of Nahshon son of Amminadab. ");
INSERT INTO engULB_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","On the second day, Nethanel son of Zuar, leader of Issachar, offered his sacrifice. ");
INSERT INTO engULB_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","He offered as his sacrifice one silver platter weighing 130 shekels and one silver bowl weighing seventy shekels, by the standard weight of the sanctuary shekel. Both of these objects were full of fine flour mixed with oil for a grain offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","He also gave one gold dish weighing ten shekels, full of incense. ");
INSERT INTO engULB_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","He gave as a burnt offering one young bull, one ram, and a one-year-old male lamb. ");
INSERT INTO engULB_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","He gave one male goat as a sin offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","He gave two oxen, five rams, five male goats, and five male lambs that were a year old, as the sacrifice for a fellowship offering. This was the sacrifice of Nethanel son of Zuar. ");
INSERT INTO engULB_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","On the third day, Eliab son of Helon, leader of the descendants of Zebulun, offered his sacrifice. ");
INSERT INTO engULB_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","His sacrifice was one silver platter weighing 130 shekels, and one silver bowl weighing seventy shekels by the standard weight of the sanctuary shekel. Both of these objects were full of fine flour mixed with oil for a grain offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","He also gave one gold dish weighing ten shekels, full of incense. ");
INSERT INTO engULB_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","He gave as a burnt offering one young bull, one ram, and a one-year-old male lamb. ");
INSERT INTO engULB_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","He gave one male goat as a sin offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","He gave two oxen, five rams, five male goats, and five male lambs that were a year old, as the sacrifice for a fellowship offering. This was the sacrifice of Eliab son of Helon. ");
INSERT INTO engULB_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","On the fourth day, Elizur son of Shedeur, leader of the descendants of Reuben, offered his sacrifice. ");
INSERT INTO engULB_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","His sacrifice was one silver platter weighing 130 shekels and one silver bowl weighing seventy shekels, by the standard weight of the sanctuary shekel. Both of these objects were full of fine flour mixed with oil for a grain offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","He also gave one gold dish weighing ten shekels, full of incense. ");
INSERT INTO engULB_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","He gave as a burnt offering one young bull, one ram, and a one-year-old male lamb. ");
INSERT INTO engULB_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","He gave one male goat as a sin offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","He gave two oxen, five rams, five male goats, and five male lambs that were a year old, as the sacrifice for a fellowship offering. This was the sacrifice of Elizur son of Shedeur. ");
INSERT INTO engULB_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","On the fifth day, Shelumiel son of Zurishaddai, leader of the descendants of Simeon, offered his sacrifice. ");
INSERT INTO engULB_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","His sacrifice was one silver platter weighing 130 shekels and one silver bowl weighing seventy shekels, by the standard weight of the sanctuary shekel. Both of these objects were full of fine flour mixed with oil for a grain offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","He also gave one gold dish weighing ten shekels, full of incense. ");
INSERT INTO engULB_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","He gave as a burnt offering one young bull, one ram, and a one-year-old male lamb. ");
INSERT INTO engULB_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","He gave one male goat as a sin offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","He gave two oxen, five rams, five male goats, and five male lambs that were a year old, as the sacrifice for a fellowship offering. This was the sacrifice of Shelumiel son of Zurishaddai. ");
INSERT INTO engULB_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","On the sixth day, Eliasaph son of Deuel, leader of the descendants of Gad, offered his sacrifice. ");
INSERT INTO engULB_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","His sacrifice was one silver platter weighing 130 shekels and one silver bowl weighing seventy shekels, by the standard weight of the sanctuary shekel. Both of these objects were full of fine flour mixed with oil for a grain offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","He also gave one gold dish weighing ten shekels, full of incense. ");
INSERT INTO engULB_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","He gave as a burnt offering one young bull, one ram, and a one-year-old male lamb. ");
INSERT INTO engULB_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","He gave one male goat as a sin offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","He gave two oxen, five rams, five male goats, and five male lambs that were a year old, as the sacrifice for a fellowship offering. This was the sacrifice of Eliasaph son of Deuel. ");
INSERT INTO engULB_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","On the seventh day, Elishama son of Ammihud, leader of the descendants of Ephraim, offered his sacrifice. ");
INSERT INTO engULB_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","His sacrifice was one silver platter weighing 130 shekels and one silver bowl weighing seventy shekels, by the standard weight of the sanctuary shekel. Both of these objects were full of fine flour mixed with oil for a grain offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","He also gave one gold dish weighing ten shekels, full of incense. ");
INSERT INTO engULB_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","He gave as a burnt offering one young bull, one ram, and a one-year-old male lamb. ");
INSERT INTO engULB_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","He gave one male goat as a sin offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","He gave two oxen, five rams, five male goats, and five male lambs that were a year old, as the sacrifice for a fellowship offering. This was the sacrifice of Elishama son of Ammihud. ");
INSERT INTO engULB_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","On the eighth day, Gamaliel son of Pedahzur, leader of the descendants of Manasseh, offered his sacrifice. ");
INSERT INTO engULB_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","His sacrifice was one silver platter weighing 130 shekels and one silver bowl weighing seventy shekels, by the standard weight of the sanctuary shekel. Both of these objects were full of fine flour mixed with oil for a grain offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","He also gave one gold dish weighing ten shekels, full of incense. ");
INSERT INTO engULB_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","He gave as a burnt offering one young bull, one ram, and a one-year-old male lamb. ");
INSERT INTO engULB_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","He gave one male goat as a sin offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","He gave two oxen, five rams, five male goats, and five male lambs that were a year old, as the sacrifice for a fellowship offering. This was the sacrifice of Gamaliel son of Pedahzur. ");
INSERT INTO engULB_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","On the ninth day, Abidan son of Gideoni, leader of the descendants of Benjamin, offered his sacrifice. ");
INSERT INTO engULB_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","His sacrifice was one silver platter weighing 130 shekels and one silver bowl weighing seventy shekels, by the standard weight of the sanctuary shekel. Both of these objects were full of fine flour mingled with oil for a grain offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","He also gave one gold dish weighing ten shekels, full of incense. ");
INSERT INTO engULB_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","He gave as a burnt offering one young bull, one ram, and a one-year-old male lamb. ");
INSERT INTO engULB_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","He gave one male goat as a sin offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","He gave two oxen, five rams, five male goats, and five male lambs that were a year old, as the sacrifice for a fellowship offering. This was the sacrifice of Abidan son of Gideoni. ");
INSERT INTO engULB_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","On the tenth day, Ahiezer son of Ammishaddai, leader of the descendants of Dan, offered his sacrifice. ");
INSERT INTO engULB_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","His sacrifice was one silver platter weighing 130 shekels and one silver bowl weighing seventy shekels, by the standard weight of the sanctuary shekel. Both of these objects were full of fine flour mixed with oil for a grain offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","He also gave one gold dish weighing ten shekels, full of incense. ");
INSERT INTO engULB_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","He gave as a burnt offering one young bull, one ram, and a one-year-old male lamb.. ");
INSERT INTO engULB_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","He gave one male goat as a sin offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","He gave two oxen, five rams, five male goats, and five male lambs that were a year old, as the sacrifice for a fellowship offering. This was the sacrifice of Ahiezer son of Ammishaddai. ");
INSERT INTO engULB_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","On the eleventh day, Pagiel son of Okran, leader of the descendants of Asher, offered his sacrifice. ");
INSERT INTO engULB_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","His sacrifice was one silver platter weighing 130 shekels and one silver bowl weighing seventy shekels, by the standard weight of the sanctuary shekel. Both of these objects were full of fine flour mingled with oil for a grain offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","He also gave one gold dish weighing ten shekels, full of incense. ");
INSERT INTO engULB_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","He gave as a burnt offering one young bull, one ram, and a one-year-old male lamb. ");
INSERT INTO engULB_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","He gave one male goat as a sin offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","He gave two oxen, five rams, five male goats, and five male lambs that were a year old, as the sacrifice for a fellowship offering. This was the sacrifice of Pagiel son of Okran. ");
INSERT INTO engULB_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","On the twelfth day, Ahira son of Enan, leader of the descendants of Naphtali, offered his sacrifice. ");
INSERT INTO engULB_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","His sacrifice was one silver platter weighing 130 shekels and one silver bowl weighing seventy shekels, by the standard weight of the sanctuary shekel. Both of these objects were full of fine flour mixed with oil for a grain offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","He also gave one gold dish weighing ten shekels, full of incense. ");
INSERT INTO engULB_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","He gave as a burnt offering one young bull, one ram, and a one-year-old male lamb. ");
INSERT INTO engULB_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","He gave one male goat as a sin offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","He gave two oxen, five rams, five male goats, and five male lambs that were a year old, as the sacrifice for a fellowship offering. This was the sacrifice of Ahira son of Enan. ");
INSERT INTO engULB_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","The leaders of Israel set all these apart on the day that Moses anointed the altar. They set apart the twelve silver platters, twelve silver bowls, and twelve gold dishes. ");
INSERT INTO engULB_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Each silver platter weighed 130 shekels and each bowl weighed seventy shekels. All the silver vessels weighed 2,400 shekels, by the standard weight of the sanctuary shekel. ");
INSERT INTO engULB_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Each of the twelve gold dishes, full of incense, weighed ten shekels by the standard weight of the sanctuary shekel. All the gold dishes weighed 120 shekels. ");
INSERT INTO engULB_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","They set apart all the animals for the burnt offerings, twelve bulls, twelve rams, and twelve year-old male lambs. They gave their grain offering. They gave twelve male goats as a sin offering. ");
INSERT INTO engULB_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","From all their cattle, they gave twenty-four bulls, sixty rams, sixty male goats, and sixty male lambs a year old, as the sacrifice for the fellowship offering. This was for the dedication of the altar after it was anointed. ");
INSERT INTO engULB_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","When Moses went into the tent of meeting to speak with Yahweh, he heard his voice speaking to him. Yahweh spoke to him from above the atonement lid on the ark of the testimony, from between the two cherubim. He spoke to him. ");
INSERT INTO engULB_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Yahweh spoke to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Speak to Aaron. Say to him, 'The seven lamps must give light in front of the lampstand when you light them.'” ");
INSERT INTO engULB_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aaron did this. He lit the lamps on the lampstand to give light toward the front of it, as Yahweh had commanded Moses. ");
INSERT INTO engULB_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","The lampstand was made in this way and Yahweh showed Moses the pattern for it. It was to be hammered gold from its base to its top, with hammered cups like blossoms. ");
INSERT INTO engULB_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Again, Yahweh spoke to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Take the Levites from among the people of Israel and purify them. ");
INSERT INTO engULB_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Do this to them to purify them: Sprinkle the water of atonement on them. Make them shave their entire body, wash their clothes, and in this way purify themselves. ");
INSERT INTO engULB_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Then have them take a young bull and its grain offering of fine flour mingled with oil. Let them take another young bull as a sin offering. ");
INSERT INTO engULB_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","You will bring the Levites in front of the tent of meeting and assemble the whole community of the people of Israel. ");
INSERT INTO engULB_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","When you bring the Levites before Yahweh, the people of Israel must lay their hands on the Levites. ");
INSERT INTO engULB_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aaron must offer the Levites before Yahweh, as a wave offering from the people of Israel so that they may do the service of Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","The Levites must place their hands on the heads of the bulls. You must offer one bull for a sin offering and the other bull for a burnt offering to me, to atone for the Levites. ");
INSERT INTO engULB_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Present the Levites before Aaron and before his sons, and lift them up as a wave offering to me. ");
INSERT INTO engULB_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","In this way you must separate the Levites from among the people of Israel. The Levites will belong to me. ");
INSERT INTO engULB_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","After that, the Levites must go in to serve in the tent of meeting. You must purify them. You must offer them as a wave offering. ");
INSERT INTO engULB_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Do this, because they are entirely mine from among the people of Israel. They will take the place of each male child who opens the womb, the firstborn of all the descendants of Israel. I have taken the Levites for myself. ");
INSERT INTO engULB_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","All the firstborn from among the people of Israel are mine, both of people and of animals. On the day that I took the lives of all the firstborn in the land of Egypt, I set them apart for myself. ");
INSERT INTO engULB_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","I have taken the Levites from among the people of Israel instead of all the firstborn. ");
INSERT INTO engULB_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","I have given the Levites as a gift to Aaron and his sons. I have taken them from among the people of Israel to do the work of the people of Israel in the tent of meeting. I have given them to atone for the people of Israel so that no plague will harm the people when they come near to the holy place.” ");
INSERT INTO engULB_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Moses, Aaron, and the whole community of the people of Israel did this with the Levites. They did everything that Yahweh had commanded Moses concerning the Levites. The people of Israel did this with them. ");
INSERT INTO engULB_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","The Levites purified themselves and washed their clothing, and Aaron presented them as a wave offering to Yahweh and he made atonement for them to cleanse them. ");
INSERT INTO engULB_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","After that, the Levites went in to do their service in the tent of meeting before Aaron and before Aaron's sons. This was as Yahweh had commanded Moses about the Levites. They treated all the Levites in this way. ");
INSERT INTO engULB_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Yahweh spoke again to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“All of this is for the Levites who are twenty-five years old and more. They must join the company to serve in the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","They must stop serving in this way at the age of fifty years. At that age they must not serve any longer. ");
INSERT INTO engULB_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","They may help their brothers who continue to work at the tent of meeting, but they must serve no more. You must direct the Levites in all these matters.” ");
INSERT INTO engULB_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Yahweh spoke to Moses in the wilderness of Sinai, in the first month of the second year after they came out from the land of Egypt. He said, ");
INSERT INTO engULB_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Let the people of Israel keep the Passover at its fixed time of year. ");
INSERT INTO engULB_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","On the fourteenth day of this month, at evening, you must keep the Passover at its fixed time of year. You must keep it, follow all the regulations, and obey all the decrees that are related to it.” ");
INSERT INTO engULB_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","So, Moses told the people of Israel that they should keep the Festival of the Passover. ");
INSERT INTO engULB_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","So they kept the Passover in the first month, on the fourteenth day of the month, at evening, in the wilderness of Sinai. The people of Israel obeyed everything that Yahweh commanded Moses to do. ");
INSERT INTO engULB_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","There were certain men who became unclean by the body of a dead man. They could not keep the Passover on that day. They went before Moses and Aaron on that same day. ");
INSERT INTO engULB_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Those men said to Moses, “We are unclean because of the dead body of a man. Why do you keep us from offering the sacrifice to Yahweh at the fixed time of year among the people of Israel?” ");
INSERT INTO engULB_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moses said to them, “Wait for me to hear what Yahweh will instruct about you.” ");
INSERT INTO engULB_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Yahweh spoke to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Speak to the people of Israel. Say, 'If any of you or your descendants are unclean because of a dead body, or are on a long journey, he may still keep the Passover to Yahweh.' ");
INSERT INTO engULB_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","In the second month on the fourteenth day at evening, they will eat the Passover meal. They must eat the Passover lamb with bread that is made without yeast and with bitter herbs. ");
INSERT INTO engULB_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","They must not leave any of it until the morning, or break any of its bones. They must follow all the regulations for the Passover. ");
INSERT INTO engULB_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","But any person who is clean and is not on a journey, but who fails to keep the Passover, that person must be cut off from his people because he did not offer the sacrifice that Yahweh requires at the fixed time of year. That man must carry his sin. ");
INSERT INTO engULB_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","If a stranger lives among you and keeps the Passover in Yahweh's honor, he must keep it and do all he commands, keeping the rules of the Passover, and obeying the laws for it. You must have the same law for the foreigner and for all who have been born in the land.” ");
INSERT INTO engULB_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","On the day that the tabernacle was set up, the cloud covered the tabernacle, the tent of the covenant decrees. At evening the cloud was over the tabernacle. It appeared like fire until morning. ");
INSERT INTO engULB_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","It continued that way. The cloud covered the tabernacle and appeared like fire at night. ");
INSERT INTO engULB_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Whenever the cloud was taken up from over the tent, the people of Israel would set out on their journey. Wherever the cloud stopped, the people would camp. ");
INSERT INTO engULB_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","At Yahweh's command, the people of Israel would travel, and at his command, they would camp. While the cloud stopped over the tabernacle, they would stay in their camp. ");
INSERT INTO engULB_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","When the cloud remained on the tabernacle for many days, then the people of Israel would obey Yahweh's instructions and not travel. ");
INSERT INTO engULB_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Sometimes the cloud remained a few days on the tabernacle. In that case, they would obey Yahweh's command—they would make camp and then travel on again at his command. ");
INSERT INTO engULB_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Sometimes the cloud was present in camp from evening until morning. When the cloud lifted in the morning, they journeyed. If it continued for a day and for a night, only when the cloud lifted would they journey on. ");
INSERT INTO engULB_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Whether the cloud stayed on the tabernacle for two days, a month, or a year, for as long as it stayed there, the people of Israel would stay in their camp and not travel. But whenever the cloud was taken up, they would set out on their journey. ");
INSERT INTO engULB_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","They would camp at Yahweh's command, and they would travel at his command. They obeyed Yahweh's command given through Moses. ");
INSERT INTO engULB_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Yahweh spoke to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Make two silver trumpets. Hammer the silver to make them. You must use the trumpets to call the community together and to call the community to move their camps. ");
INSERT INTO engULB_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","The priests must blow the trumpets to call all the community together in front of you at the entrance to the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","If the priests blow only one trumpet, then the leaders, the heads of the clans of Israel, must gather to you. ");
INSERT INTO engULB_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","When you blow a loud signal, the camps on the east side must begin their journey. ");
INSERT INTO engULB_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","When you blow a loud signal the second time, the camps on the south side must begin their journey. They must blow a loud signal for their journeys. ");
INSERT INTO engULB_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","When the community gathers together, blow the trumpets, but not loudly. ");
INSERT INTO engULB_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","The sons of Aaron, the priests, must blow the trumpets. This will always be a regulation for you throughout your people's generations. ");
INSERT INTO engULB_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","When you go to war in your land against an adversary who oppresses you, then you must sound an alarm with the trumpets. I, Yahweh your God, will call you to mind and save you from your enemies. ");
INSERT INTO engULB_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Also, at the times of celebration, both your regular festivals and at the beginnings of the months, you must blow the trumpets over your burnt offerings and over the sacrifices for your fellowship offerings. These will act as a reminder of you to me, your God. I am Yahweh your God.” ");
INSERT INTO engULB_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","In the second year, in the second month, on the twentieth day of the month, the cloud was lifted from the tabernacle of the covenant decrees. ");
INSERT INTO engULB_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","The people of Israel then went on their journey from the wilderness of Sinai. The cloud stopped in the wilderness of Paran. ");
INSERT INTO engULB_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","They made their first journey, following Yahweh's command given through Moses. ");
INSERT INTO engULB_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","The camp under the banner of Judah's descendants went out first, moving out their individual armies. Nahshon son of Amminadab led Judah's army. ");
INSERT INTO engULB_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nethanel son of Zuar led the army of the tribe of Issachar's descendants. ");
INSERT INTO engULB_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eliab son of Helon led the army of the tribe of Zebulun's descendants. ");
INSERT INTO engULB_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","The descendants of Gershon and of Merari, who cared for the tabernacle, took down the tabernacle and then set out on their journey. ");
INSERT INTO engULB_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Next, the armies under the banner of Reuben's camp set out on their journey. Elizur son of Shedeur led Reuben's army. ");
INSERT INTO engULB_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shelumiel son of Zurishaddai led the army of the tribe of Simeon's descendants. ");
INSERT INTO engULB_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Eliasaph son of Deuel led the army of the tribe of Gad's descendants. ");
INSERT INTO engULB_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","The Kohathites set out. They carried the sanctuary's holy equipment. Others would set up the tabernacle before the Kohathites arrived at the next camp. ");
INSERT INTO engULB_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","The armies under the banner of Ephraim's descendants set out next. Elishama son of Ammihud led Ephraim's army. ");
INSERT INTO engULB_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamaliel son of Pedahzur led the army of the tribe of Manasseh's descendants. ");
INSERT INTO engULB_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Abidan son of Gideoni led the army of the tribe of Benjamin's descendants. ");
INSERT INTO engULB_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","The armies that camped under the banner of Dan's descendants set out last. Ahiezer son of Ammishaddai led Dan's army. ");
INSERT INTO engULB_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagiel son of Okran led the army of the tribe of Asher's descendants. ");
INSERT INTO engULB_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ahira son of Enan led the army of the tribe of Naphtali's descendants. ");
INSERT INTO engULB_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","This is the way that the armies of the people of Israel set out on their journey. ");
INSERT INTO engULB_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Moses spoke to Hobab son of Reuel the Midianite. Reuel was the father of Moses' wife. Moses spoke to Hobab and said, “We are traveling to a place that Yahweh described. Yahweh said, 'I will give it to you.' Come with us and we will do you good. Yahweh has promised to do good for Israel.” ");
INSERT INTO engULB_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","But Hobab said to Moses, “I will not go with you. I will go to my own land and my own people.” ");
INSERT INTO engULB_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Then Moses replied, “Please do not leave us. You know how to camp in the wilderness. You must watch out for us. ");
INSERT INTO engULB_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","If you go with us, we will do for you the same good that Yahweh does to us.” ");
INSERT INTO engULB_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","They journeyed from the mountain of Yahweh for three days. The ark of the covenant of Yahweh went before them for three days to find a place for them to rest. ");
INSERT INTO engULB_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Yahweh's cloud was over them by daylight as they journeyed. ");
INSERT INTO engULB_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Whenever the ark set out, Moses would say, “Rise up, Yahweh. Scatter your enemies. Make those who hate you run from you.” ");
INSERT INTO engULB_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Whenever the ark stopped, Moses would say, “Return, Yahweh, to Israel's many tens of thousands.” ");
INSERT INTO engULB_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Now the people complained about their troubles as Yahweh listened. Yahweh heard the people and became angry. Fire from Yahweh burned among them and consumed some of the camp on its edges. ");
INSERT INTO engULB_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Then people called out to Moses, so Moses prayed to Yahweh, and the fire stopped. ");
INSERT INTO engULB_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","That place was named Taberah, because Yahweh's fire burned among them. ");
INSERT INTO engULB_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Some foreign people began to camp with Israel's descendants. They wanted better food to eat. Then the people of Israel began to weep and say, “Who will give us meat to eat? ");
INSERT INTO engULB_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","We remember the fish that we ate freely in Egypt, the cucumbers, the melons, the leeks, the onions, and the garlic. ");
INSERT INTO engULB_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Now our appetite is gone, because all we can see is this manna.” ");
INSERT INTO engULB_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manna was like coriander seed. It looked like resin. ");
INSERT INTO engULB_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","The people walked around and gathered it. They ground it in mills, beat it in mortars, boiled it in pots, and made it into cakes. It tasted like fresh olive oil. ");
INSERT INTO engULB_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","When the dew fell on the camp in the night, the manna also fell. ");
INSERT INTO engULB_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moses heard the people weeping in their families, and every man was at the entrance to his tent. Yahweh was very angry, and in Moses' eyes their complaining was wrong. ");
INSERT INTO engULB_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Moses said to Yahweh, “Why have you treated your servant so badly? Why are you not pleased with me? You make me carry the load of all these people. ");
INSERT INTO engULB_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Did I conceive all these people? Have I given them birth so that you should say to me, 'Carry them closely to your chest as a father carries a baby?' Should I carry them to the land that you swore to their ancestors to give them? ");
INSERT INTO engULB_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Where can I find meat to give to all this people? They are weeping in front of me and are saying, 'Give us meat to eat.' ");
INSERT INTO engULB_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","I cannot bear all these people alone. They are too much for me. ");
INSERT INTO engULB_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Since you are treating me this way, kill me now—if I find favor in your eyes—do not let me see my misery.” ");
INSERT INTO engULB_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Yahweh said to Moses, “Bring to me seventy of Israel's elders. Be sure that they are elders and officers of the people. Bring them to the tent of meeting to stand there with you. ");
INSERT INTO engULB_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","I will come down and talk with you there. I will take some of the Spirit that is on you and put it on them. They will bear the burden of the people with you. You will not have to bear it alone. ");
INSERT INTO engULB_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Say to the people, 'Consecrate yourselves, for tomorrow and you will indeed eat meat, for you have wept and Yahweh has heard. You said, “Who will give us meat to eat? It was good for us in Egypt.” Therefore Yahweh will give you meat, and you will eat it. ");
INSERT INTO engULB_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","You will not eat meat for only one day, two days, five days, ten days, or twenty days, ");
INSERT INTO engULB_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","but you will eat meat for a whole month until it comes out of your nostrils. It will disgust you because you have rejected Yahweh, who is among you. You have wept before him. You said, “Why did we leave Egypt?”'” ");
INSERT INTO engULB_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Then Moses said, “I am with 600,000 people, and you have said, 'I will give them meat to eat for a whole month.' ");
INSERT INTO engULB_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Should we kill flocks and herds to satisfy them? Should we catch all the fish in the sea to satisfy them?” ");
INSERT INTO engULB_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Yahweh said to Moses, “Is my hand short? Now you will see whether or not my word is true.” ");
INSERT INTO engULB_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Moses went out and told the people Yahweh's words. He gathered seventy of the people's elders and positioned them around the tent. ");
INSERT INTO engULB_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Yahweh came down in the cloud and spoke to Moses. Yahweh took some of the Spirit that was on Moses and put it on the seventy elders. When the Spirit rested on them, they prophesied, but only on that occasion and not again. ");
INSERT INTO engULB_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Two men remained in the camp, named Eldad and Medad. The Spirit also rested on them. Their names were written on the list, but they had not gone out to the tent. Nevertheless, they prophesied in the camp. ");
INSERT INTO engULB_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","A young man in the camp ran and told Moses, “Eldad and Medad are prophesying in the camp.” ");
INSERT INTO engULB_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Joshua son of Nun, Moses' assistant, one of his chosen men, said to Moses, “My master Moses, stop them.” ");
INSERT INTO engULB_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Moses said to him, “Are you jealous for my sake? I wish that all of Yahweh's people were prophets and that he would put his Spirit on them all!” ");
INSERT INTO engULB_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Then Moses and the elders of Israel went back to the camp. ");
INSERT INTO engULB_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Then a wind came from Yahweh and brought quail from the sea. They fell near the camp, about a day's journey on one side and a day's journey on the other side. The quail surrounded the camp about two cubits above the ground. ");
INSERT INTO engULB_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","The people were busy gathering quail all that day, all the night, and all the next day. No one gathered less than ten homers of quail. They shared the quail all through the camp. ");
INSERT INTO engULB_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","While the meat was still between their teeth, while they were chewing it, Yahweh became angry at them. He attacked the people with a very great disease. ");
INSERT INTO engULB_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","That place was named Kibroth Hattaavah, because there they buried the people who had craved meat. ");
INSERT INTO engULB_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","From Kibroth Hattaavah the people traveled to Hazeroth, where they stayed. ");
INSERT INTO engULB_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Then Miriam and Aaron spoke against Moses because of the Cushite woman whom he had married. ");
INSERT INTO engULB_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","They said, “Has Yahweh spoken only with Moses? Has he not spoken also with us?” Now Yahweh heard what they said. ");
INSERT INTO engULB_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Now the man Moses was very humble, humbler than anyone else on earth. ");
INSERT INTO engULB_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Right away Yahweh spoke to Moses, Aaron, and Miriam: “Come out, you three, to the tent of meeting.” So the three of them went out. ");
INSERT INTO engULB_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Then Yahweh came down in a pillar of cloud. He stood at the entrance to the tent and called Aaron and Miriam. They both came forward. ");
INSERT INTO engULB_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Yahweh said, “Now listen to my words. When a prophet of mine is with you, I will reveal myself to him in visions and speak to him in dreams. ");
INSERT INTO engULB_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","My servant Moses is not like that. He is faithful in all my house. ");
INSERT INTO engULB_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","I speak to Moses directly, not with visions or riddles. He sees my form. So why are you unafraid to speak against my servant, against Moses?” ");
INSERT INTO engULB_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Yahweh's anger burned against them, and then he left them. ");
INSERT INTO engULB_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","The cloud rose from over the tent, and Miriam was suddenly leprous—she was as white as snow. When Aaron turned toward Miriam, he saw that she had leprosy. ");
INSERT INTO engULB_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Aaron said to Moses, “Oh, my master, please do not hold this sin against us. We have spoken foolishly, and we have sinned. ");
INSERT INTO engULB_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Please do not let her be like a dead newborn whose flesh is half consumed when it emerges from its mother's womb.” ");
INSERT INTO engULB_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","So Moses called out to Yahweh. He said, “Please heal her, God, please.” ");
INSERT INTO engULB_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Yahweh said to Moses, “If her father had spit in her face, she would be disgraced for seven days. Shut her outside the camp for seven days. After that bring her in again.” ");
INSERT INTO engULB_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","So Miriam was shut outside the camp for seven days. The people did not journey until she had returned to the camp. ");
INSERT INTO engULB_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","After that, the people journeyed from Hazeroth and camped in the wilderness of Paran. ");
INSERT INTO engULB_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Then Yahweh spoke to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Send some men to examine the land of Canaan, which I have given to the people of Israel. Send a man from every tribe of their ancestors. Each man must be a leader among them.” ");
INSERT INTO engULB_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Moses sent them from the wilderness of Paran, so that they might obey Yahweh's command. All of them were leaders among the people of Israel. ");
INSERT INTO engULB_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","These were their names: from the tribe of Reuben, Shammua son of Zaccur; ");
INSERT INTO engULB_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","from the tribe of Simeon, Shaphat son of Hori; ");
INSERT INTO engULB_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","from the tribe of Judah, Caleb son of Jephunneh; ");
INSERT INTO engULB_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","from the tribe of Issachar, Igal son of Joseph; ");
INSERT INTO engULB_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","from the tribe of Ephraim, Hoshea son of Nun; ");
INSERT INTO engULB_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","from the tribe of Benjamin, Palti son of Raphu; ");
INSERT INTO engULB_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","from the tribe of Zebulun, Gaddiel son of Sodi; ");
INSERT INTO engULB_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","from the tribe of Joseph (that is to say, from the tribe Manasseh), Gaddi son of Susi; ");
INSERT INTO engULB_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","from the tribe of Dan, Ammiel son of Gemalli; ");
INSERT INTO engULB_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","from the tribe of Asher, Sethur son of Michael; ");
INSERT INTO engULB_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","from the tribe of Naphtali, Nahbi son of Vophsi; ");
INSERT INTO engULB_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","from the tribe of Gad, Geuel son of Maki. ");
INSERT INTO engULB_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","These were the names of the men whom Moses sent to examine the land. Moses called Hoshea son of Nun by the name of Joshua. ");
INSERT INTO engULB_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moses sent them to examine the land of Canaan. He said to them, “Approach from the Negev and go up into the hill country. ");
INSERT INTO engULB_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Examine the land to see what it is like. Observe the people who live there, whether they are strong or weak, and whether they are few or many. ");
INSERT INTO engULB_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","See what the land is like where they live. Is it good or bad? What cities are there? Are they like camps, or are they fortified cities? ");
INSERT INTO engULB_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","See what the land is like, whether it is good for growing crops or not, and whether there are trees there or not. Be brave and bring back samples of the land's produce.” Now the time was the season for the first ripe grapes. ");
INSERT INTO engULB_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","So the men went up and examined the land from the wilderness of Zin to Rehob, near Lebo Hamath. ");
INSERT INTO engULB_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","They went up from the Negev and arrived at Hebron. Ahiman, Sheshai, and Talmai, clans descended from Anak, were there. Now Hebron had been built seven years before Zoan in Egypt. ");
INSERT INTO engULB_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","When they reached the Valley of Eshkol, they cut down a branch with a cluster of grapes. They carried it on a staff between two of their group. They also brought pomegranates and figs. ");
INSERT INTO engULB_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","That place was named the Valley of Eshkol, because of the grape cluster that the people of Israel cut down there. ");
INSERT INTO engULB_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","After forty days, they returned from examining the land. ");
INSERT INTO engULB_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","They came back to Moses, Aaron, and all the community of the people of Israel in the wilderness of Paran, at Kadesh. They brought back word to them and to all the community, and showed them the produce from the land. ");
INSERT INTO engULB_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","They told Moses, “We reached the land to which you sent us. It certainly flows with milk and honey. Here is some produce from it. ");
INSERT INTO engULB_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","However, the people who make their homes there are strong. The cities are fortified and very large. We also saw descendants of Anak there. ");
INSERT INTO engULB_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","The Amalekites live in the Negev. The Hittites, Jebusites, and Amorites have their homes in the hill country. The Canaanites live by the sea and along the Jordan River.” ");
INSERT INTO engULB_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Then Caleb silenced the people who were before Moses and said, “Let us go up and take possession of the land, for we are certainly able to conquer it.” ");
INSERT INTO engULB_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","But the other men who had gone with him said, “We are not able to attack the people because they are stronger than we are.” ");
INSERT INTO engULB_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","So they spread around a discouraging report to the people of Israel about the land that they had examined. They said, “The land that we looked at is a land that eats up its inhabitants. All the people whom we saw there are people of great height. ");
INSERT INTO engULB_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","There we saw giants, descendants of Anak, people who came from giants. In our own sight we were like grasshoppers in comparison with them, and this is what we were in their sight, too.” ");
INSERT INTO engULB_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","That night all the community wept loudly. ");
INSERT INTO engULB_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","All the people of Israel criticized Moses and Aaron. The whole community said to them, “We wish we had died in the land of Egypt, or here in this wilderness! ");
INSERT INTO engULB_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Why did Yahweh bring us to this land to die by the sword? Our wives and our little ones will become victims. Is it not better for us to return to Egypt?” ");
INSERT INTO engULB_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","They said to each another, “Let us choose another leader, and let us return to Egypt.” ");
INSERT INTO engULB_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Then Moses and Aaron lay facedown before all the assembly of the community of the people of Israel. ");
INSERT INTO engULB_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Joshua son of Nun and Caleb son of Jephunneh, who were some of those sent to examine the land, tore their clothes. ");
INSERT INTO engULB_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","They spoke to all the community of the people of Israel. They said, “The land that we passed through and examined is a very good land. ");
INSERT INTO engULB_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","If Yahweh is pleased with us, then he will take us into this land and give it to us. The land flows with milk and honey. ");
INSERT INTO engULB_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","But do not rebel against Yahweh, and do not fear the people in the land, for they are bread to us. Their protection will be removed from them, because Yahweh is with us. Do not fear them.” ");
INSERT INTO engULB_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Then all the congregation said to stone them with stones. But the glory of Yahweh appeared at the tent of meeting to all the people of Israel. ");
INSERT INTO engULB_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Yahweh said to Moses, “How long must this people despise me? How long must they fail to trust me, despite all the signs of my power that I have done among them? ");
INSERT INTO engULB_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","I will attack them with plague, disinherit them, and make from your own clan a nation that will be greater and mightier than they are.” ");
INSERT INTO engULB_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Moses said to Yahweh, “If you do this, then the Egyptians will hear about it, because you rescued this people from them by your power. ");
INSERT INTO engULB_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","They will tell it to this land's inhabitants. They have heard that you, Yahweh, are present with this people, because you are seen face to face. Your cloud stands over our people. You go before them in a pillar of cloud by day and in a pillar of fire by night. ");
INSERT INTO engULB_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Now if you kill this people as one man, then the nations that have heard of your fame will speak and say, ");
INSERT INTO engULB_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","'Because Yahweh could not take this people into the land that he swore to give them, he has killed them in the wilderness.' ");
INSERT INTO engULB_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Now, I beg you, use your great power. For you have said, ");
INSERT INTO engULB_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","'Yahweh is slow to anger and abundant in covenant faithfulness. He forgives iniquity and transgression. He will by no means clear the guilty when he brings the punishment of the ancestors' sin on their descendants, to the third and fourth generation.' ");
INSERT INTO engULB_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Pardon, I plead with you, this people's sin because of the greatness of your covenant faithfulness, just as you have always forgiven this people from the time they were in Egypt until now.” ");
INSERT INTO engULB_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Yahweh said, “I have pardoned them in keeping with your request, ");
INSERT INTO engULB_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","but truly, as I live, and as all the earth will be filled with my glory, ");
INSERT INTO engULB_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","all those people who saw my glory and the signs of power that I did in Egypt and in the wilderness—they have still tempted me these ten times and have not listened to my voice. ");
INSERT INTO engULB_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","So I say that they will certainly not see the land about which I made an oath to their ancestors. Not one of them who despised me will see it, ");
INSERT INTO engULB_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","except for my servant Caleb, because he had another spirit. He has followed me fully; I will bring him into the land which he went to examine. His descendants will possess it. ");
INSERT INTO engULB_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","(Now the Amalekites and Canaanites lived in the valley.) Tomorrow turn and go to the wilderness by the way of the Sea of Reeds.” ");
INSERT INTO engULB_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Yahweh spoke to Moses and to Aaron. He said, ");
INSERT INTO engULB_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“How long must I tolerate this evil community that criticizes me? I have heard the complaining of the people of Israel against me. ");
INSERT INTO engULB_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Say to them, 'As I live,' says Yahweh, 'as you have spoken in my hearing, I will do this to you: ");
INSERT INTO engULB_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Your dead bodies will fall in this wilderness, all you who complained against me, you who were counted in the census, the whole number of the people from twenty years old and upward. ");
INSERT INTO engULB_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","You will certainly not go into the land that I promised to make your home, except Caleb son of Jephunneh and Joshua son of Nun. ");
INSERT INTO engULB_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","But your little ones who you said would be victims, I will take them into the land. They will experience the land that you have rejected! ");
INSERT INTO engULB_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","As for you, your dead bodies will fall in this wilderness. ");
INSERT INTO engULB_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Your children will be shepherds in the wilderness for forty years. They must bear the consequences of your acts of rebellion until the end of your corpses in the wilderness. ");
INSERT INTO engULB_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Just as the number of the days during which you examined the land—forty days, you must likewise bear the consequences of your sins for forty years—one year for every day, and you must know what it is like for me to oppose you. ");
INSERT INTO engULB_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","I, Yahweh, have spoken. I will certainly do this to all this evil community that is gathered together against me. They will be completely cut off, and here they will die.'” ");
INSERT INTO engULB_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","So the men Moses sent to spy out the land, who returned and made the entire community grumble against Moses by spreading a bad report about the land— ");
INSERT INTO engULB_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","these men who had brought out a bad report about the land were struck down, and they died of a plague before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Of those men who had gone to spy out the land, only Joshua son of Nun and Caleb son of Jephunneh remained alive. ");
INSERT INTO engULB_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","When Moses reported these words to all the people of Israel, they mourned very deeply. ");
INSERT INTO engULB_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","They rose up early in the morning and went to the top of the mountain and said, “Look, we are here, and we will go to the place that Yahweh has promised, for we have sinned.” ");
INSERT INTO engULB_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","But Moses said, “Why are you now violating Yahweh's command? You will not succeed. ");
INSERT INTO engULB_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Do not go, because Yahweh is not with you to prevent you from being defeated by your enemies. ");
INSERT INTO engULB_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","The Amalekites and Canaanites are there, and you will die by the sword because you turned back from following Yahweh. So he will not be with you.” ");
INSERT INTO engULB_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","But they presumed to go up into the hill country; however, neither Moses nor the ark of the covenant of Yahweh left the camp. ");
INSERT INTO engULB_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Then the Amalekites came down, and also the Canaanites who lived on those hills. They attacked the Israelites and defeated them all the way to Hormah. ");
INSERT INTO engULB_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Then Yahweh spoke to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Speak to the people of Israel and say to them, 'When you go into the land where you will live, which Yahweh will give to you, ");
INSERT INTO engULB_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","you are to prepare an offering by fire to Yahweh, either a burnt offering or a sacrifice to fulfill a vow or a freewill offering, or an offering at your feasts, to produce a pleasing aroma for Yahweh from the herd or the flock. ");
INSERT INTO engULB_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","You must offer to Yahweh a burnt offering as well as a grain offering of a tenth of an ephah of fine flour mixed with one-fourth of a hin of oil. ");
INSERT INTO engULB_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","You must also offer with the burnt offering, or for the sacrifice, one-fourth of a hin of wine for the drink offering for each lamb. ");
INSERT INTO engULB_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","If you are offering a ram, you must prepare as a grain offering two-tenths of an ephah of fine flour mixed with a third of a hin of oil. ");
INSERT INTO engULB_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","For the drink offering, you must offer a third of a hin of wine. It will produce a sweet aroma for Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","When you prepare a bull as a burnt offering or as a sacrifice to fulfill a vow, or as a fellowship offering to Yahweh, ");
INSERT INTO engULB_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","then you must offer with the bull a grain offering of three-tenths of an ephah of fine flour mixed with half a hin of oil. ");
INSERT INTO engULB_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","You must offer as the drink offering half a hin of wine, as an offering made by fire, to produce a sweet aroma for Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","It must be done this way for each bull, for each ram, and for each of the male lambs or young goats. ");
INSERT INTO engULB_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Every sacrifice that you prepare and offer must be done as described here. ");
INSERT INTO engULB_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","All who are native-born Israelites must do these things in this way, when anyone brings an offering made by fire, to produce an aroma that is pleasing to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","If a foreigner is staying with you, or whoever may live among you throughout your people's generations, he must make an offering made by fire, to produce a sweet aroma for Yahweh. He must act as you act. ");
INSERT INTO engULB_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","There must be the same law for the community and for the foreigner who stays with you, a permanent law throughout your people's generations. As you are, so also must be the traveler staying with you. He must act as you act before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","The same law and decree must apply to you and to the foreigner who is staying with you.'” ");
INSERT INTO engULB_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Again Yahweh spoke to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Speak to the people of Israel and say to them, 'When you come into the land where I will take you, ");
INSERT INTO engULB_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","when you eat the food produced in the land, you must offer an offering and present it to me. ");
INSERT INTO engULB_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","From the first of your dough you must offer a loaf to raise it up as a raised offering from the threshing floor. You must raise it up in this way. ");
INSERT INTO engULB_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","You must give to me a raised offering throughout your people's generations from the first of your dough. ");
INSERT INTO engULB_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","You will sometimes sin without intending to do so, when you do not obey all these commands that I have spoken to Moses— ");
INSERT INTO engULB_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","everything that I have commanded you through Moses from the day that I began to give you commands and onward throughout your people's generations. ");
INSERT INTO engULB_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","In the case of unintentional sin without the community's knowledge, then all the community must offer one young bull as a burnt offering to produce a sweet aroma for Yahweh. Along with this must be made a grain offering and drink offering, as commanded by the decree, and one male goat as a sin offering. ");
INSERT INTO engULB_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","The priest must make atonement for all the community of the people of Israel. They will be forgiven because the sin was an error. They have brought their sacrifice, an offering made by fire to me. They have brought their sin offering before me for their error. ");
INSERT INTO engULB_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Then all the community of the people of Israel will be forgiven, and also the foreigners who are staying with them, because all the people committed the sin unintentionally. ");
INSERT INTO engULB_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","If a person sins unintentionally, then he must offer a female goat a year old as a sin offering. ");
INSERT INTO engULB_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","The priest must make atonement before Yahweh for the person who sins unintentionally. That person will be forgiven when atonement has been made. ");
INSERT INTO engULB_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","You must have the same law for the one who does anything unintentionally, the same law for the one who is native born among the people of Israel and for the foreigners who are staying among them. ");
INSERT INTO engULB_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","But the person who does anything in defiance, whether he is native born or a foreigner, blasphemes me. That person must be cut off from among his people. ");
INSERT INTO engULB_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Because he has despised my word and has broken my commandment, that person must be cut off completely. His sin will be on him.'” ");
INSERT INTO engULB_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","While the people of Israel were in the wilderness, they found a man gathering wood on the Sabbath day. ");
INSERT INTO engULB_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Those who found him brought him to Moses, Aaron, and all the community. ");
INSERT INTO engULB_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","They kept him in custody because it had not been declared what should be done with him. ");
INSERT INTO engULB_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Then Yahweh said to Moses, “The man must surely be put to death. All the community must stone him with stones outside the camp.” ");
INSERT INTO engULB_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","So all the community brought him outside the camp and stoned him to death as Yahweh had commanded Moses. ");
INSERT INTO engULB_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Again Yahweh spoke to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Speak to the descendants of Israel and command them to make for themselves tassels to hang from the borders of their garments, to hang them from each border by a blue cord. They must do this throughout their people's generations. ");
INSERT INTO engULB_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","It will be a special reminder to you, when you may look at it, of all my commandments, to carry them out so that you do not look to your own heart and your own eyes and prostitute yourselves to them. ");
INSERT INTO engULB_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Do this so that you may call to mind and obey all my commandments, and so that you may be holy, reserved for me, your God. ");
INSERT INTO engULB_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","I am Yahweh your God, who brought you out of the land of Egypt, to become your God. I am Yahweh your God.” ");
INSERT INTO engULB_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Now Korah son of Izhar son of Kohath son of Levi, along with Dathan and Abiram sons of Eliab, and On son of Peleth, descendants of Reuben, gathered some men. ");
INSERT INTO engULB_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","They rose up against Moses, along with other men from the people of Israel, two hundred and fifty leaders of the community who were well-known members in the community. ");
INSERT INTO engULB_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","They assembled themselves together to confront Moses and Aaron. They said to them, “You have gone too far! All the community is set apart, every one of them, and Yahweh is among them. Why do you lift up yourselves above the rest of Yahweh's community?” ");
INSERT INTO engULB_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","When Moses heard that, he lay facedown. ");
INSERT INTO engULB_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","He spoke to Korah and to all those with him, “In the morning Yahweh will make known who belongs to him and who is set apart to him. He will bring that person near to him. The one he chooses he will bring near to himself. ");
INSERT INTO engULB_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Do this, Korah and all your group. Take censers ");
INSERT INTO engULB_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","tomorrow and put fire and incense in them before Yahweh. The one whom Yahweh chooses, that man will be set apart to Yahweh. You have gone too far, you descendants of Levi.” ");
INSERT INTO engULB_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Again, Moses said to Korah, “Now listen, you descendants of Levi: ");
INSERT INTO engULB_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","is it a small thing for you that the God of Israel has separated you from the community of Israel, to bring you near to himself, to do work in Yahweh's tabernacle, and to stand before the community to serve them? ");
INSERT INTO engULB_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","He has brought you near, and all your kinfolk, the descendants of Levi, with you, yet you are seeking the priesthood also! ");
INSERT INTO engULB_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","That is why you and all your group have gathered together against Yahweh. So why are you complaining about Aaron, who obeys Yahweh?” ");
INSERT INTO engULB_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Then Moses called for Dathan and Abiram, the sons of Eliab, but they said, “We will not come up. ");
INSERT INTO engULB_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Is it a small thing that you have brought us up out of a land flowing with milk and honey, to kill us in the wilderness? Now you want to make yourself ruler over us! ");
INSERT INTO engULB_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","In addition, you have not brought us into a land flowing with milk and honey, or given us the fields and vineyards as an inheritance. Now do you want to blind us with empty promises? We will not come to you.” ");
INSERT INTO engULB_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Moses was very angry and said to Yahweh, “Do not respect their offering. I have not taken one donkey from them, and I have not harmed any of them.” ");
INSERT INTO engULB_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Then Moses said to Korah, “Tomorrow you and all your company must go before Yahweh—you and they, and Aaron. ");
INSERT INTO engULB_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Each of you must take his censer and put incense in it. Then each man must bring before Yahweh his censer, two hundred and fifty censers. You and Aaron, also, must each bring your censer.” ");
INSERT INTO engULB_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","So every man took his censer, put fire in it, laid incense in it, and stood at the entrance to the tent of meeting with Moses and Aaron. ");
INSERT INTO engULB_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Korah assembled all the community against Moses and Aaron at the entrance to the tent of meeting, and Yahweh's glory appeared to all the community. ");
INSERT INTO engULB_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Then Yahweh spoke to Moses and to Aaron: ");
INSERT INTO engULB_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Separate yourselves from among this community that I may consume them immediately.” ");
INSERT INTO engULB_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Moses and Aaron lay facedown and said, “God, the God of the spirits of all humanity, if one man sins, must you be angry with all the community?” ");
INSERT INTO engULB_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Yahweh replied to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Speak to the community. Say, 'Get away from the tents of Korah, Dathan, and Abiram.'” ");
INSERT INTO engULB_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Then Moses rose up and went to Dathan and Abiram; the elders of Israel followed him. ");
INSERT INTO engULB_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","He spoke to the community and said, “Now leave the tents of these wicked men and touch nothing of theirs, or you will be consumed by all their sins.” ");
INSERT INTO engULB_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","So the community on every side of the tents of Korah, Dathan, and Abiram left them. Dathan and Abiram came out and stood at the entrance to their tents, with their wives, sons, and their little ones. ");
INSERT INTO engULB_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Then Moses said, “By this you will know that Yahweh has sent me to do all these works, for I have not done them of my own accord. ");
INSERT INTO engULB_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","If these men die a natural death such as normally happens, then Yahweh has not sent me. ");
INSERT INTO engULB_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","But if Yahweh creates something new, and the earth opens its mouth and swallows them, with everything that they possess, and they go down alive into Sheol, then you must understand that these men have despised Yahweh.” ");
INSERT INTO engULB_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","As soon as Moses finished speaking all these words, the ground opened under those men. ");
INSERT INTO engULB_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","The earth opened its mouth and swallowed them, their families, and all the people who belonged to Korah, as well as all their possessions. ");
INSERT INTO engULB_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","So they and all that they possessed went down alive into Sheol. The earth closed over them, and they perished from among the community. ");
INSERT INTO engULB_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","All Israel around them fled from their cries. They exclaimed, “The earth may swallow us up also!” ");
INSERT INTO engULB_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Then fire flashed out from Yahweh and devoured the 250 men who had offered incense. ");
INSERT INTO engULB_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Again Yahweh spoke to Moses and said, ");
INSERT INTO engULB_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Speak to Eleazar son of Aaron the priest and let him take up the censers out of the flames, for the censers are set apart to me. Then let him scatter the burning coals at a distance. ");
INSERT INTO engULB_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Take the censers of those who lost their lives because of their sin. Let them be made into hammered plates as a covering over the altar. Those men did offer them before me, so they are set apart to me. They will be a sign of my presence to the people of Israel.” ");
INSERT INTO engULB_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Eleazar the priest took the bronze censers that had been used by the men who were burned up, and they were hammered out into a covering for the altar, ");
INSERT INTO engULB_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","to be a reminder to the people of Israel, so that no outsider who was not descended from Aaron should come up to burn incense before Yahweh, so they might not become like Korah and his group—just as Yahweh had commanded through Moses. ");
INSERT INTO engULB_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","But the next morning all the community of the people of Israel complained against Moses and Aaron. They said, “You have killed Yahweh's people.” ");
INSERT INTO engULB_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Then it happened, when the community had assembled against Moses and Aaron, that they looked toward the tent of meeting and, behold, the cloud was covering it. Yahweh's glory appeared, ");
INSERT INTO engULB_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","and Moses and Aaron came to the front of the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Then Yahweh spoke to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Go away from in front of this community so that I may consume them immediately.” Then Moses and Aaron lay down with their faces to the ground. ");
INSERT INTO engULB_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Moses said to Aaron, “Take the censer, put fire in it from off the altar, put incense in it, carry it quickly to the community, and make atonement for them, because anger is coming from Yahweh. The plague has begun.” ");
INSERT INTO engULB_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","So Aaron did as Moses directed. He ran into the middle of the community. The plague had quickly started to spread among the people, so he put in the incense and made atonement for the people. ");
INSERT INTO engULB_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Aaron stood between the dead and the living; in this way the plague was stopped. ");
INSERT INTO engULB_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Those who died by the plague were 14,700 in number, besides those who had died in the matter of Korah. ");
INSERT INTO engULB_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Aaron returned to Moses at the entrance to the tent of meeting, and the plague ended. ");
INSERT INTO engULB_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Yahweh spoke to Moses. He said, ");
INSERT INTO engULB_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Speak to the people of Israel and get staffs from them, one for each ancestral tribe, twelve staffs. Write each man's name on his staff. ");
INSERT INTO engULB_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","You must write Aaron's name on Levi's staff. There must be one staff for each leader from his ancestors' tribe. ");
INSERT INTO engULB_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","You must place the staffs in the tent of meeting in front of the covenant decrees, where I meet with you. ");
INSERT INTO engULB_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","It will happen that the staff of the man whom I choose will bud. I will cause the complaints from the people of Israel to stop, which they are speaking against you.” ");
INSERT INTO engULB_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","So Moses spoke to the people of Israel. All the tribal leaders gave him staffs, one staff from each leader, selected from each of the ancestral tribes, twelve staffs in all. Aaron's staff was among them. ");
INSERT INTO engULB_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Then Moses deposited the staffs before Yahweh in the tent of the covenant decrees. ");
INSERT INTO engULB_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","The next day Moses went into the tent of the covenant decrees and, behold, Aaron's staff for the tribe of Levi had budded. It grew buds and produced blossoms and ripe almonds! ");
INSERT INTO engULB_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Moses brought out all the staffs from before Yahweh to all the people of Israel, and each man took his staff. ");
INSERT INTO engULB_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Yahweh said to Moses, “Put Aaron's staff in front of the covenant decrees. Keep it as a sign of guilt against the people who rebelled so that you may end complaints against me, or they will die.” ");
INSERT INTO engULB_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Moses did just as Yahweh had commanded him. ");
INSERT INTO engULB_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","The people of Israel spoke to Moses and said, “We will die here. We will all perish! ");
INSERT INTO engULB_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Everyone who comes up, who approaches Yahweh's tabernacle, will die. Must we all perish?” ");
INSERT INTO engULB_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Yahweh said to Aaron, “You, your sons, and your ancestor's clan will be responsible for all sins committed against the sanctuary. But only you and your sons with you will be responsible for all sins committed by anyone in the priesthood. ");
INSERT INTO engULB_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","As for your fellow members of the tribe of Levi, your ancestors' tribe, you must bring them with you so they may join you and help you when you and your sons serve in front of the tent of the covenant decrees. ");
INSERT INTO engULB_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","They must serve you and the whole tent. However, they must not come near to anything in the holy place or connected with the altar, or they and also you will die. ");
INSERT INTO engULB_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","They must join you and take care of the tent of meeting, for all the work connected with the tent. A foreigner must not come near you. ");
INSERT INTO engULB_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","You must take responsibility for the holy place and for the altar so that my anger does not come on the people of Israel again. ");
INSERT INTO engULB_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Look, I myself have chosen your fellow members of the Levites from among the descendants of Israel. They are a gift to you, given to me to do the work connected to the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","But only you and your sons may exercise the priesthood regarding everything connected with the altar and everything inside the curtain. You yourselves must fulfill those responsibilities. I am giving you the priesthood as a gift. Any foreigner who approaches must be put to death.” ");
INSERT INTO engULB_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Then Yahweh said to Aaron, “Look, I have given you the duty of handling the offerings raised up to me, and all the holy offerings that the people of Israel give to me. I have given these offerings to you and your sons as your ongoing share. ");
INSERT INTO engULB_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","This will belong to you from the most holy things that is kept from the fire. From every offering of theirs—every grain offering, every sin offering, and every guilt offering—they are set apart to you and to your sons. ");
INSERT INTO engULB_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","These offerings are very holy; every male must eat it, for they are holy to you. ");
INSERT INTO engULB_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","These are the offerings that will belong to you, set apart out of all their gifts of the wave offerings of the people of Israel. I have given them to you, your sons, and your daughters, as your portion forever. Everyone who is ceremonially clean in your family may eat any of these offerings. ");
INSERT INTO engULB_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","All the best of the oil, all the best of the new wine and grain, the firstfruits that the people give to me—all these things I have given to you. ");
INSERT INTO engULB_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","The first ripe produce of all that is in their land, which they bring to me, will be yours. Everyone who is clean in your family may eat these things. ");
INSERT INTO engULB_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Every devoted thing in Israel will be yours. ");
INSERT INTO engULB_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Everything that opens the womb, all the firstborn which the people offer to Yahweh, both of man and animal, will be yours. Nevertheless, the people must certainly buy back every firstborn son, and they must buy back the firstborn male of unclean animals. ");
INSERT INTO engULB_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Those that are to be bought back by the people must be bought back after becoming one month old. Then the people may buy them back, for the price of five shekels, by the standard weight of the sanctuary shekel, which equals twenty gerahs. ");
INSERT INTO engULB_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","But the firstborn of a cow, or the firstborn of a sheep, or the firstborn of a goat—you must not buy back these animals; they are set apart to me. You must sprinkle their blood on the altar and burn their fat as an offering made by fire, an aroma pleasing to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Their meat will be yours. Like the raised breast and the right thigh, their meat will be yours. ");
INSERT INTO engULB_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","All the holy offerings that the people of Israel present to Yahweh, I have given to you, and to your sons and to your daughters with you, as a continual share. It is an everlasting covenant of salt, a binding covenant forever, before Yahweh for both you and your descendants with you.” ");
INSERT INTO engULB_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Yahweh said to Aaron, “You will have no inheritance in the people's land, nor will you have any share of property among the people. I am your share and inheritance among the people of Israel. ");
INSERT INTO engULB_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","To the descendants of Levi, look, I have given all the tithes in Israel as their inheritance in return for the service that they provide in working at the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","From now on the people of Israel must not come near the tent of meeting, or they will be responsible for this sin and die. ");
INSERT INTO engULB_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","The Levites must do the work connected to the tent of meeting. They will be responsible for any sin regarding it. This will be a permanent law throughout your people's generations. Among the people of Israel they must have no inheritance. ");
INSERT INTO engULB_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","For the tithes of the people of Israel, which they offer as a contribution to me—it is these that I have given to the Levites as their inheritance. That is why I said to them, 'They must have no inheritance among the people of Israel.'” ");
INSERT INTO engULB_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Yahweh spoke to Moses and said, ");
INSERT INTO engULB_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“You must speak to the Levites and say to them, 'When you receive from the people of Israel the tenth that I have given to you from them for your inheritance, you will present a contribution from it to Yahweh, a tenth of the tithe. ");
INSERT INTO engULB_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Your contribution must be considered by you as if it were a tenth of the grain from the threshing floor or of the production from the winepress. ");
INSERT INTO engULB_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","So you also must make a contribution to Yahweh from all the tithes that you receive from the people of Israel. From them you must give his contribution to Aaron the priest. ");
INSERT INTO engULB_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Out of all the gifts you receive, you must make every contribution to Yahweh. You must do this from all the best and the holiest things that have been given to you.' ");
INSERT INTO engULB_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Therefore you must say to them, 'When you present the best of it, then it must be credited to the Levites as the product from the threshing floor and the winepress. ");
INSERT INTO engULB_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","You may eat the rest of your gifts in any place, you and your families, because it is your pay in return for your work in the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","You will not incur any guilt by eating and drinking it, if you have presented to Yahweh the best of what you have received. But you must not profane the holy offerings of the people of Israel, or you will die.'” ");
INSERT INTO engULB_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Yahweh spoke to Moses and Aaron. He said, ");
INSERT INTO engULB_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“This is a statute, a law which I am commanding you: Say to the people of Israel that they must bring to you a red heifer without flaw or blemish, and which has never carried a yoke. ");
INSERT INTO engULB_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Give the heifer to Eleazar the priest. He must bring it outside the camp, and someone must kill it in front of him. ");
INSERT INTO engULB_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Eleazar the priest must take some of its blood with his finger and sprinkle it seven times toward the front of the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Another priest must burn the heifer in his sight. He must burn its hide, flesh, and its blood with its dung. ");
INSERT INTO engULB_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","The priest must take cedarwood, hyssop, and scarlet wool, and throw it all into the middle of the burning heifer. ");
INSERT INTO engULB_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Then he must wash his clothes and bathe in water. Then he may come into the camp, where he will remain unclean until the evening. ");
INSERT INTO engULB_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","The one who has burned the heifer must wash his clothes in water and bathe in water. He will remain unclean until the evening. ");
INSERT INTO engULB_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Someone who is clean must gather up the heifer's ashes and put them outside the camp in a clean place. These ashes must be kept for the community of the people of Israel. They will mix the ashes with water for purification from sin, since the ashes were from a sin offering. ");
INSERT INTO engULB_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","The one who gathered the heifer's ashes must wash his clothes. He will remain unclean until the evening. This will be a permanent law for the people of Israel and the foreigners who stay with them. ");
INSERT INTO engULB_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Whoever touches the dead body of any man will be unclean for seven days. ");
INSERT INTO engULB_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Such a person must purify himself on the third day and on the seventh day. Then he will be clean. But if he does not purify himself the third day, then he will not be clean on the seventh day. ");
INSERT INTO engULB_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Whoever touches a dead person, the body of a man who has died, and does not purify himself—this person defiles Yahweh's tabernacle. That person must be cut off from Israel because the water for impurity was not sprinkled on him. He will remain unclean; his uncleanness will remain on him. ");
INSERT INTO engULB_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","This is the law for when someone dies in a tent. Everyone who goes into the tent and everyone who is already in the tent will be unclean for seven days. ");
INSERT INTO engULB_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Every open container with no cover becomes unclean. ");
INSERT INTO engULB_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Similarly, anyone outside a tent who touches someone who has been killed with a sword, any other dead body, a human bone, or a grave—that person will be unclean for seven days. ");
INSERT INTO engULB_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Do this for the unclean person: Take some ashes from the burnt sin offering and mix them in a jar with fresh water. ");
INSERT INTO engULB_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Someone who is clean must then take hyssop, dip it in the water, and sprinkle it on the tent, on all the containers inside the tent, on the persons who were there, and on anyone who touched the bone, the one who was killed, the one who died, or the grave. ");
INSERT INTO engULB_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","On the third day and on the seventh day, the clean person must sprinkle the unclean person. On the seventh day the unclean person must purify himself. He must wash his clothes and bathe in water. At evening he will become clean. ");
INSERT INTO engULB_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","But anyone who remains unclean, who refuses to purify himself—that person will be cut off from the community, because he has defiled Yahweh's sanctuary. The water for impurity has not been sprinkled on him; he remains unclean. ");
INSERT INTO engULB_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","This will be an ongoing law concerning these situations. The one who sprinkles the water for impurity must wash his clothes. The one who touches the water for impurity will become unclean until evening. ");
INSERT INTO engULB_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Whatever the unclean person touches will become unclean. The person who touches it will become unclean until evening.” ");
INSERT INTO engULB_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","So the people of Israel, the whole community, went into the wilderness of Zin in the first month; they stayed at Kadesh. There Miriam died and was buried. ");
INSERT INTO engULB_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","There was no water for the community, so they assembled together against Moses and Aaron. ");
INSERT INTO engULB_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","The people complained against Moses. They said, “It would have been better if we had died when our fellow Israelites died in front of Yahweh! ");
INSERT INTO engULB_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Why have you brought Yahweh's community into this wilderness to die here, we and our animals? ");
INSERT INTO engULB_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Why did you make us come up out of Egypt to bring us to this horrible place? Here there is no seed, figs, vines, or pomegranates, and there is no water to drink.” ");
INSERT INTO engULB_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","So Moses and Aaron went away from in front of the assembly. They went to the entrance of the tent of meeting and lay facedown. There Yahweh's brilliant glory appeared to them. ");
INSERT INTO engULB_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Yahweh spoke to Moses and said, ");
INSERT INTO engULB_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Take the staff and assemble the community, you, and Aaron your brother. Speak to the rock before their eyes, and command it to flow with water. You will produce water for them out of that rock, and you must give it to the community and their cattle to drink.” ");
INSERT INTO engULB_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Moses took the staff from before Yahweh, as Yahweh had commanded him to do. ");
INSERT INTO engULB_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Then Moses and Aaron gathered the assembly together before the rock. Moses said to them, “Listen now, you rebels. Must we bring water out of this rock for you?” ");
INSERT INTO engULB_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Then Moses raised his hand and struck the rock twice with his staff, and much water came out. The community drank, and their cattle drank. ");
INSERT INTO engULB_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Then Yahweh said to Moses and Aaron, “Because you did not trust me or honor me as holy in the eyes of the people of Israel, you will not bring this assembly into the land I have given them.” ");
INSERT INTO engULB_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","This place was called the waters of Meribah because the people of Israel had quarreled with Yahweh there, and he showed himself to them as holy. ");
INSERT INTO engULB_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Moses sent messengers from Kadesh to the king of Edom: Your brother Israel says this: “You know all the difficulties that have happened to us. ");
INSERT INTO engULB_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","You know that our ancestors went down to Egypt and lived in Egypt a long time. The Egyptians treated us harshly and also our ancestors. ");
INSERT INTO engULB_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","When we called out to Yahweh, he heard our voice and sent an angel and brought us out of Egypt. Look, we are in Kadesh, a city on the border of your land. ");
INSERT INTO engULB_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","I am asking you to let us pass through your land. We will not pass through field or vineyard, nor will we drink the water in your wells. We will go along the king's highway. We will not turn aside to the right hand or to the left until we have passed your border.” ");
INSERT INTO engULB_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","But the king of Edom replied to him, “You may not pass through here. If you do, I will come with the sword to attack you.” ");
INSERT INTO engULB_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Then the people of Israel said to him, “We will go along the highway. If we or our livestock drink your water, we will pay for it. Just let us walk through on foot, without doing anything else.” ");
INSERT INTO engULB_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","But the king of Edom replied, “You may not pass through.” So the king of Edom came against Israel with a strong hand with many soldiers. ");
INSERT INTO engULB_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","The king of Edom refused to allow Israel to cross over their border. Because of this, Israel turned away from the land of Edom. ");
INSERT INTO engULB_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","So the people journeyed from Kadesh. The people of Israel, the whole community, came to Mount Hor. ");
INSERT INTO engULB_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Yahweh spoke to Moses and Aaron at Mount Hor, on Edom's border. He said, ");
INSERT INTO engULB_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aaron must be gathered to his people, for he will not enter the land that I have given to the people of Israel. This is because you both rebelled against my word at the waters of Meribah. ");
INSERT INTO engULB_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Take Aaron and Eleazar his son, and bring them up to Mount Hor. ");
INSERT INTO engULB_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Take Aaron's priestly garments off him and put them on Eleazar his son. Aaron must die and be gathered to his people there.” ");
INSERT INTO engULB_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moses did as Yahweh commanded. They went up Mount Hor in the sight of all the community. ");
INSERT INTO engULB_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Moses took Aaron's priestly garments off him and put them on Eleazar his son. Aaron died there on the top of the mountain. Then Moses and Eleazar came down. ");
INSERT INTO engULB_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","When all the community saw that Aaron was dead, the entire nation wept for Aaron for thirty days. ");
INSERT INTO engULB_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","When the Canaanite king of Arad, who lived in the Negev, heard that Israel was traveling by the road to Atharim, he fought against Israel and took some of them captive. ");
INSERT INTO engULB_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Israel vowed to Yahweh and said, “If you give us victory over these people, then we will completely destroy their cities.” ");
INSERT INTO engULB_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Yahweh listened to Israel's voice and he gave them victory over the Canaanites. They completely destroyed them and their cities. That place was called Hormah. ");
INSERT INTO engULB_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","They traveled from Mount Hor by the road to the Sea of Reeds to go around the land of Edom. The people became very discouraged on the way. ");
INSERT INTO engULB_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","The people spoke against God and Moses: “Why have you brought us up out of Egypt to die in the wilderness? There is no bread, no water, and we hate this miserable food.” ");
INSERT INTO engULB_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Then Yahweh sent poisonous snakes among the people. The snakes bit the people; many people died. ");
INSERT INTO engULB_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","The people came to Moses and said, “We have sinned because we have spoken against Yahweh and you. Pray to Yahweh for him to take the snakes away from us.” So Moses prayed for the people. ");
INSERT INTO engULB_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Yahweh said to Moses, “Make a snake and attach it to a pole. It will happen that everyone who is bitten will survive, if he looks at it.” ");
INSERT INTO engULB_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","So Moses made a bronze snake and attached it to a pole. When a snake bit any person, if he looked at the bronze snake, he survived. ");
INSERT INTO engULB_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Then the people of Israel traveled on and camped at Oboth. ");
INSERT INTO engULB_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","They traveled from Oboth and camped at Iye Abarim in the wilderness that faces Moab toward the east. ");
INSERT INTO engULB_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","From there they traveled on and camped in the Valley of Zered. ");
INSERT INTO engULB_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","From there they traveled on and camped on the other side of the Arnon River, which is in the wilderness that extends from the border of the Amorites. The Arnon River forms the border of Moab, between Moab and the Amorites. ");
INSERT INTO engULB_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","That is why it says in the scroll of the Wars of Yahweh, “... Waheb in Suphah, and the valleys of the Arnon, ");
INSERT INTO engULB_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","the slope of the valleys that lead toward the town of Ar and lie along the border of Moab.” ");
INSERT INTO engULB_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","From there they traveled to Beer, the well where Yahweh said to Moses, “Gather the people together for me to give them water.” ");
INSERT INTO engULB_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Then Israel sang this song: “Spring up, well! Sing about it, ");
INSERT INTO engULB_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","about the well that our leaders dug, the well the nobles of the people dug, with the scepter and their staffs.” Then from the wilderness they traveled to Mattanah. ");
INSERT INTO engULB_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","From Mattanah they traveled to Nahaliel, and from Nahaliel to Bamoth, ");
INSERT INTO engULB_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","and from Bamoth to a valley in the land of Moab. That is where the top of Mount Pisgah looks down on the wilderness. ");
INSERT INTO engULB_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Then Israel sent messengers to Sihon king of the Amorites saying, ");
INSERT INTO engULB_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Let us pass through your land. We will not turn into any field or vineyard. We will not drink the water from your wells. We will travel by the king's highway until we have crossed your border.” ");
INSERT INTO engULB_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","But King Sihon would not allow Israel to pass through their border. Instead, Sihon gathered all his army together and attacked Israel in the wilderness. He came to Jahaz, where he fought against Israel. ");
INSERT INTO engULB_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Israel attacked the army of Sihon with the edge of the sword and took their land from the Arnon to the Jabbok river, as far as the land of the people of Ammon. Now the border of the people of Ammon was fortified. ");
INSERT INTO engULB_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israel took all the Amorite cities and lived in all of them, including Heshbon and all of its villages. ");
INSERT INTO engULB_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshbon was the city of Sihon king of the Amorites, who had fought against the former king of Moab. Sihon had taken all his land from his territory to the Arnon River. ");
INSERT INTO engULB_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","That is why those who speak in proverbs say, “Come to Heshbon. Let the city of Sihon be rebuilt and established again. ");
INSERT INTO engULB_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","A fire blazed from Heshbon, a flame from the city of Sihon that devoured Ar of Moab, and the owners of the high places of Arnon. ");
INSERT INTO engULB_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Woe to you, Moab! You have perished, people of Chemosh. He has made his sons to be fugitives and his daughters to be prisoners of Sihon king of the Amorites. ");
INSERT INTO engULB_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","But we have conquered Sihon. Heshbon is devastated all the way to Dibon. We have defeated them all the way to Nophah, which reaches to Medeba.” ");
INSERT INTO engULB_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","So Israel began to live in the Amorites' land. ");
INSERT INTO engULB_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Then Moses sent men to look at Jazer. They took its villages and drove out the Amorites who were there. ");
INSERT INTO engULB_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Then they turned and went up by the road of Bashan. Og king of Bashan went out against them, he and all his army, to fight them at Edrei. ");
INSERT INTO engULB_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Then Yahweh said to Moses, “Do not fear him, because I have given you victory over him, all his army, and his land. Do to him as you did to Sihon king of the Amorites, who lived at Heshbon.” ");
INSERT INTO engULB_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","So they killed him, his sons, and all his army, until none of his people were left alive. Then they took over his land. ");
INSERT INTO engULB_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","The people of Israel traveled on until they camped in the plains of Moab near Jericho, on the other side of the Jordan River from the city. ");
INSERT INTO engULB_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balak son of Zippor saw all that Israel had done to the Amorites. ");
INSERT INTO engULB_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Moab was very afraid of the people because they were many, and Moab was in terror of the people of Israel. ");
INSERT INTO engULB_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","The king of Moab said to the elders of Midian, “This multitude will eat up all that is around us as an ox eats up the grass in a field.” Now Balak son of Zippor was king of Moab at that time. ");
INSERT INTO engULB_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","He sent messengers to Balaam son of Beor, at Pethor which is by the Euphrates River, in the land of his nation and his people. He called him and said, “Look, a nation has come here from Egypt. They cover the face of the earth and they are right now next to me. ");
INSERT INTO engULB_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","So please come now and curse this nation for me, because they are too strong for me. Perhaps then I can manage to attack them and drive them out of the land. I know that whomever you bless will be blessed, and whomever you curse will be cursed.” ");
INSERT INTO engULB_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","So the elders of Moab and the elders of Midian left, taking payment for divination. They came to Balaam and spoke to him Balak's words. ");
INSERT INTO engULB_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaam said to them, “Stay here tonight. I will bring you what Yahweh says to me.” So the leaders of Moab stayed with Balaam that night. ");
INSERT INTO engULB_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","God came to Balaam and said, “Who are these men who came to you?” ");
INSERT INTO engULB_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam answered God, “Balak son of Zippor, king of Moab, has sent them to me. He said, ");
INSERT INTO engULB_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","'Look, the people who have come from Egypt cover the surface of my land. Now come and curse them for me. Perhaps I will manage to fight them and drive them out.'” ");
INSERT INTO engULB_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","God replied to Balaam, “You must not go with those men. You must not curse the people of Israel because they have been blessed.” ");
INSERT INTO engULB_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Balaam rose up in the morning and said to Balak's leaders, “Go back to your land because Yahweh refuses to allow me to go with you.” ");
INSERT INTO engULB_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","So the leaders of Moab left and went back to Balak. They said, “Balaam refused to come with us.” ");
INSERT INTO engULB_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balak sent again more leaders who were even more honored than the first group. ");
INSERT INTO engULB_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","They came to Balaam and said to him, “Balak son of Zippor says this, 'Please let nothing stop you from coming to me, ");
INSERT INTO engULB_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","because I will pay you extremely well and give you great honor, and I will do whatever you tell me to do. So please come and curse this people for me.'” ");
INSERT INTO engULB_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balaam answered and said to Balak's men, “Even if Balak would give me his palace full of silver and gold, I cannot go beyond the word of Yahweh, my God, and do less or more than what he tells me. ");
INSERT INTO engULB_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Now then, please wait here tonight too, so that I may learn anything further that Yahweh says to me.” ");
INSERT INTO engULB_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","God came to Balaam at night and said to him, “Since these men have come to summon you, get up and go with them. But only do what I tell you to do.” ");
INSERT INTO engULB_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaam got up in the morning, saddled his donkey, and went with the leaders of Moab. ");
INSERT INTO engULB_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","But because he went, God's anger was kindled. The angel of Yahweh placed himself in the road as someone hostile to Balaam, who was riding on his donkey. Balaam's two servants were also with him. ");
INSERT INTO engULB_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","The donkey saw the angel of Yahweh standing in the road with his drawn sword in his hand. The donkey turned off the road and went into a field. Balaam struck the donkey to turn her back to the road. ");
INSERT INTO engULB_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Then the angel of Yahweh stood in a narrow part of the road between some vineyards, with a wall on his right side and another wall on his left side. ");
INSERT INTO engULB_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","The donkey saw the angel of Yahweh again. She went against the wall and pinned Balaam's foot against it. Balaam struck her again. ");
INSERT INTO engULB_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","The angel of Yahweh went further and stood in another narrow place where there was no way to turn to either side. ");
INSERT INTO engULB_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","The donkey saw the angel of Yahweh, and she lay down under Balaam. Balaam's anger was kindled, and he struck the donkey with his staff. ");
INSERT INTO engULB_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Then Yahweh opened the donkey's mouth so she could talk. She said to Balaam, “What have I done to you that induced you to strike me these three times?” ");
INSERT INTO engULB_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam replied to the donkey, “It was because you acted so stupidly with me. I wish there were a sword in my hand. If there were, by now I would have killed you.” ");
INSERT INTO engULB_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","The donkey said to Balaam, “Am not I your donkey on which you have ridden all your life long to this present day? Have I ever been in the habit of doing such things to you before?” Balaam said, “No.” ");
INSERT INTO engULB_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Then Yahweh opened Balaam's eyes, and he saw the angel of Yahweh standing in the road with his drawn sword in his hand. Balaam lowered his head and lay facedown. ");
INSERT INTO engULB_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","The angel of Yahweh said to him, “Why have you struck your donkey these three times? Look, I have come as someone hostile to you because your actions before me have been wicked. ");
INSERT INTO engULB_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","The donkey saw me and turned away from me these three times. If she had not turned away from me, I would certainly have killed you and spared her life.” ");
INSERT INTO engULB_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam said to the angel of Yahweh, “I have sinned. I did not know that you stood against me in the road. So now, if it is displeasing to you, I will turn back.” ");
INSERT INTO engULB_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","But the angel of Yahweh said to Balaam, “Go on ahead with the men. But you must only speak the words that I tell you.” So Balaam went with the leaders of Balak. ");
INSERT INTO engULB_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","When Balak heard that Balaam had come, he went out to meet him at a city in Moab at the Arnon, which is on the border. ");
INSERT INTO engULB_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak said to Balaam, “Did I not send men to you to summon you? Why did you not come to me? Am I not able to honor you?” ");
INSERT INTO engULB_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Then Balaam replied to Balak, “See, I have come to you. Do I now have any power to say anything? I can only say the words that God puts into my mouth.” ");
INSERT INTO engULB_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balaam went with Balak, and they arrived at Kiriath Huzoth. ");
INSERT INTO engULB_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Then Balak sacrificed oxen and sheep and gave some meat to Balaam and the leaders who were with him. ");
INSERT INTO engULB_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","In the morning, Balak took Balaam up to the high place of Baal. From there Balaam could see only a part of the Israelites in their camp. ");
INSERT INTO engULB_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam said to Balak, “Build seven altars here for me and prepare seven bulls and seven rams.” ");
INSERT INTO engULB_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","So Balak did as Balaam requested. Then Balak and Balaam offered a bull and a ram on every altar. ");
INSERT INTO engULB_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Then Balaam said to Balak, “Stand at your burnt offering and I will go. Perhaps Yahweh will come to meet me. Whatever he shows me I will tell you.” So he went away to a hilltop with no trees. ");
INSERT INTO engULB_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","While he was on the hilltop, God met him, and Balaam said to him, “I have built seven altars, and I have offered up a bull and a ram on each one.” ");
INSERT INTO engULB_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Yahweh put a message in Balaam's mouth and said, “Return to Balak and speak to him.” ");
INSERT INTO engULB_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","So Balaam returned to Balak, who was standing by his burnt offering, and all the leaders of Moab were with him. ");
INSERT INTO engULB_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Then Balaam began to speak his prophecy and said, “Balak has brought me from Aram, the king of Moab from the eastern mountains. 'Come, curse Jacob for me,' he said. 'Come, defy Israel.' ");
INSERT INTO engULB_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","How can I curse those whom God has not cursed? How can I oppose those whom Yahweh does not oppose? ");
INSERT INTO engULB_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","For from the top of the rocks I see him; from the hills I look at him. See, there is a people who live alone and do not consider themselves as just an ordinary nation. ");
INSERT INTO engULB_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Who can count the dust of Jacob or number even only one-fourth of Israel? Let me die the death of a righteous person, and let my life's end be like his!” ");
INSERT INTO engULB_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balak said to Balaam, “What have you done to me? I brought you to curse my enemies, but look, you have blessed them.” ");
INSERT INTO engULB_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balaam answered and said, “Should I not be careful to say only what Yahweh puts in my mouth?” ");
INSERT INTO engULB_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","So Balak said to him, “Please come with me to another place where you can see them. You will only see the nearest of them, not all of them. There you will curse them for me.” ");
INSERT INTO engULB_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","So he took Balaam into the field of Zophim, to the top of Mount Pisgah, and built seven more altars. He offered up a bull and a ram on each altar. ");
INSERT INTO engULB_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Then Balaam said to Balak, “Stand here by your burnt offering, while I meet with Yahweh over there.” ");
INSERT INTO engULB_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","So Yahweh met Balaam and put a message in his mouth. He said, “Return to Balak and give him my message.” ");
INSERT INTO engULB_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Balaam returned to him, and look, he was standing by his burnt offering, and the leaders of Moab were with him. Then Balak said to him, “What has Yahweh said?” ");
INSERT INTO engULB_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balaam began his prophecy. He said, “Rise up, Balak, and hear. Listen to me, you son of Zippor. ");
INSERT INTO engULB_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","God is not a man, that he should lie, Or a human being, that he should change his mind. Has he promised anything without doing it? Has he said he would do something without carrying it out? ");
INSERT INTO engULB_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Look, I have been commanded to bless. God has given a blessing, and I cannot reverse it. ");
INSERT INTO engULB_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","He has seen no hardship in Jacob or trouble in Israel. Yahweh their God is with them, and shouts for their king are among them. ");
INSERT INTO engULB_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","God brought them out of Egypt with strength like that of a wild ox. ");
INSERT INTO engULB_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","There is no sorcery that works against Jacob, and no fortune-telling harms Israel. Instead, it must be said about Jacob and Israel, 'Look what God has done!' ");
INSERT INTO engULB_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Look, the people rise like a lioness, as a lion emerges and attacks. He does not lie down until he eats his victim and drinks the blood of what he has killed.” ");
INSERT INTO engULB_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Then Balak said to Balaam, “Do not curse them or bless them at all.” ");
INSERT INTO engULB_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","But Balaam answered and said to Balak, “Did I not tell you that I must say all that Yahweh tells me to say?” ");
INSERT INTO engULB_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","So Balak replied to Balaam, “Come now, I will take you to another place. Perhaps it will please God for you to curse them there for me.” ");
INSERT INTO engULB_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","So Balak took Balaam to the top of Mount Peor, which looks down on the wilderness. ");
INSERT INTO engULB_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaam said to Balak, “Build me seven altars here and prepare seven bulls and seven rams.” ");
INSERT INTO engULB_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","So Balak did as Balaam had said; he offered up a bull and a ram on each altar. ");
INSERT INTO engULB_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","When Balaam saw that it pleased Yahweh to bless Israel, he did not go, as at the other times, to use sorcery. Instead, he looked toward the wilderness. ");
INSERT INTO engULB_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","He raised his eyes and saw that Israel was camped, each in their own tribe, and the Spirit of God came on him. ");
INSERT INTO engULB_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","He received this prophecy and said, “Balaam son of Beor is about to speak, the man whose eyes are wide open. ");
INSERT INTO engULB_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","He speaks and hears God's words. He sees a vision from the Almighty, Before whom he bows down with his eyes open. ");
INSERT INTO engULB_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","How beautiful are your tents, Jacob, the place where you live, Israel! ");
INSERT INTO engULB_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Like valleys they spread out, like gardens by the riverside, like aloes planted by Yahweh, like cedars beside the waters. ");
INSERT INTO engULB_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Water flows from their buckets, and their seed is well-watered. Their king is to be higher than Agag, and their kingdom will be honored. ");
INSERT INTO engULB_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","God brings him out of Egypt, with strength like a wild ox. He will eat up the nations who fight against him. He will break their bones to pieces. He will shoot them with his arrows. ");
INSERT INTO engULB_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","He crouches down like a lion, like a lioness. Who dares disturb him? May everyone who blesses him be blessed; may everyone who curses him be cursed.” ");
INSERT INTO engULB_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balak's anger was kindled against Balaam and he struck his hands together in anger. Balak said to Balaam, “I called you to curse my enemies, but look, you have blessed them three times. ");
INSERT INTO engULB_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","So leave me right now and go home. I said I would greatly reward you, but Yahweh has kept you from getting any reward.” ");
INSERT INTO engULB_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Then Balaam replied to Balak, “I said to the messengers that you sent to me, ");
INSERT INTO engULB_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","'Even if Balak gave me his palace full of silver and gold, I could not go beyond Yahweh's word and anything bad or good, or anything at all that I might want to do. I can say only what Yahweh tells me to say.' Did I not say this to them? ");
INSERT INTO engULB_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","So now, look, I will go back to my people. But first let me warn you what this people will do to your people in the days ahead.” ");
INSERT INTO engULB_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Balaam began this prophecy. He said, “Balaam son of Beor speaks, The man whose eyes are wide open. ");
INSERT INTO engULB_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","This is a prophecy of someone who hears words from God, who has knowledge from the Most High, who has visions from the Almighty, Before whom he bows down with open eyes. ");
INSERT INTO engULB_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","I see him, but he is not here now. I look at him, but he is not near. A star will come out of Jacob, and a scepter will rise out of Israel. He will shatter Moab's leaders and destroy all the descendants of Seth. ");
INSERT INTO engULB_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Then Edom will become a possession of Israel, and Seir will also become their possession, enemies of Israel, whom Israel will conquer with force. ");
INSERT INTO engULB_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Out of Jacob a king will come who will have dominion, and he will destroy the survivors of their city.” ");
INSERT INTO engULB_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Then Balaam looked at Amalek and began his prophecy. He said, “Amalek was once the greatest of nations, but his final end will be destruction.” ");
INSERT INTO engULB_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Then Balaam looked toward the Kenites and began his prophecy. He said, “The place where you live is strong, and your nest is in the rocks. ");
INSERT INTO engULB_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Nevertheless you Kenites will be consumed by fire when Assyria carries you away captive.” ");
INSERT INTO engULB_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Then Balaam began his final prophecy. He said, “Woe! Who will survive when God does this? ");
INSERT INTO engULB_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ships will come from the coast of Kittim; they will attack Assyria and will conquer Eber, but they, too, will end in destruction.” ");
INSERT INTO engULB_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Then Balaam got up and left. He returned to his home, and Balak also went away. ");
INSERT INTO engULB_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israel stayed in Shittim, and the men began to prostitute themselves with women of Moab, ");
INSERT INTO engULB_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","for the Moabites had invited the people to the sacrifices to their gods. So the people ate and bowed down to Moabite gods. ");
INSERT INTO engULB_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","The men of Israel joined in worshiping Baal of Peor, and Yahweh's anger was kindled against Israel. ");
INSERT INTO engULB_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Yahweh said to Moses, “Kill all the leaders of the people and hang them up before me to expose them in the daylight, so that my fierce anger may turn away from Israel.” ");
INSERT INTO engULB_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","So Moses said to Israel's leaders, “Each of you must execute his people who have joined in worshiping Baal of Peor.” ");
INSERT INTO engULB_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Then one of the men of Israel came and brought among his family members a Midianite woman. This happened in the sight of Moses and all the community of the people of Israel, while they were weeping at the entrance to the tent of meeting. ");
INSERT INTO engULB_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","When Phinehas son of Eleazar son of Aaron the priest, saw that, he rose up from among the community and took a spear in his hand. ");
INSERT INTO engULB_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","He followed the Israelite man into the tent and thrust the spear through both of their bodies, both the Israelite man and the woman. So a plague that God had sent on the people of Israel stopped. ");
INSERT INTO engULB_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Those who died by the plague were twenty-four thousand in number. ");
INSERT INTO engULB_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Yahweh spoke to Moses and said, ");
INSERT INTO engULB_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Phinehas son of Eleazar son of Aaron the priest, has turned my rage away from the people of Israel because he was passionate with my zeal among them. So I have not consumed the people of Israel in my fierceness. ");
INSERT INTO engULB_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Therefore say, 'Yahweh says, “Look, I am giving to Phinehas my covenant of peace. ");
INSERT INTO engULB_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","For him and his descendants after him, it will be a covenant of an everlasting priesthood because he was zealous for me, his God. He has atoned for the people of Israel.”'” ");
INSERT INTO engULB_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Now the name of the Israelite man who was killed with the Midianite woman was Zimri son of Salu, a leader of an ancestor's family among the Simeonites. ");
INSERT INTO engULB_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","The name of the Midianite woman who was killed was Kozbi daughter of Zur, who was head of a tribe and family in Midian. ");
INSERT INTO engULB_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","So Yahweh spoke to Moses and said, ");
INSERT INTO engULB_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Treat the Midianites as enemies and attack them, ");
INSERT INTO engULB_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","for they treated you like enemies with their deceitfulness. They led you into evil in the case of Peor and in the case of their sister Kozbi, the daughter of a leader in Midian, who was killed on the day of the plague in the matter of Peor.” ");
INSERT INTO engULB_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","It came about after the plague that Yahweh spoke to Moses and Eleazar son of Aaron the priest. He said, ");
INSERT INTO engULB_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Count all the community of the people of Israel, from twenty years old and up, by their ancestor's families, all who are able to go to war for Israel.” ");
INSERT INTO engULB_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","So Moses and Eleazar the priest spoke to them in the plains of Moab by the Jordan at Jericho and said, ");
INSERT INTO engULB_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Count the people, from twenty years old and up, as Yahweh commanded Moses and the people of Israel, who came out of the land of Egypt.” ");
INSERT INTO engULB_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Reuben was the firstborn of Israel. From his son Hanok came the clan of the Hanokites. From Pallu came the clan of the Palluites. ");
INSERT INTO engULB_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","From Hezron came the clan of the Hezronites. From Karmi came the clan of the Karmites. ");
INSERT INTO engULB_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","These were the clans of Reuben, who numbered 43,730 men. ");
INSERT INTO engULB_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Eliab was a son of Pallu. ");
INSERT INTO engULB_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eliab's sons were Nemuel, Dathan, and Abiram. These were the same Dathan and Abiram who followed Korah when they challenged Moses and Aaron and rebelled against Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","The earth opened its mouth and swallowed them up together with Korah when all his followers died. At that time, fire devoured 250 men, who became a warning sign. ");
INSERT INTO engULB_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","But Korah's line did not die out. ");
INSERT INTO engULB_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","The clans of Simeon's descendants were these: Through Nemuel, the clan of the Nemuelites, through Jamin, the clan of the Jaminites, through Jakin, the clan of the Jakinites, ");
INSERT INTO engULB_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","through Zerah, the clan of the Zerahites, through Shaul, the clan of the Shaulites. ");
INSERT INTO engULB_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","These were the clans of Simeon's descendants, who numbered 22,200 men. ");
INSERT INTO engULB_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","The clans of Gad's descendants were these: Through Zephon, the clan of the Zephonites, through Haggi, the clan of the Haggites, through Shuni, the clan of the Shunites, ");
INSERT INTO engULB_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","through Ozni, the clan of the Oznites, through Eri, the clan of the Erites, ");
INSERT INTO engULB_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","through Arod, the clan of the Arodites, through Areli, the clan of the Arelites. ");
INSERT INTO engULB_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","These were the clans of Gad's descendants, who numbered 40,500 men. ");
INSERT INTO engULB_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Judah's sons were Er and Onan, but these men died in the land of Canaan. ");
INSERT INTO engULB_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","The clans of Judah's other descendants were these: through Shelah, the clan of the Shelanites, through Perez, the clan of the Perezites, and through Zerah, the clan of the Zerahites. ");
INSERT INTO engULB_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","The descendants of Perez were these: Through Hezron, the clan of the Hezronites, through Hamul, the clan of the Hamulites. ");
INSERT INTO engULB_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","These were the clans of Judah's descendants, who numbered 76,500 men. ");
INSERT INTO engULB_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","The clans of Issachar's descendants were these: Through Tola, the clan of the Tolaites, through Puah, the clan of the Puites, ");
INSERT INTO engULB_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","through Jashub, the clan of the Jashubites, through Shimron, the clan of the Shimronites. ");
INSERT INTO engULB_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","These were the clans of Issachar, who numbered 64,300 men. ");
INSERT INTO engULB_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","The clans of Zebulun's descendants were these: Through Sered, the clan of the Seredites, through Elon, the clan of the Elonites, through Jahleel, the clan of the Jahleelites. ");
INSERT INTO engULB_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","These were the clans of the Zebulunites, who numbered 60,500 men. ");
INSERT INTO engULB_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","The clans of Joseph's descendants were Manasseh and Ephraim. ");
INSERT INTO engULB_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","The descendants of Manasseh were these: through Makir, the clan of the Makirites (Makir was Gilead's father), through Gilead, the clan of the Gileadites. ");
INSERT INTO engULB_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Gilead's descendants were these: Through Iezer, the clan of the Iezerites, through Helek, the clan of the Helekites, ");
INSERT INTO engULB_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","through Asriel, the clan of the Asrielites, through Shechem, the clan of the Shechemites, ");
INSERT INTO engULB_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","through Shemida, the clan of the Shemidaites, through Hepher, the clan of the Hepherites. ");
INSERT INTO engULB_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Zelophehad son of Hepher had no sons, but only daughters. The names of his daughters were Mahlah, Noah, Hoglah, Milkah, and Tirzah. ");
INSERT INTO engULB_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","These were the clans of Manasseh, who numbered 52,700 men. ");
INSERT INTO engULB_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","The clans of Ephraim's descendants were these: Through Shuthelah, the clan of the Shuthelahites, through Beker, the clan of the Bekerites, through Tahan, the clan of the Tahanites. ");
INSERT INTO engULB_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","The descendants of Shuthelah were, by Eran, the clan of the Eranites. ");
INSERT INTO engULB_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","These were the clans of Ephraim's descendants, who numbered 32,500 men. These were Joseph's descendants, counted in each of their clans. ");
INSERT INTO engULB_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","The clans of Benjamin's descendants were these: Through Bela, the clan of the Belaites, through Ashbel, the clan of the Ashbelites, through Ahiram, the clan of the Ahiramites, ");
INSERT INTO engULB_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","through Shephupham, the clan of the Shuphamites, through Hupham, the clan of the Huphamites. ");
INSERT INTO engULB_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Bela's sons were Ard and Naaman. From Ard came the clan of the Ardites, and from Naaman came the clan of the Naamites. ");
INSERT INTO engULB_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","These were the clans of Benjamin's descendants. They numbered 45,600 men. ");
INSERT INTO engULB_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","The clans of Dan's descendants were, by Shuham, the clans of the Shuhamites. These were the clans of Dan's descendants. ");
INSERT INTO engULB_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","All the clans of the Shuhamites numbered 64,400 men. ");
INSERT INTO engULB_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","The clans of Asher's descendants were these: Through Imnah, the clan of the Imnites, through Ishvi, the clan of the Ishvites, through Beriah, the clan of the Beriites. ");
INSERT INTO engULB_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","The descendants of Beriah were these: Through Heber, the clan of the Heberites, through Malkiel, the clan of the Malkielites. ");
INSERT INTO engULB_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","The name of Asher's daughter was Serah. ");
INSERT INTO engULB_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","These were the clans of Asher's descendants, who numbered 53,400 men. ");
INSERT INTO engULB_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","The clans of Naphtali's descendants were these: Through Jahzeel, the clan of the Jahzeelites, through Guni, the clan of the Gunites, ");
INSERT INTO engULB_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","through Jezer, the clan of the Jezerites, through Shillem, the clan of the Shillemites. ");
INSERT INTO engULB_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","These were the clans of Naphtali's descendants, who numbered 45,400 men. ");
INSERT INTO engULB_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","This was the complete count of men among the people of Israel: 601,730. ");
INSERT INTO engULB_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Yahweh spoke to Moses and said, ");
INSERT INTO engULB_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“The land must be divided among these men as an inheritance according to the number of their names. ");
INSERT INTO engULB_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","To the larger clans you must give more inheritance, and to the smaller clans you must give less inheritance. To every family you must give an inheritance according to the number of men who were counted. ");
INSERT INTO engULB_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","However, the land must be divided by random lots. They must inherit the land as it will be divided among their ancestors' tribes. ");
INSERT INTO engULB_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Their inheritance must be divided among the larger and the smaller clans, distributed to them by random lot.” ");
INSERT INTO engULB_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","The Levite clans, counted clan by clan, were these: Through Gershon, the clan of the Gershonites, through Kohath, the clan of the Kohathites, through Merari, the clan of the Merarites. ");
INSERT INTO engULB_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","The clans of Levi were these: the clan of the Libnites, the clan of the Hebronites, the clan of the Mahlites, the clan of the Mushites, and the clan of the Korahites. Kohath was the Amram's ancestor. ");
INSERT INTO engULB_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","The name of Amram's wife was Jochebed, a descendant of Levi, who was born to Levites in Egypt. She bore to Amram their children, who were Aaron, Moses, and Miriam their sister. ");
INSERT INTO engULB_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","To Aaron were born Nadab and Abihu, Eleazar and Ithamar. ");
INSERT INTO engULB_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadab and Abihu died when they offered before Yahweh unacceptable fire. ");
INSERT INTO engULB_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","The males who were counted among them numbered twenty-three thousand, all males one month old and up. But they were not counted among Israel's descendants because no inheritance was given to them among the people of Israel. ");
INSERT INTO engULB_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","These are the ones who were counted by Moses and Eleazar the priest. They counted the people of Israel in the plains of Moab by the Jordan at Jericho. ");
INSERT INTO engULB_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","But among these there was no man who had been counted by Moses and Aaron the priest when the descendants of Israel were counted in the wilderness of Sinai. ");
INSERT INTO engULB_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","For Yahweh had said that all of those people would certainly die in the wilderness. There was not a man left among them, except Caleb son of Jephunneh and Joshua son of Nun. ");
INSERT INTO engULB_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Then to Moses came the daughters of Zelophehad son of Hepher son of Gilead son of Machir son of Manasseh, of the clans of Manasseh son of Joseph. These were the names of his daughters: Mahlah, Noah, Hoglah, Milkah, and Tirzah. ");
INSERT INTO engULB_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","They stood before Moses, Eleazar the priest, the leaders, and before all the community at the entrance to the tent of meeting. They said, ");
INSERT INTO engULB_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Our father died in the wilderness. He was not among those who conspired against Yahweh in the company of Korah. He died for his own sin, and he had no sons. ");
INSERT INTO engULB_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Why should our father's name be taken away from among his clan members because he had no son? Give us land among our father's relatives.” ");
INSERT INTO engULB_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","So Moses brought their case before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Yahweh spoke to Moses and said, ");
INSERT INTO engULB_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Zelophehad's daughters are speaking correctly. You must certainly give them land as an inheritance among their father's relatives, and you must ensure that their father's inheritance passes on to them. ");
INSERT INTO engULB_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","You must speak to the people of Israel and say, 'If a man dies and has no son, then you must cause his inheritance to pass to his daughter. ");
INSERT INTO engULB_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","If he has no daughter, then you must give his inheritance to his brothers. ");
INSERT INTO engULB_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","If he has no brothers, then you must give his inheritance to his father's brothers. ");
INSERT INTO engULB_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","If his father has no brothers, then you must give his inheritance to his nearest relative in his clan, and he must take it for his own. This will be a law established by decree for the people of Israel, as Yahweh has commanded me.'” ");
INSERT INTO engULB_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Yahweh said to Moses, “Go up the mountains of Abarim and look at the land that I have given to the people of Israel. ");
INSERT INTO engULB_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","After you have seen it, you, too, must be gathered to your people, like Aaron your brother. ");
INSERT INTO engULB_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","This will happen because you two rebelled against my command in the wilderness of Zin. There, when the water flowed from the rock, in your anger you failed to honor me as holy before the eyes of the whole community.” These are the waters of Meribah of Kadesh in the wilderness of Zin. ");
INSERT INTO engULB_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Then Moses spoke to Yahweh and said, ");
INSERT INTO engULB_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“May you, Yahweh, the God of the spirits of all humanity, appoint a man over the community, ");
INSERT INTO engULB_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","a man who may go out and come in before them and lead them out and bring them in, so that your community is not like sheep that have no shepherd.” ");
INSERT INTO engULB_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Yahweh said to Moses, “Take Joshua son of Nun, a man in whom my Spirit lives, and lay your hand on him. ");
INSERT INTO engULB_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Place him before Eleazar the priest and before all the community, and command him before their eyes to lead them. ");
INSERT INTO engULB_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","You must put some of your authority on him, so that all the community of the people of Israel may obey him. ");
INSERT INTO engULB_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","He will go before Eleazar the priest to seek my will for him by the decisions of the Urim. It will be at his command that the people will go out and come in, both he and all the people of Israel with him, the whole community.” ");
INSERT INTO engULB_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","So Moses did as Yahweh had commanded him. He took Joshua and placed him before Eleazar the priest and all the community. ");
INSERT INTO engULB_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","He laid his hands on him and commanded him to lead, as Yahweh had commanded him to do. ");
INSERT INTO engULB_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Yahweh spoke to Moses and said, ");
INSERT INTO engULB_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Command the people of Israel and say to them, 'You must offer sacrifices to me at the appointed times, the food of my offerings made by fire to produce a sweet aroma for me.' ");
INSERT INTO engULB_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","You must also say to them, 'This is the offering made by fire that you must offer to Yahweh—male lambs a year old without blemish, two each day, as a regular burnt offering. ");
INSERT INTO engULB_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","One lamb you must offer in the morning, and the other lamb you must offer in the evening. ");
INSERT INTO engULB_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","You must offer a tenth of an ephah of fine flour as a grain offering, mixed with one-fourth of a hin of beaten oil. ");
INSERT INTO engULB_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","This is the regular burnt offering that was commanded at Mount Sinai to produce a sweet aroma, an offering made by fire to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","The drink offering with it must be one-fourth of a hin for one of the lambs. You must pour out in the holy place a drink offering of strong drink to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","The other lamb you must offer in the evening along with another grain offering like the one offered in the morning. You must also offer another drink offering with it, an offering made by fire, to produce a sweet aroma for Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","On the Sabbath day you must offer two male lambs, each a year old without blemish, and two-tenths of an ephah of fine flour as a grain offering, mixed with oil, and the drink offering with it. ");
INSERT INTO engULB_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","This is to be the burnt offering for every Sabbath, in addition to the regular burnt offering and the drink offering with it. ");
INSERT INTO engULB_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","At the beginning of each month, you must offer a burnt offering to Yahweh. You must offer two young bulls, one ram, and seven male lambs a year old without blemish. ");
INSERT INTO engULB_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","You must also offer three-tenths of an ephah of fine flour as a grain offering mixed with oil for each bull, and two-tenths of fine flour as a grain offering mixed with oil for the one ram. ");
INSERT INTO engULB_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","You must also offer a tenth of an ephah of fine flour mixed with oil as a grain offering for each lamb. This is to be the burnt offering, to produce a sweet aroma, an offering made by fire to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","The people's drink offerings must be half a hin of wine for a bull, a third of a hin for a ram, and one-fourth of a hin for a lamb. This is to be the burnt offering for every month throughout the months of the year. ");
INSERT INTO engULB_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","One male goat as a sin offering to Yahweh must be offered. This will be in addition to the regular burnt offering and the drink offering with it. ");
INSERT INTO engULB_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","During the first month, on the fourteenth day of the month, comes Yahweh's Passover. ");
INSERT INTO engULB_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","On the fifteenth day of this month a feast is to be held. For seven days, bread without yeast must be eaten. ");
INSERT INTO engULB_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","On the first day, there must be a holy assembly to honor Yahweh. You must not do regular work on that day. ");
INSERT INTO engULB_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","However, you must offer a sacrifice made by fire, a burnt offering to Yahweh. You must offer two young bulls, one ram, and seven male lambs a year old, without blemish. ");
INSERT INTO engULB_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Along with the bull, you must offer a grain offering of three-tenths of an ephah of fine flour mixed with oil, and along with the ram, two-tenths. ");
INSERT INTO engULB_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","With each of the seven lambs, you must offer a tenth of an ephah of fine flour mixed with oil, ");
INSERT INTO engULB_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","and one male goat as a sin offering to make atonement for yourselves. ");
INSERT INTO engULB_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","You must offer these in addition to the regular burnt offering required each morning. ");
INSERT INTO engULB_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","As described here, you must offer these sacrifices daily, for the seven days of the Passover, the food of the offering made by fire, a sweet aroma for Yahweh. It must be offered in addition to the regular burnt offering and the drink offering with it. ");
INSERT INTO engULB_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","On the seventh day you must have a holy assembly to honor Yahweh, and you must not do regular work on that day. ");
INSERT INTO engULB_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Also on the day of the firstfruits, when you offer a new grain offering to Yahweh in your Festival of Weeks, you must have a holy assembly to honor Yahweh, and you must not do regular work on that day. ");
INSERT INTO engULB_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","You must offer a burnt offering to produce a sweet aroma for Yahweh. You must offer two young bulls, one ram, and seven male lambs a year old. ");
INSERT INTO engULB_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Offer also grain offering to go with them: Fine flour mixed with oil, three-tenths of an ephah of fine flour mixed with oil for each bull and two-tenths for the one ram. ");
INSERT INTO engULB_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Offer a tenth of an ephah of fine flour mixed with oil for each of the seven lambs, ");
INSERT INTO engULB_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","and one male goat to make atonement for yourselves. ");
INSERT INTO engULB_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","When you offer those animals without blemish, along with their drink offerings, this must be in addition to the regular burnt offering and the grain offering with it.'” ");
INSERT INTO engULB_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“In the seventh month, on the first day of the month, you must have a holy assembly to honor Yahweh. You must not do regular work on that day. It will be a day when you blow trumpets. ");
INSERT INTO engULB_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","You must offer a burnt offering to produce a sweet aroma for Yahweh. You must offer one young bull, one ram, and seven male lambs a year old, each without blemish. ");
INSERT INTO engULB_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","You must offer with them their grain offering, fine flour mixed with oil, three-tenths of an ephah for the bull, two-tenths for the ram, ");
INSERT INTO engULB_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","and one-tenth for each lamb of the seven lambs. ");
INSERT INTO engULB_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","You must offer one male goat as a sin offering to make atonement for yourselves. ");
INSERT INTO engULB_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Make these offerings in the seventh month in addition to all of the offerings you will make on the first of each month: the special burnt offering and the grain offering to go with it. These must be in addition to the regular burnt offering, its grain offering, and its drink offerings. As you make these offerings, you will obey what has been decreed to produce a sweet aroma, an offering made by fire to Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","On the tenth day of the seventh month you must have a holy assembly to honor Yahweh. You must humble yourselves and do no work. ");
INSERT INTO engULB_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","You must offer a burnt offering to produce a sweet aroma for Yahweh. You must offer one young bull, one ram, and seven male lambs a year old. They must each be without blemish. ");
INSERT INTO engULB_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","You must offer with them a grain offering, fine flour mixed with oil, three-tenths of an ephah for the bull, two-tenths for the one ram, ");
INSERT INTO engULB_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","and a tenth of an ephah for each of the seven lambs. ");
INSERT INTO engULB_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","You must offer one male goat as a sin offering. This will be in addition to the sin offering of atonement, the regular burnt offering, its grain offering, and their drink offerings. ");
INSERT INTO engULB_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","On the fifteenth day of the seventh month you must have a holy assembly to honor Yahweh. You must not do regular work on that day, and you must keep the festival for him seven days. ");
INSERT INTO engULB_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","You must offer a burnt offering, a sacrifice made by fire to produce a sweet aroma for Yahweh. You must offer thirteen young bulls, two rams, and fourteen male lambs a year old. Each must be without blemish. ");
INSERT INTO engULB_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","You must offer with them a grain offering, fine flour mixed with oil, three-tenths of an ephah for every bull of the thirteen bulls, two-tenths for each ram of the two rams, ");
INSERT INTO engULB_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","and a tenth of an ephah for each of the fourteen lambs. ");
INSERT INTO engULB_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","You must offer one male goat as a sin offering in addition to the regular burnt offering, its grain offering, and the drink offering with it. ");
INSERT INTO engULB_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","On the second day of the assembly, you must offer twelve young bulls, two rams, and fourteen male lambs a year old, each without blemish. ");
INSERT INTO engULB_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","You must make with them a grain offering and the drink offerings for the bulls, for the rams, and for the lambs, making as many offerings as were commanded. ");
INSERT INTO engULB_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","You must offer one male goat as a sin offering in addition to the regular burnt offering, its grain offering, and their drink offerings. ");
INSERT INTO engULB_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","On the third day of the assembly, you must offer eleven bulls, two rams, and fourteen male lambs a year old, each without blemish. ");
INSERT INTO engULB_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","You must make with them a grain offering and the drink offerings for the bulls, for the rams, and for the lambs, making as many offerings as were commanded. ");
INSERT INTO engULB_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","You must offer one male goat as a sin offering in addition to the regular burnt offering, its grain offering, and their drink offerings. ");
INSERT INTO engULB_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","On the fourth day of the assembly, you must offer ten bulls, two rams, and fourteen male lambs a year old, each without blemish. ");
INSERT INTO engULB_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","You must make with them a grain offering and the drink offerings for the bulls, for the rams, and for the lambs, making as many offerings as were commanded. ");
INSERT INTO engULB_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","You must offer one male goat as a sin offering in addition to the regular burnt offering, its grain offering, and their drink offerings. ");
INSERT INTO engULB_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","On the fifth day of the assembly, you must offer nine bulls, two rams, and fourteen male lambs a year old, each without blemish. ");
INSERT INTO engULB_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","You must make with them a grain offering and the drink offerings for the bulls, for the rams, and for the lambs, making as many offerings as were commanded. ");
INSERT INTO engULB_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","You must offer one male goat as a sin offering in addition to the regular burnt offering, its grain offering, and their drink offerings. ");
INSERT INTO engULB_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","On the sixth day of the assembly, you must offer eight bulls, two rams, and fourteen male lambs a year old, each without blemish. ");
INSERT INTO engULB_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","You must make with them a grain offering and the drink offerings for the bulls, for the rams, and for the lambs, making as many offerings as were commanded. ");
INSERT INTO engULB_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","You must offer one male goat as a sin offering in addition to the regular burnt offering, its grain offering, and their drink offerings. ");
INSERT INTO engULB_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","On the seventh day of the assembly, you must offer seven bulls, two rams, and fourteen male lambs a year old, each without blemish. ");
INSERT INTO engULB_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","You must make with them a grain offering and the drink offerings for the bulls, for the rams, and for the lambs, making as many offerings as were commanded. ");
INSERT INTO engULB_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","You must offer one male goat as a sin offering in addition to the regular burnt offering, its grain offering, and their drink offerings. ");
INSERT INTO engULB_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","On the eighth day you must have another solemn assembly. You must not do regular work on that day. ");
INSERT INTO engULB_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","You must make a burnt offering, an offering made by fire to produce a sweet aroma for Yahweh. You must offer one bull, one ram, and seven male lambs a year old, each without blemish. ");
INSERT INTO engULB_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","You must offer their grain offering and their drink offerings for the bull, for the ram, and for the lambs, making as many offerings as were commanded. ");
INSERT INTO engULB_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","You must offer one male goat as a sin offering in addition to the regular burnt offering, its grain offering, and their drink offerings. ");
INSERT INTO engULB_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","These are what you must offer to Yahweh at your fixed festivals. These must be in addition to your vows and freewill offerings. You must offer these as your burnt offerings, grain offerings, drink offerings, and fellowship offerings.” ");
INSERT INTO engULB_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Moses told the people of Israel everything that Yahweh had commanded him to say. ");
INSERT INTO engULB_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moses spoke to the leaders of the tribes of the people of Israel. He said, “This is what Yahweh has commanded. ");
INSERT INTO engULB_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","When anyone makes a vow to Yahweh, or swears an oath to bind himself with a promise, he must not break his word. He must keep his promise to do everything that comes out of his mouth. ");
INSERT INTO engULB_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","When a young woman living in her father's house makes a vow to Yahweh and binds herself with a promise, ");
INSERT INTO engULB_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","if her father hears the vow and the promise by which she has bound herself, and if he says nothing to reverse her, then all her vows will remain in force. Every promise by which she has bound herself will remain in force. ");
INSERT INTO engULB_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","But if her father hears about her vow and her promise, and if he says nothing to her, then all the vows and promises that she took on herself will remain in force. ");
INSERT INTO engULB_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","However, if her father hears all the vows she made and her solemn promises with which she has bound herself, and if he overrules her on that same day, then they will not remain in force. Yahweh will forgive her because her father had overruled her. ");
INSERT INTO engULB_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","If she marries a man while she is under those vows, or if she makes rash promises with which she obligates herself, those obligations will remain in force. ");
INSERT INTO engULB_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","But if her husband stops her on the day that he hears about it, then he cancels the vow that she has made, the rash talk of her lips with which she has bound herself. Yahweh will release her. ");
INSERT INTO engULB_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","But as for a widow or a divorced woman, everything by which she has bound herself will remain in force against her. ");
INSERT INTO engULB_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","If a woman made a vow in her husband's house or obligates herself by taking an oath, ");
INSERT INTO engULB_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","and her husband hears of it, but he says nothing to her and he does oppose her, then all her vows must stand and the obligations she made must remain in force. ");
INSERT INTO engULB_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","But if her husband cancels them on the day that he heard about them, then whatever came out of her lips about her vows or promises will not remain in force. Her husband has canceled them. Yahweh will release her. ");
INSERT INTO engULB_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Every vow or oath a woman takes that binds her to deny herself something may be confirmed or canceled by her husband. ");
INSERT INTO engULB_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","But if he says nothing at all to her day after day, then he confirms all her vows and binding promises that she has made. He has confirmed them because he has said nothing to her at the time that he heard about them. ");
INSERT INTO engULB_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","If her husband tries to cancel his wife's vow a long time after he has heard about it, then he will be responsible for her sin.” ");
INSERT INTO engULB_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","These are the statutes that Yahweh commanded Moses to announce—statutes for what is between a man and his wife and between a father and his daughter when she is in her youth in her father's family. ");
INSERT INTO engULB_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Yahweh spoke to Moses and said, ");
INSERT INTO engULB_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Take vengeance on the Midianites for what they did to the Israelites. After doing that, you will die and be gathered to your people.” ");
INSERT INTO engULB_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","So Moses spoke to the people. He said, “Arm some of your men for war so they may go against Midian and carry out Yahweh's vengeance on it. ");
INSERT INTO engULB_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Every tribe throughout Israel must send a thousand soldiers to war.” ");
INSERT INTO engULB_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","So out of Israel's thousands of men, one thousand was provided from each tribe, twelve thousand men armed for war. ");
INSERT INTO engULB_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Then Moses sent them to battle, a thousand from every tribe, along with Phinehas son of Eleazar the priest, and with some articles from the holy place and the trumpets in his possession for sounding signals. ");
INSERT INTO engULB_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","They fought against Midian, as Yahweh had commanded Moses. They killed every man. ");
INSERT INTO engULB_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","They killed the kings of Midian with the rest of their dead: Evi, Rekem, Zur, Hur, and Reba, the five kings of Midian. They also killed Balaam son of Beor, with the sword. ");
INSERT INTO engULB_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","The army of Israel took captive the women of Midian, their children, all their cattle, all their flocks, and all their goods. They took these as plunder. ");
INSERT INTO engULB_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","They burned all their cities where they lived and all their camps. ");
INSERT INTO engULB_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","They took all the plunder and prisoners, both people and animals. ");
INSERT INTO engULB_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","They brought the prisoners, the plunder, and the captured things to Moses, to Eleazar the priest, and to the community of the people of Israel. They brought these to the camp in the plains of Moab, by the Jordan near Jericho. ");
INSERT INTO engULB_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moses, Eleazar the priest, and all the leaders of the community went to meet them outside the camp. ");
INSERT INTO engULB_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","But Moses was angry with the officers of the army, the commanders of thousands and the captains of hundreds, who came from battle. ");
INSERT INTO engULB_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Moses said to them, “Have you let all the women live? ");
INSERT INTO engULB_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Look, these women caused the people of Israel, through Balaam's advice, to commit sin against Yahweh in the matter of Peor, when the plague spread among Yahweh's community. ");
INSERT INTO engULB_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Now then, kill every male among the little ones, and kill every woman who has ever slept with a man. ");
INSERT INTO engULB_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","But take for yourselves all the young girls who have never slept with a man. ");
INSERT INTO engULB_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","You must camp outside the camp of Israel for seven days. All of you who have killed anyone and or have touched any dead person—you must purify yourselves on the third day and on the seventh day—you and your prisoners. ");
INSERT INTO engULB_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","You must purify every garment and everything made of animal hide and goats' hair, and everything made of wood.” ");
INSERT INTO engULB_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Eleazar the priest said to the soldiers who had gone to war, “This is a decreed law that Yahweh has given to Moses: ");
INSERT INTO engULB_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","The gold, silver, bronze, iron, tin, and lead, ");
INSERT INTO engULB_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","and everything that resists fire, you must put it through the fire, and it will become clean. You must then purify those things with the water of cleansing. Whatever cannot go through the fire you must cleanse with that water. ");
INSERT INTO engULB_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","You must wash your clothes on the seventh day, and then you will become clean. Afterward you may come into Israel's camp.” ");
INSERT INTO engULB_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Then Yahweh spoke to Moses and said, ");
INSERT INTO engULB_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Count all the plundered things that were taken, both people and animals. You, Eleazar the priest, and the leaders of the community's ancestor's clans ");
INSERT INTO engULB_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","must divide the plunder into two parts. Divide it between the soldiers who went out to battle and all the rest of the community. ");
INSERT INTO engULB_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Then levy a tax to be given to me from the soldiers who went out to battle. This tax must be one out of every five hundred, whether persons, cattle, donkeys, sheep, or goats. ");
INSERT INTO engULB_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Take this tax from their half and give it to Eleazar the priest for an offering to be presented to me. ");
INSERT INTO engULB_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Also from the people of Israel's half, you must take one out of every fifty—from the persons, cattle, donkeys, sheep, and goats. Give these to the Levites who take care of my tabernacle.” ");
INSERT INTO engULB_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","So Moses and Eleazar the priest did as Yahweh had commanded Moses. ");
INSERT INTO engULB_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Now the plunder that remained of what the soldiers had taken was 675,000 sheep, ");
INSERT INTO engULB_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","seventy-two thousand oxen, ");
INSERT INTO engULB_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","sixty-one thousand donkeys, ");
INSERT INTO engULB_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","and thirty-two thousand women who had never slept with any man. ");
INSERT INTO engULB_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","The half that was kept for the soldiers numbered 337,000 sheep. ");
INSERT INTO engULB_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Yahweh's part of the sheep was 675. ");
INSERT INTO engULB_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","The oxen were thirty-six thousand which Yahweh's tax was seventy-two. ");
INSERT INTO engULB_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","The donkeys were 30,500 from which Yahweh's part was sixty-one. ");
INSERT INTO engULB_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","The persons were sixteen thousand women of whom Yahweh's tax was thirty-two. ");
INSERT INTO engULB_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Moses took the tax that was to be an offering presented to Yahweh. He gave it to Eleazar the priest, as Yahweh commanded Moses. ");
INSERT INTO engULB_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","As for the people of Israel's half that Moses had taken from the soldiers who had gone to war— ");
INSERT INTO engULB_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","the community's half was 337,500 sheep, ");
INSERT INTO engULB_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","thirty-six thousand oxen, ");
INSERT INTO engULB_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30,500 donkeys, ");
INSERT INTO engULB_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","and sixteen thousand women. ");
INSERT INTO engULB_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","From the people of Israel's half, Moses took one out of every fifty, both of people and animals. He gave them to the Levites who kept care of Yahweh's tabernacle, as Yahweh had commanded him to do. ");
INSERT INTO engULB_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Then the officers of the army, the commanders over thousands and the captains over hundreds, came to Moses. ");
INSERT INTO engULB_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","They said to him, “Your servants have counted the soldiers who are under our command, and not one man is missing. ");
INSERT INTO engULB_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","We have brought Yahweh's offering, what each man found, articles of gold, armlets and bracelets, signet rings, earrings, and necklaces, to make atonement for ourselves before Yahweh.” ");
INSERT INTO engULB_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Moses and Eleazar the priest received from them the gold and all the articles of craftsmanship. ");
INSERT INTO engULB_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","All the gold of the offering that they gave to Yahweh—the offerings from the commanders of thousands and from the captains of hundreds—weighed 16,750 shekels. ");
INSERT INTO engULB_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Each soldier had taken plunder, each man for himself. ");
INSERT INTO engULB_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Moses and Eleazar the priest took the gold from the commanders of thousands and captains of hundreds. They took it into the tent of meeting as a reminder of the people of Israel for Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Now the descendants of Reuben and of Gad had large numbers of livestock. When they saw the land of Jazer and Gilead, the land was a wonderful place for livestock. ");
INSERT INTO engULB_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","So the descendants of Gad and Reuben came and spoke to Moses, to Eleazar the priest, and to the leaders of the community. They said, ");
INSERT INTO engULB_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“This is a list of places we have surveyed: Ataroth, Dibon, Jazer, Nimrah, Heshbon, Elealeh, Sebam, Nebo, and Beon. ");
INSERT INTO engULB_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","These are the lands that Yahweh attacked before the community of Israel, and they are good places for livestock. We, your servants, have a lot of livestock.” ");
INSERT INTO engULB_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","They said, “If we have found favor in your eyes, let this land be given to us, your servants, as a possession. Do not make us cross over the Jordan.” ");
INSERT INTO engULB_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Moses replied to the descendants of Gad and Reuben, “Should your brothers go to war while you settle down here? ");
INSERT INTO engULB_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Why discourage the hearts of the people of Israel from going over into the land that Yahweh has given them? ");
INSERT INTO engULB_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Your fathers did the same thing when I sent them from Kadesh Barnea to examine the land. ");
INSERT INTO engULB_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","They went up to the Valley of Eshkol. They saw the land and then discouraged the hearts of the people of Israel so that they refused to enter the land that Yahweh had given them. ");
INSERT INTO engULB_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Yahweh's anger was kindled on that day. He took an oath and said, ");
INSERT INTO engULB_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","'Surely none of the men who came up out of Egypt, from twenty years old and up, will see the land about which I swore to Abraham, to Isaac, and to Jacob, because they have not completely followed me, except for ");
INSERT INTO engULB_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Caleb son of Jephunneh the Kenizzite, and Joshua son of Nun. Only Caleb and Joshua have completely followed me.' ");
INSERT INTO engULB_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","So Yahweh's anger was kindled against Israel. He made them wander around in the wilderness for forty years until all the generation who had done evil in his sight was destroyed. ");
INSERT INTO engULB_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Look, you have risen up in your fathers' place, like just more sinful men, to add to Yahweh's burning anger toward Israel. ");
INSERT INTO engULB_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","If you turn away from following him, he will again leave Israel in the wilderness and you will have destroyed all this people.” ");
INSERT INTO engULB_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","So they came near Moses and said, “Allow us to build fences here for our cattle and cities for our families. ");
INSERT INTO engULB_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","However, we ourselves will be ready and armed to go with Israel's army until we have led them into their place. But our families will live in the fortified cities because of the other people who still live in this land. ");
INSERT INTO engULB_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","We will not return to our houses until every one of the people of Israel has obtained his inheritance. ");
INSERT INTO engULB_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","We will not inherit the land with them on the other side of the Jordan, because our inheritance is here on the east side of the Jordan.” ");
INSERT INTO engULB_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","So Moses replied to them, “If you do what you say, if you arm yourselves to go before Yahweh to war, ");
INSERT INTO engULB_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","then every one of your armed men must cross over the Jordan before Yahweh, until he has driven out his enemies from before him ");
INSERT INTO engULB_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","and the land is subdued before him. Then afterward you may return. You will be guiltless toward Yahweh and toward Israel. This land will be your possession before Yahweh. ");
INSERT INTO engULB_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","But if you do not do so, look, you will have sinned against Yahweh. Be sure that your sin will find you out. ");
INSERT INTO engULB_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Build cities for your families and pens for your sheep; then do what you have said.” ");
INSERT INTO engULB_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","The descendants of Gad and Reuben spoke to Moses and said, “Your servants will do as you, our master, commands. ");
INSERT INTO engULB_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Our little ones, our wives, our flocks, and all our livestock will stay there in the cities of Gilead. ");
INSERT INTO engULB_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","However, we, your servants, will cross over before Yahweh to battle, every man who is armed for war, as you, our master, say.” ");
INSERT INTO engULB_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","So Moses gave instructions concerning them to Eleazar the priest, to Joshua son of Nun, and to the leaders of the ancestor's clans in the tribes of the people of Israel. ");
INSERT INTO engULB_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Moses said to them, “If the descendants of Gad and Reuben cross over the Jordan with you, every man who is armed to battle before Yahweh, and if the land is subdued before you, then you will give them the land of Gilead as a possession. ");
INSERT INTO engULB_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","But if they do not cross over with you armed, then they will acquire their possessions among you in the land of Canaan.” ");
INSERT INTO engULB_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","So the descendants of Gad and Reuben answered and said, “As Yahweh has said to us, your servants, this is what we will do. ");
INSERT INTO engULB_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","We will cross over armed before Yahweh into the land of Canaan, but our possessed inheritance will remain with us on this side of the Jordan.” ");
INSERT INTO engULB_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","So to the descendants of Gad and Reuben, and also to the half tribe of Manasseh son of Joseph, Moses gave the kingdom of Sihon, king of the Amorites, and of Og, king of Bashan. He gave to them the land, and distributed to them all its cities with their borders, the cities of the land around them. ");
INSERT INTO engULB_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","The descendants of Gad rebuilt Dibon, Ataroth, Aroer, ");
INSERT INTO engULB_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atroth Shophan, Jazer, Jogbehah, ");
INSERT INTO engULB_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beth Nimrah, and Beth Haran as fortified cities with pens for sheep. ");
INSERT INTO engULB_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","The descendants of Reuben rebuilt Heshbon, Elealeh, Kiriathaim, ");
INSERT INTO engULB_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, Baal Meon—their names were later changed, and Sibmah. They gave other names to the cities that they rebuilt. ");
INSERT INTO engULB_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","The descendants of Machir son of Manasseh went to Gilead and took it away from the Amorites who were in it. ");
INSERT INTO engULB_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Then Moses gave Gilead to Machir son of Manasseh, and his people settled there. ");
INSERT INTO engULB_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jair son of Manasseh went and captured its towns and called them Havvoth Jair. ");
INSERT INTO engULB_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nobah went and captured Kenath and its villages, and he called it Nobah, after his own name. ");
INSERT INTO engULB_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","These were the movements of the people of Israel after they left the land of Egypt by their armed groups under the leadership of Moses and Aaron. ");
INSERT INTO engULB_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Moses wrote down the places from where they left to where they went, as commanded by Yahweh. These were their movements, departure after departure. ");
INSERT INTO engULB_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","They traveled from Rameses during the first month, leaving on the fifteenth day of the first month. On the morning after the Passover, the people of Israel left openly, in the sight of all the Egyptians. ");
INSERT INTO engULB_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","This happened while the Egyptians were burying all their firstborn, those whom Yahweh had killed among them, for he also inflicted punishment on their gods. ");
INSERT INTO engULB_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","The people of Israel set out from Rameses and camped at Succoth. ");
INSERT INTO engULB_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","They set out from Succoth and camped at Etham, on the edge of the wilderness. ");
INSERT INTO engULB_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","They set out from Etham and turned back to Pi Hahiroth, which is opposite Baal Zephon, where they camped opposite Migdol. ");
INSERT INTO engULB_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Then they set out from opposite Pi Hahiroth and passed through the middle of the sea into the wilderness. They traveled three days' journey into the wilderness of Etham and camped at Marah. ");
INSERT INTO engULB_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","They set out from Marah and arrived at Elim. At Elim were twelve springs of water and seventy palm trees. That is where they camped. ");
INSERT INTO engULB_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","They set out from Elim and camped by the Sea of Reeds. ");
INSERT INTO engULB_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","They set out from the Sea of Reeds and camped in the wilderness of Sin. ");
INSERT INTO engULB_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","They set out from the wilderness of Sin and camped at Dophkah. ");
INSERT INTO engULB_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","They set out from Dophkah and camped at Alush. ");
INSERT INTO engULB_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","They set out from Alush and camped at Rephidim, where no water was found for the people to drink. ");
INSERT INTO engULB_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","They set out from Rephidim and camped in the wilderness of Sinai. ");
INSERT INTO engULB_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","They set out from the wilderness of Sinai and camped at Kibroth Hattaavah. ");
INSERT INTO engULB_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","They set out from Kibroth Hattaavah and camped at Hazeroth. ");
INSERT INTO engULB_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","They set out from Hazeroth and camped at Rithmah. ");
INSERT INTO engULB_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","They set out from Rithmah and camped at Rimmon Perez. ");
INSERT INTO engULB_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","They set out from Rimmon Perez and camped at Libnah. ");
INSERT INTO engULB_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","They set out from Libnah and camped at Rissah. ");
INSERT INTO engULB_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","They set out from Rissah and camped at Kehelathah. ");
INSERT INTO engULB_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","They set out from Kehelathah and camped at Mount Shepher. ");
INSERT INTO engULB_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","They set out from Mount Shepher and camped at Haradah. ");
INSERT INTO engULB_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","They set out from Haradah and camped at Makheloth. ");
INSERT INTO engULB_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","They set out from Makheloth and camped at Tahath. ");
INSERT INTO engULB_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","They set out from Tahath and camped at Terah. ");
INSERT INTO engULB_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","They set out from Terah and camped at Mithkah. ");
INSERT INTO engULB_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","They set out from Mithkah and camped at Hashmonah. ");
INSERT INTO engULB_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","They set out from Hashmonah and camped at Moseroth. ");
INSERT INTO engULB_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","They set out from Moseroth and camped at Bene Jaakan. ");
INSERT INTO engULB_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","They set out from Bene J