﻿USE sofia;
DROP TABLE IF EXISTS sofia.engPEV_vpl;
CREATE TABLE engPEV_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES engPEV_vpl WRITE;
INSERT INTO engPEV_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","First of all, a long time ago, God made everything. He made the sky, and he made the earth. He made all the things that are everywhere. ");
INSERT INTO engPEV_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","The earth didn’t have any shape. It didn’t have anything. It was covered with deep water. Everything was dark. It was dark all over the water, but God’s spirit moved around on the top of the water. ");
INSERT INTO engPEV_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","God said, “I want light.” Straight away, light was shining everywhere. ");
INSERT INTO engPEV_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","God looked at it, and he saw that it was good. So God split up the light and the dark. ");
INSERT INTO engPEV_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","He called the light day time, and he called the dark night time. After that all happened, there was night time and there was morning time. That was day number 1. ");
INSERT INTO engPEV_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Then God said, “I want something to split the water in half.” ");
INSERT INTO engPEV_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","So God made the sky to split the water in half. God left some of the water up high, and he left some of it on the ground, and he put the sky in the middle. ");
INSERT INTO engPEV_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","And when God made it, he called it sky. After that all happened, there was night time and there was morning time. That was day number 2. ");
INSERT INTO engPEV_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Then God said, “I want all the water that is on the ground to come together to one place, and I want dry ground to come up.” Then the water moved to the places where God wanted it, and the dry ground came up. ");
INSERT INTO engPEV_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","God called the dry ground land, and he called that water sea. God looked at the land and the sea, and he saw that everything was good. ");
INSERT INTO engPEV_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Then God said, “I want the land to grow all sorts of plants on the earth. I want plants with seeds, and trees with fruit that have seeds inside.” And God made it happen. ");
INSERT INTO engPEV_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","So all sorts of plants grew on the land, plants with seeds, and trees with fruit that have seeds inside. God looked at all those plants, and he saw that everything was good. ");
INSERT INTO engPEV_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","After that all happened, there was night time and there was morning time. That was day number 3. ");
INSERT INTO engPEV_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Then God said, “I want some lights in the sky. I want the lights to split up the day time from the night time. They will show the time. They will show the season, and the time of the year, and the time of day. ");
INSERT INTO engPEV_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","I will put these lights in the sky to shine on the earth.” So God did that. ");
INSERT INTO engPEV_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","He made 2 big lights. He made one light brighter than the other light. That bright light shines in the day time. We call it the sun. The other light shines in the night time. We call it the moon. And God made the stars too. ");
INSERT INTO engPEV_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","God put all those lights in the sky to shine on the earth. ");
INSERT INTO engPEV_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","One light shines during the day, and another light shines at night. Those lights split the day time from the night time. God looked at those lights, and he saw that everything was good. ");
INSERT INTO engPEV_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","After that all happened, there was night time and there was morning time. That was day number 4. ");
INSERT INTO engPEV_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Then God said, “I want the water to be full of fish and all sorts of living things. And I want birds that fly around in the sky, above the earth.” ");
INSERT INTO engPEV_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","So God made all the different sorts of things that live and move in the sea. He made the great big sea animals and a lot of other things that live in the sea. And God made all the different sorts of birds too. God looked at all those things, and he saw that everything was good. ");
INSERT INTO engPEV_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","God was good to them, and he said to them, “All of you living things will have lots of young ones, so that the sea will be full of fish, and lots of birds will fly around everywhere.” ");
INSERT INTO engPEV_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","After that all happened, there was night time and there was morning time. That was day number 5. ");
INSERT INTO engPEV_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Then God said, “I want the land to be full of all different sorts of animals. I want animals that are wild, and animals that are not wild. I want lizards, and insects, and other things that crawl around on the ground.” And God made it happen just like that. ");
INSERT INTO engPEV_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","God made all the different sorts of animals, the animals that are wild and the animals that are not wild. And he made all the different sorts of lizards, and insects, and other things that crawl around on the ground. God looked at all those things, and he saw that everything was good. ");
INSERT INTO engPEV_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Then God said, “We are going to make people. They will be like us. They will be boss over the fish and everything that lives in the sea, and they will be boss over the birds that fly in the sky, and they will be boss over all the animals that are on the land, the animals that are wild, and the animals that are not wild, and all the lizards, and insects, and other things that crawl around on the ground. People will be boss over all of them.” ");
INSERT INTO engPEV_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","So God made people to be like himself. He made them man and woman. ");
INSERT INTO engPEV_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","God was good to them, and he said to them, “You will have lots of kids, and the earth will be full of people. You people will be boss over all the earth. You will be boss over the fish in the sea, and you will be boss over the birds in the sky, and you will be boss over all the animals that live on the land.” ");
INSERT INTO engPEV_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Then God said to them, “Look, I made lots of food plants for you. I made plants that have seeds in them, and trees with fruit on them too. You can eat the seeds from those plants and the fruit from those trees. That bush tucker will be your food. ");
INSERT INTO engPEV_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","And I made green plants too, for all the animals of the earth to eat, and for all the birds of the sky to eat, and for all the lizards, and insects, and other things that crawl around on the ground to eat too. Everything that breathes air can eat those green plants.” ");
INSERT INTO engPEV_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","God looked at everything he made, and he saw that all of it was very good. After that all happened, there was night time and there was morning time. That was day number 6. ");
INSERT INTO engPEV_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","God finished making everything. He finished making the sky, and the earth, and everything that is on the earth too. ");
INSERT INTO engPEV_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","After God finished all that, it was day number 7, and God rested on that day. ");
INSERT INTO engPEV_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","So God made day number 7 a good and special day. He said, “I’ve finished making everything now, and I’m resting on day number 7. So day number 7 is a special day.” ");
INSERT INTO engPEV_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","This story is about the time when God made the earth and the sky. ");
INSERT INTO engPEV_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","At first, God didn’t send any rain on the earth, and there were no people to make the ground right for the plants. So nothing was growing on the earth at that time. ");
INSERT INTO engPEV_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Water used to come up from under the ground and wet the top of all the ground. ");
INSERT INTO engPEV_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","God took some dirt, and he made a man out of it. Then God breathed into the man’s nose, and God’s breath gave him life. So that man became a living person. ");
INSERT INTO engPEV_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Then God made a garden in a place called Eden. It was in the east part of the land. And God put the man in that garden. ");
INSERT INTO engPEV_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","And God made some trees grow there in that garden. They were pretty, and they had fruit that was good to eat. And God put 2 special trees in the middle of the garden. If people eat the fruit of one of those trees, they will stay alive. And if they eat the fruit from the other tree, they will know if the things they do are good, or if they are bad. ");
INSERT INTO engPEV_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","A river started in Eden, and it watered the garden. Then that river flowed out and split up into 4 rivers. ");
INSERT INTO engPEV_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","The 1st river was called Pishon. It flowed around the land called Havilah. In that country there was lots of gold. ");
INSERT INTO engPEV_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","It was really good gold. And there were pretty stones and good perfumes there too. ");
INSERT INTO engPEV_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","The 2nd river was called Gihon. It flowed all around the country called Cush. ");
INSERT INTO engPEV_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","The 3rd river was called Tigris. It flowed east of the country called Ashur. The 4th river was called Euphrates. ");
INSERT INTO engPEV_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","God put the man into the garden in Eden and gave him some work to do. He had to look after the garden and make sure all the plants grew strong and healthy. ");
INSERT INTO engPEV_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","And God told the man, “You can eat fruit from the trees in this garden. ");
INSERT INTO engPEV_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","There is only one tree that you can’t eat its fruit. You can’t eat the fruit from that tree that lets you know if the things you do are good, or if they are bad. I’m telling you, if you eat any fruit from that tree, you will die, for sure.” ");
INSERT INTO engPEV_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","And God said, “It is not good for this man to be by himself. I’m going to make somebody else to be a mate for the man, somebody that will be good for him.” ");
INSERT INTO engPEV_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","And God made all the animals and birds out of dirt from the ground, and he brought them to the man. God wanted the man to give all the animals and birds their names. The man could say any name he wanted for each one, and those names stayed with them. ");
INSERT INTO engPEV_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","So the man gave each animal a name. He named all the wild animals, and all the animals that are not wild, and all the birds. That man’s own name was Adam. (That name means man.) There were lots of animals and birds, but none of them were the right sort of mate that was good for Adam. ");
INSERT INTO engPEV_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","So God made the man go to sleep. It was a really strong deep sleep. And while he was asleep, God took out one of his rib bones. Then God closed up the place where that rib was. ");
INSERT INTO engPEV_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Then God used the man’s rib bone and made a woman from it. After the man woke up, God took the woman over to the man. ");
INSERT INTO engPEV_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","The man looked at that woman, and he said, “This is really good. Now I have a mate. God took out a part of my body, and he made it into a mate for me. Yes, he used my rib bone to make her. God made her out of a man’s body, so I’m going to call her woman.” ");
INSERT INTO engPEV_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","That’s how God made a woman, he made her out of a man’s body. That is the reason why a man will leave his mother and father and marry a woman. The man and his wife will join with each other, and their bodies will be like one body. ");
INSERT INTO engPEV_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","The man and his wife didn’t have any clothes on. They were both naked, but they didn’t feel any shame. ");
INSERT INTO engPEV_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","You know, God made lots of animals, but the snake was more smart than all the other animals. He was really smart and tricky. One day, the snake went to the woman and said to her, “Did God say, ‘You can’t eat fruit from any of the trees in the garden’? Is that true?” ");
INSERT INTO engPEV_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","The woman said, “No, that’s not true. We can eat fruit from those trees there in the garden. ");
INSERT INTO engPEV_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","God said that there is only one tree that we can’t eat from. We can’t eat any fruit that comes from one of the trees that is in the middle of the garden. God will not even let us touch that tree. He said that if we eat fruit from that tree, we will die.” ");
INSERT INTO engPEV_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","The snake said to the woman, “You will not die. ");
INSERT INTO engPEV_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","God knows what will happen if you eat fruit from that tree. He knows that if you eat fruit from that tree, you will know more things, like God himself. You will know if the things you do are good, or if they are bad.” ");
INSERT INTO engPEV_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","The woman looked at that tree. It was pretty, and the fruit on that tree looked really good to eat, and she reckoned that if she eats some of that fruit, she will think properly. So the woman got some of that fruit, and she ate it, and she gave some of it to her husband, and he ate that fruit too. ");
INSERT INTO engPEV_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Straight away, the man and the woman knew more things. They knew that they were naked, and they felt shame. They wanted to make clothes to cover up their naked bodies, so they picked some big leaves from a tree and sewed the leaves together to make some clothes. ");
INSERT INTO engPEV_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Later on, in the cool part of the day, the man and the woman heard God walking in the garden. So they got behind some trees in the garden to hide from God. ");
INSERT INTO engPEV_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","God called out to the man, “Where are you?” ");
INSERT INTO engPEV_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","The man said, “I heard you walking in the garden, and I was frightened, because I’m naked. So I hid from you.” ");
INSERT INTO engPEV_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","God asked the man, “How do you know that you are naked? Did you eat some of that fruit from the tree that I told you not to eat from?” ");
INSERT INTO engPEV_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","The man said, “Yes, but it was the woman that you put here with me, she gave me fruit from that tree, so I ate it.” ");
INSERT INTO engPEV_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Then God said to the woman, “Why did you do that bad thing?” The woman said, “That snake tricked me. That’s the reason why I ate that fruit.” ");
INSERT INTO engPEV_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Then God said, “Snake, you did the wrong thing, so I will curse you. I will not curse the other animals, but I will curse all you snakes. From now on, you are going to crawl around on your bellies. You will always be down on the ground in the dirt. ");
INSERT INTO engPEV_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","The woman’s kids will hate you, and so will all their kids, and all the people that will be born later on. People will always be your enemies. And Snake, your kids will hate the woman’s kids, and so will all the snake mob that will be born later on. You snake mob will always be the people’s enemies. They will hit your heads, and you will bite their feet.” ");
INSERT INTO engPEV_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Then God said to the woman, “I’m going to give you a lot of trouble. You are going to have a lot of pain whenever you have a baby. It will hurt you a lot. But you will really want to have a husband, and your husband will be your boss.” ");
INSERT INTO engPEV_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","18","Then God said to the man, “I told you not to eat any fruit from one of the trees in the middle of the garden, but you listened to your wife, and you ate that fruit. So I will curse the ground and make it bad for you. It will never be easy for you to get your food from the plants in the ground any more. The ground will have lots of rubbish plants and prickles in it. ");
INSERT INTO engPEV_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","You will work very hard to get your food, so you will get hot, and you will sweat a lot. And later on, you will die. I made you from the dirt, and after you die, your body will turn back into dirt.” ");
INSERT INTO engPEV_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam’s wife was the first woman, and all the people in the world came from her. So Adam gave her the name Eve. That name means somebody that gives life. ");
INSERT INTO engPEV_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","God made some clothes from animal skins for Adam and his wife. ");
INSERT INTO engPEV_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","After that, God said, “These people are like us now. They know what things are good, and what things are bad. We have to stop them, so they will not eat fruit from the other tree in the middle of the garden, the tree that makes people stay alive. If they eat that fruit, they will live for ever.” ");
INSERT INTO engPEV_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","So God hunted them out of the garden. To get food, they had to dig the ground and grow plants. You know, God made that man out of the ground, and after they left the garden, that man had to dig that same ground. ");
INSERT INTO engPEV_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","After God hunted them out of the garden, he made sure that they couldn’t get back. He put some of his angel workers as guards just outside the east side of the garden in Eden. And he put a long knife there with them. That knife kept on moving around all the time, and it looked like it was on fire. Those angel workers and that long knife, they kept everyone away from that tree that makes people stay alive. ");
INSERT INTO engPEV_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam and Eve slept together, like a man does with his wife, and then Eve had a baby boy. Eve said, “God has helped me make another human.” So she gave him the name Cain. That name means make. ");
INSERT INTO engPEV_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","After that, they had another son, and she gave him the name Abel. Abel grew up, and he looked after sheep and goats all the time. Cain grew up, and he became a gardener. He dug the ground and grew plants for people to eat. ");
INSERT INTO engPEV_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","One day, Cain brought a gift to give to God. He brought some food from his garden. ");
INSERT INTO engPEV_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","And Abel brought a gift to give to God too. He gave God some of his young sheep and goats. They were the first ones born to their mothers. Abel brought the best bits of meat from those sheep and goats. And God was happy with Abel, and with his gift. ");
INSERT INTO engPEV_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","But God was not happy with Cain, or with his gift. Then Cain got very angry. His face changed, and he looked very sad. ");
INSERT INTO engPEV_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","God said to Cain, “Why are you angry? Why do you look sad? ");
INSERT INTO engPEV_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","If you do the right thing, I will be happy with you. But, if you don’t do the right thing, look out, you will always want to do more bad things. But you have to control yourself and stop doing bad things.” ");
INSERT INTO engPEV_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","After that, Cain went to his brother Abel, and Cain said, “Let’s go for a walk.” So Cain and Abel went out bush together. While they were there, Cain hit his brother, and killed him dead. ");
INSERT INTO engPEV_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Later, God said to Cain, “Where is your brother, Abel?” Cain said, “I don’t know where my brother is. It’s not my job to look after him.” ");
INSERT INTO engPEV_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","God said to Cain, “You did a really bad thing. Your brother’s blood is on the ground. It’s like his blood is calling out to me. It is telling me you killed him. ");
INSERT INTO engPEV_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","So now I’m going to curse you. You killed your brother, and his blood is on the ground. So I will make the ground bad for you. ");
INSERT INTO engPEV_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","If you try to grow plants in the ground, nothing will grow for you. You will go away from me. And you will walk around in lots of places, but you will not have a home.” ");
INSERT INTO engPEV_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Cain said to God, “God, you are too hard on me. ");
INSERT INTO engPEV_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","If you make me leave this land where I grow my food, and if you make me go away from you, then I will have to walk around everywhere, and I will not have a home. Then somebody will find me and finish me.” ");
INSERT INTO engPEV_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","God said, “I will not let that happen. I’ll tell everybody that if they kill you, then I will punish them properly. I will do 7 times as much payback to them.” So God put a mark on Cain’s head, so that everybody will know that they can’t kill him. ");
INSERT INTO engPEV_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","After that, Cain went away from God and went to live in a place called Nod. That country was on the east side of Eden. ");
INSERT INTO engPEV_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Cain slept with his wife, like married people do together, and then she had a baby boy, called Enok. Cain built a town, and he also called it Enok, after his son. ");
INSERT INTO engPEV_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enok grew up, and he had a son, called Irad. Irad grew up, and he had a son, called Mehujayel. Mehujayel grew up, and he had a son, called Methushayel. Methushayel grew up, and he had a son, called Lamek. ");
INSERT INTO engPEV_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek grew up, and he married 2 women. One wife’s name was Adah, and the other wife’s name was Zillah. ");
INSERT INTO engPEV_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Lamek’s wife Adah had a baby boy, called Jabal. Jabal grew up, and he looked after animals. He took those animals around and camped in different places. He was the first person to do that. ");
INSERT INTO engPEV_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Adah had another son, called Jubal. Jubal grew up and was the first person to play musical instruments. He played a harp and a flute. ");
INSERT INTO engPEV_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lamek’s other wife, Zillah, had a son called Tubal Cain. Tubal Cain grew up and made tools from iron and from a brown metal called bronze. Zillah also had a daughter, called Namah. ");
INSERT INTO engPEV_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","One day, Lamek said to his 2 wives, “Adah and Zillah, listen to me properly. A young man hit me and hurt me, so I killed him dead. ");
INSERT INTO engPEV_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","God said that if anyone killed Cain, he will punish that person properly. He will do 7 times as much payback to them. I reckon I’m more important than Cain. So if somebody kills me for killing that young man, I reckon God will do 77 times as much payback to that person.” ");
INSERT INTO engPEV_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam and Eve slept together again, like a man does with his wife, and they had another son, and they gave him the name Seth. That name means gave. Eve said, “God gave me another son to take the place of Abel, our son that Cain killed.” ");
INSERT INTO engPEV_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seth grew up, and he had a son too, and he gave him the name Enosh. At that time people started to call God by his special name Yahweh when they showed respect to him. ");
INSERT INTO engPEV_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","This is the story about Adam’s family. You see, when God made people, he made them to be like himself. ");
INSERT INTO engPEV_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","And he made them men and women, and he called them human beings, and he was good to them. ");
INSERT INTO engPEV_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam lived a long time. He was 130 years old when he had his son called Seth. He was a human being, just like Adam, his father. ");
INSERT INTO engPEV_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","After Seth was born, Adam lived for another 800 years, and he had more sons and daughters. ");
INSERT INTO engPEV_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","He died when he was 930 years old. ");
INSERT INTO engPEV_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seth lived a long time too. He was 105 years old when he had a son called Enosh. ");
INSERT INTO engPEV_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Then Seth lived for another 807 years, and he had more sons and daughters. ");
INSERT INTO engPEV_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","He died when he was 912 years old. ");
INSERT INTO engPEV_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosh lived a long time too. He was 90 years old when he had a son called Kenan. ");
INSERT INTO engPEV_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Then Enosh lived for another 815 years, and he had more sons and daughters. ");
INSERT INTO engPEV_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","He died when he was 905 years old. ");
INSERT INTO engPEV_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan lived a long time too. He was 70 years old when he had a son called Mahalalel. ");
INSERT INTO engPEV_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Then Kenan lived for another 840 years, and he had more sons and daughters. ");
INSERT INTO engPEV_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","He died when he was 910 years old. ");
INSERT INTO engPEV_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel lived a long time too. He was 65 years old when he had a son called Jared. ");
INSERT INTO engPEV_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Then Mahalalel lived for another 830 years, and he had more sons and daughters. ");
INSERT INTO engPEV_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","He died when he was 895 years old. ");
INSERT INTO engPEV_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared lived a long time too. He was 162 years old when he had a son called Enok. ");
INSERT INTO engPEV_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Then Jared lived for another 800 years, and he had more sons and daughters. ");
INSERT INTO engPEV_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","He died when he was 962 years old. ");
INSERT INTO engPEV_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enok lived a long time too. He was 65 years old when he had a son called Methuselah. ");
INSERT INTO engPEV_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","24","Then Enok lived for another 300 years after Methuselah was born, and he had more sons and daughters. Enok was always God’s friend, and he spent a lot of time with God. One day, when he was 365 years old, he wasn’t here on the earth any more. Nobody could find him anywhere. You see, he didn’t die, but God took him straight up to heaven. ");
INSERT INTO engPEV_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Methuselah lived a long time too. He was 187 years old when he had a son called Lamek. ");
INSERT INTO engPEV_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Then Methuselah lived for another 782 years, and he had more sons and daughters. ");
INSERT INTO engPEV_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","He died when he was 969 years old. ");
INSERT INTO engPEV_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek lived a long time too. He was 182 years old when he had a son. ");
INSERT INTO engPEV_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","He named his son Noah. That name means help people be happy. Lamek said, “God cursed the ground, so we have to work really hard to dig the ground, but Noah will help us be happy, even though we have to work really hard.” ");
INSERT INTO engPEV_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Then Lamek lived for another 595 years, and he had more sons and daughters. ");
INSERT INTO engPEV_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","He died when he was 777 years old. ");
INSERT INTO engPEV_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noah lived a long time too. After he was 500 years old, he had 3 sons. They were called Shem, and Ham, and Jafeth. ");
INSERT INTO engPEV_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","The people on the earth kept on having lots of kids, and those kids grew up and kept on having more kids, so after some time there were lots of people on the earth. And some people had very pretty daughters. ");
INSERT INTO engPEV_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","There were some men that everyone called the Sons of God. They looked at the pretty young women, then they picked out the women they wanted, and they married them. ");
INSERT INTO engPEV_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","God looked at everything that was happening. He said, “I gave people their breath, but I will not let it stay in them for ever. They are just people. They will live for only 120 years.” ");
INSERT INTO engPEV_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Those men that were called the Sons of God, they slept with the pretty women, like men usually sleep with their wives, and then those women had kids called Nefalim. Those Nefalim kids grew up to be big, strong fighting men. They were the great fighters in the stories from a long time ago. ");
INSERT INTO engPEV_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","God looked at the people on the earth, and he saw them doing lots of bad things. He knew the way they were thinking. They were thinking bad things all the time. God saw that the people were very bad. ");
INSERT INTO engPEV_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","So God was feeling sad. He really felt no good inside. He thought to himself, “I should not have made all these people.” ");
INSERT INTO engPEV_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","And God said, “These people keep on doing bad things, and that makes me really sad. I’m sorry that I made them. I’m sorry I made everything on the earth. I want to finish up everything. I want to kill all the people I made, and I want to kill all the animals on earth, the big animals, and the little animals, and even the animals that crawl around on the ground, and I want to kill all the birds that fly in the sky.” ");
INSERT INTO engPEV_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","But God looked at the man called Noah, and Noah made God happy. ");
INSERT INTO engPEV_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","This is the story about Noah and his family. Noah was a good man. He didn’t do anything wrong. He was God’s friend, and he spent a lot of time with God. ");
INSERT INTO engPEV_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","He had 3 sons. Their names were Shem, Ham, and Jafeth. ");
INSERT INTO engPEV_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Everyone on the earth kept on doing bad things. They were doing wrong to each other, and fighting and hurting each other. God looked down and saw all the bad things that were going on. The people were always doing things that were really bad. ");
INSERT INTO engPEV_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","So God said to Noah, “Look, everyone is doing bad things and hurting each other. I’m going to kill everyone, and I will finish up everything on the earth.” ");
INSERT INTO engPEV_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Then God said to Noah, “Make a really big boat for yourself. Make it out of that strong wood called cypress. Make some rooms in the boat. And get some tar, and paint the inside of the boat, and paint the outside too. That will keep the water out of the boat. ");
INSERT INTO engPEV_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Listen, this is how big I want you to make the boat. It has to be 140 metres long, and 23 metres wide, and 13½ metres high. ");
INSERT INTO engPEV_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","I want you to make a roof for that boat, but leave ½ a metre between the top of the walls and the roof, all around the top of the boat. And put a door in the side of the boat. And make 3 floors in the boat, one floor on the bottom and the other 2 floors upstairs. ");
INSERT INTO engPEV_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","You see, soon I will bring a lot of flood water, and it will cover the earth, and everything that is on the earth will die. Everything that breathes air will die, wherever they live. ");
INSERT INTO engPEV_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","But don’t worry. I’m making a strong promise to you, that I will look after you. I will look after you, and your wife, and all your kids, and their wives too. You all have to go into that boat. ");
INSERT INTO engPEV_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","And you have to bring lots of animals into that boat too. Every sort of animal that is on the earth has to go into that boat, so that they will stay alive in the big flood. Get one male and one female of each sort of those animals, and take them into the boat with you. You see, you have to keep those animals alive. ");
INSERT INTO engPEV_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","And you have to do the same thing for all those different sorts of birds. Get one male and one female of all of those birds. And you have to do the same thing for all those animals that crawl around on the ground. You have to get one male and one female of all those animals too. I will get 2 of every sort of animal to come to you, so you can keep them alive. ");
INSERT INTO engPEV_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","And you have to gather up lots of food, all the sorts of food that people eat, and all the things that animals eat too. You have to put it all in the boat, so that you will all have enough food.” ");
INSERT INTO engPEV_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Then Noah did all of that. He did everything that God told him to do. ");
INSERT INTO engPEV_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","After that, God said to Noah, “You are the only man that lives the right way. Get your family and take them into the big boat. ");
INSERT INTO engPEV_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","You have to take every sort of animal with you into that big boat. You know the sorts of animals that are right for you to give to me? Well, get 7 males and 7 females from each of those sorts of animals. And get all the other animals too, the animals that are not right to give to me. Get one male and one female from each of those sorts of animals. They all have to go on to the big boat. ");
INSERT INTO engPEV_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","And the birds too. They have to go on to the big boat. Get 7 males and 7 females from each sort of bird. That’s how you can keep those birds and animals alive, so that there will always be birds and animals on the earth. ");
INSERT INTO engPEV_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","You see, I’m going to send a big rain. That rain will come in 7 days time. Then it will keep on raining all the time for 40 days. The flood water will come up and wash away all the things that I have made.” ");
INSERT INTO engPEV_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","So Noah did everything just the way God told him to. ");
INSERT INTO engPEV_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","7","Noah was 600 years old at the time that he went into the big boat to be safe from the flood. Noah, and his wife, and his 3 sons, and their wives too, they all went into the big boat. ");
INSERT INTO engPEV_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","And a big mob of animals came to Noah, and he took them into the boat too, just like God told him to. There were all sorts of animals. There were animals that were the right sort to give to God, and animals that were not the right sort to give to God. And there were birds and even animals that crawl around on the ground. And there were males and females of each sort of animal, and they went in 2 at a time. They all came together on that big boat, just like God wanted them to. ");
INSERT INTO engPEV_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Then, 7 days later, the flood water came, just like God said. ");
INSERT INTO engPEV_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","16","Noah was 600 years old at the time that the flood water came. It came on the 17th day of the 2nd month of that year. Noah, and his wife, and his sons, and their wives too, they all went into the big boat. The names of Noah’s sons were Shem, and Ham, and Jafeth, and they each had a wife. They all went into the boat with all the animals. There were wild animals, and animals that are not wild, and animals that crawl around on the ground. And all the birds were there too. There were males and females of every bird and animal on that big boat. All of the different sorts of animals went into that big boat with Noah. They went in 2 at a time, just like God told Noah. And after the last animal went into the boat with Noah and his family, God shut the door. Then, on that same day, the rain came out of the sky. It rained really hard all the time. It was like God opened up a big window in the sky, and rain poured down. And water came up from springs, and from everywhere under the ground too. It kept on raining all the time for 40 days. ");
INSERT INTO engPEV_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","The flood water kept on getting higher and higher for all those 40 days, and the big boat started to float on the water. ");
INSERT INTO engPEV_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","The water got deeper and deeper, but that boat was all right, it floated on top of the water, high above the ground. ");
INSERT INTO engPEV_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","The water got so deep that it covered all the big mountains everywhere. ");
INSERT INTO engPEV_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","It covered the tops of those mountains with about 7 metres of water. ");
INSERT INTO engPEV_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","All the people and animals that lived on the earth died. Only the people and animals on that big boat didn’t die. The flood water killed all the birds, and it killed all the animals, the wild animals and the animals that are not wild, and it killed all the animals that crawl around on the ground, and all the people. ");
INSERT INTO engPEV_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","They all died, everything that breathed air and lived on the ground. ");
INSERT INTO engPEV_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","There were no people or animals left on the earth. There were no birds, and no animals that crawl around on the ground, and no other animals, and no people. God killed them all and washed them away. The only ones that stayed alive were the animals and birds on the big boat with Noah and his family. ");
INSERT INTO engPEV_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","And that flood went on for a long time. The water covered the earth for 5 months. ");
INSERT INTO engPEV_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","And then God thought about Noah and the animals with him in that big boat. And he made a strong wind blow on the flood water to help it to go down. ");
INSERT INTO engPEV_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","And God stopped the water from coming up from under the ground, and he stopped the rain falling from the sky. ");
INSERT INTO engPEV_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","The flood water went down slowly, and after 5 months it was a lot lower. ");
INSERT INTO engPEV_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","So 5 months after the start of the flood, the big boat got stuck in the mountains called the Ararat mountains. ");
INSERT INTO engPEV_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","The flood water kept going down for the next 2½ months, and then they saw the tops of the mountains, sticking up out of the water. ");
INSERT INTO engPEV_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Then, 40 days later, Noah opened a window in the big boat. He wanted to find out if the water went down, and if a bird could find some dry ground. ");
INSERT INTO engPEV_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","So he let a crow go out of the window. The crow didn’t come back to the big boat. It just kept on flying around until the flood waters dried up. ");
INSERT INTO engPEV_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","9","So Noah let a pigeon go out of the window. But the flood water still covered the ground, and the pigeon couldn’t find a place to stop and rest, so it went back to the big boat. Noah held out his hand for the bird, and he helped it back into the boat. ");
INSERT INTO engPEV_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noah waited for 7 more days, and then he let the pigeon go out of the boat again. ");
INSERT INTO engPEV_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","This time the pigeon came back just before night time. It had a fresh leaf from an olive tree in its mouth. Then Noah knew the flood water was getting lower, and the trees were growing again. ");
INSERT INTO engPEV_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Noah waited 7 more days, then he sent the pigeon out again. This time the pigeon didn’t come back to the big boat. ");
INSERT INTO engPEV_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noah was 601 years old at that time. The water was still going down, and on the 1st day of the new year, Noah took off some of the roof from the big boat and looked around. He could see that the ground was getting dry. ");
INSERT INTO engPEV_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","After another 2 months, the earth was dry. ");
INSERT INTO engPEV_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Then God said to Noah, ");
INSERT INTO engPEV_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“You can go out of the big boat now. You can all go out, you, and your wife, and your sons, and their wives too. ");
INSERT INTO engPEV_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","And bring all the animals out of the big boat. Bring out all the animals, and the birds, and the animals that crawl around on the ground. They can all come out, so they can live on the earth and have lots of young ones, so that they will go everywhere on the earth.” ");
INSERT INTO engPEV_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","19","So Noah, and his wife, and his sons, and their wives, they all came out of the big boat. And all the animals and all the birds came out of the big boat too. They came out in groups. Each sort of animal was in its family group. ");
INSERT INTO engPEV_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Then Noah piled up stones to make a special table with a flat top, and he got one of each sort of animal and bird that are the right sorts to give to God, and he killed them, and he put them on that special table, and he burned them there. He did that to give them to God, to say thank you to God. ");
INSERT INTO engPEV_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","22","God smelled the meat cooking on that stone table, and he was happy. Then God said to himself, “People always just want to do bad things. They do that all their lives, from when they are little kids, right up until the time they die. But I will never again punish them the same way that I did this time. I will never again finish up everything that breathes air, and I will never again curse the earth. While the earth is still here, the seasons will stay the same. There will always be day and night, and every year there will be a hot time and a cold time, a wet season and a dry season. There will always be a right time to plant seeds for food, and a right time to get the food from those plants.” ");
INSERT INTO engPEV_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","God was good to Noah and his sons. God said to them, “I want you to have lots of kids, and fill the earth with people. ");
INSERT INTO engPEV_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","I’m making you boss over everything that lives on the ground, all the animals and all the birds, and I’m making you boss over the fish and everything in the sea too. They will be frightened of you. ");
INSERT INTO engPEV_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","I gave you bush tucker to eat, and now I’m giving you meat to eat too. You can eat anything that moves. ");
INSERT INTO engPEV_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","But I’m telling you this about blood. Blood is important. It keeps a body alive. So don’t eat any blood. You have to drain the blood out of the animal before you eat it. Don’t eat any meat that still has the blood in it. ");
INSERT INTO engPEV_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","And I will punish anyone and anything that kills a person dead. If an animal kills somebody, it has to die. And it is the same for a person that kills another person, that murderer has to die. ");
INSERT INTO engPEV_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","You see, I made people to be like myself, so they are important. So if somebody kills another person dead, you have to kill that murderer dead. ");
INSERT INTO engPEV_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","But I want you mob to have lots of kids, so that there will be lots of people everywhere on the earth.” ");
INSERT INTO engPEV_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Then God told Noah and his sons, ");
INSERT INTO engPEV_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“I promise this to you and to your kids, and to all the people that will be born later on. ");
INSERT INTO engPEV_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","And I promise this to all the animals that live on the earth too, all the birds, and all the wild animals, and all the animals that are not wild. I promise this to all of the animals that came out of the big boat with you. ");
INSERT INTO engPEV_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","I promise that there will never again be a real big flood of water that will finish up everything on the earth. There will never again be a big flood that kills all the people and animals.” ");
INSERT INTO engPEV_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","And God said, “I will give you something to help you remember what I promised to you, and to all of the animals living on the earth, and to your kids, and to all the people that will be born later on. ");
INSERT INTO engPEV_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","It is my rainbow, up there in the sky. I’m putting it there to help you remember what I promised to you, and to everything that lives on the earth. I promised that I will never again send a real big flood to finish up everything on the earth. ");
INSERT INTO engPEV_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Sometimes I will send rain clouds into the sky, and there will be a rainbow in the clouds too. ");
INSERT INTO engPEV_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Then I will remember what I promised to you, and to all the living animals. And there will never again be a flood that will kill all of the animals on the earth. ");
INSERT INTO engPEV_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Every time I look at the rainbow in the clouds, I will remember what I promised to you, and to all the animals on the earth. I will never break that promise. It will last for ever.” ");
INSERT INTO engPEV_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","And God said to Noah, “This is very important. That rainbow will help you remember that I myself promised that for every living thing.” ");
INSERT INTO engPEV_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","19","Noah had 3 sons. Their names were Shem, and Ham, and Jafeth. They were on the boat with Noah, and after they got off the boat, they had their own sons and daughters. One of Ham’s sons was called Canaan, and there were lots of other sons and daughters too. And later, all those kids had more kids, and it kept going like that. All the people in the world are from Noah’s family. ");
INSERT INTO engPEV_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Soon after Noah came out of the big boat, he started growing a garden. He planted some grape vines, and they grew some grapes. Then he made some wine from those grapes. ");
INSERT INTO engPEV_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Noah drank some of that wine and got drunk. He took his clothes off and went to sleep in his tent. ");
INSERT INTO engPEV_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham (Canaan’s father) went into the tent and saw his naked father. Ham didn’t respect his father, so he went outside and told his brothers what happened. ");
INSERT INTO engPEV_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Shem and Jafeth got a coat. They held it over their shoulders and walked backwards into the tent. They put the coat on their father to cover his naked body. They didn’t turn around and look at their naked father. ");
INSERT INTO engPEV_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","After Noah woke up, he found out what Ham, his youngest son, did to him. ");
INSERT INTO engPEV_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Then Noah said, “I’m going to curse Canaan, Ham’s son. He will have to work hard for his relatives, without pay. ");
INSERT INTO engPEV_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","God is good. I’m going to ask God to look after Shem, but Canaan will work hard for him with no pay. ");
INSERT INTO engPEV_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","I’m going to ask God to give Jafeth a big country. Jafeth and Shem will share that country, and Canaan will work hard for them with no pay.” ");
INSERT INTO engPEV_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noah lived for another 350 years after the flood. ");
INSERT INTO engPEV_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","He died when he was 950 years old. ");
INSERT INTO engPEV_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","This is the story about Noah’s sons and their families. His sons were Shem, and Ham, and Jafeth, and after that big flood, they had kids too. ");
INSERT INTO engPEV_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","5","A long time later, the people that were born into Jafeth’s family split up into different tribes and nations. Each tribe had their own language, and their own country. Jafeth’s sons were Gomer, and Magog, and Madayi, and Javan, and Tubal, and Meshek, and Tiras. The tribes that were from Jafeth’s son Gomer and his family were the Ashkenaz mob, and the Rifath mob, and the Togarmah mob. The tribes that were from Jafeth’s son Javan and his family were the Elishah mob, and the Tarshish mob, and the Kit mob, and the Rodan mob. Javan’s people lived near the sea. ");
INSERT INTO engPEV_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","The people that were born into Ham’s family split up into different tribes too, and each tribe had their own language, and their own country. Ham’s sons were Cush, and Egypt, and Put, and Canaan. ");
INSERT INTO engPEV_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","The tribes that were from Ham’s son Cush and his family were the Seba mob, and the Havilah mob, and the Sabtah mob, and the Ramah mob, and the Sabteca mob. And the tribes that were from Ramah and his family were the Sheba mob, and the Dedan mob. ");
INSERT INTO engPEV_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","One of the men that was born into Cush’s family was called Nimrod. After he grew up, he became a strong fighter. ");
INSERT INTO engPEV_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","He was the best hunter in the world too. Whenever people talked about good hunters, they said things like this, “That man is a really good hunter. He is just like Nimrod, the best hunter in the world.” ");
INSERT INTO engPEV_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimrod controlled the country called Babylonia, and he was the boss over the cities called Babel, and Erek, and Akad. ");
INSERT INTO engPEV_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","After that, Nimrod got the country called Ashur, and he built the towns called Nineveh, and Rehoboth-Ir, and Calah. ");
INSERT INTO engPEV_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Then he built a big town called Resen. It was between Nineveh and Calah. ");
INSERT INTO engPEV_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","The tribes that were from Ham’s son Egypt and his family were the Lud mob, and the Anam mob, and the Lehab mob, and the Naftuh mob, ");
INSERT INTO engPEV_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","and the Pathrus mob, and the Casluh mob, and the Caftor mob. (Later the Philistia nation were from the Caftor mob.) ");
INSERT INTO engPEV_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ham’s youngest son was called Canaan. Canaan had 2 sons. His 1st son was called Sidon, and his other son was called Heth. ");
INSERT INTO engPEV_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","The tribes that were from Canaan and his family were the Jebus mob, and the Amor mob, and the Girgash mob, ");
INSERT INTO engPEV_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","and the Hiv mob, and the Arek mob, and the Sin mob, ");
INSERT INTO engPEV_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","19","and the Arvad mob, and the Zemar mob, and the Hamath mob. All those tribes were from Canaan, and they went as far north as the town called Sidon, and as far south as the town called Gaza, and as far east as the towns called Sodom, and Gomorrah, and Admah, and Zeboyim, near Lasha. ");
INSERT INTO engPEV_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","They were all the tribes and nations that were from Ham and his family. Each tribe had their own country, and their own language. ");
INSERT INTO engPEV_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shem was Jafeth’s older brother. The Eber mob are from Shem’s family. ");
INSERT INTO engPEV_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Shem’s sons were Elam, and Ashur, and Arfaxad, and Lud, and Aram. ");
INSERT INTO engPEV_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","The tribes that were from Shem’s son Aram and his family were the Uz mob, and the Hul mob, and the Gether mob, and the Mash mob. ");
INSERT INTO engPEV_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Shem’s son Arfaxad had a son called Shelah, and he had a son called Eber. ");
INSERT INTO engPEV_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber had 2 sons. The 1st son was called Peleg, and his younger brother was called Joktan. That name Peleg means split up. He got that name because all the people split up into different tribes after he was born. ");
INSERT INTO engPEV_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","The tribes that were from Eber’s son Joktan’s family were the Almodad mob, and the Shelef mob, and the Hazarmaveth mob, and the Jerah mob, ");
INSERT INTO engPEV_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","and the Hadoram mob, and the Uzal mob, and the Diklah mob, ");
INSERT INTO engPEV_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","and the Obal mob, and the Abimayel mob, and the Sheba mob, ");
INSERT INTO engPEV_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","and the Ofir mob, and the Havilah mob, and the Jobab mob. ");
INSERT INTO engPEV_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","All of those people were born into Joktan’s family. Their country was in the mountains in the east, the country you see if you go from Mesha all the way to Sefar. ");
INSERT INTO engPEV_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","They were all the tribes and nations that were from Shem’s family. Each tribe had their own country, and their own language. ");
INSERT INTO engPEV_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","That is the big list of all the families and tribes that were born into Noah’s family. They split up into their own nations, and they went everywhere after the big flood. ");
INSERT INTO engPEV_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","You know, at first everyone talked the same language. ");
INSERT INTO engPEV_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","And as people moved from place to place in the east, they got to some flat country in Babylonia, and they stayed there. ");
INSERT INTO engPEV_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Then they said to each other, “Look, we can make bricks here. So come on, let’s do that. We will bake them properly so that they are good strong bricks, and we will use them to build a city here. So come on, let’s build a big tall building in that city. It will be so tall that it will go right up into the sky.” You see, they had bricks and tar instead of stones and cement. And they said, “If we do that, everyone will think we are smart. Then we will not go and live all over the earth, but we will stay together right here.” ");
INSERT INTO engPEV_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","So the people started to build a city and a really tall building, and God came down to look at those things. ");
INSERT INTO engPEV_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","He said, “These people can all talk to each other in the same language, so they can do anything they want. If they keep on going this way, nothing will stop them from doing anything. ");
INSERT INTO engPEV_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Come on, let’s go down to these people, and we will make them talk in different languages. Then they will not understand each other, and they will be all mixed up. They will not work things out with each other, so they will not keep on building this city.” ");
INSERT INTO engPEV_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","So God made all the people talk in different languages. None of them could understand anything the other people were saying. So they stopped building their big city. ");
INSERT INTO engPEV_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","They all left that city and went to live in lots of different places, all over the world. That’s how God got people to be in different tribes all over the world. And they called that city Babel. That means mixed up. They gave it that name because God mixed up their languages at that time. ");
INSERT INTO engPEV_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","This is the story about Shem’s family. Shem was 100 years old when he had a son called Arfaxad. That was 2 years after the big flood. ");
INSERT INTO engPEV_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Shem lived for 500 years after he had Arfaxad, and he had more sons and daughters. ");
INSERT INTO engPEV_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaxad was 35 years old when he had a son called Shelah. ");
INSERT INTO engPEV_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arfaxad lived for 403 years after he had Shelah, and he had more sons and daughters. ");
INSERT INTO engPEV_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shelah was 30 years old when he had a son called Eber. ");
INSERT INTO engPEV_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Shelah lived for 403 years after he had Eber, and he had more sons and daughters. ");
INSERT INTO engPEV_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber was 34 years old when he had a son called Peleg. ");
INSERT INTO engPEV_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eber lived for 430 years after he had Peleg, and he had more sons and daughters. ");
INSERT INTO engPEV_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg was 30 years old when he had a son called Reyu. ");
INSERT INTO engPEV_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peleg lived for 209 years after he had Reyu, and he had more sons and daughters. ");
INSERT INTO engPEV_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reyu was 32 years old when he had a son called Serug. ");
INSERT INTO engPEV_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Reyu lived for 207 years after he had Serug, and he had more sons and daughters. ");
INSERT INTO engPEV_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug was 30 years old when he had a son called Nahor. ");
INSERT INTO engPEV_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serug lived for 200 years after he had Nahor, and he had more sons and daughters. ");
INSERT INTO engPEV_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor was 29 years old when he had a son called Terah. ");
INSERT INTO engPEV_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahor lived for 119 years after he had Terah, and he had more sons and daughters. ");
INSERT INTO engPEV_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terah had 3 sons after he was 70 years old. Their names were Abram, Nahor and Haran. ");
INSERT INTO engPEV_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","This is the story about Terah’s family. Terah had 3 sons, called Abram, and Nahor, and Haran. Haran had a son called Lot. ");
INSERT INTO engPEV_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","29","And he also had 2 daughters called Milcah and Iscah. After that, Haran died, while his father Terah was still alive. He died in the town called Ur, in Chaldia country, the place where he was born. Nahor, Haran’s brother, married Milcah. And Abram married a woman called Sarai, ");
INSERT INTO engPEV_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","but Abram and Sarai didn’t have any kids. Sarai just couldn’t have a baby. ");
INSERT INTO engPEV_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Then Terah went away from Ur, in Chaldia country, and he took some of his family with him. They were his son Abram, and Abram’s wife Sarai, and his grand-son Lot. They all left Ur, and they started to go to the country called Canaan. But they stopped half-way, at a town called Haran, and they stayed there. ");
INSERT INTO engPEV_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah lived until he was 205 years old. Then he died there in Haran. ");
INSERT INTO engPEV_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","This story about Abram started when God said to him, “Abram, I want you to leave your country, your father’s family and all your relatives, and go to the country that I will show you. ");
INSERT INTO engPEV_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","And I will give you a big family, and they will become a great nation, and I will do good things for you and your family, and I will make your mob strong. Then everyone will know about you and your family, and everyone will respect you. And you and your family will do good things for other people. ");
INSERT INTO engPEV_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","If anyone does good things for you and your family, I will do good things for them. But, if anyone does bad things to you, and if they make trouble for you and your family, I will curse them and make trouble for them. I will use your family to do good things for all the families in the world.” ");
INSERT INTO engPEV_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Abram was 75 years old when he left the town called Haran and went to the country called Canaan. That was the country that God told him to go to. He took his wife Sarai, and his nephew Lot with him. He also took all the things and all the workers that they got in Haran, and they all went to the new country called Canaan. ");
INSERT INTO engPEV_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram and everyone with him walked through that new country, and they went to a town called Shekem, and they camped there, near a big tree at a place called Moreh. The people that lived in that country were called the Canaan mob, and they didn’t know God. ");
INSERT INTO engPEV_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","God showed himself to Abram there, and God said to him, “I will give this country to your son, and to all the people that will be born into his family later on.” So Abram piled up stones to make a table with a flat top. It was a special place for him to burn animals to show right respect to God. ");
INSERT INTO engPEV_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Later on, Abram and his mob left Shekem, and they went south to the hill country that was on the east side of a town called Bethel, and they camped between Bethel and another town called Ayi. Bethel was to the west of his camp and Ayi was to the east. Then Abram piled up stones there to make another special table, and he burned animals on it to show respect to God. He prayed to God, and he called God by his special name Yahweh. ");
INSERT INTO engPEV_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","After that, Abram and his mob kept going south to the dry desert country. ");
INSERT INTO engPEV_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","At that time, there was no rain and no food plants growing in that country. Nobody had enough food, so Abram and everyone with him went south to live in another country, called Egypt. ");
INSERT INTO engPEV_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Just before they got to Egypt, Abram said to his wife Sarai, “You are a really beautiful woman. ");
INSERT INTO engPEV_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","I reckon the men in Egypt will see you, and they will say, ‘That beautiful woman is Abram’s wife. Let’s kill Abram, so that we can have her for ourselves.’ Then they will kill me, but they will let you live. ");
INSERT INTO engPEV_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","So listen. You have to tell everyone that you are my sister. Then they will be good to me, and they will not kill me.” ");
INSERT INTO engPEV_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","And that’s what happened. They got to Egypt, and the people there looked at Sarai, and they saw that she was really beautiful. ");
INSERT INTO engPEV_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Some of them worked for the big boss of Egypt, and they told him, “Sarai is really beautiful.” So that big boss took her to live in his house. ");
INSERT INTO engPEV_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","That boss was very good to Abram, because he thought that Abram was Sarai’s brother. He gave Abram sheep, and goats, and cows, and bulls, and donkeys, and camels, as well as men and women that had to work for Abram. ");
INSERT INTO engPEV_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","God was not happy, because Sarai was living with the big boss of Egypt, so God made him really sick, and God made everyone that lived in his house really sick too. ");
INSERT INTO engPEV_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","19","Then that big boss found out that Sarai was already Abram’s wife, and he got really wild. He sent somebody to get Abram, and he said to Abram, “You did a really bad thing to me. You tricked me. You didn’t tell me that Sarai is your wife. You said, ‘She is my sister,’ and you let me marry her. Now, here is your wife. Take her back, and then get out of my country.” ");
INSERT INTO engPEV_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Then the big boss told his soldiers, “Get Abram, and Sarai, and everything they own, and all their workers, and send them out of Egypt. Send them away, and do it right now.” So his soldiers did that. They sent Abram and his mob away from Egypt. ");
INSERT INTO engPEV_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","So Abram, Sarai, and Lot left Egypt and went back to the dry desert country. They took everything they owned, and all their workers. ");
INSERT INTO engPEV_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram was a very rich man. He had a lot of silver and gold, and a big mob of animals. ");
INSERT INTO engPEV_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","They were in that dry desert country for a while, then they went north from place to place until they got back to the town called Bethel. They camped in the same place that they camped at before. It was between Bethel and the town called Ayi. ");
INSERT INTO engPEV_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","That was the place where Abram built a special stone table to burn animals, to show respect to God. After Abram got back there, he prayed to God, and he called God by his special name Yahweh. ");
INSERT INTO engPEV_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Abram and his nephew Lot were still together. And Lot also had a big mob of sheep, and goats, and cows, and bulls. And he had a lot of tents for all his workers too. ");
INSERT INTO engPEV_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","But there was a problem. There were other people already living in that country. They were called the Canaan mob, and the Periz mob. And they had animals too, and all those animals needed grass and water, as well as Abram’s animals, and Lot’s animals too. But there wasn’t enough grass and water in that place for all those animals. So Abram’s work-men and Lot’s work-men started to argue and fight with each other about whose animals got the grass and water. ");
INSERT INTO engPEV_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Then Abram said to Lot, “I don’t like this trouble. You and me, we are family, and I don’t want trouble between us. And I don’t want our work-men to argue and fight with each other. ");
INSERT INTO engPEV_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Look, there is a lot of country here. Just look around, and you will see that there’s plenty of country for both of us. So I reckon we have to split up. I want you to pick the part of the country you want, and then I will go somewhere else. If you pick the country to the east, then I will go to the country to the west, but if you pick the west country, then I will go to the east country.” ");
INSERT INTO engPEV_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot looked to the east, towards a town called Zoar, in the flat country around the Jordan River. He saw that the flat country had plenty of grass and water. It looked just like God’s garden, and like the country in Egypt. (That was before God burned up the towns in the flat country called Sodom and Gomorrah.) ");
INSERT INTO engPEV_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","12","So Lot picked the flat country around the Jordan River, to the east. Then Abram did what he promised, and he went to the country called Canaan. In that way, Lot’s mob and Abram’s mob went to different places, and there was no more trouble between their work-men. Lot went to the flat country around the Jordan River. There were some towns there, and Lot camped near the town called Sodom. ");
INSERT INTO engPEV_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","The people that lived in Sodom were very bad. They were always going against God, and they did bad things all the time. ");
INSERT INTO engPEV_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Then, after Lot left, God said to Abram, “Look at all the country around you. Look to the north, and to the south, and to the east, and to the west. ");
INSERT INTO engPEV_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","I will give you all the country that you can see. Later on, you will have a son, and lots of people will be born into his family, and they will own all this country, for ever. ");
INSERT INTO engPEV_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Look at the ground you are standing on, it has lots of little bits of dirt. Nobody can count all those little bits of dirt on the ground, and just like that, nobody will be able to count all the people that will be in your family later on. ");
INSERT INTO engPEV_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","All right, Abram, I want you to get up and walk all around the country that I’m giving you, and look at it all properly.” ");
INSERT INTO engPEV_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","So Abram went to the big trees that belonged to a man called Mamreh, near a town called Hebron, and he camped there. He piled up stones there and made another special table with a flat top, so that he could burn animals to show respect to God. ");
INSERT INTO engPEV_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","9","This story is about the people in the flat country, and it started before Lot went to live near the town called Sodom. There were 5 tribes in that flat country at that time, and each tribe had a leader. These were the 5 tribes and their leaders, – A tribe called Sodom, and their leader was called Bera. – A tribe called Gomorrah, and their leader was called Birsha. – A tribe called Admah, and their leader was Shinab. – A tribe called the Zebo mob, and their leader was Shemeber. – A tribe called Zoar. They are also called Bela. There were another 4 tribes in the country to the east. These were those 4 tribes and their leaders, – A tribe called Elam, and their leader was Kedorlayomer. – A tribe called Babylonia, and their leader was called Amrafel. – A tribe called Ellasar, and their leader was called Ariok. – A tribe called the Goy mob, and their leader was Tidal. And Kedorlayomer was the boss over those 4 tribes in the east. Those 4 tribes sent their soldiers to fight the other 5 tribes, and the 4 tribes from the east won. So Kedorlayomer became the boss over the other 5 tribes too. Those 5 tribes let him be their boss for 12 years. Then the next year, their leaders told Kedorlayomer that they didn’t want him to be their boss any more. Kedorlayomer got really angry, and the next year, he got soldiers from the 4 tribes in the east, and they went to fight those 5 tribes. On the way to that fight, Kedorlayomer’s soldiers had other fights with some other tribes, and they won all those fights. They beat the Refa tribe at a place called Ashteroth-Karnayim, and they beat the Zuz tribe at a place called Ham, and they beat the Em tribe at a place called Shaveh-Kiriathayim, and they beat the Hor tribe in the hill country called Edom. They chased the Hor soldiers all the way to a place called El-Paran, near the desert. Then Kedorlayomer and the soldiers from the east, they all went back to a place called En-Mishpat. Another name for that place is Kadesh. Then Kedorlayomer and his mob fought the Amalek tribe and beat them, and took control of their country. Then they fought the Amor tribe in Hazazon-Tamar country, and beat them too. While Kedorlayomer and his mob were fighting those other people, the 5 tribes that didn’t want Kedorlayomer to be their boss, they went to the valley called Sidim. (Today there is salt water in that valley, and we call it the Dead Sea.) The soldiers of those 5 tribes got ready there to fight against Kedorlayomer and his 4 tribes from the east. So when Kedorlayomer and his mob got to that Sidim valley there was a big fight. ");
INSERT INTO engPEV_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Kedorlayomer and his mob won that fight. They beat those 5 tribes, and their soldiers all ran away. In that flat country there were lots of holes in the ground that were full of sticky black stuff, called tar. So when the soldiers from the 5 tribes ran away, some of them fell into those holes. But the rest of them ran up into the hills. ");
INSERT INTO engPEV_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","So Kedorlayomer and his soldiers went to Sodom and Gomorrah, and they grabbed all the people that lived there. And they took everything the people owned, even their food, and then they started to go back to their own country. ");
INSERT INTO engPEV_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","At that time, Abram’s nephew Lot lived in Sodom, so the soldiers grabbed Lot too, and his family, and all their things. Those soldiers took all of Lot’s mob away with them. ");
INSERT INTO engPEV_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","14","A man got away from Kedorlayomer and his mob, and he went and told Abram that they got Lot. At that time, Abram was living near the big trees that belonged to a man called Mamreh. Abram was a good friend of Mamreh, and also of Mamreh’s 2 brothers. Their names were Eskol and Aner. Mamreh and his brothers belonged to the Amor tribe, and Abram belonged to the Hebrew tribe, but they all looked after each other. Abram had 318 men that knew how to fight. They worked for Abram all their lives, and Abram really trusted them. So Abram got those men, and Mamreh, Eskol and Aner got their fighting men, and they all went to fight Kedorlayomer and his soldiers. They followed them, and they found them at a place to the north, called Dan. ");
INSERT INTO engPEV_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Then, in the night time, Abram split up all the fighting men into groups, and they attacked Kedorlayomer and his soldiers. Abram and his men won that fight, and they chased those other soldiers all the way to a town called Hobah, north of Damascus town. ");
INSERT INTO engPEV_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","That’s how Abram’s mob saved Lot, and all the women, and the other people from the towns called Sodom and Gomorrah, and they got all their things too. Then they all started to go back south. ");
INSERT INTO engPEV_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","After Abram’s mob beat Kedorlayomer and his mob, and while they were going back south on their way home, the leader of Sodom went out to meet Abram in the valley called Shaveh. Another name for that place is the valley that belongs to the leader. ");
INSERT INTO engPEV_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","There was a town in that country called Salem, and the boss over that town was called Melkizedek. He was also a leader of God’s ceremonies. He worked for God, the one that is more powerful than any other god. Well, Melkizedek also went out to meet Abram and his men, and he gave them some bread and some wine. ");
INSERT INTO engPEV_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Then Melkizedek prayed for Abram. He said, “God, you are more powerful than any other god. You are the one that made heaven and earth. I’m asking you to be really good to Abram. ");
INSERT INTO engPEV_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","I want everyone to say that you are great, and more powerful than any other god. You are the one that helped Abram fight with his enemies and win.” Then Abram got all the things he got after the fight, the things that used to belong to the Sodom and Gomorrah mob, and he split those things up into 10 groups. And he gave one of those groups of things to Melkizedek. ");
INSERT INTO engPEV_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Then the leader of Sodom said to Abram, “I only want my people back. You can keep those other things.” ");
INSERT INTO engPEV_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","But Abram said, “I made a strong promise to my God. His name is Yahweh. He is more powerful than any other god, and he made heaven and earth. ");
INSERT INTO engPEV_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","I promised that I will not take anything that belongs to you. I will not even take a bit of string, or anything that belongs to you. You see, I don’t want you to tell everyone that you gave me a lot of things and made me rich. ");
INSERT INTO engPEV_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","No. The only thing that I will keep is the food that I ate and the food that my fighting men ate. And these men, Mamreh, and Aner, and Eskol, and their fighting men, they helped me save your people and your things too, so you can give them some of those things.” ");
INSERT INTO engPEV_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Later on, after Abram saved Lot, Abram had a dream, and God talked to him in that dream. God said, “Abram, don’t be frightened, I will always keep you safe, so that nobody can ever hurt you, and I am going to give you lots of good things.” ");
INSERT INTO engPEV_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Then Abram talked to God, and he called God by his special name Yahweh. He said, “Yahweh, you are very powerful. But look, I’ve got no son, so it doesn’t matter what you give me. You haven’t given me the one thing I really want. You haven’t given me any kids. So when I die, one of my work-men will get all my things. His name is Eliyezer. He is from Damascus.” ");
INSERT INTO engPEV_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Then Abram heard God talk to him again. God said, “I tell you, that work-man will not get all your things after you die. I am going to give you a son, and he will get all your things after you die.” ");
INSERT INTO engPEV_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Then God took Abram outside and said, “Look up at the sky and try to count all those stars. There are a lot of stars. You can’t count them all. Well, you will have a son, and later on lots of people will be born into his family, and later on they will be a real big family. And just like nobody can count the stars, nobody will be able to count all your family.” ");
INSERT INTO engPEV_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","And Abram believed what God said, so God was really happy with him, and told him, “You believe me, so now I’m saying you are properly good, like you never did anything wrong.” ");
INSERT INTO engPEV_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Then God said to Abram, “I am God, and my name is Yahweh. I am the one that brought you out of your home country, from the town called Ur, in Chaldia country. And I am going to give you this country here. It will be yours. You will own all this country.” ");
INSERT INTO engPEV_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abram said to God, “Yahweh, I know you are very powerful, but how can I be really sure that I will get all this country?” ");
INSERT INTO engPEV_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","So God said to Abram, “Bring me a cow that hasn’t had a baby, and a female goat, and a male sheep. All those animals have to be 3 years old. And I want you to bring me 2 different sorts of pigeons too.” ");
INSERT INTO engPEV_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Then Abram did what God told him. He killed those animals and birds, and he cut the animals in half. He put the halves of each animal on the ground in 2 lines facing each other. But he didn’t cut the birds in half. ");
INSERT INTO engPEV_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Then some hawks flew down and tried to eat the animals, but Abram chased them away. ");
INSERT INTO engPEV_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","While the sun was going down, Abram went to sleep. It was a strong deep sleep. Then Abram had something like a dream. It was really dark for him, and he felt really frightened. ");
INSERT INTO engPEV_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","15","God said to Abram, “I want you to know for sure what will happen after you get really old. You don’t have to worry about anything. You see, you will live to be a very old man, and then, when you are dying, you will feel good inside, and your family will bury you right here, in this country. But I have to tell you something. After you die, your family will leave this country and move to another country that belongs to other people. Your family will live in that country, and later on, the other people in that country will make your family like prisoners, and your family will have to work very hard for them. Those people will do really bad things to your family for 400 years. After that, I will save your family from that hard time, and I will punish those people for doing bad things to your family. Then your family will leave that country, and they will take a lot of animals and things with them. They will be really rich. ");
INSERT INTO engPEV_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","And I will bring your family back here to this country. You see, the Amor tribe that are here in this country now, they do really bad things, and they are getting worse and worse. But I will not punish them yet. I will punish them later, after your grand-kids grow up and have grand-kids. Then I will do payback to the mob in this country for the bad things that they do. I will take their country from them, and I will give it to your family.” That’s what God told Abram. ");
INSERT INTO engPEV_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","After the sun went down and it was dark, Abram saw a bucket full of fire, with smoke coming out of it, and he saw a burning stick with it. That bucket and stick moved along between the halves of those animals that Abram killed. ");
INSERT INTO engPEV_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","21","That’s how God showed Abram that he was really going to do everything that he promised. God said, “I am going to give all this country to the people that will be born into your family. From the river in Egypt in the south, right up to the big river called Euphrates in the north. These are the tribes in this country now, – the Ken tribe, – the Keniz tribe, – the Kadmon tribe, – the Heth tribe, – the Periz tribe, – the Refa tribe, – the Amor tribe, – the Canaan tribe, – the Girgash tribe, – the Jebus tribe. I will take this country away from all those tribes, and I will give it to your family.” God promised that to Abram. ");
INSERT INTO engPEV_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Abram and Sarai lived in that Canaan country, and after they were there for 10 years, they still had no kids. Sarai had a woman from Egypt working for her, called Hagar. She was Sarai’s slave. That means Sarai owned Hagar, and Hagar had to do everything that Sarai told her to do. Sarai was sad because she had no kids, but she got an idea about how to get a baby for herself. So she said to Abram, “God has stopped me from having my own kids. But listen. I want you to sleep with Hagar, like she is your wife. You see, she belongs to me, so if she has a baby, that baby will really belong to me.” So Abram did that, just like Sarai said. ");
INSERT INTO engPEV_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","He slept with Hagar like she was his wife. Then Hagar found out that she was going to have a baby, so she started rubbishing Sarai all the time, because Sarai didn’t have any kids. ");
INSERT INTO engPEV_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","So Sarai said to Abram, “I blame you for this trouble. I gave Hagar to you, and now she is going to have a baby, and she is rubbishing me all the time. I reckon God knows that I am right, and you are wrong.” ");
INSERT INTO engPEV_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","But Abram said to Sarai, “Hagar belongs to you. You are her boss, so do whatever you want with her.” Then Sarai started to treat Hagar in a really bad way. So Hagar left Abram and Sarai’s camp and ran away. ");
INSERT INTO engPEV_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Hagar started walking through the desert, along the road that went to a town called Shur, near Egypt. She sat down next to a water-hole there in the desert. God’s angel messenger went to her there. ");
INSERT INTO engPEV_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","He said, “Hagar, you belong to Sarai, so why are you sitting out here in the desert? Where are you going?” Hagar said, “I’m running away from my boss Sarai. She is too hard on me.” ");
INSERT INTO engPEV_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","God’s angel messenger said to her, “Don’t do that. Go back to your boss, and do what she says.” ");
INSERT INTO engPEV_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","And the angel also said, “God is going to give you a really big family. You will have a son, and later on lots of people will be born into his family, and they will be a real big family, so that nobody will be able to count all those people.” ");
INSERT INTO engPEV_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","The angel said, “You are going to have a baby boy, and you will name him Ishmael, because that name means God listens. You see, God listened to you. He heard about your trouble, and he will help you. ");
INSERT INTO engPEV_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","And Ishmael, your son, he will live like a wild donkey. He will go anywhere he wants to, and he will fight against everybody, and everybody will fight against him. He will not live close to his relatives.” ");
INSERT INTO engPEV_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Then Hagar said to herself, “I have seen the God that sees me, and he looks after me.” So she gave God a name, she called him the God that sees me. ");
INSERT INTO engPEV_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","So that’s why people call that water-hole the water-hole that belongs to the one that is alive and sees me. That water-hole is between a place called Kadesh and a place called Bered. ");
INSERT INTO engPEV_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Soon after that, Hagar had a baby boy, and Abram named him Ishmael. ");
INSERT INTO engPEV_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram was 86 years old at the time when Ishmael was born. ");
INSERT INTO engPEV_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Later on, when Abram was 99 years old, God showed himself to Abram and said, “I am God. I have power over everything. I want you to live my way and always do the right thing. ");
INSERT INTO engPEV_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","If you do that, I will make an agreement with you, and I will give you a really big family. You see, you will have a son, and later on lots of people will be born into his family, and they will be a real big family.” ");
INSERT INTO engPEV_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram got down on his knees and put his face near the ground, to show respect to God, and God said to him, ");
INSERT INTO engPEV_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“I promise that I will do this for you. I will give you a big family. Lots of people will be born into your family, so that you will be the father of lots of nations. ");
INSERT INTO engPEV_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","So I am changing your name from Abram to Abraham.” (That name Abram means father that people respect, and that name Abraham means father of lots of people.) And God said, “Yes, I will make you the father of lots of nations. ");
INSERT INTO engPEV_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","I will give you a real big family later on, and they will split up into lots of nations. And some of your people will be the big bosses of those nations. ");
INSERT INTO engPEV_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","I am making this agreement with you, and with the people that will be born into your family later on. This agreement will last for ever. It will never end. I promise that I will be your God for ever. ");
INSERT INTO engPEV_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","You see, you are now living in this country called Canaan, but it doesn’t belong to you. But later on, I will give all this country to the people that will be born into your family. They will have this country for themselves for ever, and I will be their God.” ");
INSERT INTO engPEV_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Then God said to Abraham, “You have to agree to this. You and everyone that will be born into your family later on, you mob have to always respect me and let me be your God. ");
INSERT INTO engPEV_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","11","This is what you have to do to show that we made this agreement together. You and every man in your camp has to have the young man operation. And all the men born into your family later on will have to have it too. ");
INSERT INTO engPEV_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","From now on, every baby boy in your camp has to have that young man operation 8 days after he is born. Every man in your family has to have that operation. And if you buy a man to work for you, he has to have that operation too. Every male person has to have that mark on his body. It will show that we made this agreement, you and me, and that this agreement will last for ever. ");
INSERT INTO engPEV_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Any man that doesn’t have that operation will be breaking our agreement, and I will take him away from your family.” ");
INSERT INTO engPEV_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Then God said to Abraham, “I am changing your wife’s name too. Don’t call her Sarai any more. Call her Sarah.” (Both of those names mean important woman.) ");
INSERT INTO engPEV_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","And God said, “I will do a good thing for her too. She will have a son, and you will be his father. Yes, I will do that good thing for her. Lots of people will be born into her son’s family, and they will split up into lots of nations. And some of those people will be the big bosses of those nations.” ");
INSERT INTO engPEV_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham got down on his knees again and put his face near the ground, and he laughed. He thought, “I am nearly 100 years old, and Sarah is nearly 90. We can’t have a baby. We are too old.” ");
INSERT INTO engPEV_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","So then Abraham said to God, “Look, I already have a son, Ishmael. I want you to be good to him, so that he will be that son you are talking about.” ");
INSERT INTO engPEV_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","God said, “No, not Ishmael. Listen, your wife Sarah will have a baby boy. He will be your son, and you will call him Isaac.” (That name Isaac means laugh.) And God said, “He will be the son I’m talking about. I will keep this agreement going with him. It will be the same for him, and for all the people that will be born into his family later on. This agreement will go on for ever. ");
INSERT INTO engPEV_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","And you asked me to do good things for Ishmael. Well, I listened to you, and I will be good to him too. He will have a big family, and later on, 12 big bosses will be in his family. I will make his mob into a great nation. ");
INSERT INTO engPEV_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","But my agreement will not be with Ishmael. You see, about this time next year, your wife Sarah will have a baby boy. He will be your son, and you will call him Isaac, and I will make the same agreement with him that I just made with you.” ");
INSERT INTO engPEV_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","After God said all that, he left Abraham. ");
INSERT INTO engPEV_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","Then, on that same day, Abraham did a young man operation on every man and every boy in his camp. All Abraham’s work-men had that operation. They were the work-men that Abraham bought, and the work-men that were born in his camp. And Abraham and his son Ishmael had that operation too. They all had that operation on the same day. Ishmael was 13 years old, and Abraham was 99 years old, when they had that young man operation. ");
INSERT INTO engPEV_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abraham camped for some time near the big trees that belonged to a man called Mamreh. One day, God came to Abraham there. It happened like this. Abraham was sitting in the doorway of his tent, at the hottest part of the day, ");
INSERT INTO engPEV_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","and he looked up and saw 3 men standing nearby. He got up quickly, and he ran to meet them, and he got down on his knees and put his face near the ground to show them respect. ");
INSERT INTO engPEV_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Abraham said, “Sirs, please come and sit at my place for a while. Let me look after you. ");
INSERT INTO engPEV_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","I will get a work-man to bring water so that you can wash your feet, and then you can rest in the shade of this tree. ");
INSERT INTO engPEV_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","And I will get some food for you, so that you will be strong enough to keep walking to the place where you are going. I really want to do that for you.” The 3 men said, “All right. We will rest here while you do that.” ");
INSERT INTO engPEV_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Then Abraham went quickly into the tent to tell Sarah, and he said, “Quick, get a big bag of really good flour and make some damper for our visitors.” ");
INSERT INTO engPEV_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Then he ran to his mob of cows and picked out a really good young cow. He gave it to one of his work-men and said, “Quick, kill this young cow, and cook it for our visitors.” ");
INSERT INTO engPEV_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Then Abraham gave the men that cooked meat, and some cheese and milk. And Abraham stood near them in the shade of that tree, and he looked after them while they ate that food. ");
INSERT INTO engPEV_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Then they said to Abraham, “Where is your wife, Sarah?” Abraham said, “She is right here, in our tent.” ");
INSERT INTO engPEV_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","You know, one of those men was God, but he made himself to be like a man when he talked to Abraham. He said, “I will come back to you at this time next year, and Sarah will have a baby boy.” Sarah was at the doorway of the tent, and she listened to them talking. ");
INSERT INTO engPEV_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham and Sarah were both very old. She knew she was too old to have a baby, ");
INSERT INTO engPEV_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","so when she heard him say that, she laughed quietly and said to herself, “I am too old and worn out to have a baby, and my good boss, my husband, he is old too. If I had a baby, I would be really happy. But I’m too old for that now.” ");
INSERT INTO engPEV_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","God said, “Why did Sarah laugh? Why did she say to herself, ‘I can’t have a baby now, I am too old’? ");
INSERT INTO engPEV_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","I’m telling you, nothing is too hard for me. I am God, and my name is Yahweh. Just like I said, at this time next year, I will come back, and Sarah will have a baby boy.” ");
INSERT INTO engPEV_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sarah was frightened, and so she lied and said, “I didn’t laugh.” But God said, “That’s not true. You did laugh.” ");
INSERT INTO engPEV_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Then the 3 men got up to leave, and Abraham went with them for a little while to say goodbye. They went to a hill where they looked down at the town called Sodom. ");
INSERT INTO engPEV_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","God said, “Maybe I will tell Abraham what I am going to do. ");
INSERT INTO engPEV_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","You know, Abraham’s family will be a big and powerful nation one day, and I will use his family to do good things for all the nations in the world. ");
INSERT INTO engPEV_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","I have picked him out so that he can teach his family to live my way, and do what is good and right. Then I will keep my promise to him.” ");
INSERT INTO engPEV_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","So God said, “Abraham, I heard about all the really bad things that people do in those 2 towns down there, called Sodom and Gomorrah. A lot of people are telling me that those people are always doing bad things. ");
INSERT INTO engPEV_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","I will go down and find out if they are really doing those bad things that I heard about.” That’s what the man said, the one that was God. ");
INSERT INTO engPEV_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Then the other 2 men turned and walked towards Sodom. They left Abraham standing in front of God. ");
INSERT INTO engPEV_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham went up close to God and asked him, “Are you going to kill all the good people, as well as the bad people? ");
INSERT INTO engPEV_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","There might be 50 good people that live the right way down there in that town. Will you still finish up that town? Or will you save that town to save those 50 good people? ");
INSERT INTO engPEV_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","I don’t think you will kill 50 good people. I know that you are the judge of everybody in the world, and you always do what is right. I don’t think you will kill the good people with the bad people.” ");
INSERT INTO engPEV_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","God said, “If I find 50 good people in Sodom, I will not finish up that town. I will save that town so that I can save those 50 good people.” ");
INSERT INTO engPEV_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Then Abraham said, “Look, I know that I am just a man and you are God, but I’m being brave and I’m talking to you. I want to ask you another question. ");
INSERT INTO engPEV_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","What if you find only 45 good people in that town, will you still finish up that town?” God said, “If I find 45 good people there, I will not finish up that town.” ");
INSERT INTO engPEV_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Then Abraham asked God again, he said, “What if you find only 40 good people there?” God said, “If I find 40 good people there, I will not finish up that town.” ");
INSERT INTO engPEV_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Then Abraham said, “God, please don’t get angry with me, but I will say a little bit more. What if you find only 30 good people in that town?” God said, “If I find 30 good people there, I will not finish up that town.” ");
INSERT INTO engPEV_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Then Abraham said, “I know that I am being brave to talk to God like this, but what if you find only 20 good people in that town?” God said, “If I find 20 good people there, I will not finish up that town.” ");
INSERT INTO engPEV_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Then Abraham said, “God, please don’t get angry with me, but I will ask one more question. What if you find only 10 good people in that town?” God said, “If I find 10 good people there, I will not finish up that town.” ");
INSERT INTO engPEV_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Then they finished talking, and God left Abraham, and Abraham went back to his camp. ");
INSERT INTO engPEV_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Later that day, while the sun was going down, those other 2 men walked into the town called Sodom. They were God’s 2 angel messengers. Abraham’s nephew, the man that was called Lot, he was sitting near the town gate, and he saw those men come into the town. So he got up to meet them, and he got down on his knees and put his face near the ground, to show them respect. ");
INSERT INTO engPEV_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","He said, “Sirs, come and stay in my house. You can wash your feet and sleep here tonight, then you can go on your way tomorrow morning.” The men said, “No, it’s all right. We will sleep outside in the park.” ");
INSERT INTO engPEV_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","But Lot kept on asking them strongly to stay with him, so they agreed, and they went with him to his house. Then Lot cooked some flat damper and other food for them, and the men ate it. ");
INSERT INTO engPEV_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Before they went to bed, all the men that lived in Sodom, both the young men and the old men, they came and stood around Lot’s house, ");
INSERT INTO engPEV_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","and they all yelled out to Lot. They said, “Where are the 2 men that came to your house today? Bring them out here so that we can sleep with them like a man sleeps with his wife.” ");
INSERT INTO engPEV_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot went out to talk to them and shut the door behind him. ");
INSERT INTO engPEV_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","He said, “My friends, please don’t do that really bad thing. ");
INSERT INTO engPEV_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Look, I’ve got 2 daughters. They have never been married. They have never slept with any man. Let me bring them out here for you, and you can do whatever you want to do with them. But please don’t do anything bad to these men. They are staying in my house, so I have to keep them safe.” ");
INSERT INTO engPEV_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","But the men of Sodom said to each other, “This man came from another town to live here, and he wants to tell us what to do. He can’t do that.” And they said to Lot, “Get out of our way, or we will do even worse things to you than we will do to those men.” And they pushed hard against Lot so they could get to the door, to break it down and grab the men that were inside. ");
INSERT INTO engPEV_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","But those 2 men were really God’s angel messengers, and they quickly opened the door and pulled Lot inside with them, then they quickly shut the door. ");
INSERT INTO engPEV_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Then they used their power to make all the men outside the house go blind, the young men as well as the old men, so that they couldn’t find the door to get in. ");
INSERT INTO engPEV_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Then the 2 men said to Lot, “God heard about all the bad things that the people in this town do, so he sent us to finish it up. You and your family have to get out of this town real soon. Maybe you have sons, or more daughters, or sons-in-law, or other family here. You all have to leave this town before we finish it up.” ");
INSERT INTO engPEV_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","So Lot went and found the men that his 2 daughters were promised to. He said to them, “God is going to finish up this town, so we have to get out now. Come on, let’s go.” But those 2 men thought that Lot was joking, so they didn’t go with him. ");
INSERT INTO engPEV_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Very early the next morning, the 2 angels tried to get Lot to leave Sodom quickly. They said, “Hurry up Lot. Get your wife, and your 2 daughters, and get out of this town. If you don’t get out quick, you will die, like everyone else.” ");
INSERT INTO engPEV_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","But Lot didn’t hurry, so the angels grabbed Lot’s hand, and his wife, and his 2 daughters, and they quickly pulled them out of the town. You see, God was good to Lot and wanted to save him and his family. ");
INSERT INTO engPEV_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","As soon as the angels took Lot and his family out of the town, one of the angels told them, “Run away quickly to save your life. Don’t look back, and don’t stop anywhere in the flat country, but keep going until you get to the hill country. If you don’t do that, you will die, like all the people in Sodom are going to die.” ");
INSERT INTO engPEV_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","But Lot said to them, “Please sirs, no. ");
INSERT INTO engPEV_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","That’s too far. You have been very good to me and saved my life, but I can’t run fast enough to get to the hill country in time. If I try to do that, the trouble will come before I get there, and I will die too. ");
INSERT INTO engPEV_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Look, there is a town over there. It’s not too far for me. And it is only a little town, with only a few people. Let us go there, and then don’t finish up that little town. Then we will be safe.” ");
INSERT INTO engPEV_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","The angel said, “All right, I will do that for you. I will let you go to that little town, and I will not finish it up. You will be safe there. ");
INSERT INTO engPEV_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","But go quickly, because I have to wait until you get there before I finish up Sodom.” Later, that little town was called Zoar. That name means little. ");
INSERT INTO engPEV_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Just after the sun came up, Lot got to Zoar. ");
INSERT INTO engPEV_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Then God sent fire down from the sky on to Sodom and Gomorrah, and he sent down burning rock, called sulphur, with that fire. ");
INSERT INTO engPEV_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","God burned up those towns, and he burned up the flat country around them too. Everybody that lived in those towns died, and all the plants in that country died too. ");
INSERT INTO engPEV_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","But Lot’s wife turned around and looked back at what was happening to Sodom, and straight away her body turned into a block of salt. ");
INSERT INTO engPEV_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Early in the morning, Abraham went to the hill where he talked with God before. ");
INSERT INTO engPEV_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","He looked down at Sodom and Gomorrah and all the flat country around them, and he saw a lot of smoke, like a really big bush fire. ");
INSERT INTO engPEV_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","That’s how God finished up those towns in the flat country, but he remembered everything he said to Abraham, and he saved Abraham’s nephew Lot. Yes, God took Lot out of Sodom, where Lot lived, before he finished up that town. ");
INSERT INTO engPEV_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot was frightened to stay in Zoar, so him and his daughters, they went and lived up in the hill country, in a big hole in the rock, called a cave. ");
INSERT INTO engPEV_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","One day the oldest daughter said to her sister, “Our father is old, and we haven’t got any kids, and there are no men around here for us to marry. ");
INSERT INTO engPEV_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","So let’s get our father drunk, and then we can pretend to be his wives, and sleep with him. Then we can have babies, so that we will always have a family.” ");
INSERT INTO engPEV_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","So that night, they got their father drunk, and the oldest daughter pretended to be his wife, and she slept with him. Lot was so drunk that he didn’t know what was happening. ");
INSERT INTO engPEV_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","The next day, the oldest daughter said to her sister, “Last night I slept with our father like I was his wife. Let’s get him drunk again tonight, then you go and pretend to be his wife. Then we will both have babies, and we will always have a family.” ");
INSERT INTO engPEV_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","So that night, they got their father drunk again, and the youngest daughter pretended to be his wife, and she slept with him. And again, Lot was so drunk that he didn’t know what was happening. ");
INSERT INTO engPEV_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","So both of Lot’s daughters had babies, and Lot was the father of those babies. ");
INSERT INTO engPEV_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Lot’s oldest daughter had a son, and she called him Moab. That name means from our father. His mob are called the Moab tribe, and they are still living today. ");
INSERT INTO engPEV_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Lot’s youngest daughter also had a son, and she called him Ben-Ammi. That name means son of my relative. Ben-Ammi’s mob are called the Ammon tribe, and they are still living today. ");
INSERT INTO engPEV_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","At one time, Abraham moved his camp south to the Negev desert, and he lived between the 2 towns called Kadesh and Shur. Then later, he moved his camp to a town called Gerar. ");
INSERT INTO engPEV_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","While Abraham and Sarah were in Gerar, Abraham told everyone that his wife Sarah was his sister, not his wife. The big boss of Gerar was called Abimelek. He believed Abraham, so he sent somebody to get Sarah so that he could marry her. ");
INSERT INTO engPEV_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","God was not happy that Abimelek was going to marry Sarah, so one night he gave Abimelek a dream, and in that dream, God told him, “You are going to die. You took Sarah to be your wife, but she is already married to Abraham.” ");
INSERT INTO engPEV_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelek said, “But God, I haven’t married Sarah yet. I have not slept with her, like a man sleeps with his wife. Me and my people, we haven’t done anything wrong. Will you kill us for nothing? ");
INSERT INTO engPEV_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham told me himself that Sarah was his sister. And she said that Abraham was her brother. I didn’t know that she was already married to him. I didn’t want to do anything wrong.” ");
INSERT INTO engPEV_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","God kept talking to him in that dream. He said, “Yes, I know that you didn’t want to do anything wrong. You didn’t know that Sarah was a married woman. That’s why I did not let you touch her. I stopped you from doing a bad thing. ");
INSERT INTO engPEV_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","So now, give Sarah back to Abraham. He is my special man, and he will pray for you, so that you will not die. But I’m telling you, if you don’t give her back to Abraham, I will kill you, and I will kill everyone that lives with you.” ");
INSERT INTO engPEV_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","So early in the morning, Abimelek called a meeting for all his important workers. He told them everything that God said, and they were all very frightened. ");
INSERT INTO engPEV_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Then Abimelek sent somebody to get Abraham, and Abraham came to that meeting. Abimelek said to Abraham, “Look, you have made trouble for me and my people. What did I do to you, so that you paid me back with this trouble? You have done a bad thing to us. ");
INSERT INTO engPEV_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Why did you do that? Why did you tell us that Sarah is your sister?” ");
INSERT INTO engPEV_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham said, “I’m sorry. I thought that nobody here respected God, so I was frightened of you mob. I reckoned that you would kill me so that you can marry Sarah. ");
INSERT INTO engPEV_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","But anyway, Sarah really is my sister. We have the same father, but different mothers.” You see, in Abraham’s culture, men could marry their half-sisters. ");
INSERT INTO engPEV_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Then Abraham said, “God told me to leave my father’s country, so we moved around from place to place, and I was frightened of the people. So I told Sarah, ‘Be good to me and tell everyone that you are my sister. Then I will be safe.’” ");
INSERT INTO engPEV_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Then Abimelek did what God told him to do. He gave Sarah back to Abraham, and he also gave him some sheep, and some goats, and some cows, and some bulls, and some workers, both men and women. ");
INSERT INTO engPEV_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","And Abimelek said to Abraham, “Friend, look around at all my country. You can live anywhere you like in this country.” ");
INSERT INTO engPEV_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Then Abimelek said to Sarah, “I’m giving Abraham, your brother, a lot of money, to pay for the trouble I gave you. I’m giving him 1,000 pieces of silver money to show your mob, and everyone else, that you did nothing wrong.” ");
INSERT INTO engPEV_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Then Abraham prayed to God and asked him to make Abimelek and his mob better. You see, before, at the time when Abimelek got Sarah so that he could marry her, God made Abimelek sick and stopped all the women in Abimelek’s house from having babies. But then God talked to Abimelek, and Abimelek gave Sarah back to Abraham. So then Abraham prayed to God, and God made Abimelek better, and he made Abimelek’s wife better, and he made all the women that lived in Abimelek’s house better too, so that they had babies again. ");
INSERT INTO engPEV_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","God was good to Sarah, and he kept his promise to her, ");
INSERT INTO engPEV_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","and a baby started to grow inside her. Then that baby boy was born at the time that God said he would be born. Abraham was an old man, and that baby was a son for Abraham. ");
INSERT INTO engPEV_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham called his son Isaac. That name means laugh. ");
INSERT INTO engPEV_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","And when Isaac was 8 days old, Abraham did the young man operation on him, just like God told him to do, to show that Isaac belonged to God. ");
INSERT INTO engPEV_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham was 100 years old when Isaac was born. ");
INSERT INTO engPEV_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarah said, “God is giving me something to laugh about now, and everyone that hears this story will be happy with me, and they will laugh too.” ");
INSERT INTO engPEV_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","She also said, “Nobody reckoned that I can ever have a kid. But look, now Abraham is old, and I had a son for him.” ");
INSERT INTO engPEV_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","When Isaac was about 3 years old, he stopped drinking Sarah’s milk, and Abraham gave him a big party. ");
INSERT INTO engPEV_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Then Sarah saw Ishmael laughing at Isaac. Ishmael was the son of Abraham and Hagar. Hagar was Sarah’s worker, and she was from Egypt country. ");
INSERT INTO engPEV_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Then Sarah said to Abraham, “When you die, my son Isaac has to get all your things. I don’t want Ishmael to get anything, he is just the son of a worker woman. So you have to tell that woman and her son to get out of our camp. Send them right away from here.” ");
INSERT INTO engPEV_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraham was really upset by what Sarah said. Ishmael was his son, so Abraham reckoned it was wrong to send him away. ");
INSERT INTO engPEV_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","But God said to Abraham, “Don’t worry about Ishmael or his mother. You see, the family that I promised you will come from Isaac, not from Ishmael. So listen to Sarah, and do what she says. ");
INSERT INTO engPEV_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Don’t worry, I will give Ishmael a big family too. Later on, his family will grow into a big nation. I will do that for him, because he is your son too.” ");
INSERT INTO engPEV_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","So early the next morning, Abraham got some food, and a leather water bag. He put them on Hagar’s shoulder, and he sent her and Ishmael out of his camp. They walked around in the desert country near Beersheba. ");
INSERT INTO engPEV_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","They kept going until there was no water left in the water bag. Then they stopped, and Hagar left Ishmael in the shade of a little tree. ");
INSERT INTO engPEV_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","And then she went and sat by herself a little way from him, because she thought, “I don’t want to watch him die.” And she started to cry out loud. ");
INSERT INTO engPEV_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ishmael was crying too, and God heard him, and he sent an angel messenger from heaven to talk to Hagar. The angel said, “Why are you upset? Don’t worry. God has heard Ishmael crying, under that tree. ");
INSERT INTO engPEV_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Go and take care of him. Listen, I will give him a big family, and they will become a great nation.” ");
INSERT INTO engPEV_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Then God showed her a water-hole. So she got up and filled her water bag, and she gave Ishmael a drink. ");
INSERT INTO engPEV_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","God kept Ishmael safe as he grew up in the desert called Paran. He learned how to use a bow and arrows properly, so he became a good hunter. And later on, Hagar got a wife for him from Egypt country. ");
INSERT INTO engPEV_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","23","One day, Abimelek went to talk to Abraham. Abimelek was the big boss of the country where Abraham lived. And Ficol, the leader of Abimelek’s army, went with him. Abimelek said to Abraham, “You know, you are not one of my people. You came from another place to live here in my country. But I have been good to you, and to all your people. So I want you to promise me that you will never try to trick me, or my kids, or anyone that is born into my family. I want you to promise that you will be good to them. We know that God is very good to you, and he helps you with everything you do. So I want you to make that promise to me while God is listening. I want you to tell God to punish you if you break that promise.” ");
INSERT INTO engPEV_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","So Abraham made that promise to Abimelek. He said those words in the way that Abimelek wanted. ");
INSERT INTO engPEV_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","But then Abraham also complained to Abimelek. He said, “I’ve got a problem. Some of your workers took one of my water-holes, and then they stopped my workers from getting any water there.” ");
INSERT INTO engPEV_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelek said, “I’m sorry, Abraham. I don’t know who did that. I never heard about it, and you didn’t tell me about it until now.” ");
INSERT INTO engPEV_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","At that time, Abraham gave Abimelek some of his sheep, and goats, and cows, and the 2 men made strong promises to each other. ");
INSERT INTO engPEV_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Then Abraham also picked out 7 young female sheep from his animals, and he put them to one side. ");
INSERT INTO engPEV_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelek asked him, “Why did you put these 7 sheep to one side? What do you mean by that?” ");
INSERT INTO engPEV_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham said, “I want to give you these sheep as a special present. Take them. That’s how you can show people that you agree with me, that I dug that water-hole and that I own it.” ");
INSERT INTO engPEV_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","From that time on, that place was called Beersheba. That name means water-hole where they made a promise. It was where Abraham and Abimelek made strong promises to each other. ");
INSERT INTO engPEV_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","After they made those promises, Abimelek and Ficol went back to their home, in Philistia country. ");
INSERT INTO engPEV_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Then Abraham showed respect to God there in Beersheba. He called God by his special name Yahweh, and he planted a special tree to remember that place. Yahweh is the true God that lives for ever. ");
INSERT INTO engPEV_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham and all his people lived for a long time in the country that belonged to the Philistia mob. ");
INSERT INTO engPEV_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","A long time later, God tested Abraham. God wanted to see if Abraham trusted him properly, and if Abraham would do anything God told him to do. God called out, “Abraham.” And Abraham said, “Yes, God, I am listening to you.” ");
INSERT INTO engPEV_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Then God said, “I know that you love your son Isaac, and he is your only son, but I want you to take him to the country called Moriah, to one of the mountains that I will show you. I want you to kill Isaac for me, and burn his body on a table made of stones, to show me that you respect me.” ");
INSERT INTO engPEV_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abraham listened to God, so the next morning, Abraham chopped up some wood for the fire and tied the wood on to his donkey. Then, he got Isaac and 2 of his work-men, and they all started to go to the place God told him about. ");
INSERT INTO engPEV_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","They walked for nearly 3 days, then Abraham looked up and saw the place God told him about. It was still a long way ahead of them. ");
INSERT INTO engPEV_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abraham said to his work-men, “I want you to stay here with the donkey. And me and Isaac, we will go over there to show respect to God. After we do that, we will come back to you.” ");
INSERT INTO engPEV_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham put the wood on to Isaac’s back for him to carry, and Abraham carried some fire and his knife. As they walked along, ");
INSERT INTO engPEV_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaac said, “Dad.” Abraham said, “Yes, son?” And Isaac said, “We’ve got the wood, and the fire, but where is the sheep that we are going to burn to show respect to God?” ");
INSERT INTO engPEV_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham said, “Son, God will give us the sheep, so that we can show him respect.” And they kept on walking together. ");
INSERT INTO engPEV_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Then they got to the place that God told Abraham about, and Abraham piled up some stones to make a table with a flat top, and he put the wood on top of it. Then he tied Isaac’s hands and feet together, and he put him on top of the wood. ");
INSERT INTO engPEV_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Then Abraham picked up his sharp knife, and he was just about to kill Isaac, ");
INSERT INTO engPEV_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","but God’s angel messenger called out to him from heaven. He said, “Abraham, Abraham.” Abraham stopped, and he said, “Yes?” ");
INSERT INTO engPEV_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","The angel said, “Don’t kill that boy. Don’t hurt him in any way. Now I know that you respect God so much that you will do anything he tells you to do. You will even kill your only son for God.” ");
INSERT INTO engPEV_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Then Abraham looked behind him, and he saw a male sheep with its head stuck in a little tree. He quickly took Isaac off the wood and untied the ropes from him. Then Abraham grabbed that sheep, and he killed it instead of his son, and he burned it on that stone table, to show respect to God. ");
INSERT INTO engPEV_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","And Abraham called that place, God will give you what you need. Even today, people say, “On God’s mountain, he will give you what you need.” ");
INSERT INTO engPEV_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Then God’s angel messenger called out again from heaven to Abraham. ");
INSERT INTO engPEV_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","He said, “This is what God wants to tell you, Abraham. God says, ‘I am making this really strong promise to you. You can know that I will keep this promise, because I am God. My name is Yahweh. You listened to me, and you were ready to give me your only son. ");
INSERT INTO engPEV_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","So I will do really good things for you. And I will give you a really big family. You see, lots of people will be born into your son’s family later on, and they will become a really big mob of people. There will be lots and lots of them, just like there are lots of stars in the sky, and lots of little bits of sand at the beaches beside the sea. And when other nations get up to fight against them, your family will win, and they will take the towns from those other nations. ");
INSERT INTO engPEV_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","And I will use your family to do good things for all the nations in the world. I will do all this because you listened to me, and you did what I told you to do.’” ");
INSERT INTO engPEV_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Then Abraham and Isaac walked back to the place where Abraham’s work-men were waiting with the donkey, then they all went back to their camp at Beersheba. Abraham and all his people camped there for a long time. ");
INSERT INTO engPEV_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Later on, somebody said to Abraham, “Your brother’s wife Milcah, she had kids too. They are sons for your brother Nahor. ");
INSERT INTO engPEV_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","The oldest son is called Uz. The next son is called Buz. The next son is called Kemuel, and he has a son called Aram. ");
INSERT INTO engPEV_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Milcah’s other sons are called Kesed, Hazo, Pildash, Jidlaf, and Bethuel.” ");
INSERT INTO engPEV_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","They were the 8 sons of Milcah, and Abraham’s brother Nahor was their father. After Nahor’s son Bethuel grew up, he had a daughter called Rebekah. ");
INSERT INTO engPEV_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","And Nahor had another wife, and she had sons too. That other wife’s name was Rumah, and her sons were Tebar, Gaham, Tahash, and Macah. ");
INSERT INTO engPEV_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah lived a long time. She lived until she was 127 years old. ");
INSERT INTO engPEV_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Then she died in the town called Hebron, in the country called Canaan. Another name for that town is Kiriath Arba. Abraham was very sad, and he sat next to Sarah’s body and cried. ");
INSERT INTO engPEV_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","After that, Abraham got up and left the place where Sarah’s body was, and he went to the town gate to talk to the people that owned that country. They were from the Heth tribe. ");
INSERT INTO engPEV_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Abraham said to them, “This is your land, and I am just camping here. I need to bury my wife’s body. Can I buy some of your land to use for a grave?” ");
INSERT INTO engPEV_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","The Heth people said to Abraham, ");
INSERT INTO engPEV_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Sir, we know that you are a great leader for your people, and we respect you a lot. We want you to use one of our best graves to bury your wife. Yes, you can pick any grave you want, and we will let you use it to bury your wife.” ");
INSERT INTO engPEV_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Then Abraham got down on his knees in front of the Heth people, to show them respect. ");
INSERT INTO engPEV_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","He said to them, “Thank you for saying that you will help me bury my wife. There is a cave in your country that I want to use for a grave. You know the man called Efron, the son of Zohar. He’s one of you Heth people. He has some land in the place called Makpelah, and there’s a cave in the rock at one end of that land. I want to put my wife’s body in that cave. Can you ask Efron if I can buy that cave? I want to pay him the full price for it. And you can all watch me buy that cave from him. Then it will belong to me, and I can put my wife’s body there.” ");
INSERT INTO engPEV_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efron was sitting there with the other Heth people at the town gate. He talked to Abraham so that everyone could hear him. ");
INSERT INTO engPEV_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","He said, “Sir, I will give you that cave, and I will give you the land around it too. I’m telling you straight in front of all my people, I will give you that cave and that land, so that you can bury your wife.” ");
INSERT INTO engPEV_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Then Abraham got down on his knees again in front of the Heth people, to show them respect. ");
INSERT INTO engPEV_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","He talked to Efron so that everyone could hear him. He said, “Thank you. All right, I will buy that cave and that land from you. Tell me the right price for it, and I will pay you. Then that land will belong to me, and I can bury my wife there. Do you agree?” ");
INSERT INTO engPEV_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Then Efron said to Abraham, ");
INSERT INTO engPEV_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Sir, the right price for that land is just 4 kilograms of silver money, but let’s not talk about money all day. The most important thing is that you can bury your wife.” ");
INSERT INTO engPEV_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","And all the Heth people heard Efron say that price. So Abraham agreed, and he got out his silver money. He weighed that money properly, and he gave 4 kilograms of it to Efron. ");
INSERT INTO engPEV_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Then that land, and the cave, and all the trees on that land, they belonged to Abraham. That land was in the place called Makpelah, to the east of the place called Mamreh. All the Heth people that were at the town gate, they saw Abraham buy Efron’s land, so they knew that it belonged to Abraham. ");
INSERT INTO engPEV_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","After that, Abraham put Sarah’s body in the cave in that land. It was in the place called Makpelah, to the east of the place called Mamreh, in the country called Canaan. Another name for Mamreh is Hebron. ");
INSERT INTO engPEV_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","That is how Abraham bought some land and a cave from the Heth people, to use for a grave. ");
INSERT INTO engPEV_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham was very old, and God was very good to him in every way. ");
INSERT INTO engPEV_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraham had workers that looked after everything he owned. One of those workers was older than all the other workers, and he was in charge of all the other workers too. One day, Abraham talked to that oldest worker. He said, “I want you to make me a strong promise. So come here and put your hand under my leg.” You see, in Abraham’s culture, people sometimes made promises to each other that way. The person that made the promise, they put their hand under the other person’s leg, and that showed that they had to keep their promise. ");
INSERT INTO engPEV_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Abraham said to the worker, “I want you to make this promise with God listening. His name is Yahweh, and he is the boss of heaven and earth. Promise me that you will not get a wife for my son Isaac from this country that we are living in. Don’t get him a wife from the Canaan people that live here. ");
INSERT INTO engPEV_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","No, I want you to go back to my home country and get a wife for Isaac from my relatives.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Then Abraham’s worker said, “Yes, I will do that. But think about this. Maybe I will pick a woman to be Isaac’s wife, and that woman will not want to leave her home country and come with me here, to Canaan country. Then what do you want me to do? Maybe I can come back here and get Isaac, and then I can take him to your home country to get married?” ");
INSERT INTO engPEV_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham said, “No way. Make sure that you never take Isaac back to my home country. He has to stay here in Canaan country. ");
INSERT INTO engPEV_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","You know that Yahweh my God is the boss in heaven. He took me away from my father’s family and my home country, and he brought me here to Canaan country. And God made me a strong promise. He said, ‘I am going to give this country to all the people that will be born into your family later on.’” Then Abraham said, “I know that God will help you find a wife for my son. Yes, God will send an angel worker to my home country to get things ready for you. When you get there, you will find a woman for my son Isaac to marry. ");
INSERT INTO engPEV_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","But if that woman doesn’t want to leave her home country and come back here with you, then don’t worry. You will not have to keep that promise any more. But I tell you again, you can never take my son Isaac back to my home country.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","So Abraham’s worker put his hand under Abraham’s leg, and he made that strong promise, just like Abraham told him to. He said, “I promise that I will not get a wife for your son Isaac from the Canaan people that live here in this country. I promise that I will go back to your home country and get a wife for Isaac from your relatives.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Abraham wanted to give lots of really good presents to his relatives, so the worker got those presents ready, and he got 10 of Abraham’s camels to carry everything, and he got some of Abraham’s other workers to go with him. They all left that place, and they went north, all the way to Abraham’s home country. That country was called Aram Naharayim. When they got to that country, they went towards the town where Abraham’s brother Nahor lived. ");
INSERT INTO engPEV_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Abraham’s worker stopped near that town, next to a water-hole, and he let the camels lie down there to rest. It was nearly night time, and the young women that lived in that town, they were going to the water-hole to get water. They used to do that at the same time every day. ");
INSERT INTO engPEV_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Abraham’s worker saw those young women, and he prayed to God. He said, “Yahweh, you are the God of my boss Abraham. Please be very good to Abraham, just like you promised him. Please let me find a wife for Abraham’s son Isaac today. ");
INSERT INTO engPEV_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Look, I am standing next to this water-hole, and the young women that live in the town are coming out to get water. ");
INSERT INTO engPEV_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Please show me which woman you picked to be Isaac’s wife.” Then Abraham’s worker said to God, “I will talk to one of those women, and I will say, ‘Please give me a drink from your jar of water.’ Maybe that woman will say to me, ‘Yes, I will give you a drink, and I’ll give your camels some water too.’ If she says that, then I will know that she is the woman you picked to be Isaac’s wife. And I will know that you have been very good to my boss Abraham, just like you promised him.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","While Abraham’s worker was still praying, a young woman walked out of the town with a jar on her shoulder. That woman’s name was Rebekah, and her father’s name was Bethuel. Bethuel’s mother was Milcah, and Bethuel’s father was Nahor. And Nahor was Abraham’s brother. ");
INSERT INTO engPEV_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebekah was a very beautiful young woman, and she wasn’t married. She never slept with a man, like a woman sleeps with her husband. Rebekah got to the water-hole, and she went down to the water and filled up her jar, and then she came back up. ");
INSERT INTO engPEV_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Then Abraham’s worker ran to meet Rebekah. He said to her, “Please let me drink a little bit of water from your jar.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Rebekah said, “Yes, please have a drink, sir.” Straight away, she took the jar off her shoulder. Then she held the jar in her hands and gave Abraham’s worker a drink. ");
INSERT INTO engPEV_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","After Rebekah finished giving him a drink, she said, “Now I will get water for your camels too, until they have enough to drink.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Then she quickly poured the rest of the water from her jug for the camels to drink. Then she ran back to the water-hole to get more water. She kept on doing that until all the camels had enough to drink. ");
INSERT INTO engPEV_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","While Rebekah was getting the water, Abraham’s worker kept on looking at her, but he didn’t say anything. He waited to see if she was the woman that God picked to be Isaac’s wife. ");
INSERT INTO engPEV_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","After the camels finished drinking, Abraham’s worker got some of Abraham’s presents out, and he gave Rebekah some jewellery. He gave her a gold nose ring and 2 heavy gold bracelets for her arms. That nose ring was made out of 6 grams of gold, and those bracelets were made out of 120 grams of gold each. ");
INSERT INTO engPEV_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Then the worker said to Rebekah, “Please tell me, who is your father?” Then he said, “Me and my men, we want to stay here in this town tonight. Is there enough room for us to stay at your father’s house?” ");
INSERT INTO engPEV_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rebekah said to the worker, “My father’s name is Bethuel. His mother’s name is Milcah, and his father’s name is Nahor.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Then Rebekah said, “We have plenty of food for your camels, and we have plenty of dry grass for them to sleep on. And we have plenty of room for you and your men to stay with us tonight.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Then Abraham’s worker knew that Rebekah was Abraham’s relative, and he knew that God picked her to be Isaac’s wife. So he got down on his knees and put his face near the ground, to thank God and show him respect. ");
INSERT INTO engPEV_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","He said, “Yahweh, you are really great. You are the God of my boss Abraham. You keep on being very good to him, just like you promised him. We can always trust you. You brought me straight to Abraham’s relatives, so that I can get a wife for Isaac.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Rebekah ran home and told her family what happened. ");
INSERT INTO engPEV_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","She told them everything that Abraham’s worker said to her at the water-hole, and she showed them the gold nose ring and the gold bracelets that Abraham’s worker gave her. Rebekah’s brother Laban was there, and straight away he ran to the water-hole to find Abraham’s worker, and he found him standing there next to his camels. ");
INSERT INTO engPEV_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Then Laban said to Abraham’s worker, “Sir, I can see that God is good to you. Please, don’t keep on standing here at the water-hole. Come home with me. I have a room ready for you, and I have a place for your camels to stay too.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","So Abraham’s worker, and the other men that were with him, they went to the house with Laban. Then they took the bags off the camels, and Laban got food for the camels to eat and dry grass for them to sleep on. He also got water so that Abraham’s worker and his men could wash their feet. ");
INSERT INTO engPEV_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","After that, he got Abraham’s worker and his men some food. But Abraham’s worker said, “I will not eat yet. First I have to tell you why I came here.” Laban said to him, “Yes, tell us.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","So Abraham’s worker talked to Laban and the other people in Rebekah’s family. He said, “I work for Abraham. ");
INSERT INTO engPEV_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","His God Yahweh is really good to him, and now Abraham is very rich. Yes, God gave him a lot of sheep, and cows, and camels, and donkeys, and a lot of silver and gold. God also gave him a lot of men and women to work for him. ");
INSERT INTO engPEV_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","And Abraham has a son too. Yes, Abraham’s wife Sarah had a baby boy when she was very old. That boy is a man now, and later, when Abraham dies, he will get everything that belonged to Abraham.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Then Abraham’s worker said, “My boss Abraham got me to make him a strong promise. He said, ‘Promise me that you will not get a wife for my son from this country that we are living in. Don’t get him a wife from the Canaan people that live here. ");
INSERT INTO engPEV_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","No, you have to go to my father’s family and my other relatives, and get a wife for my son.’ ");
INSERT INTO engPEV_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Then I said to my boss Abraham, ‘Maybe I will pick a woman, and that woman will not want to leave her home country and come with me here, to Canaan country. Then what do you want me to do?’ ");
INSERT INTO engPEV_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Then my boss Abraham said, ‘Listen, I trust Yahweh my God, and I always live his way. I know that he will send an angel worker to go with you and help you, so that you will find a wife for my son from my father’s family. ");
INSERT INTO engPEV_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","But if you pick a woman to be my son’s wife, and her relatives will not let her go with you, then don’t worry. You will not have to keep that promise any more.’” ");
INSERT INTO engPEV_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Then Abraham’s worker said, “Today, I came to the water-hole that is near your town. Then I prayed to God. I said, ‘Yahweh, you are the God of my boss Abraham. Please let me find a wife for Abraham’s son today. ");
INSERT INTO engPEV_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","44","Look, I am standing next to this water-hole, and the young women that live in the town, they are coming out to get water. Please show me which one you picked for Abraham’s son. I will talk to one of those women, and I will say, “Please let me drink a little bit of water from your jar.” Maybe that woman will say to me, “Yes, I will give you a drink, and I’ll give your camels some water too.” If she says that, then I will know that she is the woman you picked for Abraham’s son.’ ");
INSERT INTO engPEV_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","While I was still praying quietly to God, Rebekah walked out of the town with a jar on her shoulder. She went down to the water-hole and got some water. Then I said to Rebekah, ‘Please let me have a drink.’ ");
INSERT INTO engPEV_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Straight away, she took the jar off her shoulder and she said, ‘Yes, have a drink. And I will get water for your camels too.’ So I had a drink, and then she got water for my camels. ");
INSERT INTO engPEV_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Then I said, ‘Who is your father?’ And she said, ‘My father’s name is Bethuel. His father’s name is Nahor, and his mother’s name is Milcah.’ Then I knew that Rebekah is from Abraham’s family, and I knew that God picked her to marry Abraham’s son. So I gave Rebekah a gold nose ring and 2 gold bracelets for her arms. ");
INSERT INTO engPEV_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Then I got down on my knees and put my face near the ground, to thank God and show him respect. I said, ‘Yahweh, you are really great. You are the God of my boss Abraham. You brought me straight here to Abraham’s relatives, so that I can get a wife for Abraham’s son.’” ");
INSERT INTO engPEV_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Abraham’s worker kept on talking to Rebekah’s family. He said, “Now I’m asking you to be very good and fair to my boss Abraham. Will you let me take Rebekah to Canaan country, so that she can marry Abraham’s son? Please tell me if you will say yes or no. Then I will know what I have to do after this.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Then Rebekah’s brother Laban, and her father Bethuel, they talked to Abraham’s worker. They said, “Those things that you told us, we know that God made them happen. So we can’t argue with you. ");
INSERT INTO engPEV_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Look, here is Rebekah. Take her with you to Canaan country, so that she can marry Abraham’s son. That is what God wants.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Then Abraham’s worker got down on his knees and put his face near the ground, to thank God and show him respect. ");
INSERT INTO engPEV_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","After that, the worker gave Rebekah and her family some presents from Abraham. He gave Rebekah some clothes, and some pretty things made out of silver and gold. And he also gave presents that cost a lot of money to Rebekah’s brother Laban, and to her mother. ");
INSERT INTO engPEV_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Abraham’s worker and his men ate some food, and then they stayed the night with Rebekah’s family. The next morning, they got up, and Abraham’s worker talked to Rebekah’s family. He said, “Let me take Rebekah and go back to my boss Abraham.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","But Rebekah’s brother and mother said, “Let Rebekah stay here a bit longer, maybe 10 more days, and after that she can go with you.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Abraham’s worker said, “Please don’t make me wait any longer. You know that God picked Rebekah to marry Abraham’s son, and he helped me find her. So please let her come with me now, so that we can go back to my boss Abraham.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Then Rebekah’s brother and mother said, “All right, we will get Rebekah and ask her what she wants to do.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","So they got Rebekah, and they said to her, “Do you want to go with this man to Canaan country now, so that you can marry Abraham’s son?” Rebekah said, “Yes, I will go now.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","So Rebekah’s family said to Abraham’s worker, “All right, Rebekah can go with you and your men to Canaan country now. And she can take some women that work for our family. They can live in Canaan country with her and work for her there.” One of those women used to look after Rebekah when she was a little girl. ");
INSERT INTO engPEV_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Then Rebekah’s family asked God to be good to Rebekah. They said to her, “We are asking God to give you lots of kids and grand-kids, so that your family will become a really big mob of people. And we are asking God to make them strong, so that when other people fight against your mob, your mob will win, and then your mob will take the towns that belonged to those other people.” ");
INSERT INTO engPEV_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Then Rebekah and her working women, they got on camels, and they went with Abraham’s worker and his men, to go all the way to Canaan country. ");
INSERT INTO engPEV_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Abraham’s son Isaac was living in Canaan country. You see, before this time, Isaac went south, away from Abraham’s camp, and he made his camp in the south part of the country called the Negev, near a water-hole. That water-hole was called the water-hole that belongs to God, he is alive and sees me. Then when Abraham’s worker was away in Haran, Isaac came back home. ");
INSERT INTO engPEV_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Then one afternoon, when it was nearly night time, Isaac went out to the grass lands to think about things. Then he looked up and saw camels coming, so he walked out to meet them. ");
INSERT INTO engPEV_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekah was riding on one of those camels, and she looked up and saw Isaac coming towards them. Straight away, she got off her camel. ");
INSERT INTO engPEV_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Then she said to Abraham’s worker, “I can see a man walking towards us. Who is he?” The worker said, “He is my boss Isaac.” Rebekah didn’t want Isaac to see her face, so she got a scarf and put it over her head. You see, in that culture, that is what a woman did when she met the man that she was going to marry. ");
INSERT INTO engPEV_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Then Abraham’s worker talked to Isaac, and he told Isaac everything that happened. ");
INSERT INTO engPEV_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","There was a tent there that used to belong to Isaac’s mother Sarah. Isaac took Rebekah into that tent, and Rebekah became Isaac’s wife. Isaac loved Rebekah. Some time before this, Isaac’s mother Sarah died, so Isaac was sad. But after he married Rebekah, he was happy again. ");
INSERT INTO engPEV_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham married another woman too. Her name was Keturah. ");
INSERT INTO engPEV_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Abraham and Keturah had 6 sons together. Their names were Zimran, Jokshan, Medan, Midian, Ishbak, and Shuwah. ");
INSERT INTO engPEV_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","After Jokshan grew up, he had 2 sons. Their names were Sheba and Dedan. The tribes that were from Dedan and his family were the Ashur mob, the Letush mob, and the Leyum mob. ");
INSERT INTO engPEV_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","After Midian grew up, he had 5 sons. Their names were Efah, Efer, Hanok, Abida, and Eldah. All of those men were Keturah’s sons and grand-sons. ");
INSERT INTO engPEV_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","One day Abraham said, “After I die, I want my son Isaac to have everything that I own. He is the son of my 1st wife Sarah.” ");
INSERT INTO engPEV_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","But Abraham wanted to be good to his other sons too, those sons that he had with his other wives. So Abraham gave presents to those other sons. Then he sent them to go and live in a country to the east, a long way away from his son Isaac. ");
INSERT INTO engPEV_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abraham lived a long time, until he was a very old man. He lived until he was 175 years old. He had a good long life, then he breathed for the last time, and he died. ");
INSERT INTO engPEV_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Then Abraham’s 2 oldest sons, Isaac and Ishmael, they took Abraham’s body to the cave at the place called Makpelah, to the east of the place called Mamreh. You see, a long time before that, Abraham bought that cave and the land around it from a man called Efron. Efron’s father was called Zohar, and they were from the Heth tribe. And Abraham put his wife Sarah’s body in that cave. So after Abraham died, Isaac and Ishmael put his body in that cave, next to Sarah’s body. ");
INSERT INTO engPEV_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","After that, Abraham’s son Isaac went to live near the water-hole called the water-hole that belongs to God, he is alive and sees me. And God kept on being good to Isaac. ");
INSERT INTO engPEV_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","This is the story about Ishmael’s family. Ishmael was Abraham’s oldest son, and his mother’s name was Hagar. Hagar was from Egypt country, and she worked for Abraham’s wife Sarah. ");
INSERT INTO engPEV_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ishmael had 12 sons. His oldest son was called Nebayoth, and his next son was called Kedar, then Adbeel, Mibsam, ");
INSERT INTO engPEV_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massa, ");
INSERT INTO engPEV_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Nafish, and Kedemah. ");
INSERT INTO engPEV_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Later on, those 12 sons of Ishmael became the bosses of 12 tribes, and all those tribes lived in their own camps. ");
INSERT INTO engPEV_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishmael lived until he was 137 years old. Then he breathed for the last time, and he died. ");
INSERT INTO engPEV_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ishmael’s sons and their tribes, they went and lived far away from their other relatives. They went and lived between the place called Havilah and the place called Shur, near Egypt country. Shur is also near the place called Ashur. ");
INSERT INTO engPEV_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","This is the story about Abraham’s son Isaac and his family. ");
INSERT INTO engPEV_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","When Isaac was 40 years old, he married Rebekah. Her family was from the Aram tribe, and they lived in Paddan Aram country. Her father’s name was Bethuel, and her brother’s name was Laban. ");
INSERT INTO engPEV_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","At first, after Isaac and Rebekah got married, they didn’t have any kids. Rebekah just couldn’t have a baby. So Isaac prayed strongly to God. He said, “Please let Rebekah have a baby.” God listened to Isaac, and God made 2 baby boys start growing inside Rebekah. ");
INSERT INTO engPEV_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","But while those babies were still inside her, they started to fight with each other. Rebekah felt them moving inside her, and she was worried about it. So she said to God, “Why is this happening to me?” ");
INSERT INTO engPEV_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","God said to Rebekah, “There are 2 babies inside you. They will grow up and have kids, and their kids will become 2 nations. Right from the start, those 2 nations will fight against each other. One of those nations will be stronger than the other nation. Yes, the younger son’s nation will be stronger, and his nation will be boss over the older son’s nation.” ");
INSERT INTO engPEV_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Later on, the time came for Rebekah to have her babies, and 2 boys were born. ");
INSERT INTO engPEV_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","The 1st baby that was born, his skin colour was a bit red. He also had hair all over his body, like an animal skin. Isaac and Rebekah named that baby Esau. ");
INSERT INTO engPEV_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Straight away, the 2nd baby was born. And when that baby came out, he was holding the back of Esau’s foot. So Isaac and Rebekah named that baby Jacob. That name means he holds the back of the foot. Isaac was 60 years old when Rebekah had those 2 babies. ");
INSERT INTO engPEV_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Isaac and Rebekah’s sons grew up and became men. Their son Esau became a good hunter. He liked to go out bush and catch wild animals to eat. But their son Jacob was a quiet man, and he liked to stay at their camp. ");
INSERT INTO engPEV_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaac loved to eat the wild animals that Esau caught. So Isaac loved Esau more than Jacob. But Rebekah loved Jacob more than Esau. ");
INSERT INTO engPEV_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","One day, while Esau was out bush, Jacob cooked some soup with red beans in it. While Jacob was cooking that soup, Esau came back home, and he was really tired and hungry. ");
INSERT INTO engPEV_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","34","So Esau said to Jacob, “Please let me eat some of that red soup right now. I’m really tired and hungry.” Jacob said to Esau, “First, I want you to do something for me. You are the oldest son in our family. That means you are the most important son, and you will be the next leader for our family. But I want to be the most important son, instead of you. I want to be the next leader for our family. So you have to promise that you will let me be the most important son now, instead of you. Then you can eat some soup.” Esau said, “Look, I’m so tired and hungry that I’m going to die. So it doesn’t matter if I stop being the next leader for our family. I just need some food right now.” But Jacob said, “First, you have to make me that strong promise.” So Esau did what Jacob asked. He said to Jacob, “I promise that you can be the most important son in our family, instead of me, and you can be the next leader for our family.” Then Jacob gave Esau some of that soup with red beans in it, and some bread. Esau ate that red soup and bread, and then he got up and left. That’s the story about how Esau let Jacob be the most important son. So Esau wasn’t the most important son any more, but he didn’t care. Later on, people sometimes called Esau a different name. They called him Edom. That name means red, like that red soup. ");
INSERT INTO engPEV_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","At another time, there was no rain and no food plants growing in the country where Isaac and Rebekah lived. It was like the time when there was no rain a long time before, while Abraham was still alive. So Isaac and his family left that country, and they went to the town called Gerar, in Philistia country. The big boss of the Philistia people was called Abimelek, and he lived in that town. ");
INSERT INTO engPEV_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","God showed himself to Isaac in that place, and God said, “Don’t go to Egypt country to try to get food. I’m going to tell you where you have to live. ");
INSERT INTO engPEV_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","4","I’m telling you to camp here, in this country. You don’t need to worry. I will be with you, to take care of you. I will keep on being good to you. Remember that strong promise that I made to your father Abraham. Now I’m making the same promise to you. I will give you a really big family. You see, lots of kids and grand-kids will be born into your family later on, and they will become a really big mob of people. There will be lots and lots of them, just like there are lots of stars in the sky. And I will give them all of this country, and I will use them to do good things for all the nations in the world. ");
INSERT INTO engPEV_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","You know, your father Abraham listened to me and did what I told him to do. That’s why I’m making that same promise to you that I made to him.” ");
INSERT INTO engPEV_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","So Isaac set up his camp in Gerar, just like God told him to. ");
INSERT INTO engPEV_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","The men in Gerar saw Isaac’s wife Rebekah, and they asked Isaac, “Who is that woman?” You know, Rebekah was very beautiful. So Isaac got worried about those men. He thought, “Maybe those men want to marry Rebekah. If I tell them that she is my wife, maybe they will kill me to get her.” So Isaac lied and said, “She is my sister.” ");
INSERT INTO engPEV_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","After that, Isaac and Rebekah lived in Gerar for a long time. But one day Abimelek, the big boss of the Philistia people, he looked out of his window, and he saw Isaac hugging Rebekah. Then Abimelek knew that Rebekah was Isaac’s wife. ");
INSERT INTO engPEV_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","So Abimelek sent somebody to get Isaac. Then Abimelek said to Isaac, “Now I know that Rebekah is your wife. Why did you say, ‘She is my sister’?” Isaac said, “I was too frightened to say, ‘She is my wife.’ I thought that the men in Gerar will kill me and take Rebekah for themselves. So I said, ‘She is my sister.’” ");
INSERT INTO engPEV_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Then Abimelek was angry. He said to Isaac, “That was a bad thing that you did to us. You didn’t tell us that Rebekah is your wife. We thought that she is not married. What if one of my men slept with her, like men sleep with their wives? Think about that. Then me and all my people, we would be guilty of that bad thing.” ");
INSERT INTO engPEV_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","After that, Abimelek talked strongly to all the people in Gerar. He said, “If any one of you hurts Isaac or Rebekah, I will kill you.” ");
INSERT INTO engPEV_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","While Isaac lived in Gerar, he planted seeds in the ground. And God was really good to Isaac. That same year, those seeds grew into really good food plants, so Isaac had lots and lots of food. ");
INSERT INTO engPEV_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","And Isaac got more and more money and good things, and he became very rich. ");
INSERT INTO engPEV_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","He had lots of sheep and cows, and lots of people that worked for him. The Philistia people that lived in Gerar, they saw that Isaac was very rich, and they got jealous of him. ");
INSERT INTO engPEV_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","So they got dirt and filled up the water-holes that Isaac was using. A long time before that, Isaac’s father Abraham got his workers to dig those water-holes. ");
INSERT INTO engPEV_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Then Abimelek, the big boss of the Philistia people, he said to Isaac, “Listen, you and your mob are a lot stronger than us now, so I don’t want you to keep on living here. You have to leave this place.” ");
INSERT INTO engPEV_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","So Isaac and his family left Gerar, and they moved their camp to a place called the Valley of Gerar, and they lived in that place for a long time. ");
INSERT INTO engPEV_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","A long time before this, when Isaac’s father Abraham was alive, Abraham and his workers dug lots of water-holes in that place, and Abraham gave all those water-holes names. But then, after Abraham died, the Philistia people filled up all those water-holes with dirt, so nobody could get water from them. Now, when Isaac moved there, he got his workers to take the dirt out of those water-holes, so that everybody could get water again. And Isaac gave those water-holes the same names that Abraham gave them a long time before. ");
INSERT INTO engPEV_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","One day, Isaac’s workers dug a new water-hole in the valley, and they found fresh running water in that hole. ");
INSERT INTO engPEV_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","But there were some men there from Gerar, looking after their animals, and those men came and argued with the men that looked after Isaac’s animals. The men from Gerar said, “That water belongs to us.” So Isaac called that water-hole Esek. That name means they argue. ");
INSERT INTO engPEV_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","After that, Isaac’s workers dug another water-hole, but the men from Gerar came and argued with them about that water-hole too. So Isaac called that water-hole Sitnah. That name means they are enemies. ");
INSERT INTO engPEV_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Then Isaac moved his camp to a new place, and his workers dug a water-hole in that place. This time, nobody argued with them about the water-hole. So Isaac called that water-hole Rehoboth. That name means big place. And Isaac said, “God has given us a big place to live. Our family will grow here, and our life will be good.” ");
INSERT INTO engPEV_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Later on, Isaac moved his camp to the place called Beersheba. ");
INSERT INTO engPEV_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","When Isaac got to Beersheba, that same night, God showed himself to Isaac. God said, “I am God. I am the one that looked after your father Abraham. Don’t be frightened. I am here with you, to take care of you. I will be good to you, and I will give you a really big family, just like I promised to your father Abraham.” ");
INSERT INTO engPEV_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Then Isaac wanted to show respect to God, so he piled up stones to make a table with a flat top. It was a special place for him to burn animals to show right respect to God. Then Isaac prayed to God, and he called God by his special name Yahweh. After that, Isaac set up his camp, and he sent his workers to go and dig a water-hole. ");
INSERT INTO engPEV_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimelek, the big boss of the Philistia mob, he wanted to talk to Isaac again. So he left his home in Gerar, and he went to Isaac’s camp in Beersheba. He took 2 other men with him. One of those men was called Ahuzath, and he was Abimelek’s helper. The other man was called Ficol, and he was the leader of Abimelek’s army. ");
INSERT INTO engPEV_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","When Isaac saw Abimelek and the 2 other men, he was shocked, and he said, “You told me to leave your country, so I know you hate me. So why did you come here to talk to me?” ");
INSERT INTO engPEV_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Then they said to Isaac, “We know that Yahweh your God is with you, and he helps you with everything you do. So we want you to make an agreement with us. ");
INSERT INTO engPEV_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","We want you to promise that you will never hurt us or our people. Remember that time when you lived in our country. We never hurt you, and we always did good things for you. Even when we told you to leave our country, we didn’t make trouble for you. After that, your God kept on being good to you. That’s why we are asking you to promise that you will never hurt us.” ");
INSERT INTO engPEV_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Then Isaac agreed to make that promise, and he got lots of good food ready for Abimelek and the other 2 men. They all ate that food together, and then they stayed the night in that place. ");
INSERT INTO engPEV_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Early the next morning, they got up, and Isaac and Abimelek made strong promises to each other. They said, “I promise that I will never hurt you or your people.” So Isaac and Abimelek both felt happy and quiet inside themselves. Then Isaac said goodbye to Abimelek and the other 2 men, and they left to go back to their home country. ");
INSERT INTO engPEV_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Later that day, Isaac’s workers came to him, and they said, “We dug a water-hole, just like you said, and we found water.” ");
INSERT INTO engPEV_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Then Isaac called that water-hole Sheba. That name means promise. So people kept on calling the town near there Beersheba. That name means water-hole where they made a promise. They still use that town’s name today. ");
INSERT INTO engPEV_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Isaac and Rebekah’s oldest son was called Esau. When Esau was 40 years old, he married 2 women. One of those women was called Judith. Her father was called Beeri, and he was from the Heth tribe. The other woman was called Basemath. Her father was called Elon, and he was from the Heth tribe too. ");
INSERT INTO engPEV_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Those 2 women gave Isaac and Rebekah a lot of trouble, and that made them very sad. ");
INSERT INTO engPEV_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","A long time later, when Isaac was old, his eyes got really weak and he couldn’t see. One day, Isaac sent somebody to get his oldest son Esau. Then Esau came to him, and Isaac said, “My son.” And Esau said, “Yes, Father?” ");
INSERT INTO engPEV_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","And Isaac said, “Listen, I am very old. Maybe I will die soon. ");
INSERT INTO engPEV_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","4","You are my oldest son, so you will be the next leader for our family. I have to do a ceremony with you, to show that you will be the next leader. First, I want you to get your bow and arrows. Go out bush and kill a wild animal, then cook it and make some good food for me, just the way I like it. Then bring me that food, and I will eat it. Then I will do that ceremony with you, to show that you are the next leader for our family. I will ask God to be good to you as the next leader for our family. I have to do that ceremony before I die.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Isaac’s wife Rebekah was nearby, and she heard Isaac say those things to Esau. But Isaac didn’t know that she heard him. After that, Esau did what Isaac told him to do. He got his bow and arrows, and he went out bush to look for a wild animal to kill. ");
INSERT INTO engPEV_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Straight away, Rebekah talked to her son Jacob. She said, “I heard your father talk to your brother Esau. ");
INSERT INTO engPEV_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Your father said, ‘Go and kill a wild animal and make some good food for me. I will eat that food, and then I will do a ceremony with you. I will ask God to be good to you as the next leader for our family, and I know that God will listen. I have to do that ceremony before I die.’” ");
INSERT INTO engPEV_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Then Rebekah said to Jacob, “My son, I want you to be the next leader for our family, not your brother Esau. So listen to me and do what I say. ");
INSERT INTO engPEV_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Go to the place where we keep our goats. Get 2 really good young goats and bring them back here. I will cook those goats and make some good food for your father, just the way he likes it. ");
INSERT INTO engPEV_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Then I will give you that food to take to your father. He can’t see, so he will think that you are Esau, and he will do that ceremony with you before he dies. He will ask God to be good to you as the next leader for our family.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","But Jacob said to Rebekah, “You know that my brother Esau has hair all over his skin. But I have smooth skin, I don’t have any hair on my skin. ");
INSERT INTO engPEV_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Maybe my father will touch my smooth skin, and then he will know that I am Jacob, not Esau. And he will know that I am tricking him. Then my father will not ask God to be good to me. No, he will ask God to curse me, and God will make trouble for me.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","But Rebekah said, “Don’t worry. If God wants to curse you, I will ask him to curse me instead. Just do what I say. Go and get those 2 young goats for me.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","So Jacob went and got 2 young goats, and he took them to his mother Rebekah. She cooked those goats, and she made some good food, just the way Jacob’s father liked it. ");
INSERT INTO engPEV_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rebekah’s older son Esau, his best clothes were in Rebekah’s tent, so Rebekah got those clothes and gave them to her younger son Jacob, and she told him to put them on. ");
INSERT INTO engPEV_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Then she took some bits of hairy skin from the 2 goats, and she tied those bits of skin around Jacob’s arms and neck. ");
INSERT INTO engPEV_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Then Rebekah gave Jacob the good food that she made, and some bread. ");
INSERT INTO engPEV_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jacob took that food, and he went to his father Isaac’s room. Jacob said, “Father.” And Isaac said, “Yes, son. Who are you? Are you Esau, or are you Jacob?” ");
INSERT INTO engPEV_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Then Jacob lied and said, “I am Esau, your older son. I killed a wild animal and I made some good food for you, just like you said. Sit up and eat it. Then you can ask God to be good to me as the next leader for our family.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","But Isaac said, “My son, how did you get that wild animal so quickly?” Jacob lied again and said, “God, the one that looks after you, he let me find that wild animal really quickly.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Then Isaac said, “My son, come close to me, so that I can touch your arms. If your arms are hairy, then I will know that you really are my son Esau.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","So Jacob went close to his father Isaac, and Isaac touched Jacob’s arms. Then Isaac said, “Your voice is like Jacob’s voice, but your arms are like Esau’s arms. They are really hairy.” You see, when Isaac touched Jacob’s arms, he touched those bits of hairy goat skin that Rebekah tied around Jacob’s arms. That’s the reason why Isaac said, “Your arms are like Esau’s arms.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","So Isaac didn’t know that Jacob tricked him. He thought, “Now I know that this is Esau, because his arms are really hairy. I will eat that food that he made, and then I will ask God to be good to him as the next leader for our family.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Then Isaac said to Jacob, “Are you really my son Esau?” And Jacob lied and said, “Yes, I am.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","So Isaac said, “My son, bring me that food that you made. I will eat that food, and then I will ask God to be good to you as the next leader for our family.” Then Jacob gave Isaac that food, and Isaac ate it. Jacob also gave Isaac some wine, and Isaac drank it. ");
INSERT INTO engPEV_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Then Isaac said to Jacob, “My son, come close to me and kiss me on the cheek.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","So Jacob went close to Isaac and kissed him, and Isaac smelled the clothes that Jacob was wearing, those clothes that belonged to Esau. Then Isaac thought again, “Yes, I know that this is Esau.” Then Isaac asked God to be good to his son and to the people born into his son’s family later on. He said, “My son smells like land where God makes lots of good things grow. ");
INSERT INTO engPEV_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","I’m asking God to send water to make your land wet, so that your land will grow really good food plants, and so that you will have lots of food and wine. ");
INSERT INTO engPEV_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","I’m asking God to make you boss over other nations, so that those other nations will work for you and show you respect. I’m asking God to make you boss over your relatives, so that they will show you respect. If anyone makes trouble for you, I’m asking God to curse them, but if anyone is good to you, I’m asking God to be good to them.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","After Isaac finished saying those things, Jacob left Isaac’s room. Straight away after that, Esau came home. He had a wild animal that he killed out bush. ");
INSERT INTO engPEV_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Esau cooked that wild animal and made some good food, just like Rebekah did. Then Esau took that food to his father Isaac. Esau said, “My father, I killed a wild animal and cooked it for you. Please sit up and eat this good food. Then you can ask God to be good to me as the next leader for our family.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Then Isaac said to him, “Who are you?” And Esau said, “I am your son Esau, your older son.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaac got a big shock, and his body started to shake. Isaac said, “But another man already killed a wild animal and made food for me. He gave that food to me, and I ate it. I want to know, who was that man? I asked God to be good to him, as the next leader for our family, and I know for sure that God will do that.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Then Esau got really upset, and he yelled out. Then he said, “My father, please ask God to be good to me too.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","But Isaac said, “No, I can’t do that. Your brother Jacob tricked me. He pretended to be you, and he got me to do that ceremony with him, instead of you. I asked God to be good to him, and he will be the next leader for our family.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Then Esau got angry, and he said, “My brother is called Jacob, and that is the right name for him. That name can mean he cheats. Yes, Jacob cheated me 2 times. First, he made me promise that I will let him be the most important son, instead of me. And look, now he got our father to do that ceremony with him, and he will be the next leader for our family.” Then Esau talked to Isaac again. He said, “Is there something else that you can ask God to do for me? Please ask God to do something good for me too.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","But Isaac said, “No, I can’t do that. I made your brother Jacob boss over you, and I made him boss over all his other relatives too, so that they will have to work for him. And I asked God to keep giving Jacob plenty of good food and wine. So there’s nothing I can ask God to do for you, my son.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Then Esau kept on talking to Isaac. He said, “Please, my father, ask God to do just one good thing for me. Please ask God to be good to me too.” Then Esau started to cry really loud. ");
INSERT INTO engPEV_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Then his father Isaac said to him, “I’m telling you that you and the people born into your family later on, you will live in a place where the ground is dry. God won’t send any water to wet that land, and there won’t be any good food plants growing there. ");
INSERT INTO engPEV_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Your tribe will always fight and steal from other people to get their food. Your brother’s tribe will be boss over your tribe. But one day, your tribe will fight back, and then your brother’s tribe will not be boss over your tribe any more.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau was really angry, because Jacob tricked their father, and their father made Jacob the next leader for their family. So Esau hated Jacob. And Esau said to himself, “My father is going to die soon. When he dies, we will all cry for a time, and then I will kill my brother Jacob.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","But somebody told Rebekah that her older son Esau said those things. So Rebekah sent somebody to get her younger son Jacob. Then she said to Jacob, “Listen. Your brother Esau wants to do payback to you. He is planning to kill you. ");
INSERT INTO engPEV_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","So, my son, do what I say. Leave this place straight away, and go quickly to the town called Haran, in Paddan Aram country. My brother Laban lives in that place. ");
INSERT INTO engPEV_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Stay with Laban for a little while, until your brother Esau stops being angry. ");
INSERT INTO engPEV_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","One day, Esau will forget about what you did, and he will not be angry with you any more. Then I will send somebody to Haran to get you, and you can come back here. But if you stay here now, Esau will kill you, and then somebody else will do payback to Esau and kill him. I don’t want both of you to die on the same day. So you have to go away from this place.” ");
INSERT INTO engPEV_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Then Rebekah went and talked to her husband Isaac. She wanted Isaac to send Jacob away, so that Jacob will be safe from his brother Esau. But she didn’t tell Isaac what she said to Jacob. She said, “You know those 2 women that our son Esau married. They are from the Heth tribe, and their people live here in Canaan country. Those women make my life rubbish. If our son Jacob keeps on living here in Canaan country, maybe he will marry a woman from the Heth tribe too. Then my life will be so rubbish, I will want to die.” ");
INSERT INTO engPEV_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaac sent somebody to get Jacob, and Jacob came to Isaac’s room. Then Isaac talked strongly to Jacob. Isaac said, “My son, don’t marry any women that live here in Canaan country. ");
INSERT INTO engPEV_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","I want you to marry somebody from our family. So leave this place straight away, and go to Paddan Aram country. Your mother’s father Bethuel, he lives in that place. And your mother’s brother Laban, he lives there too. I want you to pick one of Laban’s daughters and marry her.” ");
INSERT INTO engPEV_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Then Isaac said, “God has power over everything. So I’m asking God to be good to you. I’m asking him to give you lots of kids and grand-kids, so that your family will grow into lots of different tribes. ");
INSERT INTO engPEV_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","And I’m asking him to give all this country to you and the people that will be born into your family later on. Right now, this country doesn’t belong to you. You are just camping here. But one day, your family will take this country for themselves, just like God promised to your grand-father Abraham.” ");
INSERT INTO engPEV_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Then Isaac sent Jacob away, and Jacob left to go to his uncle Laban in Paddan Aram country. Laban was the brother of Rebekah, she was Jacob and Esau’s mother. Laban and Rebekah’s father was Bethuel, and he was from the Aram tribe. ");
INSERT INTO engPEV_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau found out that Isaac asked God to be good to Jacob, and that Isaac said to Jacob, “Don’t marry any of the women that live here in Canaan country.” And he found out that Isaac sent Jacob to Paddan Aram country, to find a wife there. ");
INSERT INTO engPEV_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","And Esau knew that Jacob left to go to Paddan Aram country, just like his father and mother told Jacob to. ");
INSERT INTO engPEV_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Then Esau knew that his father Isaac didn’t like the women from Canaan country. ");
INSERT INTO engPEV_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Esau already had 2 wives, and they were both from Canaan country. So he thought, “I have to marry a woman from our own family, so that my father will be happy with me again.” So Esau went to the place where his uncle Ishmael lived. Ishmael was Abraham’s son. And Esau married Ishmael’s daughter Mahalath. Her oldest brother was called Nebayoth. Then Esau had 3 wives. ");
INSERT INTO engPEV_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","This is the story about what happened to Jacob next, after his father Isaac sent him away to find a wife. Jacob left his home in Beersheba, and he started to go towards the town called Haran, in Paddan Aram country. ");
INSERT INTO engPEV_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","He kept on walking until the sun started to go down. Then he stopped for the night. There were lots of stones in that place, and Jacob got one of those stones, and he put it on the ground at his head. Then he lay down and went to sleep. ");
INSERT INTO engPEV_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","While Jacob was asleep, he had a dream. In that dream, he saw lots of steps going up from the earth, and those steps went all the way up into the sky. And Jacob saw lots of God’s angel messengers on those steps. Some of those angel messengers were going up the steps towards the sky, and some of them were going down the steps towards the earth. ");
INSERT INTO engPEV_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Then Jacob saw God standing near him. And God talked to Jacob. He said, “I am God, my name is Yahweh. I am the one that looked after your grand-father Abraham and your father Isaac. I’m making you a promise about this country where you are sleeping right now. I will give all this country to you and to the people that will be born into your family later on. ");
INSERT INTO engPEV_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Lots of people will be born into your family, and they will become a really big mob of people. There will be lots and lots of them, just like there are lots of little bits of dirt on the ground. And those people in your family, they will spread out a long way, and they will live in lots of different places. Some of them will go west, some of them will go east, some of them will go north, and some of them will go south. And I will use your family to do good things for all the families in the world. ");
INSERT INTO engPEV_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","You can be sure that I will be with you wherever you go. I will look after you and I will keep you safe. Right now, you are going to another country. But one day, I will bring you back to this country again. Yes, I will stay with you, and I will keep all these promises that I’m making to you.” ");
INSERT INTO engPEV_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Then Jacob woke up, and he said, “Now I know that God is in this place. I didn’t know that before, but now I do.” ");
INSERT INTO engPEV_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","So Jacob got frightened. He said, “This place frightens me. I know for sure that God lives here. This place joins up with heaven.” ");
INSERT INTO engPEV_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Early the next morning, Jacob picked up the stone that was at his head, and he stood it up and poured olive oil on top of it. Jacob did those things to show that God was in that place, and that place was special. ");
INSERT INTO engPEV_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","And Jacob named that place Bethel. That name means God’s house. At that time, the town nearby was called Luz. But later, people called that town Bethel. ");
INSERT INTO engPEV_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","22","Jacob prayed to God. He said, “God, you know that I’m walking a long way to Haran. Please stay with me and look after me while I’m away. Please give me food to eat and clothes to wear. And please keep me safe, so that one day I can go back home to my family.” Then Jacob made promises to God. He said, “God, if you will do all those things that I asked, then I will respect you properly, and you Yahweh will be my God. And this special stone that I put here, it will show people that you are here in this place, and people can come here to show you respect. And I promise that whenever you give me good things, I will always split them up into 10 parts and give one part back to you.” ");
INSERT INTO engPEV_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Then Jacob left that place, and he kept on walking towards the east, until he got to Paddan Aram country. ");
INSERT INTO engPEV_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","3","Then Jacob looked at the land that was in front of him, and he saw a water-hole with a really big flat stone over the top, like a lid. And he saw 3 mobs of sheep lying next to that water-hole. There were some work-men there that looked after those sheep. Every day, those work-men used to meet together at that water-hole with their sheep, and then they worked together to move that big stone that was on top of the water-hole, and they got water for their sheep to drink. Then every day they put that big stone on top of the water-hole again. ");
INSERT INTO engPEV_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob went and talked to those work-men. He said, “Hello. Where do you mob come from?” The work-men said, “We are from Haran.” ");
INSERT INTO engPEV_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Then Jacob said, “Do you know Laban? His grand-father’s name is Nahor.” The work-men said, “Yes, we know him.” ");
INSERT INTO engPEV_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Jacob said, “How is he?” The work-men said, “He is good.” Then they said, “Look over there. Laban’s daughter Rachel is coming here with some sheep.” ");
INSERT INTO engPEV_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Then Jacob talked to the work-men again. He said, “Why are you mob waiting here, next to the water-hole? It’s only the middle of the day. It’s too early to bring your animals together to take them home. You should get water from the water-hole for your sheep to drink, and then take your sheep away and find grass for them to eat.” ");
INSERT INTO engPEV_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","But the work-men said, “No, we can’t do that yet. We always wait until all the other work-men come here with their sheep. After that, we will move that big stone that is on top of the water-hole, and then we will get water for our sheep to drink.” ");
INSERT INTO engPEV_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","While Jacob and the work-men were still talking to each other, Laban’s daughter Rachel came to the water-hole with some sheep. Those sheep belonged to Rachel’s father Laban, and Rachel looked after those sheep for her father. ");
INSERT INTO engPEV_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","As soon as Jacob saw Rachel and those sheep, he felt really happy, because Rachel was his relative. Her father Laban was the brother of Jacob’s mother. So Jacob quickly went to the water-hole, and he moved that big stone that was on top of the water-hole, and he got water for Laban’s sheep to drink. ");
INSERT INTO engPEV_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Then he kissed Rachel on the cheek, and he started to cry out loud because he was so happy. ");
INSERT INTO engPEV_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jacob said to Rachel, “I am your father’s relative. My mother’s name is Rebekah, and she is your father’s sister.” Then Rachel ran home and told her father Laban what happened. ");
INSERT INTO engPEV_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","As soon as Laban heard that his sister’s son Jacob came to Haran, he ran to meet Jacob. Then Laban hugged Jacob and kissed him on the cheek, and he took Jacob to his house. And Jacob told Laban about the things that happened to him. ");
INSERT INTO engPEV_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Then Laban talked to Jacob, and he said, “You and me, we are both from the same family.” After that, Jacob stayed at Laban’s house for one month, and he worked for Laban. ");
INSERT INTO engPEV_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","18","Jacob’s uncle Laban had 2 daughters. His older daughter was called Leah, and his younger daughter was called Rachel. Leah had pretty eyes, but Rachel was really beautiful. So Jacob loved Rachel, and he wanted to marry her. After one month, Laban talked to Jacob. Laban said, “You are working for me, but I am not paying you anything, because you are my relative. Is that fair? No way. I want to start paying you for the work that you do for me. Tell me, how much do you want me to pay you?” Jacob said, “You don’t have to pay me anything. I just want to marry Rachel, your younger daughter. If I work for you for 7 years, will you give her to me to marry?” ");
INSERT INTO engPEV_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Then Laban said, “All right. You are our relative, so it’s best for Rachel to marry you, not another man. Stay here and work for me for 7 years, and then I will give her to you to marry.” ");
INSERT INTO engPEV_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","So Jacob worked for Laban for 7 years, so that he could marry Rachel. Jacob really loved Rachel, and he felt really happy that he was going to marry her. He was so happy that those 7 years only felt like a few days. ");
INSERT INTO engPEV_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","At the end of those 7 years, Jacob said to Laban, “I worked for you for 7 years, just like you said. So now, let me marry your daughter Rachel.” ");
INSERT INTO engPEV_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Then Laban made a wedding party. He got all the people that lived in that place to come to that wedding party, and he gave them lots of good food. ");
INSERT INTO engPEV_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","But then, that night, Laban tricked Jacob. Laban took his daughter Leah to Jacob’s room, instead of his daughter Rachel. Then Jacob slept with Leah, like a man sleeps with his wife. But Jacob didn’t know that he slept with Leah. He thought that he slept with Rachel. ");
INSERT INTO engPEV_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","30","The next morning, Jacob saw that Leah was in his room, instead of Rachel. So Jacob was angry, and he went and talked to Laban. Jacob said, “You told me that I have to work for you for 7 years, and then I can marry Rachel. So I worked those 7 years, just like you said, but then you tricked me. You gave me Leah to be my wife, instead of Rachel. Why did you do that bad thing to me?” Laban said, “Leah is my older daughter, and Rachel is my younger daughter. In our culture, the older daughter always gets married first. That’s the reason why I gave you Leah to be your wife, instead of Rachel.” Then Laban said, “Listen, your wedding party will finish in one week. So spend this week with Leah, and after that, I will give you Rachel to marry as well. But after you marry Rachel, you have to work for me for 7 more years.” Jacob agreed to do what Laban said. After one week, Jacob and Leah’s wedding party finished. Then Laban gave his daughter Rachel to Jacob, and Jacob married Rachel as well. And Jacob slept with Rachel, like a man sleeps with his wife. So then Jacob had 2 wives, but he loved Rachel more than Leah. Laban had some women that worked for him. And Laban gave one of those women to his daughter Leah, to work for her, and he gave another of those women to his daughter Rachel, to work for her. The woman that worked for Leah was called Zilpah, and the woman that worked for Rachel was called Bilhah. Then Jacob worked for Laban for 7 more years. ");
INSERT INTO engPEV_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Jacob didn’t love his wife Leah. He only loved his wife Rachel. And God saw that Jacob didn’t love Leah. So God felt sorry for Leah, and he let her have kids. But Rachel couldn’t have any kids. ");
INSERT INTO engPEV_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","This is the story about Leah and her kids. A baby started to grow inside Leah, and she had a baby boy. Leah named that baby Reuben. That name means this is my son. And Leah said, “God saw that I was sad, so he gave me a son. Now I reckon my husband will love me.” ");
INSERT INTO engPEV_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Later on, Leah had another baby boy. And Leah said, “God heard that my husband doesn’t love me, so he gave me another son.” And Leah named that baby Simeon. That name means he heard. ");
INSERT INTO engPEV_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Later on, Leah had another baby boy. And Leah said, “Now I reckon my husband will love me and stay close to me, because I gave him 3 sons.” And Leah named that baby Levi. That name means stay close. ");
INSERT INTO engPEV_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Later on, Leah had another baby boy. And Leah said, “Now I will say thank you to God, and I will tell everybody that God is really great.” And Leah named that baby Judah. That name means thank you. After that, Leah stopped having babies for a while. ");
INSERT INTO engPEV_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Leah already had 4 kids with Jacob, but her sister Rachel didn’t have any kids. So Rachel got jealous of Leah. Then Rachel said to Jacob, “Give me kids. If you don’t, I will be so sad that I will die.” ");
INSERT INTO engPEV_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Then Jacob got angry with Rachel. Jacob said, “God is the one that stopped you from having kids. I can’t change that. I’m not God.” ");
INSERT INTO engPEV_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","So Rachel said, “All right, this is what you can do. Look, here is Bilhah, the woman that works for me. I want you to sleep with her, so that she will have babies. Bilhah belongs to me, so if she has babies, those babies will belong to me too. They will be just like my own kids.” ");
INSERT INTO engPEV_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Then Rachel gave Bilhah to Jacob, and Bilhah became Jacob’s wife. And Jacob slept with Bilhah, like a man sleeps with his wife. ");
INSERT INTO engPEV_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Then Bilhah had a baby boy. He was another son for Jacob. ");
INSERT INTO engPEV_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Then Rachel said, “God has been very good and fair to me. He heard me ask for kids, and he gave me a son.” And Rachel named that baby Dan. That name means he was fair. ");
INSERT INTO engPEV_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Later on, Jacob and Bilhah slept together again, like married people do. Then Bilhah had another baby boy. He was the 2nd son that she had for Jacob. ");
INSERT INTO engPEV_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Then Rachel said, “I used to be jealous of my sister Leah, because she had kids and I didn’t. But now I have 2 sons. It’s like I had a big fight with Leah, and I won.” And Rachel named that baby Naphtali. That name means my big fight. ");
INSERT INTO engPEV_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leah wanted to have more kids, but no babies grew inside her. So she thought, “I will get Jacob to marry my working woman Zilpah, so that she will have babies. Zilpah belongs to me, so if she has babies, those babies will belong to me too. They will be just like my own kids.” So Leah gave Zilpah to Jacob, and she became Jacob’s wife. ");
INSERT INTO engPEV_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Jacob slept with Zilpah, like a man sleeps with his wife, and she had a baby boy. He was another son for Jacob. ");
INSERT INTO engPEV_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Then Leah said, “I’m really lucky.” And Leah named that baby Gad. That name means lucky. ");
INSERT INTO engPEV_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Later on, Zilpah had another baby boy. He was another son for Jacob. ");
INSERT INTO engPEV_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Then Leah said, “I’m so happy. I reckon other women will say, ‘Leah is happy now.’” And Leah named that baby Asher. That name means happy. ");
INSERT INTO engPEV_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","One day, Leah’s oldest son Reuben went to the place where the wheat plants grow. At that time, some work-men were cutting down those wheat plants, to get the food from them. And Reuben found some special plants, called mandrakes, in that place. So Reuben took those mandrakes, and he gave them to his mother Leah. But Leah’s sister Rachel, she saw those mandrakes, and she wanted to have them. Rachel thought, “If I eat a mandrake, maybe I will have a baby.” You see, mandrakes were like bush medicine. People thought that if a woman eats a mandrake, it will help her have a baby. So Rachel said to Leah, “Please give me some of those mandrakes that your son found.” ");
INSERT INTO engPEV_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Then Leah got angry with Rachel. She said, “Listen, I married Jacob first, but he loved you and married you. It’s like you took my husband away from me. That’s really bad. And now, you want to take my son’s mandrakes too. No, you can’t have them.” But Rachel still wanted those mandrakes. So she said to Leah, “All right, if you give me your son’s mandrakes, you can sleep with Jacob tonight.” And Leah agreed. ");
INSERT INTO engPEV_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Later on, while the sun was going down, Jacob finished working outside, and he came back home. Leah went out to meet Jacob, and she said, “You have to sleep with me tonight. You see, my son found some mandrakes, but I gave those mandrakes to Rachel, so that I can sleep with you. It’s like I paid for you with those mandrakes.” So that night, Jacob slept with Leah, like a man sleeps with his wife. ");
INSERT INTO engPEV_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","God was good to Leah. He knew that Leah wanted to have more kids. So after Jacob slept with Leah, God made a baby start growing inside her. Later on, Leah had that baby, and it was a boy. He was another son for Jacob, and he was son number 5 for Leah. ");
INSERT INTO engPEV_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Then Leah said, “I reckon God is happy with me, because I let Jacob sleep with my working woman Zilpah. And now, God let me have another baby. It’s like God is paying me for that good thing I did.” And Leah named that baby Issachar. That name means pay. ");
INSERT INTO engPEV_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Later on, Leah had another baby boy, so Jacob had another son. He was son number 6 for Leah. ");
INSERT INTO engPEV_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Then Leah said, “God gave me lots of sons. They are like a really special present from God. Now I reckon my husband Jacob will respect me, because I gave him 6 sons.” And Leah named that baby Zebulun. That name means respect. ");
INSERT INTO engPEV_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Later on, Leah had a baby girl, and Leah named that baby Dinah. ");
INSERT INTO engPEV_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","23","But Leah’s sister Rachel still wanted to have her own kids. And God was good to Rachel, and he gave her what she wanted. Before this time, Rachel didn’t have any kids, but then God let a baby start growing inside her. Rachel had a baby boy. Then Rachel said, “I used to feel shame, because I didn’t have any kids. But now, God gave me a son, so I don’t feel shame any more.” ");
INSERT INTO engPEV_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","And Rachel named that baby Joseph. That name means he will give more. And Rachel said, “I’m asking God to give me another son.” ");
INSERT INTO engPEV_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","After Rachel had that baby, Jacob talked to his uncle Laban. Jacob said, “Let me go back to my home country. ");
INSERT INTO engPEV_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","And let me take my wives and my kids. You know, I worked really hard for you so that I could marry your daughters. So now, let me take them back to my home country.” ");
INSERT INTO engPEV_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","But Laban said, “Please listen to me. I’m asking you to stay here with me. You see, Yahweh your God is only good to me when you are here. I learned that by magic. ");
INSERT INTO engPEV_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","If you stay here, I will pay you to work for me. Just tell me how much you want, and I will pay you.” ");
INSERT INTO engPEV_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","30","Jacob said to Laban, “Look, you know that I worked really hard for you. When I came here, you only had a few animals. I looked after those animals for you, and they kept on having lots of babies, so now you have lots and lots of animals. Yes, Yahweh my God was good to you all the time that I worked for you. But I don’t have any animals myself. So now it’s time for me to look after myself and my own family.” ");
INSERT INTO engPEV_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Then Laban said, “All right, how much do you want me to pay you?” But Jacob said, “I don’t want you to pay me. I will keep on looking after your animals, if you will do this one thing for me. ");
INSERT INTO engPEV_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Today, let me go to the place where you keep your sheep and goats, and let me take some of those sheep and goats for myself. You know, most of your sheep have white wool, and most of your goats have black wool. I will not take any of those white sheep or any of those black goats. But you have some funny coloured sheep and goats too. You have some spotty goats and some black sheep. I will take those funny coloured sheep and goats, and they will belong to me. They will be my pay. ");
INSERT INTO engPEV_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Later on, those sheep and goats will have babies, and those babies will have funny coloured wool too. So they will belong to me. I promise I will never steal any white sheep or any black goats from you. Whenever you come and look at my sheep and goats, you will see that I only have spotty goats and black sheep. Then you will know that I kept my promise.” ");
INSERT INTO engPEV_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Then Laban said, “All right, I agree. You can take all the funny coloured sheep and goats, and they will belong to you.” ");
INSERT INTO engPEV_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","But that same day, Laban cheated Jacob. Laban went to the place where he kept his sheep and goats, and he took all the funny coloured ones away. He took the stripy goats and the spotty goats, any that had white bits on their wool, and he took all the black sheep. Then Laban gave those sheep and goats to his sons, to take them far away. ");
INSERT INTO engPEV_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","So his sons walked with those sheep and goats for 3 days, and then they stopped and camped. But Jacob stayed at Laban’s camp, and he looked after Laban’s other sheep and goats. All those sheep were white, and all those goats were black, and they belonged to Laban, just like he agreed with Jacob. So Jacob didn’t have any sheep or goats for himself. ");
INSERT INTO engPEV_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Then Jacob cut off some young green branches from 3 sorts of trees that were in that place. Those trees were called poplar trees, almond trees, and plane trees. Then Jacob pulled off some of the bark that was on the outside of those branches, so that he could see white bits under the bark. He did that so that those branches looked like they had spots on them. ");
INSERT INTO engPEV_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Then Jacob put those spotty branches in the place where the sheep and goats came to drink water. And whenever the sheep and goats came to that place to drink water, the males and females joined together to make babies. ");
INSERT INTO engPEV_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","So whenever the males and females did that, those spotty branches were there in front of them. Later on, when their baby animals were born, they had spots and stripes on their wool. ");
INSERT INTO engPEV_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jacob did another thing with Laban’s animals too. He took the white sheep, and he got those sheep to look at the stripy animals and the black animals. After the babies were born, Jacob split up the animals. He took all the funny coloured animals for himself, just like he agreed with Laban. But all the white sheep and black goats belonged to Laban. And Jacob didn’t mix them together. ");
INSERT INTO engPEV_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Jacob wanted his sheep and goats to be stronger than Laban’s, so he wanted the strong babies to be born with funny coloured wool. So whenever the strong sheep and strong goats came to drink water, Jacob put the spotty branches there, and the strong males and strong females joined together to make babies in front of those branches. Later on, when those babies were born, they were strong too, and they had funny coloured wool, so they belonged to Jacob. ");
INSERT INTO engPEV_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","But when the weak sheep and weak goats came to that place, Jacob didn’t put those branches in front of them. Then the weak sheep had white babies, and the weak goats had black babies, so they belonged to Laban. But the strong baby sheep and goats, they had funny coloured wool, so they belonged to Jacob. ");
INSERT INTO engPEV_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","In that way, Jacob got lots and lots of sheep and goats, and he became very rich. He also owned lots of men and women that worked for him, and lots of camels and donkeys. ");
INSERT INTO engPEV_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Laban’s sons talked to each other about Jacob. They said, “Jacob took everything that our father owned, and now it all belongs to Jacob, and he is rich.” And Jacob heard that Laban’s sons said those things. ");
INSERT INTO engPEV_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jacob also saw that Laban wasn’t friendly to him any more. ");
INSERT INTO engPEV_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Then God talked to Jacob. God said, “Leave this place, and go back to your home country, and to your relatives. I will go with you, to take care of you.” ");
INSERT INTO engPEV_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jacob wanted to talk about that with his wives, Rachel and Leah. So he sent somebody to get them, and he met them in the place where he kept his sheep and goats. ");
INSERT INTO engPEV_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Jacob said to them, “I can see that your father isn’t friendly to me any more. But God is still with me. He is the one that looked after my father Isaac, and he is with me. ");
INSERT INTO engPEV_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","You both know that I worked really hard for your father. ");
INSERT INTO engPEV_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","But your father kept cheating me. He promised to give me things for working for him, but then he kept changing his mind. He did that lots and lots of times. He wanted to give me trouble, but God didn’t let him. Yes, God looked after me. ");
INSERT INTO engPEV_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Sometimes your father promised to give me all the spotty sheep and goats, and then all the sheep and goats had babies with spots on their wool. And sometimes he promised to give me all the stripy sheep and goats, and then all the sheep and goats had babies with stripes on their wool. ");
INSERT INTO engPEV_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","You know, God was the one that made those things happen. It’s like God took away your father’s animals and gave them to me.” ");
INSERT INTO engPEV_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Then Jacob said, “One time, I had a dream. It was the month when the male and female animals join together to make babies. In that dream, I saw male and female goats joining together, and all the male goats had black and white spots and stripes on their wool. ");
INSERT INTO engPEV_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Then in that dream there was an angel messenger from God, and he said, ‘Jacob.’ And I said, ‘Yes, I am listening.’ ");
INSERT INTO engPEV_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","And he said, ‘God says, “Look at the male goats that are joining together with the female goats. You can see that all those male goats have black and white spots on their wool. That shows that I am helping you to get sheep and goats for yourself, because I know that Laban is cheating you. ");
INSERT INTO engPEV_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","I am God. A long time ago, I came to you at the place called Bethel. That’s the place where you poured olive oil on top of a stone to show that it was a special place, and you made promises to me. Now leave this country straight away, and go back to your home country.” ’” ");
INSERT INTO engPEV_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Then Rachel and Leah said to Jacob, “We will go with you. We don’t want to live here with our father any more. He will never give us anything. ");
INSERT INTO engPEV_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","He treats us like we are not part of his family. First, he got you to work for him so that you could marry us. It’s like he sold us to you. Then you worked really hard for our father, so that he got very rich. But our father still didn’t give us anything, even though we are his daughters. He cheated us, and he kept everything for himself. ");
INSERT INTO engPEV_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","But God took away some of our father’s animals and gave them to you, and you got rich. So now all those animals and good things, they belong to us and our kids.” Then Rachel and Leah said to Jacob, “Do whatever God told you to do.” ");
INSERT INTO engPEV_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","19","So Jacob and his family got ready to leave. Laban wasn’t there at that time. He was cutting the wool off his sheep out in the grass lands, a long way away. So Laban didn’t know that Jacob was getting ready to leave. And while Jacob was getting ready, Rachel went into Laban’s tent, and she stole some little statues that belonged to Laban. Sometimes, Laban and his family used to pray to those statues and ask them for help. They thought that those statues were gods that had power. Jacob went and got all his animals, and all the other things that he owned. You know, a long time before this, when Jacob came to Laban’s home, he didn’t own anything. But now he owned lots and lots of things. So Jacob took all those things that he owned, and he put them on camels. Then he helped his kids and his wives to get on camels, and he got his other animals to walk in front of him, and they all left quickly to go to Canaan country. That’s the country where Jacob’s father Isaac lived. ");
INSERT INTO engPEV_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","But Jacob tricked Laban, he didn’t tell Laban that he left. Laban belonged to the Aram tribe, and his country was called Paddan Aram. ");
INSERT INTO engPEV_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","So Jacob left Paddan Aram country with his wives, his kids, his animals, and everything that he owned. They crossed over the Euphrates River, and then they started to go south, towards the hill country called Gilead. ");
INSERT INTO engPEV_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","2 days later, somebody told Laban, “Jacob ran away.” ");
INSERT INTO engPEV_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","As soon as Laban heard that, he took some of his relatives with him, and they started to go after Jacob. 7 days later, they almost caught up to Jacob in the hill country called Gilead. ");
INSERT INTO engPEV_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","But that night, Laban had a dream, and he heard God talk to him in that dream. God said, “Be careful about the way you talk to Jacob. Don’t make trouble for him.” ");
INSERT INTO engPEV_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","The next day, Laban and his relatives caught up to Jacob. Jacob and his mob were in that hill country. That’s where they set up their tents. So Laban and his relatives, they set up their tents in that place too. ");
INSERT INTO engPEV_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Then Laban went and talked to Jacob. Laban said, “You did a bad thing to me. You tricked me, and you took my daughters away. It’s like I’m your enemy and you came and stole my daughters from me. ");
INSERT INTO engPEV_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","28","Why didn’t you tell me that you wanted to leave? You tricked me, and you ran away. That was a stupid thing to do. I didn’t get to say goodbye to you properly. I wanted to have a party for you, with people singing and playing music on drums and harps. You didn’t even let me kiss my daughters and my grand-kids and say goodbye to them.” ");
INSERT INTO engPEV_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Then Laban said to Jacob, “You know, I can hurt you and your family. But I will not do that. You see, last night, your father’s God talked to me. He said, ‘Be careful about how you talk to Jacob. Don’t make trouble for him.’” ");
INSERT INTO engPEV_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Laban kept on talking to Jacob. He said, “Look, I know that you want to see your father again, and that’s the reason why you left. But why did you steal my little statues from my tent?” You see, Laban didn’t know that his daughter Rachel stole those statues. He thought that Jacob stole them. ");
INSERT INTO engPEV_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Then Jacob talked to Laban. First, he told Laban why he ran away. He said, “I ran away because I was frightened of you. I thought that if I say, ‘I want to leave,’ then you will fight me and take your daughters away from me.” ");
INSERT INTO engPEV_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","After that, Jacob talked about those little statues that belonged to Laban. Jacob didn’t know that his wife Rachel stole those statues, so he said to Laban, “We didn’t take your little statues. You can look in our tents, and you can look at all our things. If you find those statues, then you can kill the person that stole them. And if you find anything else that belongs to you, then tell me, and show our relatives here, and you can have it back.” ");
INSERT INTO engPEV_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","So Laban went into Jacob’s tent, and he looked all around. But he didn’t find those statues. Then he went into Leah’s tent and he looked all around there too. And then he went into the tent that belonged to those 2 women that worked for Rachel and Leah. Laban looked all around that tent too, but he didn’t find those statues. After that, Laban went into Rachel’s tent. ");
INSERT INTO engPEV_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","He looked through everything in her tent, but he didn’t find those statues. You see, Rachel already hid those statues. She put them inside a soft seat, called a saddle, that she used to sit on when she rode her camel. Then she put that saddle on the ground, and she sat on it. ");
INSERT INTO engPEV_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","When Rachel’s father Laban came into the tent, Rachel said to him, “Sir, I’m sorry, I can’t stand up to show you respect, because I am bleeding, like a woman does every month. Please don’t be angry with me.” So Laban looked all around Rachel’s tent, but he didn’t find those statues. ");
INSERT INTO engPEV_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Then Jacob got very angry, and he talked strongly to Laban. Jacob said, “Listen, I didn’t do anything wrong to you. I didn’t do any bad thing. You came after me for no reason. ");
INSERT INTO engPEV_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","And you looked through all my things. If you found anything that belongs to you, then you can put those things here, in front of all our relatives. And they can say which one of us is right and which one is wrong. Did you find anything that belongs to you? No you didn’t. I didn’t take any of your things.” ");
INSERT INTO engPEV_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Then Jacob said to Laban, “I worked hard for you for 20 years, and I looked after your sheep and goats really well. They had lots of babies, and none of those babies died. And I never took any of your sheep for my food, not even your male sheep. ");
INSERT INTO engPEV_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","And whenever a wild animal killed one of your sheep or goats, I always paid for it. I never showed you that dead sheep or goat, I never asked you to pay for it. You made me pay for every sheep or goat that somebody stole, even if that happened at night time. That’s not fair. ");
INSERT INTO engPEV_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","And I had a really hard time when I worked for you. In the day time, it was really hot. And in the night time, it was really cold. It was so cold that I couldn’t sleep. ");
INSERT INTO engPEV_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","I worked for you like that for 20 years. First, I worked for you for 14 years so that I could marry your 2 daughters. Then I worked for you for 6 years, so that you would give me some of your sheep and goats. You kept promising to give me things for working for you, but then you kept changing your mind. That’s not fair.” ");
INSERT INTO engPEV_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Then Jacob said to Laban, “I know that you wanted to send me away with nothing. But God was with me, and he helped me. He is the one that looked after my grand-father Abraham. And my father Isaac respected him properly too. Yes, God helped me. He saw that I worked very hard for you, and he saw that you gave me trouble. So last night, he talked strongly to you, and he showed you that you did the wrong thing.” ");
INSERT INTO engPEV_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Then Laban said, “Your wives are my daughters. Your kids are my grand-kids. All these animals here, they belong to me, and everything else here belongs to me too. But I can’t get my daughters and my grand-kids back now. I know that they will go with you to your home country, and I will go back to my home country. ");
INSERT INTO engPEV_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","So before I go, let’s agree that we will be good to each other. And let’s put some stones in this place to show that we made that agreement.” ");
INSERT INTO engPEV_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","So Jacob got a big stone, and he stood it up. ");
INSERT INTO engPEV_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Then Jacob said to his relatives, “Pick up some more stones.” So they picked up some more stones, and they piled those stones on top of each other. Then Jacob, and Laban, and all their relatives, they sat down beside that pile of stones, and they ate some food. ");
INSERT INTO engPEV_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban named that pile of stones Jegar Sahadutha. That name comes from Laban’s language. And Jacob named that pile of stones Gal-Ed. That name comes from Jacob’s language. Both those names mean a pile that shows we agreed with each other. ");
INSERT INTO engPEV_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","And Laban said, “This pile of stones shows that we agreed with each other today.” So that place is called Gal-Ed. ");
INSERT INTO engPEV_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","50","Then Laban said to Jacob, “Tomorrow, you will go to your home country, and I will go back to my home country, and we will not see each other any more. So I’m asking Yahweh your God to always watch both of us. If you treat my daughters badly, or if you marry any other women, remember that God will see you do those things. Even if nobody else sees you, God will see you.” So that place is also called Mizpah. That name means place where he watches. ");
INSERT INTO engPEV_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Then Laban said to Jacob, “Look at this pile of stones, and this other big stone. We have put them here, between my country and your country. ");
INSERT INTO engPEV_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","This pile of stones, and this other big stone, they show that we agreed to be good to each other. I will not go past these stones into your country, to hurt you. And you will not go past these stones into my country, to hurt me. ");
INSERT INTO engPEV_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","I’m asking the gods of our grand-fathers to watch us and judge us. I’m asking the God of your grand-father Abraham, and the god of my grand-father Nahor and their father Terah. Those gods will keep on watching us, and they will know if one of us does the wrong thing.” Then Jacob made a strong promise to Laban. He said, “I promise that I will not go past these stones into your country, to hurt you. I’m making this promise with God listening. He is the one that my father Isaac respected.” ");
INSERT INTO engPEV_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Then Jacob killed an animal and burned it, to show respect to God. He did that right there, in the hill country. Then Jacob said to his relatives, “Come and eat food with me.” So they all ate food, and then they spent the night in that place. ");
INSERT INTO engPEV_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Early the next morning, Laban got up. He kissed his grand-kids and his daughters, and he said goodbye to them. Then Laban and his relatives left that place, and they went back to their home country. ");
INSERT INTO engPEV_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob and his relatives left that place, and they kept on going towards Jacob’s home country. On the way, some angel messengers from God came to meet Jacob. ");
INSERT INTO engPEV_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Jacob saw those angel messengers, and he said, “This place is God’s camp.” So Jacob called that place Mahanayim. That name means 2 camps. ");
INSERT INTO engPEV_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacob’s brother Esau lived in the place called Seir, in Edom country. Jacob thought, “Maybe my brother still wants to kill me.” So when Jacob got near to Seir, he said to some of his men, “Go and talk to my brother Esau. ");
INSERT INTO engPEV_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","I want him to know that I respect him, just like a work-man respects his boss. Tell Esau that I said, ‘I went and stayed with our uncle Laban for a long time, and now I’m coming back. ");
INSERT INTO engPEV_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","I have cows, and bulls, and donkeys, and sheep, and goats, and I have men and women that work for me. I sent some men to say these things to you, and I hope that you will be happy with me.’” So those men went and told Esau those things. ");
INSERT INTO engPEV_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Then those men came back, and they said to Jacob, “We went and talked to your brother Esau, and now he is coming here to meet you. He has 400 men with him.” ");
INSERT INTO engPEV_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jacob thought, “Maybe Esau and his men are coming to attack my camp.” Jacob was really frightened and worried. So he split up all the people that were with him into 2 camps. And he split up all his sheep and goats, and his cows, and his bulls, and his camels. He split up all those animals into 2 groups, and he put one group in one camp and the other group in the other camp. ");
INSERT INTO engPEV_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Jacob thought, “If Esau attacks one of those camps, maybe the people and the animals in the other camp will get away.” ");
INSERT INTO engPEV_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Then Jacob prayed to God, and he called God by his special name Yahweh. He said, “Yahweh, you are the God of my grand-father Abraham and the God of my father Isaac. You said to me, ‘Go back to your home country and your relatives, and I will be good to you.’ ");
INSERT INTO engPEV_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","God, you are my boss. You have been very good to me, just like you promised. I can always trust you. You did lots of good things for me, even though I’m not an important person. When I left my home country and I crossed over the Jordan River, I only had a walking stick with me. Now I’m going back to my home country, and I have lots and lots of people and animals with me. Yes, I have enough people and animals to make 2 camps.” ");
INSERT INTO engPEV_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Then Jacob said to God, “I’m frightened of my brother Esau. Maybe he will come and attack me and kill me, and even kill my wives and my kids. God, please save us from my brother. ");
INSERT INTO engPEV_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Remember that promise you made to me. You said, ‘I promise that I will be good to you, and I will give you a really big family. Lots of kids and grand-kids will be born into your family later on, and they will become a really big mob of people. Nobody will be able to count them, just like nobody can count all those little bits of sand that are at the beaches by the sea.’ Please be good to me and my family, God, just like you promised. Please don’t let my brother kill us.” ");
INSERT INTO engPEV_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jacob stayed in that place that night. He wanted to give his brother Esau a present, so he picked some of his animals to give to Esau. ");
INSERT INTO engPEV_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","He picked 200 female goats, 20 male goats, 200 female sheep, 20 male sheep, ");
INSERT INTO engPEV_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 female camels with their babies, 40 cows, 10 bulls, 20 female donkeys, and 10 male donkeys. ");
INSERT INTO engPEV_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Jacob split up all those animals into groups, and he gave each group to one of his work-men to look after. He said to those work-men, “Take these groups of animals, and go ahead of me to meet my brother Esau. But don’t all go at the same time. I want one group to go first. A bit later, I want the 2nd group to go. Then a bit later, I want the 3rd group to go. Keep on doing that until all the groups go.” ");
INSERT INTO engPEV_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Then Jacob talked to the work-man that was in charge of that 1st group of animals. He said, “You are going to meet my brother Esau first. I reckon he will say to you, ‘Who is your boss? Where are you going? And who do these animals belong to?’ ");
INSERT INTO engPEV_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Then I want you to say to him, ‘These animals belong to Jacob. He respects you, just like a work-man respects his boss. He sent these animals as a present for you. And he is coming to meet you too.’” ");
INSERT INTO engPEV_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Then Jacob talked to the work-men that were in charge of the other groups of animals. He said, “You will each meet my brother Esau, and I want you to say those same things to him. ");
INSERT INTO engPEV_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","And make sure you say, ‘Jacob is coming to meet you. He respects you.’” Jacob thought, “Maybe my brother will stop being angry with me, because I’m sending my work-men to give him presents. They will give him those presents, and then I will go and meet him. Maybe he will be friendly to me.” ");
INSERT INTO engPEV_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","So Jacob sent his work-men to give those animals to his brother Esau. But Jacob stayed in the camp. ");
INSERT INTO engPEV_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","That same night, Jacob got his 2 wives, and his 2 working women, and his 11 sons, and all the other men and women in his camp, and all the animals, and everything that he owned, and they left the camp, and they crossed over the Jabbok River. They all crossed over at a place where the river wasn’t deep. ");
INSERT INTO engPEV_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","But Jacob didn’t go with them. He stayed next to the river, and he was all alone. Then a man came and grabbed Jacob, and that man wrestled with Jacob. They kept on wrestling all night, until it was nearly time for the sun to come up. ");
INSERT INTO engPEV_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","That other man saw that he couldn’t win, so he touched the joint at the top of Jacob’s leg, and Jacob’s leg bone came out of the joint while they were wrestling. ");
INSERT INTO engPEV_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Then that man said to Jacob, “Let me go. It’s nearly time for the sun to come up.” But Jacob said, “No. First, I want you to promise that you will make things go well for me. Then I will let you go.” ");
INSERT INTO engPEV_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","The man said, “What is your name?” And Jacob said, “My name is Jacob.” ");
INSERT INTO engPEV_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Then the man said, “Now I’m giving you a new name. Your name will not be Jacob any more. You tried to fight with God and with people, and you won. So I’m giving you the name Israel.” That name Israel means fight with God. ");
INSERT INTO engPEV_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Then Jacob said to the man, “Please tell me your name.” But the man said, “You don’t need to ask my name.” Then he said to Jacob, “Things will go well for you.” And he left. ");
INSERT INTO engPEV_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jacob knew that God talked to him through that man, so he said, “I met God, and I’m still alive.” Then Jacob named that place Penuel. That name means God’s face. ");
INSERT INTO engPEV_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Then the sun came up, and Jacob left Penuel and started walking towards his family. Jacob couldn’t walk very well, because that man made his leg bone come out of the joint. ");
INSERT INTO engPEV_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Later on, the Israel mob made a special law about their food. They said, “God touched the joint at the top of Jacob’s leg bone. So when we kill an animal and eat it, we will not eat the stringy bits that are on the top of that animal’s leg bone.” And the Israel mob still keep that law today. ");
INSERT INTO engPEV_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jacob and his family kept on walking towards the place where Jacob’s brother Esau was. Then Jacob looked up and saw Esau coming towards him with 400 men. So Jacob stopped walking, and he split up his family into groups. He put his wife Leah with her kids, and he put his wife Rachel with her son Joseph, and he put his 2 working women with their kids. ");
INSERT INTO engPEV_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","3","Then they all started walking towards Esau again. Jacob walked in front, then the 2 working women and their kids, then Leah and her kids, then Rachel and her son Joseph. And Jacob got down on his knees and put his face near the ground, to show respect to his brother Esau. He did that 7 times, until he got near to Esau. ");
INSERT INTO engPEV_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","But Esau ran to meet Jacob. Then he put his arms around Jacob, and he hugged him and kissed him on the cheek. And Esau and Jacob both cried. ");
INSERT INTO engPEV_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Then Esau looked up, and he saw the women and their kids. Esau said, “Who are these people with you?” Jacob said, “These are my kids. God was very good to me, and he gave me these kids.” ");
INSERT INTO engPEV_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Then Jacob’s 2 working women and their kids, they came over to Esau, and they got down on their knees to show him respect. ");
INSERT INTO engPEV_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Then Leah and her kids, they did the same thing. They came over to Esau, and they got down on their knees. Then Rachel and her son Joseph, they came over and got down on their knees too. ");
INSERT INTO engPEV_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Then Esau said to Jacob, “I met your work-men walking along this road, and they gave me lots of animals, and they said, ‘These animals are a present from Jacob.’ Why did you send those animals to me?” Jacob said, “I respect you, just like a work-man respects his boss, and I want you to be happy with me. That’s the reason why I sent those animals to you.” ");
INSERT INTO engPEV_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","But Esau said, “My brother, I already have lots of animals, and I don’t need any more. Those animals that you sent to me, they belong to you. Keep them for yourself.” ");
INSERT INTO engPEV_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Then Jacob said to Esau, “No, I want you to have them. Please take them as a present from me. Then I will know for sure that you are happy with me. You know, when I saw you again, you were so friendly to me, it was like I saw God’s face. ");
INSERT INTO engPEV_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","So please take the present that I sent to you. God has given me lots of good things, and I already have everything that I need.” Jacob kept on talking like that, so Esau took those animals as a present from Jacob. ");
INSERT INTO engPEV_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Then Esau said, “Let’s go now. Let’s go to Seir, to the place where I live. We will go there together.” ");
INSERT INTO engPEV_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","But Jacob said to Esau, “Sir, as you can see, my kids are young, and they can’t walk very fast. And some of my animals have baby animals with them, and I have to look after those animals. If I make them walk fast, they will die after one day. ");
INSERT INTO engPEV_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","So please, sir, you go ahead. I will walk slowly with my kids and animals. Later on, we will see you there in Seir.” ");
INSERT INTO engPEV_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","So Esau said, “All right. But I will leave some of my men with you, to help you.” But Jacob said, “Sir, you don’t need to do that. You saw me, and you were friendly to me, so now I am happy. I don’t need anything else.” ");
INSERT INTO engPEV_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","So that same day, Esau left that place, and he went south to go back home to Seir. ");
INSERT INTO engPEV_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","But Jacob and his family, they went west. They stopped in the land there, and Jacob built a house, and he made shelters for his animals. Jacob called that place Succoth. That name means shelters. ");
INSERT INTO engPEV_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jacob was born in Canaan country, and he grew up there. But then he went to Paddan Aram country for a long time. Now he finally got back to his home country again. When he got there, he set up his camp on some land outside the town called Shekem. ");
INSERT INTO engPEV_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","That land where Jacob put his tent, it belonged to a man called Shekem and his brothers. Their father was called Hamor. And Jacob bought that land from Shekem and his brothers. He paid them 100 pieces of silver money for that land. ");
INSERT INTO engPEV_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Then Jacob piled up stones there to make a special table with a flat top, so that he could burn animals to show respect to God. And Jacob called it The God of Israel is God. ");
INSERT INTO engPEV_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","2","This story is about what happened to Jacob’s family in the town called Shekem, in Canaan country. The big boss of that town was called Hamor, and he was from the Hiv tribe. And Hamor had a son called Shekem. Jacob and Leah’s daughter was called Dinah, and she was a young woman. One day, she went out to visit some other women that lived in that place. But that man Shekem, he saw Dinah, and he wanted to have her for himself. So he grabbed Dinah and he made her sleep with him, like a woman sleeps with her husband. Shekem really shamed Dinah. ");
INSERT INTO engPEV_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Shekem fell in love with Dinah, and he thought that she was wonderful. So he talked to her and tried to get her to love him too. ");
INSERT INTO engPEV_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Then Shekem talked to his father Hamor and said, “I want to marry that woman. Ask her father to give her to me, so that she can be my wife.” ");
INSERT INTO engPEV_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","At that time, Jacob was in his camp, and Jacob’s sons were out in the grass lands looking after Jacob’s animals. Then somebody went and told Jacob that Shekem did that bad thing to his daughter Dinah. But Jacob didn’t say anything, because he wanted to wait for his sons to come home. ");
INSERT INTO engPEV_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","7","Then somebody went and told Jacob’s sons that Shekem did that bad thing to Dinah. So Jacob’s sons got really upset and angry. They said, “Shekem slept with our sister. That was a properly wrong thing that he did. He made our family shamed.” And Jacob’s sons left the grass lands, and they quickly went back to Jacob’s camp. Hamor, Shekem’s father, he went to Jacob’s camp to talk to Jacob, and Shekem went with him. ");
INSERT INTO engPEV_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","And Hamor talked to Jacob and his sons. Hamor said, “My son Shekem, he loves your daughter Dinah, and he really wants to marry her. Please give her to him, so that she can be his wife. ");
INSERT INTO engPEV_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","And let’s make an agreement between our families. Let’s agree that the men in my family can marry the women in your family, and the men in your family can marry the women in my family. ");
INSERT INTO engPEV_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","You mob can live in our land, and you can do whatever you want here. You can buy things and sell things here, and you can even buy some of the land for yourself.” ");
INSERT INTO engPEV_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Then Shekem talked to Dinah’s father Jacob and her brothers. He said, “Please be good to me and do what I ask, and I will give you whatever you want.” ");
INSERT INTO engPEV_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","In that culture, when a man married a woman, he used to pay money to that woman’s family and give them presents. So Shekem talked to Dinah’s father and brothers about that. He said, “Tell me how much money you want, and I will give it to you. Even if you want lots and lots of money and presents, I will give them to you. Please just let me marry that young woman Dinah.” ");
INSERT INTO engPEV_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","But Jacob’s sons were still thinking about that bad thing that Shekem did to their sister Dinah. So they pretended to make an agreement with Shekem and Hamor, but really, they were tricking them. ");
INSERT INTO engPEV_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Jacob’s sons said, “You know, all of us men and boys in our mob, we had a young man operation. But you mob don’t do that operation on your boys. We can’t let our sister marry a man that didn’t have that operation. That will make our family shamed. ");
INSERT INTO engPEV_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","So listen, we will make an agreement with you mob. You and all the men and boys in your mob, you have to have that young man operation. Then you will be like us. ");
INSERT INTO engPEV_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","If you agree to do that, then we will let our sister marry Shekem. We will let our women marry your men, and our men will marry your women. We will live with you, and our mob will join together with your mob, and we will become one tribe. ");
INSERT INTO engPEV_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","But if you will not agree to do what we say, if you will not do that young man operation on your boys and your men, then we will take our sister and we will leave this place.” ");
INSERT INTO engPEV_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamor and his son Shekem, they liked that idea, and they agreed to do what Jacob’s sons said. ");
INSERT INTO engPEV_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Shekem really loved Dinah, and he really wanted to marry her soon, so he went quickly to do those things. Shekem was the most important person in his father’s family. ");
INSERT INTO engPEV_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor and his son Shekem, they went to the town gate, and they had a meeting with the other men that lived in that town. Hamor and Shekem said to those men, ");
INSERT INTO engPEV_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“You know, that man Jacob and his sons, they are friendly to us. So let them live here in our land, and let them buy things and sell things here. Our land is big, and there is plenty of room for them. Our men can marry their women, and their men can marry our women. ");
INSERT INTO engPEV_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","But first, there is one thing that we have to do. All of us men and boys in our mob, we have to have a young man operation, just like Jacob and his family. If we do that, then Jacob and his sons will agree to live with us, and their mob will join together with our mob, and we will become one tribe. ");
INSERT INTO engPEV_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Then all their animals will belong to us, and everything else that they own, it will belong to us too. We just have to agree to do what they say. We have to have that young man operation. Then they will live here with us.” ");
INSERT INTO engPEV_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","The men that lived in that town, they listened to Hamor and his son Shekem, and they agreed to do what Hamor and Shekem said. So all the boys and all the men that lived in that town, they had a young man operation. ");
INSERT INTO engPEV_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","That young man operation hurt a lot. And 3 days later, all the men in Shekem’s mob still felt really weak. Then 2 of Jacob’s sons, they got some long knives, and they went to attack Shekem’s mob. Those 2 sons were Simeon and Levi, and they were Dinah’s brothers. Nobody in Shekem’s mob knew that Dinah’s brothers wanted to attack them, so they were not ready to fight. Simeon and Levi went into the town, and they killed all the boys and men there. ");
INSERT INTO engPEV_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","They also killed Hamor and his son Shekem with those long knives. At that time, Dinah was in Shekem’s house. So Simeon and Levi got Dinah from Shekem’s house, and they left the town. ");
INSERT INTO engPEV_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Then Jacob’s other sons went into the town, and they saw all the dead bodies of Shekem’s mob. So Jacob’s sons took everything that they wanted in that town. They thought, “Shekem did that bad thing to our sister, so we will take everything that belonged to his mob.” ");
INSERT INTO engPEV_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","They took all the sheep, and cows, and donkeys. They took everything that was in the town, and everything that was in the grass lands. ");
INSERT INTO engPEV_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","They took everything that was in the houses. And they got all the women and all the young kids, and they took them away, like they were prisoners. ");
INSERT INTO engPEV_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Then Jacob talked strongly to his sons Simeon and Levi. He said, “You made big trouble for me. You know about the other tribes that live in this land, the Canaan tribe and the Periz tribe. Well, now those tribes will hate us, because you finished up Shekem’s mob. And maybe those tribes will join together and attack us. My mob is small, so we will not be able to fight those big tribes, and then they will finish us up, me and my family.” ");
INSERT INTO engPEV_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","But Simeon and Levi said, “That man did a bad thing to our sister. He made her sleep with him, like a woman sleeps with her husband, and then he tried to pay us money for her. Somebody had to do payback to his mob.” ");
INSERT INTO engPEV_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Then God said to Jacob, “Leave this place, and go to that special place called Bethel. Remember, a long time ago, you ran away from your brother Esau, and you went to that place, and I came to you there. Now I want you to go and live in that place, and I want you to pile up stones there, to make a special table. Then I want you to burn animals on that special table, to show respect to me, because I am God.” ");
INSERT INTO engPEV_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","3","So Jacob talked to his family, and to all the other people that were in his camp. He said, “We are going to leave this place and go to the place called Bethel. I’m going to make a special table there, so that I can burn animals to show respect to God. You know, God is the one that helped me every time I got trouble, and he stayed with me wherever I went.” Jacob kept on talking to his mob. He said, “Some of you mob have little statues with you, that came from other countries. Some people think that those statues are gods that have power. You mob have to get rid of those statues. Then you all have to wash your bodies and put on clean clothes, because we are going to a special place to show respect to God.” ");
INSERT INTO engPEV_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","So Jacob’s family, and everybody else in Jacob’s camp, they went and got all their little statues, and they gave them to Jacob. They also took out the rings that were in their ears, and they gave those rings to Jacob too. And Jacob buried those statues and those rings under a big tree in the place called Shekem. ");
INSERT INTO engPEV_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Then Jacob and his mob left Shekem, and they started to go towards Bethel. Jacob thought that the people in the towns nearby might attack them. But God looked after Jacob’s mob. God made the people in those towns really frightened, so none of them attacked Jacob’s mob. ");
INSERT INTO engPEV_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Later on, Jacob and his mob got to the place called Bethel, in Canaan country. That place used to be called Luz. ");
INSERT INTO engPEV_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Then Jacob piled up stones to make a table with a flat top, so that he could burn animals to show respect to God. And Jacob gave that place a new name. He called it El Bethel. That name means God is in Bethel. A long time before this, when Jacob ran away from his brother Esau, God came and talked to Jacob in that place. That’s the reason why Jacob gave it that name. ");
INSERT INTO engPEV_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","At that time, there was a woman called Deborah in Jacob’s camp. She used to look after Jacob’s mother Rebekah, at the time when Rebekah was a little girl. Now Deborah was very old, and she died. So Jacob’s mob buried Deborah’s body under a big tree, near Bethel. And they called it Allon Bakuth. That name means big tree where they cried. ");
INSERT INTO engPEV_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","This is the story about how God talked to Jacob after he got back from Paddan Aram country. God came to Jacob, and he promised to be good to him. ");
INSERT INTO engPEV_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","God said, “Before this, your name was Jacob, but your name will not be Jacob any more. I’m giving you another name. That name is Israel.” In that way, God gave Jacob the name Israel. ");
INSERT INTO engPEV_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","And God said to Jacob, “I am God. I have power over everything. Your mob will have lots of kids, so that your family will get really big. Later on, your family will be so big that they will become a nation, and that nation will split up into lots of nations, and some of your people will be the big bosses of those nations.” ");
INSERT INTO engPEV_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Then God said, “A long time ago, I made promises to your grand-father Abraham and your father Isaac. I promised to give all this country to the people that will be born into their family. Well, now I’m making that same promise to you. I will give all this country to you and to the people that will be born into your family later on.” ");
INSERT INTO engPEV_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","God said all those things to Jacob, and then God left that place. ");
INSERT INTO engPEV_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jacob knew that God talked to him there, and he wanted to show that it was a special place. So he got a stone, and he stood it up. He poured out some wine on top of that stone, and he poured some olive oil on it too. ");
INSERT INTO engPEV_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","And Jacob gave a name to that place where God talked to him. He called that place Bethel. That name means God’s house. ");
INSERT INTO engPEV_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","17","Jacob and his family left Bethel, and they started going towards the town called Efrath. At that time, Jacob’s wife Rachel had a baby growing inside her. And while they were still a long way from Efrath, the time came for Rachel to have her baby. A woman came to help Rachel have her baby, but Rachel had a lot of pain, and she had trouble having that baby. Then Rachel had her baby, but that pain was really bad. That woman said to her, “Don’t be frightened. You have another son.” ");
INSERT INTO engPEV_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","But Rachel was dying. She said, “I want to name my son Ben-Oni.” That name means the son that I had when I was sad. Then Rachel died. But Jacob gave that baby a different name. He named him Benjamin. That name means the son that is like my strong right hand. ");
INSERT INTO engPEV_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","That’s how Rachel died. Then Jacob’s mob buried her near the road that goes to the town called Efrath. Another name for Efrath is Bethlehem. ");
INSERT INTO engPEV_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","And Jacob stood up a big stone at that place, so that people will know that Rachel was buried there. That stone is still there today. ");
INSERT INTO engPEV_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Then Jacob’s mob left that place. They went past a place called Migdal-Eder, and then they set up their camp. ");
INSERT INTO engPEV_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","While they were living there, Jacob’s son Reuben went to the woman called Bilhah. Bilhah worked for Jacob’s family, and she was like another wife for Jacob. And Reuben slept with Bilhah, like a man sleeps with his wife. Then somebody told Jacob that Reuben did that bad thing. These are the names of Jacob’s 12 sons. ");
INSERT INTO engPEV_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Jacob’s wife Leah had 6 sons, – Reuben. He was Jacob’s oldest son. – Simeon – Levi – Judah – Issachar – Zebulun ");
INSERT INTO engPEV_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Jacob’s wife Rachel had 2 sons, – Joseph – Benjamin ");
INSERT INTO engPEV_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rachel’s working woman Bilhah, she had 2 sons, – Dan – Naphtali ");
INSERT INTO engPEV_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leah’s working woman Zilpah, she had 2 sons, – Gad – Asher All those men were Jacob’s sons. Jacob’s sons were born at the time when Jacob lived in Paddan Aram country. Jacob’s other name was Israel. ");
INSERT INTO engPEV_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob went back home, to the place where his father Isaac lived. That place was called Mamreh, and it was near the town called Kiriath Arba. Another name for that town is Hebron. A long time before this, Jacob’s grand-father Abraham lived in Mamreh too. ");
INSERT INTO engPEV_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaac lived until he was 180 years old. ");
INSERT INTO engPEV_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isaac had a good long life, and then he breathed for the last time, and he died. Then his sons Esau and Jacob buried him. ");
INSERT INTO engPEV_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","This is the story about Jacob’s brother Esau and his family. Sometimes people called Esau a different name. They called him Edom. ");
INSERT INTO engPEV_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau married some women from Canaan country. These are the names of those women, – Adah. Her father’s name was Elon, and he was from the Heth tribe. – Oholibamah. Her father’s name was Anah. Her grand-father’s name was Zibeyon, and he was from the Hiv tribe. ");
INSERT INTO engPEV_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","– Basemath. Her father’s name was Ishmael, and her brother’s name was Nebayoth. ");
INSERT INTO engPEV_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","All of those women had sons with Esau. Adah had a son called Elifaz, Basemath had a son called Rewel, ");
INSERT INTO engPEV_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","and Oholibamah had 3 sons called Jeyush, Jalam, and Korah. That’s all the sons that Esau had, and they were all born in Canaan country. ");
INSERT INTO engPEV_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","8","Esau and his brother Jacob, they both lived in Canaan country. And Esau and Jacob both had lots and lots of animals. But there was a problem. There wasn’t enough grass and water in that country for all of Esau’s animals and all of Jacob’s animals. So Esau took his wives, his sons, his daughters, and everyone else that lived in his camp, and he took all his animals and everything else that he owned, and he left Canaan country. He went to the hill country called Seir, and he set up his camp there. That place was a long way away from Jacob. And you know, sometimes people called Esau a different name. They called him Edom. ");
INSERT INTO engPEV_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Esau’s family was called the Edom tribe, and they lived in the hill country called Seir. These are the names of Esau’s sons and grand-sons. ");
INSERT INTO engPEV_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esau’s 2 oldest sons were, – Elifaz. His mother’s name was Adah, and she was one of Esau’s wives. – Rewel. His mother’s name was Basemath, and she was another one of Esau’s wives. ");
INSERT INTO engPEV_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","These are the names of Elifaz’s sons, – Teman – Omar – Zefo – Gatam – Kenaz ");
INSERT INTO engPEV_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Esau’s son Elifaz had another son too. His name was Amalek, and his mother’s name was Timna. That woman Timna, she was like another wife for Elifaz. All those men were Elifaz’s sons. They were the grand-sons of Esau and his wife Adah. ");
INSERT INTO engPEV_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Esau’s son Rewel had sons too. These are the names of Rewel’s sons, – Nahath – Zerah – Shammah – Mizzah They were the grand-sons of Esau and his wife Basemath. ");
INSERT INTO engPEV_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau had another wife, and her name was Oholibamah. Her father’s name was Anah, and her grand-father’s name was Zibeyon. Oholibamah and Esau had 3 sons together. These are their names, – Jeyush – Jalam – Korah ");
INSERT INTO engPEV_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Esau’s tribe split up into clans, and all those clans had leaders. These are the names of those leaders. Esau’s oldest son Elifaz, he had these sons, – Teman – Omar – Zefo – Kenaz ");
INSERT INTO engPEV_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","– Korah – Gatam – Amalek All those men were Elifaz’s sons, and they were the leaders for their clans in Edom country. Their grand-mother was Esau’s wife Adah. ");
INSERT INTO engPEV_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","These are the sons of Esau’s son Rewel, – Nahath – Zerah – Shammah – Mizzah Those men were Rewel’s sons, and they were the leaders for their clans in Edom country. Their grand-mother was Esau’s wife Basemath. ");
INSERT INTO engPEV_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","These are the sons of Esau’s wife Oholibamah, – Jeyush – Jalam – Korah Those men were Oholibamah’s sons, and they were the leaders for their clans. Oholibamah’s father was called Anah. ");
INSERT INTO engPEV_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","All those sons of Esau, they were the leaders for their clans. And you know, sometimes people called Esau a different name. They called him Edom. ");
INSERT INTO engPEV_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","There was another tribe living in that country too. They lived there before Esau’s family came there. That tribe was called the Hor tribe. The people in that tribe were the kids and grand-kids of a man called Seir. These are the names of Seir’s sons, – Lotan – Shobal – Zibeyon – Anah ");
INSERT INTO engPEV_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","– Dishon – Ezer – Dishan All those men were Seir’s sons, and they were the leaders for their clans in Edom country. ");
INSERT INTO engPEV_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Seir’s son Lotan had these sons, – Hori – Hemam Lotan also had a sister called Timna. ");
INSERT INTO engPEV_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Seir’s son Shobal had these sons, – Alvan – Manahath – Ebal – Shefo – Onam ");
INSERT INTO engPEV_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Seir’s son Zibeyon had these sons, – Ayah – Anah. (Anah is the man that found springs in the desert. One day, he was out in the desert, and he was looking after some donkeys that belonged to his father Zibeyon. And he found some springs with hot water in them.) ");
INSERT INTO engPEV_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Seir’s son Anah had these kids, – Dishon – Oholibamah. She was Anah’s daughter. ");
INSERT INTO engPEV_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Seir’s son Dishon had these sons, – Hemdan – Eshban – Ithran – Keran ");
INSERT INTO engPEV_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Seir’s son Ezer had these sons, – Bilhan – Zavan – Akan ");
INSERT INTO engPEV_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Seir’s son Dishan had these sons, – Uz – Aran ");
INSERT INTO engPEV_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","These are the names of the leaders in the Hor tribe, – Lotan – Shobal – Zibeyon – Anah ");
INSERT INTO engPEV_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","– Dishon – Ezer – Dishan All those men were in the Hor tribe, and they were the leaders for their clans in the country called Seir. ");
INSERT INTO engPEV_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","At first, the Israel mob didn’t have big bosses over them. A long time later, they started having a big boss over them. But before that, the Edom mob had big bosses in their country. These are the names of those big bosses in Edom. ");
INSERT INTO engPEV_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","The 1st big boss in Edom country, his name was Bela. He lived in a town called Dinhabah, and his father’s name was Beor. ");
INSERT INTO engPEV_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela died, and then a man called Jobab became the big boss. He was from a town called Bozrah, and his father’s name was Zerah. ");
INSERT INTO engPEV_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab died, and then a man called Husham became the big boss. He was from the land of the Teman clan. ");
INSERT INTO engPEV_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husham died, and then a man called Hadad became the big boss. He was from a town called Avith, and his father’s name was Bedad. Hadad fought the Midian people in Moab country, and he won. ");
INSERT INTO engPEV_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad died, and then a man called Samlah became the big boss. He was from the town called Masrekah. ");
INSERT INTO engPEV_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlah died, and then a man called Shawl became the big boss. He was from the town called Rehoboth, next to the river. ");
INSERT INTO engPEV_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shawl died, and then a man called Baal-Hanan became the big boss. His father’s name was Akbor. ");
INSERT INTO engPEV_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal-Hanan died, and then a man called Hadad became the big boss. He lived in a town called Pau, and his wife’s name was Mehetabel. She was the daughter of Matred and the grand-daughter of Mezahab. ");
INSERT INTO engPEV_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Some people in Esau’s tribe were leaders for their clans. And all those clans lived in different places. These are the names of those clan leaders, – Timna – Alvah – Jetheth ");
INSERT INTO engPEV_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","– Oholibamah – Elah – Pinon ");
INSERT INTO engPEV_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","– Kenaz – Teman – Mibzar ");
INSERT INTO engPEV_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","– Magdiel – Iram Those people were the leaders for their clans in the Edom tribe. All those clans lived in different places. All the people in the Edom tribe were the kids and grand-kids of Esau. ");
INSERT INTO engPEV_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob lived in Canaan country. That’s the country where his father Isaac used to have his camp. ");
INSERT INTO engPEV_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","This is the story about what happened to Jacob’s family. Jacob’s son Joseph was 17 years old. And Joseph and his brothers looked after the sheep that belonged to their father Jacob. Joseph used to help 4 of his brothers to look after those sheep. 2 of those brothers were Bilhah’s sons, and the other 2 were Zilpah’s sons. Bilhah and Zilpah were Jacob’s wives. And Joseph told his father that those 4 brothers were doing bad things. ");
INSERT INTO engPEV_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Jacob loved Joseph more than his other sons, because Joseph was born when Jacob was an old man. So Jacob gave Joseph a special coat. ");
INSERT INTO engPEV_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Joseph’s brothers saw that their father loved Joseph more than them. So they hated Joseph, and they couldn’t talk in a friendly way to him. ");
INSERT INTO engPEV_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","One night, Joseph had a dream. The next day, he told his brothers about his dream, and they hated him even more. ");
INSERT INTO engPEV_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","This is what Joseph told his brothers. He said, “Listen to this dream that I had. ");
INSERT INTO engPEV_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","In my dream, you mob and me, we were out in the place where the wheat plants grow. We were cutting down those wheat plants to get the seeds from them for food. We cut down those wheat plants, and we put them in piles on the ground. Then we tied up those piles. Suddenly, the pile of wheat that I tied up, it got up from the ground, and it stood up straight, like a person. Then those piles of wheat that you mob tied up, they got up too. They went near to my wheat, and they bent down in front of it, to show it respect.” ");
INSERT INTO engPEV_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Then Joseph’s brothers thought, “That dream that Joseph had, it shows that he wants to be boss over us.” So they said to him, “Do you think that you are going to be a big boss over us? Do you think that you are going to tell us what to do? No way.” Joseph’s brothers were really angry about Joseph’s dream, and they were angry about those things that he said to them. So then they hated him even more. ");
INSERT INTO engPEV_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Later on, Joseph had another dream, and the next day, he told his brothers about his dream. He said to them, “Listen, I had another dream. In my dream, the sun, the moon, and 11 stars, they all bent down in front of me, to show me respect.” ");
INSERT INTO engPEV_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Joseph told his father about that dream too. Then Joseph’s father talked strongly to Joseph. He said, “That is a stupid dream. Do you really think that me and your mother and your brothers, we will all come and bend down in front of you, to show you respect? That will not happen.” ");
INSERT INTO engPEV_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Joseph’s brothers were really angry with him about those dreams, and they hated him even more. But Joseph’s father kept on thinking about those things that Joseph said. ");
INSERT INTO engPEV_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Jacob and his sons lived in a place called the Valley of Hebron. One day, Joseph’s brothers took their father’s sheep to the place called Shekem, so that the sheep had grass to eat. That place was a long way from Jacob’s camp. All of Joseph’s brothers went there, but Joseph stayed at home with his father Jacob. ");
INSERT INTO engPEV_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Then Jacob said to Joseph, “Your brothers are looking after my sheep in Shekem. I want you to go there and see how they are going.” And Joseph said, “Yes, I will go.” ");
INSERT INTO engPEV_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","So Jacob said to him, “Go and find out if everything is good with your brothers, and if everything is good with the sheep. Then come back here and tell me.” So Joseph left the Valley of Hebron, and he went to Shekem. ");
INSERT INTO engPEV_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","When he got to Shekem, he walked around in the grass lands and looked for his brothers. A man saw him and said, “What are you looking for?” ");
INSERT INTO engPEV_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Joseph said, “I’m looking for my brothers. They came to this place with my father’s sheep. Please, can you tell me where they are?” ");
INSERT INTO engPEV_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","The man said, “Your brothers left this place. I heard them say, ‘Let’s go to the place called Dothan.’” So Joseph left Shekem, and he went to Dothan. He saw his brothers there, and he started to go towards them. ");
INSERT INTO engPEV_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","But Joseph was still a long way away, and his brothers saw him coming. So they talked quickly to each other and made a plan to kill him. ");
INSERT INTO engPEV_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","They said to each other, “Look, there is the young man that has stupid dreams. ");
INSERT INTO engPEV_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Let’s kill him, and let’s throw his body into one of those big holes in the ground. Then we will tell our father, ‘A wild animal ate Joseph.’” Then they said, “If we kill Joseph, that will show that his dreams are rubbish, and that he will never be boss over us.” ");
INSERT INTO engPEV_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","But Joseph’s oldest brother Reuben, he heard his brothers say those things, and he wanted to save Joseph. So Reuben said, “No. We can’t kill him.” ");
INSERT INTO engPEV_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Then Reuben said to his brothers, “Don’t murder Joseph. Just chuck him into one of those big holes in the ground, here in the desert. Don’t hurt him yourselves, just leave him there to die.” You see, Reuben wanted to save Joseph from his brothers. He thought, “Later on, I will pull Joseph out of that hole, and I will take him home to our father.” ");
INSERT INTO engPEV_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Then Joseph got to his brothers. He was wearing that special coat that his father gave him. So Joseph’s brothers pulled that special coat off him. ");
INSERT INTO engPEV_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","And they grabbed him, and they chucked him into a big hole in the ground. That hole was empty, there wasn’t any water in it. ");
INSERT INTO engPEV_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Then Joseph’s brothers sat down to eat some food. While they were eating, they looked up, and they saw some men coming towards them with camels. Those men were from the Midian tribe. Their camels were carrying bags on their backs, and those bags had lots of bush medicine and perfumes. Those men were taking those things from Gilead country to Egypt country, to sell them there. ");
INSERT INTO engPEV_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","One of Joseph’s brothers was called Judah. He talked to the rest of his brothers, and he said, “We talked about killing Joseph and tricking our father. But if we kill Joseph, that will be a really bad thing, and we will not get anything for ourselves. ");
INSERT INTO engPEV_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","So let’s not kill him. Let’s sell him to this Midian mob. You know, Joseph is our brother, and we are all in the same family, so we shouldn’t hurt him.” The rest of Joseph’s brothers agreed to do what Judah said. ");
INSERT INTO engPEV_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","So when that Midian mob got near to them, Joseph’s brothers pulled Joseph out of that hole, and they sold him to the Midian mob for 20 pieces of silver money. Then the Midian mob took Joseph to Egypt country. ");
INSERT INTO engPEV_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Joseph’s brother Reuben was somewhere else, so he didn’t see his brothers sell Joseph to that Midian mob. He thought that Joseph was still in that hole in the ground. And Reuben wanted to save Joseph, so he went to that hole to get him out. But he saw that Joseph wasn’t in that hole any more, and he got really upset. He was so upset that he tore his clothes. ");
INSERT INTO engPEV_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Then he went back to his brothers, and he said to them, “Our young brother isn’t in that hole any more. I’m his oldest brother, but now there is nothing I can do to help him.” ");
INSERT INTO engPEV_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Joseph’s brothers wanted their father to think that an animal killed Joseph. So they killed a goat, and they got some of that goat’s blood, and they put the blood on that special coat that belonged to Joseph. ");
INSERT INTO engPEV_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Then they went back home, and they took Joseph’s special coat, and they showed it to their father Jacob. They said to their father, “Look, we found this coat. Does it belong to your son?” ");
INSERT INTO engPEV_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jacob looked at the coat, and he knew that it belonged to Joseph. So he said, “Yes, that is my son’s coat.” And Jacob saw the blood on that coat, so he said, “I know what happened. A wild animal ate Joseph. Yes, that animal tore him into little bits.” ");
INSERT INTO engPEV_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","So Jacob was really sad, because he thought that Joseph was dead. He was so sad that he tore his clothes. Then he put on some clothes made out of a rough cloth, called sack-cloth, and he cried. You see, in that culture, people sometimes tore their clothes and wore sack-cloth to show that they were sad. Jacob cried like that for lots of days. ");
INSERT INTO engPEV_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","All of Jacob’s sons and daughters, they talked to Jacob, and they tried to help him feel happy again. But Jacob said, “No, I can’t be happy again. I will keep on crying for my son, until I die and go to join him.” And Jacob cried a lot for Joseph. ");
INSERT INTO engPEV_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","But Joseph wasn’t really dead. That Midian mob, they took Joseph to Egypt country, and they sold him to a man called Potifar. That man Potifar, he worked for the big boss of Egypt, called Pharaoh. Potifar was in charge of all the soldiers that guarded Pharaoh’s house. ");
INSERT INTO engPEV_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","This story is about something that Jacob’s son Judah did. Judah left his brothers, and he went to stay with a man from the town called Adullam. That man’s name was Hirah. ");
INSERT INTO engPEV_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","While Judah was staying in that place, he saw a young woman. That woman’s father was called Shua, and he was from the Canaan tribe. Judah married that young woman, and he slept with her. ");
INSERT INTO engPEV_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Then that woman had a baby boy, and Judah named him Er. ");
INSERT INTO engPEV_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Later, that woman had another baby boy, and she named him Onan. ");
INSERT INTO engPEV_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","And later, she had another baby boy too. She named that baby Shelah. At that time, Judah was staying in the town called Kezib. ");
INSERT INTO engPEV_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judah’s oldest son Er, he grew up and became a man. And Judah found a woman for Er to marry. That woman’s name was Tamar. ");
INSERT INTO engPEV_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","But Judah’s oldest son Er, he did really bad things, and God was angry with him. So God finished up Er, and he died. ");
INSERT INTO engPEV_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Then Judah talked to his 2nd son Onan. Judah said, “Your brother Er is dead, and he didn’t have any kids. So now, you have to marry Er’s wife and sleep with her, so that she will have kids. That’s the rule in our culture. And after those kids grow up, they will get everything that belonged to Er. It will be like they are his kids.” ");
INSERT INTO engPEV_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","So Onan married Er’s wife. But Onan didn’t want to have kids with her, because he knew that those kids will not belong to him. So Onan did a bad thing. Every time they slept together, like married people do, he didn’t sleep with her properly. He always stopped early, so she didn’t get any babies growing inside her. ");
INSERT INTO engPEV_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","But God was angry with Onan for doing that bad thing, so God finished up Onan too. ");
INSERT INTO engPEV_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Then Judah thought, “My sons Er and Onan, they are both dead, and they didn’t have any kids with that woman. So now, my other son Shelah has to marry that woman and have kids with her. That’s the rule in our culture. But if Shelah marries that woman, he might die too, just like Er and Onan.” So Judah got worried, and he didn’t want his son Shelah to marry that woman Tamar. So Judah talked to Tamar, and he tried to trick her. He said to her, “My son Shelah is too young to marry you now. So go back to your father’s house, and live there. Don’t get married to anyone else. Later on, Shelah will grow up, and then you can marry him.” So Tamar went back to her father’s house, and she lived there. Judah’s son Shelah grew up and became a man. But Judah didn’t keep that promise he made to Tamar. He didn’t let her marry his son Shelah. ");
INSERT INTO engPEV_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Some time later, Judah’s wife died. Her father’s name was Shua. Judah missed his wife, so he felt very sad for a while. But later on, he felt all right again. Judah’s work-men were in the place called Timnah. They were cutting the wool off Judah’s sheep. Judah wanted to visit his work-men, so he started to go towards Timnah, and his friend Hirah went with him. That man Hirah, he was from the town called Adullam. ");
INSERT INTO engPEV_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Then somebody told that woman Tamar, “Your dead husband’s father is going to Timnah to visit his work-men. They are cutting the wool off his sheep there.” ");
INSERT INTO engPEV_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamar thought about Judah’s son Shelah. She knew that he was grown up now, but Judah still didn’t let her marry him. So Tamar thought, “I will trick Judah and get him to sleep with me, like a man sleeps with his wife, so that I can have kids. Then those kids will belong to my dead husband Er.” At that time, Tamar was wearing the sort of clothes that widows wear. But then, Tamar changed those clothes, and she put on some pretty clothes, and she put a scarf over her head, to cover her face. Then she went and sat outside the town called Enayim. That town is on the road that goes to Timnah. ");
INSERT INTO engPEV_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","16","Later, Judah walked along that road, and he saw Tamar sitting there. She had that scarf over her head, and Judah couldn’t see her face. So Judah didn’t know that she was Tamar, his dead son’s wife. He thought she was a woman that sleeps with men for pay. So Judah went to her, and he said, “I want to sleep with you, like a man sleeps with his wife.” Tamar said, “If I sleep with you, then you have to give me something to pay me. What will you give me?” ");
INSERT INTO engPEV_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Judah said, “After you sleep with me, I will send you one of my young goats.” Tamar said, “All right. But first, you have to give me something that belongs to you, to show that you promised to send me a young goat.” ");
INSERT INTO engPEV_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Judah said, “All right, I will give you something to show that I made that promise. What do you want me to give you?” Tamar said, “Give me that necklace with your special stamp on it, and your walking stick.” (Judah used that special stamp like a signature.) So Judah gave those things to Tamar. Then he slept with Tamar, like a man sleeps with his wife, and a baby started to grow inside her. ");
INSERT INTO engPEV_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Then Tamar left that place, and she went home. She took off the scarf that was over her head, and she took off those pretty clothes, and she put on her widow’s clothes again. ");
INSERT INTO engPEV_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Judah talked to his friend Hirah, and he said, “Take one of my young goats, and give it to that woman that I slept with. Then tell her to give back my necklace with my special stamp on it, and my walking stick.” So Hirah took that young goat, and he went to look for that woman, but he didn’t find her. ");
INSERT INTO engPEV_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","So he talked to the men that lived in that place, and he said, “Where is that woman that sleeps with men for pay? She was sitting next to the road, near the place called Enayim.” But those men said, “There isn’t any woman here that sleeps with men for pay.” ");
INSERT INTO engPEV_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","So Hirah went back to Judah, and he said, “I didn’t find that woman. And the men that live in that place, they said to me, ‘There isn’t any woman here that sleeps with men for pay.’” ");
INSERT INTO engPEV_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Then Judah said to Hirah, “All right, that woman can keep the necklace with my stamp on it, and my walking stick. I tried to keep my promise to that woman. Yes, I gave you a young goat to take to her. But you didn’t find her. If you go and look for her again, everybody will laugh at us. So she can just keep my things.” ");
INSERT INTO engPEV_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","3 months later, somebody said to Judah, “Your dead son’s wife Tamar, she did a bad thing. She slept with a man that isn’t her husband. And now there is a baby growing inside her.” Judah wanted to punish Tamar for doing that. So he said, “Go and get her. Put her on a fire, and burn her until she dies.” ");
INSERT INTO engPEV_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","So some people went to Tamar’s house, and they started to take her to the place to burn her. But she said to them, “Take this necklace with a special stamp on it, and this walking stick, and show them to Judah, my dead husband’s father. Say to him, ‘The man that owns these things, he is the one that slept with me and made this baby grow inside me. So please look at this necklace with the special stamp on it, and this walking stick, and say who they belong to.’” ");
INSERT INTO engPEV_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","So they took those things to Judah, and they told him what Tamar said. And Judah looked at those things, and he knew that they belonged to him. Then Judah knew that Tamar tricked him, and he felt shame. He said, “You know, I did the wrong thing. I didn’t let Tamar marry my son Shelah. But Tamar is better than me. She wanted to have kids that will belong to her dead husband, just like our culture says. That’s the reason why she got me to sleep with her.” So Judah didn’t punish Tamar, and he never slept with her again. ");
INSERT INTO engPEV_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Later on, the time came for Tamar to have her baby. At that time, Tamar found out that she had 2 babies inside her. ");
INSERT INTO engPEV_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","There was a working woman there with Tamar, and that woman helped Tamar while she had her babies. The 1st baby started to be born. His arm came out. And that working woman, she tied a bit of red string around that baby’s arm, and she said, “This baby is first.” ");
INSERT INTO engPEV_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","But then, that baby pulled his arm back in, and the 2nd baby came out. Then that working woman was shocked, because that 2nd baby came out before his brother. She talked to that 2nd baby, and she said, “You pushed really hard, and you came out first. It’s like you broke out through a wall.” So they named that baby Perez. That name means break out. ");
INSERT INTO engPEV_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Then the other baby came out, with that bit of red string tied around his arm. And they named that baby Zerah. ");
INSERT INTO engPEV_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","This is the story about what happened to Joseph, after that time when his brothers sold him to the Midian mob. That Midian mob took Joseph to Egypt country. Then they sold Joseph to a man called Potifar. That man Potifar, he worked for the big boss of Egypt country, called Pharaoh. Potifar was in charge of all the soldiers that guarded Pharaoh’s house. ");
INSERT INTO engPEV_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","God was with Joseph, and God helped him. So everything that Joseph did, it all went well. Joseph worked for Potifar, and he lived in Potifar’s house. ");
INSERT INTO engPEV_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potifar saw that Joseph did everything really well, and he knew that God was helping him. ");
INSERT INTO engPEV_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","So Potifar liked Joseph a lot, and he got Joseph to be his special worker. He put Joseph in charge of all the other workers in his house, and he got Joseph to look after everything that he owned. ");
INSERT INTO engPEV_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","As soon as Potifar put Joseph in charge, God started to be really good to Potifar. God made everything go well in Potifar’s house, and he made lots of food plants grow on his land. ");
INSERT INTO engPEV_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","So Potifar really trusted Joseph, and he let Joseph look after everything that belonged to him. Potifar didn’t worry about anything, because Joseph was in charge. Potifar just got to think about easy things, like the food he wanted to eat. Joseph looked after everything else. Joseph was a really good-looking man, with a strong body. ");
INSERT INTO engPEV_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","So after a while, Potifar’s wife started to look at Joseph a lot, and she wanted to sleep with him, like a woman sleeps with her husband. She said to Joseph, “Come and sleep with me.” ");
INSERT INTO engPEV_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","But Joseph said, “No, I will not sleep with you. You know, I work for your husband, and he trusts me. He got me to look after everything that belongs to him. He doesn’t worry about anything, because I am in charge. ");
INSERT INTO engPEV_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","He made me the most important person in his house. He made me the boss of everything here. There’s only one thing he will not let me touch. He will not let me touch you, because you are his wife. So I will not sleep with you. I will not go against God and do that wrong thing. No way.” ");
INSERT INTO engPEV_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","But Potifar’s wife did not stop. Every day, she kept on asking Joseph to sleep with her. But Joseph didn’t listen to her. He didn’t sleep with her, and he tried to be far away from her. ");
INSERT INTO engPEV_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","One day, Joseph went into Potifar’s house to do his work, just like he always did. On that day, there weren’t any other work-men in the house. ");
INSERT INTO engPEV_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Then Potifar’s wife came to Joseph. She grabbed him, and she held on to his coat, and she said, “Come and sleep with me.” So Joseph quickly ran out of the house. But Potifar’s wife still had Joseph’s coat in her hand. ");
INSERT INTO engPEV_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Potifar’s wife saw that Joseph ran out of the house, and she saw that she still had his coat in her hand. So she thought, “I will make trouble for Joseph.” ");
INSERT INTO engPEV_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Straight away, she shouted to the other work-men, and she said, “Come and see this.” Then those work-men came to her, and she lied to them and said, “You know, my husband brought a man here from the Hebrew tribe. That man doesn’t respect us mob. He wants to make fun of us. He came to me, and he tried to make me sleep with him, like a man sleeps with his wife. But I yelled out really loud. ");
INSERT INTO engPEV_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","And as soon as he heard me yell out, he left his coat next to me, and he ran out of the house.” ");
INSERT INTO engPEV_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","After that, Potifar’s wife put down Joseph’s coat next to her, and she waited for Potifar to come home. Potifar was Joseph’s boss. ");
INSERT INTO engPEV_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Later on, Potifar came home, and his wife said the same things to him that she said to those work-men. She lied and said, “That work-man from the Hebrew tribe, the one that you brought here, he came to me, and he tried to sleep with me and make me shamed. ");
INSERT INTO engPEV_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","But I yelled out really loud, and straight away, he ran out of the house, and he left his coat next to me.” ");
INSERT INTO engPEV_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Potifar heard his wife say that Joseph did those bad things to her. And Potifar got really angry. ");
INSERT INTO engPEV_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Potifar was Joseph’s boss, so he sent his men to grab Joseph, and they put him in jail. That jail belonged to Pharaoh, the big boss of Egypt country. There were other prisoners in that jail too. And Joseph stayed there in the jail. ");
INSERT INTO engPEV_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","But God was with Joseph, and God kept on being very good to him. God got the boss of that jail to think in a good way about Joseph. So that jail boss liked Joseph a lot, ");
INSERT INTO engPEV_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","and he put Joseph in charge of all the other prisoners in that jail. Whenever those prisoners had work to do, Joseph was their leader, and he made sure that they did their work properly. ");
INSERT INTO engPEV_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Joseph did everything well, so that jail boss didn’t worry about anything. He trusted Joseph to look after the prisoners and get all the work done. You see, God was with Joseph, and God made everything go well for him. ");
INSERT INTO engPEV_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Some time later, Joseph was still in jail in Egypt country. The big boss of Egypt country was called Pharaoh, and he had lots of men that worked for him. This story is about 2 of those men. The 1st man was Pharaoh’s wine-boss. He used to make wine and other special drinks for Pharaoh. The 2nd man was Pharaoh’s bread-boss. He used to cook bread and cakes for Pharaoh to eat. Both of those men were important workers in Pharaoh’s house. One day, that wine-boss and that bread-boss, they both did something that made Pharaoh really angry. ");
INSERT INTO engPEV_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","So Pharaoh put those 2 men in jail. That jail was the same one that Joseph was in. The soldier that guarded that jail, he was in charge of all the soldiers that looked after Pharaoh’s house. ");
INSERT INTO engPEV_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","That soldier said to Joseph, “You have to look after these 2 men.” So Joseph looked after that wine-boss and that bread-boss. And those 2 men stayed in jail for a long time. ");
INSERT INTO engPEV_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","One night, that wine-boss and that bread-boss, they were both sleeping in the jail, and they both had dreams. Both those dreams showed things that will happen later on. But those 2 men didn’t understand what those dreams meant. So they felt sad and worried. ");
INSERT INTO engPEV_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","The next morning, Joseph went to those 2 men, like he always did. He looked at their faces, and he saw that they were sad and worried. ");
INSERT INTO engPEV_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","So he said to them, “Why are you so sad and worried today?” ");
INSERT INTO engPEV_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Then those 2 men said to Joseph, “We both had dreams last night, but we don’t understand what those dreams mean, and there is nobody here that can tell us what they mean.” Joseph said, “Only God can tell people what dreams mean. Please tell me about your dreams. God will show me what they mean.” ");
INSERT INTO engPEV_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","So the wine-boss told Joseph about his dream. He said, “In my dream, I saw a grape vine. ");
INSERT INTO engPEV_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","That grape vine had 3 branches. Little flowers started to grow on those branches, then straight away, those flowers got big, and grapes grew from them, then those grapes got big. ");
INSERT INTO engPEV_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","I had Pharaoh’s cup in my hand. So I took those grapes, and I squeezed the juice into Pharaoh’s cup. Then I gave that cup of juice to Pharaoh.” ");
INSERT INTO engPEV_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Then Joseph said to the wine-boss, “All right, I will tell you what that dream means. Those 3 branches that you saw, they are like a picture of 3 days. ");
INSERT INTO engPEV_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","In 3 days time, Pharaoh will take you out of this jail, and he will get you to work for him again. You will make wine and other special drinks, just like you did before, and you will take those drinks and give them to Pharaoh.” ");
INSERT INTO engPEV_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Then Joseph said to the wine-boss, “Now you know that everything will go well for you. So please be good to me, and don’t forget about me. Please talk to Pharaoh, and say good things about me. Then maybe Pharaoh will take me out of this jail, and he will let me go free. ");
INSERT INTO engPEV_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","You know, I am from the Hebrew tribe, and I used to live with my people, in my home country. But then some men grabbed me, and they took me away from my home country, and they brought me here to Egypt country. And now I’m in jail, even though I didn’t do anything wrong.” ");
INSERT INTO engPEV_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","The wine-boss listened to all those things that Joseph said, and the bread-boss listened too. That bread-boss thought, “That other man’s dream meant something good, so maybe my dream means something good too.” So the bread-boss talked to Joseph, and he said, “I had a dream too. In my dream, there were 3 baskets of special bread on my head. ");
INSERT INTO engPEV_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","The basket that was on top, it had all sorts of bread and cakes in it, and they were for Pharaoh to eat. But some birds were there, and they ate the bread and cakes that were in that basket.” ");
INSERT INTO engPEV_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Then Joseph said, “I will tell you what that dream means. Those 3 baskets that you saw, they are like a picture of 3 days. ");
INSERT INTO engPEV_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","In 3 days time, Pharaoh will take you out of this jail, and his soldiers will cut off your head. Then they will hang your body on a pole, and birds will come and eat bits of your body.” ");
INSERT INTO engPEV_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","3 days later, it was Pharaoh’s birthday. So Pharaoh had a big party, with lots of good food, and he got all his important workers to come to that party. And Pharaoh got his soldiers to go and get that wine-boss and that bread-boss out of the jail. ");
INSERT INTO engPEV_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Then Pharaoh got that wine-boss to work for him again. He made wine and other special drinks, just like he did before, and he took those drinks and gave them to Pharaoh. ");
INSERT INTO engPEV_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","But Pharaoh got his soldiers to kill that bread-boss, and they hung his body on a pole. All those things happened just the way Joseph said. ");
INSERT INTO engPEV_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","But that wine-boss forgot about Joseph, and he didn’t talk to Pharaoh about him. ");
INSERT INTO engPEV_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","2 years later, Pharaoh, the big boss of Egypt, he had a dream. In his dream, he stood next to the Nile River, ");
INSERT INTO engPEV_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","and he saw 7 cows coming up from the river. Those 7 cows were good-looking and fat, and they started to eat the long grass that was beside the river. ");
INSERT INTO engPEV_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","After that, another 7 cows came up from the river. Those other 7 cows were ugly and skinny, and they stood beside the river next to the 7 fat cows. ");
INSERT INTO engPEV_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Then those 7 ugly, skinny cows, they ate the 7 good-looking, fat cows. That was the end of Pharaoh’s dream, and he woke up. ");
INSERT INTO engPEV_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Then Pharaoh went to sleep again, and he had another dream. In his dream, he saw a plant that grows seeds for food, called wheat. That wheat plant had 1 stick part, and on top were 7 groups of wheat seeds growing on it. Each group had lots of good big seeds. ");
INSERT INTO engPEV_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","After that, another 7 groups of seeds started to grow. But they were small and dry, because a hot dry wind blew on them. ");
INSERT INTO engPEV_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Then those 7 groups of small dry seeds, they ate the 7 groups of good big seeds, like a person eats food. That was the end of Pharaoh’s dream, and he thought it was real. Then he woke up, and he knew that it was a dream. ");
INSERT INTO engPEV_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","The next morning, Pharaoh felt very worried, because he didn’t know what those 2 dreams meant. So he said to some of his workers, “You know, there are some men here in Egypt country that can do magic, and there are some other men that are really wise. Go and get all those men, and bring them here. I want somebody to tell me what my dreams mean.” So Pharaoh’s workers went and got all those men, and they brought them to Pharaoh. Then Pharaoh told them about those 2 dreams that he had. But none of those men understood what the dreams meant. ");
INSERT INTO engPEV_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Pharaoh’s wine-boss was there, and he remembered that time when he had a dream in the jail, and he remembered that Joseph told him what his dream meant. So that wine-boss said to Pharaoh, “Sir, now I remember a time that I did the wrong thing. ");
INSERT INTO engPEV_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","You know, some time ago, you got really angry with me and your bread-boss. You put us in jail, and your most important soldier guarded us. ");
INSERT INTO engPEV_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Then one night, me and that bread-boss, we both had dreams. We knew that those dreams showed things that will happen later on, but we didn’t know what they meant. ");
INSERT INTO engPEV_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","But there was a young man with us in the jail. He was from the Hebrew tribe, and he worked for that important soldier, the one that guarded us. We told that young man about our dreams, and he told us what they meant. He said to me, ‘Your dream shows that Pharaoh will get you to work for him again.’ And he said to the bread-boss, ‘Your dream shows that Pharaoh will get his soldiers to kill you.’ ");
INSERT INTO engPEV_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","And everything happened just like that young man said. Soon after that, you got me to work for you again. But you got your soldiers to kill the bread-boss and hang his body on a pole.” ");
INSERT INTO engPEV_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Then Pharaoh sent some of his workers to go and get Joseph. Those workers quickly went and took Joseph out of the jail. Then Joseph got ready to go and see Pharaoh. He cut his hair, and he shaved his beard, and he put on clean clothes. Then he went and stood in front of Pharaoh. ");
INSERT INTO engPEV_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pharaoh said to Joseph, “I had a dream, and nobody can tell me what it means. But somebody told me that you can understand dreams. They said that if somebody tells you about their dream, you can say what it means.” ");
INSERT INTO engPEV_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseph said to Pharaoh, “Sir, I can’t do that by myself. God is the one that lets me understand people’s dreams. He will show me what your dream means, and it will be good for you to hear it.” ");
INSERT INTO engPEV_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","So Pharaoh told Joseph about his dream. He said, “In my dream, I stood next to the Nile River. ");
INSERT INTO engPEV_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Then 7 cows came up from the river. Those 7 cows were good-looking and fat, and they started to eat the long grass that was beside the river. ");
INSERT INTO engPEV_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","After that, another 7 cows came up from the river. Those other cows looked really weak and sick, and they were very ugly and skinny. They were more ugly and skinny than any cows I saw in Egypt country. ");
INSERT INTO engPEV_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Then those 7 ugly, skinny cows, they ate those 7 good-looking, fat cows, those ones that came up first from the river. ");
INSERT INTO engPEV_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","But after that, those ugly, skinny cows looked just the same as before. They were still very ugly and skinny, even though they ate those fat cows. That was the end of my dream, and I woke up.” ");
INSERT INTO engPEV_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Then Pharaoh said, “I went to sleep again, and I had another dream. In my dream, I saw a wheat plant. That wheat plant had 1 stick part with 7 groups of wheat seeds growing on top, and they had lots of good big seeds. ");
INSERT INTO engPEV_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","After that, another 7 groups of seeds started to grow. They were small and dry, because a hot dry wind blew on them. ");
INSERT INTO engPEV_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Then those 7 groups of small dry seeds, they ate the 7 groups of good big seeds, like a person eats food. That was the end of my dream.” Then Pharaoh said to Joseph, “I talked to the men that can do magic, and I told them about those dreams that I had. But they don’t know what my dreams mean.” ");
INSERT INTO engPEV_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Then Joseph said to Pharaoh, “Sir, both those dreams mean the same thing. God gave you those dreams to show you what he is going to do next.” ");
INSERT INTO engPEV_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Then Joseph told Pharaoh what those dreams meant. First Joseph said, “Those 7 good-looking, fat cows that you saw in your dream, they are like a picture of 7 good years. And those 7 groups of good big seeds on the wheat plant, they are like a picture of 7 good years too. Both those dreams mean the same thing.” ");
INSERT INTO engPEV_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Then Joseph said, “And you know those 7 ugly, skinny cows, those ones that came up from the river later on, they are like a picture of 7 dry years with no rain and no food plants growing. And you know those 7 small groups of seeds on the wheat plant. They were dry, because a hot dry wind blew on them. Well, they are like a picture of those 7 dry years too.” ");
INSERT INTO engPEV_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Then Joseph said to Pharaoh, “Sir, God gave you those dreams to show you what he is going to do next, just like I said. ");
INSERT INTO engPEV_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","For 7 years, there will be lots and lots of food everywhere in Egypt country. ");
INSERT INTO engPEV_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","But after that, there will be 7 dry years. There will be no rain and no food plants growing anywhere in Egypt. Those dry years will be bad for the whole country. All the people in Egypt, they will forget about that time when there was lots and lots of food. ");
INSERT INTO engPEV_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Those dry years will be so bad, it will be just like those 7 good years never happened. ");
INSERT INTO engPEV_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Sir, God is going to make those things happen, for sure. And he’s going to make them happen soon. That’s the reason why he gave you 2 dreams about them.” ");
INSERT INTO engPEV_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Then Joseph said, “Sir, now I will tell you what you have to do. You have to pick a man that is really wise and thinks properly. And you have to put that man in charge of Egypt country. ");
INSERT INTO engPEV_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","35","Then you have to pick some other men to work for him. And those men have to go all over Egypt country, and they have to gather up food from all the farms. Every time the farmers have food plants with seeds that are ready to make flour, those workers have to say to the farmers, ‘This is what Pharaoh says you have to do. Split up that food into 5 piles, and give one pile to us.’ Then those workers have to put that food in big sheds in the towns, and they have to look after it. They have to keep on doing that for 7 years, while there is lots and lots of food in Egypt country. ");
INSERT INTO engPEV_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","At the end of those 7 good years, there will be 7 dry years. There will be no rain, and no food plants will grow in Egypt country. But all the people in Egypt country, they can eat the food that is in those sheds, and they can keep on doing that for those 7 dry years, so that they will not die.” ");
INSERT INTO engPEV_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Pharaoh and all his workers listened to Joseph, and they all liked Joseph’s idea. ");
INSERT INTO engPEV_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","And Pharaoh said to his workers, “Now I know that this man has God’s spirit in him. There isn’t anybody else like him.” ");
INSERT INTO engPEV_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Then Pharaoh said to Joseph, “God showed you what is going to happen, and he told you what to do. So I know that you are more wise than everybody else. You really know how to think properly. ");
INSERT INTO engPEV_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","So now I will make you my most important worker, and all the people in Egypt will have to do what you say. I will be the only one that is more important than you, because I am the big boss.” ");
INSERT INTO engPEV_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","After Pharaoh said those things, he said to Joseph, “Now I’m putting you in charge of all of Egypt country.” ");
INSERT INTO engPEV_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Pharaoh was wearing a ring with a special mark on it. That ring showed that Pharaoh was the big boss. So Pharaoh took off that special ring, and he put it on Joseph’s finger, to show that Joseph was in charge. And Pharaoh gave Joseph some new clothes to wear. Those clothes were made out of a really good cloth, called linen. And Pharaoh put a gold necklace around Joseph’s neck. ");
INSERT INTO engPEV_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Then Pharaoh got a special trailer with horses pulling it, and he got Joseph to ride in that special trailer to show that he was the 2nd boss over Egypt country. Pharaoh’s soldiers went with Joseph, and they shouted out to all the people, “Joseph is coming. Show him respect.” In that way, Pharaoh put Joseph in charge of all of Egypt country. ");
INSERT INTO engPEV_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Pharaoh said to Joseph, “I am the big boss, and you are my most important worker. If anybody in Egypt country wants to do something, they have to ask you first, and you can say yes or no.” ");
INSERT INTO engPEV_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Then Pharaoh gave Joseph a name in the Egypt language. That name was Zafenath-Pania. Pharaoh also gave Joseph a woman to marry. That woman’s name was Asenath, and her father’s name was Potifera. He was a ceremony leader for the Egypt people, at the town called Onn. That’s the story about how Joseph became Pharaoh’s most important worker, and he started to be in charge of Egypt country. At that time, Joseph was 30 years old. Then Joseph left Pharaoh’s house, and he went all around Egypt country. ");
INSERT INTO engPEV_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","The next 7 years were really good years in Egypt country, because lots and lots of food grew on the land. ");
INSERT INTO engPEV_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","So for those 7 years, Joseph told the Egypt people to get food from the farms and take it into the towns. And the people did what Joseph said. Everywhere in Egypt country, the people got food from the farms, and they took that food into the towns that were near the farms. Then they put that food into big sheds, to keep it safe. ");
INSERT INTO engPEV_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","There was so much food in those sheds that nobody could count it, just like nobody can count all those little bits of sand that are at the beaches by the sea. ");
INSERT INTO engPEV_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Joseph’s wife was called Asenath, and her father’s name was Potifera. He was a ceremony leader for the Egypt people, at the town called Onn. Joseph and Asenath had 2 sons. Both those sons were born at the time when there was still lots of food growing in Egypt country. ");
INSERT INTO engPEV_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph named his 1st son Manasseh. That name means he let me forget. Joseph said, “You see, God was good to me. He let me forget about all that trouble I had, and he even let me forget that I miss my family.” ");
INSERT INTO engPEV_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Joseph named his 2nd son Ephraim. That name means he let me have kids. Joseph said, “You see, God was good to me. He let me have kids in this country, even though I had lots of trouble here.” ");
INSERT INTO engPEV_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","For those 7 years, lots and lots of food plants grew in Egypt country. But at the end of those 7 good years, the rain stopped coming. ");
INSERT INTO engPEV_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Then the 7 dry years started. There was no rain, and the food plants stopped growing. It happened just like Joseph said. The same thing happened in all the other countries around Egypt too. There was no rain and no food plants growing in those countries, so the people in those countries didn’t have enough food. But there was still lots of food in those big sheds in Egypt. ");
INSERT INTO engPEV_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","56","This is what happened in Egypt country at the time when the rain stopped coming. It got dry all over Egypt country, and the food plants everywhere stopped growing. It got really bad, and all the Egypt people started to get hungry. So they went to Pharaoh, and they said to him, “Please, please give us food.” Then Pharaoh said to all the Egypt people, “Go to Joseph, and do whatever he tells you.” So they went to Joseph, and they asked him for food. Then Joseph got his workers to go to all the towns in Egypt country and open those big sheds. There was lots of food in those sheds from the 7 good years. So Joseph’s workers started to sell that food to the Egypt people. ");
INSERT INTO engPEV_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","And there was no rain in other countries too. It was really bad everywhere. So the people that lived in those other countries, they went to Egypt, and they bought food from Joseph’s workers too. ");
INSERT INTO engPEV_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Joseph’s father Jacob, he lived in Canaan country with his other sons. At that time, there was no rain and no food plants growing in Canaan country. Then somebody said to Jacob, “There is lots of food in Egypt country.” So Jacob talked to his sons, and he said to them, “Don’t just stand around doing nothing. ");
INSERT INTO engPEV_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Somebody told me that there is lots of food in Egypt country. Go there and buy food for all of us. If you don’t go and buy food for us, we will die.” ");
INSERT INTO engPEV_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","So 10 of Jacob’s sons left Canaan country, and they went to Egypt country to buy food there. Those 10 men were Joseph’s half-brothers. They had the same father as Joseph, but different mothers. ");
INSERT INTO engPEV_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","You know, Joseph had one other brother too. His name was Benjamin. Joseph and Benjamin had the same father and mother. Their father Jacob really loved Benjamin. So Jacob didn’t want Benjamin to go to Egypt with his brothers. He thought, “Benjamin might get hurt, or he might die.” So Benjamin stayed at home with his father. ");
INSERT INTO engPEV_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","In Egypt country, Jacob’s sons went to buy food, and there were lots of other people from Canaan country there too. You see, there was no rain and no food plants growing anywhere in Canaan, so the Canaan people had to go to Egypt to buy food. ");
INSERT INTO engPEV_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","At that time, Joseph was in charge of Egypt country, and he was the one that sold food to everybody. So Joseph’s brothers came to him, and they got down on their knees and put their faces near the ground, to show him respect. ");
INSERT INTO engPEV_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","But they didn’t know that he was their brother Joseph. They thought that he was one of the Egypt people. Joseph looked at those men, and he saw that they were his brothers. But Joseph pretended that he didn’t know them. He talked to them in the Egypt language, and somebody else talked to Joseph’s brothers in their own language and told them the things Joseph said. And Joseph talked in a rough way to them. He said, “Where do you mob come from?” His brothers said, “We come from Canaan country. We want to buy food here in Egypt.” ");
INSERT INTO engPEV_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Then Joseph remembered those dreams that he had a long time before. Those dreams showed that one day, Joseph’s brothers will all bend down in front of him, to show him respect. Joseph kept on pretending that he didn’t know them. He said to his brothers, “I reckon you mob are lying to me. I reckon you are my enemies. You came here to find out about our country, so that your people can attack us.” ");
INSERT INTO engPEV_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","But they said to him, “No, sir, that’s not true. We respect you. We came here to buy food. ");
INSERT INTO engPEV_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","You know, we are all brothers, with the same father. We are good men, and we don’t tell lies. We are not your enemies.” ");
INSERT INTO engPEV_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Joseph said, “I don’t believe you. I reckon you came here to find out about our country, so that your people can attack us.” ");
INSERT INTO engPEV_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","They said, “No, sir. Those things that we told you, they are true. We are from a family of 12 brothers. We all have the same father, and he lives in Canaan country. Our youngest brother stayed at home with our father, and our other brother isn’t with us any more.” ");
INSERT INTO engPEV_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","But Joseph said, “Stop talking, you mob. I know for sure that you are my enemies. ");
INSERT INTO engPEV_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","So I’m going to test you mob, to see if you are lying. You said, ‘Our youngest brother is with our father in Canaan country.’ All right, I want your youngest brother to come here, so that I can see him. I’m telling you strongly, if your brother doesn’t come here, I will not let you leave this place. Pharaoh, the big boss of this country, he is the one that gives me the power to promise that.” ");
INSERT INTO engPEV_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Then Joseph said to his brothers, “This is how I am going to test you mob. One of you has to go back to your home country and get your youngest brother, then bring him back here. The rest of you mob have to stay here, and I will put you in jail. If your youngest brother comes here, then I will know that you told me the true story, and I will let you go free. But if he doesn’t come, then I will know that you are my enemies. I will be really sure, just like I’m really sure that Pharaoh is alive.” ");
INSERT INTO engPEV_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Then Joseph put his brothers in jail, and they stayed there for 3 days. ");
INSERT INTO engPEV_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","At the end of those 3 days, Joseph talked to his brothers again. He said to them, “You know, I respect God and I want to do the right thing. So if you do what I say, I will not kill you.” ");
INSERT INTO engPEV_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Then Joseph said to them, “You told me that you are good men, and you don’t tell lies. So listen, this is what you have to do. Pick one man from your mob, and I will keep that man here in jail. The rest of you mob, you can go back to your home country. You can take food with you, and you can give that food to your families, because they are really hungry. ");
INSERT INTO engPEV_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Then get your youngest brother, and bring him here to me. Then I will know that you told me the true story, and I will not kill you.” So Joseph’s brothers agreed to do what he said. But they still didn’t know that he was their brother Joseph. They still thought he was an Egypt man. ");
INSERT INTO engPEV_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Then Joseph’s brothers talked to each other in their own language. They said, “You know, a long time ago, we made bad trouble for our brother Joseph. We chucked him into a big hole in the ground, and then we sold him to some men from the Midian tribe. At that time, we saw that he was really frightened, and he asked us strongly to be good to him, but we didn’t listen. That’s the reason why we’ve got this bad trouble now. God is punishing us for those things that we did to Joseph.” ");
INSERT INTO engPEV_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Then Joseph’s oldest brother Reuben, he said to the others, “You know, I told you mob not to hurt Joseph, but you didn’t listen to me. And look, now God is doing payback to us.” ");
INSERT INTO engPEV_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Joseph listened to his brothers, and he understood what they said, because he knew their language. But Joseph’s brothers didn’t know that he understood them. You see, Joseph always talked to his brothers in the Egypt language, then somebody else talked to them in their own language and told them what Joseph said. So they thought he only talked the Egypt language. ");
INSERT INTO engPEV_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","When Joseph heard his brothers say those things, he wanted to cry. So he went to a place where they couldn’t see him, and he cried. After a while, Joseph stopped crying. Then he went back to his brothers, and he talked to them in the Egypt language again. And Joseph picked his brother Simeon to stay in Egypt country. He told his men to tie up Simeon, and they tied him up in front of his brothers. ");
INSERT INTO engPEV_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Then Joseph got ready to send his brothers back to Canaan country. He said to his workers, “Fill up these men’s bags with food, so that they can take it home to their families. And give them some food to eat on the way home too.” And those workers did what Joseph said. Joseph’s brothers already paid for that food, but Joseph talked secretly to his workers, and he said, “Get the money that those men paid us, and hide it in their food bags.” So those workers did what Joseph said. Then they gave those food bags to Joseph’s brothers, with the money inside. But Joseph’s brothers didn’t know that their money was in those bags. ");
INSERT INTO engPEV_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Then Joseph’s brothers put their food bags on their donkeys, and they left that place and started to go back towards Canaan country. ");
INSERT INTO engPEV_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Later that day, they stopped in another place, to camp there that night. One of Joseph’s brothers wanted food for his donkey, so he opened his food bag. Then he saw his money in there on top of the food, and he got a shock. ");
INSERT INTO engPEV_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","He said to his brothers, “Somebody gave my money back. They hid it in my bag. Look, here it is, on top of the food.” Then Joseph’s brothers got really worried. They thought, “Those Egypt people will think that we stole this money.” They were really frightened, and their bodies started to shake. They said to each other, “This thing that happened to us, it’s really bad. God is punishing us.” ");
INSERT INTO engPEV_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","The next day, they kept going towards Canaan country, and they kept on camping along the way. When they got to Canaan country, they went to their father Jacob, and they told him about the things that happened to them in Egypt country. ");
INSERT INTO engPEV_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","They said, “The man that is in charge of Egypt country, he talked in a rough way to us. He thought we were his enemies, and he said to us, ‘I reckon you came here to find out about our country, so that your people can attack us.’ ");
INSERT INTO engPEV_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","But we said to him, ‘We are good men, and we don’t tell lies. We are not your enemies. ");
INSERT INTO engPEV_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","We are from a family of 12 brothers, and we all have the same father. One brother isn’t with us any more, and our youngest brother is with our father in Canaan country.’ ");
INSERT INTO engPEV_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Then that man, the one that is in charge in Egypt, he said to us, ‘I’m going to test you mob, to see if those things you said are true. This is what you have to do. You have to pick one of your brothers to stay here with me. The rest of you mob can go back to your home country. You can take food with you, and give it to your families, because they are really hungry. ");
INSERT INTO engPEV_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","After that, you have to get your youngest brother, and you have to bring him here to me. Then I will know that you are not my enemies. Yes, I will know that you are good men, and you didn’t lie to me. Then I will give your other brother back to you, the one that stayed here in Egypt country. And then I will let you buy and sell things in my country.’” ");
INSERT INTO engPEV_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","After Joseph’s brothers told their father those things, they all opened their bags, and they started to take out the food. Then all of them saw their money in those bags. And their father Jacob saw that money too. They all got a shock, and they were frightened. ");
INSERT INTO engPEV_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jacob’s sons wanted to take their brother Benjamin back to Egypt country, just like Joseph told them to. That made Jacob sad. So Jacob said to his sons, “I don’t want to lose any more of my kids. My son Joseph isn’t here any more, and my son Simeon isn’t here any more. And now you want to take my son Benjamin away from me too. All those things are really sad for me.” ");
INSERT INTO engPEV_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Then Reuben, Jacob’s oldest son, he talked to his father Jacob. Reuben said, “Let me take Benjamin to Egypt country. I will look after him, and I promise that I will bring him back to you. If I don’t bring him back to you, then you can kill my 2 sons.” ");
INSERT INTO engPEV_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","But Jacob said, “No. I will not let Benjamin go with you mob to Egypt country. You know that I really loved Benjamin’s mother Rachel. We had 2 sons together, Joseph and Benjamin. Now Joseph is dead, and Benjamin is the only one left. If I let him go with you, he might get hurt, or he might die. You know, I am an old man. If you mob take Benjamin to Egypt country, and something bad happens to him, I will be so sad that I will die.” ");
INSERT INTO engPEV_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Some time later, there was still no rain and no food plants growing in Canaan country, and everybody was really hungry. ");
INSERT INTO engPEV_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Jacob’s family finished eating all that food that they got in Egypt country, and they didn’t have any more food. So Jacob said to his sons, “Go back to Egypt country, and buy a bit more food for us.” ");
INSERT INTO engPEV_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","But Jacob’s son Judah said, “You know that we can’t go back to Egypt country without our youngest brother Benjamin. That man that is in charge of Egypt, he will not let us do that. Last time we went to Egypt, that man talked strongly to us, and he said, ‘You can only come back here if you bring your youngest brother with you.’” ");
INSERT INTO engPEV_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Then Judah said to Jacob, “If you will let our brother Benjamin go with us to Egypt country, then we will go and buy food for you there. ");
INSERT INTO engPEV_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","But if you will not let Benjamin go with us, then we will not go to Egypt country, because that man said to us, ‘You can only come back here if you bring your youngest brother with you.’” ");
INSERT INTO engPEV_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Then Jacob said, “I don’t want you mob to take Benjamin to Egypt country. Why did you make this problem for me? Why did you tell that man that you have another brother?” ");
INSERT INTO engPEV_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Jacob’s sons said, “That man asked us lots of questions about ourselves and our family. He said, ‘Is your father still alive? And have you got another brother?’ We just answered his questions. We didn’t know that he was going to say, ‘Bring your brother here.’” ");
INSERT INTO engPEV_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Then Judah talked to his father Jacob again. He said, “I will look after that young man Benjamin. Let him go with me to Egypt country. We will go there straight away, with the rest of our brothers, so that we can buy food. If we don’t go and buy food, our mob will get so hungry that we will all die. That’s true for us, and you, and our kids. We all need that food, so that we can stay alive.” ");
INSERT INTO engPEV_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Then Judah said to his father, “I promise that I will look after Benjamin, and I will keep him safe until we come back. I’m telling you straight, if I don’t bring Benjamin back here to you, then you can blame me and say that I am guilty, and you can keep doing that all my life. ");
INSERT INTO engPEV_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","But listen, we really need to go to Egypt country now. We already waited too long. We had enough time to go to Egypt and come back, and then go again and come back. But we didn’t do that. We just stayed here in Canaan country.” ");
INSERT INTO engPEV_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Then their father Jacob said, “All right. I can see that you mob have to take Benjamin to Egypt country. But first, I want you to get some of the best things from our country, so that you can take them as presents for that man, the one that is in charge of Egypt. Get some honey, and some nuts. And get some perfume, and some bush medicine called myrrh. Put all those things into your bags, and take them to Egypt, and give them to that man that is in charge.” ");
INSERT INTO engPEV_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Then Jacob kept on talking to his sons. He said, “Remember, the last time you mob went to Egypt, you paid money for food. Then later on, you found that money in your food bags. I don’t know why somebody put that money into your food bags. Maybe that person wasn’t thinking right. So you have to take that money back to Egypt country, and you have to give it to that man that is in charge. And take some other money with you as well, to pay for the food that you will buy this time.” ");
INSERT INTO engPEV_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Then Jacob said to his sons, “Now get your brother Benjamin, and leave this place straight away. Go back to Egypt country, and go to that man that is in charge. ");
INSERT INTO engPEV_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","You know, God is the one that has power over everything. So I’m asking God to make that man feel sorry for you mob. If he feels sorry for you, then he will let your brother Simeon go free, and he will let Simeon and Benjamin come back here with you. But if those things don’t happen, and if my sons die, then I can’t change that.” ");
INSERT INTO engPEV_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Straight away, Jacob’s sons did everything that Jacob said. They got those presents ready, and they got that money that they found in their food bags, and some other money. Then they got their brother Benjamin, and they went to Egypt country. After they got there, they went and stood in front of Joseph. ");
INSERT INTO engPEV_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Joseph looked at those men, and he saw that his brother Benjamin was with them. So Joseph talked to his worker, the one that was in charge of all the other workers in his house. Joseph said to that worker, “I want these men to eat lunch with me at 12 o’clock. So take them to my house, and then go and get one of my animals and kill it. Cook the meat from that animal, and get it ready for us to eat.” ");
INSERT INTO engPEV_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","So that worker started to take those men to Joseph’s house, just like Joseph told him to do. ");
INSERT INTO engPEV_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Then those men got frightened. They talked to each other, and they said, “You know, the last time we came here to Egypt country, we brought money with us, to buy food. But somebody put that money in our food bags, and then we took those food bags back home with us. We didn’t know that our money was in those bags. Now that man is going to say to us, ‘You mob stole that money.’ That’s the reason why he wants us at his house. Him and his men, they are going to attack us, and we will not be able to fight back, because they will be too strong for us. Then they will make us like prisoners, and we will have to work very hard for them. And they will take our donkeys too.” ");
INSERT INTO engPEV_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","So when those men got near to Joseph’s house, they stopped outside the door of the house, and they talked to Joseph’s worker. ");
INSERT INTO engPEV_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","They said, “Please, sir, we want to tell you something. Some time ago, we came here to Egypt country, to buy food. We got lots of food, and we paid money for that food. ");
INSERT INTO engPEV_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Then on the way home, we stopped at a place to camp for the night. Then we opened our food bags, and we saw that all our money was in those bags, on top of the food. We don’t know who put that money in our bags. So now, we brought that money here, to give it back. And we brought some other money with us too, so that we can buy more food.” ");
INSERT INTO engPEV_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Then Joseph’s worker said to them, “It’s all right. Don’t be frightened. I got the money that you paid for that food last time. The God that you and your father respect, he is the one that put that money in your food bags. It’s like he gave you a special present.” Then that worker went and got Joseph’s brother Simeon, that one that stayed in Egypt country last time. That worker took Simeon to his brothers, ");
INSERT INTO engPEV_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","and then he took all those men into Joseph’s house. He got water for them to wash their feet, and he got food for their donkeys to eat. ");
INSERT INTO engPEV_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","And he said to those men, “You are going to eat lunch with my boss at 12 o’clock.” So they washed their feet, and they got those presents ready for Joseph, the ones that they brought from Canaan country. ");
INSERT INTO engPEV_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Joseph came home for lunch, and his brothers gave him those presents that they brought from Canaan country. They still didn’t know that he was their brother. They thought that he was one of the Egypt people. So they got down on their knees and put their faces near the ground, to show him respect. ");
INSERT INTO engPEV_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Joseph said to them, “How are you mob?” And he said, “The last time you came here, you told me about your father. So tell me, how is that old man? Is he still alive?” ");
INSERT INTO engPEV_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","They said, “Yes, our father is still alive, and he is good. He respects you.” Then they all got down on their knees again, and they put their faces near the ground, to show respect to Joseph. ");
INSERT INTO engPEV_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Joseph looked around, and he saw his brother Benjamin. You know, Joseph and Benjamin had the same mother and father. So Joseph said to those men, “You told me that you have another younger brother. Is this him?” Then Joseph said to Benjamin, “Young man, I’m asking God to be very good to you.” ");
INSERT INTO engPEV_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Joseph was really happy to see Benjamin, because he loved him very much. He was so happy that he wanted to cry. But Joseph didn’t want his brothers to see him crying, so he quickly went out of that room to find a place to cry. He went to his own room, and he cried. ");
INSERT INTO engPEV_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","After a while, Joseph stopped crying. Then he washed his face, and he went back to his brothers. And Joseph tried to be strong, so that he did not cry again. He said to his workers, “Bring the food that you made, so that we can eat it.” ");
INSERT INTO engPEV_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","In that room there was Joseph, and Joseph’s brothers, and some Egypt people. Joseph’s workers went and got food for them all. Those Egypt people didn’t want to sit with Joseph’s brothers, because Joseph’s brothers were from the Hebrew tribe, and the Egypt people reckoned it was wrong to eat food with Hebrew people. That’s what their culture said. So those Egypt people sat by themselves, and Joseph had a special place for himself. ");
INSERT INTO engPEV_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","And Joseph got his brothers to sit together. He got his oldest brother to sit down first, and he got his 2nd oldest brother to sit down next, and then he kept on doing that with all his brothers, and he got his youngest brother to sit down last. So all his brothers were sitting down in order of their age, from the oldest to the youngest. Joseph’s brothers were shocked. They thought, “That man knows how old we all are. How does he know that?” ");
INSERT INTO engPEV_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Then Joseph’s workers got food from Joseph’s table, and they gave that food to Joseph’s brothers. But they gave Benjamin more food than all the others. They gave Benjamin 5 lunches just for him. And all of Joseph’s brothers, they drank a lot of wine with Joseph, and they felt very happy. ");
INSERT INTO engPEV_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Joseph talked to his worker, the one that was in charge of all the other workers in his house. Joseph said to that worker, “Fill up those men’s bags with food. Put lots of food in them, so that they are really full. Then get the money that they paid for that food, and hide that money in their bags, on top of the food. Do that for every one of those men.” ");
INSERT INTO engPEV_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Joseph also said, “Get my special cup, the one that is made of silver. Hide that cup in the youngest man’s bag, on top of the food, with the money he paid for that food.” And Joseph’s worker did all those things that Joseph said. ");
INSERT INTO engPEV_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","The next morning, as soon as the sun came up, Joseph’s workers helped those men get ready to go home. Those men got their food bags, and they put those bags on their donkeys, and then they started to go home. ");
INSERT INTO engPEV_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","When those men were just a little bit away from Joseph’s town, Joseph said to his worker, “Quick, chase those men until you catch up with them. Then say to them, ‘My boss was very good to you, but you mob did a bad thing to him. You stole his silver cup. ");
INSERT INTO engPEV_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","That cup is really special. My boss drinks from that cup, and he uses it to find out things that will happen later on. But you mob stole that cup. That was a really wrong thing to do.’” ");
INSERT INTO engPEV_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","So Joseph’s worker chased those men until he caught up with them. Then he talked to those men, and he said those things that Joseph told him to say. ");
INSERT INTO engPEV_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","But those men said to him, “Sir, we don’t know why you said those things. We didn’t steal your boss’s cup. We respect you and your boss, and we don’t want to do bad things to you. No way.” ");
INSERT INTO engPEV_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Those men kept on talking to Joseph’s worker. They said, “Sir, think about that other time when we came to your country to buy food. On the way home to Canaan country, we found money in our food bags, on top of the food. But we didn’t try to keep that money. No, we wanted to give it back to you. So the next time we came to your country, we brought that money with us, to give it to you. That shows that we are good men. So you can be sure that we didn’t steal anything made of silver or gold from your boss’s house.” ");
INSERT INTO engPEV_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Then those men said to Joseph’s worker, “Sir, you can look in all our bags. And if you find that silver cup, then you can kill the man that has the cup in his bag. Then the rest of us mob, we will become your work-men, and we will work for you for no pay.” ");
INSERT INTO engPEV_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Joseph’s worker said, “All right, I will look in all your bags. And the man that has the cup in his bag, he has to become my work-man. Then I will let the rest of you mob go free.” ");
INSERT INTO engPEV_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","So those men quickly took their bags off their donkeys, and they all opened their bags. ");
INSERT INTO engPEV_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","And Joseph’s worker started to look in all those bags. He looked in the oldest man’s bag first, but the cup wasn’t there. Then he went to the next oldest man, and he looked in that man’s bag, but the cup wasn’t there. And he kept on doing that with all the men. He looked in all of their bags until he got to the youngest man. That young man’s name was Benjamin. Joseph’s worker looked in Benjamin’s bag, and he found that silver cup. ");
INSERT INTO engPEV_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Then all those men got a big shock, and they thought, “Now Benjamin will have to stay in Egypt country and work for that man.” So they got really upset. They were so upset that they tore their clothes. Then they put their bags back on their donkeys, and they went back to the town where Joseph lived. ");
INSERT INTO engPEV_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Joseph was in his house, and he was waiting for those men to come back. Then those men got to the house. The one called Judah, he went inside the house, and his brothers went inside too. You know, all those men were Joseph’s brothers, but they still didn’t know that he was Joseph. So they quickly got down on their knees and put their faces near the ground, to show him respect. ");
INSERT INTO engPEV_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Joseph still wanted to trick them, so he said to them, “You know, I’m a very powerful man. I can do magic to find out things that nobody else knows. So I know that you mob stole my silver cup. Why did you do that bad thing?” ");
INSERT INTO engPEV_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judah said to Joseph, “Sir, we don’t know what to say to you. We really don’t know what to say. We didn’t steal your cup. That’s the true story, but we don’t have any way to show you that it’s true.” Then Judah said to Joseph, “Sir, a long time ago, we did bad things, and God knows that. Now God is showing you that we are guilty men. So listen, we will all become your work-men. Yes, that man that had your cup in his bag, he will become your work-man, and the rest of us mob, we will become your work-men too. And we will work for you for no pay.” ");
INSERT INTO engPEV_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","But Joseph said, “No way. I don’t want to punish all of you like that. The man that had my cup in his bag, he is the only one that has to become my work-man. The rest of you mob, you can go home to your father, and I will not make any trouble for you.” ");
INSERT INTO engPEV_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Then Judah went more close to Joseph, and Judah said, “Sir, please let me say something to you, even though I am not an important person. I know that you are very important, just like Pharaoh, the big boss of Egypt country. So please don’t be angry with me for saying this. ");
INSERT INTO engPEV_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","You know, sir, the last time we came here, you asked us, ‘Is your father still alive? And do you have another brother?’ ");
INSERT INTO engPEV_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Then we said to you, ‘Yes, sir. Our father is alive, and he is an old man. And we have a young brother too. He was born when our father was already old. We had one more brother, but he died. That brother that died, and our young brother, they had the same mother. So now our young brother is the only kid left from his mother. And our father really loves him.’ ");
INSERT INTO engPEV_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Then you said to us, ‘Go and get that young man, and bring him here to Egypt country, so that I can see him.’ ");
INSERT INTO engPEV_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","But we said, ‘Sir, we can’t take that young man away from his father. If we do that, his father will be so sad that he will die.’ ");
INSERT INTO engPEV_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Then you said to us, ‘You mob can only come back here if you bring your youngest brother with you.’” ");
INSERT INTO engPEV_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Judah kept on talking to Joseph. He said, “Sir, we went back home to our father, and we told him those things that you said. ");
INSERT INTO engPEV_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Then, some time later, our father said to us, ‘Go back to Egypt, and buy a bit more food for us mob.’ ");
INSERT INTO engPEV_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","But we said to him, ‘That man that is in charge of Egypt, he said to us, “You mob can only come back here if you bring your youngest brother with you.” ’ So we said to our father, ‘If you will let our youngest brother go with us to Egypt, then we will go. But if you don’t let him go with us, then we can’t go.’ ");
INSERT INTO engPEV_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Then my father said to us, ‘Listen, you know that I really loved my wife Rachel, and we only had 2 sons together. ");
INSERT INTO engPEV_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","One of those sons went away, and he never came back. So I said, “I know what happened. A wild animal tore my son into little bits.” And I never saw him again. ");
INSERT INTO engPEV_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","So now your youngest brother, he is the only one of Rachel’s sons that I have left. If you take him away from me, he might get hurt, or he might die. You know, I am an old man. If something bad happens to my son, I will be so sad that I will die.’” ");
INSERT INTO engPEV_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Judah kept on talking to Joseph. He said, “Sir, our father really loves that young man. He loves him more than anything else. And you know, our father is very old. I’m telling you, if I go back home to my father, and if that young man is not with us, then my father will be so sad that he will die. Yes, as soon as he sees that the young man is not with us, he will die straight away. We don’t want to do that to our father. ");
INSERT INTO engPEV_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Sir, I promised my father that I will look after that young man, and keep him safe. I said to my father, ‘If I don’t bring that young man back here to you, then you can blame me and say that I am guilty, and you can do that all my life.’ ");
INSERT INTO engPEV_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","So please, sir, let me stay here and become your work-man, instead of that young man. And let that young man go back home with his brothers. ");
INSERT INTO engPEV_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","If that young man is not with me, I can’t go back to my father. I don’t want to see my father get real sad and die. No way.” ");
INSERT INTO engPEV_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","After Judah said all those things, Joseph really wanted to cry, and he wanted to tell those men that he was their brother. But lots of Joseph’s workers were there in that room, so Joseph said to them, “All of you workers, go out of this room.” Then all of Joseph’s workers went out, and Joseph stayed there with his brothers. ");
INSERT INTO engPEV_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Then Joseph started to cry really loud. He cried so loud that some of the Egypt people heard him, and those Egypt people went and told the people in Pharaoh’s house. ");
INSERT INTO engPEV_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Then Joseph said to his brothers, “I am your brother Joseph. You said that my father is still alive. Is that true?” Joseph’s brothers got a big shock. You see, before this, they thought that he was one of the Egypt people, but now they knew that he was their brother Joseph. They were really shocked and frightened, so they didn’t say anything. ");
INSERT INTO engPEV_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Then Joseph said to his brothers, “Please, come and stand more close to me.” So they went more close to him. And Joseph said, “I am your brother Joseph. Remember, a long time ago, you sold me as a work-man to that Midian mob, and they brought me here to Egypt country. ");
INSERT INTO engPEV_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Listen, I can see that you are upset and angry with yourselves, because you sold me as a work-man. But don’t be upset or angry. You know, God was the one that made those things happen. Yes, God sent me here to Egypt, so that I can help people stay alive in these dry years with no food plants growing. And later on, he got you mob to come here to get food. ");
INSERT INTO engPEV_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","You know, we already had 2 dry years with no rain, and there will be 5 more dry years. Yes, for 5 more years, nobody will be able to grow any food. ");
INSERT INTO engPEV_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","But God wants to save you mob, so he did a great thing for you. He sent me here to Egypt, to get things ready for you. Now God is going to use me to make sure that you and your families stay alive. ");
INSERT INTO engPEV_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","So I’m telling you, it wasn’t you mob that sent me here to Egypt. No, it was God that sent me here. He made me Pharaoh’s most important helper, and he made me boss over all of Pharaoh’s workers, and he put me in charge of all of Egypt.” ");
INSERT INTO engPEV_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Then Joseph said to his brothers, “Now you mob have to go quickly to my father. Say to him, ‘This is a message from your son Joseph. He says, “God put me in charge of all of Egypt country. Come and live in this country with me straight away. ");
INSERT INTO engPEV_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Bring your kids and your grand-kids, your sheep and cows, and everything that you own. You can live near me, in the place called Goshen. ");
INSERT INTO engPEV_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","You know, there will be 5 more years of no rain and no food plants growing. But I will give food to you and your family and your animals for those 5 years. I will do that for you, so that you will not become really poor, and you and your animals will not die.” ’” ");
INSERT INTO engPEV_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Then Joseph said to his brothers, “Now you mob know that I really am Joseph. And my brother Benjamin, he knows that too. ");
INSERT INTO engPEV_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","So you mob have to go and tell my father that I am very important in Egypt country. And tell him about everything else that you saw here. Go quickly, and then bring my father here.” ");
INSERT INTO engPEV_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Then Joseph put his arms around his brother Benjamin, and he hugged him. And Joseph cried, because he was so happy to see Benjamin again. And Benjamin hugged Joseph, and he cried too. ");
INSERT INTO engPEV_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Then Joseph kissed all his brothers on the cheek, and he kept on crying while he did that. Then Joseph’s brothers were not frightened any more, and they talked to Joseph. ");
INSERT INTO engPEV_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Somebody went to Pharaoh’s house, and they said to Pharaoh and his workers, “Joseph’s brothers are here in Egypt country.” And Pharaoh and his workers were happy that Joseph’s brothers came. ");
INSERT INTO engPEV_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Then Pharaoh said to Joseph, “Tell your brothers, ‘This is what you have to do. Put your bags of food on your donkeys, and go back to Canaan country. ");
INSERT INTO engPEV_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Then get your father and your families, and bring them back here to Egypt. I will give you the best land in Egypt, and you can live on that land. And you can eat the best food that is in this country.’” ");
INSERT INTO engPEV_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Pharaoh kept on talking to Joseph. He said, “I want you to say to your brothers, ‘This is what you have to do. Get some of our cows and trailers that are here in Egypt country, and get those cows to pull those trailers back to your home country. Then get your little kids and your wives to sit in those trailers, and then those cows can bring them back here to Egypt. And bring your father too. ");
INSERT INTO engPEV_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","You don’t need to bring all the things that you own, because I am going to give you the best things that are here in Egypt.’” ");
INSERT INTO engPEV_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Then Jacob’s sons did those things that Pharaoh said. Joseph gave them some cows and trailers, just like Pharaoh told him to do, and he gave them some food to eat on the way home. ");
INSERT INTO engPEV_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","And he gave them all some new clothes. But he gave Benjamin more clothes than all the others. Yes, he gave Benjamin 5 sets of clothes. He also gave Benjamin 300 pieces of silver money. ");
INSERT INTO engPEV_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Joseph wanted to send some presents to his father too. So he got 10 male donkeys, and he got some really good things from Egypt country, and he put those good things into bags, and he put those bags on the donkeys to send them to his father. Joseph also got 10 female donkeys to send to his father, and he got wheat seeds, and bread, and lots of other food, and he put all that food into bags, and he put those bags on those 10 female donkeys. Joseph wanted to send that food to his father, so that his father could eat it on the way back to Egypt. ");
INSERT INTO engPEV_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","After everything was ready, Joseph told his brothers to leave Egypt and go back to their home country. And he said to them, “Don’t argue on the way home.” So they left Egypt country to go home. ");
INSERT INTO engPEV_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Joseph’s brothers went back to their father Jacob, in Canaan country. ");
INSERT INTO engPEV_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","They said to Jacob, “Joseph is not dead. No, he is still alive, and he is in charge of all of Egypt country.” Jacob got a big shock, and he didn’t believe those things that his sons said. You see, he thought that Joseph was dead. ");
INSERT INTO engPEV_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","So Jacob’s sons told him everything that Joseph said to them, and they showed him those cows and trailers that Joseph sent. They said, “Joseph sent these cows and trailers so that we can take you and our families to Egypt country.” Then Jacob felt better. ");
INSERT INTO engPEV_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","He said, “Now I know that those things that you said, they are true. My son Joseph really is alive. I have to go and see him before I die.” ");
INSERT INTO engPEV_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","So Jacob left his home in Canaan country, and he started to go to Egypt country. He took his family with him, and everything that he owned. They got to the place called Beersheba, then Jacob killed some animals and burned them. He did that to show respect to God. God is the one that looked after his father Isaac. ");
INSERT INTO engPEV_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","That night, God talked to Jacob. God said, “Jacob, Jacob.” Jacob said, “Yes, I am listening.” ");
INSERT INTO engPEV_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","And God said, “I am God, I am the one that looked after your father. Don’t be frightened to go to Egypt. I will make your family into a great nation there.” ");
INSERT INTO engPEV_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Then God said to Jacob, “I will go with you to Egypt, and I will take care of you. One day, you will die in Egypt, and your son Joseph will be with you when you die. And I promise that later on, I will take your family back to Canaan country again.” ");
INSERT INTO engPEV_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Then Jacob and his family left Beersheba. Jacob’s sons got their father to ride in one of those trailers that Pharaoh sent. And they got their little kids and their wives to ride in those trailers too. And the cows from Pharaoh, they pulled those trailers. ");
INSERT INTO engPEV_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Jacob’s family took all their animals with them, and everything else that they owned. They took all the things that they got while they lived in Canaan country. And they all went to Egypt country. That’s how Jacob’s whole family went to Egypt country. ");
INSERT INTO engPEV_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Jacob took all his sons and daughters to Egypt, and all his grand-sons and grand-daughters. ");
INSERT INTO engPEV_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","These are the names of Jacob’s kids and grand-kids. All this mob went to Egypt country with Jacob. Jacob and Leah’s oldest son was Reuben. ");
INSERT INTO engPEV_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Reuben’s sons were, – Hanok – Pallu – Hezron – Carmi ");
INSERT INTO engPEV_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Jacob and Leah’s next son was Simeon. Simeon’s sons were, – Jemuel – Jamin – Ohad – Jakin – Zohar – Shawl. His mother was from Canaan country. ");
INSERT INTO engPEV_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Jacob and Leah’s next son was Levi. Levi’s sons were, – Gershon – Kohath – Merari ");
INSERT INTO engPEV_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Jacob and Leah’s next son was Judah. Judah’s sons were, – Er – Onan – Shelah – Perez – Zerah But Er and Onan already died in Canaan country. Perez’s sons were, – Hezron – Hamul ");
INSERT INTO engPEV_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Jacob and Leah’s next son was Issachar. Issachar’s sons were, – Tola – Puvah – Yashub – Shimron ");
INSERT INTO engPEV_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Jacob and Leah’s youngest son was Zebulun. Zebulun’s sons were, – Sered – Elon – Jaleel ");
INSERT INTO engPEV_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Those were the sons and grand-sons that Jacob had with his wife Leah. There were 33 of them, and they were all born in Paddan Aram country. Jacob and Leah also had a daughter called Dinah. ");
INSERT INTO engPEV_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Jacob and Zilpah’s older son was Gad. Gad’s sons were, – Zefon – Haggi – Shuni – Ezbon – Eri – Arodi – Areli ");
INSERT INTO engPEV_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Jacob and Zilpah’s younger son was Asher. Asher’s sons were, – Imnah – Ishvah – Ishvi – Beriah Asher also had a daughter called Serah. Beriah’s sons were, – Heber – Malkiel ");
INSERT INTO engPEV_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Those were the kids and grand-kids that Jacob had with Zilpah. There were 16 of them. That woman Zilpah, she used to work for Leah’s father Laban. Then, at the time when Jacob and Leah got married, Laban gave Zilpah to Leah, to work for her. ");
INSERT INTO engPEV_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jacob and his wife Rachel had 2 sons, – Joseph – Benjamin ");
INSERT INTO engPEV_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Joseph had 2 sons in Egypt country. Their names were Manasseh and Ephraim. Their mother was Joseph’s wife Asenath. Her father’s name was Potifera, and he was a ceremony leader for the Egypt people, at the town called Onn. ");
INSERT INTO engPEV_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamin’s sons were, – Bela – Beker – Ashbel – Gera – Nayman – Ehi – Rosh – Muppim – Huppim – Ard ");
INSERT INTO engPEV_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","All those were the sons and grand-sons that Jacob had with his wife Rachel. There were 14 of them. ");
INSERT INTO engPEV_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Jacob and Bilhah’s older son was Dan. Dan’s son was, – Hushim ");
INSERT INTO engPEV_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Jacob and Bilhah’s younger son was Naphtali. Naphtali’s sons were, – Jahzeel – Guni – Jezer – Shillem ");
INSERT INTO engPEV_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Those were the sons and grand-sons that Jacob had with Bilhah. There were 7 of them. That woman Bilhah, she used to work for Rachel’s father Laban. Then, at the time when Jacob and Rachel got married, Laban gave Bilhah to Rachel, to work for her. ");
INSERT INTO engPEV_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","All those kids and grand-kids of Jacob went to Egypt country with him. There were 66 of them. And Jacob’s sons took their wives to Egypt too. ");
INSERT INTO engPEV_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Jacob’s son Joseph was already in Egypt, and Joseph’s 2 sons were in Egypt too, because they were born there. At that time, there were 70 people in Jacob’s family, and they all went to live in Egypt country. ");
INSERT INTO engPEV_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob and his family got near to Egypt country. Then Jacob said to his son Judah, “Go to Joseph, and say to him, ‘Please tell us how to get to the place called Goshen.’” And Judah did what Jacob said. Then Jacob and his family went to Goshen. ");
INSERT INTO engPEV_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joseph told his workers to get his special trailer ready, with horses to pull it. Then Joseph got into that trailer, and he went to Goshen, so that he could meet his father Jacob. As soon as Joseph saw his father, he went to him, and he put his arms around him and hugged him. Joseph held on to his father for a long time, and he cried a lot, because he was so happy to see him again. ");
INSERT INTO engPEV_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Then Jacob said to his son Joseph, “Now I have seen you again, and I know that you are still alive. That’s the only thing I wanted. So I’m ready to die now.” ");
INSERT INTO engPEV_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Then Joseph talked to his brothers, and to the rest of his father’s family. He said, “Now I have to go and tell Pharaoh that you mob are here. I will say to Pharaoh, ‘My brothers, and the rest of my father’s family, they left their home in Canaan country, and they came here to Egypt country, so that they can live near me. ");
INSERT INTO engPEV_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","All the men in my father’s family, they look after animals. They brought all their sheep here, and all their cows, and everything else that they own.’” ");
INSERT INTO engPEV_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Then Joseph said to his brothers, “After I say those things to Pharaoh, he will say to me, ‘Tell those men to come and see me.’ And when you go to see him, he will say to you, ‘What sort of work did you do in Canaan country?’ ");
INSERT INTO engPEV_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Then you have to say to him, ‘Sir, ever since we were young men, we looked after animals. And our father and our grand-fathers, they used to look after animals too.’” Then Joseph said to his brothers, “You know, the Egypt people hate men that look after animals. So they will not want you mob to live in their towns. But this place called Goshen, it’s a long way from the other towns in Egypt country, so Pharaoh will let you live here.” ");
INSERT INTO engPEV_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Joseph left Goshen, and he went to Pharaoh’s house. Then Joseph said to Pharaoh, “My father and my brothers came here from Canaan country. They brought all their sheep and cows with them, and everything else that they own. They are staying in the place called Goshen.” ");
INSERT INTO engPEV_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Joseph took 5 of his brothers to Pharaoh. ");
INSERT INTO engPEV_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Then Pharaoh said to Joseph’s brothers, “What sort of work do you do?” Joseph’s brothers said to Pharaoh, “Sir, we look after animals, just like our father and our grand-fathers used to.” ");
INSERT INTO engPEV_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Then they said, “Sir, it is a really hard time in Canaan country. There is no rain, so there are no food plants growing, and there isn’t any grass there for our animals to eat. That’s the reason why we came here to Egypt country. We want to live here for a while. Please, sir, let us stay in the place called Goshen.” ");
INSERT INTO engPEV_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Then Pharaoh talked to Joseph. He said, “It is good that your father and your brothers have come here to be with you. ");
INSERT INTO engPEV_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","There is lots of land here in Egypt country. Your father and brothers can live in the best part of the land. Let them live in Goshen, the land is good there.” Pharaoh also said to Joseph, “Maybe some of the men in your family are really good at looking after animals. You can tell those men to look after my animals for me.” ");
INSERT INTO engPEV_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Then Joseph got his father Jacob, and he took Jacob to meet Pharaoh. Then Jacob said good things to Pharaoh, and he showed him respect. ");
INSERT INTO engPEV_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Pharaoh said to Jacob, “How old are you?” ");
INSERT INTO engPEV_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","And Jacob said to Pharaoh, “I am 130 years old. All my life, I’ve lived on country that belongs to other people. I never had my own land, just like my grand-fathers never had their own land. You know, my grand-fathers lived for a long time, and they died when they were very old. But my life has been short, and I had a lot of trouble in my life.” ");
INSERT INTO engPEV_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Then Jacob said good-bye to Pharaoh, and he went out of Pharaoh’s house. ");
INSERT INTO engPEV_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","After that, Joseph gave his father and his brothers the best land in Egypt country, just like Pharaoh said, and they lived on that land. That land was in the place called Goshen, but later on, people called that place Rameses. ");
INSERT INTO engPEV_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","And Joseph gave food to his father, and his brothers, and the rest of his father’s family. He made sure that each brother always had enough food for their whole family. ");
INSERT INTO engPEV_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","There was no rain in all of Egypt and Canaan country, and no food plants grew. It was really hard for everyone. The people did not have enough food, so they got really hungry and weak. ");
INSERT INTO engPEV_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","At first, all the people in Egypt and Canaan country, they paid money to Joseph, and he gave them food. And Joseph took all that money into Pharaoh’s house. ");
INSERT INTO engPEV_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","But after a while, the people in Egypt and Canaan country had no more money left. So all the Egypt people went to Joseph, and they said to him, “We’ve got no more money to buy food. You have to help us. Give us food, or we will die.” ");
INSERT INTO engPEV_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Joseph said to them, “All right. You don’t have any money, so you can give me your animals instead of money, and then I will give you food.” ");
INSERT INTO engPEV_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","So the people brought their animals to Joseph. They brought horses, and sheep, and cows, and donkeys. Every time somebody gave an animal to Joseph, he gave them some food, so they had enough food to eat. They kept on doing that for one year. Then after that, they had no more animals left. ");
INSERT INTO engPEV_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","The next year, the people went to Joseph again, and they said, “Sir, you know that we’ve got no money, and we gave you all our animals. The only things we have left are our own bodies and our land. There’s nothing else we can give you. ");
INSERT INTO engPEV_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","We need food, and we need seeds to plant in the ground. We know we can plant seeds now, and those food plants will grow, but we don’t have any seeds to plant. You have to help us, or we will die, and our land will be useless.” Then the people said, “This is what we want to do. We will give you our land and ourselves. Then all the land that belongs to us will belong to Pharaoh. And we will belong to Pharaoh too, we will become his workers. Then you give us food to eat and seeds to plant, so that we can grow food plants on the land again. It will be like we are paying for that food and those seeds with ourselves and our land. That way, we will have food to eat, and we will stay alive. But if you don’t do that, we will die, and our land will be useless.” ");
INSERT INTO engPEV_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","So Joseph did what the people asked. You see, there was no rain and no food plants growing in Egypt country. It was really bad, and the people needed food. So everyone in Egypt country gave all their land to Joseph, and he gave their land to Pharaoh. Then that land didn’t belong to the people any more, it belonged to Pharaoh. ");
INSERT INTO engPEV_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","And Joseph got all the Egypt people to work for Pharaoh. ");
INSERT INTO engPEV_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","26","And Joseph said to the people, “Listen. Today I gave you mob to Pharaoh, to work for him. And I gave him your land as well. Now I will give you seeds to plant in the ground, so that you can grow food plants. Every time you take food from those plants, you have to split up that food into 5 piles, and give one pile to Pharaoh. You can keep the rest of that food for yourselves. Then you and your families and your little kids, and all the people that live in your homes, you will all have food to eat. And you can take some of the seeds from those food plants, and you can plant those seeds in the ground, so that you can keep growing more food plants.” Then the Egypt people said to Joseph, “Sir, you saved our lives. Thank you for being good to us. We will be Pharaoh’s workers, just like you said.” So Joseph made a new law for Egypt country. That law said that every time the Egypt people got food from their food plants, they had to split up that food into 5 piles, and give one pile to Pharaoh. And you know, that law is still there in Egypt country. After that time, Pharaoh owned all the land in Egypt country. Only the ceremony men still owned their own land. You see, Pharaoh always paid those ceremony men, so they didn’t need to sell him their land to get food. So their land still belonged to them, it didn’t belong to Pharaoh. ");
INSERT INTO engPEV_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","At that time, Jacob and his family started to live in Egypt country, in the place called Goshen. They got their own land in that place, and lots more kids were born into their family, so that they became a really big mob of people. ");
INSERT INTO engPEV_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob lived in Egypt country for 17 years. He lived until he was 147 years old. ");
INSERT INTO engPEV_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","This story is about some things that happened before Jacob died. Jacob knew that he was going to die soon, so he sent somebody to get his son Joseph. Then Jacob said to Joseph, “I am going to ask you to put your hand under my leg, and make me a strong promise.” You see, in that culture, people sometimes made promises to each other that way. The person that made the promise, they put their hand under the other person’s leg, and that showed that they had to keep their promise. Then Jacob said to Joseph, “I know that you love me, so I want you to promise that you will be good to me, and do the right thing. When I die, don’t bury my body here in Egypt country. ");
INSERT INTO engPEV_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","You have to take my body out of Egypt country, and go back to Canaan country, and bury me in the same grave as my father and grand-father.” And Joseph said, “I will do those things that you said.” ");
INSERT INTO engPEV_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Jacob said, “Make me that strong promise.” So Joseph put his hand under Jacob’s leg, and he made him that strong promise. Then Jacob put his face down towards his bed, to thank God. ");
INSERT INTO engPEV_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","One day, not long after that, somebody said to Joseph, “Your father is really sick. He might die soon.” So Joseph went to see his father Jacob. And Joseph took his 2 sons with him. Their names were Manasseh and Ephraim. ");
INSERT INTO engPEV_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Joseph and his sons got to Jacob’s house, and somebody went and told Jacob, “Your son Joseph has come here to see you.” Then Joseph and his sons went inside to talk to Jacob. Jacob was lying on his bed. He was really weak, so it was hard for him to move. But he really wanted to talk to Joseph, so he slowly sat up on his bed. ");
INSERT INTO engPEV_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Then Jacob said to Joseph, “You know, a long time ago, I saw God. He is the one that has power over everything. He came to me at the place called Luz, in Canaan country. And he promised me that he will be good to me. ");
INSERT INTO engPEV_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","He said to me, ‘I will give you lots of kids and grand-kids, so that your family will grow into lots of different tribes. And I will give them all of this country, called Canaan. They will have this country for ever.’” ");
INSERT INTO engPEV_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Then Jacob kept talking to Joseph. He said, “At that time, there will be one tribe for each of my sons, and each tribe will get part of the land. And your 2 sons, Ephraim and Manasseh, they will get part of that land too. It’s like I’m adopting your 2 sons. There will be a tribe for Ephraim, and there will be a tribe for Manasseh, just like there will be a tribe for my son Reuben, and a tribe for my son Simeon, and for all my other sons. Your 2 sons, Ephraim and Manasseh, they were born here in Egypt country before I came to live here. ");
INSERT INTO engPEV_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","But if you have any other sons, they will not have their own tribes. No, their kids and grand-kids will belong to Ephraim’s tribe and Manasseh’s tribe. And their families will have some land in the land of Ephraim or Manasseh in Canaan country.” ");
INSERT INTO engPEV_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Jacob also said to Joseph, “I want your 2 sons, Ephraim and Manasseh, to have their own tribes and their own land, because your mother Rachel only gave me 2 sons. She had you and your brother Benjamin. And then she died, and I was really sad. At that time, we were going from Paddan Aram country to Canaan country. Your mother died in Canaan country, on the way to the town called Efrath. And I buried her body near the road that goes to Efrath.” Another name for that town is Bethlehem. ");
INSERT INTO engPEV_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","10","Jacob was very old, and his eyes were weak, so he couldn’t see very well. He looked at Joseph’s 2 sons, and he said to Joseph, “Who are these 2 boys?” Joseph said, “They are my sons, the ones that God gave me here in this country.” Then Jacob said, “Bring them near to me. I will put my hands on them, and I will ask God to be good to them.” So Joseph took his 2 sons near to Jacob. And Jacob hugged those 2 boys, and he kissed them on their cheeks. ");
INSERT INTO engPEV_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Then Jacob said to Joseph, “You know, for a really long time, I thought you were dead. But a long time later, God let me see you again. And now, he let me see your kids too.” ");
INSERT INTO engPEV_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Then Joseph got his 2 sons to move away from Jacob. And Joseph got down on his knees and put his face near the ground, to show respect to his father Jacob. ");
INSERT INTO engPEV_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Then Joseph stood up. He put his son Ephraim on his right side, and he put his son Manasseh on his left side, and he went near to Jacob with his 2 sons, so that Jacob can ask God to be good to them. Then Joseph put his younger son Ephraim in front of Jacob’s left hand, and he put his older son Manasseh in front of Jacob’s right hand. You see, in that culture, people thought that their right hand was more important than their left hand. So Joseph wanted Jacob to put his right hand on Manasseh, because he was the older son. And he wanted Jacob to put his left hand on Ephraim, because he was the younger son. ");
INSERT INTO engPEV_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","But Jacob didn’t do that. No, he put his right hand on Ephraim’s head, even though Ephraim was the younger son. And then he crossed his left arm over his right arm, and he put his left hand on Manasseh’s head, even though Manasseh was the older son. ");
INSERT INTO engPEV_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Then Jacob asked God to be good to Joseph and his sons. Jacob said, “God, my grand-father Abraham always lived your way, and so did my father Isaac. God, you took care of me all my life, and you still take care of me today. ");
INSERT INTO engPEV_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","You are the one that saved me and set me free from all the bad things that happened to me. So now, I’m asking you to be good to these 2 boys, Ephraim and Manasseh. Let them be just like my own sons, and give them those good things that you promised to me, and to my grand-father Abraham, and to my father Isaac. Let them have lots of kids and grand-kids, so that their families will become a really big mob here on earth.” ");
INSERT INTO engPEV_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","While Jacob said all those things, he had his right hand on Ephraim’s head, and he had his left hand on Manasseh’s head. But Joseph wanted Jacob to put his right hand on Manasseh, because he was the older son. So Joseph got upset, and he tried to move Jacob’s right hand from Ephraim’s head to Manasseh’s head. ");
INSERT INTO engPEV_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","And Joseph said to Jacob, “Father, don’t put your right hand on my younger son’s head. Look, here is my older son. Put your right hand on his head.” ");
INSERT INTO engPEV_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","But Jacob didn’t move his hand. He said, “No, my son. I know for sure that I’m doing the right thing. Listen, your older son will have a big family, and they will become an important tribe. But your younger son will be more important than your older son. He will have a really big family, and later on, his tribe will be really big and really important.” ");
INSERT INTO engPEV_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","That’s the story about the way that Jacob made Ephraim more important than Manasseh. Then Jacob said another good thing about Ephraim and Manasseh. Jacob said to them, “Later on, the Israel mob will always remember that God was very good to both of you. And sometimes they will say to each other, ‘I’m asking God to be good to you, just like he was good to Ephraim and Manasseh.’” ");
INSERT INTO engPEV_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Then Jacob said to Joseph, “Listen, I am going to die very soon. But God will be with you and your family. Later on, he will take your family back to that country where your father and grand-fathers lived, and he will give you land there.” ");
INSERT INTO engPEV_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Jacob also said to Joseph, “You know, a long time ago, I fought the Amor tribe with my long knife, and with my bow and arrows. And I took a bit of their land from them. Well, I’m giving you that bit of land too. I’m not giving it to your brothers, I’m only giving it to you.” ");
INSERT INTO engPEV_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Then Jacob sent somebody to bring all his sons to him. And Jacob said to his sons, “Come to me, all of you, and I will tell you about the things that will happen to you and your families. These things will happen later on. ");
INSERT INTO engPEV_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Come near to me, my sons. I am your father Jacob, and my other name is Israel. Listen to me.” ");
INSERT INTO engPEV_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Then Jacob said, “Reuben, you are my oldest son. You were born first. You were born at that time when I was a strong young man. You were the most important and the most powerful of all my sons. ");
INSERT INTO engPEV_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","But then you went and did whatever you wanted, just like the wild water in the sea. You took one of my wives, and you slept with her, like a man sleeps with his wife. That was a wrong and dirty thing you did. You made me really shamed. So you will not be my most important son any more.” ");
INSERT INTO engPEV_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Then Jacob said, “Simeon and Levi are just like each other. They both like to fight, and they use long knives to hurt people and kill them. ");
INSERT INTO engPEV_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","They got really angry, so they killed a big mob of men. They are like people that caught a lot of cows and cut their legs, for no reason. They make secret plans, but I will not do that with them. I will not go with them to do bad things. ");
INSERT INTO engPEV_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","I’m asking God to curse Simeon and Levi, because they are really angry men, and they properly hurt people. So God will split up their tribes, and he will send their people all over the land. He will mix them up with all the other tribes of the Israel nation.” ");
INSERT INTO engPEV_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Then Jacob said, “Judah, your tribe will fight against their enemies, and your tribe will win. Then the tribes of all your brothers, they will say that your tribe is really great, and they will bend down in front of your tribe, to show them respect.” ");
INSERT INTO engPEV_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Jacob also said, “My son Judah is like a strong young lion, like a lion that fought another animal and won, like a lion that killed an animal and ate it. He is like a lion that lies down to sleep, and nobody is brave enough to wake it up. ");
INSERT INTO engPEV_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Judah’s tribe will always be important and powerful. Leaders and big bosses will come from his tribe. People from other countries will bring them gifts. And people from different nations will respect them and do what they say. ");
INSERT INTO engPEV_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Judah’s land will be full of good grape vines. His tribe will even tie their donkeys to those grape vines, so that the donkeys can eat the grapes. They will make lots of grape juice and wine. They will have even more grape juice and wine than water. ");
INSERT INTO engPEV_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","There will be enough wine for everybody in Judah’s land, and they will all have lots of milk to drink.” ");
INSERT INTO engPEV_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Then Jacob said, “Zebulun’s tribe will set up their camp next to the sea, and it will be a safe place for ships. The north bit of Zebulun’s land will be near the town called Sidon, in Fonisha country.” ");
INSERT INTO engPEV_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Then Jacob said, “Issachar is like a strong donkey, like a donkey with bags on its back, that lies down to rest. ");
INSERT INTO engPEV_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","His tribe will see a country where the land is really good, and they will want to live in that land. So they will agree to work for the people that own that country, and those people will make them work really hard.” ");
INSERT INTO engPEV_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Then Jacob said, “Dan’s tribe will have their own bosses, just like all the other tribes of the Israel nation. Those bosses from Dan’s tribe, they will be good and fair to the people. ");
INSERT INTO engPEV_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan’s tribe will be smart, just like a clever snake. They will wait for their enemies, like a snake hiding beside the road. They will attack their enemies, and they will win against those enemies, like a snake that bites a horse’s leg, so that the man on the horse will fall down.” ");
INSERT INTO engPEV_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Then Jacob said, “God, I am waiting for you to save us.” ");
INSERT INTO engPEV_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Then Jacob said, “Bad men will attack Gad’s tribe, and those bad men will try to steal Gad’s things, but Gad’s tribe will fight back and attack those men, and those men will run away.” ");
INSERT INTO engPEV_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Then Jacob said, “Asher’s land will grow really good food. That food will be so good, rich bosses will pay a lot of money to eat it.” ");
INSERT INTO engPEV_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Then Jacob said, “Naphtali is like a wild animal called a deer, that is free to run wherever it wants, and has really pretty babies.” ");
INSERT INTO engPEV_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Then Jacob said, “Lots of people will be born into Joseph’s family. Yes, Joseph’s family will grow big, just like a grape vine that grows near a spring of water, and has lots of fruit. Its branches are so long, they grow over a big wall. ");
INSERT INTO engPEV_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Joseph’s enemies hated him, they attacked him and made trouble for him. ");
INSERT INTO engPEV_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","But he didn’t give up, God helped him to stand strong. Yes, God, my God, he is the one that has all the power. God looks after his people properly, just like a man looks after his sheep properly. God is like solid rock, he keeps his people safe.” ");
INSERT INTO engPEV_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Jacob kept on talking to Joseph. He said, “My God will help you. God has power over everything, and he will be good to you. He will make rain come down from the sky, and he will make water come up from springs under the ground, so that your land will grow really good food. You will have lots of kids and grand-kids, and your animals will have lots of babies. ");
INSERT INTO engPEV_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","I know that God will give you all those good things, and they will be better than anything the old mountains can give you, better than anything else on the earth.” Then Jacob said, “Joseph, you are more special than all your brothers, so I’m asking God to give you all those good things.” ");
INSERT INTO engPEV_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Then Jacob said, “Benjamin’s tribe will be like a wild dog that is really hungry. In the morning, they will kill their enemies and grab all their good things, and in the night time, they will share those good things with each other.” ");
INSERT INTO engPEV_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","In that way, Jacob talked to his 12 sons, and he told them about things that will happen to them and their families later on. He said different things to each of his sons, and those things that he said were right for each one of them. You know, later on, Jacob’s 12 sons became the grand-fathers of the 12 tribes in the Israel mob. ");
INSERT INTO engPEV_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Then Jacob said to his sons, “I am going to die very soon. After I die, I want you mob to bury my body in that cave in Canaan country. My father’s body and my grand-father’s body are already in that cave. That cave is on some land in the place called Makpelah, to the east of Mamreh, in Canaan country. That land used to belong to a man from the Heth tribe, called Efron. My grand-father Abraham, he bought that land from Efron, to use as a grave. ");
INSERT INTO engPEV_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","And Abraham buried his wife Sarah there. Some time later, Abraham died, and they buried him in that same place. My father Isaac and his wife Rebekah, they are buried there too. And I also buried my wife Leah there. ");
INSERT INTO engPEV_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","That land and that cave, they used to belong to the Heth people, but now that place belongs to our family.” ");
INSERT INTO engPEV_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jacob finished saying all those things to his sons, and he lay down on his bed. Then he breathed for the last time, and he died. ");
INSERT INTO engPEV_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Then Joseph bent down and hugged his father’s body. He cried, and he kissed his father’s face. ");
INSERT INTO engPEV_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Then Joseph talked to some of his workers. Joseph said to them, “My father Jacob died. Now I want you to get his body ready for the funeral. I want you to look after his body in that special way that you do for important people.” So those men worked on Jacob’s body to get it ready, then they put special oils and perfumes on his body, so that it will not rot away. Then they wrapped his body in long bits of cloth, and they put it in a special coffin. ");
INSERT INTO engPEV_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","It took them 40 days to finish doing all those things. The Egypt people cried for Jacob for 70 days. ");
INSERT INTO engPEV_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","At the end of those 70 days, Joseph talked to Pharaoh’s important workers. Joseph said to them, “I want you to do something for me. Please be good to me, and do this thing that I ask. Please go to Pharaoh, and tell him that I said, ");
INSERT INTO engPEV_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘My father talked to me before he died. He said, “I am going to die very soon. After I die, I want you to take my body to Canaan country, and put it in that grave that I got ready for myself.” And my father got me to promise that I will do that. So now, please let me go to Canaan country, so that I can bury my father there, just like he said. Then I will come back here.’” ");
INSERT INTO engPEV_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","So Pharaoh’s workers went to Pharaoh, and they said everything Joseph asked them to say. And Pharaoh told them to say to Joseph, “Yes, you can go to Canaan country, and you can bury your father there, just like you promised him.” ");
INSERT INTO engPEV_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","So Joseph left Egypt, and he started to go towards Canaan country. He took his father’s coffin with him, so that he could bury him in Canaan country. And lots of people went with Joseph. All of Pharaoh’s important workers went with him, and all the boss men from Egypt country went with him. ");
INSERT INTO engPEV_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","And Joseph’s brothers, and the rest of his family, and his father’s relatives, they all went with Joseph too. Only the little kids and the animals stayed in Egypt country, that was all. They stayed there in the place where they were living, called Goshen. Everybody else went with Joseph to Canaan country. ");
INSERT INTO engPEV_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","And some of Pharaoh’s soldiers went with Joseph too. Some of those soldiers rode on horses, and some of them rode in trailers with horses pulling them. All of that mob went with Joseph to Canaan country. It was a really big mob of people. ");
INSERT INTO engPEV_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","After a while, Joseph and his mob got to the place called Atad, near the Jordan River. There was a place there with flat ground, where farmers sometimes sorted their plants. Joseph and his mob stopped there, and they cried loudly for Joseph’s father. Joseph and his mob cried for 7 days, and they did other things to show that they were very sad. ");
INSERT INTO engPEV_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","The Canaan people lived in that land. They saw Joseph and his mob crying at the place called Atad, near the Jordan River. And they said to each other, “Look at that mob that came here from Egypt country. They are really sad.” So the Canaan people gave that place a new name. They called it Abel-Mizrayim. That name means the Egypt people are sad. ");
INSERT INTO engPEV_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","13","Then Joseph and his brothers took their father’s coffin to the place in Canaan country that their father told them about. They put his coffin in the cave there, just like he told them to. Jacob’s family owned that cave and the land around it. You see, a long time before this, Abraham bought that land and that cave from a man from the Heth tribe. That man’s name was Efron. Abraham bought that cave to use it as a grave. It was at a place called Makpelah, to the east of Mamreh. ");
INSERT INTO engPEV_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","That’s the story about how Joseph buried his father. After that, Joseph went back to Egypt country with his brothers, and with everybody else that came to Canaan country with him. ");
INSERT INTO engPEV_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","After Jacob died, Joseph’s brothers started to worry, and they said to each other, “When our father was alive, Joseph was good to us. But maybe Joseph is still angry about all those bad things that we did to him. Now our father is dead, maybe Joseph will do payback to us.” ");
INSERT INTO engPEV_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","So Joseph’s brothers sent a message to Joseph. This is what they said in that message, “Joseph, our father talked to us before he died. ");
INSERT INTO engPEV_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","He told us to say to you, ‘I know that your brothers did really bad things to you. They went wrong, and they hurt you. Please let go of all those bad things that your brothers did, and don’t do payback to them.’” Joseph’s brothers also said this in their message, “Please let go of all those bad things that we did, and don’t do payback to us. We respect God, just like our father did.” Joseph listened to that message from his brothers, and he started to cry. ");
INSERT INTO engPEV_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Then his brothers came to him, and they quickly got down on their knees and put their faces near the ground, to show respect to Joseph. And they said to Joseph, “You are our boss, and we are your work-men.” ");
INSERT INTO engPEV_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","But Joseph said to his brothers, “Don’t be frightened. God is the only true judge. I’m not God, so I will not judge you mob.” ");
INSERT INTO engPEV_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Then Joseph said, “You know, a long time ago, you mob made a plan to hurt me. But God had a plan too. His plan was good, and it was more powerful than your plan. You did bad things, but God used them to make good things happen. Yes, he brought me here to Egypt country, so that I helped lots of people stay alive when the food plants didn’t grow. And those people are still alive today. ");
INSERT INTO engPEV_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","So don’t be frightened. I will not do payback to you mob. No, I will keep on looking after you and your little kids, and I will make sure that you always have enough food to eat.” In that way, Joseph talked in a friendly way to his brothers, and he helped them feel happy again. ");
INSERT INTO engPEV_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","After that, Joseph kept on living in Egypt, and all his father’s family lived there too. And Joseph lived until he was 110 years old. ");
INSERT INTO engPEV_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","While Joseph was still alive, his sons Ephraim and Manasseh had kids, and some of those kids had kids too. So Joseph got to see his great grand-kids. One of Manasseh’s sons was called Makir, and later on, Makir had his own kids. Then Joseph adopted Makir’s kids into his family, and they became like his own kids. ");
INSERT INTO engPEV_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Then one day, Joseph said to his brothers, “I am going to die very soon. But don’t worry. God is going to help you mob in a powerful way. Yes, one day, God will take all our mob out of this country, and he will give our mob all the land in Canaan country, just like he promised to our great grand-father Abraham, and our grand-father Isaac, and our father Jacob.” ");
INSERT INTO engPEV_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Then Joseph got his brothers to make a strong promise. He said, “You have to promise that you will not leave my body here in Egypt country. When God takes our mob back to Canaan country, they have to take my body with them.” ");
INSERT INTO engPEV_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Then Joseph died. He was 110 years old. The Egypt people put special oils and perfumes on Joseph’s body, so that it will not rot away. Then they wrapped his body in long bits of cloth, and they put it in a coffin in Egypt country. ");
INSERT INTO engPEV_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","There was a man called Elkanah. He was from Ephraim’s tribe, and he lived in a town called Ramah in the hill country. His father was Jeroham, his grand-father was Elihu, and his great grand-father was Tohu. He belonged to the Zuf family. ");
INSERT INTO engPEV_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","He had 2 wives called Hannah and Penninah. Penninah had some kids, but Hannah had none. ");
INSERT INTO engPEV_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Every year Elkanah used to go with his family from Ramah to Shiloh. They went to Shiloh to show respect to God, the boss of everything, and to burn meat for him. At that time, God’s ceremony house was in Shiloh. An old man was there called Eli. He was the leader of God’s ceremonies. His 2 sons, Hofni and Finiyas, also worked in God’s house. They looked after God’s ceremonies too. ");
INSERT INTO engPEV_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","When Elkanah was in Shiloh, he used to burn meat to give it to God, and he gave some of it to his family to eat. He gave meat to Penninah and her kids. ");
INSERT INTO engPEV_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","His other wife, Hannah, had no kids. You see, before this time, God stopped her from having kids. But Elkanah loved her very much, so he used to give lots of meat to her. ");
INSERT INTO engPEV_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","But Penninah used to make fun of her because she had no kids. So Hannah got upset. ");
INSERT INTO engPEV_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Every year it was like that. Whenever they went up to God’s house at Shiloh, Penninah used to make fun of Hannah until she cried. She felt so sad she couldn’t eat. ");
INSERT INTO engPEV_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Her husband used to ask her, “Why are you crying? You have to eat. Don’t be sad. Don’t keep on worrying that you have no sons. I love you very much anyway.” ");
INSERT INTO engPEV_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","One time at Shiloh, after they finished eating and drinking, Hannah got up and went to God’s house to talk to God. The old man Eli sat on a chair at the door of God’s house. ");
INSERT INTO engPEV_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","Hannah was so sad. She cried and prayed to God like this, ");
INSERT INTO engPEV_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","“God, you are the boss of everything. I am just your worker. I’m sad. Please help me. Don’t forget about me. I want to ask you this. Let me have a little boy. If you do that, I’ll give him back to you, so he can work for you until he gets old. Nobody will cut his hair, so that other people will see that he belongs to you.” ");
INSERT INTO engPEV_vpl VALUES ("S11_12","010_1_12","1SA","1","12","13","She talked quietly to God for a long time. Eli saw her mouth moving, but couldn’t hear anything, so he thought she was drunk. ");
INSERT INTO engPEV_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","He said, “Why did you come here drunk? Throw that wine away.” ");
INSERT INTO engPEV_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Hannah answered, “No, old man. I’m not drunk. I haven’t drunk any wine at all. I’m a sad woman. I talked to God, and I told him my story. ");
INSERT INTO engPEV_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Please don’t call me no good. I am properly sad. I want God to help me.” ");
INSERT INTO engPEV_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Eli said, “Don’t worry. Go now. We Israel mob follow a good God. He will do whatever you ask him.” ");
INSERT INTO engPEV_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Hannah said to him, “Thank you, old man. You have made me feel happy now.” And she left God’s house, and she went and ate some food. Her face was not sad any more. ");
INSERT INTO engPEV_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","The next day, Elkanah got up and went with his family to show respect and pray to God once again. Then they went home to Ramah. Then Elkanah slept with his wife, Hannah, like married people do together. But God didn’t forget that Hannah asked for a boy. ");
INSERT INTO engPEV_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Some time later, she really did have a little boy, and she named him Samuel. That name means God heard. She said, “I asked God for him, and he heard me, so I’ll name him Samuel.” ");
INSERT INTO engPEV_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","A year later Elkanah went with his family to Shiloh as usual, to show respect to God, and to burn meat and give it to him. You see, long before Elkanah promised to do that, so he wanted to keep on doing it. ");
INSERT INTO engPEV_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","But his wife Hannah stayed at home. She said, “My baby is still drinking my milk. After he stops drinking my milk, I will take him to Shiloh to give him to God. Then he will stay at that place all the time.” ");
INSERT INTO engPEV_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Elkanah said, “All right, if you like, stay here until your baby stops drinking your milk. After that, God will help you to keep your promise.” So Hannah stayed home with her little boy while he was still drinking her milk. ");
INSERT INTO engPEV_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Some time later, when the boy was bigger, he stopped drinking her milk. Elkanah went with his family as usual to God’s ceremony house at Shiloh. Hannah and her son went too. They took a big bull, a bag of flour and a big leather water bag full of wine. ");
INSERT INTO engPEV_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Elkanah and Hannah killed the bull and burned it for God. Then they took the boy to Eli, the old man that looked after God’s ceremonies. ");
INSERT INTO engPEV_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Hannah said to him, “Old man, do you remember me? A long time ago, I stood here with you. You heard the way I cried and prayed to God. ");
INSERT INTO engPEV_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","I wanted a little boy, and God heard me. He let me have this one, just like I asked. ");
INSERT INTO engPEV_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Now I want to give him to God. He will work for God until he gets old.” After she told him that, they showed respect to God. ");
INSERT INTO engPEV_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","After that, Elkanah and his family went home to Ramah. Samuel stayed at Shiloh, and there Eli taught him the way to work for God. ");
INSERT INTO engPEV_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","Eli’s 2 sons both looked after God’s ceremonies, but they were no good. They didn’t respect God. ");
INSERT INTO engPEV_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","If somebody gave meat to God, those 2 used to take meat the wrong way from that person. You see, the Israel mob used to boil meat in a big cooking pot at God’s ceremony house. One of Eli’s sons used to tell a worker to get meat for him. ");
INSERT INTO engPEV_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","The worker used to come with a big fork and stick it into the cooking pot to stab some meat. Some bits of meat got stuck on the fork, and that meat was like pay for that ceremony man. Maybe the worker got lots of meat on the fork, maybe a little bit. All the Israel mob used to go to Shiloh to give meat to God. Those 2 did the same to everybody whenever they came to Shiloh. ");
INSERT INTO engPEV_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","But that was not the right way to do it. They should burn the fat in the fire first. But those 2 didn’t do that. The worker used to tell the owner of the meat, “Give me meat for the 2 men that look after God’s ceremonies, so they can cook it on the fire and eat it. They don’t like meat that’s boiled in water. Give them raw meat.” ");
INSERT INTO engPEV_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","That man might answer, “Wait for me to burn the fat first. Then you can get the meat.” But the worker said, “No. Give it to me right now, or I will just take it from you.” ");
INSERT INTO engPEV_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","So Eli’s 2 sons kept on doing things the wrong way. They didn’t respect God or his word. God was angry with them. ");
INSERT INTO engPEV_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","The boy Samuel worked for God. He wore special clothes like those of a man that looked after God’s ceremonies. ");
INSERT INTO engPEV_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Every year Hannah went to Shiloh with her husband to burn meat for God, and every year she took a new coat to Samuel. ");
INSERT INTO engPEV_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Eli used to pray to God for Elkanah and Hannah like this, “God, you gave this woman a boy, just as she asked, and she gave him back to you. So give them other kids now instead of him.” Then they used to go back home. ");
INSERT INTO engPEV_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","And God was really good to Hannah. After that, she had some other kids. She had 3 boys and 2 girls. All this time Samuel grew up in God’s house, still working for him. ");
INSERT INTO engPEV_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","Eli became a really old man. He heard that his 2 sons did wrong things to the Israel people. He also heard that they slept with the women that worked in God’s house, like men sleep with their wives, but those men were not married to those women. Those women worked at the front door of the house. ");
INSERT INTO engPEV_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","Eli said to his 2 sons, “Lots of people tell me that you do bad things. Why are you doing that? ");
INSERT INTO engPEV_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","My sons, stop it. Lots of God’s people talk about you. That bad news is everywhere. ");
INSERT INTO engPEV_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","You know, if a man does wrong to another, somebody can ask God not to punish him. But if a man does wrong to God himself, nobody can ask God not to punish him.” But his sons didn’t listen to him. You see, God already made up his mind to kill them. ");
INSERT INTO engPEV_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","But the boy Samuel was growing up the right way. God loved him and so did everybody else. ");
INSERT INTO engPEV_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","At that time, God talked only to a few people. Only a few saw dreams from God. The boy Samuel helped Eli, and he did his work for God. ");
INSERT INTO engPEV_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Eli was a very old man, and he couldn’t see very well. Every night he used to sleep in his usual place in God’s house. One night the old man lay asleep. ");
INSERT INTO engPEV_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Samuel was a big boy by this time, and he slept in God’s house too, near the place where they kept God’s special box. After the sun went down, they used to light a lamp there. One night, when it was still burning, ");
INSERT INTO engPEV_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","God called out to the boy, “Samuel.” The boy answered, “Yes? What is it?” ");
INSERT INTO engPEV_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","And he got up and ran to Eli and said, “Yes? What is it? You called out to me.” Eli answered, “No, I didn’t call you. Go back and lie down.” So Samuel went back and lay down. ");
INSERT INTO engPEV_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Then God called out again, “Samuel.” So the boy got up again and went to Eli and said, “Yes? What is it? You called out to me.” The old man said, “No, boy, I didn’t call out to you. Go back and lie down.” ");
INSERT INTO engPEV_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","You see, Samuel didn’t know God yet. It was the first time God talked to him like that, and he didn’t know his voice. ");
INSERT INTO engPEV_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","After that, God called out again, “Samuel.” So the boy got up, and he went to Eli again and said, “Yes? What is it? You called out to me.” Then the old man knew that it was God that called out to him, ");
INSERT INTO engPEV_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","so he said, “Go back and lie down. If somebody calls out, say like this, ‘Yes, God, talk to me. I’m listening to you.’” So Samuel went back and lay down. ");
INSERT INTO engPEV_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","God came and stood close to him, and he said the same thing again, “Samuel.” Samuel said, “Yes, God, talk to me. I’m listening to you.” ");
INSERT INTO engPEV_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Then God said to him, “I will do something different in this place. After the Israel mob hear it, they will be shocked. ");
INSERT INTO engPEV_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","I will finish up Eli’s family, as I said before. ");
INSERT INTO engPEV_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","I told Eli, ‘I’m angry with you and your family, and I will finish you all. You knew that your 2 sons did wrong things, without any shame, and with no respect for my word. Everybody hates them now. But you didn’t stop them at all. ");
INSERT INTO engPEV_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Your family did wrong things lots of times, so I tell you and your family, that if you burn meat for me to try to make me happy, it will not work. I will still punish you mob.’” ");
INSERT INTO engPEV_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Samuel heard it, and he went and lay down again. Early the next morning he opened the door of God’s house as usual. He was frightened to tell Eli the story God told him. ");
INSERT INTO engPEV_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","But the old man called out to him, “Samuel, come here.” Samuel answered, “Yes? What is it?” ");
INSERT INTO engPEV_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","The old man asked, “What did God say to you? Tell me straight. If you don’t tell me straight, God will be very angry with you.” ");
INSERT INTO engPEV_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","So Samuel told him the whole story, right to the end. Eli said, “Truly he is the great God. He can do whatever he wants.” ");
INSERT INTO engPEV_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","After that, Samuel grew up to become a man. And God was with him, so the words he said were really true. ");
INSERT INTO engPEV_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","All the Israel mob knew him, everybody from every place, from the north to the south. They all knew that Samuel was God’s messenger. ");
INSERT INTO engPEV_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Lots of times God came to him at that place called Shiloh. He showed himself to Samuel and told his message to him. ");
INSERT INTO engPEV_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","That’s the way Samuel talked to all the Israel mob. At that time, a lot of soldiers from Philistia came together to fight the Israel mob. The Israel mob camped near a place called Ebenezer. The Philistia mob camped near a place called Afek. ");
INSERT INTO engPEV_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","The 2 armies met in the middle for a big fight. The Philistia mob killed dead lots of the Israel mob. 4,000 of them died. ");
INSERT INTO engPEV_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","After that, the Israel mob went back to their camp. The elders asked each other, “Why did God let them beat our mob? Let’s go to Shiloh, to get God’s special box. If we have that box with us, God will help us whenever we fight the Philistia mob.” ");
INSERT INTO engPEV_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","So they sent some men to Shiloh to get God’s special box. They thought, “That box will be with us, so God will help us.” Eli’s 2 sons, Hofni and Finiyas, they went along too, to watch over the special box. God is the boss of everything. He sits on that box between the 2 statues of angel messengers. ");
INSERT INTO engPEV_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","After they brought the box to their camp, the Israel mob were so happy that they shouted out real loud. Their shouts were so loud they made the ground shake. ");
INSERT INTO engPEV_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","The Philistia mob heard it, and they asked each other, “What’s happening? Why are the Israel mob shouting?” Then they heard that the Israel mob had God’s special box with them, ");
INSERT INTO engPEV_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","and they got frightened, and they said to each other, “Oh no. Their God has come to them. This is the first time this sort of thing has happened to us. Now we’re in big trouble. ");
INSERT INTO engPEV_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","Nobody can save us from their powerful gods. Their gods helped them when they were in the desert. They hit the Egypt mob with all kinds of sickness and other trouble. ");
INSERT INTO engPEV_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","So we Philistia mob, we have to stay strong. We’ve got to beat them, so that we will be their bosses, otherwise they might become our bosses. Don’t be afraid of them. Let’s be real men and hit them hard.” ");
INSERT INTO engPEV_vpl VALUES ("S14_10","010_4_10","1SA","4","10","11","And they really did get properly strong. They attacked the Israel mob again, and they killed dead lots of Israel’s soldiers. 30,000 of them died. Then the Philistia mob stole God’s special box. And they killed dead Eli’s 2 sons, Hofni and Finiyas. They died there too. The other Israel soldiers, they just ran away. They ran straight back home. ");
INSERT INTO engPEV_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","On that day a messenger ran from the fighting with the bad news. He was from Benjamin’s tribe. He tore his clothes and put dirt on his head, to show he was upset about it, and he ran all the way to Shiloh. ");
INSERT INTO engPEV_vpl VALUES ("S14_13","010_4_13","1SA","4","13","15","Eli was a really old man by this time. He was 98 years old, and he was blind. He sat in a chair beside the road. He worried about God’s special box. He was afraid something bad might happen to it. After the messenger arrived at that place, he went around and told the bad news, and lots of people started to cry. Eli heard it and called out to the man, “What’s happening? Why is everybody crying like that?” ");
INSERT INTO engPEV_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","The man ran over to Eli and said, “Old man, I ran away from the fighting.” The old man asked, “What happened?” ");
INSERT INTO engPEV_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","He answered, “We Israel mob ran away from the Philistia mob. They killed dead lots of our soldiers, and your 2 sons are dead too. And they even stole God’s special box from us.” ");
INSERT INTO engPEV_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","Eli was still on his chair at the door. After he heard that the Philistia mob stole the special box, he fell over backwards, and he broke his neck and died. You see, he was an old man and very fat. He was boss of the Israel mob for 40 years. ");
INSERT INTO engPEV_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","So the Philistia mob stole God’s special box. They took it from Ebenezer to a town called Ashdod, in Philistia country. ");
INSERT INTO engPEV_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","They carried it into the house of their god. They called him Dagon. In that house was a big statue of Dagon, made of stone. The Philistia mob used to show respect to that statue, just like it was real. And they put God’s special box next to it in that house. ");
INSERT INTO engPEV_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","The next morning, the Ashdod mob got up, and they saw their statue. It lay on the ground on its belly in front of God’s special box. So they stood it up again. ");
INSERT INTO engPEV_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","The next morning, they saw it on the ground like that again. It was lying there on its belly, in front of God’s special box. Its body was still good, but its head and arms were broken off. They lay in the doorway. ");
INSERT INTO engPEV_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","So Dagon’s workers, and everybody else, they did not want to walk through that door any more. They jumped through the doorway every time they went inside that house, so they would not step on the place where bits of Dagon used to be. And they still do that. ");
INSERT INTO engPEV_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","Then God made trouble for the people of Ashdod and the country around that town. He made everybody really sick, with lots of boils. ");
INSERT INTO engPEV_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","After they saw that bad sickness, they said to each other, “We’re in big trouble with the God of the Israel mob. And now he hits Dagon as well. We’ve got to throw away that special box.” ");
INSERT INTO engPEV_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","So they sent messengers to the bosses from other places of the Philistia nation to come and meet together at Ashdod. They asked them, “What will we do with this box of the God of the Israel mob?” They answered, “Send it to another place now, to the town called Gath.” So then they took the special box to Gath. ");
INSERT INTO engPEV_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","But after they took it there, God made trouble for the Gath mob, in the same way. Everybody got really sick, with lots of boils. All the kids and the adults got sick. That made them really frightened. ");
INSERT INTO engPEV_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","So the Philistia mob took the special box to another place, this time to the town called Ekron. After they arrived at Ekron with the special box, lots of people from that place shouted out as they saw it, “Oh no. They have brought that special box here now. We will all die.” ");
INSERT INTO engPEV_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","So they sent messengers to the bosses from other places to come and meet together at Ekron. This time they said, “Send it away. Send it back to its own country. It might finish us up and everybody else in Philistia.” Lots of people in that place died from the same sickness. That’s how God made them frightened. He made big trouble for all the Philistia mob. ");
INSERT INTO engPEV_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","The other people that were still alive, they were really sick, with lots of boils. They cried out to their gods, to ask them to help. ");
INSERT INTO engPEV_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","The Kiriath-Jearim mob took God’s special box back to their country, to the house of a man called Abinadab. That house stood on the top of a hill. And they picked his son Eleazar to look after that box. ");
INSERT INTO engPEV_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","God’s special box stood there at that house for 20 years. All that time the Israel mob felt sad. They thought God left them, so they kept on asking him to help them. ");
INSERT INTO engPEV_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","Then Samuel asked them, “Is it true that you mob want to turn back to God? Well, you have to do this. Throw away all those statues made of wood and stone. Throw away those statues of women called Astarti. Those things do not belong to us Israel mob. They are from another place. You mob have to show respect only to God. Turn back to him. Give yourselves only to him. If you do that, he will save you from the Philistia mob.” ");
INSERT INTO engPEV_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","So the Israel mob listened to him and threw away all those things, those statues like men called Baal and those other statues like women called Astarti. And they turned back to God and showed respect only to him. ");
INSERT INTO engPEV_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","Then Samuel told them all, “Send messengers to every place. I want all the Israel mob to meet together at that place called Mizpah. Then I will pray to God for everybody there.” ");
INSERT INTO engPEV_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","So they all met together at Mizpah. They got some water from a spring and poured it on the ground. That was their way to tell God that they felt shamed. They were sorry that they showed respect to those statues. On that day they didn’t eat any food as they prayed to him. They prayed like this, “Our God, we did wrong things. We didn’t follow your way.” That’s the way Samuel led the people to go the right way. ");
INSERT INTO engPEV_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","After the bosses from Philistia heard that the Israel mob came together at Mizpah, they took their soldiers to that place. The Israel mob heard they were coming, and they got frightened. ");
INSERT INTO engPEV_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","So they said to Samuel, “Pray to God for us. Keep on praying, don’t stop. Ask him to save us from the Philistia mob.” ");
INSERT INTO engPEV_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Then Samuel got a young sheep, and he burned all of it to give it to God. He kept on praying for the Israel mob, and God took notice of him. ");
INSERT INTO engPEV_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","God heard Samuel’s prayer. While he burned the young sheep, the Philistia mob came close, ready to attack the Israel mob. But suddenly God made a really loud noise, and it sounded like thunder. The Philistia mob got really frightened and confused, so the Israel mob easily beat them. ");
INSERT INTO engPEV_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","They chased them from Mizpah almost as far as a place called Beth-Car, and they killed lots of people dead along the way. ");
INSERT INTO engPEV_vpl VALUES ("S17_12","010_7_12","1SA","7","12","13","The Philistia mob ran away and went home. Then Samuel got a big stone, and stood it up half-way between 2 places, Mizpah and Shen, so that everybody will remember the things that happened. And he said, “God was helping us.” So he called the stone Ebenezer. That name means stone that belongs to the one that helps us. The Philistia mob sat quiet for a long time. They didn’t come back to the Israel mob’s country. So God saved them from the Philistia mob for a long time, until Samuel became an old man. ");
INSERT INTO engPEV_vpl VALUES ("S18_1","010_8_1","1SA","8","1","2","Samuel had 2 sons. His older son was called Joel, his younger son was called Abijah. After Samuel became an old man, he picked them to be bosses for the Israel mob. They were court judges, working at the place called Beersheba. ");
INSERT INTO engPEV_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","But they were not like their father. They were greedy. They thought only about money. Bad men used to give them money in a quiet way, and then they used to let those bad men go free. ");
INSERT INTO engPEV_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","So all the elders of Israel met together at the town called Ramah, to talk to Samuel. ");
INSERT INTO engPEV_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","They said, “You are an old man now. Your sons don’t live straight like you, so they shouldn’t be judges for us. You have to pick one man to be the big boss for us. In other countries they have one big boss. We want to be the same as them.” ");
INSERT INTO engPEV_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Samuel wasn’t happy about that, so he prayed to God. ");
INSERT INTO engPEV_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","God said to him, “Listen to them. Do what they are asking. They don’t hate you. Really it’s me they hate. They hate their God. They don’t want me to be their boss any more. ");
INSERT INTO engPEV_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","That’s the way it was a long time ago, while I led their grand-fathers back from that country called Egypt. They used to turn away from me and show respect to gods from other places. Today they still do the same thing. And now they don’t want you or your family to be bosses either. ");
INSERT INTO engPEV_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","But it’s good to listen to them. Let them have a big boss. But warn them carefully, ‘If you have that sort of big boss, he will make it hard for you mob. He will make you do all kinds of hard things for him.’” ");
INSERT INTO engPEV_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Samuel told that story to the elders, just as God told it to him. ");
INSERT INTO engPEV_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","But they didn’t listen to him. They said, “No. We want a big boss. ");
INSERT INTO engPEV_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","In other places there is a big boss. We want that here too. We want a big boss to lead us whenever we fight with other mobs.” ");
INSERT INTO engPEV_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Samuel told God everything that the elders said to him. ");
INSERT INTO engPEV_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","God said, “Listen to them. Do as they ask. Give them a big boss.” So Samuel said to the elders, “All right. I’ll do that. So go back home now, all of you.” ");
INSERT INTO engPEV_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","There was an old man called Kish. He was an important man. He was from Benjamin’s tribe. His father was Abiyel. His grand-father was Zeror. His great grand-father was Becorath, and his great great grand-father was Afiah. ");
INSERT INTO engPEV_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Kish had a son called Saul. He was a young man with a properly good-looking face, and he was a lot taller than anybody else of the Israel mob. ");
INSERT INTO engPEV_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Kish had some donkeys, and one day, those donkeys wandered away and got lost. Kish said to his son Saul, “Go and look for those donkeys. Take one of the working men with you.” ");
INSERT INTO engPEV_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","So they went off to look for them. First they went and looked in the hill country that belongs to the Ephraim tribe. From there they went and looked in Shalisha country. But nothing, they didn’t find them. From there they went to look in the Shalim country. Still nothing. They also looked in the country that belongs to the Benjamin tribe, but they didn’t find them. ");
INSERT INTO engPEV_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","They went as far as the Zuf country. Then Saul said, “We’ve come a long way. Let’s go back, or my father might worry about us now, instead of those donkeys.” ");
INSERT INTO engPEV_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","But his working man said, “Wait a minute. What about that old man that tells God’s messages? He lives in this place. Everybody knows that he is God’s man. Whenever he says that something is going to happen, later it happens. We can ask him. He might tell us the place to look for the donkeys.” ");
INSERT INTO engPEV_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","After they got to that place, they saw the old man Samuel as he came towards them. He wanted to go up the hill, to the place where they used to burn meat to give to God. ");
INSERT INTO engPEV_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","You see, God talked to him the day before that, God said to him, ");
INSERT INTO engPEV_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","“I see that the Philistia mob makes trouble for my people. They cried out to me to help them, and I am listening to them. At about this time tomorrow, I will send a young man to you. He is from Benjamin’s tribe. He will rescue my people from the Philistia mob. Pour olive oil on his head to show that I pick him to be the big boss for my people, the Israel mob.” ");
INSERT INTO engPEV_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Samuel saw Saul as he came towards him, and God said to him, “There he is. He’s the one I told you about yesterday. He will be the big boss for my people.” ");
INSERT INTO engPEV_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","So Samuel waited for him at the town gate. You see, Saul hadn’t met that old man before. He didn’t know him, so he said to him, “They say there’s an old man that sees dreams from God, and he lives in this place. Where is his house?” ");
INSERT INTO engPEV_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Samuel answered, “That’s me. I’m the man that sees dreams. You 2 go ahead up that hill, to that place. We burn meat there to give it to God. Today you will both eat with me, and tomorrow I will tell you whatever you want to know. Then you can go back home. ");
INSERT INTO engPEV_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Oh, and those donkeys that ran away 3 days ago, don’t worry about them. Other people already found them. But think about this story now. Lots of people are saying, ‘One of Kish’s mob should be the big boss for us, the Israel mob.’” ");
INSERT INTO engPEV_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Later on, they came back from the top of the hill to Samuel’s house, and Samuel took Saul up on to the flat roof, to a clear place, so they could talk to each other. It was cool up on the roof at night, so Saul and his working man slept up there. ");
INSERT INTO engPEV_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Early the next morning Samuel called out, “Get up you 2. It’s time to go home now.” Saul got ready, then he and Samuel started to walk to the town gate. ");
INSERT INTO engPEV_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","Samuel said to him, “Send your working man ahead. You wait here. I want to tell you the word of God.” So the working man started to walk ahead. ");
INSERT INTO engPEV_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Samuel got some olive oil and poured it on Saul’s head. And then he kissed him on both his cheeks to show that he was his friend, and he said, “I pour this oil to show that God picked you to be the big boss for his people.” ");
INSERT INTO engPEV_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","Then Samuel told Saul, “You can start going home now. Soon you will arrive at the hill near the town called Gibeah. There is an army camp for soldiers from Philistia at that place. People get together on the top of that hill to burn meat to give it to God. When you arrive, you will see a group of men who tell God’s message, coming down that hill. And you will see other people in front of them, with all kinds of musical instruments. Those messengers and the musical people, they will all have special power from God, and they will tell his message. ");
INSERT INTO engPEV_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","And God’s spirit will also come to you, and he will give you that power too. Then you will be a different person, and you will tell his word whenever the men that tell God’s message meet together. ");
INSERT INTO engPEV_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","And after you see it happen like this, you will know that God will stay close to you. He will help you to do anything you think is right.” ");
INSERT INTO engPEV_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Saul turned around and started to leave that place, then God suddenly changed him. That day he told people God’s word, just like Samuel said. ");
INSERT INTO engPEV_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","After that, Samuel told the Israel mob to come together at the place called Mizpah. So they met together at that place. ");
INSERT INTO engPEV_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Samuel told Saul to stand up in front of them. And he said to everybody, “Look at this man. God picked him to be the big boss. There’s nobody else like him.” They all shouted happily, “Yes. He will be our big boss for ever.” ");
INSERT INTO engPEV_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","After that, the big boss of the mob called Ammon went to the town called Jabesh, in the Gilead country. His name was Nahash, and he came with big mobs of soldiers. They all stood in a circle around Jabesh. Nobody in the town could go outside. Then the Jabesh mob sent a messenger to that boss. He said, “Don’t kill us dead. We will let you be our boss. We will be your workers. Let’s all agree about that. You promise not to kill us dead, and we will promise to be your workers.” ");
INSERT INTO engPEV_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","Nahash sent the messenger back to say, “All right. I will not kill you mob dead. I will just take out your eyes. I will take out the right eye from every one of you. That’s the way I will shame you Israel mob. Whenever people from other places look at you mob, you will feel ashamed.” ");
INSERT INTO engPEV_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","The elders from that place sent the messenger back. They told him to tell Nahash, “First let us wait for 7 days. We will send messengers to every place in Israel. Maybe somebody will come to help us, maybe not. If not, we will give ourselves to you. Then you can take out our eyes.” ");
INSERT INTO engPEV_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","So the messengers went around to every place in Israel. They arrived at Saul’s camp at Gibeah with the bad news. The people there heard it, and they cried out loud. ");
INSERT INTO engPEV_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","Saul was out in the garden. As he came back with 2 bulls, he heard them crying and asked, “What’s happening? Why is everybody crying?” They told him the story the messengers said. ");
INSERT INTO engPEV_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","Saul heard that message, and then the spirit of God came to him and gave him special power. He got wild with that boss from Ammon. ");
INSERT INTO engPEV_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","He killed his 2 bulls, and he cut them into bits. Then he gathered lots of messengers together, and he gave a bit of meat to each one. He sent them to every place in Israel to say, “Look at this bit of meat. Every man has to follow Saul and Samuel, to fight the Ammon mob. If any man stays behind, Saul will cut up his bulls into little bits, like this meat.” God made Saul so strong that he made everybody frightened. So all the men came together. ");
INSERT INTO engPEV_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","Saul gathered them all together at a place called Bezek. 300,000 men came from the Israel mob and 30,000 came from the Judah mob. ");
INSERT INTO engPEV_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","Those men told the messengers from Jabesh, “Tell that Jabesh mob, ‘Tomorrow morning we will hunt away that Ammon mob and then rescue you mob before the middle of the day.’” The Jabesh mob heard that, and they were very happy. ");
INSERT INTO engPEV_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","So they sent a messenger back to the boss from Ammon, to tell him a lie, and say, “Tomorrow we will give ourselves to you. You can do whatever you like to us then.” ");
INSERT INTO engPEV_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","Before the sun came up Saul divided his fighting men into 3 groups. At day-light they ran into the Ammon mob’s camp and killed lots of them dead. They kept on killing them until the middle of the day. Only a few Ammon men were left, and they ran away in all directions. ");
INSERT INTO engPEV_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","One day, Samuel came to Saul and said, “Listen, Saul. God is the boss of everybody. He was the one that told me to pick you to be the big boss for his people the Israel mob. So listen to this message that he told me today. ");
INSERT INTO engPEV_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","He said, ‘A long time ago, as the grand-fathers of you Israel mob came from Egypt, the Amalek mob attacked them. They did wrong to my people. And now, I want to punish them. ");
INSERT INTO engPEV_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","So, Saul, I want you mob to go and kill the Amalek mob dead. Burn everything that belongs to them. Kill everything until there’s nothing left. Kill the men, women, kids, babies, bulls, cows, sheep, camels, and donkeys too. Kill everything. That’s the way you have to give them all to me.’” ");
INSERT INTO engPEV_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","So Saul sent messengers to every place, to tell the soldiers to meet together at a place called Telayim. Lots of soldiers came together at that place. There were 200,000 soldiers from Israel and 10,000 from Judah. ");
INSERT INTO engPEV_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Then Saul led them to the town where the Amalek mob lived, and they went and hid in a gully nearby. ");
INSERT INTO engPEV_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","At that time the Ken mob lived in that country. Saul sent a messenger to them to say, “I want to finish up all the Amalek mob, so you Ken mob have to get out of the way. A long time ago, you mob helped us Israel mob, as we came from Egypt. So I can’t hurt you now.” So the Ken mob moved away from that place. ");
INSERT INTO engPEV_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Then Saul and his men chased the Amalek mob from the place called Havilah in the east to the place called Shur in the west. Shur was half-way between Israel and Egypt. ");
INSERT INTO engPEV_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Saul’s mob killed dead all the men, and the women and the kids. They finished them up properly. But they didn’t kill the boss of the Amalek mob, a man called Agag. ");
INSERT INTO engPEV_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","They kept him alive. They also kept a lot of the animals alive. They took all the good sheep and goats, and all the good cows and bulls, and their young ones too. They only killed the rubbish animals dead. They didn’t finish all the animals properly. ");
INSERT INTO engPEV_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","That day God said to that old man Samuel, ");
INSERT INTO engPEV_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","“Saul didn’t listen to me. He’s turned away from me. Now I’m sorry that I picked him to be the big boss.” Samuel heard that message, and he was very angry and upset. All night he talked to God about it. ");
INSERT INTO engPEV_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Early the next morning, Samuel got up and went to look for Saul. Other people told him, “Saul isn’t here. He went to the place called Carmel. After he finished up the Amalek mob, he wanted everybody to think he was a great soldier, so he stood up a big stone there to remind them. Then he went to another place called Gilgal.” ");
INSERT INTO engPEV_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Samuel went to Gilgal, and Saul said to him, “Samuel. I hope God makes you happy. I did everything he told me to do.” ");
INSERT INTO engPEV_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","But Samuel said, “Really? So how come I can hear animals crying? I can hear sheep, goats, cows and bulls.” ");
INSERT INTO engPEV_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Saul answered, “It was the soldiers, they did that. They took the good animals that belonged to the Amalek mob. They kept them alive, to burn them for God. The other animals we finished properly.” ");
INSERT INTO engPEV_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","But Samuel said, “Stop talking, and listen carefully to me. God talked to me last night. Let me tell you about it.” Saul said, “Yes, tell me.” ");
INSERT INTO engPEV_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Samuel said, “At first you called yourself nothing. You didn’t try to be important. It was God that made you important. He picked you to be the big boss for the Israel mob. ");
INSERT INTO engPEV_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","And then he told you to kill all those bad Amalek people. He told you to finish them up properly. ");
INSERT INTO engPEV_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","So why didn’t you listen to him? Why did you do something that he said was wrong? You kept the best animals, so he is angry with you.” ");
INSERT INTO engPEV_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Saul was confused. He said, “What? Truly I listened to God. I did everything he told me to do. I killed everybody dead. But I brought their boss Agag back alive. ");
INSERT INTO engPEV_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","The soldiers only brought back the good animals. They got the best sheep, goats, cows and bulls for you to burn for God here at Gilgal.” ");
INSERT INTO engPEV_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","But Samuel answered, “God wants people to listen to his word properly and do what he says. He doesn’t want us to do wrong things and then burn meat or fat to give it to him. He really likes it when we do what he says. ");
INSERT INTO engPEV_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","You know, if somebody doesn’t listen to God, that person truly does wrong. If somebody prays to bad spirits, it’s just the same. If somebody is proud, God is not happy with that person. If somebody shows respect to statues made of wood and stone, that’s just the same. And you didn’t listen to God, so he turned away from you. You did wrong things, so God says, ‘You can’t be the big boss any more.’” ");
INSERT INTO engPEV_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Then Saul said, “I did wrong things. I didn’t listen to God or to you. I was afraid of the soldiers, and I listened only to them. ");
INSERT INTO engPEV_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Please don’t be angry with me. Please forgive me. Don’t leave me now. Come back with me to the people. I want to get down on my knees and show respect to God.” ");
INSERT INTO engPEV_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","But Samuel said to him, “No. I can’t go back with you. You didn’t listen to God, so he will not listen to you now. You did wrong things, so God has said, ‘You can’t be the big boss any more.’” ");
INSERT INTO engPEV_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Then Samuel said to the soldiers, “Where’s that Agag, the Amalek mob’s boss? Bring him to me.” They brought Agag to Samuel. Agag was not afraid, and he thought, “It looks like they will not kill me dead after all.” ");
INSERT INTO engPEV_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","But Samuel said to him, “You killed people with your own long knife. Now lots of women have no children any more. Well, just like that, your mother will have no children any more.” So Samuel killed Agag dead right there at Gilgal. And God watched him do it. ");
INSERT INTO engPEV_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Then Samuel left and went back to his place in the town called Ramah. Saul went back to his place in Gibeah. ");
INSERT INTO engPEV_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","After that, Samuel never saw Saul again. He was very sad about what Saul did. And God was sad too. He was sorry that he made Saul to be the big boss of Israel. ");
INSERT INTO engPEV_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","After that, God said to Samuel, “Saul is not a good boss any more. I will not help him now. Why do you keep on being sad for him? Forget about him now. Get a bottle of olive oil. Go and see that old man Jesse at the place called Bethlehem. I picked one of his sons to be the new big boss of Israel.” ");
INSERT INTO engPEV_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Samuel said, “I can’t do that. Somebody might tell Saul, and he might kill me dead.” But God said, “Take a young cow with you. Say this to the Bethlehem mob, ‘I came here to burn this young cow, to give it to God.’ ");
INSERT INTO engPEV_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","And tell the old man Jesse and his sons to come too. At that time, I will show you the man that I picked. You have to pour olive oil on his head. That will show that I am picking him to be the big boss of Israel.” ");
INSERT INTO engPEV_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Samuel listened to God, and he went to Bethlehem. After he got there, the elders of the town came to meet him. They were really afraid. They were so frightened that they shook, and they asked, “Did you come with good news? Or are you angry with us?” ");
INSERT INTO engPEV_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Samuel answered, “No, I came happily. I came to burn this young cow with you mob, to give it to God. You have to wash and get ready. You have to be clean in God’s way before we can burn this young cow.” He also told Jesse and his sons to come. And he helped them to get ready. ");
INSERT INTO engPEV_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","After they came together, Samuel saw Jesse’s oldest son. His name was Eliab. Samuel thought, “I reckon this is the one God has picked to be the big boss.” ");
INSERT INTO engPEV_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","But God said to Samuel, “No, not this one. I didn’t pick him. You just see that he has a strong tall body. You people look at the outside of a person, but I know what they are like inside. I know the way they think.” ");
INSERT INTO engPEV_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","So Samuel asked Jesse to send the next son to him. His name was Abinadab. He came, and Samuel said, “No, God hasn’t picked this one.” ");
INSERT INTO engPEV_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Then Jesse sent Shammah, and Samuel said, “No, God hasn’t picked this one either.” ");
INSERT INTO engPEV_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Jesse sent all 7 of his sons one by one to stand in front of Samuel. But Samuel said to him, “God hasn’t picked any of these. ");
INSERT INTO engPEV_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Do you have another son?” Jesse answered, “Yes. There is my youngest son, David. But he is looking after the sheep out in the bush.” Samuel said, “Send somebody to get him and bring him here. We will wait for him. We can’t sit down and eat the meat without him.” ");
INSERT INTO engPEV_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","So Jesse sent somebody to get David, and he brought him back. David was a good-looking young man, with a strong body and a nice face. God said to Samuel, “This is the one. Stand up now, and pour olive oil on his head. I picked him to be the next big boss.” ");
INSERT INTO engPEV_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","So Samuel got the bottle of olive oil, and he poured oil on David’s head, while his older brothers were watching. God’s spirit went into David in a powerful way and stayed in him from that day on. Then Samuel went back to his place at Ramah. ");
INSERT INTO engPEV_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Then God’s spirit left Saul and did not go back to him. God sent a bad spirit that often made Saul frightened. ");
INSERT INTO engPEV_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","His workers said to him, “Boss. We can see that God has sent a bad spirit to make you frightened. ");
INSERT INTO engPEV_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","We will go and get somebody to come here and play the guitar for you. Whenever the bad spirit makes you frightened, he will play that guitar, and you will feel better then.” ");
INSERT INTO engPEV_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Saul said to them, “Yes, go and look for somebody, a good guitar player. Bring him to me.” ");
INSERT INTO engPEV_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","One worker said, “I know an old man in Bethlehem called Jesse. One of his sons plays the guitar, and he’s a really good-looking young man. He’s a good soldier too. He’s brave, and he talks clearly. God is close to him.” ");
INSERT INTO engPEV_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","So Saul sent messengers to Jesse to say, “The big boss Saul wants you to send your son to him, that David, the one that looks after the sheep.” ");
INSERT INTO engPEV_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","So Jesse got a donkey, and he put lots of food on it. He also put some wine in leather bags on the donkey. He said to his son, “Go to the big boss’s place, and take this donkey and a little goat with you.” ");
INSERT INTO engPEV_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","From then on, David worked for Saul. He liked David very much, so he gave him another job. Whenever the Israel mob went to fight their enemies, David carried Saul’s spear and shield for him. ");
INSERT INTO engPEV_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","And Saul sent a messenger back to Jesse, to say like this, “Saul likes David very much. Let him stay and work for Saul.” ");
INSERT INTO engPEV_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Lots of times God sent a bad spirit to make Saul angry. So David used to play his guitar to make him feel better. Then the bad spirit went away, and Saul felt better. ");
INSERT INTO engPEV_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","At one time the Philistia mob came together at the town called Socoh in the Judah country, to fight with the Israel mob. They camped at a place called Efes-Dammim. It is half-way between the town called Socoh and the town called Azekah. ");
INSERT INTO engPEV_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Saul gathered the Israel soldiers together, and they camped in the valley called Elah. They got ready there to fight with the Philistia soldiers. ");
INSERT INTO engPEV_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","There was a hill close by, so the Israel mob went up from the valley on to that hill. From there they saw the Philistia mob on the hill on the other side of the valley. ");
INSERT INTO engPEV_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","One of the Philistia soldiers was a really big man called Goliath, and he was from a town called Gath. He was really tall, about 3 metres. ");
INSERT INTO engPEV_vpl VALUES ("S117_5","010_17_5","1SA","17","5","6","In a fight he used to put on iron plates to cover his body. One covered his head, and 2 others covered his legs. Another covered his chest, and it was really heavy. It was about 60 kilograms. He carried 2 fighting spears, a short one and a long one. The short one was made of a brown metal called bronze. It was in a belt over his shoulder. ");
INSERT INTO engPEV_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","The long spear had a sharp point made of iron. The point was really heavy too, about 7 kilograms. Another soldier used to walk in front of Goliath, to carry his shield for him. ");
INSERT INTO engPEV_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Every day, Goliath used to go out into the middle and call out to the Israel mob like this, “Hey Israel mob. What are you waiting for? You call yourselves soldiers? Look at me. I’m a real soldier, from Philistia. You mob are just Saul’s working men. Listen. You pick one man and send him to me, so the 2 of us can fight. ");
INSERT INTO engPEV_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","If he kills me, we mob will let you take us all to Israel, to work for you mob. But if I kill him, we will take you mob back to Philistia, to work for us. ");
INSERT INTO engPEV_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Don’t be weak. Send one man to me so the 2 of us can fight.” ");
INSERT INTO engPEV_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Saul and the Israel mob heard that big man’s words, and they got frightened and confused. ");
INSERT INTO engPEV_vpl VALUES ("S117_15","010_17_15","1SA","17","15","16","That happened every day. Goliath used to go out and say that in the early morning and late afternoon. He did that for 40 days. At that time, David kept on going back from Saul’s place to his father’s place, to look after his father’s sheep. ");
INSERT INTO engPEV_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","One day, his father said, “Get this bag of cooked seed, and get 10 loaves of bread. Take them to your big brothers. ");
INSERT INTO engPEV_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","And take 10 big lumps of cheese too, and give them to the boss soldier. Go quickly. I’m worried about your big brothers. Bring back some news from them. Bring back something to show that they are still all right. ");
INSERT INTO engPEV_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Go to the valley called Elah. That’s the place where Saul and our mob are fighting with the Philistia mob.” ");
INSERT INTO engPEV_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","David listened to his father. Then he told another man to look after the sheep. The next morning, he put all that food on a donkey and went to the valley called Elah. After he got there, he saw the soldiers as they got ready to fight. They shouted to make themselves brave. ");
INSERT INTO engPEV_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","The Israel mob and the Philistia mob watched each other across the valley. ");
INSERT INTO engPEV_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","David gave the food to the man that was in charge of all the food, then he ran out to the soldiers and said hello to his brothers. ");
INSERT INTO engPEV_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","While they talked, that big man from Gath, Goliath, he went out into the middle as before. And he went around and shouted out loud, as he always did. And David heard him talk like that. ");
INSERT INTO engPEV_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Every time the Israel mob saw Goliath, they got frightened and ran away from him. ");
INSERT INTO engPEV_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","You see, they already said to each other like this, “Every day, that man comes to shame us and make fun of us. But if one of our men kills him, Saul will give him big money. He will also give him his daughter to marry. And Saul will not make his family pay tax money.” ");
INSERT INTO engPEV_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","David said to the men that stood near him, “That man gives us shame. He doesn’t know God. Somebody has to shut him up. What will Saul give if somebody kills him? We can’t let him make fun of the true God and his army, no way.” ");
INSERT INTO engPEV_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","They told him the same thing, “Saul will give big money to the man that kills Goliath. And he will give him his daughter to marry. And Saul will not make his family pay tax money.” ");
INSERT INTO engPEV_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","David’s oldest brother, Eliab, heard them talking, and he was angry with David. He said to him, “Why did you come here? What about those few little sheep? Who is watching them today? You are doing wrong. Why do you try to make yourself big? I know what you are like. You just came here for fun, to see the fighting.” ");
INSERT INTO engPEV_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","David asked, “Why are you angry with me? What did I do wrong? I’m just asking.” ");
INSERT INTO engPEV_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","And he asked another man, “What will Saul give to the man that kills Goliath?” The man told him the same thing as before. ");
INSERT INTO engPEV_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Somebody went and told Saul about David. So Saul sent a man to get him. ");
INSERT INTO engPEV_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","David said to him, “Boss. We can’t be frightened of that man. I will go. I will fight with him myself.” ");
INSERT INTO engPEV_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Saul said, “No way. You can’t fight with him. You are only a young man, and he’s a brave soldier. He was a soldier since he was young.” ");
INSERT INTO engPEV_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","But David said, “I look after my father’s sheep and goats. A lion or a bear might grab a sheep, and drag it away to eat. ");
INSERT INTO engPEV_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","I chase it, and I hit the cheeky animal, until it lets the sheep go. If it tries to bite and scratch me, I grab it by the hair and kill it dead. ");
INSERT INTO engPEV_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","I’ve killed lions and bears dead. That cheeky man is shaming God’s army, so I will kill him the same way. God is the only powerful one. ");
INSERT INTO engPEV_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","He has saved me from cheeky animals, and he will save me from that cheeky man too.” Saul said, “All right, you go and fight him. God will go with you.” ");
INSERT INTO engPEV_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Saul had some iron plates there, to use in a fight. He used to put them on to cover his body. Those things were really heavy. He gave them to David to put on. He also gave him a hat made of bronze, to cover the head. ");
INSERT INTO engPEV_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","David also put on a belt and put Saul’s long knife in it. It was the first time David put on heavy things like that, and he couldn’t walk properly. And he said to Saul, “I can’t walk like this. I’ve never used this kind of thing before.” So he took them off. ");
INSERT INTO engPEV_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","He got his walking stick and his thing for throwing stones, called a sling, and he went down to the creek. He picked up 5 smooth stones, and he put them in his bag. Then he walked up towards that Philistia man. ");
INSERT INTO engPEV_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Goliath saw him and walked towards him also. The other soldier that carried his shield walked in front of him. And they came close to David. ");
INSERT INTO engPEV_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","That big man laughed and made fun of David, “You are just a young man, a pretty boy. ");
INSERT INTO engPEV_vpl VALUES ("S117_43","010_17_43","1SA","17","43","44","Why are you coming at me with a stick? Do you think I’m a dog? All right, come. I will kill you dead, so the birds and the wild animals can eat your body. I will kill you dead properly.” And he called out to his gods and told them to curse David. ");
INSERT INTO engPEV_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","David answered, “You think you will kill me dead. You come to me with a long knife and 2 spears. But God sent me to fight you. He is the boss of everything, and he is with me now as I go to you, and I will kill you dead. God is the only powerful one, and he is the leader of the Israel soldiers. But you made fun of him. ");
INSERT INTO engPEV_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","So today God will help me to win. And I will kill you and cut off your head. Today you Philistia mob will all lie dead, and the birds and the wild animals will eat your bodies. Then everybody will know that the only real God is Israel’s God. ");
INSERT INTO engPEV_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","All of us here will know that God looks after his people, but he doesn’t have to use long knives and spears. He does it his way. God is boss of this fight. So we Israel mob will finish up all of you Philistia mob.” ");
INSERT INTO engPEV_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Goliath moved closer to hit David, but David quickly ran towards him. ");
INSERT INTO engPEV_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","He took out a stone from his bag, and he used his sling to throw it at Goliath, and that stone hit Goliath on the forehead and went through the bone in his head. He fell on his face on the ground and lay there. ");
INSERT INTO engPEV_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","And that’s how David won. He didn’t use a long knife. No, he killed that Philistia man dead just with a sling and a stone. ");
INSERT INTO engPEV_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","Then he ran up to him and stood on top of him. He took out the long knife from Goliath’s belt and cut off his head. After the Philistia mob saw that their big soldier lay there dead on the ground, they all turned around and ran away. ");
INSERT INTO engPEV_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","The Israel mob shouted out loud and chased them. They kept on chasing them along the Sharayim road as far as those 2 places called Gath and Ekron. Lots of Philistia people lay dead along that road. ");
INSERT INTO engPEV_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Then the Israel mob all went back home, and women came from lots of places to meet Saul, the big boss. They danced and sang happily. Some played little drums and others played guitars. ");
INSERT INTO engPEV_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","They sang like this as they went, “Saul killed dead a thousand enemy soldiers. David killed dead 10,000 of them.” ");
INSERT INTO engPEV_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Saul heard their words, and he was really angry. He thought, “They reckon David killed more enemy soldiers than me. Maybe they want to make him the boss of us Israel mob, instead of me?” ");
INSERT INTO engPEV_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","From then on, he was jealous of David, and he watched him all the time. ");
INSERT INTO engPEV_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","The next day, God sent a bad spirit to Saul. It made him go really mad. He just sat there in his house and screamed. David played the guitar for him as before. Saul was holding a spear in his hand, ");
INSERT INTO engPEV_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","and he thought, “I will spear David straight through and hang him on the wall.” So he threw it at him. But David quickly jumped out of the way, and the spear missed him. That happened 2 times, and he missed David each time. ");
INSERT INTO engPEV_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","One day, Saul said to his son Jonathan and to his workers, “David has got to die. You have to kill him.” But Jonathan was good friends with David, ");
INSERT INTO engPEV_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","so he told David, “Look out. My father is trying to kill you. Run away and hide over there in the bush. Wait there and watch out for somebody tomorrow morning. ");
INSERT INTO engPEV_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","I will go for a walk with my father near the place you are hiding. I will talk to him about you. After he goes back, I will tell you whatever he says.” ");
INSERT INTO engPEV_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","Next morning Jonathan and his father went for a walk in the bush, and they talked about David. Jonathan said good things about David like this, “He didn’t do wrong to you. He did all kinds of good things for you. He did things that helped you. You can’t do wrong to him now. ");
INSERT INTO engPEV_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","He didn’t worry about dying. He bravely fought that Philistia man, Goliath, and killed him dead. God used him to really help the Israel mob. You saw it too, and you were happy about it. Why do you want to kill him? He did nothing wrong.” ");
INSERT INTO engPEV_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","Saul listened to his son Jonathan, and he said, “God hears us, so I’m talking straight to you. I will not try to kill David.” ");
INSERT INTO engPEV_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","After Saul went back, Jonathan called to David to come out. He told him everything his father said. So they went back to Saul, and David started to work for him again. ");
INSERT INTO engPEV_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","One day, the Philistia mob came again, to fight with the Israel mob. David was a boss soldier at that time, and he attacked and killed lots of Philistia men dead. The rest of them ran away frightened. ");
INSERT INTO engPEV_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","Then David went back to Saul’s place, to work for him again, and God sent a bad spirit to Saul again. David played the guitar as before. At that time, Saul was holding a spear in his hand, ");
INSERT INTO engPEV_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","and he tried to spear him straight through and hang him on the wall. But again David quickly jumped out of the way, and the spear only hit the wall. That night David ran away safely from Saul’s house. ");
INSERT INTO engPEV_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","Saul sent men to watch David’s house that night and to kill him in the morning. But while it was still night time, David’s wife, Mihal, she saw them and said to David, “Run away quickly, right now. Don’t wait, or in the morning they will kill you dead.” ");
INSERT INTO engPEV_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Then she put a rope down from the window, and he climbed down it and ran away safely. ");
INSERT INTO engPEV_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","After that, David ran away from the community called Nayoth in the town called Ramah. He went to Jonathan’s place and asked him, “What have I done? What wrong thing did I do? Why does your father keep on looking for me, to kill me?” ");
INSERT INTO engPEV_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","Jonathan answered, “No way. That is not true. He will not kill you. My father has not told me that he wants to do that. He always tells me what he is thinking. That’s his way. He does not tell lies to me.” ");
INSERT INTO engPEV_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","But David said, “Listen. Let God punish me if what I said is not true. Your father knows that you and I are close friends. We are also brothers-in-law. He might think like this, ‘I can’t tell my son. He might get upset.’ No, listen to me. God is listening, so I can’t tell lies. Today I might die.” ");
INSERT INTO engPEV_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","Jonathan said, “All right, if that’s the way you feel, tell me what I should do for you now.” ");
INSERT INTO engPEV_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","David said, “Tomorrow, people will come together for the new moon ceremony, as they always do. Lots of people will be at your father’s place to eat food together. He told me to come and eat with him there too. But for the first 2 nights I don’t want to be at the food table, but I will hide in the garden. Is that all right? ");
INSERT INTO engPEV_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","If your father asks about me, tell him, ‘David asked me, “Is it all right for me to go to my home town, Bethlehem? Every year my family comes together there, to kill animals and burn them for God.” ’ ");
INSERT INTO engPEV_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","If he says, ‘All right,’ you will know that he will not hurt me. But if he gets angry, you will know that he wants to kill me.” ");
INSERT INTO engPEV_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","So David went to hide in the garden. The next day, lots of people came together at Saul’s place for the new moon ceremony. Saul sat down in his chair to eat. ");
INSERT INTO engPEV_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","His chair was near the wall as usual. Jonathan sat on the other side of the table. The boss soldier called Abner was also there, in the chair next to Saul. But David was not there. His chair was empty. ");
INSERT INTO engPEV_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","Saul noticed that he was not there, but he thought to himself, “Maybe something has happened to him, so he can’t eat at the ceremony?” (You see, God said that if something happened to somebody first, like maybe they touched a dead body, then they can’t eat at a special ceremony.) So Saul did not ask anybody about David. ");
INSERT INTO engPEV_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","The next day, David’s chair was still empty. So Saul asked Jonathan, “Why is David not here? And he was not here yesterday.” ");
INSERT INTO engPEV_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","Jonathan answered, and he told a lie like this, “David kept on asking me to let him go to Bethlehem. ");
INSERT INTO engPEV_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","He said, ‘Every year my family comes together there, to burn animals and give them to God. My older brother told me to come. So please, let me go to see my brothers.’ He told me that, and that’s why he can’t be here to eat food with you.” ");
INSERT INTO engPEV_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","Saul got very angry with his son, and he yelled at him like this, “You stupid fool. I know that you listen to David and not to me. That’s a shame job. You even shame your own mother. ");
INSERT INTO engPEV_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","If David is still alive, you can’t be boss in Israel after me. Send some men straight away, to grab David and bring him to me. He has got to die.” ");
INSERT INTO engPEV_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","Jonathan asked his father, “Why has he got to die? What wrong thing did he do?” ");
INSERT INTO engPEV_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","But as soon as Saul heard that, he suddenly threw his spear at his son. He meant to kill him dead, but he missed. So then Jonathan knew that his father really wanted to kill David. ");
INSERT INTO engPEV_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","Jonathan got wild and stood up and went outside. He was so upset that he did not eat anything all day. He was very sad that his father treated David so badly like that. ");
INSERT INTO engPEV_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","The next morning, he went out to the garden to meet with David. ");
INSERT INTO engPEV_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","David came out from behind a rock. He got down on his knees and put his face near the ground 3 times to show respect to Jonathan. They kissed each other and cried for each other. But David cried more than Jonathan. ");
INSERT INTO engPEV_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","Jonathan said, “Go carefully now. God will take care of you. You and I will be friends for ever. And God hears us whenever we talk like this. He will help your mob and my mob to live quietly for ever.” So David went away then, and Jonathan went back again to his home. ");
INSERT INTO engPEV_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","After that, David went to a place called Nob. There was an old man there called Ahimelek. He used to look after God’s ceremonies. He saw David coming with no soldiers. There were just a few work-men with him. This made Ahimelek afraid. He was so frightened that he shook. He asked David, “Why did you come here all by yourself? Where are your soldiers? What happened?” ");
INSERT INTO engPEV_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","David told a lie. He said, “Saul sent me to do a secret job for him. I can’t tell you about it. I told my soldiers to go ahead of me, and to meet me at another place. ");
INSERT INTO engPEV_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Do you have any food? I need some. Maybe 5 loaves of bread? Or maybe some other kind of food?” ");
INSERT INTO engPEV_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","The old man said, “I have nothing, no bread, I only have this special bread, that we make to give to God. Only men that do my kind of work can eat it. I’ll let you take it, but only if your men have not slept with women, like men do with their wives.” ");
INSERT INTO engPEV_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","David said, “Yes, we always do that when we work for the big boss. Today we have a special job to do, so we have to properly follow that rule. We have not slept with any women.” ");
INSERT INTO engPEV_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","So the old man gave him the special bread that was left from the day before, because the fresh bread was still on God’s table. ");
INSERT INTO engPEV_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","On that same day a working man came to that place to show respect to God. He heard David and Ahimelek as they talked together. His name was Doeg, and he came from the country called Edom. He worked for Saul, and he looked after Saul’s sheep. ");
INSERT INTO engPEV_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","David said to the old man, “I came with nothing. The big boss told me to go quickly, so I came without my spear and my long knife. Do you have one here?” ");
INSERT INTO engPEV_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","The old man answered, “Yes, there is that long knife that belonged to Goliath from Philistia. You killed him dead, down in the valley at Elah. That is all I have. If you like, you can take it. There it is, covered with a blanket, near the special ceremony clothes.” David said, “That is a good knife. It is better than anyone else’s knife. Give it to me.” ");
INSERT INTO engPEV_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","That man Doeg, from Edom, he went back and told Saul, “I saw David at Nob. He went to see that old man Ahimelek, Ahitub’s son. ");
INSERT INTO engPEV_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","That old man prayed to God for David. He asked God what David should do. And he gave him food. He also gave him the long knife that belonged to Goliath from Philistia.” ");
INSERT INTO engPEV_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","As soon as Saul heard it, he sent a messenger to get Ahimelek and his family to come to him. You see, at that time, Ahimelek and the men in his family used to look after God’s ceremonies at Nob. After they got Saul’s message, they all went to his place. ");
INSERT INTO engPEV_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","Then Saul said, “Listen to me, son of Ahitub.” And Ahimelek said, “What is it, boss?” ");
INSERT INTO engPEV_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","Saul asked, “Why do you want to trick me? You don’t think about me any more. You want to make David the big boss. You helped him with food, and you gave him a long knife. And you even prayed to God for him. David has turned against me. He’s just waiting to kill me dead some time.” ");
INSERT INTO engPEV_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","The old man answered, “No way, boss. David truly works for you. He is your best worker. And he is also your son-in-law, a boss soldier. Everybody that works for you respects him very much. ");
INSERT INTO engPEV_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","I have prayed lots of times to God for him, but you did not get angry with me before. Do not blame me and my family. We know nothing about whatever is going on.” ");
INSERT INTO engPEV_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","But Saul said, “You and everybody in your family will die today.” ");
INSERT INTO engPEV_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","And he told his workers, “Kill all these men dead. They listen to David and not to me. They knew that he ran away from me, but they did not tell me.” But the workers said, “No. We can’t kill these men that look after God’s ceremonies.” ");
INSERT INTO engPEV_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","So Saul said to Doeg, “All right. You kill those men yourself.” Doeg was from Edom, a different country. He didn’t care about those men, so he listened to Saul and did what he said. He got up straight away, and he killed dead 85 men that looked after God’s ceremonies, men that used to wear the special ceremony clothes. ");
INSERT INTO engPEV_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","Then he went to Nob, the town where Ahimelek’s family lived. They were the people who used to look after God’s ceremonies. Doeg killed dead everybody there too. He killed men dead, also women, kids, babies, bulls, donkeys, and sheep. He killed everything dead. ");
INSERT INTO engPEV_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","Only one man ran away safely from there. His name was Abiathar, one of Ahimelek’s sons. He ran away and joined up with David’s mob. ");
INSERT INTO engPEV_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","Another time Saul and his soldiers went to fight with the Philistia mob. After they came back, somebody told him this story, “David’s mob are in the desert at En-Gedi.” ");
INSERT INTO engPEV_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","So Saul got 3,000 of his best soldiers together from every place in Israel. And they went off to look for David and his men in the hill country, near a place called the rocks of the wild goats. ");
INSERT INTO engPEV_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","There were yards for sheep and goats at that place, near a cave. David and his men were in that place before Saul and his men got there, and David’s mob went into the cave to hide. Later on, Saul and his men came, and Saul went into the cave by himself to go to the toilet. But David and his men were already in that cave, right at the back. The cave was very big, so Saul did not see them. ");
INSERT INTO engPEV_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","David’s men said to him, “You remember that God said this, ‘I will help you to beat your enemy that does wrong to you. You can do whatever you like to him.’ So you can kill him dead now.” David went quietly up behind Saul and cut off a little bit of his coat with his knife. Saul just sat there. He did not know what David was doing. ");
INSERT INTO engPEV_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","But after he cut off that bit of Saul’s coat, David felt really shamed about it. ");
INSERT INTO engPEV_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","He said to his men, “God picked Saul to be the big boss of Israel, so I can’t do wrong to him. I can’t touch him, no way.” ");
INSERT INTO engPEV_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","In that way, David told them not to hurt Saul. Soon after that, Saul stood up and went out of the cave. ");
INSERT INTO engPEV_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","David waited a few minutes, then he went out too. He called out to Saul, “Hey boss.” Saul looked back over his shoulder. David got down on his knees, to show him respect. ");
INSERT INTO engPEV_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","David said, “Some men reckon that I want to hurt you. Don’t listen to them. ");
INSERT INTO engPEV_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","Just now God brought us together in this cave. I could do whatever I liked to you. Some said to me, ‘You can kill him dead now.’ But I was sorry for you. I said, ‘No, I can’t kill my boss. God picked him, to be the big boss of Israel.’ ");
INSERT INTO engPEV_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","Look at this, boss. I’m holding a little bit of your coat. I cut it off just then, when you were in the cave, but I did not kill you. This shows that I am not trying to do any wrong to you. I can’t make myself the big boss instead of you. But you keep on looking for me, to kill me. ");
INSERT INTO engPEV_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","One day, God will judge you and me. If you do wrong to me, he will punish you. But I can’t kill you. No way. ");
INSERT INTO engPEV_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","You know what people often say, ‘Only bad people do bad things.’ I do not want to be a bad person, so I will not touch you.” ");
INSERT INTO engPEV_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","After David said that, Saul asked him, “Is that really you, my son David?” And he cried out loud. ");
INSERT INTO engPEV_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","He said to David, “You are a good man, I am not. You are good to me, but I am giving you a hard time. ");
INSERT INTO engPEV_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","And now you have just told me that you feel sorry for me. God brought us together in the cave, but still you did not kill me. ");
INSERT INTO engPEV_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","Whenever a soldier finds his enemy, he can’t let him go. He never does that. But you are not like that. You are good to me. You did good to me today, so God will do good to you. ");
INSERT INTO engPEV_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","I know that one day you will be the big boss of Israel. ");
INSERT INTO engPEV_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","So promise me right now, with God listening, that you will not kill my family dead after you become the big boss. And after you become the big boss, keep on being good to them, so that my family will not finish up.” ");
INSERT INTO engPEV_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","David promised to do what Saul asked. Then Saul went back home. But David went back with his men to the hill country, and they stayed in a safe place. ");
INSERT INTO engPEV_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","About that time the old man Samuel died. The Israel mob came together and cried for him. They buried him at his place in the town called Ramah. After that, David and his men went back to the desert country called Maon. ");
INSERT INTO engPEV_vpl VALUES ("S125_2","010_25_2","1SA","25","2","3","There was a man there called Nabal. He belonged to Caleb’s family. His farm was near the town called Carmel, in that Maon country. He had lots of money, 3,000 sheep and 1,000 goats. He was a hard man and a cheeky man. His wife was called Abigail. She was very beautiful and very clever. One day, Nabal started to cut wool from the sheep. They always used to have a party after they finished that job. ");
INSERT INTO engPEV_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","David was in the desert country nearby, and he heard about it. ");
INSERT INTO engPEV_vpl VALUES ("S125_5","010_25_5","1SA","25","5","5","So he told 10 young men, “Go to Carmel and see that man Nabal. Say to him, ‘Our boss David says to say hello to you. ");
INSERT INTO engPEV_vpl VALUES ("S125_6","010_25_6","1SA","25","6","6","God will look after you and your family and your animals. ");
INSERT INTO engPEV_vpl VALUES ("S125_7","010_25_7","1SA","25","7","7","I heard that you are now cutting wool from your sheep. You know, whenever we camped with your work-men that look after your sheep in the bush, we always looked after them carefully and did not steal from them. Other soldiers are thieves. But we are good to other people, and we don’t think about stealing. ");
INSERT INTO engPEV_vpl VALUES ("S125_8","010_25_8","1SA","25","8","8","You can ask your workers. They will tell you the same story. It is like we are your working men too, so please be good to us. I also heard that it is party time at your place. But think about us too. Can you give us some food?’” ");
INSERT INTO engPEV_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","The young men went to Nabal’s place and told him David’s message. But at first Nabal did not answer. ");
INSERT INTO engPEV_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","Then he asked them, “Who does this man David think he is? That son of Jesse is just like other workers that run away from their bosses. ");
INSERT INTO engPEV_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","I only give bread, meat and water to my own workers. I can’t just give it to some other mob. I don’t know where they came from.” ");
INSERT INTO engPEV_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","So they went back to tell David what Nabal said. ");
INSERT INTO engPEV_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","Then David said to his men, “Get your long knives, you mob. We will go and fight him.” They got their long knives and put them in their belts, and David got his long knife as well. He went off with 400 of his men. His 200 other men stayed behind to watch the camp. ");
INSERT INTO engPEV_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","One of Nabal’s workers heard what Nabal said to David’s men, and he ran to tell Abigail, Nabal’s wife. He told her, “David sent messengers from the desert country to talk to our boss. But he talked badly to them. ");
INSERT INTO engPEV_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","Truly David’s mob were good to us, while we looked after the sheep. They did not steal from us. ");
INSERT INTO engPEV_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","Day and night they watched over us whenever we looked after the sheep. ");
INSERT INTO engPEV_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","This boss of ours has made trouble for us now. Something really bad might happen to us here. Can you do something about it? He’s no good. I can’t talk to him at all.” ");
INSERT INTO engPEV_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","Abigail did not wait. She quickly gathered all kinds of things together. She got 200 loaves of bread, and 2 leather bags that were full of wine, and 5 cooked sheep, and 5 bags of cooked seeds, and lots of fruit like bush tomato, and lots of fruit like bush figs. And she put all this food on some donkeys. ");
INSERT INTO engPEV_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","She said to her workers, “You mob go ahead. I will follow behind you.” She did not say anything to her husband about it. ");
INSERT INTO engPEV_vpl VALUES ("S125_20","010_25_20","1SA","25","20","22","So Abigail went off on a donkey. You see, David talked to himself like this, as he went along, “I looked after Nabal’s men and his sheep in the desert country just for nothing. I didn’t take anything that belonged to him. I was good to him, but he talked badly about me. Tonight, while it is still dark, I will kill all the men and boys at his place. If I do not do that, I will ask God to make big trouble for me.” That’s the way David talked. As Abigail went along on her donkey, she went through a gap in the hills. She saw David as he came with his men. ");
INSERT INTO engPEV_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","As soon as she saw him, she quickly jumped off the donkey and got down on her knees to show respect to him, her face close to the ground. ");
INSERT INTO engPEV_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","She said, “Boss. Please wait and listen to me now. Be angry with me, not Nabal. Forget him. ");
INSERT INTO engPEV_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","Do not listen to that no good man. That name Nabal means stupid one. He’s always like that. You see, I was not there, at the time your workers came to our place. ");
INSERT INTO engPEV_vpl VALUES ("S125_26","010_25_26","1SA","25","26","27","But now I have brought all kinds of food for you and your men to eat. So don’t be angry with us now. I know for sure that it is God that stopped you here, so that you did not kill lots of people dead. And I want God to kill anybody that does wrong to you, just like I reckon he will kill Nabal one day. ");
INSERT INTO engPEV_vpl VALUES ("S125_28","010_25_28","1SA","25","28","28","So please let us go, even though my husband did wrong to you. I know that God will make you the big boss of all of us Israel mob. And later, after you die, your family will keep on being our bosses. I know that you fight against the people that God wants to fight. I hope you will keep on living straight always, for the rest of your life. ");
INSERT INTO engPEV_vpl VALUES ("S125_29","010_25_29","1SA","25","29","29","If other people chase you, to kill you, God will look after you and will keep you safe. You are his special one. He will soon finish up those other people. ");
INSERT INTO engPEV_vpl VALUES ("S125_30","010_25_30","1SA","25","30","30","After he does that, you will be boss in Israel, the way he promised before. ");
INSERT INTO engPEV_vpl VALUES ("S125_31","010_25_31","1SA","25","31","31","So here today do not do payback to us. Do not kill us just for nothing. If you kill us, you will bring big shame on yourself. If you kill people now that are not guilty, it will be a problem for you later. But if you don’t kill us, that will be good. I know that God will make you the big boss one day. At that time, please do not forget me, but be good to me.” That’s the story Abigail told David. ");
INSERT INTO engPEV_vpl VALUES ("S125_32","010_25_32","1SA","25","32","32","Then David settled down and said to Abigail, “I reckon God is really great. He sent you to meet me here. ");
INSERT INTO engPEV_vpl VALUES ("S125_33","010_25_33","1SA","25","33","33","You thought carefully about it, then you came and met me here. So now I ask God to be good to you. Yes, I came to fight, but you stopped me, so I didn’t kill lots of people dead. ");
INSERT INTO engPEV_vpl VALUES ("S125_34","010_25_34","1SA","25","34","34","God knows that this is true. He stopped me, or I might have killed you mob dead. Every man and boy in this place might have died before tomorrow morning. But you came quickly to meet me and stop me.” ");
INSERT INTO engPEV_vpl VALUES ("S125_35","010_25_35","1SA","25","35","35","And David thanked her, and he told his men to get all the food from Abigail. And he said to her, “All right. You can go home now. I have heard you, and I will do what you are asking me.” ");
INSERT INTO engPEV_vpl VALUES ("S125_36","010_25_36","1SA","25","36","36","While Abigail was away, other people came together at their house, to have a big party with her husband. Nabal was happy, and he got very drunk. After Abigail got back, she did not tell him about David. ");
INSERT INTO engPEV_vpl VALUES ("S125_37","010_25_37","1SA","25","37","37","In the morning Nabal was sober, so Abigail told him about David. As soon as he heard he was so shocked that he had a stroke. He became just like a stone and couldn’t move. ");
INSERT INTO engPEV_vpl VALUES ("S125_38","010_25_38","1SA","25","38","38","After 10 days, God hit him properly, and he died. ");
INSERT INTO engPEV_vpl VALUES ("S125_39","010_25_39","1SA","25","39","40","As soon as David heard that Nabal was dead, he said, “Praise God. That old man talked badly to me. He talked very badly, so God finished him properly. God also stopped me so that I didn’t do wrong.” So David sent messengers to Carmel, and they went and said to Abigail, “David sent us. He wants you to come with us, to marry him.” ");
INSERT INTO engPEV_vpl VALUES ("S125_41","010_25_41","1SA","25","41","41","She got down on her knees to show respect, her face close to the ground, and she said, “Yes, I will go. I am happy to work for him and his men, and I will even wash their feet too.” ");
INSERT INTO engPEV_vpl VALUES ("S125_42","010_25_42","1SA","25","42","42","She quickly got on a donkey and went off. 5 working women also went with her. They all went to David’s camp. And then David and Abigail got married. ");
INSERT INTO engPEV_vpl VALUES ("S125_43","010_25_43","1SA","25","43","44","You see, David’s first wife was Saul’s daughter, Mihal. But Saul took her away and gave her to another man called Paltiel. His father’s name was Layish, and he came from a place called Gallim. After that, David got another wife called Ahinoam. She came from a place called Jezreel. So Abigail and Ahinoam, they were both his wives. ");
INSERT INTO engPEV_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","One day, some men from a place called Zif went to see Saul at his place at Gibeah. They said, “David’s mob are hiding in a cave at the hill called Hakilah near Jeshimon town.” ");
INSERT INTO engPEV_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","Saul quickly gathered together 3,000 of his best soldiers from Israel. They went off to look for David in the desert called Zif. ");
INSERT INTO engPEV_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","They camped in the hill country beside the road. David’s mob stayed in the bush. After he heard that Saul was at Hakilah, ");
INSERT INTO engPEV_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","he sent some men to have a look. They saw that Saul’s mob really was there, so they came back and told David. ");
INSERT INTO engPEV_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","That night David went close to Saul’s camp. From his hiding place he saw Saul and the boss soldier Abner, Ner’s son. They slept in the middle. The other soldiers all slept around them. ");
INSERT INTO engPEV_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","There were 2 men with David. They were Ahimelek, the man who used to belong to the Heth mob, and Abishai, Zeruiah’s son. Zeruiah was David’s older sister. Her other son was Joab. David said to them, “I am going to go quietly into the middle of their camp, to where Saul is. Which of you 2 will do that with me?” Abishai said, “I’ll go with you.” ");
INSERT INTO engPEV_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","So in the middle of the night, David and Abishai went quietly into Saul’s camp. Everybody was asleep. They found Saul asleep in the middle of the camp. His spear stood there, stuck in the ground near his head. Other soldiers lay asleep nearby. One of them was Abner, the boss of Saul’s soldiers. ");
INSERT INTO engPEV_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","Abishai said, “Boss. Look at this. God wants you to kill that old man. He did wrong to you. I will stab him right through with his spear. I’ll only stab him one time. I’ll use that spear like it is a big pin, and I’ll pin him to the ground, and he will die straight away.” ");
INSERT INTO engPEV_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","But David answered, “You can’t kill him. God will punish you. He picked Saul to be our big boss. ");
INSERT INTO engPEV_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","Some time God himself will finish him up, maybe through sickness, maybe through fighting. ");
INSERT INTO engPEV_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","But not us. We can’t kill him. God does not want me to kill this man that he picked. Let’s just take his spear, and that billycan of water that is near his head, and we will go back.” ");
INSERT INTO engPEV_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","So David took the spear and the billycan, and they went away quietly. Nobody saw them. God made everybody sleep properly, so nobody woke up. ");
INSERT INTO engPEV_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","Then they went across to the other side of the valley and stood on the top of a hill a long way away. ");
INSERT INTO engPEV_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","David called out to Abner, “Hey, Abner. Can you hear me?” He answered, “Who’s that calling out? Who’s waking up the big boss?” ");
INSERT INTO engPEV_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","David made fun of him, and he said, “Abner, what kind of man are you? You call yourself a big boss soldier, greater than all the other soldiers. But you don’t look after your boss. Just now somebody went into your camp and nearly killed him dead. ");
INSERT INTO engPEV_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","You are a boss soldier for nothing. God should kill you, and your soldiers too. You mob don’t look after the big boss, the one God picked. Look there. Where’s the big boss’s spear? Where’s his billycan? I’ve got those 2 things here.” ");
INSERT INTO engPEV_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","Saul heard David’s voice, and said, “David, my son. Is that you talking?” David answered, “Yes, boss. It’s me. ");
INSERT INTO engPEV_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","Why do you always chase me? I did not do anything wrong. Why do you blame me? ");
INSERT INTO engPEV_vpl VALUES ("S126_19","010_26_19","1SA","26","19","19","Listen carefully to me. Did God tell you to hate me? If yes, then I have to burn meat to give to him, so he will change his mind. But maybe it was some other men that told you to hate me? They hunted me away from my people, so God has to punish them. They don’t let me live in my country. I’m like a stranger. I have to live in another country now. The people there follow other gods. I can’t live for God properly. ");
INSERT INTO engPEV_vpl VALUES ("S126_20","010_26_20","1SA","26","20","20","This place is a long way from God. I do not want to die here. I’m just nobody, not a boss man. Why do you keep on looking for me? You keep on chasing me like you are hunting for meat.” ");
INSERT INTO engPEV_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","Saul said, “I did the wrong thing. You are good to me. I can’t do wrong to you again. You didn’t kill me, but I truly did wrong. I was a stupid fool. You are like my son. Come back to me.” ");
INSERT INTO engPEV_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","David said, “Your spear is here. Send a man to come and get it. ");
INSERT INTO engPEV_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","Just now God brought us together, and I did not kill you. He picked you to be boss, so I will not kill you. God is good to people that listen to him. He is good to people that live straight. ");
INSERT INTO engPEV_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","That’s why I want him to be good to me. I want him to keep me alive, just like I was good to you today, and did not kill you.” ");
INSERT INTO engPEV_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","Then Saul said, “Truly God will be good to you. You will do great things for him. Whatever you do will work out well.” Then David left that place, and Saul went back home. ");
INSERT INTO engPEV_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","A long time before this, Saul stopped the clever men and women from talking to the spirits of dead people, and he hunted them away from Israel. You see, that is in God’s law. When the old man Samuel died, the Israel mob all cried for him, and they buried him in his own town, called Ramah. ");
INSERT INTO engPEV_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","Some time later, the Philistia mob came together at a place called Shunem to fight with the Israel mob. Saul gathered his soldiers together at another place called Gilboa, not far from Shunem. ");
INSERT INTO engPEV_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","As soon as he saw the Philistia mob, he was really frightened and confused. ");
INSERT INTO engPEV_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","He prayed to God, but God did not answer him. God didn’t talk to Saul in dreams, and nobody came to bring him a word from God. Nothing. So he got the special stone that they used to find out what God wanted, and he threw it down, to see if it lay on its back or on its side. But still God did not show him anything. ");
INSERT INTO engPEV_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","So Saul said to his men, “Go and look for a clever woman, one that can talk to dead people’s spirits. I want her to ask Samuel for me. He might give me an answer.” They said to him, “There’s one at that place called Endor.” ");
INSERT INTO engPEV_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","So Saul put on some working man’s clothes to make himself look different. Then, at night, he went with 2 of his men to look for that woman. He found her and said, “Will you talk to a dead man for me? I will call the dead man’s name, and you get him for me.” ");
INSERT INTO engPEV_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","But the woman said, “I can’t do that. You know, Saul hunted the clever men and women away from Israel. You are making trouble for me. If I do this for you, Saul might send people to kill me dead.” ");
INSERT INTO engPEV_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","Saul answered, “God is listening, so I tell you straight. Nobody can kill you or do payback to you.” ");
INSERT INTO engPEV_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","The woman answered, “All right, who do you want me to get for you?” Saul said, “That old man Samuel. Get him for me.” ");
INSERT INTO engPEV_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","Then she talked to Samuel’s spirit, and he came to her. As soon as she saw him, she was frightened and yelled at Saul, “You tricked me. You are Saul.” ");
INSERT INTO engPEV_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","Saul said, “It’s all right. Don’t be frightened. What can you see?” She said, “I can see a spirit coming out of the ground here.” ");
INSERT INTO engPEV_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","Saul asked, “What does it look like?” She said, “It’s an old man wearing long clothes.” Saul knew it was Samuel, and he got down on his knees and put his face near the ground to show respect to that spirit. ");
INSERT INTO engPEV_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","Samuel said, “I was dead. Why did you wake me up? Why did you bring me back?” Saul stood up and answered, “Things are really bad for me now. The Philistia mob will try to kill me dead. God turned away from me, and he doesn’t answer me. He doesn’t talk to me through a man, or a dream. Nothing. That’s why I’m here now, to ask you what I have to do.” ");
INSERT INTO engPEV_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","Samuel said, “Yes, God turned away from you. He is your enemy now. Why do you ask me to help you? ");
INSERT INTO engPEV_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","While I was alive, he told me the story about you. And I told it to you. Now it’s come true. You are not the big boss of Israel any more. God has already picked David to be the big boss instead of you. ");
INSERT INTO engPEV_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","You did not listen to God, so he did that. He was angry with the Amalek mob, so he told you to finish all of them up, and their animals too. He told you what to do, but you didn’t do it. ");
INSERT INTO engPEV_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","So now the Philistia mob will kill you and your soldiers. Tomorrow God will let them beat you mob. They will kill you and your sons dead. You will all come to sit with me, here, with all the dead people.” ");
INSERT INTO engPEV_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","You see, from early that day Saul didn’t eat any food, and he ate nothing all that night too. So he was weak. And as soon as he heard Samuel’s words, he got very frightened. He was so weak that he fell to the ground. ");
INSERT INTO engPEV_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","The woman saw Saul on the ground. He was shaking, and she said, “Look. I listened to you. I was afraid you might kill me, but I did like you asked. ");
INSERT INTO engPEV_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","Now you have to listen to me. Let me give you some food to make you strong again, so you can go back home.” ");
INSERT INTO engPEV_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","But he said, “No. I can’t eat.” Then his 2 men said the same thing, “Boss, you have to eat some food.” He listened to them and got up and sat on a chair. ");
INSERT INTO engPEV_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","There was a fat young cow at that place. It belonged to the woman, and she quickly killed it. While the meat was cooking, she got some flour and cooked a flat damper. ");
INSERT INTO engPEV_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","She gave food to Saul and the other 2 men. After they ate it, they went back to their camp, while it was still dark. ");
INSERT INTO engPEV_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","After that, the Philistia mob fought with the Israel mob. They fought on the hill called Gilboa. Lots of Israel soldiers died there, and the other soldiers got frightened and ran away. ");
INSERT INTO engPEV_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","The Philistia mob chased Saul and his sons, and they got closer and closer. Then they killed dead Saul’s sons, Jonathan, Abinadab and Malkishua. ");
INSERT INTO engPEV_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","The soldiers that were close to Saul fought hard. The Philistia mob shot Saul lots of times with bows and arrows, and they hurt him very badly. ");
INSERT INTO engPEV_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","Saul talked to one of the soldiers there, the one that carried his shield for him. He said, “Get your long knife and stab me. I don’t want that mob to kill me dead. They don’t know God. They might make fun of me as they kill me.” The soldier was frightened and did not want to stab him. So Saul got the knife and stabbed himself in his belly and killed himself. ");
INSERT INTO engPEV_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Then that soldier saw that his boss was dead, so he stabbed himself and died too. ");
INSERT INTO engPEV_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","That’s how Saul died, and his sons, and the man that carried his shield, and his soldiers. They all died on that day. ");
INSERT INTO engPEV_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","The people that saw what happened told this bad news to everybody along the Jezreel Valley and across the Jordan River. The Israel mob in all those places heard it, and they ran away frightened. They left their towns empty, and the Philistia mob went and lived in those towns. ");
INSERT INTO engPEV_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","The next day, the Philistia mob went back up the hill at Gilboa to get stuff from the dead bodies. They saw the dead bodies of Saul and his 3 sons there. ");
INSERT INTO engPEV_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","They cut off Saul’s head and took off his heavy iron plates. Then they sent messengers to every place in Philistia, to tell the story to the people and in the houses of their gods. ");
INSERT INTO engPEV_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","They put Saul’s iron plates in one of those houses, the house of the female god called Astarti. At Beth-Shan they hung Saul’s dead body on the wall that was around the town. ");
INSERT INTO engPEV_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","The people from another place called Jabesh, in the Gilead country, they heard the bad news too. They remembered that Saul helped them before. They were very upset about the bad things the Philistia mob did to Saul. ");
INSERT INTO engPEV_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","So that night lots of brave men from Jabesh walked all night to Beth-Shan. They took down the bodies of Saul and his sons from the wall, and they carried them back to Jabesh. They burned the bodies ");
INSERT INTO engPEV_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","and buried the bones under the big tree there. For the next 7 days they ate no food. They just sat sadly together and felt sorry for Saul. ");
INSERT INTO engPEV_vpl VALUES ("S21_1","011_1_1","2SA","1","1","1","The Philistia mob and the Israel mob fought each other on the hill called Gilboa. Saul died at that place. At the same time, David and his men fought the Amalek mob at another place. After they beat the Amalek mob, David and his men went back to the place called Ziklag. ");
INSERT INTO engPEV_vpl VALUES ("S21_2","011_1_2","2SA","1","2","2","Then, 2 days later, a young man arrived at David’s camp. He came from the place where Saul’s mob had that big fight. Along the road he tore his clothes and put dirt on his head, to show that he had bad news. Then he came to David, got down on his knees with his face close to the ground, to show respect to him. ");
INSERT INTO engPEV_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","David asked, “Where did you come from?” He answered, “I ran away from that hill called Gilboa, from that big fight.” ");
INSERT INTO engPEV_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","David asked him, “What happened in that fight? Tell me.” He answered, “The Philistia mob killed dead lots of our soldiers, and our other soldiers ran away. Saul and his son Jonathan died too.” ");
INSERT INTO engPEV_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","David and his mob were really sad for Saul and Jonathan. They tore their clothes to show they were upset. ");
INSERT INTO engPEV_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","They cried until the sun went down, and they didn’t eat anything. Lots of God’s people died, so they were sad for them too, their countrymen, the Israel mob. ");
INSERT INTO engPEV_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","After that, David asked God, “What do I do now? Maybe I have to go back and stay at some place in Judah country?” God answered, “Yes, go.” David asked, “Which place?” God said, “To the town called Hebron.” ");
INSERT INTO engPEV_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","So David went and lived in that place. His 2 wives went with him. Their names were Ahinoam, from Jezreel, and Abigail, from Carmel. Abigail was the widow of that stupid old man, Nabal. ");
INSERT INTO engPEV_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","David’s workers also went back to Judah, and they took their children with them. Some went to Hebron. Other workers went to other places close by. ");
INSERT INTO engPEV_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","Then the Judah tribe came together at Hebron to make David their boss. They poured olive oil on his head. That was their way of showing everybody that he was their boss. ");
INSERT INTO engPEV_vpl VALUES ("S22_8","011_2_8","2SA","2","8","8","At that same time Abner got up. He was Ner’s son, and he used to be the boss of Saul’s soldiers. He got up and went to a man called Ishbosheth. He was one of Saul’s sons. Abner took him to a place called Mahanayim, ");
INSERT INTO engPEV_vpl VALUES ("S22_9","011_2_9","2SA","2","9","9","and made him boss of all the other tribes of the Israel nation. So he was boss for the Gilead mob, and for the Asher mob, and for the Jezreel mob, and for the Ephraim mob, and for the Benjamin mob. ");
INSERT INTO engPEV_vpl VALUES ("S22_10","011_2_10","2SA","2","10","10","Ishbosheth was 40 years old at the time he became boss over those Israel tribes, and he was their boss for 2 years. But the Judah tribe made David their boss. ");
INSERT INTO engPEV_vpl VALUES ("S22_11","011_2_11","2SA","2","11","11","David was boss for 7 years and 6 months in Hebron town. ");
INSERT INTO engPEV_vpl VALUES ("S23_1","011_3_1","2SA","3","1","1","Saul’s mob and David’s mob kept on fighting each other for a long time. More and more men joined David’s mob, and only a few men stayed in Saul’s mob. ");
INSERT INTO engPEV_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","At first David was boss only for the Judah tribe. But one day all the other Israel tribes came together at Hebron and said to David, “You are family for us. ");
INSERT INTO engPEV_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","While Saul was the big boss of all of us in Israel, you were boss of all the soldiers. At that time, God told you, ‘One day, you will be the big boss, and you will look after my people, the Israel mob, like a shepherd looks after his sheep.’” ");
INSERT INTO engPEV_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","So the elders told that story to David in Hebron. Then he said, “Yes, I agree to be the big boss of everybody. I say that while God is listening.” Then the elders poured olive oil on his head to show that he was the big boss for all the Israel mob. ");
INSERT INTO engPEV_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","David was 30 years old when they picked him to be the big boss. And he was boss for a long time, for 40 years. ");
INSERT INTO engPEV_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","You see, David was boss for the Judah tribe first. That was for 7½ years, and he lived at that place called Hebron. After that, he became the big boss for the other Israel tribes too, and he lived in the city called Jerusalem. ");
INSERT INTO engPEV_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","After David became the big boss, God kept his enemies away from Israel. So he sat down happily in his big house in Jerusalem. ");
INSERT INTO engPEV_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","There was a man called Nathan. He told God’s messages to people. One day, David said to him, “Listen, I live here in this big fancy house, but God’s special box still lives in a tent. I want to build a proper house for that special box.” ");
INSERT INTO engPEV_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Nathan said, “God is looking after you. You can do anything you want to do.” ");
INSERT INTO engPEV_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","But that night God gave Nathan a dream and told him a different story. ");
INSERT INTO engPEV_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","He told him to say this to David, “David, you are my working man. Listen to me. I want you to leave it. Don’t build a house for me. And don’t build a house for that special box. ");
INSERT INTO engPEV_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","I led the Israel mob to walk away from Egypt and to come back to this country. All that time I didn’t live in a house. Today I still don’t live in a house. I still go from place to place, and I still live in a tent. ");
INSERT INTO engPEV_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","I picked bosses for the Israel mob, to look after them. I didn’t say to any of those bosses, ‘Build me a nice house.’ I never said that. ");
INSERT INTO engPEV_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","So, listen carefully to me. At first you just looked after sheep. Then I picked you to look after my mob, the Israel nation. I picked you to be the big boss for them. ");
INSERT INTO engPEV_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","I was always close to you whenever you did all kinds of important things. I helped you to hunt away the cheeky people that came here from other places. And now I will make you really important. Everybody in every place will hear about you and remember your name, and they will say you are great. ");
INSERT INTO engPEV_vpl VALUES ("S27_10","011_7_10","2SA","7","10","11","For a long time I picked judges and other bosses for my people, the Israel mob. Other mobs kept on giving them trouble, and they fought with the Israel mob. But from now on, I will look after my mob here in this country. This country belongs to Israel now. They can sit down here and live quietly, and not be frightened any more. Those other mobs will leave them alone. Listen, I am telling you this, so you will know. I will make your family important. And I will keep on making your family important. ");
INSERT INTO engPEV_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","One day you will die, and then I will pick one of your sons to be the big boss, and I will make him strong. He will be a strong boss for his people for a long time. ");
INSERT INTO engPEV_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","Nobody can stop him from being the big boss of this country. And then his son will be the big boss, and later his son’s son will be the big boss. It will be like that for ever. The big boss will always be a son from your family. Your son is the right one to build a house for me, not you. ");
INSERT INTO engPEV_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","I will be like his father, and he will be like my son. If he does wrong, I will send somebody to punish him, the way men punish people. But I will keep on looking after him, and I will keep on teaching him, just like a father does. ");
INSERT INTO engPEV_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","You see, I loved Saul at first. But after a while I didn’t love him any more. So I picked you to be the big boss instead of him. But I will treat you better than Saul. I will keep on loving your son always, for as long as he will be the big boss. ");
INSERT INTO engPEV_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","Your family line will stay for ever. One of them will always be the big boss.” That’s the story God told Nathan in a dream. ");
INSERT INTO engPEV_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Then Nathan told David everything that God said. ");
INSERT INTO engPEV_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","At that time, long ago, the big bosses of those nations used to wait for the end of the cold weather to finish every year, then they used to get their soldiers together, and the big bosses went with their soldiers to fight with other nations. That was their way. One year, at that time, David told his boss soldier Joab, “Gather the soldiers from Israel together. Go again to fight with the Ammon mob.” So they went, and they met up with the soldiers from Ammon, and they beat them properly. Then they went to the town called Rabbah in Ammon country and stood in a circle around it. The Rabbah people couldn’t get out of their town, because the Israel soldiers blocked the gates. But David didn’t go with his soldiers to that town. He stayed home, in Jerusalem. ");
INSERT INTO engPEV_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","One day, in the late afternoon, David woke up from a sleep, and he went up and stood on the flat roof of his house. As he looked down at the other houses, he saw a woman. She was having a bath, and she was very pretty. ");
INSERT INTO engPEV_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","He sent a messenger to ask, “Who is this woman?” The messenger came back and told him, “She is Bathsheba, Eliam’s daughter. Her husband is Uriah, who belongs to the Heth mob.” ");
INSERT INTO engPEV_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","He was an Israel soldier, and he was fighting at Rabbah. So David sent messengers to get Bathsheba and bring her to him. You see, she just finished her washing ceremony, the one that women used to do to clean themselves every month. So Bathsheba did what David told her to do. She went to him, and he slept with her, as a man does with his wife. Then she went back to her home. ");
INSERT INTO engPEV_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Some weeks later, that woman knew that she was going to have a baby. So she sent a message to tell David, “I’m going to have your baby.” ");
INSERT INTO engPEV_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","David heard her message, and then he sent a message to the boss soldier Joab. He was with the army, fighting at Rabbah. David told him, “Send Uriah to me.” So Joab sent Uriah back to Jerusalem. ");
INSERT INTO engPEV_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","Uriah came, and David said, “Hello, Uriah. Tell me, how’s Joab? Is he all right? Are the soldiers from Israel all right? Are they fighting hard with the Ammon mob?” Uriah answered his questions. ");
INSERT INTO engPEV_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","Then David said to him, “You can go home to your wife. Have a wash and a rest. Go back to Joab tomorrow.” You see, David wanted people to think that the baby was Uriah’s. As Uriah left the big house, David sent a working man with some fresh meat for Uriah and his wife to eat. ");
INSERT INTO engPEV_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","But Uriah didn’t go back to sleep at his own house. He went and slept outside, where David’s working men used to sleep. ");
INSERT INTO engPEV_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","The next day, one working man told David, “Uriah did not go and sleep at his own house.” David said, “Go and get him.” Uriah came, and David asked him, “Why didn’t you go home and have a rest? You need a break from the fighting.” ");
INSERT INTO engPEV_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","He answered, “I can’t go back to my house. There are big mobs of our soldiers still over there, fighting the Ammon mob. The big boss soldier Joab, and the other boss soldiers, and all the other soldiers from Judah and from all of Israel, they are all camped out in the dry country. God’s special box is there too. I can’t go back to my house. I can’t go and eat meat and drink wine. I can’t go back and sleep with my wife. I’m telling you straight, with God listening, I can’t do that.” ");
INSERT INTO engPEV_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","David said to him, “All right. You can stay with me. I’ll send you back tomorrow.” So Uriah stayed 2 nights in Jerusalem. ");
INSERT INTO engPEV_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","David gave him lots of food and wine to make him confused. He kept on saying, “Drink some more of this.” So Uriah got properly drunk. But still he didn’t go home to his wife. He went and slept outside with the working men, like before. ");
INSERT INTO engPEV_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","The next morning, David heard the same story. So he wrote a letter to Joab. He gave it to Uriah, and he said, “Give this letter to your boss, Joab.” So Uriah took the paper with him, but he didn’t know what it said. ");
INSERT INTO engPEV_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","That message said this, “Send Uriah to the really hard fighting, close to the Ammon mob. Tell the other soldiers to stand back away from him and leave him alone. Then the enemy will kill him dead.” ");
INSERT INTO engPEV_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","You see, the Israel soldiers were still at that same place, there at Rabbah. They still stood in a circle around the town. Joab knew that the best Ammon soldiers were in one place, so he sent Uriah and some other soldiers there, to shoot arrows at them from close to the wall of the town. ");
INSERT INTO engPEV_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","But those Ammon soldiers suddenly came out from behind the wall and killed dead some Israel soldiers. And they killed Uriah dead too. ");
INSERT INTO engPEV_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","Joab sent a messenger to tell David about the fighting at Rabbah. ");
INSERT INTO engPEV_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","He told the messenger, “After you tell the big boss all about the fighting, ");
INSERT INTO engPEV_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","he might think that those soldiers died for nothing. He might get angry. He might ask you, ‘Why did you mob go close to the wall? You knew that the Ammon mob will shoot arrows at you from the wall. ");
INSERT INTO engPEV_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","Maybe you forgot that story about Abimelek, Gideon’s son. One time, he fought against the people of the town called Thebez. A woman threw a big stone from the top of the wall, and it hit him, and he died. So why did you mob get so close to that wall?’ If the big boss asks you that, you can tell him this, ‘Uriah died too.’” ");
INSERT INTO engPEV_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","So the messenger went to Jerusalem. After he got there, he told David the story. ");
INSERT INTO engPEV_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","This is what he said, “The Ammon mob came out from that town, Rabbah, to fight with us. We chased them back into their town. ");
INSERT INTO engPEV_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","Then their soldiers on the wall of the town shot arrows at us from close up. They killed dead some of your soldiers. One of them was Uriah, he is dead too.” ");
INSERT INTO engPEV_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","David heard it and said, “Go back and say this to Joab, ‘Don’t be upset about this. Fighting a war is like that. Some die, some stay alive. Keep going. Keep attacking the town. Knock all the houses down.’ Tell Joab that message, so he will not get upset.” ");
INSERT INTO engPEV_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","Uriah’s wife, Bathsheba, heard the bad news that her husband was dead, and she cried for him. ");
INSERT INTO engPEV_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","She cried for him for 7 days, as that Israel mob used to do. After she finished crying for him, David sent a messenger to bring her to his house, and David married her. Later she had a little boy. But God saw everything. He was not happy about what David did. ");
INSERT INTO engPEV_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","God talked to Nathan, the man that told God’s message to people. God said, “Go to David and tell him this story, ‘2 men lived in the same town. One was very rich and had all kinds of things. But the other one was very poor. He had nothing. ");
INSERT INTO engPEV_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","The rich man had big mobs of sheep, goats, cows and bulls, ");
INSERT INTO engPEV_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","but the poor man had only one little girl sheep. He paid money for it. He grew it up in his own house, just like one of his kids. It ate food from his plate and drank water from his cup. It slept on his lap like it was his own kid. ");
INSERT INTO engPEV_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","One day, a friend of the rich man came from another place, and he stayed at the rich man’s house. The rich man wanted to cook meat for his friend, but he didn’t want to kill one of his own animals. He took the little sheep from the poor man instead, and he killed it and cooked its meat for his friend.’” That’s the story Nathan told to David. ");
INSERT INTO engPEV_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","David heard that story and got wild with that rich man. He said to Nathan, “I’m telling you straight, and God hears us. That rich man did wrong. Somebody has to punish him. He has to die. ");
INSERT INTO engPEV_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","He had no shame, and he did not care about the poor man. He has to give that poor man 4 little sheep, to pay for the one he took.” ");
INSERT INTO engPEV_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","Nathan said to David, “You are that rich man. This is a picture story from God, and it is about you. You took Uriah’s wife, just like that rich man took the poor man’s little sheep. You know that God picked you to be the big boss for the Israel mob. When Saul tried to kill you, God looked after you and saved you. ");
INSERT INTO engPEV_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","Then he made you the big boss, instead of Saul. God made you the big boss of all the people of Judah and all Israel. And he gave you Saul’s wives too. Maybe you think all that is not enough. All right, God can give you more. ");
INSERT INTO engPEV_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","But you didn’t take notice of God’s word. You did something that is really wrong. God says it is really bad. You took Uriah’s wife, and you killed him. Yes, you sent Uriah into the middle of the fight. You knew that the Ammon mob would kill him. So really, you murdered him to get his wife for yourself. ");
INSERT INTO engPEV_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","This bad thing you did will make big trouble for you and your family. You turned against me and didn’t listen to me. You took Uriah’s wife for yourself. So bad things will keep on happening to your family. People will kill lots of your family dead. That will go on for ever. ");
INSERT INTO engPEV_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","And now God has another story for you. One day, he will tell a man from your own family to give you big trouble. God will take away your wives and give them to that man. And that man will sleep with them as if they are his wives. Everybody will see him do that. ");
INSERT INTO engPEV_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","You did wrong in secret, but God will make sure everybody sees that man do wrong to you.” ");
INSERT INTO engPEV_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","David said to Nathan, “I’m sorry. I did wrong things. I did not listen to God.” Nathan said, “Yes, that’s true. But he will not do payback to you. He will let it go, he will not kill you dead. ");
INSERT INTO engPEV_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","But you did something very wrong against God, so your baby boy will die.” ");
INSERT INTO engPEV_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","After Nathan went home, God made David and Bathsheba’s baby boy really sick. ");
INSERT INTO engPEV_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","So David prayed to God and asked him strongly to make the baby better. David didn’t eat any food, and he slept all night on the hard floor. He didn’t sleep on a soft bed. ");
INSERT INTO engPEV_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","Some of his important working men came to see him. They tried to make him get up. They tried to make him eat some food. But nothing. He did not want to eat anything with them. ");
INSERT INTO engPEV_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","After 7 days the baby died. David’s working men were afraid to tell him the bad news. They said to each other, “While the baby was alive, we tried to talk to him, but he didn’t listen to us. We can’t tell him this bad news, or he might hurt himself.” ");
INSERT INTO engPEV_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","But David saw that his working men talked quietly to each other like that. He worked out that the baby died. So he asked them, “Is the baby dead?” They answered, “Yes.” ");
INSERT INTO engPEV_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","Then David got up from the floor and washed himself, and he rubbed himself with perfume. Then he put on some clean clothes. He went into God’s ceremony house and got down on his knees to show respect to God, and to pray. Then he went back to his own house and told his working men to bring him some food to eat. ");
INSERT INTO engPEV_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","His working men were confused. They said, “What’s going on? While the baby was alive, you lay on the floor. You cried, and you ate nothing. But after he died, you got up and ate. We don’t understand. Why didn’t you cry after he died?” ");
INSERT INTO engPEV_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","He answered, “While the baby was alive, I lay on the floor. I cried, and I ate nothing. I thought, ‘Maybe God will be sorry for me. Maybe he will make the baby better again.’ ");
INSERT INTO engPEV_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","But now he is dead. Even if I don’t eat food now, I can’t make him alive again. I know that one day I will die too, and I will go to the place where he is. But he can’t come back here to me now.” ");
INSERT INTO engPEV_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","David talked gently to his wife, Bathsheba, to make her feel better. And he slept with her, as a man sleeps with his wife. And she had another baby boy, and David named him Solomon. God loved that little boy very much. ");
INSERT INTO engPEV_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","So he told Nathan, “Go and tell them to name him Jedidiah.” That name means God loves him very much. That is why God gave him that name. ");
INSERT INTO engPEV_vpl VALUES ("S215_1","011_15_1","2SA","15","1","1","David had a grown up son. His name was Absalom. Some time after Solomon was born, Absalom reckoned that he had to be the big boss, instead of his father. So he got a special trailer and some horses to pull it, and he sat in that trailer and went around in it. Whenever he went in that trailer, he told 50 men to run along in front of it, so that he looked important. ");
INSERT INTO engPEV_vpl VALUES ("S215_2","011_15_2","2SA","15","2","2","And he used to get up early to go and stand at the town gate. People used to walk through that gate into Jerusalem whenever they went to see the big boss. You see, they used to go and ask David to help them sort out their problems. Absalom used to call out to them, “Hey, where are you from?” That person used to tell him the name of his tribe. ");
INSERT INTO engPEV_vpl VALUES ("S215_3","011_15_3","2SA","15","3","3","Then Absalom used to lie to them and say, “Listen to me. You are right. That other person did wrong to you. My father is the big boss, but he is too busy to listen to everybody. He doesn’t have working men to sort out all your problems. ");
INSERT INTO engPEV_vpl VALUES ("S215_4","011_15_4","2SA","15","4","4","I should be the judge in this country. I am fair to everybody. I will treat everybody the same way. If somebody comes to me with a problem, I will sort it out for them.” That’s what Absalom used to say to the people. ");
INSERT INTO engPEV_vpl VALUES ("S215_5","011_15_5","2SA","15","5","5","Sometimes people really did think Absalom was an important man, so they got down on their knees to show respect to him. Then Absalom shook their hands and hugged them, to get them to like him. ");
INSERT INTO engPEV_vpl VALUES ("S215_6","011_15_6","2SA","15","6","6","Absalom used to do that whenever one of the Israel mob came to talk to David, to ask for help. So that’s the way he got the Israel mob to like him. They didn’t like his father David any more. ");
INSERT INTO engPEV_vpl VALUES ("S215_7","011_15_7","2SA","15","7","8","Absalom did that for 4 years. Then he said to his father, the big boss, “Old man, while I was living at the place called Geshur in Aram country, I said to God, ‘If you will let me go to Jerusalem first, I will go to Hebron later. I will get down on my knees and show respect to you there.’ God heard me say that. So is it all right for me to go to Hebron now?” But he was lying to his father. ");
INSERT INTO engPEV_vpl VALUES ("S215_9","011_15_9","2SA","15","9","9","David answered, “All right. You can go there.” So Absalom went to Hebron. ");
INSERT INTO engPEV_vpl VALUES ("S215_10","011_15_10","2SA","15","10","10","But he sent messengers to go secretly all around their country, to tell all the Israel mob like this, “As soon as you hear the trumpets play out loud, you mob have to call out, ‘Absalom is our big boss. They have picked him to be the big boss in Hebron.’” ");
INSERT INTO engPEV_vpl VALUES ("S215_11","011_15_11","2SA","15","11","12","And he told 200 men to go with him to Hebron, to kill animals there and burn them for God. But they didn’t know that Absalom planned to make himself the big boss there. At the same time, he sent a messenger to an old man called Ahithofel, from a place called Giloh, to tell him to come. He was a wise man, and he used to help David. And so Absalom tricked lots of people and made them turn away from David. More and more people started to follow Absalom. ");
INSERT INTO engPEV_vpl VALUES ("S215_13","011_15_13","2SA","15","13","13","After that, a messenger came to David and said, “The Israel mob are following Absalom now, they are not following you.” ");
INSERT INTO engPEV_vpl VALUES ("S215_14","011_15_14","2SA","15","14","14","David got a shock. So he talked to all his workers that were with him in Jerusalem city. He said, “Quick. We have to run away from this city, or they will catch us. If we don’t hurry, Absalom’s mob will attack this city and kill everybody.” ");
INSERT INTO engPEV_vpl VALUES ("S215_15","011_15_15","2SA","15","15","15","The workers said, “Yes, boss. We will do whatever you tell us to do.” ");
INSERT INTO engPEV_vpl VALUES ("S215_16","011_15_16","2SA","15","16","16","So David went away with his mob. He told 10 of his wives to stay behind to look after his house. ");
INSERT INTO engPEV_vpl VALUES ("S215_32","011_15_32","2SA","15","32","32","David and his mob, they went to the top of the hill called Olive Trees Hill. People used to show respect to God at that place. A man called Hushai was there to join up with David’s mob. He was from the Arek mob, and he worked for David. You see, he heard about Absalom’s plan to attack Jerusalem, and he was sad for his boss. He even tore his clothes and put dirt on his head, to show he was sad. ");
INSERT INTO engPEV_vpl VALUES ("S215_33","011_15_33","2SA","15","33","33","But David said to him, “Don’t come with me. You might slow me down. ");
INSERT INTO engPEV_vpl VALUES ("S215_34","011_15_34","2SA","15","34","34","I want you to do something different for me. Go back to Jerusalem and say you want to work for my son, Absalom. Lie to him and say, ‘Boss. I want to work for you now. I used to work for your father, but now I want to work only for you.’ If you do that, it will really help me. If that old man Ahithofel tells my son something, you can tell him a different story and confuse him.” ");
INSERT INTO engPEV_vpl VALUES ("S216_5","011_16_5","2SA","16","5","5","David and his mob came close to a town called Bahurim. A man called Shimmey came out to meet them. He was one of Saul’s relatives, and his father’s name was Gera. He started to swear at David and talk curses. ");
INSERT INTO engPEV_vpl VALUES ("S216_6","011_16_6","2SA","16","6","6","And he threw stones at them. David’s soldiers and guards were standing with David, but Shimmey kept on throwing stones at all of them. ");
INSERT INTO engPEV_vpl VALUES ("S216_7","011_16_7","2SA","16","7","7","And he cursed David like this, “You are a no good trouble maker. You are a cheeky one, a murderer. You are boss for nothing. Go away. ");
INSERT INTO engPEV_vpl VALUES ("S216_8","011_16_8","2SA","16","8","8","You killed lots of Saul’s family dead, so God is making trouble for you right now. You made yourself the big boss instead of him. So God picked your son Absalom now to be the big boss instead of you. You are a murderer. Now you are in trouble yourself, and it is your own fault.” ");
INSERT INTO engPEV_vpl VALUES ("S216_9","011_16_9","2SA","16","9","9","One of David’s boss soldiers was Abishai. He was the son of Zeruiah, David’s sister. He said, “Boss. That man is no good. He can’t swear at you like that. Let me cut off his head.” ");
INSERT INTO engPEV_vpl VALUES ("S216_10","011_16_10","2SA","16","10","10","David said to Abishai, and to Abishai’s brother Joab, “Don’t do it. It’s got nothing to do with you 2. Maybe God himself told him, ‘Go and swear at David.’ If God told him to do that, nobody can stop him.” ");
INSERT INTO engPEV_vpl VALUES ("S216_15","011_16_15","2SA","16","15","15","On that same day, David’s son, Absalom, came to Jerusalem with a lot of Israel soldiers. Ahithofel, that wise old man, he was with him too. ");
INSERT INTO engPEV_vpl VALUES ("S216_16","011_16_16","2SA","16","16","16","Then David’s friend, Hushai, went to meet Absalom. He called out, “Boss Absalom, you are great. You have to be the big boss for ever.” But he told a lie. He was still working for David. ");
INSERT INTO engPEV_vpl VALUES ("S216_17","011_16_17","2SA","16","17","17","Absalom said, “You are a friend of David. You used to follow him. So how come you are not with him now?” ");
INSERT INTO engPEV_vpl VALUES ("S216_18","011_16_18","2SA","16","18","18","But Hushai lied again and said, “I can’t follow him any more. You are the big boss now. God and the Israel mob, they have picked you to be the big boss. I belong to you. ");
INSERT INTO engPEV_vpl VALUES ("S216_19","011_16_19","2SA","16","19","19","This is the best way for me now. I will work for you, just like I worked for your father.” And Absalom believed him. ");
INSERT INTO engPEV_vpl VALUES ("S216_20","011_16_20","2SA","16","20","20","So Absalom said to that wise man, Ahithofel, “All right, tell us, what do we do first?” ");
INSERT INTO engPEV_vpl VALUES ("S216_21","011_16_21","2SA","16","21","21","He answered, “10 of your father’s wives stayed behind to look after the house. You have to sleep with them, as if you are married to them. If you do that, you will make your father ashamed, and he will hate you properly. Then everybody will know that you are the big boss in his house now. Everybody will hear that you were really brave, and that you did it in the open. Then they will follow you.” ");
INSERT INTO engPEV_vpl VALUES ("S216_22","011_16_22","2SA","16","22","22","So the workers put up a tent on the flat roof of David’s big house. Absalom went into the tent and slept with his father’s wives one by one, just like he was married to them. And a lot of people saw him do that, and all the Israel mob heard about it. ");
INSERT INTO engPEV_vpl VALUES ("S216_23","011_16_23","2SA","16","23","23","So Absalom took notice of that wise man’s story, just like his father used to take notice of him. They both thought that he talked straight, just like God does. So they always listened to him carefully. ");
INSERT INTO engPEV_vpl VALUES ("S217_1","011_17_1","2SA","17","1","1","That wise man, Ahithofel, said to David’s son Absalom, “Let me pick 12,000 soldiers. We will chase your father tonight. ");
INSERT INTO engPEV_vpl VALUES ("S217_2","011_17_2","2SA","17","2","2","Right now he’s upset and tired. We will suddenly come and attack his mob, and they will get a shock. All his mob will run away. He’s the only one I will kill dead. ");
INSERT INTO engPEV_vpl VALUES ("S217_3","011_17_3","2SA","17","3","3","I will gather all the other men together and bring them back here to you. They will see that their boss is dead, and then you will be their boss. We will not hurt any of them. They will all be safe.” ");
INSERT INTO engPEV_vpl VALUES ("S217_4","011_17_4","2SA","17","4","4","Absalom and the elders of Israel agreed. They said, “This is a good plan.” ");
INSERT INTO engPEV_vpl VALUES ("S217_5","011_17_5","2SA","17","5","5","Then Absalom said, “All right, what about that man Hushai, from the Arek mob? Tell him to come here. We will listen to him too.” ");
INSERT INTO engPEV_vpl VALUES ("S217_6","011_17_6","2SA","17","6","6","Hushai came, and Absalom told him the things Ahithofel said. Then he asked Hushai, “So what do you think? Can we listen to his plan? Or maybe not? What do you reckon?” ");
INSERT INTO engPEV_vpl VALUES ("S217_7","011_17_7","2SA","17","7","7","Hushai lied and answered, “That old man usually talks straight. But not today. That plan he just told you, it’s no good. ");
INSERT INTO engPEV_vpl VALUES ("S217_8","011_17_8","2SA","17","8","8","You know that your father and his men are strong soldiers. They are good fighters, like cheeky wild animals. And he really knows what he is doing too. He always sleeps a long way from the soldiers, so he will stay safe. ");
INSERT INTO engPEV_vpl VALUES ("S217_9","011_17_9","2SA","17","9","9","Maybe he will go and hide in a cave in the hills. Nobody can find him there. But then he and his soldiers might suddenly come and attack your mob of soldiers. Lots of your men might die. Everybody will hear about it and think, ‘Hey, look out. David’s mob finished up Absalom’s mob.’ ");
INSERT INTO engPEV_vpl VALUES ("S217_10","011_17_10","2SA","17","10","10","Everybody knows that David and his men are brave and strong. If your other soldiers think he beat our mob, they will be afraid. Even the brave ones will be afraid. ");
INSERT INTO engPEV_vpl VALUES ("S217_11","011_17_11","2SA","17","11","11","No, this is what I reckon. We have to gather more soldiers together from all over this country, Israel. Gather lots of them together, too many to count. You are their big boss, so you have to lead them yourself. ");
INSERT INTO engPEV_vpl VALUES ("S217_12","011_17_12","2SA","17","12","12","Your father can’t hide from us. We will find him, and we will quickly go all around him, and then we will attack him. He and all his men will die. ");
INSERT INTO engPEV_vpl VALUES ("S217_13","011_17_13","2SA","17","13","13","If he is hiding in a town, all the Israel mob will break the wall and the houses of that town. We will get ropes, and we will drag their stones away. There will not even be a small stone left. We will do that until we find him.” ");
INSERT INTO engPEV_vpl VALUES ("S217_14","011_17_14","2SA","17","14","14","Absalom and the elders of Israel heard what Hushai said, and they reckoned, “Hushai from the Arek mob has a good idea. It is better than the other plan of that wise man Ahithofel.” You see, God himself made them think like that. He wanted them to follow Hushai’s plan, and so make big trouble for Absalom. God confused them, so they did not like Ahithofel’s good plan. ");
INSERT INTO engPEV_vpl VALUES ("S218_1","011_18_1","2SA","18","1","2","David gathered his soldiers together, and he split them into 3 big groups. He picked a boss soldier to lead each group. They were Joab, and his brother Abishai, and Ittai, a man that used to live in a town called Gath. David told each big group to split into mobs with 1,000 men in each. And he picked one boss soldier for each mob of 1,000 soldiers. Then he told each of those mobs to do it again. This time each of them split into little groups with 100 men in each. David picked a boss soldier for each group of 100 soldiers. Then David said to everybody, “Let’s go and fight Absalom’s mob. I will go with you mob.” ");
INSERT INTO engPEV_vpl VALUES ("S218_3","011_18_3","2SA","18","3","3","But the soldiers said to him, “No way. You can’t come with us. You are the boss man, but we are just nothing. You are the one they want to kill. If we soldiers all run away, they will not chase us. If we all die, they will not care. They will say, ‘All right, leave them.’ But if you die, they will be really happy. So it’s good for you to stay here in this town. If the fighting gets hard for us, then you can send more soldiers to help us.” ");
INSERT INTO engPEV_vpl VALUES ("S218_4","011_18_4","2SA","18","4","5","David said, “All right, I will listen to what you mob say.” And he called out loud to the 3 boss soldiers, so everybody could hear. He said, “Joab. Abishai. Ittai. Don’t hurt that young man, Absalom. Don’t forget, he’s my son.” And he stood at the gate and watched the soldiers as they left that town. ");
INSERT INTO engPEV_vpl VALUES ("S218_6","011_18_6","2SA","18","6","6","David’s mob went away from the town, and they met the Israel mob in the bush at a place called Ephraim. ");
INSERT INTO engPEV_vpl VALUES ("S218_7","011_18_7","2SA","18","7","8","They chased each other in the bush, and they attacked each other with spears and bows and arrows. David’s mob beat Absalom’s mob and killed lots of them dead. But even more soldiers died from things in the bush. 20,000 men died on that day. ");
INSERT INTO engPEV_vpl VALUES ("S218_9","011_18_9","2SA","18","9","9","While they were fighting, David’s son Absalom rode around in the bush on a donkey. He suddenly met some of David’s men, and he tried to get away. The donkey ran under a big tree, and Absalom’s head got stuck in the branches. The donkey kept on running, so Absalom was left there. He hung from the tree and couldn’t get down. ");
INSERT INTO engPEV_vpl VALUES ("S218_10","011_18_10","2SA","18","10","10","One of David’s men saw him, and he went to the boss soldier, Joab, and said, “I just saw Absalom hanging from a tree.” ");
INSERT INTO engPEV_vpl VALUES ("S218_11","011_18_11","2SA","18","11","11","Joab said, “What? You really saw him like that? Why didn’t you kill him dead straight away? I will give lots of money and a boss soldier’s belt to a man that does something like that.” ");
INSERT INTO engPEV_vpl VALUES ("S218_12","011_18_12","2SA","18","12","12","But the man said, “I can’t do that. Yes, I might get lots of money, but I can’t kill our big boss’s son. No way. We all heard him tell you 3 boss soldiers, ‘Keep that young man, Absalom, safe. Don’t forget, he’s my son.’ ");
INSERT INTO engPEV_vpl VALUES ("S218_13","011_18_13","2SA","18","13","13","If I kill him, his father will hear about it straight away. He knows everything, and he will kill me dead too. And I reckon you might not help me either. You might say to him, ‘It’s nothing to do with me.’” ");
INSERT INTO engPEV_vpl VALUES ("S218_14","011_18_14","2SA","18","14","14","Joab was angry, and he said, “I can’t wait for you all day.” And he got 3 spears and went to Absalom. He was still alive and hanging there in that tree. Joab went and stabbed him 3 times in the chest. ");
INSERT INTO engPEV_vpl VALUES ("S218_15","011_18_15","2SA","18","15","15","10 men went with Joab, and they finished Absalom properly. ");
INSERT INTO engPEV_vpl VALUES ("S218_16","011_18_16","2SA","18","16","16","Straight away, Joab blew the trumpet, to tell David’s mob to stop chasing the Israel mob. ");
INSERT INTO engPEV_vpl VALUES ("S218_17","011_18_17","2SA","18","17","17","They got Absalom and threw him into a deep hole in the middle of the bush. Then they covered his body with lots of stones. At the same time, the Israel mob ran away and went back to their homes. ");
INSERT INTO engPEV_vpl VALUES ("S218_31","011_18_31","2SA","18","31","31","The messenger said, “Boss. Good news. God still wants you to be our big boss. Your enemies are nothing now. He punished them properly.” ");
INSERT INTO engPEV_vpl VALUES ("S218_32","011_18_32","2SA","18","32","32","David asked, “What about my son Absalom? Is he all right?” The messenger answered, “Those trouble makers, your enemies, I hope they all finish up, just like that young man finished up.” ");
INSERT INTO engPEV_vpl VALUES ("S218_33","011_18_33","2SA","18","33","33","David got very upset. He went inside and cried. As he went in, he called out, “Absalom. My son Absalom. I want to be dead instead of you. You were my son.” ");
INSERT INTO engPEV_vpl VALUES ("S221_15","011_21_15","2SA","21","15","15","Some time later, the Israel mob went to fight with the Philistia mob again. David also went with his soldiers, to fight along with them. But soon, he got very tired. ");
INSERT INTO engPEV_vpl VALUES ("S221_16","011_21_16","2SA","21","16","16","Then a really big Philistia man came close to David. His name was Ishbibenob. He belonged to Rafa’s family. Everybody in that family was really big and strong. His spear had a sharp point. It was heavy, 3½ kilograms, and he had a new long knife. He reckoned he was going to kill David dead. ");
INSERT INTO engPEV_vpl VALUES ("S221_17","011_21_17","2SA","21","17","17","But one of David’s boss soldiers came to save him from that big man. He attacked the big man and killed him dead. That brave man was Abishai, the son of David’s sister called Zeruiah. After that, David’s men made a promise to him. They said, “We will never let you come with us again to fight. They might kill you dead. You are like the lamp in God’s ceremony house. Nobody puts out its fire. You see, your life is like that. We don’t want anybody to kill you and finish up Israel’s lamp.” David died when he was an old man. They buried him in the city called Jerusalem, in that part of the city they call the city of David. David was the big boss of Israel for 40 years. First he was the boss in the town called Hebron for 7 years, then he was the boss in Jerusalem for 33 years. Then David’s son Solomon became the big boss. He took over from his father and controlled the whole country.  ");
INSERT INTO engPEV_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","People that live the right way are really happy. If people tell them to do bad things, they don’t listen. And they don’t copy the things that bad people do. And they don’t rubbish God the way bad people do. ");
INSERT INTO engPEV_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","They love God’s word, and they listen to it. They think about God’s word in the day time and in the night time. ");
INSERT INTO engPEV_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Those people are like trees that grow right next to a river. Those trees grow fruit every year. Their leaves never go brown and dry up. People that live the right way, they are like those trees. Everything that they do always goes well. ");
INSERT INTO engPEV_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","But bad people are not like that. They are like the rubbish bits of a plant that the wind blows away. ");
INSERT INTO engPEV_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Later, on the day when God will judge everybody, God will say that those bad people are guilty, and they will not be with the people that live God’s way. ");
INSERT INTO engPEV_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","You see, God knows the people that always live his way. He watches them, and he takes care of them. But those bad people go their own way, and God will finish them up. ");
INSERT INTO engPEV_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","The people from different countries are really angry, and they are talking about doing something stupid, something that will not work. ");
INSERT INTO engPEV_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Their bosses and leaders are getting ready to fight. They get together to fight against God, and against the man that God picked to be the special boss. They say, ");
INSERT INTO engPEV_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","“We don’t want God and his special man to be boss over us. We want to be free.” ");
INSERT INTO engPEV_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","But God just looks down from heaven and laughs at them. He is the true boss. He knows that their plans are stupid. ");
INSERT INTO engPEV_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","God is angry with those bosses, and he talks to them. He talks in a big, angry voice, so that they get really frightened. God says, ");
INSERT INTO engPEV_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","“I already picked somebody to be boss over all people. I made him the big boss, and I gave him the most important seat. That seat is on my special hill called Zion.” ");
INSERT INTO engPEV_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","God’s special boss said, “I will tell you this important thing that God said to me. He said, ‘You are my son. Now people will know that I am your father. ");
INSERT INTO engPEV_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","You can ask me for anything. Ask me for all the countries in the world, and I will give them to you. Yes, the whole world will belong to you. ");
INSERT INTO engPEV_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","You will win against all those other countries. You will finish them up, like somebody breaking a bowl into little pieces.’” ");
INSERT INTO engPEV_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","So listen, all you bosses of different countries. You have to think about what you are doing. You leaders all around the world, you have to be careful. ");
INSERT INTO engPEV_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","You have to do what God says, and show him proper respect. Be happy that God is your boss, but be frightened too, because he is really powerful. ");
INSERT INTO engPEV_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Yes, you have to show him proper respect. If you don’t respect God, he will quickly get angry, and he will suddenly finish you up. But God looks after everyone that trusts him. He will keep them safe, and they will be really happy. ");
INSERT INTO engPEV_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","This is one of David’s songs for God. God, who do you let visit your ceremony house to show you respect? Who do you let live there on your special hill? ");
INSERT INTO engPEV_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","I know the sort of people that God lets in his ceremony house. You can visit God’s ceremony house, if you are like this. You always live in a good way, and always do the right thing, and only say true things. ");
INSERT INTO engPEV_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","You don’t tell lies about people, and you don’t do bad things to people, and you don’t say bad things about people to shame them. ");
INSERT INTO engPEV_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","You never respect really bad people, but you respect people that properly respect God. You always keep your promises. Maybe it will be hard, maybe it will hurt you to keep those promises, but you still keep them. ");
INSERT INTO engPEV_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","And whenever somebody needs help, you let them borrow your money. And later on, when they pay you back that money, you only take that same money that they borrowed from you, you don’t make them pay you any more money on top of that. And another thing. If somebody says to you, “I want you to go to court and tell lies about good people. I will pay you money to tell those lies.” You always say, “No, I can’t tell lies about people.” All of those things that I just talked about in this song, everybody that lives that way will always be really strong for God. ");
INSERT INTO engPEV_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","This is one of David’s songs for God. The music leader can use the music called, “The deer in the early morning.” My God, my God, why did you go away and leave me all by myself? You are far away, and it feels like you will never save me. I yell out to you, but it is like you don’t hear me. ");
INSERT INTO engPEV_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","My God, I call out to you in the day time, but you don’t answer me. And I call out in the night time too, but you don’t let me rest. ");
INSERT INTO engPEV_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","But God, you are properly good. You are the big boss of the Israel mob, and all the Israel mob praise you and say that you are great. ");
INSERT INTO engPEV_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Our grand-fathers trusted you. Yes, they trusted you, and you saved them from their trouble. ");
INSERT INTO engPEV_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","They called out to you, and you helped them. They trusted you to help them, and you saved them. ");
INSERT INTO engPEV_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","But everybody hates me. They shame me and say bad things about me. They treat me like I am a worm, not a human being. ");
INSERT INTO engPEV_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","People see me, and they all make fun of me. They laugh at me, and they shake their heads to shame me. ");
INSERT INTO engPEV_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","They say, “That man trusts God, so why doesn’t God save him? If God is really happy with him, why doesn’t God help him?” ");
INSERT INTO engPEV_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","10","But you have cared for me all my life. You were my God even when I was inside my mother. You kept me safe when I was born, and you made me feel safe in my mother’s arms. ");
INSERT INTO engPEV_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","But now trouble is near me, and there is nobody to help me. Please don’t be far away from me, God. ");
INSERT INTO engPEV_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","My enemies are all around me. They are like a mob of big strong bulls, and I am in the middle. ");
INSERT INTO engPEV_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","My enemies want to attack me. They are like lions that roar and kill other animals. ");
INSERT INTO engPEV_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","I am very weak, and I feel like I am dying. I feel like my bones are not joined together any more. I used to be strong and brave, but now I am frightened. I don’t feel strong inside any more. ");
INSERT INTO engPEV_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","My mouth is really dry, and my tongue is sticking to the top of my mouth. It’s like God already put me in the grave. ");
INSERT INTO engPEV_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","There’s a mob of bad people all around me. They are like wild dogs coming towards me, and they hurt my hands and feet. ");
INSERT INTO engPEV_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","I am so thin that my bones are sticking out. My enemies look at me and laugh. ");
INSERT INTO engPEV_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","They split up my clothes among each other, and they gamble for my shirt. ");
INSERT INTO engPEV_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","God, please don’t be far away from me. You are the one that makes me strong, so please come quickly to help me. ");
INSERT INTO engPEV_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Don’t let my enemies kill me with their long knives. They are like wild dogs trying to kill me. ");
INSERT INTO engPEV_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","They are like hungry lions that want to eat me, like wild cows that try to hurt me with their horns. Please save me from all my enemies. Yes, I prayed like that, and you listened to me. ");
INSERT INTO engPEV_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","God, I will tell my people all about you. Every time we get together at your ceremony house, I will say, “God, you are really great.” ");
INSERT INTO engPEV_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Listen, all you people that respect God. You have to praise him. All you Israel mob, you family of Jacob, you have to tell God that he is really great. God is really powerful, so you have to respect him. ");
INSERT INTO engPEV_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","God doesn’t forget people that have trouble, and he doesn’t leave them all alone. I had trouble, and I called to God for help. He listened and answered me. ");
INSERT INTO engPEV_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Back when I had that trouble, I said, “God will save me, and then I promise to take an animal to God’s ceremony house. I will give that animal to God to say thank you, and I will have a special lunch there and eat some of that animal.” You know, God saved me, so I will keep that promise, and I will praise him in front of all his people. ");
INSERT INTO engPEV_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","I will invite people to eat that lunch with me. I will invite lots of people that have trouble, and they will eat until they are full. Some people trust God to help them, and they will all praise him. I pray that God looks after them for ever. ");
INSERT INTO engPEV_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","28","God is the boss of everybody, and he has power over all the nations and tribes in the world. People from all over the world will know about the things God does, and they will turn to God and follow him. And tribes from every country will show respect to God. ");
INSERT INTO engPEV_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Even people that have lots of food and good things in this life, they will show respect to God. Everybody that’s dying and can’t keep themselves alive, they will get down on their knees to show respect to God. ");
INSERT INTO engPEV_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","And our children will listen to God and work for him, and they will tell their children about God too. ");
INSERT INTO engPEV_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","And later on, they will tell people that are not even born yet. They will say, “God saved his people. Yes, he really helped us.” ");
INSERT INTO engPEV_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","This is one of David’s songs for God. God looks after me properly, he gives me everything that I need. You know about people that properly look after sheep all the time, called shepherds. Well, God looks after me like that. He is a good shepherd for me. ");
INSERT INTO engPEV_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","God gives me a good place to rest, just like a shepherd finds a good place for his sheep to rest, a place where there is green grass for them to eat and clean water for them to drink. ");
INSERT INTO engPEV_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","When I get tired, God makes me feel good and strong again. He leads me on the right track, so that people will know that he is good. ");
INSERT INTO engPEV_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","You know, God is with me when I have trouble too. Sometimes I have a lot of trouble, and I feel like I am walking in a really dark valley, and something might kill me, but even then, God is with me. I will not be frightened at that time. I know that God is stopping my enemies from hurting me, just like a shepherd uses his stick and stops wild dogs from hurting his sheep. When I remember that he does that, I feel safe. ");
INSERT INTO engPEV_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","God does good things for me even when people are giving me trouble, and he makes my enemies watch him do those good things. It is like I am a visitor at his house, and he cooks a big dinner for me, and I sit down and eat it. And he makes my enemies watch me eat it. It is like he fills my cup with good drink, right to the top. And it is like he shows everyone that I am his friend, by putting olive oil on my head. ");
INSERT INTO engPEV_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","I am sure that God will always love me, he will be good to me all of my life. And I will always be in God’s house, and I will respect him properly for ever. ");
INSERT INTO engPEV_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","This is one of David’s songs for God. It’s from the time when David pretended he was crazy in front of big boss Abimelek, so Abimelek sent David away. I will always say, “God is good.” Yes, I will keep on saying good things about God. ");
INSERT INTO engPEV_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","I will tell people, “God has all the power.” I want everybody that has a hard life to hear that and be happy. ");
INSERT INTO engPEV_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Come here everybody. I want us all to say, “God is great.” Let’s come together and say, “God is really powerful.” ");
INSERT INTO engPEV_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","You see, I prayed to God, and he listened to me. He took away everything that frightened me. ");
INSERT INTO engPEV_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","People that trust God are really happy. They will never feel shame. ");
INSERT INTO engPEV_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","I had a lot of trouble, but I prayed to God, and he listened to me. He saved me from all my troubles. ");
INSERT INTO engPEV_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Some people know that God is powerful, so they have strong respect for him. God sends his special angel spirit to be with those people, and that angel keeps those people safe from trouble. ");
INSERT INTO engPEV_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Find out for yourself that God is really good. Look at all the things he does. Whenever you get trouble, ask God to look after you. He will do that, and he will make you really happy. ");
INSERT INTO engPEV_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","You are God’s special people. You know that he is powerful, so you have to really respect him. If you really respect God, he will give you everything that you need. ");
INSERT INTO engPEV_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Sometimes even strong young lions can’t find food and they go hungry, but people that trust God, they have all the good things that they need. ");
INSERT INTO engPEV_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Come here everyone, and listen to me. I will teach you to respect God properly. ");
INSERT INTO engPEV_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Do you want to live well? Do you want a long and happy life? ");
INSERT INTO engPEV_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","If that’s what you want, don’t say bad things about other people, and don’t lie to them. ");
INSERT INTO engPEV_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Turn away from doing bad things, and do good things. Don’t fight with people or make trouble. Try very hard to live happily with other people. ");
INSERT INTO engPEV_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","God looks after people that live the right way. And if they ask him for help, he listens to them. ");
INSERT INTO engPEV_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","But God punishes people that do bad things. After they die, God doesn’t want anybody in the world to remember those bad people. So God will make everybody forget them. ");
INSERT INTO engPEV_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","But some people live the right way, and whenever they ask God for help, he listens to them. He saves them from all their troubles. ");
INSERT INTO engPEV_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Some people are really sad and feel hurt inside. God stays really close to those people. And some people think nothing good will happen to them. God helps those people too. ");
INSERT INTO engPEV_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","If somebody lives the right way, that person might still have a lot of troubles. But God will save that person from all those troubles. ");
INSERT INTO engPEV_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","God will keep that person safe, and nobody will break any of that person’s bones. ");
INSERT INTO engPEV_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","But people that do bad things, they will get trouble and die. And if somebody hates people that live the right way, God will punish that person. ");
INSERT INTO engPEV_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","But if people work hard for God, he will keep them safe. And if people trust God and if they ask him to look after them, God will not punish them. ");
INSERT INTO engPEV_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","2","This is one of David’s songs for God. The music leader can use it in God’s ceremony house. I had really bad trouble. It’s like I was in a deep hole that people die in. It’s like I was stuck in a bad place, like my legs were stuck in sticky mud. But I trusted God, and I waited for him to help me. I cried out to him, and he listened to me. God helped me. He saved me from that trouble. It’s like he lifted me out of that mud, and put my feet on good hard ground. God kept me safe. It’s like he gave me a safe path to walk on. ");
INSERT INTO engPEV_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Then God gave me a new song to sing to him. That song says that God is great. Lots of people will hear about everything that God did, and they will know that he has all the power. Then they will only trust him. ");
INSERT INTO engPEV_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","If people trust God properly, God makes those people happy. Whenever they have trouble, they trust God to help them. They don’t go to people that think they are great, or people that tell lies. ");
INSERT INTO engPEV_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","God, my God, you have done lots of powerful things for us. And you have lots and lots of good plans for us. Nobody is like you. You do so many great things that I can’t say them all. If I try to say them all, I’ll talk for ever and never stop talking. ");
INSERT INTO engPEV_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Some people kill animals to pay you for the bad things they did. And they give you animals and food as gifts. But that does not really make you happy. You don’t need people to burn animals for you. You don’t need people to give you gifts. You taught me all of this. ");
INSERT INTO engPEV_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","So I said to you, “Here I am. I came.” Your book tells me the things that I should do. ");
INSERT INTO engPEV_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","God, it makes me really happy to do everything that you want. I always think about your laws and obey them. ");
INSERT INTO engPEV_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Whenever your people come together to respect you, I tell them, “God helps his people.” I always talk like that, I don’t keep my mouth shut. You know that’s true, God. ");
INSERT INTO engPEV_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","I know that you always do what is right. I don’t keep it a secret inside of me. I tell everyone, “We can trust God. He saves us.” I don’t hide the true story from your people. I tell them, “God always loves us. We can always trust him.” ");
INSERT INTO engPEV_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Whenever I have troubles, God, you feel sorry for me, and you are good to me. You always love me, and I can always trust you. You keep me safe. ");
INSERT INTO engPEV_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","And I have lots of troubles now. It feels like there are troubles all around me, lots of troubles, so I can’t count them all. It’s like all the bad things I did are here with me, and I don’t know the right thing to do. I did lots of bad things, more bad things than the number of hairs on my head, so now I feel weak inside. ");
INSERT INTO engPEV_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","God, please save me from all this trouble. God, please come quickly, and help me. ");
INSERT INTO engPEV_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Some people want to kill me. God, please make them feel shame and make them confused. Those people are happy whenever I get hurt. God, please make them run away and be sad. ");
INSERT INTO engPEV_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Those people make fun of me, and they laugh at me. God, please make them shamed, so that they feel really sad. ");
INSERT INTO engPEV_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","But there are some people that always come to you God. Please make those people really happy. They say, “God, thank you for saving us.” And I pray that they always say, “God is great.” ");
INSERT INTO engPEV_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","But what about me? I have lots of trouble and I need help, so I want God to think about me. God, you are the one that helps me and saves me. God, my God, please come and help me now and don’t wait. ");
INSERT INTO engPEV_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","This is one of the songs of the Korah mob. The music leader can use it in God’s ceremony house. God is strong, and he is always ready to help us when we get trouble. He is like a safe place for us to hide. Whenever we get trouble, he is the one that can help us. ");
INSERT INTO engPEV_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","So we will never get frightened. Even if there is a big earthquake, and the mountains start to break up and fall into the sea, even then we will not be frightened. ");
INSERT INTO engPEV_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Even if the waves in the sea get really big and loud, and if the mountains shake, even then we will not be frightened. ");
INSERT INTO engPEV_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","There is a river in God’s city, and it makes the people there happy. That place is God’s home. He is the greatest one of all. ");
INSERT INTO engPEV_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","God lives in that city. Nothing can ever knock it down. God will stop anybody from hurting the people in that city. He will look after them all the time, right from the start of every day. ");
INSERT INTO engPEV_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","You see, God is powerful, and he frightens the nations that don’t follow him. So they go wild and don’t think properly, and they get weak and useless. It’s like God just yells at those people and they finish up, like ice that melts in the hot sun. ");
INSERT INTO engPEV_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","God is the boss of everything, and he is with us and helps us. He is the God of us Israel people, and he will stop anyone from hurting us. ");
INSERT INTO engPEV_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Come and look at what God does. He does things on the earth that will shock you. ");
INSERT INTO engPEV_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","He stops wars all over the world. It’s like he breaks all the things that people use to fight with, like their spears and bows, and it’s like he burns all the shields with fire. ");
INSERT INTO engPEV_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","God says, “Stop, you mob. Keep still, and think, and you will know that I am the only one that really is God. The people in every nation will respect me. People all over the world will respect me.” ");
INSERT INTO engPEV_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","God is the boss of everything, and he is with us and helps us. He is the God of us Israel people, and he will stop anyone from hurting us. ");
INSERT INTO engPEV_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Say thank you to God, because he is good. God will keep on loving us for ever, just like he promised. ");
INSERT INTO engPEV_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","All you Israel people, you have to say, “God will keep on loving us for ever, just like he promised.” ");
INSERT INTO engPEV_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","All you people in Aaron’s family, you people that help with God’s ceremonies, you have to say, “That’s right, God will keep on loving us for ever, just like he promised.” ");
INSERT INTO engPEV_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","All you people that love God and respect him, you have to say, “That’s right, God will keep on loving us for ever, just like he promised.” ");
INSERT INTO engPEV_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","I had lots of trouble, so I cried out to God to help me. He heard me, and he took away that trouble from me. ");
INSERT INTO engPEV_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","God is with me, so I will not be frightened. God is looking after me, so people can’t do anything to hurt me. ");
INSERT INTO engPEV_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","God is with me. He always helps me. So I will win against my enemies. ");
INSERT INTO engPEV_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","We cannot always trust other people to keep us safe. But we can always trust God to keep us safe. ");
INSERT INTO engPEV_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","We cannot always trust big bosses to keep us safe. But we can always trust God to keep us safe. ");
INSERT INTO engPEV_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","People from all different countries were in a circle around me, they were ready to attack me. But God gave me power, and I finished them up. ");
INSERT INTO engPEV_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Yes, they were all around me on every side. But God gave me power, and I finished them up. ");
INSERT INTO engPEV_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","They were like angry bees flying all around me. But God gave me power, and I finished them up quickly, just like a fire quickly finishes up dry grass. ");
INSERT INTO engPEV_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","My enemies were attacking me. They nearly beat me, but God helped me. ");
INSERT INTO engPEV_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","God makes me strong. He is the one that keeps me safe. He saved me from my enemies. ");
INSERT INTO engPEV_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","God’s people yell out and sing happy songs all around their camp. They sing about God saving them. They shout, “God does really powerful things. ");
INSERT INTO engPEV_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","He wins against his enemies. God does really powerful things.” ");
INSERT INTO engPEV_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","My enemies will not kill me. I will keep on living, and I will tell people about the good things that God does. ");
INSERT INTO engPEV_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","God let me have big trouble, so that he can teach me good things, but he did not let me die. ");
INSERT INTO engPEV_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Now I am going to God’s ceremony house. I want to say thank you to God. Please open the doors so that I can come in. ");
INSERT INTO engPEV_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Those doors are the way into God’s house. Only people that live God’s way go through those doors. ");
INSERT INTO engPEV_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Thank you God. You listened to me, and you saved me. ");
INSERT INTO engPEV_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","It is like some workers built a house out of big stones, but those workers thought one of those stones was rubbish, so they chucked it away. But they were wrong. That stone was properly good, and now God made it the most important stone of all. ");
INSERT INTO engPEV_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Yes, God did that, and we are really happy about it. We reckon he did something great. ");
INSERT INTO engPEV_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Today God won against our enemies, so we are really happy. Let’s have a party and sing about it. ");
INSERT INTO engPEV_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","We pray to you God, please save us. We pray to you God, please make everything work out good for us. ");
INSERT INTO engPEV_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","God, we want you to look after the man that you send. Make him strong and happy. God, we are in your ceremony house, and we want you to look after all these people here. Make them strong and happy. ");
INSERT INTO engPEV_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","God’s name is Yahweh. He is the true God. He is really good to us. Come and join God’s ceremony today. Bring palm branches and wave them, as you walk around the special table in God’s ceremony house. ");
INSERT INTO engPEV_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","You are my God. I will thank you. You are my God. I will praise you. ");
INSERT INTO engPEV_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Say thank you to God, because he is good. God will keep on loving us for ever, just like he promised. ");
INSERT INTO engPEV_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","This song is for people to sing as they walk up to God’s house to show him respect. I look up at all the hills, and I ask myself, “Who is the one that helps me?” ");
INSERT INTO engPEV_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Then I say, “God is the one that helps me. He is the one that made the earth and the sky.” ");
INSERT INTO engPEV_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","He will always look after you so that you don’t get trouble. He is watching you all the time, to keep you safe. He never goes to sleep. ");
INSERT INTO engPEV_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","That’s right. He always watches the Israel people, and he never sleeps. ");
INSERT INTO engPEV_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","God is the one that looks after you properly. When the sun is really hot, you know how good it is to rest under a shady tree. Well, when life gets tough for you, God will be close to you and help you, like he is a shady tree for you. ");
INSERT INTO engPEV_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","7","Yes, God will always look after you, in the day time and in the night time. He will always keep you safe. He will stop anything from hurting you. Not even the hot sun or the moon will hurt you. He will not let anything finish you. ");
INSERT INTO engPEV_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Whenever you go anywhere, God will go with you all the way, and he will keep you safe. He will do that now, and he will keep doing that all the time, for ever. ");
INSERT INTO engPEV_vpl VALUES ("PR3_5","021_3_5","PRO","3","5","5","You have to trust in God properly, you have to only trust in him. Don’t trust the things you know, you don’t know everything. ");
INSERT INTO engPEV_vpl VALUES ("PR3_6","021_3_6","PRO","3","6","6","Always think about God in everything that you do. If you do that, he will show you the right way to live. ");
INSERT INTO engPEV_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","There was a man in Israel country called Jonah. His father’s name was Amittai. One day, the God of Israel talked to Jonah. God said to Jonah, ");
INSERT INTO engPEV_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“You know the big city called Nineveh that is not in Israel country? The people in that city do really bad things, and I see all the things they do. So you have to go there now, to that big city called Nineveh. You have to tell those people, ‘God is angry with you.’” ");
INSERT INTO engPEV_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","But Jonah didn’t listen to God. Instead, he ran away from God. He went down to the town called Joppa. He wanted to get on a ship there, and go to the town called Tarshish. Tarshish is a long way away from Nineveh. In Joppa, Jonah found a ship that was going to Tarshish, so he paid some money to the ship-men so he can go on that ship. Then he got on the ship to go to Tarshish with them. Jonah was running away from God. ");
INSERT INTO engPEV_vpl VALUES ("JH1_4","033_1_4","JON","1","4","5","Then Jonah went down inside the ship and lay down, and he fell asleep. While they were sailing, God sent a big wind over the sea, and there was a big storm. That storm was really strong, and the ship-men thought the ship might break up. All the ship-men were frightened, so they called out to their own gods and asked them to help. That ship was carrying lots of heavy boxes and bags of things, to take them to Tarshish. But that storm was really big, so the ship-men threw all those heavy things into the sea to make the ship lighter. ");
INSERT INTO engPEV_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Jonah was still asleep down inside the ship, so the ship’s boss went to Jonah and said, “Why are you sleeping? Get up and pray to your god. Maybe he will feel sorry for us and help us, so that we don’t die.” ");
INSERT INTO engPEV_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Then the ship-men talked to each other. They said, “Why do we have this trouble? Who did something wrong to make this trouble come on us? Let’s put small stones in a bag, one stone for each of us, and we’ll pull out one person’s stone. That stone will show us who made this trouble come on us.” So they did that, and they pulled out Jonah’s stone. ");
INSERT INTO engPEV_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","So those ship-men asked Jonah, “Did you make this trouble come on us? Did you do something bad? Who are you? What is your job? And where do you come from? What country are you from? And who are your people?” ");
INSERT INTO engPEV_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Jonah said to them, “I am from the Hebrew people, from Israel country. Our God’s name is Yahweh, and we have to respect him. I know he has all the power. He is the big boss in heaven. He made the sea and the land. ");
INSERT INTO engPEV_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","But right now, I am running away from him.” Then the ship-men got really frightened. They asked Jonah, “Why are you running away from your god? That is a bad thing to do.” ");
INSERT INTO engPEV_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","The sea was getting more and more rough. So the ship-men asked Jonah, “How can we stop this storm and make the sea quiet and still? What do we have to do to you?” ");
INSERT INTO engPEV_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Jonah said to them, “You have to pick me up and throw me into the sea. Then the storm will stop, and the sea will be quiet and still. This storm is my fault. I did something wrong, and that’s the reason why you are in this big storm.” ");
INSERT INTO engPEV_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","But the ship-men didn’t want to throw Jonah into the sea, so they tried hard to row back to the land. But the sea was getting more and more rough, so they couldn’t do it. ");
INSERT INTO engPEV_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Then the ship-men prayed to Jonah’s God. They said, “Yahweh, you sent this storm and made all of this happen. If we throw this man into the sea, please don’t kill us. Maybe he did nothing wrong, we don’t know, but please don’t do payback to us.” ");
INSERT INTO engPEV_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Then they picked up Jonah, and they threw him into the sea, and the storm stopped, and the sea was quiet and still. ");
INSERT INTO engPEV_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Then the ship-men knew that Jonah’s God is powerful, and they showed him lots of respect. They killed an animal to give to Jonah’s God, and they made promises to him. ");
INSERT INTO engPEV_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","While the ship-men did that, God sent a big fish to Jonah. Jonah was deep down in the water, and that big fish came and swallowed Jonah alive. Jonah stayed inside that fish for 3 days and 3 nights. ");
INSERT INTO engPEV_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Then Jonah prayed to God from inside that fish. He talked about the things that happened to him in the water before that fish came. ");
INSERT INTO engPEV_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","He said, “Yahweh, when I got trouble, I called out to you, and you answered me. I nearly died, but I called out for help, and you listened to me. ");
INSERT INTO engPEV_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","This is what happened. First you made me go down into deep water, into the middle of the sea. The water moved all around me. You sent big waves over me. ");
INSERT INTO engPEV_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","I knew that you sent me away. You didn’t want to look at me any more. But I also knew that I will get to go to your good ceremony house again. ");
INSERT INTO engPEV_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","That water tried to drown me. Deep water was all around me. Seaweed wrapped around my head. ");
INSERT INTO engPEV_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","I sank down to the bottom of the sea, deep down in the earth. It was like gates locked around me, I thought I was stuck there for ever. But you, my God, you saved my life. You pulled me up from that deep dark place. ");
INSERT INTO engPEV_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","My life was finishing up, and I called out to you my God. My prayer went up to you, to your special place where you live. ");
INSERT INTO engPEV_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","God, you are good to your people, and you keep your promises. But some people don’t respect you, and they turn away from you. Those people show respect to things they think are gods that have no power. So those people will miss out on the good things that you do for your people. ");
INSERT INTO engPEV_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","But God, I will sing to you to say thank you. And I will kill animals to give them to you, to show respect to you. I promise I will do that. You are the only one that saves people.” ");
INSERT INTO engPEV_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","And then God talked to that fish, and it spat Jonah on to dry ground. ");
INSERT INTO engPEV_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Then God talked to Jonah a second time. God said, ");
INSERT INTO engPEV_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“You have to go now to that big city called Nineveh. You have to tell the people in Nineveh my message.” ");
INSERT INTO engPEV_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","So Jonah got up and went to Nineveh, just like God said. Nineveh was a really big city. It took three days to walk from one side of that city to the other side. ");
INSERT INTO engPEV_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Jonah started to go into the city. He walked for one day, and he called out, “In 40 days from now, God will finish up Nineveh.” ");
INSERT INTO engPEV_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","The Nineveh people listened to Jonah, and they believed God’s message. They knew that God was angry with them for the bad things they did. So all the Nineveh people stopped eating food, to show God that they were sorry for the bad things they did. And they all put on clothes made out of a rough cloth, called sack-cloth. Everybody did that, the important people and the poor people, they all did that to show God that they were sorry for the bad things they did. ");
INSERT INTO engPEV_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","The big boss of Nineveh heard about God’s message, and he got up from his special seat, and he took off his special coat, and he put on those rough clothes, and he sat down on ashes. He did those things to show God that he was sorry. ");
INSERT INTO engPEV_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","And that Nineveh boss sent a message to all the people in Nineveh. That message said, “The big boss of Nineveh and his important workers are telling you what you have to do. All the people and animals have to stop eating and drinking. None of you, or your sheep or cows, are allowed to eat or drink anything. ");
INSERT INTO engPEV_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","And all the people and animals have to wear that rough cloth. And everybody has to pray strongly to God and ask him to help us. And you all have to stop doing bad things, and stop hurting people. ");
INSERT INTO engPEV_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","God is really angry with us. He said he will finish us up. So we have to show God that we are sorry, and stop doing bad things. Then maybe God will change his mind. Maybe God will stop being angry with us, and maybe he will not finish us up.” ");
INSERT INTO engPEV_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Then the Nineveh people did everything the big boss said, and God saw that they stopped doing bad things. So God changed his mind, and he didn’t finish up the Nineveh people. ");
INSERT INTO engPEV_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","But Jonah wanted God to punish the Nineveh people. Jonah saw that God changed his mind and that God didn’t finish up the Nineveh people. So Jonah got really upset and was very angry. ");
INSERT INTO engPEV_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Jonah prayed to God. He said, “God, that first time you talked to me, when I was still at home in Israel country, you told me to go and talk to the Nineveh people. But I knew that if I told the Nineveh people your message, they might stop doing bad things, and you might not finish them up. But God, I want you to finish up those Nineveh people. That is the reason why I didn’t want to go to Nineveh and tell them your message, and why I ran away to Tarshish. I knew that you feel sorry for people, and you are always kind. You don’t get angry quickly, and you are really good to people. You don’t do payback to people that stop doing bad things. ");
INSERT INTO engPEV_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","So, God, please finish me up. I want to die, I don’t want to live and watch you be good to the Nineveh people.” ");
INSERT INTO engPEV_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Then God said, “You are very angry. Are you thinking the right way?” ");
INSERT INTO engPEV_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Then Jonah went out of the city, to the east side. And he made a shelter for himself, and he sat under it in the shade. And he waited there to see what will happen to Nineveh. ");
INSERT INTO engPEV_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Then God made a plant grow up near Jonah, to give him shade over his head, so that he will not be so hot. And Jonah was really happy about that plant. ");
INSERT INTO engPEV_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","But early the next day, just before the sun came up, God sent a worm to eat that plant, and that plant died. ");
INSERT INTO engPEV_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Then the sun came up, and God sent a really hot wind that came from the east. And the sun was really hot on Jonah’s head, so he felt sick. Then Jonah got angry, and he wanted to die. He said, “I don’t want to live any more. I want to die.” ");
INSERT INTO engPEV_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Then God said to Jonah, “You are very angry about that plant. Are you thinking the right way?” Then Jonah said, “Yes, I am thinking the right way. I am so angry that I want to die.” ");
INSERT INTO engPEV_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Then God said to Jonah, “You really care about that plant. But you didn’t look after it or make it grow. It grew in one night, and it died in one night. ");
INSERT INTO engPEV_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","But you think it’s wrong that I care about Nineveh. Nineveh is a big city, and it has lots and lots of people. It has more than 120,000 people, and those people don’t know what is right and what is wrong. And there are lots of animals there too.” ");
INSERT INTO engPEV_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","A long time ago, God promised to send somebody to save us. Jesus is that person. These names are the fathers and grand-fathers of Jesus, that lived a long time before he was born. This list shows that Jesus was from the family of David. David was the big boss over the Israel people. It also shows that David was from the family of Abraham. ");
INSERT INTO engPEV_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","This list starts with Abraham, a really long time ago. He was the father of Isaac. Isaac was the father of Jacob. Jacob was the father of Judah and his brothers. ");
INSERT INTO engPEV_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah was the father of Perez and Zerah. Their mother’s name was Tamar. Perez was the father of Hezron. Hezron was the father of Ram. ");
INSERT INTO engPEV_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram was the father of Amminadab. Amminadab was the father of Nahshon. Nahshon was the father of Salmon. ");
INSERT INTO engPEV_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon was the father of Boaz. His mother’s name was Rahab. Boaz was the father of Obed. His mother’s name was Ruth. Obed was the father of Jesse. ");
INSERT INTO engPEV_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse was the father of David. He was the big boss over all that mob, the Israel nation. So in that family there were 14 fathers from Abraham to David. David was the father of Solomon. At first Solomon’s mother was the wife of another man called Uriah. ");
INSERT INTO engPEV_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon was the father of Riaboam. Riaboam was the father of Abijah. Abijah was the father of Asa. ");
INSERT INTO engPEV_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa was the father of Jehoshafat. Jehoshafat was the father of Jehoram. Jehoram was the father of Uzziah. ");
INSERT INTO engPEV_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah was the father of Jotham. Jotham was the father of Ahaz. Ahaz was the father of Hezekiah. ");
INSERT INTO engPEV_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah was the father of Manasseh. Manasseh was the father of Amon. Amon was the father of Josiah. ");
INSERT INTO engPEV_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiah was the father of Jeconiah and his brothers. At that time, the soldiers from Babylon came and fought the Jewish people. The Babylon mob won, and they took the Jewish people as prisoners to their country. So in that family there were 14 fathers from David until the time they all had to go to Babylon. ");
INSERT INTO engPEV_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jeconiah was the father of Shiyaltiel. Shiyaltiel was the father of Zerubbabel. ");
INSERT INTO engPEV_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel was the father of Abihud. Abihud was the father of Eliakim. Eliakim was the father of Azor. ");
INSERT INTO engPEV_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor was the father of Zadok. Zadok was the father of Akim. Akim was the father of Eliud. ");
INSERT INTO engPEV_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud was the father of Eleazar. Eleazar was the father of Matthan. Matthan was the father of Jacob. ");
INSERT INTO engPEV_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob was the father of Joseph. Joseph was the husband of Mary, and Mary was the mother of Jesus. Jesus is the Christ, the man that God promised to send to save us. ");
INSERT INTO engPEV_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","So in that family there were 14 fathers from Abraham to David, and there were 14 fathers from David until the time they all had to go to Babylon, and there were 14 fathers from that Babylon time until the time God sent Jesus to the world. ");
INSERT INTO engPEV_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","This is the story about how Jesus was born. He is the man that God talked about a long time ago. God promised to send him to us. Mary was promised to a man called Joseph, but they hadn’t slept together yet, like married people do. Then the Holy Spirit made a baby grow inside Mary. ");
INSERT INTO engPEV_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joseph found out that Mary was going to have a baby, and he was not happy. He knew that the baby wasn’t his, so he wanted to leave Mary. But he was a good man, and he didn’t want to shame her. So he thought, “I will just leave her quietly, without any argument.” ");
INSERT INTO engPEV_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","While Joseph thought about that, he went to sleep and had a dream. He saw an angel messenger from God. The angel said, “Joseph, you are from the family of David. Look, you can go ahead and marry Mary. Don’t be too frightened to do that. You see, her baby is from the Holy Spirit, not from another man. ");
INSERT INTO engPEV_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","She will have a baby boy, and you will name him Jesus. (That name Jesus means God saves.) You see, he will save his people, so that God will not punish them for the bad things they do.” ");
INSERT INTO engPEV_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","That all happened just like God told one of his men to write in God’s book, a long time ago. He wrote, ");
INSERT INTO engPEV_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“There will be a young woman that never slept with a man, like a woman does with her husband, but she will have a baby boy. That boy will have a special name, Immanuel. That name means God is with us.” ");
INSERT INTO engPEV_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joseph woke up and did what God’s angel told him to do. He married Mary. ");
INSERT INTO engPEV_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","But he did not sleep with her, like a man does with his wife, until after her son was born. And he named the baby Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus was born in Bethlehem, in Judea country. At that time, the big boss over that country was called Herod. There were some wise men in a country to the east of Judea. They always looked at the stars, and one night they saw a special star in the sky. So they went west to Jerusalem, the city in Judea country. ");
INSERT INTO engPEV_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","They asked the Jerusalem people, “Where was that baby born that is going to be the big boss over you Jewish people? You see, back in our country, we saw his special star. We saw it come up into the sky, so we came here, to show respect to him. Where will we find him?” ");
INSERT INTO engPEV_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Herod was the big boss over that country, and somebody told him that these wise men were talking about another big boss. Herod got very worried. He thought this other person might fight against him and take over his job. A lot of other people in Jerusalem were worried about it too. ");
INSERT INTO engPEV_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","So Herod had a meeting with the bosses of the Jewish ceremonies and the Jewish law teachers, and he asked them, “Where will that baby be born? You know, the Christ, the man that God promised to send?” ");
INSERT INTO engPEV_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","They said, “He will be born in Bethlehem, in Judea country. You see, a long time ago, God told one of his men to write about it. He wrote this in God’s book, ");
INSERT INTO engPEV_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Bethlehem is a little town in Judea country, but it is a very important town, because a big boss will be born there. He will really look after God’s people, the Israel nation.’” That’s what those Jewish leaders told Herod. ");
INSERT INTO engPEV_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","So Herod sent for those wise men to come and meet him, but he didn’t tell anyone else about the meeting. He asked them, “When did you first see that star?” ");
INSERT INTO engPEV_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","So they told him when they first saw it. Then he said to them, “Go to Bethlehem and look carefully for that boy. After you find him, come and tell me the place where he’s living, so that I can go there too and show respect to him.” ");
INSERT INTO engPEV_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","The wise men listened to Herod, then they started to go to Bethlehem. Then they saw that same star that they saw before, and they were very happy. That star moved through the sky, and they followed it until it stopped right above the house that Joseph and Mary were living in. ");
INSERT INTO engPEV_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","The wise men went into that house. They saw Jesus with his mother Mary, and they got down on their knees, to show him respect. Then they opened their bags and gave him some presents. They gave him some gold. And they gave him some powder called frankincense, to burn to make a good smell. And they gave him some rubbing medicine called myrrh, that smells good, like perfume. ");
INSERT INTO engPEV_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","After that, the wise men had a dream. In that dream God told them not to go back to Herod, so they went back to their own country along a different road. ");
INSERT INTO engPEV_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","After those wise men went away, Joseph had a dream. He heard God’s angel messenger say, “Herod will try to kill the boy, so get up and take Jesus and Mary to Egypt country, and stay there until I tell you to come back.” ");
INSERT INTO engPEV_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","So Joseph got up right then, in the middle of the night, and he got Mary and Jesus, and they left to go to Egypt. ");
INSERT INTO engPEV_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","They lived in Egypt until Herod died, and then they came out of Egypt and went back to Israel country. So it happened just like God told one of his men to write in God’s book, a long time ago. He wrote, “God called his son to come out of Egypt.” ");
INSERT INTO engPEV_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","At the time when Joseph, Mary and Jesus were going to Egypt, Herod waited for those wise men to come back, but they tricked him. They didn’t come back to him. Then he got really angry. He remembered their story about when they first saw the star, so he sent his soldiers to Bethlehem, and he told them to kill all the little boys up to 2 years old. So they killed all the little boys around Bethlehem. Herod wanted to make sure that Jesus was dead. ");
INSERT INTO engPEV_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","That all happened the way God’s man, Jeremiah, wrote in God’s book, a long time ago. This is what he wrote, ");
INSERT INTO engPEV_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“In the town called Ramah, a lot of women are really sad, and they are crying out loud. They are the grand-daughters of Rachel. They are crying for their babies. Nobody can cheer them up, because their babies are dead.” ");
INSERT INTO engPEV_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Some time later, Herod died. Then, in Egypt, Joseph had another dream. He heard God’s angel messenger say, ");
INSERT INTO engPEV_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Get up and take Mary and Jesus back to Israel country. The people that wanted to kill him are dead now.” ");
INSERT INTO engPEV_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","So Joseph did what God’s angel messenger told him. He got up, and he got Mary and Jesus, and they started to go back to Israel country. ");
INSERT INTO engPEV_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","But then somebody told him that Herod’s son Arkelayus was the new big boss over the part of Israel called Judea, and Joseph was too frightened to go there. Then he had another dream. God told him, “Go to Galilee country.” ");
INSERT INTO engPEV_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","So he took his family up north to Galilee. He got to the town called Nazareth, and he stayed there. A long time before that, one of God’s men wrote about this, and it is in God’s book. He wrote, “People will say that God’s special man is from Nazareth.” And that happened after Joseph took his family to live at Nazareth. ");
INSERT INTO engPEV_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Many years later, while Jesus was still in Nazareth, John the Baptiser started his work. He went to the bush in Judea country, and he started to tell everybody his message. ");
INSERT INTO engPEV_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","He said, “Listen. God is going to show everyone how they can be in his family. So you have to stop doing bad things. You have to turn around and live God’s way.” ");
INSERT INTO engPEV_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","John was the man that Isaiah wrote about, a long time ago. Isaiah was one of God’s men, and God got him to write this in God’s book, “A man will be out in the bush, and he will call out to people. He will say, ‘You mob get ready. God is coming to this country, so you have to get ready for him. It is like when a big boss comes, and you have to make a good road for him.’” ");
INSERT INTO engPEV_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","John wore rough clothes, made of camel’s hair, and he wore a leather belt. He ate grasshoppers and bush honey. ");
INSERT INTO engPEV_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","A lot of people went out to see John, and to listen to him. They went out from Jerusalem city, and from all of Judea country, and from all the country around the Jordan River. ");
INSERT INTO engPEV_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","And, after those people said they were sorry for the bad things they did, John took them through a special washing ceremony, that is, he baptised them in the Jordan River. ");
INSERT INTO engPEV_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Some men came to that place to watch John baptise people. Some of them were from the Pharisee mob, that were strong for the Jewish law, and some of them were from the mob called Sadducees. John saw them and said, “You mob are bad, and you are tricky. You are just like a mob of cheeky snakes. Did somebody tell you that God is really angry with you, so you want to do something to stop him from punishing you? ");
INSERT INTO engPEV_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","If you really are sorry for the bad things you did, and if you are turning around properly to live God’s way, show us. If we see you doing good things, then we will know it is true. ");
INSERT INTO engPEV_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","But don’t just say to yourselves, ‘We are in Abraham’s family, so we’ll be all right.’ Listen, God can turn these stones here into Abraham’s family. ");
INSERT INTO engPEV_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","So you look out. God is going to punish you. He is like a man lifting up an axe to cut the roots of a tree. You are like trees that haven’t got good fruit, so men chop them down and throw them into a fire. God will punish you like that. He will throw you into a fire.” ");
INSERT INTO engPEV_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","John kept on talking to the people. He said, “If you say you are sorry for the bad things you did, and if you turn to God, then I will baptise you with water. But somebody is coming soon, and he is more important than me. I’m not even good enough to carry his shoes. I’m just nothing. He will put the Holy Spirit in you, that is, he will baptise you with the Holy Spirit, and with fire. ");
INSERT INTO engPEV_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","You know the way a farmer gets all the seeds from the plants he grows. He hits the seed heads with a stick and throws them in the air, so that the seeds fall off the plants. Then he gathers all the seeds and puts them in his shed. But he burns all the rest. It is rubbish, and he burns it in a fire. Well, God is like that farmer. He’s got that stick in his hand right now. If you turn around and live God’s way, he will look after you. But if you don’t, he will throw you in the fire that never goes out.” ");
INSERT INTO engPEV_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","At that time, Jesus left his home in Galilee country, and he went south to the Jordan River. Jesus wanted John to baptise him. ");
INSERT INTO engPEV_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","But John didn’t agree with him. He said, “No. Don’t come to me. I can’t baptise you. You are better than me, so really, you have to baptise me.” ");
INSERT INTO engPEV_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","But Jesus said, “We have to do it the way God wants. So now, while you are baptising people, you can baptise me too.” Then John agreed with him. ");
INSERT INTO engPEV_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","So John baptised Jesus. And as Jesus came up out of the water, the sky opened up, and Jesus saw the spirit of God coming down like a pigeon, and landing on him. ");
INSERT INTO engPEV_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","And God talked from heaven. He said, “This is my son. I love him very much, and I’m very happy with him.” ");
INSERT INTO engPEV_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Then the Holy Spirit led Jesus into the bush, and the devil, the boss over the bad spirits, tested him there, trying to trick him. ");
INSERT INTO engPEV_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesus was there for 40 days, and he didn’t eat anything, so he got very hungry. ");
INSERT INTO engPEV_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","At that time the devil came to him and said, “If you are the son of God, tell these stones to turn into loaves of bread.” ");
INSERT INTO engPEV_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","But Jesus told him, “No. I will not do that. You know what God says. These words are in his book, ‘People don’t live just by eating bread, but they live by every word that God says.’” ");
INSERT INTO engPEV_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Then the devil took Jesus to God’s special city, called Jerusalem, and he took him up to the top of the big ceremony house there. ");
INSERT INTO engPEV_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","The devil said, “If you are the son of God, jump off. You know, these words are in God’s book too, ‘God will tell his angel messengers to look after you, and they will hold you up with their hands, so you will not even hurt your foot on a stone.’” ");
INSERT INTO engPEV_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesus said, “No. I will not do that. You see, God says this too. These words are in his book, ‘Don’t do something stupid just to test God.’” ");
INSERT INTO engPEV_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Then the devil took Jesus up to the top of a very high mountain. From there the devil showed him all the people of the world, in all their countries, with all their great things. ");
INSERT INTO engPEV_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","And the devil said, “If you will get down on your knees and show respect to me, then I will give you all of this, all of these people and all of these things.” ");
INSERT INTO engPEV_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesus said to the devil, “No. I will not do that either. Satan, you go away from me now. This is what God says in his book, ‘You have to show respect to God. He is the only God, so just do what he says.’” ");
INSERT INTO engPEV_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Then the devil went away, and God’s angel messengers came and took care of Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","After that, Jesus heard that some soldiers grabbed John and put him in jail. So Jesus left Judea country and went back to Galilee country. ");
INSERT INTO engPEV_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","He went to the town called Nazareth, and then he left that town and went to live in the town called Capernium. It was beside the big lake called Lake Galilee. It was in the country where the Zebulun tribe and the Naphtali tribe used to live. ");
INSERT INTO engPEV_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","All that happened just like God says in his book. Isaiah was a man that told everyone God’s words, and a long time ago, he wrote this in God’s book, ");
INSERT INTO engPEV_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“It will happen in the country that belongs to the Zebulun tribe and the Naphtali tribe. It is beside the sea, past the Jordan River, in Galilee country, where there are a lot of people that are not Jews. ");
INSERT INTO engPEV_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","The people there don’t know much about God. It is like they are in the dark, but they will see a big bright light. They thought they were going to die, but a light will start to shine for them.” ");
INSERT INTO engPEV_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Then Jesus started to tell everybody, “Listen. God is going to show everyone how they can be in his family. So you have to stop doing bad things. You have to turn around and live God’s way.” ");
INSERT INTO engPEV_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","One day, Jesus walked along next to Lake Galilee, and he saw 2 men throwing a net into the water to catch fish. That was their job. One man was called Simon. He was also called Peter. And the other man was his brother Andrew. ");
INSERT INTO engPEV_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesus said, “I want you 2 to come and follow me. I want you to stop catching fish. I’ll give you another job. You will catch people for me.” ");
INSERT INTO engPEV_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","And straight away, they left their nets and followed him. ");
INSERT INTO engPEV_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Then Jesus kept walking along next to the water, and he saw an old man called Zebedee and his 2 sons, James and John. They were getting their nets ready to catch fish. Like before, Jesus called out to James and John to stop their work and follow him. ");
INSERT INTO engPEV_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","They got up straight away. They left their father, and the boat, and they followed Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","After that, Jesus went through all of Galilee country. He taught people in the Jewish meeting houses, and he told them the good news about God’s family. And he made a lot of sick people better. They had all sorts of sickness. ");
INSERT INTO engPEV_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Then people started to tell other people about Jesus, so that people as far away as Syria country heard about the things he did, and they all started to bring lots of sick people to Jesus. And Jesus made them all better, no matter what sort of sickness they had. Some of them used to fall down and shake a lot, and some of them couldn’t move their arms or legs, and some of them had bad spirits in them. But Jesus made them all better. ");
INSERT INTO engPEV_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","A big mob of people followed him everywhere he went. These people were from Galilee country, and from the country called Ten Towns, and from Jerusalem city, and from all over Judea country, and from the country east of the Jordan River. ");
INSERT INTO engPEV_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesus saw big mobs of people coming to him. So he went up a big hill, and he sat down there to teach them. His followers, the people that wanted to learn about God, they all went close to him, to listen to him. ");
INSERT INTO engPEV_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Then he started to teach them. ");
INSERT INTO engPEV_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Jesus said, “Some people know that they need God very much. All right, God will take those people into his family, and they will be really happy. ");
INSERT INTO engPEV_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Some people are very sad now, and they cry, but God will make them feel better, and they will be really happy. ");
INSERT INTO engPEV_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Some people know that they are weak, and they don’t try to be important. But later God will give them everything in the world, and they will be really happy. ");
INSERT INTO engPEV_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Some people really want to live the right way, and they want other people to live the right way too. They think about that more than anything else, like they are really hungry and thirsty for it to happen. All right, God will give them what they want, and they will be really happy. ");
INSERT INTO engPEV_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Some people feel sorry for other people, and they don’t do payback for the bad things those other people did. All right, God will do the same. He will feel sorry for those people that feel sorry for other people. He will not do payback to them for the bad things they did, and they will be really happy. ");
INSERT INTO engPEV_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Some people never want to do bad things. These people will see God, and they will be really happy. ");
INSERT INTO engPEV_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Some people help other people to settle down, stop arguing, and agree with each other. God will tell those people, ‘You are my own kids.’ And they will be really happy. ");
INSERT INTO engPEV_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Some people do what is right, but some other people don’t like it, and they make trouble for those good people. But God takes those good people into his family, and they will be really happy. ");
INSERT INTO engPEV_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","And you too. Some people will not like you following me, and they will say bad things about you, and they will make trouble for you. Sometimes people will tell lies about you. But don’t worry. Be really happy when they do that. ");
INSERT INTO engPEV_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","You see, if they do these bad things to you now, God will give you lots of good things later, in heaven. So you can be really happy, no matter what they do. Remember the stories from a long time ago, about the men that told everyone God’s message. Some people did bad things to those men too.” ");
INSERT INTO engPEV_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesus said, “You people that follow me are like salt for everybody on the earth. You know, salt helps food taste good and stops it from rotting. Well, if you follow me properly, you will live in a way that helps people to be good. Yes, salt is good, but if it stops tasting like salt, then it is no good any more. Nobody can use it for anything. They chuck it away, and everyone walks on it. So don’t be like that sort of salt. Don’t stop following me.” ");
INSERT INTO engPEV_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","And Jesus said, “You people that follow me have to live the right way and show people the way to God. It is like you are a light for everybody in the world. You know, if people build houses up on a hill, then everyone can see them clearly. You are like those houses on a hill. Everyone can see you clearly. They can know if you are good, or if you are bad. ");
INSERT INTO engPEV_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nobody ever lights a candle and then puts a bowl over it. No way. They put that candle up in a high place, so that its light shines out everywhere. ");
INSERT INTO engPEV_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","You have to be like that candle. You have to let everyone see that you are following me. They will see all the good things you do, and they will say good things about God, your father in heaven. They will say, ‘God is really great.’” ");
INSERT INTO engPEV_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesus kept on teaching them. He said, “You know the law that Moses wrote. Well, I didn’t come here to take away that law. And you know all the messages that God gave to his men, the messages that they wrote in his book for us. I didn’t come here to take away those messages either. But I came here to show that the law and those messages are right, and to make those things happen, just like those men wrote. ");
INSERT INTO engPEV_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Listen. God’s book is really important. Everything in it will happen. You know, the earth and sky are always here. They don’t change. Well, just like that, God’s word and his laws will not change, not even a little bit. They will stay the same until everything in God’s book happens. ");
INSERT INTO engPEV_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","So if you think to yourself, ‘I can break just one little rule,’ and if you teach other people to think like that too, then later on, in God’s family in heaven, nobody will respect you. They will say, ‘You are no good.’ But if you don’t break any of God’s rules, and if you teach other people to follow them too, then later on, in God’s family in heaven, everyone will respect you. And they will say, ‘You are really good.’ ");
INSERT INTO engPEV_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","I’m telling you this, if you don’t do everything that God says, then you can’t come into his family. You know that mob called Pharisees. They are really strong for our Jewish law. And you know the mob that teach our Jewish law. Well, you have to follow God’s law better than all of that Pharisee mob and that law teacher mob.” ");
INSERT INTO engPEV_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesus said, “You know, the teachers of God’s law tell you what God told the people, a long time ago. They say, ‘Don’t murder anybody. If you murder somebody, then you have to go to court, and the judge will punish you.’ ");
INSERT INTO engPEV_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","But now I’m telling you this. Don’t even get angry with anybody. That is bad too. If you are angry with somebody, God will be your judge, and he will punish you. Or if you call somebody bad names, you will end up in God’s court. And if you get really angry with somebody, and if you tell them, ‘You are a stupid fool,’ God will judge you for that, and he can send you into the big fire called hell.” ");
INSERT INTO engPEV_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Jesus said to the people, “Suppose you go to give a gift to God, and you take it to God’s ceremony house, but then you remember that somebody is upset with you about something. ");
INSERT INTO engPEV_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","You have to leave your gift there at God’s house, and you have to go and find that other person straight away. You have to tell them that you are sorry, and you have to fix up that problem with them, so that you can both be friends again. After that, you can go back and give your gift to God. ");
INSERT INTO engPEV_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","If somebody blames you and says that you have done something wrong, and if they start to take you to court about it, then you have to talk to that person straight away, and fix up that problem. Both of you have to agree about what is right. Do that even while you are going along the road to the court. If you don’t do that, then that person will blame you in the court, and the judge might agree with them and tell the police to grab you and put you in jail. ");
INSERT INTO engPEV_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","And you will stay in jail until you give that other person all the money that you owe them. That’s for sure.” ");
INSERT INTO engPEV_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesus said, “You know, the teachers of God’s law tell you this, ‘Don’t sleep with a woman that is not your wife, as if you are married to her.’ ");
INSERT INTO engPEV_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","But now I’m telling you this. If you look at a woman that is not your wife, and you think about sleeping with her, that is bad too. If you think about doing that, you are going wrong. Thinking about it is just as bad as doing it. ");
INSERT INTO engPEV_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","You see, if things in your life push you to go wrong, then you have to get rid of them, even if it is hard to do. Be careful about how you use your eyes. If you see something that gets you to go wrong, then stop looking. That might be hard to do, like you are pulling out your eye and throwing it away. But it is better to lose one eye here on the earth now, than to keep 2 eyes and go to the bad place called hell. ");
INSERT INTO engPEV_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","And think about how you use your hand. If you do something with your hand that gets you to go wrong, then pull your hand away. That might be hard to do, like you are cutting off your hand and throwing it away. But it is better to lose one hand here on the earth now, than to keep 2 hands and go to hell.” ");
INSERT INTO engPEV_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Then Jesus said, “And God’s law says, ‘If a man wants to leave his wife, then he can write a divorce letter and give it to her. Then they aren’t married any more.’ ");
INSERT INTO engPEV_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","But now I’m telling you this, husbands and wives have to stay married to each other. Only if a man’s wife sleeps with another man, as if he is her husband, only then can her husband divorce her. But if a wife never does that, then her husband can’t divorce her. If he divorces her, he is forcing her to marry another man and sleep with him, and that is wrong. And the man that marries her is doing wrong too.” ");
INSERT INTO engPEV_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jesus said to the people, “You know, sometimes people promise something to somebody, and to get people to believe them, they say, ‘by God’. That shows that they want God to punish them if they don’t do it. And the law teachers tell you that God said, ‘If you say, “by God”, then you have to do what you promised.’ ");
INSERT INTO engPEV_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","But now I’m telling you this. If you promise something, don’t say, ‘by God’, to get people to believe you. And don’t say, ‘by heaven’, when you promise something. God is the boss in heaven, so that is just like saying, ‘by God’. ");
INSERT INTO engPEV_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","And don’t say, ‘by the earth’, when you promise something. God controls the earth too. And don’t say, ‘by Jerusalem’, when you promise something. Jerusalem is God’s special city. He is the big boss there. ");
INSERT INTO engPEV_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","And don’t say, ‘by my head’, when you promise something. You can’t change the colour of even one hair on your head, to turn it black or turn it white. ");
INSERT INTO engPEV_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Look, just say what is properly true. When yes is the true answer, just say, ‘Yes.’ And when no is the true answer, just say, ‘No.’ The devil, the boss over the bad spirits, he tries to get you to say more than that, but don’t do it. Don’t say anything more to try to get people to believe you.” ");
INSERT INTO engPEV_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesus kept on talking to them. He said, “You know, the teachers of God’s law tell you this, ‘If somebody hits your eye and blinds it, then this is the payback, you have to hit one of that person’s eyes and blind it.’ And the teachers of God’s law say, ‘If somebody knocks out your tooth, then this is the payback, you have to knock out one of that person’s teeth.’ That’s what they say. ");
INSERT INTO engPEV_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","But now I’m telling you this, don’t do payback at all. If somebody does something bad to you, don’t do payback to them. Somebody might hit you on one side of your face. All right, let them hit you on the other side of your face too. ");
INSERT INTO engPEV_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Or if somebody takes you to court to get your shirt, all right, give that person your shirt, and give them your coat too. ");
INSERT INTO engPEV_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Or a soldier might tell you, ‘Carry my bag for a kilometre.’ All right, help him more than that. Carry it for 2 kilometres. ");
INSERT INTO engPEV_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Or if somebody asks you for something, give it to them. Or if they want to borrow something from you, let them have it.” ");
INSERT INTO engPEV_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jesus said, “You know, those teachers tell you this, ‘Love your friends and hate your enemies.’ ");
INSERT INTO engPEV_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","But I’m telling you to do more than that. You have to love your enemies too. And if anyone makes trouble for you, pray to God and ask him to be good to them. ");
INSERT INTO engPEV_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","If you do that, you will be just like your father in heaven. He gets the sun to shine on everybody, bad people as well as good people. And he gets the rain to fall on everybody, good people and bad people too. ");
INSERT INTO engPEV_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","You see, if you only love the people that love you, that is nothing. Even bad people do that. God will not give you anything for only loving people that love you. ");
INSERT INTO engPEV_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","And if you only talk to your friends, that is nothing. Everybody talks to their friends, even people that don’t believe in God do that. So if you only talk to your friends, you are no better than those people. ");
INSERT INTO engPEV_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","So this is what I say. You have to be properly good, just like your father in heaven is properly good.” ");
INSERT INTO engPEV_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesus kept on teaching the people. He said, “If you only do good things so that people will see you and think you are good, God will not do good to you. Instead, you have to do good things and keep them secret. Then your father in heaven will do good things for you. ");
INSERT INTO engPEV_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","You know, there are some people that want everyone to think they are good, even though they are not good. So whenever they give something to help a poor person, they do it in front of the meeting house or on a busy street, so that people will see it and say that they are good. But listen, that is all those people will get. God will not give them anything good for doing that. Don’t be like them. ");
INSERT INTO engPEV_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Whenever you give something to help somebody, don’t tell anyone else about it, not even your best friend. ");
INSERT INTO engPEV_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Keep it a secret. You know, God, your father, always sees what you do in secret, and he will be properly good to you for doing that.” ");
INSERT INTO engPEV_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesus said, “Don’t pray like those people that want everyone to think they are good, even though they are not good. They like to stand up and pray in the meeting houses and on the busy street corners, so that lots of people can see them praying. They want to hear people say, ‘That’s a good person.’ But listen, that is all those people will get. God will not give them anything good for doing that.” ");
INSERT INTO engPEV_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","And Jesus said, “I’ll tell you the right way to pray. Go away from other people to a place where you can be alone, like go into a little room in your house and close the door. There you can pray to God, your father. He is in that secret place. And he sees what you do. He will listen to you, and he will be properly good to you for respecting him. ");
INSERT INTO engPEV_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","And when you pray, don’t keep on talking on and on, with lots of words that don’t mean anything. People that don’t know God, they do that. They think that if they talk a lot, God will hear them. But they are wrong. ");
INSERT INTO engPEV_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Don’t be like them. God, your father, knows what you need already, even before you ask him. ");
INSERT INTO engPEV_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","So pray like this, ‘God, our father, you live in heaven. We want everyone to respect you. ");
INSERT INTO engPEV_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","We want you to be everyone’s boss. We want everyone in the world to do what you want, just like everyone in heaven does what you want. ");
INSERT INTO engPEV_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Please give us the food that we need each day. ");
INSERT INTO engPEV_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Please don’t punish us for the bad things that we did, just like we don’t do payback to the people that did bad things to us. ");
INSERT INTO engPEV_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Don’t let anything push us to do bad things. And keep us safe from the devil, the boss over the bad spirits.’” ");
INSERT INTO engPEV_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Then Jesus said, “If you don’t do payback to other people for the bad things they do to you, God, your father in heaven, will not do payback to you for the bad things you do. ");
INSERT INTO engPEV_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","But if you do payback to other people, your father will do payback to you. He will punish you for the bad things you do.” ");
INSERT INTO engPEV_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jesus kept on teaching the people. Some of those people used to stop eating for a while, so they can think about God and respect him. Jesus said, “Whenever you stop eating for a while, make sure you look the same as you always look. You know, there are some people that want everyone to think they are good, even though they are not good. Whenever they stop eating food to respect God, they want everyone to know what they are doing, so they let their faces get dirty, and they try to look sad. They want people to say, ‘That’s a good person.’ But listen, that is all those people will get. God will not give them anything good for doing that. Don’t be like them. ");
INSERT INTO engPEV_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","When you stop eating for God, just be normal and look the same as you always look. Wash your face and comb your hair. ");
INSERT INTO engPEV_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Then nobody will know that you have stopped eating. But God your father knows. Nobody can see him, but he sees everything you do. He will see what you do in a secret way, and he will be properly good to you for it.” ");
INSERT INTO engPEV_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","20","Jesus said, “If you have a lot of money and other good things here in this world, don’t try to keep them all for yourself. No. But give them away to people that need them. When you do that, it’s like you give them to God, and he will keep them for you in heaven. You see, here in this world you might lose them. There are things here that might eat them, like grubs or white ants. Or your good things might go rusty. Or somebody might steal them. But nothing will eat them in heaven, and they will not go rusty in heaven, and nobody there will steal them. ");
INSERT INTO engPEV_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","You see, you will always think about the place where you keep your money and your good things. If they are here in this world, you will only live for the things of this world. But if you give them to God in heaven, then you will live for God.” ");
INSERT INTO engPEV_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Then Jesus told them this picture story. He said, “Your eyes are like lights for your body. They show you where to go. If you always want to look at good things, then you will think about good things, and you will live God’s way. It will be like God is shining his light for you, to help you live his way. ");
INSERT INTO engPEV_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","But if you always want to look at bad things, then you will think about bad things, and you will be spiritually blind, and you will not live God’s way. It will be like you are living in the dark. And if you are spiritually blind, with no light from God, it will be really bad for you.” ");
INSERT INTO engPEV_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","And Jesus told them another picture story. He said, “You can’t work for 2 bosses at the same time. If you try to do that, then you will only like one boss, and you will always work properly for him. But you will not like the other boss, and you will never work properly for him. You see, you can’t have God as your boss, and money as your boss, both at the same time.” ");
INSERT INTO engPEV_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jesus said, “So I’m telling you, even though you need some things to stay alive, don’t worry about them. Don’t worry about what you will eat or drink. Don’t worry about the clothes you will wear. Your life is more important than food, and your body is more important than clothes. ");
INSERT INTO engPEV_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Think about the birds. They don’t put seeds into the ground to grow a garden, to get their food from it. And they don’t build sheds to keep their food in. But God, your father, gives them food anyway. And you are much more special to God than birds, so you can trust him to give you the food you need. ");
INSERT INTO engPEV_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","And don’t worry about how long you will live, or when you will die. No matter how much you worry about it, you will not live any longer, not even one day longer. ");
INSERT INTO engPEV_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","29","And don’t worry about your clothes. Listen. You know the story about Solomon. He was a very rich man, and he lived a long time ago. He wore very pretty clothes. Well, think about the wild flowers in the bush. They don’t work hard to get clothes for themselves. But those wild flowers are more pretty than Solomon’s clothes. ");
INSERT INTO engPEV_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","You see, we might think the grass and the wild flowers are rubbish, and anybody might burn them up at any time. But God makes them very pretty anyway. So God will give you the clothes you need. You have to trust God properly, and he will take care of you. ");
INSERT INTO engPEV_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","So don’t keep on asking yourself, ‘Where will I get my food? And where will I get my drink? And where will I get clothes to wear?’ ");
INSERT INTO engPEV_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Listen, God is your father in heaven, and he knows that you need these things. People that don’t know God are always worrying about those things, but you shouldn’t worry about them. ");
INSERT INTO engPEV_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Think, instead, about the things that are good for God’s family, and try to do the good things that God wants you to do. Then God will give you all those other things that you need. ");
INSERT INTO engPEV_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","So don’t worry about how to get what you will need tomorrow. Each day has enough problems of its own. When tomorrow comes, then you can think about those things.” ");
INSERT INTO engPEV_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesus said to the people, “Don’t say to anybody, ‘You are bad,’ and then God will not say to you, ‘You are bad.’ ");
INSERT INTO engPEV_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","God will judge you the same way as you judge other people. If you are easy on other people, God will be easy on you. But if you are hard on other people, God will be hard on you. ");
INSERT INTO engPEV_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","You shouldn’t always try to tell other people they are doing bad things. First, you have to think about all the bad things that you do, and you have to stop doing those bad things. Then maybe you can help other people to stop doing bad things too. Maybe you are doing lots of bad things, and your friend is just doing one little bad thing. If you are still doing lots of bad things, you can’t help them stop doing that little bad thing. It’s like this. All those bad things you do are making you blind, like you have a big bit of wood in your eye. And maybe your friend is just doing one little thing wrong, like they just have a little splinter of wood in their eye. You have to take that big bit of wood out of your eye, so that you can see properly, then maybe you can help your friend get that little splinter out of their eye.” ");
INSERT INTO engPEV_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Jesus kept on talking to them. He said, “There are some things that belong to God. Don’t give those things to people that don’t like God. Those people are like dogs. If you give them God’s things, they will rubbish them, and then they will turn around and bite you, just like dogs. And some of God’s things are really special. Don’t give them to people that don’t know that those things are special. They will rubbish those things. They will be just like pigs that don’t know good things. They will walk on them and push them into the mud.” ");
INSERT INTO engPEV_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesus kept on teaching the people. He said, “Whenever you need something, you have to keep asking God for it, and he will give it to you. Keep looking for whatever you need, and God will let you find it. Maybe something will block you, so you can’t get what you need, like there is a door that is shut and you can’t get through it. Well, then keep on knocking at that door, and God will open it for you. ");
INSERT INTO engPEV_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Everyone that asks God for something will get it. Everyone that looks for something will find it. God will open the door for everyone that knocks on it. ");
INSERT INTO engPEV_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","It’s like this. If your son asks you for some bread, will you give him a stone? No way. ");
INSERT INTO engPEV_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Or if your son asks you for a fish, will you give him a cheeky snake? No way. ");
INSERT INTO engPEV_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","You see, you might be bad, but you give good things to your kids. Well, your father in heaven is a lot better than you. He is always good, so he will always give good things to people that ask him.” ");
INSERT INTO engPEV_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Jesus said, “You know the way you want other people to treat you. Well, you have to treat other people that same way. You have to live like that all the time. That is a short way of saying the message that is in God’s book. It is what God’s law is all about, and it is what God got his men to write about in his book. You have to always treat other people the same way that you want people to treat you.” ");
INSERT INTO engPEV_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Then Jesus told them this picture story about how to live. He said, “It is like there are 2 tracks in life, and each track has its own gate. One gate is big and wide, but the other gate is a narrow little gate. It is hard to get through that little gate, and only a few people get through it. Listen, you have to go through that little gate. If you want to live with God for ever, you have to pick that little gate and go through it, and you have to follow its track. Its track is a narrow little track, and it is hard to walk on. But if you go that way, you will live with God for ever. The other gate is wide and easy to go through, and its track is wide and easy to walk on. A lot of people go that way. They go through that wide gate and walk along that easy track. But that track goes to the wrong place, and God will finish up those people.” ");
INSERT INTO engPEV_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Then Jesus told them, “Always be careful. Don’t believe everybody. There are some people that reckon they are telling you a message from God, but they are liars. They try to get you to think they are like sheep, like they are soft and will not give you any trouble. But really, they are like wild dingoes. They will give you trouble, like dingoes hurt sheep. If you believe their words, then you will get lots of trouble. ");
INSERT INTO engPEV_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","If you look at the things these people do, you can find out if they are talking true words, or if they are liars.” Then Jesus told a picture story. He said, “Think about the trees that give us fruit to eat. We can’t get good fruit from rubbish trees. We can’t get grapes from rubbish plants. ");
INSERT INTO engPEV_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Good fruit grows on a good tree. Rubbish fruit grows on a rubbish tree. ");
INSERT INTO engPEV_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","A good tree can’t make bad fruit. A bad tree can’t make good fruit. ");
INSERT INTO engPEV_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","If a farmer has a tree that only makes rubbish fruit, he will cut down that tree and burn it in a fire. ");
INSERT INTO engPEV_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","So, to find out if a person is good or bad, look at what they do. A good person does good things. And a bad person does bad things.” ");
INSERT INTO engPEV_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","And Jesus said, “Lots of people call me, ‘My leader and my boss,’ but some of them will never be in God’s family. God will only have people that do what he wants them to do. God will have those people in his family, but not the other people. God is my father in heaven. ");
INSERT INTO engPEV_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","One day, God will get me to judge everybody, and some people will say to me, ‘You are my leader and my boss. We used your power to tell people your messages, and to force bad spirits out of people, and to do a lot of other great things.’ ");
INSERT INTO engPEV_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Then I will tell them, ‘I don’t know you mob. You are bad. You don’t do what God wants. So get away from me.’” ");
INSERT INTO engPEV_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Then Jesus told them 2 more picture stories. He said, “If you listen to my message, and if you do what I say, you are like a wise man that built his house on hard rock. ");
INSERT INTO engPEV_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Then a lot of rain came and made big flood waters that flowed along really fast, and that water hit that house, and strong winds blew hard against that house. But that house didn’t fall down. He built it on hard rock, so it stayed strong. You see, if you do what I say, you will be like the wise man in that picture story. ");
INSERT INTO engPEV_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","But if you hear my message and you don’t do what I say, you are like a stupid man that built his house on soft sand. ");
INSERT INTO engPEV_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Then a lot of rain came and made big flood waters that flowed along really fast, and that water hit that house, and strong winds blew hard against that house. Then that house fell down, and it broke up into little bits. You see, if you don’t do what I say, you will be like the stupid man in that picture story.” ");
INSERT INTO engPEV_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Then Jesus finished talking to that big mob of people. They were really surprised as they listened to what he told them. ");
INSERT INTO engPEV_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","You see, they knew he told them God’s word properly. He knew what he was talking about. Their law teachers never talked like that. ");
INSERT INTO engPEV_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesus went to a town called Capernium. There was a Roman army boss there. He was the boss over 100 soldiers. He went to Jesus and strongly asked him for help. ");
INSERT INTO engPEV_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","He said, “Sir, my young work-man is lying in bed at home. He can’t move, and he is hurting a lot.” ");
INSERT INTO engPEV_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesus said, “I will go with you and make him better.” ");
INSERT INTO engPEV_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","But the army boss said to Jesus, “Sir, I’m not good enough for you, so it will not be right for you to go into my house. But you can make him better from right here. You can tell that sickness to stop, and leave my work-man, and then he will get better straight away. ");
INSERT INTO engPEV_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","I know it will happen. You see, I know about bosses. I have a boss over me, and I’m the boss over a lot of soldiers. If I tell a soldier to go somewhere, he goes there. And if I tell one of them to come to me, he comes to me. And if I tell my work-men to do something, they do it. Well, I believe that you are a powerful boss. If you just tell that sickness to go, then my work-man will get better straight away.” ");
INSERT INTO engPEV_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesus heard what that Roman army boss said, and he was very surprised. He said to the people that were following him, “Listen. This man is not one of you Israel mob, but he trusts me more than any of you Israel people.” ");
INSERT INTO engPEV_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Then Jesus told them about something that will happen one day. He said, “Listen. You know that God picked you Israel mob to be his special people. But one day, a lot of other people will come from everywhere in the world, and they will join God’s family in heaven. God will put on a big dinner there for his family, and these other people will sit down and eat it with Abraham, and Isaac, and Jacob. They are your grand-fathers that lived a long time ago. ");
INSERT INTO engPEV_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","But a lot of Israel people will not eat any of it. God will grab them and chuck them out. They will be very upset and angry. They will cry a lot, and they will be so angry that they will bite their teeth together.” ");
INSERT INTO engPEV_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Then Jesus said to the army boss, “You can go back home now. You are trusting me to make your work-man better, so I am doing it.” And right then, at that same time, that army boss’s work-man got better. ");
INSERT INTO engPEV_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","At another time Jesus saw a big mob of people coming around him, so he told his followers to take him in a boat to the other side of the lake. ");
INSERT INTO engPEV_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","After they got there, a Jewish law teacher went to Jesus and said, “Teacher, I want to be one of your followers. I will go everywhere with you.” ");
INSERT INTO engPEV_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesus said to him, “Wild dogs have places where they can sleep, and wild birds have nests they can sleep in. But I haven’t got a home to lie down and sleep in, even though I’m God’s special man from heaven.” ");
INSERT INTO engPEV_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","There was another man that was already a follower of Jesus. He said to Jesus, “Sir, I will come with you. But my father has died, so let me go home to bury him. After that, I will come with you.” ");
INSERT INTO engPEV_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesus said to him, “No. You come and follow me now. You see, some people are spiritually dead, so they can bury the dead bodies of their own people. But you come and follow me.” ");
INSERT INTO engPEV_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesus was walking along, and 2 blind men followed him. They kept on shouting to him, “You belong to David’s family, and you are the special man that God promised to send. Please, feel sorry for us, and help us.” ");
INSERT INTO engPEV_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesus went into a house, and the blind men went to him. He asked them, “Do you believe that I can make your eyes good, so you will see again?” The men said, “Yes, sir, we believe that you can do that.” ");
INSERT INTO engPEV_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Then Jesus touched the men’s eyes and said, “You believed in me, so you will see again.” ");
INSERT INTO engPEV_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Then straight away, those men could see again. Jesus told them strongly, “Don’t tell anybody about this.” ");
INSERT INTO engPEV_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","But they went away and told everybody in that country that Jesus made their eyes better. ");
INSERT INTO engPEV_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jesus and his followers started to walk along the road away from that place. Then some people brought a man to Jesus that had a bad spirit living inside him, so he couldn’t talk. ");
INSERT INTO engPEV_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesus said to that bad spirit, “Get out of this man.” Then the bad spirit went out of that man, and he started to talk. Everybody there was very surprised. They said, “Nothing like that ever happened before in our country, called Israel.” ");
INSERT INTO engPEV_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jesus said to his followers, “Lots of people need to hear about me. They are ready to listen, but nobody is telling them. They are like a big crop of food plants on a farm that are ready for the workers to get their seeds for food. But there are only a few workers. The farmer needs a lot of workers to bring all those seeds into the shed, and in the same way I need a lot of workers to tell people about me, and bring them to God. ");
INSERT INTO engPEV_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","So you have to ask God to send more workers out to tell everyone about me, just like the farmer has to ask for more workers for his crop.” ");
INSERT INTO engPEV_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Jesus told his followers, “You know about students and teachers. The teacher is more important than any of the students. The students have to learn to be like their teacher. And I am your teacher, so you have to learn to be like me. And you know about workers and their boss. The boss is more important than any of the workers. The workers have to learn to be like their boss. And I am your boss, so you have to learn to be like me. People will treat you the same way as they treat me. I am your leader, and they lie about me. They call me the boss over the bad spirits. And you are my followers, so they will say bad things about you too, more than they say about me. ");
INSERT INTO engPEV_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","But don’t be frightened of them. You see, people might do things secretly now, but later God will let everyone know what they do. People hide things now, but later God will show them to everybody. ");
INSERT INTO engPEV_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","And think about the message I tell you now. Sometimes I tell you something when nobody else is here. I might even just say it quietly in your ear. But later on, I want you to tell my message to everyone in the world. If you can, get up on a high place, and shout my words out loud, for lots of people to hear. ");
INSERT INTO engPEV_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Don’t be frightened of those people that can only kill your body. They can’t kill your soul. But you have to listen to God. If you don’t do what he says, you have to be frightened. He can finish up your body, and then he can also finish up your soul too, in that bad place called hell. ");
INSERT INTO engPEV_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Think about those little birds called sparrows. They don’t cost very much. You can buy them for a few dollars. But God remembers each one of them anyway. And if one of them falls down to the ground, God knows about it. ");
INSERT INTO engPEV_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Well, you are more important to God than a big mob of those birds, so don’t be frightened. He knows you properly. He even knows how many hairs you have on your head. So he will only let things happen to you that will be good for you.” ");
INSERT INTO engPEV_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jesus said, “If you tell everyone that you are one of my followers, I will tell God, my father in heaven, that you are one of my followers. ");
INSERT INTO engPEV_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","But if you tell everyone that you are not one of my followers, I will tell God, my father in heaven, that I don’t know you, and I will tell him that you are not one of my followers. ");
INSERT INTO engPEV_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Don’t think that I came into the world to get everyone to agree with each other. No. People will not agree about me, and some people will fight the people that they don’t agree with. It will be like this, ");
INSERT INTO engPEV_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Maybe your own family will not want me, and they will turn against you and be your enemies. A man will be the enemy of his father. A daughter will be the enemy of her mother. A woman will be the enemy of her mother-in-law. ");
INSERT INTO engPEV_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","You see, you have to love me more than you love your own father and mother. Then it is all right for you to be my follower. And you have to love me more than you love your own son or daughter. Then it is all right for you to be my follower. If you don’t love me like that, you are not the right person to be my follower. ");
INSERT INTO engPEV_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","If you want to follow me properly, you have to stop thinking only about yourself. You have to live like me. You have to be ready to die, yes, to die like a criminal on a cross, just like me. ");
INSERT INTO engPEV_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","If you only want to look after your own life here on earth, you will lose it. You will not live with me for ever. But if you are ready to give up your life here, then you will find real life, and you will live with me for ever.” ");
INSERT INTO engPEV_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesus finished talking to his 12 special workers, then he went around the towns in Galilee country. He talked to people and taught them more about God. ");
INSERT INTO engPEV_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","At that time, John the Baptiser was in jail. But people told him about all the things that Jesus was doing. So John sent some of his own followers to ask Jesus some questions. ");
INSERT INTO engPEV_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","They went to Jesus and said to him, “John the Baptiser has sent us to you. He wants us to ask you, ‘Are you the special man that God has sent to us? Or do we have to start looking around for somebody else?’” ");
INSERT INTO engPEV_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus said, “Go back and tell John what you see here. ");
INSERT INTO engPEV_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Some people were blind, but now they can see. Some people were crippled, but now they can walk. Some people had a bad skin sickness, but now their skin is good again. Some people were deaf, but now they can hear. Some people were dead, but now they are alive again. And tell John that you heard us telling the good news to poor people. ");
INSERT INTO engPEV_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Maybe I’m not the sort of person you thought God would send, but just trust me anyway, and God will make you happy.” ");
INSERT INTO engPEV_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Then the followers of John went away, and Jesus started to talk to all the people. He talked to them about John. He said, “You know, you went out into the bush to see John. What sort of man did you think you would see? You didn’t go out there to see a man that is weak, like grass that goes any way the wind pushes it. ");
INSERT INTO engPEV_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","And you didn’t go out there to see a man wearing pretty clothes. No, men that wear pretty clothes live in the town, in good big houses. ");
INSERT INTO engPEV_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Did you go out there to see a man that tells people God’s messages? Yes, John the Baptiser told you God’s message, and he did something even more important than that. ");
INSERT INTO engPEV_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","You see, a long time ago, God got one of his men to write about somebody that will get everything ready. God’s man wrote about John the Baptiser. We can read it in God’s book. This is what it says, ‘God will send a man to get everything ready for God’s special person. That man will talk about God’s special person, and he will make a way for people to listen to him.’” ");
INSERT INTO engPEV_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Then Jesus said, “Listen. John the Baptiser is a very important man. He is greater than any other man that ever lived. But everyone in God’s family is more important than John the Baptiser. ");
INSERT INTO engPEV_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","You know, John started to teach some time ago, and from that time until now, God’s family has been getting bigger. There are people that really want to be friends with God, and they have been trying hard to get into his family. ");
INSERT INTO engPEV_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","You see, before John came, God told his words and his laws to his men, and they wrote them in God’s book. And you know, that was a long time ago, but they wrote about the things that will happen now, at this time. ");
INSERT INTO engPEV_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Look. Try to believe this. They wrote about John, but they didn’t use that name for him. They called him Elijah.” ");
INSERT INTO engPEV_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","And Jesus said, “You’ve got ears, so you have to listen to me properly, and take notice of my words.” ");
INSERT INTO engPEV_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Then Jesus said, “Now I’ll talk about you people that are alive today and I’ll tell you what you are like. You are like kids that are playing in the street. Some kids say to the other kids, ");
INSERT INTO engPEV_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘We played happy music for you, but you didn’t dance. So we sang a sad song, but you didn’t cry. No matter what we do, you say we are wrong.’ ");
INSERT INTO engPEV_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Those kids are a picture of you mob. You are just like those kids. You rubbish God’s people no matter what they do. You see, John the Baptiser didn’t go to parties and eat lots of good food, and he didn’t drink wine. But you rubbished him and said, ‘He’s got a bad spirit living inside him.’ ");
INSERT INTO engPEV_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","But sometimes I go to parties and eat good food, and sometimes I drink wine, and even though I’m God’s special man from heaven, you rubbish me too. You say, ‘He eats too much, and he drinks too much. He’s a friend of those bad men that get tax money from people and give it to the Roman government, and he’s a friend of other bad people that don’t follow the law properly.’ But really, John and me, we are both wise. And you can know if somebody is wise or not. Just look at what they do, and see if they do good things or not.” ");
INSERT INTO engPEV_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","At that time, Jesus prayed to God. He said, “Father, you are the biggest boss. You are the boss over everything in the sky and everything on the earth. There are some people here that reckon they are smart, and they reckon they understand everything. And there are other people that are just like little kids. They know that they are not smart. Thank you for showing what your message means to those people that are like kids. And thank you for not showing it to those people that reckon they are smart. ");
INSERT INTO engPEV_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yes, Father, that is how you wanted to do it.” ");
INSERT INTO engPEV_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Then Jesus told the people, “God, my father, gave me everything, so I can teach people all about him. You see, I am God’s son, and my father knows me properly. Nobody else knows me properly. And I know my father properly. I pick some people, and I show them what my father is like, but nobody else knows God properly.” ");
INSERT INTO engPEV_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Then Jesus said to the people, “Come to me, all of you mob that are tired. You did a lot of ceremony things to get God to save you, but that is not the right way. It’s like you worked hard, and you carried a lot of heavy things, and then you got too tired. Look, instead of that, just come and work for me, and I will let you rest really good. ");
INSERT INTO engPEV_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Be my follower and work for me. Listen to the things I teach you, and you will feel good inside yourselves, like your spirit is resting. You see, I am not a big tough boss. I will be easy on you. ");
INSERT INTO engPEV_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","I will never ask you to do things that are too hard for you.” ");
INSERT INTO engPEV_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Big mobs of people followed Jesus. Some of them were sick, and he made them better. ");
INSERT INTO engPEV_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","But he told them straight, “Don’t go and tell other people about me.” ");
INSERT INTO engPEV_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","A long time ago, God got his man called Isaiah to write about this, and it is in God’s book. It happened just like Isaiah said. This is what he wrote, ");
INSERT INTO engPEV_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“This is the man that God picked to work for himself. God loves him, and he makes God very happy. God will put his spirit in him, and he will tell the people in other nations that God is right and fair. ");
INSERT INTO engPEV_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","He will not fight with anyone or shout at people. Nobody will hear him shouting in the streets. ");
INSERT INTO engPEV_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Some people are weak, like a bit of grass that is almost broken, and some people can’t help themselves, like a candle wick that has almost gone out. He will not forget those people, but he will help them to get strong. He will keep on being right and fair to everyone, until people are fair to each other too. ");
INSERT INTO engPEV_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","And people everywhere will believe that he can save them.” ");
INSERT INTO engPEV_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","One day, some Jewish law teachers, and some of the Pharisee mob, that were strong for the Jewish law, they went to Jesus and said, “Teacher, we want to see you do something powerful. That will show us that God sent you.” ");
INSERT INTO engPEV_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesus said, “You mob that are alive today are really bad. You turned away from God. But now you want me to show you something powerful, right? No. I will not do that. The only powerful thing you will see is the same thing that God did to Jonah. He was one of God’s men. ");
INSERT INTO engPEV_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Think about that story from a long time ago. A big fish swallowed Jonah, and he stayed inside that fish for 3 days. And just like that, I will stay in the ground for 3 days. I am God’s special man from heaven. ");
INSERT INTO engPEV_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jonah went to the people that lived in the city called Nineveh, and he told them God’s message. Those people listened to him, and they stopped doing bad things and turned to God. Well, later, on the day when God will judge everyone, that Nineveh mob will get up and tell you mob here that you are wrong. You see, that Nineveh mob listened to Jonah. And I am greater than Jonah, but you mob don’t listen properly to me. You don’t turn to God, and you don’t stop doing bad things. ");
INSERT INTO engPEV_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","And think about the story about the woman from Sheba. She was the big boss over that country. One day, she heard about Solomon. He was the big boss over our country. She heard that he was a very wise man, so she came here to listen to the good things he said. Well, later, on the day when God will judge everyone, that woman will get up and tell you mob here that you are stupid. You see, she came a long way from her country just to listen to Solomon. And I am more wise than Solomon, but you mob don’t want to listen to me.” ");
INSERT INTO engPEV_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","And Jesus said, “When a bad spirit goes out of a person, it goes around in dry country looking for a new place to live. But it doesn’t find a good place. ");
INSERT INTO engPEV_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","So it says to itself, ‘I will go back to the place where I lived before.’ Then it goes back to that person, and it finds the place is good, empty, and clean. ");
INSERT INTO engPEV_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Then the bad spirit goes out and gets 7 other bad spirits that are worse than itself. And they all go into the person, and they live there. Then that person has more bad spirits than before, so that person is worse than before. Listen, I’m talking about you mob here today. You don’t listen to me, so you are worse now than you were before I came.” ");
INSERT INTO engPEV_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Then Jesus told the people another picture story. He said, “This story shows you something about God’s family. A farmer planted some good food seeds in his garden. ");
INSERT INTO engPEV_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","But there was a bad man that didn’t like that farmer. One night, when everyone was asleep, that bad man went to the farmer’s garden and planted some rubbish plant seeds in it, beside the good seeds. Then that bad man went away. ");
INSERT INTO engPEV_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","The good seeds grew into good plants, but at the same time the rubbish plants started to grow there too. Those rubbish plants look like the good plants when they are young, but when they get big we can’t eat their seeds. They are too cheeky. ");
INSERT INTO engPEV_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","So the farmer’s workers went to him and said, ‘Boss, you planted good food seeds in that ground. How come a lot of rubbish plants are growing there too?’ ");
INSERT INTO engPEV_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","The farmer said, ‘I reckon there is a bad man that doesn’t like me, and he planted those rubbish plants.’ The workers said, ‘Do you want us to go and pull up those rubbish plants?’ ");
INSERT INTO engPEV_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","The farmer said, ‘No, don’t do that. Those plants are all mixed together, so if you pull up the rubbish plants, then you will pull up some of the good food plants with them. ");
INSERT INTO engPEV_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","No. Just let them all grow up, the good plants and the rubbish plants together. Later, when the right time comes, I will get some men to get the good seed food. But I will talk to them before they do that job. I will tell them to cut down the rubbish plants first, and take them away, and burn them. After that, they will get all the good seed food and bring it into my shed.’” ");
INSERT INTO engPEV_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Then Jesus went into a house, away from all the people. And his followers went to him and said, “Please tell us what that story means, that picture story about the rubbish plants and the garden.” ");
INSERT INTO engPEV_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesus said to them, “I’m God’s special man from heaven, and I’m like the farmer in that story. I’m like the man that planted good food seeds in a garden. ");
INSERT INTO engPEV_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","That garden is like the world. The good food seeds are like the people that belong to God. The rubbish plant seeds are like the people that belong to the devil, the boss over the bad spirits. ");
INSERT INTO engPEV_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","The bad man that planted those rubbish seeds in the garden is like the devil. The time to get all the good seed food is like the time for the end of the world. The workers that cut down the plants are like God’s angel messengers. ");
INSERT INTO engPEV_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","And in the story the workers cut down the rubbish plants and burned them in the fire. That is a picture of what will happen at the end of the world. ");
INSERT INTO engPEV_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","You see, I’m God’s special man from heaven, and at the end of the world, I will send out God’s angel messengers. They will get the people that belong to the devil. They will get all the people that don’t belong in God’s family. Those people are the ones that break God’s law, and they make other people do bad things. ");
INSERT INTO engPEV_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","The angels will chuck all those bad people into a big fire. Those people will cry, and they will be so angry that they will bite their teeth together. ");
INSERT INTO engPEV_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","But at that time God will show everyone that the good people are really great. It will be like they are shiny, like the sun. And they will be in the family of God, their father.” Then Jesus said, “You’ve got ears, so you have to listen to me properly, and take notice of my words.” ");
INSERT INTO engPEV_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesus told his followers another picture story. He said, “This story shows you more about God’s family. A man buried a lot of gold in the ground, to hide it. Some time later, another man found that gold, but he didn’t own the land, so he couldn’t get it for himself. So he buried it again. Then he went away, and he sold everything that he owned, to get some money. Then he bought that land. After that, he got all that gold for himself, and he was really happy. Well, if you find out how to get into God’s family, it is like you find a lot of gold.” ");
INSERT INTO engPEV_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jesus talked some more. He said, “This is another picture story that shows you about God’s family. There was a man that used to buy things, and then take them to another place and sell them again at a higher price. That was his job. One day, he was looking for beautiful pearls to buy. ");
INSERT INTO engPEV_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","He found a really good and beautiful pearl, but its price was very high. So he sold everything that he owned, to get enough money for it. Then he bought that very good pearl. Well, if you find out how to get into God’s family, it is like you find a very good pearl.” ");
INSERT INTO engPEV_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Then Jesus said, “This is another picture story that shows you about God’s family. Some fishermen threw their fishing net into the water and caught a lot of fish in it. There were all sorts of fish in that net. ");
INSERT INTO engPEV_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Then they dragged it up on to the land, and sat down, and sorted out the fish. They put the good fish into baskets to keep them, and they chucked the bad fish away. ");
INSERT INTO engPEV_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","That’s what it will be like when God will finish up this world. His angel workers will come and sort everybody out. They will save good people, and they will chuck the bad people into a big fire. Those people will cry a lot, and they will be so angry that they will bite their teeth together.” ");
INSERT INTO engPEV_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Then Jesus asked his followers, “Do you understand all these things?” They said, “Yes, we do.” ");
INSERT INTO engPEV_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Then Jesus said, “Every teacher of our Jewish law that joins God’s family will teach new messages from God as well as old messages. Every teacher of God’s word is like a man that owns a big house. That man has a store-room in that house, where he keeps his very special things. Sometimes he brings those things out to show to his friends. He shows them new things, as well as old things.” ");
INSERT INTO engPEV_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesus and his followers went and stayed in the town called Capernium. There were some men that worked in God’s ceremony house. Every year, all the Jewish people had to pay tax money to those men. They used that money to look after God’s ceremony house. Those men went to Peter and asked him, “Is your teacher going to pay the tax money for God’s ceremony house?” ");
INSERT INTO engPEV_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peter said, “Yes.” Then Peter went into the house where they were staying, to talk to Jesus about it. But Jesus talked first. He said, “Peter, think about the big bosses in this world. They take money from people, but what do you reckon? Do they take it from their own mob, or do they take it from other people?” ");
INSERT INTO engPEV_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peter said, “They take money from other people, not from their own mob.” Then Jesus said, “All right, that means their own families don’t have to pay anything. And we are God’s family, so we don’t have to pay money for God’s house. ");
INSERT INTO engPEV_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","But we don’t want to make those tax men angry. So get a fishing line, and go down to the lake, and throw in the line to catch a fish. Get the first fish that you catch, open its mouth, and you will find a gold coin inside it. Take that coin, and give it to those tax men. It will be enough money for both my tax and your tax.” ");
INSERT INTO engPEV_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesus told his followers, “If another one of my followers does something wrong to you, then you have to go to them and talk about it. Just the 2 of you can talk about it together, while you are alone. If they listen to you, and if they agree with you, then you can call them your friend again. ");
INSERT INTO engPEV_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","But if they don’t want to listen to you, then take one or 2 other people with you, and go to that person. These other people will hear you talk about the wrong things that person did, and they will hear what that person says, and they will find out what is true. ");
INSERT INTO engPEV_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","If that person will not listen to all of you, then go to the church, and tell the people in the church what happened. Let them sort it out and talk to that person. If that person doesn’t want to listen to them, then you can treat them like somebody that doesn’t follow me. They are like somebody that doesn’t know God, or like somebody that doesn’t do what God says.” ");
INSERT INTO engPEV_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Then Jesus told his followers, “Listen. You are the people that will know what God wants. If you all agree that something here on this earth is wrong, it will be something that God in heaven already said is wrong. And if you all agree that something here on this earth is all right, it will be something that God in heaven already said is all right. ");
INSERT INTO engPEV_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","I’m telling you this again. If you agree together about something, even if it is only 2 of you, and then you ask my father in heaven to do that thing, then he will do it for you. ");
INSERT INTO engPEV_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","You see, if you get together to respect me, I will be right there with you, even if it is only 2 or 3 of you at that time.” ");
INSERT INTO engPEV_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Then Peter went up to Jesus and said, “Teacher, if somebody is always doing wrong things to me, how many times do I have to forget it and not do payback to that person? If I forget it 7 times, is that enough? Then if they do another wrong thing, I can do payback, right?” ");
INSERT INTO engPEV_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus said, “No, not 7 times, but I say lots of times, like 77 times.” ");
INSERT INTO engPEV_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","24","Then Jesus told them a story. He said, “I will tell you a picture story to show you what it’s like in God’s family. There was a big boss that loaned some money to his workers. After a while he wanted them to give it back. So he started to check up on them, and he got his soldiers to bring those workers to him. They brought a work-man that borrowed a real lot of money, like millions of dollars, and the boss said, ‘Give me that money now.’ ");
INSERT INTO engPEV_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","The work-man said, ‘No, not yet. I haven’t got any money right now.’ The big boss was angry. He wanted to get some money back, so he told his soldiers, ‘Grab this man, and his wife, and his kids, and all his things, and sell them to another man. He will make them work for no pay.’ ");
INSERT INTO engPEV_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Then the work-man got down on his knees in front of the big boss and said to him, ‘Please, please give me more time, then I will give you back all your money.’ ");
INSERT INTO engPEV_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Then the big boss felt sorry for his work-man, and he changed his mind, and he said, ‘All right, you don’t have to give that money back to me. I’ll forget it. You can go free now.’ ");
INSERT INTO engPEV_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","But after that, his work-man went away, and he met another man. Before this time, that other man borrowed a little bit of money from the work-man, just 100 dollars. So the work-man grabbed that other man’s neck and said, ‘Give me back that money right now. It’s my money.’ ");
INSERT INTO engPEV_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","That other man went down on his knees and said, ‘Please, please give me more time. Then I will give you back your money.’ ");
INSERT INTO engPEV_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","But the work-man said, ‘No way. I will not forget what you owe me.’ And he put that man in jail, and he told the boss over the jail to keep him there until he gives back all of that money. ");
INSERT INTO engPEV_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Some of the other workers saw what happened, and they were not happy about it. So they went to the big boss and told him all about it. ");
INSERT INTO engPEV_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Then the big boss got the work-man to come in, and said to him, ‘You are really bad. You asked me to forget about all my money that you borrowed. It was millions of dollars. And I was good to you. I said that you didn’t have to give it back to me. ");
INSERT INTO engPEV_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","So now you have to feel sorry for that other man and be good to him, just like I felt sorry for you.’ ");
INSERT INTO engPEV_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","The big boss was really angry, and he told the soldiers to grab that work-man, to beat him up, and to put him in jail. He will stay there until he can give all that money back to the big boss.” ");
INSERT INTO engPEV_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Then Jesus said, “It’s like that with you too. You have to be good to all my other followers. If they do something bad to you, don’t do payback to them. Just forget it. Then, in the same way, my father in heaven will not do payback to you.” ");
INSERT INTO engPEV_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesus said to his followers, “This picture story is about the people that will be in God’s family. There was a man that owned a garden, and he wanted some work-men to get a job finished in one day. So he went out early in the morning, to the place in the town where men waited around looking for a job. ");
INSERT INTO engPEV_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","He talked to the men there, and they agreed to work for him. He agreed to give them the right pay, the pay that men always get for a day’s work. Then he sent them to work in his garden. ");
INSERT INTO engPEV_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","At 9 o’clock in the morning he went again to that place in the town, and he saw some other men standing around doing nothing. ");
INSERT INTO engPEV_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","So he gave each of them a job too. He told them, ‘Come and work in my garden today, and I will pay you the right money at the end of the day.’ ");
INSERT INTO engPEV_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","So they went to work in his garden. Then, in the middle of the day, the boss went to that place in the town again. And he found some more men there, and he did the same for them. He gave them jobs. At 3 o’clock in the afternoon, he did the same thing. He found some more men and gave them jobs too. ");
INSERT INTO engPEV_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Then, at 5 o’clock in the afternoon, he went into town again, and he saw some more men standing around. He asked them, ‘Why haven’t you been working today?’ ");
INSERT INTO engPEV_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","They said, ‘Because nobody gave us a job.’ The boss said to them, ‘All right, I’ll give each of you a job. Go and work in my garden.’ ");
INSERT INTO engPEV_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","At the end of the day, he told his manager, ‘Tell all the work-men to come here, and we will pay them their money. Tell the last work-men to come first.’ ");
INSERT INTO engPEV_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","So he paid the men that started their job at 5 o’clock, and he gave each of them a full day’s pay. Then he kept on paying the other men, and he gave each man a full day’s pay. ");
INSERT INTO engPEV_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Last of all, he paid the men that started their job early in the morning. They thought they were going to get more money, but they didn’t. Each of them got a full day’s pay, just like the other men. ");
INSERT INTO engPEV_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","When they got their money, they complained to the boss. They said, ");
INSERT INTO engPEV_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Those men only worked for one hour, and you paid them just as much money as you paid us. That’s not fair. We worked all day in the hot sun.’ ");
INSERT INTO engPEV_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","The boss said to one of them, ‘My friend, I’m not cheating you. You agreed to work all day for one day’s pay, right? ");
INSERT INTO engPEV_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Well, take your money and go home. You see, I wanted to pay these last work-men the same as you. ");
INSERT INTO engPEV_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","It’s all right for me to do what I want with my own money, right? If I’m good to somebody, don’t get upset with me.’” ");
INSERT INTO engPEV_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Then Jesus told them what that story means. He said, “One day, those people that are the last ones now, they will be the first ones. And those people that are the first ones now, they will be the last ones.” ");
INSERT INTO engPEV_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesus talked to the Jewish leaders. He said, “Tell me what you think about this picture story. A man had 2 sons. He went to the oldest son and said, ‘Son, go and work on our farm today.’ ");
INSERT INTO engPEV_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","The oldest son said, ‘No. I don’t want to.’ But later, he changed his mind, and he went and worked on their farm. ");
INSERT INTO engPEV_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","The father also went to his youngest son and said the same thing to him. He said, ‘Son, go and work on our farm today.’ The youngest son said, ‘Yes, Dad, I will go.’ But he didn’t go and work on their farm.” ");
INSERT INTO engPEV_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Then Jesus asked those Jewish leaders, “Which one of that man’s sons did what their father wanted?” They said, “The oldest son did what their father wanted.” Then Jesus said, “Listen. There are people that did bad things, but they will go into God’s family before you mob do. You know, there are some men that get tax money from people and give it to the Roman government. And sometimes a woman does bad things, so if men pay her money she sleeps with them, like a woman sleeps with her husband. But some of those bad people will go into God’s family before you mob do. ");
INSERT INTO engPEV_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","You see, John the Baptiser came and told everyone the right way to live, and you mob didn’t believe him. But some of those bad people did believe him, and they stopped doing bad things. And even when you saw them do that, you still didn’t change your minds. You didn’t say you were sorry for the bad things you did, and you didn’t turn around and follow God’s way.” ");
INSERT INTO engPEV_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Then Jesus said to the people, “Think about a good work-man. He will always do what his boss says. He thinks about it and does it properly. So, if the boss has to go away for a while, he will pick that good work-man to be in charge of all his other workers, to look after them and give them food every day. ");
INSERT INTO engPEV_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Later, the boss will come home. And if he sees that work-man doing everything properly, then the boss will be good to that work-man. ");
INSERT INTO engPEV_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yes, the boss will put him in charge of everything he owns. ");
INSERT INTO engPEV_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","But now think about a bad work-man. If the boss goes away for a while, then that bad work-man will say to himself, ‘My boss will be away for a long time.’ ");
INSERT INTO engPEV_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Then he will do bad things. He will hit the other workers, and he will eat too much food, and get drunk with other people that drink too much grog. ");
INSERT INTO engPEV_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Then the boss will come home at a time when the bad work-man doesn’t think he will. So the boss will catch him doing bad things. ");
INSERT INTO engPEV_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","And the boss will punish that bad work-man a lot. He will put him in a bad place with people that say they are good, but really, they do bad things. Everyone in that place will cry, and they will be so angry they will bite their teeth together.” ");
INSERT INTO engPEV_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesus said to his followers, “This picture story is about what will happen in God’s family, at the time when I come back from heaven. There were some young women that had a special job at a wedding ceremony. When the man getting married came to the house, they had to meet him, and they had to bring him into the house. Then they were all going to eat a big dinner with that man and his new wife. That wedding was at night time, so the young women had their oil lamps with them. ");
INSERT INTO engPEV_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","There were 10 of these young women. And 5 of them used their brains. They took jars of extra oil with them for their lamps. But the other 5 women were stupid. They didn’t take any extra oil with them. ");
INSERT INTO engPEV_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","That man getting married didn’t come for a long time, so all the young women got tired and went to sleep. ");
INSERT INTO engPEV_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","In the middle of the night, somebody shouted, ‘He is coming now. Come out to meet him.’ ");
INSERT INTO engPEV_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","The 10 young women woke up. Then they got up quickly, and they tried to make their lamps burn bright. ");
INSERT INTO engPEV_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","The 5 stupid women that didn’t have any extra oil said to the other 5 women, ‘Give us some of your oil. Our lamps are going out.’ ");
INSERT INTO engPEV_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","The other women said, ‘Sorry, we can’t do that. There is not enough oil for all of us. You have to go and buy some oil for yourselves.’ ");
INSERT INTO engPEV_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","So those 5 stupid women went to buy some oil. While they were away, that man came to the house to get married. The 5 other women were ready, and they went with him into the house, and somebody locked the door. Then they all started to eat the wedding dinner. ");
INSERT INTO engPEV_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Later, the 5 stupid women came back. They called to that man. They said, ‘Sir, please open the door for us.’ ");
INSERT INTO engPEV_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","But he said, ‘Who are you? I don’t know you.’” ");
INSERT INTO engPEV_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Then Jesus said, “It will be like that for you too. You don’t know when I will come back. You don’t know the day or the time. So you have to keep on waiting for me properly. You have to be ready for me when I come.” ");
INSERT INTO engPEV_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesus said, “I am God’s special man, and one day, I will come back from heaven, and all God’s angel messengers will come with me. At that time, I will be really great and powerful. I will be the biggest boss, and I will sit down on the big boss’s seat. ");
INSERT INTO engPEV_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","All the people in the world, from every country, they will all come together in front of me. Then I will split all those people into 2 mobs. ");
INSERT INTO engPEV_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","I will put one mob on one side of me, and the other mob on the other side of me. ");
INSERT INTO engPEV_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Then I will say to the people on my right-hand side, ‘Come on, you mob. My father is happy with you, so you can be in his family. A long time ago, at the time when he made the world, he made a good place for you. It is ready for you now. ");
INSERT INTO engPEV_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","You see, at one time I was hungry, and you gave me some food to eat. I was thirsty, and you gave me some water to drink. I was a stranger with no-where to live, so you took me into your home. ");
INSERT INTO engPEV_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","In the cold weather time I didn’t have enough clothes to keep me warm, so you gave me some more clothes. I was sick, and you looked after me. I was in prison, and you visited me there.’ ");
INSERT INTO engPEV_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Then these good people will say, ‘Sir, when did we ever see you hungry, and give you food? Or thirsty, and give you water to drink? ");
INSERT INTO engPEV_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","When did we ever see you as a stranger, and take you into our homes? When did we ever see you without enough clothes, and give you some more clothes? ");
INSERT INTO engPEV_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","When did we ever see you sick, or in prison, and visit you?’ ");
INSERT INTO engPEV_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","I will say to them, ‘Listen. You did all these things to help my followers. They were not important people, but they were mine, so every time you helped them, you helped me at the same time.’ ");
INSERT INTO engPEV_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Then I will turn to the people on my left-hand side, and I will say to them, ‘Get away from me, you mob that God will punish. Go into that big fire that burns for ever. God made that fire for all the bad spirits and for their boss, the devil. And you have to go there too. ");
INSERT INTO engPEV_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","You see, I was hungry, but you didn’t give me anything to eat. I was thirsty, but you didn’t give me a drink. ");
INSERT INTO engPEV_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","I was a stranger with no-where to live, but you didn’t take me into your home. I didn’t have enough clothes to keep me warm, but you didn’t give me any more clothes. I was sick, and in prison, but you didn’t visit me.’ ");
INSERT INTO engPEV_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Then they will say, ‘But, sir, when did we ever see you with those problems and not help you? We never saw you hungry, or thirsty, or a stranger, or without enough clothes, or sick, or in prison.’ ");
INSERT INTO engPEV_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","And I will say to them, ‘Listen. You didn’t do anything to help my friends. They were not important people, but they were my people. Every time you said no to helping them, at that same time you were saying no to helping me.’ ");
INSERT INTO engPEV_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Then that bad mob will go to the bad place, and God will punish them for ever. But the good mob will go to live in the good place for ever.” ");
INSERT INTO engPEV_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","The bosses of the Jewish ceremonies got together with the Pharisee mob, that were strong for the Jewish law, and they went to Pilate. He was the Roman boss at that time. ");
INSERT INTO engPEV_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","They said, “Sir, we can remember the things Jesus said while he was still alive. That man tried to get people to believe things that are not true. He said, ‘I will die, and then after 2 nights, on the 3rd day, I will come alive again.’ ");
INSERT INTO engPEV_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Maybe his followers will come and steal his body, and then tell everyone that he came alive again. If they do that, then we’ll be worse off than before. So we want to stop them from doing that. We want somebody to guard the cave that has Jesus’s body, and keep people away from it for 3 days.” ");
INSERT INTO engPEV_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilate said, “All right. You can take a mob of soldiers to guard that cave. Do whatever you can to stop anybody from moving that stone.” ");
INSERT INTO engPEV_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","So they tied a rope around that stone and put wax on the knot, and they made Pilate’s mark in that wax. Then they would know if somebody tried to move that stone. And they told the soldiers, “Guard this cave. Don’t let anyone touch it.” ");
INSERT INTO engPEV_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","On Sunday morning, Mary Magdalene, and another woman that was called Mary, they got up really early and went to look at the cave that had Jesus’s body in it. ");
INSERT INTO engPEV_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Suddenly there was a big earthquake. One of God’s angel messengers came down from heaven, and he rolled the big stone away from the cave, and he sat on top of it. ");
INSERT INTO engPEV_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","His face was bright and shiny, like lightning. His clothes were really white, like snow. ");
INSERT INTO engPEV_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","The soldiers that were guarding the cave were really frightened. They fell down on the ground like dead men, and they couldn’t move. ");
INSERT INTO engPEV_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Then the angel said to the women, “Don’t be frightened. I know that you are looking for Jesus, the man they killed on a cross. ");
INSERT INTO engPEV_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","But he is not here. God made him alive again. Remember, Jesus told you that this was going to happen. Come over here and see the place where he was lying. ");
INSERT INTO engPEV_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Now you have to go quickly to his followers. Tell them, ‘Jesus is alive again, and he is going to Galilee country ahead of you mob. You have to go and see him there.’ So go quickly now, and tell them.” ");
INSERT INTO engPEV_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Then the women ran quickly away from that cave. They were really frightened, but they were really happy too. They got up to run to Jesus’s other followers, to tell them the angel’s message. ");
INSERT INTO engPEV_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","But Jesus met them half-way and called out, “Hello.” They went up to Jesus and showed him strong respect. They even got down and held on to his feet. ");
INSERT INTO engPEV_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Then Jesus said, “Don’t be frightened. Go and tell my other followers to go back to Galilee country, and they will see me there.” ");
INSERT INTO engPEV_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","While the women were going away, some of the soldier guards went into the city and told the bosses of the Jewish ceremonies everything that happened at the cave. ");
INSERT INTO engPEV_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Then the ceremony bosses called a meeting with the Jewish elders. They all agreed to give the soldiers a lot of money to get them to tell a lie. ");
INSERT INTO engPEV_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","They told the soldiers, “You have to tell everyone, ‘Jesus’s followers came in the night, while we were asleep, and they stole his body.’ ");
INSERT INTO engPEV_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","If anyone tells the boss, Pilate, about this, then we’ll talk to him and tell him that you didn’t do anything wrong, so he will not give you any trouble.” ");
INSERT INTO engPEV_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","The soldiers took the money, and they told everyone that lie, like the leaders told them to say. So a lot of Jewish people heard that story, and some of them still tell that lie to other people. ");
INSERT INTO engPEV_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","The women told Jesus’s message to his 11 special workers. Then those men remembered that Jesus told them to meet him on a mountain in Galilee, so they went there. ");
INSERT INTO engPEV_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","They saw Jesus there, and they felt really happy, and they showed him strong respect. But some of them were thinking, “Is this really Jesus? I don’t know.” ");
INSERT INTO engPEV_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Then Jesus said to them, “God, my father, has made me boss over everything now. I’m boss over everything up in heaven. And I’m boss over everything down here on the earth. ");
INSERT INTO engPEV_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","So go out to all the people in the world, and tell them about me. Teach those people to follow my way, and baptise them with water to show that they belong to the father, and the son, and the Holy Spirit. ");
INSERT INTO engPEV_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","You have to teach them to do everything that I told you to do. And remember this, I will be with you all the time. I will be with you to help you, right up until the time when this world will finish.” ");
INSERT INTO engPEV_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","This story is good news. It is all about Jesus Christ, God’s son. The story starts like this. ");
INSERT INTO engPEV_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","3","A long time before Jesus was born, God told a man called Isaiah to write in God’s book about something God was going to do for Jesus. And it happened the way Isaiah wrote. He wrote this, “God will send a man to get everything ready for him. That man will talk about him and make a way for people to listen to him. That man will be out in the bush, and he will call out to people, and he will say, ‘You mob get ready. God is coming to this country, so you have to get ready for him. It is like when a big boss comes, and you have to make a good road for him.’” ");
INSERT INTO engPEV_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Isaiah was talking about a man called John. God sent him to get things ready for Jesus, so he started to tell people God’s message. He lived out in the bush and wore rough clothes made out of camel’s hair, and a leather belt. He ate grasshoppers and bush honey. John talked to people out there in the bush. He said, “You mob have to be really sorry for the wrong way you are living. You have to turn right around and live God’s way.” He also told them, “If you do that, I will baptise you. That means, I will take you through a special washing ceremony. And God will not do payback for the bad things you did.” A lot of people went out into the bush to listen to John. They came from the city called Jerusalem and from other towns in that country called Judea. Some people told John that they were sorry for the wrong things they did, so he baptised them in the Jordan River. ");
INSERT INTO engPEV_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","John told them, “A man will come to this country later. He is more important than me, and he is stronger than me. I’m not good enough to untie his shoes. I’m just nothing. ");
INSERT INTO engPEV_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","You see, I baptised you just with water, but this new man will put the Holy Spirit in you. He will baptise you with the Holy Spirit.” ");
INSERT INTO engPEV_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","At that time, Jesus was living in a town called Nazareth, in Galilee country. Then Jesus left his home, and he walked all the way south to a place on the Jordan River. John was baptising people there. ");
INSERT INTO engPEV_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","After he got to that place, Jesus went down into the water and John baptised him. As he came up out of the water, Jesus looked up, and he saw the sky split open, and he saw the Holy Spirit. It looked just like a pigeon, and it flew down to Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","And God said to Jesus, “You are my son. I love you very much, and I’m very happy with you.” ");
INSERT INTO engPEV_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Straight away, the Holy Spirit sent Jesus out into the bush. ");
INSERT INTO engPEV_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jesus stayed out there for 40 days. And Satan went to him and tried to trick him. Satan is the boss over all the bad spirits. He tried to make Jesus do something bad. But Jesus didn’t do it. There were wild animals in that place, but angel messengers went and looked after Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","One day, that country’s government boss was angry with John the Baptiser, so he sent some soldiers to grab John and put him in jail. After that, Jesus went back to Galilee country, and he told everyone God’s good news. ");
INSERT INTO engPEV_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","He said, “Now is the right time for God to take people into his family. You mob have to take notice and turn right around and live God’s way. You have to believe this good news.” ");
INSERT INTO engPEV_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","One day, Jesus walked next to a big lake, called Lake Galilee, and he saw 2 men throwing a net into the water to catch fish. That was their job. One man was called Simon, and the other man was his brother Andrew. ");
INSERT INTO engPEV_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus said, “I want you 2 to come with me. I want you to stop catching fish and start catching people for me.” ");
INSERT INTO engPEV_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Straight away, Simon and Andrew dropped their nets and followed Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesus kept walking along next to the water, and he saw James and John getting their nets ready to catch fish. And their father Zebedee was with them too. ");
INSERT INTO engPEV_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Like before, Jesus called out to James and John to stop their work and follow him. Straight away, they left their father and the other work-men in the boat, and they followed Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesus and his followers went to a town called Capernium. On Saturday they went to the Jewish meeting house, and Jesus taught God’s word to the people. You see, Saturday was their day to rest and show respect to God. ");
INSERT INTO engPEV_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jesus talked with clear and strong words, and the people listened to him, and they were really surprised. They knew that he was teaching God’s words really straight. The Jewish law teachers didn’t talk like that. ");
INSERT INTO engPEV_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Then, in the middle of the meeting, a man with a bad spirit in him called out, ");
INSERT INTO engPEV_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Leave us, Jesus from Nazareth. Why do you trouble us bad spirits? Are you going to finish us up? We know you. You are God’s special man.” ");
INSERT INTO engPEV_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesus talked to the bad spirit strongly. He said, “Be quiet. Come out of him.” ");
INSERT INTO engPEV_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","The bad spirit knocked the man down and made him shake and scream out loud as it came out of him, and then it went away. ");
INSERT INTO engPEV_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","All the people were watching, and they were really surprised. They asked each other, “What’s going on? This man is teaching us something new, and he has so much power. He tells bad spirits to get out of people, and they do what he tells them to do. They just go away.” ");
INSERT INTO engPEV_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Then all those people went out and told everyone about Jesus. Everyone in Galilee country heard that story about him. ");
INSERT INTO engPEV_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","After that, Jesus left the meeting house and went with Simon and Andrew to their house. James and John went with them. ");
INSERT INTO engPEV_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon’s mother-in-law was sick. She was lying in her bed, really hot and sweating a lot. They told Jesus, “She is very sick.” ");
INSERT INTO engPEV_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","So he held her hand and started to lift her up. Straight away, she got better. Then she got up, and she gave them some food to eat. ");
INSERT INTO engPEV_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Late that afternoon, just after the sun went down, all the people from that town got all the sick people, and the people with bad spirits in them, and they brought them all to Simon’s house. ");
INSERT INTO engPEV_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","A big mob of people were there outside that house. ");
INSERT INTO engPEV_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesus made lots of sick people better, and he forced lots of bad spirits to go out of people. The bad spirits knew that Jesus was God’s son, but Jesus wouldn’t let them tell everyone. He forced those bad spirits to be quiet. ");
INSERT INTO engPEV_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","The next day, Jesus got up very early, before the sun came up, and he walked out from the town to pray by himself. ");
INSERT INTO engPEV_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Then Simon and the others went and looked everywhere for Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","After they found him, they said, “Everyone is looking for you.” ");
INSERT INTO engPEV_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","But Jesus said to them, “Come on, let’s go. I have to go to the other towns around here too, and tell everyone the good news. That’s the job I came to do.” ");
INSERT INTO engPEV_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","So Jesus went all around Galilee country, talking to people in their meeting houses, and telling them God’s story. And he forced bad spirits to go out of lots of people. ");
INSERT INTO engPEV_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","A man walked up to Jesus. He had a really bad skin sickness. He got down on his knees in front of Jesus to show him respect, and he kept on asking Jesus to make him better. That man said, “I know that if you want to, you can make me better.” ");
INSERT INTO engPEV_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus felt really sorry for the sick man, and said, “I do want to make you better.” Then Jesus touched him with his hand, and said, “You are better now.” ");
INSERT INTO engPEV_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","And straight away, that man was better. ");
INSERT INTO engPEV_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Then Jesus told him strongly, “I don’t want you to tell anyone about this. But I want you to go to God’s ceremony house and show your skin to the leader of the Jewish ceremonies there, so that he can see that you are better. And you have to do the right ceremony that Moses gave us, to say thank you to God. When you do that ceremony, everyone will know that you are better.” ");
INSERT INTO engPEV_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","But the man didn’t do what Jesus said. He went away and told everyone, “Jesus made me better.” After people heard the man’s story they went to Jesus from everywhere. Lots of people went to him and stood around him. So he couldn’t go into the towns any more, because there were too many people. So he had to stay out in the bush. But people still came from everywhere and found him, even in the bush. ");
INSERT INTO engPEV_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Some time later, Jesus went back to the town called Capernium. The people heard that Jesus was at a house there, ");
INSERT INTO engPEV_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","so they all went to see him. Soon the house was too full and there was a big mob outside too. ");
INSERT INTO engPEV_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jesus was inside the house, teaching the people God’s story. Then 4 men brought a crippled man to that house. He couldn’t walk so they carried him on a swag. They wanted to get that man close to Jesus, so that Jesus could make him better. ");
INSERT INTO engPEV_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","But those men found a lot of people blocking the house. So they carried the sick man up on to the flat roof of the house and made a hole in it. Then they picked up the sick man on his swag and put him down through the hole into the house where Jesus was. ");
INSERT INTO engPEV_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesus saw them do that, and so he knew that they really trusted him. Then Jesus said to the crippled man, “You know all the bad things you did? I say you are not guilty of those things, and God will not punish you.” ");
INSERT INTO engPEV_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","But some of the Jewish law teachers didn’t like Jesus saying that. Those law teachers were thinking, ");
INSERT INTO engPEV_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“He can’t say that. Only God can talk like that. This man is talking like he is God. He can’t talk like that. He is shaming God.” ");
INSERT INTO engPEV_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","9","Straight away, Jesus knew what the Jewish law teachers were thinking, so he said to them, “You are thinking the wrong way. I might say to this man, ‘You did bad things, but I say you are not guilty of them.’ Or I might say to him, ‘Get up, pick up your swag and go home.’ I can do both of those things. ");
INSERT INTO engPEV_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","I will show you that God made me the boss over both of those things, so I can say that people are not guilty, and God will not punish them. I’m God’s special man from heaven, and I have the power to say those things, and I have the power to do those things.” Then Jesus looked at the crippled man and said, ");
INSERT INTO engPEV_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Come on, get up, pick up your swag and go home.” ");
INSERT INTO engPEV_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Straight away, that man got up, and he picked up his swag in front of all the people, and he walked out of the house and went home. Everybody there saw him do it, and they were really surprised. They started talking about it. They praised God, telling him that he is really good. They said, “We’ve never seen anything like this before.” ");
INSERT INTO engPEV_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","After that, Jesus left the house and walked along next to the lake. The people from the town kept coming to him, so he kept on teaching them. ");
INSERT INTO engPEV_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","At that time, the Roman people were the bosses over all that country, and they got some Jewish people to take tax money from the other Jewish people and give it to the Roman government. One of those tax men was called Levi, and his father’s name was Alfius. Jesus walked along, and he saw Levi and said to him, “I want you to be one of my followers. Come on, follow me.” And straight away, Levi stood up and went with Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Later that day, Jesus and his followers were eating some food at Levi’s house. There were lots of people there. Some of them were men that used to get tax money from people and give it to the Roman government, and some other people there didn’t live God’s way. ");
INSERT INTO engPEV_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Some of the Jewish law teachers saw Jesus eating with all those people. Those law teachers also belonged to the Pharisee mob. They were really strong for the law, so they asked Jesus’s followers, “Why does Jesus eat with those people that don’t live God’s way?” ");
INSERT INTO engPEV_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesus heard them, and said to them, “Listen, sick people need a doctor, but healthy people don’t need a doctor. I’m telling you, I’m like a doctor. You mob reckon these people do bad things, so I’m here to help them turn around and do good things. But you mob think you never do anything wrong yourselves, so I can’t help you.” ");
INSERT INTO engPEV_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","The mob called Pharisees, that were strong for the Jewish law, they sometimes stopped eating food for a while to show God that they respected him. The followers of John the Baptiser did the same. Some people went to Jesus and asked him, “How come your followers don’t stop eating food to show God that you respect him, you know, just like the Pharisee mob and John’s followers do?” ");
INSERT INTO engPEV_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesus said to them, “At a wedding ceremony everybody is happy, and they all eat food together with the man that is getting married. It’s the same way for my followers. I’m still here, so they are happy and don’t need to stop eating food. Not yet. ");
INSERT INTO engPEV_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","One day, my enemies will take me away, then my followers will be sad, and they will stop eating food.” ");
INSERT INTO engPEV_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Then Jesus told them 2 picture stories about the things he was teaching, to get them to start thinking a new way. He said, “If you have an old coat with a hole in it, you can’t fix that hole with a new bit of cloth. If you try to do that, and then if you wash it, the new cloth will tear away from the old cloth, and the coat will still be useless. ");
INSERT INTO engPEV_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","And this is another story. You don’t put new drink into an old cracked bottle. That drink will all leak out and you will lose it. You have to put new drink into new bottles.” ");
INSERT INTO engPEV_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","One day, on the Jewish rest day, Jesus and his followers walked through a garden that had seed food growing in it. They walked along and they got a bit hungry, so his followers grabbed some of the seeds to eat. ");
INSERT INTO engPEV_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Some of the Pharisee mob saw Jesus’s followers doing that. That mob were strong for the Jewish law, so they got angry. They said to Jesus, “Your mob are doing the wrong thing. Our Jewish law says that today is the rest day. But your mob are getting seeds off those plants. That is work. They are breaking our law.” ");
INSERT INTO engPEV_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Jesus said to them, “Remember the story about David and his men. You know, it was when Abiathar was the big boss of the Jewish ceremonies. David and his men were really hungry, and they didn’t have any food. So David went into God’s ceremony place and got the special bread. Only the men that look after the Jewish ceremonies can eat that bread. But David and his men ate that special bread, and so they broke our Jewish law, but God didn’t punish them.” ");
INSERT INTO engPEV_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Then Jesus said to them, “Listen to me now. God gave us the rest day to help us, not just to give us another law to follow. ");
INSERT INTO engPEV_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Listen, I am God’s special man from heaven, and I’m boss over everything. I am even the boss of our Jewish rest day. So I’m not worried about my followers grabbing some seeds to eat.” ");
INSERT INTO engPEV_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesus went to the Jewish meeting house again on another rest day, and he saw a man with one hand that was no good. It was all dried up and useless. ");
INSERT INTO engPEV_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Some of the Pharisee mob were there. They were strong for the Jewish law. They wanted to make trouble for Jesus, so they watched him there. They wanted to see if he was going to help the man with the dried up hand, and make it better on their Jewish rest day. If he did that, they were going to say, “He worked on the rest day, so he broke the law.” ");
INSERT INTO engPEV_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesus knew they were thinking like that, and so he said to the man, “Come here and stand in front of everybody, so they can see you.” ");
INSERT INTO engPEV_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Then Jesus said to the Pharisee mob, “What does our law say about our rest day? Is it right to do good things on our rest day, or is it right to do bad things? Can I make this man better? Or can I hurt him?” The Pharisee mob said nothing. ");
INSERT INTO engPEV_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesus looked at them. They didn’t care about people, they only worried about their law, and that made Jesus really angry. And it made him really sad too. Then Jesus said to the man with the useless hand, “Hold out your hand.” The man put his hand out, and straight away it was better. It wasn’t dried up any more. ");
INSERT INTO engPEV_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Then the Pharisee mob went away and had a meeting with another mob of Jewish leaders. That other mob were good friends with the big boss called Herod. At that meeting they tried to work out a way to kill Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesus and his followers went away to the big lake, called Lake Galilee, and a big mob of people followed them. ");
INSERT INTO engPEV_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Those people came from a lot of places. They came from Galilee country, and from Judea country, and from Idjumia country, and some people came from Jerusalem city, and other people came from the country near the towns called Tyre and Sidon, and some people came from the other side of the Jordan River. All those people heard about the things that Jesus did, so they wanted to see him themselves. ");
INSERT INTO engPEV_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Jesus made lots of people better that day, and a lot more people wanted to touch him to get better too. A lot of people pushed up close to him, so he said to his followers, “Get a boat ready for me. I might need more room. If they push me too much, I will get up on that boat.” ");
INSERT INTO engPEV_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Some of the people had bad spirits living inside them. Every time those people saw Jesus, the bad spirits pushed them down to the ground and they shouted out, “You are God’s son.” ");
INSERT INTO engPEV_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","And every time they shouted out, Jesus told them strongly to stay quiet. He said, “Don’t tell anyone that I’m really God’s son.” ");
INSERT INTO engPEV_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","One day, Jesus walked up a hill and called out to some of the people to follow him. ");
INSERT INTO engPEV_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Then Jesus picked out 12 of them. He wanted them to be his special workers. Jesus told them, “You mob will walk around with me and live with me, and after that, I will send you to other places to tell people God’s good news, and God will give you the power to force bad spirits out of people.” ");
INSERT INTO engPEV_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","These are the names of those 12 men that Jesus picked out, – Simon. Jesus gave him another name. He called him Peter. – James and John. They were Zebedee’s sons, and they were loud men, so Jesus gave them another name. He called them Thunder men. – Andrew – Philip – Bartholomew – Matthew – Thomas – James. He was the son of Alfius. – Thadius – Simon. He used to be one of the mob that wanted to fight the Roman government bosses. – Judas Iscariot. Some time later he turned against Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jesus went into a house, and a big mob of people came there to see him. They were a really big mob of people, so Jesus and his followers were really busy, and they couldn’t even stop and eat some food. ");
INSERT INTO engPEV_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Somebody went and told Jesus’s family about him. So his family said, “He is crazy in his head,” and they went to get him. They wanted to take him home to look after him. ");
INSERT INTO engPEV_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Some teachers of the Jewish law that were from Jerusalem were there in that place. They said, “The boss over all the bad spirits is living inside Jesus. That bad spirit boss is called Beelzebul, and he is also called Satan. He is the one that gives Jesus the power to force bad spirits out of people.” ");
INSERT INTO engPEV_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesus knew the law teachers were rubbishing him like that, so he called out to them and said, “Come here and listen to me.” Then he told them stories to teach them. He said, “Think about Satan, the boss over the bad spirits. Do you reckon he fights against his own mob of bad spirits? That doesn’t make sense. ");
INSERT INTO engPEV_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Listen to me. If a tribe splits up into 2 mobs that fight against each other, that tribe will get weak and finish up. ");
INSERT INTO engPEV_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","In the same way, people in a family, if they fight each other all the time, they will split up and will stop being a family. ");
INSERT INTO engPEV_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","So, if Satan is fighting against his own mob of bad spirits, he will get weak and will not have any power. So Satan never does that. You have got it all wrong. ");
INSERT INTO engPEV_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Listen to this picture story. A man wanted to take some things from a strong man’s house. First he tied up that strong man. After that, he took all the strong man’s things. Well, in that story Satan is like that strong man, and I’m like the man that tied him up, and now I’m taking my people away from him. ");
INSERT INTO engPEV_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Listen, people might do bad things, and they might say bad things against God, but later, if they are sorry for those bad things, God can say they are not guilty. ");
INSERT INTO engPEV_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","But if somebody says bad things about the Holy Spirit, they are always guilty. God will blame them and punish them for ever.” ");
INSERT INTO engPEV_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","That’s what Jesus said to those Jewish law teachers. You see, they reckoned that Jesus had a bad spirit in him. That is the reason why Jesus talked so straight to them. ");
INSERT INTO engPEV_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesus’s mother and his brothers came to the house where Jesus was teaching, and they sent somebody in to tell him to come out and talk to them. ");
INSERT INTO engPEV_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","There was a big mob of people sitting around Jesus, listening to him at that time. The people said to him, “Your mother and your younger brothers are outside looking for you.” ");
INSERT INTO engPEV_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","34","Jesus looked around at the people sitting there and said, “Do you want to know my real family? You just have to look around. These people here are my real family. ");
INSERT INTO engPEV_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","My real family are the people that listen to God, and that do what he says. Those people are my brothers, and my sisters, and my mothers.” ");
INSERT INTO engPEV_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesus went down to the lake again, and he started to teach people. A big mob of people went to listen to him, so he got into a boat and sat in it. He was a little bit away from the dry ground. All the people stayed on the dry ground and listened to his words. ");
INSERT INTO engPEV_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","He told them picture stories to teach them lots of things. Jesus told them this story. He said, ");
INSERT INTO engPEV_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“You mob listen to me now. A man wanted to grow some seed food in a garden. ");
INSERT INTO engPEV_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","He threw the seeds all over the garden. Some seeds went too far and fell on the road. The road was hard, so the seeds couldn’t grow there. Some birds saw those seeds lying there, so they ate them and finished them up. ");
INSERT INTO engPEV_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","And some seeds went another way. They fell on ground that had too much rock in it. Those seeds grew up really fast, but they had too much rock and only a little bit of ground, so when the sun got hot, they dried up and died. ");
INSERT INTO engPEV_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Some other seeds fell into the rubbish grass that was growing right next to the garden. Those seeds tried to grow, but the rubbish grass blocked them, so they couldn’t grow properly. They didn’t grow any new seeds on them. ");
INSERT INTO engPEV_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","But some of those seeds fell on really good ground, and those seeds grew properly and became seed food plants. When they were ready, they had really big mobs of new seeds on them.” ");
INSERT INTO engPEV_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Then Jesus said, “You’ve got ears, so you have to listen to me properly, and take notice of my words.” ");
INSERT INTO engPEV_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Some time later, Jesus came away from that big mob of people. Then just his 12 special workers and a few other people sat around him. They said to him, “You tell us picture stories, but we can’t understand them. What are your stories all about?” ");
INSERT INTO engPEV_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesus said, “You mob follow me, so God wants you to know what my stories are all about, so I will tell you what they mean. Those stories are about how God gets people into his family. But other people don’t follow me, so they only get the picture stories. I will not tell them what they mean. ");
INSERT INTO engPEV_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","You know, God got one of his men to write these words, and they are in God’s book. He wrote, ‘People will look with their eyes at what I do, but they will not try to understand what it means. They will hear my words with their ears, but they will not try to understand them properly. If they do understand me properly, then they will turn around and come back to God, and then God will not blame them for the bad things they did. But they don’t want to know about that.’ And those things are happening now.” ");
INSERT INTO engPEV_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesus kept on talking. He said, “Why can’t you understand this picture story? If you can’t understand this easy story, you will not understand the other stories that I’m going to tell you. ");
INSERT INTO engPEV_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Listen to me again. In my story, a man threw the seeds into his garden, to grow some food. He is a picture of somebody that tells God’s word to people. ");
INSERT INTO engPEV_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","I said that some seeds fell on the road, and birds ate them up. Those seeds are a picture for God’s word, and the birds are a picture of Satan, the boss over the bad spirits. When some people hear God’s word, Satan makes them forget it, so they take no notice of its message. ");
INSERT INTO engPEV_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","In my story there was ground with too much rock in it. That is a picture of people that listen to God’s word and they are happy about it, and they start to take notice of it. ");
INSERT INTO engPEV_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","But other people see them believing that word, and those other people make trouble for them, so they stop taking notice of God’s word. They soon turn their back and walk away from it. ");
INSERT INTO engPEV_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","In my story the man threw some seeds into rubbish grass, and that grass blocked them, so they couldn’t grow. That is a picture of people that hear God’s word, ");
INSERT INTO engPEV_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","but after that, they let other things stop them, so they don’t live properly for God. They worry too much about the things they want in this life. They start to think too much about money, and they trick themselves. They want a lot of different things all the time, and they worry too much about all those things. They just think about what they want for themselves, and that stops them listening properly to God’s word, so they can’t live properly for God. ");
INSERT INTO engPEV_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","In my story, the seeds that fell on the good ground grew properly, and after those plants grew up big, they made lots of new seeds. That is a picture of people that are ready to listen to God’s word, and do what he says. When they believe God’s word, they grow stronger and stronger for God, and they live God’s way.” ");
INSERT INTO engPEV_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Then Jesus said, “When somebody lights a candle, they don’t put it under a bowl. And they don’t put that candle under their bed. No way. People put candles up high, so everyone can see clearly. ");
INSERT INTO engPEV_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Well, just like that, God wants people to understand the things that are true. He will not hide them away. You see, there are some things that God hasn’t told anyone yet, but people will know them soon. It will be like a light will shine on them. ");
INSERT INTO engPEV_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","You’ve all got ears, so you have to listen to me properly, and take notice of my words.” ");
INSERT INTO engPEV_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","25","Then Jesus said, “Make sure you listen to the right message and think about it properly. When you really take notice of a true message, God will help you understand it, and he will help you to know more and more of his word. But if you don’t want to listen to that message, God will stop you from understanding the little bit you did hear.” ");
INSERT INTO engPEV_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","29","Jesus kept on teaching. He said, “I want you to know how God’s family grows. This is another picture story. A man wanted to grow some seed food, so he threw some seeds on the ground in his garden. Then that man walked away and left the seeds there. Those seeds grew all by themselves in that ground, and that man didn’t know what made those seeds grow. He just left them there for a few months, and they grew. At first the long stick part grew, and after that, the head part grew with all the seeds inside it. Then, when the seeds were ready, that man cut those plants down and picked up the seed food. God is boss for everyone, and his family will grow just like the plants in that story.” ");
INSERT INTO engPEV_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesus talked some more. He said, “Do you know what God’s family is like? I will tell you another picture story to help you understand it. ");
INSERT INTO engPEV_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","God’s family is like a little seed, like the seed of the plant we call mustard. Its seeds are very little. ");
INSERT INTO engPEV_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","When somebody puts one of those little seeds into the ground, it grows and grows. Later it gets really big with lots of branches. It gets bigger than all the other plants in a vegetable garden, and birds can sit down in the shade of its branches, and they can make their nests there too. Well, that is a picture of how God’s family will grow.” ");
INSERT INTO engPEV_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesus taught the people this way whenever they were ready to listen. ");
INSERT INTO engPEV_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Whenever he talked to all the people, he used picture stories. But later, when Jesus was sitting down with only his followers, he told them what those stories really mean. ");
INSERT INTO engPEV_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","On that same day, while Jesus was teaching, the sun started to go down. He was still sitting in the boat, so he stopped teaching and told his followers to take him across the lake. ");
INSERT INTO engPEV_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","So they left all the other people behind, and his followers started to take him across the lake in their boat. Some other people got into their boats and followed them. ");
INSERT INTO engPEV_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","A little bit later a really strong storm came. The wind got very strong, and the waves started to fill the boat with water, so it was starting to sink. ");
INSERT INTO engPEV_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesus was asleep in the back of the boat with his head on a pillow. His followers were frightened, so they woke him up, and they shouted at him, “Teacher, we will all drown, and you don’t care. Why don’t you do something?” ");
INSERT INTO engPEV_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesus opened his eyes, then he stood up, and he talked strongly to the wind and the water. He said, “Stop. Be quiet.” Straight away, the wind stopped and the water lay down flat. Everything was quiet and still. ");
INSERT INTO engPEV_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Then Jesus said to his followers, “Why are you so frightened? You should know by now that you can trust me.” ");
INSERT INTO engPEV_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","They said to each other, “Look. The wind and the water listen to this man, and they do what he says. He is really powerful.” So they were really surprised and frightened. ");
INSERT INTO engPEV_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Then Jesus and his followers went to the other side of the lake, to the country called Gerasene. ");
INSERT INTO engPEV_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","5","There was a man there that had a bad spirit in him. He was like a crazy man. He camped in the cemetery there. Before Jesus came to that place, that man walked around in the cemetery, and all over the hills there, and he yelled out and screamed all the time. He did that in the day time and also at night time. And he cut himself with stones. People couldn’t tie him up, not even with chains. They tried to do that lots of times. They tied up his hands and his feet, but it was no good. He was too strong. He just broke those chains every time. Nobody was strong enough to hold him or make him sit down quiet. When Jesus got out of the boat, ");
INSERT INTO engPEV_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","that crazy man saw him from a long way off. He ran right up to Jesus. The spirit in him knew that Jesus was stronger than him, so he got down on his knees in front of Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jesus said to the bad spirit, “Come out of this man.” But the spirit in him made him yell at Jesus, “Why did you come here? I know you. You are Jesus. You are the son of God. He is the big boss over everything. Promise me truly that you will not hurt me.” ");
INSERT INTO engPEV_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesus asked him, “What is your name?” He said, “Our name is Big Mob. You see, we are a mob of bad spirits inside this man. ");
INSERT INTO engPEV_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Please don’t send us away from this country.” ");
INSERT INTO engPEV_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","There were about 2,000 pigs feeding themselves on the hill nearby. ");
INSERT INTO engPEV_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","The bad spirits asked Jesus, “Can we go into that big mob of pigs over there?” ");
INSERT INTO engPEV_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","So Jesus sent those bad spirits out of the man and let them go into the pigs. Then those pigs went crazy, and they ran down the steep hill into the lake, and they drowned themselves in the water. ");
INSERT INTO engPEV_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","The men that looked after the pigs were frightened, and they ran back to their town, and they told everyone what happened. They told that story to the people in the town, and they told it to the people that lived outside of the town too. A lot of people wanted to see what happened, ");
INSERT INTO engPEV_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","so they ran out to that place where Jesus was. They saw that man sitting down quiet and wearing clothes. He wasn’t crazy any more. Then those people got frightened. ");
INSERT INTO engPEV_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","The men that looked after the pigs told them the story about the man and the pigs. ");
INSERT INTO engPEV_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Then all that mob started to ask Jesus strongly to go away from their country and leave them alone. ");
INSERT INTO engPEV_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesus listened to them, and he started to get into the boat. Then the man that used to have the bad spirits in him, asked Jesus, “Please, can I come with you?” ");
INSERT INTO engPEV_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesus said, “No, I want you to go back to your family, and to your own mob. I want you to tell everybody about the good things God did for you. Tell them that God felt sorry for you, and he was really good to you.” ");
INSERT INTO engPEV_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Then that man went all over that country called Ten Towns, and he told everybody that story. He told them all about the good things Jesus did for him. Everybody that heard him was really surprised. ");
INSERT INTO engPEV_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesus and his followers got back into the boat and went to the other side of the lake. A really big mob of people were waiting for them there, beside the water. ");
INSERT INTO engPEV_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","There was a Jewish meeting house near there. One of the bosses of that meeting house saw Jesus and went up to him, and he got down on his knees in front of Jesus, to show him respect. That man’s name was Jairus. ");
INSERT INTO engPEV_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","He strongly asked Jesus to help his daughter. He said, “My little girl is really sick, and I think she will die. Please come and put your hands on her. I know that you can make her better, so that she will not die.” ");
INSERT INTO engPEV_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesus listened to the man and started to go with him. The big mob of people followed them. They went up really close and pushed up against Jesus, all around him. ");
INSERT INTO engPEV_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","While they were walking along, a sick woman was there. A long time before this, she started bleeding, and that bleeding didn’t stop. ");
INSERT INTO engPEV_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","She went to every doctor, but none of them could help her. She spent all her money trying to get better, but it was no good, she only got worse. She kept on bleeding for 12 years. ");
INSERT INTO engPEV_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Then somebody told her about Jesus, and she thought to herself, “If I can just touch his coat, I will get better.” So she came up behind Jesus, and she touched his coat. ");
INSERT INTO engPEV_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","And straight away, her bleeding stopped. She knew she was better. ");
INSERT INTO engPEV_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesus knew straight away that power went out from him, so he stopped walking, turned around, and asked the people, “Who touched my clothes?” ");
INSERT INTO engPEV_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jesus’s followers said, “There are big mobs of people here pushing up against you. Why do you ask, ‘Who touched me?’ Lots of people touched you.” ");
INSERT INTO engPEV_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesus kept on looking around to see the person that used his power. ");
INSERT INTO engPEV_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","That woman knew that she was the person that got better, so she was very frightened, and she was shaking. She came to Jesus, and she got down on her knees in front of him, to show him respect, and she told him her story. She told him that she touched him. ");
INSERT INTO engPEV_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesus said to her, “My friend, you really believed in me, so now you are better. You can go home, and you will not have any more trouble. You are not sick any more.” ");
INSERT INTO engPEV_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","While Jesus was talking to the woman, a man from Jairus’s house came to him with bad news. He said, “I’m sorry, it’s too late. Your little girl is dead. Don’t bother Jesus now.” ");
INSERT INTO engPEV_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesus heard the man’s words, but he took no notice of them. He said to Jairus, “Don’t be frightened. Just trust me.” ");
INSERT INTO engPEV_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Then Jesus told the people, “Don’t come with me to this man’s house.” He only let a few people go with him. They were the girl’s mother and father, and 3 of his special workers, Peter, James and John. They were the only people that went with him. ");
INSERT INTO engPEV_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","They got close to the house, and Jesus heard other people inside it making a big noise. They were crying for that dead girl and shouting out loud. ");
INSERT INTO engPEV_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesus went into the house, and he asked them, “Why are you making all this noise? That little girl isn’t dead. She is just sleeping.” ");
INSERT INTO engPEV_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","But they just laughed at Jesus. So he told them all to get out of the house. Then Jesus said to the girl’s mother and father, and to his 3 followers, “You come with me.” Then they went together into the room where the girl lay. ");
INSERT INTO engPEV_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesus held the girl’s hand and talked to her in their language. He said, “Talitha koum.” That means, Get up, little girl. ");
INSERT INTO engPEV_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Straight away, that girl got up and walked around the room. Her mother and father were really surprised. Their little girl was alive again. She was 12 years old at that time. ");
INSERT INTO engPEV_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesus told them strongly, “Don’t tell anyone that I made this little girl alive again.” Then he said to them, “Now give her some food to eat.” ");
INSERT INTO engPEV_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus and his followers left that country and went back to his own town, called Nazareth. ");
INSERT INTO engPEV_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","On the Jewish people’s rest day, Jesus went to the Jewish meeting house, and he started to teach the people God’s message. A lot of the people heard his words, and they were really shocked. They said, “How does he know so much? How come he can do powerful things? He’s nobody special. We know him. He grew up here, in this town. His mother, Mary, lives here, with his brothers, James, Joses, Judas and Simon, as well as his sisters. His job here is to make things with wood.” So those Nazareth people got angry, and they wouldn’t take any notice of him. ");
INSERT INTO engPEV_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesus then said to them, “If God gives a man a message, lots of people know he is God’s man, and they respect him. But not his own people. They lived with that man and knew him from the time he was a little boy. They don’t respect him. Even his close family and relatives don’t listen to him.” ");
INSERT INTO engPEV_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","You see, the people of Jesus’s own town didn’t believe in him, and he was really shocked. He couldn’t do anything really powerful there, because they didn’t believe in him. He only touched a few sick people and made them better. Then he left Nazareth, and went to other towns, and taught God’s word to the people there. ");
INSERT INTO engPEV_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","11","Jesus called together his 12 special workers. He told them, “You have to go to every town and tell my message to the people. Let them take care of you when you go there. Don’t take a bag, or food, or money, or spare clothes with you. Just take your shoes and a walking stick. After you get to a town, if the people in that town are happy for you to stay there, just stay in one house. Don’t move around to different houses. But if the people in that town don’t want you to be there, and if they will not listen to you, then you have to go away from that town. As you leave it, shake the dirt off your feet. That will show those people that they will get trouble. It will be like you are telling them, ‘You didn’t take any notice of my message, so God will judge you and punish you.’” And Jesus told his special workers, “I’m giving you my power to force bad spirits out from people.” Then Jesus split them up into 6 teams with 2 men in each team, and he sent them out to do God’s work. ");
INSERT INTO engPEV_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","So his special workers went to other towns, and they told everyone to turn around, to change their lives, and to come back to God’s way. ");
INSERT INTO engPEV_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Those men forced a lot of bad spirits out of people. And they put olive oil on a lot of sick people, like medicine for them, and those sick people got better. ");
INSERT INTO engPEV_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","29","This is the story about what happened to John, the man that baptised people. The big boss over that country was Herod, and his brother was Philip. Philip’s wife’s name was Herodias. But Herodias left Philip, and Herod married her. John kept on telling Herod, “You are breaking God’s law. You shouldn’t have your brother’s wife.” Herodias hated John for saying that, and she wanted to kill him, but Herod sent some soldiers to grab John and keep him in jail, so Herodias couldn’t do anything to him. John was a good man, one of God’s own men, so Herod respected John, and he was a bit frightened of him too. Herod used to talk with John. He didn’t really understand John’s message, but he liked to listen to him. Some time later, Herod had a birthday party. All the leaders of Herod’s army, and the government bosses from Galilee country, they were all there at Herod’s party. Herodias’s daughter danced for them at that party. Herod and everybody else really liked to watch her dance. She made them really happy, so Herod made a strong promise to her. He told her, “I want to give you something really good. You can ask for anything. I will give you anything you ask for, even as much as half of this country. This is true. I’m not lying.” That young girl went outside and asked her mother, “What will I ask for?” Her mother said, “Go back in and ask the big boss to send a soldier to cut off John the Baptiser’s head and give it to you.” The girl ran back into the party and said to Herod, “I want you to give me John the Baptiser’s head on a big plate, and I want it right now.” When Herod heard her say that, he was really sad. But he didn’t want to break his promise. He didn’t want to feel shame in front of his friends, so he sent a soldier to cut off John’s head, and to bring it back to the girl on a big plate. The soldier went to the jail, and he cut off John’s head, and he brought it back to the party, and he gave it to the young girl, and then she gave it to her mother. John’s friends heard the bad news, so they came and got his body, then they took it away and buried it. Later lots of people heard about what Jesus was doing, and they talked about him all the time. Some people said, “Jesus is really Elijah, that old man that told God’s messages a long time ago. God made him alive again.” Some other people said, “Jesus is a man talking for God, just like those other men that told God’s messages a long time ago.” But some people reckoned, “Jesus is really John the Baptiser. God made John alive again, and God gave him power to do great things.” Herod heard those stories, and he said, “I got my soldiers to cut John’s head off, but this man, Jesus, he has to be John the Baptiser. I reckon God made him alive again.” ");
INSERT INTO engPEV_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Some time later, Jesus’s 12 special workers came back from telling his message to all the towns. They stood around Jesus and told him everything they did, and everything they taught the people in the towns. ");
INSERT INTO engPEV_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","While they were talking, lots of other people kept on coming up to Jesus, and Jesus and his followers didn’t have time to eat any food. So Jesus said to his followers, “Let’s go to a quiet place out bush, so that we can rest for a while.” ");
INSERT INTO engPEV_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Then Jesus and his followers got into a boat and started to go across the lake, to a quiet place away from all the people. But lots of people saw them leave. ");
INSERT INTO engPEV_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Those people were from a lot of different towns, but they knew the place that Jesus and his special workers were going to, so they ran around the side of the lake, and they got there first, before the boat. ");
INSERT INTO engPEV_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Then Jesus and his special workers got to that place, and they got out of the boat. Jesus looked at the mob of people waiting for him, and he felt sad for them. They didn’t have anyone looking after them. They were like a mob of sheep that had nobody to take care of them. So Jesus started to teach them lots of things. ");
INSERT INTO engPEV_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","At the end of the day, Jesus’s followers went to him and said, “It’s nearly time for the sun to go down, and we are way out here in the bush. ");
INSERT INTO engPEV_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","You have to send the people away from here so that they can find some food. They can go to a nearby farm or to a town, to buy some food to eat.” ");
INSERT INTO engPEV_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesus said to them, “No. You mob give them some food to eat.” But they said, “What? We haven’t got that much food. Do you want us to go and buy a lot of bread for them? That will cost thousands of dollars.” ");
INSERT INTO engPEV_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesus said to his followers, “How much food have you got? Go and see what there is.” They came back to him and said, “We’ve got 5 loaves of bread and 2 fish.” ");
INSERT INTO engPEV_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Jesus told his followers to get the people to sit on the green grass in groups, maybe about 50 people in each group, or maybe 100 people. ");
INSERT INTO engPEV_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Then Jesus picked up the bread and the fish, then he looked up to the sky, and he said, “Thank you God for this bread and this fish.” Then Jesus broke the bread and the fish into bits, and he gave them to his followers to give to the people. ");
INSERT INTO engPEV_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","All of the people got some bread and some fish, and they ate until they were full. ");
INSERT INTO engPEV_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","After that, Jesus’s followers picked up the bits of food that nobody ate. They filled up 12 big baskets with that left-over food. ");
INSERT INTO engPEV_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A really big mob of people ate that food. There were 5,000 men in that mob, as well as women and kids. ");
INSERT INTO engPEV_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","As soon as they finished eating, Jesus told his followers, “Get into the boat and row across the lake, to the place called Bethsayida. I will follow you mob some time later.” Then he started telling all the people, “You mob can all go home now. Goodbye.” ");
INSERT INTO engPEV_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","After he said goodbye to them, Jesus went up into the hills to pray. ");
INSERT INTO engPEV_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Then night time came, and Jesus was still alone on the land, and the boat was half-way across the lake. ");
INSERT INTO engPEV_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Later that night, Jesus looked out and saw that his followers were having a hard time rowing the boat. The wind was stopping them. Just before day-light, Jesus walked to them on top of the water, and it looked like he was going to keep going past them. ");
INSERT INTO engPEV_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","His followers saw him walking on the water, and they thought he was a ghost. They got really frightened, and they screamed. Straight away, Jesus said to them, “It’s all right. It’s me, I’m Jesus. Don’t be frightened.” ");
INSERT INTO engPEV_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Then Jesus got into the boat with his followers, and straight away the wind stopped blowing. The men in the boat were surprised. ");
INSERT INTO engPEV_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","They still couldn’t understand about Jesus. They saw what he did with the bread and the fish the day before, but they couldn’t work it out. It was like their brains were no good. ");
INSERT INTO engPEV_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Then they got to the dry land again, in the country called Gennesaret, and they tied up the boat. ");
INSERT INTO engPEV_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","A lot of people saw Jesus getting out of the boat, and they knew who he was, ");
INSERT INTO engPEV_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","so they ran around everywhere in that country, and they put the sick people on swags, and they carried them to Jesus, to wherever people said that Jesus was. ");
INSERT INTO engPEV_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesus went to little towns, and to big towns in that country. Wherever he went, the people carried their sick friends and family to the middle of the town, and they put them on the ground. Those sick people asked Jesus if they could touch his clothes, and everyone that touched his clothes got better. ");
INSERT INTO engPEV_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","There were some Jewish law teachers, and some of the Pharisee mob, that were strong for the Jewish law, they went from Jerusalem to see Jesus and his followers. A long time before that, those mobs made up a lot of rules that are not in God’s book. One of those rules that they made up was this. Before they could eat anything, they had to wash their hands in a special way, and after people came home from the shops, they had to wash that same way. There were other rules too, that those leaders made up, a long time ago. They had rules about the way to wash cups, and billycans, and cooking pots, and the chairs they sat on to eat their food. Those rules didn’t come from God. After they got there from Jerusalem, they saw that some of Jesus’s followers didn’t wash their hands that special way before they ate food. ");
INSERT INTO engPEV_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","So they said to Jesus, “Your followers are going wrong. They are not following the rules that our old leaders gave us a long time ago. They didn’t wash their hands the right way before they started to eat their food. You have to make them follow the rules properly.” ");
INSERT INTO engPEV_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesus said to them, “You mob tell everyone you are good, but really, you are not good. You know the man that was called Isaiah. He lived a long time ago, and he told God’s messages. He wrote true words about you, and they are in God’s book. He wrote, ‘These people show respect to me with their mouths, but really, they think another way. ");
INSERT INTO engPEV_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","They have ceremonies for me, but, really, they rubbish me. You see, they teach rules that men made up themselves, and they tell everybody that those rules come from God.’ ");
INSERT INTO engPEV_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","You mob are just like that. You turn your back on God’s law, but you are strong on the rules that men made up.” ");
INSERT INTO engPEV_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","And Jesus kept on talking to them. He said, “You mob are tricky in the way you turn your back on God’s law, and follow your own rules. ");
INSERT INTO engPEV_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","You see, God told Moses to tell everyone to look after their old people. Moses wrote this law, ‘You have to respect your father and mother.’ And he also wrote, ‘You have to punish anyone that rubbishes their father or mother. You have to kill that person.’ ");
INSERT INTO engPEV_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","But you mob reckon that somebody can tell their father or mother, ‘I want to help you old people, but I’m sorry. I know that you need that thing, but I promised to give it to God, so I can’t give it to you.’ ");
INSERT INTO engPEV_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","You reckon that if a person says that to their father or mother, they don’t have to help their father or mother. ");
INSERT INTO engPEV_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","When you tell people that, you take God’s word away from them, so they will just follow the rules that you made up. You do all sorts of wrong things like that all the time.” ");
INSERT INTO engPEV_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Then Jesus called out to all the people to come and listen to him. He said, “Listen to me, everyone, and try to understand what I’m saying. ");
INSERT INTO engPEV_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","It’s not the things you eat that make you no good. Don’t worry about what goes into you, but worry about what comes out of you. It’s the things that come out of you that make you no good.” ");
INSERT INTO engPEV_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","After that, Jesus stopped talking to all the people, and he went into the house to take a break. His followers went in with him, and they asked him what he meant by the words he just told the people. ");
INSERT INTO engPEV_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Jesus said, “What’s wrong with you? You still don’t understand what I’m saying. Listen. If you eat something, it goes into your belly, then, some time later, it goes out of your body into the toilet. It doesn’t go into your brain. So God will not say, ‘You ate the wrong food and made yourself no good.’ No, he will not say that.” (Jesus said that about food, and he made it clear for us that every sort of food is all right.) ");
INSERT INTO engPEV_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","23","Then Jesus kept on teaching his followers. He said, “People think inside their heads about bad things, and then they go wrong. They do those bad things, and that makes them no good. These are the things they might do. – They might think about all sorts of bad things. – They might sleep with somebody that is not their own husband or wife, and do what married people do together. – They might steal things. – They might murder somebody. – They might sleep with somebody else’s husband or wife, as if they are married to them. – They might be greedy, and try to get lots of money and things. – They might do really bad things. – They might trick people. – They might do the first bad thing that they think about. – They might want to get something that other people have. – They might rubbish people. – They might think that they themselves are great. – They might only think about what they want for themselves, and do really stupid things. All those bad things come from people thinking the wrong way inside their heads, and those things make people no good.” ");
INSERT INTO engPEV_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","After that, Jesus left Galilee country and went north to a town called Tyre. The people that lived in Tyre were not Jewish people. Jesus and his followers stayed at somebody’s house there. He didn’t want other people to know that he was in that house. But a lot of people heard that he was there. ");
INSERT INTO engPEV_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","There was a woman in that town that was not a Jewish woman. She was from a place called Fonisha, in Syria country. Her daughter had a bad spirit inside her, so that woman went to Jesus to get help. She got down on her knees in front of Jesus, to show him respect, and she asked him to force the bad spirit out of her daughter. ");
INSERT INTO engPEV_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesus said to her, “You know, a man gives food to his own kids first. He will not take their food and throw it to the dogs. Well, that is a picture of me. I belong to the Jewish nation. I have to look after my own people first, not you people that are not Jewish.” ");
INSERT INTO engPEV_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","The woman said, “Yes, teacher, you are right about that, but while the kids in that picture story are eating, they drop a few little bits of food, and the dogs under the table can eat those little bits of food. So you can still do a little thing to help me, even though I’m not Jewish.” ");
INSERT INTO engPEV_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesus said, “That’s a good answer. It shows me that you trust me. You can go home now. I just made that bad spirit go out from your daughter.” ");
INSERT INTO engPEV_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Then the woman went home and found her daughter lying down quietly on a bed. The bad spirit was not in her any more. ");
INSERT INTO engPEV_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Then Jesus left Tyre and walked back through another town called Sidon. Then he went around the north of Lake Galilee to the country everyone called Ten Towns. ");
INSERT INTO engPEV_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Some people brought a man to Jesus. That man was deaf, and he couldn’t talk properly. His friends asked Jesus strongly to put his hand on their friend and make him better. ");
INSERT INTO engPEV_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesus took the man away from all the other people there and put his fingers in the man’s ears. He spat and touched the man’s tongue. ");
INSERT INTO engPEV_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Then Jesus looked up into the sky and prayed for the man. He talked in their language. He said, “Efatha.” That means, Open up. ");
INSERT INTO engPEV_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","And straight away, that man could hear properly, and his tongue was better so he could talk properly. ");
INSERT INTO engPEV_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesus went back and told the people strongly, “Don’t tell anyone about the great thing I just did.” But they didn’t listen to Jesus. Jesus kept on telling them not to talk about it, but they just kept on telling other people, “Jesus made that man better.” ");
INSERT INTO engPEV_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Everyone was really surprised, and they said to each other, “Jesus does everything properly. He does really good things for people. He makes deaf people better, so they can hear again. And people that can’t talk, he makes them better too, so they can talk.” ");
INSERT INTO engPEV_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jesus kept on teaching the people in that country. A big mob of people stayed there and listened to him for 3 days. And in that time, they finished up all their food. ");
INSERT INTO engPEV_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Jesus called to his followers to come to him, and he said, “I feel really sorry for this mob. They are hungry, and they haven’t got anything to eat. ");
INSERT INTO engPEV_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","I can’t send them home like this. Some of them have walked a long way to get here, and if they start walking home now, they will get weak and fall down. We have to give them some food.” ");
INSERT INTO engPEV_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","His followers said, “But they are a really big mob of people. We can’t get enough food out here in the bush to feed them all.” ");
INSERT INTO engPEV_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesus said, “How much bread have you got?” The men said, “7 loaves of bread.” ");
INSERT INTO engPEV_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Then Jesus told the people to sit down on the ground. Then he picked up the 7 loaves of bread and said, “Thank you God for this bread.” Then Jesus broke it into bits and gave it to his followers, and they gave it out to all the people. ");
INSERT INTO engPEV_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Somebody had some little fish there, and they gave them to Jesus, and he said, “Thank you God for these fish.” Then Jesus also gave the fish to his followers, to give out to the people. ");
INSERT INTO engPEV_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","They all ate and ate until they were full, and there was a lot of food that they didn’t eat. Then they picked up all those left-over bits of food, and they filled up 7 baskets with it. ");
INSERT INTO engPEV_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","There were 4,000 men in that big mob. After they finished eating that food, Jesus told them to go home. ");
INSERT INTO engPEV_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Straight away, Jesus and his followers got into a boat and went across the lake to a place called Dalmanutha. ");
INSERT INTO engPEV_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","There were some of the Pharisee mob at that place. They were strong for the Jewish law. They heard people say that Jesus was there, so they came to talk to him. They wanted to trick him, so they started to argue with him. They said, “Hey, show us that God sent you here. Do something powerful so we can see that you have special power from God.” ");
INSERT INTO engPEV_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesus was a little bit upset. He breathed deeply and said, “You mob that are alive today always want to see something powerful, and if I don’t do something powerful, you will not believe that I came from God. Listen, I will not do anything powerful for you mob here now.” ");
INSERT INTO engPEV_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Then Jesus and his followers walked away from that Pharisee mob, and they got into a boat and went across to the other side of the lake. ");
INSERT INTO engPEV_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","But, before they got into the boat to go across the lake, Jesus’s followers forgot to buy more food. So they only had one loaf of bread with them. ");
INSERT INTO engPEV_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesus talked straight to his followers. He said, “You know how we make damper. We put some baking powder into the flour to make it swell up. Well, I’m telling you this, stay away from the baking powder that comes from the Pharisee mob, that are strong for our law, and stay away from the baking powder that comes from Herod, the big boss.” ");
INSERT INTO engPEV_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jesus’s followers didn’t understand what Jesus meant, and they started to argue with each other. They said, “We didn’t get enough food for the trip. That is what he is talking about.” ");
INSERT INTO engPEV_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus knew what they said to each other, and he said, “Why are you mob arguing about food? You still haven’t learned about me. You don’t understand me. Maybe your minds are closed. ");
INSERT INTO engPEV_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","You’ve got eyes, but you don’t look. You’ve got ears, but you don’t listen. Do you remember the time we had 5 loaves of bread, and I gave food to 5,000 men? How many baskets of left-over bits did you pick up?” They said, “12 baskets full.” ");
INSERT INTO engPEV_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Then Jesus said, “Do you remember the time we had 7 loaves of bread, and I gave food to 4,000 men? How many baskets of left-over bits did you pick up?” They said, “7 baskets full.” ");
INSERT INTO engPEV_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Then Jesus asked them, “So how come you still don’t understand about me?” ");
INSERT INTO engPEV_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesus and his followers got to a place called Bethsayida, on the west side of Lake Galilee, and they got out of the boat. Some people brought a blind man to him, and they asked Jesus to touch him and make him better. ");
INSERT INTO engPEV_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesus held the man’s hand and took him outside the town. Then Jesus spat on the man’s eyes, and then put his hands on him and said, “Can you see anything now?” ");
INSERT INTO engPEV_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","The man looked around and said, “Yes, I can see a little bit. I can see people, but they look like trees walking around.” ");
INSERT INTO engPEV_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","So Jesus put his hands on the man’s eyes again. Then the man carefully looked around again, and his eyes were properly better, and he saw everything clearly. ");
INSERT INTO engPEV_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesus told the man to go straight home. He said, “As you walk home, don’t go into that town. Don’t let anyone see that I made you better.” ");
INSERT INTO engPEV_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Then Jesus and his followers left Galilee country, and they went north to some towns in the country called Caesarea-Philippi. As they walked along the track, Jesus asked his followers, “When people talk about me, who do they reckon I really am?” ");
INSERT INTO engPEV_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","They said, “They reckon you are one of God’s men that died, but then God made you come alive again. Some people reckon you are John the Baptiser. Other people reckon you are Elijah, that man that lived a long time ago. And other people reckon you are one of those other men that told God’s messages a long time ago.” ");
INSERT INTO engPEV_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Then Jesus asked them, “Who do you reckon I really am?” Peter said straight out, “You are the Christ, the special man that God promised to send to save us.” ");
INSERT INTO engPEV_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesus told them strongly, “Don’t say that to anyone else. Don’t tell anyone about me.” ");
INSERT INTO engPEV_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Then Jesus told his followers about the bad things that were going to happen to him. He said, “I am God’s special man from heaven, but our Jewish elders, and our ceremony bosses, and our law teachers, they will all reckon I’m no good. They will hurt me badly in lots of ways, and they will kill me. I will be dead for 2 nights, then on the 3rd day I will come alive again.” ");
INSERT INTO engPEV_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesus talked straight to them, but Peter couldn’t believe it. He took Jesus away from the others and told him not to talk like that. ");
INSERT INTO engPEV_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesus turned around and looked at his other followers there, then he said strongly to Peter, “Go away from me. You are like Satan, the boss over the bad spirits. You are not thinking God’s way. You are just thinking like a man.” ");
INSERT INTO engPEV_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Then Jesus called out to all the people that were there. He called them to come up close, with his followers, and he said to them all, “If any of you wants to follow me properly, you have to stop thinking only about yourself. You have to live like me. You have to be ready to die, yes, die like a criminal on a cross, just like I will die. ");
INSERT INTO engPEV_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","If you only want to look after your own life here on earth, you will lose it. You will not live for ever with me. But if you are ready to give up your life here, and live my way, and tell other people the good news about me, then you will find real life, and you will live with me for ever. ");
INSERT INTO engPEV_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","You see, you might get lots of money and things for yourself, and you might even get everything in the world. But if you miss out on real life, and you don’t live for ever with me, all that stuff is useless to you. ");
INSERT INTO engPEV_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","You can’t use it to get that real life. ");
INSERT INTO engPEV_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","You know that some people are really bad, and they don’t take any notice of God. If you are frightened of them, so that you don’t tell them about me, and you don’t say that you belong to me, then later, I will not say that you belong to me. I’m God’s special man from heaven, and one day my father, God, will make me really great, and I will come back here to the earth, with all God’s angel messengers. But if you don’t tell people now that you belong to me, then when I come back here, I will not say that you belong to me.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Then Jesus said, “Listen, some of you people will see a very special thing. God will show you that he is boss over everything, and you will see that he is really powerful. You will see that happen before you die.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","After 6 days, Jesus got Peter, and James, and John, and they went by themselves up to the top of a big hill. While they were there, Jesus started to look different. ");
INSERT INTO engPEV_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","His clothes got really white and shiny. Nobody can wash clothes good enough to make them properly white like that. ");
INSERT INTO engPEV_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","And Peter, James and John saw 2 men that lived a long time ago. They were Elijah and Moses. Elijah was a man that told God’s messages to people, and Moses was a leader of the Israel nation. They were there, and they talked to Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Peter, James and John were very surprised and frightened, and they didn’t know what to say. But Peter talked anyway. He said to Jesus, “Teacher, it is good that we are here. We can put up 3 special bush shades here, one for you, one for Moses and one for Elijah.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Then a cloud covered them all, and God talked to them from the cloud. He said, “This is my son. I love him very much. You have to listen properly to him.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Then Peter, James and John looked around for those 2 old men, but they couldn’t see them any more. Only Jesus was there with them. ");
INSERT INTO engPEV_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Then they all started to come down from the hill. And as they walked along, Jesus told them really straight, “Don’t tell anyone what you just saw. You have to wait until after I die. I’m God’s special man, and I will die, and then I will come back alive again. After that, you can talk about what you saw.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","So Peter, James and John kept quiet about it. They didn’t tell anyone, but they talked to each other about the words Jesus said, “I will die, and then I will come back alive again.” They didn’t know what Jesus meant. ");
INSERT INTO engPEV_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Then they asked Jesus about the Jewish law teachers. They said, “Those law teachers say that first of all Elijah has to come back, God’s man that lived a long time ago. He has to come back, and after that, God will send his special man.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Jesus said, “Those law teachers are right. That man did come, and he told them God’s message, just like Elijah did a long time ago. That man got things ready for me, but bad people killed him. And they will do the same to me, God’s special man from heaven. They will turn against me and not listen to me, and they will hurt me a lot. A long time ago God got his men to write about that, and it is in God’s book.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","They came back down the hill, and they found Jesus’s other followers arguing with the Jewish law teachers. There were lots of people standing around. ");
INSERT INTO engPEV_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","That mob looked up and saw Jesus, and they were surprised, and they all ran to him, and they said hello to him. ");
INSERT INTO engPEV_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesus asked them, “What are you mob all arguing about?” ");
INSERT INTO engPEV_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","One of them said, “Teacher, my son has a bad spirit inside him, and it stops him from talking. ");
INSERT INTO engPEV_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","It pushes the boy down on to the ground, and his body goes stiff, and he rubs his teeth together, and spit comes out of his mouth. I asked your followers, ‘Please force that bad spirit out of him.’ But they can’t do it.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesus said, “Look, you mob, I’ve been here with you a long time, but still you don’t trust God properly. I can’t stay here and wait for you for ever. All right, bring the boy here to me.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","The people brought the boy to Jesus. As soon as that bad spirit saw Jesus, it shook the boy and pushed him down, so that he wriggled around on the ground, and a lot of spit came out of his mouth. ");
INSERT INTO engPEV_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesus asked the boy’s father, “How long has your boy been like this?” The man said, “For a long time, from when he was a little kid. ");
INSERT INTO engPEV_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Lots of times the bad spirit pushed him into fires and into water. That bad spirit is trying to kill him. Please feel sorry for us, and help him if you can.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus said, “You said to me, ‘If you can.’ But you know that God is strong enough to do anything if you trust him to do it, right?” ");
INSERT INTO engPEV_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","The boy’s father yelled out, “I believe God can do it. But please help me believe properly.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesus looked around, and he saw a big mob of people coming to watch, so he talked strongly to the bad spirit. He said, “Listen, you bad spirit. You stop people from talking and hearing. I’m telling you now, come out of this little boy, and stay out of him. You can never go back into him.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Then the bad spirit screamed, and it forced the boy to have another bad fit and fall down on the ground, then it went out of the boy. The boy looked like he was dead, and a lot of people said, “Poor boy, he’s finished.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","But Jesus grabbed the boy’s hand and helped him stand up. Then the boy’s father took him home. ");
INSERT INTO engPEV_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","After that, Jesus and his followers went into a house, and his followers asked him quietly, “Why couldn’t we force the bad spirit out of that boy?” ");
INSERT INTO engPEV_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesus told them, “The only way you can force that sort of bad spirit out of somebody is to pray to God, and get him to force it out.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Later Jesus and his followers left that place and went through Galilee country. He didn’t want everyone to know where he was going, so they went along secretly and quietly, and he was teaching his followers as they walked along. He told them about what was going to happen to him. He said, “I’m God’s special man from heaven, but bad men will grab me, and they will kill me. I will be dead for 2 nights, then on the 3rd day I will come alive again.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","His followers couldn’t understand what he was talking about. But they felt shame, so they didn’t ask him about it. ");
INSERT INTO engPEV_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","While they walked along the road, Jesus’s followers argued with each other about which one of them was the most important. Then, after they got to Capernium, they all went into a house, and Jesus asked them, “What were you arguing about on the road?” His followers didn’t answer him. They felt too much shame. ");
INSERT INTO engPEV_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Then Jesus sat down to teach them, and he called to his 12 special workers to come close to him, and he said, “If any one of you wants to be the leader, you have to think to yourself, ‘I’m not important at all.’ And you have to be a worker for everyone else.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","There was a young kid in that house, and Jesus picked him up and said, “Look at this little kid. If you follow me, and if you are friendly to little kids like this one, and if you help them, well, really you are friendly to me too. And if you are friendly to me, well, really you are friendly to my father in heaven too. He is the one that sent me here.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John said to Jesus, “Teacher, we saw a man forcing bad spirits out of people, and he was using your power by saying your name. But he’s not one of our mob. So we told him to stop.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","But Jesus said, “No. Don’t stop him. If somebody uses my power by saying my name to do good and powerful things for people, that person can’t soon turn around and say bad things about me. ");
INSERT INTO engPEV_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","You see, if somebody is not trying to stop us, well, that person is really on our side. ");
INSERT INTO engPEV_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","And listen, if somebody knows that you are my follower, and so they try to help you, even if they just give you a drink of water, God will be sure to pay that person with something good for that good thing they did.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesus kept on teaching his followers. He said, “If a little kid trusts me, and if somebody gets that little kid to do something bad, God will properly punish that person. Suppose somebody gets a big stone and ties it to that person’s neck and throws them into the sea and drowns them, that is bad for that person, but it is not as bad as the trouble God will give them for getting that little kid to go wrong. ");
INSERT INTO engPEV_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Look, if there is something that gets you to go wrong, you have to stop yourself. If you want to do something bad with your hand, you have to stop yourself from doing it. It is like you have to cut off your hand. It is better for you to live with God for ever with only one hand, than for God to send you to hell with 2 hands. That fire in hell never goes out. ");
INSERT INTO engPEV_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","In the same way, if you want to do something bad with your foot, you have to stop yourself from doing it. It is like you have to cut off your foot. It is better for you to live with God for ever with only one foot, than for God to send you to hell with 2 feet. ");
INSERT INTO engPEV_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","It is the same for your eye. If you want to look with your eye at something, and if it gets you to do something bad, you have to look away. It is like you have to dig your eye out. It is better for you to be in God’s family with only one eye, than for God to send you to hell with 2 eyes. ");
INSERT INTO engPEV_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Hell is a really bad place and people that go there will have bad pain all the time. It will be like maggots are eating them all the time, and like a fire is burning them all the time. Their pain will never stop.” ");
INSERT INTO engPEV_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Jesus also said to them, “God is going to let you have some trouble. He wants to test you to see if you are following him properly. You know how people shake salt on to food to make it good? Well, this trouble will be like God is shaking fire on to you, and it will make you good. ");
INSERT INTO engPEV_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","You know that salt is good. It makes food better. But if that salt loses its salty taste, it is no good any more, and you can’t fix it up. That is a picture of you mob. You have to be like good salt for people. You have to try to make their lives better, and don’t fight with anyone, but live happy and quiet together.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesus left Capernium in Galilee and went south, through Judea to the country on the east side of the Jordan River. A lot of people went to him there, and he taught them God’s word, the same as he always did. ");
INSERT INTO engPEV_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Some of the Pharisee mob also went to Jesus. They were strong for the Jewish law, and they tried to trick Jesus with a hard question. They said, “Is it all right for a man to break up his marriage, and send his wife away?” ");
INSERT INTO engPEV_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesus said, “What did Moses write in the law part of God’s book?” ");
INSERT INTO engPEV_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","The Pharisee mob said, “Moses wrote a law like this, ‘A man can split up from his wife. That man has to write a divorce letter to say she is not his wife any more. He has to give that letter to his wife, and then he can force her to go away.’” ");
INSERT INTO engPEV_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus said to them, “You people have closed ears, and you will not listen to God, so Moses had to write those words for you like that. ");
INSERT INTO engPEV_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","But God tells us in his book that he made people and everything else. His book says, ‘He made them man and woman.’ ");
INSERT INTO engPEV_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","And he tells us, ‘A man will leave his mother and father and marry a woman. The man and his wife will join with each other, and their bodies will be like one body again.’ ");
INSERT INTO engPEV_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","So they are not 2 people any more. They are like just one body. ");
INSERT INTO engPEV_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","You see, God joined them together like that, so don’t let anyone split them up.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","After that, Jesus went back to the house with just his followers, and they asked him more about the things he said. ");
INSERT INTO engPEV_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesus said to them, “If a man splits up from his wife, and then if he marries another woman, he is sleeping with the wrong woman as if she is his proper wife. But she is not, and he is breaking God’s law, and he is doing wrong to his proper wife. ");
INSERT INTO engPEV_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","And if a woman splits up from her husband, and then if she marries another man, she is sleeping with the wrong man as if he is her proper husband. But he is not, and she is breaking God’s law, and she is doing wrong to her proper husband.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Some time later, some people took their kids to Jesus. They wanted him to put his hands on them, and ask God to be good to them. But Jesus’s followers got angry with those people and told them to take their kids away. ");
INSERT INTO engPEV_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesus saw his followers stopping the kids from coming to him, and he got upset. He said, “Don’t stop those kids. Let them come to me. They are the sort of people God wants. You see, if you are like these little kids, God will let you join his family. ");
INSERT INTO engPEV_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","You know, little kids know they are weak and not important, so they trust their mothers and fathers and do what they say. Well, I’m telling you straight, you have to be like those kids. You have to trust God and let him be your boss. If you can’t do that, you can’t be in God’s family.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Then Jesus held those kids in his arms, and he prayed for God to be good to them. ");
INSERT INTO engPEV_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","After that, Jesus started to leave that place. Then a man ran up to him and got down on his knees to show Jesus respect. The man said, “Teacher, you are a good man. Tell me, what can I do so that I will live with God for ever?” ");
INSERT INTO engPEV_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesus said, “You call me good, but think about it. Only God is properly good. ");
INSERT INTO engPEV_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","You know God’s laws, – Don’t murder anyone. – Don’t sleep with a woman that is not your wife, as if you are married to her. – Don’t steal things that belong to other people. – Don’t tell lies about anybody. – Don’t trick people to get something from them. – You always have to respect your father and your mother.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","That man said, “Teacher, I always do all those things. I always lived like that, from when I was a boy.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus looked at him, and he loved him. And Jesus said, “There is still one more thing you have to do. Go and sell all your things to get some money, and give all that money to people that haven’t got anything. After you do that, God will be really happy with you. And later, in heaven, he will give you lots of other good things. So go and do what I told you, then come with me, and follow me.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","That man heard what Jesus said, and he got really sad. He was a rich man, but Jesus told him to give all his things away. That made him very sad, and he just walked away with his eyes looking down. ");
INSERT INTO engPEV_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","After that man left, Jesus looked around at his followers, and he said, “It’s really hard for rich people to join God’s family and to let him be their boss.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","25","This shocked Jesus’s followers. So he told them more. He said, “It is hard for anyone to let God be their boss. Think about a big camel. Do you reckon it can go through the little hole in a needle? No, it can’t. But I’m telling you, it’s more easy for a big camel to get through that little hole, than for a rich person to get into God’s family. Rich people find it really hard to let God be the boss over their lives.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","This shocked Jesus’s followers, and they said to each other, “Is there anyone that God will save and take into his family? Maybe nobody.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus looked straight at them and said, “Nobody is good enough to get into God’s family. But God can make people good enough. God can do anything.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peter said to Jesus, “We have left everything to follow you. What about us?” ");
INSERT INTO engPEV_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Jesus said, “Listen, if anyone leaves anything, so that they can tell people God’s good news, they will get back more than they leave. If somebody leaves their home, or their brothers, or their sisters, or their mother, or their father, or their kids, or their land, so that they can follow me and tell people God’s good news, they will get a much better life. They will get a lot more homes, a lot more brothers and sisters, a lot more mothers, a lot more kids, and a lot more land. But I have to tell you this too. If they do this work for me, they will get trouble from other people. But later they will live with God for ever. ");
INSERT INTO engPEV_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","People that are important leaders today will find out later that they are nothing. God will make them workers for everybody. And people that are just workers today will be the important leaders later.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Then Jesus and his followers walked along the road towards Jerusalem, and Jesus went ahead of his followers. Jesus’s special workers were shocked because there were people in Jerusalem that wanted to make big trouble for Jesus, but he wanted to go there anyway. And his other followers were frightened too. Then Jesus stopped walking, and he took his 12 special workers away from the other people, and he told them what was going to happen to him later. ");
INSERT INTO engPEV_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jesus said, “We are all going to Jerusalem, and after we get there, somebody will change sides, and he will help the other mob catch me. That other mob are the bosses of our Jewish ceremonies and our law teachers. I’m God’s special man from heaven, but those Jewish leaders will grab me and take me to the Roman bosses. The Jewish leaders will say that I’m guilty, and they will tell the Romans to kill me. ");
INSERT INTO engPEV_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Then the Romans will make fun of me, and spit on me. They will hit me with whips, and then they will kill me. I will be dead for 2 nights, then on the 3rd day I will come alive again.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Then James and John, the sons of Zebedee, went up to Jesus and said, “Teacher, we want you to do something good for us. Will you do what we ask you?” ");
INSERT INTO engPEV_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesus asked them, “What do you want me to do?” ");
INSERT INTO engPEV_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","They said, “Later you will be the most important leader. Can you make us the next most important? Can you let one of us sit on one side of you, and the other one sit on the other side of you?” ");
INSERT INTO engPEV_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesus said, “You 2 don’t understand what you are asking me. People will give me a really hard time. Do you reckon you can stay strong for God even when people give you a really hard time? I will have really bad pain. It’s like I will have to drink really bad drink, like poison. I will even die.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","James and John said, “Yes. We can do that.” So Jesus said, “You are right. You will get the same hard time as me, and you will get bad pain like I will get. ");
INSERT INTO engPEV_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","But I can’t give you what you want. God is the one that picks the people that will be the important leaders, and he picks the people that will sit beside me later on.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jesus’s other 10 special workers heard what James and John asked for, and they got angry. ");
INSERT INTO engPEV_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","So Jesus called them all together and said, “You know what government people are like here in this world. They like to be bosses over everybody. It is like that everywhere in this world, the leaders boss everyone around, and the big bosses like to show everyone that they are strong. ");
INSERT INTO engPEV_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","But I don’t want you to be like that. If you want to be a leader of my people, you have to really want to help them, so you have to work hard for them, and don’t think about pay. And if you want to be the most important person, you have to be a worker for everyone. ");
INSERT INTO engPEV_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","You see, all the leaders of my people have to be like that. They have to be just like me. I’m God’s special man from heaven, but I didn’t come here to be bossy and get people to work for me. I came here to work for other people. And I came here to die for a lot of people. I will let God punish me instead of them. He will punish me for the bad things that they did.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesus and his followers kept going towards Jerusalem, and they walked through a town called Jericho. As they left Jericho, a big mob of people walked with them along the road. A blind man was sitting at the side of that road, asking people to give him money so that he could buy some food. He was called Bartimayus. His father’s name was Timayus. ");
INSERT INTO engPEV_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bartimayus heard that Jesus from Nazareth was coming along the road, so he started to yell out, “Jesus, you belong to David’s family, and you are the man that God promised to send to us. Please feel sorry for me, and help me.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","A lot of the people there told him to be quiet, but he kept on yelling out even louder, “You belong to David’s family, and you are the man that God promised to send to us. Please feel sorry for me, and help me.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus stopped and said, “Tell him to come to me.” So they called out to the blind man, and they said, “Listen, Jesus is calling out for you. So you can be happy now. Get up and go to him.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","That blind man jumped up. He didn’t worry about his coat. He left it behind on the ground. He just got up and walked to Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesus asked him, “What do you want me to do for you?” That blind man said, “Teacher, I just want to see again.” ");
INSERT INTO engPEV_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesus said to him, “You believe in me, so now you can see again. You can go home now.” Straight away, Bartimayus could see again, and he joined in with the other people and followed Jesus along that road. ");
INSERT INTO engPEV_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesus and his followers kept going, and they got near to Jerusalem. They came to the 2 towns called Bethany and Bethfage, on the hill called Olive Trees Hill. ");
INSERT INTO engPEV_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Then Jesus told 2 of his followers to go to a town nearby. He said, “As soon as you get there you will see a donkey tied to a post. Nobody ever rode that young donkey yet. I want you to untie that donkey and bring it to me. ");
INSERT INTO engPEV_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","If anyone asks you why you are taking that donkey, you can say, ‘Our leader needs it for a while, but don’t worry, he will send it back to you later.’” ");
INSERT INTO engPEV_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","The 2 men went into the town, and they found the donkey near the door of a house, then they started to untie him. ");
INSERT INTO engPEV_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Some people standing there said to them, “What are you doing? Why are you untying that young donkey?” ");
INSERT INTO engPEV_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesus’s followers told them what Jesus said, and then those people let them take the donkey and go. ");
INSERT INTO engPEV_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","They took the donkey back to Jesus. Then they put their coats on top of the donkey, and Jesus sat on their coats on the donkey, and he started to ride it into Jerusalem. ");
INSERT INTO engPEV_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","A lot of people laid their coats down on to the track in front of the donkey, and other people cut leafy branches from trees, and they put them on the track for the donkey to walk on. ");
INSERT INTO engPEV_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Some of the people walked in front of Jesus, and some of them walked behind him. They all kept on yelling out, “God, you are really great and powerful. God, we want you to look after the man you have sent. Make him strong and happy. ");
INSERT INTO engPEV_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","God, please make this man our big boss, just like David was our big boss. David was our grand-father that lived a long time ago. God in heaven, you are very great and powerful.” ");
INSERT INTO engPEV_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Then Jesus got to Jerusalem, and he went into God’s ceremony house. He looked around at everything that was going on there. The sun was starting to go down, so Jesus left God’s ceremony house, and he and his 12 special workers went back to Bethany. ");
INSERT INTO engPEV_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","13","The next morning, Jesus and his followers started to walk from Bethany back to Jerusalem. Jesus saw a tree not far away. It was the sort of tree that gets fruit, called figs. Jesus was hungry, so he went to look for some figs on that tree, but there was nothing. It had lots of leaves, but no fruit. You see, it was not yet the right time of the year for that sort of fruit. ");
INSERT INTO engPEV_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","His followers heard Jesus say to that tree, “Nobody will ever eat any fruit from you again.” ");
INSERT INTO engPEV_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Then Jesus and his followers went into Jerusalem, and they went to God’s ceremony house. Inside that house people were buying and selling animals and pigeons, to use in their ceremonies. And other people were taking people’s Roman money and giving them Jewish money, to give to the bosses of God’s ceremony house. But they did those things inside that house. They didn’t respect God’s house, so they were wrong. So Jesus hunted all those people out of God’s ceremony house. He hunted out all the men that sold things, and the people that bought things, and those people that changed money. He knocked over their tables with their money on them, and he knocked over the chairs of the men that sold pigeons. ");
INSERT INTO engPEV_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","He wouldn’t let anyone carry those things through God’s ceremony house. ");
INSERT INTO engPEV_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Then Jesus taught everyone. He said, “Do you know what God says? These words are in his book, ‘God wants his special house to be a place for people from every tribe to come and pray in.’ But you mob turned God’s house into a place where criminals steal money from people.” ");
INSERT INTO engPEV_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","The Jewish law teachers and the bosses of the Jewish ceremonies heard about what Jesus did at God’s house, and they were angry. But all the other people were really happy with Jesus. Whenever he taught them, they listened to him, and they were really surprised by the things he said. So the Jewish leaders were frightened of him. They thought that maybe everyone was going to listen to Jesus and stop listening to them. So those leaders started to work out a way to kill Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Later that day, when the sun started to go down, Jesus and his followers left Jerusalem and went back to Bethany. ");
INSERT INTO engPEV_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","In the morning, Jesus and his followers walked past that fruit tree that he talked to the day before. They looked at it. It was dead and dry, right down to the ground. ");
INSERT INTO engPEV_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter remembered the words Jesus said to it, and Peter said, “Teacher, that tree you cursed is already dead and dry.” ");
INSERT INTO engPEV_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesus said, “If you trust God properly, you can do things like that too. ");
INSERT INTO engPEV_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Listen, if you ask God to do something, and if you really trust him to do it, then he will do it for you. If you trust him properly, you can even say to a big hill, ‘God will pick you up and throw you into the sea,’ and God will do it. ");
INSERT INTO engPEV_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","So I’m telling you, if you ask God for something, and if you trust him properly, that is, if you believe that he will give you that thing, then God will make it happen for you. ");
INSERT INTO engPEV_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","And whenever you pray, first think about this. If somebody did a wrong thing to you, you have to let it go. Don’t think about payback. If you let it go, then God will let go of all the wrong things you have done too. He will say you are not guilty, and he will not do payback. So before you pray to God, you have to let go of all the wrong things that people did to you.” ");
INSERT INTO engPEV_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Then Jesus and his followers went into Jerusalem, and they walked into the yard of God’s ceremony house. As Jesus walked along, some Jewish leaders went up to him. They were some bosses of the Jewish ceremonies, and some law teachers, and some elders. ");
INSERT INTO engPEV_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","They asked Jesus straight, “Who told you to hunt all those people out of God’s ceremony house? What big boss said that you can do that?” ");
INSERT INTO engPEV_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesus said to them, “You answer my question first. If you answer me, then I will tell you which big boss said that I can hunt those men out of God’s ceremony house. ");
INSERT INTO engPEV_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","My question is about John the Baptiser. Who told him to do that washing ceremony for people? Did people tell John to do that, or did God tell him to do it?” ");
INSERT INTO engPEV_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Those Jewish leaders talked together to work out their answer. They said to each other, “If we say that God told John to do it, then we will be in trouble. He will say to us, ‘So why didn’t you mob listen to him?’ ");
INSERT INTO engPEV_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","But we can’t say that people told him to do it.” You see, those leaders were frightened of the people there. They knew that the people believed that John was God’s man. So if those leaders said that John wasn’t God’s man, then the people might hit them. ");
INSERT INTO engPEV_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","So the Jewish leaders said, “We don’t know who told John to do that washing ceremony for people.” Then Jesus said, “You did not answer me, so I will not answer you. I will not tell you which big boss said that I can do those things.” ");
INSERT INTO engPEV_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","After that, Jesus told them all a picture story. He said, “A man planted some fruit trees in his garden. Then he built a strong fence around it, and he made all the things he needed to look after those trees properly. Then he got some men to look after those trees for him. They agreed to give him some of the fruit from that garden, instead of paying rent money for it. After that, the owner went away to another country. ");
INSERT INTO engPEV_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","The time came for the men to pick the fruit, and the owner sent one of his work-men to get some of his fruit from the garden. ");
INSERT INTO engPEV_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","But the men in the garden grabbed that work-man, and they beat him up, and they sent him back with nothing. ");
INSERT INTO engPEV_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Then the owner sent another work-man to the garden, but those men hit him on the head and said bad things to him. ");
INSERT INTO engPEV_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","After that, the owner sent another work-man to the garden, and this time the men killed him. Again and again the owner sent work-men to get some of his fruit, but the men in the garden killed some of them, and they beat up the others. ");
INSERT INTO engPEV_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","The owner of the garden had one more person to send to get the fruit from the garden. The owner said to himself, ‘I will try one more time. I will send my son. I love him, and those men in the garden will respect him too.’ So he sent his son to that garden. ");
INSERT INTO engPEV_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","But the men in the garden saw the owner’s son, and they said to themselves, ‘After that old man dies this young man will get this garden for himself. Let’s kill this man now so that we can get the garden for ourselves.’ ");
INSERT INTO engPEV_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","So they grabbed the young man, and they killed him and chucked his body out of the garden.” ");
INSERT INTO engPEV_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Then Jesus asked the people, “What do you reckon the owner of that garden will do? I’m telling you, he will go to the garden and kill all those men there. Then he will get other people to look after the garden for him.” ");
INSERT INTO engPEV_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Then Jesus said, “You mob can read this picture story in God’s book, so think about its message. God said, ‘Some workers built a house out of big stones, but those workers thought one of those stones was rubbish, so they chucked it away. They were wrong. That stone was properly good, and now God made it the most important stone of all. ");
INSERT INTO engPEV_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yes, God did that, and we are really happy about it. We reckon he did something great.’” ");
INSERT INTO engPEV_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","The Jewish leaders heard that story, and they knew that it was a picture of themselves, that they were the bad workers in the story. They got angry, and they wanted to grab Jesus and take him to jail. But they were frightened of the big mob of people there, so they just walked away and left him alone. ");
INSERT INTO engPEV_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Then the Jewish leaders sent some other men to try to trick Jesus. They sent some of the law men that were called Pharisees, and they sent some men that were good friends of Herod. Herod was the big government boss at that time. Those men tried to get Jesus to say something wrong, so they could make trouble for him. ");
INSERT INTO engPEV_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","They said to Jesus, “Teacher, we know that you always want to do the right thing, and you always say true words. You talk to everyone the same way, people that are important and people that are not important. You always teach God’s words the right way. Well, we have a question about the Roman government bosses over our country. Is it right or wrong for us Jews to pay tax money to them?” ");
INSERT INTO engPEV_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesus knew that if he said, “Don’t pay that tax money,” then he will be in trouble with the Roman bosses, and if he said, “Pay that tax money,” then he will be in trouble with the Jewish people. They wanted to be free from the Roman bosses. So Jesus said, “Don’t try to trick me. Have you got some money? I want to look at a coin.” ");
INSERT INTO engPEV_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","The men gave Jesus a coin. He looked at it and said, “Who is this on this money? Whose picture is this? And whose name is this?” They said, “That is Caesar, the Roman government’s big boss.” ");
INSERT INTO engPEV_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesus said, “Well, you have to give Caesar and the Roman government whatever belongs to them, and you have to give God whatever belongs to him.” When they heard him say that they were all really surprised. ");
INSERT INTO engPEV_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","There were some Jewish people that believed that after somebody dies they will stay dead, and they will never come alive again. They were called Sadducees. They tried to trick Jesus too. ");
INSERT INTO engPEV_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","They said to him, “Teacher, Moses wrote down God’s law like this, he said, ‘If a married man has no kids, and if he dies, then his brother has to marry his widow. Then they have to have kids, and everyone will call those kids that dead brother’s kids.’ ");
INSERT INTO engPEV_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","But what about this. There were 7 brothers. The oldest brother got married, but he died before his wife could have a baby. ");
INSERT INTO engPEV_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","So the next brother married that woman to follow God’s law, but he died too, before they could have a baby. Then the next brother did the same, but he died too, before they could have a baby. ");
INSERT INTO engPEV_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","The same happened to all of those brothers. They all followed God’s law and married the woman, but each of them died before they could have any kids. And then last of all, that woman died too. ");
INSERT INTO engPEV_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Well, you reckon that one day all the dead people will come alive again. So here is our question. If all those brothers and that woman come alive again, which brother will have that woman as his wife? All 7 brothers had her as their wife before they died.” ");
INSERT INTO engPEV_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus said, “You mob have a problem. You don’t know God’s word properly, and you don’t know about God’s power. ");
INSERT INTO engPEV_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","You see, after all the dead people come alive again, they will be like God’s angel messengers in heaven. Those angels never marry each other. And people that come alive again will be the same. Nobody will promise a wife to anyone, and nobody will marry anyone. ");
INSERT INTO engPEV_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","27","You mob reckon that dead people will never come alive again, but think about this story about Moses. You can read it in God’s book. Moses saw a little tree on fire, and then God said to him, ‘I am the God of Abraham, and I am the God of Isaac, and I am the God of Jacob.’ He didn’t say, ‘At one time, I used to be the God of those men.’ He said that he is their God now. That means those men are alive, not dead. They are living right now, with God. You see, you mob are really wrong.” ");
INSERT INTO engPEV_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","One of the Jewish law teachers listened to Jesus and thought that Jesus answered them well. Then he asked Jesus, “Which one of God’s laws is the most important one?” ");
INSERT INTO engPEV_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus said to him, “The most important law is this one, ‘Listen to me, you Israel people, our God is the only God. He is the number one boss over everybody. ");
INSERT INTO engPEV_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","You have to love God properly, not just a little bit. You have to love God from right inside yourself. You have to love God in the way you feel, and in the way you think. And you have to love God in the way you do things.’ ");
INSERT INTO engPEV_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","The 2nd most important law is this one, ‘You have to love other people just as much as you love yourself.’ Those 2 laws are the strongest and most important laws.” ");
INSERT INTO engPEV_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","The Jewish law teacher said, “That is a good answer, teacher. God is the number one boss over everybody. There is no other god, just him. ");
INSERT INTO engPEV_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","We have to love God properly, not just a little bit. We have to love God from right inside ourselves. We have to love God in the way we feel, and in the way we think. And we have to love God in the way we do things. That is really important for us. It is not so important for us to do ceremonies, like we do when we burn meat to give it to God.” ");
INSERT INTO engPEV_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesus heard the man’s words and knew this man was thinking the right way, so Jesus said, “You are right. You are nearly ready for God to take you into his family.” After that, nobody was brave enough to ask Jesus any more questions to try to trick him. ");
INSERT INTO engPEV_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Then Jesus taught people in the yard of God’s ceremony house. He said, “You know that David lived a long time ago, and now our Jewish law teachers say that one of his grand-sons will be the special man that God promised to send, called the Christ. What do they mean by that? ");
INSERT INTO engPEV_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Think about this. God’s Holy Spirit told David to write these words, and they are in God’s book. He wrote, ‘God said to my boss, “Come here and sit down beside me until I make you boss over all your enemies.” ’ ");
INSERT INTO engPEV_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","You know, David was talking about that special man that God was going to send, and David called him boss, so how can that man be David’s grand-son?” A lot of people listened to his words, and they were really happy with him. ");
INSERT INTO engPEV_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesus kept on teaching the people. He said, “Look out for those Jewish law teachers. They think they are great. They wear real good clothes so that people will think they are important. They like people to say hello to them whenever they go shopping. ");
INSERT INTO engPEV_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Those law teachers want everyone to respect them, so they want to have special chairs at the meeting houses, and if they go to parties, they want to have special places to sit. ");
INSERT INTO engPEV_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","But they do bad things. They trick old women that haven’t got anybody to look after them. They take everything off those women. They take their houses and all their things, and then those law teachers go to the meeting house and say long prayers, so that people will think they are good. They just pretend to live God’s way. You know, God will punish them more than he will punish the other people that do bad things.” ");
INSERT INTO engPEV_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Then Jesus sat down near the money box at God’s ceremony house, and he watched the people put money in the box to give it to God. Some rich people put in a lot of money. ");
INSERT INTO engPEV_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","But then a poor widow woman came in, and she didn’t put much money into the money box. She just put in 2 very little coins. ");
INSERT INTO engPEV_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Jesus called his followers to him and said, “Listen, this poor woman gave more money than those rich people. You see, those rich people gave some of their money, but they still have lots more back at their homes. But that poor woman gave all the money she had. She kept nothing for herself, not even money to buy some food for herself.” ");
INSERT INTO engPEV_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesus and his followers started to leave God’s ceremony house, and as they walked along, one of them said, “Teacher, look at these lovely buildings. And look at these big stones. This is a really good house that they made for God.” ");
INSERT INTO engPEV_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesus said, “You see these lovely big buildings? One day, these buildings will not be here. Somebody will knock them all down. They will just be a big pile of rubbish.” ");
INSERT INTO engPEV_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Then Jesus and his followers went out of Jerusalem, and they sat down on the hill called Olive Trees Hill. They could see God’s ceremony house from there. Peter, James, John and Andrew talked quietly to Jesus. They asked him, ");
INSERT INTO engPEV_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“When will somebody knock that building down? Will there be something to show us that it will soon happen?” ");
INSERT INTO engPEV_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesus said, “Listen, you have to be careful. Don’t let anybody trick you. ");
INSERT INTO engPEV_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","A lot of people will come and say, ‘I’m Jesus Christ, the man that God sent,’ and they will trick a lot of people. ");
INSERT INTO engPEV_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","You will hear stories about big fights, and somebody might tell you stories about big fights that will happen later. Don’t let those stories frighten you. Those fights will happen, but the world will not finish up yet. ");
INSERT INTO engPEV_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","There will be a lot more fights. People from some tribes will get up and fight against people from other tribes, and people from some nations will get up and fight against people from other nations. And in lots of different places the ground will shake in earthquakes. And sometimes there will not be any food, and people will be really hungry. These bad things will happen, and after that, more big trouble will come. You know about women, when they have babies. At first a woman has some pain, then later her pain gets really bad. Well, the trouble I just told you about is like the first pain for a mother, and after that, the trouble will get really bad. ");
INSERT INTO engPEV_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","You have to watch out. You see, you follow me, but some people don’t like me, so they will not like you. They will grab you and take you to their leaders, and they will punish you. And people will beat you up in their meeting houses. They will take you to court, so that you will stand up in front of big leaders and big government bosses. Then you can tell everyone about me. ");
INSERT INTO engPEV_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","You see, people everywhere will hear about me. The people in every nation will hear the good news about me, and some time after that, the world will finish up. ");
INSERT INTO engPEV_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Yes, people will grab you to take you to court. But before you get there, don’t worry about what you will say to the judge. The Holy Spirit will give you the right words to say, so just talk the way the Holy Spirit tells you to. ");
INSERT INTO engPEV_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","You see, there is going to be so much trouble that people will fight their own families. Some men will turn against their own brothers, and they will get people to kill them. And some fathers will do that to their own kids. And some kids will turn against their mothers and fathers and get people to kill them. ");
INSERT INTO engPEV_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","And everybody will know that you follow me, so they will hate you. But if you stay strong and don’t give up, God will save you.” ");
INSERT INTO engPEV_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Then Jesus said, “Somebody will put a really bad thing inside God’s ceremony house. That bad thing ruins everything around it, so it shouldn’t be in God’s house. It will bring a lot of trouble.” (Everyone that reads this story has to try hard to understand what it means.) And Jesus said, “When you see that happen, you mob that live in Judea country, you have to quickly run away to the hill country. ");
INSERT INTO engPEV_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","If you are outside your house, don’t go back into it to get anything. ");
INSERT INTO engPEV_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Or if you are out working somewhere, don’t go back to your house to get something, not even your coat. Just run away quick. ");
INSERT INTO engPEV_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","It will be hard for women that are carrying babies inside them, and for mothers with little kids at that time. ");
INSERT INTO engPEV_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","You have to ask God to stop this trouble from coming at the time when the weather is bad and it’s hard to go anywhere. ");
INSERT INTO engPEV_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","This trouble will give people really bad pain. People never had bad pain like that before, not in all the time since God made everything. And nothing that bad will ever happen again. ");
INSERT INTO engPEV_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","You see, if God lets that trouble keep on going, everybody will die. But God has picked out some people, and he doesn’t want them to die, so after a short time he will stop that trouble so that they will not die. ");
INSERT INTO engPEV_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Don’t believe people that say, ‘We have found the Christ, the special man from God. Here he is.’ Or if they say, ‘There he is over there,’ don’t believe them. ");
INSERT INTO engPEV_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","There will be a lot of people that will tell lies and try to trick you. Some people will say that they are the Christ, the special man from God. Other people will say that they are telling people God’s words, and they might do all sorts of clever things. Those people will be thinking, ‘Maybe we can trick the people that God picked out for himself.’ But really, they can’t do that. ");
INSERT INTO engPEV_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","So keep on being careful. You see, I’m telling you about it now, so that later, when it happens, you can be ready for it. ");
INSERT INTO engPEV_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","After that time of trouble, things will happen that God tells us about in his book. He says, ‘The sun will go dark, and the moon will stop shining. ");
INSERT INTO engPEV_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","The stars and the other powerful things in the sky will all shake about and fall out of the sky.’ ");
INSERT INTO engPEV_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Then everybody will see God’s special man come back from heaven in the clouds. People will see that he is really strong, and powerful, and shining really bright. ");
INSERT INTO engPEV_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Then he will send God’s angel messengers out to every place in the world. They will not miss any place, anywhere. They will get all the people that belong to God. He picked out those people for himself. The angels will bring all those people to God. ");
INSERT INTO engPEV_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Think about this. Whenever you see new leaves on a bush tucker tree, you know that the weather’s going to change soon. Those new leaves show you that. ");
INSERT INTO engPEV_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","It’s the same with all these things that I’m telling you about now, they will show you something too. You will see these things happen, and you will know that I will come really soon. ");
INSERT INTO engPEV_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Listen, there are some people alive now that will still be alive when these things happen. ");
INSERT INTO engPEV_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","One day, everything will finish up. The sky, and the ground, and everything, it will all finish up, but not my words. My words stay true for ever. They will never finish up.” ");
INSERT INTO engPEV_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Then Jesus said, “I’m telling you straight. Nobody knows the time when God will do these things. Nobody knows what day it will be, or what the time will be on the clock. God’s angel messengers in heaven don’t know. Even I don’t know. My father in heaven is the only one that knows. ");
INSERT INTO engPEV_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","You don’t know what time God will do these things, so you have to always be ready and keep on remembering everything I told you, like you have to stay awake and keep on looking out for me. ");
INSERT INTO engPEV_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Listen to this picture story. A man wanted to go to stay in another place for a while, so he told his workers to look after everything at his house while he was away. He told each one of them to do their own jobs. He said to the guard at the gate, ‘Keep looking out to see me coming back.’ ");
INSERT INTO engPEV_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Those workers didn’t know what time that boss was going to come home. He might come after the sun goes down, or he might come in the middle of the night, or he might come as the birds call out in the morning, or he might come back after the sun comes up. So those workers have to be ready all the time. You are like those workers in that picture story, and I am like that boss. You don’t know what time I will come back here, and you have to be ready for me all the time. So you have to keep on looking out for me, like that guard at the gate has to keep on looking out. Don’t get lazy. ");
INSERT INTO engPEV_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","I’m telling you mob to be careful, like I tell everybody else. You’ve got to always be ready for me to come.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Every year Jewish people went to Jerusalem for a special ceremony where they ate flat damper for a week. On the first day of that ceremony, they always ate a special dinner called Passover. It was 2 days before that ceremony was going to start, and the bosses of the Jewish ceremonies and the law teachers met together to work out a way to grab Jesus and kill him. But they wanted to grab him when nobody was looking. So those leaders said to each other, “Everybody likes Jesus, so we have to wait a bit. We can’t grab him while there are lots of people here for the ceremony. They will get angry with us, and we will have a very big fight.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","At the time, Jesus was at the town called Bethany. A man lived there that used to have a skin sickness, but then he got better. His name was Simon. Jesus went to Simon’s house, and he was eating dinner there. A woman came into the house with some special perfume in a pretty bottle. That perfume smelled really good and it cost a lot of money. She opened the bottle and poured the perfume on Jesus’s head. ");
INSERT INTO engPEV_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Some of the people there said to each other, “Why did she waste that perfume? ");
INSERT INTO engPEV_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Why didn’t she sell it and get a lot of money, and give that money to poor people?” And they said angry words to her too. ");
INSERT INTO engPEV_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","But Jesus said to them, “Leave her alone. Don’t make trouble for her. She did something really good to me. ");
INSERT INTO engPEV_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","You will always have poor people with you, and you can give them money whenever you want to. But I will not be here with you much longer. ");
INSERT INTO engPEV_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","I will die soon, and people will bury my body. This woman poured the perfume on me to get my body ready. She did a good thing. ");
INSERT INTO engPEV_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Listen. People will go everywhere in the world to tell people God’s story, and they will remember this woman and they will tell people about her too, and about the good thing she did today.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariot was one of the 12 men that Jesus picked out to be his special workers. But at this time he turned against Jesus, and he went to the bosses of the Jewish ceremonies, and he said, “I can help you catch Jesus.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","They heard him say that, and they were very happy. They promised to pay him money. So he waited for a good time to help them catch Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","The day came for people to kill a young sheep to cook it and eat it. That was the start of the ceremony time called Passover. They ate flat damper at that time too, and they remembered the time, long ago, when their grand-fathers were in Egypt, and God’s angel messenger passed over them, and didn’t kill any of them. On that day, some of Jesus’s followers went up to him, and they asked him, “Where do you want us all to eat this dinner? We can go and get it ready.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesus said, “All right, you 2 go over there into Jerusalem city, and after you get there you will meet a man. He will be carrying a big jug of water. Follow him, and he will go into a house. ");
INSERT INTO engPEV_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","You talk to the boss over that house. You tell him, ‘Our teacher wants you to show us the room you have for visitors. He wants to eat the Passover dinner there with his followers.’ ");
INSERT INTO engPEV_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Then that boss will take you upstairs to a big room that he’s got set up and ready. You can get the dinner ready for us there.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Those 2 men left him and went into Jerusalem. Everything happened just like Jesus told them. So they got the food ready for that special Passover dinner. ");
INSERT INTO engPEV_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","When the sun went down, Jesus and his special workers went to that house to eat the Passover dinner. ");
INSERT INTO engPEV_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","While they were eating, Jesus said to them, “Listen, one of you men, that is eating with me here right now, will turn against me and help the people that want to kill me.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","His 12 special workers were sad, and each of them said to him, “Were you talking about me? No, not me. I will not do that.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesus said, “It is one of you that is eating food with me right now. ");
INSERT INTO engPEV_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","I’m God’s special man from heaven, and I have to die, just like God says in his book. But the man that helps my enemies to catch me, he will get really bad trouble from God. He will wish he was never born.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","After that, while they were still eating their dinner, Jesus picked up some damper and thanked God for it, then he broke it into bits and gave it to his special workers. He said, “This damper is my body. Take a bit and eat it.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Then he picked up the cup of wine and said thank you to God for it, and he gave it to them, and they passed it around, and each of them drank a little bit of wine. ");
INSERT INTO engPEV_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","He told them, “This wine is my blood. I will die and pour out my blood for a lot of people. It’s like this, God has agreed to save people, and I will die so he can do that. My blood will come out, and it is like I’m using my blood to sign God’s new agreement with people, to say that they are not guilty of the bad things they did. ");
INSERT INTO engPEV_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Listen, I will not drink any wine again until the day that I sit down with God and all his family, and he will show everyone that he is the biggest boss. Then I will drink a new sort of wine with you.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","After Jesus said that, they all sang a song to God, and then they went out of that house to go to the hill called Olive Trees Hill. ");
INSERT INTO engPEV_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","They walked along the road, and Jesus talked to his followers. He said, “All you mob will run away and leave me. A long time ago, God got one of his men to write about this in his book. He wrote, ‘God will knock down the man that looks after the sheep, and all his sheep will run away.’ He wrote those words about me. I will die, like he wrote about that man, and you will all run away. ");
INSERT INTO engPEV_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","But after that, God will make me alive again. Then I will go ahead of you to Galilee country, and I will wait for you there.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter said, “Maybe all the others will run away, but not me. No way.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","But Jesus said to him, “Listen to me, Peter. Tonight you will tell people that you don’t know me. You will say that 3 times, and then a chook will yell out 2 times, just like it always does before the sun comes up.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","But Peter talked really strong to Jesus. He said, “No. People might try to force me to say that. They might even tell me that they will kill me, but I will never say that I don’t know you.” All the other followers said the same thing. ");
INSERT INTO engPEV_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesus and his followers got to the place called Gethsemane. He said to them, “I want you to sit here and wait for me. I’m going to pray to God.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","He asked Peter, James and John to go with him, and they walked away from the others. Then Jesus started to get really sad and upset. ");
INSERT INTO engPEV_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","And he said to them, “I feel really sad right now. I feel so sad, it’s like I’m dying. Stay here and keep on looking out for trouble.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Then Jesus walked away from them a little bit and lay down on the ground. ");
INSERT INTO engPEV_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","He said to God, “Father, you can do anything. You can take this trouble away from me. It’s too hard for me. But you do what you want to do, not what I want.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jesus went back to his 3 followers and found them asleep. He said to Peter, “Wake up, Simon. Can’t you stay awake with me for just one hour? ");
INSERT INTO engPEV_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Stay awake and pray to God so that nothing will get you to go wrong. I know that you want to do the right thing, but your body is weak and wants to sleep.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesus left them again, and he prayed again. He kept on asking God the same thing. ");
INSERT INTO engPEV_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jesus’s 3 followers were very tired, and they just couldn’t stay awake. Then Jesus came back to them again, and they were asleep again. After they woke up, they felt shame, and they didn’t know what to say to him. ");
INSERT INTO engPEV_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jesus went away and prayed to God again. Then he came back to his 3 followers and said, “Are you still resting? You can’t sleep any more now. Look. I’m God’s special man from heaven, but those bad men will soon come and get me. ");
INSERT INTO engPEV_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","So get up, we have to go now. See, here is the man that is helping them catch me.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Just before that time, the bosses of the Jewish ceremonies and the law teachers and the Jewish elders, they told a big mob of men to go with Judas to grab Jesus. Those men all had long knives and fighting sticks. Judas was one of Jesus’s 12 special workers, but he changed sides, and he took that mob of men to Gethsemane to grab Jesus. They got there while Jesus was talking to his followers. ");
INSERT INTO engPEV_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","45","Judas walked up to Jesus and said, “Hello teacher,” and kissed him on the cheek. He did that to show those men which man they had to grab. ");
INSERT INTO engPEV_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","So they grabbed Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","One of Jesus’s followers was standing right there, and he pulled out his long knife. He cut off the ear of a man that worked for the big boss of the Jewish ceremonies. ");
INSERT INTO engPEV_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesus said to the mob, “Why have you got all these long knives and fighting sticks? I’m not a criminal. No way. ");
INSERT INTO engPEV_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","I was always in God’s ceremony house, and I taught the people there every day, but you didn’t grab me then. But a long time ago, God said that you will grab me. It is in his book. So you will grab me now.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Then Jesus’s followers got frightened, and they ran away and left him there. ");
INSERT INTO engPEV_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","There was a young man there that followed along a little bit behind Jesus. He was just wearing a sheet wrapped around him. ");
INSERT INTO engPEV_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","That mob of men tried to grab him, but they only grabbed the sheet. He wriggled out of it and ran away naked. ");
INSERT INTO engPEV_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","54","That mob took Jesus to court at the house of the big boss of the Jewish ceremonies. All the bosses of the Jewish ceremonies, and the elders, and the law teachers, they all went to that court too. That house had a yard with a wall around it. Peter followed a little bit behind the mob, and he followed that mob into the yard of that house, and he sat down with them near their fire. ");
INSERT INTO engPEV_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","All the Jewish leaders there tried to get somebody to say, “We saw Jesus do bad things,” so that they could kill him, but nobody told a strong story against him. ");
INSERT INTO engPEV_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Lots of people stood up and told lies about Jesus, but they didn’t agree with each other. Their stories were all mixed up. ");
INSERT INTO engPEV_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Some men stood up and told this lie. ");
INSERT INTO engPEV_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","They said, “We heard this man say, ‘I will knock down God’s ceremony house and build another one in 3 days. Lots of men built this one, but I will build a new one just by myself.’” ");
INSERT INTO engPEV_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","But even those men had their stories mixed up. They didn’t agree with each other. ");
INSERT INTO engPEV_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","The big boss of the Jewish ceremonies stood up in the meeting and said to Jesus, “All those people said that you did bad things. You heard them. What do you say?” ");
INSERT INTO engPEV_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","But Jesus didn’t answer him. He just kept his mouth shut. Then that boss said, “All right, tell us this. Are you the Christ, that special man that God promised to send to save us? Are you the son of God?” ");
INSERT INTO engPEV_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesus said, “Yes, I am. I’m God’s special man from heaven. And one day, you mob will all see me sitting there in heaven on the right-hand side of God, the powerful one. And you will also see me come back here in the clouds.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Then that big boss of the Jewish ceremonies got so angry that he tore his clothes and said to the Jewish leaders, “Did you hear that? This man said that he is the same as God. We don’t need anyone to say anything more. We heard it ourselves. So what do you reckon, did he break our law?” They all said, “He did. He broke our law. He’s got to die.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Some of the people in that meeting spat on Jesus. They tied a rag across his eyes so that he couldn’t see, then they hit him with their hands and said, “Hey. You reckon that God gives you power to know things, so tell us, who hit you?” Then the guards grabbed Jesus and hit him. ");
INSERT INTO engPEV_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","All this time, Peter sat next to the fire in the yard of the big boss of the Jewish ceremonies. One of the girls that worked in that house came along and saw Peter there. She looked at him and said, “I think you were with Jesus, the man from Nazareth.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","But Peter said, “No. I don’t know what you are talking about.” Then Peter went back to the gate of that yard. Just then a chook yelled out. ");
INSERT INTO engPEV_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","That girl saw Peter at the gate and started to tell the people, “This man is one of Jesus’s mob.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","But again Peter said, “No, I’m not.” A little bit later those people there at that gate said to Peter, “You talk like the Galilee people talk, and Jesus is from Galilee, so you have to be one of his followers.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Peter got really wild, and he said, “I’m telling you, I don’t know that man. I don’t know what you are talking about. God knows that this is true, or if not, he can kill me.” ");
INSERT INTO engPEV_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Straight away, that chook yelled out again. Then Peter remembered the words Jesus said to him before, “Tonight you will tell people that you don’t know me. You will say that 3 times, and then a chook will yell out 2 times.” When Peter remembered these words, he was very sad, and he cried a lot. ");
INSERT INTO engPEV_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Early in the morning, the men of the Jewish Leaders Council talked with each other about what they will do with Jesus. That council mob were the bosses of the Jewish ceremonies, and the law teachers, and the elders. They tied Jesus’s hands together, and they took him over to the big government boss. His name was Pilate. They asked him to judge Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","So Pilate asked Jesus, “Are you the big boss over the Jewish nation?” Jesus said, “Those are your words.” ");
INSERT INTO engPEV_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","The bosses of the Jewish ceremonies blamed Jesus, and they told Pilate he did a lot of bad things, but Jesus didn’t say anything. ");
INSERT INTO engPEV_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Then Pilate said to him, “They are saying lots of bad things about you. Why don’t you say something for yourself?” ");
INSERT INTO engPEV_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","But Jesus said nothing, and Pilate was really shocked. ");
INSERT INTO engPEV_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Every year, at the ceremony time called Passover, Pilate always did something special for the people in Jerusalem. He let one prisoner go free from the jail. ");
INSERT INTO engPEV_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","8","At this Passover time, some of the Jerusalem people came to Pilate and asked him to let a prisoner go free, like he always did. They came up to Pilate while Jesus was still there. At the same time, there was a murderer in jail there. His name was Barabbas. Before that time, Barabbas and his mob fought against the government and killed some of the government people, so the soldiers grabbed him and put him in jail. ");
INSERT INTO engPEV_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","11","Pilate knew that the bosses of the Jewish ceremonies were jealous of Jesus, and that was the only reason why they brought him to Pilate. They wanted Pilate to kill him. So when those Jerusalem people asked Pilate to let a prisoner go free, Pilate said, “All right, how about I let Jesus go? You reckon he says that he is your big boss. What do you reckon, will I let him go?” But the ceremony bosses got all those people to be angry with Jesus, and those people told Pilate, “No. Not him. We want you to let Barabbas go free.” ");
INSERT INTO engPEV_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilate said, “So what do you want me to do with this man that you Jewish people call your big boss?” ");
INSERT INTO engPEV_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","They all yelled, “Kill him. Nail him to a cross and let him die there.” ");
INSERT INTO engPEV_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilate said, “Why? What did he do that was so bad?” But they didn’t listen. They yelled even louder, “Kill him. Nail him to a cross.” ");
INSERT INTO engPEV_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilate didn’t want that mob to get wild, so he did what they wanted. He let Barabbas go out of jail, and he told his Roman soldiers to hit Jesus a lot with whips. After they finished whipping him, Pilate told them to nail Jesus to a cross and leave him to die. ");
INSERT INTO engPEV_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","The soldiers took Jesus outside into the yard of the big house where Pilate lived. They called out to the rest of the soldiers there to come out into that yard. ");
INSERT INTO engPEV_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","They put a purple coat on Jesus. Then they made some prickly branches into a headband that looked like a crown, like a big boss wears, and they put it on Jesus’s head. ");
INSERT INTO engPEV_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","And they made fun of him. They got down on their knees in front of Jesus and said, “Hey, you reckon that you are great. And you reckon that you are the big boss over the Jewish people. But you are not.” ");
INSERT INTO engPEV_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","And they kept on hitting him on the head with a stick, and they spat on him. ");
INSERT INTO engPEV_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","When they finished making fun of him, they took off the long purple coat and put his own clothes back on him. Then they took him out to another place to kill him. ");
INSERT INTO engPEV_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","There was a man walking past them on the road at that time. He was coming into the city from the bush. His name was Simon, and he was from the country called Cyrene. (He was the father of our friends Alexander and Rufus.) The soldiers forced Simon to carry the cross for Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Then they got to the place called Golgotha in their language. That name means Skull Place. ");
INSERT INTO engPEV_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Then the soldiers tried to give Jesus some wine to drink. That wine had some medicine called myrrh mixed in it. But Jesus wouldn’t drink it. ");
INSERT INTO engPEV_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","26","Then the soldiers nailed Jesus’s hands and feet to the cross. Then they stood it up, and they left him to die like that. And they made a sign and put it above his head, to say why they killed him. It said, “The big boss over the Jews.” It was 9 o’clock in the morning when they nailed Jesus to that cross. After that, the soldiers gambled with each other to get his clothes. ");
INSERT INTO engPEV_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","The soldiers also nailed 2 criminals to crosses next to Jesus. One criminal was on his left-hand side, and the other criminal was on his right-hand side. ");
INSERT INTO engPEV_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Some other people walked past Jesus and rubbished him too. They stood there and shook their heads to shame him, and they said, “You reckon you can knock down God’s ceremony house, and then build it again in 3 days, do you? ");
INSERT INTO engPEV_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","All right, if you are so smart, save yourself. Get off the cross and come down.” ");
INSERT INTO engPEV_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","The bosses of the Jewish ceremonies and the law teachers joined in and laughed at Jesus. They said to each other, “He saved other people, but he can’t save himself. ");
INSERT INTO engPEV_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","He thinks he is the Christ, the special man that God promised to send to save us. He reckons he is the big boss over us Israel nation. No way. We will not believe him unless we see him come down off that cross.” The men on the other crosses joined in too and rubbished Jesus. ");
INSERT INTO engPEV_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","In the middle of the day, at about 12 o’clock, all of the country got dark, like it was night time. It stayed dark for about 3 hours, until 3 o’clock in the afternoon. ");
INSERT INTO engPEV_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Then Jesus yelled out in his language. He said, “Eloy, Eloy, lama sabakthani?” That means, My God, my God, why did you go away and leave me all by myself? ");
INSERT INTO engPEV_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Some of the people standing around heard Jesus say that. They thought that he called out for Elijah to come to him from heaven. ");
INSERT INTO engPEV_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","One man got up quickly and got a sponge, and he filled it with sour wine, and he put it on a stick and held it up to Jesus’s mouth, so he could suck a bit of it. And that man said, “All right, just leave him. Let us wait and see if Elijah will come and get him down.” ");
INSERT INTO engPEV_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesus yelled out again, and then he died. ");
INSERT INTO engPEV_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Over in Jerusalem, in God’s ceremony house, there was a big curtain that blocked off God’s special place. At the same time that Jesus died, that curtain just ripped right down the middle from the top to the bottom, into 2 bits. ");
INSERT INTO engPEV_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","And at the cross, the boss over those Roman soldiers stood near Jesus, and he saw the way Jesus died. Then that boss soldier said, “I reckon this man really was the son of God.” ");
INSERT INTO engPEV_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","There were some women there at the cross too. Before this time, those women went everywhere with Jesus in Galilee country. They looked after him there, and after that, they came with him to Jerusalem. While Jesus was dying, they stood looking from a long way off. They were Mary Magdalene, and Salomi, and the other Mary that was the mother of young James and Joses, and some other women with them. ");
INSERT INTO engPEV_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","That day that Jesus died was the day when the Jewish people got everything ready for their rest day. That rest day was going to start when it got dark. ");
INSERT INTO engPEV_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","There was a man there that was called Joseph, and he was from a place called Arimathia. Everyone said that he was a good man, and he was one of the Jewish Leaders Council men too. He was waiting for the time when God will get all his family together and show everyone that he is the biggest boss. So when it was nearly night time, before that rest day started, he went to Pilate. He was a little bit frightened, but he went to Pilate anyway, and he asked him, “Can I get Jesus’s body to take care of it our way?” ");
INSERT INTO engPEV_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","45","Pilate was shocked. He said, “Is that man dead already?” He sent somebody to get the boss over the soldiers, and he asked that boss soldier, “Is it true? Is that man properly dead now?” That boss soldier told Pilate, “Yes, it is true.” Then Pilate told Joseph, “All right, you can take Jesus’s body.” ");
INSERT INTO engPEV_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","So Joseph bought a good sheet, and he took Jesus’s body down from the cross and wrapped it in that sheet. Then he took Jesus’s body and put it in a cave to bury it. That cave was a special place to put dead bodies. It was a big hole, like a little room that somebody cut in the rock. Then Joseph rolled a big flat stone in front of that cave to block it. ");
INSERT INTO engPEV_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","And those women, Mary Magdalene and Mary the mother of Joses, they saw the place where Joseph put Jesus’s body. ");
INSERT INTO engPEV_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","The next day was Saturday. It was their rest day. When the sun went down, that rest day was finished. Then some women went and bought some perfume to put on Jesus’s body, so they could bury him the right way. They were Mary Magdalene, and Salomi, and Mary the mother of James. ");
INSERT INTO engPEV_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Early on Sunday morning, when the sun was just starting to come up, they went to that cave to find Jesus’s body. ");
INSERT INTO engPEV_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","As they walked along, they said to each other, “Who will roll away that big stone to open up the cave for us? It’s way too big for us.” ");
INSERT INTO engPEV_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","But when the women got there they looked up and saw that the big stone was not blocking the cave any more. Somebody already came before them and rolled that big stone away. ");
INSERT INTO engPEV_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Then they walked into the cave, and they saw a young man sitting there on the right-hand side, wearing really white clothes. They got a big surprise. ");
INSERT INTO engPEV_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","He said to them, “Don’t be frightened. You are looking for the body of Jesus, the man from Nazareth that they killed on a cross. God made him alive again. He isn’t here. Look, see this place just here. They put his body here, but it isn’t here now.” ");
INSERT INTO engPEV_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","And he said to them, “Go back to his followers and tell them, ‘You mob have to go back to Galilee country. Jesus will go there ahead of you, and when you go back there you will see him. You remember, he told you about that some time ago.’ Make sure you tell that message to Peter and the other followers.” ");
INSERT INTO engPEV_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","The women didn’t know what to think. They were so frightened they were shaking. They came out of that cave and ran away. Those women were too frightened to talk to anybody. They just ran away. ");
INSERT INTO engPEV_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Early on Sunday morning, before those women went to the cave, Jesus came alive again. He let Mary Magdalene see him first. (Some time before this, Jesus forced 7 bad spirits out of her.) ");
INSERT INTO engPEV_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","After Mary saw Jesus, she went to his friends, the people that used to walk around with him. When she got there, they were all very sad and crying. ");
INSERT INTO engPEV_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mary told them, “Jesus is alive again. I just saw him.” But they didn’t believe her. ");
INSERT INTO engPEV_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","A little while after that, 2 of Jesus’s other followers were walking from Jerusalem to another place out in the bush. Jesus came to them, and he let them see him, but he made himself look like a different man, so they didn’t know it was him. ");
INSERT INTO engPEV_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Then, after they found out it really was him, they turned around and quickly went back to Jerusalem, and they told Jesus’s other followers that they saw Jesus. But those other followers didn’t believe them. ");
INSERT INTO engPEV_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","After that, Jesus’s 11 special workers were eating food together, and Jesus came to them, and he let them see him alive. He said to them, “Why didn’t you listen to those people that said they saw me? What they said was true, but you didn’t believe them.” ");
INSERT INTO engPEV_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","After that, Jesus said to his followers, “You have to go out to everywhere in the world and tell everybody the good news about me. ");
INSERT INTO engPEV_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Some people will believe that message, and then you have to take them through that special washing ceremony, called baptism. God will save those people. But God will not save people that don’t believe that message. He will blame them and say they are guilty. ");
INSERT INTO engPEV_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","And the people that believe in me will do great things with the power that I will give them, to show everyone that they are God’s people. They will force bad spirits out of people. And they will talk in different languages that they never learned. ");
INSERT INTO engPEV_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","And if they pick up a cheeky snake, it will not hurt them. And if they drink poison, it will not hurt them. And they will put their hands on sick people, and those sick people will get better.” ");
INSERT INTO engPEV_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","After Jesus finished telling his followers all those things, God took him up to heaven. And Jesus sat down at the right-hand side of God, the place where only a really important person can sit. ");
INSERT INTO engPEV_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","After that, his followers went everywhere and told people the good news about Jesus. And our leader, Jesus himself, worked with them. He gave them power to do great things so that everyone knew that he was with them, and that their message about him was true. ");
INSERT INTO engPEV_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","I’m writing this for you, my good friend Thiofilus. A lot of great things happened here, and the people that saw those things happen told everyone what they saw, and a lot of people wrote down those stories that they heard. After that, I read those stories, and I talked to the people that saw those things, and I checked up on everything they said, right from the start. So now I am carefully sorting out those stories, and I am writing them in this book for you. ");
INSERT INTO engPEV_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","You already heard some of this, but I want you to know the right story, and I want you to be sure about it. ");
INSERT INTO engPEV_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","When Herod was the big boss over Judea country, there was a man there that was called Zekariah. He was one of the men that looked after the Jewish ceremonies. There were different groups that did the Jewish ceremonies for the people at different times. He was in the group called the Abijah mob. His wife belonged to a family of Jewish ceremony people too. Her name was Elizabeth. ");
INSERT INTO engPEV_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Those 2 people, Zekariah and Elizabeth, they were very good people. They did everything in God’s law, and God liked the way they lived. ");
INSERT INTO engPEV_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","They got very old, but they didn’t have any kids. You see, Elizabeth just couldn’t have a baby. ");
INSERT INTO engPEV_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","The time came for Zekariah’s mob to do the ceremonies in God’s ceremony house, in Jerusalem city. ");
INSERT INTO engPEV_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","One day, it was Zekariah’s turn to go into the special room in that house and burn some special perfume to make a good smell. ");
INSERT INTO engPEV_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","While he was doing that, a big mob of people were outside, and they were praying. ");
INSERT INTO engPEV_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Then God sent one of his angel messengers to that room, and he stood on the right-hand side of the metal table where that special perfume was burning. ");
INSERT INTO engPEV_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zekariah saw the angel there and got a big shock. He was really frightened. ");
INSERT INTO engPEV_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","But the angel told him, “Don’t be frightened, Zekariah. God has heard what you have been asking him, and he will give you what you want. Your wife, Elizabeth, will have a baby boy, and you will name him John. ");
INSERT INTO engPEV_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","You will be really happy, and a lot of other people will be happy with you. ");
INSERT INTO engPEV_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","God will say that this kid is important, so you have to make sure he never drinks any sort of wine or grog at all. You see, the Holy Spirit will come into this kid before he gets born, while he is still inside his mother. ");
INSERT INTO engPEV_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","And then, after he grows up, he will get lots of you Israel people to turn away from bad things and turn back to God. ");
INSERT INTO engPEV_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Remember Elijah, God’s man that lived a long time ago. He had God’s spirit in him, and he did powerful things. Well, in the same way, your son John will have God’s spirit in him, and he will do powerful things. He will get people ready for God. John will get people to turn around and live the right way. He will get the men that are fathers to love their kids properly. And he will get people to listen properly to the sensible words of good people. Even those people that don’t listen to God now, he will get them to listen to good people.” ");
INSERT INTO engPEV_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zekariah said to the angel, “But that’s hard for me to believe. I am an old man, and my wife is old too. We are too old now to have a baby. How can I be sure that your message is true?” ");
INSERT INTO engPEV_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","The angel said, “Look, I am Gabriel. I am always close to God, and I do special jobs for him. And he sent me to tell you this good message. ");
INSERT INTO engPEV_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","And everything I said will happen at the right time. But you didn’t believe me, so now God will shut you up. You will not be able to talk until this kid gets born.” ");
INSERT INTO engPEV_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","While they were talking in that room, the people outside were waiting for Zekariah. They were thinking, “Why is he staying a long time in that room?” ");
INSERT INTO engPEV_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Then Zekariah came out, and he tried to talk to them, but he couldn’t say anything. He had to make signs with his hands, and at last they understood that he saw something powerful in that room. ");
INSERT INTO engPEV_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Then Zekariah finished his days of work in God’s ceremony house, and he went home. ");
INSERT INTO engPEV_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Soon after that, his wife, Elizabeth, found out she was going to have a baby. She stayed inside her house for 5 months. ");
INSERT INTO engPEV_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","She said, “Wow. God is properly good to me. He will let me have a baby, and nobody will rubbish me any more.” ");
INSERT INTO engPEV_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","That baby kept on growing inside Elizabeth. After about 6 months, God sent Gabriel, that same angel messenger, to Galilee country, to a town called Nazareth. ");
INSERT INTO engPEV_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","He went there to a young girl that was not married. Her name was Mary. Before that time, Mary didn’t ever sleep with any man, like a woman does with her husband. She was promised to a man that was called Joseph. He belonged to the family of David, the man that was the big boss a long time ago. ");
INSERT INTO engPEV_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabriel came to Mary and said, “Hello, Mary. God loves you and is good to you. He is here with you now, and he will do something good for you.” ");
INSERT INTO engPEV_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","This worried Mary. She thought, “What’s he talking about?” ");
INSERT INTO engPEV_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Gabriel said, “Don’t be frightened, Mary. God is really happy with you. ");
INSERT INTO engPEV_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Listen. You will soon have a baby boy, and you will call him Jesus. ");
INSERT INTO engPEV_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","God will make him the biggest boss over you Israel people, like David, his grand-father that lived a long time ago. He will be very important, and he will be the biggest boss for ever. He will never stop being the biggest boss over the Israel people. And people will call him the son of God.” ");
INSERT INTO engPEV_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary said, “But I’m not married. I’ve never slept with a man, like a wife sleeps with her husband. How will I get a baby?” ");
INSERT INTO engPEV_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Gabriel said, “The Holy Spirit will come to you, and God’s power will come over you and give you a baby. Your baby will be really special, and people will say he is God’s son. ");
INSERT INTO engPEV_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","And you know your cousin Elizabeth? Everyone reckoned she is too old to have a baby, but now she is carrying a baby inside her. She has been carrying that baby for the last 6 months, and soon she will have a son. ");
INSERT INTO engPEV_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","You see, God can do anything. Nothing is too hard for him.” ");
INSERT INTO engPEV_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mary said, “All right, I will do whatever God wants. I want everything to happen just like you said.” Then Gabriel left her. ");
INSERT INTO engPEV_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Soon after that, Mary got ready, and she went south quickly to a town in the hilly part of the country called Judea. ");
INSERT INTO engPEV_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zekariah and Elizabeth lived in that town. Mary went to their house, and she went in and said to Elizabeth, “Hello cousin.” ");
INSERT INTO engPEV_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","As soon as Elizabeth heard Mary say those words, she felt her baby jump inside her. And the Holy Spirit came into her, ");
INSERT INTO engPEV_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","and she talked really loud. She said to Mary, “God is really good to you, and he is making you happy. He is being more good to you than to any other woman. And he is being really good to your baby too. ");
INSERT INTO engPEV_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","I’m not important, but you are the mother of my leader, the man from God. It is really good of you to visit me. ");
INSERT INTO engPEV_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","You see, as soon as I heard you say ‘hello,’ my baby inside me was so happy he jumped. ");
INSERT INTO engPEV_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Yes, you believed that God will do everything he told you, and so God makes you very happy.” ");
INSERT INTO engPEV_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mary said, “God is really good and really great, and I want to tell everybody about him. ");
INSERT INTO engPEV_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","My spirit is really happy with God. I know he will save me. ");
INSERT INTO engPEV_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","God knew that I was not important, but he picked me, and now everyone will say that God was good to me. ");
INSERT INTO engPEV_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Yes, he is the really strong one, and he did great things for me. God is properly good, better than anyone else. ");
INSERT INTO engPEV_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","He is always good to all the people that respect him. He was good to people that respected him before, and he is good to people that respect him now, and he will be good to people that respect him later on. ");
INSERT INTO engPEV_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","He does great things with his power, and he shows everyone that he is really strong. Some people reckon they are smart and strong, but God makes them nothing. They are like soldiers that get frightened of the enemy and run away. ");
INSERT INTO engPEV_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","He chucks out the big bosses and takes their power away. But he gets people that are not important, and he makes them bosses. ");
INSERT INTO engPEV_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","And he gives hungry people good food, and they eat until they are full. But he doesn’t give anything to the rich people. They go away with nothing. ");
INSERT INTO engPEV_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","He feels sorry for his own people, us Israel mob, and he helps us, ");
INSERT INTO engPEV_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","just like he promised to Abraham, and our other grand-fathers that lived a long time ago. He said that he will look after us for ever.” ");
INSERT INTO engPEV_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary stayed with Elizabeth for about 3 months, then she went back to her own home. ");
INSERT INTO engPEV_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Then the time came for Elizabeth to have her baby, and she had a son. ");
INSERT INTO engPEV_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","All her family, and the people that lived near her, they all heard that she had a baby, and they knew that God felt sorry for Elizabeth, and that he was very good to her. Elizabeth was happy, and they were all happy too. ");
INSERT INTO engPEV_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","When the baby was 8 days old, all those people went to Zekariah and Elizabeth’s place. The baby boy had to have a young man operation on that day, and they used to give a baby his name at that time. The people wanted to call him Zekariah, the same name that his father had. ");
INSERT INTO engPEV_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","But Elizabeth said, “No. His name is John.” ");
INSERT INTO engPEV_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","They said, “What? Nobody in your family has that name.” ");
INSERT INTO engPEV_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","So they made signs with their hands to his father, to ask him what name he wanted to give to the boy. ");
INSERT INTO engPEV_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zekariah got them to give him something to write on, and he wrote, “His name is John.” Everyone was shocked. ");
INSERT INTO engPEV_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Then, straight away, Zekariah started to talk again, and he told everyone that God is very great. ");
INSERT INTO engPEV_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","The people there never saw God do things like that before. They were really surprised. They told other people about everything that happened, and soon a lot of people in the hilly part of Judea country were talking about it. ");
INSERT INTO engPEV_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Everyone that heard the news thought about it, and they said, “After this kid grows up, what will he be?” They knew God was powerfully looking after that boy. ");
INSERT INTO engPEV_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","At that time, when Zekariah started talking again, the Holy Spirit came into him, and he told everyone a message from God. He said, ");
INSERT INTO engPEV_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“The God of us Israel mob, he is a great God. He came now to save us, his people. ");
INSERT INTO engPEV_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","He sent us a very strong person, to save us. You know about David, the big boss that worked for God a long time ago. Well, this person is in David’s family. ");
INSERT INTO engPEV_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","God promised this to us a long time ago, and he got his men to tell us this message. ");
INSERT INTO engPEV_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","God promised to save us from our enemies, and from everyone that hates us. ");
INSERT INTO engPEV_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","He did that because he felt sorry for our grand-fathers that lived a long time ago, and wanted to be good to them, and do everything that he promised. ");
INSERT INTO engPEV_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Yes, God will remember the things he promised to our grand-father Abraham. ");
INSERT INTO engPEV_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","He promised to save us from our enemies, so we can work for him without being frightened. ");
INSERT INTO engPEV_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","We can live God’s way and work for him in the right way, and we can do that all our lives.” ");
INSERT INTO engPEV_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Then Zekariah talked to his baby boy. He said, “This word is for you, my son. Everyone will know that you tell people messages from God. You will get things ready for God. ");
INSERT INTO engPEV_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","You will teach his people how God can say they are not guilty of the bad things they did, and then God will save them. ");
INSERT INTO engPEV_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","You see, our God feels sorry for us, so he will do that for us. It will be like the sun coming up, bringing light from God. ");
INSERT INTO engPEV_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","That light will shine for everybody. Some people are like they are in the dark. They think they will die soon. But that light will shine on everybody. It will show us how to live in a happy and quiet way.” ");
INSERT INTO engPEV_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","After that, baby John grew up to be a man, and God made his spirit strong. He went and lived out in the bush for years, until he started to tell the Israel people God’s messages. ");
INSERT INTO engPEV_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","3","About the time that John was born, the biggest boss over all those countries was called Augustus. He sent a message to everyone in every country. He said, “The government bosses in every town have to write down everyone’s name on a big list, and make them pay tax money.” So everyone had to go back to their home town and put their names on the list there. (At that time a man called Quirinius was the government boss over Syria country.) ");
INSERT INTO engPEV_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseph belonged to the family of David, the man that was Israel’s big boss a long time ago. David grew up in the town called Bethlehem, in Judea country, but Joseph lived in a town called Nazareth, in Galilee country. So Joseph had to go south to Bethlehem, to put his name on the right list. ");
INSERT INTO engPEV_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Joseph took Mary with him. She was his promised wife, and she was carrying a baby inside her at that time. ");
INSERT INTO engPEV_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","At Bethlehem they couldn’t find any room to stay in, so they had to sleep in the place where the animals ate their food. Then the time came for Mary to have her baby. She had her baby right there, and she wrapped him up in bits of cloth, just like mothers always did. And she put him down to sleep in an animal’s food box. ");
INSERT INTO engPEV_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Not far away, on that same night, some men were out in the grass lands looking after their sheep. ");
INSERT INTO engPEV_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Suddenly, an angel messenger from God stood there with them, and bright light from God was shining all around them, and they were very frightened. ");
INSERT INTO engPEV_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","But the angel said, “Don’t be frightened. I’ve got really good news for you, and good news for everyone in the world too. ");
INSERT INTO engPEV_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","12","Today a young woman had a baby boy over there in Bethlehem, in the place where David grew up. Go there, and you will find him. He is wrapped up in cloth, and lying in an animal’s food box. Then you will know that this message is true. He is the one that is going to save you people. He is the Christ, the man that God promised to send to you, to be your leader.” ");
INSERT INTO engPEV_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Then suddenly a big mob of other angel messengers came from heaven, and they all praised God. They said, ");
INSERT INTO engPEV_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“God, you are really great there in heaven. And here on the earth, your people are quiet and happy. You are really good to your people.” ");
INSERT INTO engPEV_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Then the angels went back to heaven, and the men said to each other, “Let’s go to Bethlehem and see this baby that God just told us about.” ");
INSERT INTO engPEV_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Then they went quickly, and they found Mary and Joseph, with the baby boy in an animal’s food box, just like the angel said. ");
INSERT INTO engPEV_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","After those men saw the baby, they talked to people about him, and they told them the message that God’s angel gave them. ");
INSERT INTO engPEV_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Everyone was surprised when they heard what those men said. ");
INSERT INTO engPEV_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","And Mary remembered their words, and she thought about them a lot. ");
INSERT INTO engPEV_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","As those men walked back to their sheep, they talked about how everything happened, just like God’s angel said. They said to God, “You are really great.” And they told everybody that God is great. ");
INSERT INTO engPEV_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","You know, the law of Moses said that they had to do a young man operation on all baby boys as soon as they were 8 days old. So Mary’s baby had that operation, and they gave him his name, Jesus, at that time. That’s the name that God’s angel messenger told Mary to call him, before she started to carry that baby inside her. ");
INSERT INTO engPEV_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","The Jewish law is like this, a woman’s first baby boy belongs to God. And after a baby boy is born, the mother can’t go into God’s ceremony house or do any of their ceremonies for the next 40 days. It is like she is not clean. Then, after 40 days, she has to go to God’s ceremony house in Jerusalem. She has to get a leader of the Jewish ceremonies there to kill 2 pigeons and burn them, and let the smoke go up to God. This will make her clean again for Jewish ceremonies. So Joseph and Mary went to Jerusalem at the right time to follow that law. They took baby Jesus with them. ");
INSERT INTO engPEV_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","There was an old man in Jerusalem at that time. His name was Simeon. He was a good man that lived God’s way, and he was waiting for God to make the Israel people happy again. And the Holy Spirit used to tell him things. ");
INSERT INTO engPEV_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Before that time, the Holy Spirit told him, “You will stay alive until you see the special man that God will send to save his people. He is called the Christ.” ");
INSERT INTO engPEV_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Then on the day that Joseph and Mary took Jesus into God’s ceremony house, the Holy Spirit told Simeon to go there too, so he was there when Joseph and Mary brought Jesus in. ");
INSERT INTO engPEV_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","And Simeon took Jesus from them, and held him in his arms, and he thanked God, and said, ");
INSERT INTO engPEV_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Now, God, I can die happy, just like you promised me, ");
INSERT INTO engPEV_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","because now I can see the one that you promised to send. People in every tribe will see him, and he will save them. ");
INSERT INTO engPEV_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","He will shine like a light for people that are not Jews, showing them new things about you, God. And he will get everyone to respect your people, the Israel nation.” ");
INSERT INTO engPEV_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Joseph and Mary heard the things that Simeon said about Jesus, and they were surprised. ");
INSERT INTO engPEV_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Then Simeon asked God to be good to them, and he said to Mary, “This kid is going to ruin a lot of people in Israel, but he will help a lot of others. He will point people to God, but they will not understand, and they will argue against him. ");
INSERT INTO engPEV_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","When they do that, they will show everyone what they really think. And Mary, later you will be really sad. It will hurt, like somebody is stabbing you with a big knife.” ");
INSERT INTO engPEV_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","38","While Joseph and Mary were talking to Simeon, a very old woman came along. Her name was Anna. She saw Jesus, and she thanked God for him. Some of the people there were waiting for God to send somebody to help the Jewish people. Anna told them about Jesus, that he is that special person. Anna’s father was Fanuel, and he belonged to the tribe called Asher. She was 84 years old. A long time before this, Anna was a young woman and she got married. But then after 7 years her husband died. After that, she stayed in God’s ceremony house all the time, telling the people God’s words. She prayed all the time, in the day time and at night, and often she didn’t eat any food because she was praying. ");
INSERT INTO engPEV_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","After that, Joseph and Mary finished doing everything that their law said they had to do. Then they went back home, to Nazareth, in Galilee country. ");
INSERT INTO engPEV_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","And the baby started to grow big and strong, and he got wise too. And God was good to him. ");
INSERT INTO engPEV_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","The Jewish people have a ceremony every year called Passover. Every year Joseph and Mary went to Jerusalem for that ceremony. ");
INSERT INTO engPEV_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","When Jesus was 12 years old, they went to Jerusalem, like they always did, and they took Jesus with them. ");
INSERT INTO engPEV_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","After that ceremony finished, they started to go north, back to their home in Nazareth. They were with a lot of other people going north, and they thought Jesus was somewhere in that mob. They thought, “He will come to us when we stop to camp tonight.” But Jesus didn’t come to them when they stopped to camp. You see, he was still back in Jerusalem. Mary and Joseph looked for him among their relatives and all that mob that was camping on that road, ");
INSERT INTO engPEV_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","but they didn’t find him. So they went back to Jerusalem and looked for him there. ");
INSERT INTO engPEV_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","They looked for him for 3 days, then they found him in God’s ceremony house. He was sitting with the teachers there. He was listening to what they were saying, and he was asking them questions. ");
INSERT INTO engPEV_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","The people there listened to Jesus too, and they were very surprised at the things he said. He understood lots of things, and he knew the answers to all of their questions. ");
INSERT INTO engPEV_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","His mother and father were shocked, and Mary said, “My son, why did you do this to us? Your father and me, we have been worried about you. We have been looking everywhere for you, for 3 days.” ");
INSERT INTO engPEV_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesus said, “Why did you look everywhere for me? I had to be in my father’s special house. You should know that.” ");
INSERT INTO engPEV_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","But they didn’t understand what he meant by those words. ");
INSERT INTO engPEV_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Then Jesus went with them back to Nazareth, and he always did what his mother and father told him to do. And his mother always remembered all those things that happened, and she always thought about them. ");
INSERT INTO engPEV_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesus grew up to be a man, and as he got bigger, he became very wise too. God was really happy with him, and so was everyone that knew him. ");
INSERT INTO engPEV_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","The Holy Spirit made Jesus very powerful, and he went back to Galilee country. The people that saw him kept on telling other people about him, and those people told more people, so that soon everyone there heard the news about him. ");
INSERT INTO engPEV_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","He went to the Jewish meeting houses every week, and he taught everyone about God. And they were all really happy with him. ");
INSERT INTO engPEV_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Then Jesus went to his own town, called Nazareth. That was the town he grew up in. He went to the Jewish meeting house there on Saturday, like he always did, and he stood up to read to the people from God’s book. ");
INSERT INTO engPEV_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","A helper there gave him the part that Isaiah wrote. Isaiah was a man that told everyone God’s messages, a long time ago. Jesus opened the book to the right place, and he read these words. ");
INSERT INTO engPEV_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“God’s spirit came into me. He picked me to tell good news to poor people. He sent me to tell prisoners, ‘You will go free.’ And he sent me to tell blind people, ‘You will see.’ And he sent me to people that are in big trouble, to take their trouble away. ");
INSERT INTO engPEV_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","He sent me to tell everybody, ‘This is the time now for God to be good to you.’” ");
INSERT INTO engPEV_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Then Jesus closed the book, gave it back to the helper there, and sat down. Everybody kept looking straight at Jesus. ");
INSERT INTO engPEV_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","And then he started to teach them. He said, “You just heard me read that message that Isaiah wrote, a long time ago. Well, those things are happening right now, today, while you are listening to me.” ");
INSERT INTO engPEV_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","All those people started talking together. They said good things about Jesus, and they said, “Wow. He talked real good. But we know this man, he is Joseph’s son.” ");
INSERT INTO engPEV_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","So Jesus said, “I know what you are going to say next. You are going to use the picture talk that some people use. They say, ‘Doctor, make yourself better, to show us that you know how to make people better.’ And you mob will say to me, ‘Show us that you know how to do powerful things. Do them here, in your own home town, like you did in Capernium.’ ");
INSERT INTO engPEV_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Listen, whenever God picks a man to tell his messages, the people of his own home town don’t want him. They reckon they know him, so they will not listen to him. ");
INSERT INTO engPEV_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Think about these 2 stories in God’s book. Remember the story about God’s man, Elijah, that lived a long time ago. Our people, the Israel nation, did bad things at that time, so God punished them. He stopped the rain. No rain fell for 3½ years, and no food plants grew in the gardens, so nobody had enough food, and they were very hungry. But God looked after Elijah, and sent him to another place called Zarefath, in Sidon country. God got a widow there to look after Elijah, and God gave that widow enough food for herself, and her son, and Elijah too. Listen, there were a lot of widows in Israel at that time, but God did not save a widow that belonged to Israel, he saved a widow that belonged to Sidon country, not one of us Israel people. ");
INSERT INTO engPEV_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","And remember the story about Elisha, another one of God’s men that lived a long time ago. At that time, there was a man called Nayman, that belonged to Syria country. He had a bad skin sickness. But Elisha used God’s power to make him better. Listen, there were a lot of people in Israel that had a bad skin sickness at that time, but God made a Syrian man better, not one of us Israel people.” ");
INSERT INTO engPEV_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Those people in the meeting house heard Jesus say those things. They got really angry because they thought they were better than people from other places. ");
INSERT INTO engPEV_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","They got up and forced him out of the town. That town is on a big hill, and that mob chased Jesus up that hill. They were going to throw him off the top of the cliff there, to kill him. ");
INSERT INTO engPEV_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","But Jesus turned around, and he just went through the middle of that mob and went away. ");
INSERT INTO engPEV_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesus was talking to his followers, and he told them a picture story. He said, “Think about different sorts of trees that give us fruit to eat. Good trees don’t give us rubbish fruit. And rubbish trees don’t give us good fruit. ");
INSERT INTO engPEV_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Whenever we look at the fruit of a tree, we know what sort of tree it comes from. Think about it. We don’t get bananas or grapes from a rubbish prickly plant. ");
INSERT INTO engPEV_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","And it’s like that with people too. Good people think about good things, so they do good things. But bad people think about bad things, so they do bad things, and they say bad things. You see, the things people say, show what they think about.” ");
INSERT INTO engPEV_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jesus and his followers went to a town called Nain. A big mob of other people went with him. ");
INSERT INTO engPEV_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Just before that, a young man died in that town. He was the only son of his mother, and her husband was already dead, so she had nobody left to look after her. A big mob of people were with that mother, and they had the young man’s body on a stretcher. They were taking it along the road out of the town, to bury it. And at that same time, Jesus was going into that town on that same road. ");
INSERT INTO engPEV_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesus saw the mother, and he felt very sorry for her. He told her, “Don’t cry.” ");
INSERT INTO engPEV_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Then he walked over to the stretcher and touched it, and the men that were carrying it stopped. Jesus said, “Young man, listen to me. Get up.” ");
INSERT INTO engPEV_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Then the dead man sat up and started to talk. And Jesus told him to go back to his mother. ");
INSERT INTO engPEV_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Everyone that saw that was frightened. They said, “God is really great and powerful. God sent this man to us, to tell us his word and show us his power. God has come to help his people.” ");
INSERT INTO engPEV_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Then they went and told lots of other people what they saw. So people in the towns near there, and people everywhere in Judea country, they heard that story. ");
INSERT INTO engPEV_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","There was a man that was called Simon, and he was one of the Pharisee mob, that were strong for the Jewish law. He asked Jesus to eat dinner with him. So Jesus went to his house and sat down at the table with him and some other people. ");
INSERT INTO engPEV_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","There was a woman in that town that used to do bad things. She heard that Jesus was eating dinner with that man, so she got a pretty jar of oil that had perfume in it and took it to his house. It smelled really good, and it cost a lot of money. ");
INSERT INTO engPEV_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Then she went inside and was just behind Jesus, near his feet. She was crying, and her tears fell on his feet. Then she dried his feet with her hair, and she kissed them, then she poured all that special oil on to his feet. ");
INSERT INTO engPEV_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Simon, the Pharisee man, he saw her do that, and he said to himself, “I knew it. This man is not one of God’s men. He is letting a bad woman touch him. I reckon he doesn’t know she did a lot of bad things, so I reckon he doesn’t have God’s power.” ");
INSERT INTO engPEV_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesus said to him, “Simon, I want to tell you something.” Simon said, “All right, teacher, tell me.” ");
INSERT INTO engPEV_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Then Jesus told him a picture story. He said, “There was a rich man that used to lend money to people. One man borrowed $500 from him, and another man borrowed $50. ");
INSERT INTO engPEV_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","But both of those men lost all their money. They couldn’t pay that money back to the rich man. But the rich man was good to both of them and told them, ‘Don’t worry, I’ll let it go. You don’t have to pay me back that money.’ Well, Simon, what do you reckon? Which one of those men will love that rich man the most?” ");
INSERT INTO engPEV_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon said, “I reckon it is the man that owed him the most money and didn’t have to pay it back.” Jesus said, “You are right.” ");
INSERT INTO engPEV_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Then he turned towards the woman and said, “Simon, look at this woman. When I came into your house, you didn’t give me water to wash my feet, but she washed my feet with her tears, and dried them with her hair. ");
INSERT INTO engPEV_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","You didn’t kiss me on the cheek to make me feel good, but this woman keeps on kissing my feet. ");
INSERT INTO engPEV_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","You didn’t put any olive oil on my head, like people do for their friends, but she put oil on my feet that has perfume in it, and it cost a lot of money. ");
INSERT INTO engPEV_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Listen, I know she did a lot of bad things, but I’m telling you, I will say that she is not guilty of all those bad things. I will let it all go, and God will not punish her. That is the reason why she loves me a lot. But if somebody only did a few bad things, and I let it go, they will only love me a little bit.” ");
INSERT INTO engPEV_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Then Jesus said to the woman, “You did bad things, but I am letting it go, and I will say that you are not guilty.” ");
INSERT INTO engPEV_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","The other people there said to each other, “Who does this man think he is? He reckons he can say that somebody is not guilty, and then God will not punish them for the bad things they did.” ");
INSERT INTO engPEV_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","But Jesus said to the woman, “You trusted me, so you will not get trouble for the bad things you did. Don’t worry, you can go away happy and quiet now.” ");
INSERT INTO engPEV_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","After that, Jesus went around to a lot of different towns. In each town he told the people God’s good news. He said, “God wants to have you in his family.” He took his 12 special workers with him. ");
INSERT INTO engPEV_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","There were some women too, that went around with them. They used their own money to buy the things that Jesus and his special workers needed. Before that time, some of those women were sick, but Jesus made them better. And some of them had bad spirits in them, but Jesus forced those bad spirits out of them. One of those women was Mary Magdalene. Jesus forced 7 bad spirits out of her. Another one was Joanna, the wife of Chuza. Chuza was the boss over all the people that worked in the house of the big boss, that was called Herod. Another one of those women was Susanna. And there were lots of other women that went around with Jesus and his followers. ");
INSERT INTO engPEV_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","The time was soon coming for Jesus to go back to heaven, so he started to go to Jerusalem city. He wasn’t going to let anything stop him. ");
INSERT INTO engPEV_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","So he walked along the road, and soon he was getting close to a town in Samaria country, so he sent some messengers ahead of him to ask the people there for a place to stay that night. ");
INSERT INTO engPEV_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","But the people in that town said, “No. He is going to Jerusalem. We don’t like that Jerusalem mob, so he is not our friend. He can’t stay here tonight.” ");
INSERT INTO engPEV_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","James and John, 2 of Jesus’s special workers, heard what they said, then those 2 men said to Jesus, “Can we ask God to send fire down from the sky and kill all those people? Do you want us to do that?” ");
INSERT INTO engPEV_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesus turned around and said, “No. That is very wrong. Don’t do it.” ");
INSERT INTO engPEV_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Then they all went on to another town. ");
INSERT INTO engPEV_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","As they walked along the road, a man said to Jesus, “I want to be one of your followers. I will go everywhere with you.” ");
INSERT INTO engPEV_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesus said to him, “All right, but your life will not be easy. You see, wild dogs have places where they go to sleep, and birds have nests to rest in. But I haven’t got a home to lie down and sleep in, even though I’m God’s special man from heaven. So if you follow me, you too might not have a home.” ");
INSERT INTO engPEV_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","And Jesus said to another man, “Come and follow me.” That man said, “All right, I will come with you. But my father has died, so let me go home to bury him. After that, I will come with you.” ");
INSERT INTO engPEV_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesus said to him, “Some people don’t want me. It is like they are dead to me. So those people can bury the dead bodies of their own people. But you have to go and tell people that God wants them in his family.” ");
INSERT INTO engPEV_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Another man said to Jesus, “Yes, sir, I will follow you, but first I want to go back home and say goodbye to all my family.” ");
INSERT INTO engPEV_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesus said, “Don’t think about going back. I’ll use the picture of a man that is driving something. He has to look at what is ahead of him, not look back at what is behind him. Well, it is the same for you. You have to look at me, and think about me. If you think about the people and the things that you left behind, it is like you are looking back, and you are not the right person to join God’s family.” ");
INSERT INTO engPEV_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jesus talked to the people that lived in some towns. He said, “You mob that live in Korazin and Bethsayida, you will be really sorry. You know, I did a lot of powerful things there in your towns, but you didn’t listen to me, and you keep on doing bad things. Think about those towns called Tyre and Sidon. A long time ago their people did bad things. At that time, I didn’t go to them and do powerful things for them, like I did for you. They didn’t get to listen to me, so they couldn’t turn around and stop doing bad things. If they got to listen to me, they would be very sorry for the bad things they did, and they would turn to God real quick. But that didn’t happen. ");
INSERT INTO engPEV_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","You know, one day God will judge everybody, and he will punish those people for the bad things they did, but he will punish you mob a lot more than he will punish that mob. You mob heard my words, but you didn’t take any notice, and you didn’t turn to God. ");
INSERT INTO engPEV_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","And it’s the same for you mob that live in Capernium. You reckon you are good, so you reckon God will take you up into heaven. But you are wrong. He knows you are no good, and he will chuck you down into the bad place called hell.” ");
INSERT INTO engPEV_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","One day, a Jewish law man went to Jesus. He wanted to test Jesus, to see if he can answer a hard question. So he asked Jesus, “Teacher, what can I do so that I will live with God for ever?” ");
INSERT INTO engPEV_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus said, “You know God’s laws, and you read them all the time. What do you reckon they say?” ");
INSERT INTO engPEV_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","The man said, “One law says this, ‘You have to love God properly, not just a little bit. You have to love God from right inside yourself. You have to love God in the way you feel, and in the way you think. And you have to love God in the way you do things.’ And another law says this, ‘You have to love the people around you just as much as you love yourself.’” ");
INSERT INTO engPEV_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesus said, “You are right. Do what those laws say, and you will live with God for ever.” ");
INSERT INTO engPEV_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","But the man wanted to show that he asked an important question, so he said, “What does it mean by the people around me? Who are they?” ");
INSERT INTO engPEV_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesus answered that question by telling this picture story. He said, “A Jewish man was going down the road from Jerusalem city to the town called Jericho. About half-way along that road some bad men grabbed him. They beat him up, and they took everything he had, even his clothes, and then they ran away. They left him lying there, half dead. ");
INSERT INTO engPEV_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","After that, a leader of the Jewish ceremonies was walking down that road. He saw that man lying there, but he didn’t do anything to help him. He went over to the other side of the road to go past him, and he kept going down the road. ");
INSERT INTO engPEV_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","After that, a man that helped in the Jewish ceremonies went along that road. He looked at the man lying there, then he went to the other side of the road and went past him, and he kept going down the road. ");
INSERT INTO engPEV_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Then a man from Samaria country went along that road. He was riding on a donkey. You know, Samaria people and Jewish people don’t like each other, but when that Samaria man saw that Jewish man lying there, he felt sorry for him. ");
INSERT INTO engPEV_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","He went to that man and helped him. He treated the places where he was bleeding. He put wine and oil on them, and bandaged them, to help them get better. Then he lifted him up and put him on his donkey and took him to a hotel, and they both stayed there that night. ");
INSERT INTO engPEV_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","The next day, he paid a lot of money to the hotel boss, and said, ‘This is for you to keep this man here and look after him until he gets better. If it costs more than this, I’ll pay you the rest next time I come here.’” ");
INSERT INTO engPEV_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Then Jesus said to the law man, “There were 3 people that saw that man on the road. Which one of them treated that man like he was one of the people around them?” ");
INSERT INTO engPEV_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","The law man said, “I reckon it was the person that felt sorry for that man and helped him.” Jesus said, “You are right. So you always have to do that same sort of thing for other people.” ");
INSERT INTO engPEV_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesus and his followers kept going along the road to Jerusalem, and they went into a town. A woman called Martha lived in that town, and she asked him to come to her house, so they went with her. ");
INSERT INTO engPEV_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Then her sister, Mary, sat down near Jesus. He was teaching the people about God, and Mary just sat there listening to everything he said. ");
INSERT INTO engPEV_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martha was busy getting a big dinner ready, and she got upset because Mary wasn’t helping her. So she said to Jesus, “Sir, my sister isn’t helping me with the work. She has left me to do it by myself. Do you think that is all right? Tell her to get up and help me.” ");
INSERT INTO engPEV_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesus said, “Martha, Martha, you worry about a lot of things. ");
INSERT INTO engPEV_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","But only one thing is really important, and Mary is doing that. She is listening to me, and nobody can stop her.” ");
INSERT INTO engPEV_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Jesus told his followers a picture story, to teach them how to pray. He said, “Think about this. A man is going on a long trip, and at night he comes to the house where his cousin lives, so he visits him to stay the night with him. But his cousin hasn’t got any food to give him. So his cousin goes out in the middle of the night to his friend’s house, and he knocks on the door and he calls out, ‘My friend, can you give me some food? You see, my cousin has just come, and I haven’t got any food to give him. Can you give me some bread?’ ");
INSERT INTO engPEV_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","But his friend says, ‘Don’t humbug me now. I’m in bed, and my kids are in bed with me. I already locked the door. I can’t get up and give you anything.’ ");
INSERT INTO engPEV_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","But if that man keeps on knocking and asking for bread, after a while his friend will get up and give him everything he asks for. He will not do it because they are friends. He will do it because that man keeps on asking him. ");
INSERT INTO engPEV_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","So I’m telling you this. Keep asking God for what you need, and he will give it to you. Keep looking for what you need, and God will help you find it. Or if something is stopping you, like there is a door that is shut and you can’t get in, keep on knocking at that door, and God will open it for you. ");
INSERT INTO engPEV_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","You see, everyone that asks God for something will get it. Everyone that looks for something will find it. God will open the door for everyone that knocks on it. ");
INSERT INTO engPEV_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Some of you are fathers. If your kid asks you for a fish to eat, will you give him a cheeky snake instead? No, of course not. ");
INSERT INTO engPEV_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Or if your kid asks you for an egg, will you give him a cheeky scorpion instead? No, of course not. ");
INSERT INTO engPEV_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","You see, you might be bad, but you always give good things to your kids. Well, your father in heaven is a lot better than you, so you can be sure that he will always give you good things. He will send the Holy Spirit to everyone that asks him.” ");
INSERT INTO engPEV_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesus was talking to the people, and a man that belonged to the Pharisee mob asked him to come to his place for dinner. The Pharisee mob were very strong for the Jewish law. ");
INSERT INTO engPEV_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","They made a rule, that whenever anyone wanted to eat some food, they first had to wash their hands. But Jesus didn’t follow that rule. He didn’t wash his hands. The Pharisee man was shocked. ");
INSERT INTO engPEV_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","So Jesus said to him, “You Pharisee mob are like somebody that cleans the outside of cups and plates, but doesn’t clean the inside. You see, you only do good things if people can see you, like you are good on the outside. But you are really dirty on the inside. Yes, inside yourselves you are greedy, and you are always thinking in your heads about doing very bad things. ");
INSERT INTO engPEV_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Look, you are really stupid. You forget that God made the inside of you as well as the outside. He can see everything that is inside your heads. ");
INSERT INTO engPEV_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","The right way is like this. You have to think in your heads about poor people, and you have to feel sorry for them, and you have to give them the things they need. Then God will say that you are clean, on the inside as well as on the outside. ");
INSERT INTO engPEV_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","You mob follow God’s law that says you have to give him a little bit of everything you get. That little bit is one part out of every 10 parts. You do that for everything you get, even the little plants that grow in your garden. But you don’t do the important things that God wants everyone to do. So God will make trouble for you Pharisee mob. You see, you have to be fair to other people, and you have to love God. Those are the important things that you have to do, and you have to do the other things too. ");
INSERT INTO engPEV_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Yes, God will make trouble for you Pharisee mob. You try to get people to think you are important. Whenever you go to a meeting house, you want the good seats that are for important people. And whenever you walk around the shopping places, you want people to respect you and say hello to you in a good way. ");
INSERT INTO engPEV_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","But God will make trouble for you mob. You are like ground that has dead bodies in it that people don’t know about. People walk on that ground, and they think it is good. You are like that ground. You get people to think you are good, and they don’t know that you are bad on the inside.” ");
INSERT INTO engPEV_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Then a Jewish law man said to Jesus, “Hey, teacher, you are saying bad things about us too.” ");
INSERT INTO engPEV_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesus said, “That’s right, you mob are just as bad, and God will make trouble for you law men too. You make a lot of hard rules, and you make people follow all those rules. You are too hard on people. It is like you are making them carry lots of heavy things, and you don’t help them at all. You don’t even move one of your fingers to help them. ");
INSERT INTO engPEV_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yes, God will make trouble for you law teacher mob. A long time ago, your grand-fathers killed the men that told everyone God’s messages, and they buried them. And now, you mob put pretty little stone buildings there to remember the place where they buried them. ");
INSERT INTO engPEV_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","When you do that, you show that you agree with the bad things your grand-fathers did. They killed those good men, and now you make those buildings for them. ");
INSERT INTO engPEV_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Listen, God is wise, and he said, ‘I will pick men to tell everyone my messages, and I will pick men to be my special workers, and I will send them to the people. But you will kill some of them, and you will hurt some of them.’ ");
INSERT INTO engPEV_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yes, you people that are alive today will hurt and kill God’s people. And it has been like that for a long time. Your grand-fathers have been killing God’s men ever since the world first started. And you agree with those bad things that they did too, so God will punish you too, for all those bad things that they did. ");
INSERT INTO engPEV_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel was the first one of God’s men to die. And Zekariah was the last one to die. They killed him at God’s ceremony house, near the place where they kill animals and burn them, to give them to God. Yes, they killed those men, but God will punish you people that are alive today too. ");
INSERT INTO engPEV_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Listen, God will make trouble for you law men, because you don’t do the right thing. You know how to help people understand more about God, but you never do it. You yourselves don’t want to know God, and you stop everybody else, so they can’t know him either.” ");
INSERT INTO engPEV_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Then Jesus got up to go to another place, but the Jewish law teacher mob and the Pharisee mob started to get really angry with him, and they argued against him a lot. They tried to make him say something bad, so they could blame him. So they asked him a lot of hard questions. But he didn’t say anything bad. ");
INSERT INTO engPEV_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","A man in the crowd said to Jesus, “Teacher, my brother is cheating me. Our father died, and he left his things for my brother and me. But my brother took all those things, and he is keeping them for himself. Please tell my brother to be fair to me and give me my part of our father’s things.” ");
INSERT INTO engPEV_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesus said, “It’s not my job to say which one of you is right and which one is wrong, or what part of your father’s things each of you can have.” ");
INSERT INTO engPEV_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Then he said to the people, “Think carefully about this. Don’t be greedy. Don’t try to get more things than you need. You can’t get real life from the things you own, even if you are rich.” ");
INSERT INTO engPEV_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Then Jesus told them a picture story. He said, “A rich man had a big garden. He planted lots of seeds there, and they grew into very big plants, and then those plants grew lots of seed food on them. ");
INSERT INTO engPEV_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","The man looked at it all and said to himself, ‘My sheds are not big enough for all this seed food. Where will I put it all?’ ");
INSERT INTO engPEV_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","He thought about it, and then he said, ‘I know what to do. I will pull down my little sheds and build big sheds, and I will keep it all in those big sheds. And I will keep all my other things in those big sheds too. ");
INSERT INTO engPEV_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Then I will say, “Ah. I’ve got lots of stuff now. I’ve got enough in those sheds to last me for a long time. I don’t have to do any work. I can just sit down and eat, and drink, and be happy.” ’ ");
INSERT INTO engPEV_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","But God said to him, ‘You are stupid. You are going to die tonight. Then what will happen to all this stuff in your sheds? Who will get it? Not you.’ ");
INSERT INTO engPEV_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","That is a picture story to tell you people this. If you keep money and things just for yourself, and if you don’t use them the way God wants you to, you are stupid.” ");
INSERT INTO engPEV_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Then Jesus said to all the people, “Sometimes you look at the sky, and you see big clouds coming together, and you say, ‘Here comes some rain.’ And you are right. ");
INSERT INTO engPEV_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","And sometimes the north wind blows, and you say, ‘Today will be really hot.’ And again, you are right. ");
INSERT INTO engPEV_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","But really, you are fools. Yes, you know how to look at the earth and the sky, and work out what the weather is doing. But you don’t know how to look at the things that are happening right now, and work out what God is doing.” ");
INSERT INTO engPEV_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","About that time, some men from Galilee country were killing some animals to give them to God, but then Pilate, the big boss, went with his soldiers and killed those men. Then some people went and told Jesus what happened. ");
INSERT INTO engPEV_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesus said, “Do you reckon those men that died did more bad things than all the other men from Galilee? Is that why God let Pilate kill them? ");
INSERT INTO engPEV_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","No. That is not right. Listen, all of you mob do bad things. You have to stop doing bad things and turn to God. If you don’t turn to God, you will die, just like those men died. ");
INSERT INTO engPEV_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","And you know about the high building in Jerusalem city, at the place called Siloam. It fell down on top of 18 people and killed them. Do you think those people did more bad things than the other people in Jerusalem, and that is the reason why God let them die like that? ");
INSERT INTO engPEV_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","No. That is not right. Listen, all of you mob do bad things. You have to stop doing bad things and turn to God. If you don’t turn to God, you will die, just like those people died.” ");
INSERT INTO engPEV_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Then Jesus told them this picture story to show them that they have to turn to God soon. He said, “A man had a garden with grape vines growing in it. There was a fruit tree there too, called a fig tree. That man used to go to that garden, to see if there was any fruit on that tree, but he never found any fruit. ");
INSERT INTO engPEV_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","So he talked to his work-man that looked after the garden. He said, ‘Look, this tree is no good. I came here looking for fruit on this tree. I did that for the last 3 years, but I never found any fruit. So chop it down and get rid of it. We can’t let it go on like this. It is using up the ground and giving back nothing to us.’ ");
INSERT INTO engPEV_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","But his work-man said, ‘Wait, boss. Leave it for one more year, and I will look after it properly. I’ll dig around it and put some fertilizer stuff on it to help it grow. ");
INSERT INTO engPEV_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","And maybe next year it will get fruit on it. If it doesn’t get any fruit next year, then we can chop it down.’” ");
INSERT INTO engPEV_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","One Saturday, Jesus was teaching people in a Jewish meeting house. Their Jewish law said that nobody can work on a Saturday. It was their rest day. ");
INSERT INTO engPEV_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","There was a woman there with a bad spirit inside her. A long time before that, the bad spirit went into that woman and made her back crooked. That bad spirit lived in her for 18 years, and all that time her back was bent over. She couldn’t stand up straight. ");
INSERT INTO engPEV_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesus saw her in that meeting house, and he called out to her to come to him. And he said to her, “Friend, you are better now. You are free from that sickness.” ");
INSERT INTO engPEV_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Then he put his hands on her, and she stood up straight, right then. And she told everybody that God is really good. ");
INSERT INTO engPEV_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","But the boss of that meeting house got angry, because Jesus made a sick woman better on their rest day. So he told the people, “Listen, you mob. There are 6 days for work each week, so come on any one of those days and get him to make you better. But Saturday is our rest day. Don’t come on a Saturday.” ");
INSERT INTO engPEV_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jesus said to him, “You and your mob are wrong. You say one thing, but you do something different. You work for yourselves on our rest day, right? You know, you keep cows and donkeys tied up in your yards, and every day you untie them and take them out to a water-hole, to let them drink. You do that on our rest day too. ");
INSERT INTO engPEV_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Now look at this woman here. She belongs to Abraham’s family. But 18 years ago, Satan, the boss over the bad spirits, he made her back crooked. It’s like he has kept her tied up with this problem for 18 years. So why can’t I untie her, even on our rest day?” ");
INSERT INTO engPEV_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","When Jesus said those words, the bosses of that meeting house felt shame, but all the people were happy, because Jesus was doing a lot of really good things there. ");
INSERT INTO engPEV_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","At that time, some of the Pharisee mob, that were strong for the Jewish law, they went to Jesus and said, “Herod, that big boss, he wants to kill you, so you have to run away. Get right away from here.” ");
INSERT INTO engPEV_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesus said, “Herod is a bad man, and he is tricky, like a wild dog. Tell him that I’m forcing bad spirits out of people, and I’m making sick people better, and I’ll keep on doing these things for a bit longer. Then I’ll finish my work. ");
INSERT INTO engPEV_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","But I have to keep going now, and I’ll keep going for a bit longer, until I get to Jerusalem city. I will not die before I get there. You see, the Jerusalem mob are the worst. They kill the people that tell God’s messages.” ");
INSERT INTO engPEV_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Then Jesus gave a message for the people that lived in Jerusalem city. He said, “You Jerusalem mob. You never listen to the men that tell you God’s messages, but instead you kill them. Yes, you throw big stones at them to kill them. Listen, I wanted to look after you mob, just like a chook looks after her young chicks and covers them with her wings, so that nothing can hurt them. I often wanted to look after you like that, but you never let me. ");
INSERT INTO engPEV_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","So now God is leaving you. He will not look after you, or your city, or his ceremony house there. You mob will not see me again until the day comes when you will say, ‘God, we want you to look after this man you sent. Make him strong and happy.’” ");
INSERT INTO engPEV_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","One day, a man asked Jesus to come to his house to have dinner with him, and with some of his friends. He was a leader of the Pharisee mob, that were strong for the Jewish law. That day was a Saturday, and the Jewish law says that Saturday is their rest day. Nobody can work on the rest day. There was a sick man there at that Pharisee man’s house. His arms and legs were swollen. That Pharisee mob and the Jewish law men there, they watched Jesus to see if he was going to make that sick man better. ");
INSERT INTO engPEV_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesus asked them, “Is it all right to make people better on our rest day, or not?” ");
INSERT INTO engPEV_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","They didn’t want to answer him, so they said nothing. Then Jesus touched the sick man and made him better, and then Jesus said that he can go home. ");
INSERT INTO engPEV_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","And Jesus talked to the Pharisee mob and the law men. He said, “Sometimes you work on our rest day, right? If you ever have to do something straight away, like if your little kid falls into a deep hole on our rest day, you get up quick and pull your kid out. Or if your cow falls into a hole, you pull it out, even on our rest day. You do that, right? So it’s all right to do a good thing on our rest day. Is that right?” ");
INSERT INTO engPEV_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","That mob didn’t answer Jesus. They couldn’t say that he was wrong. ");
INSERT INTO engPEV_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","There were a lot of people at that dinner, and they all wanted to sit in the seats up near the boss. That’s the place where the important people sit. Jesus watched them, and he told them, ");
INSERT INTO engPEV_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“You are not doing the right thing. You see, if somebody asks you to come to a big dinner, don’t go quickly to the best seat and sit down there. Maybe later on, somebody more important than you will come, ");
INSERT INTO engPEV_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","and the boss will tell you, ‘Get up and give this person that good seat.’ Then you will feel shame, and you will have to find yourself an empty seat, and it will be down at the other end of the table, at the place for people that are not important. ");
INSERT INTO engPEV_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Instead of that, when you come to the dinner, go and sit at the place for people that are not important. Then later, the boss will see you there, and he will say, ‘My friend, you can have a better seat than that.’ And he will take you to a good seat, and everybody there will see him do that, and they will respect you. ");
INSERT INTO engPEV_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","You see, if you try to make yourself important, God will make you like nothing. But if you make yourself like nothing, God will make you important.” ");
INSERT INTO engPEV_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Then Jesus talked to the boss of that house. He said, “Whenever you put on a dinner for other people to come and eat with you, don’t ask your family, or your friends, or the rich people that live near you, to come and eat that food. If you ask those people to come, later they will ask you to come and eat some food with them. That will be the only pay you get for giving them food. ");
INSERT INTO engPEV_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Instead of that, ask poor people to come and eat with you. Maybe they are crippled, or blind, or they can’t walk, so they can’t get jobs to get some money, so they are too poor to put on a dinner for you. ");
INSERT INTO engPEV_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","There’s no way they can pay you for that food. But God will make you really happy on the day when he will make everyone alive again. At that time, he will pay you properly for that good thing you did for those poor people.” ");
INSERT INTO engPEV_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","One of the men sitting there heard the words that Jesus said, and that man said, “It will be really good to be at the dinner that God will put on for all his family.” ");
INSERT INTO engPEV_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesus told him this picture story. He said, “An important man put on a big dinner. He asked a lot of people to come to eat that dinner with him. ");
INSERT INTO engPEV_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","When all the food was ready, he sent his work-man out to tell them to come. That work-man told each one of them, ‘You can come now, the dinner is ready for you.’ ");
INSERT INTO engPEV_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","But each one told him they couldn’t come to that dinner. One of them said, ‘I have bought a garden, so I have to go and look at it. Please tell your boss I’m sorry, but I can’t come to his dinner.’ ");
INSERT INTO engPEV_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","The next man said, ‘I have just bought 10 cows, and I have to see if they work well together. Please tell your boss I’m sorry, but I can’t come to his dinner.’ ");
INSERT INTO engPEV_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Another man said, ‘I just got married, so I can’t come to that dinner.’ ");
INSERT INTO engPEV_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","The work-man went back to his boss and told him their stories. Then his boss was very angry. He said to his work-man, ‘Go quickly now to every street in this town, and get the poor people, and bring them here to eat this dinner. Bring the people that are crippled, and the people that are blind, and the people that can’t walk.’ ");
INSERT INTO engPEV_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","So the work-man went out and got those people. Then he told his boss, ‘Those people are here now, but there are still some empty seats at the table.’ ");
INSERT INTO engPEV_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","So the boss said, ‘Go out to the roads in the bush. Look for people that are out there. Tell them all to come here, so that my house will be full. They can eat this good food. ");
INSERT INTO engPEV_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","But those other people that I asked before, and they said they couldn’t come, I’m telling you this, none of them will eat any of this good food.’” ");
INSERT INTO engPEV_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Jesus said to the people, “If you want to follow me, first you have to think about it. Your life will be hard, so ask yourself, ‘Can I really do it?’ You know, it’s the same as when you want to build a big high building. At first you have to think about how much it will cost, and you have to find out if you have enough money to do that job, and to finish it. ");
INSERT INTO engPEV_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","If you don’t do that, you might start that job, then you might run out of money, and never finish that building. Then other people will laugh at you ");
INSERT INTO engPEV_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","and say, ‘You stupid fool. You started to build that thing, but you couldn’t finish it. Now it is no good for anything, so you wasted your money.’” ");
INSERT INTO engPEV_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Then Jesus told them another picture story. He said, “If a country’s big boss has to get his army to fight the army of another country, at first he thinks about it, to see if he will win. If the other army has a lot more soldiers, he might say, ‘No. My army is too little. We can’t win.’ ");
INSERT INTO engPEV_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Then he will send a message real quick to that other army’s big boss. He will say to him, ‘Let’s not fight each other. Let’s talk about the problem and sort it out, without fighting.’” ");
INSERT INTO engPEV_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Then Jesus said, “It is the same for you. If you want to be one of my followers, you have to think about it. You see, your life will be hard. You will have to leave everything you own, and then you can follow me.” ");
INSERT INTO engPEV_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","There were some people that everyone reckoned did really bad things. Some of them used to get tax money from the people and give it to the Roman government. Everyone reckoned those tax men were bad men. Lots of those bad people often went up to Jesus and listened to him. ");
INSERT INTO engPEV_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","That upset the Jewish law teachers and the Pharisee mob, the men that were strong for the Jewish law, so they complained about Jesus. They said, “He is a friend of bad people. He even eats food with them.” ");
INSERT INTO engPEV_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","So Jesus told the people this picture story. He said, ");
INSERT INTO engPEV_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Suppose there is a man that has 100 sheep, but one of them wanders away and gets lost. What do you think that man will do? He will leave all the other sheep and go out into the bush and look for the one that got lost. He will keep on looking for it until he finds it. ");
INSERT INTO engPEV_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Then, after he finds it, he will pick it up and carry it back home on his shoulders. He will be really happy. ");
INSERT INTO engPEV_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","After he gets home, he will call out to his family, and to his friends. He will say, ‘Look, I’ve found my lost sheep. We can all be happy together now.’ ");
INSERT INTO engPEV_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Well, just like that, whenever somebody turns back to God, everyone in heaven is really happy too. Whenever one bad person stops doing bad things, and lives God’s way, everyone in heaven is really happy. They are even more happy about that person, than they are about the big mob of other people that never went wrong.” ");
INSERT INTO engPEV_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesus told them another picture story. He said, “Suppose a woman has 10 coins, but then she loses one of them in her house. What do you think she will do? She will get a torch and look carefully everywhere in that house. She will even sweep all the floors, and she will keep on looking for her money until she finds it. ");
INSERT INTO engPEV_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Then, after she finds it, she will be happy, and she will call out to her family, and to her friends. She will say, ‘Look, I’ve found my lost coin. We can all be happy together now.’ ");
INSERT INTO engPEV_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Well, just like that, whenever somebody turns back to God, God’s angel messengers in heaven are really happy too. Whenever one bad person stops doing bad things, and lives God’s way, God’s angel messengers in heaven are really happy.” ");
INSERT INTO engPEV_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Then Jesus told the people another picture story. He said, “There was a man that had 2 sons. ");
INSERT INTO engPEV_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","One day, his youngest son said to him, ‘Dad, I want you to give me my part of all the things you own. I can’t wait until after you die to get it. No, I want it all now.’ So his father split up everything he had and gave one part to his youngest son, and he kept the other part for his oldest son. ");
INSERT INTO engPEV_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","A few days later, that youngest son sold all those things that his father gave him, then he took the money and went away to another country, far away. In that country he soon spent all that money. He just wasted it on all sorts of things that made him feel good. ");
INSERT INTO engPEV_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","After a while, he had no money left. At that same time, that country had no rain, so all the food plants died. And soon that young man had nothing to eat. ");
INSERT INTO engPEV_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","So he got a job with a man in that place. He had to look after that man’s pigs. ");
INSERT INTO engPEV_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","That young man was so hungry he wanted to eat the rubbish food that the pigs ate, but nobody gave him anything to eat. ");
INSERT INTO engPEV_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","At last he started to think properly. He thought, ‘Those men that work for my dad in his garden back home, they always get enough food to eat. But I am getting so hungry that I reckon I will die in this place. ");
INSERT INTO engPEV_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","So I will get up now and go back home to my dad, and I will say to him, “Dad, I’m sorry, I went wrong. I did the wrong thing to God, and I did the wrong thing to you. ");
INSERT INTO engPEV_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","So now I’m not good enough for you to call me your son, so just let me have a job in your garden. I will work for you, and you can just call me your work-man.” ’ ");
INSERT INTO engPEV_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","So he got up and started to go back to his father. But while he was still a long way off, his father saw him coming along the road. His father felt really sorry for him. He ran to his son and hugged him and kissed him. ");
INSERT INTO engPEV_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Then his son said, ‘Dad, I’m sorry, I went wrong. I did the wrong thing to God, and I did the wrong thing to you. So now I’m not good enough for you to call me your son.’ ");
INSERT INTO engPEV_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","But his father said to his workers there, ‘Go and get some really good clothes and put them on him. And be quick. And get him a ring for his finger, and get some shoes for his feet. ");
INSERT INTO engPEV_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","And get a fat young cow, and kill it, and cook the meat, so we can all have a big party. ");
INSERT INTO engPEV_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","You see, my son got himself lost, but now I have found him. I thought he was gone for ever, like he was dead, but now he came back to me, and it is like he came alive again.’ So those workers did what he told them to do, and they had a big party. ");
INSERT INTO engPEV_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","While all that was happening, the oldest son was working out in the garden, and he didn’t know what was going on. Then later, he knocked off work, and he started walking home. He got near to the house, and then he heard a lot of music, and he heard people dancing and having a good time. ");
INSERT INTO engPEV_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","So he asked one of the work-men, ‘What’s going on?’ ");
INSERT INTO engPEV_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","The work-man said, ‘Your brother just came back home, and your dad is having a party for him. We just killed a young cow and cooked its meat. Your brother is alive and well, so your dad is really happy.’ ");
INSERT INTO engPEV_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Then the oldest son got angry, and he said, ‘I’m not happy. I’m not going into the house to join in that party. No way.’ So his father came out and said, ‘Don’t be angry. Come on in, and have a good time with us.’ And the father kept on asking him to come in. ");
INSERT INTO engPEV_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","But the oldest son said, ‘No. It’s not fair. Look, I worked for you for years and years, and I always did everything you told me to do. But you never gave me a party. You didn’t even give me a young goat for me to kill and cook its meat, and have a good time with my friends. ");
INSERT INTO engPEV_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","But this other son of yours, he took your money away, and he wasted it. He even paid women to sleep with him, like a woman does with her husband. And then he came back here, and now you are good to him. You even killed a young cow and gave him a party. That’s not right.’ ");
INSERT INTO engPEV_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","His father said, ‘Listen, you are my son. You have always stayed with me, and now you own everything that I have. After I die, you will get all of it. ");
INSERT INTO engPEV_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","But your brother got himself lost, and now I have found him. I thought he was gone for ever, like he was dead, but he came back to me, and now it is like he came alive again. So we have to have a party and be happy together.’” ");
INSERT INTO engPEV_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Then Jesus told his followers another picture story. He said, “There was a rich man that had a big business, and he had another man working in his office. That other man was his manager. He looked after the rich man’s money. Somebody told the rich man, ‘Look, your manager is wasting your money.’ ");
INSERT INTO engPEV_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","So that boss said to his manager, ‘They tell me you are not doing your job properly. So I’m going to sack you, and you will not have a job any more. Now write down everything you have done with my money, and after that, you have to go.’ ");
INSERT INTO engPEV_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","The manager thought to himself, ‘Soon I will not have a job. What will I do to get money for my food? I’m not strong enough to do hard work, like digging the ground. And if I ask people for money all the time, I will feel shame. ");
INSERT INTO engPEV_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","What can I do? I know what to do. I will do something to get people to like me, so that after I lose my job, they will look after me, and they will let me live in their homes.’ ");
INSERT INTO engPEV_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","There were some people that borrowed things from that rich man, and they didn’t give anything back to him yet. So the manager called those people into the office. He asked one man, ‘What did you borrow from my boss?’ ");
INSERT INTO engPEV_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","That man said, ‘I borrowed 100 drums of oil.’ The manager said, ‘We can change that. Here is the paper that has the numbers on it. I’ll let you change it right now. Make it 50 drums of oil.’ ");
INSERT INTO engPEV_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Then the manager asked the next man, ‘What did you borrow from my boss?’ That man said, ‘I borrowed 100 bags of flour.’ The manager said, ‘We can change that. Here is the paper that has the numbers on it. I’ll let you change it right now. Make it 80 bags of flour.’ ");
INSERT INTO engPEV_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","That manager was cheating his boss, but his boss thought, ‘This man is a liar and a cheat, but he is smart too. He has done something that will help him get his food later.’” Then Jesus said, “You know, the people that don’t care about God, but only care about the things in this world, they are smart with the things of this world. God’s people are not so smart with the things of this world. ");
INSERT INTO engPEV_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","This is what you can learn from that story. Use your money now to help people that need money, and then later, after you die, and you haven’t got any money, God will say, ‘Good on you. Come and live with me for ever.’” ");
INSERT INTO engPEV_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Then Jesus said, “If people can trust you with little things, they can trust you with big things too. If you cheat with little things, you will cheat with big things too. ");
INSERT INTO engPEV_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","So if you cheat when you handle money and other things of this world, God will not trust you to look after his very special things. ");
INSERT INTO engPEV_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","And if you don’t look after other people’s things properly, God will not give you things for yourself. ");
INSERT INTO engPEV_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","You see, you can’t work for 2 bosses at the same time. If you try to do that, you will like one boss and work properly for him, and you will not like the other boss, and you will not work properly for him. You see, you can’t have God as your boss, and money as your boss, both at the same time.” ");
INSERT INTO engPEV_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Some of the Pharisee mob were there. They were strong for the Jewish law. And they loved money a lot too, so when they heard Jesus teach those things, they laughed at him. ");
INSERT INTO engPEV_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Then Jesus told them, “You mob want everyone to think you are good, but God knows what you are really like, and he knows what you think inside your heads. You see, there are things that people reckon are important, but God thinks those things are rubbish. ");
INSERT INTO engPEV_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","You know, God gave Moses the law for people to follow, and he sent his other men to tell people God’s messages. And God’s people had to follow those words, from the time of Moses until the time that John the Baptiser came. Then John told people about the new way. And I’m telling people about that new way too. I’m telling them how to join God’s family too, and now lots of people are trying hard to get into God’s family. ");
INSERT INTO engPEV_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","But the laws from Moses will not go away. You know, the sky and the earth will stay here for a long time, and while they stay here, God’s words will stay here too. God will not change any little bit of them.” ");
INSERT INTO engPEV_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Then Jesus said, “Some of those words from God are about people that want to break up their marriage. It is wrong. If a man divorces his wife and marries another woman, he is sleeping with the wrong woman. She is not his proper wife. And if another man marries the divorced woman, that man is sleeping with the wrong woman too.” ");
INSERT INTO engPEV_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesus told them another picture story. He said, “There was a rich man that always wore really good clothes, and he always had plenty of good food to eat. ");
INSERT INTO engPEV_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","And there was a very poor man. His name was Lazarus. He had a lot of sores on his body, and he was hungry, but he had nothing to eat. So he used to lie down at the gate of the rich man’s house. ");
INSERT INTO engPEV_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","He wanted to get some of the rubbish food that the rich man chucked away. But that rich man didn’t give him anything. And that poor man couldn’t stop the dogs there from licking his sores. ");
INSERT INTO engPEV_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Then one day, the poor man died, and God sent his angel messengers to get him and take him to be with Abraham, our grand-father that died a long time ago. Then later the rich man died, and his family buried his body. ");
INSERT INTO engPEV_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","He went to a place where dead people go. A big fire there was hurting him a lot. Then he looked up, and he saw Abraham, a long way off, and he saw Lazarus there with Abraham. ");
INSERT INTO engPEV_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","So he yelled out loud. He said, ‘Grand-father Abraham, this fire is hurting me a lot. Feel sorry for me, and send Lazarus to bring some water to me, and put his finger in it and then put it on my tongue, to cool it a little bit.’ ");
INSERT INTO engPEV_vp