﻿USE sofia;
DROP TABLE IF EXISTS sofia.engBBE_vpl;
CREATE TABLE engBBE_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES engBBE_vpl WRITE;
INSERT INTO engBBE_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","At the first God made the heaven and the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","And the earth was waste and without form; and it was dark on the face of the deep: and the Spirit of God was moving on the face of the waters. ");
INSERT INTO engBBE_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","And God said, Let there be light: and there was light. ");
INSERT INTO engBBE_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","And God, looking on the light, saw that it was good: and God made a division between the light and the dark, ");
INSERT INTO engBBE_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Naming the light, Day, and the dark, Night. And there was evening and there was morning, the first day. ");
INSERT INTO engBBE_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","And God said, Let there be a solid arch stretching over the waters, parting the waters from the waters. ");
INSERT INTO engBBE_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","And God made the arch for a division between the waters which were under the arch and those which were over it: and it was so. ");
INSERT INTO engBBE_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","And God gave the arch the name of Heaven. And there was evening and there was morning, the second day. ");
INSERT INTO engBBE_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","And God said, Let the waters under the heaven come together in one place, and let the dry land be seen: and it was so. ");
INSERT INTO engBBE_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","And God gave the dry land the name of Earth; and the waters together in their place were named Seas: and God saw that it was good. ");
INSERT INTO engBBE_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","And God said, Let grass come up on the earth, and plants producing seed, and fruit-trees giving fruit, in which is their seed, after their sort: and it was so. ");
INSERT INTO engBBE_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","And grass came up on the earth, and every plant producing seed of its sort, and every tree producing fruit, in which is its seed, of its sort: and God saw that it was good. ");
INSERT INTO engBBE_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","And there was evening and there was morning, the third day. ");
INSERT INTO engBBE_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","And God said, Let there be lights in the arch of heaven, for a division between the day and the night, and let them be for signs, and for marking the changes of the year, and for days and for years: ");
INSERT INTO engBBE_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","And let them be for lights in the arch of heaven to give light on the earth: and it was so. ");
INSERT INTO engBBE_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","And God made the two great lights: the greater light to be the ruler of the day, and the smaller light to be the ruler of the night: and he made the stars. ");
INSERT INTO engBBE_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","And God put them in the arch of heaven, to give light on the earth; ");
INSERT INTO engBBE_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","To have rule over the day and the night, and for a division between the light and the dark: and God saw that it was good. ");
INSERT INTO engBBE_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","And there was evening and there was morning, the fourth day. ");
INSERT INTO engBBE_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","And God said, Let the waters be full of living things, and let birds be in flight over the earth under the arch of heaven. ");
INSERT INTO engBBE_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","And God made great sea-beasts, and every sort of living and moving thing with which the waters were full, and every sort of winged bird: and God saw that it was good. ");
INSERT INTO engBBE_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","And God gave them his blessing, saying, Be fertile and have increase, making all the waters of the seas full, and let the birds be increased in the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","And there was evening and there was morning, the fifth day. ");
INSERT INTO engBBE_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","And God said, Let the earth give birth to all sorts of living things, cattle and all things moving on the earth, and beasts of the earth after their sort: and it was so. ");
INSERT INTO engBBE_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","And God made the beast of the earth after its sort, and the cattle after their sort, and everything moving on the face of the earth after its sort: and God saw that it was good. ");
INSERT INTO engBBE_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","And God said, Let us make man in our image, like us: and let him have rule over the fish of the sea and over the birds of the air and over the cattle and over all the earth and over every living thing which goes flat on the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","And God made man in his image, in the image of God he made him: male and female he made them. ");
INSERT INTO engBBE_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","And God gave them his blessing and said to them, Be fertile and have increase, and make the earth full and be masters of it; be rulers over the fish of the sea and over the birds of the air and over every living thing moving on the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","And God said, See, I have given you every plant producing seed, on the face of all the earth, and every tree which has fruit producing seed: they will be for your food: ");
INSERT INTO engBBE_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","And to every beast of the earth and to every bird of the air and every living thing moving on the face of the earth I have given every green plant for food: and it was so. ");
INSERT INTO engBBE_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","And God saw everything which he had made and it was very good. And there was evening and there was morning, the sixth day. ");
INSERT INTO engBBE_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","And the heaven and the earth and all things in them were complete. ");
INSERT INTO engBBE_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","And on the seventh day God came to the end of all his work; and on the seventh day he took his rest from all the work which he had done. ");
INSERT INTO engBBE_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","And God gave his blessing to the seventh day and made it holy: because on that day he took his rest from all the work which he had made and done. ");
INSERT INTO engBBE_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","These are the generations of the heaven and the earth when they were made. ");
INSERT INTO engBBE_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","In the day when the Lord God made earth and heaven there were no plants of the field on the earth, and no grass had come up: for the Lord God had not sent rain on the earth and there was no man to do work on the land. ");
INSERT INTO engBBE_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","But a mist went up from the earth, watering all the face of the land. ");
INSERT INTO engBBE_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","And the Lord God made man from the dust of the earth, breathing into him the breath of life: and man became a living soul. ");
INSERT INTO engBBE_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","And the Lord God made a garden in the east, in Eden; and there he put the man whom he had made. ");
INSERT INTO engBBE_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","And out of the earth the Lord made every tree to come, delighting the eye and good for food; and in the middle of the garden, the tree of life and the tree of the knowledge of good and evil. ");
INSERT INTO engBBE_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","And a river went out of Eden giving water to the garden; and from there it was parted and became four streams. ");
INSERT INTO engBBE_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","The name of the first is Pishon, which goes round about all the land of Havilah where there is gold. ");
INSERT INTO engBBE_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","And the gold of that land is good: there is bdellium and the onyx stone. ");
INSERT INTO engBBE_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","And the name of the second river is Gihon: this river goes round all the land of Cush. ");
INSERT INTO engBBE_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","And the name of the third river is Tigris, which goes to the east of Assyria. And the fourth river is Euphrates. ");
INSERT INTO engBBE_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","And the Lord God took the man and put him in the garden of Eden to do work in it and take care of it. ");
INSERT INTO engBBE_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","And the Lord God gave the man orders, saying, You may freely take of the fruit of every tree of the garden: ");
INSERT INTO engBBE_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","But of the fruit of the tree of the knowledge of good and evil you may not take; for on the day when you take of it, death will certainly come to you. ");
INSERT INTO engBBE_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","And the Lord God said, It is not good for the man to be by himself: I will make one like himself as a help to him ");
INSERT INTO engBBE_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","And from the earth the Lord God made every beast of the field and every bird of the air, and took them to the man to see what names he would give them: and whatever name he gave to any living thing, that was its name. ");
INSERT INTO engBBE_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","And the man gave names to all cattle and to the birds of the air and to every beast of the field; but Adam had no one like himself as a help. ");
INSERT INTO engBBE_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","And the Lord God sent a deep sleep on the man, and took one of the bones from his side while he was sleeping, joining up the flesh again in its place: ");
INSERT INTO engBBE_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","And the bone which the Lord God had taken from the man he made into a woman, and took her to the man. ");
INSERT INTO engBBE_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","And the man said, This is now bone of my bone and flesh of my flesh: let her name be Woman because she was taken out of Man. ");
INSERT INTO engBBE_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","For this cause will a man go away from his father and his mother and be joined to his wife; and they will be one flesh. ");
INSERT INTO engBBE_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","And the man and his wife were without clothing, and they had no sense of shame. ");
INSERT INTO engBBE_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Now the snake was wiser than any beast of the field which the Lord God had made. And he said to the woman, Has God truly said that you may not take of the fruit of any tree in the garden? ");
INSERT INTO engBBE_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","And the woman said, We may take of the fruit of the trees in the garden: ");
INSERT INTO engBBE_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","But of the fruit of the tree in the middle of the garden, God has said, If you take of it or put your hands on it, death will come to you. ");
INSERT INTO engBBE_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","And the snake said, Death will not certainly come to you: ");
INSERT INTO engBBE_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","For God sees that on the day when you take of its fruit, your eyes will be open, and you will be as gods, having knowledge of good and evil. ");
INSERT INTO engBBE_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","And when the woman saw that the tree was good for food, and a delight to the eyes, and to be desired to make one wise, she took of its fruit, and gave it to her husband. ");
INSERT INTO engBBE_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","And their eyes were open and they were conscious that they had no clothing and they made themselves coats of leaves stitched together. ");
INSERT INTO engBBE_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","And there came to them the sound of the Lord God walking in the garden in the evening wind: and the man and his wife went to a secret place among the trees of the garden, away from the eyes of the Lord God. ");
INSERT INTO engBBE_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","And the voice of the Lord God came to the man, saying, Where are you? ");
INSERT INTO engBBE_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","And he said, Hearing your voice in the garden I was full of fear, because I was without clothing: and I kept myself from your eyes. ");
INSERT INTO engBBE_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","And he said, Who gave you the knowledge that you were without clothing? Have you taken of the fruit of the tree which I said you were not to take? ");
INSERT INTO engBBE_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","And the man said, The woman whom you gave to be with me, she gave me the fruit of the tree and I took it. ");
INSERT INTO engBBE_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","And the Lord God said to the woman, What have you done? And the woman said, I was tricked by the deceit of the snake and I took it. ");
INSERT INTO engBBE_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","And the Lord God said to the snake, Because you have done this you are cursed more than all cattle and every beast of the field; you will go flat on the earth, and dust will be your food all the days of your life: ");
INSERT INTO engBBE_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","And there will be war between you and the woman and between your seed and her seed: by him will your head be crushed and by you his foot will be wounded. ");
INSERT INTO engBBE_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","To the woman he said, Great will be your pain in childbirth; in sorrow will your children come to birth; still your desire will be for your husband, but he will be your master. ");
INSERT INTO engBBE_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","And to Adam he said, Because you gave ear to the voice of your wife and took of the fruit of the tree which I said you were not to take, the earth is cursed on your account; in pain you will get your food from it all your life. ");
INSERT INTO engBBE_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Thorns and waste plants will come up, and the plants of the field will be your food; ");
INSERT INTO engBBE_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","With the hard work of your hands you will get your bread till you go back to the earth from which you were taken: for dust you are and to the dust you will go back. ");
INSERT INTO engBBE_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","And the man gave his wife the name of Eve because she was the mother of all who have life. ");
INSERT INTO engBBE_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","And the Lord God made for Adam and for his wife coats of skins for their clothing. ");
INSERT INTO engBBE_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","And the Lord God said, Now the man has become like one of us, having knowledge of good and evil; and now if he puts out his hand and takes of the fruit of the tree of life, he will go on living for ever. ");
INSERT INTO engBBE_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","So the Lord God sent him out of the garden of Eden to be a worker on the earth from which he was taken. ");
INSERT INTO engBBE_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","So he sent the man out; and at the east of the garden of Eden he put winged ones and a flaming sword turning every way to keep the way to the tree of life. ");
INSERT INTO engBBE_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","And the man had connection with Eve his wife, and she became with child and gave birth to Cain, and said, I have got a man from the Lord. ");
INSERT INTO engBBE_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Then again she became with child and gave birth to Abel, his brother. And Abel was a keeper of sheep, but Cain was a farmer. ");
INSERT INTO engBBE_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","And after a time, Cain gave to the Lord an offering of the fruits of the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","And Abel gave an offering of the young lambs of his flock and of their fat. And the Lord was pleased with Abel's offering; ");
INSERT INTO engBBE_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","But in Cain and his offering he had no pleasure. And Cain was angry and his face became sad. ");
INSERT INTO engBBE_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","And the Lord said to Cain, Why are you angry? and why is your face sad? ");
INSERT INTO engBBE_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","If you do well, will you not have honour? and if you do wrong, sin is waiting at the door, desiring to have you, but do not let it be your master. ");
INSERT INTO engBBE_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","And Cain said to his brother, Let us go into the field: and when they were in the field, Cain made an attack on his brother Abel and put him to death. ");
INSERT INTO engBBE_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","And the Lord said to Cain, Where is your brother Abel? And he said, I have no idea: am I my brother's keeper? ");
INSERT INTO engBBE_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","And he said, What have you done? the voice of your brother's blood is crying to me from the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","And now you are cursed from the earth, whose mouth is open to take your brother's blood from your hand; ");
INSERT INTO engBBE_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","No longer will the earth give you her fruit as the reward of your work; you will be a wanderer in flight over the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","And Cain said, My punishment is greater than my strength. ");
INSERT INTO engBBE_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","You have sent me out this day from the face of the earth and from before your face; I will be a wanderer in flight over the earth, and whoever sees me will put me to death. ");
INSERT INTO engBBE_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","And the Lord said, Truly, if Cain is put to death, seven lives will be taken for his. And the Lord put a mark on Cain so that no one might put him to death. ");
INSERT INTO engBBE_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","And Cain went away from before the face of the Lord, and made his living-place in the land of Nod on the east of Eden. ");
INSERT INTO engBBE_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","And Cain had connection with his wife and she became with child and gave birth to Enoch: and he made a town, and gave the town the name of Enoch after his son. ");
INSERT INTO engBBE_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","And Enoch had a son Irad: and Irad became the father of Mehujael: and Mehujael became the father of Methushael: and Methushael became the father of Lamech. ");
INSERT INTO engBBE_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","And Lamech had two wives; the name of the one was Adah, and the name of the other Zillah. ");
INSERT INTO engBBE_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","And Adah gave birth to Jabal: he was the father of such as are living in tents and keep cattle. ");
INSERT INTO engBBE_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","And his brother's name was Jubal: he was the father of all players on instruments of music. ");
INSERT INTO engBBE_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","And Zillah gave birth to Tubal-cain, who is the father of every maker of cutting instruments of brass and iron: and the sister of Tubal-cain was Naamah. ");
INSERT INTO engBBE_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","And Lamech said to his wives, Adah and Zillah, give ear to my voice; you wives of Lamech, give attention to my words, for I would put a man to death for a wound, and a young man for a blow; ");
INSERT INTO engBBE_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","If seven lives are to be taken as punishment for Cain's death, seventy-seven will be taken for Lamech's. ");
INSERT INTO engBBE_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","And Adam had connection with his wife again, and she gave birth to a son to whom she gave the name of Seth: for she said, God has given me another seed in place of Abel, whom Cain put to death. ");
INSERT INTO engBBE_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","And Seth had a son, and he gave him the name of Enosh: at this time men first made use of the name of the Lord in worship. ");
INSERT INTO engBBE_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","This is the book of the generations of Adam. In the day when God made man, he made him in the image of God; ");
INSERT INTO engBBE_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Male and female he made them, naming them Man, and giving them his blessing on the day when they were made. ");
INSERT INTO engBBE_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam had been living for a hundred and thirty years when he had a son like himself, after his image, and gave him the name of Seth: ");
INSERT INTO engBBE_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","And after the birth of Seth, Adam went on living for eight hundred years, and had sons and daughters: ");
INSERT INTO engBBE_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","And all the years of Adam's life were nine hundred and thirty: and he came to his end. ");
INSERT INTO engBBE_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","And Seth was a hundred and five years old when he became the father of Enosh: ");
INSERT INTO engBBE_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","And he went on living after the birth of Enosh for eight hundred and seven years, and had sons and daughters: ");
INSERT INTO engBBE_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","And all the years of Seth's life were nine hundred and twelve: and he came to his end. ");
INSERT INTO engBBE_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","And Enosh was ninety years old when he became the father of Kenan: ");
INSERT INTO engBBE_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","And after the birth of Kenan, Enosh went on living for eight hundred and fifteen years, and had sons and daughters: ");
INSERT INTO engBBE_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","And all the years of Enosh were nine hundred and five: and he came to his end. ");
INSERT INTO engBBE_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","And Kenan was seventy years old when he became the father of Mahalalel: ");
INSERT INTO engBBE_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","And after the birth of Mahalalel, Kenan went on living for eight hundred and forty years, and had sons and daughters: ");
INSERT INTO engBBE_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","And all the years of Kenan's life were nine hundred and ten; and he came to his end. ");
INSERT INTO engBBE_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","And Mahalalel was sixty-five years old when he became the father of Jared: ");
INSERT INTO engBBE_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","And after the birth of Jared, Mahalalel went on living for eight hundred and thirty years, and had sons and daughters: ");
INSERT INTO engBBE_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","And all the years of Mahalalel's life were eight hundred and ninety-five: and he came to his end. ");
INSERT INTO engBBE_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","And Jared was a hundred and sixty-two years old when he became the father of Enoch: ");
INSERT INTO engBBE_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","And Jared went on living after the birth of Enoch for eight hundred years, and had sons and daughters: ");
INSERT INTO engBBE_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","And all the years of Jared's life were nine hundred and sixty-two: and he came to his end. ");
INSERT INTO engBBE_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","And Enoch was sixty-five years old when he became the father of Methuselah: ");
INSERT INTO engBBE_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","And after the birth of Methuselah, Enoch went on in God's ways for three hundred years, and had sons and daughters: ");
INSERT INTO engBBE_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","And all the years of Enoch's life were three hundred and sixty-five: ");
INSERT INTO engBBE_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","And Enoch went on in God's ways: and he was not seen again, for God took him. ");
INSERT INTO engBBE_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","And Methuselah was a hundred and eighty-seven years old when he became the father of Lamech: ");
INSERT INTO engBBE_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","And after the birth of Lamech, Methuselah went on living for seven hundred and eighty-two years, and had sons and daughters: ");
INSERT INTO engBBE_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","And all the years of Methuselah's life were nine hundred and sixty-nine: and he came to his end. ");
INSERT INTO engBBE_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","And Lamech was a hundred and eighty-two years old when he had a son: ");
INSERT INTO engBBE_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","And he gave him the name of Noah, saying, Truly, he will give us rest from our trouble and the hard work of our hands, because of the earth which was cursed by God. ");
INSERT INTO engBBE_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","And after the birth of Noah, Lamech went on living for five hundred and ninety-five years, and had sons and daughters: ");
INSERT INTO engBBE_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","And all the years of Lamech's life were seven hundred and seventy-seven: and he came to his end. ");
INSERT INTO engBBE_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","And when Noah was five hundred years old, he became the father of Shem, Ham, and Japheth. ");
INSERT INTO engBBE_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","And after a time, when men were increasing on the earth, and had daughters, ");
INSERT INTO engBBE_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","The sons of God saw that the daughters of men were fair; and they took wives for themselves from those who were pleasing to them. ");
INSERT INTO engBBE_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","And the Lord said, My spirit will not be in man for ever, for he is only flesh; so the days of his life will be a hundred and twenty years. ");
INSERT INTO engBBE_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","There were men of great strength and size on the earth in those days; and after that, when the sons of God had connection with the daughters of men, they gave birth to children: these were the great men of old days, the men of great name. ");
INSERT INTO engBBE_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","And the Lord saw that the sin of man was great on the earth, and that all the thoughts of his heart were evil. ");
INSERT INTO engBBE_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","And the Lord had sorrow because he had made man on the earth, and grief was in his heart. ");
INSERT INTO engBBE_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","And the Lord said, I will take away man, whom I have made, from the face of the earth, even man and beast and that which goes on the earth and every bird of the air; for I have sorrow for having made them. ");
INSERT INTO engBBE_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","But Noah had grace in the eyes of God. ");
INSERT INTO engBBE_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","These are the generations of Noah. Noah was an upright man and without sin in his generation: he went in the ways of God. ");
INSERT INTO engBBE_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","And Noah had three sons, Shem, Ham, and Japheth. ");
INSERT INTO engBBE_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","And the earth was evil in God's eyes and full of violent ways. ");
INSERT INTO engBBE_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","And God, looking on the earth, saw that it was evil: for the way of all flesh had become evil on the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","And God said to Noah, The end of all flesh has come; the earth is full of their violent doings, and now I will put an end to them with the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Make for yourself an ark of gopher wood with rooms in it, and make it safe from the water inside and out. ");
INSERT INTO engBBE_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","And this is the way you are to make it: it is to be three hundred cubits long, fifty cubits wide, and thirty cubits high. ");
INSERT INTO engBBE_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","You are to put a window in the ark, a cubit from the roof, and a door in the side of it, and you are to make it with a lower and second and third floors. ");
INSERT INTO engBBE_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","For truly, I will send a great flow of waters over the earth, for the destruction from under the heaven of all flesh in which is the breath of life; everything on the earth will come to an end. ");
INSERT INTO engBBE_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","But with you I will make an agreement; and you will come into the ark, you and your sons and your wife and your sons' wives with you. ");
INSERT INTO engBBE_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","And you will take with you into the ark two of every sort of living thing, and keep them safe with you; they will be male and female. ");
INSERT INTO engBBE_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Two of every sort of bird and cattle and of every sort of living thing which goes on the earth will you take with you to keep them from destruction. ");
INSERT INTO engBBE_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","And make a store of every sort of food for yourself and them. ");
INSERT INTO engBBE_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","And all these things Noah did; as God said, so he did. ");
INSERT INTO engBBE_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","And the Lord said to Noah, Take all your family and go into the ark, for you only in this generation have I seen to be upright. ");
INSERT INTO engBBE_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Of every clean beast you will take seven males and seven females, and of the beasts which are not clean, two, the male and his female; ");
INSERT INTO engBBE_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","And of the birds of the air, seven males and seven females, so that their seed may still be living on the face of the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","For after seven days I will send rain on the earth for forty days and forty nights, for the destruction of every living thing which I have made on the face of the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","And Noah did everything which the Lord said he was to do. ");
INSERT INTO engBBE_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","And Noah was six hundred years old when the waters came flowing over all the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","And Noah, with his sons and his wife and his sons' wives, went into the ark because of the flowing of the waters. ");
INSERT INTO engBBE_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Of clean beasts, and of beasts which are not clean, and of birds, and of everything which goes on the earth, ");
INSERT INTO engBBE_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","In twos, male and female, they went into the ark with Noah, as God had said. ");
INSERT INTO engBBE_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","And after the seven days, the waters came over all the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","In the six hundredth year of Noah's life, in the second month, on the seventeenth day of the month, all the fountains of the great deep came bursting through, and the windows of heaven were open; ");
INSERT INTO engBBE_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","And rain came down on the earth for forty days and forty nights. ");
INSERT INTO engBBE_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","On the same day Noah, with Shem, Ham, and Japheth, his sons, and his wife and his sons' wives, went into the ark; ");
INSERT INTO engBBE_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","And with them, every sort of beast and cattle, and every sort of thing which goes on the earth, and every sort of bird. ");
INSERT INTO engBBE_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","They went with Noah into the ark, two and two of all flesh in which is the breath of life. ");
INSERT INTO engBBE_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Male and female of all flesh went in, as God had said, and the ark was shut by the Lord. ");
INSERT INTO engBBE_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","And for forty days the waters were over all the earth; and the waters were increased so that the ark was lifted up high over the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","And the waters overcame everything and were increased greatly on the earth, and the ark was resting on the face of the waters. ");
INSERT INTO engBBE_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","And the waters overcame everything on the earth; and all the mountains under heaven were covered. ");
INSERT INTO engBBE_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","The waters went fifteen cubits higher, till all the mountains were covered. ");
INSERT INTO engBBE_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","And destruction came on every living thing moving on the earth, birds and cattle and beasts and everything which went on the earth, and every man. ");
INSERT INTO engBBE_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Everything on the dry land, in which was the breath of life, came to its end. ");
INSERT INTO engBBE_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Every living thing on the face of all the earth, man and cattle and things moving on the face of the earth, and birds of the air, came to destruction: only Noah and those who were with him in the ark, were kept from death. ");
INSERT INTO engBBE_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","And the waters were over the earth a hundred and fifty days. ");
INSERT INTO engBBE_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","And God kept Noah in mind, and all the living things and the cattle which were with him in the ark: and God sent a wind over the earth, and the waters went down. ");
INSERT INTO engBBE_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","And the fountains of the deep and the windows of heaven were shut, and the rain from heaven was stopped. ");
INSERT INTO engBBE_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","And the waters went slowly back from the earth, and at the end of a hundred and fifty days the waters were lower. ");
INSERT INTO engBBE_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","And on the seventeenth day of the seventh month the ark came to rest on the mountains of Ararat. ");
INSERT INTO engBBE_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","And still the waters went on falling, till on the first day of the tenth month the tops of the mountains were seen. ");
INSERT INTO engBBE_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Then, after forty days, through the open window of the ark which he had made, ");
INSERT INTO engBBE_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Noah sent out a raven, which went this way and that till the waters were gone from the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","And he sent out a dove, to see if the waters had gone from the face of the earth; ");
INSERT INTO engBBE_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","But the dove saw no resting-place for her foot, and came back to the ark, for the waters were still over all the earth; and he put out his hand, and took her into the ark. ");
INSERT INTO engBBE_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","And after waiting another seven days, he sent the dove out again; ");
INSERT INTO engBBE_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","And the dove came back at evening, and in her mouth was an olive-leaf broken off: so Noah was certain that the waters had gone down on the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","And after seven days more, he sent the dove out again, but she did not come back to him. ");
INSERT INTO engBBE_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","And in the six hundred and first year, on the first day of the first month, the waters were dry on the earth: and Noah took the cover off the ark and saw that the face of the earth was dry. ");
INSERT INTO engBBE_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","And on the twenty-seventh day of the second month the earth was dry. ");
INSERT INTO engBBE_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","And God said to Noah, ");
INSERT INTO engBBE_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Go out of the ark, you and your wife and your sons and your sons' wives. ");
INSERT INTO engBBE_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Take out with you every living thing which is with you, birds and cattle and everything which goes on the earth, so that they may have offspring and be fertile and be increased on the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","And Noah went out with his sons and his wife and his sons' wives; ");
INSERT INTO engBBE_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","And every beast and bird and every living thing of every sort which goes on the earth, went out of the ark. ");
INSERT INTO engBBE_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","And Noah made an altar to the Lord, and from every clean beast and bird he made burned offerings on the altar. ");
INSERT INTO engBBE_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","And when the sweet smell came up to the Lord, he said in his heart, I will not again put a curse on the earth because of man, for the thoughts of man's heart are evil from his earliest days; never again will I send destruction on all living things as I have done. ");
INSERT INTO engBBE_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","While the earth goes on, seed time and the getting in of the grain, cold and heat, summer and winter, day and night, will not come to an end. ");
INSERT INTO engBBE_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","And God gave his blessing to Noah and his sons, and said, Be fertile, and have increase, and make the earth full. ");
INSERT INTO engBBE_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","And the fear of you will be strong in every beast of the earth and every bird of the air; everything which goes on the land, and all the fishes of the sea, are given into your hands. ");
INSERT INTO engBBE_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Every living and moving thing will be food for you; I give them all to you as before I gave you all green things. ");
INSERT INTO engBBE_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","But flesh with the life-blood in it you may not take for food. ");
INSERT INTO engBBE_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","And for your blood, which is your life, will I take payment; from every beast I will take it, and from every man will I take payment for the blood of his brother-man. ");
INSERT INTO engBBE_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Whoever takes a man's life, by man will his life be taken; because God made man in his image. ");
INSERT INTO engBBE_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","And now, be fertile and have increase; have offspring on the earth and become great in number. ");
INSERT INTO engBBE_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","And God said to Noah and to his sons, ");
INSERT INTO engBBE_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Truly, I will make my agreement with you and with your seed after you, ");
INSERT INTO engBBE_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","And with every living thing with you, all birds and cattle and every beast of the earth which comes out of the ark with you. ");
INSERT INTO engBBE_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","And I will make my agreement with you; never again will all flesh be cut off by the waters; never again will the waters come over all the earth for its destruction. ");
INSERT INTO engBBE_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","And God said, This is the sign of the agreement which I make between me and you and every living thing with you, for all future generations: ");
INSERT INTO engBBE_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","I will put my bow in the cloud and it will be for a sign of the agreement between me and the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","And whenever I make a cloud come over the earth, the bow will be seen in the cloud, ");
INSERT INTO engBBE_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","And I will keep in mind the agreement between me and you and every living thing; and never again will there be a great flow of waters causing destruction to all flesh. ");
INSERT INTO engBBE_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","And the bow will be in the cloud, and looking on it, I will keep in mind the eternal agreement between God and every living thing on the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","And God said to Noah, This is the sign of the agreement which I have made between me and all flesh on the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","And the sons of Noah who went out of the ark were Shem, Ham, and Japheth; and Ham is the father of Canaan. ");
INSERT INTO engBBE_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","These three were the sons of Noah and from them all the earth was peopled. ");
INSERT INTO engBBE_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","In those days Noah became a farmer, and he made a vine-garden. ");
INSERT INTO engBBE_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","And he took of the wine of it and was overcome by drink; and he was uncovered in his tent. ");
INSERT INTO engBBE_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","And Ham, the father of Canaan, saw his father unclothed, and gave news of it to his two brothers outside. ");
INSERT INTO engBBE_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","And Shem and Japheth took a robe, and putting it on their backs went in with their faces turned away, and put it over their father so that they might not see him unclothed. ");
INSERT INTO engBBE_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","And, awaking from his wine, Noah saw what his youngest son had done to him, and he said, ");
INSERT INTO engBBE_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Cursed be Canaan; let him be a servant of servants to his brothers. ");
INSERT INTO engBBE_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","And he said, Praise to the Lord, the God of Shem; let Canaan be his servant. ");
INSERT INTO engBBE_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","May God make Japheth great, and let his living-place be in the tents of Shem, and let Canaan be his servant. ");
INSERT INTO engBBE_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","And Noah went on living three hundred and fifty years after the great flow of waters; ");
INSERT INTO engBBE_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","all the years of his life were nine hundred and fifty: and he came to his end. ");
INSERT INTO engBBE_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Now these are the generations of the sons of Noah, Shem, Ham, and Japheth: these are the sons which they had after the great flow of waters ");
INSERT INTO engBBE_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","The sons of Japheth: Gomer and Magog and Madai and Javan and Tubal and Meshech and Tiras. ");
INSERT INTO engBBE_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","And the sons of Gomer: Ashkenaz and Riphath and Togarmah. ");
INSERT INTO engBBE_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","And the sons of Javan: Elishah and Tarshish, the Kittim and the Dodanim. ");
INSERT INTO engBBE_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","From these came the nations of the sea-lands, with their different families and languages. ");
INSERT INTO engBBE_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","And the sons of Ham: Cush and Mizraim and Put and Canaan. ");
INSERT INTO engBBE_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","And the sons of Cush: Seba and Havilah and Sabtah and Raamah and Sabteca; and the sons of Raamah: Sheba and Dedan. ");
INSERT INTO engBBE_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","And Cush was the father of Nimrod, who was the first of the great men of the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","He was a very great bowman, so that there is a saying, Like Nimrod, a very great bowman. ");
INSERT INTO engBBE_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","And at the first, his kingdom was Babel and Erech and Accad and Calneh, in the land of Shinar. ");
INSERT INTO engBBE_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","From that land he went out into Assyria, building Nineveh with its wide streets and Calah, ");
INSERT INTO engBBE_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","And Resen between Nineveh and Calah, which is a very great town. ");
INSERT INTO engBBE_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","And Mizraim was the father of the Ludim and Anamim and Lehabim and Naphtuhim; ");
INSERT INTO engBBE_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","And Pathrusim and Casluhim and Caphtorim, from whom came the Philistines. ");
INSERT INTO engBBE_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","And Canaan was the father of Zidon, who was his oldest son, and Heth, ");
INSERT INTO engBBE_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","And the Jebusite and the Amorite and the Girgashite, ");
INSERT INTO engBBE_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","And the Hivite and the Arkite and the Sinite, ");
INSERT INTO engBBE_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","And the Arvadite and the Zemarite and the Hamathite; after that the families of the Canaanites went far and wide in all directions; ");
INSERT INTO engBBE_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Their country stretching from Zidon to Gaza, in the direction of Gerar; and to Lasha, in the direction of Sodom and Gomorrah and Admah and Zeboiim. ");
INSERT INTO engBBE_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","All these, with their different families, languages, lands, and nations, are the offspring of Ham. ");
INSERT INTO engBBE_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","And Shem, the older brother of Japheth, the father of the children of Eber, had other sons in addition. ");
INSERT INTO engBBE_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","These are the sons of Shem: Elam and Asshur and Arpachshad and Lud and Aram. ");
INSERT INTO engBBE_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","And the sons of Aram: Uz and Hul and Gether and Mash. ");
INSERT INTO engBBE_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","And Arpachshad became the father of Shelah; and Shelah became the father of Eber. ");
INSERT INTO engBBE_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","And Eber had two sons: the name of the one was Peleg, because in his time the peoples of the earth became separate; and his brother's name was Joktan. ");
INSERT INTO engBBE_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","And Joktan was the father of Almodad and Sheleph and Hazarmaveth and Jerah ");
INSERT INTO engBBE_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","And Hadoram and Uzal and Diklah ");
INSERT INTO engBBE_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","And Obal and Abimael and Sheba ");
INSERT INTO engBBE_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","And Ophir and Havilah and Jobab; all these were the sons of Joktan. ");
INSERT INTO engBBE_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","And their country was from Mesha, in the direction of Sephar, the mountain of the east. ");
INSERT INTO engBBE_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","These, with their families and their languages and their lands and their nations, are the offspring of Shem. ");
INSERT INTO engBBE_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","These are the families of the sons of Noah, in the order of their generations and their nations: from these came all the nations of the earth after the great flow of waters. ");
INSERT INTO engBBE_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","And all the earth had one language and one tongue. ");
INSERT INTO engBBE_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","And it came about that in their wandering from the east, they came to a stretch of flat country in the land of Shinar, and there they made their living-place. ");
INSERT INTO engBBE_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","And they said one to another, Come, let us make bricks, burning them well. And they had bricks for stone, putting them together with sticky earth. ");
INSERT INTO engBBE_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","And they said, Come, let us make a town, and a tower whose top will go up as high as heaven; and let us make a great name for ourselves, so that we may not be wanderers over the face of the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","And the Lord came down to see the town and the tower which the children of men were building. ");
INSERT INTO engBBE_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","And the Lord said, See, they are all one people and have all one language; and this is only the start of what they may do: and now it will not be possible to keep them from any purpose of theirs. ");
INSERT INTO engBBE_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Come, let us go down and take away the sense of their language, so that they will not be able to make themselves clear to one another. ");
INSERT INTO engBBE_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","So the Lord God sent them away into every part of the earth: and they gave up building their town. ");
INSERT INTO engBBE_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","So it was named Babel, because there the Lord took away the sense of all languages and from there the Lord sent them away over all the face of the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","These are the generations of Shem. Shem was a hundred years old when he became the father of Arpachshad, two years after the great flow of waters; ");
INSERT INTO engBBE_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","And after the birth of Arpachshad, Shem went on living for five hundred years, and had sons and daughters: ");
INSERT INTO engBBE_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","And Arpachshad was thirty-five years old when he became the father of Shelah: ");
INSERT INTO engBBE_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","And after the birth of Shelah, Arpachshad went on living for four hundred and three years, and had sons and daughters: ");
INSERT INTO engBBE_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","And Shelah was thirty years old when he became the father of Eber: ");
INSERT INTO engBBE_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","And after the birth of Eber, Shelah went on living for four hundred and three years, and had sons and daughters: ");
INSERT INTO engBBE_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","And Eber was thirty-four years old when he became the father of Peleg: ");
INSERT INTO engBBE_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","And after the birth of Peleg, Eber went on living for four hundred and thirty years, and had sons and daughters: ");
INSERT INTO engBBE_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","And Peleg was thirty years old when he became the father of Reu: ");
INSERT INTO engBBE_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","And after the birth of Reu, Peleg went on living for two hundred and nine years, and had sons and daughters: ");
INSERT INTO engBBE_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","And Reu was thirty-two years old when he became the father of Serug: ");
INSERT INTO engBBE_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","And after the birth of Serug, Reu went on living for two hundred and seven years, and had sons and daughters: ");
INSERT INTO engBBE_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","And Serug was thirty years old when he became the father of Nahor: ");
INSERT INTO engBBE_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","And after the birth of Nahor, Serug went on living for two hundred years, and had sons and daughters: ");
INSERT INTO engBBE_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","And Nahor was twenty-nine years old when he became the father of Terah: ");
INSERT INTO engBBE_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","And after the birth of Terah, Nahor went on living for a hundred and nineteen years, and had sons and daughters: ");
INSERT INTO engBBE_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","And Terah was seventy years old when he became the father of Abram, Nahor, and Haran. ");
INSERT INTO engBBE_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","These are the generations of Terah: Terah was the father of Abram, Nahor, and Haran; and Haran was the father of Lot. ");
INSERT INTO engBBE_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","And death came to Haran when he was with his father Terah in the land of his birth, Ur of the Chaldees. ");
INSERT INTO engBBE_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","And Abram and Nahor took wives for themselves: the name of Abram's wife was Sarai, and the name of Nahor's wife was Milcah, the daughter of Haran, the father of Milcah and Iscah. ");
INSERT INTO engBBE_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","And Sarai had no child. ");
INSERT INTO engBBE_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","And Terah took Abram, his son, and Lot, the son of Haran, and Sarai, his daughter-in-law, the wife of his son Abram and they went out from Ur of the Chaldees, to go to the land of Canaan; and they came to Haran, and were there for some time. ");
INSERT INTO engBBE_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","And all the years of Terah's life were two hundred and five: and Terah came to his end in Haran. ");
INSERT INTO engBBE_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Now the Lord said to Abram, Go out from your country and from your family and from your father's house, into the land to which I will be your guide: ");
INSERT INTO engBBE_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","And I will make of you a great nation, blessing you and making your name great; and you will be a blessing: ");
INSERT INTO engBBE_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","To them who are good to you will I give blessing, and on him who does you wrong will I put my curse: and you will become a name of blessing to all the families of the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","So Abram went as the Lord had said to him, and Lot went with him: Abram was seventy-five years old when he went away from Haran. ");
INSERT INTO engBBE_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","And Abram took Sarai, his wife, and Lot, his brother's son, and all their goods and the servants which they had got in Haran, and they went out to go to the land of Canaan. ");
INSERT INTO engBBE_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","And Abram went through the land till he came to Shechem, to the holy tree of Moreh. At that time, the Canaanites were still living in the land. ");
INSERT INTO engBBE_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","And the Lord came to Abram, and said, I will give all this land to your seed; then Abram made an altar there to the Lord who had let himself be seen by him. ");
INSERT INTO engBBE_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","And moving on from there to the mountain on the east of Beth-el, he put up his tent, having Beth-el on the west and Ai on the east: and there he made an altar and gave worship to the name of the Lord. ");
INSERT INTO engBBE_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","And he went on, journeying still to the South. ");
INSERT INTO engBBE_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","And because there was little food to be had in that land, he went down into Egypt. ");
INSERT INTO engBBE_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Now when he came near to Egypt, he said to Sarai, his wife, Truly, you are a fair woman and beautiful to the eye; ");
INSERT INTO engBBE_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","And I am certain that when the men of Egypt see you, they will say, This is his wife: and they will put me to death and keep you. ");
INSERT INTO engBBE_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Say, then, that you are my sister, and so it will be well with me because of you, and my life will be kept safe on your account. ");
INSERT INTO engBBE_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","And so it was that when Abram came into Egypt, the men of Egypt, looking on the woman, saw that she was fair. ");
INSERT INTO engBBE_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","And Pharaoh's great men, having seen her, said words in praise of her to Pharaoh, and she was taken into Pharaoh's house. ");
INSERT INTO engBBE_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","And because of her, he was good to Abram, and he had sheep and oxen and asses, and men-servants and women-servants, and camels. ");
INSERT INTO engBBE_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","And the Lord sent great troubles on Pharaoh's house because of Sarai, Abram's wife. ");
INSERT INTO engBBE_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Then Pharaoh sent for Abram, and said, What have you done to me? why did you not say that she was your wife? ");
INSERT INTO engBBE_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Why did you say that she was your sister? so that I took her for my wife: now, take your wife and go on your way. ");
INSERT INTO engBBE_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","And Pharaoh gave orders to his men, and they sent him on his way, with his wife and all he had. ");
INSERT INTO engBBE_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","And Abram went up out of Egypt with his wife and all he had, and Lot with him, and they came in to the South. ");
INSERT INTO engBBE_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Now Abram had great wealth of cattle and silver and gold. ");
INSERT INTO engBBE_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","And travelling on from the South, he came to Beth-el, to the place where his tent had been before, between Beth-el and Ai; ");
INSERT INTO engBBE_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","To the place where he had made his first altar, and there Abram gave worship to the name of the Lord. ");
INSERT INTO engBBE_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","And Lot, who went with him, had flocks and herds and tents; ");
INSERT INTO engBBE_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","So that the land was not wide enough for the two of them: their property was so great that there was not room for them together. ");
INSERT INTO engBBE_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","And there was an argument between the keepers of Abram's cattle and the keepers of Lot's cattle: at that time the Canaanites and Perizzites were still living in the land. ");
INSERT INTO engBBE_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Then Abram said to Lot, Let there be no argument between me and you, and between my herdmen and your herdmen, for we are brothers. ");
INSERT INTO engBBE_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Is not all the land before you? then let us go our separate ways: if you go to the left, I will go to the right; or if you take the right, I will go to the left. ");
INSERT INTO engBBE_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","And Lot, lifting up his eyes and looking an the valley of Jordan, saw that it was well watered everywhere, before the Lord had sent destruction on Sodom and Gomorrah; it was like the garden of the Lord, like the land of Egypt, on the way to Zoar. ");
INSERT INTO engBBE_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","So Lot took for himself all the valley of Jordan, and went to the east, and they were parted from one another. ");
INSERT INTO engBBE_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram went on living in the land of Canaan, and Lot went to the lowland towns, moving his tent as far as Sodom. ");
INSERT INTO engBBE_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Now the men of Sodom were evil, and great sinners before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","And the Lord had said to Abram, after Lot was parted from him, From this place where you are take a look to the north and to the south, to the east and to the west: ");
INSERT INTO engBBE_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","For all the land which you see I will give to you and to your seed for ever. ");
INSERT INTO engBBE_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","And I will make your children like the dust of the earth, so that if the dust of the earth may be numbered, then will your children be numbered. ");
INSERT INTO engBBE_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Come, go through all the land from one end to the other for I will give it to you. ");
INSERT INTO engBBE_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","And Abram, moving his tent, came and made his living-place by the holy tree of Mamre, which is in Hebron, and made an altar there to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Now in the days of Amraphel, king of Shinar, Arioch, king of Ellasar, Chedorlaomer, king of Elam, and Tidal, king of Goiim, ");
INSERT INTO engBBE_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","They made war with Bera, king of Sodom, and with Birsha, king of Gomorrah, Shinab, king of Admah, and Shemeber, king of Zeboiim, and the king of Bela (which is Zoar). ");
INSERT INTO engBBE_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","All these came together in the valley of Siddim (which is the Salt Sea). ");
INSERT INTO engBBE_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","For twelve years they were under the rule of Chedorlaomer, but in the thirteenth year they put off his control. ");
INSERT INTO engBBE_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","And in the fourteenth year, Chedorlaomer and the kings who were on his side, overcame the Rephaim in Ashteroth-karnaim, and the Zuzim in Ham, and the Emim in Shaveh-kiriathaim, ");
INSERT INTO engBBE_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","And the Horites in their mountain Seir, driving them as far as El-paran, which is near the waste land. ");
INSERT INTO engBBE_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Then they came back to En-mishpat (which is Kadesh), making waste all the country of the Amalekites and of the Amorites living in Hazazon-tamar. ");
INSERT INTO engBBE_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","And the king of Sodom with the king of Gomorrah and the king of Admah and the king of Zeboiim and the king of Bela (that is Zoar), went out, and put their forces in position in the valley of Siddim, ");
INSERT INTO engBBE_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Against Chedorlaomer, king of Elam, and Tidal, king of Goiim, and Amraphel, king of Shinar, and Arioch, king of Ellasar: four kings against the five. ");
INSERT INTO engBBE_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Now the valley of Siddim was full of holes of sticky earth; and the kings of Sodom and Gomorrah were put to flight and came to their end there, but the rest got away to the mountain. ");
INSERT INTO engBBE_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","And the four kings took all the goods and food from Sodom and Gomorrah and went on their way. ");
INSERT INTO engBBE_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","And in addition they took Lot, Abram's brother's son, who was living in Sodom, and all his goods. ");
INSERT INTO engBBE_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","And one who had got away from the fight came and gave word of it to Abram the Hebrew, who was living by the holy tree of Mamre, the Amorite, the brother of Eshcol and Aner, who were friends of Abram. ");
INSERT INTO engBBE_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","And Abram, hearing that his brother's son had been made a prisoner, took a band of his trained men, three hundred and eighteen of them, sons of his house, and went after them as far as Dan. ");
INSERT INTO engBBE_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","And separating his forces by night, he overcame them, putting them to flight and going after them as far as Hobah, which is on the north side of Damascus. ");
INSERT INTO engBBE_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","And he got back all the goods, and Lot, his brother's son, with his goods and the women and the people. ");
INSERT INTO engBBE_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","And when he was coming back after putting to flight Chedorlaomer and the other kings, he had a meeting with the king of Sodom in the valley of Shaveh, that is, the King's Valley. ");
INSERT INTO engBBE_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","And Melchizedek, king of Salem, the priest of the Most High God, took bread and wine, ");
INSERT INTO engBBE_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","And blessing him, said, May the blessing of the Most High God, maker of heaven and earth, be on Abram: ");
INSERT INTO engBBE_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","And let the Most High God be praised, who has given into your hands those who were against you. Then Abram gave him a tenth of all the goods he had taken. ");
INSERT INTO engBBE_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","And the king of Sodom said to Abram, Give me the prisoners and take the goods for yourself. ");
INSERT INTO engBBE_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","But Abram said to the king of Sodom, I have taken an oath to the Lord, the Most High God, maker of heaven and earth, ");
INSERT INTO engBBE_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","That I will not take so much as a thread or the cord of a shoe of yours; so that you may not say, I have given wealth to Abram: ");
INSERT INTO engBBE_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Give me nothing but the food which the fighting-men who went with me have had; but let Aner and Eshcol and Mamre have their part of the goods. ");
INSERT INTO engBBE_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","After these things, the word of the Lord came to Abram in a vision, saying, Have no fear, Abram: I will keep you safe, and great will be your reward. ");
INSERT INTO engBBE_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","And Abram said, What will you give me? for I have no child and this Eliezer of Damascus will have all my wealth after me. ");
INSERT INTO engBBE_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","And Abram said, You have given me no child, and a servant in my house will get the heritage. ");
INSERT INTO engBBE_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Then said the Lord, This man will not get the heritage, but a son of your body will have your property after you. ");
INSERT INTO engBBE_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","And he took him out into the open air, and said to him, Let your eyes be lifted to heaven, and see if the stars may be numbered; even so will your seed be. ");
INSERT INTO engBBE_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","And he had faith in the Lord, and it was put to his account as righteousness. ");
INSERT INTO engBBE_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","And he said to him, I am the Lord, who took you from Ur of the Chaldees, to give you this land for your heritage. ");
INSERT INTO engBBE_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","And he said, O Lord God, how may I be certain that it will be mine? ");
INSERT INTO engBBE_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","And he said, Take a young cow of three years old, and a she-goat of three years old, and a sheep of three years old, and a dove and a young pigeon. ");
INSERT INTO engBBE_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","All these he took, cutting them in two and putting one half opposite the other, but not cutting the birds in two. ");
INSERT INTO engBBE_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","And evil birds came down on the bodies, but Abram sent them away. ");
INSERT INTO engBBE_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Now when the sun was going down, a deep sleep came on Abram, and a dark cloud of fear. ");
INSERT INTO engBBE_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","And he said to Abram, Truly, your seed will be living in a land which is not theirs, as servants to a people who will be cruel to them for four hundred years; ");
INSERT INTO engBBE_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","But I will be the judge of that nation whose servants they are, and they will come out from among them with great wealth. ");
INSERT INTO engBBE_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","As for you, you will go to your fathers in peace; at the end of a long life you will be put in your last resting-place. ");
INSERT INTO engBBE_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","And in the fourth generation they will come back here; for at present the sin of the Amorite is not full. ");
INSERT INTO engBBE_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Then when the sun went down and it was dark, he saw a smoking fire and a flaming light which went between the parts of the bodies. ");
INSERT INTO engBBE_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","In that day the Lord made an agreement with Abram, and said, To your seed have I given this land from the river of Egypt to the great river, the river Euphrates: ");
INSERT INTO engBBE_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","The Kenite, the Kenizzite, and the Kadmonite, ");
INSERT INTO engBBE_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","And the Hittite, and the Perizzite, and the Rephaim, ");
INSERT INTO engBBE_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","And the Amorite, and the Canaanite, and the Girgashite, and the Jebusite. ");
INSERT INTO engBBE_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Now Sarai, Abram's wife, had given him no children; and she had a servant, a woman of Egypt whose name was Hagar. ");
INSERT INTO engBBE_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","And Sarai said to Abram, See, the Lord has not let me have children; go in to my servant, for I may get a family through her. And Abram did as Sarai said. ");
INSERT INTO engBBE_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","So after Abram had been living for ten years in the land of Canaan, Sarai took Hagar, her Egyptian servant, and gave her to Abram for his wife. ");
INSERT INTO engBBE_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","And he went in to Hagar and she became with child, and when she saw that she was with child, she no longer had any respect for her master's wife. ");
INSERT INTO engBBE_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","And Sarai said to Abram, May my wrong be on you: I gave you my servant for your wife and when she saw that she was with child, she no longer had any respect for me: may the Lord be judge between you and me. ");
INSERT INTO engBBE_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","And Abram said, The woman is in your power; do with her whatever seems good to you. And Sarai was cruel to her, so that she went running away from her. ");
INSERT INTO engBBE_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","And an angel of the Lord came to her by a fountain of water in the waste land, by the fountain on the way to Shur. ");
INSERT INTO engBBE_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","And he said, Hagar, Sarai's servant, where have you come from and where are you going? And she said, I am running away from Sarai, my master's wife. ");
INSERT INTO engBBE_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","And the angel said to her, Go back, and put yourself under her authority. ");
INSERT INTO engBBE_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","And the angel of the Lord said, Your seed will be greatly increased so that it may not be numbered. ");
INSERT INTO engBBE_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","And the angel of the Lord said, See, you are with child and will give birth to a son, to whom you will give the name Ishmael, because the ears of the Lord were open to your sorrow. ");
INSERT INTO engBBE_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","And he will be like a mountain ass among men; his hand will be against every man and every man's hand against him, and he will keep his place against all his brothers. ");
INSERT INTO engBBE_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","And to the Lord who was talking with her she gave this name, You are a God who is seen; for she said, Have I not even here in the waste land had a vision of God and am still living? ");
INSERT INTO engBBE_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","So that fountain was named, Fountain of Life and Vision: it is between Kadesh and Bered. ");
INSERT INTO engBBE_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","And Hagar gave birth to a child, the son of Abram, to whom Abram gave the name of Ishmael. ");
INSERT INTO engBBE_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram was eighty-six years old when Hagar gave birth to Ishmael. ");
INSERT INTO engBBE_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","When Abram was ninety-nine years old, the Lord came to him, and said, I am God, Ruler of all; go in my ways and be upright in all things, ");
INSERT INTO engBBE_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","And I will make an agreement between you and me, and your offspring will be greatly increased. ");
INSERT INTO engBBE_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","And Abram went down on his face on the earth, and the Lord God went on talking with him, and said, ");
INSERT INTO engBBE_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","As for me, my agreement is made with you, and you will be the father of nations without end. ");
INSERT INTO engBBE_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","No longer will your name be Abram, but Abraham, for I have made you the father of a number of nations. ");
INSERT INTO engBBE_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","I will make you very fertile, so that nations will come from you and kings will be your offspring. ");
INSERT INTO engBBE_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","And I will make between me and you and your seed after you through all generations, an eternal agreement to be a God to you and to your seed after you. ");
INSERT INTO engBBE_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","And to you and to your seed after you, I will give the land in which you are living, all the land of Canaan for an eternal heritage; and I will be their God. ");
INSERT INTO engBBE_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","And God said to Abraham, On your side, you are to keep the agreement, you and your seed after you through all generations. ");
INSERT INTO engBBE_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","And this is the agreement which you are to keep with me, you and your seed after you: every male among you is to undergo circumcision. ");
INSERT INTO engBBE_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","In the flesh of your private parts you are to undergo it, as a mark of the agreement between me and you. ");
INSERT INTO engBBE_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Every male among you, from one generation to another, is to undergo circumcision when he is eight days old, with every servant whose birth takes place in your house, or for whom you gave money to someone of another country, and not of your seed. ");
INSERT INTO engBBE_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","He who comes to birth in your house and he who is made yours for a price, all are to undergo circumcision; so that my agreement may be marked in your flesh, an agreement for all time. ");
INSERT INTO engBBE_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","And any male who does not undergo circumcision will be cut off from his people: my agreement has been broken by him. ");
INSERT INTO engBBE_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","And God said, As for Sarai, your wife, from now her name will be not Sarai, but Sarah. ");
INSERT INTO engBBE_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","And I will give her a blessing so that you will have a son by her: truly my blessing will be on her, and she will be the mother of nations: kings of peoples will be her offspring. ");
INSERT INTO engBBE_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Then Abraham went down on his face, and laughing, said in his heart, May a man a hundred years old have a child? will Sarah, at ninety years old, give birth? ");
INSERT INTO engBBE_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","And Abraham said to God, If only Ishmael's life might be your care! ");
INSERT INTO engBBE_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","And God said, Not so; but Sarah, your wife, will have a son, and you will give him the name Isaac, and I will make my agreement with him for ever and with his seed after him. ");
INSERT INTO engBBE_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","As for Ishmael, I have given ear to your prayer: truly I have given him my blessing and I will make him fertile and give him great increase; he will be the father of twelve chiefs, and I will make him a great nation. ");
INSERT INTO engBBE_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","But my agreement will be with Isaac, to whom Sarah will give birth a year from this time. ");
INSERT INTO engBBE_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","And having said these words, God went up from Abraham. ");
INSERT INTO engBBE_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","And Abraham took Ishmael, his son, and all whose birth had taken place in his house, and all his servants whom he had made his for a price, every male of his house, and on that very day he gave them circumcision in the flesh of their private parts as God had said to him. ");
INSERT INTO engBBE_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham was ninety-nine years old when he underwent circumcision. ");
INSERT INTO engBBE_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","And Ishmael, his son, was thirteen years old when he underwent circumcision. ");
INSERT INTO engBBE_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abraham and Ishmael, his son, underwent circumcision on that very day. ");
INSERT INTO engBBE_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","And all the men of his house, those whose birth had taken place in the house and those whom he had got for money from men of other lands, underwent circumcision with him. ");
INSERT INTO engBBE_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Now the Lord came to him by the holy tree of Mamre, when he was seated in the doorway of his tent in the middle of the day; ");
INSERT INTO engBBE_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","And lifting up his eyes, he saw three men before him; and seeing them, he went quickly to them from the door of the tent, and went down on his face to the earth; ");
INSERT INTO engBBE_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","And said, My Lord, if now I have grace in your eyes, do not go away from your servant: ");
INSERT INTO engBBE_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Let me get water for washing your feet, and take your rest under the tree: ");
INSERT INTO engBBE_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","And let me get a bit of bread to keep up your strength, and after that you may go on your way: for this is why you have come to your servant. And they said, Let it be so. ");
INSERT INTO engBBE_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Then Abraham went quickly into the tent, and said to Sarah, Get three measures of meal straight away and make cakes. ");
INSERT INTO engBBE_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","And running to the herd, he took a young ox, soft and fat, and gave it to the servant and he quickly made it ready; ");
INSERT INTO engBBE_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","And he took butter and milk and the young ox which he had made ready and put it before them, waiting by them under the tree while they took food. ");
INSERT INTO engBBE_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","And they said to him, Where is Sarah your wife? And he said, She is in the tent. ");
INSERT INTO engBBE_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","And he said, I will certainly come back to you in the spring, and Sarah your wife will have a son. And his words came to the ears of Sarah who was at the back of the tent-door. ");
INSERT INTO engBBE_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Now Abraham and Sarah were very old, and Sarah was past the time for giving birth. ");
INSERT INTO engBBE_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","And Sarah, laughing to herself, said, Now that I am used up am I still to have pleasure, my husband himself being old? ");
INSERT INTO engBBE_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","And the Lord said, Why was Sarah laughing and saying, Is it possible for me, being old, to give birth to a child? ");
INSERT INTO engBBE_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Is there any wonder which the Lord is not able to do? At the time I said, in the spring, I will come back to you, and Sarah will have a child. ");
INSERT INTO engBBE_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Then Sarah said, I was not laughing; for she was full of fear. And he said, No, but you were laughing. ");
INSERT INTO engBBE_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","And the men went on from there in the direction of Sodom; and Abraham went with them on their way. ");
INSERT INTO engBBE_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","And the Lord said, Am I to keep back from Abraham the knowledge of what I do; ");
INSERT INTO engBBE_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Seeing that Abraham will certainly become a great and strong nation, and his name will be used by all the nations of the earth as a blessing? ");
INSERT INTO engBBE_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","For I have made him mine so that he may give orders to his children and those of his line after him, to keep the ways of the Lord, to do what is good and right: so that the Lord may do to Abraham as he has said. ");
INSERT INTO engBBE_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","And the Lord said, Because the outcry against Sodom and Gomorrah is very great, and their sin is very evil, ");
INSERT INTO engBBE_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","I will go down now, and see if their acts are as bad as they seem from the outcry which has come to me; and if they are not, I will see. ");
INSERT INTO engBBE_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","And the men, turning from that place, went on to Sodom: but Abraham was still waiting before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","And Abraham came near, and said, Will you let destruction come on the upright with the sinners? ");
INSERT INTO engBBE_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","If by chance there are fifty upright men in the town, will you give the place to destruction and not have mercy on it because of the fifty upright men? ");
INSERT INTO engBBE_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Let such a thing be far from you, to put the upright to death with the sinner: will not the judge of all the earth do right? ");
INSERT INTO engBBE_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","And the Lord said, If there are fifty upright men in the town, I will have mercy on it because of them. ");
INSERT INTO engBBE_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","And Abraham answering said, Truly, I who am only dust, have undertaken to put my thoughts before the Lord: ");
INSERT INTO engBBE_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","If by chance there are five less than fifty upright men, will you give up all the town to destruction because of these five? And he said, I will not give it to destruction if there are forty-five. ");
INSERT INTO engBBE_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","And again he said to him, By chance there may be forty there. And he said, I will not do it if there are forty. ");
INSERT INTO engBBE_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","And he said, Let not the Lord be angry with me if I say, What if there are thirty there? And he said, I will not do it if there are thirty. ");
INSERT INTO engBBE_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","And he said, See now, I have undertaken to put my thoughts before the Lord: what if there are twenty there? And he said, I will have mercy because of the twenty. ");
INSERT INTO engBBE_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","And he said, O let not the Lord be angry and I will say only one word more: by chance there may be ten there. And he said, I will have mercy because of the ten. ");
INSERT INTO engBBE_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","And the Lord went on his way when his talk with Abraham was ended, and Abraham went back to his place. ");
INSERT INTO engBBE_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","And at nightfall the two angels came to Sodom; and Lot was seated at the way into the town: and when he saw them he got up and came before them, falling down on his face to the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","And he said, My masters, come now into your servant's house and take your rest there for the night, and let your feet be washed; and early in the morning you may go on your way. And they said, Not so, but we will take our night's rest in the street. ");
INSERT INTO engBBE_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","But he made his request more strongly, so they went with him into his house; and he got food ready for them, and made unleavened bread, of which they took. ");
INSERT INTO engBBE_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","But before they had gone to bed, the men of the town, all the men of Sodom, came round the house, young and old, from every part of the town; ");
INSERT INTO engBBE_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","And crying out to Lot, they said, Where are the men who came to your house this night? Send them out to us, so that we may take our pleasure with them. ");
INSERT INTO engBBE_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","And Lot went out to them in the doorway, shutting the door after him. ");
INSERT INTO engBBE_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","And he said, My brothers, do not this evil. ");
INSERT INTO engBBE_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","See now, I have two unmarried daughters; I will send them out to you so that you may do to them whatever seems good to you: only do nothing to these men, for this is why they have come under the shade of my roof. ");
INSERT INTO engBBE_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","And they said, Give way there. This one man, they said, came here from a strange country, and will he now be our judge? now we will do worse to you than to them; and pushing violently against Lot, they came near to get the door broken in. ");
INSERT INTO engBBE_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","But the men put out their hands and took Lot into the house to them, shutting the door again. ");
INSERT INTO engBBE_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","But the men who were outside the door they made blind, all of them, small and great, so that they were tired out with looking for the door. ");
INSERT INTO engBBE_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Then the men said to Lot, Are there any others of your family here? sons-in-law or sons or daughters, take them all out of this place; ");
INSERT INTO engBBE_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","For we are about to send destruction on this place, because a great outcry against them has come to the ears of the Lord; and the Lord has sent us to put an end to the town. ");
INSERT INTO engBBE_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","And Lot went out and said to his sons-in-law, who were married to his daughters, Come, let us go out of this place, for the Lord is about to send destruction on the town. But his sons-in-law did not take him seriously. ");
INSERT INTO engBBE_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","And when morning came, the angels did all in their power to make Lot go, saying, Get up quickly and take your wife and your two daughters who are here, and go, for fear that you come to destruction in the punishment of the town. ");
INSERT INTO engBBE_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","But while he was waiting, the men took him and his wife and his daughters by the hand, for the Lord had mercy on them, and put them outside the town. ");
INSERT INTO engBBE_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","And when they had put them out, he said, Go for your life, without looking back or waiting in the lowland; go quickly to the mountain or you will come to destruction. ");
INSERT INTO engBBE_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","And Lot said to them, Not so, O my Lord; ");
INSERT INTO engBBE_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","See now, your servant has had grace in your eyes and great is your mercy in keeping my life from destruction, but I am not able to get as far as the mountain before evil overtakes me and death; ");
INSERT INTO engBBE_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","This town, now, is near, and it is a little one: O, let me go there (is it not a little one?) so that my life may be safe. ");
INSERT INTO engBBE_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","And he said, See, I have given you your request in this one thing more: I will not send destruction on this town. ");
INSERT INTO engBBE_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Go there quickly, for I am not able to do anything till you have come there. For this reason, the town was named Zoar. ");
INSERT INTO engBBE_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","The sun was up when Lot came to Zoar. ");
INSERT INTO engBBE_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Then the Lord sent fire and flaming smoke raining down from heaven on Sodom and Gomorrah. ");
INSERT INTO engBBE_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","And he sent destruction on those towns, with all the lowland and all the people of those towns and every green thing in the land. ");
INSERT INTO engBBE_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","But Lot's wife, looking back, became a pillar of salt. ");
INSERT INTO engBBE_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","And Abraham got up early in the morning and went to the place where he had been talking with the Lord: ");
INSERT INTO engBBE_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","And looking in the direction of Sodom and Gomorrah and the lowland, he saw the smoke of the land going up like the smoke of an oven. ");
INSERT INTO engBBE_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","So it came about that when God sent destruction on the towns of the lowland, he kept his word to Abraham, and sent Lot safely away when he put an end to the towns where he was living. ");
INSERT INTO engBBE_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Then Lot went up out of Zoar to the mountain, and was living there with his two daughters, for fear kept him from living in Zoar: and he and his daughters made their living-place in a hole in the rock. ");
INSERT INTO engBBE_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","And the older daughter said to her sister, Our father is old, and there is no man to be a husband to us in the natural way: ");
INSERT INTO engBBE_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Come, let us give our father much wine, and we will go into his bed, so that we may have offspring by our father, ");
INSERT INTO engBBE_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","And that night they made their father take much wine; and the older daughter went into his bed; and he had no knowledge of when she went in or when she went away. ");
INSERT INTO engBBE_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","And on the day after, the older daughter said to the younger, Last night I was with my father; let us make him take much wine this night again, and do you go to him, so that we may have offspring by our father. ");
INSERT INTO engBBE_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","And that night again they made their father take much wine; and the younger daughter went into his bed; and he had no knowledge of when she went in or when she went away. ");
INSERT INTO engBBE_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","And so the two daughters of Lot were with child by their father. ");
INSERT INTO engBBE_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","And the older daughter had a son, and she gave him the name Moab: he is the father of the Moabites to this day. ");
INSERT INTO engBBE_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","And the younger had a son and gave him the name Ben-ammi: from him come the children of Ammon to this day. ");
INSERT INTO engBBE_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","And Abraham went on his way from there to the land of the South, and was living between Kadesh and Shur, in Gerar. ");
INSERT INTO engBBE_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","And Abraham said of Sarah, his wife, She is my sister: and Abimelech, king of Gerar, sent and took Sarah. ");
INSERT INTO engBBE_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","But God came to Abimelech in a dream in the night, and said to him, Truly you are a dead man because of the woman whom you have taken; for she is a man's wife. ");
INSERT INTO engBBE_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Now Abimelech had not come near her; and he said, Lord, will you put to death an upright nation? ");
INSERT INTO engBBE_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Did he not say to me himself, She is my sister? and she herself said, He is my brother: with an upright heart and clean hands have I done this. ");
INSERT INTO engBBE_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","And God said to him in the dream, I see that you have done this with an upright heart, and I have kept you from sinning against me: for this reason I did not let you come near her. ");
INSERT INTO engBBE_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","So now, give the man back his wife, for he is a prophet, and let him say a prayer for you, so your life may be safe: but if you do not give her back, be certain that death will come to you and all your house. ");
INSERT INTO engBBE_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","So Abimelech got up early in the morning and sent for all his servants and gave them word of these things, and they were full of fear. ");
INSERT INTO engBBE_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Then Abimelech sent for Abraham, and said, What have you done to us? what wrong have I done you that you have put on me and on my kingdom so great a sin? You have done to me things which are not to be done. ");
INSERT INTO engBBE_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","And Abimelech said to Abraham, Why did you do this thing? ");
INSERT INTO engBBE_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","And Abraham said, Because it seemed to me that there was no fear of God in this place, and that they might put me to death because of my wife. ");
INSERT INTO engBBE_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","And, in fact, she is my sister, the daughter of my father, but not the daughter of my mother; and she became my wife: ");
INSERT INTO engBBE_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","And when God sent me wandering from my father's house, I said to her, Let this be the sign of your love for me; wherever we go, say of me, He is my brother. ");
INSERT INTO engBBE_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Then Abimelech gave to Abraham sheep and oxen and men-servants and women-servants, and gave him back his wife Sarah. ");
INSERT INTO engBBE_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","And Abimelech said, See, all my land is before you; take whatever place seems good to you. ");
INSERT INTO engBBE_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","And he said to Sarah, See, I have given to your brother a thousand bits of silver so that your wrong may be put right; now your honour is clear in the eyes of all. ");
INSERT INTO engBBE_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Then Abraham made prayer to God, and God made Abimelech well again, and his wife and his women-servants, so that they had children. ");
INSERT INTO engBBE_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","For the Lord had kept all the women of the house of Abimelech from having children, because of Sarah, Abraham's wife. ");
INSERT INTO engBBE_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","And the Lord came to Sarah as he had said and did to her as he had undertaken. ");
INSERT INTO engBBE_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","And Sarah became with child, and gave Abraham a son when he was old, at the time named by God. ");
INSERT INTO engBBE_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","And Abraham gave to his son, to whom Sarah had given birth, the name Isaac. ");
INSERT INTO engBBE_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","And when his son Isaac was eight days old, Abraham made him undergo circumcision, as God had said to him. ");
INSERT INTO engBBE_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Now Abraham was a hundred years old when the birth of Isaac took place. ");
INSERT INTO engBBE_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","And Sarah said, God has given me cause for laughing, and everyone who has news of it will be laughing with me. ");
INSERT INTO engBBE_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","And she said, Who would have said to Abraham that Sarah would have a child at her breast? for see, I have given him a son now when he is old. ");
INSERT INTO engBBE_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","And when the child was old enough to be taken from the breast, Abraham made a great feast. ");
INSERT INTO engBBE_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","And Sarah saw the son of Hagar the Egyptian playing with Isaac. ");
INSERT INTO engBBE_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","So she said to Abraham, Send away that woman and her son: for the son of that woman is not to have a part in the heritage with my son Isaac. ");
INSERT INTO engBBE_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","And this was a great grief to Abraham because of his son. ");
INSERT INTO engBBE_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","But God said, Let it not be a grief to you because of the boy and Hagar his mother; give ear to whatever Sarah says to you, because it is from Isaac that your seed will take its name. ");
INSERT INTO engBBE_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","And I will make a nation of the son of your servant-woman, because he is your seed. ");
INSERT INTO engBBE_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","And early in the morning Abraham got up, and gave Hagar some bread and a water-skin, and put the boy on her back, and sent her away: and she went, wandering in the waste land of Beer-sheba. ");
INSERT INTO engBBE_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","And when all the water in the skin was used up, she put the child down under a tree. ");
INSERT INTO engBBE_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","And she went some distance away, about an arrow flight, and seating herself on the earth, she gave way to bitter weeping, saying, Let me not see the death of my child. ");
INSERT INTO engBBE_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","And the boy's cry came to the ears of God; and the angel of God said to Hagar from heaven, Hagar, why are you weeping? have no fear, for the child's cry has come to the ears of God. ");
INSERT INTO engBBE_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Come, take your child in your arms, for I will make of him a great nation. ");
INSERT INTO engBBE_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Then God made her eyes open, and she saw a water-spring, and she got water in the skin and gave the boy a drink. ");
INSERT INTO engBBE_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","And God was with the boy, and he became tall and strong, and he became a bowman, living in the waste land. ");
INSERT INTO engBBE_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","And while he was in the waste land of Paran, his mother got him a wife from the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Now at that time, Abimelech and Phicol, the captain of his army, said to Abraham, I see that God is with you in all you do. ");
INSERT INTO engBBE_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Now, then, give me your oath, in the name of God, that you will not be false to me or to my sons after me, but that as I have been good to you, so you will be to me and to this land where you have been living. ");
INSERT INTO engBBE_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","And Abraham said, I will give you my oath. ");
INSERT INTO engBBE_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","But Abraham made a protest to Abimelech because of a water-hole which Abimelech's servants had taken by force. ");
INSERT INTO engBBE_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","But Abimelech said, I have no idea who has done this thing; you never gave me word of it, and I had no knowledge of it till this day. ");
INSERT INTO engBBE_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","And Abraham took sheep and oxen and gave them to Abimelech, and the two of them made an agreement together. ");
INSERT INTO engBBE_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","And Abraham put seven young lambs of the flock on one side by themselves. ");
INSERT INTO engBBE_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Then Abimelech said, What are these seven lambs which you have put on one side? ");
INSERT INTO engBBE_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","And he said, Take these seven lambs from me as a witness that I have made this water-hole. ");
INSERT INTO engBBE_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","So he gave that place the name Beer-sheba, because there the two of them had given their oaths. ");
INSERT INTO engBBE_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","So they made an agreement at Beer-sheba, and Abimelech and Phicol, the captain of his army, went back to the land of the Philistines. ");
INSERT INTO engBBE_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","And Abraham, after planting a holy tree in Beer-sheba, gave worship to the name of the Lord, the Eternal God. ");
INSERT INTO engBBE_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","And Abraham went on living in the land of the Philistines as in a strange country. ");
INSERT INTO engBBE_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Now after these things, God put Abraham to the test, and said to him, Abraham; and he said, Here am I. ");
INSERT INTO engBBE_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","And he said to him, Take your son, your dearly loved only son Isaac, and go to the land of Moriah and give him as a burned offering on one of the mountains of which I will give you knowledge. ");
INSERT INTO engBBE_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","And Abraham got up early in the morning, and made ready his ass, and took with him two of his young men and Isaac, his son, and after the wood for the burned offering had been cut, he went on his way to the place of which God had given him word. ");
INSERT INTO engBBE_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","And on the third day, Abraham, lifting up his eyes, saw the place a long way off. ");
INSERT INTO engBBE_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Then he said to his young men, Keep here with the ass; and I and the boy will go on and give worship and come back again to you. ");
INSERT INTO engBBE_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","And Abraham put the wood for the burned offering on his son's back, and he himself took the fire and the knife in his hand, and the two of them went on together. ");
INSERT INTO engBBE_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Then Isaac said to Abraham, My father; and he said, Here am I, my son. And he said, We have wood and fire here, but where is the lamb for the burned offering? ");
INSERT INTO engBBE_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","And Abraham said, God himself will give the lamb for the burned offering: so they went on together. ");
INSERT INTO engBBE_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","And they came to the place of which God had given him knowledge; and there Abraham made the altar and put the wood in place on it, and having made tight the bands round Isaac his son, he put him on the wood on the altar. ");
INSERT INTO engBBE_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","And stretching out his hand, Abraham took the knife to put his son to death. ");
INSERT INTO engBBE_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","But the voice of the angel of the Lord came from heaven, saying, Abraham, Abraham: and he said, Here am I. ");
INSERT INTO engBBE_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","And he said, Let not your hand be stretched out against the boy to do anything to him; for now I am certain that the fear of God is in your heart, because you have not kept back your son, your only son, from me. ");
INSERT INTO engBBE_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","And lifting up his eyes, Abraham saw a sheep fixed by its horns in the brushwood: and Abraham took the sheep and made a burned offering of it in place of his son. ");
INSERT INTO engBBE_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","And Abraham gave that place the name Yahweh-yireh: as it is said to this day, In the mountain the Lord is seen. ");
INSERT INTO engBBE_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","And the voice of the angel of the Lord came to Abraham a second time from heaven, ");
INSERT INTO engBBE_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Saying, I have taken an oath by my name, says the Lord, because you have done this and have not kept back from me your dearly loved only son, ");
INSERT INTO engBBE_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","That I will certainly give you my blessing, and your seed will be increased like the stars of heaven and the sand by the seaside; your seed will take the land of those who are against them; ");
INSERT INTO engBBE_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","And your seed will be a blessing to all the nations of the earth, because you have done what I gave you orders to do. ");
INSERT INTO engBBE_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Then Abraham went back to his young men and they went together to Beer-sheba, the place where Abraham was living. ");
INSERT INTO engBBE_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","After these things, Abraham had news that Milcah, the wife of his brother Nahor, had given birth to children; ");
INSERT INTO engBBE_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz the oldest, and Buz his brother, and Kemuel, the father of Aram, ");
INSERT INTO engBBE_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","And Chesed and Hazo and Pildash and Jidlaph and Bethuel. ");
INSERT INTO engBBE_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethuel was the father of Rebekah: these eight were the children of Milcah and Nahor, Abraham's brother. ");
INSERT INTO engBBE_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","And his servant Reumah gave birth to Tebah and Gaham and Tahash and Maacah. ");
INSERT INTO engBBE_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Now the years of Sarah's life were a hundred and twenty-seven. ");
INSERT INTO engBBE_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","And Sarah's death took place in Kiriath-arba, that is, Hebron, in the land of Canaan: and Abraham went into his house, weeping and sorrowing for Sarah. ");
INSERT INTO engBBE_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","And Abraham came from his dead and said to the children of Heth, ");
INSERT INTO engBBE_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","I am living among you as one from a strange country: give me some land here as my property, so that I may put my dead to rest. ");
INSERT INTO engBBE_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","And in answer the children of Heth said to Abraham, ");
INSERT INTO engBBE_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","My lord, truly you are a great chief among us; take the best of our resting-places for your dead; not one of us will keep back from you a place where you may put your dead to rest. ");
INSERT INTO engBBE_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","And Abraham got up and gave honour to the children of Heth, the people of that land. ");
INSERT INTO engBBE_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","And he said to them, If you will let me put my dead to rest here, make a request for me to Ephron, the son of Zohar, ");
INSERT INTO engBBE_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","That he will give me the hollow in the rock named Machpelah, which is his property at the end of his field; let him give it to me for its full price as a resting-place for my dead among you. ");
INSERT INTO engBBE_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Now Ephron was seated among the children of Heth: and Ephron the Hittite gave Abraham his answer in the hearing of the children of Heth, and of all those who came into his town, saying, ");
INSERT INTO engBBE_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","No, my lord, I will give you the field with the hollow in the rock; before all the children of my people will I give it to you for a resting-place for your dead. ");
INSERT INTO engBBE_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","And Abraham went down on his face before the people of the land. ");
INSERT INTO engBBE_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","And Abraham said to Ephron, in the hearing of the people of the land, If only you will give ear to me, I will give you the price of the field; take it, and let me put my dead to rest there. ");
INSERT INTO engBBE_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","So Ephron said to Abraham, ");
INSERT INTO engBBE_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","My lord, give ear to me: the value of the land is four hundred shekels; what is that between me and you? so put your dead to rest there. ");
INSERT INTO engBBE_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","And Abraham took note of the price fixed by Ephron in the hearing of the children of Heth, and gave him four hundred shekels in current money. ");
INSERT INTO engBBE_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","So Ephron's field at Machpelah near Mamre, with the hollow in the rock and all the trees in the field and round it, ");
INSERT INTO engBBE_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Became the property of Abraham before the eyes of the children of Heth and of all who came into the town. ");
INSERT INTO engBBE_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Then Abraham put Sarah his wife to rest in the hollow rock in the field of Machpelah near Mamre, that is, Hebron in the land of Canaan. ");
INSERT INTO engBBE_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","And the field and the hollow rock were handed over to Abraham as his property by the children of Heth. ");
INSERT INTO engBBE_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Now Abraham was old and far on in years: and the Lord had given him everything in full measure. ");
INSERT INTO engBBE_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","And Abraham said to his chief servant, the manager of all his property, Come now, put your hand under my leg: ");
INSERT INTO engBBE_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","And take an oath by the Lord, the God of heaven and the God of the earth, that you will not get a wife for my son Isaac from the daughters of the Canaanites among whom I am living; ");
INSERT INTO engBBE_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","But that you will go into my country and to my relations and get a wife there for my son Isaac. ");
INSERT INTO engBBE_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","And the servant said, If by chance the woman will not come with me into this land, am I to take your son back again to the land from which you came? ");
INSERT INTO engBBE_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","And Abraham said, Take care that you do not let my son go back to that land. ");
INSERT INTO engBBE_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","The Lord God of heaven, who took me from my father's house and from the land of my birth, and made an oath to me, saying, To your seed I will give this land: he will send his angel before you and give you a wife for my son in that land. ");
INSERT INTO engBBE_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","And if the woman will not come with you, then you are free from this oath; only do not take my son back there. ");
INSERT INTO engBBE_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","And the servant put his hand under Abraham's leg, and gave him his oath about this thing. ");
INSERT INTO engBBE_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","And the servant took ten of his master's camels, and all sorts of good things of his master's, and went to Mesopotamia, to the town of Nahor. ");
INSERT INTO engBBE_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","And he made the camels take their rest outside the town by the water-spring in the evening, at the time when the women came to get water. ");
INSERT INTO engBBE_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","And he said, O Lord, the God of my master Abraham, let me do well in what I have undertaken this day, and give your mercy to my master Abraham. ");
INSERT INTO engBBE_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","See, I am waiting here by the water-spring; and the daughters of the town are coming out to get water: ");
INSERT INTO engBBE_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Now, may the girl to whom I say, Let down your vessel and give me a drink, and who says in answer, Here is a drink for you and let me give water to your camels: may she be the one marked out by you for your servant Isaac: so may I be certain that you have been good to my master Abraham. ");
INSERT INTO engBBE_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","And even before his words were ended, Rebekah, the daughter of Bethuel, the son of Milcah, who was the wife of Nahor, Abraham's brother, came out with her water-vessel on her arm. ");
INSERT INTO engBBE_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","She was a very beautiful girl, a virgin, who had never been touched by a man: and she went down to the spring to get water in her vessel. ");
INSERT INTO engBBE_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","And the servant came running to her and said, Give me a little water from your vessel. ");
INSERT INTO engBBE_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","And she said, Take a drink, my lord: and quickly letting down her vessel onto her hand, she gave him a drink. ");
INSERT INTO engBBE_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","And having done so, she said, I will get water for your camels till they have had enough. ");
INSERT INTO engBBE_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","And after putting the water from her vessel into the animals' drinking-place, she went quickly back to the spring and got water for all the camels. ");
INSERT INTO engBBE_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","And the man, looking at her, said nothing, waiting to see if the Lord had given his journey a good outcome. ");
INSERT INTO engBBE_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","And when the camels had had enough, the man took a gold nose-ring, half a shekel in weight, and two ornaments for her arms of ten shekels weight of gold; ");
INSERT INTO engBBE_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","And said to her, Whose daughter are you? is there room in your father's house for us? ");
INSERT INTO engBBE_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","And she said to him, I am the daughter of Bethuel, the son of Milcah, Nahor's wife. ");
INSERT INTO engBBE_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","And she said, We have a great store of dry grass and cattle-food, and there is room for you. ");
INSERT INTO engBBE_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","And with bent head the man gave worship to the Lord; ");
INSERT INTO engBBE_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","And said, Praise be to the Lord, the God of my master Abraham, who has given a sign that he is good and true to my master, by guiding me straight to the house of my master's family. ");
INSERT INTO engBBE_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","So the girl went running and took the news of these things to her mother's house ");
INSERT INTO engBBE_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Now Rebekah had a brother named Laban, and he came out quickly to the man at the water-spring. ");
INSERT INTO engBBE_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","And when he saw the nose-ring and the ornaments on his sister's hands, and when she gave him word of what the man had said to her, then he went out to the man who was waiting with the camels by the water-spring. ");
INSERT INTO engBBE_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","And he said to him, Come in, you on whom is the blessing of the Lord; why are you waiting outside? for I have made the house ready for you, and a place for the camels. ");
INSERT INTO engBBE_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Then the man came into the house, and Laban took their cords off the camels and gave them dry grass and food, and he gave to him and the men who were with him water for washing their feet. ");
INSERT INTO engBBE_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","And meat was put before him, but he said, I will not take food till I have made my business clear to you. And they said, Do so. ");
INSERT INTO engBBE_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","And he said, I am Abraham's servant. ");
INSERT INTO engBBE_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","The Lord has given my master every blessing, and he has become great: he has given him flocks and herds and silver and gold, and men-servants and women-servants and camels and asses. ");
INSERT INTO engBBE_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","And when Sarah, my master's wife, was old, she gave birth to a son, to whom he has given all he has. ");
INSERT INTO engBBE_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","And my master made me take an oath, saying, Do not get a wife for my son from the daughters of the Canaanites among whom I am living; ");
INSERT INTO engBBE_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","But go to my father's house and to my relations for a wife for my son. ");
INSERT INTO engBBE_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","And I said to my master, What if the woman will not come with me? ");
INSERT INTO engBBE_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","And he said, The Lord, whom I have ever kept before me, will send his angel with you, who will make it possible for you to get a wife for my son from my relations and my father's house; ");
INSERT INTO engBBE_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","And you will be free from your oath to me when you come to my people; and if they will not give her to you, you will be free from your oath. ");
INSERT INTO engBBE_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","And I came today to the water-spring, and I said, O Lord, the God of my master Abraham, if it is your purpose to give a good outcome to my journey, ");
INSERT INTO engBBE_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Let it come about that, while I am waiting here by the water-spring, if a girl comes to get water and I say to her, Give me a little water from your vessel, and she says, ");
INSERT INTO engBBE_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Take a drink, and I will get water for your camels; let her be the woman marked out by the Lord for my master's son. ");
INSERT INTO engBBE_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","And even while I was saying this to myself, Rebekah came out with her vessel on her arm; and she went down to the spring to get water; and I said to her, Give me a drink. ");
INSERT INTO engBBE_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","And straight away she took down her vessel from her arm, and said, Take a drink, and I will get water for your camels. ");
INSERT INTO engBBE_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","And questioning her, I said, Whose daughter are you? And she said, The daughter of Bethuel, the son of Nahor, and Milcah his wife. Then I put the ring on her nose and the ornaments on her hands. ");
INSERT INTO engBBE_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","And with bent head I gave worship and praise to the Lord, the God of my master Abraham, by whom I had been guided in the right way, to get the daughter of my master's brother for his son. ");
INSERT INTO engBBE_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","And now, say if you will do what is good and right for my master or not, in order that it may be clear to me what I have to do. ");
INSERT INTO engBBE_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Then Laban and Bethuel said in answer, This is the Lord's doing: it is not for us to say Yes or No to you. ");
INSERT INTO engBBE_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","See, here is Rebekah: take her and go, and let her be your master's son's wife, as the Lord has said. ");
INSERT INTO engBBE_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","And at these words, Abraham's servant went down on his face and gave praise to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Then he took jewels of silver and jewels of gold and fair robes and gave them to Rebekah: and he gave things of value to her mother and her brother. ");
INSERT INTO engBBE_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Then he and the men who were with him had food and drink, and took their rest there that night; and in the morning he got up, and said, Let me now go back to my master. ");
INSERT INTO engBBE_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","But her brother and her mother said, Let the girl be with us a week or ten days, and then she may go. ");
INSERT INTO engBBE_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","And he said, Do not keep me; the Lord has given a good outcome to my journey; let me now go back to my master. ");
INSERT INTO engBBE_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","And they said, We will send for the girl, and let her make the decision. ");
INSERT INTO engBBE_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","And they sent for Rebekah and said to her, Are you ready to go with this man? And she said, I am ready. ");
INSERT INTO engBBE_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","So they sent their sister Rebekah and her servant with Abraham's servant and his men. ");
INSERT INTO engBBE_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","And they gave Rebekah their blessing, saying, O sister, may you be the mother of thousands and ten thousands; and may your seed overcome all those who make war against them. ");
INSERT INTO engBBE_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","So Rebekah and her servant-women went with the man, seated on the camels; and so the servant took Rebekah and went on his way. ");
INSERT INTO engBBE_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Now Isaac had come through the waste land to Beer-lahai-roi; for he was living in the South. ");
INSERT INTO engBBE_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","And when the evening was near, he went wandering out into the fields, and lifting up his eyes he saw camels coming. ");
INSERT INTO engBBE_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","And when Rebekah, looking up, saw Isaac, she got down from her camel, ");
INSERT INTO engBBE_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","And said to the servant, Who is that man coming to us through the field? And the servant said, It is my master: then she took her veil, covering her face with it. ");
INSERT INTO engBBE_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Then the servant gave Isaac the story of all he had done. ");
INSERT INTO engBBE_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","And Isaac took Rebekah into his tent and she became his wife; and in his love for her, Isaac was comforted after his father's death. ");
INSERT INTO engBBE_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","And Abraham took another wife named Keturah. ");
INSERT INTO engBBE_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","She became the mother of Zimran and Jokshan and Medan and Midian and Ishbak and Shuah. ");
INSERT INTO engBBE_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","And Jokshan became the father of Sheba and Dedan. And from Dedan came the Asshurim and Letushim and Leummim. ");
INSERT INTO engBBE_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","And from Midian came Ephah and Epher and Hanoch and Abida and Eldaah. All these were the offspring of Keturah. ");
INSERT INTO engBBE_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Now Abraham gave all his property to Isaac; ");
INSERT INTO engBBE_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","But to the sons of his other women he gave offerings, and sent them away, while he was still living, into the east country. ");
INSERT INTO engBBE_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Now the years of Abraham's life were a hundred and seventy-five. ");
INSERT INTO engBBE_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","And Abraham came to his death, an old man, full of years; and he was put to rest with his people. ");
INSERT INTO engBBE_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","And Isaac and Ishmael, his sons, put him to rest in the hollow rock of Machpelah, in the field of Ephron, the son of Zohar the Hittite, near Mamre; ");
INSERT INTO engBBE_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","The same field which Abraham got from the children of Heth: there Abraham was put to rest with Sarah, his wife. ");
INSERT INTO engBBE_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Now after the death of Abraham, the blessing of God was with Isaac, his son. ");
INSERT INTO engBBE_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Now these are the generations of Ishmael, the son of Abraham, whose mother was Hagar the Egyptian, the servant of Sarah: ");
INSERT INTO engBBE_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","These are the names of the sons of Ishmael by their generations: Ishmael's first son was Nebaioth; then Kedar and Adbeel and Mibsam ");
INSERT INTO engBBE_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","And Mishma and Dumah and Massa, ");
INSERT INTO engBBE_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad and Tema, Jetur, Naphish, and Kedemah: ");
INSERT INTO engBBE_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","These are the sons of Ishmael, and these are their names in their towns and their tent-circles; twelve chiefs with their peoples. ");
INSERT INTO engBBE_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","And the years of Ishmael's life were a hundred and thirty-seven: and he came to his end, and was put to rest with his people. ");
INSERT INTO engBBE_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","And their country was from Havilah to Shur which is east of Egypt: they took their place to the east of all their brothers. ");
INSERT INTO engBBE_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Now these are the generations of Abraham's son Isaac: ");
INSERT INTO engBBE_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac was forty years old when he took Rebekah, the daughter of Bethuel the Aramaean of Paddan-aram, and the sister of Laban the Aramaean, to be his wife. ");
INSERT INTO engBBE_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaac made prayer to the Lord for his wife because she had no children; and the Lord gave ear to his prayer, and Rebekah became with child. ");
INSERT INTO engBBE_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","And the children were fighting together inside her, and she said, If it is to be so, why am I like this? So she went to put her question to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","And the Lord said to her, Two nations are in your body, and two peoples will come to birth from you: the one will be stronger than the other, and the older will be the servant of the younger. ");
INSERT INTO engBBE_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","And when the time came for her to give birth, there were two children in her body. ");
INSERT INTO engBBE_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","And the first came out red from head to foot like a robe of hair, and they gave him the name of Esau. ");
INSERT INTO engBBE_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","And after him, his brother came out, gripping Esau's foot; and he was named Jacob: Isaac was sixty years old when she gave birth to them. ");
INSERT INTO engBBE_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","And the boys came to full growth; and Esau became a man of the open country, an expert bowman; but Jacob was a quiet man, living in tents. ");
INSERT INTO engBBE_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Now Isaac's love was for Esau, because Esau's meat was greatly to his taste: but Rebekah had more love for Jacob. ");
INSERT INTO engBBE_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","And one day Jacob was cooking some soup when Esau came in from the fields in great need of food; ");
INSERT INTO engBBE_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","And Esau said to Jacob, Give me a full meal of that red soup, for I am overcome with need for food: for this reason he was named Edom. ");
INSERT INTO engBBE_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","And Jacob said, First of all give me your birthright. ");
INSERT INTO engBBE_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","And Esau said, Truly, I am at the point of death: what profit is the birthright to me? ");
INSERT INTO engBBE_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","And Jacob said, First of all give me your oath; and he gave him his oath, handing over his birthright to Jacob. ");
INSERT INTO engBBE_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Then Jacob gave him bread and soup; and he took food and drink and went away, caring little for his birthright. ");
INSERT INTO engBBE_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Then came a time of great need in the land, like that which had been before in the days of Abraham. And Isaac went to Abimelech, king of the Philistines, at Gerar. ");
INSERT INTO engBBE_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","And the Lord came to him in a vision and said, Do not go down to Egypt; keep in the land of which I will give you knowledge: ");
INSERT INTO engBBE_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Keep in this land, and I will be with you and give you my blessing; for to you and to your seed will I give all these lands, giving effect to the oath which I made to your father Abraham; ");
INSERT INTO engBBE_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","I will make your seed like the stars of heaven in number, and will give them all these lands, and your seed will be a blessing to all the nations of the earth; ");
INSERT INTO engBBE_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Because Abraham gave ear to my voice and kept my words, my rules, my orders, and my laws. ");
INSERT INTO engBBE_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","So Isaac went on living in Gerar; ");
INSERT INTO engBBE_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","And when he was questioned by the men of the place about his wife, he said, She is my sister; fearing to say, She is my wife; for, he said, the men of the place may put me to death on account of Rebekah; because she is very beautiful. ");
INSERT INTO engBBE_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","And when he had been there for some time, Abimelech, king of the Philistines, looking through a window, saw Isaac playing with Rebekah his wife. ");
INSERT INTO engBBE_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","And he said to Isaac, It is clear that she is your wife: why then did you say, She is my sister? And Isaac said, For fear that I might be put to death because of her. ");
INSERT INTO engBBE_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Then Abimelech said, What have you done to us? one of the people might well have had connection with your wife, and the sin would have been ours. ");
INSERT INTO engBBE_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","And Abimelech gave orders to his people that anyone touching Isaac or his wife was to be put to death. ");
INSERT INTO engBBE_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Now Isaac, planting seed in that land, got in the same year fruit a hundred times as much, for the blessing of the Lord was on him. ");
INSERT INTO engBBE_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","And his wealth became very great, increasing more and more; ");
INSERT INTO engBBE_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","For he had great wealth of flocks and herds and great numbers of servants; so that the Philistines were full of envy. ");
INSERT INTO engBBE_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Now all the water-holes, which his father's servants had made in the days of Abraham, had been stopped up with earth by the Philistines. ");
INSERT INTO engBBE_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","And Abimelech said to Isaac, Go away from us, for you are stronger than we are. ");
INSERT INTO engBBE_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","So Isaac went away from there, and put up his tents in the valley of Gerar, making his living-place there. ");
INSERT INTO engBBE_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","And he made again the water-holes which had been made in the days of Abraham his father, and which had been stopped up by the Philistines; and he gave them the names which his father had given them. ");
INSERT INTO engBBE_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Now Isaac's servants made holes in the valley, and came to a spring of flowing water. ");
INSERT INTO engBBE_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","But the herdmen of Gerar had a fight with Isaac's herdmen, for they said, The spring is ours: so he gave the spring the name of Esek, because there was a fight about it. ");
INSERT INTO engBBE_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Then they made another water-hole, and there was a fight about that, so he gave it the name of Sitnah. ");
INSERT INTO engBBE_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Then he went away from there, and made another water-hole, about which there was no fighting: so he gave it the name of Rehoboth, for he said, Now the Lord has made room for us, and we will have fruit in this land. ");
INSERT INTO engBBE_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","And from there he went on to Beer-sheba. ");
INSERT INTO engBBE_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","That night the Lord came to him in a vision, and said, I am the God of your father Abraham: have no fear for I am with you, blessing you, and your seed will be increased because of my servant Abraham. ");
INSERT INTO engBBE_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Then he made an altar there, and gave worship to the name of the Lord, and he put up his tents there, and there his servants made a water-hole. ");
INSERT INTO engBBE_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","And Abimelech had come to him from Gerar, with Ahuzzath his friend and Phicol, the captain of his army. ");
INSERT INTO engBBE_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","And Isaac said to them, Why have you come to me, seeing that in your hate for me you sent me away from you? ");
INSERT INTO engBBE_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","And they said, We saw clearly that the Lord was with you: so we said, Let there be an oath between us and you, and let us make an agreement with you; ");
INSERT INTO engBBE_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","That you will do us no damage, even as we put no hand on you, and did you nothing but good, and sent you away in peace: and now the blessing of the Lord is on you. ");
INSERT INTO engBBE_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Then he made a feast for them, and they all had food and drink. ");
INSERT INTO engBBE_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","And early in the morning they took an oath one to the other: then Isaac sent them away and they went on their way in peace. ");
INSERT INTO engBBE_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","And that day Isaac's servants came to him and gave him word of the water-hole which they had made, and said to him, We have come to water. ");
INSERT INTO engBBE_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","And he gave it the name of Shibah: so the name of that town is Beer-sheba to this day. ");
INSERT INTO engBBE_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","And when Esau was forty years old, he took as his wives Judith, the daughter of Beeri the Hittite, and Basemath, the daughter of Elon the Hittite: ");
INSERT INTO engBBE_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","And Isaac and Rebekah had grief of mind because of them. ");
INSERT INTO engBBE_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Now when Isaac was old and his eyes had become clouded so that he was not able to see, he sent for Esau, his first son, and said to him, My son: and he said, Here am I. ");
INSERT INTO engBBE_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","And he said, See now, I am old, and my death may take place at any time: ");
INSERT INTO engBBE_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","So take your arrows and your bow and go out to the field and get meat for me; ");
INSERT INTO engBBE_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","And make me food, good to the taste, such as is pleasing to me, and put it before me, so that I may have a meal and give you my blessing before death comes to me. ");
INSERT INTO engBBE_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Now Isaac's words to his son were said in Rebekah's hearing. Then Esau went out to get the meat. ");
INSERT INTO engBBE_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","And Rebekah said to Jacob, her son, Your father said to your brother Esau in my hearing, ");
INSERT INTO engBBE_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Go and get some roe's meat and make me a good meal, so that I may be full, and give you my blessing before the Lord before my death. ");
INSERT INTO engBBE_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Now, my son, do what I say. ");
INSERT INTO engBBE_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Go to the flock and get me two fat young goats; and I will make of them a meal to your father's taste: ");
INSERT INTO engBBE_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","And you will take it to him, so that he may have a good meal and give you his blessing before his death. ");
INSERT INTO engBBE_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","And Jacob said to Rebekah, his mother, But Esau my brother is covered with hair, while I am smooth: ");
INSERT INTO engBBE_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","If by chance my father puts his hand on me, it will seem to him that I am tricking him, and he will put a curse on me in place of a blessing. ");
INSERT INTO engBBE_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","And his mother said, Let the curse be on me, my son: only do as I say, and go and get them for me. ");
INSERT INTO engBBE_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","So he went and got them and took them to his mother: and she made a meal to his father's taste. ");
INSERT INTO engBBE_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","And Rebekah took the fair robes of her oldest son, which were with her in the house, and put them on Jacob, her younger son: ");
INSERT INTO engBBE_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","And she put the skins of the young goats on his hands and on the smooth part of his neck: ");
INSERT INTO engBBE_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","And she gave into the hand of Jacob, her son, the meat and the bread which she had made ready. ");
INSERT INTO engBBE_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","And he came to his father, and said, My father: and he said, Here am I: who are you, my son? ");
INSERT INTO engBBE_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","And Jacob said, I am Esau, your oldest son; I have done as you said: come now, be seated and take of my meat, so that you may give me a blessing. ");
INSERT INTO engBBE_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","And Isaac said, How is it that you have got it so quickly, my son? And he said, Because the Lord your God made it come my way. ");
INSERT INTO engBBE_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","And Isaac said, Come near so that I may put my hand on you, my son, and see if you are truly my son Esau or not. ");
INSERT INTO engBBE_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","And Jacob went near his father Isaac: and he put his hands on him; and he said, The voice is Jacob's voice, but the hands are the hands of Esau. ");
INSERT INTO engBBE_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","And he did not make out who he was, because his hands were covered with hair like his brother Esau's hands: so he gave him a blessing. ");
INSERT INTO engBBE_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","And he said, Are you truly my son Esau? And he said, I am. ");
INSERT INTO engBBE_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","And he said, Put it before me and I will take of my son's meat, so that I may give you a blessing. And he put it before him and he took it; and he gave him wine, and he had a drink. ");
INSERT INTO engBBE_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","And his father Isaac said to him, Come near now, my son, and give me a kiss. ");
INSERT INTO engBBE_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","And he came near and gave him a kiss; and smelling the smell of his clothing, he gave him a blessing, and said, See, the smell of my son is like the smell of a field on which the blessing of the Lord has come: ");
INSERT INTO engBBE_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","May God give you the dew of heaven, and the good things of the earth, and grain and wine in full measure: ");
INSERT INTO engBBE_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Let peoples be your servants, and nations go down before you: be lord over your brothers, and let your mother's sons go down before you: a curse be on everyone by whom you are cursed, and a blessing on those who give you a blessing. ");
INSERT INTO engBBE_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","And when Isaac had come to the end of blessing Jacob, and Jacob had not long gone away from Isaac his father, Esau came in from the field. ");
INSERT INTO engBBE_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","And he made ready a meal, good to the taste, and took it to his father, and said to him, Let my father get up and take of his son's meat, so that you may give me a blessing. ");
INSERT INTO engBBE_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","And Isaac his father said to him, Who are you? And he said, I am your oldest son, Esau. ");
INSERT INTO engBBE_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","And in great fear Isaac said, Who then is he who got meat and put it before me, and I took it all before you came, and gave him a blessing, and his it will be? ");
INSERT INTO engBBE_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","And hearing the words of his father, Esau gave a great and bitter cry, and said to his father, Give a blessing to me, even to me, O my father! ");
INSERT INTO engBBE_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","And he said, Your brother came with deceit, and took away your blessing. ");
INSERT INTO engBBE_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","And he said, Is it because he is named Jacob that he has twice taken my place? for he took away my birthright, and now he has taken away my blessing. And he said, Have you not kept a blessing for me? ");
INSERT INTO engBBE_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","And Isaac answering said, But I have made him your master, and have given him all his brothers for servants; I have made him strong with grain and wine: what then am I to do for you, my son? ");
INSERT INTO engBBE_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","And Esau said to his father, Is that the only blessing you have, my father? give a blessing to me, even me! And Esau was overcome with weeping. ");
INSERT INTO engBBE_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Then Isaac his father made answer and said to him, Far from the fertile places of the earth, and far from the dew of heaven on high will your living-place be: ");
INSERT INTO engBBE_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","By your sword will you get your living and you will be your brother's servant; but when your power is increased his yoke will be broken from off your neck. ");
INSERT INTO engBBE_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","So Esau was full of hate for Jacob because of his father's blessing; and he said in his heart, The days of weeping for my father are near; then I will put my brother Jacob to death. ");
INSERT INTO engBBE_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Then Rebekah, hearing what Esau had said, sent for Jacob, her younger son, and said to him, It seems that your brother Esau is purposing to put you to death. ");
INSERT INTO engBBE_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","So now, my son, do what I say: go quickly to Haran, to my brother Laban; ");
INSERT INTO engBBE_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","And be there with him for a little time, till your brother's wrath is turned away; ");
INSERT INTO engBBE_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Till the memory of what you have done to him is past and he is no longer angry: then I will send word for you to come back; are the two of you to be taken from me in one day? ");
INSERT INTO engBBE_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Then Rebekah said to Isaac, My life is a weariness to me because of the daughters of Heth: if Jacob takes a wife from among the daughters of Heth, such as these, the women of this land, of what use will my life be to me? ");
INSERT INTO engBBE_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Then Isaac sent for Jacob, and blessing him, said, Do not take a wife from among the women of Canaan; ");
INSERT INTO engBBE_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","But go to Paddan-aram, to the house of Bethuel, your mother's father, and there get yourself a wife from the daughters of Laban, your mother's brother. ");
INSERT INTO engBBE_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","And may God, the Ruler of all, give you his blessing, giving you fruit and increase, so that you may become an army of peoples. ");
INSERT INTO engBBE_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","And may God give you the blessing of Abraham, to you and to your seed, so that the land of your wanderings, which God gave to Abraham, may be your heritage. ");
INSERT INTO engBBE_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","So Isaac sent Jacob away: and he went to Paddan-aram, to Laban, son of Bethuel the Aramaean, the brother of Rebekah, the mother of Jacob and Esau. ");
INSERT INTO engBBE_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","So when Esau saw that Isaac had given Jacob his blessing, and sent him away to Paddan-aram to get a wife for himself there, blessing him and saying to him, Do not take a wife from among the women of Canaan; ");
INSERT INTO engBBE_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","And that Jacob had done as his father and mother said and had gone to Paddan-aram; ");
INSERT INTO engBBE_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","It was clear to Esau that his father had no love for the women of Canaan, ");
INSERT INTO engBBE_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","So Esau went to Ishmael and took Mahalath, the daughter of Abraham's son Ishmael, the sister of Nebaioth, to be his wife in addition to the wives he had. ");
INSERT INTO engBBE_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","So Jacob went out from Beer-sheba to go to Haran. ");
INSERT INTO engBBE_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","And coming to a certain place, he made it his resting-place for the night, for the sun had gone down; and he took one of the stones which were there, and putting it under his head he went to sleep in that place. ");
INSERT INTO engBBE_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","And he had a dream, and in his dream he saw steps stretching from earth to heaven, and the angels of God were going up and down on them. ");
INSERT INTO engBBE_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","And he saw the Lord by his side, saying, I am the Lord, the God of Abraham your father, and the God of Isaac: I will give to you and to your seed this land on which you are sleeping. ");
INSERT INTO engBBE_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Your seed will be like the dust of the earth, covering all the land to the west and to the east, to the north and to the south: you and your seed will be a name of blessing to all the families of the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","And truly, I will be with you, and will keep you wherever you go, guiding you back again to this land; and I will not give you up till I have done what I have said to you. ");
INSERT INTO engBBE_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","And Jacob, awaking from his sleep, said, Truly, the Lord is in this place and I was not conscious of it. ");
INSERT INTO engBBE_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","And fear came on him, and he said, This is a holy place; this is nothing less than the house of God and the doorway of heaven. ");
INSERT INTO engBBE_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","And early in the morning Jacob took the stone which had been under his head, and put it up as a pillar and put oil on it. ");
INSERT INTO engBBE_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","And he gave that place the name of Beth-el, but before that time the town was named Luz. ");
INSERT INTO engBBE_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Then Jacob took an oath, and said, If God will be with me, and keep me safe on my journey, and give me food and clothing to put on, ");
INSERT INTO engBBE_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","So that I come again to my father's house in peace, then I will take the Lord to be my God, ");
INSERT INTO engBBE_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","And this stone which I have put up for a pillar will be God's house: and of all you give me, I will give a tenth part to you. ");
INSERT INTO engBBE_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Then Jacob went on his journey till he came to the land of the children of the East. ");
INSERT INTO engBBE_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","And there he saw a water-hole in a field, and by the side of it three flocks of sheep, for there they got water for the sheep: and on the mouth of the water-hole there was a great stone. ");
INSERT INTO engBBE_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","And all the flocks would come together there, and when the stone had been rolled away, they would give the sheep water, and put the stone back again in its place on the mouth of the water-hole. ");
INSERT INTO engBBE_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Then Jacob said to the herdmen, My brothers, where do you come from? And they said, From Haran. ");
INSERT INTO engBBE_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","And he said to them, Have you any knowledge of Laban, the son of Nahor? And they said, We have. ");
INSERT INTO engBBE_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","And he said to them, Is he well? And they said, He is well, and here is Rachel his daughter coming with the sheep. ");
INSERT INTO engBBE_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Then Jacob said, The sun is still high and it is not time to get the cattle together: get water for the sheep and go and give them their food. ");
INSERT INTO engBBE_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","And they said, We are not able to do so till all the flocks have come together and the stone has been rolled away from the mouth of the water-hole; then we will get water for the sheep. ");
INSERT INTO engBBE_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","While he was still talking with them, Rachel came with her father's sheep, for she took care of them. ");
INSERT INTO engBBE_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Then when Jacob saw Rachel, the daughter of Laban, his mother's brother, coming with Laban's sheep, he came near, and rolling the stone away from the mouth of the hole, he got water for Laban's flock. ");
INSERT INTO engBBE_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","And weeping for joy, Jacob gave Rachel a kiss. ");
INSERT INTO engBBE_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","And Rachel, hearing from Jacob that he was her father's relation and that he was the son of Rebekah, went running to give her father news of it. ");
INSERT INTO engBBE_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","And Laban, hearing news of Jacob, his sister's son, came running, and took Jacob in his arms, and kissing him, made him come into his house. And Jacob gave him news of everything. ");
INSERT INTO engBBE_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","And Laban said to him, Truly, you are my bone and my flesh. And he kept Jacob with him for the space of a month. ");
INSERT INTO engBBE_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Then Laban said to Jacob, Because you are my brother are you to be my servant for nothing? say now, what is your payment to be? ");
INSERT INTO engBBE_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Now Laban had two daughters: the name of the older was Leah, and the name of the younger was Rachel. ");
INSERT INTO engBBE_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","And Leah's eyes were clouded, but Rachel was fair in face and form. ");
INSERT INTO engBBE_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","And Jacob was in love with Rachel; and he said, I will be your servant seven years for Rachel, your younger daughter. ");
INSERT INTO engBBE_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","And Laban said, It is better for you to have her than another man: go on living here with me. ");
INSERT INTO engBBE_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","And Jacob did seven years' work for Rachel; and because of his love for her it seemed to him only a very little time. ");
INSERT INTO engBBE_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Then Jacob said to Laban, Give me my wife so that I may have her, for the days are ended. ");
INSERT INTO engBBE_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","And Laban got together all the men of the place and gave a feast. ");
INSERT INTO engBBE_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","And in the evening he took Leah, his daughter, and gave her to him, and he went in to her. ");
INSERT INTO engBBE_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","And Laban gave Zilpah, his servant-girl, to Leah, to be her waiting-woman. ");
INSERT INTO engBBE_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","And in the morning Jacob saw that it was Leah: and he said to Laban, What have you done to me? was I not working for you so that I might have Rachel? why have you been false to me? ");
INSERT INTO engBBE_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","And Laban said, In our country we do not let the younger daughter be married before the older. ");
INSERT INTO engBBE_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Let the week of the bride-feast come to its end and then we will give you the other in addition, if you will be my servant for another seven years. ");
INSERT INTO engBBE_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","And Jacob did so; and when the week was ended, Laban gave him his daughter Rachel for his wife. ");
INSERT INTO engBBE_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","And Laban gave Rachel his servant-girl Bilhah to be her waiting-woman. ");
INSERT INTO engBBE_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Then Jacob took Rachel as his wife, and his love for her was greater than his love for Leah; and he went on working for Laban for another seven years. ");
INSERT INTO engBBE_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Now the Lord, seeing that Leah was not loved, gave her a child; while Rachel had no children. ");
INSERT INTO engBBE_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","And Leah was with child, and gave birth to a son to whom she gave the name Reuben: for she said, The Lord has seen my sorrow; now my husband will have love for me. ");
INSERT INTO engBBE_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Then she became with child again, and gave birth to a son; and said, Because it has come to the Lord's ears that I am not loved, he has given me this son in addition: and she gave him the name Simeon. ");
INSERT INTO engBBE_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","And she was with child again, and gave birth to a son; and said, Now at last my husband will be united to me, because I have given him three sons: so he was named Levi. ");
INSERT INTO engBBE_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","And she was with child again, and gave birth to a son: and she said, This time I will give praise to the Lord: so he was named Judah; after this she had no more children for a time. ");
INSERT INTO engBBE_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Now Rachel, because she had no children, was full of envy of her sister; and she said to Jacob, If you do not give me children I will not go on living. ");
INSERT INTO engBBE_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","But Jacob was angry with Rachel, and said, Am I in the place of God, who has kept your body from having fruit? ");
INSERT INTO engBBE_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Then she said, Here is my servant Bilhah, go in to her, so that she may have a child on my knees, and I may have a family by her. ");
INSERT INTO engBBE_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","So she gave him her servant Bilhah as a wife, and Jacob went in to her. ");
INSERT INTO engBBE_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","And Bilhah became with child, and gave birth to a son. ");
INSERT INTO engBBE_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Then Rachel said, God has been my judge, and has given ear to my voice, and has given me a son; so he was named Dan. ");
INSERT INTO engBBE_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","And again Bilhah, Rachel's servant, was with child, and gave birth to a second son. ");
INSERT INTO engBBE_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","And Rachel said, I have had a great fight with my sister, and I have overcome her: and she gave the child the name Naphtali. ");
INSERT INTO engBBE_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","When it was clear to Leah that she would have no more children for a time, she gave Zilpah, her servant, to Jacob as a wife. ");
INSERT INTO engBBE_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","And Zilpah, Leah's servant, gave birth to a son. ");
INSERT INTO engBBE_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","And Leah said, It has gone well for me: and she gave him the name Gad. ");
INSERT INTO engBBE_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","And Zilpah, Leah's servant, gave birth to a second son. ");
INSERT INTO engBBE_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","And Leah said, Happy am I! and all women will give witness to my joy: and she gave him the name Asher. ");
INSERT INTO engBBE_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Now at the time of the grain-cutting, Reuben saw some love-fruits in the field, and took them to his mother Leah. And Rachel said to her, Let me have some of your son's love-fruits. ");
INSERT INTO engBBE_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","But Leah said to her, Is it a small thing that you have taken my husband from me? and now would you take my son's love-fruits? Then Rachel said, You may have him tonight in exchange for your son's love-fruits. ");
INSERT INTO engBBE_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","In the evening, when Jacob came in from the field, Leah went out to him and said, Tonight you are to come to me, for I have given my son's love-fruits as a price for you. And he went in to her that night. ");
INSERT INTO engBBE_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","And God gave ear to her and she became with child, and gave Jacob a fifth son. ");
INSERT INTO engBBE_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Then Leah said, God has made payment to me for giving my servant-girl to my husband: so she gave her son the name Issachar. ");
INSERT INTO engBBE_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","And again Leah became with child, and she gave Jacob a sixth son. ");
INSERT INTO engBBE_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","And she said, God has given me a good bride-price; now at last will I have my husband living with me, for I have given him six sons: and she gave him the name Zebulun. ");
INSERT INTO engBBE_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","After that she had a daughter, to whom she gave the name Dinah. ");
INSERT INTO engBBE_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Then God gave thought to Rachel, and hearing her prayer he made her fertile. ");
INSERT INTO engBBE_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","And she was with child, and gave birth to a son: and she said, God has taken away my shame. ");
INSERT INTO engBBE_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","And she gave him the name Joseph, saying, May the Lord give me another son. ");
INSERT INTO engBBE_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Now after the birth of Joseph, Jacob said to Laban, Let me go away to my place and my country. ");
INSERT INTO engBBE_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Give me my wives and my children, for whom I have been your servant, and let me go: for you have knowledge of all the work I have done for you. ");
INSERT INTO engBBE_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","And Laban said, If you will let me say so, do not go away; for I have seen by the signs that the Lord has been good to me because of you. ");
INSERT INTO engBBE_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Say then what your payment is to be and I will give it. ");
INSERT INTO engBBE_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Then Jacob said, You have seen what I have done for you, and how your cattle have done well under my care. ");
INSERT INTO engBBE_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","For before I came you had little, and it has been greatly increased; and the Lord has given you a blessing in everything I have done; but when am I to do something for my family? ");
INSERT INTO engBBE_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","And Laban said, What am I to give you? And Jacob said, Do not give me anything; but I will again take up the care of your flock if you will only do this for me: ");
INSERT INTO engBBE_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Let me go through all your flock today, taking out from among them all the sheep which are marked or coloured or black, and all the marked or coloured goats: these will be my payment. ");
INSERT INTO engBBE_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","And so you will be able to put my honour to the test in time to come; if you see among my flocks any goats which are not marked or coloured, or any sheep which is not black, you may take me for a thief. ");
INSERT INTO engBBE_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","And Laban said, Let it be as you say. ");
INSERT INTO engBBE_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","So that day he took all the he-goats which were banded or coloured, and all the she-goats which were marked or coloured or had white marks, and all the black sheep, and gave them into the care of his sons; ");
INSERT INTO engBBE_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","And sent them three days' journey away: and Jacob took care of the rest of Laban's flock. ");
INSERT INTO engBBE_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Then Jacob took young branches of trees, cutting off the skin so that the white wood was seen in bands. ");
INSERT INTO engBBE_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","And he put the banded sticks in the drinking-places where the flock came to get water; and they became with young when they came to the water. ");
INSERT INTO engBBE_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","And because of this, the flock gave birth to young which were marked with bands of colour. ");
INSERT INTO engBBE_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","These lambs Jacob kept separate; and he put his flock in a place by themselves and not with Laban's flock. ");
INSERT INTO engBBE_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","And whenever the stronger ones of the flock became with young, Jacob put the sticks in front of them in the drinking-places, so that they might become with young when they saw the sticks. ");
INSERT INTO engBBE_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","But when the flocks were feeble, he did not put the sticks before them; so that the feebler flocks were Laban's and the stronger were Jacob's. ");
INSERT INTO engBBE_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","So Jacob's wealth was greatly increased; he had great flocks and women-servants and men-servants and camels and asses. ");
INSERT INTO engBBE_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Now it came to the ears of Jacob that Laban's sons were saying, Jacob has taken away all our father's property, and in this way he has got all this wealth. ");
INSERT INTO engBBE_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","And Jacob saw that Laban's feeling for him was no longer what it had been before. ");
INSERT INTO engBBE_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Then the Lord said to Jacob, Go back to the land of your fathers, and to your relations, and I will be with you. ");
INSERT INTO engBBE_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","And Jacob sent for Rachel and Leah to come to him in the field among his flock. ");
INSERT INTO engBBE_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","And he said to them, It is clear to me that your father's feeling is no longer what it was to me; but the God of my father has been with me ");
INSERT INTO engBBE_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","And you have seen how I have done all in my power for your father, ");
INSERT INTO engBBE_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","But your father has not kept faith with me, and ten times he has made changes in my payment; but God has kept him from doing me damage. ");
INSERT INTO engBBE_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","If he said, All those in the flock which have marks are to be yours, then all the flock gave birth to marked young; and if he said, All the banded ones are to be yours, then all the flock had banded young. ");
INSERT INTO engBBE_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","So God has taken away your father's cattle and has given them to me. ");
INSERT INTO engBBE_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","And at the time when the flock were with young, I saw in a dream that all the he-goats which were joined with the she-goats were banded and marked and coloured. ");
INSERT INTO engBBE_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","And in my dream the angel of the Lord said to me, Jacob: and I said, Here am I. ");
INSERT INTO engBBE_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","And he said, See how all the he-goats are banded and marked and coloured: for I have seen what Laban has done to you. ");
INSERT INTO engBBE_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","I am the God of Beth-el, where you put oil on the pillar and took an oath to me: now then, come out of this land and go back to the country of your birth. ");
INSERT INTO engBBE_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Then Rachel and Leah said to him in answer, What part or heritage is there for us in our father's house? ");
INSERT INTO engBBE_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Are we not as people from a strange country to him? for he took a price for us and now it is all used up. ");
INSERT INTO engBBE_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","For the wealth which God has taken from him is ours and our children's; so now, whatever God has said to you, do. ");
INSERT INTO engBBE_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Then Jacob put his wives and his sons on camels; ");
INSERT INTO engBBE_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","And sending on before him all his cattle and his property which he had got together in Paddan-aram, he made ready to go to Isaac his father in the land of Canaan. ");
INSERT INTO engBBE_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Now Laban had gone to see to the cutting of the wool of his sheep; so Rachel secretly took the images of the gods of her father's house. ");
INSERT INTO engBBE_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","And Jacob went away secretly, without giving news of his flight to Laban the Aramaean. ");
INSERT INTO engBBE_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","So he went away with all he had, and went across the River in the direction of the hill-country of Gilead. ");
INSERT INTO engBBE_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","And on the third day Laban had news of Jacob's flight. ");
INSERT INTO engBBE_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","And taking the men of his family with him, he went after him for seven days and overtook him in the hill-country of Gilead. ");
INSERT INTO engBBE_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Then God came to Laban in a dream by night, and said to him, Take care that you say nothing good or bad to Jacob. ");
INSERT INTO engBBE_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Now when Laban overtook him, Jacob had put up his tent in the hill-country; and Laban and his brothers put up their tents in the hill-country of Gilead. ");
INSERT INTO engBBE_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","And Laban said to Jacob, Why did you go away secretly, taking my daughters away like prisoners of war? ");
INSERT INTO engBBE_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Why did you make a secret of your flight, not giving me word of it, so that I might have sent you away with joy and songs, with melody and music? ");
INSERT INTO engBBE_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","You did not even let me give a kiss to my sons and my daughters. This was a foolish thing to do. ");
INSERT INTO engBBE_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","It is in my power to do you damage: but the God of your father came to me this night, saying, Take care that you say nothing good or bad to Jacob. ");
INSERT INTO engBBE_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","And now, it seems, you are going because your heart's desire is for your father's house; but why have you taken my gods? ");
INSERT INTO engBBE_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","And Jacob, in answer, said to Laban, My fear was that you might take your daughters from me by force. ");
INSERT INTO engBBE_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","As for your gods, if anyone of us has them, let him be put to death: make search before us all for what is yours, and take it. For Jacob had no knowledge that Rachel had taken them. ");
INSERT INTO engBBE_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","So Laban went into Jacob's tent and into Leah's tent, and into the tents of the two servant-women, but they were not there; and he came out of Leah's tent and went into Rachel's. ");
INSERT INTO engBBE_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Now Rachel had taken the images, and had put them in the camels' basket, and was seated on them. And Laban, searching through all the tent, did not come across them. ");
INSERT INTO engBBE_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","And she said to her father, Let not my lord be angry because I do not get up before you, for I am in the common condition of women. And with all his searching, he did not come across the images. ");
INSERT INTO engBBE_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Then Jacob was angry with Laban, and said, What crime or sin have I done that you have come after me with such passion? ");
INSERT INTO engBBE_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Now that you have made search through all my goods, what have you seen which is yours? Make it clear now before my people and your people, so that they may be judges between us. ");
INSERT INTO engBBE_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","These twenty years I have been with you; your sheep and your goats have had young without loss, not one of your he-goats have I taken for food. ");
INSERT INTO engBBE_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Anything which was wounded by beasts I did not take to you, but myself made up for the loss of it; you made me responsible for whatever was taken by thieves, by day or by night. ");
INSERT INTO engBBE_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","This was my condition, wasted by heat in the day and by the bitter cold at night; and sleep went from my eyes. ");
INSERT INTO engBBE_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","These twenty years I have been in your house; I was your servant for fourteen years because of your daughters, and for six years I kept your flock, and ten times was my payment changed. ");
INSERT INTO engBBE_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","If the God of my father, the God of Abraham and the Fear of Isaac, had not been with me, you would have sent me away with nothing in my hands. But God has seen my troubles and the work of my hands, and this night he kept you back. ");
INSERT INTO engBBE_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Then Laban, answering, said, These women are my daughters and these children my children, the flocks and all you see are mine: what now may I do for my daughters and for their children? ");
INSERT INTO engBBE_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Come, let us make an agreement, you and I; and let it be for a witness between us. ");
INSERT INTO engBBE_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Then Jacob took a stone and put it up as a pillar. ");
INSERT INTO engBBE_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","And Jacob said to his people, Get stones together; and they did so; and they had a meal there by the stones. ");
INSERT INTO engBBE_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","And the name Laban gave it was Jegar-sahadutha: but Jacob gave it the name of Galeed. ");
INSERT INTO engBBE_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","And Laban said, These stones are a witness between you and me today. For this reason its name was Galeed, ");
INSERT INTO engBBE_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","And Mizpah, for he said, May the Lord keep watch on us when we are unable to see one another's doings. ");
INSERT INTO engBBE_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","If you are cruel to my daughters, or if you take other wives in addition to my daughters, then though no man is there to see, God will be the witness between us. ");
INSERT INTO engBBE_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","And Laban said, See these stones and this pillar which I have put between you and me; ");
INSERT INTO engBBE_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","They will be witness that I will not go over these stones to you, and you will not go over these stones or this pillar to me, for any evil purpose. ");
INSERT INTO engBBE_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","May the God of Abraham and the God of Nahor, the God of their father, be our judge. Then Jacob took an oath by the Fear of his father Isaac. ");
INSERT INTO engBBE_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","And Jacob made an offering on the mountain, and gave orders to his people to take food: so they had a meal and took their rest that night on the mountain. ");
INSERT INTO engBBE_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","And early in the morning Laban, after kissing and blessing his daughters, went on his way back to his country. ");
INSERT INTO engBBE_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","And on his way Jacob came face to face with the angels of God. ");
INSERT INTO engBBE_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","And when he saw them he said, This is the army of God: so he gave that place the name of Mahanaim. ");
INSERT INTO engBBE_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Now Jacob sent servants before him to Esau, his brother, in the land of Seir, the country of Edom; ");
INSERT INTO engBBE_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","And he gave them orders to say these words to Esau: Your servant Jacob says, Till now I have been living with Laban: ");
INSERT INTO engBBE_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","And I have oxen and asses and flocks and men-servants and women-servants: and I have sent to give my lord news of these things so that I may have grace in his eyes. ");
INSERT INTO engBBE_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","When the servants came back they said, We have seen your brother Esau and he is coming out to you, and four hundred men with him. ");
INSERT INTO engBBE_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Then Jacob was in great fear and trouble of mind: and he put all the people and the flocks and the herds and the camels into two groups; ");
INSERT INTO engBBE_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","And said, If Esau, meeting one group, makes an attack on them, the others will get away safely. ");
INSERT INTO engBBE_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Then Jacob said, O God of my father Abraham, the God of my father Isaac, the Lord who said to me, Go back to your country and your family and I will be good to you: ");
INSERT INTO engBBE_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","I am less than nothing in comparison with all your mercies and your faith to me your servant; for with only my stick in my hand I went across Jordan, and now I have become two armies. ");
INSERT INTO engBBE_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Be my saviour from the hand of Esau, my brother: for my fear is that he will make an attack on me, putting to death mother and child. ");
INSERT INTO engBBE_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","And you said, Truly, I will be good to you, and make your seed like the sand of the sea which may not be numbered. ");
INSERT INTO engBBE_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Then he put up his tent there for the night; and from among his goods he took, as an offering for his brother Esau, ");
INSERT INTO engBBE_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Two hundred she-goats and twenty he-goats, two hundred females and twenty males from the sheep, ");
INSERT INTO engBBE_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Thirty camels with their young ones, forty cows, ten oxen, twenty asses, and ten young asses. ");
INSERT INTO engBBE_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","These he gave to his servants, every herd by itself, and he said to his servants, Go on before me, and let there be a space between one herd and another. ");
INSERT INTO engBBE_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","And he gave orders to the first, saying, When my brother Esau comes to you and says, Whose servant are you, and where are you going, and whose are these herds? ");
INSERT INTO engBBE_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Then say to him, These are your servant Jacob's; they are an offering for my lord, for Esau; and he himself is coming after us. ");
INSERT INTO engBBE_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","And he gave the same orders to the second and the third and to all those who were with the herds, saying, This is what you are to say to Esau when you see him; ");
INSERT INTO engBBE_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","And you are to say further, Jacob, your servant, is coming after us. For he said to himself, I will take away his wrath by the offering which I have sent on, and then I will come before him: it may be that I will have grace in his eyes. ");
INSERT INTO engBBE_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","So the servants with the offerings went on in front, and he himself took his rest that night in the tents with his people. ");
INSERT INTO engBBE_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","And in the night he got up, and taking with him his two wives and the two servant-women and his eleven children, he went over the river Jabbok. ");
INSERT INTO engBBE_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","He took them and sent them over the stream with all he had. ");
INSERT INTO engBBE_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Then Jacob was by himself; and a man was fighting with him till dawn. ");
INSERT INTO engBBE_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","But when the man saw that he was not able to overcome Jacob, he gave him a blow in the hollow part of his leg, so that his leg was damaged. ");
INSERT INTO engBBE_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","And he said to him, Let me go now, for the dawn is near. But Jacob said, I will not let you go till you have given me your blessing. ");
INSERT INTO engBBE_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Then he said, What is your name? And he said, Jacob. ");
INSERT INTO engBBE_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","And he said, Your name will no longer be Jacob, but Israel: for in your fight with God and with men you have overcome. ");
INSERT INTO engBBE_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Then Jacob said, What is your name? And he said, What is my name to you? Then he gave him a blessing. ");
INSERT INTO engBBE_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","And Jacob gave that place the name of Peniel, saying, I have seen God face to face, and still I am living. ");
INSERT INTO engBBE_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","And while he was going past Peniel, the sun came up. And he went with unequal steps because of his damaged leg. ");
INSERT INTO engBBE_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","For this reason the children of Israel, even today, never take that muscle in the hollow of the leg as food, because the hollow of Jacob's leg was touched. ");
INSERT INTO engBBE_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Then Jacob, lifting up his eyes, saw Esau coming with his four hundred men. So he made a division of the children between Leah and Rachel and the two women-servants. ");
INSERT INTO engBBE_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","He put the servants and their children in front, Leah and her children after them, and Rachel and Joseph at the back. ");
INSERT INTO engBBE_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","And he himself, going before them, went down on his face to the earth seven times till he came near his brother. ");
INSERT INTO engBBE_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Then Esau came running up to him, and folding him in his arms, gave him a kiss: and the two of them were overcome with weeping. ");
INSERT INTO engBBE_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Then Esau, lifting up his eyes, saw the women and the children, and said, Who are these with you? And he said, The children whom God in his mercy has given to your servant. ");
INSERT INTO engBBE_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Then the servants and their children came near, and went down on their faces. ");
INSERT INTO engBBE_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","And Leah came near with her children, and then Joseph and Rachel, and they did the same. ");
INSERT INTO engBBE_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","And he said, What were all those herds which I saw on the way? And Jacob said, They were an offering so that I might have grace in my lord's eyes. ");
INSERT INTO engBBE_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","But Esau said, I have enough; keep what is yours, my brother, for yourself. ");
INSERT INTO engBBE_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","And Jacob said, Not so; but if I have grace in your eyes, take them as a sign of my love, for I have seen your face as one may see the face of God, and you have been pleased with me. ");
INSERT INTO engBBE_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Take my offering then, with my blessing; for God has been very good to me and I have enough: so at his strong request, he took it. ");
INSERT INTO engBBE_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","And he said, Let us go on our journey together, and I will go in front. ");
INSERT INTO engBBE_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","But Jacob said, My lord may see that the children are only small, and there are young ones in my flocks and herds: one day's over-driving will be the destruction of all the flock. ");
INSERT INTO engBBE_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Do you, my lord, go on before your servant; I will come on slowly, at the rate at which the cattle and the children are able to go, till I come to my lord at Seir. ");
INSERT INTO engBBE_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","And Esau said, Then keep some of my men with you. And he said, What need is there for that, if my lord is pleased with me? ");
INSERT INTO engBBE_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","So Esau, turning back that day, went on his way to Seir. ");
INSERT INTO engBBE_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","And Jacob went on to Succoth, where he made a house for himself and put up tents for his cattle: for this reason the place was named Succoth. ");
INSERT INTO engBBE_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","So Jacob came safely from Paddan-aram to the town of Shechem in the land of Canaan, and put up his tents near the town. ");
INSERT INTO engBBE_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","And for a hundred bits of money he got from the children of Hamor, the builder of Shechem, the field in which he had put up his tents. ");
INSERT INTO engBBE_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","And there he put up an altar, naming it El, the God of Israel. ");
INSERT INTO engBBE_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Now Dinah, the daughter whom Leah had by Jacob, went out to see the women of that country. ");
INSERT INTO engBBE_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","And when Shechem, the son of Hamor the Hivite who was the chief of that land, saw her, he took her by force and had connection with her. ");
INSERT INTO engBBE_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Then his heart went out in love to Dinah, the daughter of Jacob, and he said comforting words to her. ");
INSERT INTO engBBE_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","And Shechem said to Hamor, his father, Get me this girl for my wife. ");
INSERT INTO engBBE_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Now Jacob had word of what Shechem had done to his daughter; but his sons were in the fields with the cattle, and Jacob said nothing till they came. ");
INSERT INTO engBBE_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Then Hamor, the father of Shechem, came out to have a talk with Jacob. ");
INSERT INTO engBBE_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Now the sons of Jacob came in from the fields when they had news of it, and they were wounded and very angry because of the shame he had done in Israel by having connection with Jacob's daughter; and they said, Such a thing is not to be done. ");
INSERT INTO engBBE_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","But Hamor said to them, Shechem, my son, is full of desire for your daughter: will you then give her to him for a wife? ");
INSERT INTO engBBE_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","And let our two peoples be joined together; give your daughters to us, and take our daughters for yourselves. ");
INSERT INTO engBBE_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Go on living with us, and the country will be open to you; do trade and get property there. ");
INSERT INTO engBBE_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","And Shechem said to her father and her brothers, If you will give ear to my request, whatever you say I will give to you. ");
INSERT INTO engBBE_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","However great you make the bride-price and payment, I will give it; only let me have the girl for my wife. ");
INSERT INTO engBBE_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","But the sons of Jacob gave a false answer to Shechem and Hamor his father, because of what had been done to Dinah their sister. ");
INSERT INTO engBBE_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","And they said, It is not possible for us to give our sister to one who is without circumcision, for that would be a cause of shame to us: ");
INSERT INTO engBBE_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","But on this condition only will we come to an agreement with you: if every male among you becomes like us and undergoes circumcision; ");
INSERT INTO engBBE_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Then we will give our daughters to you and take your daughters to us and go on living with you as one people. ");
INSERT INTO engBBE_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","But if you will not undergo circumcision as we say, then we will take our daughter and go. ");
INSERT INTO engBBE_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","And their words were pleasing to Hamor and his son Shechem. ");
INSERT INTO engBBE_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","And without loss of time the young man did as they said, because he had delight in Jacob's daughter, and he was the noblest of his father's house. ");
INSERT INTO engBBE_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Then Hamor and Shechem, his son, went to the meeting-place of their town, and said to the men of the town, ");
INSERT INTO engBBE_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","It is the desire of these men to be at peace with us; let them then go on living in this country and doing trade here, for the country is wide open before them; let us take their daughters as wives and let us give them our daughters. ");
INSERT INTO engBBE_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","But these men will make an agreement with us to go on living with us and to become one people, only on the condition that every male among us undergoes circumcision as they have done. ");
INSERT INTO engBBE_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Then will not their cattle and their goods and all their beasts be ours? so let us come to an agreement with them so that they may go on living with us. ");
INSERT INTO engBBE_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Then all the men of the town gave ear to the words of Hamor and Shechem his son; and every male in the town underwent circumcision. ");
INSERT INTO engBBE_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","But on the third day after, before the wounds were well, two of the sons of Jacob, Simeon and Levi, Dinah's brothers, took their swords and came into the town by surprise and put all the males to death. ");
INSERT INTO engBBE_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","And Hamor and his son they put to death with the sword, and they took Dinah from Shechem's house and went away. ");
INSERT INTO engBBE_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","And the sons of Jacob came on them when they were wounded and made waste the town because of what had been done to their sister; ");
INSERT INTO engBBE_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","They took their flocks and their herds and their asses and everything in their town and in their fields, ");
INSERT INTO engBBE_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","And all their wealth and all their little ones and their wives; everything in their houses they took and made them waste. ");
INSERT INTO engBBE_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","And Jacob said to Simeon and Levi, You have made trouble for me and given me a bad name among the people of this country, among the Canaanites and the Perizzites: and because we are small in number they will come together against me and make war on me; and it will be the end of me and all my people. ");
INSERT INTO engBBE_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","But they said, Were we to let him make use of our sister as a loose woman? ");
INSERT INTO engBBE_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","And God said to Jacob, Go up now to Beth-el and make your living-place there: and put up an altar there to the God who came to you when you were in flight from your brother Esau. ");
INSERT INTO engBBE_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Then Jacob said to all his people, Put away the strange gods which are among you, and make yourselves clean, and put on a change of clothing: ");
INSERT INTO engBBE_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","And let us go up to Beth-el: and there I will make an altar to God, who gave me an answer in the day of my trouble, and was with me wherever I went. ");
INSERT INTO engBBE_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Then they gave to Jacob all the strange gods which they had, and the rings which were in their ears; and Jacob put them away under the holy tree at Shechem. ");
INSERT INTO engBBE_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","So they went on their journey: and the fear of God was on the towns round about, so that they made no attack on the sons of Jacob. ");
INSERT INTO engBBE_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","And Jacob came to Luz in the land of Canaan (which is the same as Beth-el), he and all his people. ");
INSERT INTO engBBE_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","And there he made an altar, naming the place El-beth-el: because it was there he had the vision of God when he was in flight from his brother. ");
INSERT INTO engBBE_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","And Deborah, the servant who had taken care of Rebekah from her birth, came to her end, and was put to rest near Beth-el, under the holy tree: and they gave it the name of Allon-bacuth. ");
INSERT INTO engBBE_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Now when Jacob was on his way from Paddan-aram, God came to him again and, blessing him, said, ");
INSERT INTO engBBE_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Jacob is your name, but it will be so no longer; from now your name will be Israel; so he was named Israel. ");
INSERT INTO engBBE_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","And God said to him, I am God, the Ruler of all: be fertile, and have increase; a nation, truly a group of nations, will come from you, and kings will be your offspring; ");
INSERT INTO engBBE_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","And the land which I gave to Abraham and Isaac, I will give to you; and to your seed after you I will give the land. ");
INSERT INTO engBBE_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Then God went up from him in the place where he had been talking with him. ");
INSERT INTO engBBE_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","And Jacob put up a pillar in the place where he had been talking with God, and put a drink offering on it, and oil. ");
INSERT INTO engBBE_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","And he gave to the place where God had been talking with him, the name of Beth-el. ");
INSERT INTO engBBE_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","So they went on from Beth-el; and while they were still some distance from Ephrath, the pains of birth came on Rachel and she had a hard time. ");
INSERT INTO engBBE_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","And when her pain was very great, the woman who was helping her said, Have no fear; for now you will have another son. ");
INSERT INTO engBBE_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","And in the hour when her life went from her (for death came to her), she gave the child the name Ben-oni: but his father gave him the name of Benjamin. ");
INSERT INTO engBBE_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","So Rachel came to her end and was put to rest on the road to Ephrath (which is Beth-lehem). ");
INSERT INTO engBBE_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","And Jacob put up a pillar on her resting-place; which is named, The Pillar of the resting-place of Rachel, to this day. ");
INSERT INTO engBBE_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","And Israel went journeying on and put up his tents on the other side of the tower of the flock. ");
INSERT INTO engBBE_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Now while they were living in that country, Reuben had connection with Bilhah, his father's servant-woman: and Israel had news of it. ");
INSERT INTO engBBE_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Now Jacob had twelve sons: the sons of Leah: Reuben, Jacob's first son, and Simeon and Levi and Judah and Issachar and Zebulun; ");
INSERT INTO engBBE_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","The sons of Rachel: Joseph and Benjamin; ");
INSERT INTO engBBE_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","The sons of Bilhah, Rachel's servant: Dan and Naphtali; ");
INSERT INTO engBBE_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","The sons of Zilpah, Leah's servant: Gad and Asher; these are the sons whom Jacob had in Paddan-aram. ");
INSERT INTO engBBE_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","And Jacob came to his father Isaac at Mamre, at Kiriath-arba, that is, Hebron, where Abraham and Isaac had been living. ");
INSERT INTO engBBE_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","And Isaac was a hundred and eighty years old. ");
INSERT INTO engBBE_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Then Isaac came to his end and was put to rest with his father's people, an old man after a long life: and Jacob and Esau, his sons, put him in his last resting-place. ");
INSERT INTO engBBE_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Now these are the generations of Esau, that is to say, Edom. ");
INSERT INTO engBBE_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau's wives were women of Canaan: Adah, the daughter of Elon the Hittite, and Oholibamah, the daughter of Anah, the daughter of Zibeon the Hivite, ");
INSERT INTO engBBE_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","And Basemath, Ishmael's daughter, the sister of Nebaioth. ");
INSERT INTO engBBE_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adah had a son Eliphaz; and Basemath was the mother of Reuel; ");
INSERT INTO engBBE_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibamah was the mother of Jeush, Jalam, and Korah; these are the sons of Esau, whose birth took place in the land of Canaan. ");
INSERT INTO engBBE_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau took his wives and his sons and his daughters, and all the people of his house, and his beasts and his cattle and all his goods which he had got together in the land of Canaan, and went into the land of Seir, away from his brother Jacob. ");
INSERT INTO engBBE_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","For their wealth was so great that the land was not wide enough for the two of them and all their cattle. ");
INSERT INTO engBBE_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","So Esau made his living-place in the hill-country of Seir (Esau is Edom). ");
INSERT INTO engBBE_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","And these are the generations of Esau, the father of the Edomites in the hill-country of Seir: ");
INSERT INTO engBBE_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","These are the names of Esau's sons: Eliphaz, the son of Esau's wife Adah, and Reuel, the son of Esau's wife Basemath. ");
INSERT INTO engBBE_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","The sons of Eliphaz were Teman, Omar, Zepho, Gatam, and Kenaz. ");
INSERT INTO engBBE_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","And Eliphaz, the son of Esau, had connection with a woman named Timna, who gave birth to Amalek: all these were the children of Esau's wife Adah. ");
INSERT INTO engBBE_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","And these are the sons of Reuel: Nahath, Zerah, Shammah, and Mizzah: they were the children of Esau's wife Basemath. ");
INSERT INTO engBBE_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","And these are the sons of Esau's wife Oholibamah, the daughter of Anah, the daughter of Zibeon: she was the mother of Jeush, Jalam, and Korah. ");
INSERT INTO engBBE_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","These were the chiefs among the sons of Esau: the sons of Eliphaz, Esau's first son: Teman, Omar, Zepho, Kenaz, ");
INSERT INTO engBBE_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gatam, Amalek: all these were chiefs in the land of Edom, the offspring of Eliphaz, the seed of Adah. ");
INSERT INTO engBBE_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","And these are the sons of Esau's son Reuel: Nahath, Zerah, Shammah, Mizzah: these were the chiefs of Reuel in the land of Edom, the children of Esau's wife Basemath. ");
INSERT INTO engBBE_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","And these are the sons of Esau's wife Oholibamah: Jeush, Jalam, and Korah: these were the chiefs who came from Esau's wife Oholibamah, daughter of Anah. ");
INSERT INTO engBBE_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","These were the sons of Esau (that is, Edom), and these were their chiefs. ");
INSERT INTO engBBE_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","These are the sons of Seir the Horite who were living in that country; Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO engBBE_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, and Dishan: these are the chiefs of the Horites, offspring of Seir in the land of Edom. ");
INSERT INTO engBBE_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","The children of Lotan were Hori and Hemam; Lotan's sister was Timna. ");
INSERT INTO engBBE_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","And these are the children of Shobal: Alvan, Manahath, Ebal, Shepho, and Onam. ");
INSERT INTO engBBE_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","And these are the children of Zibeon: Aiah and Anah; that same Anah who made the discovery of the water-springs in the waste land, when he was looking after the asses of his father Zibeon. ");
INSERT INTO engBBE_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","And these are the children of Anah: Dishon and Oholibamah his daughter. ");
INSERT INTO engBBE_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","These are the children of Dishon: Hemdan, Eshban, Ithran, and Keran. ");
INSERT INTO engBBE_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","These are the children of Ezer: Bilhan, Zaavan, and Akan. ");
INSERT INTO engBBE_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","These are the children of Dishan: Uz and Aran. ");
INSERT INTO engBBE_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","These were the Horite chiefs: Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO engBBE_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishon, Ezer, and Dishan. Such were the Horite chiefs in their order in the land of Seir. ");
INSERT INTO engBBE_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","And these are the kings who were ruling in the land of Edom before there was any king over the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, son of Beor, was king in Edom, and the name of his chief town was Dinhabah. ");
INSERT INTO engBBE_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","At his death, Jobab, son of Zerah of Bozrah, became king in his place. ");
INSERT INTO engBBE_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","And at the death of Jobab, Husham, from the country of the Temanites, became king in his place. ");
INSERT INTO engBBE_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","And at the death of Husham, Hadad, son of Bedad, who overcame the Midianites in the field of Moab, became king; his chief town was named Avith. ");
INSERT INTO engBBE_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","And at the death of Hadad, Samlah of Masrekah became king. ");
INSERT INTO engBBE_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","And at the death of Samlah, Shaul of Rehoboth by the River became king in his place. ");
INSERT INTO engBBE_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","And at the death of Shaul, Baal-hanan, son of Achbor, became king. ");
INSERT INTO engBBE_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","And at the death of Baal-hanan, Hadar became king in his place; his chief town was named Pau, and his wife's name was Mehetabel; she was the daughter of Matred, the daughter of Me-zahab. ");
INSERT INTO engBBE_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","These are the names of the chiefs of Esau in the order of their families and their places: Timna, Alvah, Jetheth, ");
INSERT INTO engBBE_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibamah, Elah, Pinon, ");
INSERT INTO engBBE_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar, ");
INSERT INTO engBBE_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, Iram; these are the Edomite chiefs, in their places in their heritage; this is Esau, the father of the Edomites. ");
INSERT INTO engBBE_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Now Jacob was living in the land where his father had made a place for himself, in the land of Canaan. ");
INSERT INTO engBBE_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","These are the generations of Jacob: Joseph, a boy seventeen years old, was looking after the flock, together with his brothers, the sons of Bilhah and Zilpah, his father's wives; and Joseph gave their father a bad account of them. ");
INSERT INTO engBBE_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Now the love which Israel had for Joseph was greater than his love for all his other children, because he got him when he was an old man: and he had a long coat made for him. ");
INSERT INTO engBBE_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","And because his brothers saw that Joseph was dearer to his father than all the others, they were full of hate for him, and would not say a kind word to him. ");
INSERT INTO engBBE_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Now Joseph had a dream, and he gave his brothers an account of it, which made their hate greater than ever. ");
INSERT INTO engBBE_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","And he said to them, Let me give you the story of my dream. ");
INSERT INTO engBBE_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","We were in the field, getting the grain stems together, and my grain kept upright, and yours came round and went down on the earth before mine. ");
INSERT INTO engBBE_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","And his brothers said to him, Are you to be our king? will you have authority over us? And because of his dream and his words, their hate for him became greater than ever. ");
INSERT INTO engBBE_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Then he had another dream, and gave his brothers an account of it, saying, I have had another dream: the sun and the moon and eleven stars gave honour to me. ");
INSERT INTO engBBE_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","And he gave word of it to his father and his brothers; but his father protesting said, What sort of a dream is this? am I and your mother and your brothers to go down on our faces to the earth before you? ");
INSERT INTO engBBE_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","And his brothers were full of envy; but his father kept his words in mind. ");
INSERT INTO engBBE_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Now his brothers went to keep watch over their father's flock in Shechem. ");
INSERT INTO engBBE_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","And Israel said to Joseph, Are not your brothers with the flock in Shechem? come, I will send you to them. And he said to him, Here am I. ");
INSERT INTO engBBE_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","And he said to him, Go now, and see if your brothers are well and how the flock is; then come back and give me word. So he sent him out of the valley of Hebron, and he came to Shechem. ");
INSERT INTO engBBE_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","And a man saw him wandering in the country, and said to him, What are you looking for? ");
INSERT INTO engBBE_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","And he said, I am looking for my brothers; please give me word of where they are keeping their flock. ");
INSERT INTO engBBE_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","And the man said, They have gone away from here, for they said in my hearing, Let us go to Dothan. So Joseph went after them and came up with them at Dothan. ");
INSERT INTO engBBE_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","But they saw him when he was a long way off, and before he came near them they made a secret design against him to put him to death; ");
INSERT INTO engBBE_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Saying to one another, See, here comes this dreamer. ");
INSERT INTO engBBE_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Let us now put him to death and put his body into one of these holes, and we will say, An evil beast has put him to death: then we will see what becomes of his dreams. ");
INSERT INTO engBBE_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","But Reuben, hearing these words, got him out of their hands, saying, Let us not take his life. ");
INSERT INTO engBBE_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Do not put him to a violent death, but let him be placed in one of the holes; this he said to keep him safe from their hands, with the purpose of taking him back to his father again. ");
INSERT INTO engBBE_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","So when Joseph came to his brothers, they took off his long coat which he had on; ");
INSERT INTO engBBE_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","And they took him and put him in the hole: now the hole had no water in it. ");
INSERT INTO engBBE_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Then seating themselves, they took their meal: and looking up, they saw a travelling band of Ishmaelites, coming from Gilead on their way to Egypt, with spices and perfumes on their camels. ");
INSERT INTO engBBE_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","And Judah said to his brothers, What profit is there in putting our brother to death and covering up his blood? ");
INSERT INTO engBBE_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Let us give him to these Ishmaelites for a price, and let us not put violent hands on him, for he is our brother, our flesh. And his brothers gave ear to him. ");
INSERT INTO engBBE_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","And some traders from Midian went by; so pulling Joseph up out of the hole, they gave him to the Ishmaelites for twenty bits of silver, and they took him to Egypt. ");
INSERT INTO engBBE_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Now when Reuben came back to the hole, Joseph was not there; and giving signs of grief, ");
INSERT INTO engBBE_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","He went back to his brothers, and said, The child is gone; what am I to do? ");
INSERT INTO engBBE_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Then they took Joseph's coat, and put on it some of the blood from a young goat which they had put to death, ");
INSERT INTO engBBE_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","And they took the coat to their father, and said, We came across this; is it your son's coat or not? ");
INSERT INTO engBBE_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","And he saw that it was, and said, It is my son's coat; an evil beast has put him to death; without doubt Joseph has come to a cruel end. ");
INSERT INTO engBBE_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Then Jacob, giving signs of grief, put on haircloth, and went on weeping for his son day after day. ");
INSERT INTO engBBE_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","And all his sons and all his daughters came to give him comfort, but he would not be comforted, saying with weeping, I will go down to the underworld to my son. So great was his father's sorrow for him. ");
INSERT INTO engBBE_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","And in Egypt the men of Midian gave him for a price to Potiphar, a captain of high position in Pharaoh's house. ");
INSERT INTO engBBE_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Now at that time, Judah went away from his brothers and became the friend of a man of Adullam named Hirah. ");
INSERT INTO engBBE_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","And there he saw the daughter of a certain man of Canaan named Shua, and took her as his wife. ");
INSERT INTO engBBE_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","And she gave birth to a son, and he gave him the name Er. ");
INSERT INTO engBBE_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","And again she gave birth to a son, and he gave him the name Onan. ");
INSERT INTO engBBE_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Then she had another son, to whom she gave the name Shelah; she was at Chezib when the birth took place. ");
INSERT INTO engBBE_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","And Judah took a wife for his first son Er, and her name was Tamar. ");
INSERT INTO engBBE_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Now Er, Judah's first son, did evil in the eyes of the Lord, so that he put him to death. ");
INSERT INTO engBBE_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Then Judah said to Onan, Go in to your brother's wife and do what it is right for a husband's brother to do; make her your wife and get offspring for your brother. ");
INSERT INTO engBBE_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","But Onan, seeing that the offspring would not be his, went in to his brother's wife, but let his seed go on to the earth, so that he might not get offspring for his brother. ");
INSERT INTO engBBE_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","And what he did was evil in the eyes of the Lord, so that he put him to death, like his brother. ");
INSERT INTO engBBE_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Then Judah said to Tamar, his daughter-in-law, Go back to your father's house and keep yourself as a widow till my son Shelah becomes a man: for he had in his mind the thought that death might come to him as it had come to his brothers. So Tamar went back to her father's house. ");
INSERT INTO engBBE_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","And after a time, Bath-shua, Judah's wife, came to her end; and after Judah was comforted for her loss, he went to Timnah, where they were cutting the wool of his sheep, and his friend Hirah of Adullam went with him. ");
INSERT INTO engBBE_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","And when Tamar had news that her father-in-law was going up to Timnah to the wool-cutting, ");
INSERT INTO engBBE_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","She took off her widow's clothing, and covering herself with her veil, she took her seat near Enaim on the road to Timnah; for she saw that Shelah was now a man, but she had not been made his wife. ");
INSERT INTO engBBE_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","When Judah saw her he took her to be a loose woman of the town, because her face was covered. ");
INSERT INTO engBBE_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","And turning to her by the roadside, he said to her, Let me come in to you; for he had no idea that she was his daughter-in-law. And she said, What will you give me as my price? ");
INSERT INTO engBBE_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","And he said, I will give you a young goat from the flock. And she said, What will you give me as a sign till you send it? ");
INSERT INTO engBBE_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","And he said, What would you have? And she said, Your ring and its cord and the stick in your hand. So he gave them to her and went in to her, and she became with child by him. ");
INSERT INTO engBBE_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Then she got up and went away and took off her veil and put on her widow's clothing. ");
INSERT INTO engBBE_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Then Judah sent his friend Hirah with the young goat, to get back the things which he had given as a sign to the woman: but she was not there. ");
INSERT INTO engBBE_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","And he put questions to the men of the place, saying, Where is the loose woman who was in Enaim by the wayside? And they said, There was no such woman there. ");
INSERT INTO engBBE_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","So he went back to Judah, and said, I have not seen her, and the men of the place say that there is no such woman there. ");
INSERT INTO engBBE_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","And Judah said, Let her keep the things, so that we may not be shamed; I sent the young goat, but you did not see the woman. ");
INSERT INTO engBBE_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Now about three months after this, word came to Judah that Tamar, his daughter-in-law, had been acting like a loose woman and was with child. And Judah said, Take her out and let her be burned. ");
INSERT INTO engBBE_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","And while she was being taken out, she sent word to her father-in-law, saying, The man whose property these things are, is the father of my child: say then, whose are this ring and this cord and this stick? ");
INSERT INTO engBBE_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Then Judah said openly that they were his, and said, She is more upright than I am, for I did not give her to Shelah my son. And he had no more connection with her. ");
INSERT INTO engBBE_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","And when the time came for her to give birth, it was clear that there were two children in her body. ");
INSERT INTO engBBE_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","And while she was in the act of giving birth, one of them put out his hand; and the woman who was with her put a red thread round his hand, saying, This one came out first. ");
INSERT INTO engBBE_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","But then he took his hand back again, and his brother came first to birth: and the woman said, What an opening you have made for yourself! So he was named Perez. ");
INSERT INTO engBBE_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","And then his brother came out, with the red thread round his hand, and he was named Zerah. ");
INSERT INTO engBBE_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Now Joseph was taken down to Egypt; and Potiphar the Egyptian, a captain of high position in Pharaoh's house, got him for a price from the Ishmaelites who had taken him there. ");
INSERT INTO engBBE_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","And the Lord was with Joseph, and he did well; and he was living in the house of his master the Egyptian. ");
INSERT INTO engBBE_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","And his master saw that the Lord was with him, making everything he did go well. ");
INSERT INTO engBBE_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","And having a high opinion of Joseph as his servant, he made him the overseer of his house and gave him control over all he had. ");
INSERT INTO engBBE_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","And from the time when he made him overseer and gave him control of all his property, the blessing of the Lord was with the Egyptian, because of Joseph; the blessing of the Lord was on all he had, in the house and in the field. ");
INSERT INTO engBBE_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","And he gave Joseph control of all his property, keeping no account of anything, but only the food which was put before him. Now Joseph was very beautiful in form and face. ");
INSERT INTO engBBE_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","And after a time, his master's wife, looking on Joseph with desire, said to him, Be my lover. ");
INSERT INTO engBBE_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","But he would not, and said to her, You see that my master keeps no account of what I do in his house, and has put all his property in my control; ");
INSERT INTO engBBE_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","So that no one has more authority in this house than I have; he has kept nothing back from me but you, because you are his wife; how then may I do this great wrong, sinning against God? ");
INSERT INTO engBBE_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","And day after day she went on requesting Joseph to come to her and be her lover, but he would not give ear to her. ");
INSERT INTO engBBE_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Now one day he went into the house to do his work; and not one of the men of the house was inside. ");
INSERT INTO engBBE_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","And pulling at his coat, she said, Come to my bed; but slipping out of his coat, he went running away. ");
INSERT INTO engBBE_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","And when she saw that he had got away, letting her keep his coat, ");
INSERT INTO engBBE_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","She sent for the men of her house and said to them, See, he has let a Hebrew come here and make sport of us; he came to my bed, and I gave a loud cry; ");
INSERT INTO engBBE_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","And hearing it he went running out without his coat. ");
INSERT INTO engBBE_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","And she kept his coat by her, till his master came back. ");
INSERT INTO engBBE_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Then she gave him the same story, saying, The Hebrew servant whom you have taken into our house came in to make sport of me; ");
INSERT INTO engBBE_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","And when I gave a loud cry he went running out without his coat. ");
INSERT INTO engBBE_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","And hearing his wife's account of what his servant had done, he became very angry. ");
INSERT INTO engBBE_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","And Joseph's master took him and put him in prison, in the place where the king's prisoners were kept in chains, and he was there in the prison-house. ");
INSERT INTO engBBE_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","But the Lord was with Joseph, and was good to him, and made the keeper of the prison his friend. ");
INSERT INTO engBBE_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","And the keeper of the prison put all the prisoners under Joseph's control, and he was responsible for whatever was done there. ");
INSERT INTO engBBE_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","And the keeper of the prison gave no attention to anything which was under his care, because the Lord was with him; and the Lord made everything he did go well. ");
INSERT INTO engBBE_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Now after these things the chief servant who had the care of the wine, and the chief bread-maker in Pharaoh's house, did something against Pharaoh's orders; ");
INSERT INTO engBBE_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","And Pharaoh was angry with his two servants, with the chief wine-servant and the chief bread-maker; ");
INSERT INTO engBBE_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","And he put them in prison under the care of the captain of the army, in the same prison where Joseph himself was shut up. ");
INSERT INTO engBBE_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","And the captain put them in Joseph's care, and he did what was needed for them; and they were kept in prison for some time. ");
INSERT INTO engBBE_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","And these two had a dream on the same night; the chief wine-servant and the chief bread-maker of the king of Egypt, who were in prison, the two of them had dreams with a special sense. ");
INSERT INTO engBBE_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","And in the morning when Joseph came to them he saw that they were looking sad. ");
INSERT INTO engBBE_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","And he said to the servants of Pharaoh who were in prison with him, Why are you looking so sad? ");
INSERT INTO engBBE_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Then they said to him, We have had a dream, and no one is able to give us the sense. And Joseph said, Does not the sense of dreams come from God? what was your dream? ");
INSERT INTO engBBE_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Then the chief wine-servant gave Joseph an account of his dream, and said, In my dream I saw a vine before me; ");
INSERT INTO engBBE_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","And on the vine were three branches; and it seemed as if it put out buds and flowers, and from them came grapes ready for cutting. ");
INSERT INTO engBBE_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","And Pharaoh's cup was in my hand, and I took the grapes and crushing them into Pharaoh's cup, gave the cup into Pharaoh's hand. ");
INSERT INTO engBBE_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Then Joseph said, This is the sense of your dream: the three branches are three days; ");
INSERT INTO engBBE_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","After three days Pharaoh will give you honour, and put you back into your place, and you will give him his cup as you did before, when you were his wine-servant. ");
INSERT INTO engBBE_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","But keep me in mind when things go well for you, and be good to me and say a good word for me to Pharaoh and get me out of this prison: ");
INSERT INTO engBBE_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","For truly I was taken by force from the land of the Hebrews; and I have done nothing for which I might be put in prison. ");
INSERT INTO engBBE_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Now when the chief bread-maker saw that the first dream had a good sense, he said to Joseph, I had a dream; and in my dream there were three baskets of white bread on my head; ");
INSERT INTO engBBE_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","And in the top basket were all sorts of cooked meats for Pharaoh; and the birds were taking them out of the baskets on my head. ");
INSERT INTO engBBE_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Then Joseph said, This is the sense of your dream: the three baskets are three days; ");
INSERT INTO engBBE_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","After three days Pharaoh will take you out of prison, hanging you on a tree, so that your flesh will be food for birds. ");
INSERT INTO engBBE_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Now the third day was Pharaoh's birthday, and he gave a feast for all his servants; and he gave honour to the chief wine-servant and the chief bread-maker among the others. ");
INSERT INTO engBBE_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","And he put the chief wine-servant back in his old place; and he gave the cup into Pharaoh's hand. ");
INSERT INTO engBBE_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","But the chief bread-maker was put to death by hanging, as Joseph had said. ");
INSERT INTO engBBE_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","But the wine-servant did not keep Joseph in mind or give a thought to him. ");
INSERT INTO engBBE_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Now after two years had gone by, Pharaoh had a dream; and in his dream he was by the side of the Nile; ");
INSERT INTO engBBE_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","And out of the Nile came seven cows, good-looking and fat, and their food was the river-grass. ");
INSERT INTO engBBE_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","And after them seven other cows came out of the Nile, poor-looking and thin; and they were by the side of the other cows. ");
INSERT INTO engBBE_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","And the seven thin cows made a meal of the seven fat cows. Then Pharaoh came out of his sleep. ");
INSERT INTO engBBE_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","But he went to sleep again and had a second dream, in which he saw seven heads of grain, full and good, all on one stem. ");
INSERT INTO engBBE_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","And after them came up seven other heads, thin and wasted by the east wind. ");
INSERT INTO engBBE_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","And the seven thin heads made a meal of the good heads. And when Pharaoh was awake he saw it was a dream. ");
INSERT INTO engBBE_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","And in the morning his spirit was troubled; and he sent for all the wise men of Egypt and all the holy men, and put his dream before them, but no one was able to give him the sense of it. ");
INSERT INTO engBBE_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Then the chief wine-servant said to Pharaoh, The memory of my sin comes back to me now; ");
INSERT INTO engBBE_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pharaoh had been angry with his servants, and had put me in prison in the house of the captain of the army, together with the chief bread-maker; ");
INSERT INTO engBBE_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","And we had a dream on the same night, the two of us, and the dreams had a special sense. ");
INSERT INTO engBBE_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","And there was with us a young Hebrew, the captain's servant, and when we put our dreams before him, he gave us the sense of them. ");
INSERT INTO engBBE_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","And it came about as he said: I was put back in my place, and the bread-maker was put to death by hanging. ");
INSERT INTO engBBE_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Then Pharaoh sent for Joseph, and they took him quickly out of prison; and when his hair had been cut and his dress changed, he came before Pharaoh. ");
INSERT INTO engBBE_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","And Pharaoh said to Joseph, I have had a dream, and no one is able to give me the sense of it; now it has come to my ears that you are able to give the sense of a dream when it is put before you. ");
INSERT INTO engBBE_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Then Joseph said, Without God there will be no answer of peace for Pharaoh. ");
INSERT INTO engBBE_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Then Pharaoh said, In my dream I was by the side of the Nile: ");
INSERT INTO engBBE_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","And out of the Nile came seven cows, fat and good-looking, and their food was the river-grass; ");
INSERT INTO engBBE_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Then after them came seven other cows, very thin and poor-looking, worse than any I ever saw in the land of Egypt; ");
INSERT INTO engBBE_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","And the thin cows made a meal of the seven fat cows who came up first; ");
INSERT INTO engBBE_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","And even with the fat cows inside them they seemed as bad as before. And so I came out of my sleep. ");
INSERT INTO engBBE_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","And again in a dream I saw seven heads of grain, full and good, coming up on one stem: ");
INSERT INTO engBBE_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","And then I saw seven other heads, dry, thin, and wasted by the east wind, coming up after them: ");
INSERT INTO engBBE_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","And the seven thin heads made a meal of the seven good heads; and I put this dream before the wise men, but not one of them was able to give me the sense of it. ");
INSERT INTO engBBE_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Then Joseph said, These two dreams have the same sense: God has made clear to Pharaoh what he is about to do. ");
INSERT INTO engBBE_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","The seven fat cows are seven years, and the seven good heads of grain are seven years: the two have the same sense. ");
INSERT INTO engBBE_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","The seven thin and poor-looking cows who came up after them are seven years; and the seven heads of grain, dry and wasted by the east wind, are seven years when there will be no food. ");
INSERT INTO engBBE_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","As I said to Pharaoh before, God has made clear to him what he is about to do. ");
INSERT INTO engBBE_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Seven years are coming in which there will be great wealth of grain in Egypt; ");
INSERT INTO engBBE_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","And after that will come seven years when there will not be enough food; and the memory of the good years will go from men's minds; and the land will be made waste by the bad years; ");
INSERT INTO engBBE_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","And men will have no memory of the good time because of the need which will come after, for it will be very bitter. ");
INSERT INTO engBBE_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","And this dream came to Pharaoh twice, because this thing is certain, and God will quickly make it come about. ");
INSERT INTO engBBE_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","And now let Pharaoh make search for a man of wisdom and good sense, and put him in authority over the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Let Pharaoh do this, and let him put overseers over the land of Egypt to put in store a fifth part of the produce of the land in the good years. ");
INSERT INTO engBBE_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","And let them get together all the food in those good years and make a store of grain under Pharaoh's control for the use of the towns, and let them keep it. ");
INSERT INTO engBBE_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","And let that food be kept in store for the land till the seven bad years which are to come in Egypt; so that the land may not come to destruction through need of food. ");
INSERT INTO engBBE_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","And this seemed good to Pharaoh and to all his servants. ");
INSERT INTO engBBE_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Then Pharaoh said to his servants, Where may we get such a man as this, a man in whom is the spirit of God? ");
INSERT INTO engBBE_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","And Pharaoh said to Joseph, Seeing that God has made all this clear to you, there is no other man of such wisdom and good sense as you: ");
INSERT INTO engBBE_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","You, then, are to be over my house, and all my people will be ruled by your word: only as king will I be greater than you. ");
INSERT INTO engBBE_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","And Pharaoh said to Joseph, See, I have put you over all the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Then Pharaoh took off his ring from his hand and put it on Joseph's hand, and he had him clothed with the best linen, and put a chain of gold round his neck; ");
INSERT INTO engBBE_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","And he made him take his seat in the second of his carriages; and they went before him crying, Make way! So he made him ruler over all the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Then Pharaoh said to Joseph, I am Pharaoh; and without your order no man may do anything in all the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","And Pharaoh gave Joseph the name of Zaphnath-paaneah; and he gave him Asenath, the daughter of Poti-phera, the priest of On, to be his wife. So Joseph went through all the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Now Joseph was thirty years old when he came before Pharaoh, king of Egypt. And Joseph went out from before the face of Pharaoh and went through all the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Now in the seven good years the earth gave fruit in masses. ");
INSERT INTO engBBE_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","And Joseph got together all the food of those seven years, and made a store of food in the towns: the produce of the fields round every town was stored up in the town. ");
INSERT INTO engBBE_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","So he got together a store of grain like the sand of the sea; so great a store that after a time he gave up measuring it, for it might not be measured. ");
INSERT INTO engBBE_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","And before the time of need, Joseph had two sons, to whom Asenath, the daughter of Poti-phera, priest of On, gave birth. ");
INSERT INTO engBBE_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","And to the first he gave the name Manasseh, for he said, God has taken away from me all memory of my hard life and of my father's house. ");
INSERT INTO engBBE_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","And to the second he gave the name Ephraim, for he said, God has given me fruit in the land of my sorrow. ");
INSERT INTO engBBE_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","And so the seven good years in Egypt came to an end. ");
INSERT INTO engBBE_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Then came the first of the seven years of need as Joseph had said: and in every other land they were short of food; but in the land of Egypt there was bread. ");
INSERT INTO engBBE_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","And when all the land of Egypt was in need of food, the people came crying to Pharaoh for bread; and Pharaoh said to the people, Go to Joseph, and whatever he says to you, do it. ");
INSERT INTO engBBE_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","And everywhere on the earth they were short of food; then Joseph, opening all his store-houses, gave the people of Egypt grain for money; so great was the need of food in the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","And all lands sent to Egypt, to Joseph, to get grain, for the need was great over all the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Now Jacob, hearing that there was grain in Egypt, said to his sons, Why are you looking at one another? ");
INSERT INTO engBBE_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","And he said, I have had news that there is grain in Egypt: go down there and get grain for us, so that life and not death may be ours. ");
INSERT INTO engBBE_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","So Joseph's ten brothers went down to get grain from Egypt. ");
INSERT INTO engBBE_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","But Jacob did not send Benjamin, Joseph's brother, with them, for fear, as he said, that some evil might come to him. ");
INSERT INTO engBBE_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","And the sons of Israel came with all the others to get grain: for they were very short of food in the land of Canaan. ");
INSERT INTO engBBE_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Now Joseph was ruler over all the land, and it was he who gave out the grain to all the people of the land; and Joseph's brothers came before him and went down on their faces to the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","And when Joseph saw his brothers, it was clear to him who they were, but he made himself strange to them, and talking roughly to them, said, Where do you come from? And they said, From the land of Canaan, to get food. ");
INSERT INTO engBBE_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Now though Joseph saw that these were his brothers, they had no idea who he was. ");
INSERT INTO engBBE_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Then the memory of his dreams about them came back to Joseph, and he said to them, You have come secretly to see how poor the land is. ");
INSERT INTO engBBE_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","And they said to him, Not so, my lord: your servants have come with money to get food. ");
INSERT INTO engBBE_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","We are all one man's sons, we are true men; we have not come with any secret purpose. ");
INSERT INTO engBBE_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","And he said to them, No, but you have come to see how poor the land is. ");
INSERT INTO engBBE_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Then they said, We your servants are twelve brothers, sons of one man in the land of Canaan; the youngest of us is now with our father, and one is dead. ");
INSERT INTO engBBE_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","And Joseph said, It is as I said; you have come with some secret purpose; ");
INSERT INTO engBBE_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","But in this way will you be put to the test: by the life of Pharaoh, you will not go away from this place till your youngest brother comes here. ");
INSERT INTO engBBE_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Send one of your number to get your brother, and the rest of you will be kept in prison, so that your words may be tested to see if you are true; if not, by the life of Pharaoh, your purpose is certainly secret. ");
INSERT INTO engBBE_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","So he put them in prison for three days. ");
INSERT INTO engBBE_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","And on the third day Joseph said to them, Do this, if you would keep your lives: for I am a god-fearing man: ");
INSERT INTO engBBE_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","If you are true men, let one of you be kept in prison, while you go and take grain for the needs of your families; ");
INSERT INTO engBBE_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","And come back to me with your youngest brother, so that your words may be seen to be true, and you will not be put to death. This is what you are to do. ");
INSERT INTO engBBE_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","And they said to one another, Truly, we did wrong to our brother, for we saw his grief of mind, and we did not give ear to his prayers; that is why this trouble has come on us. ");
INSERT INTO engBBE_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","And Reuben said to them, Did I not say to you, Do the child no wrong? but you gave no attention; so now, punishment has come on us for his blood. ");
INSERT INTO engBBE_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","They were not conscious that the sense of their words was clear to Joseph, for he had been talking to them through one who had knowledge of their language. ");
INSERT INTO engBBE_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","And turning away from them, he was overcome with weeping; then he went on talking to them again and took Simeon and put chains on him before their eyes. ");
INSERT INTO engBBE_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Then Joseph gave orders for their bags to be made full of grain, and for every man's money to be put back into his bag, and for food to be given them for the journey: which was done. ");
INSERT INTO engBBE_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Then they put the bags of grain on their asses and went away. ");
INSERT INTO engBBE_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Now at their night's resting-place one of them, opening his bag to give his ass some food, saw his money in the mouth of the bag. ");
INSERT INTO engBBE_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","And he said to his brothers, My money has been given back: it is in my bag; then their hearts became full of fear, and turning to one another they said, What is this which God has done to us? ");
INSERT INTO engBBE_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","So when they came to Jacob their father, in the land of Canaan, they gave him an account of all their experiences, saying, ");
INSERT INTO engBBE_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","The man who is the ruler of the country was rough with us and put us in prison, saying that we had come with a secret evil purpose. ");
INSERT INTO engBBE_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","And we said to him, We are true men, we have no evil designs; ");
INSERT INTO engBBE_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","We are twelve brothers, sons of our father; one is dead, and the youngest is now with our father in the land of Canaan. ");
INSERT INTO engBBE_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","And the ruler of the land said, In this way I may be certain that you are true men; let one of you be kept here with me, while you go and take grain for the needs of your families; ");
INSERT INTO engBBE_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","And come back to me with your youngest brother: then I will be certain that you are true men, and I will give your brother back to you and let you do trade in the land. ");
INSERT INTO engBBE_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","And when they took the grain out of their bags, it was seen that every man's parcel of money was in his bag; and when they and their father saw the money, they were full of fear. ");
INSERT INTO engBBE_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","And Jacob their father said to them, You have taken my children from me: Joseph is gone and Simeon is gone, and now you would take Benjamin away; all these things have come on me. ");
INSERT INTO engBBE_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","And Reuben said, Put my two sons to death if I do not come back to you with him; let him be in my care and I will give him safely back to you. ");
INSERT INTO engBBE_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","And he said, I will not let my son go down with you; for his brother is dead and he is all I have: if evil overtakes him on the journey, then through you will my grey head go down to the underworld in sorrow. ");
INSERT INTO engBBE_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Now the land was in bitter need of food. ");
INSERT INTO engBBE_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","And when the grain which they had got in Egypt was all used up, their father said to them, Go again and get us a little food. ");
INSERT INTO engBBE_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","And Judah said to him, The man said to us with an oath, You are not to come before me again without your brother. ");
INSERT INTO engBBE_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","If you will let our brother go with us, we will go down and get food: ");
INSERT INTO engBBE_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","But if you will not send him, we will not go down: for the man said to us, You are not to come before me if your brother is not with you. ");
INSERT INTO engBBE_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","And Israel said, Why were you so cruel to me as to say to him that you had a brother? ");
INSERT INTO engBBE_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","And they said, The man put a number of questions to us about ourselves and our family, saying, Is your father still living? have you another brother? And we had to give him answers; how were we to have any idea that he would say, Come back with your brother? ");
INSERT INTO engBBE_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Then Judah said to Israel, his father, Send the boy with me, and let us be up and going, so that we and you and our little ones may not come to destruction. ");
INSERT INTO engBBE_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Put him into my care and make me responsible for him: if I do not give him safely back to you, let mine be the sin for ever. ");
INSERT INTO engBBE_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Truly, if we had not let the time go by, we might have come back again by now. ");
INSERT INTO engBBE_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Then their father Israel said to them, If it has to be so, then do this: take of the best fruits of the land in your vessels to give the man, perfumes and honey and spices and nuts: ");
INSERT INTO engBBE_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","And take twice as much money with you; that is to say, take back the money which was put in your bags, for it may have been an error; ");
INSERT INTO engBBE_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","And take your brother and go back to the man: ");
INSERT INTO engBBE_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","And may God, the Ruler of all, give you mercy before the man, so that he may give you back your other brother and Benjamin. If my children are to be taken from me; there is no help for it. ");
INSERT INTO engBBE_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","So they took what their father said for the man, and twice as much money in their hands, and Benjamin, and went on their journey to Egypt, and came before Joseph. ");
INSERT INTO engBBE_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","And when Joseph saw Benjamin, he said to his chief servant, Take these men into my house, and make ready a meal, for they will take food with me in the middle of the day. ");
INSERT INTO engBBE_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","And the servant did as Joseph said, and took the men into Joseph's house. ");
INSERT INTO engBBE_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Now the men were full of fear because they had been taken into Joseph's house and they said, It is because of the money which was put back in our bags the first time; he is looking for something against us, so that he may come down on us and take us and our asses for his use. ");
INSERT INTO engBBE_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","So they went up to Joseph's chief servant at the door of the house, ");
INSERT INTO engBBE_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","And said, O my lord, we only came down the first time to get food; ");
INSERT INTO engBBE_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","And when we came to our night's resting-place, on opening our bags we saw that every man's money was in the mouth of his bag, all our money in full weight: and we have it with us to give it back; ");
INSERT INTO engBBE_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","As well as more money, with which to get food: we have no idea who put our money in our bags. ");
INSERT INTO engBBE_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Then the servant said, Peace be with you: have no fear: your God, even the God of your father, has put wealth in your bags for you: I had your money. Then he let Simeon come out to them. ");
INSERT INTO engBBE_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","And the servant took them into Joseph's house, and gave them water for washing their feet; and he gave their asses food. ");
INSERT INTO engBBE_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","And they got ready the things for Joseph before he came in the middle of the day: for word was given to them that they were to have a meal there. ");
INSERT INTO engBBE_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","And when Joseph came in, they gave him the things which they had for him, and went down to the earth before him. ");
INSERT INTO engBBE_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","And he said, How are you? is your father well, the old man of whom you were talking to me? is he still living? ");
INSERT INTO engBBE_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","And they said, Your servant, our father, is well, he is still living. And they went down on their faces before him. ");
INSERT INTO engBBE_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Then, lifting up his eyes, he saw Benjamin, his brother, his mother's son, and he said, Is this your youngest brother of whom you gave me word? And he said, God be good to you, my son. ");
INSERT INTO engBBE_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Then Joseph's heart went out to his brother, and he went quickly into his room, for he was overcome with weeping. ");
INSERT INTO engBBE_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Then, after washing his face, he came out, and controlling his feelings said, Put food before us. ");
INSERT INTO engBBE_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","And they put a meal ready for him by himself, and for them by themselves, and for the Egyptians who were with him by themselves; because the Egyptians may not take food with the Hebrews, for that would make them unclean. ");
INSERT INTO engBBE_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","And they were all given their seats before him in order of birth, from the oldest to the youngest: so that they were looking at one another in wonder. ");
INSERT INTO engBBE_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","And Joseph sent food to them from his table, but he sent five times as much to Benjamin as to any of the others. And they took wine freely with him. ");
INSERT INTO engBBE_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Then he gave orders to the servant who was over his house, saying, Put as much food into the men's bags as will go into them, and put every man's money in the mouth of his bag; ");
INSERT INTO engBBE_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","And put my cup, my silver cup, in the youngest one's bag, with his money. So he did as Joseph said. ");
INSERT INTO engBBE_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","And at dawn the men, with their asses, were sent away. ");
INSERT INTO engBBE_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","And when they had gone only a little way out of the town, Joseph said to the servant who was over his house, Go after them; and when you overtake them, say to them, Why have you done evil in reward for good? ");
INSERT INTO engBBE_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Is not this the cup from which my lord takes wine and by which he gets knowledge of the future? Truly, you have done evil. ");
INSERT INTO engBBE_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","So he overtook them and said these words to them. ");
INSERT INTO engBBE_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","And they said to him, Why does my lord say such words as these? far be it from your servants to do such a thing: ");
INSERT INTO engBBE_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","See, the money which was in the mouth of our bags we gave back to you when we came again from Canaan: how then might we take silver or gold from your lord's house? ");
INSERT INTO engBBE_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","If it comes to light that any of your servants has done this, let him be put to death, and we will be your lord's servants. ");
INSERT INTO engBBE_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","And he said, Let it be as you say: he in whose bag it is seen will become my servant; and you will not be responsible. ");
INSERT INTO engBBE_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Then every man quickly got his bag down and undid it. ");
INSERT INTO engBBE_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","And he made a search, starting with the oldest and ending with the youngest; and the cup was in Benjamin's bag. ");
INSERT INTO engBBE_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Then in bitter grief they put the bags on the asses again and went back to the town. ");
INSERT INTO engBBE_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","So Judah and his brothers came to Joseph's house; and he was still there: and they went down on their faces before him. ");
INSERT INTO engBBE_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","And Joseph said, What is this thing which you have done? had you no thought that such a man as I would have power to see what is secret? ");
INSERT INTO engBBE_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","And Judah said, What are we to say to my lord? how may we put ourselves right in his eyes? God has made clear the sin of your servants: now we are in your hands, we and the man in whose bag your cup was seen. ");
INSERT INTO engBBE_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Then he said, Far be it from me to do so: but the man who had my cup will be my servant; and you may go back to your father in peace. ");
INSERT INTO engBBE_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Then Judah came near him, and said, Let your servant say a word in my lord's ears, and let not your wrath be burning against your servant: for you are in the place of Pharaoh to us. ");
INSERT INTO engBBE_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","My lord said to his servants, Have you a father or a brother? ");
INSERT INTO engBBE_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","And we said to my lord, We have an old father and a young child, whom he had when he was old; his brother is dead and he is the only son of his mother, and is very dear to his father. ");
INSERT INTO engBBE_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","And you said to your servants, Let him come down to me with you, so that I may see him. ");
INSERT INTO engBBE_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","And we said to my lord, His father will not let him go; for if he went away his father would come to his death. ");
INSERT INTO engBBE_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","But you said to your servants, If your youngest brother does not come with you, you will not see my face again. ");
INSERT INTO engBBE_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","And when we went back to your servant, our father, we gave him an account of my lord's words. ");
INSERT INTO engBBE_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","And our father said, Go again and get us a little food. ");
INSERT INTO engBBE_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","And we said, Only if our youngest brother goes with us will we go down; for we may not see the man's face again if our youngest brother is not with us. ");
INSERT INTO engBBE_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","And our father said to us, You have knowledge that my wife gave me two sons; ");
INSERT INTO engBBE_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","The one went away from me, and I said, Truly he has come to a violent death; and from that time I have not seen him, ");
INSERT INTO engBBE_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","If now you take this one from me, and some evil comes to him, you will make my grey head go down in sorrow to the underworld. ");
INSERT INTO engBBE_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","If then I go back to your servant, my father, without the boy, because his life and the boy's life are one, ");
INSERT INTO engBBE_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","When he sees that the boy is not with us, he will come to his death, and our father's grey head will go down in sorrow to the underworld. ");
INSERT INTO engBBE_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","For I made myself responsible for the boy to my father, saying, If I do not give him safely back to you, let mine be the sin for ever. ");
INSERT INTO engBBE_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","So now let me be my lord's servant here in place of the boy, and let him go back with his brothers. ");
INSERT INTO engBBE_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","For how may I go back to my father without the boy, and see the evil which will come on my father? ");
INSERT INTO engBBE_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Then Joseph, unable to keep back his feelings before those who were with him, gave orders for everyone to be sent away, and no one was present when he made clear to his brothers who he was. ");
INSERT INTO engBBE_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","And so loud was his weeping, that it came to the ears of the Egyptians and all Pharaoh's house. ");
INSERT INTO engBBE_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","And Joseph said to his brothers, I am Joseph: is my father still living? But his brothers were not able to give him an answer for they were troubled before him. ");
INSERT INTO engBBE_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Then Joseph said to his brothers, Come near to me. And they came near, And he said, I am Joseph your brother, whom you sent into Egypt. ");
INSERT INTO engBBE_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Now do not be troubled or angry with yourselves for sending me away, because God sent me before you to be the saviour of your lives. ");
INSERT INTO engBBE_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","For these two years have been years of need, and there are still five more years to come in which there will be no ploughing or cutting of grain. ");
INSERT INTO engBBE_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","God sent me before you to keep you and yours living on earth so that you might become a great nation. ");
INSERT INTO engBBE_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","So now it was not you who sent me here, but God: and he has made me as a father to Pharaoh, and lord of all his house, and ruler over all the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Now go quickly to my father, and say to him, Your son Joseph says, God has made me ruler over all the land of Egypt: come down to me straight away: ");
INSERT INTO engBBE_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","The land of Goshen will be your living-place, and you will be near me; you and your children and your children's children, and your flocks and herds and all you have: ");
INSERT INTO engBBE_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","And there I will take care of you, so that you and your family may not be in need, for there are still five bad years to come. ");
INSERT INTO engBBE_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Now truly, your eyes see, and the eyes of my brother Benjamin see, that it is my mouth which says these things to you. ");
INSERT INTO engBBE_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Give my father word of all my glory in Egypt and of all you have seen; and come back quickly with my father. ");
INSERT INTO engBBE_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Then, weeping, he took Benjamin in his arms, and Benjamin himself was weeping on Joseph's neck. ");
INSERT INTO engBBE_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Then he gave a kiss to all his brothers, weeping over them; and after that his brothers had no fear of talking to him. ");
INSERT INTO engBBE_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","And news of these things went through Pharaoh's house, and it was said that Joseph's brothers were come; and it seemed good to Pharaoh and his servants. ");
INSERT INTO engBBE_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","And Pharaoh said to Joseph, Say to your brothers, Put your goods on your beasts and go back to the land of Canaan; ");
INSERT INTO engBBE_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","And get your father and your families and come back to me: and I will give you all the good things of Egypt, and the fat of the land will be your food. ");
INSERT INTO engBBE_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","And say to them, This you are to do: take carts from the land of Egypt for your little ones and for your wives, and get your father and come back. ");
INSERT INTO engBBE_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","And take no thought for your goods, for the best of all the land of Egypt is yours. ");
INSERT INTO engBBE_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","And the children of Israel did as he said; and Joseph gave them carts as had been ordered by Pharaoh, and food for their journey. ");
INSERT INTO engBBE_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","To every one of them he gave three changes of clothing; but to Benjamin he gave three hundred bits of silver and five changes of clothing. ");
INSERT INTO engBBE_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","And to his father he sent ten asses with good things from Egypt on their backs, and ten she-asses with grain and bread and food for his father on the journey. ");
INSERT INTO engBBE_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","And he sent his brothers on their way, and said to them, See that you have no argument on the road. ");
INSERT INTO engBBE_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","So they went up from Egypt and came to the land of Canaan, to their father Jacob. ");
INSERT INTO engBBE_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","And they said to him, Joseph is living, and is ruler over all the land of Egypt. And at this word Jacob was quite overcome, for he had no faith in it. ");
INSERT INTO engBBE_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","And they gave him an account of everything Joseph had said to them; and when he saw the carts which Joseph had sent for them, his spirit came back to him: ");
INSERT INTO engBBE_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","And Israel said, It is enough: Joseph my son is still living; I will go and see him before my death. ");
INSERT INTO engBBE_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","And Israel went on his journey with all he had, and came to Beer-sheba, where he made offerings to the God of his father Isaac. ");
INSERT INTO engBBE_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","And God said to Israel in a night-vision, Jacob, Jacob. And he said, Here am I. ");
INSERT INTO engBBE_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","And he said, I am God, the God of your father: go down to Egypt without fear, for I will make a great nation of you there: ");
INSERT INTO engBBE_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","I will go down with you to Egypt, and I will see that you come back again, and at your death Joseph will put his hands on your eyes. ");
INSERT INTO engBBE_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Then Jacob went on from Beer-sheba; and the sons of Jacob took their father and their little ones and their wives in the carts which Pharaoh had sent for them. ");
INSERT INTO engBBE_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","And they took their cattle and all the goods which they had got in the land of Canaan, and came to Egypt, even Jacob and all his seed: ");
INSERT INTO engBBE_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","His sons and his sons' sons, his daughters and his daughters' sons and all his family he took with him into Egypt. ");
INSERT INTO engBBE_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","And these are the names of the children of Israel who came into Egypt, even Jacob and all his sons: Reuben, Jacob's oldest son; ");
INSERT INTO engBBE_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","And the sons of Reuben: Hanoch and Pallu and Hezron and Carmi; ");
INSERT INTO engBBE_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","And the sons of Simeon: Jemuel and Jamin and Ohad and Jachin and Zohar and Shaul, the son of a woman of Canaan; ");
INSERT INTO engBBE_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","And the sons of Levi: Gershon, Kohath, and Merari; ");
INSERT INTO engBBE_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","And the sons of Judah: Er and Onan and Shelah and Perez and Zerah: but Er and Onan had come to their death in the land of Canaan; and the sons of Perez were Hezron and Hamul. ");
INSERT INTO engBBE_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","And the sons of Issachar: Tola and Puah and Job and Shimron; ");
INSERT INTO engBBE_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","And the sons of Zebulun: Sered and Elon and Jahleel; ");
INSERT INTO engBBE_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","All these, together with his daughter Dinah, were the children of Leah, whom Jacob had by her in Paddan-aram; they were thirty-three in number. ");
INSERT INTO engBBE_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","And the sons of Gad: Ziphion and Haggi, Shuni and Ezbon, Eri and Arodi and Areli; ");
INSERT INTO engBBE_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","And the sons of Asher: Jimnah and Ishvah and Ishvi and Beriah, and Sarah, their sister; and the sons of Beriah: Heber and Malchiel. ");
INSERT INTO engBBE_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","These are the children of Zilpah, whom Laban gave to his daughter Leah, and Jacob had these sixteen children by her. ");
INSERT INTO engBBE_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","The sons of Jacob's wife Rachel: Joseph and Benjamin. ");
INSERT INTO engBBE_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","And Joseph had Manasseh and Ephraim in the land of Egypt, by Asenath, the daughter of Poti-phera, priest of On. ");
INSERT INTO engBBE_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","And the sons of Benjamin were Belah and Becher and Ashbel, Gera and Naaman, Ehi and Rosh, Muppim and Huppim and Ard. ");
INSERT INTO engBBE_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","All these were the children of Rachel whom Jacob had by her, fourteen persons. ");
INSERT INTO engBBE_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","And the son of Dan was Hushim. ");
INSERT INTO engBBE_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","And the sons of Naphtali: Jahzeel and Guni and Jezer and Shillem. ");
INSERT INTO engBBE_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","These were the children of Bilhah, whom Laban gave to his daughter Rachel, seven persons. ");
INSERT INTO engBBE_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","All the persons who came with Jacob into Egypt, the offspring of his body, were sixty-six, without taking into account the wives of Jacob's sons. ");
INSERT INTO engBBE_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","And the sons of Joseph whom he had in Egypt were two. Seventy persons of the family of Jacob came into Egypt. ");
INSERT INTO engBBE_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Now he had sent Judah before him to Goshen, to get word from Joseph; and so they came to the land of Goshen. ");
INSERT INTO engBBE_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","And Joseph got his carriage ready and went to Goshen for the meeting with his father; and when he came before him, he put his arms round his neck, weeping. ");
INSERT INTO engBBE_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","And Israel said to Joseph, Now that I have seen you living again, I am ready for death. ");
INSERT INTO engBBE_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","And Joseph said to his brothers and to his father's people, I will go and give the news to Pharaoh, and say to him, My brothers and my father's people, from the land of Canaan, have come to me; ");
INSERT INTO engBBE_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","And these men are keepers of sheep and owners of cattle, and have with them their flocks and their herds and all they have. ");
INSERT INTO engBBE_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Now when Pharaoh sends for you and says, What is your business? ");
INSERT INTO engBBE_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","You are to say, Your servants have been keepers of cattle from our early days up to now, like our fathers; in this way you will be able to have the land of Goshen for yourselves; because keepers of sheep are unclean in the eyes of the Egyptians. ");
INSERT INTO engBBE_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Then Joseph went to Pharaoh, and said, My father and my brothers with their flocks and their herds and all they have, are come from Canaan, and are now in the land of Goshen. ");
INSERT INTO engBBE_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","And he took five of his brothers to Pharaoh. ");
INSERT INTO engBBE_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","And Pharaoh said to them, What is your business? And they said, Your servants are keepers of sheep, as our fathers were before us. ");
INSERT INTO engBBE_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","And they said to Pharaoh, We have come to make a living in this land, because we have no grass for our flocks in the land of Canaan; so now let your servants make a place for themselves in the land of Goshen. ");
INSERT INTO engBBE_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","And Pharaoh said to Joseph, Let them have the land of Goshen; and if there are any able men among them, put them over my cattle. ");
INSERT INTO engBBE_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","And Jacob and his sons came to Joseph in Egypt, and when word of it came to the ears of Pharaoh, king of Egypt, he said to Joseph, Your father and brothers have come to you; all the land of Egypt is before you; let your father and your brothers have the best of the land for their resting-place. ");
INSERT INTO engBBE_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Then Joseph made his father Jacob come before Pharaoh, and Jacob gave him his blessing. ");
INSERT INTO engBBE_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","And Pharaoh said to him, How old are you? ");
INSERT INTO engBBE_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","And Jacob said, The years of my wanderings have been a hundred and thirty; small in number and full of sorrow have been the years of my life, and less than the years of the wanderings of my fathers. ");
INSERT INTO engBBE_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","And Jacob gave Pharaoh his blessing, and went out from before him. ");
INSERT INTO engBBE_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","And Joseph made a place for his father and his brothers, and gave them a heritage in the land of Egypt, in the best of the land, the land of Rameses, as Pharaoh had given orders. ");
INSERT INTO engBBE_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","And Joseph took care of his father and his brothers and all his father's people, giving them food for the needs of their families. ");
INSERT INTO engBBE_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Now there was no food to be had in all the land, so that all Egypt and Canaan were wasted from need of food. ");
INSERT INTO engBBE_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","And all the money in Egypt and in the land of Canaan which had been given for grain, came into the hands of Joseph: and he put it in Pharaoh's house. ");
INSERT INTO engBBE_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","And when all the money in Egypt and Canaan was gone, the Egyptians came to Joseph, and said, Give us bread; would you have us come to destruction before your eyes? for we have no more money. ");
INSERT INTO engBBE_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","And Joseph said, Give me your cattle; I will give you grain in exchange for your cattle if your money is all gone. ");
INSERT INTO engBBE_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","So they took their cattle to Joseph and he gave them bread in exchange for their horses and flocks and herds and asses, so all that year he gave them food in exchange for their cattle. ");
INSERT INTO engBBE_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","And when that year was ended, they came to him in the second year, and said, We may not keep it from our lord's knowledge that all our money is gone, and all the herds of cattle are my lord's; there is nothing more to give my lord but our bodies and our land; ");
INSERT INTO engBBE_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Are we to come to destruction before your eyes, we and our land? take us and our land and give us bread; and we and our land will be servants to Pharaoh; and give us seed so that we may have life and the land may not become waste. ");
INSERT INTO engBBE_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","So Joseph got all the land in Egypt for Pharaoh; for every Egyptian gave up his land in exchange for food, because of their great need; so all the land became Pharaoh's. ");
INSERT INTO engBBE_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","And as for the people, he made servants of them, town by town, from one end of Egypt to the other. ");
INSERT INTO engBBE_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Only he did not take the land of the priests, for the priests had their food given them by Pharaoh, and having what Pharaoh gave them, they had no need to give up their land. ");
INSERT INTO engBBE_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Then Joseph said to the people, I have made you and your land this day the property of Pharaoh; here is seed for you to put in your fields. ");
INSERT INTO engBBE_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","And when the grain is cut, you are to give a fifth part to Pharaoh, and four parts will be yours for seed and food, and for your families and your little ones. ");
INSERT INTO engBBE_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","And they said to him, Truly you have kept us from death; may we have grace in your eyes, and we will be Pharaoh's servants. ");
INSERT INTO engBBE_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Then Joseph made a law which is in force to this day, that Pharaoh was to have the fifth part; only the land of the priests did not become his. ");
INSERT INTO engBBE_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","And so Israel was living among the Egyptians in the land of Goshen; and they got property there, and became very great in numbers and in wealth. ");
INSERT INTO engBBE_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","And Jacob was living in the land of Goshen for seventeen years; so the years of his life were a hundred and forty-seven. ");
INSERT INTO engBBE_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","And the time of his death came near, and he sent for his son Joseph and said to him, If now I am dear to you, put your hand under my leg and take an oath that you will not put me to rest in Egypt; ");
INSERT INTO engBBE_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","But when I go to my fathers, you are to take me out of Egypt and put me to rest in their last resting-place. And he said, I will do so. ");
INSERT INTO engBBE_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","And he said, Take an oath to me; and he took an oath to him: and Israel gave worship on the bed's head. ");
INSERT INTO engBBE_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Now after these things, word came to Joseph that his father was ill: and he took with him his sons Manasseh and Ephraim. ");
INSERT INTO engBBE_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","And when they said to Jacob, Your son Joseph is coming to see you: then Israel, getting all his strength together, had himself lifted up in his bed. ");
INSERT INTO engBBE_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","And Jacob said to Joseph, God, the Ruler of all, came to me in a vision at Luz in the land of Canaan, and gave me his blessing, ");
INSERT INTO engBBE_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","And said to me, Truly, I will make you fertile and give you increase and will make of you a great family of nations: and I will give this land to your seed after you to be their heritage for ever. ");
INSERT INTO engBBE_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","And now your two sons who came to birth in Egypt before I came to you here, are mine; Ephraim and Manasseh will be mine, in the same way as Reuben and Simeon are. ");
INSERT INTO engBBE_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","And any other offspring which you have after them, will be yours, and will be named after their brothers in their heritage. ");
INSERT INTO engBBE_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","And as for me, when I came from Paddan, death overtook Rachel on the way, when we were still some distance from Ephrath; and I put her to rest there on the road to Ephrath, which is Beth-lehem. ");
INSERT INTO engBBE_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Then Israel, looking at Joseph's sons, said, Who are these? ");
INSERT INTO engBBE_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","And Joseph said to his father, They are my sons, whom God has given me in this land. And he said, Let them come near me, and I will give them a blessing. ");
INSERT INTO engBBE_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Now because Israel was old, his eyes were no longer clear, and he was not able to see. So he made them come near to him, and he gave them a kiss, folding them in his arms. ");
INSERT INTO engBBE_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","And Israel said to Joseph, I had no hope of seeing your face again, but God in his mercy has let me see you and your children. ");
INSERT INTO engBBE_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Then Joseph took them from between his knees, and went down on his face to the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Then taking Ephraim with his right hand, Joseph put him at Israel's left side, and with his left hand he put Manasseh at Israel's right side, placing them near him. ");
INSERT INTO engBBE_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","And Israel, stretching out his right hand, put it on the head of Ephraim, the younger, and his left hand on the head of Manasseh, crossing his hands on purpose, for Manasseh was the older. ");
INSERT INTO engBBE_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","And he gave Joseph a blessing, saying, May the God to whom my fathers, Abraham and Isaac, gave worship, the God who has taken care of me all my life till this day, ");
INSERT INTO engBBE_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","The angel who has been my saviour from all evil, send his blessing on these children: and let my name and the name of my fathers, Abraham and Isaac, be given to them; and let them become a great nation in the earth. ");
INSERT INTO engBBE_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Now when Joseph saw that his father had put his right hand on the head of Ephraim, it did not seem right to him; and lifting his father's hand he would have put it on the head of Manasseh. ");
INSERT INTO engBBE_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","And Joseph said to his father, Not so, my father, for this is the older; put your right hand on his head. ");
INSERT INTO engBBE_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","But his father would not, saying, I am doing it on purpose, my son; he will certainly become a nation and a great one; but his younger brother will be greater than he, and his seed will become a great family of nations. ");
INSERT INTO engBBE_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","So he gave them his blessing that day, saying, You will be the sign of blessing in Israel, for they will say, May God make you like Ephraim and Manasseh; and he put Ephraim before Manasseh. ");
INSERT INTO engBBE_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Then Israel said to Joseph, Now my death is near; but God will be with you, guiding you back to the land of your fathers. ");
INSERT INTO engBBE_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","And I have given you more than your brothers, even Shechem as your heritage, which I took from the Amorites with my sword and my bow. ");
INSERT INTO engBBE_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","And Jacob sent for his sons, and said, Come together, all of you, so that I may give you news of your fate in future times. ");
INSERT INTO engBBE_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Come near, O sons of Jacob, and give ear to the words of Israel your father. ");
INSERT INTO engBBE_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Reuben, you are my oldest son, the first-fruit of my strength, first in pride and first in power: ");
INSERT INTO engBBE_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","But because you were uncontrolled, the first place will not be yours; for you went up to your father's bed, even his bride-bed, and made it unclean. ");
INSERT INTO engBBE_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon and Levi are brothers; deceit and force are their secret designs. ");
INSERT INTO engBBE_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Take no part in their secrets, O my soul; keep far away, O my heart, from their meetings; for in their wrath they put men to death, and for their pleasure even oxen were wounded. ");
INSERT INTO engBBE_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","A curse on their passion for it was bitter; and on their wrath for it was cruel. I will let their heritage in Jacob be broken up, driving them from their places in Israel. ");
INSERT INTO engBBE_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","To you, Judah, will your brothers give praise: your hand will be on the neck of your haters; your father's sons will go down to the earth before you. ");
INSERT INTO engBBE_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judah is a young lion; like a lion full of meat you have become great, my son; now he takes his rest like a lion stretched out and like an old lion; by whom will his sleep be broken? ");
INSERT INTO engBBE_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","The rod of authority will not be taken from Judah, and he will not be without a law-giver, till he comes who has the right to it, and the peoples will put themselves under his rule. ");
INSERT INTO engBBE_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Knotting his ass's cord to the vine, and his young ass to the best vine; washing his robe in wine, and his clothing in the blood of grapes: ");
INSERT INTO engBBE_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","His eyes will be dark with wine, and his teeth white with milk. ");
INSERT INTO engBBE_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","The resting-place of Zebulun will be by the sea, and he will be a harbour for ships; the edge of his land will be by Zidon. ");
INSERT INTO engBBE_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issachar is a strong ass stretched out among the flocks: ");
INSERT INTO engBBE_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","And he saw that rest was good and the land was pleasing; so he let them put weights on his back and became a servant. ");
INSERT INTO engBBE_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan will be the judge of his people, as one of the tribes of Israel. ");
INSERT INTO engBBE_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","May Dan be a snake in the way, a horned snake by the road, biting the horse's foot so that the horseman has a fall. ");
INSERT INTO engBBE_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","I have been waiting for your salvation, O Lord. ");
INSERT INTO engBBE_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad, an army will come against him, but he will come down on them in their flight. ");
INSERT INTO engBBE_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asher's bread is fat; he gives delicate food for kings. ");
INSERT INTO engBBE_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naphtali is a roe let loose, giving fair young ones. ");
INSERT INTO engBBE_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joseph is a young ox, whose steps are turned to the fountain; ");
INSERT INTO engBBE_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","He was troubled by the archers; they sent out their arrows against him, cruelly wounding him: ");
INSERT INTO engBBE_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","But their bows were broken by a strong one, and the cords of their arms were cut by the Strength of Jacob, by the name of the Stone of Israel: ");
INSERT INTO engBBE_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Even by the God of your father, who will be your help, and by the Ruler of all, who will make you full with blessings from heaven on high, blessings of the deep stretched out under the earth, blessings of the breasts and of the fertile body: ");
INSERT INTO engBBE_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Blessings of sons, old and young, to the father: blessings of the oldest mountains and the fruit of the eternal hills: let them come on the head of Joseph, on the crown of him who was separate from his brothers. ");
INSERT INTO engBBE_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin is a wolf, searching for meat: in the morning he takes his food, and in the evening he makes division of what he has taken. ");
INSERT INTO engBBE_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","These are the twelve tribes of Israel: and these are the words their father said to them, blessing them; to every one he gave his blessing. ");
INSERT INTO engBBE_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","And he gave orders to them, saying, Put me to rest with my people and with my fathers, in the hollow of the rock in the field of Ephron the Hittite, ");
INSERT INTO engBBE_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","In the rock in the field of Machpelah, near Mamre in the land of Canaan, which Abraham got from Ephron the Hittite, to be his resting-place. ");
INSERT INTO engBBE_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","There Abraham and Sarah his wife were put to rest, and there they put Isaac and Rebekah his wife, and there I put Leah to rest. ");
INSERT INTO engBBE_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","In the rock in the field which was got for a price from the people of Heth. ");
INSERT INTO engBBE_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","And when Jacob had come to the end of these words to his sons, stretching himself on his bed, he gave up his spirit, and went the way of his people. ");
INSERT INTO engBBE_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","And Joseph put his head down on his father's face, weeping and kissing him. ");
INSERT INTO engBBE_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","And Joseph gave orders to his servants who had the necessary knowledge, to make his father's body ready, folding it in linen with spices, and they did so. ");
INSERT INTO engBBE_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","And the forty days needed for making the body ready went by: and there was weeping for him among the Egyptians for seventy days. ");
INSERT INTO engBBE_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","And when the days of weeping for him were past, Joseph said to the servants of Pharaoh, If now you have love for me, say these words to Pharaoh: ");
INSERT INTO engBBE_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","My father made me take an oath, saying, When I am dead, put me to rest in the place I have made ready for myself in the land of Canaan. So now let me go and put my father in his last resting-place, and I will come back again. ");
INSERT INTO engBBE_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","And Pharaoh said, Go up and put your father to rest, as you gave your oath to him. ");
INSERT INTO engBBE_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","So Joseph went up to put his father in his last resting-place; and with him went all the servants of Pharaoh, and the chief men of his house and all the chiefs of the land of Egypt, ");
INSERT INTO engBBE_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","And all the family of Joseph, and his brothers and his father's people: only their little ones and their flocks and herds they did not take with them from the land of Goshen. ");
INSERT INTO engBBE_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","And carriages went up with him and horsemen, a great army. ");
INSERT INTO engBBE_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","And they came to the grain-floor of Atad on the other side of Jordan, and there they gave the last honours to Jacob, with great and bitter sorrow, weeping for their father for seven days. ");
INSERT INTO engBBE_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","And when the people of the land, the people of Canaan, at the grain-floor of Atad, saw their grief, they said, Great is the grief of the Egyptians: so the place was named Abel-mizraim, on the other side of Jordan. ");
INSERT INTO engBBE_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","So his sons did as he had given them orders to do: ");
INSERT INTO engBBE_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","For they took him into the land of Canaan and put him to rest in the hollow rock in the field of Machpelah, which Abraham got with the field, for a resting-place, from Ephron the Hittite at Mamre. ");
INSERT INTO engBBE_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","And when his father had been put to rest, Joseph and his brothers and all who had gone with him, went back to Egypt. ");
INSERT INTO engBBE_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Now after the death of their father, Joseph's brothers said to themselves, It may be that Joseph's heart will be turned against us, and he will give us punishment for all the evil which we did to him. ");
INSERT INTO engBBE_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","So they sent word to Joseph, saying, Your father, before his death, gave us orders, saying, ");
INSERT INTO engBBE_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","You are to say to Joseph, Let the wrongdoing of your brothers be overlooked, and the evil they did to you: now, if it is your pleasure, let the sin of the servants of your father's God have forgiveness. And at these words, Joseph was overcome with weeping. ");
INSERT INTO engBBE_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Then his brothers went, and falling at his feet, said, Truly, we are your servants. ");
INSERT INTO engBBE_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","And Joseph said, Have no fear: am I in the place of God? ");
INSERT INTO engBBE_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","As for you, it was in your mind to do me evil, but God has given a happy outcome, the salvation of numbers of people, as you see today. ");
INSERT INTO engBBE_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","So now, have no fear: for I will take care of you and your little ones. So he gave them comfort with kind words. ");
INSERT INTO engBBE_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Now Joseph and all his father's family went on living in Egypt: and the years of Joseph's life were a hundred and ten. ");
INSERT INTO engBBE_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","And Joseph saw Ephraim's children of the third generation: and the children of Machir, the son of Manasseh, came to birth on Joseph's knees. ");
INSERT INTO engBBE_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Then Joseph said to his brothers, The time of my death has come; but God will keep you in mind and take you out of this land into the land which he gave by his oath to Abraham and Isaac and Jacob. ");
INSERT INTO engBBE_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Then Joseph made the children of Israel take an oath, saying, God will certainly give effect to his word, and you are to take my bones away from here. ");
INSERT INTO engBBE_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","So Joseph came to his death, being a hundred and ten years old: and they made his body ready, and he was put in a chest in Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Now these are the names of the sons of Israel who came into Egypt; every man and his family came with Jacob. ");
INSERT INTO engBBE_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuben, Simeon, Levi, and Judah; ");
INSERT INTO engBBE_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issachar, Zebulun, and Benjamin; ");
INSERT INTO engBBE_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan and Naphtali, Gad and Asher. ");
INSERT INTO engBBE_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","All the offspring of Jacob were seventy persons: and Joseph had come to Egypt before them. ");
INSERT INTO engBBE_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Then Joseph came to his end, and all his brothers, and all that generation. ");
INSERT INTO engBBE_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","And the children of Israel were fertile, increasing very greatly in numbers and in power; and the land was full of them. ");
INSERT INTO engBBE_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Now a new king came to power in Egypt, who had no knowledge of Joseph. ");
INSERT INTO engBBE_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","And he said to his people, See, the people of Israel are greater in number and in power than we are: ");
INSERT INTO engBBE_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Let us take care for fear that their numbers may become even greater, and if there is a war, they may be joined with those who are against us, and make an attack on us, and go up out of the land. ");
INSERT INTO engBBE_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","So they put overseers of forced work over them, in order to make their strength less by the weight of their work. And they made store-towns for Pharaoh, Pithom and Raamses. ");
INSERT INTO engBBE_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","But the more cruel they were to them, the more their number increased, till all the land was full of them. And the children of Israel were hated by the Egyptians. ");
INSERT INTO engBBE_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","And they gave the children of Israel even harder work to do: ");
INSERT INTO engBBE_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","And made their lives bitter with hard work, making building-material and bricks, and doing all sorts of work in the fields under the hardest conditions. ");
INSERT INTO engBBE_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","And the king of Egypt said to the Hebrew women who gave help at the time of childbirth (the name of the one was Shiphrah and the name of the other Puah), ");
INSERT INTO engBBE_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","When you are looking after the Hebrew women in childbirth, if it is a son you are to put him to death; but if it is a daughter, she may go on living. ");
INSERT INTO engBBE_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","But the women had the fear of God, and did not do as the king of Egypt said, but let the male children go on living. ");
INSERT INTO engBBE_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","And the king of Egypt sent for the women, and said to them, Why have you done this, and let the male children go on living? ");
INSERT INTO engBBE_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","And they said to Pharaoh, Because the Hebrew women are not like the Egyptian women, for they are strong, and the birth takes place before we come to them. ");
INSERT INTO engBBE_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","And the blessing of God was on these women: and the people were increased in number and became very strong. ");
INSERT INTO engBBE_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","And because the women who took care of the Hebrew mothers had the fear of God, he gave them families. ");
INSERT INTO engBBE_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","And Pharaoh gave orders to all his people, saying, Every son who comes to birth is to be put into the river, but every daughter may go on living. ");
INSERT INTO engBBE_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Now a man of the house of Levi took as his wife a daughter of Levi. ");
INSERT INTO engBBE_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","And she became with child and gave birth to a Son; and when she saw that he was a beautiful child, she kept him secretly for three months. ");
INSERT INTO engBBE_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","And when she was no longer able to keep him secret, she made him a basket out of the stems of water-plants, pasting sticky earth over it to keep the water out; and placing the baby in it she put it among the plants by the edge of the Nile. ");
INSERT INTO engBBE_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","And his sister took her place at a distance to see what would become of him. ");
INSERT INTO engBBE_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Now Pharaoh's daughter came down to the Nile to take a bath, while her women were walking by the riverside; and she saw the basket among the river-plants, and sent her servant-girl to get it. ");
INSERT INTO engBBE_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","And opening it, she saw the child, and he was crying. And she had pity on him, and said, This is one of the Hebrews' children. ");
INSERT INTO engBBE_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Then his sister said to Pharaoh's daughter, May I go and get you one of the Hebrew women to give him the breast? ");
INSERT INTO engBBE_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","And Pharaoh's daughter said to her, Go. And the girl went and got the child's mother. ");
INSERT INTO engBBE_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","And Pharaoh's daughter said to her, Take the child away and give it milk for me, and I will give you payment. And the woman took the child and gave it milk at her breast. ");
INSERT INTO engBBE_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","And when the child was older, she took him to Pharaoh's daughter and he became her son, and she gave him the name Moses, Because, she said, I took him out of the water. ");
INSERT INTO engBBE_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Now when Moses had become a man, one day he went out to his people and saw how hard their work was; and he saw an Egyptian giving blows to a Hebrew, one of his people. ");
INSERT INTO engBBE_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","And turning this way and that, and seeing no one, he put the Egyptian to death, covering his body with sand. ");
INSERT INTO engBBE_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","And he went out the day after and saw two of the Hebrews fighting: and he said to him who was in the wrong, Why are you fighting your brother? ");
INSERT INTO engBBE_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","And he said, Who made you a ruler and a judge over us? are you going to put me to death as you did the Egyptian? And Moses was in fear, and said, It is clear that the thing has come to light. ");
INSERT INTO engBBE_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Now when Pharaoh had news of this, he would have put Moses to death. But Moses went in flight from Pharaoh into the land of Midian: and he took his seat by a water-spring. ");
INSERT INTO engBBE_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Now the priest of Midian had seven daughters: and they came to get water for their father's flock. ");
INSERT INTO engBBE_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","And the keepers of the sheep came up and were driving them away; but Moses got up and came to their help, watering their flock for them. ");
INSERT INTO engBBE_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","And when they came to Reuel their father, he said, How is it that you have come back so quickly today? ");
INSERT INTO engBBE_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","And they said, An Egyptian came to our help against the keepers of sheep and got water for us and gave it to the flock. ");
INSERT INTO engBBE_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","And he said to his daughters, Where is he? why have you let the man go? make him come in and give him a meal. ");
INSERT INTO engBBE_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","And Moses was happy to go on living with the man; and he gave his daughter Zipporah to Moses. ");
INSERT INTO engBBE_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","And she gave birth to a son, to whom he gave the name Gershom: for he said, I have been living in a strange land. ");
INSERT INTO engBBE_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Now after a long time the king of Egypt came to his end: and the children of Israel were crying in their grief under the weight of their work, and their cry for help came to the ears of God. ");
INSERT INTO engBBE_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","And at the sound of their weeping the agreement which God had made with Abraham and Isaac and Jacob came to his mind. ");
INSERT INTO engBBE_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","And God's eyes were turned to the children of Israel and he gave them the knowledge of himself. ");
INSERT INTO engBBE_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Now Moses was looking after the flock of Jethro, his father-in-law, the priest of Midian: and he took the flock to the back of the waste land and came to Horeb, the mountain of God. ");
INSERT INTO engBBE_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","And the angel of the Lord was seen by him in a flame of fire coming out of a thorn-tree: and he saw that the tree was on fire, but it was not burned up. ");
INSERT INTO engBBE_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","And Moses said, I will go and see this strange thing, why the tree is not burned up, ");
INSERT INTO engBBE_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","And when the Lord saw him turning to one side to see, God said his name out of the tree, crying, Moses, Moses. And he said, Here am I. ");
INSERT INTO engBBE_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","And he said, Do not come near: take off your shoes from your feet, for the place where you are is holy. ");
INSERT INTO engBBE_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","And he said, I am the God of your fathers, the God of Abraham, the God of Isaac, and the God of Jacob. And Moses kept his face covered for fear of looking on God. ");
INSERT INTO engBBE_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","And God said, Truly, I have seen the grief of my people in Egypt, and their cry because of their cruel masters has come to my ears; for I have knowledge of their sorrows; ");
INSERT INTO engBBE_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","And I have come down to take them out of the hands of the Egyptians, guiding them out of that land into a good land and wide, into a land flowing with milk and honey; into the place of the Canaanite and the Hittite and the Amorite and the Perizzite and the Hivite and the Jebusite. ");
INSERT INTO engBBE_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","For now, truly, the cry of the children of Israel has come to me, and I have seen the cruel behaviour of the Egyptians to them. ");
INSERT INTO engBBE_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Come, then, and I will send you to Pharaoh, so that you may take my people, the children of Israel, out of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","And Moses said to God, Who am I to go to Pharaoh and take the children of Israel out of Egypt? ");
INSERT INTO engBBE_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","And he said, Truly I will be with you; and this will be the sign to you that I have sent you: when you have taken the children of Israel out of Egypt, you will give worship to God on this mountain. ");
INSERT INTO engBBE_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","And Moses said to God, When I come to the children of Israel and say to them, The God of your fathers has sent me to you: and they say to me, What is his name? what am I to say to them? ");
INSERT INTO engBBE_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","And God said to him, I AM WHAT I AM: and he said, Say to the children of Israel, I AM has sent me to you. ");
INSERT INTO engBBE_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","And God went on to say to Moses, Say to the children of Israel, The Lord, the God of your fathers, the God of Abraham, of Isaac, and of Jacob, has sent me to you: this is my name for ever, and this is my sign to all generations. ");
INSERT INTO engBBE_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Go and get together the chiefs of the children of Israel, and say to them, The Lord, the God of your fathers, the God of Abraham, of Isaac, and of Jacob, has been seen by me, and has said, Truly I have taken up your cause, because of what is done to you in Egypt; ");
INSERT INTO engBBE_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","And I have said, I will take you up out of the sorrows of Egypt into the land of the Canaanite and the Hittite and the Amorite and the Perizzite and the Hivite and the Jebusite, into a land flowing with milk and honey. ");
INSERT INTO engBBE_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","And they will give ear to your voice: and you, with the chiefs of Israel, will go to Pharaoh, the king of Egypt, and say to him, The Lord, the God of the Hebrews, has come to us: let us then go three days' journey into the waste land to make an offering to the Lord our God. ");
INSERT INTO engBBE_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","And I am certain that the king of Egypt will not let you go without being forced. ");
INSERT INTO engBBE_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","But I will put out my hand and overcome Egypt with all the wonders which I will do among them: and after that he will let you go. ");
INSERT INTO engBBE_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","And I will give this people grace in the eyes of the Egyptians, so that when you go out you will go out with your hands full. ");
INSERT INTO engBBE_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","For every woman will get from her neighbour and from the woman living in her house, ornaments of silver and gold, and clothing; and you will put them on your sons and your daughters; you will take the best of their goods from the Egyptians. ");
INSERT INTO engBBE_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","And Moses, answering, said, It is certain that they will not have faith in me or give ear to my voice; for they will say, You have not seen the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","And the Lord said to him, What is that in your hand? And he said, A rod. ");
INSERT INTO engBBE_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","And he said, Put it down on the earth. And he put it down on the earth and it became a snake; and Moses went running from it. ");
INSERT INTO engBBE_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","And the Lord said to Moses, Put out your hand and take it by the tail: (and he put out his hand and took a grip of it and it became a rod in his hand:) ");
INSERT INTO engBBE_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","So that they may be certain that the Lord, the God of their fathers, the God of Abraham, of Isaac, and of Jacob, has been seen by you. ");
INSERT INTO engBBE_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Then the Lord said to him again, Put your hand inside your clothing. And he put his hand inside his robe: and when he took it out it was like the hand of a leper, as white as snow. ");
INSERT INTO engBBE_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","And he said, Put your hand inside your robe again. (And he put his hand into his robe again, and when he took it out he saw that it had become like his other flesh.) ");
INSERT INTO engBBE_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","And if they do not have faith in you or give ear to the voice of the first sign, they will have faith in the second sign. ");
INSERT INTO engBBE_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","And if they have no faith even in these two signs and will not give ear to your voice, then you are to take the water of the Nile and put it on the dry land: and the water you take out of the river will become blood on the dry land. ");
INSERT INTO engBBE_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","And Moses said to the Lord, O Lord, I am not a man of words; I have never been so, and am not now, even after what you have said to your servant: for talking is hard for me, and I am slow of tongue. ");
INSERT INTO engBBE_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","And the Lord said to him, Who has made man's mouth? who takes away a man's voice or hearing, or makes him seeing or blind? Is it not I, the Lord? ");
INSERT INTO engBBE_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","So go now, and I will be with your mouth, teaching you what to say. ");
INSERT INTO engBBE_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","And he said, O Lord, send, if you will, by the hand of anyone whom it seems good to you to send. ");
INSERT INTO engBBE_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","And the Lord was angry with Moses, and said, Is there not Aaron, your brother, the Levite? To my knowledge he is good at talking. And now he is coming out to you: and when he sees you he will be glad in his heart. ");
INSERT INTO engBBE_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Let him give ear to your voice, and you will put my words in his mouth; and I will be with your mouth and with his, teaching you what you have to do. ");
INSERT INTO engBBE_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","And he will do the talking for you to the people: he will be to you as a mouth and you will be to him as God. ");
INSERT INTO engBBE_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","And take in your hand this rod with which you will do the signs. ");
INSERT INTO engBBE_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","And Moses went back to Jethro, his father-in-law, and said to him, Let me go back now to my relations in Egypt and see if they are still living. And Jethro said to Moses, Go in peace. ");
INSERT INTO engBBE_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","And the Lord said to Moses in Midian, Go back to Egypt, for all the men are dead who were attempting to take your life. ");
INSERT INTO engBBE_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","And Moses took his wife and his sons and put them on an ass and went back to the land of Egypt: and he took the rod of God in his hand. ");
INSERT INTO engBBE_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","And the Lord said to Moses, When you go back to Egypt, see that you do before Pharaoh all the wonders which I have given you power to do: but I will make his heart hard and he will not let the people go. ");
INSERT INTO engBBE_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","And you are to say to Pharaoh, The Lord says, Israel is the first of my sons: ");
INSERT INTO engBBE_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","And I said to you, Let my son go, so that he may give me worship; and you did not let him go: so now I will put the first of your sons to death. ");
INSERT INTO engBBE_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Now on the journey, at the night's resting-place, the Lord came in his way and would have put him to death. ");
INSERT INTO engBBE_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Then Zipporah took a sharp stone, and cutting off the skin of her son's private parts, and touching his feet with it, she said, Truly you are a husband of blood to me. ");
INSERT INTO engBBE_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","So he let him go. Then she said, You are a husband of blood because of the circumcision. ");
INSERT INTO engBBE_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","And the Lord said to Aaron, Go into the waste land and you will see Moses. So he went and came across Moses at the mountain of God, and gave him a kiss. ");
INSERT INTO engBBE_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","And Moses gave Aaron an account of all the words of the Lord which he had sent him to say, and of all the signs which he had given him orders to do. ");
INSERT INTO engBBE_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Then Moses and Aaron went and got together all the chiefs of the children of Israel: ");
INSERT INTO engBBE_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","And Aaron said to them all the words the Lord had said to Moses, and did the signs before all the people. ");
INSERT INTO engBBE_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","And the people had faith in them; and hearing that the Lord had taken up the cause of the children of Israel and had seen their troubles, with bent heads they gave him worship. ");
INSERT INTO engBBE_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","And after that, Moses and Aaron came to Pharaoh, and said, The Lord, the God of Israel, says, Let my people go so that they may keep a feast to me in the waste land. ");
INSERT INTO engBBE_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","And Pharaoh said, Who is the Lord, to whose voice I am to give ear and let Israel go? I have no knowledge of the Lord and I will not let Israel go. ");
INSERT INTO engBBE_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","And they said, The God of the Hebrews has come to us: let us then go three days' journey into the waste land to make an offering to the Lord our God, so that he may not send death on us by disease or the sword. ");
INSERT INTO engBBE_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","And the king of Egypt said to them, Why do you, Moses and Aaron, take the people away from their work? get back to your work. ");
INSERT INTO engBBE_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","And Pharaoh said, Truly, the people of the land are increasing in number, and you are keeping them back from their work. ");
INSERT INTO engBBE_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","The same day Pharaoh gave orders to the overseers and those who were responsible for the work, saying, ");
INSERT INTO engBBE_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Give these men no more dry stems for their brick-making as you have been doing; let them go and get the material for themselves. ");
INSERT INTO engBBE_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","But see that they make the same number of bricks as before, and no less: for they have no love for work; and so they are crying out and saying, Let us go and make an offering to our God. ");
INSERT INTO engBBE_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Give the men harder work, and see that they do it; let them not give attention to false words. ");
INSERT INTO engBBE_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","And the overseers of the people and their responsible men went out and said to the people, Pharaoh says, I will give you no more dry stems. ");
INSERT INTO engBBE_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Go yourselves and get dry stems wherever you are able; for your work is not to be any less. ");
INSERT INTO engBBE_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","So the people were sent in all directions through the land of Egypt to get dry grass for stems. ");
INSERT INTO engBBE_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","And the overseers went on driving them and saying, Do your full day's work as before when there were dry stems for you. ");
INSERT INTO engBBE_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","And the responsible men of the children of Israel, whom Pharaoh's overseers had put over them, were given blows, and they said to them, Why have you not done your regular work, in making bricks as before? ");
INSERT INTO engBBE_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Then the responsible men of the children of Israel came to Pharaoh, protesting and saying, Why are you acting in this way to your servants? ");
INSERT INTO engBBE_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","They give us no dry stems and they say to us, Make bricks: and they give your servants blows; but it is your people who are in the wrong. ");
INSERT INTO engBBE_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","But he said, You have no love for work: that is why you say, Let us go and make an offering to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Go now, get back to your work; no dry stems will be given to you, but you are to make the full number of bricks. ");
INSERT INTO engBBE_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Then the responsible men of the children of Israel saw that they were purposing evil when they said, The number of bricks which you have to make every day will be no less than before. ");
INSERT INTO engBBE_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","And they came face to face with Moses and Aaron, who were in their way when they came out from Pharaoh: ");
INSERT INTO engBBE_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","And they said to them, May the Lord take note of you and be your judge; for you have given Pharaoh and his servants a bad opinion of us, putting a sword in their hands for our destruction. ");
INSERT INTO engBBE_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","And Moses went back to the Lord and said, Lord, why have you done evil to this people? why have you sent me? ");
INSERT INTO engBBE_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","For from the time when I came to Pharaoh to put your words before him, he has done evil to this people, and you have given them no help. ");
INSERT INTO engBBE_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","And the Lord said to Moses, Now you will see what I am about to do to Pharaoh; for by a strong hand he will be forced to let them go, driving them out of his land because of my outstretched arm. ");
INSERT INTO engBBE_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","And God said to Moses, I am Yahweh: ");
INSERT INTO engBBE_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","I let myself be seen by Abraham, Isaac, and Jacob, as God, the Ruler of all; but they had no knowledge of my name Yahweh. ");
INSERT INTO engBBE_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","And I made an agreement with them, to give them the land of Canaan, the land of their wanderings. ");
INSERT INTO engBBE_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","And truly my ears are open to the cry of the children of Israel whom the Egyptians keep under their yoke; and I have kept in mind my agreement. ");
INSERT INTO engBBE_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Say then to the children of Israel, I am Yahweh, and I will take you out from under the yoke of the Egyptians, and make you safe from their power, and will make you free by the strength of my arm after great punishments. ");
INSERT INTO engBBE_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","And I will take you to be my people and I will be your God; and you will be certain that I am the Lord your God, who takes you out from under the yoke of the Egyptians. ");
INSERT INTO engBBE_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","And I will be your guide into the land which I made an oath to give to Abraham, to Isaac, and to Jacob; and I will give it to you for your heritage: I am Yahweh. ");
INSERT INTO engBBE_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","And Moses said these words to the children of Israel, but they gave no attention to him, because of the grief of their spirit and the cruel weight of their work. ");
INSERT INTO engBBE_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Go in and say to Pharaoh, king of Egypt, that he is to let the children of Israel go out of his land. ");
INSERT INTO engBBE_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","And Moses, answering the Lord, said, See, the children of Israel will not give ear to me; how then will Pharaoh give ear to me, whose lips are unclean? ");
INSERT INTO engBBE_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","And the word of the Lord came to Moses and Aaron, with orders for the children of Israel and for Pharaoh, king of Egypt, to take the children of Israel out of the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","These are the heads of their fathers' families: the sons of Reuben the oldest son of Israel: Hanoch and Pallu, Hezron and Carmi: these are the families of Reuben. ");
INSERT INTO engBBE_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","And the sons of Simeon: Jemuel and Jamin and Ohad and Jachin and Zohar and Shaul, the son of a woman of Canaan: these are the families of Simeon. ");
INSERT INTO engBBE_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","And these are the names of the sons of Levi in the order of their generations: Gershon and Kohath and Merari: and the years of Levi's life were a hundred and thirty-seven. ");
INSERT INTO engBBE_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","The sons of Gershon: Libni and Shimei, in the order of their families. ");
INSERT INTO engBBE_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","And the sons of Kohath: Amram and Izhar and Hebron and Uzziel: and the years of Kohath's life were a hundred and thirty-three. ");
INSERT INTO engBBE_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","And the sons of Merari: Mahli and Mushi: these are the families of the Levites, in the order of their generations. ");
INSERT INTO engBBE_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","And Amram took Jochebed, his father's sister, as wife; and she gave birth to Aaron and Moses: and the years of Amram's life were a hundred and thirty-seven. ");
INSERT INTO engBBE_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","And the sons of Izhar: Korah and Nepheg and Zichri. ");
INSERT INTO engBBE_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","And the sons of Uzziel: Mishael and Elzaphan and Sithri. ");
INSERT INTO engBBE_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","And Aaron took as his wife Elisheba, the daughter of Amminadab, the sister of Nahshon; and she gave birth to Nadab and Abihu, Eleazar and Ithamar. ");
INSERT INTO engBBE_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","And the sons of Korah: Assir and Elkanah and Abiasaph: these are the families of the Korahites. ");
INSERT INTO engBBE_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","And Eleazar, Aaron's son, took as his wife one of the daughters of Putiel; and she gave birth to Phinehas. These are the heads of the families of the Levites, in the order of their families. ");
INSERT INTO engBBE_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","These are the same Aaron and Moses to whom the Lord said, Take the children of Israel out of the land of Egypt in their armies. ");
INSERT INTO engBBE_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","These are the men who gave orders to Pharaoh to let the children of Israel go out of Egypt: these are the same Moses and Aaron. ");
INSERT INTO engBBE_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","And on the day when the word of the Lord came to Moses in the land of Egypt, ");
INSERT INTO engBBE_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","The Lord said to Moses, I am the Lord: say to Pharaoh, king of Egypt, everything I am saying to you. ");
INSERT INTO engBBE_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","And Moses said to the Lord, My lips are unclean; how is it possible that Pharaoh will give me a hearing? ");
INSERT INTO engBBE_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","And the Lord said to Moses, See I have made you a god to Pharaoh, and Aaron your brother will be your prophet. ");
INSERT INTO engBBE_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Say whatever I give you orders to say: and Aaron your brother will give word to Pharaoh to let the children of Israel go out of his land. ");
INSERT INTO engBBE_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","And I will make Pharaoh's heart hard, and my signs and wonders will be increased in the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","But Pharaoh will not give ear to you, and I will put my hand on Egypt, and take my armies, my people, the children of Israel, out of Egypt, after great punishments. ");
INSERT INTO engBBE_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","And the Egyptians will see that I am the Lord, when my hand is stretched out over Egypt, and I take the children of Israel out from among them. ");
INSERT INTO engBBE_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","And Moses and Aaron did so: as the Lord gave them orders, so they did. ");
INSERT INTO engBBE_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","And Moses was eighty years old, and Aaron eighty-three years old, when they gave the Lord's word to Pharaoh. ");
INSERT INTO engBBE_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","And the Lord said to Moses and Aaron, ");
INSERT INTO engBBE_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","If Pharaoh says to you, Let me see a wonder: then say to Aaron, Take your rod and put it down on the earth before Pharaoh so that it may become a snake. ");
INSERT INTO engBBE_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Then Moses and Aaron went in to Pharaoh and they did as the Lord had said: and Aaron put his rod down on the earth before Pharaoh and his servants, and it became a snake. ");
INSERT INTO engBBE_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Then Pharaoh sent for the wise men and the wonder-workers, and they, the wonder-workers of Egypt, did the same with their secret arts. ");
INSERT INTO engBBE_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","For every one of them put down his rod on the earth, and they became snakes: but Aaron's rod made a meal of their rods. ");
INSERT INTO engBBE_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","But Pharaoh's heart was made hard, and he did not give ear to them, as the Lord had said. ");
INSERT INTO engBBE_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","And the Lord said to Moses and Aaron, Pharaoh's heart is unchanged; he will not let the people go. ");
INSERT INTO engBBE_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Go to Pharaoh in the morning; when he goes out to the water, you will be waiting for him by the edge of the Nile, with the rod which was turned into a snake in your hand; ");
INSERT INTO engBBE_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","And say to him, The Lord, the God of the Hebrews, has sent me to you, saying, Let my people go so that they may give me worship in the waste land; but up to now you have not given ear to his words. ");
INSERT INTO engBBE_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","So the Lord says, By this you may be certain that I am the Lord; see, by the touch of this rod in my hand the waters of the Nile will be turned to blood; ");
INSERT INTO engBBE_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","And the fish in the Nile will come to destruction, and the river will send up a bad smell, and the Egyptians will not be able, for disgust, to make use of the water of the Nile for drinking. ");
INSERT INTO engBBE_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","And the Lord said, Say to Aaron, Let the rod in your hand be stretched out over the waters of Egypt, and over the rivers and the streams and the pools, and over every stretch of water, so that they may be turned to blood; and there will be blood through all the land of Egypt, in vessels of wood and in vessels of stone. ");
INSERT INTO engBBE_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","And Moses and Aaron did as the Lord had said; and when his rod had been lifted up and stretched out over the waters of the Nile before the eyes of Pharaoh and his servants, all the water in the Nile was turned to blood; ");
INSERT INTO engBBE_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","And the fish in the Nile came to destruction, and a bad smell went up from the river, and the Egyptians were not able to make use of the water of the Nile for drinking; and there was blood through all the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","And the wonder-workers of Egypt did the same with their secret arts: but Pharaoh's heart was made hard, and he would not give ear to them, as the Lord had said. ");
INSERT INTO engBBE_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Then Pharaoh went into his house, and did not take even this to heart. ");
INSERT INTO engBBE_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","And all the Egyptians made holes round about the Nile to get drinking-water, for they were not able to make use of the Nile water. ");
INSERT INTO engBBE_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","And seven days went past, after the Lord had put his hand on the Nile. ");
INSERT INTO engBBE_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","And this is what the Lord said to Moses: Go to Pharaoh and say to him, The Lord says, Let my people go so that they may give me worship. ");
INSERT INTO engBBE_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","And if you will not let them go, see, I will send frogs into every part of your land: ");
INSERT INTO engBBE_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","The Nile will be full of frogs, and they will come up into your house and into your bedrooms and on your bed, and into the houses of your servants and your people, and into your ovens and into your bread-basins. ");
INSERT INTO engBBE_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","The frogs will come up over you and your people and all your servants. ");
INSERT INTO engBBE_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","And the Lord said to Moses, Say to Aaron, Let the rod in your hand be stretched out over the streams and the waterways and the pools, causing frogs to come up on the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","And when Aaron put out his hand over the waters of Egypt, the frogs came up and all the land of Egypt was covered with them. ");
INSERT INTO engBBE_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","And the wonder-workers did the same with their secret arts, making frogs come up over the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Then Pharaoh sent for Moses and Aaron and said, Make prayer to the Lord that he will take away these frogs from me and my people; and I will let the people go and make their offering to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","And Moses said, I will let you have the honour of saying when I am to make prayer for you and your servants and your people, that the frogs may be sent away from you and your houses, and be only in the Nile. ");
INSERT INTO engBBE_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","And he said, By tomorrow. And he said, Let it be as you say: so that you may see that there is no other like the Lord our God. ");
INSERT INTO engBBE_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","And the frogs will be gone from you and from your houses and from your servants and from your people and will be only in the Nile. ");
INSERT INTO engBBE_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Then Moses and Aaron went out from Pharaoh; and Moses made prayer to the Lord about the frogs which he had sent on Pharaoh. ");
INSERT INTO engBBE_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","And the Lord did as Moses said; and there was an end of all the frogs in the houses and in the open spaces and in the fields. ");
INSERT INTO engBBE_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","And they put them together in masses, and a bad smell went up from the land. ");
INSERT INTO engBBE_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","But when Pharaoh saw that there was peace for a time, he made his heart hard and did not give ear to them, as the Lord had said. ");
INSERT INTO engBBE_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","And the Lord said to Moses, Say to Aaron, Let your rod be stretched out over the dust of the earth so that it may become insects through all the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","And they did so; and Aaron, stretching out the rod in his hand, gave a touch to the dust of the earth, and insects came on man and on beast; all the dust of the earth was changed into insects through all the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","And the wonder-workers with their secret arts, attempting to make insects, were unable to do so: and there were insects on man and on beast. ");
INSERT INTO engBBE_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Then the wonder-workers said to Pharaoh, This is the finger of God: but Pharaoh's heart was hard, and he did not give ear to them, as the Lord had said. ");
INSERT INTO engBBE_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","And the Lord said to Moses, Get up early in the morning and take your place before Pharaoh when he comes out to the water; and say to him, This is what the Lord says: Let my people go to give me worship. ");
INSERT INTO engBBE_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","For if you do not let my people go, see, I will send clouds of flies on you and on your servants and on your people and into their houses; and the houses of the Egyptians and the land where they are will be full of flies. ");
INSERT INTO engBBE_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","And at that time I will make a division between your land and the land of Goshen where my people are, and no flies will be there; so that you may see that I am the Lord over all the earth. ");
INSERT INTO engBBE_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","And I will put a division between my people and your people; tomorrow this sign will be seen. ");
INSERT INTO engBBE_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","And the Lord did so; and great clouds of flies came into the house of Pharaoh and into his servants' houses, and all the land of Egypt was made waste because of the flies. ");
INSERT INTO engBBE_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","And Pharaoh sent for Moses and Aaron and said, Go and make your offering to your God here in the land. ");
INSERT INTO engBBE_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","And Moses said, It is not right to do so; for we make our offerings of that to which the Egyptians give worship; and if we do so before their eyes, certainly we will be stoned. ");
INSERT INTO engBBE_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","But we will go three days' journey into the waste land and make an offering to the Lord our God as he may give us orders. ");
INSERT INTO engBBE_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Then Pharaoh said, I will let you go to make an offering to the Lord your God in the waste land; but do not go very far away, and make prayer for me. ");
INSERT INTO engBBE_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","And Moses said, When I go out from you I will make prayer to the Lord that the cloud of flies may go away from Pharaoh and from his people and from his servants tomorrow: only let Pharaoh no longer by deceit keep back the people from making their offering to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Then Moses went out from Pharaoh and made prayer to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","And the Lord did as Moses said, and took away the cloud of flies from Pharaoh and from his servants and from his people; not one was to be seen. ");
INSERT INTO engBBE_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","But again Pharaoh made his heart hard and did not let the people go. ");
INSERT INTO engBBE_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Then the Lord said to Moses, Go in to Pharaoh and say to him, This is what the Lord, the God of the Hebrews, says: Let my people go so that they may give me worship. ");
INSERT INTO engBBE_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","For if you will not let them go, but still keep them in your power, ");
INSERT INTO engBBE_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Then the hand of the Lord will put on your cattle in the field, on the horses and the asses and the camels, on the herds and the flocks, a very evil disease. ");
INSERT INTO engBBE_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","And the Lord will make a division between the cattle of Israel and the cattle of Egypt; there will be no loss of any of the cattle of Israel. ");
INSERT INTO engBBE_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","And the time was fixed by the Lord, and he said, Tomorrow the Lord will do this thing in the land. ");
INSERT INTO engBBE_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","And on the day after, the Lord did as he had said, causing the death of all the cattle of Egypt, but there was no loss of any of the cattle of Israel. ");
INSERT INTO engBBE_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","And Pharaoh sent and got word that there was no loss of any of the cattle of Israel. But the heart of Pharaoh was hard and he did not let the people go. ");
INSERT INTO engBBE_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","And the Lord said to Moses and to Aaron, Take in your hand a little dust from the fire and let Moses send it in a shower up to heaven before the eyes of Pharaoh. ");
INSERT INTO engBBE_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","And it will become small dust over all the land of Egypt, and will be a skin-disease bursting out in wounds on man and beast through all the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","So they took some dust from the fire, and placing themselves before Pharaoh, Moses sent it out in a shower up to heaven; and it became a skin-disease bursting out on man and on beast. ");
INSERT INTO engBBE_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","And the wonder-workers were not able to take their places before Moses, because of the disease; for the disease was on the wonder-workers and on all the Egyptians. ");
INSERT INTO engBBE_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","And the Lord made Pharaoh's heart hard, and he would not give ear to them, as the Lord had said. ");
INSERT INTO engBBE_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","And the Lord said to Moses, Get up early in the morning and take your place before Pharaoh, and say to him, This is what the Lord, the God of the Hebrews, says: Let my people go so that they may give me worship. ");
INSERT INTO engBBE_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","For this time I will send all my punishments on yourself and on your servants and on your people; so that you may see that there is no other like me in all the earth. ");
INSERT INTO engBBE_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","For if I had put the full weight of my hand on you and your people, you would have been cut off from the earth: ");
INSERT INTO engBBE_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","But, for this very reason, I have kept you from destruction, to make clear to you my power, and so that my name may be honoured through all the earth. ");
INSERT INTO engBBE_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Are you still uplifted in pride against my people so that you will not let them go? ");
INSERT INTO engBBE_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Truly, tomorrow about this time I will send down an ice-storm, such as never was in Egypt from its earliest days till now. ");
INSERT INTO engBBE_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Then send quickly and get in your cattle and all you have from the fields; for if any man or beast in the field has not been put under cover, the ice-storm will come down on them with destruction. ");
INSERT INTO engBBE_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Then everyone among the servants of Pharaoh who had the fear of the Lord, made his servants and his cattle come quickly into the house: ");
INSERT INTO engBBE_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","And he who gave no attention to the word of the Lord, kept his servants and his cattle in the field. ");
INSERT INTO engBBE_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","And the Lord said to Moses, Now let your hand be stretched out to heaven so that there may be an ice-storm on all the land of Egypt, on man and on beast and on every plant of the field through all the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","And Moses put out his rod to heaven: and the Lord sent thunder, and an ice-storm, and fire running down on the earth; the Lord sent an ice-storm on the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","So there was an ice-storm with fire running through it, coming down with great force, such as never was in all the land of Egypt from the time when it became a nation. ");
INSERT INTO engBBE_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","And through all the land of Egypt the ice-storm came down on everything which was in the fields, on man and on beast; and every green plant was crushed and every tree of the field broken. ");
INSERT INTO engBBE_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Only in the land of Goshen, where the children of Israel were, there was no ice-storm. ");
INSERT INTO engBBE_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Then Pharaoh sent for Moses and Aaron, and said to them, I have done evil this time: the Lord is upright, and I and my people are sinners. ");
INSERT INTO engBBE_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Make prayer to the Lord; for there has been enough of these thunderings of God and this ice-storm; and I will let you go and will keep you no longer. ");
INSERT INTO engBBE_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","And Moses said, When I am gone outside the town, my hands will be stretched out to the Lord; the thunders and the ice-storm will come to an end, so that you may see that the earth is the Lord's. ");
INSERT INTO engBBE_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","But as for you and your servants, I am certain that even now the fear of the Lord God will not be in your hearts. ");
INSERT INTO engBBE_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","And the flax and the barley were damaged, for the barley was almost ready to be cut and the flax was in flower. ");
INSERT INTO engBBE_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","But the rest of the grain-plants were undamaged, for they had not come up. ");
INSERT INTO engBBE_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","So Moses went out of the town, and stretching out his hands made prayer to God: and the thunders and the ice-storm came to an end; and the fall of rain was stopped. ");
INSERT INTO engBBE_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","But when Pharaoh saw that the rain and the ice-storm and the thunders were ended, he went on sinning, and made his heart hard, he and his servants. ");
INSERT INTO engBBE_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","And the heart of Pharaoh was hard, and he did not let the people go, as the Lord had said by the mouth of Moses. ");
INSERT INTO engBBE_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","And the Lord said to Moses, Go in to Pharaoh: for I have made his heart and the hearts of his servants hard, so that I may let my signs be seen among them: ");
INSERT INTO engBBE_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","And so that you may be able to give to your son and to your son's son the story of my wonders in Egypt, and the signs which I have done among them; so that you may see that I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Then Moses and Aaron went in to Pharaoh, and said to him, This is what the Lord, the God of the Hebrews, says: How long will you be lifted up in your pride before me? let my people go so that they may give me worship. ");
INSERT INTO engBBE_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","For if you will not let my people go, tomorrow I will send locusts into your land: ");
INSERT INTO engBBE_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","And the face of the earth will be covered with them, so that you will not be able to see the earth: and they will be the destruction of everything which up to now has not been damaged, everything which was not crushed by the ice-storm, and every tree still living in your fields. ");
INSERT INTO engBBE_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","And your houses will be full of them, and the houses of your servants and of all the Egyptians; it will be worse than anything your fathers have seen or their fathers, from the day when they were living on the earth till this day. And so he went out from Pharaoh. ");
INSERT INTO engBBE_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","And Pharaoh's servants said to him, How long is this man to be the cause of evil to us? let the men go so that they may give worship to the Lord their God: are you not awake to Egypt's danger? ");
INSERT INTO engBBE_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Then Moses and Aaron came in again before Pharaoh: and he said to them, Go and give worship to the Lord your God: but which of you are going? ");
INSERT INTO engBBE_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","And Moses said, We will go with our young and our old, with our sons and our daughters, with our flocks and our herds; for we are to keep a feast to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","And he said to them, May the Lord be with you, if I will let you and your little ones go! take care, for your purpose clearly is evil. ");
INSERT INTO engBBE_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Not so; but let your males go and give worship to the Lord, as your desire is. This he said, driving them out from before him. ");
INSERT INTO engBBE_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","And the Lord said to Moses, Let your hand be stretched out over the land of Egypt so that the locusts may come up on the land for the destruction of every green plant in the land, even everything untouched by the ice-storm. ");
INSERT INTO engBBE_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","And Moses' rod was stretched out over the land of Egypt, and the Lord sent an east wind over the land all that day and all the night; and in the morning the locusts came up with the east wind. ");
INSERT INTO engBBE_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","And the locusts went up over all the land of Egypt, resting on every part of the land, in very great numbers; such an army of locusts had never been seen before, and never will be again. ");
INSERT INTO engBBE_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","For all the face of the earth was covered with them, so that the land was black; and every green plant and all the fruit of the trees which was untouched by the ice-storm they took for food: not one green thing, no plant or tree, was to be seen in all the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Then Pharaoh quickly sent for Moses and Aaron, and said, I have done evil against the Lord your God and against you. ");
INSERT INTO engBBE_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Let me now have forgiveness for my sin this time only, and make prayer to the Lord your God that he will take away from me this death only. ");
INSERT INTO engBBE_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","So he went out from Pharaoh and made prayer to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","And the Lord sent a very strong west wind, which took up the locusts, driving them into the Red Sea; not one locust was to be seen in any part of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","But the Lord made Pharaoh's heart hard, and he did not let the children of Israel go. ");
INSERT INTO engBBE_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","And the Lord said to Moses, Let your hand be stretched out to heaven, and all the land of Egypt will be dark, so that men will be feeling their way about in the dark. ");
INSERT INTO engBBE_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","And when Moses' hand was stretched out, dark night came over all the land of Egypt for three days; ");
INSERT INTO engBBE_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","They were not able to see one another, and no one got up from his place for three days: but where the children of Israel were living it was light. ");
INSERT INTO engBBE_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Then Pharaoh sent for Moses, and said, Go and give worship to the Lord; only let your flocks and your herds be kept here: your little ones may go with you. ");
INSERT INTO engBBE_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","But Moses said, You will have to let us take burned offerings to put before the Lord our God. ");
INSERT INTO engBBE_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","So our cattle will have to go with us, not one may be kept back; for they are needed for the worship of the Lord our God; we have no knowledge what offering we have to give till we come to the place. ");
INSERT INTO engBBE_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","But the Lord made Pharaoh's heart hard, and he would not let them go. ");
INSERT INTO engBBE_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","And Pharaoh said to him, Go away from me, take care that you come not again before me; for the day when you see my face again will be your last. ");
INSERT INTO engBBE_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","And Moses said, You say truly; I will not see your face again. ");
INSERT INTO engBBE_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","And the Lord said to Moses, I will send one more punishment on Pharaoh and on Egypt; after that he will let you go; and when he does let you go, he will not keep one of you back, but will send you out by force. ");
INSERT INTO engBBE_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","So go now and give orders to the people that every man and every woman is to get from his or her neighbour ornaments of silver and of gold. ");
INSERT INTO engBBE_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","And the Lord gave the people grace in the eyes of the Egyptians. For the man Moses was highly honoured in the land of Egypt, by Pharaoh's servants and the people. ");
INSERT INTO engBBE_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","And Moses said, This is what the Lord says: About the middle of the night I will go out through Egypt: ");
INSERT INTO engBBE_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","And death will come to every mother's first male child in all the land of Egypt, from the child of Pharaoh on his seat of power, to the child of the servant-girl crushing the grain; and the first births of all the cattle. ");
INSERT INTO engBBE_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","And there will be a great cry through all the land of Egypt, such as never has been or will be again. ");
INSERT INTO engBBE_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","But against the children of Israel, man or beast, not so much as the tongue of a dog will be moved: so that you may see how the Lord makes a division between Israel and the Egyptians. ");
INSERT INTO engBBE_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","And all these your servants will come to me, going down on their faces before me and saying, Go out, and all your people with you: and after that I will go out. And he went away from Pharaoh burning with wrath. ");
INSERT INTO engBBE_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","And the Lord said to Moses, Pharaoh will not give ear to you, so that my wonders may be increased in the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","All these wonders Moses and Aaron did before Pharaoh: but the Lord made Pharaoh's heart hard, and he did not let the children of Israel go out of his land. ");
INSERT INTO engBBE_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","And the Lord said to Moses and Aaron in the land of Egypt, ");
INSERT INTO engBBE_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Let this month be to you the first of months, the first month of the year. ");
INSERT INTO engBBE_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Say to all the children of Israel when they are come together, In the tenth day of this month every man is to take a lamb, by the number of their fathers' families, a lamb for every family: ");
INSERT INTO engBBE_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","And if the lamb is more than enough for the family, let that family and its nearest neighbour have a lamb between them, taking into account the number of persons and how much food is needed for every man. ");
INSERT INTO engBBE_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Let your lamb be without a mark, a male in its first year: you may take it from among the sheep or the goats: ");
INSERT INTO engBBE_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Keep it till the fourteenth day of the same month, when everyone who is of the children of Israel is to put it to death between sundown and dark. ");
INSERT INTO engBBE_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Then take some of the blood and put it on the two sides of the door and over the door of the house where the meal is to be taken. ");
INSERT INTO engBBE_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","And let your food that night be the flesh of the lamb, cooked with fire in the oven, together with unleavened bread and bitter-tasting plants. ");
INSERT INTO engBBE_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Do not take it uncooked or cooked with boiling water, but let it be cooked in the oven; its head with its legs and its inside parts. ");
INSERT INTO engBBE_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Do not keep any of it till the morning; anything which is not used is to be burned with fire. ");
INSERT INTO engBBE_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","And take your meal dressed as if for a journey, with your shoes on your feet and your sticks in your hands: take it quickly: it is the Lord's Passover. ");
INSERT INTO engBBE_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","For on that night I will go through the land of Egypt, sending death on every first male child, of man and of beast, and judging all the gods of Egypt: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","And the blood will be a sign on the houses where you are: when I see the blood I will go over you, and no evil will come on you for your destruction, when my hand is on the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","And this day is to be kept in your memories: you are to keep it as a feast to the Lord through all your generations, as an order for ever. ");
INSERT INTO engBBE_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","For seven days let your food be unleavened bread; from the first day no leaven is to be seen in your houses: whoever takes bread with leaven in it, from the first till the seventh day, will be cut off from Israel. ");
INSERT INTO engBBE_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","And on the first day there is to be a holy meeting and on the seventh day a holy meeting; no sort of work may be done on those days but only to make ready what is necessary for everyone's food. ");
INSERT INTO engBBE_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","So keep the feast of unleavened bread; for on this very day I have taken your armies out of the land of Egypt: this day, then, is to be kept through all your generations by an order for ever. ");
INSERT INTO engBBE_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","In the first month, from the evening of the fourteenth day, let your food be unleavened bread till the evening of the twenty-first day of the month. ");
INSERT INTO engBBE_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","For seven days no leaven is to be seen in your houses: for whoever takes bread which is leavened will be cut off from the people of Israel, if he is from another country or if he is an Israelite by birth. ");
INSERT INTO engBBE_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Take nothing which has leaven in it; wherever you are living let your food be unleavened cakes. ");
INSERT INTO engBBE_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Then Moses sent for the chiefs of Israel, and said to them, See that lambs are marked out for yourselves and your families, and let the Passover lamb be put to death. ");
INSERT INTO engBBE_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","And take some hyssop and put it in the blood in the basin, touching the two sides and the top of the doorway with the blood from the basin; and let not one of you go out of his house till the morning. ");
INSERT INTO engBBE_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","For the Lord will go through the land, sending death on the Egyptians; and when he sees the blood on the two sides and the top of the door, the Lord will go over your door and will not let death come in for your destruction. ");
INSERT INTO engBBE_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","And you are to keep this as an order to you and to your sons for ever. ");
INSERT INTO engBBE_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","And when you come into the land which the Lord will make yours, as he gave his word, you are to keep this act of worship. ");
INSERT INTO engBBE_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","And when your children say to you, What is the reason of this act of worship? ");
INSERT INTO engBBE_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Then you will say, This is the offering of the Lord's Passover; for he went over the houses of the children of Israel in Egypt, when he sent death on the Egyptians, and kept our families safe. And the people gave worship with bent heads. ");
INSERT INTO engBBE_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","And the children of Israel went and did so; as the Lord had given orders to Moses and Aaron, so they did. ");
INSERT INTO engBBE_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","And in the middle of the night the Lord sent death on every first male child in the land of Egypt, from the child of Pharaoh on his seat of power to the child of the prisoner in the prison; and the first births of all the cattle. ");
INSERT INTO engBBE_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Then Pharaoh got up in the night, he and all his servants and all the Egyptians; and a great cry went up from Egypt; for there was not a house where someone was not dead. ");
INSERT INTO engBBE_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","And he sent for Moses and Aaron by night, and said, Get up and go out from among my people, you and the children of Israel; go and give worship to the Lord as you have said. ");
INSERT INTO engBBE_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","And take your flocks and your herds as you have said, and be gone; and give me your blessing. ");
INSERT INTO engBBE_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","And the Egyptians were forcing the people on, to get them out of the land quickly; for they said, We are all dead men. ");
INSERT INTO engBBE_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","And the people took their bread-paste before it was leavened, putting their basins in their clothing on their backs. ");
INSERT INTO engBBE_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","And the children of Israel had done as Moses had said; and they got from the Egyptians ornaments of silver and of gold, and clothing: ");
INSERT INTO engBBE_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","And the Lord had given the people grace in the eyes of the Egyptians so that they gave them whatever was requested. So they took away all their goods from the Egyptians. ");
INSERT INTO engBBE_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","And the children of Israel made the journey from Rameses to Succoth; there were about six hundred thousand men on foot, as well as children. ");
INSERT INTO engBBE_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","And a mixed band of people went with them; and flocks and herds in great numbers. ");
INSERT INTO engBBE_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","And they made unleavened cakes from the paste which they had taken out of Egypt; it was not leavened, for they had been sent out of Egypt so quickly, that they had no time to make any food ready. ");
INSERT INTO engBBE_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Now the children of Israel had been living in Egypt for four hundred and thirty years. ");
INSERT INTO engBBE_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","And at the end of four hundred and thirty years, to the very day, all the armies of the Lord went out of the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","It is a watch-night before the Lord who took them out of the land of Egypt: this same night is a watch-night to the Lord for all the children of Israel, through all their generations. ");
INSERT INTO engBBE_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","And the Lord said to Moses and Aaron, This is the law of the Passover: no man who is not an Israelite is to take of it: ");
INSERT INTO engBBE_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","But every man's servant, whom he has got for money, may take of it, when he has had circumcision. ");
INSERT INTO engBBE_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","A man from a strange country living among you, and a servant working for payment, may not take part in it. ");
INSERT INTO engBBE_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","It is to be taken in one house; not a bit of the flesh is to be taken out of the house, and no bone of it may be broken. ");
INSERT INTO engBBE_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","All Israel is to keep the feast. ");
INSERT INTO engBBE_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","And if a man from another country is living with you, and has a desire to keep the Passover to the Lord, let all the males of his family undergo circumcision, and then let him come near and keep it; for he will then be as one of your people; but no one without circumcision may keep it. ");
INSERT INTO engBBE_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","The law is the same for him who is an Israelite by birth and for the man from a strange country who is living with you. ");
INSERT INTO engBBE_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","So the children of Israel did as the Lord gave orders to Moses and Aaron. ");
INSERT INTO engBBE_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","And on that very day the Lord took the children of Israel out of the land of Egypt by their armies. ");
INSERT INTO engBBE_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Let the first male child of every mother among the children of Israel be kept holy for me, even the first male birth among man or beast; for it is mine. ");
INSERT INTO engBBE_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","And Moses said to the people, Let this day, on which you came out of Egypt, out of your prison-house, be kept for ever in memory; for by the strength of his hand the Lord has taken you out from this place; let no leavened bread be used. ");
INSERT INTO engBBE_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","On this day, in the month Abib, you are going out. ");
INSERT INTO engBBE_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","And it will be that, when the Lord takes you into the land of the Canaanite and the Hittite and the Amorite and the Hivite and the Jebusite, the land which he made an oath to your fathers that he would give you, a land flowing with milk and honey, you will do this act of worship in this month. ");
INSERT INTO engBBE_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","For seven days let your food be unleavened cakes; and on the seventh day there is to be a feast to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Unleavened cakes are to be your food through all the seven days; let no leavened bread be seen among you, or any leaven, in any part of your land. ");
INSERT INTO engBBE_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","And you will say to your son in that day, It is because of what the Lord did for me when I came out of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","And this will be for a sign to you on your hand and for a mark on your brow, so that the law of the Lord may be in your mouth: for with a strong hand the Lord took you out of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","So let this order be kept, at the right time, from year to year. ");
INSERT INTO engBBE_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","And when the Lord takes you into the land of Canaan, as he made his oath to you and to your fathers, and gives it to you, ");
INSERT INTO engBBE_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","You are to put on one side for the Lord every mother's first male child, the first-fruit of her body, and the first young one of every beast; every male is holy to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","And for the young of an ass you may give a lamb in payment, or if you will not make payment for it, its neck is to be broken; but for all the first sons among your children, let payment be made. ");
INSERT INTO engBBE_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","And when your son says to you in time to come, What is the reason for this? say to him, By the strength of his hand the Lord took us out of Egypt, out of the prison-house: ");
INSERT INTO engBBE_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","And when Pharaoh made his heart hard and would not let us go, the Lord sent death on all the first sons in Egypt, of man and of beast: and so every first male who comes to birth is offered to the Lord; but for all the first of my sons I give a price. ");
INSERT INTO engBBE_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","And this will be for a sign on your hand and for a mark on your brow: for by the strength of his hand the Lord took us out of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Now after Pharaoh had let the people go, God did not take them through the land of the Philistines, though that was near: for God said, If the people see war, they may have a change of heart and go back to Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","But God took the people round by the waste land near the Red Sea: and the children of Israel went up in fighting order out of the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","And Moses took the bones of Joseph with him, for Joseph had made the children of Israel take an oath, saying, God will certainly keep you in mind; and you are to take my bones away with you. ");
INSERT INTO engBBE_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Then they went on their journey from Succoth, and put up their tents in Etham at the edge of the waste land. ");
INSERT INTO engBBE_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","And the Lord went before them by day in a pillar of cloud, guiding them on their way; and by night in a pillar of fire to give them light: so that they were able to go on day and night: ");
INSERT INTO engBBE_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","The pillar of cloud went ever before them by day, and the pillar of fire by night. ");
INSERT INTO engBBE_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Give orders to the children of Israel to go back and put up their tents before Pi-hahiroth, between Migdol and the sea, in front of Baal-zephon, opposite to which you are to put up your tents by the sea. ");
INSERT INTO engBBE_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","And Pharaoh will say of the children of Israel, They are wandering without direction, they are shut in by the waste land. ");
INSERT INTO engBBE_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","And I will make Pharaoh's heart hard, and he will come after them and I will be honoured over Pharaoh and all his army, so that the Egyptians may see that I am the Lord. And they did so. ");
INSERT INTO engBBE_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","And word came to Pharaoh of the flight of the people: and the feeling of Pharaoh and of his servants about the people was changed, and they said, Why have we let Israel go, so that they will do no more work for us? ");
INSERT INTO engBBE_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","So he had his war-carriage made ready and took his people with him: ");
INSERT INTO engBBE_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","And he took six hundred carriages, all the carriages of Egypt, and captains over all of them. ");
INSERT INTO engBBE_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","And the Lord made the heart of Pharaoh hard, and he went after the children of Israel: for the children of Israel had gone out without fear. ");
INSERT INTO engBBE_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","But the Egyptians went after them, all the horses and carriages of Pharaoh, and his horsemen, and his army, and overtook them in their tents by the sea, by Pihahiroth, before Baal-zephon. ");
INSERT INTO engBBE_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","And when Pharaoh came near, the children of Israel, lifting up their eyes, saw the Egyptians coming after them, and were full of fear; and their cry went up to God. ");
INSERT INTO engBBE_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","And they said to Moses, Was there no resting-place for the dead in Egypt, that you have taken us away to come to our death in the waste land? why have you taken us out of Egypt? ");
INSERT INTO engBBE_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Did we not say to you in Egypt, Let us be as we are, working for the Egyptians? for it is better to be the servants of the Egyptians than to come to our death in the waste land. ");
INSERT INTO engBBE_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","But Moses said, Keep where you are and have no fear; now you will see the salvation of the Lord which he will give you today; for the Egyptians whom you see today you will never see again. ");
INSERT INTO engBBE_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","The Lord will make war for you, you have only to keep quiet. ");
INSERT INTO engBBE_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","And the Lord said to Moses, Why are you crying out to me? give the children of Israel the order to go forward. ");
INSERT INTO engBBE_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","And let your rod be lifted up and your hand stretched out over the sea, and it will be parted in two; and the children of Israel will go through on dry land. ");
INSERT INTO engBBE_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","And I will make the heart of the Egyptians hard, and they will go in after them: and I will be honoured over Pharaoh and over his army, his war-carriages, and his horsemen. ");
INSERT INTO engBBE_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","And the Egyptians will see that I am the Lord, when I get honour over Pharaoh and his war-carriages and his horsemen. ");
INSERT INTO engBBE_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Then the angel of God, who had been before the tents of Israel, took his place at their back; and the pillar of cloud, moving from before them, came to rest at their back: ");
INSERT INTO engBBE_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","And it came between the army of Egypt and the army of Israel; and there was a dark cloud between them, and they went on through the night; but the one army came no nearer to the other all the night. ");
INSERT INTO engBBE_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","And when Moses' hand was stretched out over the sea, the Lord with a strong east wind made the sea go back all night, and the waters were parted in two and the sea became dry land. ");
INSERT INTO engBBE_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","And the children of Israel went through the sea on dry land: and the waters were a wall on their right side and on their left. ");
INSERT INTO engBBE_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Then the Egyptians went after them into the middle of the sea, all Pharaoh's horses and his war-carriages and his horsemen. ");
INSERT INTO engBBE_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","And in the morning watch, the Lord, looking out on the armies of the Egyptians from the pillar of fire and cloud, sent trouble on the army of the Egyptians; ");
INSERT INTO engBBE_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","And made the wheels of their war-carriages stiff, so that they had hard work driving them: so the Egyptians said, Let us go in flight from before the face of Israel, for the Lord is fighting for them against the Egyptians. ");
INSERT INTO engBBE_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","And the Lord said to Moses, Let your hand be stretched out over the sea, and the waters will come back again on the Egyptians, and on their war-carriages and on their horsemen. ");
INSERT INTO engBBE_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","And when Moses' hand was stretched out over the sea, at dawn the sea came flowing back, meeting the Egyptians in their flight, and the Lord sent destruction on the Egyptians in the middle of the sea. ");
INSERT INTO engBBE_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","And the waters came back, covering the war-carriages and the horsemen and all the army of Pharaoh which went after them into the middle of the sea; not one of them was to be seen. ");
INSERT INTO engBBE_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","But the children of Israel went through the sea walking on dry land, and the waters were a wall on their right side and on their left. ");
INSERT INTO engBBE_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","So that day the Lord gave Israel salvation from the hands of the Egyptians; and Israel saw the Egyptians dead on the sea's edge. ");
INSERT INTO engBBE_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","And Israel saw the great work which the Lord had done against the Egyptians, and the fear of the Lord came on the people and they had faith in the Lord and in his servant Moses. ");
INSERT INTO engBBE_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Then Moses and the children of Israel made this song to the Lord, and said, I will make a song to the Lord, for he is lifted up in glory: the horse and the horseman he has sent down into the sea. ");
INSERT INTO engBBE_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","The Lord is my strength and my strong helper, he has become my salvation: he is my God and I will give him praise; my father's God and I will give him glory. ");
INSERT INTO engBBE_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","The Lord is a man of war: the Lord is his name. ");
INSERT INTO engBBE_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Pharaoh's war-carriages and his army he has sent down into the sea: the best of his captains have gone down into the Red Sea. ");
INSERT INTO engBBE_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","They were covered by the deep waters: like a stone they went down under the waves. ");
INSERT INTO engBBE_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Full of glory, O Lord, is the power of your right hand; by your right hand those who came against you are broken. ");
INSERT INTO engBBE_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","When you are lifted up in power, all those who come against you are crushed: when you send out your wrath, they are burned up like dry grass. ");
INSERT INTO engBBE_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","By your breath the waves were massed together, the flowing waters were lifted up like a pillar; the deep waters became solid in the heart of the sea. ");
INSERT INTO engBBE_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Egypt said, I will go after them, I will overtake, I will make division of their goods: my desire will have its way with them; my sword will be uncovered, my hand will send destruction on them. ");
INSERT INTO engBBE_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","You sent your wind and the sea came over them: they went down like lead into the great waters. ");
INSERT INTO engBBE_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Who is like you, O Lord, among the gods? who is like you, in holy glory, to be praised with fear, doing wonders? ");
INSERT INTO engBBE_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","When your right hand was stretched out, the mouth of the earth was open for them. ");
INSERT INTO engBBE_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","In your mercy you went before the people whom you have made yours; guiding them in your strength to your holy place. ");
INSERT INTO engBBE_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Hearing of you the peoples were shaking in fear: the people of Philistia were gripped with pain. ");
INSERT INTO engBBE_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","The chiefs of Edom were troubled in heart; the strong men of Moab were in the grip of fear: all the people of Canaan became like water. ");
INSERT INTO engBBE_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Fear and grief came on them; by the strength of your arm they were turned to stone; till your people went over, O Lord, till the people went over whom you have made yours. ");
INSERT INTO engBBE_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","You will take them in, planting them in the mountain of your heritage, the place, O Lord, where you have made your house, the holy place, O Lord, the building of your hands. ");
INSERT INTO engBBE_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","The Lord is King for ever and ever. ");
INSERT INTO engBBE_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","For the horses of Pharaoh, with his war-carriages and his horsemen, went into the sea, and the Lord sent the waters of the sea back over them; but the children of Israel went through the sea on dry land. ");
INSERT INTO engBBE_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","And Miriam, the woman prophet, the sister of Aaron, took an instrument of music in her hand; and all the women went after her with music and dances. ");
INSERT INTO engBBE_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","And Miriam, answering, said, Make a song to the Lord, for he is lifted up in glory; the horse and the horseman he has sent into the sea. ");
INSERT INTO engBBE_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Then Moses took Israel forward from the Red Sea, and they went out into the waste land of Shur; and for three days they were in the waste land where there was no water. ");
INSERT INTO engBBE_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","And when they came to Marah, the water was no good for drinking, for the waters of Marah were bitter, which is why it was named Marah. ");
INSERT INTO engBBE_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","And the people, crying out against Moses, said, What are we to have for drink? ");
INSERT INTO engBBE_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","And in answer to his prayer, the Lord made him see a tree, and when he put it into the water, the water was made sweet. There he gave them a law and an order, testing them; ");
INSERT INTO engBBE_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","And he said, If with all your heart you will give attention to the voice of the Lord your God, and do what is right in his eyes, giving ear to his orders and keeping his laws, I will not put on you any of the diseases which I put on the Egyptians: for I am the Lord your life-giver. ");
INSERT INTO engBBE_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","And they came to Elim where there were twelve water-springs and seventy palm-trees: and they put up their tents there by the waters. ");
INSERT INTO engBBE_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","And they went on their way from Elim, and all the children of Israel came into the waste land of Sin, which is between Elim and Sinai, on the fifteenth day of the second month after they went out of the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","And all the children of Israel were crying out against Moses and Aaron in the waste land: ");
INSERT INTO engBBE_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","And the children of Israel said to them, It would have been better for the Lord to have put us to death in the land of Egypt, where we were seated by the flesh-pots and had bread enough for our needs; for you have taken us out to this waste of sand, to put all this people to death through need of food. ");
INSERT INTO engBBE_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Then the Lord said to Moses, See, I will send down bread from heaven for you; and the people will go out every day and get enough for the day's needs; so that I may put them to the test to see if they will keep my laws or not. ");
INSERT INTO engBBE_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","And on the sixth day they are to make ready what they get in, and it will be twice as much as they get on the other days. ");
INSERT INTO engBBE_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","And Moses and Aaron said to all the children of Israel, This evening it will be clear to you that it is the Lord who has taken you out of the land of Egypt: ");
INSERT INTO engBBE_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","And in the morning you will see the glory of the Lord; for your angry words against the Lord have come to his ears: and what are we that you are crying out against us? ");
INSERT INTO engBBE_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","And Moses said, The Lord will give you meat for your food at evening, and in the morning bread in full measure; for your outcry against the Lord has come to his ears: for what are we? your outcry is not against us but against the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","And Moses said to Aaron, Say to all the people of Israel, Come near before the Lord for he has given ear to your outcry. ");
INSERT INTO engBBE_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","And while Aaron was talking to the children of Israel, their eyes were turned in the direction of the waste land, and they saw the glory of the Lord shining in the cloud. ");
INSERT INTO engBBE_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","The outcry of the children of Israel has come to my ears: say to them now, At nightfall you will have meat for your food, and in the morning bread in full measure; and you will see that I am the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","And it came about that in the evening little birds came up and the place was covered with them: and in the morning there was dew all round about the tents. ");
INSERT INTO engBBE_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","And when the dew was gone, on the face of the earth was a small round thing, like small drops of ice on the earth. ");
INSERT INTO engBBE_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","And when the children of Israel saw it, they said to one another, What is it? for they had no idea what it was. And Moses said to them, It is the bread which the Lord has given you for your food. ");
INSERT INTO engBBE_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","This is what the Lord has said, Let every man take up as much as he has need of; at the rate of one omer for every person, let every man take as much as is needed for his family. ");
INSERT INTO engBBE_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","And the children of Israel did so, and some took more and some less. ");
INSERT INTO engBBE_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","And when it was measured, he who had taken up much had nothing over, and he who had little had enough; every man had taken what he was able to make use of. ");
INSERT INTO engBBE_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","And Moses said to them, Let nothing be kept till the morning. ");
INSERT INTO engBBE_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","But they gave no attention to Moses, and some of them kept it till the morning and there were worms in it and it had an evil smell: and Moses was angry with them. ");
INSERT INTO engBBE_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","And they took it up morning by morning, every man as he had need: and when the sun was high it was gone. ");
INSERT INTO engBBE_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","And on the sixth day they took up twice as much of the bread, two omers for every person: and all the rulers of the people gave Moses word of it. ");
INSERT INTO engBBE_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","And he said, This is what the Lord has said, Tomorrow is a day of rest, a holy Sabbath to the Lord: what has to be cooked may be cooked; and what is over, put on one side to be kept till the morning. ");
INSERT INTO engBBE_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","And they kept it till the morning as Moses had said: and no smell came from it, and it had no worms. ");
INSERT INTO engBBE_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","And Moses said, Make your meal today of what you have, for this day is a Sabbath to the Lord: today you will not get any in the fields. ");
INSERT INTO engBBE_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","For six days you will get it, but on the seventh day, the Sabbath, there will not be any. ");
INSERT INTO engBBE_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","But still on the seventh day some of the people went out to get it, and there was not any. ");
INSERT INTO engBBE_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","And the Lord said to Moses, How long will you go against my orders and my laws? ");
INSERT INTO engBBE_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","See, because the Lord has given you the Sabbath, he gives you on the sixth day bread enough for two days; let every man keep where he is; let no man go out of his place on the seventh day. ");
INSERT INTO engBBE_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","So the people took their rest on the seventh day. ");
INSERT INTO engBBE_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","And this bread was named manna by Israel: it was white, like a grain seed, and its taste was like cakes made with honey. ");
INSERT INTO engBBE_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","And Moses said, This is the order which the Lord has given: Let one omer of it be kept for future generations, so that they may see the bread which I gave you for your food in the waste land, when I took you out from the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","And Moses said to Aaron, Take a pot and put one omer of manna in it, and put it away before the Lord, to be kept for future generations. ");
INSERT INTO engBBE_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","So Aaron put it away in front of the holy chest to be kept, as the Lord gave orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","And the children of Israel had manna for their food for forty years, till they came to a land with people in it, till they came to the edge of the land of Canaan. ");
INSERT INTO engBBE_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Now an omer is the tenth part of an ephah. ");
INSERT INTO engBBE_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","And the children of Israel went on from the waste land of Sin, by stages as the Lord gave them orders, and put up their tents in Rephidim: and there was no drinking-water for the people. ");
INSERT INTO engBBE_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","So the people were angry with Moses, and said, Give us water for drinking. And Moses said, Why are you angry with me? and why do you put God to the test? ");
INSERT INTO engBBE_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","And the people were in great need of water; and they made an outcry against Moses, and said, Why have you taken us out of Egypt to send death on us and our children and our cattle through need of water? ");
INSERT INTO engBBE_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","And Moses, crying out to the Lord, said, What am I to do to this people? they are almost ready to put me to death by stoning. ");
INSERT INTO engBBE_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","And the Lord said to Moses, Go on before the people, and take some of the chiefs of Israel with you, and take in your hand the rod which was stretched out over the Nile, and go. ");
INSERT INTO engBBE_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","See, I will take my place before you on the rock in Horeb; and when you give the rock a blow, water will come out of it, and the people will have drink. And Moses did so before the eyes of the chiefs of Israel. ");
INSERT INTO engBBE_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","And he gave that place the name Massah and Meribah, because the children of Israel were angry, and because they put the Lord to the test, saying, Is the Lord with us or not? ");
INSERT INTO engBBE_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Then Amalek came and made war on Israel in Rephidim. ");
INSERT INTO engBBE_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","And Moses said to Joshua, Get together a band of men for us and go out, make war on Amalek: tomorrow I will take my place on the top of the hill with the rod of God in my hand. ");
INSERT INTO engBBE_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","So Joshua did as Moses said to him, and went to war with Amalek: and Moses, Aaron, and Hur went up to the top of the hill. ");
INSERT INTO engBBE_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Now while Moses' hand was lifted up, Israel was the stronger: but when he let his hand go down, Amalek became the stronger. ");
INSERT INTO engBBE_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","But Moses' hands became tired; so they put a stone under him and he took his seat on it, Aaron and Hur supporting his hands, one on one side and one on the other; so his hands were kept up without falling till the sun went down. ");
INSERT INTO engBBE_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","And Joshua overcame Amalek and his people with the sword. ");
INSERT INTO engBBE_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","And the Lord said to Moses, Make a record of this in a book, so that it may be kept in memory, and say it again in the ears of Joshua: that all memory of Amalek is to be completely uprooted from the earth. ");
INSERT INTO engBBE_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Then Moses put up an altar and gave it the name of Yahweh-nissi: ");
INSERT INTO engBBE_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","For he said, The Lord has taken his oath that there will be war with Amalek from generation to generation. ");
INSERT INTO engBBE_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Now news came to Jethro, the priest of Midian, Moses' father-in-law, of all God had done for Moses and for Israel his people, and how the Lord had taken Israel out of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","And Jethro, Moses' father-in-law, took Zipporah, Moses' wife, after he had sent her away, ");
INSERT INTO engBBE_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","And her two sons, one of whom was named Gershom, for he said, I have been living in a strange land: ");
INSERT INTO engBBE_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","And the name of the other was Eliezer, for he said, The God of my father was my help, and kept me safe from the sword of Pharaoh: ");
INSERT INTO engBBE_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","And Jethro, Moses' father-in-law, came with his sons and his wife to where Moses had put up his tent in the waste land, by the mountain of God. ");
INSERT INTO engBBE_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","And he said to Moses, I, your father-in-law, have come to you, with your wife and your two sons. ");
INSERT INTO engBBE_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","And Moses went out to his father-in-law, and went down on his face before him and gave him a kiss; and they said to one another, Are you well? and they came into the tent. ");
INSERT INTO engBBE_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","And Moses gave his father-in-law an account of all the Lord had done to Pharaoh and to the Egyptians because of Israel, and of all the troubles which had come on them by the way, and how the Lord had given them salvation. ");
INSERT INTO engBBE_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","And Jethro was glad because the Lord had been good to Israel, freeing them from the power of the Egyptians. ");
INSERT INTO engBBE_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","And Jethro said, Praise be to the Lord, who has taken you out of the hand of Pharaoh and out of the hand of the Egyptians; freeing the people from the yoke of the Egyptians. ");
INSERT INTO engBBE_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Now I am certain that the Lord is greater than all gods, for he has overcome them in their pride. ");
INSERT INTO engBBE_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Then Jethro, Moses' father-in-law, made a burned offering to God: and Aaron came, with the chiefs of Israel, and had a meal with Moses' father-in-law, before God. ");
INSERT INTO engBBE_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Now on the day after, Moses took his seat to give decisions for the people: and the people were waiting before Moses from morning till evening. ");
INSERT INTO engBBE_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","And when Moses' father-in-law saw all he was doing, he said, What is this you are doing for the people? why are you seated here by yourself, with all the people waiting before you from morning till evening? ");
INSERT INTO engBBE_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","And Moses said to his father-in-law, Because the people come to me to get directions from God: ");
INSERT INTO engBBE_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","And if they have any question between themselves, they come to me, and I am judge between a man and his neighbour, and I give them the orders and laws of God. ");
INSERT INTO engBBE_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","And Moses' father-in-law said to him, What you are doing is not good. ");
INSERT INTO engBBE_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Your strength and that of the people will be completely used up: this work is more than you are able to do by yourself. ");
INSERT INTO engBBE_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Give ear now to my suggestion, and may God be with you: you are to be the people's representative before God, taking their causes to him: ");
INSERT INTO engBBE_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Teaching them his rules and his laws, guiding them in the way they have to go, and making clear to them the work they have to do. ");
INSERT INTO engBBE_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","But for the rest, take from among the people able men, such as have the fear of God, true men hating profits wrongly made; and put such men over them, to be captains of thousands, captains of hundreds and of fifties and of tens; ");
INSERT INTO engBBE_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","And let them be judges in the causes of the people at all times: and let them put before you all important questions, but in small things let them give decisions themselves: in this way, it will be less hard for you, and they will take the weight off you. ");
INSERT INTO engBBE_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","If you do this, and God gives approval, then you will be able to go on without weariness, and all this people will go to their tents in peace. ");
INSERT INTO engBBE_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","So Moses took note of the words of his father-in-law, and did as he had said. ");
INSERT INTO engBBE_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","And he made selection of able men out of all Israel, and made them heads over the people, captains of thousands, captains of hundreds and of fifties and of tens. ");
INSERT INTO engBBE_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","And they were judges in the causes of the people at all times: the hard questions they put before Moses; but on every small point they gave decisions themselves. ");
INSERT INTO engBBE_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","And Moses let his father-in-law go away, and he went back to his land. ");
INSERT INTO engBBE_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","In the third month after the children of Israel went out from Egypt, on the same day, they came into the waste land of Sinai. ");
INSERT INTO engBBE_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","And when they had gone away from Rephidim and had come into the waste land of Sinai, they put up their tents in the waste land before the mountain: there Israel put up its tents. ");
INSERT INTO engBBE_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","And Moses went up to God, and the voice of the Lord came to him from the mountain, saying, Say to the family of Jacob, and give word to the children of Israel: ");
INSERT INTO engBBE_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","You have seen what I did to the Egyptians, and how I took you, as on eagles' wings, guiding you to myself. ");
INSERT INTO engBBE_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","If now you will truly give ear to my voice and keep my agreement, you will be my special property out of all the peoples: for all the earth is mine: ");
INSERT INTO engBBE_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","And you will be a kingdom of priests to me, and a holy nation. These are the words which you are to say to the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","And Moses came and sent for the chiefs of the people and put before them all these words which the Lord had given him orders to say. ");
INSERT INTO engBBE_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","And all the people, answering together, said, Whatever the Lord has said we will do. And Moses took back to the Lord the words of the people. ");
INSERT INTO engBBE_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","And the Lord said to Moses, See, I will come to you in a thick cloud, so that what I say to you may come to the ears of the people and they may have belief in you for ever. And Moses gave the Lord word of what the people had said. ");
INSERT INTO engBBE_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","And the Lord said to Moses, Go to the people and make them holy today and tomorrow, and let their clothing be washed. ");
INSERT INTO engBBE_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","And by the third day let them be ready: for on the third day the Lord will come down on Mount Sinai, before the eyes of all the people. ");
INSERT INTO engBBE_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","And let limits be marked out for the people round the mountain, and say to them, Take care not to go up the mountain or near the sides of it: whoever puts his foot on the mountain will certainly come to his death: ");
INSERT INTO engBBE_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","He is not to be touched by a hand, but is to be stoned or have an arrow put through him; man or beast, he is to be put to death: at the long sounding of a horn they may come up to the mountain. ");
INSERT INTO engBBE_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Then Moses went down from the mountain to the people, and made the people holy; and their clothing was washed. ");
INSERT INTO engBBE_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","And he said to the people, Be ready by the third day: do not come near a woman. ");
INSERT INTO engBBE_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","And when morning came on the third day, there were thunders and flames and a thick cloud on the mountain, and a horn sounding very loud; and all the people in the tents were shaking with fear. ");
INSERT INTO engBBE_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","And Moses made the people come out of their tents and take their places before God; and they came to the foot of the mountain, ");
INSERT INTO engBBE_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","And all the mountain of Sinai was smoking, for the Lord had come down on it in fire: and the smoke of it went up like the smoke of a great burning; and all the mountain was shaking. ");
INSERT INTO engBBE_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","And when the sound of the horn became louder and louder, Moses' words were answered by the voice of God. ");
INSERT INTO engBBE_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Then the Lord came down on to Mount Sinai, to the top of the mountain, and the Lord sent for Moses to come up to the top of the mountain, and Moses went up. ");
INSERT INTO engBBE_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","And the Lord said to Moses, Go down and give the people orders to keep back, for fear that a great number of them, forcing their way through to see the Lord, may come to destruction. ");
INSERT INTO engBBE_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","And let the priests who come near to the Lord make themselves holy, for fear that the Lord may come on them suddenly. ");
INSERT INTO engBBE_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","And Moses said to the Lord, The people will not be able to come up the mountain, for you gave us orders to put limits round the mountain, marking it out and making it holy. ");
INSERT INTO engBBE_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","And the Lord said to him, Go down, and you and Aaron may come up; but let not the priests and the people make their way through to the Lord, or he will come on them suddenly. ");
INSERT INTO engBBE_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","So Moses went down to the people and said this to them. ");
INSERT INTO engBBE_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","And God said all these words: ");
INSERT INTO engBBE_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","I am the Lord your God who took you out of the land of Egypt, out of the prison-house. ");
INSERT INTO engBBE_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","You are to have no other gods but me. ");
INSERT INTO engBBE_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","You are not to make an image or picture of anything in heaven or on the earth or in the waters under the earth: ");
INSERT INTO engBBE_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","You may not go down on your faces before them or give them worship: for I, the Lord your God, am a God who will not give his honour to another; and I will send punishment on the children for the wrongdoing of their fathers, to the third and fourth generation of my haters; ");
INSERT INTO engBBE_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","And I will have mercy through a thousand generations on those who have love for me and keep my laws. ");
INSERT INTO engBBE_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","You are not to make use of the name of the Lord your God for an evil purpose; whoever takes the Lord's name on his lips for an evil purpose will be judged a sinner by the Lord ");
INSERT INTO engBBE_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Keep in memory the Sabbath and let it be a holy day. ");
INSERT INTO engBBE_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","On six days do all your work: ");
INSERT INTO engBBE_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","But the seventh day is a Sabbath to the Lord your God; on that day you are to do no work, you or your son or your daughter, your man-servant or your woman-servant, your cattle or the man from a strange country who is living among you: ");
INSERT INTO engBBE_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","For in six days the Lord made heaven and earth, and the sea, and everything in them, and he took his rest on the seventh day: for this reason the Lord has given his blessing to the seventh day and made it holy. ");
INSERT INTO engBBE_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Give honour to your father and to your mother, so that your life may be long in the land which the Lord your God is giving you. ");
INSERT INTO engBBE_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Do not put anyone to death without cause. ");
INSERT INTO engBBE_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Do not be false to the married relation. ");
INSERT INTO engBBE_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Do not take the property of another. ");
INSERT INTO engBBE_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Do not give false witness against your neighbour. ");
INSERT INTO engBBE_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Let not your desire be turned to your neighbour's house, or his wife or his man-servant or his woman-servant or his ox or his ass or anything which is his. ");
INSERT INTO engBBE_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","And all the people were watching the thunderings and the flames and the sound of the horn and the mountain smoking; and when they saw it, they kept far off, shaking with fear. ");
INSERT INTO engBBE_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","And they said to Moses, To your words we will give ear, but let not the voice of God come to our ears, for fear death may come on us. ");
INSERT INTO engBBE_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","And Moses said to the people, Have no fear: for God has come to put you to the test, so that fearing him you may be kept from sin. ");
INSERT INTO engBBE_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","And the people kept their places far off, but Moses went near to the dark cloud where God was. ");
INSERT INTO engBBE_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","And the Lord said to Moses, Say to the children of Israel, You yourselves have seen that my voice has come to you from heaven ");
INSERT INTO engBBE_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Gods of silver and gods of gold you are not to make for yourselves. ");
INSERT INTO engBBE_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Make for me an altar of earth, offering on it your burned offerings and your peace-offerings, your sheep and your oxen: in every place where I have put the memory of my name, I will come to you and give you my blessing. ");
INSERT INTO engBBE_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","And if you make me an altar of stone do not make it of cut stones: for the touch of an instrument will make it unclean. ");
INSERT INTO engBBE_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","And do not go up by steps to my altar, for fear that your bodies may be seen uncovered. ");
INSERT INTO engBBE_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Now these are the laws which you are to put before them. ");
INSERT INTO engBBE_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","If you get a Hebrew servant for money, he is to be your servant for six years, and in the seventh year you are to let him go free without payment. ");
INSERT INTO engBBE_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","If he comes to you by himself, let him go away by himself: if he is married, let his wife go away with him. ");
INSERT INTO engBBE_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","If his master gives him a wife, and he gets sons or daughters by her, the wife and her children will be the property of the master, and the servant is to go away by himself. ");
INSERT INTO engBBE_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","But if the servant says clearly, My master and my wife and children are dear to me; I have no desire to be free: ");
INSERT INTO engBBE_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Then his master is to take him to the gods of the house, and at the door, or at its framework, he is to make a hole in his ear with a sharp-pointed instrument; and he will be his servant for ever. ");
INSERT INTO engBBE_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","And if a man gives his daughter for a price to be a servant, she is not to go away free as the men-servants do. ");
INSERT INTO engBBE_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","If she is not pleasing to her master who has taken her for himself, let a payment be made for her so that she may go free; her master has no power to get a price for her and send her to a strange land, because he has been false to her. ");
INSERT INTO engBBE_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","And if he gives her to his son, he is to do everything for her as if she was his daughter. ");
INSERT INTO engBBE_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","And if he takes another woman, her food and clothing and her married rights are not to be less. ");
INSERT INTO engBBE_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","And if he does not do these three things for her, she has the right to go free without payment. ");
INSERT INTO engBBE_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","He who gives a man a death-blow is himself to be put to death. ");
INSERT INTO engBBE_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","But if he had no evil purpose against him, and God gave him into his hand, I will give you a place to which he may go in flight. ");
INSERT INTO engBBE_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","But if a man makes an attack on his neighbour on purpose, to put him to death by deceit, you are to take him from my altar and put him to death. ");
INSERT INTO engBBE_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Any man who gives a blow to his father or his mother is certainly to be put to death. ");
INSERT INTO engBBE_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Any man who gets another into his power in order to get a price for him is to be put to death, if you take him in the act. ");
INSERT INTO engBBE_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Any man cursing his father or his mother is to be put to death. ");
INSERT INTO engBBE_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","If, in a fight, one man gives another a blow with a stone, or with the shut hand, not causing his death, but making him keep in bed; ");
INSERT INTO engBBE_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","If he is able to get up again and go about with a stick, the other will be let off; only he will have to give him payment for the loss of his time, and see that he is cared for till he is well. ");
INSERT INTO engBBE_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","If a man gives his man-servant or his woman-servant blows with a rod, causing death, he is certainly to undergo punishment. ");
INSERT INTO engBBE_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","But, at the same time, if the servant goes on living for a day or two, the master is not to get punishment, for the servant is his property. ");
INSERT INTO engBBE_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","If men, while fighting, do damage to a woman with child, causing the loss of the child, but no other evil comes to her, the man will have to make payment up to the amount fixed by her husband, in agreement with the decision of the judges. ");
INSERT INTO engBBE_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","But if damage comes to her, let life be given in payment for life, ");
INSERT INTO engBBE_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Eye for eye, tooth for tooth, hand for hand, foot for foot, ");
INSERT INTO engBBE_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Burning for burning, wound for wound, blow for blow. ");
INSERT INTO engBBE_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","If a man gives his man-servant or his woman-servant a blow in the eye, causing its destruction, he is to let him go free on account of the damage to his eye. ");
INSERT INTO engBBE_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Or if the loss of a tooth is caused by his blow, he will let him go free on account of his tooth. ");
INSERT INTO engBBE_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","If an ox comes to be the cause of death to a man or a woman, the ox is to be stoned, and its flesh may not be used for food; but the owner will not be judged responsible. ");
INSERT INTO engBBE_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","But if the ox has frequently done such damage in the past, and the owner has had word of it and has not kept it under control, so that it has been the cause of the death of a man or woman, not only is the ox to be stoned, but its owner is to be put to death. ");
INSERT INTO engBBE_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","If a price is put on his life, let him make payment of whatever price is fixed. ");
INSERT INTO engBBE_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","If the death of a son or of a daughter has been caused, the punishment is to be in agreement with this rule. ");
INSERT INTO engBBE_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","If the death of a man-servant or of a woman-servant is caused by the ox, the owner is to give their master thirty shekels of silver, and the ox is to be stoned. ");
INSERT INTO engBBE_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","If a man makes a hole in the earth without covering it up, and an ox or an ass dropping into it comes to its death; ");
INSERT INTO engBBE_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","The owner of the hole is responsible; he will have to make payment to their owner, but the dead beast will be his. ");
INSERT INTO engBBE_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","And if one man's ox does damage to another man's ox, causing its death, then the living ox is to be exchanged for money, and division made of the price of it, and of the price of the dead one. ");
INSERT INTO engBBE_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","But if it is common knowledge that the ox has frequently done such damage in the past, and its owner has not kept it under control, he will have to give ox for ox; and the dead beast will be his. ");
INSERT INTO engBBE_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","If a man takes without right another man's ox or his sheep, and puts it to death or gets a price for it, he is to give five oxen for an ox, or four sheep for a sheep, in payment: the thief will have to make payment for what he has taken; if he has no money, he himself will have to be exchanged for money, so that payment may be made. ");
INSERT INTO engBBE_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","If a thief is taken in the act of forcing his way into a house, and his death is caused by a blow, the owner of the house is not responsible for his blood. ");
INSERT INTO engBBE_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","But if it is after dawn, he will be responsible. ");
INSERT INTO engBBE_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","If he still has what he had taken, whatever it is, ox or ass or sheep, he is to give twice its value. ");
INSERT INTO engBBE_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","If a man makes a fire in a field or a vine-garden, and lets the fire do damage to another man's field, he is to give of the best produce of his field or his vine-garden to make up for it. ");
INSERT INTO engBBE_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","If there is a fire and the flames get to the thorns at the edge of the field, causing destruction of the cut grain or of the living grain, or of the field, he who made the fire will have to make up for the damage. ");
INSERT INTO engBBE_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","If a man puts money or goods in the care of his neighbour to keep for him, and it is taken from the man's house, if they get the thief, he will have to make payment of twice the value. ");
INSERT INTO engBBE_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","If they do not get the thief, let the master of the house come before the judges and take an oath that he has not put his hand on his neighbour's goods. ");
INSERT INTO engBBE_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","In any question about an ox or an ass or a sheep or clothing, or about the loss of any property which anyone says is his, let the two sides put their cause before God; and he who is judged to be in the wrong is to make payment to his neighbour of twice the value. ");
INSERT INTO engBBE_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","If a man puts an ass or an ox or a sheep or any beast into the keeping of his neighbour, and it comes to death or is damaged or is taken away, without any person seeing it: ");
INSERT INTO engBBE_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","If he takes his oath before the Lord that he has not put his hand to his neighbour's goods, the owner is to take his word for it and he will not have to make payment for it. ");
INSERT INTO engBBE_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","But if it is taken from him by a thief, he is to make up for the loss of it to its owner. ");
INSERT INTO engBBE_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","But if it has been damaged by a beast, and he is able to make this clear, he will not have to make payment for what was damaged. ");
INSERT INTO engBBE_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","If a man gets from his neighbour the use of one of his beasts, and it is damaged or put to death when the owner is not with it, he will certainly have to make payment for the loss. ");
INSERT INTO engBBE_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","If the owner is with it, he will not have to make payment: if he gave money for the use of it, the loss is covered by the payment. ");
INSERT INTO engBBE_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","If a man takes a virgin, who has not given her word to another man, and has connection with her, he will have to give a bride-price for her to be his wife. ");
INSERT INTO engBBE_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","If her father will not give her to him on any account, he will have to give the regular payment for virgins. ");
INSERT INTO engBBE_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Any woman using unnatural powers or secret arts is to be put to death. ");
INSERT INTO engBBE_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Any man who has sex connection with a beast is to be put to death. ");
INSERT INTO engBBE_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Complete destruction will come on any man who makes offerings to any other god but the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Do no wrong to a man from a strange country, and do not be hard on him; for you yourselves were living in a strange country, in the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Do no wrong to a widow, or to a child whose father is dead. ");
INSERT INTO engBBE_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","If you are cruel to them in any way, and their cry comes up to me, I will certainly give ear; ");
INSERT INTO engBBE_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","And in the heat of my wrath I will put you to death with the sword, so that your wives will be widows and your children without fathers. ");
INSERT INTO engBBE_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","If you let any of the poor among my people have the use of your money, do not be a hard creditor to him, and do not take interest. ");
INSERT INTO engBBE_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","If ever you take your neighbour's clothing in exchange for the use of your money, let him have it back before the sun goes down: ");
INSERT INTO engBBE_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","For it is the only thing he has for covering his skin; what is he to go to sleep in? and when his cry comes up to me, I will give ear, for my mercy is great. ");
INSERT INTO engBBE_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","You may not say evil of the judges, or put a curse on the ruler of your people. ");
INSERT INTO engBBE_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Do not keep back your offerings from the wealth of your grain and your vines. The first of your sons you are to give to me. ");
INSERT INTO engBBE_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","In the same way with your oxen and your sheep: for seven days let the young one be with its mother; on the eighth day give it to me. ");
INSERT INTO engBBE_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","You are to be holy men to me: the flesh of no animal whose death has been caused by the beasts of the field may be used for your food; it is to be given to the dogs. ");
INSERT INTO engBBE_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Do not let a false statement go further; do not make an agreement with evil-doers to be a false witness. ");
INSERT INTO engBBE_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Do not be moved to do wrong by the general opinion, or give the support of your words to a wrong decision: ");
INSERT INTO engBBE_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","But, on the other hand, do not be turned from what is right in order to give support to a poor man's cause. ");
INSERT INTO engBBE_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","If you come across the ox or the ass of one who is no friend to you wandering from its way, you are to take it back to him. ");
INSERT INTO engBBE_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","If you see the ass of one who has no love for you bent down to the earth under the weight which is put on it, you are to come to its help, even against your desire. ");
INSERT INTO engBBE_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Let no wrong decisions be given in the poor man's cause. ");
INSERT INTO engBBE_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Keep yourselves far from any false business; never let the upright or him who has done no wrong be put to death: for I will make the evil-doer responsible for his sin. ");
INSERT INTO engBBE_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Take no rewards in a cause: for rewards make blind those who have eyes to see, and make the decisions of the upright false. ");
INSERT INTO engBBE_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Do not be hard on the man from a strange country who is living among you; for you have had experience of the feelings of one who is far from the land of his birth, because you yourselves were living in Egypt, in a strange land. ");
INSERT INTO engBBE_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","For six years put seed into your fields and get in the increase; ");
INSERT INTO engBBE_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","But in the seventh year let the land have a rest and be unplanted; so that the poor may have food from it: and let the beasts of the field take the rest. Do the same with your vine-gardens and your olive-trees. ");
INSERT INTO engBBE_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","For six days do your work, and on the seventh day keep the Sabbath; so that your ox and your ass may have rest, together with the son of your servant and the man from a strange land living among you. ");
INSERT INTO engBBE_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Take note of all these things which I have said to you, and let not the names of other gods come into your minds or from your lips. ");
INSERT INTO engBBE_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Three times in the year you are to keep a feast to me. ");
INSERT INTO engBBE_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","You are to keep the feast of unleavened bread; for seven days let your bread be without leaven, as I gave you orders, at the regular time in the month Abib (for in it you came out of Egypt); and let no one come before me without an offering: ");
INSERT INTO engBBE_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","And the feast of the grain-cutting, the first-fruits of your planted fields: and the feast at the start of the year, when you have got in all the fruit from your fields. ");
INSERT INTO engBBE_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Three times in the year let all your males come before the Lord God. ");
INSERT INTO engBBE_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Do not give the blood of my offering with leavened bread; and do not let the fat of my feast be kept all night till the morning. ");
INSERT INTO engBBE_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","The best of the first-fruits of your land are to be taken into the house of the Lord your God. The young goat is not to be cooked in its mother's milk. ");
INSERT INTO engBBE_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","See, I am sending an angel before you, to keep you on your way and to be your guide into the place which I have made ready for you. ");
INSERT INTO engBBE_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Give attention to him and give ear to his voice; do not go against him; for your wrongdoing will not be overlooked by him, because my name is in him. ");
INSERT INTO engBBE_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","But if you truly give ear to his voice, and do whatever I say, then I will be against those who are against you, fighting those who are fighting you. ");
INSERT INTO engBBE_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","And my angel will go before you, guiding you into the land of the Amorite and the Hittite and the Perizzite and the Canaanite and the Hivite and the Jebusite, and they will be cut off by my hand. ");
INSERT INTO engBBE_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Do not go down on your faces and give worship to their gods, or do as they do; but overcome them completely, and let their pillars be broken down. ");
INSERT INTO engBBE_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","And give worship to the Lord your God, who will send his blessing on your bread and on your water; and I will take all disease away from among you. ");
INSERT INTO engBBE_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","All your animals will give birth without loss, not one will be without young in all your land; I will give you a full measure of life. ");
INSERT INTO engBBE_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","I will send my fear before you, putting to flight all the people to whom you come; all those who are against you will go in flight, turning their backs before you. ");
INSERT INTO engBBE_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","I will send hornets before you, driving out the Hivite and the Canaanite and the Hittite before your face. ");
INSERT INTO engBBE_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","I will not send them all out in one year, for fear that their land may become waste, and the beasts of the field be increased overmuch against you. ");
INSERT INTO engBBE_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Little by little I will send them away before you, till your numbers are increased and you take up your heritage in the land. ");
INSERT INTO engBBE_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","I will let the limits of your land be from the Red Sea to the sea of the Philistines, and from the waste land to the river Euphrates: for I will give the people of those lands into your power; and you will send them out before you. ");
INSERT INTO engBBE_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Make no agreement with them or with their gods. ");
INSERT INTO engBBE_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Let them not go on living in your land, or they will make you do evil against me: for if you give worship to their gods, it will certainly be a cause of sin to you. ");
INSERT INTO engBBE_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","And he said to Moses, Come up to the Lord, you and Aaron, and Nadab and Abihu and seventy of the chiefs of Israel; and give me worship from a distance. ");
INSERT INTO engBBE_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","And Moses only may come near to the Lord; but the others are not to come near, and the people may not come up with them. ");
INSERT INTO engBBE_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Then Moses came and put before the people all the words of the Lord and his laws: and all the people, answering with one voice, said, Whatever the Lord has said we will do. ");
INSERT INTO engBBE_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Then Moses put down in writing all the words of the Lord, and he got up early in the morning and made an altar at the foot of the mountain, with twelve pillars for the twelve tribes of Israel. ");
INSERT INTO engBBE_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","And he sent some of the young men of the children of Israel to make burned offerings and peace-offerings of oxen to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","And Moses took half the blood and put it in basins; draining out half of the blood over the altar. ");
INSERT INTO engBBE_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","And he took the book of the agreement, reading it in the hearing of the people: and they said, Everything which the Lord has said we will do, and we will keep his laws. ");
INSERT INTO engBBE_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Then Moses took the blood and let it come on the people, and said, This blood is the sign of the agreement which the Lord has made with you in these words. ");
INSERT INTO engBBE_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Then Moses and Aaron, Nadab, and Abihu, and seventy of the chiefs of Israel went up: ");
INSERT INTO engBBE_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","And they saw the God of Israel; and under his feet there was, as it seemed, a jewelled floor, clear as the heavens. ");
INSERT INTO engBBE_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","And he put not his hand on the chiefs of the children of Israel: they saw God, and took food and drink. ");
INSERT INTO engBBE_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","And the Lord said to Moses, Come up to me on the mountain, and take your place there: and I will give you the stones on which I have put in writing the law and the orders, so that you may give the people knowledge of them. ");
INSERT INTO engBBE_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Then Moses and Joshua his servant got up; and Moses went up into the mountain of God. ");
INSERT INTO engBBE_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","And he said to the chiefs, Keep your places here till we come back to you: Aaron and Hur are with you; if anyone has any cause let him go to them. ");
INSERT INTO engBBE_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","And Moses went up into the mountain, and it was covered by the cloud. ");
INSERT INTO engBBE_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","And the glory of the Lord was resting on Mount Sinai, and the cloud was over it for six days; and on the seventh day he said Moses' name out of the cloud. ");
INSERT INTO engBBE_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","And the glory of the Lord was like a flame on the top of the mountain before the eyes of the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","And Moses went up the mountain, into the cloud, and was there for forty days and forty nights. ");
INSERT INTO engBBE_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Say to the children of Israel that they are to make me an offering; from every man who has the impulse in his heart take an offering for me. ");
INSERT INTO engBBE_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","And this is the offering you are to take from them: gold and silver and brass; ");
INSERT INTO engBBE_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","And blue and purple and red, and the best linen, and goats' hair; ");
INSERT INTO engBBE_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","And sheepskins coloured red, and leather, and hard wood; ");
INSERT INTO engBBE_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Oil for the light, spices for the sweet-smelling oil, sweet perfumes for burning; ");
INSERT INTO engBBE_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Beryls and stones of value to be put on the ephod and on the priest's bag. ");
INSERT INTO engBBE_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","And let them make me a holy place, so that I may be ever present among them. ");
INSERT INTO engBBE_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Make the House and everything in it from the designs which I will give you. ");
INSERT INTO engBBE_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","And they are to make an ark of hard wood; two and a half cubits long, and a cubit and a half wide and high. ");
INSERT INTO engBBE_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","It is to be plated inside and out with the best gold, with an edge of gold all round it ");
INSERT INTO engBBE_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","And make four rings of gold for it, to be fixed on its four feet, two rings on one side of it and two on the other. ");
INSERT INTO engBBE_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","And make rods of the same wood, plating them with gold. ");
INSERT INTO engBBE_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","And put the rods through the rings at the sides of the ark, for lifting it. ");
INSERT INTO engBBE_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","The rods are to be kept in the rings, and never taken out. ");
INSERT INTO engBBE_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Inside the ark you are to put the record which I will give you. ");
INSERT INTO engBBE_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","And you are to make a cover of the best gold, two and a half cubits long and a cubit and a half wide. ");
INSERT INTO engBBE_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","And at the two ends of the cover you are to make two winged ones of hammered gold, ");
INSERT INTO engBBE_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","One at one end and one at the other; the winged ones are to be part of the cover. ");
INSERT INTO engBBE_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","And their wings are to be outstretched over the cover, and the winged ones are to be opposite one another, facing the cover. ");
INSERT INTO engBBE_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","And put the cover over the ark, and in the ark the record which I will give you. ");
INSERT INTO engBBE_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","And there, between the two winged ones on the cover of the ark, I will come to you, face to face, and make clear to you all the orders I have to give you for the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","And you are to make a table of the same wood, two cubits long, a cubit wide and a cubit and a half high, ");
INSERT INTO engBBE_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Plated with the best gold, with a gold edge all round it; ");
INSERT INTO engBBE_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","And make a frame all round it, as wide as a man's hand, with a gold edge to the frame. ");
INSERT INTO engBBE_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","And make four gold rings and put them at the four angles, on the four feet of the table; ");
INSERT INTO engBBE_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","The rings are to be fixed under the frame to take the rods with which the table is to be lifted. ");
INSERT INTO engBBE_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Make rods of the same wood, plated with gold, for lifting the table. ");
INSERT INTO engBBE_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","And make the table-vessels, the spoons and the cups and the basins for liquids, all of the best gold. ");
INSERT INTO engBBE_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","And on the table at all times you are to keep my holy bread. ");
INSERT INTO engBBE_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","And you are to make a support for lights, of the best gold; its base and its pillar are to be of hammered gold; its cups, its buds, and its flowers are to be made of the same metal. ");
INSERT INTO engBBE_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","It is to have six branches coming out from its sides; three branches from one side and three from the other. ");
INSERT INTO engBBE_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Every branch having three cups made like almond flowers, every cup with a bud and a flower, on all the branches. ");
INSERT INTO engBBE_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","And on the pillar, four cups like almond flowers, every one with its bud and its flower: ");
INSERT INTO engBBE_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","And under every two branches a bud, made with the branch, for all the six branches of it. ");
INSERT INTO engBBE_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","The buds and the branches are to be made of the same metal; all together one complete work of hammered gold. ");
INSERT INTO engBBE_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Then you are to make its seven vessels for the lights, putting them in their place so that they give light in front of it. ");
INSERT INTO engBBE_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","And the instruments and trays for use with it are all to be of the best gold. ");
INSERT INTO engBBE_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","A talent of gold will be needed for it, with all these vessels. ");
INSERT INTO engBBE_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","And see that you make them from the design which you saw on the mountain. ");
INSERT INTO engBBE_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","And you are to make a House for me, with ten curtains of the best linen, blue and purple and red, worked with designs of winged ones by a good workman. ");
INSERT INTO engBBE_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Every curtain is to be twenty-eight cubits long and four cubits wide, all of the same measure. ");
INSERT INTO engBBE_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Five curtains are to be joined together, and the other five are to be joined together. ");
INSERT INTO engBBE_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","And you are to put twists of blue cord on the edge of the outside curtain of the first group of five, and on the edge of the outside curtain of the second group of five; ");
INSERT INTO engBBE_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Fifty twists on one curtain and fifty on the other, the twists to be opposite one another. ");
INSERT INTO engBBE_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Then make fifty gold hooks, joining the curtains together by the hooks, and in this way the House will be made. ");
INSERT INTO engBBE_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","And you are to make curtains of goats' hair for a tent over the House, eleven curtains. ");
INSERT INTO engBBE_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Every curtain is to be thirty cubits long and four cubits wide, all of the same measure. ");
INSERT INTO engBBE_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Five of these curtains are to be joined together, and the other six are to be joined together, the sixth being folded over to make a hanging in front of the tent. ");
INSERT INTO engBBE_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","And you are to put fifty twists of cord on the edge of the outside curtain of one group, and fifty twists on the edge of the outside curtain of the other group. ");
INSERT INTO engBBE_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Then make fifty brass hooks and put the hooks into the twists, joining the tent together to make it one. ");
INSERT INTO engBBE_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","And the folded part which is over of the curtains of the tent, the half-curtain which is folded back, will be hanging down over the back of the House. ");
INSERT INTO engBBE_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","And the cubit which is over of the ten curtains at the sides will be hanging over the two sides of the House as a cover. ");
INSERT INTO engBBE_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","And then you are to make a cover for the tent, of sheepskins coloured red, and a cover of leather over that. ");
INSERT INTO engBBE_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","And you are to make upright boards of hard wood for the House. ");
INSERT INTO engBBE_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Every board is to be ten cubits high and a cubit and a half wide. ");
INSERT INTO engBBE_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Every board is to be joined to the one nearest to it by two tongues, and so for every board in the House. ");
INSERT INTO engBBE_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","These are the boards needed for the house; twenty boards for the south side, ");
INSERT INTO engBBE_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","With forty silver bases under the twenty boards, two bases under every board to take its tongues. ");
INSERT INTO engBBE_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","And twenty boards for the second side of the house on the north, ");
INSERT INTO engBBE_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","With their forty silver bases, two under every board. ");
INSERT INTO engBBE_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","And six boards for the back of the House on the west, ");
INSERT INTO engBBE_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","With two boards for the angles of the House at the back. ");
INSERT INTO engBBE_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","The two are to be joined together at the base and at the top to one ring, forming the two angles. ");
INSERT INTO engBBE_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","So there are to be eight boards, with their sixteen silver bases, two bases under every board. ");
INSERT INTO engBBE_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","And make rods of the same wood, five for the boards on the one side, ");
INSERT INTO engBBE_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","And five for the boards on the other side of the House, and five for the west side of the House at the back. ");
INSERT INTO engBBE_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","And the middle rod is to go through the rings of all the boards from end to end. ");
INSERT INTO engBBE_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","And the boards are to be plated with gold, having gold rings for the rods to go through: and the rods are to be plated with gold. ");
INSERT INTO engBBE_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","And you are to make the House from the design which you saw on the mountain. ");
INSERT INTO engBBE_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","And you are to make a veil of the best linen, blue and purple and red, worked with designs of winged ones by a good workman: ");
INSERT INTO engBBE_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Hanging it by gold hooks from four pillars of wood, plated with gold and fixed in silver bases. ");
INSERT INTO engBBE_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","And you are to put up the veil under the hooks, and put inside it the ark of the law: the veil is to be a division between the holy place and the most holy. ");
INSERT INTO engBBE_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","You are to put the cover on the ark of the law, inside the most holy place. ");
INSERT INTO engBBE_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","And outside the veil you are to put the table, and the support for the lights opposite the table on the south side of the House; and the table is to be on the north side. ");
INSERT INTO engBBE_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","And you are to make a curtain for the doorway of the Tent, of the best linen with needlework of blue and purple and red. ");
INSERT INTO engBBE_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","And make five pillars for the curtain, of hard wood plated with gold; their hooks are to be of gold and their bases of brass. ");
INSERT INTO engBBE_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","And make an altar of hard wood, a square altar, five cubits long, five cubits wide and three cubits high. ");
INSERT INTO engBBE_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Put horns at the four angles of it, made of the same, plating it all with brass. ");
INSERT INTO engBBE_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","And make all its vessels, the baskets for taking away the dust of the fire, the spades and basins and meat-hooks and fire-trays, of brass. ");
INSERT INTO engBBE_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","And make a network of brass, with four brass rings at its four angles. ");
INSERT INTO engBBE_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","And put the network under the shelf round the altar so that the net comes half-way up the altar. ");
INSERT INTO engBBE_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","And make rods for the altar, of hard wood, plated with brass. ");
INSERT INTO engBBE_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","And put the rods through the rings at the two opposite sides of the altar, for lifting it. ");
INSERT INTO engBBE_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","The altar is to be hollow, boarded in with wood; make it from the design which you saw on the mountain. ");
INSERT INTO engBBE_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","And let there be an open space round the House, with hangings for its south side of the best linen, a hundred cubits long. ");
INSERT INTO engBBE_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Their twenty pillars and their twenty bases are to be of brass; the hooks of the pillars and their bands are to be of silver. ");
INSERT INTO engBBE_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","And on the north side in the same way, hangings a hundred cubits long, with twenty pillars of brass on bases of brass; their hooks and their bands are to be of silver. ");
INSERT INTO engBBE_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","And for the open space on the west side, the hangings are to be fifty cubits wide, with ten pillars and ten bases; ");
INSERT INTO engBBE_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","And on the east side the space is to be fifty cubits wide. ");
INSERT INTO engBBE_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","On the one side of the doorway will be hangings fifteen cubits long, with three pillars and three bases; ");
INSERT INTO engBBE_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","And on the other side, hangings fifteen cubits long, with three pillars and three bases. ");
INSERT INTO engBBE_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","And across the doorway, a veil of twenty cubits of the best linen, made of needlework of blue and purple and red, with four pillars and four bases. ");
INSERT INTO engBBE_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","All the pillars round the open space are to have silver bands, with hooks of silver and bases of brass. ");
INSERT INTO engBBE_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","The open space is to be a hundred cubits long, fifty cubits wide, with sides five cubits high, curtained with the best linen, with bases of brass. ");
INSERT INTO engBBE_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","All the instruments for the work of the House, and all its nails, and the nails of the open space are to be of brass. ");
INSERT INTO engBBE_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Give orders to the children of Israel to give you clear olive oil for the lights, so that a light may be burning there at all times. ");
INSERT INTO engBBE_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Let Aaron and his sons put this in order, evening and morning, before the Lord, inside the Tent of meeting, outside the veil which is before the ark; this is to be an order for ever, from generation to generation, to be kept by the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Now let Aaron your brother, and his sons with him, come near from among the children of Israel, so that they may be my priests, even Aaron, and Nadab, Abihu, Eleazar, and Ithamar, his sons. ");
INSERT INTO engBBE_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","And make holy robes for Aaron your brother, so that he may be clothed with glory and honour. ");
INSERT INTO engBBE_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Give orders to all the wise-hearted workmen, whom I have made full of the spirit of wisdom, to make robes for Aaron, so that he may be made holy as my priest. ");
INSERT INTO engBBE_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","This is what they are to make: a priest's bag, an ephod, and a robe, and a coat of coloured needlework, a head-dress, and a linen band; they are to make holy robes for Aaron your brother and for his sons, so that they may do the work of priests for me. ");
INSERT INTO engBBE_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","They are to take the gold and blue and purple and red and the best linen, ");
INSERT INTO engBBE_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","And make the ephod of gold and blue and purple and red and the best linen, the work of a designer. ");
INSERT INTO engBBE_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","It is to have two bands stitched to it at the top of the arms, joining it together. ");
INSERT INTO engBBE_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","And the beautifully worked band, which goes on it, is to be of the same work and the same material, of gold and blue and purple and red and twisted linen-work. ");
INSERT INTO engBBE_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","You are to take two beryl stones, on which the names of the children of Israel are to be cut: ");
INSERT INTO engBBE_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Six names on the one stone and six on the other, in the order of their birth. ");
INSERT INTO engBBE_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","With the work of a jeweller, like the cutting of a stamp, the names of the children of Israel are to be cut on them, and they are to be fixed in twisted frames of gold. ");
INSERT INTO engBBE_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","And the two stones are to be placed on the ephod, over the arm-holes, to be stones of memory for the children of Israel: Aaron will have their names on his arms when he goes in before the Lord, to keep the Lord in mind of them. ");
INSERT INTO engBBE_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","And you are to make twisted frames of gold; ");
INSERT INTO engBBE_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","And two chains of the best gold, twisted like cords; and have the chains fixed on to the frames. ");
INSERT INTO engBBE_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","And make a priest's bag for giving decisions, designed like the ephod, made of gold and blue and purple and red and the best linen. ");
INSERT INTO engBBE_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","It is to be square, folded in two, a hand-stretch long and a hand-stretch wide. ");
INSERT INTO engBBE_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","And on it you are to put four lines of jewels; the first line is to be a cornelian, a chrysolite, and an emerald; ");
INSERT INTO engBBE_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","The second, a ruby, a sapphire, and an onyx; ");
INSERT INTO engBBE_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","The third, a jacinth, an agate, and an amethyst; ");
INSERT INTO engBBE_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","The fourth, a topaz, a beryl, and a jasper; they are to be fixed in twisted frames of gold. ");
INSERT INTO engBBE_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","The jewels are to be twelve in number, for the names of the children of Israel; every jewel having the name of one of the twelve tribes cut on it as on a stamp. ");
INSERT INTO engBBE_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","And you are to make two chains of gold, twisted like cords, to be fixed to the priest's bag. ");
INSERT INTO engBBE_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","And put two gold rings on the two ends of the bag. ");
INSERT INTO engBBE_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Put the two gold chains on the two rings at the ends of the bag; ");
INSERT INTO engBBE_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Joining the other ends of the chains to the gold frames and putting them on the front of the ephod, at the top of the arms. ");
INSERT INTO engBBE_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Then make two gold rings and put them on the lower ends of the bag, at the edge of it on the inner side nearest to the ephod. ");
INSERT INTO engBBE_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","And make two more gold rings and put them on the front of the ephod at the top of the arms, at the join, over the worked band: ");
INSERT INTO engBBE_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","So that the rings on the bag may be fixed to the rings of the ephod by a blue cord and on to the band of the ephod, so that the bag may not come loose from the ephod. ");
INSERT INTO engBBE_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","And so Aaron will have the names of the children of Israel on the priest's bag over his heart whenever he goes into the holy place, to keep the memory of them before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","And in the bag you are to put the Urim and Thummim, so that they may be on Aaron's heart whenever he goes in before the Lord; and Aaron may have the power of making decisions for the children of Israel before the Lord at all times. ");
INSERT INTO engBBE_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","The robe which goes with the ephod is to be made all of blue; ");
INSERT INTO engBBE_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","With a hole at the top, in the middle of it; the hole is to be edged with a band to make it strong like the hole in the coat of a fighting-man, so that it may not be broken open. ");
INSERT INTO engBBE_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","And round the skirts of it put fruits in blue and purple and red, with bells of gold between; ");
INSERT INTO engBBE_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","A gold bell and a fruit in turn all round the skirts of the robe. ");
INSERT INTO engBBE_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaron is to put it on for his holy work; and the sound of it will be clear, when he goes into the holy place before the Lord, and when he comes out, keeping him safe from death. ");
INSERT INTO engBBE_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","You are to make a plate of the best gold, cutting on it, as on a stamp, these words: HOLY TO THE LORD. ");
INSERT INTO engBBE_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Put a blue cord on it and put it on the front of the twisted head-dress: ");
INSERT INTO engBBE_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","And it will be over Aaron's brow, so that Aaron will be responsible for any error in all the holy offerings made by the children of Israel; it will be on his brow at all times, so that their offerings may be pleasing to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","The coat is to be made of the best linen, worked in squares; and you are to make a head-dress of linen, and a linen band worked in needlework. ");
INSERT INTO engBBE_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","And for Aaron's sons you are to make coats, and bands, and head-dresses, so that they may be clothed with glory and honour. ");
INSERT INTO engBBE_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","These you are to put on Aaron, your brother, and on his sons, putting oil on them, separating them and making them holy, to do the work of priests to me. ");
INSERT INTO engBBE_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","And you are to make them linen trousers, covering their bodies from the middle to the knee; ");
INSERT INTO engBBE_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaron and his sons are to put these on whenever they go into the Tent of meeting or come near the altar, when they are doing the work of the holy place, so that they may be free from any sin causing death: this is to be an order for him and his seed after him for ever. ");
INSERT INTO engBBE_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","This is what you are to do to make them holy, to do the work of priests to me: Take one young ox and two male sheep, without any mark on them, ");
INSERT INTO engBBE_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","And unleavened bread, and unleavened cakes mixed with oil, and thin unleavened cakes on which oil has been put, made of the best bread-meal; ");
INSERT INTO engBBE_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Put these in a basket and take them, with the ox and the two sheep. ");
INSERT INTO engBBE_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","And let Aaron and his sons come to the door of the Tent of meeting, and there let them be washed with water. ");
INSERT INTO engBBE_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Take the robes, and put the coat and the dress and the ephod and the priest's bag on Aaron; put the band of needlework round him, ");
INSERT INTO engBBE_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","And let the head-dress be placed on his head and the holy crown on the head-dress. ");
INSERT INTO engBBE_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Then take the oil and put it on his head. ");
INSERT INTO engBBE_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","And take his sons and put their robes on them; ");
INSERT INTO engBBE_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","And put the linen bands round Aaron and his sons, and the head-dresses on them, to make them priests by my order for ever: so you are to make Aaron and his sons holy to me. ");
INSERT INTO engBBE_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Then let the ox be taken in front of the Tent of meeting: and let Aaron and his sons put their hands on its head. ");
INSERT INTO engBBE_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","And you are to put the ox to death before the Lord at the door of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Then take some of the blood of the ox, and put it on the horns of the altar with your finger, draining out all the rest of the blood at the base of the altar. ");
INSERT INTO engBBE_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","And take all the fat covering the inside of the ox, and the fat joining the liver and the two kidneys with the fat round them, and let them be burned on the altar; ");
INSERT INTO engBBE_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","But the flesh of the ox and its skin and its waste parts are to be burned outside the circle of the tents, for it is a sin-offering. ");
INSERT INTO engBBE_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Then take one of the sheep, and let Aaron and his sons put their hands on its head. ");
INSERT INTO engBBE_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Then let it be put to death, so that the sides of the altar are marked with its blood. ");
INSERT INTO engBBE_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Then the sheep is to be cut up into its parts, and after washing its legs and its inside parts, you are to put them with the parts and the head, ");
INSERT INTO engBBE_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","And let them all be burned on the altar as a burned offering to the Lord: a sweet smell, an offering made by fire to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Then take the other sheep; and after Aaron and his sons have put their hands on its head, ");
INSERT INTO engBBE_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","You are to put the sheep to death, and take some of its blood and put it on the point of Aaron's right ear, and of the right ears of his sons, and on the thumbs of their right hands and the great toes of their right feet, dropping the rest of the blood on the sides of the altar. ");
INSERT INTO engBBE_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Then take some of the blood on the altar, and the oil, and put it on Aaron and his robes and on his sons and on their robes, so that he and his robes and his sons and their robes may be made holy. ");
INSERT INTO engBBE_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Then take the fat of the sheep, the fat tail, the fat covering the insides, and the fat joining the liver and the two kidneys with the fat round them, and the right leg; for by the offering of this sheep they are to be marked out as priests: ");
INSERT INTO engBBE_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","And take one bit of bread and one cake of oiled bread and one thin cake out of the basket of unleavened bread which is before the Lord: ");
INSERT INTO engBBE_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","And put them all on the hands of Aaron and of his sons, to be waved for a wave offering before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Then take them from their hands, and let them be burned on the burned offering on the altar, a sweet smell before the Lord, an offering made by fire to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Then take the breast of Aaron's sheep, waving it before the Lord; and it is to be your part of the offering. ");
INSERT INTO engBBE_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","So you are to make holy the breast of the sheep which is waved and the leg which is lifted up on high, that is, of the sheep which is offered for Aaron and his sons; ");
INSERT INTO engBBE_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","And it will be their part as a right for ever from the children of Israel, it is a special offering from the children of Israel, made from their peace-offerings, a special offering lifted up to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","And Aaron's holy robes will be used by his sons after him; they will put them on when they are made priests. ");
INSERT INTO engBBE_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","For seven days the son who becomes priest in his place will put them on when he comes into the Tent of meeting to do the work of the holy place. ");
INSERT INTO engBBE_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Then take the sheep of the wave offering and let its flesh be cooked in water in a holy place. ");
INSERT INTO engBBE_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","And let Aaron and his sons make a meal of it, with the bread in the basket, at the door of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","All those things which were used as offerings to take away sin, and to make them holy to be priests, they may have for food: but no one who is not a priest may have them, for they are holy food. ");
INSERT INTO engBBE_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","And if any of the flesh of the offering or of the bread is over till the morning, let it be burned with fire; it is not to be used for food, for it is holy. ");
INSERT INTO engBBE_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","All these things you are to do to Aaron and his sons as I have given you orders: for seven days the work of making them priests is to go on. ");
INSERT INTO engBBE_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Every day an ox is to be offered as a sin-offering, to take away sins: and by this offering on it, you will make the altar clean from sin; and you are to put oil on it and make it holy. ");
INSERT INTO engBBE_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","For seven days you are to make offerings for the altar and make it holy, so that it may become completely holy, and anything touching it will become holy. ");
INSERT INTO engBBE_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Now this is the offering which you are to make on the altar: two lambs in their first year, every day regularly. ");
INSERT INTO engBBE_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","One lamb is to be offered in the morning and the other in the evening: ");
INSERT INTO engBBE_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","And with the one lamb, a tenth part of an ephah of the best meal, mixed with a fourth part of a hin of clear oil; and the fourth part of a hin of wine for a drink offering. ");
INSERT INTO engBBE_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","And the other lamb is to be offered in the evening, and with it the same meal offering and drink offering, for a sweet smell, an offering made by fire to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","This is to be a regular burned offering made from generation to generation, at the door of the Tent of meeting before the Lord, where I will come face to face with you and have talk with you. ");
INSERT INTO engBBE_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","There I will come face to face with the children of Israel, and the Tent will be made holy by my glory ");
INSERT INTO engBBE_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","I will make holy the Tent of meeting and the altar: and Aaron and his sons I will make holy, to be my priests ");
INSERT INTO engBBE_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Among the children of Israel I will make my living-place, and I will be their God. ");
INSERT INTO engBBE_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","And they will see that I am the Lord their God, who took them out of the land of Egypt, so that I might be ever with them: I am the Lord their God. ");
INSERT INTO engBBE_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","And you are to make an altar for the burning of perfume; of hard wood let it be made. ");
INSERT INTO engBBE_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","The altar is to be square, a cubit long and a cubit wide, and two cubits high, and its horns are to be made of the same. ");
INSERT INTO engBBE_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","It is to be plated with the best gold, the top of it and the sides and the horns, with an edging of gold all round it. ");
INSERT INTO engBBE_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Under the edge on the two opposite sides, you are to make two gold rings, to take the rods for lifting it. ");
INSERT INTO engBBE_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","And make these rods of the same wood, plating them with gold. ");
INSERT INTO engBBE_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","And let it be placed in front of the veil before the ark of the law, before the cover which is over the law, where I will come face to face with you. ");
INSERT INTO engBBE_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","And on this altar sweet spices are to be burned by Aaron every morning when he sees to the lights. ");
INSERT INTO engBBE_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","And every evening, when he puts the lights up in their places, the spices are to be burned, a sweet-smelling smoke going up before the Lord from generation to generation for ever. ");
INSERT INTO engBBE_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","No strange perfume, no burned offering or meal offering, and no drink offering is to be offered on it. ");
INSERT INTO engBBE_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","And once every year Aaron is to make its horns clean: with the blood of the sin-offering he is to make it clean once every year from generation to generation: it is most holy to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","When you are taking the number of the children of Israel, let every man who is numbered give to the Lord a price for his life, so that no disease may come on them when they are numbered. ");
INSERT INTO engBBE_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","And this is what they are to give; let every man who is numbered give half a shekel, by the scale of the holy place: (the shekel being valued at twenty gerahs:) this money is an offering to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Everyone who is numbered, from twenty years old and over, is to give an offering to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","The man of wealth is to give no more and the poor man no less than the half-shekel of silver, when the offering is made to the Lord as the price for your lives. ");
INSERT INTO engBBE_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","And you are to take this money from the children of Israel to be used for the work of the Tent of meeting, to keep the memory of the children of Israel before the Lord and to be the price of your lives. ");
INSERT INTO engBBE_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","You are to make a brass washing-vessel, with a brass base; and put it between the Tent of meeting and the altar, with water in it; ");
INSERT INTO engBBE_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","That it may be used by Aaron and his sons for washing their hands and feet; ");
INSERT INTO engBBE_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Whenever they go into the Tent of meeting they are to be washed with water, to keep them from death; and whenever they come near to do the work of the altar, or to make an offering by fire to the Lord, ");
INSERT INTO engBBE_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Their hands and feet are to be washed. so that they may be safe from death: this is an order to them for ever; to him and his seed from generation to generation. ");
INSERT INTO engBBE_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Take the best spices, five hundred shekels' weight of liquid myrrh, and of sweet cinnamon half as much, that is, two hundred and fifty shekels, and two hundred and fifty shekels of sweet calamus, ");
INSERT INTO engBBE_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","And of cassia, five hundred shekels' weight measured by the scale of the holy place, and of olive oil a hin: ");
INSERT INTO engBBE_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","And make these into a holy oil, a perfume made by the art of the perfume-maker; it is to be a holy oil. ");
INSERT INTO engBBE_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","This oil is to be put on the Tent of meeting, and on the ark of the law, ");
INSERT INTO engBBE_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","And on the table and all its vessels, and on the support for the lights, with its vessels, and on the altar for burning spices, ");
INSERT INTO engBBE_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","And on the altar of burned offerings with its vessels, and on the washing-vessel and its base. ");
INSERT INTO engBBE_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","And you are to make them most holy; anything touching them will become holy. ");
INSERT INTO engBBE_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","And put the oil on Aaron and his sons, making them holy to do the work of priests to me. ");
INSERT INTO engBBE_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","And say to the children of Israel, This is to be the Lord's holy oil, from generation to generation. ");
INSERT INTO engBBE_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","It is not to be used for man's flesh, and no other is to be made like it: holy it is, and you are to keep it holy. ");
INSERT INTO engBBE_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Whoever makes any like it, or puts it on one who is not a priest, will be cut off from his people. ");
INSERT INTO engBBE_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","And the Lord said to Moses, Take sweet spices, stacte and onycha and galbanum, with the best frankincense, in equal weights; ");
INSERT INTO engBBE_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","And make from them a perfume, such as is made by the art of the perfume-maker, mixed with salt, and clean and holy. ");
INSERT INTO engBBE_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","And put some of it, crushed very small, in front of the ark in the Tent of meeting, where I will come face to face with you; it is to be most holy. ");
INSERT INTO engBBE_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","You are not to make any perfume like it for yourselves: it is to be kept holy to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Whoever makes any like it, for its sweet smell, will be cut off from his people. ");
INSERT INTO engBBE_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","I have made selection of Bezalel, the son of Uri, by name, the son of Hur, of the tribe of Judah: ");
INSERT INTO engBBE_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","And I have given him the spirit of God and made him wise and full of knowledge and expert in every sort of handwork, ");
INSERT INTO engBBE_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","To do all sorts of delicate work in gold and silver and brass; ");
INSERT INTO engBBE_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","In cutting stones for framing, and to do every form of woodwork. ");
INSERT INTO engBBE_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","And I have made selection of Oholiab with him, the son of Ahisamach, of the tribe of Dan; and in the hearts of all who are wise I have put the knowledge to make whatever I have given you orders to have made; ");
INSERT INTO engBBE_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","The Tent of meeting, and the ark of the law, and the cover which is on it, and all the things for the tent, ");
INSERT INTO engBBE_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","And the table with its vessels, and the holy light-support with all its vessels, and the altar for the burning of spices, ");
INSERT INTO engBBE_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","And the altar of burned offerings with all its vessels, and the washing-vessel with its base, ");
INSERT INTO engBBE_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","And the robes of needlework, the holy robes for Aaron and for his sons, for their use when acting as priests, ");
INSERT INTO engBBE_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","And the holy oil, and the perfume of sweet spices for the holy place; they will do whatever I have given you orders to have done. ");
INSERT INTO engBBE_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Say to the children of Israel that they are to keep my Sabbaths; for the Sabbath day is a sign between me and you through all your generations; so that you may see that I am the Lord who makes you holy. ");
INSERT INTO engBBE_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","So you are to keep the Sabbath as a holy day; and anyone not honouring it will certainly be put to death: whoever does any work on that day will be cut off from his people. ");
INSERT INTO engBBE_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Six days may work be done, but the seventh day is a Sabbath of complete rest, holy to the Lord; whoever does any work on the Sabbath day is to be put to death. ");
INSERT INTO engBBE_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","And the children of Israel are to keep the Sabbath holy, from generation to generation, by an eternal agreement. ");
INSERT INTO engBBE_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","It is a sign between me and the children of Israel for ever; because in six days the Lord made heaven and earth, and on the seventh day he took his rest and had pleasure in it. ");
INSERT INTO engBBE_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","And when his talk with Moses on Mount Sinai was ended, he gave him the two stones of the law, two stones on which was the writing made by the finger of God. ");
INSERT INTO engBBE_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","And when the people saw that Moses was a long time coming down from the mountain, they all came to Aaron and said to him, Come, make us a god to go before us: as for this Moses, who took us up out of the land of Egypt, we have no idea what has become of him. ");
INSERT INTO engBBE_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Then Aaron said to them, Take off the gold rings which are in the ears of your wives and your sons and your daughters, and give them to me. ");
INSERT INTO engBBE_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","And all the people took the gold rings from their ears and gave them to Aaron. ");
INSERT INTO engBBE_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","And he took the gold from them and, hammering it with an instrument, he made it into the metal image of a young ox: and they said, This is your god, O Israel, who took you out of the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","And when Aaron saw this, he made an altar before it, and made a public statement, saying, Tomorrow there will be a feast to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","So early on the day after they got up and made burned offerings and peace-offerings; and took their seats at the feast, and then gave themselves to pleasure. ");
INSERT INTO engBBE_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","And the Lord said to Moses, Go down quickly; for your people, whom you took out of the land of Egypt, are turned to evil ways; ");
INSERT INTO engBBE_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Even now they are turned away from the rule I gave them, and have made themselves a metal ox and given worship to it and offerings, saying, This is your god, O Israel, who took you up out of the land of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","And the Lord said to Moses, I have been watching this people, and I see that they are a stiff-necked people. ");
INSERT INTO engBBE_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Now do not get in my way, for my wrath is burning against them; I will send destruction on them, but of you I will make a great nation. ");
INSERT INTO engBBE_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","But Moses made prayer to God, saying, Lord, why is your wrath burning against your people whom you took out of the land of Egypt, with great power and with the strength of your hand? ");
INSERT INTO engBBE_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Why let the Egyptians say, He took them out to an evil fate, to put them to death on the mountains, cutting them off from the earth? Let your wrath be turned away from them, and send not this evil on your people. ");
INSERT INTO engBBE_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Have in mind Abraham, Isaac, and Israel, your servants, to whom you gave your oath, saying, I will make your seed like the stars of heaven in number, and all this land will I give to your seed, as I said, to be their heritage for ever. ");
INSERT INTO engBBE_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","So the Lord let himself be turned from his purpose of sending punishment on his people. ");
INSERT INTO engBBE_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Then Moses came down the mountain with the two stones of the law in his hand; the stones had writing on their two sides, on the front and on the back. ");
INSERT INTO engBBE_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","The stones were the work of God, and the writing was the writing of God, cut on the stones. ");
INSERT INTO engBBE_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Now when the noise and the voices of the people came to the ears of Joshua, he said to Moses, There is a noise of war in the tents. ");
INSERT INTO engBBE_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","And Moses said, It is not the voice of men who are overcoming in the fight, or the cry of those who have been overcome; it is the sound of songs which comes to my ear. ");
INSERT INTO engBBE_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","And when he came near the tents he saw the image of the ox, and the people dancing; and in his wrath Moses let the stones go from his hands, and they were broken at the foot of the mountain. ");
INSERT INTO engBBE_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","And he took the ox which they had made, burning it in the fire and crushing it to powder, and he put it in the water and made the children of Israel take a drink of it. ");
INSERT INTO engBBE_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","And Moses said to Aaron, What did the people do to you that you let this great sin come on them? ");
INSERT INTO engBBE_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","And Aaron said, Let not my lord be angry; you have seen how the purposes of this people are evil. ");
INSERT INTO engBBE_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","For they said to me, Make us a god to go before us: as for this Moses, who took us up out of the land of Egypt, we have no idea what has come to him. ");
INSERT INTO engBBE_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Then I said to them, Whoever has any gold, let him take it off; so they gave it to me, and I put it in the fire, and this image of an ox came out. ");
INSERT INTO engBBE_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","And Moses saw that the people were out of control, for Aaron had let them loose to their shame before their haters: ");
INSERT INTO engBBE_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Then Moses took his place at the way into the tents, and said, Whoever is on the Lord's side, let him come to me. And all the sons of Levi came together to him. ");
INSERT INTO engBBE_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","And he said to them, This is the word of the Lord, the God of Israel: Let every man take his sword at his side, and go from one end of the tents to the other, putting to death his brother and his friend and his neighbour. ");
INSERT INTO engBBE_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","And the sons of Levi did as Moses said; and about three thousand of the people were put to death that day. ");
INSERT INTO engBBE_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","And Moses said, You have made yourselves priests to the Lord this day; for every one of you has made the offering of his son and his brother; the blessing of the Lord is on you this day. ");
INSERT INTO engBBE_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","And on the day after, Moses said to the people, Great has been your sin: but I will go up to the Lord, and see if I may get forgiveness for your sin. ");
INSERT INTO engBBE_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Then Moses went back to the Lord and said, This people has done a great sin, making themselves a god of gold; ");
INSERT INTO engBBE_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","But now, if you will give them forgiveness — but if not, let my name be taken out of your book. ");
INSERT INTO engBBE_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","And the Lord said to Moses, Whoever has done evil against me will be taken out of my book. ");
INSERT INTO engBBE_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","But now, go, take the people into that place of which I have given you word; see, my angel will go before you: but when the time of my judging has come, I will send punishment on them for their sin. ");
INSERT INTO engBBE_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","And the Lord sent punishment on the people because they gave worship to the ox which Aaron made. ");
INSERT INTO engBBE_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","And the Lord said to Moses, Go forward from this place, you and the people whom you have taken up out of the land of Egypt, to that land about which I made an oath to Abraham, Isaac, and Jacob, saying, To your seed will I give it. ");
INSERT INTO engBBE_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","And I will send an angel before you, driving out the Canaanite and the Amorite and the Hittite and the Perizzite and the Hivite and the Jebusite: ");
INSERT INTO engBBE_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Go up to that land flowing with milk and honey; but I will not go up among you, for you are a stiff-necked people, for fear that I send destruction on you while you are on the way. ");
INSERT INTO engBBE_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Hearing this bad news the people were full of grief, and no one put on his ornaments. ");
INSERT INTO engBBE_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","And the Lord said to Moses, Say to the children of Israel, You are a stiff-necked people: if I come among you, even for a minute, I will send destruction on you; so take off all your ornaments, so that I may see what to do with you. ");
INSERT INTO engBBE_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","So the children of Israel took off their ornaments at Mount Horeb, and did not put them on again. ");
INSERT INTO engBBE_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Now it was Moses' way to put up the Tent of meeting outside the tent-circle, at some distance away; giving it the name of The Tent of meeting. And everyone desiring to make his prayer to the Lord went to the Tent of meeting outside the tent-circle. ");
INSERT INTO engBBE_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","And whenever Moses went out to the Tent of meeting, all the people got up and everyone went to the door of his tent, looking after Moses till he went inside the Tent. ");
INSERT INTO engBBE_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","And whenever Moses went into the Tent, the pillar of cloud came down, and took its place by the door of the Tent, as long as the Lord was talking with Moses. ");
INSERT INTO engBBE_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","And all the people saw the cloud at the door of the Tent, and they went down on their faces, everyone at the door of his tent. ");
INSERT INTO engBBE_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","And the Lord had talk with Moses face to face, as a man may have talk with his friend. And when Moses came back to the tents, his servant, the young man Joshua, the son of Nun, did not come away from the Tent. ");
INSERT INTO engBBE_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","And Moses said to the Lord, See, you say to me, Be this people's guide on their journey, but you have not made clear to me whom you will send with me. But you have said, I have knowledge of you by name, and you have grace in my eyes. ");
INSERT INTO engBBE_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","If then I have grace in your eyes, let me see your ways, so that I may have knowledge of you and be certain of your grace; and my prayer is that you will keep in mind that this nation is your people. ");
INSERT INTO engBBE_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","And he said, I myself will go with you and give you rest. ");
INSERT INTO engBBE_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","And Moses said, If you yourself are not going with us, do not send us on from here. ");
INSERT INTO engBBE_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","For is not the fact of your going with us the sign that I and this people have grace in your eyes, so that we, that is, I and your people, are separate from all other people on the face of the earth? ");
INSERT INTO engBBE_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","And the Lord said to Moses, I will do as you say: for you have grace in my eyes, and I have knowledge of you by your name. ");
INSERT INTO engBBE_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","And Moses said, O Lord, let me see your glory. ");
INSERT INTO engBBE_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","And he said, I will make all the light of my being come before you, and will make clear to you what I am; I will be kind to those to whom I will be kind, and have mercy on those on whom I will have mercy. ");
INSERT INTO engBBE_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","But it is not possible for you to see my face, for no man may see me and still go on living. ");
INSERT INTO engBBE_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","And the Lord said, See, there is a place near me, and you may take your place on the rock: ");
INSERT INTO engBBE_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","And when my glory goes by, I will put you in a hole in the rock, covering you with my hand till I have gone past: ");
INSERT INTO engBBE_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Then I will take away my hand, and you will see my back: but my face is not to be seen. ");
INSERT INTO engBBE_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","And the Lord said to Moses, Make two other stones like the first two; and I will put on them the words which were on the first stones, which were broken by you. ");
INSERT INTO engBBE_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","And be ready by the morning, and come up on Mount Sinai, and come before me there in the morning, on the top of the mountain. ");
INSERT INTO engBBE_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","No one is to come up with you, and let no man be seen anywhere on the mountain; let no flocks or herds come near to get their food at its foot. ");
INSERT INTO engBBE_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","So Moses got two stones cut like the first; and early in the morning he went up Mount Sinai, as the Lord had said, with the two stones in his hand. ");
INSERT INTO engBBE_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","And the Lord came down in the cloud and took his place by the side of Moses, and Moses gave worship to the name of the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","And the Lord went past before his eyes, saying, The Lord, the Lord, a God full of pity and grace, slow to wrath and great in mercy and faith; ");
INSERT INTO engBBE_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Having mercy on thousands, overlooking evil and wrongdoing and sin; he will not let wrongdoers go free, but will send punishment on children for the sins of their fathers, and on their children's children to the third and fourth generation. ");
INSERT INTO engBBE_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Then Moses quickly went down on his face in worship. ");
INSERT INTO engBBE_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","And he said, If now I have grace in your eyes, let the Lord go among us, for this is a stiff-necked people, and give us forgiveness for our wrongdoing and our sin, and take us for your heritage. ");
INSERT INTO engBBE_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","And the Lord said, See, this is what I will undertake: before the eyes of your people I will do wonders, such as have not been done in all the earth or in any nation: and all your people will see the work of the Lord, for what I am about to do for you is greatly to be feared. ");
INSERT INTO engBBE_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Take care to do the orders which I give you today; I will send out from before you the Amorite and the Canaanite and the Hittite and the Perizzite and the Hivite and the Jebusite. ");
INSERT INTO engBBE_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","But take care, and do not make any agreement with the people of the land where you are going, for it will be a cause of sin to you. ");
INSERT INTO engBBE_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","But their altars are to be overturned and their pillars broken and their images cut down: ");
INSERT INTO engBBE_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","For you are to be worshippers of no other god: for the Lord is a God who will not give his honour to another. ");
INSERT INTO engBBE_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","So see that you make no agreement with the people of the land, and do not go after their gods, or take part in their offerings, or be guests at their feasts, ");
INSERT INTO engBBE_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Or take their daughters for your sons; for when their daughters give worship before their gods, they will make your sons take part with them. ");
INSERT INTO engBBE_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Make for yourselves no gods of metal. ");
INSERT INTO engBBE_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Keep the feast of unleavened bread; for seven days your food is to be bread without leaven, as I gave you orders, at the regular time in the month Abib; for in that month you came out of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Every first male child is mine; the first male birth of your cattle, the first male of every ox and sheep. ");
INSERT INTO engBBE_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","A lamb may be given in payment for the young of an ass, but if you will not make payment for it, its neck will have to be broken. For all the first of your sons you are to make payment. No one is to come before me without an offering. ");
INSERT INTO engBBE_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Six days let work be done, but on the seventh day take your rest: at ploughing time and at the grain-cutting you are to have a day for rest. ");
INSERT INTO engBBE_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","And you are to keep the feast of weeks when you get in the first-fruits of the grain, and the feast at the turn of the year when you take in the produce of your fields. ");
INSERT INTO engBBE_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Three times in the year let all your males come before the Lord, the God of Israel. ");
INSERT INTO engBBE_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","For I will send out the nations before you and make wide the limits of your land; and no man will make an attempt to take your land while you go up to give worship to the Lord, three times in the year. ");
INSERT INTO engBBE_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","No leaven is to be offered with the blood of my offering, and the offering of the Passover feast may not be kept till the morning. ");
INSERT INTO engBBE_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Take the first-fruits of your land as an offering to the house of the Lord your God. Let not the young goat be cooked in its mother's milk ");
INSERT INTO engBBE_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","And the Lord said to Moses, Put all these words in writing; for on them is based the agreement which I will make with you. ");
INSERT INTO engBBE_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","And for forty days and forty nights Moses was there with the Lord, and in that time he had no food or drink. And he put in writing on the stones the words of the agreement, the ten rules of the law. ");
INSERT INTO engBBE_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Now when Moses came down from Mount Sinai, with the two stones in his hand, he was not conscious that his face was shining because of his talk with God. ");
INSERT INTO engBBE_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","But when Aaron and all the children of Israel saw Moses, and the shining of his face, they would not come near him for fear. ");
INSERT INTO engBBE_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Then Moses sent for them; and Aaron, with the chiefs of the people, came to him; and Moses had talk with them. ");
INSERT INTO engBBE_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","And later, all the children of Israel came near, and he gave them all the orders which the Lord had given him on Mount Sinai. ");
INSERT INTO engBBE_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","And at the end of his talk with them, Moses put a veil over his face. ");
INSERT INTO engBBE_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","But whenever Moses went in before the Lord to have talk with him, he took off the veil till he came out. And whenever he came out he said to the children of Israel what he had been ordered to say; ");
INSERT INTO engBBE_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","And the children of Israel saw that the face of Moses was shining: so Moses put the veil over his face again till he went to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","And Moses sent for all the children of Israel to come together, and said to them, This is what the Lord has said and these are his orders. ");
INSERT INTO engBBE_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Six days let work be done, but the seventh day is to be a holy day to you, a Sabbath of rest to the Lord; whoever does any work on that day is to be put to death. ");
INSERT INTO engBBE_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","No fire is to be lighted in any of your houses on the Sabbath day. ");
INSERT INTO engBBE_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","And Moses said to all the meeting of the children of Israel, This is the order which the Lord has given: ");
INSERT INTO engBBE_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Take from among you an offering to the Lord; everyone who has the impulse in his heart, let him give his offering to the Lord; gold and silver and brass; ");
INSERT INTO engBBE_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","And blue and purple and red and the best linen and goats' hair, ");
INSERT INTO engBBE_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","And sheepskins coloured red, and leather, and hard wood, ");
INSERT INTO engBBE_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","And oil for the lights, and spices for the holy oil and for the sweet perfumes for burning. ");
INSERT INTO engBBE_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","And beryls and jewels to be cut for the ephod and for the priest's bag. ");
INSERT INTO engBBE_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","And let every wise-hearted man among you come and make whatever has been ordered by the Lord; ");
INSERT INTO engBBE_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","The House and its tent and its cover, its hooks and its boards, its rods and its pillars and its bases; ");
INSERT INTO engBBE_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","The ark with its cover and its rods and the veil hanging before it; ");
INSERT INTO engBBE_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","The table and its rods and all its vessels, and the holy bread; ");
INSERT INTO engBBE_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","And the support for the lights, with its vessels and its lights and the oil for the light; ");
INSERT INTO engBBE_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","And the altar for burning spices, with its rods, and the holy oil and the sweet perfume, and the curtain for the door, at the door of the House; ");
INSERT INTO engBBE_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","The altar of burned offerings, with its network of brass, its rods, and all its vessels, the washing-vessel and its base; ");
INSERT INTO engBBE_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","The hangings for the open space, its pillars and their bases, and the curtain for the doorway; ");
INSERT INTO engBBE_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","The nails for the House, and the nails for the open space and their cords; ");
INSERT INTO engBBE_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","The robes of needlework for the work of the holy place, the holy robes for Aaron the priest, and the robes for his sons when acting as priests. ");
INSERT INTO engBBE_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","And all the children of Israel went away from Moses. ");
INSERT INTO engBBE_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","And everyone whose heart was moved, everyone who was guided by the impulse of his spirit, came with his offering for the Lord, for whatever was needed for the Tent of meeting and its work and for the holy robes. ");
INSERT INTO engBBE_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","They came, men and women, all who were ready to give, and gave pins and nose-rings and finger-rings and neck-ornaments, all of gold; everyone gave an offering of gold to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","And everyone who had blue and purple and red and the best linen and goats' hair and sheepskins coloured red and leather, gave them. ");
INSERT INTO engBBE_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Everyone who had silver and brass gave an offering of them to the Lord; and everyone who had hard wood, such as was needed for the work, gave it. ");
INSERT INTO engBBE_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","And all the women who were expert with their hands, made cloth, and gave the work of their hands, blue and purple and red and the best linen. ");
INSERT INTO engBBE_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","And those women who had the knowledge, made the goats' hair into cloth. ");
INSERT INTO engBBE_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","And the rulers gave the beryls and the cut jewels for the ephod and the priest's bag; ");
INSERT INTO engBBE_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","And the spice and the oil for the light, and the holy oil and the sweet perfumes. ");
INSERT INTO engBBE_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","The children of Israel, every man and woman, from the impulse of their hearts, gave their offerings freely to the Lord for the work which the Lord had given Moses orders to have done. ");
INSERT INTO engBBE_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","And Moses said to the children of Israel, See, the Lord has made selection of Bezalel, the son of Uri, the son of Hur, of the tribe of Judah; ");
INSERT INTO engBBE_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","And he has made him full of the spirit of God, in all wisdom and knowledge and art of every sort; ");
INSERT INTO engBBE_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","As an expert designer of beautiful things, working in gold and silver and brass; ");
INSERT INTO engBBE_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Trained in the cutting of stones and the ornamenting of wood and in every sort of handwork. ");
INSERT INTO engBBE_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","And he has given to him, and to Oholiab, the son of Ahisamach, of the tribe of Dan, the power of training others. ");
INSERT INTO engBBE_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","To them he has given knowledge of all the arts of the handworker, of the designer, and the expert workman; of the maker of needlework in blue and purple and red and the best linen, and of the maker of cloth; in all the arts of the designer and the trained workman they are expert. ");
INSERT INTO engBBE_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","So let Bezalel and Oholiab get to work, with every wise-hearted man to whom the Lord has given wisdom and knowledge, to do whatever is necessary for the ordering of the holy place, as the Lord has given orders. ");
INSERT INTO engBBE_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Then Moses sent for Bezalel and Oholiab, and for all the wise-hearted men to whom the Lord had given wisdom, even everyone who was moved by the impulse of his heart to come and take part in the work: ");
INSERT INTO engBBE_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","And they took from Moses all the offerings which the children of Israel had given for the building of the holy place. And still they went on giving him more free offerings every morning. ");
INSERT INTO engBBE_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Then the wise men, who were doing all the work of the holy place, came from their work; ");
INSERT INTO engBBE_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","And said to Moses, The people are giving much more than is needed for the work which the Lord has given us orders to do. ");
INSERT INTO engBBE_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","So Moses made an order and had it given out through all the tents, saying, Let no man or woman make any more offerings for the holy place. So the people were kept from giving more. ");
INSERT INTO engBBE_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","For the material they had was enough and more than enough for all the work which had to be done. ");
INSERT INTO engBBE_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Then all the expert workmen among them made the House with its ten curtains; of the best linen, blue and purple and red, they made them, with winged ones worked by expert designers. ");
INSERT INTO engBBE_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Every curtain was twenty-eight cubits long and four cubits wide, all of the same measure. ");
INSERT INTO engBBE_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","And five curtains were joined together, and the other five curtains were joined together. ");
INSERT INTO engBBE_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","And they put twists of blue cord on the edge of the outside curtain of the first group, and in the same way on the outside curtain of the second group. ");
INSERT INTO engBBE_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Fifty twists on the one curtain and fifty on the edge of the curtain of the other group; the twists being opposite to one another. ");
INSERT INTO engBBE_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","And they made fifty hooks of gold, joining the curtains one to another with the hooks; and so the House was made. ");
INSERT INTO engBBE_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","And they made curtains of goats' hair for the tent; eleven curtains were made. ");
INSERT INTO engBBE_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Every curtain was thirty cubits long and four cubits wide, all of the same measure. ");
INSERT INTO engBBE_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Five curtains were joined together to make one group, and six curtains were joined together to make the other group. ");
INSERT INTO engBBE_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","And they put fifty twists of cord on the edge of the outside curtain of the first group, and fifty twists on the edge of the outside curtain of the second group, ");
INSERT INTO engBBE_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","And fifty hooks of brass for joining them together to make the tent. ");
INSERT INTO engBBE_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","And they made a cover of sheepskins coloured red, to go over the tent, and a cover of leather over that. ");
INSERT INTO engBBE_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","And for the uprights of the House they made boards of hard wood. ");
INSERT INTO engBBE_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","The boards were ten cubits long and one cubit and a half wide. ");
INSERT INTO engBBE_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Every board had two tongues fixed into it; all the boards were made in this way. ");
INSERT INTO engBBE_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","They made twenty boards for the south side of the House: ");
INSERT INTO engBBE_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","And for these twenty boards, forty silver bases, two bases under every board, to take its tongues. ");
INSERT INTO engBBE_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","And for the second side of the House, on the north, they made twenty boards, ");
INSERT INTO engBBE_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","With their forty silver bases, two bases for every board. ");
INSERT INTO engBBE_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","And for the west side of the House, at the back, they made six boards, ");
INSERT INTO engBBE_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","And two boards for the angles at the back. ");
INSERT INTO engBBE_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","These were joined together at the base and at the top to one ring, so forming the two angles. ");
INSERT INTO engBBE_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","So there were eight boards with sixteen bases of silver, two bases under every board. ");
INSERT INTO engBBE_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","And they made rods of hard wood; five for the boards on one side of the House, ");
INSERT INTO engBBE_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","And five for the boards on the other side of the House, and five for the boards at the back, on the west. ");
INSERT INTO engBBE_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","The middle rod was made to go right through the rings of all the boards from one end to the other. ");
INSERT INTO engBBE_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","All the boards were plated with gold, and the rings through which the rods went were of gold, and the rods were plated with gold. ");
INSERT INTO engBBE_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","And he made the veil of the best linen, blue and purple and red, worked with winged ones designed by expert workmen. ");
INSERT INTO engBBE_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","And they made four pillars for it of hard wood plated with gold: they had hooks of gold and four silver bases. ");
INSERT INTO engBBE_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","And they made a curtain for the door of the tent, of the best linen with needlework of blue and purple and red; ");
INSERT INTO engBBE_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","And five pillars for the curtain, with their hooks; the heads of the pillars were of gold and they were circled with bands of gold; and their five bases were of brass. ");
INSERT INTO engBBE_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","And Bezalel made the ark of hard wood, two and a half cubits long, a cubit and a half wide and a cubit and a half high; ");
INSERT INTO engBBE_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Plating it inside and out with the best gold, and putting an edge of gold all round it. ");
INSERT INTO engBBE_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","And he made four gold rings for its four angles, two on one side and two on the other, ");
INSERT INTO engBBE_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","And rods of the same wood plated with gold. ");
INSERT INTO engBBE_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","These rods he put in the rings at the sides of the ark, for lifting it. ");
INSERT INTO engBBE_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","And he made the cover all of gold, two and a half cubits long and a cubit and a half wide. ");
INSERT INTO engBBE_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","And he made two winged ones, hammered out of one bit of gold, for the two ends of the cover; ");
INSERT INTO engBBE_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Placing one at one end and one at the other; the winged ones were part of the cover. ");
INSERT INTO engBBE_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","And their wings were stretched out over the cover; the faces of the winged ones were opposite one another and facing the cover. ");
INSERT INTO engBBE_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","And he made the table of hard wood, two cubits long, a cubit wide and a cubit and a half high; ");
INSERT INTO engBBE_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Plating it with the best gold and putting a gold edge all round it. ");
INSERT INTO engBBE_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","And he made a frame all round it about as wide as a man's hand, edged with gold all round. ");
INSERT INTO engBBE_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","And he made four gold rings, and put the rings at the angles of its four feet. ");
INSERT INTO engBBE_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","The rings were fixed under the frame to take the rods with which the table was to be lifted. ");
INSERT INTO engBBE_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","The rods for lifting the table he made of hard wood plated with gold. ");
INSERT INTO engBBE_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","And all the table-vessels, the plates and spoons and basins and the cups for liquids, he made of the best gold. ");
INSERT INTO engBBE_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Then he made the support for the lights, all of the best gold; its base and its pillar were of hammered gold; its cups and buds and flowers were all made out of the same metal: ");
INSERT INTO engBBE_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","It had six branches coming out from its sides, three from one side and three from the other; ");
INSERT INTO engBBE_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Every branch having three cups made like almond flowers, every cup with a bud and a flower on all the branches; ");
INSERT INTO engBBE_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","And on its pillar, four cups like almond flowers, every one with its bud and its flower; ");
INSERT INTO engBBE_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","And under every two branches a bud, made with the branch, for all six branches of it. ");
INSERT INTO engBBE_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","The buds and the branches were made of the same metal, all together one complete work of the best hammered gold. ");
INSERT INTO engBBE_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","And he made the seven vessels for the lights, and all the necessary instruments for it, of gold. ");
INSERT INTO engBBE_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","A talent of the best gold was used for the making of it and its vessels. ");
INSERT INTO engBBE_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","And he made the altar for the burning of spices, using the same hard wood; it was square, a cubit long and a cubit wide and two cubits high; the horns made of the same. ");
INSERT INTO engBBE_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","The top and the sides and the horns were all plated with the best gold; and he put an edge of gold all round it. ");
INSERT INTO engBBE_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","And he made two gold rings, placing them on the two opposite sides under the edge, to take the rods for lifting it. ");
INSERT INTO engBBE_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","The rods he made of the same hard wood, plating them with gold. ");
INSERT INTO engBBE_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","And he made the holy oil and the perfume of sweet spices for burning, after the art of the perfume-maker. ");
INSERT INTO engBBE_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","The altar of burned offerings he made of hard wood; a square altar, five cubits long, five cubits wide and three cubits high, ");
INSERT INTO engBBE_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","And he put horns at its four angles made of the same, plating it all with brass; ");
INSERT INTO engBBE_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","And brass was used for all the vessels of the altar, the baskets and the spades, the basins and the meat-hooks and the fire-trays; all the vessels he made of brass ");
INSERT INTO engBBE_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","And he made a network of brass for the altar, under the frame round it, stretching half-way up; ");
INSERT INTO engBBE_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","And four rings for the four angles of this network, to take the rods. ");
INSERT INTO engBBE_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","The rods he made of hard wood plated with brass. ");
INSERT INTO engBBE_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","He put the rods through the rings at the opposite sides of the altar for lifting it; he made the altar hollow, boarded in with wood. ");
INSERT INTO engBBE_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","And he made the washing-vessel of brass on a brass base, using the polished brass looking-glasses given by the women who did work at the doors of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","To make the open space, he put hangings on the south side, of the best linen, a hundred cubits long: ");
INSERT INTO engBBE_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Their twenty pillars and their twenty bases were brass; and the hooks of the pillars and their bands were of silver. ");
INSERT INTO engBBE_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","And for the north side. hangings a hundred cubits long, on twenty brass pillars in brass bases, with silver hooks and bands. ");
INSERT INTO engBBE_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","And on the west side, hangings fifty cubits long, on ten pillars in ten bases, with silver bands. ");
INSERT INTO engBBE_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","And on the east side, the open space was fifty cubits long. ");
INSERT INTO engBBE_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","The hangings on one side of the doorway were fifteen cubits long, on three pillars with their three bases; ");
INSERT INTO engBBE_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","And the same on the other side of the doorway; on this side and on that the hangings were fifteen cubits long, on three pillars with their three bases. ");
INSERT INTO engBBE_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","All the hangings were of the best linen. ");
INSERT INTO engBBE_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","And the bases of the pillars were of brass; their hooks and the bands round the tops of them were of silver; all the pillars were ringed with silver. ");
INSERT INTO engBBE_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","And the curtain for the doorway of the open space was of the best linen, with designs of blue and purple and red in needlework; it was twenty cubits long and five cubits high, to go with the hangings round the sides. ");
INSERT INTO engBBE_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","There were four pillars with their bases, all of brass, the hooks being of silver, and their tops and their bands being covered with silver. ");
INSERT INTO engBBE_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","All the nails used for the House and the open space round it were of brass. ");
INSERT INTO engBBE_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","This is the price of the making of the House, even the House of witness, as it was valued by the word of Moses, for the work of the Levites under the direction of Ithamar, the son of Aaron the priest. ");
INSERT INTO engBBE_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezalel, the son of Uri, the son of Hur, of the tribe of Judah, made everything as the Lord had given orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","And with him was Oholiab, the son of Ahisamach, of the tribe of Dan; a designer and a trained workman, expert in needlework of blue and purple and red and the best linen. ");
INSERT INTO engBBE_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","The gold used for all the different work done for the holy place, the gold which was given, was twenty-nine talents, and seven hundred and thirty shekels in weight, by the scale of the holy place. ");
INSERT INTO engBBE_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","And the silver given by those who were numbered of the people was a hundred talents, and a thousand, seven hundred and seventy-five shekels in weight, by the scale of the holy place. ");
INSERT INTO engBBE_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","A beka, that is, half a shekel by the holy scale, for everyone who was numbered; there were six hundred and three thousand, five hundred and fifty men of twenty years old and over. ");
INSERT INTO engBBE_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Of this silver, a hundred talents was used for making the bases of the pillars of the holy place and of the veil; a talent for every base. ");
INSERT INTO engBBE_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","And a thousand, seven hundred and seventy-five shekels of silver was used to make the hooks for the pillars, and for plating the tops of the pillars and for making their bands. ");
INSERT INTO engBBE_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","The brass which was given was seventy talents, two thousand four hundred shekels; ");
INSERT INTO engBBE_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","From it he made the bases of the doorway of the Tent of meeting and the brass altar and the network for it and all the vessels for the altar, ");
INSERT INTO engBBE_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","And the bases for the open space all round and for its doorway, and all the nails for the House and for the open space. ");
INSERT INTO engBBE_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","And from the needlework of blue and purple and red they made the robes used for the work of the holy place, and the holy robes for Aaron, as the Lord had given orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","The ephod he made of gold and blue and purple and red and the best linen; ");
INSERT INTO engBBE_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Hammering the gold into thin plates and cutting it into wires to be worked into the blue and the purple and the red and the linen by the designer. ");
INSERT INTO engBBE_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","And they made two bands for joining its edges together at the top of the arms. ");
INSERT INTO engBBE_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","And the beautifully worked band which went on it was of the same design and the same material, worked in gold and blue and purple and red and twisted linen-work, as the Lord gave orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Then they made the beryl stones, fixed in twisted frames of gold and cut like the cutting of a stamp, with the names of the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","These he put on the ephod, over the arm-holes, to be stones of memory for the children of Israel, as the Lord had said to Moses. ");
INSERT INTO engBBE_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","The priest's bag was designed like the ephod, of the best linen worked with gold and blue and purple and red. ");
INSERT INTO engBBE_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","It was square and folded in two, as long and as wide as the stretch of a man's hand; ");
INSERT INTO engBBE_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","And on it they put four lines of stones: in the first line was a carnelian, a chrysolite, and an emerald; ");
INSERT INTO engBBE_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","In the second, a ruby, a sapphire, and an onyx; ");
INSERT INTO engBBE_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","In the third, a jacinth, an agate, and an amethyst; ");
INSERT INTO engBBE_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","In the fourth, a topaz, a beryl, and a jasper; they were fixed in twisted frames of gold. ");
INSERT INTO engBBE_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","There were twelve stones for the twelve tribes of Israel; on every one the name of one of the tribes of Israel was cut, like the cutting of a stamp. ");
INSERT INTO engBBE_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","And on the bag they put gold chains, twisted like cords. ");
INSERT INTO engBBE_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","And they made two gold frames and two gold rings, the rings being fixed to the ends of the priest's bag; ");
INSERT INTO engBBE_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","And they put the two twisted chains on the two rings at the ends of the priest's bag; ");
INSERT INTO engBBE_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","And the other two ends of the chains were joined to the two frames and fixed to the front of the ephod over the arm-holes. ");
INSERT INTO engBBE_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","And they made two rings of gold and put them on the two lower ends of the bag, on the inner side nearest to the ephod. ");
INSERT INTO engBBE_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","And two other gold rings were put on the front of the ephod, over the arm-holes, at the join, and over the worked band. ");
INSERT INTO engBBE_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","And the rings on the bag were fixed to the rings of the ephod by a blue cord, keeping it in place over the band, so that the bag might not get loose, as the Lord gave orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","The robe which went with the ephod was made all of blue; ");
INSERT INTO engBBE_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","With a hole at the top in the middle, like the hole in the coat of a fighting-man, edged with a band to make it strong. ");
INSERT INTO engBBE_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","The skirts of the robe were worked all round with fruits in blue and purple and red made of twisted linen. ");
INSERT INTO engBBE_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","And between the fruits all round the skirt they put gold bells, as the Lord gave orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","All round the skirt of the robe were bells and fruits in turn. ");
INSERT INTO engBBE_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","The coats for Aaron and his sons they made of the best linen; ");
INSERT INTO engBBE_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","And the twisted head-dress for Aaron, and beautiful head-dresses of linen, and linen trousers, ");
INSERT INTO engBBE_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","And a linen band worked with a design of blue and purple and red, as the Lord had said to Moses. ");
INSERT INTO engBBE_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","The plate for the holy crown was made of the best gold, and on it were cut these words, HOLY TO THE LORD. ");
INSERT INTO engBBE_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","It was fixed to the head-dress by a blue cord, as the Lord had given orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","So all the work on the House of the Tent of meeting was done; as the Lord had given orders to Moses, so the children of Israel did it. ");
INSERT INTO engBBE_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Then they took the House to Moses, the tent with all the things for it; its hooks, its boards, its rods, its pillars, and its bases; ");
INSERT INTO engBBE_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","The outer cover of sheepskins coloured red, and the cover of leather, and the veil for the doorway; ");
INSERT INTO engBBE_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","The ark of the law, with its rods and its cover; ");
INSERT INTO engBBE_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","The table, with all its vessels and the holy bread; ");
INSERT INTO engBBE_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","The support for the lights, with the vessels for the lights to be put in their places on it, and all its vessels, and the oil for the lights; ");
INSERT INTO engBBE_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","And the gold altar, and the holy oil, and the sweet perfume for burning, and the curtain for the doorway of the tent; ");
INSERT INTO engBBE_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","And the brass altar, with its network of brass, and its rods and all its vessels, and the washing-vessel and its base; ");
INSERT INTO engBBE_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","The hangings for the open space, with the pillars and their bases, and the curtain for the doorway, and the cords and nails, and all the instruments necessary for the work of the House of the Tent of meeting; ");
INSERT INTO engBBE_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","The robes for use in the holy place, and the holy robes for Aaron and his sons when acting as priests. ");
INSERT INTO engBBE_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","The children of Israel did everything as the Lord had given orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Then Moses, when he saw all their work and saw that they had done everything as the Lord had said, gave them his blessing. ");
INSERT INTO engBBE_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","On the first day of the first month you are to put up the House of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","And inside it put the ark of the law, hanging the veil before it. ");
INSERT INTO engBBE_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","And put the table inside, placing all the things on it in order; and put in the support for the lights, and let its lights be burning. ");
INSERT INTO engBBE_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","And put the gold altar for burning perfumes in front of the ark of the law, hanging the curtain over the doorway of the House. ");
INSERT INTO engBBE_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","And put the altar of burned offerings before the doorway of the House of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","And let the washing-vessel, with water in it, be put between the Tent of meeting and the altar. ");
INSERT INTO engBBE_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","And put up the hangings forming the open space all round it, with the curtain over its doorway. ");
INSERT INTO engBBE_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","And take the holy oil and put it on the House and everything in it, and make it and everything in it holy: ");
INSERT INTO engBBE_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","And put oil on the altar of burned offering, and make it and all its vessels holy; this altar is to be most holy. ");
INSERT INTO engBBE_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","And put oil on the washing-vessel and its base, and make them holy. ");
INSERT INTO engBBE_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Then let Aaron and his sons come to the door of the Tent of meeting; and after washing them with water, ");
INSERT INTO engBBE_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","You are to put on Aaron the holy robes; and you are to put oil on him, and make him holy, so that he may be my priest. ");
INSERT INTO engBBE_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","And take his sons with him and put coats on them; ");
INSERT INTO engBBE_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","And put oil on them as you did on their father, so that they may be my priests: the putting on of oil will make them priests for ever, from generation to generation. ");
INSERT INTO engBBE_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","And Moses did this; as the Lord gave him orders, so he did. ");
INSERT INTO engBBE_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","So on the first day of the first month in the second year the House was put up. ");
INSERT INTO engBBE_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moses put up the House; placing its bases in position and lifting up its uprights, putting in the rods and planting the pillars in their places; ");
INSERT INTO engBBE_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Stretching the outer tent over it, and covering it, as the Lord had given him orders. ");
INSERT INTO engBBE_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","And he took the law and put it inside the ark, and put the rods at its side and the cover over it; ");
INSERT INTO engBBE_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","And he took the ark into the House, hanging up the veil before it as the Lord had given him orders. ");
INSERT INTO engBBE_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","And he put the table in the Tent of meeting, on the north side outside the veil. ");
INSERT INTO engBBE_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","And he put the bread on it in order before the Lord, as the Lord had said. ");
INSERT INTO engBBE_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","The support for the lights he put in the Tent of meeting, opposite the table, on the south side: ");
INSERT INTO engBBE_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Lighting the lights before the Lord, as the Lord had given him orders. ");
INSERT INTO engBBE_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","And he put the gold altar in the Tent of meeting, in front of the veil: ");
INSERT INTO engBBE_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Burning sweet perfumes on it, as the Lord had given him orders. ");
INSERT INTO engBBE_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","And he put up the curtain at the doorway of the House. ");
INSERT INTO engBBE_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","And at the door of the House of the Tent of meeting, he put the altar of burned offerings, offering on it the burned offering and the meal offering, as the Lord had given him orders. ");
INSERT INTO engBBE_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","And between the altar and the Tent of meeting he put the vessel with water in it for washing. ");
INSERT INTO engBBE_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","In it the hands and feet of Moses and Aaron and his sons were washed, ");
INSERT INTO engBBE_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Whenever they went into the Tent of meeting, and when they came near the altar, as the Lord had given orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","And he put up the hangings forming the open space round the House and the altar, and put the curtain over the doorway. So Moses made the work complete. ");
INSERT INTO engBBE_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Then the cloud came down covering the Tent of meeting, and the House was full of the glory of the Lord; ");
INSERT INTO engBBE_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","So that Moses was not able to go into the Tent of meeting, because the cloud was resting on it, and the House was full of the glory of the Lord. ");
INSERT INTO engBBE_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","And whenever the cloud was taken up from the House, the children of Israel went forward on their journey: ");
INSERT INTO engBBE_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","But while the cloud was there, they made no move till it was taken up. ");
INSERT INTO engBBE_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","For the cloud of the Lord was resting on the House by day, and at night there was fire in the cloud, before the eyes of all the people of Israel, and so it was through all their journeys. ");
INSERT INTO engBBE_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","And the voice of the Lord came to Moses out of the Tent of meeting, saying, ");
INSERT INTO engBBE_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Give these orders to the children of Israel: When anyone of you makes an offering to the Lord, you are to take it from the cattle, from the herd or from the flock. ");
INSERT INTO engBBE_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","If the offering is a burned offering of the herd, let him give a male without a mark: he is to give it at the door of the Tent of meeting so that he may be pleasing to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","And he is to put his hand on the head of the burned offering and it will be taken for him, to take away his sin. ");
INSERT INTO engBBE_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","And the ox is to be put to death before the Lord: then Aaron's sons, the priests, are to take the blood and put some of it on and round the altar which is at the door of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","And the burned offering is to be skinned and cut up into its parts. ");
INSERT INTO engBBE_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","And Aaron's sons, the priests, are to put fire on the altar and put the wood in order on the fire: ");
INSERT INTO engBBE_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","And Aaron's sons, the priests, are to put the parts, the head and the fat, in order on the wood which is on the fire on the altar: ");
INSERT INTO engBBE_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","But its inside parts and its legs are to be washed with water, and it will all be burned on the altar by the priest for a burned offering, an offering made by fire, for a sweet smell to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","And if his offering is of the flock, a burned offering of sheep or goats, let him give a male without a mark. ");
INSERT INTO engBBE_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","And he is to put it to death on the north side of the altar before the Lord: and Aaron's sons, the priests, are to put some of the blood on and round the altar. ");
INSERT INTO engBBE_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","And the offering is to be cut into its parts, with its head and its fat; and the priest is to put them in order on the wood which is on the fire on the altar: ");
INSERT INTO engBBE_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","But the inside parts and the legs are to be washed with water; and the priest will make an offering of all of it, burning it on the altar: it is a burned offering, an offering made by fire, for a sweet smell to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","And if his offering to the Lord is a burned offering of birds, then he is to make his offering of doves or of young pigeons. ");
INSERT INTO engBBE_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","And the priest is to take it to the altar, and after its head has been twisted off, it is to be burned on the altar, and its blood drained out on the side of the altar: ");
INSERT INTO engBBE_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","And he is to take away its stomach, with its feathers, and put it down by the east side of the altar, where the burned waste is put: ");
INSERT INTO engBBE_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","And let it be broken open at the wings, but not cut in two; and let it be burned on the altar by the priest on the wood which is on the fire; it is a burned offering; an offering made by fire for a sweet smell to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","And when anyone makes a meal offering to the Lord, let his offering be of the best meal, with oil on it and perfume: ");
INSERT INTO engBBE_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","And let him take it to Aaron's sons, the priests; and having taken in his hand some of the meal and of the oil, with all the perfume, let him give it to the priest to be burned on the altar, as a sign, an offering made by fire, for a sweet smell to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","And the rest of the meal offering will be for Aaron and his sons; it is most holy among the Lord's fire offerings. ");
INSERT INTO engBBE_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","And when you give a meal offering cooked in the oven, let it be of unleavened cakes of the best meal mixed with oil, or thin unleavened cakes covered with oil. ");
INSERT INTO engBBE_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","And if you give a meal offering cooked on a flat plate, let it be of the best meal, unleavened and mixed with oil. ");
INSERT INTO engBBE_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Let it be broken into bits, and put oil on it; it is a meal offering. ");
INSERT INTO engBBE_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","And if your offering is of meal cooked in fat over the fire, let it be made of the best meal mixed with oil. ");
INSERT INTO engBBE_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","And you are to give the meal offering made of these things to the Lord, and let the priest take it to the altar. ");
INSERT INTO engBBE_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","And he is to take from the meal offering a part, for a sign, burning it on the altar; an offering made by fire for a sweet smell to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","And the rest of the meal offering will be for Aaron and his sons; it is most holy among the Lord's fire offerings. ");
INSERT INTO engBBE_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","No meal offering which you give to the Lord is to be made with leaven; no leaven or honey is to be burned as an offering made by fire to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","You may give them as an offering of first-fruits to the Lord, but they are not to go up as a sweet smell on the altar. ");
INSERT INTO engBBE_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","And every meal offering is to be salted with salt; your meal offering is not to be without the salt of the agreement of your God: with all your offerings give salt. ");
INSERT INTO engBBE_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","And if you give a meal offering of first-fruits to the Lord, give, as your offering of first-fruits, new grain, made dry with fire, crushed new grain. ");
INSERT INTO engBBE_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","And put oil on it and perfume: it is a meal offering. ");
INSERT INTO engBBE_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","And part of the meal of the offering and part of the oil and all the perfume is to be burned for a sign by the priest: it is an offering made by fire to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","And if his offering is given for a peace-offering; if he gives of the herd, male or female, let him give it without any mark on it, before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","And he is to put his hand on the head of his offering and put it to death at the door of the Tent of meeting; and Aaron's sons, the priests, are to put some of the blood on and round the altar. ");
INSERT INTO engBBE_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","And he is to give of the peace-offering, as an offering made by fire to the Lord; the fat covering the inside parts and all the fat on the inside parts, ");
INSERT INTO engBBE_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","And the two kidneys, and the fat on them, which is by the top part of the legs, and the fat joining the liver and the kidneys, he is to take away; ");
INSERT INTO engBBE_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","That it may be burned by Aaron's sons on the altar, on the burned offering which is on the wood on the fire: it is an offering made by fire of a sweet smell to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","And if what he gives for a peace-offering to the Lord is of the flock, let him give a male or female, without any mark on it. ");
INSERT INTO engBBE_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","If his offering is a lamb, then let it be placed before the Lord: ");
INSERT INTO engBBE_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","And he is to put his hand on the head of his offering and put it to death before the Tent of meeting; and Aaron's sons are to put some of its blood on and round the altar. ");
INSERT INTO engBBE_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","And of the peace-offering, let him give an offering made by fire to the Lord; the fat of it, all the fat tail, he is to take away near the backbone; and the fat covering the inside parts and all the fat on the inside parts, ");
INSERT INTO engBBE_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","And the two kidneys, with the fat on them, which is by the top part of the legs, and the fat joining the liver and the kidneys, he is to take away; ");
INSERT INTO engBBE_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","That it may be burned by the priest on the altar; it is the food of the offering made by fire to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","And if his offering is a goat, then let it be placed before the Lord, ");
INSERT INTO engBBE_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","And let him put his hand on the head of it and put it to death before the Tent of meeting; and the sons of Aaron are to put some of its blood on and round the altar. ");
INSERT INTO engBBE_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","And of it let him make his offering, an offering made by fire to the Lord; the fat covering the inside parts and all the fat on the inside parts, ");
INSERT INTO engBBE_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","And the two kidneys, with the fat on them, which is by the top part of the legs, and the fat joining the liver and the kidneys, let him take away; ");
INSERT INTO engBBE_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","That it may be burned by the priest on the altar; it is the food of the offering made by fire for a sweet smell: all the fat is the Lord's. ");
INSERT INTO engBBE_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Let it be an order for ever, through all your generations, in all your houses, that you are not to take fat or blood for food. ");
INSERT INTO engBBE_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Say to the children of Israel: These are the offerings of anyone who does wrong through error, doing any of the things which by the Lord's order are not to be done: ");
INSERT INTO engBBE_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","If the chief priest by doing wrong becomes a cause of sin to the people, then let him give to the Lord for the sin which he has done, an ox, without any mark, for a sin-offering. ");
INSERT INTO engBBE_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","And he is to take the ox to the door of the Tent of meeting before the Lord; and put his hand on its head and put it to death before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","And the chief priest is to take some of its blood and take it to the Tent of meeting; ");
INSERT INTO engBBE_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","And the priest is to put his finger in the blood, shaking drops of it before the Lord seven times, in front of the veil of the holy place. ");
INSERT INTO engBBE_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","And the priest is to put some of the blood on the horns of the altar on which perfume is burned before the Lord in the Tent of meeting, draining out all the rest of the blood of the ox at the base of the altar of burned offering which is at the door of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","And he is to take away all the fat of the ox of the sin-offering; the fat covering the inside parts and all the fat of the inside parts, ");
INSERT INTO engBBE_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","And the two kidneys, with the fat on them, which is by the top part of the legs, and the fat joining the liver and the kidneys, he is to take away, ");
INSERT INTO engBBE_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","As it is taken from the ox of the peace-offering; and it is to be burned by the priest on the altar of burned offerings. ");
INSERT INTO engBBE_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","And the skin of the ox and all its flesh, with its head and its legs and its inside parts and its waste, ");
INSERT INTO engBBE_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","All the ox, he is to take away outside the circle of the tents into a clean place where the burned waste is put, and there it is to be burned on wood with fire. ");
INSERT INTO engBBE_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","And if all the people of Israel do wrong, without anyone's knowledge; if they have done any of the things which by the Lord's order are not to be done, causing sin to come on them; ");
INSERT INTO engBBE_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","When the sin which they have done comes to light, then let all the people give an ox for a sin-offering, and take it before the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","And let the chiefs of the people put their hands on its head before the Lord, and put the ox to death before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","And the priest is to take some of its blood to the Tent of meeting; ");
INSERT INTO engBBE_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","And put his finger in the blood, shaking drops of the blood seven times before the Lord in front of the veil. ");
INSERT INTO engBBE_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","And he is to put some of the blood on the horns of the altar which is before the Lord in the Tent of meeting; and all the rest of the blood is to be drained out at the base of the altar of burned offering at the door of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","And he is to take off all its fat, burning it on the altar. ");
INSERT INTO engBBE_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Let him do with the ox as he did with the ox of the sin-offering; and the priest will take away their sin and they will have forgiveness. ");
INSERT INTO engBBE_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Then let the ox be taken away outside the tent-circle, that it may be burned as the other ox was burned; it is the sin-offering for all the people. ");
INSERT INTO engBBE_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","If a ruler does wrong, and in error does any of the things which, by the order of the Lord his God, are not to be done, causing sin to come on him; ");
INSERT INTO engBBE_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","When the sin which he has done is made clear to him, let him give for his offering a goat, a male without any mark. ");
INSERT INTO engBBE_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","And he is to put his hand on the head of the goat and put it to death in the place where they put to death the burned offering before the Lord: it is a sin-offering. ");
INSERT INTO engBBE_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","And the priest is to take some of the blood of the offering with his finger and put it on the horns of the altar of burned offering, draining out the rest of the blood at the base of the altar of burned offering. ");
INSERT INTO engBBE_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","And all the fat of it is to be burned on the altar like the fat of the peace-offering; and the priest will take away his sin and he will have forgiveness. ");
INSERT INTO engBBE_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","And if any one of the common people does wrong in error, doing any of the things which the Lord has given orders are not to be done, causing sin to come on him; ");
INSERT INTO engBBE_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","When the sin which he has done is made clear to him, then he is to give for his offering a goat, a female without any mark, for the sin which he has done. ");
INSERT INTO engBBE_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","And he is to put his hand on the head of the sin-offering and put it to death in the place where they put to death the burned offering. ");
INSERT INTO engBBE_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","And the priest is to take some of the blood with his finger, and put it on the horns of the altar of burned offering, and all the rest of its blood is to be drained out at the base of the altar. ");
INSERT INTO engBBE_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","And let all its fat be taken away, as the fat is taken away from the peace-offerings, and let it be burned on the altar by the priest for a sweet smell to the Lord; and the priest will take away his sin and he will have forgiveness. ");
INSERT INTO engBBE_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","And if he gives a lamb as his sin-offering, let it be a female without any mark; ");
INSERT INTO engBBE_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","And he is to put his hand on the head of the offering and put it to death for a sin-offering in the place where they put to death the burned offering. ");
INSERT INTO engBBE_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","And the priest is to take some of the blood of the offering with his finger and put it on the horns of the altar of burned offering, and all the rest of the blood is to be drained out at the base of the altar; ");
INSERT INTO engBBE_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","And let him take away all its fat, as the fat is taken away from the lamb of the peace-offerings; and let it be burned by the priest on the altar among the offerings made by fire to the Lord: and the priest will take away his sin and he will have forgiveness. ");
INSERT INTO engBBE_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","And if anyone does wrong by saying nothing when he is put under oath as a witness of something he has seen or had knowledge of, then he will be responsible: ");
INSERT INTO engBBE_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","If anyone becomes unclean through touching unconsciously some unclean thing, such as the dead body of an unclean beast or of unclean cattle or of any unclean animal which goes flat on the earth, he will be responsible: ");
INSERT INTO engBBE_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Or if he becomes unclean through touching unconsciously any unclean thing of man, whatever it may be, when it is made clear to him he will be responsible: ");
INSERT INTO engBBE_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Or if anyone, without thought, takes an oath to do evil or to do good, whatever he says without thought, with an oath, having no knowledge of what he is doing; when it becomes clear to him, he will be responsible for any of these things. ");
INSERT INTO engBBE_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","And whoever is responsible for any such sin, let him make a statement openly of his wrongdoing; ");
INSERT INTO engBBE_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","And take to the Lord the offering for the wrong which he has done, a female from the flock, a lamb or a goat, for a sin-offering, and the priest will take away his sin. ");
INSERT INTO engBBE_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","And if he has not money enough for a lamb, then let him give, for his offering to the Lord, two doves or two young pigeons; one for a sin-offering and one for a burned offering. ");
INSERT INTO engBBE_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","And let him take them to the priest, who will first give the sin-offering, twisting off its head from its neck, but not cutting it in two; ");
INSERT INTO engBBE_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","And he is to put drops of the blood of the offering on the side of the altar, and the rest of the blood is to be drained out at the base of the altar; it is a sin-offering. ");
INSERT INTO engBBE_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","And the second is for a burned offering, in agreement with the law; and the priest will take away his sin and he will have forgiveness. ");
INSERT INTO engBBE_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","But if he has not enough money for two doves or two young pigeons, then let him give, for the sin he has done, the tenth part of an ephah of the best meal, for a sin-offering; let him put no oil on it, and no perfume, for it is a sin-offering. ");
INSERT INTO engBBE_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","And let him come to the priest with it, and the priest will take some of it in his hand, to be burned on the altar as a sign, among the offerings of the Lord made by fire: it is a sin-offering. ");
INSERT INTO engBBE_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","And the priest will take away his sin and he will have forgiveness: and the rest of the offering will be the priest's, in the same way as the meal offering. ");
INSERT INTO engBBE_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","If anyone is untrue, sinning in error in connection with the holy things of the Lord, let him take his offering to the Lord, a male sheep from the flock, without any mark, of the value fixed by you in silver by shekels, by the scale of the holy place. ");
INSERT INTO engBBE_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","And he is to make payment to the priest for what he has done wrong in relation to the holy thing, together with a fifth part of its value in addition; and the priest will take away his sin by the sheep of his offering, and he will have forgiveness. ");
INSERT INTO engBBE_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","And if anyone does wrong, and does any of the things which the Lord has given orders are not to be done, though he has no knowledge of it, still he is in the wrong and he is responsible. ");
INSERT INTO engBBE_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Let him come to the priest with a sheep, a male without any mark out of the flock, of the value fixed by you, as an offering for his error; and the priest will take away the sin which he did in error, and he will have forgiveness. ");
INSERT INTO engBBE_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","It is an offering for his error: he is certainly responsible before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","If anyone does wrong, and is untrue to the Lord, acting falsely to his neighbour in connection with something put in his care, or something given for a debt, or has taken away anything by force, or has been cruel to his neighbour, ");
INSERT INTO engBBE_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Or has taken a false oath about the loss of something which he has come across by chance; if a man has done any of these evil things, ");
INSERT INTO engBBE_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Causing sin to come on him, then he will have to give back the thing he took by force or got by cruel acts, or the goods which were put in his care or the thing he came on by chance, ");
INSERT INTO engBBE_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Or anything about which he took a false oath; he will have to give it all back, with the addition of a fifth of its value, to him whose property it is, when he has been judged to be in the wrong. ");
INSERT INTO engBBE_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Then let him take to the Lord the offering for his wrongdoing; giving to the priest for his offering, a male sheep from the flock, without any mark, of the value fixed by you: ");
INSERT INTO engBBE_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","And the priest will take away his sin from before the Lord, and he will have forgiveness for whatever crime he has done ");
INSERT INTO engBBE_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Give orders to Aaron and to his sons, saying, This is the law for the burned offering: the offering is to be on the fire-wood on the altar all night till the morning; and the fire of the altar is to be kept burning. ");
INSERT INTO engBBE_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","And the priest is to put on his linen robes and his linen trousers, and take up what is over of the offering after it has been burned on the altar, and put it by the side of the altar. ");
INSERT INTO engBBE_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Then having taken off his linen robes and put on other clothing, he is to take it away into a clean place, outside the tent-circle. ");
INSERT INTO engBBE_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","The fire on the altar is to be kept burning; it is never to go out; every morning the priest is to put wood on it, placing the burned offering in order on it, and there the fat of the peace-offering is to be burned. ");
INSERT INTO engBBE_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Let the fire be kept burning on the altar at all times; it is never to go out. ");
INSERT INTO engBBE_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","And this is the law for the meal offering: it is to be offered to the Lord before the altar by the sons of Aaron. ");
INSERT INTO engBBE_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","The priest is to take in his hand some of the meal of the meal offering and of the oil of it, and all the perfume on it, burning it on the altar as a sign, for a sweet smell to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","And whatever is over Aaron and his sons may have for their food, taking it without leaven in a holy place; in the open space of the Tent of meeting they may take a meal of it. ");
INSERT INTO engBBE_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","It is not to be cooked with leaven. I have given it to them as their part of the offerings made by fire to me; it is most holy, as are the sin-offerings and the offerings for error. ");
INSERT INTO engBBE_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Every male among the children of Aaron may have it for food; it is their right for ever through all your generations, from the offerings made by fire to the Lord: anyone touching them will be holy. ");
INSERT INTO engBBE_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","This is the offering which Aaron and his sons are to make to the Lord on the day when he is made a priest: the tenth part of an ephah of the best meal for a meal offering for ever; half of it in the morning and half in the evening. ");
INSERT INTO engBBE_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Let it be made with oil on a flat plate; when it is well mixed and cooked, let it be broken and taken in as a meal offering, for a sweet smell to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","And the same offering is to be given by that one of his sons who takes his place as priest; by an order for ever, all of it is to be burned before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Every meal offering offered for the priest is to be completely burned: nothing of it is to be taken for food. ");
INSERT INTO engBBE_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Say to Aaron and his sons, This is the law for the sin-offering: the sin-offering is to be put to death before the Lord in the same place as the burned offering; it is most holy. ");
INSERT INTO engBBE_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","The priest by whom it is offered for sin, is to take it for his food in a holy place, in the open space of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Anyone touching the flesh of it will be holy: and if any of the blood is dropped on any clothing, the thing on which the blood has been dropped is to be washed in a holy place. ");
INSERT INTO engBBE_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","But the vessel of earth in which the flesh was cooked is to be broken; or if a brass vessel was used, it is to be rubbed clean and washed out with water. ");
INSERT INTO engBBE_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Every male among the priests may take it for his food: it is most holy. ");
INSERT INTO engBBE_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","No sin-offering, the blood of which is taken into the Tent of meeting, to take away sin in the holy place, may be used for food: it is to be burned with fire. ");
INSERT INTO engBBE_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","And this is the law of the offering for wrongdoing: it is most holy. ");
INSERT INTO engBBE_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","They are to put to death the offering for wrongdoing in the same place as the burned offering; and the priest is to put the blood on and round the altar. ");
INSERT INTO engBBE_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","And all the fat of it, the fat tail and the fat covering the inside parts, is to be given as an offering. ");
INSERT INTO engBBE_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","And the two kidneys, and the fat on them, which is by the top of the legs, and the fat joining the liver and the kidneys, he is to take away: ");
INSERT INTO engBBE_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","They are to be burned by the priest on the altar for an offering made by fire to the Lord: it is an offering for wrongdoing. ");
INSERT INTO engBBE_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Every male among the priests may have it as food in a holy place: it is most holy. ");
INSERT INTO engBBE_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","As is the sin-offering, so is the offering for wrongdoing; there is one law for them: the priest who makes the offering to take away sin, he is to have it. ");
INSERT INTO engBBE_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","And the priest offering any man's burned offering for him, may have the skin of the burned offering which is offered by him. ");
INSERT INTO engBBE_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","And every meal offering which is cooked in the oven and everything made in a cooking pot or on a flat plate, is for the priest by whom it is offered. ");
INSERT INTO engBBE_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","And every meal offering, mixed with oil or dry, is for all the sons of Aaron in equal measure. ");
INSERT INTO engBBE_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","And this is the law for the peace-offerings offered to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","If any man gives his offering as a praise-offering, then let him give with the offering, unleavened cakes mixed with oil and thin unleavened cakes covered with oil and cakes of the best meal well mixed with oil. ");
INSERT INTO engBBE_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","With his peace-offering let him give cakes of leavened bread, as a praise-offering. ");
INSERT INTO engBBE_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","And let him give one out of every offering to be lifted up before the Lord; that it may be for the priest who puts the blood of the peace-offering on the altar. ");
INSERT INTO engBBE_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","And the flesh of the praise-offering is to be taken as food on the day when it is offered; no part of it may be kept till the morning. ");
INSERT INTO engBBE_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","But if his offering is made because of an oath or given freely, it may be taken as food on the day when it is offered; and the rest may be used up on the day after: ");
INSERT INTO engBBE_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","But if any of the flesh of the offering is still unused on the third day, it is to be burned with fire. ");
INSERT INTO engBBE_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","And if any of the flesh of the peace-offering is taken as food on the third day, it will not be pleasing to God and will not be put to the account of him who gives it; it will be unclean and a cause of sin to him who takes it as food. ");
INSERT INTO engBBE_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","And flesh touched by any unclean thing may not be taken for food: it is to be burned with fire; and as for the flesh of the peace-offerings, everyone who is clean may take it as food: ");
INSERT INTO engBBE_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","But he who is unclean when he takes as food the flesh of the peace-offerings, which are the Lord's, will be cut off from his people. ");
INSERT INTO engBBE_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","And anyone who, after touching any unclean thing of man or an unclean beast or any unclean and disgusting thing, takes as food the flesh of the peace-offerings, which are the Lord's, will be cut off from his people. ");
INSERT INTO engBBE_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Say to the children of Israel: You are not to take any fat, of ox or sheep or goat, for food. ");
INSERT INTO engBBE_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","And the fat of that which comes to a natural death, and the fat of that which is attacked by beasts, may be used for other purposes, but not in any way for food. ");
INSERT INTO engBBE_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","For anyone who takes as food the fat of any beast of which men make an offering by fire to the Lord, will be cut off from his people. ");
INSERT INTO engBBE_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","And you are not to take for food any blood, of bird or of beast, in any of your houses. ");
INSERT INTO engBBE_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Whoever takes any blood for food will be cut off from his people. ");
INSERT INTO engBBE_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Say to the children of Israel: He who makes a peace-offering to the Lord, is to give an offering to the Lord out of his peace-offering: ");
INSERT INTO engBBE_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","He himself is to take to the Lord the offering made by fire, even the fat with the breast, so that the breast may be waved for a wave offering before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","And the fat is to be burned by the priest on the altar, but the breast is for Aaron and his sons. ");
INSERT INTO engBBE_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","And the right leg you are to give to the priest for an offering to be lifted up out of what is given for your peace-offerings. ");
INSERT INTO engBBE_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","That man, among the sons of Aaron, by whom the blood of the peace-offering and the fat are offered, is to have the right leg for his part. ");
INSERT INTO engBBE_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","For the breast which is waved and the right leg which is lifted up on high I have taken from the children of Israel, from their peace-offerings, and have given them to Aaron the priest and to his sons as their right for ever from the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","This is the holy part given to Aaron and to his sons, out of the offerings made to the Lord by fire, on the day when they were made priests before the Lord; ");
INSERT INTO engBBE_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Which the Lord said the children of Israel were to give them, on the day when he made them his priests. It is their right for ever from generation to generation. ");
INSERT INTO engBBE_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","These are the laws for the burned offering, the meal offering, and the offering for wrongdoing; and for the making of priests, and for the giving of peace-offerings; ");
INSERT INTO engBBE_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","As they were given by the Lord to Moses on Mount Sinai, on the day when the Lord gave orders to the children of Israel to make their offerings to the Lord, in the waste land of Sinai. ");
INSERT INTO engBBE_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Take Aaron, and his sons with him, and the robes and the holy oil and the ox of the sin-offering and the two male sheep and the basket of unleavened bread; ");
INSERT INTO engBBE_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","And let all the people come together at the door of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","And Moses did as the Lord said, and all the people came together at the door of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","And Moses said to the people, This is what the Lord has given orders to be done. ");
INSERT INTO engBBE_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Then Moses took Aaron and his sons; and after washing them with water, ");
INSERT INTO engBBE_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","He put the coat on him, making it tight with its band, and then the robe, and over it the ephod, with its band of needlework to keep it in place. ");
INSERT INTO engBBE_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","And he put the priest's bag on him, and in the bag he put the Urim and Thummim. ");
INSERT INTO engBBE_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","And on his head he put the head-dress, and in front of the head-dress the plate of gold, the holy crown, as the Lord gave orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","And Moses took the holy oil and put it on the House and on all the things in it, to make them holy. ");
INSERT INTO engBBE_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Seven times he put oil on the altar and on all its vessels, and on the washing-basin and its base, to make them holy. ");
INSERT INTO engBBE_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","And some of the oil he put on Aaron's head, to make him holy. ");
INSERT INTO engBBE_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Then he took Aaron's sons, clothing them with the coats, and putting the bands round them, and the head-dresses on their heads, as the Lord had given him orders. ");
INSERT INTO engBBE_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","And he took the ox of the sin-offering: and Aaron and his sons put their hands on the head of the ox, ");
INSERT INTO engBBE_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","And he put it to death; and Moses took the blood and put it on the horns of the altar and round it with his finger, and made the altar clean, draining out the blood at the base of the altar; so he made it holy, taking away what was unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","And he took all the fat on the inside parts, and the fat on the liver, and the two kidneys with their fat, to be burned on the altar; ");
INSERT INTO engBBE_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","But the ox, with its skin and its flesh and its waste, was burned with fire outside the tent-circle, as the Lord gave orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","And he put the male sheep of the burned offering before the Lord, and Aaron and his sons put their hands on its head, ");
INSERT INTO engBBE_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","And he put it to death; and Moses put some of the blood on and round the altar. ");
INSERT INTO engBBE_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","And when the sheep had been cut into parts, the head and the parts and the fat were burned by Moses. ");
INSERT INTO engBBE_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","And the inside parts and the legs were washed with water and all the sheep was burned by Moses on the altar; it was a burned offering for a sweet smell: it was an offering made by fire to the Lord, as the Lord gave orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","And he put the other sheep before the Lord, the sheep with which they were made priests; and Aaron and his sons put their hands on the head of the sheep, ");
INSERT INTO engBBE_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","And he put it to death; and Moses took some of the blood and put it on the point of Aaron's right ear and on the thumb of his right hand and on the great toe of his right foot. ");
INSERT INTO engBBE_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Then he took Aaron's sons, and Moses put some of the blood on the point of their right ears and on the thumbs of their right hands and on the great toes of their right feet: and Moses put the blood on and round the altar. ");
INSERT INTO engBBE_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","And he took the fat, and the fat tail, and the fat on the inside parts, and the fat on the liver, and the two kidneys with their fat, and the right leg; ");
INSERT INTO engBBE_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","And out of the basket of unleavened bread which was before the Lord he took one unleavened cake, and one cake of bread with oil on it, and one thin cake, and put them on the fat and on the right leg: ");
INSERT INTO engBBE_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","And he put them all on the hands of Aaron and on the hands of his sons, waving them for a wave offering before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","And Moses took them from their hands, and they were burned on the altar on the burned offering, as a priest's offering for a sweet smell, an offering made by fire to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","And Moses took the breast, waving it for a wave offering before the Lord; it was Moses' part of the sheep of the priest's offering, as the Lord gave orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","And Moses took some of the holy oil and of the blood which was on the altar and put it on Aaron and on his robes, and on his sons and on his sons' robes; and made Aaron holy, and his robes and his sons and his sons' robes with him. ");
INSERT INTO engBBE_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","And Moses said to Aaron and to his sons, The flesh is to be cooked in water at the door of the Tent of meeting, and there you are to take it as food, together with the bread in the basket, as I have given orders, saying, It is the food of Aaron and his sons. ");
INSERT INTO engBBE_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","And that which is over of the flesh and of the bread is to be burned with fire. ");
INSERT INTO engBBE_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","And you are not to go out from the door of the Tent of meeting for seven days, till the days for making you priest are ended; for this will be the work of seven days. ");
INSERT INTO engBBE_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","What has been done this day, has been ordered by the Lord to take away your sin. ");
INSERT INTO engBBE_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","And you are to keep watch for the Lord at the door of the Tent of meeting day and night for seven days, so that death may not come to you: for so he has given me orders. ");
INSERT INTO engBBE_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","And Aaron and his sons did all the things about which the Lord had given orders through Moses. ");
INSERT INTO engBBE_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","And on the eighth day Moses sent for Aaron and his sons and the responsible men of Israel; ");
INSERT INTO engBBE_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","And he said to Aaron, Take a young ox for a sin-offering and a male sheep for a burned offering, without a mark, and make an offering of them before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","And say to the children of Israel: Take a he-goat for a sin-offering, and a young ox and a lamb, in their first year, without any mark on them, for a burned offering; ");
INSERT INTO engBBE_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","And an ox and a male sheep for peace-offerings, to be put to death before the Lord; and a meal offering mixed with oil: for this day you are to see the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","And they took the things ordered by Moses, before the Tent of meeting, and all the people came near, waiting before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","And Moses said, This is what the Lord has said you are to do; and you will see the glory of the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","And Moses said to Aaron, Come near to the altar and make your sin-offering and your burned offering to take away your sin and the sin of the people, and make the people's offering to take away their sin; as the Lord has given orders. ");
INSERT INTO engBBE_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","So Aaron came near to the altar and put to death the ox for the sin-offering for himself; ");
INSERT INTO engBBE_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","And the sons of Aaron gave him the blood and he put his finger in the blood and put it on the horns of the altar, draining out the blood at the base of the altar; ");
INSERT INTO engBBE_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","But the fat and the kidneys and the fat on the liver of the sin-offering were burned by him on the altar as the Lord gave orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","And the flesh and the skin were burned with fire outside the tent-circle; ");
INSERT INTO engBBE_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","And he put to death the burned offering; and Aaron's sons gave him the blood and he put some of it on and round the altar; ");
INSERT INTO engBBE_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","And they gave him the parts of the burned offering, in their order, and the head, to be burned on the altar. ");
INSERT INTO engBBE_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","And the inside parts and the legs, when they had been washed with water, were burned on the burned offering on the altar. ");
INSERT INTO engBBE_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","And he made an offering for the people and took the goat of the sin-offering for the people and put it to death, offering it for sin, in the same way as the first. ");
INSERT INTO engBBE_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","And he took the burned offering, offering it in the ordered way; ");
INSERT INTO engBBE_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","And he put the meal offering before the Lord, and taking some of it in his hand he had it burned on the altar, separately from the burned offering of the morning. ");
INSERT INTO engBBE_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","And he put to death the ox and the sheep, which were the peace-offerings for the people; and Aaron's sons gave him the blood and he put some of it on and round the altar; ");
INSERT INTO engBBE_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","And as for the fat of the ox and the fat tail of the sheep and the fat covering the inside parts and the kidneys and the fat on the liver; ");
INSERT INTO engBBE_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","They put the fat on the breasts, and the fat was burned on the altar. ");
INSERT INTO engBBE_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","And Aaron took the breasts and the right leg, waving them for a wave offering before the Lord, as Moses gave orders. ");
INSERT INTO engBBE_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","And Aaron, lifting up his hands to the people, gave them a blessing; and he came down from offering the sin-offering, and the burned offering, and the peace-offerings. ");
INSERT INTO engBBE_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","And Moses and Aaron went into the Tent of meeting, and came out and gave the people a blessing, and the glory of the Lord was seen by all the people. ");
INSERT INTO engBBE_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","And fire came out from before the Lord, burning up the offering on the altar and the fat: and when all the people saw it, they gave a loud cry, falling down on their faces. ");
INSERT INTO engBBE_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","And Nadab and Abihu, the sons of Aaron, took their vessels and put fire in them and perfume, burning strange fire before the Lord, which he had not given them orders to do. ");
INSERT INTO engBBE_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","And fire came out from before the Lord, burning them up and causing their destruction before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Then Moses said to Aaron, This is what the Lord said, I will be holy in the eyes of all those who come near to me, and I will be honoured before all the people. And Aaron said nothing. ");
INSERT INTO engBBE_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","And Moses sent for Mishael and Elzaphan, the sons of Uzziel, the brother of Aaron's father, and said to them, Come near and take your brothers away from before the holy place, outside the tent-circle. ");
INSERT INTO engBBE_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","So they came and took them, in their coats, outside the tent-circle, as Moses had said. ");
INSERT INTO engBBE_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","And Moses said to Aaron and to Eleazar and Ithamar, his sons, Do not let your hair be loose, and give no signs of grief; so that death may not overtake you, and his wrath come on all the people; but let there be weeping among your brothers and all the house of Israel for this burning of the Lord's fire. ");
INSERT INTO engBBE_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","And do not go out from the door of the Tent of meeting, or death will come to you; for the holy oil of the Lord is on you. And they did as Moses said. ");
INSERT INTO engBBE_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","And the Lord said to Aaron: ");
INSERT INTO engBBE_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Take no wine, or strong drink, you or your sons with you, when you go into the Tent of meeting, that it may not be the cause of death to you; this is an order for ever through all your generations. ");
INSERT INTO engBBE_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","And make a division between the holy and the common, and between the unclean and the clean; ");
INSERT INTO engBBE_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Teaching the children of Israel all the laws which the Lord has given them by the hand of Moses. ");
INSERT INTO engBBE_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","And Moses said to Aaron and to Eleazar and Ithamar, his sons who were still living, Take the rest of the meal offering from the offerings of the Lord made by fire, and take it for your food, without leaven, at the side of the altar, for it is most holy. ");
INSERT INTO engBBE_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","It is to be for your food in a holy place, because it is your right and your sons' right, from the offerings of the Lord made by fire: for so am I ordered. ");
INSERT INTO engBBE_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","And the breast which is waved and the leg which is lifted up on high, you are to take as your food in a clean place; you and your sons and your daughters with you: for they are given to you as your right and your sons' right, from the peace-offerings of the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Let them take the breast which is waved and the leg which is lifted up on high, with the fat of the burned offering, to be waved for a wave offering before the Lord; and this will be for you and for your sons with you, for a right for ever, as the Lord has given orders. ");
INSERT INTO engBBE_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","And Moses was looking for the goat of the sin-offering, but it was burned; and he was angry with Eleazar and Ithamar, the sons of Aaron, who were still living, saying, ");
INSERT INTO engBBE_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Why did you not make a meal of the sin-offering in the holy place? For it is most holy and he has given it to you, so that the sin of the people may be put on it, to take away their sin before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","See, its blood was not taken into the holy place: certainly it was right for you to have taken it as food in the holy place, as I gave orders. ");
INSERT INTO engBBE_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","And Aaron said to Moses, You have seen that today they have made their sin-offering and their burned offering before the Lord, and such things as these have come on me. If I had taken the sin-offering as food today, would it have been pleasing to the Lord? ");
INSERT INTO engBBE_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","And after hearing this, Moses was no longer angry. ");
INSERT INTO engBBE_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","And the Lord said to Moses and Aaron, ");
INSERT INTO engBBE_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Say to the children of Israel: These are the living things which you may have for food among all the beasts on the earth. ");
INSERT INTO engBBE_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","You may have as food any beast which has a division in the horn of its foot, and whose food comes back into its mouth to be crushed again. ");
INSERT INTO engBBE_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","But, at the same time, of those beasts, you may not take for food the camel, because its food comes back but the horn of its foot is not parted in two; it is unclean to you. ");
INSERT INTO engBBE_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","And the rock-badger, for the same reason, is unclean to you. ");
INSERT INTO engBBE_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","And the hare, because the horn of its foot is not parted in two, is unclean to you. ");
INSERT INTO engBBE_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","And the pig is unclean to you, because though the horn of its foot is parted, its food does not come back. ");
INSERT INTO engBBE_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Their flesh may not be used for food, and their dead bodies may not even be touched; they are unclean to you. ");
INSERT INTO engBBE_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","These you may have for food of all things living in the water: anything living in the water, in the seas or rivers, which has special parts for swimming and skin formed of thin plates, may be used for food. ");
INSERT INTO engBBE_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","All other things living and moving in the water, in the sea or in the rivers, are a disgusting thing to you; ");
INSERT INTO engBBE_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","They may not be used for food, and their dead bodies are disgusting to you. ");
INSERT INTO engBBE_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Anything in the water which has no special parts for swimming and no thin plates on its skin is disgusting to you. ");
INSERT INTO engBBE_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","And among birds these are to be disgusting to you, and not to be used for food: the eagle and the gier-eagle and the ospray; ");
INSERT INTO engBBE_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","And the kite and the falcon, and birds of that sort; ");
INSERT INTO engBBE_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","Every raven, and birds of that sort; ");
INSERT INTO engBBE_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","And the ostrich and the night-hawk and the sea-hawk, and birds of that sort; ");
INSERT INTO engBBE_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","And the little owl and the cormorant and the great owl; ");
INSERT INTO engBBE_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","And the water-hen and the pelican and the vulture; ");
INSERT INTO engBBE_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","The stork and the heron, and birds of that sort, and the hoopoe and the bat. ");
INSERT INTO engBBE_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Every winged four-footed thing which goes on the earth is disgusting to you; ");
INSERT INTO engBBE_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","But of the winged four-footed things, those which have long legs for jumping on the earth you may have for food; ");
INSERT INTO engBBE_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Such as all the different sorts of locust. ");
INSERT INTO engBBE_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","But all other winged four-footed things which go on the earth are disgusting to you. ");
INSERT INTO engBBE_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","By these you will be made unclean; anyone touching their dead bodies will be unclean till evening: ");
INSERT INTO engBBE_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Whoever takes away the dead body of one of them is to have his clothing washed, and will be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Every beast, in the horn of whose foot there is not a complete division, and whose food does not come back, is unclean to you: anyone touching one of these will be unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Any four-footed beast which goes on the ball of its foot, is unclean to you: anyone touching the dead body of one of these will be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Anyone who takes away the dead body of one of these is to have his clothing washed and be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","And these are unclean to you among things which go low down on the earth; the weasel and the mouse and the great lizard, and animals of that sort; ");
INSERT INTO engBBE_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","And the ferret and the land crocodile and the lizard and the sand-lizard and the chameleon. ");
INSERT INTO engBBE_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","All these are unclean to you: anyone touching them when they are dead will be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","The dead body of any of these, falling on anything, will make that thing unclean; if it is any vessel of wood, or clothing, or skin, or bag, whatever it is, if it is used for any purpose, it will have to be put into water, and will be unclean till evening; after that it will be clean. ");
INSERT INTO engBBE_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","And if one of them gets into any vessel of earth, whatever is in the vessel will be unclean and the vessel will have to be broken. ");
INSERT INTO engBBE_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Any food in it, and anything on which water from it comes, will be unclean: any drink taken from such a vessel will be unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Any part of the dead body of one of these, falling on anything, will make it unclean; if it is an oven or a cooking-pot it will have to be broken: they are unclean and will be unclean to you. ");
INSERT INTO engBBE_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","But at the same time a fountain or a place where water is stored for use will be clean; but anyone touching their dead bodies will be unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","If any part of the dead body of one of these gets on to any seed for planting, it is clean; ");
INSERT INTO engBBE_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","But if water is put on the seed, and any part of the dead body gets on to it, it will be unclean to you. ");
INSERT INTO engBBE_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","And if any beast which may be used for food comes to a natural death, anyone touching its dead body will be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","And he who makes use of any part of its body for food is to have his clothing washed and be unclean till evening; and anyone taking away its body is to have his clothing washed and be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Everything which goes flat on its body on the earth is disgusting, and is not to be used for food. ");
INSERT INTO engBBE_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Whatever goes on its stomach or on four feet or has a great number of feet, even all those going flat on the earth, may not be used for food, for they are disgusting. ");
INSERT INTO engBBE_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","You are not to make yourselves disgusting with anything which goes about flat on the earth; you may not make yourselves unclean with them, in such a way that you are not holy to me. ");
INSERT INTO engBBE_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","For I am the Lord your God: for this reason, make and keep yourselves holy, for I am holy; you are not to make yourselves unclean with any sort of thing which goes about flat on the earth. ");
INSERT INTO engBBE_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","For I am the Lord, who took you out of the land of Egypt, to be your God; so be you holy, for I am holy. ");
INSERT INTO engBBE_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","This is the law about beasts and birds and every living thing moving in the waters, and every living thing which goes flat on the earth: ");
INSERT INTO engBBE_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Marking out the unclean from the clean, and the living thing which may be used for food from that which may not. ");
INSERT INTO engBBE_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Say to the children of Israel, If a woman is with child and gives birth to a male child, she will be unclean for seven days, as when she is unwell. ");
INSERT INTO engBBE_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","And on the eighth day let him be given circumcision. ");
INSERT INTO engBBE_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","And she will be unclean for thirty-three days till the flow of her blood is stopped; no holy thing may be touched by her, and she may not come into the holy place, till the days for making her clean are ended. ");
INSERT INTO engBBE_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","But if she gives birth to a female child, then she will be unclean for two weeks, as when she is unwell; and she will not be completely clean for sixty-six days. ");
INSERT INTO engBBE_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","And when the days are ended for making her clean for a son or a daughter, let her take to the priest at the door of the Tent of meeting, a lamb of the first year for a burned offering and a young pigeon or a dove for a sin-offering: ");
INSERT INTO engBBE_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","And the priest is to make an offering of it before the Lord and take away her sin, and she will be made clean from the flow of her blood. This is the law for a woman who gives birth to a male or a female. ");
INSERT INTO engBBE_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","And if she has not money enough for a lamb, then let her take two doves or two young pigeons, one for a burned offering and the other for a sin-offering, and the priest will take away her sin and she will be clean, ");
INSERT INTO engBBE_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","And the Lord said to Moses and Aaron, ");
INSERT INTO engBBE_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","If a man has on his skin a growth or a mark or a white place, and it becomes the disease of a leper, let him be taken to Aaron the priest, or to one of the priests, his sons; ");
INSERT INTO engBBE_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","And if, when the priest sees the mark on his skin, the hair on the place is turned white and the mark seems to go deeper than the skin, it is the mark of a leper: and the priest, after looking at him, will say that he is unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","But if the mark on his skin is white, and does not seem to go deeper than the skin, and the hair on it is not turned white, then the priest will keep him shut up for seven days; ");
INSERT INTO engBBE_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","And the priest is to see him on the seventh day; and if, in his opinion, the place on his skin has not become worse and is not increased in size, then the priest will keep him shut up for seven days more: ");
INSERT INTO engBBE_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","And the priest is to see him again on the seventh day; and if the mark is less bright and is not increased on his skin, then let the priest say that he is clean: it is only a skin-mark, and after his clothing has been washed he will be clean. ");
INSERT INTO engBBE_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","But if the size of the mark on his skin is increased after he has been seen by the priest, let him go to the priest again: ");
INSERT INTO engBBE_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","And if, after looking at him, he sees that the mark is increased in his skin, let the priest say that he is unclean; he is a leper. ");
INSERT INTO engBBE_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","When the disease of a leper is seen on a man, let him be taken to the priest; ");
INSERT INTO engBBE_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","And if the priest sees that there is a white growth on the skin, and the hair is turned white, and there is diseased flesh in the growth, ");
INSERT INTO engBBE_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","It is an old disease in the skin of his flesh, and the priest will say that he is unclean; he will not have to be shut up, for he is clearly unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","And if the disease comes out all over his skin, from his head to his feet, as far as the priest is able to see, ");
INSERT INTO engBBE_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","And if the priest sees that all his flesh is covered with the leper's disease, the priest will say that he is clean: it is all turned white, he is clean. ");
INSERT INTO engBBE_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","But whenever diseased flesh is seen on him, he will be unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","And when the priest sees the diseased flesh he will say that he is unclean; the diseased flesh is unclean, he is a leper. ");
INSERT INTO engBBE_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Or if the diseased flesh is turned again and changed to white then he is to come to the priest, ");
INSERT INTO engBBE_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","And the priest will see him: and if the place is turned white, then the priest will say that he is free from the disease. ");
INSERT INTO engBBE_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","And if a bad place has come out on the skin and is well again, ");
INSERT INTO engBBE_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","And on the same place there is a white growth of a bright mark, red and white, then let the priest see it; ");
INSERT INTO engBBE_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","And after looking at it, if it seems to go deeper than the skin, and the hair on it is turned white, then the priest will say that the man is unclean: it is the leper's disease, it has come out in the bad place. ");
INSERT INTO engBBE_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","But if, after looking at it, he sees that there are no white hairs on it, and it is not deeper than the skin, and it is not very bright, then let the priest keep him shut up for seven days: ");
INSERT INTO engBBE_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","And if it is increasing on the skin, the priest will say that he is unclean: it is a disease. ");
INSERT INTO engBBE_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","But if the bright mark keeps in the same place and gets no greater, it is the mark of the old wound, and the priest will say that he is clean. ");
INSERT INTO engBBE_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Or if there is a burn on the skin of the flesh, and if the diseased flesh in the burn becomes a bright place, red and white or white, ");
INSERT INTO engBBE_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","The priest is to see it: and if the hair on the bright place is turned white and it seems to go deeper than the skin, he is a leper: it has come out in the burn, and the priest will say that he is unclean: it is the leper's disease. ");
INSERT INTO engBBE_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","But if, after looking at it, the priest sees that there is no white hair on the bright place, and it is not deeper than the skin, and is not very bright, then let the priest keep him shut up for seven days: ");
INSERT INTO engBBE_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","And the priest is to see him again on the seventh day; if it is increased in the skin, then the priest will say that he is unclean: it is the leper's disease. ");
INSERT INTO engBBE_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","And if the bright place keeps the same size and gets no greater on the skin, but is less bright, it is the effect of the burn, and the priest will say that he is clean: it is the mark of the burn. ");
INSERT INTO engBBE_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","And when a man or a woman has a disease on the head, or in the hair of the chin, ");
INSERT INTO engBBE_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","Then the priest is to see the diseased place: and if it seems to go deeper than the skin, and if there is thin yellow hair in it, then the priest will say that he is unclean: he has the mark of the leper's disease on his head or in the hair of his chin. ");
INSERT INTO engBBE_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","And after looking at the diseased place, if it does not seem to go deeper than the skin, and there is no black hair in it, then the priest will have him shut up for seven days: ");
INSERT INTO engBBE_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","And on the seventh day the priest will see the place: and if it is not increased, and there is no yellow hair in it, and it does not seem to go deeper than the skin, ");
INSERT INTO engBBE_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","Then his hair is to be cut off, but not on the diseased place, and he is to be shut up for seven days more: ");
INSERT INTO engBBE_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","And on the seventh day the priest will see the place: and if it is not increased, and does not seem to go deeper than the skin, the priest will say that he is clean: and after his clothing has been washed he will be clean. ");
INSERT INTO engBBE_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","But if the disease in his skin becomes worse after he has been made clean, ");
INSERT INTO engBBE_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Then the priest is to see him: and if the mark is increased, the priest, without looking for the yellow hair, will say that he is unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","But if, in his opinion, the growth is stopped, and black hair has come up on it, the disease has gone; he is clean and the priest will say that he is clean. ");
INSERT INTO engBBE_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","And if a man or a woman has bright marks on the skin of their flesh, that is, bright white marks, ");
INSERT INTO engBBE_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","Then the priest is to see them: and if the white marks on their skin are not very bright, it is a skin disease which has come out on the skin; he is clean. ");
INSERT INTO engBBE_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","And if a man's hair has come out and he has no hair, still he is clean. ");
INSERT INTO engBBE_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","And if the hair has gone from the front part of his head, so that he has no hair there, still he is clean. ");
INSERT INTO engBBE_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","But if, on his head or on his brow, where he has no hair, there is a red and white place, it is the disease of the leper coming out on his head or on his brow. ");
INSERT INTO engBBE_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Then if the priest sees that the growth of the disease has become red and white on his head or on his brow where there is no hair, like the mark in the skin of a leper; ");
INSERT INTO engBBE_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","He is a leper and unclean; the priest is to say that he is most certainly unclean: the disease is in his head. ");
INSERT INTO engBBE_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","And the leper who has the disease on him is to go about with signs of grief, with his hair loose and his mouth covered, crying, Unclean, unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","While the disease is on him, he will be unclean. He is unclean: let him keep by himself, living outside the tent-circle. ");
INSERT INTO engBBE_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","And any clothing of wool or of linen in which is the mark of the disease; ");
INSERT INTO engBBE_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","If it is in the threads of the linen or of the wool, or in leather, or in anything made of skin; ");
INSERT INTO engBBE_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","If there are red or green marks on the clothing, or on the leather, or in the threads of the cloth, or in anything made of skin, it is the leper's disease: let the priest see it. ");
INSERT INTO engBBE_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","And after it has been seen by the priest, the thing which is so marked is to be shut up for seven days: ");
INSERT INTO engBBE_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","And he is to see the mark on the seventh day; if the mark is increased in the clothing, or in the threads of the material, or in the leather, whatever the leather is used for, it is the disease biting into it: it is unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","And the clothing, or the wool or linen material, or anything of leather in which is the disease, is to be burned: for the disease is biting into it; let it be burned in the fire. ");
INSERT INTO engBBE_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","And if the priest sees that the mark is not increased in the clothing or in any part of the material or in the leather, ");
INSERT INTO engBBE_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","Then the priest will give orders for the thing on which the mark is, to be washed, and to be shut up for seven days more: ");
INSERT INTO engBBE_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","And if, after the mark has been washed, the priest sees that the colour of it is not changed and it is not increased, it is to be burned in the fire: the disease is working in it, though the damage may be inside or outside. ");
INSERT INTO engBBE_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","And if the priest sees that the mark is less bright after the washing, then let him have it cut out of the clothing or the leather or from the threads of the material: ");
INSERT INTO engBBE_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","And if the mark is still seen in the clothing or in the threads of the material or in the leather, it is the disease coming out: the thing in which the disease is will have to be burned with fire. ");
INSERT INTO engBBE_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","And the material of the clothing, or anything of skin, which has been washed, if the mark has gone out of it, let it be washed a second time and it will be clean. ");
INSERT INTO engBBE_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","This is the law about the leper's disease in the thread of wool or linen material, in clothing or in anything of skin, saying how it is to be judged clean or unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","This is the law of the leper on the day when he is made clean: he is to be taken to the priest; ");
INSERT INTO engBBE_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","And the priest is to go outside the tent-circle; and if, after looking, the priest sees that the mark of the disease has gone from him, ");
INSERT INTO engBBE_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Then the priest is to give orders to take, for him who is to be made clean, two living clean birds and some cedar wood and red thread and hyssop. ");
INSERT INTO engBBE_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","And the priest will give orders for one of the birds to be put to death in a vessel made of earth, over flowing water. ");
INSERT INTO engBBE_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","And he will take the living bird and the wood and the red thread and the hyssop and put them in the blood of the bird which was put to death over flowing water. ");
INSERT INTO engBBE_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","And shaking it seven times over the man who is to be made clean, he will say that he is clean and will let the living bird go free into the open country. ");
INSERT INTO engBBE_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","And he who is to be made clean will have his clothing washed and his hair cut and have a bath, and he will be clean. And after that he will come back to the tent-circle; but he is to keep outside his tent for seven days. ");
INSERT INTO engBBE_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","And on the seventh day he is to have all the hair cut off his head and his chin and over his eyes — all his hair is to be cut off — and he will have his clothing washed and his body bathed in water and he will be clean. ");
INSERT INTO engBBE_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","And on the eighth day let him take two male lambs, without any marks on them, and one female lamb of the first year, without a mark, and three tenth parts of an ephah of the best meal, mixed with oil, and one log of oil. ");
INSERT INTO engBBE_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","And the priest who is making him clean will put the man who is being made clean, together with these things, before the door of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","And the priest is to take one of the male lambs and give it as an offering for wrongdoing, and the log of oil, waving them for a wave offering before the Lord; ");
INSERT INTO engBBE_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","And he is to put the male lamb to death in the place where they put to death the sin-offering and the burned offering, in the holy place; for as the sin-offering is the property of the priest, so is the offering for wrongdoing: it is most holy. ");
INSERT INTO engBBE_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","And let the priest take some of the blood of the offering for wrongdoing and put it on the point of the right ear of him who is to be made clean, and on the thumb of his right hand and on the great toe of his right foot; ");
INSERT INTO engBBE_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","And take some of the oil and put it in the hollow of his left hand; ");
INSERT INTO engBBE_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","And let the priest put his right finger in the oil which is in his left hand, shaking it out with his finger seven times before the Lord; ");
INSERT INTO engBBE_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","And of the rest of the oil which is in his hand, the priest will put some on the point of the right ear of the man who is to be made clean, and on the thumb of his right hand and on the great toe of his right foot, over the blood of the offering for wrongdoing; ");
INSERT INTO engBBE_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","And the rest of the oil in the priest's hand he will put on the head of him who is to be made clean; and so the priest will make him free from sin before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","And the priest will give the sin-offering, and take away the sin of him who is to be made clean from his unclean condition; and after that he will put the burned offering to death. ");
INSERT INTO engBBE_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","And the priest is to have the burned offering and the meal offering burned on the altar; and the priest will take away his sin and he will be clean. ");
INSERT INTO engBBE_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","And if he is poor and not able to get so much, then he may take one male lamb as an offering for wrongdoing, to be waved to take away his sin, and one tenth part of an ephah of the best meal mixed with oil for a meal offering, and a log of oil; ");
INSERT INTO engBBE_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","And two doves or two young pigeons, such as he is able to get; and one will be for a sin-offering and the other for a burned offering. ");
INSERT INTO engBBE_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","And on the eighth day he will take them to the priest, to the door of the Tent of meeting before the Lord, so that he may be made clean. ");
INSERT INTO engBBE_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","And the priest will take the lamb of the offering for wrongdoing and the oil, waving them for a wave offering before the Lord; ");
INSERT INTO engBBE_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","And he will put to death the lamb of the offering for wrongdoing and the priest will take some of the blood of the offering for wrongdoing and put it on the point of the right ear of him who is to be made clean, and on the thumb of his right hand and on the great toe of his right foot; ");
INSERT INTO engBBE_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","And the priest will put out some of the oil in the hollow of his left hand, ");
INSERT INTO engBBE_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Shaking out drops of oil with his right finger before the Lord seven times: ");
INSERT INTO engBBE_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","And the priest will put some of the oil which is in his hand on the point of the ear of the man who is to be made clean and on the thumb of his right hand and on the great toe of his right foot, on the place where the blood of the offering for wrongdoing was put; ");
INSERT INTO engBBE_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","And the rest of the oil which is in the priest's hand he will put on the head of him who is to be made clean, to take away his sin before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","And he will make an offering of one of the doves or the young pigeons, such as he is able to get; ");
INSERT INTO engBBE_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","And of these, he will give one for a sin-offering and one for a burned offering, with the meal offering; and the priest will take away the sin of him who is to be made clean before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","This is the law for the man who has the disease of the leper on him, and who is not able to get that which is necessary for making himself clean. ");
INSERT INTO engBBE_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","And the Lord said to Moses and Aaron, ");
INSERT INTO engBBE_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","When you have come into the land of Canaan which I will give you for your heritage, if I put the leper's disease on a house in the land of your heritage, ");
INSERT INTO engBBE_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Then let the owner of the house come and say to the priest, It seems to me that there is a sort of leper's disease in the house. ");
INSERT INTO engBBE_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","And the priest will give orders for everything to be taken out of the house, before he goes in to see the disease, so that the things in the house may not become unclean; and then the priest is to go in to see the house; ");
INSERT INTO engBBE_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","And if he sees that the walls of the house are marked with hollows of green and red, and if it seems to go deeper than the face of the wall; ");
INSERT INTO engBBE_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Then the priest will go out of the door of the house, and keep the house shut up for seven days: ");
INSERT INTO engBBE_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","And the priest is to come again on the seventh day and have a look and see if the marks on the walls of the house are increased in size; ");
INSERT INTO engBBE_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Then the priest will give orders to them to take out the stones in which the disease is seen, and put them out into an unclean place outside the town: ");
INSERT INTO engBBE_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","And he will have the house rubbed all over inside, and the paste which is rubbed off will be put out into an unclean place outside the town: ");
INSERT INTO engBBE_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","And they will take other stones and put them in place of those stones, and he will take other paste and put it on the walls of the house. ");
INSERT INTO engBBE_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","And if the disease comes out again in the house after he has taken out the stones and after the walls have been rubbed and the new paste put on, ");
INSERT INTO engBBE_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Then the priest will come and see it; and if the disease in the house is increased in size, it is the leper's disease working out in the house: it is unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","And the house will have to be pulled down, the stones of it and the wood and the paste; and everything is to be taken out to an unclean place outside the town. ");
INSERT INTO engBBE_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","And, in addition, anyone who goes into the house at any time, while it is shut up, will be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","And anyone who has been sleeping in the house will have to have his clothing washed; and anyone who takes food in that house will have to have his clothing washed. ");
INSERT INTO engBBE_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","And if the priest comes in, and sees that the disease is not increased after the new paste has been put on the house, then the priest will say that the house is clean, because the disease is gone. ");
INSERT INTO engBBE_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","And in order to make the house clean, let him take two birds and cedar-wood and red thread and hyssop; ");
INSERT INTO engBBE_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","And put one of the birds to death in a vessel of earth over flowing water; ");
INSERT INTO engBBE_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","And take the cedar-wood and the hyssop and the red thread and the living bird and put them in the blood of the dead bird and in the flowing water, shaking it over the house seven times. ");
INSERT INTO engBBE_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","And he will make the house clean with the blood of the bird and the flowing water and with the living bird and with the cedar-wood and the hyssop and the red thread. ");
INSERT INTO engBBE_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","But he will let the living bird go out of the town into the open country; so he will take away sin from the house and it will be clean. ");
INSERT INTO engBBE_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","This is the law for all signs of the leper's disease and for skin diseases; ");
INSERT INTO engBBE_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","And for signs of disease in clothing, or in a house; ");
INSERT INTO engBBE_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","And for a growth or a bad place or a bright mark on the skin; ");
INSERT INTO engBBE_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","To make clear when it is unclean and when it is clean: this is the law about the disease of the leper. ");
INSERT INTO engBBE_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","And the Lord said to Moses and to Aaron, ");
INSERT INTO engBBE_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Say to the children of Israel: If a man has an unclean flow from his flesh, it will make him unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","If the flow goes on or if the part is stopped up, to keep back the flow, he is still unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Every bed on which he has been resting will be unclean, and everything on which he has been seated will be unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","And anyone touching his bed is to have his clothing washed and his body bathed in water and be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","And he who has been seated on anything on which the unclean man has been seated is to have his clothing washed and his body bathed in water and be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","And anyone touching the flesh of the unclean man is to have his clothing washed and his body bathed in water and be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","And if liquid from the mouth of the unclean man comes on to him who is clean, then he is to have his clothing washed and his body bathed in water and be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","And any leather seat on a horse on which the unclean man has been seated will be unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","And anyone touching anything which was under him will be unclean till the evening; anyone taking up any of these things is to have his clothing washed and his body bathed in water and be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","And anyone on whom the unclean man puts his hands, without washing them in water, is to have his clothing washed and his body bathed in water and be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","And any vessel of earth which has been touched by the unclean man will have to be broken and any vessel of wood washed. ");
INSERT INTO engBBE_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","And when a man who has a flow from his body is made clean from it, he is to take seven days to make himself clean, washing his clothing and bathing his body in flowing water, and then he will be clean. ");
INSERT INTO engBBE_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","And on the eighth day he is to take two doves or two young pigeons and come before the Lord to the door of the Tent of meeting and give them to the priest: ");
INSERT INTO engBBE_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","And they are to be offered by the priest, one for a sin-offering and one for a burned offering, and the priest will take away his sin before the Lord on account of his flow. ");
INSERT INTO engBBE_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","And if a man's seed goes out from him, then all his body will have to be bathed in water and he will be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","And any clothing or skin on which the seed comes is to be washed with water and be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","And if a man has sex relations with a woman and his seed goes out from him, the two of them will have to be bathed in water and will be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","And if a woman has a flow of blood from her body, she will have to be kept separate for seven days, and anyone touching her will be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","And everything on which she has been resting, while she is kept separate, will be unclean, and everything on which she has been seated will be unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","And anyone touching her bed will have to have his clothing washed and his body bathed in water and be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","And anyone touching anything on which she has been seated will have to have his clothing washed and his body bathed in water and be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Anyone touching anything on the bed or on the thing on which she has been seated, will be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","And if any man has sex relations with her so that her blood comes on him, he will be unclean for seven days and every bed on which he has been resting will be unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","And if a woman has a flow of blood for a long time, not at the time when she generally has it, or if the flow goes on longer than the normal time, she will be unclean while the flow of blood goes on, as she is at other normal times. ");
INSERT INTO engBBE_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Every bed on which she has been resting will be unclean, as at the times when she normally has a flow of blood, and everything on which she has been seated will be unclean, in the same way. ");
INSERT INTO engBBE_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","And anyone touching these things will be unclean, and his clothing will have to be washed and his body bathed in water and he will be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","But when her flow of blood is stopped, after seven days she will be clean. ");
INSERT INTO engBBE_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","And on the eighth day let her get two doves or two young pigeons and take them to the priest to the door of the Tent of meeting, ");
INSERT INTO engBBE_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","To be offered by the priest, one for a sin-offering and one for a burned offering; and the priest will take away her sin before the Lord on account of her unclean condition. ");
INSERT INTO engBBE_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","In this way may the children of Israel be made free from all sorts of unclean conditions, so that death may not overtake them when they are unclean and when they make unclean my holy place which is among them. ");
INSERT INTO engBBE_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","This is the law for the man who has a flow from his body, or whose seed goes from him so that he is unclean; ");
INSERT INTO engBBE_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","And for her who has a flow of blood, and for any man or woman who has an unclean flow, and for him who has sex relations with a woman when she is unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","And the Lord said to Moses, after the death of the two sons of Aaron when they took in strange fire before the Lord and death overtook them; ");
INSERT INTO engBBE_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","The Lord said to Moses, Say to Aaron, your brother, that he may not come at all times into the holy place inside the veil, before the cover which is on the ark, for fear that death may overtake him; for I will be seen in the cloud on the cover of the ark. ");
INSERT INTO engBBE_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Let Aaron come into the holy place in this way: with an ox for a sin-offering and a male sheep for a burned offering. ");
INSERT INTO engBBE_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Let him put on the holy linen coat, and the linen trousers on his body, and the linen band round him, and the linen head-dress on his head; for this is holy clothing, and before he puts them on his body is to be washed with water. ");
INSERT INTO engBBE_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","And let him take from the children of Israel two he-goats for a sin-offering and one male sheep for a burned offering. ");
INSERT INTO engBBE_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","And Aaron is to give the ox of the sin-offering for himself, to make himself and his house free from sin. ");
INSERT INTO engBBE_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","And he is to take the two goats and put them before the Lord at the door of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","And Aaron will make selection from the two goats by the decision of the Lord, one goat for the Lord and one for Azazel. ");
INSERT INTO engBBE_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","And the goat which is marked out for the Lord, let Aaron give for a sin-offering. ");
INSERT INTO engBBE_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","But the goat for Azazel is to be placed living before the Lord, for the taking away of sin, that it may be sent away for Azazel into the waste land. ");
INSERT INTO engBBE_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","And Aaron is to give the ox of the sin-offering for himself and take away sin from himself and his house, and put to death the ox of the sin-offering which is for himself. ");
INSERT INTO engBBE_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","And he is to take a vessel full of burning coal from the altar before the Lord and in his hand some sweet perfume crushed small, and take it inside the veil; ");
INSERT INTO engBBE_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","And let him put the perfume on the fire before the Lord so that the ark may be covered with a cloud of the smoke of the perfume, in order that death may not overtake him. ");
INSERT INTO engBBE_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","And let him take some of the blood of the ox, shaking drops of it from his finger on the cover of the ark on the east side, and before it, seven times. ");
INSERT INTO engBBE_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Then let him put to death the goat of the sin-offering for the people, and take its blood inside the veil and do with it as he did with the blood of the ox, shaking drops of it on and before the cover of the ark. ");
INSERT INTO engBBE_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","And let him make the holy place free from whatever is unclean among the children of Israel and from their wrongdoing in all their sins; and let him do the same for the Tent of meeting, which has its place among an unclean people. ");
INSERT INTO engBBE_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","And no man may be in the Tent of meeting from the time when Aaron goes in to take away sin in the holy place till he comes out, having made himself and his house and all the people of Israel free from sin. ");
INSERT INTO engBBE_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","And he is to go out to the altar which is before the Lord and make it free from sin; and he is to take some of the blood of the ox and the blood of the goat and put it on the horns of the altar and round it; ");
INSERT INTO engBBE_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Shaking drops of the blood from his finger on it seven times to make it holy and clean from whatever is unclean among the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","And when he has done whatever is necessary to make the holy place and the Tent of meeting and the altar free from sin, let him put the living goat before the Lord; ");
INSERT INTO engBBE_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","And Aaron, placing his two hands on the head of the living goat, will make a public statement over him of all the evil doings of the children of Israel and all their wrongdoing, in all their sins; and he will put them on the head of the goat and send him away, in the care of a man who will be waiting there, into the waste land. ");
INSERT INTO engBBE_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","And the goat will take all their sins into a land cut off from men, and he will send the goat away into the waste land. ");
INSERT INTO engBBE_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Then let Aaron come into the Tent of meeting and take off the linen clothing which he put on when he went into the holy place, and put them down there; ");
INSERT INTO engBBE_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","And after bathing his body in water in a holy place, he is to put on his clothing and come out and give his burned offering and the burned offering of the people, to take away his sin and the sin of the people. ");
INSERT INTO engBBE_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","And the fat of the sin-offering is to be burned by him on the altar. ");
INSERT INTO engBBE_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","And the man who takes away the goat for Azazel is to have his clothing washed and his body bathed in water and then he may come back to the tent-circle. ");
INSERT INTO engBBE_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","And the ox of the sin-offering and the goat of the sin-offering, whose blood was taken in to make the holy place free from sin, are to be taken away outside the tent-circle and their skins and their flesh and their waste are to be burned with fire. ");
INSERT INTO engBBE_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","And the man by whom they are burned is to have his clothing washed and his body bathed in water, and then he may come back to the tent-circle. ");
INSERT INTO engBBE_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","And let this be an order to you for ever: in the seventh month, on the tenth day, you are to keep yourselves from pleasure and do no sort of work, those who are Israelites by birth and those from other lands who are living among you: ");
INSERT INTO engBBE_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","For on this day your sin will be taken away and you will be clean: you will be made free from all your sins before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","It is a special Sabbath for you, and you are to keep yourselves from pleasure; it is an order for ever. ");
INSERT INTO engBBE_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","And the man on whose head the holy oil has been put, and who has been marked out to be a priest in his father's place, will do what is necessary to take away sin, and will put on the linen clothing, even the holy robes: ");
INSERT INTO engBBE_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","And he will make the holy place and the Tent of meeting and the altar free from sin; he will take away sin from the priests and from all the people. ");
INSERT INTO engBBE_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","And let this be an order for ever for you, so that the sin of the children of Israel may be taken away once every year. And he did as the Lord gave orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Say to Aaron and to his sons and to all the children of Israel: This is the order which the Lord has given. ");
INSERT INTO engBBE_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","If any man of Israel puts to death an ox or a lamb or a goat, in or outside the tent-circle; ");
INSERT INTO engBBE_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","And has not taken it to the door of the Tent of meeting, to make an offering to the Lord, before the Lord's House, its blood will be on him, for he has taken life, and he will be cut off from among his people: ");
INSERT INTO engBBE_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","So that the children of Israel may take to the Lord, to the door of the Tent of meeting and to the priest, the offerings which they have put to death in the open country, and that they may make their peace-offerings to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","And the priest will put blood on the altar of the Lord at the door of the Tent of meeting, burning the fat for a sweet smell to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","And let them make no more offerings to evil spirits, after which they have gone, turning away from the Lord. Let this be a law to them for ever, through all their generations. ");
INSERT INTO engBBE_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","And say to them, If any man of Israel, or any other living among them, makes a burned offering or other offering, ");
INSERT INTO engBBE_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","And does not take it to the door of the Tent of meeting to make an offering to the Lord, that man will be cut off from among his people. ");
INSERT INTO engBBE_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","And if any man of Israel, or any other living among them, takes any sort of blood for food, my wrath will be turned against that man and he will be cut off from among his people. ");
INSERT INTO engBBE_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","For the life of the flesh is in its blood; and I have given it to you on the altar to take away your sin: for it is the blood which makes free from sin because of the life in it. ");
INSERT INTO engBBE_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","For this reason I have said to the children of Israel, No man among you, or any others living with you, may take blood as food. ");
INSERT INTO engBBE_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","And any man of Israel, or any other living among them, who gets with his bow any beast or bird used for food, is to see that its blood is covered with earth. ");
INSERT INTO engBBE_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","For the blood is the life of all flesh: and so I have said to the children of Israel, You may not take any sort of blood as food, and any man who does so will be cut of. ");
INSERT INTO engBBE_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","And anyone who takes as food anything which has come to a natural end, or anything which has been put to death by beasts, if he is one of you by birth, or of another nation, will have to have his clothing washed and his body bathed in water and be unclean till evening, and then he will be clean. ");
INSERT INTO engBBE_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","But if his clothing is not washed and his body bathed, his sin will be on him. ");
INSERT INTO engBBE_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Say to the children of Israel, I am the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","You may not do those things which were done in the land of Egypt where you were living; and you may not do those things which are done in the land of Canaan where I am taking you, or be guided in your behaviour by their rules. ");
INSERT INTO engBBE_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","But you are to be guided by my decisions and keep my rules, and be guided by them: I am the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","So keep my rules and my decisions, which, if a man does them, will be life to him: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","You may not have sex connection with anyone who is a near relation: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","You may not have sex relations with your father or your mother: she is your mother, you may not take her. ");
INSERT INTO engBBE_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","And you may not have sex relations with your father's wife: she is your father's. ");
INSERT INTO engBBE_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","You may not take your sister, the daughter of your father or of your mother, wherever her birth took place, among you or in another country. ");
INSERT INTO engBBE_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","You may not have sex relations with your son's daughter or your daughter's daughter, for they are part of yourself; ");
INSERT INTO engBBE_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Or your father's wife's daughter, the child of your father, for she is your sister. ");
INSERT INTO engBBE_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","You may not have sex connection with your father's sister, for she is your father's near relation. ");
INSERT INTO engBBE_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","You may not have sex connection with your mother's sister, for she is your mother's near relation. ");
INSERT INTO engBBE_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","You may not have sex relations with the wife of your father's brother, for she is of your family; ");
INSERT INTO engBBE_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Or with your daughter-in-law, for she is your son's wife, and you may not take her. ");
INSERT INTO engBBE_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","You may not have sex relations with your brother's wife, for she is your brother's. ");
INSERT INTO engBBE_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","You may not take as wife a woman and her daughter, or her son's daughter or her daughter's daughter, for they are of one family: it is an act of shame. ");
INSERT INTO engBBE_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","And you may not take as wife a woman and at the same time her sister, to be in competition with her in her life-time. ");
INSERT INTO engBBE_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","And you may not go near a woman or have sex relations with her when she is unclean, at her regular time. ");
INSERT INTO engBBE_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","And you may not have sex relations with your neighbour's wife, making yourself unclean with her. ");
INSERT INTO engBBE_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","And you may not make any of your children go through the fire as an offering to Molech, and you may not put shame on the name of your God: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","You may not have sex relations with men, as you do with women: it is a disgusting thing. ");
INSERT INTO engBBE_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","And you may not have sex relations with a beast, making yourself unclean with it; and a woman may not give herself to a beast: it is an unnatural act. ");
INSERT INTO engBBE_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Do not make yourself unclean in any of these ways; for so have those nations whom I am driving out from before you made themselves unclean: ");
INSERT INTO engBBE_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","And the land itself has become unclean; so that I have sent on it the reward of its wrongdoing, and the land itself puts out those who are living in it. ");
INSERT INTO engBBE_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","So then keep my rules and my decisions, and do not do any of these disgusting things, those of you who are Israelites by birth, or any others who are living with you: ");
INSERT INTO engBBE_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(For all these disgusting things were done by the men of this country who were there before you, and the land has been made unclean by them;) ");
INSERT INTO engBBE_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","So that the land may not put you out from it, when you make it unclean, as it put out the nations which were there before you. ");
INSERT INTO engBBE_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","For all those who do any of these disgusting things will be cut off from among their people. ");
INSERT INTO engBBE_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","So then, keep my orders, so that you may not do any of these disgusting things which were done before you, or make yourselves unclean through them: I am the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Say to all the people of Israel, You are to be holy, for I, the Lord your God, am holy. ");
INSERT INTO engBBE_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Let every man give honour to his mother and to his father and keep my Sabbaths: I am the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Do not go after false gods, and do not make metal images of gods for yourselves: I am the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","And when you give a peace offering to the Lord, do it in the way which is pleasing to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Let it be used for food on the same day on which it is offered, or on the day after; and whatever is over on the third day is to be burned with fire. ");
INSERT INTO engBBE_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","If any of it is used for food on the third day, it is a disgusting thing and will not be pleasing to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","And as for anyone who takes it for food, his sin will be on him, for he has put shame on the holy thing of the Lord: he will be cut off from his people. ");
INSERT INTO engBBE_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","And when you get in the grain from your land, do not let all the grain be cut from the edges of the field, or take up what has been dropped on the earth after the getting in of the grain. ");
INSERT INTO engBBE_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","And do not take all the grapes from your vine-garden, or the fruit dropped on the earth; let the poor man, and the man from another country, have these: I am the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Do not take anyone's property or be false in act or word to another. ");
INSERT INTO engBBE_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","And do not take an oath in my name falsely, putting shame on the name of your God: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Do not be cruel to your neighbour or take what is his; do not keep back a servant's payment from him all night till the morning. ");
INSERT INTO engBBE_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Do not put a curse on those who have no hearing, or put a cause of falling in the way of the blind, but keep the fear of your God before you: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Do no wrong in your judging: do not give thought to the position of the poor, or honour to the position of the great; but be a judge to your neighbour in righteousness. ");
INSERT INTO engBBE_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Do not go about saying untrue things among your people, or take away the life of your neighbour by false witness: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Let there be no hate in your heart for your brother; but you may make a protest to your neighbour, so that he may be stopped from doing evil. ");
INSERT INTO engBBE_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Do not make attempts to get equal with one who has done you wrong, or keep hard feelings against the children of your people, but have love for your neighbour as for yourself: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Keep my laws. Do not let your cattle have offspring by those of a different sort; do not put mixed seed into your field; do not put on a robe made of two sorts of cloth. ");
INSERT INTO engBBE_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","If any man has sex relations with a servant-woman who has given her word to be married to a man, and has not been made free for a price or in any other way, the thing will be looked into; but they will not be put to death because she was not a free woman. ");
INSERT INTO engBBE_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Let him take his offering for wrongdoing to the Lord, to the door of the Tent of meeting; let him give a male sheep as an offering for wrongdoing. ");
INSERT INTO engBBE_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","And the priest will take away his sin before the Lord with the sheep which is offered for his wrongdoing, and he will have forgiveness for the sin which he has done. ");
INSERT INTO engBBE_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","And when you have come into the land, and have put in all sorts of fruit-trees, their fruit will be as if they had not had circumcision, and for three years their fruit may not be used for food. ");
INSERT INTO engBBE_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","And in the fourth year all the fruit will be holy as a praise-offering to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","But in the fifth year you may take the fruit and the increase of it for your food: I am the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Nothing may be used for food with its blood in it; you may not make use of strange arts, or go in search of signs and wonders. ");
INSERT INTO engBBE_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","The ends of the hair round your face and on your chin may not be cut off. ");
INSERT INTO engBBE_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","You may not make cuts in your flesh in respect for the dead, or have marks printed on your bodies: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Do not make your daughter common by letting her become a loose woman, for fear that the land may become full of shame. ");
INSERT INTO engBBE_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Keep my Sabbaths and have respect for my holy place: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Do not go after those who make use of spirits, or wonder-workers; do not go in their ways or become unclean through them: I am the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Get up from your seats before the white-haired, and give honour to the old, and let the fear of your God be before you: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","And if a man from another country is living in your land with you, do not make life hard for him; ");
INSERT INTO engBBE_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Let him be to you as one of your countrymen and have love for him as for yourself; for you were living in a strange land, in the land of Egypt: I am the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Do not make false decisions in questions of yard-sticks and weights and measures. ");
INSERT INTO engBBE_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Have true scales, true weights and measures for all things: I am the Lord your God, who took you out of the land of Egypt; ");
INSERT INTO engBBE_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","You are to keep all my rules and my decisions and do them: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Again, say to the children of Israel, If any man of the children of Israel, or any other man living in Israel, gives his offspring to Molech, he is certainly to be put to death: he is to be stoned by the people of the land; ");
INSERT INTO engBBE_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","And my face will be turned against that man, and he will be cut off from his people; because he has given his offspring to Molech, making my holy place unclean, and making my holy name common. ");
INSERT INTO engBBE_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","And if the people of the land do not take note of that man when he gives his offspring to Molech, and do not put him to death, ");
INSERT INTO engBBE_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Then my face will be turned against him and his family, and he and all those who do evil with him will be cut off from among their people. ");
INSERT INTO engBBE_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","And whoever goes after those who make use of spirits and wonder-workers, doing evil with them, against him will my face be turned, and he will be cut off from among his people. ");
INSERT INTO engBBE_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","So make and keep yourselves holy, for I am the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","And keep my rules and do them: I am the Lord, who make you holy. ");
INSERT INTO engBBE_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Every man cursing his father or his mother is certainly to be put to death; because of his curse on his father or his mother, his blood will be on him. ");
INSERT INTO engBBE_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","And if a man has sex relations with another man's wife, even the wife of his neighbour, he and she are certainly to be put to death. ");
INSERT INTO engBBE_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","And the man who has sex relations with his father's wife has put shame on his father: the two of them are to be put to death; their blood will be on them. ");
INSERT INTO engBBE_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","And if a man has sex relations with his son's wife, the two of them are to be put to death: it is unnatural; their blood will be on them. ");
INSERT INTO engBBE_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","And if a man has sex relations with a man, the two of them have done a disgusting thing: let them be put to death; their blood will be on them. ");
INSERT INTO engBBE_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","And if a man takes as wife a woman and her mother, it is an act of shame; let them be burned with fire, all three of them, so that there may be no shame among you. ");
INSERT INTO engBBE_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","And if a man has sex relations with a beast, let him be put to death, and let the beast be put to destruction. ");
INSERT INTO engBBE_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","And if a woman goes near a beast and has sex relations with it, you will put an end to the woman and the beast: their blood will be on them. ");
INSERT INTO engBBE_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","And if a man takes his sister, daughter of his father or his mother, and has sex relations with her and she with him, it is an act of shame: they are to be cut off before the children of their people; he has had sex relations with his sister, and his sin will be on him. ");
INSERT INTO engBBE_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","And if a man has sex relations with a woman at the time when she is unwell, he has seen her fountain and she has let the fountain of her blood be uncovered, and the two of them are to be cut off from among their people. ");
INSERT INTO engBBE_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","And you may not have sex connection with your mother's sister or your father's sister, for they are his near relations: their sin will be on them. ");
INSERT INTO engBBE_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","And if a man has sex relations with the wife of his father's brother, he has put shame on his father's brother: their sin will be on them; till the day of their death they will have no children. ");
INSERT INTO engBBE_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","And if a man takes his brother's wife, it is an unclean act; he has put shame on his brother; they will have no children. ");
INSERT INTO engBBE_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","So then, keep my rules and my decisions and do them, so that the land which I am giving you as your resting-place may not violently send you out again. ");
INSERT INTO engBBE_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","And do not keep the rules of the nations which I am driving out before you; for they did all these things, and for that reason my soul was turned against them. ");
INSERT INTO engBBE_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","But I have said to you, You will take their land and I will give it to you for your heritage, a land flowing with milk and honey: I am the Lord your God who have made you separate from all other peoples. ");
INSERT INTO engBBE_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","So then, make division between the clean beast and the unclean, and between the clean bird and the unclean: do not make yourselves disgusting by any beast or bird or anything which goes flat on the earth, which has been marked by me as unclean for you. ");
INSERT INTO engBBE_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","And you are to be holy to me; for I the Lord am holy and have made you separate from the nations, so that you may be my people. ");
INSERT INTO engBBE_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Any man or woman who makes use of spirits, or who is a wonder-worker, is to be put to death: they are to be stoned with stones: their blood will be on them. ");
INSERT INTO engBBE_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","And the Lord said to Moses, Say to the priests, the sons of Aaron, Let no man make himself unclean for the dead among his people; ");
INSERT INTO engBBE_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","But only for his near relations, for his mother or his father, his son or his daughter, and his brother; ");
INSERT INTO engBBE_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","And for his sister, a virgin, for she is his near relation and has had no husband, he may make himself unclean. ");
INSERT INTO engBBE_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","But let him, being a chief among his people, not make himself unclean in such a way as to put shame on himself. ");
INSERT INTO engBBE_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","They are not to have their hair cut off for the dead, or the hair on their chins cut short, or make cuts in their flesh. ");
INSERT INTO engBBE_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Let them be holy to their God and not make the name of their God common; for the fire offerings of the Lord and the bread of their God are offered by them, and they are to be holy. ");
INSERT INTO engBBE_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","They may not take as wife a loose or common woman, or one who has been put away by her husband: for the priest is holy to his God. ");
INSERT INTO engBBE_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","And he is to be holy in your eyes, for by him the bread of your God is offered; he is to be holy in your eyes, for I the Lord, who make you holy, am holy. ");
INSERT INTO engBBE_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","And if the daughter of a priest makes herself common and by her loose behaviour puts shame on her father, let her be burned with fire. ");
INSERT INTO engBBE_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","And he who is the chief priest among his brothers, on whose head the holy oil has been put, who is marked out to put on the holy robes, may not let his hair go loose or have his clothing out of order as a sign of sorrow. ");
INSERT INTO engBBE_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","He may not go near any dead body or make himself unclean for his father or his mother; ");
INSERT INTO engBBE_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","He may not go out of the holy place or make the holy place of his God common; for the crown of the holy oil of his God is on him: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","And let him take as his wife one who has not had relations with a man. ");
INSERT INTO engBBE_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","A widow, or one whose husband has put her away, or a common woman of loose behaviour, may not be the wife of a priest; but let him take a virgin from among his people. ");
INSERT INTO engBBE_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","And he may not make his seed unclean among his people, for I the Lord have made him holy. ");
INSERT INTO engBBE_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Say to Aaron, If a man of your family, in any generation, is damaged in body, let him not come near to make the offering of the bread of his God. ");
INSERT INTO engBBE_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","For any man whose body is damaged may not come near: one who is blind, or has not the use of his legs, or one who has a broken nose or any unnatural growth, ");
INSERT INTO engBBE_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Or a man with broken feet or hands, ");
INSERT INTO engBBE_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","Or one whose back is bent, or one who is unnaturally small, or one who has a damaged eye, or whose skin is diseased, or whose sex parts are damaged; ");
INSERT INTO engBBE_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","No man of the offspring of Aaron whose body is damaged in any way may come near to give the fire offerings of the Lord: he is damaged, he may not come near to make the offerings. ");
INSERT INTO engBBE_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","He may take of the bread of God, the holy and the most holy; ");
INSERT INTO engBBE_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","But he may not go inside the veil or come near the altar, because he is damaged; and he may not make my holy places common; for I the Lord have made them holy. ");
INSERT INTO engBBE_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","These are the words which Moses said to Aaron and to his sons and to all the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Give orders to Aaron and to his sons to keep themselves separate from the holy things of the children of Israel which they give to me, and not to make my holy name common: I am the Lord, ");
INSERT INTO engBBE_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Say to them, If any man of all your seed through all your generations, being unclean, comes near the holy things which the children of Israel make holy to the Lord, he will be cut off from before me: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","No man of the seed of Aaron who is a leper, or who has a flow from his body, may take of the holy food till he is clean. And any man touching anything which is unclean because of the dead, or any man whose seed goes from him; ");
INSERT INTO engBBE_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Or anyone touching any unclean thing which goes flat on the earth, or someone by whom he may be made unclean in any way whatever; ");
INSERT INTO engBBE_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Any person touching any such unclean thing will be unclean till evening, and may not take of the holy food till his flesh has been bathed in water; ");
INSERT INTO engBBE_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","And when the sun has gone down he will be clean; and after that he may take part in the holy food, because it is his bread. ");
INSERT INTO engBBE_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","That which comes to a natural death, or is attacked by beasts, he may not take as food, for it will make him unclean: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","So then, let them keep what I have put into their care, for fear that sin may come on them because of it, so causing their death because they have made it common: I am the Lord, who make them holy. ");
INSERT INTO engBBE_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","No outside person may take of the holy food, or one living as a guest in the priest's house, or a servant working for payment. ");
INSERT INTO engBBE_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","But any person for whom the priest has given money, to make him his, may take of it with him; and those who come to birth in his house may take of his bread. ");
INSERT INTO engBBE_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","And if the daughter of a priest is married to an outside person she may not take of the holy things which are lifted up as offerings. ");
INSERT INTO engBBE_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","But if a priest's daughter is a widow, or parted from her husband, and has no child, and has come back to her father's house as when she was a girl, she may take of her father's bread; but no outside person may do so. ");
INSERT INTO engBBE_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","And if a man takes the holy food in error, he will have to give the holy thing back to the priest, with the addition of a fifth part. ");
INSERT INTO engBBE_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","And they may not make common the holy things which the children of Israel give to the Lord, ");
INSERT INTO engBBE_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","So causing sin to come on them when they take their holy things for food: I am the Lord who make them holy. ");
INSERT INTO engBBE_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Say to Aaron and to his sons and to all the children of Israel, If any man of the children of Israel, or of another nation living in Israel, makes an offering, given because of an oath or freely given to the Lord for a burned offering; ");
INSERT INTO engBBE_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","So that it may be pleasing to the Lord, let him give a male, without any mark, from among the oxen or the sheep or the goats. ");
INSERT INTO engBBE_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","But anything which has a mark you may not give; it will not make you pleasing to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","And whoever makes a peace-offering to the Lord, in payment of an oath or as a free offering, from the herd or the flock, if it is to be pleasing to the Lord, let it be free from any mark or damage. ");
INSERT INTO engBBE_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Anything blind or broken or damaged or having any disease or any mark on it may not be offered to the Lord; you may not make an offering of it by fire on the altar to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","An ox or a lamb which has more or less than its natural parts, may be given as a free offering; but it will not be taken in payment of an oath. ");
INSERT INTO engBBE_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","An animal which has its sex parts damaged or crushed or broken or cut, may not be offered to the Lord; such a thing may not be done anywhere in your land. ");
INSERT INTO engBBE_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","And from one who is not an Israelite you may not take any of these for an offering to the Lord; for they are unclean, there is a mark on them, and the Lord will not be pleased with them. ");
INSERT INTO engBBE_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","When an ox or a sheep or a goat is given birth, let it be with its mother for seven days; and after the eighth day it may be taken as an offering made by fire to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","A cow or a sheep may not be put to death with its young on the same day. ");
INSERT INTO engBBE_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","And when you make an offering of praise to the Lord, make it in a way which is pleasing to him. ");
INSERT INTO engBBE_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Let it be used for food on the same day; do not keep any part of it till the morning: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","So then, keep my orders and do them: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","And do not make my holy name common; so that it may be kept holy by the children of Israel: I am the Lord who make you holy, ");
INSERT INTO engBBE_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Who took you out of the land of Egypt that I might be your God: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Say to the children of Israel, These are the fixed feasts of the Lord, which you will keep for holy meetings: these are my feasts. ");
INSERT INTO engBBE_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","On six days work may be done; but the seventh day is a special day of rest, a time for worship; you may do no sort of work: it is a Sabbath to the Lord wherever you may be living. ");
INSERT INTO engBBE_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","These are the fixed feasts of the Lord, the holy days of worship which you will keep at their regular times. ");
INSERT INTO engBBE_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","In the first month, on the fourteenth day of the month at nightfall, is the Lord's Passover; ");
INSERT INTO engBBE_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","And on the fifteenth day of the same month is the feast of unleavened bread; for seven days let your food be unleavened bread. ");
INSERT INTO engBBE_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","On the first day you will have a holy meeting; you may do no sort of field-work. ");
INSERT INTO engBBE_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","And every day for seven days you will give a burned offering to the Lord; and on the seventh day there will be a holy meeting; you may do no field-work. ");
INSERT INTO engBBE_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Say to the children of Israel, When you have come to the land which I will give you, and have got in the grain from its fields, take some of the first-fruits of the grain to the priest; ");
INSERT INTO engBBE_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","And let the grain be waved before the Lord, so that you may be pleasing to him; on the day after the Sabbath let it be waved by the priest. ");
INSERT INTO engBBE_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","And on the day of the waving of the grain, you are to give a male lamb of the first year, without any mark, for a burned offering to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","And let the meal offering with it be two tenth parts of an ephah of the best meal mixed with oil, an offering made by fire to the Lord for a sweet smell; and the drink offering with it is to be of wine, the fourth part of a hin. ");
INSERT INTO engBBE_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","And you may take no bread or dry grain or new grain for food till the very day on which you have given the offering for your God: this is a rule for ever through all your generations wherever you are living. ");
INSERT INTO engBBE_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","And let seven full weeks be numbered from the day after the Sabbath, the day when you give the grain for the wave offering; ");
INSERT INTO engBBE_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Let fifty days be numbered, to the day after the seventh Sabbath; then you are to give a new meal offering to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Take from your houses two cakes of bread, made of a fifth part of an ephah of the best meal, cooked with leaven, to be waved for first-fruits to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","And with the bread, take seven lambs of the first year, without any marks, and one ox and two male sheep, to be a burned offering to the Lord, with their meal offering and their drink offerings, an offering of a sweet smell made by fire to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","And you are to give one male goat for a sin-offering and two male lambs of the first year for peace-offerings. ");
INSERT INTO engBBE_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","And these will be waved by the priest, with the bread of the first-fruits, for a wave offering to the Lord, with the two lambs: they will be holy to the Lord for the priest. ");
INSERT INTO engBBE_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","And on the same day, let it be given out that there will be a holy meeting for you: you may do no field-work on that day: it is a rule for ever through all your generations wherever you are living. ");
INSERT INTO engBBE_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","And when you get in the grain from your land, do not let all the grain at the edges of the field be cut, and do not take up the grain which has been dropped in the field; let that be for the poor, and for the man from another country: I am the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Say to the children of Israel, In the seventh month, on the first day of the month, let there be a special day of rest for you, a day of memory, marked by the blowing of horns, a meeting for worship. ");
INSERT INTO engBBE_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Do no field-work and give to the Lord an offering made by fire. ");
INSERT INTO engBBE_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","The tenth day of this seventh month is the day for the taking away of sin; let it be a holy day of worship; you are to keep from pleasure, and give to the Lord an offering made by fire. ");
INSERT INTO engBBE_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","And on that day you may do no sort of work, for it is a day of taking away sin, to make you clean before the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","For any person, whoever he may be, who takes his pleasure on that day will be cut off from his people. ");
INSERT INTO engBBE_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","And if any person, whoever he may be, on that day does any sort of work, I will send destruction on him from among his people. ");
INSERT INTO engBBE_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","You may not do any sort of work: this is an order for ever through all your generations wherever you may be living. ");
INSERT INTO engBBE_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Let this be a Sabbath of special rest to you, and keep yourselves from all pleasure; on the ninth day of the month at nightfall from evening to evening, let this Sabbath be kept. ");
INSERT INTO engBBE_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Say to the children of Israel, On the fifteenth day of this seventh month let the feast of tents be kept to the Lord for seven days. ");
INSERT INTO engBBE_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","On the first day there will be a holy meeting: do no field-work. ");
INSERT INTO engBBE_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Every day for seven days give an offering made by fire to the Lord; and on the eighth day there is to be a holy meeting, when you are to give an offering made by fire to the Lord; this is a special holy day: you may do no field-work on that day. ");
INSERT INTO engBBE_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","These are the fixed feasts of the Lord, to be kept by you as holy days of worship, for making an offering by fire to the Lord; a burned offering, a meal offering, an offering of beasts, and drink offerings; every one on its special day; ");
INSERT INTO engBBE_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","In addition to the Sabbaths of the Lord, and in addition to the things you give and the oaths you make and the free offerings to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","But on the fifteenth day of the seventh month, when you have got in all the fruits of the land, you will keep the feast of the Lord for seven days: the first day will be a Sabbath, and the eighth day the same. ");
INSERT INTO engBBE_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","On the first day, take the fruit of fair trees, branches of palm-trees, and branches of thick trees and trees from the riverside, and be glad before the Lord for seven days. ");
INSERT INTO engBBE_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","And let this feast be kept before the Lord for seven days in the year: it is a rule for ever from generation to generation; in the seventh month let it be kept. ");
INSERT INTO engBBE_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","For seven days you will be living in tents; all those who are Israelites by birth are to make tents their living-places: ");
INSERT INTO engBBE_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","So that future generations may keep in mind how I gave the children of Israel tents as their living-places when I took them out of the land of Egypt: I am the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","And Moses made clear to the children of Israel the orders about the fixed feasts of the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Give orders to the children of Israel to give you clean olive oil for the light, so that a light may be burning at all times, ");
INSERT INTO engBBE_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Outside the veil of the ark in the Tent of meeting; let Aaron see that it is burning from evening till morning at all times before the Lord: it is a rule for ever through all your generations. ");
INSERT INTO engBBE_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Let Aaron put the lights in order on the support before the Lord at all times. ");
INSERT INTO engBBE_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","And take the best meal and make twelve cakes of it, a fifth part of an ephah in every cake. ");
INSERT INTO engBBE_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","And put them in two lines, six in a line, on the holy table before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","And on the lines of cakes put clean sweet-smelling spices, for a sign on the bread, an offering made by fire to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Every Sabbath day regularly, the priest is to put it in order before the Lord: it is offered for the children of Israel, an agreement made for ever. ");
INSERT INTO engBBE_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","And it will be for Aaron and his sons; they are to take it for food in a holy place: it is the most holy of all the offerings made by fire to the Lord, a rule for ever. ");
INSERT INTO engBBE_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","And a son of an Israelite woman, whose father was an Egyptian, went out among the children of Israel and had a fight with a man of Israel by the tents; ");
INSERT INTO engBBE_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","And the son of the Israelite woman said evil against the holy Name, with curses; and they took him to Moses. His mother's name was Shelomith, the daughter of Dibri, of the tribe of Dan. ");
INSERT INTO engBBE_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","And they kept him shut up, till a decision might be given by the mouth of the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Take the curser outside the tent-circle; and let all in whose hearing the words were said put their hands on his head, and let him be stoned by all the people. ");
INSERT INTO engBBE_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","And say to the children of Israel, As for any man cursing God, his sin will be on his head. ");
INSERT INTO engBBE_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","And he who says evil against the name of the Lord will certainly be put to death; he will be stoned by all the people; the man who is not of your nation and one who is an Israelite by birth, whoever says evil against the holy Name is to be put to death. ");
INSERT INTO engBBE_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","And anyone who takes another's life is certainly to be put to death. ");
INSERT INTO engBBE_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","And anyone wounding a beast and causing its death, will have to make payment for it: a life for a life. ");
INSERT INTO engBBE_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","And if a man does damage to his neighbour, as he has done, so let it be done to him; ");
INSERT INTO engBBE_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Wound for wound, eye for eye, tooth for tooth; whatever damage he has done, so let it be done to him. ");
INSERT INTO engBBE_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","He who puts a beast to death will have to make payment for it; he who puts a man to death will himself be put to death. ");
INSERT INTO engBBE_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","You are to have the same law for a man of another nation living among you as for an Israelite; for I am the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","And Moses said these words to the children of Israel, and they took the man who had been cursing outside the tent-circle and had him stoned. The children of Israel did as the Lord gave orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","And the Lord said to Moses on Mount Sinai, ");
INSERT INTO engBBE_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Say to the children of Israel, When you come into the land which I will give you, let the land keep a Sabbath to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","For six years put seed into your land, and for six years give care to your vines and get in the produce of them; ");
INSERT INTO engBBE_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","But let the seventh year be a Sabbath of rest for the land, a Sabbath to the Lord; do not put seed into your land or have your vines cut. ");
INSERT INTO engBBE_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","That which comes to growth of itself may not be cut, and the grapes of your uncared-for vines may not be taken off; let it be a year of rest for the land. ");
INSERT INTO engBBE_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","And the Sabbath of the land will give food for you and your man-servant and your woman-servant and those working for payment, and for those of another country who are living among you; ");
INSERT INTO engBBE_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","And for your cattle and the beasts on the land; all the natural increase of the land will be for food. ");
INSERT INTO engBBE_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","And let seven Sabbaths of years be numbered to you, seven times seven years; even the days of seven Sabbaths of years, that is forty-nine years; ");
INSERT INTO engBBE_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Then let the loud horn be sounded far and wide on the tenth day of the seventh month; on the day of taking away sin let the horn be sounded through all your land. ");
INSERT INTO engBBE_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","And let this fiftieth year be kept holy, and say publicly that everyone in the land is free from debt: it is the Jubilee, and every man may go back to his heritage and to his family. ");
INSERT INTO engBBE_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Let this fiftieth year be the Jubilee: no seed may be planted, and that which comes to growth of itself may not be cut, and the grapes may not be taken from the uncared-for vines. ");
INSERT INTO engBBE_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","For it is the Jubilee, and it is holy to you; your food will be the natural increase of the field. ");
INSERT INTO engBBE_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","In this year of Jubilee, let every man go back to his heritage. ");
INSERT INTO engBBE_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","And in the business of trading goods for money, do no wrong to one another. ");
INSERT INTO engBBE_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Let your exchange of goods with your neighbours have relation to the number of years after the year of Jubilee, and the number of times the earth has given her produce. ");
INSERT INTO engBBE_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","If the number of years is great, the price will be increased, and if the number of years is small, the price will be less, for it is the produce of a certain number of years which the man is giving you. ");
INSERT INTO engBBE_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","And do no wrong, one to another, but let the fear of your God be before you; for I am the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","So keep my rules and my decisions and do them, and you will be safe in your land. ");
INSERT INTO engBBE_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","And the land will give her fruit, and you will have food in full measure and be safe in the land. ");
INSERT INTO engBBE_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","And if you say, Where will our food come from in the seventh year, when we may not put in seed, or get in the increase ");
INSERT INTO engBBE_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Then I will send my blessing on you in the sixth year, and the land will give fruit enough for three years. ");
INSERT INTO engBBE_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","And in the eighth year you will put in your seed, and get your food from the old stores, till the fruit of the ninth year is ready. ");
INSERT INTO engBBE_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","No exchange of land may be for ever, for the land is mine, and you are as my guests, living with me for a time. ");
INSERT INTO engBBE_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Wherever there is property in land, the owner is to have the right of getting it back. ");
INSERT INTO engBBE_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","If your brother becomes poor, and has to give up some of his land for money, his nearest relation may come and get back that which his brother has given up. ");
INSERT INTO engBBE_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","And if he has no one to get it back for him, and later he himself gets wealth and has enough money to get it back; ");
INSERT INTO engBBE_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Then let him take into account the years from the time when he gave it up, and make up the loss for the rest of the years to him who took it, and so get back his property. ");
INSERT INTO engBBE_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","But if he is not able to get it back for himself, then it will be kept by him who gave a price for it, till the year of Jubilee; and in that year it will go back to its first owner and he will have his property again. ");
INSERT INTO engBBE_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","And if a man gives his house in a walled town for money, he has the right to get it back for the space of a full year after he has given it up. ");
INSERT INTO engBBE_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","And if he does not get it back by the end of the year, then the house in the town will become the property of him who gave the money for it, and of his children for ever; it will not go from him in the year of Jubilee. ");
INSERT INTO engBBE_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","But houses in small unwalled towns will be the same as property in the country; they may be got back, and they will go back to their owners in the year of Jubilee. ");
INSERT INTO engBBE_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","But the houses in the towns of the Levites may be got back by the Levites at any time. ");
INSERT INTO engBBE_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","And if a Levite does not give money to get back his property, his house in the town which was exchanged for money will come back to him in the year of Jubilee. For the houses of the towns of the Levites are their property among the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","But the land on the outskirts of their towns may not be exchanged for money, for it is their property for ever. ");
INSERT INTO engBBE_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","And if your brother becomes poor and is not able to make a living, then you are to keep him with you, helping him as you would a man from another country who is living among you. ");
INSERT INTO engBBE_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Take no interest from him, in money or in goods, but have the fear of your God before you, and let your brother make a living among you. ");
INSERT INTO engBBE_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Do not take interest on the money which you let him have or on the food which you give him. ");
INSERT INTO engBBE_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","I am the Lord your God, who took you out of the land of Egypt to give you the land of Canaan, that I might be your God. ");
INSERT INTO engBBE_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","And if your brother becomes poor and gives himself to you for money, do not make use of him like a servant who is your property; ");
INSERT INTO engBBE_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","But let him be with you as a servant working for payment, till the year of Jubilee; ");
INSERT INTO engBBE_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Then he will go out from you, he and his children with him, and go back to his family and to the property of his fathers. ");
INSERT INTO engBBE_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","For they are my servants whom I took out from the land of Egypt; they may not become the property of another. ");
INSERT INTO engBBE_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Do not be a hard master to him, but have the fear of God before you. ");
INSERT INTO engBBE_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","But you may get servants as property from among the nations round about; from them you may take men-servants and women-servants. ");
INSERT INTO engBBE_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","And in addition, you may get, for money, servants from among the children of other nations who are living with you, and from their families which have come to birth in your land; and these will be your property. ");
INSERT INTO engBBE_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","And they will be your children's heritage after you, to keep as their property; they will be your servants for ever; but you may not be hard masters to your countrymen, the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","And if one from another nation living among you gets wealth, and your countryman, at his side, becomes poor and gives himself for money to the man from another nation or to one of his family; ");
INSERT INTO engBBE_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","After he has given himself he has the right to be made free, for a price, by one of his brothers, ");
INSERT INTO engBBE_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Or his father's brother, or the son of his father's brother, or any near relation; or if he gets money, he may make himself free. ");
INSERT INTO engBBE_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","And let the years be numbered from the time when he gave himself to his owner till the year of Jubilee, and the price given for him will be in relation to the number of years, on the scale of the payment of a servant. ");
INSERT INTO engBBE_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","If there is still a long time, he will give back, on account of it, a part of the price which was given for him. ");
INSERT INTO engBBE_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","And if there is only a short time, he will take account of it with his master, and in relation to the number of years he will give back the price of making him free. ");
INSERT INTO engBBE_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","And he will be with him as a servant working for payment year by year; his master is not to be cruel to him before your eyes. ");
INSERT INTO engBBE_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","And if he is not made free in this way, he will go out in the year of Jubilee, he and his children with him. ");
INSERT INTO engBBE_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","For the children of Israel are servants to me; they are my servants whom I took out of the land of Egypt: I am the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Do not make images of false gods, or put up an image cut in stone or a pillar or any pictured stone in your land, to give worship to it; for I am the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Keep my Sabbaths and give honour to my holy place: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","If you are guided by my rules, and keep my laws and do them, ");
INSERT INTO engBBE_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Then I will give you rain at the right time, and the land will give her increase and the trees of the field will give their fruit; ");
INSERT INTO engBBE_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","And the crushing of the grain will overtake the cutting of the grapes, and the cutting of the grapes will overtake the planting of the seed, and there will be bread in full measure, and you will be living in your land safely. ");
INSERT INTO engBBE_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","And I will give you peace in the land, and you will take your rest and no one will give you cause for fear; and I will put an end to all evil beasts in the land, and no sword of war will go through your land. ");
INSERT INTO engBBE_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","And you will put to flight those who are against you, and they will be put to death by your swords. ");
INSERT INTO engBBE_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Then five of you will put to flight a hundred, and a hundred of you will put to flight ten thousand, and all who are against you will be put to death by your swords. ");
INSERT INTO engBBE_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","And I will have pleasure in you and make you fertile and greater in number; and I will keep my agreement with you. ");
INSERT INTO engBBE_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","And old stores long kept will be your food, and you will take out the old because of the new; ");
INSERT INTO engBBE_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","And I will put my holy House among you, and my soul will not be turned away from you in disgust. ");
INSERT INTO engBBE_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","And I will be present among you and will be your God and you will be my people. ");
INSERT INTO engBBE_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","I am the Lord your God, who took you out of the land of Egypt so that you might not be servants to them; by me the cords of your yoke were broken and I made you go upright. ");
INSERT INTO engBBE_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","But if you do not give ear to me, and do not keep all these my laws; ");
INSERT INTO engBBE_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","And if you go against my rules and if you have hate in your souls for my decisions and you do not do all my orders, but go against my agreement; ");
INSERT INTO engBBE_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","This will I do to you: I will put fear in your hearts, even wasting disease and burning pain, drying up the eyes and making the soul feeble, and you will get no profit from your seed, for your haters will take it for food. ");
INSERT INTO engBBE_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","And my face will be turned from you, and you will be broken before those who are against you, and your haters will become your rulers, and you will go in flight when no man comes after you. ");
INSERT INTO engBBE_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","And if, even after these things, you will not give ear to me, then I will send you punishment seven times more for your sins. ");
INSERT INTO engBBE_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","And the pride of your strength will be broken, and I will make your heaven as iron and your earth as brass; ");
INSERT INTO engBBE_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","And your strength will be used up without profit; for your land will not give her increase and the trees of the field will not give their fruit. ");
INSERT INTO engBBE_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","And if you still go against me and will not give ear to me, I will put seven times more punishments on you because of your sins. ");
INSERT INTO engBBE_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","I will let loose the beasts of the field among you, and they will take away your children and send destruction on your cattle, so that your numbers will become small and your roads become waste. ");
INSERT INTO engBBE_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","And if by these things you will not be turned to me, but still go against me; ");
INSERT INTO engBBE_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Then I will go against you, and I will give you punishment, I myself, seven times for all your sins. ");
INSERT INTO engBBE_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","And I will send a sword on you to give effect to the punishment of my agreement; and when you come together into your towns I will send disease among you and you will be given up into the hands of your haters. ");
INSERT INTO engBBE_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","When I take away your bread of life, ten women will be cooking bread in one oven, and your bread will be measured out by weight; you will have food but never enough. ");
INSERT INTO engBBE_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","And if, after all this, you do not give ear to me, but go against me still, ");
INSERT INTO engBBE_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Then my wrath will be burning against you, and I will give you punishment, I myself, seven times for your sins. ");
INSERT INTO engBBE_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Then you will take the flesh of your sons and the flesh of your daughters for food; ");
INSERT INTO engBBE_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","And I will send destruction on your high places, overturning your perfume altars, and will put your dead bodies on your broken images, and my soul will be turned from you in disgust. ");
INSERT INTO engBBE_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","And I will make your towns waste and send destruction on your holy places; I will take no pleasure in the smell of your sweet perfumes; ");
INSERT INTO engBBE_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","And I will make your land a waste, a wonder to your haters living in it. ");
INSERT INTO engBBE_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","And I will send you out in all directions among the nations, and my sword will be uncovered against you, and your land will be without any living thing, and your towns will be made waste. ");
INSERT INTO engBBE_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Then will the land take pleasure in its Sabbaths while it is waste and you are living in the land of your haters; then will the land have rest. ");
INSERT INTO engBBE_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","All the days while it is waste will the land have rest, such rest as it never had in your Sabbaths, when you were living in it. ");
INSERT INTO engBBE_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","And as for the rest of you, I will make their hearts feeble in the land of their haters, and the sound of a leaf moved by the wind will send them in flight, and they will go in flight as from the sword, falling down when no one comes after them; ");
INSERT INTO engBBE_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Falling on one another, as before the sword, when no one comes after them; you will give way before your haters. ");
INSERT INTO engBBE_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","And death will overtake you among strange nations, and the land of your haters will be your destruction. ");
INSERT INTO engBBE_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","And those of you who are still living will be wasting away in their sins in the land of your haters; in the sins of their fathers they will be wasting away. ");
INSERT INTO engBBE_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","And they will have grief for their sins and for the sins of their fathers, when their hearts were untrue to me, and they went against me; ");
INSERT INTO engBBE_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","So that I went against them and sent them away into the land of their haters: if then the pride of their hearts is broken and they take the punishment of their sins, ");
INSERT INTO engBBE_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Then I will keep in mind the agreement which I made with Jacob and with Isaac and with Abraham, and I will keep in mind the land. ");
INSERT INTO engBBE_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","And the land, while she is without them, will keep her Sabbaths; and they will undergo the punishment of their sins, because they were turned away from my decisions and in their souls was hate for my laws. ");
INSERT INTO engBBE_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","But for all that, when they are in the land of their haters I will not let them go, or be turned away from them, or give them up completely; my agreement with them will not be broken, for I am the Lord their God. ");
INSERT INTO engBBE_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","And because of them I will keep in mind the agreement which I made with their fathers, whom I took out of the land of Egypt before the eyes of the nations, to be their God: I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","These are the rules, decisions, and laws, which the Lord made between himself and the children of Israel in Mount Sinai, by the hand of Moses. ");
INSERT INTO engBBE_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Say to the children of Israel, If a man makes a special oath, you will give your decision as to the value of the persons for the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","And you will put the value of a male from twenty years to sixty years old at fifty shekels of silver, by the scale of the holy place. ");
INSERT INTO engBBE_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","And if it is a female, the value will be thirty shekels. ");
INSERT INTO engBBE_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","And if the person is from five to twenty years old, the value will be twenty shekels for a male, and ten for a female. ");
INSERT INTO engBBE_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","And if the person is from one month to five years old, then the value for a male will be five shekels of silver, and for a female three shekels. ");
INSERT INTO engBBE_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","And for sixty years old and over, for a male the value will be fifteen shekels, and for a female, ten. ");
INSERT INTO engBBE_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","But if he is poorer than the value which you have put on him, then let him be taken to the priest, and the priest will put a value on him, such as it is possible for him to give. ");
INSERT INTO engBBE_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","And if it is a beast of which men make offerings to the Lord, whatever any man gives of such to the Lord will be holy. ");
INSERT INTO engBBE_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","It may not be changed in any way, a good given for a bad, or a bad for a good; if one beast is changed for another, the two will be holy. ");
INSERT INTO engBBE_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","And if it is any unclean beast, of which offerings are not made to the Lord, then let him take the beast before the priest; ");
INSERT INTO engBBE_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","And let the priest put a value on it, if it is good or bad; whatever value the priest puts on it, so will it be. ");
INSERT INTO engBBE_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","But if he has a desire to get it back for himself, let him give a fifth more than your value. ");
INSERT INTO engBBE_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","And if a man has given his house as holy to the Lord, then the priest will put a value on it, if it is good or bad; as the priest gives decision so will the value be fixed. ");
INSERT INTO engBBE_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","And if the owner has a desire to get back his house, let him give a fifth more than your value, and it will be his. ");
INSERT INTO engBBE_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","And if a man gives to the Lord part of the field which is his property, then let your value be in relation to the seed which is planted in it; a measure of barley grain will be valued at fifty shekels of silver. ");
INSERT INTO engBBE_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","If he gives his field from the year of Jubilee, the value will be fixed by your decision. ");
INSERT INTO engBBE_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","But if he gives his field after the year of Jubilee, the amount of the money will be worked out by the priest in relation to the number of years till the coming year of Jubilee, and the necessary amount will be taken off your value. ");
INSERT INTO engBBE_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","And if the man who has given the field has a desire to get it back, let him give a fifth more than the price at which it was valued and it will be his. ");
INSERT INTO engBBE_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","But if he has no desire to get it back, or if he has given it for a price to another man, it may not be got back again. ");
INSERT INTO engBBE_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","But the field, when it becomes free at the year of Jubilee, will be holy to the Lord, as a field given under oath: it will be the property of the priest. ");
INSERT INTO engBBE_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","And if a man gives to the Lord a field which he has got for money from another, which is not part of his heritage; ");
INSERT INTO engBBE_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Then the value fixed by you up to the year of Jubilee will be worked out for him by the priest, and in that day he will give the amount of your value as holy to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","In the year of Jubilee the field will go back to him from whom he got it, that is, to him whose heritage it was. ");
INSERT INTO engBBE_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","And let all your values be based on the shekel of the holy place, that is, twenty gerahs to the shekel. ");
INSERT INTO engBBE_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","But a man may not give by oath to the Lord the first-fruits of cattle which are offered to the Lord: if it is an ox or a sheep it is the Lord's. ");
INSERT INTO engBBE_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","And if it is an unclean beast, then the owner of it may give money to get it back, in agreement with the value fixed by you, by giving a fifth more; or if it is not taken back, let it be given for money in agreement with your valuing. ");
INSERT INTO engBBE_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","But nothing which a man has given completely to the Lord, out of all his property, of man or beast, or of the land which is his heritage, may be given away or got back in exchange for money; anything completely given is most holy to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Any man given completely to the Lord may not be got back: he is certainly to be put to death. ");
INSERT INTO engBBE_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","And every tenth part of the land, of the seed planted, or of the fruit of trees, is holy to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","And if a man has a desire to get back any of the tenth part which he has given, let him give a fifth more. ");
INSERT INTO engBBE_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","And a tenth part of the herd and of the flock, whatever goes under the rod of the valuer, will be holy to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","He may not make search to see if it is good or bad, or make any changes in it; and if he makes exchange of it for another, the two will be holy; he will not get them back again. ");
INSERT INTO engBBE_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","These are the orders which the Lord gave to Moses for the children of Israel in Mount Sinai. ");
INSERT INTO engBBE_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","And the Lord said to Moses in the waste land of Sinai, in the Tent of meeting, on the first day of the second month, in the second year after they came out of the land of Egypt, ");
INSERT INTO engBBE_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Take the full number of the children of Israel, by their families, and by their fathers' houses, every male by name; ");
INSERT INTO engBBE_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","All those of twenty years old and over, who are able to go to war in Israel, are to be numbered by you and Aaron. ");
INSERT INTO engBBE_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","And to give you help, take one man from every tribe, the head of his father's house. ");
INSERT INTO engBBE_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","These are the names of those who are to be your helpers: from Reuben, Elizur, the son of Shedeur; ");
INSERT INTO engBBE_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","From Simeon, Shelumiel, the son of Zurishaddai; ");
INSERT INTO engBBE_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","From Judah, Nahshon, the son of Amminadab; ");
INSERT INTO engBBE_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","From Issachar, Nethanel, the son of Zuar; ");
INSERT INTO engBBE_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","From Zebulun, Eliab, the son of Helon; ");
INSERT INTO engBBE_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Of the children of Joseph: from Ephraim, Elishama, the son of Ammihud; from Manasseh, Gamaliel, the son of Pedahzur, ");
INSERT INTO engBBE_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","From Benjamin, Abidan, the son of Gideoni; ");
INSERT INTO engBBE_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","From Dan, Ahiezer, the son of Ammi-shaddai; ");
INSERT INTO engBBE_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","From Asher, Pagiel, the son of Ochran; ");
INSERT INTO engBBE_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","From Gad, Eliasaph, the son of Reuel; ");
INSERT INTO engBBE_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","From Naphtali, Ahira, the son of Enan. ");
INSERT INTO engBBE_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","These are the men named out of all the people, chiefs of their fathers' houses, heads of the tribes of Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","And Moses and Aaron took these men, marked out by name; ");
INSERT INTO engBBE_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","And they got together all the people on the first day of the second month; and everyone made clear his family and his father's house, by the number of the names, from twenty years old and over. ");
INSERT INTO engBBE_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","As the Lord had given orders to Moses, so they were numbered by him in the waste place of Sinai. ");
INSERT INTO engBBE_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","The generations of the sons of Reuben, the oldest son of Israel, were numbered by their families and their fathers' houses, every male of twenty years old and over, who was able to go to war; ");
INSERT INTO engBBE_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Forty-six thousand, five hundred of the tribe of Reuben were numbered. ");
INSERT INTO engBBE_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","The generations of the sons of Simeon were numbered by their families and their fathers' houses, every male of twenty years old and over, who was able to go to war; ");
INSERT INTO engBBE_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Fifty-nine thousand, three hundred of the tribe of Simeon were numbered. ");
INSERT INTO engBBE_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","The generations of the sons of Gad were numbered by their families and their fathers' houses, every male of twenty years old and over who was able to go to war; ");
INSERT INTO engBBE_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Forty-five thousand, six hundred and fifty of the tribe of Gad were numbered. ");
INSERT INTO engBBE_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","The generations of the sons of Judah were numbered by their families and their fathers' houses, every male of twenty years old and over who was able to go to war; ");
INSERT INTO engBBE_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Seventy-four thousand, six hundred of the tribe of Judah were numbered. ");
INSERT INTO engBBE_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","The generations of the sons of Issachar were numbered by their families and their fathers' houses, every male of twenty years old and over who was able to go to war; ");
INSERT INTO engBBE_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Fifty-four thousand, four hundred of the tribe of Issachar were numbered. ");
INSERT INTO engBBE_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","The generations of the sons of Zebulun were numbered by their families and their fathers' houses, every male of twenty years old and over who was able to go to war; ");
INSERT INTO engBBE_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Fifty-seven thousand, four hundred of the tribe of Zebulun were numbered. ");
INSERT INTO engBBE_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","The generations of the sons of Joseph were numbered by their families and their fathers' houses, every male of twenty years old and over who was able to go to war; ");
INSERT INTO engBBE_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Forty thousand, five hundred of the tribe of Ephraim were numbered. ");
INSERT INTO engBBE_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","The generations of the sons of Manasseh were numbered by their families and their fathers' houses, every male of twenty years old and over who was able to go to war; ");
INSERT INTO engBBE_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Thirty-two thousand, two hundred of the tribe of Manasseh were numbered. ");
INSERT INTO engBBE_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","The generations of the sons of Benjamin were numbered by their families and their fathers' houses, every male of twenty years old and over who was able to go to war; ");
INSERT INTO engBBE_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Thirty-five thousand, four hundred of the tribe of Benjamin were numbered. ");
INSERT INTO engBBE_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","The generations of the sons of Dan were numbered by their families and their fathers' houses, every male of twenty years and over who was able to go to war; ");
INSERT INTO engBBE_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Sixty-two thousand, seven hundred of the tribe of Dan were numbered. ");
INSERT INTO engBBE_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","The generations of the sons of Asher were numbered by their families and their fathers' houses, every male of twenty years old and over who was able to go to war; ");
INSERT INTO engBBE_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Forty-one thousand, five hundred of the tribe of Asher were numbered. ");
INSERT INTO engBBE_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","The generations of the sons of Naphtali were numbered by their families and their fathers' houses, every male of twenty years old and over who was able to go to war; ");
INSERT INTO engBBE_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Fifty-three thousand, four hundred of the tribe of Naphtali were numbered. ");
INSERT INTO engBBE_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","These are they who were numbered by Moses and Aaron and by the twelve chiefs of Israel, one from every tribe. ");
INSERT INTO engBBE_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","So all those who were numbered of the children of Israel, by their families, all those of twenty years old and over who were able to go to war, ");
INSERT INTO engBBE_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Were six hundred and three thousand, five hundred and fifty. ");
INSERT INTO engBBE_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","But the Levites, of the tribe of their fathers, were not numbered among them. ");
INSERT INTO engBBE_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","For the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Only the tribe of Levi is not to be numbered among the children of Israel, ");
INSERT INTO engBBE_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","But to them you are to give the care of the Tent of meeting with its vessels and everything in it: they are to take up the Tent, and be responsible for everything to do with it, and put up their tents round it. ");
INSERT INTO engBBE_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","And when the Tent of meeting goes forward, the Levites are to take it down; and when it is to be put up, they are to do it: any strange person who comes near it is to be put to death. ");
INSERT INTO engBBE_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","The children of Israel are to put up their tents, every man in his tent-circle round his flag. ");
INSERT INTO engBBE_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","But the tents of the Levites are to be round the Tent of meeting, so that wrath may not come on the children of Israel: the Tent of meeting is to be in the care of the Levites. ");
INSERT INTO engBBE_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","So the children of Israel did as the Lord had given orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","And the Lord said to Moses and Aaron, ");
INSERT INTO engBBE_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","The children of Israel are to put up their tents in the order of their families, by the flags of their fathers' houses, facing the Tent of meeting on every side. ");
INSERT INTO engBBE_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Those whose tents are on the east side, looking to the dawn, will be round the flag of the children of Judah, with Nahshon, the son of Amminadab, as their chief. ");
INSERT INTO engBBE_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","The number of his army was seventy-four thousand, six hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","And nearest to him will be the tribe of Issachar, with Nethanel, the son of Zuar, as their chief. ");
INSERT INTO engBBE_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","The number of his army was fifty-four thousand, four hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","After him, the tribe of Zebulun, with Eliab, the son of Helon, as their chief. ");
INSERT INTO engBBE_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","The number of his army was fifty-seven thousand, four hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","The number of all the armies of Judah was a hundred and eighty-six thousand, four hundred. They go forward first. ");
INSERT INTO engBBE_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","On the south side is the flag of the children of Reuben, in the order of their armies, with Elizur, the son of Shedeur, as their chief. ");
INSERT INTO engBBE_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","The number of his army was forty-six thousand, five hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","And nearest to him, the tribe of Simeon, with Shelumiel, the son of Zurishaddai, as their chief. ");
INSERT INTO engBBE_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","The number of his army was fifty-nine thousand, three hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Then the tribe of Gad, with Eliasaph, son of Reuel, as their chief. ");
INSERT INTO engBBE_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","The number of his army was forty-five thousand, six hundred and fifty. ");
INSERT INTO engBBE_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","The number of all the armies of Reuben together came to a hundred and fifty-one thousand, four hundred and fifty. They go forward second. ");
INSERT INTO engBBE_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Then the Tent of meeting is to go forward, with the tents of the Levites, in the middle of the armies; in the same order as their tents are placed, they are to go forward, every man under his flag. ");
INSERT INTO engBBE_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","On the west side will be the flag of the children of Ephraim, with Elishama, the son of Ammihud, as their chief. ");
INSERT INTO engBBE_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","The number of his army was forty thousand, five hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","And by him the tribe of Manasseh with Gamaliel, the son of Pedahzur, as their chief. ");
INSERT INTO engBBE_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","The number of his army was thirty-two thousand, two hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Then the tribe of Benjamin, with Abidan, the son of Gideoni, as their chief. ");
INSERT INTO engBBE_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","The number of his army was thirty-five thousand, four hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","The number of all the armies of Ephraim was a hundred and eight thousand, one hundred. They go forward third. ");
INSERT INTO engBBE_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","On the north side will be the flag of the children of Dan, with Ahiezer, the son of Ammishaddai, as their chief. ");
INSERT INTO engBBE_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","The number of his army was sixty-two thousand, seven hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Nearest to him will be the tribe of Asher, with Pagiel, the son of Ochran, as their chief. ");
INSERT INTO engBBE_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","The number of his army was forty-one thousand, five hundred; ");
INSERT INTO engBBE_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Then the tribe of Naphtali, with Ahira, the son of Enan, as their chief. ");
INSERT INTO engBBE_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","The number of his army was fifty-three thousand, four hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","The number of all the armies in the tents of Dan was a hundred and fifty-seven thousand, six hundred. They will go forward last, by their flags. ");
INSERT INTO engBBE_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","These are all who were numbered of the children of Israel, in the order of their fathers' families: all the armies in their tents together came to six hundred and three thousand, five hundred and fifty. ");
INSERT INTO engBBE_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","But the Levites were not numbered among the children of Israel, as the Lord said to Moses. ");
INSERT INTO engBBE_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","So the children of Israel did as the Lord said to Moses, so they put up their tents by their flags, and they went forward in the same order, by their families, and by their fathers' houses. ");
INSERT INTO engBBE_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Now these are the generations of Aaron and Moses, in the day when the word of the Lord came to Moses on Mount Sinai. ");
INSERT INTO engBBE_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","These are the names of the sons of Aaron: Nadab the oldest, and Abihu, Eleazar, and Ithamar. ");
INSERT INTO engBBE_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","These are the names of the sons of Aaron, the priests, on whom the holy oil was put, who were marked out as priests. ");
INSERT INTO engBBE_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","And Nadab and Abihu were put to death before the Lord when they made an offering of strange fire before the Lord, in the waste land of Sinai, and they had no children: and Eleazar and Ithamar did the work of priests before Aaron their father. ");
INSERT INTO engBBE_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Make the tribe of Levi come near, and put them before Aaron the priest, to be his helpers, ");
INSERT INTO engBBE_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","In order that they may be responsible to him and to all Israel for the care of the Tent of meeting, and to do the work of the House; ");
INSERT INTO engBBE_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","And they will have the care of all the vessels of the Tent of meeting, and will do for the children of Israel all the necessary work of the House. ");
INSERT INTO engBBE_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Give the Levites to Aaron and his sons; so that they may be his without question from among the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","And give orders that Aaron and his sons are to keep their place as priests; any strange person who comes near is to be put to death. ");
INSERT INTO engBBE_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","See, I have taken the Levites out of the children of Israel to be mine in place of the first sons of the children of Israel; ");
INSERT INTO engBBE_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","For all the first sons are mine; on the day when I put to death all the first sons in the land of Egypt, I took for myself every first male birth of man and beast. They are mine; I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","And the Lord said to Moses in the waste land of Sinai, ");
INSERT INTO engBBE_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Let all the children of Levi be numbered by their families and their fathers' houses; let every male of a month old and over be numbered. ");
INSERT INTO engBBE_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","So Moses did as the Lord said, numbering them as he had been ordered. ");
INSERT INTO engBBE_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","These were the sons of Levi by name: Gershon and Kohath and Merari. ");
INSERT INTO engBBE_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","And these are the names of the sons of Gershon, by their families: Libni and Shimei. ");
INSERT INTO engBBE_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","And the sons of Kohath, by their families: Amram and Izhar and Hebron and Uzziel. ");
INSERT INTO engBBE_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","And the sons of Merari by their families: Mahli and Mushi. These are the families of the Levites in the order of their fathers' houses. ");
INSERT INTO engBBE_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","From Gershon come the Libnites and the Shimeites; these are the families of the Gershonites. ");
INSERT INTO engBBE_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Those who were numbered of them, the males from one month old and over, were seven thousand, five hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","The tents of the Gershonites are to be placed at the back of the House, to the west. ");
INSERT INTO engBBE_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","The chief of the Gershonites is Eliasaph, the son of Lael. ");
INSERT INTO engBBE_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","In the Tent of meeting, the Gershonites are to have the care of the House, and the Tent with its cover, and the veil for the door of the Tent of meeting, ");
INSERT INTO engBBE_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","And the hangings for the open space round the House and the altar, and the curtain for its doorway, and all the cords needed for its use. ");
INSERT INTO engBBE_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","From Kohath come the Amramites and the Izharites and the Hebronites and the Uzzielites; these are the families of the Kohathites. ");
INSERT INTO engBBE_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Those who were numbered of them, the males from one month old and over, were eight thousand, six hundred, who were responsible for the care of the holy place. ");
INSERT INTO engBBE_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","The tents of the Kohathites are to be placed on the south side of the House. ");
INSERT INTO engBBE_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Their chief is Elizaphan, the son of Uzziel. ");
INSERT INTO engBBE_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","In their care are the ark, and the table, and the lights, and the altars, and all the vessels used in the holy place, and the veil, and all they are used for. ");
INSERT INTO engBBE_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Eleazar, the son of Aaron the priest, will be head over all the Levites and overseer of those responsible for the care of the holy place. ");
INSERT INTO engBBE_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","From Merari come the Mahlites and the Mushites; these are the families of Merari. ");
INSERT INTO engBBE_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Those who were numbered of them, the males of a month old and over, were six thousand, two hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","The chief of the families of Merari was Zuriel, the son of Abihail: their tents are to be placed on the north side of the House. ");
INSERT INTO engBBE_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","And in their care are to be all the boards of the Tent, with their rods and pillars and bases, and all the instruments, and all they are used for, ");
INSERT INTO engBBE_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","And the pillars of the open space round it, with their bases and nails and cords. ");
INSERT INTO engBBE_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","And those whose tents are to be placed on the east side of the House in front of the Tent of meeting, looking to the dawn, are Moses and Aaron and his sons, who will do the work of the holy place for the children of Israel; and any strange person who comes near will be put to death. ");
INSERT INTO engBBE_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","All the Levites numbered by Moses and Aaron at the order of the Lord, all the males of one month old and over numbered in the order of their families, were twenty-two thousand. ");
INSERT INTO engBBE_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","And the Lord said to Moses, Let all the first male children be numbered, and take the number of their names. ");
INSERT INTO engBBE_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","And give to me the Levites (I am the Lord) in place of the first sons of the children of Israel; and the cattle of the Levites in place of the first births among the cattle of the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","So Moses had all the first sons among the children of Israel numbered, as the Lord said to him. ");
INSERT INTO engBBE_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Every first son from a month old and over was numbered by name, and the number came to twenty-two thousand, two hundred and seventy-three. ");
INSERT INTO engBBE_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Take the Levites in place of all the first sons of the children of Israel, and the cattle of the Levites in place of their cattle; the Levites are to be mine; I am the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","And the price you have to give for the two hundred and seventy-three first sons of the children of Israel which are in addition to the number of the Levites, ");
INSERT INTO engBBE_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Will be five shekels for every one, by the scale of the holy place (the shekel is twenty gerahs); ");
INSERT INTO engBBE_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","And this money, the price of those over the number of the Levites, is to be given to Aaron and his sons. ");
INSERT INTO engBBE_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","So Moses took the money, the price of those whose place had not been taken by the Levites; ");
INSERT INTO engBBE_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","From the first sons of Israel he took it, a thousand, three hundred and sixty-five shekels, by the scale of the holy place; ");
INSERT INTO engBBE_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","And he gave the money to Aaron and his sons, as the Lord had said. ");
INSERT INTO engBBE_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","And the Lord said to Moses and Aaron, ");
INSERT INTO engBBE_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Let the sons of Kohath, from among the sons of Levi, be numbered by their families, in the order of their fathers' houses; ");
INSERT INTO engBBE_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","All those from thirty to fifty years old who are able to do the work of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","And this is to be the work of the sons of Kohath in connection with the most holy things. ");
INSERT INTO engBBE_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","When all the people go forward, Aaron is to go in with his sons, and take down the veil of the curtain, covering the ark of witness with it; ");
INSERT INTO engBBE_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","And putting over it the leather cover and over that a blue cloth; and putting its rods in place. ");
INSERT INTO engBBE_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","And on the table of the holy bread they are to put a blue cloth, and on it all the vessels, the spoons and the basins and the cups; and the holy bread with them; ");
INSERT INTO engBBE_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","And over them they are to put a red cloth, covering it with a leather cover, and putting its rods in their places. ");
INSERT INTO engBBE_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","And they are to take a blue cloth, covering with it the light-support with its lights and its instruments and its trays and all the oil vessels which are used for it: ");
INSERT INTO engBBE_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","All these they are to put in a leather cover, and put it on the frame. ");
INSERT INTO engBBE_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","On the gold altar they are to put a blue cloth, covering it with a leather cover; and they are to put its rods in their places. ");
INSERT INTO engBBE_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","All the vessels which are used in the holy place they are to put in a blue cloth, covering them with a leather cover, and put them on the frame. ");
INSERT INTO engBBE_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","And they are to take away the burned waste from the altar, and put a purple cloth on it; ");
INSERT INTO engBBE_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Placing on the cloth all its vessels, the fire-baskets, the meat-hooks, the spades, and the basins; all the vessels of the altar; they are to put a leather cover over all these, and put its rods in their places. ");
INSERT INTO engBBE_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","And after the holy place and all its vessels have been covered up by Aaron and his sons, when the tents of the people go forward, the sons of Kohath are to come and take it up; but the holy things may not be touched by them for fear of death. ");
INSERT INTO engBBE_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","And Eleazar, the son of Aaron the priest, is to be responsible for the oil for the light, and the sweet perfumes for burning, and the regular meal offering, and the holy oil; the House and the holy place and everything in it will be in his care. ");
INSERT INTO engBBE_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","And the Lord said to Moses and Aaron, ");
INSERT INTO engBBE_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Do not let the family of the Kohathites be cut off from among the Levites; ");
INSERT INTO engBBE_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","But do this to them, so that life and not death may be theirs when they come near the most holy things; let Aaron and his sons go in and give to every one his work and that which he is to take up; ");
INSERT INTO engBBE_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","But they themselves are not to go in to see the holy place, even for a minute, for fear of death. ");
INSERT INTO engBBE_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Let the sons of Gershon be numbered by families, in the order of their fathers' houses; ");
INSERT INTO engBBE_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","All those from thirty to fifty years old who are able to do the work of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","This is to be the work of the Gershonites, the things they are to do and take up. ");
INSERT INTO engBBE_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","They are to take up the curtains of the House, and the Tent of meeting with its cover and the leather cover over it, and the hangings for the door of the Tent of meeting; ");
INSERT INTO engBBE_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","And the hangings for the open space round the House and the altar, and the curtain for its doorway, with the cords and all the things used for them; whatever is necessary for these, they are to do. ");
INSERT INTO engBBE_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","From the mouth of Aaron and his sons the Gershonites will have word about all the things they are to do and take up; you are to give them their orders. ");
INSERT INTO engBBE_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","This is the work of the family of the Gershonites in the Tent of meeting, and they will be under the direction of Ithamar, the son of Aaron the priest. ");
INSERT INTO engBBE_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","The sons of Merari are to be numbered by families, in the order of their fathers' houses; ");
INSERT INTO engBBE_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Every one from thirty to fifty years old who is able to do the work of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","And this is their part in the work of the Tent of meeting: the transport of the boards and the rods of the Tent, with the pillars and their bases; ");
INSERT INTO engBBE_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","And the pillars of the open space outside it, with their bases and their nails and cords and all the instruments used, and everything which has to be done there; all the instruments for which they are responsible are to be numbered by name. ");
INSERT INTO engBBE_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","This is the work which the sons of Merari are to do in connection with the Tent of meeting, under the direction of Ithamar, the son of Aaron the priest. ");
INSERT INTO engBBE_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","So Moses and Aaron and the chiefs of the people took in hand the numbering of the sons of the Kohathites, by families, in the order of their fathers' houses; ");
INSERT INTO engBBE_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Numbering all those from thirty to fifty years old who were able to do the work in the Tent of meeting; ");
INSERT INTO engBBE_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","And the number of all these was two thousand, seven hundred and fifty. ");
INSERT INTO engBBE_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","This is the number of those of the Kohathites who did the work in the Tent of meeting, as they were numbered by Moses and Aaron at the order of the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","And those of the sons of Gershon who were numbered by families, ");
INSERT INTO engBBE_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","All those from thirty to fifty years old who were able to do the work in the Tent of meeting, ");
INSERT INTO engBBE_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Who were numbered by families in the order of their fathers' houses, were two thousand, six hundred and thirty. ");
INSERT INTO engBBE_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","This is the number of the sons of Gershon who did the work in the Tent of meeting, as they were numbered by Moses and Aaron at the order of the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","And those of the sons of Merari who were numbered by families, in the order of their fathers' houses, ");
INSERT INTO engBBE_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","All those from thirty to fifty years old who did the work in the Tent of meeting, ");
INSERT INTO engBBE_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Who were numbered by families, were three thousand, two hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","This is the number of the sons of Merari, numbered by Moses and Aaron at the order of the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","And all the Levites who were numbered by Moses and Aaron and the chiefs of the people, by families, in the order of their fathers' houses, ");
INSERT INTO engBBE_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Those from thirty to fifty years old who were able to do the work of the Tent of meeting and of its transport, ");
INSERT INTO engBBE_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Came to eight thousand, five hundred and eighty. ");
INSERT INTO engBBE_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","At the order of the Lord they were numbered by Moses, every one in relation to his work and to his part in the transport; so they were numbered by Moses at the order of the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Give orders to the children of Israel to put outside the tent-circle every leper, and anyone who has any sort of flow from his body, and anyone who is unclean from the touch of the dead; ");
INSERT INTO engBBE_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Male or female they are to be put outside the tent-circle, so that they may not make unclean my resting-place among them. ");
INSERT INTO engBBE_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","So the children of Israel did as the Lord had said to Moses, and put them outside the tent-circle. ");
INSERT INTO engBBE_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Say to the children of Israel, If a man or a woman does any of the sins of men, going against the word of the Lord, and is in the wrong; ");
INSERT INTO engBBE_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Let them say openly what they have done; and make payment for the wrong done, with the addition of a fifth part, and give it to him to whom the wrong was done. ");
INSERT INTO engBBE_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","But if the man has no relation to whom the payment may be made, then the payment for sin made to the Lord will be the priest's, in addition to the sheep offered to take away his sin. ");
INSERT INTO engBBE_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","And every offering lifted up of all the holy things which the children of Israel give to the priest, will be his. ");
INSERT INTO engBBE_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","And every man's holy things will be his: whatever a man gives to the priest will be his. ");
INSERT INTO engBBE_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Say to the children of Israel, If any man's wife does wrong, sinning against him ");
INSERT INTO engBBE_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","By taking as her lover another man, and keeps it secret so that her husband has no knowledge of it, and there is no witness against her, and she is not taken in the act; ");
INSERT INTO engBBE_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","If the spirit of doubt comes into her husband's heart, and he has doubts of his wife, with good cause; or if he has doubts of her without cause: ");
INSERT INTO engBBE_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Then let him take her to the priest, offering for her the tenth part of an ephah of barley meal, without oil or perfume; for it is a meal offering of a bitter spirit, a meal offering keeping wrongdoing in mind. ");
INSERT INTO engBBE_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","And the priest will make her come near and put her before the Lord; ");
INSERT INTO engBBE_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","And the priest will take holy water in a pot and put in it dust from the floor of the House; ");
INSERT INTO engBBE_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","And he will make the woman come before the Lord with her hair loose, and will put the meal offering, the offering of a bitter spirit, in her hands; and the priest will take in his hand the bitter water causing the curse; ");
INSERT INTO engBBE_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","And he will make her take an oath, and say to her, If no man has been your lover and you have not been with another in place of your husband, you are free from this bitter water causing the curse; ");
INSERT INTO engBBE_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","But if you have been with another in place of your husband and have made yourself unclean with a lover: ");
INSERT INTO engBBE_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Then the priest will put the oath of the curse on the woman, and say to her, May the Lord make you a curse and an oath among your people, sending on you wasting of the legs and disease of the stomach; ");
INSERT INTO engBBE_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","And this water of the curse will go into your body, causing disease of your stomach and wasting of your legs: and the woman will say, So be it. ");
INSERT INTO engBBE_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","And the priest will put these curses in a book, washing out the writing with the bitter water; ");
INSERT INTO engBBE_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","And he will give to the woman the bitter water for drink; and the bitter water causing the curse will go into her. ");
INSERT INTO engBBE_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","And the priest will take from her hand the meal offering of doubt, waving it before the Lord, and will take it to the altar; ");
INSERT INTO engBBE_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","And he will take some of it in his hand, burning it on the altar as a sign, and then he will give the woman the bitter water. ");
INSERT INTO engBBE_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","And it will be that if the woman has become unclean, sinning against her husband, when she has taken the bitter water it will go into her body, causing disease of the stomach and wasting of the legs, and she will be a curse among her people. ");
INSERT INTO engBBE_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","But if she is clean she will be free and will have offspring. ");
INSERT INTO engBBE_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","This is the law for testing a wife who goes with another in place of her husband and becomes unclean; ");
INSERT INTO engBBE_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Or for a husband who, in a bitter spirit, has doubts in his heart about his wife; let him take her to the priest, who will put in force this law. ");
INSERT INTO engBBE_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Then the man will be free from all wrong, and the woman's sin will be on her. ");
INSERT INTO engBBE_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Say to the children of Israel, If a man or a woman takes an oath to keep himself separate and give himself to the Lord; ");
INSERT INTO engBBE_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","He is to keep himself from wine and strong drink, and take no mixed wine or strong drink or any drink made from grapes, or any grapes, green or dry. ");
INSERT INTO engBBE_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","All the time he is separate he may take nothing made from the grape-vine, from its seeds to its skin. ");
INSERT INTO engBBE_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","All the time he is under his oath let no blade come near his head; till the days while he is separate are ended he is holy and his hair may not be cut. ");
INSERT INTO engBBE_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","All the time he is separate he may not come near any dead body. ");
INSERT INTO engBBE_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","He may not make himself unclean for his father or his mother, his sister or his brother, if death comes to them; because he is under an oath to keep himself separate for God. ");
INSERT INTO engBBE_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","All the time he is separate he is holy to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","If death comes suddenly to a man at his side, so that he becomes unclean, let his hair be cut off on the day when he is made clean, on the seventh day. ");
INSERT INTO engBBE_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","And on the eighth day let him take to the priest, at the door of the Tent of meeting, two doves or two young pigeons; ");
INSERT INTO engBBE_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","And the priest will give one for a sin-offering and the other for a burned offering to take away the sin which came on him on account of the dead, and he will make his head holy that same day. ");
INSERT INTO engBBE_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","And he will give to the Lord his days of being separate, offering a he-lamb of the first year as an offering for error: but the earlier days will be a loss, because he became unclean. ");
INSERT INTO engBBE_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","And this is the law for him who is separate, when the necessary days are ended: he is to come to the door of the Tent of meeting, ");
INSERT INTO engBBE_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","And make his offering to the Lord; one he-lamb of the first year, without a mark, for a burned offering, and one female lamb of the first year, without a mark, for a sin-offering, and one male sheep, without a mark, for peace-offerings, ");
INSERT INTO engBBE_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","And a basket of unleavened bread, cakes of the best meal mixed with oil, and thin unleavened cakes covered with oil, with their meal offering and drink offerings. ");
INSERT INTO engBBE_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","And the priest will take them before the Lord, and make his sin-offering and his burned offering; ");
INSERT INTO engBBE_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Giving the sheep of the peace-offerings, with the basket of unleavened bread; and at the same time, the priest will make his meal offering and his drink offering. ");
INSERT INTO engBBE_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Then let his long hair, the sign of his oath, be cut off at the door of the Tent of meeting, and let him put it on the fire on which the peace-offerings are burning. ");
INSERT INTO engBBE_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","And the priest will take the cooked leg of the sheep and one unleavened cake and one thin cake out of the basket, and put them on the hands of the separate one after his hair has been cut, ");
INSERT INTO engBBE_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Waving them for a wave offering before the Lord; this is holy for the priest, together with the waved breast and the leg which is lifted up; after that, the man may take wine. ");
INSERT INTO engBBE_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","This is the law for him who takes an oath to keep himself separate, and for his offering to the Lord on that account, in addition to what he may be able to get; this is the law of his oath, which he will have to keep. ");
INSERT INTO engBBE_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Say to Aaron and his sons, These are the words of blessing which are to be used by you in blessing the children of Israel; say to them, ");
INSERT INTO engBBE_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","May the Lord send his blessing on you and keep you: ");
INSERT INTO engBBE_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","May the light of the Lord's face be shining on you in grace: ");
INSERT INTO engBBE_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","May the Lord's approval be resting on you and may he give you peace. ");
INSERT INTO engBBE_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","So they will put my name on the children of Israel, and I will give them my blessing. ");
INSERT INTO engBBE_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","And when Moses had put up the House completely, and had put oil on it and made it holy, with all the things in it, and had made the altar and all its vessels holy with oil; ");
INSERT INTO engBBE_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Then the chiefs of Israel, the heads of their fathers' houses, made offerings; these were the chiefs of the tribes, who were over those who were numbered. ");
INSERT INTO engBBE_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","And they came with their offerings before the Lord, six covered carts and twelve oxen; a cart for every two of the chiefs, and for every one an ox. ");
INSERT INTO engBBE_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Take the things from them, to be used for the work of the Tent of meeting; and give them to the Levites, to every man what is needed for his work. ");
INSERT INTO engBBE_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","So Moses took the carts and the oxen and gave them to the Levites. ");
INSERT INTO engBBE_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Two carts and four oxen he gave to the sons of Gershon for their work; ");
INSERT INTO engBBE_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","And four carts and eight oxen he gave to the sons of Merari for their work, under the direction of Ithamar, the son of Aaron the priest. ");
INSERT INTO engBBE_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","But to the sons of Kohath he gave nothing; because they had the care of the holy place, taking it about on their backs. ");
INSERT INTO engBBE_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","And the chiefs gave an offering for the altar on the day when the holy oil was put on it; they made their offering before the altar. ");
INSERT INTO engBBE_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","And the Lord said to Moses, Let every chief on his day give his offering to make the altar holy. ");
INSERT INTO engBBE_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","And he who made his offering on the first day was Nahshon, the son of Amminadab, of the tribe of Judah: ");
INSERT INTO engBBE_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","And his offering was one silver plate, a hundred and thirty shekels in weight, one silver basin of seventy shekels, by the scale of the holy place; the two of them full of the best meal mixed with oil for a meal offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","One gold spoon of ten shekels, full of spice for burning; ");
INSERT INTO engBBE_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","One young ox, one male sheep, one he-lamb of the first year, for a burned offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","One male of the goats for a sin-offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","And for the peace-offerings, two oxen, five male sheep, five he-goats, five he-lambs of the first year: this was the offering of Nahshon, the son of Amminadab. ");
INSERT INTO engBBE_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","On the second day Nethanel, the son of Zuar, chief of Issachar, made his offering: ");
INSERT INTO engBBE_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","He gave one silver plate, a hundred and thirty shekels in weight, one silver basin of seventy shekels, by the scale of the holy place; the two of them full of the best meal mixed with oil for a meal offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","One gold spoon of ten shekels, full of spice; ");
INSERT INTO engBBE_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","One young ox, one male sheep, one he-lamb of the first year, for a burned offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","One male of the goats for a sin-offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","And for the peace-offerings, two oxen, five male sheep, five he-goats, five he-lambs of the first year: this was the offering of Nethanel, the son of Zuar. ");
INSERT INTO engBBE_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","On the third day Eliab, the son of Helon, chief of the children of Zebulun: ");
INSERT INTO engBBE_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","His offering was one silver plate, a hundred and thirty shekels in weight, one silver basin of seventy shekels, by the scale of the holy place; the two of them full of the best meal mixed with oil for a meal offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","One gold spoon of ten shekels, full of spice; ");
INSERT INTO engBBE_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","One young ox, one male sheep, one he-lamb of the first year, for a burned offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","One male of the goats for a sin-offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","And for the peace-offerings, two oxen, five male sheep, five he-goats, five he-lambs of the first year: this was the offering of Eliab, the son of Helon. ");
INSERT INTO engBBE_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","On the fourth day Elizur, the son of Shedeur, chief of the children of Reuben: ");
INSERT INTO engBBE_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","His offering was one silver plate, a hundred and thirty shekels in weight, one silver basin of seventy shekels, by the scale of the holy place; the two of them full of the best meal mixed with oil for a meal offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","One gold spoon of ten shekels, full of spice; ");
INSERT INTO engBBE_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","One young ox, one male sheep, one he-lamb of the first year, for a burned offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","One male of the goats for a sin-offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","And for the peace-offerings, two oxen, five male sheep, five he-goats, five he-lambs of the first year: this was the offering of Elizur, the son of Shedeur. ");
INSERT INTO engBBE_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","On the fifth day Shelumiel, the son of Zurishaddai, chief of the children of Simeon: ");
INSERT INTO engBBE_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","His offering was one silver plate, a hundred and thirty shekels in weight, one silver basin of seventy shekels, by the scale of the holy place; the two of them full of the best meal mixed with oil for a meal offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","One gold spoon of ten shekels, full of spice; ");
INSERT INTO engBBE_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","One young ox, one male sheep, one he-lamb of the first year, for a burned offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","One male of the goats for a sin-offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","And for the peace-offerings, two oxen, five male sheep, five he-goats, five he-lambs of the first year: this was the offering of Shelumiel, the son of Zurishaddai. ");
INSERT INTO engBBE_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","On the sixth day Eliasaph, the son of Reuel, chief of the children of Gad: ");
INSERT INTO engBBE_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","His offering was one silver plate, a hundred and thirty shekels in weight, one silver basin of seventy shekels, by the scale of the holy place; the two of them full of the best meal mixed with oil for a meal offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","One gold spoon of ten shekels, full of spice; ");
INSERT INTO engBBE_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","One young ox, one male sheep, one he-lamb of the first year, for a burned offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","One male of the goats for a sin-offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","And for the peace-offerings, two oxen, five male sheep, five he-goats, five he-lambs of the first year: this was the offering of Eliasaph, the son of Reuel ");
INSERT INTO engBBE_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","On the seventh day Elishama, the son of Ammihud, chief of the children of Ephraim: ");
INSERT INTO engBBE_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","His offering was one silver plate, a hundred and thirty shekels in weight, one silver basin of seventy shekels, by the scale of the holy place; the two of them full of the best meal mixed with oil for a meal offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","One gold spoon of ten shekels, full of spice; ");
INSERT INTO engBBE_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","One young ox, one male sheep, one he-lamb of the first year, for a burned offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","One male of the goats for a sin-offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","And for the peace-offerings, two oxen, five male sheep, five he-goats, five he-lambs of the first year: this was the offering of Elishama, the son of Ammihud. ");
INSERT INTO engBBE_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","On the eighth day Gamaliel, the son of Pedahzur, chief of the children of Manasseh: ");
INSERT INTO engBBE_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","His offering was one silver plate, a hundred and thirty shekels in weight, one silver basin of seventy shekels, by the scale of the holy place; the two of them full of the best meal mixed with oil for a meal offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","One gold spoon of ten shekels, full of spice; ");
INSERT INTO engBBE_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","One young ox, one male sheep, one he-lamb of the first year, for a burned offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","One male of the goats for a sin-offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","And for the peace-offerings, two oxen, five male sheep, five he-goats, five he-lambs of the first year: this was the offering of Gamaliel, the son of Pedahzur. ");
INSERT INTO engBBE_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","On the ninth day Abidan, the son of Gideoni, chief of the children of Benjamin: ");
INSERT INTO engBBE_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","His offering was one silver plate, a hundred and thirty shekels in weight, one silver basin of seventy shekels, by the scale of the holy place; the two of them full of the best meal mixed with oil for a meal offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","One gold spoon of ten shekels, full of spice; ");
INSERT INTO engBBE_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","One young ox, one male sheep, one he-lamb of the first year for a burned offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","One male of the goats for a sin-offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","And for the peace-offerings, two oxen, five male sheep, five he-goats, five he-lambs of the first year: this was the offering of Abidan, the son of Gideoni. ");
INSERT INTO engBBE_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","On the tenth day Ahiezer; the son of Ammishaddai, chief of the children of Dan: ");
INSERT INTO engBBE_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","His offering was one silver plate, a hundred and thirty shekels in weight, one silver basin of seventy shekels, by the scale of the holy place; the two of them full of the best meal mixed with oil for a meal offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","One gold spoon of ten shekels, full of spice; ");
INSERT INTO engBBE_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","One young ox, one male sheep, one he-lamb of the first year, for a burned offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","One male of the goats for a sin-offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","And for the peace-offerings, two oxen, five male sheep, five he-goats, five he-lambs of the first year: this was the offering of Ahiezer, the son of Ammishaddai. ");
INSERT INTO engBBE_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","On the eleventh day Pagiel, the son of Ochran, chief of the children of Asher: ");
INSERT INTO engBBE_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","His offering was one silver plate; a hundred and thirty shekels in weight, one silver basin of seventy shekels, by the scale of the holy place; the two of them full of the best meal mixed with oil for a meal offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","One gold spoon of ten shekels, full of spice; ");
INSERT INTO engBBE_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","One young ox, one male sheep, one he-lamb of the first year, for a burned offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","One male of the goats for a sin-offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","And for the peace-offerings, two oxen, five male sheep, five he-goats, five he-lambs of the first year: this was the offering of Pagiel, the son of Ochran. ");
INSERT INTO engBBE_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","On the twelfth day Ahira, the son of Enan, chief of the children of Naphtali: ");
INSERT INTO engBBE_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","His offering was one silver plate, a hundred and thirty shekels in weight, one silver basin of seventy shekels, by the scale of the holy place; the two of them full of the best meal mixed with oil for a meal offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","One gold spoon of ten shekels, full of spice; ");
INSERT INTO engBBE_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","One young ox, one male sheep, one he-lamb of the first year, for a burned offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","One male of the goats for a sin-offering; ");
INSERT INTO engBBE_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","And for the peace-offerings, two oxen, five male sheep, five he-goats, five he-lambs of the first year: this was the offering of Ahira, the son of Enan. ");
INSERT INTO engBBE_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","These were the offerings given for the altar by the chiefs of Israel, when the holy oil was put on it: twelve silver plates, twelve silver basins, twelve gold spoons; ");
INSERT INTO engBBE_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","The weight of every silver plate was a hundred and thirty shekels, and of every basin seventy; the weight of all the silver of the vessels was two thousand and four hundred shekels, by the scale of the holy place; ");
INSERT INTO engBBE_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","The weight of the twelve gold spoons of spice for burning was ten shekels for every one, by the scale of the holy place; all the gold of the spoons was a hundred and twenty shekels; ");
INSERT INTO engBBE_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","All the oxen, for the burned offering were twelve, the male sheep twelve, the he-lambs of the first year twelve, with their meal offering; and the males of the goats for sin-offering twelve; ");
INSERT INTO engBBE_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","And all the oxen for the peace-offerings, twenty-four oxen, the male sheep sixty, and the he-goats sixty, the he-lambs of the first year sixty. This was given for the altar after the holy oil was put on it. ");
INSERT INTO engBBE_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","And when Moses went into the Tent of meeting to have talk with him, then the Voice came to his ears from over the cover which was on the ark of witness, from between the two winged ones. And he had talk with him. ");
INSERT INTO engBBE_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Say to Aaron, When you put the lights in their places, the seven lights will give light in front of the support. ");
INSERT INTO engBBE_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","And Aaron did so; he put the lights in their places so that they gave light in front of the support, as the Lord gave orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","The support for the lights was of hammered gold work, from its base to its flowers it was of hammered work; from the design which the Lord had given to Moses, he made the support for the lights. ");
INSERT INTO engBBE_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Take the Levites out from among the children of Israel and make them clean. ");
INSERT INTO engBBE_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","And this is how you are to make them clean: let the holy water which takes away sin be put on them, and let the hair all over their bodies be cut off with a sharp blade, and let their clothing be washed and their bodies made clean. ");
INSERT INTO engBBE_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Then let them take a young ox and its meal offering, crushed grain mixed with oil, and take another ox for a sin-offering. ");
INSERT INTO engBBE_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","And make the Levites come forward in front of the Tent of meeting, and let all the children of Israel come together: ");
INSERT INTO engBBE_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","And you are to take the Levites before the Lord: and the children of Israel are to put their hands on them: ");
INSERT INTO engBBE_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","And Aaron is to give the Levites to the Lord as a wave offering from the children of Israel, so that they may do the Lord's work. ");
INSERT INTO engBBE_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","And the Levites are to put their hands on the heads of the oxen, and one of the oxen is to be offered for a sin-offering and the other for a burned offering to the Lord to take away the sin of the Levites. ");
INSERT INTO engBBE_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Then the Levites are to be put before Aaron and his sons, to be offered as a wave offering to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","So you are to make the Levites separate from the children of Israel, and the Levites will be mine. ");
INSERT INTO engBBE_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","After that, the Levites will go in to do whatever has to be done in the Tent of meeting; you are to make them clean and give them as a wave offering. ");
INSERT INTO engBBE_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","For they have been given to me from among the children of Israel; in place of every mother's first son, the first to come to birth in Israel, I have taken them for myself. ");
INSERT INTO engBBE_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","For every mother's first son among the children of Israel is mine, the first male birth of man or beast: on the day when I sent death on all the first sons in the land of Egypt, I made them mine. ");
INSERT INTO engBBE_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","And in place of the first sons among the children of Israel, I have taken the Levites. ");
INSERT INTO engBBE_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","And I have given them to Aaron and to his sons, from among the children of Israel, to undertake for them all the work of the Tent of meeting, and to take away sin from the children of Israel so that no evil may come on them when they come near the holy place. ");
INSERT INTO engBBE_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","All these things Moses and Aaron and the children of Israel did to the Levites; as the Lord gave orders to Moses about the Levites, so the children of Israel did. ");
INSERT INTO engBBE_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","And the Levites were made clean from sin, and their clothing was washed, and Aaron gave them for a wave offering before the Lord; and Aaron took away their sin and made them clean. ");
INSERT INTO engBBE_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","And then the Levites went in to do their work in the Tent of meeting before Aaron and his sons: all the orders which the Lord had given Moses about the Levites were put into effect. ");
INSERT INTO engBBE_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","This is the rule for the Levites: those of twenty-five years old and over are to go in and do the work of the Tent of meeting; ");
INSERT INTO engBBE_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","But after they are fifty years old, they are to give up their work and do no more; ");
INSERT INTO engBBE_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","But be with their brothers in the Tent of meeting, taking care of it but doing no work. This is what you are to do in connection with the Levites and their work. ");
INSERT INTO engBBE_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","And the Lord said to Moses, in the waste land of Sinai, in the first month of the second year after they had come out of the land of Egypt, ");
INSERT INTO engBBE_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Let the children of Israel keep the Passover at its regular time. ");
INSERT INTO engBBE_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","In the fourteenth day of this month, at evening, you are to keep it at the regular time, and in the way ordered in the law. ");
INSERT INTO engBBE_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","And Moses gave orders to the children of Israel to keep the Passover. ");
INSERT INTO engBBE_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","So they kept the Passover in the first month, on the fourteenth day of the month, at evening, in the waste land of Sinai: as the Lord gave orders to Moses, so the children of Israel did. ");
INSERT INTO engBBE_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","And there were certain men who were unclean because of a dead body, so that they were not able to keep the Passover on that day; and they came before Moses and before Aaron on that day: ");
INSERT INTO engBBE_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","And these men said to him, We have been made unclean by the dead body of a man; why may we not make the offering of the Lord at the regular time among the children of Israel? ");
INSERT INTO engBBE_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","And Moses said to them, Do nothing till the Lord gives me directions about you. ");
INSERT INTO engBBE_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Say to the children of Israel, If any one of you or of your families is unclean because of a dead body, or is on a journey far away, still he is to keep the Passover to the Lord: ");
INSERT INTO engBBE_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","In the second month, on the fourteenth day, in the evening, they are to keep it, taking it with unleavened bread and bitter-tasting plants; ");
INSERT INTO engBBE_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Nothing of it is to be kept till the morning, and no bone of it is to be broken: they are to keep it by the rules of the Passover. ");
INSERT INTO engBBE_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","But the man who, not being unclean or on a journey, does not keep the Passover, will be cut off from his people: because he did not make the offering of the Lord at the regular time, his sin will be on him. ");
INSERT INTO engBBE_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","And if a man from another country is among you and has a desire to keep the Passover to the Lord, let him do as is ordered in the law of the Passover: there is to be the same rule for the man from another nation and for him who had his birth in the land. ");
INSERT INTO engBBE_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","And on the day when the House was put up, the cloud came down on it, on the Tent of witness; and in the evening there was a light like fire over the House till the morning. ");
INSERT INTO engBBE_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","And so it was at all times: it was covered by the cloud, and by a light as of fire by night. ");
INSERT INTO engBBE_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","And whenever the cloud was taken up from over the House, then the children of Israel went journeying on; and in the place where the cloud came to rest, there the children of Israel put up their tents. ");
INSERT INTO engBBE_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","At the order of the Lord the children of Israel went forward, and at the order of the Lord they put up their tents: as long as the cloud was resting on the House, they did not go away from that place. ");
INSERT INTO engBBE_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","When the cloud was resting on the House for a long time the children of Israel, waiting for the order of the Lord, did not go on. ");
INSERT INTO engBBE_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Sometimes the cloud was resting on the House for two or three days; then, by the order of the Lord, they kept their tents in that place, and when the Lord gave the order they went on. ");
INSERT INTO engBBE_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","And sometimes the cloud was there only from evening to morning; and when the cloud was taken up in the morning they went on their journey again: or if it was resting there by day and by night, whenever the cloud was taken up they went forward. ");
INSERT INTO engBBE_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Or if the cloud came to rest on the House for two days or a month or a year without moving, the children of Israel went on waiting there and did not go on; but whenever it was taken up they went forward on their journey. ");
INSERT INTO engBBE_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","At the word of the Lord they put up their tents, and at the word of the Lord they went forward on their journey: they kept the orders of the Lord as he gave them by Moses. ");
INSERT INTO engBBE_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Make two silver horns of hammered work, to be used for getting the people together and to give the sign for the moving of the tents. ");
INSERT INTO engBBE_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","When they are sounded, all the people are to come together to you at the door of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","If only one of them is sounded, then the chiefs, the heads of the thousands of Israel, are to come to you. ");
INSERT INTO engBBE_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","When a loud note is sounded, the tents placed on the east side are to go forward. ");
INSERT INTO engBBE_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","At the sound of a second loud note, the tents on the south side are to go forward: the loud note will be the sign to go forward. ");
INSERT INTO engBBE_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","But when all the people are to come together, the horn is to be sounded but not loudly. ");
INSERT INTO engBBE_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","The horns are to be sounded by the sons of Aaron, the priests; this is to be a law for you for ever, from generation to generation. ");
INSERT INTO engBBE_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","And if you go to war in your land against any who do you wrong, then let the loud note of the horn be sounded; and the Lord your God will keep you in mind and give you salvation from those who are against you. ");
INSERT INTO engBBE_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","And on days of joy and on your regular feasts and on the first day of every month, let the horns be sounded over your burned offerings and your peace-offerings; and they will put the Lord in mind of you: I am the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Now in the second year, on the twentieth day of the second month, the cloud was taken up from over the Tent of witness. ");
INSERT INTO engBBE_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","And the children of Israel went on their journey out of the waste land of Sinai; and the cloud came to rest in the waste land of Paran. ");
INSERT INTO engBBE_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","They went forward for the first time on their journey as the Lord had given orders by the hand of Moses. ");
INSERT INTO engBBE_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","First the flag of the children of Judah went forward with their armies: and at the head of his army was Nahshon, the son of Amminadab. ");
INSERT INTO engBBE_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","And at the head of the army of the children of Issachar was Nethanel, the son of Zuar. ");
INSERT INTO engBBE_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","And at the head of the army of the children of Zebulun was Eliab, the son of Helon. ");
INSERT INTO engBBE_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Then the House was taken down; and the sons of Gershon and the sons of Merari, who were responsible for moving the House, went forward. ");
INSERT INTO engBBE_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Then the flag of the children of Reuben went forward with their armies: and at the head of his army was Elizur, the son of Shedeur. ");
INSERT INTO engBBE_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","And at the head of the army of the children of Simeon was Shelumiel, the son of Zurishaddai. ");
INSERT INTO engBBE_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","At the head of the army of the children of Gad was Eliasaph, the son of Reuel. ");
INSERT INTO engBBE_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Then the Kohathites went forward with the holy place; the others put up the House ready for their coming. ");
INSERT INTO engBBE_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Then the flag of the children of Ephraim went forward with their armies: and at the head of his army was Elishama, the son of Ammihud. ");
INSERT INTO engBBE_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","At the head of the army of the children of Manasseh was Gamaliel, the son of Pedahzur. ");
INSERT INTO engBBE_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","At the head of the army of the children of Benjamin was Abidan, the son of Gideoni. ");
INSERT INTO engBBE_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","And the flag of the children of Dan, whose tents were moved last of all, went forward with their armies: and at the head of his army was Ahiezer, the son of Ammishaddai. ");
INSERT INTO engBBE_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","At the head of the army of the children of Asher was Pagiel, the son of Ochran. ");
INSERT INTO engBBE_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","And at the head of the army of the children of Naphtali was Ahira, the son of Enan. ");
INSERT INTO engBBE_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","This was the order in which the children of Israel were journeying by armies; so they went forward. ");
INSERT INTO engBBE_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Then Moses said to Hobab, the son of his father-in-law Reuel the Midianite, We are journeying to that place of which the Lord has said, I will give it to you: so come with us, and it will be for your profit: for the Lord has good things in store for Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","But he said, I will not go with you, I will go back to the land of my birth and to my relations. ");
INSERT INTO engBBE_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","And he said, Do not go from us; for you will be eyes for us, guiding us to the right places in the waste land to put up our tents. ");
INSERT INTO engBBE_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","And if you come with us, we will give you a part in whatever good the Lord does for us. ");
INSERT INTO engBBE_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","So they went forward three days' journey from the mountain of the Lord; and the ark of the Lord's agreement went three days' journey before them, looking for a resting-place for them; ");
INSERT INTO engBBE_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","And by day the cloud of the Lord went over them, when they went forward from the place where they had put up their tents. ");
INSERT INTO engBBE_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","And when the ark went forward Moses said, Come up, O Lord, and let the armies of those who are against you be broken, and let your haters go in flight before you. ");
INSERT INTO engBBE_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","And when it came to rest, he said, Take rest, O Lord, and give a blessing to the families of Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Now the people were saying evil against the Lord; and the Lord, hearing it, was angry and sent fire on them, burning the outer parts of the tent-circle. ");
INSERT INTO engBBE_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","And the people made an outcry to Moses, and Moses made prayer to the Lord, and the fire was stopped. ");
INSERT INTO engBBE_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","So that place was named Taberah, because of the fire of the Lord which had been burning among them. ");
INSERT INTO engBBE_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","And the mixed band of people who went with them were overcome by desire: and the children of Israel, weeping again, said, Who will give us flesh for our food? ");
INSERT INTO engBBE_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Sweet is the memory of the fish we had in Egypt for nothing, and the fruit and green plants of every sort, sharp and pleasing to the taste: ");
INSERT INTO engBBE_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","But now our soul is wasted away; there is nothing at all: we have nothing but this manna before our eyes. ");
INSERT INTO engBBE_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Now the manna was like a seed of grain, like small clear drops. ");
INSERT INTO engBBE_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","The people went about taking it up from the earth, crushing it between stones or hammering it to powder, and boiling it in pots, and they made cakes of it: its taste was like the taste of cakes cooked with oil. ");
INSERT INTO engBBE_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","When the dew came down on the tents at night, the manna came down with it. ");
INSERT INTO engBBE_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","And at the sound of the people weeping, every man at his tent-door, the wrath of the Lord was great, and Moses was very angry. ");
INSERT INTO engBBE_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","And Moses said to the Lord, Why have you done me this evil? and why have I not grace in your eyes, that you have put on me the care of all this people? ");
INSERT INTO engBBE_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Am I the father of all this people? have I given them birth, that you say to me, Take them in your arms, like a child at the breast, to the land which you gave by an oath to their fathers? ");
INSERT INTO engBBE_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Where am I to get flesh to give to all this people? For they are weeping to me and saying, Give us flesh for our food. ");
INSERT INTO engBBE_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","I am not able by myself to take the weight of all this people, for it is more than my strength. ");
INSERT INTO engBBE_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","If this is to be my fate, put me to death now in answer to my prayer, if I have grace in your eyes; and let me not see my shame. ");
INSERT INTO engBBE_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","And the Lord said to Moses, Send for seventy of the responsible men of Israel, who are in your opinion men of weight and authority over the people; make them come to the Tent of meeting and be there with you. ");
INSERT INTO engBBE_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","And I will come down and have talk with you there: and I will take some of the spirit which is on you and put it on them, and they will take part of the weight of the people off you, so that you do not have to take it by yourself. ");
INSERT INTO engBBE_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","And say to the people, Make yourselves clean before tomorrow and you will have flesh for your food: for in the ears of the Lord you have been weeping and saying, Who will give us flesh for food? for we were well off in Egypt: and so the Lord will give you flesh, and it will be your food; ");
INSERT INTO engBBE_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Not for one day only, or even for five or ten or twenty days; ");
INSERT INTO engBBE_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","But every day for a month, till you are tired of it, turning from it in disgust: because you have gone against the Lord who is with you, and have been weeping before him saying, Why did we come out of Egypt? ");
INSERT INTO engBBE_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Then Moses said, The people, among whom I am, are six hundred thousand men on foot; and you have said, I will give them flesh to be their food for a month. ");
INSERT INTO engBBE_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Are flocks and herds to be put to death for them? or are all the fish in the sea to be got together so that they may be full? ");
INSERT INTO engBBE_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","And the Lord said to Moses, Has the Lord's hand become short? Now you will see if my word comes true for you or not. ");
INSERT INTO engBBE_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","And Moses went out and gave the people the words of the Lord: and he took seventy of the responsible men of the people, placing them round the Tent. ");
INSERT INTO engBBE_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Then the Lord came down in the cloud and had talk with him, and put on the seventy men some of the spirit which was on him: now when the spirit came to rest on them, they were like prophets, but only at that time. ");
INSERT INTO engBBE_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","But two men were still in the tent-circle one of them named Eldad and the other Medad: and the spirit came to rest on them; they were among those who had been sent for, but they had not gone out to the Tent: and the prophet's power came on them in the tent-circle. ");
INSERT INTO engBBE_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","And a young man went running to Moses and said, Eldad and Medad are acting as prophets in the tent-circle. ");
INSERT INTO engBBE_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Then Joshua, the son of Nun, who had been Moses' servant from the time when he was a child, said, My lord Moses, let them be stopped. ");
INSERT INTO engBBE_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","And Moses said to him, Are you moved by envy on my account? If only all the Lord's people were prophets, and the Lord might put his spirit on them! ");
INSERT INTO engBBE_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Then Moses, with the responsible men of Israel, went back to the tent-circle. ");
INSERT INTO engBBE_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Then the Lord sent a wind, driving little birds from the sea, so that they came down on the tents, and all round the tent-circle, about a day's journey on this side and on that, in masses about two cubits high over the face of the earth. ");
INSERT INTO engBBE_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","And all that day and all night and the day after, the people were taking up the birds; the smallest amount which anyone got was ten homers: and they put them out all round the tents. ");
INSERT INTO engBBE_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","But while the meat was still between their teeth, before it was tasted, the wrath of the Lord was moved against the people and he sent a great outburst of disease on them. ");
INSERT INTO engBBE_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","So that place was named Kibroth-hattaavah; because there they put in the earth the bodies of the people who had given way to their desires. ");
INSERT INTO engBBE_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","From Kibroth-hattaavah the people went on to Hazeroth; and there they put up their tents. ");
INSERT INTO engBBE_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Now Miriam and Aaron said evil against Moses, because of the Cushite woman to whom he was married, for he had taken a Cushite woman as his wife. ");
INSERT INTO engBBE_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","And they said, Have the words of the Lord been given to Moses only? have they not come to us? And the Lord took note of it. ");
INSERT INTO engBBE_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Now the man Moses was more gentle than any other man on earth. ");
INSERT INTO engBBE_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","And suddenly the Lord said to Moses and Aaron and Miriam, Come out, you three, to the Tent of meeting. And the three of them went out. ");
INSERT INTO engBBE_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","And the Lord came down in a pillar of cloud, taking his place at the door of the Tent, and made Aaron and Miriam come before him. ");
INSERT INTO engBBE_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","And he said, Now give ear to my words: if there is a prophet among you I will give him knowledge of myself in a vision and will let my words come to him in a dream. ");
INSERT INTO engBBE_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","My servant Moses is not so; he is true to me in all my house: ");
INSERT INTO engBBE_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","With him I will have talk mouth to mouth, openly and not in dark sayings; and with his eyes he will see the form of the Lord: why then had you no fear of saying evil against my servant Moses? ");
INSERT INTO engBBE_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","And burning with wrath against them, the Lord went away. ");
INSERT INTO engBBE_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","And the cloud was moved from over the Tent; and straight away Miriam became a leper, as white as snow: and Aaron, looking at Miriam, saw that she was a leper. ");
INSERT INTO engBBE_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Then Aaron said to Moses, O my lord, let not our sin be on our heads, for we have done foolishly and are sinners. ");
INSERT INTO engBBE_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Let her not be as one dead, whose flesh is half wasted when he comes out from the body of his mother. ");
INSERT INTO engBBE_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","And Moses, crying to the Lord, said, Let my prayer come before you, O God, and make her well. ");
INSERT INTO engBBE_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","And the Lord said to Moses, If her father had put a mark of shame on her, would she not be shamed for seven days? Let her be shut up outside the tent-circle for seven days, and after that she may come in again. ");
INSERT INTO engBBE_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","So Miriam was shut up outside the tent-circle for seven days: and the people did not go forward on their journey till Miriam had come in again. ");
INSERT INTO engBBE_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","After that, the people went on from Hazeroth and put up their tents in the waste land of Paran. ");
INSERT INTO engBBE_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Send men to get knowledge about the land of Canaan, which I am giving to the children of Israel; from every tribe of their fathers you are to send a man, every one a chief among them. ");
INSERT INTO engBBE_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","And Moses sent them from the waste land of Paran as the Lord gave orders, all of them men who were heads of the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","And these were their names: of the tribe of Reuben, Shammua, the son of Zaccur. ");
INSERT INTO engBBE_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Of the tribe of Simeon, Shaphat, the son of Hori. ");
INSERT INTO engBBE_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Of the tribe of Judah, Caleb, the son of Jephunneh. ");
INSERT INTO engBBE_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Of the tribe of Issachar, Igal, the son of Joseph. ");
INSERT INTO engBBE_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Of the tribe of Ephraim, Hoshea, the son of Nun. ");
INSERT INTO engBBE_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Of the tribe of Benjamin, Palti, the son of Raphu. ");
INSERT INTO engBBE_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Of the tribe of Zebulun, Gaddiel, the son of Sodi. ");
INSERT INTO engBBE_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Of the tribe of Joseph, that is of the family of Manasseh, Gaddi, the son of Susi. ");
INSERT INTO engBBE_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Of the tribe of Dan, Ammiel, the son of Gemalli. ");
INSERT INTO engBBE_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Of the tribe of Asher, Sethur, the son of Michael ");
INSERT INTO engBBE_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Of the tribe of Naphtali, Nahbi, the son of Vophsi. ");
INSERT INTO engBBE_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Of the tribe of Gad, Gevel, the son of Machi. ");
INSERT INTO engBBE_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","These are the names of the men whom Moses sent to get knowledge about the land. And Moses gave to Hoshea, the son of Nun, the name of Joshua. ");
INSERT INTO engBBE_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","So Moses sent them to have a look at the land of Canaan, and said to them, Go up into the South and into the hill-country; ");
INSERT INTO engBBE_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","And see what the land is like; and if the people living in it are strong or feeble, small or great in number; ");
INSERT INTO engBBE_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","And what sort of land they are living in, if it is good or bad; and what their living-places are, tent-circles or walled towns; ");
INSERT INTO engBBE_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","And if the land is fertile or poor, and if there is wood in it or not. And be of good heart, and come back with some of the produce of the land. Now it was the time when the first grapes were ready. ");
INSERT INTO engBBE_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","So they went up and got a view of the land, from the waste land of Zin to Rehob, on the way to Hamath. ");
INSERT INTO engBBE_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","They went up into the South and came to Hebron; and Ahiman and Sheshai and Talmai, the children of Anak, were living there. (Now the building of Hebron took place seven years before that of Zoan in Egypt.) ");
INSERT INTO engBBE_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","And they came to the valley of Eshcol, and cutting down a vine-branch with its grapes, two of them took it on a rod between them; and they took some pomegranates and figs. ");
INSERT INTO engBBE_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","That place was named the valley of Eshcol because of the grapes which the children of Israel took from there. ");
INSERT INTO engBBE_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","At the end of forty days they came back from viewing the land. ");
INSERT INTO engBBE_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","And they came back to Moses and Aaron and all the children of Israel, to Kadesh in the waste land of Paran; and gave an account to them and to all the people and let them see the produce of the land. ");
INSERT INTO engBBE_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","And they said, We came to the land where you sent us, and truly it is flowing with milk and honey: and here is some of the produce of it. ");
INSERT INTO engBBE_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","But the people living in the land are strong, and the towns are walled and very great; further, we saw the children of Anak there. ");
INSERT INTO engBBE_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","And the Amalekites are in the South; and the Hittites and the Jebusites and the Amorites are living in the hill-country; and the Canaanites by the sea and by the side of Jordan. ");
INSERT INTO engBBE_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Then Caleb made signs to the people to keep quiet, and said to Moses, Let us go up straight away and take this land; for we are well able to overcome it. ");
INSERT INTO engBBE_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","But the men who had gone up with him said, We are not able to go up against the people, for they are stronger than we. ");
INSERT INTO engBBE_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","And they gave the children of Israel a bad account of the land they had been to see, saying, This land through which we went is a land causing destruction to those living in it; and all the people we saw there are men of more than common size. ");
INSERT INTO engBBE_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","There we saw those great men, the sons of Anak, offspring of the Nephilim: and we seemed to ourselves no more than insects, and so we seemed to them. ");
INSERT INTO engBBE_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Then all the people gave load cries of grief, and all that night they gave themselves up to weeping. ");
INSERT INTO engBBE_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","And all the children of Israel, crying out against Moses and Aaron, said, If only we had come to our death in the land of Egypt, or even in this waste land! ");
INSERT INTO engBBE_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Why is the Lord taking us into this land to come to our death by the sword? Our wives and our little ones will get into strange hands: would it not be better for us to go back to Egypt? ");
INSERT INTO engBBE_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","And they said to one another, Let us make a captain over us, and go back to Egypt. ");
INSERT INTO engBBE_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Then Moses and Aaron went down on their faces before the meeting of the people. ");
INSERT INTO engBBE_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","And Joshua, the son of Nun, and Caleb, the son of Jephunneh, two of those who had been to see the land, giving signs of grief, ");
INSERT INTO engBBE_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Said to all the children of Israel, This land which we went through to see is a very good land. ");
INSERT INTO engBBE_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","And if the Lord has delight in us, he will take us into this land and give it to us, a land flowing with milk and honey. ");
INSERT INTO engBBE_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Only, do not go against the Lord or go in fear of the people of the land, for they will be our food; their strength has been taken from them and the Lord is with us: have no fear of them. ");
INSERT INTO engBBE_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","But all the people said they were to be stoned. Then the glory of the Lord was seen in the Tent of meeting, before the eyes of all the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","And the Lord said to Moses, How long will this people have no respect for me? how long will they be without faith, in the face of all the signs I have done among them? ");
INSERT INTO engBBE_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","I will send disease on them for their destruction, and take away their heritage, and I will make of you a nation greater and stronger than they. ");
INSERT INTO engBBE_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","And Moses said to the Lord, Then it will come to the ears of the Egyptians; for by your power you took this people out from among them; ");
INSERT INTO engBBE_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","And they will give the news to the people of this land: they have had word that you, Lord, are present with this people, letting yourself be seen face to face, and that your cloud is resting over them, and that you go before them in a pillar of cloud by day and in a pillar of fire by night. ");
INSERT INTO engBBE_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Now if you put to death all this people as one man, then the nations who have had word of your glory will say, ");
INSERT INTO engBBE_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Because the Lord was not able to take this people into the land which he made an oath to give them, he sent destruction on them in the waste land. ");
INSERT INTO engBBE_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","So now, may my prayer come before you, and let the power of the Lord be great, as you said: ");
INSERT INTO engBBE_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","The Lord is slow to wrath and great in mercy, overlooking wrongdoing and evil, and will not let wrongdoers go free; sending punishment on children for the sins of their fathers, to the third and fourth generation. ");
INSERT INTO engBBE_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","May the sin of this people have forgiveness, in the measure of your great mercy, as you have had mercy on them from Egypt up till now. ");
INSERT INTO engBBE_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","And the Lord said, I have had mercy, as you say: ");
INSERT INTO engBBE_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","But truly, as I am living, and as all the earth will be full of the glory of the Lord; ");
INSERT INTO engBBE_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Because all these men, having seen my glory and the signs which I have done in Egypt and in the waste land, still have put me to the test ten times, and have not given ear to my voice; ");
INSERT INTO engBBE_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","They will not see the land about which I made an oath to their fathers; not one of these by whom I have not been honoured will see it. ");
INSERT INTO engBBE_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","But my servant Caleb, because he had a different spirit in him, and has been true to me with all his heart, him I will take into that land into which he went, and his seed will have it for their heritage. ");
INSERT INTO engBBE_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Now the Amalekites and the Canaanites are in the valley; tomorrow, turning round, go into the waste land by the way to the Red Sea. ");
INSERT INTO engBBE_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Then the Lord said to Moses and Aaron, ");
INSERT INTO engBBE_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","How long am I to put up with this evil people and their outcries against me? The words which they say against me have come to my ears. ");
INSERT INTO engBBE_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Say to them, By my life, says the Lord, as certainly as your words have come to my ears, so certainly will I do this to you: ");
INSERT INTO engBBE_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Your dead bodies will be stretched out in this waste land; and of all your number, all those of twenty years old and over who have been crying out against me, ");
INSERT INTO engBBE_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Not one will come into the land which I gave my word you would have for your resting-place, but only Caleb, the son of Jephunneh, and Joshua, the son of Nun. ");
INSERT INTO engBBE_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","And your little ones, whom you said would come into strange hands, I will take in, and they will see the land which you would not have. ");
INSERT INTO engBBE_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","But as for you, your dead bodies will be stretched in this waste land. ");
INSERT INTO engBBE_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","And your children will be wanderers in the waste land for forty years, undergoing punishment for your false ways, till your bodies become dust in the waste land. ");
INSERT INTO engBBE_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","And as you went through the land viewing it for forty days, so for forty years, a year for every day, you will undergo punishment for your wrongdoing, and you will see that I am against you. ");
INSERT INTO engBBE_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","I the Lord have said it, and this I will certainly do to all this evil people who have come together against me: in this waste land destruction will come on them, and death will be their fate. ");
INSERT INTO engBBE_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","And the men whom Moses sent to see the land, and who, by the bad account they gave of the land, were the cause of the outcry the people made against Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Those same men who said evil of the land, came to their death by disease before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","But Joshua, the son of Nun, and Caleb, the son of Jephunneh, of those who went to see the land, were not touched by disease. ");
INSERT INTO engBBE_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","And when Moses put these words before the children of Israel, the people were full of grief. ");
INSERT INTO engBBE_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","And early in the morning they got up and went to the top of the mountain, saying, We are here and we will go up to the place which the Lord said he would give us: for we have done wrong. ");
INSERT INTO engBBE_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","And Moses said, Why are you now acting against the Lord's order, seeing that no good will come of it? ");
INSERT INTO engBBE_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Go not up, for the Lord is not with you, and you will be overcome by those who are fighting against you. ");
INSERT INTO engBBE_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","For the Amalekites and the Canaanites are there before you, and you will be put to death by their swords: because you have gone back from the way of the Lord, the Lord will not be with you. ");
INSERT INTO engBBE_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","But they gave no attention to his words and went to the top of the mountain, though Moses and the ark of the Lord's agreement did not go out of the tent-circle. ");
INSERT INTO engBBE_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Then the Amalekites came down, and the Canaanites who were living in the hill-country, and overcame them completely, driving them back as far as Hormah. ");
INSERT INTO engBBE_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Say to the children of Israel, When you have come into the land which I am giving to you for your resting-place, ");
INSERT INTO engBBE_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","And are going to make an offering by fire to the Lord, a burned offering or an offering in connection with an oath, or an offering freely given, or at your regular feasts, an offering for a sweet smell to the Lord, from the herd or the flock: ");
INSERT INTO engBBE_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Then let him who is making his offering, give to the Lord a meal offering of a tenth part of a measure of the best meal mixed with a fourth part of a hin of oil: ");
INSERT INTO engBBE_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","And for the drink offering, you are to give with the burned offering or other offering, the fourth part of a hin of wine for every lamb. ");
INSERT INTO engBBE_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Or for a male sheep, give as a meal offering two tenth parts of a measure of the best meal mixed with a third part of a hin of oil: ");
INSERT INTO engBBE_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","And for the drink offering give a third part of a hin of wine, for a sweet smell to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","And when you make ready a young ox for a burned or other offering, or for the effecting of an oath, or for peace-offerings to the Lord: ");
INSERT INTO engBBE_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","Then with the ox give a meal offering of three tenth parts of a measure of the best meal mixed with half a hin of oil. ");
INSERT INTO engBBE_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","And for the drink offering: give half a hin of wine, for an offering made by fire for a sweet smell to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","This is to be done for every young ox and for every male sheep or he-lamb or young goat. ");
INSERT INTO engBBE_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Whatever number you make ready, so you are to do for every one. ");
INSERT INTO engBBE_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","All those who are Israelites by birth are to do these things in this way, when giving an offering made by fire of a sweet smell to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","And if a man from another country or any other person living among you, through all your generations, has the desire to give an offering made by fire of a sweet smell to the Lord, let him do as you do. ");
INSERT INTO engBBE_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","There is to be one law for you and for the man of another country living with you, one law for ever from generation to generation; as you are, so is he to be before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","The law and the rule are to be the same for you and for those from other lands living with you. ");
INSERT INTO engBBE_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Say to the children of Israel, When you come into the land where I am guiding you, ");
INSERT INTO engBBE_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Then, when you take for your food the produce of the land, you are to give an offering lifted up before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Of the first of your rough meal you are to give a cake for a lifted offering, lifting it up before the Lord as the offering of the grain-floor is lifted up. ");
INSERT INTO engBBE_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","From generation to generation you are to give to the Lord a lifted offering from the first of your rough meal. ");
INSERT INTO engBBE_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","And if in error you go against any of these laws which the Lord has given to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","All the laws which the Lord has given you by the hand of Moses, from the day when the Lord gave them, and ever after from generation to generation; ");
INSERT INTO engBBE_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Then, if the wrong is done in error, without the knowledge of the meeting of the people, let all the meeting give a young ox as a burned offering, a sweet smell to the Lord, with its meal offering and its drink offering, as is ordered in the law, together with a he-goat for a sin-offering. ");
INSERT INTO engBBE_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","So the priest will make the people free from sin, and they will have forgiveness; for it was an error, and they have given their offering made by fire to the Lord, and their sin-offering before the Lord, on account of their error: ");
INSERT INTO engBBE_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","And all the meeting of the children of Israel, as well as those from other lands living among them, will have forgiveness; for it was an error on the part of the people. ");
INSERT INTO engBBE_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","And if one person does wrong, without being conscious of it, then let him give a she-goat of the first year for a sin-offering. ");
INSERT INTO engBBE_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","And the priest will take away the sin of the person who has done wrong, if the wrong was done unconsciously, and he will have forgiveness. ");
INSERT INTO engBBE_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","The law in connection with wrong done unconsciously is to be the same for him who is an Israelite by birth and for the man from another country who is living among them. ");
INSERT INTO engBBE_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","But the person who does wrong in the pride of his heart, if he is one of you or of another nation by birth, is acting without respect for the Lord, and will be cut off from his people. ");
INSERT INTO engBBE_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Because he had no respect for the word of the Lord, and did not keep his law, that man will be cut off without mercy and his sin will be on him. ");
INSERT INTO engBBE_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Now while the children of Israel were in the waste land, they saw a man who was getting sticks on the Sabbath day. ");
INSERT INTO engBBE_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","And those who saw him getting sticks took him before Moses and Aaron and all the people. ");
INSERT INTO engBBE_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","And they had him shut up, because they had no directions about what was to be done with him. ");
INSERT INTO engBBE_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Then the Lord said to Moses, Certainly the man is to be put to death: let him be stoned by all the people outside the tent-circle. ");
INSERT INTO engBBE_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","So all the people took him outside the tent-circle and he was stoned to death there, as the Lord gave orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Say to the children of Israel that through all their generations they are to put on the edges of their robes an ornament of twisted threads, and in every ornament a blue cord; ");
INSERT INTO engBBE_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","So that, looking on these ornaments, you may keep in mind the orders of the Lord and do them; and not be guided by the desires of your hearts and eyes, through which you have been untrue to me: ");
INSERT INTO engBBE_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","And that you may keep in mind all my orders and do them and be holy to your God. ");
INSERT INTO engBBE_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","I am the Lord your God, who took you out of the land of Egypt, so that I might be your God: I am the Lord your God. ");
INSERT INTO engBBE_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Now Korah, the son of Izhar, the son of Kohath, the son of Levi, with Dathan and Abiram, the sons of Eliab, and On, the son of Pallu, the son of Reuben, made themselves ready, ");
INSERT INTO engBBE_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","And came before Moses, with certain of the children of Israel, two hundred and fifty chiefs of the people, men of good name who had a place in the meeting of the people. ");
INSERT INTO engBBE_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","They came together against Moses and against Aaron, and said to them, You take overmuch on yourselves, seeing that all the people are holy, every one of them, and the Lord is among them; why then have you put yourselves in authority over the people of the Lord? ");
INSERT INTO engBBE_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","And Moses, hearing this, went down on his face; ");
INSERT INTO engBBE_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","And he said to Korah and his band, In the morning the Lord will make clear who are his, and who is holy, and who may come near him: the man of his selection will be caused to come near him. ");
INSERT INTO engBBE_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","So do this: let Korah and all his band take vessels for burning perfumes; ");
INSERT INTO engBBE_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","And put spices on the fire in them before the Lord tomorrow; then the man marked out by the Lord will be holy: you take overmuch on yourselves, you sons of Levi. ");
INSERT INTO engBBE_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","And Moses said to Korah, Give ear now, you sons of Levi: ");
INSERT INTO engBBE_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Does it seem only a small thing to you that the God of Israel has made you separate from the rest of Israel, letting you come near himself to do the work of the House of the Lord, and to take your place before the people to do what has to be done for them; ");
INSERT INTO engBBE_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Letting you, and all your brothers the sons of Levi, come near to him? and would you now be priests? ");
INSERT INTO engBBE_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","So you and all your band have come together against the Lord; and Aaron, who is he, that you are crying out against him? ");
INSERT INTO engBBE_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Then Moses sent for Dathan and Abiram, the sons of Eliab: and they said, We will not come up: ");
INSERT INTO engBBE_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Is it not enough that you have taken us from a land flowing with milk and honey, to put us to death in the waste land, but now you are desiring to make yourself a chief over us? ");
INSERT INTO engBBE_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","And more than this, you have not taken us into a land flowing with milk and honey, or given us a heritage of fields and vine-gardens: will you put out the eyes of these men? We will not come up. ");
INSERT INTO engBBE_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Then Moses was very angry, and said to the Lord, Give no attention to their offering: not one of their asses have I taken, or done wrong to any of them. ");
INSERT INTO engBBE_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","And Moses said to Korah, You and all your band are to come before the Lord tomorrow, you and they and Aaron: ");
INSERT INTO engBBE_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","And let every man take a vessel for burning perfumes, and put sweet spices in them; let every man take his vessel before the Lord, two hundred and fifty vessels; you and Aaron and everyone with his vessel. ");
INSERT INTO engBBE_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","So every man took his vessel and they put fire in them, with spices, and came to the door of the Tent of meeting with Moses and Aaron. ");
INSERT INTO engBBE_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","And Korah made all the people come together against them to the door of the Tent of meeting: and the glory of the Lord was seen by all the people. ");
INSERT INTO engBBE_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","And the Lord said to Moses and Aaron, ");
INSERT INTO engBBE_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Come out from among this people, so that I may send sudden destruction on them. ");
INSERT INTO engBBE_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Then falling down on their faces they said, O God, the God of the spirits of all flesh, because of one man's sin will your wrath be moved against all the people? ");
INSERT INTO engBBE_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Say to the people, Come away from the tent of Korah Dathan, and Abiram. ");
INSERT INTO engBBE_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","So Moses got up and went to Dathan and Abiram, and the responsible men of Israel went with him. ");
INSERT INTO engBBE_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","And he said to the people, Come away now from the tents of these evil men, without touching anything of theirs, or you may be taken in the punishment of their sins. ");
INSERT INTO engBBE_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","So on every side they went away from the tent of Korah Dathan, and Abiram: and Dathan and Abiram came out to the door of their tents, with their wives and their sons and their little ones. ");
INSERT INTO engBBE_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","And Moses said, Now you will see that the Lord has sent me to do all these works, and I have not done them of myself. ");
INSERT INTO engBBE_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","If these men have the common death of men, or if the natural fate of all men overtakes them, then the Lord has not sent me. ");
INSERT INTO engBBE_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","But if the Lord does something new, opening the earth to take them in, with everything which is theirs, and they go down living into the underworld, then it will be clear to you that the Lord has not been honoured by these men. ");
INSERT INTO engBBE_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","And while these words were on his lips, the earth under them was parted in two; ");
INSERT INTO engBBE_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","And the earth, opening her mouth, took them in, with their families, and all the men who were joined to Korah, and their goods. ");
INSERT INTO engBBE_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","So they and all theirs went down living into the underworld, and the earth was shut over them, and they were cut off from among the meeting of the people. ");
INSERT INTO engBBE_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","And all Israel round about them went in flight at their cry, For fear, said they, that we go down into the heart of the earth. ");
INSERT INTO engBBE_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Then fire came out from the Lord, burning up the two hundred and fifty men who were offering the perfume. ");
INSERT INTO engBBE_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Say to Eleazar, the son of Aaron the priest, that he is to take out of the flames the vessels with the perfumes in them, turning the fire out of them, for they are holy; ");
INSERT INTO engBBE_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","And let the vessels of those men, who with their lives have made payment for their sin, be hammered out into plates as a cover for the altar; for they have been offered before the Lord and are holy; so that they may be a sign to the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","So Eleazar the priest took the brass vessels which had been offered by those who were burned up, and they were hammered out to make a cover for the altar: ");
INSERT INTO engBBE_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","To be a sign, kept in memory for ever by the children of Israel, that no man who is not of the seed of Aaron has the right of burning spices before the Lord, so that he may not be like Korah and his band: as the Lord said to him by the mouth of Moses. ");
INSERT INTO engBBE_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","But on the day after, all the children of Israel made an outcry against Moses and against Aaron, saying, You have put to death the Lord's people. ");
INSERT INTO engBBE_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Now when the people had come together against Moses and Aaron, looking in the direction of the Tent of meeting, they saw the cloud covering it, and the glory of the Lord came before their eyes. ");
INSERT INTO engBBE_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Then Moses and Aaron came to the front of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Come out from among this people, so that I may send sudden destruction on them. And they went down on their faces. ");
INSERT INTO engBBE_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","And Moses said to Aaron, Take your vessel and put in it fire from the altar, and sweet spices, and take it quickly into the meeting of the people, and make them free from sin: for wrath has gone out from the Lord, and the disease is starting. ");
INSERT INTO engBBE_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","And at the words of Moses, Aaron took his vessel, and went running among the people; and even then the disease had made a start among them; and he put spices in his vessel to take away the sin of the people. ");
INSERT INTO engBBE_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","And he took his place between the dead and the living: and the disease was stopped. ");
INSERT INTO engBBE_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Now fourteen thousand, seven hundred deaths were caused by that disease, in addition to those who came to their end because of what Korah had done. ");
INSERT INTO engBBE_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Then Aaron went back to Moses to the door of the Tent of meeting: and the disease came to a stop. ");
INSERT INTO engBBE_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Say to the children of Israel that they are to give you rods, one for every family, for every chief, the head of his father's house, making twelve rods; let every man's name be placed on his rod. ");
INSERT INTO engBBE_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","And let Aaron's name be placed on the rod of Levi: for there is to be one rod for the head of every family. ");
INSERT INTO engBBE_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","And let them be stored up in the Tent of meeting, in front of the ark of witness where I come to you. ");
INSERT INTO engBBE_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","And the rod of that man who is marked out by me for myself will have buds on it; so I will put a stop to the outcries which the children of Israel make to me against you. ");
INSERT INTO engBBE_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","So Moses gave these orders to the children of Israel, and all their chiefs gave him rods, one for the head of every family, making twelve rods: and Aaron's rod was among them. ");
INSERT INTO engBBE_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","And Moses put the rods before the Lord in the Tent of witness. ");
INSERT INTO engBBE_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Now on the day after, Moses went into the Tent of witness; and he saw that Aaron's rod, the rod of the house of Levi, had put out buds, and was covered with buds and flowers and fruit. ");
INSERT INTO engBBE_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Then Moses took out all the rods from before the Lord, and gave them back to the children of Israel: and they saw them, and every man took his rod. ");
INSERT INTO engBBE_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","And the Lord said to Moses, Put Aaron's rod back in front of the ark of witness, to be kept for a sign against this false-hearted people, so that you may put a stop to their outcries against me, and death may not overtake them. ");
INSERT INTO engBBE_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","This Moses did: as the Lord gave orders, so he did. ");
INSERT INTO engBBE_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","And the children of Israel said to Moses, Truly, destruction has come on us; an evil fate has overtaken us all. ");
INSERT INTO engBBE_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Death will overtake everyone who comes near, who comes near the House of the Lord: are we all to come to destruction? ");
INSERT INTO engBBE_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","And the Lord said to Aaron, You and your sons and your father's family are to be responsible for all wrongdoing in relation to the holy place: and you and your sons are to be responsible for the errors which come about in your work as priests. ");
INSERT INTO engBBE_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Let your brothers, the family of Levi, come near with you, so that they may be joined with you and be your servants: but you and your sons with you are to go in before the ark of witness. ");
INSERT INTO engBBE_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","They are to do your orders and be responsible for the work of the Tent; but they may not come near the vessels of the holy place or the altar, so that death may not overtake them or you. ");
INSERT INTO engBBE_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","They are to be joined with you in the care of the Tent of meeting, doing whatever is needed for the Tent: and no one of any other family may come near you. ");
INSERT INTO engBBE_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","You are to be responsible for the holy place and the altar, so that wrath may never again come on the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Now, see, I have taken your brothers the Levites from among the children of Israel: they are given to you and to the Lord, to do the work of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","And you and your sons with you are to be responsible as priests for the altar and everything on it, and everything inside the veil; you are to do the work of priests; I have given you your position as priests; and any other man who comes near will be put to death. ");
INSERT INTO engBBE_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","And the Lord said to Aaron, See, I have given into your care my lifted offerings; even all the holy things of the children of Israel I have given to you and to your sons as your right for ever, because you have been marked with the holy oil. ");
INSERT INTO engBBE_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","This is to be yours of the most holy things, out of the fire offerings; every offering of theirs, every meal offering and sin-offering, and every offering which they make on account of error, is to be most holy for you and your sons. ");
INSERT INTO engBBE_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","As most holy things they are to be your food: let every male have them for food; it is to be holy to you. ");
INSERT INTO engBBE_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","And this is yours: the lifted offering which they give and all the wave offerings of the children of Israel I have given to you and to your sons and to your daughters as your right for ever: everyone in your house who is clean may have them for food. ");
INSERT INTO engBBE_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","All the best of the oil and the wine and the grain, the first-fruits of them which they give to the Lord, to you have I given them. ");
INSERT INTO engBBE_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","The earliest produce from their land which they take to the Lord is to be yours; everyone in your house who is clean may have it for his food. ");
INSERT INTO engBBE_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Everything given by oath to the Lord in Israel is to be yours. ");
INSERT INTO engBBE_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","The first birth of every living thing which is offered to the Lord, of man or beast, is to be yours; but for the first sons of man payment is to be made, and for the first young of unclean beasts. ");
INSERT INTO engBBE_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Payment is to be made for these when they are a month old, at the value fixed by you, a price of five shekels by the scale of the holy place, that is, twenty gerahs to the shekel. ");
INSERT INTO engBBE_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","But no such payment may be made for the first birth of an ox or a sheep or a goat; these are holy: their blood is to be dropped on the altar, and their fat burned for an offering made by fire, a sweet smell to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Their flesh is to be yours; like the breast of the wave offering and the right leg, it is to be yours. ");
INSERT INTO engBBE_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","All the lifted offerings of the holy things which the children of Israel give to the Lord, I have given to you and to your sons and to your daughters as a right for ever. This is an agreement made with salt before the Lord, to you and to your seed for ever. ");
INSERT INTO engBBE_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","And the Lord said to Aaron, You will have no heritage in their land, or any part among them; I am your part and your heritage among the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","And to the children of Levi I have given as their heritage all the tenths offered in Israel, as payment for the work they do, the work of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","In future the children of Israel are not to come near the Tent of meeting, so that death may not come to them because of sin. ");
INSERT INTO engBBE_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","But the Levites are to do the work of the Tent of meeting, and be responsible for errors in connection with it: this is a law for ever through all your generations; and among the children of Israel they will have no heritage. ");
INSERT INTO engBBE_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","For the tenths which the children of Israel give as a lifted offering to the Lord I have given to the Levites as their heritage. and so I have said to them, Among the children of Israel they will have no heritage. ");
INSERT INTO engBBE_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Say to the Levites, When you take from the children of Israel the tenth which I have given to you from them as your heritage, a tenth part of that tenth is to be offered as an offering lifted up before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","And this lifted offering is to be put to your credit as if it was grain from the grain-floor and wine from the vines. ");
INSERT INTO engBBE_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","So you are to make an offering lifted up to the Lord from all the tenths which you get from the children of Israel, giving out of it the Lord's lifted offering to Aaron the priest. ");
INSERT INTO engBBE_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","From everything given to you, let the best of it, the holy part of it, be offered as a lifted offering to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Say to them, then, When the best of it is lifted up on high, it is to be put to the account of the Levites as the increase of the grain-floor and of the place where the grapes are crushed. ");
INSERT INTO engBBE_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","It is to be your food, for you and your families in every place: it is your reward for your work in the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","And no sin will be yours on account of it, when the best of it has been lifted up on high; you are not to make a wrong use of the holy things of the children of Israel, so that death may not overtake you. ");
INSERT INTO engBBE_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","And the Lord said to Moses and Aaron, ");
INSERT INTO engBBE_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","This is the rule of the law which the Lord has made, saying, Give orders to the children of Israel to give you a red cow without any mark on her, and on which the yoke has never been put: ");
INSERT INTO engBBE_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Give her to Eleazar the priest and let him take her outside the tent-circle and have her put to death before him. ");
INSERT INTO engBBE_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Then let Eleazar the priest take some of her blood on his finger, shaking the blood seven times in the direction of the front of the Tent of meeting: ");
INSERT INTO engBBE_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","And the cow is to be burned before him, her skin and her flesh and her blood and her waste are to be burned: ");
INSERT INTO engBBE_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Then let the priest take cedar-wood and hyssop and red thread, and put them into the fire where the cow is burning. ");
INSERT INTO engBBE_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","And the priest, after washing his clothing and bathing his body in water, may come back to the tent-circle, and will be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","And he who does the burning is to have his clothing washed and his body bathed in water and be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Then let a man who is clean take the dust of the burned cow and put it outside the tent-circle in a clean place, where it is to be kept for the children of Israel and used in making the water which takes away what is unclean: it is a sin-offering. ");
INSERT INTO engBBE_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","And he who takes up the dust of the burned cow is to have his clothing washed with water and be unclean till evening: this is to be a law for ever, for the children of Israel as well as for the man from another country who is living among them. ");
INSERT INTO engBBE_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Anyone touching a dead body will be unclean for seven days: ");
INSERT INTO engBBE_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","On the third day and on the seventh day he is to make himself clean with the water, and so he will be clean: but if he does not do this on the third day and on the seventh day, he will not be clean. ");
INSERT INTO engBBE_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Anyone touching the body of a dead man without making himself clean in this way, makes the House of the Lord unclean; and that man will be cut off from Israel: because the water was not put on him, he will be unclean; his unclean condition is unchanged. ");
INSERT INTO engBBE_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","This is the law when death comes to a man in his tent: everyone who comes into the tent, and everyone who is in the tent, will be unclean for seven days. ");
INSERT INTO engBBE_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","And every open vessel without a cover fixed on it will be unclean. ");
INSERT INTO engBBE_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","And anyone touching one who has been put to death with the sword in the open country, or the body of one who has come to his end by a natural death, or a man's bone, or the resting-place of a dead body, will be unclean for seven days. ");
INSERT INTO engBBE_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","And for the unclean, they are to take the dust of the burning of the sin-offering, and put flowing water on it in a vessel: ");
INSERT INTO engBBE_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","And a clean person is to take hyssop and put it in the water, shaking it over the tent, and all the vessels, and the people who were there, and over him by whom the bone, or the body of one who has been put to death with the sword, or the body of one who has come to his end by a natural death, or the resting-place was touched. ");
INSERT INTO engBBE_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Let the clean person do this to the unclean on the third day and on the seventh day: and on the seventh day he is to make him clean; and after washing his clothing and bathing himself in water, he will be clean in the evening. ");
INSERT INTO engBBE_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","But the man who, being unclean, does not make himself clean in this way, will be cut off from the meeting of the people, because he has made the holy place of the Lord unclean: the water has not been put on him, he is unclean. ");
INSERT INTO engBBE_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","This is to be a law for them for ever: he who puts the water on the unclean person is to have his clothing washed; and anyone touching the water will be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Anything touched by the unclean person will be unclean; and any person touching it will be unclean till evening. ");
INSERT INTO engBBE_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","In the first month all the children of Israel came into the waste land of Zin, and put up their tents in Kadesh; there death came to Miriam, and they put her body to rest in the earth. ");
INSERT INTO engBBE_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","And there was no water for the people: and they came together against Moses and against Aaron. ");
INSERT INTO engBBE_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","And the people were angry with Moses and said, If only death had overtaken us when our brothers came to their death before the Lord! ");
INSERT INTO engBBE_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Why have you taken the Lord's people into this waste, for death to come to us and to our cattle there? ");
INSERT INTO engBBE_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Why have you made us come out of Egypt into this evil place? This is no place of seed or figs or vines or other fruits, and there is no water for drinking. ");
INSERT INTO engBBE_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Then Moses and Aaron went away from the people to the door of the Tent of meeting; and, falling on their faces there, they saw the glory of the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Take the rod, you and Aaron, your brother, and make all the people come together, and before their eyes give orders to the rock to give out its water; and so make water come out of the rock for them, and give the people and their cattle drink. ");
INSERT INTO engBBE_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","And Moses took the rod from before the Lord as he gave him orders. ");
INSERT INTO engBBE_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Then Moses and Aaron made the people come together in front of the rock, and he said to them, Give ear now, you people whose hearts are turned from the Lord; are we to get water for you out of the rock? ");
INSERT INTO engBBE_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","And lifting up his hand, Moses gave the rock two blows with his rod: and water came streaming out, and the people and their cattle had drink enough. ");
INSERT INTO engBBE_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Then the Lord said to Moses and Aaron, Because you had not enough faith in me to keep my name holy before the children of Israel, you will not take this people into the land which I have given them. ");
INSERT INTO engBBE_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","These are the waters of Meribah; because the children of Israel went against the Lord, and they saw that he was holy among them. ");
INSERT INTO engBBE_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Then Moses sent men from Kadesh to the king of Edom to say to him, Your brother Israel says, You have knowledge of all the things we have been through; ");
INSERT INTO engBBE_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","How our fathers went down into Egypt, and we were living in Egypt for a long time; and the Egyptians were cruel to us and to our fathers: ");
INSERT INTO engBBE_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","And the Lord gave ear to the voice of our cry, and sent an angel and took us out of Egypt: and now we are in Kadesh, a town on the edge of your land; ");
INSERT INTO engBBE_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Let us now go through your land: we will not go into field or vine-garden, or take the water of the springs; we will go by the highway, not turning to the right or to the left, till we have gone past the limits of your land. ");
INSERT INTO engBBE_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","And Edom said, You are not to go through my land, for if you do I will come out against you with the sword. ");
INSERT INTO engBBE_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","And the children of Israel said to him, We will go up by the highway: and if we or our cattle take of your water, we will give you a price for it: only let us go through on our feet, nothing more. ");
INSERT INTO engBBE_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","But he said, You are not to go through. And Edom came out against them in his strength, with a great army. ");
INSERT INTO engBBE_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","So Edom would not let Israel go through his land; and Israel went in another direction. ");
INSERT INTO engBBE_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","And they went on from Kadesh, and came, with all their people, to Mount Hor. ");
INSERT INTO engBBE_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","And at Mount Hor, at the edge of the land of Edom, the Lord said to Moses and Aaron, ");
INSERT INTO engBBE_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aaron will be put to rest with his people; he will not go into the land which I have given to the children of Israel, because you went against my word at the waters of Meribah. ");
INSERT INTO engBBE_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","So take Aaron and Eleazar, his son, up into Mount Hor; ");
INSERT INTO engBBE_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","And take Aaron's robes off him and put them on Eleazar, his son: and death will come to Aaron there, and he will be put to rest with his people. ");
INSERT INTO engBBE_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","So Moses did as the Lord had said, and before the eyes of all the people they went up Mount Hor. ");
INSERT INTO engBBE_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","And Moses took off Aaron's robes, and put them on Eleazar, his son; and there on the top of the mountain death came to Aaron: then Moses and Eleazar came down from the mountain. ");
INSERT INTO engBBE_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","And when the people saw that Aaron was dead, all the children of Israel gave themselves up to weeping for him for thirty days. ");
INSERT INTO engBBE_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","And it came to the ears of the Canaanite, the king of Arad, living in the South, that Israel was coming by the way of Atharim, and he came out against them and took some of them prisoners. ");
INSERT INTO engBBE_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Then Israel made an oath to the Lord, and said, If you will give up this people into my hands, then I will send complete destruction on all their towns. ");
INSERT INTO engBBE_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","And the Lord, in answer to the voice of Israel, gave the Canaanites up to them; and they put them and their towns completely to destruction: and that place was named Hormah. ");
INSERT INTO engBBE_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Then they went on from Mount Hor by the way to the Red Sea, going round the land of Edom: and the spirit of the people was overcome with weariness on the way. ");
INSERT INTO engBBE_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","And crying out against God and against Moses, they said, Why have you taken us out of Egypt to come to our death in the waste land? For there is no bread and no water, and this poor bread is disgusting to us. ");
INSERT INTO engBBE_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Then the Lord sent poison-snakes among the people; and their bites were a cause of death to numbers of the people of Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Then the people came to Moses and said, We have done wrong in crying out against the Lord and against you: make prayer to the Lord to take away the snakes from us. So Moses made prayer for the people. ");
INSERT INTO engBBE_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","And the Lord said to Moses, Make an image of a snake and put it on a rod, and anyone who has been wounded by the snakes, looking on it will be made well. ");
INSERT INTO engBBE_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","So Moses made a snake of brass and put it on a rod; and anyone who had a snakebite, after looking on the snake of brass, was made well. ");
INSERT INTO engBBE_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Then the children of Israel went on and put up their tents in Oboth. ");
INSERT INTO engBBE_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","And journeying on again from Oboth, they put up their tents in Iye-abarim, in the waste land before Moab looking east. ");
INSERT INTO engBBE_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","And moving on from there, they put up their tents in the valley of Zered. ");
INSERT INTO engBBE_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","From there they went on and put up their tents on the other side of the Arnon, which is on the waste land at the edge of the land of the Amorites; for the Arnon is the line of division between Moab and the Amorites: ");
INSERT INTO engBBE_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","As it says in the book of the Wars of the Lord, Vaheb in Suphah, and the valley of the Amon; ");
INSERT INTO engBBE_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","The slope of the valleys going down to the tents of Ar and touching the edge of Moab. ");
INSERT INTO engBBE_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","From there they went on to Beer, the water-spring of which the Lord said to Moses, Make the people come together and I will give them water. ");
INSERT INTO engBBE_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Then Israel gave voice to this song: Come up, O water-spring, let us make a song to it: ");
INSERT INTO engBBE_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","The fountain made by the chiefs, made deep by the great ones of the people, with the law-givers' rod, and with their sticks. Then from the waste land they went on to Mattanah: ");
INSERT INTO engBBE_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","And from Mattanah to Nahaliel: and from Nahaliel to Bamoth: ");
INSERT INTO engBBE_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","And from Bamoth to the valley in the open country of Moab, and to the top of Pisgah looking over Jeshimon. ");
INSERT INTO engBBE_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","And Israel sent men to Sihon, king of the Amorites, saying, ");
INSERT INTO engBBE_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Let me go through your land: we will not go into field or vine-garden, or take the water of the springs; we will go by the highway till we have gone past the limits of your land. ");
INSERT INTO engBBE_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","And Sihon would not let Israel go through his land; but got all his people together and went out against Israel into the waste land, as far as Jahaz, to make war on Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","But Israel overcame him, and took all his land from the Arnon to the Jabbok, as far as the country of the children of Ammon, for the country of the children of Ammon was strongly armed. ");
INSERT INTO engBBE_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","And Israel took all their towns, living in Heshbon and all the towns and small places of the Amorites. ");
INSERT INTO engBBE_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","For Heshbon was the town of Sihon, king of the Amorites, who had made war against an earlier king of Moab and taken from him all his land as far as the Arnon. ");
INSERT INTO engBBE_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","So the makers of wise sayings say, Come to Heshbon, building up the town of Sihon and making it strong: ");
INSERT INTO engBBE_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","For a fire has gone out of Heshbon, a flame from the town of Sihon: for the destruction of Ar in Moab, and the lords of the high places of the Arnon. ");
INSERT INTO engBBE_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Sorrow is yours, O Moab! Destruction is your fate, O people of Chemosh: his sons have gone in flight, and his daughters are prisoners, in the hands of Sihon, king of the Amorites. ");
INSERT INTO engBBE_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","They are wounded with our arrows; destruction has come on Heshbon, even to Dibon; and we have made the land waste as far as Nophah, stretching out to Medeba. ");
INSERT INTO engBBE_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","So Israel put up their tents in the land of the Amorites. ");
INSERT INTO engBBE_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","And Moses sent men secretly to Jazer, and they took its towns, driving out the Amorites who were living there. ");
INSERT INTO engBBE_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Then turning they went up by the way of Bashan; and Og, king of Bashan, went out against them with all his people, to the fight at Edrei. ");
INSERT INTO engBBE_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","And the Lord said to Moses, Have no fear of him: for I have given him up into your hands, with all his people and his land; do to him as you did to Sihon, king of the Amorites, at Heshbon. ");
INSERT INTO engBBE_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","So they overcame him and his sons and his people, driving them all out: and they took his land for their heritage. ");
INSERT INTO engBBE_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Then the children of Israel, journeying on, put up their tents in the lowlands of Moab, on the other side of Jordan at Jericho. ");
INSERT INTO engBBE_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Now Balak, the son of Zippor, saw what Israel had done to the Amorites. ");
INSERT INTO engBBE_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","And in Moab there was great fear of the people, because their numbers were so great: and the feeling of Moab was bitter against the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Then Moab said to the responsible men of Midian, It is clear that this great people will be the destruction of everything round us, making a meal of us as the ox does of the grass of the field. At that time Balak, the son of Zippor, was king of Moab. ");
INSERT INTO engBBE_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","So he sent men to Balaam, son of Beor, at Pethor by the River in the land of the children of his people, saying to him, See, a people has come out of Egypt, covering all the face of the earth, and they have put up their tents opposite to me: ");
INSERT INTO engBBE_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Come now, in answer to my prayer, and put a curse on this people, for they are greater than I: and then I may be strong enough to overcome them and send them out of the land: for it is clear that good comes to him who has your blessing, but he on whom you put your curse is cursed. ");
INSERT INTO engBBE_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","So the responsible men of Moab and Midian went away, taking in their hands rewards for the prophet; and they came to Balaam and said to him what Balak had given them orders to say. ");
INSERT INTO engBBE_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","And he said to them, Take your rest here tonight, and I will give you an answer after hearing what the Lord says; so the chiefs of Moab kept there with Balaam that night. ");
INSERT INTO engBBE_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","And God came to Balaam and said, Who are these men with you? ");
INSERT INTO engBBE_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","And Balaam said to God, Balak, the son of Zippor, king of Moab, has sent them to me, saying, ");
INSERT INTO engBBE_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","See, the people who have come out of Egypt are covering all the earth: now, put a curse on this people for me, so that I may be able to make war on them, driving them out of the land. ");
INSERT INTO engBBE_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","And God said to Balaam, You are not to go with them, or put a curse on this people, for they have my blessing. ");
INSERT INTO engBBE_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","In the morning Balaam got up and said to the chiefs of Balak, Go back to your land, for the Lord will not let me go with you. ");
INSERT INTO engBBE_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","So the chiefs of Moab went back to Balak and said, Balaam will not come with us. ");
INSERT INTO engBBE_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","So Balak sent more chiefs, greater in number and of higher position than the others. ");
INSERT INTO engBBE_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","And they came to Balaam and said, Balak, son of Zippor, says, Let nothing keep you from coming to me: ");
INSERT INTO engBBE_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","For I will give you a place of very great honour, and whatever you say to me I will do; so come, in answer to my prayer, and put a curse on this people. ");
INSERT INTO engBBE_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","But Balaam, in answer; said to the servants of Balak, Even if Balak gave me his house full of silver and gold, it would not be possible for me to do anything more or less than the orders of the Lord my God. ");
INSERT INTO engBBE_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","So take your rest here this night, till I have knowledge what more the Lord has to say to me. ");
INSERT INTO engBBE_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","And that night God came to Balaam and said to him, If these men have come for you, go with them: but do only what I say to you. ");
INSERT INTO engBBE_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","So in the morning Balaam got up and, making his ass ready, went with the chiefs of Moab. ");
INSERT INTO engBBE_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","But God was moved to wrath because he went: and the angel of the Lord took up a position in the road to keep him from his purpose. Now he was seated on his ass, and his two servants were with him. ");
INSERT INTO engBBE_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","And the ass saw the angel of the Lord waiting in the road with his sword in his hand; and turning from the road, the ass went into the field; and Balaam gave the ass blows, to get her back on to the road. ");
INSERT INTO engBBE_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Then the angel of the Lord took up his position in a narrow road through the vine-gardens, with a wall on this side and on that. ");
INSERT INTO engBBE_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","And the ass saw the angel of the Lord, and went near the wall, crushing Balaam's foot against the wall; and he gave her more blows. ");
INSERT INTO engBBE_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Then the angel of the Lord went further, stopping in a narrow place where there was no room for turning to the right or to the left. ");
INSERT INTO engBBE_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","And the ass saw the angel of the Lord and went down on the earth under Balaam; and full of wrath, Balaam gave her hard blows with his stick. ");
INSERT INTO engBBE_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Then the Lord gave the ass the power of talking, and opening her mouth she said to Balaam, What have I done to you that you have given me blows these three times? ");
INSERT INTO engBBE_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","And Balaam said to the ass, You have made me seem foolish: if only I had a sword in my hand I would put you to death. ");
INSERT INTO engBBE_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","And the ass said to Balaam, Am I not your ass upon which you have gone all your life till this day? and have I ever done this to you before? And he said, No. ");
INSERT INTO engBBE_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Then the Lord made Balaam's eyes open, and he saw the angel of the Lord in the way with his sword in his hand: and he went down on his face to the earth. ");
INSERT INTO engBBE_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","And the angel of the Lord said to him, Why have you given your ass blows these three times? See, I have come out against you to keep you back, because your purpose is not pleasing to me. ");
INSERT INTO engBBE_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","And the ass saw me, turning to one side from me three times: if she had not gone to one side, I would certainly have put you to death and kept her safe. ");
INSERT INTO engBBE_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","And Balaam said to the angel of the Lord, I have done wrong, for I did not see that you were in the way against me: but now, if it is evil in your eyes, I will go back again. ");
INSERT INTO engBBE_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","And the angel of the Lord said to Balaam, Go with the men; but say only what I give you to say. Then Balaam went on with the chiefs of Balak. ");
INSERT INTO engBBE_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Now Balak, hearing that Balaam had come, went to the chief town of Moab, on the edge of the Arnon, in the farthest part of the land, for the purpose of meeting him. ");
INSERT INTO engBBE_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","And Balak said to Balaam, Did I not send to you, requesting you with all my heart to come to me? why did you not come? am I not able to give you a place of honour? ");
INSERT INTO engBBE_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Then Balaam said to Balak, Now I have come to you; but have I power to say anything? Only what God puts into my mouth may I say. ");
INSERT INTO engBBE_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","And Balaam went with Balak to Kiriath-huzoth. ");
INSERT INTO engBBE_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","And Balak made offerings of oxen and sheep, and sent to Balaam and the chiefs who were with him. ");
INSERT INTO engBBE_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","And in the morning Balak took Balaam up to the high places of Baal, and from there he was able to see the outer limits of the people. ");
INSERT INTO engBBE_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","And Balaam said to Balak, Make me here seven altars and get ready seven oxen and seven male sheep. ");
INSERT INTO engBBE_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","And Balak did as Balaam had said; and Balak and Balaam made an offering on every altar of an ox and a male sheep. ");
INSERT INTO engBBE_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Then Balaam said to Balak, Take your place by your burned offering, and I will go and see if the Lord comes to me: and I will give you word of whatever he says to me. And he went to an open place on a hill. ");
INSERT INTO engBBE_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","And God came to Balaam, and Balaam said to him, I have made ready seven altars, offering an ox and a male sheep on every altar. ");
INSERT INTO engBBE_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","And the Lord put words in Balaam's mouth, and said, Go back to Balak, and this is what you are to say. ");
INSERT INTO engBBE_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","So he went back to him where he was waiting by his burned offering with all the chiefs of Moab. ");
INSERT INTO engBBE_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","And in the words which the Lord had given him he said, From Aram Balak has sent for me, the king of Moab from the mountains of the East: come, put curses on Jacob for me and be angry with Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","How may I put curses on him who is not cursed by God? how may I be angry with him with whom the Lord is not angry? ");
INSERT INTO engBBE_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","From the top of the rocks I see him, looking down on him from the hills: it is a people made separate, not to be numbered among the nations. ");
INSERT INTO engBBE_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Who is able to take the measure of the dust of Jacob or the number of the thousands of Israel? May my death be the death of the upright and my last end like his! ");
INSERT INTO engBBE_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Then Balak said to Balaam, What have you done to me? I sent for you so that my haters might be cursed, and see, you have given them a blessing. ");
INSERT INTO engBBE_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","And in answer he said, Am I not ordered to say only what the Lord puts into my mouth? ");
INSERT INTO engBBE_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","And Balak said to him, Come with me now into another place from which you will not be able to see them all, but only the outskirts of them; and you will send curses on them from there. ");
INSERT INTO engBBE_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","So he took him into the country of Zophim, to the top of Pisgah, and there they made seven altars, offering an ox and a male sheep on every altar. ");
INSERT INTO engBBE_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Then he said to Balak, Take your place here by your burned offering, while I go over there to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","And the Lord came to Balaam, and put words in his mouth, and said, Go back to Balak, and this is what you are to say. ");
INSERT INTO engBBE_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","So he came to him where he was waiting by his burned offering with the chiefs of Moab by his side. And Balak said to him, What has the Lord said? ");
INSERT INTO engBBE_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","And in the words which the Lord had given him he said, Up! Balak, and give ear; give attention to me, O son of Zippor: ");
INSERT INTO engBBE_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","God is not a man, to say what is false; or the son of man, that his purpose may be changed: what he has said, will he not do? and will he not give effect to the words of his mouth? ");
INSERT INTO engBBE_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","See, I have had orders to give blessing: and he has given a blessing which I have no power to take away. ");
INSERT INTO engBBE_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","He has seen no evil in Jacob or wrongdoing in Israel: the Lord his God is with him, and the glad cry of a king is among them. ");
INSERT INTO engBBE_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","It is God who has taken them out of Egypt; his horns are like those of the mountain ox. ");
INSERT INTO engBBE_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","No evil power has effect against Jacob, no secret arts against Israel; at the right time it will be said of Jacob and of Israel, See what God has done! ");
INSERT INTO engBBE_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","See, Israel comes up like a she-lion, lifting himself up like a lion: he will take no rest till he has made a meal of those he has overcome, drinking the blood of those he has put to death. ");
INSERT INTO engBBE_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Then Balak said to Balaam, If you will not put a curse on them, at all events do not give them a blessing. ");
INSERT INTO engBBE_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","But Balaam in answer said to Balak, Did I not say to you, I may only do what the Lord says? ");
INSERT INTO engBBE_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Then Balak said to Balaam, Come now, I will take you to another place; it may be that God will let you put a curse on them from there. ");
INSERT INTO engBBE_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","So Balak took Balaam to the top of Peor, looking down over the waste land. ");
INSERT INTO engBBE_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","And Balaam said to Balak, Make me seven altars here and get seven oxen and seven male sheep ready for me. ");
INSERT INTO engBBE_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","And Balak did as Balaam said, offering an ox and a male sheep on every altar. ");
INSERT INTO engBBE_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Now when Balaam saw that it was the Lord's pleasure to give his blessing to Israel, he did not, as at other times, make use of secret arts, but turning his face to the waste land, ");
INSERT INTO engBBE_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","And lifting up his eyes, he saw Israel there, with their tents in the order of their tribes: and the spirit of God came on him. ");
INSERT INTO engBBE_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","And moved by the spirit, he said, These are the words of Balaam, son of Beor, the words of the man whose eyes are open: ");
INSERT INTO engBBE_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","He says, whose ears are open to the words of God, who has seen the vision of the Ruler of all, falling down, but having his eyes open: ");
INSERT INTO engBBE_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","How fair are your tents, O Jacob, your houses, O Israel! ");
INSERT INTO engBBE_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","They are stretched out like valleys, like gardens by the riverside, like flowering trees planted by the Lord, like cedar-trees by the waters. ");
INSERT INTO engBBE_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Peoples will be in fear before his strength, his arm will be on great nations: his king will be higher than Agag, and his kingdom made great in honour. ");
INSERT INTO engBBE_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","It is God who has taken him out of Egypt; his horns are like those of the mountain ox; the nations warring against him will be his food, their bones will be broken, they will be wounded with his arrows. ");
INSERT INTO engBBE_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","He took his sleep stretched out like a lion, and like a she-lion: by whom will his rest be broken? May a blessing be on everyone who gives you blessing, and a curse on everyone by whom you are cursed. ");
INSERT INTO engBBE_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Then Balak was full of wrath against Balaam, and angrily waving his hands he said to Balaam, I sent for you so that those who are against me might be cursed, but now, see, three times you have given them a blessing. ");
INSERT INTO engBBE_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Go back quickly to the place you came from: it was my purpose to give you a place of honour, but now the Lord has kept you back from honour. ");
INSERT INTO engBBE_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Then Balaam said to Balak, Did I not say to the men you sent to me, ");
INSERT INTO engBBE_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Even if Balak gave me his house full of silver and gold, it would not be possible for me to go outside the orders of the Lord, doing good or evil at the impulse of my mind; whatever the Lord says I will say? ");
INSERT INTO engBBE_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","So now I will go back to my people: but first let me make clear to you what this people will do to your people in days to come. ");
INSERT INTO engBBE_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Then he went on with his story and said, These are the words of Balaam, the son of Beor, the words of him whose eyes are open: ");
INSERT INTO engBBE_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","He says, whose ear is open to the words of God, who has knowledge of the Most High, who has seen the vision of the Ruler of all, falling down and having his eyes open: ");
INSERT INTO engBBE_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","I see him, but not now: looking on him, but not near: a star will come out of Jacob, and a rod of authority out of Israel, sending destruction to the farthest limits of Moab and on the head of all the sons of Sheth. ");
INSERT INTO engBBE_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom will be his heritage, and he will put an end to the last of the people of Seir. ");
INSERT INTO engBBE_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","And Israel will go on in strength, and Jacob will have rule over his haters. ");
INSERT INTO engBBE_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Then, turning his eyes to Amalek, he went on with his story and said, Amalek was the first of the nations, but his part will be destruction for ever. ");
INSERT INTO engBBE_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","And looking on the Kenites he went on with his story and said, Strong is your living-place, and your secret place is safe in the rock. ");
INSERT INTO engBBE_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","But still the Kenites will be wasted, till Asshur takes you away prisoner. ");
INSERT INTO engBBE_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Then he went on with his story and said, But who may keep his life when God does this? ");
INSERT INTO engBBE_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","But ships will come from the direction of Kittim, troubling Asshur and troubling Eber, and like the others their fate will be destruction. ");
INSERT INTO engBBE_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Then Balaam got up and went back to his place: and Balak went away. ");
INSERT INTO engBBE_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Now when Israel was living in Shittim the people became false to the Lord, doing evil with the daughters of Moab: ");
INSERT INTO engBBE_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","For they sent for the people to be present at the offerings made to their gods; and the people took part in their feasts and gave honour to their gods. ");
INSERT INTO engBBE_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","So Israel had relations with the women of Moab in honour of the Baal of Peor: and the Lord was moved to wrath against Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Then the Lord said to Moses, Take all the chiefs of the people, hanging them up in the sun before the Lord, so that the wrath of the Lord may be turned from Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","So Moses said to the judges of Israel, Let everyone put to death those of his men who have had relations with the women of Moab in honour of the Baal of Peor. ");
INSERT INTO engBBE_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Then one of the children of Israel came to his brothers, taking with him a woman of Midian, before the eyes of Moses and all the meeting of the people, while they were weeping at the door of the Tent of meeting. ");
INSERT INTO engBBE_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","And Phinehas, the son of Eleazar, the son of Aaron the priest, seeing it, got up from among the people and took a spear in his hand, ");
INSERT INTO engBBE_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","And went after the man of Israel into the tent, driving the spear through the two of them, through the man of Israel and through the stomach of the woman. So the disease was stopped among the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","But twenty-four thousand of them had come to their death by the disease. ");
INSERT INTO engBBE_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Through Phinehas, and because of his passion for my honour, my wrath has been turned away from the children of Israel, so that I have not sent destruction on them all in my wrath. ");
INSERT INTO engBBE_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","So say to them that I will make with him an agreement of peace: ");
INSERT INTO engBBE_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","And by this agreement, he and his sons after him have the right to be priests for ever; because, by his care for the honour of his God, he took away the sin of the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Now the man of Israel who was put to death with the woman of Midian was Zimri, the son of Salu, a chief of one of the families of the Simeonites. ");
INSERT INTO engBBE_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","And the woman of Midian who was put to death was Cozbi, the daughter of Zur; he was the head of a family in Midian. ");
INSERT INTO engBBE_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Then the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Take up arms against the Midianites and overcome them; ");
INSERT INTO engBBE_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","For they are a danger to you with their false ways, causing sin to come on you in the question of Peor, and because of Cozbi, their sister, the daughter of the chief of Midian, who was put to death at the time of the disease which came on you because of Peor. ");
INSERT INTO engBBE_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Now after the disease was over, the Lord said to Moses and Eleazar, the son of Aaron the priest, ");
INSERT INTO engBBE_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Let all the children of Israel be numbered, by the names of their fathers' families, all those of twenty years old and over who are able to go to war in Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","So Moses and Eleazar the priest gave them the order in the lowlands of Moab by Jordan at Jericho, saying, ");
INSERT INTO engBBE_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Let all the people of twenty years old and over be numbered, as the Lord has given orders to Moses and the children of Israel who have come out of Egypt. ");
INSERT INTO engBBE_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Reuben, the first son of Israel: the sons of Reuben by their families: of Hanoch, the family of the Hanochites: of Pallu, the family of the Palluites: ");
INSERT INTO engBBE_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Of Hezron, the family of the Hezronites: of Carmi, the family of the Carmites. ");
INSERT INTO engBBE_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","These are the families of the Reubenites: their number was forty-three thousand, seven hundred and thirty. ");
INSERT INTO engBBE_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","And the sons of Pallu, Eliab ");
INSERT INTO engBBE_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","And the sons of Eliab: Nemuel and Dathan and Abiram. These are the same Dathan and Abiram who had a place in the meeting of the people, who together with Korah made an outcry against Moses and Aaron and against the Lord: ");
INSERT INTO engBBE_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","And they went down into the open mouth of the earth, together with Korah, when death overtook him and all his band; at the time when two hundred and fifty men were burned in the fire, and they became a sign. ");
INSERT INTO engBBE_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","But death did not overtake the sons of Korah. ");
INSERT INTO engBBE_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","The sons of Simeon by their families: of Nemuel, the family of the Nemuelites: of Jamin, the family of the Jaminites: of Jachin, the family of the Jachinites: ");
INSERT INTO engBBE_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Of Zerah, the family of the Zerahites: of Shaul, the family of the Shaulites. ");
INSERT INTO engBBE_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","These are the families of the Simeonites, twenty-two thousand, two hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","The sons of Gad by their families: of Zephon, the family of the Zephonites: of Haggi, the family of the Haggites: of Shuni, the family of the Shunites: ");
INSERT INTO engBBE_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Of Ozni, the family of the Oznites: of Eri, the family of the Erites: ");
INSERT INTO engBBE_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Of Arod, the family of the Arodites: of Areli, the family of the Arelites. ");
INSERT INTO engBBE_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","These are the families of the sons of Gad as they were numbered, forty thousand, five hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","The sons of Judah, Er and Onan: and Er and Onan had come to their death in the land of Canaan. ");
INSERT INTO engBBE_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","And the sons of Judah by their families were: of Shelah, the family of the Shelahites: of Perez, the family of the Perezites: of Zerah, the family of the Zerahites. ");
INSERT INTO engBBE_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","And the sons of Perez were: of Hezron, the family of the Hezronites: of Hamul, the family of the Hamulites. ");
INSERT INTO engBBE_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","These are the families of Judah as they were numbered, seventy-six thousand, five hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","The sons of Issachar by their families: of Tola, the family of the Tolaites: of Puvah, the family of the Punites: ");
INSERT INTO engBBE_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Of Jashub, the family of the Jashubites: of Shimron, the family of the Shimronites. ");
INSERT INTO engBBE_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","These are the families of Issachar, as they were numbered, sixty-four thousand, three hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","The sons of Zebulun by their families: of Sered, the family of the Seredites: of Elon, the family of the Elonites: of Jahleel, the family of the Jahleelites. ");
INSERT INTO engBBE_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","These are the families of the Zebulunites as they were numbered, sixty thousand, five hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","The sons of Joseph by their families: Manasseh and Ephraim. ");
INSERT INTO engBBE_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","The sons of Manasseh: of Machir, the family of the Machirites: and Machir was the father of Gilead: of Gilead, the family of the Gileadites. ");
INSERT INTO engBBE_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","These are the sons of Gilead: of Iezer, the family of the Iezerites: of Helek, the family of the Helekites: ");
INSERT INTO engBBE_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","And of Asriel, the family of the Asrielites: and of Shechem, the family of the Shechemites: ");
INSERT INTO engBBE_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","And of Shemida, the family of the Shemidaites: and of Hepher, the family of the Hepherites. ");
INSERT INTO engBBE_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","And Zelophehad, the son of Hepher, had no sons, but only daughters, and the names of the daughters of Zelophehad were Mahlah, and Noah, Hoglah, Milcah, and Tirzah. ");
INSERT INTO engBBE_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","These are the families of Manasseh; and those who were numbered of them were fifty-two thousand, seven hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","These are the sons of Ephraim by their families: of Shuthelah, the family of the Shuthelahites: of Becher, the family of the Becherites: of Tahan, the family of the Tahanites. ");
INSERT INTO engBBE_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","And these are the sons of Shuthelah: of Eran, the family of the Eranites: ");
INSERT INTO engBBE_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","These are the families of Ephraim as they were numbered, thirty-two thousand, five hundred. These are the sons of Joseph by their families. ");
INSERT INTO engBBE_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","The sons of Benjamin by their families: of Bela, the family of the Belaites: of Ashbel, the family of the Ashbelites: of Ahiram, the family of the Ahiramites: ");
INSERT INTO engBBE_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Of Shephupham, the family of the Shuphamites: and of Hupham, the family of the Huphamites. ");
INSERT INTO engBBE_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","And the sons of Bela were Ard and Naaman: of Ard, the family of the Ardites: of Naaman, the family of the Naamites. ");
INSERT INTO engBBE_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","These are the sons of Benjamin by their families: and those who were numbered of them were forty-five thousand, six hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","These are the sons of Dan by their families: of Shuham, the family of the Shuhamites. These are the families of Dan by their families. ");
INSERT INTO engBBE_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","All the families of the Shuhamites, as they were numbered, were sixty-four thousand, four hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","The sons of Asher by their families: of Imnah, the family of the Imnites: of Ishvi, the family of the Ishvites: of Beriah, the family of the Beriites. ");
INSERT INTO engBBE_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Of the sons of Beriah: of Heber, the family of the Heberites: of Malchiel, the family of the Malchielites: ");
INSERT INTO engBBE_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","And the name of the daughter of Asher was Serah. ");
INSERT INTO engBBE_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","These are the families of the sons of Asher as they were numbered, fifty-three thousand, four hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","The sons of Naphtali by their families: of Jahzeel, the family of the Jahzeelites: of Guni, the family of the Gunites: ");
INSERT INTO engBBE_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Of Jezer, the family of the Jezerites: of Shillem, the family of the Shillemites. ");
INSERT INTO engBBE_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","These are the families of Naphtali by their families: and those who were numbered of them were forty-five thousand, four hundred. ");
INSERT INTO engBBE_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Those who were numbered of the children of Israel were six hundred and one thousand, seven hundred and thirty. ");
INSERT INTO engBBE_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Let there be a division of the land among these, for their heritage, in relation to the number of names. ");
INSERT INTO engBBE_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","To those families who are more in number, give a greater heritage; to those who are less in number, a smaller part: to every one let the heritage be given in relation to the number in his family. ");
INSERT INTO engBBE_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","But let the distribution of the land be made by the decision of the Lord: by the names of the tribes of their fathers let their heritage be given them. ");
INSERT INTO engBBE_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","As it is ordered by the decision of the Lord, let distribution be made between those who are more in number and those who are less. ");
INSERT INTO engBBE_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","These were those of the Levites who were numbered by their families: of Gershon, the family of the Gershonites: of Kohath, the family of the Kohathites: of Merari, the family of the Merarites. ");
INSERT INTO engBBE_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","These are the families of Levi: the family of the Libnites, the family of the Hebronites, the family of the Mahlites, the family of the Mushites, the family of the Korahites. And Kohath was the father of Amram. ");
INSERT INTO engBBE_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amram's wife was Jochebed, the daughter of Levi, whom he had in Egypt: by Amram she had Moses and Aaron and their sister Miriam. ");
INSERT INTO engBBE_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aaron's sons were Nadab and Abihu, Eleazar and Ithamar. ");
INSERT INTO engBBE_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Death overtook Nadab and Abihu when they made an offering of strange fire before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Of these, twenty-three thousand males, from one month old and over, were numbered: they were not numbered with the rest of the children of Israel, for they had no heritage among the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","All these were numbered by Moses and Eleazar the priest when the children of Israel were numbered in the lowlands of Moab by the Jordan at Jericho. ");
INSERT INTO engBBE_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","But among all these was not one of those numbered by Moses and Aaron the priest when the children of Israel were numbered in the waste land of Sinai. ");
INSERT INTO engBBE_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","For the Lord had said of them, Death will certainly overtake them in the waste land. And of them all, only Caleb, the son of Jephunneh, and Joshua, the son of Nun, were still living. ");
INSERT INTO engBBE_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Then the daughters of Zelophehad, the son of Hepher, the son of Gilead, the son of Machir, the son of Manasseh, of the families of Manasseh, the son of Joseph, came forward: their names are Mahlah, Noah, and Hoglah, and Milcah, and Tirzah. ");
INSERT INTO engBBE_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","They came before Moses and Eleazar the priest and the chiefs and all the people at the door of the Tent of meeting, and said, ");
INSERT INTO engBBE_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Death overtook our father in the waste land; he was not among those who were banded together with Korah against the Lord; but death came to him in his sin; and he had no sons. ");
INSERT INTO engBBE_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Why is the name of our father to be taken away from among his family, because he had no son? Give us a heritage among our father's brothers. ");
INSERT INTO engBBE_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","So Moses put their cause before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","What the daughters of Zelophehad say is right: certainly you are to give them a heritage among their father's brothers: and let the property which would have been their father's go to them. ");
INSERT INTO engBBE_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","And say to the children of Israel, If a man has no son at the time of his death, let his heritage go to his daughter. ");
INSERT INTO engBBE_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","And if he has no daughter, then give his heritage to his brothers. ");
INSERT INTO engBBE_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","And if he has no brothers, then give his heritage to his father's brothers. ");
INSERT INTO engBBE_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","And if his father has no brothers, then give it to his nearest relation in the family, as his heritage: this is to be a decision made by law for the children of Israel, as the Lord gave orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","And the Lord said to Moses, Go up into this mountain of Abarim so that you may see the land which I have given to the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","And when you have seen it, you will be put to rest with your people, as your brother Aaron was: ");
INSERT INTO engBBE_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Because in the waste land of Zin, when the people were angry, you and he went against my word and did not keep my name holy before their eyes, at the waters. (These are the waters of Meribah in Kadesh in the waste land of Zin.) ");
INSERT INTO engBBE_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Then Moses said to the Lord, ");
INSERT INTO engBBE_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Let the Lord, the God of the spirits of all flesh, put a man at the head of this people, ");
INSERT INTO engBBE_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","To go out and come in before them and be their guide; so that the people of the Lord may not be like sheep without a keeper. ");
INSERT INTO engBBE_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","And the Lord said to Moses, Take Joshua, the son of Nun, a man in whom is the spirit, and put your hand on him; ");
INSERT INTO engBBE_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","And take him before Eleazar the priest and all the meeting of the people, and give him his orders before their eyes. ");
INSERT INTO engBBE_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","And put your honour on him, so that all the children of Israel may be under his authority. ");
INSERT INTO engBBE_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","He will take his place before Eleazar the priest, so that he may get directions from the Lord for him, with the Urim: at his word they will go out, and at his word they will come in, he and all the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","So Moses did as the Lord said: he took Joshua and put him before Eleazar the priest and the meeting of the people: ");
INSERT INTO engBBE_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","And he put his hands on him and gave him his orders, as the Lord had said by Moses. ");
INSERT INTO engBBE_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Give orders to the children of Israel and say to them, Let it be your care to give me my offerings at their regular times, the food of the offerings made by fire to me for a sweet smell. ");
INSERT INTO engBBE_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Say to them, This is the offering made by fire which you are to give to the Lord; he-lambs of the first year without any mark, two every day as a regular burned offering. ");
INSERT INTO engBBE_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Let one be offered in the morning, and the other at evening; ");
INSERT INTO engBBE_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","And the tenth part of an ephah of the best meal for a meal offering mixed with the fourth part of a hin of clear oil. ");
INSERT INTO engBBE_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","It is a regular burned offering, as it was ordered in Mount Sinai, for a sweet smell, an offering made by fire to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","And for its drink offering take the fourth part of a hin for one lamb: in the holy place let the wine be drained out for a drink offering for the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Let the other lamb be offered at evening; like the meal offering of the morning and its drink offering, let it be offered as an offering made by fire for a sweet smell to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","And on the Sabbath day, two he-lambs of the first year, without any mark, and two tenth parts of the best meal for a meal offering mixed with oil, and its drink offering: ");
INSERT INTO engBBE_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","This is the burned offering for every Sabbath day, in addition to the regular burned offering, and its drink offering. ");
INSERT INTO engBBE_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","And on the first day of every month you are to give a burned offering to the Lord; two oxen, one male sheep, and seven he-lambs of the first year, without any mark; ");
INSERT INTO engBBE_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","And three tenth parts of the best meal for a meal offering mixed with oil, for every ox; and two tenth parts of the best meal for a meal offering mixed with oil, for the one sheep; ");
INSERT INTO engBBE_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","And a separate tenth part of the best meal mixed with oil for a meal offering for every lamb; for a burned offering of a sweet smell, an offering made by fire to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","And their drink offerings are to be half a hin of wine for an ox, and the third part of a hin for a male sheep, and the fourth part of a hin for a lamb: this is the burned offering for every month through all the months of the year. ");
INSERT INTO engBBE_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","And one he-goat for a sin-offering to the Lord; it is to be offered in addition to the regular burned offering and its drink offering. ");
INSERT INTO engBBE_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","And in the first month, on the fourteenth day of the month, is the Lord's Passover. ");
INSERT INTO engBBE_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","On the fifteenth day of this month there is to be a feast; for seven days let your food be unleavened cakes. ");
INSERT INTO engBBE_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","On the first day there is to be a holy meeting: you may do no sort of field-work: ");
INSERT INTO engBBE_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","And you are to give an offering made by fire, a burned offering to the Lord; two oxen, one male sheep, and seven he-lambs of the first year, without any mark: ");
INSERT INTO engBBE_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","And their meal offering, the best meal mixed with oil: let three tenth parts of an ephah be offered for an ox and two tenth parts for a male sheep; ");
INSERT INTO engBBE_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","And a separate tenth part for every one of the seven lambs; ");
INSERT INTO engBBE_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","And one he-goat for a sin-offering to take away your sin. ");
INSERT INTO engBBE_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","These are to be offered in addition to the morning burned offering, which is a regular burned offering at all times. ");
INSERT INTO engBBE_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","In this way, every day for seven days, give the food of the offering made by fire, a sweet smell to the Lord: it is to be offered in addition to the regular burned offering, and its drink offering. ");
INSERT INTO engBBE_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Then on the seventh day there will be a holy meeting; you may do no field-work. ");
INSERT INTO engBBE_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","And at the time of the first-fruits, when you give an offering of new meal to the Lord at your feast of weeks, there is to be a holy meeting: you may do no field-work: ");
INSERT INTO engBBE_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","And give a burned offering for a sweet smell to the Lord; two oxen, one male sheep, and seven he-lambs of the first year; ");
INSERT INTO engBBE_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","And their meal offering, the best meal mixed with oil, three tenth parts for an ox, two tenth parts for a male sheep, ");
INSERT INTO engBBE_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","And a separate tenth part for every one of the seven lambs; ");
INSERT INTO engBBE_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","And one he-goat to take away your sin. ");
INSERT INTO engBBE_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","These are in addition to the regular burned offering and its meal offering; take care that they are without any mark, and let them be offered with their drink offerings. ");
INSERT INTO engBBE_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","In the seventh month, on the first day of the month, let there be a holy meeting; on it you may do no field-work; let the day be marked by the blowing of horns; ");
INSERT INTO engBBE_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","And give to the Lord a burned offering for a sweet smell; one ox, one male sheep, seven he-lambs of the first year, without any mark on them: ");
INSERT INTO engBBE_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","And their meal offering, the best meal mixed with oil, three tenth parts for an ox, two tenth parts for a male sheep, ");
INSERT INTO engBBE_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","And a separate tenth part for every one of the seven lambs; ");
INSERT INTO engBBE_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","And one he-goat for a sin-offering, to take away your sin: ");
INSERT INTO engBBE_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","In addition to the burned offering of the new moon, and its meal offering, and the regular burned offering and its meal offering, and their drink offerings, as they are ordered, for a sweet smell, an offering made by fire to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","And on the tenth day of this seventh month there will be a holy meeting; keep yourselves from pleasure, and do no sort of work; ");
INSERT INTO engBBE_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","And give to the Lord a burned offering for a sweet smell; one ox, one male sheep, seven he-lambs of the first year: only those without any mark on them may be used: ");
INSERT INTO engBBE_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","And their meal offering, the best meal mixed with oil, three tenth parts for an ox, two tenth parts for a male sheep, ");
INSERT INTO engBBE_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","A separate tenth part for every one of the seven lambs; ");
INSERT INTO engBBE_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","One he-goat for a sin-offering; in addition to the offering for taking away your sin, and the regular burned offering and its meal offering, and their drink offerings. ");
INSERT INTO engBBE_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","And on the fifteenth day of the seventh month let there be a holy meeting; do no field-work, and keep a feast to the Lord for seven days; ");
INSERT INTO engBBE_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","And give a burned offering, an offering made by fire of a sweet smell to the Lord, thirteen oxen, two male sheep, fourteen he-lambs of the first year, all without any mark on them; ");
INSERT INTO engBBE_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","And their meal offering, the best meal mixed with oil, three tenth parts for every one of the thirteen oxen, two tenth parts for every male sheep, ");
INSERT INTO engBBE_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","And a separate tenth part for every one of the fourteen lambs; ");
INSERT INTO engBBE_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","And one he-goat for a sin-offering; in addition to the regular burned offering, and its meal offering, and its drink offering. ");
INSERT INTO engBBE_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","On the second day of the feast give an offering of twelve oxen, two male sheep, fourteen he-lambs of the first year, without any mark on them; ");
INSERT INTO engBBE_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","And their meal offering and their drink offerings for the oxen and the sheep and the lambs, in relation to their number, as it is ordered: ");
INSERT INTO engBBE_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","And one he-goat for a sin-offering in addition to the regular burned offering, and its meal offering, and their drink offerings. ");
INSERT INTO engBBE_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","And on the third day eleven oxen, two male sheep, fourteen he-lambs of the first year, without any mark; ");
INSERT INTO engBBE_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","And their meal offering and drink offerings for the oxen, for the male sheep, and for the lambs, in relation to their number, as it is ordered: ");
INSERT INTO engBBE_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","And one he-goat for a sin-offering; in addition to the regular burned offering, and its meal offering, and its drink offering. ");
INSERT INTO engBBE_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","And on the fourth day ten oxen, two male sheep, fourteen he-lambs of the first year, without any mark: ");
INSERT INTO engBBE_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","And their meal offering and their drink offerings for the oxen, for the male sheep, and for the lambs, in relation to their number, as it is ordered. ");
INSERT INTO engBBE_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","And one he-goat for a sin-offering; in addition to the regular burned offering, and its meal offering, and its drink offering. ");
INSERT INTO engBBE_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","And on the fifth day nine oxen, two male sheep, fourteen he-lambs of the first year, without any mark: ");
INSERT INTO engBBE_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","And their meal offering and their drink offerings for the oxen, for the male sheep, and for the lambs, in relation to their number, as it is ordered: ");
INSERT INTO engBBE_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","And one he-goat for a sin-offering; in addition to the regular burned offering, and its meal offering, and its drink offering. ");
INSERT INTO engBBE_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","And on the sixth day eight oxen, two male sheep, fourteen he-lambs of the first year, without any mark: ");
INSERT INTO engBBE_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","And their meal offering and their drink offerings for the oxen, for the male sheep, and for the lambs, in relation to their number, as it is ordered: ");
INSERT INTO engBBE_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","And one he-goat for a sin-offering; in addition to the regular burned offering, its meal offering, and its drink offerings. ");
INSERT INTO engBBE_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","And on the seventh day seven oxen, two male sheep, fourteen he-lambs of the first year, without any mark: ");
INSERT INTO engBBE_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","And their meal offering and their drink offerings for the oxen, for the male sheep, and for the lambs, in relation to their number, as it is ordered: ");
INSERT INTO engBBE_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","And one he-goat for a sin-offering; in addition to the regular burned offering, its meal offering, and its drink offering. ");
INSERT INTO engBBE_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","On the eighth day let there be a holy meeting: you may do no field-work; ");
INSERT INTO engBBE_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","And give a burned offering, an offering made by fire of a sweet smell to the Lord: one ox, one male sheep, seven he-lambs of the first year, without any mark: ");
INSERT INTO engBBE_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","With the meal offering and the drink offerings for the ox, the male sheep, and the lambs, in relation to their number, as it is ordered: ");
INSERT INTO engBBE_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","And one he-goat for a sin-offering; in addition to the regular burned offering, and its meal offering, and its drink offering. ");
INSERT INTO engBBE_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","These are the offerings which you are to give to the Lord at your regular feasts, in addition to the offerings for an oath, and the free offerings you give, for your burned offerings and your drink offerings and your peace-offerings. ");
INSERT INTO engBBE_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","So Moses gave the children of Israel all these directions as the Lord had given him orders. ");
INSERT INTO engBBE_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","And Moses said to the heads of the tribes of the children of Israel, This is the order of the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","When a man takes an oath to the Lord, or gives an undertaking having the force of an oath, let him not go back from his word, but let him do whatever he has said he will do. ");
INSERT INTO engBBE_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","If a woman, being young and under the authority of her father, takes an oath to the Lord or gives an undertaking; ");
INSERT INTO engBBE_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","If her father, hearing of her oath or the undertaking she has given, says nothing to her, then all her oaths and every undertaking she has given will have force. ");
INSERT INTO engBBE_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","But if her father, hearing of it, makes her take back her word, then the oaths or the undertakings she has given will have no force; and she will have forgiveness from the Lord, because her oath was broken by her father. ");
INSERT INTO engBBE_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","And if she is married to a husband at the time when she is under an oath or an undertaking given without thought; ");
INSERT INTO engBBE_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","If her husband, hearing of it, says nothing to her at the time, then the oaths she made and the undertakings she gave will have force. ");
INSERT INTO engBBE_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","But if her husband, hearing of it, makes her take it back, then the oath she made and the undertaking she gave without thought will have no force or effect, and she will have the Lord's forgiveness. ");
INSERT INTO engBBE_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","But an oath made by a widow or one who is no longer married to her husband, and every undertaking she has given, will have force. ");
INSERT INTO engBBE_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","If she made an oath while she was under the authority of her husband, ");
INSERT INTO engBBE_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","And her husband, hearing of it, said nothing to her and did not put a stop to it, then all her oaths and every undertaking she gave will have force. ");
INSERT INTO engBBE_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","But if her husband, on hearing of it, made them without force or effect, then whatever she has said about her oaths or her undertaking has no force: her husband has made them without effect, and she will have the Lord's forgiveness. ");
INSERT INTO engBBE_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Every oath, and every undertaking which she gives, to keep herself from pleasure, may be supported or broken by her husband. ");
INSERT INTO engBBE_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","But if the days go on, and her husband says nothing whatever to her, then he is giving the support of his authority to her oaths and undertakings, because at the time of hearing them he said nothing to her. ");
INSERT INTO engBBE_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","But if at some time after hearing of them, he makes them without force, then he is responsible for her wrongdoing. ");
INSERT INTO engBBE_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","These are the laws which the Lord gave Moses in relation to a man and his wife, or a father and a young daughter who is under his authority. ");
INSERT INTO engBBE_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Then the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Give the Midianites punishment for the wrong they did to the children of Israel: and after that you will go to rest with your people. ");
INSERT INTO engBBE_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","So Moses said to the people, Let men from among you be armed for war to put into effect against Midian the Lord's punishment on them. ");
INSERT INTO engBBE_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","From every tribe of Israel send a thousand to the war. ");
INSERT INTO engBBE_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","So from the thousands of Israel a thousand were taken from every tribe, twelve thousand men armed for war. ");
INSERT INTO engBBE_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","And Moses sent them out to war, a thousand from every tribe, and with them Phinehas, the son of Eleazar the priest, taking in his hands the vessels of the holy place and the horns for sounding the note of war. ");
INSERT INTO engBBE_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","And they made war on Midian, as the Lord gave orders to Moses; and they put to death every male. ");
INSERT INTO engBBE_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","They put the kings of Midian to death with the rest, Evi and Reken and Zur and Hur and Reba, the five kings of Midian: and Balaam, the son of Beor, they put to death with the sword. ");
INSERT INTO engBBE_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","The women of Midian with their little ones the children of Israel took prisoner; and all their cattle and flocks and all their goods they took for themselves; ");
INSERT INTO engBBE_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","And after burning all their towns and all their tent-circles, ");
INSERT INTO engBBE_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","They went away with the goods they had taken, man and beast. ");
INSERT INTO engBBE_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","And the prisoners and the goods and everything they had taken, they took to Moses and Eleazar the priest and the people of Israel, to the tent-circle in the lowlands of Moab by the Jordan at Jericho. ");
INSERT INTO engBBE_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Then Moses and Eleazar the priest and the chiefs of the people went out to them before they had come into the tent-circle. ");
INSERT INTO engBBE_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","And Moses was angry with the chiefs of the army, the captains of thousands and the captains of hundreds who had come back from the war. ");
INSERT INTO engBBE_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","And Moses said to them, Why have you kept all the women safe? ");
INSERT INTO engBBE_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","It was these who, moved by Balaam, were the cause of Israel's sin against the Lord in the question of Peor, because of which disease came on the people of the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","So now put every male child to death, and every woman who has had sex relations with a man. ");
INSERT INTO engBBE_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","But all the female children who have had no sex relations with men, you may keep for yourselves. ");
INSERT INTO engBBE_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","You yourselves will have to keep outside the tent-circle for seven days, anyone of you who has put any person to death or come near a dead body; and on the third day and on the seventh day make yourselves and your prisoners clean. ");
INSERT INTO engBBE_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","And every bit of clothing, and anything made of leather or goats' hair or wood, you are to make clean. ");
INSERT INTO engBBE_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Then Eleazar the priest said to the men of war who had been to the fight, This is the rule of the law which the Lord has given to Moses: ");
INSERT INTO engBBE_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","But gold and silver and brass and iron and tin and lead, ");
INSERT INTO engBBE_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","And anything which may be heated, is to go through the fire and be made clean; but in addition it is to be put in the water of cleaning: and anything which may not go through the fire is to be put in the water. ");
INSERT INTO engBBE_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","And on the seventh day, after washing your clothing, you will be clean, and then you may come into the tent-circle. ");
INSERT INTO engBBE_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Get an account of everything which was taken in the war, of man and of beast, you and Eleazar the priest and the heads of families of the people: ");
INSERT INTO engBBE_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","And let division be made of it into two parts, one for the men of war who went out to the fight, and one for all the people: ");
INSERT INTO engBBE_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","And from the men of war who went out let there be offered to the Lord one out of every five hundred, from the persons, and from the oxen and asses and sheep: ");
INSERT INTO engBBE_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Take this from their part and give it to Eleazar the priest as an offering to be lifted up to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","And from the part given to the children of Israel, take one out of every fifty, from the persons, and from the oxen and asses and sheep, and give it to the Levites who have the care of the House of the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","So Eleazar and Moses did as the Lord had given orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Now the beasts taken, in addition to what the fighting-men took for themselves, were six hundred and seventy-five thousand sheep, ");
INSERT INTO engBBE_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","And seventy-two thousand oxen, ");
INSERT INTO engBBE_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","And sixty-one thousand asses; ");
INSERT INTO engBBE_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","And thirty-two thousand persons, that is, women who had never had sex relations with a man. ");
INSERT INTO engBBE_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","And the half given as their part to the men who went to the war, was three hundred and thirty-seven thousand, five hundred sheep, ");
INSERT INTO engBBE_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Of which the Lord's part was six hundred and seventy-five. ");
INSERT INTO engBBE_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","The number of oxen was thirty-six thousand, of which the Lord's part was seventy-two; ");
INSERT INTO engBBE_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","The number of asses was thirty thousand, five hundred, of which the Lord's part was sixty-one. ");
INSERT INTO engBBE_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","And the number of persons was sixteen thousand, of which the Lord's part was thirty-two persons. ");
INSERT INTO engBBE_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","And Moses gave the Lord's part, lifted up as an offering, to Eleazar the priest, as the Lord had given orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","And from the half given to the children of Israel, which Moses had kept separate from that given to the fighting-men, ");
INSERT INTO engBBE_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","(Now the people's half was three hundred and thirty-seven thousand, five hundred sheep, ");
INSERT INTO engBBE_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","And thirty-six thousand oxen, ");
INSERT INTO engBBE_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","And thirty thousand, five hundred asses, ");
INSERT INTO engBBE_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","And sixteen thousand persons;) ");
INSERT INTO engBBE_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Even from the children of Israel's half, Moses took one out of every fifty, men and beasts, and gave them to the Levites who had the care of the House of the Lord; as the Lord gave orders to Moses. ");
INSERT INTO engBBE_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Then the men in authority over the thousands of the army, the captains of thousands and captains of hundreds, came to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","And said to him, Your servants have taken note of the number of all the fighting-men under our orders, and every one is present; ");
INSERT INTO engBBE_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","And we have here an offering for the Lord from what every man took in the war, ornaments of gold, leg-chains and arm-rings, finger-rings, ear-rings, and neck-ornaments, to make our souls free from sin before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","So Moses and Eleazar the priest took the gold from them, even all the worked ornaments. ");
INSERT INTO engBBE_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","And the gold which the captains of thousands and captains of hundreds gave, as an offering to be lifted up before the Lord, came to sixteen thousand, seven hundred and fifty shekels. ");
INSERT INTO engBBE_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","(For every man of the army had taken goods for himself in the war.) ");
INSERT INTO engBBE_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Then Moses and Eleazar the priest took the gold given by the captains of thousands and captains of hundreds, and took it into the Tent of meeting, to be a sign in memory of the children of Israel before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Now the children of Reuben and the children of Gad had a great number of cattle: and when they saw that the land of Jazer and the land of Gilead was a good place for cattle; ");
INSERT INTO engBBE_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","The children of Gad and the children of Reuben came and said to Moses and to Eleazar the priest and to the chiefs of the meeting, ");
INSERT INTO engBBE_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Ataroth, and Dibon, and Jazer, and Nimrah, and Heshbon, and Elealeh, and Sebam, and Nebo, and Beon, ");
INSERT INTO engBBE_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","The land which the Lord gave into the hands of the children of Israel, is a land for cattle, and your servants have cattle. ");
INSERT INTO engBBE_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","And they said, With your approval, let this land be given to your servants as their heritage: do not take us over Jordan. ");
INSERT INTO engBBE_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","And Moses said to the children of Gad and the children of Reuben, Are your brothers to go to the war, while you take your rest here? ");
INSERT INTO engBBE_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Why would you take from the children of Israel the desire to go over into the land which the Lord has given them? ");
INSERT INTO engBBE_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","So did your fathers, when I sent them from Kadesh-barnea to see the land. ");
INSERT INTO engBBE_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","For when they went up to the valley of Eshcol, and saw the land, they took from the children of Israel the desire to go into the land which the Lord had given them. ");
INSERT INTO engBBE_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","And at that time the Lord was moved to wrath, and made an oath, saying, ");
INSERT INTO engBBE_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Truly, not one of the men of twenty years old and over who came out of Egypt will see the land which I gave by oath to Abraham, Isaac, and Jacob; because they have not been true to me with all their heart; ");
INSERT INTO engBBE_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","But only Caleb, the son of Jephunneh the Kenizzite, and Joshua, the son of Nun: because they have been true to the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Then the Lord was angry with Israel, and he made them wanderers in the waste land for forty years? till all that generation who had done evil in the eyes of the Lord was dead. ");
INSERT INTO engBBE_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","And now you have come to take the place of your fathers, another generation of sinners, increasing the wrath of the Lord against Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","For if you are turned away from him, he will send them wandering again in the waste land; and you will be the cause of the destruction of all this people. ");
INSERT INTO engBBE_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Then they came to him, and said, We will make safe places for our cattle here, and towns for our little ones; ");
INSERT INTO engBBE_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","But we ourselves will be ready armed to go before the children of Israel till we have taken them to their place: but our little ones will be safe in the walled towns against the people of the land. ");
INSERT INTO engBBE_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","We will not come back to our houses till every one of the children of Israel has come into his heritage. ");
INSERT INTO engBBE_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","For we will not have our heritage with them on the other side of Jordan and forward; because our heritage has come to us on this side of Jordan to the east. ");
INSERT INTO engBBE_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Then Moses said to them, If you will do this, arming yourselves to go before the Lord to the war, ");
INSERT INTO engBBE_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Every armed man of you going across Jordan before the Lord till he has overcome and sent in flight all who are against him, ");
INSERT INTO engBBE_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","And the land is under the rule of the Lord: then after that you may come back, having done no wrong to the Lord and to Israel; and this land will be yours for your heritage before the Lord. ");
INSERT INTO engBBE_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","But if you do not do this, then you are sinners against the Lord; and you may be certain that your sin will have its reward. ");
INSERT INTO engBBE_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","So get to work building your towns for your little ones, and safe places for your sheep; and do as you have said. ");
INSERT INTO engBBE_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","And the children of Gad and the children of Reuben said to Moses, Your servants will do as my lord says. ");
INSERT INTO engBBE_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Our little ones, our wives, and our flocks, and all our cattle, will be there in the towns of Gilead; ");
INSERT INTO engBBE_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","But your servants will go over, every man armed for war, before the Lord to the fight, as my lord says. ");
INSERT INTO engBBE_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","So Moses gave orders about them to Eleazar the priest and to Joshua, the son of Nun, and to the heads of families of the tribes of the children of Israel. ");
INSERT INTO engBBE_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","And Moses said to them, If the children of Gad and the children of Reuben go with you over Jordan, every man armed for the fight before the Lord, and all the land is given into your hands, then let them have the land of Gilead for a heritage: ");
INSERT INTO engBBE_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","But if they do not go over with you armed, they will have to take their heritage with you in the land of Canaan. ");
INSERT INTO engBBE_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Then the children of Gad and the children of Reuben said, As the Lord has said to your servants, so will we do. ");
INSERT INTO engBBE_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","We will go over armed before the Lord into the land of Canaan, and you will give us our heritage on this side of Jordan. ");
INSERT INTO engBBE_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","So Moses gave to them, even to the children of Gad and the children of Reuben and to the half-tribe of Manasseh, the son of Joseph, the kingdom of Sihon, king of the Amorites and Og, king of Bashan, all the land with its towns and the country round them. ");
INSERT INTO engBBE_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","And the children of Gad were the builders of Dibon and Ataroth and Aroer; ");
INSERT INTO engBBE_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","And Atroth-shophan and Jazer and Jogbehah; ");
INSERT INTO engBBE_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","And Beth-nimrah and Beth-haran: walled towns and shut-in places for sheep. ");
INSERT INTO engBBE_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","And the children of Reuben were the builders of Heshbon and Elealeh and Kiriathaim; ");
INSERT INTO engBBE_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","And Nebo and Baal-meon, (their names being changed,) and Sibmah: and they gave other names to the towns they made. ");
INSERT INTO engBBE_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","And the children of Machir, the son of Manasseh, went to Gilead and took it, driving out the Amorites who were living there. ");
INSERT INTO engBBE_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","And Moses gave Gilead to Machir, the son of Manasseh; and he made it his living-place. ");
INSERT INTO engBBE_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","And Jair, the son of Manasseh, went and took the towns of Gilead, naming them Havvoth-Jair. ");
INSERT INTO engBBE_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","And Nobah went and took Kenath and its small towns, naming it Nobah, after himself. ");
INSERT INTO engBBE_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","These are the journeys of the children of Israel, when they went out of the land of Egypt in their armies, under the direction of Moses and Aaron. ");
INSERT INTO engBBE_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","And the stages of their journey on their way out were put down in writing by Moses at the order of the Lord: these are the stages of their journey and the way they went. ");
INSERT INTO engBBE_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","On the fifteenth day of the first month they went out from Rameses; on the day after the Passover the children of Israel went out by the power of the Lord before the eyes of all the Egyptians, ");
INSERT INTO engBBE_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","While the Egyptians were placing in the earth the bodies of their sons on whom the Lord had sent destruction: and their gods had been judged by him. ");
INSERT INTO engBBE_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","So the children of Israel went from Rameses and put up their tents in Succoth. ");
INSERT INTO engBBE_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","And they went on from Succoth and put up their tents in Etham on the edge of the waste land. ");
INSERT INTO engBBE_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","And from Etham, turning back to Pi-hahiroth which is before Baal-zephon, they put up their tents before Migdol. ");
INSERT INTO engBBE_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","And journeying on from before Hahiroth, they went through the sea into the waste land: they went three days' journey through the waste land of Etham and put up their tents in Marah. ");
INSERT INTO engBBE_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","And from Marah they went on to Elim: and in Elim there were twelve water-springs and seventy palm-trees; and they put up their tents there. ");
INSERT INTO engBBE_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","And they went on from Elim and put up their tents by the Red Sea. ");
INSERT INTO engBBE_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Then from the Red Sea they went on and put up their tents in the waste land of Sin. ");
INSERT INTO engBBE_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","And they went on from the waste land of Sin, and put up their tents in Dophkah. ");
INSERT INTO engBBE_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","And they went on from Dophkah, and put up their tents in Alush. ");
INSERT INTO engBBE_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","And they went on from Alush, and put up their tents in Rephidim, where there was no drinking-water for the people. ");
INSERT INTO engBBE_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","And they went on from Rephidim, and put up their tents in the waste land of Sinai. ");
INSERT INTO engBBE_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","And they went on from the waste land of Sinai and put up their tents in Kibroth-hattaavah. ");
INSERT INTO engBBE_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","And they went on from Kibroth-hattaavah, and put up their tents in Hazeroth. ");
INSERT INTO engBBE_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","And they went on from Hazeroth, and put up their tents in Rithmah. ");
INSERT INTO engBBE_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","And they went on from Rithmah, and put up their tents in Rimmon-perez. ");
INSERT INTO engBBE_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","And they went on from Rimmon-perez, and put up their tents in Libnah. ");
INSERT INTO engBBE_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","And they went on from Libnah, and put up their tents in Rissah. ");
INSERT INTO engBBE_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","And they went on from Rissah, and put up their tents in Kehelathah. ");
INSERT INTO engBBE_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","And they went on from Kehelathah, and put up their tents in Mount Shepher. ");
INSERT INTO engBBE_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","And they went on from Mount Shepher, and put up their tents in Haradah. ");
INSERT INTO engBBE_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","And they went on from Haradah, and put up their tents in Makheloth. ");
INSERT INTO engBBE_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","And they went on from Makheloth, and put up their tents in Tahath. ");
INSERT INTO engBBE_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","And they went on from Tahath, and put up their tents in Terah. ");
INSERT INTO engBBE_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","And they went on from Terah, and put up their tents in Mithkah. ");
INSERT INTO engBBE_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","And they went on from Mithkah, and put up their tents in Hashmonah. ");
INSERT INTO engBBE_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","And they went on from Hashmonah, and put up their tents in Moseroth. ");
INSERT INTO engBBE_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","And they went on from Moseroth, and put up their tents in Bene-jaakan. ");
INSERT INTO engBBE_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","And they went on from Bene-jaakan, and put up their tents in Hor-haggidgad. ");
INSERT INTO engBBE_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","And they went on from Hor-haggidgad, and put up their tents in Jotbathah. ");
INSERT INTO engBBE_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","And they went on from Jotbathah, and put up their tents in Abronah. ");
INSERT INTO engBBE_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","And they went on from Abronah, and put up their tents in Ezion-geber. ");
INSERT INTO engBBE_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","And they went on from Ezion-geber, and put up their tents in the waste land of Zin (which is Kadesh). ");
INSERT INTO engBBE_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","And they went on from Kadesh, and put up their tents in Mount Hor, on the edge of the land of Edom. ");
INSERT INTO engBBE_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","And Aaron the priest went up into the mountain at the order of the Lord, and came to his death there, in the fortieth year after the children of Israel had come out of the land of Egypt, in the fifth month, on the first day of the month. ");
INSERT INTO engBBE_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aaron was a hundred and twenty-three years old at the time of his death in Mount Hor. ");
INSERT INTO engBBE_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","And news of the coming of the children of Israel came to the king of Arad, the Canaanite, who was living in the South in the land of Canaan. ");
INSERT INTO engBBE_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","And from Mount Hor they went on, and put up their tents in Zalmonah. ");
INSERT INTO engBBE_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","And they went on from Zalmonah, and put up their tents in Punon. ");
INSERT INTO engBBE_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","And they went on from Punon, and put up their tents in Oboth. ");
INSERT INTO engBBE_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","And they went on from Oboth, and put up their tents in Iye-abarim at the edge of Moab. ");
INSERT INTO engBBE_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","And they went on from Iyim, and put up their tents in Dibon-gad. ");
INSERT INTO engBBE_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","And from Dibon-gad they went on, and put up their tents in Almon-diblathaim. ");
INSERT INTO engBBE_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","And from Almon-diblathaim they went on, and put up their tents in the mountains of Abarim, before Nebo. ");
INSERT INTO engBBE_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","And they went on from the mountains of Abarim, and put up their tents in the lowlands of Moab by Jordan at Jericho; ");
INSERT INTO engBBE_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Planting their tents by the side of Jordan from Beth-jeshimoth as far as Abel-shittim in the lowlands of Moab. ");
INSERT INTO engBBE_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","And in the lowlands of Moab by Jordan at Jericho, the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Say to the children of Israel, When you go over Jordan into the land of Canaan, ");
INSERT INTO engBBE_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","See that all the people of the land are forced out from before you, and put to destruction all their pictured stones, and all their metal images, and all their high places: ");
INSERT INTO engBBE_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","And take the land for yourselves, for your resting-place: for to you I have given the land as your heritage. ");
INSERT INTO engBBE_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","And you will take up your heritage in the land by the decision of the Lord, to every family its part; the greater the family the greater its heritage, and the smaller the family the smaller will be its heritage; wherever the decision of the Lord gives to any man his part, that will be his; distribution will be made to you by your fathers' tribes. ");
INSERT INTO engBBE_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","But if you are slow in driving out the people of the land, then those of them who are still there will be like pin-points in your eyes and like thorns in your sides, troubling you in the land where you are living. ");
INSERT INTO engBBE_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","And it will come about that as it was my purpose to do to them, so I will do to you. ");
INSERT INTO engBBE_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","Give orders to the children of Israel and say to them, When you come into the land of Canaan; (this is the land which is to be your heritage, the land of Canaan inside these limits,) ");
INSERT INTO engBBE_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Then your south quarter will be from the waste land of Zin by the side of Edom, and your limit on the south will be from the east end of the Salt Sea, ");
INSERT INTO engBBE_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","And round to the south of the slope of Akrabbim, and on to Zin: and its direction will be south of Kadesh-barnea, and it will go as far as Hazar-addar and on to Azmon: ");
INSERT INTO engBBE_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","And from Azmon it will go round to the stream of Egypt as far as the sea. ");
INSERT INTO engBBE_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","And for your limit on the west you will have the Great Sea and its edge: this will be your limit on the west. ");
INSERT INTO engBBE_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","And your limit on the north will be the line from the Great Sea to Mount Hor: ");
INSERT INTO engBBE_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","And from Mount Hor the line will go in the direction of Hamath; the farthest point of it will be at Zedad: ");
INSERT INTO engBBE_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","And the limit will go on to Ziphron, with its farthest point at Hazar-enan: this will be your limit on the north. ");
INSERT INTO engBBE_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","And on the east, your limit will be marked out from Hazar-enan to Shepham, ");
INSERT INTO engBBE_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Going down from Shepham to Riblah on the east side of Ain, and on as far as the east side of the sea of Chinnereth: ");
INSERT INTO engBBE_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","And so down to Jordan, stretching to the Salt Sea: all the land inside these limits will be yours. ");
INSERT INTO engBBE_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","And Moses gave orders to the children of Israel saying, This is the land which is to be your heritage, by the decision of the Lord, which by the Lord's order is to be given to the nine tribes and the half-tribe: ");
INSERT INTO engBBE_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","For the tribe of the children of Reuben, by their fathers' families, and the tribe of the children of Gad, by their fathers' families, and the half-tribe of Manasseh, have been given their heritage: ");
INSERT INTO engBBE_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","The two tribes and the half-tribe have been given their heritage on the other side of Jordan at Jericho, on the east looking to the dawn. ");
INSERT INTO engBBE_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","And the Lord said to Moses, ");
INSERT INTO engBBE_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","These are the names of the men who are to make the distribution of the land among you: Eleazar the priest and Joshua, the son of Nun. ");
INSERT INTO engBBE_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","And you are to take one chief from every tribe to make the distribution of the land. ");
INSERT INTO engBBE_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","And these are the names of the men: of the tribe of Judah, Caleb, the son of Jephunneh. ");
INSERT INTO engBBE_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","And of the tribe of the children of Simeon, Shemuel, the son of Ammihud. ");
INSERT INTO engBBE_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Of the tribe of Benjamin, Elidad, the son of Chislon. ");
INSERT INTO engBBE_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","And of the tribe of the children of Dan, a chief, Bukki, the son of Jogli. ");
INSERT INTO engBBE_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Of the children of Joseph: of the tribe of the children of Manasseh, a chief, Hanniel, the son of Ephod: ");
INSERT INTO engBBE_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","And of the tribe of the children of Ephraim, a chief, Kemuel, the son of Shiphtan. ");
INSERT INTO engBBE_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","And of the tribe of the children of Zebulun, a chief, Elizaphan, the son of Parnach. ");
INSERT INTO engBBE_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","And of the tribe of the children of Issachar, a chief, Paltiel, the son of Azzan. ");
INSERT INTO engBBE_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","And of the tribe of the children of Asher, a chief, Ahihud, the son of Shelomi. ");
INSERT INTO engBBE_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","And of the tribe of the children of Naphtali, a chief, Pedahel, the son of Ammihud. ");
INSERT INTO engBBE_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","These are they to whom the Lord gave orders to make the distribution of the heritage among the children of Israel in the land of Canaan. ");
INSERT INTO engBBE_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","And the Lord said to Moses 