﻿USE sofia;
DROP TABLE IF EXISTS sofia.eng_t4t_vpl;
CREATE TABLE eng_t4t_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES eng_t4t_vpl WRITE;
INSERT INTO eng_t4t_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Long, long ago God created the heavens and the earth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","When he began to create the earth, it was shapeless and completely desolate/chaotic. Darkness covered the deep water that surrounded the earth. And the Spirit of God was hovering over the water. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","God said, “I want light to shine!” And light shone. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","God was pleased with the light. Then he made the light to shine in some places, and in other places there was still darkness. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","He gave to the light the name ‘day’, and he gave to the darkness the name ‘night’. After that, there was an evening which was followed by a morning. He called that whole period of time ‘the first day’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Then God said, “I command that there be an empty space like a huge dome to separate the water that is above it from the water on the earth that is below it!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","And that is what happened. God gave to the space the name ‘sky’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Then there was another evening, which was followed by another morning. He called that period of time ‘the second day’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Then God said, “I want the water that is below the sky to come together, and dry ground to appear and rise above the water.” And that is what happened. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","God gave to the ground the name ‘earth’, and he gave to the water that came together the name ‘oceans’. God was pleased with the earth and the oceans. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Then God said, “I want the earth to produce plants, including plants that will produce seeds and trees that will produce fruit. Each kind of tree will bear its own kind of fruit.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Then plants grew on the earth; each kind of plant began to produce its own kind of seed. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Then there was another evening which was followed by another morning. God called that period of time ‘the third day’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Then God said, “I want a sun, a moon, and many stars to shine in the sky. The sun will shine in the daytime and the moon and stars will shine during the nighttime. By the changes in their appearance they will indicate the various seasons (OR, the times for special celebrations), and will enable people to know when days and years begin. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","I want them also to be like lights in the sky that will shine on the earth.” And that is what happened. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","God made two of them that were like big lights. The bigger one, the sun, shines during the day and the smaller one, the moon, shines during the night. He also made the stars. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","God set all of them in the sky to shine on the earth, ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","to rule the day and the night, and to separate the light of the daytime from the darkness of the nighttime. God was pleased with these things he had made. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Then there was another evening which was followed by another morning. He called that period of time ‘the fourth day’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Then God said, “I want many creatures to live in all the oceans, and I also want birds to fly in the sky above the earth.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","So God created huge sea creatures and every other kind of creature that moves in the water, and caused them to live in all the oceans. He also created many kinds of birds. God was pleased with all those creatures. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","God blessed them. He said, “Produce offspring and become very numerous. I want the creatures in the water to live in all the oceans, and birds also to become very numerous.” And that is what happened. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Then there was another evening that was followed by another morning. He called that period of time ‘the fifth day’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Then God said, “I want various kinds of creatures to appear on the earth. There will be many kinds of ◄livestock/domestic animals►, creatures that scurry across the ground, and large wild animals.” And that is what happened. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","God made all kinds of wild animals and ◄livestock/domestic animals► and all kinds of creatures that scurry across the ground. God was pleased with all these creatures. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Then God said, “Now we will make human beings that will be like us in many ways. I want them to rule over the fish in the sea, over the birds, over all the ◄livestock/domestic animals►, and over all the other creatures that scurry across the ground.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","So God created human beings that were like him in many ways. He made them to be like himself. He created some to be male and some to be female. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","God blessed them, saying, “Produce many children, who will live all over the earth and rule over it. I want them to rule over the fish and the birds and over all creatures that scurry across the ground.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","God said to the humans, “Listen! I have given you all the plants that produce seeds, all over the earth, and all the trees that have seeds in their fruit. All these things are for you to eat. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","I have given all the green plants to all the wild animals and to the birds and to all the creatures that scurry across the ground, to everything that breathes, for them to eat.” And that is what happened. ");
INSERT INTO eng_t4t_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","God was pleased with everything that he had made. Truly, it was all very good. Then there was another evening, that was followed by another morning. He called that period of time ‘the sixth day’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","That is the way God created the heavens and the earth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","By the time it was the seventh day, God had finished the work of creating everything, so he did not work any more on that day. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","God blessed each seventh day, and he set those days apart to be special days, because on the seventh day God did not work any more, after finishing all his work of creating everything. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","That is how God created the heavens and the earth. God, whose name is Yahweh, made the heavens and the earth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","At first there were no plants growing, because Yahweh God had not yet caused rain to fall on the ground. Furthermore, there was no one to till the ground for planting crops. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Instead, mist rose up from the ground, so that it watered the surface of the ground. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Then Yahweh God took some soil and formed a man. He breathed into the man’s nostrils his own breath that gives life, and as a result the man became a living person. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Yahweh God made a park/garden in a place named Eden, which was east of the land of Canaan, and he put there the man that he had created. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Yahweh God also put there every kind of tree that is beautiful to see and that produced fruit that was good to eat. He also placed in the middle of the park/garden a tree whose fruit would enable those who ate it to live forever. He also placed there another tree whose fruit would enable those who ate it to know what actions were good to do and what actions were evil to do. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","A river flowed from Eden to provide water for the park/garden. Outside of Eden, the river divided into four rivers. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","The name of the first river is Pishon. That river flows through all the land of Havilah, where there is gold. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","That gold ◄is very pure/has no impurities in it►. There is also a sweet-smelling gum called bdellium, and valuable stones called onyx. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","The name of the second river is Gihon. That river flows through all the land of Cain. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","The name of the third river is Tigris. It flows east of the city of Asshur. The name of the fourth river is Euphrates. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Yahweh God took the man and put him in Eden park/garden to till/cultivate it and take care of it. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","17","But Yahweh said to him, “You must not eat the fruit of the tree that will enable you to know what actions are good to do and what actions are evil to do. If you eat any fruit from that tree, on that day your relationship with me will end. But I will permit you to eat the fruit of any of the other trees in the park/garden.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Then Yahweh God said, “It is not good for this man to be alone. So I will make someone who will be a suitable partner for him.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Yahweh God had taken some soil and had formed from it all kinds of animals and birds, and he brought them to the man to hear what names he would give them. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Then the man gave names to all the kinds of livestock and birds and wild animals, but none of these creatures was a partner that was suitable for the man. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","So Yahweh God caused the man to fall into a deep sleep. While the man was sleeping, Yahweh took out one of the man’s ribs. Then he immediately closed the opening in his body and healed it. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Yahweh then made a woman from the rib that he had taken from the man’s body, and he brought her to the man. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","The man exclaimed, “Wow! This is truly ◄someone like me/what I was looking for!► She is truly from my bones and from my flesh. So I will call her woman, because she was taken from me, a man.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","The first woman was taken from the man’s body, so that is why when a man and a woman marry, they must leave their parents. The man will join very closely to his wife, so that the two of them will be as though they are one person. ");
INSERT INTO eng_t4t_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Although the man and his wife were naked, they were not ashamed about that. ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","The snake was more cunning than all the other wild animals that Yahweh God had made. One day Satan gave to the snake the ability to talk to the woman. The snake said to her, “Did God really say to you, ‘Do not eat the fruit from any of the trees in the park/garden’?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","The woman replied, “What God said was, ‘Do not eat the fruit from the tree that is in the middle of the park/garden or touch it. If you do that, you will die. But you can eat fruit from any of the other trees.’” ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","The snake said to the woman, “No, you will certainly not die. God said that ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","only because he knows that when you eat fruit from that tree, you will understand new things. It will be as though your eyes are opened MET, and you will know what is good to do and what is evil to do, just as God does.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","The woman saw that the fruit on that tree was good to eat, and it was very beautiful, and she desired it because she thought it would make her wise. So she picked some of the fruit and ate it. Then she gave some to her husband, and he ate it. ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Immediately it was as though their eyes were opened, and they realized that they were naked, so they were ashamed. So they picked some fig leaves and fastened them together to make clothes for themselves. ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Late that afternoon, when a cool breeze was blowing, they heard the sound/footsteps of Yahweh as he was walking in the park/garden. So the man and his wife hid themselves among the bushes in the park/garden, so that Yahweh God would not see them. ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","But Yahweh God called to the man, saying to him, “Why are you trying to hide from me?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","The man replied, “I heard the sound of your footsteps/walking in the garden, and I was naked, so I was afraid and I hid myself.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","God said, “How did you find out you were naked RHQ? It must be because you ate some of the fruit from the tree that I told you, ‘Do not eat its fruit.’” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","The man said, “You gave me this woman to be with me. She is the one who gave me some of the fruit from that tree, and so I ate it.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Then Yahweh God said to the woman, “Why did you do such a thing?” The woman replied, “I ate some of the fruit because the snake deceived me.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Then Yahweh God said to the snake, “Because you did this, of all the livestock and the wild animals, I will curse/punish you alone. As a result, you and all other snakes will scurry across the ground on your bellies, and so what you eat will have dirt on it as long as you live. ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","And I will cause you and the woman to act in a hostile way toward each other, and I will cause your brood and her descendants to act hostilely toward each other. You will strike at the heel of one descendant of hers, but he will strike your head.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Then Yahweh said to the woman, “You will have great pain when you give birth to children; you will suffer great pain as your children are being born DOU. You will greatly desire your husband to show affection for you, but he will rule over you.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Then Yahweh said to the man, “You heeded what your wife said, and you ate some of the fruit of the tree concerning which I commanded you saying, ‘Do not eat it.’ So I will make it difficult to grow things in the ground because of what you did. You will have to work hard as long as you live to produce things from the ground to eat. ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Thornbushes and thistle plants and other weeds will grow and prevent what you have planted from growing. And for food, you will have to eat things that just grow in your fields. ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","All your life you will sweat as you work hard to produce food to eat. Then you will die EUP, and your body will be buried in the ground. I made you from soil, so when you die and are buried your body will decay and become soil again.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","The man, whose name was Adam, named his wife Eve, which means ‘living’, because she became the ancestor of all living people. ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Then Yahweh God killed some animals and made clothes from their skins for Adam and his wife. ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Then Yahweh said, “Look! Those two have become like us because they know what is good to do and what is evil to do. So now, it will not be good if they reach out and pick and eat some of the fruit from the tree which enables people who eat it to live forever!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","So Yahweh God expelled the man and his wife from the garden of Eden. Yahweh God had created Adam from the ground, but now he forced him to till that ground so that he could grow food to eat. ");
INSERT INTO eng_t4t_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","After Yahweh expelled them, on the east side of the garden he placed ◄cherubim/creatures with wings► and an angel holding a flaming sword which flashed back and forth. He did that in order to block the entrance to the garden, so that people could not go back to the tree that enables people who eat its fruit to live forever. ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam ◄had sex/slept► with his wife Eve, and she became pregnant and gave birth to a son whom she named Cain, which sounds like the word that means ‘produce’, because, she said, “By Yahweh’s help I have produced a son.” Some time later she gave birth to another son, and she named him Abel. ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","After those boys grew up, Abel ◄tended/took care of► sheep and goats, and Cain became a farmer. ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","One day Cain harvested some of the crops he had grown and brought them to Yahweh as a gift for him, ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","and Abel took from his flock some of the first lambs that had been born and killed them and, as a gift, gave to Yahweh the fatty parts, which were the best parts. Yahweh was pleased with Abel and his offering, ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","but he was not pleased with Cain and his offering. So Cain became very angry, and his face looked dejected. ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yahweh said to Cain, “◄You should not be angry!/Why are you angry?► RHQ ◄You should not scowl like that!/Why do you scowl like that?► RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","If you had done what was right (OR, if you do what is right) RHQ, I would accept your offering. But if you do not do what is right, your desire to sin is ready to attack you like a wild animal that PRS crouches outside the doorway, ready to spring on its victim MET. Your desire to sin wants to control you, but you must ◄control/not obey► it.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","But one day, Cain said to his younger brother Abel, “Let’s go for a walk in the fields.” So they went together. And when they were in the countryside, suddenly Cain attacked Abel and killed him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Later, even though Yahweh knew what Cain had done, he said to Cain, “Do you know where Abel, your younger brother, is?” Cain replied, “No, I do not know. ◄My job is not to guard my younger brother!/Am I supposed to take care of my younger brother?►” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Yahweh said, “You have done a terrible thing RHQ! So now it is as though your younger brother’s voice is crying to me from the ground, demanding that his death must be avenged. ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","You have killed your younger brother, and the ground has soaked up his blood. So now I will expel you from this land and curse your efforts to produce crops. ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","You will till the ground to plant crops, but the ground will produce very few HYP crops. And you will continually wander around the earth, and not have any place to live permanently.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Cain replied, “You are punishing me more then I can endure. ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","You are about to expel me from the ground that I have been cultivating, and I will no longer be able to come ◄into your presence/and talk with you►. Furthermore, I will be continually wandering around the earth with no place to live permanently, and anyone who sees me will kill me.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","But Yahweh said to him, “No, that will not happen. I will put a mark on you to warn anyone who sees you that I will punish him severely if he kills you. I will punish that person seven times as severely as I am punishing you.” Then Yahweh put a mark on Cain’s forehead. ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","So Cain left Yahweh and went to live in the land called Nod, which means ‘wandering’, which was east of Eden. ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Some time later, Cain ◄had sex/slept► with his wife, and she became pregnant and gave birth to a son, whom she named Enoch. Then Cain started to build a city, and he named the city ‘Enoch’, the same name that his son had. ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoch grew up and married and became the father of a son whom he named Irad. When Irad grew up he became the father of a son whom he named Mehujael. Mehujael grew up and became the father of a son whom he named Methuselah. Methuselah grew up and became the father of Lamech. ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","When Lamech grew up he married two women. The name of one was Adah and the other was Zillah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adah gave birth to a son she named Jabal. ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Later, Jabal was the first person who lived in tents because he traveled from place to place to take care of livestock. His younger brother’s name was Jubal. He was the first person who made/played a ◄lyre/stringed instrument► and a flute. ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lamech’s other wife Zillah gave birth to a son whom she named Tubal-Cain. Later Tubal-Cain became a ◄blacksmith/one who made tools from bronze and iron►. Tubal-Cain had a younger sister whose name was Naamah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","One day Lamech said to his two wives, “Adah and Zillah, listen carefully to what I am saying. A young man struck me and wounded me, so I killed him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Yahweh said long ago that he would avenge and punish anyone who killed Cain seven times as much as he punished Cain for killing his younger brother. So if anyone tries to kill me, I will punish him 77 times as much as Yahweh punished Cain.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam continued to ◄have sex/sleep► with EUP his wife, and she became pregnant and gave birth to another son, whom she named Seth, which sounds like the Hebrew word that means ‘given’, because, she said, “God has given me another child to take the place of Abel, since Cain killed him.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","When Seth grew up, he became the father of a son whom he named Enosh. About that time people began to worship Yahweh again. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Here is a list of the descendants of Adam. When God created humans, he caused them to be like him in many ways. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","He created one man and one woman. He blessed them, and on the day that he created them, he called them ‘human beings’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","When Adam was 130 years old, he became the father of a son who grew up to be just like him. That was the son he named Seth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","After Seth was born, Adam lived 800 more years, and during those years he became the father of other sons and daughters. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam lived 930 years altogether, and then he died. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","When Seth was 105 years old, he became the father of Enosh. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","After Enosh was born, Seth lived 807 more years, and became the father of other sons and daughters. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seth lived 912 years altogether, and then he died. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","When Enosh was 90 years old, he became the father of Kenan. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","After Kenan was born, Enosh lived 815 more years and became the father of other sons and daughters. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enosh lived 905 years altogether, and then he died. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","When Kenan was 70 years old, he became the father of Mahalalel. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","After Mahalalel was born, Kenan lived 840 more years and became the father of other sons and daughters. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan lived 910 years altogether, and then he died. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","When Mahalalel was 65 years old, he became the father of Jared. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","After Jared was born, Mahalalel lived 830 more years and became the father of other sons and daughters. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalel lived 895 years altogether, and then he died. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","When Jared was 162 years old, he became the father of Enoch. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Jared lived 800 years after Enoch was born, and he became the father of other sons and daughters. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jared lived 962 years altogether, and then he died. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","When Enoch was 65 years old, he became the father of Methuselah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enoch lived in close fellowship with God for 300 years after Methuselah was born, and he became the father of other sons and daughters. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enoch lived 365 years altogether in close fellowship with God. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Then one day he disappeared, because God took him away to be with him in heaven. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","When Methuselah was 187 years old, he became the father of Lamech. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Methuselah lived 782 years after Lamech was born, and became the father of other sons and daughters. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Methuselah lived 969 years altogether, and then he died. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","When Lamech was 182 years old, he became the father of a son, ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","whom he named Noah, which sounds like the Hebrew word that means ‘relief’, because he said, “He will bring us relief from all the hard work we have been doing to produce food from the ground that Yahweh cursed.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamech lived 595 years after Noah was born and became the father of other sons and daughters. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamech lived 777 years altogether, and then he died. ");
INSERT INTO eng_t4t_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","When Noah was 500 years old, he became the father of a son whom he named Shem. Later he became the father of another son whom he named Ham, and later he became the father of another son whom he named Japheth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","When people began to become very numerous all over the earth, and many daughters were born to them, ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","some of the men who ◄belonged to/believed in► God saw that some of the women who did not ◄belong to/believe in► God were very beautiful. So they took whichever ones they chose to become their wives. ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Then Yahweh said, “I will not allow  my Spirit to keep people alive forever (OR, the breath of life will not remain in people forever). They will die eventually. They will live not more than 120 years before they die (OR, there will be only 120 more years before they die).” ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","There were giants called Nephils who lived on the earth at that time and later. During that time some of the Nephil men who ◄belonged to/believed in► God had sex EUP with women who did not ◄belong to/believe in► God, and they gave birth to children. The Nephils were considered to be heroic fighters, and they became famous. ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yahweh saw that people on the earth had become very wicked, and that everything they thought about evil things continually. ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yahweh was sorry that he had made people. ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","So he said, “I will completely destroy the people I made. I will also destroy all the animals and the creatures that scurry across the ground and the birds. None of them will remain on the earth, because I regret that I made them.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","But Yahweh was pleased with Noah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","This is why: Noah was a man who always acted in a righteous way. No one who lived at that time could criticize him about anything. Noah lived in close fellowship with God. ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noah became the father of three sons: Shem, Ham, and Japheth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","At that time God considered that everyone else on earth was very wicked, and everywhere on the earth, people MTY were acting cruelly and violently toward each other. ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","God was dismayed when he saw how evil people MTY were, because everyone (OR, all living creatures) had begun to behave in an evil way. ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","So God said to Noah, “I have decided to destroy everyone, because all over the earth people are acting violently toward each other. So I am about to get rid of them as well as everything else on the earth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","I want you to make for yourself a large boat from cypress wood. Make rooms inside it. Cover the outside and the inside with tar to make it ◄waterproof/so that water cannot get in and sink the boat►. ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","This is the size you must make it: It shall be ◄150 yards/135 meters► long, ◄25 yards/22.5 meters► wide, and ◄15 yards/13.5 meters► high. ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Make a roof for the boat. Leave a space of about ◄18 in./.5 meter► between the sides and the roof to let air and light enter (OR, the middle of the roof should be 18 inches higher than the sides). Build the boat with three decks inside, and put a door in one side. ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Listen carefully! I am about to cause a flood to occur that will destroy every creature that lives beneath the sky. Everything on the earth will die. ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","But I will make an agreement with you(sg): You and your wife, your sons and their wives will enter the boat. ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","And I want to save some of all kinds of creatures. So you must also bring two of all living creatures, a male and a female, into the boat with you, so that their species also may remain alive. ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Two of every kind of creature will come to youin order that by your putting them in the boat  you will keep them alive. They will include two of each kind of bird and each kind of animal and each kind of creature that scurries across the ground. ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","You must also take some of every kind of food that you and all these animals will need, and store it in the boat.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","So Noah did everything that God told him to do. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Then Yahweh said to Noah, “I have seen that out of everyone who is now living, you alone always act righteously. So you and all your family go into the boat. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Take with you seven pairs of every kind of animal that I have said I will accept for sacrifices. Take seven males and seven females. Also take a male and a female from every kind of animal that I have said that I will not accept for sacrifices. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Also take seven pairs of every kind of bird from all over the earth to keep them alive. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Do this because seven days from now I will cause rain to fall on the earth. It will rain constantly for 40 days and nights. By doing that, I will destroy everything that I have made that is on the earth.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noah did everything that Yahweh told him to do. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noah was 600 years old when the flood covered the earth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Before it started to rain, Noah and his wife and his sons went into the boat to escape from the flood water. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Pairs of animals, those that God said that he would accept for sacrifices and those that he would not accept for sacrifices, and pairs of birds and pairs of all the kinds of creatures that move close to the ground, ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","males and females, came to Noah and then went into the boat, just as God told Noah that they would do. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Seven days later, it started to rain and a flood began to cover the earth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","When Noah was 600 years old, ◄on the 17th day of the second month of that year/late in October►, all the water that is under the surface of the earth burst forth, and it began to rain so hard that it was as though a dam MET in the sky burst open. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Rain fell on the earth constantly for 40 days and nights. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","On the day that it started to rain, Noah went into the boat with his wife, and his three sons, Shem, Ham, and Japheth and their wives. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","They had already put in the boat some of every kind of wild animal and every kind of livestock and every kind of bird and every other creature that has wings. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Pairs of all animals came to Noah and entered the boat. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","There was a male and a female of each animal that came to Noah, just as God had said they would do. After they were all in the boat, God shut the door. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","It rained for 40 days and nights, and the flood increased. It flooded until the water lifted the boat above the ground. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","As he water rose higher and higher, the boat floated on the surface of the water. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","The water rose all over the earth until it covered all the mountains. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Even the highest mountains were covered by more than ◄20 feet/6 meters► of water. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","As a result, every living creature on the surface of the earth died. That included birds and livestock and wild animals and other creatures that scurry across the ground, and all the people. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","On the land, ◄everything that breathed/every living thing► died. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","God destroyed every living creature: People and animals and creatures that scurry across the ground and birds. Only Noah and those who were in the boat with him remained alive. ");
INSERT INTO eng_t4t_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","The flood remained like that on the earth for 150 days. ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","But God ◄did not forget/thought► about Noah and all the wild animals and all the kinds of livestock that were with him in the boat. So one day God sent a wind to blow across the earth, and the wind caused the water to begin to recede. ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","God caused the water that was under the earth to stop bursting forth, and he caused the floodgates of water from the sky to close so that it stopped raining. ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","The water on the earth gradually receded. 150 days after the flood began, ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","◄on the 17th day of the seventh month of that year/late in March►, the boat came to rest on one of the mountains in the Ararat region. ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","The water continued to recede until, on the first day of the tenth month of that year, the tops of other mountains became visible. ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","40 days later, Noah opened the window that he had made in the side of the boat, and sent out a raven. ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","The raven flew back and forth to and from the boat until the water was completely gone. ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Then Noah sent out a dove to find out if the water had all receded on the ground. ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","But the dove did not find any place to perch, so it flew back to Noah in the boat, because there was still water all over the surface of the earth. So Noah reached out his hand and took the dove back inside the boat. ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noah waited seven more days. Then he sent the dove out of the boat again. ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","This time the dove returned to him in the evening and, surprisingly, in its beak there was a leaf from an olive tree that the dove had just plucked. Then Noah knew that the water had truly receded from the surface of the ground. ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Noah waited seven more days. Then he sent the dove out again, but this time it did not return to him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noah was now 601 years old. By the first day of the first month of the Jewish year, the water had completely drained away from the ground. Noah removed the covering on top of the ark, and he was surprised to see that the surface of the ground was drying. ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","By the 27th day of the next month, the ground was completely dry. ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Then God said to Noah, ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Leave the boat, along with your wife and your sons and their wives. ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Bring out with you all the birds, the animals, and all the creatures that scurry across the ground, in order that they can spread all over the earth and become very numerous.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","So Noah left the boat, along with his wife and his sons and their wives. ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","And every kind of creature, including all those that scurry across the ground, all the birds, every creature that moves on the earth, left the boat. They left the boat in groups of their own species. ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Then Noah built a ◄stone altar/place for offering sacrifices► to Yahweh. Then he took some of the animals that Yahweh had said were acceptable as sacrifices and killed them. Then he burned them whole on the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","When Yahweh smelled the pleasant odor, he was pleased with the sacrifice. Then he said to himself, “I will never again devastate everything on the earth because of the sinful things people do. Even though everything that people think is evil from the time they are young, I will not destroy all the living creatures again, as I did this time. ");
INSERT INTO eng_t4t_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","As long as the earth exists, each year there will be seasons for planting seeds and seasons for harvesting crops. Each year there will be times when it is cold and times when it is hot, summer and winter (OR, rainy season and dry season). Each day there will be daytime and nighttime.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Then God blessed Noah and his sons, saying to them, “I want you to have many children who will live all over the earth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","All the wild animals on the earth and all the birds, all the creatures that scurry across the ground, and all the fish, will be very afraid DOU of you. I have put them under your control. ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Just as I previously said you could eat green plants for food, now I am saying you can eat everything that lives and moves. ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","It is blood that causes creatures to be alive, therefore you must not eat meat that still has blood in it after the animal is killed. After you have drained the blood out, you may cook it and eat it. ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","I insist that murderers must be executed. Animals that kill people must also be executed. The reason that everyone who murders someone else must be executed is that ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","I made people to be like myself in many ways. So someone who murders another human being must be executed by others, because he killed someone who is like me. ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","As for you, I want you to produce many children, in order that they and their descendants may live all over the earth.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","God also said to Noah and his sons, ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Listen carefully. I am now making a solemn promise to you and with your descendants, ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","and with all the living creatures that are with you—including the birds, the livestock, and the wild animals—every living creature on the earth that came out of the boat with you. ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","This is the promise that I am making to you: I will never again destroy all living creatures by a flood, or destroy everything else on the earth by a flood.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Then God said to him, “This is the sign to guarantee that I will keep the promise that I am making to you and to all living creatures, a promise that I will keep forever: ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","From time to time I will put a rainbow in the sky. It will remind me of my promise that I have made to you and everything on the earth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","When I cause rain to fall from the clouds, and a rainbow appears in the sky, ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","it will remind me about the promise that I have made to you and all living creatures, my promise that there will never again be a flood that will destroy all living creatures. ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Whenever there is a rainbow in the sky, I will see it, and I will think about the promise that I have made to every living creature that is upon the earth, a promise that I will keep forever.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Then God said to Noah, “The rainbow will be the sign of the promise that I have made to all the creatures that live on the earth.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","The sons of Noah who came out of the boat were Shem, Ham, and Japheth. Ham later became the father of Canaan. ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","All the people on the earth are descended from those three sons of Noah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noah was a farmer. He planted grapevines. ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","When they later produced grapes, he made wine from the grapes. One day, when he drank too much of the wine, he became drunk, and he lay naked in his tent. ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, the father of Canaan, saw his father lying naked in the tent. So he went outside and told his two older brothers what he had seen. ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Then Shem and Japheth took a large cloth and placed it across their backs, and walked backwards into the tent. They covered their father’s naked body with the cloth. Their faces were turned away from their father, so they did not see him naked. ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","When Noah woke up and was sober again, he found out how wrongfully Ham, his youngest son, had behaved toward him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","He said, “I am cursing Ham’s youngest son, Canaan, and his descendants. They will be like slaves to their uncles. ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","I will ask God to enlarge the territory that belongs to Japheth, and allow his descendants to live peacefully among the descendants of Shem MTY. ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","And I desire that Canaan’s descendants will be like slaves of Japheth’s descendants.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noah lived 350 more years after the flood. ");
INSERT INTO eng_t4t_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","He died when he was 950 years old. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","◄This is/I will now give► a list of the descendants of Noah’s sons, Shem, Ham, and Japheth. They had many children after the flood. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","The sons of Japheth were Gomer, Magog, Madai, Javan, Tubal, Meshech, and Tiras. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","The sons of Gomer were Askenaz, Riphath, and Togarmah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","The sons of Javan were Elishah, Tarshish, Kittim, and Dodanim. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Those sons and their families who were descended from Javan lived on the islands and on the land close to the Mediterranean Sea. Their descendants became tribes, each with its own language and clans and territory. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","The descendants of Ham were Cush, Egypt, Put, and Canaan. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","The descendants of Cush were Seba, Havilah, Sabtah, Raamah, and Sabteca. The descendants of Raamah were Sheba and Dedan. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Another one of Cush’s descendants was Nimrod. Nimrod was the first person on earth who became a mighty warrior. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Yahweh saw that he had become (OR, caused him to become) a great hunter. That is why people say to a great hunter, “Yahweh ◄sees that you are/has caused you to be► a great hunter like Nimrod.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimrod became a king who ruled in Babylonia. The first cities over which he ruled were Babel, Erech, Accad, and Calneh. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","From there he went with others to Assyria and built the cities of Nineveh, Rehoboth-Ir, Calah, ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","and Resen. Resen was a large city between Nineveh and Calah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ham’s son, Egypt, became the ancestor of the Lud, Anam, Lehab and Naphtuh, ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pathrus, Casluh and Caphtor people-groups. The Philistine people were descended from Casluh. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ham’s youngest son, Canaan, became the father of Sidon, who was his eldest son, and Heth, his younger son. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Canaan was also the ancestor of the Jebus, Amor, Girgash, ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiv, Ark, Sin, ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arved, Zemar and Hamath people-groups. Later the descendants of Canaan dispersed over a large area. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Their land extended from Sidon city in the north as far south as Gaza town, and then to the east as far as Gerar town, and then farther east to Sodom, Gomorrah, Admah, and Zeboiim towns, and even as far as Lasha town. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Those are the descendants of Ham. They became groups that had their own clans, their own languages, and their own land. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shem, the older brother of Japheth, became the father of Eber, and the ancestor of all the descendants of Eber. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","The sons of Shem were Elam, Asshur, Arphaxad, Lud, and Aram. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","The sons of Aram were Uz, Hul, Gether, and Mash. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arphaxad became the father of Shelah. Shelah became the father of Eber. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber became the father of two sons. One of them was named Peleg, which means ‘division’, because during the time he lived, people on MTY the earth became divided and scattered everywhere. Peleg’s younger brother was Joktan. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan became the ancestor of Almodad, Sheleph, Hazarmaveth, Jerah, ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havilah, and Jobab. All those people were descended from Joktan. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","The areas in which they lived extended from Mesha westward to Sephar, which is in the ◄hill country/area that has a lot of hills►. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","They are descendants of Shem. They became groups that had their own clans, their own languages, and their own land. ");
INSERT INTO eng_t4t_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","All those groups descended from the sons of Noah. Each group had its own ◄genealogy/record of people’s ancestors► and each became a separate ethnic group. Those ethnic groups formed after the flood and spread all around the earth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","At first, all the people in MTY the world spoke the same language DOU. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","As people moved further east, they arrived at a plain in Babylonia region and began to live there. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Then they said to each other, “◄Hey/Come on►, let’s form bricks and bake them to make them hard, for building!” So they used bricks instead of stones, and used tar instead of ◄mortar/a mixture of cement, sand and lime► to hold them together. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","They said, “Hey, let’s build a city for ourselves! We also ought to build a very high tower that reaches up to the sky! In that way we will become famous! If we do not do this, we will be scattered all over the earth!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","So they began to build the city and the tower. Then Yahweh looked down and saw the city and the tower that those puny men were building. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Yahweh said, “These people are one group that all speak the same language. If they have begun to do this now, then ◄there is nothing that they will decide to do that will be impossible for them/they will be able to do whatever they decide to do► LIT! ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","So, okay/now, we will go down there and cause there to be many different languages, so that they will not be able to understand each other.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","So Yahweh did that. As a result, the people stopped building the city, and Yahweh caused them to disperse all over the earth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","The city was called Babel which means ‘confusion’, because there Yahweh caused the people to become confused because the people MTY spoke different languages that the others could not understand, not just one language. From there Yahweh caused them to disperse all over the earth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","◄This is a bigger list/I will now tell you more► of the descendants of Shem: Two years after the flood, when Shem was 100 years old, he became the father of Arpachshad. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","After Arpachshad was born, Shem lived 500 more years and had more sons and daughters. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","When Arphachshad was 35 years old, he became the father of Shelah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","After Shelah was born, Arpachshad lived 403 more years and became the father of more sons and daughters. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","When Shelah was 30 years old, he became the father of Eber. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","After Eber was born, Shelah lived 403 more years and became the father of other sons and daughters. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","When Eber was 34 years old, he became the father of Peleg. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","After Peleg was born, Eber lived 430 more years and became the father of other sons and daughters. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","When Peleg was 30 years old, he became the father of Reu. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","After Reu was born, Peleg lived 209 more years and became the father of other sons and daughters. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","When Reu was 32 years old, he became the father of Serug. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","After Serug was born, Reu lived 207 more years and became the father of other sons and daughters. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","When Serug was 30 years old, he became the father of Nahor. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","After Nahor was born, Serug lived 200 more years and became the father of other sons and daughters. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","When Nahor was 29 years old, he became the father of Terah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","After Terah was born, Nahor lived 119 more years and became the father of other sons and daughters. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","When Terah was 70 years old, his son Abram was born. Later, two other sons, Nahor and Haran were born. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","◄This is/I will now give► a list of the descendants of Terah: Terah’s sons were Abram, Nahor, and Haran. Haran’s son was named Lot. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran died before his father died. He died in Ur city in Chaldea land, where he was born. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram and Nahor both married. Abram’s wife was named Sarai, and Nahor’s wife was named Milcah. Milcah and her younger sister Iscah were the daughters of Haran. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai was unable to bear any children. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah decided to leave Ur and go to live in Canaan land. So he took his son Abram and his grandson Lot, the son of Haran, and Abram’s wife Sarai with him. But instead of going to Canaan, they stopped at Haran town and lived there. ");
INSERT INTO eng_t4t_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","When Terah was 205 years old, he died there in Haran. ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Then Yahweh said to Abram, “Leave this country where you are now living. Leave your father’s clan and his family. Go to a land that I will show you. ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","I will cause your descendants to become a large nation. I will bless you and cause you to become ◄famous/highly esteemed►. What I do for you will be a blessing to others. ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","I will bless those who ◄bless/ask God to do good things for► you, and I will ◄curse/ask God to punish► those who do evil things to you. And because of what you do, groups of people all over the earth will receive blessings (OR, people will wish that God will bless others as much as he has blessed you).” ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","So Abram left Haran town, as Yahweh told him to do. Abram was 75 years old when he left there along with his wife, Sarai, and his nephew, Lot. ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram also took along all the possessions and slaves that they had accumulated/acquired in Haran town, and they left there and went to Canaan land. ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","In Canaan they traveled as far as Shechem town and camped by a huge tree called the tree of Moreh. The Canaan people-group were still living in that land. ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Then Yahweh appeared to Abram and said to him, “I will give this land to your descendants.” Then Abram built a stone altar to offer a sacrifice to Yahweh because Yahweh had appeared to him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","From Shechem, Abram and his family traveled to the hills that were east of Bethel town. Bethel town was to the west of where they set up their tent, and Ai town was further to the east. There he built another stone altar and offered a sacrifice and worshiped Yahweh there. ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Then they left there and started traveling south to the Negev Desert. ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","There was ◄a famine/very little food to eat► in Canaan, so they went south to live in Egypt for a while. ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Just as they were about to enter Egypt, Abram said to his wife Sarai, “Listen, I know that you are a very beautiful woman. ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","When the people in Egypt see you, they will say, ‘This woman is his wife!’ and they will kill me in order to get you, but they will not kill you. ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","So I ask you to tell them that you are my sister, so that because of you telling them that, they will ◄spare my life/not kill me►.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","And as soon as they arrived in Egypt, the people in Egypt saw that his wife was indeed very beautiful. ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","When the king’s officials saw her, they told the king how beautiful she was. And they took her to the king’s palace. ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","The king treated Abram kindly because of Sarai, and he gave Abram many sheep and cattle and donkeys and male and female slaves and camels. ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","But because the king had taken Sarai, Abram’s wife, Yahweh caused the king and the others in his household to be inflicted with terrible diseases. ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","When the king realized why that was happening, he summoned Abram and said to him, “Why did you do this to me? Why did you not tell me that she was your wife? ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Why did you lie, saying she is your sister, with the result that I took her to be my wife? You should not have done that! So now take your wife, leave here and go!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Then the king told his officials/servants to take Abram and his wife and all his possessions out of Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","So Abram and Sarai left Egypt, and they took along all his possessions, and Lot went with them to the Negev Desert. ");
INSERT INTO eng_t4t_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram was very rich. He owned a lot of livestock, silver and gold. ");
INSERT INTO eng_t4t_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","They continued traveling from place to place from the Negev Desert toward Bethel town to the place between Bethel and Ai where they had previously set up their tents, ");
INSERT INTO eng_t4t_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","and where Abram had made a stone altar and worshiped Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot, who was traveling with Abram, also had flocks of sheep and goats and herds of cattle, and tents. ");
INSERT INTO eng_t4t_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","But they had so many animals that they could not all stay in the same area. There was not enough land to provide water and food for all their animals. ");
INSERT INTO eng_t4t_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Furthermore, the descendants of Canaan and Perizzi were also living in that area, and the land really belonged to them. And the men who took care of Abram’s animals started quarreling with the men who took care of Lot’s animals. ");
INSERT INTO eng_t4t_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","So Abram said to Lot, “Since we are close relatives, it is not good for us two to quarrel, or for the men who take care of your animals to quarrel with the men who take care of my animals. ");
INSERT INTO eng_t4t_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","There is plenty of land for both of us. So we should separate. You can choose whatever part you want RHQ. If you want the area over there, I will stay here. If you want the area here, I will go over there.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot looked around toward Zoar town, and saw that there was plenty of water all over the plain near the Jordan River. It was like the park/garden in Eden, and like the land in Egypt. That was before Yahweh destroyed the cities of Sodom and Gomorrah which were on that plain. ");
INSERT INTO eng_t4t_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","So Lot chose the land in the plain of the Jordan River. He left his uncle, Abram, and moved east. ");
INSERT INTO eng_t4t_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram stayed in the Canaan area, and Lot started to live near the cities in the plain of the Jordan River, and he set up his tents near Sodom city. ");
INSERT INTO eng_t4t_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","You need to know that people who lived there were extremely wicked. ");
INSERT INTO eng_t4t_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","After Abram and Lot separated, Yahweh said to Abram, “Look around at this whole area where you are. Look north and south, look east and west. ");
INSERT INTO eng_t4t_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","I will give to you and your descendants all the land that you see; I will give it to you forever. ");
INSERT INTO eng_t4t_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","I will cause your descendants to be as numerous as particles of dust! It will be easier to count the particles of dust than it will be to count your descendants HYP. ");
INSERT INTO eng_t4t_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Walk through the land in every direction, because I am going to give it all to you.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","So Abram and his men took down their tents and moved to Hebron and started to live by the huge trees at the town of Mamre. He placed a stone altar there to make sacrifices to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","In a region to the east, there were four kings who were friends/allies. They were King Amraphel of Babylonia, King Arioch of Ellasar, King Chedorlaomer of Elam, and King Tidal of Goiim. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","In an area to the west, there were five other kings. They were King Bera of Sodom, King Birsha of Gomorrah, King Shinab of Admah, King Shemeber of Zeboiim, and the king of Bela, the city that is now called Zoar. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Those five kings and their armies gathered together in Siddim Valley, which is also called the Dead Sea Valley, to fight against the four kings and their armies. King Chedorlaomer and his army conquered the armies of those five kings, and demanded that those kings pay him tribute money each year. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","For twelve years he ruled them. But during the thirteenth year they rebelled and refused to keep giving him tribute money. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","The next year, King Chedorlaomer and the other kings that were his allies took their armies and defeated the Repha people-group in Ashteroth-Karnaim and the Zuz people-group in Ham, and the Emi people-group in Shaveh-Kiriathaim. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","They also defeated the Hor people-group in the hilly area of Seir as far as El-Paran near the desert. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Then they turned back and went to Mishpat city, which is now called Kadesh. They conquered all the land belonging to the Amalek people-group and the Amor people-group who were living in Hazazon-Tamar town. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Then the armies of the kings of Sodom, Gomorrah, Admah, Zeboiim and Bela marched out to fight the armies of the other four kings in Siddim Valley. That valley is close to the Salt/Dead Sea. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","They fought against the armies of Chedorlaomer the king of Elam, Tidal the king of Goiim, Amraphel the king of Shinar, and Arioch the king of Ellasar. The armies of four kings were fighting against the armies of five kings. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","The Siddim Valley was full of tar pits. So when the armies of the kings of Sodom and Gomorrah tried to run away, many of the men fell into the tar pits. The others escaped and ran away to the hills. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","As the armies of the five kings fled, the armies of the four kings seized all of the valuable things in Sodom and Gomorrah, including all the food. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","They also captured Abram’s nephew Lot and his possessions, since he was living in Sodom at that time. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Abram was living near the big trees near Mamre, who belonged to the Amor people-group. Abram had made an agreement with Mamre and his two brothers, Eshcol and Aner, that they would help each other if there was a war. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","One of the men who escaped from the battle told Abram what had happened and that his nephew Lot had been captured and taken away. So Abram summoned 318 men who were his servants, men who had been with Abram since they were born. They all went together and pursued their enemies as far north as Dan city. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","During the night, Abram divided the men into several groups, and they attacked their enemies from various directions and defeated them. They pursued them as far as Hobah, which was north of Damascus city. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abram’s men recovered all of the goods that had been taken. They also rescued Lot and all his possessions and also the women and others who had been captured by their enemies. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","As Abram was returning home after he and his men had defeated the armies of King Chedorlaomer and the other kings who had fought alongside him, the king of Sodom went north to meet him in Shaveh Valley, which people call the King’s Valley. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","The king of Salem city, whose name was Melchizedek, was also a priest who offered sacrifices to the Supreme God. He brought some bread and wine to Abram. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Then he blessed Abram, saying “I ask the Supreme God, the one who created heaven and earth, to bless you. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","The Supreme God has enabled you to defeat MTY your enemies, so we should praise/thank him.” Then Abram gave to Melchizedek a tenth part of all the things he had captured. ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","The king of Sodom said to Abram, “You can keep all the goods you recovered. Just let me take back the people from my city whom you rescued.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","But Abram said to the king of Sodom, “I have solemnly promised MTY to Yahweh, the Supreme God, the one who created heaven and earth, ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","that I will not accept even one thread or a thong of a sandal from anything that belongs to you. As a result, you will never be able to say, ‘I caused Abram to become rich.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","The only thing I will accept is the food that my men have eaten. But Aner, Eshcol, and Mamre went with me and fought alongside me, so let them also have a share of the goods we brought back.” So the king of Sodom agreed to what he said. ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Some time later, Abram had a vision in which Yahweh spoke to him and said, “Do not be afraid of ◄anything/your enemies►. I will protect you MTY, and I will give a great reward.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","But Abram replied, “Yahweh God, how can you give me what I truly want, because I have no children, and the one who will be like a son and inherit all my possessions is my servant Eliezer from Damascus!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram added, “You have not given me any children, so think about this: A servant in my household will inherit all I own!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Yahweh replied, “No! He will not be the one who will inherit it. Instead, you yourself will be the father of the one who will inherit everything you own.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Then Yahweh took Abram outside of his tent and said, “Look up at the sky! Can you count the stars? No, you cannot count them because there are so many of them, and your descendants will be as numerous as the stars.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram believed that what Yahweh said would happen. And because of that, Yahweh considered that Abram was righteous. ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Yahweh also said to him, “I am Yahweh. I am the one who brought you from Ur in Chaldea land. I brought you here to give you this land to possess.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","But Abram replied, “Yahweh God, how can I know for sure that this land will belong to me?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","God said to him, “Bring a three-year-old heifer and a three-year-old goat to me, and a dove and a pigeon.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","So Abram brought all of them and killed them and cut each of the animals in half. He arranged the halves of each one, side by side. But he did not cut the pigeon and dove in half. ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Birds that eat dead flesh came down to eat the carcasses, but Abram shooed them away. ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","As the sun was going down, Abram fell sound asleep, and suddenly everything around him became dark and frightening. ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Then God said to Abram, “I want you to know that your descendants will become foreigners living in a land that does not belong to them. They will become slaves of the owners of that land. The owners of the land will mistreat them for 400 years. ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","But then I will punish the people of that country that made them become slaves, and then your descendants will leave that country, taking many possessions with them. ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","But as for you, you will die EUP peacefully when you are very old. ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","After your descendants have been slaves for 400 years, they will return here, and take control of this land and defeat the Amor people-group. Those people will, because those people have not yet sinned enough to deserve to be punished now.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","When the sun had set and it had become dark, unexpectedly a blazing torch and a clay pot containing burning coals from which smoke was rising appeared and went between the halves of the animals. ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","And on that day Yahweh made an agreement with Abram. Yahweh told him, “I will give to your descendants all the land between the river that is on the eastern border of Egypt to the south, and north to the huge Euphrates River. ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","That is the land where the Ken, the Keniz, the Kidmon, ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","the Heth, the Periz, the Repha, ");
INSERT INTO eng_t4t_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","the Amor, the Canaan, the Girgash, and the Tebus people-groups live.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Up to that time, Abram’s wife Sarai had not given birth to any children for Abram. But she had a female slave from Egypt, whose name was Hagar. ");
INSERT INTO eng_t4t_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","So one day Sarai said to Abram, “Listen to me! Yahweh has not allowed me to become pregnant. So ◄sleep with/have sex with► EUP my slave Hagar. Perhaps she will bear children whom I can consider to be mine.” Abram agreed to do what Sarai said. ");
INSERT INTO eng_t4t_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","So Abram ◄slept with/had sex with► Hagar, his wife Sarai’s slave from Egypt. This happened ten years after they went to live in Canaan land. Sarai gave Hagar to her husband to be his secondary wife. ");
INSERT INTO eng_t4t_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","He ◄slept with/had sex with► EUP Hagar and she became pregnant. When she realized that she was pregnant, she began to despise her mistress Sarai. ");
INSERT INTO eng_t4t_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Then Sarai said to Abram, “It is your fault! I put my servant into your arms, so that you could sleep with her EUP. Now she realizes that she is pregnant, and she despises me. I think Yahweh will punish you for doing this to me!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","So Abram said to Sarai, “You listen to me! She is your servant, so act towards her in the way you consider best.” Then Sarai started to mistreat her, so she ran away from Sarai. ");
INSERT INTO eng_t4t_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","An angel of Yahweh found her as she was near a spring of water in the desert. It was the spring that was alongside the road to Shur. ");
INSERT INTO eng_t4t_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","He said to her, “Hagar, slave of Sarai, where have you come from, and where are you going?” She replied, “I have run away from Sarai, my mistress.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","The angel said, “Go back to your mistress and be under her authority MTY”. ");
INSERT INTO eng_t4t_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","The angel also said to her, “I will enable you to bear so many descendants that no one will be able to count them!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","The angel also said to her, “Listen to this! You are pregnant. You will give birth to a son. You must name him Ishmael, which means ‘God hears’, because Yahweh has heard you crying because you feel so miserable. ");
INSERT INTO eng_t4t_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","But your son will be as uncontrollable as a wild donkey MET. He will oppose everyone, and everyone will oppose him MTY. He will live far away from his relatives SYN.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Then Hagar realized that the angel was really Yahweh, so she said to herself, “◄It is difficult to believe that I have really seen the back of Yahweh, the one who sees me!/Have I really seen the back of Yahweh, the one who sees me?►” RHQ So she called him ‘Yahweh, the one who sees me’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","That is why people call the well there ‘Beer-Lahai-Roi’, which means, ‘The well of the living one who sees us’! It is still there, between Kadesh and Bered. ");
INSERT INTO eng_t4t_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","So Hagar later gave birth to a son for Abram, and she gave to her son the name Ishmael. ");
INSERT INTO eng_t4t_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram was eighty-six years old when Hagar gave birth to Abram’s son Ishmael. ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","When Abram was 99 years old, Yahweh appeared to him again and said to him, “I am God Almighty. I want you to live in a way that I will regard you as someone that cannot be criticized. ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","If you do that, I will make an agreement with you in which I will promise to enable you to have very many descendants.” MTY ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram prostrated himself with his face on the ground. Then God said to him, ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Listen to this agreement that I am making with you: People of many nations will be your descendants. ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","And no longer will your name be Abram. Instead, your name will be Abraham, which means ‘father of many nations,’ because the people of many nations will descend from you. ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","I will enable you to have very many descendants, and I will cause them to become great nations/people-groups, and some of your descendants will become kings. ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","I will make this agreement between me and you and your descendants. It will be an everlasting agreement to be in effect for many generations. This agreement is that I will be your God, and the God of your descendants. ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","I will give to you and to your descendants the land through which you are now traveling, all of the Canaan region. It will be an everlasting possession for your descendants, and I will be the God that they will worship.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Then God said to Abraham, “Now you must obey your part of the agreement that I am making with you, and your descendants must also obey it, for all generations. ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","This is the agreement that I am making, between myself and you and all your descendants: Every male among you must be circumcised. ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","◄Cutting the foreskins of/Circumcising► them will be the sign that you have accepted the agreement I am making with you. ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Every male child among you must be circumcised when he is eight days old, in all future generations. That includes baby boys in your household or those born from slaves that have been bought, and baby boys of foreigners who live among you but do not belong to your household. ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","It does not matter whether their parents are members of your household or slaves that have been bought; they must all be circumcised. Your bodies will have this mark to show you have accepted this everlasting agreement I am making. ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","You must expel from your community any male who has not been circumcised, because by not being circumcised that person has disobeyed my agreement.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","God also said to Abraham, “As for Sarai, your wife, you must not call her Sarai any longer. Since I changed your name, I will change her name also. Her name will now be Sarah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","I will bless her, and she will surely give birth to a son for you. And I will bless her so much that she will be the ancestor of people of many nations. Kings of some people-groups will be descended from her.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham prostrated himself with his face on the ground to show respect to God. But then he laughed as he said to himself, “Can a man who is a 100 years old become a father of a son? And since Sarah is 90 years old, how can she bear a child?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Then Abraham said to God, “Perhaps you will let Ishmael receive your blessing and inherit all I possess.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Then God replied, “No! Your wife Sarah will bear a son for you. You must name him Isaac. I will establish my agreement with him, one which will be an everlasting agreement for him and his descendants. ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","As for Ishmael, I have heard what you asked me to do for him. I will bless him so that he also will have many descendants. Among his descendants will be rulers of twelve nations. And I will cause his descendants MTY to also become a great nation. ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","But Isaac, the son whom Sarah will give birth to at this time next year, is the one with whom I will establish my agreement.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","When God finished talking to Abraham, God disappeared from his sight. ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","On that same day, Abraham took his son Ishmael and all the males that were in his household, including the sons of all the slaves he had bought, and circumcised them. He cut off their foreskins, just as God told him to do. ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham was 99 years old when ◄he was circumcised/someone circumcised him►, ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","and Ishmael was thirteen years old when Abraham circumcised him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","On that very day Abraham and his son, Ishmael were circumcised. ");
INSERT INTO eng_t4t_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","And all the males in his household, the ones who had been born there and those who had been bought from foreigners, were also circumcised. ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","One day during that year when it was hot, Yahweh appeared to Abraham again near the big trees that belonged to Mamre, while Abraham was sitting in the entrance to his tent. ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abraham looked up MTY and was surprised to see three men standing near him. Actually, one was Yahweh, and the other two were angels. When he saw them, he ran to meet them. He prostrated himself with his face on the ground to show respect, ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","and said to one of them, “Sir, if you are pleased with me, stay here for a little while LIT. ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Allow my servants to bring a little water and wash your feet, and rest under this tree. ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Since you have come here to me, allow me to bring you some food SYN so that you can feel refreshed before you leave.” Yahweh replied, “All right, do as you have said.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","So Abraham quickly went into the tent and said to Sarah, “Quick, get some of our best flour and make some loaves of bread!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Then he ran to the herd of cattle and selected a calf whose meat would be tender and tasty. He gave it to one of his servants and told him to quickly kill it and cook it. ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","When the meat was cooked, Abraham brought some curds and milk and the meat that had been prepared, and set them in front of his visitors. Then he stood near them, under a tree, while they ate. ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","One of them asked him, “Where is Sarah, your wife?” He replied, “She is in the tent.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Then the leader of the group said, “I will return to you ◄about this time/in the springtime► next year, and to your amazement, your wife Sarah will have an infant son.” It happened that Sarah was listening at the entrance of the tent, which was behind the one who was speaking. ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham and Sarah were very old, and Sarah was far past the time of when she could bear children. ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","So Sarah laughed to herself, thinking, “My body is worn out, and my husband is old. So how can I have the pleasure of having a child?” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Yahweh said to Abraham, “Why did Sarah laugh? Why was she thinking, ‘I am too old, so how can I bear a child?’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","I am Yahweh! ◄Is there anything too difficult for me?/There is nothing too difficult for me!► RHQ I will return about this time next year in the springtime, and Sarah will have an infant son.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Then Sarah was afraid, so she lied and said, “I did not laugh.” But Yahweh said, “Don’t deny it! You did laugh.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","When the three men got up to leave, they looked down into the valley toward Sodom city. Abraham was walking with them to say “goodbye” to them. ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yahweh thought to himself, “It is not right for me to prevent Abraham from knowing what I plan to do RHQ. ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abraham’s descendants MTY will become a great and powerful nation. And people of MTY all nations will be blessed because of what I do for him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","I have chosen him in order that he will teach his children and their families to obey me and do what is right and fair, and then I will do for Abraham what I promised.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","So Yahweh said to Abraham, “I have heard the terrible things that have been said about the people of MTY Sodom and Gomorrah. Their sins are very great. ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","So I will go down now, and I will see if all the terrible things that I have heard are true or not true.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Then the two men turned and started walking toward Sodom. But Yahweh remained, standing in front of Abraham. ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham came closer to him and said, “Will you really destroy righteous people along with wicked ones? ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","What will you do if there are only 50 righteous people in the city? Will you really get rid of them all, and not spare the place/city for the sake of the 50 righteous people who are in the city? ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","It would certainly not be right for you to do such a thing, to kill righteous people along with wicked ones, and treat righteous people and wicked people the same way. You could not do that, because you, who are the judge of everyone on the earth, will certainly do what is right regarding the people of Sodom!” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yahweh replied, “If I find 50 righteous people in Sodom, I will spare the whole place/city for their sake.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham replied, “I should not be bold like this and speak to you, God, because I am as worthless as dust and ashes MET. ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","But what will you do if there are only 45 righteous people? Will you destroy everyone in the whole city because there are only 45 and not 50 righteous people?” Yahweh replied, “I will not destroy it if I find that there are 45 righteous people.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham continued to speak to him like this, saying, “What will you do if you find that there are only 40 righteous people there?” Yahweh replied, “I will not destroy them all, for the sake of the 40.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham said, “God, please don’t be angry now. Let me speak again. What will you do if there are only 30 righteous people?” He replied, “I will not do it if I find that there are 30 there.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham said, “I should not be bold and speak to you like this, God. But what will you do if you find that there are only 20 righteous people there?” He replied, “I will not destroy the whole city, for the sake of those 20.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abraham said, “God, don’t be angry now. Just let me speak one time more. What will you do if you find that there are only ten righteous people there?” Yahweh answered, “I will not destroy the city for the sake of those ten.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Abraham said no more, and as soon as Yahweh finished speaking with Abraham, he left, and Abraham returned home. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","That evening, the two angels arrived in Sodom. Lot was sitting at the gateway of the city. When he saw them, he got up to greet them, and prostrated himself with his face on the ground. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","He said to them, “Gentlemen, please stay in my house tonight. You can wash your feet, and tomorrow you can continue your journey.” But they said, “No, we will just sleep in the city square.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","But Lot kept insisting strongly that they sleep in his house. So they entered his house with him, and he prepared a meal for them. He baked some bread without yeast, and they ate it. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","After they finished eating, before they went to bed, the men of Sodom city, all of them, from the young ones to the old ones, surrounded the house. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","They called out to Lot, saying, “Where are the men who came to your house this evening? Bring them out, so that we can have sex with them!” EUP ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot went outside the house and shut the door behind him, so that they could not go inside. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","He said to them, “My friends, don’t do such an evil thing! ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Listen to me. I have two daughters who have never had sex with any man. Let me bring them out to you now, and you can do with them whatever pleases you. But don’t do anything to these men, because they are guests in my house, so I must protect them!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","But they replied, “Get out of our way! You are a foreigner; so you have no right to tell us what is right! If you don’t get out of our way, we will do worse things to you than we will do to them!” Then they lunged towards Lot, and tried forcefully to break down the door. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","But the two angels opened the door carefully, reached out their hands, and pulled Lot to them inside the house. Then they quickly shut the door. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Then they caused all the men who were outside the door of the house, young and old, to become blind, so that they could not find the door. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Then the two angels said to Lot, “Who else is with you here? If you have sons or sons-in-law or daughters or anyone else in the city who is related to you, take them out of the city, ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","because we are the ones who are going to destroy this place. Yahweh considers that these people are so evil that he sent us to destroy the city.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","So Lot went and spoke to the men who had pledged to marry his daughters. He said to them, “Hurry! Get out of this city, because Yahweh is about to destroy it!” But his future sons-in-law thought he was joking. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","As it was about to dawn the next morning, the two angels urged Lot, saying, “Get up quickly! Take your wife and your two daughters who are here with you and leave! If you don’t, you will die when we destroy/Yahweh destroys the city!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","When Lot hesitated, the angels grasped his hand and his wife’s hand and the hands of his two daughters. They led them outside the city safely. The angels did that because Yahweh was acting mercifully toward them. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","When they were outside the city, one of the angels said, “If you want to remain alive, run away quickly! Don’t look back! And don’t stop anywhere in the valley! Flee to the hills! If you don’t, you will die!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","But Lot said to one of the angels, “No, sir, don’t make me do that! ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Please, listen. You have been pleased with me and have been very kind to me and spared my life. But I cannot flee to the mountain. If I try to do that, I will die in this disaster PRS. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","But listen to me. There is a town nearby. Let me run to that small town. Let me go there now. It is a small town, but our lives will be saved if we go there.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","One of the angels said to Lot, “I will allow you to do what you have requested MTY. I will not destroy the little town you are speaking about. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","But hurry! Run there, because I cannot destroy anything until you arrive there.” People later called the name of the town Zoar which means ‘small’, because Lot said it was small. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","As the sun was rising, Lot and his family arrived in the town which is now called Zoar. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Then Yahweh caused fire and burning sulfur to fall down on Sodom and Gomorrah like rain. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","In that way, he destroyed those cities and all the people who were living in those cities. He also destroyed everything in the valley, including all the plants/vegetation. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","But Lot’s wife stopped and looked back to see what was happening, so she died, and her body later became a pillar of salt. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","That morning, Abraham got up and went to the place where he had stood in front of Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","He looked down toward Sodom and Gomorrah, and he was surprised to see that all over the valley, smoke was rising, like the smoke of a huge furnace. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","So, when God destroyed those cities in the valley, he remembered what he had promised Abraham, and he rescued Lot from the disaster that occurred in the cities where Lot had lived. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot was afraid to stay in Zoar, so he left there and moved with his two daughters to the mountain, and they lived in a cave. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","One day the older daughter said to ◄the younger daughter/her sister►, “Our father is old, and there is no man in this area who can have sex EUP with us, as people all over the earth do. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Let’s make our father drink wine until he gets drunk. Then we can have sex with him EUP without him knowing it. In that way he will cause us to become pregnant and we can bear children.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","So that night they caused their father to become drunk. And the older daughter went in and lay in bed with her father, and he had sex with her, but he was so drunk that he did not know when she lay down with him or when she got up. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","The next day, his older daughter said to ◄his younger daughter/her sister►, “Listen to me. Last night I slept with our father. Let’s cause him to become drunk again tonight! This time you can go and sleep with him. If he has sex with you, you can become pregnant, and that way you can have a child, too.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","So that night, they caused their father to become drunk with wine again, and then his younger daughter went and slept with him. But again, he was so drunk that he did not know when she lay down with him or when she got up. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","So Lot caused his two daughters to become pregnant. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","The older one later gave birth to a son, whom she named Moab. He became the ancestor of the Moab people-group. ");
INSERT INTO eng_t4t_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","The younger one also gave birth to a son, whom she named Ben-Ammi. He became the ancestor of the Ammon people-group. ");
INSERT INTO eng_t4t_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham left Mamre and moved southwest to the Negev desert and lived in a place named Gerar, between Kadesh and Shur. ");
INSERT INTO eng_t4t_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","While he was there, he told people that Sarah was his sister, not his wife. Then King Abimelech of Gerar sent some of his men to Sarah, and they brought her to him to be his wife. ");
INSERT INTO eng_t4t_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","But God appeared to Abimelech in a dream during the night and said to him, “Listen to me! You are going to die because the woman you took is another man’s wife.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","But Abimelech had not had sex EUP with her, so he said, “God, since the people of my nation and I am innocent; will you kill me? ");
INSERT INTO eng_t4t_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","He told me, ‘She is my sister,’ and she also said, ‘He is my brother.’ I did this with pure motives and I SYN have not done anything wrong yet.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","God said to him in another dream, “Yes, I know that your motives were pure. That is why I truly prevented you from sinning against me. I did not allow you to have sex EUP with her. ");
INSERT INTO eng_t4t_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Now, return this man’s wife to her husband, because he is ◄a prophet/a man who receives messages from me►. He will pray for you, and you will ◄remain alive/not die►. But if you do not return her to him, you will certainly die, and all the members of your household will also certainly die.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Early the next morning, Abimelech summoned all his officials, and told them everything that had happened. When they heard that MTY, his men were very afraid that God would punish them. ");
INSERT INTO eng_t4t_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimelech then summoned Abraham, and said to him, “You should not have done that to us RHQ! Did I do something wrong to you, with the result that you are causing me and the people in MTY my kingdom to be guilty of committing a great sin RHQ? You have done things to me that ◄should not be done/you should not have done►!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelech asked Abraham, “What was your reason for doing this?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham replied, “I said that because I thought, ‘They certainly do not respect God in this place. If they don’t respect God, they will not respect relationships with others. If I say she is my sister, they will try to pay me a bride price to get her. But if I say she is my wife, they will kill me to get her.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Besides, she really can be considered my sister, because she is the daughter of my father, although she is not the daughter of my mother. She is the daughter of another woman, and I married her. ");
INSERT INTO eng_t4t_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Later, when God told me to move away from my father’s household, I said to her, ‘This is the way you can show that you love me: Everywhere we go, say about me, “This is my brother.”’” ");
INSERT INTO eng_t4t_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","So Abimelech brought some sheep and cattle and male and female slaves and gave them to Abraham. And he returned his wife Sarah to him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","And Abimelech said to him, “Look! All my land is here in front of you. Live in whatever place you like!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","And he said to Sarah, “Look here, I am giving 1,000 pieces of silver to your brother. This is to insure that no one will bring up this matter again and say that I have done something wrong. EUP, IDM” ");
INSERT INTO eng_t4t_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Then Abraham prayed to God, and God healed Abimelech’s wife and his slave girls so that they could become pregnant. ");
INSERT INTO eng_t4t_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","This was because Yahweh had caused it to be impossible for any of the women in Abimelech’s household to bear children, because Abimelech had taken Abraham’s wife Sarah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yahweh was very kind to Sarah, just as he said he would be. He did for Sarah exactly what he promised to do. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","She became pregnant and gave birth to a son for Abraham when he was very old, at the time God promised it would happen. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham gave the name ‘Isaac’ (which means ‘he laughs’) to the son Sarah gave birth to. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abraham circumcised his son Isaac when his son was eight days old, just as God commanded him to do. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham was 100 years old when his son Isaac was born. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","And Sarah said, “Although I was sad before because I did not have any children, God has now enabled me to laugh, and everyone who hears about what God has done for me will laugh with me.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Then she also said, “No one would have said to Abraham that some day Sarah would nurse a child, but I have given birth to a son when Abraham is very old.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","The baby grew and was weaned when he was about three years old. On that day, Abraham prepared a large feast to celebrate. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","◄One day/During the feast► Sarah noticed that Hagar’s son Ishmael was ◄making fun of/playing with► Isaac. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","So she said to Abraham, “Get rid of that slave woman from Egypt and her son! I do not want the son of that slave woman to be alone (OR, to be an heir along with) my son, Isaac!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraham was very distressed about the matter, because he was concerned about his son Ishmael. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","But God said to Abraham, “Do not be distressed about your son, Ishmael, and about your maidservant, Hagar. Do everything that Sarah tells you to do. Listen to her, because Isaac is the one who will be considered the ancestor of the descendants I promised to give you. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","But I will also cause the son of your maidservant to be the ancestor of the people of a great nation MTY, because he is also your son.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","So Abraham got up early the next morning. He got some food ready, put water in a container, and gave them to Hagar. He put them in a bag on her shoulder and sent them away. They wandered in the desert near Beersheba town. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","After they had drunk all the water in the container, she put her son under one of the bushes there. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Then she went and sat nearby, about ◄as far as someone can shoot an arrow/100 meters away►, because she thought, “I cannot endure seeing my son die!” As she sat there, she began to cry loudly MTY. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","The boy was crying too. And God heard the boy crying. So he caused one of his angels to call out from heaven to Hagar, saying, “Hagar, are you worried about something? Do not be afraid, because God has heard the boy crying there. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Help your son up, and hold his hand as you leave, because I will cause his descendants to become a great nation.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Then God showed her a well of water. So she went to the well and filled the container with water, and gave the boy a drink. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","God helped the boy as he grew up. He lived in the desert and became a good ◄archer/man who hunts with bow and arrows►. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","He lived in Paran Desert. While e was there, Hagar got a wife for him from Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","At that time, King Abimelech and Phicol, the commander of his army, said to Abraham, “It is clear that God helps you with everything that you do. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","So now ◄solemnly promise/swear► to me here, as God is listening, that you will ◄not deceive/act fairly to► me and my children and my descendants, in return for my being kind to you. Be kind to me and to all the people here in the country where you are now living.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","So Abraham promised to do that. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Then Abraham complained to Abimelech about one of Abraham’s wells that Abimelech’s servants had seized. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","But Abimelech said, “I do not know who has done that. You did not tell me previously, and I did not hear about it until today.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","So Abraham brought some sheep and gave them to Abimelech, and the two of them made a ◄treaty/peace agreement►. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham separated seven female lambs from his flock. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelech asked Abraham, “What are these seven female lambs that you have separated from the rest of your flock?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham replied, “I want you truly to accept these female lambs from me SYN, so that it may be a ◄public witness/proof► that this well belongs to me because I dug it.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","So Abimelech accepted the animals, and as a result they called that place Beersheba, which means ‘Friendship Agreement Well’, because there the two of them made that agreement. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","After they made the agreement at Beersheba, Abimelech and his army commander, Phicol, left, and returned to the land of the Philistine people-group. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham planted a ◄tamarisk tree/kind of tree called esel► there, and he worshiped the eternal God there. ");
INSERT INTO eng_t4t_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham lived in the land of the Philistine people-group for a long time. ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Several years later, God tested Abraham to find out whether Abraham really trusted in him and would obey him. He called out to Abraham, and Abraham replied, “I’m here.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","God said, “Your son, Isaac, whom you love very much, is the only son who is still here with you. But take him and go together to the Moriah region. Offer him as a sacrifice like a burnt offering, on a hill that I will show you.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","So Abraham got up early the next morning, put a saddle on his donkey, and took with him two of his servants along with his son, Isaac. He also chopped some wood to kindle a fire for a burnt offering. Then they started traveling to the place God told him about. ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","On the third day of their travels, Abraham looked up and saw in the distance the place where God wanted him to go. ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abraham said to his servants, “You two stay here with the donkey while the boy and I go over there. We will worship God there, and then we will come back to you.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Then Abraham took the wood to kindle a fire for the burnt offering and placed it on his son Isaac, for him to carry. Abraham carried in his hand a pan containing burning coals to start a fire, and a knife, and the two of them walked along together. ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Then Isaac spoke to his father Abraham, saying, “My father!” Abraham replied, “Yes, my son, I’m here!” Isaac said, “Look, we have wood and coals to light a fire, but where is the lamb for the burnt offering?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham replied, “My son, God himself will provide the lamb for the burnt offering.” So the two of them continued walking along together. ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","They arrived at the place God had told him about. There, Abraham built a stone altar and arranged the wood on top of it. Then he tied his son Isaac, and laid him on the altar on top of the wood. ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Then Abraham took the knife and reached out to kill his son. ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","But an angel who was really Yahweh called to him from heaven and said, “Abraham! Abraham!” Abraham replied, “I’m here!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","The angel said, “Do not harm the boy or do anything to injure him, because now I know that you respect and obey God. I know that because you have not refused to sacrifice your son, the only son who is still with you.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Then Abraham looked up and saw that a ram was nearby, whose horns had been caught in a ◄thicket/clump of bushes►. So Abraham went over and grabbed the ram and killed it, and sacrificed it on the altar as a burnt offering, instead of his son. ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham named that place ‘Yahweh will provide’. And to the present day, people say, “On Yahweh’s mountain, he will provide.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","The angel who was really Yahweh called out to Abraham from heaven a second time. ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","He said, “I, Yahweh your Lord, am telling you that you did what I told you, and you have not refused to sacrifice your only son that is with you. So I say, ‘I solemnly swear, with myself as my witness, ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","that some day your descendants will be as numerous as the stars in the sky and the grains of sand on the seashore. And your descendants will defeat their enemies and capture their cities SYN.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","You obeyed me, so by means of your descendants the people of all the nations on the earth will be blessed.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Then Abraham and Isaac returned to where his servants were waiting, and they went back home together to Beersheba, and Abraham stayed there. ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","After these things happened, someone told Abraham, “Your brother Nahor’s wife, Milcah, has also given birth to children. She has eight sons.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","The oldest son was Uz. The next was Buz. After him was Kemuel, the father of Aram. ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","After Kemuel was Kesad, then Hazo, then Pildash, then Jidlaph, then Bethuel, ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","who was the father of Rebekah, who later became Isaac’s wife. Those were the eight sons of Milcah, wife of Abraham’s brother, Nahor. ");
INSERT INTO eng_t4t_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahor also had a ◄concubine/female slave whom he took as a wife►, whose name was Beumah. She gave birth to four sons: Tebah, Gaham, Tahash, and Maacah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","When Sarah was 127 years old, ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","she died at Kiriath-Arba town, which is now called Hebron, in the Canaan region. After Abraham mourned for her, ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","he left the body of his wife and went and spoke to some of the descendants of Heth, saying, ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“I am a foreigner DOU living among you, so I do not own any land here. Sell me some land here so that I can bury my wife’s body.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","They replied to him, ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Sir, you are a powerful prince among us. Choose one of our finest tombs and bury your wife’s body in it. None of us will refuse to sell land to you for a tomb for your relatives’ bodies.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Then Abraham stood up and bowed in respect in front of the people who owned the land, the descendants of Heth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","He said to them, “If you say that you are willing for me to bury my wife’s body here, listen to me, and ask Ephron, the son of Zohar for me, ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","to sell to me the cave in the Machpelah area, which is at the end of his field. Ask him to sell it to me for the full price he wants, so that I can have a burial ground among you.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ephron was sitting among the people near the city gate where many HYP descendants of Heth had gathered. He heard what Abraham said to them. ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","So, just to make the customary reply to start the real discussion about a price, Ephron said, “No, sir, listen to me. I will give to you the field and the cave in it, without charge, with the people here as witnesses.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham again bowed before the people who lived in the area, ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","and said to Ephron, as all the others were listening, “No, listen to me. If you are willing, I will pay for the field. You tell me what the price is, and I will give it to you. If you accept it, the field will become mine, and I can bury my wife’s body there.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ephron answered Abraham, saying to him, ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Sir, listen to me. The land is worth 400 pieces of silver. But the price is not important to you and me. Give me the money and bury your wife’s body there.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham agreed with Ephron about the price, and weighed for Ephron the 400 pieces of silver he had suggested, as everyone was listening, using the standard weights for silver used in that area by people who sold things. ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","So Ephron’s field in the Machpelah area, near Mamre, and the cave in the field, and all the trees that were in the field inside the boundaries of the land, became Abraham’s possession. ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","It became Abraham’s property as all the descendants of Heth were listening there at the city gate. ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","After that, Abraham buried his wife Sarah’s body in the cave in the field in the Machpelah area near Mamre, which is now called Hebron city, in the Canaan region. ");
INSERT INTO eng_t4t_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","So the field and the cave in it were officially sold to Abraham by the descendants of Heth, to be used as a burial ground. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham was now a very old man. Yahweh had blessed Abraham in many ways. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","One day Abraham said to the chief servant of his household, the man who was in charge of everything Abraham owned, “Put your hand between my thighs to solemnly promise you will do what I tell you. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Knowing that Yahweh God who created the heavens and the earth is listening, promise that you will not get a wife for my son, Isaac, from the women here in Canaan. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Instead, go back to my country and to my relatives and get a wife for my son Isaac from among them.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","The servant asked him, “If I find a woman among your relatives, what if she is not willing to come back with me to this land? Shall I take your son back there to the country you came from, so he can find a wife and live there?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham replied to him, “No! Be certain that you don’t take my son there! ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yahweh God, who created the heavens, brought me here. He brought me from my father’s household, and from the land where my relatives lived. He spoke to me and made a solemn promise to me, saying, ‘I will give this land of Canaan to your descendants.’ He will send an angel who will go there ahead of you, and enable you to get a wife for my son there and bring her to live here. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","But if the woman you find will not come back with you, you are free to disregard the promise you are making. The only thing that you must not do is to take my son to live there!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","So the servant put his hand between Abraham’s thighs and made a solemn promise about the matter. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Then the servant took ten of his master’s camels and loaded them with all kinds of goods that his master gave him to take along. Then he left to go to Aram-Naharaim, which is in ◄northern Mesopotamia/Syria►. He arrived in Nahor city. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","It was late in the afternoon, at the time when the women go to the well to get water, when he arrived there. He made the camels kneel down near the well, which was outside the city. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","The servant prayed, “Yahweh God whom my master Abraham worships, enable me to be successful today! Act kindly to my master, Abraham! ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Listen to me. I am standing near a well of water, and the young women of the city are coming to get water. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","I am asking you this: ‘I will say to some girl, “Please lower your jar so that I may drink some water.” If she says, “Drink some, and I will draw some water from the well for your camels, too,” I will know that she is the woman whom you chose to be a wife for your servant, Isaac, and I will know that you have been kind to my master.’” ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Before he finished praying, amazingly, Rebekah arrived there, carrying a jar on her shoulder. She was the daughter of Bethuel, who was the son of Milcah, the wife of Abraham’s younger brother Nahor. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","She was very beautiful and still a virgin. She went down to the edge of the well, filled her jar with water, and then came back up. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Abraham’s servant immediately ran to meet her, and said, “Please give me a little water from your jar.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","She replied, “Drink some, sir!” She lowered her jar from her shoulder to her hands and gave him a drink. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","After she had finished giving him a drink, she said, “I will also get some water for your camels, until they have had enough to drink.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","She quickly emptied the water in her jar into the trough for giving water to animals, and then ran back to the well, and kept getting water for all the camels. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","The servant just watched her, without saying anything. He wanted to know if Yahweh had caused his trip to be successful or not. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Finally, after the camels finished drinking, the servant took out a gold nose ring that weighed ◄two ounces/6 grams►, and two large gold bracelets for her arms, and gave them to Rebekah and told her to put them on. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Then he said, “Tell me whose daughter you are. Also, tell me, is there room in your father’s house for me and my men to sleep there tonight?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","She replied, “My father’s name is Bethuel. He is the son of Nahor and his wife Milcah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Yes, we have room where you all can sleep tonight, and we also have plenty of straw and grain to feed the camels.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","The servant bowed and worshiped Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","He said, “I thank you, Yahweh God, whom my master Abraham worships. You have continued to be kind and faithful to my master. You led me on this journey straight/directly to the house of my master’s relatives!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","The girl ran and told everyone in her mother’s household about what had happened. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebekah had a brother whose name was Laban. Laban went quickly to Abraham’s servant, who was still by the well. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","He was surprised to have seen the bracelets on his sister’s arms and the nose ring and to have heard Rebekah tell what the man had said to her. So he went out and saw the man standing near the camels, close to the well. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","He said to the man, “You who have been blessed by Yahweh, come with me! ◄Why are standing out here?/You should not keep standing out here!► RHQ I have prepared a room for you in the house, and a place for the camels to stay.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","So the servant went to the house, and Laban’s servants unloaded the camels, and brought straw and grain for the camels, and water for him and the men with him to wash their feet. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","They set food in front of him for him to eat, but he said, “I will not eat until I tell you ◄what I need to tell you/why I have come►.” So Laban said, “Tell us!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","So the servant said, “I am Abraham’s servant. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yahweh has greatly blessed my master so that he has become very rich. Yahweh has given him many sheep and cattle, a lot of gold and silver, male and female servants, camels and donkeys. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","My master’s wife, Sarah, bore a son for him when she was very old, and my master has given to his son everything he owns. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","My master made me solemnly promise, saying, ‘Do not get a wife for my son from the women here in Canaan. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Instead, go back to my father’s family, to my own clan, and get from them a wife for my son.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Then I asked my master, ‘What shall I do if the woman you show me will not come back with me?’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","He replied, ‘Yahweh, whom I have always obeyed MTY, will send his angel with you, and he will cause your journey to be successful, with the result that you can get a wife for my son from my clan, from my father’s family. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","But if my clan refuses to allow her to return with you, you will be freed from being cursed because of not obeying me.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“When I came today to the well, I prayed, ‘Yahweh God whom my master, Abraham worships, if you are willing, please allow this journey of mine to be successful. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Listen to me. I am standing beside a well. A young woman may come to draw water. I will say to her, “Please, give me a little water to drink from your jar.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","If she says to me, “Certainly, drink some! And I will also draw some water for your camels,” that will be the woman whom you have chosen for my master’s son!’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Before I finished praying, amazingly, Rebekah approached with her water jar on her shoulder. She went down to the well and got some water. I said to her, ‘Please give me a drink!’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","She quickly lowered her jar and said, ‘Drink some! And I will draw water from the well for your camels, too.’ So I drank some water, and she also got water for the camels. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Then I asked her, ‘Whose daughter are you?’ She said, ‘The daughter of Bethuel, the son of Nahor and his wife, Milcah.’ I had a ring and bracelets with me, and I put the ring in her nose and put the bracelets on her arms. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Then I bowed and worshiped Yahweh, and I thanked Yahweh God, the one my master Abraham worships, the one who led me on the right road to get the granddaughter of my master’s brother to be a wife for my master’s son. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Now, if you are kind and faithful to my master, tell me that you will do what I am asking. If you will not do that, tell me that also, so I may know what to do MTY.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban and Bethuel answered, “It is clear that Yahweh has caused this to happen. So we two cannot say anything more. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebekah is here in front of you. Take her and go, and let her be a wife for your master’s son, just as Yahweh has indicated.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","When Abraham’s servant heard these words, he bowed down to the ground to thank Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Then the servant brought out silver and gold jewelry and clothes, and gave them to Rebekah. And he gave gifts to her brother Laban and to her mother. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Then they ate a meal together. The men who were with Abraham’s servant also slept there that night. The next morning, the servant said, “Allow me now to return to my master.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","But her brother and her mother replied, “Let the girl remain with us for about ten days. After that, you may take her and go.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","But he replied to them, “Yahweh has made my journey successful, so do not detain me. Let me take her back to my master now!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","They said, “Let’s call Rebekah and ask her what she wants to do.” MTY ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","So they summoned Rebekah and asked her, “Will you go with this man now?” She replied, “Yes, I will go.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","So they allowed Rebekah, a woman who had taken care of her when she was very young, Abraham’s servant, and the men who had come with him. to go. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Before they all left, they asked God to bless Rebekah, and said to her, “Our sister, we ask that Yahweh will cause you to have millions of descendants, and allow them to completely defeat MET all those that hate them.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Then Rebekah and her maid servants got ready and got on their camels and went with Abraham’s servant. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","At that time, Isaac was living in the Negev desert. He had gone there from Beer-Lahai-Roi. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","One evening he went out into the field to meditate as he walked. He looked up and was surprised to see some camels coming. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekah also looked up and saw Isaac. She got off the camel, ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","and asked the servant, “Who is that man who is approaching?” The servant replied, “That is Isaac, my master, the man you will be marrying.” So she took her veil and covered her face, which was the custom for a woman who was about to be married. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","The servant told Isaac everything that had happened. ");
INSERT INTO eng_t4t_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Then Isaac took Rebekah into the tent that belonged to his mother, Sarah, and she became his wife. And he loved her. So Isaac was comforted about his mother’s death. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Some time after Sarah died, Abraham married another woman, whose name was Keturah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","She later gave birth to six sons: Zimran, Jokshan, Medan, Midian, Ishbak, and Shuah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan became the father of two sons, Sheba and Dedan. The descendants of Dedan were the Asshur people-group, the Letush people-group, and the Leum people-group. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","The sons of Midian were Ephah, Epher, Hanoch, Abida, and Eldaah. They were all descendants of Keturah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham declared that after he died, Isaac would inherit everything he owned. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","But while Abraham was still living, he gave gifts to the sons of his ◄concubines/slaves that he had taken to be his secondary wives►, and then he sent them away to live in a land to the east, to keep them far from his son Isaac. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham lived until he was 175 years old. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","He died at a very old age, joining his ancestors who had died previously DOU. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","His sons Isaac and Ishmael buried his body in the cave at Machpelah area, near Mamre, in the field that Abraham had previously bought from Ephron, one of the descendants of Heth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Isaac and Ishmael buried his body there, where Abraham previously buried his wife Sarah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","After Abraham died, God blessed his son Isaac. And Isaac moved to live near Beer-Lahai-Roi. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","◄These are/I will now give a list of► the descendants of Abraham’s son, Ishmael, to whom Sarah’s female slave, Hagar from Egypt, had given birth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","These are their names, in the order in which they were born: Ishmael’s oldest son was named Nebaioth. After him were born Kedar, Adbeel, Mibsam, ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massa, ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, Tema, Jetur, Naphish, and Kedemah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","The twelve sons of Ishmael became the leaders/chiefs of people-groups that had those names. They each had their own settlement and campsite. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishmael lived until he was 137 years old. Then he died, EUP joining his ancestors who had previously died. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","His descendants ◄settled/went to live► in the area between Shur and Havilah, near the border of Egypt as a person travels toward Asshur. All of their camps were close to each other (OR, they all frequently attacked each other). ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","◄This is an account of/I will now tell you about► Abraham’s son, Isaac. Abraham became the father of Isaac, ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","and when Isaac was 40 years old, he married Rebekah, the daughter of Bethuel. Bethuel was one of the descendants of Aram from Paddan-Aram. Rebekah was the sister of Laban, who belonged to the Aram people-group. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Almost 20 years after they were married, Rebekah still had no children. So Isaac prayed to Yahweh concerning his wife, and Yahweh answered his prayer. His wife Rebekah became pregnant. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","She was carrying twins in her womb, and they kept jostling each other. So she said, “Why is it that this is happening to me?” So she asked Yahweh about it. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yahweh said to her, “The older one of your twins will serve the younger one. The twins will be ancestors of two nations. And those two people-groups will separate from each other.” CHI ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","When Rebekah gave birth, it was true! Twin boys were born! ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","The first one born was red, and his body had hair all over it, like a garment made of hair. So they named him Esau, which sounds like the Hebrew word that means ‘hairy'. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Then his brother was born, grasping Esau’s heel. So they named him Jacob, which sounds like the Hebrew word that means ‘heel’. Isaac was 60 years old when the twins were born. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","When the boys grew up, Esau became a skilled hunter. He spent a lot of time out in the fields. Jacob was a quiet man who stayed close to the campsite. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaac liked Esau more, because he enjoyed the taste of the meat of the animals that Esau killed. But Rebekah liked Jacob more. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","One day while Jacob was cooking some stew, Esau came home from the field, very hungry. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","He said to Jacob, “Give me some of that red stew to eat right now, because I am very hungry!” That is why Esau’s other name was Edom, which sounds like the Hebrew word that means ‘red’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacob said, “I will give you some if you sell me ◄your birthright/the privileges you have because you are the firstborn son►.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau replied, “Well, I am about to die from being so hungry. If I die now, ◄my birthright will not benefit me./What good will my birthright be to me?►” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jacob said, “◄Swear to/Solemnly promise► me that you are giving me the privileges that you will have from being the firstborn son!” So that is what Esau did. He sold his birthright to Jacob. ");
INSERT INTO eng_t4t_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Then Jacob gave to Esau some bread and some stew made of lentils/beans. Esau ate and drank, and then he got up and left. By doing that, Esau showed that he ◄was not interested in/did not value► the privileges that would be his because of being the firstborn son. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Some time later there was a severe ◄famine/scarcity of food► there. That was different from the famine that occurred when Abraham was alive. So Isaac went southeast to Gerar town, to talk to Abimelech, the king of the Philistine people-group. What happened was this: Isaac considered going to Egypt, ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","but Yahweh appeared to him and said, “Do not go down to Egypt! Live in the land where I will tell you to go! ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Stay in this land for a while, and I will help you and bless you, because it is to you and your descendants that I will give all these lands, and I will do what I solemnly promised to your father. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","I will cause your descendants to be as numerous as the stars in the sky. I will give to your descendants all these lands, and I will cause your descendants to be a blessing to the people of MTY all nations on the earth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","I will do that because your father Abraham obeyed me. He obeyed everything that I told him to do, everything that I declared and all the laws that I gave him.” So Isaac went and asked King Abimelech if he would permit him to live in the Gerar area. The king said, “Okay,” ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","so Isaac stayed there along with his wife and sons. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","When the men in Gerar town asked who Rebekah was, Isaac said, “She is my sister.” He said that because he was afraid to say, “She is my wife.” He thought, “Rebekah is very beautiful, so they will want her. If I say that she is my sister, they know they will have to negotiate about a bride price because I am her older brother; but if I say that she is my wife, no negotiation will be possible. They will just kill me to get her.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","When Isaac had been there a long time, one day Abimelech, the king of the Philistine people-group, looked down from a window in his palace and was surprised to see Isaac caressing his wife Rebekah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","So Abimelech summoned Isaac and said to him, “Now I realize that she is really your wife! So why did you say, ‘She is my sister’?” Isaac replied to him, “I said that because I thought that someone here might kill me to get her.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelech said, “◄You should not have done this to us!/Why did you do this?► RHQ One of our people might have ◄had sex with/slept with► EUP your wife, and you would have caused us to be guilty of a great sin!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Then Abimelech commanded all his people, saying, “Do not harm/molest this man or his wife! Anyone who does that will surely be executed!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaac planted grain in that land that year, and he harvested a very large crop, because Yahweh blessed him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Isaac continued to acquire more and more possessions, until finally he became very wealthy. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","He had large herds of sheep and goats and cattle, and many slaves. Because of that, the Philistine people envied him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","So all the wells that the servants of his father Abraham had dug during the time when he was alive, the people filled up with dirt. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Then Abimelech said to Isaac, “You people have become more numerous than we are, so I want you to get out of our area.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","So Isaac and his family moved from there. They set up their tents in Gerar Valley and started to live there. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","There were several wells in that area that had been dug when Isaac’s father Abraham was living, but Philistine people had filled them up with dirt after Abraham died. Now Isaac and his servants removed the dirt, and Isaac gave the wells the same names that his father had given to them. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isaac’s servants dug in the valley and discovered a well of fresh water. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","But other men who lived in Gerar Valley who took care of their animals argued/quarreled with the men who took care of Isaac’s animals, and said, “The water in this well is ours!” So Isaac named the well Esek, which means ‘dispute’, because they disputed about who owned it. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Then Isaac’s servants dug another well, but they quarreled about who owned that one also. So Isaac named it Sitnah, which means ‘opposition’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","They moved on from there and dug another well, but this time no one quarreled about who owned it. So Isaac named it Rehoboth, which means ‘uninhabited place’, saying, “Yahweh has given us an uninhabited place to live in, a place that is not wanted by other people, and we will become very prosperous here.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","From there Isaac went up to Beersheba. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","The first night that he was there, Yahweh appeared to him and said, “I am God, whom your father Abraham worshiped. Do not be afraid of anything. I will help you and bless you, and because of what I promised my servant Abraham, I will greatly increase the number of your descendants.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","So Isaac built a stone altar there and offered a sacrifice to worship Yahweh. He and his servants set up their tents there, and his servants started to dig a well. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","While they were digging the well, King Abimelech came to Isaac from Gerar, along with Ahuzzath, his advisor, and Phicol, the commander of his army. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaac asked them, “You ◄acted in a hostile way toward me/treated me like an enemy► before, and sent me away. So why have you come to me now?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","One of them answered, “We have seen that Yahweh helps you. So we said to each other, ‘We should have an agreement between us and you. We should make a peace treaty with you, ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","stating that you will not harm us, in the same way that we did not molest EUP you.’ We always treated you well and sent you away peacefully. And now Yahweh is blessing you.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","So Isaac made a feast for them, and they all ate and drank. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Early the next morning they all ◄swore/solemnly promised► each other that they would do what they had promised. Then Isaac sent them home peacefully. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","That day Isaac’s servants came to him and told him about the well that they had finished digging. They said, “We found water in the well!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isaac named the well Shibah, which sounds like the Hebrew word that means ‘oath’. To the present time the town there has the name Beersheba which means ‘Friendship Agreement Well’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","When Esau was 40 years old, he married Judith, the daughter of Beeri, and Basemath, the daughter of Elon. Both of those women were descendants of Heth, not from Isaac’s clan. ");
INSERT INTO eng_t4t_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Esau’s two wives made life miserable for Isaac and Rebekah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","When Isaac was old, he became almost blind. One day he summoned Esau, his firstborn/older son, ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","and said to him, “My son?” Esau replied, “Here I am!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Isaac said, “Listen to me. I am very old, and I do not know when I will die. So now take your bow and quiver full of arrows and go out into the countryside, and hunt for a wild animal for me. ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Kill one and prepare the kind of tasty meat that I like. Then bring it to me so that after I eat it, I can give you a blessing before I die.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebekah was listening as Isaac said that to his son, Esau. So when Esau left the tent to go to the countryside to hunt for a wild animal in order to kill it and bring it back, ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekah said to her son, Jacob, “Listen to me. I heard your father talking to your brother, Esau, saying, ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Go and kill some wild animal and bring it here, and prepare the meat in a tasty way, so that I may eat it, and then before I die I can give you my blessing while Yahweh is listening.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","So now, my son, do what I am telling you. ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Go out to the flock and kill two nice young goats and bring the meat to me. Then I will prepare some tasty food for your father, the way he likes it. ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Then you can take it to your father, in order that he can eat it, and then, before he dies, he will give his blessing to you, and not to your older brother.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","But Jacob said to his mother Rebekah, “But my brother Esau’s skin has hair all over it, and my skin is not like that! My skin is smooth! ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","What will happen if my father touches me? He will realize that I am tricking him, and as a result ◄I will be cursed/he will say that God will do bad things to► me, not a blessing!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","His mother replied, “If that happens, let the curse be on me. You do what I am telling you. Go and get the goats for me!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","So Jacob went and killed two goats and brought them to his mother. Then with the meat his mother prepared some tasty food, just the way his father liked. ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Then Rebekah took her older son Esau’s clothes that were with her in the tent, and she put them on her younger son Jacob. ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","She also put the skins of the young goats on his hands and the smooth part of his neck. ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Then she handed him some bread and the tasty food that she had prepared. ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jacob took it to his father and said, “My father!” Isaac replied, “I’m here; which of my sons are you?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacob said to his father, “I am Esau, your firstborn son. I did what you told me to do. Sit up and eat some of the meat so that you can then bless me.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","But Isaac asked his son, “My son, how is it that you were able to find and kill an animal so quickly?” Jacob replied, “Because Yahweh, whom you worship, enabled me to be successful.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaac said to Jacob, “Come near to me, my son, so that I can touch you and determine whether you are really my son Esau.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","So Jacob went close to him. Isaac. Isaac touched him and said, “Your voice sounds like Jacob, but your hands feel hairy, like the hands of your older brother, Esau.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isaac did not recognize Jacob, because he was blind and because Jacob’s hands were now hairy, like those of his older brother, Esau. So Isaac prepared to bless Jacob. ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","But first Isaac asked, “Are you really my son Esau?” Jacob replied, “Yes, I am.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isaac said, “My son, bring me some of the meat that you have cooked, so that I may eat it and then give you my blessing.” So Jacob brought him some, and he ate it. Jacob also brought him some wine, and he drank it. ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Then Isaac said to him, “My son, come here and kiss me.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","So Jacob came close to him, and his father kissed him on the cheek. Isaac smelled the clothes Jacob was wearing. They smelled like Esau’s clothes. So he said, “Truly, the smell of my son is like the smell of a field that Yahweh has blessed. ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","I ask that God will send down to you dew from heaven to water your fields, and cause you to have abundant crops, good harvests of grain, and grapes for wine. ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","I ask that people of many nations will serve you and bow down to you. I ask that you will rule over your brothers, and that your mother’s descendants will also bow down to you. I ask that God will curse/punish those who ◄curse you/ask God to do bad things to you►, and bless those who bless you.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","After Isaac finished blessing Jacob, Jacob was just leaving the room where his father was, when his older brother, Esau, returned from hunting. ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Esau cooked some tasty meat and brought it to his father. He said to his father, “My father, please sit up and eat some of the meat that I have cooked, so that you can then give me your blessing!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","His father, Isaac, said to him, “Who are you?” He answered, “I am Esau, your firstborn son!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Then Isaac, realizing that it was not Esau who had come earlier, trembled very violently. He said, “Then who is it that brought me some meat from an animal that he had hunted and killed, and I ate it all? He was here just before you came. I blessed him, and I cannot ◄take back that blessing/declare that those things will not happen to him►.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","When Esau heard those words of his father, he cried loudly. He was very disappointed. He said to his father, “My father, bless me, too!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","But his father said, “Your brother came deceitfully and took your blessing!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau said, “It is right RHQ that his name is Jacob, which means ‘cheat,’ because he deceived me two times. The first time he took my rights from being his firstborn son, and this time he took my blessing!” Then he asked, “Do you not have any blessing left for me?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac answered and said to Esau, “I have declared that your younger brother will rule over you, and declared that all his relatives will serve him. And I have said that God will give him plenty of grain and grapes for wine. So, my son, ◄what can I do for you?/There is nothing more that I can do for you!►” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau said to his father, “My father, do you have only one blessing? My father, bless me, too!” Then Esau cried very loudly. ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","His father Isaac answered and said to him, “The place where you will live will be far from the fertile soil and from the dew that God sends from heaven to water the fields. ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","You will rob and kill people MTY in order to get what you need to live, and you will be as though you are your brother’s slave. But when you decide to rebel against him, you will ◄free yourself from/no longer be under► his control.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","So, because his father had given a blessing to Jacob, and not to him, Esau hated his younger brother. Esau thought to himself, “After my father dies and we finish mourning for him, I will kill Jacob!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","But Rebekah found out what her older son, Esau, was thinking. So she summoned her younger son, Jacob, and said to him, “Listen to me. Your older brother, Esau, is comforting himself by planning to kill you, to get revenge because of your deceiving your father. ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","So now, my son, listen carefully to what I am telling you. Escape quickly and go and stay with my brother Laban, in Haran town. ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Stay with him a while, until your older brother is no longer angry. ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","When he forgets what you did to him, I will send a message to you, to tell you to return from there. If Esau kills you, others will kill him, and then both my sons would die at the same time!” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebekah also said to Isaac, “These foreign women whom Esau has married, who are descendants of Heth, are making my life miserable. I would prefer to die than to see Jacob marry a woman from the descendants of Heth in this area!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Then Isaac summoned Jacob, and gave him a blessing. He told him, “Do not marry a woman of the Canaan people-group. ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Instead, go right away to Paddan-Aram in northwest Mesopotamia, to the house of your mother’s father Bethuel. Ask one of the daughters of your mother’s brother Laban to marry you. ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","I will pray that God Almighty will bless you, and enable you to get married and have many descendants, in order that they will become many people-groups. ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","I also will pray that he will bless you and your descendants by enabling you to possess/seize the land in which you are now living as a foreigner, the land that God promised to give to my father Abraham and his descendants.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","So Isaac sent Jacob to Paddan-Aram, to live with Rebekah’s brother Laban, the son of Bethuel, who belonged to the Aram people-group. ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau found out that his father Isaac had blessed Jacob and then sent him to Paddan-Aram. He also found out that when he blessed Isaac, he told him, “Do not marry a woman of the Canaan people-group,” ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","and that Jacob had obeyed his father and mother, and had gone to Paddan-Aram. ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau also realized that his father Isaac did not approve of women from the Canaan people-group. ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Because of that, Esau went to see his uncle Ishmael, and married Mahalath, the daughter of Ishmael. Mahalath was the sister of Nabaioth and the granddaughter of Abraham. ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Meanwhile, Jacob left Beersheba and started walking along the road to Haran. ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","When he arrived at a certain place, he stopped there, because the sun had gone down. He took one of the stones there and put it under his head to use as a pillow. Then he lay down and slept there. ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","While he was sleeping, he had a dream, in which he was surprised to see a stairway. The bottom of the stairway was on the earth and the top was in the sky. Jacob also saw that God’s angels were going up and down the stairway. ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","And he was surprised to see Yahweh standing at the top of the stairway, saying “I am Yahweh God, whom your grandfather Abraham worshiped, and whom Isaac worships. I will give to you and to your descendants the land on which you are lying. ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Your descendants will be as numerous as the particles of dirt that are on the earth, and their territory will be very large. It will extend in all directions, to the east and to the west, to the north and to the south. And people of all people-groups on earth will receive blessings because of what happens to you and to your descendants. ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","I will help you and protect you wherever you go, and I will bring you back to this land. I will not leave you; I will continue to do for you all that I have promised to do.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","During the night, when Jacob woke up from sleeping, he thought, “Surely Yahweh is in this place, and until now I was not aware of it!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","He was afraid, and he said, “This place is very awesome! This is surely the place where God lives, and this is the entrance to heaven!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","In the morning Jacob got up and took the stone that he had put under his head and set it up on its end to show that the place was a holy place. He poured some olive oil on top of the stone to dedicate it to God. ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","He named that place Bethel, which means ‘house of God’. Previously its name was Luz. ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jacob solemnly promised God, saying, “God, if you will help me and protect me while I am taking this journey, and if you give me enough food to eat and clothes to wear, ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","in order that I can later return safely to my father’s house, then you, Yahweh, will be the God that I will worship. ");
INSERT INTO eng_t4t_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","This stone that I have set up will mark the place where people can worship you. And I will give back to you a tenth of everything that you give to me.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacob continued on the road MTY, and he arrived at the land that was east of Canaan. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","There he was surprised to see a well in a field, and three flocks of sheep were lying near the well. It was the well from which shepherds habitually got water for their sheep. There was a large stone covering the top of the well. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","When all the flocks were gathered there, the shepherds would work together to roll the stone away from the top of the well and get water for the sheep. When they finished doing that, they would put the stone back in its place over the top of the well. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","On that day, Jacob asked the shepherds who were sitting there, “Where are you from?” They replied, “We are from Haran.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","He asked them, “Do you know Laban, the grandson of Nahor?” They replied, “Yes, we know him.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Jacob asked them, “Is Laban well?” They replied, “Yes, he is well. Look! Here comes his daughter Rachel with the sheep!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jacob said, “Hey! The sun is still high in the sky. It is not time for the flocks to be gathered for nighttime. Give the sheep some water and then take them back to ◄graze/eat grass► in the pastures!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","They replied, “No, we cannot do that until all the flocks are gathered here and the stone is removed from the top of the well. After that, we will give water to the sheep.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","While he was still talking with them, Rachel came with her father’s sheep. She was the one who took care of her father’s sheep. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","When Jacob saw Rachel, the daughter of Laban, who was his mother’s brother, Jacob was so excited that he went over and by himself rolled away the stone that covered the top of the well, and he got water for his uncle’s sheep. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Then Jacob kissed Rachel on the cheek, and he cried loudly because he was so happy. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jacob told Rachel that he was one of her father’s relatives, the son of her aunt Rebekah. So she ran and told that to her father. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","As soon as Laban heard that Jacob, his sister’s son, was there, he ran to meet him. He embraced him and kissed him on the cheek. Then he brought him to his home, and Jacob told him all that had happened to him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Then Laban said to him, “Truly, you are part of my family!” After Jacob had stayed there and worked for Laban for a month, ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban said to him “◄You should not work for me for nothing just because you are a relative of mine!/Why should you work for me for nothing just because you are a relative of mine?► RHQ Tell me how much you want me to pay you.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Well, Laban had two daughters. The older one was named Leah, and the younger one was named Rachel. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leah had pretty eyes, but Rachel had a very attractive figure and was beautiful. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob ◄was in love with/wanted very much to be married to► Rachel, and he said, “I will work for you for seven years. That will be my payment for your letting me marry your younger daughter, Rachel.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban replied, “It is better for me to let you marry her than for her to marry some other man!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","So Jacob worked for Laban for seven years to get Rachel, but to him it seemed like it was only a few days, because he loved her so much. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","After the seven years were ended, Jacob said to Laban, “Let me marry Rachel now, because the time we agreed upon for me to work for you is ended, and I want to marry her. EUP” ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","So Laban gathered together all the people who lived in that area and made a feast. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","But that evening, instead of taking Rachel to Jacob, Laban took his older daughter, Leah, to him. But because it was already dark, he could not see that it was Leah and not Rachel, and he had sex EUP with her. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Laban had already given his slave girl Zilpah to his daughter Leah to be her maid/servant.) ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","The next morning, Jacob was shocked to see that it was Leah who was with him! So he went to Laban and told him very angrily, “◄What you have done to me is disgusting!/What is this that you have done to me?► RHQ I worked for you to get Rachel, did I not? So why did you deceive me?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban replied, “In this land, it is not our custom to give a younger daughter to be married before we let someone marry our firstborn daughter. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","After we finish this week of celebration, we will let you marry the younger one also. But in return, you must pay for Rachel by working for me for another seven years.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","So that is what Jacob did. After the week of celebration was ended, Laban gave him his daughter, Rachel, to be his wife. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban gave his slave girl, Bilhah, to Rachel to be her maid/servant. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jacob had sex EUP with Rachel also, and he loved Rachel more than he loved Leah. And Jacob worked for Laban for another seven years. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","When Yahweh saw that Jacob did not love Leah very much, he enabled her to become pregnant. But Rachel was not able to become pregnant. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leah gave birth to a son, whom she named Reuben, which sounds like the Hebrew words that mean ‘Look, a son!’ She said, “Yahweh has seen that I was miserable, and because of that he has given me a son. Now, surely my husband will love me for giving birth to a son for him.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Later she became pregnant again and gave birth to another son. She said, “Because Yahweh has heard that my husband doesn’t love me, he has given me this son, too.” So she named him Simeon, which means ‘someone who hears’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Later she became pregnant again, and gave birth to another son. She said, “Now, finally, my husband will hold me close to him.” So she named him Levi, which means ‘hold close’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Later she became pregnant again and gave birth to another son. She said, “◄This time/Now► I will praise Yahweh.” So she called his name Judah, which sounds like the Hebrew word that means ‘praise’. After that, she did not give birth to any more children for several years. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rachel realized that she was not becoming pregnant and giving birth to any children for Jacob. So she became jealous of her older sister, Leah, because Leah had given birth to four sons. She said to Jacob, “Enable me to become pregnant and give birth to children. If you do not do that, I think I will die!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jacob became angry with Rachel and said, “◄I am not God!/Am I God?► RHQ He is the one who has prevented you from becoming pregnant!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Then she said, “Look, here is my female slave, Bilhah. ◄Sleep with/Have sex with► EUP her, so that she may become pregnant and give birth to children for me. In that way it will be as though ◄I have children/her children are mine►.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","So she gave him her slave, Bilhah, to be another wife for him, and Jacob had sex EUP with her. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","She became pregnant and bore Jacob a son. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rachel said, “God has ◄vindicated me/judged my case and has decided that what I have done is right►. He has also heard my requests and has given me a son.” So she named him Dan, which sounds like the Hebrew word that means ‘he judged’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Later, Rachel’s slave Bilhah became pregnant again and gave birth to another son for Jacob. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Then Rachel said, “I have had a great struggle to have children like my older sister, but truly I have a son.” So she named him Naphtali, which sounds like the Hebrew word that means ‘struggle’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","When Leah realized that she was not becoming pregnant and giving birth to any more children, she took her female slave, Zilpah, and gave her to Jacob to be another wife for him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpah soon became pregnant and gave birth to a son for Jacob. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leah said, “I am truly fortunate!” So she named him Gad, which means ‘fortunate’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Later Leah’s slave, Zilpah, gave birth to another son for Jacob. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leah said, “Now I am very happy, and people will call me happy.” So she named him Asher, which means ‘happy.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","When it was time to harvest wheat, Reuben went out into the fields and saw some ◄mandrakes/plants that women eat to help them to become pregnant►. He brought some of them to his mother Leah. But Rachel saw them and said to Leah, “Please give me some of those plants that your son brought to you!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","But Leah said to her, “No! ◄It was bad that you stole my husband!/Is it not bad enough that you stole my husband?► RHQ Now ◄are you going to take my son’s mandrake plants?/You want to take my son’s mandrake plants also, so that you can become pregnant!►” RHQ So Rachel said, “All right, Jacob can sleep with you tonight, if you give me some of your son’s mandrake plants.” So Leah ◄agreed/gave her some►. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","When Jacob returned from the wheat fields that evening, Leah went out to meet him. She said, “You must sleep with me tonight, because I gave Rachel some of my son’s mandrakes that enable women to become pregnant, to pay her for allowing us to do that.” So Jacob slept with her that night. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","God answered Leah’s prayers, and she became pregnant and bore a fifth son to Jacob. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leah said, “God has rewarded me for giving my slave to my husband to be another wife for him.” So she named him Issachar, which sounds like the Hebrew word that means ‘reward’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leah became pregnant again and bore a sixth son for Jacob. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leah said, “God has given me a precious gift. ◄This time/Now► my husband will honor/respect me, because I have given birth to six sons for him.” So she named him Zebulon, which sounds like the Hebrew word that means ‘accepted gift’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Later she gave birth to a daughter, and named her Dinah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Then God thought about what Rachel wanted. He heard her prayers and enabled her to become pregnant. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","She became pregnant and gave birth to a son. She said, “God has caused that no longer will I be ashamed for not having children.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","She named him Joseph, which sounds like the Hebrew words that mean ‘may he give another’  and she said, ‘ want Yahweh to give me another son.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","After Rachel had given birth to Joseph, Jacob said to Laban, “Now allow me to quit working for you and let me return to my own land. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","You know the work that I have done for you for a long time to get my wives. So let me take my wives and my children, and leave.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","But Laban said to him, “If you are pleased with me, stay here, because I have found out by performing a magic ritual that Yahweh has blessed me because of what you have done for me. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Tell me what you want me to pay you for continuing to work for me, and that is what I will pay you.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jacob replied, “You know how I have worked for you, and you know that your livestock have increased greatly as I have taken care of them. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","You had only a few animals before I came here. But now you have very many, and Yahweh has caused them to increase greatly in number wherever I have taken them. But now I need to start taking care of the needs of my own family.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban replied, “What do you want me to give you?” Jacob replied, “I do not want you to pay me anything. But if you will do this one thing for me, I will continue to take care of your flocks and protect them. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Allow me to go and look at all of your flocks today and remove from them all the speckled sheep, all the spotted sheep, and every dark-colored lamb, all the goats that are speckled, and all the goats that are spotted, and keep them for myself. They will be my wages. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","In that way, in the future, you will be able to know whether I have been honest regarding what you have paid me. If any of my goats are neither speckled or spotted, or if any of my lambs are not dark-colored, you will know that I have stolen them from you.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban agreed and said, “Okay, we will do as you have said.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","But that same day Laban removed all the male goats that had black and white stripes on them or were spotted, and all the female goats that were speckled or spotted, all the goats that were partly white, and all the dark-colored lambs. He separated them and told his sons to take care of them. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Then he took these flocks and walked a distance of three days, in order that he could be that far from Jacob. Jacob continued to take care of the rest of Laban’s flocks. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Then Jacob cut some branches of ◄poplar, almond, and plane trees/three kinds of trees that had white wood►. He peeled strips of bark from the branches, so that where the bark had been peeled off, the branches were light in color. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Then he placed the peeled branches in the troughs where they put the water for the animals to drink, so that the branches would be in front of the flocks when they came to drink. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","The animals also mated in front of the branches, and eventually they gave birth to animals that were speckled, or to animals that were spotted, or to animals that had black and white stripes on them. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Furthermore, Jacob separated the female sheep in his flock from the other sheep and goats in Laban’s flock. And when his female sheep mated, he made them look toward the animals that belonged to Laban that had black and white stripes on them, and the dark-colored animals. He did that so that the female sheep would give birth to animals that were striped or dark-colored. By doing that, he made bigger flocks for himself, and he kept them separate from Laban’s flocks. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","In addition, whenever the stronger female sheep were ready to mate, Jacob put some of those peeled branches in the troughs in front of them, so that they would mate in front of the branches. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","But when weak animals were ready to mate, he did not put the branches in their troughs. So the weak ones became part of Laban’s flock, and the strong ones became part of Jacob’s flock. ");
INSERT INTO eng_t4t_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","As a result, Jacob became very rich. He owned many large flocks of sheep and goats, and many male and female slaves, and many camels and donkeys. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Someone told Jacob that Laban’s sons were complaining and saying, “Jacob has become very rich by taking everything HYP that belonged to our father.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","And Jacob noticed that Laban was not acting friendly toward him as he had done before. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Then Yahweh said to Jacob, “Go back to your country and your relatives, and I will help you there.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","So Jacob sent a message to Rachel and Leah, telling them to come out to the pastures where his flocks of sheep and goats were. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","When they arrived, he said to them, “I see that your father does not act friendly toward me as he did previously. But God, whom my father worshiped, has helped me. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","You two know that I have worked very hard for your father, ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","but many times HYP he has cheated me by decreasing my wages. But God has not allowed him to harm me. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","When Laban said, ‘The speckled animals are the ones that I will give you to be your wages,’ then all the animals gave birth to young ones that were speckled. When he changed and said, ‘The ones that have black and white stripes on them will be your wages,’ then all the animals gave birth to young ones that were striped. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","In that way, God has taken away the livestock that belonged to your father and has given them to me. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“One time, when the animals were mating, I had a dream. In my dream I looked up and was surprised to see that some of the male goats that were mating with the female goats had black and white stripes on them, some were speckled, and some were spotted. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","An angel who was sent by God said to me in the dream, ‘Jacob!’ I replied, ‘I am here!’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","He said to me, ‘Look up and you will see that all the male goats that are mating have black and white stripes on them, or are speckled or spotted. This is happening because I have seen all that Laban has done to you. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","I am God who appeared to you at Bethel, where you set up a stone to show that the place was holy, and you poured olive oil on the stone and made a solemn promise to me. So now leave this land immediately, and return to the land where you were born.’” ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rachel and Leah replied, “Our father will not give us anything more when he dies RHQ. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","He treats us as though we were foreigners RHQ! Your working for him all these years was like a payment that you gave him as a price for us, but we will not inherit any of that money that he got as a price for us. He has spent it all! ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Surely all of the wealth that God took away from our father belongs to us and to our children. So do whatever God has told you to do!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Then Jacob put his children and his wives on camels. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","He made all his livestock go ahead of him. Besides the livestock, he took along all the other things that he had acquired while living in Paddan-Aram. And they prepared to return to his father Isaac, in the Canaan region. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Before they left, while Laban was shearing his sheep, Rachel stole the small wooden idols that were in her father’s tent. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Furthermore, Jacob deceived Laban, who belonged to the Aram people-group, by not telling him that they were planning to leave. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","So Jacob and his family fled with all their possessions, and they crossed the Euphrates River, and then started traveling south toward the hilly Gilead region. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","On the third day after they left, someone told Laban that Jacob and his family had left. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","So he took some of his relatives with him and started to pursue Jacob. They continued walking for seven days. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Then God appeared to Laban in a dream at night, and said to him, “When you catch up to Jacob, be sure that you do not say anything at all HYP to him in an angry manner!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","The next day, by the time Laban caught up with Jacob, Jacob and his household had set up their tents in the hilly Gilead region. So Laban and his relatives set up their tents there, too. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Then Laban went to Jacob and said to him, “Why have you done this? You have deceived me by carrying away my daughters as though you had captured them in a war MTY! ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Why did you run away and deceive me? Why did you not tell me that you were going to leave, so that we could have rejoiced and sung while people played music on tambourines and harps before I said ‘goodbye’ to you? ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","◄You did not even let me kiss my grandchildren and my daughters goodbye before they left!/Why did you not allow me to kiss my grandchildren and daughters goodbye before they left?► RHQ What you have done was foolish! ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","My relatives and I have the power to harm you, but last night the God whom your father worships said to me in a dream, ‘Be sure that you do not say anything at all to Jacob in an angry way.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Now, I know you have left because you long to go back home. But why did you steal my wooden idols?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacob replied to Laban, saying, “I did not tell you that we were planning to leave, because I was afraid. I thought that if I told you, you would forcefully take your daughters away from me. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","But if you find anyone here who has your wooden idols, we will execute that person. While our relatives are watching, search for yourself to see if there is anything that belongs to you that is here with me. If you find anything, you can take it!” When Jacob said that, he did not know that Rachel had stolen the wooden idols. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban went into Jacob’s tent, and then into Leah’s tent, and then into the tents of the two female slaves and searched for the idols, but he did not find them. After he left their tents, he entered Rachel’s tent. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","But Rachel had previously taken the idols and put them in the saddle of a camel, and she was sitting on the saddle. So when Laban searched all over for them inside Rachel’s tent, he did not find them. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rachel said to her father, “Do not be angry with me, sir, but I cannot get up in your presence to show respect for you, because I am having my monthly menstrual period. EUP” So when Laban searched some more, he did not find the wooden idols. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Then Jacob became angry. He rebuked Laban, saying, “What crime did I commit? For what sin that I committed have you pursued me? ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Now you have searched through all my possessions, and what did you find from all these possessions that belongs to you? Put it here in front of my relatives and your relatives, so that they can decide who is right, you or me! ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","I was with you for 20 years. In all that time, your sheep and goats have ◄not miscarried/always given birth to animals safely►. I have not killed and eaten any rams from your flocks. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","When one of your animals was attacked and mauled/killed by a wild animal, I did not bring it to you. I replaced the dead animal with a living one of my own animals. Whenever one of your animals was stolen, during the day or during the night, you demanded that I replace it with one of my own animals. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","I suffered from the heat during the day and from the cold at night. I was often not even able to sleep PRS! ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","I lived in your household for 20 years. I worked for you for 14 years to buy your two daughters, and for six more years to buy some of your sheep and goats. During that time, you changed and reduced my wages many times HYP. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","If God, the one whom my grandfather Abraham worshiped and before whom my father Isaac trembled in fear, had not been with me and helped me, you would have sent me away ◄with nothing in my hands/owning nothing►! But God saw how much I was suffering and how hard I was working, so last night he told you that what you have done to me was wrong.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban replied, “These two women are my daughters, and their children are my grandchildren, and the animals are my animals. Everything you see here is mine HYP! But what can I do today to keep my daughters or the children they have given birth to RHQ? ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","I cannot do anything in order to keep them, so hey, we should make a peace agreement, you and I, and do something that will remind us about our agreement.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","So Jacob took a large stone and set it on its end. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Then Jacob said to his relatives, “You also gather some stones.” So they gathered some rocks and put them in a heap, and they ate some food there near the heap. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban gave the heap the Aramaic name Jegar-Sahadutha, which means ‘rock-pile to remind us’, but Jacob gave the rock-pile the Hebrew name Galeed, which has the same meaning. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban said to Jacob, “This pile of rocks we have put here today will help us to remember our agreement.” That is why Jacob called it Galeed. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","They also named the place Mizpah, which sounds like the Hebrew word that means ‘watchtower’, because Laban said, “We will ask Yahweh to watch you and me while we are separated from each other, so that we do not try to harm each other. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","If you mistreat my daughters, or if you take other women to be your wives, even if no one tells me about it, don’t forget that God sees what you and I are doing!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban also said to Jacob, “You see this large stone and this pile of rocks that we have set up to be between us. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Both this pile of rocks and this large stone will remind us, that I will not go past these rocks to harm you, and you will not go past these rocks to harm me. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","We will ask the God whom your grandfather Abraham and his father Nahor worshiped to punish MTY either one of us, if we harm the other one.” So Jacob solemnly promised to do what they said in their peace agreement. And he asked God, the one before whom his father Isaac trembled, to listen to what they promised. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","He offered a sacrifice to God there in the hilly area, and he invited his relatives to eat with him. After they had eaten, they slept there that night. ");
INSERT INTO eng_t4t_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","The next morning Laban kissed his grandchildren and his daughters goodbye and asked God to bless them. Then he and his men left them and returned home. ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","As Jacob and his family continued traveling, some angels, whom God sent, met him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","When Jacob saw them, he said, “This is God’s army camp!” So he named that place Mahanaim, which means ‘two camps’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacob told some of the men to go ahead of him to his older brother Esau, who was living in Seir, the land where the descendants of Edom lived. ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","He told them, “This is what I want you to say to Esau: 'I, Jacob, want to be your servant and I want you to be my master. I have been living with our uncle Laban, and I have stayed there until now. ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","I now own many cattle, donkeys, sheep, goats, and male and female slaves. Now I am sending this message to you, sir, hoping that you will ◄be friendly toward me/treat me kindly► when I arrive.’ “ ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","The messengers went and gave that message to Esau. When they returned to Jacob, they said, “We went to your older brother Esau. Now he is coming to you, and 400 men are coming with him.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jacob was very afraid and worried. So he divided the people who were with him into two groups. He also divided the sheep and goats, the cattle, and the camels, into two groups. ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","He was thinking, “If Esau and his men come and attack us, perhaps one of the groups will be left and will be able to escape.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Then Jacob prayed, “O Yahweh God, whom my grandfather Abraham worshiped and my father Isaac worships, you said to me, ‘Go back to your own land and to your relatives, and I will ◄cause good things happen to/do good things for► you.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","I am not worthy for you to have been so kind and faithful to me in so many ways, your servant. I had only this walking stick with me when I crossed the Jordan River on my way to Haran, but now I am so wealthy that there are two large groups of my family and possessions. ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","So now I pray that you will rescue me from MTY my older  brother Esau, because I am afraid that he and his men will come and attack and kill me and the children and their mothers. ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","But do not forget that you have said, ‘I will certainly enable you to prosper, and I will cause your descendants to be as numerous as the grains of sand on the seashore, which are so many that no one can count them.’” ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jacob slept there that night. The next morning he selected some animals to give to his brother Esau. ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","He selected 200 female goats and 20 male goats, 200 female sheep and 20 male sheep, ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 female camels and their offspring, 40 cows and ten bulls, 20 female donkeys and 10 male donkeys. ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","He divided them into small herds, and put each herd into the care of one of his servants. He said to his servants, “Go ahead of me, one group at a time, and keep some space between each herd.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","He said to the servant who was going with the first group, “When my brother Esau meets you, and he asks you, ‘To whom do you belong, and where are you going, and to whom do these animals in front of you belong?’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","tell him, ‘They belong to your servant Jacob. He has sent them to you as a gift, sir. And he is coming behind us.’” ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","He also said the same thing to the servants who were taking care of the second and third groups, and to the other herdsmen. He said to them, “When you meet Esau, I want you to say to him the same thing that I told the first servant. ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","And be sure to say ‘Jacob, who wants to serve you, is coming behind us.’” Jacob told them to say that because he was thinking, “Perhaps these gifts that I am sending ahead of me will cause him to ◄act peacefully toward/stop being angry with► me. Then later, when I see him, perhaps he will be kind to me.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","So the men taking the gifts PRS went ahead, but Jacob himself stayed in the camp that night. ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Some time during that night, Jacob got up and took his two wives, his two female slaves, and his eleven sons and his daughter, and he sent them across the ford at the Jabbok River. ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","After he had done that, he sent other slaves, carrying all his possessions, across the river. ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","So Jacob was left there alone. But a man came and wrestled with him until dawn. ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","When the man realized that he was not winning against Jacob, he struck Jacob’s hip and caused the thigh bone to pull away from the hip socket. ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Then the man said, “Let me go, because it will soon be daylight.” Then Jacob realized who he was really wrestling with. So he replied, “No, if you will not bless me, I will not let you go!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","The man said to him, “What is your name?” He replied, “Jacob.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","The man said, “Your name will no longer be Jacob. Your name will be Israel, which means ‘he struggles with God’, because you have struggled with God and with people, and you have won.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jacob said, “Now, please tell me your name!” The man replied, “◄Why do you ask me what my name is?/You should not have to ask me what my name is!►” RHQ But he blessed Jacob there. ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","So Jacob named the place Peniel, which means ‘God’s face’, saying “I looked directly at God, but I did not die because of doing that.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","The sun was rising as Jacob left Peniel, and he was limping because of what had happened to his hip. ");
INSERT INTO eng_t4t_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","The muscle on his hip joint had been injured. So to this present time, because of what happened to Jacob, the Israeli people do not eat the muscle/tendon that is attached to the socket of the hips of animals. ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Then Jacob joined the rest of his family. Later that day  Jacob looked up and saw Esau coming, and there were 400 men with him. Jacob was worried because of that, so he separated the children. He put Leah’s children with Leah, Rachel’s children with Rachel, and the two female slaves’ children with their mothers. ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","He put the two female slaves and their children in front. He put Leah and her children next. He put Rachel and Joseph at the rear. ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","He himself went ahead of them all, and as he continued to approach his older brother, he prostrated himself with his face on the ground seven times. ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","But Esau ran to Jacob. He hugged him, put his arms around his neck, and kissed him on the cheek. And they both cried. ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Then Esau looked up and saw the women and the children. He asked, “Who are these people who are with you?” Jacob replied, “These are the wives and children that God has graciously/kindly given to me.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Then the female slaves and their children came near and bowed in front of Esau. ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Then Leah and her children came and bowed down. Finally Joseph and Rachel came near and bowed down. ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau asked, “What is the meaning of all the animals that I saw?” Jacob replied, “I am giving them to you, sir, so that you will feel good toward me.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","But Esau replied, “My younger brother, I have enough animals! Keep for yourself the animals that you have!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","But Jacob said, “No, please, if you feel good toward me, accept these gifts from me. You have greeted me very kindly. Seeing your smiling face assures me that you have forgiven me. It is like seeing the face of God! ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Please accept these gifts that I have brought to you, because God has acted kindly toward me, and I still have plenty of animals!” Jacob kept on urging him to accept the animals, and finally he accepted them. ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Then Esau said, “Let’s continue traveling together, and I will show the road to you.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jacob had no intention to go with Esau, but he said, “You know, sir, that the children are weak, and that I must take care of the female sheep and cows that are ◄sucking their mother’s milk/nursing their young►. If I force them to walk fast for a long distance in just one day, the animals will all die. ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","You go ahead of me. I will lead the animals slowly, but I will walk as fast as the children and animals can walk. I will catch up with you in Seir, in the land where the descendants of Edom live.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau said, “Then allow me to leave with you some of the men who came with me, to protect you.” But Jacob replied, “◄Why do that?/There is no need to do that!► RHQ The only thing that I want is for you to act friendly toward me.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","So on that day Esau left to return to Seir. ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","But instead of going to Seir, Jacob and his family went to a place called Succoth. There he built a house for himself and his family, and built shelters for his livestock. That is the reason they named the place Succoth, which means ‘shelters’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Some time later, Jacob and his family left Paddan-Aram in Mesopotamia, and they traveled safely to the Canaan region. There they set up their tents in a field near Shechem city. ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","One of the leaders of the people in that area was named Hamor. Hamor had several sons. Jacob paid the sons of Hamor 100 pieces of silver for the piece of ground on which they set up their tents. ");
INSERT INTO eng_t4t_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","He built a stone altar there, and named it El-Elohe Israel, which means ‘God, the God of Israel.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","One day Dinah, the daughter of Jacob and Leah, went to visit some of the women in that area. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Shechem, one of the sons of Hamor, the ruler of that area who was descended from the Hiv people-group, saw her. He wanted her. So he grabbed her and forced her to have sex EUP with him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","He SYN was very much attracted to her, and fell in love with her, and he tried to get her to love him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","So Shechem said to his father Hamor, “Please get this girl for me. I want her to become my wife!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jacob very soon found out that his daughter Dinah had been disgraced/defiled. But his sons were in the fields with his livestock, so he did nothing about it until they returned home. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","In the meantime, Shechem’s father Hamor went to talk with Jacob. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","While they were still talking, Jacob’s sons came in from the field. When they found out what had happened, they were shocked and very angry. They said, “Shechem has done something that is very disgraceful among us Israeli people, something that never should be done!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","But Hamor said to them, “My son Shechem really likes this girl. Please allow him to marry her. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Let’s make an agreement: You will give your daughters to our young men to be their wives, and we will give our daughters to your young men to be their wives. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","You can live among us, and live anywhere in our land that you wish. You can buy and sell things (OR, travel around) and if you find land that you want, then you can buy it.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Then Shechem said to Dinah’s father and brothers, “If you feel good toward me and do what I am asking for, I will give you whatever you ask for. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Tell me what gifts you want and what bride price you want, and I will give you what you ask for. I just want you to give the girl to me to be my wife.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","But because Shechem had done a shameful thing to their sister Dinah, the sons of Jacob deceived Shechem and his father Hamor ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","by saying to them, “No, we cannot do that. We cannot give our sister to be the wife of a man who is not circumcised, because that would be a shameful thing for us to do. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","We will do that only if you do one thing: You must become like us by circumcising all the males that are among you. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Then we will give our daughters to your young men to be your wives, and we will take your daughters to be the wives of our young men. We will live among you, and we will become one people-group. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","But if you will not agree to being circumcised, we will take our sister and go back to our land.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","What they said pleased Hamor and his son Shechem. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Shechem was very much in love with Jacob’s daughter, so he quickly agreed to do what they suggested. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Shechem went with Hamor to the meeting place near the city gate, and they spoke to the city leaders, saying, ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“These men are friendly toward us. We should let them live here and travel around (OR, buy and sell things) and if they find land that they want, they can buy it. There is plenty of land for them to live here. Our young men can marry their daughters, and their young men can marry our daughters. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","But these men will agree to live among us and become one people-group with us only if all our males are circumcised, as they are. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","But if we do that, just think! Their livestock and their possessions and their other animals will become ours RHQ! So we should agree to do what they suggest, and then they will live among us!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Shechem was the most respected person in his father’s household, so all the men who were there at the city gate agreed to what Hamor and Shechem suggested. So every male in the city was circumcised. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","On the third day after that, when the men of the city were still sore because of being circumcised, two of Jacob’s sons, Simeon and Levi, who were Dinah’s brothers, took their swords and entered the city without anyone opposing them, and killed all the men. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","They even killed Hamor and his son Shechem. Then they took Dinah out of Shechem’s house and left the city. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Then the other sons of Jacob went into the city where all those dead bodies were. They ◄looted/took everything in► the city to get revenge for the shameful thing that had been done to their sister. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","They took away the people’s sheep and goats, their cattle, their donkeys, and everything else that they wanted from inside the city and from out in the countryside. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","They took away everything that was valuable, even the children and the women. They seized and took away everything that was in the houses. ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Then Jacob said to Simeon and Levi, “You have caused a lot of trouble for me! Now the Canaan people-group and the Perizzi people-group and everyone else who lives in this land will ◄hate me/say my name stinks►! I do not have many men to fight for us, so if they all gather together and come to me and attack us, they will destroy us and all our household!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","But they replied, “◄Should we have allowed Shechem to treat our sister like a prostitute?/We could not just let Shechem treat our sister like a prostitute!►” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Some time later God said to Jacob, “Go up to Bethel, and live there. Build an altar to worship me, God, who appeared to you when you were fleeing from your older brother Esau.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","So Jacob said to his household and to all the others who were with him, “Get rid of the idols you brought from Mesopotamia. Also, bathe yourselves and put on clean clothes. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Then we will get ready and go up to Bethel. There I will make an altar to worship God. He is the one who helped me at the time when I was greatly distressed and afraid, and he has been with me wherever I have gone.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","So they gave to Jacob all the idols that they had brought, and all their earrings. Jacob buried them in the ground under the big oak tree that was near Shechem town. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","As they prepared to leave there, God caused the people who lived in the cities around them to be extremely afraid of Jacob’s family PRS, so that they did not pursue and attack them. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacob and all those who were with him came to Luz, which is now called Bethel, in the Canaan region. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","There he built an altar. He named the place El-Bethel, which means ‘God of Bethel’, because it was there that God revealed himself to Jacob when he was fleeing from his older brother Esau. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Deborah, who had taken care of Isaac’s wife Rebekah when Rebekah was a small girl, was now very old. She died and was buried under an oak tree south of Bethel. So they named that place Allon-Bacuth, which means ‘oak of weeping’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","After Jacob and his family returned from Paddan-Aram/Mesopotamia, while they were still at Bethel, God appeared to Jacob again and blessed him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","God said to him again, “Your name will no longer be Jacob. It will be Israel.” So Jacob was then called ‘Israel’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Then God said to him, “I am God Almighty. Produce many children. Your descendants will become many nations, and some of your descendants will be kings. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","The land that I promised to give to your grandfather Abraham and your father Isaac, I will give to you. I will also give it to your descendants.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","When God finished talking there with Jacob, he left him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jacob set up a large stone at the place where God had talked with him. He poured some wine and some olive oil on it to dedicate it to God. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jacob named that place Bethel, which means ‘house of God’, because God had spoken to him there. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Jacob and his family left Bethel and traveled south toward Ephrath town. When they were still some distance from Ephrath, Rachel began to have severe childbirth pains. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","When her pain was the most severe, the ◄midwife/woman who helped her to give birth► said to Rachel, “Do not be afraid, because now you have given birth to another son!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","But she was dying, and with her last breath she said, “Name him Benoni,” which means ‘son of my sorrow’, but his father named him Benjamin, which means ‘son of my right hand’. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","After Rachel died, she was buried alongside the road to Ephrath, which is now called Bethlehem. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob set up a large stone over her grave, and it is still there, showing where Rachel’s grave is. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Jacob, whose new name was Israel, continued traveling with his family, and he set up his tents on the south side of the watchtower at Eder town. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","While they were living in that area, Jacob’s son Reuben had sex EUP with Bilhah, one of his father’s ◄concubines/female slaves whom he had taken as a secondary wife►. Someone told Jacob about it, and it made him very angry. ◄I will now give you/Here is► a list of Jacob’s twelve sons. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","The sons of Leah were Reuben, who was Jacob’s oldest son, then Simeon, Levi, Judah, Issachar and Zebulon. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","The sons of Rachel were Joseph and Benjamin. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","The sons of Rachel’s female slave Bilhah were Dan and Naphtali. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","The sons of Leah’s female slave Zilpah were Gad and Asher. All those sons of Jacob, except Benjamin, were born while he was living in Paddan-Aram/Mesopotamia. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob had returned back home to see his father Isaac at Mamre, which is also named Kiriath-Arba, and which is now named Hebron. Isaac’s father Abraham had also lived there. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaac lived until he was 180 years old. ");
INSERT INTO eng_t4t_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","He was very old when he died, joining his ancestors who had died previously. His sons Esau and Jacob buried his body. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","◄Here is/I will now give you► a list of the descendants of Esau, whose other name was Edom. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau married three women from the Canaan region: Adah, the daughter of Elon from the Heth people-group; Oholibamah, who was the daughter of Anah and granddaughter of Zibeon from the Hiv people-group; ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","and Basemath, who was the daughter of Ishmael and sister of Nebaioth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esau’s wife Adah gave birth to Eliphaz. Basemath gave birth to Reuel. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibamah gave birth to Jeush, Jalam, and Korah. All these sons of Esau were born while he was living in the Canaan region. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","7","Jacob and Esau had very many possessions. The result was that they needed more land for their livestock. The land where they were living was not big enough for both of them. They had too much livestock. So Esau, whose other name was Edom, had taken his wives and sons and daughters and all the other members of his household, his sheep and goats and his other animals, and all the other things he had obtained in Canaan land, and they had moved to an area that was away from Jacob. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","They went to live in the Seir hilly area. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","◄Here is/I will now give you► another list of the male descendants of Esau. He was the ancestor of the Edom people-group who live in the Seir area. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esau’s wife Adah gave birth to Eliphaz, and Esau’s wife Basemath gave birth to Reuel. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","The sons of Eliphaz were Teman, Omar, Zepho, Gatam, and Kenaz. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Esau’s son Eliphaz also had a ◄concubine/female slave whom he took as a secondary wife►. Her name was Timna. She gave birth to Amalek. Those six men were grandsons of Esau’s wife Adah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuel’s sons were Nahath, Zerah, Shammah, and Mizzah. They were grandsons of Esau’s wife Basemath. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau’s wife Oholibamah, who was the daughter of Anah and granddaughter of Zibeon, gave birth to three sons: Jeush, Jalam, and Korah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","◄Here is/I will now give you► a list of the people-groups who were descendants of Esau. His oldest son Eliphaz was the ancestor of the Teman people-group, the Omar people-group, the Zepho people-group, the Kenaz people-group, ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","the Korah people-group, the Gatam people-group, and the Amalek people-group. They were descendants of Eliphaz and of Esau’s wife Adah. They lived in the Edom region. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","The sons of Esau’s son Reuel were ancestors of the Nahath, Zerah, Shammah, and Mizzah people-groups. They were descended from Esau’s wife Basemath. They also lived in Edom. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","The sons of Esau’s wife Oholibamah, whose mother was Anah, were ancestors of the Jeush, Jalam, and Korah people-groups. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","That is the list of the sons of Esau, and the people-groups who were their descendants. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","◄This is/I will now give you► a list of the descendants of Seir, who belonged to the Hor people-group, who were the first people-group who lived in the Edom region: Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, and Dishan. Those seven men became ancestors of people-groups. Each of the people-groups had the same name as the name of their ancestor. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","The sons of Lotan were Hori and Heman and Lotan’s sister was Timna. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","The sons of Shobal were Alvan, Manahath, Ebal, Shepho, and Onam. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","The sons of Zibeon were Aiah and Anah. This Anah was the one who discovered the hot springs in the desert while he was taking care of his father Zibeon’s donkeys. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anah had two children—a son named Dishon and a daughter named Oholibamah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dishon’s sons were Hemdan, Eshban, Ithran, and Keran. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer’s sons were Bilhan, Zaavan, and Akan. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishan’s sons were Uz and Aran. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","The people-groups who were descendants of Hor lived in the Seir/Edom region. The names of the people-groups are Lotan, Shobal, Zibeon, Anah, Dishon, Ezer, and Dishan. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","These are the names of the kings who ruled in Edom before any kings ruled over Israel. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beor’s son Bela became the first king in Edom. The city where he lived was named Dinhabah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","When Bela died, Zerah’s son Jobab/became the king. He was from Bozrah city. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","When Jobab died, Husham became the king. He was from the region where the Teman people-group lived. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","When Husham died, Bedad’s son Hadan became the king. Husham’s army fought the army of the Midian people-group in the Moab region and defeated them. The city where Husham lived was Avith. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","When Hadad died, Samlah became the king. He was from Masrekah town. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","When Samlah died, Shaul became the king. He was from Rehoboth town along the Euphrates river. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","When Shaul died, Achbor’s son Baal-Hanan became king. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","When Achbor’s son Baal-Hanan died, Hadad became king. The city where he lived was named Pau. His wife’s name was Mehetabel. She was the daughter of Matred, who was the daughter of Me-Zahab. ");
INSERT INTO eng_t4t_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","◄Here is/I will now give you► a list of all the people-groups that were descendants of Esau: Timna, Alvah, Jetheth, Oholibamah, Elah, Pinon, Kenaz, Teman, Mibzar, Magdiel, and Iram. They all lived in the Edom region. The land where each people-group lived got the same name as the name of the people-group. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob continued to live in the Canaan region where his father had lived previously. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","◄This is/I will now tell you► what happened to Jacob’s family. When his son Joseph was 17 years old, he was taking care of the flocks of sheep and goats with some of his older brothers. They were sons of his father’s ◄concubines/female slaves that he had taken to be his secondary wives►. Joseph sometimes told his father about bad things that his brothers were doing. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Jacob loved Joseph more than he loved any of his other children, because Joseph had been born when Jacob was an old man. Jacob made for Joseph a long pretty robe that had long sleeves. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","When Joseph’s older brothers realized that their father loved him more than he loved any of them, they hated him. They never spoke kindly to him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","One night Joseph had a dream. He told his brothers about the dream. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","He said to them, “Listen to the dream I had! ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","In the dream, we were tying up bundles of wheat in the field. Suddenly my bundle stood up straight, and surprisingly, your bundles gathered around my bundle and bowed down to it!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","His brothers said to him, “Do you think that some day you will rule over us? Are you saying that some day you are going to be our king?” RHQ They hated him even more than before because of what he had told them about his dream. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Later he had another dream, and again he told his older brothers about it. He said, “Listen to this! I had another dream. In this dream, the sun and moon and eleven stars were bowing down to me!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","He also told his father about it. His father rebuked him, saying “What are you suggesting by that dream RHQ? Do you think it means that your mother and I and your older brothers will some day bow down to the ground in front of you?” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Joseph’s older brothers were furious/angry with him, but his father just kept thinking about what the dream meant. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","One day Joseph’s older brothers went to take care of their father’s sheep and goats that were eating grass near Shechem. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Some time later, Jacob said to Joseph, “Your brothers are taking care of the sheep and goats near Shechem RHQ. I am going to send you there to see them.” Joseph replied, “Okay.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Jacob said, “Go and see if they are doing okay, and if the flocks are doing okay. Then come back and give me a report.” So Jacob sent Joseph from the valley where they were living, the valley where Hebron is located, to go north to find his brothers. When Joseph arrived near Shechem city, ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","while he was wandering around in the fields looking/searching for his brothers, a man saw him and asked him, “Whom are you looking/searching for?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Joseph replied, “I am looking for my older brothers. Can you tell me where they are taking care of their sheep and goats?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","The man replied, “They are not here any more. I heard one of them saying, ‘Let’s take the sheep and goats and go to Dothan town.’” So Joseph left there and went north, and found his older brothers near Dothan. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","But they saw him when he was still far away, and they decided to kill him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","They said to each other things like, “Here comes that dreamer!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","and “Hey, let’s kill him, and then throw his body into one of the pits/cisterns. Then we will tell people that a ferocious/wild animal attacked and killed him and ate him. And then we will ◄find out whether his dreams come true/make sure that his dreams do not come true►!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Reuben heard what they were saying, so he tried to persuade them not to kill MTY Joseph. He said, “No, we should not kill him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Do not even shed his blood! We can throw him into this pit/cistern in the desert, but we should not harm him MTY.” He said that, and then left them, planning to rescue Joseph later and take him back to his father. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","So when Joseph arrived where his older brothers were, they seized him and ripped off his pretty robe with long sleeves. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Then they took him and threw him into the pit/cistern. But the pit/cistern was dry; there was no water in it. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","After they sat down to eat some food, they looked up and saw a ◄caravan/group of traders►, descendants of Ishmael, coming from the Gilead area. Their camels were loaded with bags of spices and nice-smelling resins. They were going down to Egypt to sell those things there. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Judah said to his older and younger brothers, “If we kill our younger brother and hide his body, ◄what will we gain?/we will not gain anything!► RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","So, instead of harming him, let’s sell him to these men who are descendants of Ishmael. Don’t forget, he is our own younger brother!” So they all agreed to do that. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","When those traders from the Midian area came near, Joseph’s brothers pulled him up out of the pit/cistern. Then they sold him to the men from Midian for 20 pieces of silver. The traders then took Joseph to Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","When Reuben returned to the pit/cistern, he saw that his younger brother was not there. He was so grieved that he tore his clothes. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","He went back to his younger brothers and said, “The boy is not in the pit/cistern! What can I do now?” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Joseph’s brothers did not dare to tell their father what they had done. So, they decided to invent a story about what had happened. They got Joseph’s robe. Then they killed a goat and dipped the robe in the goat’s blood. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","They took that pretty robe back to their father and said, “We found this robe! Look at it. Is it your son’s robe?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","He recognized it, and he said, “Yes, it is my son’s robe! Some ferocious/wild animal must have attacked and killed him! I am sure that the animal has torn Joseph to pieces!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jacob was so grieved that he tore his clothes. He put on ◄sackcloth/clothes that people wear when they are mourning for someone who has died►. He mourned/cried for his son for many days. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","All of his children came to try to comfort him, but he did not pay attention to what they said. He said, “No, I will still be mourning/crying when I die and go to be with my son.” So Joseph’s father continued to cry because of what had happened to his son. ");
INSERT INTO eng_t4t_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","In the meantime, the men/traders from Midian took Joseph to Egypt and sold him to Potiphar, who was one of the king’s officials. He was the captain of the soldiers who protected the king. ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","At that time, Judah left his older and younger brothers and went down from the hilly area and stayed with a man whose name was Hiram, who lived in Adullam town. ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","There he ◄met/became acquainted with► a woman who was the daughter of a man from Canaan named Shua. He married her. He had sex EUP with her, ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","and she became pregnant and later gave birth to a son, whom he named Er. ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Later she became pregnant again and gave birth to another son whom she named Onan. ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Many years later, when Judah and his family went to live in Kezib town, Judah’s wife gave birth to another son, whom she named Shelah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","When Judah’s oldest son Er grew up, Judah got a wife for him, a woman named Tamar. ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","But Er did something that Yahweh considered to be very wicked, so Yahweh caused him to die. ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Then Judah said to Onan, “Your older brother died without having any sons. So marry his widow and have sex EUP with her. That is what our customs require that you should do.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","But Onan knew if he did that, any children who would be born would not be considered to be his. So every time he had sex EUP with his brother’s widow, he spilled his semen on the ground, so that she would not get pregnant and produce children for his older brother. ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Yahweh considered that what he did was wicked, so he caused him to die also. ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Then Judah said to his daughter-in-law Tamar, “Return to your father’s house, but do not marry anyone else. When my youngest son Shelah grows up, he can marry you.” But Judah really did not want Shelah to marry her, because he was afraid that then Shelah would die too, just as his older brothers had died. So Tamar obeyed Judah and went back to live in her father’s house again. ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Several years later, Judah’s wife, who was the daughter of Shua, died. When the time of mourning for her was finished, Judah decided to go up to Timnah, to the place where his ◄men were shearing his sheep/sheep were being sheared► His friend Hiram, from Adullam, went with him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Someone said to Tamar, “Your father-in-law is going to the fields near the city of Timnah to help the men who are shearing his sheep.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","She realized that now Shelah was grown up, but Judah had not given her to him to be his wife. So she took off her widow’s clothes, and covered her head with a veil, so that people would not ◄recognize her/know who she was►. Then she sat down at the entrance to Enaim town, which is on the road to Timnah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","When Judah came along and saw her, he thought that she was a prostitute, because she had covered her head like prostitutes often did (OR, and sat where prostitutes often sat). ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Judah did not realize that she was his daughter-in-law. So he said to her, “Hey, let me have sex EUP with you!” She replied, “What will you give me for allowing you to have sex EUP with me?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","He replied, “I will send you a young goat from my flock of goats.” She asked, “Will you give me something now for me to keep until you send the goat?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","He replied, “What do you want me to give to you?” She replied, “Give me the ring that has your name on it that is tied by a cord around your neck, and give me the walking stick that you are holding in your hand.” So he gave them to her. Then he had sex EUP with her, and she became pregnant. ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","After she left, she took off the veil and put her widow’s clothes on again. ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Judah gave a young goat to his friend from Adullam, for him to take back to the woman, as he had promised. But his friend could not find the woman. ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","So he asked the men who lived there, “Where is the prostitute who was sitting by the road at Enaim?” They replied, “There has never been a prostitute here!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","So he went back to Judah and said, “I did not find her. Furthermore, the men who live in that town said, ‘There has never been a prostitute here.’” ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Judah said, “She can keep the things that I gave to her. If we continued to search for her, people would ridicule us. I tried to send this young goat to her, but you could not find her to give it to her.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","About three months later, someone told Judah, “Your daughter-in-law Tamar has become a prostitute and now she is pregnant!” Judah said, “Drag her outside of the city and kill her by burning her!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","But as they were taking her outside of the city, she gave the ring and walking stick to someone, and told him to take them to Judah, and say to him, “The man who owns these things is the one who caused me to become pregnant.” She also said to tell him, “Look at this ring, and the cord that is attached to it, and this walking stick. Whose are they?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","When the man did that, Judah recognized the ring and the stick. He said, “She is more righteous than I am. I did not tell my son Shelah to marry her, as I promised that I would.” And Judah did not have sex EUP with her again. ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","When it was time for her to give birth, she was surprised that there were twin boys in her womb. ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","As she was giving birth, one of them put out his hand. So the midwife fastened a scarlet thread around his wrist, saying, “This one came out first.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","But he pulled his hand back inside the womb, and his brother came out first. So she said, “So this is how you break your way out first!” So she named him Perez, which sounds like the Hebrew word that means ‘breaking out.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Then his younger brother, the one who had the scarlet thread around his wrist, came out. And he was named Zerah, which sounds like the Hebrew word that means ‘redness of dawn.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Meanwhile, the descendants of Ishmael took Joseph down to Egypt. There Potiphar bought Joseph from them. Potiphar was an Egyptian who was one of the king’s officials and the captain of the king’s ◄palace guards/guards who protected the king►. ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Because Yahweh helped Joseph, he was able to do his work very well, and lived in the house of his Egyptian master. ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","His master saw that Yahweh was helping Joseph and enabling him to be successful in everything that he did. ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Joseph’s master was pleased with him, so he appointed him to be his personal servant. Then he appointed him to be the one who would take care of everything in his household and all of his possessions. ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","From the time Potiphar appointed Joseph to take care of everything in his household and all that he owned, Yahweh blessed the people who lived in Potiphar’s house because of Joseph. He also caused Potiphar’s crops to grow well. ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potiphar allowed Joseph to take care of everything that he owned. Potiphar needed to decide only about the food he ate. He was not concerned about anything else in his house. Joseph was well-built/muscular and handsome. ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Because of that, after a while, his master’s wife started to look fondly at Joseph. So one day she said to him, “Have sex EUP with me!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","But he refused, saying to his master’s wife, “Listen! My master is not concerned about anything in this house. He has appointed me to take care of everything that he owns. ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","No one in this household has more authority than I do. The only thing that he has not allowed me to have is you, because you are his wife! So ◄how could I do this wicked thing that you are asking me to do?/I certainly could not do this wicked thing!► RHQ I would be sinning against God if I did that!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","She kept on asking Joseph day after day to have sex EUP with her, but he refused. He would not even go near her. ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","One day Joseph went into the house to do his work, and none of the other household servants were in the house. ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Potiphar’s wife grabbed his cloak and said, “Have sex EUP with me!” Joseph ran out of the house, but his cloak was still in her hand! ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","When she saw that he had run outside leaving his cloak in her hand, ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","she called the household servants. She said to them, “Look! This Hebrew man that my husband brought to us is ◄insulting/trying to do something disgraceful to► us! He came into my room and tried to ◄rape me/make me have sex EUP with him►, but I screamed loudly. ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","As soon as he heard me scream loudly, he left his loincloth with me and ran outside!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","She kept the loincloth beside her until her husband, Joseph’s master, came home. ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Then she told him this story: “That Hebrew slave whom you brought here came into my room and tried to rape me! ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","As soon as I screamed loudly, he ran outside, leaving me holding his loincloth!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","When Joseph’s master heard this story that his wife told him, saying “This is how your slave treated me,” he was very angry. ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Joseph’s master took Joseph and put him in prison, the place where all the king’s prisoners were put, and Joseph stayed there. ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","But Yahweh was kind to Joseph and helped him, and caused the ◄prison warden/man who was in charge of the prison► to be pleased with him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","So the prison warden put Joseph in charge of all those who were in the prison, and in charge of all the work that was done there. ");
INSERT INTO eng_t4t_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","The warden was not concerned with anything that Joseph was taking care of, because Yahweh helped Joseph to do well everything that he did. ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Some time later, two of the king of Egypt’s officials did things that displeased him. One was his chief ◄drink-server/man who prepared the wine and served it to the king►, and the other was his chief ◄baker/man who baked bread for the king►. ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","The king became angry with both of them. ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","So he had them put in prison, in the house of the captain of the palace guards. That was the place where Joseph was being kept. ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","The two men were in prison for a long time. And during that time the captain of the palace guards appointed Joseph to be their servant, to take care of their needs. ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","One night while the king’s drink-server and his baker were there in the prison, each of them had a dream. Each dream had a different meaning. ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","The next morning, when Joseph came to them, he saw that both of them were dejected/worried. ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","So he asked them, “Why do you look so sad today?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","One of them answered, “We both had dreams last night, but there is no one who can tell us the meaning of the dreams.” Joseph said to them, “God is the only one who can RHQ tell the meaning of dreams. So tell me what you dreamed, and God will tell me the meaning.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","So the king’s chief drink-server told his dream to Joseph. He said, “In my dream I saw a grapevine in front of me. ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","On the vine there were three branches. After the branches budded, they blossomed, and then they produced clusters of grapes. ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","I was holding the king’s cup, so I took the grapes and squeezed the juice into the cup. Then I gave the cup to the king to drink the juice.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","God immediately told Joseph what the dream meant. So Joseph said to him, “This is the meaning of your dream: The three branches of the vine represent three days. ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Within three days the king will release you from prison. He will let you do the work that you did before. You will take cups of wine to the king as you did before, when you were his drink-server. ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","But when you are out of prison and everything goes well for you, please do not forget me. ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","People took me away forcefully from the land where my fellow Hebrews live. I did nothing wrong there, and also while I have been here in Egypt, I have done nothing for which I deserved to be put in prison. So be kind to me and tell the king about me, so that he will release me from this prison!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","When the chief baker heard that the meaning of the dream of the king’s drink-server was very favorable, he said to Joseph, “I also had a dream. In the dream I was surprised to see three baskets of bread stacked on my head. ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","In the top basket there were many kinds of baked goods for the king, but birds were eating them from the top basket that was on my head!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","God again told Joseph what the dream meant, so he said, “The three baskets also represent three days. ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Within three days the king will command that your head be cut off. Then your body will be hung on a tree, and vultures will come and eat your flesh.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","The third day after that was the ◄king’s birthday/day they celebrated when the king became one year older►. On that day the king invited all his officials to celebrate his birthday. During the celebration, while they were all gathered there, the king summoned his chief drink-server and chief baker from the prison. ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","He said that his chief drink-server could have his previous job again, so that again he took cups of wine to the king. ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","But he commanded that the chief baker should be killed by being hanged, just as Joseph had said would happen when he told the two men the meaning of their dreams. ");
INSERT INTO eng_t4t_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","But the chief drink-server did not think about Joseph. He forgot to do what Joseph asked him to do. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Two complete years later, the king of Egypt had a dream. In the dream, he was standing alongside the Nile River. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Suddenly seven healthy fat cows come up out of the river. They started eating the grass that was on the riverbank. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Soon seven other cows, unhealthy-looking and thin, came up behind them from the Nile River. They stood alongside the fat cows that were on the riverbank. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Then the unhealthy thin cows ate the seven healthy fat cows. And then the king woke up. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","The king went to sleep again, and he had another dream. This time he saw seven heads of grain that were full of kernels of grain and ripe, and all growing on one stalk. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","After that, the king saw that seven other heads of grain sprouted on that (OR, on another) stalk. They were thin and had been dried up by the hot east wind. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Then the thin heads of grain swallowed up the seven ripe full heads. Then the king woke up. He realized that he had been dreaming. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","But the next morning he was worried about the meaning of the dream. So he summoned all the magicians and wise men who lived in Egypt. He told them what he had dreamed, but none of them could tell him the meaning of the two dreams. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Then the chief drink-server said to the king, “Now I remember something that I should have told you! I made a mistake by forgetting to tell it to you. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","One time you were angry with two of us. So you put me and the chief baker in the prison in the house of the captain of the palace guards. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","While we were there, one night each of us had a dream, and the dreams had different meanings. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","There was a young Hebrew man there with us. He was a servant of the captain of the palace guards. We told him what we had dreamed, and he told us what our dreams meant. He told each of us the meaning of our dreams. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","And what happened was exactly the same as the meanings that he told us: You said I could have my previous job again, but the other man was killed by being hanged. The Hebrew man’s name was Joseph.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","When the king heard that, he told some servants to bring Joseph to him, and they quickly brought Joseph out of the prison. Joseph shaved and put on better clothes, and then he went and stood in front of the king. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","The king said to Joseph, “I had two dreams, and no one can tell me what they mean. But someone told me that when you hear someone tell about a dream he has had, you can tell that person what the dream means.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","But Joseph replied to the king, “No, I cannot do that. It is God who knows the meaning of dreams, but he will enable me to tell you their meaning, and they will mean something good.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","The king said to Joseph, “In my first dream I was standing on the bank of the Nile River. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Suddenly seven healthy fat cows came up out of the river, and they started eating the grass that was on the riverbank. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Soon seven other cows, ugly and thin ones, came up behind them from the river. I never saw such ugly cows in all the land of Egypt! ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","The thin ugly cows ate the seven fat cows that came up first. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","But afterwards, no one would have known that the thin cows ate them, because they were just as ugly as they were before. Then I woke up. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Then I had another dream. I saw seven heads of grain. They were full of kernels of grain and ripe, and they were all growing on one stalk. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Then to my surprise I saw seven other heads of grain that sprouted. They were thin and had been dried up by the hot east wind. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","The thin heads of grain swallowed the seven good heads. I told these dreams to the magicians, but none of them could explain to me what they meant.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Then Joseph said to the king, “Both your dreams have the same meaning. God is revealing to you in your dreams what he is about to do. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","The seven healthy cows represent seven years. The seven good heads of grain also represent seven years. The two dreams both have the same meaning. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","The seven thin ugly cows that came up behind them and the seven worthless heads of grain that were dried up by the hot east wind each represent seven years ◄of famine/when food will be very scarce►. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","It will happen just as I have told you, because God has revealed to you what he is about to do. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","There will be seven years in which there will be plenty of food throughout the land of Egypt, ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","but after that there will be seven years ◄of famine/when food will be very scarce►. Then people will forget all the years when there was plenty of food, because the famine that will come afterward will ruin the country. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","The people will forget how plentiful food was previously, because the famine will be very terrible. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","The reason God gave to you two dreams is that he wants you to know that this will happen, and he will cause it to happen very soon. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Now I suggest that you should choose a man who is wise and can make good decisions. I suggest that you appoint him to direct the affairs of the whole country. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","You should also appoint supervisors over the country, in order that they can arrange to collect one-fifth of all the grain that is harvested during the seven years when food is plentiful. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","They should collect this amount of grain during those seven years that are coming, when there will be plenty of food. You should supervise them as they store it in the cities. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","This grain should be stored so that it can be eaten during the seven years when there will be a famine here in Egypt, so that the people in this country will not die from hunger.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","The king and his officials thought that this would be a good plan. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","So the king said to them, “◄Can we find any other man like Joseph, a man to whom God has given his Spirit?/It is not likely that we will find another man like this man, one to whom God has given his Spirit!►” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Then the king said to Joseph, “Because God has revealed all this to you, it seems to me that there is no one who is as wise as you and who can decide wisely about things. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","So I will put you in charge of everything in my palace. All the people here in Egypt must obey what you command. Only because I am king MTY will I have more authority than you.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Then the king said to Joseph, “I am now putting you in charge of the whole country of Egypt.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","The king took from his finger the ring that had his seal on it, and he put it on Joseph’s finger. He put robes made of fine linen on him, and he put a gold chain around his neck. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Then he arranged for Joseph to ride around in the chariot that showed that he was the second-most important man in the country. When Joseph rode in the chariot, men shouted to the people who were on the road in front of him, “Get off the road!” So the king put Joseph in charge of everything in the country. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","The king said to Joseph, “I am the king, but no one in the whole land of Egypt will do anything IDM if you do not permit them to do it.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","The king gave Joseph a new name, Zaphenath-Paneah. He also gave him Asenath to be his wife. She was the daughter of Potiphera, who was a priest in a temple in On city. Then Joseph became known (OR, traveled) through all the land of Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joseph was 30 years old when he started to work for the king of Egypt. To do his work, he left the king’s palace and traveled throughout Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","During the next seven years, the land produced abundant crops, so there was plenty of food. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","As Joseph supervised them, his helpers collected one-fifth of all the grain that was produced during those years, and stored it in the cities. In each city, he had his helpers store up the grain that was grown in the fields that surrounded that city. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Joseph had them store up a huge amount of grain. It looked as plentiful as the sand on the seashore. There was so much grain that after a while they stopped keeping records of how much grain was stored, because there was more grain than they could measure. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Before the seven years of famine started, Joseph’s wife Asenath gave birth to two sons. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph named the first one Manasseh, which sounds like the Hebrew word that means ‘forget’, because, he said, “God has caused me to forget all my troubles and all my father’s family.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","He named his second son Ephraim, which means ‘to have children’, because, he said, “God has given me children here in this land where I have suffered.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Finally the seven years in which there was plenty of food ended. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Then the seven years of famine started, just as Joseph had predicted. There was also a famine in all the other nearby lands, but although the crops did not grow, there was food everywhere in Egypt, because of the grain they had stored up in the cities. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","When all the people of MTY Egypt had eaten all of their own food and were still hungry, they begged the king for food. So the king told all the people of Egypt, “Go to Joseph, and do what he tells you to do.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","When the famine was very bad throughout the whole country, Joseph ordered his helpers to open the storehouses. Then they sold the grain in the storehouses to the people of Egypt, because the famine was very severe all over Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","And people from many HYP nearby countries came to Egypt to buy grain from Joseph, because the famine was very severe everywhere HYP. ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","When someone told Jacob that there was grain in Egypt that people could buy, he said to his sons, “◄Why do you just sit there looking at each other?/Do not just sit there looking at each other!► RHQ We need some grain!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","He said to them, “Someone told me that there is grain for sale in Egypt. Go down there and buy some for us, in order that we will not die!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","So Joseph’s ten older brothers went down to Egypt to buy some grain. ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","But Jacob did not send Benjamin, Joseph’s younger brother, to go with the others, because he was afraid/worried that something terrible might happen to him like what happened to Joseph. ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","So Jacob’s other sons went down from Canaan to Egypt to buy grain, and others from there went too, because there was a famine in Canaan also. ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","At that time Joseph was the governor of Egypt. He was the one who sold grain to people who came from all over Egypt and from many other countries HYP to buy grain. So when Joseph’s brothers arrived, they were told that it was necessary for them to talk with Joseph. So they went to him and prostrated themselves before him with their faces to the ground. ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","As soon as Joseph saw his brothers, he recognized them. But he pretended that he did not know them. He spoke harshly to them, saying, “Where do you come from?” One of them replied, “We have come from Canaan, to buy some grain.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Although Joseph recognized his brothers, they did not recognize him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","And then Joseph remembered what he had dreamed about them many years previously. But he decided not to tell them yet that he was their younger brother. He said to them, “You are spies! You have come to find out whether we will be able to defend ourselves if you attack us!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","One of them replied, “No, sir! We have come to buy grain. ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","We are all sons of one man. We are honest men, not spies.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","He said to them, “I do not believe you. You have come just to see whether we would be able to defend ourselves if we were attacked!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","But one of them replied, “No, that is not true! Originally there were twelve of us who were brothers, the sons of one man. Our younger brother is with our father. One younger brother has died. EUP” ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Joseph replied, “You are lying! I think it is just as I told you. You are spies! ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","But this is how I will determine whether what you are saying is true. I think that as surely as the king lives, you are spies. And you will not leave this place until your youngest brother comes here! ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Send one of your group to go and get your younger brother and bring him here. I will put the rest of you in prison, in order that I may test what you have said to find out whether what you are telling me is true. If the one who goes does not bring your younger brother here, then, just as surely as the king lives, it will be clear that you are lying and that you are spies.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Then Joseph put them all in prison for three days. ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","On the third day, Joseph went to the prison and said to them, “I am a man who fears that God will punish me if I do not do what I promise. So do what I tell you, and I will spare your lives. ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","If you are honest men, let one of your brothers stay here in prison, and the rest of you can take some grain back to your families who are very hungry because of the famine. ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","But if you come back here again, you must bring your youngest brother to me, so that you can prove that what you told me is true, and as a result I will not have you executed.” So they agreed to do that. ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","They said to each other, “It is surely because of what we did to our younger brother that ◄we are being punished/God is punishing us►! We saw that he SYN was very distressed when he pleaded with us not to harm him. But we did not pay any attention to him, and that is why we are having this trouble!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reuben said to them, “I told you not to harm the boy RHQ, but you did not pay attention to what I said! Now we are being ◄paid back/punished► for killing him MTY!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","While they were talking with Joseph, they were speaking through ◄an interpreter/someone who knew their language and the Egyptian language►, but when they said these things among themselves, they were speaking in their own language, and they did not know that Joseph could understand their language, and that he could understand what they were saying. ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Because of what they said, Joseph realized that they admitted that what they had done to him many years previously was wrong. He could not keep from crying, and he did not want them to see him crying, so he left them and went outside the room and began to cry. But then he returned to them and talked to them again. Then he took Simeon, and while they were watching, he told his servants to tie him up. He left Simeon in the prison and told the others that they could go. ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Joseph told his servants to fill the men’s sacks with grain, but he also told them to put the money that each one had paid for the grain in the top of his sack. He also told them to give them food to eat along the way. After the servants did those things for Joseph’s older brothers, ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","his older brothers loaded the sacks of grain on their donkeys and left. ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","At the place where they stopped to sleep that night, one of them opened his sack to get some grain for his donkey. He was amazed to see his money in the top of the sack. ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","He exclaimed to his brothers, “Someone has returned my money! Here it is in my sack!” They started shaking with fear, and said to each other, “What is this that God has done to us?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","When they returned to their father in Canaan land, they told him all that had happened to them. One of them said, ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“The man who governs the whole land of Egypt talked very harshly to us. He acted toward us as though we were spying on his country. ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","But we told him, ‘We are honest men! We are not spies. ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Originally there were twelve of us who were brothers, the sons of one father. One has died EUP, and our youngest brother is with our father in Canaan.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","The man who is the governor of the land did not believe us, so he said to us, ‘This is how I will know if you are truly honest men: Leave one of your brothers here with me. Then the rest of you can take some grain for your families that are starving from hunger and go. ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","But when you return, bring your youngest brother to me, in order that I will know that you are not spies, but instead, that you are honest men. Then I will release your brother for you. And then you can buy whatever you want in this country.’” ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","As they were emptying their sacks, they were surprised that in each man’s sack was his pouch of money! When they and their father saw all the pouches of money, they were frightened. ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Their father Jacob said to them, “You have caused two of my children to be taken from me! Joseph is dead, and Simeon is gone! And now you want to take Benjamin from me! It is I who am suffering because of all these things that are happening!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Reuben said to his father, “I will be responsible for Benjamin. I will take him to Egypt and bring him back to you. Let me take care of him. If I do not bring Benjamin back to you, you may kill both of my sons.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","But Jacob said, “No, I will not let my son go down there with you. His older brother is dead, and he is the only one of my wife Rachel’s sons who is left! If something harms him while you are traveling, you would cause me, a gray-haired old man, to die because of sorrow.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","The famine in Canaan got worse. ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Finally, when Jacob and his family had eaten all the grain they had brought from Egypt, Jacob said to them, “Go back to Egypt and buy some more grain for us!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","But Judah said to him, “The man who sold us the grain warned us sternly, ‘I will not let you see me SYN again if you come and your younger brother is not with you.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","So, if you will send our younger brother with us, we will go down to Egypt and buy some grain for you. ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","But if you will not send him, we will not go down there, because that man said to us, ‘I will not let you see me again if your younger brother is not with you.’” ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Jacob asked, “Why did you cause me to have this trouble by telling the man that you had a younger brother?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","One of them replied, “The man asked about us and about our family. He said, ‘Is your father still living? Do you have another brother?’ We had to answer his questions. ◄We could not know that he would say, ‘The next time that you come down here, bring your brother with you!’/How could we know that he would say, ‘The next time that you come down here, bring your brother with you!’►” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Then Judah said to his father Jacob, “Send the boy with me, and we will go immediately, in order that we and you and our children may get grain and not die from hunger. ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","I myself will guarantee that he will return. You can require me to do what I am promising IDM. If I do not bring him back to you safely, you can say forever that ◄I am to blame/it was my fault that he did not return to you►. ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","If we had not ◄wasted so much time/waited so long►, by now we could have gone there and returned two times!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Then their father Jacob said to them, “If there is no other way, do this: Put in your sacks some of the best things that are grown in this land, and take them down to the man as a gift. Take some balm/perfume and honey and spices and myrrh/ointment, some pistachio nuts, and almonds. ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Take twice as much money as you took the previous time, because you must return the silver that someone put in the tops of your sacks. Perhaps it was a mistake that it was put in your sacks. ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Take your younger brother and go back to that man. ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","I will pray that God Almighty will cause that man to act mercifully toward you, so that he will let your other brother, as well as Benjamin, come back here with you. But as for me, if my sons are taken from me, then I will not have my sons!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","So the men took the gifts that Jacob said that they should take, and twice the amount of money that the grain would cost, and they also took Benjamin. They went down quickly to Egypt, and they stood in front of Joseph. ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","When Joseph saw Benjamin with them, he said to the man who ◄was in charge of/supervised► things in his house, “Take these men to my house. Slaughter an animal and prepare a meal, because I want them to eat with me at noon.” And he told him in what order they were to be seated. ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","The man did as Joseph said. And he took them to Joseph’s house. ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","But they were afraid because he was taking them to Joseph’s house. They were thinking, “He is taking us here because of the silver that was put in our sacks the first time that we came here. While we are eating, he will have his servants attack us and seize us and cause us to become his slaves, and also take our donkeys.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","They went with the man who was in charge of things in Joseph’s house. When they arrived at the entrance of the house, ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","one of them said to him, “Please, sir, listen to me. We came down here previously and bought some grain. ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","But at the place where we stopped for the night as we were returning home, we opened our sacks. We were astonished to see that in the top of each of our sacks was the exact amount of silver that we had paid for the grain! So we have brought it back with us. ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","We have also brought more silver with us to buy more grain. We do not know who put the silver in our sacks.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","The man replied, “Relax! Do not worry about it! I received the silver that you brought. Your God, the God your father worships, must have put it in your sacks.” And then he brought Simeon to them from the prison. ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Then he took them into Joseph’s house. He gave them water to wash their feet and gave them food for the donkeys. ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","He told them that they were going to eat with Joseph at noon. So the men prepared their gifts to give to Joseph when he arrived. ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","When Joseph came home, they presented to him the gifts that they had brought into the house. Then they bowed down to the ground in front of him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","He asked them if they were ◄well/in good health►, and then he asked, “How is the health of your old father, the one that you told me about? Is he still living?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","One of them replied, “Yes, our father, who is willing to be your servant, is still alive, and he is well.” Then again they bowed down in front of him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Then he saw his younger brother Benjamin, his own mother’s other son. He asked them, “Is this your youngest brother, the one whom you told me about?” After they said “Yes,” he said to Benjamin, “Young man, I pray that God will act kindly toward you.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Joseph quickly left the room. He realized that he was about to cry because he ◄was full of emotion about his younger brother/loved his younger brother so much►. He went into his private room and cried there. ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Then, after he washed the tears from his face, he came out, and controlling his emotions, he said to the servants, “Serve the food!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","The people of Egypt considered that it was disgraceful for them to eat with Hebrews, so the servants served food to Joseph by himself, and served the other people of Egypt who ate with him by themselves, and they served Joseph’s older brothers and younger brother by themselves. ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","His brothers were astonished to see that their seats were arranged according to their ages, from the oldest to the youngest! ");
INSERT INTO eng_t4t_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","And when their portions of food were served to them from Joseph’s table, Benjamin’s portion was five times as much as anyone else’s portion! So they ate food and drank wine with Joseph and became very cheerful. ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","When his brothers were ready to return home, Joseph said to the man who was in charge of things in his house, “Fill the sacks of those men with as much grain as they can carry on their donkeys. And put in the top of each man’s sack the silver that he paid for the grain. ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Then put my silver cup in the top of the youngest brother’s sack, along with the silver that he paid for the grain.” So the servant did what Joseph told him to do. ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","The next morning at dawn the men started on the way home with their donkeys. ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","When they had not gone far from the city, Joseph said to the servant in charge of things in his house, “Pursue those men immediately. When you catch up to them, say to them, ‘We did good things for you! Why have you paid us back by doing something bad to us? ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","You have stolen the cup that my master drinks from RHQ! It is the cup that he uses to find out things that nobody knows! What you did was very wicked!’” ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","The servant left immediately and when he caught up with them, he told them what Joseph had told him to say. ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","But one of them replied to him, “Sir, why do you say such things? We are your servants, and we would never do anything like that! ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","We even brought back to you from Canaan land the silver that we found inside the tops of our sacks! So ◄we certainly would not steal silver or gold from your master’s house!/Why would we steal silver or gold from your master’s house?► RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","If you discover that any of us has that cup, you can execute him, and the rest of us will become your slaves.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","The man replied, “Okay, I will do what you say. But the one who has the cup will not be executed. Instead, he will become my slave, and the rest of you may return home.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Each of the men quickly lowered his sack down from the donkey to the ground and opened it. ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Then the servant started to search for the cup in each sack. He started with the oldest brother’s sack and ended with the youngest one’s sack. And he found the cup in Benjamin’s sack and showed it to them. ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","The brothers tore their clothes because they were so dismayed. They loaded the sacks on the donkeys again and returned to the city. ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","When Judah and his older and younger brothers entered Joseph’s house, Joseph was still there. The servant told Joseph what had happened. Then the brothers threw themselves down on the ground in front of Joseph. ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","He said to them, “Why did you do this? Do you not know that a man like me can find out things that nobody knows?” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judah replied, “Sir, what can we say? How can we prove that we ◄are innocent/did not steal the cup►? God has ◄paid us back/punished us► for the sins we committed many years ago. So now we will become your slaves—both we and the one in whose sack the cup was found.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","But Joseph replied, “No, I could never do anything like that. Only the man in whose sack the cup was found will become my slave. The rest of you can return to your father peacefully.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Then Judah came near to Joseph and said, “Sir, please let me say something to you. You are equal to the king himself, so you could command that I be executed; but do not be angry with me for speaking to you. ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","You asked us, ‘Is your father still living, and do you have another brother?’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","We answered, ‘Our father is alive, but he is an old man. He has a young son who was born after our father became an old man. That son had an older brother, who is now dead. So the youngest son is the only one of his mother’s sons who is still alive, and his father loves him very much.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Then you said to us, ‘The next time you come here, bring your younger brother down to me, so that I can see him.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","We said to you, ‘No, we cannot do that, because the boy cannot leave his father. If he leaves his father, his father will die from sorrow.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","But you told us, ‘If your youngest brother does not come back with you, I will not let you see me again!’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","When we returned to our father, we told him what you said. ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Months later our father said, ‘Go back to Egypt and buy some more grain!’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","But we said, ‘We cannot go back by ourselves. We will go only if our youngest brother is with us. We will not be able to see the man who sells grain if our youngest brother is not with us.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Our father replied, ‘You know that my wife Rachel gave birth to two sons for me. ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","One of them disappeared, and I said, “A wild animal has surely torn him to pieces.” And I have not seen him since then. ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","I am an old gray-haired man. If you take this other one from me, too, and something harms him, you would cause me to die because of my sorrow.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“So please listen. My father will remain alive only if his youngest son remains alive. ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","If he sees that the boy is not with us when we return to him, he will die. We will cause our gray-haired father to die because of his sorrow. ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","I guaranteed/promised to my father that the boy would return safely. I told him, ‘You can require me to do what I am promising. If I do not bring him back to you, you can say forever that ◄I am to blame/it is my fault► for not bringing him back to you.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“So, please let me remain here as your slave instead of my youngest brother, and let the boy return home with his other older brothers. ");
INSERT INTO eng_t4t_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","◄I cannot return to my father if the boy is not with me!/How can I return to my father if the boy is not with me?► RHQ I do not want to see how miserable/sad my father would become!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Joseph was not able to control his feelings any longer. He did not want to cry in front of his servants, so he said to them loudly, “All of you go outside!” After they went outside, there was no one else there with Joseph when he told his brothers who he was. ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","He cried so loudly that the people of Egypt who were outside heard it, and even the people in the king’s palace heard it. ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Joseph said to his brothers, “I am Joseph! Is our father still alive?” But his brothers were not able to reply, because they were frightened because of what he said. ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Then Joseph said to his brothers, “Come close to me!” When they came closer, he said, “I am your brother Joseph! I am the one you sold to traders who brought me here to Egypt! ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","But now, do not be distressed, and do not be angry with yourselves for having sold me to people who brought me here, because it was to save you from dying because of the famine that God sent me here ahead of you. ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","There has been a famine in this country for two years, and it will continue for five more years, so that no one will plow ground, and there will be no crops to harvest. ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","But God sent me here ahead of you, to keep you from starving, and to make sure that your descendants will survive. ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Therefore, it was not you who sent me here; it was God who sent me here! He has caused me to become like a father to the king. I am in charge of everything in his palace and the governor of everyone in Egypt! ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Now return to my father quickly, and say to him, ‘This is what your son Joseph says: “God has caused me to become the governor over the whole land of Egypt. Come down to me immediately! ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","You can live in the Goshen region. You and your children and your grandchildren, your sheep and goats and cattle, and everything that you own, will be near me. ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Since there will be five more years of famine, I will make sure that you have food. If you do not come here, you and your family and all of your servants will starve. EUP”’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Look closely, and all of you can see, including my brother Benjamin, that it is really I, Joseph, who am speaking to you. ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Go and tell my father about how greatly I am honored here in Egypt. And tell him about everything else that you have seen. And bring my father down here quickly!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Then he threw his arms around his younger brother Benjamin’s neck and cried. And Benjamin hugged him and cried. ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","And then as he kissed his older brothers on their cheeks, he cried. After that, his brothers started to talk with him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Someone went to the palace and told the news that Joseph’s brothers had come. The king and all his officials were pleased. ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","The king said to Joseph, “Tell your brothers this: ‘Put loads of grain on your animals and return to the Canaan region. ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Then bring your father and your families back here. I will give you the best land in Egypt, and you will have the best food in the land to eat.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Also tell this to your brothers: ‘Take some carts from Egypt to carry your children and your wives, and get them and your father and come back here quickly. ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Do not worry about bringing your possessions, because the best things in Egypt will be yours. Because of that, you will not need to bring any of your things from Canaan.’” ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Jacob’s sons did what the king suggested. Joseph gave them carts and food to eat along the way, as the king had ordered. ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","To each of them he gave new clothes, but he gave 300 pieces of silver and five sets of new clothes to Benjamin! ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","And this is what he sent to his father: Ten male donkeys, loaded with some of the best goods that come from Egypt, and ten female donkeys loaded with grain and bread and other food for his father’s trip to Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Then he sent his brothers on their way, saying to them “Do not quarrel along the way!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","So they left Egypt and came to their father Jacob in Canaan. ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","One of them told him, “Joseph is still alive! In fact, he is the governor over all of Egypt!” Jacob was extremely astonished; he could not believe that it was true. ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","But they told him everything that Joseph had said to them, and Jacob saw the carts that Joseph had sent to carry him and his family and possessions to Egypt. Then their father Jacob’s shock ended. ");
INSERT INTO eng_t4t_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","He said, “What you have said is enough to convince me! My son Joseph is still alive, and I will go and see him before I die!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","So Jacob left Canaan, taking with him all his family and possessions. When they arrived at Beersheba, he offered sacrifices to God, the one whom his father Isaac worshiped. ");
INSERT INTO eng_t4t_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","That night, God called to Jacob in a vision, saying, “Jacob! Jacob!” He replied, “I am here!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","God said, “I am God, the one your father worshiped. Do not be afraid to go down to Egypt, because I will give you many descendants, and they will become a great nation there. ");
INSERT INTO eng_t4t_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","I will go down to Egypt with you, and later I will bring your descendants back to Canaan again. And Joseph will be with you MTY when you die.” IDM ");
INSERT INTO eng_t4t_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Jacob left Beersheba, and his sons took their father, their wives, and their children, in the carts that the king had sent for them to travel in. ");
INSERT INTO eng_t4t_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","So Jacob and all his family went to Egypt. They took with them the livestock and all the other possessions that they had acquired in Canaan. ");
INSERT INTO eng_t4t_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Jacob went to Egypt with all his sons and his daughters and grandsons and granddaughters—his whole family. ");
INSERT INTO eng_t4t_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","25","◄Here is/I will now give you► a list of the names of the members of Jacob’s family who went with him to Egypt: Reuben, Jacob’s oldest son; Reuben’s sons Hanoch, Pallu, Hezron, and Carmi; Simeon and his sons Jemuel, Jamin, Ohad, Jakin, Zohar, and Shaul, who was the son of a Canaan people-group woman; Levi and his sons Gershon, Kohath, and Merari; Judah and his sons, Shelah, Perez, and Zerah (his other sons, Er, and Onan, had died in Canaan); Perez and his two sons Hezron and Hamul; Issachar and his sons Tola, Puah, Jashub, and Shimron; Zebulon and his sons Sered, Elon, and Jahleel; (Those were the sons of Jacob and Leah, and their daughter Dinah, who were born in Paddan-Aram/Mesopotamia: There were 33 of them, altogether.) They had Gad and his sons Zephon, Haggi, Shuni, Ezbon, Eri, Arodi, and Areli; Asher and his sons Imnah, Ishvah, Ishvi, and Beriah; and their sister Serah; Beriah’s sons Heber and Malkiel; (Those were the children and grandchildren of Jacob and Zilpah, the slave girl whom Laban gave to his daughter Leah: There were 16 of them, altogether.) Joseph and Benjamin, the sons of Jacob’s wife Rachel; (Ephraim and Manasseh were Joseph’s two sons. They did not go down to Egypt because they were already in Egypt. They were sons of Asenath, the daughter of On, who was the priest in the temple in On city.) Benjamin and his sons Bela, Beker, Ashbel, Gera, Naaman, Ehi, Rosh, Muppim, Huppim, and Ard; (Those were the sons and grandsons of Rachel and Jacob: There were 14 people altogether.) Dan and his son Hushim; Naphtali and his sons Jahziel, Guni, Jezer, and Shillem. (Those were the sons and grandsons of Jacob and Bilhah, the slave girl whom Laban gave to his daughter Rachel: There were seven people altogether.) ");
INSERT INTO eng_t4t_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Altogether there were 66 people who were Jacob’s descendants who went to Egypt with him. That number does not include his sons’ wives. ");
INSERT INTO eng_t4t_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Including Jacob and Joseph and Joseph’s two sons who were born in Egypt, there were 70 members of Jacob’s family when they were all there in Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob sent Judah to go ahead of the rest of them to talk with Joseph and ask for directions on how to travel to Goshen. Then Judah returned to the rest of his family and they all traveled to the Goshen region. When they arrived there, ");
INSERT INTO eng_t4t_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joseph got his chariot ready and went to Goshen to meet his father. When Joseph arrived, he threw his arms around his father’s neck and cried a long time. ");
INSERT INTO eng_t4t_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Jacob said to Joseph, “I have seen you and I know that you are still alive! So now I am ready to die.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Then Joseph said to his older brothers and younger brother and to the rest of his father’s family, “I will go to the king and say to him, ‘My older brothers and younger brother and my father and the rest of his family, who were living in Canaan land, have all come to me. ");
INSERT INTO eng_t4t_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","The men are all shepherds. They take care of their livestock, and they have brought with them their sheep and goats and cattle, and everything else that they own.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","When the king summons you and asks, ‘What work do you do?’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","answer him by saying, ‘From the time when we were young, we have taken care of livestock, just as our ancestors did.’ If you tell him that, he will let you live in the Goshen region.” Joseph told them to say that because the people of Egypt despised all shepherds. ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Joseph chose five of his older brothers to go with him to talk to the king. He introduced his older brothers to the king, and then he said, “My father and my older brothers and younger brother have come from the Canaan region. They have brought all their sheep and goats and cattle and everything else that they own, and they are living now in Goshen region.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","The king asked the brothers, “What work do you do?” They replied, “We are shepherds, just as our ancestors were.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","They also said to him, “We have come here to live for a while in this land, because the famine is very severe in Canaan, and our animals have no ◄pasture/grass to eat► there. So now, please let us live in the Goshen region.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","The king said to Joseph, “I am happy that your father and your older brothers and younger brother have come to you. ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","They can live wherever you want in the whole country of Egypt. Give your father and your brothers the best part of the land. They can live in Goshen. And if you know that any of them have any special ability to work with livestock, have them be in charge of my own livestock, too.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Then Joseph brought his father Jacob into the palace and introduced him to the king. Jacob asked God to bless the king. ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Then the king asked Jacob, “How old are you?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacob replied, “I have been traveling around for 130 years. I have not lived as long as my ancestors, but my life has been full of troubles.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Then Jacob again asked God to bless the king, and left him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","That is how Joseph enabled his father and older brothers and younger brother to start living in Egypt. As the king had commanded, he gave them property in the best part of the land, in Goshen, which is now called Rameses. ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Joseph also provided food for all his father’s family. The amounts that he gave them were according to how many children each of them had. ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","There were no crops growing in the whole region, because the famine was very severe. The people of Egypt and Canaan MTY became weak because they did not have enough food to eat. ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Joseph collected all the money that the people in Egypt and Canaan paid for the grain they were buying from him, and he brought the money to the king’s palace. ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","When the people of Egypt and Canaan had spent all their money for grain, they all kept coming to Joseph and saying, “Please give us some food! If you do not give us grain, we will die RHQ! We have used all our money to buy food, and we have no money left!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Joseph replied, “Since your money is all gone, bring me your livestock. If you do that, I will give you food in exchange for your livestock.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","So they brought their livestock to Joseph. He gave them food in exchange for their horses, their sheep and goats, their cattle, and their donkeys. ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","The next year they came to him again and said, “We cannot hide this from you: We have no more money, and now our livestock belongs to you. We have only our bodies and our land to give to you. We have nothing else left. ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","◄If you do not give us some food, we will die!/Do you want to watch us die?► RHQ If you do not give us seeds, our fields will become useless IDM. Buy us and our land in exchange for food. Then we will be the king’s slaves, and he will own the land. Give us seeds that we can plant and grow food, in order that we will not die, and in order that our land will not become like a desert.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","So Joseph bought all the farms in Egypt for the king. The people of Egypt each sold their land to him because the famine was very severe, and they had no other way to get money to buy food. So all the farms became the king’s farms. ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","As a result, Joseph caused all the people from one border of the country to the other to become the king’s slaves. ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","But he did not buy the priests’ land, because they received food from the king regularly, so the food that the king gave them was enough for them. That is the reason they did not sell their land to him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Joseph said to the people who sold themselves and their land to him, “Listen to me! Today I have bought you and your land for the king. So here are seeds for you so that you can plant them in the ground. ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","But when you harvest the crop, you must give one-fifth of the crop to the king. The rest of the crop you can keep, to be seed to plant in the fields, and to be food for you and your children and for everyone else in your household to eat.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","They replied, “You have saved our lives! We want you to be pleased with us. And we will be the king’s slaves.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","So Joseph made a law about all the land in Egypt, stating that one-fifth of the crops that are harvested belongs to the king. That law still exists. Only the land that belonged to the priests did not become the king’s land. ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Jacob and his family started to live in Egypt, in the Goshen region. They acquired property there. Many children were born to them there. As a result, their population increased greatly. ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob lived in Egypt 17 years. Altogether he lived 147 years. ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","When it was almost time for him to die, he summoned his son Joseph and said to him, “If I have pleased you, make a solemn promise that you will be kind to me and faithfully do what I am now asking you: When I die, do not bury me here in Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Instead, take my body out of Egypt, and bury it in Canaan where my ancestors are buried.” Joseph replied, “I will do that.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Jacob said, “◄Swear/Solemnly promise► to me that you will do it!” So Joseph swore to do it. Then Jacob turned over in bed, bowed his head, and worshiped God. ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Some time later, someone told Joseph, “Hey, your father is ill.” When Joseph heard that, he took his two sons, Manasseh and Ephraim, to see his father. ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","When someone told Jacob, “Look, your son Joseph has come to see you!” Jacob sat up on the bed, even though it was difficult for him to do that. ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","He said to Joseph, “When I was at Luz in Canaan, God Almighty appeared to me. He blessed me ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","and said to me, ‘I am going to enable you to become the father of many children. You will have many descendants, and they will become the ancestors of many people-groups. And I will give this land to your descendants to possess forever.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“And now I will consider that your two sons, who were born to you here in Egypt before I came here, will ◄belong to me/be as though they are my sons►. Ephraim and Manasseh will be as though they were my sons, and they will inherit my possessions, just like my sons Reuben and Simeon and the others will. ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","If you later become the father of any more children, they will not be considered to be my children, but as my grandchildren, and in Canaan they will receive as part of what they inherit some of the same land that is in the territory that their brothers Ephraim and Manasseh will inherit. ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Many years ago, as I was returning from Paddan-Aram/Mesopotamia, your mother Rachel died in the Canaan region, while we were still traveling, not far from Ephrath town. So I buried her body there alongside the road to Ephrath which is now called Bethlehem.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","When Jacob saw Joseph’s sons, he asked, “Who are these boys?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph replied, “They are the sons that God has given to me here in Egypt.” Jacob said, “Bring them close to me so that I can bless them.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Jacob was almost blind because he was very old. He could not recognize the boys. So Joseph brought his sons close to his father, and Jacob kissed them and hugged them. ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Jacob said to Joseph, “I did not expect to see you again, but look at this! God has allowed me to see not only you, but he has allowed me to see your children, too!” ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Joseph took the boys from alongside Jacob’s knees. Then he bowed down with his face to the ground. ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Then Joseph took both of the boys, putting Ephraim on his right side toward Jacob’s left hand, and putting Manasseh on his left side toward Jacob’s right hand, and brought them close to Jacob. ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","But Jacob did not do what Joseph wanted him to do. Instead, he reached out his right hand and put it on Ephraim’s head, even though he was the younger son. He crossed his arms and put his left hand on Manasseh’s head, even though Manasseh was the older son. ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Then he ◄blessed/asked God to bless► Joseph and his sons, saying, “My grandfather Abraham and my father Isaac conducted their lives as God desired, and to this very day God has led me and taken care of me as a shepherd leads and cares for his sheep MET. ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","The angel whom he sent has kept me from being harmed in any way. I pray that God will bless these boys. I pray that people will never forget about me and about Abraham and Isaac because of what God does for these boys. I pray that they will have many descendants who will live all over the earth.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","When Joseph saw that his father had placed his right hand on Ephraim’s head and not on Manasseh’s head, he was distressed/displeased. So he took his father’s hand to move it from Ephraim’s head to Manasseh’s head. ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Joseph said to him, “My father, that is not right! The one on whom you put your left hand is my older son. Put your right hand on his head.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","But his father refused, saying, “I know that, my son, I know what I am doing. Manasseh’s descendants will also become a people-group, and they will become important. But his younger brother’s descendants will become greater than his will. His descendants will become several nations.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","So he blessed them both on that day, saying, “The people in Israel will use your names when they bless people. They will say, ‘We pray that God will help you as he helped Ephraim and Manasseh.’” In that way, Jacob said that Ephraim would become more important than Manasseh. ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Then Jacob said to Joseph, “I am about to die. But I know that God will help/protect you. And some day he will take your descendants back to the land of their ancestors. ");
INSERT INTO eng_t4t_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","And it is to you, not to your brothers, that I will give the fertile hill in the Shechem area. I captured that land from the Amor people-group, fighting them with my sword and my bow and arrows.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacob summoned all his sons, and said to them, ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Gather around me in order that I can tell you what will happen in the future. My sons, come and listen to me. I am your father, Jacob, whom God named Israel. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Reuben, you are my oldest son. You were born when I was young and energetic/strong. You are prouder and stronger than all the rest of my sons. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","But you were as uncontrollable as a flood SIM. So now you will not be my most important son, because you climbed up onto my bed, and had sex with MTY my ◄concubine/slave who had become one of my wives►. Your doing that caused me, your father, to have great shame. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon and Levi, you have both acted like criminals. You use your swords to act violently. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","I do not want to be with you when you make evil plans DOU. I do not want to join you in your meetings, because you killed people when you became very angry, and you ◄hamstrung/cut the tendons in the legs of► oxen just to ◄have fun/see them suffer►. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","God says, ‘I will ◄curse/cause bad things to happen to► them for being very angry, for acting very cruelly when they were very furious. I will scatter their descendants MTY throughout Israel land.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judah, your older and younger brothers will praise you. They will bow down before you, because you will thoroughly defeat MTY your enemies. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judah is like a young lion SIM that has returned to its den satisfied after eating the animals that it has killed. He is like a lion that lies down and stretches out after eating; no one would dare to disturb it RHQ. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","There will always be a ruler MTY from the descendants of Judah MTY. Each one will hold a scepter/staff to show that he has authority as a king. He will do that until the one to whom the scepter belongs comes, the one to whom the nations will bring tribute and show that they will obey him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","The grapevines of Judah’s descendants will produce grapes very abundantly. As a result, they will not object to tying their young donkeys to the grapevines in order that the donkeys can eat the leaves of the grapevines. Wine will be very plentiful, with the result that they could wash their cloaks in wine that is as red as blood MET. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Their eyes will be red because of drinking too much wine, but their teeth will be very white because of drinking much milk from the cows. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulun, your descendants will live by the seashore where there will be a safe harbor for ships. Their land will extend north as far as Sidon city. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issachar, your descendants will be like strong donkeys that are lying down on the ground between their loads, so tired that they cannot get up! ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","They will see that their resting place is good, and that the land pleases them very much. But they will bend their backs to carry heavy loads and be forced to work for others. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan, although your tribe will be small, their leaders will rule their people just like the leaders of other tribes of Israel will rule their people. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Your descendants will be like snakes at the side of a road, like poisonous snakes lying beside a path. They will strike the heels of horses that pass by, causing the riders to fall backwards as the horses rear up on their hind legs.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Then Jacob prayed, “Yahweh, I am waiting for you to rescue me from my enemies.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Then Jacob continued telling his sons what would happen in the future. He said, “Gad, your tribe/descendants will be attacked by a group of bandits, but your tribe/descendants will pursue and attack them MTY. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asher, your descendants will eat good-tasting food; they will produce food that is delicious enough for kings to eat. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naphtali, your descendants will be like deer MET that are ◄free to/not tied down and can► run wherever they wish. They will give birth to children who are good-looking like ◄fawns/baby deer► MET. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joseph, you will have many descendants MET. Their children will be as many as the fruit on a vine near a spring of water, whose branches extend over a wall. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Their enemies will attack them fiercely, and shoot at them with bows and arrows and pursue them. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","But they will hold their bows steady and their arms will remain strong, because of the power MTY of my mighty God, because of Yahweh who guides and provides for me MET like a shepherd guides and provides for his sheep. The people of Israel will ask Yahweh to protect them, like people hide under a huge overhanging rock to be protected. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","God, the one whom I worship, will help your descendants. God Almighty will bless them by sending them rain from the sky and by giving them water from deep/far below the ground. He will give them many cattle and children MET (OR, and their cattle will have many offspring). ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","The blessings that I want God to give you are great ones. They are greater than the blessings that come from the eternal mountains, greater than the ones that come from the everlasting hills. Joseph, I pray that these blessings will ◄be given to you/come upon your head►, because you are the leader of your older brothers and younger brother. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin, your descendants will be like MET vicious/fierce wolves: In the morning they will kill their enemies like a wolf devours ◄its prey/the animals that it has killed►, and in the evening they will divide among their warriors the spoils that they seized from their enemies.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Those twelve sons are the ancestors of the twelve tribes of Israel. That is what their father said to them as he blessed them, telling to each one words that were appropriate for him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Then Jacob said to his sons, “I will soon die. Bury my body where some of my ancestors are buried, in the cave that is in the field that was bought from Ephron, who belonged to the Heth people-group. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","That field is in the Machpelah area, east of Mamre town, in Canaan. My grandfather Abraham bought it from Ephron to use as a burial place. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","That is where they buried him and his wife Sarah. That is where they buried my father Isaac and his wife Rebekah. And that is where I buried my wife Leah. ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","That field and the cave in it were bought from the Heth people-group; so that is where I want you to bury me.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","When Jacob finished giving those instructions to his sons, he lay down on his bed again. Then he died IDM. ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Joseph leaned close to his father’s face and cried over him and kissed him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Joseph commanded his servants who were morticians to ◄embalm his father’s body/put spices on his father’s body► to ◄preserve it/keep it from decaying►, and then wrap it with strips of cloth. ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","So the morticians did that. It took 40 days to embalm Jacob’s body, because that is the amount of time that was always required for them to embalm a body. And the people of Egypt mourned for 70 days because of Jacob’s death. ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","When the time of mourning was finished, Joseph said to the king’s officials, “If you are pleased with me, please take this message to the king: ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘When my father was about to die, he told me to solemnly promise that I would bury his body in Canaan, in the tomb that he himself had prepared. So please let me go up to Canaan and bury my father’s body. Then I will return.’” ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","After they gave the king the message, he replied, “Tell Joseph, ‘Go up and bury your father’s body, as you ◄swore/solemnly promised► that you would do.’” ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","So Joseph went up to Canaan to bury his father’s body. All of the king’s officials, all the king’s advisors, and all the elders in Egypt went with him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","His own family’s small children and their sheep and goats and their cattle stayed in the Goshen region. But all the rest of Joseph’s family and his older brothers and younger brother and his father’s family went with him. ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Men riding in chariots MTY and on horses also went along. It was a huge group. ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","They went to the east side of the Jordan River and arrived at Atad. There was a place there where people ◄threshed/beat the grain to separate the wheat from the chaff.► There they mourned loudly for Jacob for a long time. Joseph performed mourning ceremonies for his father for seven days. ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","When the Canaan people-group who lived there saw them mourning like that, they said, “This is a sad mourning place for the people of Egypt!” So they named the place Abel-Mizraim, which sounds like the Hebrew words that mean ‘mourning of the Egyptians.’ ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Then Jacob’s sons did for him what their father had commanded. ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","They crossed the Jordan River and carried Jacob’s body to Canaan. They buried it in the cave in the field at Machpelah, east of Mamre town. That was the field that Abraham had bought from Ephron, who was one of the Heth people-group, to use as a burial place. ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","After he had buried his father, Joseph and his older brothers and younger brother and all the others who had gone up to Canaan with him for the funeral returned to Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","After Jacob died, Joseph’s brothers became worried. They realized what might happen. They said, “Suppose Joseph hates us and tries to get revenge for all the evil things that we did to him many years ago?” ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","So they sent someone to tell this to Joseph for them: “Before our father died, he told us this: ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Say to Joseph, “Please forgive your older brothers for the evil thing that they did to you, for their terrible sin against you, because what they did to you was very wrong.”’ So now we, who are servants of your father’s God, ask you, please forgive us for what we did to you.” But Joseph just cried when he received their message. ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Then his older brothers themselves came and threw themselves on the ground in front of Joseph, and one of them said, “Please listen. We will just be your servants.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","But Joseph replied to them, “Do not be afraid! God is the one who punishes people; ◄am I God?/I am not God!► RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","As for you, yes, you wanted to do something very evil to me. But God caused something good to come from it! He wanted to save many people from dying of hunger, and that is what happened! Today they are alive! ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","So I say again, do not be afraid! I will make sure that you and your children have enough to eat.” In that way he reassured them and made made them feel much better. ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Joseph lived with his father’s family in Egypt until he was 110 years old. ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","He lived long enough to see Ephraim’s children and grandchildren. The children of Joseph’s grandson Machir, who was Manasseh’s son, were born before Joseph died, and were adopted by Joseph to be his own children IDM. ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","One day Joseph said to his older brothers, “I am about to die. But God will certainly ◄help/take care of► you. And some day he will lead your descendants up out of this land and take them to Canaan, the land that he solemnly promised to give to Abraham, Isaac, and Jacob.” ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Then Joseph said, “When God enables you to do that, you must take my body back to Canaan.” He made his older brothers solemnly promise to do that. ");
INSERT INTO eng_t4t_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","So Joseph died in Egypt when he was 110 years old. His body was embalmed and put in a coffin there. ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","The sons of Jacob who went to Egypt with him along with their families were ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuben, Simeon, Levi, Judah, ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issachar, Zebulun, Benjamin, ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naphtali, Gad, and Asher. ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Altogether there were 70 people who went with Jacob. That included his sons, his grandsons, and two great-grandsons. His son Joseph was already in Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Eventually Joseph and his older and younger brothers and everyone else in their family who lived ◄in that generation/at that time► died. ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","But Jacob’s descendants kept giving birth to many children IDM. The number of his descendants kept becoming larger and larger. As a result, there were so many of them that they were everywhere in Egypt (OR, that they became a threat to the Egyptians). ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Then several hundred years later, a new king began to rule MTY in Egypt. He did not know what Joseph had done for the people of Egypt long ago. ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","He said to his people, “Look at what has happened! The Israeli people have become so numerous and so powerful that they now might conquer us! ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","We must find a way to control them! If we do not do that, their population will continue to grow. Then, if enemies PRS attack us, they will join with our enemies and fight against us, and they will escape from our land.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","So the king and his officials put supervisors over the Israeli people to cause them to suffer very much by forcing them to work very hard. They forced the Israeli people to build two cities, Pithom and Ramses, in which to store supplies for the king/government. ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","But the more cruelly they treated the Israeli people, the bigger the Israeli population grew, and they became more numerous all over the land. So the Egyptian people began to be afraid of the Israeli people. ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","They forced the Israeli people to work very hard, ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","and by making them slaves, they made their lives miserable. They forced them to build many buildings with mortar and bricks. They also forced them to do other work in the fields. In making them do all this work, the Egyptian officials treated them ruthlessly/cruelly. ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","There were two Hebrew ◄midwives/women who helped the women when they were giving birth►. Hebrew means the same as Israeli. The names of the women were Shiphrah and Puah. The king of Egypt said to those two women, ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“When you help the Hebrew women when they are giving birth MTY, if the baby that is born is a boy, you must kill it. If the baby is a girl, you ◄may let it live/do not have to kill them►.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","But the midwives feared/revered God. So they did not do what the king told them to do. They allowed the baby boys to live. ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","So the king summoned the two midwives and said to them, “Why are you doing this? Why are you letting the baby boys live?” ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","One of the midwives replied to the king, “You need to realize that the Hebrew women are not like the Egyptian women. The Hebrew women are very strong/healthy. They give birth to their babies before we can get to them to help them.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","So God acted kindly toward the midwives, and the Hebrew people became even more numerous and strong. ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Furthermore, because the midwives feared/revered God, he enabled them also to give birth to children. ");
INSERT INTO eng_t4t_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Then the king commanded all ◄the Egyptian people/his advisors►: “You must throw into the Nile River every baby boy born that the Hebrew women give birth to! But you can allow the baby girls to live.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","◄There was a man who/My father► was descended from Jacob’s son Levi. He married a woman who was also descended from Levi. ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","She became pregnant and gave birth to ◄a baby boy/me►. When she saw that he/I was a good-looking baby, she hid him/me for three months, because she was not willing to do what the king commanded. ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","When she was unable to ◄hide him/me/keep it a secret► any longer, she got a basket made from tall reeds. She covered the basket with tar ◄to make it waterproof/so water could not get in►. Then she put him/me in the basket and put the basket in the water in the middle of the tall grass at the edge of the Nile River. ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","His/My older sister was standing not far away, watching to see what would happen to him/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Soon the king’s daughter went down to the river to bathe. Her female servants were walking along the riverbank. She saw the basket amid the tall grass in the river. So she sent one of her servants to get it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","When the servant brought the basket to her, she opened it, and was surprised to see ◄a baby that was/me►, crying. She felt sorry for him/me, and said, “This must be one of the Hebrews’ babies.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Then ◄the baby’s/my► older sister approached the king’s daughter and said, “Do you want me to go and find someone from among the Hebrew women who will be able to nurse the baby for you?” ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","The king’s daughter said to her, “Yes, go and find one.” So the girl went and summoned ◄the baby’s/my► mother. ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","The king’s daughter said to her, “Please take this baby and nurse him for me. I will pay you for doing that.” So ◄the woman/my mother► took him/me and nursed him/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","◄A few years later/when ◄the child/I► grew older►, she brought him/me to the king’s daughter. She adopted him/me as though I was her own son. She named him/me Moses, which sounds like the Hebrew words ‘pull out’, because she said “I pulled him out of the water.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","One day, after Moses/I had grown up, he/I went out of the palace area to see his/my people, the Hebrews. He/I saw how they were being forced to work very hard. He/I also saw an Egyptian man beating one of his/my Hebrew people. ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","He/I looked around to see if anyone was watching. Seeing no one, he/I killed the Egyptian man and buried his body in the sand. ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","The next day he/I returned to the same place. He/I was surprised to see two Hebrew men who were fighting each other. He/I said to the man who started the fight, “Why are you ◄you should not be► striking your fellow Hebrew.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","The man replied, “◄Who made you our ruler and judge?/No one made you our ruler and judge!► RHQ You have no right to interfere with us Are you going to kill me just like you killed that Egyptian man yesterday?” Then Moses/I was afraid, because he/I thought, “Since that man knows what I did, surely other people know, too.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","And that was correct. The king heard about what he/I had done to that Egyptian. So he ordered his soldiers to execute/kill Moses/me. But he/I fled from the king and left Egypt. He/I traveled east to the Midian region and started to live there. ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","The man who was the ◄priest/one who offered the people’s gifts to God► for the Midian people, whose name was Jethro, had seven daughters. One day as Moses/I sat down beside a well, those girls came to the well and got water, and filled the troughs in order to give water to their father’s flock of sheep. ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Some ◄shepherds/men who took care of other sheep► came and started to chase away the girls. But Moses/I helped/rescued the girls, and got water for their sheep. ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","When the girls returned to their father Jethro, whose other name is Reuel, he asked them, “How is it that you were able to give water to the sheep and come home so quickly today?” ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","They replied, “A man from Egypt kept MTY other shepherds from sending us away. He also got water for us from the well and gave water to the flock of sheep.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","He said to his daughters, “Where is he? ◄Why did you leave him out there?/You should not leave him out there!► RHQ Invite him in, so he can have something to eat MTY!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","So they did, and Moses/I accepted and ate with them. And Moses/I decided to live there. Later Jethro gave him/me his daughter Zipporah to be his/my wife. ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Later she gave birth to a son, and Moses/I named him Gershom, which sounds like the Hebrew words that mean ‘foreigner’, because he/I said, “I am living as a foreigner in this land.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Many years later the king of Egypt died. The Israeli people in Egypt were still groaning because of the hard work they had to do as slaves. They called out for someone to help them, and God heard them call out PRS. ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","He heard them groaning. And he ◄thought about/did not forget► that he had solemnly promised to Abraham, Isaac, and Jacob to bless their descendants. ");
INSERT INTO eng_t4t_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","God saw how the Israeli people were being badly treated, and he was concerned about them. ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moses/I was taking care of the sheep that belonged to his/my father-in-law Jethro, the priest of the Midian people. He/I led the flock across the desert and came to Horeb, the mountain that was later called Sinai, the ◄mountain that had been dedicated to God/taboo mountain►. ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","One day Yahweh ◄appeared/revealed himself► to him/me, looking like an angel. The angel appeared in a flame of fire in the middle of a bush that was burning. Moses/I looked at it, and he/I was surprised that the bush was burning, but it was not burning up. ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Moses/I thought, “I will go closer and try to see this strange sight! Why is the bush not burning up?” ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","When Yahweh saw that he/I had come closer, he called to Moses/me from the middle of the bush, saying, “Moses! Moses!” He/I replied, “Yes, here I am.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Yahweh said, “Do not come closer! Because I am God, the ground on which you are standing is holy/taboo. So take off your sandals to show respect to me.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Then he said, “I am God, whom your ancestors Abraham, Isaac, and Jacob worshiped.” So Moses/I covered his/my face, because he/I was afraid that God would kill him/me if he/I looked at him. ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Then Yahweh said, “I have seen how cruelly they are treating my people in Egypt. I have heard them ◄wailing/crying out► for help because of what the slave-drivers are forcing them to do. I know how my people are suffering. ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","So I have come down from heaven to rescue them from the Egyptians SYN. I have come to bring them up from that land to the highlands in Canaan. I will bring them to a land that is good/fertile and that has plenty of space. It will be very good for raising livestock and growing crops MTY. It is the land where the descendants of Canaan, Heth, Amor, Periz, Hiv, and Jebus live. ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Truly I have now heard my Israeli people crying PRS. I have seen how the Egyptians oppress them. ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","So you go back to Egypt. I am sending you to the king, in order that he may permit you to bring my people, the Israeli people, out of Egypt.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","But Moses/I replied, “I am not a well-known person RHQ! ◄I cannot go to the king and ask him to permit me to bring the Israeli people out of Egypt!/How can I go to the king and ask him to allow me to bring the Israeli people out of Egypt?►” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","God replied, “I will be with you. And when you bring my people out of Egypt, all of you will worship me right here on this mountain. That will prove that I am the one who sent you to them.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moses/I said to God, “If I go to the Israeli people and say to them, ‘God, the one your ancestors worshiped, has sent me to you,’ and they ask me, ‘What is his name?’, what shall I say to them?” ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","God replied, “I AM who I AM.” And he said, “Tell the Israeli people that the one who is named ‘I AM’ has sent me to you.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","God also said to Moses/me, “Say this to the Israeli people: ‘Yahweh God, the one your ancestors worshiped, the one that Abraham and Isaac and Jacob worshiped, has sent me to you.’ This name, Yahweh, will be my name forever. That is the name that people in all future generations must use when they talk about/to me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Go to Egypt and gather together the elders/leaders of the Israeli people, and say to them, ‘Yahweh God, the one your ancestors worshiped, the one Abraham, Isaac, and Jacob worshiped, appeared to me. He said to him/me, “I have been watching closely what the Egyptian people have done to you. ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","I promise that I will rescue you from being oppressed in Egypt, and I will take you to the land where the descendants of Canaan, Heth, Amor, Periz, Hiv, and Jebus live. It is a land good for raising livestock and growing crops MTY.”’ ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","My people will do what you say. Then you and their leaders must go to the king of Egypt, and you must say to him, ‘Yahweh, who is God, the one we Hebrews worship, has revealed himself to us. So now we ask you to allow us to travel for three days to a place in the desert, in order that there we may offer sacrifices to Yahweh, our God.’ ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","But I know that the king of Egypt will allow you to go only if he realizes I am more powerful MTY than he is. ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","So I will use my power MTY to strike/punish the people of Egypt MTY by performing many miracles there. Then he will allow you to leave. ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","When that happens, I will cause the people of Egypt to respect you. The result will be that when you leave Egypt, ◄you will not go empty-handed/they will give you many valuable things to take with you►. ");
INSERT INTO eng_t4t_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","At that time, each Israeli woman will ask her Egyptian neighbors and each Egyptian woman who is living in her (OR, her neighbor’s) house to give her some silver and gold jewelry and some nice clothes. Each Egyptian woman will give them some, and you will put them on your sons and daughters to take with you. In that way you will ◄take away/confiscate► the wealth of the Egyptian people.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moses/I replied, “But what if the Israeli people ◄do not believe me/are not convinced► or not do what I tell them? What if they say, ‘Yahweh did not appear to you!’” ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Yahweh said to him/me, “Look at that thing you are holding in your hand. What is it?” He/I replied, “A ◄walking stick/shepherd’s stick►.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","He said, “Throw it down on the ground!” So, he/I threw it on the ground, and it became a snake! And he/I ran/jumped away from it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","But Yahweh said to Moses/me, “Reach down and pick it up by its tail!” So he/I reached down and caught it, and when he/I picked it up, it became a stick in his/my hand again. ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Yahweh said, “Do the same thing in front of the Israeli people, in order that they may believe that I, Yahweh God, the one Abraham and Isaac and Jacob worshiped, truly appeared to you.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Yahweh spoke to Moses/me again, saying “Put your hand inside your robe MTY!” He/I did that. And when he/I took it out again, surprisingly, his/my hand was white. It had a skin disease that made it as white as snow. ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Then God said, “Put your hand back inside your robe MTY!” So he/I did that, and when he/I took it out again, surprisingly, it was normal again, just like the rest of his/my body! ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","God said, “You can do that in front of the Israeli people, too. If they do not pay attention to what you say because of seeing the first miracle, they will ◄believe you/be convinced► when you perform the second miracle. ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","If they do not believe you or do what you say, even after you perform those two miracles, get some water from the Nile River and pour it on the ground. When you do that, the water from the river that you pour on the ground will become blood MTY (OR, red like blood).” ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moses/I replied, “O Yahweh! I am not an eloquent speaker! I was not an eloquent speaker before, and I have not become one since you started talking to me! I am not a good speaker MTY, and I speak very slowly.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Then Yahweh said to him/me, “You seem to forget who it is that makes people able to speak RHQ! Who is it that enables people to be unable to speak or unable to hear, or able to see or not to see? It is I, Yahweh RHQ! ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","So start going to Egypt, and I will help you to speak MTY, and I will tell you what you should say.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","But he/I replied, “O, Yahweh, I ask you, please send someone else instead!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Then Yahweh became very angry with Moses/me. He said, “What about your older brother Aaron, who is also a descendant of Levi? I know that he is a very good/eloquent speaker. He is actually on his way here right now, and he will be very happy to see you. ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","You can talk to him and tell him what to say MTY, and I will help both of you SYN to know what to say MTY. And I will tell you both what you should do. ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","He will speak for you to the Israeli people. He will be ◄your spokesman/as though he was your mouth► MET, and you will be to him as though you are his god. ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Be sure to take with you the walking/shepherd’s stick that is in your hand, because you will perform miracles with it.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Moses/I returned to his/my father-in-law Jethro and said to him, “Please let me go back to Egypt, to see my fellow Israelis there. I want to know if they are still alive.” Jethro said to Moses/me, “Go, and may God give you inner peace.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Yahweh said to Moses/me before he/I left Midian, “You can safely return to Egypt, because the men who were wanting to kill you MTY are now dead.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","So Moses/I took his/my wife and sons and put them on donkeys, and they/we returned to Egypt. And Moses/I took in his/my hand the stick that God told him/me to take along. ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Yahweh said to Moses/me, “When you return to Egypt, be sure to perform all the miracles that I have given you power to do, while the king is watching. But I will make him stubborn IDM, with the result that he will not let the Israeli people leave Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Then say to him, ‘This is what Yahweh says: “The Israeli people MTY are as dear to me as firstborn sons MET. ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","I told you to let my people MTY leave Egypt, in order that they may worship me in the desert. If you refuse to let them go, I warn you, I will kill your firstborn son!”’” ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","One night, as they were camping on the way to Egypt, Yahweh appeared to Moses/me. He wanted/threatened to kill Moses/me for disobeying his command that boys/sons be circumcised. ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Then his/my wife Zipporah took a flint knife and circumcised her son. Then she touched the boy’s feet (OR, genitals) with the piece of skin she had cut off, and she said, “The blood which flowed when I circumcised you will protect you from being harmed by Yahweh MET.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","She said to him, “You are safe now MET because you have been circumcised.” So Yahweh did not harm her son. ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Yahweh said to Aaron, “Go into the desert to meet/see Moses!” So he went there from Egypt and met him/me at Sinai, the mountain dedicated to God, and greeted him/me by kissing him/me on the cheek. ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moses/I told Aaron everything that Yahweh had said to him/me when he told him/me to return to Egypt. He/I also told Aaron about all the miracles that Yahweh told him/me to perform. ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","So Aaron and Moses/I returned to Egypt. There they/we gathered together all the Israeli elders/leaders. ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaron told them everything that Yahweh had told Moses/me, and Aaron performed all the miracles as the people watched. ");
INSERT INTO eng_t4t_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","They believed that what they/we were saying was true. When they heard that Yahweh had seen how the Israeli people were being cruelly oppressed and that he was going to help them, they bowed down and worshiped Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Then Aaron and Moses/I went to the king and one of them/us said, “Yahweh God, whom we Israeli people worship, says this to you: ‘Let my people go to the desert, in order that they may have a feast to honor me!’” ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","But the king said, “Who is Yahweh? Why should I pay attention to what he says and let the Israeli people MTY go? I do not know Yahweh! And furthermore, I will not let the Israeli people go!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","They/we replied, “Yahweh God, the one we Hebrews worship, has ◄revealed himself/appeared► to us and told us what to tell you. So we ask you to please let us go on a three day journey into the desert. We must offer sacrifices to Yahweh God there. If we do not do that, he will cause us to die IDM from diseases or from attacks by our enemies MTY.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","But the king of Egypt said to them/us, “Moses and Aaron, ◄stop trying to keep the Israeli people from working/why are you preventing the Israeli people from working?► RHQ Tell those slaves to return to work!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","The king also said, “Listen to me! You  people who now live in this land are now more numerous, and you want them to stop working and rest!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","That same day the king commanded the Egyptian slave bosses and the Israeli men supervising the slaves, ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Do not continue to give the Israeli people straw for making bricks, as you have done previously. Make them go into the fields and gather straw for themselves. ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","But require them to make the same number of bricks that they did before. Do not decrease the number at all. They ◄are lazy/do not have enough work to do►. That is the reason they are asking me to let them go into the desert to offer sacrifices to their god. ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Force the men to work harder, so that they will not have time to listen to lies from their leaders!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","So the slave bosses and supervisors of the slaves went to where the Israeli people were and said to them, “The king has said that he will no longer give you any straw. ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","So you yourselves must go and get straw wherever you can find it. But you must still keep working to make the same number of bricks as before.” LIT ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","So the Israeli people went all over Egypt to find straw. ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","The slave bosses kept telling them insistently, “Finish the work you are required to do each day, making the same amount of bricks as you did before, when we gave you straw!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","When they were not able to do that, the slave bosses had the Israeli supervisors beaten with sticks, and they asked them, “Why have all the men you are supervising not been able to make the same number of bricks today/now as they did before RHQ?” ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Then the Israeli supervisors went to the king and complained, saying “Your Majesty, why are you treating us this way? ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Now they are not giving us any straw for making bricks, but they keep commanding us to make bricks. And now sometimes they beat us. But it is the fault of your own slave bosses that we cannot make as many bricks as before!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","But the king said, “You are lazy and do not want to work! That is why you keep saying, ‘Allow us to go to the desert and offer sacrifices to Yahweh.’ ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","So go and get back to work! We are not going to give you any straw, but you must keep making the same number of bricks!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","The Israeli supervisors realized that they were in a difficult situation, because they had been told, “We are not going to decrease the number of bricks you must make each day.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","As they left the king’s palace, they met Aaron and Moses/me, who were waiting for them there. ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","They said to Aaron and Moses/me, “Yahweh has seen what you two have done He will punish you MTY, because you have caused the king and his officials to despise us! You have given them an excuse MTY to kill us!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Moses/I left them and prayed to Yahweh again, saying, “O Yahweh, why have you caused all these evil things to happen to your people RHQ? And why did you send me here RHQ? ");
INSERT INTO eng_t4t_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ever since I went to the king and told him what you told me to say MTY, he has treated your people very cruelly, and you have not done anything to help/rescue them!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Then Yahweh said to Moses/me, “Now you will see what I will do to the king and his people. I will powerfully MTY compel him to let my people go. In fact, by my power MTY I will force him to expel them from his land!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","God also said to Moses/me, “I am Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","I am the one who appeared to Abraham, Isaac, and Jacob, and told them that I was God Almighty, but I did not tell them that my name was Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","I also made my solemn agreement with them, promising to give them the Canaan region. That was the area in which they were living as foreigners. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Furthermore, I have heard the Israeli people as they were groaning because of the hard work that the Egyptians forced them to do as their slaves. I have thought about that solemn promise that I made. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","So tell the Israeli people that I said this: ‘I am Yahweh. I will free you from the burdens of heavy work that the Egyptians have given you. I will free you from being their slaves. With my great power MTY and by punishing them MTY very severely, I will save you. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","I will cause you to be my own people, and I will be your God, the one you worship. You will truly know that I, Yahweh your God, am the one who has freed you from the burdens of work as slaves of the Egyptians. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","And I will bring you to the land that I solemnly promised to give to Abraham, to Isaac, and to Jacob. You will possess it forever. I, Yahweh, am promising this.’” ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moses/I told that to the Israeli people, but they did not believe what he/I said. They were very discouraged IDM because of the hard work that they had been forced to do as slaves. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Go and tell the king of Egypt again that he must allow the Israeli people to leave his land!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","But Moses/I said to Yahweh, “Listen to what I am saying. Even the Israeli people have not paid attention to what I told them. But I am a poor speaker. MET, MTY So ◄why should the king pay attention to what I tell him?/the king will certainly not pay attention to what I tell him!►” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","But Yahweh spoke to Aaron and Moses/me and commanded them/us, “Tell the Israeli people and the king of Egypt that I have commissioned you two to lead the Israeli people out of Egypt.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","◄Here is/I will now give you► a list of the ancestors of Moses/me and Aaron: The sons of Reuben, who was Jacob’s oldest son, were Hanoch, Pallu, Hezron, and Carmi. They were ancestors of the clans that have those same names. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","The sons of Simeon were Jemuel, Jamin, Ohad, Jachin, Zohar, and Shaul. Shaul’s mother was a woman from the Canaan people-group. Those men also were ancestors of clans that have those same names. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","These are the names of the sons of Levi, in the order in which they were born: Gershon, Kohath, and Merari. Levi was 137 years old when he died. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","The sons of Gershon were Libni and Shimei. They were ancestors of clans that have those names. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","The sons of Kohath were Amram, Izhar, Hebron, and Uzziel. Kohath was 133 years old when he died. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","The sons of Merari were Mahli and Mushi. All of those people whose names I have listed belonged to tribes/clans descended from Levi, in the order in which they were born. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram married his father’s sister, Jochebed. She was the mother of Aaron and Moses/me. Amram was 137 years old when he died. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","The sons of Izhar were Korah, Nepheg, and Zichri. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","The sons of Uzziel were Mishael, Elzaphan, and Sithri. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron married Elisheba. She was the daughter of Amminadab and sister of Nahshon. Elisheba gave birth to four sons: Nadab, Abihu, Eleazar, and Ithamar. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","The sons of Korah were Assir, Elkanah, and Abiasaph. They were the ancestors of the Korah people-group. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aaron’s son Eleazar married one of the daughters of Putiel, and she gave birth to Phinehas. That ends the list of the families and clans that were descended from Levi. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aaron and Moses/I were the ones to whom Yahweh said, “Lead all the families and clans of the Israeli people out of Egypt.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","They/We were the ones who spoke to the king of Egypt about bringing the Israeli people out of Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","On the day that Yahweh spoke to Moses/me in Egypt, ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","he said, “I am Yahweh. You must tell the king everything that I say to you.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","But Moses/I said to Yahweh, “Listen to me. I am not a good speaker. MET, MTY So ◄the king will certainly not pay attention to what I say/why should the king pay attention to what I tell him?►!” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Then Yahweh said to Moses/me, “Listen carefully. Just like I enabled prophet to speak my messages, I will cause the king to consider that you are like a god, and that Aaron is like a prophet. ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","You must tell everything I command you to tell to your older brother Aaron, and he will tell that to the king. He must tell the king to let the Israeli people leave his land. ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","But I will make the king stubborn IDM. As a result, even though I perform many kinds of ◄miracles/terrifying things► DOU here in Egypt, ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","the king will not pay any attention to what you say. Then I will punish MTY the people of Egypt MTY very severely MTY, and I will lead/bring the tribes of the Israeli people out of Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Then, when I show my great power MTY to the Egyptian people and bring the Israeli people out from among them, they will know that I, Yahweh, have the power to do what I say that I will do.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Aaron and Moses/I did what Yahweh told them/us to do. They/We went and spoke to the king. ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","At that time, Moses/I was 80 years old, and Aaron was 83 years old. ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“If the king says to you, ‘Prove that God sent you by performing a miracle,’ then say to Aaron, ‘Throw your stick down in front of the king, in order that it may become a snake.’” ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","So Aaron and Moses/I went to the king and did what Yahweh had commanded them/us to do. Aaron threw his stick down in front of the king and his officials, and it became a snake. ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Then the king summoned his sorcerers and men who performed magic. They did the same thing, using their magic. ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","They all threw down their sticks, and they became snakes. But Aaron’s stick, which had become a snake, swallowed up all their sticks! ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","But the king continued to be stubborn IDM, just as Yahweh had predicted, and he would not pay attention to what Aaron and Moses/I said. ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Then Yahweh said to Moses/me, “The king is very stubborn IDM. He refuses to allow my people to go. ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","So tomorrow morning, go to him as he is going down to the Nile River to bathe. Wait for him at the riverbank. When he comes out of the water, show him the stick, the one which became a snake. ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Say to him, ‘Yahweh God, the one we Hebrews worship, sent me to you to tell you to let my people go, in order that they may worship him in the desert. We told you that, but you have not paid any attention to it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","So now Yahweh says this: “This is the way you will know that I, Yahweh, have the power to do what I say that I will do. Watch this: I am going to strike the water that is in the Nile River with the stick that is in my hand. When I do that, the water will become blood (OR, red like blood MTY). ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Then the fish in the Nile River will die, and the water in the river will stink, and the Egyptians will not be able to drink water from the Nile River.”’” ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Yahweh said to Moses/me, “When you are talking to the king, say to Aaron, ‘Hold your stick out as though you were holding it over the water in Egypt—over the rivers, the canals, the ponds, and over the pools of water, in order that all of it may become red like blood.’ When Aaron does that, there will be blood throughout Egypt, even in wooden jars and in stone jars.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","So Aaron and Moses/I did what Yahweh commanded. As the king and his officials were watching, Aaron lifted up his stick and then struck the water in the Nile River with it. And all the water in the river turned red like blood. ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Then all the fish died. And the water stank, with the result that the Egyptians could not drink water from the river. Everywhere in Egypt the water became red like blood. ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","But the men who performed magic did the same thing using their magic. So the king remained stubborn IDM, and he would not pay attention to what Aaron and Moses/I said, just as Yahweh had predicted. ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","The king turned and went back to his palace, and he did not think any more about it IDM. ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","The Egyptians HYP dug into the ground near the Nile River to get water to drink, because they could not drink the water from the river. ");
INSERT INTO eng_t4t_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","◄One week/Seven days► passed after Yahweh caused the water in the Nile River to become red like blood. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Then Yahweh said to Moses/me, “Go back to the king and tell him, ‘Yahweh says that you must let my people go, in order that they can worship me in the desert. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","But if you refuse to let them go, I will punish you by sending frogs to cover your country. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Not only will the Nile River be full of frogs, but the frogs will come up out of the river into your palace. They will come into your bedroom and onto your bed. They will be in the houses of your officials and all the rest of your people. They will even get into your ovens and your pans for mixing the materials for baking bread. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","The frogs will jump up on you and your officials and all the rest of your people.’” ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Yahweh also said to Moses/me, “Say this to Aaron: ‘Hold your stick in your hand and stretch it out as though you were stretching it over the river, the canals, and over the pools, and cause frogs to come up from all this water and cover the land of Egypt.’” ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","After Moses/I told that to Aaron, he stretched out his hand as though he were stretching it over all the water in Egypt. And the frogs came up from the water and covered Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","But the men who performed magic did the same thing, and they caused more frogs to come up from the water onto the land. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Then the king summoned Moses/me and said, “Ask Yahweh to take away these frogs from me and my people. After that happens, I will allow your people to go, in order that they can offer sacrifices to Yahweh.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moses/I said to the king, “I will be glad to pray for you and for your officials and for the rest of your people. I will ask Yahweh to get rid of the frogs from all your houses. The only frogs left will be those in the Nile River. Just tell me when I should pray.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","He replied, “Tomorrow.” So Moses/I said, “I will do what you say, and then you will know that Yahweh God, the one we worship, is the only true god, and that there is no other god like him. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","The frogs will leave you and your officials and all the rest of your people. The only ones left will be in the Nile River.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Aaron and Moses/I left the king. Then Moses/I prayed to Yahweh, asking him to take away all the frogs he had brought to the king’s land. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","And Yahweh did just what Moses/I asked him to do. As a result, all the frogs in the houses, in their courtyards, and in the fields died. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","The people gathered together all the dead frogs into big piles, and the land stank from the smell. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","But when the king saw that the problem was ended, he became stubborn IDM again. And just as Yahweh had predicted, he would not pay attention to what Aaron and Moses/we told him. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Then Yahweh said to Moses/me, “Tell Aaron to strike the ground with his stick. When he does that, all the fine particles of ground/dust will become gnats, all over the land of Egypt.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","So they/we did that. Aaron struck the ground with his stick, and all over Egypt, the fine particles of ground/dirt became gnats. The gnats covered the people and all their animals. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","The men who worked magic tried to cause gnats to appear, but they were unable to do it. So the gnats stayed on the Egyptian people and on their animals. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","The men who worked magic said to the king, “It is God who has done this with his power MTY!” But the king continued to be stubborn IDM, and he would not pay attention to us, just as Yahweh had predicted. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Then Yahweh said to Moses/me, “Get up early tomorrow morning. Go down to the river and wait for the king. When he comes to bathe MTY, say to him, ‘This is what Yahweh says to you: “Let my people go, in order that they may worship me in the desert. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","I warn you that if you do not let my people go, I will send swarms of flies to you. They will come down on you and on your officials and on the rest of your people. The houses of all you Egyptians will be full of flies. They will even cover the ground. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","But when that happens, I will treat the Goshen region, where my people live, differently. There will be no swarms of flies there. In that way, you will know that I, Yahweh, am doing these things here in this land. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","I will distinguish clearly between how I act toward my people and how I act toward your people. And this plague is going to happen tomorrow!”’” ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Early the next morning, Moses/I told that to the king, but the king would not pay any attention. So Yahweh did what he said he would do. He sent great swarms of flies into the palace of the king and into the houses of his officials. The whole country of Egypt was ruined by the flies. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Then the king summoned Aaron and Moses/me and said, “You Israeli people can go and offer sacrifices to your god, but you must do it here in this land.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","But Moses/I replied, “It would not be right for us to do that, because we will be offering sacrifices that are very offensive to the Egyptian people. If we offer sacrifices that the Egyptian people think are disgusting, they will kill us by throwing stones at us RHQ! ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","No, we need to travel for three days into the desert. There we will offer sacrifices to Yahweh, the God we worship, just as he commands (OR, has commanded) us.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","So the king said, “I will let your people go to offer sacrifices to Yahweh, your god, in the desert. But you must not go very far. Now pray for me!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moses/I said, “Listen to me! After I leave you, I will pray to Yahweh, asking that tomorrow he will cause the swarms of flies to leave you and your officials and the rest of your people. But do not deceive us again by refusing to let our people go to offer sacrifices to Yahweh!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Then Moses/I left the king and prayed to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","And Yahweh did what Moses/I asked, and he got rid of the swarms of flies from around the king and his officials and the rest of his people. No flies remained. ");
INSERT INTO eng_t4t_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","But the king was stubborn IDM this time also, and he did not allow the Israeli people to go. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Then Yahweh said to Moses/me, “Go to the king and say to him, ‘This is what Yahweh, the God we Hebrews worship, says: “Allow my people to go, in order that they may worship me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","If you still keep refusing to let them go DOU, ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","I warn you that I will punish you with my power MTY by sending a terrible disease on all your animals—on your horses, donkeys, camels, on your cattle, and on your flocks of sheep and goats. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","But I, Yahweh, will distinguish between what I do to the animals that belong to the Israeli people and what I do to your animals. The result will be that no animal that belongs to the Israeli people will die.”’ ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Tell him that I have determined/decided that tomorrow is the day that I will do this in this land.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","The next day Yahweh did just what he said that he would do. A terrible disease afflicted all of the Egyptians’ animals, and many of them HYP died. But none of the Israeli people’s animals died. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","The king sent men to investigate, and they were surprised to see that none of the Israeli people’s animals had died. But after they reported that to the king, he continued to be stubborn IDM, and he did not let the Israeli people go. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Then Yahweh said to Aaron and Moses/me, “Take a few handfuls of ashes/soot from ◄a furnace/an oven where they burn lime►, and let Moses throw them up into the air, in front of the king. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","The ashes/soot will spread all over the country of Egypt like fine dust. And the ashes/soot will cause boils to afflict both the Egyptian people and their animals, all over the land.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","So they/we both got some ashes/soot and went and stood in front of the king. Moses/I threw the ashes/soot up into the air. The ashes/soot spread all over, causing boils to afflict the Egyptian people and their animals. All the boils became open sores. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Even the men who worked magic had boils. The result was that they were suffering so much that they were not able to come to Moses/me, because the men who worked magic had boils just like all the rest of the Egyptian people. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","But Yahweh caused the king to continue to be stubborn IDM. He did not pay any attention to what they/we said, just as Yahweh had told Moses/me would happen. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Then Yahweh said to Moses/me, “Get up early tomorrow morning. Go and stand in front of the king and tell him that Yahweh God, the one that the Hebrew people worship, says this: ‘Let my people go, in order that they may worship me in the desert. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","If you do not let them go, this time I will punish with plagues not only your officials and the rest of your people, but I will punish you yourself SYN, in order that you will know there is no god like me anywhere in the world. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","By this time I could have used my power MTY to strike you and your people with terrible diseases that would have wiped you all from the earth. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","But I have let you live. The reason I have let you live is to show you my power, with the result that people all over the earth HYP will know how great I MTY am. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","You are still acting proudly and refusing to let my people go. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","So listen to this: About this time tomorrow I will cause very heavy hail to fall in Egypt. From the time Egypt first became a country, there has never been a hailstorm as bad as this one will be. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","So you should send a message to everyone to put their cattle, and everything else that they own that is out in the fields, under shelters. The hail will fall on every person and every animal that is out in the fields and that is not put under a shelter, and they will all die.’” So Moses/I did what Yahweh said. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Some of the king’s officials who heard what Yahweh had said became very afraid. So they put all their animals and their slaves under shelters. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","But those who did not pay any attention to what Yahweh had said left their slaves and their animals in the fields. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Then Yahweh said to Moses/me, “Raise your hand up toward the sky, in order that hail will fall all over the land of Egypt—on the people and on their animals and on all the plants in the fields.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","So Moses/I lifted his/my stick up toward the sky. And Yahweh sent down hail, all over the land of Egypt. There was also thunder and lightning. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","While very heavy hail was falling, there was thunder, and lightning struck the ground. There had never been a hailstorm like that since Egypt first became a country. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","The hail struck everything that was in the fields all over Egypt—every person and every animal. The hail destroyed the plants in the fields and stripped the leaves off the trees. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Only in the Goshen region, where the Israeli people were living, was there no hail. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Then the king sent someone to summon Aaron and Moses/me. When they/we came to the king, he said to them/us, “This time I admit that I have sinned. What Yahweh has done is right, and what I and my people have done is wrong. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","◄Pray to/Plead with► Yahweh to cause it to stop! We cannot endure any more of this thunder and hail! I will let your people go; they do not have to stay here in Egypt any longer.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moses/I replied, “As soon as I go out of this city, I will lift up my hands and pray to Yahweh. Then the thunder will cease, and no more hail will fall. This will happen in order that you will know that Yahweh, not your gods, controls everything that happens on the earth. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","But as for you and your officials, I know that you do not yet fear Yahweh God.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","When the hail fell, the flax was ruined because the buds were forming, and the barley was ruined because its grain was ripe. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","But none of the wheat crops was ruined, because their shoots were still very small. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","So Moses/I left the king and went outside the city. He/I lifted up his/my hands toward Yahweh and prayed. Then the thunder and the hail stopped, and the rain also stopped falling on the land of Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","But when the king saw that the rain and the hail and the thunder had stopped, he sinned again. He and his officials continued to be stubborn IDM. ");
INSERT INTO eng_t4t_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","So, just as Yahweh had predicted by what he told Moses/me, the king did not allow the Israeli people to leave. ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Then Yahweh said to Moses/me, “Go to the king again. I have made him and his officials stubborn IDM. I have done that in order that I would have a good reason to perform all these plagues among them, ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","and also in order that you would be able to tell your children and your grandchildren how I caused the Egyptians to act very foolishly when I performed all these miracles. Then all of you will know that I, Yahweh, have the power to do what I say that I will do.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","So Aaron and Moses/I went into the king’s palace and said to him, “Yahweh God, whom we Hebrews worship, says this: ‘How long will you stubbornly refuse to do what I tell you MTY? Let my people go, in order that they may worship me in the desert ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","If you keep refusing to let them go, I warn you that tomorrow I will bring ◄locusts/large flying insects called locusts► into your country. ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","They will completely cover the ground so that you will not even be able to see the ground. They will eat everything that the hail did not destroy. They will eat everything that is left on the trees. ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","They will fill your houses, and the houses of all your officials, and the houses of all the rest of the Egyptians. There will be more locusts than you or your parents or your grandparents have ever seen, from the time your ancestors first came to this land until the present time!’” Then he/I turned and Aaron and I left the king. ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","The king’s officials said to him, “◄How long is this man going to continue to bring disasters on us?/We must not let this man continue to cause trouble for us!► RHQ Let the Israeli men leave, in order that they may worship Yahweh, their god. ◄Do you not yet understand that this man has ruined Egypt?/You ought to realize by now that this man has ruined Egypt!►” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","So they brought Aaron and Moses/me back to the king. He said to them/us, “All right, you can go and worship Yahweh your god. But who are the ones who will go?” ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moses/I replied, “We all need to go, everyone, including those who are young and those who are old. We need to take our sons and our daughters and our flocks of sheep and goats and herds of livestock, because we must have a festival to honor Yahweh.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Moses/I really did not intend that the Israelis would ever return to Egypt, and the king knew that also. So the king replied sarcastically, “If you all leave, it will be clear that Yahweh has helped you, but I myself will never let you take your children and your wives when you go! It is clear that you are wickedly planning not to return. ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","So no, I will not let you all go. The Israeli men may go and worship Yahweh, if that is what you want.” Then the king expelled them/us from his palace. ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Then Yahweh said to Moses/me, “Reach out your hand as though you were stretching it over the land to welcome the locusts. They will come to the country of Egypt and eat every plant that is left in the land, every plant that the hail has not destroyed.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","So Moses/I held out his/my stick as though he/I was stretching it over the whole land of Egypt. Then Yahweh caused a strong wind to blow from the east, and it blew over the land all that day and all that night. By the next morning, it had brought the locusts. ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","The locusts swarmed all over Egypt. It was larger than any swarm of locusts that had ever been seen, and there will never be a swarm of locusts like that again. ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","They covered the surface of the ground and made it appear black. They ate all the plants in the land and everything on the trees that had not been destroyed by the hail. Nothing that was green was left on any plant or on any tree, anywhere in Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","The king quickly summoned Aaron and Moses/me and said, “I have sinned against Yahweh, your god, and against you two. ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","So now I ask you to forgive me this one time for having sinned, and pray to Yahweh your god to stop these locusts MTY from causing everything to die.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","They/We left the king, and Moses/I prayed to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Then Yahweh changed the wind so that it blew strongly from the west, and it blew all the locusts into the Red Sea (OR, the Gulf of Suez). There was not one locust left anywhere in the country of Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","But Yahweh made the king stubborn IDM again, and he did not let the Israeli people go. ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Yahweh said to Moses/me, “Reach your hand up toward the sky, in order that there will be darkness over all the land of Egypt, a darkness so complete that people will have to grope around to know where to walk.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","So Moses/I reached his/my hand toward the sky, and it became totally dark all over Egypt for three days and nights. ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","People could not see each other. No one left his house during that whole time. But there was light in the area where the Israeli people were living. ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","The king summoned Moses/me and said, “All right, you may go and worship Yahweh. Your wives and your children may go with you. But your flocks of sheep and goats and your herds of cattle must remain here.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","But Moses/I replied, “No, you must let us take along the sheep and goats, in order that we may have some of them to sacrifice and give as burned offerings to Yahweh, our God. ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Our livestock must also go with us; we are not going to leave one of them SYN behind. We must take them to worship Yahweh. We will not know which animals to sacrifice until we get to where we are going.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","But Yahweh made the king continue to be stubborn IDM, and he would not let the Israeli people go. ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","The king said to me, “Get out of here! Make sure that you never come to see me SYN again! The day you see me again, I will have you executed!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moses/I replied, “You are correct! You will never see me SYN again!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Then Yahweh said to Moses/me, “I will cause one more disaster to strike the king of Egypt and all his people MTY. After that, he will let you leave. In fact, he will expel you all. ");
INSERT INTO eng_t4t_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","So now speak to all the Israeli people. Tell them to ask all their Egyptian neighbors, both men and women, to give them some silver and gold jewelry.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Yahweh made the Egyptians highly respect the Israeli people. In particular, the Egyptian officials and all the rest of the people considered Moses/me to be a very great man. ");
INSERT INTO eng_t4t_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Then Moses/I went to the king and said, “This is what Yahweh says: ‘About midnight tonight I will go throughout Egypt, ");
INSERT INTO eng_t4t_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","and I will cause all the firstborn/oldest sons to die. That will include your oldest son, the oldest sons of the slave women who grind grain, and the oldest sons of everyone else. I will also kill the oldest males of the Egyptians’ livestock. ");
INSERT INTO eng_t4t_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","When that happens, people all over Egypt will wail loudly. They have never wailed like that before, and they will never wail like that again. ");
INSERT INTO eng_t4t_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","But among the Israeli people it will be so quiet that not even a dog will bark! Then you will know for sure that I, Yahweh, distinguish how I act toward the Egyptians and how I act toward the Israeli people. ");
INSERT INTO eng_t4t_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Then all these officials of yours will come and bow down before me and will say, “Please get out of Egypt, you and all the Israeli people!”’ After that, I will leave Egypt!” After Moses/I said that, he/I very angrily left the king. ");
INSERT INTO eng_t4t_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Then Yahweh said to Moses/me, “The king will not pay any attention to what you say. The result will be that I will perform more plagues in the land of Egypt.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Aaron and Moses/I performed all these miracles in front of the king, but Yahweh made the king stubborn, and he did not let the Israeli people leave his country. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Yahweh said to Aaron and Moses/me there in Egypt, ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“From now on, this month will be the first month of the year for you. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Tell all the Israeli people that in each family, the man who heads the family must select a lamb or a young goat for his household. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","If there are not enough people in his family to eat a whole cooked lamb, then his family and the family that lives next door may share one animal. Decide how many lambs you need according to the number of people in each family, and according to how much each person can eat. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","The lambs or goats that you choose must be males, one-year-old, and they must not have any defects. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","You must take special care of these animals until the 14th day of the month. On that day, all the Israeli people must slaughter the lambs or goats in the evening. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Then they must take some of the blood from the lambs or goats, and they must smear it on the doorposts and the ◄lintels/horizontal beams above the doorways► of the houses in which they will eat the meat. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","They must roast the animals immediately and eat the meat that night. They must eat it with bread that is baked without yeast and with bitter herbs. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","You must not eat any of the meat raw, and you must not boil the meat. You must roast it whole, without cutting off the head or the legs or removing the internal parts. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","You must eat all the meat that evening; do not let any of the meat remain to be eaten the next morning. If any of the meat is left until the next morning, you must completely burn it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","When you eat it, you must be dressed ready to travel, and you must eat it quickly. You must have your sandals on your feet and your walking stick in your hands. It will be a festival called Passover to honor me, Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","On that night I will go through all the country of Egypt, and I will kill all the oldest males in Egypt, both humans and animals. By doing this I will show that all the gods in Egypt are worthless. I can do this, because I am Yahweh, the all-powerful God. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","The blood that you smear on the doorways will be a mark to indicate the houses in which you Israelis live. When I see the blood, I will ignore and pass by those houses, and I will not harm you Israelis who live there, when I punish the Egyptians. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Each year, you must celebrate this festival on this day, to remember what I, Yahweh, have done for you. In all the generations to come, each year you must celebrate this festival. It must continue forever. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","For seven days you must eat bread that has no yeast in it. On the first day of that week you must get rid of all the yeast that is in your houses. During those seven days, if anyone eats bread that is baked with yeast in it, you must consider that person to be no longer an Israeli. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","On the first day of that week, you must ◄have a holy meeting/gather together to worship me►. You must do the same thing on the seventh day. People must not work on those two days. The only work they may do is to prepare food for you to eat. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Every year you must keep celebrating this festival of eating bread that has no yeast in it, because it will remind you that it was on this day that I brought all your tribal groups out of Egypt. So every year, in all the generations to come, you must celebrate this day as a festival. It must continue forever. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","19","In the first month of the year, on the 14th day of that month, the only bread you may eat is bread that has no yeast in it. You must keep doing that each day until the 21st day of that month. For those seven days you must not have any yeast in your house. During that time, if anyone, either an Israeli or a foreigner, eats bread made with yeast, you must consider that person no longer to be an Israeli. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","In your houses, do not eat anything that has yeast in it during those seven days.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Then Moses/I summoned all the leaders of the Israeli people. He/I said to them, “Each family should select a lamb and kill it, in order that you may eat it to celebrate the festival that will be called ‘Passover’. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Let the lamb’s blood drain into a basin. Get a bunch/sprig of ◄hyssop/a very leafy plant► and dip it in the blood. Then smear some of the blood on the doorposts and the ◄lintels/beams above the doorways► of your houses. The people in each house must all stay inside the house until the next morning. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","When Yahweh goes throughout Egypt to kill the oldest male in each Egyptian family, he will see the blood on the ◄lintels/beams of your doorways►, and he will ignore and pass by those houses. He will not allow the angel who causes people to die to enter your houses and kill any of your oldest sons. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","You and your descendants must celebrate this festival forever. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","And when you arrive in the land that Yahweh will be giving to you as he promised, you must keep celebrating this ritual every year. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","When your children ask you, ‘What does this ritual mean?’, ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","you must tell them, ‘This ritual is to remember how our ancestors sacrificed lambs on the night that Yahweh’s angel passed by the houses of the Israeli people when they were in Egypt. He killed the oldest males/sons in all the Egyptian houses, but he spared the sons in MTY our houses.’” After Moses/I told them this, they all bowed their heads and worshiped Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Then the Israeli people did what Yahweh had told Aaron and Moses/me to tell them to do. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","At midnight Yahweh killed all the oldest sons of the Egyptian people, all over Egypt. That included the king’s oldest son, the oldest sons of the prisoners in the dungeon/jail, and the oldest sons of everyone else. He also killed the oldest males of all the Egyptians’ livestock. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","That night the king, all his officials, and all the rest of the Egyptian people awoke and discovered what had happened. They wailed loudly all over Egypt, because in every house, someone’s son had died. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","That night the king summoned Aaron and Moses/me and said, “You and all the other Israeli people, must leave my country immediately! Go and worship Yahweh, as you requested! ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Take your flocks of sheep and goats and herds of cattle, and leave! And ask Yahweh to bless me, also!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Then the Israeli people did as Moses/I had told them. They went to their Egyptian neighbors and asked them for silver and gold jewelry and clothing. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Yahweh caused the Egyptian people to greatly respect the Israeli people, so they gave them what they asked for. In that way, they carried away the wealth of the Egyptian people. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","The Egyptians urged the Israeli people to leave their country quickly. They said, “If you do not do that, we will all die!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","So the Israeli people prepared to leave at once. They took the bowls in which they mixed the dough to make bread, and the dough that was in the bowls without any yeast in it, and they wrapped the bowls in their cloaks. They put the bowls on their shoulders and left. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","The Israeli people traveled from Rameses city to Succoth town. There were about 600,000 men who went, in addition to the women and children. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Many other people who were not Israelis went along with them. There were also livestock, the flocks of sheep and goats and herds of cattle. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","On their way, they baked bread with the dough that they carried with them when they had been expelled from Egypt. The dough did not have yeast in it, because they were told to leave Egypt so quickly that they did not have enough time to get food ready to take with them, or enough time to mix yeast in the dough. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","The Israeli people had lived in Egypt 430 years. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","On the day that those 430 years ended, on that very day, all the tribes of Yahweh’s people left Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","It was a night when Yahweh ◄protected/guarded over► them as he brought them out of Egypt. So this same night every year is a night that is dedicated to Yahweh, a night when the Israeli people in every generation remember how Yahweh protected our ancestors. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","44","Then Yahweh said this to Aaron and Moses/me: “These are my instructions about the Passover ritual: Do not let foreigners eat the Passover meal. But any male slaves that you have bought may eat it after you have circumcised them. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Do not let people who are living among you temporarily, or servants whom you have hired, eat the Passover meal. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Each family must eat the Passover meal inside their own house. Do not take any of the food outside the house. And do not break any of the bones of the lamb that is sacrificed. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","All the Israeli people must celebrate this festival. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","When someone from another country comes to live with you and wants to celebrate the Passover Festival, circumcise all the males in his household. Then they may eat the Passover meal, and you should treat those people as though they were born as Israelis. But do not allow men who have not been circumcised to eat the Passover meal. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","These rules apply to people who were born as Israelis and to foreigners who come and live among you.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","All the Israeli people obeyed Aaron and Moses/me and did what Yahweh had commanded. ");
INSERT INTO eng_t4t_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","On that very day Yahweh brought all the tribes of the Israeli people out of Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Set apart all the firstborn males in order that they may belong to me. The firstborn males of the Israeli people and of their animals will be mine.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moses/I said to the people, “Do not forget this day! This is the day that you are leaving Egypt. This is the day you are freed from being their slaves. Yahweh has brought you out of Egypt by his great power MTY. Do not eat any bread that has yeast in it whenever you celebrate this day. ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","You are leaving Egypt on this day, which is the first day of the month that is named Abib. ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Later, when Yahweh brings you into the land where the descendants of Canaan, Heth, Amor, Hiv, and Jebus now live, the land that he solemnly promised to give to you, a land that will be very good for raising livestock and growing crops MTY, you must celebrate this festival during this month every year. ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","For seven days the bread that you eat must not have any yeast in it. On the seventh day there must be a festival to honor Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","For seven days do not eat bread that has yeast in it. You should not have any yeast or bread made with yeast anywhere in your land. ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","On the day the festival starts, you must tell your children, ‘We are doing this to remember what Yahweh did for our ancestors when they left Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","This ritual will remind you how Yahweh brought your ancestors out of Egypt with his great power MTY. The ritual will be like something you tie on your forehead or on your wrist. It will remind you to recite to others what Yahweh has instructed you. ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","So you must celebrate this festival every year at the time Yahweh has appointed.’ ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Yahweh will bring you into the land where the descendants of Canaan live, just as he promised you and your ancestors that he would do. When he gives that land to you, ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","you must dedicate to Yahweh the firstborn males of all your animals. These all will belong to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","You may keep the firstborn male donkeys, but you must buy them back by sacrificing a lamb as a substitute for the donkey. If you do not want to buy back the donkey, you must kill it by breaking its neck. You must also buy back every one of your own firstborn sons. ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","In the future, when one of your children asks, ‘What does this mean?’, you must say to him, ‘Yahweh brought our ancestors out of Egypt with his great power MTY, and freed us from being slaves there. ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","The king of Egypt stubbornly refused to let them leave his country, so Yahweh killed all the firstborn males in Egypt, both the boys and the firstborn of their livestock. That is why we now sacrifice to Yahweh all the firstborn of our livestock, but we buy back our own firstborn sons.’ ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","I repeat that this ritual will remind you about how Yahweh brought our ancestors out of Egypt by his great power MTY; it will be like something you tie on your wrist or on your forehead to remind you of that.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","When the king of Egypt let the Israeli people go, God did not lead them to go through the land of the Philistines. That was a shorter way, but God said, “It would be bad if my people change their minds when they realize that they will have to fight the Philistines to take their land, and then decide to return to Egypt.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Instead, God led them to go around through the desert toward the Red Sea (OR, the Gulf of Suez). When the Israeli people left Egypt, they were carrying weapons to fight their enemies. ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moses/I had them take along the bones of Joseph with them/us, because Joseph long ago had made the Israeli people promise solemnly that they would do that. He had said to them, “God will enable your descendants to leave Egypt. When that happens, you must carry my bones with you.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","The Israeli people left Succoth and traveled to Etham, at the edge of the desert, and they set up their tents there. ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","When they traveled during the daytime, Yahweh went in front of them in a tall white cloud to show them the way. During the night, he went in front of them in a tall cloud that looked like a fire. By doing that, he enabled them to travel in the daytime and also at nighttime. ");
INSERT INTO eng_t4t_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","The tall cloud did not leave them. It was always in front of them, as a bright white cloud in the daytime and like a fire at night. ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Then Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Tell the Israeli people to turn around and go back and set up their tents in front of Pi-Hahiroth town. That town is between Migdol and the sea, across from Baal-Zephon town. Set up your tents there, close to the sea. ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","When the king knows you have done that, he will think, ‘The Israeli people are confused. They are wandering around, and the desert blocks their path.’ ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","But I will make the king stubborn again, and he will take his army and pursue you. Then my people will praise/thank me for winning a victory over the king and his army. And the Egyptians will know that I, Yahweh, have the power to do what I say that I will do.” So Moses/I told my people that, and they did what he/I told them to do. ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","When someone told the king that the Israeli people had left during the night, he and his officials changed their minds and said, “◄What have we done?/What we have done was stupid!► RHQ The Israeli people will no longer be our slaves!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","So the king got his chariot and his army ready. ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Then he selected 600 of the best chariots, and in each chariot he placed a driver, a soldier, and a commander, and they left. Other chariots, with a driver and a soldier in each of them, also went along. ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Because Yahweh made the king of Egypt so stubborn that he and his army went to pursue the Israelis, who were leaving triumphantly, ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","the Egyptian army, with all the king’s horses and chariots and horsemen, pursued the Israelis. They caught up with them as they were camped near the sea, close to Pi-Hahiroth, in front of Baal-Zephon town. ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","When the king’s army got near, the Israeli people were surprised to see that the Egyptians were marching toward them. They were terrified; so they cried out to Yahweh to help them. ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Then they said to Moses/me, “Is it because there were no places in Egypt where we could be buried that you have brought us here to die in this desert RHQ? Look what you have done to us by bringing us out of Egypt RHQ! ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","That is what we told you when we were in Egypt! We said, ‘Leave us alone, and let us work for the Egyptians RHQ!’ It would have been better for us to be slaves for the Egyptians than to die here in the desert!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moses/I replied to the people, “Do not be afraid! Be brave, and see how Yahweh will rescue you! He will save you today, and the result will be that the Egyptians that you are looking at today—you will never see them again! ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yahweh will fight for you! Just keep quiet. There is nothing else that you will have to do.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","16","Yahweh said to Moses/me, “Tell the people to stop crying out for me to help them, and tell them to go forward. Lift up your stick and stretch it out toward the sea. The water will divide, so that all you Israeli people can go in the middle of the sea, walking on dry ground. ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","I will make the Egyptians stubborn, so that they will try to follow you. And then as a result of what I will do to the king and his army and his chariots and his horsemen, my people will praise/thank me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","And when I have won a glorious victory over the king and his chariots and his horsemen, the other Egyptians will know that I, Yahweh, have the power to do what I say that I will do.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Then the angel of God, who had been in front of the Israeli people, moved and went behind them. The tall bright cloud that had been in front of them also moved behind them, ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","until it was between the Egyptian army and the Israeli people. The cloud caused the Egyptian army to be in the dark but it gave light for the Israelis. As a result, neither group could come near the other group during the whole night. ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","That evening, Moses/I stretched out his/my hand toward the sea. Then Yahweh sent a strong wind from the east. It blew all night and pushed the water apart, and it caused the ground between the water to dry up. ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Then we Israeli people went on the dry land in the middle of the sea. The water was like a wall on each side of us, on the right side and on the left side. ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Then the Egyptian army pursued them, and went after them into the middle of the sea, with their horses and their chariots and the chariot-drivers. ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Just before dawn, Yahweh looked down from the fiery cloud, and then he caused the Egyptian army to panic. ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","He caused the wheels of the chariots to get stuck in the mud, so that they could hardly move. So the Egyptians said, “Yahweh is fighting for the Israelis and against us; let’s get out of here!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Then Yahweh said to Moses/me, “Stretch out your arm toward the sea again. Then the water will come back on the Egyptians and on their chariots and their horsemen.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","So Moses/I stretched out his/my arm, and as the sun was rising, the water returned to its normal level. The Egyptians tried to escape, but Yahweh hurled them back into the sea. ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","The water returned and covered the chariots and the horsemen and the whole Egyptian army that had tried to follow us Israelis into the sea. Every one of the Egyptians drowned. ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","But we Israeli people had already crossed through the sea by walking on dry ground, with the water being like two walls, one on the right side and one on the left side. ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","That is the way Yahweh saved the Israeli people from the Egyptian army on that day. The Israeli people saw the Egyptians lying dead, with their bodies washed up on the shore. ");
INSERT INTO eng_t4t_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","The Israelis saw what Yahweh did to the Egyptians by his great power MTY, and they were in awe of Yahweh. They trusted in Yahweh and they also trusted Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Then Moses/I sang this song, and the Israeli people sang with him: “I will sing to Yahweh, because he has triumphed gloriously; He has thrown the horses and their riders into the sea! ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yahweh is the one who makes me strong, and he is the one I sing about. He is the one who has saved me. He is ◄my God/God, the one I worship►, and I will praise him. He is the one my father worshiped, and I will tell others how great he is. ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yahweh is a warrior; Yahweh is his name. ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","He has thrown the king’s chariots and his army into the sea; His best officers all drowned in the Red Sea (OR, Gulf of Suez). ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","The water covered them like a flood; they sank to the bottom like a stone. ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","O Yahweh, your right arm has awesome power; with that power MTY, O Yahweh, you have crushed/smashed the enemy into pieces. ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","You have gloriously defeated your enemies. Because you were angry with them, you have destroyed them like a fire burns up straw SIM. ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","You blew on the sea, and the water piled up high; the water stood up like two walls. In the deepest part of the sea the water became thick/solid, as though it was frozen. ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Our enemies said, ‘We will pursue them and catch up to them. We will draw our swords and strike them. After we defeat them, we will divide up the spoils. We will take from them all we want.’ ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","But you blew on them with your breath, and then the sea covered them. They sank like lead/rocks in the big waves. ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Yahweh, among their gods, there is no god like you RHQ! You are glorious, completely different from all that you made. ◄There is no god like you!/What god is like you?► RHQ There is no one who can perform all kinds of miracles DOU like you do RHQ! ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","When you stretched out your right hand, the earth swallowed up our enemies ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","You faithfully loved the people you rescued; with your power you are leading them to the land that you have set apart. ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","The people of other nations will hear what you have done; and they will tremble. The people in Philistia will be terrified. ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","The chiefs in Edom will be dismayed. The leaders in Moab will be so afraid, they will shake. All those who live in Canaan will faint. ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","They will be terrified and fearful because of your great strength MTY. But they will be as silent as stones until your people march past them, the people you freed from being slaves in Egypt, ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","to go to Canaan land. You will enable them to live MET on your hill, at the place that you, O Yahweh, have chosen to be your home, in the ◄holy place/temple► that you yourself will build. ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","O Yahweh, you will rule forever! ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","The Israeli people walked through the middle of the sea on dry ground. But when the king’s horses and chariots and horsemen tried to go through the sea, Yahweh caused the water to come back and cover them.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Then Miriam, who was Aaron’s older sister and a ◄prophetess/woman who spoke messages that came directly from God►, picked up her tambourine, ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","and she sang this song to Yahweh: “Sing to Yahweh, because he has triumphed gloriously over his enemies. He has thrown the horses and their riders into the sea.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Then Moses/I led the Israeli people away from the Red Sea (OR, Gulf of Suez). They/we went to the desert at Shur. They/We walked for three days, but they/we could not find any water. ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","So they/we went on and came to a place named Marah. There was water there, but they/we could not drink it, because it was bitter. That is why they named the place Marah, which is the Hebrew word that means ‘bitter’. ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","The people complained to Moses/me, saying, “What are we going to drink?” ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","So Moses/I prayed earnestly to Yahweh. Then Yahweh showed him/me a tree. So he/I cut off one of the branches and threw it into the water, and the water became good to drink. There at Marah, Yahweh gave them various laws to direct their lives. He also tested them there, to determine if they would obey him, ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","by saying, “I am Yahweh, your God. If you will carefully obey me when I speak to you, and do those things that I know are right, and pay close attention to all the things that I command you, I will keep you from being afflicted by all the diseases that I brought on the Egyptians. Do not forget that I am the one who heals you.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","After they/we left Marah, they/we came to a place named Elim. There were twelve springs of water and 70 palm trees there. So they/we camped there. ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","They/We left Elim, and all the Israeli people came to the desert named Sin. That is between Elim and Sinai Mountain. That was on the fifteenth day of the second month after they/we left Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","There in the desert, the Israeli HYP people complained to Aaron and Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","They said to them/us, “We wish that Yahweh had killed us in Egypt! There we had meat to eat, and all the bread that we wanted. But you have brought us into this desert in order that we will all starve to death!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Yahweh said to Moses/me, “Listen to what I am going to do. I am going to send something from the sky that will take the place of bread for all of you. When I do that, the people must go out of their tents every day and gather just enough to eat on that day. When I do that, I will find out whether they will obey my instructions or not. ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","On the sixth day after I start doing that, they will be able to gather twice as much as on the other days, and not have to gather any on the seventh day. Then they can prepare it to eat it on the 6th and 7th days.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","So Aaron and Moses/I said to all the Israeli people, “This evening you will know that it was Yahweh, not we, who brought you out of Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","And tomorrow morning you will see how great Yahweh is, because he has heard what you have complained about. He is the one whom you have really complained to, because we are just his servants.” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Then Moses/I also said, “From now on, each evening Yahweh will give you meat to eat, and each morning he will give you something that will take the place of bread, because he has heard what you have complained about. Yahweh is the one to whom you have really complained, not us. We are just his servants.” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Then Moses/I said to Aaron, “Tell all the Israeli people, ‘Come and stand here in the presence of Yahweh, because he has heard what you have been complaining about.’” ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","So Aaron told them that. And as Aaron was talking to all the Israeli people, they looked toward the desert, and were surprised to see the ◄dazzling light/incredible brightness► of Yahweh in the cloud that had been leading them. ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Then Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“I have heard what the Israeli people have been complaining about. So say to them, ‘From now on, each evening, you will have meat to eat. And each morning you will have something that will take the place of bread. You will have all you want of it to eat.’ Then you will know that I, Yahweh, have the power to do what I say that I will do.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","That evening, ◄quails/small plump birds► appeared, and there were so many that they covered the campsite. The next morning there was something like dew all around the campsite. ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","When the dew evaporated, on the surface of the desert there was a thick layer of something that looked like white flakes. It looked like frost. ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","When the Israeli people saw it, since they had never seen it before and did not know what it was, they said to each other, “What is it?” Moses/I replied to them, “It is something Yahweh has given you to eat, to take the place of bread. ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","This is what Yahweh has commanded: ‘Each of you should gather as much as you need to eat. Gather two quarts/liters for each person who lives in your tents.’” ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","So that is what the Israeli people did. Some gathered more and some gathered less. ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","But when they measured what they had gathered, those that had gathered a lot did not have anything left over. And those that gathered less still had enough to eat. Each person gathered just what they needed. ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moses/I said to them, “Do not leave any of it to eat tomorrow morning!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","But some of them did not pay any attention to what Moses/I said. They kept some of it until the next morning. But it was full of maggots and smelled rotten. And that made Moses/me angry. ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Each morning they gathered as much as they needed. But later, when the sun got hot, what was left on the ground melted. ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","On the sixth day after they started gathering it, each person was able to gather four quarts/liters, which was twice as much as they gathered on the other days. When the leaders of the people came to Moses/me and told him/me about that, ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Moses/I said to them, “This is what Yahweh has commanded: ‘Tomorrow will be a day for you to rest completely. It will be a day dedicated to Yahweh. So today, bake or boil what you will need for today and for tomorrow. Whatever is left this evening, you should put aside and keep it to eat tomorrow.’” ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","So they did what Moses/I commanded. What was left over, they kept until the next day. It did not spoil and did not get maggots in it! ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","On that day, Moses/I said, “Eat today what you have saved from yesterday, because today is a day dedicated to Yahweh. Today you will not find any of that food outside. ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Every week, you must gather it for six days; but on the seventh day, which will be a day of rest, you will not find any.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","On the seventh day, some of the people went outside their tents to gather some of that food, but there was none. ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Then Yahweh told Moses/me to say this to the people: “How long will you people refuse to do all the things that I tell you? ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Listen! Yahweh has given you a day of rest. So on the sixth day of each week, he will be giving you enough of this food for two days. Each of you should stay in his tent and do no work on the seventh day!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","So the people rested on the seventh day. ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","The Israeli people called this food manna, which sounds like the words in their language that mean ‘what is it?’ It looked like small seeds called coriander, but it was white, and it tasted like thin wafers/biscuits made with honey. ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moses/I said, “This is what Yahweh has commanded: ‘You must keep two quarts/liters of it for all future generations, so that they can see the food that took the place of bread that I gave to your ancestors when I brought them out of Egypt.’” ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","And he/I said to Aaron, “Take a jar, and put two quarts of manna in it. Then put it in a place where Yahweh can see it. It is to be kept like that for all future generations.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Many years later, as Yahweh had commanded Moses/me, Aaron put the jar in front of the box that contained the stone slabs on which the Ten Commandments were written. ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","The Israeli people were able to eat manna every day for 40 years, until they came to the border of Canaan land. ");
INSERT INTO eng_t4t_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(The standard measure that they used at that time held 20 quarts/liters.) ");
INSERT INTO eng_t4t_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Obeying what Yahweh commanded, all the Israeli people moved from the Sin Desert. They/We traveled from one place to another. They/We camped at a place named Rephidim, but there was no water there for ◄the people/us► to drink. ");
INSERT INTO eng_t4t_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","So the people complained to Moses/me again, saying, “Give us water to drink!” Moses/I replied to them, “Why are you ◄criticizing/arguing with► me RHQ? And why are you trying to determine whether Yahweh has the power to provide for you?” ");
INSERT INTO eng_t4t_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","But the people were very thirsty, and they continued to complain to Moses/me. They were saying things like “Why did you bring us out of Egypt?”, and “Did you bring us here to cause us and our children and livestock to die ◄from thirst/because we had no water to drink► RHQ?” ");
INSERT INTO eng_t4t_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","So Moses/I prayed earnestly to Yahweh. He/I said, “◄How shall I deal with these people?/I do not know how to deal with these people!► RHQ They are almost ready to kill me by throwing stones at me!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yahweh replied to Moses/me, “Take some of the elders/leaders of the Israeli people with you and tell the rest of the people to follow you to Sinai Mountain. Take along the stick with which you struck the Nile River. ");
INSERT INTO eng_t4t_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Listen carefully: I will stand in front of you on top of a large rock at the foot of the mountain. Strike the rock with your stick. When you do that, water for the people to drink will flow out of the rock.” When they/we arrived at the mountain, Moses/I did that while the Israeli elders were watching, and water flowed from the rock. ");
INSERT INTO eng_t4t_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Moses/I gave that place two names in the Hebrew language: Massah, which means ‘testing’, and Meribah, which means ‘complaining’. He/I gave it the name Massah because the Israeli people were testing Yahweh, saying “Is Yahweh really among us and able to help us, or not?”, and he/I gave it the name Meribah because they were continually complaining. ");
INSERT INTO eng_t4t_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Then the descendants of the Amalek people-group came and fought against the Israeli people at Rephidim. ");
INSERT INTO eng_t4t_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Moses/I said to Joshua, who was one of our army/Israeli leaders, “Choose some men to go out and fight against the Amalek people-group tomorrow. I will stand on the top of the hill, holding the stick that God told me to carry.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","So Joshua did what Moses/I told him to do. He took some men to fight against the Amalek people-group. While they were fighting, Aaron, Hur, and Moses/I went up to the top of the hill so that they/we could see the whole battle area. ");
INSERT INTO eng_t4t_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Whenever Moses/I lifted up his/my arms, the Israeli men started to win the battle. And whenever he/I lowered his/my arms, the Amalek people-group started to win. ");
INSERT INTO eng_t4t_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","But his/my arms became tired. So Aaron and Hur rolled a large stone for Moses/me to sit on. While he/I was sitting on it, those two held up his/my arms, one on one side and the other on the other side. In that way, they kept his/my arms lifted up, and his/my arms held steady until the sun went down. ");
INSERT INTO eng_t4t_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","So Joshua and the men with him completely defeated the Amalek people-group, using their swords to fight against them. ");
INSERT INTO eng_t4t_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Then Yahweh said to Moses/me, “Write an account of this battle, and then read it to Joshua. Also write that some day I will completely get rid of the Amalek people-group.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Then Moses/I built a stone altar there and named it ‘Yahweh is like my flag’. ");
INSERT INTO eng_t4t_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","He/I said, “Hold high Yahweh’s flag! Yahweh will continue to fight against the Amalek people-group ◄forever/in all future generations►!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jethro, who was the priest for the Midian people-group, and who was also Moses’/my father-in-law, heard about all that God had done for the Israeli people. He heard about how Yahweh had brought them out of Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Moses/I had previously sent his/my wife Zipporah back home when he/I was returning to Egypt. But now Jethro came to him/me, ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","bringing Zipporah and their/our two sons. One son was named Gershom, which sounds like the Hebrew word that means ‘foreigner’, because he/I had said, “I have been a foreigner living in another land.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Her other son was named Eliezer, which sounds like the Hebrew words that mean ‘God helps me’, because he/I had said “God, whom my father worshiped, has helped me and saved me from being killed MTY by the king of Egypt.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","While Moses/I was camped with the Israeli people in the desert near Sinai, God’s sacred/holy mountain, Jethro came to him/me, bringing along Moses’/my wife and our two sons. ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jethro had sent a message to Moses/me, “I, your father-in-law, Jethro, am coming to see you, bringing along your wife and your two sons!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","So Moses/I went out of the campsite to meet his/my father-in-law. He/I bowed before him, and kissed him on the cheek. ◄They both/We► asked each other, “Have you been healthy?” Then they/we went into Moses’/my tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moses/I told Jethro everything that Yahweh had done to the king and all the other people in Egypt for the sake of the Israeli people. He/I also told him about the troubles/problems they/we had experienced on the way, and how Yahweh had helped them/us. ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jethro rejoiced when he heard all that Yahweh had done for the Israeli people. ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","He said, “Praise Yahweh, who has rescued you from the powerful MTY Egyptian king and his army! ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Now I realize that Yahweh is greater than all other gods, because he rescued you all from the power MTY of the proud Egyptians when they were causing you to suffer.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Then Jethro sacrificed an animal by burning it completely on the altar as an offering, and he also offered other sacrifices to God. Aaron and the Israeli elders/leaders went with them/us to eat a sacred meal with Jethro. ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","The next day, Moses/I sat down at the place where he/I settled disputes among the people. The people were continually bringing their disputes to Moses/me, from morning until evening. ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","When Jethro saw everything that Moses/I was doing for the people, he said, “◄Why are you doing all this for the people?/You should not be doing all this for the people!► RHQ Why are you doing this by yourself, and all the people are crowding around you, from morning until evening, asking you to make decisions for them RHQ?” ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moses/I replied, “I am doing this because the people keep coming to me to find out what God desires. ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","When they have a dispute about something, they come to me, and they ask me to decide which of them is right. I also tell them all of God’s laws and instructions.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Jethro said to him/me, “What you are doing is not good for you or for the people. ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","You and these people will ◄wear yourselves out/become exhausted►! This work is too much for one person. You are not able to do it by yourself. ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Now listen to some good advice MTY I will give to you. If you do what I suggest, God will help you. You should continue to speak to God and tell him about the people’s disputes. ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","You should also teach the people what God has commanded and instructed you. You should also explain to them how they should conduct their lives, and the things that they should do. ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","But in addition, you should choose some other men to help you. Choose men who have reverence for God and who will not accept bribes. Appoint some of them to make decisions for groups of ten people, some for groups of 50 people, some for groups of 100 people, and some for groups of 1,000 people. ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Allow them to serve permanently to settle disputes for the people. The difficult matters the people can bring to you; but the matters that are not difficult, they can decide themselves. That will make the work easier for you, as they help you do that work. ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","If you do that, and I think that God is telling you to do it (OR, if God tells you to do it), you will not become exhausted, and all the people will be able to go home feeling satisfied about the decisions, with their disputes settled quickly”. ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moses/I accepted what his/my father-in-law Jethro suggested. ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Moses/I chose capable men from among the Israeli people. ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","They were appointed permanently to make decisions about the people’s disputes. They brought the difficult cases to Moses/me, but they decided the matters that were not difficult by themselves. ");
INSERT INTO eng_t4t_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Then Moses/I said goodbye to his/my father-in-law, and Jethro returned home. ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","The Israeli people then left Rephidim, and exactly two months after leaving Egypt, they/we came to the desert near Sinai Mountain. They/We set up their/our tents at the base of the mountain. ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moses/I climbed up the mountain to talk with God. Yahweh called to him/me from the top of the mountain and said, “This is what I want you to say to the Israeli people, the descendants of Jacob: ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘You have seen what I did to the Egyptians. You have seen what I did for all of you and how I brought you here to me. It was as though I lifted you up as an eagle carries its young eaglets on its wings MET. ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","So now, if you will do what I tell you and obey all that I command you, you will be my own people. All the people-groups on the earth are mine, but you will be ◄dearer/more special► to me than all the other people-groups. ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","You will be people over whom I will rule, and you will all ◄be like priests/represent me to other nations as priests represent me to one nation► MET, and you will be completely dedicated to me.’ That is what you must tell the Israeli people.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","So Moses/I went down the mountain and summoned the elders/leaders of the people. He/I told them everything that Yahweh had told him/me to tell them. ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","The people all said, “We will do everything that Yahweh has told us to do.” Then Moses/I climbed back up the mountain and reported to Yahweh what the people had said. ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Then Yahweh said to Moses/me, “Listen carefully: I am going to appear to you from inside a thick cloud. When I am speaking to you, the people will hear it, and they will always trust in you.” Then Moses/I went down the mountain and reported to the people what Yahweh said. Then he/I went back up the mountain and told Yahweh what the people replied. ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Then Yahweh said to Moses/me, “Go back down to the people again. Tell them to purify themselves today and tomorrow. Tell them to wash their clothes, too. ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","They must do that to be ready on the day after tomorrow. On that day I will come down to Sinai Mountain to where all the people can see me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","You must make a boundary around the base of the mountain, and tell them, ‘Be sure that you do not climb the mountain or even go near it. Anyone who even touches the base of the mountain must be executed.’ ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Do not let anyone touch any person or any animal that touches the mountain. You must kill any person or animal that touches the mountain by throwing stones at it or shooting it with arrows. But when you hear a long loud trumpet sound, the people can come close to the base of the mountain.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","So Moses/I went down the mountain again and told the people to purify themselves. They did what Moses/I told them to do, and they also washed their clothes. ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Then Moses/I said to the people, “Be ready on the day after tomorrow. And you men must not have sex with EUP your wives until after then.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Two days later, during the morning, there was thunder and lightning, and a very dark cloud on the mountain. A trumpet sounded very loudly, with the result that the people in the camp shook/trembled because they were very afraid. ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Then Moses/I led the people outside the camp to meet with God. They stood at the base of the mountain. ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","All of Sinai Mountain was covered in smoke, because Yahweh had descended on it, surrounded by a fire. The smoke rose up like the smoke from the chimney of a furnace, and the whole mountain shook violently. ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","As the sound of the trumpet continued to become louder, Moses/I spoke to Yahweh, and Yahweh answered him/me in a loud voice that sounded like thunder. ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Then Yahweh came down again onto the top of Sinai Mountain, and he summoned Moses/me to come up to the top of the mountain. So Moses/I went up. ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Yahweh said to Moses/me, “Go down again and warn the people not to cross the boundary in order to look at me. If they do that, many of them will die. ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Also, the priests who habitually come near me must purify themselves. If they do not do that, I will punish them.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Then Moses/I said to Yahweh, “The people will not climb the mountain, because you commanded them, saying, ‘Set a boundary around the mountain, to make it sacred/taboo.’” ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yahweh replied, “Go down the mountain, and bring Aaron back up with you. But do not allow the priests or other people to cross the boundary to come up to me. If they cross it, I will punish them.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","So Moses/I went down the mountain again and told the people what Yahweh had said. ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Then God said this to the Israeli people: ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“I am Yahweh God, the one you worship. I am the one who brought you out of Egypt. I am the one who freed you from being slaves there. ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","So you must worship only me; you must not worship any other god. ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","You must not carve/make for yourselves any idol that represents anything in the sky or that is on the ground or that is in the water under the ground/earth. ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","You must not bow down to any idol and worship it, because I am Yahweh God, and I ◄am very jealous/want you to worship me only►. I will punish those who sin and hate me. I will punish not only them, but I will punish ◄their descendants, down to the third and fourth generation/their children and grandchildren and great-grandchildren►. ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","But I will steadfastly love thousands of generations of those who love me and obey my commandments (OR, I will love for thousands of generations.) ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Do not use my name carelessly (OR, for wrong/evil purposes), because I am Yahweh God, the one whom you should worship, and I will certainly punish those who use my name for wrong/evil purposes LIT. ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Do not forget that the seventh day of every week is mine, so dedicate those days to me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","There are six days each week for you to do all your work, ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","but the seventh day is a day of rest, a day dedicated to me, Yahweh God, the one whom you should worship. On that day you must not do any work. You and your sons and daughters and your male and female slaves must not work. You must not even force your livestock to work, and you must not allow foreigners to work, those who are living in your country. ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","I, Yahweh, created the sky, the earth, the ocean, and everything that is in them, in six days. Then I stopped my work of creating everything, and rested on the seventh day. That is the reason that I, Yahweh, have blessed the rest day and set it apart to be a sacred/special day. ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Honor/Respect your fathers and your mothers, in order that you may live a long time in the land that I, Yahweh God, will give you. ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Do not murder anyone. ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Do not ◄commit adultery/have sex with anyone other than your spouse►. ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Do not steal anything. ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Do not falsely accuse anyone of committing a crime. ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Do not ◄covet/desire to have► someone else’s house, someone else’s wife, someone else’s male or female slave, someone else’s livestock, someone else’s donkeys, or anything else that some other person owns.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","When the people heard the thunder and saw the lightning, and when they heard the sound of the trumpet and saw the smoke on the mountain, they were afraid and trembled. They stood at a distance, ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","and said to Moses/me, “If you speak to us, we will listen. But do not let God speak any more to us. We are afraid that if he speaks any more to us, we will die.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moses/I replied, “Do not be afraid! God has come to determine/test how you will behave. He wants you to revere him, and to not sin.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Then, as the people watched from a distance, Moses/I went close to the black cloud where God was. ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","23","Yahweh said to Moses/me, “Say this to the Israeli people: ‘You have heard how I, Yahweh, have spoken to you from heaven. I told you that you must not make any idols of silver or gold that you will worship instead of me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Make for me an altar from dirt. Sacrifice on it the animals that you will burn completely. Also sacrifice on it the animals that you will not burn completely, to maintain fellowship with me. Worship me MTY in any place that I choose for you to honor/worship me; and if you do that, I will come to you and bless you. ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","If you make for me an altar from stones, do not make it from stones that you have cut to make them look nice, because you will make the altar unsuitable for worshiping me if you use tools to cut the stones. ");
INSERT INTO eng_t4t_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Do not make an altar that has steps in front of it, because if you do that, people could see your naked buttocks as you go up the steps.’” ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Here are some other instructions to give to the Israeli people: ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","When/If you buy a Hebrew slave, he is to serve you for only six years. In the seventh year you must free him from being your slave, and he is not required to pay you anything for setting him free. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","If he was not married before he became your slave, and if he marries someone while he is your slave, his wife is not to be set free with him. But if he was married before he became your slave, you must free both him and his wife. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","If a slave’s master gives him a wife, and she gives birth to sons or daughters while her husband is a slave, only the man is to be freed. His wife and children will continue to be slaves of their master. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","But when it is time for the slave to be set free, if the slave says, ‘I love my master and my wife and my children, and I do not want to be set free,’ ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","then his master must take him to the place where they worship God (OR, to the owner’s house). There he must make the slave stand against the door or the doorpost. Then the master will use an ◄awl/pointed metal rod► to make a hole in the slave’s ear. Then he will fasten a tag to the slave’s ear to indicate that ◄he will own that slave for the rest of his life/he will own the slave as long as the slave lives►. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","If a man sells his daughter to become a slave, she should not be set free after six years, as the male slaves are. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","If the man who bought her wanted her to be his wife, but if later he is not pleased with her, he must sell her back to her father. He must not sell her to a foreigner, because that would be breaking the contract/agreement he made with the girl’s father. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","If the man who buys her wants her to be a wife for his son, he must then treat her as though she were his own daughter. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","If the master takes another slave girl to be another wife for himself, he must continue to give the first slave wife the same amount of food and clothing that he gave to her before, and he must continue to have sex EUP with her as before. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","If he does not do all these three things for her, he must free her from being a slave, and she is not required to pay anything for being set free. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","You must execute anyone who strikes another person with the result that the person who is struck dies. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","But if the one who struck the other did not intend to kill that person, the one who struck him can escape to a place that I will choose for you, and he will be safe there. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","But if someone gets angry with another person and kills him, even if the murderer runs to the altar, a place that God designated as a place to be safe, you must execute him. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Anyone who strikes his father or mother must surely be executed. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Anyone who kidnaps another person, either in order to sell that person or to keep him as a slave, must be executed. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Anyone who reviles/curses his father or his mother must be executed. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Suppose two people fight, and one strikes the other with a stone or with his fist. And suppose the person he strikes does not die but is injured and has to stay in bed for a while, ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","and later he is able to walk outside using a cane. Then the person who struck him does not have to be punished. However, he must pay the injured person the money he could not earn while he was recovering, and he must also pay the injured person’s medical expenses until that person is well. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","If someone strikes his male or female slave with a stick, if the slave dies ◄immediately/as a result► IDM, the one who struck him must be punished. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","But if the slave lives for a day or two after he is struck and then dies, you must not punish the one who struck him. Not having that slave to be able to work for him any longer is enough punishment. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Suppose two people are fighting and they hurt a pregnant woman with the result that ◄she has a miscarriage/her baby is born prematurely and dies►. If the woman is not harmed in any other way, the one who injured her must pay a fine. He must pay whatever the woman’s husband demands, after a judge approves of the fine. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","But if the woman is injured in some additional way, the one who injured her must be caused to suffer in exactly the same way that he caused her to suffer. If she dies, he must be executed. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","25","If her eye is injured or destroyed, or if he knocks out one of her teeth, or her hand or foot is injured, or if she is burned or bruised, the one who injured her must be injured in the same way. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","If the owner of a slave strikes the eye of his male or female slave and ruins it, he must free that slave because of what he did to the slave’s eye. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","If someone knocks out one of his slave’s teeth, he must free the slave because of what he did to the slave’s tooth. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","If a bull gores a man or woman with the result that the person dies, you must kill the bull by throwing stones at it, but you must not punish the owner of the bull. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","But suppose the bull had attacked people several times before, and its owner had been warned, but he did not keep the bull inside a fence. Then you must kill the bull by throwing stones at it, but you must also execute its owner. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","However, if the owner of the bull is allowed to pay a fine ◄to save his own life/in order not to be executed►, he must pay the full amount that the judges say that he must pay. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","If someone’s bull attacks and gores another person’s son or daughter, you must treat the bull’s owner according to that same rule. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","If a bull attacks and gores a male or female slave, its owner must pay to the slave’s owner 30 pieces of silver. Then you must kill the bull by throwing stones at it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Suppose someone has a pit/cistern and does not keep it covered, and someone’s bull or donkey falls into it and dies. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","Then the owner of the pit/cistern must pay for the animal that died. He must give the money to the animal’s owner, but then he can take away the animal that died and do whatever he wants to with it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","If someone’s bull hurts another person’s bull with the result that it dies, the owners of both bulls must sell the bull that is living, and they must divide between them the money that they receive for it. They must also divide between them the meat of the animal that died. ");
INSERT INTO eng_t4t_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","However, if people know that the bull often attacked other animals previously, and its owner did not keep it inside a fence, then the owner of that bull must give the owner of the bull that died one of his own bulls, but he can take away the animal that died and do with it whatever he wants to do.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Yahweh also said, “If someone steals a bull or a sheep, and then slaughters it to sell it or to sacrifice it or sells its meat to someone else, he must pay five bulls for the bull that he stole, and he must pay four sheep for the sheep that he stole. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","If a thief is caught while he is breaking into someone else’s house at night, if the one who catches him kills the thief, he is not guilty of murdering him. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","But if that happens during the daytime, the one who killed the thief is guilty of murdering him. The thief must pay for what he stole. If he has no animals with which to pay for the one that he stole, he must be sold to become someone’s else’s slave and the money must be used to pay for what he stole. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","If the thief still has the animal when he is caught, whether it is a bull or a donkey or a sheep, and it is still alive, the thief must give back the stolen animal as well as giving two additional animals for each one that he stole. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","If someone allows his animals to ◄graze/eat the grass► in his field or in his vineyard, and if they stray away and eat the crops in another person’s field, the owner of the animals must pay the owner of those crops by giving him the best crops from his own field or vineyard. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Suppose someone starts a fire in his own field, and the fire spreads through the grass and starts burning in someone else’s field, and the fire burns grain that is growing or grain that is already cut and stacked. Then the person who started the fire must pay completely for the damage. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Suppose someone gives to another person some money or other valuable goods and asks him to guard them in his house for a while. If those things are stolen from that person’s house, if the thief is caught, he must pay back twice as much as he stole. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","But if the thief is not caught, the owner of the house from which the things were stolen must stand before the judges, so that the judges can determine whether the owner of the house was the one who took the other man’s goods and sold them to someone else. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","If two people argue about which one of them owns a bull or a donkey or a sheep or some clothing, or something else that has been lost, the two people who each claim/say that the item belongs to them must stand before the judges. The one whom the judges declare is lying must pay back to the real owner twice as many bulls or donkeys or sheep or pieces of clothing. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Suppose someone gives his donkey or bull or sheep or some other animal to someone else and asks him to take care of it for a while, and the animal dies or is injured or is stolen while no one is watching. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Then the person who was taking care of the animal must ◄swear/solemnly declare►, knowing that God is listening, that he did not steal the animal. If he did not steal it the owner of the animal must accept/believe that the other person is telling the truth, and the other person will not have to pay anything back to the owner. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","But if the animal was stolen while he was supposed to be taking care of it, the man who promised to take care of it must pay back the owner for the animal. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","If he says that the animal was killed by wild animals, he must bring back the remains of the animal that was killed and show it to the animal’s owner. If he does that, he will not have to pay anything for the animal. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","If someone borrows an animal, and if that animal is hurt or dies when its owner is not there, the one who borrowed it must pay the owner for the animal. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","But if that happens when the owner of the animal is there, the one who borrowed it will not have to pay back anything. If the man who borrowed it only rented it, the money that he paid to rent it will be enough to pay for the animal dying or being injured.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“If a man persuades a girl/woman to have sex with him, a girl/woman who ◄is a virgin/has never had sex with any man► and who is not engaged to be married, he must pay the bride price for her and marry her. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","But if her father refuses to allow her to marry him, he must pay to the woman’s father the amount of money that is equal to the amount of bride price money that men pay for virgins. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","You must execute any woman who ◄practices sorcery/is a shaman►. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","You must execute any person who has sex with an animal. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","You must offer sacrifices only to Yahweh. You must execute anyone who offers a sacrifice to any other god. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","You must not mistreat a foreigner who comes to live among you. Do not forget that you were previously foreigners in Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","You must not mistreat any widow or any orphan. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","If you mistreat them and they cry out to me for help, I will hear them. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","And I will be angry with you, and I will cause you to be killed in a war MTY. Your wives will become widows, and your children will no longer have fathers. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","If you lend money to any of my people who are poor, do not act like a moneylender and require him to pay interest on the money. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","If he gives you his cloak to guarantee that he will pay the money back, you must give the cloak back to him before the sun goes down, ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","because he needs it to keep him warm during the night. ◄That is the only covering that poor people have when they sleep at night./What else will he cover himself with during the night?► RHQ If you do not act mercifully toward him by returning his cloak, when he cries out to me asking for my help, I will help him, because I always act mercifully. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Do not ◄revile/speak evil about► me, and do not ◄curse/ask me to do harmful things to► any ruler of your people. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","◄Do not withhold from/Give► me the best parts of the grain that you harvest and of the olive oil and the wine that you produce. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","You must dedicate your firstborn sons to me. Similarly, your firstborn male cattle and sheep belong to me. After those animals are born, allow them to stay with their mothers for seven days. On the eighth day, offer them to me as a sacrifice. ");
INSERT INTO eng_t4t_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","You are people who are ◄completely dedicated to/set apart for► me. And I detest the meat of any animal that has been killed by wild animals. Therefore you should not eat such meat. Instead, throw it where the dogs can eat it.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Do not tell to others ◄false rumors/untrue reports► about other people. Do not help someone who is guilty by ◄testifying falsely/lying► about what happened. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Do not join a group of people who are planning to do something evil. Do not testify the way the crowd wants you to, if that will prevent the judge from deciding the case justly/fairly. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","When a poor person is on trial, do not testify in his favor just because he is poor and you feel sorry for him. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","If you see someone’s bull or donkey when it is wandering away loose, take it back to its owner, even if the owner is your enemy. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","If you see someone’s donkey that has fallen down because of its heavy load, help the owner to get the donkey up again, even if he is someone who hates you. Do not just walk away without helping him. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Decide the cases of poor people who are on trial as fairly as you decide the cases of other people. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Do not accuse people falsely. Do not decide that innocent and righteous DOU people should be executed, because I will ◄punish/not forgive► people who do such an evil thing. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Do not accept money that is a bribe, because officials who accept bribes are not able to MTY decide what is right to do, and they do not allow innocent people to be treated fairly. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Do not mistreat foreigners who live among you. You know how people often treat foreigners, because the Egyptians did not treat you well when you were foreigners there. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Plant seeds in your ground and gather the harvest for six years. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","But during the seventh year you must not plant anything. If things grow without your planting seeds, allow poor people to harvest and eat the crops. If there are still crops ◄left over/that they do not harvest►, allow wild animals to eat them. Do the same thing with your grapevines/vineyards and your olive trees. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","You may work for six days each week, but on the seventh day you must rest and not work. And on the seventh day you must allow your work animals and your slaves and the foreigners who live among you also to rest and be refreshed. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Make certain that you obey everything that I have commanded you to do. Do not pray to MTY other gods. Do not even mention their names.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Every year you must celebrate three festivals to honor me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","The first one is the Festival of Bread That Has No Yeast. Celebrate it in the month that is named Abib. That is the month in which you left Egypt. Celebrate it in the way that I commanded you. And always bring LIT an offering when you come to worship me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","The second one is the Festival of Harvesting. During that festival you must offer to me the first parts/harvest of your crops that grow from the seeds that you planted. The third one is the Festival of Living in Temporary Shelters. That will be after you finish harvesting your grain and grapes and fruit. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Every year, at each of these times, all the men must gather together to worship me, Yahweh God. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","When you sacrifice an animal and offer it to me, you must not offer bread that has been baked with yeast. When you offer sacrifices, burn the fat from the animals on that same day. Do not allow any fat to remain until the next morning. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Each year, when you harvest your crops, bring to the place where you worship me, Yahweh God, the first part of what you harvest. When you kill a ◄young animal/kid or lamb or calf►, do not prepare to eat it by boiling it in its mother’s milk.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","21","“Note this: I am going to send an angel ahead of you, to guard you as you travel and to bring you safely to the place that I have prepared for you. Pay attention to what he says and obey him. Do not rebel against him, because he will have my authority MTY and he will ◄punish/not forgive► LIT you if you rebel against him. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","But if you pay attention to what he says and if you do all that I tell you to do, I will fight strongly DOU against all of your enemies. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","My angel will go ahead of you, and will take you to where the Amor and Heth and Periz and Canaan and Hiv and Jebus people-groups live, and I will completely get rid of them. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Do not bow down before their gods/idols or worship them. And do not do the things that they think that their gods want them to do. Completely destroy their gods/idols, and smash to pieces their sacred stones. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","You must worship me, Yahweh God. If you do that, I will bless your (OR, bless you by giving you) food and water, and I will protect you from becoming sick. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","No women in your land will have ◄miscarriages/babies that will die after being born prematurely►, and no women will be unable to become pregnant. And I will enable you to live a long time. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","I will cause the people who oppose you to become very afraid of me. I will cause the people whom you fight against to become very confused. And then I will cause them to turn around and run away from you. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","I will cause your enemies to become terrified. And I will expel the Hiv, Canaan, and Heth people-groups from your land. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","I will not expel all of them in less than one year. If I did that, your land would become deserted, and there would be very many wild animals ◄that would attack you/you would not be able to control►. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","I will expel those people-groups slowly, a few at a time, until the number of your people increases and you are able to live everywhere in the land. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","I will cause the borders of your land to extend from the ◄Red Sea/Gulf of Aqaba► in the southeast to the Mediterranean Sea in the northwest, and from the Sinai Desert in the southwest to the Euphrates River in the northeast of the country. I will enable you MTY to expel the people who live there, so that you will expel them as you occupy more of the country. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","You must not make any agreement/treaty with those people or with their gods. ");
INSERT INTO eng_t4t_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Do not allow those people to live in your land, in order that they do not cause you to sin against me. If you worship their gods, you will not be able to escape from worshiping them and sinning against me, just like someone caught in a trap is unable to escape MET.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Then Yahweh said to Moses/me, “Come to me, up on top of this mountain, you and Aaron and his sons Nadab and Abihu. Also take along 70 of the Israeli elders/leaders. While you are still some distance from the top of the mountain, prostrate yourselves on the ground and worship me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Moses, I will allow you alone to come near to me. The others must not come near, and the rest of the people must not come up the mountain.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moses/I went and told the people everything that Yahweh had said and all that he had commanded. The people all replied together, saying, “We will do everything that Yahweh has told us to do.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Then Moses/I wrote down everything that Yahweh had commanded. Early the next morning Moses/I built a stone altar. He/I also set up twelve stones, one for each of the Israeli tribes. ");
INSERT INTO eng_t4t_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","He/I also selected some young men. They burned sacrifices to Yahweh and they also sacrificed some cattle that they did not burn completely, for the purpose of maintaining fellowship with Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moses/I took half of the blood of the animals that were slaughtered and put it in bowls. The other half of the blood he/I threw/splashed against the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Then he/I took the scroll on which he/I had written everything that Yahweh had commanded in the agreement that he had made, and he/I read it aloud, while all the people were listening. Then all the people said, “We will do all that Yahweh has told us to do. We will obey everything.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Then Moses/I took the blood that was in the bowls and threw/splashed it on the people. He/I said, “This is the blood that ◄confirms/puts into effect► the agreement that Yahweh made with you when he gave you all these commands.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Then Moses/I, along with Aaron, Nadab, Abihu, and the 70 Israeli elders/leaders, went up the mountain, ");
INSERT INTO eng_t4t_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","and they/we saw God, the one whom the Israeli people worship. Under his feet was something like a pavement made of expensive blue stones called sapphires. They were as clear as the sky is when there are no clouds. ");
INSERT INTO eng_t4t_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","God did not harm MTY those Israeli elders/leaders because of their having seen him. They saw God, and they ate and drank together! Then we all went back down the mountain. ");
INSERT INTO eng_t4t_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Then Yahweh said to Moses/me, “Come up to me again on top of this mountain. While you are here, I will give you two stone slabs on which I have written all the laws DOU that I have given to you to instruct/teach the people.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","14","So Moses/I told the elders, “Stay here with the other people until we return! Do not forget that Aaron and Hur will be with you. So if anyone has a dispute while I am gone, he can go to those two men.” Then Moses/I went with his/my servant Joshua part of the way up the mountain that was dedicated to God. ");
INSERT INTO eng_t4t_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Then Moses/I went the rest of the way up the mountain. A cloud covered the mountain. ");
INSERT INTO eng_t4t_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","The ◄glory/brilliant light► of Yahweh came down on the mountain and covered it for six days. On the seventh day, Yahweh called to Moses/me from the middle of the cloud. ");
INSERT INTO eng_t4t_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","When the Israeli people looked at the top of the mountain, the glory of Yahweh was like a big fire that was burning there. ");
INSERT INTO eng_t4t_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moses/I went into the cloud on top of the mountain. He/I was there for 40 days and nights. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Yahweh said to Moses/me, “There are many things that I want you to tell to the Israeli people. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Tell them that they must give offerings/gifts to me. Receive from the people every offering/gift that they want to give to me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","These are the things that they may offer/give: Gold, silver, bronze, ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","blue, purple, and scarlet yarn/wool, fine ◄linen/white cloth►, goats’ hair for making cloth, ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","rams’ skins that have been ◄tanned/dyed red►, goatskins, hard wood from acacia trees, ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","olive oil to burn in the lamps, spices to put in the olive oil for anointing the priests and in the sweet-smelling incense, ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","expensive quartz stones called onyx, and other expensive stones to be fastened to the priest’s vest and put on the pouches that are to be fastened to the vest. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Tell the people to make a big Sacred Tent for me, so that I can live in it among them. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","They must make the Sacred Tent and all the things that will be used inside it according to the plan/model that I will show you.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Tell the people to make a sacred chest from acacia wood. It is to be ◄45 in./110 cm.► long, ◄27 in./66 cm.► wide, and ◄27 in./66 cm.► high. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Cover it with pure gold inside and outside, and put a gold border around the top of it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","They must make/cast four rings from gold and fasten them to the legs of the chest. Put two rings on each side of the chest. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","They must make two poles from acacia wood, and they must cover them with gold. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","They must put the poles into the rings on the sides of the chest, so that the chest can be carried by the poles. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","The poles must always be left in the rings; they must not take the poles out of the rings. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Put inside the chest the two stone slabs that I will give you, on which I have written my commandments. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Tell them to make a lid for the chest from pure gold. It will be the place where I will forgive people’s sins. It also is to be ◄45 in./110 cm.► long and ◄27 in./66 cm.► wide. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Tell them to hammer huge lump of gold into the form of two creatures that have wings. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","One of these is to be put at each end of the chest, but the gold from which they are made must be joined to the gold from which the lid is made. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Tell them to place the winged creatures so that their wings touch each other and spread out over the lid. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Put inside the chest the stone slabs that I will give you. Then fasten the lid onto the top of the chest. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","I will set times to talk with you there. From above the lid of the chest, between the two winged creatures, I will tell to you all my laws that you must tell to the Israeli people.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Tell them to make a table from acacia wood. It is to be ◄36 in./88 cm.► long, ◄18 in./66 cm.► wide, and ◄27 in./66 cm.► high. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Tell them to cover it with pure gold and put a gold border around it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Tell them to make a rim all around it, ◄3 in./7.5 cm.► wide, and put a gold border around the rim. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Tell them to make/cast four rings from gold and fasten the rings to the four corners of the table, one ring close to each leg of the table. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","The rings should be fastened to the table near the rim. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Make two poles from acacia wood and cover them with gold. The poles for carrying the table are to be inserted in the rings. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Also tell them to make plates, cups, jars, and bowls to be used when the priests pour out wine to offer to me. They must all be made from pure gold. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","On the table, in front of the chest, there must always be the loaves of sacred bread that the priests have offered to me.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Tell them to make a lampstand from pure gold. They must hammer one large lump of gold to make its base and its shaft. The branches of the lampstand, the cups for holding the oil, the flower buds and the flower petals that decorate the branches of the lamp, the base, and the shaft are all to be hammered from one big lump of gold. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","There are to be six branches on the lampstand, three on each side of the shaft. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Each of the branches is to have on it three gold decorations that will look like almond blossoms. These decorations must also have flower buds and flower petals. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","On the shaft of the lampstand there are to be four gold decorations that also look like almond blossoms, each one with flower buds and petals. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","On each side, there is to be one flower bud beneath each of the branches. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","All these buds and branches, along with the shaft, are to be hammered from one large lump of pure gold. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Also tell them to make seven small cups for holding oil. One is to be put on top of the shaft and the others are to be put on top of the branches. Place these cups so that when the lamps are lit, the light will shine toward the ◄front of the lampstand/entrance►. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Tell them to make tongs from pure gold, to remove the burned wicks and trays in which to put the burned wicks. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Tell them to use ◄75 pounds/35 kg.► of pure gold to make the lampstand and the tongs and the trays. ");
INSERT INTO eng_t4t_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Make sure that they make these things according to the instructions that I am giving you here on this mountain.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Tell the people to make the Sacred Tent using ten long strips of fine linen. They must take blue, purple, and red thread (OR, weave the strips from blue, purple, and red thread), and a skilled craftsman must embroider these strips with designs that represent the winged creatures that are above the chest. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Each strip is to be ◄14 yards/twelve meters► long and ◄2 yards/1.8 meters► wide. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Tell them to sew five strips together to make one set, and sew the other five strips together to make another set. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","For each set, they must make loops of blue cloth and fasten them along the outer edge of the strip, at the end of each set. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","They must put 50 loops on the edge of the first set, and 50 loops on the edge of the second set. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Tell them to make 50 gold clasps/fasteners, to fasten both of the sets together. As a result, the inside of the Sacred Tent will be as though it was one piece. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Also, tell them to make a cover for the Sacred Tent from eleven pieces of cloth made from goats’ hair. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Each piece of cloth is to be ◄15 yards/13.5 meters► long and ◄2 yards/1.8 meters► wide. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Tell them to sew five of these pieces of cloth together to make one set, and sew the other six pieces of cloth together to make another set. They must fold the sixth piece of cloth in half to make it double over the front of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Tell them to make 100 loops of blue cloth, and to fasten 50 of them to the outer edge of the one set and fasten 50 to the outer edge of the other set. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Tell them to make fifty bronze clasps/fasteners and put them in the cloth loops to join the two sets together. As a result, the cover for the Sacred Tent will be as though it was one piece. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Let the extra part of the cover, the part that extends beyond the linen cloth, hang over the back of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","The extra half yard/meter of each cover, the part that extends beyond the linen cloth on each side, must hang over the two sides of the Sacred Tent, to protect the sides. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Tell them to make two more covers for the Sacred Tent. One is to be made from rams’ skins that have been ◄tanned/dyed red►, and the top cover is to be made from goatskin leather.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Tell them to make 48 frames from acacia wood, frames that will be set up from which to hang the Sacred Tent covers. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Each frame is to be ◄five yards/four meters► long and ◄27 in./66 cm.► wide. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","They must make two projections at the bottom of each frame. These will be to fasten the frames to the bases underneath them. They must make these projections at the bottom of each frame. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Make 20 frames for the south side of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Tell them to make 40 silver bases to go underneath them. Two bases will go under each frame. The projections at the bottom of each frame are to be made to fit into the bases. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Similarly, tell them to make twenty frames for the north side of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","They must make 40 silver bases for them also, with two bases to be put under each frame. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","For the rear of the Sacred Tent, on the west side, tell them to make six frames. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Also, tell them to make two extra frames, one for each corner of the rear of the Sacred Tent, to provide extra support. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","The two corner frames must be joined from the bottom to the top (OR, joined at both the bottom and the top). At the top of each of the two corner frames there must be a gold ring for holding the crossbar. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","In that way, for the rear of the Sacred Tent there will be eight frames, and there will be 16 bases, two under each frame. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Tell them to make 15 crossbars from acacia wood. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Five of them will be for the frames on the north side of the Sacred Tent, five will be for the south side, and five for the frames at the rear of the Sacred Tent, the west side. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Tell them to fasten the crossbars on the north, south, and west sides of the Sacred Tent to the middle of the frames. The two long ones must extend from one end of the Sacred Tent to the other, and the crossbar on the west side must extend from one side of the Sacred Tent to the other. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Tell them to cover the frames with gold, and make gold rings to fasten the crossbars to the frames. The crossbars must also be covered with gold. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Erect the Sacred Tent in the way that I have shown you here on this mountain.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Tell them to make a curtain from fine linen. A skilled craftsman must embroider it with blue, purple, and red yarn/thread, making designs to represent the winged creatures that are above the chest. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Tell them to suspend/hang the curtain from four posts made from acacia wood and covered with gold. Set each post in a silver base. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","They must suspend/hang the top of the curtain by hooks that are fastened to the roof of the Sacred Tent. Behind the curtain, in the room called the Very Holy Place, they must put the chest containing the two stone slabs on which I have written my commandments. That curtain will separate the Holy Place from the Very Holy Place. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","On top of the chest in the Very Holy Place they must put the lid which will be the place where blood will be sprinkled to forgive people’s sins. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","In the room that is outside of the Very Holy Place, they must put the table for the sacred bread on the north side, and put the lampstand on the south side. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Tell them to make a curtain to cover the entrance of the Sacred Tent. They must make it from fine linen, and a skilled weaver must embroider it with blue, purple, and red yarn/thread. ");
INSERT INTO eng_t4t_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","To hold up this curtain, they must make five posts from acacia wood. They must cover them with gold, and fasten gold clasps/fasteners to them. Also they must make a bronze base for each of these posts.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Tell them to make an altar from acacia wood. It is to be square, ◄7-1/2 feet/2.2 meters► on each side, and make it ◄4-1/2 feet/1.3 meters► high. ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","They must make a projection that looks like a horn on each of the top corners. The projections must be carved from the same block of wood as the altar. Tell them to cover the whole altar with gold. ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","They must make pans in which to put the greasy ashes from the animal sacrifices. Also they must make shovels for cleaning out the ashes, basins and forks for turning the meat as it cooks, and buckets for carrying hot coals/ashes. All of these things must be made from bronze. ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Also tell them to make a bronze grating to hold the wood and burning coals. They must fasten to each of the corners of the altar a bronze ring for carrying the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","They must put the grating under the rim that is around the altar. They must make it so that it is inside the altar, halfway down. ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","For carrying the altar, they must make poles from acacia wood and cover them with bronze. ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","They must put the poles through the rings on each side of the altar. The poles are for carrying the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","The altar will be like a box, made from boards of acacia wood. They must make it according to these instructions that I am giving you here on this mountain.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Around the Sacred Tent there is to be a courtyard. To form the courtyard, tell them to make curtains of fine linen. On the south side, the curtain is to be ◄50 yards/44 meters► long. ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","To support/hang the curtain, tell them to make twenty bronze posts, and one bronze base for each post. To fasten the curtains to the posts, they must make silver hooks, and metal rods covered with silver to fasten the curtains to the hooks. ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","They must make the same kind of curtains for the north side of the courtyard. ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","On the west side of the courtyard they must make a curtain ◄25 yards/22 meters► long. The curtains are to be supported by ten posts, with a base under each post. ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","On the east side, where the entrance is, the courtyard must also be ◄25 yards/22 meters► wide. ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Tell them to make a curtain ◄22-1/2 feet/6.6 meters► wide for each side of the entrance to the courtyard. ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","They must make a curtain ◄30 feet/9 meters► long for the entrance. A skilled weaver must embroider it with blue, purple, and red yarn/thread. It must be ◄supported by/hung from► four posts, each one with a base under it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","All the posts around the courtyard must be connected with metal rods covered with silver. The clasps/fasteners must be made of silver, and the bases must be made of bronze. ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","The whole courtyard, from the east entrance to the west end, must be ◄50 yards/44 meters► long, and the curtains that enclose it must be ◄7-1/2 feet/2.3 meters► high. All the curtains must be made of fine linen, and all the bases under the posts must be made of bronze. ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","All the things that are not made of gold that are to be used inside the Sacred Tent and in the courtyard, and all the tent pegs to support the Sacred Tent and the curtains, must be made of bronze. ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Command the Israeli people that they must bring to you the best kind of olive oil to burn in the lamps. They must bring this oil to you continually, in order that the lamps can burn continually. ");
INSERT INTO eng_t4t_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","They must put the lampstand outside of the curtain which is in front of the sacred chest which contains the stone slabs on which I have written my commandments. Aaron must take care of the lamps. After he dies, his descendants must do this work. The lamps are to burn every night, from evening until morning. The Israeli people must obey this regulation throughout all future generations.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Summon your older brother Aaron and his sons—Nadab, Abihu, Eleazar, and Ithamar. ◄Set them apart/They are the ones whom I have chosen► from the rest of the Israeli people, in order that they can serve me by being priests. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Tell the people to make beautiful clothes for Aaron, clothes that are suitable for one who has this dignified and sacred work. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Talk to all the skilled workmen, those to whom I have given special ability. Tell them  to make clothes for Aaron, for him to wear when he is ◄set apart/dedicated► to become a priest to serve me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","These are the clothes that they are to make: A sacred pouch for Aaron to wear over his chest, a sacred apron, a robe, an embroidered tunic/gown, a ◄turban/cloth to wrap around his head►, and a sash/waistband. These are the clothes that your older brother Aaron and his sons must wear as they serve me by doing the work that priests do. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","The skilled workmen must use fine linen and blue, purple, and red yarn/thread to make these clothes.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“The skilled workmen must make the sacred apron from fine linen, and skillfully embroider it with blue, purple, and red yarn/thread. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","It must have two shoulder straps, to join the front part to the back part. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","A carefully-woven sash, which must be made from the same materials as the sacred apron, must be sewn onto the sacred apron. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","A skilled workman must take two expensive onyx stones and engrave on them the names of the twelve sons of Jacob. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","He must engrave the names in the order in which Jacob’s sons were born. He must engrave six names on one stone, and the other six names on the other stone. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","A gem-cutter should engrave these names on the stones. Then he should enclose the stones in ◄settings/tiny gold frames►. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Then he should fasten the stones onto the shoulder straps of the sacred apron, to represent the twelve Israeli tribes. In that way, Aaron will carry the names of the tribes on his shoulders in order that I, Yahweh, will never forget my people (OR, in order that he will always remember that those tribes belong to Yahweh). ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","The settings for the stones must be made from gold. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Tell them to make two tiny chains that are braided like cords, and fasten the chains to the settings.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Tell the skilled workman to make a sacred pouch for Aaron to wear over his chest. He will use the things he puts into the pouch to determine my answers to the questions he asks. It must be made of the same materials as the sacred apron, and embroidered in the same way. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","It is to be square, and the material must be folded double, so that it is ◄9 in./22 cm.► on each side. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","The skilled workman must fasten four rows of valuable stones onto the pouch. In the first row he must put a red ruby, a yellow topaz, and a red garnet. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","In the second row he must put a green emerald, a blue sapphire, and a clear/white diamond. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","In the third row he must put a red jacinth, a white agate, and a purple amethyst. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","In the fourth row he must put a yellow beryl, a red carnelian, and a green jasper. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","A gem-cutter should engrave on each of these twelve stones the name of one of the sons of Jacob. These names will represent the twelve Israeli tribes. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","The two chains that are made from pure gold and braided like cords are for attaching the sacred pouch to the sacred apron. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","The workman must make two gold rings, and attach them to the upper corners of the sacred pouch. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","He must make two gold cords, and fasten one end of each cord to one of the rings. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","He must fasten the other end of each cord to the two settings that enclose the stones. In that way, the sacred pouch will be attached to the shoulder straps of the sacred apron. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Then he must make two more gold rings, and attach them to the lower corners of the sacred pouch, on the inside edges, next to the sacred apron. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","He must make two more gold rings, and attach them to the lower part of the front of the shoulder straps, near to where the shoulder straps are joined to the sacred apron, just above the carefully-woven sash/waistband. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","The skilled workman must tie the rings on the sacred pouch to the rings on the sacred apron with a blue cord, so that the sacred pouch is above the sash/waistband and does not come loose from the sacred apron. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","In that way, Aaron will have the names of the twelve Israeli tribes in the sacred pouch close to his chest when he enters the Holy Place. This will remind him that I, Yahweh, will never forget my people (OR, that he represents my people when he talks to me, Yahweh). ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Put into the sacred pouch the two things that the priest will use to determine my answers to the questions he asks. In that way, they will be close to his chest when he enters the Holy Place to talk to me. He will use them to find out what is my will for the Israeli people.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Tell the workmen to use only blue cloth to make the robe that is to be worn underneath the priest’s sacred apron. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","It is to have an opening through which the priest can put his head. They must sew a border around this opening, to keep the material from tearing. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","At the lower edge on the robe, they must fasten decorations that look like pomegranate fruit. They must be woven from blue, purple, and red yarn/thread. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Between each of these decorations, they must fasten a tiny gold bell. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","When Aaron enters the Holy Place in the Sacred Tent to do his work as a priest and when he leaves the Sacred Tent, the bells will ring as he walks. As a result, he will not die because of disobeying my instructions. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Tell them to make a tiny ornament of pure gold, and tell a ◄skilled workman/gem-cutter► to engrave on it the words, ‘Dedicated to Yahweh.’ ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","They should fasten this ornament to the front of the turban by a blue cord. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Aaron must always wear this on his forehead. In that way, Aaron himself will show that he accepts the guilt if the Israeli people offer their sacrifices to me in a way that is not correct, and I, Yahweh, will accept their sacrifices. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Tell them to weave the long-sleeved tunic/gown from fine linen. Also, they must make from fine linen a turban and a sash/waistband, and embroider designs on it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Tell them to make beautiful long-sleeved tunics/gowns, sashes, and caps for Aaron’s sons. Make ones that will be suitable for those who have this dignified work. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Put these clothes on your older brother Aaron and on his sons. Then ◄set them apart/dedicate them► for this work by anointing them with olive oil, in order that they may serve me by being priests. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Also tell them to make linen undershorts for them. The undershorts should extend from their waists to their thighs, in order that no one can see their private parts. ");
INSERT INTO eng_t4t_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaron and his sons must always wear those undershorts when they enter the Sacred Tent or when they come near to the altar to offer sacrifices in the Holy Place. If they do not obey this command, I will cause them to die. Aaron and all his male descendants must obey this rule forever.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“This is what you must do to dedicate Aaron and his sons to serve me by being priests: Select one young bull and two rams that do not have any defects. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Bake three kinds of bread using finely-ground wheat flour, but without yeast: Bake some loaves that do not have any olive oil in them, bake some loaves that have olive oil in the dough, and bake some thin wafers that will be smeared with olive oil after they are baked. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Put them in a basket and offer them to me when you sacrifice the young bull and the two rams. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Take Aaron and his sons to the entrance of the Sacred Tent, and wash them ritually. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Then put the special clothes on Aaron—the long-sleeved tunic/gown, the robe that will be worn underneath the sacred apron, the sacred apron, the sacred pouch, and the sash/waistband. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Place the turban on his head, and fasten to the turban the ornament that has the words ‘Dedicated to Yahweh’ engraved on it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Then take the oil and pour some on his head to ◄dedicate him/set him apart►. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Then bring his sons and put the long-sleeved tunics/gowns on them. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Put the sashes/waistbands around their waists and the caps on their heads. That is the ritual by which you are to ◄dedicate them/set them apart► to be priests. Aaron and his male descendants must serve me by being priests forever. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Then bring the young bull to the entrance of the Sacred Tent. Tell Aaron and his sons to put their hands on the head of the young bull. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Then, while they do that, kill the young bull by slitting its throat, and catch/drain the blood in a bowl. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Take some of that blood with your finger and smear it on the projections of the altar. Throw/Splash the rest of the blood against the base of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Take all the fat that covers the inner organs of the young bull, the best part of the liver, and the two kidneys with the fat on them, and burn all these on the altar as an offering to me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","But the meat of the young bull and its hide and intestines must be burned outside the camp. That will be an offering to forgive the guilt of your sins. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Then select one of the rams, and tell Aaron and his sons to put their hands on the head of the ram. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Then kill the ram by slitting its throat. Catch/Drain some of the blood and splash it against all four sides of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Then cut the ram into pieces. Wash its inner organs and its rear legs and put those with the head ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","and burn those pieces completely on the altar with the rest of the ram. That will be an offering to me, Yahweh, and the smell will please me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Take the other ram that was selected for these rituals, and tell Aaron and his sons to put their hands on the ram’s head. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Then kill the ram by slitting its throat, and drain the blood into a bowl. Smear some of the blood on the lobe of the right ears of Aaron and his sons, and on the thumbs of their right hands, and on the big toes of their right feet. Throw/Splash the rest of the blood against the four sides of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Wipe up some of the blood that is on the altar, mix it with some of the oil for anointing, and sprinkle it on Aaron and his clothes, and on his sons and their clothes. By doing that, you will dedicate them and their clothes to me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Also, cut off the ram’s fat and its fat tail and the fat that covers the inner organs, the best part of the liver, the two kidneys with the fat on them, and the right thigh. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Take also one of each of the kinds of bread that was baked—one made with no oil, one with oil, and one thin wafer. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Put all these things in the hands of Aaron and his sons. Then tell them to lift them up high to dedicate them to me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Then take them from their hands and burn them on the altar, on top of the other things that were placed there. That also will be an offering to me, and its smell will please me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Then take the meat of the ribs of the second ram that was killed, and lift it up high as an offering to me. But then this part of the animal will be for you to eat. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Then take the meat of the ribs, the other thigh of the first ram that was sacrificed to ◄dedicate/set apart► the priests, and the ram whose other parts were lifted high to show that they were an offering to me; and set the meat of the ribs and thigh apart for Aaron and his sons, for them to eat. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","In the future, whenever the Israeli people present to me, Yahweh, offerings to maintain fellowship with me, the ribs and the thigh of animals that they sacrifice will be for Aaron and his male descendants to eat. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“After Aaron dies, the special clothes that he wore will belong to his sons. They are to wear those clothes when they are ◄set apart/dedicated► to become priests. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Aaron’s son who becomes The Supreme Priest and enters the Sacred Tent and performs rituals in the Holy Place must stay in the Sacred Tent, wearing these special clothes, for seven days. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Take the meat of the other ram that was sacrificed to ◄set apart/dedicate► Aaron and his sons, and boil it in the courtyard. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","After it is cooked, Aaron and his sons must eat it, along with the bread that is left in the basket, at the entrance of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","They must eat the meat of the ram that was sacrificed to forgive them for their sins when they were dedicated to do this work. They are the only ones who are permitted to eat this meat. Those who are not priests are not allowed to eat it, because it is dedicated to me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","If any of this meat or some of the bread is not eaten that night, no one is permitted to eat any of it the next day. It must be completely burned, because it is sacred/dedicated to me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Those are the rituals that you(sg) must perform during those seven days when you dedicate Aaron and his sons for this work. You must do everything that I have commanded you. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Each of those seven days you must also sacrifice a young bull as an offering to me, in order that I may forgive sins. Also, you must make another offering ◄to make the altar pure in my sight/in order that I will consider the altar to be pure►. You must also anoint the altar with olive oil, to ◄set it apart/dedicate it►. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Perform these rituals every day for seven days, to ◄set apart/dedicate► the altar and make it pure. If you do not do that, anyone or anything that touches the altar will become taboo. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“You must also sacrifice lambs and burn them on the altar. Each of those seven days you must sacrifice two lambs. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","One lamb must be sacrificed in the morning, and one must be sacrificed in the evening. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","With the first lamb, also offer ◄2 pounds/1 kilogram► of finely-ground wheat flour mixed with one quart/liter of the best kind of olive oil, and one quart/liter of wine as an offering. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","In the evening, when you sacrifice the other lamb, offer the same amounts of flour, olive oil, and wine as you did in the morning. This will be an offering to me, Yahweh, that will be burned, and its smell will please me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","You and your descendants must continue making these offerings to me, Yahweh, throughout all future generations. You must offer them at the entrance of the Sacred Tent. That is where I will meet with you and speak to you. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","That is where I will meet with the Israeli people, and the brilliant light of my presence will cause that place to be holy/sacred. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","I will dedicate the Sacred Tent and the altar. I will also dedicate Aaron and his sons to serve me by being priests. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","I will live among the Israeli people, and I will be their God. ");
INSERT INTO eng_t4t_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","They will know that I, Yahweh their God, am the one who brought them out of Egypt in order that I might live among them.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Tell the skilled workers to make an altar from acacia wood, for burning incense. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","It is to be square, ◄18 in./45 cm.► on each side. It is to be ◄3 feet/90 cm.► high. Tell them to make a projection that looks like a horn on each of the top corners. The projections must be carved from the same block of wood that the altar is made from. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","They must cover the top and the four sides, including the projections, with pure gold. Put a gold border around the altar, near the top. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","They must make two gold rings for carrying the altar. They must attach them to the altar below the border, one on each side of the altar. These rings are for the poles for carrying the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Tell them to make these two poles from acacia wood and cover them with gold. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","They must put this altar outside the curtain that hangs in front of the sacred chest and its lid. That is the place where I will talk with you. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Aaron must burn sweet-smelling incense on this altar. He must burn some every morning when he takes care of the lamps, ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","and he must burn some in the evening when he lights the lamps. The incense must be burned continually, throughout all future generations. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","The priests must not burn on the altar any incense that I have not told you to burn, or burn any animal on it, or any grain offering for me, or pour any wine on it as an offering. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","One time every year Aaron must perform the ritual for making this altar pure. He must do it by putting on its four projections some of the blood from the animal that was sacrificed ◄to remove the guilt of the people’s sins/so that the people would no longer be guilty for sins►. This ritual is to be done by Aaron and his descendants throughout all future generations. This altar must be completely dedicated to me, Yahweh.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“When your leaders ◄take a census of/count► the Israeli people, each man who is counted must pay to me a price to save his life. They must do this in order that no disaster will happen to them while the people are being counted. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Every man who is counted must pay to me ◄0.2 ounces/5.7 grams► of silver. They must use the official standard when they weigh the silver. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","All the men who are at least 20 years old must pay this amount to me when the people are counted. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Rich men must not pay more than this amount, and poor men must not pay less than this amount, when they pay this money to save their lives. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Your leaders must collect this money from the Israeli people and give it to those who will take care of the Sacred Tent. This money is the payment for the lives of those who take care of the Sacred Tent, ◄to enable me not to forget them/and then I will remember to protect them►.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Tell the skilled workers to make a bronze washbasin and a bronze base for it. They must put it between the Sacred Tent and the altar, and fill it with water. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaron and his sons must ritually wash their hands and their feet with this water ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","before they enter the Sacred Tent and before they come to the altar to sacrifice offerings that will be burned on it. If they do that, they will not die because of disobeying my instructions. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","They must wash their hands and their feet, in order that they will not die. They and the males descended from them must obey this ritual throughout all generations.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Tell the people to collect some of the finest spices— ◄12 pounds/6 kg.► of ◄liquid myrrh/sweet-smelling sap named myrrh►, ◄6 pounds/3 kg.► of sweet-smelling cinnamon, ◄6 pounds/3 kg.► of a sweet-smelling cane/reed, ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","and ◄12 pounds/6 kg.► of ◄cassia/a sweet-smelling bark named cassia►. Be sure that they use the official standard when they weigh these things. Tell an expert perfumer to mix these with ◄one gallon/four liters► of olive oil ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","to make sacred oil for anointing. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Use this oil for anointing the Sacred Tent, the sacred chest, ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","the table and all the things that are used with it, the lampstand and all the things that are used to take care of it, the altar for burning incense, ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","and the altar for offering sacrifices that will be burned, along with its bases and the washbasin and all the things that are used with it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Dedicate them by anointing them, in order that they will be completely holy/sacred. Anyone or anything that touches the altar will become taboo. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","And anoint Aaron and his sons. By doing that, you will dedicate them to serve me by being priests. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","And tell the Israeli people, ‘This oil will be my sacred anointing oil that must be used throughout all future generations. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","You must not pour it on the bodies of people who are not priests, and you must not make other oil to be like it by mixing the same amount of those things. This oil is sacred, and you must consider it to be sacred.’ ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","I will consider that anyone who makes ointment like this for any other purpose, and anyone who puts any of this ointment on someone who is not a priest, no longer be allowed to associate with my people.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Yahweh also said to Moses/me, “Tell the people to take equal parts of several sweet spices—stacte, onycha, galbanum, and pure frankincense— ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","and tell an expert perfumer to mix them together to make some perfume. Add some salt to keep it pure and make it holy. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Beat some of it into a fine powder. Then take some of it into the Sacred Tent and sprinkle it in front of the sacred chest. You must all consider this incense to be very holy. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","The people must not mix the same spices to make incense for themselves. This incense must be completely dedicated to me, Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","I will consider that anyone who makes incense like this to use it for perfume will no longer be allowed to associate with my people.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","2","Yahweh also said to Moses/me, “Note that I have chosen Bezalel, the son of Uri and grandson of Hur, from the tribe of Judah, for special tasks. ");
INSERT INTO eng_t4t_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","I have caused him to be completely controlled/empowered by my Spirit, and I have given him special ability to make things and have enabled him to know how to do very skilled work. ");
INSERT INTO eng_t4t_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","He can engrave skillful designs in gold, silver, and bronze. ");
INSERT INTO eng_t4t_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","He can cut ◄jewels/valuable stones► and enclose them in tiny gold settings/frames. He can carve things from wood and do other skilled work. ");
INSERT INTO eng_t4t_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Note that I have also appointed Oholiab, the son of Ahisamach, from the tribe of Dan, to work with him. I have also given special ability to other men, in order that they can make all the things that I have commanded you to be made. ");
INSERT INTO eng_t4t_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","That includes the Sacred Tent, the sacred chest and its lid, all the other things that will be inside the Sacred Tent, ");
INSERT INTO eng_t4t_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","the table and all the things that are used with it, the pure gold lampstand and all the things that are used to take care of it, the altar for burning incense, ");
INSERT INTO eng_t4t_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","the altar for offering sacrifices that will be burned and all the things that will be used with it, the washbasin and its base, ");
INSERT INTO eng_t4t_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","all the beautiful sacred clothes for Aaron and his sons to wear when they work as priests, ");
INSERT INTO eng_t4t_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","the oil for anointing, and the sweet-smelling incense for the Holy Place. The skilled workers must make all these things exactly as I have told you to do.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Tell the Israeli people, ‘Obey my instructions regarding the ◄rest days/Sabbath days►. Those days will remind you and your descendants, throughout all future generations, that I, Yahweh, have ◄set you apart/chosen you► to be my people. ");
INSERT INTO eng_t4t_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","You must obey my rules about the Sabbath days because they are holy/sacred. Those who treat those days in an irreverent way by working on those days must be executed to show that I no longer consider them to belong to my people. ");
INSERT INTO eng_t4t_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","You may work for six days each week, but the seventh day of each week is a solemn day of rest, dedicated to me, Yahweh. Anyone who does any work on a day of rest is to be executed because I no longer want them to be able to associate with my people. ");
INSERT INTO eng_t4t_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","You Israeli people must respect the rest day, and you and your descendants must ◄celebrate it/keep it holy► throughout all future generations. It will remind you of the agreement that I have made with you that will last forever. ");
INSERT INTO eng_t4t_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","It will remind you Israeli people and remind me of that agreement  because I, Yahweh, created the heavens and the earth in six days, and on the seventh day I stopped doing that work and relaxed.’” ");
INSERT INTO eng_t4t_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","When Yahweh finished talking with Moses/me on the top of Sinai Mountain, he gave him/me the two stone slabs on which he had engraved his commandments with his own fingers. ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","◄Moses/I► stayed on top of the mountain a long time. When the people realized that he/I was not returning quickly, they gathered near Aaron and said to him, “We do not know what has happened to that man Moses who brought us here out of Egypt. So quickly, make us ◄an idol/a statue of a god► who will lead us!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron replied to them, “All right, I will do that, but tell your wives and your sons and your daughters to take off all their gold earrings and bring them to me.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","So the people did that. They took off all their gold earrings and brought them to Aaron. ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","He took all those gold earrings and melted them in a fire. He poured the gold into a mold and made a statue that looked like a young bull. The people saw it and said, “This is the god of us Israeli people! This is the one who brought us up from the land of Egypt!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","When Aaron saw what was happening, he built an altar in front of the statue of the young bull. Then he announced, “Tomorrow we will have a festival to honor Yahweh!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","So the people got up early the next morning and brought animals to kill and burn as sacrifices on the altar. They also brought sacrifices to maintain fellowship with Yahweh. Then they sat down to eat and drink wine. Then they got up and started dancing in a very immoral way. ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Then Yahweh said to Moses/me, “Go back down from the mountain, because your people, the ones that you brought up here from Egypt, have already ◄become very depraved/wicked►! ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","They have already ◄left the road that I showed them/stopped obeying me►! They have made a statue of a young bull from melted gold. They have worshiped it and offered sacrifices to it. And they are saying, ‘This is the god of us Israeli people! This is the one who brought us up from Egypt!’” ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Then Yahweh said to Moses/me, “I have seen that these people are very stubborn. ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","I am very angry with them, and so I am going to get rid of them. Do not try to stop me! Then I will cause you and your descendants to become a great nation.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","But Moses/I pleaded with his/my God, Yahweh, and said, “Yahweh, ◄you should not be very angry with your people!/why are you so angry with your people RHQ?► These are the people whom you rescued from Egypt with very great power MTY, DOU! ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Do not do anything that would allow the people of Egypt to say, ‘Their god led them out from our country, but he did that only because he wanted to kill them in the mountains and get rid of them completely RHQ!’ Stop being so angry! ◄Change your mind/Do not do what you have told me that you will do►! Do not do to your people this terrible thing that you have just said that you will do ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Think about your servants Abraham, Isaac, and Jacob. You solemnly promised them, ‘I will enable you to have as many descendants as there are stars in the sky.’ You said to them, ‘I will give to your descendants all the land that I am promising to give them. It will be their land forever.’” ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","So Yahweh changed his mind. He did not do to his people the terrible thing that he said he would do. ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Moses/I turned away from God and went down the mountain, carrying in his hands the two stone slabs on which Yahweh had engraved his commandments. He had written on both sides of the slabs. ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","God himself had made the slabs, and he was the one who had engraved the commandments on them. ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Joshua heard the very loud noise of the people shouting. So when he and I got near the camp, Joshua said, “There is a noise in the camp that sounds like the noise of a battle!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","But Moses/I replied, “No, that is not the shouting that people do when they have won a victory or when they have been defeated in a battle What I hear is the sound of loud singing!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","As soon as Moses/I came close to the camp and saw the statue of the young bull and saw the people dancing, he/I became extremely angry. He/I threw the stone tablets that he/I was carrying down onto the ground, there at the base of the mountain. ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Then he/I took the statue of the young bull that they had made and melted it in the fire. When it cooled, he/I ground it into fine powder. Then he/I mixed the powder with water and forced the Israeli people to drink it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Then he/I said to Aaron, “What did these people do to you, with the result that you have made them commit such a terrible sin?” ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron replied, “Please do not be angry with me, sir. You know that these people are very determined to do evil things. ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","They said to me, ‘As for that man Moses, the one who brought us up here from the land of Egypt, we do not know what has happened to him. So make for us an idol that will lead us!’ ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","So I said to them, ‘Everyone who is wearing gold earrings should take them off.’ So they took them off and gave them to me. I threw them into the fire, and out came this statue of a young bull!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moses/I saw that Aaron had allowed the people to become completely out of control and to do things that would make their enemies think the Israeli people were foolish. ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","So he/I stood at the entrance to the camp and shouted, “Everyone who is loyal to Yahweh should come closer to me!” So the descendants of Levi gathered around him/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Then he/I said to them, “Yahweh, the God of us Israeli people, commands that every one of you should fasten your sword to your side, and then go through the camp from this entrance to the other one, and kill some of your relatives and your companions and your neighbors.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","The descendants of Levi did what Moses/I told them to do, and they killed 3,000 men on that day. ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moses/I said to the descendants of Levi, “Today you have dedicated yourselves to serving Yahweh by ◄killing/not sparing► even your own sons and brothers, and as a result Yahweh will bless you.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","The next day, Moses/I said to the people, “You have committed a terrible sin. But I will now climb up the mountain again to talk with Yahweh. Perhaps I can persuade him to forgive you for sinning like this.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","So Moses/I went back up the mountain and said to Yahweh, “I am sorry to admit that these people have committed a terrible sin. They have made for themselves a gold idol and have worshiped it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","But now I ask you to please forgive them for having sinned. If you will not forgive them, then erase my name from the book in which you have written the names of your people.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","But Yahweh said to Moses/me, “It is only those who have sinned against me whose names I will erase from that book. ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Now you go back down and lead the Israeli people to the place that I told you about. Keep in mind that my angel will go in front of you. But, at the time that I determine, I will punish them for their sin.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Later Yahweh caused a plague to strike the people because they had told Aaron to make the gold statue of a young bull. ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Yahweh said to Moses/me, “Leave this place and go with the people whom you led out of Egypt. Go to the land that I promised Abraham, Isaac, and Jacob that I would give to their descendants. ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","I will send my angel ahead of you all, and I will expel from that land the Canaan, Amor, Heth, Periz, Hiv, and Jebus people-groups. ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","You will go to a land that will be very good for raising livestock and growing crops IDM. But I will not go with you myself, because if I did that, I might get rid of you while you are traveling, because you are very stubborn IDM people.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","5","Yahweh said to Moses/me, “Tell the Israeli people, ‘You are very stubborn IDM. If I would go with you for even a moment, I would completely ◄get rid of you/wipe you out►. Now take off your jewelry to show that you are sorry for having sinned. Then I will decide how I will punish you (OR, if I should punish you).’” So when Moses/I told to the people what God said, they started to mourn, and they all took off their jewelry. ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","After the Israeli people left Sinai Mountain, they did not wear jewelry any more. ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","When the Israeli people traveled, whenever they stopped and set up their tents, Moses/I had them set up a tent outside the camp, far from the camp. I called it ‘the Sacred Tent where God and I talk together’. Everyone who wanted Yahweh to decide something for them would go out of the camp to the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Whenever Moses/I went out to the Sacred Tent, all the people would stand at the entrances of their tents and watch him/me until he/I had entered the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","When Moses/I entered the Sacred Tent, the tall cloud that looked like a fire would come down and stay at the entrance of the Sacred Tent, and then Yahweh would talk with Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","When the people saw the tall cloud at the entrance of the Sacred Tent, they would all prostrate themselves on the ground and worship Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Yahweh would speak to Moses/me directly, like someone speaks to his friend. Then Moses/I would return to the camp. But his/my young helper, Joshua, the son of Nun, stayed in the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moses/I said to Yahweh, “It is true that you have told me, ‘Lead the people to the land that I will show you,’ and you have said that you know me well and that you are pleased with me, but you have not told me whom you will send with me! ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","So now, if you are truly pleased with me, I ask you, tell me the things that you intend/plan to do, in order that I will know you better and continue to please you. Also, do not forget that the Israeli people are the people whom you chose to belong to you.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Yahweh replied, “I will go with you, and I will give you inner peace.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moses/I replied, “If you do not go with me, do not force us to leave this place. ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","The only way that other people will know that you are pleased with me and with your people is if you go with us RHQ! ◄If you go with us, that will show that we are different from all the other people on the earth./If you do not go with us, what will show that we are different from all the other people on the earth?►” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Yahweh replied to Moses/me, “What you have asked is exactly what I will do, because I know you well and I am pleased with you.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Then Moses/I said, “Please let me see your glorious presence!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Yahweh replied, “I will let you see how great and glorious I am, and I will tell you clearly that my name is Yahweh. I will act very kindly and be merciful to all those whom I choose. ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","But you are not allowed to see my face, because anyone who sees my face will ◄die/not continue to stay alive►. ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","But look! Here is a place close to me where you can stand on a large rock. ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","When my glorious presence comes past you, I will put you in a large crevice/opening in the rock, and I will cover your face with my hand until I have passed by. ");
INSERT INTO eng_t4t_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Then I will take my hand away, and you will see my back, but you will not see my face.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Yahweh said to Moses/me, “Cut two slabs of stone that will be like the first slabs, the ones that you broke. Then I will engrave on them the words that were on the first slabs. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Get ready tomorrow morning, and come up to the top of Sinai Mountain again to talk with me there. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Do not allow anyone to come up with you. I do not want anyone else to be anywhere on the mountain. Do not allow any sheep or cattle to graze ◄at the base of/near► the mountain.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","So Moses/I cut two slabs of stone that were like the first ones. He/I arose early the next morning. He/I took the slabs and carried them in his/my hands up to the top of Sinai Mountain, as Yahweh had commanded. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Then Yahweh descended in the tall cloud and stood with Moses/me there. He proclaimed that it was he, Yahweh, who was going to speak to Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Then Yahweh passed in front of him/me and proclaimed, “I am Yahweh God. I always act mercifully and kindly toward people. I do not get angry quickly. I truly love people and I do what I promise to do for them, without changing. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","I love people for thousands of generations. I forgive people for all kinds of sins TRI. But I will certainly punish LIT those who are guilty. I will punish not only them, but I will punish ◄their descendants, down to the third and fourth generation/their children and grandchildren and great-grandchildren►.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moses/I quickly prostrated himself/myself on the ground and worshiped Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","He/I said, “Yahweh, if you are now pleased with me, I ask that you go with us. These people are very stubborn IDM, but forgive us for all our sins DOU, and accept us to be people who belong to you forever.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Yahweh replied, “Note this: I am going to make a solemn agreement with the Israeli people. As they are watching, I will perform great miracles. They will be miracles that no one has ever done on the earth in any nation. All the people who are near you will see the great things that I, Yahweh, will do. I will do awesome things for you all. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","12","Each Israeli person must obey what I am commanding you this day. Do not forget that if you obey me, I will expel the Amor, Canaan, Heth, Periz, Hiv, and Jebus people-groups from the land. But be careful that you do not make any peace agreements with any of the people who live in the land into which you are going, because if you do that, you will begin to do the evil things that they do. It will be like falling into a trap. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","You must tear down their altars, destroy their sacred pillars, and cut down the poles that they use to worship their female goddess Asherah. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","You must worship only me, and not worship any other god, because I, Yahweh, cannot endure any rivals. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Do not make peace agreements with any group that lives in that land. When they worship their gods and offer sacrifices to their gods, and they invite you to join them, do not join them. If you join them, you will eat the food that they sacrifice to their gods, and you will not be faithful to me. You will be like people who commit adultery, who are not being faithful to their spouses MET. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","If you take some of their women to be wives for your sons, and these women worship their own gods, they will persuade your sons also to worship their gods. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Do not pour melted metal into molds to make statues for you to worship. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Each year, during the month of/named Abib, celebrate the Festival of Eating Bread Made Without Yeast. During that festival, for seven days you must not eat bread made with yeast, as I commanded you, because it was in that month that you left Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Your firstborn sons and the firstborn male animals of your cattle and sheep and goats belong to me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","The firstborn of your male donkeys also belong to me. But you may buy them back by offering to me lambs in their place. If you do not do that, you must kill these animals by breaking their necks. You must also buy back your firstborn sons. You must bring an offering to me LIT each time you come to worship me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Each week you may work for six days, but on the seventh day you must rest. Even during the times when you plow the ground and harvest your crops, you must rest on the seventh day. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Each year celebrate the Harvest Festival, when you begin to harvest the first crop of wheat, and also celebrate the Festival of Living in Temporary Shelters, when you finish harvesting the grain and fruit. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Three times each year all the men must come to worship me, Yahweh, the God of the Israeli people. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","I will expel the people-groups that live in the land where you will be, and I will cause your territory to become very large. As a result, no group will try to conquer your country if you come to worship me each year during those three festivals. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","When you sacrifice an animal MTY to me, do not offer with it bread that is made with yeast. And during the Passover Festival, when you sacrifice lambs, do not keep any of the meat until the next morning. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","I am Yahweh God. You must bring to my Sacred Tent the first part of the grain that you harvest each year. When you kill a young animal/kid either a lamb or a calf, do not prepare to eat it by boiling it in its mother’s milk.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Yahweh also said to Moses/me, “Write down the words that I have told you. By giving you these commands, I have made a solemn agreement with you and with the other Israeli people.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moses/I was there on the top of the mountain with Yahweh for 40 days and nights. During that time he/I did not eat or drink anything SYN. He/I engraved on the stone slabs the words of the Ten Commandments, which were part of Yahweh’s solemn agreement. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","When Moses/I came back down the mountain, carrying in his/my hand the two stone slabs on which were written the Ten Commandments, his/my face was shining because he/I had been talking with Yahweh, but he/I did not know that his/my face was shining. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","When Aaron and the other Israeli people saw Moses/me, they were amazed/surprised that his/my face was shining. So they were afraid to come near him/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","But Moses/I called to them. Then Aaron and the other Israeli leaders came to him/me, and he/I talked with them. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Afterwards, all the other Israeli people came near, and he/I told them all the laws that Yahweh had given to him/me on Sinai Mountain. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","When Moses/I finished talking to the people, he/I put a veil over his/my face. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","But whenever Moses/I entered the Sacred Tent to talk with Yahweh, he/I removed the veil. When he/I came back out, he/I would always tell to the Israeli people everything that Yahweh had commanded him/me to tell them. ");
INSERT INTO eng_t4t_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","The Israeli people would see that Moses’/my face was still shining. Then he/I would put the veil back on his/my face again until the next time that he/I went into the Sacred Tent to talk with Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moses/I gathered all the Israeli people together and said to them, “This is what Yahweh has commanded you to do: ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Each week you may work for six days, but on the seventh day you must rest. It is a sacred day, dedicated to Yahweh. Anyone who does any work on the seventh day must be executed. ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Do not even light a fire in your homes on days of rest.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moses/I also said to all the Israeli people, “This is also what Yahweh has commanded: ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Make offerings to Yahweh. Everyone who wants to should bring to Yahweh an offering. These are the things that they may offer: Gold, silver, bronze, ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","fine white linen, blue or purple or red cloth, cloth made from goats’ hair, ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","rams’ skins that are ◄tanned/dyed red►, fine leather made from goatskins, wood from acacia trees, ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","oil for the lamps, spices to put in the olive oil for anointing and in the sweet-smelling incense, ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","valuable onyx stones or other valuable stones to fasten onto the priest’s sacred apron and put on his sacred chest pouch. ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“All the skilled workers among you should come and make all the things that Yahweh has commanded: ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","The Sacred Tent and its covering, its fasteners and its frames, its crossbars, its posts, its bases, ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","the sacred chest with its poles and its lid, the curtain that will separate the Holy Place from the Very Holy Place, ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","the table with the poles for carrying it and all the things that will be used with the table, the sacred bread that will be offered to God, ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","the lampstand for the lamps with all the things that will be used to take care of them, the oil for the lamps, ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","the altar for burning incense, and the poles for carrying that altar, the oil for anointing and the sweet-smelling incense, the curtain for the entrance of the Sacred Tent, ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","the altar for offering sacrifices that will be completely burned and its bronze grating, the poles for carrying that altar and all the things that will be used with it, the washbasin and its base, ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","the curtains to surround the courtyard and the posts and bases for the posts from which to hang the curtains, the curtain for the entrance to the courtyard, ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","the pegs and ropes for the Sacred Tent and for the courtyard, ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","and the beautiful clothes that Aaron and his sons are to wear when they do their work in the Holy Place.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Then all the Israeli people returned to their tents. ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Everyone who wanted to brought an offering to Yahweh. They brought some of the things that would be used to make the Sacred Tent and all the other items that would be used in the rituals, and the materials to make the sacred clothes for the priests. ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","All the men and women who wanted to brought gold ornaments, earrings, rings, necklaces, and many other kinds of things made of gold, and they dedicated them to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","And many HYP people who had blue, purple, or red cloth or fine white linen or cloth made from goats’ hair or rams’ skins that were ◄tanned/dyed red► or leather made from goatskins brought some of these things. ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","All those who had silver or bronze brought them as offerings to Yahweh. All those who had some acacia wood that could be used for any of the work brought it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","All the women who were skilled to make cloth brought fine linen thread and blue, purple, or red yarn/thread that they had made/spun. ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","And all the women who wanted to made/spun thread from goats’ hair. ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","All the leaders brought valuable onyx stones and other valuable stones to be fastened to Aaron’s sacred apron and his sacred chest pouch. ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","They also brought spices to put in the sweet-smelling incense, and they brought olive oil for the lamps and for the oil for anointing and for putting in the sweet-smelling incense. ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","All the Israeli men and women who wanted to brought these things to offer them to Yahweh, for doing the work that he had commanded Moses/me to do. ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Moses/I said to the Israeli people, “Listen carefully. Yahweh has chosen Bezalel, the son of Uri and grandson of Hur, from the tribe of Judah. ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Yahweh has enabled his Spirit to completely control Bezalel and has given him ability and enabled him to know how to do very skilled work. ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","He can engrave skillful designs in gold, silver, and bronze. ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","He can cut ◄jewels/valuable stones► and enclose them in tiny gold frames. He can carve things from wood and do other skilled work. ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Yahweh has also given to him and to Oholiab, the son of Ahisamach, from the tribe of Dan, the ability to teach their skills to others. ");
INSERT INTO eng_t4t_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","He has given to them the ability to do all kinds of work that is done by craftsmen—those who create artistic things, those who make fine white linen, those who embroider designs using blue or purple or red yarn/thread, and those who make other cloth. They are able to do many HYP kinds of skillful work. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Bezalel and Oholiab, and all the other men to whom Yahweh has given ability and enabled them to understand how to do all the work to make the Sacred Tent, must make everything just as Yahweh has commanded.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","So Moses/I summoned Bezalel and Oholiab and all the other skilled men to whom Yahweh had given special ability and who wanted to do some of the work. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Moses/I gave them all the things that the people had brought as offerings to Yahweh for making the Sacred Tent. But the people continued bringing more things every morning. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","As a result, the skilled men who were doing various things to make the Sacred Tent came to Moses/me ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","and said, “The people are bringing more than we need to do the work that Yahweh has commanded us!” ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","So Moses/I gave the skilled men this message that was proclaimed throughout the camp: “No one should bring anything more as an offering to make the Sacred Tent!” When the people heard that, they did not bring anything more. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","What they had already brought was enough to do all the work. In fact, it was more than was needed! ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","All the most skilled men among the workmen made the Sacred Tent. They made it from ten strips of fine linen, and carefully embroidered it using blue, purple, and red yarn/thread to make figures that resembled the winged creatures. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Each strip was ◄14 yards/twelve meters► long and ◄2 yards/1.8 meters► wide. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","They sewed five strips together to make one set, and they sewed the other five strips together to make the other set. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","For each set, they made loops of blue cloth and fastened them on the outer edge of the strip, at the end of each set. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","They put 50 loops on the edge of the first set, and 50 loops on the edge of the second set. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","They made 50 gold clasps/fasteners, to fasten both of the sets together. In that way, the inside of the Sacred Tent was as though it was one piece. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","They made a cover for the Sacred Tent from eleven pieces of cloth made from goats’ hair. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Each piece of cloth was ◄15 yards/13.5 meters► long and ◄2 yards/1.8 meters► wide. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","They sewed five of these pieces of cloth together to make one set, and they sewed the other six pieces of cloth together to make another set. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","They made 100 loops of blue cloth. They fastened 50 of them to the outer edge of the one set and they fastened 50 to the outer edge of the other set. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","They made 50 bronze clasps/fasteners and joined the two sets together with them. In that way it formed one cover. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","They made two more covers for the Sacred Tent. They made one from rams’ skins that had been ◄tanned/dyed red►, and they made the top cover from goatskin leather. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","They made 48 frames from acacia wood and set them up to support the covers for the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Each frame was ◄15 feet/4.5 meters► long and ◄27 in./66 cm.► wide. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","They made two projections at the bottom of each frame. These were for fastening the frames to the bases underneath them. Each frame had these projections. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","The skilled workmen made twenty frames for the south side of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","They made 40 silver bases to go underneath them. Two bases went under each frame. The projections on each frame fit into these bases. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Similarly, they made 20 frames for the north side of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","They made 40 silver bases for them also, with two bases for under each frame. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","For the rear of the Sacred Tent, on the west side, they made six frames. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","They also made two extra frames, one for each corner of the rear of the Sacred Tent, to provide extra support. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","The two corner frames were joined from the bottom to the top (OR, joined at both the bottom and the top). At the top of each of the two corner frames they fastened a gold ring for holding the crossbar. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","In that way, for the rear of the Sacred Tent there were eight frames, and there were 16 bases, two bases under each frame. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","The workmen made 15 crossbars from acacia wood. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Five of them were for the frames on the north side of the Sacred Tent, five for the south side, and five for the frames at the rear of the Sacred Tent, the west side. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","The crossbars on the north, south, and west sides of the Sacred Tent were fastened to the middle of the frames. The two long crossbars extended from one end of the Sacred Tent to the other, and the crossbar on the west side extended from one side of the Sacred Tent to the other side. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","The workmen covered the frames with gold and fastened gold rings to the poles. The crossbars were put into the rings. The crossbars were also covered with gold. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","They made a curtain from fine white linen. Skilled craftsmen embroidered it with blue, purple, and red yarn/thread, making designs that resembled the winged creatures. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","They suspended/hung the curtain from four posts that were made from acacia wood and covered with gold. They set each post in a silver base. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","They made a curtain to cover the entrance of the Sacred Tent. They made it from fine linen, and a skilled weaver embroidered it with blue, purple, and red yarn/thread. ");
INSERT INTO eng_t4t_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","To support this curtain, they also made five posts from acacia wood and fastened gold clasps/fasteners to them. They completely covered the posts with gold. They also made a bronze base for each of those posts. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Then Bezalel made the sacred chest from acacia wood. It was ◄45 in./110 cm.► long, ◄27 in./66 cm.► wide, and ◄27 in./66 cm.► high. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","He covered it with pure gold inside and outside the chest, and he made a gold border around the top of it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","He made/cast four rings from gold and fastened them to the legs of the chest. He put two rings on each side of the chest. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","He made two poles from acacia wood, and covered them with gold. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","He put the poles into the rings on the sides of the chest, in order that the chest could be carried by means of the poles. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","He made a lid for the chest. That was the place where Yahweh would forgive people’s sins. It also was ◄45 in./110 cm.► long and ◄27 in./66 cm.► wide. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","He made two winged creatures from hammered gold. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","One of these was put at each end of the chest. The gold with which they were made was joined to the gold from which the lid was made. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","He placed the winged creatures facing each other so that their wings touched each other and spread out over the lid. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Bezalel made a table from acacia wood. It was ◄36 in./88 cm.► long, ◄18 in./44 cm.► wide, and ◄27 in./66 cm.► high. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","He covered it with pure gold, and he put a gold border around it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","He made a rim all around it, ◄3 in./7 cm.► wide. He put a gold border around the rim. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","He made/cast four rings from gold and fastened the rings to the four corners of the table, one ring close to each leg of the table. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","The rings were fastened to the table near the rim. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","He made two poles from acacia wood and covered them with gold. These poles for carrying the table were then inserted into the rings. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","He also made from pure gold all the things to be put on the table. He made the plates, the cups, and the jars and bowls to be used when the priests poured out wine as an offering to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","He made the lampstand from pure gold. Its base and its shaft were hammered from one large lump of gold. The branches of the lampstand, the cups for holding the oil, the flower buds and the petals that decorated the branches of the lamp, the base, and the shaft were all hammered from one big lump of gold. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","There were six branches on the lampstand, three on each side of the shaft. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Each of the branches had on it three gold decorations that looked like almond blossoms. These decorations also had flower buds and flower petals. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","On the shaft of the lampstand there were four gold decorations that also looked like almond blossoms, each one with flower buds and flower petals. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","On each side, beneath and extending from each of the branches, there was one flower bud. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","All these flower buds and branches, along with the shaft, were hammered from one large lump of pure gold. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Bezalel also made seven small cups for holding oil. He put one cup on top of the shaft and he put the others on top of the branches. He made from pure gold the tongs for removing the burned wicks and the trays in which to put the burned wicks. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","He used ◄75 pounds/35 kg.► of pure gold to make the lampstand and all the things that were used to take care of it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","From acacia wood, Bezalel made the altar for burning incense. It was square, ◄18 in./45 cm.► on each side. It was ◄3 ft./90 cm.► high. He made a projection that looked like a horn on each of the top corners. The projections were carved from the same block of wood that the altar was made of. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","He covered the top and the four sides, including the projections, with pure gold. He put a gold border around the altar, near the top. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","He made two gold rings for carrying the altar. Then he attached them to the altar below the border, one on each side of the altar. The poles by means of which the altar was to be carried were to be inserted into those rings. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","He made those two poles from acacia wood and covered them with gold. ");
INSERT INTO eng_t4t_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","He also made the sacred oil for anointing and the pure sweet-smelling incense. He mixed the incense together as a skilled perfumer would. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Several men helped Bezalel to make the altar for burning sacrifices. They made it from acacia wood. It was square, ◄7-1/2 feet/2.2 meters► on each side, and it was ◄4-1/2 feet/1.3 meters► high. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","They made a projection that looked like a horn on each of the top corners. The projections were carved from the same block of wood that the altar was made of. They covered the whole altar with bronze. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","They made the pans in which to put the greasy ashes from the animal sacrifices. They also made the shovels for cleaning out the ashes. They made the basins and forks for turning the meat as it cooked, and buckets for carrying hot coals/ashes. All of those things were made from bronze. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","They also made a bronze grating to hold the wood and burning coals. They put the grating under the rim that went around the altar. They made it so that it was inside the altar, halfway down. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","They made bronze rings in which to put the poles for carrying the altar, and fastened one of them to each of the corners of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","They made the poles from acacia wood and covered them with bronze. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","They put the poles through the rings on each side of the altar. The poles were for carrying the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","The altar was hollow like an empty box. It was made from boards of acacia wood. They made/cast the washbasin and its base from bronze. The bronze was from the mirrors that belonged to the women who worked at the entrance of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Around the Sacred Tent Bezalel and his helpers made a courtyard. To form the courtyard, they made curtains of fine white linen. On the south side, the curtain was ◄150 feet/46 meters► long. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","To hang the curtain, they made 20 bronze posts and 20 bronze bases, one for under each post. To fasten the curtains to the posts, they made silver hooks, and they made metal rods covered with silver. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","They made the same kind of curtains, posts, bases, and hooks for the north side of the courtyard. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","On the west side of the courtyard, they made a curtain ◄75 feet/23 meters► long. They also made ten posts on which to hang the curtains, and ten bases, with silver hooks and metal rods covered with silver. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","On the east side, where the entrance is, the courtyard was ◄75 feet/23 meters► wide. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","On each side of the entrance, they made a curtain ◄22-1/2 feet/6.6 meters► wide. On each side they were hung from three posts, and one base was under each post. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","All the curtains around the courtyard were made from fine white linen. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","All the posts around the courtyard were made of bronze, but the tops were covered with silver. The posts were connected with metal rods covered with silver. The clasps/fasteners and hooks were made of silver. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","For the entrance of the courtyard, they made a curtain from fine white linen, and a skilled weaver embroidered it with blue, purple, and red yarn/thread. The curtain was ◄30 feet/9 meters► long and ◄7-1/2 feet/2.3 meters► high, just like the other curtains around the courtyard. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","All the curtains were made of fine white linen. They were supported by four posts, and under each post was a base made of bronze. All the posts around the courtyard were connected with metal rods covered with silver. The clasps/fasteners were made of silver, and the tops of the posts were covered with silver. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","All the tent pegs to support the Sacred Tent and the curtains around the courtyard were made of bronze. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Here is a list of the amounts of metal used to make the Sacred Tent. Moses/I told some men from the tribe of Levi to count all the materials used and write down the amounts. Ithamar, the son of Aaron the priest, supervised those men. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezalel the son of Uri and grandson of Hur made all the things that Yahweh commanded Moses/me to be made. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Bezalel’s helper was Oholiab, the son of Ahisamach, of the tribe of Dan. Oholiab was a skilled engraver who made artistic things. He made fine white linen, and he embroidered designs using blue, purple, and red yarn/thread. He also made other cloth. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","All the gold that was used to make the Sacred Tent weighed ◄2,195 pounds/1,000 kg.►. They used the official standard when they weighed the gold. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","All the silver that the people contributed when the leaders ◄took the census/counted the men► weighed ◄7,500 pounds/3,400 kg.►. They also used the official standard when they weighed the silver. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","All the men who were at least 20 years old were counted, and they each paid the required amount. That was a total of 603,550 men. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","They used ◄75 pounds/34 kg.► of silver for making/casting each of the 100 bases to put under the posts to support the curtains of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Bezalel and his helpers used the ◄50 pounds/30 kg.► of silver that was not used for the bases to make the rods and the hooks for the posts, and to cover the tops of the posts. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","The bronze that the people contributed weighed ◄5,310 pounds/2,425 kg.►. ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","With the bronze, Bezalel and his helpers made the bases for under the posts at the entrance of the Sacred Tent. They also made the altar for burning sacrifices, the grating for it and the tools used with it, ");
INSERT INTO eng_t4t_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","the bases for the posts that supported the curtains that surrounded the courtyard and the bases for the entrance to the courtyard, and the pegs for the Sacred Tent and for the curtains around the courtyard. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Bezalel, Oholiab, and the other skilled workmen made the beautiful clothes for Aaron to wear while he did his work as a priest in the Holy Place. They made them from blue, purple, and red cloth, just as Yahweh had commanded Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","They made the sacred apron from fine white linen and from blue, purple, and red cloth. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","They hammered some thin sheets of gold and cut them into thin strips which they embroidered into the fine linen and into the blue, purple, and red cloth. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","The apron had two shoulder straps, to join the front part to the back part at the shoulders. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","A carefully-woven sash, which was made from the same materials as the sacred apron, was sewn onto the sacred apron. This was made exactly as Yahweh had commanded Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","They cut two valuable onyx stones and enclosed them in a tiny gold frame, and a skilled gem-cutter engraved on the stones the names of the twelve sons of Jacob. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","They fastened the stones to the shoulder straps of the sacred apron, to represent the twelve Israeli tribes, exactly as Yahweh had commanded Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","They made the sacred chest pouch. They made it of the same materials as the sacred apron and embroidered it in the same way. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","It was square, and the material was folded double, so that it was ◄9 in./22 cm.► long and ◄9 in./22 cm.► wide. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","They fastened four rows of valuable stones onto the pouch. In the first row, they put a red ruby, a yellow topaz, and a red garnet. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","In the second row, they put a green emerald, a blue sapphire, and a clear/white diamond. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","In the third row they put a red jacinth, a white agate, and a purple amethyst. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","In the fourth row, they put a yellow beryl, a red carnelian, and a green jasper. They set each of the stones in tiny gold frames. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","On each of the twelve stones they engraved the name of one of the sons of Jacob, to represent one of the twelve Israeli tribes. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","They made two chains from pure gold and braided them like cords, to attach the sacred pouch to the sacred apron. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","They made two gold rings, and they attached them to the upper corners of the sacred pouch. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","They fastened one end of each cord to one of the rings. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","They fastened the other end of each cord to the two ◄settings/tiny frames► that enclosed the stones. Then they attached the sacred pouch to the shoulder straps of the sacred apron. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Then they made two more gold rings and attached them to the lower corners of the sacred pouch, on the inside edges, next to the sacred apron. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","They made two more gold rings and attached them to the lower part of the front of the shoulder straps, near to where the shoulder straps were joined to the sacred apron, just above the carefully-woven sash/waistband. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","They tied the rings on the sacred pouch to the rings on the sacred apron with a blue cord, so that the sacred pouch was above the sash/waistband and would not come loose from the sacred apron. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","They made the robe that is to be worn underneath the priest’s sacred apron, using only blue cloth. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","It had an opening through which the priest would put his head. They sewed a border around this opening, to prevent the material from tearing. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","At the lower edge on the robe, they fastened decorations that resembled pomegranate fruit. The decorations were woven from blue, purple, and red yarn/thread. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Between each of these decorations, they fastened a tiny bell made from pure gold, so there was a bell and a pomegranate, a bell and a pomegranate, alternating all around the hem of the robe ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","for Aaron to wear while he did his work as a priest. They made all these things exactly as Yahweh had commanded Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","They wove long-sleeved tunics/gowns from fine white linen, for Aaron and his sons. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","They also made a turban of fine linen for Aaron to wear around his head. They made the caps and the undershorts for Aaron’s sons from fine linen. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","They made the embroidered sash/waistband for Aaron from fine linen and from blue, purple, and red cloth, and they embroidered designs on it using blue, purple, and red yarn/thread, exactly as Yahweh had commanded Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","They also made the tiny ornament of pure gold and had a skilled workman engrave on it the words, ‘Dedicated to Yahweh’. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","They fastened this to the front of the turban by a blue cord, just as Yahweh had commanded Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Finally they finished all the work to make the Sacred Tent. They brought to Moses/me all the things that they had made. They had made them exactly as Yahweh had commanded me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","They brought to him/me the Sacred Tent and all the things that were used with it: the hooks, the frames, the crossbars, the posts and their bases, ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","the coverings for the Sacred Tent that were made of tanned/dyed rams’ skins and goatskins, the curtains, ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","the sacred chest that contained the stone slabs on which the commandments were written, the poles, the lid for the chest, ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","the table with all the things that were used with it, the sacred bread that was offered to God, ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","the lampstand made of pure gold and all its lamps and all the things that were to be used to take care of it, the oil for the lamps, ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","the golden altar for burning incense, the oil for anointing, the sweet-smelling incense, the curtain for the entrance to the Sacred Tent, ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","the bronze altar for burning sacrifices and its bronze grating, the poles for carrying it, and all the other things that were used with it, the washbasin and its base, ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","the curtains that surrounded the courtyard, the posts and bases that supported them, the curtain for the entrance to the courtyard and its ropes, the tent pegs, and all the other things that would be used in the Sacred Tent, ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","the beautiful sacred clothes for Aaron to wear when he did his work in the Holy Place, and the special clothes for his sons to wear as they did their work as priests. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","The Israeli people had done all this work exactly as Yahweh had commanded Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Then Moses/I saw all the work that they had done. Truly, they had done everything exactly as Yahweh had commanded that it should be done. Then Moses/I asked God to bless them. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Then Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“On the first day of the first month next year, tell the people to set up the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Put inside it the sacred chest that contains the stone slabs on which are engraved the Ten Commandments, and hang the curtain in front of it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Bring the table into the Sacred Tent, and place on it all the things that are to be used with it. Bring in the lampstand and fasten the lamps to it. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Put the gold altar for burning incense in front of the sacred chest, and set up the curtain at the entrance of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Put the altar for burning sacrifices in front of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Put the washbasin between the Sacred Tent and the altar, and fill it with water. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Hang the curtains that will surround the courtyard, and hang the curtain at its entrance. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Then take the oil for anointing, and anoint the Sacred Tent and everything that is in it, to ◄set it apart/dedicate it► to me. Then it will be holy/sacred. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Also anoint the altar for offering sacrifices that will be completely burned, and all the things that will be used with it, and set it apart. Then it also will be holy/sacred. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Also anoint the washbasin and its base, to set it apart. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Then bring Aaron and his sons to the entrance of the Sacred Tent, and wash them ritually with water. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Then put on Aaron his sacred clothes to ◄set him apart/dedicate him►, in order that he can serve me as a priest. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Also bring his sons there. Put their sacred tunics/gowns on them ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","and anoint them just as you anointed their father, in order that they also may serve me by working as priests. By anointing them and their descendants, you will cause them and their descendants to be priests throughout all coming generations.” ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moses/I did all these things exactly as Yahweh had commanded him/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","On the first day of the first month of the next year (OR, second year after they/we left Egypt), the people set up the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Following Moses’/my instructions, they set up the Sacred Tent and its bases, set up the frames, attached the crossbars, and put up the posts for the curtains. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Then they spread out the coverings over the Sacred Tent, exactly as Yahweh had commanded. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Then he/I took the two stone slabs on which the commandments were written and put them in the sacred chest. He/I put the carrying poles in the rings on the chest and put the lid on top of the chest. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Then he/I took the chest into the Very Holy Place inside the Sacred Tent and hung the curtain. In that way, he/I prevented the people who were outside from seeing the chest. He/I did all this exactly as Yahweh had commanded him/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","He/I set the table inside the Sacred Tent, on the north side, outside the curtain. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","He/I placed on the table the bread that was offered to Yahweh, exactly as Yahweh had commanded. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","He/I set the lampstand inside the Sacred Tent, on the south side, opposite the table. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Then he/I fastened the lamps to the lampstand in Yahweh’s presence, exactly as Yahweh had commanded. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","He/I set the golden altar for burning incense inside the Sacred Tent, in front of the curtain that separated the Holy Place from the Very Holy Place, ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","and he/I burned some sweet-smelling incense on it, exactly as Yahweh had commanded him/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","He/I hung the curtain at the entrance to the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","At the entrance to the Sacred Tent, he/I set the altar for offering sacrifices that were to be burned completely. Then he/I offered on it the meat that was to be burned completely and the grain offering, exactly as Yahweh had commanded him/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","He/I set the washbasin between the Sacred Tent and the bronze altar, and he/I filled the washbasin with water. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","32","Every time Moses/I and Aaron and his sons went into the Sacred Tent or went to the altar, they/we washed their/our hands and feet ritually, exactly as Yahweh had commanded Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Following Moses’/my instructions, they hung the curtains that surrounded the courtyard and the altar, and they hung the curtain at the entrance to the courtyard. So Moses/I finished that work. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Then the tall bright cloud covered the Sacred Tent, and Yahweh’s ◄glory/brilliant light► filled the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Because that light was very bright, Moses/I was not able to enter the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","From that day, whenever the Israeli people wanted to move to another place, they went only when the bright cloud rose from above the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","If the cloud did not rise, they stayed where they were and did not go on until the cloud rose. ");
INSERT INTO eng_t4t_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Wherever they traveled, the bright cloud that indicated Yahweh’s presence was above the Sacred Tent during the day, and a bright fire was inside the cloud at night, with the result that all the Israeli people MTY could see it at any time. ");
INSERT INTO eng_t4t_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","While Moses/I was standing near the entrance to the Sacred Tent, Yahweh called to him/me from inside the tent. He said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Tell this to the Israeli people: ‘When any of you brings an offering to Yahweh, bring one of your sheep or goats or cattle. ");
INSERT INTO eng_t4t_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","‘If what you are offering is a bull that will be completely burned on the altar, it must not have any defects. You must take it to the entrance to the Sacred Tent, in order that it will be acceptable to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","You must lay your hands on the head of the bull. When you do that, Yahweh will accept its death in your place to forgive/pardon you for the sins that you have committed. ");
INSERT INTO eng_t4t_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","You must slaughter the bull in front of Yahweh. Then Aaron’s sons, who are priests, will bring the blood and sprinkle it against all sides of the altar near the entrance to the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","You must remove the skin of the animal and cut the animal into pieces. You must wash the inner parts and the legs of the bull. ");
INSERT INTO eng_t4t_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Then Aaron’s sons will put wood on the altar and light a fire. ");
INSERT INTO eng_t4t_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Then they will arrange the pieces, including the head and the fat, on the burning wood. ");
INSERT INTO eng_t4t_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Then one of the priests will completely burn all of it on the altar. And the aroma will be pleasing to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","‘If you are offering a sheep or a goat, it must be a male without any defect. ");
INSERT INTO eng_t4t_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","You must slaughter it in front of Yahweh, on the north side of the altar, and drain all the blood into a bowl. Then Aaron’s sons will sprinkle the blood against all sides of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","You must cut the animal into pieces. You must wash the inner parts and the legs of the animal. Then the priests will arrange the pieces, including the head and the fat, on the burning wood. ");
INSERT INTO eng_t4t_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Then one of the priests will take all of it and completely burn all of it on the altar. And the aroma as it burns will be pleasing to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","‘If what you are offering to Yahweh is a bird, you must offer a dove or a young pigeon. ");
INSERT INTO eng_t4t_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","The priest will take it to the altar and wring/twist off its head. Then he will burn the head on the altar. He will drain out the bird’s blood onto the side of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Then he will remove the bird’s ◄craw/food-grinding pouch► and what is inside it, and throw it on the east side of the altar, where the ashes are thrown. ");
INSERT INTO eng_t4t_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Then he will grasp the bird’s wings and partially tear the bird open. Then he will burn it completely in the fire on the altar. And the aroma will be pleasing to Yahweh.’ ");
INSERT INTO eng_t4t_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","‘If you bring to Yahweh an offering of grain, it must consist of finely-ground flour. You must pour olive oil on it, and put some incense on it, ");
INSERT INTO eng_t4t_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","and take it to one of the priests. The priest will take a handful of the flour and the oil with the incense and burn it on the altar. That part will symbolize that all of the offering truly belongs to Yahweh. And the aroma will be pleasing to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","The part of that offering that is not burned will belong to Aaron and his sons. It is a very holy part of the offerings that are given to Yahweh by burning them in a fire. ");
INSERT INTO eng_t4t_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","‘If you bring an offering that is made from grain, something that is baked in an oven, it must be made from finely-ground flour. You may bring loaves made from flour mixed with olive oil but without yeast, or you may bring wafers with olive oil smeared on them, but also made without yeast. ");
INSERT INTO eng_t4t_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","If your offering is cooked ◄on a griddle/in a shallow pan►, it must be made from finely-ground flour mixed with olive oil and without yeast. ");
INSERT INTO eng_t4t_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","You must crumble it and pour olive oil on it. That will be your offering made from grain. ");
INSERT INTO eng_t4t_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","If your offering that is made from grain is cooked in a pan, it must be made of finely-ground flour mixed with olive oil. ");
INSERT INTO eng_t4t_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Bring to Yahweh your grain offering. Give it to the priest, and he will take it to the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","He will take a part of it that will symbolize that all the offering belongs to Yahweh. He will burn that part on the altar, and the aroma as it burns will be pleasing to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","The part that is not burned will belong to Aaron and his sons. It is a very holy part of the offerings given to Yahweh by burning them in a fire. ");
INSERT INTO eng_t4t_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","‘Every offering that is made from grain and that you bring to Yahweh must be made without yeast, because you must not put any yeast or honey in any offering to Yahweh that is burned on the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","You may bring to Yahweh an offering of the first part of your harvest, but that is not to be burned on the altar to produce an aroma that will be pleasing to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Put salt on all your offerings that are made from grain. The salt represents the agreement that your God made with you, so be sure that you do not forget to put salt on those offerings. ");
INSERT INTO eng_t4t_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","‘If you bring to Yahweh an offering of the first part of your harvest of grain, offer some new grain that has been crushed and roasted in a fire. ");
INSERT INTO eng_t4t_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Put olive oil and incense on it, and that will be your offering made from grain. ");
INSERT INTO eng_t4t_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","The priest will take a part of the flour and oil along with the incense. That will symbolize that all the offering truly belongs to Yahweh. He will burn that part on the altar, to be an offering given to Yahweh by burning it in a fire.’ ” ");
INSERT INTO eng_t4t_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“Also tell the people, ‘When the offering that you bring to Yahweh is to maintain good fellowship with him, you may bring a bull or a cow from your herd of cattle, but what you present to Yahweh must be an animal that has no defects. ");
INSERT INTO eng_t4t_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","You must bring the animal to the entrance to the Sacred Tent. You must lay your hands on its head. Then you must slaughter it and drain some of its blood in a bowl. Then one of Aaron’s sons, one of the priests, will sprinkle the blood against all sides of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","From that offering, you must offer to Yahweh, as a sacrifice that will be burned in the fire, all the fat that covers the inner parts of the animal, or which is attached to them— ");
INSERT INTO eng_t4t_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","the kidneys and the fat that is attached to them near the lower back muscle, and the fat that covers the liver. ");
INSERT INTO eng_t4t_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Then one of the priests will burn those things on the altar, along with the other parts of the animal that will be completely burned to be an offering to Yahweh. And the aroma while it burns will be pleasing to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","If that offering to maintain good fellowship with Yahweh is a sheep or a goat, it must also be an animal that has no defects. ");
INSERT INTO eng_t4t_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","If you offer a lamb, you must present it to Yahweh at the entrance to the Sacred Tent. You must lay your hands on the lamb’s head and then slaughter it. ‘You must drain some of its blood in a bowl. ");
INSERT INTO eng_t4t_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Then one of the priests will sprinkle that blood against all sides of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","You must dedicate these things to be a sacrifice to Yahweh that is burned: Its fat, the fat tail that you must cut off close to the backbone, and all the fat that covers the inner parts of the lamb or which is attached to them— ");
INSERT INTO eng_t4t_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","the kidneys with the fat that is on them near the lower back muscle, and the fat that covers the liver. ");
INSERT INTO eng_t4t_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","One of the priests will burn those things on the altar to be an offering to Yahweh; it will be as though they will be a special food given to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","‘If your offering is a goat, you must take/present it to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","You must lay your hands on its head. Then you must slaughter it in front of the Sacred Tent. Then one of Aaron’s sons will sprinkle the blood against all sides of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","From that offering you must dedicate these things to be a sacrifice to Yahweh that is burned: All the fat that covers the inner parts of the animal or which is attached to them, ");
INSERT INTO eng_t4t_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","the kidneys with the fat that is on them near the lower back muscle, and the fat that covers the liver. ");
INSERT INTO eng_t4t_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","The priest will burn those things on the altar to be an offering to Yahweh; it will be as though they will be a special food given to Yahweh. And the aroma while it burns will be pleasing to Yahweh. All the fat of the animals that are sacrificed belongs to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","‘This is a command that must be obeyed by you and your descendants forever, wherever you live: You must not eat the fat or the blood of any animal.’ ” ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Then Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Say this to the Israeli people: This is what must be done if someone sins without intending to sin, doing something that is forbidden in any of Yahweh’s commands. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","'If the Supreme MTY Priest sins, and that causes all the people to be guilty, he must bring to Yahweh a young bull that has no defects. That will be an offering for the sin that he has committed. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","He must bring the bull to the entrance to the Sacred Tent. He must lay his hands on its head. Then he must slaughter it in front of Yahweh and drain some of the blood into a bowl. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Then the Supreme Priest must take some of that blood into the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","He must dip one of his fingers into the blood and sprinkle it seven times in the presence of Yahweh, in front of the curtain that separates the Holy Place from the Very Holy Place. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Then he must put some of the blood on the projections at the corners of the altar where fragrant incense is burned in the Sacred Tent in the presence of Yahweh. The remaining part of the bull’s blood that is still in the bowl, he must pour out at the base of the altar, where sacrifices are burned, at the entrance to the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","From that offering the Supreme Priest must separate these things from the bull that is to be burned: The fat that covers the inner parts of the bull or which is attached to them— ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","the kidneys and the fat that is attached to them near the lower back muscle, and the fat that covers the liver. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Then the Supreme Priest must completely burn those things on the altar. That will be just like when the fat is removed from an animal that is sacrificed to maintain good fellowship with Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","But all the other parts of the animal—its skin/hide and all its other meat, its head and its legs, its inner parts and the intestines, ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","he must take outside the camp and throw them in a place that is acceptable to Yahweh, where the ashes are thrown, and he must burn them in a fire on the pile of ashes. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","‘If all the Israeli people sin without intending to sin, doing something that is forbidden in any of Yahweh’s commands, they will be guilty, even if they do not realize that they have sinned. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","When they realize that they have committed a sin, together they must bring a young bull to be an offering for their sin, to the front of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","The elders must lay their hands on the bull’s head in the presence of Yahweh and slaughter it and catch some of the blood in a bowl. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Then the Supreme MTY Priest must take some of that blood into the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","‘He must dip one of his fingers into the blood and sprinkle it seven times in the presence of Yahweh, in front of the curtain that separates the Holy Place from the Very Holy Place. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Then he must put some of the blood on the projections at the corners of the altar that is in the presence of Yahweh in the Sacred Tent. The remaining part of the bull’s blood, he must pour out at the base of the altar where sacrifices are burned, at the entrance of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","He must remove all the animal’s fat and burn it on the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","He must do with this bull the same things that he did with the bull that was an offering for his own sins, and they will be forgiven {Yahweh will forgive them}. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Then the priest must take the other parts of the bull outside the camp and burn them, like he does when he himself has sinned. That will be the offering for the sin that all the people have committed, and they will be forgiven. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","‘When one of the leaders sins without intending to sin, doing something that is forbidden in any of the commands of Yahweh his God, he will be guilty. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","When he realizes that he has committed a sin, he must bring as his offering a male goat that has no defects. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","He must lay his hands on the goat’s head in the presence of Yahweh and slaughter it at the place where they slaughter {are slaughtered} the animals that will be completely burned on the altar. That will be an offering for his sin. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Then the priest must put some of the animal’s blood into a bowl and dip one of his fingers in it and put some of the blood on the corners of the projections of the altar. Then he must pour out the rest of the blood at the base of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Then he must burn all the fat on the altar, as was done with the fat of the offering to maintain good fellowship with Yahweh. As a result of the priest’s doing that, the leader will no longer be guilty for his sin and he will be forgiven. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","‘If one of the Israeli people who is not a priest sins without intending to sin, and does something that is forbidden in any of the commands of Yahweh his God, he will be guilty. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","When he realizes that he has committed a sin, he must bring as his offering a female goat that has no defects. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","He must lay his hands on the goat’s head and slaughter it at the place where they slaughter the animals that will be completely burned on the altar, and catch some of the blood in a bowl. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Then the priest must dip one of his fingers in the blood, and put some of it on the projections at the corners of the altar. Then he must pour out the rest of the blood at the base of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Then he must remove all the goat’s fat, and burn all the fat on the altar, like was done with the fat of the offering to maintain fellowship with Yahweh. And the aroma while it burns will be pleasing to Yahweh. As a result of the priest doing that, the person will no longer be guilty for his sin, and he will be forgiven. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","‘If that person brings a lamb to be his offering for sin, he must bring a female lamb that has no defects. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","He must lay his hands on the lamb’s head and slaughter it at the place where they slaughter the animals that will be completely burned on the altar, and catch some of the blood in a bowl. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Then the priest must dip one of his fingers in the blood and put some of it on the projections at the corners of the altar. Then he must pour out the rest of the blood at the base of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Then he must remove all the lamb’s fat, and burn all the fat on the altar, like was done with the fat of the offering to maintain fellowship with Yahweh. He must burn it on top of the other offerings to Yahweh that are being burned. As a result, the priest will request God to forgive that person for his sin, and he will be forgiven.’” ");
INSERT INTO eng_t4t_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Yahweh also said to tell the people, “If a judge orders any of you to tell in court something that you have seen or something that you heard someone say, if you refuse to say what you know is true, you must ◄pay a penalty/be punished► MTY for refusing to tell what you know. ");
INSERT INTO eng_t4t_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","If you accidentally touch something which God considers impure DOU, such as the carcass of a wild animal or the carcass of a bull or cow, or of an animal that scurries across the ground, you must ◄pay a penalty/be punished►. ");
INSERT INTO eng_t4t_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","If you touch any human feces, even if you do not intend to do that, when you realize what you have done, you must ◄pay a penalty/be punished►. ");
INSERT INTO eng_t4t_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","If you carelessly make a solemn promise to do something that is good or that is bad, when you realize what you have done, you must ◄pay a penalty/be punished►. ");
INSERT INTO eng_t4t_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","If you are guilty of committing any of those sins, you must confess what you have done. ");
INSERT INTO eng_t4t_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","And for a penalty you must bring to Yahweh a female lamb or female goat, to be an offering for the sin that you have committed, and the priest will sacrifice it, and then you will no longer be guilty for your sin. ");
INSERT INTO eng_t4t_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","If you are poor and cannot afford to bring a lamb, you must bring to Yahweh two doves or two young pigeons. One will be an offering for your sin and one will be an offering that will be completely burned on the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","You must bring them to the priest. First he will offer one of them to be an offering for your sin. He will wring/twist its neck to kill it, but he must not pull off its head completely. ");
INSERT INTO eng_t4t_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Then he must sprinkle some of the blood against the side of the altar. The remaining blood must be drained out at the base of the altar. That will be an offering for your sin. ");
INSERT INTO eng_t4t_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","The priest will then do what I have commanded and offer the other bird to be completely burned on the altar. Then you will no longer be guilty for the sin you have committed, and Yahweh will forgive you. ");
INSERT INTO eng_t4t_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","However, if you are very poor and cannot afford two doves or two young pigeons, you must bring to be an offering for your sin ◄2 pounds/1 kg.► of fine flour. You must not put olive oil or incense on it, because it is an offering for sin. ");
INSERT INTO eng_t4t_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","You must take it to the priest. He will take a handful of it, to symbolize that the whole offering truly belongs to Yahweh, and burn it on the altar, on top of the other offerings. ");
INSERT INTO eng_t4t_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","And by doing that, the priest will enable you to no longer be guilty for any of the sins that you have committed, and you will be forgiven. The part of the offering that is not burned will belong to the priest, like was true for the offerings made from grain.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“When you sin, without intending to, by not giving to Yahweh the things that you are required to give to him, you must pay a penalty by bringing to Yahweh a ram that has no defects. You must determine how much silver it is worth, by using the official standard in the temple. It will be an offering to cause you to no longer be guilty. ");
INSERT INTO eng_t4t_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","But you must also make restitution for what you failed to give to Yahweh, adding one-fifth of its value. You must give that to the priest. He will offer the ram as a sacrifice for the sin that you have committed, and cause you to no longer be guilty; and you will be forgiven. ");
INSERT INTO eng_t4t_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","If you sin by doing something that is forbidden by any of Yahweh’s commands, even if you do not know that you have disobeyed one of my commands, you are guilty and must pay a penalty to me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","When you realize what you have done, you must bring a ram to the Supreme Priest to be an offering in order that you will no longer be guilty. You must bring one that has no defects. He will offer the ram to be a sacrifice to me, and as a result you will no longer be guilty for the sin that you have committed, and you will be forgiven. ");
INSERT INTO eng_t4t_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","It is an offering to cause you to no longer be guilty for sinning against me.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“If any one of you you sins against me by deceiving someone—if you refuse to return what someone has lent you, or if you steal something of his, or if you find something and claim that you do not have it, ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","you are guilty. You must return to its owner what you have stolen or what someone has lent you and you have not returned, or what you found that someone else had lost, ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","or whatever you lied about. ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","You must not only return anything like that to its owner, but you must also pay to the owner one-fifth of its value. ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","You must also bring to the Supreme Priest a ram to be an offering to me in order that you will no longer be guilty. The ram that you bring must be one that has no defects, one that has the value that has been officially determined. ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Then he will offer that ram to be a sacrifice that will cause you to no longer be guilty, and you will be forgiven for the wrong things that you did.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Tell this to Aaron and his sons: These are the regulations concerning the offerings that will be completely burned on the altar: The offering must remain on the altar all during the night, and the fire on the altar must always be kept burning. ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","The next morning the priest must put on his linen under-clothes and linen outer clothes. Then he must remove the ashes of the offering from the fire and put them beside the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Then he must take off those clothes and put on other clothes, and take the ashes outside the camp, to a place that is acceptable to me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","The fire on the altar must always be kept burning; the priest must not allow it to ◄go out/quit burning►. Each morning the priest must put more firewood on the fire. Then he must arrange more offerings on the fire, and burn on the altar the fat of the offerings to be burned to maintain fellowship with me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","The fire on the altar must be kept burning continually; the priest must not allow it to go out.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“These are the regulations concerning the offerings made from grain: Aaron’s sons must bring them to me in front of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","The priest must take a handful of fine flour mixed with olive oil and incense and burn that on the altar. That handful will signify that the whole offering truly belongs to me. And the aroma while it burns will be pleasing to me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Aaron and his sons may eat the remaining part of the grain offering. But they must eat it in a holy place, in the courtyard of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","It must not have yeast mixed with it. Like the offerings for sin and the offerings to cause people to no longer be guilty of sin, that offering is very holy. ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Any male descendants of Aaron are permitted to eat it, because it is forever their regular share of the offerings given to me and burned in the fire on the altar. Anyone else who touches those offerings made from grain will be punished by God.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Tell Aaron and his sons that this is the offering that they must bring to Yahweh on the day that any of them ◄is ordained/becomes a priest►: That person must bring two quarts/liters of fine flour as an offering made from grain. He must bring half of it in the morning and half of it in the evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","He must mix it well with olive oil and bake it in a shallow pan. He must then break it into small pieces to be burned on the altar. And the aroma while it burns will be pleasing to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","I have commanded that the descendants of Aaron who are appointed in turn to become the Supreme Priests after Aaron dies are the ones who must prepare those things. These offerings must be completely burned on the altar to be sacrifices to me, Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Every offering that a priest gives that is made from grain must be completely burned; none of it is to be eaten.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Tell Aaron and his sons: These are the regulations concerning the offerings that people must bring to me so that I will forgive the people for the sins they have committed: ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","The animals must be slaughtered in my presence in the same place that the animals that are to be completely burned on the altar are slaughtered, in the courtyard in front of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Any other person who touches any of its meat will be punished by God. And if its blood is splattered on your clothes, you must wash the clothes in a holy place. ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","If the meat is cooked in a clay pot, the pot must be broken afterwards. But if it is cooked in a bronze pot, the pot must be scoured afterwards and rinsed with water. ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Any male in a priest’s family may eat some of the cooked meat; that meat is very holy. ");
INSERT INTO eng_t4t_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","But if the blood of those sin offerings is brought into the Sacred Tent to enable the people to be forgiven for having sinned, the meat of those animals must not be eaten. The meat must be completely burned.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“These are the regulations concerning the offerings to be made by people who are guilty of not giving to me the things that are required to be given to me. Those are very sacred offerings. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Each animal that is to be offered by such people must be slaughtered in the same place where the animals that will be completely burned on the altar are slaughtered, and their blood must be sprinkled against all sides of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","All their fat, the fat tails that are cut close to the backbone, and all the fat that covers the inner parts of the animals or which is attached to them, must be burned on the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","That includes the kidneys with their fat near the lower back muscle, and the protruding lobe that is attached to the liver. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","The priest must burn them on the altar to be offerings to me, Yahweh. They are an offering for the people to be forgiven for not doing what they were required to do. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","All the males in the priest’s family are permitted to eat its meat, but it must be eaten in a sacred place, because it is very sacred. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“The regulation is the same for the offerings to enable people to be forgiven for the sins they have committed  and the offerings for when they are guilty of not giving to me the things that are required to be given to me. The meat of those offerings belongs to the priest who offers them in order that the people will be forgiven. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","The priest who slaughters an animal that will be completely burned on the altar is permitted to keep the animal’s hide for himself. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Offerings of things made from grain that are baked in an oven or cooked in a pan or ◄in a shallow pan/on a griddle► belong to the priest who makes those offerings for another person. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","And offerings of things made from grain, whether they were mixed with olive oil or not, also belong to the sons of Aaron.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","These are the regulations concerning the offerings that people make to maintain fellowship with Yahweh: ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“If you bring an offering to thank Yahweh, along with the animal that you slaughter you must offer loaves of bread made with olive oil mixed with the flour but without yeast, and wafers that are made without yeast but with olive oil smeared on them, and loaves made from fine flour with olive oil well mixed with the flour. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Along with that offering to thank Yahweh, you must bring an offering of loaves made with yeast. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","You must bring one of each kind for an offering to Yahweh, but they belong to the priest who sprinkles against the altar the blood of the animal that is slaughtered as an offering to maintain fellowship with Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","The meat of that offering must be eaten on the day that it is offered; none of it should be left to be eaten on the next day. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“However, if your offering is the result of a solemn promise that you made to Yahweh, or if it is an offering that you make ◄voluntarily/without being required to►, you are permitted to eat some of the meat on the day it is offered, but anything that is left may be eaten on the next day. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","But any meat that is left until the third day must be completely burned. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","If any meat from the offering to maintain fellowship with Yahweh is eaten on the third day, Yahweh will not accept that offering; it will be useless to offer it, because Yahweh will consider that it is worthless. Anyone who eats some of it will have to pay a penalty to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“Meat that touches something that God considers to be impure must not be eaten; it must be completely burned. Anyone who has performed the rituals to become acceptable to God is allowed to eat other meat which has been offered as a sacrifice. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","But if anyone who has not performed those rituals eats some of the meat of the offering to maintain fellowship with Yahweh, meat that belongs to Yahweh, he must no longer be allowed to associate with God’s people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","If anyone touches something that God considers to be impure and very displeasing to him, whether it is from a human or from an animal, and then he eats any of the meat of the offering to maintain fellowship with Yahweh, meat that belongs to Yahweh, he must no longer be allowed to associate with God’s people.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Yahweh also said to Moses/me: ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Say this to the Israeli people: ‘Do not eat any of the fat of cattle or sheep or goats. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","The fat of an animal that is found dead or that has been killed by a wild animal may be used for other purposes, but you must not eat it. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Anyone who eats the fat of an animal from which an offering has been made to Yahweh must no longer be allowed to associate with God’s people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","And wherever you live, you must not eat the blood of any bird or animal. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","If anyone eats blood, he must no longer be allowed to associate with God’s people.’” ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Tell the Israeli people this: ‘Anyone who brings an offering to maintain fellowship with Yahweh must bring part of it to be a sacrifice to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","He himself must bring the offering that will be burned in the fire. He must bring the fat along with the breast of the animal and lift it up in front of Yahweh to indicate that it is an offering to him. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","The Supreme Priest must burn the fat on the altar, but the breast belongs to Aaron and all his sons. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","You must give to the Supreme Priest the right thigh of the animal that is sacrificed to maintain fellowship with Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","The son of Aaron who offers the blood and the fat of that sacrifice must be given the right thigh of the animal as his share. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","From the offerings that the Israeli people give to maintain fellowship with Yahweh, he has declared that he has given to Aaron and his sons the breast that is lifted up and the right thigh that is offered; those portions must always be their regular share from the Israeli people.’” ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Those are the portions of the offerings brought/given to Yahweh and burned in fire that are allotted to Aaron and his sons on the day that they are set apart to serve Yahweh as priests. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Yahweh commands that on the day that the priests are appointed MTY, the Israeli people must always give those portions to the priests. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Those are the regulations for the offerings that are to be completely burned on the altar, the offerings made from grain, the offerings to enable people to become acceptable to God again, the offerings for when people are guilty of not giving to Yahweh the things that are required to be given to him, the offerings given when the priests are appointed, and the offerings to maintain fellowship with Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","They are regulations that Yahweh gave to Moses/me on Sinai Mountain in the Sinai Desert, on the day that he commanded the Israeli people to start bringing their offerings to him. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Bring Aaron and his sons, and bring their ◄special clothes/clothes that they will wear while they do the work of priests►, the oil for anointing them, the bull to be offered to cause them to become forgiven for the sins they have committed, the two rams to be slaughtered, and the basket containing bread made without yeast. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Then gather all the people at the entrance to the Sacred Tent.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moses/I did what Yahweh told him/me to do, and all the people gathered there. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Then Moses/I said to the people, “This is what Yahweh has commanded us to do.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Then he/I brought Aaron and his sons forward and washed them. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","He/I put the special tunic/shirt on Aaron, tied the sash/waistband around him, put on him the special robe, and put on him the sacred vest/apron. He/I fastened the sacred vest/apron around him, using the skillfully woven sash. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","He/I put the sacred pouch on his chest and put into it the two stones for him to use to find out what God wants. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Then he/I wrapped the turban around Aaron’s head, and fastened on the front of it the gold ornament, the object that showed that he was dedicated to God, like Yahweh had commanded Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Then Moses/I took the olive oil and anointed the sacred tent and everything in it, and dedicated them to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","He/I sprinkled some of the oil on the altar seven times. He/I anointed the altar and all the things used with it, and its huge washbasin and its stand, to dedicate them to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","He/I poured some of the oil on Aaron’s head and anointed him to dedicate him to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Then he/I brought forward Aaron’s sons. He/I put tunics/shirts on them, tied sashes/waistbands around them, and wrapped turbans around their heads, like Yahweh had commanded Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Then he/I brought the bull for the offering to cause people to be forgiven for the sins that have committed. Then Aaron and his sons put their hands on the bull’s head. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Then Moses/I slaughtered the bull, caught some of its blood in a bowl, and with his/my finger put some of that blood on the projections at the corners of the altar, to purify the altar. He/I poured the rest of the blood at the base of the altar. By doing that, he/I caused it to be a suitable place for burning sacrifices for sin. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Moses/I took all the fat that covers the inner parts of the animal, including the liver and kidneys, and burned them on the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","He/I took the rest of the bull, including the hide and intestines, and burned them outside the camp, like Yahweh had commanded Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Then he/I brought the ram for the offering that would be completely burned on the altar, and Aaron and his sons laid their hands on its head. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Then Moses/I slaughtered the ram and sprinkled its blood on all sides of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","He/I cut the ram into pieces and washed the inner parts and hind legs.Then he/I put the head, the fat, and the other parts of the ram on the altar. As it burned, the aroma of the smoke was pleasing to Yahweh. It was an offering to Yahweh that was burned, as Yahweh had commanded Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Then he/I brought the other ram, the one for consecrating the priests, and Aaron and his sons laid their hands on its head. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","24","Moses/I slaughtered that ram, drained some of its blood in a bowl, and put some of that blood on the lobes of the right ears, the thumbs of the right hands, and the big toes of the right feet of Aaron and his sons to indicate that what they listened to and what they did and where they went should be directed by Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","He/I picked up all the fat of the ram, its fat tail, the fat that covered the inner parts, including the fat that covered the liver and kidneys, and the right thigh of the ram. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","27","Then from the basket containing the bread that was made without yeast, the bread which had been dedicated to Yahweh, he/I picked up one loaf of bread made without olive oil, and one loaf that was made by mixing the flour with olive oil, and one wafer. He/I put those on top of the portions of fat, and put them into the hands of Aaron and his sons. Then they lifted them up in the presence of Yahweh to indicate that it was an offering that belonged to him. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Then Moses/I took those things from their hands and burned them on the altar. That was the offering that was burned to appoint Aaron and his sons as priests. And the aroma while it burned was pleasing to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moses/I also took the breast of the second ram and lifted it up, as Yahweh had commanded. The breast was Moses’/my share of the ram that was sacrificed to dedicate the priests. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Then Moses/I took some of the olive oil for anointing Aaron and his sons, and some of the blood that was on the altar and sprinkled it on Aaron and his sons and on their clothes. By doing that, he/I consecrated Aaron and his sons and their clothes. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Then Moses/I said to Aaron and his sons, “Boil the meat of the second ram at the entrance of the Sacred Tent, and eat it there with the bread that is in the basket, like I told you to do. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Burn up any of the meat and bread that remains. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","The time for you to be set apart as priests will be seven days, so do not leave the entrance of the Sacred Tent for seven days. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","What we have done today is what Yahweh commanded to cause that you will be forgiven for your sins. ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","You must stay at the entrance of the Sacred Tent for seven days and seven nights and do what Yahweh requires, in order that you will not die because of disobeying him. I am telling you that because that is what Yahweh has commanded me to tell you.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","So Aaron and his sons did everything that Yahweh told Moses/me to tell them. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Eight days later, Moses/I summoned the elders of Israel. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Then he/I said to Aaron, “Take a young bull for the offering to enable you leaders to be forgiven for the sins you have committed, and a ram to be completely burned on the altar, both of them without any defects, and offer them to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Then say to the Israeli people, ‘Take one male goat for the offering to enable you all to be forgiven for the sins you have committed. Also take a calf and a lamb that have no defects, to be an offering completely burned on the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Also take an ox and a ram to be an offering to maintain fellowship with Yahweh, along with an offering of flour mixed with olive oil. Do this because today Yahweh is going to appear to you.’ ” ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","After Moses/I told this to the Israeli people, some of them took the things that Moses/I had commanded them to take, and went to the courtyard in front of the Sacred Tent. Then all the people came near and stood in front of Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Then Moses/I said, “This is what Yahweh has commanded you to do, in order that his glory will appear to you.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Then Moses/I said to Aaron, “Come to the altar and sacrifice the animal that is your offering to enable you to be forgiven for the sins you have committed, and the animal that will be completely burned there. Because of those offerings, God will forgive you and the people for the sins that you have committed DOU. Do those things that Yahweh has commanded.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","So Aaron came close to the altar and slaughtered the calf to be an offering for his sins. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","His sons brought its blood to him in a bowl. He dipped his finger into the blood and put some of it on the projections at the corners of the altar. He poured out the rest of the blood at the base of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","He/I burned the fat, including that which covered the kidneys and the liver, as Yahweh had commanded him/me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Then Aaron burned the rest of the meat and the hide/skin outside the camp. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Then Aaron slaughtered the animal that would be completely burned on the altar. His sons handed him the bowl containing its blood, and he sprinkled the blood on all sides of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Then they handed him the head and the pieces of the animal that would be burned, and he burned them on the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","He washed the inner parts and the legs of the animal, and burned them on the altar, on top of the other pieces of the animal. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Then Aaron brought the animals that would be sacrifices for the Israeli people. He took the goat and slaughtered it to be an offering to enable them to be forgiven for the sins they had committed, like he had done with the goat for his own offering. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Then he brought the animal for the offering to be completely burned. He slaughtered it and offered it in the way that Yahweh had commanded him to do. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","He also brought the offering of grain. He took a handful of it and burned it on the altar, like he had done for the animal that he had slaughtered and completely burned on the altar in the morning. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Then he slaughtered the ox and the ram, to be an offering for the Israeli people to maintain fellowship with Yahweh. His sons handed him the bowl containing the blood, and he sprinkled the blood against all sides of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","But he took the fat from the ox and the ram, including their fat tails that were cut close to the backbone, and all the fat that covered the livers and the kidneys. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","He put them on top of the breasts of those animals and carried them to the altar to be burned. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Then, doing what Moses/I had commanded, he lifted up in front of Yahweh the breast and the right thigh of those animals, to signify that those two animals completely belonged to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Then Aaron lifted his arms toward the people and asked Yahweh to bless them. Then having finished making all those offerings, he stepped down from the place where the altar was. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Then Aaron and Moses/I entered the Sacred Tent. When they/we later came out, they/we asked Yahweh to bless the people. And suddenly the glory/brightness of Yahweh appeared to all the people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","A fire from Yahweh appeared and burned up the offering that was to be completely burned and the fat that was on the altar. And when all the people saw that, they shouted joyfully and prostrated themselves on the ground to worship Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Two of Aaron’s sons, Nadab and Abihu, took the pans in which they burned incense. They put some burning coals in them and put incense on top of the coals, but this fire was not acceptable to Yahweh because it was not the kind that he had commanded them to burn. ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","So suddenly a fire from Yahweh appeared and burned them up DOU in the presence of Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Then Moses/I said to Aaron, “That is what Yahweh predicted. He said, ‘Those priests who come near to me, I will show them that they must ◄respect me/treat me as being holy►; in the presence of all the people I am the one who must be honored.’” But Aaron said nothing. ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Then Moses/I summoned Mishael and Elzaphan, who were the sons of Aaron’s uncle Uzziel, and said to them, “Take the corpses of your cousins outside the camp, away from the front of the Sacred Tent.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","So they carried the corpses, which still had their special gowns on, outside the camp, and buried them. ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Then Moses/I said to Aaron and his other two sons Eleazar and Ithamar, “You are sad because Nadab and Abihu died, but you must act like you always do. Do not allow the hair on your heads to remain uncombed, and do not tear your clothes. But your relatives and all your fellow Israelis are allowed to mourn for those whom Yahweh destroyed by fire. ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","But you must not leave the entrance of the Sacred Tent to join those who are mourning, because if you do that, you also will die, and Yahweh will punish MTY all the people of Israel. Do not forget that Yahweh has set you apart MTY to work for him here, and he does not want you to become defiled by touching a corpse.” So they did what Moses/I told them to do. ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Then Yahweh said to Aaron, ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“You and your two sons who are still alive must not drink wine or other fermented drinks before you enter the Sacred Tent; if you do that, you will die. That is a command that you and your descendants must obey forever. ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","You must do that in order to learn what things are holy and what things are ◄not holy/common►, and from the things that are not holy you must learn what things are acceptable to me and what things are not. ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","And you must teach to the Israeli people all the laws that I gave to the Israeli people by telling them to Moses.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Moses/I said to Aaron and his two sons who were still alive, Eleazar and Ithamar, “Take the offering made from grain that is left after a portion of it has been offered to Yahweh to be burned, and eat it alongside the altar. It should not be eaten elsewhere, because it is very holy. ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Eat it in a holy place; it is the share for you and your sons from the offerings that were burned; I have commanded that it be your share. ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","But you and your sons and daughters are permitted to eat the breast and the thigh that were lifted up in front of Yahweh. Eat them in any place that is ◄holy/acceptable to him►. They have been given to you and your descendants as your share of the offerings to enable the Israelis to maintain fellowship with Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","The thigh and the breast that were lifted up in front of Yahweh must be brought with the portions of fat to be burned, to be lifted up in his presence. They will be the regular share for you and your descendants, as Yahweh has commanded.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","When Moses/I inquired about the goat that had been sacrificed to enable the people to be forgiven by Yahweh for the sins they had committed, he/I found out that it had been completely burned. So he/I was angry with Eleazar and Ithamar and asked them, ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Why did you not eat near the Sacred Tent the meat of the offering for sin? It was very holy, and it was given to you to enable the Israeli people to no longer be guilty for their sins and to be forgiven for their sins. ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Since its blood was not taken into the holy place inside the Sacred Tent, you should have eaten the meat of the goat near the Sacred Tent, as I commanded.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aaron replied to Moses/me, “Today the people brought to Yahweh their offering to be forgiven for the sins they had committed, and the offering to be completely burned, and surely that pleased Yahweh, but think about the terrible thing that happened to my other two sons! Would RHQ Yahweh have been pleased if I had eaten some of the offering to cause the people to become acceptable to God?” ");
INSERT INTO eng_t4t_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","When Moses/I heard that, he/I was satisfied. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Yahweh said to Aaron and Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Tell the Israeli people that this is what Yahweh says: From all the animals that live on the land, these are the ones that you are permitted to eat: ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","The ones that have hooves that are completely split and that ◄chew their cuds/bring their food up from their stomachs to chew it again►. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","There are some animals that chew their cuds but do not have split hooves, and some animals that have split hooves but do not chew their cuds. You must not eat any of those animals. For example, camels chew their cuds but do not have split hooves, so they are unacceptable for you to eat. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Rock badgers chew their cuds but do not have split hooves, so they are unacceptable for you to eat. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Rabbits chew their cuds but do not have split hooves, so they are unacceptable for you to eat. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Pigs have completely split hooves but they do not chew their cuds, so they are unacceptable for you to eat. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","All of those animals are unacceptable for you, so you must not eat their meat or even touch their carcasses. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","From all the creatures that live in the oceans and the streams, you are permitted to eat any that have fins and scales. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","But you must detest and not eat those that do not have fins and scales. That includes ones that are very small. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","You must despise them, and you must not eat their meat, and you must detest their carcasses. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","You must detest everything that lives in the water that does not have fins and scales. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","There are some birds that you must detest and not eat. They include eagles, bearded vultures, black vultures, ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","kites, any kind of falcon/buzzard, ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","any kind of raven, ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","horned owls, screech owls, seagulls, any kind of hawk, ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","small owls, cormorants, large owls, ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","white owls, desert owls, vultures that eat dead animals, ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","storks, any kind of heron, hoopoes, and bats. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","You must detest and not eat flying insects that sometimes walk on the ground MTY. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","But you are permitted to eat creatures with wings that sometimes walk on the ground if they have jointed legs for hopping around. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","They include locusts, crickets, and grasshoppers. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","But you must detest and not eat other insects with wings that have four legs. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","‘There are certain creatures that if you touch their carcasses you will become defiled. Anyone who touches their carcasses must not touch other people until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Anyone who picks up one of their carcasses must wash his clothes and not touch other people until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","‘The animals whose carcasses you must not touch are those that have hooves that are not completely divided or animals that do not chew their cuds. Anyone who touches the carcasses of any of those animals becomes ◄defiled/unacceptable to me►. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","From all the animals that walk on the ground, you must not touch the carcasses of those that have paws to walk on. Anyone who touches one of their carcasses must not touch other people until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Anyone who picks up one of their carcasses must wash his clothes and not touch other people until that evening, because touching their carcasses ◄defiles you/causes you to become unacceptable to me►. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","‘From all the animals that walk on the ground, these are the ones that ◄defile you/cause you to become unacceptable to me► if you touch them: Moles, rats, any kind of lizard, ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","geckos, skinks, and chameleons. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Those creatures that scurry across the ground ◄defile you/cause you to become unacceptable to me►; anyone who touches one of their carcasses must not touch other people until the evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","When one of those creatures dies and falls on something, the thing that it falls on, whatever it is used for, will become ◄defiled/unacceptable to me►, whether it is made of wood or cloth or the hide of some animal or from rough cloth. You must put it in water. Then you must not use it until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","If one of them falls into a clay pot, everything in it becomes defiled, and you must break that pot into pieces. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","If you pour water from that pot on any food, you must not eat that food. And you must not drink any water from that pot. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Anything that one of the carcasses of those creatures falls on becomes ◄defiled/unacceptable to me►; even if it falls on an oven or a cooking pot, anything that it falls on must be broken into pieces. It becomes unacceptable to me and you must not use it again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","If one of their carcasses falls into a spring or a pit for storing water, the water may still be drunk, but anyone who touches one of those carcasses becomes unacceptable to me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","If one of those carcasses falls on seeds that are to be planted, those seeds are still acceptable to be planted. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","But if water has been put on the seeds and then a carcass falls on them, the seeds must be thrown away. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","‘If an animal whose meat you are permitted to eat dies, anyone who touches its carcass must not touch other people until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Anyone who eats some meat from that carcass must wash his clothes, and then he must not touch anyone until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","42","‘All creatures that scurry across the ground, including those that move on their bellies and those that crawl, are detestable, and they must not be eaten. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Do not ◄defile yourselves/cause you to become unacceptable to me► by eating any of those creatures DOU. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","I am Yahweh your God, and I am holy, so you must consecrate yourselves and be holy. You must avoid eating things that cause you to be unacceptable to me. Do not cause yourselves to become unacceptable to me by eating creatures that scurry across the ground. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","I am Yahweh, the one who freed you from being slaves in Egypt, in order to be your God. Therefore, because I am holy, you must be holy. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","'Those are the regulations concerning animals and birds, all the living creatures that live in water or scurry across the ground. ");
INSERT INTO eng_t4t_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","You must learn what things I say are acceptable to me and what things are not, and learn what things you are permitted to eat and what things you are not permitted to eat.’” ");
INSERT INTO eng_t4t_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Tell this to the Israeli people: ‘If a woman gives birth to a son, she must be avoided for seven days, like she must be avoided when she is menstruating each month. ");
INSERT INTO eng_t4t_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","The baby son must be circumcised on the eighth day after he is born. ");
INSERT INTO eng_t4t_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Then the woman must wait 33 days to be purified from her bleeding during childbirth. She must not touch anything that is sacred or enter the Sacred Tent area until that time is ended. ");
INSERT INTO eng_t4t_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","If a woman gives birth to a daughter, she must be avoided for two weeks, like she must be avoided when she is menstruating each month. Then she must wait 66 days to be purified from the bleeding that occurred when her baby was born. ");
INSERT INTO eng_t4t_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","‘Then that time for her to be purified is ended, that woman must bring to the priest at the entrance of the Sacred Tent a one-year-old lamb to be completely burned on the altar, and a dove or a young pigeon to be sacrificed to enable her to become acceptable to Yahweh again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","The priest will offer them to Yahweh in order that she may be forgiven for any sins she has committed. Then she will be purified from her loss of blood when the baby was born. ‘Those are the regulations for women who give birth to a son or daughter. ");
INSERT INTO eng_t4t_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","If a woman who gives birth to a child cannot afford a lamb, she must bring two doves or two young pigeons. One will be burned completely on the altar, and one will be an offering to enable her to become acceptable to God again. By doing that, the priest will cause that she will be forgiven for any sins she has committed, and she no longer will need to be avoided.’” ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Yahweh said this to Aaron and Moses/me: ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“When someone has on his skin a swelling or a rash or a shiny/bright spot that may become ◄contagious/a dreaded skin disease►, he must be brought to Aaron or to one of his sons who are also priests. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","The priest must examine that part of the person’s skin. If the hair in that area has become white and it appears that the sore is deeper than just on the skin, it is a contagious skin disease. When the priest sees that, he must declare that the person must stay away from other people MTY. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","If the spot on the person’s skin is white but it does not appear that the sore is deeper than just on the skin, the priest must tell him to stay away from other people for seven days. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Then the priest must examine the person again. If the priest sees that the sore has not changed and has not spread, he must tell the person to stay away from people for seven more days. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Then the priest must examine him again. If the sore has faded and has not spread, the priest will allow him to be with other people again; it is only a rash. After the person washes his clothes, he will be allowed to be with other people again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","But if the sore spreads after the priest has examined him, he must go to the priest again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","The priest will examine him; and if the sore has spread to more of the skin, it is a contagious skin disease, and the priest will declare that he must stay away from other people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","When anyone has a contagious skin disease, he must be brought to the priest. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","The priest must examine him. And if there is a white swelling in the skin that has caused the hair in that swelling to become white, and if the flesh in that area is painful/sensitive, ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","it is a permanent skin disease, and the priest will declare that he must stay away from other people. The priest does not need to tell that person that he must avoid other people, because other people already are wanting to stay away from him. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","‘If the disease spreads all over someone’s body, and the priest examines that person and sees that it is covering his skin from his head to his feet, ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","and it has caused all his skin to become white which will indicate that the disease has ended, the priest will declare that the person does not have to stay away from other people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","But if the person has open sores and they are very painful/sensitive, he has a contagious skin disease, ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","and when the priest sees that, he will declare that the person must stay away from other people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","But if the person’s flesh changes and becomes white, he must go to the priest again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","The priest must examine him again; and if the sores have become white, the priest will declare that the person who had been infected is now permitted to be with other people again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","‘Then someone has a boil on his skin and it has healed, ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","but in the place where the boil was a white swelling or a bright/shiny spot appears, he must go to the priest. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","The priest must examine it. And if it seems to be deeper than just on the skin, and if the hair in that spot has become white, it is a contagious skin disease that has appeared where the boil had been. And the priest will declare that the person must stay away from other people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","But when the priest examines it, if there is no white hair in that spot and it is only on the surface of the skin and has become less bright/shiny, then the priest will order him to stay away from other people for seven days. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","But if it is spreading, it is contagious and the priest will declare that the person must stay away from other people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","But if that spot is unchanged and has not spread, it is only a scar from the boil, and the priest will declare that the person is permitted to be with other people again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","‘Then someone has a burn on his skin and a bright/shiny or white spot appears, and the flesh in that area is sensitive/painful, ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","the priest must examine the spot. If the hair in that spot has turned white and it seems to be deeper than just on the surface of the skin, it is a contagious skin disease that has appeared where the burn was, and that person must stay away from other people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","But when the priest examines it and sees that there is no white hair in that spot and it is only on the surface of the skin, and has faded, the priest will declare that the person must stay away from people for seven days. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","On the seventh day, the priest will examine him again. If the sore is spreading, it is a contagious skin disease, and the priest will declare that the person must stay away from other people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","However, if the spot is not changed and has not spread but has faded, it is only a scar from the burn, and the priest will declare that the person is permitted to be with other people again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","‘If a man or a woman has a sore on his head or on his chin, ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","the priest must examine it. If it appears to be deeper than just on the surface of the skin, and the hair in that spot has thinned out and has become yellowish, it is a contagious skin disease that causes itching. And the priest will declare that the person must stay away from other people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","But when the priest examines that kind of sore, if it seems to be only on the surface of the skin and there is no healthy hair in it, the priest will tell the person to stay away from other people for seven days. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","On the seventh day, the priest will examine the sore again. If it has not spread and if there is no yellow hair in that spot and if it appears to be only on the surface of the skin, ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","the person must shave the hair near the sore but not the hair on the sore. And the priest will tell him to stay away from other people for seven more days. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","On the seventh day, the priest will examine that spot again. If it has not spread and it appears to be only on the surface of the skin, the priest will declare that the person is permitted to be with people again. The person must wash his clothes, and then he can be with other people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","But if the sore later spreads, ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","the priest must examine him again. If the itch/sore has spread, the priest does not need to look for yellow hair, because it is clear that the person has a contagious skin disease. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","However, if the priest thinks that the spot has not changed, and healthy hair is growing in that area, it is clear that the itch has healed, and the priest will declare that the person is permitted to be with other people again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","‘Then a man or a woman has white spots on the skin, ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","the priest should examine them. But if the spots are dull white, it is only a rash, and the priest will declare that the person is permitted to be with other people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","‘If a man loses the hair on any part of his head, he does not need to stay away from other people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","But if he gets a bright/shiny sore on his bald head or on his forehead, he has a contagious skin disease. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","The priest must examine him. If the swollen sore is a bright spot like the spot on someone who has a contagious skin disease, ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","the priest will declare that the man has a contagious skin disease and must not be with other people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","‘Anyone who has a contagious skin disease must wear torn clothes and not comb his hair. When he is near other people, he must cover the lower part to his face and call out, “Do not come near me! I have a contagious skin disease!” ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","He is not allowed to be with other people as long as he has the disease. He must live alone, outside the camp.’” ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","48","“Sometimes a person’s clothing gets mildew on it. It may be clothing that is woven from wool or made from linen or from leather. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","If the contaminated/mildewed part is greenish or reddish, it is a spreading mildew, and it must be shown to the priest. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","The priest will examine it, and then put it in a separate place by itself for seven days. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","On the seventh day he must examine it again. If the mildew has spread, it is clear that it is a type of mildew that destroys clothing, and that clothing must not be worn again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","The owner must burn completely the item that has the mildew in it, whatever kind of item it is. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","But when the priest examines it, if the mildew has not spread, ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","he will tell the person who owns it to wash it. Then he must put it in a separate place for another seven days. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Then the priest will examine it again. If the color of the mildew has not changed, even though it has not spread, that item must not be worn again. It does not matter if the mildew is on the inside of the clothing or on the outside; it must be burned. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","But when the priest examines it after it has been washed, if the mildew has faded, he must tear out that part that had the mildew in it. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","But if the mildew reappears in that item, it is clear that it is spreading, and the whole item must be burned. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","But after the clothing is washed and the mildew disappears, it must be washed again, and then it can be worn again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Those are the regulations concerning mildew on things made of wool or linen or leather, for deciding whether those things can continue to be worn or not.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“These are the regulations for anyone who has been healed of a contagious skin disease. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","The person must be brought to a priest. The priest will take him outside the camp to where that person has been staying, and examine him. If the skin disease has been healed, ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","the priest will say that someone must bring two living birds that are acceptable to Yahweh, along with some cedar wood, some scarlet/red yarn, and some sprigs of ◄hyssop/a very leafy plant►. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Then the priest will command that one of the birds be killed while it is being held over a clay pot containing water from a spring. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Then the priest will dip the other bird, along with the cedar wood, the scarlet/red yarn and the hyssop, into the blood of the bird that was killed. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Then he must sprinkle some of the blood on the person who was healed; he must sprinkle it on him seven times. Then he will declare that the person is permitted to be with other people again. And the priest will release the other bird and allow it to fly away. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Then the person who was healed must wash his clothes, shave off all his hair, and bathe. Then he is allowed to return to the camp, but he must stay outside his tent for seven days. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","On the seventh day, he must again shave off all his hair, including his beard and his eyebrows. Then he must again wash his clothes and bathe, and then he will be allowed to be with other people again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“The next day that person must bring two male lambs and one female lamb that is one year old, all of them with no defects. He must also bring six quarts/liters of fine flour, mixed with olive oil, to be an offering, and ◄0.6 pint/0.3 liter► of olive oil. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","The priest who declares that the person’s skin disease is ended must bring that person, and his offerings, to me, Yahweh, at the entrance of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Then the priest must take one of the male lambs and lift it up, along with the olive oil, in front of me, to be a guilt offering—an offering for his being guilty for not giving to me the things that he was required to give me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Then the priest must slaughter the lamb in the sacred place where the other sacrifices are offered. Like the offering to enable people to be forgiven, this guilt offering is holy, and belongs to the priest. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","The priest must take some of the blood of that animal and pour it on the lobe/tip of the right ear and on the thumb of the right hand and on the big toe of the right foot of the one who has been healed of the skin disease. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Then the priest must take some of the olive oil and pour it in the palm of his own left hand. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Then he must dip the forefinger of his right hand into the oil in his palm, and sprinkle it in front of me seven times. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Then he must put some of the oil that is still in the palm of his hand on the lobe/tip of the right ear and the thumb of the right hand and on the big toe of the right foot of the person who has been healed of the skin disease. He must put it on top of the blood that he has already put on those places. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","The remaining oil in his palm must be put on the person’s head, to indicate that I declare that the person has been forgiven for having sinned. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Then the priest must slaughter one of the other two animals, to show that the one who has been healed of the skin disease has been forgiven for having sinned, and that he has become acceptable to Yahweh. Then the priest will slaughter the animal that will be completely burned on the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","He will also put on the altar the offering of grain, to indicate that the person has been forgiven for having sinned. Then that person will be allowed to be with other people again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“But if the person who has been healed of a skin disease is poor and cannot afford to bring all those animals, he must take to the priest one male lamb to be lifted up to be an offering for his not giving to me the things that he was required to give me. He must also take two quarts/liters of fine flour mixed with olive oil to be an offering made from grain, ◄0.6 pint/0.3 liter► of olive oil, ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","and two doves or two young pigeons, one for him to be forgiven for the sins he has committed, and one to be completely burned on the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“On that same day, that person must take those things to the priest at the entrance of the Sacred Tent, to offer them to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","The priest will take the lamb for the offering for that person not giving to me the things that he was required to give me, along with the olive oil, and lift them up in front of me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Then the priest will slaughter that lamb and drain some of the blood in a bowl, and take some of that blood and put it on the lobe/tip of the person’s right ear and on the thumb of his right hand and on the big toe of his right foot. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Then the priest will pour some of the oil into the palm of his left hand, ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","and with his right forefinger he must sprinkle some of the oil from his palm there in my presence. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","He must put some of the oil in his palm on the same places where he put the blood. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","He must put the rest of the oil that is in his hand on the head of the person who has been healed of a skin disease, to indicate that I have forgiven him for having sinned. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Then the priest must sacrifice the doves or the pigeons, whichever that person has brought. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","One will be an offering for sin and the other will be completely burned on the altar, along with the offering of grain. By doing that, the priest will declare that the person is no longer guilty for having sinned. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","“Those are the regulations for anyone who has a contagious skin disease and who is poor and cannot afford the usual offerings, in order that he can be with people again.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Yahweh also said to Aaron and Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“I am about to give you Canaan land to belong to your people permanently. When you enter that land, there will be times when I cause/allow mildew to appear inside one of your houses. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","If that happens, the owner of that house must go to the priest and tell him, ‘There is something in my house that looks like mildew.’ ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","“Then the priest will say to him, ‘Take everything out of the house before I enter the house to examine the mildew. If you do not do that, I will declare that everything in the house is contaminated.’ ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","After the owner takes everything outside of his house, the priest will go in and inspect the house. If the mildew has caused greenish or reddish spots/depressions on the walls that seem to be deeper than only on the surface of the walls, ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","the priest will go outside the house and lock it up for seven days. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","On the seventh day, he must go into the house and inspect it again. If the mildew on the walls has spread, ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","the priest will tell someone to tear out and throw in the dump outside the town all the stones in the walls that have mildew on them. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Then the owner must scrape all the walls inside the house, and everything that is scraped off must be thrown into a dump outside the town. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Then the owner must get new/other stones to replace the ones that had mildew on them, and take new clay and plaster to cover the stones in the walls of the house. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“If the mildew appears again in the house after that is done, ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","the priest must go and examine the house again. If the mildew has spread inside the house, it will be clear that the mildew is the kind that destroys houses, and no one will be allowed to live in it. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","It must be completely torn down—the stones, the timber and the plaster—and all those things must be thrown into a dump outside the town. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Anyone who goes into that house while it is locked up will not be allowed to be with other people until sunset of that day. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Anyone who sleeps in that house or eats in that house during that time must wash his clothes. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“But when the priest comes to examine the house after it has been plastered, if the mildew has not spread, he shall declare that people may live in it, because the mildew is gone. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","But before people are allowed to live in it, the priest must take two small birds and some cedar wood and some red/scarlet yarn and some hyssop. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","He must kill one of the birds while holding it over a clay pot containing water from a spring. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Then he must take the cedar wood, the hyssop, the red/scarlet yarn, and the other/living bird, and dip them into the blood of the dead bird, and sprinkle some of that blood on the house seven times. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","By doing all those things he will cause the house to be acceptable to be lived in again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Then he must release the other bird and allow it to fly away. By doing that, he will finish the ritual for causing the house to be acceptable for people to live in it again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","“Those are the regulations for contagious diseases, for itching sores, ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","for mildew DOU on clothes or in a house, ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","and for swellings, rashes, or bright spots on sores, ");
INSERT INTO eng_t4t_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","to find out whether a person has a contagious disease or not, and whether people will still be permitted to touch their clothing or their house, or not.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Yahweh also said to Moses/me and Aaron, ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Tell this to the Israelis: When an infected discharge comes out of a man’s sexual organs EUP, that fluid should not be touched. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Whether that fluid is blocked or continues to drip, it causes him to be someone who should not be touched. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“And any bed that such a man lies on should not be touched, and anything that he sits on should not be touched. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Anyone who touches that person’s bed must wash his clothes and bathe, and no one should touch him until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Anyone who sits on something that man has sat on must wash his clothes and bathe, and no one should touch him until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“Anyone who touches such a man must wash his clothes and bathe, and no one should touch him until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“If such a man spits on someone else, that person who is spit upon should not be touched. He must wash his clothes, and no one should touch him until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“Everything that a man who has such a discharge of fluid sits on while he is riding a horse or a donkey should not be touched, ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","and anyone who touches the seat or saddle that he was sitting on also should not be touched until that evening. And anyone who picks up the seat or saddle must wash his clothes and bathe, and no one should touch him until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Anyone whom the man with such a discharge of fluid from his body touches without first rinsing his hands in water must wash his clothes and bathe, and no one should touch him until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“If such a man touches a clay pot, that pot must be broken into pieces. Anything made from wood that he touches must be rinsed in water. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“If such a man is healed from his flow of fluid, he must wait for seven days. Then he must wash his clothes and bathe in water from a spring. Then he will be able to be with others. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","On the eighth/next day, he must take two doves or two young pigeons and come in front of Yahweh at the entrance of the Sacred Tent, and give them to the priest. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","The priest will sacrifice them. One will be an offering for the man to become acceptable to God, and the other one will be completely burned on the altar. As a result of the priest doing that, the man will be forgiven for having sinned. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Then semen accidentally flows from a man’s sexual organs EUP, he must bathe his whole body, and no one should touch him until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Any clothing or leather that has semen on it must be washed, and no one should touch it until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","When a man has sex with a woman and some semen spills, both of them must bathe, and no one should touch them until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Then a woman has her monthly menstrual period, no one should touch her for seven days. If anyone touches her during that time, no one should touch the person who touched her until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","No one should touch anything that she lies on or sits on during that time. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Anyone who touches her bed must wash his clothes and bathe, and no one should touch that person until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","23","Anyone who touches something that she has been sitting on, a bed or anything else, must wash his clothes, and no one should touch that person until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“If a man has sex with a woman during that time and some of the menstrual blood touches him, no one should touch him for seven days, and no one should touch the bed that he lies on. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Then a woman has a vaginal discharge of blood for ◄many days/a long time►, which is not her monthly flow of blood, or if her flow of blood continues after her monthly flow ends, no one should touch her until it stops. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","And no one should touch the bed that she lies on or anything that she sits on while that flow of blood continues, just like during her monthly menstrual period. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Anyone who touches those things should not touch anyone else; he must wash his clothes and bathe, and he should not touch anyone else until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“After a woman’s monthly menstrual flow ends, she must wait seven days before she touches anyone. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","On the eighth/next day, she must take two doves or two pigeons to the priest at the entrance of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","The priest will sacrifice one of them to be an offering to enable her to become acceptable to Yahweh again, and completely burn the other one on the altar. By doing that he will cause me, Yahweh, to forgive her for having sinned DOU. ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“You must warn the Israeli people not to do things that ◄defile them/cause them to be unacceptable to me►. If they become ◄unacceptable to me/defiled►, they will cause my Sacred Tent which is among them to become an unacceptable place to worship me, and as a result they will die.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","“Those are the regulations for a man who has a fluid that flows from his sexual organs or who should not be touched because some of his semen spills out while having sex with a woman, ");
INSERT INTO eng_t4t_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","and for any woman during her monthly menstrual period, and for any man who has sex with a woman during her menstrual period.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","After the two sons of Aaron died because they burned incense to Yahweh in a manner that was contrary to what Yahweh commanded, Yahweh spoke to Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","He said to him/me, “Warn your older brother Aaron that he must not enter the Very Holy Place inside the curtain that is in the Sacred Tent whenever he wants to, because the cover of the sacred chest is there. That is the place where the priest ◄makes atonement for/requests me to forgive► sins. I am present in the cloud that is over the cover of the sacred chest. If Aaron goes in that room when it is not the proper time, he will die! ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“When Aaron enters the Sacred Tent area, he must bring a bull that will be killed to become an offering/sacrifice for sins, and a ram to be killed to be an offering that will be completely burned on the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Then he must bathe his whole body, and put on the linen underwear/undershorts and the linen gown. He must tie the linen sash/waistbands around his waist and wrap the turban around his head. Those are his sacred garments. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","The Israeli people must then bring to him two male goats to be killed as an offering/sacrifice for sin, and a ram to be killed and burned completely on the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Aaron must offer the bull to me to be a sacrifice in order that ◄I will forgive his sins and the sins of his family/his sins and the sins of his family will be forgiven►. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Then he must bring the two male goats to me at the entrance to the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","He must ◄cast lots/throw down stones that have been marked► to determine which goat will be sacrificed to me, and which will be the goat that will be set free. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aaron must bring to me the goat that was chosen to be sacrificed. It will be an offering for the people’s sins. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Aaron must also bring to me the other goat, but it is not to be killed. It will be freed while it is still alive. As a result of Aaron sending it into the desert, the people’s sins will be forgiven. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Then Aaron must bring the young bull to me, to be an offering/sacrifice for himself and for his family. He must slaughter that bull to be an offering for their sins, and he must drain the blood into a basin. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Then he must take some burning coals from the bronze altar and put them in the incense burner. Then he must fill his hands with fragrant finely-ground incense. Then he must take the incense and the incense burner inside the curtain into the Very Holy Place of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","There he must put the incense on the burning coals, with the result that a cloud of burning incense will rise up over the lid of the sacred chest. If he obeys these instructions, he will not die like Korah’s two sons did because of offering incense incorrectly (OR, because of being in God’s presence). ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Then he must dip his finger into the basin and sprinkle some blood on the lid of the sacred chest, and also sprinkle some blood seven times against the front of the chest. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Aaron must then go outside the Sacred Tent and slaughter the goat to be an offering for the sins of the people. Then he must bring its blood into the Very Holy Place behind the curtain. There he must sprinkle some of that blood on the lid of the sacred chest and against the front of the chest, like he did with the bull’s blood. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","By doing that, he will purify the Very Holy Place. And he must sprinkle more of the blood on the Sacred Tent, because the tent is in the midst of the camp of the Israeli people who have become unacceptable to me because of their sins. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","When Aaron goes into the Very Holy Place in the Sacred Tent to purify it, no one else is permitted to enter the other part of the Sacred Tent. Only after Aaron has performed rituals to enable me to forgive him and his family, and all the Israeli people, is any priest permitted to enter the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Then Aaron must go outside the tent to purify my altar. He must do this by smearing some of the blood from the bull and some of the blood from the goat on each of the projections at the corners of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Then Aaron must dip his finger into the basin of blood and sprinkle some of the blood over the altar seven times. By doing that, he will cleanse it from being unholy because of the sins of the Israeli people, and it will become holy again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“When Aaron has finished purifying the Very Holy Place inside the Sacred Tent and all of the Sacred Tent and the altar, he must bring the goat that was chosen to be set free. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","He must put both of his hands on the head of the goat and confess all the sins DOU of the Israeli people. By doing that, he will put the guilt of their sins on the head of the goat. Then he must give the goat to a man who is chosen, and that man will send the goat out into the desert. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","It is as though the goat will carry away into the desert the guilt for the sins of all the people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“When Aaron approaches the Sacred Tent, he must take off the linen clothes that he wore when he previously entered the Very Holy Place, and he must leave those clothes there. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Then he must bathe in a sacred place, put on his regular/ordinary clothes, and sacrifice the animals that will be burned completely on the altar for his own sins and for the sins of the Israeli people. By doing that he will enable me to forgive him and them. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","He must also burn on the altar all the fat of the bull and the goat that were sacrificed. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“The man who was chosen to send the other goat into the desert and free it there must afterwards wash his clothes and bathe. Then he may return to the camp. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","The carcasses of the bull and the goat that were slaughtered to be an offering/sacrifice for the people’s sins, whose blood was taken inside the Very Holy Place to enable Yahweh to forgive the Israeli people, must be carried outside the camp and burned. The hides/skins of the animals, the inner organs, and the dung must also be burned. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","The man who burns those things must then wash his clothes and bathe before he returns to the camp. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“On ◄October/the month after the dry season ends►, on the day that I have appointed, you all must ◄fast/abstain from eating food► and not do any work. This is a rule/law that will never end. It must be obeyed by you people who have been Israelis all your lives, and also by foreigners who are living among you. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","On that day, Aaron will perform rituals to enable me to forgive you all, and then I will cleanse/free you all from the guilt of all your sins and you will become acceptable to me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","That will be a day for you to rest and not do any work, like the Sabbath days, and you must ◄fast/abstain from eating food► all that day. That is a permanent command/law for you all to obey. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","In future years, after Aaron has died, this ritual/ceremony to enable me to forgive you all DOU will be performed by the Supreme Priest who is anointed with olive oil and appointed to serve instead of his ancestor Aaron. He must put on the sacred clothes made of linen ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","and offer sacrifices to purify the Very Holy Place, all of the Sacred Tent, the altar, the priests, and all the Israel people like Aaron did. ");
INSERT INTO eng_t4t_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","This will be a permanent command/law for you to obey once every year, to enable me to forgive you Israeli people for the sins that you have committed.” Moses/I obeyed all those instructions/commands that Yahweh had given to him/me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Speak to Aaron and his sons and to all the other Israeli people, and say this to them: ‘This is what Yahweh has commanded: ");
INSERT INTO eng_t4t_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","If you sacrifice an ox or a lamb or a goat, you must bring it to the priest at the entrance of the Sacred Tent area, to present/offer it to me there. ");
INSERT INTO eng_t4t_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","If you slaughter it to be a sacrifice anywhere else in the camp or outside the camp, you will be guilty of killing an animal in an unacceptable place. As a result you will no longer be allowed to be/associate with my people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","That rule is in order that you Israeli people, instead of offering sacrifices in the open fields, will offer them to me by taking them to the priest at the entrance of the Sacred Tent area, to be offerings to maintain fellowship with me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","After the animal is slaughtered, the priest must sprinkle some of its blood against the altar at the entrance of the Sacred Tent, and burn its fat to be an aroma that is pleasing to me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","You people must no longer give sacrifices to the demons that resemble goats which you are worshiping. You people must obey this command forever.’ ");
INSERT INTO eng_t4t_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“And tell this to the people: ‘If any Israeli or any foreigner who is living among them brings an offering that is to be completely burned on the altar, or any other sacrifice, ");
INSERT INTO eng_t4t_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","and does not bring it to the entrance of the Sacred Tent area to be a sacrifice to me, that person will no longer be allowed to associate with my people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","‘I will reject IDM any Israeli or any foreigner who is living among you who eats any blood, and I will command that he no longer be allowed to associate with my people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","That is because the life of every creature is in its blood; I have declared that it is blood that is to be offered on the altar to enable people to be forgiven for their sins. ");
INSERT INTO eng_t4t_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","That is why I say that you Israelis must not eat blood, and the foreigners who live among you must also not eat blood. ");
INSERT INTO eng_t4t_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","‘Any Israeli or any foreigner who is living among you who hunts any animal or bird that is permitted for you to eat, must drain out the blood of the animal or bird that he kills, and cover the blood with dirt. ");
INSERT INTO eng_t4t_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","This is because the life of every creature is in its blood. And that is why I have said DOU to you Israelis that anyone who eats blood must no longer be allowed to associate with my people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","‘Anyone in Israel, including foreigners, who eats any of the meat of any creature that is found dead, or that had been killed by wild animals, must wash his clothes and bathe. Then he must not touch anyone until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","If he does not do those things, he will be punished for what he did.’” ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Speak to the Israeli people and tell them that I, Yahweh, say this this: I am Yahweh, your God. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","So you must do what I want you to do; you must not do the things that the people in Egypt, where you lived previously, do; and you must not do what is done by the people in Canaan, the land to which I am taking you. Do not imitate their behavior. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","You must obey all of my laws DOU, because it is I, Yahweh your God, who am commanding those laws. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","If you obey all my laws and decrees, you will continue to remain alive for a long time. I, Yahweh, am the one who is promising that to you. These are some of my laws: ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“Do not have sex with any of your close relatives. It is I, Yahweh, who am commanding that. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“Do not disgrace your father by having sex with your mother DOU. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“Do not have sex with any of your father’s other wives, because that would disgrace your father. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“Do not have sex with your sister or your stepsister; it does not matter whether she was born in your house or somewhere else. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“Do not have sex with your granddaughter, because that would disgrace you. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“Do not have sex with your half-sister, because she is your sister. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“Do not have sex with your father’s sister, because she is your father’s close relative. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“Do not have sex with your mother’s sister, because she is your mother’s close relative. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“Do not disgrace your ◄uncle/father’s brother► by having sex with his wife, because she is your aunt. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“Do not have sex with DOU your daughter-in-law, because she is your son’s wife. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“Do not have sex with your brother’s wife, because that would disgrace your brother. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“Do not have sex with the daughter or granddaughter of any woman whom you have previously had sex with; they are her (OR, your) close relatives. Having sex with any of them would be a wicked thing to do. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“While your wife is still living, do not marry your wife’s sister and have sex with her. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Do not have sex with any woman while she is having her monthly menstrual period. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“Do not ◄defile yourself/make yourself unacceptable to me► by having sex with someone else’s wife. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“Do not give any of your children to be burned to be a sacrifice to the god Molech, because that would show that you do not revere me MTY, Yahweh, your God. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“No man should have sex with another man; that is detestable. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“No one, man or woman, should ◄defile himself/cause himself to become unacceptable to me► by having sex with an animal; that is a perverse act. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Do not ◄defile yourselves/cause yourselves to become unacceptable to me► in any of those ways, because doing those things is how the people of the nations that I expelled as you advanced became ◄unacceptable to me/defiled►. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","They even caused the land to become defiled, so I punished them for their sins, and it was as though the land vomited out the people who lived there. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","You must all obey my laws and decrees. That includes you people who were born here and the foreigners who live among you. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","All those detestable things were done by the people who lived in this land before you came here, and they caused the land to become defiled. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","So if you defile the land, I will get rid of MET you like I got rid of the people of those nations that were here before you came. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“You must not allow people who do any of those detestable things to associate with you who are my people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Obey everything that I command you to do, and do not defile yourselves by practicing any of the detestable customs that were practiced by the people who were there before you came. I, Yahweh your God, am the one who is commanding these things.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Speak to all the people of Israel and tell them this: You must be holy, because I, Yahweh your God, am holy, and I want you to be like me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","‘Each of you must respect your father and your mother. And you must ◄honor/treat respectfully► the Sabbath days. I am Yahweh, your God, and that is what I am commanding you to do. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","‘Do not worship idols or make metal statues of gods for yourselves. I am Yahweh, your God, and I am the only one you must worship. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","‘Then you bring an offering to maintain fellowship with me, offer it in a way that will cause me to accept it. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","The meat should be eaten on the day that you sacrifice it, but you are permitted to eat some of it on the next day. Anything that remains until the third/next day must be completely burned. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","For any of it to be eaten on the third day is very displeasing to me, and I will not accept that offering. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","I will punish anyone who eats it after the second day, because he will not have respected that what I say is holy. And that person must no longer be allowed to associate with my people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","‘Then you harvest your grain, leave the grain at the very edge of the field, and do not pick up the grain that has fallen on the ground. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","And when you harvest your grapes, do not go back a second time to try to harvest some more, and do not pick up the grapes that have fallen on the ground. Leave those things for the poor people and for foreigners who are living among you. I, Yahweh your God, am commanding those things. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","‘Do not steal anything. ‘Do not tell lies. ‘Do not deceive each other. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","‘Do not show that you do not respect me by using/saying my name to falsely promise that you will do something. Do not forget that I am Yahweh, your God. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","‘Do not cheat anyone or steal from anyone. ‘If you have agreed to pay your workers at the end of the day, do what you have promised; do not keep those wages until the next day. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","‘Do not curse deaf people, and do not put things in the path of blind people to cause them to stumble. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","‘Always LIT judge people fairly DOU. Do not do special favors for either poor people or rich people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","‘Do not spread false rumors about other people. ‘Do not say anything in court that would result in some innocent person being executed. I, Yahweh, am commanding this. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","‘Do not hate anyone. Instead, honestly rebuke those who ought to be rebuked, in order that you also will not be guilty. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","‘Do not try to get revenge against someone or be angry with someone for a long time. Instead, love other people like you love yourself. I, Yahweh your God, am commanding this. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","‘Obey my laws. ‘Do not allow two different kinds of animals to mate with each other. ‘Do not plant two different kinds of seed in the same field. ‘Do not wear clothing made from two different kinds of material. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","‘If a man has sex with a slave woman who has been promised to marry some other man, but she has not been bought by that man and is still a slave, the man who had sex with her must be punished. But because she is still a slave, she and the man who had sex with her must not be killed. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","However, that man must bring a ram to be slaughtered at the entrance of the Sacred Tent area, to be an offering in order that he no longer be guilty for his sin. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","The priest will offer that ram to me in order that the man will be forgiven for the sin that he committed, and I will forgive him. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","‘When you enter the land that I have promised to give to you, and when you plant various kinds of fruit trees, you must not eat any of their fruit for three years DOU. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","In the fourth year all of their fruit must be set aside to belong to me; it must be brought to me to be an offering to praise me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","But in the fifth/next year, you will be permitted to eat their fruit. If you do that, your trees will produce much fruit. I, Yahweh your God, am promising that. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","‘Do not eat any meat that still has the animal’s blood in it. ‘Do not consult spirits to find out what will happen in the future, and do not practice sorcery. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","‘Do not shave the hair at the sides of your heads like pagan people do. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","‘Do not cut your bodies when you are mourning for people who have died, and do not put tattoos on your bodies. I, Yahweh your God, am commanding this. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","‘Do not disgrace your daughters by forcing them to become prostitutes. If you cause them to become prostitutes, soon the land will be filled with prostitutes and all other kinds of people’s wicked behavior. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","‘Honor my Sabbath days and revere my Sacred Tent, because I, Yahweh, live there. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","‘Do not seek advice from those who ◄consult/talk with► the spirits of dead people DOU, because if you do that, they will defile you. I, Yahweh your God, am the one you should consult. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","‘Stand up when old people enter the room, and show that you respect them, and also revere me, your God; that is what I, Yahweh, am commanding. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","‘When foreigners live among you in your land, do not mistreat them. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","You must treat them like you treat your fellow-citizens. Love them like you love yourselves, and do not forget that once, when you were foreigners in Egypt, you were badly mistreated by the people of Egypt. I, Yahweh your God, am commanding you to do this. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","‘When you are measuring things, to see how long they are or how much they weigh or how many there are, ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","use correct measuring sticks and scales and weights on the scales and measuring baskets and other measuring containers. I Yahweh, your God, who brought you out of Egypt, am giving you these laws. ");
INSERT INTO eng_t4t_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","‘Obey carefully DOU all my laws and decrees, because I, Yahweh, am the one who am commanding them.’ ” ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Yahweh also said this to Moses/me: ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Tell the Israeli people, ‘This is what Yahweh says: Any Israeli or any foreigner who is living in Israel who sacrifices any of his children to be an offering to the god Molech must be executed. The people of the town must kill him by throwing stones at him. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","I will reject IDM such people and command that they no longer be allowed to associate with my people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","If the people of that man’s town ignore it when he kills one of his children to offer him as a sacrifice to Molech, and if they do not execute that person, ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","I myself will punish that person and his family, and I will command that he no longer be able to associate with my people. And I will do the same thing to any others who do the same thing that he did to worship Molech. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","‘ will reject IDM those who go to those who ◄consult/talk with► the spirits of dead people and fortune-tellers to seek advice from them. I will command that they no longer be allowed to associate with my people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","‘Set yourselves apart and be holy, because I, Yahweh your God, am holy, and I want you to be like me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Obey carefully DOU all my laws. I am Yahweh, the one will cause you to be holy. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","‘If anyone curses his father or his mother, he must be executed. He himself will be responsible for his own death MTY. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","‘If a man commits adultery with some other man’s wife, both of them, the man and the woman, must be executed. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","‘If a man has sex with EUP one of his father’s wives, he has disgraced his father. So both that man and that woman must be executed, they will be responsible for their own deaths MTY. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","‘If a man has sex with EUP his daughter-in-law, both of them must be executed. What they have done is very perverse; and they will be responsible for their own deaths MTY. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","‘If two men have sex together, they have done something detestable. They must both be executed, they will be responsible for their own deaths MTY. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","‘If a man marries both a woman and her mother, that is a wicked thing. All three of them must be burned to death, in order that such a wicked practice will not continue to be done among you. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","‘If a man has sex with an animal, he must be executed, and you must also kill that animal. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","‘Similarly, if a woman has sex with an animal, both the woman and that animal must be killed DOU; they are responsible for their own deaths MTY. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","‘If a man marries his sister, the daughter of either his mother or his father, and they have sex together, that is disgraceful. They must not be allowed to continue to associate with my people. And because he has disgraced his sister, he must be punished. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","‘If a man has sex with EUP, DOU a woman during her monthly menstrual period, they have both revealed why she was bleeding, so both of them must not be allowed to associate with my people any more. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","‘Do not have sex with the sister of either your father or your mother, because that would be disgracing someone who is a close relative. And you and the woman must both be punished. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","‘If a man has sex EUP with his aunt, he has dishonored his uncle. I will punish both of them by causing them to die without having any children. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","‘If a man marries his brother’s wife while his brother is still living, that is disgraceful. He has dishonored his brother; and they both will die without having any children. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","‘Obey all my laws/decrees DOU carefully, in order that you will not be forced to leave MET the land to which I am bringing you. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Do not imitate/adopt the customs of the people of the land from which I will expel them as you advance. I hated them because they did all those things. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","But I said to you, “You will take their land from them; I will give it to you to be yours, a land that is very fertile IDM. I am Yahweh your God, who has set you apart from the people of other nations.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","‘So you must distinguish between birds and animals that are unacceptable to me and those that are acceptable to me. Do not defile yourselves by eating birds or animals, or anything that scurries across the ground, that I have said are unacceptable for you. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","You must behave in ways that I consider to be holy, because I, Yahweh, am holy, and I have set you apart from the ungodly people of other nations to belong to me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","‘You must execute any man or woman among you who ◄consults/talks with► the spirits of dead people or who is a fortune-teller. Kill them by throwing stones at them; but they will be responsible for their own deaths.’” ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Yahweh also said to Moses/me, “Speak to the priests, the sons of Aaron, and say to them, ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","‘You priests must not cause yourselves to become unfit to do my work by touching corpses. Priests are permitted to touch only the corpses of close relatives, such as the priest’s mother or father or his son or daughter or his brother. ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Priests are also permitted to touch the corpse of a sister if she is not married, because she has no husband to bury her body. ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Priests must not cause themselves to become unfit to do my work DOU by touching corpses of people who were married to one of their close relatives. ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","You priests must not shave your heads or shave the edges of your beards or cut your bodies to show that you are mourning for someone who has died. ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","You must act in ways that I, your God, consider to be holy, and not disgrace my name/reputation. You are the ones who present to me the offerings that are burned. It is as though those offerings are food for me, your God; so you must act in ways that are holy. ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","You priests must not marry women who have been prostitutes or who have been divorced from their husbands, because you priests are ◄set apart for me/holy►. ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","You must consider that you are holy, because you offer food to me, your God. Consider yourselves to be holy because I, Yahweh, the one who caused you to be priests and  the one who enables you to be holy, am holy. ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","If a priest’s daughter disgraces herself by becoming a prostitute, she disgraces her father; and she must be killed by being burned in a fire. ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","The Supreme Priest is the one among his relatives who has been appointed for that work by having his head anointed with olive oil. He is also the one who has been appointed to wear the special garments that priests wear. He must not allow the hair on his head to remain uncombed, and he must not tear his clothes when he is mourning for someone. ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","He must not enter some place where there is a corpse. He must not do that and cause himself to become unfit for his work, even if it is his father or his mother who has died. ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","He must not leave the Sacred Tent to join those who are mourning, because he would cause himself to become unfit for his work and would also defile/desecrate the Sacred Tent. He must not leave the Sacred Tent at that time, because by being anointed with olive oil he has been ◄appointed/set apart► to serve his God in the Sacred Tent. I, Yahweh, am the one who am commanding this. ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Women whom you priests marry must be virgins. ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","15","You priests must not marry widows or prostitutes or divorced women, because if you did that, if you later have sons, they would not be acceptable to be priests among your people. You must marry only virgins from among your own people. I am Yahweh, who sets priests apart to be holy.’” ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Say this to Aaron: 'For all future time, none of your descendants who has any defects on his body will be allowed to come near the altar to offer sacrifices to me which will be like MET my food: ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","No one who is blind or lame or deformed, or whose face is disfigured, ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","no man with a crippled foot or a crippled hand, ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","no man who is a hunchback or a dwarf, no man whose eyes are defective, no man who has a skin disease DOU or whose testicles have been damaged is allowed to brings sacrifices. ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","No descendant of Aaron, the first Supreme Priest, who has any defect is allowed to come to the altar to offer to me, his God, sacrifices that will be burned. ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Priests who have defects are permitted to eat the various kinds of holy food offered to me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","But because of their defects, they must not go near the curtain in the Sacred Tent or near the altar, because if they did that, they would desecrate my Sacred Tent. I am Yahweh, the one who sets those places apart as being holy.' ” ");
INSERT INTO eng_t4t_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","So Moses/I told this to Aaron and to his sons and to all the Israeli people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Tell Aaron and his sons to greatly respect the sacred offerings that the Israeli people bring to me; by doing that you will respect me MTY, Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Tell them that for all future time, if any of their descendants comes near to the sacred offerings that the Israeli people dedicate to me while he is unfit to work for me, that person will no longer be allowed to work for me. I, Yahweh, am commanding this. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“If any descendant of Aaron has a contagious skin disease or a discharge from his sexual organs, he is not allowed to eat any of the sacred offerings until he is cured. He will also be unfit for his work if he touches anything which has become unacceptable to me because it has touched a corpse, or if he touches anyone who as an emission of semen, ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","or if he touches anything that crawls on the ground, or if he touches any person who causes him to be unfit for his work. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Any priest who touches such things must bathe, and he must not touch anyone else until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","After the sun sets, he will be permitted to eat some of the sacred offerings that are for him to eat. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","He must not eat anything that is found dead or that has been killed by wild animals, because if he did that, he would be unfit to work for me. I, Yahweh am commanding those things. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“The priests must obey my commandments in order that they will not become guilty and die as a result of ◄despising/not obeying► them. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Anyone who is not a member of a priest’s family is not permitted to eat any of a sacred offering, and no one who is visiting the priest or whom the priest has hired is permitted to eat it. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","But if a priest buys a slave, or if a slave is born in his house, that slave is permitted to eat such food. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","If a priest’s daughter marries a man who is not a priest, she no longer is permitted to eat the sacred food. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","But if a priest’s daughter who has no children becomes a widow or becomes divorced, if she returns to her father’s house to live there like she did when she was young, she may eat the same food that her father eats. But no other person is permitted to eat any of it. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“If anyone who is not permitted to eat a sacred offering eats it without realizing that it is sacred, he must pay the priest for the offering, and pay him an extra one-fifth of its value. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","When the priests bring offerings to me, the sacred offerings that the Israeli people bring to them, they must not treat those offerings as though they are not sacred ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","by allowing those who are not priests to eat any of those offerings. If they did that, they would become guilty and must make a payment. I am Yahweh, the one who causes those offerings to be sacred.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Speak to Aaron and his sons and to all the Israeli people and tell them that I command this: ‘If any of you Israelis or foreigners who live in Israel brings to me an animal that will be completely burned on the altar, either as a result of a solemn promise that you made to me or to be an offering that is given voluntarily, ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","it must be an animal that has no defects, in order that it will be accepted by me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Do not bring any animals that have defects, because I will not accept them as an offering from you. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Similarly, when someone brings from his cattle or sheep or goats an offering to maintain fellowship with me, either to fulfill a promise that he made to me or to be a voluntary offering, in order that I will accept it, it must have no defects DOU or blemishes. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Do not offer to me animals that are blind or injured or maimed/crippled, or any animal that has warts or a festering sore DOU. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","You may present to me to be a voluntary offering an ox or a sheep that is injured or stunted, but it will not be accepted to fulfill a promise made to me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","You must not offer to me animals whose testicles are bruised or crushed or torn or cut. You must not injure the testicles of any animal in your land, ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","and you must not accept such animals that are sold/given to you by a foreigner. You must not offer them to me as a sacrifice for me. Such animals will not be accepted by me, because they are deformed or have defects.’” ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“When a calf or lamb or goat is born, it must remain with its mother for seven days. After that, it will be acceptable as an offering to me that will be burned. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Do not slaughter a cow or a sheep and its baby on the same day. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Then you sacrifice an animal to thank me for what I have done, sacrifice it in a way that is acceptable to me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","The meat must be eaten on that day; do not leave any of it until the next morning. I, Yahweh, am the one who am commanding this. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Obey all my commands DOU. I, Yahweh, am commanding them; ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","do not dishonor me MTY by disobeying them. You Israeli people must acknowledge that I, Yahweh, am holy, and I am the one who causes you to be holy. ");
INSERT INTO eng_t4t_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","And I am the one who brought you out of Egypt in order to show that that I, Yahweh, am and will always be your God.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Tell the Israeli people about the festivals that I have chosen, the days when you all must gather together to worship me.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“You may work for six days each week, but on the seventh day you must not do any work. You must rest. It is a sacred/holy day when you must gather together to worship me. Wherever you live, you must rest on that day.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“There are festivals that I have established for you. Those will also be sacred/holy days when you must gather together to worship me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","The first festival is ◄the Passover/when you remember that I spared your ancestors when I killed all the firstborn Egyptian sons►. That festival will begin at twilight/dusk/sunset on the chosen day ◄each spring/in March or April each year►, and end on the following day. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","The next day, the Festival of Eating Bread That Has No Yeast will begin. That festival will continue for seven days. During that time, the bread that you eat must be made without yeast. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","On the first day of that festival, you all must stop your regular work and you must gather together to worship me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","On each of the seven days, you must present to me several animals to be an offering/sacrifice to be completely burned on the altar. On the seventh day, you all must again stop your regular work and gather to worship me.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Yahweh also told Moses/me ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","to tell the Israeli people about other festivals. He said, “When you arrive in the land which I am giving to you, and you harvest your crops for the first time there, bring to the priest some of the first grain that you harvest. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","On the day after the next Sabbath/rest day, the priest will lift it up high to dedicate it to me, in order that I will accept it as your gift. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","That same day, you must sacrifice to me a one-year-old male lamb that has no defects. You must burn it on the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","You must also burn an offering of grain. That offering must consist of ◄three quarts/3.5 liters► of good flour mixed with olive oil. The smell of those things burning will be very pleasing to me. Along with that, you must also offer one quart/liter of wine, which will be a liquid offering. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Do not eat any bread or any roasted grain or unroasted grain on that day until after you have brought those offerings to me, your God. You must always obey LIT those commands, wherever you live.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“Seven weeks after the priest offers that grain to me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","on the next/50th day after he offers it, each family must bring to me an offering from the new crop of grain. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","From your homes, bring two loaves of bread to the priest. He will lift them up high to dedicate them as an offering to me. Those loaves must be baked from three quarts/liters of good flour that has yeast mixed with it. That bread will be an offering to me from the first wheat that you harvest each year. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Along with this bread, you must present to me seven one-year-old lambs with no defects, one young bull, and two rams. They must all be completely burned on the altar. All those offerings, with the grain offering and the wine offering, will be burned, and the smell of all those things burning will be very pleasing to me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Then you must also kill one male goat to be an offering/sacrifice for your sins, and two one-year-old male lambs to be an offering to enable you to maintain fellowship with me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","The priest will lift up these offerings high to dedicate them to me. He will also offer the loaves of bread that were baked from the first wheat that you harvest. Those offerings are sacred to me, but they are for the priests to eat. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","On that day, you must stop your regular work and gather to worship me. You must always obey those instructions/commands, and you must obey them wherever you live. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“When you harvest the grain in your fields, do not harvest the grain along the edges of the fields, and do not pick up the grain that the harvesters drop. Leave that grain for the poor people and for the foreigners who are living among you. Do not forget that it is I, Yahweh your God, who am commanding those things!” ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Yahweh also told Moses/me ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","to give these instructions/commands to the Israeli people: “Each year in September, on the day that I have chosen, you all must celebrate it by completely resting. You must not do any work on that day. When the priests blow their trumpets loudly, you all must gather together to worship me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","All of you must not do your regular work on that day. Instead, you must present offerings to me that will be burned on the altar.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“You must celebrate a day on which you request that I forgive you for the sins that you have committed. That day will be nine days after the festival when the priests blow the trumpets. On that day you must ◄fast/abstain from eating food►. You must gather together to worship me and present offerings to me that will be burned on the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","You must not do any work on that day, because it is the day when the priests will offer sacrifices to me to ◄atone for/ask me to forgive► your sins. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","You must expel from your group anyone who does not ◄fast/abstain from eating food► on that day. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","I will get rid of anyone who does any kind of work on that day. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","You must not work at all! You must always obey those instructions/commands, and you must obey them wherever you live. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","That day will be a day of complete rest for all of you, and on that day you must ◄fast/abstain from eating food► to show that you are sorry for having sinned. That day of rest and ◄fasting/abstaining from eating food► will begin on the evening before the day in which you ask me to forgive you for your sins, and it will end on the evening of the following day.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Tell the Israeli people that each year they must also celebrate a festival of living in temporary shelters. That festival will begin five days after the day in which they request me to forgive them for their sins. It will last for seven days. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","On the first day of that festival, the people must gather together to worship me, and they must not do any regular work on that day. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","On each of the seven days of the festival, they must present to me an offering of animals that will be burned on the altar. On the next day, they must gather again to worship me and present to me another animal that will be burned on the altar. That also will be a sacred gathering, and they must not work on that day, either. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“To summarize, those are the festivals that I have appointed. Celebrate those sacred festivals by gathering together to present to me all the various offerings that will be burned on the altar—animals that will be burned completely, and offerings of grain, and offerings to enable the Israeli people to maintain fellowship with me, and offerings of wine. Each offering must be brought on the day that I have indicated. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","◄Those festivals must be celebrated/You must celebrate those festivals► in addition to worshiping on the ◄Sabbath days/days of rest►. And all those offerings must be given in addition to the offerings that people personally decide to give, and in addition to the offerings that people make to accompany the solemn promises that they have made, or offerings that people make ◄voluntarily/because they themselves want to►. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Returning to my instructions about the Festival of Living in Temporary Shelters, you must celebrate this festival after you have harvested all the crops. On the first day and on the last day of that festival, you must rest completely. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","But on the first day, you are permitted to pick fruit from trees. Cut palm fronds/branches and other leafy branches from trees or from bushes that grow by the streams, and make shelters/huts to live in for that week. Then rejoice in my presence for those seven days. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","You must celebrate this festival for seven days every year. You must never stop obeying my commands/instructions for that festival. You must celebrate it in September. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","During the seven days of that festival, all of you people who have been Israelis your entire lives must live in shelters/huts. ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","That will remind your descendants that their ancestors lived in shelters for many years after I rescued them from Egypt. Do not forget that I, Yahweh your God, am the one who is commanding this.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","So Moses/I gave to the Israeli people all those instructions concerning the festivals that Yahweh wanted them to celebrate each year. ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Command the Israeli people to continually bring to you clear oil made from pressed olives to burn in the lamps in the Sacred Tent, in order that those lamps will burn all the time. ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Outside the curtain of the Very Holy Place, Aaron must take care of the lamps in my presence continually, in order that they will burn all during the night. That regulation must be obeyed forever. ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Those lampstands that burn in my presence must be taken care of continually. ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Also, each week you must take some fine flour and bake twelve very big loaves of bread, using about four quarts/liters of flour for each loaf. ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Put the loaves in two rows, with six loaves in each row, on the table covered with pure gold, in my presence. ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Along each row, place in some gold cups some pure incense to be burned to be an offering to me instead of the bread. ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","New/Fresh loaves of bread must be put on the table each Sabbath day, to signify the agreement that will never end, that I have made with you Israeli people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","The bread that is taken off the table belongs to Aaron and his sons. They must eat it in a holy place, because it is a very holy part of the offerings that are given to me by being burned.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","There was a man whose mother’s name was Shelomith; she was an Israeli whose father was Dibri from the tribe of Dan. And that man’s father was from Egypt. One day that man and another Israeli man started to fight inside the camp. And while they were fighting, that man cursed Yahweh MTY. ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","So the Israeli people seized him and guarded him until they could find out what Yahweh would reveal to them that they should do to that man. ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Then Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Tie up and take outside the camp the man who has cursed me. There all those who heard what he said must put their hands on his head to indicate that he is guilty, and then all the people must kill him by throwing stones at him. ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Tell the Israelis, ‘If anyone curses me, he must ◄endure the consequences/be punished►. ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","So anyone who curses me MTY must be executed. All the people must throw stones at him. It does not matter if he is a foreigner or an Israeli citizen; anyone who curses me must be executed.’ ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Also, If anyone murders another person, he must be executed. ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","And anyone who kills another person’s animal must give that person a live animal to replace the one that he killed. ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","And if one person injures another person, the injured person is allowed to injure the person who injured him in the same way: ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","If someone breaks one of another person’s bones, that person is allowed to break one of the bones of the person who injured him. If someone gouges out an eye of another person, that person is allowed to gouge out the eye of the person who injured him. If someone knocks out the tooth of another person, that person is allowed to knock out one of his teeth. What is done to the offender must be the same as what he did to the other person. ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Whoever kills another person’s animal must give that person a live animal to replace the one that he killed, but anyone who murders another person must be executed. ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","That law applies to you Israelis and and also to the foreigners who live among you; I, Yahweh your God am the one who has commanded it.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Then Moses/I told the Israelis what they must do to the man who cursed Yahweh, so they took the man outside the camp and killed him by throwing stones at him. They did what Yahweh commanded Moses/me to tell them to do. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Yahweh said to Moses/me on Sinai Mountain, ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Tell the Israelis that I, Yahweh, say this: When you enter the land that I am about to give you, every seventh year you must honor me by not planting any seeds. You will be allowing the ground to rest. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","For six years you are to plant seeds in your fields and prune your grapevines and harvest the crops. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","But the seventh/next year you must dedicate to me, and allow your fields to rest. Do not plant seeds in your fields or prune your grapevines during that year. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Do not reap the grain that grows in your fields without having been planted, or harvest the grapes that grow without the vines being pruned; you must allow the land to rest for that one year. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","But you are permitted to eat whatever crops grow by themselves during that year without having been planted. You and your male and female servants, and workers whom you have hired, and people who are living among you temporarily are permitted to eat it. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Also, during that year your livestock and the wild animals in your land are permitted to eat it.’ ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","9","‘Also, after every 49 years has ended, you must do this: ◄On the tenth day of the seventh month/At the end of September► of the next/50th year, blow trumpets throughout the country, to declare that it will be a day on which you request that I forgive you for the sins that you have committed. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Set apart that year, and proclaim that throughout the country, it will be a year of restoring the land and freeing people: All the people who sold their property will receive back the property that they previously owned, and slaves must be ◄freed/allowed to return to their property and their families►. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","That year will be a Year of Celebration; during that year do not plant anything, and do not harvest in the usual way the grain/wheat that grows without having been planted, or the grapes that grow without the vines being pruned. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","It will be a Year of Celebration, so eat only what grows in the fields ◄by itself/without any work being done to produce anything►. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","‘In that Year of Celebration, everyone must return to their own property. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","‘If you sell some of your land to a fellow Israeli or if you buy some land from one of them, you must treat that person fairly: ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","If you buy land, the price that you will pay will depend on the number of years there will be until the next Year of Celebration. If someone sells land to you, he will charge a price that is determined by the number of years until the next Year of Celebration. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","If there will be many years before the next Year of Celebration, the price will be higher; if there will be only a few years until the next Year of Celebration, the price will be lower. You could say that what he is really selling you is the number of crops which you can harvest before the next Year of Celebration. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Do not cheat each other; instead, revere me. I, Yahweh your God, am the one who am commanding this. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","‘Obey all my laws DOU carefully. If you do that, you will continue to live safely in your country DOU. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","And crops will grow well on the land, and you will have plenty to eat. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","But you may ask, “If we do not plant or harvest our crops during the seventh year, what will we have to eat?” ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","My answer is that I will bless you very much during the sixth/previous year, with the result that during that year there will be enough crops to provide food for you for three years! ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Then, after you plant seed during the eighth/next year and wait for the crops to grow, you will eat the food grown in the sixth year, and continue to eat it until more food is harvested in the ninth year! ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","‘You must not sell any of your land to belong to someone else permanently, because the land is not yours, it; is really mine, and you are only living on it temporarily and ◄farming/taking care of► it for me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Throughout the country that you will possess, you must remember that if someone sells some of his land to you, he is permitted to buy it back from you if he wants to. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","‘So, if one of your fellow Israelis becomes poor and sells some of his property to obtain some money, the person who is most closely related to him is permitted to come and buy that land for him. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","However, if a man has no one to buy the land for him, and he himself prospers again and saves enough money to buy that land back, ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","he must calculate how many years there will be until the next Year of Celebration. Then he must pay to the man who bought the land the money that he would have earned by continuing to grow crops on that land for those years. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","But if the original owner does not have any money to buy the land that he sold, it will continue to belong to the man who bought it, until the next Year of Celebration. In that year it must be returned to its original owner, and he will be able to live on it again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","‘If someone who lives in a city that has a wall around it sells a house there, during the next year he will be permitted to buy it from the man who bought it. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","If he does not buy it during that year, it will belong permanently to the man who bought it and to his descendants. It must not be returned to the original owner in the Year of Celebration. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","But houses that are in villages that do not have walls around them are considered to be as though they are in a field. So if someone sells one of those houses, he is permitted to buy it back at any time. And if he does not buy it, it must be returned to him in the Year of Celebration. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","‘If any descendants of Levi sell their houses in the towns in which they live, they are permitted to buy them back at any time. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","And because the houses in their towns are on land that was given to them by other Israelis, that land will become theirs again in the Year of Celebration if they do not buy it back before then. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","But the pastureland near their towns must not be sold. It must belong to the original owners permanently/forever. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","‘If one of your fellow Israelis becomes poor and is unable to buy what he needs IDM, others of you must help him like you would help a foreigner who is living among you DOU temporarily. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","If you lend money to him, do not charge any kind of interest DOU. Instead, show by what you do that you revere me, your God, and help that man, in order that he will be able to continue to live among you. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","If you lend him money, do not charge interest; and if you sell food to him, charge him only what you paid for it; do not get a profit from it. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Do not forget that I am Yahweh your God, who brought you out of Egypt to be your God and to give you the land of Canaan, and I did not charge you for doing that. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","‘If one of your fellow Israelis becomes poor and sells himself to you, do not force him to work like a slave. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Treat him like you treat workers that you hire or like someone who is living on your land temporarily. But he must work for you only until the Year of Celebration. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","During that year, you must free him, and he will go back to his family and to the property that his ancestors owned. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","It is as though you Israelis are my slaves/servants, whom I freed from being slaves in Egypt. So none of you should be sold to become slaves. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","And do not treat the Israelis whom you buy cruelly; instead, revere me, your God. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","‘If you want to have slaves, you are permitted to buy them from nearby countries. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","You are also permitted to buy some of the foreigners who are living among you, and members of their clans that were born in your country. Then you will own them. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","They will be your slaves for the remaining years of your life, and after you die, it is permitted for your children to own them. But you must not act in brutal ways toward your fellow Israelis. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","‘If a foreigner who is living among you DOU becomes rich, and if one of your fellow Israelis becomes poor and sells himself to that foreigner or to a member of his clan/family, ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","it is permitted for someone to pay for him to be freed. It is permitted for one of his relatives to pay for him to be released: ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","An uncle or a cousin or another relative in his clan may pay for him to be released. Or, if he prospers and gets enough money, he is permitted to pay for his own release. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","The man who wants to pay for his own release must count the number of years until the next Year of Celebration. The price he pays to the man who bought him will depend on the pay that would be given to a hired worker for that number of years. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","If there are a lot of years that remain until the Year of Celebration, he must pay for his release a larger amount of the money. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","If there are only a few years that remain until the Year of Celebration, he must pay a smaller amount to be released. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","During the years that he is working for the man who bought him, the man who bought him must treat him like he would treat a hired worker, and all of you must make sure that his owner does not treat him cruelly. ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","‘And even if a fellow Israeli who has sold himself to a rich man is not able to pay for himself to be freed by any of these ways, he and his children must be freed in the Year of Celebration, ");
INSERT INTO eng_t4t_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","because it is as though you Israelis are my slaves/servants, whom I, Yahweh your God, freed from being slaves in Egypt.’” ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Yahweh also said this to Moses/me on Sinai Mountain: “Do not make idols or set up statues of false gods or sacred stones to worship other gods. And do not put on your property a stone that has been shaped to resemble a false god and bow down to worship it. You must worship only me, Yahweh, your God. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“Honor the Sabbath days and revere my Sacred Tent, because I, Yahweh, live there. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“If you carefully obey all my commands DOU, ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","I will send rain for you at the proper/right times, in order that crops will grow on your land and there will be plenty of fruit on your trees. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","You will continue harvesting and threshing grain until it is time to harvest grapes, and you will continue to harvest grapes until it is time to start planting things in the following year. And you will have all the food that you want to eat, and you will live safely in your land. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“If you obey all my laws, there will be peace in your country, and when you lie down to sleep, nothing will cause you to be afraid. I will get rid of the dangerous animals in your country, and there will no wars MTY in your country. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","You will pursue your enemies and kill them with your swords: ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Five of you will pursue 100 of them, and 100 of you will pursue 1,000 of them and kill them with your swords. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“If you obey all my laws, I will bless you and cause you to have many children DOU. And I will do what I said that I would do in the agreement that I made with you. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","When you are still eating food from the harvest from the previous year, it will be necessary for you to throw away some of it to make space for the new harvest. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","I will live among you in my Sacred Tent, and I will never reject you. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","I will walk among you and continue to be your God, and you will continue to be my people. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","I am Yahweh your God, the one who brought you out of Egypt in order that you would no longer be slaves of the people of Egypt. When you were there, you were treated as though you were animals that worked for the people of Egypt, but MET I broke the bars of the ◄yokes/frames that were put around your necks► and enabled you to walk with your heads up.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“But if you will not heed me and obey all these commands, ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","and if you reject DOU my decrees and laws, and do not do DOU what I commanded you to do in the agreement that I made with you, ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","these are the things that I will do to you: I will suddenly cause there to be disasters that will ruin you. You will have diseases that cannot be cured, and fevers that will cause you to become blind and will slowly kill you. It will be useless for you to plant seeds, because your enemies will eat the crops that grow. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","I will reject/abandon you IDM, with the result that you will be defeated by your enemies. Then those who hate you will rule you, and you will be so terrified that you will run away even when no one is pursuing you. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“If you still will not heed me after all those things happen to you, I will continue to punish you again and again for the sins that you have committed. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","I will cause you to no longer be stubborn and proud; I will cause no rain to fall; it will be as though MET the sky is made of iron; and the ground will be as hard as brass MET. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","You will uselessly work very hard to plant seeds, because crops will not grow in the hard soil in your fields, and fruit will not grow on your trees. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“If you continue to oppose me and refuse to heed me, I will cause you to experience disasters again and again, like you deserve to experience because of your sins. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","I will send wild animals to attack you, and they will kill your little children and destroy your cattle. There will be very few of you who will remain alive, with the result that there will be very few HYP people walking on the roads in your country. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“When you experience those things that I do to punish you, if you still do not pay attention to me, and if you continue to oppose me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","I myself will oppose you, and I will punish you for your sins again and again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","I will send foreign armies MTY to punish you for not doing the things that I commanded you to do in the agreement that I made with you. If you try to escape from your enemies by shutting yourselves in your cities that have walls around them, I will cause you to experience plagues, and I will allow your enemies to capture IDM you. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","When I cut off your food supply, there will be very little flour with which to make bread. As a result, ten women will be able to bake all their bread in only one oven. When the bread is baked, each woman will divide it among the members of her family, but there will be very little for each one, and when they have eaten all of it, they will still be hungry. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“After all those things happen, if you still do not heed me, if you still oppose me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","I will be very angry with you, and I will oppose you, and I myself will punish you for your sins again and again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","You will be extremely hungry, with the result that you will kill your sons and daughters and eat their flesh. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","I will cause the shrines where you worship idols on hilltops to be destroyed. I will smash the altars where you burn incense to worship your gods, and I will cause your corpses to be piled on the lifeless statues of your gods. And I will detest you. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","I will cause your cities to become heaps of ruins, and I will cause the buildings that are dedicated to the worship of your gods to be smashed. And I will not be pleased at all with the aroma of your offerings that are burned on the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","I will completely ruin your country, with the result that even your enemies who capture it will be shocked/appalled when they see it. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","I will enable your enemies to kill you with their swords, and I will cause the rest of you to be scattered among other nations. Your country will be ruined and your cities will become ruins. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","After that happens, as long as you are living in your enemies’ countries, your land will be allowed to rest, like you should have allowed it to rest every seven years. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","All the time that your land is desolate, it will be able to rest, like you did not enable it to rest during all the years that you lived there. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“As for you people who will remain alive in the countries to which your enemies will have taken you, I will cause you to become so afraid that when you hear the sound of leaves being blown by the wind, you will run away. You will run like SIM you are running from a man carrying a sword, and you will fall down, even though no one is pursuing you. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","You will stumble over each other. So you will not be able to stand and fight your enemies. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Many of you will die in the countries that belong to your enemies DOU. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","And those of you who remain alive will slowly die and rot in the countries of your enemies because of your sins and because of the sins of your ancestors. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","41","“But your descendants must confess their sins and the sins that their ancestors committed. Their ancestors acted unfaithfully toward me and were hostile to me, with the result that I forced them to go to the countries that belonged to their enemies. But when your descendants humble themselves SYN and stop being very stubborn IDM and accept being punished for their sins, ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","I will remember the agreement that I made with your ancestors Abraham and Isaac and Jacob, and what I promised them about  this land. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","But before that happens, you will be forced to leave your land, with the result that the land will be able to rest while it is desolate and while the people are being punished for rejecting my laws and hating my decrees DOU. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","But when that happens, I will still not reject them or hate them and destroy them completely. I will not cancel the agreement that I made with them; for I am still Yahweh their God. ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","I will ◄remember/never forget► the agreement that I made with your ancestors when I brought them out of Egypt, in order that the people of all nations will know that I, Yahweh, will continue to be your God.” ");
INSERT INTO eng_t4t_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Those are the decrees, the laws, and the regulations DOU that Yahweh established on Sinai Mountain between himself and the Israeli people by giving them to Moses/me to tell to them. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Tell the Israeli people that this is what I am saying to them: If anyone solemnly promises to dedicate another person to work solely for me, the person who is dedicated to me is allowed to be free from having to do that by someone paying to the priest a fixed amount of money. The money that is given must be calculated by comparing it with the official pieces of silver in the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","These are the amounts that must be paid: 50 pieces of silver for men who are between 20 and 60 years old, ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","30 pieces of silver for adult women who are between 20 and 60 years old, ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","20 pieces of silver for young men who are between five and 20 years old, ten pieces of silver for young women who are between five and 20 years old, ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","five pieces of silver for boys who are between one month and five years old, three pieces of silver for girls who are between one month and five years old, ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","15 pieces of silver for men who are more than 60 years old, ten pieces of silver for women who are more than 60 years old. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","‘If anyone who has made such a solemn promise is very poor and unable to pay, to free that person from doing what he had promised, he must take that person to the priest. The priest will set the price for freeing him to be what the person who made that solemn promise is able to pay. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","‘If someone solemnly promises to give an animal that is acceptable to be an offering to me, that animal becomes sacred and belongs to me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","The person who promised to give it must not give another animal instead of the one that he promised; he must not substitute a bad animal for a good one or even a better one than the one offered. If he would substitute one animal for the other, both animals would belong to me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","If the animal that he wishes to dedicate to me is a kind that is unacceptable to be an offering to me, he must take that animal to the priest. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","The priest will then decide what its value is, according to the animal’s good and bad points. Whatever value the priests sets will be the value of the animal, and that is the price that the priest must pay for the animal. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","If the man who gave the animal later decides that he wants to buy it back, he must pay to the priest that price plus an additional 20 percent. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","‘Similarly, if someone dedicates his house to be a sacred gift to belong to me, the priest will decide how much it is worth, which will depend on whether the house is in good condition. Whatever the priest says that it is worth, that will be its value and that is the price that the priest must pay for it. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","If the man who dedicated his house to me later wants to buy it back, he must pay that price plus an additional 20 percent, and then the house will belong to him again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","‘If someone dedicates to me some of the property that belongs to him and his family, its value will be determined by the number of bushels of seed that will be needed to plant seeds on that land: Its value will be ten pieces of silver for each bushel of seed. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","If he dedicates the land during the Year of Celebration, its full value will be that amount. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","But if he dedicates the field after the Year of Celebration, the priest will count the number of years until the next Year of Celebration, and if there are not many years that remain, the price will be much lower than the full price. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","If the person who dedicated the field later wants to buy it back, he must pay to the priest the price that the priest says it is worth, plus an added one-fifth, and then the field will belong to that man again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","However, if he does not buy it back, or if it has been sold (OR, the priest has sold it) to someone else, that person will never be permitted to buy it back again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","In the Year of Celebration, it will become sacred again, and it will be given to the priest. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","‘If someone dedicates to me some land that he has bought, land which is not part of the land that his family has always owned, ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","the priest will count the number of years until the next Year of Celebration to determine how much it is worth, and the man must pay that amount to the priest on that day, and then that land will belong to that man again. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","But in the Year of Celebration, the land will again be owned by the person from whom he bought it, the person whose family had always owned that land. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","All the silver that is paid must be compared with the official pieces of silver in the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","‘No one is permitted to dedicate to me the firstborn of any cow or sheep, because the firstborn already belongs to me DOU. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","If someone gives to me a kind of animal that is not acceptable to me, that person may later buy it back by paying what it is worth plus an additional 20 percent of its value. If he does not buy it back, it must be sold (OR, the priest must sell it) for its standard price. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","‘However, no slave or animal or family land that someone owns can be sold or bought back after it has been dedicated to me and no price has been paid for it. That kind of gift belongs to me permanently/forever. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","‘No person who has done something that I consider to be very wicked is permitted to be freed from being punished; that person must surely be executed. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","‘One tenth of all the crops and grain or fruit that is produced on anyone’s land is sacred and belongs to me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","If anyone wants to buy back any of that tenth, he must pay to the priest what it is worth plus an additional 20 percent. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","One of every ten domestic animals belongs to me. When a shepherd counts his animals MTY to decide which ones he will give to me, he must mark every tenth one as belonging to me. ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","When he does that, he must not pick out the good ones for himself or leave the bad ones, or substitute bad ones for good ones. If he substitutes one animal for another, both animals will belong to me, and he will not be permitted to buy them back (OR, the shepherd cannot buy them back).’ ” ");
INSERT INTO eng_t4t_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Those are the commands that Yahweh gave to Moses/me on Sinai Mountain to tell to the people. ");
INSERT INTO eng_t4t_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","In April of the year after the Israeli people left Egypt, Yahweh spoke to Moses/me while he/I was in the Sacred Tent, in the Sinai Desert. Yahweh said to him/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","3","“I want you and Aaron to determine how many Israeli men are able to fight in battles. Write down the names of all the men who are at least 20 years old, and write down the names of their clans and families. ");
INSERT INTO eng_t4t_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","I have chosen one man from each of the tribes to help you to do this. Each one will be a leader of his clan. ");
INSERT INTO eng_t4t_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","15","Their names are: Elizur, the son of Shedeur, from the tribe of Reuben; Shelumiel, the son of Zurishaddai, from the tribe of Simeon; Nahshon, the son of Amminadab, from the tribe of Judah; Nethanel, the son of Zuar, from the tribe of Issachar; Eliab, the son of Helon, from the tribe of Zebulun; Elishama, the son of Ammihud, from the tribe of Joseph’s son Ephraim; Gamaliel, the son of Pedahzur, from the tribe of Joseph’s son Manasseh; Abidan, the son of Gideoni, from the tribe of Benjamin; Ahiezer, the son of Ammishaddai, from the tribe of Dan; Pagiel, the son of Ocran, from the tribe of Asher; Eliasaph, the son of Deuel, from the tribe of Gad; Ahira, the son of Enan, from the tribe of Naphtali.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Those were the men whom Yahweh chose from the people. They were leaders of their tribes. They were the chief men of the clans of the Israeli people. ");
INSERT INTO eng_t4t_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Aaron and Moses/I summoned all these leaders, ");
INSERT INTO eng_t4t_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","and they gathered all of the people together on that same day. They listed/wrote down the names of all the men who were at least 20 years old, and with their names they wrote the names of their clans and their family groups ");
INSERT INTO eng_t4t_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","just as Moses/I had commanded. They wrote the names while ◄the Israelis/we► were there in the Sinai Desert. ");
INSERT INTO eng_t4t_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","43","This is a list of the number of men who were at least 20 years old and able to fight in battles, and the names of their tribes: There were 46,500 men from the tribe of Reuben (who was Jacob’s oldest son); there were 59,300 men from the tribe of Simeon; there were 45,560 men from the tribe of Gad; there were 74,600 men from the tribe of Judah; there were 54,400 men from the tribe of Issachar; there were 57,400 men from the tribe of Zebulun; there were 40,500 men from the tribe of Ephraim; there were 32,200 men from the tribe of Manasseh; there were 35,400 men from the tribe of Benjamin; there were 62,700 men from the tribe of Dan; there were 41,500 men from the tribe of Asher; there were 53,400 men from the tribe of Naphtali. ");
INSERT INTO eng_t4t_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","45","That was the number of men from each tribe that Aaron and Moses/I and the twelve leaders of the tribes of Israel listed, along with the names of their clans. ");
INSERT INTO eng_t4t_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","The total was 603,550 men. ");
INSERT INTO eng_t4t_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","But this number did not include the names of the men of the tribe of Levi, ");
INSERT INTO eng_t4t_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","because Yahweh had said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“When you ◄count/write the names of► the men of the tribes of Israel, do not count the men in the tribe of Levi. ");
INSERT INTO eng_t4t_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Appoint the male descendants of Levi to take care of the Sacred Tent and the chest inside it that contains the tablets on which are written the Ten Commandments. They must also take care of the other things that are inside the tent. When you travel, they are the ones who must carry the tent and all the things that are inside it, and they must take care of it and set up their tents around it. ");
INSERT INTO eng_t4t_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Whenever it is time for all of you to move to another location, the descendants of Levi are the ones who must dismantle the tent. And when it is time to stop traveling, they are the ones who must set up the Sacred Tent again. Any other person who goes near the Sacred Tent to do this work must be executed. ");
INSERT INTO eng_t4t_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","The people of each Israeli tribe must set up their tents in their own area, and they must set up a flag/banner that represents their tribe. ");
INSERT INTO eng_t4t_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","But the male descendants of Levi must set up their tents around the Sacred Tent, in order to protect the other Israeli people from being punished MTY by Yahweh for coming close to the Sacred Tent. The descendants of Levi are the ones who must stand around the Sacred Tent to guard it.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","So the Israeli people did everything just like Yahweh had commanded Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Then Yahweh said this to Aaron and Moses/me: ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“When the Israelis set up their tents, they should set them up in areas that surround the Sacred Tent, but not close to it. The people of each tribe must set up their tents in a different area. Each tribe must erect in that area a banner of their own clan and a flag that represents their tribe. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","4","The people of the tribes of Judah, Issachar, and Zebulun must set up their tents on the east side of the Sacred Tent, close to their tribal flags. These are the names of the leaders of those tribes and the number of soldiers whom they will lead: Nahshon, the son of Amminadab, will be the leader of the 74,600 men of the tribe of Judah. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","6","Nethanel, the son of Zuar, will be the leader of the 54,500 men of the tribe of Issachar. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","8","Eliab, the son of Helon, will be the leader of the 57,400 men of the tribe of Zebulun. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","So there will be 86,400 troops on the east side of the Sacred Tent. Whenever the Israelis move to a new location, those three tribes must go in front of the others. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","11","The tribes of Reuben, Simeon, and Gad must set up their tents on the south side of the Sacred Tent, close to their tribal flags. These are the names of the leaders of those tribes and the number of men whom they will lead: Elizur, the son of Shedeur, will be the leader of the 46,500 men of the tribe of Reuben. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","13","Shelumiel, the son of Zurishaddai, will be the leader of the 59,300 men of the tribe of Simeon. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","15","Eliasaph, the son of Deuel, will be the leader of the 45,650 men of the tribe of Gad. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","So there will be 151,450 troops on the south side of the Sacred Tent. Those three tribes will follow the first group when the Israelis travel. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Behind that group will walk the descendants of Levi, who will carry the Sacred Tent. The Israelis will march in the same order that they always set up their tents. Each tribe will carry its own flag. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","19","The tribes of Ephraim, Manasseh, and Benjamin must set up their tents on the west side of the Sacred Tent, close to their tribal flags. These are the names of the leaders of those tribes and number of men whom they will lead: Elishama, the son of Ammihud, will be the leader of the 40,500 men of the tribe of Ephraim. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","21","Gamaliel, the son of Pedahzur, will be the leader of the 32,200 men of the tribe of Manasseh. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","23","Abidan, the son of Gideoni, will be the leader of the 35,400 men of the tribe of Benjamin. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","So there will be 108,100 troops on the west side of the Sacred Tent. Those three tribes will follow the second group, behind the descendants of Levi. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","26","The tribes of Dan, Asher, and Naphtali must set up their tents on the north side of the Sacred Tent, close to their tribal flags. These are the names of the leaders of those tribes and the number of men whom they will lead: Ahiezer, the son of Ammishaddai, will be the leader of the 62,700 men of the tribe of Dan. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","28","Pagiel, the son of Ocran, will be the leader of the 41,500 men of the tribe of Asher. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","30","Ahira, the son of Enan, will be the leader of the 53,400 men of the tribe of Naphtali. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","So there will be 157,600 troops on the north side of the Sacred Tent. Those three tribes will be last. They must carry their own flags when the Israelis travel.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","So there were 603,550 Israeli men who were able to fight who were listed according to their families’ ancestors. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","But just as Yahweh had commanded, the names of the descendants of Levi were not included. ");
INSERT INTO eng_t4t_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","The Israelis did everything that Yahweh had told Moses/me. They set up their tents close to their tribal flags, and when they traveled to a new location, they walked with their own clans and family groups. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","These are some of the things that happened to Aaron and Moses/me when Yahweh spoke to Moses/me on Sinai Mountain. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aaron’s four sons were Nadab the oldest, Abihu, Eleazar, and Ithamar. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","They were appointed MTY (OR, Moses/I appointed them) to be priests. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","But, while Yahweh was watching, Nadab and Abihu died in the Sinai Desert because they burned incense in a manner that was different from what Yahweh had commanded. They had no sons, so Eleazar and Ithamar were the only sons of Aaron who were left to be priests, along with their father Aaron. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Then Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Bring the men of the tribe of Levi and present them to Aaron, in order that they may assist him. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","They will serve Aaron and all the other Israeli people, while they do their work inside the Sacred Tent and outside it. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","They must serve all the Israeli people by taking care of all the things that are inside the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Appoint them to help Aaron and his two sons. I have chosen them from all the Israeli people to do that. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Appoint Aaron and his two sons to do the work that priests do. But anyone else who comes close to the Sacred Tent to do that work must be executed.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Yahweh also told Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Note that from all the Israelis, I have chosen the men of the tribe of Levi to take the places of all the firstborn sons of the Israeli people. The male descendants of Levi belong to me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","because truly all the firstborn males belong to me. That is because on the day that I killed all the firstborn sons of the people of Egypt, I spared all the firstborn sons of the Israelis and set them apart for myself. I also set apart the firstborn males of your domestic animals. They belong to me, Yahweh.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Yahweh spoke to Moses/me again in the Sinai Desert. He said, ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Count the male members of the tribe of Levi. Write down their names and the names of their clans and family groups. Count all the males who are at least one month old.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","So Moses/I counted them, just as Yahweh commanded. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Levi had three sons, whose names were Gershon, Kohath, and Merari. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gershon had two sons: Libni and Shimei. The clans that were descended from them had the same names as those two sons. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kohath had four sons: Amram, Izhar, Hebron, and Uzziel. The clans that were descended from them had the same names as those four sons. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari had two sons: Mahli and Mushi. The clans that were descended from them had the same names as those two sons. Those are the clans that were descended from Levi. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","The two clans descended from Gershon are those that were descended from his sons Libni and Shimei. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","In those two clans there were 7,500 males who were at least one month old. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","They were told to set up their tents on the west side of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","The leader of those two clans was Eliasaph, the son of Lael. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Their work was to take care of the Sacred Tent, including the coverings of the tent, the curtain at the entrance of the tent, ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","the ◄curtains/large pieces of cloth► that formed the walls around the courtyard that is around the tent and around the altar, the curtains that were at the entrance of the courtyard, and the ropes for fastening the tent. They also did all the work of taking care of the things outside the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","The clans that were descended from Kohath were those descended from his four sons: Amram, Izhar, Hebron, and Uzziel. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","In those four clans there were 8,600 males who were at least one month old. The work of the men of the clans was to take care of the things that are inside the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","They set up their tents on the south side of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","The leader of those four clans was Elizaphan, the son of Uzziel. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","The work of the men of those clans was to take care of the sacred chest, the table on which the priest put the sacred bread, the lampstand, the altars, all the items that the priest used in the Sacred Tent, and the curtain that is inside the tent. Their work was also to take care of the things inside the tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Aaron’s son Eleazar was the leader of all the male descendants of Levi. He supervised all the work that was done at the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","The clans that were descended from Merari were those descended from his sons Mahli and Mushi. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","In those two clans there were 6,200 males who were at least one month old. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","They were told to set up their tents on the north side of the Sacred Tent. The leader of those two clans was Zuriel, the son of Abihail. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","The work of the men of those two clans was to take care of the frames that held up the tent, the crossbars, the pillars, and the bases. They also did all the work that was connected with those items. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Their work was also to take care of the posts that held up the curtains that formed the walls of the courtyard, and all the bases, tent pegs, and ropes that fastened those curtains. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Aaron and Moses/I and Aaron’s sons were told to set up their/our tents in the area in front of the Sacred Tent, on the east side. Their/Our work was to supervise the work that would be done in and around the Sacred Tent, for the benefit of the Israeli people. Only the priests were permitted to do that. Yahweh declared that we should execute anyone else who went near the tent to do the work that the priests do. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","When Aaron and Moses/I counted all the males who were at least one month old, who belonged to the clans descended from Levi, the total was 22,000. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Then Yahweh said to Moses/me, “Now count all the other firstborn males in Israel who are at least one month old, and write down their names. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Also, set apart for me the descendants of Levi to be substitutes for the firstborn males of the other Israelis. And set apart for me the livestock of the descendants of Levi to be substitutes for the firstborn livestock of the other Israeli people.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","So Moses/I did that. He/I counted the firstborn males of all the Israeli people, as Yahweh had commanded. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","The total of those who were at least one month old was 22,273. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Then Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Set apart the descendants of Levi to be substitutes for the firstborn males of the other Israeli people. The descendants of Levi belong to me, Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","There are 273 more firstborn males of the other Israeli people than of the descendants of Levi. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","48","To pay for these 273 males, collect five pieces of silver for each of them. Each of those pieces of silver must weigh the same as each of the silver coins that are stored in the Sacred Tent. Give this silver to Aaron and his sons.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","So Moses/I did that. He/I collected the silver from those 273 males. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","The total was 1,365 pieces of silver. Each silver coin weighed the same as each of the silver coins stored in the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Moses/I gave these silver coins to Aaron and his sons, as Yahweh had commanded. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Then Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Write down the names of the men who belong to the clans descended from Levi. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Write the names of the men who are between 30 and 50 years old. These will be men who will work at the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“The work of these descendants of Kohath will be to take care of the sacred items that are used when the people worship at the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","When you Israelis move to another location, Aaron and his sons must enter the tent to take down the curtain that separates the Very Holy Place from the other part of the Sacred Tent. They must cover the sacred chest with that curtain. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Then they must cover that with a nice covering made from the skins of goats. Over that they must spread a blue cloth. Then they must insert into the rings on the chest the poles for carrying it. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Then they must put a blue cloth over the table on which the priests put the sacred bread. On top of the cloth they must put the bowls for incense, the pans, the other dishes, the jars for the wine that will be offered as a sacrifice, and the sacred bread. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Over all of this they must spread a scarlet/red cloth. Finally, they must put on top a nice covering made from the skins of goats. Then they must insert into the rings at the corners of the tables the poles for carrying it. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Then with another blue cloth they must cover the lampstand, the lamps, the lamp snuffers, the trays, and the special jars of olive oil to burn in the lamps. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","They must cover the lampstand and all the other items with a nice covering made from the skins of goats. They must place all these things on a frame for carrying them. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Then they must spread another blue cloth over the gold altar which is used for burning incense. Over this they must spread a nice covering made from the skins of goats. Then they must insert into the rings of that altar the poles for carrying it. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“They must take all the other items that are inside the Sacred Tent and wrap them in a blue cloth, cover that with a nice covering made from the skins of goats, and place all that on a frame for carrying it. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Then they must remove the ashes from the altar on which they have burned sacrifices. Then they must cover the altar with a purple cloth. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Then they must spread on top of the cloth all the items used at the altar—the pans for carrying the hot coals, the meat forks, the shovels, the bowls for containing the blood to sprinkle on the people, and all the other containers. Then they must spread over all those things a nice covering made from the skins of goats. Then they must insert into the rings at the sides of the altar the poles for carrying it. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Then Aaron and his sons have finished covering all these sacred things, the Israeli people will be ready to move to a new location. The descendants of Kohath must come and carry all the sacred things to the next place where you Israelis will set up your tents. But the descendants of Kohath must not touch any of these sacred items, because they will immediately die if they touch them. They are the ones who will carry these things, but they must not touch them. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Aaron’s son Eleazar will have the work of taking care of the olive oil for the lamps, the nice-smelling incense, the grain which will be burned on the altar each day, and the olive oil for anointing the priests. Eleazar is the one who will supervise the work that is done at the Sacred Tent and the men who take care of everything that is in it.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","“Then Yahweh said to Aaron and Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","20","“When the descendants of Kohath approach the sacred items in the Sacred Tent to take them to another location, Aaron and his sons must always go in with them and show each of them what work to do and what things to carry. But the descendants of Kohath must not enter the Sacred Tent at any other time and look at the things that are in it. If they do that, I will get rid of all the descendants of Kohath.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Write down the names of all the men who belong to the clans descended from the Gershon division of the descendants of Levi. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Write the names of the men who are between 30 and 50 years old. They will be men who will also work at the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“This is the work that they must do and the things that they must carry when you move to a new location: ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","They must carry the curtains of the Sacred Tent; they must carry the Sacred Tent and all the things that cover it, including the nice outer covering made from skins of goats, and the curtain which is at the entrance of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","They must also carry the curtains that form the wall that surrounds the courtyard that surrounds the Sacred Tent and the altar, the curtain that is at the entrance to the courtyard, and the ropes that fasten the curtains. They must also do the packing and loading of these things. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Aaron and his sons will supervise the work of all the descendants of Gershom. That work includes carrying those things and doing other work that is necessary for moving them. They must tell each of the descendants of Gershom what things they must carry. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Those are the tasks that you must give to the men who belong to the clans descended from Gershom. Aaron’s son Ithamar is the one who will supervise their work. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Count also the men who belong to the clans descended from Levi’s son Merari. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Write the names of the men who are between 30 and 50 years old. They will be men who will also work at the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Their work will be to carry the frames that hold up the tent, the crossbars, the posts that hold up the curtains, and the bases. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","They must also carry the posts for the curtains that form the walls of the courtyard and the bases for the posts, the tent pegs, and the ropes to fasten the curtains. Tell each man what things he must carry. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Those are the tasks that the descendants of Merari must do at the Sacred Tent. Aaron’s son Ithamar is the one who will supervise them.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","So Aaron and Moses/I and the Israeli leaders counted the descendants of Kohath, writing also the names of their clans and family groups. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","They/We counted all the men who were between 30 and 50 years old who were able to work at the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","The total was 2,750 men. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","They were the descendants of Kohath who were able to work at the Sacred Tent. Aaron and Moses/I counted them just as Yahweh had commanded Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","They/We also counted the descendants of Gershon, writing also the names of their clans and family groups. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","They/We counted all the men who were between 30 and 50 years old who were able to work at the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","The total was 2,630 men. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","They were the descendants of Gershon who were able to work at the Sacred Tent. Aaron and Moses/I counted them as Yahweh had commanded. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","They/We also counted the descendants of Merari, writing also the names of their clans and family groups. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","They/We counted all the men who were between 30 and 50 years old who were able to work at the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","The total was 3,200 men. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","They were the descendants of Merari who were able to work. Aaron and Moses/I counted them as Yahweh had commanded Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","So Aaron and Moses/I and the Israeli leaders counted all the descendants of Levi, writing also the names of their clans and family groups. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","They/We counted all the men who were between 30 and 50 years old. They were ones who were able to work at the Sacred Tent and who carried the tent and everything that was connected with it. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","The total was 8,580 men. ");
INSERT INTO eng_t4t_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","They/We completed the counting of all the descendants of Levi, as Yahweh had commanded Moses/me. And they/we told each man what work he was to do and what things he must carry when they moved to a new location. ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Tell this to the Israeli people: ‘You must send away from your ◄camp/area where you have your tents► any man or woman who has leprosy and anyone who has a discharge of some fluid from his body, and anyone who has become unacceptable to God because of having touched a corpse. ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Send them away from there in order that they will not touch people in the camp area where I live among you and cause them to become unacceptable to me.’” ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","So Moses/I told that to the Israeli people, and the Israeli people obeyed what Yahweh commanded Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Yahweh also told Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Tell this to the Israeli people: ‘If someone ◄commits a crime against/does something wrong to► another person, I consider that that person has done wrong to me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","That person must confess that he or she is guilty, and he or she must pay to the person to whom wrong was done what others consider to be a suitable/proper payment for what he has done, and he must pay an extra 20 percent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","If the person against whom the wrong was done has died and there is no relative to whom the money can be paid, then the money belongs to me, and it must be paid to the priest. In addition, the one who did the wrong must give a male sheep to the priest to sacrifice in order that ◄that person’s sin may be forgiven/I can forgive that person for his sin►. ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","All the sacred offerings that the Israelis bring to the priest belong to the priest. ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","The priest can keep those gifts.’” ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Yahweh also said this to Moses/me: ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Tell this to the Israeli people: ‘Suppose a man thinks that his wife has slept with another man, ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","but neither he nor anyone else knows if it is true or not, because no one saw her doing that. ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","But if the woman’s husband is jealous, and if he suspects that she has committed adultery, and he wants to know whether that is true or not, ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","he should take his wife to the priest. He must take along as an offering two quarts/liters of barley flour. The priest must not pour olive oil or incense on it, because this is an offering that the man has brought because he ◄is jealous/wants his wife to sleep only with him►. It is an offering to find out if she is guilty or not. Neither olive oil nor incense should be used because are associated with joy and this is not a time for joy. ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","The priest must tell the woman to stand in front of the altar in my presence. ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","He must put some sacred water in a clay jar, and then he must put some dirt from the floor of the Sacred Tent into the water. ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","He must untie/unfasten the woman’s hair. Then he must put in her hands the grain that her jealous husband is offering to determine whether she has committed adultery or not. The priest must hold the bowl that contains bitter water that will cause ◄the woman to be cursed/bad things to happen to the woman► if she is guilty. ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","The priest must require her to solemnly declare that she will tell the truth. Then he must say to her, “Has another man had sex EUP with you? Have you faithfully slept only with your husband or not? If you have not slept with another man, nothing bad will happen to you if you drink the water. ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","But if you have had sex with another man, Yahweh will curse you. ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","22","Your womb will shrivel up and your stomach will swell up. You will never be able to give birth to children, and as a result, everyone will curse you and avoid you. If you have committed adultery, when you drink this water, that is what will happen to you.” Then the woman must answer, “If I am guilty, I will not object if that happens.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","‘Then the priest must write with ink on a small scroll these ◄curses/bad things that will happen to her if she is guilty► and then wash the ink off into the bitter water. ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","25","The priest must take from her the offering of barley flour that she is holding, and lift it up to dedicate it to me. Then he must put it on the altar ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","and burn part of it as a sacrifice. Then the woman must drink the bitter water. ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","If the woman has committed adultery, the water will cause her to suffer greatly. Her stomach will swell up and her womb will shrink, and she will be unable to give birth to children. And then her ◄relatives/fellow Israelis► will curse her. ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","But if she ◄is innocent/has not committed adultery►, her body will not be harmed, and she will still be able to give birth to children. ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","‘That is the ritual that must be performed when a woman who is married has been unfaithful to her husband, ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","or when a man is jealous and suspects that his wife has had sex with another man. The priest must tell that woman to stand at the altar in my presence and obey these instructions. ");
INSERT INTO eng_t4t_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Even if the woman has not done what the husband suspected, he will not be punished MTY for doing something wrong by bringing his wife to the priest. But if his wife is guilty, she will suffer as a result.’” ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Yahweh also said this to Moses/me: ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Tell this to the Israeli people: ‘If any of you wants to make a solemn promise to dedicate himself to belong to me in a special way, after you obey these instructions, you will be called a Nazir-man, which means “dedicated man”. ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","You must not drink any wine or other alcoholic/fermented drink. You must not drink any vinegar made from wine or from any other alcoholic/fermented drink. You must not drink grape juice or eat grapes or raisins. ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","You must not eat anything that comes from grapevines, not even the skins or seeds of grapes, during the time that you are a Nazir-man. ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","‘Even your hair will be dedicated to me during the time that you area Nazir-man, so you must never allow anyone to cut your hair. Until the time that your solemn promise to dedicate yourself to me is ended, you must allow your hair to grow long. ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","And you must not go near a corpse during the time that you are a Nazir-man. ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Even if the person who died is your father or your mother or your brother or your sister, you must not cause yourself to become unacceptable to me by coming close to the corpse. Your long hair MTY shows that you belong to me in a special way, so you must not cut your hair. ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","You are required to keep doing this all the time that you are dedicated to me in this special way. ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","‘If anyone dies very suddenly when he is near you, then your hair that you have dedicated to me is no longer sacred. So you must wait seven days and then shave it all off. Then you must perform a special ritual to cause yourself to become acceptable to me again. ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","The next day you must bring two doves or two young pigeons to the priest at the entrance of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","‘The priest must kill the birds and offer them as sacrifices. One of them will be an offering to enable me to forgive you for the sins you have committed, and the other will be an offering that is burned completely to please me. After the priest burns them on the altar, I will forgive you for having come close to a corpse, and when your hair grows again it will be dedicated to me again. ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","The amount of time that you were set apart for me the previous time does not count, because you had become unacceptable to me by coming close to a corpse during the time that you were a Nazir-man. So you must again make a solemn promise to dedicate yourself to me for the entire amount of time that you indicated the previous time. And you must also sacrifice a one-year-old lamb for not doing what you were required to do. ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","‘When the time that you promised to dedicate yourself to me is ended, go to the entrance of the Sacred Tent ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","and offer as sacrifices to me three animals that have no defects: Offer a one-year-old ram that will be burned completely, a one-year-old female lamb as a sacrifice to enable me to forgive your sins, and one full-grown ram as a sacrifice to maintain fellowship with me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","‘When you bring those animals, you must also bring some wine to offer as a sacrifice. And you must also bring a basket of bread that you have made with very good flour and olive oil. But you must not put any yeast in the bread. Also brush/spread some olive oil on some thin wafers and bring them to the priest. ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","‘The priest will put the young lamb and the young ram on the altar and completely burn them, in order that I will be pleased and will forgive you for your sins. ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Then he will kill the full-grown ram as an offering to restore fellowship with me, and he will also burn on the altar some of the bread and the grain and wine. ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","‘After that, you must stand at the entrance of the Sacred Tent and shave off your hair. Then you must put that hair in the fire that is under the animal that has been sacrificed on the altar to maintain fellowship with me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","‘The meat from the ram’s shoulder must be boiled. After it is cooked, the priest will take it along with one of the loaves of bread and one wafer which has been brushed with olive oil, and he will put them in your hands. ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Then the priest will take them back and lift them up high to dedicate them to me. They now belong to the priest, and he is permitted to eat some of the meat from the ram’s shoulder and from its ribs and from one of its thighs, because that meat is his share of the sacrifice. After that, you will no longer be a Nazir-man, and you will again be permitted to drink wine. ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","‘Those are the regulations about the offerings that Nazir-men solemnly promise to bring to me to end their time of being dedicated to me. They must bring these offerings, but if they want to, they may bring additional offerings. And they must do everything that they solemnly promised to do when they dedicated themselves to me.’” ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Tell Aaron and his sons that when they ask me to bless the people, they must say, ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘I desire that Yahweh will bless you and protect you, ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","and that he will smile at you and act kindly toward you, ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","and that he will be good to you IDM and cause things to go well for you.’” ");
INSERT INTO eng_t4t_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Then Yahweh said, “If Aaron and his sons ask me to bless the Israeli people, truly I will bless them.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","When Moses/I had finished setting up the Sacred Tent, he/I dedicated MTY it to Yahweh. He/I also dedicated the things that are inside the tent, and the altar for burning sacrifices, and all the things that would be used at the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Then the leaders of the twelve Israeli tribes, the same men who had helped Aaron and Moses/me to count the men who could fight in battles, ");
INSERT INTO eng_t4t_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","came to the tent, bringing gifts to Yahweh. They brought six sturdy/large carts and twelve oxen, one ox from each of the leaders and a cart from each of the two leaders. ");
INSERT INTO eng_t4t_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Then Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Accept these gifts, in order that the descendants of Levi can use them for carrying the sacred items that are here at the Sacred Tent.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","So Moses/I took the carts and oxen and gave them to the descendants of Levi. ");
INSERT INTO eng_t4t_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","He/I gave two carts and four oxen to the descendants of Gershon for their work, ");
INSERT INTO eng_t4t_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","and he/I gave four carts and eight oxen to the descendants of Merari for their work. Aaron’s son Ithamar was the supervisor of all their work. ");
INSERT INTO eng_t4t_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","But he/I did not give any carts or oxen to the descendants of Kohath, because they took care of the sacred items that were to be carried on their shoulders, not on carts. ");
INSERT INTO eng_t4t_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","On the day that the altar was dedicated MTY, the twelve leaders brought other gifts to be dedicated and put them in front of the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Yahweh said to Moses/me, “Each of the next twelve days one leader should bring his gifts for the dedication of the altar.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","These are the gifts that each of the leaders brought: —a silver dish that weighed ◄more than three pounds/1.5 kg.►, and a silver bowl that weighed ◄almost two pounds/800 grams►, both of which were full of good flour and mixed with olive oil to be offerings of grain; they both were weighed using the standard scales; —a small gold dish that weighed ◄four ounces/14 grams►, filled with incense; —a young bull, a full-grown ram, and a one-year-old ram, to be sacrifices to be completely burned on the altar; —a goat to be sacrificed to enable me to forgive the people for the sins they have committed; —and two bulls, five full-grown rams, five male goats, and five rams that were one-year-old, to be sacrifices to maintain the people’s fellowship with Yahweh. This was the order in which the leaders brought their gifts: on the first day, Nahshon, son of Amminadab from the tribe of Judah brought his gifts; on the next/second day, Nethanel, son of Zuar, from the tribe of Issachar; on the next/third day, Eliab, son of Helon, from the tribe of Zebulun; on the next/fourth day, Elizur, son of Shedeur, from the tribe of Reuben; on the next/fifth day, Shelumiel, son of Jurishhaddai, from the tribe of Simeon; on the next/sixth day, Eliasaph, son of Deuel, from the tribe of Gad; on the next/seventh day, Elishama, son of Ammihud, from the tribe of Ephraim; on the next/eighth day, Gamaliel, son of Pedahzur, from the tribe of Manasseh; on the next/ninth day, Abidan, son of Gideoni, from the tribe of Benjamin; on the next/tenth day, Ahiezer, son of Ammishaddai, from the tribe of Dan; on the next/eleventh day, Pagiel, son of Acran, from the tribe of Asher; on the next/twelfth day, Ahira, son of Enam, from the tribe of Naphtali. ");
INSERT INTO eng_t4t_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","88","When the altar was dedicated to Yahweh, those twelve leaders brought these gifts: —twelve silver plates and twelve silver bowls, weighing a total of about ◄60 pounds/27.6 kg.►, each of them being weighed on the scales kept in the Sacred Tent; —twelve gold dishes filled with incense, weighing a total of about ◄three pounds/1.4 kg.►, each being weighed on those same scales; —twelve bulls, twelve full-grown rams, and twelve one-year-old rams, to be sacrifices that were completely burned, along with the grain offerings; —twelve goats to be sacrificed to forgive the people for the sins they have committed; —and 24 bulls, 60 full-grown rams, 60 goats, and 60 rams that were one-year-old, to be sacrifices to maintain the people’s fellowship with Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Whenever Moses/I entered the Sacred Tent to talk with Yahweh, he/I heard Yahweh’s voice speaking between the two images of creatures with wings that were above the lid of the sacred chest. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Tell Aaron to put the seven lamps on the lampstand and place them in such a way that they shine toward the front of the lampstand.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","So Moses/I told him what Yahweh said, and he did that. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","The lampstand had been made from gold that had been hammered from one large lump of gold, from its base to the decorations at the top that resembled flowers. The lampstand was made exactly like Yahweh had told Moses/me that it should be made. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“You must cause the descendants of Levi to be acceptable to me by setting them apart from the other Israeli people. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Do that by sprinkling them with water which will symbolize their being freed/cleansed from the guilt of their sins. Then they must shave off all the hair on their bodies and wash their clothes. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Then they must bring to the Sacred Tent one bull and some grain mixed with olive oil. Those things will be burned as sacrifices. They must also bring another bull that will enable me to forgive them  for the sins they have committed. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Then you must summon all the Israeli people to come together in front of the Sacred Tent, to gather around the descendants of Levi. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Then the Israeli people must lay their hands on the descendants of Levi. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aaron must then present them to me to be a gift from the Israeli people, in order that they can work for me at the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“After that, the descendants of Levi must place their hands on the heads of the two bulls. Then the bulls will be killed and burned on the altar. One will be an offering to enable me to forgive them for the sins they have committed, and the other will be completely burned to please me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","The descendants of Levi must stand at the altar in front of Aaron and his sons, and you must then dedicate to me the descendants of Levi. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","This ritual will show that the descendants of Levi are set apart from the other Israelis and that they belong to me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“After the descendants of Levi have been made acceptable to me, and presented to me like a special offering, they may start to work at the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","They will belong to me. They will work for me as substitutes for the firstborn males of all the Israelis, who also belong to me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","All the firstborn males in Israel, both the people and the animals, are mine. When I caused all the firstborn sons of the people of Egypt to die, I ◄spared/did not kill► the firstborn males of the Israelis. I set them apart to belong to me. I said that the firstborn males of all their domestic animals would also belong to me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","But now I have chosen the descendants of Levi to take the places of the firstborn males of other Israelis. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","I have appointed the descendants of Levi to help Aaron and his sons at the Sacred Tent, as Aaron and his sons offer the sacrifices so that the Israeli people’s sins will be forgiven, and to prevent the Israelis from coming close to the tent with the result that a plague would cause many of them to become sick and die.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Aaron and Moses/I and the other Israelis helped the descendants of Levi to do everything that Yahweh had commanded. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","The descendants of Levi sprinkled themselves with water to symbolize that they had been freed/cleansed from the guilt of their sins, and they washed their clothes. Then Aaron brought them to the altar to present them to Yahweh, and he offered sacrifices to cleanse them from the guilt of their sins and cause them to become acceptable to Yahweh. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","After that, the descendants of Levi started to work at the Sacred Tent to assist Aaron and his sons. They did that just as Yahweh had commanded Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Yahweh also said this to Moses/me: ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“The descendants of Levi who are between 25 and 50 years old will work at the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","But after they become 50 years old, they must ◄retire/not do that work any more►. ");
INSERT INTO eng_t4t_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","They may help the other descendants of Levi to do their work at the Sacred Tent, but they must not do the work themselves. That is what you must tell them about the work they will do.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","One year after the Israelis left Egypt, during the month of March, while they were in the Sinai Desert, Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Tell the Israeli people that they must celebrate the Passover Festival again. ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","They must do it on the fourteenth day of this month, early in the evening, and they must obey all the instructions about it that I gave you previously.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","So Moses/I told the people what Yahweh had said about celebrating the Passover. ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","The people celebrated it, there in the Sinai Desert, in the evening of the fourteenth day of the month, just as Yahweh had commanded Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","But some of the Israeli people had touched a corpse, and as a result they had become unfit to celebrate the Passover. So they asked Aaron and Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","“It is true that we have touched a corpse. But why should that prevent us from celebrating the Passover Festival and offering sacrifices to Yahweh like everyone else RHQ?” ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moses/I replied, “Wait here until I go into the Sacred Tent and find out what Yahweh says about it.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","So Moses/I went into the tent and asked Yahweh what he/I should tell the people, and this is what Yahweh said: ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Tell this to the Israeli people: If any of you or your descendants touch a corpse and as a result become unacceptable to me, or if you are away from home on a long trip at the time to celebrate the Passover, you will still be permitted to celebrate it. ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","But you must celebrate it exactly one month later, early in the evening of the fourteenth day of that month. Eat the meat of the lamb for the Passover Festival with bread that is baked without yeast and eat bitter herbs. ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Do not leave any of it until the next morning. And do not break any of the lamb’s bones. Obey all the regulations about celebrating the Passover. ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","But if any of you has not done anything that would make you unfit to celebrate the Passover Festival, and you are not away from home on a long trip, and you do not sacrifice to me at the proper time, you will no longer be allowed to associate with my people. ◄You will be punished/I will punish you►. ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Foreigners who live among you may also celebrate the Passover Festival, if they obey all my commands concerning it.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","16","On the day that the Sacred Tent was set up, a cloud covered it. From the time that the sun set until the time that the sun rose the next day, the cloud resembled a huge fire. And that is what happened every day that we/the Israelis were in the desert. ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","When the cloud rose up and started to move to a new location, we/they followed it. When the cloud stopped, we/the Israelis stopped there and set up their tents. ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","We/They traveled when Yahweh, by causing the cloud to move or stop, signaled to us/them when to move and when to stop. When the cloud stayed over the Sacred Tent, we/the Israelis stayed at that place. ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Sometimes the cloud stayed over the tent for a long time, so when that happened, we/they did not travel. ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Sometimes the cloud remained over the tent for only a few days. We/The people stopped and set up our/their tents as Yahweh commanded us/them, and we/they traveled to a new location when Yahweh commanded us/them to do that. ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Sometimes the cloud stayed in one place for only one day. When that happened, when the cloud rose up into the sky the next morning, then we/they traveled. Whenever the cloud moved, during the day or during the night, we/they traveled. ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","If the cloud stayed over the Sacred Tent for two days, or for a month, or for a year, during that time we/they stayed where we/they were. But when the cloud rose up into the sky, we/they started to travel. ");
INSERT INTO eng_t4t_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","When Yahweh commanded us/them to stop and set up our/their tents, we/they did that. When he told us/them to move, we/they moved. We/They did whatever Yahweh told Moses/me that we/they should do. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Yahweh also told Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Tell someone to make two trumpets by hammering each one from one lump of silver. Blow the trumpets to summon the people to come together and also to signal that they must move their tents to a new location. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","If both trumpets are blown, it means that everyone must gather together at the entrance of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","If only one trumpet is blown, it means that only the twelve leaders of the tribes must gather together. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","If the trumpets are blown loudly, the tribes that are to the east of the Sacred Tent should start to travel. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","When the trumpets are blown loudly the second time, the tribes that are to the south should start to travel. The loud blasts on the trumpet will signal that they should start to travel. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","When you want only to gather the people together, blow the trumpets, but do not blow them as loudly. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“The priests who are descended from Aaron are the ones who should blow the trumpets. That is a regulation that will never be changed. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","When you fight against enemies who attack you in your own land, tell the priests to blow the trumpets loudly. I, Yahweh, your God, will hear that, and I will rescue you from your enemies. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Also tell the priests to blow the trumpets when the people are happy, and at the festivals each year, and at the times when they celebrate the new moon each month. Tell them to blow the trumpets when the people bring offerings that will be completely burned, and when they bring offerings to maintain fellowship with me. If they do that, it will help you to remember that I, Yahweh your God, will help you.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","On the twentieth day of May in the second year after the/we Israelis left Egypt, the cloud rose up from above the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","So we/the Israelis traveled from the Sinai Desert, and we/they continued traveling north until the cloud stopped in the Paran Desert. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","That was the first time we/they moved, obeying the instructions that Yahweh had given to Moses/me to tell them. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","The group that went first, carrying their flag/banner, was the group from the tribe of Judah. Nahshon, the son of Amminadab, was their leader. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","The group from the tribe of Issachar followed them. Nethanel, the son of Zuar, was their leader. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","The group from the tribe of Zebulun went next. Eliab, the son of Helon, was their leader. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Then they dismantled the Sacred Tent, and the descendants of Gershon and Merari carried it, and they went next. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","The group from the tribe of Reuben went next, carrying their flag. Elizur, the son of Shedeur, was their leader. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","The group from the tribe of Simeon was next. Shelumiel, the son of Zurishaddai, was their leader. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","The group from the tribe of Gad was next. Eliasaph, the son of Deuel, was their leader. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","The group descended from Kohath was next. They carried the sacred items from the Sacred Tent. The Sacred Tent itself was set up at the new location before they arrived there. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","The group from the tribe of Ephraim was next, carrying their flag. Elishama, the son of Ammihud, was their leader. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","The group from the tribe of Manasseh went next. Gamaliel, the son of Pedahzur, was their leader. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","The group from the tribe of Benjamin, went next. Abidan, the son of Gideoni, was their leader. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","The ones who went last were the group from the tribe of Dan, carrying their flag. Ahiezer, the son of Ammishaddai, was their leader. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","The group from the tribe of Asher went next. Pagiel, the son of Ocran, was their leader. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","The group from the tribe of Naphtali went last. Ahira, the son of Enan, was their leader. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","That was the order in which the groups of Israeli tribes traveled. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","One day Moses/I said to his/my brother-in-law Hobab, the son of Reuel from the Midian people-group, “We are on the way to the place that Yahweh promised to give to us. Come with us, and we will take good care of you, because Yahweh has promised to do good things for us Israeli people.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","But Hobab replied, “No, I will not go with you. I want to return to my own land and to my own family.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","But Moses/I said, “Please do not leave us. You know the places where we can set up our tents in this desert, and you can guide us. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Come with us. We will share with you all the good things that Yahweh gives to us.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","So Hobab agreed to go with them. The Israelis left Sinai Mountain, which they called Yahweh’s Mountain, and they walked for three days. The men carrying the sacred chest went in front of the other people for those three days, and they kept looking for a place to set up their tents. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","The cloud sent by Yahweh was over them every day. ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Each morning when the men who were carrying the sacred chest started to walk, Moses/I said, “Yahweh, arise! Scatter your enemies! Cause those who hate you to run away from you!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","And each time the men stopped to set down the sacred chest, Moses/I said, “Yahweh, stay close to the thousands of us Israelis!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","One day the people complained to Yahweh about their troubles. When Yahweh heard what they were saying, he became angry. So he sent a fire which burned among the people at the edge of their camp. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Then the people cried out to Moses/me, and he/I prayed to Yahweh. Then the fire stopped burning. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","So they called that place Taberah, which means ‘burning’, because the fire from Yahweh had burned among them. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Then some troublemakers from other people-groups who were traveling with the Israelis began to want better food. And when they started complaining the Israeli people also started to complain. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","They said, “We wish we had some meat! ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","We remember the fish that we ate while we were in Egypt, fish that was given to us without ◄cost/asking us to pay for it►. And we had all the cucumbers, melons, leeks, onions, and garlic that we wanted. But now we do not have any desire to eat, because all we have to eat is this manna!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","The manna resembled small white seeds. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Each morning the people would go out and gather some from the surface of the ground. Then they made flour by grinding it or pounding it with stones. Then they added water and boiled it in a pot, or they made flat cakes with it and baked them. The cakes tasted like bread that was baked with olive oil. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Each night the manna came down on their ground where their tents were, like dew from the sky. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moses/I heard all the Israeli people complaining as they were standing in the entrances of their tents. Yahweh became very angry, and Moses/I was also very perturbed. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","He/I went into the Sacred Tent and asked Yahweh, “Why have you caused me, your servant, to experience this trouble RHQ? Act mercifully to me! What wrong have I done, with the result that you have appointed me to take care of all of these people RHQ? ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","◄I am not their father./Am I their father?► RHQ Why have you told me to take care of them like a woman carries around her baby and ◄nurses it/gives it her milk► MET, RHQ? How can I take them to the land that you promised to give to our ancestors RHQ? ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Where can I get meat to feed all these people? They keep complaining to me, saying, ‘Give us some meat to eat!’ ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","I cannot carry all these people’s burdens by myself! They are like a heavy load MET, and I cannot carry this very heavy load any more. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","If you intend to act like this toward me, kill me now. If you are really concerned about me, be kind to me and kill me to end my misery of trying to take care of them!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Then Yahweh said to Moses/me, “Summon 70 men whom you know are leaders among the Israeli people. Tell them to stand with you in front of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","I will come down and talk with you there. Then I will take some of the power of my Spirit that you have, and I will put that power on them also. They will help you to take care of some of the things that the people are concerned about, in order that you will not need to do it alone. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Furthermore, say to the people, ‘Make yourselves acceptable to me, and tomorrow you will have meat to eat. You were complaining, and Yahweh heard you when you were saying, “We want some meat to eat. We had better food in Egypt!” Now Yahweh will give you some meat, and you will eat it. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","You will eat meat not only for one or two days, nor only for five or ten or 20 days. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","You will eat meat every day for one month, and then you will loathe/despise it, and it will cause you to want to vomit. This will happen because you have rejected Yahweh who is here among you, and you have wailed in his presence, saying “We would have had better food to eat if we had not left Egypt RHQ.”’” ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","But Moses/I replied to Yahweh, “There are 600,000 men plus women and children here with me, so ◄why do you say ‘I will give them plenty of meat every day for a month!’?/it does not seem right for you to say ‘I will give them plenty of meat every day for a month!’► RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Even if we killed all the sheep and cattle, that would not RHQ be enough to provide meat for all of them Even if we caught all the fish in the sea and gave it to them, that would not be enough RHQ!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","But Yahweh said to Moses/me, “Do you think that I SYN have no power? You will now see if I can do what I say I will do.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","So Moses/I went out from the Sacred Tent and told the people what Yahweh had said. Then he/I gathered together the 70 leaders and told them to stand around the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Then Yahweh came down in the cloud that was above the tent and spoke to Moses/me. He took some of the power of the Spirit that he had given to Moses/me and gave it to the 70 leaders. By means of the power of the Spirit within them, they ◄prophesied/spoke messages that Yahweh gave them►, but they did that only once. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Two of the leaders whom Moses/I appointed, Eldad and Medad, were not there when the rest of them gathered together. They had not left their tents to go and stand around the Sacred Tent. But Yahweh’s Spirit came on them also, and they started to ◄prophesy/speak messages from Yahweh►. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","So a young man ran and told Moses/me, “Eldad and Medad are prophesying in all their tents!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Joshua, who had helped Moses/me since he was a young man, said, “Sir, tell them to stop doing that!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","But Moses/I replied, “◄Are you worried that they might injure my reputation/Do you think that I want to be the only one who prophesies► RHQ? I wish that all Yahweh’s people could ◄prophesy/speak messages from Yahweh►. I wish that Yahweh would give the power of his Spirit to all of them!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Then Moses/I and all the leaders went back to their/our tents. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Then Yahweh sent a strong wind from the sea. It blew quail into the area all around the camp for miles in every direction, and caused the quail to fall onto the ground. They were piled up on the ground about ◄3 feet/1 meter► high! ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","So the people went out and gathered up the quail all that day, and all that night, and all of the following day. It seemed as though everyone gathered at least 50 bushels! They spread the quail out on the ground all around the camp, so that the quail would dry out. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Then they cooked them and started to eat them. But while they were still eating the meat MTY, Yahweh showed that he was very angry with them. He struck them with a severe plague/sickness, and many people died. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","The people who died and were buried were the ones who had said they wanted to eat meat like they had formerly eaten in Egypt. So they called that place Kibroth-Hattaavah, which means ‘graves of those who craved’. ");
INSERT INTO eng_t4t_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","From there, the Israelis continued walking east until they arrived at Hazeroth town, where they stopped and stayed for a long time. ");
INSERT INTO eng_t4t_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","2","Moses’/My older sister Miriam and his/my older brother Aaron were saying this: “Is Moses the only one to whom Yahweh has spoken messages to tell to us RHQ? Does Yahweh not speak messages to us two also?” They told people that they were saying that because Moses/I had married a woman who was a descendant of the Cush people-group, but they were really saying that because they ◄were jealous/did not want Moses/me to be the only leader of the Israeli people►. But Yahweh heard what they were saying. ");
INSERT INTO eng_t4t_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","The truth was that Moses/I was very humble. He/I was more humble than anyone else on the earth and Moses/I had not appointed himself/myself to be their leader. ");
INSERT INTO eng_t4t_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","So immediately Yahweh spoke to Moses/me and to Aaron and Miriam. He said, “All three of you must go and stand at the Sacred Tent.” So they/we did that. ");
INSERT INTO eng_t4t_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Then Yahweh descended to the entrance of the tent in a cloud that resembled a huge white pillar. He told Aaron and Miriam to step forward, so they did. ");
INSERT INTO eng_t4t_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Then he said to them, “Listen to me! When a prophet is among you, I usually reveal myself to him by allowing him to see visions, and I speak to him in dreams. ");
INSERT INTO eng_t4t_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","But that is not the way I speak to my servant Moses. I trust that he will lead my people well. ");
INSERT INTO eng_t4t_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","So I talk to him face-to-face. I speak to him ◄clearly/using words that he will understand easily►, not using parables. He has even seen what I look like. So you should be afraid to criticize my servant Moses!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Yahweh was very angry with Miriam and Aaron, and he left. ");
INSERT INTO eng_t4t_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","When the cloud rose up from the Sacred Tent, Aaron looked at Miriam, and he saw that her skin was as white as snow, because she now had leprosy. ");
INSERT INTO eng_t4t_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Aaron said to Moses/me, “My master, please do not punish us for this sin that we have foolishly committed. ");
INSERT INTO eng_t4t_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Do not allow Miriam to be like a baby that is already dead when it is born, whose flesh is already half decayed!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","So Moses/I cried out to Yahweh, saying, “God, I plead with you to heal her!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","But Yahweh replied, “If her father had rebuked her for doing something wrong by spitting in her face, she would have been ashamed for seven days. She should be ashamed because of what she has done. So send her outside the camp for seven days. Then she will not have leprosy any more, and she may return to the camp.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","So they sent her outside the camp for seven days. ◄The people/We► did not move to another location until she returned. ");
INSERT INTO eng_t4t_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","But after she returned, they/we left Hazeroth and moved north in the Paran Desert and set up their/our tents there. ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Send some men to Canaan land to explore it. That is the land that I will give to you Israelis. Send men who are leaders in their tribes.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","So Moses/I did what Yahweh commanded him/me. He/I sent out twelve Israeli men who were all leaders of their tribes. He/I sent them from their/our camp at Paran in the desert. ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","These are the names of the men and the tribes they belonged to: Shammua, the son of Zaccur, from the tribe of Reuben; ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Shaphat, the son of Hori, from the tribe of Simeon; ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Caleb, the son of Jephunneh, from the tribe of Judah; ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Igal, the son of Joseph, from the tribe of Issachar; ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Hoshea, the son of Nun, from the tribe of Ephraim; ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Palti, the son of Raphu, from the tribe of Benjamin; ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Gaddiel, the son of Sodi, from the tribe of Zebulun; ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Gaddi, the son of Susi, from the tribe of Manasseh; ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Ammiel, the son of Gemalli, from the tribe of Dan; ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Sethur, the son of Michael, from the tribe of Asher; ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nahbi, the son of Vophsi, from the tribe of Naphtali; ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","and Geuel, the son of Maki, from the tribe of Gad. ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Those are the names of the men whom Moses/I sent out to explore Canaan. Before they left, Moses/I gave Hoshea a new name, Joshua, which means ‘Yahweh is the one who saves.’ ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Before Moses/I sent them to explore Canaan, he/I said to them, “Go through the southern part of Canaan, and then go north into the hilly area. ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","See what the land is like. See if the people who live there are strong or weak. See if there are many people or only a few people. ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Find out what kind of land they live in RHQ. Is it good or bad? Find out about the towns in which they live RHQ. Do they have walls around them or not? ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Find out about the soil RHQ. Is it ◄fertile/good for growing crops► or not? Find out if there are trees there RHQ. Try to bring back some of the fruit that grows in that land.” He/I said that because it was the beginning of the time to harvest grapes. ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","So those men went to Canaan. They went through the entire land, from the Zin desert in the south all the way to Rehob town near Lebo-Hamath in the north. ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","In the south, they went to Hebron, where Ahiman, Sheshai, and Talmai, huge men descended from Anak, lived. Hebron was a city that was built seven years before Zoan city was built in Egypt. ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","In one valley, they cut from a grapevine one cluster of grapes. Because it was very large, they needed two men to carry it on a pole. They also picked some pomegranates and some figs to carry back to their camp. ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","They called that place Eshcol which means ‘cluster’ because they had cut that huge cluster of grapes there. ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","After they explored the land for 40 days, they returned to their camp. ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","They came to Aaron and Moses/me and the rest of the Israeli people in the desert at Paran. They reported to everyone what they had seen. They also showed them the fruit that they had brought back. ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","But this is what they reported to Moses/me: “We arrived in the land that you sent us to explore. It is truly a beautiful land, and it is very fertile IDM. Here is some of the fruit. ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","But the people who live there are very strong. Their cities are large and are surrounded by walls. We even saw some of the huge descendants of Anak there. ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","The descendants of Amalek live in the southern part of the land, and the descendants of Heth, Jebus, and Amor live in the hilly area to the north. The descendants of Canaan live along the coast of the Mediterranean sea and along the Jordan River.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","When they said that, the people were afraid and started to cry out very loudly. But Caleb told the people who were standing near Moses/me to be quiet. Then he said, “We should go there and take the land, because we are certainly able to conquer it!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","But the men who had gone with him said, “No, we cannot attack and defeat those people! They are much stronger than we are!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","So those men gave to the Israeli people a bad report about the land that they had explored. They said, “The land that we explored is very large; we cannot conquer it. And all the people whom we saw are very tall. ");
INSERT INTO eng_t4t_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","We even saw the descendants of Nephili there. The descendants of Anak whom we saw there are descended from the giant Nephili people. When we saw them, we felt as small as grasshoppers SIM, and they thought that we looked like grasshoppers too!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","That night, all the Israeli people cried loudly. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","The next day they all complained to Aaron and Moses/me. All the men said, “We wish that we had died in Egypt, or in this desert! ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Why is Yahweh bringing us to this land, where we men will be killed with swords? And our wives and children will be taken away to be slaves. Instead of going to Canaan. It would be better for us to return to Egypt!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Then some of them said to each other, “We should choose a leader who will take us back to Egypt!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Then Aaron and Moses/I bowed down to pray in front of all the Israeli people who had gathered there. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Joshua and Caleb, two of the men who had explored the land, tore their clothes because they were very dismayed. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","They said to the Israeli people, “The land that we explored is very good. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","If Yahweh is pleased with us, he will lead us into that very fertile IDM land, and he will give it to us. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","So do not rebel against Yahweh! And do not be afraid of the people in that land! We will ◄gobble them up/completely destroy them► MET! They do not have anyone who will protect them, but Yahweh will be with us and help us. So do not be afraid of them!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Then all the Israeli people talked about killing Caleb and Joshua by throwing stones at them. But suddenly Yahweh’s glory appeared to them at the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Then Yahweh said to Moses/me, “How long will these people reject me RHQ? I am tired of them not believing in what I can do, in spite of all the miracles I have performed among them RHQ! ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","So I will cause a ◄plague/widespread sickness► to strike them and get rid of them. But I will cause your descendants to become a great nation. They will be a nation that is much greater and stronger than these people are.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","But Moses/I replied to Yahweh, “Please do not do that, because the people of Egypt will hear about it! You brought these Israeli people from Egypt by your great power, ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","and the people of Egypt will tell that to the descendants of Canaan who live in this land. Yahweh, they have already heard about you. They know that you have ◄been with/helped► these people and that they have seen you face-to-face. They have heard that your cloud is like a huge pillar that stays over them, and by using that cloud you lead them during the day, and the cloud becomes like a fire at night to give them light. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","If you kill these people all at one time, the people-groups who have heard about your power will say, ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Yahweh was not able to bring them into the land that he promised to give to them, so he killed them in the desert.’ ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“So Yahweh, now show that you are very powerful. You said, ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘I do not quickly become angry; instead, I love people very much, and I forgive people for having sinned and having disobeyed my laws. But I will always punish LIT people who are guilty of doing what is wrong. When parents sin, I will punish them, but I will also punish their children and their grandchildren and their great-grandchildren and their great-great-grandchildren.’ ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","So, because you love people like that, forgive these people for the sins that they have committed, just like you have continued to forgive them ever since they left Egypt.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Then Yahweh replied, “I have forgiven them, as you requested me to. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","But, just as certainly as I live and that people all over the world can see my ◄glory/glorious power►, I solemnly declare this: ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","All these people saw my glory and all the miracles that I performed in Egypt and in the desert, but they disobeyed me, and many times they tested whether they could continue to do evil things without my punishing them. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Because of that, not one of them will see the land that I promised their ancestors that I would give to them. No one who rejected me will see that land. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","But Caleb, who serves me well, is different from the others. He obeys me completely. So I will bring him into that land that he has already seen, and his descendants will inherit/possess some of it. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","So, since the descendants of Amalek and Canaan who are living in the valleys in Canaan are very strong, when you leave here tomorrow, instead of traveling toward Canaan, go back along the road through the desert towards the Red Sea.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Then Yahweh said to Aaron and Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“How long will the wicked people of this nation keep complaining about me RHQ? I have heard everything that they have grumbled/complained against me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","So now tell them this: ‘Just as certainly as I, Yahweh, live, I will do exactly what you said would happen. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","I will cause all of you to die here in this desert! Because you grumbled about me, none of you who are more than 20 years old and who were counted when Moses counted everyone ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","will enter the land that I solemnly promised to give to you. Only Caleb and Joshua will enter that land. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","You said that your children would be taken from you to become slaves, but I will take them into the land, and they will enjoy living in the land that you ◄rejected/said that you could not conquer►. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","But as for you adults, you will die here in this desert. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","And like shepherds wander around in the desert as they take care of their sheep, your children will wander around in this desert for 40 years. Because you adults were not loyal/faithful to me, your children will suffer until you all die in the desert. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","You will suffer for your sins for 40 years. That will be one year for each of the 40 days that the twelve men explored Canaan land. And I will be like an enemy to you.’ ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","This will certainly happen because I, Yahweh, have said it! I will do these things to every one in this group who conspired against me. They ◄conspired against/decided together to reject► me here in the desert, and they will all die right here in this desert!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Then the ten men who had explored Canaan and who had urged the people to rebel against Yahweh by giving reports that discouraged the people ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","were immediately struck with a plague/disease that Yahweh sent, and they died. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Of the twelve men who had explored Canaan, only Joshua and Caleb remained alive. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","When Moses/I reported to the Israeli people what Yahweh had said, many of them were very sad. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","So the people got up early the next morning and started to go toward the hilly area in Canaan. They said, “We know that we have sinned, but now we are ready to enter the land that Yahweh promised to give to us.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","But Moses/I said, “Yahweh commanded you to return to the desert, so why are you now disobeying him RHQ? It will not ◄succeed/be possible►. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Do not try to enter the land now! If you try, your enemies will defeat you, because Yahweh will not ◄be with/help► you. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","When you begin to fight the descendants of Amalek and Canaan, they will slaughter you! Yahweh will abandon you, because you have abandoned him.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","But even though Moses/I did not leave the camp, and the sacred chest that contained the Ten Commandments was not taken from the camp, the people began to go towards the hilly area in Canaan. ");
INSERT INTO eng_t4t_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Then the descendants of Amalek and Canaan who lived in that hilly area came down and attacked them and chased them as far south as the town of Hormah. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Then Yahweh told Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Tell this to the Israeli people: When you arrive in the land that I am giving to you, ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","you must offer to me special sacrifices which will be pleasing to me when the priest burns them on the altar. Some of them may be offerings that will be completely burned on the altar. Some of them may be to indicate that you have made a solemn promise to me. Some of them may be offerings that you yourselves have decided to make. Some of them may be offerings at one of the festivals that you celebrate each year. These offerings may be taken from your herds of cattle or from your flocks of sheep and goats. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","When you give these offerings, you must also bring to me a grain offering of two quarts/liters of nice flour mixed with one quart/liter of olive oil. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","When you offer a lamb to be a sacrifice to be completely burned, you must also pour on the altar one quart/liter of wine. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","‘When you offer a ram to be a sacrifice, you must also bring an offering of four quarts/liters of finely-ground flour mixed with ◄a third of a gallon/1.3 liters► of olive oil. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","And also pour on the altar ◄a third of a gallon/1.3 liters► of wine. While they are being burned, the smell will be very pleasing to me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","‘Sometimes you will offer a young bull to be completely burned on the altar. Sometimes you will offer a sacrifice to indicate that you have made a solemn promise to me. Sometimes you will offer a sacrifice to maintain fellowship with me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","When you offer these sacrifices, you must also offer a grain offering of six quarts/liters of finely-ground flour mixed with two quarts/liters of olive oil. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Also pour on the altar two quarts/liters of wine to be an offering. While those special gifts are being burned, the smell will be very pleasing to me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Each time someone offers a bull or a ram or a male lamb or a young goat to be a sacrifice, it must be done that way. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","You must obey these instructions for each animal that you bring to me for an offering. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","‘All of you people who have been Israelis all of your lives must obey these regulations when you offer sacrifices that will be pleasing to me when they are burned on the altar. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","If any foreigners visit you or live among you, if they also want to bring a sacrifice that will be pleasing to me when it is burned on the altar, they must obey these same instructions. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","I consider that those who have always been Israelis and those who are foreigners are equal, and so they must all obey the same instructions. All of your descendants must also continue to obey these instructions. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","You Israelis and the foreigners who live among you must all obey the same instructions.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Tell these instructions to the Israeli people: Yahweh says this: ‘When you arrive in the land to which I am taking you, ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","and you eat the crops that are growing there, you must set some of them aside to be a sacred offering to me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Each year set aside some of the first grain that you gather after you have threshed it. Bake a loaf of bread from the first flour that you grind and bring it to me to be a sacred offering. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Every year, you and your descendants must continue to make and bring to me a loaf of bread baked MTY with flour from the first part of the grain that you harvest.’” ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“‘There may be times when you Israelis do not obey all these instructions that I have given to Moses to tell you, but not because you intended to disobey them. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","There may be times when some of your descendants do not obey all these instructions that I have given to Moses to tell to you. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","If you or they sin by forgetting to obey these instructions and none of the Israeli people realize that they were doing that, one young bull as an offering for all the people must be brought to the priest. That will be pleasing to me when it is burned on the altar. They must also bring to me a grain offering and an offering of wine, and a male goat, to be sacrificed to enable me to forgive them for the sins they have committed. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","By offering these sacrifices, the priest will make atonement for all of you Israeli people. Then, as a result of their bringing to me an offering to be burned on the altar, ◄you will be forgiven/I will forgive you►, because you sinned without realizing that you were sinning. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","You Israeli people and the foreigners who are living among you will all be forgiven. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","If one person commits a sin without realizing that he was sinning, that person must bring to me a female goat to be an offering to enable me to forgive that person for the sins that person has committed. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","The priest will offer it to be a sacrifice to remove the guilt of that person, and that person will be forgiven. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","You Israelis and all the foreigners who live among you must obey these same instructions. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","But those who disobey my commands ◄deliberately/because they want to►, both Israelis and the foreigners who live among you, have sinned against me by doing that. So ◄they must be expelled/you must expel them► from your camp. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","They have despised my commands and deliberately disobeyed them, so they must be punished for their sin by not being allowed to live among you any more.’” ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","One day, while the Israelis were in the desert, some of them saw a man who was gathering firewood on the Sabbath/rest day. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Those who saw him doing that brought him to Aaron and Moses/me and the rest of the Israeli people. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","They guarded him carefully, because they did not know what to do to punish him. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Then Yahweh said to Moses/me, “The man must be executed. All of you must kill him by throwing stones at him outside the camp.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","So they all took the man outside the camp and killed him by throwing stones at him, as Yahweh had commanded Moses/me that they should do. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Yahweh also said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Tell this to the Israeli people: You and all your descendants must twist threads together to make tassels, and then attach them with blue cords to the bottom edges of your clothes. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","When you look at the tassels, you will remember all the instructions that I gave to you, and you will obey them, instead of doing what you desire and as a result causing yourselves to become unacceptable to me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Seeing those tassels will help you to remember that you must obey all my commands and that you must be ◄my holy people/dedicated to me►. ");
INSERT INTO eng_t4t_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Do not forget that I am Yahweh, your God. I am the one who brought you out of Egypt in order that you might belong to me. I am Yahweh, your God.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","One day Korah, who was the son of Izhar and a descendant of Levi’s son Kohath, conspired with Dathan and Abiram, who were the sons of Eliab, and On, who was the son of Peleth. Those three men were from the tribe of Reuben. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Korah and those other three men incited 250 other people who were leaders among the Israeli people to join them in rebelling against Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","They came together to criticize Aaron and Moses/me. They said to them/us, “You two are using more authority than you should! Yahweh has set apart all of us Israeli people, and he is with/helping all of us. So why do you act as though you are more important than the rest of us people who belong to Yahweh RHQ?” ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","When Moses/I heard what they were saying, he/I prostrated himself/myself on the ground. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Then he/I said to Korah and those Israeli leaders who were with Korah, “Tomorrow morning Yahweh will show us whom he has chosen to be his priest, and who is holy and allowed to come near to him. Yahweh will permit only those whom he chooses to come into his presence. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","So Korah, tomorrow you and those who are with you must prepare your pans to burn incense. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Then you must light a fire in them and burn the incense in the presence of Yahweh. Then we will see which one of us Yahweh has chosen to be his holy servant. It is you men who are descendants of Levi who are trying to use more authority than you should!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Then Moses/I spoke again to Korah. He/I said, “You men who are descendants of Levi, listen to me! ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","The God of us Israelis has chosen all of you to be close to him in order that you can work for him at his Sacred Tent and serve the people. ◄Is that unimportant/Does that mean nothing► to you RHQ? ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Yahweh has brought you, Korah, and your fellow descendants of Levi, near to himself. Now are you demanding to become priests also? ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","It is really Yahweh against whom you and your fellow descendants of Levi are rebelling. Aaron is not the one about whom you are really complaining RHQ.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Then Moses/I summoned Dathan and Abiram, but they refused to come. They sent a message saying, “We will not come to you! ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","You brought us out of Egypt, which was a very fertile IDM land, in order to cause us to die here in this desert. That was bad. But now you are also trying to boss us RHQ, and that is worse. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","You have not given us a new land to live in, a land that has good fields and vineyards. You are only trying to RHQ trick these people. So we will not come to you.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Then Moses/I became very angry. He/I said to Yahweh, “Do not accept the grain offerings that they have brought. I have not taken anything from them, not even one donkey, and I have never done anything wrong to them, so they have no reason to complain about me.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Then Moses/I said to Korah, “You and all those who are with you must come here tomorrow and stand in front of Yahweh. Aaron will also be here. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","You and all the 250 men who are with you must each take a pan in which to burn incense, and put incense in it, to burn it to be an offering to Yahweh. Aaron will do the same thing.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","So the next day each of those men got a pan to burn incense. They put in it incense and hot coals to light it, and then they all stood at the entrance of the Sacred Tent with Aaron and Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Then Korah summoned all the people who supported him and who were against Moses/me, and they also gathered at the entrance of the tent. Then the glory of Yahweh appeared to all of them/us, ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","and Yahweh said to Aaron and Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Get away from all these people, in order that I can get rid of them immediately!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","But Aaron and Moses/I prostrated themselves/ourselves on the ground. We pleaded with Yahweh, saying, “God, you are the one who caused all these people to live MTY. Only one of these men has sinned; so, ◄is it right for you to be angry with all the people?/it is not right for you to be angry with all the people!► RHQ” ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Okay, but tell all the people to get away from the tents of Korah, Dathan, and Abiram.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","So Moses/I stood up and went to the tents of Dathan and Abiram. The Israeli leaders followed him/me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","He/I told the people, “Get away from the tents of these wicked men, and do not touch anything that belongs to them! If you touch anything, you will die because of their sins!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","So all the people moved away from the tents of Korah, Dathan, and Abiram. Dathan and Abiram came out of their tents with their wives and children and babies, and stood at the entrances of their tents. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Then Moses/I said, “I was not the one who decided to do all these things that I have done. It was Yahweh who chose me and sent me to do them. And now he will prove that to you. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","If these men die in a normal way, then it will be clear that Yahweh did not choose me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","But if Yahweh does something that has never happened before, if he causes the ground that is under their feet to open up and swallow these men and their families and all their possessions, and they fall into the opening and are buried while they are still alive, then you will know that these men have insulted Yahweh.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","As soon as Moses/I said this, the ground split open beneath those men. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","It swallowed them and their families and all those who were standing there with Korah and all of their possessions. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","They fell into the opening in the ground while they were still alive, and all their possessions fell into the opening also. They disappeared, and the ground closed back up again. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","They screamed as they fell, and all the people who were standing nearby heard them scream. The people were terrified and cried out as they ran away, saying, “We do not want the ground to swallow us also!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","And then a fire from Yahweh came down from the sky and burned up the 250 men who were burning the incense! ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Then Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Tell Aaron’s son Eleazar to take the pans that had incense in them away from the fire and to scatter the burning coals. The pans that those men were carrying are ◄holy/dedicated to me► because they burned incense to me in them. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Those men have now died because of their sin; so Eleazar must take their pans and hammer the metal to make it become very thin. He must make a covering for the altar with that metal. Those pans were used to offer incense to me, so they are ◄holy/dedicated to me►. What happened to those pans will now warn the Israeli people.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","So Eleazar the priest collected the 250 pans for burning incense that had been used by the men who died in the fire. He hammered the pans very thin to make a covering for the altar, as Yahweh told Moses/me should be done. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","That warned the Israeli people that only those who were descendants of Aaron were permitted to burn incense for an offering to Yahweh. If anyone else did that, the same thing that happened to Korah and those who were with him would happen to them. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","But the following morning, all the Israeli people started to complain against Aaron and Moses/me, saying “You have killed many people who belonged to Yahweh!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","When all the people gathered together to protest about what Aaron and Moses/I had done, they looked at the Sacred Tent and saw that the sacred cloud had covered it, and the glory of Yahweh had appeared. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Aaron and Moses/I went and stood in front of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Then Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Get away from these people, in order that I can get rid of them immediately without injuring you two!” But Aaron and Moses/I prostrated themselves/ourselves on the ground and prayed. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Moses/I said to Aaron, “Quickly take another pan and put in it some burning/hot coals from the altar. Put incense in the pan, and carry it out among the people to atone for the sins of the people. Yahweh is very angry with them, and I know that a ◄severe plague/bad sickness► has already started among them.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","So Aaron did what Moses/I told him. He took the burning incense out among the people. The plague had already started to strike the people, but Aaron continued to burn the incense so that God would forgive them for the sins they had committed. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","He stood between the people who had already died and those who were still alive, and then the plague stopped. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","But 14,700 people had already died from that plague/sickness, in addition to the people who died with Korah. ");
INSERT INTO eng_t4t_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Then after the plague had ended, Aaron and Moses/I returned to the entrance of the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Then Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Tell the Israeli people to bring to you twelve walking sticks. They should bring one from each of the leaders of the twelve tribes. You should carve each leader’s name on his stick. ");
INSERT INTO eng_t4t_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","There must be one stick for the leader of each tribe, so you must carve Aaron’s name on the stick for the tribe of Levi. ");
INSERT INTO eng_t4t_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Put those sticks inside the Sacred Tent, in front of the sacred chest that has in it the tablets on which the Ten Commandments are written. That is the place where I always talk with you. ");
INSERT INTO eng_t4t_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Buds will sprout on the stick of the man whom I have chosen to be the priest. When the people see that, they will stop their constantly complaining about you because they will realize that you are the one whom I have chosen.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","So Moses/I told the people what Yahweh had said. Then each of the twelve Israeli leaders, including Aaron, brought his walking stick to Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Moses/I placed the sticks inside the Sacred Tent in front of the sacred chest. ");
INSERT INTO eng_t4t_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","The following morning, when he/I went into the tent, he/I saw that Aaron’s stick, which represented the tribe of Levi, had sprouted, it had produced leaves and blossoms, and it had also produced almonds that were ripe! ");
INSERT INTO eng_t4t_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Moses/I brought all the sticks out of the Sacred Tent and showed them to the people. Each of the twelve leaders took back his own stick. ");
INSERT INTO eng_t4t_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Then Yahweh said to Moses/me, “Put Aaron’s stick in front of the sacred chest, and let it stay there permanently. That will be a warning to people who want to rebel against me. Then no more people will die because of complaining against me.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","So Moses/I did what Yahweh had commanded. ");
INSERT INTO eng_t4t_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Then the Israeli people said to Moses/me, “We are going to die! All of us are surely going to die! ");
INSERT INTO eng_t4t_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Everyone who comes close to Yahweh’s Sacred Tent dies. Are the rest of us going to die, also?” RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Yahweh said to Aaron, “You and your sons and the other members of your father’s family are the ones ◄who will be punished/whom I will punish► if anything bad happens to the things inside the Sacred Tent. But only you and your sons will be punished if the priests do something bad. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Require that those who belong to your tribe, the tribe of Levi, must assist you and your sons while you perform your work at the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","But while they do that work, they must not go near the sacred items inside the tent or near the altar. If they do that, they will die, and you will die, too! ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","They may assist you in doing all the work to take care of the Sacred Tent, but no one else is permitted to come near the place where you are working. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“You are the ones who will do the sacred work inside the Sacred Tent and at the altar. If you obey these instructions, I will not become very angry with the Israeli people again. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","I myself have chosen the descendants of Levi from the other Israelis in order that they may be your special helpers. They are like a gift that I have given you to work at the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","But it is you and your sons, who are the priests, who must perform all the rituals concerning the altar and with what happens inside the Very Holy Place. I am giving to you this work of serving as priests. So anyone else who tries to do that work must be executed.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Yahweh also said to Aaron, “I myself have appointed you to take care of all the sacred offerings that the Israeli people bring to me. I have given all these sacred offerings to you and to your sons. You and your descendants will get a share of these offerings permanently. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","The parts of the offerings that are not completely burned on the altar belong to you. Those parts of the sacred offerings, including the offerings of grain, the offerings for sins and for the people to be forgiven for not giving me what they are required to give, are set apart, and are to be given to you and your sons. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","You must eat those offerings in a sacred place, near the Sacred Tent. You and all of the other males in your clan may eat them, but you must consider those offerings to be holy/dedicated to me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“The priests lift up high the sacred offerings while they are standing in front of the altar. All of those offerings that the Israelis offer to me belong to you and your sons and daughters. They will always be your share. All the members of your family who have performed the rituals to cause them to  be acceptable to me are permitted to eat from these offerings. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“ am also giving to you the first food that people harvest each year and bring to me—the best olive oil and new wine and grain. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","All of the first crops that people harvest and bring to me belong to you. Anyone in your family who has performed the ritual to become acceptable to me is permitted to eat that food. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Everything in Israel that is set apart to belong to me also belongs to you. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","The firstborn males, both humans and domestic animals, that are offered to me, will be yours. But people must buy back their firstborn sons and the firstborn animals that may not be used for sacrifices. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","They must buy them back when they are one month old. The price that they must pay for each one is five pieces of silver. They must weigh the silver on the scales that are in the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“But they are not permitted to buy back the firstborn cattle or sheep or goats. They are holy and have been set apart for me. Slaughter them and sprinkle their blood on the altar. Then completely burn the fat of those animals on the altar to be an offering to me. The smell as they burn will be very pleasing to me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","The meat from those offerings will be yours, just like the breast and right thigh of animals that are presented to me to maintain fellowship with me as the priest lifts them up high in front of the altar are yours. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Anything that the Israeli people present to me as holy/sacred gifts, I am giving to you. They are for you and your sons and daughters to eat. They will always be your share. This is an agreement that I am making with you, an agreement that will ◄last forever/never be changed►. I am also making this agreement with your descendants.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Yahweh also said to Aaron, “You priests will not receive any of the land or the property like the other Israeli people will receive. I am what you will receive. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Then the Israeli people bring to me a tenth of all the crops and of their newborn animals, I will give that to you descendants of Levi. That will be your payment for the work you do at the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","The other Israelis must not go near that tent. If they go near it, I will consider that their doing that is a sin, and  they will die for committing that sin. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Only the descendants of Levi are permitted to work at the Sacred Tent, and they will be punished if anything bad happens to it. That is a law that will never be changed. You descendants of Levi will not receive any land among the other Israeli people, ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","because I will give you one tenth of all the crops and animals that the Israelis bring to be offerings to me. That is why I said that you will not receive any land like the other Israelis will receive.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Yahweh said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Tell this to the descendants of Levi: ‘When you receive one tenth of all the crops and animals from the Israeli people, you must give one tenth of all that to me to be a sacred offering. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Just like the other Israelis give one tenth of the grain and wine that they produce, ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","you must give to me one tenth of all that you receive from them. That will be your sacred offering to me. You must present it to Aaron. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Select the best parts of the things that are given to you to give them to me.’ ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Also, tell this to the descendants of Levi: ‘When you present those best portions of grain and wine as your offering to me, I will consider that those gifts are as though they came from your own grain fields and vineyards. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","You descendants of Levi and your families are permitted to eat the rest of that food, and you may eat it wherever you want to, because it is your payment for the work that you do at the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","If you give to the priests the best portions of what you receive, you will not be punished by me for accepting one tenth of the gifts that the people bring to me. But you must consider those gifts to be sacred/holy. If you sin by eating those things in ways that are contrary to these regulations that I have given to you, you will be executed.’ ” ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Yahweh said to Aaron and Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“I am now giving to you another regulation. Tell the Israeli people to bring to you one reddish-brown cow that has no defects. It must be an animal that ◄has never been/no one has ever► used for plowing ground. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Give it to Eleazar, the priest. He must take it outside the camp and slaughter it and drain the blood in a basin. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","He must dip one of his fingers in the blood and sprinkle some of it seven times on the ground near the Sacred Tent. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Then, while Eleazar watches, the cow must be burned completely—its hide, its meat, the rest of its blood, and even its dung. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Eliezer then must take a stick of cedar wood, a stalk of a plant named hyssop, and some scarlet/red yarn, and throw them into the fire where the cow is burning. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","“Then the priest must wash his clothes and bathe. After doing that, he may return to the camp. But he will be unfit for doing any sacred work until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","The man who burns the cow must also wash his clothes and bathe, and he will also be unacceptable to me until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Then someone who has not become unacceptable to me must gather up the ashes of the cow and put them in a ◄sacred place/place that is acceptable to me► outside the camp. The ashes must be kept there for the people of Israel to use when they mix it with water for the ritual to remove the guilt of sin. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","The man who gathers up the ashes of the cow must also wash his clothes, and he also will be unfit to do any more sacred work until that evening. That is a regulation that will never be changed. It must be obeyed by you Israeli people and by any foreigners who live among you. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“All those who touch a corpse will be unacceptable to me for seven days. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","On the third day and on the seventh day after touching a corpse, in order to become acceptable to me again, they must have sprinkled on them some of that water for removing the guilt of their sin. If they do not do that on both of those days, they will continue to be unacceptable to me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","All those who touch a corpse, and do not perform in the correct way the ritual to become acceptable to me again, defile Yahweh’s Sacred Tent. They will no longer be permitted to live among the Israeli people. The water to remove the guilt of sin was not sprinkled on them, so they continue to be unacceptable to me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“There is another ritual that must be performed when someone dies inside a tent. All those who were inside that tent when that person died or who enter that tent will be unacceptable to me for seven days. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Any jars that are inside that tent that are not covered are not permitted to be used. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","If someone who is out in a field touches the corpse of someone who was murdered, or who died from natural causes, or if someone touches a bone from some human or touches a grave, that person will be unacceptable to me for seven days. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“For someone like that to become acceptable to me again, some of the ashes from the cow that was burned must be taken and put in a jar. Then some fresh water must be poured over the ashes. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Then someone who is still acceptable to me must take a stalk of a plant named hyssop and dip it into the water. Then that person must sprinkle some of the water on the tent where that person died, on the things that are in the tent, and on the people who were in the tent. He must also sprinkle some of that water on any person who touched a human bone or who touched a person who died, or who touched a grave. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","On the third day and on the seventh day after that, the person who is acceptable to me must sprinkle some of that water on those who have become unacceptable to me. On the seventh day, the people who are performing that ritual to become acceptable to me again must wash their clothes and bathe. If they do that, on that evening they will become acceptable to me again. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“If those who have become unacceptable to me do not become acceptable to me again by doing this, they will no longer be permitted to live among the Israeli people, because they have defiled my Sacred Tent. They did not sprinkle on themselves the water that removes the guilt of their sins, so they remain unacceptable to me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","That is a law for the Israeli people that will never be changed. Those who sprinkle that water on themselves must then wash their clothes. And anyone who touches that water which removes guilt for sins will remain unacceptable to God until that evening. ");
INSERT INTO eng_t4t_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","“If someone touches a thing or a person that has become unacceptable to me, that person will remain unacceptable to me until that evening.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","In March/April of the next year, the Israeli people traveled/walked to the Zin Desert and ◄camped/set up their tents► near Kadesh town. While they/we were there, Moses’/my older sister Miriam died and was buried there. ");
INSERT INTO eng_t4t_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","There was no water for the people to drink there, so they came to Aaron and Moses/me. ");
INSERT INTO eng_t4t_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","They complained and said, “We wish that we had died in front of Yahweh’s Sacred Tent when our fellow Israelis died! ");
INSERT INTO eng_t4t_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","◄Did you bring us, who are Yahweh’s people, into this desert to die along with our livestock?/You brought us, who are Yahweh’s people, into this desert to die along with our livestock!► RHQ ");
INSERT INTO eng_t4t_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Why did you bring us from Egypt to this miserable place RHQ? There is no grain, there are no figs, no grapes, and no pomegranates here. And there is no water for us to drink!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Aaron and Moses/I turned away from the people and went to the entrance of the Sacred Tent and prostrated themselves/ourselves on the ground. Then Yahweh appeared to them/us with his bright glory, ");
INSERT INTO eng_t4t_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","and he said to Moses/me, ");
INSERT INTO eng_t4t_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“You and Aaron must take Aaron’s walking stick with you and gather all the people together. While the people are watching, command that water will flow out of that large rock over there. Water for the people will flow from it; all they and all their livestock will have enough water to drink.” ");
INSERT INTO eng_t4t_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","So Moses/I did what Yahweh told him/me to do. He/I took Aaron’s walking stick from the place in the Sacred Tent where it was kept. ");
INSERT INTO eng_t4t_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Then Aaron and he/I summoned all the people to gather at the rock. Then Moses/I shouted to them, “All you rebellious people, listen! Is it necessary for us to give you water from this rock?” ");
INSERT INTO eng_t4t_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Then Moses/I raised his/my hand and instead of speaking to the rock, he/I struck the rock two times with the walking stick. And water gushed/poured out. So all the people and their livestock drank all the water that they wanted. ");
INSERT INTO eng_t4t_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","But Yahweh said to Aaron and Moses/me, “You did not believe that I could demonstrate my power to the Israeli people and give them water without your striking the rock. So you will not lead them into the land that I am giving to them!” ");
INSERT INTO eng_t4t_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Later this place was called Meribah, which means ‘arguing’, because there the Israeli people argued with Yahweh, and there he showed 