﻿USE sofia;
DROP TABLE IF EXISTS sofia.eng_glw_vpl;
CREATE TABLE eng_glw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES eng_glw_vpl WRITE;
INSERT INTO eng_glw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","In the beginning was the Word, and the Word was with God, and the Word was God. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","He was in the beginning with God. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Everything was made through Him, and without Him nothing was made that was made. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","In Him was life, and that life was the light of mankind. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","The light shines in the darkness, but the darkness hasn’t overcome it. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","There was a man sent from God, whose name was John. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","This man came as a witness, to testify about the light, that all through him might believe. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","He wasn’t that light, but was sent as a witness of that light. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","The true light that enlightens everyone was coming into the world. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","The Word was in the world, and though the world was made through Him, the world didn’t recognize Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","He came to His own, and those who were His own didn’t receive Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","But as many as received Him, to them He gave the right to become God’s children, to those who believe in His name: ");
INSERT INTO eng_glw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","who were born, not of blood, nor of the will of the flesh, nor of the will of man, but of God. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","The Word became flesh and lived among us, and we saw His glory, the glory as of the only Son of the Father, full of grace and truth. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John testified about Him. He cried out, saying, “This was He who I told you about when I said, ‘He who comes after me has surpassed me because He was before me.’” ");
INSERT INTO eng_glw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","From His fullness we have all received grace upon grace. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","The Law was given through Moses, but grace and truth came through Jesus Christ. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","No one has ever seen God, but God’s only born Son, who is near to the heart of His Father, has made Him known. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Now this is the testimony of John, when the Jews sent priests and Levites from Jerusalem to ask him, “Who are you?” ");
INSERT INTO eng_glw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","He confessed, and didn’t deny, but confessed, “I’m not the Christ.” ");
INSERT INTO eng_glw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","They asked him, “Then who are you? Are you Elijah?” He said, “I am not.” “Are you the Prophet?” He answered, “No.” ");
INSERT INTO eng_glw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Then they asked him, “Who are you? Give us an answer to take back to those who sent us. What do you say about yourself?” ");
INSERT INTO eng_glw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","John replied in the words of Isaiah the prophet, “I am the voice of one calling in the desert, ‘Make straight the way for the Lord.’” ");
INSERT INTO eng_glw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Now those who were sent were Pharisees. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","They asked him, saying, “Why then do you baptize if you aren’t the Christ, nor Elijah, nor the Prophet?” ");
INSERT INTO eng_glw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","John answered them, saying, “I baptize with water, but One stands among you that you don’t know. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","It is He who, coming after me, is preferred before me, whose sandal strap I’m not worthy to untie.” ");
INSERT INTO eng_glw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","This all happened at Bethany on the other side of the Jordan, where John was baptizing. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","The next day, John saw Jesus coming toward him, and said, “Look! God’s Lamb who takes away the sin of the world! ");
INSERT INTO eng_glw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","This is the One I meant when I said, ‘A man who comes after me is preferred before me because He existed before me.’ ");
INSERT INTO eng_glw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","I didn’t know Him, but the reason I came baptizing with water was that He might be revealed to Israel.” ");
INSERT INTO eng_glw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","John testified, saying, “I saw the Spirit descending from Heaven like a dove, and He remained upon Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","I wouldn’t have known Him, but He who sent me to baptize with water told me, ‘Whoever you see the Spirit descending upon, and remaining on Him, this is He who baptizes with the Holy Spirit.’ ");
INSERT INTO eng_glw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","I have seen and I testify that this is God’s Son.” ");
INSERT INTO eng_glw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","The next day, John again stood with two of His disciples. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","When he saw Jesus passing by, he said, “Look, God’s Lamb!” ");
INSERT INTO eng_glw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","The two disciples heard him say this, and they followed Jesus. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus turned, and seeing them following, asked them, “What are you looking for?” They said to Him, “Rabbi” (which, when translated, means Teacher), “Where are You staying?” ");
INSERT INTO eng_glw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","He told them, “Come and see.” They came and saw where He was staying, and spent that day with Him. It was about the tenth hour. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrew, Simon Peter’s brother, was one of the two who heard what John had said and who had followed Jesus. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","The first thing Andrew did was to find his brother, Simon, and tell him, “We have found the Messiah” (that is, translated, the Christ). ");
INSERT INTO eng_glw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrew brought Simon to Jesus. Jesus looked at him, and said, “You are Simon the son of Jonah. You will be called Cephas” (which is translated Peter). ");
INSERT INTO eng_glw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","The next day Jesus decided to leave for Galilee. Finding Philip, he told him, “Follow me.” ");
INSERT INTO eng_glw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Philip was from Bethsaida, the city of Andrew and Peter. ");
INSERT INTO eng_glw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip found Nathanael and told him, “We have found Him who Moses in the Law, and also the prophets, wrote about — Jesus of Nazareth, the son of Joseph.” ");
INSERT INTO eng_glw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathanael asked Philip, “Can anything good come out of Nazareth?” Philip told Nathanael, “Come and see.” ");
INSERT INTO eng_glw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesus saw Nathanael coming toward Him, and said of Nathanael, “Look! An Israelite indeed, who has no deceit in him!” ");
INSERT INTO eng_glw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael asked Him, “How do You know me?” Jesus answered, “Before Philip called you, when you were under the fig tree, I saw you.” ");
INSERT INTO eng_glw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanael answered, “Rabbi, You are God’s Son. You are the King of Israel.” ");
INSERT INTO eng_glw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus said to him, “Because I told you that I saw you under the fig tree, do you believe? You will see greater things than these.” ");
INSERT INTO eng_glw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","And He told him, “Most assuredly, I tell you, you will see Heaven opened, and God’s angels ascending and descending on the Son of Man.” ");
INSERT INTO eng_glw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","On the third day there was a wedding in Cana of Galilee, and Jesus’ mother was there. ");
INSERT INTO eng_glw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Now both Jesus and His disciples were invited to the wedding. ");
INSERT INTO eng_glw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","When they ran out of wine, Jesus’ mother told Him, “They have no wine.” ");
INSERT INTO eng_glw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesus said to her, “Woman, what does that have to do with you and me? My time has not yet come.” ");
INSERT INTO eng_glw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","His mother told the servants, “Do whatever He tells you.” ");
INSERT INTO eng_glw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nearby stood six stone water jars, the kind used by the Jews for ceremonial washing, each holding two to three metretes. ");
INSERT INTO eng_glw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus told the servants, “Fill the jars with water,” so they filled them to the brim. ");
INSERT INTO eng_glw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Then He told them, “Now draw some out and take it to the master of the banquet.” They did so, ");
INSERT INTO eng_glw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","and the master of the banquet tasted the water that had been turned into wine. He didn’t realize where it had come from, though the servants who had drawn the water knew. Then he called the bridegroom aside ");
INSERT INTO eng_glw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","and said, “Everyone brings out the choice wine first, and then the cheaper wine after the guests have drunk freely, but you have saved the best till now!” ");
INSERT INTO eng_glw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesus did this beginning of signs in Cana of Galilee. He revealed His glory, and His disciples believed in Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","After this, He went down to Capernaum with His mother, His brothers, and His disciples, and they stayed there only a few days. ");
INSERT INTO eng_glw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","The time for the Passover of the Jews was near, and Jesus went up to Jerusalem. ");
INSERT INTO eng_glw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","He found in the temple those who sold oxen and sheep and doves, and the money changers doing business. ");
INSERT INTO eng_glw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","When He had made a whip of cords, He drove them all out of the temple, with the sheep and the oxen, and poured out the changers’ money and overturned the tables. ");
INSERT INTO eng_glw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","He told those who sold doves, “Take these things away! Don’t make my Father’s house a market place!” ");
INSERT INTO eng_glw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Then His disciples remembered that it was written, “Zeal for Your house will consume me.” ");
INSERT INTO eng_glw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","So the Jews answered and asked Him, “What sign do You show to us, since You do these things?” ");
INSERT INTO eng_glw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus answered them, “Destroy this temple, and in three days I will raise it up.” ");
INSERT INTO eng_glw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Then the Jews said, “It has taken forty-six years to build this temple, and will You raise it up in three days?” ");
INSERT INTO eng_glw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","But the temple He had spoken of was His body. ");
INSERT INTO eng_glw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","After He was raised from the dead, His disciples recalled what He had said. Then they believed the Scripture and the words that Jesus had spoken. ");
INSERT INTO eng_glw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Now while He was in Jerusalem at the Passover Feast, many people saw the miraculous signs He was doing and believed in His name. ");
INSERT INTO eng_glw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","But Jesus didn’t commit Himself to them, because He knew all people, ");
INSERT INTO eng_glw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","and had no need for anyone to testify about people, for He knew what was in people. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","There was a Pharisee, a man named Nicodemus, a ruler of the Jews. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","This man came to Jesus by night, and said to Him, “Rabbi, we know that You have come from God as a teacher, for no one can do these signs that You do unless God is with him.” ");
INSERT INTO eng_glw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus answered and told him, “Most assuredly, I tell you, unless one is born again, that person can’t see the kingdom of God.” ");
INSERT INTO eng_glw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemus asked Him, “How can a man be born when he is old? He can’t go back into his mother’s womb and be born, can he?” ");
INSERT INTO eng_glw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus answered, “Most assuredly, I tell you, unless one is born of water and the Spirit, that one can’t enter the Kingdom of God. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","That which is born of the flesh is flesh, and that which is born of the Spirit is spirit. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Don’t marvel that I told you, ‘You must be born again.’ ");
INSERT INTO eng_glw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","The wind blows where it wants to, and you hear its sound, but can’t tell where it comes from and where it goes. So is everyone who is born of the Spirit.” ");
INSERT INTO eng_glw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemus asked Him, “How can these things be?” ");
INSERT INTO eng_glw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","“Are you Israel’s teacher,” asked Jesus, “and yet you don’t understand these things? ");
INSERT INTO eng_glw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Most assuredly, I tell you, we speak what we know and testify what we have seen, and you don’t receive our witness. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","If I have told you earthly things and you don’t believe, how will you believe if I tell you heavenly things? ");
INSERT INTO eng_glw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","No one has ever gone up into Heaven except the one who came from Heaven — the Son of Man. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Just as Moses lifted up the snake in the desert, so the Son of Man must be lifted up, ");
INSERT INTO eng_glw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","that everyone who believes in Him should not die, but have eternal life. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","For God so sincerely loved the world that He gave His only born Son, that whoever believes in Him should not perish, but have everlasting life. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","For God didn’t send His Son into the world to condemn the world, but to save the world through Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Whoever believes in Him is not condemned, but whoever doesn’t believe is condemned already because that person has not believed in the name of God’s only Son. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","This is the condemnation, that light has come into the world, but people sincerely loved darkness rather than light, because their deeds were evil. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Everyone who practices evil hates the light, and doesn’t come to the light, for fear that their deeds will be exposed. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Whoever practices the truth comes to the light to show clearly that their deeds have been done with God.” ");
INSERT INTO eng_glw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","After this, Jesus and His disciples went out into the countryside of Judea, where He remained with them, and baptized. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","John was also baptizing at Aenon, near Salim, because there was plenty of water there, and people kept coming to be baptized. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","John had not yet been thrown into prison. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","There were some questions between some of John’s disciples and the Jews about purification. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","They came to John and told him, “Rabbi, He who was with you beyond the Jordan, that you have testified about — look, He is baptizing, and everyone is flocking to Him!” ");
INSERT INTO eng_glw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","John replied, “A man can receive nothing, unless it’s given to him from Heaven. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","You yourselves can testify that I said, ‘I’m not the Christ, but I have been sent ahead of Him.’ ");
INSERT INTO eng_glw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","The bride belongs to the bridegroom. The friend who attends the bridegroom waits and listens for him, and rejoices when he hears the bridegroom’s voice. This joy of mine is now made complete. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","He must increase, but I must decrease. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“He who comes from above is above all. He who is of the Earth belongs to the Earth and speaks of the Earth. He who comes from Heaven is above all. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","He testifies about what He has seen and heard, but no one accepts His testimony. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","The man who has accepted His testimony has certified that God is truthful. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","The one that God has sent speaks God’s words, for God gives the Spirit without measure. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","The Father sincerely loves the Son, and has given everything into His hand. ");
INSERT INTO eng_glw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Whoever believes in the Son has eternal life, but whoever rejects the Son won’t see life, for God’s wrath remains on that person.” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Therefore when the Lord knew that the Pharisees had heard that Jesus was gaining and baptizing more disciples than John ");
INSERT INTO eng_glw_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(although Jesus Himself wasn’t baptizing, but His disciples were), ");
INSERT INTO eng_glw_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","He left Judea, and went back towards Galilee. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","He had to go through Samaria. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","He came to a city of Samaria, called Sychar, near the parcel of ground that Jacob gave to his son Joseph, ");
INSERT INTO eng_glw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","and Jacob’s well was there. Jesus therefore, being tired from His journey, sat down by the well. It was about the sixth hour. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","A Samaritan woman came to draw water. Jesus said to her, “Please give me a drink.” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","His disciples had gone into the town to buy food. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","The Samaritan woman therefore asked Him, “How is it that You, being a Jew, ask me for a drink, since I’m a Samaritan woman?” (For Jews have nothing to do with Samaritans.) ");
INSERT INTO eng_glw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus answered her, “If you knew God’s gift, and who it is who says to you, ‘Please give me a drink,’ you would have asked Him, and He would have given you living water.” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","The woman said, “Sir, you have nothing to draw with and the well is deep. Where could you get this living water from? ");
INSERT INTO eng_glw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Are You greater than our forefather Jacob, who gave us this well and who used to drink from it himself, as did also his sons and his flocks and herds?” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus answered her, “Everyone who drinks of this water will get thirsty again, ");
INSERT INTO eng_glw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","but whoever drinks the water that I will give will never, ever get thirsty. The water that I will give will become in that person a fountain of water springing up into everlasting life.” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","The woman said to him, “Sir, give me this water so that I won’t get thirsty and have to keep coming all the way here to draw water.” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus told her, “Go, call your husband, and come here.” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","The woman answered, “I have no husband.” Jesus told her, “You are right in saying, ‘I have no husband,’ ");
INSERT INTO eng_glw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","for you have had five husbands, and the one you have now isn’t your husband. What you have said is quite true.” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","The woman said to Him, “Sir, I perceive that You are a prophet. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Our ancestors worshipped on this mountain, but you Jews say that the place where we must worship is in Jerusalem.” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus told her, “Woman, believe me, a time is coming when you will worship the Father neither in this mountain, nor in Jerusalem. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","You Samaritans worship what you don’t know. We worship what we know, for salvation is from the Jews. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","A time is coming, and has now come, when the true worshipers will worship the Father in spirit and truth, for they are the kind of worshipers that the Father seeks. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God is spirit, and those who worship Him must worship in spirit and truth.” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","The woman said to Him, “I know that the Messiah (who is called Christ) is coming. When He comes, He will explain everything to us.” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus told her, “I who speak to you am He.” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Just then Jesus’ disciples returned. They were surprised to find him talking with a woman, but no one asked, “What do you want?” or “Why are you talking with her?” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Then, leaving her water jar, the woman went back to the town and began telling the people, ");
INSERT INTO eng_glw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Come, see a man who told me everything that I ever did. Could this be the Christ?” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","They went out of the city, and started to go to Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Meanwhile, the disciples urged Him, saying “Rabbi, eat something.” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","He told them, “I have food to eat that you don’t know about.” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","So the disciples asked one another, “Nobody brought Him anything to eat, did they?” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus told them, “My food is to do the will of Him who sent me, and to accomplish His work. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Don’t you say, ‘It’s still four months until the harvest’? Look, I tell you, lift up your eyes, and look at the fields! They are ripe for harvest. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","He who harvests is already receiving wages, and is gathering fruit for eternal life, so that he who plants and he who harvests may rejoice together. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Thus the saying ‘One plants and another harvests’ is true. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","I sent you to harvest that for which you didn’t labor. Others have labored, and you have entered into their labor.” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Many Samaritans from that town believed in Jesus because of the woman’s testimony, “He told me everything that I ever did.” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","So when the Samaritans arrived, they asked Him to stay with them, and He stayed there two days. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Many more believed because of His words. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","They told the woman, “It’s no longer just because of what you said that we believe, for we have heard for ourselves, and we know that this is truly the Savior of the world, the Christ.” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","After the two days, He departed from there and went to Galilee, ");
INSERT INTO eng_glw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","for Jesus Himself testified that a prophet has no honor in his own country. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","When He arrived in Galilee, the Galileans welcomed Him. They had seen all that He had done in Jerusalem at the Passover Feast, for they had been there, too. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Therefore He came back to Cana of Galilee, where He had made the water wine. There was a certain royal official, whose son was sick at Capernaum. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","When he heard that Jesus had come out of Judea into Galilee, he went to Him and begged Him to come down and heal his son, who was at the point of death. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesus told him, “Unless you people see signs and wonders, you will never believe.” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","The royal official said to Him, “Sir, come down before my child dies!” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus told him, “Go in peace. Your son lives.” So the man believed the words that Jesus spoke to him, and he went his way. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","As he was still going down the road, his servants met him, saying that his son was living. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","So he asked them the hour when he began to recover, and they told him, “Yesterday at the seventh hour, the fever left him.” ");
INSERT INTO eng_glw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","The father realized that it was at that hour that Jesus told him, “Your son lives,” and he himself believed, along with his whole household. ");
INSERT INTO eng_glw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","This was the second sign that Jesus did, when He had come from out of Judea to Galilee. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","After this, there was a feast of the Jews, and Jesus went up to Jerusalem. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Near the Sheep Gate in Jerusalem, there is a pool, which is called Bethesda in Hebrew. It’s surrounded by five covered colonnades. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","In these lay a great multitude of sick people, blind, lame, or paralyzed, waiting for the moving of the water, ");
INSERT INTO eng_glw_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","for an angel went down from time to time into the pool and stirred up the water. Whoever stepped in first, after the stirring of the water, was made well of whatever disease that person had. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","A certain man was there who had an infirmity thirty-eight years. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","When Jesus saw him lying there, and knew that he had already been sick for a long time, He asked him, “Do you want to be made well?” ");
INSERT INTO eng_glw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","The sick man answered, “Sir, I have no one to put me into the pool when the water is stirred up, but while I’m coming, another steps down before me.” ");
INSERT INTO eng_glw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesus told him, “Stand up, pick up your mat, and walk.” ");
INSERT INTO eng_glw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Immediately, the man was made well, took up his mat, and walked. That was on the Sabbath day. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Therefore the Jews were telling him who was cured, “It’s the Sabbath, and it isn’t legal for you to carry your mat.” ");
INSERT INTO eng_glw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","He answered them, “He who made me well told me, ‘Take up your mat and walk.’” ");
INSERT INTO eng_glw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Then they asked him, “Who told you to ‘Take up your mat and walk’?” ");
INSERT INTO eng_glw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","The man who had been healed didn’t know who it was, because Jesus had disappeared into the crowd. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Later, Jesus found him in the temple and told him, “See, you have been made well! Don’t sin any more, so that nothing worse happens to you.” ");
INSERT INTO eng_glw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","The man went away, and told the Jews that it was Jesus who had made him well. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","For this reason, the Jews persecuted Jesus, and sought to kill Him, because He was doing these things on the Sabbath. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesus answered them, “My Father is still working, so I am working, too.” ");
INSERT INTO eng_glw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Because of this, the Jews tried all the harder to kill Him. Not only was He breaking the Sabbath, but He was even calling God His own Father, making Himself equal with God. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Then Jesus answered, “Most assuredly, I tell you, the Son can do nothing of Himself, unless He sees the Father do it, for whatever He does, the Son does likewise. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","The Father loves the Son, and shows Him everything that He Himself does. He will show Him even greater works than these, that you may marvel. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","As the Father raises the dead and gives life to them, even so the Son gives life to whoever He wishes. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","The Father judges no one, but has committed all judgment to the Son, ");
INSERT INTO eng_glw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","that all may honor the Son just as they honor the Father. He who doesn’t honor the Son doesn’t honor the Father who sent Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Most assuredly, I tell you, the person who hears my words and believes in Him who sent me has everlasting life, and won’t come into judgment, but has passed from death into life. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Most assuredly, I tell you, the time is coming, and now is, when the dead will hear the voice of God’s Son, and those who hear will live. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","For just as the Father has life in Himself, so He has granted the Son to have life in Himself, ");
INSERT INTO eng_glw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","and has given Him authority to execute judgment, because He is the Son of Man. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Don’t marvel at this, for the time is coming in which all who are in the graves will hear His voice ");
INSERT INTO eng_glw_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","and come out — those who have done good, to the resurrection of life, and those who have done evil, to the resurrection of condemnation. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","I can do nothing by myself. As I hear, I judge, and my judgment is righteous, because I don’t seek my own will, but the will of the Father who sent me. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“If I testify about myself, my testimony isn’t valid. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","There is another who testifies on my behalf, and I know that his testimony about me is valid. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","You have sent to John, and he has testified to the truth. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Not that I accept human testimony, but I tell you this so that you may be saved. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John was the burning and shining lamp, and you were willing for a time to rejoice in his light. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","I have a greater testimony than John’s. The works that the Father has given me to finish — the very works that I do — testify about me, that the Father has sent me. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","The Father Himself, who sent me, has testified about me. You have neither heard His voice at any time, nor seen His form. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","You don’t have His words dwelling in you, because you don’t believe the One who He sent. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","You search the Scriptures, for in them you think you have eternal life, and these testify about me. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Yet you refuse to come to me to have life. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“I don’t accept glory from men, ");
INSERT INTO eng_glw_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","but I know you. I know that you don’t have God’s sincere love in you. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","I have come in my Father’s name, and you don’t accept me, but if someone else comes in his own name, you will accept him. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","How can you believe when you accept glory from one another, and don’t seek the glory that comes from the only God? ");
INSERT INTO eng_glw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Don’t think that I will accuse you before the Father. Your accuser is Moses, who you have set your hope on. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","If you believed Moses, you would believe me, for he wrote about me. ");
INSERT INTO eng_glw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","If you don’t believe what he wrote, how will you believe what I say?” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","After this, Jesus went to the other side of the Sea of Galilee, also called the Sea of Tiberias. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","A great multitude was following Him, because they were seeing the signs that He was performing on those who were sick. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesus went up on a mountain side, and sat down with His disciples. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","The Jewish Passover Feast was near. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesus looked up, and saw that a great multitude was coming to Him, so He asked Philip, “Where can we buy bread, so that these may eat?” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","He said this to test him, for He knew what He would do. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip answered, “Two hundred denarii worth of bread wouldn’t even be enough for everyone to receive a little!” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","One of Jesus’ disciples, Andrew, Simon Peter’s brother, said to Him, ");
INSERT INTO eng_glw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“There is a boy here who has five barley loaves and two fish, but what is that among so many people?” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesus said, “Have the people sit down.” There was plenty of grass there, so the men sat down, in number about five thousand. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesus took the loaves, and when He had given thanks, He distributed them to the disciples, and the disciples to those sitting down. He did likewise with the fish, as much as they wanted. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","When they were filled, He told His disciples, “Gather up the leftover pieces, so that nothing may be wasted.” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Therefore they gathered them up, and filled twelve baskets with the pieces of the five barley loaves, which were left over by those who had eaten. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","When the people saw the sign which He had performed, they said, “This is truly the Prophet who is to come into the world.” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","When Jesus perceived that they meant to come and take Him by force to make Him king, He withdrew again to the mountain by Himself. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","When evening came, Jesus’ disciples went down to the sea, ");
INSERT INTO eng_glw_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","got into the boat, and went over the sea toward Capernaum. It was already dark, and Jesus had not come to them. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","The sea arose because a great wind was blowing. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","When they had rowed about twenty-five or thirty stadia, they saw Jesus walking on the sea and drawing near the boat. They were terrified, ");
INSERT INTO eng_glw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","but He told them, “It’s me. Don’t be afraid.” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Then they willingly took Him into the boat, and immediately the boat was at the land where they were going. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","The next day, the crowd that had stayed on the other side of the sea saw that there had been only one boat there. They also saw that Jesus had not gone in the boat with His disciples, but that His disciples had gone away alone. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Then some other boats from Tiberias landed near the place where the people had eaten the bread after the Lord had given thanks. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","When the crowd saw that neither Jesus nor His disciples were there, they got into the boats and went to Capernaum looking for Jesus. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","When they found Him on the other side of the sea, they asked Him, “Rabbi, when did you come here?” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus answered, “Most assuredly, I tell you, you are looking for me, not because you saw the signs, but because you ate the loaves and were filled. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Don’t labor for perishable food, but for the food which endures to everlasting life, which the Son of Man will give you, because God the Father has set His seal on Him.” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Then they asked Him, “What must we do to do God’s works?” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus answered them, “This is God’s work, that you believe in Him who He has sent.” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Therefore they asked Him, “What sign will You perform then, that we may see it and believe You? What work will You do? ");
INSERT INTO eng_glw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Our ancestors ate the manna in the wilderness. As it’s written, ‘He gave them bread from Heaven to eat.’” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesus told them, “Most assuredly, I tell you, Moses didn’t give you the bread from Heaven, but my Father gives you the true bread from Heaven. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","For God’s bread is He who comes down from Heaven and gives life to the world.” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Then they said to Him, “Lord, give us this bread forever.” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus told them, “I am the bread of life. Whoever comes to me will never be hungry, and whoever believes in me will never be thirsty. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","As I told you, you have seen me, and yet you still don’t believe. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","All that the Father gives me will come to me, and whoever comes to me I will never drive away. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","I have come down from Heaven, not to do my own will, but the will of Him who sent me. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","This is the will of the Father who sent me, that of all He has given me I should lose none, but should raise them up at the last day. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","This is also the will of Him who sent me, that everyone who sees the Son and believes in Him may have everlasting life; and I will raise them up at the last day.” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","The Jews then grumbled about Jesus, because He said, “I am the bread which came down from Heaven.” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","They were saying, “Isn’t this Jesus, the son of Joseph, whose father and mother we know? How can He claim, ‘I have come down from Heaven’?” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesus answered, “Stop grumbling among yourselves. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","No one can come to me unless drawn by the Father who sent me, and I will raise that person up on the last day. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","It’s written in the prophets, ‘They will all be taught by God.’ Everyone who has heard and learned from the Father comes to me. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nobody has seen the Father except the one who is from God. He has seen the Father. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Most assuredly, I tell you, everyone who believes in me has everlasting life. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","I am the bread of life. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Your forefathers ate manna in the wilderness, but they died. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","This is the bread which comes down from Heaven, so that one may eat of it and not die. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","I am the living bread that came down from Heaven. Whoever eats of this bread will live forever. The bread that I will give for the life of the world is my flesh.” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Therefore the Jews argued among themselves, saying, “How can this Man give us His flesh to eat?” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Then Jesus told them, “Most assuredly, I tell you, unless you eat the flesh of the Son of Man, and drink His blood, you have no life in you. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Whoever eats my flesh and drinks my blood has eternal life, and I will raise that person up at the last day, ");
INSERT INTO eng_glw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","for my flesh is true food, and my blood is true drink. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","One who eats my flesh and drinks my blood lives in me, and I in that person. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Just as the living Father sent me, and I live because of the Father, so the one who feeds on me will live because of me. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","This is the bread which came down from Heaven, not like the manna your forefathers ate, and died. A person who eats this bread will live forever.” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","He said this while teaching in the synagogue at Capernaum. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Therefore when many of His disciples heard this, they said, “This is a hard teaching. Who can stand to hear it?” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesus, aware that his disciples were complaining about this, asked them, “Does this offend you? ");
INSERT INTO eng_glw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","What if you saw the Son of Man ascend to where He was before? ");
INSERT INTO eng_glw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","The Spirit gives life. The flesh profits nothing. The words that I speak to you are spirit and life. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Yet there are some of you who don’t believe.” Jesus knew from the beginning who didn’t believe, and who would betray Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","He said, “For this reason I have told you, that no one can come to me, unless it has been granted by the Father.” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Because of this, many of His disciples turned back and didn’t walk with him any more. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Then Jesus asked the twelve, “Do you want to go away, too?” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Peter answered Him, “Lord, who will we go to? You have words of eternal life. ");
INSERT INTO eng_glw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","We have come to believe and know that You are the Christ, the Son of the living God.” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesus answered, “Didn’t I choose you, the twelve, yet one of you is a slanderer?” ");
INSERT INTO eng_glw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","He was speaking of Judas Iscariot, Simon’s son, for he, one of the twelve, was going to betray him. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","After these things, Jesus walked in Galilee, for He didn’t want to walk in Judea, because the Jews sought to kill Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Now the Jews’ Feast of Tabernacles was near. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Therefore His brothers told Him, “Leave here and go to Judea, so that Your disciples will see the works that You are doing, too. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nobody does anything in secret while he seeks to be known openly. If You do these things, show Yourself to the world.” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","For even His brothers didn’t believe in Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Then Jesus told them, “My time hasn’t yet come, but your time is always right. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","The world can’t hate you, but it hates me because I testify that its works are evil. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Go up to this feast yourselves. I’m not going up to this feast, yet, for my time hasn’t yet fully come.” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Having said these things to them, He stayed in Galilee. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","When His brothers had gone up to the feast, however, Jesus also went up, not publicly, but in secret. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","The Jews were looking for Him at the feast, and saying, “Where is He?” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","There was much complaining among the people about Him. Some said, “He is good,” but others said, “No, He deceives the people.” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","No one spoke openly of Him for fear of the Jews. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","About the middle of the feast, Jesus went up into the temple and began to teach. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","The Jews marveled, saying, “How does this man know letters, having never been educated?” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesus answered, “My teaching isn’t mine, but His who sent me. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Anyone who wants to do His will shall know if the teaching is from God or if I speak on my own. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","The one who speaks on his own seeks his own glory; but He who seeks the glory of the One who sent Him is true, and no unrighteousness is in Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Didn’t Moses give you the Law, yet none of you keeps the Law? Why are you trying to kill me?” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","The people answered, “You have a demon. Who is trying to kill You?” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus answered, “I did one work, and you all marvel. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses gave you circumcision (not that it’s from Moses, but from the forefathers), and you circumcise a boy on the Sabbath. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","If a boy gets circumcised on the Sabbath, so that the Law of Moses should not be broken, are you angry with me because I made a man completely well on the Sabbath? ");
INSERT INTO eng_glw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Don’t judge by appearance, but judge with righteous judgment.” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Some of the people of Jerusalem said, “Isn’t this the man they are trying to kill? ");
INSERT INTO eng_glw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Look! He is speaking boldly, and they say nothing to Him. The rulers haven’t really concluded that this is the Christ, have they? ");
INSERT INTO eng_glw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Still, we know where this man is from, but when the Christ comes, no one will know where He is from.” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Then Jesus cried out, as He taught in the temple, “You know me, and you know where I’m from. I haven’t come of my own accord, but He who sent me is true, who you don’t know. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","I know Him, because I am from Him, and He sent me.” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Because of this, they were seeking to seize Him, but no one laid hands on Him, because His time had not yet come. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Many of the people believed in Him, saying, “When the Christ comes, will He do more signs than this man has done?” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","The Pharisees heard the crowd murmuring these things about Jesus, and the Pharisees and the chief priests sent officers to seize Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Then Jesus told them, “I will be with you a little while longer, and then I am going to Him who sent me. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","You will look for me, and not find me, and where I am, you can’t come.” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Then the Jews said among themselves, “Where does He intend to go that we won’t be able to find Him? He doesn’t intend to go to the dispersion among the Greeks and teach the Greeks, does He? ");
INSERT INTO eng_glw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","What does He mean by saying, ‘You will look for me, and not find me, and where I am, you can’t come’?” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","On the last and greatest day of the feast, Jesus stood and declared loudly, “If anyone is thirsty, let that person come to me and drink. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Rivers of living water will flow from within whoever believes in me, as the Scripture has said.” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","He said this about the Spirit, who those believing in Him would receive. The Holy Spirit wasn’t yet given, because Jesus wasn’t yet glorified. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","When they heard these words, many in the crowd were saying, “This is really the prophet.” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Others were saying, “This is the Christ,” but some were saying, “Surely the Christ isn’t going to come from Galilee, is He? ");
INSERT INTO eng_glw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Hasn’t the Scripture said that the Christ comes from the seed of David and from the town of Bethlehem, where David was?” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","So there was a division among the crowd because of Jesus. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Some of them wanted to seize Him, but no one laid hands on Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","When the officers went back to the chief priests and Pharisees, they asked them, “Why didn’t you bring Him in?” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","The officers answered, “No man ever spoke like this man!” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Then the Pharisees answered, “You haven’t been deceived, too, have you? ");
INSERT INTO eng_glw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Have any of the rulers or Pharisees believed in Him? ");
INSERT INTO eng_glw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","But this accursed crowd doesn’t know the Law.” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemus (who came to Jesus before, being one of them) asked them, ");
INSERT INTO eng_glw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Does our Law permit us to judge a man before hearing him and finding out what he is doing?” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","They answered him, “You aren’t from Galilee, too, are you? Search and you will see that no prophet comes out of Galilee.” ");
INSERT INTO eng_glw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Then everyone went home, ");
INSERT INTO eng_glw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","but Jesus went to the Mount of Olives. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","At dawn, He came back into the temple. All the people were coming to Him, and He sat down and began to teach them. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","The scribes and the Pharisees brought a woman caught in adultery, and having set her in the midst, ");
INSERT INTO eng_glw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","they told Him, “Teacher, this woman has been caught in adultery, in the very act. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","In the Law, Moses commanded us to stone such women. What do You say?” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","They were saying this, testing Him, so that they might have grounds to accuse Him. Jesus stooped down and wrote on the ground with His finger, as if He didn’t hear. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","When they persisted in asking Him, He straightened up, and told them, “Let whoever is without sin among you be the first to throw a stone at her.” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","He stooped down, again, and wrote on the ground. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","When they heard this, they began to go out one by one, beginning with the older ones. Jesus was left alone with the woman still standing there. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Straightening up, Jesus asked her, “Woman, where are they? Has no one condemned you?” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","She said, “No one, Lord.” Jesus said, “Neither do I condemn you. Go and sin no more.” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesus spoke again to the people, saying, “I am the light of the world. Anyone who follows me won’t walk in the darkness, but will have the light of life.” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Then the Pharisees told Him, “You are testifying on your own behalf, so your testimony isn’t valid.” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus answered, “Even if I testify on my own behalf, my testimony is valid because I know where I came from and where I am going, but you don’t know where I come from or where I am going. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","You judge by human standards, but I am not judging anyone. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Even if I do judge, my judgment is true, because I am not alone, but I am with the Father who sent me. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","It’s also written in your Law that the testimony of two men is valid. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","I am one who bears witness of myself, and my Father who sent me bears witness of me.” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Then they asked Him, “Where is Your Father?” Jesus answered, “You know neither me nor my Father. If you had known me, you would have known my Father, too.” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesus spoke these words in the treasury, as He taught in the temple. Nobody laid hands on Him, for His time had not yet come. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus told them again, “I am going away, and you will look for me, and you will die in your sin. Where I am going, you can’t come.” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Therefore the Jews were saying, “Surely He won’t kill Himself, will He, since He says, ‘Where I am going, you can’t come’?” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesus was saying to them, “You are from below. I am from above. You are of this world. I am not of this world. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Therefore I told you that you will die in your sins, because if you don’t believe that I am He, you will die in your sins.” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Then they asked Him, “Who are You?” Jesus told them, “Just what I have been saying to you from the beginning. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","I have many things to say and judge about you, but He who sent me is true, and I speak to the world those things which I heard from Him.” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","They didn’t realize that He had been speaking to them about the Father. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","So, Jesus said, “When you lift up the Son of Man, then you will know that I am He, and that I do nothing on my own, but I speak these things as the Father taught me. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","He who sent me is with me. He hasn’t left me alone, because I always do the things that are pleasing to Him.” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","As Jesus spoke, many came to believe in Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Then Jesus said to those Jews who believed Him, “If you continue in my words, you are truly my disciples, ");
INSERT INTO eng_glw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","and you will know the truth, and the truth will set you free.” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","They answered Him, “We are Abraham’s descendants, and have never been slaves to anyone. How can you say that we’ll be set free?” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus answered them, “Most assuredly, I tell you, whoever sins is a slave of sin. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","A slave doesn’t remain in the house forever, but a son does belong forever. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Therefore if the Son sets you free, you will be free indeed. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“I know that you are Abraham’s descendants, but you seek to kill me, because my word has no place in you. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","I talk about what I have seen with my Father, and you do what you have heard from your father.” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","They answered, “Abraham is our father.” Jesus told them, “If you were Abraham’s children, you would do the works of Abraham, ");
INSERT INTO eng_glw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","but now you seek to kill me, a man who has told you the truth which I heard from God. Abraham didn’t do this. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","You do the deeds of your father.” Then they said to Him, “We weren’t born of fornication. We have one Father — God.” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus said, “If God were your Father, you would sincerely love me, for I came from God, and now am here. I haven’t come of my own initiative, but He sent me. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Why don’t you understand what I say? It’s because you can’t accept my words. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","You are of your father, the Devil, and you want to do the desires of your father. He was a murderer from the beginning, and doesn’t stand in the truth, because there is no truth in him. Whenever he speaks a lie, he speaks from his own nature, because he is a liar, and the father of lies. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Because I tell the truth, you don’t believe me. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Which of you convicts me of sin? If I tell the truth, why don’t you believe me? ");
INSERT INTO eng_glw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Whoever is from God hears God’s words. The reason you don’t hear them is that you aren’t from God.” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","The Jews answered and asked Him, “Aren’t we right in saying that You are a Samaritan and have a demon?” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus answered, “I don’t have a demon, but I honor my Father, and you dishonor me. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","I don’t seek glory for myself, but there is One who seeks it, and He is the judge. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Most assuredly, I tell you, anyone who keeps my word will never see death.” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Then the Jews answered Him, “Now we know that You have a demon! Abraham is dead, and the prophets, and You say, ‘Anyone who keeps my word will never taste death.’ ");
INSERT INTO eng_glw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Surely You aren’t greater than our forefather Abraham, who died? The prophets died too. Who do You claim to be?” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus answered, “If I honor myself, my honor is nothing. It’s my Father, who you say is your God, who honors me. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Yet you haven’t come to know Him, but I know Him. If I said, ‘I don’t know Him,’ I would be a liar like you, but I do know Him and keep His word. ");
INSERT INTO eng_glw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Your forefather Abraham rejoiced that he would see my day, and he saw it and was glad.” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Then the Jews said to Him, “You aren’t yet fifty years old, and You have seen Abraham?” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus told them, “Most assuredly, I tell you, before Abraham was, I AM.” ");
INSERT INTO eng_glw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Then they took up stones to throw at Him, but Jesus hid Himself and went out of the temple, going through the midst of them, and so passed by. ");
INSERT INTO eng_glw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Passing by, Jesus saw a man who was blind from birth. ");
INSERT INTO eng_glw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","His disciples asked Him, “Rabbi, who sinned, this man or his parents, that he was born blind?” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus answered, “Neither this man nor his parents sinned, but this happened so that God’s works might be revealed in this man. ");
INSERT INTO eng_glw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","We must work the works of Him who sent me, as long as it’s day. Night is coming, when nobody can work. ");
INSERT INTO eng_glw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","As long as I am in the world, I am the world’s light.” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","After Jesus said this, He spat on the ground and made mud with the saliva, put it on the blind man’s eyes, ");
INSERT INTO eng_glw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","and told him, “Go, wash in the pool of Siloam” (which means Sent). So he went away and washed, and came back seeing. ");
INSERT INTO eng_glw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Then the neighbors and those who used to see him as a beggar began to ask, “Isn’t this the man who used to sit and beg?” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Some were saying, “Yes, it is he,” others were saying, “No, but he is like him.” He kept saying, “I’m the one.” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","So they asked him, “How were your eyes opened?” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","He answered, “The man called Jesus made mud, put it on my eyes, and told me, ‘Go to Siloam, and wash’; so I went and washed, and I received sight.” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Where is this man?” they asked him. “I don’t know,” he said. ");
INSERT INTO eng_glw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","They brought the man who used to be blind to the Pharisees. ");
INSERT INTO eng_glw_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Now it was a sabbath day when Jesus made the mud and opened the man’s eyes. ");
INSERT INTO eng_glw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","So the Pharisees were also asking him how he received his sight. He told them, “He applied mud to my eyes, I washed, and I see.” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Therefore some of the Pharisees said, “This Man isn’t from God, because He doesn’t keep the Sabbath.” Others said, “How can a sinner do such signs?” So there was a division among them. ");
INSERT INTO eng_glw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","So they turned again to the blind man and asked, “What do you say about him? It was your eyes he opened.” He said, “He is a prophet.” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","The Jews didn’t believe that he had been blind, and had received sight, until they called the parents of the one who had received his sight, ");
INSERT INTO eng_glw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","and questioned them, saying, “Is this your son, who you say was born blind? Then how does he now see?” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","His parents answered them, “We know that this is our son, and that he was born blind, ");
INSERT INTO eng_glw_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","but how he now sees, we don’t know. Who opened his eyes, we don’t know. Ask him. He is of age. He will speak for himself.” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","His parents said this because they were afraid of the Jews, for the Jews had already agreed that if anyone would confess that Jesus was the Christ, they would be put out of the synagogue. ");
INSERT INTO eng_glw_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","For this reason, his parents said, “Ask him. He is of age.” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","So they called the man who had been blind a second time, and told him, “Give glory to God. We know that this man is a sinner.” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","He answered, “Whether He is a sinner or not I don’t know. One thing I do know: that though I was blind, now I see.” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Then they asked him again, “What did He do to you? How did He open your eyes?” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","He answered, “I told you already, and you didn’t listen. Why do you want to hear it again? You don’t want to become His disciples, too, do you?” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Then they became abusive towards him and said, “You are that man’s disciple, but we are Moses’ disciples. ");
INSERT INTO eng_glw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","We know that God spoke to Moses, but as for this man, we don’t know where He is from.” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","The man answered, “How amazing! You don’t know where He comes from, yet He opened my eyes. ");
INSERT INTO eng_glw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","We know that God doesn’t hear sinners, but if anyone is God-fearing, and does His will, He hears him. ");
INSERT INTO eng_glw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Since the beginning of time it has never been heard of that anyone opened the eyes of a person born blind. ");
INSERT INTO eng_glw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","If this man weren’t from God, He could do nothing.” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","To this they replied, “Who are you to teach us? You were born entirely in sin!” Then they threw him out. ");
INSERT INTO eng_glw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesus heard that they had thrown him out, and finding him, He said, “Do you believe in the Son of Man?” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","He answered, “Who is He, sir, that I may believe in Him?” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesus told him, “You have seen Him, and it is He who is talking with you.” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Then he said, “Lord, I believe!” and he worshipped Jesus. ");
INSERT INTO eng_glw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesus said, “I came into this world for judgment, so that those who don’t see may see, and those who do see may become blind.” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Some of the Pharisees who were with Him heard these things, and asked Him, “We aren’t blind too, are we?” ");
INSERT INTO eng_glw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus told them, “If you were blind, you would have no sin, but since you say, ‘We see,’ your sin remains. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Most assuredly, I tell you, whoever doesn’t enter the sheepfold by the door, but climbs in some other way, is a thief and a robber. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","The one who enters by the gate is the sheep’s shepherd. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","The gatekeeper opens the gate for him, and the sheep hear his voice. He calls his own sheep by name and leads them out. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","When he brings out his own sheep, he goes before them, and the sheep follow him, because they know his voice. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","There is no way that they will follow a stranger, but will run away from the stranger, because they don’t know the voice of strangers.” ");
INSERT INTO eng_glw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesus used this illustration, but the Pharisees didn’t understand what He was telling them. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Then Jesus told them again, “Most assuredly, I tell you, I am the sheep’s door. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","All who ever came before me are thieves and robbers, but the sheep didn’t listen to them. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","I am the door. Anyone who enters by me will be saved, and will go in and out and find pasture. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","The thief comes only to steal, and kill, and destroy. I came that they might have life, and that they might have it in all its fullness. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","I am the good shepherd. The good shepherd lays down His life for the sheep. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","The hired hand, who isn’t the shepherd and doesn’t own the sheep, sees the wolf coming and leaves the sheep and runs away. So, the wolf snatches them and scatters them. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","The hired hand is concerned about the wages, and not the sheep, so the hired hand runs away. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","I am the good shepherd. I know my own and my own know me, ");
INSERT INTO eng_glw_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","just as the Father knows me and I know the Father. I lay down my life for the sheep. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","I have other sheep that don’t belong to this fold. I must bring them also, and they will listen to my voice. So, there will be one flock, with one shepherd. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","For this reason the Father sincerely loves me, because I lay down my life, so that I may take it up again. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","No one takes it away from me, but I lay it down of my own free will. I have the authority to lay it down, and I have the authority to take it up again. I received this commandment from my Father.” ");
INSERT INTO eng_glw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","The Jews were divided again, because of these words. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Many of them were saying, “He has a demon and is insane. Why do you listen to Him?” ");
INSERT INTO eng_glw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Others were saying, “These aren’t the sayings of a demon-possessed person. Can a demon open the eyes of the blind?” ");
INSERT INTO eng_glw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","At that time the Feast of Dedication took place in Jerusalem. It was winter, ");
INSERT INTO eng_glw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","and Jesus was walking in the temple, in Solomon’s porch. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Then the Jews gathered around Him, and asked Him, “How long will You keep us in suspense? If You are the Christ, tell us plainly.” ");
INSERT INTO eng_glw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus answered, “I told you, but you don’t believe. The works that I do in my Father’s name testify about me, ");
INSERT INTO eng_glw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","but you don’t believe, because you aren’t of my sheep. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","My sheep listen to my voice. I know them, and they follow me. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","I give them eternal life, and they will never perish. No one is able to snatch them out of my hand. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","My Father, who has given them to me, is greater than all; and no one is able to snatch them out of my Father’s hand. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","I and my Father are one.” ");
INSERT INTO eng_glw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Therefore the Jews took up stones again to stone Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesus answered, “I showed you many good works from the Father. For which of them are you stoning me?” ");
INSERT INTO eng_glw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","The Jews answered Him, “We aren’t stoning you for a good work, but for blasphemy, because You, being a man, claim to be God.” ");
INSERT INTO eng_glw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus answered, “Isn’t it written in your Law, ‘I said, “You are gods”’? ");
INSERT INTO eng_glw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","If he, who God’s word came to, called them gods, (and the Scripture can’t be broken), ");
INSERT INTO eng_glw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","do you say of Him who the Father set apart and sent into the world, ‘You are blaspheming,’ because I said, ‘I am God’s Son’? ");
INSERT INTO eng_glw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","If I don’t do my Father’s works, then don’t believe me. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","But if I do them, even if you don’t believe me, believe the works, so that you may know and understand that the Father is in me, and I am in the Father.” ");
INSERT INTO eng_glw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Therefore they were trying again to seize Him, and He escaped from their grasp. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesus went away again across the Jordan to the place where John was first baptizing, and He was staying there. ");
INSERT INTO eng_glw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Many came to Him and were saying, “John performed no miraculous sign, but everything that John said about this man was true.” ");
INSERT INTO eng_glw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Many believed in Jesus there. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Now a certain man was sick, Lazarus from Bethany, the village of Mary and her sister Martha. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","It was the Mary who anointed the Lord with ointment, and wiped His feet with her hair, whose brother Lazarus was sick. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","These sisters therefore sent to Him, saying, “Lord, one You love is sick!” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","When Jesus heard this, He said, “This sickness won’t end in death, but for God’s glory, so that God’s Son may be glorified by it.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Now Jesus sincerely loved Martha, and her sister, and Lazarus. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yet, when He heard that Lazarus was sick, Jesus stayed where He was for two more days. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","After this, He said to the disciples, “Let’s go back to Judea.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","The disciples said to Him, “Rabbi, the Jews were just recently trying to stone You! Are You really going back there?” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus answered, “Aren’t there twelve hours of daylight? Anyone who walks by day doesn’t stumble, because he sees the light of this world. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","But anyone who walks by night stumbles, because the light isn’t in him.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","After He had said this, He told them, “Our friend Lazarus has fallen asleep, but I am going there to wake him up.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","The disciples therefore said to Him, “Lord, if he is sleeping, he will recover.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Now Jesus had spoken of his death, but they thought that He was talking about literal sleep. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","So Jesus told them plainly, “Lazarus is dead, ");
INSERT INTO eng_glw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","and I am glad for your sakes that I wasn’t there, so that you may believe — but let’s go to him.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Therefore Thomas, who is called the Twin, said to his fellow disciples, “Let’s go, too, that we may die with Him.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","When Jesus arrived, he found that Lazarus had already been in the tomb four days. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethany was near Jerusalem, about fifteen stadia away, ");
INSERT INTO eng_glw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","and many of the Jews had come to Martha and Mary, to comfort them concerning their brother. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","When Martha heard that Jesus was coming, she went out to meet him, but Mary stayed home. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Then Martha said to Jesus, “Lord, if You had been here, my brother wouldn’t have died. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Even now I know that God will give you whatever You ask of Him.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus told her, “Your brother will rise again.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha replied, “I know that he will rise again in the resurrection on the last day.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus told her, “I am the resurrection and the life. Whoever believes in me will live even if they die, ");
INSERT INTO eng_glw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","and everyone who lives and believes in me will never die. Do you believe this?” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Yes, Lord,” she answered, “I have believed that You are the Christ, God’s Son, who was to come into the world.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","When she had said this, she went back and called Mary, her sister, saying secretly, “The Teacher is here, and is asking for you.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","When she heard this, she arose quickly, and went to Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesus had not yet entered the village, but was still at the place where Martha met Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","The Jews who were with her in the house, consoling her, saw Mary get up quickly and go out. They followed her, saying, “She is going to the tomb to weep there.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","When Mary came to where Jesus was, she saw Him, and fell at His feet, saying to Him, “Lord, if You had been here, my brother wouldn’t have died.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","When Jesus saw her weeping, and the Jews who came with her weeping, He groaned in the spirit and was troubled. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","He asked, “Where have you laid him?” They replied, “Lord, come and see.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus wept. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","So the Jews were saying, “See how He loved him!” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","But some of them said, “Couldn’t this man, who opened the eyes of the blind man, have kept this man from dying?” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Then Jesus, again groaning in Himself, came to the tomb. It was a cave, and a boulder was placed against the entrance. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus said, “Take away the boulder.” Martha, the dead man’s sister, said to Him, “Lord, by this time there is a stench, because he has been dead four days.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesus told her, “Didn’t I tell you that if you would believe you would see God’s glory?” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Then they took the boulder away from the place where the dead man was lying. Jesus lifted up His eyes and said, “Father, I thank You that You have heard me. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","I know that You always hear me, but because of the people who are standing here I said this, that they may believe that You sent me.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Now when He had said these things, He called loudly, “Lazarus, come out!” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","He who had died came out, bound hand and foot with wrappings, and his face was wrapped around with a cloth. Jesus told them, “Unbind him, and let him go.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Then many of the Jews who had come to Mary, and had seen the things Jesus did, believed in Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","But some of them went away to the Pharisees and told them what Jesus did. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Then the chief priests and the Pharisees gathered a council and said, “What are we doing? For this Man performs many signs. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","If we let Him go on like this, everyone will believe in Him, and the Romans will come and take away both our place and our nation.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Then a certain one of them, Caiaphas, who was high priest that year, told them, “You don’t know anything, ");
INSERT INTO eng_glw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","nor do you take into account that it’s better for you that one man should die for the people, than for the whole nation to perish.” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","He didn’t say this on his own initiative; but being high priest that year, he prophesied that Jesus was going to die for the nation, ");
INSERT INTO eng_glw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","and not for the nation only, but that Jesus might also gather together into one God’s children who are scattered abroad. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","So from that day on, they planned together to kill Jesus. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Therefore Jesus stopped walking publicly among the Jews, but went away from there to the region near the wilderness, into a city called Ephraim, and there He stayed with the disciples. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Now the Passover of the Jews was near, and many went from the country up to Jerusalem before the Passover, to purify themselves. ");
INSERT INTO eng_glw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Then they were looking for Jesus, and spoke among themselves as they stood in the temple, “What do you think? Isn’t He coming to the feast at all?” ");
INSERT INTO eng_glw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Now the chief priests and the Pharisees had given a command, that anyone who knew where Jesus was should report it, that they might arrest Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Six days before the Passover, Jesus came to Bethany, where Lazarus was who had been dead, who He had raised from the dead. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","There they made Him a supper, and Martha served, but Lazarus was one of those reclining at the table with Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Then Mary took a pound of very costly perfume of pure nard, and anointed the feet of Jesus, and wiped His feet with her hair. The house was filled with the fragrance of the perfume. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Then one of Jesus’ disciples, Judas Iscariot, Simon’s son, who was about to betray Him, said, ");
INSERT INTO eng_glw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Why wasn’t this fragrant oil sold for three hundred denarii and given to the poor?” ");
INSERT INTO eng_glw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Now he said this, not because he was concerned about the poor, but because he was a thief, and since he had the money box, he used to steal from what was put into it. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesus therefore said, “Leave her alone. She has kept this for the day of my burial. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","You will always have the poor among you, but you won’t always have me.” ");
INSERT INTO eng_glw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Then a great multitude of the Jews learned that He was there; and they came, not just for Jesus’ sake, but also so that they could see Lazarus, who He had raised from the dead. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","So the chief priests plotted to kill Lazarus too, ");
INSERT INTO eng_glw_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","because on account of him many of the Jews were going away, and were believing in Jesus. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","The next day, when a great multitude that had come to the feast heard that Jesus was coming to Jerusalem, ");
INSERT INTO eng_glw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","they took branches of palm trees and went out to meet Him, and shouted: “Hosanna! ‘Blessed is He who comes in the name of the LORD!’ The King of Israel!” ");
INSERT INTO eng_glw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Then Jesus, finding a young donkey, sat on it, as it is written: ");
INSERT INTO eng_glw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Don’t be afraid, Daughter of Zion; look, your king is coming, sitting on a donkey’s colt.” ");
INSERT INTO eng_glw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","His disciples didn’t understand these things at first, but when Jesus was glorified, then they remembered that these things were written about Him and that they had done these things to Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","So the crowd that had been with Him when He called Lazarus out of the tomb and raised him from the dead continued to testify. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","The crowd also met Him because they heard that He had done this sign. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Then the Pharisees said among themselves, “You see that you are accomplishing nothing. Look, the whole world has gone after Him!” ");
INSERT INTO eng_glw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Now there were certain Greeks among those who came up to worship at the feast. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Then they came to Philip, who was from Bethsaida of Galilee, and told him, “Sir, we would like to see Jesus.” ");
INSERT INTO eng_glw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip came and told Andrew, then Andrew and Philip came and told Jesus. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesus answered them, saying, “The time has come for the Son of Man to be glorified. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Most assuredly, I tell you, unless a grain of wheat falls into the ground and dies, it remains alone, but if it dies, it produces many grains. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Anyone who loves their life will lose it, and anyone who hates their life in this world will keep it for eternal life. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","If anyone serves me, let them follow me; and where I am, there my servant will be also. If anyone serves me, my Father will honor them. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Now my soul has become troubled; and what will I say? ‘Father, save me from this time’? No, for this purpose I came to this time. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Father, glorify Your name.” Then a voice came from Heaven, saying, “I have both glorified it and will glorify it again.” ");
INSERT INTO eng_glw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Therefore the people who stood by and heard it said that it had thundered. Others said, “An angel has spoken to Him.” ");
INSERT INTO eng_glw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesus answered, “This voice hasn’t come for my sake, but for your sakes. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Now judgment is upon this world. Now the ruler of this world will be cast out. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","And I, if I am lifted up from the Earth, will draw everyone to myself.” ");
INSERT INTO eng_glw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","He was saying this to indicate the kind of death He was about to die. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Therefore the crowd answered Him, “We have heard from the Law that the Christ is to remain forever, so how can You say, ‘The Son of Man must be lifted up’? Who is this Son of Man?” ");
INSERT INTO eng_glw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesus told them, “The light is with you for a little longer. Walk while you have the light, so that the darkness may not overtake you. If you walk in the darkness, you don’t know where you are going. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Believe in the light while you have the light, so that you may become children of light.” After Jesus had said this, he departed and hid from them. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Although He had performed so many signs in front of them, they still didn’t believe in Him, ");
INSERT INTO eng_glw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","so that the word of Isaiah the prophet might be fulfilled, which he spoke: “Lord, who has believed our report? And who has the arm of the LORD been revealed to?” ");
INSERT INTO eng_glw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Therefore they couldn’t believe, because Isaiah said again: ");
INSERT INTO eng_glw_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“He has blinded their eyes and hardened their hearts, lest they see with their eyes, and understand with their hearts and turn — and I would heal them.” ");
INSERT INTO eng_glw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah said this because he saw Jesus’ glory and spoke about Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nevertheless, even many of the rulers believed in Him, but because of the Pharisees they weren’t confessing Him, for fear that they might be put out of the synagogue; ");
INSERT INTO eng_glw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","because they sincerely loved men’s approval more than God’s approval. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesus cried out and said, “Whoever believes in me doesn’t just believe in me, but in Him who sent me. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Whoever sees me sees Him who sent me. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","I have come into the world as light, that everyone who believes in me should not stay in darkness. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","If anyone hears the words I speak, and doesn’t keep them, I don’t judge them; because I didn’t come to judge the world, but to save the world. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Whoever rejects me, and doesn’t receive my sayings, has one who judges them. The words that I spoke are what will judge him at the last day. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","For I haven’t spoken on my own initiative, but the Father Himself who sent me has given me commandment, what to say, and what to speak. ");
INSERT INTO eng_glw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","I know that His commandment is eternal life, so the things I speak, I speak just as the Father has told me.” ");
INSERT INTO eng_glw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Before the Feast of the Passover, Jesus knew that His time had come that He should depart out of this world to the Father. Having sincerely loved His own who were in the world, He sincerely loved them to the end. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Supper was finished, and the Devil had already put it into the heart of Judas Iscariot, Simon’s son, to betray Jesus. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus, knowing that the Father had given everything into His hands, and that He had come from God and was going to God, ");
INSERT INTO eng_glw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","got up from supper, laid aside His outer garment, and wrapped a towel around His waist. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Then He poured water into a basin and began to wash the disciples’ feet, and to wipe them with the towel that was wrapped around Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Then He came to Simon Peter, and Peter asked Him, “Lord, are You washing my feet?” ");
INSERT INTO eng_glw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus answered, “You don’t understand what I am doing now, but you will know after this.” ");
INSERT INTO eng_glw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peter told Him, “You will never wash my feet!” Jesus answered, “If I don’t wash you, you have no part with me.” ");
INSERT INTO eng_glw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Peter said to Him, “Lord, not just my feet, but also my hands and my head!” ");
INSERT INTO eng_glw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus said to him, “Someone who has bathed only needs to wash their feet, but is completely clean; and most of you are clean, but not all of you.” ");
INSERT INTO eng_glw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","For He knew who would betray Him, therefore He said, “You aren’t all clean.” ");
INSERT INTO eng_glw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","When He had washed their feet, He put on His outer garment and sat down again. He asked them, “Do you know what I have done to you? ");
INSERT INTO eng_glw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","You call me Teacher and Lord, and you are right in saying so, for so I am. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","If I, your Lord and Teacher, have washed your feet, you also ought to wash one another’s feet. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","I have given you an example, that you should also do as I have done to you. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Most assuredly, I tell you, a servant isn’t greater than his master, nor is he who is sent greater than he who sent him. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","If you know these things, you are blessed if you do them. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","I’m not talking about all of you. I know who I have chosen; but this is to fulfill the Scripture, ‘He who eats bread with me has lifted up his heel against me.’ ");
INSERT INTO eng_glw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Now I tell you before it happens, that when it does happen, you may believe that I AM. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Most assuredly, I tell you, whoever receives anyone I send receives me; and he who receives me receives Him who sent me.” ");
INSERT INTO eng_glw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","When Jesus had said these things, He was troubled in spirit, and testified and said, “Most assuredly, I tell you, one of you will betray me.” ");
INSERT INTO eng_glw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","The disciples began looking at one another, perplexed about which one of them He was talking about. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","One of Jesus’ disciples, who Jesus sincerely loved, was leaning against His breast. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Peter therefore nodded to him to ask who He spoke about. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Then, leaning back on Jesus’ breast, he asked Him, “Lord, who is it?” ");
INSERT INTO eng_glw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus answered, “It is he who I will give a morsel to when I have dipped it.” Having dipped the morsel, He gave it to Judas Iscariot, Simon’s son. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","After the morsel, Satan entered into him. Jesus therefore told him, “What you do, do quickly.” ");
INSERT INTO eng_glw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","None of those reclining at the table knew why He had said this to him. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Some were supposing, because Judas had the money box, that Jesus was saying to him, “Buy the things we need for the feast”; or else, that he should give something to the poor. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Having received the morsel, he went out immediately. It was night. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","When he had gone out, Jesus said, “Now the Son of Man is glorified, and God is glorified in Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","If God is glorified in Him, God will also glorify Him in Himself, and will glorify Him immediately. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Little children, I am with you a little while longer. You will look for me, and as I told the Jews, I now tell you, also, ‘Where I am going, you can’t come.’ ");
INSERT INTO eng_glw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","I give to you a new commandment, that you sincerely love one another, even as I have sincerely loved you, so you should also sincerely love one another. ");
INSERT INTO eng_glw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","By this everyone will know that you are my disciples, if you have sincere love for one another.” ");
INSERT INTO eng_glw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter asked Him, “Lord, where are You going?” Jesus answered, “Where I go, you aren’t able to follow me now, but you will follow later.” ");
INSERT INTO eng_glw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peter asked Him, “Lord, why can’t I follow You right now? I will lay down my life for You.” ");
INSERT INTO eng_glw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus answered, “Will you lay down your life for my sake? Most assuredly, I tell you, the rooster won’t crow until you have denied me three times. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Don’t let your heart be troubled. You believe in God, believe also in me. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","In my Father’s house are many mansions. If it weren’t so, I would have told you. I go to prepare a place for you, ");
INSERT INTO eng_glw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","and if I go and prepare a place for you, I will come again and receive you to myself; that where I am, there you may also be. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","You know where I go, and you know the way.” ");
INSERT INTO eng_glw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas asked Him, “Lord, we don’t know where You are going, so how can we know the way?” ");
INSERT INTO eng_glw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus told him, “I am the way, the truth, and the life. No one comes to the Father except through me. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","If you had known me, you would have known my Father too. From now on you know Him and have seen Him.” ");
INSERT INTO eng_glw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip said to Him, “Lord, show us the Father, and that would be enough for us.” ");
INSERT INTO eng_glw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus answered, “Have I been with you so long, and yet you haven’t known me, Philip? Whoever has seen me has seen the Father, so how can you say, ‘Show us the Father’? ");
INSERT INTO eng_glw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Don’t you believe that I am in the Father, and the Father in me? The words that I speak to you aren’t my own, but from the Father who lives in me. He does the works. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Believe me when I say that I am in the Father and the Father in me, or else believe me for the sake of the works themselves. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Most assuredly, I tell you, whoever believes in me will also do the works that I do, and even greater works than these, because I am going to my Father. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","I will do whatever you ask in my name, that the Father may be glorified in the Son. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","If you ask anything in my name, I will do it. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","If you sincerely love me, you will keep my commandments. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","I will then ask the Father, and He will give you another Counselor, that He may be with you forever — ");
INSERT INTO eng_glw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","the Spirit of truth, whom the world can’t receive, because it neither sees Him nor knows Him. You know Him, though, because He lives with you and will be in you. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","I won’t leave you orphans. I will come to you. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","After a little while the world won’t see me, but you will see me. Because I live, you will also live. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","In that day you will know that I am in my Father, and you in me, and I in you. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Whoever has my commandments and keeps them, sincerely loves me. Whoever sincerely loves me will be sincerely loved by my Father, and I’ll sincerely love them and reveal myself to them.” ");
INSERT INTO eng_glw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas (not Iscariot) asked Him, “Lord, how is it that You will reveal Yourself to us, and not to the world?” ");
INSERT INTO eng_glw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus answered him, “If anyone sincerely loves me, that person will keep my words; and my Father will sincerely love that person, and we will come and make our home with that person. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Whoever doesn’t sincerely love me doesn’t keep my words. The word which you hear isn’t mine, but the Father’s who sent me. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“I’ve told you these things while living with you, ");
INSERT INTO eng_glw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","but the Counselor, the Holy Spirit, who the Father will send in my name, will teach you everything, and bring to your remembrance all that I told you. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","I leave peace with you. I give you my peace. I don’t give to you as the world gives. Don’t let your heart be troubled, neither let it be afraid. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","You have heard me tell you, ‘I am going away and coming back to you.’ If you sincerely loved me, you would rejoice because I said, ‘I am going to the Father,’ for my Father is greater than I. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Now I have told you before it happens, that when it does happen, you may believe. ");
INSERT INTO eng_glw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","I won’t talk much longer with you, for the ruler of this world is coming. He has no power over me, ");
INSERT INTO eng_glw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","but the world must learn that I sincerely love the Father and that I do exactly what my Father has commanded me. “Come on. Let’s go. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“I am the true vine, and my Father is the gardener. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","He takes away every branch in me that doesn’t bear fruit, and He prunes every branch that bears fruit, so that it may bear more fruit. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","You are already pruned clean because of the words which I have spoken to you. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Live in me, as I live in you. As the branch can’t bear fruit of itself, unless it lives in the vine, so neither can you, unless you live in me. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","I am the vine, and you are the branches. Whoever lives in me, and I in them, bears much fruit; for apart from me you can do nothing. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Anyone who doesn’t live in me is thrown away as a branch, and dries up. The dried up branches are gathered up, thrown into the fire, and burned. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","If you live in me, and my words live in you, ask whatever you want, and it will be done for you. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","My Father is glorified by this, that you bear much fruit, so you will prove to be my disciples. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Just as the Father has sincerely loved me, I have also sincerely loved you. Continue to live in my sincere love. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","If you keep my commandments, you will continue to live in my sincere love; just as I have kept my Father’s commandments, and continue to live in His sincere love. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","I have told you these things, that my joy may be in you, and that your joy may be made full. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","This is my commandment, that you sincerely love one another, just as I have sincerely loved you. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","No one has greater sincere love than this, than to lay down one’s life for one’s friends. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","You are my friends if you do whatever I command you. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","I don’t call you servants any longer, because a servant doesn’t know what the master is doing; but I have called you friends, because I have made known to you everything that I have heard from my Father. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","You didn’t choose me, but I chose you and appointed you, so that you should go and bear fruit, and so that your fruit should remain, that whatever you ask the Father in my name He may give you. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","I command you this, that you sincerely love one another. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“If the world hates you, know that it hated me before it hated you. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","If you belonged to the world, the world would love its own. Because you aren’t the world’s, but I chose you out of the world, therefore the world hates you. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Remember that I told you, ‘A servant isn’t greater than his master.’ If they persecuted me, they will also persecute you. If they obeyed my teaching, they will also obey yours. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","The world will do all these things to you, however, for My name’s sake, because they don’t know Him who sent me. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","If I hadn’t come and spoken to them, they would have no sin, but now they have no excuse for their sin. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Whoever hates me also hates my Father. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","If I hadn’t done the works which no one else did among them, they would have no sin; but now they have seen and also hated both me and my Father. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","This was to fulfill the word that is written in their Law, ‘They hated me without a cause.’ ");
INSERT INTO eng_glw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","When the Counselor comes, who I will send to you from the Father, the Spirit of Truth who proceeds from the Father, He will testify of me. ");
INSERT INTO eng_glw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","You will also testify, because you have been with me from the beginning. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“I have told you these things so that you may be kept from stumbling. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","They will put you out of the synagogues. Indeed, the time is coming that whoever kills you will think that they are serving God. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","They will do these things to you because they haven’t known the Father nor me. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","I have told you these things, so that when the time comes, you may remember that I told you about them. I didn’t tell you these things at the beginning, because I was with you. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Now I am going to Him who sent me, yet none of you asks me, ‘Where are you going?’ ");
INSERT INTO eng_glw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Instead, because I have told you these things, sorrow has filled your heart. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nevertheless, I tell you the truth: it’s to your advantage that I go away; because if I don’t go away, the Counselor won’t come to you; but if I go, I will send Him to you. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","When He has come, He will convict the world of sin, and of righteousness, and of judgment: ");
INSERT INTO eng_glw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","of sin, because they don’t believe in me; ");
INSERT INTO eng_glw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","of righteousness, because I go to my Father and you see me no more; ");
INSERT INTO eng_glw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","and of judgment, because the ruler of this world is judged. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“I still have many things to tell you, but you can’t bear them now. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","However, when the Spirit of truth has come, He will guide you into all truth. He won’t speak on His own, but whatever He hears He will speak. He will announce things to come. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","He will glorify me, because He will take from what is mine and reveal it to you. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Everything that the Father has is mine. That is why I said that He will take from what is mine and reveal it to you. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“In a little while, you won’t see me; and in a little while longer, you will see me again, because I go to the Father.” ");
INSERT INTO eng_glw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Then some of Jesus’ disciples said among themselves, “What does He mean by, ‘In a little while, and you won’t see me; and in a little while longer, you will see me, again;’ and, ‘because I go to the Father’?” ");
INSERT INTO eng_glw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","They kept asking, “What does He mean by ‘a little while’? We don’t understand what He is saying.” ");
INSERT INTO eng_glw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Now Jesus knew that they wanted to ask Him, and He said to them, “Are you asking yourselves about what I said, ‘In a little while, and you won’t see me; and in a little while longer, you will see me, again’? ");
INSERT INTO eng_glw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Most assuredly, I tell you that you will weep and mourn, but the world will rejoice. You will be sad, but your sadness will be turned into joy. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","A woman in labor is in pain because her time has come; but as soon as she has given birth to the baby, she forgets the agony, for joy that a child has been born into the world. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Therefore you have sorrow now, too, but I will see you again, and your heart will rejoice, and nobody will take your joy away from you. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“In that day you will ask me nothing. Most assuredly, I tell you, whatever you ask the Father in My name He will give you. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Until now you have asked nothing in my name. Ask, and you will receive, that your joy may be full. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“I’ve told you these things in figures of speech, but the time is coming when I will no longer speak to you in figures of speech, but I will tell you plainly about the Father. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","In that day you will ask in my name. I don’t tell you that I’ll ask the Father for you, ");
INSERT INTO eng_glw_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","because the Father Himself loves you, because you have loved me, and have believed that I came forth from God. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","I came forth from the Father and have come into the world. Again, I am leaving the world and going to the Father.” ");
INSERT INTO eng_glw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","His disciples said to Him, “See, now You are speaking plainly, and not in figures of speech! ");
INSERT INTO eng_glw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Now we are sure that You know everything, and don’t need anyone to question You. By this we believe that You came forth from God.” ");
INSERT INTO eng_glw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus answered them, “Do you now believe? ");
INSERT INTO eng_glw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","The time is coming, and indeed, has now come, that you will be scattered, each to his own home, and you will leave me all alone. Yet I am not alone, because the Father is with me. ");
INSERT INTO eng_glw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","I have told you these things so that you may have peace in me. You will have trouble in the world, but cheer up! I have overcome the world.” ");
INSERT INTO eng_glw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","After Jesus said these things, He looked toward Heaven, and said: “Father, the time has come. Glorify Your Son, so that Your Son may also glorify You, ");
INSERT INTO eng_glw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","as You have given Him authority over all flesh, that He should give eternal life to as many as You have given Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","This is eternal life, that they may know You, the only true God, and Jesus Christ who You have sent. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","I have glorified You on the Earth. I have finished the work which You have given me to do. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Now, O Father, glorify me together with Yourself, with the glory which I had with You before the world existed. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“I have revealed Your name to the people You’ve given me out of the world. They were Yours. You gave them to me, and they have kept Your word. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Now they know that everything You’ve given me comes from You, ");
INSERT INTO eng_glw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","for I have spoken to them the words You’ve given me. They have received Your words, and have come to know for certain that I came forth from You. They have believed that You sent me. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","It is for them I pray. I’m not praying for the world, but for those who You’ve given me, because they belong to You. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","All of mine are Yours, and Yours are mine. I am glorified in them. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Now I am no longer in the world, but these are in the world. I am coming to You. Holy Father, keep through Your name those who You’ve given me, that they may be one just as we are one. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","I kept them in Your name while I was with them in the world. I have kept the people You gave me; and none of them is lost except the son of perdition, so that the Scripture might be fulfilled. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Now I am coming to You, and I speak these things in the world, so that they may have my joy fulfilled in themselves. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","I have given them Your word. The world has hated them because they don’t belong to the world, just as I don’t belong to the world. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","I don’t pray that You should take them out of the world, but that You should keep them from the evil one. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","They don’t belong to the world, just as I don’t belong to the world. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Sanctify them by Your truth. Your word is truth. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","As You sent me into the world, I have sent them into the world. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","I sanctify myself for their sakes, so that they may also be sanctified by the truth. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“I don’t pray for these alone, but also for those who will believe in me through their message, ");
INSERT INTO eng_glw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","that they all may be one, as You, Father, are in me, and I in You. I pray that they also may be one in Us, so that the world may believe that You sent me. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","I have given them the glory which You gave me, that they may be one just as we are one: ");
INSERT INTO eng_glw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","I in them and You in me. May they be brought to complete unity to let the world know that You sent me and have sincerely loved them even as You have sincerely loved me. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Father, I desire that those You gave me may also be with me where I am, that they may see my glory which You’ve given me; because You sincerely loved me before the foundation of the world. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O righteous Father! The world hasn’t known You, but I have always known You, and these have come to know that You sent me. ");
INSERT INTO eng_glw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","I have declared to them Your name, and will continue to declare it, so that the sincere love with which You sincerely loved me may be in them, and I may be in them.” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","When Jesus had said these things, He went with His disciples across the Kidron ravine, where there was a garden, into which He and His disciples entered. ");
INSERT INTO eng_glw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Now Judas, who was betraying Him, also knew the place, because Jesus had often met there with His disciples. ");
INSERT INTO eng_glw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Then Judas, leading a detachment of soldiers and officers from the chief priests and Pharisees, came there with lanterns, torches, and weapons. ");
INSERT INTO eng_glw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Therefore Jesus, knowing everything that would happen to Him, went forward and asked them, “Who are you looking for?” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","They answered, “Jesus of Nazareth.” Jesus told them, “I AM.” Judas, who betrayed Him, also stood with them. ");
INSERT INTO eng_glw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Now when He told them, “I AM,” they drew back and fell to the ground. ");
INSERT INTO eng_glw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Then He asked them again, “Who are you looking for?” They said, “Jesus of Nazareth.” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus answered, “I told you that I AM. So, if you are looking for me, let these go their way,” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","that the saying might be fulfilled which He spoke, “I have lost none of those who You gave me.” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Then Simon Peter, having a sword, drew it and struck the high priest’s servant, and cut off his right ear. The servant’s name was Malchus. ");
INSERT INTO eng_glw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","So Jesus told Peter, “Put your sword into its sheath! Shouldn’t I drink the cup that my Father has given me?” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Then the detachment of soldiers and their commander and the officers of the Jews arrested Jesus and tied Him up. ");
INSERT INTO eng_glw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","They led Him away to Annas first, because he was the father-in-law of Caiaphas, who was high priest that year. ");
INSERT INTO eng_glw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","It was Caiaphas who advised the Jews that it was expedient that one man should die for the people. ");
INSERT INTO eng_glw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Peter was following Jesus, and so was another disciple. Since the high priest knew that disciple, he entered with Jesus into the high priest’s court, ");
INSERT INTO eng_glw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","but Peter was standing just outside the door. So the other disciple, who the high priest knew, went out and spoke to the woman who guarded the door, and brought Peter in. ");
INSERT INTO eng_glw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Then the maidservant who kept the door asked Peter, “You aren’t one of this man’s disciples, too, are you?” He said, “I am not.” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Because it was cold, the servants and the officers were standing there warming themselves, having made a charcoal fire. Peter was also with them, standing and warming himself. ");
INSERT INTO eng_glw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Then the high priest asked Jesus about His disciples and His doctrine. ");
INSERT INTO eng_glw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus answered him, “I have spoken openly to the world. I always taught in synagogues, and in the temple, where all the Jews come together. I said nothing in secret. ");
INSERT INTO eng_glw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Why do you ask me? Ask those who have heard me to tell you what I told them. They certainly know what I said.” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","When He had said these things, one of the officers who stood by hit Jesus with the palm of his hand, saying, “Is that how you answer the high priest?” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus answered him, “If I have spoken evil, testify about the evil, but if I have spoken honestly, why do you hit me?” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Then Annas sent Him, still bound, to Caiaphas, the high priest. ");
INSERT INTO eng_glw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Now Simon Peter stood and warmed himself. Therefore they asked him, “You aren’t one of His disciples, too, are you?” He denied it, saying, “I am not!” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","One of the servants of the high priest, a relative of the man whose ear Peter cut off, said, “Didn’t I see you in the garden with Him?” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peter then denied it again, and immediately a rooster crowed. ");
INSERT INTO eng_glw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Then they led Jesus from Caiaphas to the Praetorium. It was early morning. They themselves didn’t go into the Praetorium, so that they wouldn’t be defiled, and so that they might eat the Passover supper. ");
INSERT INTO eng_glw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","So Pilate came out to them and asked, “What charges do you bring against this man?” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","They answered, “If this man wasn’t a criminal, we wouldn’t have handed him over to you.” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Then Pilate told them, “You take Him and judge Him according to your Law.” Therefore the Jews said to him, “It’s illegal for us to put anyone to death.” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","This happened so that the words would be fulfilled which Jesus had spoken indicating the kind of death he was going to die. ");
INSERT INTO eng_glw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Then Pilate went back into the Praetorium, summoned Jesus, and asked Him, “Are You the King of the Jews?” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus answered, “Are you speaking for yourself about this, or did others tell you this about me?” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilate answered, “I’m not a Jew, am I? Your own nation and the chief priests have delivered You to me. What have You done?” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus answered, “My kingdom doesn’t belong to this world. If my kingdom did belong to this world, then my servants would be fighting to keep me from being delivered up to the Jews; but as it is, my kingdom isn’t from here.” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilate therefore asked Him, “So You are a king?” Jesus answered, “You are right in saying that I am a king. For this I have been born, and for this I have come into the world, to testify about the truth. Everyone who belongs to the truth listens to my voice.” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","“What is truth?” Pilate asked. After asking this, he went out again to the Jews and said, “I find no basis for a charge against Him, ");
INSERT INTO eng_glw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","but you have a custom that I should release someone to you at the Passover. Therefore you decide: do you want me to release the King of the Jews to you?” ");
INSERT INTO eng_glw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Then they all shouted back, saying, “Not this man, but Barabbas!” Now Barabbas was a robber. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Then Pilate took Jesus and had him flogged. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","The soldiers twisted thorns into a crown and put it on His head, and they put a purple robe on Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","They kept coming up to Him, saying, “Hail, King of the Jews!” and slapping Him on the face. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilate then went out again, and told the Jews, “Look, I’m bringing Him out to you, that you may know that I find no basis for a charge against Him.” ");
INSERT INTO eng_glw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Then Jesus came out, wearing the crown of thorns and the purple robe, and Pilate said to them, “Look! Here is the man!” ");
INSERT INTO eng_glw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","When the chief priests and officers saw Him, they shouted “Crucify Him! Crucify Him!” Pilate told them, “You take Him and crucify Him, because I find no basis for a charge against Him.” ");
INSERT INTO eng_glw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","The Jews answered him, “We have a law, and according to our law He ought to die, because He claimed to be God’s Son.” ");
INSERT INTO eng_glw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","When Pilate heard this, he was even more afraid, ");
INSERT INTO eng_glw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","and went back into the Praetorium, and asked Jesus, “Where are You from?” But Jesus didn’t answer him. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilate therefore asked him, “Do you refuse to speak to me? Don’t you know that I have authority to release you, and authority to crucify you?” ");
INSERT INTO eng_glw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus answered, “You would have no authority at all against me unless it had been given you from above. Therefore the one who delivered me to you has the greater sin.” ");
INSERT INTO eng_glw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","From then on, Pilate tried to release Him, but the Jews shouted, “If you let this man go, you aren’t Caesar’s friend. Whoever makes himself a king speaks against Caesar.” ");
INSERT INTO eng_glw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Therefore when Pilate heard these words, he brought Jesus out, and sat down on the judgment seat at a place called “The Pavement,” but in Hebrew, “Gabbatha.” ");
INSERT INTO eng_glw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Now it was the day of preparation for the Passover. It was about the sixth hour. Pilate told the Jews, “Look! Here is your King!” ");
INSERT INTO eng_glw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","They therefore shouted, “Away with Him! Away with Him! Crucify Him!” Pilate asked them, “Shall I crucify your King?” The chief priests answered, “We have no king but Caesar!” ");
INSERT INTO eng_glw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Then Pilate delivered Jesus to them to be crucified. So they took Jesus and led Him away. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","And He, bearing His cross, went out to a place called the Place of a Skull, which is called in Hebrew, Golgotha. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","There they crucified Him, and two others with Him, one on either side, with Jesus in the center. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Now Pilate wrote a notice, and put it on the cross. The notice said: “JESUS OF NAZARETH, THE KING OF THE JEWS.” ");
INSERT INTO eng_glw_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Then many of the Jews read this notice, because the place where Jesus was crucified was near the city, and it was written in Hebrew, Greek, and Latin. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Therefore the chief priests of the Jews told Pilate, “Don’t write, ‘The King of the Jews,’ but, ‘He said, “I am the King of the Jews.”’” ");
INSERT INTO eng_glw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilate answered, “What I have written, I have written.” ");
INSERT INTO eng_glw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","When the soldiers had crucified Jesus, they split His garments into four parts, to each soldier a part, including the tunic. Now the tunic was without seam, woven from the top in one piece. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Therefore they said to one another, “Let’s not tear it, but cast lots to see whose it will be,” that the Scripture might be fulfilled which says: “They divided my garments among them, And for my clothing they cast lots.” So the soldiers did these things. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Now Jesus’ mother, His mother’s sister, Mary the wife of Clopas, and Mary Magdalene stood by Jesus’ cross. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Therefore when Jesus saw His mother, and the disciple who He sincerely loved standing by, He told His mother, “Woman, here is your son!” ");
INSERT INTO eng_glw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Then He told the disciple, “Here is your mother!” From that hour, that disciple took her into his own home. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","After this, Jesus, knowing that everything was now accomplished, so that the Scripture might be fulfilled, said, “I’m thirsty!” ");
INSERT INTO eng_glw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","A jar full of vinegar was standing there, so they put a sponge full of the vinegar on a hyssop stalk, and lifted it up to His mouth. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","When Jesus had received the vinegar, He said, “It is finished!” Then, He bowed His head, and gave up His spirit. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Because it was the Preparation Day, the Jews asked Pilate for the prisoners’ legs to be broken, and that they might be taken away, so that the bodies wouldn’t stay on the cross on the Sabbath (because that Sabbath was a special one). ");
INSERT INTO eng_glw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Then the soldiers came and broke the legs of the first man and of the other man who was crucified with Jesus, ");
INSERT INTO eng_glw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","but when they came to Jesus and saw that He was already dead, they didn’t break His legs. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Instead, one of the soldiers pierced His side with a spear, and immediately blood and water came out. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","He who saw it has testified, and his testimony is true; and he knows that he is telling the truth, so that you may believe. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","These things were done so that the Scripture should be fulfilled, “Not one of His bones shall be broken.” ");
INSERT INTO eng_glw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Another Scripture says, “They will look on Him who they pierced.” ");
INSERT INTO eng_glw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","After this, Joseph of Arimathea, being a disciple of Jesus, but secretly, for fear of the Jews, asked Pilate if he could take the body of Jesus away; and Pilate gave him permission. So he came and took the body of Jesus. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemus, who at first came to Jesus by night, also came, bringing about a hundred Roman pounds of a mixture of myrrh and aloes. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","So they took the body of Jesus, and wrapped it in strips of linen with the spices, as is the burial custom of the Jews. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","In the place where He was crucified, there was a garden, and in the garden a new tomb, in which no one had yet been laid. ");
INSERT INTO eng_glw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Because of the Jewish Preparation Day, and because the tomb was nearby, they laid Jesus there. ");
INSERT INTO eng_glw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","On the first day of the week, Mary Magdalene came to the tomb early, while it was still dark, and saw that the stone had been taken away from the tomb. ");
INSERT INTO eng_glw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Then she ran and came to Simon Peter, and to the other disciple, who Jesus loved, and told them, “They’ve taken the Lord away, out of the tomb, and we don’t know where they’ve laid Him!” ");
INSERT INTO eng_glw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Then Peter and the other disciple went out, and were going to the tomb. ");
INSERT INTO eng_glw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","They both ran together, and the other disciple outran Peter and came to the tomb first. ");
INSERT INTO eng_glw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Stooping down and looking in, He saw the strips of linen lying there, but he didn’t go in. ");
INSERT INTO eng_glw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Then Simon Peter came, following him, and went into the tomb. He saw the strips of linen lying there, ");
INSERT INTO eng_glw_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","and the handkerchief that had been around His head, not lying with the strips of linen, but folded together in a place by itself. ");
INSERT INTO eng_glw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Then the other disciple, who came to the tomb first, also went in, and he saw and believed. ");
INSERT INTO eng_glw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","For they still didn’t know the Scripture, that Jesus must rise again from the dead. ");
INSERT INTO eng_glw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Then the disciples went back to their own homes, ");
INSERT INTO eng_glw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","but Mary stood outside by the tomb, weeping. As she wept, she stooped down and looked into the tomb. ");
INSERT INTO eng_glw_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","She saw two angels in white sitting where the body of Jesus had been lying, one at the head and the other at the feet. ");
INSERT INTO eng_glw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Then they asked her, “Woman, why are you weeping?” She answered them, “Because they have taken away my Lord, and I don’t know where they have laid Him.” ");
INSERT INTO eng_glw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Now when she had said this, she turned around and saw Jesus standing there, but she didn’t know that it was Jesus. ");
INSERT INTO eng_glw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus asked her, “Woman, why are you weeping? Who are you looking for?” She, supposing Him to be the gardener, said to Him, “Sir, if You have carried Him away, tell me where You’ve laid Him, and I will take Him away.” ");
INSERT INTO eng_glw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesus said to her, “Mary!” She turned and said to him, “Rhabbouni!” (which means Teacher). ");
INSERT INTO eng_glw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus said to her, “Don’t touch me, because I haven’t yet ascended to my Father; but go to my brothers and tell them, ‘I am ascending to my Father and your Father, and to my God and your God.’” ");
INSERT INTO eng_glw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mary Magdalene came and told the disciples that she had seen the Lord, and that He had told her these things. ");
INSERT INTO eng_glw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Then, that same first day of the week, at evening, although the doors were locked where the disciples were assembled (for fear of the Jews), Jesus came and stood in their midst. He said to them, “Peace be with you.” ");
INSERT INTO eng_glw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","When He had said this, He showed them His hands and His side. Then the disciples rejoiced when they saw the Lord. ");
INSERT INTO eng_glw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","So Jesus said to them again, “Peace be with you! As the Father has sent me, so I send you.” ");
INSERT INTO eng_glw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","When he had said this, he breathed on them and said to them, “Receive the Holy Spirit. ");
INSERT INTO eng_glw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","If you forgive the sins of any, they are forgiven them. If you retain the sins of any, they are retained.” ");
INSERT INTO eng_glw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Now Thomas, called the Twin, one of the twelve, wasn’t with them when Jesus came. ");
INSERT INTO eng_glw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Therefore the other disciples were telling him, “We have seen the Lord!” But he told them, “Unless I see the imprint of the nails in His hands, put my finger into the nail prints, and put my hand into His side, I won’t believe.” ");
INSERT INTO eng_glw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","After eight days, His disciples were again inside, and Thomas with them. Jesus came, the doors having been locked, and stood in their midst, and said, “Peace be with you.” ");
INSERT INTO eng_glw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Then He told Thomas, “Put your finger here, and see my hands. Reach your hand here, and put it into my side. Don’t be doubting, but believing.” ");
INSERT INTO eng_glw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomas answered Him, “My Lord and my God!” ");
INSERT INTO eng_glw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesus told him, “Thomas, you have believed because you have seen me. Blessed are those who haven’t seen, and yet have believed.” ");
INSERT INTO eng_glw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Truly, Jesus also performed many other signs in the presence of the disciples, which aren’t written in this book, ");
INSERT INTO eng_glw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","but these have been written so that you may believe that Jesus is the Christ, God’s Son; and so that believing you may have life in His name. ");
INSERT INTO eng_glw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","After these things, Jesus showed Himself to the disciples again, at the Sea of Tiberias. He showed Himself in the following way. ");
INSERT INTO eng_glw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Peter, Thomas called the Twin, Nathanael of Cana in Galilee, the sons of Zebedee, and two others of His disciples were together. ");
INSERT INTO eng_glw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter told them, “I’m going fishing.” They said to him, “We’ll go with you, too.” They went out immediately and got into the boat, and that night they caught nothing. ");
INSERT INTO eng_glw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Now when the morning had come, Jesus stood on the shore, but the disciples didn’t know that it was Jesus. ");
INSERT INTO eng_glw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Therefore Jesus asked them, “Children, you don’t have any fish, do you?” “No,” they answered Him. ");
INSERT INTO eng_glw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","He told them, “Cast the net on the right-hand side of the boat, and you’ll find some.” So, they cast the net, and then they were unable to haul it in because of the great number of fish. ");
INSERT INTO eng_glw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Therefore that disciple who Jesus sincerely loved told Peter, “It’s the Lord!” So when Simon Peter heard that it was the Lord, he put his outer garment on (for he had taken it off), and threw himself into the sea. ");
INSERT INTO eng_glw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","The other disciples came in the little boat, for they weren’t far from land, but about two hundred cubits away, dragging the net full of fish. ");
INSERT INTO eng_glw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","So when they came ashore, they saw a charcoal fire already burning, with fish and bread placed on it. ");
INSERT INTO eng_glw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus told them, “Bring some of the fish that you just caught.” ");
INSERT INTO eng_glw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Peter went up and dragged the net to land, full of one hundred fifty-three large fish. Although there were so many, the net wasn’t torn. ");
INSERT INTO eng_glw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus said to them, “Come and eat breakfast.” Yet none of the disciples dared ask Him, “Who are You?” They knew that it was the Lord. ");
INSERT INTO eng_glw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesus then came and took the bread and gave it to them, and likewise the fish. ");
INSERT INTO eng_glw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","This is now the third time that Jesus showed Himself to His disciples after He was raised from the dead. ");
INSERT INTO eng_glw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","When they had eaten breakfast, Jesus asked Simon Peter, “Simon, son of Jonah, do you sincerely love me more than these?” He answered, “Yes, Lord. You know that I love You.” “Feed my lambs,” Jesus replied. ");
INSERT INTO eng_glw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","He asked him a second time, “Simon, son of Jonah, do you sincerely love me?” He answered, “Yes, Lord. You know that I love You.” “Shepherd my sheep,” He replied. ");
INSERT INTO eng_glw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","He asked the third time, “Simon, son of Jonah, do you love me?” Peter was grieved because He asked him the third time, “Do you love me?” He answered, “Lord, You know everything. You know that I love You.” “Feed My sheep,” Jesus replied. ");
INSERT INTO eng_glw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Most assuredly, I tell you, when you were younger, you dressed yourself and walked where you wanted to; but when you are old, you will stretch out your hands, and another will dress you and carry you where you don’t want to go.” ");
INSERT INTO eng_glw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","He said this to indicate what kind of death he would glorify God with. When He had said this, He told Peter, “Follow me!” ");
INSERT INTO eng_glw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Then Peter, turning around, saw a disciple following. This was the disciple who Jesus sincerely loved, the one who had also leaned on Jesus’ breast at the supper and asked, “Lord, who is going to betray You?” ");
INSERT INTO eng_glw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peter therefore, seeing him, asked Jesus, “Lord, what about this man?” ");
INSERT INTO eng_glw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus answered, “If I want him to remain until I come, what is that to you? You follow me!” ");
INSERT INTO eng_glw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Because of this answer, the rumor spread among the brothers that this disciple wouldn’t die, but Jesus didn’t tell him that he wouldn’t die, but only, “If I want him to remain until I come, what is that to you?” ");
INSERT INTO eng_glw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","This is the disciple who testifies about these things, and who wrote these things. We know that his testimony is true. ");
INSERT INTO eng_glw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","There are also many other things that Jesus did, which if they were written one by one, I suppose that even the world itself couldn’t contain the books that would be written. Amen. ");
INSERT INTO eng_glw_vpl VALUES ("J11_1","092_1_1","1JN","1","1","1","We declare to you that which was from the beginning, which we have heard, which we have seen with our eyes, which we watched, and our hands have touched, concerning the Word of life. ");
INSERT INTO eng_glw_vpl VALUES ("J11_2","092_1_2","1JN","1","2","2","The life was revealed, and we have seen, and testify, and declare to you this eternal life which was with the Father and was revealed to us. ");
INSERT INTO eng_glw_vpl VALUES ("J11_3","092_1_3","1JN","1","3","3","That which we have seen and heard we declare to you, that you may also have fellowship with us. Truly our fellowship is with the Father and with His Son, Jesus Christ. ");
INSERT INTO eng_glw_vpl VALUES ("J11_4","092_1_4","1JN","1","4","4","We write these things to you so that your joy may be full. ");
INSERT INTO eng_glw_vpl VALUES ("J11_5","092_1_5","1JN","1","5","5","This is the message which we have heard from Him and declare to you: that God is light and in Him is no darkness at all. ");
INSERT INTO eng_glw_vpl VALUES ("J11_6","092_1_6","1JN","1","6","6","If we say that we have fellowship with Him, but walk in darkness, we lie and don’t do what is true. ");
INSERT INTO eng_glw_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","But if we walk in the light, as He is in the light, we have fellowship with one another, and the blood of Jesus Christ, His Son, cleanses us from all sin. ");
INSERT INTO eng_glw_vpl VALUES ("J11_8","092_1_8","1JN","1","8","8","If we say that we don’t sin, we are deceiving ourselves, and the truth isn’t in us. ");
INSERT INTO eng_glw_vpl VALUES ("J11_9","092_1_9","1JN","1","9","9","If we admit to our sins, He is faithful and with righteous justice forgives us our sins and cleanses us from all unrighteousness. ");
INSERT INTO eng_glw_vpl VALUES ("J11_10","092_1_10","1JN","1","10","10","If we claim that we haven’t sinned, we call Him a liar, and His word isn’t in us. ");
INSERT INTO eng_glw_vpl VALUES ("J12_1","092_2_1","1JN","2","1","1","My little children, I am writing these things to you so that you won’t sin. If anyone sins, we have an Intercessor with the Father, the righteous Jesus Christ. ");
INSERT INTO eng_glw_vpl VALUES ("J12_2","092_2_2","1JN","2","2","2","He Himself is the atoning sacrifice for our sins; and not for ours only, but also for those of the whole world. ");
INSERT INTO eng_glw_vpl VALUES ("J12_3","092_2_3","1JN","2","3","3","This is how we know that we have come to know Him: if we keep His commandments. ");
INSERT INTO eng_glw_vpl VALUES ("J12_4","092_2_4","1JN","2","4","4","The one who says, “I have come to know Him,” and doesn’t keep His commandments is a liar, and the truth isn’t in him. ");
INSERT INTO eng_glw_vpl VALUES ("J12_5","092_2_5","1JN","2","5","5","But whoever keeps His word has the sincere love of God truly perfected in him. By this we know that we are in Him: ");
INSERT INTO eng_glw_vpl VALUES ("J12_6","092_2_6","1JN","2","6","6","whoever claims to live in Jesus ought to walk in the same way He walked. ");
INSERT INTO eng_glw_vpl VALUES ("J12_7","092_2_7","1JN","2","7","7","Brothers and sisters, I’m not writing a new commandment to you, but an old commandment which you have had from the beginning. The old commandment is the word which you have heard. ");
INSERT INTO eng_glw_vpl VALUES ("J12_8","092_2_8","1JN","2","8","8","Yet, I am writing a new commandment to you, which is true in Him and in you, because the darkness is passing away, and the true light is already shining. ");
INSERT INTO eng_glw_vpl VALUES ("J12_9","092_2_9","1JN","2","9","9","Whoever claims to be in the light but hates a brother or sister, is still in darkness. ");
INSERT INTO eng_glw_vpl VALUES ("J12_10","092_2_10","1JN","2","10","10","Whoever sincerely loves his brothers and sisters lives in the light, and there is no cause for stumbling in him. ");
INSERT INTO eng_glw_vpl VALUES ("J12_11","092_2_11","1JN","2","11","11","But whoever hates a brother or sister is in darkness and walks in darkness, and doesn’t know where he is going, because the darkness has blinded his eyes. ");
INSERT INTO eng_glw_vpl VALUES ("J12_12","092_2_12","1JN","2","12","12","I write to you, little children, because your sins are forgiven for His name’s sake. ");
INSERT INTO eng_glw_vpl VALUES ("J12_13","092_2_13","1JN","2","13","13","I write to you, fathers, because you have known Him who is from the beginning. I write to you, young men, because you have overcome the evil one. I write to you, little children, because you have known the Father. ");
INSERT INTO eng_glw_vpl VALUES ("J12_14","092_2_14","1JN","2","14","14","I have written to you, fathers, because you have known Him who is from the beginning. I have written to you, young men, because you are strong, and the word of God lives in you, and you have overcome the wicked one. ");
INSERT INTO eng_glw_vpl VALUES ("J12_15","092_2_15","1JN","2","15","15","Don’t sincerely love the world or the things in the world. If anyone sincerely loves the world, the sincere love of the Father isn’t in him. ");
INSERT INTO eng_glw_vpl VALUES ("J12_16","092_2_16","1JN","2","16","16","For everything that is in the world - the lust of the flesh, the lust of the eyes, and the pride of life - isn’t the Father’s, but is the world’s. ");
INSERT INTO eng_glw_vpl VALUES ("J12_17","092_2_17","1JN","2","17","17","The world and its lusts are passing away, but whoever does the will of God stays forever. ");
INSERT INTO eng_glw_vpl VALUES ("J12_18","092_2_18","1JN","2","18","18","Little children, we are in the end times. As you have heard the antichrist is coming, even now many antichrists have come. By this we know that we are in the end times. ");
INSERT INTO eng_glw_vpl VALUES ("J12_19","092_2_19","1JN","2","19","19","They went out from us, but they didn’t belong to us. For if they had belonged to us, they would have continued with us. Instead, they went out so that it might be revealed that none of them belonged to us. ");
INSERT INTO eng_glw_vpl VALUES ("J12_20","092_2_20","1JN","2","20","20","But you have an anointing from the Holy One, and you all know the truth. ");
INSERT INTO eng_glw_vpl VALUES ("J12_21","092_2_21","1JN","2","21","21","I write to you, not because you don’t know the truth, but because you do know it, and because you know that no lie belongs to the truth. ");
INSERT INTO eng_glw_vpl VALUES ("J12_22","092_2_22","1JN","2","22","22","Who is a liar? Whoever denies that Jesus is the Christ. Whoever denies the Father and the Son is an antichrist. ");
INSERT INTO eng_glw_vpl VALUES ("J12_23","092_2_23","1JN","2","23","23","Whoever denies the Son doesn’t have the Father either. Whoever acknowledges the Son also has the Father. ");
INSERT INTO eng_glw_vpl VALUES ("J12_24","092_2_24","1JN","2","24","24","Therefore, let that which you heard from the beginning live in you. If what you heard from the beginning lives in you, you also will live in the Son and in the Father. ");
INSERT INTO eng_glw_vpl VALUES ("J12_25","092_2_25","1JN","2","25","25","This is the promise that He has promised to us - eternal life. ");
INSERT INTO eng_glw_vpl VALUES ("J12_26","092_2_26","1JN","2","26","26","I have written these things to you about those who are trying to deceive you. ");
INSERT INTO eng_glw_vpl VALUES ("J12_27","092_2_27","1JN","2","27","27","As for you, the anointing that you received from Him lives in you, and you have no need for anyone to teach you. Yet as His anointing teaches you about all things, and is true and not a lie; just as it has taught you, you live in Him. ");
INSERT INTO eng_glw_vpl VALUES ("J12_28","092_2_28","1JN","2","28","28","Now, little children, live in Him, so that when He appears, we may have confidence and not shrink away from Him in shame at His coming. ");
INSERT INTO eng_glw_vpl VALUES ("J12_29","092_2_29","1JN","2","29","29","If you know that He is righteous, then know that everyone who also practices righteousness is born of Him. ");
INSERT INTO eng_glw_vpl VALUES ("J13_1","092_3_1","1JN","3","1","1","See how great a sincere love the Father has given us, that we should be called children of God! Because the world didn’t know Him, it doesn’t know us. ");
INSERT INTO eng_glw_vpl VALUES ("J13_2","092_3_2","1JN","3","2","2","Beloved, now we are children of God, and it hasn’t yet appeared what we will be. We know that when He appears we will be like Him, because we will see Him just as He is. ");
INSERT INTO eng_glw_vpl VALUES ("J13_3","092_3_3","1JN","3","3","3","Everyone who has this hope fixed on Him purifies himself, just as He is pure. ");
INSERT INTO eng_glw_vpl VALUES ("J13_4","092_3_4","1JN","3","4","4","Everyone who practices sin also practices lawlessness. Sin is lawlessness. ");
INSERT INTO eng_glw_vpl VALUES ("J13_5","092_3_5","1JN","3","5","5","You know that He appeared to take away sins. There is no sin in Him. ");
INSERT INTO eng_glw_vpl VALUES ("J13_6","092_3_6","1JN","3","6","6","No one who lives in Him sins. No one who sins has seen Him or knows Him. ");
INSERT INTO eng_glw_vpl VALUES ("J13_7","092_3_7","1JN","3","7","7","Little children, don’t let anybody deceive you. The one who practices righteousness is righteous, just as He is righteous. ");
INSERT INTO eng_glw_vpl VALUES ("J13_8","092_3_8","1JN","3","8","8","The one who practices sin is the Devil’s, because the Devil has sinned from the beginning. The Son of God appeared for this purpose, that He might destroy the works of the Devil. ");
INSERT INTO eng_glw_vpl VALUES ("J13_9","092_3_9","1JN","3","9","9","No one who is born of God practices sin, because God’s seed lives in him. He can’t continue to sin, because he is born of God. ");
INSERT INTO eng_glw_vpl VALUES ("J13_10","092_3_10","1JN","3","10","10","By this the children of God and the children of the Devil are obvious: anyone who doesn’t practice righteousness is not God’s, and neither is anyone who doesn’t sincerely love his brother or sister. ");
INSERT INTO eng_glw_vpl VALUES ("J13_11","092_3_11","1JN","3","11","11","For this is the message that you have heard from the beginning, that we should sincerely love one another. ");
INSERT INTO eng_glw_vpl VALUES ("J13_12","092_3_12","1JN","3","12","12","Don’t be like Cain, who belonged to the evil one, and killed his brother. Why did he kill him? Because Cain’s deeds were evil, and his brother’s were righteous. ");
INSERT INTO eng_glw_vpl VALUES ("J13_13","092_3_13","1JN","3","13","13","Don’t be surprised, brothers and sisters, if the world hates you. ");
INSERT INTO eng_glw_vpl VALUES ("J13_14","092_3_14","1JN","3","14","14","We know that we have passed out of death into life, because we sincerely love our brothers and sisters. Whoever doesn’t sincerely love lives in death. ");
INSERT INTO eng_glw_vpl VALUES ("J13_15","092_3_15","1JN","3","15","15","Whoever hates his brother or sister is a murderer, and you know that no murderer has eternal life living in him. ");
INSERT INTO eng_glw_vpl VALUES ("J13_16","092_3_16","1JN","3","16","16","By this we know God’s sincere love, because He laid down His life for us. So we also ought to lay down our lives for our brothers and sisters. ");
INSERT INTO eng_glw_vpl VALUES ("J13_17","092_3_17","1JN","3","17","17","If someone has this world’s goods, and sees a brother in need, and closes up his heart of compassion from him, how does God’s sincere love live in him? ");
INSERT INTO eng_glw_vpl VALUES ("J13_18","092_3_18","1JN","3","18","18","My little children, let’s not sincerely love just in words or in language, but in deed and in truth. ");
INSERT INTO eng_glw_vpl VALUES ("J13_19","092_3_19","1JN","3","19","19","This is how we will know that we belong to the truth, and how we will assure our hearts before Him ");
INSERT INTO eng_glw_vpl VALUES ("J13_20","092_3_20","1JN","3","20","20","whenever our hearts condemn us; for God is greater than our hearts, and He knows all things. ");
INSERT INTO eng_glw_vpl VALUES ("J13_21","092_3_21","1JN","3","21","21","Beloved, if our hearts don’t condemn us, we have confidence before God; ");
INSERT INTO eng_glw_vpl VALUES ("J13_22","092_3_22","1JN","3","22","22","and we receive from Him whatever we ask, because we keep His commandments and do the things that please Him. ");
INSERT INTO eng_glw_vpl VALUES ("J13_23","092_3_23","1JN","3","23","23","This is His commandment, that we believe in the name of His Son, Jesus Christ, and that we sincerely love one another, just as He commanded us. ");
INSERT INTO eng_glw_vpl VALUES ("J13_24","092_3_24","1JN","3","24","24","Whoever keeps His commandments lives in Him, and He lives in that person. This is how we know that He lives in us: by the Spirit He has given us. ");
INSERT INTO eng_glw_vpl VALUES ("J14_1","092_4_1","1JN","4","1","1","Beloved, don’t believe every spirit, but test the spirits to see whether they are from God; because many false prophets have gone out into the world. ");
INSERT INTO eng_glw_vpl VALUES ("J14_2","092_4_2","1JN","4","2","2","This is how you know God’s Spirit: every spirit that acknowledges that Jesus Christ has come in the flesh is from God. ");
INSERT INTO eng_glw_vpl VALUES ("J14_3","092_4_3","1JN","4","3","3","Every spirit that fails to acknowledge Jesus isn’t from God. This is the spirit of the antichrist, which you have heard is coming, and now it is already in the world. ");
INSERT INTO eng_glw_vpl VALUES ("J14_4","092_4_4","1JN","4","4","4","You are from God, little children, and have overcome them, because He who is in you is greater than he who is in the world. ");
INSERT INTO eng_glw_vpl VALUES ("J14_5","092_4_5","1JN","4","5","5","They are from the world, therefore they talk like they are from the world, and the world listens to them. ");
INSERT INTO eng_glw_vpl VALUES ("J14_6","092_4_6","1JN","4","6","6","We are from God. Whoever knows God listens to us. Whoever is not from God does not listen to us. By this we know the spirit of truth and the spirit of error. ");
INSERT INTO eng_glw_vpl VALUES ("J14_7","092_4_7","1JN","4","7","7","Beloved, let us sincerely love one another, for sincere love is from God, and everyone who sincerely loves is born of God and knows God. ");
INSERT INTO eng_glw_vpl VALUES ("J14_8","092_4_8","1JN","4","8","8","The one who doesn’t sincerely love doesn’t know God, for God is sincere love. ");
INSERT INTO eng_glw_vpl VALUES ("J14_9","092_4_9","1JN","4","9","9","The sincere love of God was manifested in us by this, that God has sent His only born Son into the world so that we might live through Him. ");
INSERT INTO eng_glw_vpl VALUES ("J14_10","092_4_10","1JN","4","10","10","In this is sincere love: not that we sincerely loved God, but that He sincerely loved us and sent his Son as an atoning sacrifice for our sins. ");
INSERT INTO eng_glw_vpl VALUES ("J14_11","092_4_11","1JN","4","11","11","Beloved, if God sincerely loved us like this, we ought to sincerely love one another, too. ");
INSERT INTO eng_glw_vpl VALUES ("J14_12","092_4_12","1JN","4","12","12","No one has ever seen God, but if we sincerely love one another, God lives in us and His sincere love is made complete in us. ");
INSERT INTO eng_glw_vpl VALUES ("J14_13","092_4_13","1JN","4","13","13","This is how we know that we live in Him and He in us, because He has given us of His Spirit. ");
INSERT INTO eng_glw_vpl VALUES ("J14_14","092_4_14","1JN","4","14","14","We have seen and testify that the Father has sent the Son as Savior of the world. ");
INSERT INTO eng_glw_vpl VALUES ("J14_15","092_4_15","1JN","4","15","15","God lives in whoever confesses that Jesus is the Son of God, and that person lives in God. ");
INSERT INTO eng_glw_vpl VALUES ("J14_16","092_4_16","1JN","4","16","16","We have come to know and have believed the sincere love which God has for us. God is sincere love. One who lives in sincere love lives in God, and God lives in him. ");
INSERT INTO eng_glw_vpl VALUES ("J14_17","092_4_17","1JN","4","17","17","Sincere love has been perfected among us in this: that we may have confident boldness on the judgment day, because as He is, so are we in this world. ");
INSERT INTO eng_glw_vpl VALUES ("J14_18","092_4_18","1JN","4","18","18","There is no fear in sincere love, but perfect, sincere love casts out fear, because fear involves punishment. But whoever fears has not been made perfect in sincere love. ");
INSERT INTO eng_glw_vpl VALUES ("J14_19","092_4_19","1JN","4","19","19","We sincerely love, because He first sincerely loved us. ");
INSERT INTO eng_glw_vpl VALUES ("J14_20","092_4_20","1JN","4","20","20","If someone says, “I sincerely love God,” and hates his brother or sister, he is a liar. If someone doesn’t sincerely love a brother or sister he has seen, how can he sincerely love God whom he hasn’t seen? ");
INSERT INTO eng_glw_vpl VALUES ("J14_21","092_4_21","1JN","4","21","21","This commandment we have from Him: that whoever sincerely loves God must sincerely love his brothers and sisters, too. ");
INSERT INTO eng_glw_vpl VALUES ("J15_1","092_5_1","1JN","5","1","1","Whoever believes that Jesus is the Christ is born of God, and whoever loves the Father loves the child born of Him. ");
INSERT INTO eng_glw_vpl VALUES ("J15_2","092_5_2","1JN","5","2","2","This is how we know that we sincerely love the children of God: by sincerely loving God and keeping His commandments. ");
INSERT INTO eng_glw_vpl VALUES ("J15_3","092_5_3","1JN","5","3","3","For this is God’s sincere love, that we keep His commandments. His commandments aren’t burdensome, ");
INSERT INTO eng_glw_vpl VALUES ("J15_4","092_5_4","1JN","5","4","4","for whatever is born of God overcomes the world. This is the victory that has overcome the world - our faith. ");
INSERT INTO eng_glw_vpl VALUES ("J15_5","092_5_5","1JN","5","5","5","Who is the one who overcomes the world, but one who believes that Jesus is God’s Son? ");
INSERT INTO eng_glw_vpl VALUES ("J15_6","092_5_6","1JN","5","6","6","This is He who came by water and blood - Jesus Christ; not only by water, but by water and blood. ");
INSERT INTO eng_glw_vpl VALUES ("J15_7","092_5_7","1JN","5","7","7","It is the Spirit who testifies, because the Spirit is truth. For there are three that testify, ");
INSERT INTO eng_glw_vpl VALUES ("J15_8","092_5_8","1JN","5","8","8","the Spirit, the water, and the blood; and these three are in agreement as one. ");
INSERT INTO eng_glw_vpl VALUES ("J15_9","092_5_9","1JN","5","9","9","If we receive the witness of men, the witness of God is greater; because this is God’s testimony which He has testified about His Son. ");
INSERT INTO eng_glw_vpl VALUES ("J15_10","092_5_10","1JN","5","10","10","One who believes in the Son of God has the witness in himself. One who doesn’t believe God has accused Him of being a liar, because he hasn’t believed in the testimony that God has given concerning His Son. ");
INSERT INTO eng_glw_vpl VALUES ("J15_11","092_5_11","1JN","5","11","11","This is the witness, that God has given us eternal life, and this life is in His Son. ");
INSERT INTO eng_glw_vpl VALUES ("J15_12","092_5_12","1JN","5","12","12","Whoever has the Son has life. Whoever doesn’t have God’s Son doesn’t have life. ");
INSERT INTO eng_glw_vpl VALUES ("J15_13","092_5_13","1JN","5","13","13","I have written these things to you who believe in the name of God’s Son, so that you may know that you have eternal life. ");
INSERT INTO eng_glw_vpl VALUES ("J15_14","092_5_14","1JN","5","14","14","This is the confidence that we have in Him: that if we ask anything according to His will, He hears us. ");
INSERT INTO eng_glw_vpl VALUES ("J15_15","092_5_15","1JN","5","15","15","If we know that He hears us in whatever we ask, then we know that we have the requests which we have asked from Him. ");
INSERT INTO eng_glw_vpl VALUES ("J15_16","092_5_16","1JN","5","16","16","If you see your brother or sister committing a sin not leading to death, you should ask, and God will, for you, give life to those who commit sin not leading to death. There is a kind of sin leading to death. I don’t say that you should make requests for this. ");
INSERT INTO eng_glw_vpl VALUES ("J15_17","092_5_17","1JN","5","17","17","All unrighteousness is sin, and there is a kind of sin that doesn’t lead to death. ");
INSERT INTO eng_glw_vpl VALUES ("J15_18","092_5_18","1JN","5","18","18","We know that anyone who is born of God doesn’t keep sinning, but He who was born of God keeps him. The wicked one doesn’t harm or even touch him. ");
INSERT INTO eng_glw_vpl VALUES ("J15_19","092_5_19","1JN","5","19","19","We know that we belong to God, and the whole world lies in the power of the evil one. ");
INSERT INTO eng_glw_vpl VALUES ("J15_20","092_5_20","1JN","5","20","20","We know that God’s Son has come, and has given us understanding, so that we might know Him who is true. We are in Him who is true, in His Son Jesus Christ. This is the true God and eternal life. ");
INSERT INTO eng_glw_vpl VALUES ("J15_21","092_5_21","1JN","5","21","21","Little children, keep yourselves from idols. ");
INSERT INTO eng_glw_vpl VALUES ("J21_1","093_1_1","2JN","1","1","1","The Elder, To the chosen lady and her children, whom I sincerely love in truth - and not only I, but also all those who have known the truth - ");
INSERT INTO eng_glw_vpl VALUES ("J21_2","093_1_2","2JN","1","2","2","because of the truth which lives in us and will be with us forever: ");
INSERT INTO eng_glw_vpl VALUES ("J21_3","093_1_3","2JN","1","3","3","Grace, mercy, and peace will be with us from God the Father and from the Lord Jesus Christ, the Son of the Father, in truth and sincere love. ");
INSERT INTO eng_glw_vpl VALUES ("J21_4","093_1_4","2JN","1","4","4","I was very glad to find some of your children walking in truth, just as we have been commanded to do by the Father. ");
INSERT INTO eng_glw_vpl VALUES ("J21_5","093_1_5","2JN","1","5","5","Now I ask you, dear lady, not as writing to you a new commandment, but the one which we have had from the beginning, that we sincerely love one another. ");
INSERT INTO eng_glw_vpl VALUES ("J21_6","093_1_6","2JN","1","6","6","This is sincere love: that we walk according to His commandments. This is the commandment, just as you have heard from the beginning, that you should walk in it. ");
INSERT INTO eng_glw_vpl VALUES ("J21_7","093_1_7","2JN","1","7","7","For many deceivers have gone out into the world - those who don’t acknowledge that Jesus Christ has come in the flesh. Such a one is a deceiver and an antichrist. ");
INSERT INTO eng_glw_vpl VALUES ("J21_8","093_1_8","2JN","1","8","8","Watch yourselves, that you might not lose what we have accomplished, but that you may get a full reward. ");
INSERT INTO eng_glw_vpl VALUES ("J21_9","093_1_9","2JN","1","9","9","Anyone who doesn’t live in the teaching of Christ, but runs away from it, doesn’t have God. One who lives in the teaching has both the Father and the Son. ");
INSERT INTO eng_glw_vpl VALUES ("J21_10","093_1_10","2JN","1","10","10","If anyone comes to you and doesn’t bring this teaching, don’t welcome or receive that person into your house, ");
INSERT INTO eng_glw_vpl VALUES ("J21_11","093_1_11","2JN","1","11","11","for the one who welcomes such a person participates in that person’s evil deeds. ");
INSERT INTO eng_glw_vpl VALUES ("J21_12","093_1_12","2JN","1","12","12","Since I have so many things to write to you, I don’t want to do so with paper and ink; but I hope to come to you and speak face to face, that our joy may be made full. ");
INSERT INTO eng_glw_vpl VALUES ("J21_13","093_1_13","2JN","1","13","13","The children of your chosen sister greet you. Amen. ");
INSERT INTO eng_glw_vpl VALUES ("J31_1","094_1_1","3JN","1","1","1","The Elder, To the beloved Gaius, whom I sincerely love in truth: ");
INSERT INTO eng_glw_vpl VALUES ("J31_2","094_1_2","3JN","1","2","2","Beloved, I pray that in all ways you may prosper and be in good health, just as I know that your soul prospers. ");
INSERT INTO eng_glw_vpl VALUES ("J31_3","094_1_3","3JN","1","3","3","For I rejoiced greatly when some brothers came and testified about the truth that is in you, as indeed you do walk in the truth. ");
INSERT INTO eng_glw_vpl VALUES ("J31_4","094_1_4","3JN","1","4","4","I have no greater joy than to hear that my children are walking in the truth. ");
INSERT INTO eng_glw_vpl VALUES ("J31_5","094_1_5","3JN","1","5","5","Beloved, you are acting faithfully in whatever you accomplish for the brothers and sisters, and especially when they are strangers. ");
INSERT INTO eng_glw_vpl VALUES ("J31_6","094_1_6","3JN","1","6","6","They have testified to your sincere love before the church. You will do well to send them on their way in a manner worthy of God, ");
INSERT INTO eng_glw_vpl VALUES ("J31_7","094_1_7","3JN","1","7","7","for they went out for the sake of the Name, accepting nothing from the heathen. ");
INSERT INTO eng_glw_vpl VALUES ("J31_8","094_1_8","3JN","1","8","8","Therefore we ought to support such people, that we may be fellow workers with the truth. ");
INSERT INTO eng_glw_vpl VALUES ("J31_9","094_1_9","3JN","1","9","9","I wrote to the church, but Diotrephes, who loves to be first among them, doesn’t accept what we say. ");
INSERT INTO eng_glw_vpl VALUES ("J31_10","094_1_10","3JN","1","10","10","For this reason, if I come, I will call attention to his deeds which he does, unjustly accusing us with wicked words. Not satisfied with this, he himself doesn’t receive the brothers and sisters, either, and he forbids those who desire to do so and puts them out of the church. ");
INSERT INTO eng_glw_vpl VALUES ("J31_11","094_1_11","3JN","1","11","11","Beloved, don’t imitate what is evil, but what is good. The one who does good belongs to God; the one who does evil hasn’t seen God. ");
INSERT INTO eng_glw_vpl VALUES ("J31_12","094_1_12","3JN","1","12","12","Demetrius has received a good testimony from everyone, and from the truth itself. We add our testimony, and you know that our testimony is true. ");
INSERT INTO eng_glw_vpl VALUES ("J31_13","094_1_13","3JN","1","13","13","I had many things to write to you, but I would rather not write them to you with pen and ink; ");
INSERT INTO eng_glw_vpl VALUES ("J31_14","094_1_14","3JN","1","14","14","but I hope to see you soon, and we will speak face to face. ");
INSERT INTO eng_glw_vpl VALUES ("J31_15","094_1_15","3JN","1","15","15","Peace be to you. The friends greet you. Greet the friends by name. ");
ALTER TABLE eng_glw_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
