﻿USE sofia;
DROP TABLE IF EXISTS sofia.ena_vpl;
CREATE TABLE ena_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ena_vpl WRITE;
INSERT INTO ena_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Vaka sɨbaŋ Asɨ agaŋ hɨdɨlɨ maha fɨli uaiaŋ susu akuaba akuaba agɨladɨ lamami. ");
INSERT INTO ena_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Hadɨhu fɨli nagaŋ mu hɨdɨlɨ sɨbaŋ hɨnimi. Akuaba akuaba apalɨ sɨbaŋ hɨnimi. Avɨli laci hɨnimi. Lavɨla avɨli agaŋ abɨlu apalɨ. Hɨfɨlɨ pam hɨnimi. Hɨnidaci Asɨ dɨ Amɨŋ agaŋ avɨli sabɨ heŋ uu veve hɨdadami. ");
INSERT INTO ena_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Lɨdaci Asɨ agaŋ abami. Abɨlu havalam uami. Lɨci abɨlu havalami. ");
INSERT INTO ena_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Abɨlu havalɨci igavɨla abami. Ha huaci uami. Lavɨla abɨlu agadɨdaŋ hɨfɨlɨ agadɨdaŋ latɨhami. Latɨhavɨla hɨfɨlɨ agadɨ hɨtɨŋ lamami. Abɨlu agadɨ hɨtɨŋ lamami. ");
INSERT INTO ena_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Abɨlu saŋ abɨlu uami. Hɨfɨlɨ saŋ hɨfɨlɨ uami. La hɨfɨlɨ lavɨla hɨnia mɨŋalahɨci ha mɨhiŋ pabiŋ. ");
INSERT INTO ena_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Lɨci cɨhu abami. Uaiaŋ susu agaŋ avɨli agadɨ hɨnilaham uami. Lɨhu hɨnidi agaŋ hɨtɨŋ hɨnim uami. Sabɨ hɨnidi agaŋ hɨtɨŋ hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Lɨci hameŋ laci ala lɨmi. Uaiaŋ susu agaŋ hɨnilahɨci avɨli uaiaŋ susu lɨhu hɨnimi agaŋ nɨbu hɨtɨŋ hɨnimi. Avɨli uaiaŋ susu sabɨ hɨnimi agaŋ nɨbu hɨtɨŋ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Lɨci uaiaŋ susu saŋ uaiaŋ susu uami. La hɨfɨlɨ lavɨla hɨnia mɨŋalahɨci ha mɨhiŋ ahica. ");
INSERT INTO ena_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Lɨci abami. Avɨli uaiaŋ susu lɨhu hɨnidi agaŋ uavɨla pabiŋ abɨla hɨvɨ laci hɨnim uami. Lɨci fɨli agaŋ iaham uami. Lɨci hameŋ laci ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Lɨci avɨli apalɨ hɨnimi agasaŋ fɨli uami. Avɨli pabiŋ abɨla hɨvɨ hɨnimi agasaŋ avɨli hekɨlɨ uami. La igavɨla abami. Ha huaci uami. ");
INSERT INTO ena_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Lavɨla abami. Kɨlɨ lɨbulɨbu sɨmɨŋ isabɨlaŋ akuaba akuaba mu hɨdɨlɨ mu hɨdɨlɨ agɨlaŋ fɨli neŋ iahavɨm uami. Iahavɨla hɨlɨcɨ hɨtɨŋ hɨtɨŋ lamavɨm uami. Lɨci hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Kɨlɨ lɨbulɨbu sɨmɨŋ isabɨlaŋ akuaba akuaba mu hɨdɨlɨ mu hɨdɨlɨ agɨlaŋ iahavɨmi. Iahavɨla hɨlɨcɨ hɨtɨŋ hɨtɨŋ lamavɨmi. Lamavɨci igavɨla abami. Ha huaci uami. ");
INSERT INTO ena_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","La hɨfɨlɨ lavɨla hɨnia mɨŋalahɨci ha mɨhiŋ ahica pam. ");
INSERT INTO ena_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Lɨci abami. Abɨlu agɨlaŋ uaiaŋ susu hɨvɨ hɨniavɨla hɨfɨlɨ agadɨdaŋ uaiadi agadɨdaŋ latɨhavɨm uami. Latɨhavɨdaci iga iga abavɨbali uami. Ha uaiaŋ hɨmiŋ aba abavɨbali uami. Ha avɨli hɨmiŋ aba abavɨbali uami. Ha mɨhiŋ hekɨlɨ aba abavɨbali uami. Ha hualɨ pabiŋ aba abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Abɨlu uaiaŋ susu hɨvɨ hɨniavɨbali agɨlaŋ fɨli agasaŋ abɨlu iguavɨm uami. Lɨci hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Abɨlu hekɨlɨ ahica lamami. Hekɨlɨ ha uaiadi abɨlu havala havala saŋ lamami. Sudɨme ha hɨfɨlɨ abɨlu havala havala saŋ lamami. La lidɨ agɨladɨ avi lamami. ");
INSERT INTO ena_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Fɨli agadɨ abɨlu igu igu saŋ abɨlu sɨkasɨkan agɨladɨ uaiaŋ susu hɨvɨ lamami. ");
INSERT INTO ena_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Lɨci uaiaŋ agaŋ uaiadi hɨvɨ abɨlu havalami. Avaŋ agaŋ hɨfɨlɨ hɨvɨ abɨlu havalami. Lɨci uaiadi agaŋ hɨtɨŋ hɨnimi. Hɨfɨlɨ agaŋ hɨtɨŋ hɨnimi. Lɨci igavɨla abami. Ha huaci uami. ");
INSERT INTO ena_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","La hɨfɨlɨ lavɨla hɨnia mɨŋalahɨci ha mɨhiŋ limu ahica limu ahica. ");
INSERT INTO ena_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Lɨci abami. Hehɨlaŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨlaŋ avɨli hekɨlɨ hɨvɨ hɨdavɨm uami. Havaŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨlaŋ hɨvɨ vuhavuha hɨdavɨm uami. ");
INSERT INTO ena_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Lavɨla hehɨlaŋ hekɨlɨ hekɨlɨ sudɨme sudɨme mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ lamami. Havaŋ mu hɨdɨlɨ mu hɨdɨlɨ avi lamami. La igavɨla abami. Ha huaci uami. ");
INSERT INTO ena_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Lavɨla nulɨdɨ huaci lamavɨla abami. Hehɨlaŋ namɨlaŋ avɨli hekɨlɨ neŋ hɨniavɨla ninaŋ mɨgua habɨlɨhalaŋ uami. Mɨgua habɨla avɨli hekɨlɨ nagadɨ fɨhalɨhalaŋ uami. Havaŋ namɨlaŋ fɨli neŋ hɨniavɨla ninaŋ mɨgua habɨlɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","La hɨfɨlɨ lavɨla hɨnia mɨŋalahɨci ha mɨhiŋ human limu fɨhala. ");
INSERT INTO ena_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Lɨci abami. Sɨhɨm sabaŋ mu hɨdɨlɨ mu hɨdɨlɨ fɨli neŋ iahavɨm uami. Sɨhɨm sabaŋ uleŋ hɨsɨŋ iahavɨm uami. Sɨhɨm sabaŋ saua hɨsɨŋ iahavɨm uami. Lahu akuaba akuaba iahavɨm uami. Lɨci hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Sɨhɨm sabaŋ uleŋ hɨsɨŋ saua hɨsɨŋ lahu akuaba akuaba mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ lamami. La igavɨla abami. Ha huaci uami. ");
INSERT INTO ena_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Lavɨla abami. Hulaŋ daŋ iamɨgali daŋ lamɨlɨŋ viaŋ nukeŋ me hɨniavɨbali uami. Viaŋ nukeŋ me hɨniavɨla fɨli nagadɨ migɨlavɨbali uami. Sɨhɨm sabaŋ hehɨlaŋ lahu havaŋ akuaba akuaba fɨli neŋ hɨniavɨlalɨ agɨladɨ avi migɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Lavɨla hulaŋ daŋ iamɨgali daŋ lamɨci nɨbu nukeŋ me sɨbaŋ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Lɨhavɨci nulɨdɨ huaci lamavɨla abami. Hulaŋ iamɨgali namɨlaŋ fɨli neŋ hɨnia habɨlɨhalaŋ uami. Habɨla fɨli nagadɨ sɨkasɨkan fɨhalɨhalaŋ uami. Fɨhalɨlaŋ akuaba akuaba agɨlaŋ naludɨ lɨhu hɨvɨ hɨniavɨm uami. Hɨniavɨdaci fɨli nagadɨ migɨlɨhalaŋ uami. Sɨhɨm sabaŋ hehɨlaŋ lahu havaŋ akuaba akuaba fɨli neŋ hɨniavɨlalɨ agɨladɨ avi migɨlɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ci igɨlaŋ uami. Sɨmɨŋ isabɨlaŋ kɨlɨ akuaba akuaba hɨlɨcɨ lamavɨlalɨ agɨladɨ nalusaŋ lamacin uami. Nulɨdɨ amɨŋ agɨladɨ sɨkasɨkan vivi nɨbalaŋ uami. Nulɨdɨ hɨlɨcɨ nana hɨsɨŋ agɨladɨ avi sɨkasɨkan vivi nɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Kɨlɨ asɨŋ lɨbulɨbu akuaba akuaba sɨhɨm sabaŋ agɨlasaŋ lamacin uami. Sɨhɨm sabaŋ lahu havaŋ akuaba akuaba navɨbali agasaŋ lamacin uami. Lɨci hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Lɨhavɨci akuaba akuaba lamami agɨladɨ igavɨla abami. Ha huaci sɨbaŋ uami. La hɨfɨlɨ lavɨla hɨnia mɨŋalahɨci ha mɨhiŋ human limu fɨhala human limu pabiŋ cɨjɨŋ. ");
INSERT INTO ena_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","2","Fɨli uaiaŋ susu akuaba akuaba sɨkasɨkan agɨladɨ lama fɨhalami. La hɨfɨlɨ lavɨla hɨnia mɨŋalahɨci mɨhiŋ human limu fɨhala human limu ahica cɨjɨŋ agaŋ iahami. Iahɨci mɨhiŋ agadɨ hɨvɨ alusami. ");
INSERT INTO ena_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Sibɨla fɨhalami agasaŋ mɨhiŋ agadɨ huaci lamavɨla abami. Ha iadɨ alusɨsɨ mɨhiŋ hekɨlɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","5","Asɨ Iaue fɨli uaiaŋ susu akuaba akuaba lamami agadɨ ciaŋ nɨbu nameŋ. Asɨ Iaue agaŋ fɨli uaiaŋ susu akuaba akuaba agɨladɨ lamami agadɨ ala avɨli ma abɨci mɨgami. Lɨci kɨlɨ lɨbulɨbu sɨmɨŋ isabɨlaŋ akuaba akuaba agɨlaŋ ma iahavɨmi. Hulaŋ iamɨgali hualɨ sibɨla vivi hɨsɨŋ agɨlaŋ avi apalɨ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Avɨli ma mɨgadami. Hamu cɨbɨ pam mɨgadami. Mɨgɨdaci fɨli agaŋ simɨsimɨ laci hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Lɨci Asɨ Iaue agaŋ fɨli caŋ agadɨ viavɨla hulaŋ lamami. Lamavɨla hɨhi hɨnibali aba mugaŋ sɨmɨ hɨvɨ huŋe mahɨlɨci ivouci hulaŋ agaŋ hɨhi iahami. ");
INSERT INTO ena_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Lɨci Asɨ Iaue agaŋ Iden fɨli tɨbɨ heŋ hualabɨla lamami. Uaiaŋ iahaiaha kɨlikɨli heŋ lamami. Lamavɨla hulaŋ agadɨ via uavɨla hualabɨla heŋ lamami. ");
INSERT INTO ena_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Lavɨla abɨci kɨlɨ mu hɨdɨlɨ mu hɨdɨlɨ agɨlaŋ iahavɨmi. Iahavɨla hajɨŋ huaci huaci agɨladɨ lamavɨmi. Amɨŋ huaci huaci nana hɨsɨŋ agɨladɨ lamavɨmi. Kɨlɨ ahica agɨlaŋ avi hualabɨla alɨhaŋ heŋ iahavɨmi. Mu hana navɨla huaci hameŋ laci hameŋ laci hɨnihɨni hɨsɨŋ. Mu hana navɨla hɨji hutesɨ vivi hɨsɨŋ. Hɨji hutesɨ viavɨla nameŋ aba aba hɨsɨŋ. Ha huaci aba aba aba hɨsɨŋ. Ha sɨbɨlɨ aba aba aba hɨsɨŋ. ");
INSERT INTO ena_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Avɨli makaŋ hekɨlɨ agaŋ Iden fɨli tɨbɨ heŋ hɨniavɨla hualabɨla agadɨ hɨnilahavɨla iloumi. Hualabɨla agasaŋ avɨli igudaci fɨli agaŋ simɨsimɨ hɨniadami. Ilouavɨla makaŋ sɨhɨlami. Sɨhɨlavɨla limu ahica limu ahica ilouavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Avɨli makaŋ mu Pison. Pison avɨli makaŋ agaŋ Havila fɨli tɨbɨ agadɨ hɨnilahavɨla iloumi. Lɨba golɨ agɨlaŋ Havila fɨli tɨbɨ heŋ hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Nulɨdɨ lɨba golɨ agɨlaŋ huaci sɨbaŋ. Kɨlɨ ikupi hɨsi me iahavɨhadami agɨlaŋ nɨbɨlaŋ Havila fɨli tɨbɨ heŋ hɨniavɨhadami. Lɨba konilian agɨlaŋ avi Havila fɨli tɨbɨ heŋ hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Avɨli makaŋ mu Gihon. Gihon avɨli makaŋ agaŋ Kusɨ fɨli tɨbɨ agadɨ hɨnilahavɨla iloumi. ");
INSERT INTO ena_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Avɨli makaŋ mu Taigɨlisɨ. Taigɨlisɨ avɨli makaŋ agaŋ Asilia fɨli tɨbɨ caba caba heŋ iloumi. Uaiaŋ iahaiaha kɨlikɨli heŋ iloumi. Avɨli makaŋ mu Iufɨletisɨ. ");
INSERT INTO ena_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Asɨ Iaue agaŋ Iden hualabɨla hɨsɨŋ akuaba akuaba agɨladɨ migɨla migɨla sibɨla vivi saŋ hulaŋ agadɨ via uavɨla hualabɨla heŋ lamami. ");
INSERT INTO ena_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Lamavɨla abami. Hualabɨla hɨsɨŋ kɨlɨ nagɨladɨ amɨŋ agɨladɨ sɨkasɨkan huaci nɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Agadɨ ala kɨlɨ pabiŋ hɨji hutesɨ vivi hɨsɨŋ agadɨ amɨŋ agɨladɨ nɨmɨnaŋ uami. Nama nudɨ navɨla ha hɨmɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Lavɨla cɨhu abami. Hulaŋ nagaŋ hɨtɨŋ hɨnici huaci ma lɨbali uami. Nudɨ hala saŋ lamɨlɨŋ ahica hɨniavɨci ha huaci lɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Lavɨla sɨhɨm sabaŋ lahu havaŋ akuaba akuaba fɨli nagadɨ hɨvɨ lamami agɨladɨ likɨlavɨla hulaŋ agadɨ pɨŋ via uavɨla abami. Sɨhɨm sabaŋ lahu havaŋ akuaba akuaba nagɨladɨ ibi hɨtɨŋ hɨtɨŋ lamɨha uami. Lɨci sɨhɨm sabaŋ lahu havaŋ akuaba akuaba agɨladɨ ibi hɨtɨŋ hɨtɨŋ lamami. Lama fɨhalɨci hameŋ laci ala hɨniavɨhadami. Hɨniavɨdaci hulaŋ agaŋ igɨci hala nɨbu hula hɨnihɨni agaŋ apalɨ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Lɨci Asɨ Iaue agaŋ abɨci hulaŋ agaŋ labi hɨmavɨla valɨ me hɨnimi. Valɨ me hɨnidaci nudɨ madɨŋ henaŋ agadɨ mɨŋahubɨla vimi. Viavɨla cɨhu nudɨ madɨŋ henaŋ uvɨ agadɨ lamasɨjimi. ");
INSERT INTO ena_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Lamasɨjiavɨla madɨŋ henaŋ mɨŋahubɨla vimi agadɨ hɨvɨ ala iamɨgali lamami. Lama viavɨla hulaŋ agadɨ pɨŋ via umi. ");
INSERT INTO ena_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Via uci igavɨla abami. E e uami. Nɨbu iamɨgali uami. Viaŋ hulaŋ uami. Nɨbu iadɨ hala sɨbaŋ uami. Nudɨ henaŋ han iadɨ agadɨ viavɨla lami uami. Nudɨ hadipɨlɨ han iadɨ agadɨ viavɨla lami uami. ");
INSERT INTO ena_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Hameŋ sadaŋ hulaŋ agɨlaŋ nulɨdɨ numɨgaiagagalinɨlu agɨladɨ valavala iamɨgali sabisabi nulɨdɨ abinadinɨlu agɨlaŋ hula hadipɨlɨ pabiŋ me hɨniavɨlalɨ. ");
INSERT INTO ena_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Hulaŋ iamɨgali agɨlaŋ muhɨlɨ havɨlɨ apalɨ hɨniavɨhadami agadɨ ala ma sɨhumahɨlavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Asɨ Iaue agaŋ sɨhɨm sabaŋ lahu akuaba akuaba agɨladɨ lamami hadɨhu sɨhɨm sabaŋ agɨlaŋ hulaŋ iamɨgali agɨladɨ ilasɨsɨ hɨji daŋ ma hɨniavɨhadami. Lahu agaŋ pam nɨbu hameŋ hɨji daŋ hɨniadami. La mu tɨbɨ lahu agaŋ uavɨla iamɨgali agadɨ abitɨhami. Asɨ agaŋ hualabɨla hɨsɨŋ kɨlɨ nagɨladɨ amɨŋ agɨladɨ nana saŋ naludɨ abamɨgɨla fɨhalalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Lɨci iamɨgali agaŋ abami. Eke uami. Kɨlɨ akape nagɨladɨ amɨŋ agɨladɨ huaci nɨbalu uami. ");
INSERT INTO ena_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Agadɨ ala kɨlɨ pabiŋ hualɨ alɨhaŋ hɨvɨ hɨnidi agasaŋ pam abamɨgɨlavɨla aludɨ abalɨ uami. Nudɨ amɨŋ agɨladɨ nɨmɨlaŋ aba abalɨ uami. Human hɨvɨ avi mɨŋaigɨmɨlaŋ aba abalɨ uami. Mɨŋaigavɨla ha namɨlaŋ hɨmɨbalaŋ aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Lɨci lahu agaŋ abami. Eke uami. Ma hɨmɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kɨlɨ agadɨ amɨŋ agɨladɨ navɨla hɨji hutesɨ vibalaŋ uami. Hɨji hutesɨ viavɨla igavɨla abɨbalaŋ uami. Ha huaci aba abɨbalaŋ uami. Ha sɨbɨlɨ aba abɨbalaŋ uami. Lavɨla Asɨ nukeŋ me hɨnibalaŋ uami. Hameŋ sadaŋ kɨlɨ agadɨ amɨŋ agɨladɨ nana saŋ abamɨgɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Lɨci iamɨgali agaŋ kɨlɨ agadɨ amɨŋ agɨladɨ igɨci huaci sɨbaŋ hɨniavɨmi. La hɨji lamami. Kɨlɨ nagadɨ amɨŋ agɨladɨ huaci akua navin uami. Navɨla hɨji hutesɨ vivin akua uami. Lavɨla kɨlɨ agadɨ amɨŋ agɨladɨ ahɨlavɨla nami. Navɨla limu hɨhɨle muŋanu saŋ iguci nami. ");
INSERT INTO ena_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Navɨla hɨji viavɨla abavɨmi. I uavɨmi. Alaŋ muhɨlɨ havɨlɨ apalɨ hɨnidalu uavɨmi. Lavɨla kɨlɨ fikɨ asɨŋ agɨladɨ via hɨcavɨla havɨlɨ me lɨbavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Lɨba hɨniavɨdaci hɨfɨlɨdaŋ lɨci Asɨ Iaue agaŋ hualabɨla heŋ vedaci nudɨ hɨcɨ sagɨliŋ agadɨ igahɨlavɨla Asɨ aludɨ igɨmɨdɨ uavɨla kɨlɨ pɨŋ hɨvɨ sɨvɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Sɨvɨla hɨniavɨdaci Asɨ Iaue agaŋ hulaŋ agadɨ ulavɨla abami. Nama abeŋ hɨnidanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Lɨci hulaŋ agaŋ abami. Nama vedanaŋ nadɨ hɨcɨ sagɨliŋ agadɨ igahɨla lɨdavɨla sɨvɨlin uami. Muhɨlɨ havɨlɨ apalɨ hɨniavɨla sɨvɨlin uami. ");
INSERT INTO ena_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Lɨci abami. Nadɨ ani abɨci igavɨla abɨnaŋ uami. Viaŋ muhɨlɨ havɨlɨ apalɨ hɨnin aba abɨnaŋ uami. Kɨlɨ agadɨ amɨŋ agɨladɨ nana saŋ abamɨgɨlacin agɨladɨ akua viavɨla nɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Lɨci abami. Iamɨgali iasaŋ iguahanaŋ nagaŋ nɨbu ahɨla via iguci nin uami. ");
INSERT INTO ena_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Lɨci Asɨ Iaue agaŋ iamɨgali agadɨ abami. Iamɨgali nama akɨ lɨnaŋ uami. Lɨci abami. Lahu agaŋ iadɨ ilasɨci nin uami. ");
INSERT INTO ena_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Lɨci Asɨ Iaue agaŋ lahu agadɨ abami. Nama lusɨŋ sɨbɨlɨ vinaŋ sadaŋ nama vɨhɨlɨ igɨbanaŋ uami. Sɨhɨm sabaŋ uleŋ hɨsɨŋ saua hɨsɨŋ vɨhɨlɨ hameŋ agadɨ ma igavɨbali uami. Nama pam vɨhɨlɨ hekɨlɨ igɨbanaŋ uami. Humɨgaŋ hɨvɨ pam magɨla magɨla hɨdɨbanaŋ uami. Humɨgaŋ hɨvɨ magɨla magɨla fɨli ibɨlɨ nana hɨdɨbanaŋ uami. Mufɨli mufɨli avi hameŋ laci magɨla magɨla hɨdɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Viaŋ abɨlɨŋ iamɨgali agaŋ nadɨ nagɨli lamɨbali uami. Nudɨ iamɨlɨhalinu agɨlaŋ avi nadɨ iamɨlɨhalina agɨladɨ nagɨli lamavɨbali uami. Iamɨlɨhalinu agɨlaŋ nadɨ hali lagucabɨlavɨdaci nama nulɨdɨ hɨcɨ sulɨm agɨladɨ iavɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Lavɨla iamɨgali agadɨ abami. Nama ninanadi humɨgaŋ daŋ hɨnidanaŋ viaŋ abɨlɨŋ ninanadi viben aba avɨha avɨha hekɨlɨ igɨbanaŋ uami. Agadɨ ala muŋana dɨ ma valɨbanaŋ uami. Nusaŋ pam hacihaci lɨbanaŋ uami. Nɨbu nadɨ manɨgali hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Lavɨla hulaŋ agadɨ avi abami. Nama abina dɨ ciaŋ igahɨlavɨla kɨlɨ agadɨ amɨŋ agɨladɨ nana saŋ abamɨgɨlacin agɨladɨ nɨnaŋ sadaŋ fɨli nagadɨ lɨlɨŋ sɨbɨlɨ lɨbali uami. Sɨbɨlɨ lɨci mufɨli mufɨli sibɨla hekɨlɨ hekɨlɨ fɨli neŋ vivi avɨha avɨha iga iga sɨmɨŋ vivi nɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","19","Hualɨ hulidanaŋ akuaba akuaba cɨhɨvɨ daŋ henaŋ daŋ agɨlaŋ iahaiaha ivasɨjiavɨbali uami. Lɨhavɨdaci nama sibɨla vivi vubɨŋ fɨhala fɨhala vivi nɨbanaŋ uami. Hameŋ lɨdɨŋ hɨnia hɨmɨnabɨla fɨli haca mava hudavɨci fɨli caŋ lɨfɨbanaŋ uami. Viaŋ fɨli caŋ viavɨla nadɨ lamacin sadaŋ hɨmavɨla fɨli caŋ lɨfɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam agaŋ abinu ninanadi huhɨlɨci iaha habɨla hulaŋ iamɨgali akape hɨniavɨbali agasaŋ igahɨlavɨla nudɨ ibi lamavɨla abami. Ivɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Lɨci Asɨ Iaue agaŋ sabaŋ sipsipɨ sɨgɨtɨ viavɨla Adam tamaŋ saŋ iguci havɨlɨ me lɨbavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Lɨhavɨci Asɨ Iaue agaŋ abami. Hulaŋ iamɨgali agɨlaŋ hɨji hutesɨ viavɨla viaŋ me ci hɨniavi uami. La igavɨla nameŋ abavi uami. Ha huaci aba abavi uami. Ha sɨbɨlɨ aba abavi uami. Lavɨla huaci hameŋ laci hameŋ laci hɨnihɨni hɨsɨŋ kɨlɨ agadɨ pɨŋ vehavɨmɨdɨ uami. Vevɨla amɨŋ agɨladɨ ahɨla navɨla hualɨ mu mu hameŋ laci hameŋ laci hɨniavɨmɨdɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","24","Hameŋ abavɨla Adam tamaŋ dɨ lahumi. Lahuci uavɨdaci nudɨ ciaŋ hali hɨsɨŋ vɨdɨvɨdɨŋ daŋ agɨladɨ abɨci uavɨla Iden hualabɨla hɨbɨ agadɨ migɨla migɨla hɨniavɨhadami. Uaiaŋ iahaiaha kɨlikɨli heŋ migɨla migɨla hɨniavɨhadami. Puia hutesɨ avɨŋ mila daŋ agadɨ avi lamɨci limu cimɨla cimɨla haŋala haŋala hɨniadami. Hulaŋ iamɨgali huaci hameŋ laci hameŋ laci hɨnihɨni hɨsɨŋ kɨlɨ agadɨ mikɨ pɨŋ vehavɨmɨdɨ uavɨla nusaŋ migɨla migɨla hɨniavɨhadami. Adam tamaŋ Iden hualabɨla agadɨ valavɨla fɨli tɨbɨ mu hɨvɨ hualɨ sibɨla vivi saŋ uavɨmi. Asɨ Iaue agaŋ fɨli caŋ viavɨla hulaŋ agadɨ lamami. Agadɨ ala hulaŋ agaŋ cɨhu fɨli hɨvɨ hualɨ sibɨla vihadami. ");
INSERT INTO ena_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam agaŋ nudɨ abinu Ivɨ hula hɨniavɨci abinu agaŋ humɨgaŋ ahɨlami. La ninaŋ agadɨ huhɨlavɨla abami. Ha Asɨ Iaue nukeŋ iadɨ ahɨliahuci ninaŋ nagadɨ vin uami. La ninaŋ agadɨ ibi lamavɨla abami. Kein uami. ");
INSERT INTO ena_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","La cɨhu ninaŋ mu Abelɨ dɨ huhɨlami. Lɨci ahica hameŋ haba huhɨla hekɨlɨ hekɨlɨ lɨhavɨmi. La Abelɨ nɨbu sabaŋ sipsipɨ agɨladɨ migɨla migɨla hɨsɨŋ hulaŋ hɨniadami. Kein agaŋ nɨbu hualɨ hulihuli sibɨla hɨsɨŋ hulaŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","La mu tɨbɨ Kein agaŋ hualabɨla hɨsɨŋ sɨmɨŋ hɨhɨle agɨladɨ vave Asɨ Iaue saŋ sagalɨ igumi. ");
INSERT INTO ena_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Lɨdaci Abelɨ agaŋ sabaŋ sipsipɨ ninaŋ hekɨlɨ hekɨlɨ manɨgali limu hɨhɨle agɨladɨ ifɨhɨma ihalahavɨla hɨlɨcɨ sɨdaŋ daŋ agɨladɨ via ua Asɨ Iaue saŋ sagalɨ igumi. Lɨci Asɨ Iaue agaŋ Abelɨ sadaŋ nudɨ sagalɨ agasadaŋ hɨjɨŋalami. ");
INSERT INTO ena_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Agadɨ ala Asɨ Iaue agaŋ Kein sadaŋ nudɨ sagalɨ agasadaŋ ma hɨjɨŋalami. Lɨci Kein agaŋ nudɨ igɨvɨ hɨma sɨbaŋ lɨdaci nudɨ mugaŋ lamɨgaŋ agaŋ sɨbɨlɨ sɨbaŋ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Lɨci Asɨ Iaue agaŋ Kein dɨ abami. Nama akɨ saŋ igɨvɨ hɨnidanaŋ nadɨ mugaŋ lamɨgaŋ sɨbɨlɨ sɨbaŋ hɨnidi uami. ");
INSERT INTO ena_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Nama hɨji huaci daŋ hɨniavɨla akuaba akuaba lɨnaŋ ha viaŋ nasaŋ hɨjɨŋalɨben uami. Nama hɨji sɨbɨlɨ daŋ hɨniavɨla lusɨŋ sɨbɨlɨ vinabɨla uami. Ha nadɨ lusɨŋ sɨbɨlɨ agaŋ nadɨ sɨbɨlɨ lamɨben aba migɨla migɨla hɨnibali uami. Lusɨŋ sɨbɨlɨ agaŋ nadɨ lɨvalɨben aba vɨdɨvɨdɨŋ sɨbaŋ hɨnibali uami. Agadɨ ala nama vɨdɨvɨdɨŋ sɨbaŋ hɨniavɨla nudɨ lɨvalɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Lɨci cɨhu mu tɨbɨ Kein agaŋ iaha imanu Abelɨ dɨ abavɨla ahica uavɨmi. Uavɨla mɨda hɨvɨ iahuavɨla Kein agaŋ iahavɨla imanu Abelɨ dɨ ifɨhɨmami. ");
INSERT INTO ena_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Lɨci Asɨ Iaue agaŋ iaha Kein dɨ abami. Nadɨ imana Abelɨ abeŋ hɨnidi uami. Lɨci Kein agaŋ abami. I uami. Viaŋ nudɨ ma igɨmaŋ uami. Viaŋ nudɨ migɨla hɨnilan sadaŋ iadɨ abɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Lɨci abami. Nama akɨ saŋ lusɨŋ sɨbɨlɨ agadɨ vinaŋ uami. Lɨnaŋ imana dɨ mɨdɨ agaŋ fɨli hɨvɨ ci mɨgi uami. Nudɨ mɨdɨ agaŋ nadɨ hɨbɨŋ ifu ifu saŋ abɨdaci igahɨlin uami. ");
INSERT INTO ena_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","12","Nama imana dɨ ifɨhɨmɨnaŋ nudɨ mɨdɨ agaŋ fɨli hɨvɨ mɨgi sadaŋ nama vɨhɨlɨ igɨbanaŋ uami. La nama hualɨ vɨha hulinabɨla ala fɨli agaŋ sɨbɨlɨ lɨci sɨmɨŋ agɨlaŋ amɨŋ ma sɨhuavɨbali uami. Lavɨla nama hulaŋ ihɨlɨŋ me hɨnihɨni fɨli neŋ mu hɨvɨ mu hɨvɨ havɨ havɨ hɨdɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Lɨci Kein agaŋ ciaŋ agadɨ igahɨlavɨla abami. Ahi uami. Vɨhɨlɨ iasaŋ igunaŋ agadɨ ha viaŋ akɨ lavɨla havɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Iadɨ hualɨ sibɨla vivi saŋ abamɨgɨlɨnaŋ uami. Viaŋ nama hula hɨnihɨni saŋ valavɨla iadɨ lahunaŋ uami. Lahunaŋ viaŋ hulaŋ ihɨlɨŋ me hɨnihɨni fɨli neŋ mu hɨvɨ mu hɨvɨ havɨ havɨ hɨdɨben uami. Hɨdɨdalɨŋ aniaba iadɨ igavɨla ha iadɨ ifɨhɨmavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Lɨci abami. Eke uami. Nadɨ ma ifɨhɨmavɨbali uami. Hulaŋ mu nadɨ ifɨhɨmɨci ha viaŋ nadɨ ahɨliahua hɨbɨŋ hulaŋ human limu fɨhala human limu ahica cɨjɨŋ agɨladɨ ifɨhɨmɨben uami. Lavɨla nudɨ ifɨhɨmavɨmɨdɨ uavɨla nudɨ hadipɨlɨ hɨvɨ sihɨ lɨbami. ");
INSERT INTO ena_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Lɨci Kein agaŋ Asɨ Iaue dɨ valavɨla Nodɨ fɨli tɨbɨ umi. Nodɨ fɨli tɨbɨ agaŋ nɨbu Iden fɨli tɨbɨ hɨnici umi uaiaŋ iahaiaha kɨlikɨli heŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kein agaŋ nudɨ abinu hula hɨniavɨci abinu agaŋ humɨgaŋ ahɨlavɨla ninaŋ huhɨlami. Huhɨlɨci Kein agaŋ ninaŋ agadɨ ibi lamavɨla abami. Enokɨ uami. La cɨhu haiabɨla hɨhi viavɨla haiabɨla agadɨ ibi avi lamavɨla abami. Enokɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Lɨci Enokɨ agaŋ ninaŋ havami. Nudɨ ibi Ilatɨ. Lɨci Ilatɨ agaŋ ninaŋ havami. Nudɨ ibi Mehujaelɨ. Lɨci Mehujaelɨ agaŋ ninaŋ havami. Nudɨ ibi Metusaelɨ. Lɨci Metusaelɨ agaŋ ninaŋ havami. Nudɨ ibi Lamekɨ. ");
INSERT INTO ena_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lɨci Lamekɨ agaŋ iaha iamɨgali ahica sabimi. Mu agadɨ ibi ha nɨbu Ada. Mu agadɨ ibi ha Sila. ");
INSERT INTO ena_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Lɨci Ada agaŋ Jabalɨ dɨ huhɨlami. Jabalɨ agaŋ hɨdɨlɨ maha havɨlɨ ulaŋ agadɨ uu veve hafihafi hɨnihɨni sabaŋ bulɨmakau agɨladɨ migɨladami. Lɨci nudɨ iamɨlɨhalinu agɨlaŋ avi hameŋ laci ala lɨhavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jabalɨ dɨ imanu mu nudɨ ibi Jubalɨ. Jubalɨ agaŋ hɨdɨlɨ maha hɨbɨmaŋ lɨmɨn daŋ agadɨ ifu ifu sai mahɨla mahɨla sɨhɨ iahadami. Lɨci nudɨ iamɨlɨhalinu agɨlaŋ avi hameŋ laci ala lɨhavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila agaŋ avi ninaŋ huhɨlami. Nudɨ ibi Tubalɨkein. Tubalɨkein nɨbu lɨba bɨlasɨ agadɨdaŋ lɨba ain agadɨdaŋ vivi ifɨdaci cinaŋ puia hunaŋ sɨji akuaba akuaba iahavɨhadami. Tubalɨkein dɨ nadinu humɨgaŋ pam agadɨ ibi Nema. ");
INSERT INTO ena_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Mu tɨbɨ Lamekɨ agaŋ nudɨ abinadinu ahica agɨladɨ nameŋ abami. Ada hula Sila hula namɨlaŋ iadɨ ciaŋ igahɨlɨhalaŋ uami. Viaŋ Lamekɨ uami. Iadɨ iamɨgali ahica namɨlaŋ viaŋ akuaba akuaba ciaŋ abɨben agadɨ sɨhɨvia sɨbaŋ igahɨlɨhalaŋ uami. Hulaŋ mu iadɨ puia hɨvɨ ihɨci hɨbɨŋ viaŋ nudɨ ifɨhɨmacin uami. Hulaŋ mɨnibɨlɨ mu agaŋ iadɨ ifɨci iadɨ hadipɨlɨ agaŋ huhɨlɨci hɨbɨŋ viaŋ nudɨ avi ifɨhɨmacin uami. ");
INSERT INTO ena_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Hulaŋ mu Kein dɨ ifɨhɨmɨci ha Asɨ Iaue agaŋ cɨhu Kein dɨ ahɨliahua hɨbɨŋ hulaŋ human limu fɨhala human limu ahica cɨjɨŋ agɨladɨ ifɨhɨmɨvi uami. Agadɨ ala hulaŋ mu iadɨ ifɨhɨmɨci ha iadɨ ahɨliahua hɨbɨŋ hulaŋ 77 agɨladɨ ifɨhɨmavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Mu tɨbɨ cɨhu Adam agaŋ abinu hula hɨniavɨci abinu agaŋ humɨgaŋ ahɨlami. La ninaŋ mu agadɨ huhɨlavɨla abami. Asɨ agaŋ iasaŋ ninaŋ mu ci igui uami. Kein Abelɨ dɨ ifɨhɨmalɨ agasaŋ cɨhu nudɨ uvɨsɨjiŋ vibali aba igui uami. La ibi lamavɨla abami. Setɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Lɨci Setɨ agaŋ ninaŋ havami. La ibi lamavɨla abami. Enosɨ uami. Lɨci hulaŋ iamɨgali agɨlaŋ heŋ hɨdɨlɨ maha Asɨ Iaue dɨ ibi luvɨla luvɨla nudɨ ibi mɨŋaiahavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Adam dɨ ninadinu ajihalinu iamɨlɨhalinu agɨladɨ ibi nameŋ. Asɨ agaŋ hulaŋ daŋ iamɨgali daŋ lamɨci nɨbu me sɨbaŋ hɨniavɨmi. Lavɨla nulɨdɨ huaci lamavɨla abami. Ha hulaŋ iamɨgali uami. ");
INSERT INTO ena_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Lɨci Adam agaŋ hɨnidaci hualɨ 130 uci ninaŋ mu havami. Lɨci ninaŋ agaŋ iahavɨla iaganu me sɨbaŋ hɨnimi. Lɨci nudɨ ibi agadɨ lamavɨla abami. Setɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Lɨci cɨhu hualɨ 800 udaci ninanadi limu hɨhɨle agɨladɨ avi havami. ");
INSERT INTO ena_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Lɨci Adam dɨ hualɨ lugɨlavɨci ua 930 agaŋ iahɨci heŋ hɨmami. ");
INSERT INTO ena_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Setɨ iamɨnu nudɨ huhɨlɨci iaha hɨnidaci hualɨ 105 umi. Lɨci Setɨ agaŋ ninaŋ havami. Nudɨ ibi Enosɨ. ");
INSERT INTO ena_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Lɨci hualɨ 807 udaci ninanadi limu hɨhɨle agɨladɨ avi havami. ");
INSERT INTO ena_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Lɨci Setɨ dɨ hualɨ lugɨlavɨci ua 912 agaŋ iahɨci heŋ hɨmami. ");
INSERT INTO ena_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosɨ iamɨnu nudɨ huhɨlɨci iaha hɨnidaci hualɨ 90 umi. Lɨci Enosɨ agaŋ ninaŋ havami. Nudɨ ibi Kenan. ");
INSERT INTO ena_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Lɨci hualɨ 815 udaci ninanadi limu hɨhɨle agɨladɨ avi havami. ");
INSERT INTO ena_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Lɨci Enosɨ dɨ hualɨ lugɨlavɨci ua 905 agaŋ iahɨci heŋ hɨmami. ");
INSERT INTO ena_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan iamɨnu nudɨ huhɨlɨci iaha hɨnidaci hualɨ 70 umi. Lɨci Kenan agaŋ ninaŋ havami. Nudɨ ibi Mahalalelɨ. ");
INSERT INTO ena_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Lɨci hualɨ 840 udaci ninanadi limu hɨhɨle agɨladɨ avi havami. ");
INSERT INTO ena_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Lɨci Kenan dɨ hualɨ lugɨlavɨci ua 910 agaŋ iahɨci heŋ hɨmami. ");
INSERT INTO ena_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalelɨ iamɨnu nudɨ huhɨlɨci iaha hɨnidaci hualɨ 65 umi. Lɨci Mahalalelɨ agaŋ ninaŋ havami. Nudɨ ibi Jaletɨ. ");
INSERT INTO ena_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Lɨci hualɨ 830 udaci ninanadi limu hɨhɨle agɨladɨ avi havami. ");
INSERT INTO ena_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Lɨci Mahalalelɨ dɨ hualɨ lugɨlavɨci ua 895 agaŋ iahɨci heŋ hɨmami. ");
INSERT INTO ena_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jaletɨ iamɨnu nudɨ huhɨlɨci iaha hɨnidaci hualɨ 162 umi. Lɨci Jaletɨ agaŋ ninaŋ havami. Nudɨ ibi Enokɨ. ");
INSERT INTO ena_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Lɨci hualɨ 800 udaci ninanadi limu hɨhɨle agɨladɨ avi havami. ");
INSERT INTO ena_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Lɨci Jaletɨ dɨ hualɨ lugɨlavɨci ua 962 agaŋ iahɨci heŋ hɨmami. ");
INSERT INTO ena_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enokɨ iamɨnu nudɨ huhɨlɨci iaha hɨnidaci hualɨ 65 umi. Lɨci Enokɨ agaŋ ninaŋ havami. Nudɨ ibi Metusela. ");
INSERT INTO ena_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","24","Lɨci hualɨ 300 udaci ninanadi limu hɨhɨle agɨladɨ avi havami. Enokɨ nɨbu Asɨ dɨ hɨji agadɨ pam lubiahɨladami. Lɨdaci nudɨ hualɨ lugɨlavɨci ua 365 agaŋ iahɨci heŋ Asɨ agaŋ nudɨ hadipɨlɨ daŋ sɨkasɨkan vimi. Vici hulaŋ iamɨgali limu hɨhɨle agɨlaŋ Enokɨ dɨ cɨhu ma sɨbaŋ igavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela iamɨnu nudɨ huhɨlɨci iaha hɨnidaci hualɨ 187 umi. Lɨci Metusela agaŋ ninaŋ havami. Nudɨ ibi Lamekɨ. ");
INSERT INTO ena_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lɨci hualɨ 782 udaci ninanadi limu hɨhɨle agɨladɨ avi havami. ");
INSERT INTO ena_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Lɨci Metusela dɨ hualɨ lugɨlavɨci ua 969 agaŋ iahɨci heŋ hɨmami. ");
INSERT INTO ena_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamekɨ iamɨnu nudɨ huhɨlɨci iaha hɨnidaci hualɨ 182 umi. Lɨci Lamekɨ agaŋ ninaŋ havami. ");
INSERT INTO ena_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","La abami. Vaka Asɨ Iaue agaŋ fɨli nagadɨ lɨci sɨbɨlɨ lɨmi uami. Sɨbɨlɨ lɨci alaŋ sibɨla hekɨlɨ vivi avɨha avɨha iga iga sɨmɨŋ nɨlalu uami. Agadɨ ala ninaŋ nagaŋ aludɨ ahɨliahuci alaŋ heŋ alusɨbalu uami. Hameŋ sadaŋ Lamekɨ agaŋ ninaŋ agadɨ ibi lamavɨla abami. Noa uami. ");
INSERT INTO ena_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lɨci hualɨ 595 udaci ninanadi limu hɨhɨle agɨladɨ avi havami. ");
INSERT INTO ena_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lɨci Lamekɨ dɨ hualɨ lugɨlavɨci ua 777 agaŋ iahɨci heŋ hɨmami. ");
INSERT INTO ena_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa iamɨnu nudɨ huhɨlɨci iaha hɨnidaci hualɨ 500 umi. Lɨci Noa agaŋ ninaŋ ahica pam havami. Nulɨdɨ ibi nameŋ. Mu Siem. Mu Ham. Mu Jafetɨ. ");
INSERT INTO ena_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Hulaŋ iamɨgali agɨlaŋ fɨli neŋ hɨnihɨni habɨlavɨhadami. Habɨla habɨla nadi daŋ nadi daŋ hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Hɨniavɨdaci Asɨ dɨ ciaŋ hali hɨsɨŋ agɨlaŋ nadi agɨladɨ igavɨdaci nulɨdɨ mugaŋ lamɨgaŋ huaci huaci laci hɨniavɨhadami. Hɨniavɨdaci nulɨdɨ nukeŋ hɨji lubiahɨlavɨla nadi agɨladɨ likɨlavɨla sabiavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Lɨhavɨci Asɨ Iaue agaŋ nameŋ abami. Hulaŋ iamɨgali agɨlaŋ hɨmavɨbali sadaŋ iadɨ Amɨŋ agaŋ nɨbɨlaŋ hula sɨkasɨkan ma hɨnibali uami. Viaŋ abɨlɨŋ hulaŋ iamɨgali limu hɨhɨle agɨlaŋ hɨhi hɨniavɨdaci hualɨ 120 uci cɨhu heŋ hɨmavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Asɨ dɨ ciaŋ hali hɨsɨŋ agɨlaŋ nadi agɨladɨ sabiavɨci ninaŋ huhɨlavɨmi. Huhɨlavɨci hekɨlɨ hekɨlɨ lavɨla hulaŋ hutesɨ hutesɨ hɨniavɨhadami. Hulaŋ hutesɨ hutesɨ agɨlaŋ vɨdɨvɨdɨŋ daŋ hɨnihɨni akuaba akuaba sibɨla vivi ibi daŋ ibi daŋ hɨniavɨhadami. Hulaŋ hameŋ agɨlaŋ fɨli neŋ hɨniavɨdaci hualɨ akape uavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Asɨ Iaue agaŋ igɨdaci hulaŋ iamɨgali fɨli neŋ hɨniavɨhadami agɨlaŋ sɨbɨlɨ sɨbaŋ hɨniavɨhadami. Nulɨdɨ hɨji humɨgaŋ agɨlaŋ lusɨŋ sɨbɨlɨ vivi saŋ pam lɨhavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Lɨhavɨdaci Asɨ Iaue agaŋ mavɨn lamavɨla hɨji nameŋ lamami. Viaŋ akɨ saŋ hulaŋ iamɨgali agɨladɨ lamamin uami. Lavɨla humɨgaŋ vɨhɨlɨ vilan uami. ");
INSERT INTO ena_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Hulaŋ iamɨgali viaŋ nukeŋ lamamin agɨladɨ cɨhu sɨkasɨkan ifɨhɨma fɨhalɨben uami. Abeba abeba hɨniavi agɨladɨ sɨkasɨkan ifɨhɨma fɨhalɨben uami. Sɨhɨm sabaŋ uleŋ hɨsɨŋ saua hɨsɨŋ lahu havaŋ akuaba akuaba viaŋ nukeŋ lamamin agɨladɨ avi sɨkasɨkan ifɨhɨma fɨhalɨben uami. Akuaba akuaba agɨladɨ ma lamamin padaŋ ha huaci hɨnivin uami. ");
INSERT INTO ena_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Hameŋ abavɨla ala cɨhu Noa dɨ igavɨla nusaŋ hɨjɨŋalami. ");
INSERT INTO ena_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Noa dɨ ninaŋ ahica pam agɨladɨ ibi nameŋ. Mu Siem. Mu Ham. Mu Jafetɨ. Asɨ agaŋ hulaŋ iamɨgali fɨli neŋ hɨniavɨhadami agɨladɨ sɨkasɨkan igadami. Agadɨ ala Noa dɨ pam igɨdaci nɨbu hulaŋ huaci sɨbaŋ hɨniadami. Nɨbu akuaba akuaba hugɨ apalɨ hɨniadami. Lɨdɨŋ Asɨ dɨ hɨji agadɨ pam lubiahɨladami. ");
INSERT INTO ena_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Asɨ igɨdaci hulaŋ iamɨgali limu hɨhɨle agɨlaŋ sɨbɨlɨ sɨbaŋ hɨniavɨhadami. Nulɨdɨ hɨji humɨgaŋ agɨlaŋ sagaŋ lɨbalɨba saŋ pam lɨhavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Hameŋ lɨdɨŋ hɨniavɨdaci Asɨ igɨdaci hulaŋ iamɨgali agɨlaŋ hula akuaba akuaba hɨhi hɨniavɨhadami agɨlaŋ hula sɨbɨlɨ sɨbaŋ hɨniavɨhadami. Lɨdɨŋ lusɨŋ sɨbɨlɨ saŋ pam lɨhavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Hameŋ lɨhavɨdaci Asɨ agaŋ Noa dɨ abami. Viaŋ igɨlɨŋ hulaŋ iamɨgali sɨkasɨkan sagaŋ lɨbalɨba saŋ pam lɨhavɨlalɨ uami. Hameŋ sadaŋ viaŋ hulaŋ iamɨgali agɨladɨdaŋ akuaba akuaba hɨhi hɨniavɨlalɨ agɨladɨdaŋ sɨkasɨkan ifɨhɨma fɨhalɨben uami. La fɨli avi sɨkasɨkan sɨbɨlɨ lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Nama kɨlɨ vɨdɨvɨdɨŋ daŋ agɨladɨ igavɨla nulɨdɨ ihacɨkɨlacɨkɨla vivi lamalama hunɨga hekɨlɨ agadɨ sibɨla viha uami. Via fɨhalavɨla hɨnihɨni hɨsɨŋ fipɨ hɨtɨŋ hɨtɨŋ lamɨha uami. La hunɨga hekɨlɨ muji agadɨ mɨlɨm vɨdɨvɨdɨŋ hɨvɨ mɨŋepɨhalɨha uami. Sabɨ agadɨ avi mɨŋepɨhalɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Hunɨga hekɨlɨ agadɨ hutesɨ ha 130 mita hameŋ lamɨha uami. Hunɨga hekɨlɨ agadɨ hekɨlɨ ha 22 mita hameŋ lamɨha uami. Hunɨga hekɨlɨ agadɨ tulɨ ha 13 mita hameŋ lamɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Lavɨla hunɨga hekɨlɨ agadɨ muji heŋ ulaŋ me viha uami. Viavɨla huva agadɨ madɨŋ limu limu sɨkasɨkan lalɨgua fɨhalɨmɨnaŋ uami. Huŋe hɨbɨ ivo ivo saŋ 50 senɨtamita valɨnaŋ hɨnim uami. Hameŋ lɨnaŋ abɨlu agaŋ huŋe hɨbɨ heŋ ivoubali uami. Hɨnihɨni hɨsɨŋ ulaŋ uvɨ me agɨladɨ avi ahica pam lamɨha uami. Mu mɨga fɨli heŋ lamɨha uami. Mu iahua alɨhaŋ heŋ lamɨha uami. Mu iahua sabɨ sɨbaŋ heŋ lamɨha uami. Lavɨla hunɨga hekɨlɨ agadɨ madɨŋ heŋ hɨbɨ lamɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Lɨnaŋ viaŋ abɨlɨŋ avɨli agaŋ fɨli neŋ iaha hekɨlɨ lavɨla hulaŋ iamɨgali agɨladɨdaŋ akuaba akuaba fɨli neŋ hɨniavɨlalɨ agɨladɨdaŋ sɨkasɨkan mɨŋamɨgubali uami. Lɨci hulaŋ iamɨgali agɨlaŋ hula akuaba akuaba hɨhi hɨniavɨlalɨ agɨlaŋ hula sɨkasɨkan haba hɨma fɨhalavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Lɨhavɨci viaŋ ciaŋ mɨguavɨla nadɨ abɨben uami. Nama nadɨ abina dɨ viavɨla nadɨ ninadina ahica pam agɨladɨdaŋ nulɨdɨ abinadinɨlu agɨladɨdaŋ likɨlavɨla hameŋ hunɨga hekɨlɨ heŋ mɨgubalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Lavɨla nama akuaba akuaba mu hɨdɨlɨ mu hɨdɨlɨ hɨhi hɨniavɨlalɨ agɨladɨ ahica lɨdɨŋ ahica lɨdɨŋ likɨlɨha uami. Muŋaŋ daŋ mɨgenaŋ daŋ likɨlɨha uami. Likɨlavɨla hunɨga hekɨlɨ heŋ lamɨnaŋ mɨguavɨla hɨniavɨm uami. La nɨbɨlaŋ namɨlaŋ hula hɨniavɨla ma hɨmavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Sɨhɨm sabaŋ lahu havaŋ akuaba akuaba mu hɨdɨlɨ mu hɨdɨlɨ agɨlaŋ ahica lɨdɨŋ ahica lɨdɨŋ nadɨ pɨŋ vehavɨbali uami. Vevɨla namɨlaŋ hula hɨniavɨla ma hɨmavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Lavɨla nalusadaŋ sɨhɨm sabaŋ lahu havaŋ akuaba akuaba agɨlasadaŋ sɨmɨŋ akuaba akuaba agɨladɨ likɨlavɨla hunɨga hekɨlɨ hɨvɨ lamɨha uami. Likɨla lamavɨla ahuata hameŋ nana hɨnibalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Lɨci Noa agaŋ akuaba akuaba Asɨ abami agadɨ hameŋ laci ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Hunɨga hekɨlɨ agadɨ fɨhalɨci Asɨ Iaue agaŋ Noa dɨ abami. Hulaŋ iamɨgali fɨli neŋ hɨniavɨlalɨ agɨlaŋ sɨbɨlɨ sɨbaŋ hɨniavi uami. Agadɨ ala viaŋ igɨlɨŋ nama pam hulaŋ huaci sɨbaŋ hɨninaŋ uami. Hameŋ sadaŋ nama nadɨ abina hula naludɨ ninadinalu ahica pam agɨladɨdaŋ abinadinɨlu agɨladɨdaŋ likɨlavɨla hunɨga hekɨlɨ hɨvɨ mɨguhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Sɨhɨm sabaŋ hɨdɨlɨ hɨtɨŋ hɨtɨŋ hɨbuŋ apalɨ agɨladɨ likɨlɨha uami. Muŋaŋ human limu fɨhala human limu ahica cɨjɨŋ agɨladɨ likɨlɨha uami. Mɨgenaŋ avi human limu fɨhala human limu ahica cɨjɨŋ agɨladɨ likɨlɨha uami. Sɨhɨm sabaŋ hɨdɨlɨ hɨtɨŋ hɨtɨŋ hɨbuŋ daŋ hɨbuŋ daŋ agɨladɨ muŋaŋ pabiŋ mɨgenaŋ pabiŋ hameŋ laci likɨlɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Havaŋ hɨdɨlɨ hɨtɨŋ hɨtɨŋ agɨladɨ avi likɨlɨha uami. Muŋaŋ human limu fɨhala human limu ahica cɨjɨŋ agɨladɨ likɨlɨha uami. Mɨgenaŋ human limu fɨhala human limu ahica cɨjɨŋ agɨladɨ likɨlɨha uami. Nama hameŋ lɨnaŋ nɨbɨlaŋ ma haba hɨmavɨbali uami. Cɨhu mufɨli nɨbɨlaŋ ala fɨli neŋ hɨnia mɨgua habɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Uaiaŋ human limu fɨhala uci viaŋ abɨlɨŋ avɨli agaŋ fɨli neŋ mɨgɨbali uami. Mɨgamɨga hɨnidaci uaiaŋ 38 ubali uami. Lɨci akuaba akuaba viaŋ nukeŋ fɨli neŋ lamɨlɨŋ hɨhi hɨniavɨlalɨ agɨladɨ sɨkasɨkan ifɨhɨma fɨhalɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Lɨci Noa agaŋ Asɨ Iaue nudɨ abami hameŋ laci ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa dɨ hualɨ lugɨlavɨci ua 600 iahɨci avɨli hekɨlɨ agaŋ fɨli neŋ iahami. ");
INSERT INTO ena_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Asɨ agaŋ avɨli mɨgɨbali agasaŋ abɨci Noa tamaŋ nulɨdɨ ninadinɨlu ahica pam agɨlaŋ nulɨdɨ abinadinɨlu ahuata hameŋ hunɨga hekɨlɨ hɨvɨ mɨguavɨmi. Avɨli nahɨmɨmagalu uavɨla mɨguavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Mɨgua hɨniavɨdaci sɨhɨm sabaŋ hɨbuŋ daŋ sɨhɨm sabaŋ hɨbuŋ apalɨ lahu havaŋ akuaba akuaba agɨlaŋ Noa dɨ pɨŋ vehavɨmi. Hɨdɨlɨ hɨtɨŋ hɨtɨŋ ahica lɨdɨŋ ahica lɨdɨŋ vehavɨmi. Muŋaŋ daŋ mɨgenaŋ daŋ vehavɨmi. Veve hunɨga hekɨlɨ hɨvɨ mɨguavɨmi. Asɨ abami hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Mɨgua hɨniavɨdaci uaiaŋ human limu fɨhala uci avɨli hekɨlɨ agaŋ hɨdɨlɨ maha iahami. ");
INSERT INTO ena_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa dɨ hualɨ lugɨlavɨci ua 600 agaŋ iahami. Lɨci hualɨ mu iaha hɨnidaci avaŋ pabiŋ umi. Lɨci avaŋ mu iahami. Iaha hɨnidaci uaiaŋ human limu limu fɨhala hɨcɨ limu fɨhala hɨcɨ limu pabiŋ cɨjɨŋ umi. Lɨci amɨli me hɨvɨ avɨli fɨli muji hɨniadami agaŋ vubɨlɨm daŋ vubɨlɨm daŋ iahaiaha hɨnimi. Avɨli iahua uaiaŋ susu hɨvɨ hɨniadami agaŋ avi heŋ mɨgamɨga hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Avɨli hekɨlɨ agaŋ hɨfɨlɨ hɨfɨlɨ uaiadi uaiadi mɨgamɨga hɨnidaci uaiaŋ 38 umi. ");
INSERT INTO ena_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Avɨli hɨdɨlɨ maha mɨgami hadɨhu ala Noa ani ani agɨlaŋ hunɨga hekɨlɨ hɨvɨ mɨguavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Sɨhɨm sabaŋ uleŋ hɨsɨŋ saua hɨsɨŋ lahu havaŋ akuaba akuaba mu hɨdɨlɨ mu hɨdɨlɨ Noa ani ani hameŋ hunɨga hekɨlɨ hɨvɨ mɨguavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Sɨhɨm sabaŋ akuaba akuaba hɨhi hɨniavɨmi agɨlaŋ muŋaŋ daŋ mɨgenaŋ daŋ Noa dɨ pɨŋ vehavɨmi. Vevɨla hunɨga hekɨlɨ hɨvɨ mɨguavɨmi. Asɨ abami hameŋ laci ala lɨhavɨmi. Lavɨla Noa ani ani sɨkasɨkan hameŋ hunɨga hekɨlɨ hɨvɨ mɨgua hɨniavɨdaci Asɨ Iaue nukeŋ hunɨga hekɨlɨ agadɨ hɨbɨ lɨbami. ");
INSERT INTO ena_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Lɨbɨci hɨniavɨdaci avɨli agaŋ iahɨdaci iahɨdaci uaiaŋ 38 umi. Lɨdaci avɨli agaŋ hunɨga hekɨlɨ agadɨ mɨŋavuhalɨci hunɨga hekɨlɨ agaŋ fɨli agadɨ vala iahami. ");
INSERT INTO ena_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Hameŋ lɨdaci avɨli agaŋ vakala vakala iahɨdaci iahɨdaci hunɨga hekɨlɨ agaŋ heŋ umi vemi. ");
INSERT INTO ena_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Avɨli agaŋ iahaiaha halu hekɨlɨ hekɨlɨ agɨladɨ sɨkasɨkan mɨŋamɨgu fɨhalami. ");
INSERT INTO ena_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Halu hekɨlɨ hekɨlɨ agɨladɨ mɨŋamɨgu fɨhala iahɨci 7 mita hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Lɨci hulaŋ iamɨgali sɨhɨm sabaŋ uleŋ hɨsɨŋ saua hɨsɨŋ lahu havaŋ akuaba akuaba fɨli neŋ hɨhi hɨniavɨmi agɨlaŋ sɨkasɨkan haba hɨma fɨhalavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Akuaba akuaba hɨhi hɨnihɨni fɨli hɨdavɨhadami agɨlaŋ sɨkasɨkan hɨma fɨhalavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Asɨ Iaue agaŋ akuaba akuaba fɨli neŋ hɨniavɨmi agɨladɨ sɨkasɨkan sɨbaŋ ifɨhɨma fɨhalami. Noa ani ani agɨlaŋ hunɨga hekɨlɨ hɨvɨ hɨnihɨni ma hɨmavɨmi. Sɨhɨm sabaŋ akuaba akuaba hunɨga hekɨlɨ hɨvɨ hɨniavɨmi agɨlaŋ avi ma hɨmavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Avɨli agaŋ fɨli agadɨ mɨŋamɨgua hɨnidaci uaiaŋ 148 umi. ");
INSERT INTO ena_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Lɨci Asɨ agaŋ Noa ani ani hunɨga hekɨlɨ agadɨ muji hɨvɨ hɨniavɨmi agɨlasaŋ hɨji igahɨlami. Sɨhɨm sabaŋ akuaba akuaba hunɨga hekɨlɨ agadɨ muji hɨvɨ hɨniavɨmi agɨlasaŋ avi hɨji igahɨlami. Lavɨla abɨci huŋe agaŋ vedaci avɨli hekɨlɨ agaŋ hɨdɨlɨ maha magɨlami. ");
INSERT INTO ena_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Avɨli fɨli muji hɨnihɨni vubɨlɨm daŋ vubɨlɨm daŋ iahaiaha hɨnimi agaŋ heŋ valami. Avɨli iahua uaiaŋ susu hɨvɨ hɨnihɨni mɨgami agaŋ avi sɨkasɨkan valami. ");
INSERT INTO ena_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Lɨci avɨli agaŋ magɨla magɨla mɨgudaci uaiaŋ 148 umi. ");
INSERT INTO ena_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Lɨci Noa dɨ hualɨ lugɨlavɨci ua 600 agaŋ iahami. Lɨci hualɨ mu iaha hɨnidaci avaŋ human limu fɨhala human limu pabiŋ cɨjɨŋ umi. Lɨci avaŋ mu iaha hɨnidaci uaiaŋ human limu limu fɨhala hɨcɨ limu fɨhala hɨcɨ limu pabiŋ cɨjɨŋ umi. Lɨci amɨli me hɨvɨ hunɨga hekɨlɨ agaŋ Alalatɨ fɨli tɨbɨ halu daŋ halu daŋ heŋ fɨli avɨli muji hɨnimi agadɨ hɨvɨ mɨgahɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Mɨgahɨnidaci avɨli agaŋ simɨsimɨ magɨla magɨla mɨgudaci avaŋ agaŋ ahica tɨbɨ mɨgua iahɨci cɨhu mu mɨgua iahɨci uaiaŋ heŋ ala halu huva huva agɨlaŋ pam iahavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Iahavɨci uaiaŋ 38 uci Noa agaŋ hunɨga hekɨlɨ huŋe uu veve hɨbɨ nɨbu nukeŋ vimi agadɨ lavɨlami. ");
INSERT INTO ena_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Lavɨlavɨla havaŋ mu hegumiŋ me agadɨ valɨci vuhavɨla umi. Uavɨla cɨhu ma vemi. Vuhavuha hɨdɨdaci avɨli hekɨlɨ agaŋ sɨkasɨkan magɨla mɨgu fɨhalɨci fɨli agaŋ haiabɨla iahami. ");
INSERT INTO ena_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Havaŋ hegumiŋ me agaŋ vuha uavɨla hɨdɨdaci Noa agaŋ havaŋ mu ibɨlabi agadɨ valɨci vuhavɨla umi. Avɨli ci magɨla mɨgu fɨhali ua hɨma aba nusaŋ havaŋ agadɨ valɨci vuhavɨla umi. ");
INSERT INTO ena_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Lɨci ala hɨma. Avɨli agaŋ fɨli agadɨ hanɨbuŋ mɨŋamɨgua hɨnidaci havaŋ ibɨlabi agaŋ mɨgahɨnihɨni hɨsɨŋ fipɨ cɨki avi ma igami. Lavɨla cɨhu vemi. Veci Noa agaŋ human lamɨci ivouci havaŋ ibɨlabi agadɨ via ivavemi. ");
INSERT INTO ena_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","La makamɨŋa hɨnidaci uaiaŋ human limu fɨhala uci cɨhu ala havaŋ ibɨlabi agadɨ valɨci umi. ");
INSERT INTO ena_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ua hɨdahɨda hɨfɨlɨdaŋ sɨbaŋ kɨlɨ olivɨ asɨŋ muvɨ agadɨ iavahɨlavɨla Noa dɨ pɨŋ cɨhu ve iahami. Lɨci Noa agaŋ igavɨla abami. Avɨli hekɨlɨ agaŋ ci magɨla mɨguadi uami. ");
INSERT INTO ena_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Lavɨla makamɨŋa hɨnidaci uaiaŋ human limu fɨhala uci cɨhu havaŋ ibɨlabi agadɨ valɨci umi. Uavɨla cɨhu ma vemi. Sɨkasɨkan umi. ");
INSERT INTO ena_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Lɨci Noa dɨ hualɨ lugɨlavɨci ua 601 agaŋ iahami. Lɨci hualɨ mu iahɨci uaiaŋ heŋ ala avɨli hekɨlɨ agaŋ magɨla mɨgu fɨhalami. Lɨci Noa agaŋ hunɨga hekɨlɨ ulaŋ huva me agadɨ mɨŋavɨkɨlavɨla igoua igave igɨci fɨli agaŋ subɨlɨben aba lɨmi. ");
INSERT INTO ena_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Hualɨ heŋ ala avaŋ mu mɨgua iaha hɨdɨdaci uaiaŋ 26 uci amɨli me hɨvɨ fɨli agaŋ sɨkasɨkan subɨla fɨhalami. ");
INSERT INTO ena_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Lɨci Asɨ agaŋ Noa dɨ abami. ");
INSERT INTO ena_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Nama nadɨ abina hula hunɨga hekɨlɨ nagadɨ valavɨla fɨli mɨguhalaŋ uami. Nadɨ ninadina ahica pam agɨlaŋ nulɨdɨ abinadinɨlu agɨlaŋ hula hunɨga hekɨlɨ nagadɨ valavɨla fɨli mɨguavɨm uami. ");
INSERT INTO ena_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Sɨhɨm sabaŋ uleŋ hɨsɨŋ saua hɨsɨŋ lahu havaŋ akuaba akuaba agɨlaŋ avi mɨguavɨm uami. Mɨguavɨla sɨhɨm sabaŋ lahu havaŋ akuaba akuaba agɨlaŋ abeba abeba uavɨm uami. Uavɨla ninaŋ mɨgua habɨlavɨm uami. Mɨgua habɨla fɨli nagadɨ sɨkasɨkan fɨhalavɨm uami. ");
INSERT INTO ena_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Lɨci Noa tamaŋ nulɨdɨ ninadinɨlu ahica pam agɨlaŋ nulɨdɨ abinadinɨlu ahuata hameŋ mɨguavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Sɨhɨm sabaŋ uleŋ hɨsɨŋ saua hɨsɨŋ lahu havaŋ akuaba akuaba hɨdɨlɨ hɨtɨŋ hɨtɨŋ agɨlaŋ avi hunɨga hekɨlɨ agadɨ valavɨla fɨli mɨguavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Mɨguavɨla Noa agaŋ Asɨ Iaue saŋ sagalɨ hɨlahɨla hɨsɨŋ lɨba vadɨm ibilami. Ibila fɨhalavɨla sɨhɨm sabaŋ hɨdɨlɨ hɨtɨŋ hɨtɨŋ hɨbuŋ apalɨ apalɨ agɨladɨ pabiŋ lɨdɨŋ pabiŋ lɨdɨŋ likɨlami. Havaŋ avi hɨdɨlɨ hɨtɨŋ hɨtɨŋ hɨbuŋ apalɨ apalɨ agɨladɨ pabiŋ lɨdɨŋ pabiŋ lɨdɨŋ likɨlami. Likɨlavɨla ifɨhɨmuhɨmu uavɨla sagalɨ iguben aba lɨba vadɨm hɨvɨ mɨŋaiahua lama avɨŋ hɨvɨ hɨla fɨhalami. ");
INSERT INTO ena_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Hɨlɨdaci hɨsi huaci huaci agɨlaŋ iahuavɨdaci Asɨ Iaue agaŋ hɨsi iga iga hɨji nameŋ lamami. Hulaŋ iamɨgali mɨnibɨlɨ hɨnihɨni lusɨŋ sɨbɨlɨ vivi hɨji pam lamavɨlalɨ uami. Hameŋ agasaŋ ala viaŋ akuaba akuaba agɨladɨ sɨbɨlɨ igavɨla ifɨhɨma fɨhalacin uami. Agadɨ ala akuaba akuaba sɨbɨlɨ lamacin hameŋ cɨhu cɨhu ma sɨbɨlɨ lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Fɨli nagaŋ hɨnidaci sɨmɨŋ hulihuli hɨmiŋ hɨnibali uami. Uli mavamava hɨmiŋ hɨnibali uami. Vumɨli saŋ hɨmahɨma hɨmiŋ hɨnibali uami. Vubɨŋ fɨhala fɨhala hɨmiŋ hɨnibali uami. Avɨli hɨmiŋ hɨnibali uami. Uaiaŋ hɨmiŋ hɨnibali uami. Uaiadi hɨnibali uami. Hɨfɨlɨ hɨnibali uami. Akuaba akuaba hɨmiŋ agɨlaŋ hameŋ laci hameŋ laci ala hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Asɨ agaŋ Noa dɨdaŋ nudɨ ninadinu agɨladɨdaŋ huaci lamavɨla abami. Namɨlaŋ fɨli neŋ hɨnia ninanadi havahava habɨlɨhalaŋ uami. Habɨlavɨla fɨli nagadɨ sɨkasɨkan fɨhalɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Viaŋ lɨlɨŋ sɨhɨm sabaŋ lahu havaŋ hehɨlaŋ akuaba akuaba agɨlaŋ nalusaŋ hekɨlɨ lɨdavɨbali uami. Lɨdalɨda naludɨ lɨhu hɨvɨ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Vaka viaŋ abɨlɨŋ namɨlaŋ sɨmɨŋ isabɨlaŋ kɨlɨ asɨŋ akuaba akuaba agɨladɨ laci nadamɨlaŋ uami. Iabi neŋ viaŋ abɨlɨŋ namɨlaŋ sɨhɨm sabaŋ akuaba akuaba hɨhi hɨnihɨni hɨdavɨlalɨ agɨladɨ avi vivi nɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Agadɨ ala sɨhɨm mɨdɨ daŋ agadɨ nɨmɨlaŋ uami. Mɨdɨ uu veve hɨnidaci akuaba akuaba hɨhi hɨniavɨlalɨ uami. Hameŋ sadaŋ sɨhɨm mɨdɨ daŋ hɨniavɨlalɨ agɨladɨ nɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Sɨhɨm sabaŋ akuaba akuaba agɨlaŋ hulaŋ mu agadɨ iavavɨci hɨmɨci uami. Ha viaŋ sɨhɨm sabaŋ akuaba akuaba agɨladɨ avi sɨbɨlɨ lamɨben uami. Hulaŋ mu agaŋ hulaŋ mu agadɨ ifɨhɨmɨci uami. Ha viaŋ hulaŋ agadɨ avi sɨbɨlɨ lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Viaŋ Asɨ uami. Viaŋ nukeŋ ala hulaŋ iamɨgali lamɨlɨŋ iaha viaŋ nukeŋ me hɨniavɨlalɨ uami. Hameŋ sadaŋ hulaŋ mu agaŋ hulaŋ mu agadɨ ifɨhɨmɨci ha nudɨ avi hɨbɨŋ ifɨhɨmavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Namɨlaŋ ninanadi akape huhɨlɨhalaŋ uami. Huhɨlɨlaŋ iaha habɨlavɨla fɨli nagadɨ sɨkasɨkan fɨhalavɨm uami. ");
INSERT INTO ena_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Lavɨla Asɨ agaŋ Noa dɨdaŋ nudɨ ninadinu agɨladɨdaŋ abami. ");
INSERT INTO ena_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Ci igɨlaŋ uami. Viaŋ ciaŋ mɨguavɨla naludɨdaŋ naludɨ ninanadinalu ajihalinalu iamɨlɨhalinalu agɨladɨdaŋ abadin uami. ");
INSERT INTO ena_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Sɨhɨm sabaŋ uleŋ hɨsɨŋ saua hɨsɨŋ lahu havaŋ akuaba akuaba hunɨga hekɨlɨ hɨvɨ hɨnia fɨli mɨguavi agɨladɨ abadin uami. Akuaba akuaba mufɨli hɨhi hɨniavɨbali agɨladɨ avi abadin uami. ");
INSERT INTO ena_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Viaŋ ciaŋ mɨguavɨla naludɨ abadin uami. Viaŋ avɨli hekɨlɨ agadɨ cɨhu ma abɨlɨŋ iahɨbali uami. Iaha hulaŋ iamɨgali agɨladɨdaŋ akuaba akuaba hɨhi hɨniavɨlalɨ agɨladɨdaŋ ma mɨŋamɨgubali uami. Avɨli hekɨlɨ agaŋ fɨli nagadɨ sɨkasɨkan cɨhu ma mɨŋamɨguci sɨbɨlɨ lɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Viaŋ lahɨvulɨŋ iahua avɨli susu hɨvɨ ci lamin uami. Nudɨ igavɨla hɨji lamavɨla abɨhalaŋ uami. Ha Asɨ agaŋ ciaŋ mɨguavɨla aludɨdaŋ akuaba akuaba hɨhi hɨniavɨlalɨ agɨladɨdaŋ abami agaŋ aba abɨhalaŋ uami. Ciaŋ mɨguavɨla abami agaŋ hameŋ laci hameŋ laci hɨnibali aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Viaŋ abɨlɨŋ avɨli susu agaŋ iahɨci lahɨvulɨŋ agaŋ avi avɨli susu agadɨ hɨnilaha iahɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Iahɨci igavɨla viaŋ ciaŋ mɨguavɨla naludɨdaŋ akuaba akuaba hɨhi hɨniavɨlalɨ agɨladɨdaŋ abin agasaŋ igahɨlɨben uami. Igahɨlavɨla cɨhu avɨli hekɨlɨ agadɨ ma abɨlɨŋ iaha akuaba akuaba hɨhi hɨniavɨlalɨ agɨladɨ mɨŋamɨguci sɨkasɨkan ma sɨbɨlɨ lɨhavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Lahɨvulɨŋ agaŋ avɨli susu hɨvɨ hɨnidaci viaŋ igavɨla ciaŋ mɨguavɨla naludɨdaŋ sɨhɨm sabaŋ akuaba akuaba fɨli neŋ hɨhi hɨniavɨlalɨ agɨladɨdaŋ abin agasaŋ igahɨlɨben uami. Ciaŋ mɨguavɨla abin agaŋ mufɨli mufɨli hameŋ laci hameŋ laci hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Lahɨvulɨŋ agadɨ igavɨla ciaŋ mɨguavɨla abin agasaŋ hɨji lamɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noa dɨ ninaŋ ahica pam hunɨga hekɨlɨ hɨvɨ hɨnia mɨguavɨmi agɨladɨ ibi nameŋ. Mu Siem. Mu Ham. Mu Jafetɨ. Ham dɨ ninanu nɨbu Kenan. ");
INSERT INTO ena_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Noa dɨ ninaŋ ahica pam agɨlaŋ ninanadi havavɨci nulɨdɨ ajihalinɨlu iamɨlɨhalinɨlu agɨlaŋ latɨha uavɨla fɨli nagadɨ sɨkasɨkan fɨhalavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa agaŋ hualɨ sibɨla vihadami. La nɨbu ala hɨdɨlɨ maha lɨmɨn uain hualɨ agadɨ hulimi. ");
INSERT INTO ena_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Mu tɨbɨ Noa agaŋ lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨ nami. Navɨla uavauava iahumi. Uavauava iahuavɨla nudɨ havɨlɨ uleŋ muji heŋ muhɨlɨ havɨlɨ apalɨ ani hɨsɨvami. ");
INSERT INTO ena_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ani hɨsɨvɨdaci ninanu Ham agaŋ ivouavɨla iaganu dɨ igami. Ham nɨbu Kenan iaganu. Igɨci muhɨlɨ havɨlɨ apalɨ sɨbaŋ ani hɨsɨvami. Hɨsɨvɨdaci Ham cɨhu ivavevɨla Siem dɨdaŋ Jafetɨ dɨdaŋ abami. ");
INSERT INTO ena_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Lɨci Siem hula Jafetɨ hula havɨlɨ ulaŋ agadɨ huligalavɨla hadi hɨlahɨla hutesɨ fɨdɨm agadɨ limu limu mɨŋalɨvavɨla nulɨdɨ macɨŋ hɨvɨ hafiavɨla ahica hulɨpɨŋ hulɨpɨŋ hɨvɨ simɨsimɨ sɨbaŋ uavɨmi. Ua ivouavɨla iaganɨlu dɨ hafilɨbavɨmi. Iaganɨlu agaŋ muhɨlɨ havɨlɨ apalɨ hɨnidaci ninaŋ ahica agɨlaŋ ma limu cimɨlavɨla iaganɨlu dɨ igavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","La ivavehavɨci Noa dɨ hɨji agaŋ tovemi. Toveci hɨnidaci nudɨ ninaŋ sijaŋ Ham agaŋ nudɨ akuaba akuaba lɨmi agasaŋ sulavɨmi. Sulavɨdaci nɨfɨlɨ igahɨlami. ");
INSERT INTO ena_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","La abami. Kenan agaŋ vɨhɨlɨ igɨbali uami. Nɨbu akuaba akuaba apalɨ hɨnibali uami. La hɨnihɨni nudɨ hɨdɨlɨ pam agɨladɨ sibɨla mu mu havɨ havɨ vibali uami. ");
INSERT INTO ena_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","27","La cɨhu abami. Alaŋ Asɨ Iaue dɨ ibi pam mɨŋaiahɨmɨli uami. Ha Siem dɨ Asɨ uami. Kenan agaŋ nɨbu Siem dɨ Jafetɨ dɨ sibɨla hɨsɨŋ hulaŋ hɨnibali uami. Asɨ agaŋ abɨci Jafetɨ dɨ ninanadi agɨlaŋ iaha habɨlavɨla fɨli tɨbɨ hekɨlɨ vihavɨbali uami. Iaha habɨlavɨla Siem dɨ hɨdɨlɨ agɨlaŋ hula huaci hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Avɨli hekɨlɨ agaŋ magɨla mɨgu fɨhalɨci Noa agaŋ fɨli neŋ hɨnidaci hualɨ 350 umi. ");
INSERT INTO ena_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Lɨci Noa dɨ hualɨ lugɨlavɨci ua 950 agaŋ iahɨci heŋ hɨmami. ");
INSERT INTO ena_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noa ninadinu dɨ ibi nameŋ. Mu Siem. Mu Ham. Mu Jafetɨ. Avɨli hekɨlɨ agaŋ magɨla mɨgu fɨhalɨci Noa dɨ ninaŋ ahica pam agɨlaŋ ninanadi heŋ havavɨmi. Nulɨdɨ ninadinɨlu ajihalinɨlu iamɨlɨhalinɨlu agɨladɨ ibi nameŋ. ");
INSERT INTO ena_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jafetɨ ninadinu dɨ ibi nameŋ. Mu Gomelɨ. Mu Magokɨ. Mu Madai. Mu Javan. Mu Tubalɨ. Mu Mesekɨ. Mu Tilasɨ. ");
INSERT INTO ena_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomelɨ ninadinu dɨ ibi nameŋ. Mu Asɨkenasɨ. Mu Lifatɨ. Mu Togalɨma. ");
INSERT INTO ena_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javan ninadinu dɨ ibi nameŋ. Mu Elisa. Mu Talɨsisɨ. Javan nɨbu Saipɨlusɨ avɨli muha hɨniavɨhadami agɨladɨ iamɨlɨnɨlu hɨniadami. Dodan hɨdɨlɨ agɨladɨ avi iamɨlɨnɨlu hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Nɨbɨlaŋ ala latɨhavɨla ua avɨli hekɨlɨ caba caba heŋ hɨniavɨhadami. La hɨdɨlɨ hɨtɨŋ hɨtɨŋ haiabɨla hɨtɨŋ hɨtɨŋ fɨli tɨbɨ hɨtɨŋ hɨtɨŋ hameŋ hɨniavɨhadami. Nulɨdɨ ciaŋ sɨbaŋ avi hɨtɨŋ hɨtɨŋ hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham ninadinu dɨ ibi nameŋ. Mu Kusa. Mu Isipɨ. Mu Libia. Mu Kenan. ");
INSERT INTO ena_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusa ninadinu dɨ ibi nameŋ. Mu Ceba. Mu Havila. Mu Sapɨta. Mu Lama. Mu Sapɨteka. Lama dɨ ninaŋ ahica. Mu Seba. Mu Dedan. ");
INSERT INTO ena_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusa dɨ ninaŋ mu Nimɨlotɨ. Nimɨlotɨ agaŋ nɨbu mɨse hulaŋ vɨdɨvɨdɨŋ daŋ iahami. ");
INSERT INTO ena_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Asɨ Iaue agaŋ Nimɨlotɨ saŋ vɨdɨvɨdɨŋ igudaci nɨbu sɨhɨm sabaŋ akuaba akuaba vihadami. Lɨdaci hulaŋ iamɨgali agɨlaŋ hulaŋ mu dɨ ibi mɨŋaiahɨben aba abavɨhadami. Hulaŋ nagaŋ nɨbu Nimɨlotɨ me uavɨhadami. Asɨ Iaue agaŋ vɨdɨvɨdɨŋ nusaŋ igudaci sɨhɨm sabaŋ akuaba akuaba vilalɨ uavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimɨlotɨ nɨbu hɨdɨlɨ maha Babelɨ haiabɨla Elekɨ haiabɨla Akatɨ haiabɨla Kalɨne haiabɨla agɨladɨ migɨladami. Haiabɨla hekɨlɨ hekɨlɨ agɨlaŋ Babilonia fɨli tɨbɨ heŋ hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","La cɨhu Babilonia fɨli tɨbɨ agadɨ vala uavɨla Asilia fɨli tɨbɨ hɨniadami. Hɨnihɨni haiabɨla limu hɨhɨle agɨladɨ avi vimi. Mu Ninive. Mu Lehobotilɨ. Mu Kala. ");
INSERT INTO ena_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Mu Lesen. Lesen haiabɨla agaŋ nɨbu Ninive haiabɨla hɨnici uci Kala haiabɨla hɨnici veci alɨhaŋ heŋ hɨniadami. Kala haiabɨla agaŋ nɨbu haiabɨla hekɨlɨ. ");
INSERT INTO ena_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","Isipɨ dɨ iamɨlɨhalinu agɨladɨ hɨdɨlɨ hɨtɨŋ hɨtɨŋ nɨbɨlaŋ nameŋ. Mu Ludi hɨdɨlɨ. Mu Anam hɨdɨlɨ. Mu Lehapɨ hɨdɨlɨ. Mu Napɨtu hɨdɨlɨ. Mu Patɨlusɨ hɨdɨlɨ. Mu Kafɨtolɨ hɨdɨlɨ. Mu Kasɨlu hɨdɨlɨ. Kasɨlu hɨdɨlɨ agadɨ latɨhiŋ ha Filisɨtia hɨdɨlɨ. ");
INSERT INTO ena_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","18","Kenan dɨ ninaŋ Cimegeŋ agadɨ ibi Saidon. Kenan agaŋ hɨmɨci nudɨ iamɨlɨhalinu agɨlaŋ hɨniavɨci hutesɨ lɨci latɨhavɨla ua hɨtɨŋ hɨtɨŋ hɨniavɨhadami. Nulɨdɨ hɨdɨlɨ nɨbɨlaŋ nameŋ. Mu Hitɨ hɨdɨlɨ. Mu Jebusɨ hɨdɨlɨ. Mu Amolɨ hɨdɨlɨ. Mu Gilɨgasɨ hɨdɨlɨ. Mu Hivɨ hɨdɨlɨ. Mu Alɨka hɨdɨlɨ. Mu Sini hɨdɨlɨ. Mu Alɨvatɨ hɨdɨlɨ. Mu Semalɨ hɨdɨlɨ. Mu Hamatɨ hɨdɨlɨ. ");
INSERT INTO ena_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kenan dɨ iamɨlɨhalinu fɨli tɨbɨ hɨniavɨhadami agadɨ valɨ limu ha Saidon haiabɨla. Limu ha Gelalɨ haiabɨla. Gelalɨ haiabɨla ha Gasa haiabɨla mikɨ hɨniadami. Valɨ limu ha Sodom haiabɨla Gomola haiabɨla Atɨma haiabɨla Seboim haiabɨla. Seboim haiabɨla nɨbu Lasa haiabɨla mikɨ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hulaŋ nɨbɨlaŋ Ham dɨ ajihalinu iamɨlɨhalinu pam. Nɨbɨlaŋ ala hɨdɨlɨ hɨtɨŋ hɨtɨŋ haiabɨla hɨtɨŋ hɨtɨŋ fɨli tɨbɨ hɨtɨŋ hɨtɨŋ hameŋ hɨniavɨhadami. Nulɨdɨ ciaŋ sɨbaŋ avi hɨtɨŋ hɨtɨŋ hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Jafetɨ dɨ isanu ha Siem. Siem nɨbu Ebelɨ hɨdɨlɨ agɨladɨ iamɨlɨnɨlu. Nɨbu avi ninaŋ limu hɨhɨle agɨladɨ havami. ");
INSERT INTO ena_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Siem dɨ ninadinu agɨladɨ ibi nameŋ. Mu Elam. Mu Asulɨ. Mu Alɨpakɨsatɨ. Mu Ludi. Mu Alam. ");
INSERT INTO ena_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Alam dɨ ninadinu agɨladɨ ibi nameŋ. Mu Usɨ. Mu Hulɨ. Mu Getelɨ. Mu Masɨ. ");
INSERT INTO ena_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Alɨpakɨsatɨ dɨ ninanu ha Sele. Sele dɨ ninanu ha Ebelɨ. ");
INSERT INTO ena_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebelɨ ninaŋ ahica havami. Mu Pelekɨ. Pelekɨ agaŋ hɨnidaci hulaŋ iamɨgali fɨli neŋ hɨniavɨhadami agɨlaŋ hɨtɨŋ hɨtɨŋ lɨhavɨmi. Pelekɨ imanu Jokɨtan. ");
INSERT INTO ena_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Jokɨtan ninadinu dɨ ibi nameŋ. Mu Alɨmodatɨ. Mu Selepɨ. Mu Hasalɨmavetɨ. Mu Jela. ");
INSERT INTO ena_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Mu Hadolam. Mu Usalɨ. Mu Dikɨla. ");
INSERT INTO ena_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Mu Obalɨ. Mu Abimaelɨ. Mu Seba. ");
INSERT INTO ena_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Mu Ofilɨ. Mu Havila. Mu Jobapɨ. Hulaŋ nɨbɨlaŋ Jokɨtan dɨ ninadinu laci. ");
INSERT INTO ena_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Jokɨtan dɨ iamɨlɨhalinu fɨli tɨbɨ hɨniavɨhadami agadɨ valɨ limu ha Mesa haiabɨla. Limu ha Sefalɨ haiabɨla. Sefalɨ haiabɨla agaŋ fɨli tɨbɨ halu daŋ halu daŋ uaiaŋ iahaiaha kɨlikɨli heŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Hulaŋ nɨbɨlaŋ Siem dɨ ajihalinu iamɨlɨhalinu pam. Nɨbɨlaŋ ala hɨdɨlɨ hɨtɨŋ hɨtɨŋ haiabɨla hɨtɨŋ hɨtɨŋ fɨli tɨbɨ hɨtɨŋ hɨtɨŋ hameŋ hɨniavɨhadami. Nulɨdɨ ciaŋ sɨbaŋ avi hɨtɨŋ hɨtɨŋ hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Nɨbɨlaŋ hɨdɨlɨ hɨtɨŋ hɨtɨŋ agadɨ ala hɨdɨlɨ sɨbaŋ nɨbu Noa. Avɨli hekɨlɨ agaŋ magɨla mɨgu fɨhalɨci hulaŋ iamɨgali agɨlaŋ iaha habɨla latɨhavɨla ua fɨli tɨbɨ hɨtɨŋ hɨtɨŋ hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Vaka sɨbaŋ hulaŋ iamɨgali agɨlaŋ ciaŋ sɨbaŋ pabiŋ laci abavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Lɨdɨŋ uaiaŋ iahaiaha kɨlikɨli heŋ hɨnihɨni hɨdavɨhadami. Hɨdahɨda uavɨla Babilonia fɨli tɨbɨ iahuavɨla fɨli abɨlɨ agadɨ igavɨla heŋ hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","La nɨbɨlaŋ nukeŋ nukeŋ abavɨmi. Alialaŋ uavɨmi. Fɨli caŋ agadɨ vivi eŋala eŋala avɨŋ hɨvɨ hɨlɨdamɨli vɨdɨvɨdɨŋ lɨhavɨm uavɨmi. Vɨdɨvɨdɨŋ lɨdɨŋ lɨba me hɨniavɨbali uavɨmi. Hameŋ abavɨla fɨli caŋ agadɨ vivi eŋalavɨdaci lɨba me hɨniavɨmi. Hɨniavɨdaci vivi nulɨdɨ hɨvɨ ulaŋ hafiavɨmi. Lɨba agɨladɨ mɨlɨm daŋ lamalama ifɨhapuhapu iahuavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Lavɨla abavɨmi. Alialaŋ uavɨmi. Haiabɨla hekɨlɨ vimɨli uavɨmi. La ulaŋ hɨvɨ hekɨlɨ vimɨli uaiaŋ susu hɨvɨ iahubali uavɨmi. Lɨci hulaŋ iamɨgali aludɨ sibɨla agadɨ igavɨla aludɨ ibi mɨŋaiahavɨbali uavɨmi. Aludɨ lahuavɨci hɨtɨŋ hɨtɨŋ hɨnimagalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","La sibɨla vihavɨdaci Asɨ Iaue agaŋ ulaŋ hɨvɨ hekɨlɨ agadɨdaŋ haiabɨla agadɨdaŋ igɨben aba mɨgami. ");
INSERT INTO ena_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Mɨga igavɨla abami. Hulaŋ iamɨgali nagɨlaŋ hɨdɨlɨ pabiŋ laci ciaŋ sɨbaŋ avi pabiŋ laci hɨnihɨni haiabɨla hekɨlɨ nagadɨ vihavadi uami. Nulɨdɨ hɨji hɨvɨ nukeŋ akuaba akuaba viben aba lavɨla ha nɨbɨlaŋ nukeŋ huaci vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","La nudɨ hɨvɨ iahuavɨla abami. Alia uami. Viaŋ cɨhu mɨguavɨla nulɨdɨ ciaŋ sɨbaŋ pabiŋ laci agadɨ mɨŋaihuihu lɨben uami. Hameŋ lɨlɨŋ nɨbɨlaŋ ciaŋ sɨbaŋ hɨtɨŋ hɨtɨŋ aba aba uavauava iahuavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Hameŋ abavɨla hɨdɨlɨ pabiŋ laci agɨladɨ mɨŋa hɨtɨŋ hɨtɨŋ lɨci sibɨla agadɨ valavɨla fɨli tɨbɨ hɨtɨŋ hɨtɨŋ hɨvɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Asɨ Iaue nukeŋ nulɨdɨ ciaŋ sɨbaŋ agadɨ mɨŋaihuihu lɨci hɨdɨlɨ pabiŋ agɨlaŋ latɨhavɨla hɨtɨŋ hɨtɨŋ uavɨla fɨli tɨbɨ mu hɨvɨ mu hɨvɨ hɨniavɨmi. Ciaŋ sɨbaŋ mɨŋaihuihu lɨmi sadaŋ haiabɨla agadɨ ibi lamavɨla abavɨmi. Babelɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Siem dɨ ninadinu ajihalinu iamɨlɨhalinu agɨladɨ ibi nameŋ. Avɨli hekɨlɨ agaŋ magɨla mɨgu fɨhalɨci hualɨ ahica uci Siem dɨ hualɨ lugɨlavɨci ua 100 iahami. Lɨci Siem agaŋ ninaŋ havami. Nudɨ ibi Alɨpakɨsatɨ. ");
INSERT INTO ena_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Lɨci hualɨ 500 udaci ninanadi limu hɨhɨle agɨladɨ avi havami. Lavɨla heŋ hɨmami. ");
INSERT INTO ena_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Alɨpakɨsatɨ iamɨnu nudɨ huhɨlɨci iaha hɨnidaci hualɨ 35 umi. Lɨci Alɨpakɨsatɨ agaŋ ninaŋ havami. Nudɨ ibi Sele. ");
INSERT INTO ena_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Lɨci hualɨ 403 udaci ninanadi limu hɨhɨle agɨladɨ avi havami. Lavɨla heŋ hɨmami. ");
INSERT INTO ena_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sele iamɨnu nudɨ huhɨlɨci iaha hɨnidaci hualɨ 30 umi. Lɨci Sele agaŋ ninaŋ havami. Nudɨ ibi Ebelɨ. ");
INSERT INTO ena_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Lɨci hualɨ 403 udaci ninanadi limu hɨhɨle agɨladɨ avi havami. Lavɨla heŋ hɨmami. ");
INSERT INTO ena_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebelɨ iamɨnu nudɨ huhɨlɨci iaha hɨnidaci hualɨ 34 umi. Lɨci Ebelɨ agaŋ ninaŋ havami. Nudɨ ibi Pelekɨ. ");
INSERT INTO ena_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Lɨci hualɨ 430 udaci ninanadi limu hɨhɨle agɨladɨ avi havami. Lavɨla heŋ hɨmami. ");
INSERT INTO ena_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelekɨ iamɨnu nudɨ huhɨlɨci iaha hɨnidaci hualɨ 30 umi. Lɨci Pelekɨ agaŋ ninaŋ havami. Nudɨ ibi Leu. ");
INSERT INTO ena_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Lɨci hualɨ 209 udaci ninanadi limu hɨhɨle agɨladɨ avi havami. Lavɨla heŋ hɨmami. ");
INSERT INTO ena_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Leu iamɨnu nudɨ huhɨlɨci iaha hɨnidaci hualɨ 32 umi. Lɨci Leu agaŋ ninaŋ havami. Nudɨ ibi Selukɨ. ");
INSERT INTO ena_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Lɨci hualɨ 207 udaci ninanadi limu hɨhɨle agɨladɨ avi havami. Lavɨla heŋ hɨmami. ");
INSERT INTO ena_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Selukɨ iamɨnu nudɨ huhɨlɨci iaha hɨnidaci hualɨ 30 umi. Lɨci Selukɨ agaŋ ninaŋ havami. Nudɨ ibi Naholɨ. ");
INSERT INTO ena_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Lɨci hualɨ 200 udaci ninanadi limu hɨhɨle agɨladɨ avi havami. Lavɨla heŋ hɨmami. ");
INSERT INTO ena_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naholɨ iamɨnu nudɨ huhɨlɨci iaha hɨnidaci hualɨ 29 umi. Lɨci Naholɨ agaŋ ninaŋ havami. Nudɨ ibi Tela. ");
INSERT INTO ena_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Lɨci hualɨ 119 udaci ninanadi limu hɨhɨle agɨladɨ avi havami. Lavɨla heŋ hɨmami. ");
INSERT INTO ena_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tela iamɨnu nudɨ huhɨlɨci iaha hɨnidaci hualɨ 70 umi. Lɨci Tela agaŋ ninaŋ limu hɨhɨle havami. Mu Abɨlam. Mu Naholɨ. Mu Halan. ");
INSERT INTO ena_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tela dɨ ninadinu ajihalinu agɨladɨ ibi nameŋ. Mu Abɨlam. Mu Naholɨ. Mu Halan. Halan agaŋ ninaŋ havami. Nudɨ ibi Lotɨ. ");
INSERT INTO ena_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Halan agaŋ nudɨ nukeŋ haiabɨla Uilɨ heŋ hɨnia hɨmami. Kalɨdia hɨdɨlɨ agɨlaŋ Uilɨ haiabɨla hɨniavɨhadami. Nudɨ iaganu Tela agaŋ hɨhi hɨnidaci hɨmami. ");
INSERT INTO ena_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abɨlam agaŋ Selai dɨ sabimi. Naholɨ agaŋ Milɨka dɨ sabimi. Milɨka dɨ Isɨka dɨ iaganɨlu Halan. ");
INSERT INTO ena_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Selai agaŋ uajɨ hɨnihɨni ninanadi ma huhɨladami. ");
INSERT INTO ena_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tela agaŋ ninaŋ nabenu Abɨlam tamaŋ dɨdaŋ ajinu Lotɨ dɨdaŋ likɨlavɨla Uilɨ haiabɨla agadɨ valavɨla uavɨmi. Abɨlam abinu nɨbu Selai. Lotɨ nɨbu Halan dɨ ninaŋ. Kenan fɨli tɨbɨ saŋ uavɨmi ala Halan haiabɨla hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Hɨniavɨdaci Tela dɨ hualɨ lugɨlavɨci ua 205 iahɨci Halan haiabɨla heŋ hɨnia hɨmami. ");
INSERT INTO ena_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Asɨ Iaue agaŋ Abɨlam dɨ abami. Nama nadɨ fɨli tɨbɨ nagadɨdaŋ nadɨ hɨdɨlɨ pam agɨladɨdaŋ valavɨla uha uami. Nadɨ isagalina imahalina agɨladɨ avi valavɨla uha uami. Uavɨla fɨli tɨbɨ mu nadɨ abalamɨben heŋ hɨniha uami. ");
INSERT INTO ena_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Viaŋ nadɨ iamɨlɨhalina agɨladɨ lɨlɨŋ iaha habɨla hɨdɨlɨ hekɨlɨ hɨniavɨbali uami. Nadɨ avi huaci lamɨlɨŋ nama ibi hekɨlɨ daŋ hɨnibanaŋ uami. Ibi hekɨlɨ daŋ hɨnihɨni hulaŋ iamɨgali hɨdɨlɨ mu mu agɨladɨ huaci lamɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Viaŋ hulaŋ iamɨgali nadɨ huaci lamavɨlalɨ agɨladɨ nulɨdɨ avi huaci lamɨben uami. Agadɨ ala hulaŋ iamɨgali nadɨ sɨbɨlɨ igavɨlalɨ agɨladɨ viaŋ nukeŋ lɨlɨŋ nɨbɨlaŋ vɨhɨlɨ igavɨbali uami. Viaŋ nasaŋ igahɨlahɨla hulaŋ iamɨgali sɨkasɨkan fɨli neŋ hɨniavɨlalɨ agɨladɨ huaci lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Lɨci Abɨlam agaŋ Asɨ Iaue dɨ ciaŋ lubiahɨlavɨla Halan haiabɨla agadɨ valavɨla umi. Umi hadɨhu heŋ Abɨlam dɨ hualɨ lugɨlavɨci ua 75 iahami. Lɨci Abɨlam nudɨ abinu Selai dɨdaŋ nudɨ isanu dɨ ninaŋ Lotɨ dɨdaŋ viavɨla ahuata hameŋ uavɨmi. Nulɨdɨ sibɨla hɨsɨŋ hulaŋ iamɨgali akuaba akuaba Halan haiabɨla hɨnihɨni vihavɨhadami agɨladɨ avi viavɨla Kenan fɨli tɨbɨ saŋ uavɨmi. Ua hɨdahɨda uavɨla Kenan fɨli tɨbɨ iahuavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Iahuavɨla hɨdahɨda uavɨla Sekem haiabɨla iahuavɨmi. Mole dɨ kɨlɨ hekɨlɨ agaŋ Sekem haiabɨla mikɨ heŋ hɨniadami. Hɨnidaci nɨbɨlaŋ uavɨla heŋ ala hɨniavɨmi. Ua hɨniavɨmi hadɨhu heŋ Kenan hɨdɨlɨ agɨlaŋ fɨli tɨbɨ heŋ hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Hɨniavɨdaci Asɨ Iaue agaŋ Abɨlam dɨ pɨŋ iahavɨla abami. Fɨli tɨbɨ nagadɨ nadɨ iamɨlɨhalina agɨlasaŋ iguben uami. Lɨci Abɨlam agaŋ Asɨ Iaue dɨ ibi mɨŋaiahɨben aba sagalɨ hɨlahɨla hɨsɨŋ lɨba vadɨm ibilami. Asɨ Iaue agaŋ nudɨ pɨŋ iahami agasaŋ igahɨlavɨla ibilami. ");
INSERT INTO ena_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","La cɨhu Abɨlam agaŋ Betelɨ haiabɨla hɨnici uci fɨli tɨbɨ halu daŋ halu daŋ uaiaŋ iahaiaha kɨlikɨli heŋ umi. Lavɨla Betelɨ haiabɨla Ai haiabɨla agɨladɨ alɨhaŋ alɨhaŋ heŋ havɨlɨ ulaŋ hafiavɨmi. Betelɨ haiabɨla agaŋ uaiaŋ mɨgumɨgu kɨlikɨli heŋ hɨniadami. Ai haiabɨla agaŋ uaiaŋ iahaiaha kɨlikɨli heŋ hɨniadami. Lavɨla Abɨlam agaŋ sagalɨ hɨlahɨla hɨsɨŋ lɨba vadɨm heŋ ibilavɨla Asɨ Iaue dɨ ibi luvɨla luvɨla nudɨ ibi mɨŋaiahami. ");
INSERT INTO ena_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","La hulaŋ iamɨgali Abɨlam ani uavɨmi agɨlaŋ hameŋ laci hameŋ laci havɨlɨ ulaŋ hafihafi hɨnihɨni uu Negevɨ fɨli tɨbɨ iahuavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","La fɨli tɨbɨ heŋ hɨniavɨdaci sɨmɨŋ akuaba akuaba apalɨ sɨbaŋ lɨci humɨgaŋ ibɨlibɨliŋ hekɨlɨ iahami. Lɨci Abɨlam agaŋ hulaŋ iamɨgali nɨbu hula hɨdavɨmi agɨlaŋ hula Isipɨ fɨli tɨbɨ hɨnihɨni saŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Uavɨla Isipɨ fɨli tɨbɨ iahuben aba mikɨ mikɨ lavɨla Abɨlam agaŋ nudɨ abinu Selai dɨ abami. Ci igɨnaŋ uami. Viaŋ nadɨ igɨlɨŋ nadɨ mugaŋ lamɨgaŋ agaŋ huaci sɨbaŋ hɨni uami. ");
INSERT INTO ena_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Hameŋ sadaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ agɨlaŋ nadɨ mavɨn igavɨbali uami. La hɨji nameŋ lamavɨbali uami. Na nudɨ iamɨgali aba abavɨbali uami. La iadɨ ifɨhɨmavɨla nadɨ valavɨci hɨnibanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Hameŋ sadaŋ nama nameŋ abɨha uami. Ha nɨbu iadɨ amu aba abɨha uami. Hameŋ abɨnaŋ nɨbɨlaŋ iadɨ huaci lamavɨla ma ifɨhɨmavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","La uavɨla Isipɨ fɨli tɨbɨ iahuavɨmi. Iahuavɨci Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ agɨlaŋ nudɨ iamɨgali agadɨ igavɨci mugaŋ lamɨgaŋ huaci sɨbaŋ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Lɨci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ hɨmamɨgɨlɨ daŋ agɨlaŋ Selai dɨ igavɨla nulɨdɨ manɨgali agadɨ abavɨmi. Iamɨgali mu mugaŋ lamɨgaŋ huaci sɨbaŋ agaŋ vevɨla hɨnidi uavɨmi. La uavɨla Selai dɨ viavɨla Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ ulaŋ hɨvɨ vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Vavehavɨci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ Selai dɨ mavɨn igavɨla Abɨlam dɨ huaci lamami. La sabaŋ sipsipɨ sabaŋ bulɨmakau sabaŋ donɨki sabaŋ kamelɨ agɨladɨ Abɨlam saŋ igumi. Sibɨla hɨsɨŋ hulaŋ iamɨgali agɨladɨ avi igumi. ");
INSERT INTO ena_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Iguavɨla Abɨlam abinu Selai dɨ sabici nudɨ iamɨgali me hɨnimi. Lɨci Asɨ Iaue agaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agasadaŋ nudɨ ulaŋ pam hɨsɨŋ agɨlasadaŋ hɨmuhɨmu hekɨlɨ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ igumi. ");
INSERT INTO ena_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","19","Lɨci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ Abɨlam saŋ ciaŋ iguci umi. Lɨci Abɨlam veci nudɨ abami. Nama akɨ saŋ iadɨ analɨ nameŋ abahanaŋ uami. Viaŋ nudɨ amunu aba abahanaŋ uami. Selai iadɨ iamɨgali aba ma abahanaŋ uami. Hameŋ lɨnaŋ viaŋ nudɨ sabicin uami. Lɨlɨŋ nɨbu iadɨ iamɨgali me hɨni uami. La abami. Nadɨ iamɨgali nan hɨnidi uami. Viavɨla ahica uhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Lavɨla nudɨ sagaŋ hɨsɨŋ hulaŋ agɨladɨ abami. Abɨlam agaŋ Isipɨ fɨli tɨbɨ neŋ hɨnimɨdɨ uami. Hameŋ abɨci Abɨlam dɨdaŋ abinu dɨdaŋ lahuavɨmi. Lahuavɨci nulɨdɨ akuaba akuaba agɨladɨ likɨlavɨla uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","2","Abɨlam nɨbu sabaŋ mu hɨdɨlɨ mu hɨdɨlɨ lɨba silɨva lɨba golɨ akuaba akuaba akape daŋ hɨniadami. La Isipɨ fɨli tɨbɨ agadɨ vala cɨhu Negevɨ fɨli tɨbɨ vehavɨmi. Nudɨ abinu dɨdaŋ nudɨ akuaba akuaba agɨladɨdaŋ viavɨla vedaci Lotɨ avi nɨbɨlaŋ hula vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ve hɨniavɨla cɨhu Abɨlam agaŋ nudɨ sibɨla hɨsɨŋ hulaŋ iamɨgali agɨlaŋ hula Negevɨ fɨli tɨbɨ valavɨla vehavɨmi. La havɨlɨ ulaŋ hafihafi hɨnihɨni veve Betelɨ haiabɨla iahavɨmi. Vaka havɨlɨ ulaŋ Betelɨ haiabɨla hɨnici uci Ai haiabɨla hɨnici veci alɨhaŋ hafiavɨmi heŋ iahavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Lavɨla Abɨlam agaŋ sagalɨ hɨlahɨla hɨsɨŋ lɨba vadɨm vaka ibilami heŋ uavɨla Asɨ Iaue dɨ ibi luvɨla luvɨla nudɨ ibi mɨŋaiahami. ");
INSERT INTO ena_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lotɨ avi Abɨlam ani vehavɨmi. Nɨbu avi sabaŋ sipsipɨ sabaŋ bulɨmakau daŋ hɨniadami. Hulaŋ iamɨgali akape avi nɨbu hula hɨdahɨda havɨlɨ ulaŋ hafihafi hɨnihɨni vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Abɨlam hula Lotɨ hula akuaba akuaba akape daŋ sadaŋ humɨsɨ avɨli akuaba akuaba agɨlasaŋ tɨbɨ mɨgavɨmi. La ahica hɨnihɨni agaŋ hɨma lɨmi. ");
INSERT INTO ena_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Hameŋ sadaŋ Lotɨ dɨ sibɨla hɨsɨŋ hulaŋ sabaŋ mu hɨdɨlɨ mu hɨdɨlɨ migɨlavɨhadami agɨlaŋ hula Abɨlam dɨ sibɨla hɨsɨŋ hulaŋ sabaŋ mu hɨdɨlɨ mu hɨdɨlɨ migɨlavɨhadami agɨlaŋ hula lamacilavɨhadami. Hadɨhu heŋ Kenan hɨdɨlɨ agɨlaŋ Pelesɨ hɨdɨlɨ agɨlaŋ avi fɨli tɨbɨ heŋ ala hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Lamacilavɨdaci Abɨlam agaŋ Lotɨ dɨ abami. Alaŋ ahica hɨdɨlɨ pam laci uami. Ahica lamacilɨmagalu uami. Aludɨ sibɨla hɨsɨŋ agɨlaŋ avi lamacilavɨmɨdɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Igɨha uami. Fɨli tɨbɨ hekɨlɨ ha hɨnidi uami. Nama iadɨ vala uavɨla fɨli tɨbɨ mu hɨvɨ hɨniha uami. Nama human sɨmi kɨlikɨli hɨvɨ uben aba lɨnaŋ viaŋ human sakalɨ kɨlikɨli hɨvɨ uben uami. Nama human sakalɨ kɨlikɨli hɨvɨ uben aba lɨnaŋ viaŋ human sɨmi kɨlikɨli hɨvɨ uben uami. ");
INSERT INTO ena_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lɨci Lotɨ agaŋ lagulamavɨla igasulami. La Jolɨdan avɨli fɨli abɨlɨ agadɨ igasulasula uu Soalɨ haiabɨla agadɨ igami. Fɨli abɨlɨ agaŋ nɨbu avɨli makaŋ akape sadaŋ huaci sɨbaŋ hɨniadami. Fɨli abɨlɨ agadɨ igɨci nɨbu Asɨ Iaue dɨ hualɨ me hɨniadami. Nɨbu avi Isipɨ fɨli tɨbɨ me hɨniadami. Hadɨhu heŋ Asɨ Iaue agaŋ Sodom haiabɨla Gomola haiabɨla agɨladɨ ma sɨbɨlɨ lamami. ");
INSERT INTO ena_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lɨci Lotɨ agaŋ Jolɨdan avɨli fɨli abɨlɨ agadɨ sɨkasɨkan vivi saŋ abami. Lavɨla Abɨlam dɨ valavɨla uaiaŋ iahaiaha kɨlikɨli heŋ umi. Uavɨla hɨtɨŋ hɨtɨŋ hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abɨlam nɨbu Kenan fɨli tɨbɨ hɨniadami. Lotɨ agaŋ haiabɨla hekɨlɨ hekɨlɨ Jolɨdan avɨli fɨli abɨlɨ caba caba hɨniavɨhadami agɨladɨ alɨhaŋ heŋ ala hɨniadami. La havɨlɨ ulaŋ agɨladɨ Sodom haiabɨla mikɨ sɨbaŋ heŋ hafiavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Hulaŋ iamɨgali haiabɨla heŋ hɨsɨŋ agɨlaŋ sɨbɨlɨ sɨbaŋ hɨniavɨhadami. Asɨ Iaue agaŋ nulɨdɨ igɨdaci nɨbɨlaŋ akuaba akuaba lusɨŋ sɨbɨlɨ sɨbɨlɨ laci vihavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lotɨ agaŋ Abɨlam dɨ vala uci Asɨ Iaue agaŋ Abɨlam dɨ abami. Nama neŋ lagulamavɨla fɨli tɨbɨ nagadɨ sɨkasɨkan igasulɨha uami. Uaiaŋ iahaiaha kɨlikɨli heŋ igasulɨha uami. Uaiaŋ mɨgumɨgu kɨlikɨli heŋ igasulɨha uami. Ium kɨlikɨli heŋ igasulɨha uami. Lakulamaŋ kɨlikɨli heŋ igasulɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Fɨli tɨbɨ sɨkasɨkan igasulɨnaŋ nagadɨ nasadaŋ nadɨ iamɨlɨhalina agɨlasadaŋ iguben uami. Igulɨŋ mufɨli mufɨli fɨli tɨbɨ nagaŋ naludɨ nukeŋ fɨli tɨbɨ hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Hɨnidaci nadɨ iamɨlɨhalina agɨladɨ huaci lamɨlɨŋ iaha habɨla hacɨŋ hɨlɨcɨ me hɨniavɨbali uami. Hulaŋ mu hacɨŋ hɨlɨcɨ huaci lugɨlɨvi lɨci uami. Ha nɨbu nadɨ iamɨlɨhalina agɨladɨ avi huaci lugɨlɨvi uami. ");
INSERT INTO ena_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Fɨli tɨbɨ sɨkasɨkan nasaŋ iguben nagadɨ nama iaha hɨdahɨda igɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Lɨci Abɨlam agaŋ nudɨ sibɨla hɨsɨŋ hulaŋ agɨlaŋ hula havɨlɨ ulaŋ agɨladɨ hivahiva vivi Hebɨlon haiabɨla uavɨmi. Uavɨla Mamɨle dɨ kɨlɨ hekɨlɨ hekɨlɨ hɨniavɨhadami heŋ havɨlɨ ulaŋ hafiavɨmi. Mamɨle dɨ kɨlɨ hekɨlɨ hekɨlɨ agɨlaŋ Hebɨlon haiabɨla mikɨ hɨniavɨhadami. Lavɨla Asɨ Iaue saŋ sagalɨ hɨlahɨla hɨsɨŋ lɨba vadɨm agadɨ heŋ ibilami. ");
INSERT INTO ena_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","9","Kedolaomelɨ nɨbu Elam fɨli tɨbɨ migɨladami. Migɨlɨdaci manɨgali limu hɨhɨle agɨlaŋ nudɨ lɨhu hɨvɨ hɨniavɨhadami. Nulɨdɨ ibi nameŋ. Mu Sodom haiabɨla hɨsɨŋ agɨladɨ manɨgali Belia. Mu Gomola haiabɨla hɨsɨŋ agɨladɨ manɨgali Bilɨsa. Mu Atɨma haiabɨla hɨsɨŋ agɨladɨ manɨgali Sinapɨ. Mu Seboim haiabɨla hɨsɨŋ agɨladɨ manɨgali Semebelɨ. Mu Bela haiabɨla hɨsɨŋ agɨladɨ manɨgali. Nɨbɨlaŋ ahuata Kedolaomelɨ dɨ lɨhu hɨvɨ pam hɨniavɨhadami. Bela haiabɨla agadɨ ibi mu Soalɨ. Kedolaomelɨ dɨ lɨhu hɨvɨ hɨniavɨdaci hualɨ human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ umi. Lɨci hualɨ mu hɨvɨ nɨbɨlaŋ nudɨ ciaŋ lulavɨmi. Lɨhavɨci cɨhu hualɨ mu hɨvɨ Kedolaomelɨ agaŋ nudɨ nagɨlihalinu ahica pam agɨlasaŋ ciaŋ iguci uci vehavɨmi. Manɨgali vehavɨmi agɨladɨ ibi nameŋ. Mu Babilonia fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali Amɨlafelɨ. Mu Elasalɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali Aliokɨ. Mu Goim hɨdɨlɨ agɨladɨ manɨgali Tidalɨ. Vehavɨci manɨgali limu ahica limu ahica nɨbɨlaŋ ala nulɨdɨ sagaŋ hɨsɨŋ hulemɨlɨ agɨlaŋ hula Asɨtelotɨkalɨnaim haiabɨla uavɨla Lefaim hɨdɨlɨ agɨlaŋ hula sagaŋ lɨbavɨla nulɨdɨ lɨvalavɨmi. Lɨvalavɨla Ham haiabɨla uavɨla Susɨ hɨdɨlɨ agɨladɨ lɨvalavɨmi. Lavɨla Kiliataim haiabɨla mikɨ uavɨla fɨli abɨlɨ heŋ Em hɨdɨlɨ agɨladɨ lɨvalavɨmi. La Holɨ hɨdɨlɨ agɨladɨ Seilɨ fɨli tɨbɨ halu daŋ halu daŋ heŋ lɨvala lahua via ua Elɨpalan haiabɨla heŋ valavɨmi. Elɨpalan haiabɨla nɨbu fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ caba heŋ hɨniadami. La cɨhu ligala Kadesɨ haiabɨla vehavɨmi. Vaka Kadesɨ haiabɨla agasaŋ Enɨmisɨpatɨ uavɨhadami. La Amalekɨ hɨdɨlɨ agɨladɨ fɨli tɨbɨ hɨdahɨda sagaŋ lɨbavɨla nulɨdɨ lɨvalavɨmi. La Amolɨ hɨdɨlɨ Hasasonɨtamalɨ haiabɨla hɨniavɨhadami agɨlaŋ hula sagaŋ lɨbavɨla nulɨdɨ lɨvalavɨmi. Sagaŋ lɨbavɨci ci lɨci cɨhu Kedolaomelɨ agaŋ nudɨ nagɨlihalinu agɨlaŋ hula uavɨla manɨgali human limu fɨhala agɨlaŋ hula sagaŋ lɨbavɨmi. Manɨgali agɨladɨ haiabɨla agɨladɨ ibi nɨbɨlaŋ nameŋ. Mu Sodom. Mu Gomola. Mu Atɨma. Mu Seboim. Mu Bela. Manɨgali human limu fɨhala agɨlaŋ nulɨdɨ sagaŋ hɨsɨŋ hulemɨlɨ agɨlaŋ hula Sidim fɨli abɨlɨ heŋ mɨgudɨba hɨniavɨmi. Detɨsi idu hekɨlɨ agaŋ heŋ ala hɨniadami. Mɨgudɨba hɨniavɨla Kedolaomelɨ ani ani agɨlaŋ hula sagaŋ lɨbɨben aba lɨhavɨmi. Lavɨla manɨgali human limu fɨhala agɨladɨ sagaŋ hɨsɨŋ hulemɨlɨ agɨlaŋ hula manɨgali limu ahica limu ahica agɨladɨ sagaŋ hɨsɨŋ hulemɨlɨ agɨlaŋ hula sagaŋ lɨbavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Sidim fɨli abɨlɨ heŋ tulɨ akape maŋa mɨlɨm daŋ agɨlaŋ hɨniavɨhadami. Heŋ ala sagaŋ lɨbavɨdaci Sodom haiabɨla hɨsɨŋ agɨladɨ manɨgali agaŋ hula Gomola haiabɨla hɨsɨŋ agɨladɨ manɨgali agaŋ hula haŋɨlɨbalu aba lɨhavɨmi. La haŋɨla haŋɨla uavɨla tulɨ maŋa mɨlɨm daŋ agɨladɨ hɨvɨ havala havala mɨguavɨmi. Manɨgali ahica pam agɨlaŋ haŋɨla fɨli halu daŋ halu daŋ heŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kedolaomelɨ agaŋ nudɨ nagɨlihalinu agɨlaŋ hula ua sagaŋ lɨbavɨla manɨgali human limu fɨhala agɨladɨ lɨvalavɨmi. La Sodom haiabɨla hɨsɨŋ agɨladɨ Gomola haiabɨla hɨsɨŋ agɨladɨ akuaba akuaba agɨladɨ sɨkasɨkan vihavɨmi. Nulɨdɨ sɨmɨŋ avi viavɨla uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lotɨ agaŋ Sodom haiabɨla hɨnidaci sagaŋ lɨbavɨmi. Lavɨla Lotɨ dɨdaŋ nudɨ akuaba akuaba agɨladɨdaŋ via uavɨmi. Lotɨ nɨbu Abɨlam isanu dɨ ninanu. ");
INSERT INTO ena_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Via uavɨdaci hulaŋ mu agaŋ sɨvɨlavɨla haŋɨla Abɨlam dɨ pɨŋ umi. Ua iahuavɨla akuaba akuaba lɨhavɨmi agasaŋ Abɨlam dɨ sulami. Abɨlam nɨbu Ibɨlu ciaŋ abadami. Nɨbu Mamɨle dɨ kɨlɨ hekɨlɨ hekɨlɨ mikɨ heŋ hɨniadami. Mamɨle nɨbu Abɨlam dɨ nagɨlinu. Nudɨ imahalinu Esɨkolɨ hula Anelɨ hula nɨbɨlaŋ avi Abɨlam dɨ nagɨlihalinu. Nɨbɨlaŋ Amolɨ hɨdɨlɨ. ");
INSERT INTO ena_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abɨlam agaŋ Lotɨ dɨ viavɨla uavɨmi agadɨ ciaŋ hɨjɨ igahɨlami. Lavɨla hulaŋ vɨdɨvɨdɨŋ daŋ nɨbu hula hɨnia hekɨlɨ lɨhavɨmi agɨlasaŋ ciaŋ iguci uci vehavɨmi. Vehavɨci nulɨdɨ lugɨlavɨci ua 318 iahami. La manɨgali limu ahica limu ahica agɨladɨ sɨvɨ uavɨla Dan haiabɨla agadɨ lɨvalavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","La hɨfɨlɨ Abɨlam agaŋ nudɨ hulaŋ vɨdɨvɨdɨŋ daŋ agɨladɨ latɨhɨci ahica hɨdɨlɨ hɨniavɨmi. Lavɨla hɨfɨlɨ heŋ ala manɨgali limu ahica limu ahica agɨlaŋ hula sagaŋ lɨbavɨla nulɨdɨ lɨvalavɨmi. Lavɨla nulɨdɨ lakulamaŋ kɨlikɨli heŋ lahulahu via ua Damasɨkusɨ haiabɨla lɨvalavɨla ua Hoba haiabɨla heŋ valavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","La manɨgali agɨlaŋ nulɨdɨ lɨvala akuaba akuaba via uavɨmi agɨladɨ cɨhu ahɨla vavehavɨmi. Abɨlam ninanu Lotɨ dɨdaŋ iamɨgali nɨbu hula hɨniavɨhadami agɨladɨdaŋ vavehavɨmi. Hulaŋ iamɨgali limu hɨhɨle agɨladɨdaŋ nulɨdɨ akuaba akuaba agɨladɨdaŋ avi cɨhu sɨkasɨkan vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abɨlam ani ani agɨlaŋ uavɨla Kedolaomelɨ agaŋ hula sagaŋ lɨbavɨla nudɨ lɨvalavɨmi. Manɨgali limu hɨhɨle Kedolaomelɨ hula hɨdavɨmi agɨlaŋ hula avi sagaŋ lɨbavɨla nulɨdɨ lɨvalavɨla cɨhu vehavɨmi. Vehavɨdaci Sodom haiabɨla hɨsɨŋ agɨladɨ manɨgali agaŋ uavɨla nulɨdɨ Save fɨli abɨlɨ heŋ igami. Fɨli abɨlɨ agadɨ ibi mu manɨgali agadɨ fɨli abɨlɨ uavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melɨkisedekɨ nɨbu Salem haiabɨla hɨsɨŋ agɨladɨ manɨgali. Nɨbu Asɨ iahua hɨvɨ hɨniadami agasaŋ sagalɨ igu igu hɨsɨŋ hulaŋ hɨniadami. Nɨbu maci agadɨdaŋ lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ Abɨlam saŋ via umi. ");
INSERT INTO ena_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Via uavɨla Abɨlam dɨ huaci lamavɨla abami. Asɨ iahua hɨvɨ hɨnilalɨ agaŋ fɨli uaiaŋ susu akuaba akuaba agɨladɨ lamami uami. Nɨbu nadɨ huaci lamɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Alaŋ nudɨ ibi mɨŋaiahɨmɨli uami. Nama nadɨ nagɨli lamavalɨ agɨlaŋ hula sagaŋ lɨbɨdalaŋ Asɨ nadɨ ahɨliahuci nulɨdɨ lɨvalahalaŋ uami. Lɨci Abɨlam agaŋ akuaba akuaba vimi agɨladɨ viavɨla human limu limu fɨhala mɨguŋ lamami. Lamɨci hɨniavɨdaci labɨlavɨla pabiŋ mɨguŋ agadɨ Melɨkisedekɨ saŋ igumi. ");
INSERT INTO ena_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Iguci cɨhu Sodom haiabɨla hɨsɨŋ agɨladɨ manɨgali agaŋ Abɨlam dɨ abami. Nama sagaŋ lɨbavɨla nulɨdɨ lɨvalavɨla akuaba akuaba vihanaŋ agɨladɨ ha viha uami. Iadɨ hulaŋ iamɨgali agɨladɨ laci iasaŋ valɨnaŋ cɨhu vehavɨm uami. ");
INSERT INTO ena_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Lɨci Abɨlam agaŋ abami. Asɨ Iaue iahua hɨvɨ hɨnilalɨ agaŋ nɨbu ala fɨli uaiaŋ susu akuaba akuaba agɨladɨ lamami uami. Hameŋ sadaŋ nudɨ ibi hɨvɨ abin uami. Hɨvɨ hekɨlɨ aba abin uami. ");
INSERT INTO ena_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Viaŋ havɨlɨ hɨcahɨca hɨsɨŋ lɨmɨn agadɨdaŋ hɨcɨ sɨgɨtɨ hahahaha hɨsɨŋ lɨmɨn agadɨdaŋ ma sɨbaŋ viben uami. Nadɨ akuaba akuaba sudɨme cɨki agɨladɨ avi ma sɨbaŋ viben uami. Lɨlɨŋ nama iadɨ nameŋ abɨmɨnaŋ uami. Viaŋ nukeŋ lɨlɨŋ Abɨlam agaŋ hulaŋ akuaba akuaba akape daŋ hɨni aba abɨmɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Iadɨ hulemɨlɨ agɨlaŋ akuaba akuaba agɨladɨ ci navalɨ uami. Viaŋ nukeŋ akuaba cɨki ma viben uami. Agadɨ ala iadɨ nagɨlihali ahica pam agɨlaŋ akuaba akuaba vihavɨbali uami. Nulɨdɨ ibi nameŋ uami. Mu Anelɨ uami. Mu Esɨkolɨ uami. Mu Mamɨle uami. ");
INSERT INTO ena_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Abɨlam agaŋ sagaŋ lɨbavɨla nulɨdɨ lɨvalavɨla Lotɨ dɨ cɨhu vave hɨnidaci Asɨ Iaue agaŋ anisɨhu me hɨvɨ iaha nudɨ abami. Abɨlam uami. Nama lɨdɨmɨnaŋ uami. Viaŋ nadɨ cɨlɨbi lavɨn me hɨnidalɨŋ nadɨ ma sɨbɨlɨ lamavɨbali uami. La nasaŋ akuaba akuaba huaci huaci akape agɨladɨ iguben uami. ");
INSERT INTO ena_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Lɨci Abɨlam agaŋ abami. Asɨ Iaue nama iadɨ Hekɨlɨ uami. Viaŋ ninanadi apalɨ uami. Nama iasaŋ ninaŋ ma igumanaŋ uami. La iasaŋ akuaba akuaba iguben aba abɨnaŋ uami. Viaŋ hɨmɨlɨŋ iadɨ hɨmamɨgɨlɨ daŋ Elieselɨ Damasɨkusɨ haiabɨla hɨsɨŋ agaŋ nɨbu iadɨ akuaba akuaba agɨladɨ vibali uami. ");
INSERT INTO ena_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Hameŋ abɨci Asɨ Iaue agaŋ Abɨlam dɨ abami. Nadɨ hɨmamɨgɨlɨ daŋ agaŋ nadɨ akuaba akuaba agɨladɨ ma vibali uami. Nadɨ ninaŋ nukeŋ agaŋ nɨbu nadɨ uvɨsɨjiŋ viavɨla nadɨ akuaba akuaba agɨladɨ avi vibali uami. ");
INSERT INTO ena_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","La Abɨlam dɨ abɨci haiabɨla ivouci nudɨ abami. Nama uaiaŋ susu hɨvɨ igaiahua lidɨ agɨladɨ igɨha uami. Nama huaci lugɨlɨvanaŋ uami. Nadɨ iamɨlɨhalina agɨlaŋ iaha habɨla lidɨ nameŋ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Lɨci Abɨlam agaŋ Asɨ Iaue dɨ ciaŋ agasaŋ hɨji vɨdɨvɨdɨŋ lamɨci Asɨ Iaue nudɨ abami. Nama hulaŋ huaci uami. ");
INSERT INTO ena_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","La Abɨlam dɨ abami. Viaŋ Asɨ Iaue uami. Fɨli tɨbɨ nagadɨ nasaŋ iguben aba abɨlɨŋ Uilɨ haiabɨla agadɨ valavɨla vehanaŋ uami. Uilɨ haiabɨla ha Kalɨdia hɨdɨlɨ agɨladɨ haiabɨla uami. Fɨli tɨbɨ nagadɨ nasaŋ igulɨŋ nadɨ nukeŋ fɨli tɨbɨ hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Lɨci Abɨlam agaŋ abami. Asɨ Iaue nama iadɨ Hekɨlɨ uami. Viaŋ nukeŋ akɨ me la igavɨla abɨben uami. Fɨli tɨbɨ nagaŋ nɨbu iadɨ fɨli tɨbɨ hɨnibali aba abɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Lɨci cɨhu Asɨ Iaue nudɨ abami. Alia iasaŋ akuaba akuaba nameŋ agɨladɨ vaveha uami. Mu sabaŋ bulɨmakau mɨgenaŋ numɨgaŋ huhɨlɨci hualɨ ahica pam ci ualɨ agadɨ vaveha uami. Mu sabaŋ meme mɨgenaŋ numɨgaŋ huhɨlɨci hualɨ ahica pam ci ualɨ agadɨ vaveha uami. Mu sabaŋ sipsipɨ muŋaŋ numɨgaŋ huhɨlɨci hualɨ ahica pam ci ualɨ agadɨ vaveha uami. La havaŋ ibɨlabi agadɨdaŋ havaŋ imɨlɨ ninaŋ agadɨdaŋ avi vaveha uami. ");
INSERT INTO ena_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Lɨci Abɨlam agaŋ akuaba akuaba agɨladɨ Asɨ Iaue saŋ vavemi. Vavevɨla sɨhɨm agɨladɨ alɨhaŋ lama ihacɨkɨlacɨkɨla limu cɨkaŋ agɨladɨ hɨtɨŋ lamami. Limu cɨkaŋ agɨladɨ hɨtɨŋ lamami. Agadɨ ala havaŋ ahica agɨladɨ ma ihacɨkɨlami. ");
INSERT INTO ena_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Lɨci pujipaji agɨlaŋ vevɨla sɨhɨm sabaŋ havaŋ agɨladɨ valɨ hɨvɨ mɨgahɨnihɨni nɨben aba lɨhavɨdaci Abɨlam agaŋ nulɨdɨ lahumi. ");
INSERT INTO ena_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","La uaiaŋ mɨgudaci Abɨlam agaŋ ani vɨdɨvɨdɨŋ hɨsɨvami. Ani hɨsɨvavɨla anisɨhu hɨvɨ igɨdaci hɨfɨlɨ hekɨlɨ me agaŋ nudɨ pɨŋ iahɨci hekɨlɨ lɨdami. ");
INSERT INTO ena_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Lɨci Asɨ Iaue agaŋ nudɨ abami. Ci igɨnaŋ uami. Nadɨ iamɨlɨhalina agɨlaŋ uavɨla hɨdɨlɨ mu agɨladɨ fɨli tɨbɨ heŋ hɨniavɨbali uami. Hɨnihɨni nulɨdɨ sibɨla hɨsɨŋ hulaŋ iamɨgali hɨniavɨbali uami. Lɨhavɨdaci nulɨdɨ sɨbɨlɨ lamalama hɨniavɨdaci hualɨ 400 ubali uami. ");
INSERT INTO ena_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Nulɨdɨ sɨbɨlɨ lamavɨbali uami. Agadɨ ala viaŋ nulɨsaŋ hɨbɨŋ vɨhɨlɨ iguben uami. Hameŋ lɨlɨŋ nadɨ iamɨlɨhalina agɨlaŋ akuaba akuaba akape agɨladɨ viavɨla fɨli tɨbɨ agadɨ valavɨla cɨhu vehavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Agadɨ ala nadɨ humɨgaŋ agaŋ simɨ hɨnidaci nama hadi hadi sɨbaŋ lavɨla hɨmɨnaŋ nadɨ haca mava hudavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Nadɨ iamɨlɨhalina agɨlaŋ ua hɨniavɨla fɨli tɨbɨ neŋ cɨhu ma vevɨhehavɨbali uami. Amolɨ hɨdɨlɨ agɨlaŋ lusɨŋ sɨbɨlɨ akape ma vihavadi uami. Igɨlɨŋ lusɨŋ sɨbɨlɨ akape vivi hɨniavɨdaci ha nulɨdɨ sɨbɨlɨ lamavɨla fɨli tɨbɨ neŋ hɨniavɨmɨdɨ aba nulɨdɨ lahulɨŋ uavɨbali uami. Lahulɨŋ uavɨdaci nadɨ iamɨlɨhalina dɨ ninanadi agɨlaŋ cɨhu neŋ vehavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Lɨci uaiaŋ mɨgua hɨfɨlɨ lɨci Abɨlam agaŋ sɨji tulɨ avɨmɨsɨ iahaiaha hɨnimi agadɨdaŋ unɨ abɨlu agadɨdaŋ anisɨhu me hɨvɨ igami. Igɨdaci sɨji agaŋ hula unɨ abɨlu agaŋ hula sɨhɨm Abɨlam nukeŋ ihacɨkɨlacɨkɨla limu lama limu lamami agɨladɨ alɨhaŋ alɨhaŋ heŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Mɨhiŋ heŋ ala Asɨ Iaue agaŋ ciaŋ mɨguavɨla Abɨlam dɨ abami. Fɨli tɨbɨ nagadɨ nadɨ iamɨlɨhalina agɨlasaŋ iguben uami. Fɨli agadɨ valɨ ha avɨli makaŋ Isipɨ fɨli tɨbɨ caba hɨnidi heŋ hɨnia uu Iufɨletisɨ avɨli makaŋ hekɨlɨ heŋ hɨnidi uami. ");
INSERT INTO ena_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Igulɨŋ Kin hɨdɨlɨ agɨladɨ fɨli tɨbɨ vihavɨbali uami. Kenasɨ hɨdɨlɨ agɨladɨ fɨli tɨbɨ vihavɨbali uami. Katɨmon hɨdɨlɨ agɨladɨ fɨli tɨbɨ vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hitɨ hɨdɨlɨ agɨladɨ fɨli tɨbɨ vihavɨbali uami. Pelesɨ hɨdɨlɨ agɨladɨ fɨli tɨbɨ vihavɨbali uami. Lefaim hɨdɨlɨ agɨladɨ fɨli tɨbɨ vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amolɨ hɨdɨlɨ agɨladɨ fɨli tɨbɨ vihavɨbali uami. Kenan hɨdɨlɨ agɨladɨ fɨli tɨbɨ vihavɨbali uami. Gilɨgasɨ hɨdɨlɨ agɨladɨ fɨli tɨbɨ vihavɨbali uami. Jebusɨ hɨdɨlɨ agɨladɨ fɨli tɨbɨ avi vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abɨlam abinu Selai agaŋ nɨbu ninanadi apalɨ hɨniadami. Selai dɨ sibɨla hɨsɨŋ iamɨgali nudɨ ibi Hega. Hega nɨbu Isipɨ fɨli tɨbɨ hɨsɨŋ iamɨgali. ");
INSERT INTO ena_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Selai agaŋ Abɨlam dɨ abami. Nama igɨlanaŋ uami. Asɨ Iaue agaŋ lɨci viaŋ ninanadi ma huhɨlɨlan uami. Nama uavɨla iadɨ sibɨla hɨsɨŋ iamɨgali agaŋ hula hɨdɨha uami. Lɨnaŋ nɨbu akua iasaŋ ninaŋ huhɨlɨbali uami. Lɨci Abɨlam agaŋ abinu Selai dɨ ciaŋ agadɨ lubiahɨlami. ");
INSERT INTO ena_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Lɨci Selai agaŋ nudɨ sibɨla hɨsɨŋ iamɨgali Hega dɨ viavɨla Abɨlam saŋ iguci nudɨ iamɨgali me hɨniadami. Hadɨhu heŋ Abɨlam Kenan fɨli tɨbɨ hɨnidaci hualɨ human limu limu fɨhala ci umi. ");
INSERT INTO ena_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Lɨci Abɨlam agaŋ Hega hula hɨnici Hega agaŋ humɨgaŋ ahɨlami. Humɨgaŋ ahɨlami agadɨ igavɨla viaŋ iamɨgali huaci uavɨla Selai dɨ sɨbɨlɨ iga iga nudɨ lɨhu hɨvɨ ma hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Lɨdaci Selai agaŋ Abɨlam dɨ abami. Amɨŋ nama ala lɨdanaŋ nɨbu iadɨ sɨbɨlɨ igɨlalɨ uami. Viaŋ nukeŋ iadɨ sibɨla hɨsɨŋ iamɨgali agadɨ nasaŋ iguacin uami. Agadɨ ala nɨbu humɨgaŋ ahɨlalɨ agadɨ igavɨla iadɨ sɨbɨlɨ igɨlalɨ uami. Hameŋ sadaŋ Asɨ Iaue agaŋ aludɨ ciaŋ hihɨlam uami. ");
INSERT INTO ena_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Lɨci Abɨlam agaŋ Selai dɨ abami. Ci igɨnaŋ uami. Hega nɨbu nadɨ sibɨla hɨsɨŋ iamɨgali uami. Nama manɨgali hɨniavɨla nudɨ akuaba lɨben aba ha hameŋ laci lɨha uami. Lɨci Selai agaŋ Hega dɨ sɨbɨlɨ lamɨci Hega agaŋ haŋɨla umi. ");
INSERT INTO ena_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Haŋɨla Solɨ haiabɨla hɨbɨ pɨlɨ heŋ uavɨla fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ hɨdahɨda avɨli vubɨlɨm daŋ vubɨlɨm daŋ iahaiaha hɨniadami heŋ ua iahumi. Iahua hɨnidaci Asɨ Iaue dɨ ciaŋ hali hɨsɨŋ agaŋ nudɨ pɨŋ iahami. ");
INSERT INTO ena_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Iahavɨla nudɨ abami. Hega uami. Nama Selai dɨ sibɨla hɨsɨŋ iamɨgali uami. Nama abeŋ hɨnia vevɨla cɨhu abeŋ uben aba lɨdanaŋ uami. Lɨci Hega abami. Viaŋ iadɨ manɨgali Selai dɨ vala haŋɨla ven uami. ");
INSERT INTO ena_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Lɨci Asɨ Iaue dɨ ciaŋ hali hɨsɨŋ agaŋ abami. Nama cɨhu uavɨla Selai dɨ lɨhu hɨvɨ pam hɨniha uami. ");
INSERT INTO ena_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Viaŋ lɨlɨŋ nadɨ iamɨlɨhalina agɨlaŋ iaha habɨlavɨci hulaŋ mu nulɨdɨ lugɨlɨci ma ua iahubali uami. ");
INSERT INTO ena_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ci igɨnaŋ uami. Nama humɨgaŋ daŋ hɨniavɨla ninaŋ huhɨlɨbanaŋ uami. Asɨ Iaue agaŋ Selai nadɨ sɨbɨlɨ lamɨlalɨ agasaŋ igahɨlalɨ uami. Hameŋ sadaŋ ninaŋ agadɨ ibi lamavɨla abɨha uami. Isɨmaelɨ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Nadɨ ninaŋ agaŋ nɨbu sabaŋ donɨki saua hɨsɨŋ me hɨnibali uami. La hulaŋ sɨkasɨkan agɨladɨ nagɨli lamɨdaci hɨbɨŋ nudɨ avi nagɨli lamavɨbali uami. La nɨbu nudɨ hɨdɨlɨ pam agɨlaŋ hula huaci ma hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Lɨci Hega agaŋ Asɨ Iaue abami agasaŋ hɨji lamavɨla abami. Viaŋ Asɨ iadɨ igɨlalɨ agadɨ ci igin uami. La ibi mu lamavɨla abami. Nama Asɨ iadɨ igɨlanaŋ agaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","La nusaŋ ala hulaŋ agɨlaŋ avɨli sɨmɨ tulɨ agadɨ ibi lamavɨla abavɨhadami. Lahailoi uavɨhadami. Avɨli sɨmɨ tulɨ agaŋ Kadesɨ haiabɨla hɨnici ui Beletɨ haiabɨla hɨnici ve alɨhaŋ heŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","La cɨhu Hega agaŋ Abɨlam dɨ ninaŋ huhɨlɨci Abɨlam agaŋ nudɨ ibi lamavɨla abami. Isɨmaelɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hadɨhu Abɨlam dɨ hualɨ lugɨlavɨci ua 86 iahami. ");
INSERT INTO ena_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abɨlam dɨ hualɨ lugɨlavɨci ua 99 iahɨci Asɨ Iaue agaŋ nudɨ pɨŋ cɨhu iahavɨla abami. Viaŋ Asɨ vɨdɨvɨdɨŋ hekɨlɨ daŋ uami. Nama iadɨ hɨji agadɨ pam lubiahɨlavɨla hugɨ apalɨ hɨniha uami. ");
INSERT INTO ena_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Viaŋ ciaŋ mɨguavɨla nadɨ iamɨlɨhalina agɨladɨ lɨlɨŋ iaha habɨla akape sɨbaŋ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Lɨci Abɨlam agaŋ Asɨ dɨ ibi mɨŋaiahɨben aba fɨli hɨvɨ sɨkasɨkan mɨgavɨla ipalɨci mɨguci ani valɨ hɨnimi. Lɨci Asɨ agaŋ nudɨ abami. ");
INSERT INTO ena_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Ci igɨnaŋ uami. Viaŋ ciaŋ mɨguavɨla nadɨ abɨben uami. Nadɨ iamɨlɨhalina agɨlaŋ iaha habɨla hɨdɨlɨ akape hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Hameŋ sadaŋ malɨciŋ nadɨ ibi Abɨlam hɨma uami. Nadɨ ibi Ebɨlam uami. Viaŋ lɨlɨŋ nama hulaŋ iamɨgali iaha habɨla hɨdɨlɨ akape hɨniavɨbali agɨladɨ iamɨlɨnɨlu hɨnibanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Viaŋ nukeŋ ala lɨlɨŋ iamɨlɨhalina agɨlaŋ iaha habɨlavɨla latɨha hɨdɨlɨ akape hɨniavɨbali uami. Hɨniavɨdaci nulɨdɨ hulaŋ limu hɨhɨle agɨlaŋ manɨgali hɨnihɨni fɨli tɨbɨ mu mu agɨladɨ migɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Viaŋ ciaŋ mɨguavɨla nadɨdaŋ nadɨ iamɨlɨhalina agɨladɨdaŋ abɨben uami. Ciaŋ mɨguavɨla abɨben agaŋ mufɨli mufɨli hameŋ laci hɨnibali uami. Ciaŋ mɨguavɨla abɨben agaŋ nɨbu nameŋ uami. Viaŋ nadɨ Asɨ hɨniben uami. Nadɨ iamɨlɨhalina agɨladɨ Asɨ avi hɨniben uami. ");
INSERT INTO ena_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nama Kenan fɨli tɨbɨ neŋ ihɨlɨŋ hɨnidanaŋ uami. Agadɨ ala fɨli tɨbɨ nagadɨ nasadaŋ nadɨ iamɨlɨhalina mufɨli mufɨli iahavɨbali agɨlasadaŋ iguben uami. Igulɨŋ fɨli tɨbɨ nagaŋ mufɨli mufɨli naludɨ fɨli tɨbɨ sɨbaŋ hɨnibali uami. Lɨdaci viaŋ nadɨ iamɨlɨhalina agɨladɨ Asɨ hɨniben uami. ");
INSERT INTO ena_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","La Asɨ agaŋ Ebɨlam dɨ abami. Viaŋ ciaŋ mɨguavɨla nadɨdaŋ nadɨ iamɨlɨhalina ani ani agɨladɨdaŋ abɨben uami. Ciaŋ mɨguavɨla abɨben agasaŋ igahɨlavɨla hadi sɨbɨlɨ ihalahɨhalaŋ uami. Lɨlaŋ mufɨli mufɨli nadɨ iamɨlɨhalina agɨlaŋ avi viaŋ ciaŋ mɨguavɨla abɨben agasaŋ igahɨlahɨla hadi sɨbɨlɨ ihalahavɨbali uami. Hulaŋ sɨkasɨkan namɨlaŋ hula hɨniavɨlalɨ agɨladɨ hadi sɨbɨlɨ ihalahɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","13","Ninaŋ huhɨlavɨdaci uaiaŋ human limu fɨhala human limu pabiŋ cɨjɨŋ uci nulɨdɨ hadi sɨbɨlɨ ihalahɨhalaŋ uami. Naludɨ sibɨla hɨsɨŋ iamɨgali agɨlaŋ naludɨ ulaŋ hɨvɨ hɨnihɨni ninaŋ huhɨlavɨdaci uaiaŋ human limu fɨhala human limu pabiŋ cɨjɨŋ uci nulɨdɨ hadi sɨbɨlɨ ihalahɨhalaŋ uami. Hɨdɨlɨ mu mu agɨladɨ hulaŋ hɨhɨle anɨm hɨlɨcɨ hɨvɨ lavɨdalaŋ naludɨ sibɨla hɨsɨŋ hulaŋ hɨniavɨlalɨ agɨladɨ avi hadi sɨbɨlɨ ihalahɨhalaŋ uami. Hulaŋ sɨkasɨkan agɨladɨ hadi sɨbɨlɨ ihalahɨhalaŋ uami. Hadi sɨbɨlɨ ihalahavɨla viaŋ ciaŋ mɨguavɨla naludɨ abɨben agasaŋ igahɨlɨbalaŋ uami. Hameŋ laci hameŋ laci hadi sɨbɨlɨ ihalahalaha viovio ciaŋ mɨguavɨla abɨben agasaŋ igahɨlahɨla hɨnibalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Hulaŋ mu nudɨ hadi sɨbɨlɨ ihalahalaha saŋ abavɨci valavɨla ha nɨbu viaŋ ciaŋ mɨguavɨla abɨben agadɨ lulɨbali uami. Hulaŋ hameŋ agaŋ nudɨ hɨdɨlɨ pam agɨlaŋ hula hɨnimɨdɨ uami. Nudɨ lahuavɨci um uami. ");
INSERT INTO ena_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","La Asɨ agaŋ Ebɨlam dɨ cɨhu abami. Nama abina dɨ ibi Selai aba abɨmɨnaŋ uami. Nudɨ ibi Sela aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Viaŋ nudɨ huaci lamɨlɨŋ nɨbu nadɨ ninaŋ huhɨlɨbali uami. Lɨci nudɨ iamɨlɨhalinu agɨlaŋ iaha habɨla hɨdɨlɨ akape hɨniavɨbali uami. Lɨhavɨci nulɨdɨ hulaŋ limu hɨhɨle agɨlaŋ manɨgali hɨnihɨni fɨli tɨbɨ mu mu agɨladɨ migɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Lɨci Ebɨlam agaŋ Asɨ dɨ ibi mɨŋaiahɨben aba fɨli hɨvɨ sɨkasɨkan mɨgavɨla ipalɨci mɨguci ani valɨ hɨnihɨni hɨji hɨvɨ nameŋ abami. Hulaŋ mu numɨgaŋ nudɨ huhɨlɨci iaha hɨnidaci hualɨ 100 ci ualɨ agaŋ nɨbu huaci ninaŋ havɨvi uami. Ha hɨma uami. Sela avi hameŋ laci ala uami. Numɨgaŋ nudɨ huhɨlɨci iaha hɨnidaci hualɨ 90 ci ualɨ uami. Nɨbu huaci ninaŋ huhɨlɨvi uami. Han avi hɨma uami. Hɨji hameŋ igahɨlavɨla humɨgaŋ hɨvɨ lɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Lavɨla Asɨ dɨ abami. Nama Isɨmaelɨ dɨ huaci valɨnaŋ iadɨ uvɨsɨjiŋ viavɨla akuaba akuaba vibali uami. ");
INSERT INTO ena_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Lɨci Asɨ abami. Eke uami. Nadɨ iamɨgali Sela ninaŋ huhɨlɨci nudɨ ibi Aisakɨ aba abɨha uami. Lɨnaŋ viaŋ ciaŋ mɨguavɨla nudɨdaŋ nudɨ iamɨlɨhalinu agɨladɨdaŋ abɨben uami. Ciaŋ mɨguavɨla abɨben agaŋ mufɨli mufɨli hameŋ laci hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Nama Isɨmaelɨ dɨ huaci lamalama saŋ iadɨ abɨnaŋ sadaŋ nudɨ huaci lamɨben uami. Viaŋ nudɨ huaci lamɨlɨŋ ninanadi havɨci ninanadi akape iaha habɨla hɨdɨlɨ hekɨlɨ hɨniavɨbali uami. La nudɨ ninaŋ human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ agɨlaŋ iahavɨla manɨgali hɨniavɨbali uami. Viaŋ nukeŋ nudɨ hɨdɨlɨ agadɨ lɨlɨŋ iaha hɨdɨlɨ hekɨlɨ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Agadɨ ala hualɨ pabiŋ uci hualɨ mu agadɨ avaŋ nameŋ hɨvɨ ala Sela agaŋ Aisakɨ dɨ huhɨlɨbali uami. Huhɨlɨci viaŋ ciaŋ mɨguavɨla nudɨ abɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Asɨ agaŋ ciaŋ abɨci ci lɨci Ebɨlam dɨ vala umi. ");
INSERT INTO ena_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","Lɨci uaiaŋ heŋ laci ala Ebɨlam agaŋ Asɨ dɨ ciaŋ agadɨ lubiahɨlavɨla ninanu Isɨmaelɨ dɨ hadi sɨbɨlɨ ihalahami. Hadɨhu Isɨmaelɨ dɨ hualɨ lugɨlavɨci ua human limu limu fɨhala hɨcɨ limu ahica pam cɨjɨŋ iahami. La hulaŋ nɨbu hula hɨniavɨhadami agɨladɨ hadi sɨbɨlɨ ihalahami. Nudɨ sibɨla hɨsɨŋ iamɨgali agɨlaŋ ninaŋ huhɨlavɨdaci sibɨla hɨsɨŋ hulaŋ hɨniavɨhadami agɨladɨ hadi sɨbɨlɨ ihalahami. Hɨdɨlɨ mu agɨladɨ anɨm hɨlɨcɨ hɨvɨ lavɨdaci nudɨ sibɨla hɨsɨŋ hulaŋ hɨniavɨhadami agɨladɨ hadi sɨbɨlɨ ihalahami. Lavɨla nudɨ nukeŋ hadi sɨbɨlɨ agadɨ avi ihalahami. Hadɨhu nudɨ hualɨ lugɨlavɨci ua 99 iahami. ");
INSERT INTO ena_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","La mu tɨbɨ Ebɨlam agaŋ Mamɨle dɨ kɨlɨ hekɨlɨ hekɨlɨ hɨniavɨhadami heŋ hɨnidaci Asɨ Iaue agaŋ nudɨ pɨŋ iahami. Uaiaŋ vɨdɨvɨdɨŋ sɨbaŋ hɨlɨdaci Ebɨlam agaŋ nudɨ havɨlɨ ulaŋ hɨbɨ ivu ivu heŋ mɨgahɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","3","Mɨgahɨnia igoua igɨci hulaŋ ahica pam agɨlaŋ lagulama hɨniavɨmi. Lagulama hɨniavɨdaci Ebɨlam agaŋ nudɨ havɨlɨ ulaŋ agadɨ valavɨla haŋɨla haŋɨla nulɨdɨ pɨŋ umi. Uavɨla nulɨdɨ ibi mɨŋaiahɨben aba fɨli hɨvɨ mɨgalɨfɨlɨbavɨla abami. Hulaŋ hekɨlɨ hekɨlɨ uami. Viaŋ naludɨ sibɨla hɨsɨŋ hulaŋ uami. Iadɨ igavɨla hɨjɨŋalavɨla ha iadɨ ulaŋ hɨvɨ vehalaŋ uami. Namɨlaŋ iadɨ ulaŋ agadɨ lɨvalavɨla umɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Viaŋ hulaŋ mu dɨ abɨlɨŋ avɨli vaveci naludɨ hɨcɨ husɨbalaŋ uami. Husavɨla kɨlɨ hekɨlɨ nagadɨ lɨhu hɨvɨ mɨgahɨnia alusɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Heŋ alusɨsɨ hɨnidalaŋ viaŋ nalusaŋ sɨmɨŋ cɨki igulɨŋ navɨla humɨgaŋ laguavɨla heŋ uhalaŋ uami. Namɨlaŋ iadɨ ulaŋ hɨvɨ velaŋ sadaŋ viaŋ naludɨ ahɨliahuben uami. Viaŋ naludɨ sibɨla hɨsɨŋ hulaŋ uami. Lɨci nudɨ abavɨmi. Ha huaci uavɨmi. Nama nukeŋ abɨnaŋ hameŋ ala lɨha uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Lɨhavɨci Ebɨlam agaŋ nudɨ havɨlɨ ulaŋ heŋ lɨhalɨha uavɨla abinu Sela dɨ abami. Maci huaci sɨbaŋ agadɨ hunaŋ hɨvɨ ahica pam tɨbɨ liciavɨla mɨŋamɨjinaŋ mɨguci eŋalavɨla hɨlavɨheha uami. ");
INSERT INTO ena_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","La Ebɨlam agaŋ haŋɨla haŋɨla uavɨla sabaŋ bulɨmakau ninaŋ huaci sɨbaŋ agadɨ vimi. Viavɨla nudɨ sibɨla hɨsɨŋ hulaŋ agasaŋ iguci ifɨhɨma vɨhavɨhevɨla hɨlami. ");
INSERT INTO ena_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Hɨlɨci sabaŋ bulɨmakau hɨlɨcɨ hɨlɨcɨ agɨlaŋ lɨhuavɨci ci lɨci sabaŋ bulɨmakau hɨlɨcɨ hɨlɨcɨ agɨladɨdaŋ amaŋ mɨtɨ agadɨdaŋ vimi. Viavɨla amaŋ mɨtɨ hɨsi iajɨ me agadɨ avi via vavevɨla hulaŋ ahica pam agɨlasaŋ igumi. Iguci nana hɨniavɨdaci Ebɨlam agaŋ kɨlɨ agadɨ lɨhu hɨvɨ nulɨdɨ mikɨ heŋ lagulama hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Navɨci ci lɨci Ebɨlam dɨ abavɨmi. Nadɨ abina Sela abeŋ hɨnidi uavɨmi. Lɨhavɨci Ebɨlam abami. Nɨbu havɨlɨ uleŋ muji adan hɨnidi uami. ");
INSERT INTO ena_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Lɨci nulɨdɨ hulaŋ mu agaŋ abami. Hualɨ mu adeŋ abina Sela agaŋ ninaŋ huhɨlavɨla hɨnidaci viaŋ cɨhu veben uami. Hulaŋ agaŋ havɨlɨ ulaŋ agadɨ huligala hɨnihɨni abɨdaci Sela agaŋ havɨlɨ uleŋ muji hɨbɨ ivu ivu hɨvɨ hɨnihɨni igahɨlami. ");
INSERT INTO ena_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ebɨlam hula Sela hula ci hadi hadi sɨbaŋ lɨhavɨmi. Sela agaŋ husɨŋ hɨbɨ hɨnihɨni agadɨ ci valami. ");
INSERT INTO ena_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","La humɨgaŋ hɨvɨ lɨnilɨni hɨji hɨvɨ nameŋ abami. Viaŋ ci hadi hadi sɨbaŋ lin uami. Iadɨ hulaŋ agaŋ avi ci hadi hadi sɨbaŋ li uami. Akɨ me la viaŋ iadɨ hulaŋ hula hɨnihɨni saŋ hɨjɨŋalavin uami. ");
INSERT INTO ena_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Lɨci Asɨ Iaue agaŋ Ebɨlam dɨ abami. Sela akɨ saŋ lɨniavɨla nameŋ abi uami. Viaŋ ci hadi hadi sɨbaŋ lin sadaŋ akɨ me la ninaŋ huhɨlɨben aba abi uami. ");
INSERT INTO ena_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ci igɨnaŋ uami. Viaŋ Asɨ Iaue uami. Akuaba akuaba halu me hɨniavɨlalɨ agɨladɨ igɨlɨŋ halu me ma hɨniavɨlalɨ uami. Viaŋ avaŋ ci lamin uami. Hualɨ mu adeŋ Sela agaŋ ninaŋ huhɨlavɨla hɨnidaci viaŋ cɨhu veben uami. ");
INSERT INTO ena_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Lɨci Sela lɨdavɨla analɨ abami. Viaŋ ma lɨnin uami. Lɨci abami. Amɨŋ abin uami. Nama lɨninaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","La hulaŋ ahica pam agɨlaŋ ubalu aba lɨhavɨci Ebɨlam agaŋ nulɨdɨ via ua hɨbɨ cina lamɨben aba nɨbɨlaŋ hula umi. Uavɨla lagulamavɨla Sodom haiabɨla agadɨ igamɨgua igavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Lɨhavɨci Asɨ Iaue agaŋ hɨji nameŋ lamami. Viaŋ akuaba akuaba lɨben aba lin agasaŋ Ebɨlam dɨ mɨŋasɨvɨlɨmagaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Nudɨ iamɨlɨhalinu agɨlaŋ iaha habɨlavɨla hɨdɨlɨ hekɨlɨ vɨdɨvɨdɨŋ daŋ hɨniavɨbali uami. Viaŋ Ebɨlam saŋ igahɨlahɨla hulaŋ iamɨgali hɨdɨlɨ mu mu sɨkasɨkan fɨli neŋ hɨniavɨlalɨ agɨladɨ huaci lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Viaŋ ciaŋ mɨguavɨla nudɨ ci abacin uami. Lɨlɨŋ nudɨ ninanadinu ajihalinu agɨlasaŋ iadɨ ciaŋ vɨdɨvɨdɨŋ agadɨ abɨdaci lubiahɨlavɨbali uami. La huaci hɨnihɨni iadɨ ciaŋ lubiahɨlahɨla sibɨla huaci huaci vihavɨbali uami. Lɨhavɨdaci viaŋ nudɨ hɨvɨ akuaba akuaba lɨben aba ciaŋ mɨguavɨla abacin hameŋ ala lɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Lavɨla Asɨ Iaue agaŋ Ebɨlam dɨ abami. Sodom haiabɨla hɨsɨŋ Gomola haiabɨla hɨsɨŋ agɨlaŋ lusɨŋ sɨbɨlɨ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ vihavɨdaci hulaŋ iamɨgali limu hɨhɨle agɨlaŋ iadɨ abavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Hameŋ sadaŋ viaŋ mɨguavɨla hulaŋ iamɨgali lusɨŋ sɨbɨlɨ hameŋ vihavɨlalɨ agɨladɨ igɨben uami. Ciaŋ hɨjɨ igahɨlɨlan ha amɨŋ ua analɨ agadɨ sɨhɨvia igɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Lɨci cɨhu hulaŋ ahica agɨlaŋ Sodom haiabɨla uavɨmi. Uavɨdaci Ebɨlam agaŋ Asɨ Iaue hula lagulama hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","La Ebɨlam agaŋ Asɨ Iaue dɨ mikɨ pɨŋ uavɨla nudɨ abami. Nama hulaŋ iamɨgali sɨbɨlɨ sɨbɨlɨ agɨladɨ sɨbɨlɨ lamɨbavɨla hulaŋ iamɨgali huaci huaci agɨladɨdaŋ sɨbɨlɨ lamɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Hulaŋ iamɨgali huaci huaci 50 agɨlaŋ haiabɨla heŋ hɨniavɨdaci nulɨdɨdaŋ hulaŋ iamɨgali sɨbɨlɨ sɨbɨlɨ agɨladɨdaŋ sɨbɨlɨ lamɨbanaŋ uami. Nama hulaŋ iamɨgali huaci huaci 50 agɨlasaŋ igahɨlavɨla haiabɨla agadɨ valɨnaŋ huaci hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Hameŋ lɨmɨnaŋ sɨbaŋ uami. Nama hulaŋ iamɨgali fɨli neŋ hɨniavɨlalɨ agɨladɨ ciaŋ hihɨlɨlanaŋ uami. Hihɨlɨdanaŋ huaci laci hɨniavɨlalɨ uami. La hulaŋ iamɨgali sɨbɨlɨ sɨbɨlɨ agɨladɨ ifɨhɨmɨben aba hulaŋ iamɨgali huaci huaci agɨladɨdaŋ ma ifɨhɨmɨlanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Lɨci Asɨ Iaue agaŋ abami. Viaŋ igɨlɨŋ hulaŋ iamɨgali huaci huaci 50 agɨlaŋ Sodom haiabɨla heŋ hɨniavɨdaci nulɨsaŋ igahɨlavɨla haiabɨla agadɨ valɨlɨŋ huaci hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Lɨci Ebɨlam agaŋ cɨhu abami. Iadɨ Hekɨlɨ uami. Viaŋ ibi apalɨ uami. Nama iadɨ ciaŋ mu mu agɨlasaŋ humɨgaŋ vɨhɨlɨ vimɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","La hulaŋ iamɨgali huaci huaci 50 agɨlaŋ ma hɨniavɨdaci human limu fɨhala agasaŋ tɨbɨ mɨga hulaŋ iamɨgali huaci huaci 45 agɨlaŋ laci haiabɨla heŋ hɨniavɨdaci nulɨdɨ sɨbɨlɨ lamɨbanaŋ uami. Lɨci Asɨ Iaue agaŋ abami. Viaŋ igɨlɨŋ hulaŋ iamɨgali huaci huaci 45 agɨlaŋ hɨniavɨdaci haiabɨla agadɨ ma sɨbɨlɨ lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Lɨci Ebɨlam agaŋ cɨhu abami. Hulaŋ iamɨgali huaci huaci 40 agɨlaŋ hɨniavɨdaci ha akɨ lɨbanaŋ uami. Lɨci Asɨ Iaue abami. Viaŋ igɨlɨŋ hulaŋ iamɨgali huaci huaci 40 agɨlaŋ hɨniavɨdaci nulɨsaŋ igahɨlavɨla haiabɨla agadɨ ma sɨbɨlɨ lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Lɨci Ebɨlam abami. Iadɨ Hekɨlɨ uami. Viaŋ cɨhu ciaŋ cɨki abɨben agasaŋ iasaŋ humɨgaŋ vɨhɨlɨ vimɨnaŋ uami. Hulaŋ iamɨgali huaci huaci 30 agɨlaŋ hɨniavɨdaci ha akɨ lɨbanaŋ uami. Lɨci Asɨ Iaue abami. Viaŋ igɨlɨŋ hulaŋ iamɨgali huaci huaci 30 agɨlaŋ hɨniavɨdaci haiabɨla agadɨ ma sɨbɨlɨ lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Lɨci Ebɨlam cɨhu abami. Iadɨ Hekɨlɨ uami. Nama iadɨ ciaŋ mu mu agɨlasaŋ humɨgaŋ vɨhɨlɨ vimɨnaŋ uami. Hulaŋ iamɨgali huaci huaci 20 agɨlaŋ hɨniavɨdaci ha akɨ lɨbanaŋ uami. Lɨci Asɨ Iaue abami. Viaŋ igɨlɨŋ hulaŋ iamɨgali huaci huaci 20 agɨlaŋ hɨniavɨdaci nulɨsaŋ igahɨlavɨla haiabɨla agadɨ ma sɨbɨlɨ lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Lɨci Ebɨlam cɨhu abami. Iadɨ Hekɨlɨ uami. Viaŋ ciaŋ sijaŋ cɨki abɨben agasaŋ iasaŋ humɨgaŋ vɨhɨlɨ vimɨnaŋ uami. Hulaŋ iamɨgali huaci huaci human limu limu fɨhala agɨlaŋ hɨniavɨdaci ha akɨ lɨbanaŋ uami. Lɨci Asɨ Iaue abami. Viaŋ igɨlɨŋ hulaŋ iamɨgali huaci huaci human limu limu fɨhala agɨlaŋ hɨniavɨdaci nulɨsaŋ igahɨlavɨla haiabɨla agadɨ ma sɨbɨlɨ lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","La Asɨ Iaue agaŋ Ebɨlam hula ciaŋ abavɨci ci lɨci cɨhu umi. Udaci Ebɨlam agaŋ nudɨ havɨlɨ ulaŋ heŋ cɨhu vemi. ");
INSERT INTO ena_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Lotɨ agaŋ Sodom haiabɨla agadɨ lua madɨŋ madɨŋ uavɨla hɨbɨ ivu ivu mɨgudɨba hɨnihɨni fipɨ heŋ mɨgahɨnimi. Mɨgahɨnidaci hɨfɨlɨdaŋ Asɨ dɨ ciaŋ hali hɨsɨŋ ahica agɨlaŋ Ebɨlam dɨ valavɨla vehavɨmi. Vehavɨdaci Lotɨ agaŋ nulɨdɨ igavɨla iaha uavɨla nulɨdɨ ibi mɨŋaiahɨben aba lɨmi. La nulɨdɨ hɨcɨ mikɨ pɨŋ hɨvɨ mɨgalɨfɨlɨbavɨla nudɨ hali agadɨ fɨli hɨvɨ lɨbɨlɨvami. ");
INSERT INTO ena_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","La abami. Hulaŋ hekɨlɨ hekɨlɨ uami. Viaŋ naludɨ sibɨla hɨsɨŋ hulaŋ uami. Ahica namɨlaŋ iadɨ ulaŋ hɨvɨ vehalaŋ uami. Velaŋ abɨlɨŋ iadɨ sibɨla hɨsɨŋ hulaŋ agɨlaŋ naludɨ hɨcɨ husavɨci iadɨ ulaŋ hɨvɨ hɨsɨvɨhalaŋ uami. La hɨnilaŋ mɨŋalahɨci cimɨdaŋ sɨbaŋ huaci iaha ubalaŋ uami. Lɨci abavɨmi. Hɨma uavɨmi. Alaŋ ahica mɨgudɨba hɨnihɨni fipɨ neŋ hɨsɨvɨbalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Lɨhavɨci Lotɨ agaŋ hulaŋ ahica agɨlasaŋ vɨdɨvɨdɨŋ hɨnici nudɨ ulaŋ hɨvɨ uavɨmi. Uavɨci Lotɨ agaŋ nudɨ sibɨla hɨsɨŋ hulaŋ agɨladɨ abɨci maci sakɨvakɨva agadɨdaŋ akuaba akuaba sɨmɨŋ huaci huaci agɨladɨdaŋ viavɨla hɨla sɨhuva lamavɨmi. Lɨhavɨci hulaŋ ahica agɨlaŋ navɨmi. ");
INSERT INTO ena_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Navɨla ani ma hɨsɨvɨmaŋ lɨhavɨdaci hulaŋ Sodom haiabɨla hɨsɨŋ agɨlaŋ vevɨla ulaŋ agadɨ haŋala hudavɨmi. Hulaŋ mɨnibɨlɨ hulaŋ hadi hadi agɨlaŋ sɨkasɨkan hameŋ vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Vevɨla Lotɨ dɨ ula ula abavɨmi. Hulaŋ ahica nadɨ ulaŋ hɨvɨ vehaviemi agɨlaŋ abeŋ hɨniavadi uavɨmi. Abɨnaŋ haiabɨla ivavehavɨm uavɨmi. Ivavehavɨci alaŋ hulaŋ masa masa nukeŋ lusɨŋ sɨbɨlɨ vibalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Hameŋ abavɨci Lotɨ agaŋ haiabɨla ivouavɨla hɨbɨ sɨhɨvia sɨbaŋ lɨbami. ");
INSERT INTO ena_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Lɨbavɨla nulɨdɨ mavɨn ciaŋ ciaŋ abami. Iadɨ isagali imahali me namɨlaŋ uami. Lusɨŋ sɨbɨlɨ hameŋ agadɨ vimɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ci igɨlaŋ uami. Viaŋ iadɨ nadi ahica hanɨbuŋ hɨniavadi uami. Nɨbɨlaŋ hulaŋ mu hula ma hɨdavɨlalɨ uami. Viaŋ nulɨdɨ huaci haiabɨla nalusaŋ via ivaveben uami. Lɨlɨŋ namɨlaŋ nukeŋ nulɨdɨ akuaba akuaba lɨbalu aba lɨlaŋ ci lɨci heŋ valɨbalaŋ uami. Agadɨ ala hulaŋ ahica agɨlaŋ ve iadɨ ulaŋ hɨvɨ hɨniavi sadaŋ namɨlaŋ nulɨdɨ akuaba akuaba lɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Lɨci hulaŋ Sodom haiabɨla hɨsɨŋ agɨlaŋ ciaŋ agadɨ igahɨlavɨla abavɨmi. Hulaŋ nagaŋ ihɨlɨŋ ve hɨnilalɨ agadɨ ala cɨhu nɨbu ciaŋ hihɨla hihɨla hɨsɨŋ me hɨniben aba li uavɨmi. Lotɨ nama huacɨha uavɨmi. Nama ma huacɨnabɨla ha alaŋ nama hula avi lusɨŋ sɨbɨlɨ hameŋ laci vibalu uavɨmi. Hulaŋ ahica agɨlaŋ vɨhɨlɨ igavɨbali ala nama vɨhɨlɨ hekɨlɨ agadɨ igɨbanaŋ uavɨmi. La Lotɨ dɨ mɨŋasidiguavɨci uci hɨbɨ lapa ifɨpilɨben aba lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Lɨhavɨci hulaŋ ahica uleŋ muji hɨniavɨmi agɨlaŋ human haiabɨla lamavɨci ivouci Lotɨ dɨ mɨŋamagɨlavɨci cɨhu uleŋ muji ivavemi. Ivaveci hɨbɨ lɨbavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Lɨbavɨla Asɨ dɨ vɨdɨvɨdɨŋ hɨvɨ lɨhavɨci hulaŋ haiabɨla hɨniavɨmi agɨladɨ lamɨgaŋ hɨfɨlɨ hɨfɨlɨ lɨci nɨbɨlaŋ mɨŋasuhɨlasuhɨla hɨbɨ lapa agadɨ ma igavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Lɨhavɨdaci hulaŋ ahica agɨlaŋ Lotɨ dɨ abavɨmi. Nadɨ ninanadina acihalina ani ani agɨlaŋ haiabɨla neŋ hɨniavɨci ha nulɨdɨ likɨla via haiabɨla nagadɨ valavɨla uhalaŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Lɨlaŋ alaŋ ahica haiabɨla nagadɨ sɨbɨlɨ lamɨbalu uavɨmi. Lusɨŋ sɨbɨlɨ mu hɨdɨlɨ mu hɨdɨlɨ agɨlaŋ haiabɨla neŋ pam iahavɨlalɨ uavɨmi. Iahavɨdaci hulaŋ iamɨgali limu hɨhɨle agɨlaŋ Asɨ Iaue dɨ abavɨlalɨ uavɨmi. Lɨhavɨci Asɨ Iaue agaŋ nulɨdɨ ciaŋ agadɨ igahɨlavɨla abɨci haiabɨla nagadɨ sɨbɨlɨ lamalama saŋ veiemɨlu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lɨhavɨci Lotɨ agaŋ ua hulaŋ ahica nudɨ nanadinu dɨ sabisabi saŋ lɨbɨmɨŋavɨmi agɨladɨ abami. Ahica namɨlaŋ haiabɨla nagadɨ lɨhalɨha vala uhalaŋ uami. Asɨ Iaue agaŋ haiabɨla nagadɨ sɨbɨlɨ lamɨbali uami. Hameŋ abɨci hulaŋ ahica agɨlaŋ nɨbu aludɨ salaŋ ciaŋ akua abi uavɨla nudɨ ciaŋ agadɨ ma igahɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","La hɨniavɨci fɨli mɨŋalahɨdaci Asɨ dɨ ciaŋ hali hɨsɨŋ agɨlaŋ Lotɨ dɨ abavɨmi. Nadɨ iamɨgali nadɨ nadi ahica agɨladɨ via haiabɨla nagadɨ lɨhalɨha vala uhalaŋ uavɨmi. Namɨlaŋ hulaŋ iamɨgali lusɨŋ sɨbɨlɨ hɨsɨŋ agɨlaŋ hula sɨbɨlɨ lɨmɨlaŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lɨhavɨci Lotɨ agaŋ hɨji cuvɨlɨŋ cuvɨlɨŋ lamavɨla lɨhalɨha ma umi. Lɨci Asɨ Iaue agaŋ Lotɨ saŋ mavɨn hɨniavɨla abɨci nudɨ ciaŋ hali hɨsɨŋ agɨlaŋ Lotɨ dɨ human hɨvɨ mɨŋamagɨla viavɨla haiabɨla agadɨ vala uavɨmi. Nudɨ abinu dɨdaŋ nudɨ nadi ahica agɨladɨdaŋ avi mɨŋamagɨla viavɨla haiabɨla agadɨ vala uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Vala uavɨla Asɨ dɨ ciaŋ hali hɨsɨŋ mu agaŋ abami. Namɨlaŋ lɨhalɨha uhalaŋ uami. Uavɨla cɨhu limu cimɨla igave igɨmɨlaŋ uami. Namɨlaŋ fɨli abɨlɨ neŋ avi mɨgahɨniavɨla alusɨmɨlaŋ uami. Alaŋ hɨmɨmagalu aba abavɨla lɨhalɨha ua halu hɨvɨ iahuhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lɨci Lotɨ agaŋ mavɨn ciaŋ ciaŋ abami. Hulaŋ hekɨlɨ hekɨlɨ uami. Namɨlaŋ iadɨ hameŋ abɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Viaŋ naludɨ sibɨla hɨsɨŋ hulaŋ uami. Namɨlaŋ iadɨ iga iga hɨjɨŋalɨlalaŋ uami. Hameŋ sadaŋ iasaŋ mavɨn hɨniavɨla iadɨ ahɨliahulaŋ huaci hɨnidin uami. Agadɨ ala viaŋ akɨ lavɨla lɨhalɨha ua halu heŋ iahuvɨheben uami. Vakala udalɨŋ haiabɨla agaŋ sɨbɨlɨ lɨci ha viaŋ avi sɨbɨlɨ lɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Namɨlaŋ haiabɨla sudɨme mikɨ sɨbaŋ hɨni agadɨ igɨlaŋ uami. Ha viaŋ huaci lɨhalɨha ua iahuvɨhevin uami. Namɨlaŋ iadɨ valɨlaŋ haiabɨla sudɨme heŋ uavɨla ha ma hɨmɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Lɨci Asɨ dɨ ciaŋ hali hɨsɨŋ agaŋ abami. Alia uami. Viaŋ haiabɨla sudɨme agasaŋ abɨnaŋ agadɨ ma sɨbɨlɨ lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Namɨlaŋ lɨhalɨha uvɨhehalaŋ uami. Viaŋ akuaba akuaba lɨhalɨha ma lɨben uami. Namɨlaŋ haiabɨla heŋ ua iahulaŋ viaŋ haiabɨla limu hɨhɨle agɨladɨ sɨbɨlɨ lamɨben uami. Lotɨ agaŋ haiabɨla sudɨme aba abɨci cɨhu haiabɨla agadɨ ibi lamavɨla abavɨhadami. Soalɨ uavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Uaiaŋ iahɨci Lotɨ agaŋ Soalɨ haiabɨla ua iahumi. ");
INSERT INTO ena_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ua iahuci Asɨ Iaue agaŋ abɨci lɨba avɨŋ daŋ avɨŋ sɨbaŋ daŋ agɨlaŋ uaiaŋ susu hɨvɨ hɨnihɨni avɨli me mɨgavɨmi. Gomola haiabɨla Sodom haiabɨla agɨladɨ hɨvɨ mɨgavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Mɨgavɨdaci haiabɨla ahica agɨlaŋ lɨhuavɨmi. Nulɨdɨ fɨli abɨlɨ nulɨdɨ hulaŋ iamɨgali kɨlɨ akuaba akuaba agɨlaŋ avi sɨkasɨkan lɨhua fɨhalavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lɨhuavɨdaci Lotɨ abinu agaŋ muŋanu dɨ sɨvɨ uavɨla cɨhu limu cimɨla igave igami. Igavɨla lulɨm lɨfavɨla hɨda me lagulama hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Lɨci Ebɨlam agaŋ amɨli me hɨvɨ cimɨdaŋ sɨbaŋ iahavɨla Asɨ Iaue hula lagulama hɨniavɨmi heŋ ala cɨhu umi. ");
INSERT INTO ena_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Uavɨla lagulama Sodom haiabɨla agadɨdaŋ Gomola haiabɨla agadɨdaŋ igamɨgua igasulami. La fɨli abɨlɨ agadɨ avi igami. Igɨdaci avɨŋ hekɨlɨ me lɨhulɨhu avɨmɨsɨ iahami. ");
INSERT INTO ena_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Asɨ agaŋ Ebɨlam saŋ igahɨlavɨla Lotɨ dɨ abami. Abɨci haiabɨla hekɨlɨ hekɨlɨ fɨli abɨlɨ hɨniavɨmi agɨladɨ vala uci heŋ nulɨdɨ sɨbɨlɨ lamami. ");
INSERT INTO ena_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lotɨ agaŋ Soalɨ haiabɨla hɨnihɨni saŋ lɨdavɨla iaha nudɨ nadi ahica agɨladɨ likɨla via halu iahuavɨmi. Halu iahuavɨla lɨba haca hɨvɨ ivouavɨla hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ivoua hɨnihɨni Cimam agaŋ Iagɨvam dɨ abami. Aludɨ iavaŋ ci hadi hadi li uami. Hulaŋ fɨli neŋ hɨniavɨlalɨ agɨlaŋ iamɨgali sabiavɨlalɨ uami. Agadɨ ala hulaŋ aludɨ sabisabi hɨsɨŋ agɨlaŋ apalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Alaŋ ahica iavaŋ saŋ lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ igumɨli navɨla uavauava lɨm uami. Lɨci alaŋ ahica nɨbu hula hɨniavɨla ninaŋ huhɨlɨmɨli uami. Hameŋ lɨmɨli aludɨ hɨdɨlɨ agaŋ ma sɨvɨlɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","La hɨniavɨci hɨfɨlɨ lɨci iaganɨlu saŋ lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ iguavɨci nami. Navɨla lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ agaŋ lɨdaci iaganɨlu agaŋ uavauava hekɨlɨ iahumi. Lɨci nudɨ nadi Cimam agaŋ iaganu hula hɨdami. Hameŋ lɨmi agadɨ ala iaganu ma igami. ");
INSERT INTO ena_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","La cɨhu amɨli me hɨvɨ Cimam agaŋ Iagɨvam dɨ abami. Viaŋ amɨli hɨfɨlɨ iavaŋ hula ci hɨdiemin uami. Iabi hɨfɨlɨ alaŋ ahica iavaŋ saŋ lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ cɨhu igumɨli navɨla uavauava lɨm uami. Lɨci nama avi nɨbu hula hɨdɨha uami. Viaŋ liemin hameŋ ala lɨha uami. Hameŋ lɨnaŋ aludɨ hɨdɨlɨ agaŋ ma sɨvɨlɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Lavɨla cɨhu iaganɨlu saŋ lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ iguavɨci navɨla uavauava lɨmi. Lɨci Iagɨvam agaŋ iaganu hula hɨdami. Hameŋ lɨmi agadɨ ala iaganu ma igami. ");
INSERT INTO ena_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Hameŋ lavɨla nadi ahica agɨlaŋ humɨgaŋ ahɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","La Cimam agaŋ ninaŋ huhɨlavɨla ibi lamavɨla abami. Nudɨ ibi Moapɨ uami. Moapɨ agaŋ Moapɨ hɨdɨlɨ agɨladɨ iamɨlɨnɨlu. Nɨbɨlaŋ vaka fɨli tɨbɨ heŋ ala hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Lɨci Iagɨvam agaŋ nɨbu avi ninaŋ huhɨlavɨla ibi lamavɨla abami. Nudɨ ibi Benami uami. Benami agaŋ Amon hɨdɨlɨ agɨladɨ iamɨlɨnɨlu. Nɨbɨlaŋ avi vaka fɨli tɨbɨ heŋ ala hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","2","Ebɨlam agaŋ Hebɨlon haiabɨla valavɨla Negevɨ fɨli tɨbɨ ua hɨniadami. Kadesɨ haiabɨla hɨnici uci Solɨ haiabɨla hɨnici ve alɨhaŋ heŋ hɨniadami. Heŋ hɨniavɨla cɨhu abinu Sela hula Gelalɨ haiabɨla uavɨla hɨniavɨmi. Hɨnihɨni hulaŋ iamɨgali Gelalɨ haiabɨla hɨsɨŋ agɨladɨ abadami. Viaŋ Sela dɨ amunu uadami. Lɨdaci Gelalɨ haiabɨla hɨsɨŋ agɨladɨ manɨgali Abimelekɨ agaŋ nudɨ sibɨla hɨsɨŋ hulaŋ agɨladɨ abɨci uavɨla Sela dɨ viavɨla nudɨ pɨŋ vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Vavehavɨci nɨbu hula hutesɨ hɨnidaci Asɨ agaŋ hɨfɨlɨ anisɨhu hɨvɨ Abimelekɨ dɨ abami. Iamɨgali hulaŋ daŋ agadɨ vihanaŋ sadaŋ nama hɨmɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Hameŋ abɨci Abimelekɨ agaŋ Sela hula ma hɨdɨmaŋ lɨdɨŋ abami. Iadɨ Hekɨlɨ uami. Hulaŋ mu hugɨ ma lamɨci ha nama huaci nudɨdaŋ nudɨ hɨdɨlɨ pam agɨladɨdaŋ ifɨhɨmɨvanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ebɨlam nukeŋ iadɨ abalɨ uami. Viaŋ iamɨgali nagadɨ amunu aba abalɨ uami. Iamɨgali agaŋ avi abalɨ uami. Ebɨlam iadɨ amu aba abalɨ uami. Hameŋ abavɨci viaŋ hɨji nameŋ lamacin uami. Viaŋ iamɨgali agadɨ huaci akua sabivin aba abacin uami. La viaŋ hugɨ apalɨ hɨniavɨla abɨlɨŋ iamɨgali agadɨ iadɨ pɨŋ vavehavalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Lɨci cɨhu Asɨ anisɨhu hɨvɨ abami. Viaŋ nadɨ igɨlɨŋ nama hɨji huaci daŋ hɨniavɨla hameŋ lɨhanaŋ uami. Hameŋ sadaŋ viaŋ nukeŋ lɨlɨŋ nama iamɨgali agaŋ hula ma hɨdahanaŋ uami. La nama lusɨŋ sɨbɨlɨ ma vihanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Nama nadɨ sibɨla hɨsɨŋ hulaŋ agɨladɨ abɨnaŋ iamɨgali agadɨ viavɨla ua muŋanu dɨ pɨŋ lamavɨm uami. Muŋanu nɨbu iadɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ sadaŋ nɨbu nadɨ ahɨliahuiahu saŋ iadɨ abɨci nama ma hɨmɨbanaŋ uami. Agadɨ ala nama ma abɨnaŋ iamɨgali agadɨ via ua lamavɨci uami. Ha nama nadɨ ulaŋ pam hɨsɨŋ agɨlaŋ hula amɨŋ ci haba hɨmɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Lɨci Abimelekɨ agaŋ cimɨdaŋ sɨbaŋ iahavɨla nudɨ sibɨla hɨsɨŋ hulaŋ agɨladɨ abɨci vehavɨmi. Vehavɨci Asɨ nudɨ abami agadɨ nulɨsaŋ tɨbi sulami. Tɨbi sulɨci igahɨlavɨla haba lɨdavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Lɨdavɨci Abimelekɨ agaŋ nulɨdɨ abɨci ua Ebɨlam dɨ abavɨci nudɨ pɨŋ vemi. Veci nudɨ abitɨhami. Viaŋ nadɨ akɨ lɨlɨŋ nama aludɨ hameŋ lɨhanaŋ uami. Lɨnaŋ viaŋ iadɨ hulaŋ iamɨgali migɨlɨlan agɨlaŋ hula hugɨ hekɨlɨ daŋ hɨnidalu uami. Hulaŋ hɨhɨle agɨlaŋ lusɨŋ sɨbɨlɨ hameŋ ma vihavɨlalɨ uami. Agadɨ ala nama iadɨ akɨ saŋ hameŋ lɨhanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Nama akɨ hɨji lamavɨla lusɨŋ hameŋ agadɨ vihanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Lɨci Ebɨlam agaŋ abami. Viaŋ hɨji nameŋ igahɨlavɨla lɨcin uami. Hulaŋ iamɨgali neŋ hɨsɨŋ agɨlaŋ Asɨ saŋ ma lɨdavɨlalɨ aba lɨcin uami. La iadɨ iamɨgali agadɨ viben aba lavɨla iadɨ ifɨhɨmavɨmɨdɨ aba lɨcin uami. ");
INSERT INTO ena_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Viaŋ nadɨ amɨŋ abacin uami. Viaŋ Sela dɨ amunu aba abacin uami. Nɨbu alaŋ ahica iavaŋ pabiŋ laci uami. Agadɨ ala alaŋ iamɨga hɨtɨŋ hɨtɨŋ hɨsɨŋ sadaŋ viaŋ nudɨ sabimin uami. ");
INSERT INTO ena_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Asɨ agaŋ iadɨ abɨci viaŋ iadɨ iavaŋ dɨ hɨdɨlɨ pam agɨladɨ valavɨla hɨdɨlan uami. Hɨdahɨda Sela dɨ abamin uami. Nama iasaŋ mavɨn hɨniavɨla iadɨ huaci lamɨben aba lavɨla ha alaŋ ahica abeba abeba hɨdɨdamɨli hulaŋ iamɨgali agɨladɨ nameŋ abɨha aba abamin uami. Ebɨlam iadɨ amu aba abɨha aba abamin uami. ");
INSERT INTO ena_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Lɨci Abimelekɨ agaŋ Sela dɨ abɨci Ebɨlam dɨ pɨŋ cɨhu ala umi. Lɨci sibɨla hɨsɨŋ hulaŋ iamɨgali agɨladɨdaŋ sabaŋ sipsipɨ sabaŋ bulɨmakau agɨladɨdaŋ Ebɨlam saŋ igumi. ");
INSERT INTO ena_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Iguavɨla abami. Igɨha uami. Fɨli tɨbɨ nana iadɨ laci uami. Nama fɨli tɨbɨ abeba neŋ hɨniben aba ha alia uami. Igɨnaŋ huaci lɨci heŋ hɨniha uami. ");
INSERT INTO ena_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","La Sela dɨ abami. Viaŋ amuna saŋ lɨba silɨva hɨlɨcɨ 1,000 iguin uami. Nadɨ vɨhɨlɨ iahi agadɨ mɨŋahihɨlahihɨla saŋ iguin uami. Lɨlɨŋ hulaŋ iamɨgali nama hula hɨniavi agɨlaŋ abavɨbali uami. Nɨbu hugɨ apalɨ aba abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Abimelekɨ agaŋ Sela dɨ via hɨnidaci Asɨ Iaue agaŋ nusaŋ igahɨlavɨla avaŋ valavala hɨbɨ agadɨ abamɨgɨlɨci Abimelekɨ abinu agaŋ hula nudɨ sibɨla hɨsɨŋ iamɨgali agɨlaŋ hula humɨgaŋ ma ahɨlavɨmi. Hameŋ hɨniavɨdaci Ebɨlam agaŋ Abimelekɨ huaci lɨlɨ saŋ Asɨ dɨ abami. Lɨci Asɨ agaŋ Abimelekɨ dɨ huaci lamami. Huaci lamavɨla nudɨ abinu dɨdaŋ nudɨ sibɨla hɨsɨŋ iamɨgali agɨladɨdaŋ avi huaci lamɨci cɨhu humɨgaŋ ahɨlavɨmi. La ninanadi huhɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","2","Asɨ Iaue agaŋ Sela saŋ abami agadɨ hameŋ laci ala lɨmi. Sela dɨ huaci lamɨci humɨgaŋ ahɨlavɨla Ebɨlam dɨ ninaŋ agadɨ huhɨlami. Ebɨlam agaŋ hadi hadi la hɨnidaci avaŋ Asɨ abami heŋ ala Sela agaŋ ninaŋ huhɨlami. ");
INSERT INTO ena_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Lɨci Ebɨlam agaŋ ninaŋ agadɨ ibi lamavɨla abami. Aisakɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Huhɨlɨci uaiaŋ human limu fɨhala human limu pabiŋ cɨjɨŋ uci Ebɨlam agaŋ Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agadɨ lubiahɨlavɨla Aisakɨ dɨ hadi sɨbɨlɨ ihalahami. ");
INSERT INTO ena_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Sela agaŋ Aisakɨ dɨ huhɨla hɨnidaci Ebɨlam dɨ hualɨ lugɨlavɨci ua 100 iahami. ");
INSERT INTO ena_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","La Sela agaŋ abami. Asɨ agaŋ lɨci viaŋ hɨjɨŋalavɨla lɨnin uami. Lɨnilɨŋ hulaŋ iamɨgali akape agɨlaŋ avi ciaŋ hɨjɨ agadɨ igahɨlavɨla nɨbɨlaŋ avi hɨjɨŋalavɨla lɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Vaka akɨ hulaŋ agaŋ hɨji lamavɨla Ebɨlam dɨ abɨvi uami. Abina Sela ninaŋ huhɨlavɨla ninaŋ amaŋ lɨbɨbali aba abɨvi uami. Agadɨ ala Ebɨlam agaŋ hadi hadi lɨci ala viaŋ nudɨ ninaŋ huhɨlacin uami. ");
INSERT INTO ena_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Lɨci ninaŋ agaŋ hekɨlɨ lavɨla amaŋ valami agasaŋ igahɨlavɨla Ebɨlam agaŋ hɨjɨŋalavɨla sɨmɨŋ hekɨlɨ hɨlanami. ");
INSERT INTO ena_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Lɨci mu tɨbɨ Sela agaŋ igɨci Hega dɨ ninaŋ agaŋ salaŋ iahuiahu hɨnimi. Hega nɨbu Isipɨ fɨli tɨbɨ hɨsɨŋ iamɨgali. Nɨbu Ebɨlam hula hɨdavɨla ninaŋ agadɨ huhɨlami. ");
INSERT INTO ena_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ninaŋ agaŋ salaŋ iahuiahu hɨnidaci Sela agaŋ Ebɨlam dɨ abami. Nama sibɨla hɨsɨŋ iamɨgali agadɨdaŋ nudɨ ninanu agadɨdaŋ lahunaŋ uavɨm uami. Mufɨli nama hɨmɨnaŋ nudɨ ninaŋ agaŋ nadɨ akuaba akuaba agɨladɨ ma vibali uami. Akuaba akuaba hana ha iadɨ ninaŋ Aisakɨ dɨ laci uami. ");
INSERT INTO ena_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Hameŋ abɨci Ebɨlam agaŋ nudɨ ninaŋ Isɨmaelɨ saŋ igahɨlavɨla humɨgaŋ vɨhɨlɨ vimi. ");
INSERT INTO ena_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Humɨgaŋ vɨhɨlɨ vici Asɨ agaŋ nudɨ abami. Sibɨla hɨsɨŋ iamɨgali agaŋ nudɨ ninanu hula vala uavɨbali agasaŋ humɨgaŋ vɨhɨlɨ vimɨnaŋ uami. Sela dɨ ciaŋ agadɨ pam lubiahɨlɨha uami. Nadɨ ninana Aisakɨ dɨ hɨvɨ lɨlɨŋ nadɨ iamɨlɨhalina agɨlaŋ iaha habɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Sibɨla hɨsɨŋ iamɨgali agadɨ ninaŋ nɨbu avi nadɨ ninaŋ uami. Hameŋ sadaŋ viaŋ lɨlɨŋ nudɨ iamɨlɨhalinu agɨlaŋ avi hɨdɨlɨ hɨtɨŋ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Lɨci hɨniavɨci mɨŋalahɨci cimɨdaŋ sɨbaŋ Ebɨlam agaŋ iaha sabaŋ meme sɨgɨtɨ hɨcavɨci sɨbɨ hɨlɨcɨ me hɨnici avɨli lula lamavɨmi agadɨ vimi. La sɨmɨŋ cɨki daŋ via uavɨla Hega dɨ macɨŋ sabɨ hɨvɨ lamami. Lamavɨla Ebɨlam agaŋ ninaŋ agadɨ Hega saŋ iguavɨla lahuci ahica uavɨmi. Uavɨla Belɨseba avɨli sɨmɨ tulɨ mikɨ heŋ fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ hɨdavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Hɨdahɨda uavɨla avɨli sɨbɨ hɨlɨcɨ me hɨvɨ hɨnimi agadɨ na fɨhalavɨmi. Na fɨhalavɨla ninaŋ agadɨ via ua kɨlɨ cɨki agadɨ hɨbɨlɨ heŋ lamami. ");
INSERT INTO ena_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Lamɨci hɨnidaci hɨji nameŋ lamami. Igasulɨdalɨŋ ninaŋ agaŋ hɨmɨci mavɨn hekɨlɨ vimagaŋ uavɨla vala ataŋ tagɨlaŋ daŋ ua mɨgahɨnia ilɨha ilɨha hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Lɨci Asɨ agaŋ ninaŋ ilɨhami agadɨ igahɨlami. Lɨci Asɨ dɨ ciaŋ hali hɨsɨŋ agaŋ Asɨ dɨ haiabɨla hɨniavɨla Hega dɨ ulavɨla abami. Hega uami. Akɨ saŋ ilɨha ilɨha hɨnidanaŋ uami. Nama lɨdɨmɨnaŋ uami. Asɨ agaŋ nadɨ ninaŋ ilɨhadi agadɨ ci igi uami. ");
INSERT INTO ena_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Nama iaha uavɨla ninaŋ agadɨ mɨŋaiahavɨla nudɨ human hɨvɨ mɨŋalɨvɨha uami. Asɨ agaŋ nudɨ iamɨlɨhalinu agɨladɨ lɨci iaha habɨla hɨdɨlɨ hekɨlɨ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Hameŋ abɨci Asɨ agaŋ Hega dɨ hɨji mɨŋaiahɨci avɨli sɨmɨ tulɨ agadɨ heŋ igami. Igavɨla sabaŋ meme sɨgɨtɨ hɨcavɨci sɨbɨ hɨlɨcɨ me hɨnimi agadɨ hɨvɨ avɨli lulavɨla via uavɨla ninanu saŋ iguci nami. ");
INSERT INTO ena_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Lɨci Asɨ agaŋ ninaŋ agadɨ igulamɨci hɨniavɨla hekɨlɨ lɨmi. Hekɨlɨ lavɨla fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ hɨniadami. Nɨbu hɨmi hɨvɨ sibɨla sibɨla hulihuli sibɨla agadɨ sɨhɨvia sɨbaŋ igadami. ");
INSERT INTO ena_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Palan fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ hɨnidaci iamɨnu agaŋ nusaŋ iamɨgali Isipɨ fɨli tɨbɨ hɨsɨŋ agadɨ via vaveci sabimi. ");
INSERT INTO ena_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Mu tɨbɨ Abimelekɨ agaŋ nudɨ sagaŋ hali hɨsɨŋ Fikolɨ hula Ebɨlam dɨ abɨben aba nudɨ pɨŋ vehavɨmi. Vevɨla Abimelekɨ agaŋ abami. Akuaba akuaba sibɨla vidanaŋ Asɨ agaŋ nama hula hɨnilalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Asɨ igɨdaci hɨvɨ hekɨlɨ uavɨla abɨha uami. Viaŋ nadɨdaŋ nadɨ ninanadina agɨladɨdaŋ cɨhu cɨhu analɨ ma abɨben aba abɨha uami. Nadɨ iamɨlɨhalina agɨladɨ avi analɨ ma abɨben aba abɨha uami. Lavɨla Ebɨlam dɨ cɨhu ala abami. Viaŋ nasaŋ mavɨn hɨniavɨla nadɨ huaci lamacin uami. Hameŋ sadaŋ hɨvɨ hekɨlɨ uavɨla abɨha uami. Viaŋ nadɨdaŋ nadɨ fɨli tɨbɨ hɨnilan agadɨdaŋ huaci lamɨben aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Lɨci Ebɨlam agaŋ Abimelekɨ dɨ abami. Hɨvɨ hekɨlɨ uami. Nama abɨnaŋ agadɨ viaŋ hameŋ ala lɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","La cɨhu ala abami. Viaŋ nama hula ciaŋ cɨki daŋ uami. Nadɨ sibɨla hɨsɨŋ hulaŋ agɨlaŋ sagaŋ lɨbavɨla aludɨ lahuavɨla iadɨ avɨli sɨmɨ tulɨ agadɨ ci vihavalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Hameŋ abɨci Abimelekɨ agaŋ cɨhu abami. Hulaŋ aniaba agɨlaŋ hameŋ lɨhavalɨ agadɨ viaŋ ma igacin uami. Nama iadɨ vaka ma abahanaŋ uami. Viaŋ ciaŋ agadɨ malɨciŋ laci igahɨlin uami. ");
INSERT INTO ena_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Lɨci Ebɨlam agaŋ sabaŋ sipsipɨ limu hɨhɨle agɨladɨdaŋ sabaŋ bulɨmakau limu hɨhɨle agɨladɨdaŋ viavɨla Abimelekɨ saŋ iguavɨla nɨbu hula ciaŋ mɨgumi. ");
INSERT INTO ena_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","La Ebɨlam agaŋ sabaŋ sipsipɨ ninaŋ mɨgenaŋ human limu fɨhala human limu ahica cɨjɨŋ nudɨ nukeŋ agɨladɨ viavɨla mu abɨla hɨvɨ lamami. ");
INSERT INTO ena_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Lɨci Abimelekɨ agaŋ nudɨ abitɨhami. Akɨ saŋ hameŋ lɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Lɨci Ebɨlam agaŋ abami. Nama sabaŋ sipsipɨ ninaŋ mɨgenaŋ human limu fɨhala human limu ahica cɨjɨŋ nasaŋ lamin agɨladɨ viha uami. Hameŋ lɨlɨŋ igavɨla abɨbanaŋ uami. Avɨli sɨmɨ tulɨ hana nɨbu nukeŋ mavalɨ aba abɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Avɨli sɨmɨ tulɨ fipɨ heŋ hɨniavɨla abavɨmi. Hɨvɨ hekɨlɨ uavɨmi. La ibi lamavɨla abavɨmi. Belɨseba uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Belɨseba avɨli sɨmɨ tulɨ fipɨ heŋ ciaŋ mɨgua fɨhalavɨla Abimelekɨ hula nudɨ sagaŋ hali hɨsɨŋ Fikolɨ hula cɨhu ala Filisɨtia hɨdɨlɨ agɨladɨ fɨli tɨbɨ heŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Uavɨci Ebɨlam agaŋ Asɨ Iaue hameŋ laci hameŋ laci hɨnilalɨ agadɨ ibi mɨŋaiahɨben aba kɨlɨ Belɨseba avɨli sɨmɨ tulɨ mikɨ heŋ hulimi. Huliavɨla Asɨ Iaue dɨ ibi luvɨla luvɨla nudɨ ibi mɨŋaiahami. ");
INSERT INTO ena_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Lavɨla Filisɨtia hɨdɨlɨ agɨladɨ fɨli tɨbɨ heŋ hutesɨ tagɨlaŋ daŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Mu tɨbɨ Asɨ agaŋ Ebɨlam dɨ hɨji vɨdɨvɨdɨŋ agadɨ igɨben aba nudɨ abami. Ebɨlam uami. Lɨci Ebɨlam agaŋ abami. Viaŋ nan hɨnidin uami. ");
INSERT INTO ena_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Lɨci abami. Nama nadɨ ninaŋ pabiŋ Aisakɨ dɨ laci via hɨnilanaŋ uami. Nama nusaŋ pam mavɨn hekɨlɨ hɨnilanaŋ uami. Nama nudɨ viavɨla Molia fɨli tɨbɨ uhalaŋ uami. Lɨnaŋ viaŋ nasaŋ halu mu abalamɨben uami. Abalamɨlɨŋ nama halu heŋ uavɨla Aisakɨ dɨ ifɨhɨmavɨla iasaŋ sagalɨ igu igu saŋ sɨkasɨkan lamɨnaŋ lɨhua fɨhalam uami. ");
INSERT INTO ena_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Lɨci Ebɨlam agaŋ cimɨdaŋ sɨbaŋ iaha akuaba akuaba lamalama hɨsɨŋ agadɨ viavɨla sabaŋ donɨki hulɨ sabɨ hɨvɨ lamami. Lavɨla Asɨ saŋ sagalɨ hɨlahɨla saŋ avɨŋ makaŋ ifɨcɨkɨlami. Ifɨcɨkɨla via akuaba akuaba lamalama hɨsɨŋ sabaŋ donɨki hulɨ sabɨ hɨvɨ hɨnimi agadɨ hɨvɨ lamami. Lamavɨla Aisakɨ dɨdaŋ nudɨ sibɨla hɨsɨŋ hulaŋ ahica agɨladɨdaŋ vimi. Viavɨla fipɨ Asɨ abami agasaŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Uavɨdaci uaiaŋ pabiŋ uci anihuliŋ me hɨvɨ halu agadɨ igɨci ataŋ tagɨlaŋ daŋ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Lɨci nudɨ sibɨla hɨsɨŋ hulaŋ ahica agɨladɨ abami. Namɨlaŋ ahica sabaŋ donɨki agadɨ neŋ migɨla hɨnihalaŋ uami. Hɨnidalaŋ viaŋ Aisakɨ hula adeŋ uavɨla mɨgalɨfɨlɨbavɨla Asɨ dɨ ibi mɨŋaiahavɨla cɨhu vebalu uami. ");
INSERT INTO ena_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","La Ebɨlam agaŋ Aisakɨ saŋ avɨŋ makaŋ via iguci havami. Lɨci nɨbu nukeŋ avɨŋ daŋ puia ninaŋ daŋ mɨŋalɨvavɨla uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ua hɨbɨ cina Aisakɨ agaŋ Ebɨlam dɨ abami. Iavaŋ uami. Lɨci abami. Ninaŋ akɨ uami. Lɨci abami. Viaŋ igɨlɨŋ avɨŋ daŋ avɨŋ makaŋ daŋ hanɨbuŋ uami. Agadɨ ala sabaŋ sipsipɨ ninaŋ abeŋ hɨsɨŋ viavɨla sagalɨ igubalu uami. ");
INSERT INTO ena_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Lɨci Ebɨlam agaŋ cɨhu nudɨ abami. Ninaŋ uami. Asɨ nukeŋ sabaŋ sipsipɨ ninaŋ iguci sagalɨ igubalu uami. Hameŋ abavɨla ahica uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Uavɨla fipɨ Asɨ abami heŋ iahuavɨla Ebɨlam agaŋ Asɨ saŋ sagalɨ hɨlahɨla hɨsɨŋ lɨba vadɨm ibilami. Ibilavɨla avɨŋ makaŋ agɨladɨ lɨba vadɨm sabɨ heŋ ahɨlɨci iahuavɨmi. Ahɨlɨci iahuavɨci Aisakɨ dɨ hɨcɨ human lɨmɨn hɨvɨ hahami. Hahavɨla avɨŋ makaŋ ahɨlɨci iahuavɨmi agɨladɨ sabɨ heŋ ala lamami. ");
INSERT INTO ena_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","La puia ninaŋ viavɨla Aisakɨ dɨ iamɨla hɨmɨben aba lɨmi. ");
INSERT INTO ena_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Lɨdaci Asɨ Iaue dɨ ciaŋ hali hɨsɨŋ agaŋ Asɨ dɨ haiabɨla hɨniavɨla Ebɨlam dɨ ulavɨla abami. Ebɨlam uami. Lɨci abami. Viaŋ nan hɨnidin uami. ");
INSERT INTO ena_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Lɨci Asɨ Iaue dɨ ciaŋ hali hɨsɨŋ agaŋ nudɨ abami. Nama ninaŋ agadɨ ifɨhɨmɨmɨnaŋ uami. La nama nudɨ akuaba akuaba cɨki avi lɨmɨnaŋ uami. Nama nadɨ ninaŋ pabiŋ cɨki sɨbaŋ agasaŋ mavɨn hɨnilanaŋ uami. Agadɨ ala Asɨ nudɨ ifɨhɨmavɨla sagalɨ igu igu saŋ abɨci nama ma mɨlɨmɨŋɨnaŋ uami. Nama Asɨ saŋ lɨdavɨla nudɨ lɨhu hɨvɨ hɨnilanaŋ sadaŋ hameŋ lɨnaŋ uami. Lɨnaŋ Asɨ nadɨ ci igi uami. ");
INSERT INTO ena_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Lɨci Ebɨlam agaŋ igasula igɨci kɨlɨ cɨki agadɨ cigɨla agaŋ sabaŋ sipsipɨ muŋaŋ agadɨ lamamigɨlɨci hɨnimi. Lɨci igavɨla ua sabaŋ sipsipɨ agadɨ ifɨhɨma viavɨla ve sagalɨ saŋ sɨkasɨkan avɨŋ hɨvɨ lamɨci lɨhua fɨhalami. Hameŋ lɨci sabaŋ sipsipɨ agaŋ Aisakɨ dɨ uvɨsɨjiŋ vimi. ");
INSERT INTO ena_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Lɨci Ebɨlam agaŋ fipɨ agadɨ ibi lamavɨla abami. Asɨ Iaue nukeŋ akuaba akuaba agɨladɨ igulalɨ uami. Lɨci hameŋ laci hameŋ laci abavɨhadami. Asɨ Iaue dɨ halu heŋ ala nɨbu akuaba akuaba igubali uavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Asɨ Iaue dɨ ciaŋ hali hɨsɨŋ agaŋ Ebɨlam dɨ cɨhu tɨbɨ ulavɨla abami. ");
INSERT INTO ena_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Asɨ Iaue agaŋ nameŋ abi uami. Viaŋ iadɨ nukeŋ ibi hɨvɨ abin aba abi uami. Hɨvɨ hekɨlɨ aba abin aba abi uami. Nama nadɨ ninaŋ pabiŋ sɨbaŋ agasaŋ mavɨn hɨnilanaŋ agadɨ ala ma mɨlɨmɨŋɨnaŋ aba abi uami. ");
INSERT INTO ena_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Hameŋ sadaŋ viaŋ nadɨ huaci lamɨben aba abi uami. La nadɨ iamɨlɨhalina agɨladɨ lɨlɨŋ iaha habɨlavɨla lidɨ uaiaŋ susu hɨvɨ hɨniavɨlalɨ hameŋ ala hɨniavɨbali aba abi uami. Hacɨŋ hɨlɨcɨ avɨli hekɨlɨ caba hɨvɨ hɨniavɨlalɨ hameŋ hɨniavɨbali aba abi uami. La nadɨ iamɨlɨhalina agɨlaŋ hulaŋ nulɨdɨ nagɨli lamavɨbali agɨlaŋ hula sagaŋ lɨbavɨla nulɨdɨ lɨvalavɨbali aba abi uami. Lavɨla nulɨdɨ haiabɨla agadɨ vihavɨbali aba abi uami. ");
INSERT INTO ena_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Nama iadɨ ciaŋ lubiahɨlɨnaŋ sadaŋ viaŋ nadɨ iamɨlɨhalina agɨlasaŋ igahɨlahɨla hulaŋ iamɨgali hɨdɨlɨ mu mu sɨkasɨkan fɨli neŋ hɨniavɨlalɨ agɨladɨ huaci lamɨben aba abi uami. ");
INSERT INTO ena_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Lɨci Ebɨlam agaŋ Aisakɨ dɨ viavɨla cɨhu sibɨla hɨsɨŋ hulaŋ ahica hɨniavɨmi heŋ vehavɨmi. Vevɨla nulɨdɨ viavɨla sɨkasɨkan Belɨseba avɨli sɨmɨ tulɨ heŋ vehavɨmi. Vevɨla heŋ ala hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ebɨlam agaŋ Belɨseba avɨli sɨmɨ tulɨ caba heŋ hɨniadami. La mu tɨbɨ imanu Naholɨ abinu Milɨka agaŋ ninaŋ agɨladɨ huhɨlami agadɨ ciaŋ hɨjɨ igahɨlami. ");
INSERT INTO ena_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ninadinu agɨladɨ ibi nameŋ. Usɨ nɨbu Cimegeŋ. Mu Busɨ. Mu Kemuelɨ. Nɨbu Alam iaganu. ");
INSERT INTO ena_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Mu Kesetɨ. Mu Haso. Mu Pilɨdasɨ. Mu Jitɨlapɨ. Mu Betuelɨ. ");
INSERT INTO ena_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Nɨbu Lebeka iaganu. Naholɨ nɨbu Ebɨlam imanu. Naholɨ abinu Milɨka ninaŋ huhɨlami agɨladɨ lugɨlavɨci ua human limu fɨhala human limu ahica pam cɨjɨŋ iahami. ");
INSERT INTO ena_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Naholɨ abinu hɨvɨ agadɨ ibi Leuma. Nɨbu ninaŋ limu ahica limu ahica huhɨlami. Nulɨdɨ ibi nameŋ. Mu Teba. Mu Gehim. Mu Tehisɨ. Mu Maka. ");
INSERT INTO ena_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sela dɨ hualɨ lugɨlavɨci ua 127 iahami. ");
INSERT INTO ena_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Lɨci Sela agaŋ Kiliatalɨba haiabɨla heŋ hɨniavɨla hɨmami. Kiliatalɨba haiabɨla agadɨ ibi mu Hebɨlon. Haiabɨla agaŋ nɨbu Kenan fɨli tɨbɨ hɨniadami. Heŋ hɨniavɨla hɨmɨci Ebɨlam agaŋ abinu saŋ mavɨn mɨŋamɨŋa ilɨhami. ");
INSERT INTO ena_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","La hɨnimita Ebɨlam agaŋ Sela dɨ valɨ agadɨ vala uavɨla Hitɨ hɨdɨlɨ agɨladɨ abami. ");
INSERT INTO ena_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Viaŋ hulaŋ ihɨlɨŋ ve namɨlaŋ hula hɨnilan uami. Iadɨ iamɨgali agaŋ nɨbu ci hɨmi sadaŋ viaŋ naludɨ fɨli tɨbɨ lavɨben uami. La nudɨ valɨ agadɨ lɨba haca hɨvɨ hudɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Lɨci Hitɨ hɨdɨlɨ agɨlaŋ abavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Hulaŋ hekɨlɨ uavɨmi. Igahɨlɨha uavɨmi. Nama manɨgali hekɨlɨ uavɨmi. Nama nukeŋ lɨba haca huaci sɨbaŋ agadɨ iga lɨbɨmɨŋɨha uavɨmi. Lɨnaŋ lɨba haca iaganu agaŋ nasaŋ igubali uavɨmi. Ma mɨlɨmɨŋɨbali uavɨmi. Iguci nama abina dɨ valɨ agadɨ lɨba haca heŋ hudɨha uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Lɨhavɨci Ebɨlam agaŋ lagulamavɨla Hitɨ hɨdɨlɨ fɨli tɨbɨ heŋ hɨniavɨhadami agɨladɨ ibi mɨŋaiahɨben aba mɨgalɨfɨlɨbami. ");
INSERT INTO ena_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Mɨgalɨfɨlɨbavɨla abami. Namɨlaŋ iadɨ iamɨgali agadɨ valɨ lɨba haca heŋ hudahuda saŋ alia aba abavɨla ha namɨlaŋ iadɨ ahɨliahuavɨla Sohalɨ dɨ ninaŋ Efɨlon dɨ abitɨhɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Lɨlaŋ Efɨlon iasaŋ lɨba haca Makɨpela fɨli tɨbɨ hɨnidi agadɨ igum uami. Lɨba haca agaŋ nudɨ fɨli tɨbɨ agadɨ caba heŋ hɨni uami. Nɨbu anɨm hɨlɨcɨ vameba igu igu saŋ abɨci ha namɨlaŋ igasulɨdalaŋ nusaŋ hameŋ laci ala iguben uami. Lɨlɨŋ sudɨ haca mavamava hɨsɨŋ fɨli tɨbɨ agaŋ iadɨ laci hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Lua madɨŋ haiabɨla hɨbɨ ivu ivu mikɨ heŋ ciaŋ aba aba hɨniavɨdaci Efɨlon agaŋ nudɨ hɨdɨlɨ pam Hitɨ hɨdɨlɨ agɨlaŋ hula mɨgahɨniavɨmi. Hulaŋ iamɨgali Hitɨ hɨdɨlɨ agɨlaŋ igahɨlahɨla hɨniavɨdaci Efɨlon agaŋ Ebɨlam dɨ abami. ");
INSERT INTO ena_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Hulaŋ hekɨlɨ ha hɨma uami. Iadɨ ciaŋ agadɨ igahɨlɨha uami. Viaŋ fɨli tɨbɨ agadɨdaŋ lɨba haca agadɨdaŋ nasaŋ havɨ iguben uami. Iadɨ hɨdɨlɨ pam agɨlaŋ igasulavɨdaci viaŋ nasaŋ fɨli tɨbɨ agadɨ iguben uami. Lɨlɨŋ nama nadɨ abina dɨ valɨ agadɨ via ua fɨli tɨbɨ heŋ lɨba haca hɨvɨ hudɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Lɨci Ebɨlam agaŋ hulaŋ iamɨgali haiabɨla heŋ hɨsɨŋ agɨladɨ ibi mɨŋaiahɨben aba mɨgalɨfɨlɨbami. ");
INSERT INTO ena_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","La iaha hulaŋ iamɨgali hudɨmɨda igahɨlavɨdaci Efɨlon dɨ abami. Ha huaci uami. Agadɨ ala iadɨ ciaŋ agasaŋ hɨji lamɨha uami. Viaŋ iabi nadɨ fɨli tɨbɨ agadɨ lavɨben uami. Nama iadɨ anɨm hɨlɨcɨ agɨladɨ viha uami. Lɨnaŋ viaŋ iadɨ iamɨgali dɨ valɨ agadɨ nadɨ fɨli tɨbɨ heŋ lɨba haca hɨvɨ hudɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Lɨci Efɨlon agaŋ Ebɨlam dɨ abami. ");
INSERT INTO ena_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Hulaŋ hekɨlɨ uami. Iadɨ ciaŋ igahɨlɨha uami. Fɨli tɨbɨ nagadɨ lavɨben aba ha nudɨ lɨba silɨva hɨlɨcɨ 400 uami. Agadɨ ala ha vana hɨnim uami. Nusaŋ igahɨlɨmɨnaŋ uami. Fɨli tɨbɨ agadɨ havɨ viavɨla lɨba haca hɨvɨ abina dɨ valɨ agadɨ heŋ hudɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Lɨci Ebɨlam agaŋ ciaŋ agasaŋ alia uavɨla lɨba silɨva hɨlɨcɨ 400 sɨhɨvia lugɨlavɨla igumi. Hitɨ hɨdɨlɨ agɨlaŋ igahɨlavɨdaci Efɨlon abami hameŋ laci ala fɨli tɨbɨ agadɨ viben aba anɨm hɨlɨcɨ Efɨlon saŋ igumi. Lɨba silɨva hɨlɨcɨ lugɨlami ha anɨm hɨlɨcɨ sibɨla hɨsɨŋ lugɨlavɨhadami hameŋ me lugɨlami. ");
INSERT INTO ena_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Anɨm hɨlɨcɨ igumi agasaŋ igahɨlavɨla Efɨlon dɨ fɨli tɨbɨ agadɨ vimi. Efɨlon dɨ fɨli tɨbɨ nɨbu Makɨpela fɨli tɨbɨ agadɨ limu tɨbɨ. Makɨpela fɨli tɨbɨ agaŋ nɨbu Mamɨle haiabɨla mikɨ hɨniadami. Ebɨlam agaŋ fɨli tɨbɨ lɨba haca daŋ agadɨdaŋ kɨlɨ heŋ hɨniavɨhadami agɨladɨdaŋ sɨkasɨkan vimi. ");
INSERT INTO ena_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Hulaŋ iamɨgali Hitɨ hɨdɨlɨ agɨlaŋ nɨbu hula hɨnihɨni igavɨdaci fɨli tɨbɨ agadɨ lavami. ");
INSERT INTO ena_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Lavavɨla abinu Sela dɨ valɨ agadɨ lɨba haca Makɨpela fɨli tɨbɨ hɨnimi heŋ hudami. Makɨpela fɨli tɨbɨ ha Mamɨle haiabɨla mikɨ hɨniadami. Mamɨle haiabɨla nɨbu Kenan fɨli tɨbɨ hɨniadami. Mamɨle haiabɨla agadɨ ibi mu ha Hebɨlon. ");
INSERT INTO ena_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Fɨli tɨbɨ lɨba haca daŋ ha Hitɨ hɨdɨlɨ agɨladɨ. Agadɨ ala Ebɨlam dɨ hɨdɨlɨ agɨlasaŋ valavɨmi. Lɨhavɨci nudɨ hɨdɨlɨ pam agɨlaŋ hɨmavɨdaci heŋ laci ala mavamava hudavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ebɨlam agaŋ akuaba akuaba sibɨla vidaci Asɨ Iaue nudɨ ahɨliahuiahu huaci lamadami. Lɨdaci huaci laci hɨniadami. Hɨnia ua hadi hadi lɨmi. ");
INSERT INTO ena_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","La nɨbu nudɨ hɨmamɨgɨlɨ daŋ nɨbu hula hutesɨ hɨnihɨni nudɨ akuaba akuaba migɨladami agadɨ ulɨci vemi. Veci nudɨ abami. Ciaŋ mɨguben aba nadɨ human agadɨ iadɨ lagiŋ lɨhu hɨvɨ lamɨnaŋ vem uami. La nama Asɨ Iaue akuaba akuaba fɨli hɨsɨŋ uaiaŋ susu hɨsɨŋ agɨladɨ migɨlɨlalɨ agadɨ ibi hɨvɨ abɨha uami. Hɨvɨ hekɨlɨ aba abɨha uami. Lavɨla nama iadɨ ninaŋ Aisakɨ saŋ iamɨgali Kenan hɨdɨlɨ fɨli tɨbɨ viaŋ hɨnidin neŋ hɨsɨŋ agadɨ igavɨla lɨbɨmɨŋɨmɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Nama iadɨ haiabɨla uavɨla iamɨgali mɨnibɨlɨ iadɨ hɨdɨlɨ pam agadɨ suhɨlavɨla via vaveha uami. Vavenaŋ iadɨ ninaŋ agaŋ nudɨ sabibali uami. ");
INSERT INTO ena_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Lɨci nudɨ hɨmamɨgɨlɨ daŋ agaŋ abami. Iamɨgali mɨnibɨlɨ agaŋ nudɨ haiabɨla agadɨ valavɨla viaŋ hula fɨli tɨbɨ neŋ veve saŋ valɨci ha viaŋ akɨ lɨben uami. Cɨhu ve nadɨ ninaŋ agadɨ viavɨla nadɨ fɨli tɨbɨ uben uami. ");
INSERT INTO ena_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Lɨci Ebɨlam agaŋ abami. Nama iadɨ ninaŋ agadɨ viavɨla iadɨ fɨli tɨbɨ heŋ umɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Viaŋ iadɨ iavaŋ hula iadɨ hɨdɨlɨ pam agɨlaŋ hula iadɨ fɨli tɨbɨ hɨnidalɨŋ Asɨ Iaue akuaba akuaba uaiaŋ susu hɨsɨŋ migɨlɨlalɨ agaŋ nɨbu iadɨ neŋ vavevɨla abami uami. Hɨvɨ hekɨlɨ aba abami uami. Fɨli tɨbɨ nama hɨnidanaŋ nagadɨ nadɨ iamɨlɨhalina agɨlasaŋ iguben aba abami uami. Asɨ Iaue agaŋ nudɨ ciaŋ hali hɨsɨŋ agadɨ abɨci nɨbu mɨse iadɨ fɨli tɨbɨ heŋ udaci nama sɨvɨ ubanaŋ uami. Hameŋ lɨci ha nama huaci iadɨ ninaŋ saŋ iamɨgali mɨnibɨlɨ heŋ hɨsɨŋ vibanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Iamɨgali mɨnibɨlɨ agaŋ nama hula veve saŋ valɨci ha nama iamɨgali mɨnibɨlɨ iadɨ hɨvɨ hɨsɨŋ vavevave saŋ hɨvɨ hekɨlɨ aba abɨbanaŋ agasaŋ hɨji cuvɨlɨŋ lamɨmɨnaŋ uami. Agadɨ ala nama cɨhu ve iadɨ ninaŋ agadɨ viavɨla iadɨ fɨli tɨbɨ heŋ umɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Lɨci nudɨ hɨmamɨgɨlɨ daŋ agaŋ nudɨ manɨgali Ebɨlam dɨ lagiŋ lɨhu hɨvɨ human lamɨci uci abami. Hɨvɨ hekɨlɨ uami. Akuaba akuaba abɨnaŋ agadɨ hameŋ laci ala lɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","La nudɨ hɨmamɨgɨlɨ daŋ agaŋ sabaŋ kamelɨ human limu limu fɨhala agɨladɨdaŋ akuaba akuaba huaci huaci agɨladɨdaŋ viavɨla Naholɨ dɨ haiabɨla uavɨmi. Naholɨ dɨ haiabɨla agaŋ Mesopotemia fɨli tɨbɨ heŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ua hɨdahɨda hɨfɨlɨdaŋ hɨvɨ haiabɨla agadɨ lua madɨŋ madɨŋ heŋ iahuavɨmi. Iamɨgali avɨli licilici lakuku hɨvɨ ua iahuavɨla sabaŋ kamelɨ agɨladɨ abɨci avɨli sɨmɨ tulɨ caba heŋ mɨgalɨfɨlɨba hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","La hɨniavɨdaci abami. Asɨ Iaue nama iadɨ manɨgali Ebɨlam dɨ Asɨ uami. Nama iadɨ manɨgali agasaŋ mavɨn hɨniha uami. Lɨnaŋ sibɨla akuaba akuaba viaŋ viben agaŋ huaci laci iaham uami. ");
INSERT INTO ena_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Viaŋ avɨli sɨmɨ tulɨ mikɨ neŋ hɨnidalɨŋ iamɨgali mɨnibɨlɨ haiabɨla neŋ hɨsɨŋ agɨlaŋ avɨli licilici saŋ neŋ vehavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Vehavɨci viaŋ iamɨgali mɨnibɨlɨ mu agadɨ nameŋ abɨben uami. Nama fɨli sɨji avɨli daŋ agadɨ mɨŋamɨgɨnaŋ nɨlɨŋ aba abɨben uami. Abɨlɨŋ alia nɨha aba abɨbali uami. Lɨnaŋ nadɨ sabaŋ kamelɨ agɨlasaŋ avi igulɨŋ navɨbali aba abɨbali uami. Hameŋ abɨci viaŋ hɨji nameŋ lamɨben uami. Iamɨgali mɨnibɨlɨ nagadɨ ala nadɨ sibɨla hɨsɨŋ hulaŋ Aisakɨ saŋ lɨbɨmɨŋahanaŋ aba abɨben uami. Hameŋ lɨnaŋ viaŋ hɨji nameŋ lamɨben uami. Ha iadɨ manɨgali agasaŋ mavɨn hɨniavɨla ahɨliahui aba abɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agaŋ Asɨ dɨ aba aba hɨnidaci Lebeka agaŋ nudɨ fɨli sɨji macɨŋ sabɨ hɨvɨ lamavɨla haiabɨla agadɨ vala vemi. Lebeka dɨ iaganu nɨbu Betuelɨ. Betuelɨ dɨ iaganu nɨbu Naholɨ. Naholɨ nɨbu Ebɨlam dɨ imanu. Betuelɨ dɨ iamɨnu nɨbu Milɨka. ");
INSERT INTO ena_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Lebeka dɨ mugaŋ lamɨgaŋ agaŋ nɨbu huaci sɨbaŋ hɨniadami. Nɨbu hulaŋ mu hula ma hɨdɨmaŋ. Nɨbu nudɨ fɨli sɨji via vevɨla avɨli sɨmɨ tulɨ hɨvɨ mɨguavɨla avɨli liciavɨla cɨhu iahami. ");
INSERT INTO ena_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Iahɨci Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agaŋ lɨhalɨha nudɨ pɨŋ uavɨla abami. Iasaŋ nadɨ avɨli sɨji igunaŋ nacɨhulɨŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Lɨci Lebeka agaŋ abami. Hulaŋ hekɨlɨ nɨha uami. La lɨhalɨha mɨŋamɨga mɨŋaiaha via hɨnidaci nami. ");
INSERT INTO ena_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Nɨci ci lɨci Lebeka agaŋ nudɨ abami. Nadɨ sabaŋ kamelɨ agɨlasaŋ avi avɨli igulɨŋ navɨla humɨgaŋ laguavɨm uami. ");
INSERT INTO ena_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Hameŋ abavɨla lɨba hɨbɨn hɨbɨn sɨhɨm sabaŋ navɨhadami heŋ mɨŋamɨjici mɨguci navɨmi. Navɨdaci cɨhu lɨhalɨha uvɨhevɨla avɨli licimi. La hameŋ laci vavevave mɨŋamɨjidaci mɨgudaci nana humɨgaŋ laguavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Iamɨgali mɨnibɨlɨ agaŋ avɨli licidaci Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agaŋ ciaŋ ma abami. Nɨbu havɨ igasulasula hɨnimi. Nɨbu sɨhɨvia igɨben aba lɨmi. Asɨ Iaue agaŋ sibɨla viaŋ vin agadɨ huaci lamɨbali ua hɨma aba igahɨlahɨla hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Lɨdaci sabaŋ kamelɨ agɨlaŋ avɨli navɨci ci lɨci Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agaŋ luvɨŋ lɨba golɨ hɨvɨ vihavɨmi agadɨ viavɨla Lebeka saŋ igumi. Human lavi lɨba golɨ hɨvɨ vihavɨmi agɨladɨ avi nusaŋ igumi. Human lavi agɨladɨdaŋ luvɨŋ agadɨdaŋ anɨm hɨlɨcɨ hekɨlɨ hɨvɨ vihavɨmi. Luvɨŋ agadɨ vɨhɨlɨ ha 5 gɨlam. Lavi agɨladɨ vɨhɨlɨ hɨtɨŋ hɨtɨŋ ha 100 gɨlam. ");
INSERT INTO ena_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Lavɨla abami. Iadɨ abɨha uami. Nadɨ iagana ani uami. Nadɨ iagana dɨ ulaŋ ani hɨnihɨni fipɨ daŋ lɨci alaŋ nama hula ubalu uami. Uavɨla iadɨ sibɨla pam hɨsɨŋ agɨlaŋ hula iabi hɨfɨlɨ namɨlaŋ hula hɨsɨvɨbalu uami. ");
INSERT INTO ena_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Lɨci Lebeka agaŋ abami. Iadɨ iavaŋ nɨbu Betuelɨ uami. Betuelɨ dɨ iaganu nɨbu Naholɨ uami. Betuelɨ dɨ iamɨnu nɨbu Milɨka uami. ");
INSERT INTO ena_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Humɨsɨ akuaba akuaba huaci huaci sabaŋ kamelɨ navɨlalɨ agɨlaŋ hanɨbuŋ hɨniavi uami. Ani hɨnihɨni fipɨ avi hanɨbuŋ hɨniavi uami. ");
INSERT INTO ena_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Lɨci Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agaŋ hali lɨbuhɨlavɨla cɨhu Asɨ Iaue dɨ ibi mɨŋaiahɨben aba mɨgalɨfɨlɨbami. ");
INSERT INTO ena_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","La abami. Viaŋ Asɨ Iaue dɨ ibi mɨŋaiahin uami. Nɨbu iadɨ manɨgali Ebɨlam dɨ Asɨ uami. Nɨbu iadɨ manɨgali saŋ mavɨn hɨnilalɨ uami. Hɨnihɨni akuaba akuaba lɨlɨ saŋ abɨlalɨ agɨladɨ hameŋ laci lɨlalɨ uami. Hameŋ sadaŋ iadɨ viavɨla iadɨ manɨgali agadɨ hɨdɨlɨ pam hɨniavi neŋ vave uami. ");
INSERT INTO ena_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Lɨci iamɨgali mɨnibɨlɨ agaŋ haŋɨla iamɨnu dɨ ulaŋ umi. Uavɨla akuaba akuaba lɨmi agasaŋ sulami. ");
INSERT INTO ena_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Sulɨdaci Lebeka amunu Laban agaŋ luvɨŋ mugaŋ sɨmɨ hɨvɨ hɨnimi agadɨ igami. Human lavi nudɨ nadinu dɨ human hɨvɨ hɨniavɨmi agɨladɨ avi igami. Lɨci Lebeka agaŋ Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agaŋ abami agadɨ sulɨdaci Laban agaŋ igahɨlami. Igahɨlavɨla lua haiabɨla madɨŋ madɨŋ heŋ lɨhalɨha ivouavɨla igɨci Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agaŋ hula nudɨ sabaŋ kamelɨ agɨlaŋ hula avɨli sɨmɨ tulɨ mikɨ heŋ lagulama hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Hɨniavɨdaci Laban agaŋ nudɨ abami. Asɨ Iaue agaŋ nadɨ huaci lamɨlalɨ uami. Akɨ saŋ haiabɨla neŋ lagulama hɨnidanaŋ uami. Venaŋ alaŋ ahica haiabɨla agadɨ lua muji ivoumɨli uami. Viaŋ nasadaŋ nadɨ sabaŋ kamelɨ agɨlasadaŋ fipɨ ci mɨŋahihɨlin uami. ");
INSERT INTO ena_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Lɨci Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agaŋ uleŋ muji ivoumi. Ivouci Laban agaŋ nudɨ sibɨla hɨsɨŋ agɨladɨ abami. Akuaba akuaba nulɨdɨ sabaŋ kamelɨ sabɨ hɨvɨ hɨniavadi agɨladɨ ahɨla via lamavɨla nulɨsaŋ humɨsɨ akuaba akuaba agɨladɨ igulaŋ navɨm uami. La Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agasadaŋ nudɨ sibɨla hɨsɨŋ agɨlasadaŋ avɨli igulaŋ hɨcɨ husavɨm uami. ");
INSERT INTO ena_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Lɨci hɨcɨ husa fɨhala hɨniavɨdaci nulɨsaŋ sɨmɨŋ vavehavɨmi. Vavehavɨci Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agaŋ abami. Viaŋ sɨmɨŋ lɨhalɨha ma nɨben uami. Vana viaŋ ciaŋ sula fɨhalavɨla ala sɨmɨŋ heŋ nɨben uami. Lɨci Laban agaŋ abami. Alia sulɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Lɨci Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agaŋ abami. Viaŋ Ebɨlam dɨ hɨmamɨgɨlɨ daŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Asɨ Iaue agaŋ iadɨ manɨgali agadɨ huaci lamavɨla nusaŋ akuaba akuaba akape igudaci nɨbu hulaŋ hekɨlɨ hɨnilalɨ uami. La nɨbu sabaŋ sipsipɨ sabaŋ bulɨmakau sabaŋ kamelɨ sabaŋ donɨki akape daŋ hɨnilalɨ uami. Lɨba silɨva lɨba golɨ akuaba akuaba akape daŋ hɨnilalɨ uami. Sibɨla hɨsɨŋ hulaŋ iamɨgali avi akape daŋ hɨnilalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Nudɨ abinu Sela nɨbu hadi hadi sɨbaŋ hɨniavɨla ninaŋ huhɨlami uami. Lɨci iadɨ manɨgali agaŋ nudɨ akuaba akuaba agɨladɨ nudɨ ninanu dɨ human hɨvɨ lamami uami. ");
INSERT INTO ena_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","38","La ciaŋ vɨdɨvɨdɨŋ mu iadɨ nameŋ abalɨ uami. Nama iadɨ ninaŋ saŋ iamɨgali Kenan hɨdɨlɨ fɨli tɨbɨ viaŋ hɨnidin neŋ hɨsɨŋ agadɨ igavɨla lɨbɨmɨŋɨmɨnaŋ aba abalɨ uami. Nama iadɨ iavaŋ dɨ hɨvɨ uavɨla nudɨ hɨdɨlɨ pam agɨladɨ iamɨgali mɨnibɨlɨ igavɨla via vaveha aba abalɨ uami. Vavenaŋ iadɨ ninaŋ agaŋ nudɨ sabibali aba abalɨ uami. Iadɨ manɨgali agaŋ hameŋ abalɨ uami. Lɨci viaŋ Asɨ dɨ ibi luvɨlavɨla hɨvɨ hekɨlɨ aba abacin uami. Nama abɨnaŋ hameŋ ala lɨben aba abacin uami. ");
INSERT INTO ena_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Hameŋ abavɨla iadɨ manɨgali agadɨ nameŋ abacin uami. Iamɨgali mɨnibɨlɨ agaŋ viaŋ hula veve saŋ valɨci ha akɨ lɨben aba abacin uami. ");
INSERT INTO ena_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Lɨlɨŋ nɨbu iadɨ nameŋ abalɨ uami. Viaŋ Asɨ Iaue dɨ ciaŋ lubiahɨlɨlan aba abalɨ uami. Nɨbu nudɨ ciaŋ hali hɨsɨŋ agadɨ abɨci nama hula uavɨla nadɨ ahɨliahuci nadɨ sibɨla agaŋ huaci iahɨbali aba abalɨ uami. Lɨci nama iadɨ iavaŋ dɨ hɨvɨ uavɨla nudɨ hɨdɨlɨ pam agɨladɨ iamɨgali mɨnibɨlɨ agadɨ igavɨla iadɨ ninaŋ sabibali agasaŋ vibanaŋ aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Nama iadɨ iavaŋ dɨ hɨvɨ unaŋ nudɨ hɨdɨlɨ pam agɨlaŋ ma alia aba abavɨci ha nama iamɨgali mɨnibɨlɨ iadɨ hɨvɨ hɨsɨŋ vavevave saŋ hɨvɨ hekɨlɨ aba abɨnaŋ agasaŋ hɨji cuvɨlɨŋ lamɨmɨnaŋ aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Lɨci viaŋ iabi avɨli sɨmɨ tulɨ abɨla heŋ ve iahavɨla nameŋ abin uami. Asɨ Iaue nama iadɨ manɨgali Ebɨlam dɨ Asɨ aba abin uami. Nama iadɨ ahɨliahunaŋ iadɨ sibɨla agaŋ huaci iahɨbali aba abin uami. ");
INSERT INTO ena_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Malɨciŋ viaŋ avɨli sɨmɨ tulɨ mikɨ lagulama hɨnidin aba abin uami. Iamɨgali mɨnibɨlɨ mu avɨli liciben aba veci viaŋ nameŋ abɨben aba abin uami. Nadɨ avɨli sɨji iasaŋ igunaŋ nacɨhulɨŋ aba abɨben aba abin uami. ");
INSERT INTO ena_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Abɨlɨŋ alia nɨha aba abɨbali aba abin uami. Lɨnaŋ nadɨ sabaŋ kamelɨ agɨlasaŋ avi igulɨŋ navɨbali aba abɨbali aba abin uami. Hameŋ abɨci viaŋ hɨji nameŋ lamɨben aba abin uami. Iamɨgali nudɨ ala iadɨ manɨgali agadɨ ninaŋ agasaŋ lɨbɨmɨŋahanaŋ aba abɨben aba abin uami. ");
INSERT INTO ena_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Viaŋ hɨji hɨvɨ Asɨ dɨ aba aba hɨnidalɨŋ Lebeka agaŋ nudɨ fɨli sɨji macɨŋ sabɨ hɨvɨ lamavɨla avɨli liciben aba ve uami. Vevɨla avɨli sɨmɨ tulɨ hɨvɨ mɨgua liciavɨla iahɨci abin uami. Iasaŋ avɨli igunaŋ nacɨhulɨŋ aba abin uami. ");
INSERT INTO ena_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Lɨlɨŋ avɨli sɨji agadɨ lɨhalɨha mɨŋamɨga mɨŋalɨva hɨnihɨni abi uami. Nɨha aba abi uami. Lɨnaŋ nadɨ sabaŋ kamelɨ agɨlasaŋ avi igulɨŋ navɨbali aba abi uami. Lɨci viaŋ nɨlɨŋ nɨbu iadɨ sabaŋ kamelɨ agɨlasaŋ avi iguci navi uami. ");
INSERT INTO ena_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Lɨhavɨci viaŋ nudɨ abitɨhin uami. Nadɨ iagana ani aba abin uami. Lɨlɨŋ nɨbu abi uami. Iadɨ iavaŋ nɨbu Betuelɨ aba abi uami. Betuelɨ dɨ iaganu nɨbu Naholɨ aba abi uami. Betuelɨ dɨ iamɨnu nɨbu Milɨka aba abi uami. Lɨci viaŋ luvɨŋ agadɨ nudɨ mugaŋ sɨmɨ hɨvɨ lamin uami. Human lavi ahica agɨladɨ avi nudɨ human limu limu hɨvɨ iahu lamin uami. ");
INSERT INTO ena_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","La hali lɨbuhɨlavɨla cɨhu Asɨ Iaue dɨ ibi mɨŋaiahɨben aba mɨgalɨfɨlɨbavɨla abin uami. Viaŋ Asɨ Iaue dɨ ibi mɨŋaiahin aba abin uami. Iadɨ manɨgali agadɨ Asɨ agaŋ iadɨ via neŋ vave aba abin uami. Iadɨ manɨgali Ebɨlam dɨ imanu agadɨ ulaŋ hɨvɨ vave aba abin uami. Lɨci viaŋ nudɨ ajinu dɨ via uben aba abin uami. Via ulɨŋ iadɨ manɨgali agadɨ ninaŋ agaŋ nudɨ sabibali aba abin uami. ");
INSERT INTO ena_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Alialaŋ uami. Namɨlaŋ iadɨ manɨgali agasaŋ mavɨn hɨniavɨla akuaba akuaba lɨlɨ saŋ abalɨ hameŋ laci lɨben aba ha iadɨ sɨhɨvia sɨbaŋ abɨhalaŋ uami. Hɨma aba abɨlaŋ viaŋ naludɨ vala uben uami. ");
INSERT INTO ena_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Lɨci Laban hula Betuelɨ hula cɨhu abavɨmi. Asɨ Iaue nukeŋ sibɨla vi agadɨ alaŋ cɨhu akuaba akuaba ciaŋ ma abɨbalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Lebeka ha hɨnidi uavɨmi. Viavɨla uha uavɨmi. Lɨnaŋ nadɨ manɨgali agadɨ ninaŋ agaŋ nudɨ sabim uavɨmi. Asɨ Iaue abalɨ hameŋ laci ala lɨm uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Hameŋ abavɨci Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agaŋ Asɨ Iaue dɨ ibi mɨŋaiahɨben aba fɨli hɨvɨ mɨgalɨfɨlɨbami. ");
INSERT INTO ena_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","La akuaba akuaba huaci huaci lɨba silɨva lɨba golɨ hɨvɨ vihavɨmi agɨladɨdaŋ hadi hɨlahɨla huaci huaci limu hɨhɨle agɨladɨdaŋ Lebeka saŋ igumi. Akuaba akuaba huaci huaci limu hɨhɨle agɨladɨ avi Lebeka amunu sadaŋ iamɨnu sadaŋ igumi. ");
INSERT INTO ena_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ciaŋ aba fɨhalavɨla Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agaŋ hulaŋ limu hɨhɨle nɨbu hula vehavɨmi agɨlaŋ hula sɨmɨŋ navɨla ani hɨsɨvavɨmi. La cimɨdaŋ sɨbaŋ iahavɨla Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agaŋ abami. Iadɨ valɨlaŋ viaŋ cɨhu iadɨ manɨgali agadɨ pɨŋ uben uami. ");
INSERT INTO ena_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Hameŋ abɨci Lebeka amunu hula iamɨnu hula abavɨmi. Vana iamɨgali mɨnibɨlɨ agaŋ alaŋ hula hɨnimitavɨla uaiaŋ human limu fɨhala human limu ahica pam cɨjɨŋ akua uci ahila ubali uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Lɨhavɨci cɨhu Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agaŋ abami. Sibɨla viaŋ vilɨŋ Asɨ Iaue ahɨliahuci huaci li sadaŋ iadɨ valɨlaŋ iadɨ manɨgali agadɨ pɨŋ cɨhu uben uami. Iadɨ abamɨgɨlɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Hameŋ abɨci abavɨmi. Alaŋ iamɨgali mɨnibɨlɨ agadɨ ulɨmɨli veci abitɨha igɨmɨli uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","La Lebeka dɨ ulavɨci vemi. Veci abitɨhavɨmi. Nama hulaŋ nagaŋ hula huaci ubanaŋ uavɨmi. Lɨhavɨci abami. Uben uami. ");
INSERT INTO ena_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Lɨci Lebeka dɨdaŋ iamɨgali mu nudɨ migɨladami agadɨdaŋ abavɨci Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agaŋ hula uavɨmi. Hɨmamɨgɨlɨ daŋ agadɨ sibɨla pam hɨsɨŋ agɨlaŋ avi ahuata hameŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Uben aba lɨhavɨdaci Lebeka dɨ huaci lamɨben aba abavɨmi. Nama mufɨli ninanadi akape sɨbaŋ huhɨlɨbanaŋ uavɨmi. Lɨnaŋ nadɨ iamɨlɨhalina agɨlaŋ iaha habɨla hulaŋ nulɨdɨ nagɨli lamavɨbali agɨlaŋ hula sagaŋ lɨbavɨla nulɨdɨ lɨvalavɨbali uavɨmi. La nulɨdɨ haiabɨla agɨladɨ vihavɨbali uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Hameŋ abavɨci Lebeka hula nudɨ sibɨla hɨsɨŋ iamɨgali agɨlaŋ hula Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agaŋ hula vebalu aba sabaŋ kamelɨ sabɨ hɨvɨ iahua mɨgahɨniavɨmi. Mɨgahɨniavɨci Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agaŋ nulɨdɨ viavɨla vemi. ");
INSERT INTO ena_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Viavɨla vemi hadɨhu Aisakɨ agaŋ Lahailoi avɨli sɨmɨ tulɨ agadɨ vala vemi. Vala vevɨla Negevɨ fɨli tɨbɨ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Mu tɨbɨ hɨfɨlɨdaŋ lɨdaci mɨda hɨvɨ hɨdami. Hɨdahɨda igɨci sabaŋ kamelɨ agɨlaŋ vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Vevɨla Lebeka agaŋ Aisakɨ dɨ igoua igavɨla sabaŋ kamelɨ valavɨla fɨli mɨgami. ");
INSERT INTO ena_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","La Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agadɨ abitɨhami. Hana akɨ hulaŋ aludɨ pɨŋ vedi uami. Lɨci Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agaŋ abami. Ha iadɨ manɨgali uami. Lɨci Lebeka agaŋ havɨlɨ tɨbɨ viavɨla nudɨ nukeŋ mugaŋ lamɨgaŋ hafilɨbami. ");
INSERT INTO ena_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Lɨci Ebɨlam dɨ hɨmamɨgɨlɨ daŋ agaŋ akuaba akuaba lɨmi agasaŋ Aisakɨ dɨ sulami. ");
INSERT INTO ena_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Sula fɨhalɨci Aisakɨ agaŋ Lebeka dɨ viavɨla iamɨnu Sela dɨ havɨlɨ ulaŋ heŋ via ua lamami. Lavɨla nusaŋ mavɨn hekɨlɨ hɨniavɨla nudɨ sabimi. Vaka Aisakɨ agaŋ iamɨnu Sela hɨmɨci humɨgaŋ vɨhɨlɨ vimi. Agadɨ ala Lebeka dɨ sabici nudɨ mavɨn mɨgumi. ");
INSERT INTO ena_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ebɨlam agaŋ iamɨgali mu sabimi. Nudɨ ibi Ketula. ");
INSERT INTO ena_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketula dɨ ninadinu agɨladɨ ibi nameŋ. Mu Simɨlan. Mu Jokɨsan. Mu Medan. Mu Midian. Mu Isɨbakɨ. Mu Suahɨ. ");
INSERT INTO ena_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokɨsan nɨbu Seba dɨ Dedan dɨ iaganɨlu. Dedan nɨbu hɨdɨlɨ nameŋ agɨladɨ iamɨlɨnɨlu. Mu Aculɨ hɨdɨlɨ. Mu Letusɨ hɨdɨlɨ. Mu Leum hɨdɨlɨ. ");
INSERT INTO ena_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian dɨ ninadinu agɨladɨ ibi nameŋ. Mu Efa. Mu Efelɨ. Mu Hanokɨ. Mu Abida. Mu Elɨda. Hulaŋ agɨlaŋ Ketula dɨ ninadinu ajihalinu iamɨlɨhalinu. ");
INSERT INTO ena_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ebɨlam agaŋ nudɨ akuaba akuaba agɨladɨ ninanu Aisakɨ saŋ igu igu saŋ abami. ");
INSERT INTO ena_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Agadɨ ala nɨbu hɨhi hɨnihɨni akuaba akuaba limu hɨhɨle agɨladɨ nudɨ iamɨgali hɨvɨ agɨladɨ ninaŋ agɨlasaŋ igumi. Iguavɨla abɨci fɨli tɨbɨ uaiaŋ iahaiaha kɨlikɨli heŋ uavɨmi. Ninanu Aisakɨ dɨ mikɨ pɨŋ hɨniavɨmɨdɨ uavɨla abɨci uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ebɨlam dɨ hualɨ lugɨlavɨci ua 175 iahami. ");
INSERT INTO ena_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Lɨci nɨbu hadi hadi sɨbaŋ lavɨla hɨjɨŋalaŋala hɨniavɨla hɨmami. Hɨmɨci nudɨ amɨŋ agaŋ uavɨla nudɨ iamɨlɨhalinu dɨ amɨŋ hɨniavɨhadami heŋ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Hɨmɨci nudɨ ninaŋ ahica Aisakɨ hula Isɨmaelɨ hula nudɨ lɨba haca Makɨpela fɨli tɨbɨ hɨniadami heŋ hudavɨmi. Makɨpela fɨli tɨbɨ ha Mamɨle haiabɨla mikɨ hɨniadami. Vaka Ebɨlam agaŋ Sohalɨ dɨ ninaŋ Efɨlon saŋ anɨm hɨlɨcɨ iguavɨla fɨli tɨbɨ lɨba haca daŋ agadɨ vimi. Sohalɨ nɨbu Hitɨ hɨdɨlɨ. Viavɨla abinu Sela dɨ valɨ agadɨ lɨba haca heŋ ala hudami. Lɨci Aisakɨ hula Isɨmaelɨ hula Ebɨlam dɨ valɨ agadɨ avi heŋ laci ala hudavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ebɨlam hɨmɨci Asɨ agaŋ Ebɨlam dɨ ninaŋ Aisakɨ dɨ huaci lamami. Lɨci Lahailoi avɨli sɨmɨ tulɨ heŋ ua hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Isɨmaelɨ nɨbu Ebɨlam dɨ ninaŋ. Iamɨnu Hega nɨbu Isipɨ fɨli tɨbɨ hɨsɨŋ. Nɨbu Sela dɨ sibɨla hɨsɨŋ iamɨgali hɨniadami. Isɨmaelɨ dɨ ninadinu ajihalinu iamɨlɨhalinu agɨladɨ ibi nameŋ. ");
INSERT INTO ena_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Isɨmaelɨ dɨ ninaŋ Nebaiotɨ nɨbu Cimegeŋ. Nɨbu limu cimɨla igɨci Kedalɨ. Kedalɨ limu cimɨla igɨci Atɨbelɨ. Atɨbelɨ limu cimɨla igɨci Mipɨsam. ");
INSERT INTO ena_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mipɨsam limu cimɨla igɨci Misɨma. Misɨma limu cimɨla igɨci Duma. Duma limu cimɨla igɨci Masa. ");
INSERT INTO ena_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Masa limu cimɨla igɨci Hadatɨ. Hadatɨ limu cimɨla igɨci Tema. Tema limu cimɨla igɨci Jetulɨ. Jetulɨ limu cimɨla igɨci Nafisɨ. Nafisɨ limu cimɨla igɨci Kedema. ");
INSERT INTO ena_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Isɨmaelɨ dɨ ninaŋ human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ agɨlaŋ latɨhavɨla hɨdɨlɨ hɨtɨŋ hɨtɨŋ agɨladɨ manɨgali hɨnihɨni fɨli tɨbɨ hɨtɨŋ hɨtɨŋ haiabɨla hɨtɨŋ hɨtɨŋ agɨladɨ migɨlavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isɨmaelɨ dɨ hualɨ lugɨlavɨci ua 137 iahɨci heŋ hɨmami. Hɨmɨci nudɨ amɨŋ agaŋ uavɨla nudɨ iamɨlɨhalinu dɨ amɨŋ hɨniavɨhadami heŋ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Isɨmaelɨ dɨ iamɨlɨhalinu agɨlaŋ fɨli tɨbɨ hɨniavɨhadami agadɨ valɨ limu ha Havila fɨli tɨbɨ hɨniadami. Limu ha Solɨ haiabɨla hɨniadami. Solɨ haiabɨla nɨbu Isipɨ fɨli tɨbɨ mikɨ hɨniadami. Asilia fɨli tɨbɨ saŋ uu kɨlikɨli heŋ hɨniadami. Isɨmaelɨ dɨ iamɨlɨhalinu agɨlaŋ huaci pam ma hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Aisakɨ akuaba akuaba lɨmi agadɨ ciaŋ nɨbu nameŋ. Ebɨlam agaŋ Aisakɨ dɨ havami. ");
INSERT INTO ena_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Lɨci hualɨ 40 uci Aisakɨ agaŋ Lebeka dɨ sabimi. Lebeka dɨ iaganu Betuelɨ. Betuelɨ dɨ ninaŋ Laban. Nɨbɨlaŋ Alam hɨdɨlɨ. Nɨbɨlaŋ Mesopotemia fɨli tɨbɨ hɨsɨŋ hulaŋ iamɨgali. ");
INSERT INTO ena_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Aisakɨ abinu Lebeka nɨbu uajɨ hɨdadami. Lɨci Aisakɨ agaŋ nudɨ abinu dɨ ahɨliahuiahu saŋ Asɨ Iaue dɨ abami. Lɨci Asɨ Iaue agaŋ igahɨlavɨla Lebeka dɨ huaci lamɨci humɨgaŋ ahɨlami. ");
INSERT INTO ena_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Lɨci ninaŋ ahica Lebeka dɨ humɨgaŋ hɨvɨ hɨnihɨni ifahɨla ifahɨla iahavɨmi. Lɨhavɨdaci Lebeka agaŋ abami. Akɨ saŋ vɨhɨlɨ igadin uami. La hɨdɨlɨ igɨben aba Asɨ Iaue dɨ aba aba hɨnihɨni hɨsɨŋ fipɨ heŋ umi. ");
INSERT INTO ena_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Uavɨla aba aba hɨnidaci Asɨ Iaue agaŋ Lebeka dɨ abami. Ci igɨnaŋ uami. Ninaŋ ahica huhɨlɨnaŋ cɨhu latɨhavɨla hɨdɨlɨ hɨtɨŋ hɨtɨŋ hɨniavɨbali uami. Hɨdɨlɨ mu agɨlaŋ vɨdɨvɨdɨŋ daŋ hɨnihɨni hɨdɨlɨ mu agɨladɨ lɨvalavɨbali uami. Ninaŋ hali huhɨlɨbanaŋ agaŋ nɨbu ninaŋ sɨvɨ huhɨlɨbanaŋ agadɨ lɨhu hɨvɨ hɨnihɨni nudɨ sibɨla hɨsɨŋ hulaŋ hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Lɨci hɨnimitavɨla Lebeka agaŋ ninaŋ ahica huhɨlɨben aba lɨmi. ");
INSERT INTO ena_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","26","Ninaŋ hali hɨsɨŋ agadɨ huhɨlɨdaci sɨvɨ hɨsɨŋ agaŋ humɨgaŋ hɨvɨ hɨnihɨni isanu dɨ hɨcɨ sulɨm agadɨ mɨŋalɨvami. Lɨci iaganu agaŋ nudɨ ibi lamavɨla abami. Jekopɨ uami. Ninaŋ sebɨlɨ huhɨlami agaŋ hadi mɨnɨ kuakua hɨnimi. La nudɨ hadipɨlɨ agaŋ avi mɨdɨ amɨŋ hɨnimi. Lɨci nudɨ ibi lamavɨla abavɨmi. Iso uavɨmi. Hadɨhu ala Aisakɨ dɨ hualɨ lugɨlavɨci ua 60 iahami. ");
INSERT INTO ena_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ninaŋ ahica agɨlaŋ hekɨlɨ lɨhavɨmi. La Iso nɨbu sɨhɨm sabaŋ ifɨsuhɨla nana hɨsɨŋ hulaŋ hɨniadami. Hameŋ sadaŋ nɨbu sɨhɨm sabaŋ ifɨsuhɨla nana saŋ pam lɨhadami. Jekopɨ nɨbu hulaŋ simɨ hɨniadami. Hameŋ sadaŋ nɨbu uleŋ laci hɨnihɨni sibɨla vihadami. ");
INSERT INTO ena_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisakɨ agaŋ Iso saŋ pam mavɨn hekɨlɨ hɨniadami. Iso nɨbu sɨhɨm sabaŋ ifɨdaci nana hɨjɨŋaladami agasaŋ lavɨla nusaŋ pam mavɨn hekɨlɨ hɨniadami. Agadɨ ala Lebeka nɨbu Jekopɨ saŋ pam mavɨn hekɨlɨ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","30","Mu tɨbɨ Jekopɨ agaŋ ume mɨdɨ mɨdɨ hugɨlami. Lɨdaci Iso agaŋ hɨbɨ hɨdavɨla cɨhu uleŋ vemi. Ve humɨgaŋ saŋ hɨmavɨla Jekopɨ dɨ abami. Viaŋ humɨgaŋ saŋ hekɨlɨ hɨmadin uami. Iasaŋ ume mɨdɨ mɨsɨ agadɨ iguha uami. Iso dɨ ibi mu lamavɨmi ha Idom. Ume mɨdɨ mɨsɨ igu igu saŋ abami sadaŋ ibi hameŋ lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Lɨci Jekopɨ abami. Nama ninaŋ magɨlasiŋ agadɨ akuaba akuaba agɨladɨ iasaŋ igu igu saŋ abɨnaŋ uami. Ha viaŋ ume mɨdɨ mɨsɨ agadɨ hɨbɨŋ nasaŋ iguben uami. ");
INSERT INTO ena_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Lɨci Iso abami. Alia uami. Viaŋ sɨmɨŋ saŋ amɨŋ ci hɨmɨben aba lin uami. Ninaŋ magɨlasiŋ agadɨ akuaba akuaba agɨlaŋ iadɨ ma ahɨliahuavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Lɨci Jekopɨ abami. Ninaŋ magɨlasiŋ agadɨ akuaba akuaba agɨladɨ iasaŋ igu igu saŋ abavɨla uami. Ha nama hɨvɨ hekɨlɨ aba abɨha uami. Lɨci Iso abami. Hɨvɨ hekɨlɨ uami. Hɨvɨ hekɨlɨ uavɨla ninaŋ magɨlasiŋ agadɨ akuaba akuaba agɨladɨ Jekopɨ saŋ igumi. ");
INSERT INTO ena_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Lɨci Jekopɨ agaŋ Iso saŋ maci daŋ ume mɨsɨ daŋ iguci nami. Navɨla iaha vala umi. Iso agaŋ ninaŋ magɨlasiŋ agadɨ akuaba akuaba agɨlasaŋ hɨji ma igahɨlami. ");
INSERT INTO ena_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Mu tɨbɨ humɨgaŋ ibɨlibɨliŋ hekɨlɨ agaŋ Kenan fɨli tɨbɨ iahami. Vaka Ebɨlam hɨnidaci iahami hameŋ ala iahami. Lɨci Aisakɨ agaŋ Abimelekɨ dɨ pɨŋ umi. Abimelekɨ agaŋ Gelalɨ haiabɨla hɨnihɨni Filisɨtia hɨdɨlɨ agɨladɨ migɨladami. ");
INSERT INTO ena_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Lɨdaci Asɨ Iaue agaŋ Aisakɨ dɨ hɨvɨ iaha abami. Nama Isipɨ fɨli tɨbɨ umɨnaŋ uami. Fɨli tɨbɨ viaŋ nadɨ abeba hɨnihɨni saŋ abɨben heŋ laci hɨniha uami. ");
INSERT INTO ena_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Fɨli tɨbɨ neŋ hɨnidanaŋ viaŋ nama hula hɨniben uami. La nadɨ huaci lamɨben uami. Fɨli tɨbɨ agɨladɨ sɨkasɨkan nasadaŋ nadɨ iamɨlɨhalina agɨlasadaŋ iguben uami. Viaŋ nadɨ iagana Ebɨlam dɨ ci abamin uami. Hɨvɨ hekɨlɨ aba abamin agasaŋ igahɨlavɨla iguben uami. ");
INSERT INTO ena_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","5","Iagana Ebɨlam agaŋ iadɨ ciaŋ igahɨladami uami. Viaŋ akuaba akuaba saŋ abadamin agɨladɨ hameŋ laci ala lɨhadami uami. Akuaba akuaba ciaŋ vɨdɨvɨdɨŋ agɨladɨdaŋ akuaba akuaba ciaŋ iguadamin agɨladɨdaŋ lubiahɨladami uami. Akuaba akuaba ciaŋ lamalubiadamin agɨladɨ avi hameŋ laci ala lubiahɨladami uami. Hameŋ sadaŋ viaŋ nadɨ iamɨlɨhalina dɨ lɨlɨŋ iaha habɨlavɨla lidɨ uaiaŋ susu hɨvɨ hɨniavɨlalɨ hameŋ ala hɨniavɨdaci fɨli tɨbɨ nagɨladɨ nulɨsaŋ sɨkasɨkan iguben uami. Viaŋ nadɨ iamɨlɨhalina agɨlasaŋ igahɨlahɨla hulaŋ iamɨgali hɨdɨlɨ mu mu fɨli neŋ hɨniavɨlalɨ agɨladɨ sɨkasɨkan huaci lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Lɨci Aisakɨ agaŋ Gelalɨ haiabɨla hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Hɨnidaci hulaŋ haiabɨla heŋ hɨsɨŋ agɨlaŋ Aisakɨ abinu saŋ abitɨhavɨhadami. Abitɨhavɨdaci Aisakɨ agaŋ abadami. Viaŋ nudɨ amunu uadami. Aisakɨ igɨci nudɨ abinu dɨ mugaŋ lamɨgaŋ agaŋ huaci sɨbaŋ hɨniadami. Lɨdaci hɨji nameŋ lamadami. Nɨbu iadɨ iamɨgali aba abɨlɨŋ ha iadɨ ifɨhɨmavɨbali uadami. Ifɨhɨmavɨla iadɨ iamɨgali agadɨ vihavɨbali uadami. Hameŋ hɨji lama lɨdavɨla nameŋ abadami. Viaŋ nudɨ amunu uadami. ");
INSERT INTO ena_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Lavɨla fɨli tɨbɨ heŋ hutesɨ tagɨlaŋ daŋ hɨniadami. Hɨnidaci mu tɨbɨ Filisɨtia hɨdɨlɨ agɨladɨ manɨgali Abimelekɨ agaŋ nudɨ ulaŋ hɨvɨ hɨnihɨni huŋe uu veve hɨbɨ mikɨ lagulamavɨla igoua igɨdaci Aisakɨ agaŋ nudɨ abinu Lebeka dɨ mɨŋalɨvami. ");
INSERT INTO ena_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Lɨci Abimelekɨ agaŋ hulaŋ mu dɨ abɨci uavɨla Aisakɨ dɨ abɨci veci abami. Viaŋ ci igin uami. Iamɨgali nana nadɨ iamɨgali sɨbaŋ uami. Nama akɨ saŋ analɨ abɨlanaŋ uami. Viaŋ iamɨgali agadɨ amunu aba abɨlanaŋ uami. Lɨci Aisakɨ agaŋ abami. Viaŋ hɨji nameŋ lamɨlan uami. Nɨbu iadɨ iamɨgali aba abɨlɨŋ ha hulaŋ limu hɨhɨle agɨlaŋ iadɨ ifɨhɨmavɨbali akua aba hɨji lamɨlan uami. ");
INSERT INTO ena_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Lɨci Abimelekɨ agaŋ cɨhu ala abami. Nama aludɨ akɨ saŋ hameŋ abɨlanaŋ uami. Hulaŋ mu iadɨ hɨdɨlɨ pam agɨlaŋ nadɨ iamɨgali hula hɨdavɨci ha alaŋ hugɨ daŋ hɨnivɨlu uami. Agadɨ ala hugɨ agadɨ iaganu ha nama nukeŋ lɨnaŋ aludɨ hɨvɨ iahɨvi uami. ");
INSERT INTO ena_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","La cɨhu Abimelekɨ agaŋ nudɨ hulaŋ iamɨgali agɨladɨ ciaŋ vɨdɨvɨdɨŋ abami. Hulaŋ mu agaŋ Aisakɨ tamaŋ dɨ lusɨŋ sɨbɨlɨ vihavɨci ha viaŋ abɨlɨŋ nudɨ ifɨhɨmavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Asɨ Iaue agaŋ Aisakɨ dɨ huaci lamɨci Aisakɨ agaŋ nudɨ hualabɨla heŋ halɨha cahu uitɨ hɨlɨcɨ pabiŋ lɨdɨŋ pabiŋ lɨdɨŋ havalami. Havalɨci hualɨ heŋ ala halɨha cahu uitɨ hɨdɨlɨ hɨtɨŋ hɨtɨŋ agɨlaŋ hɨlɨcɨ 100 100 lɨdɨŋ lamavɨmi. La halɨha cahu uitɨ hɨlɨcɨ havalami agɨladɨ lɨvala akape sɨbaŋ iahavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Lɨhavɨci anɨm hɨlɨcɨ hekɨlɨ likɨlami. La nɨbu hulaŋ hekɨlɨ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Nɨbu sabaŋ sipsipɨ sabaŋ bulɨmakau akape daŋ hɨniadami. Nudɨ sibɨla hɨsɨŋ hulaŋ avi akape hɨniavɨhadami. Hɨniavɨdaci Filisɨtia hɨdɨlɨ agɨlaŋ Aisakɨ saŋ humɨgaŋ vɨhɨlɨ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Lavɨla avɨli sɨmɨ tulɨ Ebɨlam dɨ sibɨla hɨsɨŋ hulaŋ agɨlaŋ vaka mavavɨmi heŋ fɨli caŋ ahɨlavɨci ahɨlavɨci mɨguavɨmi. Lɨhavɨci avɨli sɨmɨ tulɨ agɨlaŋ sataiahaiaha apalɨ me hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Lɨhavɨci cɨhu Abimelekɨ agaŋ Aisakɨ dɨ abami. Namɨlaŋ hulaŋ akape sɨbaŋ hɨnihɨni aludɨ lɨvalɨlaŋ uami. Namɨlaŋ aludɨ valavɨla uhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Lɨci Aisakɨ agaŋ fɨli tɨbɨ agadɨ valavɨla umi. Uavɨla Gelalɨ avɨli makaŋ caba heŋ havɨlɨ ulaŋ hafiavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Vaka Ebɨlam agaŋ abɨci avɨli sɨmɨ tulɨ agɨladɨ mavavɨmi. Lɨhavɨci Ebɨlam agaŋ hɨmɨci cɨhu hulaŋ Filisɨtia hɨdɨlɨ agɨlaŋ avɨli sɨmɨ tulɨ agɨladɨ hɨvɨ fɨli caŋ ahɨlavɨdaci mɨgumɨgu sɨjiavɨmi. Lɨhavɨci Aisakɨ agaŋ abɨci avɨli sɨmɨ tulɨ agɨladɨ cɨhu mavavɨmi. Lɨhavɨci iaganu Ebɨlam ibi vaka lamami hameŋ ala ibi lamami. ");
INSERT INTO ena_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Mu tɨbɨ Aisakɨ dɨ sibɨla hɨsɨŋ hulaŋ agɨlaŋ avɨli sɨmɨ tulɨ mu avɨli makaŋ caba heŋ mavavɨmi. Mavavɨci avɨli agaŋ vubɨlɨm daŋ vubɨlɨm daŋ iahami. ");
INSERT INTO ena_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Lɨci Gelalɨ haiabɨla hɨsɨŋ hulaŋ sɨhɨm sabaŋ akuaba akuaba migɨlavɨhadami agɨlaŋ hula Aisakɨ dɨ sibɨla hɨsɨŋ hulaŋ sɨhɨm sabaŋ akuaba akuaba migɨlavɨhadami agɨlaŋ hula lamacilavɨhadami. Lamacilacila abavɨhadami. Avɨli sɨmɨ tulɨ ha aludɨ uavɨhadami. Lɨhavɨdaci Aisakɨ agaŋ avɨli sɨmɨ tulɨ agadɨ ibi lamavɨla abami. Lamacilacila hɨsɨŋ avɨli sɨmɨ tulɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Lɨci Aisakɨ dɨ sibɨla hɨsɨŋ hulaŋ agɨlaŋ avɨli sɨmɨ tulɨ mu mavavɨmi. Mavavɨci cɨhu hameŋ laci ala lamacilavɨmi. Lɨhavɨci Aisakɨ agaŋ avɨli sɨmɨ tulɨ agadɨ ibi lamavɨla abami. Nagɨli lamalama hɨsɨŋ avɨli sɨmɨ tulɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Lɨci Aisakɨ dɨ sibɨla hɨsɨŋ hulaŋ agɨlaŋ mu abɨla hɨvɨ uavɨla avɨli sɨmɨ tulɨ mu cɨhu ala mavavɨmi. Mavavɨci hulaŋ agɨlaŋ ma lamacilavɨmi. Lɨhavɨci Aisakɨ agaŋ avɨli sɨmɨ tulɨ agadɨ ibi lamavɨla abami. Huaci mɨgahɨnihɨni hɨsɨŋ avɨli sɨmɨ tulɨ uami. Aisakɨ agaŋ hɨji nameŋ igahɨlami. Asɨ Iaue agaŋ alusaŋ fɨli tɨbɨ hekɨlɨ iguci alaŋ neŋ huaci hɨnihɨni habɨlɨbalu uami. ");
INSERT INTO ena_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Lavɨla fɨli tɨbɨ agadɨ vala uavɨla Belɨseba avɨli sɨmɨ tulɨ heŋ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ua hɨnidaci hɨfɨlɨ heŋ ala Asɨ Iaue agaŋ Aisakɨ dɨ hɨvɨ iahavɨla abami. Viaŋ nadɨ iagana Ebɨlam dɨ Asɨ uami. Nama lɨdɨmɨnaŋ uami. Viaŋ nama hula hɨnilan uami. Viaŋ iadɨ sibɨla hɨsɨŋ hulaŋ Ebɨlam saŋ igahɨlavɨla nadɨ huaci lamɨben uami. Viaŋ lɨlɨŋ nadɨ ajihalina iamɨlɨhalina agɨlaŋ iaha habɨlavɨla akape lɨhavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Lɨci Aisakɨ agaŋ heŋ ala sagalɨ hɨlahɨla hɨsɨŋ lɨba vadɨm mu ibilami. Ibilavɨla Asɨ Iaue dɨ ibi luvɨla luvɨla nudɨ ibi mɨŋaiahami. Lavɨla havɨlɨ ulaŋ hafiavɨla hɨnihɨni nudɨ sibɨla hɨsɨŋ hulaŋ agɨlaŋ avɨli sɨmɨ tulɨ mu mavavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimelekɨ agaŋ nudɨ hulaŋ ahica agɨlaŋ hula Gelalɨ haiabɨla valavɨla Aisakɨ dɨ pɨŋ uavɨmi. Mu Ahusatɨ. Ahusatɨ nɨbu nusaŋ hɨji igu igu hɨsɨŋ hulaŋ hɨniadami. Mu Fikolɨ. Fikolɨ nɨbu nudɨ sagaŋ hali hɨsɨŋ hulaŋ hɨniadami. Ahica pam nɨbɨlaŋ hameŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ua iahuavɨci Aisakɨ nulɨdɨ abami. Vaka namɨlaŋ aludɨ abacabɨlavɨla aludɨ lahulaŋ naludɨ valavɨla vehɨlu uami. La cɨhu iabi neŋ aludɨ pɨŋ akɨ saŋ velaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","29","Lɨci abavɨmi. Alaŋ igɨmɨli Asɨ Iaue agaŋ nama hula hɨnilalɨ uavɨmi. Alaŋ nama hula ciaŋ mɨguavɨla aba aba saŋ nadɨ pɨŋ velu uavɨmi. Alaŋ nadɨ sɨbɨlɨ ma lamahɨlu uavɨmi. Alaŋ nadɨ huaci sɨbaŋ lamahɨlu uavɨmi. Nama aludɨ vala vehanaŋ ha alaŋ nadɨ valɨmɨli nadɨ humɨgaŋ agaŋ simɨ hɨnidaci vehanaŋ uavɨmi. Ve hɨnidanaŋ Asɨ Iaue agaŋ nadɨ huaci lamɨlalɨ uavɨmi. Nama ciaŋ mɨguavɨla nameŋ abɨha uavɨmi. Hɨvɨ hekɨlɨ aba abɨha uavɨmi. Viaŋ naludɨ sɨbɨlɨ ma lamɨben aba abɨha uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Lɨhavɨci Aisakɨ agaŋ nulɨsaŋ sɨmɨŋ hekɨlɨ hɨlanɨci navɨmi. ");
INSERT INTO ena_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","La ani hɨsɨvavɨci mɨŋalahɨci cimɨdaŋ sɨbaŋ iahavɨla ciaŋ mɨguavɨla abavɨmi. Hɨvɨ hekɨlɨ uavɨmi. Alaŋ hudɨmɨda cɨhu huaci hɨnibalu uavɨmi. Lavɨla Aisakɨ agaŋ nulɨsaŋ lamulɨdaci nulɨdɨ humɨgaŋ agɨlaŋ simɨ hɨniavɨdaci Aisakɨ dɨ vala vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Vala vehavɨdaci Aisakɨ dɨ sibɨla hɨsɨŋ hulaŋ agɨlaŋ vevɨla nudɨ abavɨmi. Alaŋ avɨli sɨmɨ tulɨ mu mavɨmɨli avɨli ci iahi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Lɨhavɨci Aisakɨ avɨli sɨmɨ tulɨ agadɨ ibi lamavɨla abami. Siba uami. Lɨci hɨniavɨci hutesɨ lɨci Aisakɨ ibi lamami agasaŋ igahɨlavɨla via ua haiabɨla vaka heŋ hɨniadami agadɨ ibi lamavɨla abavɨhadami. Belɨseba uavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Iso dɨ hualɨ lugɨlavɨci ua 40 iahɨci nɨbu iamɨgali ahica sabimi. Mu Juditɨ. Juditɨ dɨ iaganu Beli. Beli ha Hitɨ hɨdɨlɨ. Mu Basematɨ. Basematɨ dɨ iaganu Elon. Elon avi Hitɨ hɨdɨlɨ. ");
INSERT INTO ena_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Iso abinadinu agɨlaŋ lusɨŋ sɨbɨlɨ vihavɨdaci Aisakɨ tamaŋ humɨgaŋ vɨhɨlɨ hekɨlɨ hekɨlɨ vihavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Aisakɨ hadi hadi sɨbaŋ lɨci nudɨ lamɨgaŋ hɨfɨlɨ mɨgɨci akuaba akuaba ma igami. Lavɨla nudɨ sibɨla hɨsɨŋ hulaŋ agadɨ abɨci uavɨla nudɨ ninaŋ manɨgali Iso dɨ abɨci veci abami. Ninaŋ uami. Lɨci Iso agaŋ abami. Viaŋ nan hɨnidin uami. ");
INSERT INTO ena_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Lɨci Aisakɨ abami. Viaŋ ci hadi hadi lin uami. Viaŋ ma igin uami. Abadɨhuba hɨmɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Nadɨ hɨmi siaŋ viavɨla saua uha uami. Uavɨla iasaŋ sɨhɨm huliavɨla vaveha uami. ");
INSERT INTO ena_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Vave sɨhɨm akuaba akuaba huaci huaci viaŋ nana saŋ mavɨn hɨnilan hameŋ agɨladɨ hɨla iasaŋ vavenaŋ nɨlɨŋ uami. Lavɨla nadɨ sijaŋ huaci lamavɨla ala hɨmɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Lɨci Iso agaŋ iaganu saŋ sɨhɨm viben aba saua umi. Aisakɨ hula Iso hula ciaŋ abavɨdaci Lebeka agaŋ nɨfɨlɨ igahɨlami. ");
INSERT INTO ena_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Igahɨla ua ninanu mu Jekopɨ dɨ abami. Ci igɨnaŋ uami. Viaŋ igahɨlɨdalɨŋ nadɨ iagana Aisakɨ agaŋ isana Iso dɨ nameŋ abi uami. ");
INSERT INTO ena_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Sɨhɨm akuaba akuaba huaci huaci agɨladɨ hɨla vavenaŋ nɨlɨŋ aba abi uami. Navɨla Asɨ Iaue igɨdaci nadɨ sijaŋ huaci lamavɨla ala heŋ hɨmɨben aba abi uami. ");
INSERT INTO ena_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ninaŋ uami. Iadɨ ciaŋ sɨhɨvia igahɨlavɨla viaŋ abɨben agadɨ hameŋ laci lɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Sabaŋ meme hɨniavɨlalɨ heŋ uavɨla sabaŋ meme ninaŋ hekɨlɨ hekɨlɨ huaci huaci ahica agɨladɨ viavɨla iadɨ pɨŋ vaveha uami. Vavenaŋ viaŋ sɨhɨm akuaba akuaba huaci huaci iagana nana saŋ mavɨn hɨnilalɨ hameŋ agɨladɨ hɨlɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Lɨlɨŋ via uavɨla iagana saŋ igunaŋ nɨbali uami. Navɨla nadɨ huaci lamavɨla ala hɨmam uami. ");
INSERT INTO ena_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Lɨci Jekopɨ agaŋ iamɨnu dɨ abami. Nama igɨlanaŋ uami. Iso nɨbu hadi mɨnɨ kuakua uami. Viaŋ hɨma uami. ");
INSERT INTO ena_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Iavaŋ iadɨ hadipɨlɨ mɨŋaigavɨla abɨbali uami. Ha nama iadɨ analɨ akua abɨben aba lɨnaŋ aba abɨbali uami. La iadɨ sɨbɨlɨ igavɨla huaci ma lamɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Lɨci iamɨnu agaŋ abami. Ninaŋ uami. Igahɨlɨmɨnaŋ uami. Viaŋ nukeŋ nasaŋ hɨji iguin sadaŋ nɨbu iadɨ sɨbɨlɨ igɨbali uami. Nama viaŋ abin hameŋ lɨha uami. Ua sabaŋ meme ahica ahica vaveha uami. ");
INSERT INTO ena_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Lɨci Jekopɨ ua sabaŋ meme ahica viavɨla iamɨnu dɨ pɨŋ vavemi. Vaveci sɨhɨm akuaba akuaba huaci huaci Jekopɨ iaganu nana saŋ mavɨn hɨniadami agɨladɨ hɨlami. ");
INSERT INTO ena_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Hɨlanavɨla Iso dɨ hadi hɨlahɨla huaci huaci iamɨnu dɨ havɨlɨ ulaŋ hɨvɨ hɨniavɨhadami agɨladɨ viavɨla Jekopɨ dɨ hɨvɨ lamami. ");
INSERT INTO ena_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Lamavɨla cɨhu sabaŋ meme sɨgɨtɨ agɨladɨ viavɨla Jekopɨ dɨ human agɨladɨ hɨvɨ hahami. La sugɨtaŋ hɨvɨ avi hahami. ");
INSERT INTO ena_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Hahɨci ci lɨci sɨhɨm akuaba akuaba huaci huaci maci daŋ hɨlami agɨladɨ Jekopɨ saŋ igumi. ");
INSERT INTO ena_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Iguci Jekopɨ agaŋ viavɨla ua iaganu dɨ abami. Iavaŋ uami. Lɨci iaganu abami. Ninaŋ viaŋ nan hɨnidin uami. Nama ani uami. ");
INSERT INTO ena_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Lɨci Jekopɨ abami. Viaŋ Iso nadɨ ninaŋ manɨgali uami. Akuaba akuaba abɨnaŋ agadɨ viaŋ ci sɨhuvin uami. Iaha sɨhɨm hɨhɨle vaven nagɨladɨ navɨla iadɨ huaci lamɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Lɨci Aisakɨ cɨhu abami. Ninaŋ uami. Sɨhɨm agadɨ akɨ la vivɨhenaŋ uami. Lɨci Jekopɨ abami. Nadɨ Asɨ Iaue agaŋ iadɨ ahɨliahuci sɨhɨm nagadɨ vivɨhen uami. ");
INSERT INTO ena_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Lɨci Aisakɨ Jekopɨ dɨ abami. Iadɨ mikɨ pɨŋ venaŋ nadɨ hadipɨlɨ mɨŋaigɨlɨŋ uami. Nama iadɨ ninaŋ Iso ua hɨma uami. ");
INSERT INTO ena_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Lɨci Jekopɨ iaganu dɨ mikɨ pɨŋ uci nudɨ hadipɨlɨ sɨhɨvia mɨŋaigavɨla abami. Nama Jekopɨ me ciaŋ abɨnaŋ uami. Agadɨ ala nadɨ human agɨladɨ mɨŋaigɨlɨŋ Iso dɨ human me hɨniavi uami. ");
INSERT INTO ena_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Jekopɨ dɨ human agɨladɨ iamɨnu agaŋ sabaŋ meme sɨgɨtɨ hɨvɨ hahɨci mɨnɨ kuakua Iso dɨ human mɨnɨ me hɨniavɨmi. Lɨci Aisakɨ agaŋ Jekopɨ nudɨ analɨ abami agadɨ ma igami. Lavɨla nudɨ huaci lamɨben aba lɨmi. ");
INSERT INTO ena_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","La cɨhu nudɨ abitɨhami. Amɨŋ sɨbaŋ nama iadɨ ninaŋ Iso uami. Lɨci Jekopɨ abami. Iavaŋ viaŋ nukeŋ ala uami. ");
INSERT INTO ena_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Lɨci Aisakɨ abami. Sɨhɨm limu cɨkaŋ vavenaŋ navɨla nadɨ huaci lamɨben uami. Lɨci Jekopɨ Aisakɨ saŋ sɨhɨm igunami. La lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨ avi iguci nami. ");
INSERT INTO ena_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Navɨla abami. Ninaŋ uami. Mikɨ neŋ vevɨla iadɨ mɨhum iavɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Lɨci Jekopɨ Aisakɨ dɨ mikɨ pɨŋ uavɨla nudɨ mɨhum iavami. Lɨci Aisakɨ agaŋ hɨdɨlɨ igɨben aba hadi hɨlahɨla Jekopɨ lama hɨdami agadɨ sɨmɨlaigɨci Iso dɨ hadi hɨsi iahami. Lɨci nudɨ huaci lamavɨla abami. Nadɨ hadi hɨsi ci igin uami. Iadɨ ninaŋ dɨ hadi hɨsi huaci nagaŋ Asɨ Iaue hualɨ mu huaci lamɨci hualabɨla hɨsɨŋ sɨmɨŋ mɨdɨ lɨhua hɨsi huaci iahɨlalɨ hameŋ iahi uami. ");
INSERT INTO ena_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Asɨ hamu cɨbɨ abɨci mɨgɨbali uami. La fɨli tɨbɨ nama hɨnibanaŋ agadɨ huaci lamɨci nadɨ hualabɨla agɨladɨ hɨvɨ sɨmɨŋ isabɨlaŋ huaci huaci iahavɨbali uami. Iahavɨdaci nama halɨha cahu uitɨ akape vibanaŋ uami. Lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ avi hekɨlɨ hekɨlɨ vibanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Hulaŋ iamɨgali haiabɨla mu hɨsɨŋ mu hɨsɨŋ agɨlaŋ nadɨ sibɨla hɨsɨŋ hɨniavɨbali uami. Hulaŋ iamɨgali fɨli tɨbɨ mu hɨsɨŋ mu hɨsɨŋ agɨlaŋ nadɨ ibi mɨŋaiahɨben aba nadɨ mikɨ pɨŋ mɨgalɨfɨlɨbavɨbali uami. Nama manɨgali hɨnihɨni nadɨ imahalina agɨladɨ migɨlɨbanaŋ uami. Nadɨ hɨdɨlɨ pam agɨlaŋ nadɨ lɨhu hɨvɨ hɨniavɨbali uami. Hulaŋ nama vɨhɨlɨ iga iga saŋ Asɨ dɨ abavɨci Asɨ lɨci nɨbɨlaŋ nukeŋ vɨhɨlɨ igavɨbali uami. Hulaŋ Asɨ nadɨ huaci lamalama saŋ abavɨci nulɨdɨ avi huaci lamɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aisakɨ agaŋ Jekopɨ dɨ huaci lamɨci umi. Udaci Jekopɨ isanu Iso cicɨ hɨdavɨla cɨhu vemi. ");
INSERT INTO ena_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Vevɨla nɨbu avi sɨmɨŋ huaci hɨla iaganu saŋ vavemi. Vavevɨla abami. Iavaŋ uami. Iaha sɨhɨm hɨhɨle vaven nagɨladɨ navɨla iadɨ huaci lamɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Lɨci Aisakɨ abami. Nama ani uami. Lɨci Iso abami. Viaŋ Iso nadɨ ninaŋ manɨgali uami. ");
INSERT INTO ena_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Lɨci Aisakɨ agaŋ hekɨlɨ lɨdavalavala abami. Ani agaŋ sɨhɨm mu ifɨhɨma hɨla iasaŋ vaveiemi uami. Nama ma ve iahɨdanaŋ ci niemin uami. La viaŋ nudɨ ci huaci lamiemin uami. Huaci lamavɨla abiemin agaŋ hameŋ laci hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Lɨci Iso igahɨlavɨla humɨgaŋ vɨhɨlɨ viavɨla ilɨha ilɨha abami. Iavaŋ uami. Iadɨ avi huaci lamɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Lɨci Aisakɨ abami. Viaŋ nadɨ huaci lamalama saŋ abɨlɨŋ ala nadɨ imana agaŋ iadɨ analɨ abɨci nudɨ ci huaci lamiemin uami. ");
INSERT INTO ena_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Lɨci Iso abami. Iamɨga iadɨ mɨse huhɨlami uami. Agadɨ ala Jekopɨ ninaŋ manɨgali me iadɨ uvɨsɨjiŋ vilɨ uami. La cɨhu nama iadɨ huaci lamalama saŋ abiemɨnaŋ agadɨ ala nɨbu ve nadɨ analɨ abɨci nudɨ ci huaci lamiemɨnaŋ uami. Vaka ninaŋ magɨlasiŋ agadɨ akuaba akuaba agɨladɨ vilɨ hameŋ ala iabi avi liemi uami. Lɨci nudɨ ibi Jekopɨ agaŋ hulaŋ mu agaŋ hulaŋ mu dɨ hɨnikuavɨla nudɨ uvɨsɨjiŋ vivi ibi hɨni uami. Iavaŋ uami. Iadɨ avi huaci lamɨvanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Lɨci Aisakɨ Iso dɨ abami. Ci igɨnaŋ uami. Viaŋ imana dɨ ci lɨbɨmɨŋin uami. Nɨbu nadɨ manɨgali hɨnibali uami. Nudɨ isaima agɨlaŋ nudɨ sibɨla hɨsɨŋ hɨniavɨbali uami. Nɨbu halɨha cahu uitɨ akape daŋ hɨnibali uami. Lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ hekɨlɨ daŋ hɨnibali uami. Ninaŋ uami. Akɨakɨ mu agɨlaŋ hɨniavɨci nasaŋ avi igu igu saŋ nadɨ abɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Lɨci Iso agaŋ iaganu dɨ abitɨhami. Iavaŋ uami. Nama ninadina dɨ pabiŋ tɨbɨ laci huaci lamɨvanaŋ uami. Iadɨ avi huaci lamɨha uami. Hameŋ abavɨla cɨhu hekɨlɨ ilɨhami. ");
INSERT INTO ena_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Lɨci Aisakɨ nudɨ abami. Ci igɨnaŋ uami. Nadɨ haiabɨla fɨli huaci ma hɨnibali uami. Hamu cɨbɨ nadɨ hualabɨla hɨvɨ ma mɨgɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Nama sɨmɨŋ nana huaci mɨgahɨnihɨni saŋ puia hutesɨ hɨvɨ sagaŋ hɨdɨbanaŋ uami. La imana dɨ sibɨla hɨsɨŋ hulaŋ hɨnibanaŋ uami. Agadɨ ala mufɨli nudɨ lɨhu hɨvɨ hɨnihɨni saŋ valavɨla nudɨ lɨvalɨnaŋ nɨbu nadɨ manɨgali ma hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Lɨci Iso agaŋ iaganu Jekopɨ dɨ huaci lamami agasaŋ igahɨlɨci nudɨ igɨvɨ lɨmi. Lɨci hɨji nameŋ lamami. Iadɨ iavaŋ amɨŋ ci hɨmɨbali uami. Hɨmɨci alaŋ ilɨhɨbalu uami. Ilɨhɨmɨli ci lɨci viaŋ Jekopɨ dɨ ifɨhɨmɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Hɨji hameŋ lamavɨla abɨci hulaŋ limu hɨhɨle igahɨlavɨla uavɨla Lebeka dɨ abavɨmi. Lɨhavɨci Lebeka agaŋ hulaŋ mu dɨ abɨci uavɨla Jekopɨ dɨ abɨci veci abami. Igahɨlɨha uami. Nama isana Iso dɨ uvɨsɨjiŋ vinaŋ agasaŋ nudɨ igɨvɨ hɨma sɨbaŋ lɨci nadɨ ifɨhɨmuhɨmu saŋ abi uami. Nadɨ ifɨhɨmuhɨmu hɨji agaŋ muji hɨnidaci sabɨ pam simɨ hɨnidi uami. ");
INSERT INTO ena_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ninaŋ uami. Viaŋ abɨben hameŋ lɨha uami. Nama iahavɨla haŋɨla ua iadɨ amu Laban hula Halan haiabɨla hɨniha uami. ");
INSERT INTO ena_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","45","Ua nɨbu hula hɨnidanaŋ isana dɨ humɨgaŋ agaŋ simɨ lɨbali uami. Lɨci nama nudɨ akuaba akuaba lɨhanaŋ agasaŋ hɨji vala uavauava lavɨla igɨvɨ apalɨ hɨnibali uami. Lɨci viaŋ hulaŋ mu dɨ abɨlɨŋ ua nadɨ abɨci nɨbu hula vebanaŋ uami. Nama neŋ hɨninaŋ nadɨ ifɨhɨmɨci hulaŋ mu nadɨ ahɨliahua nudɨ ifɨhɨmɨbali uami. Lɨci viaŋ iadɨ ninaŋ ahica naludɨ iabi me laci valɨmagaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","La hɨnia Lebeka agaŋ Aisakɨ dɨ abami. Iso agaŋ iamɨgali Hitɨ hɨdɨlɨ agɨladɨ sabici viaŋ vɨhɨlɨ igɨlan uami. Hameŋ sadaŋ viaŋ Jekopɨ avi iamɨgali Hitɨ hɨdɨlɨ fɨli tɨbɨ neŋ hɨniavɨlalɨ agɨladɨ vivi saŋ valin uami. Iamɨgali Hitɨ hɨdɨlɨ agadɨ sabici viaŋ huaci ma hɨniben uami. ");
INSERT INTO ena_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Lɨci Aisakɨ agaŋ Jekopɨ dɨ abɨci veci nudɨ huaci lamavɨla ciaŋ vɨdɨvɨdɨŋ iguavɨla abami. Nama Kenan fɨli tɨbɨ hɨsɨŋ iamɨgali vimɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Nama Mesopotemia fɨli tɨbɨ uavɨla Betuelɨ dɨ ulaŋ heŋ hɨniha uami. Betuelɨ nɨbu iamɨna dɨ iaganu uami. La ahuana Laban dɨ nadi mu sabiha uami. ");
INSERT INTO ena_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Asɨ vɨdɨvɨdɨŋ hekɨlɨ daŋ agaŋ nadɨ huaci lamavɨla nasaŋ ninanadi akape igubali uami. Iguci habɨla nadɨ iamɨlɨhalina agɨlaŋ hɨdɨlɨ akape hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Asɨ Ebɨlam dɨ huaci lamami hameŋ laci ala nadɨdaŋ nadɨ iamɨlɨhalina agɨladɨdaŋ huaci lamɨbali uami. Lɨci fɨli tɨbɨ ihɨlɨŋ ve hɨnidanaŋ nagadɨ vibanaŋ uami. Asɨ agaŋ fɨli tɨbɨ nagadɨ Ebɨlam saŋ igumi uami. ");
INSERT INTO ena_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Aisakɨ hameŋ abavɨla Jekopɨ dɨ abɨci Mesopotemia fɨli tɨbɨ Laban dɨ hɨvɨ umi. Laban nɨbu Betuelɨ ninanu. Betuelɨ nɨbu Alam hɨdɨlɨ. Laban nɨbu Lebeka dɨ amunu. Lebeka ha Jekopɨ dɨ Iso dɨ iamɨnɨlu. ");
INSERT INTO ena_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","7","Aisakɨ agaŋ Jekopɨ dɨ hameŋ abɨci hulaŋ hɨhɨle igahɨlavɨla ua Iso dɨ abavɨmi. Aisakɨ agaŋ Jekopɨ dɨ huaci lamavɨla ciaŋ vɨdɨvɨdɨŋ iguavɨla nameŋ abalɨ uavɨmi. Kenan fɨli tɨbɨ hɨsɨŋ iamɨgali vimɨnaŋ aba abalɨ uavɨmi. Mesopotemia fɨli tɨbɨ uavɨla heŋ hɨsɨŋ iamɨgali viha aba abalɨ uavɨmi. Hameŋ abɨci Jekopɨ agaŋ iamiaganu dɨ ciaŋ igahɨlavɨla Mesopotemia fɨli tɨbɨ ci ualɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Lɨhavɨci Iso igahɨlɨci nudɨ hɨji heŋ tovemi. Toveci abami. Amɨŋ ala iadɨ iavaŋ Kenan fɨli tɨbɨ hɨsɨŋ iamɨgali saŋ vali uami. ");
INSERT INTO ena_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Lavɨla Isɨmaelɨ dɨ hɨvɨ uavɨla iamɨgali mu sabimi. Iamɨgali agadɨ ibi Mahalatɨ. Nudɨ amunu Nebaiotɨ. Iaganɨlu Isɨmaelɨ. Iauacanɨlu Ebɨlam. ");
INSERT INTO ena_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jekopɨ agaŋ Belɨseba avɨli sɨmɨ tulɨ agadɨ valavɨla Halan haiabɨla saŋ umi. ");
INSERT INTO ena_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Udaci uaiaŋ mɨguci hɨbɨ cina heŋ hɨsɨvami. Lɨba mu agadɨ viavɨla nudɨ hali sagualavɨla hɨsɨvami. ");
INSERT INTO ena_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Hɨsɨvavɨla anisɨhu hɨvɨ ulaŋ hɨbɨ iahuiahu mɨgamɨga me agadɨ igami. Hɨdɨlɨ nudɨ fɨli hɨnimi. Hɨvɨhɨvɨ nudɨ iahua Asɨ dɨ haiabɨla hɨnimi. Lɨci Asɨ dɨ ciaŋ hali hɨsɨŋ agɨlaŋ hɨbɨ heŋ mɨgamɨga iahuiahu hɨdavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Lɨhavɨdaci Asɨ Iaue agaŋ Jekopɨ dɨ mikɨ pɨŋ lagulamavɨla abami. Viaŋ Asɨ Iaue uami. Viaŋ iauacana Ebɨlam dɨ Asɨ uami. Viaŋ iagana Aisakɨ dɨ Asɨ uami. Fɨli hɨsɨvadanaŋ agadɨ viaŋ nasadaŋ nadɨ iamɨlɨhalina agɨlasadaŋ iguben uami. ");
INSERT INTO ena_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Nadɨ iamɨlɨhalina agɨlaŋ akape sɨbaŋ iaha habɨla hacɨŋ hɨlɨcɨ me hɨniavɨbali uami. La latɨhavɨla hɨhɨle uaiaŋ iahaiaha kɨlikɨli uavɨbali uami. Hɨhɨle uaiaŋ mɨgumɨgu kɨlikɨli uavɨbali uami. Hɨhɨle ium kɨlikɨli uavɨbali uami. Hɨhɨle lakulamaŋ kɨlikɨli uavɨbali uami. Viaŋ nasadaŋ nadɨ iamɨlɨhalina agɨlasadaŋ igahɨlavɨla hɨdɨlɨ mu mu fɨli neŋ hɨniavɨlalɨ agɨladɨ avi huaci lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ci igɨnaŋ uami. Nama abeba abeba ubanaŋ ha viaŋ nama hula hɨnihɨni nadɨ migɨlɨben uami. La nadɨ cɨhu neŋ vaveben uami. Viaŋ nadɨ ma valɨben uami. Akuaba akuaba abin agɨlaŋ hameŋ laci ala lɨhavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jekopɨ agaŋ anisɨhu igavɨla iaha abami. Amɨŋ ala uami. Asɨ Iaue neŋ hɨnilalɨ agadɨ viaŋ ma igɨmaŋ lavɨla neŋ hɨsɨvin uami. ");
INSERT INTO ena_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","La lɨdavɨla abami. Viaŋ uvɨ nagasaŋ lɨdadin uami. Na Asɨ dɨ hɨnihɨni hɨsɨŋ uvɨ uami. Na Asɨ dɨ haiabɨla hɨbɨ ivu ivu ivaveve me uami. ");
INSERT INTO ena_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","La cɨhu hɨsɨvavɨla cimɨdaŋ sɨbaŋ iahami. Iahavɨla lɨba hali saguala ani hɨnimi agadɨ mɨŋaiaha lalɨlamami. Uvɨ heŋ ala Asɨ dɨ igami agadɨ hɨji mɨŋaiahaiaha saŋ lalɨlamami. La lɨba agaŋ Asɨ dɨ nukeŋ lɨba hɨnibali aba kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨ lɨba agadɨ sabɨ hɨvɨ mɨŋamɨjimi. ");
INSERT INTO ena_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Mɨŋamɨjiavɨla fipɨ agadɨ ibi lamavɨla abami. Betelɨ uami. Vaka haiabɨla heŋ hɨniadami agadɨ ibi Lusɨ. ");
INSERT INTO ena_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","La Jekopɨ ciaŋ mɨgua Asɨ Iaue dɨ abami. Nama viaŋ hula hɨnihɨni iadɨ migɨlɨdanaŋ hɨbɨ hutesɨ agadɨ hɨdɨben uami. Hɨdɨdalɨŋ iasaŋ muhɨlɨ havɨlɨ sɨmɨŋ akuaba akuaba agɨladɨ igubanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Lɨnaŋ viaŋ iadɨ iavaŋ dɨ pɨŋ cɨhu ve iaha huaci hɨnilɨŋ ha Asɨ Iaue nama iadɨ Asɨ hɨnibanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Lɨba nagadɨ ci mɨŋaiaha lalɨlamin uami. Lɨba nagaŋ neŋ hɨnidaci uvɨ nagaŋ nadɨ hɨnihɨni hɨsɨŋ uvɨ hɨnibali uami. Akuaba akuaba iasaŋ igubanaŋ agɨladɨ human limu limu fɨhala mɨguŋ lamɨben uami. Lamɨlɨŋ hɨniavɨdaci labɨlavɨla pabiŋ mɨguŋ nasaŋ iguben uami. ");
INSERT INTO ena_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","La Jekopɨ agaŋ uavɨla hulaŋ iamɨgali uaiaŋ iahaiaha kɨlikɨli hɨsɨŋ agɨladɨ fɨli tɨbɨ heŋ umi. ");
INSERT INTO ena_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ua mɨda hɨvɨ iahua lagulama igasula igɨci sabaŋ sipsipɨ ahica pam hɨdɨlɨ agɨlaŋ avɨli sɨmɨ tulɨ mikɨ heŋ mɨgalɨfɨlɨba hɨniavɨmi. Avɨli sɨmɨ tulɨ agadɨ lɨba hekɨlɨ hɨvɨ hafilamavɨdaci hɨniadami. Sabaŋ sipsipɨ migɨlavɨhadami agɨlaŋ avɨli sɨmɨ tulɨ heŋ ala sabaŋ sipsipɨ agɨlasaŋ avɨli igunavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Sabaŋ sipsipɨ hɨdɨlɨ mu mu agɨlaŋ ahuata veve mɨgudɨbavɨhadami. Mɨgudɨbalɨba hɨniavɨdaci hulaŋ sabaŋ sipsipɨ migɨlavɨhadami agɨlaŋ lɨba agadɨ mɨŋalitapalavɨdaci udaci sabaŋ sipsipɨ agɨlasaŋ avɨli igunavɨhadami. Sabaŋ sipsipɨ agɨlaŋ avɨli navɨdaci ci lɨdaci hulaŋ sabaŋ sipsipɨ migɨlavɨhadami agɨlaŋ lɨba agadɨ cɨhu mɨŋalitapalavɨdaci vedaci avɨli sɨmɨ tulɨ agadɨ hafilamavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Sabaŋ sipsipɨ agɨlaŋ mɨgalɨfɨlɨba hɨniavɨdaci Jekopɨ agaŋ hulaŋ sabaŋ sipsipɨ migɨlavɨhadami agɨladɨ abitɨhami. Namɨlaŋ abeŋ hɨsɨŋ uami. Lɨci abavɨmi. Alaŋ Halan haiabɨla hɨsɨŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Lɨhavɨci abami. Namɨlaŋ Naholɨ ajinu Laban dɨ igɨlalaŋ uami. Lɨci abavɨmi. Alaŋ nudɨ igɨlalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Lɨhavɨci cɨhu abami. Laban huaci hɨnidi uami. Lɨci abavɨmi. Nɨbu huaci hɨnidi uavɨmi. Igɨha uavɨmi. Leselɨ agaŋ nudɨ iaganu Laban dɨ sabaŋ sipsipɨ agɨlaŋ hula vehavadi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Lɨhavɨci abami. I uami. Uaiaŋ hekɨlɨ vakala hɨnidi uami. Alaŋ uaiaŋ nameŋ hɨnidaci lɨhalɨha sabaŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ lua muji hɨvɨ ma lamɨlalu uami. Namɨlaŋ avɨli igunavɨla cɨhu via ulaŋ humɨsɨ navɨm uami. ");
INSERT INTO ena_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Lɨci hulaŋ sabaŋ sipsipɨ migɨlavɨhadami agɨlaŋ abavɨmi. Eke uavɨmi. Alaŋ hameŋ ma lɨlalu uavɨmi. Sabaŋ sipsipɨ hɨdɨlɨ mu mu ahuata mɨgudɨbavɨdaci alaŋ lɨba agadɨ mɨŋalitapalɨdamɨli udaci sabaŋ sipsipɨ agɨlasaŋ avɨli heŋ igunɨlalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Hameŋ abavɨci Jekopɨ agaŋ nɨbɨlaŋ hula ciaŋ abɨdaci Leselɨ agaŋ vemi. Nɨbu iaganu dɨ sabaŋ sipsipɨ agɨladɨ migɨladami sadaŋ nulɨdɨ likɨla vavemi. ");
INSERT INTO ena_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Likɨla vave iahɨci igavɨla Jekopɨ agaŋ uavɨla lɨba avɨli sɨmɨ tulɨ hɨvɨ hɨnimi agadɨ mɨŋalitapalɨci umi. Lɨci nudɨ ahuanu Laban dɨ sabaŋ sipsipɨ agɨlasaŋ avɨli igunami. ");
INSERT INTO ena_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Igunavɨla uavɨla ilɨha ilɨha hɨjɨŋalaŋala Leselɨ dɨ mɨhum iavami. ");
INSERT INTO ena_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Lavɨla Leselɨ dɨ abami. Viaŋ Lebeka dɨ ninaŋ uami. Iagana ha iadɨ ahuaŋ uami. Lɨci Leselɨ haŋɨla haŋɨla ua iaganu dɨ abami. ");
INSERT INTO ena_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Lɨci Laban agaŋ nudɨ inu vemi agadɨ ciaŋ igahɨlavɨla nudɨ pɨŋ haŋɨla haŋɨla uavɨla inu Jekopɨ dɨ mɨŋahubɨhaha nudɨ mɨhum iavami. La nudɨ ulaŋ hɨvɨ via uci Jekopɨ agaŋ akuaba akuaba iahami agɨladɨ Laban dɨ hɨvɨ sula fɨhalami. ");
INSERT INTO ena_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Sula fɨhalɨci Laban agaŋ abami. Amɨŋ sɨbaŋ uami. Viaŋ nadɨ iamɨna hula iavaŋ pabiŋ laci uami. Lɨci Jekopɨ agaŋ ahuanu hula avaŋ pabiŋ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Jekopɨ agaŋ sibɨla vivi hɨnidaci avaŋ pabiŋ uci Laban agaŋ nudɨ abami. Nama iadɨ iui sɨbaŋ sadaŋ sibɨla havɨ havɨ vimɨnaŋ uami. Nama iadɨ abɨha uami. Sibɨla vivi hɨnidanaŋ viaŋ nasaŋ akɨakɨ iguben uami. ");
INSERT INTO ena_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban nɨbu nadi ahica daŋ hɨniadami. Lea ha Cimam. Leselɨ ha Iagɨvam. ");
INSERT INTO ena_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea nɨbu mugaŋ lamɨgaŋ huaci tagɨlaŋ daŋ agadɨ ala Leselɨ nɨbu mugaŋ lamɨgaŋ huaci sɨbaŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Lɨci Jekopɨ agaŋ Leselɨ saŋ mavɨn hekɨlɨ hɨniavɨla Laban dɨ abami. Viaŋ hualɨ human limu fɨhala human limu ahica cɨjɨŋ nadɨ sibɨla vilɨŋ nadɨ nadi Leselɨ dɨ igunaŋ huaci sabivin uami. ");
INSERT INTO ena_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Lɨci Laban agaŋ abami. Ha huaci uami. Viaŋ nudɨ nasaŋ iguben uami. Hulaŋ mu saŋ ma iguben uami. Nama viaŋ hula hɨniha uami. ");
INSERT INTO ena_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Lɨci Jekopɨ Leselɨ dɨ viben aba hualɨ human limu fɨhala human limu ahica cɨjɨŋ sibɨla vivi hɨnimi. Jekopɨ Leselɨ saŋ mavɨn hekɨlɨ hɨnimi sadaŋ hualɨ human limu fɨhala human limu ahica cɨjɨŋ agadɨ igɨci uaiaŋ akape me ma hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Hualɨ human limu fɨhala human limu ahica cɨjɨŋ agaŋ uci Jekopɨ agaŋ Laban dɨ abami. Sibɨla ci fɨhalin uami. Nadina dɨ iasaŋ igunaŋ sabilɨŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Lɨci Laban agaŋ sɨmɨŋ hekɨlɨ hɨlanami. La hulaŋ iamɨgali ahuata haiabɨla heŋ hɨsɨŋ agɨladɨ abɨci ve navɨmi. ");
INSERT INTO ena_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Nana hɨniavɨdaci hɨfɨlɨ lɨci Laban agaŋ Lea dɨ via ua uvɨ Jekopɨ ani hɨniadami heŋ lamami. Lɨci Jekopɨ Lea hula hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Vaka Laban agaŋ sibɨla hɨsɨŋ iamɨgali mu agadɨ Lea saŋ igumi. Nudɨ ibi Celɨpa. ");
INSERT INTO ena_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Jekopɨ agaŋ Lea hula hɨniavɨla cimɨdaŋ iahavɨla iamɨgali nɨbu hula hɨnimi agadɨ igavɨla i uami. Iamɨgali na Leselɨ hɨma uami. Na Lea uami. La ua Laban dɨ abami. Nama akɨ saŋ iadɨ hameŋ lɨmalamɨnaŋ uami. Viaŋ Leselɨ dɨ vivi saŋ nadɨ sibɨla agadɨ vivi hɨnilan uami. Nama iadɨ akɨ saŋ analɨ abahanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lɨci Laban abami. Eke uami. Alaŋ nameŋ lɨlalu uami. Cimam agaŋ mɨse muŋaŋ iahuci Iagɨvam agaŋ sɨvɨ muŋaŋ iahulalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Lea hula hɨnidanaŋ uaiaŋ human limu fɨhala uci sɨmɨŋ hekɨlɨ nɨmɨli ci lɨci ha alaŋ Leselɨ dɨ avi nasaŋ igubalu uami. Igumɨli hualɨ human limu fɨhala human limu ahica cɨjɨŋ sibɨla cɨhu vivi hɨnibanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Lɨci Jekopɨ agaŋ Laban dɨ ciaŋ agadɨ lubiahɨlavɨla hameŋ laci ala lɨmi. Sɨmɨŋ hekɨlɨ navɨmi agaŋ ci lɨci Laban agaŋ Leselɨ dɨ Jekopɨ saŋ iguci sabimi. ");
INSERT INTO ena_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Vaka Laban agaŋ sibɨla hɨsɨŋ iamɨgali mu agadɨ Leselɨ saŋ igumi. Nudɨ ibi Bilɨha. ");
INSERT INTO ena_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jekopɨ agaŋ Leselɨ hula hɨnimi. La Leselɨ saŋ mavɨn hekɨlɨ hɨnimi. Lea saŋ ma mavɨn hɨnimi. Lavɨla Jekopɨ agaŋ Laban dɨ sibɨla agadɨ vivi hɨnidaci hualɨ human limu fɨhala human limu ahica cɨjɨŋ umi. ");
INSERT INTO ena_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","32","Jekopɨ abinu Leselɨ uajɨ hɨniadami agadɨ ala Jekopɨ nusaŋ pam mavɨn hɨniadami. Asɨ Iaue igɨci Jekopɨ agaŋ Lea saŋ mavɨn ma hɨnimaŋ lɨci Lea dɨ ahɨliahuci humɨgaŋ ahɨlami. La hɨnia Lea agaŋ ninaŋ huhɨlavɨla abami. Iadɨ hulaŋ agaŋ iasaŋ mavɨn ma hɨnilalɨ agadɨ Asɨ Iaue ci igɨlalɨ uami. La ninaŋ nagadɨ iasaŋ igui uami. Lɨci iadɨ hulaŋ agaŋ iasaŋ mavɨn hɨnibali uami. Lavɨla ninaŋ agadɨ ibi lamavɨla abami. Luben uami. ");
INSERT INTO ena_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","La cɨhu humɨgaŋ ahɨla ninaŋ mu huhɨlavɨla abami. Asɨ Iaue igɨci iadɨ hulaŋ agaŋ iasaŋ mavɨn ma hɨnimaŋ lɨci iasaŋ ninaŋ mu cɨhu igui uami. Lavɨla ninaŋ agadɨ ibi lamavɨla abami. Simeon uami. ");
INSERT INTO ena_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","La cɨhu humɨgaŋ ahɨla ninaŋ mu huhɨlavɨla abami. Viaŋ iadɨ hulaŋ saŋ ninaŋ ahica ci huhɨlacin uami. La iabi ninaŋ nagadɨ huhɨlin uami. Lɨlɨŋ nɨbu iadɨ igavɨla viaŋ hula humɨgaŋ pam hɨnibali uami. Lavɨla ninaŋ agadɨ ibi lamavɨla abami. Livai uami. ");
INSERT INTO ena_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","La cɨhu humɨgaŋ ahɨla ninaŋ mu huhɨlavɨla abami. Iabi Asɨ Iaue dɨ ibi mɨŋaiahɨben uami. La ninaŋ agadɨ ibi lamavɨla abami. Juda uami. Lavɨla cɨhu cɨhu humɨgaŋ ma ahɨlɨmaŋ. ");
INSERT INTO ena_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Leselɨ agaŋ uajɨ hɨnihɨni isanu Lea saŋ humɨgaŋ vɨhɨlɨ viavɨla Jekopɨ dɨ abami. Nama viaŋ hula hɨninaŋ ninanadi daŋ hɨnilɨŋ uami. Hɨma lɨci hɨmɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Lɨci Jekopɨ agaŋ Leselɨ saŋ igɨvɨ hɨniavɨla abami. Asɨ nukeŋ lɨci nama ninaŋ ma huhɨlɨnaŋ uami. Viaŋ Asɨ hɨma uami. Viaŋ akɨ lavɨla nasaŋ ninaŋ iguben uami. ");
INSERT INTO ena_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Lɨci Leselɨ abami. Nama iadɨ sibɨla hɨsɨŋ iamɨgali Bilɨha dɨ viha uami. La nɨbu hula hɨninaŋ nɨbu iasaŋ ninanadi huhɨlam uami. Huhɨlɨci viaŋ ninanadi agɨladɨ numɨganɨlu me hɨniben uami. ");
INSERT INTO ena_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","5","Lavɨla nudɨ sibɨla hɨsɨŋ iamɨgali Bilɨha dɨ Jekopɨ saŋ igumi. Iguci nudɨ abinu me hɨniadami. Hɨniavɨla humɨgaŋ ahɨla ninaŋ huhɨlami. ");
INSERT INTO ena_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Huhɨlɨci Leselɨ abami. Asɨ viaŋ akuaba akuaba lɨlan agɨladɨ igɨci huaci lɨhavi uami. Hameŋ sadaŋ nudɨ abɨlɨŋ iadɨ ciaŋ agadɨ igahɨlavɨla Bilɨha dɨ ahɨliahuci iasaŋ ninaŋ huhɨli uami. La ninaŋ agadɨ ibi lamavɨla abami. Dan uami. ");
INSERT INTO ena_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Lɨci Bilɨha agaŋ cɨhu humɨgaŋ ahɨlavɨla ninaŋ mu huhɨlami. ");
INSERT INTO ena_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Huhɨlɨci Leselɨ abami. Viaŋ iadɨ isaŋ dɨ lɨvalavɨla Asɨ dɨ vɨdɨvɨdɨŋ aba aba hɨnilɨŋ Bilɨha dɨ ahɨliahuci iasaŋ ninaŋ mu ci huhɨli uami. Lavɨla ninaŋ agadɨ ibi lamavɨla abami. Napɨtali uami. ");
INSERT INTO ena_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lɨci Lea agaŋ igavɨla cɨhu humɨgaŋ ma ahɨlɨmaŋ lavɨla nudɨ sibɨla hɨsɨŋ iamɨgali Celɨpa dɨ Jekopɨ saŋ igumi. Iguci Celɨpa Jekopɨ dɨ abinu me hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Lavɨla ninaŋ huhɨlami. ");
INSERT INTO ena_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Huhɨlɨci Lea abami. Cicala uami. Lavɨla ninaŋ agadɨ ibi lamavɨla abami. Gatɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Lɨci Celɨpa cɨhu ninaŋ mu huhɨlami. ");
INSERT INTO ena_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Huhɨlɨci Lea abami. Iabi viaŋ hɨjɨŋalin uami. Lɨlɨŋ iamɨgali agɨlaŋ iadɨ igavɨla nameŋ abavɨbali uami. Samɨguŋ putɨ iamɨgali aba abavɨbali uami. Lavɨla ninaŋ agadɨ ibi lamavɨla abami. Aselɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Halɨha cahu uitɨ agɨlaŋ mɨdɨ lɨhuavɨci ihalahalaha mɨgudɨbavɨmi. Mɨgudɨbavɨdaci Luben avi uavɨla akuaba akuaba cɨki cɨki alaciŋ amɨŋ me agɨladɨ hualabɨla heŋ igami. Igavɨla via numɨgaŋ Lea saŋ vavemi. Vaveci Leselɨ agaŋ Lea dɨ abami. Alaciŋ amɨŋ me nadɨ ninana vaveci igin agɨladɨ hɨhɨle iasaŋ huaci iguvanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lɨci Lea abami. Nama iadɨ hulaŋ agadɨ ci vihanaŋ uami. La malɨciŋ cɨhu alaciŋ amɨŋ me iadɨ ninaŋ vave agɨladɨ avi viben aba lɨnaŋ uami. Lɨci Leselɨ abami. Nama alaciŋ amɨŋ me agɨladɨ iasaŋ iguavɨla iabi hɨfɨlɨ nama Jekopɨ hula hɨnibanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Lɨci hɨfɨlɨdaŋ Jekopɨ agaŋ hualabɨla hɨdavɨla vedaci Lea agaŋ ua nudɨ hɨbɨ cina igavɨla abami. Ci igɨnaŋ uami. Nadɨ viaŋ alaciŋ amɨŋ me iadɨ ninaŋ vaveiemi agɨladɨ hɨvɨ ci laviemin uami. Iabi hɨfɨlɨ alaŋ ahica hɨnibalu uami. Lɨci hɨfɨlɨ heŋ ala Jekopɨ agaŋ Lea hula hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Lɨhavɨci Asɨ agaŋ Lea dɨ ciaŋ igahɨlɨci Lea humɨgaŋ ahɨlami. Lavɨla ninaŋ Ibimaŋ dɨ huhɨlami. ");
INSERT INTO ena_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lavɨla abami. Iadɨ sibɨla hɨsɨŋ iamɨgali agadɨ Jekopɨ saŋ igulɨŋ Asɨ hɨbɨŋ iasaŋ ninaŋ igui uami. La ninaŋ agadɨ ibi lamavɨla abami. Isakalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lavɨla cɨhu humɨgaŋ ahɨlavɨla ninaŋ Sɨlakula dɨ huhɨlami. ");
INSERT INTO ena_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","La abami. Asɨ iasaŋ ninaŋ huaci agadɨ igui uami. Viaŋ ninaŋ human limu fɨhala ci huhɨlacin uami. La iabi ninaŋ nagadɨ huhɨlin uami. Lɨlɨŋ iadɨ hulaŋ agaŋ iadɨ ibi mɨŋaiahɨbali uami. Lavɨla ninaŋ agadɨ ibi lamavɨla abami. Sebulun uami. ");
INSERT INTO ena_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","La cɨhu humɨgaŋ ahɨla nadi huhɨlavɨla nudɨ ibi lamavɨla abami. Daina uami. ");
INSERT INTO ena_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","23","Lɨci Asɨ agaŋ Leselɨ saŋ hɨji lamavɨla nudɨ ciaŋ igahɨlavɨla ahɨliahuci humɨgaŋ ahɨlami. La ninaŋ huhɨlavɨla abami. Asɨ nukeŋ lɨci iabi viaŋ ma sɨhumahɨlɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Viaŋ Asɨ Iaue iasaŋ ninaŋ mu avi igu igu saŋ mavɨn hɨnin uami. Lavɨla ninaŋ agadɨ ibi lamavɨla abami. Josepɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","26","Leselɨ Josepɨ dɨ huhɨlɨci Jekopɨ agaŋ Laban dɨ abami. Viaŋ iamɨgali ninanadi agɨladɨ vivi saŋ sibɨla hekɨlɨ vivi hɨnia fɨhalacin agadɨ nama igahanaŋ uami. Nama iadɨ abɨnaŋ iamɨgali ninanadi agɨladɨ likɨlavɨla iadɨ hɨvɨ ulɨŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Lɨci Laban abami. Vana viaŋ nadɨ mu ciaŋ cɨki abɨben uami. Viaŋ hɨcɨhaŋ hɨvɨ avɨli lula lamavɨla igɨlɨŋ iadɨ mugɨluŋ agaŋ nameŋ abalɨ uami. Jekopɨ nama hula hɨnidaci Asɨ Iaue nadɨ huaci lamɨlalɨ aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Nama iadɨ sɨhɨvia abɨha uami. Sibɨla vivi hɨnidanaŋ viaŋ nasaŋ akɨakɨ iguben uami. Abɨnabɨla nasaŋ iguben uami. ");
INSERT INTO ena_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Lɨci Jekopɨ abami. Nadɨ sibɨla vilan agadɨ nama nukeŋ ci igɨlanaŋ uami. Nadɨ sabaŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ viaŋ sɨhɨvia migɨla migɨla hɨnidalɨŋ iaha habɨla akape lɨhavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Vaka nadɨ sabaŋ mu hɨdɨlɨ mu hɨdɨlɨ akape ma hɨniavɨmi uami. Agadɨ ala viaŋ ve nama hula hɨnidalɨŋ nadɨ sabaŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨlaŋ habɨla akape hɨniavadi uami. Asɨ Iaue iadɨ ahɨliahudaci sibɨla huaci vidalɨŋ nadɨ avi huaci lamɨlalɨ uami. Iabi neŋ iadɨ iamɨgali ninanadi agɨlasaŋ igahɨlavɨla sabaŋ mu hɨdɨlɨ mu hɨdɨlɨ viben aba lin uami. ");
INSERT INTO ena_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Hameŋ abɨci Laban abami. Sibɨla vivi hɨnidanaŋ agasaŋ viaŋ nasaŋ akɨ iguben uami. Lɨci Jekopɨ abami. Viaŋ akuaba akuaba agɨlasaŋ valin uami. Nama iadɨ ciaŋ agadɨ lubiahɨlavɨla viaŋ akuaba akuaba saŋ abɨben agasaŋ alia aba abɨnaŋ uami. Ha sabaŋ sipsipɨ sabaŋ meme agɨladɨ cɨhu migɨla migɨla via hɨdɨdalɨŋ humɨsɨ navɨbali uami. Iadɨ hɨji nameŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Iabi viaŋ ua sabaŋ sipsipɨ sabaŋ meme nadɨ agɨladɨ sɨhɨvia igɨben uami. Igavɨla sibɨla vicin agasaŋ hɨbɨŋ sabaŋ sipsipɨ ninaŋ cɨbɨŋ sabaŋ meme sabaŋ sipsipɨ sihɨ daŋ sihɨ daŋ agɨladɨ viben uami. ");
INSERT INTO ena_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","La sibɨla viben agasaŋ hɨbɨŋ sabaŋ sipsipɨ sabaŋ meme cɨhu hameŋ laci ala viben uami. Vilɨŋ mufɨli ua igɨnaŋ sabaŋ meme sihɨ daŋ sihɨ daŋ sabaŋ sipsipɨ ninaŋ cɨbɨŋ agɨlaŋ laci hɨniavɨci nameŋ abɨbanaŋ uami. Nɨbu ciaŋ sɨhɨvia lubiahɨlɨlalɨ aba abɨbanaŋ uami. Ua igɨnaŋ sabaŋ mu hɨdɨlɨ agɨlaŋ hɨniavɨci nameŋ abɨbanaŋ uami. Nɨbu iadɨ sabaŋ agɨladɨ sɨgɨlɨ vilɨ aba abɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lɨci Laban abami. Huaci uami. Nama abɨnaŋ hameŋ ala lɨmɨli uami. ");
INSERT INTO ena_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","La uaiaŋ heŋ ala Laban agaŋ sabaŋ meme muŋaŋ sihɨ daŋ sihɨ daŋ agɨladɨ vimi. Sabaŋ meme mɨgenaŋ mila sihɨ daŋ sihɨ daŋ agɨladɨ vimi. Sabaŋ sipsipɨ ninaŋ cɨbɨŋ agɨladɨ avi vimi. Lavɨla sabaŋ sipsipɨ sabaŋ meme agɨladɨ via ua mu abɨla hɨvɨ lama migɨla migɨla saŋ ninadinu dɨ abami. ");
INSERT INTO ena_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","La Laban agaŋ nudɨ ninadinu agɨlaŋ hula umi. Nulɨdɨ sabaŋ sipsipɨ sabaŋ meme agɨladɨ likɨla uavɨdaci uaiaŋ pabiŋ uci mu abɨla hɨvɨ iahuavɨmi. Iahuavɨci Jekopɨ agaŋ Laban dɨ sabaŋ sipsipɨ sabaŋ meme limu hɨhɨle agɨladɨ pam migɨladami. ");
INSERT INTO ena_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","La kɨlɨ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ vimi. Viavɨla kɨlɨ lɨmɨ agɨladɨ limu cimɨla cimɨla sɨgɨtɨ ihasalɨdaci umi. Lɨci kɨlɨ lɨmɨ agɨlaŋ sihɨ daŋ sihɨ daŋ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Lɨhavɨci kɨlɨ lɨmɨ agɨladɨ via ua sabaŋ sipsipɨ sabaŋ meme saŋ avɨli lɨba hɨbɨn hɨbɨn hɨvɨ lamavɨhadami agɨladɨ mikɨ pɨŋ heŋ lalɨlamalama umi. Sabaŋ meme avɨli nana saŋ ve igavɨbali aba heŋ lalɨlamalama umi. Sabaŋ meme agɨlaŋ heŋ ala ame iahuavɨhadami agasaŋ igahɨlavɨla kɨlɨ lɨmɨ agɨladɨ via ua lalɨlamalama umi. ");
INSERT INTO ena_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Lɨci sabaŋ meme agɨlaŋ uvɨ heŋ ame iahuavɨdaci ninaŋ sihɨ daŋ sihɨ daŋ huhɨlavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Lɨhavɨdaci Jekopɨ sabaŋ sipsipɨ ninaŋ agɨladɨ likɨla likɨla vivi uu hɨtɨŋ lamɨdaci hɨniavɨhadami. Lamɨdaci hɨniavɨdaci Jekopɨ agaŋ sabaŋ sipsipɨ sabaŋ meme ninaŋ sihɨ daŋ sihɨ daŋ iasaŋ nukeŋ huhɨlavɨbali aba Laban dɨ sabaŋ sipsipɨ sabaŋ meme agɨladɨ mɨŋacimɨla cimɨla lamadami. Mɨŋacimɨla cimɨla lamɨdaci sabaŋ meme sabaŋ sipsipɨ sihɨ daŋ sihɨ daŋ agɨladɨdaŋ cɨbɨŋ agɨladɨdaŋ igasulasula hɨniavɨhadami. Igasulasula hɨnihɨni ame iahuavɨhadami. Hameŋ lɨhavɨdaci sabaŋ sipsipɨ sabaŋ meme ninaŋ ninaŋ sihɨ daŋ sihɨ daŋ agɨladɨ huhɨlavɨdaci nusaŋ nukeŋ vihadami. Vivi lamɨdaci Laban dɨ sabaŋ sipsipɨ sabaŋ meme agɨlaŋ hula pam ma hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Sabaŋ sipsipɨ sabaŋ meme huaci huaci vɨdɨvɨdɨŋ daŋ agɨlaŋ ame iahuben aba lɨhavɨdaci Jekopɨ kɨlɨ lɨmɨ agɨladɨ avɨli lɨba hɨbɨn hɨbɨn hɨvɨ lamavɨhadami agɨladɨ mikɨ pɨŋ heŋ lalɨlamadami. Lɨdaci kɨlɨ lɨmɨ agɨladɨ iga iga ame iahuavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Sabaŋ sipsipɨ sabaŋ meme vɨdɨvɨdɨŋ apalɨ agɨlaŋ ame iahuben aba lɨhavɨdaci kɨlɨ lɨmɨ agɨladɨ ma lalɨlamadami. Lɨdaci Laban dɨ sabaŋ sipsipɨ sabaŋ meme agɨlaŋ vɨdɨvɨdɨŋ apalɨ hɨniavɨhadami. Jekopɨ dɨ agɨlaŋ laci huaci huaci vɨdɨvɨdɨŋ daŋ hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Hameŋ lavɨla Jekopɨ akuaba akuaba akape vimi. Viavɨla sabaŋ sipsipɨ sabaŋ meme sabaŋ kamelɨ sabaŋ donɨki sibɨla hɨsɨŋ hulaŋ iamɨgali akape daŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Laban ninadinu agɨlaŋ Jekopɨ saŋ humɨgaŋ vɨhɨlɨ vivi abavɨhadami. Jekopɨ agaŋ aludɨ iavaŋ dɨ sabaŋ akuaba akuaba sɨkasɨkan viavɨla hɨnidaci iaha habɨlavɨdaci Jekopɨ nɨbu akuaba akuaba akape daŋ hɨnidi uavɨhadami. Hameŋ abavɨdaci Jekopɨ ciaŋ hɨjɨ agadɨ igahɨlami. ");
INSERT INTO ena_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","La igɨci Laban avi vaka nusaŋ mavɨn hɨniadami hameŋ ma lɨmi. ");
INSERT INTO ena_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Lɨci Asɨ Iaue agaŋ Jekopɨ dɨ abami. Nama nadɨ iagana dɨ fɨli tɨbɨ heŋ uavɨla nadɨ hɨdɨlɨ pam agɨlaŋ hula hɨniha uami. Ua hɨnidanaŋ viaŋ nama hula hɨniben uami. ");
INSERT INTO ena_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Lɨci Jekopɨ agaŋ nudɨ sabaŋ sipsipɨ hɨniavɨmi heŋ hɨniavɨla nudɨ sibɨla hɨsɨŋ hulaŋ agadɨ abami. Uavɨla iadɨ iamɨgali ahica Leselɨ dɨdaŋ Lea dɨdaŋ abɨnaŋ ve iadɨ igavɨm uami. ");
INSERT INTO ena_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Abɨci uci ve iahavɨci Jekopɨ abami. Viaŋ igɨlɨŋ naludɨ iaganalu vaka iasaŋ mavɨn hɨniadami hameŋ ma li uami. Agadɨ ala iadɨ iavaŋ dɨ Asɨ agaŋ viaŋ hula hɨni uami. ");
INSERT INTO ena_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Namɨlaŋ igɨlalaŋ uami. Viaŋ naludɨ iaganalu dɨ sibɨla agadɨ vɨdɨvɨdɨŋ sɨbaŋ lagulamalama vilan uami. ");
INSERT INTO ena_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Vidalɨŋ iasaŋ akuaba akuaba hekɨlɨ hekɨlɨ igu igu saŋ abalɨ agadɨ ala ma igualɨ uami. Sudɨme cɨki cɨki pam igualɨ uami. Human limu fɨhala human limu limu ahica limu ahica tɨbɨ hameŋ laci hameŋ laci lalɨ uami. Lɨci ala Asɨ agaŋ nudɨ abamɨgɨlɨci Laban iadɨ ma sɨbɨlɨ lamɨmaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Sebɨlɨ iadɨ abalɨ uami. Sibɨla vidanaŋ sabaŋ meme sihɨ daŋ sihɨ daŋ agɨladɨ nasaŋ pam iguben aba abalɨ uami. Hameŋ abɨci cɨhu sabaŋ meme ninaŋ sihɨ daŋ sihɨ daŋ laci huhɨlavalɨ uami. Lɨhavɨci cɨhu iadɨ abalɨ uami. Eke aba abalɨ uami. Sibɨla vidanaŋ sabaŋ meme lɨfɨleŋ sihɨ sihɨ daŋ agɨladɨ iguben aba abalɨ uami. Lɨci sabaŋ meme ninaŋ lɨfɨleŋ sihɨ sihɨ daŋ laci huhɨlavalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Asɨ agaŋ lɨci sabaŋ meme sihɨ daŋ sihɨ daŋ sabaŋ meme lɨfɨleŋ sihɨ sihɨ daŋ agɨladɨ laci huhɨlavalɨ uami. Lɨhavɨci sabaŋ sipsipɨ sabaŋ meme agɨlaŋ iadɨ laci hɨniavi uami. ");
INSERT INTO ena_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Sabaŋ meme agɨlaŋ ame iahuiahu hɨdavalɨ hadɨhu anisɨhu nameŋ igacin uami. Sabaŋ meme muŋaŋ mu sihɨ mu sihɨ daŋ agɨlaŋ laci sabaŋ meme mɨgenaŋ agɨladɨ ame iahuavɨdaci igacin uami. ");
INSERT INTO ena_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Igɨdalɨŋ anisɨhu hɨvɨ ala Asɨ dɨ ciaŋ hali hɨsɨŋ agaŋ iadɨ abalɨ uami. Jekopɨ aba abalɨ uami. Lɨci viaŋ abacin uami. Viaŋ nan aba abacin uami. ");
INSERT INTO ena_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Lɨlɨŋ abalɨ uami. Igɨha aba abalɨ uami. Laban nadɨ akuaba akuaba lɨlalɨ agadɨ viaŋ ci igin aba abalɨ uami. Lavɨla viaŋ nukeŋ lɨlɨŋ sabaŋ meme muŋaŋ mu sihɨ mu sihɨ daŋ agɨlaŋ laci sabaŋ meme mɨgenaŋ agɨladɨ ame iahuavɨlalɨ aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Asɨ viaŋ ala Betelɨ hɨbɨlɨ mɨgiŋ fipɨ heŋ nadɨ pɨŋ iahamin aba abalɨ uami. Lɨlɨŋ nadɨ hɨji mɨŋaiahaiaha saŋ hɨbɨlɨ mɨgiŋ fipɨ heŋ lɨba mu mɨŋaiaha lalɨlamamanaŋ aba abalɨ uami. Lavɨla kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨ lɨba sabɨ hɨvɨ mɨŋamɨjimanaŋ aba abalɨ uami. La ciaŋ mɨgua iadɨ abamanaŋ aba abalɨ uami. Iabi nama nadɨ akuaba akuaba viavɨla fɨli tɨbɨ nagadɨ valavɨla nadɨ hɨdɨlɨ pam agɨladɨ hɨvɨ cɨhu uha aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","15","Lɨci Leselɨ hula Lea hula ciaŋ agadɨ igahɨlavɨla abavɨmi. Iavaŋ aludɨ valɨci hɨdɨlɨ hɨtɨŋ hɨtɨŋ hɨsɨŋ me hɨnilalu sadaŋ alaŋ aludɨ iavaŋ dɨ akuaba cɨki avi ma vibalu uavɨmi. Akuaba akuaba agɨladɨ hɨvɨ aludɨ lavamanaŋ agadɨ ci fɨhalalɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Asɨ agaŋ aludɨ iavaŋ dɨ akuaba akuaba agɨladɨ nasaŋ igumi ha aludɨ ninanadi agɨlaŋ hula vibalu uavɨmi. Asɨ nadɨ akuaba akuaba saŋ abalɨ agadɨ hameŋ laci ala lɨha uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Lɨhavɨci Jekopɨ agaŋ iaha nudɨ abinadinu nudɨ ninanadinu agɨladɨ vivi sabaŋ kamelɨ agɨladɨ sabɨ hɨvɨ lamami. ");
INSERT INTO ena_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","La nudɨ sibɨla hɨsɨŋ hulaŋ agɨladɨ abɨci sabaŋ sipsipɨ sabaŋ meme sabaŋ mu hɨdɨlɨ mu hɨdɨlɨ Mesopotemia fɨli tɨbɨ hɨnihɨni vihadami agɨladɨ likɨla hali vehavɨmi. Akuaba akuaba hɨniavɨmi agɨladɨ avi viavɨla iaganu Aisakɨ dɨ igɨben aba Kenan fɨli tɨbɨ saŋ vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Veben aba lɨhavɨdaci Laban agaŋ sabaŋ sipsipɨ mɨnɨ ihalahɨben aba umi. Ua hɨnidaci Leselɨ agaŋ kɨlɨ cɨkaŋ mugɨluŋ mugaŋ lamɨgaŋ me iaganu dɨ ulaŋ migɨlavɨhadami agɨladɨ sɨgɨlɨ viavɨla vemi. ");
INSERT INTO ena_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","21","Nudɨ iaganu Laban agaŋ nɨbu Alam hɨdɨlɨ. Jekopɨ nudɨ hɨvɨ veben aba lɨmi agadɨ ala Laban dɨ ma abami. Nɨbu nɨfɨlɨ cɨki akuaba akuaba viavɨla nudɨ abinadinu ninanadinu agɨlaŋ hula haŋɨlavɨmi. Haŋɨlavɨla Laban dɨ haiabɨla agadɨ vala Iufɨletisɨ avɨli makaŋ agadɨ ivave Gileatɨ fɨli tɨbɨ halu daŋ halu daŋ heŋ vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Jekopɨ ani ani agɨlaŋ haŋɨla vehavɨdaci uaiaŋ pabiŋ uci uaiaŋ mu hɨvɨ hulaŋ hɨhɨle ua Laban dɨ abavɨmi. Jekopɨ ci haŋɨla ualɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","24","Abavɨci Laban agaŋ nudɨ hɨdɨlɨ pam Alam hɨdɨlɨ agɨladɨ viavɨla Jekopɨ dɨ sɨvɨ uavɨmi. Uavɨdaci uaiaŋ human limu fɨhala uci Gileatɨ fɨli tɨbɨ halu daŋ halu daŋ heŋ Jekopɨ dɨ mikɨ mikɨ lɨhavɨdaci hɨfɨlɨ lɨmi. Lɨci hɨfɨlɨ heŋ ala Asɨ agaŋ anisɨhu hɨvɨ Laban dɨ hɨvɨ iaha abami. Nama Jekopɨ dɨ abacabɨlɨmɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jekopɨ ani ani agɨlaŋ halu mu hɨvɨ havɨlɨ ulaŋ agɨladɨ hafia hɨniavɨdaci Laban agaŋ Gileatɨ fɨli tɨbɨ heŋ ala halu mu hɨvɨ hɨnia nulɨdɨ igoua igami. La nudɨ hɨdɨlɨ pam agɨlaŋ hula havɨlɨ ulaŋ heŋ hafiavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","La Laban agaŋ Jekopɨ dɨ pɨŋ uavɨla abami. Nama akɨ hɨji viavɨla nɨfɨlɨ haŋɨlahanaŋ uami. Akɨ saŋ viaŋ ma igɨmaŋ lɨdalɨŋ iadɨ nadi ahica agɨladɨ sagaŋ lɨbavɨla vavevave me vavehanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nama akɨ saŋ nɨfɨlɨ cɨki haŋɨlahanaŋ uami. Nama iadɨ vala veben aba iadɨ ma abahanaŋ uami. Nama iadɨ abahanaŋ padaŋ viaŋ iadɨ hɨdɨlɨ pam agɨladɨ abɨlɨŋ hɨbɨmaŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ ifu ifu sɨhɨ iahaiaha hɨniavɨci mɨŋalahɨci hɨjɨŋalaŋala hɨnidamɨli vevanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Iadɨ abahanaŋ padaŋ viaŋ iadɨ nanadi agɨladɨdaŋ iadɨ ajihali agɨladɨdaŋ mɨhum iavavɨla nulɨsaŋ lamulɨdalɨŋ vevanaŋ uami. Nama uava lusɨŋ sɨbaŋ vihanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Viaŋ naludɨ sɨbɨlɨ lamɨben aba velɨŋ ala hɨfɨlɨ nadɨ iagana dɨ Asɨ agaŋ iadɨ abiemi uami. Nama Jekopɨ dɨ abacabɨlɨmɨnaŋ aba abiemi uami. ");
INSERT INTO ena_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nama nadɨ hɨvɨ veve saŋ mavɨn hɨniavɨla iadɨ vala vehanaŋ agadɨ ci igin uami. Agadɨ ala nama akɨ saŋ iadɨ kɨlɨ cɨkaŋ mugɨluŋ mugaŋ lamɨgaŋ me iadɨ ulaŋ migɨlavɨlalɨ agɨladɨ sɨgɨlɨ vihanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Lɨci Jekopɨ abami. Nama nanadina dɨ cɨhu mɨŋamagɨla vibanaŋ akua aba abavɨla viaŋ nasaŋ lɨdavɨla nɨfɨlɨ haŋɨlacin uami. ");
INSERT INTO ena_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Nama igɨnaŋ aniaba hulaŋ mu viaŋ hula vehavalɨ agaŋ nadɨ kɨlɨ cɨkaŋ mugɨluŋ mugaŋ lamɨgaŋ me agɨladɨ vavelɨ lɨci ha nudɨ ifɨhɨmɨha uami. Aludɨ hɨdɨlɨ pam agɨlaŋ igasulavɨdaci nama ve akuaba akuaba nagɨladɨ igɨha uami. La igɨnaŋ nadɨ akuaba hɨnici ha viha uami. Leselɨ agaŋ iaganu dɨ kɨlɨ cɨkaŋ mugɨluŋ mugaŋ lamɨgaŋ me agɨladɨ sɨgɨlɨ vimi agadɨ Jekopɨ ma igami. ");
INSERT INTO ena_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Lɨci Laban agaŋ Jekopɨ dɨ havɨlɨ ulaŋ hɨvɨ ivouavɨla kɨlɨ cɨkaŋ mugɨluŋ mugaŋ lamɨgaŋ me agɨladɨ suhɨlami. La cɨhu Lea dɨ havɨlɨ ulaŋ hɨvɨ ivoua suhɨlami. Sibɨla hɨsɨŋ iamɨgali ahica agɨladɨ havɨlɨ ulaŋ hɨvɨ avi ivoua suhɨlami. Suhɨla suhɨla hɨdami ala nudɨ kɨlɨ cɨkaŋ mugɨluŋ mugaŋ lamɨgaŋ me agɨladɨ ma igami. La nulɨdɨ havɨlɨ ulaŋ vala ua Leselɨ dɨ havɨlɨ ulaŋ hɨvɨ ivoumi. ");
INSERT INTO ena_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Leselɨ agaŋ iaganu dɨ kɨlɨ cɨkaŋ mugɨluŋ mugaŋ lamɨgaŋ me agɨladɨ sabaŋ kamelɨ sabɨ lama mɨgahɨnihɨni hɨsɨŋ agadɨ hɨvɨ sɨvɨla lamami. La nudɨ sabɨ hɨvɨ mɨgahɨnimi. Laban akuaba akuaba agɨladɨ mɨŋasuhɨlasuhɨla hɨdami ala nudɨ kɨlɨ cɨkaŋ mugɨluŋ mugaŋ lamɨgaŋ me agɨladɨ ma igami. ");
INSERT INTO ena_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Lɨci Leselɨ agaŋ iaganu dɨ mavɨn ciaŋ ciaŋ abami. Iavaŋ uami. Iadɨ abacabɨlɨmɨnaŋ uami. Viaŋ husɨŋ hɨbɨ hɨnin sadaŋ ma iaha lagulamɨben uami. Lɨci Laban akuaba akuaba agɨladɨ suhɨlami ala nudɨ kɨlɨ cɨkaŋ mugɨluŋ mugaŋ lamɨgaŋ me agɨladɨ ma igami. ");
INSERT INTO ena_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Lɨci Jekopɨ dɨ igɨvɨ lɨci Laban dɨ abacabɨlavɨla abami. Viaŋ akɨ lusɨŋ sɨbɨlɨ viavɨla hugɨ daŋ hɨnilɨŋ nama iadɨ sɨvɨ lahua vehanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Iadɨ akuaba akuaba hɨniavi heŋ suhɨla igɨnaŋ nadɨ akuaba hɨnici via haiabɨla lamɨha uami. Lɨnaŋ iadɨ hɨdɨlɨ pam agɨlaŋ hula nadɨ hɨdɨlɨ pam agɨlaŋ hula aludɨ ciaŋ agadɨ hihɨlavɨci igɨmɨli uami. Ani dɨ ciaŋ agaŋ amɨŋ hɨnibali uami. Ani dɨ ciaŋ agaŋ analɨ hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Viaŋ hualɨ human limu limu fɨhala hɨcɨ limu limu fɨhala nama hula hɨniadamin uami. Hɨnihɨni nadɨ sabaŋ sipsipɨ sabaŋ meme agɨladɨ migɨlɨdalɨŋ ninaŋ huaci huaci laci huhɨlavɨhadami uami. Viaŋ nadɨ sabaŋ sipsipɨ muŋaŋ mu ma sɨbaŋ nadamin uami. ");
INSERT INTO ena_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Akuaba akuaba saua hɨsɨŋ agɨlaŋ ve nadɨ sabaŋ sipsipɨ ua sabaŋ meme mu agɨhɨmavɨci nasaŋ ma vave abalamadamin uami. Viaŋ nukeŋ hɨbɨŋ nasaŋ iguadamin uami. Hɨfɨlɨ hɨfɨlɨ uaiadi uaiadi hulaŋ limu hɨhɨle agɨlaŋ nadɨ sabaŋ sipsipɨ sabaŋ meme sɨgɨlɨ vivi uavɨdaci hɨbɨŋ igu igu saŋ iadɨ abadamɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Akape tɨbɨ iadɨ uaiaŋ hɨlacabɨladami uami. Akape tɨbɨ hɨfɨlɨ hɨvɨ iadɨ vumɨli lɨdaci ani sɨhɨvia ma hɨsɨvadamin uami. ");
INSERT INTO ena_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Viaŋ nadɨ nadi ahica agɨladɨ vivi saŋ sibɨla vidalɨŋ hualɨ human limu limu fɨhala hɨcɨ limu limu ahica limu ahica cɨjɨŋ umi uami. La sabaŋ sipsipɨ sabaŋ meme vivi saŋ sibɨla vidalɨŋ hualɨ human limu fɨhala human limu pabiŋ cɨjɨŋ umi uami. Akuaba akuaba agɨladɨ vivi saŋ viaŋ hualɨ human limu limu fɨhala hɨcɨ limu limu fɨhala nama hula hɨnihɨni sibɨla agadɨ vihadamin uami. Vivi hɨnidalɨŋ human limu limu fɨhala tɨbɨ akuaba akuaba igu igu saŋ abadamɨnaŋ agadɨ ma iguadamɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Iadɨ iavaŋ Aisakɨ agaŋ Ebɨlam dɨ Asɨ agasaŋ lɨdavɨla nudɨ lɨhu hɨvɨ hɨniadami uami. Nudɨ Asɨ agaŋ iadɨ ma migɨlɨmaŋ lɨci ha nama iadɨ lahunaŋ havɨ sɨbaŋ vevin uami. Agadɨ ala Asɨ agaŋ viaŋ sibɨla vivi vɨhɨlɨ igadamin agadɨ ci igami sadaŋ hɨfɨlɨ anisɨhu hɨvɨ nasaŋ ciaŋ vɨdɨvɨdɨŋ iguiemi uami. ");
INSERT INTO ena_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lɨci Laban abami. Iamɨgali ahica nana iadɨ nanadi uami. Nulɨdɨ ninanadinɨlu hana iadɨ ala uami. Sabaŋ sipsipɨ sabaŋ meme hana avi iadɨ ala uami. Akuaba akuaba neŋ igadanaŋ ha iadɨ laci uami. Akɨ lavɨla iadɨ nanadi ahica agɨladɨdaŋ nulɨdɨ ninanadinɨlu agɨladɨdaŋ abamɨgɨlavin uami. ");
INSERT INTO ena_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Alia uami. Alaŋ ahica ciaŋ mɨguavɨla abɨmɨli uami. Hameŋ lavɨla alaŋ ciaŋ mɨguavɨla abɨbalu agasaŋ igahɨlahɨla hɨnibalu uami. ");
INSERT INTO ena_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Lɨci Jekopɨ agaŋ ciaŋ mɨguavɨla abɨben aba lɨhavɨmi agadɨ hɨji mɨŋaiahaiaha saŋ lɨba hutesɨ agadɨ mɨŋaiaha lalɨlamami. ");
INSERT INTO ena_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Lavɨla nudɨ hɨdɨlɨ pam agɨladɨ abami. Lɨba kum kum agɨladɨ likɨla vave mɨgudɨbɨhalaŋ uami. Lɨci lɨba kum kum agɨladɨ likɨlavɨla vave mɨgudɨbavɨci hɨniavɨdaci lɨba kum kum mɨguŋ agadɨ mikɨ heŋ ahuata mɨgahɨnihɨni sɨmɨŋ navɨmi. ");
INSERT INTO ena_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Navɨci ci lɨci Laban agaŋ lɨba kum kum mɨguŋ agadɨ ibi lamavɨla abami. Jegalɨsahaduta uami. Lɨci Jekopɨ avi ibi lamavɨla abami. Galetɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Lɨci Laban abami. Lɨba kum kum mɨguŋ nagaŋ alaŋ ciaŋ mɨguavɨla abalu agasaŋ hɨji mɨŋaiahaiaha saŋ hɨnibali uami. Lavɨla nɨbu avi ibi hameŋ laci ala lamavɨla abami. Galetɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","La cɨhu abami. Alaŋ ahica hɨtɨŋ hɨtɨŋ hɨnidamɨli Asɨ Iaue aludɨ igɨbali uami. Hameŋ abavɨla lɨba kum kum mɨguŋ agadɨ ibi mu avi lamavɨla abami. Misɨpa uami. ");
INSERT INTO ena_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Lavɨla Jekopɨ dɨ abami. Nama iadɨ nanadi dɨ sɨbɨlɨ lamavɨla ha hɨji nameŋ lamɨha uami. Laban iadɨ ma igi agadɨ ala Asɨ iadɨ igi aba abɨha uami. Iamɨgali mu sabiavɨla avi hameŋ laci ala abɨha uami. Laban iadɨ ma igi agadɨ ala Asɨ iadɨ igi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Igɨha uami. Lɨba hutesɨ daŋ lɨba kum kum mɨguŋ daŋ fipɨ nama hɨnibanaŋ agadɨ fipɨ viaŋ hɨniben nagadɨ alɨhaŋ heŋ mɨgudɨbin uami. ");
INSERT INTO ena_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Lɨba hutesɨ agaŋ lɨba kum kum mɨguŋ agaŋ alaŋ ciaŋ mɨguavɨla valɨ lamalu agadɨ hɨji mɨŋaiahaiaha saŋ hɨniavɨbali uami. Viaŋ nadɨ sɨbɨlɨ lamɨben aba uavɨla valɨ nagadɨ ma lɨvalɨben uami. Nama avi iadɨ sɨbɨlɨ lamɨben aba vevɨla valɨ nagadɨ ma lɨvalɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Alaŋ ahica hɨnimɨli vɨhɨlɨ iahɨci aludɨ iauacagali Ebɨlam dɨ Naholɨ dɨ Asɨ agaŋ aludɨ ciaŋ hihɨlɨbali uami. Jekopɨ iaganu Aisakɨ agaŋ Asɨ saŋ ala lɨdavɨla nudɨ lɨhu hɨvɨ hɨniadami. Lɨci Jekopɨ agaŋ Asɨ dɨ ibi hɨvɨ abami. Hɨvɨ hekɨlɨ uami. Viaŋ hameŋ ma lɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","La iahua halu heŋ Asɨ saŋ sagalɨ iguben aba sabaŋ sipsipɨ ifɨhɨmavɨla hɨlami. Lavɨla nudɨ hɨdɨlɨ pam agɨladɨ ulɨci vevɨla maci daŋ sɨhɨm hɨlɨcɨ limu cɨkaŋ agɨladɨdaŋ navɨmi. Navɨla hɨfɨlɨ halu heŋ ala ani hɨsɨvavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","La cimɨdaŋ sɨbaŋ Laban agaŋ iaha nanadinu agɨladɨdaŋ ajihalinu agɨladɨdaŋ mɨhum iavami. La lamulavɨla nulɨdɨ vala nudɨ hɨvɨ cɨhu umi. ");
INSERT INTO ena_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Laban udaci Jekopɨ agaŋ nudɨ hulemɨlɨ agɨlaŋ hula cɨhu vehavɨmi. Vehavɨdaci Asɨ dɨ ciaŋ hali hɨsɨŋ agɨlaŋ Jekopɨ dɨ pɨŋ hɨbɨ cina iahavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Iahavɨci nulɨdɨ igavɨla hɨji nameŋ lamami. Nana Asɨ dɨ uu veve hɨnihɨni fipɨ uami. Hɨji hameŋ lamavɨla fipɨ agadɨ ibi lamavɨla abami. Mahanaim uami. ");
INSERT INTO ena_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","5","La hulaŋ hɨhɨle agɨladɨ lɨbɨmɨŋavɨla abami. Iadɨ hulaŋ hekɨlɨ Iso dɨ hɨvɨ uavɨla nameŋ abɨhalaŋ uami. Nadɨ sibɨla hɨsɨŋ hulemɨlɨ Jekopɨ agaŋ nasaŋ ciaŋ nameŋ agadɨ abɨci vavelu aba abɨhalaŋ uami. Viaŋ Laban hula hualɨ akape ci hɨnicin aba abi aba abɨhalaŋ uami. Hameŋ sadaŋ iabi viaŋ cɨhu veben aba abi aba abɨhalaŋ uami. Viaŋ sabaŋ bulɨmakau sabaŋ donɨki sabaŋ sipsipɨ sabaŋ meme daŋ aba abi aba abɨhalaŋ uami. Iadɨ sibɨla hɨsɨŋ hulaŋ iamɨgali avi hanɨbuŋ aba abi aba abɨhalaŋ uami. Iadɨ manɨgali Iso aba abi aba abɨhalaŋ uami. Nama iadɨ igavɨla hɨjɨŋalɨbanaŋ aba ciaŋ nagadɨ nasaŋ igulɨŋ ui aba abi aba abɨhalaŋ uami. Nulɨdɨ hameŋ abɨci nɨbɨlaŋ Seilɨ fɨli tɨbɨ hali uavɨmi. Fɨli tɨbɨ agadɨ ibi mu Idom. ");
INSERT INTO ena_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ua abavɨla cɨhu hagaŋ vevɨla Jekopɨ dɨ abavɨmi. Alaŋ nadɨ ciaŋ agadɨ isana Iso saŋ via ua sulahɨlu agasaŋ nɨbu nadɨ hɨbɨ cina igɨben aba ci vedi uavɨmi. Hulaŋ 400 agɨlaŋ nɨbu hula vehavadi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Lɨhavɨci Jekopɨ agaŋ ciaŋ agadɨ igahɨlavɨla hekɨlɨ sɨbaŋ lɨdavɨla hɨji cuvɨlɨŋ cuvɨlɨŋ lamami. Lavɨla nudɨ hulaŋ iamɨgali agɨladɨ labɨlami. La nudɨ sabaŋ sipsipɨ sabaŋ meme sabaŋ bulɨmakau sabaŋ kamelɨ agɨladɨ avi labɨlavɨla ahica mɨguŋ lamami. Lamɨci fipɨ hɨtɨŋ hɨtɨŋ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Hɨniavɨdaci Jekopɨ agaŋ hɨji nameŋ lamami. Iso agaŋ ve sagaŋ mɨŋaiaha mu mɨguŋ agɨladɨ sɨbɨlɨ lamɨdaci mu mɨguŋ agɨlaŋ huaci haŋɨla uavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Lavɨla Asɨ dɨ abami. Asɨ nama iadɨ iauacaŋ Ebɨlam dɨ Asɨ uami. Nama iadɨ iavaŋ Aisakɨ dɨ Asɨ uami. Asɨ Iaue nama iadɨ nameŋ abahanaŋ uami. Nama nadɨ fɨli tɨbɨ hɨvɨ cɨhu uavɨla nadɨ hɨdɨlɨ pam agɨlaŋ hula hɨniha aba abahanaŋ uami. Ua hɨnidanaŋ viaŋ lɨlɨŋ nama huaci hɨnibanaŋ aba abahanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Asɨ viaŋ nadɨ sibɨla hɨsɨŋ hulemɨlɨ uami. Viaŋ hulaŋ huaci hɨma uami. Agadɨ ala nama iasaŋ mavɨn hɨniavɨla ciaŋ abahanaŋ hameŋ laci ala lɨhanaŋ uami. Vaka viaŋ akuaba akuaba apalɨ sɨbaŋ hɨniavɨla ua Jolɨdan avɨli agadɨ limu ivouavɨla Laban hula hɨniadamin uami. Viaŋ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agadɨ pam mɨŋalɨvavɨla ivoumin uami. Agadɨ ala iabi viaŋ cɨhu hulaŋ iamɨgali akuaba akuaba ahica mɨguŋ lamin agɨladɨ likɨlavɨla cɨhu neŋ ven uami. ");
INSERT INTO ena_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Asɨ uami. Viaŋ iadɨ isaŋ saŋ lɨdadin uami. Nɨbu vevɨla iadɨdaŋ iadɨ iamɨgali ninanadi agɨladɨdaŋ sɨkasɨkan sɨbɨlɨ lamɨbali aba lɨdadin uami. Nama iadɨ ahɨliahunaŋ iadɨ isaŋ Iso agaŋ iasaŋ sagaŋ ma vebali uami. ");
INSERT INTO ena_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Nama iadɨ nameŋ abamanaŋ uami. Viaŋ lɨlɨŋ nama huaci hɨnibanaŋ aba abamanaŋ uami. Viaŋ hameŋ lɨlɨŋ nadɨ iamɨlɨhalina agɨlaŋ iaha habɨlavɨla avɨli hekɨlɨ hɨsɨŋ hacɨŋ hɨlɨcɨ me hɨniavɨdaci hulaŋ mu agaŋ lugɨlɨci ma ua iahubali aba abamanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","La hɨnici mɨŋalahɨci sabaŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ isanu Iso saŋ sagalɨ me iguben aba lugɨla lugɨla lɨbɨmɨŋamɨŋa umi. ");
INSERT INTO ena_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Sabaŋ meme mɨgenaŋ 200 agɨladɨ lɨbɨmɨŋami. Sabaŋ meme muŋaŋ 20 agɨladɨ lɨbɨmɨŋami. Sabaŋ sipsipɨ mɨgenaŋ 200 agɨladɨ lɨbɨmɨŋami. Sabaŋ sipsipɨ muŋaŋ 20 agɨladɨ lɨbɨmɨŋami. ");
INSERT INTO ena_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Lavɨla sabaŋ kamelɨ mɨgenaŋ ninaŋ daŋ 30 agɨladɨ lɨbɨmɨŋami. Sabaŋ bulɨmakau mɨgenaŋ 40 agɨladɨ lɨbɨmɨŋami. Sabaŋ bulɨmakau muŋaŋ 10 agɨladɨ lɨbɨmɨŋami. Sabaŋ donɨki mɨgenaŋ 20 agɨladɨ lɨbɨmɨŋami. Sabaŋ donɨki muŋaŋ 10 agɨladɨ lɨbɨmɨŋami. ");
INSERT INTO ena_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Lavɨla cɨhu nudɨ sibɨla hɨsɨŋ hulemɨlɨ agɨlaŋ sabaŋ hɨdɨlɨ hɨtɨŋ hɨtɨŋ agɨladɨ migɨlavɨbali aba lɨbɨmɨŋamɨŋa uavɨla nulɨdɨ abami. Namɨlaŋ sabaŋ hɨdɨlɨ hɨtɨŋ hɨtɨŋ agɨladɨ likɨlavɨla hali uhalaŋ uami. Sabaŋ mu mɨguŋ agɨlaŋ mu mɨguŋ agɨladɨ mikɨ mikɨ uu pam hafala hafala hɨdavɨmɨdɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Lavɨla sibɨla hɨsɨŋ hulemɨlɨ mu hali uben aba lɨmi agadɨ abami. Iadɨ isaŋ Iso agaŋ ve nadɨ hɨbɨ cina igavɨla nadɨ nameŋ akua abitɨhɨbali uami. Nama ani dɨ sibɨla hɨsɨŋ hulemɨlɨ aba abɨbali akua uami. Nama abeŋ uadanaŋ aba abɨbali akua uami. Sabaŋ mɨguŋ hana ani dɨ aba abɨbali akua uami. ");
INSERT INTO ena_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Hameŋ abitɨhɨci ha nameŋ abɨha uami. Sabaŋ mɨguŋ nana ha nadɨ sibɨla hɨsɨŋ hulemɨlɨ Jekopɨ dɨ aba abɨha uami. Nɨbu nudɨ hulaŋ hekɨlɨ nasaŋ sagalɨ me iguci vaven aba abɨha uami. Jekopɨ nukeŋ nɨbu aludɨ sɨvɨ vedi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Lavɨla nudɨ sibɨla hɨsɨŋ hulemɨlɨ sabaŋ hɨdɨlɨ hɨtɨŋ hɨtɨŋ migɨla migɨla hɨsɨŋ mu agadɨ sɨvɨ uben aba lɨhavɨmi agɨladɨ abami. Namɨlaŋ avi Iso dɨ igavɨla ciaŋ hameŋ agadɨ laci abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","La ciaŋ mu agadɨ avi abɨhalaŋ uami. Ci igɨnaŋ aba abɨhalaŋ uami. Nadɨ sibɨla hɨsɨŋ hulemɨlɨ Jekopɨ nɨbu aludɨ sɨvɨ vedi aba abɨhalaŋ uami. Jekopɨ agaŋ hɨji nameŋ lamami. Viaŋ nusaŋ akuaba akuaba nagɨladɨ sagalɨ me igulɨŋ nudɨ sagaŋ hɨji agadɨ huaci valɨbali akua uami. Viaŋ hameŋ lɨlɨŋ iadɨ igavɨla iasaŋ mavɨn hɨnibali akua uami. ");
INSERT INTO ena_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Lavɨla sabaŋ agɨladɨ Iso saŋ sagalɨ me iguci ahɨla via hali uavɨdaci nɨbu heŋ ala hɨnidaci hɨfɨlɨ lɨmi. ");
INSERT INTO ena_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Lɨci hɨfɨlɨ heŋ ala nɨbu iaha nudɨ iamɨgali ahica agɨladɨdaŋ nudɨ sibɨla hɨsɨŋ iamɨgali ahica abinadinu me hɨniavɨhadami agɨladɨdaŋ viavɨla uavɨmi. Nudɨ ninaŋ human limu limu fɨhala hɨcɨ limu pabiŋ cɨjɨŋ agɨladɨ avi viavɨla uavɨmi. Uavɨla Jabokɨ avɨli agadɨ mɨgulamavɨla limu ivouavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ivoua nulɨdɨ lamavɨla nɨbu cɨhu hagaŋ ivavemi. Ivavevɨla nudɨ sibɨla hɨsɨŋ hulemɨlɨ agɨladɨ abɨci nudɨ akuaba akuaba agɨladɨ ahɨla via uavɨla Jabokɨ avɨli agadɨ mɨgulama ivouavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ivoua hɨniavɨdaci nɨbu hɨtɨŋ sɨbaŋ limu neŋ hɨnimi. Hɨnidaci hɨfɨlɨ hulaŋ mu agaŋ ve nɨbu hula sagaŋ lɨbalɨba havɨ hɨbɨŋ hɨbɨŋ mɨŋahubɨhahavɨla mɨŋamigɨlamigɨla hɨniavɨmi. Lɨhavɨdaci fɨli mɨŋalahɨben aba lɨmi. ");
INSERT INTO ena_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Sagaŋ lɨbalɨba hɨnihɨni hulaŋ agaŋ hɨji nameŋ lamami. Viaŋ nudɨ ma lɨvalɨben uami. La Jekopɨ dɨ akakuŋ henaŋ lagiŋ hɨdɨlɨ agadɨ ifɨcikɨvɨci lauala vemi. ");
INSERT INTO ena_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Sagaŋ lɨbalɨba via ua hulaŋ agaŋ Jekopɨ dɨ abami. Fɨli ci mɨŋalahɨben aba ladi uami. Nama iadɨ valɨnaŋ viaŋ ulɨŋ akua uami. Lɨci abami. Nama iadɨ huaci lamɨnaŋ ha nadɨ huaci valɨlɨŋ ubanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Lɨci hulaŋ agaŋ Jekopɨ dɨ abitɨhami. Nadɨ ibi ani uami. Lɨci abami. Iadɨ ibi Jekopɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Lɨci hulaŋ agaŋ abami. Nama hulaŋ sɨbaŋ agɨlaŋ hula sagaŋ me lɨbavɨla nulɨdɨ lɨvalɨlanaŋ uami. Malɨciŋ avi nama Asɨ hula sagaŋ lɨbavɨla nudɨ ci lɨvalɨnaŋ sadaŋ Jekopɨ ibi agaŋ nadɨ hɨvɨ cɨhu cɨhu ma hɨnibali uami. Nadɨ ibi sebɨlɨ ha Isɨlaelɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Lɨci Jekopɨ agaŋ mavɨn ciaŋ ciaŋ abami. Nama nadɨ ibi agadɨ iasaŋ abɨnaŋ igahɨlɨlɨŋ uami. Lɨci nudɨ abami. Nama akɨ saŋ iadɨ ibi agadɨ igahɨlahɨla saŋ abitɨhɨnaŋ uami. La iaha Jekopɨ dɨ huaci lamami. ");
INSERT INTO ena_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Lɨci Jekopɨ agaŋ abami. Viaŋ Asɨ dɨ mugaŋ lamɨgaŋ ci igin uami. Agadɨ ala viaŋ ma hɨmin uami. Hameŋ abavɨla fipɨ agadɨ ibi lamavɨla abami. Penielɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Lavɨla hɨnici uaiaŋ iahɨdaci Penielɨ fipɨ agadɨ valavɨla umi. Agadɨ ala nudɨ akakuŋ henaŋ lagiŋ hɨdɨlɨ agadɨ ifɨcikɨvami sadaŋ lidɨŋ lagulagu umi. ");
INSERT INTO ena_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Jekopɨ dɨ akakuŋ ifɨcikɨvami agasaŋ igahɨlahɨla Isɨlaelɨ hɨdɨlɨ agɨlaŋ sɨhɨm vɨhɨn vɨhɨn akakuŋ henaŋ lagiŋ hɨdɨlɨ hɨvɨ hɨniadami agadɨ ma navɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jekopɨ agaŋ Penielɨ fipɨ agadɨ vala ua igɨci Iso agaŋ nudɨ hulaŋ 400 agɨlaŋ hula ahuata hameŋ vehavɨmi. Vehavɨdaci Jekopɨ agaŋ nudɨ ninanadi agɨladɨ abɨci uavɨla nulɨdɨ numɨgagalinɨlu agɨlaŋ hula hɨtɨŋ hɨtɨŋ lagulamavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Lagulamavɨdaci sibɨla hɨsɨŋ iamɨgali ahica abinadinu me hɨniavɨhadami agɨladɨdaŋ nulɨdɨ ninadinɨlu agɨladɨdaŋ hali uu saŋ abami. La Lea dɨdaŋ nudɨ ninanadi agɨladɨdaŋ alɨhaŋ uu saŋ abami. Leselɨ dɨ Josepɨ dɨ sɨvɨ sɨbaŋ uu saŋ abami. ");
INSERT INTO ena_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Lavɨla nɨbu nukeŋ hali umi. Hali uu isanu dɨ ibi mɨŋaiahɨben aba mɨgalɨfɨlɨba nudɨ hali agadɨ fɨli hɨvɨ lɨbɨlɨvami. La cɨhu human limu fɨhala human limu pabiŋ cɨjɨŋ tɨbɨ hameŋ laci ala mɨgalɨfɨlɨba nudɨ hali agadɨ fɨli hɨvɨ lɨbɨlɨvami. Hameŋ lɨdɨŋ uavɨla isanu dɨ mikɨ mikɨ lɨmi. ");
INSERT INTO ena_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Lɨdaci Iso agaŋ haŋɨla haŋɨla ve imanu Jekopɨ dɨ mɨŋa alahafiavɨla nudɨ mɨhum iavami. La cɨhu ahica hameŋ ilɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Lavɨla Iso agaŋ igoua igavɨla iamɨgali ninanadi agɨladɨ igavɨla Jekopɨ dɨ abitɨhami. Ha ani ani agɨlaŋ nama hula hɨniavi uami. Lɨci Jekopɨ abami. Viaŋ nadɨ sibɨla hɨsɨŋ hulemɨlɨ uami. Asɨ agaŋ iasaŋ mavɨn hɨniavɨla ninanadi nagɨladɨ igumi uami. ");
INSERT INTO ena_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Lɨci sibɨla hɨsɨŋ iamɨgali ahica abinadinu me hɨniavɨhadami agɨlaŋ nulɨdɨ ninadinɨlu agɨladɨ vave Iso dɨ ibi mɨŋaiahɨbalu aba ahuata hameŋ mɨgalɨfɨlɨbavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lɨhavɨci Lea agaŋ nudɨ ninanadinu agɨlaŋ hula ve Iso dɨ ibi mɨŋaiahɨbalu aba mɨgalɨfɨlɨbavɨmi. Lɨhavɨci sijaŋ sɨbaŋ ha Josepɨ hula Leselɨ hula ve Iso dɨ ibi mɨŋaiahɨbalu aba mɨgalɨfɨlɨbavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Lɨhavɨci Iso agaŋ Jekopɨ dɨ abami. Nama akɨ me hɨji lamavɨla abɨnaŋ sabaŋ sipsipɨ akuaba akuaba agɨladɨ vavehavɨci hɨbɨ cina igacin uami. Hameŋ abɨci Jekopɨ agaŋ nudɨ abami. Ha nama iadɨ igavɨla hɨjɨŋalɨbanaŋ aba akuaba akuaba agɨladɨ nasaŋ igulɨŋ via uavalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Lɨci Iso agaŋ abami. Iadɨ ima uami. Viaŋ akuaba akuaba akape hanɨbuŋ uami. Akuaba akuaba nadɨ agadɨ cɨhu ala likɨlɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Lɨci Jekopɨ agaŋ nusaŋ mavɨn ciaŋ ciaŋ abami. Nama iadɨ igavɨla hɨjɨŋalavɨla ha akuaba akuaba viaŋ nasaŋ iguacin agɨladɨ viha uami. Nama iadɨ igavɨla hɨjɨŋalɨnaŋ sadaŋ nadɨ mugaŋ lamɨgaŋ agadɨ igɨlɨŋ Asɨ dɨ mugaŋ lamɨgaŋ me sɨbaŋ hɨni uami. ");
INSERT INTO ena_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Viaŋ nasaŋ akuaba akuaba iguacin agɨladɨ ha nama viha uami. Asɨ iadɨ huaci lamavɨla iasaŋ akuaba akuaba akape igumi uami. Hameŋ abavɨla Iso agaŋ akuaba akuaba agɨladɨ vim aba vɨdɨvɨdɨŋ sɨbaŋ hɨnimi. Lɨci Iso akuaba akuaba agɨladɨ vimi. ");
INSERT INTO ena_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Viavɨla abami. Iabi alaŋ iaha umɨli uami. Viaŋ avi namɨlaŋ hula uben uami. ");
INSERT INTO ena_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Lɨci Jekopɨ agaŋ Iso dɨ abami. Hulaŋ hekɨlɨ uami. Ci igɨnaŋ uami. Ninanadi nagɨlaŋ vɨdɨvɨdɨŋ ma vihavi uami. Sabaŋ sipsipɨ sabaŋ bulɨmakau akuaba akuaba ninaŋ daŋ ninaŋ daŋ agɨlaŋ avi vɨdɨvɨdɨŋ ma vihavi uami. Hameŋ sadaŋ viaŋ nulɨsaŋ hɨji cuvɨlɨŋ cuvɨlɨŋ igahɨladin uami. Alaŋ malamala via udamɨli sɨhɨm sabaŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨlaŋ lɨhalɨha uavɨla ha uaiaŋ pabiŋ hɨvɨ laci ahuata hameŋ sɨkasɨkan haba hɨma fɨhalavɨbali akua uami. ");
INSERT INTO ena_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Hulaŋ hekɨlɨ uami. Nama hali ajiavɨla udanaŋ viaŋ iadɨ sɨhɨm sabaŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ likɨlavɨla iadɨ ninanadi agɨlaŋ hula sɨvɨ simɨsimɨ ubalu uami. Uavɨla nadɨ Seilɨ fɨli tɨbɨ heŋ igɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Lɨci Iso agaŋ abami. Viaŋ iadɨ sibɨla hɨsɨŋ hulemɨlɨ limu hɨhɨle agɨladɨ lɨbɨmɨŋavɨla abɨlɨŋ nama hula hɨniavɨbali uami. La naludɨ via sɨvɨ vehavɨbali uami. Lɨci Jekopɨ agaŋ nudɨ abami. Hulaŋ hekɨlɨ uami. Iasaŋ igahɨlɨmɨnaŋ uami. Nama iadɨ iga hɨjɨŋalavɨla abɨnaŋ agadɨ ci igin uami. ");
INSERT INTO ena_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Lɨci uaiaŋ heŋ ala Iso agaŋ iahavɨla cɨhu ala Seilɨ fɨli tɨbɨ saŋ umi. ");
INSERT INTO ena_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Udaci Jekopɨ agaŋ iahavɨla Sukotɨ hɨbɨlɨ mɨgiŋ fipɨ heŋ umi. Ua iahuavɨla nudɨ nukeŋ ulaŋ agadɨ hafiavɨla cɨhu sabaŋ bulɨmakau agɨlasaŋ avi cavaŋ ulaŋ cɨki cɨki hafimi. Hameŋ sadaŋ hɨbɨlɨ mɨgiŋ fipɨ agadɨ ibi lamavɨla abavɨhadami. Sukotɨ uavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jekopɨ agaŋ Mesopotemia fɨli tɨbɨ hutesɨ hɨniadami agadɨ valavɨla cɨhu Sekem haiabɨla vemi. Huaci laci vemi. Sekem haiabɨla agaŋ nɨbu Kenan fɨli tɨbɨ hɨniadami. La Sekem haiabɨla mikɨ heŋ ala cɨhu havɨlɨ ulaŋ hafiavɨla hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Lavɨla fɨli tɨbɨ havɨlɨ ulaŋ hafia hɨniavɨmi agadɨ lavami. Fɨli tɨbɨ agadɨ viben aba anɨm hɨlɨcɨ 100 agɨladɨ fɨli iagagalinu Hamolɨ dɨ ninadinu agɨlasaŋ igumi. Hamolɨ dɨ ninaŋ mu agadɨ ibi Sekem. ");
INSERT INTO ena_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Lavɨla Jekopɨ agaŋ sagalɨ hɨlahɨla hɨsɨŋ lɨba vadɨm agadɨ heŋ ibilami. Ibilavɨla vadɨm agadɨ ibi lamavɨla abami. Vadɨm nana Isɨlaelɨ hɨdɨlɨ agɨladɨ Asɨ saŋ sagalɨ hɨlahɨla hɨsɨŋ lɨba vadɨm uami. ");
INSERT INTO ena_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Jekopɨ abinu Lea dɨ nadi Daina agaŋ mu tɨbɨ Sekem haiabɨla hɨsɨŋ iamɨgali iamɨgali agɨladɨ igɨben aba umi. ");
INSERT INTO ena_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Udaci Hamolɨ dɨ ninaŋ Sekem agaŋ Daina dɨ heŋ igami. Igɨci nudɨ humɨgaŋ iahɨci nusaŋ mavɨn hekɨlɨ hɨnimi. Lavɨla Daina dɨ vɨdɨvɨdɨŋ sɨbaŋ mɨŋamagɨla via uavɨla nɨbu hula hɨdami. Sekem iaganu Hamolɨ agaŋ nɨbu Hivɨ hɨdɨlɨ hulaŋ. Nɨbu ala fɨli tɨbɨ heŋ hɨsɨŋ agɨladɨ manɨgali hɨnihɨni nulɨdɨ migɨladami. ");
INSERT INTO ena_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sekem agaŋ Daina saŋ mavɨn hekɨlɨ hɨnimi. Hɨnihɨni Daina saŋ sɨdaŋ ciaŋ huaci huaci agɨladɨ igumi. Hameŋ lɨlɨŋ Daina iasaŋ mavɨn hɨnibali aba lɨmi. ");
INSERT INTO ena_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","La Sekem agaŋ iaganu dɨ abami. Iamɨgali nagadɨ viavɨla iasaŋ igunabɨla sabilɨŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Lɨci Jekopɨ agaŋ ciaŋ hɨjɨ agadɨ igahɨlami. Sekem agaŋ Daina dɨ mɨŋamagɨla via uavɨla nɨbu hula hɨdami agadɨ ciaŋ hɨjɨ igahɨlami. Igahɨlami ala akuaba ciaŋ cɨki avi ma abami. Nudɨ ninadinu agɨlaŋ ua mɨda hɨvɨ hɨnihɨni sabaŋ bulɨmakau sabaŋ sipsipɨ agɨladɨ migɨla migɨla hɨniavɨdaci nulɨsaŋ migɨla hɨnihɨni ciaŋ ma abami. ");
INSERT INTO ena_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Lɨci Sekem iaganu Hamolɨ agaŋ Jekopɨ hula ciaŋ sulasula saŋ nudɨ pɨŋ umi. ");
INSERT INTO ena_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Uavɨla ciaŋ sulasula hɨniavɨdaci Jekopɨ dɨ ninadinu agɨlaŋ cɨhu ala vehavɨmi. Vevɨla Sekem agaŋ nadinɨlu dɨ mɨŋamagɨla via uavɨla nɨbu hula hɨdami agadɨ ciaŋ hɨjɨ igahɨlavɨla humɨgaŋ vɨhɨlɨ via igɨvɨ hekɨlɨ sɨbaŋ hɨniavɨmi. Isɨlaelɨ hɨdɨlɨ agɨlaŋ lusɨŋ sɨbɨlɨ hameŋ agadɨ ma vihavɨhadami. Ha nɨbɨlaŋ nusaŋ hɨbuŋ uavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Lɨhavɨci Hamolɨ agaŋ nulɨdɨ abami. Iadɨ ninaŋ Sekem nɨbu naludɨ nadinalu agasaŋ mavɨn hekɨlɨ sɨbaŋ hɨnidi uami. Namɨlaŋ naludɨ nadinalu agadɨ huaci igulabɨla iadɨ ninaŋ nagaŋ sabivi ua hɨma uami. ");
INSERT INTO ena_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Hameŋ lɨlaŋ alaŋ namɨlaŋ hula huaci laci hɨnihɨni naludɨ nadi nadi agɨladɨ sabidamɨli namɨlaŋ avi aludɨ nadi nadi agɨladɨ sabibalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Hameŋ lɨmɨli namɨlaŋ alaŋ hula fɨli tɨbɨ neŋ huaci hɨnibalaŋ uami. Fɨli tɨbɨ abeba heŋ hɨniben aba ha hɨnihalaŋ uami. Fɨli tɨbɨ abeba hɨdɨben aba ha ua hɨdɨhalaŋ uami. Namɨlaŋ fɨli tɨbɨ abeba lavɨben aba ha lavɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Lɨci Sekem agaŋ Daina iaganu dɨdaŋ nudɨ numɨhalinu agɨladɨdaŋ abami. Namɨlaŋ iadɨ igavɨla hɨjɨŋalɨlaŋ ha namɨlaŋ akuaba akuaba saŋ abɨbalaŋ agɨladɨ nalusaŋ huaci iguben uami. ");
INSERT INTO ena_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Viaŋ namɨlaŋ naludɨ nadinalu agadɨ iasaŋ igulaŋ sabilɨŋ aba mavɨn hekɨlɨ hɨnidin uami. Namɨlaŋ nadi agasaŋ anɨm hɨlɨcɨ hekɨlɨ hekɨlɨ akuaba akuaba huaci huaci agɨlasaŋ igahɨla abɨlabɨla uami. Ha viaŋ nalusaŋ huaci iguben uami. ");
INSERT INTO ena_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Abɨci cɨhu Jekopɨ dɨ ninadinu agɨlaŋ Sekem agaŋ nadinɨlu Daina dɨ mɨŋamagɨla via uavɨla nɨbu hula hɨdami agasaŋ igahɨlavɨla mɨŋafifi lɨdɨŋ nulɨdɨ analɨ abavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Alaŋ aludɨ nadi agadɨ hulaŋ hadi sɨbɨlɨ ma ihalahavɨlalɨ agɨlasaŋ ma igubalu uavɨmi. Alaŋ hameŋ lavɨla sɨhum daŋ hɨdɨmagalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Hulaŋ namɨlaŋ sɨkasɨkan hameŋ hadi sɨbɨlɨ ihalaha fɨhalavɨla alaŋ me hɨnihalaŋ uavɨmi. Hadi sɨbɨlɨ ihalaha alaŋ me hɨnilaŋ alaŋ naludɨ ciaŋ agadɨ huaci akua igahɨlɨbalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Lavɨla alaŋ huaci abɨmɨli namɨlaŋ aludɨ nadi nadi agɨladɨ sabidalaŋ alaŋ avi naludɨ nadi nadi agɨladɨ huaci sabibalu uavɨmi. Lavɨla alaŋ namɨlaŋ hula hɨniavɨla hɨdɨlɨ pam me hɨnibalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Namɨlaŋ aludɨ ciaŋ agadɨ ma lubiahɨlavɨla hadi sɨbɨlɨ ihalahɨmaŋ lɨlabɨla uavɨmi. Ha alaŋ aludɨ nadi agadɨ viavɨla haiabɨla nagadɨ valavɨla ubalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Lɨhavɨci Hamolɨ hula ninanu Sekem hula ciaŋ agadɨ igahɨlavɨci nulɨdɨ humɨgaŋ agɨlaŋ huaci sɨbaŋ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Lavɨla Sekem agaŋ Jekopɨ dɨ nadi agasaŋ mavɨn hekɨlɨ hɨnimi sadaŋ nulɨdɨ ciaŋ agadɨ lubiahɨlavɨheben aba lɨmi. Sekem iaganu dɨ hɨdɨlɨ pam agɨlaŋ Sekem nɨbu aludɨ manɨgali hɨnibali aba nudɨ ibi agadɨ pam mɨŋaiahavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Lɨhavɨdaci Hamolɨ agaŋ nudɨ ninanu Sekem hula ahica haiabɨla agadɨ lua madɨŋ hɨbɨ ivu ivu mɨgudɨba hɨnihɨni fipɨ heŋ uavɨla hulaŋ limu hɨhɨle haiabɨla heŋ hɨsɨŋ agɨlaŋ hula ciaŋ sulavɨla abavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Nɨbɨlaŋ alaŋ hula huaci hɨniavɨbali uavɨmi. Alaŋ fɨli tɨbɨ hekɨlɨ daŋ sadaŋ vana abɨmɨli nɨbɨlaŋ fɨli tɨbɨ neŋ hɨnihɨni akuaba akuaba mutɨŋ hɨvɨ lamalama hɨdavɨbali uavɨmi. Lɨhavɨdaci alaŋ nulɨdɨ nadi nadi agɨladɨ sabidamɨli nɨbɨlaŋ avi aludɨ nadi nadi agɨladɨ sabiavɨbali uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Agadɨ ala nɨbɨlaŋ aludɨ hadi sɨbɨlɨ ihalahɨhalaŋ aba vɨdɨvɨdɨŋ sɨbaŋ abavadi uavɨmi. Hameŋ lavɨla alaŋ nɨbɨlaŋ me hɨnibalu uavɨmi. Alaŋ hameŋ lɨmɨli nɨbɨlaŋ alaŋ hula huaci hɨniavɨci cɨhu nɨbɨlaŋ hula hɨdɨlɨ pam me laci hɨnibalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Lɨdamɨli nulɨdɨ sabaŋ sipsipɨ sabaŋ bulɨmakau akuaba akuaba agɨlaŋ avi aludɨ hɨniavɨbali uavɨmi. Nɨbɨlaŋ abavi hameŋ lɨmɨli ha alaŋ hula huaci hɨniavɨbali uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Lɨhavɨci haiabɨla heŋ hɨsɨŋ hulaŋ agɨlaŋ Hamolɨ dɨ ciaŋ agasadaŋ ninanu Sekem dɨ ciaŋ agasadaŋ alialaŋ uavɨci nulɨdɨ hadi sɨbɨlɨ agɨladɨ heŋ ihalahavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ihalahavɨci uaiaŋ pabiŋ uci anihuliŋ me hɨvɨ hadi sɨbɨlɨ ihalahavɨmi agɨlaŋ avɨha avɨha hekɨlɨ iga iga hɨniavɨmi. Iga iga hɨniavɨdaci Simeon hula Livai hula Daina dɨ numɨhalinu amɨŋ agɨlaŋ puia hutesɨ hutesɨ agɨladɨ mɨŋalɨvavɨla haiabɨla heŋ uavɨmi. Ua iahuavɨla haiabɨla heŋ hɨsɨŋ hulaŋ agɨladɨ sɨkasɨkan ifɨhɨmuhɨmu uavɨdaci hulaŋ mu nulɨdɨ hɨbɨŋ ma ifɨhɨmavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Lavɨla cɨhu Hamolɨ dɨdaŋ ninanu Sekem dɨdaŋ avi ifɨhɨmavɨla nadinɨlu Daina Sekem dɨ ulaŋ hɨvɨ hɨnimi agadɨ viavɨla cɨhu ala vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Vehavɨdaci Sekem agaŋ Daina dɨ mɨŋamagɨla via uavɨla nɨbu hula hɨdami agasaŋ Jekopɨ dɨ ninadinu limu hɨhɨle agɨlaŋ haiabɨla heŋ iahuavɨmi. Iahuavɨla hulaŋ valɨ valɨ agɨladɨ igavɨla nulɨdɨ akuaba akuaba huaci huaci heŋ hɨniavɨhadami agɨladɨ sɨkasɨkan likɨla fɨhala via vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Lavɨla nulɨdɨ sabaŋ sipsipɨ sabaŋ bulɨmakau sabaŋ donɨki akuaba akuaba haiabɨla heŋ hɨniavɨmi agɨladɨdaŋ haiabɨla caba caba hɨniavɨmi agɨladɨdaŋ sɨkan likɨla fɨhalavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","La akuaba akuaba anɨm hɨlɨcɨ hekɨlɨ hekɨlɨ hɨsɨŋ agɨladɨdaŋ akuaba akuaba uleŋ muji hɨniavɨhadami agɨladɨdaŋ likɨla fɨhalavɨla vavehavɨmi. Iamɨgali iamɨgali ninanadi agɨladɨ avi likɨla vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Lɨhavɨci Jekopɨ agaŋ Simeon dɨdaŋ Livai dɨdaŋ abami. Namɨlaŋ iasaŋ vɨhɨlɨ hekɨlɨ igulaŋ uami. Hulaŋ iamɨgali Kenan hɨdɨlɨ agɨlaŋ hula Pelesɨ hɨdɨlɨ agɨlaŋ hula fɨli tɨbɨ neŋ hɨnihɨni iadɨ sɨbɨlɨ igavɨbali uami. Viaŋ hulaŋ akape hɨma uami. Hulaŋ agɨlaŋ mɨgudɨba pam lamavɨla iasaŋ sagaŋ vevɨla ha iadɨdaŋ iadɨ iamɨgali ninanadi agɨladɨdaŋ ifɨhɨma fɨhalavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Hameŋ abɨci cɨhu Simeon hula Livai hula abavɨmi. Nɨbu akɨ saŋ lɨci aludɨ nadi agaŋ hɨbɨ pɨlɨ hɨsɨŋ iamɨgali me hɨnidi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Lɨhavɨci mu tɨbɨ Asɨ agaŋ Jekopɨ dɨ abami. Nama iahavɨla Betelɨ hɨbɨlɨ mɨgiŋ fipɨ heŋ uavɨla hɨniha uami. Hɨnihɨni iasaŋ sagalɨ hɨlahɨla hɨsɨŋ lɨba vadɨm agadɨ ibilɨha uami. Viaŋ Asɨ uami. Vaka nama nadɨ isana Iso saŋ lɨdavɨla haŋɨlɨdanaŋ viaŋ ala nadɨ pɨŋ iahamin uami. ");
INSERT INTO ena_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Lɨci Jekopɨ agaŋ nudɨ abinadinu ninanadinu agɨladɨ abami. Hulaŋ limu hɨhɨle nɨbu hula hɨniavɨmi agɨladɨ avi abami. Namɨlaŋ mu haiabɨla hɨsɨŋ agɨladɨ kɨlɨ cɨkaŋ mugɨluŋ mugaŋ lamɨgaŋ me agɨladɨ ahɨlɨlaŋ uavɨm uami. La avɨli savɨla hadi hɨlahɨla hɨhi huaci huaci agɨladɨ lamɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Lɨlaŋ alaŋ haiabɨla nagadɨ valavɨla Betelɨ hɨbɨlɨ mɨgiŋ fipɨ heŋ ubalu uami. Uavɨla Asɨ saŋ sagalɨ hɨlahɨla hɨsɨŋ lɨba vadɨm agadɨ ibilɨben uami. Vaka viaŋ akuaba akuaba vɨhɨlɨ hekɨlɨ hekɨlɨ igɨdalɨŋ nɨbu ala iadɨ ahɨliahuadami uami. La iabi avi hameŋ laci ala ahɨliahulalɨ uami. Viaŋ abeba abeba uu veve hɨdɨdalɨŋ nɨbu viaŋ hula hɨniadami uami. La iabi avi hameŋ laci ala hɨnilalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Lɨci nɨbɨlaŋ nulɨdɨ kɨlɨ cɨkaŋ mugɨluŋ dɨ mugaŋ lamɨgaŋ me agɨladɨdaŋ hɨji asɨŋ hɨsɨŋ hajɨŋ agɨladɨdaŋ Jekopɨ saŋ iguavɨmi. Iguavɨci kɨlɨ hekɨlɨ Sekem haiabɨla mikɨ lagulama hɨniadami agadɨ lɨhu heŋ fɨli haca mavavɨla ahɨlɨci mɨguavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Lavɨla Jekopɨ nudɨ hulemɨlɨ agɨlaŋ hula uavɨmi. Uavɨdaci Asɨ agaŋ lɨci hulaŋ iamɨgali Sekem haiabɨla mikɨ hɨniavɨmi agɨlaŋ nulɨsaŋ hekɨlɨ haba lɨdavɨmi. La nulɨdɨ sɨvɨ ma uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Lɨhavɨci Jekopɨ agaŋ nudɨ hulemɨlɨ agɨlaŋ hula Kenan fɨli tɨbɨ hɨdahɨda Lusɨ hɨbɨlɨ mɨgiŋ fipɨ uavɨmi. Lusɨ ibi hana nɨbu Betelɨ hɨbɨlɨ mɨgiŋ fipɨ agadɨ ibi vaka hɨsɨŋ. ");
INSERT INTO ena_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Lavɨla Jekopɨ agaŋ sagalɨ hɨlahɨla hɨsɨŋ lɨba vadɨm agadɨ ibilami. Vaka isanu saŋ lɨdavɨla haŋɨlami hadɨhu Asɨ agaŋ heŋ ala nudɨ pɨŋ iahami agasaŋ igahɨlavɨla hɨbɨlɨ mɨgiŋ fipɨ agadɨ ibi lamavɨla abami. Asɨ nɨbu Betelɨ hɨbɨlɨ mɨgiŋ fipɨ neŋ hɨnilalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Heŋ hɨniavɨdaci Lebeka dɨ migɨla migɨla hɨsɨŋ iamɨgali Debola agaŋ heŋ ala hɨmami. Hɨmɨci kɨlɨ hekɨlɨ Betelɨ hɨbɨlɨ mɨgiŋ fipɨ ium kɨlikɨli lagulama hɨniadami agadɨ lɨhu heŋ mavavɨla hudavɨmi. Hameŋ sadaŋ kɨlɨ agadɨ ibi lamavɨla abavɨmi. Ilɨhiŋ hɨsɨŋ kɨlɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","10","Jekopɨ agaŋ Mesopotemia fɨli tɨbɨ agadɨ valavɨla cɨhu Kenan fɨli tɨbɨ vemi hadɨhu ala Asɨ agaŋ nudɨ pɨŋ cɨhu ala iahavɨla nudɨ huaci lamavɨla abami. Iabi nadɨ ibi Jekopɨ hɨnidi uami. Agadɨ ala mufɨli nɨbɨlaŋ nadɨ ibi agadɨ Jekopɨ aba ma abavɨbali uami. Nadɨ ibi Isɨlaelɨ aba abavɨbali uami. Lavɨla nudɨ ibi agadɨ lamavɨla abami. Isɨlaelɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","La cɨhu ala abami. Viaŋ Asɨ vɨdɨvɨdɨŋ hekɨlɨ daŋ uami. Nama ninanadi akape havɨbanaŋ uami. Hameŋ lɨnaŋ nadɨ hɨdɨlɨ agaŋ hekɨlɨ lavɨla latɨha hɨdɨlɨ akape hɨniavɨbali uami. Nadɨ iamɨlɨhalina limu hɨhɨle agɨlaŋ manɨgali hɨnihɨni fɨli tɨbɨ migɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Vaka fɨli nagadɨ Ebɨlam sadaŋ Aisakɨ sadaŋ igumin uami. Iabi nasaŋ iguadin uami. La cɨhu mufɨli nadɨ iamɨlɨhalina agɨlasaŋ avi iguben uami. ");
INSERT INTO ena_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Hameŋ abavɨla Asɨ agaŋ Jekopɨ hula fipɨ hɨnihɨni ciaŋ sulavɨmi agadɨ valavɨla cɨhu umi. ");
INSERT INTO ena_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Uci cɨhu Jekopɨ agaŋ iahavɨla Asɨ hula ciaŋ sulavɨmi agasaŋ hɨji lamavɨla lɨba hutesɨ agadɨ mɨŋaiaha lalɨlamami. Lavɨla lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨ viavɨla Asɨ saŋ sagalɨ iguben aba mɨŋamɨjici mɨgumi. Lavɨla cɨhu kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨ viavɨla lɨba agadɨ sabɨ hɨvɨ mɨŋamɨjici mɨguci abami. Ha Asɨ dɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","La hɨbɨlɨ mɨgiŋ fipɨ agadɨ ibi lamavɨla abami. Betelɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Jekopɨ nudɨ hulemɨlɨ agɨlaŋ hula Betelɨ hɨbɨlɨ mɨgiŋ fipɨ agadɨ valavɨla Efɨlata haiabɨla saŋ uavɨmi. Hɨbɨ cina vakala uavɨdaci Leselɨ agaŋ ninanadi huhɨlɨben aba lɨdaci mɨŋemɨŋe lɨmi. Lɨdaci avɨha avɨha hekɨlɨ sɨbaŋ igami. ");
INSERT INTO ena_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Avɨha avɨha hekɨlɨ sɨbaŋ iga iga hɨnidaci iamɨgali mu nudɨ hulɨ lagumi agaŋ abami. Nama lɨdɨmɨnaŋ uami. Ha ninaŋ mu Iagɨveŋ dɨ ci huhɨlɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Lavɨla Leselɨ agaŋ amɨŋ hɨmɨben aba alu sɨbɨlɨ hekɨlɨ hekɨlɨ havalavɨla ninaŋ agadɨ ibi lamavɨla abami. Benoni uami. Agadɨ ala iaganu Jekopɨ agaŋ cɨhu ibi mu lamavɨla abami. Bejamin uami. ");
INSERT INTO ena_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Leselɨ agaŋ hɨmɨci Efɨlata haiabɨla agadɨ hɨbɨ pɨlɨ caba heŋ mava hudavɨmi. Efɨlata ha Betɨlehem haiabɨla agadɨ vaka hɨsɨŋ ibi. ");
INSERT INTO ena_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Mufɨli me hɨvɨ hɨdɨlɨ igɨben aba lɨba hutesɨ agadɨ mɨŋaiaha Leselɨ dɨ savu caba mikɨ hɨvɨ lalɨlamami. Lalɨlamɨci hualɨ mu mu hameŋ laci hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Lavɨla Jekopɨ agaŋ uavɨla Magadaledelɨ haiabɨla agadɨ vala umitavɨla havɨlɨ ulaŋ agɨladɨ hafiavɨla heŋ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Heŋ ala hɨniavɨdaci Lea dɨ ninaŋ Luben agaŋ uavɨla iaganu dɨ abinu hɨvɨ Bilɨha hula hɨdami. Lɨhavɨci Jekopɨ agaŋ Luben akuaba akuaba lɨmi agadɨ ciaŋ igahɨlami. Jekopɨ dɨ ninadinu nɨbɨlaŋ human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ. ");
INSERT INTO ena_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Jekopɨ dɨ ninaŋ manɨgali Cimegeŋ Lea huhɨlami ha Luben. Lea dɨ ninaŋ limu hɨhɨle agɨladɨ ibi nameŋ. Mu Simeon. Mu Livai. Mu Juda. Mu Isakalɨ. Mu Sebulun. ");
INSERT INTO ena_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Leselɨ dɨ ninaŋ ha Josepɨ hula Bejamin hula. ");
INSERT INTO ena_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Leselɨ dɨ sibɨla hɨsɨŋ iamɨgali Bilɨha Jekopɨ dɨ abinu me hɨniadami agadɨ ninaŋ ha Dan hula Napɨtali hula. ");
INSERT INTO ena_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lea dɨ sibɨla hɨsɨŋ iamɨgali Celɨpa Jekopɨ dɨ abinu me hɨniadami agadɨ ninaŋ ha Gatɨ hula Aselɨ hula. Jekopɨ nɨbu Mesopotemia fɨli tɨbɨ hɨnihɨni ninaŋ nagɨladɨ havami. ");
INSERT INTO ena_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jekopɨ agaŋ iaganu Aisakɨ dɨ igɨben aba Mamɨle haiabɨla umi. Mamɨle haiabɨla nɨbu Kiliatalɨba haiabɨla mikɨ hɨniadami. Kiliatalɨba haiabɨla ha Hebɨlon haiabɨla agadɨ vaka hɨsɨŋ ibi. Vaka Ebɨlam hula Aisakɨ hula haiabɨla heŋ ala hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Aisakɨ agaŋ hɨniavɨla hadi hadi sɨbaŋ lɨmi. Lɨci nudɨ hualɨ lugɨlavɨci ua 180 iahɨci heŋ hɨmami. Hɨmɨci nudɨ amɨŋ agaŋ uavɨla nudɨ iamɨlɨhalinu dɨ amɨŋ hɨniavɨhadami heŋ hɨnimi. Lɨci nudɨ ninaŋ ahica Iso hula Jekopɨ hula nudɨ valɨ agadɨ mava hudavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Iso dɨ abinadinu ninadinu agɨladɨ ibi nameŋ. Iso dɨ ibi mu Idom. ");
INSERT INTO ena_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iso nɨbu Kenan fɨli tɨbɨ hɨsɨŋ iamɨgali iamɨgali agɨladɨ sabimi. Elon dɨ nadinu Ada dɨ sabimi. Elon nɨbu Hitɨ hɨdɨlɨ. Mu ha Ana dɨ nadinu Oholibama dɨ sabimi. Nudɨ iauacanu Sibeon. Sibeon nɨbu Hivɨ hɨdɨlɨ. ");
INSERT INTO ena_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","La Isɨmaelɨ nadinu Basematɨ dɨ avi sabimi. Nudɨ amunu Nebaiotɨ. ");
INSERT INTO ena_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada nɨbu Elifasɨ dɨ huhɨlami. Basematɨ nɨbu Luelɨ dɨ huhɨlami. ");
INSERT INTO ena_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama nɨbu ninaŋ ahica pam huhɨlami. Mu Jeusɨ. Mu Jalam. Mu Kola. Iso agaŋ Kenan fɨli tɨbɨ hɨnihɨni ninaŋ nagɨladɨ havami. ");
INSERT INTO ena_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","7","Iso hula Jekopɨ hula fɨli tɨbɨ pam hɨniavɨdaci nulɨdɨ sabaŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨlaŋ iaha habɨlavɨla akape lɨhavɨdaci fɨli saŋ tɨbɨ mɨgavɨmi. Lɨhavɨci Iso agaŋ nudɨ abinadinu ninadinu agɨladɨ likɨla hulaŋ iamɨgali nɨbu hula hɨniavɨhadami agɨlaŋ hula Kenan fɨli tɨbɨ agadɨ valavɨla uavɨmi. Sabaŋ mu hɨdɨlɨ mu hɨdɨlɨ Kenan fɨli tɨbɨ hɨnihɨni vihadami agɨladɨ avi sɨkan via mu hɨvɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Uavɨla Seilɨ fɨli tɨbɨ halu daŋ halu daŋ heŋ hɨniavɨhadami. Iso dɨ ibi mu Idom. ");
INSERT INTO ena_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Iso nɨbu Idom hɨdɨlɨ agɨladɨ iamɨlɨnɨlu. Nɨbɨlaŋ ala Seilɨ fɨli tɨbɨ halu daŋ halu daŋ heŋ hɨniavɨhadami. Iso dɨ ninadinu ajihalinu iamɨlɨhalinu agɨladɨ ibi lugɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Iso dɨ ninadinu agɨladɨ ibi nameŋ. Mu Elifasɨ. Nudɨ numɨgaŋ Ada. Mu Luelɨ. Nudɨ numɨgaŋ Basematɨ. ");
INSERT INTO ena_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifasɨ dɨ ninadinu agɨladɨ ibi nameŋ. Mu Teman. Mu Omalɨ. Mu Sefo. Mu Gatam. Mu Kenasɨ. ");
INSERT INTO ena_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifasɨ abinu hɨvɨ ha Timɨna. Nɨbu ala Amalekɨ dɨ huhɨlami. Nɨbɨlaŋ Iso abinu Ada dɨ ajihalinu pam. ");
INSERT INTO ena_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Luelɨ dɨ ninadinu agɨladɨ ibi nɨbɨlaŋ nameŋ. Mu Nahatɨ. Mu Cela. Mu Sama. Mu Misa. Nɨbɨlaŋ Iso abinu Basematɨ dɨ ajihalinu pam. ");
INSERT INTO ena_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Iso abinu Oholibama dɨ ninadinu agɨladɨ ibi nɨbɨlaŋ nameŋ. Mu Jeusɨ. Mu Jalam. Mu Kola. Oholibama nɨbu Ana dɨ nadinu. Nudɨ iauacanu Sibeon. ");
INSERT INTO ena_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Iso dɨ ajihalinu agɨlaŋ latɨhavɨla hɨdɨlɨ hɨtɨŋ hɨtɨŋ hɨnihɨni nulɨdɨ nukeŋ hɨdɨlɨ agɨladɨ migɨlavɨhadami. Iso dɨ ninaŋ manɨgali Elifasɨ dɨ ninadinu manɨgali hɨniavɨhadami agɨladɨ ibi nameŋ. Mu Teman. Mu Omalɨ. Mu Sefo. Mu Kenasɨ. Mu Kola. Mu Gatam. Mu Amalekɨ. Nɨbɨlaŋ ala Idom fɨli tɨbɨ hɨnihɨni manɨgali hɨniavɨhadami. Nulɨdɨ avenɨlu nɨbu Iso abinu Ada. ");
INSERT INTO ena_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Luelɨ dɨ ninadinu agɨlaŋ latɨhavɨla hɨdɨlɨ hɨtɨŋ hɨtɨŋ hɨniavɨhadami. Hɨnihɨni nulɨdɨ nukeŋ hɨdɨlɨ hɨtɨŋ hɨtɨŋ agɨladɨ migɨlavɨhadami. Luelɨ dɨ ninadinu manɨgali hɨniavɨhadami agɨladɨ ibi nameŋ. Mu Nahatɨ. Mu Cela. Mu Sama. Mu Misa. Nɨbɨlaŋ ala Idom fɨli tɨbɨ hɨnihɨni manɨgali hɨniavɨhadami. Nulɨdɨ avenɨlu nɨbu Iso abinu Basematɨ. ");
INSERT INTO ena_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Iso abinu Oholibama dɨ ninadinu agɨlaŋ latɨhavɨla hɨdɨlɨ hɨtɨŋ hɨtɨŋ hɨniavɨhadami. Hɨnihɨni nulɨdɨ nukeŋ hɨdɨlɨ hɨtɨŋ hɨtɨŋ agɨladɨ migɨlavɨhadami. Ninadinu agɨladɨ ibi nameŋ. Mu Jeusɨ. Mu Jalam. Mu Kola. Nulɨdɨ iamɨnɨlu nɨbu Iso abinu Oholibama. Oholibama nɨbu Ana dɨ nadinu. ");
INSERT INTO ena_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Iso dɨ ninadinu ajihalinu agɨlaŋ ala manɨgali hɨniavɨhadami. Iso dɨ ibi mu Idom. ");
INSERT INTO ena_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Seilɨ nɨbu Holɨ hɨdɨlɨ. Nɨbu Idom fɨli tɨbɨ hɨniadami. Nudɨ ninadinu agɨladɨ ibi nameŋ. Mu Lotan. Mu Sobalɨ. Mu Sibeon. Mu Ana. ");
INSERT INTO ena_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Mu Dison. Mu Eselɨ. Mu Disan. Nɨbɨlaŋ Seilɨ dɨ ninadinu. Nɨbɨlaŋ Holɨ hɨdɨlɨ agɨladɨ manɨgali hɨnihɨni Idom fɨli tɨbɨ agadɨ migɨlavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan dɨ ninadinu agɨladɨ ibi nameŋ. Mu Holi. Mu Heman. Lotan dɨ nadinu humɨgaŋ pam Timɨna. ");
INSERT INTO ena_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobalɨ dɨ ninadinu agɨladɨ ibi nameŋ. Mu Alɨvan. Mu Manahatɨ. Mu Ebalɨ. Mu Sefo. Mu Onam. ");
INSERT INTO ena_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeon dɨ ninadinu agɨladɨ ibi nameŋ. Mu Aia. Mu Ana. Ana agaŋ ala iaganu Sibeon dɨ sabaŋ donɨki agɨladɨ migɨladami. La mu tɨbɨ fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ ua igɨci avɨli vubɨŋ laci agɨlaŋ vubɨlɨm daŋ vubɨlɨm daŋ iahavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana dɨ ninanu dɨ ibi Dison. Nadinu dɨ ibi Oholibama. ");
INSERT INTO ena_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dison dɨ ninadinu agɨladɨ ibi nameŋ. Mu Hemɨdan. Mu Esɨban. Mu Itɨlan. Mu Kelan. ");
INSERT INTO ena_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eselɨ dɨ ninadinu agɨladɨ ibi nameŋ. Mu Belɨhan. Mu Cevan. Mu Eken. ");
INSERT INTO ena_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan dɨ ninadinu agɨladɨ ibi nameŋ. Mu Usɨ. Mu Alan. ");
INSERT INTO ena_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Holɨ hɨdɨlɨ agɨladɨ manɨgali agɨladɨ ibi nameŋ. Mu Lotan. Mu Sobalɨ. Mu Sibeon. Mu Ana. ");
INSERT INTO ena_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Mu Dison. Mu Eselɨ. Mu Disan. Nɨbɨlaŋ ala Seilɨ fɨli tɨbɨ hɨnihɨni nulɨdɨ hɨdɨlɨ pam latɨhiŋ agɨladɨ hɨtɨŋ hɨtɨŋ migɨlavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Vaka Isɨlaelɨ hɨdɨlɨ agɨlaŋ manɨgali apalɨ hɨniavɨdaci Idom fɨli tɨbɨ hɨsɨŋ agɨlaŋ pam manɨgali daŋ hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beolɨ dɨ ninaŋ Bela agaŋ Dinɨhaba haiabɨla hɨnihɨni Idom fɨli tɨbɨ agadɨ migɨladami. ");
INSERT INTO ena_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela hɨmɨci Cela dɨ ninaŋ Jobapɨ agaŋ manɨgali hɨnimi. Nɨbu Bosɨla haiabɨla hɨsɨŋ. ");
INSERT INTO ena_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobapɨ hɨmɨci cɨhu Husam agaŋ manɨgali hɨnimi. Nɨbu Teman hɨdɨlɨ agɨladɨ fɨli tɨbɨ hɨsɨŋ. ");
INSERT INTO ena_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam hɨmɨci cɨhu Bedatɨ dɨ ninaŋ Hadatɨ agaŋ manɨgali hɨnimi. La Moapɨ fɨli tɨbɨ uavɨla Midian hɨdɨlɨ agɨlaŋ hula sagaŋ lɨbavɨla nulɨdɨ lɨvalami. Lavɨla Hadatɨ agaŋ Avitɨ haiabɨla hɨnihɨni manɨgali hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadatɨ hɨmɨci cɨhu Samɨla agaŋ manɨgali hɨnimi. Nɨbu Masɨleka haiabɨla hɨsɨŋ. ");
INSERT INTO ena_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samɨla hɨmɨci cɨhu Saulɨ agaŋ manɨgali hɨnimi. Nɨbu Lehobotɨ haiabɨla hɨsɨŋ. Lehobotɨ haiabɨla agaŋ Iufɨletisɨ avɨli mikɨ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saulɨ hɨmɨci cɨhu Akɨbelɨ dɨ ninaŋ Balɨhanan agaŋ manɨgali hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Balɨhanan hɨmɨci cɨhu Hadatɨ agaŋ manɨgali hɨnihɨni Pau haiabɨla hɨniadami. Nudɨ abinu Mehetabelɨ. Nɨbu Matɨletɨ dɨ nadinu. Mehetabelɨ nɨbu Mesahapɨ dɨ ajinu. ");
INSERT INTO ena_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Iso dɨ hɨdɨlɨ agɨlaŋ manɨgali hɨniavɨhadami agɨladɨ ibi nameŋ. Mu Timɨna. Mu Alɨva. Mu Jetetɨ. Mu Oholibama. Mu Ela. Mu Pinon. Mu Kenasɨ. Mu Teman. Mu Mipɨsalɨ. Mu Makɨdielɨ. Mu Hilam. Hulaŋ agɨlaŋ Idom hɨdɨlɨ latɨhiŋ agɨladɨ hɨtɨŋ hɨtɨŋ migɨlavɨhadami. Iso dɨ ibi mu Idom. Iso nɨbu Idom hɨdɨlɨ agɨladɨ iamɨlɨnɨlu. Hulaŋ agɨlaŋ ala manɨgali hɨnihɨni haiabɨla hɨtɨŋ hɨtɨŋ fɨli tɨbɨ hɨtɨŋ hɨtɨŋ agɨladɨ migɨlavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jekopɨ agaŋ Kenan fɨli tɨbɨ hɨniadami. Vaka iaganu Aisakɨ agaŋ fɨli tɨbɨ heŋ ala ihɨlɨŋ ve hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Jekopɨ ninadinu ajihalinu agɨladɨ ciaŋ nameŋ. Josepɨ nɨbu hulaŋ mɨnibɨlɨ. Nudɨ hualɨ lugɨlavɨci ua 17 iahami. Nɨbu nudɨ isagalinu hula sabaŋ sipsipɨ agɨladɨ migɨlavɨhadami. Nudɨ isagalinu agɨlaŋ iaganɨlu dɨ abinadinu Bilɨha dɨ Celɨpa dɨ ninadinɨlu. Josepɨ agaŋ isagalinu agɨlaŋ lusɨŋ sɨbɨlɨ vihavɨmi agasaŋ uavɨla iaganɨlu dɨ sulami. ");
INSERT INTO ena_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Jekopɨ dɨ ibi mu Isɨlaelɨ. Nɨbu hadi hadi hɨniavɨla nudɨ ninanu Josepɨ dɨ havami. Hameŋ sadaŋ nusaŋ mavɨn hekɨlɨ hɨniadami. Nudɨ ninadinu limu hɨhɨle agɨlasaŋ mavɨn hekɨlɨ hameŋ ma hɨniadami. Jekopɨ agaŋ hadi hɨlahɨla hutesɨ makaŋ daŋ huaci sɨbaŋ agadɨ hɨcavɨla ninanu Josepɨ saŋ igumi. ");
INSERT INTO ena_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Iguci nudɨ isagalinu agɨlaŋ igavɨla nameŋ abavɨmi. Aludɨ iavaŋ agaŋ Josepɨ saŋ pam mavɨn hekɨlɨ hɨnilalɨ uavɨmi. Alusaŋ mavɨn hekɨlɨ hameŋ ma hɨnilalɨ uavɨmi. Lavɨla Josepɨ saŋ igɨvɨ hekɨlɨ hɨniavɨla nudɨ ciaŋ huaci huaci ma abavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Mu tɨbɨ Josepɨ anisɨhu igami agadɨ isagalinu agɨlasaŋ sulasula abami. Viaŋ anisɨhu mu igiemin agadɨ sulɨlɨŋ igahɨlɨhalaŋ uami. Alaŋ ahuata hameŋ hualabɨla hɨnihɨni halɨha cahu uitɨ agɨladɨ hubɨhahahaha lalɨlamalama uiemɨlu uami. Lɨmɨli halɨha cahu uitɨ hubɨ iadɨ agaŋ pam sɨlɨvɨ lagulamavɨla hɨnidaci naludɨ agɨlaŋ iadɨ agadɨ haŋala hudavɨla iadɨ halɨha cahu uitɨ hubɨ agadɨ ibi mɨŋaiahɨben aba hali lɨfuhɨla hɨniaviemi uami. Hameŋ abɨci nudɨ isagalinu agɨlaŋ nusaŋ igɨvɨ hekɨlɨ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Lavɨla abavɨmi. Nama manɨgali hɨnihɨni aludɨ migɨlɨben aba lɨnaŋ uavɨmi. Josepɨ anisɨhu iga iga sulɨdaci igahɨlavɨhadami agɨlasaŋ igɨvɨ hekɨlɨ sɨbaŋ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","La cɨhu mu tɨbɨ Josepɨ anisɨhu mu igami agadɨ isagalinu saŋ sulami. Viaŋ anisɨhu mu nameŋ agadɨ igiemin uami. Uaiaŋ hula avaŋ hula iadɨ ibi mɨŋaiahɨben aba mɨgalɨfɨlɨbavɨla hɨniavɨdaci igiemin uami. Lidɨ human limu limu fɨhala hɨcɨ limu pabiŋ cɨjɨŋ agɨlaŋ avi iadɨ ibi mɨŋaiahɨben aba mɨgalɨfɨlɨbavɨla hɨniavɨdaci igiemin uami. ");
INSERT INTO ena_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","La anisɨhu agadɨ iaganɨlu dɨdaŋ isagalinu dɨdaŋ cɨhu ala sulami. Sulɨci iaganɨlu agaŋ igahɨlavɨla nudɨ abacabɨlavɨla abami. Ha akɨ me anisɨhu agadɨ igiemɨnaŋ uami. Nama hɨji nameŋ lamɨnaŋ uami. Iadɨ iamiagaŋ agɨlaŋ hula iadɨ isaimahali agɨlaŋ hula iadɨ ibi mɨŋaiahɨben aba ve fɨli hɨvɨ mɨgalɨfɨlɨbavɨbali aba igahɨlɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Lɨci isagalinu agɨlaŋ abasɨgɨlasɨgɨla imanɨlu saŋ humɨgaŋ vɨhɨlɨ vihavɨmi. Agadɨ ala iaganɨlu agaŋ Josepɨ anisɨhu igami agasaŋ hɨji lamalama hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Mu tɨbɨ Josepɨ dɨ isagalinu agɨlaŋ Sekem haiabɨla caba caba heŋ uavɨla hɨnihɨni iaganɨlu dɨ sabaŋ sipsipɨ agɨladɨ migɨla migɨla hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Lɨhavɨdaci Isɨlaelɨ agaŋ Josepɨ dɨ nameŋ abami. Nadɨ isagalina agɨlaŋ Sekem haiabɨla caba caba heŋ hɨnihɨni sabaŋ sipsipɨ agɨladɨ migɨla migɨla hɨniavadi uami. Nama uavɨla nulɨdɨ igɨha uami. Hameŋ abɨci Josepɨ agaŋ nudɨ abami. Ua igɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Lɨci iaganɨlu agaŋ cɨhu abami. Nadɨ isagalina dɨ ua igɨha uami. Huaci hɨniavi ua hɨma ua uami. Sabaŋ sipsipɨ agɨladɨ avi igɨha uami. Nɨbɨlaŋ avi huaci laci hɨniavi ua hɨma ua uami. Ua igavɨla cɨhu ve iadɨ abɨnaŋ igahɨlɨlɨŋ uami. Hameŋ abɨci Hebɨlon fɨli abɨlɨ agadɨ valavɨla Sekem haiabɨla caba caba umi. ");
INSERT INTO ena_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Uavɨla isagalinu dɨ heŋ suhɨla suhɨla hɨdɨdaci hulaŋ mu agaŋ ve nudɨ igavɨla abitɨhami. Nama akɨ suhɨla suhɨla uu veve hɨdadanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Lɨci Josepɨ agaŋ abami. Viaŋ iadɨ isagali agɨladɨ suhɨla suhɨla hɨdadin uami. Nɨbɨlaŋ abeba hɨnihɨni nulɨdɨ sabaŋ sipsipɨ agɨladɨ migɨla migɨla hɨniavadi agadɨ iadɨ huaci abɨnaŋ igavin uami. ");
INSERT INTO ena_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Lɨci hulaŋ agaŋ nudɨ abami. Nɨbɨlaŋ neŋ ci valavɨla uavalɨ uami. Alaŋ Dotan haiabɨla ubalu aba abavɨci igahɨlacin uami. Lɨci Josepɨ agaŋ isagalinu agɨladɨ sɨvɨ uavɨla nulɨdɨ Dotan haiabɨla caba caba heŋ igami. ");
INSERT INTO ena_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","La ataŋ vakala udaci isagalinu agɨlaŋ igavɨla nudɨ ifɨhɨmuhɨmu saŋ abaigahɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Abaigahɨlahɨla nɨbɨlaŋ nukeŋ nukeŋ nameŋ abavɨmi. Igɨhalaŋ uavɨmi. Anisɨhu iga iga hɨsɨŋ hulaŋ agaŋ ci vedi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Alialaŋ uavɨmi. Ifɨhɨmavɨla valɨ agadɨ via sɨmɨ tulɨ hɨvɨ havalɨmɨli mɨgum uavɨmi. La nameŋ abɨmɨli uavɨmi. Sudɨ iŋam iava na fɨhalalɨ aba abɨmɨli uavɨmi. Hameŋ lɨmɨli anisɨhu iga iga abɨlalɨ agɨlaŋ ma iahavɨbali uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","22","Hameŋ abavɨci Luben agaŋ Josepɨ dɨ ifɨhɨmuhɨmu saŋ ciaŋ mɨguavɨmi agadɨ igahɨlavɨla nudɨ ahɨliahuben aba nulɨdɨ abami. Alaŋ nukeŋ nudɨ ifɨhɨmɨmagalu uami. Havɨ sɨmɨ tulɨ fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ neŋ havalɨmɨli mɨgum uami. Agadɨ ala nudɨ sɨbɨlɨ lamɨmagalu uami. Luben agaŋ Josepɨ dɨ ahɨliahuavɨla iaganɨlu dɨ pɨŋ cɨhu viovio saŋ hɨji lamavɨla ciaŋ hameŋ agadɨ abami. ");
INSERT INTO ena_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Josepɨ agaŋ isagalinu dɨ pɨŋ uci nudɨ mɨŋalɨvavɨmi. Lavɨla nudɨ hadi hɨlahɨla hutesɨ makaŋ daŋ huaci sɨbaŋ iaganɨlu igumi agadɨ mɨŋahubɨla vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","La nudɨ mɨŋa via uavɨla sɨmɨ tulɨ avɨli apalɨ heŋ havalavɨci mɨgumi. ");
INSERT INTO ena_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Havalavɨci mɨguci mɨgahɨnia sɨmɨŋ nana hɨniavɨmi. Nana hɨnia igavɨci Isɨmaelɨ hɨdɨlɨ agɨlaŋ nulɨdɨ sabaŋ kamelɨ agɨladɨ likɨlavɨla vehavɨmi. Gileatɨ fɨli tɨbɨ kɨlikɨli heŋ hɨniavɨla vehavɨmi. Isipɨ fɨli tɨbɨ uavɨla akuaba akuaba huaci huaci anɨm hɨlɨcɨ hekɨlɨ hekɨlɨ hɨsɨŋ agɨladɨ mutɨŋ lamɨben aba via vehavɨmi. Kɨlɨ mɨlɨm hɨsi huaci huaci daŋ agɨladɨdaŋ akuaba akuaba ikupi hɨsi huaci huaci daŋ agɨladɨdaŋ viavɨla vehavɨmi. Cihu savu me mu agadɨ ibi mea uavɨhadami. Nudɨ avi viavɨla vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Vehavɨdaci Juda agaŋ nudɨ isagalinu imahalinu agɨladɨ abami. Alaŋ aludɨ ima dɨ ifɨhɨma sɨvɨlalɨbavɨla ha alaŋ akuaba akuaba huaci huaci agɨladɨ ma vibalu uami. ");
INSERT INTO ena_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Isɨmaelɨ hɨdɨlɨ agɨlasaŋ mutɨŋ hɨvɨ lamɨmɨli lavavɨci nulɨdɨ sibɨla hɨsɨŋ hulemɨlɨ hɨnim uami. Alaŋ iavaŋ pabiŋ laci sadaŋ nudɨ sɨbɨlɨ lamɨmagalu uami. Lɨci nudɨ isagalinu imahalinu agɨlaŋ nudɨ ciaŋ agadɨ igahɨlavɨla abavɨmi. Ha huaci uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Josepɨ dɨ isagalinu agɨlaŋ ciaŋ aba aba hɨniavɨdaci Midian hɨdɨlɨ anɨm hɨlɨcɨ sibɨla vivi mutɨŋ lavavɨhadami agɨlaŋ vehavɨmi. Vehavɨci Josepɨ sɨmɨ tulɨ hɨvɨ hɨnimi agadɨ magɨlavɨci iahɨci mutɨŋ hɨvɨ lamavɨmi. Lamavɨci Isɨmaelɨ hɨdɨlɨ agɨlaŋ lɨba silɨva hɨvɨ lavavɨmi. Lɨba silɨva human limu limu fɨhala hɨcɨ limu limu fɨhala agɨladɨ hɨvɨ lavavɨmi. Lavavɨci nulɨdɨ sibɨla hɨsɨŋ hulemɨlɨ hɨnimi. Lɨci nudɨ viavɨla Isipɨ fɨli tɨbɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Lɨhavɨci Luben agaŋ vevɨla sɨmɨ tulɨ agadɨ igamɨgua igɨci apalɨ. Josepɨ sɨmɨ tulɨ heŋ ma hɨnimi. Lɨci Luben agaŋ Josepɨ saŋ mavɨn hekɨlɨ viavɨla iaha nudɨ nukeŋ hadi hɨlahɨla hutesɨ agadɨ mɨŋacɨkɨlami. ");
INSERT INTO ena_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","La uavɨla nudɨ imahalinu agɨladɨ abami. Viaŋ ve igɨlɨŋ Josepɨ sɨmɨ tulɨ hɨvɨ ma hɨni uami. I uami. Viaŋ akɨ lɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","32","Lɨci Josepɨ dɨ isagalinu agɨlaŋ sabaŋ meme agadɨ ifɨhɨmavɨmi. Ifɨhɨmavɨla Josepɨ dɨ hadi hɨlahɨla hutesɨ agadɨ via sabaŋ meme agadɨ mɨdɨ hɨvɨ lɨbɨvisa viavɨla iaganɨlu dɨ pɨŋ uavɨla abavɨmi. Alaŋ hadi hɨlahɨla hutesɨ nagaŋ fipɨ mu hɨvɨ hɨnici igavɨla vihɨlu uavɨmi. Igɨha uavɨmi. Ha ninana dɨ hadi hɨlahɨla hutesɨ ua aniaba dɨ ua uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Lɨhavɨci iaganɨlu agaŋ hadi hɨlahɨla hutesɨ agadɨ igavɨla abami. Na iadɨ ninaŋ Josepɨ dɨ hadi hɨlahɨla hutesɨ uami. Sudɨ iŋam akua iava agɨcɨkɨlacɨkɨla na fɨhalalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","La ninanu Josepɨ saŋ mavɨn hekɨlɨ viavɨla nudɨ nukeŋ hadi hɨlahɨla hutesɨ agadɨ mɨŋacɨkɨlami. Mɨŋacɨkɨlavɨla hadi hɨlahɨla hasɨ mavɨn vivi ilɨha ilɨha hɨsɨŋ agadɨ ahualavɨla ninanu saŋ mavɨn vivi ilɨha ilɨha mɨhiŋ akape hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Lɨci nudɨ ninanadinu agɨlaŋ iaganɨlu dɨ mavɨn ifɨmɨgubalu aba lɨhavɨmi ala hɨma. Nulɨdɨ ciaŋ agadɨ ma sɨbaŋ igahɨlami. La nulɨdɨ nameŋ abami. Viaŋ nusaŋ mavɨn vivi ilɨha ilɨha hɨnia hɨmɨben uami. Hameŋ abavɨla mavɨn vivi ilɨha ilɨha pam hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Midian hɨdɨlɨ agɨlaŋ Josepɨ dɨ via ua mutɨŋ lamavɨci Potifalɨ agaŋ lavɨci nudɨ sibɨla hɨsɨŋ hulemɨlɨ hɨniadami. Potifalɨ nɨbu sagaŋ hali hɨsɨŋ hɨnihɨni abɨdaci nudɨ sagaŋ hɨsɨŋ hulemɨlɨ agɨlaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ ulaŋ hekɨlɨ agadɨ migɨlavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Juda agaŋ nudɨ isagalinu imahalinu agɨladɨ valavɨla ua hulaŋ mu Hila agaŋ hula hɨnimi. Hila nɨbu Adulam haiabɨla hɨsɨŋ. ");
INSERT INTO ena_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Hɨniavɨla iamɨgali mu igami. Nudɨ iaganu Soa agaŋ nɨbu Kenan hɨdɨlɨ. Iamɨgali agadɨ igavɨla sabiavɨla nɨbu hula hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Lɨci iamɨgali agaŋ humɨgaŋ ahɨlavɨla ninaŋ huhɨlami. Huhɨlɨci Juda agaŋ ninaŋ agadɨ ibi lamavɨla abami. Elɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Lɨci iamɨgali agaŋ cɨhu humɨgaŋ ahɨlavɨla ninaŋ mu huhɨlami. La nudɨ ibi lamavɨla abami. Onan uami. ");
INSERT INTO ena_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","La cɨhu humɨgaŋ ahɨlavɨla ninaŋ mu avi huhɨlami. Lavɨla nudɨ ibi lamavɨla abami. Saila uami. Kesipɨ haiabɨla hɨniavɨdaci abinu agaŋ Saila dɨ huhɨlami. ");
INSERT INTO ena_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ninaŋ agɨlaŋ hekɨlɨ hekɨlɨ lɨhavɨci Juda agaŋ nudɨ ninaŋ Cimegeŋ Elɨ saŋ iamɨgali vimi. Iamɨgali agadɨ ibi Tamalɨ. ");
INSERT INTO ena_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Elɨ agaŋ akuaba akuaba lusɨŋ sɨbɨlɨ sɨbɨlɨ vihadami agɨladɨ Asɨ Iaue igɨci sɨbɨlɨ lɨmi. Lɨci Elɨ dɨ ifɨhɨmami. ");
INSERT INTO ena_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ifɨhɨmɨci Juda agaŋ Onan dɨ abami. Nama isana dɨ abinu agaŋ hula hɨniha uami. Isana ninanadi apalɨ hɨniavɨla hɨmalɨ uami. Nama aludɨ ciaŋ vɨdɨvɨdɨŋ agadɨ lubiahɨlavɨla isana dɨ cido agadɨ viavɨla ninaŋ akape havɨnaŋ isana dɨ uvɨsɨjiŋ vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Abɨci ala Onan agaŋ mu hulaŋ saŋ ninanadi havahava saŋ valami. Lavɨla isanu saŋ ninanadi havɨmagaŋ aba iamɨgali agaŋ hula hɨnimi agadɨ ala mu lusɨŋ mu lusɨŋ vici iamɨgali agaŋ humɨgaŋ ma ahɨlami. ");
INSERT INTO ena_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Asɨ Iaue agaŋ Onan hameŋ lusɨŋ vimi agadɨ igɨci sɨbɨlɨ lɨmi. Lɨci Onan dɨ avi ifɨhɨmami. ");
INSERT INTO ena_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Lɨci Juda agaŋ nabenu Tamalɨ dɨ abami. Muŋanadina ci hɨmavalɨ uami. Lavɨla Saila avi isagalinu hɨmavalɨ hameŋ laci ala hɨmɨmɨdɨ aba Tamalɨ dɨ abami. Nama uavɨla iagana hula hɨnidanaŋ iadɨ ninaŋ Saila hekɨlɨ lɨm uami. Lɨci Tamalɨ uavɨla nudɨ iaganu hula hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Hɨnici hutesɨ lɨci Juda abinu agaŋ avi hɨmami. Juda abiaganu Soa. Lɨci Juda agaŋ abinu saŋ mavɨn lamɨci ci lɨci Timɨna haiabɨla umi. Hulaŋ nudɨ sabaŋ sipsipɨ mɨnɨ ihalahalaha hɨniavɨmi agɨladɨ igɨben aba umi. Udaci nudɨ nagɨlinu huaci Hila Adulam haiabɨla hɨsɨŋ agaŋ nɨbu hula umi. ");
INSERT INTO ena_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Uavɨdaci hulaŋ mu Tamalɨ dɨ abami. Nadɨ auna sabaŋ sipsipɨ mɨnɨ ihalahɨben aba Timɨna haiabɨla uadi uami. ");
INSERT INTO ena_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Lɨci Tamalɨ hɨji nameŋ lamami. Saila ci hekɨlɨ li uami. Agadɨ ala nudɨ iaganu iadɨ nusaŋ ma igumi uami. Lavɨla hadi hɨlahɨla nɨbu cido hɨnihɨni lamalama hɨdadami agɨladɨ hubɨla lamami. La hadi hɨlahɨla mu lamavɨla nudɨ mugaŋ lamɨgaŋ havɨlɨ hɨvɨ hafilamami. Lavɨla Timɨna haiabɨla saŋ uu veve hɨbɨ cina hɨbɨlɨ mɨgiŋ fipɨ heŋ mɨgahɨnimi. Enaim haiabɨla agadɨ hɨbɨ cɨma agaŋ hɨbɨlɨ mɨgiŋ fipɨ heŋ ala hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Iamɨgali agaŋ mugaŋ lamɨgaŋ havɨlɨ hɨvɨ hafilamavɨla mɨgahɨnidaci Juda agaŋ ve igavɨla hɨbɨ pɨlɨ hɨsɨŋ iamɨgali akua uami. ");
INSERT INTO ena_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Lavɨla nudɨ mikɨ pɨŋ uavɨla abami. E uami. Iabi alaŋ ahica hɨdɨbalu uami. Nabenu nukeŋ agadɨ ala nɨbu ma igami. Hɨbɨ pɨlɨ hɨsɨŋ iamɨgali akua uami. Lɨci iamɨgali agaŋ nudɨ abami. Nama iasaŋ akɨ mɨse igubanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Lɨci Juda abami. Viaŋ sabaŋ meme daŋ uami. Viaŋ nasaŋ sabaŋ meme ninaŋ hekɨlɨ agadɨ igulɨŋ vebali uami. Lɨci iamɨgali agaŋ abami. Ha huaci uami. Agadɨ ala ciaŋ mɨguavɨla abɨbalu agadɨ hɨji mɨŋaiahaiaha saŋ iasaŋ akuaba iguha uami. Igunaŋ via hɨnidalɨŋ iasaŋ sabaŋ meme agadɨ igunaŋ akuaba akuaba agɨladɨ nasaŋ cɨhu iguben uami. ");
INSERT INTO ena_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Lɨci Juda abami. Ciaŋ mɨguavɨla abɨbalu agadɨ hɨji mɨŋaiahaiaha saŋ akɨ iguben uami. Lɨci iamɨgali agaŋ abami. Iasaŋ sihɨ lamalama hɨsɨŋ agadɨdaŋ lɨmɨn nadɨ sugɨtaŋ hɨvɨ hɨni agadɨdaŋ iguha uami. La kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agadɨ avi iasaŋ iguha uami. Lɨci Juda akuaba akuaba agɨladɨ iguavɨla ahica hɨdavɨmi. Hɨdavɨci iamɨgali agaŋ humɨgaŋ ahɨlami. ");
INSERT INTO ena_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Humɨgaŋ ahɨlavɨla iaha umi. Uavɨla havɨlɨ mugaŋ lamɨgaŋ hafilamami agadɨ mɨŋalavɨla lamami. Lavɨla hadi hɨlahɨla cido hɨnihɨni lamalama hɨdadami agɨladɨ cɨhu viavɨla lamami. ");
INSERT INTO ena_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Lɨci hɨniavɨla Juda agaŋ nudɨ akuaba akuaba iamɨgali agasaŋ igumi agɨladɨ cɨhu vivi saŋ sabaŋ meme ninaŋ hekɨlɨ agadɨ viavɨla Hila saŋ iguavɨla abɨci via umi. Via umi agadɨ ala iamɨgali agadɨ ma igami. ");
INSERT INTO ena_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Lavɨla heŋ hɨsɨŋ agɨladɨ abitɨhami. Hɨbɨ pɨlɨ hɨsɨŋ iamɨgali Enaim hɨbɨ pɨlɨ heŋ mɨgahɨnilalɨ agaŋ abanagaŋ uami. Lɨci nudɨ abavɨmi. Heŋ hɨbɨ pɨlɨ hɨsɨŋ iamɨgali mu ma hɨnilalɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Lɨhavɨci Hila Juda dɨ pɨŋ cɨhu vevɨla abami. Iamɨgali agadɨ ma igin uami. Hulaŋ haiabɨla heŋ hɨsɨŋ agɨlaŋ hɨbɨ heŋ hɨbɨ pɨlɨ hɨsɨŋ iamɨgali ma hɨnilalɨ aba abavi uami. ");
INSERT INTO ena_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Lɨci Juda abami. Vana hɨnim uami. Akuaba akuaba agɨladɨ vana via hɨnim uami. Iamɨgali agadɨ cɨhu cɨhu suhɨlɨmɨnaŋ uami. Aludɨ aba aba lɨniavɨmɨdɨ uami. Viaŋ ciaŋ mɨguavɨla abacin agadɨ lubiahɨlavɨla sabaŋ meme ninaŋ hekɨlɨ agadɨ nasaŋ igulɨŋ viavɨla uavɨla ala iamɨgali agadɨ ma igɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Hameŋ abavɨla hɨniavɨdaci avaŋ ahica pam uci ve Juda dɨ abavɨmi. Nadɨ nabena Tamalɨ hɨvɨkalɨ saŋ hɨdavɨla humɨgaŋ ci ahɨlalɨ uavɨmi. Lɨhavɨci Juda abami. Viavɨla ua avɨŋ hɨvɨ havalɨlaŋ mɨgua lɨhuavɨla hɨmam uami. ");
INSERT INTO ena_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Lɨci Tamalɨ dɨ via uben aba lɨhavɨdaci akuaba akuaba Juda igumi agɨladɨ nulɨsaŋ cɨhu iguci via uavɨmi. Via uavɨla Juda dɨ abavɨmi. Tamalɨ nameŋ abi uavɨmi. Akuaba akuaba nagɨladɨ iaganɨlu agaŋ ala lɨci viaŋ humɨgaŋ ahɨlacin aba abi uavɨmi. Sihɨ lamalama hɨsɨŋ nagadɨdaŋ lɨmɨn nagadɨdaŋ igɨha aba abi uavɨmi. Kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ nagadɨ avi igɨha aba abi uavɨmi. Akuaba akuaba nana ani dɨ aba abi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Lɨhavɨci Juda akuaba akuaba agɨladɨ igavɨla abami. Viaŋ iamɨgali agadɨ Saila saŋ ma iguacin sadaŋ viaŋ hugɨ daŋ hɨnidin uami. Iamɨgali agaŋ hugɨ apalɨ uami. Lavɨla Juda agaŋ cɨhu cɨhu nɨbu hula ma hɨdami. ");
INSERT INTO ena_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","La hɨnici hutesɨ lɨci Tamalɨ agaŋ ninanadi viben aba lɨmi. Lɨdaci nudɨ humɨgaŋ agadɨ mɨŋaigavɨci ninanadi ahica hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","La ninaŋ amɨŋ huhɨlami hadɨhu igavɨci ninaŋ mu agadɨ human mɨse ivavemi. Lɨci iamɨgali mu Tamalɨ dɨ hulɨ lagumi agaŋ ninaŋ agadɨ human mɨŋalɨvavɨla muhɨlɨ havɨlɨ hɨcahɨca hɨsɨŋ lɨmɨn cɨki mɨdɨ agadɨ viavɨla ninaŋ agadɨ human hɨvɨ hahami. La abami. Ninaŋ nagaŋ mɨse iahi uami. ");
INSERT INTO ena_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Agadɨ ala ninaŋ agaŋ human cɨhu magɨlɨci ivouci ninaŋ mu agadɨ mɨse huhɨlami. Lɨci iamɨgali hulɨ lagumi agaŋ abami. Nama lɨvalavɨla nama mɨse iahɨnaŋ uami. Lɨci iaganu nudɨ ibi lamavɨla abami. Pelesɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Lɨci cɨhu ninaŋ mu nudɨ human lɨmɨn cɨki hɨvɨ hahami agadɨ avi huhɨlami. Huhɨlɨci iaganu nudɨ ibi lamavɨla abami. Cela uami. ");
INSERT INTO ena_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Isɨmaelɨ hɨdɨlɨ agɨlaŋ Josepɨ dɨ Isipɨ fɨli tɨbɨ via uavɨla mutɨŋ hɨvɨ lamavɨci Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ mu Potifalɨ agaŋ nudɨ sibɨla hɨsɨŋ hulaŋ hɨnibali aba anɨm hɨlɨcɨ hɨvɨ lavami. Potifalɨ nɨbu sagaŋ hali hɨsɨŋ hɨnihɨni abɨdaci nudɨ sagaŋ hɨsɨŋ hulemɨlɨ agɨlaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ ulaŋ hekɨlɨ agadɨ migɨlavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","3","Asɨ Iaue agaŋ Josepɨ hula hɨnidaci Josepɨ agaŋ Potifalɨ dɨ uleŋ muji hɨnihɨni sibɨla vidaci huaci laci hɨniavɨmi. Lɨhavɨci Potifalɨ agaŋ Josepɨ dɨ igɨci Asɨ Iaue agaŋ Josepɨ hula hɨnidaci akuaba akuaba sibɨla vimi agɨlaŋ huaci laci hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Hɨniavɨdaci hɨjɨŋalavɨla abɨci Josepɨ agaŋ Potifalɨ dɨ hɨmamɨgɨlɨ daŋ hɨniadami. Hɨnidaci ulaŋ akuaba akuaba sɨkasɨkan agɨladɨ Josepɨ migɨlɨbali aba nudɨ human hɨvɨ lamami. ");
INSERT INTO ena_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Lɨci Josepɨ hɨmamɨgɨlɨ daŋ hɨnidaci Asɨ Iaue agaŋ hɨdɨlɨ maha Potifalɨ dɨ ulaŋ pam hɨsɨŋ agɨladɨ huaci lamami. Asɨ Iaue agaŋ Josepɨ saŋ igahɨlavɨla Potifalɨ dɨ ulaŋ akuaba akuaba agɨladɨdaŋ sɨmɨŋ isabɨlaŋ hualabɨla hɨsɨŋ agɨladɨdaŋ huaci lamami. ");
INSERT INTO ena_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Lɨci Potifalɨ abɨci Josepɨ agaŋ akuaba akuaba sɨkasɨkan agɨladɨ migɨlɨdaci nɨbu nukeŋ akuaba cɨki saŋ avi hɨji ma lamami. Nɨbu akuaba akuaba nana saŋ pam hɨji lamami. Josepɨ dɨ mugaŋ lamɨgaŋ hadipɨlɨ agaŋ huaci sɨbaŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Lɨci Potifalɨ abinu agaŋ Josepɨ dɨ mavɨn igavɨla nudɨ abami. Nama ve viaŋ hula hɨdɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Abɨci ala hɨma. Josepɨ agaŋ valavɨla nudɨ abami. Iadɨ manɨgali agaŋ akuaba akuaba ulaŋ neŋ hɨsɨŋ agɨladɨ migɨla migɨla saŋ iadɨ lɨbɨmɨŋalɨ uami. Lavɨla nudɨ akuaba akuaba agɨlasaŋ hɨji ma lamɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Viaŋ manɨgali nɨbu nukeŋ me ala ulaŋ nagadɨ manɨgali hɨnilan uami. Nɨbu akuaba cɨki agasaŋ avi iadɨ ma abamɨgɨlalɨ uami. Agadɨ ala nama hula hɨdahɨda saŋ iadɨ abamɨgɨlalɨ uami. Nama nudɨ iamɨgali sadaŋ iadɨ abamɨgɨlalɨ uami. Hameŋ sadaŋ viaŋ nama hula lusɨŋ sɨbɨlɨ ma viben uami. Viaŋ hameŋ lɨlɨŋ Asɨ iadɨ igɨci viaŋ hugɨ daŋ hɨniben uami. ");
INSERT INTO ena_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Lɨci uaiaŋ pabiŋ pabiŋ hɨvɨ iamɨgali agaŋ Josepɨ hula hɨdahɨda saŋ abitɨhadami. Abitɨhɨdaci Josepɨ agaŋ iamɨgali agadɨ sɨdaŋ ciaŋ ciaŋ agadɨ ma igahɨladami. La nɨbu hula ma hɨdadami. Nudɨ mikɨ pɨŋ avi ma uadami. ");
INSERT INTO ena_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Lavɨla uaiaŋ mu hɨvɨ Josepɨ agaŋ nudɨ sibɨla viben aba uleŋ muji ivoumi. Uleŋ muji heŋ sibɨla hɨsɨŋ hulaŋ mu avi ma hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Lɨci Potifalɨ abinu agaŋ Josepɨ dɨ hadi hɨlahɨla hutesɨ agadɨ mɨŋalɨvavɨla nudɨ abami. Nama ve viaŋ hula hɨdɨha uami. La iamɨgali agaŋ Josepɨ dɨ hadi hɨlahɨla hutesɨ agadɨ mɨŋasutavɨla mɨŋalɨva hɨnidaci haŋɨlavɨla ulaŋ agadɨ valavɨla ivavemi. ");
INSERT INTO ena_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Iamɨgali agaŋ igɨci Josepɨ agaŋ nudɨ hadi hɨlahɨla agadɨ vala haŋɨla ivavemi. ");
INSERT INTO ena_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","15","Lɨci sibɨla hɨsɨŋ hulaŋ agɨladɨ ulavɨla abami. Namɨlaŋ igɨhalaŋ uami. Iadɨ hulaŋ agaŋ hulaŋ Ibɨlu ciaŋ hɨsɨŋ agadɨ vaveci aludɨ ulaŋ hɨvɨ sibɨla vilalɨ agaŋ alusaŋ sɨhum hekɨlɨ igui uami. Nɨbu uleŋ muji iadɨ uvɨ heŋ ivouavɨla viaŋ hula hɨdahɨda saŋ iadɨ abi uami. Lɨci viaŋ vɨdɨvɨdɨŋ agalɨlɨŋ igahɨlavɨla nudɨ hadi hɨlahɨla hutesɨ nagadɨ iadɨ pɨŋ valavɨla haŋɨla haiabɨla ivave uami. ");
INSERT INTO ena_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Potifalɨ abinu agaŋ Josepɨ dɨ hadi hɨlahɨla hutesɨ agadɨ mɨŋalɨva hɨnidaci muŋanu agaŋ nudɨ ulaŋ hɨvɨ vemi. ");
INSERT INTO ena_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Veci sibɨla hɨsɨŋ hulaŋ agɨladɨ sulami hameŋ ala cɨhu muŋanu dɨ sulavɨla abami. Nama hulaŋ Ibɨlu ciaŋ hɨsɨŋ agadɨ vavenaŋ aludɨ ulaŋ hɨvɨ sibɨla vilalɨ agaŋ alusaŋ sɨhum hekɨlɨ iguiemi uami. Nɨbu viaŋ hula hɨdahɨda saŋ abiemi uami. ");
INSERT INTO ena_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Lɨci viaŋ vɨdɨvɨdɨŋ agalɨlɨŋ nudɨ hadi hɨlahɨla hutesɨ agadɨ iadɨ pɨŋ valavɨla haŋɨla haiabɨla ivaveiemi uami. ");
INSERT INTO ena_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Lɨci muŋanu agaŋ abinu dɨ ciaŋ agadɨ igahɨlavɨla igɨvɨ hekɨlɨ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","La sagaŋ hɨsɨŋ hulemɨlɨ agɨladɨ abɨci Josepɨ dɨ mɨŋalɨvavɨla via ua lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ lamavɨmi. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ hulaŋ lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ lamɨben aba ulaŋ heŋ ala lamadami. Josepɨ dɨ avi lɨmɨn sɨbɨlɨ ulaŋ heŋ ala lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Lamavɨci hɨnidaci Asɨ Iaue agaŋ Josepɨ hula hɨnihɨni nusaŋ mavɨn hɨniavɨla nudɨ huaci lamami. La Asɨ Iaue agaŋ lɨci hulaŋ lɨmɨn sɨbɨlɨ ulaŋ migɨladami agaŋ Josepɨ dɨ igavɨla hɨjɨŋalami. ");
INSERT INTO ena_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Lavɨla Josepɨ dɨ lɨbɨmɨŋɨci hɨmamɨgɨlɨ daŋ hɨnihɨni lɨmɨn sɨbɨlɨ ulaŋ agadɨdaŋ hulaŋ lɨmɨn sɨbɨlɨ ulaŋ heŋ hɨniavɨhadami agɨladɨdaŋ migɨlami. ");
INSERT INTO ena_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Asɨ Iaue agaŋ Josepɨ hula hɨniavɨla nudɨ ahɨliahumi. Lɨci akuaba akuaba sibɨla Josepɨ vimi agɨlaŋ huaci laci hɨniavɨmi. Lɨhavɨci hulaŋ lɨmɨn sɨbɨlɨ ulaŋ migɨladami agaŋ sibɨla vivi saŋ hɨji ma lamami. ");
INSERT INTO ena_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Hɨniavɨci hutesɨ lɨci hulaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali saŋ lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ iguadami agaŋ lusɨŋ sɨbɨlɨ vimi. Lɨci hulaŋ manɨgali saŋ maci hɨlanana hɨsɨŋ fipɨ migɨladami agaŋ avi lusɨŋ sɨbɨlɨ vimi. ");
INSERT INTO ena_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Lavɨla Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ hula hugɨ daŋ hɨniavɨmi. Hɨniavɨdaci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ nulɨsaŋ igɨvɨ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Igɨvɨ hɨniavɨla abɨci ahica agɨladɨ vioua sagaŋ hali hɨsɨŋ agadɨ ulaŋ hɨvɨ lamavɨmi. Sagaŋ hali hɨsɨŋ agaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ ulaŋ hekɨlɨ migɨladami. Lamavɨci lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ hɨniavɨmi. Lɨmɨn sɨbɨlɨ ulaŋ heŋ ala Josepɨ dɨ avi lamavɨci hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Hɨniavɨdaci sagaŋ hali hɨsɨŋ agaŋ Josepɨ dɨ lɨbɨmɨŋɨci ahica agɨladɨ migɨlɨdaci lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ hutesɨ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","La hɨfɨlɨ pabiŋ hɨvɨ laci hulaŋ manɨgali saŋ lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ iguadami agaŋ hula hulaŋ manɨgali saŋ maci hɨlanana hɨsɨŋ fipɨ migɨladami agaŋ hula anisɨhu igavɨmi. Nulɨdɨ anisɨhu agɨlaŋ pam hɨma. Anisɨhu agɨladɨ ciaŋ hɨdɨlɨ avi pam ma hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Lɨhavɨci Josepɨ agaŋ cimɨdaŋ uavɨla ahica agɨladɨ igɨci hɨji cuvɨlɨŋ cuvɨlɨŋ lamalama mugaŋ lɨbavɨla hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Lɨhavɨci ahica agɨladɨ abami. Akɨ lɨci namɨlaŋ ahica hɨji cuvɨlɨŋ cuvɨlɨŋ lamalama mugaŋ lɨbavɨla hɨnilaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Lɨci ahica agɨlaŋ abavɨmi. Alaŋ ahica anisɨhu igiemɨlu uavɨmi. Agadɨ ala hulaŋ aludɨ anisɨhu hɨdɨlɨ agɨlasaŋ aba aba agaŋ apalɨ uavɨmi. Lɨhavɨci Josepɨ ahica agɨladɨ abami. Asɨ laci nɨbu aludɨ anisɨhu hɨdɨlɨ agɨladɨ abalamɨlalɨ uami. Alialaŋ uami. Naludɨ anisɨhu agɨladɨ iasaŋ sulɨlaŋ igahɨlɨlɨŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Lɨci hulaŋ manɨgali saŋ lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ iguadami agaŋ nudɨ anisɨhu agadɨ sulasula abami. Viaŋ anisɨhu igiemin ha lɨmɨn uain agadɨ igiemin uami. ");
INSERT INTO ena_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Lɨmɨn uain agaŋ makaŋ ahica pam daŋ igiemin uami. Makaŋ ahica pam heŋ asɨŋ iahavɨla lɨhalɨha sɨbaŋ fu lamavɨla amɨŋ lamɨci sɨkasɨkan mɨdɨ lɨhuavɨla hɨniavɨdaci igiemin uami. ");
INSERT INTO ena_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Lavɨla Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ hɨcɨhaŋ mɨŋalɨvavɨla lɨmɨn uain agɨladɨ amɨŋ agɨladɨ viemin uami. Viavɨla human hɨvɨ mɨŋacabɨlɨdalɨŋ nulɨdɨ mɨtɨ agaŋ hɨcɨhaŋ hɨvɨ mɨguci via uavɨla manɨgali saŋ iguiemin uami. ");
INSERT INTO ena_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Lɨci Josepɨ abami. Nadɨ anisɨhu agadɨ hɨdɨlɨ nɨbu nameŋ uami. Lɨmɨn uain makaŋ ahica pam ha uaiaŋ ahica pam saŋ igiemɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Anihuliŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ abɨci nadɨ via uavɨbali uami. Lɨci nama vaka manɨgali saŋ lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ hɨcɨhaŋ hɨvɨ iguadamɨnaŋ hameŋ laci ala igubanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","La nama huaci hɨniavɨla iasaŋ igahɨlɨha uami. Lavɨla iasaŋ mavɨn hɨniavɨla viaŋ lɨmɨn sɨbɨlɨ ulaŋ nagadɨ vala uu saŋ manɨgali agadɨ abɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Vaka iadɨ nukeŋ fɨli tɨbɨ heŋ hɨnidalɨŋ iadɨ vɨdɨvɨdɨŋ mɨŋalɨva via vavehavɨci neŋ hɨnilan uami. La viaŋ Isipɨ fɨli tɨbɨ neŋ hɨniavɨla akuaba lusɨŋ sɨbɨlɨ ma vilan uami. Lɨmɨn sɨbɨlɨ ulaŋ neŋ iadɨ havɨ sɨbaŋ lamavalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Lɨci hulaŋ manɨgali saŋ maci hɨlanana hɨsɨŋ fipɨ migɨladami agaŋ igahɨlɨci hulaŋ manɨgali saŋ lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ iguadami agadɨ anisɨhu hɨdɨlɨ agaŋ huaci lɨci Josepɨ dɨ abami. Viaŋ avi anisɨhu igiemin uami. Anisɨhu igiemin agaŋ nɨbu nameŋ uami. Cinacina ahica pam agɨladɨ hɨvɨ maci huaci huaci hɨniavɨdaci iadɨ hali sabɨ hɨvɨ lamɨlɨŋ hɨniaviemi uami. ");
INSERT INTO ena_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Cinacina iadɨ hali sabɨ sɨbaŋ hɨniemi heŋ maci mu hɨdɨlɨ mu hɨdɨlɨ manɨgali nɨlalɨ agɨlaŋ mɨlavɨla hɨniaviemi uami. Agadɨ ala havaŋ agɨlaŋ veve maci agɨladɨ naviemi uami. ");
INSERT INTO ena_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Lɨci Josepɨ abami. Nadɨ anisɨhu agadɨ hɨdɨlɨ agaŋ nɨbu nameŋ uami. Cinacina ahica pam ha uaiaŋ ahica pam saŋ igiemɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Anihuliŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ abɨci sagaŋ hɨsɨŋ hulemɨlɨ agɨlaŋ vevɨla nadɨ via uavɨla nadɨ sugɨtaŋ ihalahavɨbali uami. Ihalahavɨla hɨda hɨvɨ lagɨlamavɨci hɨnidanaŋ havaŋ agɨlaŋ veve nadɨ valɨ agadɨ navɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Lɨci anihuliŋ me hɨvɨ manɨgali agaŋ nudɨ sibɨla hɨsɨŋ agɨladɨ abɨci sɨmɨŋ hekɨlɨ hɨlanavɨmi. Iamɨnu vaka nudɨ huhɨlami agasaŋ igahɨlavɨla abɨci hɨlanavɨmi. Lɨhavɨci hulaŋ nusaŋ lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ iguadami agadɨdaŋ hulaŋ nudɨ maci hɨlanana hɨsɨŋ fipɨ migɨladami agadɨdaŋ vavehavɨci lagulama hɨniavɨdaci manɨgali agaŋ nulɨdɨ igasulami. ");
INSERT INTO ena_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","La hulaŋ nusaŋ lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ iguadami agadɨ abɨci nudɨ sibɨla uvɨsɨjiŋ agasaŋ cɨhu ala umi. ");
INSERT INTO ena_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Lɨci sagaŋ hɨsɨŋ hulemɨlɨ agɨladɨ abɨci hulaŋ nudɨ maci hɨlanana hɨsɨŋ fipɨ migɨladami agadɨ sugɨtaŋ ihalahavɨla hɨda hɨvɨ lagɨlamavɨmi. Josepɨ anisɨhu hɨdɨlɨ agɨladɨ abami agɨlaŋ hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Lɨhavɨci hulaŋ lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ manɨgali saŋ iguadami agaŋ Josepɨ saŋ hɨji ma lamami. Nɨbu sɨkasɨkan uava iahumi. ");
INSERT INTO ena_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","2","Hualɨ ahica uci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ anisɨhu hɨvɨ Nailɨ avɨli caba heŋ lagulama hɨnihɨni igami. Igɨdaci sabaŋ bulɨmakau huaci huaci sɨbaŋ hadipɨlɨ daŋ human limu fɨhala human limu ahica cɨjɨŋ agɨlaŋ avɨli hɨvɨ hɨnia iahavɨmi. Iahavɨla avɨli agadɨ mikɨ heŋ humɨsɨ navɨmi. ");
INSERT INTO ena_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Lɨhavɨdaci cɨhu igɨci sabaŋ bulɨmakau human limu fɨhala human limu ahica cɨjɨŋ limu hɨhɨle agɨlaŋ avɨli hɨvɨ hɨnia iahavɨmi. Sabaŋ bulɨmakau agɨlaŋ hadi valavɨla henaŋ henaŋ la sɨbɨlɨ sɨbaŋ hɨniavɨmi. Nɨbɨlaŋ iahavɨla avɨli caba heŋ sabaŋ bulɨmakau limu hɨhɨle huaci huaci agɨladɨ mikɨ lagulamavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Lavɨla sabaŋ bulɨmakau henaŋ henaŋ human limu fɨhala human limu ahica cɨjɨŋ agɨlaŋ sabaŋ bulɨmakau hadipɨlɨ daŋ agɨladɨ iavaiava na fɨhalavɨmi. Manɨgali agaŋ anisɨhu agadɨ igavɨla iahami. ");
INSERT INTO ena_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","La ani hɨsɨvavɨla cɨhu anisɨhu igɨdaci halɨha cahu uitɨ pɨlɨ pabiŋ heŋ cɨhu cɨma cɨma human limu fɨhala human limu ahica cɨjɨŋ agɨlaŋ iahavɨmi. Halɨha cahu uitɨ cɨma cɨma agɨlaŋ iaha hekɨlɨ lavɨla hɨlɨcɨ akape daŋ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Lɨhavɨdaci cɨhu halɨha cahu uitɨ cɨma cɨma human limu fɨhala human limu ahica cɨjɨŋ limu hɨhɨle agɨlaŋ pɨlɨ mu hɨvɨ iahavɨmi. Iahavɨci huŋe avɨŋ daŋ me agaŋ fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ hɨnia vevɨla hɨlahɨmɨci halɨha cahu uitɨ agɨladɨ hɨlɨcɨ agɨlaŋ kusɨ kusɨ lɨdɨŋ sudɨme cɨki cɨki sɨbaŋ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","La halɨha cahu uitɨ cɨma cɨma hɨlɨcɨ sudɨme cɨki cɨki daŋ agɨlaŋ halɨha cahu uitɨ cɨma cɨma hekɨlɨ hekɨlɨ hɨlɨcɨ akape daŋ agɨladɨ na fɨhalavɨmi. Lɨhavɨci manɨgali agaŋ iahavɨla abami. O anisɨhu igin uami. ");
INSERT INTO ena_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","La cimɨdaŋ hɨji cuvɨlɨŋ cuvɨlɨŋ igahɨlami. Lavɨla Isipɨ fɨli tɨbɨ hɨsɨŋ hau hubɨla hubɨla hɨsɨŋ agɨlasadaŋ hulaŋ hɨji hutesɨ daŋ agɨlasadaŋ ciaŋ iguci uci nɨbɨlaŋ ahuata hameŋ vehavɨmi. Vehavɨci nudɨ anisɨhu ahica agɨladɨ nulɨsaŋ sulami. Lɨci hulaŋ agɨlaŋ avi nudɨ anisɨhu hɨdɨlɨ agɨladɨ ma igavɨmi sadaŋ ciaŋ ma abavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Lɨhavɨci hulaŋ manɨgali saŋ lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ iguadami agaŋ manɨgali agadɨ abami. Viaŋ hulaŋ mu dɨ ciaŋ agadɨ vave nadɨ ma abacin agasaŋ hugɨ daŋ hɨnidin uami. ");
INSERT INTO ena_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Manɨgali uami. Vaka nama nadɨ sibɨla hɨsɨŋ hulaŋ agɨlasaŋ igɨvɨ hɨniahanaŋ uami. Lavɨla abɨnaŋ iadɨdaŋ hulaŋ nadɨ maci hɨlanana hɨsɨŋ fipɨ migɨlɨlalɨ agadɨdaŋ via uavalɨ uami. Via uavɨla sagaŋ hali hɨsɨŋ nadɨ ulaŋ migɨlɨlalɨ agadɨ ulaŋ heŋ aludɨ lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ lamavalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","La hɨfɨlɨ pabiŋ hɨvɨ laci viaŋ anisɨhu igɨdalɨŋ nɨbu avi anisɨhu igalɨ uami. Aludɨ anisɨhu agɨlaŋ nɨbɨlaŋ hɨdɨlɨ daŋ hɨniavalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Hulaŋ mɨnibɨlɨ mu Ibɨlu ciaŋ hɨsɨŋ agaŋ nɨbu alaŋ hula hɨnilɨ uami. Nɨbu sagaŋ hali hɨsɨŋ nadɨ ulaŋ migɨlɨlalɨ agadɨ sibɨla hɨsɨŋ hulaŋ uami. Alaŋ anisɨhu igahɨlu agadɨ nudɨ hɨvɨ sulahɨlu uami. Sulɨmɨli nɨbu aludɨ anisɨhu hɨdɨlɨ hɨtɨŋ hɨtɨŋ agɨlasaŋ aludɨ abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Lɨci akuaba akuaba nɨbu abalɨ agɨlaŋ hameŋ laci lɨhavalɨ uami. Viaŋ iadɨ sibɨla uvɨsɨjiŋ cɨhu vicin uami. Hulaŋ nadɨ maci hɨlanana hɨsɨŋ fipɨ migɨlɨlalɨ agadɨ sugɨtaŋ ihalahavɨla hɨda hɨvɨ lagɨlamavalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Lɨci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ ciaŋ agadɨ igahɨlavɨla Josepɨ dɨ lɨhalɨha vavevave saŋ nudɨ sibɨla hɨsɨŋ agɨladɨ abɨci lɨmɨn sɨbɨlɨ ulaŋ uavɨmi. Uavɨla Josepɨ dɨ vavehavɨmi. Vavehavɨci Josepɨ agaŋ alɨmɨnɨ ihalahavɨla hadi hɨlahɨla hɨhi lamɨci heŋ manɨgali agadɨ pɨŋ via ivouavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ivouavɨci manɨgali agaŋ Josepɨ dɨ abami. Viaŋ anisɨhu igiemin agadɨ hulaŋ mu iadɨ anisɨhu hɨdɨlɨ agasaŋ ma abɨmaŋ uami. Hulaŋ mu iadɨ nameŋ abi uami. Nama huaci anisɨhu hɨdɨlɨ agasaŋ abɨbanaŋ aba abi uami. ");
INSERT INTO ena_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Lɨci Josepɨ abami. Viaŋ nukeŋ hɨma uami. Asɨ laci nadɨ anisɨhu hɨdɨlɨ agadɨ sɨhɨvia sulɨci igahɨlavɨla huaci hɨnibanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","18","Lɨci manɨgali agaŋ abami. Viaŋ anisɨhu nameŋ agadɨ igiemin uami. Viaŋ Nailɨ avɨli caba lagulama igɨdalɨŋ sabaŋ bulɨmakau huaci huaci sɨbaŋ hadipɨlɨ daŋ human limu fɨhala human limu ahica cɨjɨŋ agɨlaŋ avɨli hɨvɨ hɨniavɨla iahaviemi uami. Iahavɨla avɨli agadɨ mikɨ heŋ humɨsɨ naviemi uami. ");
INSERT INTO ena_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Nana hɨniavɨdaci cɨhu sabaŋ bulɨmakau human limu fɨhala human limu ahica cɨjɨŋ hadi valavɨla henaŋ henaŋ la sɨbɨlɨ sɨbaŋ hɨniavalɨ agɨlaŋ sɨvɨ iahaviemi uami. Viaŋ Isipɨ fɨli tɨbɨ neŋ sabaŋ bulɨmakau henaŋ henaŋ hameŋ agɨladɨ ma igɨlan uami. ");
INSERT INTO ena_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Lavɨla sabaŋ bulɨmakau henaŋ henaŋ agɨlaŋ sabaŋ bulɨmakau hadipɨlɨ daŋ hali iahaviemi agɨladɨ iavaiava na fɨhalaviemi uami. ");
INSERT INTO ena_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Naviemi agadɨ ala cɨhu ma nana me hɨniaviemi uami. Henaŋ henaŋ hɨniavɨdaci igiemin hameŋ laci ala sɨbɨlɨ sɨbaŋ hɨniaviemi uami. Anisɨhu hameŋ agadɨ igavɨla iahiemin uami. ");
INSERT INTO ena_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","La cɨhu ani hɨsɨvavɨla anisɨhu mu igiemin uami. Igɨdalɨŋ halɨha cahu uitɨ pɨlɨ pabiŋ heŋ cɨma cɨma human limu fɨhala human limu ahica cɨjɨŋ agɨlaŋ iahaviemi uami. Nɨbɨlaŋ hekɨlɨ lavɨla hɨlɨcɨ akape lamavɨci igiemin uami. ");
INSERT INTO ena_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","La cɨhu halɨha cahu uitɨ cɨma cɨma human limu fɨhala human limu ahica cɨjɨŋ agɨlaŋ pɨlɨ mu hɨvɨ iahavɨdaci igiemin uami. Igɨdalɨŋ huŋe avɨŋ daŋ me agaŋ fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ hɨnia veci halɨha cahu uitɨ agɨladɨ hɨlɨcɨ agɨlaŋ kusɨ kusɨ lɨdɨŋ sudɨme cɨki cɨki sɨbaŋ hɨniaviemi uami. ");
INSERT INTO ena_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","La halɨha cahu uitɨ cɨma cɨma kusɨ kusɨ human limu fɨhala human limu ahica cɨjɨŋ agɨlaŋ halɨha cahu uitɨ cɨma cɨma human limu fɨhala human limu ahica cɨjɨŋ huaci huaci hɨlɨcɨ akape daŋ agɨladɨ na fɨhalaviemi uami. Lɨhavɨci iahavɨla iadɨ anisɨhu hɨdɨlɨ agɨladɨ abavɨci igɨben aba hau hubɨla hubɨla hɨsɨŋ agɨladɨ abɨlɨŋ vehaviemi uami. Vevɨla iadɨ anisɨhu hɨdɨlɨ agɨladɨ ma igaviemi sadaŋ ciaŋ ma abɨmaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Lɨci Josepɨ agaŋ manɨgali agadɨ abami. Nadɨ anisɨhu agɨladɨ ciaŋ hɨdɨlɨ nɨbu pabiŋ laci uami. Asɨ akuaba akuaba lɨben aba hɨji lamiemi agadɨ nadɨ haiabɨla iaha abalamiemi uami. ");
INSERT INTO ena_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Sabaŋ bulɨmakau huaci huaci human limu fɨhala human limu ahica cɨjɨŋ ha hualɨ human limu fɨhala human limu ahica cɨjɨŋ uami. Halɨha cahu uitɨ cɨma cɨma huaci huaci human limu fɨhala human limu ahica cɨjɨŋ han avi hualɨ human limu fɨhala human limu ahica cɨjɨŋ uami. Nulɨdɨ hɨdɨlɨ pabiŋ laci uami. ");
INSERT INTO ena_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Sabaŋ bulɨmakau henaŋ henaŋ human limu fɨhala human limu ahica cɨjɨŋ sɨvɨ iahaviemi ha hualɨ human limu fɨhala human limu ahica cɨjɨŋ uami. Halɨha cahu uitɨ cɨma cɨma human limu fɨhala human limu ahica cɨjɨŋ pɨlɨ mu hɨvɨ iahavɨci huŋe avɨŋ daŋ me agaŋ vevɨla hɨlahɨmɨci sɨbɨlɨ sɨbɨlɨ lavɨla hɨlɨcɨ ma lamaviemi han avi hualɨ human limu fɨhala human limu ahica cɨjɨŋ uami. Humɨgaŋ ibɨlibɨliŋ hekɨlɨ hɨnidaci hualɨ human limu fɨhala human limu ahica cɨjɨŋ ubali uami. ");
INSERT INTO ena_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ha nadɨ ci abin uami. Asɨ akuaba akuaba lɨben aba hɨji lamiemi agadɨ nadɨ abalamiemi uami. ");
INSERT INTO ena_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ sɨmɨŋ akape daŋ hɨniavɨdaci hualɨ human limu fɨhala human limu ahica cɨjɨŋ ubali uami. ");
INSERT INTO ena_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Lɨci cɨhu humɨgaŋ ibɨlibɨliŋ hekɨlɨ iahɨdaci hualɨ human limu fɨhala human limu ahica cɨjɨŋ ubali uami. Lɨdaci humɨgaŋ ibɨlibɨliŋ agaŋ iahavɨla fɨli tɨbɨ nagadɨ sɨbɨlɨ lamɨci nɨbɨlaŋ sɨmɨŋ isabɨlaŋ apalɨ hɨniavɨbali agasaŋ pam igahɨlavɨbali uami. Humɨgaŋ ibɨlibɨliŋ ma iahɨmaŋ lɨdaci sɨmɨŋ akape daŋ hɨniavɨbali agasaŋ ma igahɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Asɨ agaŋ akuaba akuaba agɨladɨ amɨŋ ci sɨbaŋ lɨben aba hɨji lamalɨ uami. Hameŋ sadaŋ akuaba akuaba lɨben aba li agɨladɨ anisɨhu ahica ahica agɨladɨ hɨvɨ nadɨ abalamiemi uami. ");
INSERT INTO ena_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Hulaŋ mu hɨji hutesɨ daŋ hɨji huaci daŋ agadɨ suhɨla igavɨla lɨbɨmɨŋɨnaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ sibɨla akuaba akuaba agɨladɨ migɨlam uami. ");
INSERT INTO ena_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Migɨlɨdaci huban limu hɨhɨle avi lɨbɨmɨŋɨnaŋ manɨgali hɨji hutesɨ daŋ lɨbɨmɨŋɨbanaŋ agadɨ lɨhu hɨvɨ hɨnihɨni Isipɨ fɨli tɨbɨ migɨlavɨm uami. Hulaŋ iamɨgali agɨlaŋ hualabɨla sɨmɨŋ akape daŋ hɨniavɨdaci hualɨ human limu fɨhala human limu ahica cɨjɨŋ ubali uami. Hualɨ hameŋ udaci sɨmɨŋ vivi human limu fɨhala mɨguŋ lamavɨm uami. Lamavɨci hɨniavɨdaci labɨla labɨla pabiŋ mɨguŋ huban saŋ iguavɨm uami. ");
INSERT INTO ena_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Hualɨ huaci huaci heŋ huban agɨlaŋ sɨmɨŋ agɨladɨ mɨgudɨbavɨm uami. Nɨbɨlaŋ nadɨ lɨhu hɨvɨ hɨnihɨni sibɨla vivi halɨha cahu uitɨ akuaba akuaba agɨladɨ sɨmɨŋ mɨgudɨbalɨba ulaŋ nulɨdɨ haiabɨla hɨtɨŋ hɨtɨŋ heŋ mɨgudɨbavɨm uami. ");
INSERT INTO ena_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Lɨhavɨci humɨgaŋ ibɨlibɨliŋ Isipɨ fɨli tɨbɨ iahɨci hulaŋ iamɨgali agɨlaŋ huban sɨmɨŋ mɨgudɨbavɨbali heŋ sɨmɨŋ vihavɨbali uami. Hameŋ lɨnaŋ humɨgaŋ ibɨlibɨliŋ agaŋ iahɨci hulaŋ iamɨgali agɨlaŋ ma haba hɨma fɨhalavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Lɨci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ hulaŋ nusaŋ hɨji igu igu hɨsɨŋ agɨlaŋ hula Josepɨ dɨ ciaŋ igahɨlavɨla abavɨmi. Ha huaci uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","La Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ hulaŋ nusaŋ hɨji igu igu hɨsɨŋ agɨladɨ abami. Asɨ dɨ Amɨŋ agaŋ hulaŋ nagaŋ hula hɨnilalɨ uami. Sibɨla nagadɨ vivi hɨsɨŋ hulaŋ mu ma hɨni uami. ");
INSERT INTO ena_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Hameŋ abavɨla Josepɨ dɨ abami. Asɨ nukeŋ akuaba akuaba iahavɨbali agasaŋ nadɨ ci abalami uami. Aludɨ hulaŋ mu hɨji hutesɨ daŋ hɨji huaci daŋ nama me agaŋ ma hɨni uami. ");
INSERT INTO ena_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Viaŋ lɨlɨŋ nama manɨgali hɨnihɨni iadɨ fɨli tɨbɨ migɨlɨdanaŋ iadɨ hulaŋ iamɨgali agɨlaŋ nadɨ ciaŋ lubiahɨlavɨbali uami. Agadɨ ala viaŋ manɨgali hekɨlɨ sadaŋ naludɨ sɨkasɨkan lalɨgua hɨniben uami. ");
INSERT INTO ena_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Viaŋ nadɨ lɨbɨmɨŋɨlɨŋ manɨgali hɨnihɨni Isipɨ fɨli tɨbɨ nagadɨ sɨkasɨkan migɨlɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","La human cɨjɨŋ hɨsɨŋ hajɨŋ nudɨ nukeŋ ibi daŋ nudɨ human cɨjɨŋ hɨvɨ hɨnimi agadɨ mɨŋahubɨlavɨla Josepɨ dɨ human cɨjɨŋ hɨvɨ lamami. Lamavɨla abɨci hadi hɨlahɨla mila mu huaci sɨbaŋ agadɨ via Josepɨ dɨ hɨvɨ lamavɨmi. Lɨhavɨci manɨgali agaŋ sugɨtaŋ hɨsɨŋ hajɨŋ lɨba golɨ hɨvɨ vihavɨmi agadɨ viavɨla Josepɨ dɨ sugɨtaŋ hɨvɨ manilamami. ");
INSERT INTO ena_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Manilamavɨla hulaŋ mu manɨgali agadɨ lɨhu hɨvɨ hɨniadami agadɨ sabaŋ osɨ magɨla magɨla hɨsɨŋ vadɨm agadɨ Josepɨ saŋ valɨci viavɨla hɨdami. Lɨdaci sibɨla hɨsɨŋ hulaŋ agɨlaŋ fɨli hɨvɨ hali uu abavɨmi. Manɨgali saŋ huacɨhalaŋ uavɨmi. Manɨgali agaŋ hameŋ lɨci Josepɨ agaŋ Isipɨ fɨli tɨbɨ agadɨ sɨkasɨkan migɨladami. ");
INSERT INTO ena_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Migɨlɨdaci manɨgali agaŋ Josepɨ dɨ abami. Viaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali uami. Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ mu agaŋ akuaba akuaba lɨben aba nudɨ nukeŋ hɨji ma lubiahɨlɨbali uami. Ve nadɨ abɨci alia aba abɨnaŋ heŋ akuaba akuaba lɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","La Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ Josepɨ dɨ ibi mu lamavɨla abami. Nadɨ ibi Safenatɨpanea uami. Lavɨla cɨhu nusaŋ iamɨgali igumi. Iamɨgali agadɨ ibi Asenatɨ. Nɨbu Potifela dɨ nadi. Potifela agaŋ On haiabɨla hɨnihɨni mugɨluŋ saŋ sagalɨ iguadami. Lɨdaci Josepɨ agaŋ ibi daŋ hɨnihɨni Isipɨ fɨli tɨbɨ agadɨ migɨladami. ");
INSERT INTO ena_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josepɨ numɨgaŋ nudɨ huhɨlɨci iaha hɨnidaci hualɨ 30 umi. Lɨci heŋ hɨdɨlɨ maha Isipɨ fɨli tɨbɨ agadɨ migɨlami. La nɨbu manɨgali agadɨ valavɨla Isipɨ fɨli tɨbɨ sɨkasɨkan hɨdami. ");
INSERT INTO ena_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ sɨmɨŋ akape hulihuli vivi navɨdaci hualɨ human limu fɨhala human limu ahica cɨjɨŋ umi. ");
INSERT INTO ena_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Lɨhavɨdaci Josepɨ agaŋ migɨlɨdaci huban agɨlaŋ sɨmɨŋ akape mɨgudɨbavɨhadami. Sɨmɨŋ mɨgudɨbalɨba hɨsɨŋ ulaŋ nulɨdɨ haiabɨla hɨtɨŋ hɨtɨŋ hɨniavɨmi heŋ mɨgudɨbavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Halɨha cahu uitɨ akuaba akuaba sɨmɨŋ mɨgudɨbalɨba hɨsɨŋ ulaŋ hɨvɨ mɨgudɨbavɨmi agɨlaŋ akape sɨbaŋ hɨniavɨmi. La hacɨŋ hɨlɨcɨ me hɨniavɨdaci Josepɨ agaŋ abɨci lugɨla lugɨla via uavɨci hɨma lɨci valavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Humɨgaŋ ibɨlibɨliŋ hekɨlɨ agaŋ ma iahɨmaŋ lɨdaci Josepɨ abinu Asenatɨ agaŋ ninaŋ ahica huhɨlami. Asenatɨ nɨbu Potifela dɨ nadi. Potifela agaŋ On haiabɨla hɨnihɨni mugɨluŋ saŋ sagalɨ iguadami. ");
INSERT INTO ena_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Lɨdaci Josepɨ agaŋ abami. Asɨ agaŋ iadɨ ahɨliahuci akuaba akuaba vɨhɨlɨ agɨlasaŋ ma igahɨlin uami. Iadɨ iavaŋ dɨ hɨdɨlɨ pam agɨlasaŋ avi ma igahɨlin uami. Nusaŋ igahɨlavɨla ninaŋ Cimegeŋ agadɨ ibi lamavɨla abami. Manase uami. ");
INSERT INTO ena_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","La cɨhu abami. Viaŋ haiabɨla neŋ hɨnihɨni vɨhɨlɨ igacin uami. Hameŋ sadaŋ Asɨ agaŋ ninaŋ Iagɨveŋ agadɨ igui uami. Nusaŋ igahɨlavɨla ninaŋ Iagɨveŋ agadɨ ibi lamavɨla abami. Efɨlaim uami. ");
INSERT INTO ena_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","54","Hualɨ hulihuli vivi navɨdaci hualɨ human limu fɨhala human limu ahica cɨjɨŋ umi. Uci ci lɨci cɨhu Josepɨ agaŋ humɨgaŋ ibɨlibɨliŋ hekɨlɨ iahaiaha hɨnidaci hualɨ human limu fɨhala human limu ahica cɨjɨŋ ubali agasaŋ abami agaŋ heŋ ala hɨdɨlɨ maha iahami. Humɨgaŋ ibɨlibɨliŋ hekɨlɨ agaŋ fɨli tɨbɨ mu hɨvɨ mu hɨvɨ iahami. Iahɨci ala Isipɨ fɨli tɨbɨ heŋ sɨmɨŋ hanɨbuŋ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Humɨgaŋ ibɨlibɨliŋ agaŋ iaha hekɨlɨ lɨci Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ iamɨgali agɨlaŋ avi humɨgaŋ saŋ hɨmavɨmi. Lavɨla hulaŋ iamɨgali agɨlaŋ alusaŋ sɨmɨŋ igubali aba manɨgali agadɨ abavɨmi. Lɨhavɨci nulɨdɨ abami. Namɨlaŋ uavɨla Josepɨ dɨ abɨlaŋ nɨbu nukeŋ naludɨ abɨbali hameŋ laci ala lɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Lɨci humɨgaŋ ibɨlibɨliŋ Isipɨ fɨli tɨbɨ amɨŋ iahɨci Josepɨ agaŋ sɨmɨŋ ulaŋ agɨladɨ lavɨlɨci Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ iamɨgali agɨlaŋ veve sɨmɨŋ lavavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Humɨgaŋ ibɨlibɨliŋ agaŋ fɨli tɨbɨ sɨkasɨkan agɨladɨ hɨvɨ iahami. Iahɨci hulaŋ iamɨgali fɨli tɨbɨ mu hɨsɨŋ mu hɨsɨŋ agɨlaŋ avi Josepɨ dɨ pɨŋ veve sɨmɨŋ lavavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jekopɨ agaŋ ciaŋ hɨjɨ nameŋ agadɨ igahɨlami. Halɨha cahu uitɨ hɨlɨcɨ Isipɨ fɨli tɨbɨ hɨniavadi aba abavɨdaci igahɨlami. Lavɨla ninadinu dɨ abami. Namɨlaŋ akɨ saŋ havɨ havɨ mɨgahɨnidalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Isipɨ fɨli tɨbɨ hɨsɨŋ halɨha cahu uitɨ daŋ aba abavɨdaci igahɨlacin uami. Namɨlaŋ uavɨla alusaŋ halɨha cahu uitɨ limu hɨhɨle lavɨhalaŋ uami. Lava vavelaŋ alaŋ huaci nana hɨnibalu uami. Alaŋ humɨgaŋ saŋ hɨmavɨla haba hɨmɨmagalu uami. ");
INSERT INTO ena_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Lɨci Josepɨ isagalinu human limu limu fɨhala agɨlaŋ halɨha cahu uitɨ hɨlɨcɨ lavɨbalu aba Kenan fɨli tɨbɨ valavɨla Isipɨ fɨli tɨbɨ saŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Agadɨ ala Jekopɨ agaŋ Josepɨ imanu Bejamin dɨ abamɨgɨlɨci nɨbɨlaŋ hula ma umi. Nɨbɨlaŋ hula uavɨla hɨmɨmɨdɨ aba nudɨ abamɨgɨlami. ");
INSERT INTO ena_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kenan fɨli tɨbɨ avi humɨgaŋ ibɨlibɨliŋ hekɨlɨ iahami. Iahɨci hulaŋ limu hɨhɨle agɨlaŋ halɨha cahu uitɨ hɨlɨcɨ lavɨbalu aba Isipɨ fɨli tɨbɨ uavɨdaci Jekopɨ ninadinu agɨlaŋ avi nɨbɨlaŋ hula uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Josepɨ nɨbu manɨgali hɨnihɨni Isipɨ fɨli tɨbɨ migɨlɨdaci hulaŋ iamɨgali fɨli tɨbɨ mu hɨsɨŋ mu hɨsɨŋ agɨlaŋ nudɨ pɨŋ veve halɨha cahu uitɨ lavavɨmi. Lɨhavɨdaci Josepɨ isagalinu agɨlaŋ vevɨla nudɨ pɨŋ iahavɨla nudɨ ibi mɨŋaiahɨbalu aba fɨli hɨvɨ sɨkasɨkan mɨgavɨla ipalavɨci mɨguavɨci ani valɨ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Lɨhavɨci Josepɨ agaŋ isagalinu dɨ igavɨla hɨji hɨvɨ abami. Na iadɨ isagali ala uami. Agadɨ ala isagalinu dɨ ma iga iga me nulɨdɨ ciaŋ vɨdɨvɨdɨŋ abami. Namɨlaŋ abeŋ hɨnia velaŋ uami. Lɨci nudɨ abavɨmi. Alaŋ Kenan fɨli tɨbɨ hɨnia sɨmɨŋ lavɨbalu aba velu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Josepɨ agaŋ nudɨ isagalinu vehavɨmi agadɨ igami. Agadɨ ala hɨbɨŋ nudɨ ma igɨmaŋ lavɨla abavɨmi. Ha Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ mu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Lɨhavɨci Josepɨ agaŋ vaka anisɨhu igɨdaci isagalinu agɨlaŋ nusaŋ mɨgalɨfɨlɨbavɨmi agasaŋ igahɨlavɨla nulɨdɨ abami. Namɨlaŋ hɨbɨ igalamalama hɨsɨŋ hulaŋ uami. Aludɨ fɨli tɨbɨ nagadɨ sɨbɨlɨ lamalama saŋ hɨbɨ igalamɨbalu aba velaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Lɨci nudɨ abavɨmi. Hulaŋ hekɨlɨ uavɨmi. Ha hɨma uavɨmi. Alaŋ nadɨ sibɨla hɨsɨŋ uavɨmi. Alaŋ sɨmɨŋ lavɨbalu aba velu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Alaŋ iavaŋ pabiŋ laci agɨlaŋ velu uavɨmi. Alaŋ hɨbɨ igalamalama hɨsɨŋ hulaŋ hɨma uavɨmi. Alaŋ ciaŋ amɨŋ aba aba hɨsɨŋ hulaŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Lɨhavɨci Josepɨ cɨhu nulɨdɨ abami. Namɨlaŋ aludɨ fɨli tɨbɨ nagadɨ sɨbɨlɨ lamalama saŋ hɨbɨ igalamɨbalu aba velaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Lɨci abavɨmi. Alaŋ nadɨ sibɨla hɨsɨŋ uavɨmi. Isaima alaŋ human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ uavɨmi. Aludɨ iavaŋ pabiŋ laci uavɨmi. Nɨbu Kenan fɨli tɨbɨ hɨnilalɨ uavɨmi. Aludɨ ima sijaŋ agaŋ aludɨ iavaŋ hula hɨnidaci vala vehɨlu uavɨmi. Aludɨ ima mu avi ci hɨmami uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Lɨhavɨci Josepɨ agaŋ cɨhu ala abami. Viaŋ naludɨ ci abin uami. Namɨlaŋ hɨbɨ igalamalama hɨsɨŋ hulaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ ibi hɨvɨ viaŋ naludɨ abin uami. Naludɨ imanalu sijaŋ agaŋ ma ve iahɨci ha namɨlaŋ Isipɨ fɨli tɨbɨ ma valavɨla ubalaŋ uami. Naludɨ imanalu sijaŋ agaŋ ve iahɨci igavɨla ha abɨben uami. Amɨŋ abavalɨ aba abɨben uami. La abɨlɨŋ naludɨ haiabɨla cɨhu ubalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Naludɨ hulaŋ mu dɨ abɨlaŋ uavɨla imanalu sijaŋ agadɨ vavem uami. Limu hɨhɨle namɨlaŋ lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ hɨnidalaŋ naludɨ ciaŋ agaŋ amɨŋ ua analɨ akua agadɨ hɨdɨlɨ igɨbalu uami. La naludɨ ciaŋ hɨdɨlɨ agadɨ igɨlɨŋ analɨ lɨci ha Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ ibi hɨvɨ viaŋ naludɨ amɨŋ abɨben uami. Namɨlaŋ hɨbɨ igalamalama hɨsɨŋ hulaŋ aba abɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Josepɨ ciaŋ abɨci ci lɨci nulɨdɨ lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ lamavɨci hɨniavɨdaci uaiaŋ pabiŋ umi. ");
INSERT INTO ena_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Uaiaŋ pabiŋ uci Josepɨ agaŋ cɨhu abɨci vehavɨci nulɨdɨ abami. Viaŋ Asɨ saŋ lɨdavɨla nudɨ lɨhu hɨvɨ hɨnilan uami. Hameŋ sadaŋ iadɨ ciaŋ lubiahɨlavɨla ha huaci hɨnibalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Namɨlaŋ ciaŋ amɨŋ aba aba hɨsɨŋ hulaŋ lɨci ha naludɨ hulaŋ mu lɨmɨn sɨbɨlɨ ulaŋ hɨniahalaŋ heŋ valɨlaŋ hɨnim uami. Hɨnidaci limu hɨhɨle namɨlaŋ halɨha cahu uitɨ lavahalaŋ agɨladɨ naludɨ ninanadinalu abinadinalu ani ani agɨlaŋ humɨgaŋ saŋ hɨmahɨma hɨniavadi agɨlasaŋ via uhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Lavɨla naludɨ imanalu sijaŋ agadɨ iadɨ pɨŋ vavehalaŋ uami. Hameŋ lɨlaŋ abɨben uami. Namɨlaŋ ciaŋ amɨŋ laci abɨlalaŋ aba abɨben uami. Namɨlaŋ hameŋ lavɨla ma hɨmɨbalaŋ uami. Lɨci Josepɨ dɨ ciaŋ agadɨ igahɨlavɨla abavɨmi. Ha huaci uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","La nɨbɨlaŋ nukeŋ nukeŋ abavɨmi. Amɨŋ sɨbaŋ alaŋ aludɨ ima dɨ sɨbɨlɨ lamamɨlu sadaŋ alaŋ hugɨ daŋ hɨnilu uavɨmi. Nɨbu ilɨha ilɨha agala agala nudɨ vivi saŋ aludɨ abɨdaci ala alaŋ nudɨ ciaŋ igahɨlavɨla ma vimɨlu uavɨmi. Alaŋ nudɨ sɨbɨlɨ lamamɨlu agasaŋ iabi alaŋ vɨhɨlɨ igadalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Lɨhavɨci Luben agaŋ abami. Viaŋ naludɨ abamin uami. Hulaŋ cɨki agadɨ sɨbɨlɨ lamɨmɨlaŋ aba abamin uami. Abɨlɨŋ ala namɨlaŋ iadɨ ciaŋ agadɨ ma igahɨlamalaŋ uami. Nɨbu hɨmami agasaŋ alaŋ avi vɨhɨlɨ nagadɨ igadalu uami. ");
INSERT INTO ena_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Isagalinu agɨlaŋ Josepɨ agaŋ aludɨ ciaŋ ma igahɨladi aba Ibɨlu ciaŋ hɨvɨ abavɨmi. Josepɨ agaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ ciaŋ sɨbaŋ hɨvɨ nudɨ isagalinu hula abɨdaci hulaŋ mu Isipɨ fɨli tɨbɨ hɨsɨŋ agaŋ nulɨdɨ ciaŋ agɨladɨ limu cimɨla cimɨla abami. ");
INSERT INTO ena_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Josepɨ isagalinu agɨlaŋ Ibɨlu ciaŋ hɨvɨ abavɨdaci nulɨdɨ ciaŋ agadɨ igahɨlavɨla nulɨdɨ vala uavɨla ilɨhami. Ilɨhɨci ci lɨci cɨhu vevɨla nulɨdɨ cɨhu cɨhu abami. La nudɨ sibɨla hɨsɨŋ hulaŋ agɨladɨ abɨci Simeon dɨ mɨŋalɨvavɨla mɨŋamagɨla via nudɨ hɨcɨ human lɨmɨn vɨdɨvɨdɨŋ hɨvɨ hahavɨdaci isagalinu agɨlaŋ igasulasula hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Lɨhavɨci Josepɨ agaŋ nudɨ sibɨla hɨsɨŋ hulaŋ agɨladɨ abɨci nudɨ ciaŋ lubiahɨlavɨla isagalinu dɨ vaŋ heŋ halɨha cahu uitɨ hɨlɨcɨ hudavɨmi. Lavɨla nulɨdɨ anɨm hɨlɨcɨ agɨladɨ avi nulɨdɨ vaŋ hɨtɨŋ hɨtɨŋ hɨvɨ hudavɨmi. La sɨmɨŋ hɨbɨ cina nana saŋ avi nulɨsaŋ iguavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Lɨhavɨci Josepɨ dɨ isagalinu agɨlaŋ nulɨdɨ halɨha cahu uitɨ vaŋ agɨladɨ vivi sabaŋ donɨki sabɨ hɨvɨ lamavɨla uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Uavɨla hɨbɨ cina ani hɨniben aba havɨlɨ ulaŋ hafiavɨmi. Lavɨla nulɨdɨ hulaŋ mu agaŋ nudɨ sabaŋ donɨki saŋ igunɨben aba sɨmɨŋ vaŋ agadɨ hivami. Hivavɨla igɨci nudɨ anɨm hɨlɨcɨ agɨlaŋ vaŋ muji halɨha cahu uitɨ sabɨ heŋ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Lɨhavɨci limu hɨhɨle agɨladɨ abami. Igɨhalaŋ uami. Halɨha cahu uitɨ laviemin agadɨ anɨm hɨlɨcɨ agɨladɨ cɨhu ala halɨha cahu uitɨ vaŋ hɨvɨ hudaviemi uami. Hameŋ abɨci ciaŋ agadɨ igahɨlavɨla i uavɨmi. Lavɨla hekɨlɨ lɨdalɨda nɨbɨlaŋ nukeŋ nukeŋ hɨbɨŋ hɨbɨŋ abitɨhatɨha abavɨmi. Asɨ agaŋ aludɨ akuaba lɨben aba li uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Hameŋ abavɨla ua Kenan fɨli tɨbɨ iahuavɨla akuaba akuaba iahavɨci igavɨmi agɨlasaŋ iaganɨlu Jekopɨ dɨ abavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Isipɨ fɨli tɨbɨ migɨlɨlalɨ agaŋ aludɨ vɨdɨvɨdɨŋ lɨbɨmɨgumɨgu abalɨ uavɨmi. Namɨlaŋ fɨli tɨbɨ nagadɨ igalamalama saŋ velaŋ aba abalɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Lɨci alaŋ nudɨ abahɨlu uavɨmi. Alaŋ ciaŋ amɨŋ aba aba hɨsɨŋ hulaŋ aba abahɨlu uavɨmi. Alaŋ hɨbɨ igalamalama hɨsɨŋ hulaŋ hɨma aba abahɨlu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Alaŋ human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ isaima alaŋ hulaŋ pabiŋ dɨ ninaŋ laci aba abahɨlu uavɨmi. Agadɨ ala aludɨ ima mu ci hɨmami aba abahɨlu uavɨmi. Ima mu sijaŋ sɨbaŋ agaŋ Kenan fɨli tɨbɨ aludɨ iavaŋ hula hɨnidi aba abahɨlu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Hameŋ abɨmɨli Isipɨ fɨli tɨbɨ migɨlɨlalɨ agaŋ cɨhu aludɨ abalɨ uavɨmi. Iadɨ ciaŋ lubiahɨlɨlaŋ ha naludɨ abɨben aba abalɨ uavɨmi. Namɨlaŋ ciaŋ amɨŋ aba aba hɨsɨŋ hulaŋ aba abɨben aba abalɨ uavɨmi. Naludɨ hulaŋ mu viaŋ hula hɨnidaci namɨlaŋ limu hɨhɨle naludɨ halɨha cahu uitɨ vaŋ viavɨla naludɨ abinadinalu ninanadinalu ani ani humɨgaŋ saŋ hɨmahɨma hɨniavadi agɨlasaŋ via uhalaŋ aba abalɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Lavɨla cɨhu naludɨ imanalu sijaŋ agadɨ iadɨ pɨŋ vavehalaŋ aba abalɨ uavɨmi. Hameŋ lɨlaŋ viaŋ abɨben aba abalɨ uavɨmi. Ha namɨlaŋ hɨbɨ igalamalama hɨsɨŋ hulaŋ hɨma aba abɨben aba abalɨ uavɨmi. Namɨlaŋ ciaŋ amɨŋ aba aba hɨsɨŋ hulaŋ aba abɨben aba abalɨ uavɨmi. La naludɨ imanalu dɨ nalusaŋ cɨhu igulɨŋ ha fɨli tɨbɨ neŋ uu veve hɨdahɨda mutɨŋ akuaba akuaba viben aba huaci hɨdɨbalaŋ aba abalɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Hameŋ abavɨci ci lɨci nulɨdɨ halɨha cahu uitɨ vaŋ hɨtɨŋ hɨtɨŋ agɨladɨ mɨŋamɨjiavɨci mɨgami. Lɨci igavɨci nulɨdɨ anɨm hɨlɨcɨ vaŋ halɨha cahu uitɨ vaŋ muji hɨniavɨmi agɨlaŋ avi mɨgavɨmi. Lɨhavɨci iaganɨlu avi anɨm hɨlɨcɨ vaŋ agɨladɨ igami. Lavɨla i uavɨla lɨdavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Lavɨla iaganɨlu Jekopɨ agaŋ abami. Namɨlaŋ ala lɨlaŋ iadɨ ninaŋ ahica agɨlaŋ viaŋ hula ma hɨniavi uami. Josepɨ ci hɨmami uami. Simeon avi alaŋ hula ma hɨni uami. La cɨhu Bejamin dɨ viavɨla iadɨ valavɨla ataŋ uben aba lɨlaŋ uami. Vɨhɨlɨ hameŋ agadɨ asi ma igadamin uami. ");
INSERT INTO ena_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Lɨci Luben agaŋ iaganu dɨ abami. Valɨnaŋ viaŋ nukeŋ Bejamin dɨ sɨhɨvia migɨla migɨla via uavɨla cɨhu vave nadɨ pɨŋ lamɨben uami. Ma vavelɨŋ ha iadɨ ninaŋ ahica agɨladɨ huaci hɨbɨŋ ifɨhɨmɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Lɨci Jekopɨ abami. Iadɨ ninaŋ nagaŋ namɨlaŋ hula ma ubali uami. Nudɨ isanu humɨgaŋ pam Josepɨ hɨmɨci nɨbu hɨtɨŋ cɨki hɨnilalɨ uami. Via ulaŋ hɨbɨ cina nudɨ hɨvɨ vɨhɨlɨ iahɨmɨdɨ uami. Nudɨ hɨvɨ vɨhɨlɨ iahɨci ha viaŋ ci hadi hadi sɨbaŋ lin sadaŋ viaŋ ilɨha ilɨha hɨniavɨla hɨmɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Humɨgaŋ ibɨlibɨliŋ hekɨlɨ agaŋ Kenan fɨli tɨbɨ iahaiaha hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Lɨdaci Jekopɨ nudɨ ninadinu nabehalinu ajihalinu ani ani hula sɨmɨŋ Isipɨ fɨli tɨbɨ hɨsɨŋ vihavɨmi agɨladɨ na fɨhalavɨmi. Lavɨla Jekopɨ agaŋ nudɨ ninadinu dɨ abami. Namɨlaŋ Isipɨ fɨli tɨbɨ cɨhu uavɨla sɨmɨŋ cɨki alusaŋ lavɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Lɨci Juda cɨhu iaganu dɨ abami. Alaŋ nadɨ ci abahɨlu uami. Isipɨ fɨli tɨbɨ migɨlɨlalɨ agaŋ aludɨ vɨdɨvɨdɨŋ abalɨ uami. Namɨlaŋ naludɨ imanalu dɨ ma vavelaŋ ha viaŋ naludɨ cɨhu cɨhu ma igɨben aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Nama aludɨ ima dɨ alaŋ hula uu saŋ abɨnaŋ ha huaci alaŋ uavɨla nasaŋ sɨmɨŋ lavɨbalu uami. ");
INSERT INTO ena_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Nama aludɨ ima dɨ alaŋ hula uu saŋ ma alialaŋ unaŋ ha alaŋ ma ubalu uami. Isipɨ fɨli tɨbɨ migɨlɨlalɨ agaŋ aludɨ ci abalɨ uami. Namɨlaŋ naludɨ imanalu dɨ ma vavelaŋ ha viaŋ naludɨ cɨhu cɨhu ma igɨben aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Jekopɨ dɨ ibi mu Asɨ lamami ha Isɨlaelɨ. Lɨci Isɨlaelɨ agaŋ abami. Akɨ saŋ hulaŋ Isipɨ fɨli tɨbɨ migɨlɨlalɨ agadɨ abahalaŋ uami. Aludɨ ima sijaŋ ha hɨnidi aba abahalaŋ uami. Ha iasaŋ vɨhɨlɨ hekɨlɨ iguahalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Lɨci nudɨ abavɨmi. Hulaŋ agaŋ aludɨ cɨhu cɨhu abitɨhalɨ uavɨmi. Aludɨ hɨdɨlɨ pam agɨlasaŋ abitɨhalɨ uavɨmi. Naludɨ iaganalu ci hɨmami ua hanɨbuŋ hɨnidi aba abitɨhalɨ uavɨmi. Naludɨ imanalu mu hɨnidi ua hɨma aba abitɨhalɨ uavɨmi. Hameŋ abitɨhɨci alaŋ aludɨ ima dɨ viavɨla uu saŋ ma akua abɨbali aba nudɨ abahɨlu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Lavɨla Juda agaŋ iaganu Isɨlaelɨ dɨ abami. Bejamin dɨ valɨnaŋ iadɨ pɨŋ veci alaŋ ahuata ubalu uami. Hameŋ lɨnaŋ alaŋ aludɨ iamɨgali ninanadi agɨlaŋ hula humɨgaŋ saŋ hɨmavɨla sɨkasɨkan ma hɨmɨbalu uami. Nama avi humɨgaŋ saŋ hɨmavɨla sɨkasɨkan ma hɨmɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Viaŋ nukeŋ nudɨ migɨlɨben uami. Viaŋ nudɨ nadɨ pɨŋ cɨhu ma vavevɨla ha viaŋ nama hula hugɨ daŋ hɨniben uami. Hugɨ agaŋ viaŋ hula laci sɨkan hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Nama aludɨ ma abamɨgɨlahanaŋ padaŋ ha ahica tɨbɨ uavɨla cɨhu ci vevɨlu uami. ");
INSERT INTO ena_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Lɨci Isɨlaelɨ nulɨdɨ abami. Igahɨlɨlaŋ hɨma lɨci nameŋ lɨhalaŋ uami. Akuaba akuaba sɨmɨŋ huaci huaci fɨli tɨbɨ neŋ hɨsɨŋ agɨladɨ viavɨla naludɨ vaŋ hɨvɨ hudɨhalaŋ uami. La via uavɨla Isipɨ fɨli tɨbɨ migɨlɨlalɨ agasaŋ akuaba akuaba agɨladɨ iguhalaŋ uami. Akuaba akuaba huaci huaci nameŋ agɨladɨ vihalaŋ uami. Akuaba akuaba ikupi hɨsi huaci huaci daŋ agɨladɨdaŋ vɨhɨ magɨ me agɨladɨdaŋ vihalaŋ uami. Kɨlɨ mɨlɨm hɨsi huaci huaci daŋ agɨladɨ vihalaŋ uami. Cihu savu me mu nudɨ ibi mea aba abavɨlalɨ agɨladɨ vihalaŋ uami. Kuaniŋ pisɨtasio amɨŋ agɨladɨdaŋ kuaniŋ amon amɨŋ agɨladɨdaŋ avi via uhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Vaka namɨlaŋ sɨmɨŋ lavalava saŋ anɨm hɨlɨcɨ via uahalaŋ uami. Lɨlaŋ nɨbɨlaŋ uava iahuavɨla akua naludɨ anɨm hɨlɨcɨ agɨladɨ vivi naludɨ sɨmɨŋ vaŋ hɨvɨ cɨhu hudavalɨ uami. Anɨm hɨlɨcɨ hameŋ lɨhavalɨ agɨladɨ vihalaŋ uami. La anɨm hɨlɨcɨ hɨhɨle agɨladɨ avi viavɨla pam lamavɨla via uhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Alialaŋ imanalu dɨ via hulaŋ agadɨ pɨŋ cɨhu uhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Udalaŋ viaŋ Asɨ dɨ nameŋ abɨben uami. Asɨ vɨdɨvɨdɨŋ hekɨlɨ daŋ nama hulaŋ agasaŋ hɨji huaci igunaŋ Simeon dɨdaŋ Bejamin dɨdaŋ cɨhu vavehavɨm aba abɨben uami. Hameŋ abɨlɨŋ Asɨ agaŋ nadɨ ninaŋ agɨlaŋ sɨkasɨkan vana hɨmavɨm aba abɨci ha vana hɨmavɨm uami. ");
INSERT INTO ena_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Lɨci isaima agɨlaŋ akuaba akuaba huaci huaci agɨladɨdaŋ anɨm hɨlɨcɨ agɨladɨdaŋ pam lamavɨla via uavɨmi. Imanɨlu Bejamin dɨ avi viavɨla Isipɨ fɨli tɨbɨ uavɨla Josepɨ dɨ pɨŋ ua iahavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Iahavɨci Josepɨ agaŋ nudɨ isagalinu dɨdaŋ Bejamin dɨdaŋ igavɨla hulaŋ nudɨ ulaŋ migɨladami agadɨ abami. Nama hulaŋ nagɨladɨ iadɨ ulaŋ heŋ via uha uami. La sabaŋ bulɨmakau mu ifɨhɨmavɨla hɨlɨha uami. Hɨlɨnaŋ uaiaŋ huva hɨvɨ hulaŋ nagɨlaŋ hula sɨmɨŋ nɨbalu uami. ");
INSERT INTO ena_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Hameŋ abɨci hulaŋ Josepɨ dɨ ulaŋ migɨladami agaŋ nudɨ ciaŋ lubiahɨlavɨla nulɨdɨ via Josepɨ dɨ ulaŋ umi. ");
INSERT INTO ena_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Via uci ma ivomaŋ lɨdɨŋ Josepɨ isaimahalinu agɨlaŋ lɨdavɨla abavɨmi. Vaka vemɨli aludɨ vaŋ hɨtɨŋ hɨtɨŋ hɨvɨ anɨm hɨlɨcɨ hudavɨci via uahɨlu agasaŋ akua igahɨlavɨla aludɨ Isipɨ fɨli tɨbɨ migɨlɨlalɨ agadɨ ulaŋ hɨvɨ via uadi uavɨmi. Via ua aludɨ mɨŋalɨvavɨla nulɨdɨ sibɨla hɨsɨŋ hulaŋ hɨnihɨni saŋ lamavɨbali uavɨmi. Lavɨla aludɨ sabaŋ donɨki avi vihavɨbali uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Hulaŋ Josepɨ dɨ ulaŋ migɨladami agadɨ igavɨci ulaŋ hɨbɨ ivu ivu mikɨ heŋ lagulama hɨnimi. Lɨci nudɨ abavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Hulaŋ hekɨlɨ uavɨmi. Vaka alaŋ neŋ vevɨla sɨmɨŋ lavahɨlu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Hadɨhu alaŋ naludɨ vala uavɨla hɨbɨ cina ani hɨsɨvahɨlu uavɨmi. Lavɨla aludɨ halɨha cahu uitɨ vaŋ hɨtɨŋ hɨtɨŋ agɨladɨ hivavɨla igɨmɨli anɨm hɨlɨcɨ sɨmɨŋ lavahɨlu agɨlaŋ vaŋ muji heŋ hɨniavalɨ uavɨmi. Hameŋ sadaŋ malɨciŋ anɨm hɨlɨcɨ agɨladɨ cɨhu vavelu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Anɨm hɨlɨcɨ limu hɨhɨle sɨmɨŋ lavalava saŋ avi vavelu uavɨmi. Hulaŋ aniaba agaŋ aludɨ vaŋ hɨtɨŋ hɨtɨŋ hɨvɨ anɨm hɨlɨcɨ hudalɨ agadɨ alaŋ ma igahɨlu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Hulaŋ Josepɨ dɨ ulaŋ migɨladami agaŋ ciaŋ agadɨ igahɨlavɨla nulɨdɨ abami. Namɨlaŋ nusaŋ hɨji cuvɨlɨŋ cuvɨlɨŋ igahɨlavɨla lɨdɨmɨlaŋ uami. Ha iaganalu dɨ Asɨ agaŋ akua anɨm hɨlɨcɨ agɨladɨ naludɨ vaŋ hɨvɨ cɨhu hudalɨ uami. Nɨbu avi naludɨ Asɨ uami. Anɨm hɨlɨcɨ sɨmɨŋ lavahalaŋ agɨladɨ ci vicin uami. Lavɨla ua Simeon dɨ vave nulɨdɨ pɨŋ lamami. ");
INSERT INTO ena_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","La nulɨdɨ via uleŋ muji ivouavɨmi. Ivouavɨci hɨcɨ husavɨbali aba nulɨsaŋ avɨli igumi. Lavɨla nulɨdɨ sabaŋ donɨki agɨlasaŋ avi sɨmɨŋ iguci navɨmi. ");
INSERT INTO ena_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Josepɨ dɨ isaimahalinu agɨlaŋ Josepɨ uaiaŋ huva hɨvɨ vevɨla nɨbɨlaŋ hula sɨmɨŋ nana saŋ abami agadɨ igahɨlavɨla nusaŋ akuaba akuaba huaci huaci agɨladɨ iguben aba hihɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","La hɨniavɨdaci Josepɨ agaŋ nudɨ nukeŋ ulaŋ hɨvɨ veci akuaba akuaba huaci huaci hihɨlavɨmi agɨladɨ Josepɨ saŋ vave iguavɨmi. Lavɨla Josepɨ dɨ ibi mɨŋaiahɨbalu aba fɨli hɨvɨ mɨgalɨfɨlɨbavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Lɨhavɨci Josepɨ agaŋ nulɨdɨ abami. Namɨlaŋ huaci hɨnidalaŋ uami. Naludɨ iaganalu hadi hadi la hɨni aba abahalaŋ ha huaci hɨnidi ua akɨ me hɨnidi uami. ");
INSERT INTO ena_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Lɨci abavɨmi. Aludɨ iavaŋ huaci ala hɨnidi uavɨmi. Nɨbu nadɨ sibɨla hɨsɨŋ hulaŋ uavɨmi. Lavɨla hali lɨbuhɨlavɨla cɨhu nudɨ ibi mɨŋaiahɨbalu aba mɨgalɨfɨlɨbavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Lɨhavɨci Josepɨ agaŋ imanu humɨgaŋ pam Bejamin dɨ igavɨla abami. Hulaŋ nagaŋ nɨbu naludɨ imanalu uami. Nusaŋ ala iadɨ abahalaŋ uami. La Bejamin dɨ abami. Ci igɨnaŋ uami. Asɨ nadɨ huaci lamɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Lavɨla imanu saŋ mavɨn lɨci ilɨhɨben aba lɨmi. Lavɨla nulɨdɨ lɨhalɨha valavɨla uleŋ muji mu hɨvɨ ivouavɨla ilɨhami. ");
INSERT INTO ena_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ilɨhɨci ci lɨci avɨli hɨvɨ mugaŋ lamɨgaŋ husami. La vɨdɨvɨdɨŋ viavɨla cɨhu ivavevɨla nudɨ sibɨla hɨsɨŋ hulaŋ agɨladɨ abami. Sɨmɨŋ lulavɨla vadɨm hɨvɨ lamɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Lɨci lulavɨla Josepɨ saŋ vadɨm mu hɨvɨ lamavɨmi. Nudɨ isaimahalinu saŋ vadɨm mu hɨvɨ lamavɨmi. Isipɨ fɨli tɨbɨ hɨsɨŋ limu hɨhɨle Josepɨ hula hɨniavɨhadami agɨlasaŋ vadɨm mu hɨvɨ lamavɨmi. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ Ibɨlu ciaŋ hɨsɨŋ agɨlaŋ hula pam ma navɨhadami sadaŋ nulɨsaŋ vadɨm mu hɨvɨ lamavɨci navɨmi. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ Ibɨlu ciaŋ hɨsɨŋ agɨlaŋ hula pam lama sɨmɨŋ nana agadɨ igavɨdaci sɨbɨlɨ sɨbaŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Josepɨ agaŋ nudɨ sibɨla hɨsɨŋ hulaŋ agɨlasaŋ hɨji iguci isaimahalinu mɨgahɨnia nana saŋ fipɨ hɨtɨŋ hɨtɨŋ lamavɨmi. Lɨhavɨci isanɨlu Cimegeŋ Luben agaŋ hali mɨgahɨnimi. Nɨbu mɨgahɨnici uci imanu Iagɨveŋ agaŋ mɨgahɨnimi. Lɨci hameŋ laci mɨgahɨnihɨni uu imanɨlu Bejamin agaŋ sijaŋ sɨbaŋ mɨgahɨnimi. Lɨci isaimahalinu agɨlaŋ nɨbɨlaŋ laci mɨgahɨniavɨmi agadɨ igavɨla i uavɨmi. Nɨbu aludɨ akɨ la igavɨla Cimegeŋ Iagɨveŋ Alɨkegeŋ hameŋ lamalama via ua Bejamin dɨ sijaŋ sɨbaŋ lami uavɨmi. Lavɨla nɨbɨlaŋ nukeŋ nukeŋ lamɨgaŋ hɨbɨŋ hɨbɨŋ igavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Lɨhavɨci Josepɨ dɨ sibɨla hɨsɨŋ hulaŋ agɨlaŋ Josepɨ isaimahalinu saŋ sɨmɨŋ limu hɨhɨle Josepɨ dɨ vadɨm hɨvɨ hɨnimi agadɨ via nulɨsaŋ hɨlihɨli hameŋ laci lamavɨmi. Agadɨ ala Bejamin saŋ sɨmɨŋ hekɨlɨ lamavɨmi. Bejamin saŋ lamavɨmi ha hulaŋ human limu fɨhala agɨlaŋ nana saŋ me lamavɨmi. Lɨhavɨci Josepɨ ani ani sɨmɨŋ nana lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ nana ahuata hɨjɨŋalaŋala hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Navɨci ci lɨci Josepɨ agaŋ hulaŋ nudɨ ulaŋ migɨladami agadɨ abami. Halɨha cahu uitɨ nulɨdɨ vaŋ hɨtɨŋ hɨtɨŋ hɨvɨ hudɨnaŋ vɨhɨlɨ vameba vihavɨlalɨ hameŋ ala vihavɨm uami. La nulɨdɨ anɨm hɨlɨcɨ hɨtɨŋ hɨtɨŋ agɨladɨ nulɨdɨ vaŋ muji heŋ hudɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","La iadɨ hɨcɨhaŋ lɨba silɨva hɨvɨ vihavɨmi agadɨ nulɨdɨ imanɨlu dɨ vaŋ hɨvɨ hudɨha uami. Nudɨ anɨm hɨlɨcɨ halɨha cahu uitɨ lavɨben aba vavelɨ agadɨ avi hudɨha uami. Lɨci sibɨla hɨsɨŋ hulaŋ agaŋ Josepɨ abami hameŋ laci ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Lɨci hɨniavɨci mɨŋalahɨci hulaŋ Josepɨ dɨ ulaŋ migɨladami agaŋ Josepɨ isagalinu dɨdaŋ imanɨlu dɨdaŋ abɨci nulɨdɨ sabaŋ donɨki via cimɨdaŋ sɨbaŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","5","Haiabɨla agadɨ vala uavɨdaci ma hutesɨ lɨmaŋ lɨdaci Josepɨ agaŋ hulaŋ nudɨ ulaŋ migɨladami agadɨ abami. Nama iaha hulaŋ agɨladɨ sɨvɨ uha uami. Uavɨla nulɨdɨ igavɨla nameŋ abɨha uami. Alaŋ naludɨ huaci lamɨmɨli namɨlaŋ cɨhu aludɨ lusɨŋ sɨbɨlɨ viavɨla hɨcɨhaŋ vimalamɨlaŋ aba abɨha uami. Hɨcɨhaŋ ha iadɨ manɨgali avɨli nɨlalɨ agaŋ aba abɨha uami. Akuaba akuaba sɨvɨla hɨniavɨdaci hɨcɨhaŋ agadɨ hɨvɨ ala igɨlalɨ aba abɨha uami. Namɨlaŋ lusɨŋ sɨbɨlɨ sɨbaŋ vimalamɨlaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Lɨci hulaŋ Josepɨ dɨ ulaŋ migɨladami agaŋ uavɨla nulɨdɨ pɨŋ iahavɨla Josepɨ abami hameŋ laci ala abami. ");
INSERT INTO ena_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Lɨci nudɨ abavɨmi. Hulaŋ hekɨlɨ uavɨmi. Akɨ saŋ aludɨ ciaŋ sɨbɨlɨ hameŋ agadɨ abɨnaŋ uavɨmi. Alaŋ lusɨŋ sɨbɨlɨ hameŋ agadɨ ma sɨbaŋ vimalamɨlu uavɨmi. Alaŋ nadɨ sibɨla hɨsɨŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nama igahanaŋ uavɨmi. Mu tɨbɨ alaŋ vevɨla halɨha cahu uitɨ lavavɨla Kenan fɨli tɨbɨ via ua hɨniavɨla igɨmɨli aludɨ anɨm hɨlɨcɨ agɨlaŋ vaŋ muji hɨniavalɨ uavɨmi. Lɨhavɨci alaŋ cɨhu anɨm hɨlɨcɨ agɨladɨ vavevɨla abalamɨmɨli nama igahanaŋ uavɨmi. Alaŋ akɨ saŋ nadɨ manɨgali agadɨ lɨba silɨva lɨba golɨ agɨladɨ sɨgɨlɨ vibalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Hulaŋ hekɨlɨ uavɨmi. Nama igɨnaŋ hɨcɨhaŋ agaŋ aniaba hulaŋ hula hɨnici ha nudɨ ifɨhɨmɨha uavɨmi. Lɨnaŋ alaŋ ahuata nadɨ sibɨla hɨsɨŋ hulaŋ hɨnibalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Lɨhavɨci Josepɨ dɨ ulaŋ migɨladami agaŋ abami. Ha huaci uami. Viaŋ igɨlɨŋ hɨcɨhaŋ agaŋ hulaŋ mu dɨ hɨvɨ hɨnici ha nɨbu laci iadɨ sibɨla hɨsɨŋ hulaŋ hɨnibali uami. Namɨlaŋ limu hɨhɨle huaci ubalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Hameŋ abɨci nulɨdɨ vaŋ hɨtɨŋ hɨtɨŋ agɨladɨ fɨli mɨŋamɨga lamavɨhevɨla hivavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Lɨhavɨci Josepɨ dɨ ulaŋ migɨladami agaŋ nulɨdɨ vaŋ muji heŋ sɨhɨvia sɨbaŋ suhɨlami. Isanɨlu Cimegeŋ dɨ vaŋ heŋ hɨdɨlɨ maha suhɨla suhɨla via ua imanɨlu dɨ vaŋ sijaŋ suhɨlami. La hɨcɨhaŋ agadɨ igɨci imanɨlu Bejamin dɨ vaŋ hɨvɨ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Lɨci hɨcɨhaŋ agadɨ igavɨla mavɨn hekɨlɨ lamavɨla nulɨdɨ hadi hɨlahɨla agɨladɨ mɨŋacɨkɨlavɨmi. Lavɨla nulɨdɨ vaŋ agɨladɨ sabaŋ donɨki sabɨ hɨvɨ lamavɨla cɨhu limu cimɨlavɨla Josepɨ dɨ haiabɨla vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Vevɨla Juda agaŋ nudɨ isagalinu imahalinu hula Josepɨ dɨ ulaŋ ivoua igavɨci nɨbu heŋ hɨnimi. Lɨci mavɨn ciaŋ ciaŋ iguben aba Josepɨ dɨ hɨcɨ pɨŋ heŋ fɨli hɨvɨ mɨgalɨfɨlɨbavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Lɨhavɨci Josepɨ nulɨdɨ abami. Namɨlaŋ akɨ saŋ hameŋ lɨlaŋ uami. Viaŋ akuaba akuaba sɨvɨla hɨniavɨlalɨ agɨladɨ hɨji hɨvɨ avi igɨlan agadɨ namɨlaŋ ma igɨlalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Hameŋ abɨci Juda agaŋ abami. Hulaŋ hekɨlɨ uami. Alaŋ nadɨ akɨ ubalu uami. Alaŋ akɨ me lavɨla ciaŋ hivɨmɨli aludɨ abɨbanaŋ uami. Namɨlaŋ hugɨ apalɨ aba abɨbanaŋ uami. Alaŋ vaka lusɨŋ sɨbɨlɨ viavɨla hugɨ daŋ hɨnilalu agadɨ Asɨ agaŋ ci haiabɨla lami uami. Hulaŋ hekɨlɨ uami. Hulaŋ nadɨ hɨcɨhaŋ daŋ agaŋ nɨbu laci nadɨ sibɨla hɨsɨŋ ma hɨnibali uami. Alaŋ ahuata avi nadɨ sibɨla hɨsɨŋ hulaŋ hɨnibalu uami. ");
INSERT INTO ena_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Hameŋ abɨci Josepɨ abami. Ha hɨma sɨbaŋ uami. Viaŋ naludɨ hameŋ ma lɨben uami. Hulaŋ iadɨ hɨcɨhaŋ sɨgɨlɨ vimalami agaŋ nɨbu pam iadɨ sibɨla hɨsɨŋ hulaŋ hɨnibali uami. Namɨlaŋ limu hɨhɨle humɨgaŋ simɨ hɨniavɨla naludɨ iaganalu hɨnidi heŋ cɨhu uhalaŋ uami. Viaŋ namɨlaŋ hula ciaŋ apalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Lɨci Juda agaŋ Josepɨ dɨ mikɨ pɨŋ uavɨla nudɨ mavɨn ciaŋ ciaŋ abami. Hulaŋ hekɨlɨ uami. Iadɨ ciaŋ cɨki huaci igahɨlɨbanaŋ uami. Nama Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali me sɨbaŋ hɨninaŋ uami. Agadɨ ala nama iasaŋ igɨvɨ hɨnimɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Vaka nama aludɨ nameŋ abahanaŋ uami. Naludɨ iaganalu hanɨbuŋ hɨnidi ua hɨma aba abahanaŋ uami. Naludɨ imanalu hanɨbuŋ hɨnidi ua hɨma aba abahanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Lɨnabɨla alaŋ abahɨlu uami. Aludɨ iavaŋ hadi hadi lavɨla hɨnidi aba abahɨlu uami. Aludɨ ima sijaŋ avi hanɨbuŋ hɨnidi aba abahɨlu uami. Aludɨ iavaŋ hadi hadi la hɨnidaci iamɨga ninaŋ agadɨ huhɨlami aba abahɨlu uami. Lavɨla nɨbu ninaŋ ahica daŋ hɨnimi aba abahɨlu uami. Lɨci isanu ci hɨmami aba abahɨlu uami. Hɨmɨci imanu pam hɨnidi aba abahɨlu uami. Hameŋ sadaŋ iaganu agaŋ ninaŋ sijaŋ agasaŋ mavɨn hekɨlɨ hɨnilalɨ aba abahɨlu uami. ");
INSERT INTO ena_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Lɨmɨli nama aludɨ nameŋ abahanaŋ uami. Naludɨ imanalu dɨ vavelaŋ viaŋ nudɨ igɨben aba abahanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Lɨnaŋ alaŋ nameŋ abahɨlu uami. Ninaŋ agaŋ iaganu dɨ ma valavɨla vebali aba abahɨlu uami. Iaganu dɨ vala veci ha iaganu ilɨhavɨla hɨmɨbali aba abahɨlu uami. ");
INSERT INTO ena_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Lɨmɨli nama nameŋ abahanaŋ uami. Namɨlaŋ naludɨ imanalu dɨ ma vavelaŋ ha viaŋ naludɨ cɨhu cɨhu ma igɨben aba abahanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Hulaŋ hekɨlɨ uami. Alaŋ nadɨ vala cɨhu uavɨla nadɨ ciaŋ agadɨ aludɨ iavaŋ dɨ abahɨlu uami. Nɨbu nadɨ sibɨla hɨsɨŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Lɨmɨli aludɨ nameŋ abalɨ uami. Namɨlaŋ cɨhu uavɨla alusaŋ sɨmɨŋ cɨki lavɨhalaŋ aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Lɨci abahɨlu uami. Alaŋ cɨhu ma ubalu aba abahɨlu uami. Aludɨ ima sijaŋ agaŋ alaŋ hula ma uci ha alaŋ hulaŋ Isipɨ fɨli tɨbɨ migɨlɨlalɨ agadɨ ma igɨbalu aba abahɨlu uami. Aludɨ ima sijaŋ agaŋ alaŋ hula uci ha alaŋ huaci ubalu aba abahɨlu uami. ");
INSERT INTO ena_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Lɨmɨli aludɨ iavaŋ agaŋ nameŋ abalɨ uami. Namɨlaŋ igɨlalaŋ aba abalɨ uami. Iadɨ iamɨgali Leselɨ agaŋ ninaŋ ahica sɨbaŋ huhɨlami aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Iadɨ ninaŋ mu ci sɨvɨlami aba abalɨ uami. Akuaba sudɨ iŋam akua iava agɨcɨkɨlacɨkɨla nɨcivɨla viaŋ cɨhu nudɨ ma igɨlan aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Namɨlaŋ cɨhu iadɨ ninaŋ mu nagadɨ viavɨla ataŋ via uben aba lɨdalaŋ aba abalɨ uami. Via ulabɨla hɨbɨ cina sɨbɨlɨ lɨci ha viaŋ nusaŋ mavɨn hekɨlɨ viben aba abalɨ uami. Viaŋ ci hadi hadi lin sadaŋ viaŋ nusaŋ vɨhɨlɨ iga iga hɨniavɨla hɨmɨben aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Hulaŋ hekɨlɨ uami. Aludɨ iavaŋ nɨbu nadɨ sibɨla hɨsɨŋ hulaŋ uami. Nɨbu ci hadi hadi li uami. Nɨbu ninaŋ agasaŋ pam mavɨn hekɨlɨ hɨnilalɨ uami. Alaŋ aludɨ ima sijaŋ agadɨ valavɨla cɨhu aludɨ iavaŋ dɨ pɨŋ umɨli nudɨ ma igɨmaŋ lavɨla ha nɨbu ilɨha ilɨha hɨniavɨla hɨmɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Viaŋ iavaŋ hula ciaŋ mɨguavɨla abacin uami. Ninaŋ agadɨ cɨhu ma vavevɨla ha viaŋ nama hula hugɨ daŋ hɨniben aba abacin uami. Hugɨ agaŋ ma sɨvɨlɨbali aba abacin uami. Hanɨbuŋ hanɨbuŋ hɨnibali aba abacin uami. ");
INSERT INTO ena_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Hameŋ sadaŋ iadɨ valɨnaŋ viaŋ nudɨ uvɨsɨjiŋ viavɨla nadɨ sibɨla hɨsɨŋ hɨnilɨŋ uami. Lɨlɨŋ nama nudɨ valɨnaŋ nudɨ isagalinu hɨhɨle agɨlaŋ hula uavɨm uami. ");
INSERT INTO ena_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ninaŋ nagaŋ viaŋ hula ma uci viaŋ iavaŋ dɨ pɨŋ ma uben uami. Viaŋ ulɨŋ vɨhɨlɨ iavaŋ dɨ hɨvɨ iahɨci igɨmagaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Josepɨ agaŋ isaimahalinu agɨladɨ igɨci mavɨn lɨci amɨŋ ilɨhɨben aba lɨmi. Ilɨhɨben aba lavɨla nudɨ sibɨla hɨsɨŋ hulaŋ agɨladɨ abami. Namɨlaŋ iadɨ valavɨla haiabɨla ivouhalaŋ uami. Abɨci ivouavɨci isaimahalinu hula hɨtɨŋ hɨnihɨni abami. Viaŋ Josepɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Lavɨla nɨbu ilɨhiŋ hekɨlɨ ilɨhami. Lɨci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ igahɨlavɨmi. Lɨhavɨci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ ulaŋ hɨvɨ hɨniavɨmi agɨlaŋ avi igahɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Josepɨ agaŋ isaimahalinu dɨ cɨhu ala abami. Viaŋ Josepɨ uami. Iadɨ iavaŋ huaci ala hɨnidi uami. Lɨci nɨbɨlaŋ i uavɨla ciaŋ ma abavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Lɨhavɨci Josepɨ nulɨdɨ abami. Namɨlaŋ iadɨ mikɨ pɨŋ vehalaŋ uami. Lɨci nudɨ pɨŋ vehavɨci nulɨdɨ abami. Viaŋ Josepɨ uami. Viaŋ naludɨ isaimanalu uami. Vaka namɨlaŋ iadɨ mutɨŋ hɨvɨ lamɨlaŋ hulaŋ limu hɨhɨle agɨlaŋ iadɨ lavavɨmi uami. Lɨhavɨci viaŋ sibɨla hɨsɨŋ hulaŋ me hɨnidalɨŋ Isipɨ fɨli tɨbɨ neŋ iadɨ vavehavɨmi uami. ");
INSERT INTO ena_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Akuaba akuaba lɨmalaŋ agasaŋ igahɨlavɨla namɨlaŋ nukeŋ nukeŋ aba aba humɨgaŋ vɨhɨlɨ vimɨlaŋ uami. Asɨ agaŋ namɨlaŋ hɨmɨmɨlaŋ aba abavɨla nɨbu nukeŋ lɨci viaŋ mɨse hali vemin uami. ");
INSERT INTO ena_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Humɨgaŋ ibɨlibɨliŋ hekɨlɨ fɨli neŋ hɨnidaci hualɨ ahica ci ualɨ uami. La cɨhu humɨgaŋ ibɨlibɨliŋ agaŋ vakala hɨnidaci hualɨ human limu fɨhala ubali uami. Udaci hualɨ ma huliavɨbali uami. Sɨmɨŋ ma likɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Asɨ agaŋ lɨci naludɨ ahɨliahuiahu saŋ viaŋ mɨse hali vemin uami. Hameŋ sadaŋ namɨlaŋ sɨkasɨkan ma haba hɨma fɨhalɨbalaŋ uami. Asɨ agaŋ nudɨ vɨdɨvɨdɨŋ hekɨlɨ hɨvɨ naludɨ ahɨliahudaci huaci hɨnibalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Iadɨ namɨlaŋ ma abɨlaŋ haiabɨla neŋ vemin uami. Asɨ agaŋ lɨci vemin uami. Nɨbu nukeŋ lɨci viaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ iaganu me hɨnilan uami. Viaŋ hulaŋ ibi daŋ hɨnihɨni hulaŋ iamɨgali nudɨ ulaŋ hɨvɨ hɨniavɨlalɨ agɨladɨ migɨlɨlan uami. Isipɨ fɨli tɨbɨ avi migɨlɨlan uami. ");
INSERT INTO ena_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Namɨlaŋ lɨhalɨha aludɨ iavaŋ dɨ pɨŋ uavɨla abɨhalaŋ uami. Ninana Josepɨ abi aba abɨhalaŋ uami. Asɨ agaŋ lɨci viaŋ Isipɨ fɨli tɨbɨ sɨkasɨkan migɨlɨlan aba abi aba abɨhalaŋ uami. Hameŋ sadaŋ nama hutesɨ hɨnimɨnaŋ aba abi aba abɨhalaŋ uami. Lɨhalɨha veha aba abi aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Vevɨla viaŋ hɨnilan mikɨ neŋ Gosen fɨli tɨbɨ hɨnibanaŋ aba abi aba abɨhalaŋ uami. Nama nadɨ ninanadina ajihalina agɨladɨdaŋ sabaŋ sipsipɨ sabaŋ bulɨmakau akuaba akuaba agɨladɨdaŋ via vevɨla fɨli tɨbɨ neŋ hɨnibalaŋ aba abi aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Nama Gosen fɨli tɨbɨ ve hɨnidanaŋ viaŋ naludɨ migɨlɨben aba abi aba abɨhalaŋ uami. Humɨgaŋ ibɨlibɨliŋ hekɨlɨ iahalɨ agaŋ hɨnidaci hualɨ human limu fɨhala ubali aba abi aba abɨhalaŋ uami. Nama nadɨ ninanadina agɨlaŋ hula sɨhɨm sabaŋ akuaba akuaba agɨlaŋ hula humɨgaŋ saŋ hɨmɨmɨlaŋ aba abi aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Lavɨla Josepɨ agaŋ isaimahalinu dɨ abami. Namɨlaŋ iadɨ sɨhɨvia sɨbaŋ ci igɨlaŋ uami. Viaŋ nukeŋ namɨlaŋ hula ciaŋ abadin uami. Iadɨ ima Bejamin avi iadɨ sɨhɨvia sɨbaŋ ci igi uami. ");
INSERT INTO ena_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Namɨlaŋ aludɨ iavaŋ dɨ pɨŋ uavɨla abɨhalaŋ uami. Josepɨ nɨbu Isipɨ fɨli tɨbɨ hɨnihɨni ibi hekɨlɨ daŋ hɨnidi aba abɨhalaŋ uami. La akuaba akuaba igɨlaŋ agasaŋ avi nudɨ sulɨhalaŋ uami. Sula fɨhalavɨla nudɨ lɨhalɨha via vavehalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Hameŋ abavɨla imanu Bejamin dɨ mɨŋalɨva hɨnihɨni ilɨhami. Lɨdaci imanu Bejamin avi ilɨhami. ");
INSERT INTO ena_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Lɨci Josepɨ agaŋ ilɨha ilɨha nudɨ isagalinu agɨladɨ mɨhum iavaiava umi. Lɨci nɨbu hula heŋ ciaŋ sulavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ Josepɨ dɨ isaimahalinu agɨlaŋ ve Josepɨ hula hɨniavɨmi agadɨ ciaŋ igahɨlami. Lavɨla hulaŋ nusaŋ hɨji igu igu hɨsɨŋ agɨlaŋ hula hɨjɨŋalavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Hɨjɨŋalavɨla Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ Josepɨ dɨ abami. Nadɨ isaimahalina dɨ abɨnaŋ nulɨdɨ vaŋ maku akuaba akuaba hihɨlavɨla via sabaŋ donɨki sabɨ hɨvɨ lamavɨla Kenan fɨli tɨbɨ cɨhu uavɨm uami. ");
INSERT INTO ena_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Uavɨla nulɨdɨ abinadinɨlu agɨladɨdaŋ ninanadinɨlu agɨladɨdaŋ via vehavɨm uami. Naludɨ iaganalu agadɨ avi viavɨla iadɨ pɨŋ cɨhu vehavɨm uami. Vehavɨci viaŋ Isipɨ fɨli tɨbɨ nagadɨ limu tɨbɨ huaci sɨbaŋ agadɨ igavɨla nulɨsaŋ iguben uami. Lavɨla nulɨsaŋ sɨmɨŋ huaci huaci neŋ hɨsɨŋ agɨladɨ igudalɨŋ nana hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Nulɨdɨ abɨnaŋ sabaŋ osɨ magɨla magɨla hɨsɨŋ vadɨm Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ via uavɨla nulɨdɨ abinadinɨlu ninanadinɨlu agɨladɨ viavɨla vehavɨm uami. Naludɨ iaganalu agadɨ avi viavɨla vehavɨm uami. ");
INSERT INTO ena_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Nulɨdɨ akuaba akuaba Kenan fɨli tɨbɨ hɨniavɨdaci vala vehavɨbali agasaŋ hɨji igahɨlavɨmɨdɨ uami. Viaŋ nulɨsaŋ akuaba akuaba huaci huaci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ iguben uami. ");
INSERT INTO ena_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Lɨci Jekopɨ dɨ ninadinu agɨlaŋ manɨgali abami hameŋ laci ala lɨhavɨmi. Josepɨ agaŋ manɨgali agadɨ ciaŋ lubiahɨlavɨla nulɨsaŋ sabaŋ osɨ magɨla magɨla hɨsɨŋ vadɨm agɨladɨ igumi. La sɨmɨŋ limu hɨhɨle hɨbɨ cina nana saŋ avi igumi. ");
INSERT INTO ena_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","La isagalinu hɨtɨŋ hɨtɨŋ agɨlasaŋ hadi hɨlahɨla pabiŋ lɨdɨŋ pabiŋ lɨdɨŋ igumi. La Bejamin saŋ hadi hɨlahɨla human limu fɨhala agɨladɨdaŋ lɨba silɨva 300 agɨladɨdaŋ igumi. ");
INSERT INTO ena_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Lavɨla Josepɨ agaŋ akuaba akuaba huaci huaci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ viavɨla iaganɨlu saŋ via uavɨbali aba sabaŋ donɨki muŋaŋ human limu limu fɨhala agɨladɨ sabɨ hɨvɨ lamami. La halɨha cahu uitɨ hɨlɨcɨ agɨladɨ viavɨla maci viavɨla akuaba akuaba sɨmɨŋ huaci huaci heŋ hɨsɨŋ agɨladɨ viavɨla sabaŋ donɨki mɨgenaŋ human limu limu fɨhala agɨladɨ sabɨ hɨvɨ lamami. Iaganu hɨbɨ cina nana veve saŋ avi lamami. ");
INSERT INTO ena_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Lavɨla Josepɨ agaŋ isaimahalinu dɨ abɨci akuaba akuaba agɨladɨ via uavɨmi. Uavɨdaci abami. Namɨlaŋ nukeŋ nukeŋ lamacilacila umɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Lɨci isaimahalinu agɨlaŋ Isipɨ fɨli tɨbɨ valavɨla iaganɨlu Jekopɨ Kenan fɨli tɨbɨ hɨnimi heŋ ua iahuavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ua iahuavɨla nudɨ abavɨmi. Josepɨ ma hɨmami uavɨmi. Nɨbu hɨhi hanɨbuŋ hɨnihɨni Isipɨ fɨli tɨbɨ sɨkasɨkan agadɨ migɨladi uavɨmi. Lɨhavɨci ciaŋ agadɨ igahɨlɨci nudɨ hɨji tɨmɨŋ tɨmɨŋ lɨmi. Lɨci nɨbu nulɨdɨ ciaŋ agasaŋ hɨji vɨdɨvɨdɨŋ ma lamami. ");
INSERT INTO ena_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Lɨci akuaba akuaba ciaŋ Josepɨ abami agɨladɨ iaganɨlu dɨ sulavɨmi. Lɨhavɨci sabaŋ osɨ magɨla magɨla hɨsɨŋ vadɨm nudɨ viavɨla Isipɨ fɨli tɨbɨ via uu saŋ vavehavɨmi agɨladɨ igami. Igɨci nudɨ hɨji heŋ toveci igahɨlami. ");
INSERT INTO ena_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","La Jekopɨ agaŋ abami. Amɨŋ ala uami. Iadɨ ninaŋ hɨhi hanɨbuŋ hɨnidi uami. Viaŋ uavɨla nudɨ igavɨla heŋ huaci hɨmɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Jekopɨ agaŋ akuaba akuaba likɨlavɨla nudɨ ninadinu nabehalinu ajihalinu agɨlaŋ hula Isipɨ fɨli tɨbɨ saŋ uavɨmi. Ua Belɨseba avɨli sɨmɨ tulɨ iahuavɨla Jekopɨ agaŋ iaganu Aisakɨ dɨ Asɨ agasaŋ sagalɨ iguben aba sabaŋ sipsipɨ ifɨhɨmavɨla hɨlami. ");
INSERT INTO ena_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Lɨci hɨfɨlɨ Asɨ agaŋ anisɨhu me hɨvɨ iahavɨla Jekopɨ dɨ abami. Jekopɨ uami. Lɨci Jekopɨ abami. Viaŋ nan hɨnidin uami. ");
INSERT INTO ena_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Lɨci Asɨ abami. Viaŋ Asɨ uami. Viaŋ nadɨ iagana dɨ Asɨ uami. Nama Isipɨ fɨli tɨbɨ uu saŋ lɨdɨmɨnaŋ uami. Viaŋ lɨlɨŋ nadɨ iamɨlɨhalina agɨlaŋ iaha habɨla hɨdɨlɨ hekɨlɨ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Viaŋ nama hula Isipɨ fɨli tɨbɨ uben uami. Nama ua Josepɨ hula hɨniavɨla hɨmɨnaŋ viaŋ nukeŋ abɨlɨŋ nadɨ valɨ agadɨ cɨhu vave mava hudɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","6","Lɨci Jekopɨ Belɨseba avɨli sɨmɨ tulɨ valavɨla uben aba lɨmi. Lɨci nudɨ ninadinu agɨlaŋ nudɨdaŋ nabehalinu ajihalinu agɨladɨdaŋ viavɨla vadɨm sabaŋ osɨ magɨla magɨla hɨdavɨhadami agɨladɨ sabɨ hɨvɨ lamavɨci mɨgahɨniavɨdaci via uavɨmi. Nulɨdɨ maku akuaba akuaba Kenan fɨli tɨbɨ hɨnihɨni vihavɨhadami agɨladɨ sɨkasɨkan via uavɨmi. Vadɨm ha nulɨdɨ ala via uu saŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ iguci vavehavɨmi. Via uavɨdaci sabaŋ bulɨmakau akuaba akuaba Kenan fɨli tɨbɨ hɨnihɨni vihavɨhadami agɨlaŋ avi nɨbɨlaŋ hula uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","8","Jekopɨ agaŋ nudɨ ninanadinu ajihalinu hula Isipɨ fɨli tɨbɨ uavɨmi agɨladɨ ibi nameŋ. Luben ha Jekopɨ dɨ ninaŋ Cimegeŋ. ");
INSERT INTO ena_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Luben ninadinu dɨ ibi nameŋ. Mu Hanokɨ. Mu Palu. Mu Hesɨlon. Mu Kalɨmi. ");
INSERT INTO ena_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon ninadinu dɨ ibi nameŋ. Mu Jemuelɨ. Mu Jamin. Mu Ohatɨ. Mu Jakin. Mu Sohalɨ. Mu Saulɨ. Saulɨ iamɨnu ha Kenan hɨdɨlɨ iamɨgali. ");
INSERT INTO ena_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Livai ninadinu dɨ ibi nameŋ. Mu Gelɨson. Mu Kohatɨ. Mu Melali. ");
INSERT INTO ena_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Juda ninadinu dɨ ibi nameŋ. Mu Elɨ. Mu Onan. Mu Saila. Mu Pelesɨ. Mu Cela. Agadɨ ala Kenan fɨli tɨbɨ hɨniavɨdaci Elɨ hula Onan hula hɨmavɨmi. Pelesɨ ninadinu dɨ ibi nameŋ. Mu Hesɨlon. Mu Amulɨ. ");
INSERT INTO ena_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakalɨ ninadinu dɨ ibi nameŋ. Mu Tola. Mu Puva. Mu Iopɨ. Mu Simɨlon. ");
INSERT INTO ena_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulun ninadinu dɨ ibi nameŋ. Mu Seletɨ. Mu Elon. Mu Jalelɨ. ");
INSERT INTO ena_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Jekopɨ abinu Lea dɨ ninadinu agɨladɨ ibi nameŋ. Mu Luben. Mu Simeon. Mu Livai. Mu Juda. Mu Isakalɨ. Mu Sebulun. Mesopotemia fɨli tɨbɨ hɨnihɨni ninaŋ agɨladɨ huhɨlami. Nadi pabiŋ huhɨlami. Nudɨ ibi Daina. Lea dɨ ninanadinu ajihalinu dɨ lugɨlavɨci ua 33 iahami. ");
INSERT INTO ena_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gatɨ ninadinu dɨ ibi nameŋ. Mu Sifion. Mu Hagi. Mu Suni. Mu Esɨbon. Mu Eli. Mu Alodi. Mu Aleli. ");
INSERT INTO ena_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aselɨ ninadinu dɨ ibi nameŋ. Mu Imɨna. Mu Isɨva. Mu Isɨvi. Mu Belia. Nadinɨlu Sela. Belia ninadinu ha Hebelɨ hula Malɨkielɨ hula. ");
INSERT INTO ena_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Hulaŋ iamɨgali ha Jekopɨ dɨ Celɨpa dɨ ninadinɨlu ajihalinɨlu. Celɨpa ha sibɨla hɨsɨŋ iamɨgali Laban agaŋ nadinu Lea saŋ igumi. Celɨpa dɨ ninadinu ajihalinu agɨladɨ lugɨlavɨci ua human limu limu fɨhala hɨcɨ limu fɨhala hɨcɨ limu pabiŋ cɨjɨŋ iahami. ");
INSERT INTO ena_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jekopɨ abinu Leselɨ dɨ ninadinu ha Josepɨ hula Bejamin hula. ");
INSERT INTO ena_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Josepɨ agaŋ Isipɨ fɨli tɨbɨ hɨniavɨla Potifela nadinu Asenatɨ dɨ sabimi. Potifela nɨbu On haiabɨla hɨnihɨni mugɨluŋ saŋ sagalɨ iguadami. Asenatɨ ninadinu ahica. Mu Manase. Mu Efɨlaim. ");
INSERT INTO ena_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Bejamin ninadinu dɨ ibi nameŋ. Mu Bela. Mu Bekelɨ. Mu Asɨbelɨ. Mu Gela. Mu Naman. Mu Ehi. Mu Losɨ. Mu Mupim. Mu Hupim. Mu Alɨtɨ. ");
INSERT INTO ena_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Hulaŋ agɨlaŋ ha Jekopɨ dɨ Leselɨ dɨ ninadinɨlu ajihalinɨlu. Nulɨdɨ lugɨlavɨci ua human limu limu fɨhala hɨcɨ limu limu ahica limu ahica cɨjɨŋ iahami. ");
INSERT INTO ena_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan ninanu dɨ ibi Husim. ");
INSERT INTO ena_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Napɨtali ninadinu dɨ ibi nameŋ. Mu Jaselɨ. Mu Guni. Mu Jeselɨ. Mu Silem. ");
INSERT INTO ena_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Hulaŋ agɨlaŋ ha Jekopɨ dɨ Bilɨha dɨ ninadinɨlu ajihalinɨlu. Bilɨha ha sibɨla hɨsɨŋ iamɨgali Laban agaŋ nadinu Leselɨ saŋ igumi. Ninadinu ajihalinu agɨladɨ lugɨlavɨci ua human limu fɨhala human limu ahica cɨjɨŋ iahami. ");
INSERT INTO ena_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Jekopɨ dɨ ninanadinu ajihalinu Isipɨ fɨli tɨbɨ uavɨmi agɨladɨ lugɨlavɨci ua 66 iahami. Nabehalinu dɨ ma lugɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Josepɨ abinu agaŋ Isipɨ fɨli tɨbɨ hɨnihɨni ninaŋ ahica agɨladɨ huhɨlami. Lɨci nulɨdɨdaŋ hulaŋ iamɨgali Jekopɨ hula Isipɨ fɨli tɨbɨ uavɨmi agɨladɨdaŋ lugɨlavɨci ua 70 iahami. ");
INSERT INTO ena_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","29","Jekopɨ agaŋ Josepɨ ve nudɨ Gosen fɨli tɨbɨ igɨbali aba Juda dɨ abɨci hali umi. Udaci Jekopɨ ani ani agɨlaŋ ve Gosen fɨli tɨbɨ iahavɨci Josepɨ agaŋ sibɨla hɨsɨŋ hulemɨlɨ agɨladɨ abɨci vadɨm sabaŋ osɨ magɨla magɨla hɨsɨŋ agadɨ sɨhuvavɨmi. Lɨhavɨci Josepɨ agaŋ iaganu dɨ igɨben aba Gosen fɨli tɨbɨ umi. Uavɨla iaganu dɨ igavɨla mɨŋahubɨhahavɨla ilɨhiŋ hutesɨ ilɨha ilɨha hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Lɨci Jekopɨ agaŋ Josepɨ dɨ abami. Viaŋ igɨlɨŋ nama huaci hɨninaŋ hɨjɨŋalin uami. Hameŋ sadaŋ viaŋ hɨmɨben aba huaci hɨmɨvin uami. ");
INSERT INTO ena_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Lɨci Josepɨ agaŋ nudɨ iaganu dɨdaŋ nudɨ isaimahalinu agɨladɨdaŋ abami. Viaŋ ua iadɨ manɨgali agadɨ abɨben uami. Iadɨ iavaŋ iadɨ isaimahali ani ani agɨlaŋ viaŋ hula hɨniben aba Kenan fɨli tɨbɨ valavɨla ci ve iahavi aba abɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Nɨbɨlaŋ sabaŋ sipsipɨ sabaŋ bulɨmakau migɨla migɨla sibɨla vihavɨlalɨ aba abɨben uami. Nulɨdɨ sabaŋ sipsipɨ sabaŋ bulɨmakau akuaba akuaba agɨladɨ sɨkasɨkan vavehavi aba abɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","34","Abɨlɨŋ nɨbu naludɨ nameŋ abɨci namɨlaŋ akɨ sibɨla vilalaŋ aba abɨci nudɨ abɨhalaŋ uami. Manɨgali alaŋ sabaŋ sipsipɨ sabaŋ bulɨmakau migɨlɨlalu aba abɨhalaŋ uami. Aludɨ iagagali sibɨla vaka vihavɨhadami hameŋ laci ala alaŋ avi hulemɨlɨ hɨnihɨni sibɨla nagadɨ vihadamɨlu aba abɨhalaŋ uami. Ci igɨlaŋ uami. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ hulaŋ sabaŋ sipsipɨ migɨlavɨlalɨ agɨladɨ sɨbɨlɨ igavɨlalɨ uami. Hameŋ sadaŋ namɨlaŋ manɨgali agadɨ abɨlaŋ naludɨ abɨci Gosen fɨli tɨbɨ ua hɨnibalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","La Josepɨ agaŋ nulɨdɨ vala vevɨla manɨgali agadɨ abami. Iadɨ iavaŋ agaŋ iadɨ isaima ani ani agɨlaŋ hula Kenan fɨli tɨbɨ agadɨ vala vehavalɨ uami. Nulɨdɨ sabaŋ sipsipɨ sabaŋ bulɨmakau akuaba akuaba ahuata likɨlavɨla vavehavalɨ uami. Ve Gosen fɨli tɨbɨ hɨniavadi uami. ");
INSERT INTO ena_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Hameŋ abavɨla Josepɨ agaŋ isagalinu human limu fɨhala agɨladɨ abɨci manɨgali agadɨ pɨŋ vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Vehavɨci manɨgali agaŋ nulɨdɨ abami. Namɨlaŋ akɨ sibɨla vilalaŋ uami. Lɨci abavɨmi. Alaŋ nadɨ sibɨla hɨsɨŋ hulaŋ uavɨmi. Alaŋ aludɨ iagagali sabaŋ sipsipɨ migɨlavɨhadami hameŋ laci ala migɨlɨlalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Humɨgaŋ ibɨlibɨliŋ hekɨlɨ Kenan fɨli tɨbɨ heŋ iahalɨ uavɨmi. Iahɨci humɨsɨ sabaŋ sipsipɨ nana hɨsɨŋ agaŋ apalɨ lɨci alaŋ fɨli tɨbɨ neŋ ilɨmiŋ hɨnibalu aba vehɨlu uavɨmi. Nama huaci aludɨ alialaŋ aba abɨnaŋ Gosen fɨli tɨbɨ hɨnivɨlu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Lɨhavɨci manɨgali agaŋ Josepɨ dɨ abami. Nadɨ iagana isaimahalina nama hula hɨniben aba ci vehavalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Isipɨ fɨli tɨbɨ neŋ fɨli mu huaci sɨbaŋ agadɨ igavɨla abɨnaŋ uavɨla heŋ hɨniavɨm uami. Nama nulɨdɨ Gosen fɨli tɨbɨ hɨnihɨni saŋ abɨnaŋ ha huaci heŋ ala hɨniavɨbali uami. Nadɨ isaimana agɨladɨ hulaŋ hɨhɨle igɨnaŋ sabaŋ bulɨmakau sabaŋ sipsipɨ migɨla migɨla hɨsɨŋ hɨji huaci daŋ hɨniavɨci uami. Ha abɨnaŋ iadɨ sabaŋ bulɨmakau sabaŋ sipsipɨ agɨladɨ avi migɨlavɨm uami. ");
INSERT INTO ena_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Lɨci Josepɨ agaŋ iaganu Jekopɨ dɨ via manɨgali agadɨ pɨŋ uavɨmi. Uavɨla Jekopɨ agaŋ manɨgali agadɨ abami. Asɨ nadɨ huaci lamɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Lɨci manɨgali agaŋ abami. Nadɨ hualɨ vameŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Lɨci Jekopɨ abami. Iadɨ hualɨ 130 laci uami. Ha hutesɨ sɨbaŋ hɨma uami. Viaŋ vɨhɨlɨ akape igɨlan uami. Iadɨ iamɨlɨhali iauacagali fɨli neŋ hutesɨ hɨniavɨhadami agɨladɨ hualɨ agɨlaŋ iadɨ hualɨ agɨladɨ lɨvalavɨmi uami. ");
INSERT INTO ena_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","La abami. Asɨ nadɨ huaci lamɨbali uami. Lavɨla vala vemi. ");
INSERT INTO ena_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Lɨci Josepɨ agaŋ manɨgali agadɨ ciaŋ lubiahɨlavɨla iaganu dɨdaŋ isaimahalinu agɨladɨdaŋ ahɨliahuci Isipɨ fɨli tɨbɨ hɨniavɨmi. Hɨniavɨdaci Lamesesɨ haiabɨla agadɨ fɨli tɨbɨ agadɨ nulɨsaŋ igumi. Fɨli tɨbɨ igumi agaŋ nɨbu fɨli tɨbɨ mu mu agɨladɨ lɨvala fɨli tɨbɨ huaci sɨbaŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Josepɨ agaŋ nudɨ iaganu isaimahalinu abinadinɨlu ninanadinɨlu agɨlasaŋ sɨmɨŋ sɨhɨvia sɨbaŋ mɨŋa hɨlihalahala lamadami. ");
INSERT INTO ena_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Humɨgaŋ ibɨlibɨliŋ hekɨlɨ iahɨci fɨli tɨbɨ mu mu sɨmɨŋ apalɨ lɨmi. Lɨci Isipɨ fɨli tɨbɨ hɨsɨŋ Kenan fɨli tɨbɨ hɨsɨŋ hulaŋ iamɨgali agɨlaŋ sɨbɨlɨ sɨbɨlɨ lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Lavɨla sɨmɨŋ ulaŋ hekɨlɨ hekɨlɨ Josepɨ migɨladami agɨladɨ hɨvɨ halɨha cahu uitɨ hɨlɨcɨ lavalava hɨnia nulɨdɨ anɨm hɨlɨcɨ agɨladɨ fɨhalavɨmi. Lɨhavɨci Josepɨ agaŋ anɨm hɨlɨcɨ agɨladɨ via Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ ulaŋ hɨvɨ lamɨci hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Hɨniavɨdaci Isipɨ fɨli tɨbɨ hɨsɨŋ Kenan fɨli tɨbɨ hɨsɨŋ agɨladɨ anɨm hɨlɨcɨ apalɨ lɨhavɨmi. Lɨhavɨci hulaŋ iamɨgali Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ Josepɨ dɨ pɨŋ uu abavɨmi. Alaŋ anɨm hɨlɨcɨ apalɨ uavɨmi. Alusaŋ sɨmɨŋ iguha uavɨmi. Hɨma lɨci nama igasulɨdanaŋ humɨgaŋ ibɨlibɨliŋ agaŋ lɨdaci alaŋ mɨgaifaifa hɨmɨbalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Lɨhavɨdaci Josepɨ abami. Anɨm hɨlɨcɨ naludɨ apalɨ lɨci uami. Namɨlaŋ sabaŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ vavevave iasaŋ iguhalaŋ uami. Hameŋ lɨdalaŋ hɨbɨŋ nalusaŋ sɨmɨŋ iguben uami. ");
INSERT INTO ena_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Lɨci nulɨdɨ sabaŋ osɨ sabaŋ sipsipɨ sabaŋ bulɨmakau sabaŋ donɨki agɨladɨ vivi uavɨmi. Vivi uu Josepɨ saŋ iguavɨdaci hɨbɨŋ nulɨsaŋ sɨmɨŋ igumi. Hameŋ lɨhavɨdaci hualɨ agaŋ umi. ");
INSERT INTO ena_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Lɨci hualɨ mu hɨvɨ cɨhu uavɨla Josepɨ dɨ abavɨmi. Hulaŋ hekɨlɨ uavɨmi. Alaŋ aludɨ vɨhɨlɨ agɨlasaŋ nadɨ ma mɨŋasɨvɨlɨbalu uavɨmi. Nama aludɨ anɨm hɨlɨcɨ sabaŋ sipsipɨ sabaŋ bulɨmakau akuaba akuaba agɨladɨ ci vi fɨhalahanaŋ uavɨmi. Alaŋ akuaba akuaba mu nasaŋ igu igu agaŋ apalɨ uavɨmi. Hameŋ sadaŋ nama aludɨ fɨli tɨbɨ agɨladɨ viben aba ha hulaŋ iamɨgali aludɨdaŋ sɨkasɨkan vibanaŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nama aludɨ ma viavɨla ahɨliahunaŋ alaŋ sɨmɨŋ saŋ hɨmɨmɨli aludɨ fɨli tɨbɨ agɨlaŋ sɨbɨlɨ lɨhavɨbali uavɨmi. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ nukeŋ alusaŋ sɨmɨŋ igunɨdaci alaŋ nudɨ sibɨla hɨsɨŋ hulemɨlɨ hɨnibalu uavɨmi. Hɨnidamɨli aludɨ fɨli tɨbɨ agɨladɨ avi vibali uavɨmi. Vici alusaŋ sɨmɨŋ uli igunaŋ alaŋ ma hɨmɨbalu uavɨmi. Alaŋ huaci hɨnimɨli fɨli tɨbɨ agɨlaŋ avi ma sɨbɨlɨ lɨhavɨbali uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Humɨgaŋ ibɨlibɨliŋ agaŋ lɨci hulaŋ iamɨgali Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ nulɨdɨ fɨli tɨbɨ agɨladɨ Josepɨ saŋ valavɨci nudɨ manɨgali saŋ lavami. Lɨci Isipɨ fɨli tɨbɨ agaŋ manɨgali agadɨ fɨli tɨbɨ laci hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Josepɨ agaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ iamɨgali sɨkasɨkan agɨladɨ abɨdaci nulɨdɨ fɨli tɨbɨ agɨladɨ valavala uu mu haiabɨla mu haiabɨla hɨvɨ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Mugɨluŋ saŋ sagalɨ igu igu hɨsɨŋ hulaŋ agɨladɨ fɨli tɨbɨ laci Josepɨ ma lavami. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ mugɨluŋ saŋ sagalɨ igu igu hɨsɨŋ hulaŋ agɨlasaŋ anɨm hɨlɨcɨ igudaci sɨmɨŋ lavavɨhadami. Hameŋ sadaŋ nulɨdɨ fɨli tɨbɨ agadɨ lavalava saŋ ma abavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Lɨhavɨci Josepɨ agaŋ hulaŋ iamɨgali agɨladɨ abami. Ci igɨlaŋ uami. Viaŋ naludɨdaŋ fɨli tɨbɨ naludɨ agɨladɨdaŋ lavɨlɨŋ manɨgali agadɨ sibɨla hɨsɨŋ hulemɨlɨ hɨnilaŋ uami. Sɨmɨŋ uli nan uami. Via ua hualabɨla hɨvɨ hulihalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Lɨlaŋ sɨmɨŋ hualabɨla hɨsɨŋ agɨlaŋ iaha mɨdɨ lɨhuavɨci viavɨla labɨla human limu fɨhala mɨguŋ lamɨhalaŋ uami. La pabiŋ mɨguŋ manɨgali saŋ iguhalaŋ uami. Limu ahica limu ahica mɨguŋ ha naludɨ nukeŋ uami. Lavɨla hɨhɨle cɨhu hulihuli saŋ lamɨhalaŋ uami. Hɨhɨle hɨnici ha naludɨ abinadinalu ninanadinalu ani ani agɨlaŋ hula nɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Lɨci hulaŋ iamɨgali agɨlaŋ abavɨmi. Hulaŋ hekɨlɨ uavɨmi. Nama aludɨ ahɨliahuahanaŋ sadaŋ alaŋ huaci hɨnibalu uavɨmi. Nama aludɨ igavɨla hɨjɨŋalɨnaŋ ha alaŋ manɨgali agadɨ sibɨla hɨsɨŋ hulemɨlɨ hɨnibalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Lɨhavɨci Josepɨ agaŋ ciaŋ vɨdɨvɨdɨŋ lamavɨla abami. Sɨmɨŋ hualabɨla hɨsɨŋ mɨdɨ lɨhuci viavɨla hulaŋ iamɨgali ahuata labɨla human limu fɨhala mɨguŋ lamavɨbali uami. La pabiŋ mɨguŋ manɨgali saŋ iguavɨbali uami. Ciaŋ vɨdɨvɨdɨŋ lamavɨla abami agaŋ hameŋ laci hɨniadami. Mugɨluŋ saŋ sagalɨ igu igu hɨsɨŋ hulaŋ agɨladɨ fɨli tɨbɨ laci manɨgali agaŋ ma vimi. ");
INSERT INTO ena_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Isɨlaelɨ hɨdɨlɨ agɨlaŋ Isipɨ fɨli tɨbɨ ua hɨniavɨla fɨli agadɨ limu tɨbɨ vihavɨmi. Fɨli tɨbɨ vihavɨmi agadɨ ibi Gosen. Lavɨla ninanadi akape huhɨlavɨci iaha habɨla hɨdɨlɨ hekɨlɨ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jekopɨ agaŋ Isipɨ fɨli tɨbɨ hɨnidaci hualɨ human limu limu fɨhala hɨcɨ limu fɨhala hɨcɨ limu ahica cɨjɨŋ umi. Lɨci nudɨ hualɨ agadɨ lugɨlavɨci ua 147 iahami. ");
INSERT INTO ena_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Jekopɨ agaŋ amɨŋ ci hɨmɨben aba lavɨla ninanu Josepɨ dɨ ulɨci veci abami. Nama iasaŋ hɨjɨŋalavɨla ha ciaŋ mɨguben aba nadɨ human agadɨ iadɨ lagiŋ lɨhu hɨvɨ lamɨnaŋ vem uami. Lamɨnaŋ veci ciaŋ mɨguavɨla abɨha uami. Iadɨ iavaŋ saŋ hɨjɨŋalavɨla akuaba akuaba agɨladɨ amɨŋ sɨbaŋ lɨben aba abɨha uami. Viaŋ nudɨ huaci lamɨben aba abɨha uami. La nɨbu hɨmɨci Isipɨ fɨli tɨbɨ ma mava hudɨben aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Lavɨla abami. Viaŋ hɨmɨlɨŋ iadɨ amɨŋ agaŋ uavɨla iadɨ iamɨlɨhali dɨ amɨŋ hɨniavɨlalɨ heŋ hɨnidaci nama iadɨ valɨ agadɨ viavɨla Isipɨ fɨli tɨbɨ valavɨla uha uami. Uavɨla iadɨ iamɨlɨhali dɨ mava hudavɨhadami heŋ ala mava hudɨha uami. Lɨci Josepɨ abami. Nama abɨnaŋ hameŋ laci ala lɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Lɨci Jekopɨ cɨhu abami. Nama hɨvɨ hekɨlɨ aba abavɨla abɨha uami. Akuaba akuaba nama abɨnaŋ hameŋ sɨbaŋ lɨben aba abɨha uami. Lɨci Josepɨ agaŋ hɨvɨ hekɨlɨ aba abavɨla abami. Viaŋ amɨŋ sɨbaŋ nama abɨnaŋ hameŋ ala lɨben uami. Lɨci Jekopɨ agaŋ Josepɨ saŋ hɨjɨŋalaŋala nudɨ hali agadɨ lɨbuhɨla ani hɨsɨva hɨsɨva hɨsɨŋ vadɨm mɨgahɨnimi agadɨ sabɨ heŋ lamami. ");
INSERT INTO ena_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","La hɨniavɨdaci hulaŋ mu agaŋ ve Josepɨ dɨ abami. Nadɨ iagana hɨmuhɨmu daŋ hɨnidi uami. Lɨci Josepɨ agaŋ nudɨ ninaŋ ahica Manase dɨdaŋ Efɨlaim dɨdaŋ viavɨla iaganu Jekopɨ dɨ igɨben aba uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","4","Uavɨci hulaŋ mu agaŋ Jekopɨ dɨ abami. Nadɨ ninana Josepɨ nadɨ igɨben aba ci ve uami. Lɨci Jekopɨ agaŋ simɨsimɨ iaha vadɨm hɨvɨ mɨgahɨniavɨla Josepɨ dɨ abami. Vaka viaŋ Kenan fɨli tɨbɨ Lusɨ haiabɨla heŋ hɨnimin uami. Hɨnidalɨŋ Asɨ vɨdɨvɨdɨŋ hekɨlɨ daŋ agaŋ heŋ iaha iadɨ huaci lamalama saŋ ciaŋ huaci nameŋ abami uami. Nasaŋ ninanadi akape iguben aba abami uami. Lɨlɨŋ nadɨ iamɨlɨhalina mufɨli mufɨli iahavɨbali agɨlaŋ habɨla hɨdɨlɨ akape hɨniavɨbali aba abami uami. Lɨhavɨci fɨli tɨbɨ nagadɨ nulɨsaŋ igulɨŋ mufɨli mufɨli nulɨdɨ fɨli tɨbɨ sɨbaŋ hɨnibali aba abami uami. ");
INSERT INTO ena_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Lavɨla Jekopɨ agaŋ cɨhu abami. Viaŋ nadɨ pɨŋ Isipɨ fɨli tɨbɨ neŋ ma ve iahɨmaŋ lɨdalɨŋ nadɨ abina ninaŋ ahica huhɨlami uami. Ninaŋ ahica Manase hula Efɨlaim hula ha iadɨ uami. Nɨbɨlaŋ iadɨ ninaŋ ahica Luben me Simeon me sɨbaŋ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Agadɨ ala ninanadi Manase dɨ Efɨlaim dɨ sɨvɨ iahavɨbali ha nadɨ nukeŋ uami. Nɨbɨlaŋ nulɨdɨ hɨdɨlɨ hɨtɨŋ hɨtɨŋ agɨlasaŋ fɨli tɨbɨ latɨhavɨci isagalinɨlu ahica Efɨlaim dɨ Manase dɨ ibi hɨvɨ vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Viaŋ Mesopotemia fɨli tɨbɨ valavɨla vemin uami. La Kenan fɨli tɨbɨ ve iahavɨla Efɨlata haiabɨla saŋ udalɨŋ nadɨ iamɨna Leselɨ hɨmami uami. Hɨmɨci Efɨlata haiabɨla saŋ uu veve hɨbɨ pɨlɨ caba heŋ nudɨ mava hudamin uami. Hameŋ sadaŋ iadɨ mavɨn lɨci nadɨ ninaŋ ahica agɨladɨ vivi saŋ abin uami. Betɨlehem haiabɨla agasaŋ vaka Efɨlata haiabɨla uavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Jekopɨ agaŋ Josepɨ dɨ ninaŋ ahica agɨladɨ igavɨla abami. Hulaŋ cɨki cɨki ahica hana ani dɨ ninaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Lɨci Josepɨ abami. Ninaŋ ahica iadɨ uami. Viaŋ Isipɨ fɨli tɨbɨ neŋ hɨnidalɨŋ Asɨ iasaŋ igumi uami. Lɨci Jekopɨ abami. Iadɨ pɨŋ likɨla vavenaŋ Asɨ dɨ abɨlɨŋ nulɨdɨ huaci lamɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Jekopɨ agaŋ hadi hadi sɨbaŋ lɨci nudɨ lamɨgaŋ hɨfɨlɨ hɨfɨlɨ lɨdaci akuaba akuaba sɨhɨvia ma igadami. Lɨdaci Josepɨ nudɨ ninaŋ ahica agɨladɨ viavɨla Jekopɨ dɨ pɨŋ via uci nulɨdɨ mɨŋahubɨhahavɨla mɨhum iavami. ");
INSERT INTO ena_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Lavɨla Josepɨ dɨ abami. Viaŋ vaka nadɨ ma akua igɨben aba abamin uami. Agadɨ ala iabi Asɨ iadɨ valɨci hɨniavɨla viaŋ nadɨdaŋ nadɨ ninaŋ ahica nagɨladɨdaŋ ci igin uami. ");
INSERT INTO ena_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Lɨci Josepɨ agaŋ nudɨ ninaŋ ahica Jekopɨ dɨ lagiŋ mikɨ pɨŋ hɨniavɨmi agɨladɨ human hɨvɨ mɨŋamagɨlɨci vemitavɨmi. Lɨhavɨci Jekopɨ dɨ ibi mɨŋaiahɨben aba fɨli hɨvɨ sɨkasɨkan mɨgavɨla ipalɨci mɨguci ani valɨ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Lavɨla Josepɨ agaŋ Manase Jekopɨ dɨ human sɨmi kɨlikɨli lagulamɨbali aba human sakalɨ hɨvɨ mɨŋalɨva via umi. Efɨlaim agaŋ human sakalɨ kɨlikɨli lagulamɨbali aba human sɨmi hɨvɨ mɨŋalɨva via umi. ");
INSERT INTO ena_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Via uci ala Jekopɨ agaŋ nudɨ human hɨlihuavɨla human sɨmi agadɨ Iagɨveŋ Efɨlaim dɨ hali sabɨ hɨvɨ lamami. Human sakalɨ agadɨ Cimegeŋ Manase dɨ hali sabɨ hɨvɨ lamami. ");
INSERT INTO ena_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Lavɨla Asɨ agaŋ Josepɨ dɨ hɨdɨlɨ agɨladɨ huaci lamɨbali aba Asɨ dɨ nameŋ abami. Asɨ uami. Iadɨ iauacaŋ Ebɨlam hula iadɨ iavaŋ Aisakɨ hula nadɨ lɨhu hɨvɨ hɨniavɨhadami uami. Nama iadɨ sɨhɨvia sɨbaŋ migɨlɨlanaŋ uami. Hulemɨlɨ cɨki hɨnidalɨŋ hɨdɨlɨ maha migɨla migɨla venaŋ iabi neŋ ci hadi hadi lin uami. ");
INSERT INTO ena_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Viaŋ vɨhɨlɨ igɨdalɨŋ nama nadɨ ciaŋ hali hɨsɨŋ me veve iadɨ ahɨliahulanaŋ uami. Nama ninaŋ ahica nagɨladɨ huaci lamɨha uami. Lɨnaŋ nulɨdɨ ninanadi agɨlaŋ iaha habɨla hulaŋ iamɨgali hɨdɨlɨ hekɨlɨ hɨniavɨm uami. Hɨniavɨdaci hulaŋ iamɨgali agɨlaŋ nulɨdɨ iga iga Ebɨlam dɨ Aisakɨ dɨ ibi agɨlasaŋ ma uava iahuavɨbali uami. Iadɨ ibi agasaŋ avi ma uava iahuavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Jekopɨ agaŋ nudɨ human sɨmi Efɨlaim dɨ hali sabɨ hɨvɨ lamɨci Josepɨ igɨci huaci ma lɨmi. La iaganu dɨ human sɨmi agadɨ viavɨla Manase dɨ hali sabɨ hɨvɨ lamɨben aba lɨmi. ");
INSERT INTO ena_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","La iaganu dɨ abami. Iavaŋ hameŋ lɨmɨnaŋ uami. Ninaŋ nagaŋ nɨbu hekɨlɨ sadaŋ nadɨ human sɨmi agadɨ nudɨ hali sabɨ hɨvɨ lamɨha uami. ");
INSERT INTO ena_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Hameŋ abɨci ala iaganu valavɨla ninanu Josepɨ dɨ abami. Ninaŋ uami. Viaŋ ci igin uami. Manase dɨ ninanadi avi iaha habɨla hulaŋ iamɨgali hɨdɨlɨ hekɨlɨ hɨniavɨbali uami. Agadɨ ala imanu dɨ ninanadi agɨlaŋ iaha habɨla nulɨdɨ lɨvala hɨdɨlɨ akape sɨbaŋ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","La nulɨdɨ huaci lamami uaiaŋ heŋ laci ala cɨhu abami. Isɨlaelɨ hɨdɨlɨ agɨlaŋ Asɨ hulaŋ iamɨgali hɨhɨle agɨladɨ huaci lamalama saŋ nameŋ abavɨbali uami. Asɨ Efɨlaim dɨdaŋ Manase dɨdaŋ huaci lamami hameŋ ala naludɨ avi huaci lamɨbali aba abavɨbali uami. Hameŋ abavɨla Efɨlaim dɨ ninaŋ magɨlasiŋ me lamami. Lɨci ninaŋ magɨlasiŋ Manase agaŋ sɨvɨ hɨsɨŋ me hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Lavɨla Jekopɨ agaŋ Josepɨ dɨ abami. Ci igɨnaŋ uami. Viaŋ amɨŋ ci hɨmɨben uami. Agadɨ ala Asɨ namɨlaŋ hula hɨnia naludɨ iauacagalinalu dɨ fɨli tɨbɨ hɨvɨ cɨhu via ubali uami. ");
INSERT INTO ena_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Vaka viaŋ iadɨ puia hutesɨ daŋ hɨmi daŋ viavɨla Amolɨ hɨdɨlɨ agɨlaŋ hula sagaŋ lɨbavɨla nulɨdɨ lɨvalavɨla halu mu agadɨ vimin uami. Halu agadɨ nasaŋ pam iguben uami. Isagalina saŋ ma iguben uami. ");
INSERT INTO ena_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Lavɨla Jekopɨ agaŋ nudɨ ninadinu dɨ abɨci vehavɨci abami. Iadɨ mikɨ pɨŋ velaŋ akuaba akuaba mufɨli naludɨ hɨvɨ iahavɨbali agasaŋ abɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Viaŋ Jekopɨ uami. Iadɨ ibi mu Isɨlaelɨ uami. Iadɨ ninadi namɨlaŋ ve iadɨ pɨŋ mɨgudɨbavɨla iadɨ ciaŋ sɨhɨvia sɨbaŋ igahɨlɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Luben nama iadɨ ninaŋ Cimegeŋ uami. Viaŋ mɨnibɨlɨ hɨniavɨla nadɨ havamin uami. Nama iadɨ ninaŋ hɨhɨle agɨladɨ lɨvala hulaŋ hekɨlɨ vɨdɨvɨdɨŋ daŋ hɨnilanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Agadɨ ala akuaba akuaba lusɨŋ vilanaŋ agaŋ avɨli hagameŋ velalɨ hameŋ me vilanaŋ uami. Nama lusɨŋ sɨbɨlɨ sɨbaŋ viavɨla iadɨ iamɨgali hɨvɨ agaŋ hula hɨdamanaŋ uami. La iasaŋ sɨhum hekɨlɨ igumanaŋ sadaŋ nama manɨgali ma hɨnibanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon hula Livai hula nɨbɨlaŋ nusi nula uami. Nɨbɨlaŋ puia hutesɨ akuaba akuaba sagaŋ hɨsɨŋ agɨladɨ viavɨla hulaŋ hɨhɨle agɨladɨ sɨbɨlɨ lamavɨmi uami. ");
INSERT INTO ena_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Nɨbɨlaŋ hulaŋ hɨhɨle hula lamacilavɨla nulɨdɨ ifɨhɨmavɨmi uami. La nulɨdɨ nukeŋ hɨji lubiahɨlavɨla sabaŋ bulɨmakau agɨladɨ hɨcɨ ilɨŋ avi ihalahavɨmi uami. Hameŋ sadaŋ viaŋ nɨbɨlaŋ hula hafalavɨla ciaŋ ma sulɨben uami. Nɨbɨlaŋ akuaba akuaba lɨbalu aba abaigahɨlavɨci viaŋ nɨbɨlaŋ hula hɨji humɨgaŋ pam ma hɨniben uami. ");
INSERT INTO ena_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Nulɨdɨ lamacilacila hɨji agɨlaŋ hekɨlɨ sɨbaŋ uami. Nulɨdɨ igɨvɨ hɨnihɨni hɨji agɨlaŋ avi hekɨlɨ sɨbaŋ uami. Hameŋ sadaŋ nɨbɨlaŋ nukeŋ vɨhɨlɨ igavɨbali uami. Viaŋ lɨlɨŋ nɨbɨlaŋ hɨtɨŋ hɨtɨŋ lavɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ hulaŋ iamɨgali limu hɨhɨle agɨladɨ alɨhaŋ alɨhaŋ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Lavɨla Juda dɨ abami. Nama hulaŋ nadɨ nagɨli lamavɨlalɨ agɨladɨ sugɨtaŋ mɨŋalatɨhɨbanaŋ uami. Lɨnaŋ nadɨ isaimahalina agɨlaŋ nadɨ ibi mɨŋaiahɨbalu aba mɨgalɨfɨlɨbavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda nɨbu idɨhuŋ laion ninaŋ hagɨlu hekɨlɨ me uami. Nɨbu sɨhɨm sabaŋ agɨhɨmuhɨmu nana vɨdɨvɨdɨŋ daŋ hɨnihɨni me hɨnilalɨ uami. Nɨbu idɨhuŋ laion me simɨ sɨbaŋ hɨlɨhɨma hɨnidaci hulaŋ nudɨ ma cihalavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Nɨbu manɨgali agadɨ kɨlɨ lɨmɨ mɨŋalɨvavɨla manɨgali hɨnihɨni hameŋ laci hameŋ laci hɨnibali uami. Manɨgali ibi agaŋ nudɨ hɨvɨ hɨnidaci akuaba akuaba manɨgali hɨnihɨni hɨsɨŋ agɨladɨ via hɨnibali uami. Via hɨnidaci hulaŋ iamɨgali hɨdɨlɨ mu mu agɨlaŋ nudɨ lɨhu hɨvɨ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Nɨbu lɨmɨn uain akape sɨbaŋ daŋ uami. Nudɨ sabaŋ donɨki lɨbɨben aba lɨmɨn uain pɨlɨ heŋ lɨbɨlalɨ uami. Lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ akape vilalɨ uami. Lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨ hulaŋ iamɨgali ma na fɨhalavɨbali uami. Hameŋ sadaŋ nudɨ hadi hɨlahɨla hutesɨ agadɨdaŋ muhɨlɨ havɨlɨ limu hɨhɨle agɨladɨdaŋ lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨ hɨvɨ husɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Nɨbu lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ hekɨlɨ nɨlalɨ sadaŋ nudɨ lamɨgaŋ agɨlaŋ mɨdɨ lɨhulɨhu hɨniavɨlalɨ uami. Sabaŋ bulɨmakau amaŋ hekɨlɨ nɨlalɨ sadaŋ nudɨ mɨka agɨlaŋ mila sɨbaŋ hɨniavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulun nɨbu avɨli hekɨlɨ caba heŋ hɨnibali uami. Hɨnidaci nudɨ hunɨga sabɨlɨm agaŋ huaci sɨbaŋ hɨnibali uami. Fɨli tɨbɨ nudɨ agaŋ laci ua Saidon haiabɨla agadɨ fɨli tɨbɨ hula valɨ hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakalɨ nɨbu sabaŋ donɨki vɨdɨvɨdɨŋ daŋ me uami. Agadɨ ala muhɨlɨ havɨlɨ vaŋ akuaba akuaba havahava saŋ nudɨ sabɨ lamavɨci ala nɨbu ihɨlu lavavɨla havɨ mɨgalɨfɨlɨbavɨla ani hɨsɨvɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Nudɨ fɨli tɨbɨ agadɨ igɨci fɨli huaci sɨbaŋ hɨnibali uami. Nudɨ hɨnihɨni hɨsɨŋ uvɨ agaŋ avi huaci sɨbaŋ hɨnibali uami. Agadɨ ala nudɨ nukeŋ sibɨla ma vibali uami. Hulaŋ limu hɨhɨle abavɨdaci heŋ vɨdɨvɨdɨŋ lagulama sibɨla vibali uami. Lɨdɨŋ nulɨdɨ sibɨla hɨsɨŋ hulemɨlɨ hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan nɨbu ciaŋ hihɨla hihɨla hɨsɨŋ hulaŋ hɨnibali uami. Hɨnihɨni nudɨ hulaŋ iamɨgali agɨladɨ migɨlɨbali uami. Isɨlaelɨ hɨdɨlɨ agɨladɨ manɨgali limu hɨhɨle agɨlaŋ nulɨdɨ hulaŋ iamɨgali migɨlavɨlalɨ hameŋ laci ala migɨlɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Nɨbu lahu sɨbɨlɨ hɨbɨ pɨlɨ caba hɨvɨ migɨla migɨla hɨnihɨni me hɨnibali uami. Hɨnidaci hulaŋ sabaŋ osɨ sabɨ hɨvɨ veci havala ua sabaŋ osɨ agadɨ hɨcɨ iavɨci hulaŋ agaŋ hulɨpɨŋ hɨvɨ mɨgaifɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","La Jekopɨ agaŋ abami. Asɨ Iaue uami. Nama iadɨ ahɨliahunaŋ huaci hameŋ laci hameŋ laci hɨniben agasaŋ migɨla migɨla hɨnidin uami. ");
INSERT INTO ena_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","La abami. Gatɨ uami. Sagaŋ hɨsɨŋ agɨlaŋ nadɨ akuaba akuaba viben aba ve nama hula sagaŋ lɨbavɨbali uami. Hameŋ lɨhavɨci ala nama avi hɨbɨŋ ua nɨbɨlaŋ hula sagaŋ lɨbavɨla nulɨdɨ lahunaŋ uavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aselɨ uami. Nadɨ fɨli tɨbɨ heŋ sɨmɨŋ akape iahavɨbali uami. Lɨhavɨci nama sɨmɨŋ huaci huaci manɨgali nana saŋ mavɨn hɨniavɨlalɨ agɨladɨdaŋ hɨnibanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Napɨtali nɨbu sabaŋ meme huvɨsɨ me hɨdɨlalɨ uami. Lɨdɨŋ sɨmɨŋ huaci huaci nana hɨnihɨni ninaŋ huaci huaci huhɨlalɨ me hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Josepɨ nɨbu lɨmɨn uain huaci sɨbaŋ avɨli sɨmɨ tulɨ mikɨ hɨvɨ iaha amɨŋ akape lamɨlalɨ agaŋ me hɨnilalɨ uami. Lɨdaci nudɨ makaŋ makaŋ agɨlaŋ hutesɨ lɨdɨŋ lua agadɨ hafilamavɨlalɨ agɨlaŋ me hɨnilalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Lɨdaci hulaŋ hɨhɨle sagaŋ saŋ vɨdɨvɨdɨŋ lagulamavɨla hɨmi hɨvɨ sibɨla sibɨla nudɨ sɨbɨlɨ lamɨben aba lɨhavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Agadɨ ala nɨbu avi nudɨ hɨmi agadɨ hihala hihala hɨnilalɨ uami. Iadɨ Asɨ vɨdɨvɨdɨŋ hekɨlɨ daŋ agaŋ nusaŋ vɨdɨvɨdɨŋ igudaci nudɨ human ma haba hɨmɨlalɨ uami. Asɨ nɨbu ala Isɨlaelɨ hɨdɨlɨ agɨladɨ migɨlɨdaci nudɨ hɨvɨ vɨdɨvɨdɨŋ lagulamavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","La cɨhu Josepɨ dɨ abami. Nadɨ iagana dɨ Asɨ agaŋ nɨbu Asɨ vɨdɨvɨdɨŋ hekɨlɨ daŋ uami. Nɨbu ala nadɨ ahɨliahua nadɨ huaci lama nasaŋ akuaba akuaba huaci huaci akape igubali uami. Nɨbu abɨci avɨli mɨgɨbali uami. Avɨli fɨli muji hɨnilalɨ agaŋ avi vubɨlɨm daŋ vubɨlɨm daŋ iahavɨbali uami. Nɨbu ala lɨci nadɨ hɨdɨlɨ agɨladɨ abinadinɨlu agɨlaŋ ninanadi akape huhɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Viaŋ iagana uami. Viaŋ nadɨ huaci lamin uami. Lɨlɨŋ akuaba akuaba huaci huaci vibanaŋ agɨlaŋ iaha habɨla halu hekɨlɨ hekɨlɨ agɨladɨ huva huva me hɨniavɨbali uami. Lavɨla akuaba akuaba iadɨ ave iauacaŋ vihavɨhadami agɨladɨ lɨvalavɨbali uami. Akuaba akuaba saŋ abin agɨlaŋ Josepɨ nadɨ hɨvɨ iahavɨbali uami. Nama iaha isagalina dɨ lɨvala hulaŋ hekɨlɨ hɨnibanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Bejamin nɨbu sudɨ iŋam hekɨlɨ sɨhɨm iavɨlalɨ me uami. Sudɨ iŋam agaŋ cimɨdaŋ cimɨdaŋ hɨvɨ sɨhɨm agɨladɨ iavaiava nɨlalɨ me hulaŋ iamɨgali agɨladɨ sɨbɨlɨ lamɨlalɨ uami. Hɨfɨlɨdaŋ hɨvɨ sɨhɨm akuaba akuaba vilalɨ agɨladɨ labɨlɨlalɨ hameŋ laci ala nɨbu avi akuaba akuaba vilalɨ agɨladɨ hulaŋ limu hɨhɨle agɨlasaŋ labɨlɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Iaganɨlu hɨmɨben aba ciaŋ nagadɨ ninadinu human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ agɨlasaŋ sulami. La nulɨdɨ hɨtɨŋ hɨtɨŋ huaci lamami. Lɨci nɨbɨlaŋ ala Isɨlaelɨ hɨdɨlɨ agɨladɨ iamɨlɨhalinɨlu hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Jekopɨ agaŋ ninadinu dɨ huaci lamɨci ci lɨci nulɨdɨ abami. Viaŋ amɨŋ ci hɨmɨben uami. Hɨmɨlɨŋ iadɨ amɨŋ agaŋ uavɨla iadɨ iamɨlɨhali dɨ amɨŋ hɨniavɨlalɨ heŋ hɨnibali uami. Viaŋ hɨmɨlɨŋ lɨba haca iadɨ iauacagali dɨ sudɨ savu hɨniavɨlalɨ heŋ vioua mava hudɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Lɨba haca agaŋ Mamɨle haiabɨla agadɨ mikɨ heŋ hɨnilalɨ uami. Mamɨle haiabɨla agaŋ Makɨpela fɨli tɨbɨ hɨnilalɨ uami. Makɨpela fɨli tɨbɨ ha Kenan fɨli tɨbɨ agadɨ limu tɨbɨ uami. Fɨli tɨbɨ hana Ebɨlam agaŋ Efɨlon saŋ anɨm hɨlɨcɨ iguavɨla fɨli tɨbɨ lɨba haca daŋ agadɨ vimi uami. Efɨlon nɨbu Hitɨ hɨdɨlɨ uami. Vici fɨli tɨbɨ sudɨ savu daŋ agaŋ nudɨ nukeŋ hɨnilalɨ uami. ");
INSERT INTO ena_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","32","Lɨba haca heŋ ala Ebɨlam tamaŋ dɨdaŋ Aisakɨ tamaŋ dɨdaŋ mava hudavɨmi uami. Lea dɨ avi lɨba haca Ebɨlam lavami heŋ ala mava hudamin uami. ");
INSERT INTO ena_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ani hɨsɨva hɨsɨva hɨsɨŋ vadɨm hɨvɨ mɨgahɨnihɨni ciaŋ abɨci ci lɨci nudɨ hɨcɨ magɨlɨci iahuci vadɨm heŋ ani hɨsɨvavɨla hɨmami. Hɨmɨci nudɨ amɨŋ agaŋ uavɨla nudɨ iamɨlɨhalinu dɨ amɨŋ hɨniavɨhadami heŋ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Lɨci Josepɨ agaŋ ua iaganu dɨ valɨ agadɨ mikɨ pɨŋ lɨfɨlɨbavɨla ilɨha ilɨha mɨhum iavami. ");
INSERT INTO ena_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Lavɨla nudɨ iaganu dɨ valɨ agaŋ sɨbɨlɨ lɨmɨdɨ uavɨla nudɨ sibɨla hɨsɨŋ hulaŋ hɨhɨle hulaŋ valɨ mɨŋahihɨlavɨhadami agɨladɨ abɨci sɨdaŋ ikupi hɨsi huaci huaci daŋ agɨladɨ viavɨla iaganu dɨ valɨ hɨvɨ lamalama mɨŋepɨhalavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Sibɨla agadɨ vivi hɨniavɨdaci uaiaŋ 38 umi. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ hameŋ lɨhavɨhadami sadaŋ Jekopɨ dɨ hameŋ laci ala lɨhavɨmi. La Jekopɨ saŋ ilɨha ilɨha hɨniavɨdaci uaiaŋ 68 umi. ");
INSERT INTO ena_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ilɨha ilɨha hɨniavɨci ci lɨci Josepɨ agaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ hɨji igu igu hɨsɨŋ hulaŋ agɨladɨ abami. Namɨlaŋ iasaŋ hɨjɨŋalavɨla ha uavɨla manɨgali agadɨ abɨhalaŋ uami. Josepɨ nameŋ abi aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Iadɨ iavaŋ hɨmɨben aba iadɨ vɨdɨvɨdɨŋ abɨci viaŋ ciaŋ mɨguavɨla nameŋ abacin aba abi aba abɨhalaŋ uami. Nama hɨmɨnaŋ viaŋ nadɨ valɨ agadɨ via uavɨla Kenan fɨli tɨbɨ lɨba haca nama nukeŋ mavamanaŋ heŋ hudɨben aba abacin aba abi aba abɨhalaŋ uami. Nama iadɨ alia aba abɨnaŋ viaŋ uavɨla iadɨ iavaŋ dɨ mavavɨla cɨhu veben aba abi aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Lɨci manɨgali igahɨlavɨla abami. Uavɨla nudɨ abɨhalaŋ uami. Nama ciaŋ mɨguavɨla abahanaŋ agadɨ lubiahɨlavɨla iagana dɨ valɨ agadɨ via ua mavɨha aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Lɨci Josepɨ agaŋ iaganu dɨ mavɨben aba umi. Hulaŋ akape nɨbu hula uavɨmi. Hɨhɨle Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ hɨji igu igu hɨsɨŋ hulaŋ agɨlaŋ. Hɨhɨle Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ hekɨlɨ hekɨlɨ agɨlaŋ. Hɨhɨle hulaŋ hekɨlɨ hekɨlɨ Josepɨ dɨ ulaŋ hɨvɨ sibɨla vihavɨhadami agɨlaŋ. ");
INSERT INTO ena_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","9","Hɨhɨle Josepɨ dɨ ulaŋ pam hɨsɨŋ agɨlaŋ. Hɨhɨle Josepɨ dɨ isaimahalinu agɨlaŋ. Hɨhɨle Josepɨ dɨ iaganu dɨ ulaŋ pam hɨsɨŋ agɨlaŋ. Hulaŋ iamɨgali akape sɨbaŋ hameŋ uavɨmi. Hɨhɨle sabaŋ osɨ magɨla magɨla hɨsɨŋ vadɨm hɨvɨ mɨgahɨnihɨni uavɨmi. Hɨhɨle sabaŋ osɨ sabɨ hɨvɨ mɨgahɨnihɨni uavɨmi. Hulemɨlɨ pam sabaŋ sipsipɨ sabaŋ bulɨmakau agɨlaŋ hula Gosen fɨli tɨbɨ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Uavɨla Atatɨ haiabɨla Jolɨdan avɨli agadɨ uaiaŋ iahaiaha kɨlikɨli heŋ iahuavɨmi. Halɨha cahu uitɨ hɨlɨcɨ ifɨcabɨlacabɨla sɨgɨtɨ havala havala hɨlɨcɨ vihavɨhadami agadɨ uvɨ heŋ iahuavɨmi. La nudɨ valɨ agadɨ haca hɨvɨ hudɨbalu aba ilɨhiŋ hekɨlɨ sɨbaŋ ilɨhavɨmi. La Josepɨ dɨ mavɨn lɨdaci ilɨha ilɨha hɨnidaci uaiaŋ human limu fɨhala umi. ");
INSERT INTO ena_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ilɨha ilɨha hɨniavɨdaci Kenan hɨdɨlɨ agɨlaŋ igavɨla abavɨmi. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ ilɨhiŋ hekɨlɨ sɨbaŋ ilɨhavadi uavɨmi. Lavɨla uvɨ agadɨ ibi lamavɨla abavɨmi. Abelɨmisɨlaim uavɨmi. Uvɨ agaŋ Jolɨdan avɨli agadɨ uaiaŋ iahaiaha kɨlikɨli heŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Jekopɨ ninadinu agɨlaŋ iaganɨlu dɨ ciaŋ agadɨ lubiahɨlavɨla hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Nudɨ valɨ agadɨ hava via ua Makɨpela fɨli tɨbɨ heŋ lɨba haca hɨvɨ hudavɨmi. Makɨpela fɨli tɨbɨ agaŋ Mamɨle haiabɨla mikɨ heŋ hɨniadami. Makɨpela fɨli tɨbɨ nɨbu Kenan fɨli tɨbɨ agadɨ limu tɨbɨ. Fɨli tɨbɨ ha Ebɨlam agaŋ Efɨlon saŋ anɨm hɨlɨcɨ iguavɨla fɨli tɨbɨ lɨba haca daŋ agadɨ vimi. Efɨlon nɨbu Hitɨ hɨdɨlɨ. Vici fɨli tɨbɨ sudɨ savu daŋ agaŋ nudɨ nukeŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Josepɨ agaŋ iaganu dɨ mava hudɨci isaimahalinu agɨlaŋ hula hulaŋ hɨhɨle uavɨmi agɨlaŋ hula Isipɨ fɨli tɨbɨ saŋ cɨhu vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Nulɨdɨ iaganɨlu agaŋ hɨmɨci Josepɨ dɨ isagalinu agɨlaŋ nameŋ abavɨmi. Josepɨ agaŋ alaŋ hula ciaŋ cɨhu cɨhu akua abɨbali uavɨmi. Vaka alaŋ nudɨ sɨbɨlɨ lamamɨlu agasaŋ igahɨlavɨla aludɨ sɨbɨlɨ lamɨbali akua uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Lavɨla sibɨla hɨsɨŋ hulaŋ mu agadɨ abavɨci uavɨla Josepɨ dɨ abami. Nadɨ isagalina nameŋ abavi uami. Aludɨ iavaŋ agaŋ hɨhi hɨniavɨla aludɨ ciaŋ vɨdɨvɨdɨŋ nameŋ abalɨ aba abavi uami. ");
INSERT INTO ena_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Namɨlaŋ uavɨla Josepɨ saŋ mavɨn ciaŋ ciaŋ abɨhalaŋ aba abalɨ aba abavi uami. Alaŋ nadɨ sɨbɨlɨ lamavɨla nama hula hugɨ daŋ hɨnilalu aba abɨhalaŋ aba abalɨ aba abavi uami. Aludɨ hugɨ agasaŋ igahɨlavɨla abɨha aba abɨhalaŋ aba abalɨ aba abavi uami. Viaŋ namɨlaŋ hula ciaŋ apalɨ aba abɨha aba abɨhalaŋ aba abalɨ aba abavi uami. Lavɨla abavi uami. Alaŋ nadɨ iagana dɨ Asɨ agadɨ sibɨla hɨsɨŋ aba abavi uami. Alaŋ nama hula hugɨ daŋ hɨnilu agasaŋ aludɨ abɨba abɨha aba abavi uami. Viaŋ namɨlaŋ hula ciaŋ apalɨ aba abɨben aba ha hameŋ laci ala abɨha aba abavi uami. Lɨci Josepɨ agaŋ ciaŋ agadɨ igahɨlavɨla ilɨhami. ");
INSERT INTO ena_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Lɨci Josepɨ dɨ isagalinu agɨlaŋ nudɨ igɨben aba uavɨmi. Uavɨla nudɨ mikɨ pɨŋ fɨli hɨvɨ sɨkasɨkan mɨgavɨla ipalavɨci mɨguavɨci ani valɨ hɨnihɨni abavɨmi. Alaŋ nadɨ sibɨla hɨsɨŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Lɨhavɨci Josepɨ nulɨdɨ abami. Namɨlaŋ iasaŋ lɨdɨmɨlaŋ uami. Viaŋ Asɨ me hɨma uami. Viaŋ naludɨ ciaŋ hɨvɨ ma lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Namɨlaŋ iadɨ sɨbɨlɨ lamalama saŋ akuaba akuaba lɨmalaŋ uami. Agadɨ ala Asɨ agaŋ hɨji nameŋ lamami uami. Hulaŋ iamɨgali agɨladɨ ahɨliahulɨŋ huaci hɨniavɨbali aba abami uami. Lavɨla aludɨ ahɨliahuci hulaŋ iamɨgali alaŋ habɨlavɨla akape hɨnilalu uami. ");
INSERT INTO ena_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Namɨlaŋ lɨdɨmɨlaŋ uami. Viaŋ naludɨdaŋ naludɨ ninanadinalu agɨladɨdaŋ sakɨlɨben uami. Lavɨla Josepɨ agaŋ ciaŋ huaci sɨbaŋ abɨci isagalinu agɨladɨ humɨgaŋ agɨlaŋ simɨ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josepɨ agaŋ nudɨ iaganu dɨ hɨdɨlɨ pam agɨlaŋ hula Isipɨ fɨli tɨbɨ hɨniavɨhadami. Hɨniavɨci hutesɨ lɨci Josepɨ dɨ hualɨ lugɨlavɨci ua 110 iahami. ");
INSERT INTO ena_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","La nudɨ ninanu Efɨlaim dɨ iamɨlɨhalinu dɨ igami. La cɨhu Manase dɨ ninanu Makilɨ dɨ ninaŋ iahɨci nudɨ avi viavɨla Josepɨ dɨ pɨŋ uavɨla nudɨ lagiŋ sabɨ hɨvɨ lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Lɨhavɨci Josepɨ agaŋ isaimahalinu agɨladɨ abami. Viaŋ amɨŋ ci hɨmɨben aba ladin uami. Asɨ agaŋ naludɨ migɨlɨbali uami. La naludɨ likɨla fɨli tɨbɨ nagadɨ valavɨla fɨli tɨbɨ mu hɨvɨ via ubali uami. Fɨli tɨbɨ agadɨ vaka hɨvɨ hekɨlɨ aba abavɨla Ebɨlam sadaŋ Aisakɨ sadaŋ igu igu saŋ abami uami. Jekopɨ saŋ avi fɨli tɨbɨ agadɨ ala igu igu saŋ abami uami. Igu igu saŋ abami heŋ ala naludɨ via ubali uami. ");
INSERT INTO ena_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","La Josepɨ agaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ ciaŋ vɨdɨvɨdɨŋ abami. Hɨvɨ hekɨlɨ aba abavɨla abɨhalaŋ uami. Asɨ vevɨla aludɨ likɨlavɨla uben aba lɨdaci Josepɨ dɨ henaŋ agɨladɨ viavɨla ubalu aba abɨhalaŋ uami. Hameŋ abɨci iahavɨla abavɨmi. Hɨvɨ hekɨlɨ uavɨmi. Alaŋ huaci viavɨla ubalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Lɨhavɨci Josepɨ dɨ hualɨ lugɨlavɨci ua 110 iahɨci heŋ hɨmami. Hɨmɨci nudɨ valɨ agaŋ sɨbɨlɨ lɨmɨdɨ uavɨla sɨdaŋ ikupi hɨsi huaci huaci daŋ agɨladɨ viavɨla nudɨ valɨ agadɨ hɨvɨ lamalama mɨŋepɨhalavɨmi. Lavɨla valɨ agadɨ via hɨbɨn hɨbɨn hɨvɨ lamavɨci mɨguci Isipɨ fɨli tɨbɨ heŋ lamavɨci hɨniadami.");
INSERT INTO ena_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","5","Josepɨ agaŋ hali uavɨla Isipɨ fɨli tɨbɨ hɨniadami. Hɨnidaci Jekopɨ agaŋ nudɨ ninadinu limu hɨhɨle agɨlaŋ hula Isipɨ fɨli tɨbɨ uavɨmi. Nulɨdɨ abinadinɨlu ninanadinɨlu hudɨmɨda hameŋ uavɨmi. Hulaŋ uavɨmi agɨladɨ ibi nameŋ. Mu Luben. Mu Simeon. Mu Livai. Mu Juda. Mu Isakalɨ. Mu Sebulun. Mu Bejamin. Mu Dan. Mu Napɨtali. Mu Gatɨ. Mu Aselɨ. Hulaŋ iamɨgali agɨladɨ lugɨlavɨci ua 70 iahami. ");
INSERT INTO ena_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Josepɨ agaŋ nudɨ isaimahalinu agɨlaŋ hula haba hɨma fɨhalavɨmi. Lɨhavɨci nudɨ sa me agɨlaŋ avi sɨkasɨkan haba hɨma fɨhalavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Agadɨ ala Isɨlaelɨ hɨdɨlɨ hulaŋ iamɨgali mɨnibɨlɨ agɨlaŋ hɨnihɨni ninanadi akape havavɨmi. La heŋ hɨnia habɨla Isipɨ fɨli tɨbɨ agadɨ haiabɨla mu hɨvɨ mu hɨvɨ hɨniavɨhadami. Lɨdɨŋ nɨbɨlaŋ vɨdɨvɨdɨŋ hekɨlɨ daŋ hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Hɨniavɨdaci cɨhu manɨgali mu agaŋ Isipɨ fɨli tɨbɨ agadɨ migɨladami. Nɨbu vaka Josepɨ Isipɨ fɨli tɨbɨ migɨladami agadɨ ciaŋ ma igahɨlami. ");
INSERT INTO ena_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Lavɨla manɨgali agaŋ nudɨ hulaŋ iamɨgali agɨladɨ abami. Ci igɨlaŋ uami. Hulaŋ iamɨgali Isɨlaelɨ hɨdɨlɨ agɨlaŋ akape uami. Nulɨdɨ vɨdɨvɨdɨŋ agaŋ aludɨ vɨdɨvɨdɨŋ agadɨ lɨvali uami. ");
INSERT INTO ena_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Hulaŋ hɨhɨle agɨlaŋ vehavɨci sagaŋ iahɨci uami. Ha Isɨlaelɨ hɨdɨlɨ alaŋ hula hɨniavɨlalɨ agɨlaŋ iaha nɨbɨlaŋ hula hafalavɨla aludɨ ifɨlalɨfavɨbali uami. La sagaŋ lɨbavɨla aludɨ fɨli tɨbɨ nagadɨ valavɨla uavɨbali uami. Alaŋ akɨ me lɨmɨli Isɨlaelɨ hɨdɨlɨ agɨlaŋ ma iaha habɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Hameŋ abavɨla nudɨ hulaŋ iamɨgali agɨlaŋ hula abavɨdaci hulaŋ hɨmamɨgɨlɨ daŋ agɨlaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ migɨlavɨhadami. Migɨlavɨdaci sibɨla hekɨlɨ hekɨlɨ vivi vɨhɨlɨfavɨhadami. Lɨhavɨdaci Isɨlaelɨ hɨdɨlɨ agɨladɨ abavɨci haiabɨla hekɨlɨ hekɨlɨ hɨhi ahica agɨladɨ viavɨla hɨniavɨmi. Haiabɨla ibi mu Pitom. Mu Lamesesɨ. Haiabɨla hekɨlɨ hekɨlɨ ahica hana manɨgali dɨ halɨha cahu uitɨ hɨlɨcɨ akuaba akuaba mɨgudɨbalɨba hɨsɨŋ haiabɨla. ");
INSERT INTO ena_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Hulaŋ iamɨgali Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ Isɨlaelɨ hɨdɨlɨ agɨlasaŋ sibɨla hekɨlɨ hekɨlɨ iguavɨhadami. Agadɨ ala Isɨlaelɨ hɨdɨlɨ agɨlaŋ hulaŋ iamɨgali akape iahaiaha habɨlavɨhadami. Habɨla habɨla Isipɨ fɨli tɨbɨ agadɨ haiabɨla mu hɨvɨ mu hɨvɨ hɨniavɨhadami. Lɨhavɨdaci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ Isɨlaelɨ hɨdɨlɨ agɨlasaŋ lɨdavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Lɨdɨŋ Isɨlaelɨ hɨdɨlɨ agɨlasaŋ sibɨla hekɨlɨ hekɨlɨ iguavɨdaci vihavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Hulaŋ iamɨgali Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ Isɨlaelɨ hɨdɨlɨ agɨlaŋ hula huaci ma hɨniavɨhadami. Sɨbɨlɨ hɨniavɨhadami. Lɨdɨŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ lɨhavɨdaci hulaŋ iamɨgali Isɨlaelɨ hɨdɨlɨ agɨlaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ lɨba ulaŋ hafiavɨhadami. Nulɨdɨ hualɨ sibɨla agɨladɨ avi vihavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Lɨhavɨdaci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ Sifɨla saŋ Pua saŋ ciaŋ abɨci uci igahɨlavɨla nudɨ pɨŋ vehavɨmi. Iamɨgali ahica agɨlaŋ Isɨlaelɨ hɨdɨlɨ iamɨgali agɨladɨ ahɨliahuavɨhadami. Ahɨliahuiahu hulɨ laguavɨhadami. Isɨlaelɨ hɨdɨlɨ agɨladɨ ciaŋ sɨbaŋ nɨbu Ibɨlu ciaŋ. ");
INSERT INTO ena_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Vehavɨci manɨgali agaŋ iamɨgali ahica agɨladɨ abami. Namɨlaŋ igɨlaŋ iamɨgali mu Ibɨlu ciaŋ hɨsɨŋ agaŋ ninanadi huhɨlɨben aba mɨgahɨnidaci uavɨla migɨlɨhalaŋ uami. Migɨlavɨla igɨlaŋ ninaŋ huhɨlɨci ha ninaŋ agadɨ ifɨhɨmɨhalaŋ uami. Igɨlaŋ nadi huhɨlɨci ha valɨlaŋ hɨhi hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Lɨci iamɨgali ahica agɨlaŋ Asɨ saŋ lɨdavɨla manɨgali agadɨ ciaŋ ma lubiahɨlavɨmi. La ninaŋ agɨladɨ valavɨdaci hɨhi hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Lɨhavɨci manɨgali agaŋ iamɨgali ahica agɨladɨ abɨci vehavɨci nulɨdɨ abami. Akɨ saŋ ninaŋ agɨladɨ valɨdalaŋ hɨhi hɨniavadi uami. ");
INSERT INTO ena_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Lɨci iamɨgali ahica agɨlaŋ nudɨ abavɨmi. Iamɨgali Ibɨlu ciaŋ hɨsɨŋ agɨlaŋ iamɨgali Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ me hɨma uavɨmi. Nɨbɨlaŋ iamɨgali ninanadi huhɨla huhɨla saŋ vɨdɨvɨdɨŋ daŋ sadaŋ ninanadi lɨhalɨha huhɨlavɨhehavɨlalɨ uavɨmi. Lɨhavɨdaci hulɨ lagulagu hɨsɨŋ alaŋ sɨvɨ sɨbaŋ uu iahulalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Iamɨgali ahica agɨlaŋ Asɨ saŋ lɨdavɨci Asɨ nulɨdɨ huaci lamɨdaci ninanadi daŋ hɨniavɨhadami. Lɨhavɨdaci Isɨlaelɨ hɨdɨlɨ agɨlaŋ ninanadi huhɨla huhɨla iaha habɨlavɨmi. Habɨla hɨdɨlɨ hekɨlɨ vɨdɨvɨdɨŋ daŋ hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Lɨhavɨdaci manɨgali agaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ iamɨgali agɨladɨ abami. Hulaŋ iamɨgali Ibɨlu ciaŋ hɨsɨŋ agɨladɨ ninaŋ mumɨŋ agɨladɨ vivi Nailɨ avɨli hɨvɨ havalɨdalaŋ mɨguavɨm uami. Lɨdɨŋ nadi mumɨŋ agɨladɨ pam valɨdalaŋ hɨhi hɨniavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Hameŋ lɨhavɨdaci hulaŋ mu Livai hɨdɨlɨ agaŋ iamɨgali mu Livai hɨdɨlɨ agadɨ sabimi. ");
INSERT INTO ena_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","3","Lɨci iamɨgali sabimi agaŋ cɨhu humɨgaŋ ahɨlavɨla ninaŋ mu huhɨlami. Huhɨlavɨla igɨci ninaŋ agaŋ huaci sɨbaŋ hɨnimi. Lɨci ninaŋ agadɨ uleŋ muji hɨvɨ sɨvɨlalɨbɨci hɨnimi. Sɨvɨlalɨbɨci hɨnidaci avaŋ ahica pam uci ninaŋ agaŋ hekɨlɨ lɨmi. Lɨci akɨ hɨvɨ sɨvɨlalɨbɨben uavɨla suhan asɨŋ agɨladɨ viavɨla cinacina mɨŋami. Cinacina agadɨ fɨhala igɨci fɨlu fɨlu akape hɨniavɨmi. Lɨci fɨli mɨlɨm daŋ agadɨ viavɨla fɨlu fɨlu agɨladɨ lamasɨjisɨji umi. Lamasɨjia fɨhalavɨla ninaŋ agadɨ cinacina muji heŋ mɨŋamɨgua lamɨci ani hɨsɨvami. Hɨsɨvɨdaci sɨvɨlalɨbɨben aba avɨli caba heŋ via uavɨla suhan lɨkɨla lɨkɨla heŋ avɨli sabɨ hɨvɨ lamɨci vuhala iahavɨla uu veve hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Hameŋ hɨnidaci ninaŋ agadɨ nadinu humɨgaŋ pam agaŋ ataŋ tagɨlaŋ daŋ lagulamavɨla hɨnimi. La nɨbu akuaba akuaba iahɨben aba lɨhavɨmi agasaŋ lagulama migɨla migɨla hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Lagulama hɨnia igɨci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali dɨ nadi agaŋ nudɨ sibɨla hɨsɨŋ iamɨgali agɨlaŋ hula avɨli sɨsɨ saŋ vehavɨmi. La sibɨla hɨsɨŋ iamɨgali agɨlaŋ avɨli caba caba hɨvɨ mɨgomɨgo ilo ilo hɨdavɨdaci manɨgali dɨ nadi agaŋ avɨli sɨsɨ hɨnimi. Avɨli sɨsɨ hɨnia igoua igɨci cinacina agaŋ suhan lɨkɨla lɨkɨla heŋ hɨnimi. Lɨci sibɨla hɨsɨŋ iamɨgali mu agadɨ abɨci uavɨla cinacina agadɨ viavɨla vavemi. ");
INSERT INTO ena_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Vaveci manɨgali dɨ nadi agaŋ cinacina agadɨ mɨŋalavɨla igamɨgua igɨci ninaŋ agaŋ ilɨhami. Lɨci manɨgali dɨ nadi agaŋ nusaŋ mavɨn hekɨlɨ hɨnimi. Lavɨla abami. Ninaŋ nagaŋ Ibɨlu ciaŋ hɨsɨŋ agɨladɨ ninaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Lɨci ninaŋ agadɨ nadinu humɨgaŋ pam agaŋ vevɨla manɨgali dɨ nadi agadɨ abitɨhami. Viaŋ huaci uavɨla iamɨgali mu Ibɨlu ciaŋ hɨsɨŋ agadɨ abɨlɨŋ vevi uami. Vevɨla amaŋ iguci nana hɨnidaci nasaŋ sakɨlɨvi uami. ");
INSERT INTO ena_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Lɨci manɨgali dɨ nadi agaŋ abami. Alia uami. Nama nukeŋ abɨnaŋ hameŋ ala lɨha uami. Lɨci ninaŋ agadɨ nadinu agaŋ uavɨla iamɨnu dɨ abɨci vemi. ");
INSERT INTO ena_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Veci manɨgali dɨ nadi agaŋ nudɨ abami. Ninaŋ nagadɨ viavɨla amaŋ igunana sɨhɨvia sɨbaŋ sakɨlɨha uami. Hameŋ lɨnaŋ viaŋ nasaŋ anɨm hɨlɨcɨ iguben uami. Lɨci iamɨgali agaŋ ninaŋ agadɨ viavɨla amaŋ igunana sɨhɨvia sɨbaŋ sakɨladami. ");
INSERT INTO ena_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Lɨdaci ninaŋ agaŋ hekɨlɨ tagɨlaŋ daŋ lɨci iamɨnu agaŋ viouavɨla manɨgali agadɨ nadi agasaŋ igumi. Manɨgali agadɨ nadi agaŋ sakɨlɨci hekɨlɨ lɨci igɨci nudɨ nukeŋ me sɨbaŋ hɨnimi. Lɨci abami. Ninaŋ nagaŋ avɨli sabɨ hɨvɨ vuhala iaha hɨnici viavɨla iahacin uami. Hameŋ sadaŋ viaŋ nudɨ ibi lamavɨla abɨben uami. Mosesɨ aba abɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Isɨlaelɨ hɨdɨlɨ agɨlaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ sibɨla vivi vɨhɨlɨfulɨfu hɨniavɨhadami. Lɨhavɨdaci Mosesɨ agaŋ hulaŋ hekɨlɨ lavɨla nudɨ hɨdɨlɨ pam Ibɨlu ciaŋ hɨsɨŋ agɨladɨ igɨben aba umi. Uavɨla igɨci hulaŋ mu Isipɨ fɨli tɨbɨ hɨsɨŋ agaŋ hulaŋ mu Ibɨlu ciaŋ hɨsɨŋ agadɨ sɨbɨlɨ lamalama nudɨ ifu ifu hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Lɨdaci lagulama igoua igave igɨci hulaŋ mu avi ma hɨniavɨmi. Lɨhavɨci Mosesɨ agaŋ hulaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agadɨ valɨ ifɨhɨmavɨla hacɨŋ mavavɨla lamɨci mɨguci lɨhalɨha sɨbaŋ ibɨlalami. ");
INSERT INTO ena_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","La hɨnici mɨŋalahɨci uavɨla igɨci hulaŋ ahica Ibɨlu ciaŋ hɨsɨŋ agɨlaŋ sagaŋ lɨbalɨba hɨniavɨmi. Lɨhavɨdaci Mosesɨ agaŋ hulaŋ hɨdɨlɨ maha sagaŋ saŋ lɨmi agadɨ abami. Nama akɨ saŋ nadɨ hɨdɨlɨ pam agadɨ ifadanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Lɨci hulaŋ agaŋ Mosesɨ dɨ cɨhu hɨbɨŋ abami. Nadɨ ani lɨbɨmɨŋɨci aludɨ manɨgali hɨnidanaŋ uami. La ciaŋ hihɨla hihɨla hɨsɨŋ me hɨniavɨla aludɨ sagaŋ agadɨ alimɨŋɨben aba lɨdanaŋ uami. Nama iadɨ ifɨhɨmɨben aba lɨdanaŋ uami. Amɨli nama hulaŋ mu Isipɨ fɨli tɨbɨ hɨsɨŋ agadɨ ifɨhɨmɨmalamɨnaŋ hameŋ ala iadɨ avi ifɨhɨmɨben aba lɨdanaŋ uami. Lɨci Mosesɨ agaŋ ciaŋ agadɨ igahɨlavɨla lɨdami. La hɨji nameŋ igahɨlami. Hulaŋ iamɨgali agɨlaŋ viaŋ hulaŋ mu ifɨhɨmɨmalamin agadɨ ciaŋ hɨjɨ ci akua igahɨlavi uami. ");
INSERT INTO ena_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","La hɨnidaci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ Mosesɨ dɨ ciaŋ hɨjɨ igahɨlavɨla nudɨ ifɨhɨmɨben aba lɨmi. Lɨci Mosesɨ agaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agasaŋ lɨdavɨla haŋɨlavɨla Midian fɨli tɨbɨ umi. Ua iahua avɨli sɨmɨ tulɨ caba heŋ mɨgahɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Asɨ saŋ sagalɨ igu igu hɨsɨŋ hulaŋ mu agaŋ fɨli tɨbɨ heŋ ala hɨniadami. Nudɨ ibi Jetɨlo. Nudɨ nanadinu human limu fɨhala human limu ahica cɨjɨŋ agɨladɨ via hɨniadami. Mosesɨ agaŋ uavɨla nulɨdɨ avɨli sɨmɨ tulɨ mikɨ heŋ mɨgahɨnidaci Jetɨlo dɨ nanadinu agɨlaŋ vehavɨmi. Vevɨla avɨli licilici lɨba hɨbɨn hɨbɨn hɨniavɨhadami agɨladɨ hɨvɨ mɨŋamɨjiavɨdaci mɨguavɨmi. Iaganɨlu dɨ sabaŋ sipsipɨ sabaŋ meme agɨlasaŋ igunɨbalu aba liciavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Liciavɨdaci hulaŋ sabaŋ sipsipɨ migɨla migɨla hɨsɨŋ limu hɨhɨle agɨlaŋ nulɨdɨ sabaŋ sipsipɨ agɨlasaŋ avɨli igunɨbalu aba vevɨla iamɨgali agɨladɨ lahuavɨmi. Lahuavɨdaci Mosesɨ agaŋ iamɨgali agɨladɨ ahɨliahuavɨla hulaŋ agɨladɨ lahumi. Lahuci uavɨdaci iamɨgali agɨladɨ ahɨliahuavɨla nulɨdɨ sabaŋ sipsipɨ sabaŋ meme agɨlasaŋ avɨli igunami. ");
INSERT INTO ena_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Igunɨci ci lɨci iamɨgali agɨlaŋ iaganɨlu dɨ pɨŋ cɨhu ala uavɨmi. Uavɨci iaganɨlu agaŋ nulɨdɨ abitɨhami. Akɨ lavɨla lɨhalɨha vevɨhelaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Lɨci nudɨ abavɨmi. Eke uavɨmi. Hulaŋ mu Isipɨ fɨli tɨbɨ hɨsɨŋ agaŋ aludɨ ahɨliahuavɨla hulaŋ sabaŋ sipsipɨ migɨla migɨla hɨsɨŋ limu hɨhɨle agɨladɨ lahuiemi uavɨmi. La aludɨ ahɨliahuavɨla sabaŋ sipsipɨ sabaŋ meme agɨlasaŋ avɨli licilici igudaci naviemi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Hameŋ abavɨci Jetɨlo agaŋ nudɨ nanadinu agɨladɨ abitɨhami. Hulaŋ agaŋ abeŋ hɨnidi uami. Nudɨ akɨ saŋ igo heŋ vala velaŋ uami. Uavɨla nudɨ abɨlaŋ vevɨla alaŋ hula sɨmɨŋ nam uami. Lɨci hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Abavɨci ve hɨnidaci Jetɨlo agaŋ nudɨ sɨkan hɨnihɨni saŋ abɨci Mosesɨ agaŋ abami. Alia uami. La hɨnici Jetɨlo agaŋ nudɨ nadi mu Sipola dɨ Mosesɨ saŋ iguci sabimi. ");
INSERT INTO ena_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sabia hɨnidaci Sipola agaŋ humɨgaŋ ahɨlavɨla ninaŋ huhɨlami. Ninaŋ huhɨlami agasaŋ igahɨlavɨla Mosesɨ agaŋ hɨji lamavɨla abami. Viaŋ hulaŋ ihɨlɨŋ vevɨla neŋ hɨniadamin uami. Hameŋ sadaŋ viaŋ ninaŋ nagadɨ ibi lamavɨla abɨben uami. Gelɨsom aba abɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","La hɨnidaci hualɨ akape uci Isipɨ fɨli tɨbɨ hɨsɨŋ manɨgali agaŋ hɨmami. Hɨmɨci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ lɨhavɨdaci Isɨlaelɨ hɨdɨlɨ agɨlaŋ sibɨla hekɨlɨ hekɨlɨ vivi avɨha avɨha iga iga alu sɨbɨlɨ havalavɨhadami. Lɨdɨŋ Asɨ nulɨdɨ ahɨliahuiahu saŋ ilɨha ilɨha ula ula aba aba hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ilɨha ilɨha ula ula aba aba hɨniavɨdaci Asɨ agaŋ igahɨlami. Igahɨlavɨla ciaŋ mɨguavɨla Ebɨlam dɨdaŋ Aisakɨ dɨdaŋ abami agasaŋ hɨji lamami. Jekopɨ dɨ abami agasaŋ avi hɨji lamami. ");
INSERT INTO ena_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Lavɨla hulaŋ iamɨgali Isɨlaelɨ hɨdɨlɨ agɨlaŋ vɨhɨlɨ igavɨmi agasaŋ igahɨlavɨla nulɨsaŋ mavɨn hɨniavɨla nulɨdɨ ahɨliahuiahu saŋ hɨji lamami. ");
INSERT INTO ena_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mosesɨ agaŋ nudɨ abiaganu Jetɨlo dɨ sabaŋ sipsipɨ sabaŋ meme agɨladɨ migɨladami. Jetɨlo nɨbu Asɨ saŋ sagalɨ igu igu hɨsɨŋ hulaŋ hɨniadami. Nɨbu Midian fɨli tɨbɨ hɨniadami. Mu tɨbɨ Mosesɨ agaŋ sabaŋ sipsipɨ sabaŋ meme agɨladɨ likɨla lɨhumagɨla uavɨla fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ agadɨ lɨvalavɨla Sainai halu ua iahumi. Asɨ agaŋ Sainai halu heŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Mosesɨ ua iahua igɨci avɨŋ agaŋ kɨlɨ cɨki mu agadɨ hɨvɨ lɨhulɨhu hɨnimi. Lɨhulɨhu hɨnidaci Asɨ Iaue dɨ ciaŋ hali hɨsɨŋ agaŋ avɨŋ mila alɨhaŋ alɨhaŋ heŋ iahami. Avɨŋ agaŋ kɨlɨ cɨki agadɨ hɨvɨ lɨhulɨhu hɨnimi. Agadɨ ala kɨlɨ cɨki agadɨ asɨŋ asɨŋ makaŋ makaŋ agɨlaŋ ma lɨhulɨfavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Lɨhavɨci Mosesɨ agaŋ hɨji cuvɨlɨŋ cuvɨlɨŋ igahɨlahɨla hɨniavɨla abami. Akɨ lɨci kɨlɨ cɨki agadɨ asɨŋ asɨŋ makaŋ makaŋ agɨlaŋ amɨŋ ma lɨhulɨfavɨla mɨgalahɨlavi uami. Vana viaŋ mikɨ uavɨla igɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","La igɨben aba uavɨla kɨlɨ cɨki agadɨ mikɨ mikɨ lɨdaci Asɨ Iaue agaŋ avɨŋ lɨhulɨhu hɨnimi heŋ hɨniavɨla nudɨ abami. Mosesɨ uami. Lɨci Mosesɨ abami. Viaŋ nan hɨnidin uami. ");
INSERT INTO ena_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Lɨci Asɨ nudɨ abami. Nama iadɨ mikɨ pɨŋ vemɨnaŋ uami. Fɨli lagulama hɨnidanaŋ hana iadɨ nukeŋ sɨbaŋ uami. Hameŋ sadaŋ nama nadɨ hɨcɨ sɨgɨtɨ agɨladɨ mɨŋahubɨlɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Viaŋ nadɨ iamɨlɨhalina Ebɨlam dɨ Aisakɨ dɨ Jekopɨ dɨ Asɨ uami. Lɨci Mosesɨ agaŋ ciaŋ agadɨ igahɨlavɨla lɨdami. Lɨdavɨla Asɨ dɨ igɨmagaŋ uavɨla nudɨ mugaŋ lamɨgaŋ hafilɨbami. ");
INSERT INTO ena_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Lɨci Asɨ Iaue agaŋ nudɨ abami. Iadɨ hulaŋ iamɨgali agɨlaŋ Isipɨ fɨli tɨbɨ hɨnihɨni avɨha avɨha iga iga hɨniavɨlalɨ agɨladɨ ci igɨlan uami. Vɨhɨlɨ mu mu igavɨlalɨ agɨladɨ ci igɨlan uami. Hɨmamɨgɨlɨ daŋ agɨlaŋ nulɨdɨ sɨbɨlɨ lamavɨdaci nɨbɨlaŋ vɨhɨlɨ iga iga agalavɨlalɨ agɨladɨ avi ci igahɨlɨlan uami. ");
INSERT INTO ena_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Hameŋ sadaŋ viaŋ mɨguavɨla Isɨlaelɨ hɨdɨlɨ Isipɨ fɨli tɨbɨ hɨniavɨlalɨ agɨladɨ ahɨliahuben uami. La nulɨdɨ likɨla via uavɨla fɨli tɨbɨ hekɨlɨ huaci sɨbaŋ heŋ lamɨlɨŋ hɨniavɨbali uami. Fɨli tɨbɨ heŋ sɨmɨŋ isabɨlaŋ huliavɨdaci huaci laci iahavɨbali uami. Kenan hɨdɨlɨ Hitɨ hɨdɨlɨ Amolɨ hɨdɨlɨ Pelesɨ hɨdɨlɨ Hivɨ hɨdɨlɨ Jebusɨ hɨdɨlɨ agɨladɨ fɨli tɨbɨ heŋ uavɨla hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ iadɨ hulaŋ iamɨgali agɨladɨ sɨbɨlɨ lamavɨlalɨ agɨladɨ ci igɨlan uami. Nɨbɨlaŋ vɨhɨlɨ iga iga agalavɨlalɨ agɨladɨ ci igahɨlɨlan uami. ");
INSERT INTO ena_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Hameŋ abavɨla cɨhu Mosesɨ dɨ abami. Nama Isipɨ fɨli tɨbɨ cɨhu uha uami. Uavɨla Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ igɨha uami. Lɨnaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ iadɨ hulaŋ iamɨgali Isɨlaelɨ hɨdɨlɨ agɨladɨ valɨci likɨla viavɨla Isipɨ fɨli tɨbɨ agadɨ valavɨla vehalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Lɨci Mosesɨ agaŋ Asɨ dɨ abami. Viaŋ ibi apalɨ uami. Viaŋ hulaŋ ibi daŋ lɨci ha huaci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ pɨŋ uavɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ likɨla viavɨla vevin uami. ");
INSERT INTO ena_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Lɨci Asɨ nudɨ abami. Viaŋ nama hula hɨniben uami. Nama hula hɨnidalɨŋ Isipɨ fɨli tɨbɨ uavɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ likɨla vavenaŋ halu neŋ hɨnihɨni iadɨ ibi mɨŋaiahaiaha hɨniavɨbali uami. Iadɨ ibi mɨŋaiahaiaha hɨniavɨdaci iga iga abɨbanaŋ uami. Ha Asɨ nukeŋ abɨci nulɨdɨ likɨla vavecin aba abɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Lɨci Mosesɨ agaŋ Asɨ dɨ abami. Viaŋ uavɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ nameŋ abɨben uami. Aludɨ iamɨlɨhali agɨladɨ Asɨ agaŋ abɨci naludɨ pɨŋ ven aba abɨben uami. Lɨlɨŋ nɨbɨlaŋ iadɨ nameŋ abitɨhavɨbali uami. Nudɨ ibi ani aba abavɨbali uami. Lɨhavɨci viaŋ cɨhu nulɨdɨ akɨ me abɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Lɨci Asɨ agaŋ abami. Viaŋ nukeŋ hameŋ laci hameŋ laci hɨniadamin hɨnilan uami. Nama Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨha uami. Asɨ dɨ ibi ha nɨbu nukeŋ hameŋ laci hameŋ laci hɨniadami hɨnilalɨ aba abɨha uami. Nɨbu ala iadɨ abɨci naludɨ pɨŋ ven aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Mosesɨ uami. Nama hulaŋ iamɨgali Isɨlaelɨ hɨdɨlɨ agɨladɨ nameŋ abɨha uami. Naludɨ iamɨlɨhalinalu Ebɨlam dɨ Aisakɨ dɨ Jekopɨ dɨ Asɨ Iaue agaŋ iadɨ abɨci ven aba abɨha uami. Asɨ Iaue dɨ ibi ha nɨbu hameŋ laci hameŋ laci hɨniadami hɨnilalɨ aba abɨha uami. Lɨnaŋ iamɨlɨhalina mufɨli mufɨli iahavɨbali agɨlaŋ avi iadɨ ibi hameŋ laci luvɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Hameŋ sadaŋ nama uavɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ hulaŋ hekɨlɨ hekɨlɨ agɨladɨ mɨgudɨbavɨla nameŋ abɨha uami. Asɨ Iaue agaŋ nɨbu naludɨ iamɨlɨhalinalu Ebɨlam dɨ Aisakɨ dɨ Jekopɨ dɨ Asɨ aba abɨha uami. Nɨbu ala iadɨ pɨŋ iahavɨla abi aba abɨha uami. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ iadɨ hulaŋ iamɨgali agɨladɨ sɨbɨlɨ lamavɨlalɨ agadɨ ci igɨlan aba abi aba abɨha uami. Viaŋ nulɨsaŋ igahɨladin aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Viaŋ nadɨ amɨŋ abin aba abi aba abɨha uami. Viaŋ mɨguavɨla Isɨlaelɨ hɨdɨlɨ Isipɨ fɨli tɨbɨ hɨnihɨni vɨhɨlɨ igavɨlalɨ agɨladɨ ahɨliahuben aba abi aba abɨha uami. La nulɨdɨ likɨla via uavɨla fɨli tɨbɨ huaci sɨbaŋ heŋ lamɨlɨŋ hɨniavɨbali aba abi aba abɨha uami. Fɨli tɨbɨ heŋ sɨmɨŋ isabɨlaŋ huliavɨdaci huaci laci iahavɨbali aba abi aba abɨha uami. Nɨbɨlaŋ sɨmɨŋ isabɨlaŋ hulihuli Kenan hɨdɨlɨ Hitɨ hɨdɨlɨ Amolɨ hɨdɨlɨ Pelesɨ hɨdɨlɨ Hivɨ hɨdɨlɨ Jebusɨ hɨdɨlɨ agɨladɨ fɨli tɨbɨ heŋ hɨniavɨbali aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Isɨlaelɨ hɨdɨlɨ agɨladɨ hameŋ abɨnaŋ igahɨlavɨla nadɨ sɨvɨ uavɨbali uami. Uavɨci nama Isɨlaelɨ hɨdɨlɨ agɨladɨ hulaŋ hekɨlɨ hekɨlɨ agɨladɨ likɨla viavɨla Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ pɨŋ uhalaŋ uami. Uavɨla nudɨ nameŋ abɨha uami. Ibɨlu ciaŋ hɨsɨŋ aludɨ Asɨ Iaue agaŋ aludɨ pɨŋ iahalɨ aba abɨha uami. Nama aludɨ huaci valɨnaŋ fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ ubalu aba abɨha uami. Uavɨla anihuliŋ me hɨvɨ Asɨ saŋ sagalɨ hɨlahɨla igubalu aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Hameŋ abɨbanaŋ ala viaŋ nudɨ ci igin uami. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ naludɨ ma valɨci ubalaŋ uami. Agadɨ ala viaŋ nudɨ sɨbɨlɨ lamɨlɨŋ naludɨ valɨci ubalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Viaŋ Isipɨ fɨli tɨbɨ heŋ vɨdɨvɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ abalamɨben uami. Lɨdɨŋ iadɨ vɨdɨvɨdɨŋ hɨvɨ nulɨdɨ sɨbɨlɨ lamɨben uami. Lɨlɨŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ naludɨ valɨci ubalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Viaŋ lɨlɨŋ hulaŋ iamɨgali Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ naludɨ huaci igavɨla nalusaŋ akuaba akuaba igu igu saŋ mavɨn hɨniavɨbali uami. Lɨhavɨci akuaba akuaba apalɨ ma ubalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Naludɨ abinadinalu agɨlaŋ uavɨla Isipɨ fɨli tɨbɨ hɨsɨŋ iamɨgali naludɨ ulaŋ hɨvɨ hɨsɨvavɨlalɨ agɨladɨdaŋ naludɨ ulaŋ mikɨ hɨniavɨlalɨ agɨladɨdaŋ abitɨhavɨm uami. Abitɨhavɨci nɨbɨlaŋ muhɨlɨ havɨlɨ agɨladɨdaŋ hunaŋ lɨba golɨ lɨba silɨva hɨvɨ vihavɨmi agɨladɨdaŋ nalusaŋ iguavɨbali uami. Iguavɨci naludɨ ninanadinalu agɨlasaŋ igulaŋ vihavɨci ahuata hameŋ uhalaŋ uami. Hameŋ lavɨla ha namɨlaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ akuaba akuaba sɨkasɨkan vibalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Lɨci Mosesɨ Asɨ Iaue dɨ abami. Hulaŋ iamɨgali Isɨlaelɨ hɨdɨlɨ agɨlaŋ iadɨ ciaŋ agasaŋ hɨji vɨdɨvɨdɨŋ ma lamavɨbali uami. Ciaŋ viaŋ abɨben agadɨ avi ma igahɨlavɨbali uami. Lavɨla iadɨ nameŋ abavɨbali uami. Asɨ Iaue nadɨ pɨŋ ma iahalɨ aba abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Lɨci Asɨ Iaue Mosesɨ dɨ abitɨhami. Nama akɨ mɨŋalɨva hɨnidanaŋ uami. Lɨci abami. Viaŋ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agadɨ mɨŋalɨva hɨnidin uami. ");
INSERT INTO ena_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Lɨci abami. Kɨlɨ lɨmɨ agadɨ fɨli hɨvɨ havalɨnaŋ mɨgam uami. Lɨci Mosesɨ kɨlɨ lɨmɨ agadɨ fɨli havalɨci mɨgami. Havalɨci mɨgavɨla lahu lɨfami. Lɨci Mosesɨ agaŋ nudɨ iga lɨdavɨla haŋɨlami. ");
INSERT INTO ena_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Haŋɨlɨci Asɨ Iaue Mosesɨ dɨ abami. Eke uami. Lahu liji heŋ mɨŋalɨvɨha uami. Lɨci Mosesɨ lahu agadɨ liji heŋ vɨdɨvɨdɨŋ mɨŋalɨvami. Mɨŋalɨvɨci lahu agaŋ cɨhu kɨlɨ lɨmɨ lɨfami. ");
INSERT INTO ena_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Lɨci Asɨ Iaue nudɨ abami. Nama Isɨlaelɨ hɨdɨlɨ agɨladɨ pɨŋ uavɨla hameŋ lɨnaŋ nadɨ ciaŋ agasaŋ hɨji vɨdɨvɨdɨŋ lamavɨla nameŋ abavɨbali uami. Amɨŋ ala aba abavɨbali uami. Asɨ Iaue nudɨ pɨŋ iahalɨ aba abavɨbali uami. Aludɨ iamɨlɨhali Ebɨlam dɨ Aisakɨ dɨ Jekopɨ dɨ Asɨ agaŋ nudɨ pɨŋ iahalɨ aba abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","La Mosesɨ dɨ cɨhu ala abami. Nadɨ human agadɨ hadi hɨlahɨla muji nadɨ apagaŋ heŋ lamɨnaŋ ivoum uami. Lɨci Asɨ Iaue abami hameŋ ala nudɨ human agadɨ lamɨci ivouci cɨhu ala magɨlɨci ivavemi. Ivaveci igɨci lɨpɨlɨm lɨpɨlɨm agɨlaŋ nudɨ human hɨvɨ vɨkɨla vɨkɨla iaha hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Lɨci Asɨ Iaue abami. Human nadɨ hadi hɨlahɨla muji nadɨ apagaŋ heŋ cɨhu ala lamɨnaŋ ivoum uami. Lɨci Mosesɨ agaŋ human lamɨci ivouci cɨhu ala magɨlɨci ivaveci igami. Igɨci cɨhu human nudɨ agaŋ huaci lɨmi. Human limu huaci hɨnimi hameŋ ala hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Lɨci Asɨ Iaue abami. Nadɨ ciaŋ agasaŋ hɨji vɨdɨvɨdɨŋ ma lamavɨci uami. Ha vɨdɨvɨdɨŋ agadɨ abalamɨha uami. Lɨnaŋ nudɨ igavɨla hɨji vɨdɨvɨdɨŋ ma lamavɨci uami. Ha cɨhu nulɨsaŋ vɨdɨvɨdɨŋ mu agadɨ abalamɨnaŋ igavɨla hɨji vɨdɨvɨdɨŋ lamavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Vɨdɨvɨdɨŋ ahica agɨladɨ abalamɨnaŋ igavɨla hɨji vɨdɨvɨdɨŋ ma lamavɨci uami. Ha Nailɨ avɨli caba uavɨla avɨli liciavɨla fɨli hɨvɨ mɨŋamɨjiha uami. Mɨŋamɨjinaŋ avɨli mɨŋamɨjibanaŋ agaŋ mɨdɨ lɨfɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Lɨci Mosesɨ agaŋ Asɨ Iaue dɨ mavɨn ciaŋ ciaŋ abami. Iadɨ Hekɨlɨ uami. Viaŋ vaka hulaŋ iamɨgali lɨkɨla lɨkɨla hɨvɨ ciaŋ ma abadamin uami. Ciaŋ abɨben aba lɨbavɨhavɨha abadamin uami. Iabi avi nama viaŋ ciaŋ aba aba saŋ abɨnaŋ ala iadɨ sɨbɨsaŋ hameŋ laci ala lɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Hameŋ abɨci Asɨ Iaue nudɨ abami. Ani agaŋ ciaŋ aba aba saŋ sɨbɨsaŋ lamami uami. Ani lɨdaci hulaŋ sɨbɨsaŋ mumiavɨlalɨ uami. Ani lɨdaci hulaŋ hɨji uavauava lɨhavɨlalɨ uami. Ani lɨdaci hulaŋ lamɨgaŋ cɨhu igasulavɨlalɨ uami. Ani lɨdaci hulaŋ lamɨgaŋ sɨbɨlɨ lɨhavɨlalɨ uami. Ha Asɨ Iaue viaŋ nukeŋ hameŋ lɨlan uami. ");
INSERT INTO ena_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Uha uami. Viaŋ nadɨ ahɨliahua hɨji igudalɨŋ ciaŋ sulɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Lɨci Mosesɨ agaŋ Asɨ Iaue dɨ mavɨn ciaŋ ciaŋ abami. Iadɨ Hekɨlɨ uami. Hulaŋ mu igavɨla abɨnaŋ um uami. ");
INSERT INTO ena_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Hameŋ abɨci Asɨ Iaue agaŋ Mosesɨ saŋ igɨvɨ hekɨlɨ hɨniavɨla abami. Nadɨ isana Alon nɨbu Livai hɨdɨlɨ uami. Viaŋ igɨlɨŋ nɨbu ciaŋ huaci sulɨlalɨ uami. Nɨbu nadɨ igɨben aba ci vedi uami. Nadɨ igavɨla nasaŋ hɨjɨŋalɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Nama abɨdanaŋ nadɨ ciaŋ agadɨ Alon cɨhu nulɨsaŋ tɨbi sulɨbali uami. Viaŋ naludɨ ciaŋ sulasula saŋ ahɨliahua hɨji igudalɨŋ ciaŋ huaci sulɨbalaŋ uami. Naludɨ akuaba akuaba lɨlɨ saŋ abɨben agadɨ hameŋ laci ala lɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Nama viaŋ me hɨnihɨni ciaŋ sulɨdanaŋ Alon agaŋ igahɨlahɨla nadɨ ciaŋ agadɨ hulaŋ iamɨgali agɨlasaŋ tɨbi sulɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Nadɨ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agadɨ viavɨla uha uami. La kɨlɨ lɨmɨ agadɨ hɨvɨ ala vɨdɨvɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ abalamɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","19","Lɨci Mosesɨ agaŋ Midian fɨli tɨbɨ uavɨla hɨnidaci Asɨ Iaue nudɨ abami. Hulaŋ nadɨ ifɨhɨmɨben aba lɨhavɨmi agɨlaŋ ci haba hɨmavalɨ uami. Nama Isipɨ fɨli tɨbɨ cɨhu huaci ubanaŋ uami. Lɨci Mosesɨ uavɨla abiaganu Jetɨlo dɨ abami. Nama iadɨ huaci valɨnaŋ uavɨla iadɨ hɨdɨlɨ pam agɨladɨ igavin uami. Hanɨbuŋ hɨniavadi ua ci akua haba hɨmavalɨ uami. Lɨci Jetɨlo agaŋ abami. Alia uami. Uavɨla huaci laci hɨnibanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Hameŋ abɨci Mosesɨ agaŋ nudɨ abinu dɨdaŋ ninaŋ ahica agɨladɨdaŋ viavɨla sabaŋ donɨki sabɨ hɨvɨ lamami. La kɨlɨ lɨmɨ Asɨ abɨci viavɨla hɨnimi agadɨ avi viavɨla Isipɨ fɨli tɨbɨ saŋ vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Vehavɨdaci Asɨ Iaue Mosesɨ dɨ abami. Viaŋ nasaŋ vɨdɨvɨdɨŋ ci iguin uami. Isipɨ fɨli tɨbɨ ua iahuavɨla vɨdɨvɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ abalamɨdanaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ igɨbali uami. Lɨci viaŋ nukeŋ lɨlɨŋ nɨbu iadɨ ciaŋ lulavɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ ma valɨci uavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Hameŋ lɨci nama Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ abɨha uami. Asɨ Iaue nɨbu nameŋ abi aba abɨha uami. Isɨlaelɨ hɨdɨlɨ agɨlaŋ iadɨ ninaŋ manɨgali me hɨniavɨlalɨ aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Nama abɨnaŋ Isɨlaelɨ hɨdɨlɨ agɨlaŋ uavɨla iadɨ ibi mɨŋaiahavɨm aba abi aba abɨha uami. Nama iadɨ ciaŋ lulavɨla hulaŋ iamɨgali agɨladɨ ma abɨnaŋ uavɨci ha nadɨ ninaŋ manɨgali agadɨ ifɨhɨmɨben aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Hameŋ abɨci Mosesɨ tamaŋ Isipɨ fɨli tɨbɨ saŋ vehavɨdaci uaiaŋ akape umi. Lɨci hɨfɨlɨ mu hɨvɨ Asɨ Iaue agaŋ Mosesɨ dɨ pɨŋ iahavɨla nudɨ ifɨhɨmɨben aba lɨmi. ");
INSERT INTO ena_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Lɨci Mosesɨ abinu Sipola agaŋ lɨba ilɨŋ daŋ agadɨ viavɨla ninanu dɨ hadi sɨbɨlɨ ihalahami. Ihalahavɨla hadi sɨbɨlɨ agadɨ viavɨla muŋanu Mosesɨ dɨ hɨcɨ sa hɨvɨ lamavɨla abami. Viaŋ lɨlɨŋ aludɨ ninaŋ nagadɨ mɨdɨ mɨgi sadaŋ nama iadɨ hulaŋ aba abɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Lɨci Asɨ Iaue agaŋ Sipola lɨmi agadɨ igavɨla Mosesɨ dɨ valɨci hɨhi hɨnimi. Nudɨ ma ifɨhɨmami. Sipola agaŋ ninanu dɨ hadi sɨbɨlɨ ihalahami agasaŋ igahɨlavɨla abami. Viaŋ lɨlɨŋ mɨdɨ mɨgi sadaŋ Mosesɨ nama iadɨ hulaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Hameŋ abavɨla hɨniavɨdaci Asɨ Iaue agaŋ Alon dɨ abami. Nama fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ uavɨla Mosesɨ dɨ igɨha uami. Lɨci iaha uavɨla halu Asɨ hɨniadami heŋ imanu dɨ igavɨla nudɨ mɨhum iavami. ");
INSERT INTO ena_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Lɨci Asɨ Iaue akuaba akuaba ciaŋ Mosesɨ dɨ abami agadɨ isanu Alon dɨ tɨbi sulami. Vɨdɨvɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ abalamalama saŋ abami agɨlasaŋ avi sulami. ");
INSERT INTO ena_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Sula fɨhalavɨla Mosesɨ hula Alon hula Isipɨ fɨli tɨbɨ vehavɨmi. Vevɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ hulaŋ hekɨlɨ hekɨlɨ agɨladɨ likɨla via mɨgudɨbavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Mɨgudɨbavɨla Alon agaŋ Asɨ Iaue Mosesɨ dɨ abami agadɨ nulɨdɨ cɨhu tɨbi sulami. Sulasula vɨdɨvɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ hulaŋ iamɨgali agɨlasaŋ abalamami. Abalamɨdaci igavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Lavɨla Asɨ Iaue saŋ hɨji vɨdɨvɨdɨŋ lamavɨmi. La hɨji nameŋ igahɨlavɨmi. O uavɨmi. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ aludɨ sɨbɨlɨ lamavɨlalɨ agadɨ Asɨ Iaue agaŋ ci igɨlalɨ uavɨmi. Iga iga alusaŋ hɨji lamalama hɨnidi uavɨmi. Lavɨla Asɨ Iaue dɨ ibi mɨŋaiahɨben aba hali lɨbuhɨlavɨla fɨli mɨgalɨfɨlɨbavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","La hɨnimitavɨla Mosesɨ hula Alon hula Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ igɨben aba uavɨmi. Uavɨla abavɨmi. Asɨ Iaue nɨbu Isɨlaelɨ hɨdɨlɨ aludɨ Asɨ uavɨmi. Nɨbu nameŋ abalɨ uavɨmi. Iadɨ hulaŋ iamɨgali agɨladɨ valɨnaŋ fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ uavɨm aba abalɨ uavɨmi. Uavɨla iadɨ ibi mɨŋaiahaiaha sɨmɨŋ hekɨlɨ hɨlanavɨm aba abalɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Lɨhavɨci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ abami. Asɨ Iaue ha ani uami. Viaŋ akɨ saŋ nudɨ ciaŋ agadɨ igahɨlavɨla Isɨlaelɨ hɨdɨlɨ naludɨ valɨlɨŋ ubalaŋ uami. Viaŋ Asɨ Iaue dɨ ma igɨlan uami. Hameŋ sadaŋ viaŋ naludɨ ma valɨlɨŋ ubalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Lɨci Mosesɨ hula Alon hula nudɨ abavɨmi. Ibɨlu ciaŋ hɨsɨŋ aludɨ Asɨ agaŋ aludɨ pɨŋ iahalɨ uavɨmi. Hameŋ sadaŋ alaŋ fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ uben aba lɨlu uavɨmi. Uavɨla anihuliŋ me hɨvɨ sɨhɨm sabaŋ ifɨhɨmavɨla hɨlahɨla aludɨ Asɨ Iaue saŋ sagalɨ igubalu uavɨmi. Nama aludɨ huaci valɨnaŋ uvɨlu uavɨmi. Alaŋ hameŋ ma lɨmɨli ha Asɨ Iaue alusaŋ hɨmuhɨmu hekɨlɨ igubali akua uavɨmi. Ua sagaŋ hɨsɨŋ hulaŋ limu hɨhɨle agɨladɨ valɨci alusaŋ sagaŋ vevɨla aludɨ ifɨhɨmavɨbali akua uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Lɨhavɨci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ Mosesɨ dɨdaŋ Alon dɨdaŋ abami. Namɨlaŋ ahica akɨ saŋ lɨlaŋ hulaŋ iamɨgali agɨlaŋ iadɨ sibɨla agadɨ valɨben aba lɨhavadi uami. Namɨlaŋ ahica sibɨla saŋ uhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Isɨlaelɨ hɨdɨlɨ namɨlaŋ hulaŋ iamɨgali hɨdɨlɨ hekɨlɨ uami. Ahica namɨlaŋ lɨlaŋ sibɨla ci valavadi uami. ");
INSERT INTO ena_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","La mɨhiŋ hadɨhu laci ala Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ nudɨ hɨmamɨgɨlɨ daŋ agɨladɨdaŋ Isɨlaelɨ hɨdɨlɨ limu hɨhɨle sibɨla migɨlavɨhadami agɨladɨdaŋ abami. ");
INSERT INTO ena_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Iabi namɨlaŋ Isɨlaelɨ hɨdɨlɨ agɨlasaŋ mɨda asɨŋ culɨ culɨ me agɨladɨ vivi igudalaŋ fɨli caŋ daŋ eŋala eŋala avɨŋ hɨvɨ lamavɨdaci lɨhuavadi uami. Lɨhuavɨdaci lɨba kum kum me ulaŋ hafihafi hɨsɨŋ agɨladɨ vihavadi uami. Amɨli anihuliŋ nulɨsaŋ mɨda asɨŋ culɨ culɨ me agɨladɨ igumɨlaŋ uami. Vana nɨbɨlaŋ nukeŋ uavɨla mɨda asɨŋ culɨ culɨ me agɨladɨ vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Agadɨ ala namɨlaŋ nulɨdɨ vameba vivi saŋ abɨdalaŋ vihavɨlalɨ hameŋ laci ala abɨdalaŋ vihavɨm uami. Ihɨlu lavavɨla sɨhɨvia ma vihavɨci lɨba kum me agɨlaŋ tɨbɨ mɨgavɨmɨdɨ uami. Nɨbɨlaŋ hulaŋ iamɨgali ihɨlu putɨ sadaŋ nameŋ abavi uami. Aludɨ valɨnaŋ uavɨla sɨhɨm sabaŋ viavɨla aludɨ Asɨ saŋ sagalɨ hɨlahɨla igubalu aba abavi uami. ");
INSERT INTO ena_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Manɨgali agaŋ hɨji nameŋ lamavɨla abami. Nulɨsaŋ sibɨla hekɨlɨ hekɨlɨ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ igudalaŋ vihavɨm uami. Hameŋ lɨdalaŋ sibɨla vivi analɨ ciaŋ agasaŋ ma igahɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Lɨci Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ hɨmamɨgɨlɨ daŋ agɨlaŋ hula Isɨlaelɨ hɨdɨlɨ limu hɨhɨle sibɨla migɨlavɨhadami agɨlaŋ hula uavɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ abavɨmi. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ aludɨ nameŋ abi uavɨmi. Hulaŋ iamɨgali agɨlasaŋ mɨda asɨŋ culɨ culɨ me agɨladɨ igumɨlaŋ aba abi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Nɨbɨlaŋ nukeŋ nukeŋ uavɨla mɨda asɨŋ culɨ culɨ me agɨladɨ likɨlavɨla vavehavɨm aba abi uavɨmi. Agadɨ ala namɨlaŋ nulɨdɨ vameba vivi saŋ abɨdalaŋ vihavɨlalɨ hameŋ laci ala vihavɨm aba abi uavɨmi. Ihɨlu lavavɨla sɨhɨvia ma vihavɨci lɨba kum kum me agɨlaŋ tɨbɨ mɨgavɨmɨdɨ aba abi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Lɨhavɨci Isɨlaelɨ hɨdɨlɨ agɨlaŋ Isipɨ fɨli tɨbɨ mu hɨvɨ mu hɨvɨ uu mɨda asɨŋ culɨ culɨ me agɨladɨ likɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Lɨhavɨdaci hulaŋ hɨmamɨgɨlɨ daŋ agɨlaŋ nulɨdɨ aba lɨbɨsɨlɨvavɨla abavɨmi. Vaka mɨda asɨŋ culɨ culɨ me agɨladɨ uaiaŋ pabiŋ pabiŋ igudamɨli lɨba kum me vihadamɨlaŋ hameŋ laci ala vihalaŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Lavɨla Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ hɨmamɨgɨlɨ daŋ agɨlaŋ Isɨlaelɨ hɨdɨlɨ limu hɨhɨle sibɨla migɨlavɨhadami agɨladɨ ifavɨmi. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ lɨbɨmɨŋavɨmi agadɨ ala cɨhu ala uavɨla nulɨdɨ ifavɨmi. Ifu ifu abavɨmi. Akɨ saŋ sibɨla vaka vihadamɨlaŋ hameŋ ma vilaŋ uavɨmi. Amɨli anihuliŋ sibɨla vidalaŋ lɨba kum me agɨlaŋ tɨbɨ mɨgavalɨ uavɨmi. Iabi avi hameŋ ala tɨbɨ mɨgavadi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Lɨhavɨci Isɨlaelɨ hɨdɨlɨ limu hɨhɨle sibɨla migɨlavɨhadami agɨlaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ pɨŋ uavɨla mavɨn ciaŋ ciaŋ abavɨmi. Alaŋ nadɨ sibɨla hɨsɨŋ uavɨmi. Nama aludɨ akɨ saŋ hameŋ lɨnaŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Mɨda asɨŋ culɨ culɨ me agɨladɨ alusaŋ ma iguaviemi uavɨmi. La lɨba kum me ulaŋ hafihafi hɨsɨŋ agɨladɨ akape vihalaŋ aba abavɨla aludɨ ifaviemi uavɨmi. Hameŋ lɨhaviemi ala vɨhɨlɨ agaŋ nadɨ hulaŋ iamɨgali agɨladɨ hɨvɨ hɨni uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Lɨhavɨci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ nulɨdɨ abami. Namɨlaŋ ihɨlu putɨ putɨ hulaŋ iamɨgali sadaŋ nameŋ abɨlalaŋ uami. Aludɨ valɨlaŋ uavɨla Asɨ Iaue saŋ sɨhɨm sabaŋ viavɨla sagalɨ hɨlɨbalu aba abɨlalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","19","Alialaŋ uami. Namɨlaŋ sibɨla saŋ cɨhu ala uhalaŋ uami. Nɨbɨlaŋ mɨda asɨŋ culɨ culɨ me agɨladɨ nalusaŋ ma iguavɨbali uami. Agadɨ ala nɨbɨlaŋ lɨba kum me ulaŋ hafihafi hɨsɨŋ agɨladɨ vameba vivi saŋ abavɨci ha hameŋ laci ala vihalaŋ uami. Lɨba kum me ulaŋ hafihafi hɨsɨŋ agɨladɨ uaiaŋ pabiŋ pabiŋ hɨvɨ hulaŋ hɨtɨŋ hɨtɨŋ naludɨ vameba vivi saŋ abavɨci hɨlihɨli hameŋ laci ala vihalaŋ uami. Lɨba kum me ulaŋ hafihafi hɨsɨŋ agɨlaŋ tɨbɨ mɨgavɨmɨdɨ uami. Hameŋ abɨci Isɨlaelɨ hɨdɨlɨ limu hɨhɨle sibɨla migɨlavɨhadami agɨlaŋ cɨhu hɨji lamavɨla abavɨmi. Alaŋ vɨhɨlɨ hekɨlɨ igɨbalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","La Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ valavɨla uavɨmi. Uavɨla igavɨci Mosesɨ hula Alon hula nulɨdɨ igɨben aba ve lagulama hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Lɨhavɨci Isɨlaelɨ hɨdɨlɨ limu hɨhɨle sibɨla migɨlavɨhadami agɨlaŋ nulɨdɨ abavɨmi. Asɨ Iaue agaŋ naludɨ sɨbɨlɨ lamɨbali uavɨmi. Namɨlaŋ lɨlaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ hula hulaŋ nusaŋ hɨji igu igu hɨsɨŋ agɨlaŋ hula aludɨ igavɨci alaŋ hulaŋ hugɨ daŋ me hɨnidamɨli aludɨ ifɨhɨmavɨbali uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Lɨhavɨci Mosesɨ cɨhu uavɨla Asɨ Iaue dɨ abami. Iadɨ Hekɨlɨ uami. Nama akɨ saŋ nadɨ hulaŋ iamɨgali agɨladɨ sɨbɨlɨ lamɨnaŋ uami. Iadɨ avi akɨ saŋ abɨnaŋ neŋ vecin uami. ");
INSERT INTO ena_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Vevɨla Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agasaŋ nadɨ ciaŋ agadɨ tɨbi sulɨlan uami. Hɨdɨlɨ maha sulɨdalɨŋ nɨbu nadɨ hulaŋ iamɨgali agɨladɨ sɨbɨlɨ lamɨlalɨ uami. Agadɨ ala nama nulɨdɨ ahɨliahuiahu saŋ akuaba cɨki avi ma lɨnaŋ igin uami. ");
INSERT INTO ena_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Lɨci Asɨ Iaue agaŋ Mosesɨ dɨ abami. Amɨli anihuliŋ viaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ akuaba akuaba lɨben agadɨ igɨbanaŋ uami. Iadɨ nukeŋ vɨdɨvɨdɨŋ hɨvɨ lɨlɨŋ Isɨlaelɨ hɨdɨlɨ naludɨ valɨci ubalaŋ uami. Viaŋ nukeŋ lɨlɨŋ naludɨ lahuci Isipɨ fɨli tɨbɨ agadɨ vala ubalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Lavɨla Asɨ agaŋ Mosesɨ dɨ cɨhu ala abami. Viaŋ nukeŋ Asɨ Iaue uami. ");
INSERT INTO ena_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Viaŋ Ebɨlam dɨ Aisakɨ dɨ Jekopɨ dɨ pɨŋ iahavɨla nulɨdɨ abamin uami. Viaŋ Asɨ vɨdɨvɨdɨŋ hekɨlɨ daŋ aba abamin uami. Agadɨ ala viaŋ nulɨdɨ ma haiabɨla iaha abamin uami. Iadɨ ibi Iaue aba ma abamin uami. ");
INSERT INTO ena_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Viaŋ ciaŋ mɨguavɨla nulɨdɨ nameŋ abamin uami. Kenan fɨli tɨbɨ heŋ ihɨlɨŋ hɨnihɨni hɨdɨlalaŋ agadɨ nalusaŋ iguben aba abamin uami. ");
INSERT INTO ena_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ lɨhavɨdaci Isɨlaelɨ hɨdɨlɨ agɨlaŋ lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ me hɨnihɨni ilɨha ilɨha ula ula aba aba hɨniavɨlalɨ agadɨ ci igahɨlin uami. Igahɨlavɨla viaŋ ciaŋ mɨguavɨla abamin agasaŋ hɨji igahɨlin uami. ");
INSERT INTO ena_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Hameŋ sadaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨha uami. Asɨ Iaue agaŋ nameŋ abi aba abɨha uami. Viaŋ nukeŋ Asɨ Iaue aba abi aba abɨha uami. Namɨlaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ lɨhu hɨvɨ hɨnihɨni sibɨla hekɨlɨ hekɨlɨ vivi vɨhɨlɨfulɨfu hɨnilalaŋ aba abi aba abɨha uami. Agadɨ ala mu tɨbɨ viaŋ lɨlɨŋ namɨlaŋ Isipɨ fɨli tɨbɨ agadɨ vala uavɨla nulɨdɨ lɨhu hɨvɨ ma hɨnibalaŋ aba abi aba abɨha uami. Namɨlaŋ lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ me hɨnidalaŋ viaŋ naludɨ likɨla viavɨla lamɨlɨŋ huaci hɨnibalaŋ aba abi aba abɨha uami. Viaŋ naludɨ ahɨliahuavɨla iadɨ vɨdɨvɨdɨŋ hɨvɨ nulɨdɨ sɨbɨlɨ lamɨben aba abi aba abɨha uami. Lɨlɨŋ namɨlaŋ nulɨdɨ lɨhu hɨvɨ ma hɨnibalaŋ aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Viaŋ lɨlɨŋ namɨlaŋ iadɨ nukeŋ hulaŋ iamɨgali hɨnibalaŋ aba abi aba abɨha uami. Hɨnidalaŋ viaŋ naludɨ nukeŋ Asɨ hɨniben aba abi aba abɨha uami. Namɨlaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ lɨhu hɨvɨ hɨnihɨni sibɨla hekɨlɨ hekɨlɨ vivi vɨhɨlɨfulɨfu hɨnilalaŋ aba abi aba abɨha uami. Agadɨ ala mu tɨbɨ viaŋ lɨlɨŋ namɨlaŋ Isipɨ fɨli tɨbɨ agadɨ vala uavɨla nulɨdɨ lɨhu hɨvɨ ma hɨnibalaŋ aba abi aba abɨha uami. Hameŋ lɨben agadɨ igavɨla abɨbalaŋ aba abi aba abɨha uami. Asɨ Iaue nɨbu ala aludɨ Asɨ aba abɨbalaŋ aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Vaka viaŋ ciaŋ mɨguavɨla fɨli tɨbɨ Ebɨlam saŋ iguben aba nudɨ abamin aba abi aba abɨha uami. Aisakɨ dɨdaŋ Jekopɨ dɨdaŋ avi abamin aba abi aba abɨha uami. Viaŋ naludɨ likɨla via uavɨla fɨli tɨbɨ ciaŋ mɨguavɨla abamin heŋ ala lamɨben aba abi aba abɨha uami. Lɨlɨŋ fɨli tɨbɨ agaŋ naludɨ nukeŋ fɨli tɨbɨ hɨnibali aba abi aba abɨha uami. Viaŋ Asɨ Iaue aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Lɨci Mosesɨ agaŋ ciaŋ agadɨ Isɨlaelɨ hɨdɨlɨ agɨlasaŋ sulami. Sulɨdaci nudɨ ciaŋ agadɨ ma igahɨlavɨmi. Sibɨla hekɨlɨ hekɨlɨ vihavɨhadami sadaŋ nulɨdɨ hɨji hɨmahɨma saŋ pam lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Lɨhavɨdaci Asɨ Iaue Mosesɨ dɨ abami. ");
INSERT INTO ena_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Nama Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ pɨŋ uavɨla abɨnaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ valɨci nudɨ fɨli tɨbɨ agadɨ vala uavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Hameŋ abɨci Mosesɨ cɨhu hɨbɨŋ abami. Isɨlaelɨ hɨdɨlɨ agɨlaŋ iadɨ ciaŋ ma igahɨlavɨlalɨ uami. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ avi iadɨ ciaŋ ma igahɨlɨbali akua uami. Iadɨ sɨbɨsaŋ vɨhɨlɨ lɨdaci ciaŋ sɨhɨvia ma abɨlan uami. ");
INSERT INTO ena_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Hameŋ abɨci cɨhu Asɨ Iaue agaŋ Mosesɨ dɨdaŋ Alon dɨdaŋ abami. Isɨlaelɨ hɨdɨlɨ agɨladɨdaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨdaŋ abɨhalaŋ uami. Asɨ Iaue aludɨ nameŋ abi aba abɨhalaŋ uami. Isɨlaelɨ hɨdɨlɨ agɨladɨ likɨla via Isipɨ fɨli tɨbɨ agadɨ valavɨla uhalaŋ aba abi aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Isɨlaelɨ hɨdɨlɨ agɨlaŋ latɨhavɨla hɨdɨlɨ hɨtɨŋ hɨtɨŋ hɨniavɨhadami. Hɨnihɨni hulaŋ latɨhiŋ hɨtɨŋ hɨtɨŋ agɨlaŋ manɨgali daŋ hɨniavɨhadami. Jekopɨ dɨ ninanu Cimegeŋ nɨbu Luben. Luben dɨ ninadinu agɨladɨ ibi nameŋ. Mu Hanokɨ. Mu Palu. Mu Hesɨlon. Mu Kalɨmi. Nɨbɨlaŋ Luben hɨdɨlɨ hɨvɨ iaha habɨlavɨla manɨgali hɨtɨŋ hɨtɨŋ daŋ hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Jekopɨ dɨ ninanu Iagɨveŋ nɨbu Simeon. Simeon dɨ ninadinu agɨladɨ ibi nameŋ. Mu Jemuelɨ. Mu Jamin. Mu Ohatɨ. Mu Jakin. Mu Sohalɨ. Mu Saulɨ. Saulɨ iamɨnu nɨbu Kenan hɨdɨlɨ. Nɨbɨlaŋ Simeon hɨdɨlɨ hɨvɨ iahavɨla habɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Jekopɨ dɨ ninanu Alɨkegeŋ nɨbu Livai. Livai dɨ ninadinu agɨladɨ ibi nameŋ. Mu Gelɨson. Mu Kohatɨ. Mu Melali. Livai dɨ hualɨ lugɨlavɨci ua 137 iahɨci hɨmami. Nulɨdɨ ninadinɨlu ajihalinɨlu agɨladɨ ibi nameŋ. ");
INSERT INTO ena_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gelɨson dɨ ninadinu ahica. Mu Lipɨni. Mu Simei. Nɨbɨlaŋ Gelɨson hɨdɨlɨ hɨvɨ iahavɨla habɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohatɨ dɨ ninadinu agɨladɨ ibi nameŋ. Mu Amɨlam. Mu Isɨhalɨ. Mu Hebɨlon. Mu Usielɨ. Kohatɨ dɨ hualɨ lugɨlavɨci ua 133 iahɨci hɨmami. ");
INSERT INTO ena_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Melali dɨ ninadinu ahica. Mu Maheli. Mu Musi. Nɨbɨlaŋ Livai hɨdɨlɨ hɨvɨ iahavɨla habɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amɨlam agaŋ iaganu dɨ nadinu humɨgaŋ pam hɨsɨŋ iahuinu Jokebetɨ dɨ sabimi. Lɨci Jokebetɨ agaŋ Alon dɨdaŋ Mosesɨ dɨdaŋ huhɨlami. Lɨci Amɨlam dɨ hualɨ lugɨlavɨci ua 137 iahɨci hɨmami. ");
INSERT INTO ena_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Isɨhalɨ dɨ ninadinu agɨladɨ ibi nameŋ. Mu Kola. Mu Nefekɨ. Mu Sikɨli. ");
INSERT INTO ena_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Usielɨ dɨ ninadinu agɨladɨ ibi nameŋ. Mu Misaelɨ. Mu Elɨsafan. Mu Sitɨli. ");
INSERT INTO ena_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aminadapɨ dɨ ninanadinu agɨladɨ ibi nameŋ. Mu Nason. Nudɨ nadinu humɨgaŋ pam Eliseba. Alon agaŋ Eliseba dɨ sabimi. Sabici ninaŋ limu ahica limu ahica huhɨlami. Mu Nadapɨ. Mu Abihu. Mu Eleasalɨ. Mu Itamalɨ. ");
INSERT INTO ena_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kola dɨ ninadinu agɨladɨ ibi nameŋ. Mu Asilɨ. Mu Elɨkana. Mu Abiasapɨ. Nɨbɨlaŋ Kola hɨdɨlɨ hɨvɨ iahavɨla habɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Alon dɨ ninanu Eleasalɨ agaŋ Putielɨ dɨ nadi mu agadɨ sabimi. Sabiavɨla hɨniavɨci ninaŋ Finiasɨ dɨ huhɨlami. Hulaŋ agɨlaŋ Livai hɨdɨlɨ hulaŋ latɨhiŋ agɨladɨ manɨgali hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Alon hula Mosesɨ hula nɨbɨlaŋ Livai hɨdɨlɨ agɨladɨ latɨhiŋ sadaŋ Asɨ Iaue agaŋ nulɨdɨ abami. Isɨlaelɨ hɨdɨlɨ latɨhiŋ Isipɨ fɨli tɨbɨ hɨtɨŋ hɨtɨŋ hɨniavɨlalɨ agɨladɨ ahica namɨlaŋ nulɨdɨ likɨla via pam lamavɨla via uhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Lɨci hulaŋ ahica agɨlaŋ ala Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ abavɨmi. Nama Isɨlaelɨ hɨdɨlɨ agɨladɨ valɨnaŋ uavɨm uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Mosesɨ agaŋ Isipɨ fɨli tɨbɨ hɨnidaci Asɨ Iaue nudɨ abami. ");
INSERT INTO ena_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Viaŋ nukeŋ Asɨ Iaue uami. Iadɨ ciaŋ nasaŋ iguadin agadɨ via uavɨla Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agasaŋ sulɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Lɨci Mosesɨ agaŋ Asɨ Iaue dɨ abami. Nama iadɨ igɨlanaŋ uami. Iadɨ sɨbɨsaŋ vɨhɨlɨ lɨdaci ciaŋ sɨhɨvia ma abɨlan uami. Hameŋ sadaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ iadɨ ciaŋ ma akua igahɨlɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Hameŋ abɨci Asɨ Iaue agaŋ Mosesɨ dɨ abami. Ci igɨnaŋ uami. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ nadɨ igɨci nama viaŋ me hɨnibanaŋ uami. Nadɨ isana Alon nɨbu ciaŋ igalahalaha hɨsɨŋ me hɨnihɨni nadɨ ciaŋ agadɨ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agasaŋ tɨbi sulɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Akuaba akuaba ciaŋ mu mu nadɨ abadin agadɨ uavɨla Alon dɨ abɨha uami. Lɨnaŋ nɨbu Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ abɨci Isɨlaelɨ hɨdɨlɨ agɨladɨ valɨci nudɨ fɨli tɨbɨ agadɨ vala uavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Agadɨ ala viaŋ nukeŋ lɨlɨŋ nɨbu iadɨ ciaŋ lulɨbali uami. Lulɨci viaŋ Isipɨ fɨli tɨbɨ heŋ vɨdɨvɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ abalamɨben uami. Abalamɨdalɨŋ iga iga i aba abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Agadɨ ala nɨbu nadɨ ciaŋ ma igahɨlɨbali uami. Lɨci viaŋ iadɨ vɨdɨvɨdɨŋ hɨvɨ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ sɨbɨlɨ lamɨben uami. Lavɨla iadɨ hulaŋ iamɨgali Isɨlaelɨ hɨdɨlɨ agɨladɨ likɨlɨben uami. Lɨlɨŋ nɨbɨlaŋ Isipɨ fɨli tɨbɨ agadɨ sɨkasɨkan vala uavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ sɨbɨlɨ lamɨben uami. Sɨbɨlɨ lamavɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ likɨlɨlɨŋ nɨbɨlaŋ Isipɨ fɨli tɨbɨ agadɨ sɨkasɨkan vala uavɨbali uami. Vala uavɨdaci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ igavɨla abavɨbali uami. O aba abavɨbali uami. Ha Asɨ Iaue nukeŋ lɨci uavadi aba abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Lɨci Mosesɨ hula Alon hula Asɨ Iaue abami hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ pɨŋ ua iahuavɨmi hadɨhu Mosesɨ dɨ hualɨ lugɨlavɨci ua 80 iahami. Alon dɨ hualɨ agadɨ lugɨlavɨci ua 83 iahami. ");
INSERT INTO ena_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Lɨci Asɨ Iaue agaŋ Mosesɨ dɨdaŋ Alon dɨdaŋ abami. ");
INSERT INTO ena_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ naludɨ nameŋ abɨbali uami. Vɨdɨvɨdɨŋ abalamɨhalaŋ aba abɨbali uami. Hameŋ abɨci nama Alon dɨ abɨha uami. Nadɨ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agadɨ fɨli hɨvɨ havalɨnaŋ mɨgam aba abɨha uami. Manɨgali agaŋ igasulɨdaci kɨlɨ lɨmɨ agadɨ havalɨnaŋ mɨgam aba abɨha uami. Hameŋ lɨnaŋ kɨlɨ lɨmɨ agaŋ lahu lɨfɨbali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Lɨci Mosesɨ hula Alon hula manɨgali agadɨ pɨŋ uavɨmi. Uavɨla Asɨ Iaue abami hameŋ laci ala lɨhavɨmi. Manɨgali agaŋ hulaŋ nusaŋ hɨji igu igu hɨsɨŋ agɨlaŋ hula ahuata hameŋ igasulavɨdaci Alon agaŋ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agadɨ fɨli hɨvɨ havalɨci mɨgavɨla lahu lɨfami. ");
INSERT INTO ena_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Lɨci manɨgali agaŋ igavɨla nudɨ hulaŋ hɨji hutesɨ daŋ agɨladɨdaŋ hulaŋ hau hubɨla hubɨla hɨsɨŋ agɨladɨdaŋ abɨci nudɨ pɨŋ vehavɨmi. Vevɨla nulɨdɨ mugɨluŋ agɨladɨ ibi luvɨla luvɨla Alon lɨmi hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Nulɨdɨ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agɨladɨ fɨli hɨvɨ havalavɨci mɨgavɨla lahu lɨfavɨmi. Lɨhavɨci Alon dɨ lahu agaŋ nulɨdɨ lahu agɨladɨ iavaiava hɨlɨvami. ");
INSERT INTO ena_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Hameŋ lɨci ala manɨgali agadɨ hɨji humɨgaŋ ma iahami. Lɨci Mosesɨ dɨ ciaŋ agadɨdaŋ Alon dɨ ciaŋ agadɨdaŋ ma igahɨlami. Asɨ Iaue abami hameŋ laci ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Lɨci Asɨ Iaue agaŋ Mosesɨ dɨ abami. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ iadɨ lɨhu hɨvɨ ma hɨnilalɨ uami. Hameŋ sadaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ ma valɨci uavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ci igɨnaŋ uami. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ cimɨdaŋ cimɨdaŋ Nailɨ avɨli caba ulalɨ uami. Hameŋ sadaŋ nama cimɨdaŋ sɨbaŋ nadɨ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agadɨ viavɨla avɨli caba heŋ uavɨla manɨgali agasaŋ makamɨŋa hɨniha uami. ");
INSERT INTO ena_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Hɨnidanaŋ veci nameŋ abɨha uami. Alaŋ Ibɨlu ciaŋ hɨsɨŋ aba abɨha uami. Aludɨ Asɨ Iaue agaŋ iadɨ abɨci ven aba abɨha uami. Nɨbu nadɨ abi aba abɨha uami. Iadɨ hulaŋ iamɨgali valɨnaŋ fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ uavɨla iadɨ ibi mɨŋaiahavɨm aba abi aba abɨha uami. Viaŋ nadɨ hameŋ abɨlɨŋ ala nama iadɨ ciaŋ ma igahɨlɨlanaŋ aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","18","Viaŋ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agadɨ hɨvɨ lɨlɨŋ avɨli agaŋ mɨdɨ lɨfɨbali aba abi aba abɨha uami. Mɨdɨ lɨfɨci hehɨlaŋ agɨlaŋ haba hɨmavɨbali aba abi aba abɨha uami. Haba hɨmavɨci avɨli agaŋ avi mutu hɨsi lɨbali aba abi aba abɨha uami. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ avi avɨli agadɨ nana saŋ valavɨbali aba abi aba abɨha uami. Viaŋ akuaba akuaba lɨlɨŋ igavɨla abɨbanaŋ aba abi aba abɨha uami. O Asɨ Iaue nɨbu Asɨ amɨŋ sɨbaŋ aba abɨbanaŋ aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Lavɨla Mosesɨ dɨ cɨhu ala abami. Nama Alon dɨ abɨha uami. Nadɨ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agadɨ viavɨla atɨ lamalama udanaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ avɨli hekɨlɨ hekɨlɨ agɨlaŋ avɨli makaŋ hekɨlɨ hekɨlɨ agɨlaŋ mɨdɨ lɨfavɨm aba abɨha uami. Idu hekɨlɨ hekɨlɨ agɨlaŋ idu cɨki cɨki agɨlaŋ mɨdɨ lɨfavɨm aba abɨha uami. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ avɨli sɨkasɨkan sɨbɨlɨ lavɨla mɨdɨ pam lɨfavɨm aba abɨha uami. Avɨli kɨlɨ hunaŋ lɨba hunaŋ hɨvɨ hɨniavɨbali agɨlaŋ avi mɨdɨ lɨfavɨm aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Lɨci manɨgali agaŋ hulaŋ nusaŋ hɨji igu igu hɨsɨŋ agɨlaŋ hula igasulavɨdaci Mosesɨ hula Alon hula Asɨ Iaue abami hameŋ laci ala lɨhavɨmi. Alon nudɨ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agadɨ mɨŋaiaha Nailɨ avɨli agadɨ ifɨci mɨdɨ lɨfami. ");
INSERT INTO ena_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Lɨci hehɨlaŋ akuaba akuaba agɨlaŋ haba hɨmavɨmi. Avɨli agɨlaŋ avi mutu hɨsi lɨhavɨmi. Lɨhavɨci hulaŋ iamɨgali agɨlaŋ avɨli agɨladɨ nana saŋ lɨhavɨmi ala hɨma. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ avɨli agɨlaŋ sɨkasɨkan mɨdɨ lɨfavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Lɨhavɨci hulaŋ hau hubɨla hubɨla hɨsɨŋ agɨlaŋ vevɨla nulɨdɨ mugɨluŋ agɨladɨ ibi luvɨla luvɨla Alon lɨmi hameŋ laci ala lɨhavɨmi. Lɨhavɨci manɨgali agaŋ Mosesɨ dɨ ciaŋ agadɨdaŋ Alon dɨ ciaŋ agadɨdaŋ ma igahɨladami. Lɨdɨŋ nulɨdɨ ciaŋ agadɨ luladami. Asɨ Iaue abami hameŋ ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Manɨgali agaŋ nudɨ ulaŋ hɨvɨ uavɨla akuaba akuaba iahami agasaŋ hɨji ma lamami. ");
INSERT INTO ena_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Lɨci Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ iamɨgali agɨlaŋ Nailɨ avɨli agadɨ nɨben aba lɨhavɨmi ala hɨma. La avɨli caba heŋ avɨli sɨmɨ tulɨ mu mu mavavɨmi. Mavavɨla heŋ navɨmi. ");
INSERT INTO ena_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Nailɨ avɨli agaŋ sɨbɨlɨ lavɨla hɨnidaci uaiaŋ human limu fɨhala human limu pabiŋ cɨjɨŋ umi. ");
INSERT INTO ena_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Lɨci Asɨ Iaue agaŋ Mosesɨ dɨ cɨhu ala abami. Nama manɨgali dɨ pɨŋ uavɨla nudɨ nameŋ abɨha uami. Asɨ Iaue nameŋ abi aba abɨha uami. Iadɨ hulaŋ iamɨgali agɨladɨ valɨnaŋ uavɨla iadɨ ibi mɨŋaiahavɨm aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ma valɨnaŋ uavɨci ha viaŋ abɨlɨŋ sulɨ agɨlaŋ uavɨla nadɨ fɨli tɨbɨ agadɨ sɨkasɨkan sɨbɨlɨ lamavɨbali aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Sulɨ agɨlaŋ Nailɨ avɨli heŋ mɨla fɨhalavɨbali aba abi aba abɨha uami. Lavɨla avɨli agadɨ valavɨla cɨhu nadɨ ulaŋ hekɨlɨ agasaŋ uavɨbali aba abi aba abɨha uami. Nadɨ ani hɨnihɨni hɨsɨŋ uvɨ heŋ ivouavɨbali aba abi aba abɨha uami. Nadɨ vadɨm ani hɨsɨva hɨsɨva hɨsɨŋ heŋ avi iahuavɨbali aba abi aba abɨha uami. Hulaŋ nasaŋ hɨji igu igu hɨsɨŋ agɨladɨ ulaŋ heŋ ivouavɨbali aba abi aba abɨha uami. Nadɨ hulaŋ iamɨgali agɨladɨ ulaŋ hɨvɨ ivouavɨbali aba abi aba abɨha uami. Hɨlanana uvɨ hɨvɨ ivouavɨbali aba abi aba abɨha uami. Maci eŋala eŋala hunaŋ mɨsɨn hɨvɨ avi mɨguavɨbali aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Nadɨ hadipɨlɨ hɨvɨ havala havala iahuavɨbali aba abi aba abɨha uami. Hulaŋ nasaŋ hɨji igu igu hɨsɨŋ agɨladɨ hadipɨlɨ hɨvɨ havala havala iahuavɨbali aba abi aba abɨha uami. Nadɨ hulaŋ iamɨgali agɨladɨ hadipɨlɨ hɨvɨ avi havala havala iahuavɨbali aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Lavɨla Mosesɨ dɨ cɨhu ala abami. Alon dɨ abɨha uami. Nadɨ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agadɨ mɨŋaiaha atɨ lamalama udanaŋ avɨli hekɨlɨ hekɨlɨ avɨli makaŋ hekɨlɨ hekɨlɨ idu hekɨlɨ hekɨlɨ heŋ sulɨ agɨlaŋ iahavɨm aba abɨha uami. Iahavɨla Isipɨ fɨli tɨbɨ heŋ uavɨbali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Lɨci Mosesɨ agaŋ Alon dɨ abɨci hameŋ laci ala lɨmi. Nudɨ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agadɨ mɨŋaiaha avɨli agɨladɨ atɨ lamalama udaci sulɨ agɨlaŋ iahaiaha Isipɨ fɨli tɨbɨ heŋ mɨla fɨhalavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Lɨci hulaŋ hau hubɨla hubɨla hɨsɨŋ agɨlaŋ avi nulɨdɨ mugɨluŋ agɨladɨ ibi luvɨlavɨci sulɨ agɨlaŋ avɨli agɨladɨ valavɨla Isipɨ fɨli tɨbɨ uavɨmi. Alon lɨmi hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Lɨhavɨci manɨgali agaŋ Mosesɨ sadaŋ Alon sadaŋ ciaŋ abɨci uci vehavɨmi. Vehavɨci abami. Ahica namɨlaŋ Asɨ Iaue dɨ mavɨn ciaŋ ciaŋ abɨhalaŋ uami. Abɨlaŋ Asɨ Iaue sulɨ nagɨladɨ lahum uami. Sulɨ nagɨladɨ lahuci viaŋ iadɨ hulaŋ iamɨgali agɨlaŋ hula huaci akua hɨnibalu uami. Hameŋ lɨci ha viaŋ nudɨ hulaŋ iamɨgali agɨladɨ valɨlɨŋ uavɨla nusaŋ akuaba akuaba sagalɨ hɨlahɨla iguavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Lɨci Mosesɨ abami. Nama nukeŋ mɨhiŋ lamɨnaŋ viaŋ Asɨ Iaue dɨ abɨben uami. Nasadaŋ hulaŋ nasaŋ hɨji igu igu hɨsɨŋ agɨlasadaŋ abɨben uami. Nadɨ hulaŋ iamɨgali agɨlasaŋ avi abɨben uami. Abɨlɨŋ sulɨ naludɨ ulaŋ hɨvɨ hɨniavadi agɨlaŋ vala uavɨbali uami. Naludɨ hadipɨlɨ hɨvɨ havala havala iahuavadi agɨlaŋ avi vala uavɨbali uami. Uavɨla Nailɨ avɨli hɨvɨ pam hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Lɨci manɨgali agaŋ abami. Amɨli Asɨ Iaue dɨ abɨha uami. Lɨci Mosesɨ abami. Nama abɨnaŋ hameŋ ala lɨben uami. Viaŋ Asɨ Iaue dɨ abɨlɨŋ akuaba akuaba lɨbali agadɨ igavɨla nama hɨji nameŋ igahɨlɨbanaŋ uami. Isɨlaelɨ hɨdɨlɨ agɨladɨ Asɨ Iaue pam hɨnilalɨ aba abɨbanaŋ uami. Asɨ mu nɨbu me agaŋ fɨli neŋ ma hɨnilalɨ aba abɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Lɨci sulɨ nadɨ hadipɨlɨ hɨvɨ nadɨ ulaŋ akuaba akuaba agɨladɨ hɨvɨ havala havala iahuavadi agɨlaŋ vala uavɨbali uami. Hulaŋ nasaŋ hɨji igu igu hɨsɨŋ agɨladɨ hadipɨlɨ hɨvɨ nadɨ hulaŋ iamɨgali agɨladɨ hadipɨlɨ hɨvɨ havala havala iahuavadi agɨlaŋ avi vala uavɨbali uami. Vala uavɨla Nailɨ avɨli hɨvɨ pam hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Lavɨla Mosesɨ hula Alon hula manɨgali agadɨ vala uavɨmi. Uavɨla sulɨ agɨlaŋ manɨgali dɨ vala uavɨbali aba Mosesɨ agaŋ Asɨ Iaue dɨ mavɨn ciaŋ ciaŋ abami. ");
INSERT INTO ena_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Lɨci Asɨ Iaue agaŋ hameŋ laci ala lɨmi. Sulɨ uleŋ muji hɨniavɨmi agɨladɨ lɨci haba hɨma fɨhalavɨmi. Ulaŋ caba caba hɨniavɨmi agɨlaŋ haba hɨma fɨhalavɨmi. Hualabɨla lua muji hɨniavɨmi agɨlaŋ avi haba hɨma fɨhalavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Lɨhavɨci Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ iamɨgali agɨlaŋ sulɨ valɨ valɨ agɨladɨ likɨla likɨla vavevave mɨgudɨbavɨmi. Lɨhavɨci sulɨ valɨ valɨ agɨlaŋ haba hulɨvavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Hulɨvavɨdaci manɨgali agaŋ igɨci sulɨ agɨlaŋ hɨma fɨhalavɨmi. Lɨhavɨci ala manɨgali dɨ hɨji humɨgaŋ agaŋ ma iahami. Lɨci Mosesɨ dɨ ciaŋ agadɨdaŋ Alon dɨ ciaŋ agadɨdaŋ ma igahɨlami. Asɨ Iaue abami hameŋ laci ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Asɨ Iaue agaŋ Mosesɨ dɨ cɨhu ala abami. Alon dɨ abɨha uami. Nama nadɨ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agadɨ hɨvɨ fɨli ibɨlɨ agadɨ ifɨha aba abɨha uami. Ifɨnaŋ Isipɨ fɨli tɨbɨ neŋ fɨli ibɨlɨ sɨkasɨkan agɨlaŋ iagui lɨfavɨm aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Lɨci hameŋ ala lɨmi. Alon dɨ abɨci nudɨ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agadɨ hɨvɨ fɨli ibɨlɨ agadɨ ifɨci iagui lɨfavɨla hulaŋ iamɨgali sɨhɨm sabaŋ Isipɨ fɨli tɨbɨ hɨniavɨmi agɨladɨ sɨkasɨkan hafilɨbavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Lɨhavɨci Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ hau hubɨla hubɨla hɨsɨŋ agɨlaŋ nulɨdɨ mugɨluŋ agɨladɨ ibi luvɨlavɨci ala fɨli ibɨlɨ agaŋ iagui ma lɨfavɨmi. Alon lɨci iagui lɨfavɨmi agɨlaŋ pam hulaŋ iamɨgali agɨladɨdaŋ sɨhɨm sabaŋ agɨladɨdaŋ sɨkasɨkan hafilɨbavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Lɨhavɨci hulaŋ hau hubɨla hubɨla hɨsɨŋ agɨlaŋ manɨgali agadɨ abavɨmi. Ha Asɨ Iaue nukeŋ lɨci iahavi uavɨmi. Hameŋ abavɨci ala Asɨ Iaue abami agaŋ hameŋ laci ala lɨmi. Manɨgali agadɨ hɨji humɨgaŋ ma iahami. Lɨci Mosesɨ dɨ ciaŋ agadɨdaŋ Alon dɨ ciaŋ agadɨdaŋ ma igahɨlami. ");
INSERT INTO ena_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Lɨci Asɨ Iaue agaŋ Mosesɨ dɨ cɨhu ala abami. Ci igɨnaŋ uami. Manɨgali agaŋ cimɨdaŋ cimɨdaŋ hɨvɨ avɨli caba heŋ velalɨ uami. Nama uavɨla manɨgali saŋ makamɨŋa hɨniha uami. Hɨnidanaŋ veci igavɨla iadɨ ciaŋ agadɨ abɨha uami. Asɨ Iaue agaŋ nameŋ abi aba abɨha uami. Nama iadɨ hulaŋ iamɨgali agɨladɨ valɨnaŋ uavɨla iadɨ ibi mɨŋaiahavɨm aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ci igɨnaŋ aba abi aba abɨha uami. Nama iadɨ hulaŋ iamɨgali agɨladɨ ma valɨnaŋ uavɨci aba abi aba abɨha uami. Ha viaŋ mumalɨ agɨladɨ abɨlɨŋ nasadaŋ hulaŋ nasaŋ hɨji igu igu hɨsɨŋ agɨlasadaŋ uavɨbali aba abi aba abɨha uami. La nadɨ hulaŋ iamɨgali agɨlasaŋ avi uavɨbali aba abi aba abɨha uami. Uavɨla nadɨ ulaŋ agɨladɨ hɨvɨ mɨla fɨhalavɨbali aba abi aba abɨha uami. Isipɨ fɨli tɨbɨ hɨsɨŋ limu hɨhɨle agɨladɨ ulaŋ agɨladɨ hɨvɨ mɨla fɨhalavɨbali aba abi aba abɨha uami. Naludɨ fɨli tɨbɨ heŋ avi mɨlavɨla lalɨgua fɨhalavɨbali aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Agadɨ ala mumalɨ agɨlaŋ iadɨ hulaŋ iamɨgali Gosen fɨli tɨbɨ hɨniavɨlalɨ heŋ ma uavɨbali aba abi aba abɨha uami. Hameŋ lɨlɨŋ igavɨla nameŋ igahɨlɨbanaŋ aba abi aba abɨha uami. Ha Asɨ Iaue nukeŋ Isipɨ fɨli tɨbɨ neŋ vɨdɨvɨdɨŋ abalami aba abɨbanaŋ aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Agadɨ ala iadɨ hulaŋ iamɨgali agɨladɨ valɨlɨŋ huaci hɨniavɨbali aba abi aba abɨha uami. Nadɨ hulaŋ iamɨgali agɨlaŋ pam vɨhɨlɨ hameŋ agadɨ amɨli igavɨbali aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","La Asɨ Iaue agaŋ hameŋ laci ala lɨmi. Mumalɨ agɨladɨ abɨci Isipɨ fɨli tɨbɨ agadɨ haiabɨla mu hɨvɨ mu hɨvɨ uavɨmi. Uavɨla manɨgali dɨ ulaŋ agɨladɨ hɨvɨ ivouavɨmi. Hulaŋ nusaŋ hɨji igu igu hɨsɨŋ agɨladɨ ulaŋ agɨladɨ hɨvɨ avi ivouavɨmi. Lavɨla mumalɨ agɨlaŋ Isipɨ fɨli tɨbɨ agadɨ sɨkasɨkan sɨbɨlɨ lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Lɨhavɨci manɨgali agaŋ Mosesɨ sadaŋ Alon sadaŋ abɨci vehavɨci abami. Namɨlaŋ uavɨla naludɨ Asɨ saŋ Isipɨ fɨli tɨbɨ neŋ sagalɨ hɨlahɨla iguhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Lɨci Mosesɨ abami. Alaŋ hameŋ lɨmɨli huaci ma lɨbali uami. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ igavɨci alaŋ Asɨ Iaue saŋ sɨhɨm sabaŋ nɨbɨlaŋ sagalɨ ma hɨlahɨla iguavɨlalɨ agɨladɨ viavɨla sagalɨ igubalu aba lɨmɨli alusaŋ humɨgaŋ vɨhɨlɨ vihavɨbali uami. Humɨgaŋ vɨhɨlɨ viavɨla lɨba kum kum agɨladɨ vivi havala havala aludɨ ifɨhɨmavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Alaŋ fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ uavɨla anihuliŋ me hɨvɨ Asɨ Iaue saŋ sagalɨ hɨlahɨla igubalu uami. Asɨ abalɨ hameŋ laci ala lɨbalu uami. ");
INSERT INTO ena_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Lɨci manɨgali agaŋ abami. Alialaŋ uami. Viaŋ naludɨ valɨlɨŋ uavɨla fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ Asɨ Iaue saŋ sagalɨ hɨlahɨla iguhalaŋ uami. Ataŋ sɨbaŋ umɨlaŋ uami. Namɨlaŋ Asɨ Iaue dɨ abɨlaŋ iadɨ ahɨliahuci mumalɨ agɨlaŋ vala uavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Lɨci Mosesɨ abami. Alaŋ nadɨ vala uavɨla Asɨ Iaue dɨ abɨben uami. Abɨlɨŋ mumalɨ agɨladɨ amɨli lahubali uami. Mumalɨ nadɨ hɨvɨ hɨniavi agɨladɨdaŋ hulaŋ nasaŋ hɨji igu igu hɨsɨŋ agɨladɨ hɨvɨ hɨniavi agɨladɨdaŋ lahubali uami. Nadɨ hulaŋ iamɨgali agɨladɨ hɨvɨ hɨniavi agɨladɨ avi lahubali uami. Lahuci aludɨ analɨ abɨmɨnaŋ uami. Analɨ abavɨla hulaŋ iamɨgali agɨlaŋ Asɨ Iaue saŋ sagalɨ hɨlahɨla igubalu aba lɨhavɨbali agɨladɨ abamɨgɨlɨmɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Hameŋ abavɨla Mosesɨ agaŋ manɨgali agadɨ vala uavɨla Asɨ Iaue dɨ mavɨn ciaŋ ciaŋ abami. ");
INSERT INTO ena_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Lɨci Asɨ Iaue agaŋ Mosesɨ abami hameŋ laci ala lɨmi. Mumalɨ agɨladɨ lɨci manɨgali agadɨdaŋ hulaŋ nusaŋ hɨji igu igu hɨsɨŋ agɨladɨdaŋ vala uavɨmi. Nudɨ hulaŋ iamɨgali agɨladɨ avi sɨkasɨkan vala ua fɨhalavɨmi. Pabiŋ cɨki avi ma hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Mumalɨ agɨlaŋ uavɨci cɨhu manɨgali dɨ hɨji humɨgaŋ ma iahami. Hameŋ sadaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ ma valɨci uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Lɨci Asɨ Iaue agaŋ Mosesɨ dɨ cɨhu ala abami. Uavɨla manɨgali dɨ nameŋ abɨha uami. Ibɨlu ciaŋ hɨsɨŋ aludɨ Asɨ Iaue agaŋ nameŋ abi aba abɨha uami. Iadɨ hulaŋ iamɨgali agɨladɨ valɨnaŋ uavɨla iadɨ ibi mɨŋaiahavɨm aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","3","Nama nulɨdɨ abamɨgɨlɨnaŋ hɨniavɨci ha viaŋ lɨlɨŋ hɨmuhɨmu hekɨlɨ agaŋ naludɨ sɨhɨm sabaŋ agɨladɨ hɨvɨ iahɨbali aba abi aba abɨha uami. Naludɨ sabaŋ osɨ sabaŋ donɨki sabaŋ kamelɨ sabaŋ bulɨmakau sabaŋ sipsipɨ sabaŋ meme agɨladɨ hɨvɨ sɨkasɨkan iahɨbali aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Agadɨ ala Isɨlaelɨ hɨdɨlɨ agɨladɨ sɨhɨm sabaŋ valɨlɨŋ huaci hɨniavɨbali aba abi aba abɨha uami. Isɨlaelɨ hɨdɨlɨ agɨladɨ sɨhɨm sabaŋ agɨlaŋ pabiŋ cɨki avi ma hɨmavɨbali aba abi aba abɨha uami. Isipɨ fɨli tɨbɨ hɨsɨŋ naludɨ sɨhɨm sabaŋ agɨlaŋ pam haba hɨma fɨhalavɨbali aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Lavɨla Asɨ Iaue mɨhiŋ lamavɨla abami. Amɨli viaŋ nukeŋ lɨlɨŋ hɨmuhɨmu hekɨlɨ agaŋ iahɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Lavɨla hameŋ laci ala lɨmi. Lɨci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ sɨhɨm sabaŋ agɨlaŋ haba hɨma fɨhalavɨmi. Agadɨ ala Isɨlaelɨ hɨdɨlɨ agɨladɨ sɨhɨm sabaŋ agɨlaŋ pabiŋ cɨki avi ma hɨmavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Lɨci manɨgali agaŋ nudɨ sibɨla hɨsɨŋ hulaŋ agɨladɨ abɨci ua igavɨla ve nudɨ abavɨmi. Isɨlaelɨ hɨdɨlɨ agɨladɨ sɨhɨm sabaŋ agɨlaŋ ma hɨmavi uavɨmi. Hameŋ abavɨci manɨgali agaŋ humɨgaŋ vɨhɨlɨ viavɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ ma valɨci uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Lɨci Asɨ Iaue Mosesɨ dɨdaŋ Alon dɨdaŋ abami. Ahica namɨlaŋ ulaŋ mu fɨli caŋ eŋala eŋala avɨŋ hɨvɨ hɨlavɨdaci vɨdɨvɨdɨŋ lɨhavɨlalɨ heŋ uhalaŋ uami. Uavɨla avɨŋ ibɨlɨ agadɨ viavɨla manɨgali dɨ pɨŋ uhalaŋ uami. Ua iahulaŋ nɨbu igasulɨdaci Mosesɨ nama avɨŋ ibɨlɨ agadɨ havalɨnaŋ iahum uami. ");
INSERT INTO ena_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Iahuavɨla avɨŋ ibɨlɨ agaŋ fɨli ibɨlɨ me sɨkasɨkan Isipɨ fɨli tɨbɨ agadɨ hafilɨbɨbali uami. Ibɨlɨ agaŋ mɨgavɨla hulaŋ iamɨgali agɨladɨ hadipɨlɨ hɨvɨ sɨhɨm sabaŋ agɨladɨ hadipɨlɨ hɨvɨ sɨkasɨkan hafilɨba fɨhalɨci hacim hekɨlɨ hekɨlɨ agɨlaŋ nulɨdɨ hadipɨlɨ hɨvɨ iahaiaha vɨkuavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Lɨci hameŋ laci ala lɨhavɨmi. Ulaŋ mu fɨli caŋ eŋala eŋala avɨŋ hɨvɨ hɨlavɨdaci vɨdɨvɨdɨŋ lɨhavɨhadami heŋ uavɨla avɨŋ ibɨlɨ agadɨ via manɨgali agadɨ pɨŋ uavɨmi. Ua lagulamavɨci manɨgali agaŋ nulɨdɨ igasulɨdaci Mosesɨ agaŋ avɨŋ ibɨlɨ agadɨ havalɨci iahumi. Lɨci avɨŋ ibɨlɨ agaŋ mɨgɨci hacim hekɨlɨ hekɨlɨ hulaŋ iamɨgali agɨladɨ hadipɨlɨ hɨvɨ sɨhɨm sabaŋ agɨladɨ hadipɨlɨ hɨvɨ iahaiaha vɨkuavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Lɨhavɨci hulaŋ hau hubɨla hubɨla hɨsɨŋ agɨlaŋ hacim daŋ hɨnihɨni Mosesɨ dɨ pɨŋ ma uavɨmi. Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ iamɨgali sɨkasɨkan hacim daŋ hacim daŋ pam hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Hacim daŋ hacim daŋ hɨniavɨdaci Asɨ Iaue nukeŋ lɨdaci manɨgali agadɨ hɨji humɨgaŋ ma iahami. Lɨci Mosesɨ dɨ ciaŋ agadɨdaŋ Alon dɨ ciaŋ agadɨdaŋ ma igahɨlami. Asɨ Iaue Mosesɨ dɨ abami hameŋ laci ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Lɨci Asɨ Iaue agaŋ Mosesɨ dɨ cɨhu ala abami. Nama cimɨdaŋ sɨbaŋ uavɨla manɨgali dɨ igavɨla nameŋ abɨha uami. Ibɨlu ciaŋ hɨsɨŋ aludɨ Asɨ Iaue agaŋ nameŋ abi aba abɨha uami. Iadɨ hulaŋ iamɨgali agɨladɨ valɨnaŋ uavɨla iadɨ ibi mɨŋaiahavɨm aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Nama hameŋ ma lɨnaŋ viaŋ abɨlɨŋ vɨhɨlɨ mu hɨdɨlɨ mu hɨdɨlɨ agɨlaŋ nadɨ hɨvɨ iahavɨbali aba abi aba abɨha uami. Hulaŋ nasaŋ hɨji igu igu hɨsɨŋ agɨladɨ hɨvɨ iahavɨbali aba abi aba abɨha uami. Nadɨ hulaŋ iamɨgali agɨladɨ hɨvɨ avi iahavɨbali aba abi aba abɨha uami. Viaŋ hameŋ lɨlɨŋ hɨji igahɨlavɨla abɨbanaŋ aba abi aba abɨha uami. Fɨli tɨbɨ mu hɨvɨ mu hɨvɨ Asɨ Iaue me agɨlaŋ ma hɨniavɨlalɨ aba abɨbanaŋ aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Viaŋ iadɨ vɨdɨvɨdɨŋ hɨvɨ nadɨdaŋ nadɨ hulaŋ iamɨgali agɨladɨdaŋ sɨbɨlɨ lamacin padaŋ namɨlaŋ hɨmuhɨmu hekɨlɨ hɨmavɨla fɨli neŋ ma hɨnivalaŋ aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Agadɨ ala viaŋ nadɨ valɨlɨŋ hɨnidanaŋ iadɨ vɨdɨvɨdɨŋ agadɨ abalamɨdalɨŋ igɨbanaŋ aba abi aba abɨha uami. Igɨdanaŋ hulaŋ iamɨgali limu hɨhɨle agɨlaŋ iadɨ ibi agasaŋ fɨli tɨbɨ mu hɨvɨ mu hɨvɨ sulasula hɨdavɨbali aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Nama nadɨ nukeŋ ibi mɨŋaiahaiaha iadɨ ciaŋ agɨladɨ lulalula hɨnilanaŋ aba abi aba abɨha uami. La iadɨ hulaŋ iamɨgali agɨladɨ ma valɨnaŋ uavi aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ci igɨnaŋ aba abi aba abɨha uami. Amɨli uaiaŋ lamɨgaŋ malɨciŋ hɨnidi nameŋ ala hɨnidaci viaŋ lɨlɨŋ avɨli vumɨli lɨba hɨlɨcɨ hɨlɨcɨ me agɨlaŋ mɨgavɨbali aba abi aba abɨha uami. Vaka Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ hɨdɨlɨ maha nɨbɨlaŋ nukeŋ nukeŋ Isipɨ fɨli tɨbɨ agadɨ migɨlavɨhadami hadɨhu avɨli vumɨli lɨba hɨlɨcɨ hɨlɨcɨ me hameŋ agɨladɨ ma igavɨhadami aba abi aba abɨha uami. La hɨdahɨda ve iabi neŋ avi hameŋ ma igavi aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Hameŋ sadaŋ nadɨ hulaŋ iamɨgali agɨladɨ abɨha aba abi aba abɨha uami. Abɨnaŋ nulɨdɨ sabaŋ bulɨmakau agɨladɨdaŋ nulɨdɨ akuaba akuaba haiabɨla hɨniavi agɨladɨdaŋ likɨla likɨla uleŋ muji lamavɨm aba abi aba abɨha uami. Viaŋ lɨlɨŋ avɨli vumɨli lɨba hɨlɨcɨ hɨlɨcɨ me agɨlaŋ mɨgavɨla hulaŋ iamɨgali sɨhɨm sabaŋ haiabɨla hɨniavi agɨladɨ ifɨcabɨlavɨci hɨmavɨbali aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Lɨci hulaŋ manɨgali saŋ hɨji igu igu hɨsɨŋ limu hɨhɨle agɨlaŋ Asɨ Iaue dɨ ciaŋ agadɨ igahɨlavɨla haba lɨdavɨmi. Lɨdavɨla nulɨdɨ sibɨla hɨsɨŋ hulaŋ limu hɨhɨle agɨladɨdaŋ nulɨdɨ sɨhɨm sabaŋ agɨladɨdaŋ likɨla likɨla uleŋ muji lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Agadɨ ala hulaŋ limu hɨhɨle agɨlaŋ Asɨ Iaue dɨ ciaŋ agasaŋ ma lɨdavɨmi. Lavɨla nulɨdɨ sibɨla hɨsɨŋ hulaŋ agɨladɨdaŋ nulɨdɨ sɨhɨm sabaŋ agɨladɨdaŋ likɨla likɨla uleŋ muji hɨvɨ ma lamavɨmi. Nulɨdɨ valavɨci haiabɨla hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Hɨniavɨdaci Asɨ Iaue Mosesɨ dɨ abami. Nadɨ human agadɨ mɨŋaiahuavɨla uaiaŋ susu hɨvɨ atɨ lamɨnaŋ avɨli vumɨli lɨba hɨlɨcɨ hɨlɨcɨ me agɨlaŋ Isipɨ fɨli tɨbɨ heŋ mɨgavɨbali uami. Lavɨla hulaŋ iamɨgali sɨhɨm sabaŋ sɨmɨŋ isabɨlaŋ hualabɨla hɨsɨŋ agɨladɨ sɨkasɨkan ifɨcabɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Lɨci Mosesɨ agaŋ nudɨ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agadɨ mɨŋaiahua uaiaŋ susu hɨvɨ atɨ lamɨci Asɨ Iaue lɨci imamulaŋ mɨŋapalɨci lɨbɨlaŋ ifami. Ifɨdaci lɨbɨlaŋ hɨlɨcɨ hɨlɨcɨ agɨlaŋ Isipɨ fɨli tɨbɨ heŋ sɨkasɨkan fɨli hɨvɨ mɨgalahɨlavɨmi. Lɨhavɨdaci avɨli vumɨli lɨba hɨlɨcɨ hɨlɨcɨ me agɨlaŋ mɨgavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Imamulaŋ mɨŋapalɨdaci lɨbɨlaŋ ifami. Ifɨdaci lɨbɨlaŋ hɨlɨcɨ hɨlɨcɨ agɨlaŋ sɨkasɨkan umi vemi. Avɨli vumɨli lɨba hɨlɨcɨ hɨlɨcɨ me agɨlaŋ mɨgamɨga Isipɨ fɨli tɨbɨ agadɨ sɨkasɨkan hafilɨba fɨhalavɨmi. Vaka Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ hɨdɨlɨ maha nɨbɨlaŋ nukeŋ nukeŋ Isipɨ fɨli tɨbɨ agadɨ migɨlavɨhadami heŋ avɨli vumɨli lɨba hɨlɨcɨ hɨlɨcɨ me hameŋ agɨladɨ ma igavɨhadami. Cɨhu hɨdahɨda ve hadɨhu laci vɨhɨlɨ hameŋ agadɨ igavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Avɨli vumɨli lɨba hɨlɨcɨ hɨlɨcɨ me agɨlaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ iamɨgali sɨhɨm sabaŋ haiabɨla hɨniavɨmi agɨladɨ sɨkasɨkan ifɨcabɨlavɨmi. Akuaba akuaba sɨmɨŋ isabɨlaŋ hualabɨla hɨvɨ hɨniavɨmi agɨladɨ sɨkasɨkan ifɨcabɨlavɨmi. Kɨlɨ huliavɨci amɨŋ lamavɨdaci navɨhadami agɨladɨ avi sɨkasɨkan ifɨcabɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Agadɨ ala Isɨlaelɨ hɨdɨlɨ hɨniavɨhadami heŋ avɨli vumɨli lɨba hɨlɨcɨ hɨlɨcɨ me agɨlaŋ ma mɨgavɨmi. Fɨli tɨbɨ agadɨ ibi Gosen. Gosen nɨbu Isipɨ fɨli tɨbɨ agadɨ limu tɨbɨ. ");
INSERT INTO ena_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Lɨci manɨgali agaŋ Mosesɨ sadaŋ Alon sadaŋ ciaŋ abɨci uci vehavɨci nulɨdɨ abami. Iabi viaŋ lusɨŋ sɨbɨlɨ vin uami. Asɨ Iaue agaŋ huaci sɨbaŋ uami. Viaŋ iadɨ hulaŋ iamɨgali agɨlaŋ hula lusɨŋ sɨbɨlɨ daŋ hɨnidalu uami. ");
INSERT INTO ena_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Lɨbɨlaŋ ifɨdaci avɨli vumɨli lɨba hɨlɨcɨ hɨlɨcɨ me agɨlaŋ mɨgavadi agasaŋ valin uami. Asɨ Iaue dɨ abɨlaŋ abamɨgɨlam uami. Hameŋ lɨci ha viaŋ naludɨ valɨlɨŋ ubalaŋ uami. Neŋ ma hɨnibalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Lɨci Mosesɨ agaŋ abami. Viaŋ nadɨ haiabɨla nagadɨ vala uavɨla iadɨ human agɨladɨ mɨŋaiahua Asɨ Iaue dɨ abɨlɨŋ lɨbɨlaŋ agadɨdaŋ avɨli vumɨli lɨba hɨlɨcɨ hɨlɨcɨ me agɨladɨdaŋ abɨci valavɨbali uami. Hameŋ lɨci nama hɨji nameŋ lamɨha uami. Fɨli nana Asɨ Iaue dɨ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Agadɨ ala viaŋ naludɨ ci igin uami. Nama hulaŋ nasaŋ hɨji igu igu hɨsɨŋ agɨlaŋ hula Asɨ Iaue saŋ ma lɨdɨlalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Avɨli vumɨli lɨba hɨlɨcɨ hɨlɨcɨ me mɨgavɨmi hadɨhu ala kɨlɨ cɨki cɨki maniahuca fu hajɨŋ daŋ me agɨlaŋ fu hajɨŋ daŋ hɨnihɨni sɨbɨlɨ lɨhavɨmi. Halɨha cahu bali agɨlaŋ avi hɨlɨcɨ saŋ fu lamavɨdaci avɨli vumɨli lɨba hɨlɨcɨ hɨlɨcɨ me agɨlaŋ lɨhavɨci sɨkasɨkan sɨbɨlɨ lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Agadɨ ala halɨha cahu uitɨ mu hɨdɨlɨ mu hɨdɨlɨ agɨlaŋ pam ma sɨbɨlɨ lɨhavɨmi. Nulɨdɨ fu mɨkɨŋ cɨki cɨki sadaŋ nɨbɨlaŋ ma sɨbɨlɨ lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Lɨhavɨci Mosesɨ agaŋ manɨgali dɨ vala haiabɨla ivouavɨla nudɨ human agɨladɨ mɨŋaiahua Asɨ Iaue dɨ abami. Lɨci lɨbɨlaŋ ifami agaŋ valami. Avɨli vumɨli lɨba hɨlɨcɨ hɨlɨcɨ me mɨgavɨmi agɨlaŋ valavɨmi. Avɨli mɨgami agaŋ avi valami. ");
INSERT INTO ena_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Lɨci manɨgali agaŋ igɨci lɨbɨlaŋ ma ifami. Avɨli vumɨli lɨba hɨlɨcɨ hɨlɨcɨ me agɨlaŋ ma mɨgavɨmi. Avɨli mɨgami agaŋ avi valami. Lɨhavɨci manɨgali agaŋ hula hulaŋ nusaŋ hɨji igu igu hɨsɨŋ agɨlaŋ hula Asɨ dɨ ciaŋ lulavɨla lusɨŋ sɨbɨlɨ cɨhu ala vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Manɨgali dɨ hɨji humɨgaŋ agaŋ ma iahami. Hameŋ sadaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ ma valɨci uavɨmi. Asɨ Iaue Mosesɨ dɨ abami hameŋ laci ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Lɨci Asɨ Iaue agaŋ Mosesɨ dɨ abami. Nama manɨgali agadɨ pɨŋ uha uami. Viaŋ lɨlɨŋ manɨgali agaŋ hulaŋ nusaŋ hɨji igu igu hɨsɨŋ agɨlaŋ hula uavauava me hɨniavɨdaci nulɨdɨ hɨji humɨgaŋ agɨlaŋ ma iahavɨbali uami. La nɨbɨlaŋ igasulavɨdaci nulɨdɨ haiabɨla heŋ viaŋ nulɨsaŋ vɨdɨvɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ abalamɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Viaŋ hameŋ lɨlɨŋ mufɨli mufɨli nama nadɨ ninadina ajihalina agɨladɨ nameŋ abɨbanaŋ uami. Asɨ agaŋ nudɨ vɨdɨvɨdɨŋ agadɨ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlasaŋ abalamɨdaci ala nɨbɨlaŋ hulaŋ uavauava me hɨnihɨni nudɨ ciaŋ ma igahɨlavɨhadami aba abɨbanaŋ uami. Hameŋ aba aba viaŋ akuaba akuaba lɨlan agasaŋ igahɨlahɨla nameŋ abɨbalaŋ uami. Asɨ Iaue nɨbu Asɨ sɨbaŋ aba abɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Lɨci Mosesɨ hula Alon hula manɨgali agadɨ pɨŋ uavɨla abavɨmi. Ibɨlu ciaŋ hɨsɨŋ aludɨ Asɨ Iaue agaŋ nameŋ abi uavɨmi. Nama akape tɨbɨ iadɨ ciaŋ agadɨ lulalula iadɨ lɨhu hɨvɨ ma hɨnilanaŋ aba abi uavɨmi. Nama iadɨ hulaŋ iamɨgali agɨladɨ valɨnaŋ uavɨla iadɨ ibi mɨŋaiahavɨm aba abi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Nama hameŋ ma lɨnaŋ viaŋ amɨli hujɨbɨlam agɨladɨ abɨlɨŋ vevɨla nadɨ fɨli tɨbɨ heŋ mɨla fɨhalavɨbali aba abi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Mɨlavɨla sɨkasɨkan hafilɨbavɨci fɨli agadɨ ma igɨbanaŋ aba abi uavɨmi. Lavɨla sɨmɨŋ isabɨlaŋ avɨli vumɨli lɨba hɨlɨcɨ hɨlɨcɨ me agɨlaŋ ma ifɨcabɨlavalɨ agɨladɨ sɨkasɨkan na fɨhalavɨbali aba abi uavɨmi. Kɨlɨ asɨŋ muvɨ iahavadi agɨladɨ avi sɨkasɨkan na fɨhalavɨbali aba abi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","7","Lɨdɨŋ nadɨ ulaŋ agɨladɨ hɨvɨ ivouavɨbali aba abi uavɨmi. Hulaŋ nasaŋ hɨji igu igu hɨsɨŋ agɨladɨ ulaŋ agɨladɨ hɨvɨ ivouavɨbali aba abi uavɨmi. Nadɨ hulaŋ iamɨgali agɨladɨ ulaŋ hɨvɨ avi ivouavɨbali aba abi uavɨmi. Vaka iagagalinalu iauacagalinalu agɨlaŋ hɨdɨlɨ maha Isipɨ fɨli tɨbɨ ve hɨniavɨhadami hadɨhu hujɨbɨlam hameŋ agɨladɨ ma igavɨhadami aba abi uavɨmi. Hɨnia veve iabi avi hujɨbɨlam hameŋ agɨladɨ ma igavɨlalɨ aba abi uavɨmi. Mosesɨ ciaŋ abɨci ci lɨci limu cimɨlavɨla vala ivoudaci hulaŋ manɨgali saŋ hɨji igu igu hɨsɨŋ agɨlaŋ nulɨdɨ manɨgali agadɨ abavɨmi. Ci igɨnaŋ uavɨmi. Mosesɨ hulaŋ iamɨgali likɨla via uu saŋ abɨdaci nama mɨlɨmɨŋɨdanaŋ alaŋ vɨhɨlɨ mu mu agɨladɨ igɨlalu uavɨmi. Hulaŋ agɨladɨ valɨnaŋ uavɨla nulɨdɨ Asɨ Iaue dɨ ibi mɨŋaiahavɨm uavɨmi. Isipɨ fɨli tɨbɨ nagaŋ ci sɨbɨlɨ sɨbaŋ ladi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Lɨhavɨci manɨgali agaŋ abɨci Mosesɨ dɨdaŋ Alon dɨdaŋ ua viavɨla nudɨ pɨŋ vavehavɨmi. Vavehavɨci manɨgali agaŋ Mosesɨ dɨdaŋ Alon dɨdaŋ abami. Namɨlaŋ uavɨla naludɨ Asɨ Iaue dɨ ibi mɨŋaiahɨhalaŋ uami. La cɨhu ala abitɨhami. Ani ani agɨlaŋ uavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Lɨci Mosesɨ nudɨ abami. Hulaŋ iamɨgali mɨnibɨlɨ agɨlaŋ hulaŋ iamɨgali hadi hadi agɨlaŋ uavɨbali uami. Ninanadi agɨlaŋ uavɨbali uami. Alaŋ ahuata hameŋ sabaŋ sipsipɨ sabaŋ bulɨmakau agɨladɨ likɨla ubalu uami. Uavɨla Asɨ Iaue dɨ ibi mɨŋaiahaiaha sɨmɨŋ hekɨlɨ hɨlanɨbalu uami. ");
INSERT INTO ena_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Lɨci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ Asɨ Iaue dɨ abacuvacuva me abami. Asɨ Iaue agaŋ Isɨlaelɨ hɨdɨlɨ namɨlaŋ hula amɨŋ hɨnici ha viaŋ naludɨdaŋ naludɨ abinadinalu ninadinalu agɨladɨdaŋ valɨlɨŋ uvalaŋ uami. Viaŋ naludɨ ci igin uami. Namɨlaŋ akuaba akuaba lusɨŋ sɨbɨlɨ viben aba lɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Viaŋ naludɨ valɨlɨŋ iamɨgali ninanadi daŋ ma ubalaŋ uami. Ha hɨma sɨbaŋ uami. Hulaŋ pam uu saŋ vɨdɨvɨdɨŋ abɨlaŋ sadaŋ hulaŋ laci uavɨla Asɨ Iaue dɨ ibi mɨŋaiahɨhalaŋ uami. Lavɨla nudɨ sibɨla hɨsɨŋ hulaŋ agɨladɨ abɨci Alon dɨdaŋ Mosesɨ dɨdaŋ lahuavɨci haiabɨla ivavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ivavehavɨci Asɨ Iaue Mosesɨ dɨ abami. Nadɨ human agadɨ mɨŋaiaha Isipɨ fɨli tɨbɨ agadɨ atɨ lamɨnaŋ hujɨbɨlam agɨlaŋ vehavɨm uami. Vevɨla sɨmɨŋ isabɨlaŋ akuaba akuaba agɨladɨ sɨkasɨkan na fɨhalavɨbali uami. Avɨli vumɨli lɨba hɨlɨcɨ hɨlɨcɨ me agɨlaŋ ma ifɨcabɨlavalɨ agɨladɨ sɨkasɨkan na fɨhalavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Lɨci Mosesɨ nudɨ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agadɨ mɨŋaiaha atɨ lamɨci Asɨ Iaue lɨci huŋe agaŋ uaiaŋ iahaiaha kɨlikɨli heŋ vemi. Huŋe veve hɨnidaci uaiaŋ pabiŋ umi. Hɨfɨlɨ pabiŋ umi. Lɨci cimɨdaŋ sɨbaŋ hujɨbɨlam agɨlaŋ vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Hujɨbɨlam akape agɨlaŋ vevɨla Isipɨ fɨli tɨbɨ agadɨ sɨkasɨkan hafilɨba fɨhalavɨmi. Vaka Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ hujɨbɨlam hameŋ agɨladɨ ma igavɨhadami. Isɨlaelɨ hɨdɨlɨ agɨlaŋ vala uavɨci avi mu tɨbɨ hɨvɨ ma igavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Hujɨbɨlam agɨlaŋ vevɨla fɨli agadɨ hafilɨba fɨhalavɨci fɨli agaŋ cɨbɨŋ hɨmavɨla hɨnimi. Lɨci fɨli agadɨ ma igavɨmi. Lɨhavɨci hujɨbɨlam agɨlaŋ sɨmɨŋ isabɨlaŋ akuaba akuaba avɨli vumɨli lɨba hɨlɨcɨ hɨlɨcɨ me agɨlaŋ ma ifɨcabɨlavɨmi agɨladɨ sɨkasɨkan na fɨhalavɨmi. Kɨlɨ avɨli vumɨli lɨba hɨlɨcɨ hɨlɨcɨ me agɨlaŋ ma ifɨcabɨlavɨmi agɨladɨ amɨŋ agɨladɨ avi na fɨhalavɨmi. Lɨhavɨci kɨlɨ asɨŋ sɨmɨŋ isabɨlaŋ humɨsɨ akuaba akuaba Isipɨ fɨli tɨbɨ hɨniavɨmi agɨlaŋ apalɨ sɨbaŋ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Lɨci manɨgali agaŋ lɨhalɨha sɨbaŋ ciaŋ abɨci uci Mosesɨ hula Alon hula vehavɨmi. Vehavɨci abami. Viaŋ naludɨ Asɨ Iaue dɨdaŋ naludɨdaŋ lusɨŋ sɨbɨlɨ viavɨla hugɨ daŋ hɨnidin uami. ");
INSERT INTO ena_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Hameŋ sadaŋ iadɨ hugɨ agadɨ hivɨhalaŋ uami. Hivavɨla naludɨ Asɨ Iaue dɨ abɨlaŋ hujɨbɨlam agɨladɨ lahuci vala uavɨm uami. Hujɨbɨlam agɨlaŋ iadɨ sɨbɨlɨ lamɨben aba lɨhavadi uami. ");
INSERT INTO ena_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Lɨci Mosesɨ hula Alon hula manɨgali agadɨ vala uavɨmi. Uavɨla Mosesɨ agaŋ Asɨ Iaue dɨ mavɨn ciaŋ ciaŋ abami. ");
INSERT INTO ena_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Abɨci Asɨ Iaue agaŋ lɨci huŋe vɨdɨvɨdɨŋ agaŋ uaiaŋ mɨgumɨgu kɨlikɨli heŋ vemi. Veve hujɨbɨlam agɨladɨ lulanikɨlɨdaci sɨkasɨkan Letɨsi avɨli hekɨlɨ heŋ uavɨmi. Lɨhavɨci Isipɨ fɨli tɨbɨ agaŋ hujɨbɨlam apalɨ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Lɨci Asɨ Iaue agaŋ nukeŋ lɨdaci manɨgali dɨ hɨji humɨgaŋ ma iahami. Hameŋ sadaŋ hulaŋ iamɨgali agɨladɨ ma valɨci uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Lɨci Asɨ Iaue agaŋ Mosesɨ dɨ abami. Nadɨ human agadɨ mɨŋaiahuavɨla atɨ lamɨnaŋ hɨfɨlɨ agaŋ Isipɨ fɨli tɨbɨ agadɨ sɨkasɨkan hafilɨbɨbali uami. Lɨci Isipɨ fɨli tɨbɨ heŋ hɨfɨlɨ hekɨlɨ mɨgɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Lɨci Mosesɨ human mɨŋaiahua atɨ lamɨci hɨfɨlɨ hekɨlɨ mɨgami. Mɨgavɨla Isipɨ fɨli tɨbɨ agadɨ sɨkasɨkan hafilɨba fɨhalɨci hɨfɨlɨ laci hɨnimi. Lavɨla ciheŋ me hɨvɨ cɨhu abɨlu havalami. ");
INSERT INTO ena_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Hɨfɨlɨ laci hɨnidaci hulaŋ iamɨgali Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ nɨbɨlaŋ nukeŋ nukeŋ igɨben aba lɨhavɨmi ala hɨma. Ma igavɨmi. Lɨci hulaŋ iamɨgali agɨlaŋ hadɨhu uleŋ muji pam hɨniavɨmi. Haiabɨla ma ivavehavɨmi. Agadɨ ala Isɨlaelɨ hɨdɨlɨ agɨlaŋ hɨniavɨmi heŋ hɨfɨlɨ agaŋ nulɨdɨ hɨvɨ ma hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Lɨci manɨgali agaŋ Mosesɨ saŋ ciaŋ abɨci uci vemi. Veci manɨgali agaŋ abami. Alia uami. Namɨlaŋ uhalaŋ uami. Uavɨla Asɨ Iaue dɨ ibi mɨŋaiahɨhalaŋ uami. Hulaŋ iamɨgali ninanadi sɨkasɨkan hameŋ uhalaŋ uami. Sabaŋ sipsipɨ sabaŋ bulɨmakau agɨladɨ laci valɨlaŋ hɨniavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Lɨci Mosesɨ cɨhu ala abami. Hɨma uami. Nama aludɨ valɨnaŋ sɨhɨm sabaŋ avi likɨla via ubalu uami. Uavɨla aludɨ Asɨ Iaue saŋ sagalɨ hɨlahɨla igubalu uami. ");
INSERT INTO ena_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Alaŋ sɨhɨm sabaŋ agɨladɨ sɨkasɨkan likɨla via ubalu uami. Pabiŋ cɨki avi ma valɨbalu uami. Sɨhɨm sabaŋ limu hɨhɨle ha aludɨ Asɨ Iaue saŋ sagalɨ hɨlahɨla igubalu uami. Alaŋ ma igalu uami. Asɨ Iaue agaŋ akɨakɨ sɨhɨm saŋ abɨbali uami. Alaŋ uavɨla Asɨ Iaue saŋ sagalɨ hɨlahɨla igu igu hɨsɨŋ fipɨ hɨvɨ iahuavɨla heŋ ala sɨhɨm sabaŋ agɨladɨ labɨlɨbalu uami. Labɨlavɨla sagalɨ igu igu saŋ hɨtɨŋ lamɨbalu uami. ");
INSERT INTO ena_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Lɨci Asɨ Iaue nukeŋ lɨdaci manɨgali agadɨ hɨji humɨgaŋ ma iahami. Hameŋ sadaŋ hulaŋ iamɨgali agɨladɨ valɨci uu saŋ hɨji ma lamami. ");
INSERT INTO ena_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Lavɨla Mosesɨ dɨ lahuavɨla abami. Nama iaha valavɨla uha uami. Nama iadɨ cɨhu cɨhu ma ve igɨbanaŋ uami. Nama cɨhu vevɨla iadɨ igɨnaŋ viaŋ nadɨ ifɨhɨmɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Lɨci Mosesɨ ciaŋ agadɨ igahɨlavɨla abami. Abɨnaŋ hameŋ laci ala lɨben uami. Viaŋ nadɨ cɨhu cɨhu ma ve igɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Lɨci Asɨ Iaue Mosesɨ dɨ abami. Cɨhu tɨbɨ viaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨdaŋ nudɨ hulaŋ iamɨgali agɨladɨdaŋ sɨbɨlɨ lamɨben uami. Hameŋ lɨlɨŋ naludɨ abɨci heŋ ubalaŋ uami. Naludɨ lahuci haiabɨla agadɨ sɨkasɨkan vala ubalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Isɨlaelɨ hɨdɨlɨ hulaŋ iamɨgali agɨladɨ abavɨla sɨkasɨkan ahuata hameŋ uhalaŋ uami. Uben aba Isipɨ fɨli tɨbɨ hɨsɨŋ naludɨ mikɨ hɨniavɨlalɨ agɨladɨ abitɨhɨhalaŋ uami. Hunaŋ lɨba silɨva hɨvɨ lɨba golɨ hɨvɨ vihavalɨ agɨlasaŋ abitɨhɨlaŋ nalusaŋ iguavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","La Asɨ Iaue agaŋ lɨci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ huaci igavɨhadami. Hulaŋ manɨgali saŋ hɨji igu igu hɨsɨŋ agɨlaŋ hula hulaŋ iamɨgali Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ hula hɨji nameŋ igahɨlavɨhadami. Mosesɨ nɨbu hulaŋ ibi daŋ uavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Lɨhavɨdaci Mosesɨ agaŋ manɨgali agadɨ abami. Ci igɨnaŋ uami. Asɨ Iaue agaŋ nameŋ abi uami. Hɨfɨlɨ alɨhaŋ hɨvɨ viaŋ Isipɨ fɨli tɨbɨ heŋ hɨdɨben aba abi uami. ");
INSERT INTO ena_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Hɨdɨdalɨŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ ninaŋ Cimegeŋ agɨlaŋ sɨkasɨkan haba hɨma fɨhalavɨbali aba abi uami. Nadɨ ninaŋ Cimegeŋ nadɨ uvɨsɨjiŋ viavɨla manɨgali hɨnivi agaŋ hɨmɨbali aba abi uami. Hɨma vioua sibɨla hɨsɨŋ iamɨgali halɨha cahu uitɨ ifɨcabɨlacabɨla sɨgɨtɨ likalavɨlalɨ agɨladɨ ninaŋ Cimegeŋ agɨlaŋ hɨmavɨbali aba abi uami. Sabaŋ bulɨmakau agɨladɨ ninaŋ manɨgali agɨlaŋ avi sɨkasɨkan hɨmavɨbali aba abi uami. ");
INSERT INTO ena_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Lɨhavɨdaci hulaŋ iamɨgali Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ sɨkasɨkan vɨhɨlɨ hekɨlɨ igavɨbali aba abi uami. Ilɨhiŋ hekɨlɨ ilɨhavɨbali aba abi uami. Vaka Isipɨ fɨli tɨbɨ heŋ ilɨhiŋ hekɨlɨ hameŋ ma ilɨhavɨmi aba abi uami. Cɨhu cɨhu hameŋ ma ilɨhavɨbali aba abi uami. ");
INSERT INTO ena_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Isɨlaelɨ hɨdɨlɨ hɨniavɨlalɨ heŋ ilɨhiŋ hekɨlɨ ma ilɨhavɨbali aba abi uami. Iŋam agɨlaŋ hulaŋ iamɨgali agɨladɨ iga iga mau ma ifavɨbali aba abi uami. Sɨhɨm sabaŋ agɨladɨ avi iga iga mau ma ifavɨbali aba abi uami. Hameŋ lɨhavɨci igavɨla hɨji nameŋ lamɨhalaŋ aba abi uami. Asɨ Iaue agaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ sɨbɨlɨ lami aba abɨhalaŋ aba abi uami. Isɨlaelɨ hɨdɨlɨ agɨladɨ ma sɨbɨlɨ lami aba abɨhalaŋ aba abi uami. ");
INSERT INTO ena_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Lavɨla Mosesɨ agaŋ cɨhu ala abami. Manɨgali uami. Hulaŋ nasaŋ hɨji igu igu hɨsɨŋ nagɨlaŋ vevɨla mavɨn ciaŋ ciaŋ abɨbalu aba iadɨ hɨcɨ mikɨ pɨŋ mɨgalɨfɨlɨbavɨla abavɨbali uami. Nadɨ hulaŋ iamɨgali hula uhalaŋ aba abavɨbali uami. Hameŋ lɨlaŋ akuaba akuaba agɨlaŋ iahavɨci viaŋ heŋ Isipɨ fɨli tɨbɨ agadɨ vala uben uami. Lavɨla manɨgali saŋ igɨvɨ hɨniavɨla nudɨ valavɨla haiabɨla ivavemi. ");
INSERT INTO ena_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Lɨci Asɨ Iaue Mosesɨ dɨ abami. Manɨgali agaŋ nadɨ ciaŋ ma igahɨlɨbali uami. Hameŋ lɨdaci viaŋ vɨdɨvɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ Isipɨ fɨli tɨbɨ heŋ abalamɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mosesɨ hula Alon hula vɨdɨvɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ manɨgali saŋ abalamavɨdaci igami ala hɨma. Asɨ Iaue nukeŋ lɨdaci manɨgali dɨ hɨji humɨgaŋ agaŋ ma iahadami. Hameŋ sadaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ ma valɨci uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Mosesɨ hula Alon hula Isipɨ fɨli tɨbɨ hɨniavɨdaci Asɨ Iaue agaŋ nulɨdɨ abami. ");
INSERT INTO ena_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","3","Avaŋ nagadɨ hɨvɨ hɨdɨlɨ maha avaŋ agɨladɨ lugɨlɨhalaŋ uami. Lugɨla lugɨla vio fɨhalɨlaŋ hualɨ mu heŋ avaŋ ibi nameŋ agaŋ ala cɨhu iahɨci Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨhalaŋ uami. Avaŋ iahi nagaŋ hɨdɨdaci uaiaŋ human limu fɨhala human limu ahica pam cɨjɨŋ uci hulaŋ pabiŋ pabiŋ sabaŋ sipsipɨ ninaŋ ua sabaŋ meme ninaŋ agɨladɨ hɨtɨŋ hɨtɨŋ vihalaŋ aba abɨhalaŋ uami. Ulaŋ pam hɨnilalaŋ namɨlaŋ hɨtɨŋ hɨtɨŋ sɨhɨm hameŋ agɨladɨ vihalaŋ aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Naludɨ iamɨgali ninanadi agɨladɨ igɨlaŋ sɨhɨm sabaŋ agadɨ ma na fɨhala fɨhala me hɨniavɨci aba abɨhalaŋ uami. Ha naludɨ ulaŋ mikɨ hɨsɨŋ agɨladɨ abɨlaŋ vehavɨci hudɨmɨda hameŋ hafalavɨla heŋ nɨhalaŋ aba abɨhalaŋ uami. Hudɨmɨda hafalavɨci ulaŋ iaganu agaŋ lugɨlɨci valɨ vameba iahɨci heŋ sɨhɨm agadɨ lamɨci na fɨhalɨhalaŋ aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Sabaŋ sipsipɨ ninaŋ muŋaŋ ua sabaŋ meme ninaŋ muŋaŋ numɨgaŋ huhɨlɨci hualɨ pabiŋ ci ualɨ agadɨ igavɨla vihalaŋ aba abɨhalaŋ uami. Namɨlaŋ sabaŋ sipsipɨ ua sabaŋ meme fim akuaba akuaba apalɨ agɨladɨ igavɨla vihalaŋ aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Sabaŋ sipsipɨ ua sabaŋ meme agadɨ sɨhɨvia sɨbaŋ igasulasula hɨnihalaŋ aba abɨhalaŋ uami. Igasulasula hɨnidalaŋ uaiaŋ ahica pam uci hadɨhu laci ala sabaŋ sipsipɨ sabaŋ meme agɨladɨ hɨfɨlɨdaŋ sɨbaŋ hɨvɨ ifɨhɨmuhɨmu uhalaŋ aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Lavɨla sabaŋ sipsipɨ sabaŋ meme mɨdɨ agɨladɨ vihalaŋ aba abɨhalaŋ uami. Vivi ulaŋ namɨlaŋ hɨnihɨni nɨbalaŋ agɨladɨ hɨbɨ ivu ivu hɨvɨ hɨda ahica limu limu hɨniavi agɨladɨ hɨvɨ mɨŋepɨhalɨhalaŋ aba abɨhalaŋ uami. La ulaŋ hɨbɨ ivu ivu hɨvɨ iahua sabɨ kɨlɨ cɨkaŋ agadɨ hɨlihua lamavɨci hɨniavi agɨladɨ avi mɨŋepɨhalɨhalaŋ aba abɨhalaŋ uami. Lavɨla uleŋ muji heŋ sɨhɨm sabaŋ agɨladɨ nɨhalaŋ aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Hɨfɨlɨ heŋ laci ala namɨlaŋ sabaŋ sipsipɨ ua sabaŋ meme hɨlɨcɨ agɨladɨ avɨŋ hɨvɨ hɨlɨhalaŋ aba abɨhalaŋ uami. Maci sakɨvakɨva agɨladɨdaŋ isabɨlaŋ hitaŋ daŋ agɨladɨdaŋ avi hɨlɨhalaŋ aba abɨhalaŋ uami. Hɨlahɨla nɨhalaŋ aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Sɨhɨm agɨladɨ hɨhi nɨmɨlaŋ aba abɨhalaŋ uami. Sɨji hɨvɨ avi hugɨlɨmɨlaŋ aba abɨhalaŋ uami. Avɨŋ hɨvɨ pam hɨlahɨla nɨhalaŋ aba abɨhalaŋ uami. Sɨhɨm hali hɨcɨ human sucɨki akuaba akuaba agɨladɨ avi sɨkasɨkan hɨlahɨla nɨhalaŋ aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Sɨhɨm hɨlɨcɨ limu hɨhɨle amɨli me saŋ valɨmɨlaŋ aba abɨhalaŋ uami. Valavɨla ha amɨli me hɨvɨ sɨkasɨkan avɨŋ hɨvɨ lamɨlaŋ lɨhua fɨhalavɨm aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Sɨhɨm agɨladɨ nɨben aba namɨlaŋ nameŋ lɨhalaŋ aba abɨhalaŋ uami. Havɨlɨ lɨbavɨla hɨcɨ sɨgɨtɨ lamɨhalaŋ aba abɨhalaŋ uami. Naludɨ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agɨladɨ mɨŋalɨvavɨla lɨhalɨha navɨhehalaŋ aba abɨhalaŋ uami. Sɨmɨŋ nana hɨsɨŋ mɨhiŋ ha Asɨ Iaue agaŋ Isɨlaelɨ hɨdɨlɨ naludɨ valɨci huaci hɨnibalaŋ agadɨ mɨhiŋ hekɨlɨ aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Lavɨla cɨhu ala abami. Hɨfɨlɨ heŋ viaŋ Isipɨ fɨli tɨbɨ hɨdɨben uami. Hɨdahɨda ninaŋ manɨgali Cimegeŋ agɨladɨdaŋ sabaŋ sipsipɨ ninaŋ sabaŋ bulɨmakau ninaŋ manɨgali agɨladɨdaŋ sɨkasɨkan ifɨhɨma fɨhalɨben uami. Viaŋ Asɨ Iaue uami. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ mugɨluŋ agɨladɨ avi sɨbɨlɨ lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Sɨhɨm mɨdɨ agadɨ naludɨ ulaŋ hɨtɨŋ hɨtɨŋ hɨvɨ mɨŋepɨhalɨlaŋ ha viaŋ naludɨ ulaŋ agɨladɨ iga iga valɨdalɨŋ namɨlaŋ huaci hɨnibalaŋ uami. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ sɨbɨlɨ lamɨben uami. Agadɨ ala naludɨ ma sɨbɨlɨ lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Mɨhiŋ hekɨlɨ nana viaŋ Isɨlaelɨ hɨdɨlɨ naludɨ valɨlɨŋ huaci hɨnibalaŋ agasaŋ hɨji lamalama iadɨ ibi mɨŋaiahaiaha sɨmɨŋ hekɨlɨ hɨlanɨhalaŋ uami. Hulaŋ iamɨgali mufɨli mufɨli iahavɨbali agɨlaŋ avi hualɨ pabiŋ pabiŋ hɨvɨ mɨhiŋ hekɨlɨ agadɨ hɨvɨ hameŋ laci hameŋ laci lɨhavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Lavɨla Asɨ Iaue cɨhu Mosesɨ dɨdaŋ Alon dɨdaŋ abami. Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨhalaŋ uami. Maci sakɨvakɨva nana hɨnidalaŋ uaiaŋ human limu fɨhala human limu pabiŋ cɨjɨŋ um aba abɨhalaŋ uami. Hɨdɨlɨ maha maci sakɨvakɨva nɨben aba maci huhɨla huhɨla hɨsɨŋ isɨ aba abavɨlalɨ agɨladɨ sɨkasɨkan havalɨlaŋ uavɨm aba abɨhalaŋ uami. Naludɨ ulaŋ hɨvɨ valɨlaŋ hɨniavɨmɨdɨ aba abɨhalaŋ uami. Maci sakɨvakɨva nana hɨnibalaŋ hadɨhu naludɨ hulaŋ mu agaŋ maci huhɨla huhɨla hɨsɨŋ isɨ aba abavɨlalɨ agɨladɨ nɨci ha Isɨlaelɨ hɨdɨlɨ namɨlaŋ nudɨ lahulaŋ um aba abɨhalaŋ uami. Namɨlaŋ hula hɨnimɨdɨ aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Hɨdɨlɨ maha maci sakɨvakɨva nɨbalaŋ heŋ akuaba akuaba sibɨla vimɨlaŋ aba abɨhalaŋ uami. Namɨlaŋ sɨkasɨkan mɨgudɨbavɨla Asɨ dɨ ibi pam mɨŋaiahɨhalaŋ aba abɨhalaŋ uami. La cɨhu uaiaŋ human limu fɨhala uci cɨhu ala heŋ mɨgudɨbavɨla Asɨ dɨ ibi mɨŋaiahɨhalaŋ aba abɨhalaŋ uami. Uaiaŋ heŋ avi namɨlaŋ akuaba akuaba sibɨla vimɨlaŋ aba abɨhalaŋ uami. Sɨmɨŋ akuaba akuaba agɨladɨ pam huaci hɨlanɨbalaŋ aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Uaiaŋ heŋ laci ala Asɨ Iaue Isɨlaelɨ hɨdɨlɨ hɨtɨŋ hɨtɨŋ hɨniavɨlalɨ agɨladɨ likɨla Isipɨ fɨli tɨbɨ vala uavɨbali agasaŋ igahɨlavɨm aba abɨhalaŋ uami. Hualɨ pabiŋ pabiŋ hɨvɨ maci sakɨvakɨva nana hɨsɨŋ mɨhiŋ hekɨlɨ agaŋ hameŋ laci hameŋ laci hɨnibali aba abɨhalaŋ uami. Hulaŋ iamɨgali mufɨli mufɨli iahavɨbali agɨlaŋ hualɨ pabiŋ pabiŋ hɨvɨ mɨhiŋ hekɨlɨ agadɨ hɨvɨ hameŋ laci hameŋ laci lɨhavɨbali aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Hualɨ mu heŋ avaŋ sebɨlɨ iaha hɨdɨdaci uaiaŋ human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ uci hɨfɨlɨdaŋ hɨdɨlɨ maha maci sakɨvakɨva nɨhalaŋ aba abɨhalaŋ uami. Nana hɨnidalaŋ uaiaŋ human limu fɨhala human limu pabiŋ cɨjɨŋ uci cɨhu uaiaŋ mu hɨvɨ hɨfɨlɨdaŋ heŋ valɨbalaŋ aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Uaiaŋ human limu fɨhala human limu ahica cɨjɨŋ maci sakɨvakɨva nɨbalaŋ heŋ maci huhɨla huhɨla hɨsɨŋ isɨ aba abavɨlalɨ agɨlaŋ naludɨ ulaŋ hɨvɨ hɨniavɨmɨdɨ aba abɨhalaŋ uami. Naludɨ hulaŋ mu agaŋ maci huhɨla huhɨla hɨsɨŋ isɨ aba abavɨlalɨ agɨladɨ nɨci aba abɨhalaŋ uami. Ha Isɨlaelɨ hɨdɨlɨ namɨlaŋ nudɨ lahulaŋ um aba abɨhalaŋ uami. Hulaŋ mu ihɨlɨŋ ve namɨlaŋ hula hɨnilalɨ agaŋ maci huhɨla huhɨla hɨsɨŋ isɨ aba abavɨlalɨ agɨladɨ nɨci ha nudɨ avi lahulaŋ um aba abɨhalaŋ uami. Namɨlaŋ hula hɨniavɨmɨdɨ aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Namɨlaŋ abeba abeba hɨnibalaŋ ala maci huhɨla huhɨla hɨsɨŋ isɨ aba abavɨlalɨ agɨladɨ nɨmɨlaŋ aba abɨhalaŋ uami. Maci sakɨvakɨva laci nɨhalaŋ aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Lɨci Mosesɨ agaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ hulaŋ hekɨlɨ hekɨlɨ agɨlasaŋ ciaŋ iguci umi. Lɨci vehavɨci abami. Namɨlaŋ uavɨla sabaŋ sipsipɨ ninaŋ ua sabaŋ meme ninaŋ agɨladɨ lɨbɨmɨŋɨhalaŋ uami. Asɨ agaŋ Isɨlaelɨ hɨdɨlɨ naludɨ valɨci huaci hɨnibalaŋ agasaŋ igahɨlavɨla naludɨ ulaŋ pam hɨsɨŋ agɨlaŋ hula sɨhɨm sabaŋ agɨladɨ ifɨhɨmuhɨmu uavɨla mɨgahɨnia hɨlanɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ifɨhɨmuhɨmu mɨdɨ agɨladɨ hunaŋ hɨvɨ mɨŋamɨjidalaŋ mɨguavɨdaci isabɨlaŋ hisopɨ makaŋ agɨladɨ vivi mɨdɨ hunaŋ heŋ lɨbɨvisavisa ulaŋ hɨbɨ ivu ivu agɨladɨ hɨda ahica limu limu hɨniavi heŋ mɨŋepɨhalɨhalaŋ uami. La hɨbɨ ivu ivu hɨvɨ iahua sabɨ kɨlɨ cɨkaŋ hɨlihua lamavalɨ agɨladɨ hɨvɨ avi mɨŋepɨhalɨhalaŋ uami. Lavɨla namɨlaŋ haiabɨla ivavemɨlaŋ uami. Hameŋ hɨnidalaŋ fɨli mɨŋalahɨci amɨli cimɨdaŋ pam haiabɨla ivavebalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Asɨ Iaue agaŋ Isipɨ fɨli tɨbɨ hɨdahɨda nudɨ ciaŋ hali hɨsɨŋ agadɨ abɨdaci ninaŋ Cimegeŋ agɨladɨ sɨkasɨkan ifɨhɨma fɨhalɨbali uami. Lɨdaci Asɨ Iaue agaŋ sɨhɨm mɨdɨ naludɨ ulaŋ hɨbɨ ivu ivu caba hɨvɨ mɨŋepɨhalɨbalaŋ agɨladɨ iga iga naludɨ ulaŋ agɨladɨ lɨvalavɨbali uami. Lɨhavɨdaci naludɨ ninaŋ Cimegeŋ agɨlaŋ ma hɨmavɨbali uami. Ulaŋ mɨdɨ apalɨ agɨladɨ iga iga nudɨ ciaŋ hali hɨsɨŋ agadɨ abɨdaci uleŋ muji ivo ivo ninaŋ Cimegeŋ agɨladɨ ifɨhɨmɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Asɨ naludɨ ninaŋ Cimegeŋ agɨladɨ valɨci huaci hɨniavɨbali agasaŋ igahɨlɨbalaŋ uami. Igahɨlahɨla hualɨ pabiŋ pabiŋ hɨvɨ naludɨ ninanadi agɨlaŋ hula sɨmɨŋ hekɨlɨ hɨlahɨla nɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Asɨ Iaue agaŋ fɨli tɨbɨ nalusaŋ igu igu saŋ abami heŋ mufɨli ivo hɨnibalaŋ uami. Ivo hɨnihɨni sɨmɨŋ hekɨlɨ hɨlanana Asɨ naludɨ valɨci huaci hɨnibalaŋ agasaŋ igahɨlahɨla nudɨ ibi mɨŋaiahaiaha hɨnibalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Mufɨli mufɨli naludɨ ninadinalu agɨlaŋ nameŋ abitɨhavɨbali uami. Akɨ saŋ sɨmɨŋ hameŋ hɨlahɨla nɨlalu aba abavɨbali uami. Hameŋ abavɨdaci namɨlaŋ nulɨdɨ nameŋ abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Alaŋ Isipɨ fɨli tɨbɨ hɨnidamɨli Asɨ Iaue agaŋ nudɨ ciaŋ hali hɨsɨŋ agadɨ abɨdaci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ uleŋ muji ivo ivo nulɨdɨ ninaŋ Cimegeŋ agɨladɨ pam ifɨhɨmami aba abɨhalaŋ uami. Agadɨ ala Isɨlaelɨ hɨdɨlɨ aludɨ ulaŋ agɨladɨ lɨvalami aba abɨhalaŋ uami. La aludɨ ninaŋ Cimegeŋ agɨladɨ valɨdaci huaci hɨniavɨmi aba abɨhalaŋ uami. Hameŋ lɨmi agasaŋ hɨji lamalama hɨnihɨni Asɨ saŋ sagalɨ igulalu aba abɨhalaŋ uami. Lɨci hulaŋ iamɨgali ciaŋ agadɨ igahɨlavɨla Asɨ dɨ ibi mɨŋaiahɨben aba hali lɨbuhɨlavɨla mɨgalɨfɨlɨbavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","La cɨhu hadɨhu laci ala iaha uavɨla Asɨ Iaue agaŋ Mosesɨ dɨdaŋ Alon dɨdaŋ abami hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Lɨhavɨci hɨfɨlɨ hekɨlɨ heŋ ala Asɨ Iaue agaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ ninaŋ Cimegeŋ nudɨ uvɨsɨjiŋ vivi agadɨ ifɨhɨmami. Ifɨhɨmuhɨmu uu hulaŋ lɨmɨn sɨbɨlɨ ulaŋ hɨniavɨmi agɨladɨ ninaŋ Cimegeŋ agɨladɨ ifɨhɨma fɨhalami. Ninaŋ Cimegeŋ agɨladɨ sɨkasɨkan ifɨhɨma fɨhalami. Sabaŋ bulɨmakau ninaŋ manɨgali agɨladɨ avi sɨkasɨkan ifɨhɨma fɨhalami. ");
INSERT INTO ena_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Lɨci hɨfɨlɨ heŋ laci ala manɨgali agaŋ hulaŋ nusaŋ hɨji igu igu hɨsɨŋ agɨlaŋ hula iahaiaha igavɨmi. Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ iamɨgali agɨlaŋ avi iahaiaha igavɨmi. Igavɨci ninaŋ Cimegeŋ agɨlaŋ pam haba hɨma fɨhalavɨmi. Lɨhavɨdaci Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ iamɨgali sɨkasɨkan ilɨhiŋ hekɨlɨ ilɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ilɨha ilɨha hɨniavɨdaci hɨfɨlɨ heŋ ala manɨgali agaŋ Mosesɨ sadaŋ Alon sadaŋ ciaŋ abɨci uci vehavɨci abami. Namɨlaŋ naludɨ hulaŋ iamɨgali agɨlaŋ hula iahavɨla aludɨ valavɨla uhalaŋ uami. Namɨlaŋ aludɨ vala uavɨla iadɨ abahalaŋ hameŋ ala naludɨ Asɨ Iaue dɨ ibi mɨŋaiahɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Naludɨ sabaŋ sipsipɨ sabaŋ meme sabaŋ bulɨmakau agɨladɨ likɨlavɨla Isipɨ fɨli tɨbɨ nagadɨ sɨkasɨkan vala uhalaŋ uami. Uavɨla Asɨ dɨ abɨlaŋ iadɨ avi huaci lamam uami. ");
INSERT INTO ena_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ hɨji nameŋ lamavɨla abavɨmi. Aludɨ lɨhalɨha ma vala uavɨci ha alaŋ sɨkasɨkan haba hɨma fɨhalɨbalu uavɨmi. Lavɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ aba lɨbɨsɨlɨvavɨla abavɨmi. Namɨlaŋ Isipɨ fɨli tɨbɨ nagadɨ lɨhalɨha vala uhalaŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Hameŋ abavɨci Isɨlaelɨ hɨdɨlɨ agɨlaŋ maci agɨladɨ viavɨla hunaŋ hɨvɨ lamavɨci mɨguavɨci hunaŋ agɨladɨ havɨlɨ hɨvɨ haha lalɨguavɨla via havavɨla uavɨmi. Maci via uavɨmi agaŋ huhɨla huhɨla hɨsɨŋ isɨ aba abavɨlalɨ agaŋ apalɨ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Lɨci uben aba lavɨla Isɨlaelɨ hɨdɨlɨ agɨlaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ hunaŋ lɨba silɨva hɨvɨ lɨba golɨ hɨvɨ vihavɨmi agɨlasadaŋ muhɨlɨ havɨlɨ agɨlasadaŋ abitɨhavɨmi. Mosesɨ abami hameŋ ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Lɨhavɨci Asɨ Iaue agaŋ lɨci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ huaci igavɨmi. Lɨhavɨci Isɨlaelɨ hɨdɨlɨ agɨlaŋ akuaba akuaba saŋ nulɨdɨ abitɨhavɨci iguavɨmi. Igu fɨhalavɨla cɨhu Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ akuaba akuaba apalɨ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Isɨlaelɨ hɨdɨlɨ agɨlaŋ iaha Lamesesɨ haiabɨla agadɨ vala uavɨmi. Uavɨla Sukotɨ haiabɨla ua iahuavɨmi. Hulaŋ agɨladɨ pam lugɨlavɨci ua 600,000 iahami. Iamɨgali ninanadi avi uavɨmi ala nulɨdɨ ma lugɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Nulɨdɨ sabaŋ sipsipɨ sabaŋ meme sabaŋ bulɨmakau sɨkasɨkan hameŋ likɨlavɨla uavɨmi. Hulaŋ iamɨgali hɨdɨlɨ mu mu nɨbɨlaŋ hula hɨniavɨhadami agɨlaŋ avi nɨbɨlaŋ hula uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ aba lɨbɨsɨlɨvavɨci lɨhalɨha sɨbaŋ iaha uavɨmi. Sɨmɨŋ akuaba akuaba agɨladɨ ma sɨhuva via uavɨmi. Maci huhɨla huhɨla hɨsɨŋ isɨ aba abavɨhadami agadɨ maci hɨvɨ ma mɨŋamɨjiavɨci mɨguci eŋalavɨla via uavɨmi. Maci sakɨvakɨva laci via uavɨla hɨlanavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Isɨlaelɨ hɨdɨlɨ agɨlaŋ Isipɨ fɨli tɨbɨ hɨniavɨdaci hualɨ 430 umi. ");
INSERT INTO ena_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Hualɨ hameŋ u fɨhalɨci uaiaŋ heŋ ala Asɨ Iaue agaŋ Isɨlaelɨ hɨdɨlɨ hɨtɨŋ hɨtɨŋ hɨniavɨhadami agɨladɨ likɨlɨci Isipɨ fɨli tɨbɨ agadɨ vala uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Hɨfɨlɨ heŋ ala Asɨ Iaue agaŋ nudɨ hulaŋ iamɨgali Isipɨ fɨli tɨbɨ heŋ hɨniavɨmi agɨladɨ likɨla via sɨhɨvia sɨbaŋ migɨlɨdaci uavɨmi. Lavɨla Isɨlaelɨ hɨdɨlɨ agɨlaŋ Asɨ Iaue lɨmi agasaŋ igahɨlahɨla hameŋ laci hameŋ laci nudɨ ibi mɨŋaiahaiaha hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","La Asɨ Iaue agaŋ Mosesɨ dɨdaŋ Alon dɨdaŋ abami. Viaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ valɨlɨŋ huaci hɨnihɨni sɨmɨŋ nana hɨsɨŋ mɨhiŋ hekɨlɨ agadɨ ciaŋ vɨdɨvɨdɨŋ nɨbu nameŋ hɨnibali uami. Hulaŋ iamɨgali fɨli tɨbɨ mu hɨsɨŋ agɨlaŋ sɨmɨŋ agadɨ navɨmɨdɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","45","Hulaŋ namɨlaŋ hula ilɨmiŋ hɨniavɨlalɨ agɨlaŋ hula anɨm hɨlɨcɨ sibɨla vivi hɨniavɨlalɨ agɨlaŋ hula avi sɨmɨŋ agadɨ navɨmɨdɨ uami. Hulaŋ limu hɨhɨle agɨladɨ anɨm hɨlɨcɨ hɨvɨ lavɨlaŋ naludɨ sibɨla hɨsɨŋ hɨniavɨlalɨ agɨladɨ hadi sɨbɨlɨ ihalahɨlaŋ ha sɨmɨŋ agadɨ huaci navɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Hulaŋ iamɨgali agɨlaŋ sɨhɨm agadɨ nɨbalu aba ha ulaŋ sɨmɨŋ nana saŋ sɨhuvavɨmi heŋ hɨnihɨni navɨm uami. Sɨmɨŋ limu hɨhɨle viavɨla haiabɨla ivavehavɨmɨdɨ uami. La sɨhɨm henaŋ agɨladɨ avi lɨlaŋ lɨfavɨmɨdɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Isɨlaelɨ hɨdɨlɨ namɨlaŋ sɨkasɨkan sɨmɨŋ agadɨ hameŋ laci lɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Hulaŋ hɨdɨlɨ mu ihɨlɨŋ vevɨla namɨlaŋ hula hɨniavɨlalɨ agɨlaŋ sɨmɨŋ agadɨ navɨmɨdɨ uami. Nɨbɨlaŋ mɨhiŋ hekɨlɨ hɨsɨŋ sɨmɨŋ agadɨ via nɨbalu aba lɨhavɨci uami. Ha namɨlaŋ nulɨdɨ hadi sɨbɨlɨ sɨkasɨkan ihalahɨhalaŋ uami. Hadi sɨbɨlɨ ihalaha fɨhalɨlaŋ ha hulaŋ agɨlaŋ namɨlaŋ me sɨbaŋ hɨniavɨbali uami. La sɨmɨŋ agadɨ huaci navɨbali uami. Hulaŋ hadi sɨbɨlɨ ma ihalahavɨlalɨ agɨlaŋ sɨmɨŋ agadɨ navɨmɨdɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Isɨlaelɨ hɨdɨlɨ namɨlaŋ ciaŋ lamalubidin nagadɨ sɨhɨvia sɨbaŋ lubiahɨlɨhalaŋ uami. Hɨdɨlɨ mu ihɨlɨŋ vevɨla namɨlaŋ hula hɨniavɨlalɨ agɨlaŋ ciaŋ hameŋ laci ala lubiahɨlavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Lɨci Isɨlaelɨ hɨdɨlɨ agɨlaŋ Asɨ Iaue Mosesɨ dɨdaŋ Alon dɨdaŋ abami hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Lɨhavɨdaci uaiaŋ heŋ laci ala Asɨ Iaue agaŋ Isɨlaelɨ hɨdɨlɨ hɨtɨŋ hɨtɨŋ hɨniavɨhadami agɨladɨ likɨlɨci Isipɨ fɨli tɨbɨ vala uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Lɨhavɨdaci Asɨ Iaue Mosesɨ dɨ abami. ");
INSERT INTO ena_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Naludɨ ninaŋ Cimegeŋ agɨladɨ lɨbɨmɨŋamɨŋa abɨhalaŋ uami. Nan Asɨ Iaue dɨ aba abɨhalaŋ uami. La naludɨ sɨhɨm sabaŋ ninaŋ manɨgali muŋaŋ agɨladɨ avi lɨbɨmɨŋamɨŋa abɨhalaŋ uami. Nan Asɨ Iaue dɨ aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Lɨci Mosesɨ agaŋ hulaŋ iamɨgali agɨladɨ abami. Namɨlaŋ Isipɨ fɨli tɨbɨ neŋ lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ me hɨnihɨni sibɨla vilalaŋ uami. Vivi hɨnidalaŋ Asɨ Iaue agaŋ nudɨ nukeŋ vɨdɨvɨdɨŋ hɨvɨ naludɨ likɨlɨci Isipɨ fɨli tɨbɨ vala ubalaŋ uami. Hameŋ sadaŋ mufɨli mufɨli namɨlaŋ mɨhiŋ nagasaŋ hɨji lamɨhalaŋ uami. Lɨdɨŋ maci nɨbalu aba maci huhɨla huhɨla hɨsɨŋ isɨ aba abavɨlalɨ agadɨdaŋ nɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Iabi avaŋ Abipɨ hɨvɨ Isipɨ fɨli tɨbɨ nagadɨ vala uadalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Asɨ Iaue agaŋ hɨvɨ hekɨlɨ aba abavɨla naludɨ iamɨlɨhalinalu dɨ abami uami. Kenan hɨdɨlɨ Hitɨ hɨdɨlɨ Amolɨ hɨdɨlɨ Hivɨ hɨdɨlɨ Jebusɨ hɨdɨlɨ agɨladɨ fɨli tɨbɨ nalusaŋ iguben aba abami uami. Fɨli agaŋ huaci sɨbaŋ aba abami uami. Sɨmɨŋ isabɨlaŋ huliavɨdaci huaci laci iahavɨlalɨ aba abami uami. Asɨ Iaue naludɨ likɨla via ua fɨli tɨbɨ heŋ ala lamɨci hɨnibalaŋ uami. Hɨnihɨni namɨlaŋ hualɨ pabiŋ pabiŋ avaŋ heŋ laci ala mɨhiŋ hekɨlɨ agasaŋ maci sakɨvakɨva hɨlahɨla nɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","7","Maci sakɨvakɨva laci nana hɨnidalaŋ uaiaŋ human limu fɨhala um uami. Lɨci amɨli me hɨvɨ maci sakɨvakɨva sijaŋ nana Asɨ Iaue dɨ ibi mɨŋaiahaiaha sɨmɨŋ hekɨlɨ hɨlanɨhalaŋ uami. Maci huhɨla huhɨla hɨsɨŋ agadɨ mɨŋamɨjiavɨci mɨguci eŋala hɨlavɨlalɨ agɨladɨdaŋ maci huhɨla huhɨla hɨsɨŋ isɨ aba abavɨlalɨ agadɨdaŋ valɨlaŋ naludɨ fɨli tɨbɨ heŋ hɨniavɨmɨdɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Maci sakɨvakɨva nana hɨsɨŋ mɨhiŋ hekɨlɨ agaŋ iahɨci naludɨ ninanadi agɨladɨ nameŋ abɨhalaŋ uami. Mɨhiŋ hekɨlɨ nana Asɨ Iaue agaŋ aludɨ likɨlɨci Isipɨ fɨli tɨbɨ vala vemɨlu agasaŋ hameŋ lɨlalu aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Mɨhiŋ hekɨlɨ agasaŋ igahɨlahɨla Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agadɨ lɨbalɨba hɨbɨn hɨbɨn cɨki cɨki hɨvɨ lamɨhalaŋ uami. Lamalama hɨbɨn hɨbɨn cɨki cɨki agɨladɨdaŋ vivi naludɨ lɨbam hɨvɨ human hɨvɨ lɨbɨhahɨhalaŋ uami. Lɨbɨhahahaha nulɨdɨ iga iga Asɨ Iaue ciaŋ lamalubilɨ agasaŋ aba aba hɨnihalaŋ uami. Asɨ Iaue nudɨ nukeŋ vɨdɨvɨdɨŋ hɨvɨ naludɨ likɨlɨci Isipɨ fɨli tɨbɨ vala ubalaŋ agasaŋ aba aba hɨnihalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Namɨlaŋ Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ lubiahɨlahɨla hualɨ pabiŋ pabiŋ hɨvɨ sɨmɨŋ hekɨlɨ nana lakuku heŋ hameŋ laci hameŋ laci lɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Lɨci Mosesɨ nulɨdɨ abami. Asɨ Iaue agaŋ nalusadaŋ naludɨ iamɨlɨhalinalu sadaŋ hɨvɨ hekɨlɨ aba abavɨla fɨli tɨbɨ igu igu saŋ abami uami. Lavɨla nudɨ nukeŋ ciaŋ lubiahɨlavɨla naludɨ likɨla Kenan hɨdɨlɨ agɨladɨ fɨli tɨbɨ heŋ via ubali uami. La fɨli tɨbɨ agadɨ nalusaŋ igubali uami. ");
INSERT INTO ena_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Fɨli tɨbɨ agadɨ nalusaŋ iguci namɨlaŋ ninaŋ Cimegeŋ agɨladɨ lɨbɨmɨŋamɨŋa abɨhalaŋ uami. Nan Asɨ Iaue dɨ aba abɨhalaŋ uami. Sɨhɨm sabaŋ ninaŋ manɨgali muŋaŋ agɨladɨ avi Asɨ Iaue saŋ lɨbɨmɨŋamɨŋa abɨhalaŋ uami. Nan Asɨ Iaue dɨ aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Sabaŋ donɨki ninaŋ manɨgali agadɨ ifɨhɨmuhɨmu saŋ valavɨla uami. Ha nudɨ uvɨsɨjiŋ vivi saŋ sabaŋ sipsipɨ ninaŋ muŋaŋ agadɨ ifɨhɨma lamavɨla sagalɨ hɨla iguhalaŋ uami. Sabaŋ donɨki ninaŋ manɨgali agadɨ uvɨsɨjiŋ vivi saŋ valavɨla uami. Ha sabaŋ donɨki ninaŋ manɨgali agadɨ sakum hɨvɨ mɨŋa mafɨlavɨci hɨmɨbali uami. Ninaŋ Cimegeŋ agadɨ uvɨsɨjiŋ vivi saŋ sabaŋ sipsipɨ ninaŋ muŋaŋ agadɨ ifɨhɨma lamavɨla sagalɨ hɨla iguhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Mufɨli naludɨ ninanadi agɨlaŋ nameŋ abitɨhavɨbali uami. Akɨ hɨdɨlɨ saŋ hameŋ lɨlalaŋ aba abavɨbali uami. Hameŋ abavɨci namɨlaŋ nameŋ abɨhalaŋ uami. Alaŋ Isipɨ fɨli tɨbɨ heŋ lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ me hɨnihɨni sibɨla vihadamɨlu aba abɨhalaŋ uami. Vivi hɨnidamɨli Asɨ Iaue nudɨ nukeŋ vɨdɨvɨdɨŋ hɨvɨ aludɨ likɨlɨci Isipɨ fɨli tɨbɨ vala vemɨlu aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Isipɨ fɨli tɨbɨ hɨsɨŋ manɨgali agaŋ aludɨ abamɨgɨlɨdaci hɨniadamɨlu aba abɨhalaŋ uami. Hɨnidamɨli Asɨ Iaue agaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ ninaŋ Cimegeŋ agɨladɨ ifɨhɨma fɨhalami aba abɨhalaŋ uami. Nulɨdɨ sɨhɨm sabaŋ ninaŋ manɨgali agɨladɨ avi sɨkasɨkan ifɨhɨma fɨhalami aba abɨhalaŋ uami. Hameŋ sadaŋ sɨhɨm sabaŋ ninaŋ manɨgali agɨladɨ alaŋ Asɨ Iaue saŋ sagalɨ hɨlahɨla igulalu aba abɨhalaŋ uami. Aludɨ ninaŋ Cimegeŋ agɨladɨ uvɨsɨjiŋ vivi saŋ sabaŋ sipsipɨ ninaŋ muŋaŋ agɨladɨ ifɨhɨmuhɨmu lamalama sagalɨ hɨlahɨla igulalu aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Alaŋ Isipɨ fɨli tɨbɨ hɨnimɨli Asɨ Iaue nudɨ nukeŋ vɨdɨvɨdɨŋ hɨvɨ aludɨ likɨlɨci Isipɨ fɨli tɨbɨ agadɨ vala vemɨlu aba abɨhalaŋ uami. Lavɨla aludɨ hɨji mɨŋaiahaiaha saŋ Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agadɨ lɨbalɨba hɨbɨn hɨbɨn cɨki cɨki hɨvɨ lamɨlalu aba abɨhalaŋ uami. Lamalama hɨbɨn hɨbɨn cɨki cɨki agɨladɨdaŋ vivi aludɨ lɨbam hɨvɨ human hɨvɨ lɨbɨhahɨlalu aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Hɨfɨlɨ heŋ ala Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ abɨci uavɨdaci Asɨ agaŋ Isɨlaelɨ hɨdɨlɨ agɨlasaŋ hɨbɨ abalamami. Nɨbu hɨji nameŋ lamami. Isɨlaelɨ hɨdɨlɨ agɨladɨ hɨbɨ tɨbɨ cɨki hɨvɨ likɨla via ulɨŋ igavɨci hɨdɨlɨ mu agɨlaŋ nulɨsaŋ sagaŋ saŋ lɨhavɨci cɨhu hɨji mu lamavɨla Isipɨ fɨli tɨbɨ saŋ haŋɨlavɨla cɨhu vehavɨbali uami. Asɨ hɨji hameŋ lamavɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ likɨla avɨli hekɨlɨ caba caba uavɨla Filisɨtia hɨdɨlɨ agɨladɨ fɨli tɨbɨ heŋ ma via umi. ");
INSERT INTO ena_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Hameŋ sadaŋ Asɨ agaŋ nulɨdɨ likɨlavɨla hɨbɨ hutesɨ fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ via umi. Via uci Letɨsi avɨli hekɨlɨ iahuavɨmi. Akuaba akuaba sagaŋ hɨsɨŋ agɨladɨ likɨlavɨla uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Vaka Josepɨ Isɨlaelɨ hɨdɨlɨ agɨladɨ nameŋ abami. Hɨvɨ hekɨlɨ aba abavɨla nameŋ abɨhalaŋ uami. Asɨ vevɨla Isɨlaelɨ hɨdɨlɨ aludɨ likɨlavɨla uben aba lɨdaci Josepɨ dɨ henaŋ agɨladɨ viavɨla ubalu aba abɨhalaŋ uami. Hameŋ abami agasaŋ igahɨlavɨla Mosesɨ agaŋ nulɨdɨ abɨci Josepɨ dɨ henaŋ hɨbɨn hɨbɨn hɨvɨ hɨniavɨmi agɨladɨ viavɨla uavɨmi. Kenan fɨli tɨbɨ heŋ mavɨben aba via uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Isɨlaelɨ hɨdɨlɨ agɨlaŋ Sukotɨ haiabɨla valavɨla uavɨla Etam haiabɨla iahua hɨniavɨmi. Etam haiabɨla agaŋ fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ agadɨ caba heŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Uavɨdaci uaiadi ha avɨli susu agaŋ sɨlɨvɨ lamɨci mɨga hɨnidaci Asɨ Iaue agaŋ nudɨ hɨvɨ hɨnihɨni nulɨsaŋ hɨbɨ hali uu abalamalama udaci iga iga uavɨmi. Hɨfɨlɨ ha avɨŋ abɨlu hekɨlɨ agaŋ sɨlɨvɨ lamɨci mɨga hɨnidaci Asɨ Iaue agaŋ nudɨ hɨvɨ hɨnihɨni nulɨsaŋ hɨbɨ hali uu abalamalama udaci iga iga uavɨmi. Hameŋ lɨdaci hɨfɨlɨ hɨfɨlɨ uaiadi uaiadi huaci laci uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Avɨli susu agaŋ hɨbɨ hali udaci hulaŋ iamɨgali agɨlaŋ nudɨ iga iga uavɨmi. Hɨfɨlɨ ha avɨŋ abɨlu hekɨlɨ agaŋ hɨbɨ hali udaci nudɨ iga iga uavɨmi. Avɨli susu agaŋ nulɨdɨ ma vala umi. Avɨŋ abɨlu hekɨlɨ agaŋ avi nulɨdɨ ma vala umi. Hameŋ laci hameŋ laci hɨniavɨdaci iga iga uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Lɨhavɨdaci Asɨ Iaue Mosesɨ dɨ abami. ");
INSERT INTO ena_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨnaŋ avɨli hekɨlɨ caba heŋ uavɨla havɨlɨ ulaŋ hafiavɨla hɨniavɨm uami. Pihahilotɨ haiabɨla mikɨ heŋ hɨniavɨm uami. Mikɨdolɨ haiabɨla hɨnici ui Letɨsi avɨli hekɨlɨ hɨnici ve alɨhaŋ heŋ hɨniavɨm uami. Balɨsefon haiabɨla mikɨ heŋ hɨniavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Heŋ hɨniavɨdaci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ nameŋ igahɨlɨbali uami. Isɨlaelɨ hɨdɨlɨ agɨlaŋ fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ hɨbɨ saŋ suhɨla suhɨla vakala uu veve hɨdavadi aba abɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Asɨ Iaue viaŋ nukeŋ lɨlɨŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ iadɨ ciaŋ lulavɨla nudɨ sagaŋ hɨsɨŋ hulemɨlɨ agɨlaŋ hula Isɨlaelɨ hɨdɨlɨ agɨladɨ sɨvɨ uavɨbali uami. Uavɨdaci viaŋ nulɨsaŋ igɨvɨ hɨniavɨla nulɨdɨ sɨbɨlɨ lamavɨla ibi hekɨlɨ daŋ hɨniben uami. Lɨlɨŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ igavɨla abavɨbali uami. Asɨ Iaue nukeŋ ala nulɨdɨ likɨla via ualɨ aba abavɨbali uami. Asɨ Iaue hameŋ abɨci Isɨlaelɨ hɨdɨlɨ agɨlaŋ nudɨ ciaŋ lubiahɨlavɨla uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Uavɨdaci hulaŋ limu hɨhɨle Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ nulɨdɨ manɨgali agadɨ abavɨmi. Isɨlaelɨ hɨdɨlɨ agɨlaŋ ci uavalɨ uavɨmi. Hameŋ abavɨci manɨgali agaŋ hula hulaŋ nusaŋ hɨji igu igu hɨsɨŋ agɨlaŋ hula cɨhu hɨji mu lamavɨla abavɨmi. Alaŋ akɨ saŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ valɨmɨli uavalɨ uavɨmi. Hameŋ lɨmɨli aludɨ sibɨla agɨladɨ ani ani vihavɨbali uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","7","Hameŋ abavɨci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ iahavɨla nudɨ sagaŋ hɨsɨŋ hulemɨlɨ agɨladɨ abɨci nudɨ sabaŋ osɨ agɨladɨdaŋ vadɨm sabaŋ osɨ magɨla magɨla hɨsɨŋ agadɨdaŋ hihɨlavɨmi. Lɨhavɨci sabaŋ osɨ vadɨm magɨla magɨla hɨsɨŋ 600 huaci sɨbaŋ agɨladɨdaŋ sagaŋ hali hɨsɨŋ nulɨdɨ via hɨdahɨda hɨsɨŋ agɨladɨdaŋ likɨlami. La sabaŋ osɨ vadɨm magɨla magɨla hɨsɨŋ limu hɨhɨle agɨladɨdaŋ sagaŋ hali hɨsɨŋ nulɨdɨ via hɨdahɨda hɨsɨŋ agɨladɨdaŋ likɨla via uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Uavɨdaci Isɨlaelɨ hɨdɨlɨ agɨlaŋ hɨji nameŋ lamavɨmi. Alaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ ci vala uadalu uavɨmi. Hameŋ aba aba hɨjɨŋalaŋala uavɨmi. Hameŋ lɨhavɨdaci Asɨ Iaue agaŋ lɨdaci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ lɨhalɨha uavɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ igɨben aba lɨmi. ");
INSERT INTO ena_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ nudɨ sabaŋ osɨ vadɨm magɨla magɨla hɨsɨŋ agɨlaŋ hula nudɨ sagaŋ hɨsɨŋ hulemɨlɨ sabaŋ osɨ sabɨ hɨvɨ iahua mɨgahɨnihɨni sagaŋ lɨbavɨhadami agɨlaŋ hula Isɨlaelɨ hɨdɨlɨ agɨladɨ sɨvɨ uavɨmi. Nudɨ sagaŋ hɨsɨŋ hulemɨlɨ fɨli hɨvɨ hɨdahɨda sagaŋ lɨbavɨhadami agɨlaŋ avi Isɨlaelɨ hɨdɨlɨ agɨladɨ sɨvɨ uavɨmi. Uavɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ uu veve hɨnihɨni fipɨ Letɨsi avɨli hekɨlɨ caba mikɨ lɨhavɨmi. Nulɨdɨ uu veve hɨnihɨni fipɨ agaŋ Pihahilotɨ haiabɨla Balɨsefon haiabɨla mikɨ heŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ hula nudɨ sagaŋ hɨsɨŋ hulemɨlɨ agɨlaŋ hula uavɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ mikɨ mikɨ lɨhavɨmi. Mikɨ mikɨ lɨhavɨdaci nɨbɨlaŋ nulɨdɨ igavɨla lɨdavɨmi. Lɨdavɨla Asɨ Iaue dɨ abavɨmi. Aludɨ ahɨliahuha uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","La Mosesɨ dɨ abavɨmi. Alaŋ Isipɨ fɨli tɨbɨ hɨnidamɨli nama aludɨ akɨ saŋ likɨlɨnaŋ fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ neŋ vehɨlu uavɨmi. Nama hɨji nameŋ lamahanaŋ uavɨmi. Sudɨ haca haiabɨla Isipɨ fɨli tɨbɨ agaŋ tɨbɨ mɨgi aba abahanaŋ uavɨmi. Lɨnaŋ alaŋ neŋ hɨniavɨla hɨmɨbalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Alaŋ Isipɨ fɨli tɨbɨ ma valɨmaŋ lɨdɨŋ nadɨ abahɨlu uavɨmi. Aludɨ valɨnaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ lɨhu hɨvɨ hɨnihɨni sibɨla vibalu aba abahɨlu uavɨmi. Alaŋ nulɨdɨ lɨhu hɨvɨ hɨnihɨni sibɨla vimɨli ha huaci lɨbali aba abahɨlu uavɨmi. Fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ hɨniavɨla hɨmɨbalu aba abahɨlu uavɨmi. Alaŋ heŋ hɨniavɨla hɨmɨmɨli ha huaci ma lɨbali aba abahɨlu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Lɨhavɨci Mosesɨ agaŋ cɨhu hɨbɨŋ hulaŋ iamɨgali agɨladɨ abami. Lɨdɨmɨlaŋ uami. Vɨdɨvɨdɨŋ lagulamɨhalaŋ uami. Vɨdɨvɨdɨŋ lagulamavɨla Asɨ Iaue naludɨ ahɨliahubali agadɨ igɨbalaŋ uami. Namɨlaŋ iabi Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ sagaŋ saŋ vehavɨdaci igadalaŋ uami. Agadɨ ala mufɨli namɨlaŋ nulɨdɨ cɨhu cɨhu ma igɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Simɨ hɨnihalaŋ uami. Hɨnidalaŋ Asɨ Iaue nukeŋ naludɨ ahɨliahuavɨla Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlasaŋ igɨvɨ hɨniavɨla nulɨdɨ sɨbɨlɨ lamɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Lɨci Asɨ Iaue Mosesɨ dɨ abami. Nama iadɨ akɨ saŋ ula ula aba aba hɨninaŋ uami. Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨnaŋ nulɨdɨ akuaba akuaba agɨladɨ hihɨla vihavɨci uhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Uavɨla nama nadɨ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agadɨ mɨŋaiaha avɨli hekɨlɨ agadɨ atɨ lamɨha uami. Atɨ lamɨnaŋ avɨli hekɨlɨ agaŋ huhahɨlavɨla limu mɨgoudaci limu iloum uami. Lɨci fɨli agaŋ subɨlavɨla vɨdɨvɨdɨŋ la hɨnidaci Isɨlaelɨ hɨdɨlɨ namɨlaŋ heŋ limu ivoubalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ci igɨnaŋ uami. Viaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ lɨlɨŋ nulɨdɨ hɨji humɨgaŋ iahavɨci nɨbɨlaŋ naludɨ sɨvɨ ivouavɨbali uami. Sɨvɨ ivouavɨdaci viaŋ igɨvɨ hɨniavɨla Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨdaŋ nudɨ sabaŋ osɨ vadɨm magɨla magɨla hɨsɨŋ agɨladɨdaŋ sɨbɨlɨ lamɨben uami. Nudɨ sagaŋ hɨsɨŋ hulemɨlɨ sabaŋ osɨ sabɨ hɨvɨ iahua mɨgahɨnihɨni sagaŋ lɨbavɨlalɨ agɨladɨdaŋ nudɨ sagaŋ hɨsɨŋ hulemɨlɨ fɨli hɨvɨ hɨdahɨda sagaŋ lɨbavɨlalɨ agɨladɨdaŋ avi sɨbɨlɨ lamɨben uami. Lavɨla ibi hekɨlɨ daŋ hɨniben uami. ");
INSERT INTO ena_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Lɨlɨŋ Isipɨ fɨli tɨbɨ hɨsɨŋ limu hɨhɨle agɨlaŋ igavɨla abavɨbali uami. Asɨ Iaue nukeŋ igɨvɨ hɨniavɨla nulɨdɨ sɨbɨlɨ lamavɨla nulɨdɨ lɨvali aba abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Asɨ dɨ ciaŋ hali hɨsɨŋ agaŋ hali udaci Isɨlaelɨ hɨdɨlɨ agɨlaŋ sɨvɨ uavɨhadami. Agadɨ ala Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ mikɨ mikɨ sɨbaŋ lɨhavɨci Asɨ dɨ ciaŋ hali hɨsɨŋ agaŋ cɨhu Isɨlaelɨ hɨdɨlɨ agɨladɨ hɨsihala sɨvɨ lagulamami. Lɨci avɨli susu agaŋ avi hali hɨniadami agadɨ valavɨla cɨhu Asɨ dɨ ciaŋ hali hɨsɨŋ agaŋ hula lagulamami. ");
INSERT INTO ena_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","La avɨli susu agaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨdaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨdaŋ alɨhaŋ hɨnilaha hɨnidaci hɨfɨlɨ pabiŋ umi. Lɨdaci Isipɨ fɨli tɨbɨ hɨsɨŋ hɨniavɨmi kɨlikɨli heŋ hɨfɨlɨ mɨgami. Isɨlaelɨ hɨdɨlɨ hɨniavɨmi kɨlikɨli heŋ abɨlu hɨnimi. Hɨfɨlɨ heŋ laci ala Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ Isɨlaelɨ hɨdɨlɨ hɨniavɨmi mikɨ heŋ ubalu aba lɨhavɨmi ala hɨma. ");
INSERT INTO ena_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","22","Lɨhavɨdaci Mosesɨ agaŋ human mɨŋaiahavɨla avɨli hekɨlɨ agadɨ atɨ lamami. Atɨ lamɨci hɨfɨlɨ heŋ laci ala Asɨ Iaue agaŋ lɨdaci huŋe vɨdɨvɨdɨŋ agaŋ uaiaŋ iahaiaha kɨlikɨli heŋ vemi. Huŋe hekɨlɨ veve hɨnidaci ua fɨli mɨŋalahami. Lɨdaci avɨli hekɨlɨ agaŋ huhahɨla limu uavɨla sɨmi kɨlikɨli heŋ hɨhavɨla hɨnimi. Limu avi uavɨla sakalɨ kɨlikɨli heŋ hɨhavɨla hɨnimi. Hɨnidaci fɨli agaŋ subɨlavɨla vɨdɨvɨdɨŋ la hɨnidaci Isɨlaelɨ hɨdɨlɨ agɨlaŋ heŋ limu caba ua iahubalu aba uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Uavɨdaci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ sabaŋ osɨ agɨlaŋ hula nulɨdɨ sabaŋ osɨ vadɨm magɨla magɨla hɨsɨŋ agɨlaŋ hula Isɨlaelɨ hɨdɨlɨ agɨladɨ sɨvɨ uavɨmi. Nulɨdɨ sagaŋ hɨsɨŋ hulemɨlɨ sabaŋ osɨ sabɨ hɨvɨ iahua mɨgahɨnihɨni sagaŋ lɨbavɨhadami agɨlaŋ avi Isɨlaelɨ hɨdɨlɨ agɨladɨ sɨvɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Avɨli susu agaŋ sɨlɨvɨ lamɨci mɨga hɨnidaci avɨŋ me agaŋ nudɨ alɨhaŋ lɨkɨla lɨkɨla muji heŋ lɨhulɨhu hɨnimi. Lɨdaci Asɨ Iaue agaŋ alɨhaŋ lɨkɨla lɨkɨla heŋ hɨnimi. Hɨnidaci fɨli amɨŋ mɨŋalahɨben aba lɨdaci Asɨ Iaue agaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ sagaŋ hɨsɨŋ hulemɨlɨ agɨladɨ igamɨgua igami. La nulɨdɨ hɨji mɨŋaihuihu lɨci lɨdalɨda abavɨmi. I uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Lɨhavɨci Asɨ Iaue nukeŋ lɨci maŋa mɨlɨm agaŋ nulɨdɨ sabaŋ osɨ vadɨm magɨla magɨla hɨsɨŋ agɨladɨ mɨŋahahahaha umi. Lɨdaci sabaŋ osɨ vadɨm magɨla magɨla hɨsɨŋ agɨlaŋ lɨhalɨha ma uavɨmi. Lɨhavɨdaci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ abavɨmi. Ha Asɨ Iaue nukeŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ ahɨliahuavɨla alusaŋ igɨvɨ hɨniavɨla aludɨ sɨbɨlɨ lamɨben aba ladi uavɨmi. Alaŋ nulɨdɨ lɨhalɨha vala haŋɨla cɨhu umɨli uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Lɨhavɨdaci Asɨ Iaue agaŋ Mosesɨ dɨ abami. Nadɨ human hɨvɨ avɨli hekɨlɨ agadɨ cɨhu atɨ lamɨha uami. Lɨnaŋ avɨli agaŋ cɨhu vevɨla Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ sagaŋ hɨsɨŋ hulemɨlɨ agɨladɨdaŋ sabaŋ osɨ vadɨm magɨla magɨla hɨsɨŋ agɨladɨdaŋ mɨŋamɨgum uami. Sagaŋ hɨsɨŋ hulemɨlɨ sabaŋ osɨ sabɨ hɨvɨ iahua mɨgahɨnihɨni sagaŋ lɨbavɨlalɨ agɨladɨ avi mɨŋamɨgum uami. ");
INSERT INTO ena_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Lɨci Mosesɨ agaŋ human hɨvɨ avɨli hekɨlɨ agadɨ atɨ lamami. Atɨ lamɨci fɨli mɨŋalahɨdaci avɨli agaŋ cɨhu vevɨla mɨŋamumimi. Mɨŋamumici cɨhu vaka hɨnimi hameŋ ala hɨnimi. Lɨdaci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ haŋɨlɨbalu aba lɨhavɨci ala hɨma. Asɨ Iaue nukeŋ lɨci avɨli agaŋ nulɨdɨ sɨkasɨkan mɨŋamɨgumi. ");
INSERT INTO ena_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ sabaŋ osɨ vadɨm magɨla magɨla hɨsɨŋ agɨladɨdaŋ sagaŋ hɨsɨŋ hulemɨlɨ sabaŋ osɨ sabɨ hɨvɨ iahua mɨgahɨnihɨni sagaŋ lɨbavɨhadami agɨladɨdaŋ mɨŋamɨguci haba hɨma fɨhalavɨmi. Sagaŋ hɨsɨŋ hulemɨlɨ limu hɨhɨle Isɨlaelɨ hɨdɨlɨ agɨladɨ sɨvɨ uavɨmi agɨladɨ avi mɨŋamɨguci haba hɨma fɨhalavɨmi. Nulɨdɨ hulaŋ mu cɨki avi hɨhi ma hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Agadɨ ala Isɨlaelɨ hɨdɨlɨ agɨlaŋ uavɨmi heŋ fɨli agaŋ subɨlavɨla vɨdɨvɨdɨŋ la hɨnidaci uavɨmi. Uavɨdaci avɨli agaŋ uavɨla sɨmi kɨlikɨli heŋ hɨhavɨla hɨnimi. Limu avi uavɨla sakalɨ kɨlikɨli heŋ hɨhavɨla hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Hadɨhu Isɨlaelɨ hɨdɨlɨ agɨlaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ lɨhu hɨvɨ hɨniavɨdaci Asɨ Iaue agaŋ cɨhu nulɨdɨ ahɨliahumi. Lɨci Isɨlaelɨ hɨdɨlɨ agɨlaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ valɨ agɨladɨ igavɨci avɨli hekɨlɨ agadɨ caba caba hacɨŋ savu heŋ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Asɨ Iaue hameŋ lɨci Isɨlaelɨ hɨdɨlɨ agɨlaŋ vɨdɨvɨdɨŋ hekɨlɨ agadɨ igavɨla Asɨ Iaue saŋ lɨdavɨmi. La nusadaŋ nudɨ sibɨla hɨsɨŋ hulaŋ Mosesɨ sadaŋ hɨji vɨdɨvɨdɨŋ lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","La Mosesɨ agaŋ Isɨlaelɨ hɨdɨlɨ agɨlaŋ hula Asɨ Iaue saŋ sɨhɨ nameŋ agadɨ iahavɨmi. Asɨ Iaue nama Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ lɨvalɨnaŋ agasaŋ alaŋ hɨjɨŋalaŋala sɨhɨ iahaiaha hɨnidalu uavɨmi. Nama lɨnaŋ nulɨdɨ sabaŋ osɨ agɨlaŋ hula sagaŋ hɨsɨŋ hulemɨlɨ sabaŋ osɨ sabɨ hɨvɨ iahua mɨgahɨnihɨni sagaŋ lɨbavɨlalɨ agɨlaŋ hula sɨkasɨkan avɨli hekɨlɨ hɨvɨ mɨguavi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Nama nukeŋ lɨdanaŋ alaŋ vɨdɨvɨdɨŋ hɨnihɨni sɨhɨ iahaiaha hɨnilalu uavɨmi. Nama aludɨ ahɨliahudanaŋ huaci hɨnilalu uavɨmi. Nama aludɨ Asɨ sadaŋ alaŋ nadɨ huaci aba abɨbalu uavɨmi. Nama aludɨ iagagali agɨladɨ Asɨ sadaŋ alaŋ avi nadɨ ibi mɨŋaiahɨbalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Asɨ Iaue nama pam sagaŋ hɨsɨŋ hulaŋ vɨdɨvɨdɨŋ daŋ me hɨnilanaŋ uavɨmi. Nadɨ ibi Iaue uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","5","Nama lɨnaŋ Letɨsi avɨli hekɨlɨ agaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ sagaŋ hɨsɨŋ agɨladɨdaŋ sabaŋ osɨ vadɨm magɨla magɨla hɨsɨŋ agɨladɨdaŋ mɨŋamɨgui uavɨmi. Nulɨdɨ sagaŋ hali hɨsɨŋ agɨladɨ avi mɨŋamɨgui uavɨmi. Mɨŋamɨguci avɨli nahɨmavi uavɨmi. Nahɨmavɨla sɨkasɨkan avɨli muji lɨba kum me mɨguavɨla fɨli lubigavi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Asɨ Iaue uavɨmi. Nadɨ human sɨmi agaŋ vɨdɨvɨdɨŋ hekɨlɨ uavɨmi. Hameŋ sadaŋ aludɨ nagɨli lamavɨlalɨ agɨladɨ ifɨlalɨfɨlɨfɨ unaŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Nadɨ nukeŋ vɨdɨvɨdɨŋ hekɨlɨ hɨvɨ nadɨ nagɨli lamavɨlalɨ agɨladɨ ifɨhɨmɨnaŋ uavɨmi. Nadɨ igɨvɨ agaŋ avɨŋ mɨda asɨŋ culɨ culɨ lɨhulɨhu ulalɨ me lɨhui uavɨmi. Lɨhulɨhu nulɨdɨ sɨbɨlɨ lamalama ui uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Nama lɨdanaŋ huŋe vɨdɨvɨdɨŋ ve uavɨmi. Vedaci avɨli hekɨlɨ agaŋ hɨhavɨla halu me hɨni uavɨmi. Hɨnidaci avɨli hekɨlɨ mɨgua muji agaŋ vɨdɨvɨdɨŋ amɨŋ hɨni uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Lɨdaci aludɨ nagɨli lamavɨlalɨ agɨlaŋ nameŋ abavi uavɨmi. Alaŋ nulɨdɨ sɨvɨ uavɨla nɨbɨlaŋ hula sagaŋ lɨbavɨla nulɨdɨ lɨvalɨbalu aba abavi uavɨmi. Lavɨla nulɨdɨ akuaba akuaba huaci huaci agɨladɨ labɨlavɨla aludɨ hɨdɨlɨ pam agɨlasaŋ igubalu aba abavi uavɨmi. La nulɨdɨ akuaba akuaba agɨladɨ viben aba nameŋ abavi uavɨmi. Alaŋ huaci vibalu aba abavi uavɨmi. Alaŋ nɨbɨlaŋ hula puia hutesɨ hutesɨ hɨvɨ sagaŋ lɨbɨbalu aba abavi uavɨmi. Lavɨla aludɨ nukeŋ vɨdɨvɨdɨŋ hɨvɨ nulɨdɨ sɨbɨlɨ lamɨbalu aba abavi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Hameŋ abavɨdaci ala Asɨ Iaue nama lɨdanaŋ huŋe agaŋ vevɨla lulɨdaci avɨli hekɨlɨ agaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ mɨŋamɨgui uavɨmi. Mɨŋamɨguci lɨba kum vɨhɨlɨ daŋ me avɨli hekɨlɨ alɨhaŋ heŋ mɨguavi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Asɨ Iaue uavɨmi. Akɨ mugɨluŋ agaŋ nama me fɨli neŋ hɨni uavɨmi. Ha nama pam vɨdɨvɨdɨŋ daŋ hɨnilanaŋ uavɨmi. Lɨdanaŋ nadɨ vɨdɨvɨdɨŋ agaŋ mugɨluŋ agɨladɨ vɨdɨvɨdɨŋ lɨvalɨlalɨ uavɨmi. Mugɨluŋ agɨlaŋ nama me hɨma uavɨmi. Nama laci vɨdɨvɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ abalamɨlanaŋ uavɨmi. Sibɨla hekɨlɨ hekɨlɨ vidanaŋ hulaŋ iamɨgali agɨlaŋ nasaŋ lɨdalɨda i aba abavɨlalɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Nama lɨdanaŋ fɨli cɨkɨlɨci aludɨ nagɨli lamavɨlalɨ agɨlaŋ fɨli muji hɨvɨ mɨguavi uavɨmi. Mɨguavɨci fɨli agaŋ nulɨdɨ sɨkasɨkan lalɨgui uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Nama aludɨ likɨlɨnaŋ nadɨ lɨhu hɨvɨ hɨnilalu uavɨmi. Nama aludɨ huaci lamavɨla hali udanaŋ alaŋ nadɨ sɨvɨ ubalu uavɨmi. Nadɨ vɨdɨvɨdɨŋ hɨvɨ alusaŋ hɨbɨ abalamɨdanaŋ ubalu uavɨmi. Uavɨla fipɨ alaŋ hɨnihɨni saŋ nama lɨbɨmɨŋahanaŋ heŋ iahubalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Lɨmɨli fɨli tɨbɨ mu hɨsɨŋ mu hɨsɨŋ agɨlaŋ ciaŋ hameŋ agɨladɨ igahɨlavɨla hekɨlɨ lɨdavɨbali uavɨmi. Filisɨtia fɨli tɨbɨ hɨniavɨlalɨ agɨlaŋ avi hekɨlɨ haba lɨdavɨbali uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Idom fɨli tɨbɨ hɨsɨŋ manɨgali agɨlaŋ ahi aba abavɨbali uavɨmi. Moapɨ fɨli tɨbɨ hɨsɨŋ hulaŋ ibi daŋ agɨlaŋ lɨdavalavala hɨniavɨbali uavɨmi. Hulaŋ iamɨgali Kenan fɨli tɨbɨ hɨniavɨlalɨ agɨladɨ vɨdɨvɨdɨŋ agaŋ avi apalɨ lɨbali uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Nadɨ vɨdɨvɨdɨŋ agadɨ igavɨci nulɨdɨ lɨdalɨda hɨji agaŋ hekɨlɨ iahɨbali uavɨmi. Lɨci nɨbɨlaŋ akuaba cɨki avi ma lɨhavɨbali uavɨmi. Nɨbɨlaŋ kɨlɨ hali me lagulama havɨ hɨniavɨbali uavɨmi. Lɨhavɨdaci alaŋ nulɨdɨ likilamalama ubalu uavɨmi. Alaŋ nadɨ hulaŋ iamɨgali uavɨmi. Alaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ lɨhu hɨvɨ hɨnidamɨli nama aludɨ likɨlɨnaŋ iabi alaŋ nadɨ lɨhu hɨvɨ hɨnidalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Nama aludɨ likɨla via uavɨla halu nama hɨniben aba lɨbɨmɨŋahanaŋ heŋ lamɨnaŋ hɨnibalu uavɨmi. Heŋ hɨnidamɨli nama nadɨ aŋam ulaŋ hafibanaŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Asɨ Iaue nama manɨgali hɨnihɨni akuaba akuaba agɨladɨ migɨla migɨla hameŋ laci hameŋ laci hɨnibanaŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Letɨsi avɨli hekɨlɨ agaŋ huhahɨla limu uavɨla sɨmi kɨlikɨli heŋ hɨhavɨla hɨnimi. Limu avi uavɨla sakalɨ kɨlikɨli heŋ hɨhavɨla hɨnimi. Hɨnidaci fɨli agaŋ subɨlavɨla vɨdɨvɨdɨŋ la hɨnidaci Isɨlaelɨ hɨdɨlɨ agɨlaŋ heŋ limu caba ua iahubalu aba uavɨmi. Ua iahuavɨdaci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨ sagaŋ hɨsɨŋ hulemɨlɨ sabaŋ osɨ sabɨ hɨvɨ iahua mɨgahɨnihɨni sagaŋ lɨbavɨhadami agɨlaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ sɨvɨ uavɨmi. Manɨgali agadɨ sabaŋ osɨ vadɨm magɨla magɨla hɨsɨŋ agɨlaŋ avi Isɨlaelɨ hɨdɨlɨ agɨladɨ sɨvɨ uavɨmi. Uavɨdaci Asɨ Iaue agaŋ lɨci huŋe agaŋ avɨli hekɨlɨ agadɨ lulɨdaci vevɨla Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ sɨkasɨkan mɨŋamɨgumi. ");
INSERT INTO ena_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Alon nadinu humɨgaŋ pam Miliam nɨbu Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ iamɨgali. Hadɨhu nɨbu hɨbɨmaŋ viavɨla udaci iamɨgali sɨkasɨkan agɨlaŋ avi hɨbɨmaŋ viavɨla Miliam dɨ sɨvɨ uavɨmi. Uavɨla hɨbɨmaŋ ifu ifu sɨcisɨci hɨjɨŋalavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Lɨhavɨdaci Miliam agaŋ Asɨ Iaue saŋ sɨhɨ nameŋ agadɨ iahami. Asɨ Iaue nama Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ lɨvalɨnaŋ agasaŋ hɨjɨŋalaŋala sɨhɨ iahaiaha hɨnidalu uami. Nama lɨnaŋ nulɨdɨ sabaŋ osɨ agɨlaŋ hula sagaŋ hɨsɨŋ hulemɨlɨ sabaŋ osɨ sabɨ hɨvɨ iahua mɨgahɨnihɨni sagaŋ lɨbavɨlalɨ agɨlaŋ hula sɨkasɨkan avɨli hekɨlɨ hɨvɨ mɨguavi uami. ");
INSERT INTO ena_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Mosesɨ agaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ likɨla viavɨla Letɨsi avɨli hekɨlɨ agadɨ vala uavɨmi. Uavɨla Solɨ fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ hɨdavɨmi. Hɨdavɨdaci uaiaŋ pabiŋ umi. Agadɨ ala avɨli ma igavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Hɨdahɨda uavɨla man avɨli mu heŋ iahuavɨmi. Iahuavɨla man avɨli agadɨ nɨbalu aba igavɨci hitaŋ lɨci valavɨmi. Avɨli hitaŋ daŋ agasaŋ igahɨlavɨla ibi lamavɨla abavɨmi. Mala uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","La hulaŋ iamɨgali agɨlaŋ Mosesɨ dɨ ajimahamaha abavɨmi. Alaŋ akɨ avɨli agadɨ nɨbalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Lɨhavɨci Mosesɨ agaŋ Asɨ Iaue dɨ mavɨn ciaŋ ciaŋ abami. Lɨci Asɨ Iaue agaŋ Mosesɨ saŋ kɨlɨ tɨbɨ agadɨ abalamɨci via havalɨci man avɨli hitaŋ daŋ agadɨ hɨvɨ mɨgumi. Mɨguci avɨli agaŋ cɨhu huaci lɨmi. Lɨci heŋ hɨniavɨdaci Asɨ Iaue agaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ hɨji vɨdɨvɨdɨŋ agadɨ igɨben aba lɨmi. La nulɨsaŋ ciaŋ vɨdɨvɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ igumi. ");
INSERT INTO ena_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Lavɨla nulɨdɨ abami. Viaŋ Asɨ Iaue uami. Viaŋ naludɨ Asɨ uami. Namɨlaŋ iadɨ ciaŋ agadɨ igahɨlɨhalaŋ uami. Viaŋ igɨdalɨŋ sibɨla huaci hɨnilalɨ agadɨ pam vihalaŋ uami. Vivi iadɨ ciaŋ vɨdɨvɨdɨŋ agɨladɨ lubiahɨlɨhalaŋ uami. Akuaba akuaba ciaŋ igulan agɨladɨ avi lubiahɨlɨhalaŋ uami. Hameŋ lɨlabɨla ha Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlasaŋ hɨmuhɨmu sɨbɨlɨ sɨbɨlɨ iguacin hameŋ agɨladɨ nalusaŋ ma iguben uami. Viaŋ naludɨ hɨmuhɨmu agɨladɨ hihɨlɨdalɨŋ huaci lɨlalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Lɨci Isɨlaelɨ hɨdɨlɨ agɨlaŋ uavɨla Elim man avɨli daŋ heŋ iahuavɨmi. Iahua man avɨli human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ hɨniavɨhadami agɨladɨ igavɨmi. Kɨlɨ detɨ 70 agɨlaŋ avi heŋ hɨniavɨhadami. Isɨlaelɨ hɨdɨlɨ agɨlaŋ man avɨli caba mikɨ heŋ ala havɨlɨ ulaŋ agɨladɨ hafiavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Isɨlaelɨ hɨdɨlɨ agɨlaŋ Isipɨ fɨli tɨbɨ agadɨ vala uavɨdaci avaŋ mu iahami. Iaha hɨdɨdaci uaiaŋ human limu limu fɨhala hɨcɨ limu ahica pam cɨjɨŋ uci Elim man avɨli agɨladɨ vala uavɨmi. Uavɨla Sen fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ ua iahuavɨmi. Sen fɨli tɨbɨ agaŋ Elim man avɨli agɨladɨ Sainai halu agadɨ alɨhaŋ alɨhaŋ heŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","3","Hulaŋ iamɨgali agɨlaŋ heŋ ua hɨnihɨni ajimahamaha Mosesɨ dɨdaŋ Alon dɨdaŋ abavɨmi. Alaŋ Isipɨ fɨli tɨbɨ hɨnihɨni sɨhɨm sabaŋ maci akuaba akuaba nana pam hɨnilalu uavɨmi. Agadɨ ala ahica namɨlaŋ aludɨ viavɨla fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ neŋ likɨla vavehalaŋ uavɨmi. Ahica namɨlaŋ alusaŋ hɨji nameŋ lamahalaŋ uavɨmi. Nulɨdɨ likɨla via umɨli humɨgaŋ saŋ hɨmavɨla sɨkan haba hɨmavɨm aba abahalaŋ uavɨmi. Alaŋ Isipɨ fɨli tɨbɨ hɨnidamɨli Asɨ Iaue agaŋ aludɨ ifɨhɨmɨci ha huaci uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Lɨhavɨci Asɨ Iaue agaŋ Mosesɨ dɨ abami. Ci igɨnaŋ uami. Viaŋ hulaŋ iamɨgali agɨladɨ hɨji igɨben uami. Iadɨ ciaŋ vɨdɨvɨdɨŋ lubiahɨlavɨbali ua hɨma ua uami. Iadɨ ciaŋ vɨdɨvɨdɨŋ nɨbu nameŋ uami. Viaŋ lɨdalɨŋ maci uaiaŋ susu hɨvɨ hɨnihɨni mɨgalahɨlavɨbali uami. Mɨgalahɨlavɨdaci uaiaŋ pabiŋ hɨvɨ laci na fɨhala fɨhala saŋ hɨtɨŋ hɨtɨŋ hunaŋ pabiŋ pabiŋ hɨvɨ vihavɨm uami. Hameŋ lɨhavɨdaci iga iga abɨben uami. Hulaŋ iamɨgali agɨlaŋ iadɨ ciaŋ lubiahɨlavadi aba abɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Maci agɨladɨ vivi nana hɨnihɨni kalɨpiŋ me hɨvɨ cɨhu uaiaŋ ahica saŋ maci hunaŋ ahica lɨdɨŋ ahica lɨdɨŋ sɨhuvavɨbali uami. Mɨkɨmɨkɨ me agasaŋ vihavɨbali uami. Kalɨpiŋ me agasaŋ avi kalɨpiŋ me hɨvɨ vihavɨbali uami. Via vave hɨlanavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Lɨci Mosesɨ hula Alon hula Isɨlaelɨ hɨdɨlɨ hulaŋ iamɨgali agɨladɨ abavɨmi. Hɨfɨlɨdaŋ namɨlaŋ sɨhɨvia sɨbaŋ hɨdɨlɨ igavɨla abɨbalaŋ uavɨmi. Amɨŋ ala aba abɨbalaŋ uavɨmi. Alaŋ Isipɨ fɨli tɨbɨ hɨnidamɨli Asɨ Iaue nukeŋ aludɨ likɨla vavelɨ aba abɨbalaŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Namɨlaŋ akɨ saŋ ajimahamaha aludɨ abɨlalaŋ uavɨmi. Alaŋ ahica ibi apalɨ uavɨmi. Namɨlaŋ ajimahamaha aludɨ abɨlalaŋ ha Asɨ Iaue dɨ abɨlalaŋ uavɨmi. Lɨdalaŋ nɨbu naludɨ ciaŋ agɨladɨ ci igahɨli uavɨmi. Hameŋ sadaŋ amɨli cimɨdaŋ namɨlaŋ nudɨ nukeŋ abɨlu hekɨlɨ vɨdɨvɨdɨŋ daŋ agadɨ igɨbalaŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","La Mosesɨ cɨhu ala abami. Hɨfɨlɨdaŋ Asɨ Iaue nɨbu nukeŋ ala nalusaŋ havaŋ iguci nɨbalaŋ uami. Cimɨdaŋ nalusaŋ maci iguci navɨla humɨgaŋ lagubalaŋ uami. Namɨlaŋ ajimahamaha aludɨ ma abɨlalaŋ uami. Alaŋ ahica ibi apalɨ uami. Namɨlaŋ ajimahamaha aludɨ abɨlalaŋ ha Asɨ Iaue dɨ abɨlalaŋ uami. Lɨdalaŋ nɨbu naludɨ ciaŋ agɨladɨ ci igahɨli uami. ");
INSERT INTO ena_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","La Mosesɨ agaŋ Alon dɨ abami. Asɨ Iaue agaŋ hulaŋ iamɨgali ajimahamaha abavɨlalɨ agɨladɨ ci igahɨli uami. Hameŋ sadaŋ nulɨdɨ abɨnaŋ Asɨ Iaue dɨ pɨŋ vehavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Lɨci Alon agaŋ aba aba hɨnidaci hulaŋ iamɨgali agɨlaŋ hɨnia igoua igavɨci fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ Asɨ Iaue dɨ abɨlu hekɨlɨ vɨdɨvɨdɨŋ daŋ agaŋ avɨli susu hɨvɨ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Lɨci Asɨ Iaue agaŋ Mosesɨ dɨ abami. ");
INSERT INTO ena_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Isɨlaelɨ hɨdɨlɨ agɨlaŋ ajimahamaha abavɨlalɨ agɨladɨ ci igahɨlin uami. Hameŋ sadaŋ nulɨdɨ abɨha uami. Hɨfɨlɨdaŋ sɨbaŋ havaŋ fɨli mɨlɨmɨlɨ me agɨladɨ nɨbalaŋ aba abɨha uami. Cimɨdaŋ ha maci navɨla humɨgaŋ lagubalaŋ aba abɨha uami. Havaŋ agɨladɨdaŋ maci agɨladɨdaŋ navɨla hɨji nameŋ lamɨbalaŋ aba abɨha uami. Asɨ Iaue ha aludɨ Asɨ aba abɨbalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Lɨci hɨfɨlɨdaŋ hɨvɨ havaŋ cɨki cɨki fɨli mɨlɨmɨlɨ me agɨlaŋ uu veve hɨnihɨni fipɨ havɨlɨ ulaŋ caba caba heŋ veve mɨlavɨmi. Cimɨdaŋ hamu cɨbɨ agɨlaŋ humɨsɨ hɨvɨ havɨlɨ ulaŋ caba caba heŋ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Hɨnia subɨlavɨci akuaba akuaba cɨki cɨki akape fɨli hɨvɨ hɨniavɨmi agɨlaŋ akuaba akuaba suvɨli suvɨli me hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Lɨhavɨci Isɨlaelɨ hɨdɨlɨ agɨlaŋ igavɨla uava iahuavɨmi. La nɨbɨlaŋ nukeŋ nukeŋ hɨbɨŋ hɨbɨŋ abitɨhavɨmi. Ha akɨ uavɨmi. Lɨhavɨci Mosesɨ nulɨdɨ abami. Ha maci namɨlaŋ nɨbalaŋ aba Asɨ Iaue nukeŋ igui uami. ");
INSERT INTO ena_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Asɨ Iaue nameŋ abi uami. Havɨlɨ ulaŋ hɨtɨŋ hɨtɨŋ hɨvɨ hulaŋ iamɨgali ninanadi agɨladɨ lugɨlɨlaŋ valɨ vameba iahavɨci aba abi uami. Ha hunaŋ avi hulaŋ iamɨgali ninanadi agɨladɨ valɨ hɨvɨ laci vihavɨm aba abi uami. Hunaŋ hɨtɨŋ hɨtɨŋ via uavɨla maci agɨladɨ vihavɨm aba abi uami. ");
INSERT INTO ena_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Lɨci Isɨlaelɨ hɨdɨlɨ agɨlaŋ hameŋ laci ala lɨhavɨmi. Ulaŋ hɨhɨle hulaŋ iamɨgali ninanadi akape daŋ agɨlaŋ hunaŋ akape vihavɨmi. Hulaŋ iamɨgali ninanadi akape hɨma agɨlaŋ hunaŋ akape ma vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Hɨhɨle maci hunaŋ akape vihavɨmi agɨlaŋ nulɨdɨ maci hunaŋ agɨladɨ lugɨlavɨci ua nulɨdɨ valɨ agadɨ ma lɨvalavɨmi. Limu hɨhɨle maci hunaŋ akape ma vihavɨmi agɨlaŋ nulɨdɨ maci hunaŋ agɨladɨ lugɨlavɨci ua ma tɨbɨ mɨgavɨmi. Nulɨdɨ valɨ hɨtɨŋ hɨtɨŋ agɨlaŋ hɨlihɨli hameŋ laci hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Lɨhavɨci Mosesɨ nulɨdɨ abami. Namɨlaŋ sɨmɨŋ limu hɨhɨle agɨladɨ amɨli me saŋ valɨlaŋ hɨniavɨmɨdɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Agadɨ ala Mosesɨ dɨ ciaŋ lulavɨla amɨli me saŋ valavɨci hɨniavɨmi. Hɨniavɨci amɨli me hɨvɨ igavɨci sɨmɨŋ agɨlaŋ mutu hɨsi lavɨla huhɨ ninaŋ ninaŋ daŋ hɨniavɨmi. Lɨhavɨci Mosesɨ nulɨdɨ abacabɨlami. ");
INSERT INTO ena_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Lɨci uaiaŋ pabiŋ pabiŋ cimɨdaŋ hɨvɨ maci hɨlihɨli hameŋ laci vihavɨhadami. Uaiaŋ iahaiaha vɨdɨvɨdɨŋ lɨdaci maci limu hɨhɨle ma vihavɨhadami agɨlaŋ fɨli hɨvɨ hɨnihɨni miŋɨla miŋɨla avɨli avɨli lɨdɨŋ apalɨ lɨhavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Hulaŋ iamɨgali hɨtɨŋ hɨtɨŋ agɨlaŋ hɨdɨlɨ maha iabi me maci hunaŋ pabiŋ lɨdɨŋ pabiŋ lɨdɨŋ vihavɨmi. Hameŋ laci lɨdɨŋ hɨnihɨni via ua cɨhu kalɨpiŋ me hɨvɨ maci hunaŋ ahica lɨdɨŋ ahica lɨdɨŋ vihavɨmi. Lɨhavɨci Isɨlaelɨ hɨdɨlɨ agɨladɨ manɨgali agɨlaŋ vevɨla Mosesɨ dɨ abavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Abavɨci Mosesɨ nulɨdɨ abami. Asɨ Iaue nameŋ abi uami. Amɨli iadɨ alusɨsɨ mɨhiŋ hekɨlɨ aba abi uami. Akuaba akuaba sɨmɨŋ avɨŋ hɨvɨ hɨlɨbavɨla ha avɨŋ hɨvɨ hɨlɨhalaŋ aba abi uami. Sɨji hɨvɨ hugɨlɨben aba ha sɨji hɨvɨ hugɨlɨhalaŋ aba abi uami. Hɨla navɨla sɨmɨŋ sɨha limu hɨhɨle agɨladɨ amɨli saŋ lamɨhalaŋ aba abi uami. ");
INSERT INTO ena_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Lɨci Mosesɨ dɨ ciaŋ agadɨ lubiahɨlavɨla sɨmɨŋ sɨha limu hɨhɨle agɨladɨ lamavɨmi. La hɨniavɨci mɨŋalahɨci sɨmɨŋ sɨha lamavɨmi agɨladɨ igavɨci ma hɨsi lɨhavɨmi. Huhɨ ninaŋ ninaŋ avi ma mɨguavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Lɨhavɨci Mosesɨ nulɨdɨ abami. Iabi Asɨ Iaue dɨ mɨhiŋ hekɨlɨ uami. Alusɨsɨ nudɨ ibi mɨŋaiahaiaha hɨsɨŋ mɨhiŋ uami. Alusɨsɨ mɨhiŋ neŋ hɨdavɨla maci akuaba akuaba cɨki avi ma igɨbalaŋ uami. Hameŋ sadaŋ sɨmɨŋ sɨha limu hɨhɨle hɨniavadi agɨladɨ nɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Navɨla hɨnilaŋ mɨŋalahɨci cɨhu maci sɨhuvɨbalaŋ uami. Sɨhuvɨdalaŋ uaiaŋ human limu fɨhala uci cɨhu uaiaŋ mu hɨvɨ alusɨbalaŋ uami. Uaiaŋ alusɨbalaŋ heŋ maci ma hɨniavɨbali uami. Mufɨli mufɨli avi hameŋ laci ala lɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Alusɨsɨ mɨhiŋ hɨvɨ hulaŋ iamɨgali limu hɨhɨle agɨlaŋ maci vibalu aba uavɨmi. Uavɨla igavɨci maci heŋ ma hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Lɨci Asɨ Iaue agaŋ Mosesɨ dɨ abami. Viaŋ nalusaŋ ciaŋ lamalubilan agɨladɨdaŋ ciaŋ vɨdɨvɨdɨŋ agɨladɨdaŋ nalusaŋ iguacin uami. Agadɨ ala namɨlaŋ ma lubiahɨlɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Iadɨ ciaŋ sɨhɨvia sɨbaŋ igahɨlɨhalaŋ uami. Viaŋ Asɨ Iaue uami. Alusɨsɨ mɨhiŋ nagadɨ viaŋ nukeŋ lamamin uami. Viaŋ alusɨsɨ mɨhiŋ agasaŋ igahɨlavɨla amɨli nalusaŋ sɨmɨŋ uaiaŋ ahica hɨsɨŋ agɨladɨ igumalamin uami. Hameŋ sadaŋ alusɨsɨ mɨhiŋ hɨvɨ hulaŋ iamɨgali namɨlaŋ naludɨ havɨlɨ ulaŋ hɨtɨŋ hɨtɨŋ hɨvɨ hɨnihalaŋ uami. Naludɨ havɨlɨ ulaŋ agɨladɨ vala umɨlaŋ uami. Mufɨli mufɨli avi alusɨsɨ mɨhiŋ agasaŋ igahɨlahɨla hameŋ laci ala sɨmɨŋ igudalɨŋ nɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Hameŋ abɨci Isɨlaelɨ hɨdɨlɨ agɨlaŋ alusɨsɨ mɨhiŋ hɨvɨ alusavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","La maci agadɨ ibi lamavɨla abavɨmi. Mana uavɨmi. Maci agaŋ isabɨlaŋ hɨlɨcɨ mila sudɨme cɨki cɨki me hɨniadami. Sɨdaŋ nudɨ maci daŋ vɨhɨ magɨ daŋ eŋala hɨlavɨci sɨdaŋ daŋ hɨnilalɨ hameŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Lɨci Mosesɨ nulɨdɨ abami. Asɨ Iaue aludɨ nameŋ abi uami. Namɨlaŋ Isipɨ fɨli tɨbɨ hɨnidalaŋ viaŋ naludɨ likɨla vavelɨŋ fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ neŋ hɨnidalaŋ nalusaŋ maci igudalɨŋ nana hɨnibalaŋ aba abi uami. Hameŋ sadaŋ hunaŋ cɨki agadɨ viavɨla maci agɨladɨ heŋ likɨlɨlaŋ mɨguavɨm aba abi uami. Likɨlɨlaŋ mɨgua hɨniavɨdaci naludɨ ninanadinalu ajihalinalu iamɨlɨhalinalu mufɨli iahavɨbali agɨlaŋ avi igavɨbali aba abi uami. ");
INSERT INTO ena_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Lavɨla Alon dɨ abami. Maci agɨladɨ hunaŋ hɨvɨ via uavɨla sɨbɨ hɨlɨcɨ hɨvɨ ahualɨnaŋ mɨgua mɨlɨci via uavɨla Asɨ Iaue hula aba aba hɨsɨŋ fipɨ heŋ lamɨha uami. Lamɨnaŋ hɨnidaci ninanadinalu ajihalinalu iamɨlɨhalinalu mufɨli iahavɨbali agɨlaŋ avi heŋ igavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Lɨci Mosesɨ agaŋ Asɨ Iaue nudɨ abami hameŋ laci ala lɨmi. Alon agaŋ maci agɨladɨ sɨbɨ hɨlɨcɨ hɨvɨ ahualɨci mɨguavɨmi agadɨ via uavɨla Asɨ Iaue hula aba aba hɨsɨŋ fipɨ heŋ lamɨci hameŋ laci hɨniadami. ");
INSERT INTO ena_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Isɨlaelɨ hɨdɨlɨ agɨlaŋ maci agɨladɨ nana hɨniavɨdaci hualɨ 40 umi. Hualɨ 40 agaŋ ua fɨhalɨci Kenan fɨli tɨbɨ agadɨ mikɨ heŋ ua iahuavɨmi. La Kenan fɨli tɨbɨ agadɨ igavɨci hualɨ hulihuli fɨli huaci sɨbaŋ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Isɨlaelɨ hɨdɨlɨ agɨlaŋ hunaŋ ahica ahica agɨladɨ hɨvɨ sɨmɨŋ lamalama lugɨlavɨhadami. Hunaŋ mu sudɨme cɨki. Mu hunaŋ mɨsɨn hekɨlɨ. Nulɨdɨ hunaŋ sudɨme cɨki hɨvɨ maci agɨladɨ vivi hunaŋ mɨsɨn heŋ human limu limu fɨhala tɨbɨ lugɨla lugɨla mɨŋamɨjiavɨdaci mɨgumɨgu heŋ mɨladami. ");
INSERT INTO ena_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Asɨ Iaue agaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨdaci hɨbɨ cina uu havɨlɨ ulaŋ hafihafi hɨnihɨni uavɨhadami. La Sen fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ agadɨ valavɨla uavɨmi. Ua Lefidim uu veve hɨnihɨni fipɨ heŋ ua iahua hɨnihɨni saŋ abavɨla igavɨci avɨli apalɨ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Lɨci hulaŋ iamɨgali agɨlaŋ Mosesɨ hula hɨbɨŋ ciaŋ hɨbɨŋ ciaŋ abavɨmi. Alusaŋ avɨli igunaŋ nɨmɨli uavɨmi. Lɨhavɨci Mosesɨ nulɨdɨ abami. Namɨlaŋ akɨ saŋ viaŋ hula hɨbɨŋ ciaŋ hɨbɨŋ ciaŋ abadalaŋ uami. Namɨlaŋ akɨ saŋ Asɨ Iaue dɨ vɨdɨvɨdɨŋ agasaŋ abacuvadalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Lɨci hulaŋ iamɨgali agɨlaŋ avɨli nana saŋ hekɨlɨ hɨmavɨla ajimahamaha Mosesɨ dɨ abavɨmi. Nama akɨ saŋ aludɨ viavɨla fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ neŋ likɨla vavehanaŋ uavɨmi. Nama alusaŋ hɨji nameŋ lamahanaŋ uavɨmi. Nulɨdɨ likɨla via ulɨŋ nɨbɨlaŋ nulɨdɨ sabaŋ sipsipɨ sabaŋ bulɨmakau agɨlaŋ hula avɨli apalɨ heŋ hɨniavɨla hɨmavɨm aba abahanaŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Lɨhavɨci Mosesɨ agaŋ Asɨ Iaue dɨ mavɨn ciaŋ ciaŋ abami. Hulaŋ iamɨgali nagɨlaŋ iadɨ ifɨhɨmuhɨmu saŋ lɨba kum kum agɨladɨ vivi havalɨbalu aba lɨhavadi uami. Hameŋ lɨhavadi sadaŋ viaŋ nulɨdɨ akɨ me lɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Lɨci Asɨ Iaue agaŋ Mosesɨ dɨ abami. Nadɨ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ Nailɨ avɨli ifahanaŋ agadɨ viavɨla ua Isɨlaelɨ hɨdɨlɨ agɨladɨ hulaŋ hekɨlɨ hekɨlɨ limu hɨhɨle agɨladɨ viavɨla hali uhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ci igɨnaŋ uami. Viaŋ lɨba mu Sainai halu hɨnilalɨ heŋ hɨniben uami. Hɨnidalɨŋ nama mikɨ sɨbaŋ ve lagulamavɨla kɨlɨ lɨmɨ agadɨ hɨvɨ lɨba agadɨ ifaigɨnaŋ avɨli agaŋ lɨba hɨvɨ iahɨdaci hulaŋ iamɨgali agɨlaŋ heŋ navɨbali uami. Lɨci Isɨlaelɨ hɨdɨlɨ agɨladɨ hulaŋ hekɨlɨ hekɨlɨ agɨlaŋ igasulavɨdaci Mosesɨ agaŋ hameŋ laci ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Uu veve hɨnihɨni fipɨ agadɨ ibi ahica ahica lamavɨmi. Isɨlaelɨ hɨdɨlɨ agɨlaŋ Mosesɨ hula hɨbɨŋ ciaŋ hɨbɨŋ ciaŋ abavɨmi agasaŋ igahɨlavɨla uu veve hɨnihɨni fipɨ agadɨ ibi lamavɨla abavɨmi. Melɨba uavɨmi. Asɨ Iaue dɨ vɨdɨvɨdɨŋ agasaŋ abacuvavɨla abavɨmi. Asɨ Iaue alaŋ hula hɨni ua hɨma uavɨmi. La nusaŋ igahɨlavɨla ibi mu lamavɨla abavɨmi. Masa uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Isɨlaelɨ hɨdɨlɨ agɨlaŋ Lefidim uu veve hɨnihɨni fipɨ heŋ hɨniavɨdaci Amalekɨ hɨdɨlɨ agɨlaŋ nulɨsaŋ sagaŋ vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Lɨhavɨci Mosesɨ agaŋ Josua dɨ abami. Nama aludɨ sagaŋ hɨsɨŋ hulaŋ hɨhɨle agɨladɨ lɨbɨmɨŋavɨla amɨli iaha Amalekɨ hɨdɨlɨ agɨlasaŋ sagaŋ uhalaŋ uami. Udalaŋ viaŋ kɨlɨ lɨmɨ Asɨ abɨci via hɨdɨlan agadɨ via uavɨla halu cɨki agadɨ iahua huva heŋ lagulamavɨla hɨniben uami. ");
INSERT INTO ena_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Lɨci Josua agaŋ Mosesɨ abami hameŋ laci ala lɨmi. Nudɨ sagaŋ hɨsɨŋ hulaŋ hɨhɨle agɨladɨ likɨla viavɨla Amalekɨ hɨdɨlɨ agɨlasaŋ sagaŋ uavɨmi. Uavɨdaci Mosesɨ agaŋ Alon dɨdaŋ Holɨ dɨdaŋ via uavɨla halu huva heŋ iahuavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Iahuavɨla Mosesɨ nudɨ human agɨladɨ mɨŋaiahua lagulama hɨnidaci Isɨlaelɨ hɨdɨlɨ agɨladɨ sagaŋ hɨsɨŋ hulaŋ agɨlaŋ Amalekɨ hɨdɨlɨ agɨladɨ sagaŋ hɨsɨŋ hulaŋ agɨladɨ lɨvalɨbalu aba lɨhavɨmi. Agadɨ ala Mosesɨ dɨ human limu limu alu lɨci valɨci mɨgavɨci Amalekɨ hɨdɨlɨ agɨladɨ sagaŋ hɨsɨŋ hulaŋ agɨlaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ sagaŋ hɨsɨŋ hulaŋ agɨladɨ lɨvalɨbalu aba lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mosesɨ dɨ human limu limu agɨlaŋ alu lɨhavɨci cɨhu ma mɨŋaiahumi. Lɨci Alon hula Holɨ hula lɨba tɨbɨ vave fɨli lamavɨci Mosesɨ agaŋ heŋ mɨgahɨnimi. Mɨgahɨnidaci Alon hula Holɨ hula nudɨ madɨŋ limu limu heŋ lagulamavɨmi. La nudɨ human limu hulaŋ mu agaŋ mɨŋalɨva mɨŋaiahua lagulama hɨnimi. Hulaŋ mu human limu agadɨ mɨŋalɨva mɨŋaiahua lagulama hɨnimi. Hameŋ hɨniavɨdaci uaiaŋ mɨgumi. ");
INSERT INTO ena_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Lɨhavɨdaci Josua nudɨ sagaŋ hɨsɨŋ hulaŋ agɨlaŋ hula puia hutesɨ hutesɨ hɨvɨ Amalekɨ hɨdɨlɨ agɨladɨ sɨkasɨkan ifɨhɨma fɨhalavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Lɨhavɨci Asɨ Iaue agaŋ Mosesɨ dɨ abami. Viaŋ Amalekɨ hɨdɨlɨ agɨladɨ sɨkasɨkan sɨbɨlɨ lama fɨhalɨben agadɨ ciaŋ manasɨŋ hɨvɨ lɨbɨha uami. Lɨnaŋ hulaŋ iamɨgali agɨlaŋ nudɨ igavɨla hɨji lamavɨla abavɨbali uami. Asɨ Iaue agaŋ Amalekɨ hɨdɨlɨ agɨladɨ sɨbɨlɨ lamɨci sɨkasɨkan haba hɨma fɨhalavɨbali aba abavɨbali uami. Lɨhavɨci Amalekɨ hɨdɨlɨ agɨladɨ ibi cɨhu cɨhu ma igahɨlɨbalu aba abavɨbali uami. Ciaŋ nagadɨ Josua dɨ avi sulɨnaŋ igahɨlam uami. ");
INSERT INTO ena_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Asɨ Iaue agaŋ abɨci ci lɨci Mosesɨ agaŋ sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ ibilami. La vadɨm agadɨ ibi lamavɨla abami. Asɨ Iaue agaŋ aludɨ ahɨliahuci Amalekɨ hɨdɨlɨ agɨlaŋ hula sagaŋ lɨbavɨla nulɨdɨ lɨvalalu uami. ");
INSERT INTO ena_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Amalekɨ hɨdɨlɨ agɨlaŋ Asɨ Iaue dɨ vɨdɨvɨdɨŋ agadɨ lɨvalɨbalu aba lɨhavɨdaci Asɨ Iaue agaŋ nulɨsaŋ igɨvɨ hɨnihɨni nulɨdɨ hameŋ laci hameŋ laci sɨbɨlɨ lamɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Mosesɨ abiaganu Jetɨlo nɨbu Midian fɨli tɨbɨ hɨsɨŋ. Nɨbu Asɨ saŋ sagalɨ igu igu hɨsɨŋ hulaŋ hɨniadami. Nɨbu Asɨ Iaue agaŋ Mosesɨ dɨdaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨdaŋ akuaba akuaba lɨmi agadɨ ciaŋ hɨjɨ igahɨlami. Asɨ Iaue agaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ likɨlɨci Isipɨ fɨli tɨbɨ agadɨ valavɨla cɨhu vehavɨmi agadɨ ciaŋ hɨjɨ igahɨlami. ");
INSERT INTO ena_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Lavɨla Jetɨlo agaŋ Mosesɨ dɨ hɨbɨ cina igɨben aba vemi. Vaka Mosesɨ abinu Sipola dɨdaŋ nudɨ ninaŋ ahica agɨladɨdaŋ abɨci iaganu Jetɨlo dɨ pɨŋ uavɨmi agɨladɨ cɨhu iaganu nukeŋ ala likɨla via vemi. ");
INSERT INTO ena_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","4","Ninaŋ ahica agɨladɨ ibi nameŋ. Mu Gelɨsom. Mu Elieselɨ. Mosesɨ abinu agaŋ ninaŋ Cimegeŋ agadɨ huhɨlɨci Mosesɨ agaŋ hɨji nameŋ lamami. Viaŋ hulaŋ ihɨlɨŋ vevɨla neŋ hɨniadamin uami. Hɨji hameŋ lamavɨla ninaŋ Cimegeŋ agadɨ ibi lamavɨla abami. Gelɨsom uami. La hɨnidaci abinu agaŋ Iagɨveŋ dɨ huhɨlami. Lɨci abami. Iadɨ iavaŋ dɨ Asɨ agaŋ iadɨ ahɨliahuci Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agaŋ iadɨ ma ifɨhɨmami uami. Hameŋ abavɨla nudɨ ninaŋ Iagɨveŋ agadɨ ibi lamavɨla abami. Elieselɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jetɨlo agaŋ Mosesɨ abinu dɨdaŋ Mosesɨ dɨ ninaŋ ahica agɨladɨdaŋ via vemi. Vevɨla fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ Asɨ dɨ halu hɨniadami mikɨ heŋ ve iahavɨmi. Mosesɨ dɨ uu veve hɨnihɨni fipɨ avi Asɨ dɨ halu agadɨ lɨguŋ heŋ ala hɨniadami. ");
INSERT INTO ena_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jetɨlo agaŋ Mosesɨ dɨ uu veve hɨnihɨni fipɨ agadɨ mikɨ vemitavɨla Mosesɨ saŋ ciaŋ iguci uci abami. Viaŋ nadɨ abiagana Jetɨlo uami. Viaŋ nadɨ abina dɨdaŋ ninaŋ ahica agɨladɨdaŋ viavɨla nadɨ pɨŋ ci velu uami. ");
INSERT INTO ena_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Lɨci Mosesɨ ciaŋ hɨjɨ agadɨ igahɨlavɨla iaha uu veve hɨnihɨni fipɨ agadɨ vala haiabɨla ivavevɨla Jetɨlo dɨ igami. La mɨgalɨfɨlɨbavɨla iaha abiaganu dɨ mɨhum iavami. La ahica hɨbɨŋ hɨbɨŋ abitɨhavɨmi. Nama sɨbɨlɨ hɨnilanaŋ ua huaci hɨnilanaŋ uavɨmi. Hameŋ abaigahɨlavɨci ci lɨci Mosesɨ dɨ havɨlɨ ulaŋ hɨvɨ ivouavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ivouavɨla abiaganu dɨ sulami. Asɨ Iaue agaŋ Isɨlaelɨ hɨdɨlɨ agɨlasaŋ igahɨlavɨla Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ manɨgali agadɨdaŋ nudɨ hulaŋ iamɨgali agɨladɨdaŋ akuaba akuaba lɨmi agasaŋ sulami. Isɨlaelɨ hɨdɨlɨ agɨlaŋ Isipɨ fɨli tɨbɨ agadɨ vala uu hɨbɨ cina vɨhɨlɨ hekɨlɨ hekɨlɨ igavɨdaci Asɨ Iaue nulɨdɨ ahɨliahudaci huaci hɨniavɨmi agasaŋ sulami. ");
INSERT INTO ena_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ sɨbɨlɨ lamavɨdaci vɨhɨlɨ hekɨlɨ hekɨlɨ agɨladɨ iga iga hɨniavɨhadami agasaŋ sulami. Asɨ Iaue agaŋ nulɨdɨ ahɨliahua huaci lamavɨla likɨla vavemi agasaŋ avi sulami. Sulɨci Jetɨlo agaŋ igahɨlavɨla hekɨlɨ hɨjɨŋalami. ");
INSERT INTO ena_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Lavɨla abami. Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ iamɨgali agɨladɨ lɨhu hɨvɨ hɨniadamɨlaŋ uami. Nulɨdɨ manɨgali agadɨ lɨhu hɨvɨ avi hɨniadamɨlaŋ uami. Hɨnihɨni vɨhɨlɨ iga iga hɨnidalaŋ Asɨ Iaue naludɨ ahɨliahua likɨla vavelɨ agasaŋ nudɨ ibi mɨŋaiahin uami. ");
INSERT INTO ena_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Iabi viaŋ ci igin uami. Asɨ Iaue nɨbu vɨdɨvɨdɨŋ daŋ uami. Isipɨ fɨli tɨbɨ hɨsɨŋ agɨlaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ sɨbɨlɨ igavɨci Asɨ agaŋ nudɨ vɨdɨvɨdɨŋ hekɨlɨ agadɨ abalamalɨ uami. Asɨ dɨ vɨdɨvɨdɨŋ agaŋ mugɨluŋ agɨladɨ vɨdɨvɨdɨŋ lɨvalɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","La Jetɨlo agaŋ Asɨ saŋ sagalɨ iguavɨla avɨŋ hɨvɨ sɨkan hɨlɨci lɨhulɨhu saŋ sɨhɨm sabaŋ agɨladɨ via umi. La sɨmɨŋ limu hɨhɨle agɨladɨ avi Asɨ saŋ sagalɨ iguben aba via umi. Via uavɨla hɨlami. Hɨlahɨla hɨnidaci Alon agaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ hulaŋ hekɨlɨ hekɨlɨ agɨlaŋ hula uavɨla Jetɨlo Asɨ Iaue saŋ sagalɨ hɨlami agadɨ fipɨ mikɨ heŋ mɨgahɨniavɨla ahuata hameŋ navɨmi. ");
INSERT INTO ena_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","La Mosesɨ agaŋ hɨnici mɨŋalahɨci Isɨlaelɨ hɨdɨlɨ hulaŋ iamɨgali agɨladɨ ciaŋ vɨhɨlɨ agɨladɨ hihɨlɨben aba mɨgahɨnimi. Mɨgahɨnidaci hulaŋ iamɨgali akape agɨlaŋ cimɨdaŋ hɨvɨ nulɨdɨ ciaŋ vɨhɨlɨ agɨladɨ hihɨla hihɨla saŋ nudɨ pɨŋ vehavɨmi. Vehavɨci ciaŋ hihɨla hihɨla via uci hɨfɨlɨdaŋ sɨbaŋ lɨmi. Lɨci hulaŋ iamɨgali agɨlaŋ vala uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Lɨhavɨci Jetɨlo agaŋ igavɨla Mosesɨ hulaŋ iamɨgali agɨladɨ vɨhɨlɨ hihɨla hihɨla sibɨla vihadami agasaŋ abami. Nama akɨ saŋ sibɨla agadɨ hɨtɨŋ sɨbaŋ vilanaŋ uami. Lɨdanaŋ hulaŋ iamɨgali akape agɨlaŋ ciaŋ hihɨla hihɨla saŋ nadɨ pɨŋ vehavɨlalɨ uami. Cimɨdaŋ cimɨdaŋ veve lagulamalama hɨniavɨlalɨ uami. Hɨniavɨdaci hɨfɨlɨdaŋ sɨbaŋ lɨdaci nadɨ valavala uavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Lɨci Mosesɨ nudɨ abami. Hulaŋ Asɨ dɨ hɨji agadɨ vivi saŋ lavɨla iadɨ pɨŋ vehavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Hulaŋ ahica agɨlaŋ akuaba akuaba saŋ aba aba lamacilacila nulɨdɨ ciaŋ vɨhɨlɨ agɨladɨ iadɨ pɨŋ vavehavɨdaci viaŋ hihɨlɨlan uami. Lɨdɨŋ Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agɨladɨ sulɨdalɨŋ igahɨlavɨlalɨ uami. Ciaŋ hɨhɨle iadɨ lamalubilalɨ agɨladɨ avi sulɨdalɨŋ igahɨlavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Lɨci Jetɨlo agaŋ Mosesɨ dɨ abami. Nama hameŋ lɨlanaŋ agaŋ huaci ma lɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Sibɨla hekɨlɨ hekɨlɨ hameŋ agɨladɨ hɨtɨŋ vinaŋ ma huaci lɨbali uami. Nama hameŋ lɨnaŋ nadɨ hadipɨlɨ vɨhɨlɨ lɨbali uami. Hulaŋ iamɨgali agɨladɨ hadipɨlɨ avi vɨhɨlɨ lɨhavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Iadɨ ciaŋ nagadɨ igahɨlɨha uami. Nama iadɨ ciaŋ nagadɨ igahɨla lubiahɨlɨnabɨla ha Asɨ Iaue nama hula hɨnihɨni nadɨ ahɨliahudaci hulaŋ iamɨgali agɨlasaŋ Asɨ dɨ abɨbanaŋ uami. Lɨdɨŋ nulɨdɨ ciaŋ vɨhɨlɨ agɨladɨ viovio Asɨ dɨ abɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Asɨ dɨ aba aba nulɨsaŋ hɨji igudanaŋ Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agɨladɨ igahɨlavɨbali uami. Asɨ agaŋ ciaŋ lamalubilɨ agadɨ igahɨlavɨbali uami. Lavɨla huaci hɨnihɨni sibɨla vivi saŋ avi hɨji igudanaŋ igahɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Hulaŋ ciaŋ daŋ agaŋ nudɨ ahɨliahuiahu saŋ anɨm hɨlɨcɨ iguavɨci vihavɨlalɨ agɨladɨ lɨbɨmɨŋɨmɨnaŋ uami. Hulaŋ iamɨgali migɨla migɨla hɨsɨŋ hulaŋ huaci sɨbaŋ Asɨ dɨ lɨhu hɨvɨ hɨnihɨni nusaŋ hɨji vɨdɨvɨdɨŋ lamavɨlalɨ agɨladɨ lɨbɨmɨŋɨha uami. Lɨnaŋ manɨgali hɨhɨle agɨlaŋ hulaŋ iamɨgali 1,000 agɨladɨ hɨtɨŋ hɨtɨŋ migɨlavɨm uami. Manɨgali hɨhɨle hulaŋ iamɨgali 100 agɨladɨ hɨtɨŋ hɨtɨŋ migɨlavɨm uami. Manɨgali hɨhɨle hulaŋ iamɨgali 50 agɨladɨ hɨtɨŋ hɨtɨŋ migɨlavɨm uami. Manɨgali hɨhɨle hulaŋ iamɨgali 10 agɨladɨ hɨtɨŋ hɨtɨŋ migɨlavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Lɨnaŋ nɨbɨlaŋ ala ciaŋ vɨhɨlɨ hihɨla hihɨla hɨsɨŋ hulaŋ hɨniavɨbali uami. Ciaŋ vɨhɨlɨ hekɨlɨ hɨma agɨladɨ nɨbɨlaŋ hihɨlavɨbali uami. Agadɨ ala vɨhɨlɨ hekɨlɨ hekɨlɨ agɨladɨ nadɨ pɨŋ vavehavɨdaci nama nukeŋ hihɨlɨbanaŋ uami. Hameŋ lɨdanaŋ nɨbɨlaŋ nadɨ ahɨliahuavɨdaci nama vɨhɨlɨ hekɨlɨ sɨbaŋ ma igɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Akuaba akuaba nadɨ abin agɨlasaŋ Asɨ dɨ abitɨhɨha uami. Abitɨhɨnaŋ alia aba abɨci hameŋ laci ala lɨha uami. Hameŋ lavɨla ha sibɨla huaci vibanaŋ uami. Nama iadɨ ciaŋ agadɨ lubiahɨlavɨla sibɨla agadɨ vinabɨla ha nadɨ hadipɨlɨ ma vɨhɨlɨ lɨbali uami. Lɨci hulaŋ iamɨgali agɨlaŋ avi nulɨdɨ ciaŋ vɨhɨlɨ agɨladɨ hihɨlɨdanaŋ hɨjɨŋalaŋala uavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Lɨci Mosesɨ agaŋ Jetɨlo dɨ ciaŋ agadɨ igahɨla lubiahɨlavɨla hameŋ laci ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Isɨlaelɨ hɨdɨlɨ hulaŋ huaci huaci sɨbaŋ agɨladɨ igavɨla hulaŋ iamɨgali migɨla migɨla saŋ igahɨlavɨla lɨbɨmɨŋami. Lɨbɨmɨŋɨci manɨgali hɨhɨle hulaŋ iamɨgali 1,000 agɨladɨ hɨtɨŋ hɨtɨŋ migɨlavɨhadami. Manɨgali hɨhɨle hulaŋ iamɨgali 100 agɨladɨ hɨtɨŋ hɨtɨŋ migɨlavɨhadami. Manɨgali hɨhɨle hulaŋ iamɨgali 50 agɨladɨ hɨtɨŋ hɨtɨŋ migɨlavɨhadami. Manɨgali hɨhɨle hulaŋ iamɨgali 10 agɨladɨ hɨtɨŋ hɨtɨŋ migɨlavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Lɨdɨŋ ciaŋ vɨhɨlɨ hihɨla hihɨla sibɨla agɨladɨ pam vihavɨhadami. Ciaŋ vɨhɨlɨ hekɨlɨ hɨma agɨladɨ hulaŋ lɨbɨmɨŋamɨŋa umi agɨlaŋ hihɨlavɨhadami. Agadɨ ala vɨhɨlɨ hekɨlɨ hekɨlɨ agɨladɨ Mosesɨ dɨ pɨŋ via uavɨdaci hihɨladami. ");
INSERT INTO ena_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Hameŋ lɨdɨŋ hɨniavɨdaci Mosesɨ abiaganu Jetɨlo agaŋ nulɨdɨ vala nudɨ hɨvɨ udaci acinu agaŋ nusaŋ lamulami. ");
INSERT INTO ena_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Isɨlaelɨ hɨdɨlɨ agɨlaŋ Lefidim uu veve hɨnihɨni fipɨ agadɨ valavɨla uavɨmi. Isipɨ fɨli tɨbɨ vala uavɨdaci avaŋ ahica uci avaŋ mu iahami agadɨ mɨhiŋ hadɨhu heŋ ala Sainai halu lɨguŋ heŋ ua iahuavɨmi. Lavɨla halu lɨguŋ heŋ ala uu veve hɨnihɨni fipɨ vihavɨmi. Sainai halu lɨguŋ agaŋ fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Lɨci hulaŋ iamɨgali agɨlaŋ heŋ hɨniavɨdaci Mosesɨ agaŋ Asɨ hula ciaŋ sulɨben aba halu heŋ iahumi. Iahuci Asɨ Iaue agaŋ Mosesɨ dɨ ulavɨla abami. Nama Jekopɨ iamɨlɨhalinu Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Namɨlaŋ Asɨ Iaue Isipɨ fɨli tɨbɨ hɨsɨŋ agɨladɨ akuaba akuaba lalɨ agɨladɨ igahalaŋ aba abɨha uami. Havaŋ hɨbɨlakuŋ agaŋ nudɨ ninaŋ abɨŋ hɨvɨ hava via ulalɨ hameŋ ala naludɨ avi hava vavedaci igahalaŋ aba abɨha uami. Vaveci namɨlaŋ iabi nɨbu hula halu lɨguŋ neŋ hɨnidalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Fɨli akuaba akuaba ha nudɨ pam aba abɨha uami. Hulaŋ iamɨgali avi nudɨ pam aba abɨha uami. Agadɨ ala nɨbu naludɨ lɨbɨmɨŋɨci namɨlaŋ nudɨ hulaŋ iamɨgali sɨbaŋ hɨnibalaŋ aba abɨha uami. Iabi namɨlaŋ nɨbu ciaŋ mɨguavɨla abɨbali agadɨ igahɨla lubiahɨlavɨla ha namɨlaŋ nudɨ nukeŋ hulaŋ iamɨgali sɨbaŋ hɨnibalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","La nudɨ lɨhu hɨvɨ pam hɨnihɨni nusaŋ sagalɨ igu igu hɨsɨŋ hulaŋ me sibɨla vibalaŋ aba abɨha uami. Vivi nudɨ hulaŋ iamɨgali huaci sɨlɨvɨ laci hɨnibalaŋ aba abɨha uami. Isɨlaelɨ hɨdɨlɨ agɨladɨ hameŋ abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Lɨci Mosesɨ agaŋ halu vala mɨguavɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ hulaŋ hekɨlɨ hekɨlɨ agɨlasaŋ abɨci vehavɨmi. Vehavɨci Asɨ Iaue agaŋ akuaba akuaba ciaŋ vɨdɨvɨdɨŋ abami agadɨ nulɨdɨ tɨbi sulami. ");
INSERT INTO ena_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Lɨci hulaŋ iamɨgali hudɨmɨda hɨji pam hɨniavɨla abavɨmi. Asɨ Iaue aludɨ akuaba akuaba saŋ abi agɨladɨ hameŋ laci ala lɨbalu uavɨmi. Lɨhavɨci Mosesɨ agaŋ cɨhu iahuavɨla hulaŋ iamɨgali agɨladɨ ciaŋ agadɨ Asɨ Iaue dɨ abami. ");
INSERT INTO ena_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Lɨci Asɨ Iaue agaŋ cɨhu nudɨ abami. Ci igɨnaŋ uami. Viaŋ avɨli susu hekɨlɨ hɨvɨ hɨniavɨla nadɨ pɨŋ mɨguben uami. Mɨguavɨla nama hula ciaŋ abɨdalɨŋ hulaŋ iamɨgali agɨlaŋ iadɨ ciaŋ agadɨ igahɨlahɨla amɨŋ ala aba abavɨbali uami. Lɨdɨŋ nadɨ ciaŋ agasaŋ hɨji vɨdɨvɨdɨŋ hameŋ laci hameŋ laci lamavɨbali uami. Lɨci Mosesɨ agaŋ hulaŋ iamɨgali abavɨmi agadɨ Asɨ Iaue dɨ abami. ");
INSERT INTO ena_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Lɨci Asɨ Iaue agaŋ cɨhu abami. Nama uavɨla iabi amɨli hulaŋ iamɨgali agɨladɨ lamalubiha uami. Nɨbɨlaŋ iadɨ hulaŋ iamɨgali huaci sɨlɨvɨ laci hɨnihɨni saŋ nulɨdɨ lamalubiha uami. Lamalubiavɨla abɨnaŋ nulɨdɨ muhɨlɨ havɨlɨ husavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Anihuliŋ saŋ hihɨlavɨla migɨla migɨla hɨniavɨm uami. Hadɨhu heŋ ala viaŋ mɨgavɨla Sainai halu heŋ hɨnidalɨŋ hulaŋ iamɨgali agɨlaŋ iadɨ igavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","13","Nama halu agadɨ valɨ haŋala lamavɨla hulaŋ iamɨgali agɨladɨ abɨha uami. Valɨ haŋala lamin nagadɨ hemala uavɨla halu heŋ iahumɨlaŋ aba abɨha uami. Valɨ haŋala lamin nagadɨ hemala uavɨla halu agadɨ avi mɨŋaigɨmɨlaŋ aba abɨha uami. Hulaŋ mu valɨ haŋala lamin nagadɨ hemala uavɨla halu agadɨ mɨŋaigɨci ha nudɨ ifɨhɨmɨhalaŋ aba abɨha uami. Agadɨ ala human hɨvɨ ifɨhɨmɨmɨlaŋ aba abɨha uami. Nudɨ ifɨhɨmɨben aba lɨba kum kum agɨladɨ vivi havala havala ifɨhɨmɨhalaŋ ua siaŋ hɨvɨ hulihalaŋ aba abɨha uami. Sɨhɨm sabaŋ agɨlaŋ uavɨla halu agadɨ lubigavɨci nulɨdɨ avi hameŋ ala ifɨhɨmɨhalaŋ aba abɨha uami. La abami. Sai bihulɨ agalɨdaci igahɨlahɨla halu heŋ iahuavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Lɨci Mosesɨ agaŋ halu agadɨ vala mɨguavɨla hulaŋ iamɨgali Asɨ dɨ hulaŋ iamɨgali huaci sɨlɨvɨ laci hɨniavɨbali aba nulɨdɨ lamalubimi. Lamalubici nulɨdɨ muhɨlɨ havɨlɨ agɨladɨ husavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Lɨhavɨci Mosesɨ nulɨdɨ abami. Namɨlaŋ anihuliŋ saŋ hihɨlavɨla hɨnihalaŋ uami. Hɨnihɨni iabi amɨli anihuliŋ iamɨgali hula hɨnimɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Lɨci anihuliŋ me hɨvɨ cimɨdaŋ sɨbaŋ avɨli susu hekɨlɨ halu heŋ iahami. La imamulaŋ mɨŋapalɨdaci lɨbɨlaŋ ifami. Lɨdaci sai bihulɨ agaŋ hekɨlɨ agalami. Lɨci hulaŋ iamɨgali uu veve hɨnihɨni fipɨ heŋ hɨniavɨmi agɨlaŋ hekɨlɨ lɨdavɨdaci nulɨdɨ hadipɨlɨ agɨlaŋ sɨkasɨkan lɨdavalavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Lɨhavɨdaci Mosesɨ agaŋ nulɨdɨ likɨlavɨla uu veve hɨnihɨni fipɨ agadɨ valavɨla halu agadɨ lɨguŋ heŋ uavɨmi. Asɨ agaŋ ciaŋ abɨdaci igahɨlɨbalu aba ua lagulamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Lagulama hɨniavɨdaci Asɨ Iaue agaŋ avɨŋ lɨkɨla lɨkɨla hɨvɨ mɨgavɨla Sainai halu heŋ hɨnimi. Hɨnidaci avɨmɨsɨ hekɨlɨ halu agadɨ sɨkasɨkan hafilamami. Avɨmɨsɨ agaŋ avɨŋ hekɨlɨ lɨhulɨhu avɨmɨsɨ hekɨlɨ iahadami hameŋ iahami. Lɨdaci mumim hekɨlɨ halu heŋ vemi. ");
INSERT INTO ena_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Vedaci sai bihulɨ agaŋ hekɨlɨ agalami. Lɨci Mosesɨ agaŋ Asɨ hula abɨdaci Asɨ agaŋ lɨdaci sai bihulɨ agalami. Asɨ agaŋ ciaŋ cɨhu cɨhu abɨdaci Mosesɨ igahɨlami. ");
INSERT INTO ena_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Lɨci Asɨ Iaue agaŋ mɨgavɨla Sainai halu huva hɨvɨ hɨnihɨni Mosesɨ dɨ ulavɨla abɨci iahumi. ");
INSERT INTO ena_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Iahuci Asɨ Iaue nudɨ abami. Nama mɨguavɨla hulaŋ iamɨgali agɨladɨ vɨdɨvɨdɨŋ abɨha uami. Halu lɨguŋ heŋ valɨ haŋala lamahanaŋ agadɨ hemala vevɨla iadɨ igavɨmɨdɨ uami. Halu lɨguŋ heŋ valɨ haŋala lamahanaŋ agadɨ hemalavɨla ha nulɨdɨ hulaŋ iamɨgali akape agɨlaŋ hɨmavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Sagalɨ igu igu hɨsɨŋ hulaŋ iadɨ pɨŋ vehavɨlalɨ agɨlaŋ uami. Nɨbɨlaŋ iadɨ sibɨla hɨsɨŋ hulaŋ hɨnibalu aba nulɨdɨ hɨji humɨgaŋ akuaba akuaba agɨladɨ hihɨlavɨm uami. Nulɨdɨ hɨji humɨgaŋ ma hihɨlɨmaŋ lɨhavɨci ha nulɨdɨ sɨbɨlɨ lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Lɨci Mosesɨ agaŋ Asɨ Iaue dɨ abami. Nama nukeŋ nulɨdɨ abamɨgɨlavɨla iadɨ vɨdɨvɨdɨŋ abahanaŋ uami. Halu lɨguŋ heŋ valɨ haŋala lamavɨla hulaŋ iamɨgali agɨladɨ abɨha aba abahanaŋ uami. Ha Asɨ dɨ aba abɨha aba abahanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Lɨci Asɨ Iaue agaŋ Mosesɨ dɨ cɨhu ala abami. Nama mɨguavɨla Alon dɨ viavɨla ahica cɨhu iahɨhalaŋ uami. Agadɨ ala iasaŋ sagalɨ igu igu hɨsɨŋ hulaŋ agɨlaŋ hula hulaŋ iamɨgali agɨlaŋ hula halu lɨguŋ heŋ valɨ haŋala lamahanaŋ agadɨ hemalavɨla iadɨ pɨŋ halu neŋ vehavɨmɨdɨ uami. Nɨbɨlaŋ hameŋ lɨhavɨci viaŋ nulɨdɨ sɨbɨlɨ lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Lɨci Mosesɨ agaŋ mɨguavɨla Asɨ dɨ ciaŋ agadɨ hulaŋ iamɨgali agɨlasaŋ tɨbi sulami. ");
INSERT INTO ena_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Asɨ agaŋ ciaŋ vɨdɨvɨdɨŋ agɨladɨ abami. ");
INSERT INTO ena_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Viaŋ nukeŋ Asɨ Iaue uami. Viaŋ naludɨ Asɨ uami. Namɨlaŋ Isipɨ fɨli tɨbɨ heŋ lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ me hɨnihɨni sibɨla vivi hɨnidalaŋ viaŋ iadɨ nukeŋ vɨdɨvɨdɨŋ hɨvɨ naludɨ likɨlɨlɨŋ Isipɨ fɨli tɨbɨ vala vehalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Iadɨ ibi pam mɨŋaiahɨhalaŋ uami. Mugɨluŋ akuaba akuaba agɨladɨ ibi mɨŋaiahɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Namɨlaŋ akuaba akuaba fɨli hɨvɨ hɨniavɨlalɨ agɨladɨdaŋ uaiaŋ susu hɨvɨ hɨniavɨlalɨ agɨladɨdaŋ iga iga nulɨdɨ mugaŋ lamɨgaŋ me lɨhua lamavɨla aludɨ asɨ aba abɨmɨlaŋ uami. Akuaba akuaba avɨli fɨli muji hɨniavi agɨladɨ hɨvɨ hɨniavɨlalɨ agɨladɨ avi iga iga nulɨdɨ mugaŋ lamɨgaŋ me lɨhua lamavɨla aludɨ asɨ aba abɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","6","Viaŋ Asɨ Iaue uami. Viaŋ naludɨ Asɨ uami. Iadɨ uvɨsɨjiŋ agadɨ valɨlɨŋ mugɨluŋ mu ma vibali uami. Hulaŋ iamɨgali iadɨ sɨkasɨkan valavɨla hugɨ daŋ hɨniavɨci uami. Nulɨdɨ ninanadinɨlu ajihalinɨlu iamɨlɨhalinɨlu agɨlaŋ vɨhɨlɨ hameŋ laci hameŋ laci igavɨbali uami. Agadɨ ala hulaŋ iamɨgali viaŋ hula hɨnihɨni saŋ mavɨn hekɨlɨ hɨnihɨni iadɨ ciaŋ vɨdɨvɨdɨŋ agɨladɨ lubiahɨlavɨdaci viaŋ nulɨsaŋ mavɨn hɨnihɨni nulɨdɨ huaci lamɨben uami. La nulɨdɨ ninanadinɨlu ajihalinɨlu iamɨlɨhalinɨlu agɨlasaŋ mavɨn hɨnihɨni nulɨdɨ huaci lamɨben uami. Iamɨlɨhalinɨlu dɨ ninanadinɨlu mufɨli mufɨli iahavɨbali agɨladɨ avi hameŋ laci ala nulɨsaŋ mavɨn hɨnihɨni nulɨdɨ huaci lamɨben uami. Hameŋ sadaŋ namɨlaŋ kɨlɨ akuaba akuaba lɨhulɨhu lamalama aludɨ asɨ aba abavɨlalɨ agɨlasaŋ mɨgalɨfɨlɨbavɨla aludɨ asɨ aba abɨmɨlaŋ uami. La nulɨdɨ lɨhu hɨvɨ hɨnimɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Viaŋ naludɨ Asɨ Iaue uami. Namɨlaŋ iadɨ ibi havɨ havɨ luvɨlɨmɨlaŋ uami. Hulaŋ iamɨgali iadɨ ibi havɨ havɨ luvɨlavɨlalɨ agɨladɨ sɨbɨlɨ sɨbaŋ lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","11","Viaŋ uaiaŋ human limu fɨhala human limu pabiŋ cɨjɨŋ hɨvɨ fɨli uaiaŋ susu agɨladɨ lamamin uami. Avɨli hekɨlɨ akuaba akuaba agɨladɨ avi lamamin uami. Lama fɨhalɨlɨŋ hɨfɨlɨ hɨnia mɨŋalahɨci alusamin uami. Lavɨla mɨhiŋ alusamin agadɨ huaci lamavɨla abamin uami. Ha iadɨ alusɨsɨ mɨhiŋ hekɨlɨ aba abamin uami. Namɨlaŋ alusɨsɨ mɨhiŋ agasaŋ sɨhɨvia igahɨlavɨla lɨbɨmɨŋɨlaŋ iadɨ nukeŋ mɨhiŋ hɨnim uami. Naludɨ sibɨla akuaba akuaba vivi mɨhiŋ ha human limu fɨhala human limu pabiŋ cɨjɨŋ laci uami. Agadɨ ala alusɨsɨ mɨhiŋ ha iadɨ uami. Viaŋ naludɨ Asɨ Iaue uami. Ha alusɨsɨ mɨhiŋ sadaŋ sibɨla vimɨlaŋ uami. Namɨlaŋ naludɨ ninanadinalu agɨlaŋ hula sibɨla vimɨlaŋ uami. Naludɨ sibɨla hɨsɨŋ hulaŋ iamɨgali agɨlaŋ sibɨla vihavɨmɨdɨ uami. Hulaŋ ihɨlɨŋ ve namɨlaŋ hula hɨniavɨlalɨ agɨlaŋ sibɨla vihavɨmɨdɨ uami. Naludɨ sabaŋ bulɨmakau agɨlaŋ avi sibɨla vihavɨmɨdɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Namɨlaŋ naludɨ iamiagagalinalu agɨladɨ lɨhu hɨvɨ hɨnihɨni nulɨdɨ ciaŋ agɨladɨ lubiahɨlɨhalaŋ uami. Namɨlaŋ hameŋ lavɨla ha lɨhalɨha ma hɨmɨbalaŋ uami. La fɨli tɨbɨ nalusaŋ iguben aba lin heŋ huaci hutesɨ hɨnibalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Namɨlaŋ hulaŋ iamɨgali limu hɨhɨle agɨladɨ ifɨhɨmɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Hulaŋ iamɨgali daŋ namɨlaŋ naludɨ abinadinalu agɨladɨ valavala uu iamɨgali mu mu agɨladɨ sɨgɨlɨ vimɨlaŋ uami. Iamɨgali hulaŋ daŋ namɨlaŋ naludɨ muŋanadinalu agɨladɨ valavala uu hulaŋ mu mu agɨladɨ sɨgɨlɨ vimɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Namɨlaŋ mu hulaŋ dɨ akuaba akuaba agɨladɨ avi sɨgɨlɨ vimɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Namɨlaŋ analɨ ciaŋ aba aba mu hulaŋ dɨ ciaŋ hɨvɨ lamɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Namɨlaŋ hulaŋ mu dɨ ulaŋ agadɨ mavɨn igɨmɨlaŋ uami. Hulaŋ mu dɨ iamɨgali agadɨ mavɨn igɨmɨlaŋ uami. Nudɨ sibɨla hɨsɨŋ hulaŋ iamɨgali agɨladɨdaŋ sabaŋ bulɨmakau sabaŋ donɨki akuaba akuaba agɨladɨdaŋ avi mavɨn igɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Lɨdaci hulaŋ iamɨgali agɨlaŋ imamulaŋ mɨŋapalapala lɨbɨlaŋ ifu ifu sai bihulɨ agala agala hɨnimi agadɨ igahɨlavɨmi. Igahɨlahɨla igavɨdaci avɨmɨsɨ hekɨlɨ halu heŋ iahami. Iahɨdaci igavɨla hekɨlɨ lɨdavɨmi. La lɨdavalavala cɨhu halu agadɨ vala umitavɨla ataŋ tagɨlaŋ daŋ lagulamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","La Mosesɨ dɨ abavɨmi. Nama nukeŋ aludɨ abɨdanaŋ huaci igahɨlɨbalu uavɨmi. Asɨ aludɨ abɨci alaŋ hɨmɨmagalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Lɨhavɨci Mosesɨ nulɨdɨ abami. Namɨlaŋ lɨdɨmɨlaŋ uami. Asɨ agaŋ naludɨ hɨji vɨdɨvɨdɨŋ agadɨ igɨben aba li uami. Lɨci namɨlaŋ nusaŋ lɨdalɨda akuaba akuaba lusɨŋ sɨbɨlɨ ma vibalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Lɨci hulaŋ iamɨgali agɨlaŋ ataŋ tagɨlaŋ daŋ lagulama hɨniavɨmi. Lagulama hɨniavɨdaci Mosesɨ agaŋ avɨli susu hekɨlɨ agadɨ mikɨ pɨŋ umi. Asɨ agaŋ avɨli susu hekɨlɨ heŋ ala hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Lɨci Asɨ Iaue agaŋ Mosesɨ dɨ abami. Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨha uami. Asɨ Iaue agaŋ nudɨ haiabɨla hɨvɨ hɨnihɨni namɨlaŋ hula ciaŋ sulɨdaci ci igahɨlahalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Namɨlaŋ lɨba golɨ lɨba silɨva agɨladɨ vivi lamalama aludɨ asɨ aba abɨmɨlaŋ aba abɨha uami. Namɨlaŋ Asɨ Iaue dɨ lɨhu hɨvɨ hɨnihɨni nudɨ pam aludɨ Asɨ aba abɨhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Fɨli savu mɨŋɨlaŋ iahua vadɨm me hɨnici heŋ laci ala sabaŋ sipsipɨ sabaŋ bulɨmakau Asɨ saŋ sagalɨ sɨkasɨkan hɨla fɨhalɨhalaŋ aba abɨha uami. La nɨbu hula humɨgaŋ pam hɨnihɨni saŋ sagalɨ iguhalaŋ aba abɨha uami. Asɨ fipɨ abeba saŋ lɨbɨmɨŋɨbali heŋ laci ala nudɨ ibi mɨŋaiahaiaha sagalɨ iguhalaŋ aba abɨha uami. Hameŋ lɨlaŋ Asɨ naludɨ huaci lamɨbali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Sagalɨ hɨlahɨla hɨsɨŋ lɨba vadɨm ibilɨben aba lɨba kum hulaŋ lɨhuavɨci sɨlɨvɨ hɨniavɨlalɨ agɨladɨ viavɨla ibilɨmɨlaŋ aba abɨha uami. Hulaŋ mu lɨba kum lɨhuci sɨlɨvɨ hɨniavɨlalɨ agɨladɨ viavɨla nulɨdɨ hɨvɨ vilabɨla Asɨ igɨci sɨbɨlɨ sɨbaŋ hɨnibali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Sagalɨ hɨlahɨla hɨsɨŋ vadɨm vibavɨla hɨvɨ hekɨlɨ vimɨlaŋ aba abɨha uami. Vadɨm agaŋ iahaiaha mɨgumɨgu hɨbɨ apalɨ hɨnibali aba abɨha uami. Vadɨm hɨvɨ hekɨlɨ ibilavɨla iahaiaha mɨgumɨgu heŋ iahuavɨla sagalɨ iguben aba havɨlɨ kɨvɨkɨvɨ lɨbavɨla iahulaŋ Asɨ igɨci sɨbɨlɨ lɨbali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Lavɨla Asɨ cɨhu Mosesɨ dɨ abami. Nama Isɨlaelɨ hɨdɨlɨ agɨlasaŋ ciaŋ vɨdɨvɨdɨŋ nagɨladɨ abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Isɨlaelɨ hɨdɨlɨ namɨlaŋ naludɨ hulaŋ mu Ibɨlu ciaŋ hɨsɨŋ agadɨ lavɨlaŋ naludɨ sibɨla hɨsɨŋ hulaŋ hɨniavɨla ha nɨbu sibɨla vivi hɨnidaci hualɨ human limu fɨhala human limu pabiŋ cɨjɨŋ um aba abɨha uami. Sibɨla vivi hɨnidaci hualɨ hameŋ agɨlaŋ uavɨci cɨhu hualɨ mu iahɨci nudɨ valɨlaŋ havɨ um aba abɨha uami. Nɨbu nalusaŋ anɨm hɨlɨcɨ cɨhu hɨbɨŋ igumɨdɨ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Hulaŋ agaŋ iamɨgali daŋ ma hɨniavɨla sibɨla hameŋ agadɨ viavɨla ha nɨbu hɨtɨŋ huaci ubali aba abɨha uami. Agadɨ ala iamɨgali daŋ hɨniavɨla sibɨla hameŋ agadɨ viavɨla ha nɨbu abinu dɨ huaci via ahica uavɨbali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Manɨgali agaŋ nudɨ sibɨla hɨsɨŋ hulaŋ agasaŋ iamɨgali iguci ninanadi huhɨlɨci nudɨ iamɨgali ninanadi agɨlaŋ manɨgali agaŋ hula hɨniavɨm aba abɨha uami. Hulaŋ agaŋ laci sibɨla agadɨ valavɨla huaci ubali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Agadɨ ala sibɨla hɨsɨŋ hulaŋ agaŋ nameŋ abɨci aba abɨha uami. Viaŋ iadɨ manɨgali iadɨ iamɨgali ninanadi agɨlasaŋ mavɨn hekɨlɨ hɨniavɨla nulɨdɨ ma vala uben aba abɨci aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Ha manɨgali agaŋ nudɨ viavɨla ciaŋ hihɨla hihɨla hɨsɨŋ agɨladɨ pɨŋ um aba abɨha uami. Via uci hɨbɨ ivu ivu heŋ lagulama hɨnim aba abɨha uami. Hɨnidaci manɨgali agaŋ sibɨla hɨsɨŋ hulaŋ agadɨ hɨji asɨŋ agadɨ hɨbɨ lapa agadɨdaŋ lama lɨmɨlɨben aba hameŋ ala lɨm aba abɨha uami. Hɨbɨ lapa hɨsɨŋ hɨda agadɨdaŋ lama lɨmɨlɨben aba hameŋ ala lɨm aba abɨha uami. Lɨci sibɨla hɨsɨŋ hulaŋ agaŋ manɨgali dɨ sibɨla hɨsɨŋ hulaŋ hɨnihɨni sibɨla havɨ havɨ vivi hɨniavɨla hɨmɨbali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Hulaŋ mu nudɨ nadinu dɨ mutɨŋ hɨvɨ lamɨci lavɨlaŋ sibɨla vivi hɨnidaci hualɨ human limu fɨhala human limu pabiŋ cɨjɨŋ uci aba abɨha uami. Cɨhu hualɨ mu iahɨci sibɨla hɨsɨŋ hulaŋ agɨladɨ valɨdalaŋ uavɨlalɨ hameŋ laci ala sibɨla hɨsɨŋ iamɨgali agadɨ valɨlaŋ havɨ umɨdɨ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Hulaŋ mu agaŋ sibɨla hɨsɨŋ iamɨgali mu agadɨ lavɨci nudɨ iamɨgali hɨnibali aba abɨha uami. Lɨci nudɨ sɨbɨlɨ igavɨla lahuben aba lɨci iamɨgali agadɨ iaganu agaŋ anɨm hɨlɨcɨ akuaba akuaba agɨladɨ cɨhu hulaŋ nudɨ lavami agasaŋ igubali aba abɨha uami. Hulaŋ agaŋ iamɨgali agadɨ sɨbɨlɨ igɨlalɨ sadaŋ iamɨgali agadɨ hulaŋ fɨli tɨbɨ mu hɨsɨŋ agɨlasaŋ mutɨŋ hɨvɨ lamɨci lavavɨmɨdɨ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Agadɨ ala iamɨgali agadɨ nudɨ ninanu saŋ iguben aba nudɨ nukeŋ nadinu dɨ huaci lamɨlalɨ hameŋ laci ala iamɨgali agadɨ avi huaci lamam aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Manɨgali agaŋ iamɨgali mu sabiavɨla nudɨ sibɨla hɨsɨŋ iamɨgali vaka sabilɨ agadɨ avi huaci lamam aba abɨha uami. La hadi hɨlahɨla sɨmɨŋ akuaba akuaba nusaŋ igum aba abɨha uami. La iamɨgali hɨvɨ agaŋ hula hɨnilalɨ hameŋ laci ala lɨvɨlu agaŋ hula hɨnim aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Hulaŋ agaŋ akuaba akuaba hameŋ agɨladɨ iamɨgali lɨvɨlu agasaŋ ma iguavɨla ha iamɨgali lɨvɨlu agadɨ havɨ valɨci um aba abɨha uami. Lɨci iamɨgali lɨvɨlu agaŋ muŋanu saŋ anɨm hɨlɨcɨ cɨhu hɨbɨŋ igumɨdɨ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Lavɨla Asɨ cɨhu Mosesɨ dɨ abami. Nama Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨha uami. Hulaŋ mu agaŋ hulaŋ mu dɨ ifɨhɨmɨci ha nudɨ hɨbɨŋ ifɨhɨmɨhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Agadɨ ala hulaŋ mu agaŋ hulaŋ mu agadɨ ifɨhɨmuhɨmu hɨji ma lamavɨla ahica sibɨla vivi hɨniavɨla lɨci hulaŋ mu agaŋ hɨmɨci nɨbu haŋɨlavɨla haiabɨla Asɨ lɨbɨmɨŋɨbali heŋ uavɨla huaci hɨnibali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Hulaŋ mu agaŋ hulaŋ mu dɨ ifɨhɨmɨben aba nudɨ igalamalama hɨdavɨla nudɨ ifɨhɨmɨci nudɨ hɨbɨŋ ifɨhɨmɨhalaŋ aba abɨha uami. Hulaŋ agaŋ iadɨ ifɨhɨmavɨmɨdɨ aba iadɨ sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ mɨŋalɨvɨci ala nudɨ via uavɨla mu abɨla hɨvɨ ifɨhɨmɨhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Hulaŋ mu agaŋ iamiaganu dɨ ifɨhɨmɨci nudɨ hɨbɨŋ ifɨhɨmɨhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Hulaŋ sɨbɨlɨ agaŋ hulaŋ mu agadɨ vɨdɨvɨdɨŋ mɨŋalɨvavɨla magɨla via uben aba lɨdaci igavɨla hulaŋ sɨbɨlɨ agadɨ ifɨhɨmɨhalaŋ aba abɨha uami. Hulaŋ sɨbɨlɨ agaŋ hulaŋ mu agadɨ vɨdɨvɨdɨŋ mɨŋalɨvɨci nudɨ sibɨla hɨsɨŋ hulaŋ me hɨnidaci via ua mutɨŋ hɨvɨ lamɨci nudɨ lavavɨci igavɨla hulaŋ sɨbɨlɨ agadɨ ifɨhɨmɨhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Hulaŋ mu iamiaganu dɨ cilu lɨhuci nudɨ ifɨhɨmɨhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","Hulaŋ ahica agɨlaŋ lamacilavɨla hulaŋ mu agaŋ hulaŋ mu agadɨ human hɨvɨ ua lɨba kum hɨvɨ ifɨci sɨbɨlɨ lavɨla vadɨm hɨvɨ pam ani hɨnibali aba abɨha uami. Ma hɨmɨbali aba abɨha uami. La cɨhu iahavɨla kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agadɨ mɨŋalɨva hɨdɨdaci aba abɨha uami. Ha hulaŋ nudɨ ifami agaŋ nusaŋ anɨm hɨlɨcɨ igum aba abɨha uami. Igudaci hulaŋ agaŋ huaci hɨnihɨni anɨm hɨlɨcɨ vilalɨ hameŋ laci ala vibali aba abɨha uami. Hulaŋ anɨm hɨlɨcɨ sibɨla vilalɨ agaŋ uaiaŋ vameba sibɨla valɨci hulaŋ nudɨ ifami agaŋ nusaŋ anɨm hɨlɨcɨ igum aba abɨha uami. Uaiaŋ vameba sibɨla valalɨ agɨlasaŋ igahɨlavɨla igum aba abɨha uami. Igu igu nudɨ migɨla migɨla hɨnidaci hulaŋ agaŋ sɨkasɨkan huaci lɨm aba abɨha uami. Lɨci hɨbɨŋ hulaŋ agadɨ ifɨmɨlaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Manɨgali mu nudɨ kɨlɨ lɨmɨ via hɨdahɨda hɨsɨŋ agadɨ viavɨla nudɨ sibɨla hɨsɨŋ hulaŋ ua iamɨgali ua agadɨ ifu ifu hɨnici hɨmɨci aba abɨha uami. Ha manɨgali agadɨ avi ifɨhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Agadɨ ala sibɨla hɨsɨŋ hulaŋ ua iamɨgali ua agaŋ uaiaŋ pabiŋ ua ahica ua hɨniavɨla hɨmɨci aba abɨha uami. Ha nudɨ manɨgali agadɨ ifɨmɨlaŋ aba abɨha uami. Hulaŋ iamɨgali nudɨ nukeŋ sibɨla hɨsɨŋ sadaŋ nɨbu ciaŋ apalɨ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Hulaŋ agɨlaŋ sagaŋ lɨbavɨla hulaŋ mu agaŋ iamɨgali mu humɨgaŋ daŋ agadɨ ifɨci iamɨgali agaŋ ninaŋ huhɨla huhɨla mɨhiŋ agadɨ alɨhaŋ hɨnilɨfavɨla ninaŋ huaci huhɨlɨci aba abɨha uami. Iamɨgali agadɨ muŋanu agaŋ anɨm hɨlɨcɨ vameba igu igu saŋ hulaŋ agadɨ abɨci iamɨgali agasaŋ anɨm hɨlɨcɨ hameŋ laci ala igum aba abɨha uami. Ciaŋ hihɨla hihɨla hɨsɨŋ hulaŋ agaŋ anɨm hɨlɨcɨ agadɨ igavɨla alia aba abɨci aba abɨha uami. Ha iamɨgali agadɨ muŋanu agaŋ anɨm hɨlɨcɨ agadɨ heŋ vim aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Agadɨ ala iamɨgali agadɨ vɨhɨlɨ iahɨci ha hulaŋ agadɨ hɨbɨŋ vɨhɨlɨ iguhalaŋ aba abɨha uami. Iamɨgali agaŋ hɨmɨci ha hulaŋ agadɨ hɨbɨŋ ifɨhɨmɨhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Nudɨ lamɨgaŋ ifɨcɨpɨlɨci ha hɨbɨŋ nudɨ lamɨgaŋ agadɨ avi ifɨcɨpɨlɨhalaŋ aba abɨha uami. Nudɨ mɨka ifɨtaualɨci ha hɨbɨŋ nudɨ mɨka agadɨ avi ifɨtaualɨhalaŋ aba abɨha uami. Nudɨ hɨcɨ agadɨ sɨbɨlɨ lamɨci ha hɨbɨŋ nudɨ hɨcɨ agadɨ avi sɨbɨlɨ lamɨhalaŋ aba abɨha uami. Nudɨ human agadɨ sɨbɨlɨ lamɨci ha hɨbɨŋ nudɨ human agadɨ avi sɨbɨlɨ lamɨhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Nudɨ avɨŋ hɨvɨ hɨlɨci ha hulaŋ agadɨ avi hɨbɨŋ hameŋ laci avɨŋ hɨvɨ hɨlɨhalaŋ aba abɨha uami. Nudɨ hadipɨlɨ agadɨ sɨbɨlɨ lamɨci fim iahɨci ha hulaŋ agadɨ avi hɨbɨŋ hameŋ laci nudɨ hadipɨlɨ agadɨ sɨbɨlɨ lamɨlaŋ fim iaham aba abɨha uami. Nudɨ vɨgɨlɨci ha hulaŋ agadɨ avi hɨbɨŋ hameŋ laci vɨgɨlɨhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Manɨgali mu nudɨ sibɨla hɨsɨŋ hulaŋ ua iamɨgali ua agadɨ lamɨgaŋ ifɨcɨpɨlavɨla aba abɨha uami. Ha lamɨgaŋ ifɨcɨpɨli agasaŋ igahɨlavɨla abɨci havɨ um aba abɨha uami. Uavɨla manɨgali agadɨ lɨhu hɨvɨ hɨnimɨdɨ aba abɨha uami. Nɨbu nudɨ nukeŋ sibɨla akuaba akuaba agɨladɨ vim aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Sibɨla hɨsɨŋ hulaŋ ua iamɨgali ua agadɨ mɨka ifɨtaualavɨla aba abɨha uami. Ha mɨka ifɨtauali agasaŋ igahɨlavɨla abɨci havɨ um aba abɨha uami. Uavɨla manɨgali agadɨ lɨhu hɨvɨ hɨnimɨdɨ aba abɨha uami. Nɨbu nudɨ nukeŋ sibɨla akuaba akuaba agɨladɨ vim aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Lavɨla Asɨ Iaue agaŋ Mosesɨ dɨ cɨhu ala abami. Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨha uami. Sabaŋ bulɨmakau agaŋ nudɨ hali makaŋ agadɨ hɨvɨ hulaŋ ua iamɨgali ua agadɨ iamɨlahɨmɨci ha lɨba kum kum agɨladɨ vivi havala havala sabaŋ bulɨmakau agadɨ ifɨhɨmɨhalaŋ aba abɨha uami. Ifɨhɨmavɨla nudɨ hɨlɨcɨ agɨladɨ nɨmɨlaŋ aba abɨha uami. Lɨlaŋ sabaŋ bulɨmakau iaganu agaŋ ciaŋ apalɨ hɨnibali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Agadɨ ala sabaŋ bulɨmakau hulaŋ iamɨgali iamɨlɨlalɨ agasaŋ iaganu dɨ vɨdɨvɨdɨŋ abɨlaŋ lua ma hahavɨla lamɨci hɨniavɨla hulaŋ ua iamɨgali ua iamɨlahɨmɨci aba abɨha uami. Ha lɨba kum kum agɨladɨ vivi havala havala nudɨ sabaŋ bulɨmakau agadɨ ifɨhɨmavɨla iaganu dɨ avi ifɨhɨmɨhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ciaŋ hihɨla hihɨla hɨsɨŋ hulaŋ agaŋ hulaŋ ua iamɨgali ua hɨmalɨ agasaŋ igahɨlavɨla anɨm hɨlɨcɨ igu igu saŋ abɨci aba abɨha uami. Ha sabaŋ bulɨmakau iaganu nudɨ nukeŋ hugɨ agadɨ lavam aba abɨha uami. Hameŋ lavɨla ma hɨmɨbali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Sabaŋ bulɨmakau agaŋ ninaŋ ua nadi ua iamɨlahɨmɨci aba abɨha uami. Ha sabaŋ bulɨmakau iaganu nudɨ nukeŋ hugɨ agadɨ lavam aba abɨha uami. Hameŋ lavɨla ma hɨmɨbali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Sabaŋ bulɨmakau agaŋ sibɨla hɨsɨŋ hulaŋ ua iamɨgali ua agadɨ iamɨlahɨmɨci aba abɨha uami. Sabaŋ bulɨmakau iaganu agaŋ anɨm hɨlɨcɨ lɨba silɨva 30 agɨladɨ sibɨla hɨsɨŋ agadɨ manɨgali agasaŋ igum aba abɨha uami. Lɨci lɨba kum kum agɨladɨ vivi havala havala sabaŋ bulɨmakau agadɨ ifɨhɨmɨhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Hulaŋ mu agaŋ haca mava hafilamavɨmi agadɨ mɨŋalavɨlɨci ua haca nɨbu nukeŋ mavavɨla ma lalɨguci sabaŋ bulɨmakau ua sabaŋ donɨki ua haca heŋ mɨgua hɨmɨci aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","Hulaŋ haca mavalɨ agaŋ hugɨ daŋ hɨniavɨla sabaŋ iaganu agasaŋ anɨm hɨlɨcɨ igubali aba abɨha uami. La sɨhɨm valɨ agadɨ nɨbu nukeŋ huaci vibali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Sabaŋ bulɨmakau hulaŋ mu dɨ agaŋ hulaŋ mu dɨ agaŋ hula sagaŋ lɨbavɨla hulaŋ mu dɨ agaŋ hɨmɨci aba abɨha uami. Sabaŋ bulɨmakau mu hɨhi hɨni agadɨ ahica mutɨŋ hɨvɨ lamavɨci lavavɨm aba abɨha uami. Lɨhavɨci anɨm hɨlɨcɨ agɨladɨ viavɨla sabaŋ bulɨmakau hɨmalɨ agadɨ hɨlɨcɨ agɨladɨ viavɨla ahica hameŋ labɨlavɨla vihavɨm aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Agadɨ ala sabaŋ bulɨmakau sagaŋ daŋ agasaŋ nudɨ iaganu agaŋ lua sɨhɨvia ma hahavɨla lamɨci hɨnici aba abɨha uami. Ha sabaŋ bulɨmakau sagaŋ daŋ agadɨ sabaŋ bulɨmakau hɨmalɨ agadɨ iaganu saŋ hɨbɨŋ igum aba abɨha uami. La nɨbu nukeŋ sabaŋ bulɨmakau valɨ agadɨ vim aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Lavɨla Asɨ cɨhu Mosesɨ dɨ abami. Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨha uami. Hulaŋ mu agaŋ hulaŋ mu dɨ sabaŋ bulɨmakau muŋaŋ agadɨ sɨgɨlɨ via uavɨla ifɨhɨmavɨla ha sabaŋ bulɨmakau agadɨ iaganu saŋ sabaŋ bulɨmakau human limu fɨhala hameŋ agɨladɨ cɨhu hɨbɨŋ igum aba abɨha uami. Hulaŋ mu agaŋ hulaŋ mu dɨ sabaŋ bulɨmakau muŋaŋ agadɨ sɨgɨlɨ via uavɨla mutɨŋ hɨvɨ lamɨci lavavɨci ha sabaŋ bulɨmakau agadɨ iaganu saŋ sabaŋ bulɨmakau human limu fɨhala hameŋ agɨladɨ cɨhu hɨbɨŋ igum aba abɨha uami. Hulaŋ mu agaŋ hulaŋ mu dɨ sabaŋ sipsipɨ agadɨ sɨgɨlɨ via uavɨla ifɨhɨmavɨla ha sabaŋ sipsipɨ agadɨ iaganu saŋ sabaŋ sipsipɨ limu ahica limu ahica hameŋ agɨladɨ cɨhu hɨbɨŋ igum aba abɨha uami. Hulaŋ mu agaŋ hulaŋ mu dɨ sabaŋ sipsipɨ agadɨ sɨgɨlɨ via uavɨla mutɨŋ hɨvɨ lamɨci lavavɨci ha sabaŋ sipsipɨ agadɨ iaganu saŋ sabaŋ sipsipɨ limu ahica limu ahica hameŋ agɨladɨ cɨhu hɨbɨŋ igum aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Hulaŋ sɨgɨlɨ hɨsɨŋ agaŋ cɨhu sɨhɨm sabaŋ iaganu agasaŋ hɨbɨŋ amɨŋ sɨbaŋ igum aba abɨha uami. Agadɨ ala nɨbu sɨhɨm sabaŋ hɨbɨŋ igu igu agaŋ apalɨ lɨci aba abɨha uami. Ha sɨhɨm sabaŋ iaganu agaŋ hulaŋ sɨgɨlɨ vilɨ agadɨ via ua nudɨ sibɨla hɨsɨŋ hulaŋ me mutɨŋ hɨvɨ lamɨci lavavɨci anɨm hɨlɨcɨ vim aba abɨha uami. Sabaŋ bulɨmakau sɨgɨlɨ vilɨ agadɨ via hɨniavɨla sabaŋ bulɨmakau iaganu agaŋ hula hugɨ hivɨben aba sabaŋ bulɨmakau nudɨ nukeŋ agadɨ ahica vim aba abɨha uami. Lavɨla sabaŋ bulɨmakau sɨgɨlɨ vilɨ agadɨdaŋ vave sabaŋ bulɨmakau iaganu agasaŋ igum aba abɨha uami. Sabaŋ donɨki sɨgɨlɨ vilɨ agadɨ via hɨniavɨla sabaŋ donɨki iaganu agaŋ hula hugɨ hivɨben aba sabaŋ donɨki nudɨ nukeŋ agadɨ ahica vim aba abɨha uami. Lavɨla sabaŋ donɨki sɨgɨlɨ vilɨ agadɨdaŋ vave sabaŋ donɨki iaganu agasaŋ igum aba abɨha uami. Sabaŋ sipsipɨ sɨgɨlɨ vilɨ agadɨ via hɨniavɨla sabaŋ sipsipɨ iaganu agaŋ hula hugɨ hivɨben aba sabaŋ sipsipɨ nudɨ nukeŋ agadɨ ahica vim aba abɨha uami. Lavɨla sabaŋ sipsipɨ sɨgɨlɨ vilɨ agadɨdaŋ vave sabaŋ sipsipɨ iaganu agasaŋ igum aba abɨha uami. Sɨgɨlɨ hɨsɨŋ hulaŋ hɨfɨlɨ vevɨla ulaŋ ifɨpilɨdaci ulaŋ iaganu agaŋ nudɨ mɨŋalɨva ifɨhɨmavɨla ha nɨbu hugɨ apalɨ hɨnibali aba abɨha uami. Agadɨ ala uaiadi hɨvɨ vevɨla ifɨpilɨdaci mɨŋalɨva nudɨ ifɨhɨmavɨla ha nɨbu hugɨ daŋ hɨnibali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Hulaŋ mu agaŋ nudɨ sabaŋ bulɨmakau akuaba akuaba valɨci uavɨla humɨsɨ akuaba akuaba nudɨ lɨmɨn uain hualabɨla hɨniavɨbali heŋ nana uavɨla nudɨ valɨ agadɨ lɨvala uavɨla hulaŋ mu dɨ lɨmɨn uain hualabɨla akuaba akuaba agɨladɨ navɨci aba abɨha uami. Ha sabaŋ bulɨmakau agɨladɨ iaganɨlu agaŋ hualabɨla hɨsɨŋ sɨmɨŋ lɨmɨn uain agɨladɨ amɨŋ akuaba akuaba huaci huaci nudɨ nukeŋ agɨladɨ cɨhu hulaŋ mu agasaŋ hɨbɨŋ igum aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Hulaŋ mu agaŋ humɨsɨ akuaba akuaba nudɨ halɨha cahu uitɨ hualabɨla caba heŋ hɨniavɨbali agɨladɨ avɨŋ lubilamɨci lɨhulɨhu ubali aba abɨha uami. Lɨhulɨhu uci hulaŋ mu agadɨ halɨha cahu uitɨ limu hɨhɨle hualabɨla lagulama hɨniavɨbali agɨlaŋ avi lɨhuavɨbali aba abɨha uami. Lɨhuavɨci hulaŋ avɨŋ lubilamɨbali agaŋ sɨmɨŋ akuaba akuaba lɨhuavɨbali agɨlasaŋ cɨhu hɨbɨŋ igum aba abɨha uami. Hulaŋ mu agaŋ humɨsɨ akuaba akuaba nudɨ halɨha cahu uitɨ hualabɨla caba heŋ hɨniavɨbali agɨladɨ avɨŋ lubilamɨci lɨhulɨhu ubali aba abɨha uami. Lɨhulɨhu uci hulaŋ mu agadɨ halɨha cahu uitɨ hualabɨla ihalahavɨla mɨgudɨbavɨbali agɨlaŋ avi lɨhuavɨbali aba abɨha uami. Lɨhuavɨci hulaŋ avɨŋ lubilamɨbali agaŋ sɨmɨŋ akuaba akuaba lɨhuavɨbali agɨlasaŋ cɨhu hɨbɨŋ igum aba abɨha uami. Hulaŋ mu agaŋ humɨsɨ akuaba akuaba nudɨ halɨha cahu uitɨ hualabɨla caba heŋ hɨniavɨbali agɨladɨ avɨŋ lubilamɨci lɨhulɨhu ubali aba abɨha uami. Lɨhulɨhu uci hulaŋ mu agadɨ halɨha cahu uitɨ hualabɨla agaŋ avi sɨkasɨkan lɨhubali aba abɨha uami. Lɨhuci hulaŋ avɨŋ lubilamɨbali agaŋ sɨmɨŋ akuaba akuaba lɨhuavɨbali agɨlasaŋ cɨhu hɨbɨŋ igum aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Hulaŋ mu agaŋ nudɨ anɨm hɨlɨcɨ akuaba akuaba nudɨ haiabɨla pam hɨsɨŋ agadɨ human hɨvɨ lama vala udaci cɨhu hulaŋ mu sɨgɨlɨ hɨsɨŋ agaŋ ve akuaba akuaba agɨladɨ sɨgɨlɨ vici aba abɨha uami. Ha nudɨ mɨŋalɨvavɨla abɨlaŋ akuaba akuaba sɨgɨlɨ vibali agasaŋ cɨhu hɨbɨŋ akuaba akuaba ahica lɨdɨŋ ahica lɨdɨŋ hameŋ laci igum aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Agadɨ ala hulaŋ sɨgɨlɨ hɨsɨŋ agadɨ ma igavɨla ha hulaŋ akuaba akuaba migɨlɨbali agadɨ ciaŋ hihɨla hihɨla hɨsɨŋ hulaŋ agɨladɨ pɨŋ via uhalaŋ aba abɨha uami. Lɨlaŋ abam aba abɨha uami. Hɨma sɨbaŋ aba abam aba abɨha uami. Viaŋ akuaba akuaba agɨladɨ sɨgɨlɨ ma vicin aba abam aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Sabaŋ bulɨmakau sabaŋ donɨki sabaŋ sipsipɨ muhɨlɨ havɨlɨ akuaba akuaba agɨlaŋ sɨvɨlavɨci cɨhu hulaŋ ahica haiabɨla pam hɨsɨŋ agɨlaŋ igavɨla hɨbɨŋ hɨbɨŋ nameŋ abavɨbali aba abɨha uami. Ha nadɨ hɨma ha iadɨ aba abavɨbali aba abɨha uami. Lɨhavɨci nulɨdɨ ciaŋ hihɨla hihɨla hɨsɨŋ hulaŋ agɨladɨ pɨŋ via uhalaŋ aba abɨha uami. Via ulaŋ hulaŋ mu analɨ abɨlalɨ agadɨ abalamavɨci nɨbu nudɨ haiabɨla pam hɨsɨŋ agasaŋ akuaba akuaba ahica lɨdɨŋ ahica lɨdɨŋ igum aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","11","Hulaŋ mu sabaŋ donɨki sabaŋ bulɨmakau sabaŋ sipsipɨ sɨhɨm akuaba akuaba agɨladɨ nudɨ haiabɨla pam hɨsɨŋ agadɨ human hɨvɨ lama vala udaci aba abɨha uami. Sɨhɨm sabaŋ akuaba akuaba agɨladɨ hɨcɨ human sɨbɨlɨ lɨhavɨci ua havɨ hɨmavɨci aba abɨha uami. Ha Asɨ Iaue dɨ ibi hɨvɨ nameŋ abam aba abɨha uami. Hɨma sɨbaŋ aba abam aba abɨha uami. Viaŋ nadɨ sɨhɨm akuaba akuaba ma sɨbɨlɨ lamacin aba abam aba abɨha uami. Hulaŋ mu sabaŋ donɨki sabaŋ bulɨmakau sabaŋ sipsipɨ sɨhɨm akuaba akuaba agɨladɨ nudɨ haiabɨla pam hɨsɨŋ agadɨ human hɨvɨ lama vala udaci aba abɨha uami. Hulaŋ sɨbɨlɨ agɨlaŋ via uavɨci akuaba akuaba agɨladɨ ma igɨmaŋ lavɨla aba abɨha uami. Han avi Asɨ Iaue dɨ ibi hɨvɨ abam aba abɨha uami. Hɨma sɨbaŋ aba abam aba abɨha uami. Viaŋ nadɨ sɨhɨm akuaba akuaba sɨgɨlɨ ma vicin aba abam aba abɨha uami. Lɨci sɨhɨm akuaba akuaba agɨladɨ iaganu agaŋ amɨŋ ala abi aba abavɨla nudɨ haiabɨla pam hɨsɨŋ agadɨ akuaba akuaba hɨbɨŋ igu igu saŋ abɨmɨdɨ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Hulaŋ mu sabaŋ donɨki sabaŋ bulɨmakau sabaŋ sipsipɨ sɨhɨm akuaba akuaba agɨladɨ nudɨ haiabɨla pam hɨsɨŋ agadɨ human hɨvɨ lama vala udaci aba abɨha uami. Nudɨ haiabɨla pam hɨsɨŋ agaŋ sɨhɨm sabaŋ akuaba akuaba agɨladɨ migɨla migɨla hɨnidaci hulaŋ limu hɨhɨle agɨlaŋ sɨgɨlɨ vihavɨci aba abɨha uami. Nɨbu sɨhɨm sabaŋ iaganu agasaŋ hɨbɨŋ igum aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Agadɨ ala sudɨ iŋam agaŋ sabaŋ bulɨmakau ua sabaŋ sipsipɨ ua akuaba akuaba sɨhɨm sabaŋ agadɨ iavɨci hɨmɨci nudɨ haiabɨla pam hɨsɨŋ agaŋ sɨhɨm sabaŋ limu cɨkaŋ agadɨ sɨhɨm sabaŋ iaganu agasaŋ vaveci igam aba abɨha uami. Lɨci sɨhɨm sabaŋ sudɨ iŋam iavɨbali agasaŋ sɨhɨm sabaŋ iaganu saŋ hɨbɨŋ igumɨdɨ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Hulaŋ mu nudɨ haiabɨla pam hɨsɨŋ agasaŋ sabaŋ bulɨmakau valɨci sibɨla saŋ via hɨdavɨla lɨci sabaŋ bulɨmakau iaganu ma hɨnimaŋ lɨdaci hɨcɨ human sɨbɨlɨ lɨci ua havɨ hɨmɨci aba abɨha uami. Nudɨ haiabɨla pam hɨsɨŋ agaŋ sabaŋ bulɨmakau iaganu saŋ hɨbɨŋ igum aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Agadɨ ala sabaŋ bulɨmakau iaganu agaŋ nudɨ haiabɨla pam hɨsɨŋ agɨlaŋ hula hɨnidaci hɨcɨ human sɨbɨlɨ lɨci ua havɨ hɨmɨci nudɨ haiabɨla pam hɨsɨŋ agaŋ nusaŋ hɨbɨŋ igumɨdɨ aba abɨha uami. Sabaŋ bulɨmakau agadɨ sibɨla saŋ via hɨdɨben aba nudɨ haiabɨla pam hɨsɨŋ agasaŋ anɨm hɨlɨcɨ igubali sadaŋ cɨhu hɨbɨŋ igumɨdɨ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Lavɨla Asɨ cɨhu Mosesɨ dɨ abami. Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨha uami. Iamɨgali mɨnibɨlɨ hulaŋ mu hula ma hɨdɨmaŋ aba abɨha uami. Nudɨ hulaŋ mu saŋ ma lɨbɨmɨŋɨmaŋ aba abɨha uami. Nudɨ ala hulaŋ mu agaŋ nɨbu hula hɨdahɨda saŋ nudɨ sɨdaŋ ciaŋ ciaŋ iguavɨla ahica hɨdavɨbali aba abɨha uami. Lavɨla iamɨgali agadɨ iaganu saŋ anɨm hɨlɨcɨ iamɨgali mɨnibɨlɨ lavavɨlalɨ hameŋ agadɨ ala iguavɨla iamɨgali agadɨ sabim aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Agadɨ ala iamɨgali agadɨ iaganu agaŋ hulaŋ agadɨ nameŋ abɨci aba abɨha uami. Nama iadɨ nadi dɨ ma sabibanaŋ aba abɨci ha nɨbu ciaŋ apalɨ aba abɨha uami. Agadɨ ala hulaŋ agaŋ nudɨ lusɨŋ sɨbɨlɨ agadɨ lavɨben aba iamɨgali agadɨ iaganu saŋ anɨm hɨlɨcɨ iamɨgali mɨnibɨlɨ lavavɨlalɨ hameŋ agadɨ ala igum aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Hau hubɨla hubɨla hɨsɨŋ iamɨgali agɨladɨ ifɨhɨmɨhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Hulaŋ mu sɨhɨm sabaŋ mɨgenaŋ hula lusɨŋ sɨbɨlɨ vici nudɨ ifɨhɨmɨhalaŋ aba abɨha uami. Iamɨgali mu sɨhɨm sabaŋ muŋaŋ hula lusɨŋ sɨbɨlɨ vici nudɨ avi ifɨhɨmɨhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Hulaŋ iamɨgali sagalɨ iguben aba sɨhɨm sabaŋ agɨladɨ Asɨ Iaue saŋ pam hɨlavɨm aba abɨha uami. Hulaŋ mu kɨlɨ akuaba akuaba lɨhulɨhu lamalama aludɨ asɨ aba abavɨlalɨ agasaŋ sagalɨ hɨlavɨla iguci ha nudɨ ifɨhɨmɨbalu aba valɨlaŋ hɨtɨŋ hɨnim aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Vaka namɨlaŋ Isipɨ fɨli tɨbɨ uavɨla ihɨlɨŋ hɨniahalaŋ aba abɨha uami. Hameŋ sadaŋ hulaŋ ihɨlɨŋ vevɨla namɨlaŋ hula hɨniavɨdaci nulɨdɨ sɨbɨlɨ lamalama nulɨsaŋ vɨhɨlɨ igumɨlaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Namɨlaŋ iamɨgali cido cido agɨlasaŋ vɨhɨlɨ igumɨlaŋ aba abɨha uami. Ninanadi mavacɨŋ agɨlasaŋ avi vɨhɨlɨ igumɨlaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Namɨlaŋ nulɨsaŋ vɨhɨlɨ igudalaŋ mavacɨŋ mavacɨŋ cido cido agɨlaŋ Asɨ dɨ abavɨdaci nulɨdɨ ciaŋ igahɨlahɨla nulɨdɨ ahɨliahubali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Namɨlaŋ mavacɨŋ mavacɨŋ cido cido agɨlasaŋ vɨhɨlɨ igulaŋ Asɨ dɨ igɨvɨ lɨci sagaŋ hɨsɨŋ hulaŋ agɨladɨ valɨci vevɨla naludɨ ifɨhɨmavɨbali aba abɨha uami. Lɨhavɨci naludɨ iamɨgali agɨlaŋ cido cido hɨniavɨbali aba abɨha uami. Naludɨ ninanadi agɨlaŋ avi mavacɨŋ mavacɨŋ hɨniavɨbali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Namɨlaŋ anɨm hɨlɨcɨ sibɨla vivi hɨji nameŋ lamɨmɨlaŋ aba abɨha uami. Hulaŋ mu saŋ anɨm hɨlɨcɨ igulɨŋ iasaŋ hɨbɨŋ lɨvala iahua anɨm hɨlɨcɨ hekɨlɨ igubali aba abɨmɨlaŋ aba abɨha uami. Asɨ dɨ hulaŋ iamɨgali agɨlaŋ anɨm hɨlɨcɨ saŋ tɨbɨ mɨgavɨla naludɨ pɨŋ vevɨla anɨm hɨlɨcɨ vihavɨci cɨhu hɨbɨŋ lɨvala iahua vibalu aba igahɨlɨmɨlaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Hulaŋ mu nalusaŋ anɨm hɨlɨcɨ hɨbɨŋ iguben aba nudɨ hadi hɨlahɨla hafihafi ani hɨnilalɨ agadɨ iguavɨla cɨhu nɨbu nukeŋ hadi hɨlahɨla apalɨ hɨnilalɨ aba abɨha uami. Uaiaŋ heŋ laci ala nudɨ hadi hɨlahɨla hafihafi hɨnilalɨ agadɨ uaiaŋ ma mɨgumaŋ lɨdaci cɨhu ilɨmiŋ iguhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Nudɨ hadi hɨlahɨla pabiŋ sadaŋ hɨfɨlɨ vumɨli lɨci nudɨ lamavɨla cɨhu vumɨli saŋ ma hɨmɨbali aba abɨha uami. La nusaŋ ma igumaŋ lɨlaŋ nudɨ hadipɨlɨ agadɨ akɨ hɨvɨ hafilamavɨla ani hɨsɨvɨbali aba abɨha uami. Nudɨ ahɨliahuiahu saŋ Asɨ dɨ abɨci Asɨ agaŋ nudɨ ciaŋ igahɨlɨbali aba abɨha uami. Asɨ agaŋ hulaŋ iamɨgali hameŋ agɨlasaŋ mavɨn hɨnihɨni nulɨdɨ huaci lamɨlalɨ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Namɨlaŋ Asɨ dɨ sɨbɨlɨ iga iga mu ciaŋ mu ciaŋ abɨmɨlaŋ aba abɨha uami. Aludɨ manɨgali agaŋ vɨhɨlɨ igam aba Asɨ dɨ abɨmɨlaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Namɨlaŋ akuaba akuaba naludɨ hualabɨla hɨnihɨni mɨdɨ lɨhuavɨlalɨ agɨladɨ Asɨ saŋ mɨse sagalɨ igu igu saŋ ihɨlu lavɨmɨlaŋ aba abɨha uami. Halɨha cahu uitɨ hɨlɨcɨ agɨladɨ iguhalaŋ aba abɨha uami. Lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ agɨladɨ iguhalaŋ aba abɨha uami. Kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agɨladɨ iguhalaŋ aba abɨha uami. Naludɨ ninaŋ Cimegeŋ agɨladɨ avi Asɨ saŋ iguhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","La sabaŋ bulɨmakau ninaŋ sabaŋ sipsipɨ ninaŋ manɨgali agɨladɨ Asɨ saŋ sagalɨ iguhalaŋ aba abɨha uami. Sabaŋ bulɨmakau sabaŋ sipsipɨ ninaŋ manɨgali agɨlaŋ uaiaŋ human limu fɨhala human limu ahica cɨjɨŋ numɨgaŋ hula hɨdavɨdaci cɨhu uaiaŋ mu iahɨci heŋ vave Asɨ saŋ sagalɨ iguhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Namɨlaŋ Asɨ dɨ hulaŋ iamɨgali aba abɨha uami. Hameŋ sadaŋ sudɨ iŋam agɨlaŋ sɨhɨm sabaŋ saua hɨvɨ iavavɨci nulɨdɨ hɨlɨcɨ agɨladɨ nɨmɨlaŋ aba abɨha uami. Iŋam saŋ pam igulaŋ navɨm aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Lavɨla Asɨ cɨhu Mosesɨ dɨ abami. Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨha uami. Hulaŋ mu analɨ ciaŋ abɨci namɨlaŋ igahɨlavɨla ciaŋ agadɨ hulaŋ limu hɨhɨle agɨladɨ aba aba hɨdɨmɨlaŋ aba abɨha uami. Hulaŋ mu hugɨ daŋ agaŋ ciaŋ hɨvɨ hɨnidaci namɨlaŋ nudɨ ahɨliahubavɨla analɨ abavɨla amɨŋ ala aba abɨmɨlaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Hulaŋ akape agɨlaŋ lusɨŋ sɨbɨlɨ vihavɨdaci namɨlaŋ nulɨdɨ lusɨŋ sɨbɨlɨ sɨbɨlɨ agɨladɨ iga iga mɨŋasɨvɨlɨmɨlaŋ aba abɨha uami. Hulaŋ akape analɨ ciaŋ ciaŋ abavɨla hulaŋ mu dɨ ciaŋ hɨvɨ lamavɨci nulɨdɨ ahɨliahumɨlaŋ aba abɨha uami. Ahɨliahuavɨla nudɨ ciaŋ mɨŋaihuihu lɨlabɨla ciaŋ hihɨla hihɨla hɨsɨŋ hulaŋ agaŋ ciaŋ agadɨ sɨhɨvia ma hihɨlɨbali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Hulaŋ limu hɨhɨle agɨlaŋ hulaŋ akuaba akuaba saŋ tɨbɨ mɨgavɨlalɨ agɨladɨ ciaŋ hɨvɨ lamavɨci namɨlaŋ nulɨsaŋ mavɨn hɨniavɨla nulɨdɨ ahɨliahuben aba analɨ ciaŋ ciaŋ abɨmɨlaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Hulaŋ naludɨ nagɨli lamavɨlalɨ agɨladɨ sabaŋ donɨki ua sabaŋ bulɨmakau ua agaŋ lua lɨbɨpilavɨla haŋɨlɨci ha nudɨ iaganu saŋ via ua iguhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Hulaŋ nalusaŋ igɨvɨ hɨniavɨlalɨ agɨladɨ sabaŋ donɨki ua sabaŋ bulɨmakau ua vaŋ maku akuaba akuaba agɨladɨ nudɨ sabɨ hɨvɨ lamɨci hava via ua lalɨfavɨla fɨli mɨgaifa hɨnidaci aba abɨha uami. Nalusaŋ igɨvɨ hɨniavɨlalɨ agɨladɨ ahɨliahuavɨla nudɨ sabaŋ donɨki ua sabaŋ bulɨmakau agadɨ mɨŋaiahɨhalaŋ aba abɨha uami. Nudɨ valɨlaŋ fɨli hɨvɨ hameŋ hɨnimɨdɨ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Hulaŋ mu akuaba akuaba apalɨ agadɨ ciaŋ hɨvɨ lamavɨci ciaŋ hihɨla hihɨla hɨsɨŋ hulaŋ agaŋ ciaŋ agadɨ sɨhɨvia sɨbaŋ hihɨlam aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Asɨ Iaue agaŋ hulaŋ sɨbɨlɨ agɨladɨ ma valɨci huaci hɨniavɨbali aba abɨha uami. Namɨlaŋ analɨ ciaŋ ciaŋ abavɨla hulaŋ mu dɨ ciaŋ hɨvɨ lamɨmɨlaŋ aba abɨha uami. Hulaŋ huaci hugɨ apalɨ agasaŋ analɨ ciaŋ ciaŋ abavɨla nudɨ ciaŋ hɨvɨ lamavɨla ifɨhɨmɨmɨlaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Hulaŋ mu anɨm hɨlɨcɨ nalusaŋ iguavɨla hulaŋ mu agasaŋ analɨ abavɨla ciaŋ hɨvɨ lamalama saŋ abɨci aba abɨha uami. Namɨlaŋ anɨm hɨlɨcɨ agadɨ vimɨlaŋ aba abɨha uami. Lusɨŋ sɨbɨlɨ hameŋ agaŋ ciaŋ hihɨla hihɨla hɨsɨŋ hulaŋ agadɨ hɨji huaci agadɨ mɨŋaihuihu lɨbali aba abɨha uami. Lɨci hulaŋ huaci agadɨ ciaŋ sɨhɨvia ma hihɨlɨbali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Namɨlaŋ nukeŋ Isipɨ fɨli tɨbɨ uavɨla ihɨlɨŋ hɨnihɨni agadɨ ci igahalaŋ aba abɨha uami. Hameŋ sadaŋ hulaŋ ihɨlɨŋ vevɨla namɨlaŋ hula hɨniavɨdaci nulɨsaŋ vɨhɨlɨ igumɨlaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Lavɨla Asɨ cɨhu Mosesɨ dɨ abami. Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨha uami. Namɨlaŋ hualɨ sibɨla vivi sɨmɨŋ hulihuli vivi mɨgudɨbalɨba hɨnidalaŋ hualɨ human limu fɨhala human limu pabiŋ cɨjɨŋ ubali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Agadɨ ala hualɨ mu iahɨci fɨli agadɨ valɨlaŋ havɨ hɨnim aba abɨha uami. Havɨ hɨnidaci sɨmɨŋ akuaba akuaba naludɨ isɨlɨbɨ hɨvɨ hɨniavɨbali agɨladɨ vimɨlaŋ aba abɨha uami. Naludɨ lɨmɨn uain hualabɨla kɨlɨ olivɨ hualabɨla agɨladɨ avi hameŋ laci ala valɨlaŋ hɨniavɨm aba abɨha uami. Hulaŋ iamɨgali akuaba akuaba apalɨ agɨlaŋ laci sɨmɨŋ akuaba akuaba isɨlɨbɨ hɨvɨ hɨniavɨbali agɨladɨ huaci vihavɨbali aba abɨha uami. Viavɨla valavɨci sɨhɨm sabaŋ saua hɨsɨŋ agɨlaŋ vevɨla na fɨhalavɨbali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Uaiaŋ human limu fɨhala human limu pabiŋ cɨjɨŋ hɨvɨ laci sibɨla vihalaŋ aba abɨha uami. La hɨnilaŋ mɨŋalahɨci sibɨla vimɨlaŋ aba abɨha uami. Naludɨ sibɨla hɨsɨŋ hulaŋ iamɨgali sabaŋ donɨki sabaŋ bulɨmakau hulaŋ fɨli tɨbɨ mu hɨsɨŋ ve namɨlaŋ hula ihɨlɨŋ hɨniavɨlalɨ agɨladɨ valɨlaŋ havɨ hɨniavɨla cɨhu vɨdɨvɨdɨŋ vihavɨm aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Ciaŋ vɨdɨvɨdɨŋ Asɨ abi agadɨ igahɨlavɨla namɨlaŋ sɨhɨvia sɨbaŋ lubiahɨlɨhalaŋ aba abɨha uami. Namɨlaŋ kɨlɨ akuaba akuaba lɨhulɨhu lamalama aludɨ asɨ aba abavɨlalɨ agɨladɨ ibi mɨŋaiahɨmɨlaŋ aba abɨha uami. La nulɨdɨ ibi agɨladɨ avi luvɨlɨmɨlaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Lavɨla Asɨ cɨhu Mosesɨ dɨ abami. Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨha uami. Hualɨ pabiŋ pabiŋ hɨvɨ Asɨ dɨ ibi mɨŋaiahaiaha saŋ ahica pam tɨbɨ fipɨ Asɨ hɨnibali heŋ uu sɨmɨŋ hekɨlɨ hɨlanɨhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Avaŋ Abipɨ hɨvɨ namɨlaŋ Isipɨ fɨli tɨbɨ vala vehalaŋ aba abɨha uami. Hameŋ sadaŋ Asɨ agaŋ avaŋ Abipɨ agadɨ lɨbɨmɨŋavɨla nudɨ ibi mɨŋaiahaiaha sɨmɨŋ hekɨlɨ hɨlanana saŋ abi aba abɨha uami. Lɨci nudɨ ciaŋ vɨdɨvɨdɨŋ agadɨ lubiahɨlavɨla uaiaŋ human limu fɨhala human limu ahica cɨjɨŋ hɨvɨ maci sakɨvakɨva agɨladɨ nɨhalaŋ aba abɨha uami. Agadɨ ala nudɨ ibi mɨŋaiahɨben aba akuaba akuaba agɨladɨ avi sagalɨ igu igu saŋ vavehalaŋ aba abɨha uami. Havɨ vemɨlaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Naludɨ halɨha cahu uitɨ hulilalaŋ agɨlaŋ mɨdɨ lɨhuavɨci Asɨ dɨ ibi mɨŋaiahaiaha saŋ hafalavɨla sɨmɨŋ hekɨlɨ hɨlanɨhalaŋ aba abɨha uami. La halɨha cahu uitɨ hali hɨsɨŋ agɨladɨ Asɨ saŋ mɨse vave sagalɨ iguhalaŋ aba abɨha uami. Avaŋ naludɨ sɨmɨŋ akuaba akuaba mɨdɨ lɨhuavɨci mɨgudɨba fɨhalɨlalaŋ agadɨ hɨvɨ avi Asɨ dɨ ibi mɨŋaiahaiaha saŋ hafalavɨla sɨmɨŋ hekɨlɨ hɨlanɨhalaŋ aba abɨha uami. La nusaŋ sagalɨ iguhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Hualɨ pabiŋ pabiŋ hɨvɨ ahica pam tɨbɨ fipɨ aludɨ Hekɨlɨ Asɨ Iaue hɨnibali heŋ hulaŋ sɨkasɨkan namɨlaŋ uhalaŋ aba abɨha uami. Uu nudɨ ibi mɨŋaiahaiaha saŋ sɨmɨŋ hekɨlɨ hɨlanɨhalaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Asɨ saŋ sagalɨ iguben aba sɨhɨm ifɨhɨmɨlaŋ mɨdɨ mɨgɨci mɨdɨ agadɨ viavɨla maci daŋ Asɨ saŋ sagalɨ iguhalaŋ aba abɨha uami. Agadɨ ala maci huhɨla huhɨla hɨsɨŋ isɨ aba abavɨlalɨ agadɨdaŋ eŋalavɨla hɨlavɨlalɨ agɨladɨ via mɨdɨ agadɨdaŋ Asɨ saŋ sagalɨ igumɨlaŋ aba abɨha uami. Sɨhɨm sɨdaŋ agɨladɨ limu cɨkaŋ cɨki avi cimɨdaŋ nana saŋ valɨlaŋ hɨnimɨdɨ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Naludɨ hualabɨla hɨhi hɨsɨŋ sɨmɨŋ huaci huaci nɨbɨlaŋ mɨse mɨdɨ lɨhuavɨlalɨ agɨladɨ naludɨ Asɨ Iaue dɨ ulaŋ hɨvɨ vavehalaŋ aba abɨha uami. Sabaŋ meme amaŋ mɨtɨ agadɨdaŋ sabaŋ meme ninaŋ cɨki agadɨdaŋ pam lamavɨla sɨji hɨvɨ hugɨlɨmɨlaŋ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","La Asɨ Iaue agaŋ cɨhu ala abami. Ci igɨnaŋ uami. Viaŋ iadɨ ciaŋ hali hɨsɨŋ agadɨ abɨlɨŋ namɨlaŋ hula uu nalusaŋ hɨbɨ abalamalama hali ubali uami. Abalamalama via uavɨla fɨli tɨbɨ nalusaŋ mɨŋahihɨlɨlɨŋ huaci lalɨ heŋ iahubali uami. ");
INSERT INTO ena_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Viaŋ nukeŋ nɨbu hula hɨniben uami. Hameŋ sadaŋ namɨlaŋ nudɨ lɨhu hɨvɨ hɨnihɨni nudɨ ciaŋ agadɨ pam lubiahɨlɨhalaŋ uami. Nudɨ ciaŋ lulɨmɨlaŋ uami. Nudɨ ciaŋ lulɨlaŋ naludɨ hugɨ agɨladɨ ma hivɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Nudɨ ciaŋ lubiahɨlavɨla akuaba akuaba saŋ abin agɨladɨ lɨlaŋ viaŋ hulaŋ naludɨ nagɨli lamavɨlalɨ agɨladɨ nagɨli lamɨben uami. Hulaŋ naludɨ sɨbɨlɨ lamavɨlalɨ agɨladɨ nulɨdɨ avi sɨbɨlɨ lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Iadɨ ciaŋ hali hɨsɨŋ agaŋ hali udaci nɨbu hula uavɨla Amolɨ hɨdɨlɨ Hitɨ hɨdɨlɨ Pelesɨ hɨdɨlɨ Kenan hɨdɨlɨ Hivɨ hɨdɨlɨ Jebusɨ hɨdɨlɨ agɨlaŋ fɨli tɨbɨ hɨniavɨlalɨ heŋ udalaŋ viaŋ nulɨdɨ sɨkasɨkan ifɨhɨma fɨhalɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Nɨbɨlaŋ kɨlɨ akuaba akuaba lɨhulɨhu lamalama aludɨ asɨ aba abavɨlalɨ agɨlasaŋ mɨgalɨfɨlɨbavɨla nulɨdɨ ibi mɨŋaiahɨmɨlaŋ uami. Nɨbɨlaŋ lusɨŋ sɨbɨlɨ sɨbɨlɨ vihavɨlalɨ agɨladɨ lubiahɨlɨmɨlaŋ uami. Nɨbɨlaŋ kɨlɨ akuaba akuaba lɨhulɨhu lamalama aludɨ asɨ aba abavɨlalɨ agɨladɨ ifɨcɨkɨlɨdalaŋ uavɨm uami. Lɨba hutesɨ hutesɨ agɨladɨ lamalama aludɨ asɨ aba abavɨlalɨ agɨladɨ avi sɨkan ifɨcɨkɨlɨdalaŋ uavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Viaŋ naludɨ Asɨ Iaue uami. Namɨlaŋ iadɨ ibi pam mɨŋaiahɨhalaŋ uami. Namɨlaŋ hameŋ lɨlaŋ viaŋ naludɨ sɨmɨŋ avɨli akuaba akuaba agɨladɨ huaci lamavɨla naludɨ hɨmuhɨmu agɨladɨ avi mɨŋahihɨlɨdalɨŋ huaci hɨnibalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Lɨdalɨŋ iamɨgali sɨkasɨkan agɨlaŋ ninanadi huaci laci huhɨlavɨbali uami. Iamɨgali hulaŋ daŋ agɨlaŋ uajɨ ma hɨniavɨbali uami. Viaŋ lɨlɨŋ namɨlaŋ fɨli neŋ hutesɨ hɨnibalaŋ uami. Ma hɨmavɨhebalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Viaŋ hali uavɨla hulaŋ naludɨ nagɨli lamavɨlalɨ agɨladɨ lɨdalɨŋ naludɨ iga iga hekɨlɨ lɨdalɨda uavauava iahuavɨbali uami. Lavɨla naludɨ vala haŋɨla uavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Viaŋ iagui habɨn agɨladɨ abɨlɨŋ hali uavɨla Hivɨ hɨdɨlɨ Kenan hɨdɨlɨ Hitɨ hɨdɨlɨ agɨladɨ lahuavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Agadɨ ala hɨdɨlɨ hɨtɨŋ hɨtɨŋ agɨladɨ hualɨ pabiŋ hɨvɨ laci ma lahu fɨhalɨben uami. Viaŋ hameŋ lɨlɨŋ fɨli tɨbɨ agaŋ havɨ hɨnici sudɨ iŋam agɨlaŋ iaha habɨlavɨla naludɨ sɨbɨlɨ lamavɨmɨdɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Hameŋ sadaŋ viaŋ nulɨdɨ simɨsimɨ lɨdɨŋ lahudalɨŋ namɨlaŋ iaha habɨla fɨli tɨbɨ agadɨ sɨkasɨkan fɨhalɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Viaŋ naludɨ fɨli tɨbɨ agadɨ valɨ lamɨben uami. Letɨsi avɨli hekɨlɨ caba heŋ hɨdɨlɨ maha lama via uavɨla Meditelenian avɨli hekɨlɨ heŋ valɨben uami. La cɨhu Iufɨletisɨ avɨli heŋ hɨdɨlɨ maha lama vave fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ valɨben uami. La nalusaŋ vɨdɨvɨdɨŋ igulɨŋ hulaŋ iamɨgali heŋ hɨniavɨlalɨ agɨladɨ fɨli tɨbɨ ivouavɨla nulɨdɨ lɨvalavɨla lahulaŋ vala uavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Namɨlaŋ nɨbɨlaŋ hula ciaŋ mɨgumɨlaŋ uami. Nulɨdɨ kɨlɨ akuaba akuaba lɨhulɨhu lamalama aludɨ asɨ aba abavɨlalɨ agɨlaŋ hula avi ciaŋ mɨgumɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Namɨlaŋ nulɨdɨ valɨlaŋ fɨli tɨbɨ naludɨ heŋ hɨniavɨmɨdɨ uami. Valɨlaŋ hɨniavɨla kɨlɨ akuaba akuaba lɨhulɨhu lamalama aludɨ asɨ aba abavɨlalɨ agɨladɨ ibi mɨŋaiahɨben aba naludɨ avi abavɨbali uami. Lɨhavɨci namɨlaŋ nɨbɨlaŋ hula kɨlɨ akuaba akuaba lɨhulɨhu lamalama aludɨ asɨ aba abavɨlalɨ agɨladɨ ibi mɨŋaiahɨbalaŋ uami. Lusɨŋ sɨbɨlɨ hameŋ agadɨ vilaŋ Asɨ Iaue agaŋ naludɨ igɨci sɨbɨlɨ sɨbaŋ hɨnibalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Asɨ Iaue agaŋ Mosesɨ dɨ abami. Nama iaha Alon dɨdaŋ Nadapɨ dɨdaŋ viha uami. Abihu dɨdaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ hulaŋ hekɨlɨ hekɨlɨ limu hɨhɨle 70 agɨladɨdaŋ avi viha uami. La nulɨdɨ likɨla via halu lɨguŋ agadɨ valavɨla alɨhaŋ heŋ iahɨhalaŋ uami. Iaha ve ataŋ tagɨlaŋ daŋ lagulama iadɨ ibi mɨŋaiahɨben aba mɨgalɨfɨlɨbɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","La Mosesɨ nama pam hɨtɨŋ iadɨ mikɨ pɨŋ sɨbaŋ veha uami. Isɨlaelɨ hɨdɨlɨ agɨladɨ hulaŋ hekɨlɨ hekɨlɨ limu hɨhɨle agɨlaŋ iadɨ mikɨ pɨŋ vehavɨmɨdɨ uami. Hulaŋ iamɨgali avi nama hula halu neŋ iahavɨmɨdɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Hameŋ abɨci Mosesɨ agaŋ hulaŋ iamɨgali agɨlasaŋ Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agɨladɨdaŋ Asɨ dɨ ciaŋ limu hɨhɨle agɨladɨdaŋ sɨkasɨkan sulɨdaci igahɨlahɨla hɨniavɨla nameŋ abavɨmi. Asɨ Iaue aludɨ akuaba akuaba saŋ abi agɨladɨ alaŋ ahuata hameŋ laci ala lɨbalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Lɨhavɨci Mosesɨ agaŋ Asɨ Iaue dɨ ciaŋ agɨladɨ sɨkasɨkan manasɨŋ hɨvɨ lɨbami. La hɨnici mɨŋalahɨci cimɨdaŋ sɨbaŋ iahavɨla halu agadɨ alɨhaŋ heŋ sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ ibilami. Isɨlaelɨ hɨdɨlɨ hulaŋ latɨhiŋ agɨladɨ lugɨlavɨci ua human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ iahami. La nulɨsaŋ igahɨla lɨba hutesɨ hutesɨ agɨladɨ avi lugɨlavɨci ua valɨ hameŋ laci ala iahami. Lɨci likɨla vave sagalɨ hɨlahɨla hɨsɨŋ vadɨm mikɨ heŋ lalɨlamalama uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Lavɨla hulaŋ mɨnibɨlɨ agɨladɨ abɨci uavɨla Asɨ Iaue saŋ sagalɨ hɨlavɨdaci lɨhucabɨlavɨmi. La Asɨ Iaue hula hɨji humɨgaŋ pabiŋ laci hɨnihɨni saŋ igahɨlavɨla sabaŋ bulɨmakau limu hɨhɨle agɨladɨ ifɨhɨmuhɨmu nusaŋ sagalɨ iguavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Lɨhavɨdaci Mosesɨ agaŋ sabaŋ bulɨmakau mɨdɨ agɨladɨ labɨla labɨla hunaŋ hɨtɨŋ hɨtɨŋ hɨvɨ lamami. Lavɨla mɨdɨ hunaŋ hɨhɨle sibɨla mu saŋ lamami. Mɨdɨ hunaŋ hɨhɨle agɨladɨ viavɨla sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ hɨvɨ sevɨdaci umi. ");
INSERT INTO ena_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Lavɨla Asɨ Iaue agaŋ hulaŋ iamɨgali agɨlasaŋ igahɨla ciaŋ mɨguavɨla nudɨ abɨdaci manasɨŋ hɨvɨ lɨbami agadɨ cɨhu iga iga hulaŋ iamɨgali agɨladɨ sulami. Sulɨdaci hulaŋ iamɨgali agɨlaŋ igahɨlavɨla abavɨmi. Alaŋ Asɨ Iaue dɨ ciaŋ agadɨ igahɨlavɨla hameŋ laci ala lɨbalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Lɨhavɨci Mosesɨ agaŋ sabaŋ bulɨmakau mɨdɨ agadɨ vivi hulaŋ iamɨgali agɨladɨ hɨvɨ sevaseva umi. La abami. Ci igɨlaŋ uami. Asɨ Iaue ciaŋ nagɨladɨ sɨkasɨkan abalɨ uami. Nɨbu ciaŋ mɨguavɨla naludɨ abalɨ agaŋ vɨdɨvɨdɨŋ sɨbaŋ hɨnibali uami. Hɨnidaci namɨlaŋ lubiahɨlɨbalaŋ uami. Nusaŋ ala mɨdɨ nagadɨ naludɨ sabɨ hɨvɨ sevadin uami. Hameŋ lɨlɨŋ ciaŋ agaŋ vɨdɨvɨdɨŋ sɨbaŋ hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","La Mosesɨ hula Alon hula Nadapɨ dɨdaŋ Abihu dɨdaŋ viavɨla uavɨmi. Isɨlaelɨ hɨdɨlɨ agɨladɨ hulaŋ hekɨlɨ hekɨlɨ limu hɨhɨle 70 agɨlaŋ avi nɨbɨlaŋ hula uavɨla halu iahuavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Iahuavɨla igavɨci lɨba valɨ valɨ me agɨlaŋ Asɨ Iaue dɨ hɨcɨ lɨhu hɨvɨ heŋ hɨniavɨmi. Lɨba valɨ valɨ me agɨlaŋ nɨbɨlaŋ uaiaŋ susu agaŋ avɨli susu apalɨ hɨniadami me hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Hɨniavɨdaci anisɨhu me hɨvɨ Asɨ Iaue dɨ igavɨmi. Agadɨ ala nulɨdɨ ma sɨbɨlɨ lamami. Lɨci heŋ hɨniavɨla sɨmɨŋ navɨmi. ");
INSERT INTO ena_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Lɨhavɨci Asɨ Iaue agaŋ Mosesɨ dɨ abami. Nama halu huva neŋ iaha iasaŋ migɨlɨha uami. Lɨnaŋ ciaŋ lamalubicin agɨladɨdaŋ ciaŋ vɨdɨvɨdɨŋ hɨhɨle agɨladɨdaŋ lɨba cɨkaŋ ahica hɨvɨ ihatɨbutɨbu lɨbin agɨladɨ nasaŋ igulɨŋ via mɨguha uami. Via mɨgua ciaŋ nagɨladɨ hulaŋ iamɨgali agɨladɨ aba aba lamalubiha uami. ");
INSERT INTO ena_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","14","Lɨci Mosesɨ agaŋ nudɨ sibɨla hɨsɨŋ hulaŋ Josua hula uben aba lɨhavɨmi. La Isɨlaelɨ hɨdɨlɨ agɨladɨ hulaŋ hekɨlɨ hekɨlɨ agɨladɨ abami. Namɨlaŋ uavɨla alusaŋ uu veve hɨnihɨni fipɨ heŋ migɨla migɨla hɨnihalaŋ uami. Alon hula Holɨ hula avi namɨlaŋ hula hɨniavɨbali uami. Aniaba hulaŋ mu agaŋ hulaŋ mu hula ciaŋ vɨhɨlɨ daŋ hɨniavɨla uami. Ha hulaŋ ahica agɨladɨ pɨŋ uavɨci nɨbɨlaŋ nukeŋ hihɨlavɨbali uami. La nulɨdɨ vala uavɨla Asɨ dɨ halu iahuavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Iahua halu huva agadɨ mikɨ heŋ hɨniavɨmi. Hɨniavɨdaci avɨli susu hekɨlɨ agaŋ ve mɨga halu huva agadɨ lalɨgumi. ");
INSERT INTO ena_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Lɨci Asɨ Iaue dɨ abɨlu hekɨlɨ vɨdɨvɨdɨŋ daŋ agaŋ halu heŋ mɨgami. Lɨci Isɨlaelɨ hɨdɨlɨ hulaŋ iamɨgali agɨlaŋ igavɨdaci iahua halu huva heŋ avɨŋ hekɨlɨ me lɨhulɨhu hɨnimi. Hɨnidaci avɨli susu agaŋ halu agadɨ lalɨgua hɨnidaci uaiaŋ human limu fɨhala umi. Lɨci uaiaŋ mu hɨvɨ Asɨ Iaue agaŋ avɨli susu alɨhaŋ alɨhaŋ hɨvɨ hɨnihɨni Mosesɨ dɨ ulami. ");
INSERT INTO ena_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ulɨci uavɨla avɨli susu lɨkɨla lɨkɨla alɨhaŋ hɨvɨ ivoua halu huva heŋ iahumi. Iahua halu huva heŋ hɨnidaci uaiaŋ 38 umi. ");
INSERT INTO ena_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Halu heŋ ala hɨnidaci Asɨ Iaue agaŋ Mosesɨ dɨ abami. ");
INSERT INTO ena_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨnaŋ akuaba akuaba agɨladɨ via iasaŋ sagalɨ iguavɨm uami. Hulaŋ iamɨgali human putɨ putɨ agɨlaŋ akuaba akuaba iadɨ havɨlɨ ulaŋ vivi saŋ iguavɨdaci viha uami. ");
INSERT INTO ena_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Akuaba akuaba nameŋ agɨladɨ vavevave iguavɨdaci vibanaŋ uami. Lɨba golɨ lɨba silɨva lɨba bɨlasɨ agɨladɨ viha uami. ");
INSERT INTO ena_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Sabaŋ sipsipɨ mɨnɨ ihalahalaha vivi maŋa cɨbɨŋ hɨvɨ mɨŋepɨhalavalɨ agɨladɨ viha uami. Maŋa mɨdɨ cɨbɨŋ agadɨ hɨvɨ mɨŋepɨhalavalɨ agɨladɨ viha uami. Maŋa mɨdɨ sɨbaŋ hɨvɨ mɨŋepɨhalavalɨ agɨladɨ avi viha uami. Niagɨlɨŋ mila huaci huaci sɨbaŋ agɨladɨ viha uami. Sabaŋ meme mɨnɨ agɨladɨ viha uami. ");
INSERT INTO ena_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","Sabaŋ sipsipɨ muŋaŋ agɨladɨ sɨgɨtɨ maŋa mɨdɨ hɨvɨ mɨŋepɨhalavalɨ agɨladɨ viha uami. Avɨli hekɨlɨ hɨsɨŋ hehɨlaŋ mu hɨdɨlɨ agɨladɨ sɨgɨtɨ huaci huaci agɨladɨ viha uami. Kɨlɨ akasɨ tɨbɨ tɨbɨ mibɨŋ hegulaŋ me agɨladɨ viha uami. ");
INSERT INTO ena_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ unɨ hɨvɨ lama lubilamalama hɨsɨŋ agadɨ viha uami. Cihu savu me mu hɨdɨlɨ mu hɨdɨlɨ hɨlavɨdaci hɨsi huaci huaci iahaiaha hɨsɨŋ agɨladɨ viha uami. Cihu savu me hɨhɨle kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavɨla akuaba akuaba iasaŋ lɨbɨmɨŋɨben aba nulɨdɨ sabɨ hɨvɨ mɨŋamɨjimɨji hɨsɨŋ agɨladɨ viha uami. Cihu savu me hɨhɨle hɨlavɨdaci hɨsi huaci huaci iahaiaha hɨsɨŋ agɨladɨ viha uami. ");
INSERT INTO ena_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Lɨba konilian ahica agɨladɨ viha uami. Lɨba konilian ahica ha iasaŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ agaŋ havɨlɨ cɨliŋ daŋ agadɨ nudɨ macɨŋ hɨvɨ lamɨbali agadɨ sabɨ lamalama saŋ viha uami. Lɨba hɨlɨcɨ hɨhɨle avi viha uami. Lɨba hɨlɨcɨ hɨhɨle ha havɨlɨ tɨbɨ mu sugɨ vaŋ me hɨnibali agadɨ uvɨ hɨtɨŋ hɨtɨŋ heŋ lamalama saŋ viha uami. ");
INSERT INTO ena_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Lavɨla hulaŋ iamɨgali agɨladɨ abɨnaŋ iasaŋ havɨlɨ ulaŋ vihavɨm uami. Lɨhavɨci viaŋ nɨbɨlaŋ hula hɨniben uami. ");
INSERT INTO ena_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Havɨlɨ ulaŋ agadɨ abalamɨlɨŋ igɨbanaŋ uami. Nudɨ akuaba akuaba haiabɨla hɨsɨŋ agɨladɨdaŋ uleŋ muji hɨsɨŋ agɨladɨdaŋ avi abalamɨlɨŋ igɨbanaŋ uami. Lavɨla akuaba akuaba igɨbanaŋ hameŋ sɨbaŋ ala vihalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","La Asɨ Iaue agaŋ cɨhu ala abami. Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨnaŋ kɨlɨ akasɨ cɨkaŋ cɨkaŋ mibɨŋ hegulaŋ me agɨladɨ hɨvɨ hɨbɨn hɨbɨn sibɨla vihavɨm uami. Nudɨ hutesɨ agadɨ 110 senɨtamita hameŋ vihavɨm uami. Nudɨ abɨŋ agadɨ 66 senɨtamita hameŋ vihavɨm uami. Nudɨ tulɨ agadɨ avi 66 senɨtamita hameŋ ala vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","La lɨba golɨ huaci sɨbaŋ agadɨ hɨvɨ kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ tulɨ agadɨdaŋ nudɨ sabɨ agadɨdaŋ lamalama ifuhafiavɨm uami. Nudɨ caba caba agɨladɨ avi sɨkasɨkan lamalama ifuhafiavɨm uami. La lɨba golɨ cɨliŋ cɨki mu hutesɨ agadɨ viavɨla kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ lamɨgaŋ hafilamalama uvɨ agadɨ mɨkamɨka heŋ haŋala haŋala ifuhafiavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ lamavɨci lagulama hɨnihɨni saŋ nudɨ lɨhu ikuŋ limu limu heŋ hɨcɨ tɨbɨ cɨki cɨki me agɨladɨ lamavɨm uami. Lavɨla kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ havahava saŋ lɨba golɨ agadɨ viavɨla avɨŋ hɨvɨ hɨlavɨm uami. Hɨlavɨci miŋɨlavɨla avɨli avɨli lɨci fɨli haca limu ahica limu ahica agɨladɨ hɨvɨ mɨŋamɨjiavɨci mɨguavɨla hakɨ daŋ hɨniavɨm uami. Lɨhavɨci lɨba golɨ hakɨ ahica agɨladɨ viavɨla kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ caba limu heŋ lamavɨm uami. Caba limu heŋ avi ahica ala lamavɨm uami. Nudɨ hɨcɨ tɨbɨ cɨki cɨki me agɨladɨ mikɨ heŋ ala lɨba golɨ hakɨ agɨladɨ lamavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","La kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ havahava saŋ kɨlɨ akasɨ sɨlɨvɨ ahica mibɨŋ hegulaŋ me agɨladɨ lɨhuavɨm uami. Lavɨla lɨba golɨ agadɨ hɨvɨ ifuhafihafi uavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","La kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ havahava saŋ kɨlɨ akasɨ sɨlɨvɨ ahica mibɨŋ hegulaŋ me agɨladɨ viavɨla kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ lɨba golɨ hakɨ heŋ limu caba limu caba hɨvɨ lamavɨci ivouavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Lamavɨci ivouavɨci cɨhu mɨŋahubɨlavɨmɨdɨ uami. Vana hameŋ laci hɨniavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Hɨniavɨdaci lɨba cɨkaŋ ahica ciaŋ vɨdɨvɨdɨŋ daŋ nasaŋ iguben agɨladɨ kɨlɨ cɨkaŋ hɨbɨn hɨbɨn muji heŋ lamɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","La lɨba golɨ huaci sɨbaŋ hɨvɨ kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ lamɨgaŋ vihavɨm uami. Kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ lamɨgaŋ sabɨ heŋ ala hugɨ hivahiva saŋ mɨdɨ agadɨ sevavɨbali uami. Nudɨ hutesɨ 110 senɨtamita hameŋ vihavɨm uami. Nudɨ abɨŋ 66 senɨtamita hameŋ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Vivi lɨba golɨ agadɨ ifɨvɨnapɨna lɨdɨŋ via ua fɨdɨm limu limu agɨladɨ hɨvɨ iadɨ ciaŋ hali hɨsɨŋ vɨdɨvɨdɨŋ daŋ me ahica agɨladɨ lamavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Lamavɨci mu agaŋ limu caba lagulama hɨnibali uami. Mu agaŋ limu caba lagulama hɨnibali uami. Iadɨ ciaŋ hali hɨsɨŋ vɨdɨvɨdɨŋ daŋ me ahica agɨladɨdaŋ kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ lamɨgaŋ agadɨdaŋ pam me laci vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Iadɨ ciaŋ hali hɨsɨŋ vɨdɨvɨdɨŋ daŋ me ahica agɨlaŋ mavɨn hɨbɨŋ hɨbɨŋ lamavɨla kɨlɨ cɨkaŋ hɨbɨn hɨbɨn lamɨgaŋ agadɨ igasulasula hɨniavɨm uami. Nulɨdɨ abɨŋ agɨladɨ mɨŋaiahavɨci kɨlɨ cɨkaŋ hɨbɨn hɨbɨn lamɨgaŋ agadɨ lalɨguavɨla hɨniavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Lɨhavɨci viaŋ nasaŋ lɨba cɨkaŋ ahica ciaŋ vɨdɨvɨdɨŋ daŋ agɨladɨ igulɨŋ kɨlɨ cɨkaŋ hɨbɨn hɨbɨn tulɨ muji heŋ lamavɨla hafilɨbɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Lɨnaŋ viaŋ vevɨla nudɨ sabɨ iadɨ ciaŋ hali hɨsɨŋ vɨdɨvɨdɨŋ daŋ me ahica agɨladɨ alɨhaŋ heŋ hɨniben uami. Hɨnihɨni iadɨ ciaŋ vɨdɨvɨdɨŋ agadɨ nadɨ abɨdalɨŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","La Asɨ Iaue agaŋ abami. Vadɨm mu kɨlɨ akasɨ mibɨŋ hegulaŋ me agɨladɨ hɨvɨ ibilavɨm uami. Nudɨ hutesɨ agadɨ 88 senɨtamita hameŋ lamavɨm uami. Nudɨ abɨŋ agadɨ 44 senɨtamita hameŋ lamavɨm uami. Vadɨm agadɨ iahua hɨvɨ hɨnia fɨli mɨgamɨga agadɨ 66 senɨtamita hameŋ lamavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","La lɨba golɨ huaci sɨbaŋ agadɨ hɨvɨ lamalama sɨkasɨkan ifuhafiavɨm uami. Lavɨla lɨba golɨ cɨliŋ cɨki mu viavɨla vadɨm agadɨ mɨkamɨka heŋ haŋala haŋala ifuhafiavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Lɨba golɨ mu agadɨ ifavɨci abɨŋ nudɨ 8 senɨtamita hɨnim uami. Lɨci vadɨm agaŋ vɨdɨvɨdɨŋ hɨnihɨni saŋ vadɨm agadɨ hɨlɨ mɨgua fɨli mikɨ heŋ sɨkasɨkan haŋala haŋala ifuhafiavɨm uami. Lavɨla lɨba golɨ cɨliŋ agadɨ avi lɨba golɨ mu ifɨvɨnapɨna lɨhavɨbali agadɨ sabɨ hɨvɨ haŋala haŋala ifuhafiavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","La vadɨm agadɨ havahava saŋ lɨba golɨ hakɨ vihavɨm uami. Viavɨla vadɨm agadɨ hɨlɨ lalɨlamalama hɨsɨŋ limu ahica limu ahica agɨladɨ hɨvɨ hɨtɨŋ hɨtɨŋ lamalama ifuhafiavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Lɨba golɨ cɨliŋ cɨki vadɨm hɨlɨ agɨladɨ haŋala haŋala lamalama ifuhafiavɨbali heŋ ala lɨba golɨ hakɨ agɨladɨ avi ifuhafiavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","La vadɨm agadɨ havahava saŋ kɨlɨ akasɨ sɨlɨvɨ ahica mibɨŋ hegulaŋ me agɨladɨ lɨhuavɨm uami. Lavɨla lɨba golɨ hɨvɨ ifuhafihafi uavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","La lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ mɨŋamɨjimɨji sagalɨ igu igu saŋ sɨbɨ hɨlɨcɨ agɨladɨdaŋ hɨcɨhaŋ agɨladɨdaŋ vihavɨm uami. Hunaŋ mɨsɨn agɨladɨdaŋ hunaŋ sudɨme cɨki cɨki agɨladɨdaŋ vihavɨm uami. Akuaba akuaba agɨladɨ lɨba golɨ huaci sɨbaŋ hɨvɨ laci vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Lɨhavɨci viaŋ igasulɨdalɨŋ mufɨli mufɨli hameŋ laci ala maci sakɨvakɨva agɨladɨ vivi vadɨm agadɨ sabɨ heŋ lamavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","La Asɨ Iaue agaŋ cɨhu ala abami. Lɨba golɨ huaci sɨbaŋ agadɨ viavɨla ifɨvɨnapɨna lɨdɨŋ unɨ lamalama hɨsɨŋ hɨlɨ agadɨ vihavɨm uami. Lavɨla unɨ lamalama hɨsɨŋ hɨlɨ agadɨ lalɨlamalama saŋ hɨdɨlɨ nudɨ agadɨ abɨŋ daŋ vihavɨm uami. La makaŋ hɨtɨŋ hɨtɨŋ unɨ lamalama uvɨ daŋ agɨladɨ avi vihavɨm uami. Lavɨla lɨba golɨ huaci sɨbaŋ agadɨ laci ala ifɨvɨnapɨna lɨdɨŋ kɨlɨ fu hajɨŋ daŋ hɨnilalɨ hameŋ agɨladɨ vihavɨm uami. Akuaba akuaba agɨladɨ vihavɨci pabiŋ me laci hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Unɨ lamalama hɨsɨŋ hɨlɨ agaŋ makaŋ human limu fɨhala human limu pabiŋ cɨjɨŋ daŋ hɨnim uami. Limu caba ahica pam makaŋ hɨniavɨm uami. Limu caba avi ahica pam makaŋ ala hɨniavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Kɨlɨ amon agadɨ fu hajɨŋ me agɨlaŋ makaŋ hɨtɨŋ hɨtɨŋ hɨvɨ ahica pam lɨdɨŋ hɨniavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Unɨ lamalama hɨsɨŋ hɨlɨ agadɨ pɨlɨ hɨvɨ kɨlɨ amon agadɨ fu hajɨŋ me limu ahica limu ahica agɨladɨ vihavɨci hɨtɨŋ hɨtɨŋ hɨniavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Makaŋ ahica limu limu hɨniavɨbali agɨladɨ hɨdɨlɨ heŋ kɨlɨ fu hajɨŋ me agɨladɨ lɨhu hɨvɨ asɨŋ cɨki cɨki me agɨladɨ vihavɨm uami. Makaŋ ahica limu limu agɨladɨ hɨdɨlɨ heŋ hɨniavɨbali agɨladɨ hameŋ laci ala vihavɨm uami. La makaŋ ahica limu limu agɨladɨ hɨdɨlɨ heŋ hɨniavɨbali agɨladɨ avi hameŋ laci ala vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Lɨba golɨ huaci sɨbaŋ agadɨ ifɨvɨnapɨna lɨdɨŋ akuaba akuaba agɨladɨ vihavɨci pabiŋ me laci hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Lɨci lɨba golɨ huaci sɨbaŋ hɨvɨ unɨ human limu fɨhala human limu ahica cɨjɨŋ agɨladɨ vihavɨm uami. Lavɨla unɨ lamalama hɨsɨŋ hɨlɨ agadɨ makaŋ hɨtɨŋ hɨtɨŋ agɨladɨ sabɨ hɨvɨ lamavɨm uami. La amɨŋ pɨlɨ agadɨ hɨvɨhɨvɨ heŋ avi lamavɨm uami. Lamavɨla unɨ agɨladɨ mɨŋacimɨlavɨci nulɨdɨ abɨlu agɨlaŋ uleŋ muji heŋ abɨlu havalavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Lɨba golɨ huaci sɨbaŋ agadɨ viavɨla husɨmiŋ unɨ fu mɨŋamɨŋa hɨsɨŋ agadɨdaŋ hunaŋ hɨhɨle agɨladɨdaŋ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Lɨba golɨ huaci sɨbaŋ agadɨ viavɨla unɨ lamalama hɨsɨŋ hɨlɨ agadɨdaŋ nudɨ akuaba akuaba agɨladɨdaŋ vihavɨbali agɨladɨ vɨhɨlɨ 35 kilogɨlam uami. ");
INSERT INTO ena_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Viaŋ akuaba akuaba halu neŋ nadɨ abalamɨdalɨŋ igɨnaŋ agɨladɨ nulɨdɨ sɨhɨvia sɨbaŋ abɨdanaŋ nadɨ ciaŋ agadɨ lubiahɨlahɨla vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","La Asɨ Iaue agaŋ cɨhu abami. Havɨlɨ ulaŋ vivi saŋ havɨlɨ mila huaci huaci sɨbaŋ human limu limu fɨhala agɨladɨ vihavɨm uami. Viavɨla niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavalɨ agɨladɨ vivi hɨcavɨdaci hajɨŋ daŋ hɨniavɨm uami. Niagɨlɨŋ sihɨ sihɨ hɨcavɨbali agɨlaŋ iadɨ ciaŋ hali hɨsɨŋ vɨdɨvɨdɨŋ daŋ agɨladɨ mugaŋ lamɨgaŋ me hadipɨlɨ me hɨniavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Havɨlɨ human limu limu fɨhala agɨladɨ vihavɨci hɨlihɨli laci hɨniavɨm uami. Nulɨdɨ hutesɨ 12 mita laci hɨniavɨm uami. Nulɨdɨ abɨŋ 2 mita laci hɨniavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Lɨhavɨci havɨlɨ human limu fɨhala agɨladɨ abɨŋ hɨvɨ lamalama hɨcavɨci ua havɨlɨ abɨŋ hekɨlɨ me laci hɨnibali uami. Havɨlɨ human limu fɨhala limu hɨhɨle agɨladɨ avi hameŋ laci ala nulɨdɨ abɨŋ hɨvɨ lamalama hɨcavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Lavɨla havɨlɨ hekɨlɨ hekɨlɨ ahica agɨladɨ mɨŋave pam lamalama saŋ niagɨlɨŋ cɨbɨŋ agɨladɨ hɨvɨ mɨdu hɨhɨle hɨcavɨm uami. Havɨlɨ hekɨlɨ hekɨlɨ ahica agɨladɨ abɨŋ iahua ulaŋ sabɨ hɨvɨ alɨhaŋ alɨhaŋ heŋ hɨnihɨni saŋ mɨdu agɨladɨ hɨcahɨca uavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Havɨlɨ mu limu caba hɨsɨŋ agadɨ abɨŋ iahua ulaŋ sabɨ hɨvɨ alɨhaŋ alɨhaŋ heŋ hɨnihɨni saŋ mɨdu 50 agɨladɨ hɨcahɨca uavɨm uami. Havɨlɨ mu limu caba hɨsɨŋ agadɨ abɨŋ iahua ulaŋ alɨhaŋ alɨhaŋ heŋ hɨnihɨni saŋ avi mɨdu 50 ala hɨcahɨca uavɨm uami. Havɨlɨ limu caba hɨsɨŋ agadɨ mɨdu agɨladɨ iga iga hɨlihɨli hameŋ laci hɨcahɨca uavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Havɨlɨ hekɨlɨ hekɨlɨ ahica agɨladɨ lamalama agɨlimɨgumɨgu saŋ lɨba golɨ hɨvɨ agɨlɨŋ 50 agɨladɨ vihavɨm uami. Havɨlɨ hekɨlɨ hekɨlɨ ahica agɨladɨ mɨŋave agɨlimɨgumɨgu uavɨci havɨlɨ ulaŋ hekɨlɨ me laci hɨnihɨni saŋ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","La cɨhu havɨlɨ human limu limu fɨhala hɨcɨ limu pabiŋ cɨjɨŋ sabaŋ meme mɨnɨ hɨvɨ vihavɨm uami. Havɨlɨ ulaŋ agadɨ lalɨgu lalɨgu saŋ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Havɨlɨ sɨkasɨkan agɨladɨ vihavɨci hɨlihɨli laci hɨniavɨm uami. Nulɨdɨ hutesɨ 13 mita laci hɨniavɨm uami. Nulɨdɨ abɨŋ 2 mita laci hɨniavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Lɨhavɨci havɨlɨ human limu fɨhala agɨladɨ abɨŋ hɨvɨ lamalama hɨcavɨci ua havɨlɨ abɨŋ hekɨlɨ me laci hɨnim uami. Lɨci cɨhu havɨlɨ hɨhɨle human limu fɨhala human limu pabiŋ cɨjɨŋ agɨladɨ abɨŋ hɨvɨ lamalama hɨcavɨci ua havɨlɨ abɨŋ hekɨlɨ me laci hɨnim uami. Lɨci havɨlɨ sijaŋ lama hɨcavɨbali agadɨ mɨŋafɨhulavɨci havɨlɨ ulaŋ agadɨ hali hɨbɨ sɨkasɨkan lalɨgubali uami. ");
INSERT INTO ena_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Lɨci havɨlɨ hekɨlɨ mu agadɨ abɨŋ iahua ulaŋ sabɨ hɨvɨ alɨhaŋ alɨhaŋ heŋ hɨnihɨni saŋ mɨdu 50 agɨladɨ hɨcahɨca uavɨm uami. La havɨlɨ hekɨlɨ mu agadɨ hɨvɨ avi mɨdu hɨhɨle agɨladɨ iga iga hɨlihɨli laci mɨdu 50 agɨladɨ hɨcahɨca uavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Lɨba bɨlasɨ hɨvɨ agɨlɨŋ 50 vihavɨm uami. Havɨlɨ hekɨlɨ hekɨlɨ ahica agɨladɨ lamalama agɨlimɨgumɨgu uavɨci havɨlɨ ulaŋ hekɨlɨ hɨnihɨni saŋ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Havɨlɨ hekɨlɨ agadɨ fɨdɨm havɨ hɨnibali agadɨ valavɨci iadɨ havɨlɨ ulaŋ agadɨ safɨli heŋ fɨli daŋ lalɨgua hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Havɨlɨ sabɨ hɨsɨŋ agaŋ havɨlɨ muji hɨsɨŋ agadɨ lɨvalɨbali uami. Lɨvala mɨgua 50 senɨtamita hɨvɨ hɨnibali uami. La havɨlɨ ulaŋ agadɨ limu limu sɨkasɨkan fɨli daŋ hafilamɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Sabaŋ sipsipɨ muŋaŋ sɨgɨtɨ maŋa mɨdɨ hɨvɨ mɨŋepɨhalavalɨ agɨladɨ viavɨla havɨlɨ ulaŋ sabɨ lalɨgu lalɨgu saŋ lamalama hɨcavɨm uami. Avɨli hekɨlɨ hɨsɨŋ hehɨlaŋ mu hɨdɨlɨ agɨladɨ sɨgɨtɨ viavɨla lamalama hɨcavɨm uami. Havɨlɨ ulaŋ sabɨ sɨbaŋ heŋ lalɨgu lalɨgu saŋ hɨcavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Havɨlɨ ulaŋ vivi saŋ hɨda kɨlɨ akasɨ mibɨŋ hegulaŋ me agɨladɨ sɨhuvavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Hɨda sɨkasɨkan agɨladɨ hutesɨ 4 mita laci vihavɨm uami. Kɨlɨ tɨbɨ tɨbɨ 66 senɨtamita agɨladɨ avi mɨgɨla mɨgɨla hɨda agɨladɨ lɨbukuvakuva saŋ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","19","Lɨba silɨva kum agɨladɨ haca hɨvɨ lalɨlamalama saŋ hɨda agɨladɨ hɨdɨlɨ lɨhua vɨlɨbɨlɨŋ lɨdɨŋ lamavɨm uami. Hɨda sɨkasɨkan agɨladɨ hameŋ laci lɨhavɨm uami. Ium kɨlikɨli heŋ lalɨlamalama saŋ hɨda ahica lɨbukuvavɨbali agɨladɨ lugɨlavɨci ua 20 hɨniavɨbali uami. Lɨhavɨci hɨda ahica lɨdɨŋ lɨbukuvavɨbali agɨladɨ lalɨlamalama saŋ lɨba silɨva agɨladɨ vivi kum kum 40 agɨladɨ lamavɨm uami. Lavɨla lɨba silɨva kum agɨladɨ hɨvɨ haca lamavɨm uami. La hɨda ahica lɨdɨŋ lɨbukuvavɨbali agɨladɨ lalɨlamalama saŋ lɨba silɨva kum haca daŋ haca daŋ agɨladɨ ahica lɨdɨŋ ahica lɨdɨŋ lamavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Lavɨla limu caba lakulamaŋ kɨlikɨli agadɨ avi hameŋ laci ala lɨhavɨm uami. Hɨda ahica lɨdɨŋ lɨbukuvavɨbali agɨladɨ lugɨlavɨci ua 20 hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Lɨhavɨci hɨda ahica lɨdɨŋ lɨbukuvavɨbali agɨladɨ lalɨlamalama saŋ lɨba silɨva agɨladɨ vivi kum kum 40 agɨladɨ lamavɨm uami. Lavɨla lɨba silɨva kum agɨladɨ hɨvɨ haca lamavɨm uami. La hɨda ahica lɨdɨŋ lɨbukuvavɨbali agɨladɨ lalɨlamalama saŋ lɨba silɨva kum haca daŋ haca daŋ agɨladɨ ahica lɨdɨŋ ahica lɨdɨŋ lamavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Lavɨla havɨlɨ ulaŋ safɨli uaiaŋ mɨgumɨgu kɨlikɨli agadɨ avi hɨda ahica lɨdɨŋ lɨbukuvavɨbali agɨladɨ lugɨlavɨci ua human limu fɨhala human limu pabiŋ cɨjɨŋ hɨniavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Lavɨla hɨda ahica lɨdɨŋ ahica lɨdɨŋ lɨbukuvavɨbali agɨladɨ vivi ulaŋ safɨli ikuŋ limu limu agɨlasaŋ lamavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Lamavɨci hɨda agɨladɨ fɨdɨm mikɨ heŋ lɨba golɨ hakɨ agɨladɨ lamavɨdaci mɨguavɨdaci iahua hɨvɨ agɨlaŋ pam laci hɨniavɨm uami. Mɨga hɨdɨlɨ agɨlaŋ hɨtɨŋ hɨtɨŋ hɨniavɨm uami. Ikuŋ limu agasaŋ avi hameŋ laci ala vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Hameŋ lɨhavɨci ulaŋ safɨli agadɨ hɨda ahica lɨdɨŋ lɨbukuvavɨbali agɨlaŋ human limu fɨhala human limu ahica pam cɨjɨŋ hɨniavɨm uami. Lɨci lɨba silɨva kum haca daŋ haca daŋ human limu limu fɨhala hɨcɨ limu fɨhala hɨcɨ limu pabiŋ cɨjɨŋ agɨladɨ vihavɨm uami. La hɨda ahica lɨdɨŋ lɨbukuvavɨbali agɨladɨ lalɨlamalama saŋ lɨba silɨva kum haca daŋ haca daŋ agɨladɨ ahica lɨdɨŋ lamavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","27","Lavɨla kɨlɨ akasɨ mibɨŋ hegulaŋ me agɨladɨ sɨlɨvɨŋ valɨ hutesɨ hutesɨ vihavɨm uami. Kɨlɨ sɨlɨvɨŋ valɨ human limu fɨhala agɨladɨ limu madɨŋ hɨvɨ hɨgɨlavɨci hɨgɨlavɨci uu saŋ vihavɨm uami. Kɨlɨ sɨlɨvɨŋ valɨ human limu fɨhala hɨhɨle agɨladɨ limu madɨŋ hɨvɨ hɨgɨlavɨci hɨgɨlavɨci uu saŋ vihavɨm uami. Kɨlɨ sɨlɨvɨŋ valɨ human limu fɨhala limu hɨhɨle agɨladɨ ulaŋ safɨli uaiaŋ mɨgumɨgu kɨlikɨli heŋ hɨgɨlavɨci hɨgɨlavɨci uu saŋ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ulaŋ agadɨ madɨŋ limu limu hɨvɨ hɨgɨlavɨci hɨgɨlavɨci uu vɨdɨvɨdɨŋ igu igu saŋ kɨlɨ sɨlɨvɨŋ valɨ alɨhaŋ lamalama hɨsɨŋ agɨladɨ vivi ulaŋ agadɨdaŋ lama hɨlihalahala ihalahavɨm uami. Ulaŋ safɨli uaiaŋ mɨgumɨgu kɨlikɨli agasaŋ avi hameŋ laci ala lɨhavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Hɨda ahica lɨdɨŋ lɨbukuvavɨbali agɨladɨ lɨba golɨ hɨvɨ ifuhafihafi uavɨm uami. Lavɨla kɨlɨ sɨlɨvɨŋ valɨ hutesɨ hutesɨ agɨladɨ hɨgɨlavɨci hɨgɨlavɨci uu saŋ lɨba golɨ hakɨ lamavɨm uami. Kɨlɨ sɨlɨvɨŋ valɨ hutesɨ hutesɨ agɨladɨ avi lɨba golɨ hɨvɨ ifuhafihafi uavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Viaŋ halu neŋ nasaŋ akuaba akuaba ci abalamin uami. Lɨlɨŋ havɨlɨ ulaŋ agadɨ akuaba akuaba igɨnaŋ hameŋ sɨbaŋ ala abɨdanaŋ hafiavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Havɨlɨ mila huaci sɨbaŋ agadɨ viavɨla niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavalɨ agɨladɨ vivi hɨcavɨci hajɨŋ daŋ hɨnim uami. Niagɨlɨŋ sihɨ sihɨ hɨcavɨbali agɨlaŋ iadɨ ciaŋ hali hɨsɨŋ vɨdɨvɨdɨŋ daŋ agɨladɨ mugaŋ lamɨgaŋ me hadipɨlɨ me hɨniavɨm uami. Havɨlɨ agadɨ lɨbalavɨci kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ hɨsihala hɨnihɨni saŋ hɨcavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Hɨda limu ahica limu ahica kɨlɨ akasɨ mibɨŋ hegulaŋ me agɨladɨ vihavɨm uami. Viavɨla lɨba golɨ hɨvɨ ifuhafihafi uavɨm uami. Lavɨla havɨlɨ agadɨ agɨlimɨgumɨgu saŋ lɨba golɨ hɨvɨ agɨlɨŋ viavɨla hɨda agɨladɨ hɨvɨ lamalama lɨbɨhahavɨm uami. Hɨda agɨladɨ lalɨlamalama saŋ lɨba silɨva kum haca daŋ haca daŋ limu ahica limu ahica agɨladɨ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Havɨlɨ iahua sabɨ agɨlimɨgumɨgu uavɨbali agɨladɨ lɨhu heŋ hɨda limu ahica limu ahica lalɨlamavɨm uami. Lalɨlamavɨci havɨlɨ agadɨ lamalama hɨda hɨvɨ agɨlimɨgumɨgu uavɨci havɨlɨ agaŋ uleŋ muji sɨbaŋ agadɨ hɨsihalɨci uvɨ hɨtɨŋ hɨtɨŋ hɨniavɨbali uami. Uvɨ mu uaiaŋ pabiŋ pabiŋ sagalɨ igu igu hɨsɨŋ uami. Uvɨ mu muji sɨbaŋ heŋ iasaŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ agaŋ hualɨ pabiŋ hɨvɨ pabiŋ tɨbɨ sɨbaŋ ivo ivo hɨsɨŋ uami. Lɨci kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ viavɨla havɨlɨ agɨlimɨgumɨgu uavɨbali agadɨ lɨvala ivo uleŋ muji sɨbaŋ heŋ lamavɨm uami. Ciaŋ vɨdɨvɨdɨŋ lɨba cɨkaŋ ahica hɨvɨ ihatɨbutɨbu lɨbacin agɨlaŋ kɨlɨ cɨkaŋ hɨbɨn hɨbɨn muji heŋ ala hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","La kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ lamɨgaŋ lɨba golɨ hɨvɨ vihavɨbali agadɨ avi viavɨla ivoua hafilɨbavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Lavɨla maci sakɨvakɨva lamalama hɨsɨŋ vadɨm agadɨ uaiaŋ pabiŋ pabiŋ sagalɨ igu igu hɨsɨŋ uvɨ heŋ via ivoua ulaŋ madɨŋ lakulamaŋ kɨlikɨli heŋ lamavɨm uami. La unɨ lamalama hɨsɨŋ hɨlɨ agadɨ via ivoua ulaŋ madɨŋ limu ium kɨlikɨli heŋ lamavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Havɨlɨ ulaŋ agadɨ hɨbɨ ivu ivu heŋ hɨsihalahala saŋ havɨlɨ mila hekɨlɨ mu huaci sɨbaŋ agadɨ vihavɨm uami. La niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavalɨ agɨladɨ vivi hɨcavɨm uami. Hɨcavɨci hajɨŋ daŋ hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Lɨci hɨda kɨlɨ akasɨ mibɨŋ hegulaŋ me human limu fɨhala agɨladɨ vihavɨm uami. Viavɨla lɨba golɨ hɨvɨ ifuhafihafi uavɨm uami. La havɨlɨ lamalama agɨlimɨgumɨgu saŋ lɨba golɨ agɨlɨŋ agɨladɨ vivi hɨda hɨvɨ lamalama lɨbɨhahavɨm uami. La hɨda agɨladɨ lalɨlamalama saŋ lɨba bɨlasɨ kum haca daŋ haca daŋ human limu fɨhala agɨladɨ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","La Asɨ Iaue agaŋ cɨhu ala abami. Kɨlɨ akasɨ mibɨŋ hegulaŋ me agɨladɨ viavɨla sagalɨ hɨlahɨla hɨsɨŋ vadɨm vihavɨm uami. Vihavɨci nudɨ hutesɨ agaŋ 220 senɨtamita hɨnim uami. Nudɨ abɨŋ agaŋ avi 220 senɨtamita hɨnim uami. Ahica hɨlihɨli hameŋ laci hɨniavɨm uami. Vadɨm agadɨ iahua hɨvɨ hɨnia fɨli mɨgamɨga agaŋ 130 senɨtamita hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Lɨci kɨlɨ akasɨ mibɨŋ hegulaŋ me agɨladɨ lɨhuavɨci kum limu ahica limu ahica daŋ hɨnim uami. Kum pabiŋ pabiŋ agɨlaŋ ikuŋ limu limu hɨvɨ hɨniavɨm uami. Lɨhavɨci sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ lɨba bɨlasɨ hɨvɨ sɨkasɨkan ifuhafihafi uavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Lɨba bɨlasɨ hɨvɨ hunaŋ mɨsɨn hekɨlɨ hekɨlɨ limu hɨhɨle avɨŋ ibɨlɨ lamalama hɨsɨŋ agɨladɨ vihavɨm uami. Avɨŋ ibɨlɨ licilici saŋ sami hekɨlɨ hekɨlɨ me agɨladɨ vihavɨm uami. Hunaŋ mɨsɨn sɨhɨm mɨdɨ hɨniavɨdaci vivi sevaseva hɨsɨŋ agɨladɨ vihavɨm uami. Akuaba akuaba avɨŋ hɨvɨ hɨniavɨdaci iamɨla iamɨla vivi hɨsɨŋ agɨladɨ vihavɨm uami. La hunaŋ hɨhɨle avɨŋ sɨvɨ me agadɨ lama via hɨdahɨda hɨsɨŋ agɨladɨ avi vihavɨm uami. Hunaŋ mɨsɨn akuaba akuaba agɨladɨ lɨba bɨlasɨ hɨvɨ laci vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Lavɨla lɨba bɨlasɨ hɨvɨ mɨkɨdiŋ tulɨ me agadɨ vihavɨm uami. Mɨkɨdiŋ tulɨ me heŋ avɨŋ makaŋ lamalama sɨhɨm sabaŋ akuaba akuaba agɨladɨ avɨŋ makaŋ sabɨ hɨvɨ lamalama hɨlavɨbali uami. Mɨkɨdiŋ tulɨ me agadɨ viavɨla hakɨ limu ahica limu ahica vihavɨm uami. La hakɨ agɨladɨ viavɨla ikuŋ limu limu hɨvɨ lamavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Lavɨla lɨba bɨlasɨ cɨliŋ hekɨlɨ mu agadɨ viavɨla sagalɨ hɨlahɨla hɨsɨŋ vadɨm mɨkamɨka agadɨ hɨvɨ lɨba bɨlasɨ mɨkɨdiŋ tulɨ me agadɨ ifɨmɨgamɨga lamalama ifuhafiavɨm uami. Ifuhafiavɨci lɨba bɨlasɨ mɨkɨdiŋ tulɨ me agaŋ vadɨm mɨkamɨka agadɨ lɨvala mɨgua alɨhaba hɨvɨ hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Lɨci kɨlɨ akasɨ sɨlɨvɨ ahica mibɨŋ hegulaŋ me agɨladɨ lɨhuavɨla lɨba bɨlasɨ hɨvɨ ifuhafihafi uavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Lavɨla sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ havahava saŋ kɨlɨ sɨlɨvɨ agɨladɨ viavɨla hakɨ madɨŋ limu limu hɨniavɨbali agɨladɨ hɨvɨ lamavɨci ivouavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ kɨlɨ cɨkaŋ hɨvɨ vihavɨm uami. Vihavɨci hɨbɨn hɨbɨn me hɨnim uami. Agadɨ ala vadɨm mɨgua lɨhu fɨli hɨvɨ lamalama hɨsɨŋ agadɨ kɨlɨ cɨkaŋ lamavɨmɨdɨ uami. Vana tuŋ daŋ hɨnim uami. Akuaba akuaba viaŋ halu neŋ nadɨ abalamin agɨladɨ hameŋ laci ala abɨdanaŋ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","La Asɨ Iaue agaŋ cɨhu ala abami. Havɨlɨ mila hekɨlɨ hekɨlɨ huaci huaci sɨbaŋ agɨladɨ hɨvɨ havɨlɨ ulaŋ haiabɨla agadɨ caba caba heŋ lua me hahahaha saŋ vihavɨm uami. Madɨŋ limu ium kɨlikɨli agasaŋ vihavɨci 44 mita hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Hɨda 20 agɨladɨ viavɨla lɨba bɨlasɨ hɨvɨ ifuhafihafi uavɨm uami. Hɨda agɨladɨ lalɨlamalama saŋ lɨba bɨlasɨ kum haca daŋ haca daŋ 20 agɨladɨ vihavɨm uami. Lɨba silɨva hɨvɨ agɨlɨŋ hɨhɨle vihavɨm uami. Havɨlɨ mila hekɨlɨ huaci sɨbaŋ agadɨ lɨbala lɨbala saŋ lɨba silɨva agɨlɨŋ agɨladɨ lɨba silɨva cɨliŋ hɨda sugɨ hahavɨbali agɨladɨ hɨvɨ agɨlimɨgumɨgu uavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Madɨŋ limu lakulamaŋ kɨlikɨli agasaŋ havɨlɨ mila hekɨlɨ huaci sɨbaŋ agadɨ vihavɨci 44 mita hɨnim uami. Hɨda 20 agɨladɨ viavɨla lɨba bɨlasɨ hɨvɨ ifuhafihafi uavɨm uami. Hɨda lalɨlamalama saŋ lɨba bɨlasɨ kum haca daŋ haca daŋ 20 agɨladɨ vihavɨm uami. Lɨba silɨva hɨvɨ agɨlɨŋ hɨhɨle vihavɨm uami. Havɨlɨ mila hekɨlɨ huaci sɨbaŋ agadɨ lɨbala lɨbala saŋ lɨba silɨva agɨlɨŋ agɨladɨ viavɨla lɨba silɨva cɨliŋ hɨda sugɨ hahavɨbali agɨladɨ hɨvɨ agɨlimɨgumɨgu uavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ulaŋ safɨli agadɨ haiabɨla uaiaŋ mɨgumɨgu kɨlikɨli heŋ lɨbalavɨci lua me hɨnihɨni saŋ havɨlɨ mila hekɨlɨ huaci sɨbaŋ agadɨ vihavɨci 22 mita hɨnim uami. Hɨda human limu limu fɨhala agɨladɨ viavɨla lɨba bɨlasɨ hɨvɨ ifuhafihafi uavɨm uami. Hɨda agɨladɨ lalɨlamalama saŋ lɨba bɨlasɨ kum haca daŋ haca daŋ human limu limu fɨhala agɨladɨ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ulaŋ hali hɨbɨ agadɨ haiabɨla uaiaŋ iahaiaha kɨlikɨli heŋ lɨbalavɨci lua me hɨnihɨni saŋ havɨlɨ mila hekɨlɨ huaci sɨbaŋ agadɨ vihavɨci 22 mita hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Hɨbɨ ivu ivu limu caba agasaŋ havɨlɨ mila huaci sɨbaŋ vihavɨci 660 senɨtamita hɨnim uami. Hɨbɨ ivu ivu limu caba agasaŋ avi havɨlɨ mila huaci sɨbaŋ vihavɨci 660 senɨtamita hɨnim uami. Hɨbɨ ivu ivu limu caba agasaŋ hɨda ahica pam agɨladɨ viavɨla lɨba bɨlasɨ hɨvɨ ifuhafihafi uavɨm uami. Hɨda agɨladɨ lalɨlamalama saŋ lɨba bɨlasɨ kum haca daŋ haca daŋ ahica pam agɨladɨ vihavɨm uami. Hɨbɨ ivu ivu limu caba agasaŋ avi hɨda ahica pam agɨladɨ viavɨla lɨba bɨlasɨ hɨvɨ ifuhafihafi uavɨm uami. Hɨda agɨladɨ lalɨlamalama saŋ lɨba bɨlasɨ kum haca daŋ haca daŋ ahica pam agɨladɨ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Hɨbɨ ivu ivu amɨŋ agadɨ hɨsihalahala saŋ havɨlɨ mila huaci sɨbaŋ vihavɨci 9 mita hɨnim uami. Lɨci niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavalɨ agɨladɨ vivi hɨcavɨm uami. Hɨcavɨci hajɨŋ daŋ hɨnim uami. Havɨlɨ agadɨ lɨbalavɨci hɨnihɨni saŋ hɨda limu ahica limu ahica agɨladɨ viavɨla lɨba bɨlasɨ hɨvɨ ifuhafihafi uavɨm uami. Hɨda agɨladɨ lalɨlamalama saŋ lɨba bɨlasɨ kum haca daŋ haca daŋ limu ahica limu ahica agɨladɨ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Lɨba silɨva cɨliŋ agɨladɨ vivi hɨda sɨkasɨkan agɨladɨ sugɨ hɨvɨ hahahaha uavɨm uami. Lɨba silɨva hɨvɨ agɨlɨŋ viavɨla lɨba silɨva cɨliŋ agɨladɨ hɨvɨ agɨlimɨgumɨgu uavɨm uami. Hɨda agɨladɨ lalɨlamalama saŋ lɨba bɨlasɨ kum haca daŋ haca daŋ agɨladɨ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ulaŋ haiabɨla agadɨ madɨŋ limu limu havɨlɨ mila huaci huaci sɨbaŋ lɨbala lɨbala lua me hahavɨbali agadɨ hutesɨ 44 mita hɨniavɨm uami. Nudɨ safɨli kɨlikɨli nudɨ hali hɨbɨ kɨlikɨli 22 mita hɨniavɨm uami. Ulaŋ haiabɨla agadɨ madɨŋ limu limu safɨli hali hɨbɨ lamalama lɨbala lɨbala lua me hahavɨbali agɨladɨ iahua hɨvɨ hɨnia fɨli mɨgamɨga agɨlaŋ 220 senɨtamita laci hɨniavɨm uami. Havɨlɨ mila huaci sɨbaŋ agadɨ hɨvɨ havɨlɨ ulaŋ haiabɨla agadɨ lua me lamalama hɨsihalavɨm uami. Hɨda agɨladɨ lalɨlamalama saŋ lɨba bɨlasɨ kum haca daŋ haca daŋ agɨladɨ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Havɨlɨ ulaŋ agadɨ hɨvɨ sibɨla vivi saŋ akuaba akuaba agɨladɨ lɨba bɨlasɨ hɨvɨ laci vihavɨm uami. Havɨlɨ ulaŋ agadɨdaŋ nudɨ lua me agadɨdaŋ vɨdɨvɨdɨŋ igu igu saŋ lɨba bɨlasɨ henaŋ hutesɨ hutesɨ agɨladɨ vihavɨm uami. Fɨli hɨvɨ ifavɨci ifavɨci mɨguavɨdaci lɨmɨn havɨlɨ ulaŋ hɨsɨŋ agɨladɨdaŋ nudɨ lua me hɨsɨŋ agɨladɨdaŋ magɨla magɨla hahahaha saŋ lɨba bɨlasɨ henaŋ hutesɨ hutesɨ agɨladɨ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","La Asɨ Iaue agaŋ Mosesɨ dɨ abami. Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨha uami. Abɨnaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ ifɨcabɨlavɨdaci mɨtɨ huaci huaci mɨgavɨbali agɨladɨ unɨ hɨvɨ lamalama saŋ vihavɨm uami. La hɨfɨlɨ mu hɨvɨ mu hɨvɨ unɨ agɨladɨ lubilamavɨdaci lɨhulɨhu hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Alon agaŋ nudɨ ninadinu agɨlaŋ hula havɨlɨ uleŋ muji sɨbaŋ havɨlɨ lɨbalavɨci kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ hɨsihala hɨnici vebali heŋ ivouavɨbali uami. Ivouavɨla unɨ agɨladɨ hihɨlavɨla hɨfɨlɨ mu mu kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨ unɨ agɨladɨ hɨvɨ lamavɨbali uami. Lamalama lubilamavɨdaci viaŋ igasulɨdalɨŋ lɨhulɨhu hɨniavɨbali uami. Lɨhulɨhu hɨniavɨdaci fɨli mɨŋalahɨbali uami. Isɨlaelɨ hɨdɨlɨ naludɨ ninanadinalu ajihalinalu iamɨlɨhalinalu mufɨli iahavɨbali agɨlaŋ mufɨli mufɨli hameŋ laci hameŋ laci ciaŋ vɨdɨvɨdɨŋ nagadɨ lubiahɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","La Asɨ Iaue agaŋ Mosesɨ dɨ abami. Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨnaŋ isana Alon dɨdaŋ nudɨ ninadinu agɨladɨdaŋ nadɨ pɨŋ vavehavɨm uami. Alon ninadinu dɨ ibi nameŋ uami. Mu Nadapɨ uami. Mu Abihu uami. Mu Eleasalɨ uami. Mu Itamalɨ uami. Vavehavɨci nɨbɨlaŋ iasaŋ sagalɨ igu igu hɨsɨŋ hulaŋ hɨnihɨni sibɨla vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Isɨlaelɨ hɨdɨlɨ agɨlaŋ iasaŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ agasaŋ hadi hɨlahɨla huaci huaci agɨladɨ hɨcavɨm uami. La Alon dɨ hɨvɨ ahuala lamavɨci hajɨŋ huaci huaci daŋ hɨdɨdaci Isɨlaelɨ hɨdɨlɨ agɨlaŋ nudɨ iga iga abavɨbali uami. Ha nɨbu hulaŋ ibi daŋ aba abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Hulaŋ hɨhɨle human sihɨ daŋ agɨlasaŋ hɨji hutesɨ ci iguacin uami. Nama nulɨdɨ abɨnaŋ Alon saŋ sagalɨ igu igu hɨsɨŋ hadi hɨlahɨla vihavɨm uami. Vihavɨci lamam uami. Lamɨci abɨben uami. Ha iadɨ sibɨla hɨsɨŋ hulaŋ aba abɨben uami. Lɨlɨŋ iasaŋ sagalɨ igu igu hɨsɨŋ hulaŋ hɨnihɨni sibɨla vibali uami. ");
INSERT INTO ena_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Sugɨ vaŋ me agadɨ vihavɨm uami. Havɨlɨ cɨliŋ daŋ agadɨ vihavɨm uami. Hadi hɨlahɨla mu agadɨ vihavɨm uami. Hadi hɨlahɨla hutesɨ mu havɨlɨ mila huaci sɨbaŋ agadɨ hɨvɨ vihavɨm uami. Havɨlɨ mu hali hɨvɨ lɨbɨhahahaha hɨsɨŋ agadɨ vihavɨm uami. Lavi lɨbɨhahahaha hɨsɨŋ me agadɨ vihavɨm uami. Hadi hɨlahɨla huaci huaci agɨladɨ Alon sadaŋ nudɨ ninadinu agɨlasadaŋ vihavɨm uami. Vihavɨci iasaŋ sagalɨ igu igu hɨsɨŋ hulaŋ hɨnihɨni hadi hɨlahɨla agɨladɨ ahuala lamalama sibɨla vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Sagalɨ igu igu hɨsɨŋ hulaŋ agɨladɨ hadi hɨlahɨla akuaba akuaba agɨladɨ vivi saŋ akuaba akuaba nameŋ agɨladɨ vihavɨm uami. Havɨlɨ mila huaci huaci sɨbaŋ agɨladɨ vihavɨm uami. Niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavalɨ agɨladɨdaŋ lɨba golɨ niagɨlɨŋ agɨladɨdaŋ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Havɨlɨ mu vihavɨci cɨliŋ daŋ hɨnihɨni saŋ nameŋ lɨhavɨm uami. Niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavalɨ agɨladɨdaŋ lɨba golɨ niagɨlɨŋ agɨladɨdaŋ vihavɨm uami. Viavɨla havɨlɨ mila huaci sɨbaŋ agadɨ hɨvɨ hɨcavɨci sihɨ sihɨ daŋ hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","La havɨlɨ agaŋ sɨlɨhala mɨgɨmɨdɨ aba cɨliŋ ahica macɨŋ limu limu hɨvɨ huliavalɨci mɨgamɨga saŋ havɨlɨ agadɨ hɨvɨ lamalama hɨcavɨm uami. Mavɨn hɨbɨ hɨsɨŋ agadɨ hɨvɨ lamalama hɨcavɨm uami. Hulɨpɨŋ hɨsɨŋ agadɨ hɨvɨ avi lamalama hɨcavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","La havɨlɨ cɨliŋ daŋ agadɨ lavi me vivi saŋ nameŋ lɨhavɨm uami. Niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavalɨ agɨladɨdaŋ lɨba golɨ niagɨlɨŋ agɨladɨdaŋ vihavɨm uami. Lavɨla havɨlɨ mila huaci sɨbaŋ mu agadɨ hɨvɨ hɨcavɨci sihɨ sihɨ daŋ hɨnim uami. Lɨci lavi me agadɨ viavɨla havɨlɨ cɨliŋ daŋ agadɨ fɨdɨm hɨvɨ lama hɨcavɨci havɨlɨ sihɨ sihɨ daŋ laci hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","11","Lɨci lɨba hɨlɨcɨ konilian ahica agɨladɨ viavɨla hulaŋ mu lɨba hɨvɨ ibi ihasihɨsihɨ lɨlalɨ agasaŋ iguavɨm uami. Iguavɨci Jekopɨ ninadinu human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ agɨladɨ ibi ihasihɨsihɨ lɨm uami. Ninaŋ Cimegeŋ agadɨ ibi mɨse ihasihɨsihɨ lavɨla via ua Amasiŋ agadɨ ibi sijaŋ ihasihɨsihɨ lɨm uami. Lɨba hɨlɨcɨ mu hɨvɨ ninaŋ human limu fɨhala human limu pabiŋ cɨjɨŋ agɨladɨ ibi ihasihɨsihɨ lɨm uami. Lɨba hɨlɨcɨ mu agadɨ hɨvɨ avi ninaŋ human limu fɨhala human limu pabiŋ cɨjɨŋ agɨladɨ ibi ihasihɨsihɨ lɨm uami. Ihasihɨsihɨ lavɨla lɨba hɨlɨcɨ ahica hulaŋ ibi daŋ agɨladɨ via lɨba golɨ hajɨŋ cɨki cɨki havaŋ avɨli veve agadɨ ulaŋ tulɨ me agɨladɨ hɨvɨ lamɨci mɨguavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Mɨguavɨci havɨlɨ cɨliŋ macɨŋ limu limu hɨniavɨbali agɨladɨ hɨvɨ macɨŋ sabɨ heŋ lama lɨbɨhaham uami. Lɨci Alon agaŋ lɨba hɨlɨcɨ ahica agɨladɨ macɨŋ hɨvɨ via hɨdɨdaci viaŋ iga iga iadɨ hulaŋ iamɨgali Isɨlaelɨ hɨdɨlɨ agɨlasaŋ igahɨlɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Lɨba golɨ hɨvɨ hajɨŋ cɨki cɨki havaŋ avɨli veve agadɨ ulaŋ tulɨ me agɨladɨ ahica vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","La lɨba golɨ huaci sɨbaŋ hɨvɨ lɨmɨn vɨdɨvɨdɨŋ ahica vihavɨm uami. Lɨba golɨ huaci sɨbaŋ agadɨ ifavɨci hucɨŋ me hɨnim uami. Lɨci lɨmɨn vɨdɨvɨdɨŋ tagɨlaŋ niagɨlɨŋ me ivavɨlalɨ hameŋ lɨmɨn vɨdɨvɨdɨŋ ahica agɨladɨ vihavɨm uami. La lɨmɨn vɨdɨvɨdɨŋ ahica agɨladɨ viavɨla lɨba golɨ hajɨŋ cɨki cɨki havaŋ avɨli veve agadɨ ulaŋ tulɨ me agɨladɨ hɨvɨ hahavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","La Asɨ Iaue agaŋ cɨhu abami. Niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavalɨ agɨladɨdaŋ lɨba golɨ niagɨlɨŋ agɨladɨdaŋ vihavɨm uami. Viavɨla havɨlɨ mila huaci sɨbaŋ agadɨ hɨvɨ hɨcavɨci sihɨ sihɨ daŋ hɨnim uami. Havɨlɨ cɨliŋ daŋ agadɨ sihɨ me hɨnim uami. Lɨci nudɨ viavɨla iasaŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ agasaŋ sugɨ vaŋ me agadɨ vihavɨm uami. Lɨba hɨlɨcɨ ahica agɨlaŋ sugɨ vaŋ me agadɨ muji heŋ hɨnihɨni iadɨ hɨji agadɨ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ agasaŋ abalamavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Sugɨ vaŋ me agadɨ hutesɨ 44 senɨtamita hɨnim uami. Nudɨ abɨŋ agaŋ 22 senɨtamita hɨnim uami. Lɨci nudɨ hutesɨ agadɨ alɨhaŋ lama mɨŋafɨhulavɨci ve hɨlihɨli laci hɨnim uami. Lɨci hutesɨ agaŋ 22 senɨtamita hɨnim uami. Nudɨ abɨŋ avi 22 senɨtamita hɨnim uami. Lavɨla ahica hɨlihɨli laci hɨniavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Lɨhavɨci sugɨ vaŋ me agadɨ hɨvɨ lɨba hɨlɨcɨ anɨm hɨlɨcɨ hekɨlɨ hɨvɨ lavavɨlalɨ agɨladɨ sɨlɨ limu ahica limu ahica lamalama lɨbɨhahavɨm uami. Sɨlɨ mu hɨvɨ lɨba lobi lɨba topasɨ lɨba ganetɨ agɨladɨ lamalama lɨbɨhahavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Sɨlɨ mu agadɨ hɨvɨ lɨba emelalɨ lɨba sapaia lɨba daimon agɨladɨ lamalama lɨbɨhahavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Sɨlɨ mu hɨvɨ lɨba telɨkoisɨ lɨba agetɨ lɨba ametisɨ agɨladɨ lamalama lɨbɨhahavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Sɨlɨ mu hɨvɨ lɨba belilɨ lɨba konilian lɨba jasɨpa agɨladɨ lamalama lɨbɨhahavɨm uami. Lɨba hɨlɨcɨ agɨladɨ lɨba golɨ hajɨŋ cɨki cɨki havaŋ avɨli veve agadɨ ulaŋ tulɨ me agɨladɨ hɨvɨ lamavɨci mɨgua hɨniavɨdaci sugɨ vaŋ me agadɨ hɨvɨ lamalama lɨbɨhahavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Lɨba hɨlɨcɨ hɨlɨcɨ agɨladɨ hɨvɨ Jekopɨ ninadinu human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ agɨladɨ ibi ihasihɨsihɨ lɨhavɨm uami. Nɨbɨlaŋ Isɨlaelɨ hɨdɨlɨ hulaŋ latɨhiŋ agɨladɨ iamɨlɨhalinɨlu uami. ");
INSERT INTO ena_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Lɨhavɨci lɨba golɨ huaci sɨbaŋ agadɨ via ifavɨci ifavɨci ua hucɨŋ me hɨniavɨm uami. Lɨhavɨci nulɨdɨ vivi lɨmɨn vɨdɨvɨdɨŋ tagɨlaŋ niagɨlɨŋ me ivavɨm uami. Sugɨ vaŋ me agasaŋ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Lavɨla lɨba golɨ hakɨ ahica vihavɨm uami. Viavɨla sugɨ vaŋ me agadɨ fɨdɨm limu limu iahua sabɨ heŋ lamavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Lavɨla lɨmɨn vɨdɨvɨdɨŋ ahica lɨba golɨ hɨvɨ vihavɨbali agɨladɨ viavɨla sugɨ vaŋ me agadɨ lɨba golɨ hakɨ ahica heŋ hɨtɨŋ hɨtɨŋ hahavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","La lɨmɨn vɨdɨvɨdɨŋ fɨdɨm limu limu lɨba golɨ hɨvɨ vihavɨbali agɨladɨ viavɨla lɨba golɨ hajɨŋ cɨki cɨki havaŋ avɨli veve agadɨ ulaŋ tulɨ me agɨladɨ hɨvɨ hahavɨm uami. Lɨba golɨ hajɨŋ agɨlaŋ iasaŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ agadɨ havɨlɨ cɨliŋ daŋ nudɨ macɨŋ sabɨ limu limu hɨniavɨbali heŋ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Lɨba golɨ hakɨ ahica vihavɨm uami. Viavɨla sugɨ vaŋ me agadɨ fɨdɨm limu limu mɨga hulɨpɨŋ heŋ lama lɨbɨhahavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Lavɨla cɨhu lɨba golɨ hakɨ ahica vihavɨm uami. Viavɨla havɨlɨ cɨliŋ daŋ agadɨ hɨvɨ hahavɨm uami. Havɨlɨ agadɨ cɨliŋ fɨdɨm agɨladɨ lavi me agadɨdaŋ lama hɨcavɨbali heŋ hahavɨm uami. Mavɨn hɨbɨ hɨvɨ lama hɨcavɨbali heŋ hahavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","La niagɨlɨŋ cɨbɨŋ agɨladɨ vihavɨm uami. Viavɨla sugɨ vaŋ me mɨga fɨdɨm limu limu agɨladɨ hɨvɨ lɨba golɨ hakɨ muji hahavɨbali heŋ niagɨlɨŋ cɨbɨŋ agɨladɨ hahavɨm uami. La havɨlɨ cɨliŋ daŋ agadɨ hɨvɨ lɨba golɨ hakɨ hahavɨbali heŋ niagɨlɨŋ cɨbɨŋ agɨladɨ hahavɨm uami. Lɨhavɨci manɨgali agaŋ hɨdɨdaci sugɨ vaŋ me agaŋ ma uu veve sese lɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Lɨci Alon agaŋ sugɨ vaŋ me Isɨlaelɨ hɨdɨlɨ agɨladɨ ibi daŋ agadɨ lamalama uaiaŋ pabiŋ pabiŋ sagalɨ igu igu hɨsɨŋ uvɨ heŋ ubali uami. Lɨdaci viaŋ lɨba hɨlɨcɨ hulaŋ ibi daŋ agɨladɨ iga iga iadɨ hulaŋ iamɨgali agɨlasaŋ igahɨlɨben uami. Mufɨli mufɨli hameŋ laci lɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Lɨba ulim agadɨdaŋ lɨba tumim agadɨdaŋ viavɨla sugɨ vaŋ me agadɨ tulɨ heŋ hudɨha uami. Hudɨnaŋ viaŋ igasulɨdalɨŋ Alon agaŋ uaiaŋ pabiŋ pabiŋ sagalɨ igu igu hɨsɨŋ uvɨ heŋ uben aba lɨba ahica agɨlaŋ sugɨ vaŋ me agadɨ muji hɨniavɨdaci sugɨ vaŋ me agadɨ lamavɨla ubali uami. Sugɨ vaŋ me lɨba kum ahica daŋ agadɨ lamalama uu viaŋ akuaba akuaba saŋ abɨben agadɨ igahɨlahɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨbali uami. Mufɨli mufɨli hameŋ laci lɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","32","La Asɨ Iaue agaŋ cɨhu abami. Niagɨlɨŋ cɨbɨŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavalɨ agɨladɨ hɨvɨ laci hadi hɨlahɨla agadɨ vihavɨci sihɨ sihɨ daŋ hɨnim uami. Lavɨla hali hɨvɨ ahualɨci mɨgamɨga saŋ haca daŋ vihavɨm uami. La haca agaŋ lalɨlahɨmɨdɨ aba havɨlɨ cɨliŋ agadɨ viavɨla haca mɨkamɨka agadɨ hɨvɨ lamalama hɨcavɨm uami. Hɨcavɨci sagaŋ hɨsɨŋ hadi hɨlahɨla me hɨnim uami. Lɨci iasaŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ agaŋ hadi hɨlahɨla agadɨ hali hɨvɨ ahualɨci mɨgɨbali uami. Hali hɨvɨ ahualɨci mɨgɨci havɨlɨ cɨliŋ daŋ agadɨ via nudɨ sabɨ lamɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavɨlalɨ agɨladɨ vihavɨm uami. Viavɨla kɨlɨ pomigɨlanetɨ agadɨ amɨŋ me agɨladɨ hɨcavɨla hadi hɨlahɨla agadɨ fɨdɨm hɨvɨ lɨbala lɨbala uavɨm uami. La lɨba golɨ huaci sɨbaŋ hɨvɨ iajɨ tɨbaŋ tɨbaŋ me agɨladɨ vihavɨm uami. Viavɨla kɨlɨ pomigɨlanetɨ agadɨ amɨŋ me lɨbalavɨci alɨhaŋ tuŋ daŋ tuŋ daŋ hɨniavɨbali heŋ iajɨ tɨbaŋ tɨbaŋ me agɨladɨ lɨbala lɨbala uavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Lɨhavɨci Alon agaŋ hadi hɨlahɨla agɨladɨ lamavɨla sagalɨ igu igu hɨsɨŋ sibɨla vibali uami. Lɨdaci viaŋ igasulɨdalɨŋ uaiaŋ pabiŋ pabiŋ sagalɨ igu igu hɨsɨŋ uvɨ heŋ ivo ivo cɨhu haiabɨla ivavedaci lɨba golɨ iajɨ tɨbaŋ tɨbaŋ me agɨladɨ sagɨliŋ igahɨlɨben uami. Nɨbu hameŋ lavɨla ha ma hɨmɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Hulaŋ mu lɨba hɨvɨ ciaŋ ihasihɨsihɨ lɨlalɨ agaŋ lɨba golɨ huaci sɨbaŋ agadɨ viavɨla hajɨŋ mu vim uami. Viavɨla nudɨ hɨvɨ ciaŋ nameŋ agadɨ ihasihɨsihɨ lɨci hɨnim uami. Ha Asɨ Iaue dɨ aba ihasihɨsihɨ lɨci hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Lɨci niagɨlɨŋ cɨbɨŋ ivavɨm uami. Iva viavɨla lɨba golɨ hajɨŋ agadɨ iasaŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ agadɨ havɨlɨ hali hɨvɨ lɨbɨhahahaha hɨsɨŋ agadɨ hɨvɨ lɨbalavɨm uami. Lɨbalavɨci nudɨ lɨbam heŋ lɨbala hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Isɨlaelɨ hɨdɨlɨ agɨlaŋ iadɨ ciaŋ agadɨ sɨhɨvia ma lubiahɨlavɨla sagalɨ iguavɨci ha Alon agaŋ nulɨdɨ ahɨliahua nulɨdɨ hugɨ agɨladɨ havɨbali uami. Uaiaŋ mu hɨvɨ mu hɨvɨ hajɨŋ ibi daŋ agadɨ havɨlɨ hali hɨsɨŋ heŋ lɨbalɨci lɨbam heŋ lɨbala hɨnibali uami. Lɨdaci viaŋ hajɨŋ lɨbam hɨvɨ hɨnibali agadɨ iga iga Isɨlaelɨ hɨdɨlɨ agɨlaŋ akuaba akuaba sagalɨ iasaŋ iguavɨbali agɨladɨ viben uami. ");
INSERT INTO ena_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Havɨlɨ mila huaci sɨbaŋ agadɨ viavɨla hadi hɨlahɨla hutesɨ vihavɨci mila sihɨ sihɨ daŋ pam hɨnim uami. Havɨlɨ mila huaci sɨbaŋ mu Alon dɨ hali hɨvɨ lɨbɨhahahaha saŋ vihavɨm uami. Havɨlɨ mila huaci sɨbaŋ mu viavɨla lavi me agadɨ vihavɨm uami. Viavɨla niagɨlɨŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ vivi lavi me agadɨ hɨvɨ hɨcavɨci hajɨŋ daŋ hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Lɨci cɨhu hadi hɨlahɨla hutesɨ hɨhɨle agɨladɨ vihavɨm uami. Lavi me hɨhɨle agɨladɨ vihavɨm uami. Mɨlaŋ lɨpɨlɨpɨ me agɨladɨ avi vihavɨm uami. Vihavɨci Alon dɨ ninadinu agɨlaŋ hadi hɨlahɨla akuaba akuaba hajɨŋ huaci huaci daŋ agɨladɨ lamalama hɨdavɨdaci Isɨlaelɨ hɨdɨlɨ limu hɨhɨle agɨlaŋ nulɨdɨ iga iga abavɨbali uami. Ha hulaŋ ibi daŋ ibi daŋ aba abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","La Asɨ Iaue agaŋ Mosesɨ dɨ abami. Hadi hɨlahɨla akuaba akuaba agɨladɨ isana Alon dɨ hɨvɨ ahuala lamɨha uami. Nudɨ ninadinu agɨladɨ hɨvɨ avi ahuala lamɨha uami. La cihu savu me agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavɨla akuaba akuaba iasaŋ lɨbɨmɨŋɨben aba nulɨdɨ sabɨ hɨvɨ mɨŋamɨjiha uami. Lavɨla lɨbɨmɨŋɨnaŋ iasaŋ sagalɨ igu igu hɨsɨŋ hulaŋ hɨnihɨni sibɨla vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Havɨlɨ mila huaci sɨbaŋ hɨvɨ usaŋ tɨbɨ tɨbɨ uvɨ sɨbɨlɨ hɨsihalahala saŋ vihavɨm uami. Vihavɨci nulɨdɨ lamavɨdaci mɨgumɨgu hɨcɨ suli hɨvɨ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Alon agaŋ ninadinu hula usaŋ hameŋ agɨladɨ muji lamavɨm uami. Lamalama sagalɨ hɨlahɨla hɨsɨŋ vadɨm heŋ uu sibɨla vihavɨm uami. Uaiaŋ pabiŋ pabiŋ sagalɨ igu igu hɨsɨŋ uvɨ havɨlɨ uleŋ muji heŋ avi lamalama uavɨm uami. Hameŋ lɨdɨŋ nɨbɨlaŋ hugɨ apalɨ hɨniavɨdaci viaŋ nulɨdɨ ma ifɨhɨmɨben uami. Mufɨli mufɨli Alon dɨ ninadinu ajihalinu agɨlaŋ ciaŋ vɨdɨvɨdɨŋ nagadɨ lubiahɨlahɨla hameŋ laci hameŋ laci ala lɨhavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","La Asɨ Iaue agaŋ cɨhu abami. Alon dɨdaŋ nudɨ ninadinu agɨladɨdaŋ lɨbɨmɨŋɨnaŋ iasaŋ sagalɨ igu igu hɨsɨŋ hulaŋ hɨnihɨni sibɨla vihavɨbali uami. Nulɨdɨ lɨbɨmɨŋamɨŋa saŋ sabaŋ bulɨmakau muŋaŋ pabiŋ viha uami. Sabaŋ sipsipɨ muŋaŋ fim akuaba akuaba apalɨ agɨladɨ ahica viha uami. ");
INSERT INTO ena_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Lavɨla maci huaci huaci sɨbaŋ agɨladɨ viha uami. Maci daŋ eŋalavɨci huhɨla huhɨla hɨsɨŋ isɨ aba abavɨlalɨ agadɨ vimɨnaŋ uami. La maci limu hɨhɨle agɨladɨ viavɨla havɨ hɨlɨha uami. Maci limu hɨhɨle agɨladɨ viavɨla kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ daŋ eŋalavɨla hɨlɨha uami. Maci limu hɨhɨle agɨladɨ viavɨla hɨlɨnaŋ tata lɨhavɨci kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ hɨvɨ mɨŋepɨhalɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Lavɨla cinacina hɨvɨ huda iasaŋ sagalɨ iguha uami. Sabaŋ bulɨmakau muŋaŋ agadɨdaŋ sabaŋ sipsipɨ muŋaŋ ahica agɨladɨdaŋ sagalɨ igubanaŋ hadɨhu laci ala maci agɨladɨ avi iguha uami. ");
INSERT INTO ena_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","La Alon dɨdaŋ nudɨ ninadinu agɨladɨdaŋ iadɨ havɨlɨ ulaŋ hɨbɨ ivu ivu heŋ vave lama sɨlamɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Sɨlamavɨla sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ agadɨ hadi hɨlahɨla muhɨlɨ havɨlɨ akuaba akuaba agɨladɨ Alon dɨ hɨvɨ ahuala lamɨha uami. Hadi hɨlahɨla hutesɨ agadɨ mɨse ahuala lamɨha uami. La hadi hɨlahɨla mu nudɨ sabɨ ahuala lamɨha uami. Lavɨla havɨlɨ cɨliŋ daŋ agadɨ ahuala lamɨha uami. Lamavɨla sugɨ vaŋ me agadɨ nudɨ apagaŋ hɨvɨ manilamɨha uami. Lavɨla lavi me agadɨ viavɨla lavi lɨbɨhahavɨlalɨ heŋ lama lɨbɨhahɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","La havɨlɨ mu viavɨla hali hɨvɨ lɨbɨhahɨha uami. Lavɨla lɨba golɨ hajɨŋ agadɨ viavɨla havɨlɨ hali hɨvɨ lɨbɨhahɨnaŋ hɨnibali agadɨ hɨvɨ lɨbalɨnaŋ hɨnim uami. Lɨba golɨ hajɨŋ agadɨ hɨvɨ ciaŋ nameŋ agadɨ ihasihɨsihɨ lɨhavɨbali uami. Ha Asɨ Iaue dɨ aba ihasihɨsihɨ lɨhavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","La cihu savu me agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavɨbali agadɨ nudɨ hali sabɨ hɨvɨ mɨŋamɨjinaŋ mɨgɨci nudɨ lɨbɨmɨŋɨnaŋ iasaŋ sagalɨ igu igu hɨsɨŋ hulaŋ hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Lavɨla Alon ninadinu agɨladɨ avi vavevɨla hadi hɨlahɨla hutesɨ hutesɨ agɨladɨ nulɨdɨ hɨvɨ ahuala lamɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","La lavi me agɨladɨ lamalama lɨbɨhahɨha uami. Lavɨla havɨlɨ mɨlaŋ lɨpɨlɨpɨ me agɨladɨ nudɨ ninadinu agɨladɨ hali hɨvɨ hafilamalama uha uami. Lavɨla Alon dɨdaŋ nudɨ ninadinu agɨladɨdaŋ lɨbɨmɨŋɨnaŋ iasaŋ sagalɨ igu igu hɨsɨŋ hulaŋ hɨniavɨbali uami. Lɨhavɨci mufɨli mufɨli nulɨdɨ ninadinɨlu ajihalinɨlu agɨlaŋ avi hameŋ laci ala sagalɨ igu igu hɨsɨŋ hulaŋ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Sabaŋ bulɨmakau muŋaŋ agadɨ viavɨla iadɨ havɨlɨ ulaŋ agadɨ hɨbɨ ivu ivu heŋ vaveha uami. Vavenaŋ Alon hula nudɨ ninadinu agɨlaŋ hula nulɨdɨ human agɨladɨ sabaŋ bulɨmakau muŋaŋ agadɨ hali sabɨ hɨvɨ lamavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Lɨhavɨci viaŋ igasulɨdalɨŋ havɨlɨ ulaŋ hɨbɨ ivu ivu mikɨ heŋ sabaŋ bulɨmakau agadɨ ifɨhɨmɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Lavɨla human cɨjɨŋ hɨvɨ sabaŋ bulɨmakau mɨdɨ agadɨ lɨbɨvisavisa mɨŋepɨhalɨha uami. Sagalɨ hɨlahɨla hɨsɨŋ vadɨm kɨlɨ akasɨ mibɨŋ hegulaŋ me agɨladɨ lɨhuavɨla ikuŋ limu limu hɨvɨ kum limu ahica limu ahica lamavɨbali agɨladɨ hɨvɨ mɨŋepɨhalɨha uami. La mɨdɨ hɨhɨle agɨladɨ sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ caba caba heŋ fɨli hɨvɨ mɨŋamɨjinaŋ mɨgam uami. ");
INSERT INTO ena_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Lavɨla sɨdaŋ mulamula agadɨ viavɨla vicɨŋ agadɨ viha uami. La hama hulɨ hɨlɨcɨ ahica sɨdaŋ daŋ agɨladɨ avi viha uami. Lavɨla vadɨm hɨvɨ lamavɨla avɨŋ hɨvɨ hɨlɨnaŋ sɨkasɨkan lɨhua fɨhalavɨm uami. Lɨci hɨsi huaci huaci iadɨ hɨvɨ iahavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Lɨhavɨci sabaŋ bulɨmakau hɨlɨcɨ sɨgɨtɨ sucɨki agɨladɨ viavɨla ua uu veve hɨnihɨni fipɨ agadɨ vala umita ataŋ tagɨlaŋ lama hɨlɨha uami. Akuaba akuaba lɨbanaŋ ha sagalɨ igu igu hɨsɨŋ hulaŋ agɨladɨ hugɨ hivahiva saŋ lɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","La sabaŋ sipsipɨ muŋaŋ mu vaveha uami. Vavenaŋ Alon agaŋ nudɨ ninadinu hula nulɨdɨ human agɨladɨ sabaŋ sipsipɨ agadɨ hali sabɨ hɨvɨ lamavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Lɨhavɨci sabaŋ sipsipɨ agadɨ ifɨhɨmɨha uami. Lavɨla mɨdɨ agadɨ viavɨla sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ madɨŋ limu limu fɨdɨm limu limu hɨvɨ sevɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","La sabaŋ sipsipɨ agadɨ vɨhavɨla lagiŋ limu limu human limu limu agɨladɨdaŋ sucɨki agadɨdaŋ viha uami. Via husavɨla hali agadɨdaŋ viavɨla sagalɨ hɨlahɨla hɨsɨŋ vadɨm heŋ lamɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Lamavɨla avɨŋ hɨvɨ hɨlɨnaŋ sɨkasɨkan lɨhu fɨhalavɨm uami. Lɨhavɨci viaŋ sagalɨ hɨsi agadɨ igavɨla hɨjɨŋalɨben uami. Ha sagalɨ avɨŋ hɨvɨ hɨlahɨla hɨsɨŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","La cɨhu sabaŋ sipsipɨ muŋaŋ mu agadɨ avi vaveha uami. Vavenaŋ Alon agaŋ nudɨ ninadinu hula nulɨdɨ human agɨladɨ sabaŋ sipsipɨ agadɨ hali sabɨ hɨvɨ lamavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Lɨhavɨci sabaŋ sipsipɨ agadɨ ifɨhɨmɨha uami. Lavɨla mɨdɨ cɨki agadɨ viavɨla Alon dɨ hɨji asɨŋ mujɨŋ human sɨmi kɨlikɨli hɨvɨ mɨŋepɨhalɨha uami. La nudɨ ninadinu agɨladɨ hɨji asɨŋ mujɨŋ human sɨmi kɨlikɨli hɨvɨ mɨŋepɨhalapɨhala uha uami. La nulɨdɨ human sɨmi agɨladɨ numɨgaŋ cɨjɨŋ hɨvɨ mɨŋepɨhalapɨhala uha uami. La nulɨdɨ hɨcɨ sɨmi agɨladɨ numɨgaŋ cɨjɨŋ hɨvɨ avi hameŋ laci ala lɨha uami. Lɨnaŋ mɨdɨ hɨhɨle hɨniavɨci sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ madɨŋ limu limu fɨdɨm limu limu heŋ sevɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","La mɨdɨ hɨhɨle sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ madɨŋ heŋ hɨnibali agadɨ viha uami. Viavɨla cihu savu me agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavɨbali agadɨ viha uami. Via Alon dɨdaŋ nudɨ ninadinu agɨladɨdaŋ lɨbɨmɨŋamɨŋa saŋ eŋalɨha uami. Eŋalavɨla nulɨdɨ hadipɨlɨ hɨvɨ nulɨdɨ hadi hɨlahɨla akuaba akuaba agɨladɨ hɨvɨ sevɨha uami. Hameŋ lɨnaŋ nɨbɨlaŋ iasaŋ sagalɨ igu igu hɨsɨŋ hulaŋ hɨniavɨbali uami. Hulaŋ agɨlaŋ hula nulɨdɨ hadi hɨlahɨla akuaba akuaba agɨlaŋ hula iadɨ nukeŋ sɨbaŋ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","La sagalɨ igu igu hɨsɨŋ hulaŋ lɨbɨmɨŋamɨŋa saŋ sabaŋ sipsipɨ ifɨhɨmɨbanaŋ agadɨ vɨhavɨla sɨdaŋ agɨladɨ likɨlɨha uami. Liji hɨdɨlɨ sɨdaŋ daŋ agadɨ viha uami. Sɨdaŋ mulamula agadɨ viha uami. Vicɨŋ agadɨ viavɨla hama hulɨ hɨlɨcɨ ahica sɨdaŋ daŋ agɨladɨ viha uami. Lagiŋ hɨlɨcɨ human sɨmi kɨlikɨli hɨsɨŋ agadɨ viha uami. ");
INSERT INTO ena_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","La maci sakɨvakɨva mu hɨdɨlɨ mu hɨdɨlɨ iasaŋ sagalɨ igu igu saŋ cinacina hɨvɨ hudavɨbali agɨladɨ pabiŋ lɨdɨŋ pabiŋ lɨdɨŋ viha uami. Maci mu kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ daŋ eŋalavɨla hɨlavɨbali agadɨ pabiŋ viha uami. Maci mu kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ apalɨ hɨlavɨbali agadɨ pabiŋ viha uami. Maci tata agadɨ avi pabiŋ viha uami. ");
INSERT INTO ena_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Lavɨla maci agɨladɨdaŋ sɨhɨm hɨlɨcɨ agɨladɨdaŋ Alon sadaŋ nudɨ ninadinu agɨlasadaŋ iguha uami. Igunaŋ viaŋ igasulɨdalɨŋ nɨbɨlaŋ hɨjɨŋalaŋala iasaŋ sagalɨ iguavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Lɨhavɨci sɨmɨŋ agɨladɨ viavɨla sagalɨ hɨlahɨla hɨsɨŋ vadɨm sabɨ heŋ lama hɨlɨha uami. Lɨnaŋ viaŋ sagalɨ hɨsi agadɨ igavɨla hɨjɨŋalɨben uami. Ha iasaŋ sagalɨ avɨŋ hɨvɨ hɨlahɨla hɨsɨŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","La sabaŋ sipsipɨ husivɨ ifɨhɨmɨbanaŋ agadɨ apagaŋ henaŋ hɨlɨcɨ agadɨ iasaŋ sagalɨ iguben aba hɨjɨŋalaŋala iguha uami. Lavɨla sɨhɨm agadɨ nɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Alon dɨ lɨbɨmɨŋɨben aba sabaŋ sipsipɨ apagaŋ agadɨ viavɨla uami. Ha Asɨ dɨ nukeŋ aba hɨjɨŋalaŋala iasaŋ nukeŋ iguha uami. Lavɨla nudɨ ninadinu agɨladɨ lɨbɨmɨŋɨben aba lagiŋ agadɨ viavɨla uami. Ha Asɨ dɨ nukeŋ aba mɨŋaiahavɨla iasaŋ nukeŋ iguha uami. ");
INSERT INTO ena_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Mufɨli mufɨli Isɨlaelɨ hɨdɨlɨ agɨlaŋ hɨji humɨgaŋ pam hɨnihɨni saŋ sagalɨ igubalu aba sɨhɨm apagaŋ agadɨdaŋ lagiŋ sɨmi kɨlikɨli hɨsɨŋ agadɨdaŋ vivi iasaŋ sagalɨ iguavɨdaci viaŋ cɨhu sagalɨ igu igu hɨsɨŋ hulaŋ agɨlasaŋ igudalɨŋ navɨbali uami. Isɨlaelɨ hɨdɨlɨ agɨlaŋ akuaba akuaba huaci huaci hameŋ agɨladɨ iasaŋ iguavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Mufɨli Alon hɨmɨci nudɨ sagalɨ igu igu hɨsɨŋ hadi hɨlahɨla akuaba akuaba agɨladɨ nudɨ ninaŋ mu nudɨ uvɨsɨjiŋ vibali agasaŋ iguavɨm uami. Alon dɨ ajihalinu iamɨlɨhalinu agɨlaŋ avi sagalɨ igu igu hɨsɨŋ hulaŋ hɨnihɨni sagalɨ igu igu hɨsɨŋ hadi hɨlahɨla agɨladɨ lamavɨbali uami. Lamavɨdaci iasaŋ lɨbɨmɨŋɨben aba cihu savu me agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavɨbali agɨladɨ vivi nulɨdɨ hali sabɨ hɨvɨ mɨŋamɨjidaci mɨgam uami. ");
INSERT INTO ena_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Alon dɨ ninadinu ajihalinu iamɨlɨhalinu agɨladɨ hulaŋ mu Alon dɨ uvɨsɨjiŋ viavɨla iasaŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ hɨniben aba Alon dɨ hadi hɨlahɨla agɨladɨ lama hɨnidaci uaiaŋ human limu fɨhala ubali uami. Uaiaŋ pabiŋ pabiŋ hɨvɨ viaŋ igasulɨdalɨŋ iadɨ havɨlɨ uleŋ muji uaiaŋ pabiŋ pabiŋ sagalɨ igu igu hɨsɨŋ uvɨ heŋ sibɨla vibali uami. ");
INSERT INTO ena_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Alon dɨdaŋ nudɨ ninadinu agɨladɨdaŋ lɨbɨmɨŋɨben aba sɨhɨm hɨlɨcɨ iasaŋ sagalɨ igubanaŋ agadɨ viavɨla havɨlɨ ulaŋ haiabɨla agadɨ lua muji heŋ sɨji hɨvɨ hugɨlɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Hugɨlɨnaŋ iasaŋ sagalɨ igu igu hɨsɨŋ hulaŋ agɨlaŋ viavɨla maci hɨhɨle cinacina hɨvɨ hɨniavɨbali agɨladɨdaŋ iadɨ havɨlɨ ulaŋ hali hɨbɨ haiabɨla heŋ navɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Viaŋ nulɨdɨ hugɨ hivɨlɨŋ iasaŋ sagalɨ igu igu hɨsɨŋ hulaŋ hɨnihɨni saŋ sagalɨ iguavɨbali agadɨ nɨbɨlaŋ nukeŋ navɨm uami. Iasaŋ sagalɨ igu igu hɨsɨŋ hulaŋ agɨlaŋ laci navɨm uami. Hulaŋ iamɨgali havɨ havɨ agɨlaŋ navɨmɨdɨ uami. Nɨbu hɨbuŋ daŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Sɨhɨm hɨlɨcɨ daŋ maci daŋ hɨniavɨci fɨli mɨŋalahɨci cimɨdaŋ hɨvɨ navɨmɨdɨ uami. Ha hɨbuŋ uami. Avɨŋ hɨvɨ laci hɨlavɨci sɨkasɨkan lɨhua fɨhalavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Viaŋ Alon dɨdaŋ ninadinu agɨladɨdaŋ iasaŋ sagalɨ igu igu hɨsɨŋ hulaŋ hɨniavɨbali aba lɨbɨmɨŋamɨŋa saŋ nadɨ abin uami. Sibɨla hameŋ agadɨ vidanaŋ uaiaŋ human limu fɨhala ubali uami. ");
INSERT INTO ena_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Uaiaŋ pabiŋ pabiŋ hɨvɨ hugɨ hivahiva saŋ sabaŋ bulɨmakau pabiŋ lɨdɨŋ pabiŋ lɨdɨŋ sagalɨ iguha uami. Lɨdanaŋ sagalɨ agɨlaŋ lɨhavɨdaci viaŋ igɨdalɨŋ sagalɨ hɨlahɨla hɨsɨŋ vadɨm agaŋ huaci laci hɨnibali uami. La vadɨm iadɨ nukeŋ sɨbaŋ hɨnihɨni saŋ cihu savu me agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavɨbali agadɨ via vadɨm sabɨ heŋ mɨŋamɨjiha uami. ");
INSERT INTO ena_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Hameŋ lɨdɨŋ hɨnidanaŋ uaiaŋ human limu fɨhala ubali uami. Lɨci vadɨm agaŋ iadɨ sɨbaŋ hɨnibali uami. Hulaŋ iamɨgali vadɨm agadɨ mɨŋaigavɨla ha nɨbɨlaŋ iadɨ sɨbaŋ hɨniavɨbali uami. Sɨhɨm sabaŋ akuaba akuaba agɨlaŋ vadɨm agadɨ lubigavɨla uami. Ha sɨhɨm sabaŋ akuaba akuaba agɨlaŋ avi iadɨ sɨbaŋ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","La Asɨ Iaue agaŋ cɨhu abami. Sabaŋ sipsipɨ ninaŋ ahica numɨgagalinɨlu huhɨlavɨci hualɨ pabiŋ ci ualɨ agɨladɨ vivi uaiaŋ pabiŋ pabiŋ hɨvɨ sagalɨ iguavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Sabaŋ sipsipɨ ninaŋ mu agadɨ cimɨdaŋ hɨvɨ sagalɨ iguavɨm uami. Mu agadɨ hɨfɨlɨdaŋ sɨbaŋ hɨvɨ iguavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Halɨha cahu uitɨ maci huaci sɨbaŋ agadɨ vihavɨm uami. Nudɨ vɨhɨlɨ ha 1 kilogɨlam agadɨ vihavɨm uami. Viavɨla kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ 1 lita agadɨdaŋ eŋalavɨm uami. Lavɨla sabaŋ sipsipɨ cimɨdaŋ ifɨhɨmavɨbali agadɨdaŋ sagalɨ iguavɨm uami. Lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ 1 lita agadɨ avi sagalɨ igu igu saŋ mɨŋamɨjiavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","La hɨfɨlɨdaŋ hɨvɨ sabaŋ sipsipɨ ninaŋ mu agadɨ avi hameŋ laci ala iguavɨm uami. Halɨha cahu uitɨ maci huaci sɨbaŋ agadɨ vihavɨm uami. Nudɨ vɨhɨlɨ ha 1 kilogɨlam agadɨ vihavɨm uami. Viavɨla kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ 1 lita agadɨdaŋ eŋalavɨm uami. Lavɨla sabaŋ sipsipɨ hɨfɨlɨdaŋ hɨvɨ ifɨhɨmavɨbali agadɨdaŋ sagalɨ iguavɨm uami. Lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ 1 lita agadɨ avi sagalɨ igu igu saŋ mɨŋamɨjiavɨm uami. Ha sagalɨ avɨŋ hɨvɨ hɨlahɨla hɨsɨŋ uami. Sagalɨ avɨŋ hɨlavɨci hɨsi huaci iahɨci igavɨla hɨjɨŋalɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Iadɨ havɨlɨ ulaŋ hɨbɨ ivu ivu heŋ mufɨli mufɨli hameŋ laci hameŋ laci sagalɨ hɨlavɨdaci sɨkasɨkan lɨhua fɨhalavɨm uami. Lɨhavɨdaci viaŋ heŋ hɨnidalɨŋ Isɨlaelɨ hɨdɨlɨ agɨlaŋ veve haiabɨla mɨgudɨbavɨdaci viaŋ nama hula ciaŋ sulɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Lɨdalɨŋ iadɨ abɨlu hekɨlɨ vɨdɨvɨdɨŋ daŋ agaŋ havɨlɨ ulaŋ heŋ iahɨbali uami. Lɨci uvɨ agaŋ iadɨ nukeŋ uvɨ sɨbaŋ hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Havɨlɨ ulaŋ agadɨdaŋ sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨdaŋ lɨbɨmɨŋɨlɨŋ iadɨ nukeŋ sɨbaŋ hɨniavɨbali uami. Lɨci Alon dɨdaŋ nudɨ ninadinu agɨladɨdaŋ lɨbɨmɨŋɨlɨŋ iasaŋ sagalɨ igu igu hɨsɨŋ hulaŋ hɨnihɨni sibɨla vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Viaŋ Isɨlaelɨ hɨdɨlɨ namɨlaŋ hula hɨnihɨni naludɨ Asɨ hɨniben uami. ");
INSERT INTO ena_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Hɨnidalɨŋ namɨlaŋ iadɨ sɨhɨvia igɨbalaŋ uami. Viaŋ Asɨ Iaue uami. Viaŋ nukeŋ naludɨ Asɨ uami. Viaŋ namɨlaŋ hula hɨniben aba naludɨ ahɨliahudalɨŋ Isipɨ fɨli tɨbɨ agadɨ valavɨla vehalaŋ uami. Viaŋ Asɨ Iaue uami. Viaŋ nukeŋ naludɨ Asɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","La Asɨ agaŋ cɨhu abami. Kɨlɨ akasɨ mibɨŋ hegulaŋ me agɨladɨ viavɨla cihu savu me hɨsi huaci huaci daŋ agɨladɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Vihavɨci vadɨm agadɨ hutesɨ agaŋ 45 senɨtamita hɨnim uami. Nudɨ abɨŋ agaŋ avi 45 senɨtamita ala hɨnim uami. Ahica hɨlihɨli laci hɨniavɨm uami. Vadɨm agadɨ iahua hɨvɨ hɨnia fɨli mɨgamɨga agaŋ 90 senɨtamita hɨnim uami. Kɨlɨ akasɨ mibɨŋ hegulaŋ me agɨladɨ lɨhuavɨci kum limu ahica limu ahica daŋ hɨnim uami. Kum pabiŋ pabiŋ ikuŋ limu limu hɨvɨ hɨniavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Lɨhavɨci vadɨm agadɨ madɨŋ limu limu agɨladɨdaŋ nudɨ fɨdɨm limu limu agɨladɨdaŋ lɨba golɨ huaci sɨbaŋ hɨvɨ lamalama ifuhafiavɨm uami. Nudɨ sabɨ agadɨ lɨba golɨ huaci sɨbaŋ hɨvɨ lamalama ifuhafiavɨm uami. Kum limu ahica limu ahica ikuŋ limu limu hɨniavɨbali agɨladɨ avi lɨba golɨ huaci sɨbaŋ hɨvɨ lamalama ifuhafiavɨm uami. La lɨba golɨ cɨliŋ cɨki agadɨ hɨvɨ vadɨm mɨkamɨka agadɨ caba caba heŋ haŋala haŋala ifuhafiavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Vadɨm agadɨ havahava saŋ lɨba golɨ hakɨ ahica agɨladɨ viavɨla vadɨm agadɨ madɨŋ limu limu hɨvɨ lamavɨm uami. Lɨba golɨ cɨliŋ cɨki haŋala haŋala ifuhafiavɨbali agadɨ lɨhu heŋ ala lɨba golɨ hakɨ agɨladɨ lamavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Vadɨm agadɨ havahava saŋ kɨlɨ akasɨ sɨlɨvɨ ahica mibɨŋ hegulaŋ me agɨladɨ lɨhuavɨm uami. Lavɨla lɨba golɨ hɨvɨ ifuhafihafi uavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ifuhafihafi uavɨla vadɨm agadɨ via ivoua havɨlɨ hekɨlɨ lɨbalavɨci kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ hɨsihala hɨnibali agaŋ hɨnici vebali heŋ lamavɨm uami. Lɨhavɨci viaŋ kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ lamɨgaŋ sabɨ heŋ hɨnidalɨŋ nama veve viaŋ hula ciaŋ abɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Alon agaŋ cimɨdaŋ cimɨdaŋ hɨvɨ unɨ ifɨhɨmavɨla hihɨlɨben aba uu cihu savu me hɨsi huaci huaci daŋ agɨladɨ hɨlahɨla hɨsɨŋ vadɨm heŋ cihu savu me agɨladɨ hɨlɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","La hɨfɨlɨdaŋ sɨbaŋ avi unɨ lubilamalama saŋ uu hameŋ laci ala lɨbali uami. Viaŋ Asɨ Iaue uami. Cihu savu me hɨsi huaci huaci daŋ agɨladɨ iasaŋ mufɨli mufɨli hameŋ laci hɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Akuaba akuaba nameŋ agɨladɨ vadɨm heŋ hɨlavɨmɨdɨ uami. Sɨhɨm hɨlɨcɨ agɨladɨdaŋ halɨha cahu uitɨ agɨladɨdaŋ hɨlavɨmɨdɨ uami. Cihu savu me mu hɨdɨlɨ mu hɨdɨlɨ hɨsi huaci huaci iahaiaha hɨsɨŋ viaŋ valɨlan agɨladɨ hɨlavɨmɨdɨ uami. Lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨ avi sagalɨ igu igu saŋ cihu savu me hɨsi huaci huaci daŋ agɨladɨ hɨlahɨla hɨsɨŋ vadɨm sabɨ heŋ mɨŋamɨjiavɨmɨdɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Alon agaŋ hualɨ pabiŋ pabiŋ hɨvɨ pabiŋ tɨbɨ hugɨ hivahiva saŋ sabaŋ bulɨmakau muŋaŋ agadɨ ifɨhɨmam uami. Ifɨhɨmavɨla sabaŋ bulɨmakau mɨdɨ agadɨ viavɨla cihu savu me hɨsi huaci huaci daŋ agɨladɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ ikuŋ limu limu kum limu ahica limu ahica agɨladɨ hɨvɨ mɨŋepɨhalam uami. Lɨci vadɨm agaŋ huaci laci hɨnihɨni iadɨ nukeŋ sɨbaŋ hɨnibali uami. Alon agaŋ hualɨ mu hɨvɨ mu hɨvɨ hameŋ laci lɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","La Asɨ Iaue agaŋ Mosesɨ dɨ cɨhu ala abami. ");
INSERT INTO ena_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Isɨlaelɨ hɨdɨlɨ hulaŋ agɨladɨ laci lugɨla lugɨla nulɨdɨ ibi agɨladɨ manasɨŋ hɨvɨ lɨbɨha uami. Lɨbɨnaŋ nɨbɨlaŋ hɨtɨŋ hɨtɨŋ nulɨdɨ hugɨ hivahiva saŋ anɨm hɨlɨcɨ iguavɨm uami. Hameŋ lɨhavɨci nulɨdɨ ahɨliahulɨŋ huaci hɨniavɨbali uami. Hulaŋ hɨtɨŋ hɨtɨŋ lugɨlavɨbali agɨlaŋ anɨm hɨlɨcɨ iguavɨci ha hɨmuhɨmu hekɨlɨ agaŋ nulɨdɨ ma sɨbɨlɨ lamɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Hulaŋ sɨkasɨkan nulɨdɨ ibi vihavɨbali agɨlaŋ lɨba silɨva hɨlɨcɨ hɨlɨcɨ agɨladɨ lugɨla lugɨla iguavɨm uami. Iadɨ havɨlɨ ulaŋ caba heŋ akuaba akuaba lamalama vɨhɨlɨ sɨhɨvia sɨbaŋ iga iga lugɨlavɨbali hameŋ ala lamalama vɨhɨlɨ agɨladɨ iga iga lugɨlavɨm uami. Lɨba silɨva hɨlɨcɨ hɨlɨcɨ agɨladɨ lugɨlavɨci ua anɨm hɨlɨcɨ gela 20 iahɨci ha anɨm hɨlɨcɨ sekelɨ 1 uami. Nudɨ labɨlavɨla anɨm hɨlɨcɨ gela 10 agɨladɨ iasaŋ sagalɨ iguavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Hulaŋ agɨladɨ hualɨ lugɨlavɨci ua human limu limu fɨhala hɨcɨ limu limu fɨhala iahalɨ agɨladɨ hɨvɨ hɨdɨlɨ maha ibi sɨkasɨkan vihavɨm uami. Vivi via ua hulaŋ hadi hadi agɨladɨ avi sɨkasɨkan vihavɨm uami. Lɨhavɨci nɨbɨlaŋ ala iasaŋ anɨm hɨlɨcɨ iguavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Hulaŋ akuaba akuaba akape daŋ agɨlaŋ hula hulaŋ akuaba akuaba saŋ tɨbɨ mɨgavɨlalɨ agɨlaŋ hula nulɨdɨ hugɨ hivahiva saŋ lɨba silɨva hɨlɨcɨ hɨlɨcɨ agɨladɨ hɨlihɨli laci iguavɨm uami. Hameŋ lavɨla ha huaci hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Iadɨ havɨlɨ ulaŋ agadɨ sibɨla vivi saŋ anɨm hɨlɨcɨ hameŋ iguavɨm uami. Viaŋ nulɨdɨ hugɨ hivahiva hɨsɨŋ anɨm hɨlɨcɨ agɨladɨ igavɨla Isɨlaelɨ hɨdɨlɨ hulaŋ agɨlasaŋ igahɨlavɨla nulɨdɨ ahɨliahulɨŋ huaci laci hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Lavɨla Asɨ Iaue agaŋ Mosesɨ dɨ cɨhu ala abami. ");
INSERT INTO ena_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Lɨba bɨlasɨ agadɨ viavɨla hɨcɨ human husahusa hɨsɨŋ hunaŋ mɨsɨn hekɨlɨ agadɨdaŋ nudɨ lamɨci hɨnihɨni hɨsɨŋ vadɨm agadɨdaŋ vihavɨm uami. Lavɨla havɨlɨ ulaŋ agadɨ hɨbɨ ivu ivu agaŋ hɨnici veci sagalɨ hɨlahɨla hɨsɨŋ vadɨm agaŋ hɨnici ubali agadɨ alɨhaŋ heŋ fɨli hɨvɨ lamavɨm uami. La hɨcɨ human husahusa hɨsɨŋ hunaŋ mɨsɨn hekɨlɨ agadɨ hɨvɨ avɨli mɨŋamɨjiavɨci mɨgum uami. ");
INSERT INTO ena_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Lɨhavɨci Alon agaŋ nudɨ ninadinu hula avɨli hunaŋ mɨsɨn hekɨlɨ hɨvɨ hɨnibali agadɨ hɨvɨ hɨcɨ human husavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Sagalɨ hɨlahɨla hɨsɨŋ vadɨm heŋ sagalɨ hɨlɨbalu aba hɨcɨ human husavɨbali uami. Iadɨ havɨlɨ ulaŋ hɨvɨ ivoubalu aba avi hɨcɨ human husavɨbali uami. Hameŋ lɨhavɨci viaŋ nulɨdɨ ma ifɨhɨmɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Mufɨli mufɨli hameŋ laci lavɨla ha nɨbɨlaŋ ma hɨmavɨbali uami. Alon agaŋ nudɨ ninadinu hula ciaŋ vɨdɨvɨdɨŋ agadɨ lubiahɨlavɨbali uami. Lɨhavɨci iamɨlɨhalinɨlu mufɨli mufɨli iahavɨbali agɨlaŋ avi ciaŋ vɨdɨvɨdɨŋ agadɨ hameŋ laci ala lubiahɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","La Asɨ Iaue agaŋ Mosesɨ dɨ cɨhu ala abami. ");
INSERT INTO ena_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Akuaba akuaba hɨsi huaci huaci daŋ nameŋ agɨladɨ vihavɨm uami. Cihu savu me mu agadɨ ibi mea aba abavɨlalɨ uami. Nudɨ vihavɨci vɨhɨlɨ 6 kilogɨlam hɨnilalɨ agadɨ vihavɨm uami. Cihu savu me sinamon hɨsi huaci daŋ agɨladɨ vihavɨci vɨhɨlɨ 3 kilogɨlam hɨnilalɨ agadɨ vihavɨm uami. Sɨhuaniam hɨsi me agadɨ vihavɨci vɨhɨlɨ 3 kilogɨlam hɨnilalɨ agadɨ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Cihu savu me hɨhɨle kɨlɨ kasia sɨgɨtɨ hɨvɨ vihavɨci vɨhɨlɨ 6 kilogɨlam hɨnilalɨ agadɨ vihavɨm uami. Iadɨ havɨlɨ ulaŋ caba heŋ akuaba akuaba lamalama vɨhɨlɨ sɨhɨvia sɨbaŋ iga iga lugɨlavɨbali hameŋ ala lamalama vɨhɨlɨ iga iga lugɨlavɨm uami. Kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ 4 lita agadɨ viavɨla akuaba akuaba agɨladɨ sabɨ hɨvɨ mɨŋamɨjiavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Cihu savu me hɨhɨle agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavɨla akuaba akuaba iasaŋ lɨbɨmɨŋɨben aba nulɨdɨ sabɨ hɨvɨ mɨŋamɨjimɨji hɨsɨŋ agɨladɨ eŋalavɨm uami. Akuaba akuaba hɨsi huaci huaci daŋ eŋala iga iga hɨsɨŋ hulaŋ agɨlaŋ eŋalavɨlalɨ me eŋalavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Lɨhavɨci nudɨ viavɨla havɨlɨ ulaŋ sabɨ heŋ sevɨha uami. Kɨlɨ cɨkaŋ hɨbɨn hɨbɨn sabɨ heŋ mɨŋamɨjiha uami. ");
INSERT INTO ena_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","Maci sakɨvakɨva lamalama hɨsɨŋ vadɨm agadɨ sabɨ hɨvɨ mɨŋamɨjiha uami. Hunaŋ akuaba akuaba vadɨm sabɨ hɨvɨ hɨniavɨbali agɨladɨ sabɨ hɨvɨ mɨŋamɨjiha uami. Unɨ lamalama hɨsɨŋ hɨlɨ agadɨ sabɨ hɨvɨ mɨŋamɨjiha uami. Nudɨ unɨ agɨladɨ sabɨ hɨvɨ mɨŋamɨjiha uami. Nudɨ hunaŋ akuaba akuaba agɨladɨ sabɨ hɨvɨ mɨŋamɨjiha uami. Cihu savu me hɨsi huaci huaci daŋ agɨladɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ sabɨ hɨvɨ mɨŋamɨjiha uami. ");
INSERT INTO ena_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ sabɨ hɨvɨ mɨŋamɨjiha uami. Nudɨ hunaŋ akuaba akuaba sibɨla vivi hɨsɨŋ agɨladɨ hɨvɨ mɨŋamɨjiha uami. Hɨcɨ human husahusa hɨsɨŋ hunaŋ mɨsɨn hekɨlɨ agadɨ hɨvɨ mɨŋamɨjiha uami. Nudɨ lamɨci hɨnihɨni hɨsɨŋ vadɨm agadɨ sabɨ hɨvɨ avi mɨŋamɨjiha uami. ");
INSERT INTO ena_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Lavɨla lɨbɨmɨŋɨnaŋ akuaba akuaba agɨlaŋ iadɨ nukeŋ sɨbaŋ laci hɨniavɨbali uami. Hulaŋ iamɨgali akuaba akuaba agɨladɨ mɨŋaigavɨla ha nɨbɨlaŋ iadɨ sɨbaŋ hɨniavɨbali uami. Sɨhɨm sabaŋ akuaba akuaba agɨlaŋ akuaba akuaba agɨladɨ lubigavɨla uami. Ha sɨhɨm sabaŋ akuaba akuaba agɨlaŋ avi iadɨ sɨbaŋ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Cihu savu me agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavɨla akuaba akuaba iasaŋ lɨbɨmɨŋɨben aba nulɨdɨ sabɨ hɨvɨ mɨŋamɨjimɨji hɨsɨŋ agadɨ viavɨla Alon dɨ sabɨ hɨvɨ mɨŋamɨjiha uami. La nudɨ ninadinu agɨladɨ sabɨ hɨvɨ avi mɨŋamɨjiha uami. Lavɨla nulɨdɨ lɨbɨmɨŋɨnaŋ iasaŋ sagalɨ igu igu hɨsɨŋ hulaŋ hɨnihɨni sibɨla vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Lavɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨha uami. Isɨlaelɨ hɨdɨlɨ naludɨ ninadinalu ajihalinalu agɨlaŋ mufɨli mufɨli akuaba akuaba Asɨ saŋ lɨbɨmɨŋɨben aba hameŋ laci ala lɨhavɨm aba abɨha uami. Cihu savu me hɨhɨle agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavɨbali hameŋ ala eŋala eŋala mɨŋamɨjimɨji lɨbɨmɨŋavɨm aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Hulaŋ havɨ havɨ agɨladɨ hɨvɨ mɨŋamɨjimɨlaŋ aba abɨha uami. Cihu savu me mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavɨbali hameŋ agadɨ nalusaŋ nukeŋ vimɨlaŋ aba abɨha uami. Ha Asɨ dɨ sadaŋ naludɨ abamɨgɨli aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Hulaŋ mu cihu savu me mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavɨbali hameŋ agadɨ havɨ havɨ eŋalavɨla aba abɨha uami. Ha nɨbu Asɨ dɨ hulaŋ iamɨgali agɨlaŋ hula ma hɨnibali aba abɨha uami. Hulaŋ havɨ havɨ agɨladɨ hɨvɨ mɨŋamɨjiavɨla ha nɨbu Asɨ dɨ hulaŋ iamɨgali agɨlaŋ hula ma hɨnibali aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","La Asɨ Iaue agaŋ Mosesɨ dɨ cɨhu ala abami. Akuaba akuaba hɨsi huaci huaci daŋ agɨladɨ hɨvɨ cihu savu me agɨladɨ vihavɨm uami. Cihu savu me sɨkasɨkan agɨladɨ vɨhɨlɨ hɨlihɨli hameŋ laci vihavɨm uami. Cihu savu me mu nudɨ ibi mea aba abavɨlalɨ agadɨ vihavɨm uami. Avɨli hekɨlɨ hɨsɨŋ cihu tɨbaŋ me agadɨ hɨvɨ vihavɨlalɨ agadɨ vihavɨm uami. Isabɨlaŋ mu galɨbanum agadɨ mɨlɨm hɨgɨliŋ agadɨ vihavɨm uami. La cihu savu me mu kɨlɨ balɨsam mɨlɨm hɨvɨ vihavɨlalɨ agɨladɨ avi vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Akuaba akuaba agɨladɨ viavɨla cihu savu me hɨsi huaci huaci iahaiaha saŋ eŋala iga iga hɨsɨŋ agɨlaŋ me sɨhɨvia sɨbaŋ eŋalavɨm uami. La cihu savu me agaŋ huaci hɨnihɨni saŋ lulɨm lamavɨci iadɨ nukeŋ sɨbaŋ hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Akuaba akuaba agɨladɨ sɨhɨvia sɨbaŋ ifɨcabɨlavɨci cihu savu me sɨbaŋ hɨnim uami. Lɨci viaŋ igasulɨdalɨŋ havɨlɨ uleŋ muji via ivoua kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ pɨŋ lamavɨm uami. Lɨhavɨci viaŋ heŋ hɨnihɨni nama hula ciaŋ sulɨben uami. Cihu savu me hɨsi huaci huaci iahaiaha hɨsɨŋ ha iadɨ sɨbaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Iadɨ cihu savu me agadɨ nulɨsaŋ nukeŋ vihavɨmɨdɨ uami. Viaŋ Asɨ Iaue uami. Cihu savu me ha iadɨ nukeŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Hulaŋ mu cihu savu me hameŋ agadɨ hɨvɨ hɨsi huaci huaci nɨbu nukeŋ iga iga saŋ viavɨla uami. Ha nɨbu iadɨ hulaŋ iamɨgali agɨlaŋ hula ma hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","La Asɨ Iaue agaŋ Mosesɨ dɨ abami. ");
INSERT INTO ena_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Ci igɨnaŋ uami. Viaŋ Besalelɨ dɨ ci lɨbɨmɨŋacin uami. Nɨbu Juda hɨdɨlɨ uami. Nudɨ iaganu Oli uami. Nudɨ iauacanu Holɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Iadɨ Amɨŋ agaŋ nɨbu hula ci hɨnidi uami. Hɨnihɨni nusaŋ hɨji igudaci hɨji hutesɨ vivi hɨji huaci daŋ hɨnidi uami. Nɨbu human sihɨ vivi hɨsɨŋ hɨji daŋ hɨnidi uami. Hɨnihɨni sibɨla mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ vibali uami. ");
INSERT INTO ena_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Lɨba golɨ hɨvɨ lɨba silɨva hɨvɨ lɨba bɨlasɨ hɨvɨ akuaba akuaba huaci huaci agɨladɨ vivi saŋ hɨji ci iguacin uami. ");
INSERT INTO ena_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Lɨba hɨlɨcɨ huaci huaci sɨbaŋ agɨladɨ hɨvɨ ihatɨbutɨbu sihɨ lamalama lɨba golɨ hajɨŋ cɨki cɨki havaŋ avɨli veve agadɨ ulaŋ tulɨ me agɨladɨ hɨvɨ lamɨci mɨgumɨgu saŋ hɨji ci iguacin uami. Kɨlɨ cɨkaŋ hɨvɨ kɨlɨ tɨbɨ hɨvɨ ihatɨbutɨbu sihɨ sihɨ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ lamalama saŋ hɨji ci iguacin uami. Nɨbu sibɨla hameŋ agɨladɨ vivi havɨlɨ ulaŋ agadɨ hajɨŋ lamɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Hulaŋ mu Oholiapɨ dɨ avi ci lɨbɨmɨŋacin uami. Nɨbu Dan hɨdɨlɨ uami. Nudɨ iaganu Ahisamakɨ uami. Nɨbu Besalelɨ hula sibɨla vihavɨbali uami. Hulaŋ hɨji daŋ hɨji daŋ agɨlasaŋ avi hɨji hutesɨ ci iguacin uami. Nɨbɨlaŋ ala akuaba akuaba vivi saŋ abin agɨladɨ vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Iadɨ havɨlɨ ulaŋ sibɨla agadɨ vihavɨbali uami. Kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨdaŋ nudɨ lamɨgaŋ agadɨdaŋ vihavɨbali uami. Havɨlɨ ulaŋ agadɨ akuaba akuaba agɨladɨ vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Maci sakɨvakɨva lamalama hɨsɨŋ vadɨm agadɨdaŋ nudɨ hunaŋ akuaba akuaba agɨladɨdaŋ vihavɨbali uami. Unɨ lamalama hɨsɨŋ hɨlɨ agadɨ vihavɨbali uami. Unɨ agɨladɨdaŋ nudɨ hunaŋ akuaba akuaba agɨladɨdaŋ vihavɨbali uami. Lɨba golɨ huaci sɨbaŋ agadɨ hɨvɨ unɨ lamalama hɨsɨŋ hɨlɨ agadɨ vihavɨbali uami. Cihu savu me hɨsi huaci huaci daŋ agɨladɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨdaŋ nudɨ hunaŋ akuaba akuaba agɨladɨdaŋ vihavɨbali uami. Hɨcɨ human husahusa hɨsɨŋ hunaŋ mɨsɨn hekɨlɨ agadɨdaŋ nudɨ lamɨci hɨnihɨni hɨsɨŋ vadɨm agadɨdaŋ vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Iasaŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ agadɨ hadi hɨlahɨla akuaba akuaba agɨladɨdaŋ hadi hɨlahɨla huaci huaci hɨhɨle agɨladɨdaŋ hɨcavɨbali uami. Hɨcavɨci Alon agaŋ ninadinu agɨlaŋ hula iasaŋ sagalɨ igu igu hɨsɨŋ hulaŋ hɨnihɨni hadi hɨlahɨla agɨladɨ lamalama sibɨla vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Cihu savu me agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavɨla akuaba akuaba Asɨ saŋ lɨbɨmɨŋɨben aba nulɨdɨ sabɨ hɨvɨ mɨŋamɨjimɨji hɨsɨŋ agɨladɨ vihavɨbali uami. Cihu savu me hɨsi huaci huaci iahaiaha hɨsɨŋ agɨladɨ vihavɨbali uami. Viavɨla uaiaŋ pabiŋ pabiŋ sagalɨ igu igu hɨsɨŋ uvɨ havɨlɨ uleŋ muji heŋ ivo ivo sibɨla vihavɨbali uami. Akuaba akuaba nadɨ abin agɨladɨ hameŋ laci ala vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","La Asɨ Iaue agaŋ Mosesɨ dɨ abami. ");
INSERT INTO ena_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨha uami. Asɨ Iaue nameŋ abi aba abɨha uami. Alusɨsɨ mɨhiŋ hɨvɨ alusɨhalaŋ aba abi aba abɨha uami. Alusɨsɨ mɨhiŋ heŋ iasaŋ hɨji lamɨhalaŋ aba abi aba abɨha uami. Viaŋ naludɨ lɨbɨmɨŋɨlɨŋ iadɨ hulaŋ iamɨgali hɨnilalaŋ agasaŋ avi hɨji lamɨhalaŋ aba abi aba abɨha uami. Hameŋ agɨlasaŋ igahɨlahɨla mufɨli mufɨli avi alusɨsɨ mɨhiŋ hɨvɨ alusɨhalaŋ aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Alusɨsɨ mɨhiŋ ha iadɨ mɨhiŋ aba abi aba abɨha uami. Hameŋ sadaŋ mɨhiŋ agadɨ hɨvɨ alusɨhalaŋ aba abi aba abɨha uami. Hulaŋ mu iadɨ ciaŋ vɨdɨvɨdɨŋ agadɨ lulavɨla alusɨsɨ mɨhiŋ hɨvɨ akuaba akuaba sibɨla viavɨla ha nɨbu iadɨ hulaŋ iamɨgali agɨlaŋ hula ma hɨnibali aba abi aba abɨha uami. Nudɨ ifɨhɨmɨhalaŋ aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Naludɨ sibɨla akuaba akuaba vivi hɨsɨŋ uaiaŋ ha human limu fɨhala human limu pabiŋ cɨjɨŋ laci aba abi aba abɨha uami. La uaiaŋ mu hɨvɨ ha alusɨhalaŋ aba abi aba abɨha uami. Ha iadɨ mɨhiŋ hekɨlɨ aba abi aba abɨha uami. Hulaŋ iamɨgali limu hɨhɨle alusɨsɨ mɨhiŋ agadɨ hɨvɨ sibɨla vihavɨci ha nulɨdɨ ifɨhɨmɨhalaŋ aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Isɨlaelɨ hɨdɨlɨ namɨlaŋ mɨhiŋ heŋ alusɨhalaŋ aba abi aba abɨha uami. Naludɨ ninanadinalu ajihalinalu iamɨlɨhalinalu mufɨli mufɨli iahavɨbali agɨlaŋ avi hameŋ laci ala lɨhavɨbali aba abi aba abɨha uami. Alusɨsɨ mɨhiŋ agasaŋ ala igahɨlavɨla ciaŋ mɨguavɨla naludɨ abin aba abi aba abɨha uami. Ciaŋ mɨguavɨla abin agaŋ hameŋ laci hameŋ laci hɨnibali aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Viaŋ Asɨ Iaue aba abi aba abɨha uami. Viaŋ uaiaŋ human limu fɨhala human limu pabiŋ cɨjɨŋ agɨladɨ hɨvɨ fɨli uaiaŋ susu akuaba akuaba agɨladɨ lamamin aba abi aba abɨha uami. La uaiaŋ mu hɨvɨ viaŋ sibɨla valavɨla havɨ alusamin aba abi aba abɨha uami. Hameŋ sadaŋ mufɨli mufɨli namɨlaŋ avi alusɨsɨ mɨhiŋ hɨvɨ nusaŋ ala hɨji lamalama alusɨhalaŋ aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Asɨ agaŋ Sainai halu heŋ Mosesɨ dɨ abɨci ci lɨci lɨba cɨkaŋ ahica agɨladɨ hɨvɨ ciaŋ vɨdɨvɨdɨŋ nudɨ nukeŋ human cɨjɨŋ hɨvɨ ihatɨbutɨbu lɨbavɨla Mosesɨ saŋ igumi. ");
INSERT INTO ena_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mosesɨ agaŋ halu iahua hɨnidaci hulaŋ iamɨgali agɨlaŋ nusaŋ migɨla migɨla hɨniavɨdaci uaiaŋ akape umi. Lɨci hulaŋ iamɨgali agɨlaŋ Alon dɨ pɨŋ ua mɨgudɨbavɨla nudɨ abavɨmi. Mosesɨ akuaba lɨdɨŋ hutesɨ hɨnidi agadɨ alaŋ hɨdɨlɨ ma igadalu uavɨmi. Alaŋ Isipɨ fɨli tɨbɨ hɨnidamɨli nɨbu ala aludɨ likɨla neŋ vavelɨ uavɨmi. Nama alusaŋ akuaba akuaba agɨladɨ lɨnaŋ iaha aludɨ asɨ me hɨnihɨni alusaŋ hɨbɨ abalamavɨdaci nulɨdɨ sɨvɨ ubalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Lɨhavɨci Alon agaŋ nulɨdɨ abami. Naludɨ abinadinalu agɨladɨdaŋ ninanadinalu agɨladɨdaŋ abɨlaŋ hɨji asɨŋ hɨsɨŋ hajɨŋ lɨba golɨ hɨvɨ vihavalɨ agɨladɨ mɨŋa ulɨhalavɨci mɨgavɨci iasaŋ vavehalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Lɨci hɨji asɨŋ hɨsɨŋ hajɨŋ lɨba golɨ hɨvɨ vihavɨmi agɨladɨ mɨŋa ulɨhalavɨci mɨgavɨci vave Alon saŋ iguavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Iguavɨci viavɨla avɨŋ hɨvɨ hɨlɨci hɨji asɨŋ hɨsɨŋ hajɨŋ agɨlaŋ lɨhua miŋɨlavɨla avɨli avɨli lɨhavɨmi. Lɨhavɨci haca sabaŋ bulɨmakau ninaŋ hadalɨ me mavavɨmi agadɨ hɨvɨ mɨŋamɨjici mɨgumi. Mɨŋamɨjici mɨgua vɨdɨvɨdɨŋ lavɨla sabaŋ bulɨmakau ninaŋ me sɨbaŋ hɨnimi. Lɨci puia viavɨla sɨhɨvia sɨbaŋ hihɨlami. Hihɨla lamɨci hulaŋ iamɨgali agɨlaŋ igavɨla abavɨmi. Nagɨlaŋ Isɨlaelɨ hɨdɨlɨ aludɨ asɨ uavɨmi. Alaŋ Isipɨ fɨli tɨbɨ hɨnidamɨli nɨbɨlaŋ ala aludɨ likɨla vavehavalɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Hameŋ lɨhavɨdaci Alon agaŋ sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ ibilami. Sabaŋ bulɨmakau ninaŋ me lamami agaŋ mugaŋ lamɨgaŋ lamavɨla hɨnimi agadɨ mikɨ heŋ ibilami. La abami. Alaŋ amɨli Asɨ Iaue dɨ ibi mɨŋaiahaiaha saŋ sɨmɨŋ hekɨlɨ hɨlanɨbalu uami. ");
INSERT INTO ena_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","La hɨniavɨci mɨŋalahɨci cimɨdaŋ sɨbaŋ hulaŋ iamɨgali agɨlaŋ iahavɨla sɨhɨm sabaŋ akuaba akuaba agɨladɨ sagalɨ igu igu saŋ vavehavɨmi. Sagalɨ limu hɨhɨle agɨladɨ avɨŋ hɨvɨ hɨlavɨci lɨhucabɨlavɨmi. Sagalɨ limu hɨhɨle agɨladɨ asɨ hula hɨji humɨgaŋ pabiŋ laci hɨnibalu aba sagalɨ iguavɨmi. Iguavɨla cɨhu mɨgahɨnia sɨmɨŋ navɨmi. Avɨli vɨdɨvɨdɨŋ navɨmi. Nana iamɨgali mu mu agɨlaŋ hula lusɨŋ sɨbɨlɨ sɨbɨlɨ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Lɨhavɨdaci Asɨ Iaue agaŋ Mosesɨ dɨ abami. Nama lɨhalɨha sɨbaŋ mɨguvɨheha uami. Hulaŋ iamɨgali Isipɨ fɨli tɨbɨ hɨniavɨdaci nama nukeŋ likɨla vavehanaŋ agɨlaŋ lusɨŋ sɨbɨlɨ sɨbaŋ agɨladɨ vihavadi uami. ");
INSERT INTO ena_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Akuaba akuaba lɨlɨ saŋ ciaŋ vɨdɨvɨdɨŋ abacin agɨladɨ lɨhalɨha sɨbaŋ valavɨla lɨba golɨ agadɨ viavɨla nulɨdɨ nukeŋ human hɨvɨ vihavɨci sabaŋ bulɨmakau ninaŋ me hɨnidi uami. Hɨnidaci nudɨ ibi mɨŋaiahaiaha nusaŋ sagalɨ iguavadi uami. Amɨli nameŋ abavɨmalami uami. Nagɨlaŋ Isɨlaelɨ hɨdɨlɨ aludɨ asɨ aba abavɨmalami uami. Alaŋ Isipɨ fɨli tɨbɨ hɨnidamɨli nɨbɨlaŋ ala aludɨ likɨla vavehavalɨ aba abavɨmalami uami. ");
INSERT INTO ena_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","La Mosesɨ dɨ cɨhu ala abami. Viaŋ Asɨ Iaue uami. Viaŋ hulaŋ iamɨgali agɨladɨ igɨlan uami. Nɨbɨlaŋ ciaŋ lulalula hɨsɨŋ hulaŋ iamɨgali uami. ");
INSERT INTO ena_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Iadɨ valɨnaŋ viaŋ nulɨsaŋ igɨvɨ hɨniavɨla nulɨdɨ sɨkasɨkan sɨbɨlɨ lama fɨhalɨben uami. Lavɨla mufɨli nadɨ ninadina ajihalina iamɨlɨhalina agɨladɨ lɨlɨŋ iaha habɨla nulɨdɨ uvɨsɨjiŋ viavɨla hɨdɨlɨ hekɨlɨ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Lɨci Mosesɨ agaŋ Asɨ Iaue dɨ mavɨn ciaŋ ciaŋ abami. Asɨ Iaue uami. Hulaŋ iamɨgali agɨlaŋ Isipɨ fɨli tɨbɨ hɨniavɨdaci nama nukeŋ nadɨ vɨdɨvɨdɨŋ hekɨlɨ hɨvɨ likɨla vavehanaŋ uami. Nama akɨ saŋ igɨvɨ hɨnihɨni nadɨ hulaŋ iamɨgali agɨladɨ sɨbɨlɨ lamɨben aba lɨdanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Nama nulɨdɨ hameŋ lɨnaŋ Isipɨ fɨli tɨbɨ hɨsɨŋ hulaŋ iamɨgali agɨlaŋ nameŋ abavɨbali uami. Asɨ Iaue agaŋ nudɨ hulaŋ iamɨgali agɨladɨ sɨbɨlɨ lamɨben aba hɨji lamavɨla likɨla via ualɨ aba abavɨbali uami. Isipɨ fɨli tɨbɨ hɨniavɨdaci likɨlavɨla halu lɨguŋ heŋ via ua sɨbɨlɨ lamavɨla ifɨhɨmuhɨmu saŋ via ualɨ aba abavɨbali uami. Ifɨhɨmuhɨmu uci sɨvɨlavɨci fɨli nagaŋ Isɨlaelɨ hɨdɨlɨ apalɨ hɨnibali aba abavɨbali uami. Nama igɨvɨ agadɨ valavɨla hɨji huaci viha uami. Hameŋ lavɨla nadɨ hulaŋ iamɨgali agɨladɨ ma sɨbɨlɨ lamɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Nama nadɨ nukeŋ ibi hɨvɨ nameŋ abamanaŋ uami. Hɨvɨ hekɨlɨ aba abamanaŋ uami. Hameŋ abavɨla nadɨ sibɨla hɨsɨŋ hulaŋ Ebɨlam dɨdaŋ Aisakɨ dɨdaŋ abamanaŋ uami. Jekopɨ dɨ avi abamanaŋ uami. Viaŋ lɨlɨŋ naludɨ ajihalinalu iamɨlɨhalinalu agɨlaŋ iaha habɨlavɨla lidɨ me hɨniavɨbali aba abamanaŋ uami. Fɨli tɨbɨ igu igu saŋ abin agadɨ ajihalinalu iamɨlɨhalinalu saŋ igulɨŋ heŋ hameŋ laci hameŋ laci hɨniavɨbali aba abamanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Lɨci Asɨ Iaue agaŋ nulɨdɨ sɨbɨlɨ lamalama saŋ abami agadɨ ala hɨji huaci viavɨla valami. ");
INSERT INTO ena_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","16","Lavɨla ciaŋ vɨdɨvɨdɨŋ agɨladɨ ihatɨbutɨbu lɨbami. Lɨba cɨkaŋ ahica agɨladɨ hɨvɨ limu limu ihatɨbutɨbu lɨbami. Lɨci Mosesɨ agaŋ lɨba cɨkaŋ ahica ciaŋ vɨdɨvɨdɨŋ daŋ agɨladɨ via mɨgami. ");
INSERT INTO ena_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Josua avi Mosesɨ hula mɨgavɨmi. La Josua agaŋ hulaŋ iamɨgali agɨlaŋ ula ula aba aba hɨniavɨmi agadɨ igahɨlavɨla Mosesɨ dɨ abami. Viaŋ uu veve hɨnihɨni fipɨ heŋ sagaŋ lɨbalɨba ula ula aba aba hɨniavɨdaci igahɨladin uami. ");
INSERT INTO ena_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Lɨci Mosesɨ nudɨ abami. Hɨma uami. Viaŋ sagaŋ lɨbavɨla lɨvalavɨla ula ula livaliva me ma igahɨladin uami. Sagaŋ lɨbavɨci hulaŋ hɨhɨle nulɨdɨ lɨvalavɨci ilɨhavɨlalɨ me ma igahɨladin uami. Ha sɨhɨ iahaiaha sugɨ mɨtɨ pam igahɨladin uami. ");
INSERT INTO ena_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","La uu veve hɨnihɨni fipɨ mikɨ heŋ vevɨla igɨci sabaŋ bulɨmakau ninaŋ me lɨba golɨ hɨvɨ vihavɨmi agasaŋ igahɨlahɨla sɨhɨ iahaiaha sɨcisɨci hɨniavɨmi. Lɨhavɨdaci igavɨla nulɨsaŋ igɨvɨ hekɨlɨ hɨnimi. La lɨba cɨkaŋ ahica mɨŋalɨva mɨgami agɨladɨ halu lɨguŋ caba heŋ havalɨci mɨga ifɨcɨkɨcɨkɨ lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Lɨhavɨci Mosesɨ agaŋ sabaŋ bulɨmakau ninaŋ me lɨba golɨ hɨvɨ via lamavɨla aludɨ asɨ aba abavɨmi agadɨ viavɨla avɨŋ hɨvɨ lamɨci lɨhumi. Lɨhuci ifɨsavɨhalɨci cihu savu me sɨbaŋ hɨnimi. Lɨci cihu savu me agadɨ viavɨla avɨli hɨvɨ havalɨci mɨguavɨmi. Mosesɨ agaŋ hameŋ lavɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ vɨdɨvɨdɨŋ abɨci avɨli agadɨ navɨmi. ");
INSERT INTO ena_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Lɨhavɨci Alon dɨ abami. Hulaŋ iamɨgali agɨlaŋ nadɨ akɨ lɨhavɨci hameŋ lɨnaŋ lusɨŋ sɨbɨlɨ agadɨ vihavadi uami. ");
INSERT INTO ena_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Lɨci Alon agaŋ Mosesɨ dɨ abami. Iadɨ hekɨlɨ uami. Nama iasaŋ igɨvɨ hɨnimɨnaŋ uami. Nama hulaŋ iamɨgali nagɨladɨ ci igɨlanaŋ uami. Nɨbɨlaŋ lusɨŋ sɨbɨlɨ saŋ pam lɨhavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Hameŋ sadaŋ iadɨ nameŋ abavalɨ uami. Mosesɨ akuaba lɨdɨŋ hutesɨ hɨnidi agadɨ alaŋ hɨdɨlɨ ma igadalu aba abavalɨ uami. Alaŋ Isipɨ fɨli tɨbɨ hɨnidamɨli nɨbu ala aludɨ likɨla neŋ vavelɨ aba abavalɨ uami. Nama alusaŋ akuaba akuaba agɨladɨ lɨnaŋ iaha aludɨ asɨ me hɨnihɨni alusaŋ hɨbɨ abalamavɨdaci nulɨdɨ sɨvɨ ubalu aba abavalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Lɨhavɨci nulɨdɨ ciaŋ agadɨ igahɨlavɨla nameŋ abacin uami. Naludɨ hajɨŋ lɨba golɨ hɨvɨ vihavalɨ agɨladɨ mɨŋa ulɨhalɨlaŋ mɨgavɨci iasaŋ iguhalaŋ aba abacin uami. Abɨlɨŋ iguavɨci viavɨla avɨŋ hɨvɨ ahɨlɨlɨŋ mɨgua lɨhuavɨci sabaŋ bulɨmakau ninaŋ me agaŋ iahalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Lɨci Mosesɨ agaŋ hulaŋ iamɨgali agɨladɨ igavɨla hɨji nameŋ lamami. Alon nukeŋ lɨci hulaŋ iamɨgali nagɨlaŋ lusɨŋ sɨbɨlɨ vivi manɨgali dɨ lɨhu hɨvɨ ma hɨniavɨlalɨ uami. Lɨhavɨdaci hulaŋ iamɨgali nulɨdɨ nagɨli lamavɨlalɨ agɨlaŋ iga iga nulɨsaŋ lɨnilɨni abacuvacuva ciaŋ abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","La Mosesɨ agaŋ uavɨla uu veve hɨnihɨni fipɨ agadɨ lua hɨbɨ ivu ivu heŋ lagulama ulavɨla nameŋ abami. Aniaba hulaŋ Asɨ Iaue dɨ sɨvɨ ubavɨla ha iadɨ pɨŋ vehavɨm uami. Lɨci Livai hɨdɨlɨ agɨlaŋ nudɨ mikɨ pɨŋ vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Vehavɨci nulɨdɨ abami. Isɨlaelɨ hɨdɨlɨ aludɨ Asɨ Iaue agaŋ nameŋ abi uami. Naludɨ puia hutesɨ hutesɨ agɨladɨ likɨla via uavɨla uu veve hɨnihɨni fipɨ lua hɨbɨ mu neŋ ivouhalaŋ aba abi uami. Ivouavɨla puia hutesɨ hutesɨ hɨvɨ hulaŋ agɨladɨ ifɨhɨmuhɨmu uavɨla lua hɨbɨ mu limu hɨni heŋ limu cimɨla cɨhu ifɨhɨmuhɨmu vevɨla lua hɨbɨ neŋ ala ivavehalaŋ aba abi uami. La isagalinalu imahalinalu nagɨlihalinalu naludɨ havɨlɨ ulaŋ mikɨ hɨniavɨlalɨ agɨladɨ avi ifɨhɨmuhɨmu uhalaŋ aba abi uami. ");
INSERT INTO ena_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Lɨci Livai hɨdɨlɨ agɨlaŋ Mosesɨ abami hameŋ laci ala lɨhavɨmi. La uaiaŋ pabiŋ hɨvɨ laci hulaŋ 3,000 hameŋ agɨladɨ akua ifɨhɨmuhɨmu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Lɨhavɨci Mosesɨ Livai hɨdɨlɨ agɨladɨ abami. Namɨlaŋ hulaŋ agɨladɨ ifɨhɨmavɨla naludɨ isaimahalinalu agɨladɨdaŋ ninadinalu agɨladɨdaŋ avi ifɨhɨmɨlaŋ Asɨ Iaue igavɨla naludɨ huaci lamavɨla abi uami. Iadɨ sibɨla hɨsɨŋ hulaŋ aba abi uami. ");
INSERT INTO ena_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","La hɨnici mɨŋalahɨci Isɨlaelɨ hɨdɨlɨ agɨladɨ abami. Namɨlaŋ lusɨŋ sɨbɨlɨ hekɨlɨ ci vihalaŋ uami. Agadɨ ala iabi viaŋ cɨhu halu iahua Asɨ Iaue dɨ pɨŋ uavɨla naludɨ hugɨ agɨladɨ hivahiva saŋ nudɨ abaigɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Lavɨla Mosesɨ agaŋ halu cɨhu iahuavɨla Asɨ Iaue dɨ mavɨn ciaŋ ciaŋ abami. Hulaŋ iamɨgali agɨlaŋ lusɨŋ sɨbɨlɨ hekɨlɨ agadɨ vihavalɨ uami. Lɨba golɨ agadɨ vivi lamalama aludɨ asɨ aba abavalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Hameŋ abavɨla Asɨ Iaue dɨ abitɨhami. Nama hulaŋ iamɨgali agɨladɨ hugɨ agɨladɨ huaci hivɨvanaŋ uami. Valavɨla ha iadɨ ibi nadɨ manasɨŋ hɨvɨ hɨnidi agadɨ avi ifɨlahɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Lɨci Asɨ Iaue agaŋ Mosesɨ dɨ abami. Hɨma uami. Viaŋ hulaŋ iamɨgali lusɨŋ sɨbɨlɨ hɨsɨŋ agɨladɨ ibi iadɨ manasɨŋ hɨvɨ hɨniavɨlalɨ agɨladɨ pam ifɨlahɨlan uami. ");
INSERT INTO ena_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Alia uami. Iaha uavɨla hulaŋ iamɨgali agɨladɨ likɨla viavɨla fɨli tɨbɨ mu nadɨ abacin heŋ uhalaŋ uami. Ci igɨnaŋ uami. Iadɨ ciaŋ hali hɨsɨŋ agaŋ hali udaci ahuata hameŋ ubalaŋ uami. Agadɨ ala mu tɨbɨ viaŋ hulaŋ iamɨgali lusɨŋ sɨbɨlɨ vihavalɨ agasaŋ nulɨdɨ sɨbɨlɨ lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Hameŋ abavɨla mu tɨbɨ Asɨ Iaue agaŋ lɨci hɨmuhɨmu sɨbɨlɨ agaŋ iahami. Hulaŋ iamɨgali agɨlaŋ nukeŋ lusɨŋ sɨbɨlɨ saŋ igahɨlavɨla Alon dɨ abavɨci sabaŋ bulɨmakau ninaŋ me vimi agasaŋ lavɨla Asɨ Iaue nukeŋ nulɨdɨ sɨbɨlɨ lamami. ");
INSERT INTO ena_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","La Asɨ Iaue agaŋ Mosesɨ dɨ abami. Vaka sɨbaŋ Ebɨlam Aisakɨ Jekopɨ ani ani agɨlaŋ Kenan fɨli tɨbɨ heŋ hɨniavɨdaci viaŋ Ebɨlam dɨdaŋ Aisakɨ dɨdaŋ nameŋ abamin uami. Jekopɨ dɨ avi nameŋ abamin uami. Hɨvɨ hekɨlɨ aba abamin uami. Viaŋ fɨli tɨbɨ nagadɨ naludɨ iamɨlɨhalinalu agɨlasaŋ iguben aba abamin uami. Nama hulaŋ iamɨgali Isipɨ fɨli tɨbɨ hɨniavɨdaci likɨla vavehanaŋ agɨlaŋ hula uhalaŋ uami. Fɨli tɨbɨ naludɨ iamɨlɨhalinalu saŋ iguben aba abamin heŋ uhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Udalaŋ Kenan hɨdɨlɨ Amolɨ hɨdɨlɨ Hitɨ hɨdɨlɨ Pelesɨ hɨdɨlɨ Hivɨ hɨdɨlɨ Jebusɨ hɨdɨlɨ agɨladɨ lahudalɨŋ fɨli tɨbɨ agadɨ valavala uavɨbali uami. Uavɨdaci viaŋ iadɨ ciaŋ hali hɨsɨŋ agadɨ abɨlɨŋ nɨbu hali udaci namɨlaŋ nudɨ sɨvɨ ubalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Uavɨla nulɨdɨ fɨli tɨbɨ agadɨ vibalaŋ uami. Fɨli tɨbɨ heŋ sɨmɨŋ isabɨlaŋ hulidalaŋ huaci laci iahavɨbali uami. Agadɨ ala viaŋ namɨlaŋ hula ma sɨbaŋ uben uami. Namɨlaŋ ciaŋ lulalula hɨsɨŋ hulaŋ iamɨgali sadaŋ namɨlaŋ hula ma uben uami. Namɨlaŋ hula uavɨla naludɨ sɨbɨlɨ lamɨmagaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Lɨci Mosesɨ agaŋ Asɨ Iaue dɨ ciaŋ agadɨ sulɨci igahɨlavɨmi. Igahɨlavɨci sɨbɨlɨ lɨci mavɨn mɨŋamɨŋa ilɨha ilɨha hajɨŋ huaci huaci agɨladɨ ma lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Lɨhavɨci Asɨ Iaue agaŋ Mosesɨ dɨ abami. Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨha uami. Asɨ Iaue nameŋ abi aba abɨha uami. Namɨlaŋ ciaŋ lulalula hɨsɨŋ hulaŋ iamɨgali aba abi aba abɨha uami. Viaŋ namɨlaŋ hula umitavɨla avi ha naludɨ sɨbɨlɨ lamɨben aba abi aba abɨha uami. Ci igɨlaŋ aba abi aba abɨha uami. Naludɨ hadipɨlɨ hɨsɨŋ hajɨŋ akuaba akuaba agɨladɨ mɨŋa ulɨhalɨlaŋ mɨgavɨm aba abi aba abɨha uami. Lɨlaŋ viaŋ nukeŋ sɨhɨvia hɨji lamavɨla heŋ naludɨ akuaba akuaba lɨben aba abi aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Lɨci hulaŋ iamɨgali agɨlaŋ Sainai halu lɨguŋ heŋ hɨniavɨla hajɨŋ huaci huaci mɨŋa ulɨhalavɨci mɨgavɨmi agɨladɨ cɨhu cɨhu ma lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mosesɨ agaŋ akape tɨbɨ havɨlɨ ulaŋ mu agadɨ vivi uu hafiadami. Uu veve hɨnihɨni fipɨ agadɨ valavala umitamita ataŋ tagɨlaŋ daŋ heŋ hafiadami. La havɨlɨ ulaŋ agadɨ ibi lamavɨla abadami. Asɨ Iaue hula mɨgudɨba ciaŋ aba aba hɨsɨŋ havɨlɨ ulaŋ uadami. Hulaŋ iamɨgali agɨlaŋ Asɨ Iaue dɨ hɨji agadɨ igɨben aba nɨbɨlaŋ uu veve hɨnihɨni fipɨ agadɨ valavala havɨlɨ ulaŋ heŋ ala uavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Mosesɨ agaŋ havɨlɨ ulaŋ heŋ ivouben aba lɨdaci hulaŋ iamɨgali sɨkasɨkan iahaiaha nulɨdɨ nukeŋ havɨlɨ ulaŋ hɨbɨ ivu ivu hɨvɨ lagulama migɨla hɨnihɨni igasulavɨdaci Mosesɨ heŋ ivouadami. ");
INSERT INTO ena_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ivoudaci avɨli susu agaŋ mɨgamɨga havɨlɨ ulaŋ hɨbɨ ivu ivu agadɨ hɨsihalahala hɨniadami. Lɨdaci Asɨ Iaue hula Mosesɨ hula ciaŋ abavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Abavɨdaci hulaŋ iamɨgali agɨlaŋ iga iga nulɨdɨ nukeŋ havɨlɨ ulaŋ hɨbɨ ivu ivu heŋ Asɨ Iaue dɨ ibi mɨŋaiahɨben aba fɨli hɨvɨ mɨgamɨga lɨfɨlɨbavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Asɨ Iaue agaŋ Mosesɨ hula ciaŋ abadami ha hulaŋ nagɨlihalinu hula ciaŋ aba aba me abadami. Aba aba hɨniavɨdaci ci lɨdaci Mosesɨ havɨlɨ ulaŋ agadɨ valavala cɨhu uu veve hɨnihɨni fipɨ heŋ vehadami. Agadɨ ala Mosesɨ dɨ sibɨla hɨsɨŋ hulaŋ mɨnibɨlɨ Non dɨ ninaŋ Josua nɨbu havɨlɨ ulaŋ agadɨ ma valavala uadami. ");
INSERT INTO ena_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mosesɨ agaŋ Asɨ Iaue dɨ abami. Ci igɨnaŋ uami. Nama hulaŋ iamɨgali agɨladɨ likɨla viovio saŋ iadɨ abɨlanaŋ uami. Agadɨ ala aniaba viaŋ hula ubali agasaŋ iadɨ ma abɨnaŋ igahɨlacin uami. Nama iadɨ nameŋ abahanaŋ uami. Viaŋ nadɨ sɨhɨvia igɨlan aba abahanaŋ uami. Lavɨla nasaŋ hɨjɨŋalɨlan aba abahanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Nama iasaŋ hɨjɨŋalavɨla ha nadɨ hɨji agadɨ iasaŋ sɨhɨvia sulɨnaŋ igahɨlɨben uami. Lɨnaŋ viaŋ hɨji lamavɨla abɨben uami. Asɨ Iaue agaŋ iadɨ igavɨla iasaŋ hɨjɨŋali aba abɨben uami. Lɨlɨŋ hulaŋ iamɨgali agɨladɨ lɨbɨmɨŋɨnaŋ nadɨ nukeŋ hɨniavi agɨlasaŋ igahɨlɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Lɨci Asɨ Iaue agaŋ Mosesɨ dɨ abami. Viaŋ nukeŋ nama hula uben uami. Uu nadɨ huaci lamɨdalɨŋ alusɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Lɨci Mosesɨ abami. Nama alaŋ hula uu saŋ valavɨla ha aludɨ lahunaŋ fɨli tɨbɨ nagadɨ valavɨla umagalu uami. ");
INSERT INTO ena_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Nama alaŋ hula ma unabɨla ha hulaŋ iamɨgali hɨhɨle agɨlaŋ nama iasadaŋ nadɨ hulaŋ iamɨgali agɨlasadaŋ hɨjɨŋalɨnaŋ agadɨ ma igavɨbali uami. Agadɨ ala nama alaŋ hula unabɨla hulaŋ iamɨgali hɨhɨle fɨli tɨbɨ neŋ hɨniavɨlalɨ agɨlaŋ igavɨla abavɨbali uami. Ha Asɨ Iaue nukeŋ hulaŋ iamɨgali agɨladɨ huaci lamɨdaci mu hɨdɨlɨ sɨbaŋ hɨniavadi aba abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Lɨci Asɨ Iaue agaŋ Mosesɨ dɨ abami. Viaŋ nadɨ sɨhɨvia igɨlan uami. Lavɨla nasaŋ hɨjɨŋalɨlan uami. Hameŋ sadaŋ nama akuaba akuaba saŋ abɨnaŋ hameŋ laci ala lɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Lɨci Mosesɨ agaŋ Asɨ Iaue dɨ abami. Iasaŋ nadɨ abɨlu hekɨlɨ vɨdɨvɨdɨŋ daŋ agadɨ abalamɨnaŋ igɨlɨŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Lɨci Asɨ Iaue agaŋ Mosesɨ dɨ abami. Viaŋ iadɨ hɨji huaci agadɨ nasaŋ sulɨlɨŋ igahɨlɨbanaŋ uami. La iadɨ ibi agadɨ avi luvɨlɨlɨŋ igahɨlɨbanaŋ uami. Viaŋ Asɨ Iaue uami. Viaŋ hulaŋ mu saŋ mavɨn hɨniavɨla nudɨ huaci lamɨben aba uami. Ha viaŋ nusaŋ mavɨn hɨniavɨla nudɨ huaci lamɨben uami. Viaŋ hulaŋ mu saŋ mavɨn hekɨlɨ mɨŋavɨla nudɨ huaci lamɨben aba uami. Ha nusaŋ mavɨn hekɨlɨ mɨŋavɨla nudɨ huaci lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Agadɨ ala nama iadɨ mugaŋ lamɨgaŋ agadɨ ma igɨbanaŋ uami. Hulaŋ mu iadɨ mugaŋ lamɨgaŋ agadɨ igavɨla ha nɨbu hɨmɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Igɨha uami. Lɨba kum hekɨlɨ agaŋ iadɨ mikɨ pɨŋ hɨnidi uami. Nama ve lɨba kum agadɨ sabɨ heŋ lagulamɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Iadɨ abɨlu hekɨlɨ vɨdɨvɨdɨŋ daŋ agaŋ nadɨ mikɨ pɨŋ uci uami. Ha lɨba haca muji hɨvɨ nadɨ mɨŋa ivoua lamavɨla iadɨ human hɨvɨ hɨsihalɨlɨŋ hɨnidanaŋ viaŋ ua likilama umitɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","La iadɨ human agadɨ mɨŋavelɨŋ iadɨ hulɨ agadɨ pam igɨbanaŋ uami. Agadɨ ala iadɨ mugaŋ lamɨgaŋ agadɨ amɨŋ ma igɨbanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Asɨ Iaue agaŋ Mosesɨ dɨ abami. Lɨba cɨkaŋ ahica ahica havalɨnaŋ mɨga ifɨcɨkɨcɨkɨ lɨhavalɨ hameŋ agɨladɨ ihacɨkɨla viavɨla sɨhɨvia sɨbaŋ hihɨlɨha uami. Lɨnaŋ viaŋ ciaŋ lɨba cɨkaŋ ihatɨbutɨbu lɨbacin hameŋ agadɨ laci ala ihatɨbutɨbu lɨbɨben uami. ");
INSERT INTO ena_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Nama lɨba cɨkaŋ ahica agɨladɨ sɨhuvavɨla amɨli cimɨdaŋ sɨbaŋ Sainai halu huva viaŋ hɨnilan neŋ iahɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Agadɨ ala hulaŋ mu nama hula vemɨdɨ uami. Hulaŋ mu halu neŋ hɨnihɨni saŋ avi valin uami. Nɨbɨlaŋ hudɨmɨda sɨkasɨkan mɨgua halu lɨguŋ heŋ pam hɨniavɨm uami. Sabaŋ sipsipɨ sabaŋ bulɨmakau agɨlaŋ avi halu lɨguŋ heŋ vevɨla humɨsɨ navɨmɨdɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Lɨci Mosesɨ agaŋ Asɨ Iaue dɨ ciaŋ agadɨ lubiahɨlavɨla lɨba cɨkaŋ ahica ihacɨkɨlami. Sebɨlɨ Asɨ nukeŋ ihacɨkɨlami hameŋ ala ihacɨkɨlami. Ihacɨkɨla via mɨŋalɨvavɨla cimɨdaŋ sɨbaŋ Sainai halu iahumi. ");
INSERT INTO ena_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Lɨci Asɨ Iaue agaŋ avɨli susu lɨkɨla lɨkɨla hɨvɨ hɨnia mɨgavɨla halu heŋ Mosesɨ dɨ pɨŋ lagulamavɨla nudɨ nukeŋ ibi agadɨ luvɨlavɨla abami. Viaŋ Asɨ Iaue uami. ");
INSERT INTO ena_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","La Mosesɨ dɨ mikɨ pɨŋ uavɨla nudɨ likilama hɨbɨsisi uu abami. Viaŋ Asɨ Iaue uami. Viaŋ hulaŋ iamɨgali akape agɨlasaŋ mavɨn hekɨlɨ mɨŋamɨŋa nulɨdɨ huaci lamɨlan uami. Viaŋ hulaŋ iamɨgali akape agɨlasaŋ mavɨn hɨnilan uami. Viaŋ lɨhalɨha sɨbaŋ igɨvɨ ma hɨnilan uami. Viaŋ iadɨ nukeŋ ciaŋ agadɨ lubiahɨlahɨla hulaŋ iamɨgali akape agɨladɨ huaci lamɨlan uami. ");
INSERT INTO ena_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Hulaŋ iamɨgali ciaŋ lulavɨla lusɨŋ sɨbɨlɨ viavɨla hugɨ daŋ hɨniavɨci uami. Ha viaŋ nulɨdɨ hugɨ agɨladɨ hivavɨla nulɨdɨ huaci lamɨlan uami. La nulɨdɨ ninanadinɨlu ajihalinɨlu iamɨlɨhalinɨlu agɨladɨ huaci lamɨben uami. Iamɨlɨhalinɨlu dɨ ninanadinɨlu mufɨli mufɨli iahavɨbali agɨladɨ avi hameŋ laci ala huaci lamɨben uami. Agadɨ ala hulaŋ iamɨgali iadɨ sɨkasɨkan valavɨla hugɨ daŋ hɨniavɨci uami. Ha nulɨdɨ ninanadinɨlu ajihalinɨlu iamɨlɨhalinɨlu agɨlaŋ avi vɨhɨlɨ hameŋ laci ala iga iga hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Hameŋ abɨci Mosesɨ agaŋ Asɨ Iaue dɨ ibi mɨŋaiahɨben aba nudɨ hali lɨbuhɨla lɨhalɨha fɨli hɨvɨ mɨgalɨfɨlɨbami. ");
INSERT INTO ena_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Lavɨla Asɨ Iaue dɨ abami. Iadɨ Hekɨlɨ uami. Iadɨ igavɨla iasaŋ hɨjɨŋalavɨla ha nama alaŋ hula huaci ubanaŋ uami. Alaŋ ciaŋ lulalula hɨsɨŋ hulaŋ iamɨgali uami. Alaŋ lusɨŋ sɨbɨlɨ vivi hugɨ daŋ hɨnilalu uami. Agadɨ ala nama aludɨ hugɨ agɨladɨ hivavɨla aludɨ likɨlɨnaŋ nadɨ lɨhu hɨvɨ hɨniavɨla ha nadɨ nukeŋ hulaŋ iamɨgali sɨbaŋ hɨnibalu uami. ");
INSERT INTO ena_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Lɨci Asɨ Iaue agaŋ Mosesɨ dɨ abami. Viaŋ Asɨ Iaue uami. Viaŋ ciaŋ mɨguavɨla Isɨlaelɨ hɨdɨlɨ naludɨ abɨben uami. La vɨdɨvɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ nalusaŋ abalamɨdalɨŋ igɨbalaŋ uami. Vaka hɨdɨlɨ mu mu fɨli tɨbɨ mu hɨvɨ mu hɨvɨ hɨniavɨhadami agɨlaŋ hameŋ agɨladɨ ma igavɨhadami uami. Viaŋ naludɨ hɨvɨ akuaba akuaba lɨdalɨŋ hulaŋ iamɨgali naludɨ haiabɨla mikɨ hɨniavɨlalɨ agɨlaŋ iga iga hekɨlɨ lɨdavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Iabi viaŋ ciaŋ vɨdɨvɨdɨŋ nalusaŋ iguadin nagɨladɨ lubiahɨlɨhalaŋ uami. Ci igɨlaŋ uami. Viaŋ nukeŋ hali uavɨla Amolɨ hɨdɨlɨ Kenan hɨdɨlɨ Hitɨ hɨdɨlɨ Pelesɨ hɨdɨlɨ Hivɨ hɨdɨlɨ Jebusɨ hɨdɨlɨ agɨladɨ lahudalɨŋ vala mɨjiavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Namɨlaŋ sɨhɨvia sɨbaŋ migɨlɨhalaŋ uami. Fɨli tɨbɨ hɨnibalaŋ heŋ hɨsɨŋ hulaŋ iamɨgali agɨlaŋ hula ciaŋ mɨgumɨlaŋ uami. Nɨbɨlaŋ hula ciaŋ mɨgulabɨla ha nɨbɨlaŋ lɨhavɨci namɨlaŋ nulɨdɨ hɨji agɨladɨ pam lubiahɨlavɨla sɨkasɨkan sɨbɨlɨ lɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Nulɨdɨ sagalɨ hɨlahɨla hɨsɨŋ vadɨm agɨladɨ sɨkasɨkan mɨŋacivɨhalɨhalaŋ uami. Lɨba hutesɨ hutesɨ agɨladɨ lamalama aludɨ asɨ aba abavɨlalɨ agɨladɨ ifɨcɨkɨcɨkɨ lɨhalaŋ uami. Kɨlɨ limu hɨhɨle vavevave hɨda me huliavɨdaci mɨgumɨgu hɨniavɨdaci aludɨ asɨ aba abavɨlalɨ agɨladɨ avi sɨkasɨkan ihalalɨfɨlaŋ mɨgavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Viaŋ Asɨ Iaue uami. Viaŋ vɨdɨvɨdɨŋ hekɨlɨ daŋ sadaŋ hulaŋ mu iadɨ hɨninikɨla iadɨ uvɨsɨjiŋ vivi agaŋ hɨma sɨbaŋ uami. Namɨlaŋ iadɨ ibi agadɨ pam mɨŋaiahɨhalaŋ uami. Kɨlɨ akuaba akuaba lɨhulɨhu lamalama aludɨ asɨ aba abavɨlalɨ agɨladɨ ibi mɨŋaiahɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Fɨli tɨbɨ hɨnibalaŋ heŋ hɨsɨŋ hulaŋ iamɨgali agɨlaŋ hula ciaŋ mɨgumɨlaŋ uami. Nɨbɨlaŋ kɨlɨ akuaba akuaba agɨladɨ lɨhulɨhu lamalama aludɨ asɨ aba abavɨlalɨ agɨladɨ ibi mɨŋaiahavɨlalɨ uami. Namɨlaŋ nɨbɨlaŋ hula ciaŋ mɨgulabɨla ha naludɨ abavɨci ahuata mɨgudɨbavɨla nulɨdɨ sɨhɨm akuaba akuaba sagalɨ hɨlahɨla lamavɨlalɨ agɨladɨ nɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Namɨlaŋ hɨdɨlɨ mu agɨlaŋ hula ciaŋ mɨguavɨla ha naludɨ hulaŋ mɨnibɨlɨ agɨlasaŋ hɨdɨlɨ mu agɨladɨ iamɨgali mɨnibɨlɨ agɨladɨ lɨbɨmɨŋɨbalaŋ uami. Hameŋ lɨlabɨla ha iamɨgali agɨlaŋ nulɨdɨ muŋanadinɨlu dɨ hɨji huaci agɨladɨ mɨŋaihuihu lɨhavɨci iadɨ valavɨbali uami. La kɨlɨ akuaba akuaba lɨhulɨhu lamalama aludɨ asɨ aba abavɨlalɨ agɨladɨ ibi mɨŋaiahavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Namɨlaŋ lɨba golɨ akuaba akuaba agɨladɨ via lamavɨla aludɨ asɨ aba abavɨla nulɨdɨ ibi mɨŋaiahɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Avaŋ Abipɨ hɨvɨ namɨlaŋ Isipɨ fɨli tɨbɨ agadɨ vala vehalaŋ uami. Hameŋ sadaŋ avaŋ Abipɨ agadɨ hɨvɨ iadɨ ibi mɨŋaiahaiaha sɨmɨŋ hekɨlɨ hɨlanana saŋ ciaŋ vɨdɨvɨdɨŋ iguadin uami. Iadɨ ciaŋ vɨdɨvɨdɨŋ lubiahɨlavɨla uaiaŋ human limu fɨhala human limu ahica cɨjɨŋ agɨladɨ hɨvɨ maci sakɨvakɨva agɨladɨ nɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Naludɨ ninaŋ manɨgali Cimegeŋ uami. Naludɨ sabaŋ bulɨmakau ninaŋ manɨgali muŋaŋ agɨlaŋ uami. Sabaŋ sipsipɨ ninaŋ manɨgali muŋaŋ agɨlaŋ uami. Akuaba akuaba sɨhɨm sabaŋ ninaŋ manɨgali muŋaŋ agɨlaŋ uami. Ha iadɨ pam hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Sabaŋ donɨki ninaŋ manɨgali agadɨ ifɨhɨmuhɨmu saŋ valavɨla ha nudɨ uvɨsɨjiŋ vivi saŋ sabaŋ sipsipɨ ninaŋ muŋaŋ agadɨ ifɨhɨma lamavɨla sagalɨ hɨla iguhalaŋ uami. Sabaŋ donɨki ninaŋ manɨgali agadɨ uvɨsɨjiŋ ma vimaŋ lavɨla ha sabaŋ donɨki ninaŋ manɨgali agadɨ sakum hɨvɨ mɨŋa mafɨlavɨci hɨmɨbali uami. Ninaŋ Cimegeŋ agadɨ uvɨsɨjiŋ heŋ sabaŋ sipsipɨ ninaŋ muŋaŋ agadɨ ifɨhɨma lamavɨla sagalɨ hɨla iguhalaŋ uami. Iadɨ ibi mɨŋaiahɨben aba akuaba akuaba sagalɨ igu igu saŋ abin agɨladɨ vavehalaŋ uami. Havɨ vemɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Naludɨ nukeŋ sibɨla akuaba akuaba agɨladɨ vivi hɨsɨŋ mɨhiŋ human limu fɨhala human limu pabiŋ cɨjɨŋ uami. La hɨnilaŋ mɨŋalahɨci uaiaŋ mu hɨvɨ sibɨla vimɨlaŋ uami. La mufɨli mufɨli hualɨ hulihuli hɨmiŋ hɨvɨ hameŋ laci hameŋ laci lɨhalaŋ uami. Hualabɨla hɨsɨŋ sɨmɨŋ mɨdɨ lɨhulɨhu hɨmiŋ hɨvɨ avi hameŋ laci ala lɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Naludɨ halɨha cahu uitɨ hulilalaŋ agɨlaŋ mɨdɨ lɨhuavɨci iadɨ ibi mɨŋaiahaiaha saŋ sɨmɨŋ hekɨlɨ hɨlanɨhalaŋ uami. Halɨha cahu uitɨ hali hɨsɨŋ agɨladɨ vave iasaŋ sagalɨ iguhalaŋ uami. Avaŋ naludɨ sɨmɨŋ akuaba akuaba mɨdɨ lɨhua fɨhalavɨlalɨ agadɨ hɨvɨ avi iadɨ ibi mɨŋaiahaiaha sɨmɨŋ hekɨlɨ hɨlanɨhalaŋ uami. La iasaŋ sagalɨ iguhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Viaŋ Asɨ Iaue uami. Viaŋ Isɨlaelɨ hɨdɨlɨ naludɨ Hekɨlɨ uami. Hualɨ pabiŋ pabiŋ hɨvɨ iadɨ ibi mɨŋaiahaiaha saŋ ahica pam tɨbɨ fipɨ viaŋ hɨniben heŋ uu sɨmɨŋ hekɨlɨ hɨlanɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Viaŋ hali uavɨla hulaŋ iamɨgali hɨdɨlɨ mu mu agɨladɨ lahudalɨŋ uavɨdaci namɨlaŋ fɨli tɨbɨ hekɨlɨ daŋ hɨnibalaŋ uami. Hɨnihɨni hualɨ pabiŋ pabiŋ hɨvɨ ahica pam tɨbɨ iadɨ ibi mɨŋaiahaiaha sɨmɨŋ hekɨlɨ hɨlanana saŋ udalaŋ hulaŋ hɨhɨle agɨlaŋ naludɨ fɨli tɨbɨ agadɨ sɨgɨlɨ vivi saŋ mavɨn ma igavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Iasaŋ sagalɨ iguben aba sɨhɨm ifɨhɨmɨlaŋ mɨdɨ mɨgɨci mɨdɨ agadɨ viavɨla maci daŋ iasaŋ sagalɨ iguhalaŋ uami. Agadɨ ala maci huhɨla huhɨla hɨsɨŋ isɨ aba abavɨlalɨ agadɨdaŋ eŋalavɨla hɨlavɨlalɨ agɨladɨ via mɨdɨ agadɨdaŋ iasaŋ sagalɨ igumɨlaŋ uami. Viaŋ Isɨlaelɨ hɨdɨlɨ naludɨ valɨlɨŋ huaci hɨniahalaŋ agadɨ mɨhiŋ hekɨlɨ heŋ sɨmɨŋ hekɨlɨ hɨlanavɨla sɨkasɨkan na fɨhalɨhalaŋ uami. Sɨhɨm agɨladɨ limu cɨkaŋ cɨki avi cimɨdaŋ nana saŋ valɨlaŋ hɨnimɨdɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Naludɨ hualabɨla hɨhi hɨsɨŋ sɨmɨŋ huaci huaci nɨbɨlaŋ mɨse mɨdɨ lɨhuavɨlalɨ agɨladɨ iadɨ ulaŋ hɨvɨ vavehalaŋ uami. Viaŋ naludɨ Asɨ Iaue uami. Sabaŋ meme amaŋ mɨtɨ agadɨdaŋ sabaŋ meme ninaŋ cɨki agadɨdaŋ pam lamavɨla sɨji hɨvɨ hugɨlɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","La Mosesɨ dɨ abami. Nama ciaŋ nagɨladɨ lɨbɨha uami. Viaŋ ciaŋ nagɨlasaŋ igahɨlavɨla ciaŋ mɨguavɨla nadɨdaŋ nadɨ hɨdɨlɨ pam Isɨlaelɨ hɨdɨlɨ agɨladɨdaŋ abadin uami. ");
INSERT INTO ena_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mosesɨ agaŋ halu iahua Asɨ Iaue hula hɨnidaci uaiaŋ 38 umi. Heŋ hɨnihɨni sɨmɨŋ avɨli akuaba akuaba ma nami. Lɨci Asɨ Iaue agaŋ ciaŋ mɨguavɨla ciaŋ vɨdɨvɨdɨŋ human limu limu fɨhala agɨladɨ ihatɨbutɨbu lɨbami. Lɨba cɨkaŋ ahica ahica Mosesɨ via iahumi agɨladɨ hɨvɨ ihatɨbutɨbu lɨbami. ");
INSERT INTO ena_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mosesɨ agaŋ Asɨ Iaue hula ciaŋ sulasula hɨniavɨdaci Asɨ dɨ abɨlu agaŋ ve Mosesɨ dɨ mugaŋ lamɨgaŋ hɨvɨ hɨnimi. Lɨci nudɨ mugaŋ lamɨgaŋ agaŋ mila sɨbaŋ hɨnimi. Agadɨ ala Asɨ Mosesɨ dɨ hɨvɨ akuaba akuaba lɨmi agadɨ nɨbu nukeŋ ma igami. La Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ lɨba cɨkaŋ hɨvɨ hɨniavɨmi agɨladɨ likɨla mɨŋalɨvavɨla halu agadɨ vala mɨgami. ");
INSERT INTO ena_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Lɨci Alon agaŋ Isɨlaelɨ hɨdɨlɨ agɨlaŋ hula Mosesɨ dɨ mugaŋ lamɨgaŋ agadɨ igavɨci mila sɨbaŋ hɨnimi. Lɨci nudɨ mikɨ pɨŋ uu saŋ lɨdavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Lɨhavɨci Mosesɨ agaŋ Alon dɨdaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ manɨgali agɨladɨdaŋ abɨci nudɨ pɨŋ vehavɨci nɨbɨlaŋ hula ciaŋ abami. ");
INSERT INTO ena_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Abɨci ci lɨci Isɨlaelɨ hɨdɨlɨ agɨlaŋ sɨkasɨkan Mosesɨ dɨ pɨŋ vehavɨmi. Vehavɨci Asɨ Iaue agaŋ nusaŋ ciaŋ vɨdɨvɨdɨŋ Sainai halu iahuci igumi agɨladɨ nulɨsaŋ sulami. ");
INSERT INTO ena_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Sula fɨhalɨci ci lɨci havɨlɨ tɨbɨ viavɨla nudɨ mugaŋ lamɨgaŋ agadɨ hafilɨbami. ");
INSERT INTO ena_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","La Asɨ hula ciaŋ aba aba saŋ havɨlɨ ulaŋ ivouben aba havɨlɨ tɨbɨ nudɨ mugaŋ lamɨgaŋ hafilɨbadami agadɨ mɨŋalavɨlalavɨla lamalama heŋ ivouadami. Lɨdɨŋ haiabɨla ivaveve Asɨ Iaue akuaba akuaba ciaŋ vɨdɨvɨdɨŋ abadami agasaŋ cɨhu hulaŋ iamɨgali agɨladɨ tɨbi suladami. ");
INSERT INTO ena_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Hulaŋ iamɨgali agɨlaŋ Mosesɨ dɨ igavɨdaci Asɨ dɨ abɨlu agaŋ hɨnidaci nudɨ mugaŋ lamɨgaŋ mila sɨbaŋ hɨniadami. Lɨdaci Mosesɨ Asɨ dɨ ciaŋ sulɨci ci lɨdaci nudɨ havɨlɨ tɨbɨ agadɨ vivi nudɨ mugaŋ lamɨgaŋ agadɨ cɨhu hafilɨbadami. Lɨdɨŋ uu Asɨ hula ciaŋ abɨben aba heŋ pam havɨlɨ tɨbɨ agadɨ cɨhu mɨŋalavɨlalavɨla lamadami. ");
INSERT INTO ena_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mosesɨ agaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ abɨci vehavɨci nulɨdɨ abami. Asɨ Iaue nameŋ abalɨ uami. Ciaŋ vɨdɨvɨdɨŋ nameŋ agɨladɨ lubiahɨlɨhalaŋ aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Naludɨ sibɨla akuaba akuaba vivi hɨsɨŋ uaiaŋ ha human limu fɨhala human limu pabiŋ cɨjɨŋ laci aba abalɨ uami. La uaiaŋ mu hɨvɨ ha alusɨhalaŋ aba abalɨ uami. Ha iadɨ mɨhiŋ hekɨlɨ aba abalɨ uami. Hulaŋ iamɨgali agɨlaŋ mɨhiŋ agadɨ hɨvɨ sibɨla vihavɨci nulɨdɨ sɨkasɨkan ifɨhɨmɨhalaŋ aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Alusɨsɨ mɨhiŋ agadɨ hɨvɨ naludɨ uleŋ muji hɨvɨ avɨŋ mahɨlɨmɨlaŋ aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","La Mosesɨ agaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ abami. Asɨ Iaue nameŋ abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Isɨlaelɨ hɨdɨlɨ agɨlaŋ akuaba akuaba agɨladɨ via iasaŋ sagalɨ iguavɨm aba abalɨ uami. Hulaŋ iamɨgali human putɨ putɨ agɨlaŋ akuaba akuaba iadɨ havɨlɨ ulaŋ vivi saŋ iguavɨm aba abalɨ uami. Akuaba akuaba nameŋ agɨladɨ vavevave iguavɨm aba abalɨ uami. Lɨba golɨ lɨba silɨva lɨba bɨlasɨ agɨladɨ vavehavɨm aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Sabaŋ sipsipɨ mɨnɨ ihalahalaha vivi maŋa cɨbɨŋ hɨvɨ mɨŋepɨhalavalɨ agɨladɨ vavehavɨm aba abalɨ uami. Maŋa mɨdɨ cɨbɨŋ hɨvɨ mɨŋepɨhalavalɨ agɨladɨ vavehavɨm aba abalɨ uami. Maŋa mɨdɨ sɨbaŋ hɨvɨ mɨŋepɨhalavalɨ agɨladɨ avi vavehavɨm aba abalɨ uami. Niagɨlɨŋ mila huaci huaci sɨbaŋ agɨladɨ vavehavɨm aba abalɨ uami. Sabaŋ meme mɨnɨ agɨladɨ vavehavɨm aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Sabaŋ sipsipɨ muŋaŋ agɨladɨ sɨgɨtɨ maŋa mɨdɨ hɨvɨ mɨŋepɨhalavalɨ agɨladɨ vavehavɨm aba abalɨ uami. Avɨli hekɨlɨ hɨsɨŋ hehɨlaŋ mu hɨdɨlɨ agɨladɨ sɨgɨtɨ huaci huaci agɨladɨ vavehavɨm aba abalɨ uami. Kɨlɨ akasɨ tɨbɨ tɨbɨ mibɨŋ hegulaŋ me agɨladɨ vavehavɨm aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ unɨ hɨvɨ lama lubilamalama hɨsɨŋ agadɨ vavehavɨm aba abalɨ uami. Cihu savu me mu hɨdɨlɨ mu hɨdɨlɨ hɨlavɨdaci hɨsi huaci huaci iahaiaha hɨsɨŋ agɨladɨ vavehavɨm aba abalɨ uami. Cihu savu me hɨhɨle kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavɨla akuaba akuaba iasaŋ lɨbɨmɨŋɨben aba nulɨdɨ sabɨ hɨvɨ mɨŋamɨjimɨji hɨsɨŋ agɨladɨ vavehavɨm aba abalɨ uami. Cihu savu me hɨhɨle hɨlavɨdaci hɨsi huaci huaci iahaiaha hɨsɨŋ agɨladɨ vavehavɨm aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Lɨba konilian ahica agɨladɨ vavehavɨm aba abalɨ uami. Lɨba konilian ahica ha iasaŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ agaŋ havɨlɨ cɨliŋ daŋ agadɨ nudɨ macɨŋ hɨvɨ lamɨbali agadɨ sabɨ lamalama saŋ vavehavɨm aba abalɨ uami. Lɨba hɨlɨcɨ hɨhɨle avi vavehavɨm aba abalɨ uami. Lɨba hɨlɨcɨ hɨhɨle ha havɨlɨ tɨbɨ mu sugɨ vaŋ me hɨnibali agadɨ uvɨ hɨtɨŋ hɨtɨŋ heŋ lamalama saŋ vavehavɨm aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","La Mosesɨ agaŋ cɨhu abami. Asɨ Iaue agaŋ nameŋ abalɨ uami. Naludɨ hulaŋ hɨhɨle human sihɨ via iga iga agɨlaŋ vevɨla akuaba akuaba agɨladɨ vihavɨm aba abalɨ uami. Viaŋ abacin hameŋ laci ala vihavɨm aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Havɨlɨ ulaŋ vihavɨm aba abalɨ uami. Havɨlɨ limu hɨhɨle havɨlɨ ulaŋ agadɨ sabɨ lalɨgu lalɨgu hɨsɨŋ agɨladɨ vihavɨm aba abalɨ uami. Agɨlɨŋ hɨhɨle vihavɨm aba abalɨ uami. Hɨda ahica lɨdɨŋ lɨbukuvakuva hɨsɨŋ agɨladɨdaŋ hɨda sɨbaŋ agɨladɨdaŋ vihavɨm aba abalɨ uami. Lɨba kum haca daŋ haca daŋ hɨda lalɨlamalama hɨsɨŋ agɨladɨ vihavɨm aba abalɨ uami. Kɨlɨ sɨlɨvɨŋ valɨ hutesɨ hutesɨ havɨlɨ ulaŋ agadɨ madɨŋ limu limu hɨgɨlavɨci hɨgɨlavɨci uu hɨsɨŋ agɨladɨdaŋ ulaŋ safɨli heŋ hɨgɨlavɨci hɨgɨlavɨci uu hɨsɨŋ agɨladɨdaŋ vihavɨm aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨdaŋ nudɨ lamɨgaŋ agadɨdaŋ vihavɨm aba abalɨ uami. Kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ havahava saŋ kɨlɨ sɨlɨvɨ ahica agɨladɨ vihavɨm aba abalɨ uami. Havɨlɨ uleŋ muji alɨhaŋ hɨnilaha lɨbala lɨbala hɨsɨŋ havɨlɨ hekɨlɨ agadɨ vihavɨm aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Maci sakɨvakɨva lamalama hɨsɨŋ vadɨm agadɨdaŋ nudɨ hunaŋ akuaba akuaba agɨladɨdaŋ vihavɨm aba abalɨ uami. Nudɨ havahava saŋ kɨlɨ sɨlɨvɨ agɨladɨ vihavɨm aba abalɨ uami. Maci sakɨvakɨva iasaŋ lamalama hɨsɨŋ agɨladɨ vihavɨm aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Unɨ lamalama hɨsɨŋ hɨlɨ agadɨdaŋ nudɨ hunaŋ akuaba akuaba agɨladɨdaŋ vihavɨm aba abalɨ uami. Unɨ cɨki cɨki agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ unɨ hɨvɨ lama lubilamalama hɨsɨŋ agadɨdaŋ vihavɨm aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Cihu savu me hɨsi huaci huaci daŋ agɨladɨ hɨlahɨla hɨsɨŋ vadɨm ibilavɨm aba abalɨ uami. Nudɨ havahava saŋ kɨlɨ sɨlɨvɨ agɨladɨ vihavɨm aba abalɨ uami. Cihu savu me agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavɨla akuaba akuaba iasaŋ lɨbɨmɨŋɨben aba nulɨdɨ sabɨ hɨvɨ mɨŋamɨjimɨji hɨsɨŋ agɨladɨ vihavɨm aba abalɨ uami. Cihu savu me hɨlavɨci hɨsi huaci huaci iahaiaha hɨsɨŋ agɨladɨ vihavɨm aba abalɨ uami. Havɨlɨ ulaŋ hɨbɨ agadɨ hɨsihalahala saŋ havɨlɨ mu vihavɨm aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Sagalɨ hɨlahɨla hɨsɨŋ vadɨm ibilavɨm aba abalɨ uami. Akuaba akuaba agɨladɨ lamalama hɨlahɨla hɨsɨŋ lɨba bɨlasɨ hɨvɨ mɨkɨdiŋ me agadɨdaŋ nudɨ hunaŋ akuaba akuaba agɨladɨdaŋ vihavɨm aba abalɨ uami. Vadɨm havahava saŋ kɨlɨ sɨlɨvɨ agɨladɨ vihavɨm aba abalɨ uami. Hɨcɨ human husahusa hɨsɨŋ hunaŋ mɨsɨn hekɨlɨ agadɨdaŋ nudɨ lamɨci hɨnihɨni hɨsɨŋ vadɨm agadɨdaŋ vihavɨm aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Havɨlɨ hekɨlɨ hekɨlɨ havɨlɨ ulaŋ haiabɨla agadɨ haŋala haŋala lua me hahahaha hɨsɨŋ agɨladɨ vihavɨm aba abalɨ uami. Nudɨ hɨda agɨladɨdaŋ lɨba bɨlasɨ kum haca daŋ haca daŋ hɨda lalɨlamalama hɨsɨŋ agɨladɨdaŋ vihavɨm aba abalɨ uami. Lua me agadɨ hɨbɨ hɨsihalahala hɨsɨŋ havɨlɨ mu vihavɨm aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Havɨlɨ ulaŋ agadɨdaŋ nudɨ lua me agadɨdaŋ vɨdɨvɨdɨŋ igu igu saŋ lɨmɨn agɨladɨ vihavɨm aba abalɨ uami. Fɨli hɨvɨ ifavɨci ifavɨci mɨguavɨdaci lɨmɨn agɨladɨ magɨla magɨla hahahaha saŋ lɨba bɨlasɨ henaŋ hutesɨ hutesɨ agɨladɨ vihavɨm aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Alon sadaŋ nudɨ ninadinu agɨlasadaŋ hadi hɨlahɨla huaci huaci agɨladɨ vihavɨm aba abalɨ uami. Iasaŋ sagalɨ igu igu hɨsɨŋ hulaŋ agɨlaŋ hadi hɨlahɨla hameŋ agɨladɨ lamalama uaiaŋ pabiŋ pabiŋ sagalɨ igu igu hɨsɨŋ uvɨ havɨlɨ uleŋ muji heŋ sibɨla vihavɨbali aba abalɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Mosesɨ agaŋ abɨci ci lɨci Isɨlaelɨ hɨdɨlɨ agɨlaŋ nudɨ vala uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Vala uavɨla cɨhu hulaŋ iamɨgali sibɨla vivi saŋ mavɨn hɨniavɨmi agɨlaŋ hula hulaŋ iamɨgali human putɨ putɨ agɨlaŋ hula Asɨ Iaue dɨ havɨlɨ ulaŋ vivi saŋ akuaba akuaba vavehavɨmi. Havɨlɨ ulaŋ heŋ Asɨ dɨ ibi mɨŋaiahaiaha hɨsɨŋ akuaba akuaba agɨladɨ vavehavɨmi. Akuaba akuaba sagalɨ igu igu hɨsɨŋ hulaŋ agɨladɨ hadi hɨlahɨla vivi hɨsɨŋ agɨladɨ avi vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Hulaŋ iamɨgali human putɨ putɨ agɨlaŋ akuaba akuaba nameŋ agɨladɨ vavehavɨmi. Mugaŋ hɨsɨŋ luvɨŋ hɨji asɨŋ hɨsɨŋ hajɨŋ human lavi sugɨ malɨluŋ agɨladɨ vavehavɨmi. Akuaba akuaba hajɨŋ sɨkasɨkan ha lɨba golɨ hɨvɨ laci vihavɨmi agɨladɨ vavehavɨmi. Asɨ Iaue saŋ sagalɨ igubalu aba hɨjɨŋalaŋala akuaba akuaba agɨladɨ vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Hulaŋ iamɨgali limu hɨhɨle niagɨlɨŋ mila huaci huaci sɨbaŋ daŋ agɨlaŋ niagɨlɨŋ mila huaci huaci sɨbaŋ agɨladɨ vavehavɨmi. Hɨhɨle sabaŋ sipsipɨ mɨnɨ ihalahalaha vivi maŋa cɨbɨŋ hɨvɨ mɨŋepɨhalapɨhala lamavɨhadami agɨlaŋ nudɨ vavehavɨmi. Hɨhɨle maŋa mɨdɨ cɨbɨŋ hɨvɨ mɨŋepɨhalapɨhala lamavɨhadami agɨlaŋ nudɨ vavehavɨmi. Hɨhɨle maŋa mɨdɨ sɨbaŋ hɨvɨ mɨŋepɨhalapɨhala lamavɨhadami agɨlaŋ nudɨ vavehavɨmi. Hɨhɨle sabaŋ meme mɨnɨ daŋ agɨlaŋ sabaŋ meme mɨnɨ agɨladɨ vavehavɨmi. Hɨhɨle sabaŋ sipsipɨ muŋaŋ agɨladɨ sɨgɨtɨ maŋa mɨdɨ hɨvɨ mɨŋepɨhalapɨhala lamavɨhadami agɨlaŋ nulɨdɨ vavehavɨmi. Hɨhɨle avɨli hekɨlɨ hɨsɨŋ hehɨlaŋ mu hɨdɨlɨ agɨladɨ sɨgɨtɨ daŋ agɨlaŋ hameŋ ala vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Hulaŋ iamɨgali Asɨ Iaue saŋ sagalɨ iguben aba lɨhavɨmi agɨlaŋ lɨba silɨva lɨba bɨlasɨ agɨladɨ vavevɨla nusaŋ sɨkasɨkan sagalɨ iguavɨmi. Hulaŋ kɨlɨ akasɨ mibɨŋ hegulaŋ me daŋ agɨlaŋ havɨlɨ ulaŋ akuaba akuaba vivi saŋ vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Iamɨgali sɨkasɨkan niagɨlɨŋ iva iga iga agɨlaŋ niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ iva iva vavehavɨmi. Havɨlɨ mila vivi saŋ niagɨlɨŋ mila huaci huaci sɨbaŋ agɨladɨ ivavɨla vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Iamɨgali hɨhɨle sabaŋ meme mɨnɨ hɨvɨ niagɨlɨŋ iva iga iga agɨladɨ mavɨn iahɨdaci niagɨlɨŋ ivavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Manɨgali agɨlaŋ lɨba hɨlɨcɨ konilian ahica agɨladɨ vavehavɨmi. Lɨba hɨlɨcɨ konilian ahica ha Asɨ saŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ agaŋ havɨlɨ cɨliŋ daŋ nudɨ macɨŋ hɨvɨ lamɨbali agadɨ sabɨ lamalama saŋ vavehavɨmi. Lɨba hɨlɨcɨ hɨhɨle vavehavɨmi. Lɨba hɨlɨcɨ hɨhɨle ha havɨlɨ tɨbɨ mu sugɨ vaŋ me hɨnibali agadɨ uvɨ hɨtɨŋ hɨtɨŋ heŋ lamalama saŋ vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Cihu savu me hɨhɨle agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ vavehavɨmi. Cihu savu me hɨhɨle ha hɨlavɨci hɨsi huaci huaci iahaiaha saŋ vavehavɨmi. Cihu savu me hɨhɨle ha kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavɨla akuaba akuaba agɨladɨ Asɨ saŋ lɨbɨmɨŋɨben aba nulɨdɨ sabɨ hɨvɨ mɨŋamɨjimɨji saŋ vavehavɨmi. Kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ hɨhɨle ha unɨ hɨvɨ lama lubilamalama saŋ vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Isɨlaelɨ hɨdɨlɨ hulaŋ iamɨgali human putɨ putɨ agɨlaŋ akuaba akuaba Asɨ Iaue saŋ iguavɨmi. Asɨ Iaue Mosesɨ dɨ abami hameŋ vivi saŋ iguavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mosesɨ agaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ abami. Ci igɨlaŋ uami. Asɨ Iaue agaŋ Besalelɨ dɨ ci lɨbɨmɨŋalɨ uami. Nɨbu Juda hɨdɨlɨ uami. Nudɨ iaganu Oli uami. Nudɨ iauacanu Holɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Asɨ dɨ Amɨŋ agaŋ nɨbu hula ci hɨnidi uami. Hɨnihɨni nusaŋ hɨji igudaci hɨji hutesɨ vivi hɨji huaci daŋ hɨnidi uami. Nɨbu human sihɨ vivi hɨsɨŋ hɨji daŋ hɨnidi uami. Hɨnihɨni sibɨla mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ vibali uami. ");
INSERT INTO ena_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Lɨba golɨ hɨvɨ lɨba silɨva hɨvɨ lɨba bɨlasɨ hɨvɨ akuaba akuaba huaci huaci agɨladɨ vivi saŋ hɨji ci igualɨ uami. ");
INSERT INTO ena_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Lɨba hɨlɨcɨ huaci huaci sɨbaŋ agɨladɨ hɨvɨ ihatɨbutɨbu sihɨ lamalama lɨba golɨ hajɨŋ cɨki cɨki havaŋ avɨli veve agadɨ ulaŋ tulɨ me agɨladɨ hɨvɨ lamɨci mɨgumɨgu saŋ hɨji ci igualɨ uami. Kɨlɨ cɨkaŋ hɨvɨ kɨlɨ tɨbɨ hɨvɨ ihatɨbutɨbu sihɨ sihɨ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ lamalama saŋ hɨji ci igualɨ uami. Nɨbu sibɨla hameŋ agɨladɨ vivi havɨlɨ ulaŋ agadɨ hajɨŋ lamɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Hulaŋ mu Oholiapɨ dɨ avi ci lɨbɨmɨŋalɨ uami. Nɨbu Dan hɨdɨlɨ uami. Nudɨ iaganu Ahisamakɨ uami. Nɨbu Besalelɨ hula sibɨla vihavɨbali uami. Vivi hulaŋ hɨhɨle agɨladɨ avi lamalubiavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Asɨ Iaue agaŋ hulaŋ ahica agɨlaŋ lɨba akuaba akuaba agɨladɨ ihatɨbutɨbu sihɨ lamalama mu hɨdɨlɨ mu hɨdɨlɨ sibɨla vivi saŋ hɨji huaci huaci ci igualɨ uami. Niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ hɨvɨ havɨlɨ huaci huaci sihɨ sihɨ daŋ agɨladɨ vivi saŋ hɨji huaci huaci ci igualɨ uami. Havɨlɨ sihɨ sihɨ hajɨŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ vivi saŋ avi hɨji huaci huaci ci igualɨ uami. Lɨci nɨbɨlaŋ akuaba akuaba hajɨŋ sihɨ sihɨ daŋ agɨladɨ vivi saŋ igahɨlavɨla hameŋ laci ala vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Asɨ Iaue agaŋ Besalelɨ sadaŋ Oholiapɨ sadaŋ hɨji huaci huaci ci igualɨ uami. Hulaŋ hɨhɨle hɨji daŋ hɨji daŋ agɨlasaŋ avi hɨji hutesɨ ci igualɨ uami. Lɨci nɨbɨlaŋ ala Asɨ dɨ havɨlɨ ulaŋ agadɨ vihavɨbali uami. Havɨlɨ ulaŋ hɨsɨŋ akuaba akuaba agɨladɨ avi vihavɨbali uami. Asɨ Iaue akuaba akuaba saŋ abalɨ agɨladɨ hameŋ laci ala vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","La Mosesɨ agaŋ Besalelɨ dɨdaŋ Oholiapɨ dɨdaŋ abɨci vehavɨmi. Hulaŋ hɨhɨle Asɨ Iaue nulɨsaŋ hɨji huaci huaci igumi agɨladɨ avi abɨci vehavɨmi. Hulaŋ sibɨla vivi saŋ mavɨn hɨniavɨmi agɨlaŋ sibɨla vivi saŋ vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Vehavɨci Mosesɨ agaŋ akuaba akuaba Asɨ dɨ havɨlɨ ulaŋ vivi saŋ vavehavɨmi agɨladɨ nulɨsaŋ igumi. Isɨlaelɨ hɨdɨlɨ agɨlaŋ cimɨdaŋ cimɨdaŋ hɨvɨ Asɨ saŋ sagalɨ igubalu aba akuaba akuaba agɨladɨ vakala vakala vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","5","Vavehavɨdaci hulaŋ havɨlɨ ulaŋ sibɨla vivi hɨniavɨmi agɨlaŋ sibɨla valavɨla ve Mosesɨ dɨ abavɨmi. Hulaŋ iamɨgali agɨlaŋ akuaba akuaba akape sɨbaŋ vavehavadi uavɨmi. Akuaba akuaba Asɨ Iaue havɨlɨ ulaŋ sibɨla vivi saŋ abalɨ agaŋ ci hɨlihali uavɨmi. Akuaba akuaba akape sɨbaŋ havɨ hɨniavɨbali uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Lɨhavɨci Mosesɨ agaŋ hulaŋ iamɨgali uu veve hɨnihɨni fipɨ heŋ hɨniavɨmi agɨlasaŋ ciaŋ abɨci umi. Nɨbɨlaŋ akuaba akuaba Asɨ dɨ havɨlɨ ulaŋ vivi saŋ cɨhu cɨhu iguavɨci vehavɨmɨdɨ aba abɨci umi. Lɨci ciaŋ agadɨ igahɨlavɨla akuaba akuaba cɨhu cɨhu ma vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Akuaba akuaba vavehavɨmi agɨlaŋ Asɨ dɨ havɨlɨ ulaŋ akuaba akuaba vivi saŋ abami agɨladɨ lɨvalavɨla akape sɨbaŋ vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Sibɨla hɨsɨŋ hulaŋ sɨkasɨkan sibɨla via iga iga agɨlaŋ Asɨ dɨ havɨlɨ ulaŋ vihavɨmi. Havɨlɨ ulaŋ vivi saŋ havɨlɨ mila huaci huaci sɨbaŋ human limu limu fɨhala agɨladɨ vihavɨmi. Viavɨla niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavɨmi agɨladɨ vivi hɨcavɨdaci hajɨŋ daŋ hɨniavɨmi. Niagɨlɨŋ sihɨ sihɨ hɨcavɨmi agɨlaŋ Asɨ dɨ ciaŋ hali hɨsɨŋ vɨdɨvɨdɨŋ daŋ agɨladɨ mugaŋ lamɨgaŋ me hadipɨlɨ me hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Havɨlɨ human limu limu fɨhala agɨladɨ vihavɨci hɨlihɨli laci hɨniavɨmi. Nulɨdɨ hutesɨ 12 mita laci hɨniavɨmi. Nulɨdɨ abɨŋ 2 mita laci hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Lɨhavɨci havɨlɨ human limu fɨhala agɨladɨ abɨŋ hɨvɨ lamalama hɨcavɨci ua havɨlɨ abɨŋ hekɨlɨ me laci hɨnimi. Havɨlɨ human limu fɨhala limu hɨhɨle agɨladɨ avi hameŋ laci ala nulɨdɨ abɨŋ hɨvɨ lamalama hɨcavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Lavɨla havɨlɨ hekɨlɨ hekɨlɨ ahica agɨladɨ mɨŋave pam lamalama saŋ niagɨlɨŋ cɨbɨŋ agɨladɨ hɨvɨ mɨdu hɨhɨle hɨcavɨmi. Havɨlɨ hekɨlɨ hekɨlɨ ahica agɨladɨ abɨŋ iahua ulaŋ sabɨ hɨvɨ alɨhaŋ alɨhaŋ heŋ hɨnihɨni saŋ mɨdu agɨladɨ hɨcahɨca uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Havɨlɨ mu limu caba hɨsɨŋ agadɨ abɨŋ iahua ulaŋ sabɨ hɨvɨ alɨhaŋ alɨhaŋ heŋ hɨnihɨni saŋ mɨdu 50 agɨladɨ hɨcahɨca uavɨmi. Havɨlɨ mu limu caba hɨsɨŋ agadɨ abɨŋ iahua ulaŋ sabɨ hɨvɨ alɨhaŋ alɨhaŋ heŋ hɨnihɨni saŋ avi mɨdu 50 ala hɨcahɨca uavɨmi. Havɨlɨ limu caba hɨsɨŋ agadɨ mɨdu agɨladɨ iga iga hɨlihɨli hameŋ laci hɨcahɨca uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Havɨlɨ hekɨlɨ hekɨlɨ ahica agɨladɨ lamalama agɨlimɨgumɨgu saŋ lɨba golɨ hɨvɨ agɨlɨŋ 50 agɨladɨ vihavɨmi. Havɨlɨ hekɨlɨ hekɨlɨ ahica agɨladɨ mɨŋave agɨlimɨgumɨgu uavɨci havɨlɨ ulaŋ hekɨlɨ me laci hɨnihɨni saŋ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","La cɨhu havɨlɨ human limu limu fɨhala hɨcɨ limu pabiŋ cɨjɨŋ sabaŋ meme mɨnɨ hɨvɨ vihavɨmi. Havɨlɨ ulaŋ agadɨ lalɨgu lalɨgu saŋ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Havɨlɨ sɨkasɨkan agɨladɨ vihavɨci hɨlihɨli laci hɨniavɨmi. Nulɨdɨ hutesɨ 13 mita laci hɨniavɨmi. Nulɨdɨ abɨŋ 2 mita laci hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Lɨhavɨci havɨlɨ human limu fɨhala agɨladɨ abɨŋ hɨvɨ lamalama hɨcavɨci ua havɨlɨ abɨŋ hekɨlɨ me laci hɨnimi. Lɨci cɨhu havɨlɨ hɨhɨle human limu fɨhala human limu pabiŋ cɨjɨŋ agɨladɨ abɨŋ hɨvɨ lamalama hɨcavɨci ua havɨlɨ abɨŋ hekɨlɨ me laci hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Lɨci havɨlɨ hekɨlɨ mu agadɨ abɨŋ iahua ulaŋ sabɨ hɨvɨ alɨhaŋ alɨhaŋ heŋ hɨnihɨni saŋ mɨdu 50 agɨladɨ hɨcahɨca uavɨmi. La havɨlɨ hekɨlɨ mu agadɨ hɨvɨ avi mɨdu hɨhɨle agɨladɨ iga iga hɨlihɨli laci mɨdu 50 agɨladɨ hɨcahɨca uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Lɨba bɨlasɨ hɨvɨ agɨlɨŋ 50 vihavɨmi. Havɨlɨ hekɨlɨ hekɨlɨ ahica agɨladɨ lamalama agɨlimɨgumɨgu uavɨci havɨlɨ ulaŋ hekɨlɨ hɨnihɨni saŋ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Sabaŋ sipsipɨ muŋaŋ sɨgɨtɨ maŋa mɨdɨ hɨvɨ mɨŋepɨhalavɨmi agɨladɨ viavɨla havɨlɨ ulaŋ sabɨ lalɨgu lalɨgu saŋ lamalama hɨcavɨmi. Avɨli hekɨlɨ hɨsɨŋ hehɨlaŋ mu hɨdɨlɨ agɨladɨ sɨgɨtɨ viavɨla lamalama hɨcavɨmi. Havɨlɨ ulaŋ sabɨ sɨbaŋ heŋ lalɨgu lalɨgu saŋ hɨcavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Havɨlɨ ulaŋ vivi saŋ hɨda kɨlɨ akasɨ mibɨŋ hegulaŋ me agɨladɨ sɨhuvavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Hɨda sɨkasɨkan agɨladɨ hutesɨ 4 mita laci vihavɨmi. Kɨlɨ tɨbɨ tɨbɨ 66 senɨtamita agɨladɨ avi mɨgɨla mɨgɨla hɨda agɨladɨ lɨbukuvakuva saŋ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","24","Lɨba silɨva kum agɨladɨ haca hɨvɨ lalɨlamalama saŋ hɨda agɨladɨ hɨdɨlɨ lɨhua vɨlɨbɨlɨŋ lɨdɨŋ lamavɨmi. Hɨda sɨkasɨkan agɨladɨ hameŋ laci lɨhavɨmi. Ium kɨlikɨli heŋ lalɨlamalama saŋ hɨda ahica lɨdɨŋ lɨbukuvavɨmi agɨladɨ lugɨlavɨci ua 20 hɨniavɨmi. Lɨhavɨci hɨda ahica lɨdɨŋ lɨbukuvavɨmi agɨladɨ lalɨlamalama saŋ lɨba silɨva agɨladɨ vivi kum kum 40 agɨladɨ lamavɨmi. Lavɨla lɨba silɨva kum agɨladɨ hɨvɨ haca lamavɨmi. La hɨda ahica lɨdɨŋ lɨbukuvavɨmi agɨladɨ lalɨlamalama saŋ lɨba silɨva kum haca daŋ haca daŋ agɨladɨ ahica lɨdɨŋ ahica lɨdɨŋ lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Lavɨla limu caba lakulamaŋ kɨlikɨli agadɨ avi hameŋ laci ala lɨhavɨmi. Hɨda ahica lɨdɨŋ lɨbukuvavɨmi agɨladɨ lugɨlavɨci ua 20 hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Lɨhavɨci hɨda ahica lɨdɨŋ lɨbukuvavɨmi agɨladɨ lalɨlamalama saŋ lɨba silɨva agɨladɨ vivi kum kum 40 agɨladɨ lamavɨmi. Lavɨla lɨba silɨva kum agɨladɨ hɨvɨ haca lamavɨmi. La hɨda ahica lɨdɨŋ lɨbukuvavɨmi agɨladɨ lalɨlamalama saŋ lɨba silɨva kum haca daŋ haca daŋ agɨladɨ ahica lɨdɨŋ ahica lɨdɨŋ lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Lavɨla havɨlɨ ulaŋ safɨli uaiaŋ mɨgumɨgu kɨlikɨli agadɨ avi hɨda ahica lɨdɨŋ lɨbukuvavɨmi agɨladɨ lugɨlavɨci ua human limu fɨhala human limu pabiŋ cɨjɨŋ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Lavɨla hɨda ahica lɨdɨŋ ahica lɨdɨŋ lɨbukuvavɨmi agɨladɨ vivi ulaŋ safɨli ikuŋ limu limu agɨlasaŋ lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Lamavɨci hɨda agɨladɨ fɨdɨm mikɨ heŋ lɨba golɨ hakɨ agɨladɨ lamavɨdaci mɨguavɨdaci iahua hɨvɨ agɨlaŋ pam laci hɨniavɨmi. Mɨga hɨdɨlɨ agɨlaŋ hɨtɨŋ hɨtɨŋ hɨniavɨmi. Ikuŋ limu agasaŋ avi hameŋ laci ala vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Hameŋ lɨhavɨci ulaŋ safɨli agadɨ hɨda ahica lɨdɨŋ lɨbukuvavɨmi agɨlaŋ human limu fɨhala human limu ahica pam cɨjɨŋ hɨniavɨmi. Lɨci lɨba silɨva kum haca daŋ haca daŋ human limu limu fɨhala hɨcɨ limu fɨhala hɨcɨ limu pabiŋ cɨjɨŋ agɨladɨ vihavɨmi. La hɨda ahica lɨdɨŋ lɨbukuvavɨmi agɨladɨ lalɨlamalama saŋ lɨba silɨva kum haca daŋ haca daŋ agɨladɨ ahica lɨdɨŋ ahica lɨdɨŋ lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","32","Lavɨla kɨlɨ akasɨ mibɨŋ hegulaŋ me agɨladɨ sɨlɨvɨŋ valɨ hutesɨ hutesɨ vihavɨmi. Kɨlɨ sɨlɨvɨŋ valɨ human limu fɨhala agɨladɨ limu madɨŋ hɨvɨ hɨgɨlavɨci hɨgɨlavɨci uu saŋ vihavɨmi. Kɨlɨ sɨlɨvɨŋ valɨ human limu fɨhala hɨhɨle agɨladɨ limu madɨŋ hɨvɨ hɨgɨlavɨci hɨgɨlavɨci uu saŋ vihavɨmi. Kɨlɨ sɨlɨvɨŋ valɨ human limu fɨhala limu hɨhɨle agɨladɨ ulaŋ safɨli uaiaŋ mɨgumɨgu kɨlikɨli heŋ hɨgɨlavɨci hɨgɨlavɨci uu saŋ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ulaŋ agadɨ madɨŋ limu limu hɨvɨ hɨgɨlavɨci hɨgɨlavɨci uu vɨdɨvɨdɨŋ igu igu saŋ kɨlɨ sɨlɨvɨŋ valɨ alɨhaŋ lamalama hɨsɨŋ agɨladɨ vivi ulaŋ agadɨdaŋ lama hɨlihalahala ihalahavɨmi. Ulaŋ safɨli uaiaŋ mɨgumɨgu kɨlikɨli agasaŋ avi hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Hɨda ahica lɨdɨŋ lɨbukuvavɨmi agɨladɨ lɨba golɨ hɨvɨ ifuhafihafi uavɨmi. Lavɨla kɨlɨ sɨlɨvɨŋ valɨ hutesɨ hutesɨ agɨladɨ hɨgɨlavɨci hɨgɨlavɨci uu saŋ lɨba golɨ hakɨ lamavɨmi. Kɨlɨ sɨlɨvɨŋ valɨ hutesɨ hutesɨ agɨladɨ avi lɨba golɨ hɨvɨ ifuhafihafi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Havɨlɨ mila huaci sɨbaŋ agadɨ viavɨla niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavɨmi agɨladɨ vivi hɨcavɨci hajɨŋ daŋ hɨnimi. Niagɨlɨŋ sihɨ sihɨ hɨcavɨmi agɨlaŋ Asɨ dɨ ciaŋ hali hɨsɨŋ vɨdɨvɨdɨŋ daŋ agɨladɨ mugaŋ lamɨgaŋ me hadipɨlɨ me hɨniavɨmi. Havɨlɨ agadɨ lɨbalavɨci kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ hɨsihala hɨnihɨni saŋ hɨcavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Hɨda limu ahica limu ahica kɨlɨ akasɨ mibɨŋ hegulaŋ me agɨladɨ vihavɨmi. Viavɨla lɨba golɨ hɨvɨ ifuhafihafi uavɨmi. Lavɨla havɨlɨ agadɨ agɨlimɨgumɨgu saŋ lɨba golɨ hɨvɨ agɨlɨŋ viavɨla hɨda agɨladɨ hɨvɨ lamalama lɨbɨhahavɨmi. Hɨda agɨladɨ lalɨlamalama saŋ lɨba silɨva kum haca daŋ haca daŋ limu ahica limu ahica agɨladɨ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Havɨlɨ ulaŋ agadɨ hɨbɨ ivu ivu heŋ hɨsihalahala saŋ havɨlɨ mila hekɨlɨ mu huaci sɨbaŋ agadɨ vihavɨmi. La niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavɨmi agɨladɨ vivi hɨcavɨmi. Hɨcavɨci hajɨŋ daŋ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Lɨci hɨda human limu fɨhala agɨladɨ vihavɨmi. Havɨlɨ lamalama agɨlimɨgumɨgu saŋ lɨba golɨ agɨlɨŋ agɨladɨ vivi hɨda hɨvɨ lamalama lɨbɨhahavɨmi. La hɨda fɨdɨm iahua hɨvɨ agɨladɨ lɨba golɨ hɨvɨ ifuhafihafi uavɨmi. Lavɨla lɨba golɨ cɨliŋ agɨladɨ viavɨla hɨda agɨladɨ sugɨ hahavɨmi. Hɨda agɨladɨ lalɨlamalama saŋ lɨba bɨlasɨ kum haca daŋ haca daŋ human limu fɨhala agɨladɨ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besalelɨ agaŋ sibɨla hɨsɨŋ hulaŋ hɨhɨle agɨlaŋ hula kɨlɨ akasɨ cɨkaŋ cɨkaŋ mibɨŋ hegulaŋ me agɨladɨ hɨvɨ hɨbɨn hɨbɨn sibɨla vihavɨmi. Nudɨ hutesɨ agadɨ 110 senɨtamita vihavɨmi. Nudɨ abɨŋ agadɨ 66 senɨtamita vihavɨmi. Nudɨ tulɨ agadɨ avi 66 senɨtamita ala vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","La lɨba golɨ huaci sɨbaŋ agadɨ hɨvɨ kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ tulɨ agadɨdaŋ nudɨ sabɨ agadɨdaŋ lamalama ifuhafiavɨmi. Nudɨ caba caba agɨladɨ avi sɨkasɨkan lamalama ifuhafiavɨmi. La lɨba golɨ cɨliŋ cɨki mu hutesɨ agadɨ viavɨla kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ lamɨgaŋ hafilamalama uvɨ agadɨ mɨkamɨka heŋ haŋala haŋala ifuhafiavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ lamavɨci lagulama hɨnihɨni saŋ nudɨ lɨhu ikuŋ limu limu heŋ hɨcɨ tɨbɨ cɨki cɨki me agɨladɨ lamavɨmi. Lavɨla kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ havahava saŋ lɨba golɨ agadɨ viavɨla avɨŋ hɨvɨ hɨlavɨmi. Hɨlavɨci miŋɨlavɨla avɨli avɨli lɨci fɨli haca limu ahica limu ahica agɨladɨ hɨvɨ mɨŋamɨjiavɨci mɨguavɨla hakɨ daŋ hɨniavɨmi. Lɨhavɨci lɨba golɨ hakɨ ahica agɨladɨ viavɨla kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ caba limu heŋ lamavɨmi. Caba limu heŋ avi ahica ala lamavɨmi. Nudɨ hɨcɨ tɨbɨ cɨki cɨki me agɨladɨ mikɨ heŋ ala lɨba golɨ hakɨ agɨladɨ lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","La kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ havahava saŋ kɨlɨ akasɨ sɨlɨvɨ ahica mibɨŋ hegulaŋ me agɨladɨ lɨhuavɨmi. Lavɨla lɨba golɨ agadɨ hɨvɨ ifuhafihafi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","La kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ havahava saŋ kɨlɨ akasɨ sɨlɨvɨ ahica mibɨŋ hegulaŋ me agɨladɨ viavɨla kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ lɨba golɨ hakɨ heŋ limu caba limu caba hɨvɨ lamavɨci ivouavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","La lɨba golɨ huaci sɨbaŋ hɨvɨ kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ lamɨgaŋ vihavɨmi. Nudɨ hutesɨ 110 senɨtamita vihavɨmi. Nudɨ abɨŋ 66 senɨtamita vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Vivi lɨba golɨ agadɨ ifɨvɨnapɨna lɨdɨŋ via ua fɨdɨm limu limu agɨladɨ hɨvɨ Asɨ dɨ ciaŋ hali hɨsɨŋ vɨdɨvɨdɨŋ daŋ me ahica agɨladɨ lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Lamavɨci mu agaŋ limu caba lagulama hɨnimi. Mu agaŋ limu caba lagulama hɨnimi. Asɨ dɨ ciaŋ hali hɨsɨŋ vɨdɨvɨdɨŋ daŋ me ahica agɨladɨdaŋ kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ lamɨgaŋ agadɨdaŋ pam me laci vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Asɨ dɨ ciaŋ hali hɨsɨŋ vɨdɨvɨdɨŋ daŋ me ahica agɨlaŋ mavɨn hɨbɨŋ hɨbɨŋ lamavɨla kɨlɨ cɨkaŋ hɨbɨn hɨbɨn lamɨgaŋ agadɨ igasulasula hɨniavɨmi. Nulɨdɨ abɨŋ agɨladɨ mɨŋaiahavɨci kɨlɨ cɨkaŋ hɨbɨn hɨbɨn lamɨgaŋ agadɨ lalɨguavɨla hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Lɨhavɨci vadɨm mu kɨlɨ akasɨ mibɨŋ hegulaŋ me agɨladɨ hɨvɨ ibilavɨmi. Nudɨ hutesɨ agadɨ 88 senɨtamita lamavɨmi. Nudɨ abɨŋ agadɨ 44 senɨtamita lamavɨmi. Vadɨm agadɨ iahua hɨvɨ hɨnia fɨli mɨgamɨga agadɨ 66 senɨtamita lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","La lɨba golɨ huaci sɨbaŋ agadɨ hɨvɨ lamalama sɨkasɨkan ifuhafiavɨmi. Lavɨla lɨba golɨ cɨliŋ cɨki mu viavɨla vadɨm agadɨ mɨkamɨka heŋ haŋala haŋala ifuhafiavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Lɨba golɨ mu agadɨ ifavɨci abɨŋ nudɨ 8 senɨtamita hɨnimi. Lɨci vadɨm agaŋ vɨdɨvɨdɨŋ hɨnihɨni saŋ vadɨm agadɨ hɨlɨ mɨgua fɨli mikɨ heŋ sɨkasɨkan haŋala haŋala ifuhafiavɨmi. Lavɨla lɨba golɨ cɨliŋ agadɨ avi lɨba golɨ mu ifɨvɨnapɨna lɨhavɨmi agadɨ sabɨ hɨvɨ haŋala haŋala ifuhafiavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","La vadɨm agadɨ havahava saŋ lɨba golɨ hakɨ vihavɨmi. Viavɨla vadɨm agadɨ hɨlɨ lalɨlamalama hɨsɨŋ limu ahica limu ahica agɨladɨ hɨvɨ hɨtɨŋ hɨtɨŋ lamalama ifuhafiavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Lɨba golɨ cɨliŋ cɨki vadɨm hɨlɨ agɨladɨ haŋala haŋala lamalama ifuhafiavɨmi heŋ ala lɨba golɨ hakɨ agɨladɨ avi ifuhafiavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","La vadɨm agadɨ havahava saŋ kɨlɨ akasɨ sɨlɨvɨ ahica mibɨŋ hegulaŋ me agɨladɨ lɨhuavɨmi. Lavɨla lɨba golɨ hɨvɨ ifuhafihafi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","La lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ mɨŋamɨjimɨji sagalɨ igu igu saŋ sɨbɨ hɨlɨcɨ agɨladɨdaŋ hɨcɨhaŋ agɨladɨdaŋ vihavɨmi. Hunaŋ mɨsɨn agɨladɨdaŋ hunaŋ sudɨme cɨki cɨki agɨladɨdaŋ vihavɨmi. Akuaba akuaba agɨladɨ lɨba golɨ huaci sɨbaŋ hɨvɨ laci vihavɨmi. Hunaŋ mɨsɨn hunaŋ sudɨme cɨki sɨbɨ hɨlɨcɨ hɨcɨhaŋ agɨlaŋ vadɨm sabɨ hɨvɨ hɨniavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Lɨba golɨ huaci sɨbaŋ agadɨ viavɨla ifɨvɨnapɨna lɨdɨŋ unɨ lamalama hɨsɨŋ hɨlɨ agadɨ vihavɨmi. Lavɨla unɨ lamalama hɨsɨŋ hɨlɨ agadɨ lalɨlamalama saŋ hɨdɨlɨ nudɨ agadɨ abɨŋ daŋ vihavɨmi. La makaŋ hɨtɨŋ hɨtɨŋ unɨ lamalama uvɨ daŋ agɨladɨ avi vihavɨmi. Lavɨla lɨba golɨ huaci sɨbaŋ agadɨ laci ala ifɨvɨnapɨna lɨdɨŋ kɨlɨ fu hajɨŋ daŋ hɨniadami hameŋ agɨladɨ vihavɨmi. Akuaba akuaba agɨladɨ vihavɨci pabiŋ me laci hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Unɨ lamalama hɨsɨŋ hɨlɨ agaŋ makaŋ human limu fɨhala human limu pabiŋ cɨjɨŋ daŋ hɨnimi. Limu caba ahica pam makaŋ hɨniavɨmi. Limu caba avi ahica pam makaŋ ala hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Kɨlɨ amon agadɨ fu hajɨŋ me agɨlaŋ makaŋ hɨtɨŋ hɨtɨŋ hɨvɨ ahica pam lɨdɨŋ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Unɨ lamalama hɨsɨŋ hɨlɨ agadɨ pɨlɨ hɨvɨ kɨlɨ amon agadɨ fu hajɨŋ me limu ahica limu ahica agɨladɨ vihavɨci hɨtɨŋ hɨtɨŋ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Makaŋ ahica limu limu hɨniavɨmi agɨladɨ hɨdɨlɨ heŋ kɨlɨ fu hajɨŋ me agɨladɨ lɨhu hɨvɨ asɨŋ cɨki cɨki me agɨladɨ vihavɨmi. Makaŋ ahica limu limu agɨladɨ hɨdɨlɨ heŋ hameŋ laci ala vihavɨmi. La makaŋ ahica limu limu agɨladɨ hɨdɨlɨ heŋ avi hameŋ laci ala vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Lɨba golɨ huaci sɨbaŋ agadɨ ifɨvɨnapɨna lɨdɨŋ akuaba akuaba agɨladɨ vihavɨci pabiŋ me laci hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Lɨci lɨba golɨ huaci sɨbaŋ hɨvɨ unɨ human limu fɨhala human limu ahica cɨjɨŋ agɨladɨ vihavɨmi. Lavɨla lɨba golɨ huaci sɨbaŋ agadɨ viavɨla husɨmiŋ unɨ fu mɨŋamɨŋa hɨsɨŋ agadɨdaŋ hunaŋ hɨhɨle agɨladɨdaŋ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Lɨba golɨ huaci sɨbaŋ agadɨ viavɨla unɨ lamalama hɨsɨŋ hɨlɨ agadɨdaŋ nudɨ akuaba akuaba agɨladɨdaŋ vihavɨmi agɨladɨ vɨhɨlɨ 35 kilogɨlam. ");
INSERT INTO ena_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Kɨlɨ akasɨ mibɨŋ hegulaŋ me agɨladɨ viavɨla cihu savu me hɨsi huaci huaci daŋ agɨladɨ hɨlahɨla hɨsɨŋ vadɨm vihavɨmi. Vihavɨci vadɨm agadɨ hutesɨ agaŋ 45 senɨtamita hɨnimi. Nudɨ abɨŋ agaŋ avi 45 senɨtamita ala hɨnimi. Ahica hɨlihɨli laci hɨniavɨmi. Vadɨm agadɨ iahua hɨvɨ hɨnia fɨli mɨgamɨga agaŋ 90 senɨtamita hɨnimi. Kɨlɨ akasɨ mibɨŋ hegulaŋ me agɨladɨ lɨhuavɨci kum limu ahica limu ahica daŋ hɨnimi. Kum pabiŋ pabiŋ ikuŋ limu limu hɨvɨ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Lɨhavɨci vadɨm agadɨ madɨŋ limu limu agɨladɨdaŋ nudɨ fɨdɨm limu limu agɨladɨdaŋ lɨba golɨ huaci sɨbaŋ hɨvɨ lamalama ifuhafiavɨmi. Nudɨ sabɨ agadɨ lɨba golɨ huaci sɨbaŋ hɨvɨ lamalama ifuhafiavɨmi. Kum limu ahica limu ahica ikuŋ limu limu hɨniavɨmi agɨladɨ avi lɨba golɨ huaci sɨbaŋ hɨvɨ lamalama ifuhafiavɨmi. La lɨba golɨ cɨliŋ cɨki agadɨ hɨvɨ vadɨm mɨkamɨka agadɨ caba caba heŋ haŋala haŋala ifuhafiavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Vadɨm agadɨ havahava saŋ lɨba golɨ hakɨ ahica agɨladɨ viavɨla vadɨm agadɨ madɨŋ limu limu hɨvɨ lamavɨmi. Lɨba golɨ cɨliŋ cɨki haŋala haŋala ifuhafiavɨmi agadɨ lɨhu heŋ ala lɨba golɨ hakɨ agɨladɨ lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Vadɨm agadɨ havahava saŋ kɨlɨ akasɨ sɨlɨvɨ ahica mibɨŋ hegulaŋ me agɨladɨ lɨhuavɨmi. Lavɨla lɨba golɨ hɨvɨ ifuhafihafi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Cihu savu me hɨhɨle agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavɨla akuaba akuaba Asɨ saŋ lɨbɨmɨŋɨben aba nulɨdɨ sabɨ hɨvɨ mɨŋamɨjimɨji hɨsɨŋ agɨladɨ eŋalavɨmi. Lavɨla cihu savu me hɨhɨle hɨlavɨci hɨsi huaci huaci iahaiaha hɨsɨŋ agɨladɨ eŋalavɨmi. Akuaba akuaba hɨsi huaci huaci daŋ eŋala iga iga hɨsɨŋ hulaŋ agɨlaŋ eŋalavɨhadami me eŋalavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Besalelɨ agaŋ sibɨla hɨsɨŋ hulaŋ hɨhɨle agɨlaŋ hula kɨlɨ akasɨ mibɨŋ hegulaŋ me agɨladɨ viavɨla sagalɨ hɨlahɨla hɨsɨŋ vadɨm vihavɨmi. Vihavɨci nudɨ hutesɨ agaŋ 220 senɨtamita hɨnimi. Nudɨ abɨŋ agaŋ avi 220 senɨtamita hɨnimi. Ahica hɨlihɨli hameŋ laci hɨniavɨmi. Vadɨm agadɨ iahua hɨvɨ hɨnia fɨli mɨgamɨga agaŋ 130 senɨtamita hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Lɨci kɨlɨ akasɨ mibɨŋ hegulaŋ me agɨladɨ lɨhuavɨci kum limu ahica limu ahica daŋ hɨnimi. Kum pabiŋ pabiŋ agɨlaŋ ikuŋ limu limu hɨvɨ hɨniavɨmi. Lɨhavɨci sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ lɨba bɨlasɨ hɨvɨ sɨkasɨkan ifuhafihafi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Lavɨla lɨba bɨlasɨ hɨvɨ hunaŋ mɨsɨn hekɨlɨ hekɨlɨ limu hɨhɨle agɨladɨ vihavɨmi. Avɨŋ ibɨlɨ licilici saŋ sami hekɨlɨ hekɨlɨ me agɨladɨ vihavɨmi. Hunaŋ mɨsɨn sɨhɨm mɨdɨ hɨniavɨdaci vivi sevaseva hɨsɨŋ agɨladɨ vihavɨmi. Akuaba akuaba avɨŋ hɨvɨ hɨniavɨdaci iamɨla iamɨla vivi hɨsɨŋ agɨladɨ vihavɨmi. La hunaŋ hɨhɨle avɨŋ sɨvɨ me agadɨ lama via hɨdahɨda hɨsɨŋ agɨladɨ avi vihavɨmi. Sagalɨ hɨlahɨla hɨsɨŋ vadɨm heŋ sibɨla vivi saŋ hunaŋ mɨsɨn akuaba akuaba agɨladɨ lɨba bɨlasɨ hɨvɨ laci vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","5","Lavɨla lɨba bɨlasɨ hɨvɨ mɨkɨdiŋ tulɨ me agadɨ vihavɨmi. Mɨkɨdiŋ tulɨ me heŋ avɨŋ makaŋ lamalama sɨhɨm sabaŋ akuaba akuaba agɨladɨ avɨŋ makaŋ sabɨ hɨvɨ lamalama avɨŋ hɨvɨ hɨlahɨla saŋ vihavɨmi. Viavɨla vadɨm agadɨ havahava saŋ hakɨ limu ahica limu ahica vihavɨmi. La hakɨ agɨladɨ viavɨla ikuŋ limu limu hɨvɨ lamavɨmi. Lavɨla lɨba bɨlasɨ cɨliŋ hekɨlɨ mu agadɨ viavɨla sagalɨ hɨlahɨla hɨsɨŋ vadɨm mɨkamɨka agadɨ hɨvɨ lɨba bɨlasɨ mɨkɨdiŋ tulɨ me agadɨ ifɨmɨgamɨga lamalama ifuhafiavɨmi. Ifuhafiavɨci lɨba bɨlasɨ mɨkɨdiŋ tulɨ me agaŋ vadɨm mɨkamɨka agadɨ lɨvala mɨgua alɨhaba hɨvɨ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Lɨci kɨlɨ akasɨ sɨlɨvɨ ahica mibɨŋ hegulaŋ me agɨladɨ lɨhuavɨla lɨba bɨlasɨ hɨvɨ ifuhafihafi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Lavɨla sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ havahava saŋ kɨlɨ sɨlɨvɨ agɨladɨ viavɨla hakɨ madɨŋ limu limu hɨniavɨmi agɨladɨ hɨvɨ lamavɨci ivouavɨmi. Sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ kɨlɨ cɨkaŋ hɨvɨ vihavɨmi. Vihavɨci hɨbɨn hɨbɨn me hɨnimi. Agadɨ ala vadɨm mɨgua lɨhu fɨli hɨvɨ lamalama hɨsɨŋ agadɨ kɨlɨ cɨkaŋ ma lamavɨmi. Valavɨci havɨ tuŋ daŋ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Iamɨgali hɨhɨle Asɨ hula mɨgudɨba ciaŋ aba aba hɨsɨŋ havɨlɨ ulaŋ agadɨ hɨbɨ ivu ivu heŋ sibɨla vihavɨhadami. Nɨbɨlaŋ Besalelɨ saŋ lɨba bɨlasɨ mugaŋ lamɨgaŋ iga iga hɨsɨŋ agɨladɨ iguavɨmi. Iguavɨci sibɨla hɨsɨŋ hulaŋ agɨlaŋ lɨba bɨlasɨ agadɨ viavɨla hɨcɨ human husahusa hɨsɨŋ hunaŋ mɨsɨn hekɨlɨ agadɨdaŋ nudɨ lamɨci hɨnihɨni hɨsɨŋ vadɨm agadɨdaŋ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Lavɨla havɨlɨ mila hekɨlɨ hekɨlɨ huaci huaci sɨbaŋ agɨladɨ hɨvɨ havɨlɨ ulaŋ haiabɨla agadɨ caba caba heŋ lua me hahahaha saŋ vihavɨmi. Madɨŋ limu ium kɨlikɨli agasaŋ vihavɨci 44 mita hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Hɨda 20 agɨladɨ viavɨla lɨba bɨlasɨ hɨvɨ ifuhafihafi uavɨmi. Hɨda agɨladɨ lalɨlamalama saŋ lɨba bɨlasɨ kum haca daŋ haca daŋ 20 agɨladɨ vihavɨmi. Lɨba silɨva hɨvɨ agɨlɨŋ hɨhɨle vihavɨmi. Havɨlɨ mila hekɨlɨ huaci sɨbaŋ agadɨ lɨbala lɨbala saŋ lɨba silɨva agɨlɨŋ agɨladɨ lɨba silɨva cɨliŋ hɨda sugɨ hahavɨmi agɨladɨ hɨvɨ agɨlimɨgumɨgu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Madɨŋ limu lakulamaŋ kɨlikɨli agasaŋ havɨlɨ mila hekɨlɨ agadɨ vihavɨci 44 mita hɨnimi. Hɨda 20 agɨladɨ viavɨla lɨba bɨlasɨ hɨvɨ ifuhafihafi uavɨmi. Hɨda lalɨlamalama saŋ lɨba bɨlasɨ kum haca daŋ haca daŋ 20 agɨladɨ vihavɨmi. Lɨba silɨva hɨvɨ agɨlɨŋ hɨhɨle vihavɨmi. Havɨlɨ mila hekɨlɨ huaci sɨbaŋ agadɨ lɨbala lɨbala saŋ lɨba silɨva agɨlɨŋ agɨladɨ viavɨla lɨba silɨva cɨliŋ hɨda sugɨ hahavɨmi agɨladɨ hɨvɨ agɨlimɨgumɨgu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ulaŋ safɨli uaiaŋ mɨgumɨgu kɨlikɨli agadɨ haiabɨla heŋ lɨbalavɨci lua me hɨnihɨni saŋ havɨlɨ mila hekɨlɨ huaci sɨbaŋ agadɨ vihavɨci 22 mita hɨnimi. Hɨda human limu limu fɨhala agɨladɨ viavɨla lɨba bɨlasɨ hɨvɨ ifuhafihafi uavɨmi. Hɨda agɨladɨ lalɨlamalama saŋ lɨba bɨlasɨ kum haca daŋ haca daŋ human limu limu fɨhala agɨladɨ vihavɨmi. Lɨba silɨva hɨvɨ agɨlɨŋ hɨhɨle vihavɨmi. Havɨlɨ mila hekɨlɨ huaci sɨbaŋ agadɨ lɨbala lɨbala saŋ lɨba silɨva agɨlɨŋ agɨladɨ lɨba silɨva cɨliŋ hɨda sugɨ hahavɨmi agɨladɨ hɨvɨ agɨlimɨgumɨgu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ulaŋ hali hɨbɨ uaiaŋ iahaiaha kɨlikɨli agadɨ haiabɨla heŋ lɨbalavɨci lua me hɨnihɨni saŋ havɨlɨ mila hekɨlɨ huaci sɨbaŋ agadɨ vihavɨci 22 mita hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Hɨbɨ ivu ivu limu caba agasaŋ havɨlɨ mila huaci sɨbaŋ vihavɨci 660 senɨtamita hɨnimi. Hɨbɨ ivu ivu limu caba agasaŋ avi havɨlɨ mila huaci sɨbaŋ vihavɨci 660 senɨtamita hɨnimi. Hɨbɨ ivu ivu limu caba agasaŋ hɨda ahica pam agɨladɨ viavɨla lɨba bɨlasɨ hɨvɨ ifuhafihafi uavɨmi. Hɨda agɨladɨ lalɨlamalama saŋ lɨba bɨlasɨ kum haca daŋ haca daŋ ahica pam agɨladɨ vihavɨmi. Hɨbɨ ivu ivu limu caba agasaŋ avi hɨda ahica pam agɨladɨ viavɨla lɨba bɨlasɨ hɨvɨ ifuhafihafi uavɨmi. Hɨda agɨladɨ lalɨlamalama saŋ lɨba bɨlasɨ kum haca daŋ haca daŋ ahica pam agɨladɨ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Havɨlɨ ulaŋ haiabɨla agadɨ haŋala haŋala lua me hahahaha saŋ havɨlɨ mila huaci huaci sɨbaŋ agɨladɨ laci vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Hɨda agɨladɨ lalɨlamalama saŋ lɨba bɨlasɨ kum haca daŋ haca daŋ agɨladɨ vihavɨmi. Lavɨla hɨda fɨdɨm iahua agɨladɨ lɨba silɨva hɨvɨ ifuhafihafi uavɨmi. Lavɨla lɨba silɨva cɨliŋ agɨladɨ vivi hɨda sɨkasɨkan agɨladɨ sugɨ hɨvɨ hahahaha uavɨmi. La lɨba silɨva hɨvɨ agɨlɨŋ viavɨla lɨba silɨva cɨliŋ agɨladɨ hɨvɨ agɨlimɨgumɨgu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Hɨbɨ ivu ivu amɨŋ agadɨ hɨsihalahala saŋ havɨlɨ mila huaci sɨbaŋ vihavɨci 9 mita hɨnimi. Lɨci niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavɨmi agɨladɨ vivi hɨcavɨmi. Hɨcavɨci hajɨŋ daŋ hɨnimi. Havɨlɨ hɨbɨ ivu ivu amɨŋ agadɨ hɨsihalahala hɨsɨŋ agadɨ iahua hɨvɨ hɨnia fɨli mɨgamɨga agaŋ 220 senɨtamita hɨnimi. Ulaŋ haiabɨla agadɨ madɨŋ limu limu safɨli hali hɨbɨ lamalama lɨbala lɨbala lua me hahavɨmi agɨladɨ iahua hɨvɨ hɨnia fɨli mɨgamɨga agɨlaŋ 220 senɨtamita laci hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","La havɨlɨ hɨbɨ ivu ivu amɨŋ agadɨ hɨsihalahala saŋ hɨda limu ahica limu ahica vihavɨmi. La hɨda agɨladɨ lalɨlamalama saŋ lɨba bɨlasɨ kum haca daŋ haca daŋ limu ahica limu ahica agɨladɨ vihavɨmi. Lavɨla hɨda fɨdɨm iahua agɨladɨ lɨba silɨva hɨvɨ ifuhafiavɨmi. La lɨba silɨva cɨliŋ agɨladɨ hɨvɨ hɨda agɨladɨ sugɨ hahavɨmi. La lɨba silɨva hɨvɨ agɨlɨŋ viavɨla lɨba silɨva cɨliŋ agɨladɨ hɨvɨ agɨlimɨgumɨgu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Havɨlɨ ulaŋ agadɨdaŋ nudɨ lua me agadɨdaŋ vɨdɨvɨdɨŋ igu igu saŋ lɨba bɨlasɨ henaŋ hutesɨ hutesɨ agɨladɨ vihavɨmi. Fɨli hɨvɨ ifavɨci ifavɨci mɨguavɨdaci lɨmɨn havɨlɨ ulaŋ hɨsɨŋ agɨladɨdaŋ nudɨ lua me hɨsɨŋ agɨladɨdaŋ magɨla magɨla hahahaha saŋ lɨba bɨlasɨ henaŋ hutesɨ hutesɨ agɨladɨ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Mosesɨ agaŋ Livai hɨdɨlɨ agɨladɨ abɨci havɨlɨ ulaŋ vivi hɨsɨŋ akuaba akuaba agɨladɨ lugɨlavɨmi. Lugɨlavɨla manasɨŋ hɨvɨ lɨbavɨla sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ Alon dɨ ninanu Itamalɨ saŋ iguavɨmi. Nɨbu Livai hɨdɨlɨ agɨladɨ migɨladami. Lɨba cɨkaŋ ahica Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ daŋ agɨladɨ via havɨlɨ uleŋ muji heŋ lamalama saŋ vibalu aba akuaba akuaba agɨladɨ lugɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Besalelɨ nɨbu Juda hɨdɨlɨ. Nudɨ iaganu Oli. Nudɨ iauacanu Holɨ. Nɨbu Asɨ Iaue akuaba akuaba sibɨla vivi saŋ Mosesɨ dɨ abami agɨladɨ vimi. ");
INSERT INTO ena_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Oholiapɨ avi sibɨla vimi. Nɨbu Dan hɨdɨlɨ. Nudɨ iaganu Ahisamakɨ. Nɨbu lɨba hɨvɨ ihatɨbutɨbu sihɨ sihɨ lamalama hɨsɨŋ hɨji huaci daŋ hɨniadami. Nɨbu niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavɨmi agɨladɨ vivi havɨlɨ mila huaci huaci sɨbaŋ agɨladɨ hɨvɨ hɨcahɨca hajɨŋ lamalama hɨsɨŋ hɨji huaci daŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Hulaŋ iamɨgali agɨlaŋ Asɨ dɨ havɨlɨ ulaŋ akuaba akuaba agɨladɨ vivi saŋ lɨba golɨ Asɨ saŋ sagalɨ igubalu aba hɨjɨŋalaŋala vavehavɨmi. Vavehavɨci nulɨdɨ vɨhɨlɨ iga iga lugɨla lugɨla lamavɨci vɨhɨlɨ nudɨ 998 kilogɨlam hɨnimi. Lɨba golɨ akuaba akuaba agɨladɨ vavevave Asɨ dɨ havɨlɨ ulaŋ caba heŋ akuaba akuaba lamalama vɨhɨlɨ sɨhɨvia sɨbaŋ iga iga lugɨlavɨhadami hameŋ ala vɨhɨlɨ iga iga lugɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","26","Lɨba silɨva agɨladɨ lamalama vɨhɨlɨ iga iga lugɨlavɨci ua nudɨ vɨhɨlɨ 3,430 kilogɨlam hɨnimi. Hulaŋ nulɨdɨ ibi manasɨŋ hɨvɨ lɨbavɨmi agɨlaŋ ala lɨba silɨva agɨladɨ vavehavɨmi. Hulaŋ agɨladɨ hualɨ lugɨlavɨci ua human limu limu fɨhala hɨcɨ limu limu fɨhala iahami agɨladɨ hɨdɨlɨ maha ibi sɨkasɨkan vivi via ua hulaŋ hadi hadi agɨladɨ avi sɨkasɨkan vihavɨmi. Hulaŋ ibi vihavɨmi agɨladɨ lugɨlavɨci ua 603,550 iahami. Lɨci nɨbɨlaŋ ala anɨm hɨlɨcɨ sekelɨ uavɨhadami agadɨ limu cɨkaŋ Asɨ saŋ sagalɨ iguavɨmi. Asɨ dɨ havɨlɨ ulaŋ caba heŋ akuaba akuaba lamalama vɨhɨlɨ sɨhɨvia sɨbaŋ iga iga lugɨlavɨhadami hameŋ ala lɨba silɨva agɨladɨ lamalama vɨhɨlɨ agadɨ iga iga lugɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","La hɨda ahica lɨdɨŋ lɨbukuvavɨmi agɨladɨ lalɨlamalama saŋ lɨba silɨva kum haca daŋ haca daŋ agɨladɨ vihavɨmi. Havɨlɨ uleŋ muji alɨhaŋ hɨnilaha lɨbala lɨbala hɨsɨŋ havɨlɨ agadɨ hɨda lalɨlamalama saŋ avi lɨba silɨva kum haca daŋ haca daŋ agɨladɨ vihavɨmi. Lɨhavɨci lɨba silɨva kum agɨlaŋ 100 hɨniavɨmi. Lɨba silɨva kum pabiŋ pabiŋ agɨladɨ vɨhɨlɨ 34 kilogɨlam hɨniavɨmi. Nulɨdɨ vɨhɨlɨ sɨkasɨkan agɨladɨ lugɨlavɨci ua 3,400 kilogɨlam iahami. ");
INSERT INTO ena_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Lɨba silɨva limu cɨkaŋ havɨ hɨnimi agadɨ vɨhɨlɨ 30 kilogɨlam hɨnimi. Lɨci nudɨ hɨvɨ ala agɨlɨŋ hɨhɨle vihavɨmi. Lɨba silɨva cɨliŋ hɨda agɨladɨ sugɨ hahahaha saŋ vihavɨmi. La hɨda agɨladɨ fɨdɨm iahua agɨladɨ ifuhafihafi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Lɨba bɨlasɨ Asɨ Iaue saŋ igubalu aba hɨjɨŋalaŋala vavehavɨmi agɨladɨ sɨkasɨkan lamalama vɨhɨlɨ iga iga lugɨlavɨci ua 2,425 kilogɨlam hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Lɨci lɨba bɨlasɨ agadɨ viavɨla Asɨ dɨ havɨlɨ ulaŋ hɨbɨ ivu ivu agadɨ hɨda lalɨlamalama saŋ lɨba kum haca daŋ haca daŋ agɨladɨ vihavɨmi. Lɨba bɨlasɨ agadɨ hɨvɨ ala sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨdaŋ nudɨ mɨkɨdiŋ me agadɨdaŋ vihavɨmi. Nudɨ hunaŋ akuaba akuaba sibɨla vivi hɨsɨŋ agɨladɨ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Havɨlɨ ulaŋ haiabɨla agadɨ lua me agadɨ hɨda lalɨlamalama saŋ lɨba kum haca daŋ haca daŋ agɨladɨ vihavɨmi. Lua me agadɨ hɨbɨ ivu ivu agadɨ hɨda lalɨlamalama saŋ lɨba kum haca daŋ haca daŋ agɨladɨ vihavɨmi. Havɨlɨ ulaŋ agadɨdaŋ nudɨ lua me agadɨdaŋ vɨdɨvɨdɨŋ igu igu saŋ lɨba bɨlasɨ henaŋ hutesɨ hutesɨ agɨladɨ vihavɨmi. Fɨli hɨvɨ ifavɨci ifavɨci mɨguavɨdaci lɨmɨn havɨlɨ ulaŋ hɨsɨŋ agɨladɨdaŋ nudɨ lua me hɨsɨŋ agɨladɨdaŋ magɨla magɨla hahahaha saŋ lɨba bɨlasɨ henaŋ hutesɨ hutesɨ agɨladɨ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavɨmi agɨladɨ vihavɨmi. Viavɨla hadi hɨlahɨla huaci huaci Asɨ saŋ sagalɨ igu igu hɨsɨŋ hulaŋ agɨlasaŋ hɨcavɨmi. Hadi hɨlahɨla agɨladɨ ahuala lamalama uaiaŋ pabiŋ pabiŋ sagalɨ igu igu hɨsɨŋ uvɨ havɨlɨ uleŋ muji heŋ ivoua sibɨla vivi saŋ hɨcavɨmi. La Asɨ saŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ Alon saŋ avi hadi hɨlahɨla huaci huaci agɨladɨ hɨcavɨmi. Asɨ Iaue Mosesɨ dɨ abami hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","3","Lɨba golɨ agadɨ viavɨla ifɨvɨnapɨna lɨhavɨci manasɨŋ me hɨnimi. Lɨci viavɨla sudɨme cɨki cɨki lɨdɨŋ sɨhɨlavɨdaci niagɨlɨŋ me hɨniavɨmi. Lɨhavɨci niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavɨmi agɨladɨdaŋ lɨba golɨ niagɨlɨŋ agɨladɨdaŋ vihavɨmi. Viavɨla havɨlɨ mila huaci sɨbaŋ agadɨ hɨvɨ hɨcavɨci sihɨ sihɨ daŋ hɨnimi. Lɨci nudɨ hɨvɨ havɨlɨ cɨliŋ daŋ agadɨ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","La havɨlɨ agaŋ sɨlɨhala mɨgɨmɨdɨ aba cɨliŋ ahica macɨŋ limu limu hɨvɨ huliavalɨci mɨgamɨga saŋ havɨlɨ agadɨ hɨvɨ lamalama hɨcavɨmi. Mavɨn hɨbɨ hɨsɨŋ agadɨ hɨvɨ lamalama hɨcavɨmi. Hulɨpɨŋ hɨsɨŋ agadɨ hɨvɨ avi lamalama hɨcavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","La havɨlɨ cɨliŋ daŋ agadɨ lavi me vivi saŋ nameŋ lɨhavɨmi. Niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavɨmi agɨladɨdaŋ lɨba golɨ niagɨlɨŋ agɨladɨdaŋ vihavɨmi. Lavɨla havɨlɨ mila huaci sɨbaŋ mu agadɨ hɨvɨ hɨcavɨci sihɨ sihɨ daŋ hɨnimi. Lɨci lavi me agadɨ viavɨla havɨlɨ cɨliŋ daŋ agadɨ fɨdɨm hɨvɨ lama hɨcavɨci havɨlɨ sihɨ sihɨ daŋ laci hɨnimi. Asɨ Iaue Mosesɨ dɨ abami hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","La lɨba hɨlɨcɨ konilian ahica agɨladɨ viavɨla hulaŋ mu lɨba hɨvɨ ibi ihasihɨsihɨ lɨhadami agasaŋ iguavɨci Jekopɨ ninadinu agɨladɨ ibi lɨba hɨlɨcɨ ahica agɨladɨ hɨvɨ ihasihɨsihɨ lɨmi. Ihasihɨsihɨ lavɨla lɨba hɨlɨcɨ ahica hulaŋ ibi daŋ agɨladɨ via lɨba golɨ hajɨŋ cɨki cɨki havaŋ avɨli veve agadɨ ulaŋ tulɨ me ahica agɨladɨ hɨvɨ lamɨci mɨguavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Mɨguavɨci havɨlɨ cɨliŋ macɨŋ limu limu hɨniavɨmi agɨladɨ hɨvɨ macɨŋ sabɨ heŋ lama lɨbɨhahami. Asɨ Iaue Mosesɨ dɨ abami hameŋ laci ala lɨhavɨmi. Lɨhavɨci lɨba hɨlɨcɨ ahica agɨlaŋ macɨŋ limu limu hɨvɨ hɨniavɨdaci Asɨ lɨba hɨlɨcɨ agɨladɨ iga iga Isɨlaelɨ hɨdɨlɨ agɨlasaŋ igahɨladami. ");
INSERT INTO ena_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavɨmi agɨladɨdaŋ lɨba golɨ niagɨlɨŋ agɨladɨdaŋ vihavɨmi. Viavɨla havɨlɨ mila huaci sɨbaŋ agadɨ hɨvɨ hɨcavɨci sihɨ sihɨ daŋ hɨnimi. Havɨlɨ cɨliŋ daŋ agadɨ sihɨ me hɨnimi. Lɨci nudɨ viavɨla Asɨ saŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ agasaŋ sugɨ vaŋ me agadɨ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Sugɨ vaŋ me agadɨ hutesɨ 44 senɨtamita hɨnimi. Nudɨ abɨŋ agaŋ 22 senɨtamita hɨnimi. Lɨci nudɨ hutesɨ agadɨ alɨhaŋ lama mɨŋafɨhulavɨci ve hɨlihɨli laci hɨnimi. Lɨci hutesɨ agaŋ 22 senɨtamita hɨnimi. Nudɨ abɨŋ avi 22 senɨtamita hɨnimi. Lavɨla ahica hɨlihɨli laci hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Lɨhavɨci sugɨ vaŋ me agadɨ hɨvɨ lɨba hɨlɨcɨ anɨm hɨlɨcɨ hekɨlɨ hɨvɨ lavavɨhadami agɨladɨ sɨlɨ limu ahica limu ahica lamalama lɨbɨhahavɨmi. Sɨlɨ mu hɨvɨ lɨba lobi lɨba topasɨ lɨba ganetɨ agɨladɨ lamalama lɨbɨhahavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Sɨlɨ mu agadɨ hɨvɨ lɨba emelalɨ lɨba sapaia lɨba daimon agɨladɨ lamalama lɨbɨhahavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Sɨlɨ mu hɨvɨ lɨba telɨkoisɨ lɨba agetɨ lɨba ametisɨ agɨladɨ lamalama lɨbɨhahavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Sɨlɨ mu hɨvɨ lɨba belilɨ lɨba konilian lɨba jasɨpa agɨladɨ lamalama lɨbɨhahavɨmi. Lɨba hɨlɨcɨ agɨladɨ lɨba golɨ hajɨŋ cɨki cɨki havaŋ avɨli veve agadɨ ulaŋ tulɨ me agɨladɨ hɨvɨ lamavɨci mɨgua hɨniavɨdaci sugɨ vaŋ me agadɨ hɨvɨ lamalama lɨbɨhahavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Lɨba hɨlɨcɨ agɨladɨ hɨvɨ Jekopɨ ninadinu human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ agɨladɨ ibi ihasihɨsihɨ lɨhavɨmi. Nɨbɨlaŋ Isɨlaelɨ hɨdɨlɨ hulaŋ latɨhiŋ agɨladɨ iamɨlɨhalinɨlu. ");
INSERT INTO ena_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Lɨhavɨci lɨba golɨ huaci sɨbaŋ agadɨ via ifavɨci ifavɨci ua hucɨŋ me hɨniavɨmi. Lɨhavɨci nulɨdɨ vivi lɨmɨn vɨdɨvɨdɨŋ tagɨlaŋ niagɨlɨŋ me ivavɨmi. Sugɨ vaŋ me agasaŋ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Lavɨla lɨba golɨ hajɨŋ cɨki cɨki havaŋ avɨli veve agadɨ ulaŋ tulɨ me ahica agɨladɨ vihavɨmi. Viavɨla lɨba golɨ hakɨ ahica vihavɨmi. Via sugɨ vaŋ me agadɨ fɨdɨm limu limu iahua sabɨ heŋ lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Lavɨla lɨmɨn vɨdɨvɨdɨŋ ahica lɨba golɨ hɨvɨ vihavɨmi agɨladɨ viavɨla sugɨ vaŋ me agadɨ lɨba golɨ hakɨ ahica heŋ hɨtɨŋ hɨtɨŋ hahavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","La lɨmɨn vɨdɨvɨdɨŋ fɨdɨm limu limu lɨba golɨ hɨvɨ vihavɨmi agɨladɨ viavɨla lɨba golɨ hajɨŋ cɨki cɨki havaŋ avɨli veve agadɨ ulaŋ tulɨ me agɨladɨ hɨvɨ hahavɨmi. Lɨba golɨ hajɨŋ agɨlaŋ Asɨ saŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ agadɨ havɨlɨ cɨliŋ daŋ nudɨ macɨŋ sabɨ limu limu hɨniavɨmi heŋ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Lɨba golɨ hakɨ ahica vihavɨmi. Viavɨla sugɨ vaŋ me agadɨ fɨdɨm limu limu mɨga hulɨpɨŋ heŋ lama lɨbɨhahavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Lavɨla cɨhu lɨba golɨ hakɨ ahica vihavɨmi. Viavɨla havɨlɨ cɨliŋ daŋ agadɨ hɨvɨ hahavɨmi. Havɨlɨ agadɨ cɨliŋ fɨdɨm agɨladɨ lavi me agadɨdaŋ lama hɨcavɨmi heŋ hahavɨmi. Mavɨn hɨbɨ hɨvɨ lama hɨcavɨmi heŋ hahavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","La niagɨlɨŋ cɨbɨŋ agɨladɨ vihavɨmi. Viavɨla sugɨ vaŋ me mɨga fɨdɨm limu limu agɨladɨ hɨvɨ lɨba golɨ hakɨ muji hahavɨmi heŋ niagɨlɨŋ cɨbɨŋ hahavɨmi. La havɨlɨ cɨliŋ daŋ agadɨ hɨvɨ lɨba golɨ hakɨ hahavɨmi heŋ niagɨlɨŋ cɨbɨŋ hahavɨmi. Lɨhavɨci manɨgali agaŋ hɨdɨdaci sugɨ vaŋ me agaŋ ma uu veve sese lɨhadami. Asɨ Iaue Mosesɨ dɨ abami hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","23","Niagɨlɨŋ cɨbɨŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavɨmi agɨladɨ hɨvɨ laci hadi hɨlahɨla agadɨ vihavɨci sihɨ sihɨ daŋ hɨnimi. Lavɨla hali hɨvɨ ahualɨci mɨgamɨga saŋ haca daŋ vihavɨmi. La haca agaŋ lalɨlahɨmɨdɨ aba havɨlɨ cɨliŋ agadɨ viavɨla haca mɨkamɨka agadɨ hɨvɨ lamalama hɨcavɨmi. Hɨcavɨci sagaŋ hɨsɨŋ hadi hɨlahɨla me hɨnimi. Lɨci Asɨ saŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ agaŋ hadi hɨlahɨla agadɨ hali hɨvɨ ahualɨci mɨgamɨga saŋ vihavɨmi. Hali hɨvɨ ahualɨci mɨgɨci havɨlɨ cɨliŋ daŋ agadɨ via nudɨ sabɨ lamalama saŋ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","26","Niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavɨmi agɨladɨ vihavɨmi. Viavɨla kɨlɨ pomigɨlanetɨ agadɨ amɨŋ me agɨladɨ hɨcavɨla hadi hɨlahɨla agadɨ fɨdɨm hɨvɨ lɨbala lɨbala uavɨmi. La lɨba golɨ huaci sɨbaŋ hɨvɨ iajɨ tɨbaŋ tɨbaŋ me agɨladɨ vihavɨmi. Viavɨla kɨlɨ pomigɨlanetɨ agadɨ amɨŋ me lɨbalavɨci alɨhaŋ tuŋ daŋ tuŋ daŋ hɨniavɨmi heŋ iajɨ tɨbaŋ tɨbaŋ me agɨladɨ lɨbala lɨbala uavɨmi. Lɨhavɨci Asɨ saŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ agaŋ hadi hɨlahɨla agɨladɨ lamalama sagalɨ igu igu hɨsɨŋ sibɨla vihadami. Asɨ Iaue Mosesɨ dɨ abami hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Niagɨlɨŋ mila huaci sɨbaŋ agadɨ viavɨla hadi hɨlahɨla hutesɨ hutesɨ agɨladɨ vihavɨci mila sihɨ sihɨ daŋ pam hɨniavɨmi. Alon sadaŋ ninadinu agɨlasadaŋ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Havɨlɨ mila huaci sɨbaŋ mu Alon dɨ hali hɨvɨ lɨbɨhahahaha saŋ vihavɨmi. Lavɨla cɨhu ninadinu agɨlasaŋ mɨlaŋ lɨpɨlɨpɨ me agɨladɨ vihavɨmi. Havɨlɨ mila huaci huaci sɨbaŋ hɨvɨ Alon sadaŋ ninadinu agɨlasadaŋ usaŋ tɨbɨ tɨbɨ agɨladɨ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Havɨlɨ mila huaci sɨbaŋ mu viavɨla lavi me agadɨ vihavɨmi. Viavɨla niagɨlɨŋ cɨbɨŋ niagɨlɨŋ mɨdɨ cɨbɨŋ niagɨlɨŋ mɨdɨ sɨbaŋ sabaŋ sipsipɨ mɨnɨ hɨvɨ ivavɨmi agɨladɨ vivi hɨcavɨci hajɨŋ daŋ hɨnimi. Asɨ Iaue Mosesɨ dɨ abami hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Lɨhavɨci hulaŋ mu lɨba hɨvɨ ciaŋ ihasihɨsihɨ lɨhadami agaŋ lɨba golɨ huaci sɨbaŋ agadɨ viavɨla hajɨŋ mu vimi. Viavɨla Asɨ Iaue saŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ hɨnihɨni saŋ hajɨŋ agadɨ hɨvɨ ciaŋ nameŋ ihasihɨsihɨ lɨci hɨnimi. Ha Asɨ Iaue dɨ aba ihasihɨsihɨ lɨci hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Lɨci niagɨlɨŋ cɨbɨŋ ivavɨmi. Lɨba golɨ hajɨŋ agadɨ Asɨ saŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ agadɨ havɨlɨ hali hɨvɨ lɨbɨhahahaha hɨsɨŋ agadɨ hɨvɨ lɨbala lɨbala saŋ vihavɨmi. Lɨbalavɨci nudɨ lɨbam heŋ lɨbala hɨnihɨni saŋ vihavɨmi. Asɨ Iaue Mosesɨ dɨ abami hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Asɨ dɨ havɨlɨ ulaŋ agadɨ sibɨla vi fɨhalavɨmi. Asɨ Iaue Mosesɨ dɨ abami hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Akuaba akuaba Mosesɨ saŋ vavehavɨmi agɨlaŋ nɨbɨlaŋ nameŋ. Havɨlɨ ulaŋ hɨsɨŋ havɨlɨ agɨladɨdaŋ nudɨ akuaba akuaba agɨladɨdaŋ vavehavɨmi. Agɨlɨŋ hɨhɨle vavehavɨmi. Hɨda ahica lɨdɨŋ lɨbukuvavɨmi agɨladɨdaŋ hɨda sɨbaŋ agɨladɨdaŋ vavehavɨmi. Lɨba kum haca daŋ haca daŋ hɨda lalɨlamalama hɨsɨŋ agɨladɨ vavehavɨmi. Kɨlɨ sɨlɨvɨŋ valɨ hutesɨ hutesɨ havɨlɨ ulaŋ agadɨ madɨŋ limu limu hɨgɨlavɨci hɨgɨlavɨci uu hɨsɨŋ agɨladɨdaŋ ulaŋ safɨli heŋ hɨgɨlavɨci hɨgɨlavɨci uu hɨsɨŋ agɨladɨdaŋ vavehavɨmi. Havɨlɨ ulaŋ agadɨ sabɨ lalɨgu lalɨgu saŋ havɨlɨ sabaŋ meme mɨnɨ hɨvɨ hɨcavɨmi agɨladɨ vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Havɨlɨ ulaŋ agadɨ cɨhu sabɨ lalɨgu lalɨgu saŋ sabaŋ sipsipɨ muŋaŋ sɨgɨtɨ maŋa mɨdɨ hɨvɨ mɨŋepɨhalapɨhala lamalama hɨcavɨmi agadɨ vavehavɨmi. Iahua sabɨ sɨbaŋ lalɨgu lalɨgu saŋ avɨli hekɨlɨ hɨsɨŋ hehɨlaŋ mu hɨdɨlɨ agɨladɨ sɨgɨtɨ lamalama hɨcavɨmi agadɨ vavehavɨmi. Havɨlɨ uleŋ muji alɨhaŋ hɨnilaha lɨbala lɨbala hɨsɨŋ havɨlɨ hekɨlɨ agadɨ vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨdaŋ nudɨ lamɨgaŋ agadɨdaŋ vavehavɨmi. Kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ havahava saŋ kɨlɨ sɨlɨvɨ ahica agɨladɨ vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Maci sakɨvakɨva lamalama hɨsɨŋ vadɨm agadɨdaŋ nudɨ hunaŋ akuaba akuaba agɨladɨdaŋ vavehavɨmi. Maci sakɨvakɨva Asɨ saŋ lamalama hɨsɨŋ agɨladɨ vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Unɨ lamalama hɨsɨŋ hɨlɨ lɨba golɨ huaci sɨbaŋ hɨvɨ vihavɨmi agadɨ hɨvɨ unɨ cɨki cɨki lamavɨla vavehavɨmi. Nudɨ hunaŋ akuaba akuaba agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ unɨ hɨvɨ lama lubilamalama hɨsɨŋ agadɨdaŋ vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Cihu savu me hɨsi huaci huaci daŋ agɨladɨ hɨlahɨla hɨsɨŋ vadɨm lɨba golɨ hɨvɨ ifuhafiavɨmi agadɨ vavehavɨmi. Cihu savu me agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavɨla akuaba akuaba Asɨ saŋ lɨbɨmɨŋɨben aba nulɨdɨ sabɨ hɨvɨ mɨŋamɨjimɨji hɨsɨŋ agɨladɨ vavehavɨmi. Cihu savu me hɨlavɨci hɨsi huaci huaci iahaiaha hɨsɨŋ agɨladɨ vavehavɨmi. Havɨlɨ ulaŋ hɨbɨ agadɨ hɨsihalahala saŋ havɨlɨ mu vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Sagalɨ hɨlahɨla hɨsɨŋ vadɨm lɨba bɨlasɨ hɨvɨ ifuhafiavɨmi agadɨ vavehavɨmi. Akuaba akuaba agɨladɨ lamalama hɨlahɨla hɨsɨŋ lɨba bɨlasɨ mɨkɨdiŋ me agadɨdaŋ nudɨ hunaŋ akuaba akuaba agɨladɨdaŋ vavehavɨmi. Vadɨm havahava saŋ kɨlɨ sɨlɨvɨ agɨladɨ vavehavɨmi. Hɨcɨ human husahusa hɨsɨŋ hunaŋ mɨsɨn hekɨlɨ agadɨdaŋ nudɨ lamɨci hɨnihɨni hɨsɨŋ vadɨm agadɨdaŋ vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Havɨlɨ hekɨlɨ hekɨlɨ havɨlɨ ulaŋ haiabɨla agadɨ haŋala haŋala lua me hahahaha hɨsɨŋ agɨladɨ vavehavɨmi. Nudɨ hɨda agɨladɨdaŋ lɨba bɨlasɨ kum haca daŋ haca daŋ hɨda lalɨlamalama hɨsɨŋ agɨladɨdaŋ vavehavɨmi. Lua me agadɨ hɨbɨ hɨsihalahala hɨsɨŋ havɨlɨ mu vavehavɨmi. Havɨlɨ ulaŋ agadɨdaŋ nudɨ lua me agadɨdaŋ vɨdɨvɨdɨŋ igu igu saŋ lɨmɨn agɨladɨ vavehavɨmi. Fɨli hɨvɨ ifavɨci ifavɨci mɨguavɨdaci lɨmɨn agɨladɨ magɨla magɨla hahahaha saŋ lɨba bɨlasɨ henaŋ hutesɨ hutesɨ agɨladɨ vavehavɨmi. Havɨlɨ uleŋ muji heŋ sibɨla vivi hɨsɨŋ akuaba akuaba agɨladɨ avi vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Alon sadaŋ nudɨ ninadinu agɨlasadaŋ hadi hɨlahɨla huaci huaci agɨladɨ vavehavɨmi. Asɨ saŋ sagalɨ igu igu hɨsɨŋ hulaŋ agɨlaŋ hadi hɨlahɨla hameŋ agɨladɨ lamalama uaiaŋ pabiŋ pabiŋ sagalɨ igu igu hɨsɨŋ uvɨ havɨlɨ uleŋ muji heŋ sibɨla vivi saŋ vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Asɨ Iaue agaŋ akuaba akuaba sibɨla vivi saŋ Mosesɨ dɨ abami. Lɨci Isɨlaelɨ hɨdɨlɨ agɨlaŋ hameŋ laci ala vi fɨhalavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Lɨhavɨci Mosesɨ agaŋ akuaba akuaba sibɨla vihavɨmi agɨladɨ iga iga hɨdami. Hɨda igɨci akuaba akuaba vihavɨmi agɨlaŋ Asɨ Iaue nudɨ abami hameŋ laci ala vihavɨmi. Lɨhavɨci nulɨdɨ huaci lamavɨla nameŋ abami. Asɨ Iaue agaŋ naludɨ huaci lamɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","La Asɨ Iaue agaŋ Mosesɨ dɨ abami. ");
INSERT INTO ena_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Hualɨ mu agadɨ avaŋ sebɨlɨ agaŋ iahɨci nudɨ mɨhiŋ sebɨlɨ hɨvɨ abɨnaŋ akuaba akuaba havɨlɨ ulaŋ vivi saŋ sɨhuvavalɨ agɨladɨ viavɨla iadɨ havɨlɨ ulaŋ agadɨ hafiavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","La kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ via ivoua havɨlɨ uleŋ muji heŋ lamavɨm uami. Lavɨla havɨlɨ hekɨlɨ mu lɨbalavɨci hɨsihala hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Hɨnidaci maci sakɨvakɨva lamalama hɨsɨŋ vadɨm agadɨ via ivoua lamavɨla akuaba akuaba nudɨ sabɨ heŋ lamalama hihɨlavɨm uami. Hihɨlavɨla unɨ lamalama hɨsɨŋ hɨlɨ makaŋ makaŋ daŋ agadɨ via ivoua lamavɨla unɨ agɨladɨ lamavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Lamavɨla cihu savu me hɨsi huaci huaci daŋ agɨladɨ hɨlahɨla hɨsɨŋ vadɨm lɨba golɨ hɨvɨ ifuhafiavalɨ agadɨ via ivouavɨm uami. Via ivouavɨla kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ mikɨ havɨlɨ hekɨlɨ agadɨ hulɨpɨŋ heŋ lamavɨm uami. Lamavɨla havɨlɨ mu agadɨ viavɨla havɨlɨ ulaŋ agadɨ hɨbɨ ivu ivu hɨvɨ lɨbalavɨci hɨsihala hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Hɨnidaci sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ via ua havɨlɨ ulaŋ hɨbɨ ivu ivu agadɨ mikɨ haiabɨla heŋ lamavɨm uami. ");
INSERT INTO ena_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Lamavɨla sagalɨ hɨlahɨla hɨsɨŋ vadɨm agaŋ hɨnici uci havɨlɨ ulaŋ agadɨ hɨbɨ ivu ivu agaŋ hɨnici vebali alɨhaŋ heŋ hɨcɨ human husahusa hɨsɨŋ hunaŋ mɨsɨn hekɨlɨ agadɨ lamavɨm uami. Lamavɨla avɨli nudɨ hɨvɨ mɨŋamɨjiavɨci mɨgum uami. ");
INSERT INTO ena_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Mɨŋamɨjiavɨci mɨguci havɨlɨ ulaŋ haiabɨla agadɨ lua me haŋala haŋala hahavɨm uami. Lavɨla havɨlɨ mu viavɨla lua hɨbɨ ivu ivu heŋ lɨbalavɨci hɨsihala hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Hɨnidaci akuaba akuaba iasaŋ lɨbɨmɨŋɨben aba cihu savu me hɨhɨle agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavalɨ agadɨ viavɨla havɨlɨ ulaŋ agadɨ sabɨ heŋ sevɨha uami. Sevaseva nudɨ akuaba akuaba agɨladɨ sabɨ hɨvɨ mɨŋamɨjiha uami. Hameŋ lavɨla lɨbɨmɨŋɨnaŋ akuaba akuaba agɨlaŋ iadɨ nukeŋ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Sagalɨ hɨlahɨla hɨsɨŋ vadɨm sabɨ hɨvɨ mɨŋamɨjiha uami. Nudɨ hunaŋ akuaba akuaba agɨladɨ hɨvɨ avi mɨŋamɨjiha uami. Lɨnaŋ vadɨm agaŋ iadɨ nukeŋ sɨbaŋ hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Hɨcɨ human husahusa hɨsɨŋ hunaŋ mɨsɨn hekɨlɨ agadɨ hɨvɨ mɨŋamɨjiha uami. Nudɨ lamɨci hɨnihɨni hɨsɨŋ vadɨm agadɨ sabɨ hɨvɨ avi mɨŋamɨjiha uami. Lɨnaŋ akuaba akuaba agɨlaŋ iadɨ nukeŋ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Lavɨla Alon dɨdaŋ nudɨ ninadinu agɨladɨdaŋ vavevɨla havɨlɨ ulaŋ agadɨ hɨbɨ ivu ivu haiabɨla heŋ lamavɨla nulɨdɨ sɨlamɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Sɨlama iasaŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ agadɨ hadi hɨlahɨla agɨladɨ Alon dɨ hɨvɨ ahuala lamɨha uami. Lamavɨla cihu savu me agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavalɨ agadɨ nudɨ sabɨ hɨvɨ mɨŋamɨjiavɨla lɨbɨmɨŋɨha uami. Lɨbɨmɨŋɨnaŋ iasaŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali hekɨlɨ hɨnihɨni sibɨla vibali uami. ");
INSERT INTO ena_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","La ninadinu agɨladɨ avi vavevɨla iasaŋ sagalɨ igu igu hɨsɨŋ hadi hɨlahɨla hutesɨ hutesɨ agɨladɨ nulɨdɨ hadipɨlɨ hɨvɨ ahuala lamɨha uami. ");
INSERT INTO ena_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Lavɨla cihu savu me agɨladɨdaŋ kɨlɨ olivɨ agɨladɨ amɨŋ agɨladɨ mɨtɨ agadɨdaŋ eŋalavalɨ agadɨ nulɨdɨ sabɨ hɨvɨ mɨŋamɨjiavɨla lɨbɨmɨŋɨha uami. Lɨbɨmɨŋɨnaŋ iasaŋ sagalɨ igu igu hɨsɨŋ hulaŋ hɨnihɨni sibɨla vihavɨbali uami. Iaganɨlu dɨ lɨbanaŋ hameŋ laci ala lɨha uami. Lɨnaŋ ninadinɨlu ajihalinɨlu iamɨlɨhalinɨlu mufɨli mufɨli iahavɨbali agɨlaŋ avi hameŋ laci ala lɨhavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Lɨci Mosesɨ agaŋ akuaba akuaba Asɨ Iaue abami agɨladɨ hameŋ laci ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","18","Isipɨ fɨli tɨbɨ vala vehavɨdaci hualɨ pabiŋ umi. Lɨci hualɨ mu agadɨ avaŋ sebɨlɨ agaŋ iahami. Lɨci avaŋ agadɨ mɨhiŋ sebɨlɨ hɨvɨ Asɨ dɨ havɨlɨ ulaŋ agadɨ hafiavɨmi. Mosesɨ abɨci lɨba silɨva kum haca daŋ haca daŋ agɨladɨ fɨli hɨvɨ lamalama ua hɨda ahica lɨdɨŋ lɨbukuvavɨmi agɨladɨ lɨba kum haca daŋ haca daŋ agɨladɨ hɨvɨ lalɨlamalama uavɨmi. La kɨlɨ sɨlɨvɨŋ valɨ hutesɨ hutesɨ agɨladɨ madɨŋ limu limu heŋ hɨgɨlavɨci hɨgɨlavɨci uavɨmi. Ulaŋ safɨli agadɨ avi hameŋ laci ala hɨgɨlavɨci hɨgɨlavɨci uavɨmi. La havɨlɨ hekɨlɨ hekɨlɨ agɨladɨ lɨbala lɨbala hɨsɨŋ hɨda agɨladɨ lalɨlamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","La havɨlɨ hekɨlɨ agadɨ havalavɨci iahua lalɨguci ulaŋ me hɨnimi. Hɨnidaci havɨlɨ hekɨlɨ mu sabaŋ meme mɨnɨ hɨvɨ vihavɨmi agadɨ havalavɨci iahua havɨlɨ ulaŋ agadɨ lalɨgumi. Lɨci sabaŋ sipsipɨ muŋaŋ sɨgɨtɨ agɨladɨ viavɨla havɨlɨ hekɨlɨ me hɨcavɨmi agadɨ via sabɨ havalavɨci iahua lalɨgumi. Lɨci avɨli hekɨlɨ hɨsɨŋ hehɨlaŋ mu hɨdɨlɨ sɨgɨtɨ agɨladɨ avi viavɨla havɨlɨ hekɨlɨ me hɨcavɨmi agadɨ via cɨhu sabɨ sɨbaŋ havalavɨci iahua lalɨgumi. Asɨ Iaue Mosesɨ dɨ abami hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Lɨhavɨci Mosesɨ agaŋ Asɨ lɨba cɨkaŋ ahica hɨvɨ ciaŋ vɨdɨvɨdɨŋ ihatɨbutɨbu lɨbami agɨladɨ via kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ hɨvɨ lamɨci mɨguavɨmi. La abɨci kɨlɨ sɨlɨvɨ ahica agɨladɨ viavɨla kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ lɨba golɨ hakɨ agɨladɨ hɨvɨ lamavɨci ivouavɨmi. Lavɨla nudɨ lamɨgaŋ agadɨ lalɨguavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","La kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ via havɨlɨ uleŋ muji lamavɨla havɨlɨ mu agadɨ viavɨla lɨbalavɨci kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ hɨsihala hɨnimi. Asɨ Iaue Mosesɨ dɨ abami hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Lavɨla maci sakɨvakɨva lamalama hɨsɨŋ vadɨm agadɨ via ivouavɨla uaiaŋ pabiŋ pabiŋ sagalɨ igu igu hɨsɨŋ uvɨ caba limu lakulamaŋ kɨlikɨli heŋ lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","La Asɨ Iaue agaŋ maci sakɨvakɨva agɨladɨ iga iga saŋ maci sakɨvakɨva agɨladɨ vivi vadɨm hɨvɨ lamalama hihɨlavɨmi. Asɨ Iaue Mosesɨ dɨ abami hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Lavɨla unɨ lamalama hɨsɨŋ hɨlɨ agadɨ via ivouavɨla uaiaŋ pabiŋ pabiŋ sagalɨ igu igu hɨsɨŋ uvɨ caba limu ium kɨlikɨli heŋ lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","La Asɨ Iaue agaŋ igasulɨdaci unɨ lamalama hɨsɨŋ hɨlɨ agadɨ makaŋ hɨtɨŋ hɨtɨŋ hɨvɨ unɨ agɨladɨ lamalama lubilamavɨmi. Asɨ Iaue Mosesɨ dɨ abami hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Lavɨla cihu savu me hɨsi huaci huaci daŋ agɨladɨ hɨlahɨla hɨsɨŋ vadɨm lɨba golɨ hɨvɨ ifuhafiavɨmi agadɨ via ivouavɨla kɨlɨ cɨkaŋ hɨbɨn hɨbɨn agadɨ mikɨ havɨlɨ hɨsihala hɨnimi agadɨ hulɨpɨŋ heŋ lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Lamavɨci Mosesɨ agaŋ vadɨm agadɨ hɨvɨ cihu savu me hɨsi huaci huaci daŋ agɨladɨ hɨlami. Asɨ Iaue nudɨ abami hameŋ laci ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","La abɨci havɨlɨ ulaŋ agadɨ hɨbɨ ivu ivu heŋ havɨlɨ mu lɨbalavɨci hɨsihala hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Lɨci sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨ viavɨla havɨlɨ ulaŋ agadɨ hɨbɨ ivu ivu mikɨ haiabɨla heŋ lamavɨmi. Lamavɨci Mosesɨ agaŋ sagalɨ iguben aba sɨhɨm hɨlɨcɨ agɨladɨdaŋ halɨha cahu uitɨ agɨladɨdaŋ avɨŋ hɨlɨci sɨkasɨkan lɨhu fɨhalavɨmi. Asɨ Iaue nudɨ abami hameŋ laci ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","La abɨci hɨcɨ human husahusa hɨsɨŋ hunaŋ mɨsɨn hekɨlɨ agadɨ via uavɨla havɨlɨ ulaŋ agadɨ hɨbɨ ivu ivu agaŋ hɨnici veci sagalɨ hɨlahɨla hɨsɨŋ vadɨm agaŋ hɨnici umi alɨhaŋ heŋ lamavɨmi. Lavɨla avɨli mɨŋamɨjiavɨci mɨgumi. ");
INSERT INTO ena_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Lɨhavɨci Mosesɨ hula Alon hula nulɨdɨ hɨcɨ human husavɨmi. Alon dɨ ninadinu agɨlaŋ avi nulɨdɨ hɨcɨ human husavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Havɨlɨ uleŋ muji heŋ ivoubalu aba hɨcɨ human husavɨhadami. Sagalɨ hɨlahɨla hɨsɨŋ vadɨm haiabɨla hɨniadami heŋ sagalɨ igubalu aba avi hɨcɨ human husavɨhadami. Asɨ Iaue Mosesɨ dɨ abami hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Lavɨla havɨlɨ ulaŋ haiabɨla agadɨdaŋ sagalɨ hɨlahɨla hɨsɨŋ vadɨm agadɨdaŋ haŋala haŋala havɨlɨ hɨvɨ lua me hahavɨmi. La lua hɨbɨ ivu ivu heŋ havɨlɨ mu agadɨ lɨbalavɨci hɨsihala hɨnimi. Mosesɨ agaŋ hulaŋ hɨhɨle agɨlaŋ hula havɨlɨ ulaŋ akuaba akuaba sibɨla agɨladɨ vivi hɨdahɨda sibɨla agɨladɨ fɨhalavɨmi. ");
INSERT INTO ena_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Havɨlɨ ulaŋ agadɨ hafia fɨhalavɨci avɨli susu agaŋ vevɨla havɨlɨ ulaŋ agadɨ lalɨgua hɨnimi. Lɨci Asɨ Iaue dɨ abɨlu hekɨlɨ vɨdɨvɨdɨŋ daŋ agaŋ havɨlɨ uleŋ muji heŋ iahavɨla hɨnimi. ");
INSERT INTO ena_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Avɨli susu agaŋ havɨlɨ ulaŋ agadɨ lalɨgua hɨnidaci Asɨ Iaue dɨ abɨlu hekɨlɨ vɨdɨvɨdɨŋ daŋ agaŋ uleŋ muji heŋ hɨniadami. Hɨnidaci Mosesɨ agaŋ havɨlɨ ulaŋ heŋ ma ivouadami. ");
INSERT INTO ena_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Avɨli susu agaŋ Asɨ dɨ havɨlɨ ulaŋ agadɨ vala udaci Isɨlaelɨ hɨdɨlɨ agɨlaŋ nulɨdɨ akuaba akuaba agɨladɨdaŋ Asɨ dɨ havɨlɨ ulaŋ agadɨdaŋ vivi nudɨ sɨvɨ uavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Avɨli susu agaŋ havɨlɨ ulaŋ sabɨ heŋ hɨnidaci nɨbɨlaŋ avi havɨlɨ ulaŋ akuaba akuaba agɨladɨ ma vivi uavɨhadami. Igavɨdaci avɨli susu agaŋ havɨlɨ ulaŋ agadɨ vala udaci nɨbɨlaŋ avi iahaiaha avɨli susu agadɨ sɨvɨ uavɨhadami. ");
INSERT INTO ena_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Asɨ Iaue agaŋ avɨli susu lɨkɨla lɨkɨla hɨvɨ hɨniadami. Uaiaŋ mu hɨvɨ mu hɨvɨ avɨli susu agaŋ havɨlɨ ulaŋ sabɨ heŋ hɨniadami. Hɨnidaci uaiadi hɨvɨ avɨli susu agadɨ igavɨhadami. Hɨfɨlɨ hɨvɨ avɨŋ avɨli susu lɨkɨla lɨkɨla heŋ hɨniadami agadɨ igavɨhadami. Avɨli susu daŋ avɨŋ daŋ agɨlaŋ hameŋ laci hameŋ laci lɨhavɨdaci Isɨlaelɨ hɨdɨlɨ agɨlaŋ iga iga hɨdavɨhadami.");
INSERT INTO ena_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jisasɨ Kɨlaisɨ dɨ iauacagalinu iamɨlɨhalinu agɨladɨ lugɨlavɨmi agadɨ ciaŋ nɨbu nameŋ. Jisasɨ agaŋ Devitɨ dɨ hɨdɨlɨ hɨvɨ iahami. Devitɨ nɨbu Ebɨlam dɨ hɨdɨlɨ hɨvɨ iahami. ");
INSERT INTO ena_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebɨlam ninanu Aisakɨ. Aisakɨ ninanu Jekopɨ. Jekopɨ ninanu Juda. Jekopɨ agaŋ ninadinu limu hɨhɨle agɨladɨ avi havami. ");
INSERT INTO ena_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda ninadinu ahica. Mu Pelesɨ. Mu Cela. Nulɨdɨ iamɨnɨlu Tamalɨ. Pelesɨ ninanu Hesɨlon. Hesɨlon ninanu Lam. ");
INSERT INTO ena_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lam ninanu Aminadapɨ. Aminadapɨ ninanu Nason. Nason ninanu Salɨmon. ");
INSERT INTO ena_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salɨmon ninanu Boasɨ. Boasɨ iamɨnu Lehapɨ. Boasɨ ninanu Obetɨ. Obetɨ iamɨnu Lutɨ. Obetɨ ninanu Jesi. ");
INSERT INTO ena_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi ninanu Devitɨ. Devitɨ nɨbu manɨgali hɨniadami. Manɨgali hɨnihɨni Ulia dɨ cido agadɨ sabimi. Sabici nɨbu hula hɨniavɨla Solomon dɨ huhɨlami. ");
INSERT INTO ena_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ninanu Lehaboam. Lehaboam ninanu Abia. Abia ninanu Asa. ");
INSERT INTO ena_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ninanu Jehosafatɨ. Jehosafatɨ ninanu Jeholam. Jeholam ninanu Usia. ");
INSERT INTO ena_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia ninanu Jotam. Jotam ninanu Ahasɨ. Ahasɨ ninanu Hesekia. ");
INSERT INTO ena_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia ninanu Manase. Manase ninanu Amon. Amon ninanu Josaia. ");
INSERT INTO ena_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia ninanu Jehoiakin. Josaia agaŋ ninadinu limu hɨhɨle agɨladɨ avi havami. Nɨbɨlaŋ iaha hɨniavɨdaci Babilonia fɨli tɨbɨ hɨsɨŋ agɨlaŋ ve nɨbɨlaŋ hula sagaŋ lɨbavɨmi. Sagaŋ lɨba nulɨdɨ lɨvalavɨla nulɨdɨdaŋ Isɨlaelɨ hɨdɨlɨ limu hɨhɨle agɨladɨdaŋ Babilonia fɨli tɨbɨ via uavɨmi. Via uavɨci lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ me hɨnihɨni sibɨla havɨ havɨ vihavɨhadami. ");
INSERT INTO ena_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Lɨhavɨdaci Jehoiakin agaŋ Sealɨtielɨ dɨ havami. Sealɨtielɨ ninanu Selubabelɨ. ");
INSERT INTO ena_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selubabelɨ ninanu Abiutɨ. Abiutɨ ninanu Eliakim. Eliakim ninanu Ajolɨ. ");
INSERT INTO ena_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ajolɨ ninanu Sadokɨ. Sadokɨ ninanu Akim. Akim ninanu Eliutɨ. ");
INSERT INTO ena_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliutɨ ninanu Eleasalɨ. Eleasalɨ ninanu Matan. Matan ninanu Jekopɨ. ");
INSERT INTO ena_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekopɨ ninanu Josepɨ. Josepɨ agaŋ Malia dɨ sabimi. Malia nɨbu Jisasɨ dɨ huhɨlami. Nudɨ ala Jisasɨ Kɨlaisɨ uavɨhadami. ");
INSERT INTO ena_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ebɨlam dɨ ninadinu ajihalinu iamɨlɨhalinu agɨladɨ tɨbitɨbi lugɨlavɨmi. Lugɨla lugɨla vavehavɨci human limu limu fɨhala hɨcɨ limu ahica pam cɨjɨŋ iahami. Lɨci cɨhu Devitɨ agaŋ iahami. Devitɨ dɨ ninadinu ajihalinu iamɨlɨhalinu agɨladɨ avi tɨbitɨbi lugɨlavɨmi. Lugɨla lugɨla vavehavɨci human limu limu fɨhala hɨcɨ limu ahica pam cɨjɨŋ iahami. Lɨci Josaia dɨ ninadinu agɨlaŋ iaha hɨniavɨdaci Babilonia fɨli tɨbɨ hɨsɨŋ agɨlaŋ ve nɨbɨlaŋ hula sagaŋ lɨbavɨmi. La nulɨdɨ lɨvalavɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ viavɨla Babilonia fɨli tɨbɨ heŋ via uavɨmi. Via uavɨci lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ me hɨniavɨhadami. Heŋ hɨnihɨni cɨhu hɨdɨlɨ maha Jehoiakin dɨ ninadinu ajihalinu iamɨlɨhalinu agɨladɨ avi tɨbitɨbi lugɨlavɨmi. Lugɨla lugɨla vavehavɨci human limu limu fɨhala hɨcɨ limu ahica pam cɨjɨŋ iahami. Lɨci cɨhu Jisasɨ Kɨlaisɨ iahami. ");
INSERT INTO ena_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisasɨ Kɨlaisɨ iahami agadɨ ciaŋ nɨbu nameŋ. Jisasɨ iamɨnu Malia Josepɨ dɨ iahuiahu saŋ lɨbɨmɨŋavɨmi. Agadɨ ala ahica ma hɨnimaŋ lɨhavɨdaci Malia agaŋ humɨgaŋ ahɨlami. Asɨ dɨ Amɨŋ agadɨ vɨdɨvɨdɨŋ hɨvɨ humɨgaŋ ahɨlami. ");
INSERT INTO ena_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josepɨ nɨbu Asɨ dɨ ciaŋ sɨhɨvia lubiahɨladami. Hameŋ sadaŋ Malia humɨgaŋ ahɨlami agadɨ ciaŋ hɨjɨ igahɨlavɨla nudɨ valɨben aba lɨmi. La hulaŋ iamɨgali Malia dɨ mɨŋavɨhavɨdaci Malia sɨhumahɨlɨmɨdɨ aba nudɨ nɨfɨlɨ cɨki valɨben aba lɨmi. ");
INSERT INTO ena_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Hɨji hameŋ lamalama hɨnidaci hɨfɨlɨ heŋ ala nulɨdɨ Hekɨlɨ dɨ ciaŋ hali hɨsɨŋ agaŋ anisɨhu hɨvɨ iahavɨla Josepɨ dɨ abami. Josepɨ uami. Nama Devitɨ dɨ iamɨlɨnu uami. Ci igɨnaŋ uami. Asɨ dɨ Amɨŋ agaŋ Malia dɨ ahɨliahuci humɨgaŋ ahɨlalɨ uami. Hameŋ sadaŋ nama nudɨ sabisabi saŋ lɨdɨmɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nɨbu ninaŋ huhɨlɨbali uami. Lɨci ninaŋ agaŋ hekɨlɨ lavɨla Asɨ dɨ hulaŋ iamɨgali Isɨlaelɨ hɨdɨlɨ agɨladɨ hugɨ hivɨbali uami. Hugɨ hivahiva nulɨdɨ ahɨliahudaci huaci hameŋ laci hameŋ laci hɨniavɨbali uami. Hameŋ sadaŋ nudɨ ibi Jisasɨ aba abɨha uami. ");
INSERT INTO ena_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","25","Lɨci Josepɨ agaŋ ani hɨsɨva iahavɨla nulɨdɨ Hekɨlɨ dɨ ciaŋ hali hɨsɨŋ agaŋ nudɨ abami hameŋ laci ala lɨmi. Malia dɨ sabimi. Agadɨ ala ahica ma hɨnimaŋ lɨhavɨdaci Malia agaŋ ninaŋ agadɨ huhɨlami. Huhɨlɨci Josepɨ agaŋ ninaŋ agadɨ ibi lamavɨla abami. Jisasɨ uami. Akuaba akuaba hadɨhu iahavɨmi agɨlasaŋ ala vaka nulɨdɨ Hekɨlɨ agaŋ nudɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ agasaŋ hɨji igudaci nameŋ abami. Ci igɨlaŋ uami. Iamɨgali mɨnibɨlɨ mu hulaŋ mu hula ma hɨnimaŋ lɨdɨŋ humɨgaŋ ahɨlɨbali uami. Lavɨla ninaŋ mu huhɨlɨbali uami. Huhɨlɨci nudɨ ibi Emanuelɨ aba abavɨbali uami. Lɨci Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ abami hameŋ laci ala lɨmi. Asɨ alaŋ hula hɨnilalɨ aba abavɨhadami agasaŋ Ibɨlu ciaŋ hɨvɨ Emanuelɨ uavɨhadami. ");
INSERT INTO ena_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Helotɨ agaŋ nɨbu manɨgali hɨnihɨni Judia fɨli tɨbɨ agadɨ migɨladami. Betɨlehem haiabɨla agaŋ Judia fɨli tɨbɨ heŋ hɨniadami. Betɨlehem haiabɨla heŋ ala Malia agaŋ Jisasɨ dɨ huhɨlami. Huhɨlavɨla via hɨnidaci hulaŋ hekɨlɨ hekɨlɨ hɨji hutesɨ daŋ uaiaŋ iahaiaha kɨlikɨli hɨsɨŋ agɨlaŋ Jelusalem haiabɨla ve iahavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ve iahavɨla nameŋ abavɨmi. Alaŋ uaiaŋ iahaiaha kɨlikɨli hɨniavɨla lidɨ mu igavɨla nameŋ abahɨlu uavɨmi. Ninaŋ mu Isɨlaelɨ hɨdɨlɨ agɨladɨ manɨgali hɨnihɨni saŋ ci iahi aba abahɨlu uavɨmi. La nudɨ ibi mɨŋaiahaiaha saŋ mɨgalɨfɨlɨbɨbalu aba vehɨlu uavɨmi. Ninaŋ agaŋ abeŋ hɨnidi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Lɨhavɨci manɨgali Helotɨ agaŋ ciaŋ agadɨ igahɨlɨci nudɨ hɨji tɨmɨŋ tɨmɨŋ lɨmi. Hulaŋ iamɨgali Jelusalem haiabɨla hɨsɨŋ agɨladɨ hɨji avi tɨmɨŋ tɨmɨŋ lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Helotɨ agaŋ ciaŋ hameŋ agadɨ igahɨlavɨla Asɨ saŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali sɨkasɨkan agɨladɨ abɨci nudɨ pɨŋ vehavɨmi. Isɨlaelɨ hɨdɨlɨ agɨlasaŋ Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agadɨ lamalubilubi hɨsɨŋ hulaŋ sɨkasɨkan agɨladɨ avi abɨci vehavɨmi. Ve mɨgudɨbavɨci nulɨdɨ abitɨhami. Asɨ agaŋ hulaŋ mu lɨbɨmɨŋavɨla hulaŋ iamɨgali ahɨliahuiahu saŋ abɨci veve saŋ abami uami. Hulaŋ agaŋ haiabɨla abeŋ iahɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Lɨci nudɨ abavɨmi. Hulaŋ agaŋ Betɨlehem haiabɨla heŋ iahɨbali uavɨmi. Betɨlehem haiabɨla agaŋ Judia fɨli tɨbɨ neŋ hɨnilalɨ uavɨmi. Haiabɨla agasaŋ ala vaka Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ agaŋ ciaŋ mu manasɨŋ hɨvɨ nameŋ lɨbami uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Juda hɨdɨlɨ agɨladɨ haiabɨla ibi hekɨlɨ hekɨlɨ daŋ agɨlaŋ Betɨlehem haiabɨla agadɨ ma sɨbaŋ lɨvalavi aba abami uavɨmi. Betɨlehem haiabɨla agadɨ hɨvɨ ala hulaŋ mu iahɨbali aba abami uavɨmi. Nɨbu iaha manɨgali hɨnihɨni Isɨlaelɨ hɨdɨlɨ agɨladɨ migɨlɨbali aba abami uavɨmi. Nɨbɨlaŋ Asɨ dɨ hulaŋ iamɨgali aba abami uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Lɨhavɨci Helotɨ agaŋ ciaŋ agadɨ igahɨlami. Igahɨlavɨla nudɨ sibɨla hɨsɨŋ hulaŋ mu agadɨ nɨfɨlɨ cɨki abɨci hulaŋ hekɨlɨ hekɨlɨ hɨji hutesɨ daŋ uaiaŋ iahaiaha kɨlikɨli hɨsɨŋ agɨladɨ pɨŋ umi. Uavɨla nulɨdɨ abɨci Helotɨ dɨ pɨŋ vehavɨmi. Vehavɨci nulɨdɨ sɨhɨvia sɨbaŋ abitɨhami. Lidɨ agaŋ abadɨhu amɨŋ iahɨci igahalaŋ uami. Lɨci lidɨ iahɨci igavɨmi agasaŋ nudɨ sɨhɨvia sɨbaŋ sulavɨci igahɨlami. ");
INSERT INTO ena_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Lavɨla Betɨlehem haiabɨla uu saŋ nulɨdɨ nameŋ abami. Namɨlaŋ uavɨla ninaŋ agadɨ sɨhɨvia sɨbaŋ suhɨlɨhalaŋ uami. Suhɨla igavɨla ve iadɨ abɨhalaŋ uami. Lɨlaŋ viaŋ avi uavɨla ninaŋ agadɨ ibi mɨŋaiahaiaha saŋ mɨgalɨfɨlɨbɨben uami. ");
INSERT INTO ena_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Manɨgali agaŋ hameŋ abɨci igahɨlavɨla uavɨmi. Uavɨdaci lidɨ vaka uaiaŋ iahaiaha kɨlikɨli hɨnia iga iga vehavɨmi agaŋ cɨhu iahami. Lɨci lidɨ agadɨ igavɨla hekɨlɨ sɨbaŋ hɨjɨŋalavɨmi. La igavɨdaci lidɨ agaŋ hali uavɨla ulaŋ ninaŋ agaŋ hɨnimi agadɨ huva huva heŋ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Hɨnidaci hulaŋ hekɨlɨ hekɨlɨ hɨji hutesɨ daŋ agɨlaŋ ua uleŋ muji heŋ ivoua ninaŋ agadɨdaŋ iamɨnu Malia dɨdaŋ igavɨmi. Lavɨla ninaŋ agadɨ ibi mɨŋaiahɨbalu aba mɨgalɨfɨlɨbavɨla nulɨdɨ hali agɨladɨ fɨli hɨvɨ lɨbɨlɨvavɨmi. Lavɨla nulɨdɨ hɨbɨn hɨbɨn agɨladɨ mɨŋalavɨla akuaba akuaba huaci huaci agɨladɨ ninaŋ agasaŋ iguavɨmi. Akuaba akuaba nameŋ agɨladɨ iguavɨmi. Lɨba golɨ agadɨ iguavɨmi. Cihu savu me kɨlɨ balɨsam agadɨ mɨlɨm hɨvɨ vihavɨhadami agadɨ iguavɨmi. Cihu savu me mu agadɨ ibi mea uavɨhadami agadɨ avi iguavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Lavɨla hɨniavɨdaci hɨfɨlɨ anisɨhu hɨvɨ Asɨ agaŋ nulɨdɨ abami. Helotɨ dɨ pɨŋ cɨhu umɨlaŋ uami. Lɨci nɨbɨlaŋ hɨbɨ mu hɨvɨ uavɨla Helotɨ dɨ lɨvala sɨkasɨkan nulɨdɨ hɨvɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Hulaŋ hekɨlɨ hekɨlɨ hɨji hutesɨ daŋ agɨlaŋ uavɨdaci Asɨ dɨ ciaŋ hali hɨsɨŋ agaŋ anisɨhu hɨvɨ Josepɨ dɨ nameŋ abami. Nama iaha ninaŋ agadɨdaŋ iamɨnu dɨdaŋ viavɨla Isipɨ fɨli tɨbɨ haŋɨla uhalaŋ uami. Helotɨ agaŋ ninaŋ agadɨ suhɨla igavɨla ifɨhɨmuhɨmu saŋ hɨji lamalama hɨnidi uami. Uavɨla Isipɨ fɨli tɨbɨ hɨnidalaŋ viaŋ nukeŋ naludɨ cɨhu veve saŋ abɨben uami. ");
INSERT INTO ena_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Lɨci hɨfɨlɨ heŋ ala Josepɨ agaŋ iaha ninaŋ agadɨdaŋ ninaŋ agadɨ iamɨnu dɨdaŋ viavɨla Isipɨ fɨli tɨbɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Uavɨla Isipɨ fɨli tɨbɨ heŋ hɨniavɨdaci Helotɨ agaŋ hɨmami. Akuaba akuaba hadɨhu iahavɨmi agɨlasaŋ ala vaka nulɨdɨ Hekɨlɨ agaŋ nudɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ agasaŋ hɨji igudaci nameŋ abami. Aludɨ Hekɨlɨ agaŋ nameŋ abi uami. Iadɨ ninaŋ Isipɨ fɨli tɨbɨ hɨnidaci fɨli tɨbɨ agadɨ cɨhu vala veve saŋ abacin aba abi uami. Lɨci nulɨdɨ Hekɨlɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ abami agaŋ hameŋ laci ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hulaŋ hekɨlɨ hekɨlɨ hɨji hutesɨ daŋ uaiaŋ iahaiaha kɨlikɨli hɨsɨŋ agɨlaŋ sɨvɨlavɨla hɨbɨ mu hɨvɨ Helotɨ dɨ lɨvala uavɨmi. Lɨhavɨci nudɨ igɨvɨ lɨmi. Lɨci hulaŋ hekɨlɨ hekɨlɨ hɨji hutesɨ daŋ uaiaŋ iahaiaha kɨlikɨli hɨsɨŋ agɨladɨ abitɨhɨdaci nudɨ sɨhɨvia sɨbaŋ nameŋ sulavɨmi agasaŋ igahɨlami. Alaŋ lidɨ hekɨlɨ iahɨci igahɨlu agaŋ hualɨ ahica ci ualɨ uavɨmi. Hameŋ abavɨci igahɨlami agasaŋ igahɨlavɨla nudɨ sagaŋ hɨsɨŋ hulemɨlɨ agɨladɨ abɨci Betɨlehem haiabɨla uavɨmi. Uavɨla ninaŋ hualɨ ahica daŋ agɨladɨ ifɨhɨmuhɨmu via ua mumɨŋ cɨki cɨki agɨladɨ avi sɨkasɨkan ifɨhɨma fɨhalavɨmi. Haiabɨla hɨhɨle Betɨlehem haiabɨla mikɨ mikɨ hɨniavɨhadami heŋ avi uu hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Akuaba akuaba hadɨhu iahavɨmi agɨlasaŋ ala vaka Asɨ agaŋ nudɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ Jelemaia saŋ hɨji igudaci nameŋ abami. Lame haiabɨla heŋ livaliva ilɨhiŋ hekɨlɨ ilɨhavadi uami. Leselɨ dɨ iamɨlɨhalinu agɨlaŋ mavɨn mɨŋamɨŋa ilɨhavadi uami. Nulɨdɨ ninadinɨlu agɨlaŋ sɨkasɨkan haba hɨma fɨhalavɨci nulɨsaŋ mavɨn mɨŋamɨŋa ilɨhavadi uami. Hameŋ sadaŋ hulaŋ iamɨgali limu hɨhɨle agɨlaŋ igahɨlavɨla nulɨdɨ mavɨn ifɨmɨgubalu aba lɨhavi uami. Agadɨ ala nɨbɨlaŋ nulɨdɨ ciaŋ igahɨlahɨla saŋ valavi uami. Lɨci Jelemaia abami hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Josepɨ agaŋ Isipɨ fɨli tɨbɨ hɨnidaci Helotɨ hɨmami. Lɨci nulɨdɨ Hekɨlɨ dɨ ciaŋ hali hɨsɨŋ agaŋ Isipɨ fɨli tɨbɨ heŋ anisɨhu hɨvɨ iaha Josepɨ dɨ nameŋ abami. ");
INSERT INTO ena_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ninaŋ agadɨ ifɨhɨmuhɨmu saŋ abavalɨ agɨlaŋ ci hɨmavalɨ uami. Hameŋ sadaŋ nama iaha ninaŋ agadɨdaŋ iamɨnu dɨdaŋ viavɨla Isɨlaelɨ fɨli tɨbɨ cɨhu uhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Lɨci Josepɨ agaŋ iaha ninaŋ agadɨdaŋ ninaŋ agadɨ iamɨnu dɨdaŋ via Isɨlaelɨ fɨli tɨbɨ heŋ cɨhu vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Helotɨ agaŋ nɨbu manɨgali hɨnihɨni Judia fɨli tɨbɨ agadɨ migɨladami. La hɨmɨci ninanu Alɨkelausɨ agaŋ iaganu dɨ uvɨsɨjiŋ viavɨla Judia fɨli tɨbɨ agadɨ ala migɨladami. Lɨdaci Josepɨ agaŋ nudɨ ciaŋ hɨjɨ agadɨ igahɨlami. Igahɨlavɨla heŋ veve saŋ lɨdami. Lɨci Asɨ agaŋ anisɨhu hɨvɨ nudɨ abami. Judia fɨli tɨbɨ heŋ umɨnaŋ uami. Hameŋ abɨci Galili fɨli tɨbɨ vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Vevɨla Nasaletɨ haiabɨla hɨniavɨmi. Akuaba akuaba hadɨhu iahavɨmi agɨlasaŋ ala vaka Asɨ agaŋ nudɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ agɨlasaŋ hɨji igudaci Jisasɨ saŋ nameŋ abavɨhadami. Hulaŋ iamɨgali agɨlaŋ nameŋ abavɨbali uavɨhadami. Hulaŋ agaŋ nɨbu Nasaletɨ haiabɨla hɨsɨŋ aba abavɨbali uavɨhadami. Lɨhavɨci Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ abavɨhadami agaŋ hameŋ laci ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Hualɨ akape uci hulaŋ iamɨgali avɨli hɨvɨ mɨŋamɨgu mɨŋaiahaiaha hɨsɨŋ hulaŋ Jon agaŋ hɨdɨlɨ maha ciaŋ suladami. Judia fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ hɨnihɨni hulaŋ iamɨgali agɨlasaŋ ciaŋ suladami. ");
INSERT INTO ena_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Sulasula hulaŋ iamɨgali agɨladɨ nameŋ abadami. Asɨ hulaŋ iamɨgali agɨladɨ amɨŋ ci likɨlɨci nudɨ lɨhu hɨvɨ hɨniavɨbali uadami. Hameŋ sadaŋ namɨlaŋ lusɨŋ sɨbɨlɨ sɨbɨlɨ agɨladɨ valɨhalaŋ uadami. ");
INSERT INTO ena_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Vaka Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ Aisaia agaŋ Jon saŋ ala nameŋ abami. Hulaŋ mu fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ hɨnihɨni ciaŋ vɨdɨvɨdɨŋ sɨbaŋ nameŋ abɨbali uami. Aludɨ Hekɨlɨ saŋ hɨbɨ hekɨlɨ agadɨ vɨcihalaŋ aba abɨbali uami. Hɨbɨ sudɨme cɨki cɨki agɨladɨ avi vɨcivɨci hihɨlɨhalaŋ aba abɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon nɨbu hadi hɨlahɨla sabaŋ kamelɨ mɨnɨ hɨvɨ vihavɨmi agadɨ lamadami. Lamalama lavi sabaŋ sipsipɨ sɨgɨtɨ hɨvɨ vihavɨmi agadɨ lɨbɨhahadami. Lɨdɨŋ vɨhɨ magɨ agɨladɨdaŋ hujɨbɨlam amɨŋ agɨladɨdaŋ nadami. ");
INSERT INTO ena_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Hameŋ lɨdɨŋ hɨnidaci Jelusalem haiabɨla hɨsɨŋ hulaŋ iamɨgali agɨlaŋ hula Judia fɨli tɨbɨ hɨsɨŋ hulaŋ iamɨgali akape agɨlaŋ hula nudɨ pɨŋ vehavɨhadami. Haiabɨla hɨhɨle Jolɨdan avɨli mikɨ hɨniavɨhadami heŋ hɨsɨŋ hulaŋ iamɨgali akape agɨlaŋ avi nudɨ pɨŋ vehavɨhadami. ");
INSERT INTO ena_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Veve lusɨŋ sɨbɨlɨ sɨbɨlɨ vihavɨhadami agɨladɨ valavala saŋ haiabɨla lamalama abavɨdaci Jolɨdan avɨli heŋ nulɨdɨ mɨŋamɨgu mɨŋaiahadami. ");
INSERT INTO ena_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mɨŋamɨgu mɨŋaiahɨdaci Falisi hɨdɨlɨ Sadiusi hɨdɨlɨ akape agɨlaŋ nudɨ pɨŋ vehavɨmi. Nulɨdɨ avi avɨli hɨvɨ mɨŋamɨgu mɨŋaiahaiaha saŋ vehavɨmi. Vehavɨdaci Jon nulɨdɨ iga iga abami. Namɨlaŋ lahu sɨhɨpɨŋ dɨ ninanadi uami. Asɨ agaŋ nalusaŋ igɨvɨ hɨniavɨla naludɨ amɨŋ ci sɨbɨlɨ lamɨbali uami. Ani agaŋ naludɨ abɨci Asɨ hulaŋ iamɨgali sɨbɨlɨ lamɨbali agadɨ vala haŋɨlavɨhebalu aba lɨdalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Namɨlaŋ lusɨŋ sɨbɨlɨ sɨbɨlɨ agɨladɨ valavɨla ha sibɨla huaci huaci vibalaŋ uami. Hameŋ lɨdalaŋ hulaŋ iamɨgali limu hɨhɨle agɨlaŋ iga iga abavɨbali uami. Nɨbɨlaŋ lusɨŋ sɨbɨlɨ sɨbɨlɨ agɨladɨ ci valavala sibɨla huaci huaci vihavadi aba abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Namɨlaŋ hɨji nameŋ lamɨmɨlaŋ uami. Alaŋ Ebɨlam dɨ iamɨlɨhalinu sadaŋ Asɨ aludɨ ma sɨbɨlɨ lamɨbali aba abɨmɨlaŋ uami. Viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Asɨ agaŋ lɨba kum kum nagɨladɨ abɨci hulaŋ lɨfavɨla naludɨ uvɨsɨjiŋ vihavɨvi uami. La Ebɨlam dɨ iamɨlɨhalinu hɨniavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hulaŋ mu agaŋ cinaŋ viavɨla kɨlɨ ihɨben aba mabɨla hɨnihɨni me ci hɨnidi uami. Kɨlɨ agɨlaŋ amɨŋ huaci huaci ma lamavɨlalɨ agɨladɨ iha iha vivi havalɨdaci avɨŋ hɨvɨ mɨguavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Namɨlaŋ lusɨŋ sɨbɨlɨ sɨbɨlɨ agɨladɨ valɨdalaŋ viaŋ avɨli hɨvɨ naludɨ mɨŋamɨgu mɨŋaiahɨlan uami. Agadɨ ala hulaŋ mu iadɨ sɨvɨ vebali agadɨ vɨdɨvɨdɨŋ agaŋ iadɨ vɨdɨvɨdɨŋ agadɨ lɨvalɨbali uami. Viaŋ hulaŋ havɨ uami. Viaŋ ibi apalɨ uami. Viaŋ ibi daŋ lɨci viaŋ nudɨ ahɨliahua nudɨ hɨcɨ sɨgɨtɨ agadɨ huaci via uvin uami. Nɨbu avɨli hɨvɨ naludɨ mɨŋamɨgu mɨŋaiahɨdaci Asɨ dɨ Amɨŋ agaŋ veve namɨlaŋ hula hɨnibali uami. Limu hɨhɨle lusɨŋ sɨbɨlɨ ma valɨlalaŋ naludɨ mufɨli avɨŋ hɨvɨ havalɨdaci mɨgubalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nɨbu sahua cɨkaŋ agadɨ mɨŋalɨvavɨla hɨnidi uami. Sahua cɨkaŋ agadɨ hɨvɨ ala halɨha cahu uitɨ agɨladɨ lɨbɨlicilici mɨŋaiahɨdaci hɨtɨŋ hɨtɨŋ mɨgalahɨlavɨbali uami. Mɨgalahɨlavɨdaci sɨgɨtɨ sɨmum agɨladɨ vivi avɨŋ ma hɨmɨlalɨ agadɨ hɨvɨ havalɨdaci mɨguavɨbali uami. Amɨŋ agɨladɨ vivi sɨmɨŋ mɨgudɨbalɨba hɨsɨŋ ulaŋ heŋ mɨgudɨbɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jisasɨ Galili fɨli tɨbɨ vala Jolɨdan avɨli caba heŋ umi. Jon agaŋ avɨli hɨvɨ iadɨ mɨŋamɨgu mɨŋaiahɨbali aba umi. ");
INSERT INTO ena_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ua iahɨci Jon agaŋ Jisasɨ dɨ abamɨgɨlɨben aba nudɨ abami. Nama avɨli hɨvɨ iadɨ mɨŋamɨgu mɨŋaiahɨnaŋ ha huaci uami. Akɨ saŋ nama iadɨ pɨŋ venaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Lɨci ala Jisasɨ nudɨ abami. Ha ci uami. Viaŋ abin hameŋ laci ala lɨha uami. Asɨ agaŋ alaŋ akuaba akuaba sibɨla hameŋ agɨladɨ vivi saŋ abami uami. Nama hameŋ lɨnaŋ alaŋ nudɨ ciaŋ agadɨ sɨhɨvia lubiahɨlɨbalu uami. Lɨci Jon agaŋ Jisasɨ abami hameŋ laci ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Avɨli hɨvɨ Jisasɨ dɨ mɨŋamɨgu mɨŋaiahɨci hɨvɨ igaiahua igami. Igaiahua igɨci Asɨ agaŋ lɨci avɨli susu agaŋ hɨbɨ me lavɨlami. Lavɨlɨci Asɨ dɨ Amɨŋ agaŋ havaŋ ibɨlabi me vuha mɨgavɨla Jisasɨ dɨ hɨvɨ mɨgahɨnimi. ");
INSERT INTO ena_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mɨgahɨnidaci Asɨ nudɨ haiabɨla heŋ hɨniavɨla Jisasɨ saŋ nameŋ abami. Ha iadɨ nukeŋ Ninaŋ uami. Viaŋ nusaŋ mavɨn hekɨlɨ hɨnihɨni hɨjɨŋalɨlan uami. ");
INSERT INTO ena_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Laguŋ agaŋ Jisasɨ dɨ ilasɨbali aba Asɨ dɨ Amɨŋ agaŋ Jisasɨ dɨ hɨji mɨŋaiahavɨla abɨci Jolɨdan avɨli agadɨ valavɨla fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ umi. ");
INSERT INTO ena_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ua heŋ hɨnihɨni sɨmɨŋ cɨki avi ma nami. Havɨ sɨbaŋ hɨnidaci uaiaŋ 38 agaŋ umi. Lɨci humɨgaŋ ibɨlibɨliŋ hekɨlɨ agaŋ nudɨ hɨvɨ iahami. ");
INSERT INTO ena_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Iahɨci laguŋ agaŋ nudɨ ilasɨben aba iahavɨla abami. Nama Asɨ dɨ Ninaŋ lɨci lɨba kum kum nagɨladɨ abɨnaŋ maci lɨfavɨci nɨha uami. ");
INSERT INTO ena_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Lɨci Jisasɨ cɨhu hɨbɨŋ nudɨ abami. Asɨ dɨ manasɨŋ hekɨlɨ agaŋ nameŋ abami uami. Maci agaŋ hulaŋ iamɨgali agɨladɨ ahɨliahudaci huaci hameŋ laci hameŋ laci ma hɨniavɨbali aba abami uami. Agadɨ ala hulaŋ iamɨgali Asɨ dɨ ciaŋ agadɨ lubiahɨlavɨla aba abami uami. Ha huaci hameŋ laci hameŋ laci hɨniavɨbali aba abami uami. ");
INSERT INTO ena_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Lɨci laguŋ agaŋ Jisasɨ dɨ viavɨla Jelusalem haiabɨla umi. Via uavɨla Asɨ dɨ aŋam ulaŋ hekɨlɨ iahua sabɨ sɨbaŋ heŋ lamavɨla nudɨ abami. ");
INSERT INTO ena_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nama Asɨ dɨ Ninaŋ lɨci havala mɨguha uami. Asɨ dɨ manasɨŋ hekɨlɨ agaŋ nameŋ abami uami. Asɨ agaŋ abɨci nudɨ ciaŋ hali hɨsɨŋ agɨlaŋ nadɨ migɨla migɨla hɨniavɨbali aba abami uami. Lavɨla nɨbɨlaŋ nulɨdɨ human hɨvɨ nadɨ mɨŋalɨvavɨbali aba abami uami. Mɨŋalɨvavɨci lɨba henaŋ henaŋ daŋ agɨlaŋ nadɨ hɨcɨ ma iamɨlavɨbali aba abami uami. ");
INSERT INTO ena_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Lɨci Jisasɨ nudɨ cɨhu ala abami. Asɨ dɨ manasɨŋ hekɨlɨ agaŋ nameŋ abami uami. Nama Asɨ dɨ ilasɨmɨnaŋ aba abami uami. Nɨbu nadɨ Hekɨlɨ aba abami uami. ");
INSERT INTO ena_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","9","Lɨci laguŋ agaŋ Jisasɨ dɨ via halu hekɨlɨ mu heŋ iahuavɨmi. Iahuavɨla haiabɨla hekɨlɨ hekɨlɨ agɨladɨdaŋ nulɨdɨ akuaba akuaba huaci huaci agɨladɨdaŋ sɨkasɨkan igoua igave iga iga abalamavɨla abami. Nama iadɨ ibi mɨŋaiahaiaha saŋ mɨgalɨfɨlɨbavɨla nadɨ hali agadɨ fɨli hɨvɨ lɨbɨlɨvɨnaŋ akuaba akuaba sɨkasɨkan nagɨladɨ nasaŋ iguben uami. ");
INSERT INTO ena_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Lɨci Jisasɨ nudɨ abami. Satan nama iadɨ valavɨla uha uami. Asɨ dɨ manasɨŋ hekɨlɨ agaŋ nameŋ abami uami. Asɨ nɨbu nadɨ Hekɨlɨ aba abami uami. Nama nudɨ ibi laci mɨŋaiahaiaha saŋ mɨgalɨfɨlɨbɨha aba abami uami. Lavɨla nudɨ sibɨla laci viha aba abami uami. ");
INSERT INTO ena_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Lɨci laguŋ agaŋ nudɨ vala umi. Vala udaci Asɨ dɨ ciaŋ hali hɨsɨŋ agɨlaŋ vevɨla Jisasɨ dɨ ahɨliahuavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","13","Jisasɨ agaŋ Jon dɨ via lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ lamavɨmi agadɨ ciaŋ hɨjɨ igahɨlami. Lavɨla Galili fɨli tɨbɨ uavɨla Nasaletɨ haiabɨla hɨnimi. La haiabɨla agadɨ valavɨla ua cɨhu Kapelɨneam haiabɨla hɨnimi. Kapelɨneam haiabɨla agaŋ Galili idu caba Sebulun hɨdɨlɨ Napɨtali hɨdɨlɨ agɨladɨ fɨli tɨbɨ heŋ hɨniadami. ");
INSERT INTO ena_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","16","Akuaba akuaba hadɨhu iahavɨmi agɨlasaŋ ala vaka Asɨ agaŋ nudɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ Aisaia saŋ hɨji igudaci nameŋ abami. Sebulun hɨdɨlɨ agɨladɨ fɨli tɨbɨ agaŋ avɨli hekɨlɨ saŋ uu veve hɨbɨ pɨlɨ caba heŋ hɨnilalɨ uami. Napɨtali hɨdɨlɨ agɨladɨ fɨli tɨbɨ agaŋ avi heŋ ala hɨnilalɨ uami. Fɨli tɨbɨ agɨlaŋ Jolɨdan avɨli agadɨ limu caba Galili fɨli tɨbɨ heŋ hɨniavɨlalɨ uami. Hulaŋ iamɨgali hɨdɨlɨ mu mu agɨlaŋ avi heŋ ala hɨniavɨlalɨ uami. Vaka nɨbɨlaŋ hɨfɨlɨ hekɨlɨ me hɨvɨ hɨniavɨhadami uami. Agadɨ ala cɨhu abɨlu hekɨlɨ agadɨ ci igavalɨ uami. Hulaŋ iamɨgali agɨlaŋ fipɨ hɨfɨlɨ hekɨlɨ me heŋ hɨnihɨni hɨmahɨma saŋ lɨdalɨda hɨniavɨhadami uami. Lɨhavɨdaci abɨlu agaŋ nulɨdɨ hɨvɨ ci iahalɨ uami. Lɨci Aisaia abami hameŋ laci ala lɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jisasɨ agaŋ Galili fɨli tɨbɨ heŋ hɨdɨlɨ maha Asɨ dɨ ciaŋ sulasula hulaŋ iamɨgali agɨladɨ nameŋ abadami. Asɨ hulaŋ iamɨgali agɨladɨ amɨŋ ci likɨlɨci nudɨ lɨhu hɨvɨ hɨniavɨbali uadami. Hameŋ sadaŋ namɨlaŋ lusɨŋ sɨbɨlɨ sɨbɨlɨ agɨladɨ valɨhalaŋ uadami. ");
INSERT INTO ena_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Hameŋ aba aba Galili idu hekɨlɨ caba heŋ hɨdavɨla hulaŋ ahica nusi nula agɨladɨ igami. Saimon dɨdaŋ Edɨlu dɨdaŋ igami. Saimon dɨ ibi mu Pita uavɨhadami. Nɨbɨlaŋ mɨkɨdiŋ lamalama hehɨlaŋ vivi mutɨŋ hɨvɨ lamalama anɨm hɨlɨcɨ sibɨla vihavɨhadami. Sibɨla hameŋ agadɨ vivi hɨniavɨdaci Jisasɨ ua nulɨdɨ igami. ");
INSERT INTO ena_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Igavɨla nulɨdɨ abami. Ahica namɨlaŋ velaŋ alaŋ ahuata hɨdɨmɨli uami. Hɨdahɨda hulaŋ iamɨgali likɨla likɨla saŋ naludɨ lamalubiben uami. ");
INSERT INTO ena_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Lɨci ahica agɨlaŋ lɨhalɨha sɨbaŋ nulɨdɨ mɨkɨdiŋ agɨladɨ valavɨla iaha Jisasɨ hula uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Umitavɨla Jisasɨ agaŋ cɨhu Sebedi ninadinu ahica agɨladɨ igami. Mu Jemɨsɨ. Mu Jon. Nɨbɨlaŋ iaganɨlu Sebedi hula hunɨga hɨvɨ idu caba heŋ hɨniavɨmi. Nulɨdɨ mɨkɨdiŋ pilapila uavɨmi agɨladɨ ifɨhɨcahɨca hɨniavɨmi. Lɨhavɨdaci Jisasɨ agaŋ nulɨdɨ avi nɨbu hula uu saŋ abami. ");
INSERT INTO ena_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Lɨci lɨhalɨha sɨbaŋ iaganɨlu dɨdaŋ hunɨga agadɨdaŋ valavɨla iaha Jisasɨ ani ani uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisasɨ agaŋ Galili fɨli tɨbɨ heŋ hɨnihɨni haiabɨla mu hɨvɨ mu hɨvɨ hɨdadami. Hɨdahɨda Isɨlaelɨ hɨdɨlɨ agɨladɨ aŋam ulaŋ hɨvɨ ivo ivo hulaŋ iamɨgali agɨladɨ lamalubiadami. Asɨ hulaŋ iamɨgali agɨladɨ likɨlɨci nudɨ lɨhu hɨvɨ hɨniavɨbali agasaŋ suladami. Sulasula hɨdahɨda hulaŋ iamɨgali hɨmuhɨmu daŋ agɨladɨ huaci lamadami. Akuaba akuaba hɨmuhɨmu mu hɨdɨlɨ mu hɨdɨlɨ hulaŋ iamɨgali agɨladɨ sɨbɨlɨ lamavɨhadami agɨladɨ avi lɨdaci huaci lɨhavɨhadami. ");
INSERT INTO ena_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Lɨdaci nudɨ ciaŋ hɨjɨ agaŋ Silia fɨli tɨbɨ sɨkasɨkan heŋ umi vemi. Lɨdaci heŋ hɨsɨŋ agɨlaŋ avi hulaŋ iamɨgali hɨmuhɨmu mu hɨdɨlɨ mu hɨdɨlɨ daŋ hɨniavɨhadami agɨladɨ vavehavɨhadami. Hɨhɨle hulaŋ sudɨ sɨbɨlɨ daŋ agɨladɨ vavehavɨhadami. Hɨhɨle uava hɨmavɨhadami agɨladɨ vavehavɨhadami. Hɨhɨle nulɨdɨ henaŋ hɨmahɨma agɨladɨ vavehavɨhadami. Vavehavɨdaci Jisasɨ agaŋ hɨmuhɨmu daŋ agɨladɨ huaci lamalama sudɨ sɨbɨlɨ agɨladɨ avi lahuadami. ");
INSERT INTO ena_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Lɨdaci hulaŋ iamɨgali akape sɨbaŋ agɨlaŋ iahaiaha nɨbu hula uavɨhadami. Hulaŋ iamɨgali hɨhɨle Galili fɨli tɨbɨ hɨsɨŋ. Hɨhɨle Dekapolisɨ fɨli tɨbɨ hɨsɨŋ. Hɨhɨle Jelusalem haiabɨla hɨsɨŋ. Hɨhɨle Judia fɨli tɨbɨ hɨsɨŋ. Hulaŋ iamɨgali Jolɨdan avɨli agadɨ limu caba heŋ hɨniavɨhadami agɨlaŋ avi iahaiaha nɨbu hula uavɨhadami. ");
INSERT INTO ena_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisasɨ agaŋ igɨdaci hulaŋ iamɨgali akape sɨbaŋ vehavɨmi. Vehavɨdaci nɨbu halu hɨvɨ iahumi. Iahua mɨgahɨnidaci nudɨ hulemɨlɨ agɨlaŋ nudɨ pɨŋ vehavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Vehavɨci ciaŋ nagadɨ hɨdɨlɨ maha nulɨdɨ abami. ");
INSERT INTO ena_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Hulaŋ iamɨgali nulɨdɨ amɨŋ agɨlaŋ vɨdɨvɨdɨŋ apalɨ hɨniavɨdaci ala nɨbɨlaŋ Asɨ saŋ pam igahɨlavɨlalɨ agɨlaŋ hɨjɨŋalavɨm uami. Asɨ nulɨdɨ likɨlɨci nudɨ lɨhu hɨvɨ ci hɨniavadi uami. ");
INSERT INTO ena_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Hulaŋ iamɨgali ilɨha ilɨha hɨniavɨlalɨ agɨlaŋ hɨjɨŋalavɨm uami. Mufɨli Asɨ nulɨdɨ mavɨn ifɨmɨgubali uami. ");
INSERT INTO ena_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Hulaŋ iamɨgali nulɨdɨ nukeŋ ibi ma mɨŋaiahavɨlalɨ agɨlaŋ hɨjɨŋalavɨm uami. Mufɨli Asɨ agaŋ fɨli nagadɨ nulɨsaŋ sɨkasɨkan igubali uami. ");
INSERT INTO ena_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Hulaŋ iamɨgali sɨmɨŋ nana saŋ mavɨn hɨniavɨlalɨ hameŋ laci ala Asɨ dɨ ciaŋ sɨhɨvia lubiahɨlahɨla saŋ mavɨn hɨniavɨlalɨ agɨlaŋ hɨjɨŋalavɨm uami. Avɨli nana saŋ mavɨn hɨniavɨlalɨ hameŋ laci ala Asɨ dɨ ciaŋ sɨhɨvia lubiahɨlahɨla saŋ mavɨn hɨniavɨlalɨ agɨlaŋ hɨjɨŋalavɨm uami. Mufɨli nɨbɨlaŋ hulaŋ iamɨgali sɨmɨŋ nana humɨgaŋ laguavɨlalɨ hameŋ laci ala Asɨ dɨ ciaŋ agadɨ sɨhɨvia lubiahɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Hulaŋ iamɨgali limu hɨhɨle agɨlasaŋ mavɨn hɨnihɨni nulɨdɨ huaci lamavɨlalɨ agɨlaŋ hɨjɨŋalavɨm uami. Mufɨli Asɨ nulɨsaŋ avi mavɨn hɨnihɨni nulɨdɨ huaci lamɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Asɨ igɨdaci hulaŋ iamɨgali hɨji humɨgaŋ huaci daŋ hɨniavɨlalɨ agɨlaŋ hɨjɨŋalavɨm uami. Mufɨli nɨbɨlaŋ Asɨ dɨ igavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Hulaŋ iamɨgali ciaŋ sagaŋ hɨnilahavɨlalɨ agɨlaŋ hɨjɨŋalavɨm uami. Mufɨli Asɨ nulɨdɨ nameŋ abɨbali uami. Namɨlaŋ iadɨ ninanadi aba abɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Hulaŋ iamɨgali Asɨ dɨ ciaŋ sɨhɨvia lubiahɨlavɨdaci hulaŋ limu hɨhɨle nulɨdɨ sɨbɨlɨ lamavɨlalɨ uami. Nulɨdɨ sɨbɨlɨ lamavɨdaci hɨjɨŋalavɨm uami. Asɨ nulɨdɨ likɨlɨci nudɨ lɨhu hɨvɨ ci hɨniavadi uami. ");
INSERT INTO ena_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Namɨlaŋ iadɨ ciaŋ agadɨ lubiahɨlɨdalaŋ naludɨ analɨ aba aba lɨbɨmɨgumɨgu ciaŋ sɨbɨlɨ sɨbɨlɨ abavɨbali uami. Lɨdɨŋ naludɨ sɨbɨlɨ lamavɨbali uami. Hameŋ lɨhavɨdaci namɨlaŋ hɨjɨŋalɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Vaka nulɨdɨ ave iauacaŋ agɨlaŋ Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ agɨladɨ sɨbɨlɨ lamavɨhadami uami. Hameŋ laci ala naludɨ avi sɨbɨlɨ lamavɨbali uami. Akuaba akuaba vɨhɨlɨ naludɨ hɨvɨ iahavɨdaci namɨlaŋ hekɨlɨ hɨjɨŋalaŋala hɨnihalaŋ uami. Ci igɨlaŋ uami. Mufɨli namɨlaŋ akuaba akuaba hekɨlɨ hekɨlɨ vibalaŋ agɨlaŋ Asɨ dɨ haiabɨla heŋ ci hɨniavadi uami. ");
INSERT INTO ena_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Lavɨla Jisasɨ cɨhu abami. Namɨlaŋ fɨli neŋ lulɨm me hɨnilalaŋ uami. Agadɨ ala lulɨm agaŋ sɨdaŋ apalɨ lavɨla cɨhu huaci ma lɨlalɨ uami. Lulɨm hameŋ agaŋ nɨbu sibɨla apalɨ uami. Nudɨ havɨ mɨŋamɨjiavɨla nudɨ sabɨ hɨvɨ lagulagu uu veve hɨdavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Namɨlaŋ fɨli neŋ unɨ abɨlu me hɨnilalaŋ uami. Haiabɨla mu halu hɨvɨ hɨnidaci nudɨ unɨ abɨlu agaŋ ma sɨvɨlɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Hulaŋ iamɨgali agɨlaŋ unɨ lubilamavɨci lɨhulɨhu hɨnidaci sɨji agadɨ via iupalavɨci mɨgua unɨ agadɨ ma lalɨgua hɨnilalɨ uami. Nɨbɨlaŋ unɨ agɨladɨ lubilamalama vadɨm sabɨ hɨvɨ lamavɨdaci hɨniavɨlalɨ uami. Hɨniavɨdaci hulaŋ iamɨgali ulaŋ heŋ hɨniavɨlalɨ agɨlaŋ unɨ abɨlu hɨvɨ hɨniavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Namɨlaŋ unɨ abɨlu me hɨnihɨni akuaba akuaba sibɨla huaci huaci agɨladɨ vihalaŋ uami. Vidalaŋ hulaŋ iamɨgali agɨlaŋ iga iga naludɨ Iaganalu Asɨ iahua hɨvɨ hɨnilalɨ agadɨ ibi mɨŋaiahavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Lavɨla Jisasɨ cɨhu abami. Namɨlaŋ iasaŋ hɨji nameŋ lamɨmɨlaŋ uami. Nɨbu Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ agɨlaŋ ciaŋ sulavɨhadami agɨladɨdaŋ ciaŋ vɨdɨvɨdɨŋ Mosesɨ lɨbami agadɨdaŋ lɨci sɨvɨla sɨvɨla saŋ ve aba abɨmɨlaŋ uami. Viaŋ Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ agɨlaŋ ciaŋ sulavɨhadami agɨladɨdaŋ ciaŋ vɨdɨvɨdɨŋ Mosesɨ lɨbami agadɨdaŋ lɨdalɨŋ vɨdɨvɨdɨŋ hɨniavɨbali agasaŋ vemin uami. ");
INSERT INTO ena_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Viaŋ naludɨ amɨŋ abadin uami. Fɨli uaiaŋ susu akuaba akuaba agɨlaŋ vakala hɨniavɨdaci ciaŋ vɨdɨvɨdɨŋ Mosesɨ lɨbami agaŋ ma sɨvɨlɨbali uami. Ciaŋ vɨdɨvɨdɨŋ agadɨ ciaŋ limu tɨbɨ cɨki avi ma sɨbaŋ sɨvɨlɨbali uami. Ciaŋ vɨdɨvɨdɨŋ agaŋ hameŋ laci hɨnidaci Asɨ agaŋ akuaba akuaba lɨlɨ saŋ abami agɨlaŋ iahavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Hulaŋ mu ciaŋ vɨdɨvɨdɨŋ sɨkasɨkan agɨladɨ lubiahɨlɨlalɨ agaŋ ciaŋ vɨdɨvɨdɨŋ pabiŋ cɨki agadɨ lulɨlalɨ uami. Lulalula hulaŋ iamɨgali limu hɨhɨle agɨladɨ abɨdaci nudɨ hɨji lubiahɨlavɨdaci uami. Ha Asɨ hulaŋ iamɨgali agɨladɨ likɨlɨci nudɨ lɨhu hɨvɨ hɨniavɨbali heŋ nɨbu avi hɨnibali uami. Agadɨ ala nɨbu ibi hekɨlɨ daŋ ma hɨnibali uami. Hulaŋ mu ciaŋ vɨdɨvɨdɨŋ agɨladɨ lubiahɨlahɨla hulaŋ iamɨgali hɨhɨle agɨladɨ abɨdaci nudɨ hɨji lubiahɨlavɨdaci uami. Ha nɨbu Asɨ hulaŋ iamɨgali likɨlɨci nudɨ lɨhu hɨvɨ hɨniavɨbali heŋ nɨbu ibi hekɨlɨ daŋ hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Namɨlaŋ Asɨ dɨ ciaŋ agadɨ sɨhɨvia sɨbaŋ lubiahɨlɨhalaŋ uami. Lavɨla Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agadɨ lamalubilubi hɨsɨŋ hulaŋ agɨladɨdaŋ Falisi hɨdɨlɨ agɨladɨdaŋ lɨvala lɨvala akuaba akuaba sibɨla huaci huaci sɨbaŋ agɨladɨ vihalaŋ uami. Namɨlaŋ hameŋ lɨlaŋ Asɨ naludɨ likɨlɨci nudɨ lɨhu hɨvɨ hɨnibalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Lavɨla Jisasɨ cɨhu abami. Vaka Asɨ agaŋ naludɨ iamɨlɨhalinalu agɨladɨ nameŋ abami uami. Namɨlaŋ hulaŋ iamɨgali limu hɨhɨle agɨladɨ ifɨhɨmɨmɨlaŋ aba abami uami. Aniaba hulaŋ agaŋ hulaŋ mu dɨ ifɨhɨmavɨla nɨbu hugɨ daŋ hɨnidaci nudɨ ciaŋ hɨvɨ lamavɨbali aba abami uami. Ciaŋ hameŋ agɨladɨ tɨbi sulavɨdaci igahɨlɨlalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Agadɨ ala viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Hulaŋ mu nudɨ isaima me agɨlasaŋ igɨvɨ hɨniavɨla hugɨ daŋ hɨnidaci uami. Ha hulaŋ igɨvɨ daŋ hɨnibali agadɨ ciaŋ hɨvɨ lamavɨbali uami. Hulaŋ mu nudɨ isaima me agɨladɨ ciaŋ sɨbɨlɨ abavɨla nɨbu hugɨ daŋ hɨniavɨla uami. Ha nɨbu hulaŋ cihu tɨbaŋ daŋ agɨladɨ pɨŋ um uami. Hulaŋ mu agaŋ nudɨ isaima me agɨladɨ namɨlaŋ uavauava aba abavɨla uami. Ha nɨbu hugɨ daŋ hɨnidaci Asɨ nudɨ via avɨŋ hɨvɨ havalɨci mɨgubali uami. ");
INSERT INTO ena_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nama sagalɨ hɨlahɨla hɨsɨŋ sɨmɨŋ akuaba akuaba viavɨla Asɨ saŋ sagalɨ hɨlahɨla hɨsɨŋ vadɨm heŋ uavɨla nadɨ isaima me agaŋ hula hugɨ daŋ hɨnidanaŋ agasaŋ igahɨlavɨla uami. ");
INSERT INTO ena_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Akuaba akuaba Asɨ saŋ sagalɨ igu igu hɨsɨŋ via ubanaŋ agɨladɨ sagalɨ hɨlahɨla hɨsɨŋ vadɨm caba heŋ lamɨha uami. Lamavɨla cɨhu ve nadɨ isaima me agaŋ hula ciaŋ hihɨlɨha uami. Hihɨlɨnaŋ ci lɨci heŋ uavɨla Asɨ saŋ sagalɨ iguha uami. ");
INSERT INTO ena_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Hulaŋ mu agaŋ nadɨ lɨbɨmɨgumɨgu ciaŋ hɨvɨ lamɨben aba lɨci uami. Nama nɨbu hula hɨbɨ cina uu nɨbu hula ciaŋ hihɨlavɨheha uami. Hameŋ lɨnaŋ hulaŋ agaŋ nadɨ via ua ciaŋ hihɨla hihɨla hɨsɨŋ hulaŋ agadɨ human hɨvɨ ma lamɨbali uami. Ciaŋ ma hihɨlɨmaŋ lɨnaŋ nadɨ via ua ciaŋ hihɨla hihɨla hɨsɨŋ hulaŋ agadɨ human hɨvɨ lamɨbali uami. Lamɨci nadɨ via uavɨla hɨmi sɨbɨlɨ dɨ human hɨvɨ lamɨbali uami. Lamɨci hɨmi sɨbɨlɨ agaŋ nadɨ via ua lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ lamɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Viaŋ nadɨ amɨŋ abadin uami. Lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ lamavɨla anɨm hɨlɨcɨ vameba hɨvɨ lavalava saŋ abavɨci uami. Ha hameŋ laci lavɨbanaŋ uami. Lava fɨhalavɨla haiabɨla heŋ ivavebanaŋ uami. Nama ma lavavɨla uami. Ha haiabɨla ma ivavebanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Lavɨla Jisasɨ cɨhu abami. Vaka Asɨ agaŋ naludɨ iamɨlɨhalinalu agɨladɨ nameŋ abami uami. Hulaŋ iamɨgali daŋ namɨlaŋ naludɨ abinadinalu agɨladɨ valavala uu iamɨgali mu mu agɨladɨ sɨgɨlɨ vimɨlaŋ aba abami uami. Iamɨgali hulaŋ daŋ namɨlaŋ naludɨ muŋanadinalu agɨladɨ valavala uu hulaŋ mu mu agɨladɨ sɨgɨlɨ vimɨlaŋ aba abami uami. Ciaŋ hameŋ agɨladɨ tɨbi sulavɨdaci igahɨlɨlalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Agadɨ ala viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Hulaŋ mu agaŋ iamɨgali mu hulaŋ dɨ agadɨ havɨ mavɨn igɨci uami. Asɨ igɨci nɨbu nudɨ hɨji hɨvɨ abinu dɨ vala ua iamɨgali mu sɨgɨlɨ ci vivi me hɨnilalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nadɨ lamɨgaŋ sɨmi kɨlikɨli agaŋ lɨci nama lusɨŋ sɨbɨlɨ viavɨla uami. Nadɨ lamɨgaŋ sɨmi kɨlikɨli agadɨ mɨŋatɨhua havalɨha uami. Hameŋ lɨbanaŋ agaŋ nɨbu huaci uami. Lɨnaŋ nadɨ lamɨgaŋ limu laci hɨnidaci Asɨ agaŋ nadɨ hadipɨlɨ sɨkasɨkan agadɨ avɨŋ hɨvɨ ma havalɨci mɨgubali uami. Nadɨ lamɨgaŋ sɨmi kɨlikɨli agaŋ lɨci lusɨŋ sɨbɨlɨ viavɨla nudɨ ma mɨŋatɨhua havalɨnaŋ uami. Ha Asɨ agaŋ nadɨ hadipɨlɨ sɨkasɨkan agadɨ avɨŋ hɨvɨ havalɨci mɨgubali uami. ");
INSERT INTO ena_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nadɨ human sɨmi agaŋ lɨci lusɨŋ sɨbɨlɨ viavɨla uami. Human sɨmi agadɨ ihalaha havalɨha uami. La human limu laci daŋ hɨniha uami. Lɨnaŋ Asɨ agaŋ nadɨ hadipɨlɨ sɨkasɨkan agadɨ avɨŋ hɨvɨ ma havalɨbali uami. Nadɨ human sɨmi agaŋ lɨci lusɨŋ sɨbɨlɨ viavɨla nudɨ ma ihalaha havalɨnaŋ uami. Ha Asɨ nadɨ hadipɨlɨ sɨkasɨkan agadɨ avɨŋ hɨvɨ havalɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Lavɨla Jisasɨ cɨhu abami. Vaka Mosesɨ agaŋ nameŋ abami uami. Hulaŋ mu abinu dɨ valavɨla lahuben aba nusaŋ manasɨŋ lɨbavɨla igum aba abami uami. ");
INSERT INTO ena_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Agadɨ ala viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Iamɨgali mu hɨvɨkalɨ saŋ ma hɨdɨvi uami. Agadɨ ala muŋanu nudɨ lahuci ua havɨ hɨnivi uami. Hɨnidaci hulaŋ mu nudɨ sabivi uami. Sabici Asɨ iamɨgali agadɨ igɨci nɨbu muŋanu lɨvɨlu agadɨ vala ua muŋaŋ hɨhi agaŋ hula hɨnivi agasaŋ nɨbu hugɨ daŋ hɨnivi uami. Iamɨgali hulaŋ mu mu sɨgɨlɨ vihavɨlalɨ agɨlaŋ me hɨnivi uami. Muŋanu lɨvɨlu agaŋ nukeŋ lɨci iamɨgali agaŋ hugɨ daŋ hɨnivi uami. Lɨci Asɨ agaŋ muŋanu hɨhi agadɨ igɨci iamɨgali agaŋ hula hɨniavɨla nɨbu avi hugɨ daŋ hɨnivi uami. Hulaŋ agɨlaŋ iamɨgali mu mu sɨgɨlɨ vihavɨlalɨ agɨlaŋ me hɨnivi uami. ");
INSERT INTO ena_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Lavɨla Jisasɨ cɨhu abami. Vaka Asɨ agaŋ naludɨ iamɨlɨhalinalu agɨladɨ nameŋ abami uami. Namɨlaŋ akuaba akuaba lɨlɨ saŋ analɨ abavɨla hɨvɨ hekɨlɨ aba abɨmɨlaŋ aba abami uami. Namɨlaŋ naludɨ Hekɨlɨ dɨ ibi hɨvɨ akuaba akuaba lɨlɨ saŋ hɨvɨ hekɨlɨ aba abavɨla aba abami uami. Ha hameŋ laci ala lɨhalaŋ aba abami uami. Ciaŋ hameŋ agɨladɨ tɨbi sulavɨdaci igahɨlɨlalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Agadɨ ala viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Hulaŋ hɨhɨle agɨlaŋ naludɨ ciaŋ agadɨ igahɨlavɨla amɨŋ ala aba abavɨbali aba hɨvɨ hekɨlɨ aba abɨmɨlaŋ uami. Namɨlaŋ akuaba akuaba saŋ abɨben aba uaiaŋ susu agadɨ ibi luvɨla luvɨla hɨvɨ hekɨlɨ aba abɨmɨlaŋ uami. Uaiaŋ susu nɨbu Asɨ dɨ mɨgahɨnihɨni hɨsɨŋ uvɨ me uami. ");
INSERT INTO ena_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Lavɨla fɨli nagadɨ ibi luvɨla luvɨla hɨvɨ hekɨlɨ aba abɨmɨlaŋ uami. Ha Asɨ dɨ hɨcɨ lamalama hɨsɨŋ fipɨ me uami. La Jelusalem haiabɨla agadɨ ibi luvɨla luvɨla hɨvɨ hekɨlɨ aba abɨmɨlaŋ uami. Ha manɨgali hekɨlɨ agadɨ haiabɨla uami. ");
INSERT INTO ena_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Namɨlaŋ naludɨ hali mɨnɨ agɨladɨ lɨlaŋ mila ma hɨniavɨvi uami. Cɨbɨŋ avi ma hɨniavɨvi uami. Hameŋ sadaŋ namɨlaŋ akuaba akuaba saŋ abɨben aba naludɨ nukeŋ hali agadɨ ibi luvɨla luvɨla hɨvɨ hekɨlɨ aba abɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Amɨŋ lɨci amɨŋ aba abɨhalaŋ uami. Hɨma lɨci hɨma aba abɨhalaŋ uami. Ciaŋ hɨhɨle abavɨlalɨ ha laguŋ dɨ hɨji agadɨ lubiahɨlahɨla abavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Lavɨla Jisasɨ cɨhu abami. Vaka Asɨ agaŋ naludɨ iamɨlɨhalinalu agɨladɨ nameŋ abami uami. Hulaŋ mu agaŋ hulaŋ mu dɨ lamɨgaŋ ifɨcɨpɨlɨci aba abami uami. Hɨbɨŋ nudɨ lamɨgaŋ agadɨ avi ifɨcɨpɨlɨhalaŋ aba abami uami. Mɨka ifɨtaualɨci hɨbɨŋ nudɨ mɨka agadɨ avi ifɨtaualɨhalaŋ aba abami uami. Ciaŋ hameŋ agɨladɨ tɨbi sulavɨdaci igahɨlɨlalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Agadɨ ala viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Hulaŋ iamɨgali hɨhɨle naludɨ sɨbɨlɨ lamavɨci uami. Namɨlaŋ hɨbɨŋ nulɨdɨ sɨbɨlɨ lamɨmɨlaŋ uami. Hulaŋ iamɨgali limu hɨhɨle naludɨ mɨhum human sɨmi kɨlikɨli agadɨ ifavɨci uami. Cɨhu limu cimɨlɨlaŋ mɨhum limu agadɨ avi ifavɨm uami. ");
INSERT INTO ena_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Hulaŋ iamɨgali limu hɨhɨle naludɨ hadi hɨlahɨla vivi saŋ naludɨ ciaŋ hɨvɨ lamavɨbali uami. Lamavɨla naludɨ hadi hɨlahɨla agɨladɨ vihavɨbali uami. Vihavɨci namɨlaŋ naludɨ hadi hɨlahɨla hutesɨ mu agadɨ avi valɨlaŋ vihavɨm uami. ");
INSERT INTO ena_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Sagaŋ hɨsɨŋ hulemɨlɨ limu hɨhɨle agɨlaŋ uami. Namɨlaŋ nulɨdɨ akuaba akuaba agɨladɨ viavɨla ua fipɨ abeba lamalama saŋ vɨdɨvɨdɨŋ aba lɨbɨsɨlɨvavɨci uami. Namɨlaŋ nulɨdɨ ahɨliahua akuaba akuaba agɨladɨ via ua fipɨ abavɨbali agadɨ lɨvalɨhalaŋ uami. Lɨvalavɨla hɨbɨ hutesɨ hɨdɨlɨ maha vameba vebalaŋ hameŋ laci ala uavɨla lamɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Hulaŋ iamɨgali limu hɨhɨle naludɨ akuaba akuaba agɨladɨ nulɨsaŋ igu igu saŋ abavɨci uami. Nulɨsaŋ iguhalaŋ uami. Naludɨ akuaba akuaba viavɨla cɨhu hɨbɨŋ nalusaŋ igubalu aba abavɨci nulɨsaŋ iguhalaŋ uami. Mɨlɨmɨŋɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Lavɨla Jisasɨ cɨhu abami. Vaka Asɨ agaŋ naludɨ iamɨlɨhalinalu agɨladɨ nameŋ abami uami. Naludɨ isagalinalu imahalinalu agɨlasaŋ pam mavɨn hekɨlɨ hɨnihalaŋ aba abami uami. Hulaŋ iamɨgali limu hɨhɨle naludɨ nagɨli lamavɨlalɨ agɨlasaŋ igɨvɨ hɨnihalaŋ aba abami uami. Ciaŋ hameŋ agɨladɨ tɨbi sulavɨdaci igahɨlɨlalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Agadɨ ala viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Hulaŋ iamɨgali naludɨ nagɨli lamavɨlalɨ agɨlasaŋ mavɨn hekɨlɨ hɨnihalaŋ uami. Hulaŋ iamɨgali limu hɨhɨle naludɨ sɨbɨlɨ lamavɨci uami. Namɨlaŋ Asɨ dɨ abɨlaŋ nulɨdɨ huaci lamam uami. ");
INSERT INTO ena_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Hameŋ lavɨla namɨlaŋ Iaganalu Asɨ iahua hɨvɨ hɨnilalɨ agadɨ ninanadi hɨnibalaŋ uami. Nɨbu ala lɨdaci uaiaŋ agaŋ hulaŋ iamɨgali huaci huaci agɨladɨ hɨvɨ hɨlɨlalɨ uami. Hulaŋ iamɨgali sɨbɨlɨ sɨbɨlɨ agɨladɨ hɨvɨ avi hɨlɨlalɨ uami. Nɨbu ala lɨdaci avɨli agaŋ hulaŋ iamɨgali Asɨ dɨ ciaŋ sɨhɨvia lubiahɨlavɨlalɨ agɨladɨ hɨvɨ mɨgɨlalɨ uami. Hulaŋ iamɨgali Asɨ dɨ ciaŋ sɨhɨvia ma lubiahɨlavɨlalɨ agɨladɨ hɨvɨ avi mɨgɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Hulaŋ huban saŋ anɨm hɨlɨcɨ vihavɨlalɨ agɨlaŋ uami. Nɨbɨlaŋ hulaŋ nulɨsaŋ mavɨn hekɨlɨ hɨniavɨlalɨ agɨlasaŋ pam mavɨn hekɨlɨ hɨniavɨlalɨ uami. Hameŋ sadaŋ Asɨ nulɨsaŋ akuaba akuaba huaci huaci agɨladɨ ma igubali uami. Namɨlaŋ nɨbɨlaŋ lɨhavɨlalɨ hameŋ lɨmɨlaŋ uami. Hulaŋ nalusaŋ mavɨn hekɨlɨ hɨniavɨlalɨ agɨlasaŋ pam mavɨn hekɨlɨ hɨnimɨlaŋ uami. Namɨlaŋ hulaŋ iamɨgali nalusaŋ mavɨn hekɨlɨ ma hɨniavɨlalɨ agɨlasaŋ avi mavɨn hekɨlɨ hɨnihalaŋ uami. Hameŋ lavɨla namɨlaŋ hulaŋ huban saŋ anɨm hɨlɨcɨ vihavɨlalɨ agɨladɨ lɨvalɨbalaŋ uami. Lɨlaŋ Asɨ nalusaŋ akuaba akuaba huaci huaci agɨladɨ igubali uami. ");
INSERT INTO ena_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Hulaŋ hɨdɨlɨ mu mu agɨlaŋ uami. Nɨbɨlaŋ nulɨdɨ isaima agɨlasaŋ pam mavɨn hɨnihɨni lamulavɨlalɨ uami. Hameŋ sadaŋ Asɨ nulɨsaŋ akuaba akuaba huaci huaci agɨladɨ ma igubali uami. Namɨlaŋ nɨbɨlaŋ lɨhavɨlalɨ hameŋ lɨmɨlaŋ uami. Naludɨ isaima agɨlasaŋ pam mavɨn hɨnihɨni lamulɨmɨlaŋ uami. Hulaŋ iamɨgali limu hɨhɨle agɨlasaŋ avi mavɨn hɨnihɨni lamulɨhalaŋ uami. Hameŋ lavɨla namɨlaŋ hɨdɨlɨ mu mu agɨladɨ lɨvalɨbalaŋ uami. Lɨlaŋ Asɨ nalusaŋ akuaba akuaba huaci huaci agɨladɨ igubali uami. ");
INSERT INTO ena_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Naludɨ Iaganalu Asɨ iahua hɨvɨ hɨnilalɨ agaŋ nɨbu huaci sɨbaŋ hɨnilalɨ uami. Hameŋ sadaŋ namɨlaŋ avi huaci laci nɨbu me sɨbaŋ hɨnihalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Lavɨla Jisasɨ cɨhu abami. Namɨlaŋ hɨji nameŋ lamɨmɨlaŋ uami. Alaŋ Asɨ dɨ ciaŋ sɨhɨvia lubiahɨlɨdamɨli hulaŋ iamɨgali agɨlaŋ aludɨ ibi mɨŋaiahaiaha abavɨbali aba abɨmɨlaŋ uami. Nɨbɨlaŋ Asɨ dɨ ciaŋ sɨhɨvia lubiahɨlavɨlalɨ aba abavɨbali aba abɨmɨlaŋ uami. Namɨlaŋ hameŋ lɨlaŋ naludɨ Iaganalu Asɨ iahua hɨvɨ hɨnilalɨ agaŋ nalusaŋ akuaba akuaba huaci huaci agɨladɨ ma igubali uami. ");
INSERT INTO ena_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Hulaŋ hɨhɨle nulɨsaŋ nukeŋ analɨ hɨji nameŋ lamalama abavɨlalɨ uami. Alaŋ hulaŋ huaci aba abavɨlalɨ uami. Lɨdɨŋ hulaŋ iamɨgali akuaba akuaba apalɨ agɨlasaŋ akuaba akuaba igubalu aba nameŋ lɨhavɨlalɨ uami. Hulaŋ mu agaŋ sibɨla hɨsɨŋ hulemɨlɨ mu agadɨ abɨci sai bihulɨ mahɨla mahɨla hali ulalɨ uami. Lɨdaci nɨbu akuaba akuaba agɨladɨ igu igu sɨvɨ ulalɨ uami. Hulaŋ hɨhɨle agɨlaŋ avi akuaba akuaba igubalu aba hameŋ laci ala lɨhavɨlalɨ uami. Isɨlaelɨ hɨdɨlɨ agɨladɨ aŋam ulaŋ hɨvɨ hameŋ lɨhavɨlalɨ uami. Hɨbɨ pɨlɨ hɨvɨ avi hameŋ ala lɨhavɨlalɨ uami. Hulaŋ iamɨgali hɨhɨle agɨlaŋ iga iga nɨbɨlaŋ hulaŋ huaci aba abavɨla aludɨ ibi mɨŋaiahavɨbali aba hameŋ lɨhavɨlalɨ uami. Namɨlaŋ nɨbɨlaŋ lɨhavɨlalɨ hameŋ lɨmɨlaŋ uami. Viaŋ naludɨ amɨŋ abadin uami. Nɨbɨlaŋ ibi hekɨlɨ ci vihavɨlalɨ sadaŋ Asɨ nulɨsaŋ akuaba cɨki avi ma sɨbaŋ igubali uami. ");
INSERT INTO ena_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Namɨlaŋ hulaŋ iamɨgali limu hɨhɨle akuaba akuaba apalɨ agɨlasaŋ akuaba akuaba igu igu saŋ igahɨlavɨla uami. Ha nulɨsaŋ iguhalaŋ uami. Lavɨla akuaba akuaba igubalaŋ agasaŋ hulaŋ hɨhɨle agɨladɨ abɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Hulaŋ iamɨgali limu hɨhɨle agɨlaŋ avi igavɨmɨdɨ uami. Sɨvɨla sɨvɨla iguhalaŋ uami. Hameŋ lɨdalaŋ Iaganalu Asɨ agaŋ akuaba akuaba nɨfɨlɨ cɨki lɨlalaŋ agɨladɨ igavɨla nalusaŋ akuaba akuaba huaci huaci agɨladɨ igubali uami. ");
INSERT INTO ena_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Lavɨla Jisasɨ cɨhu abami. Hulaŋ hɨhɨle nulɨsaŋ nukeŋ analɨ hɨji nameŋ lamalama abavɨlalɨ uami. Alaŋ hulaŋ huaci aba abavɨlalɨ uami. Lɨdɨŋ Asɨ dɨ abɨbalu aba Isɨlaelɨ hɨdɨlɨ agɨladɨ aŋam ulaŋ hɨvɨ ivo ivo abavɨlalɨ uami. Hɨhɨle hɨbɨ cɨma hekɨlɨ hekɨlɨ hɨvɨ lagulamalama abavɨlalɨ uami. Hulaŋ iamɨgali limu hɨhɨle agɨlaŋ aludɨ igavɨbali aba akuaba akuaba hameŋ agɨladɨ lɨhavɨlalɨ uami. Namɨlaŋ nɨbɨlaŋ lɨhavɨlalɨ hameŋ lɨmɨlaŋ uami. Viaŋ naludɨ amɨŋ abadin uami. Nɨbɨlaŋ ibi hekɨlɨ ci vihavɨlalɨ sadaŋ Asɨ nulɨsaŋ akuaba cɨki avi ma sɨbaŋ igubali uami. ");
INSERT INTO ena_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Namɨlaŋ Asɨ dɨ abɨben aba naludɨ uleŋ muji ivoua hɨbɨ lɨbavɨla hɨnihɨni nɨfɨlɨ cɨki abɨhalaŋ uami. Lɨlaŋ Iaganalu Asɨ sɨvɨla hɨnihɨni akuaba akuaba hɨji nɨfɨlɨ hɨsɨŋ igɨlalɨ agaŋ nalusaŋ akuaba akuaba huaci huaci agɨladɨ igubali uami. ");
INSERT INTO ena_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Hɨdɨlɨ mu mu agɨlaŋ Asɨ dɨ lɨbɨsɨlɨvasɨlɨva ciaŋ mu mu abavɨlalɨ uami. Ciaŋ mu mu abɨmɨli Asɨ aludɨ ciaŋ igahɨlɨbali aba hameŋ lɨhavɨlalɨ uami. Agadɨ ala namɨlaŋ Asɨ dɨ abɨben aba nɨbɨlaŋ lɨhavɨlalɨ hameŋ lɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Namɨlaŋ Asɨ dɨ ma abɨmaŋ lɨdalaŋ namɨlaŋ akuaba saŋ tɨbɨ mɨgɨlalaŋ agɨladɨ igɨlalɨ uami. Hameŋ sadaŋ namɨlaŋ hɨdɨlɨ mu mu lɨhavɨlalɨ hameŋ lɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Namɨlaŋ Asɨ dɨ abɨben aba nameŋ abɨhalaŋ uami. Aludɨ Iavaŋ nama nadɨ haiabɨla hɨnilanaŋ aba abɨhalaŋ uami. Nadɨ ibi huaci sɨbaŋ aba abɨhalaŋ uami. Hulaŋ iamɨgali agɨlaŋ avi nasaŋ hameŋ abavɨm aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nama hulaŋ iamɨgali agɨladɨ likɨlɨnaŋ nadɨ lɨhu hɨvɨ hɨniavɨm aba abɨhalaŋ uami. Iahua nadɨ haiabɨla heŋ nadɨ hɨji lubiahɨlavɨlalɨ hameŋ ala alaŋ avi fɨli neŋ nadɨ hɨji lubiahɨlɨmɨli aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Alusaŋ sɨmɨŋ isabɨlaŋ akuaba akuaba iabi me saŋ laci iguha aba abɨhalaŋ uami. Alaŋ nɨlalu hameŋ ala lama hɨlihalavɨla iguha aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Hulaŋ hɨhɨle aludɨ ciaŋ lulavɨdaci alaŋ nulɨdɨ hugɨ hivɨlalu aba abɨhalaŋ uami. Hameŋ laci ala nama avi aludɨ hugɨ hivɨha aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Aludɨ migɨlɨha aba abɨhalaŋ uami. Laguŋ agaŋ aludɨ ilasɨmɨdɨ aba abɨhalaŋ uami. Nama aludɨ ahɨliahunaŋ laguŋ agaŋ aludɨ sɨbɨlɨ lamɨmɨdɨ aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Hulaŋ hɨhɨle naludɨ sɨbɨlɨ lamavɨdaci nulɨdɨ hugɨ hivɨhalaŋ uami. Hameŋ lɨdalaŋ Iaganalu Asɨ iahua hɨvɨ hɨnilalɨ agaŋ naludɨ hugɨ agɨladɨ hivɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Agadɨ ala hulaŋ hɨhɨle naludɨ sɨbɨlɨ lamavɨdaci nulɨdɨ hugɨ ma hivɨlabɨla uami. Ha Iaganalu Asɨ iahua hɨvɨ hɨnilalɨ agaŋ naludɨ hugɨ agɨladɨ avi ma hivɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Lavɨla Jisasɨ cɨhu abami. Hulaŋ hɨhɨle nulɨsaŋ nukeŋ analɨ hɨji nameŋ lamalama abavɨlalɨ uami. Alaŋ hulaŋ huaci aba abavɨlalɨ uami. Lɨdɨŋ sɨmɨŋ valavala hɨnihɨni Asɨ dɨ aba aba mugaŋ lɨbalɨba hɨniavɨlalɨ uami. Hulaŋ hɨhɨle aludɨ iga iga nameŋ abavɨbali aba lɨhavɨlalɨ uami. Nɨbɨlaŋ sɨmɨŋ valavala Asɨ dɨ aba aba hɨniavadi aba abavɨbali aba lɨhavɨlalɨ uami. Viaŋ naludɨ amɨŋ abadin uami. Nɨbɨlaŋ ibi hekɨlɨ ci vihavɨlalɨ sadaŋ Asɨ nulɨsaŋ akuaba cɨki avi ma sɨbaŋ igubali uami. ");
INSERT INTO ena_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Namɨlaŋ sɨmɨŋ valavala hɨnihɨni Asɨ dɨ abɨbalaŋ hadɨhu heŋ uami. Naludɨ hali mɨnɨ huaci hɨnihɨni saŋ sɨdaŋ avɨli agadɨ naludɨ hali hɨvɨ mɨŋamɨjihalaŋ uami. Lavɨla naludɨ mugaŋ lamɨgaŋ mɨŋahusɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Hameŋ lɨlaŋ hulaŋ hɨhɨle namɨlaŋ sɨmɨŋ valavala Asɨ dɨ abɨbalaŋ agadɨ ma igavɨbali uami. Iaganalu Asɨ iahua hɨvɨ hɨnilalɨ agaŋ akuaba akuaba nɨfɨlɨ cɨki lɨbalaŋ agɨladɨ nɨbu laci igɨbali uami. Lavɨla nalusaŋ hɨbɨŋ akuaba akuaba huaci huaci agɨladɨ igubali uami. ");
INSERT INTO ena_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Lavɨla Jisasɨ cɨhu abami. Namɨlaŋ fɨli neŋ hɨnihɨni akuaba akuaba huaci huaci agɨladɨ mɨgudɨbɨmɨlaŋ uami. Akuaba akuaba fɨli neŋ hɨsɨŋ agɨlaŋ niaguŋ lɨhulɨhu sɨbɨlɨ lɨhavɨlalɨ uami. Sɨbiaŋ akuaba akuaba agɨlaŋ agɨlahavɨlalɨ uami. Hulaŋ sɨgɨlɨ hɨsɨŋ agɨlaŋ ulaŋ mɨŋapilapila sɨgɨlɨ vihavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Hameŋ sadaŋ mufɨli Asɨ dɨ haiabɨla uavɨla akuaba akuaba huaci huaci vibalaŋ agɨlasaŋ igahɨlahɨla sibɨla huaci huaci vihalaŋ uami. Lɨdalaŋ naludɨ akuaba akuaba huaci huaci agɨlaŋ Asɨ dɨ haiabɨla heŋ hɨniavɨbali uami. Hɨniavɨdaci sɨbiaŋ agɨlaŋ naludɨ akuaba akuaba agɨladɨ ma agɨlahavɨbali uami. Akuaba akuaba agɨlaŋ ma niaguŋ lɨhulɨhu sɨbɨlɨ lɨhavɨbali uami. Hulaŋ sɨgɨlɨ hɨsɨŋ agɨlaŋ ulaŋ mɨŋapilapila sɨgɨlɨ ma vihavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Naludɨ akuaba akuaba huaci huaci haiabɨla abeba hɨniavɨdaci naludɨ hɨji humɨgaŋ agɨlaŋ avi haiabɨla heŋ ala hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Lavɨla Jisasɨ cɨhu abami. Naludɨ lamɨgaŋ agɨlaŋ unɨ abɨlu me uami. Lamɨgaŋ agɨlaŋ huaci hɨniavɨci naludɨ hadipɨlɨ sɨkasɨkan agɨlaŋ avi abɨlu me laci hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Naludɨ lamɨgaŋ agɨlaŋ sɨbɨlɨ hɨniavɨci uami. Ha naludɨ hadipɨlɨ sɨkasɨkan agɨlaŋ avi hɨfɨlɨ me hɨniavɨbali uami. Namɨlaŋ sɨhɨvia sɨbaŋ migɨlɨhalaŋ uami. Abɨlu me naludɨ hɨvɨ hɨniavadi agɨlaŋ cɨhu hɨfɨlɨ me hɨniavɨmɨdɨ uami. Hɨfɨlɨ me hɨniavɨci ha naludɨ amɨŋ agɨlaŋ avi hɨfɨlɨ sɨbaŋ me hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Lavɨla Jisasɨ cɨhu abami. Sibɨla hɨsɨŋ hulaŋ mu agaŋ manɨgali ahica agɨladɨ hɨvɨ sibɨla ma vibali uami. Manɨgali ahica agɨladɨ sibɨla viavɨla uami. Manɨgali mu agadɨ sɨbɨlɨ igavɨla valɨbali uami. La manɨgali mu agasaŋ pam lɨbali uami. Lavɨla nudɨ ciaŋ agadɨ pam lubiahɨlɨbali uami. Manɨgali mu agadɨ ciaŋ ma lubiahɨlɨbali uami. Hameŋ sadaŋ namɨlaŋ Asɨ dɨ sibɨla daŋ anɨm hɨlɨcɨ sibɨla daŋ vimɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Lavɨla Jisasɨ cɨhu abami. Namɨlaŋ sɨmɨŋ akuaba akuaba vivi nana huaci hɨnihɨni agasaŋ pam lɨlalaŋ uami. Muhɨlɨ havɨlɨ akuaba akuaba agɨlasaŋ pam lɨlalaŋ uami. Akuaba akuaba hameŋ agɨlaŋ naludɨ hɨnihɨni hɨdahɨda agɨladɨ ma ahɨliahuavɨbali uami. Hameŋ sadaŋ viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Naludɨ hadipɨlɨ hɨhi hɨnihɨni agɨlasaŋ pam hɨji cuvɨlɨŋ cuvɨlɨŋ igahɨlahɨla nameŋ abɨmɨlaŋ uami. Iabi akɨ nɨbalu aba abɨmɨlaŋ uami. Akɨ avɨli nɨbalu aba abɨmɨlaŋ uami. Akɨ havɨlɨ lɨbɨbalu aba abɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Havaŋ agɨlasaŋ hɨji lamɨhalaŋ uami. Nɨbɨlaŋ sɨmɨŋ ma huliavɨlalɨ uami. Sɨmɨŋ ma mɨgudɨbavɨlalɨ uami. Nɨbɨlaŋ sɨmɨŋ mɨgudɨbalɨba hɨsɨŋ ulaŋ apalɨ uami. Agadɨ ala Iaganalu Asɨ iahua hɨvɨ hɨnilalɨ agaŋ nulɨsaŋ sɨmɨŋ igunɨlalɨ uami. Hulaŋ iamɨgali naludɨ amɨŋ agɨlaŋ Asɨ dɨ Amɨŋ me sadaŋ namɨlaŋ havaŋ agɨladɨ lɨvalɨlalaŋ uami. Hameŋ sadaŋ Asɨ naludɨ avi sɨhɨvia sɨbaŋ migɨlɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Hulaŋ iamɨgali namɨlaŋ akuaba akuaba fɨli hɨsɨŋ agɨlasaŋ hɨji cuvɨlɨŋ cuvɨlɨŋ lamalama hɨnilalaŋ uami. Agadɨ ala naludɨ hɨmahɨma mɨhiŋ agadɨ namɨlaŋ nukeŋ ma mɨŋoubalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","29","Akuaba akuaba fu hajɨŋ huaci huaci saua iahavɨlalɨ agɨlasaŋ hɨji lamɨhalaŋ uami. Nɨbɨlaŋ akuaba akuaba sibɨla hekɨlɨ hekɨlɨ vivi havɨlɨ ma hɨcavɨlalɨ uami. Viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Vaka Isɨlaelɨ hɨdɨlɨ agɨladɨ manɨgali Solomon agaŋ muhɨlɨ havɨlɨ hajɨŋ huaci huaci agɨladɨ lamɨdaci hɨniavɨhadami uami. Agadɨ ala akuaba akuaba fu hajɨŋ huaci huaci saua iahavɨlalɨ agɨlaŋ Solomon dɨ muhɨlɨ havɨlɨ hajɨŋ huaci huaci agɨladɨ lɨvalavɨlalɨ uami. Hameŋ sadaŋ namɨlaŋ muhɨlɨ havɨlɨ akuaba akuaba agɨlasaŋ hɨji cuvɨlɨŋ cuvɨlɨŋ lamɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Akuaba akuaba fu hajɨŋ huaci huaci saua hɨsɨŋ agɨlaŋ iabi me iahavɨlalɨ uami. Iahavɨdaci amɨli me hɨvɨ nulɨdɨ ihalahalaha avɨŋ hɨvɨ havalavɨdaci mɨgumɨgu lɨhuavɨlalɨ uami. Asɨ nukeŋ akuaba akuaba fu hajɨŋ huaci huaci saua iahavɨlalɨ agɨladɨ lɨdaci hajɨŋ huaci huaci lamavɨlalɨ uami. Hameŋ sadaŋ nɨbu nalusaŋ avi muhɨlɨ havɨlɨ hajɨŋ huaci huaci agɨladɨ igubali uami. Muhɨlɨ havɨlɨ hajɨŋ huaci huaci nalusaŋ igubali agɨlaŋ akuaba akuaba fu hajɨŋ huaci huaci saua hɨsɨŋ agɨladɨ lɨvalavɨlalɨ uami. Namɨlaŋ hulaŋ hɨji vɨdɨvɨdɨŋ apalɨ me hɨnihɨni muhɨlɨ havɨlɨ agɨlasaŋ hɨji cuvɨlɨŋ cuvɨlɨŋ lamɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Namɨlaŋ hɨji cuvɨlɨŋ cuvɨlɨŋ lamalama nameŋ abɨmɨlaŋ uami. Iabi alaŋ akɨ sɨmɨŋ nɨbalu aba abɨmɨlaŋ uami. Akɨ avɨli nɨbalu aba abɨmɨlaŋ uami. Akɨ muhɨlɨ havɨlɨ agɨladɨ lɨbɨbalu aba abɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Hulaŋ iamɨgali hɨdɨlɨ mu mu agɨlaŋ akuaba akuaba hameŋ agɨlasaŋ pam igahɨlavɨlalɨ uami. Naludɨ Iaganalu Asɨ iahua hɨvɨ hɨnilalɨ agaŋ namɨlaŋ akuaba akuaba saŋ tɨbɨ mɨgɨlalaŋ agɨladɨ igɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Asɨ naludɨ likɨlɨci nudɨ lɨhu hɨvɨ hɨnibalaŋ agasaŋ pam igahɨlɨhalaŋ uami. Lɨdɨŋ nudɨ ciaŋ agadɨ sɨhɨvia lubiahɨlahalaŋ uami. Hameŋ lɨlaŋ sɨmɨŋ isabɨlaŋ muhɨlɨ havɨlɨ akuaba akuaba sɨkasɨkan agɨladɨ nalusaŋ igubali uami. ");
INSERT INTO ena_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Vɨhɨlɨ naludɨ hɨvɨ iabi me hɨvɨ iahavɨlalɨ agɨlaŋ akape sɨbaŋ uami. Hameŋ sadaŋ nulɨsaŋ pam igahɨlɨhalaŋ uami. Akuaba akuaba amɨli me hɨvɨ iahavɨbali agɨlasaŋ igahɨlɨmɨlaŋ uami. Amɨli me hɨvɨ ala nulɨsaŋ igahɨlɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","Lavɨla Jisasɨ cɨhu abami. Namɨlaŋ hulaŋ iamɨgali limu hɨhɨle akuaba akuaba lɨhavɨlalɨ agɨladɨ iga iga lamalɨhɨlalɨhɨla nameŋ abɨmɨlaŋ uami. Nɨbɨlaŋ hulaŋ iamɨgali sɨbɨlɨ sɨbɨlɨ aba abɨmɨlaŋ uami. Hameŋ lɨlaŋ Asɨ agaŋ namɨlaŋ akuaba akuaba lɨlalaŋ agɨladɨ avi lamalɨhɨlɨbali uami. Namɨlaŋ hulaŋ iamɨgali agɨlasaŋ vameba igulalaŋ hameŋ laci ala Asɨ avi nalusaŋ igubali uami. ");
INSERT INTO ena_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nama akɨ saŋ hɨfuhɨfu isana dɨ lamɨgaŋ hɨvɨ hɨnivi agadɨ iga iga hɨji lamalama hɨnivanaŋ uami. Agadɨ ala kɨlɨ cɨkaŋ hekɨlɨ me nadɨ nukeŋ lamɨgaŋ hɨvɨ hɨnivi agasaŋ hɨji ma lamɨvanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kɨlɨ cɨkaŋ hekɨlɨ me agaŋ nadɨ lamɨgaŋ hɨvɨ hɨnidaci nama akɨ me lavɨla isana dɨ abɨvanaŋ uami. Viaŋ hɨfuhɨfu nadɨ lamɨgaŋ hɨvɨ hɨnidi agadɨ lɨbɨnikɨlɨlɨŋ iahɨbali aba abɨvanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nama nasaŋ nukeŋ analɨ hɨji nameŋ lamalama abɨlanaŋ uami. Viaŋ hulaŋ huaci aba abɨlanaŋ uami. Agadɨ ala kɨlɨ cɨkaŋ hekɨlɨ me nadɨ nukeŋ lamɨgaŋ hɨvɨ hɨnivi agadɨ mɨŋahubɨlɨnaŋ iahɨci uami. Ha nama huaci sɨhɨvia igasulasula hɨfuhɨfu isana dɨ lamɨgaŋ hɨvɨ hɨnivi agadɨ avi lɨbɨnikɨlɨnaŋ iahɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Namɨlaŋ Asɨ dɨ ciaŋ agadɨ hulaŋ iamɨgali hɨji apalɨ iŋam sabaŋ me agɨlasaŋ sulɨmɨlaŋ uami. Nɨbɨlaŋ iŋam hulaŋ iavavɨlalɨ hameŋ me ciaŋ agadɨ sɨbɨlɨ lamavɨbali uami. Lɨdɨŋ ciaŋ agadɨ abacuvacuva sabaŋ agɨlaŋ sugɨ malɨluŋ akuaba akuaba huaci huaci agɨladɨ lagucabɨlavɨlalɨ hameŋ lɨhavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Lavɨla Jisasɨ cɨhu abami. Namɨlaŋ Asɨ nalusaŋ akuaba akuaba igu igu saŋ nudɨ abitɨhɨhalaŋ uami. Lɨlaŋ nalusaŋ igubali uami. Namɨlaŋ akuaba akuaba saŋ suhɨlɨhalaŋ uami. Lavɨla igɨbalaŋ uami. Namɨlaŋ hɨbɨ lapa ifɨhalaŋ uami. Lɨlaŋ Asɨ nalusaŋ hɨbɨ lavɨlɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Hulaŋ mu akuaba akuaba saŋ Asɨ dɨ abitɨhɨlalɨ agaŋ akuaba akuaba vilalɨ uami. Hulaŋ mu akuaba akuaba saŋ suhɨlɨlalɨ agaŋ igɨlalɨ uami. Hulaŋ mu hɨbɨ lapa ifɨlalɨ agasaŋ Asɨ nusaŋ hɨbɨ lavɨlɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Iagagalinɨlu namɨlaŋ ninadinalu maci nana saŋ abavɨci nulɨsaŋ lɨba kum agɨladɨ ma iguvalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ninadinalu hehɨlaŋ nana saŋ abavɨci nulɨsaŋ lahu sɨbɨlɨ agɨladɨ ma iguvalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Iagagalinɨlu namɨlaŋ lusɨŋ sɨbɨlɨ sɨbɨlɨ akape vilalaŋ uami. Agadɨ ala naludɨ ninanadinalu agɨlasaŋ akuaba akuaba huaci huaci agɨladɨ igulalaŋ uami. Naludɨ Iaganalu Asɨ iahua hɨvɨ hɨnilalɨ agaŋ nalusaŋ akuaba akuaba igu igu saŋ abɨlaŋ uami. Nɨbu hɨjɨŋalavɨla nalusaŋ akuaba akuaba huaci huaci agɨladɨ igubali uami. ");
INSERT INTO ena_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Hulaŋ iamɨgali limu hɨhɨle agɨlaŋ naludɨ vameba lɨhavɨdaci hɨjɨŋalɨlalaŋ agasaŋ igahɨlɨhalaŋ uami. Igahɨlahɨla hulaŋ iamɨgali limu hɨhɨle agɨlasaŋ avi hameŋ laci ala lɨdalaŋ hɨjɨŋalavɨbali uami. Akuaba akuaba hameŋ lɨlɨ saŋ ala vaka Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ agɨlaŋ abavɨhadami uami. Mosesɨ avi nusaŋ ala ciaŋ vɨdɨvɨdɨŋ lɨbami uami. ");
INSERT INTO ena_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Lavɨla Jisasɨ cɨhu abami. Avɨŋ hɨvɨ uu hɨsɨŋ hɨbɨ pɨlɨ agaŋ nɨbu hekɨlɨ uami. Hɨbɨ ivu ivu agaŋ nɨbu hekɨlɨ sadaŋ hulaŋ iamɨgali akape hɨbɨ pɨlɨ heŋ uavɨlalɨ uami. Agadɨ ala namɨlaŋ hɨbɨ ivu ivu sudɨme cɨki heŋ ivouhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Asɨ hula huaci hameŋ laci hameŋ laci hɨnihɨni hɨsɨŋ agadɨ hɨbɨ nɨbu sudɨme cɨki sɨbaŋ uami. Hɨbɨ pɨlɨ heŋ ubalu aba vɨhɨlɨfulɨfu uavɨlalɨ uami. Hameŋ sadaŋ hulaŋ iamɨgali pabiŋ pabiŋ hɨbɨ sudɨme cɨki agadɨ iga iga hɨbɨ heŋ uavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Lavɨla Jisasɨ cɨhu abami. Hulaŋ hɨhɨle naludɨ sɨbɨlɨ lamalama saŋ ciaŋ huaci huaci aba aba naludɨ hɨji huaci huaci agɨladɨ mɨŋaihuihu lɨhavɨbali agɨlasaŋ sɨhɨvia sɨbaŋ migɨlɨhalaŋ uami. Nɨbɨlaŋ analɨ nameŋ abavɨlalɨ uami. Alaŋ Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ aba abavɨlalɨ uami. Nɨbɨlaŋ sudɨ iŋam me uami. Sudɨ iŋam agɨlaŋ sabaŋ sipsipɨ sɨgɨtɨ agɨladɨ ahualavɨlalɨ uami. Lɨdɨŋ sabaŋ sipsipɨ agɨladɨ mikɨ pɨŋ uu nulɨdɨ iavavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nɨbɨlaŋ akuaba akuaba sibɨla vihavɨbali agɨladɨ sɨhɨvia iga iga abɨbalaŋ uami. Nɨbɨlaŋ analɨ ciaŋ nameŋ abavɨlalɨ aba abɨbalaŋ uami. Alaŋ Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ aba abavɨlalɨ aba abɨbalaŋ uami. Hulaŋ lɨmɨn uain agɨladɨ amɨŋ agɨladɨ vibalu aba lɨmɨn henaŋ henaŋ daŋ agɨladɨ pɨŋ ma uavɨlalɨ uami. Kɨlɨ fikɨ agɨladɨ amɨŋ agɨladɨ vibalu aba lɨbulɨbu cɨhɨvɨ daŋ cɨhɨvɨ daŋ agɨladɨ pɨŋ ma uavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kɨlɨ huaci agaŋ amɨŋ huaci huaci agɨladɨ lamɨlalɨ uami. Kɨlɨ sɨbɨlɨ agaŋ amɨŋ sɨbɨlɨ sɨbɨlɨ agɨladɨ lamɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kɨlɨ huaci agaŋ amɨŋ sɨbɨlɨ sɨbɨlɨ agɨladɨ ma lamɨlalɨ uami. Kɨlɨ sɨbɨlɨ agaŋ amɨŋ huaci huaci agɨladɨ ma lamɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kɨlɨ agaŋ amɨŋ huaci huaci ma lamɨlalɨ agadɨ iha iha vivi havalɨdaci avɨŋ hɨvɨ mɨgulalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nɨbɨlaŋ akuaba akuaba sibɨla vihavɨbali agɨladɨ namɨlaŋ sɨhɨvia igɨhalaŋ uami. Lavɨla hɨji lamavɨla abɨbalaŋ uami. Nɨbɨlaŋ analɨ ciaŋ nameŋ abavɨlalɨ aba abɨbalaŋ uami. Alaŋ Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ aba abavɨlalɨ aba abɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Hulaŋ iamɨgali iadɨ havɨ havɨ nameŋ abavɨlalɨ uami. Aludɨ Hekɨlɨ aba abavɨlalɨ uami. Agadɨ ala Asɨ nulɨdɨ ma likɨlɨbali uami. Lɨci nudɨ lɨhu hɨvɨ ma sɨbaŋ hɨniavɨbali uami. Hulaŋ iamɨgali iadɨ Iavaŋ iahua hɨvɨ hɨnilalɨ agadɨ hɨji lubiahɨlavɨci uami. Ha nɨbu nulɨdɨ likɨlɨci nudɨ lɨhu hɨvɨ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Asɨ hulaŋ iamɨgali ciaŋ hɨvɨ lamɨbali agadɨ mɨhiŋ hekɨlɨ heŋ hulaŋ iamɨgali akape agɨlaŋ veve iadɨ nameŋ abavɨbali uami. Aludɨ Hekɨlɨ aba abavɨbali uami. Alaŋ nadɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ hɨnihɨni nadɨ ibi hɨvɨ sibɨla vilalu aba abavɨbali uami. Sibɨla vivi nadɨ ibi hɨvɨ sudɨ sɨbɨlɨ agɨladɨ lahulalu aba abavɨbali uami. Lɨdɨŋ nadɨ ibi hɨvɨ vɨdɨvɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ abalamɨlalu aba abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Lɨhavɨci hadɨhu heŋ viaŋ haiabɨla iahaiaha nulɨdɨ nameŋ abɨben uami. Viaŋ naludɨ ma igɨlan aba abɨben uami. Namɨlaŋ ciaŋ vɨdɨvɨdɨŋ lulalula hɨsɨŋ hulaŋ iamɨgali aba abɨben uami. Namɨlaŋ uhalaŋ aba abɨben uami. ");
INSERT INTO ena_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","25","Lavɨla Jisasɨ cɨhu hɨve lama abami. Hulaŋ mu hɨji huaci daŋ agaŋ ulaŋ mavɨben aba lɨvi uami. La haca mɨse mavamava mɨgua lɨba hekɨlɨ iga valavɨla lɨba agadɨ sabɨ heŋ ulaŋ mavɨci hɨnivi uami. Hɨnidaci avɨli mɨgɨdaci huŋe sagaŋ vevi uami. Lavɨla avɨli hekɨlɨ lagua vevɨla mɨŋanikɨlɨci ala ma mɨgaifɨvi uami. Hulaŋ hameŋ agaŋ ulaŋ huaci vɨdɨvɨdɨŋ sɨbaŋ mavɨvi uami. Nɨbu hulaŋ iadɨ pɨŋ veve ciaŋ igahɨlahɨla lubiahɨlɨlalɨ agaŋ me uami. ");
INSERT INTO ena_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","Hulaŋ mu hɨji huaci apalɨ agaŋ nɨbu hacɨŋ savu hɨvɨ ulaŋ mavɨci hɨnivi uami. Hɨnidaci avɨli hekɨlɨ mɨgɨdaci huŋe sagaŋ hekɨlɨ vevi uami. Lavɨla avɨli hekɨlɨ lagua vevɨla nudɨ ulaŋ agadɨ mɨŋanikɨlɨci sɨkasɨkan mɨgaifa sɨbɨlɨ lɨvi uami. Hulaŋ hameŋ agaŋ ulaŋ huaci ma mavɨvi uami. Nɨbu hulaŋ iadɨ ciaŋ igahɨlahɨla ma lubiahɨlɨlalɨ agaŋ me uami. ");
INSERT INTO ena_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Jisasɨ agaŋ hulaŋ ibi daŋ me hɨnihɨni ciaŋ sulami. Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agadɨ lamalubilubi hɨsɨŋ hulaŋ agɨlaŋ ciaŋ sulavɨhadami hameŋ ma sulami. Sula fɨhalɨci hulaŋ iamɨgali akape agɨlaŋ igahɨlavɨla i uavɨmi. Hulaŋ nagaŋ ibi daŋ me hɨnihɨni ciaŋ sulɨlalɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisasɨ agaŋ halu vala mɨgudaci hulaŋ iamɨgali akape agɨlaŋ nɨbu hula uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Uavɨdaci hulaŋ mu lɨpɨlɨm lɨpɨlɨm daŋ agaŋ Jisasɨ dɨ pɨŋ vemi. Vevɨla Jisasɨ dɨ igavɨla mavɨn ciaŋ ciaŋ aba aba saŋ mɨgalɨfɨlɨbavɨla nudɨ abami. Iadɨ Hekɨlɨ uami. Nama iasaŋ huaci mavɨn hɨniavɨla lɨpɨlɨm lɨpɨlɨm iadɨ hadipɨlɨ hɨvɨ hɨnilalɨ nagadɨ abɨnaŋ sɨvɨlɨci huaci lavɨla hɨnivin uami. ");
INSERT INTO ena_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Lɨci Jisasɨ hulaŋ agadɨ hadipɨlɨ agadɨ mɨŋaigavɨla abami. Viaŋ nasaŋ mavɨn hɨniavɨla nadɨ hadipɨlɨ agadɨ ci huaci lamin uami. Hameŋ abɨci nudɨ lɨpɨlɨm lɨpɨlɨm agaŋ lɨhalɨha sɨbaŋ sɨvɨlami. ");
INSERT INTO ena_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Sɨvɨlɨci Jisasɨ nudɨ abami. Hulaŋ iamɨgali limu hɨhɨle agɨladɨ abɨmɨnaŋ uami. Asɨ saŋ sagalɨ igu igu hɨsɨŋ hulaŋ agadɨ pɨŋ uha uami. Uavɨla nadɨ hadipɨlɨ agadɨ abalamɨnaŋ igam uami. Igɨci huaci lɨci Asɨ saŋ sagalɨ igunaŋ hɨlam uami. Ciaŋ vɨdɨvɨdɨŋ Mosesɨ lɨbami agadɨ lubiahɨlavɨla sagalɨ igunaŋ hɨlam uami. Sagalɨ igunaŋ hɨlɨci hulaŋ iamɨgali agɨlaŋ nadɨ iga iga abavɨbali uami. Nudɨ hadipɨlɨ ci huaci li aba abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisasɨ agaŋ uavɨla Kapelɨneam haiabɨla iahumi. Iahua hɨnidaci Lom haiabɨla hɨsɨŋ agɨladɨ sagaŋ hali hɨsɨŋ agaŋ vevɨla nusaŋ mavɨn ciaŋ ciaŋ iguavɨla abami. ");
INSERT INTO ena_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Iadɨ Hekɨlɨ uami. Iadɨ sibɨla hɨsɨŋ hulemɨlɨ agaŋ hɨmuhɨmu hekɨlɨ hɨmavɨla iadɨ ulaŋ hɨvɨ hɨnidi uami. Nudɨ henaŋ agɨlaŋ haba hɨmavɨci avɨha avɨha hekɨlɨ iga iga hɨnidi uami. ");
INSERT INTO ena_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Lɨci Jisasɨ nudɨ abami. Viaŋ uavɨla nudɨ huaci lamɨben uami. ");
INSERT INTO ena_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Lɨci sagaŋ hali hɨsɨŋ agaŋ Jisasɨ dɨ abami. Iadɨ Hekɨlɨ uami. Viaŋ hulaŋ huaci hɨma uami. Hameŋ sadaŋ nama iadɨ ulaŋ hɨvɨ umɨnaŋ uami. Viaŋ hulaŋ ibi daŋ agadɨ lɨhu hɨvɨ hɨnilan uami. Sagaŋ hɨsɨŋ hulemɨlɨ agɨlaŋ iadɨ lɨhu hɨvɨ hɨniavɨlalɨ uami. Hɨniavɨdaci viaŋ nulɨdɨ heŋ uhalaŋ aba abɨdalɨŋ uavɨlalɨ uami. Neŋ vehalaŋ aba abɨdalɨŋ vehavɨlalɨ uami. Sibɨla hɨsɨŋ hulemɨlɨ agɨladɨ sibɨla nagadɨ vihalaŋ aba abɨdalɨŋ vihavɨlalɨ uami. Ciaŋ pam abɨnaŋ iadɨ sibɨla hɨsɨŋ hulemɨlɨ agaŋ huaci lɨm uami. ");
INSERT INTO ena_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Lɨci Jisasɨ igahɨlavɨla i uami. Lavɨla limu cimɨla hulaŋ iamɨgali nudɨ sɨvɨ uavɨmi agɨladɨ abami. Viaŋ naludɨ amɨŋ abadin uami. Sagaŋ hali hɨsɨŋ nagaŋ iasaŋ hɨji vɨdɨvɨdɨŋ hekɨlɨ sɨbaŋ lami uami. Isɨlaelɨ hɨdɨlɨ agɨladɨ hulaŋ pabiŋ avi hɨji vɨdɨvɨdɨŋ hameŋ ma lamavɨci igɨlan uami. ");
INSERT INTO ena_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Hulaŋ iamɨgali akape uaiaŋ iahaiaha kɨlikɨli hɨsɨŋ uami. Uaiaŋ mɨgumɨgu kɨlikɨli hɨsɨŋ uami. Nulɨdɨ fɨli tɨbɨ valavala vehavɨdaci Asɨ nulɨdɨ likɨlɨbali uami. Likɨlɨci nudɨ lɨhu hɨvɨ hɨnihɨni Ebɨlam Aisakɨ Jekopɨ ani ani agɨlaŋ hula sɨmɨŋ navɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Asɨ agaŋ hɨdɨlɨ maha Isɨlaelɨ hɨdɨlɨ agɨladɨ likɨlɨci nudɨ lɨhu hɨvɨ hɨnihɨni saŋ abami uami. Agadɨ ala nulɨdɨ lahubali uami. Lahuci haiabɨla uvɨ hɨfɨlɨ hekɨlɨ daŋ heŋ hɨniavɨbali uami. Hɨnihɨni ilɨha ilɨha mɨka hɨkɨŋ lagulagu hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Lavɨla Jisasɨ sagaŋ hali hɨsɨŋ agadɨ cɨhu abami. Uha uami. Udanaŋ akuaba akuaba agɨlasaŋ hɨji vɨdɨvɨdɨŋ lamɨnaŋ agaŋ hameŋ ala lɨbali uami. Lɨci hadɨhu heŋ ala nudɨ sibɨla hɨsɨŋ hulemɨlɨ agaŋ huaci lɨmi. ");
INSERT INTO ena_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Lɨci Jisasɨ agaŋ Pita dɨ ulaŋ heŋ ivoumi. Ivoua igɨci Pita abiamɨnu agaŋ hɨmuhɨmu daŋ hɨniavɨla ani hɨnimi. Nudɨ hadipɨlɨ agaŋ avɨŋ me lɨhumi. ");
INSERT INTO ena_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Lɨdaci Jisasɨ nudɨ human agadɨ mɨŋaigɨci hadi vubɨŋ agaŋ valami. Valɨci iahavɨla Jisasɨ saŋ sɨmɨŋ igunami. ");
INSERT INTO ena_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Uaiaŋ sijaŋ sijaŋ hɨlɨdaci hulaŋ iamɨgali akape sudɨ sɨbɨlɨ daŋ agɨladɨ vivi Jisasɨ dɨ pɨŋ vavehavɨmi. Vavehavɨdaci sudɨ sɨbɨlɨ agɨladɨ aba aba lahudaci sudɨ sɨbɨlɨ agɨlaŋ hulaŋ iamɨgali agɨladɨ valavala uavɨmi. Lɨhavɨdaci cɨhu hulaŋ iamɨgali akape hɨmuhɨmu daŋ agɨladɨ avi sɨkasɨkan huaci lamami. ");
INSERT INTO ena_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Akuaba akuaba hadɨhu iahavɨmi agɨlasaŋ ala vaka Asɨ agaŋ nudɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ Aisaia saŋ hɨji igudaci nameŋ abami. Nɨbu nukeŋ lɨdaci hɨmuhɨmu mu hɨdɨlɨ mu hɨdɨlɨ agɨlaŋ aludɨ valavɨdaci huaci laci hɨnidalu uami. Lɨci Aisaia abami hameŋ laci ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Hulaŋ iamɨgali akape Jisasɨ dɨ haŋala huda hɨniavɨmi. Hɨniavɨdaci Jisasɨ nulɨdɨ igavɨla nudɨ hulemɨlɨ agɨladɨ abami. Idu hekɨlɨ limu caba adeŋ ivoumɨli uami. ");
INSERT INTO ena_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hameŋ abɨci hulaŋ mu Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agadɨ lamalubilubi hɨsɨŋ hulaŋ agaŋ vevɨla Jisasɨ dɨ abami. Iavaŋ uami. Abeba abeba hɨdɨbanaŋ heŋ viaŋ avi nama hula hɨdɨben uami. ");
INSERT INTO ena_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Lɨci Jisasɨ nudɨ abami. Sudɨ iŋam agɨlaŋ fɨli haca daŋ uami. Havaŋ agɨlaŋ avi ulaŋ daŋ uami. Agadɨ ala Hulaŋ dɨ Ninaŋ nɨbu ani hɨnihɨni hɨsɨŋ uvɨ agaŋ apalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Lɨci nudɨ hulemɨlɨ mu agaŋ abami. Iadɨ Hekɨlɨ uami. Nama iadɨ huaci valɨnaŋ uavɨla iadɨ iavaŋ dɨ valɨ agadɨ haca mava hudavɨla heŋ nama hula uvin uami. ");
INSERT INTO ena_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Lɨci Jisasɨ agaŋ nudɨ abami. Hulaŋ iasaŋ hɨji vɨdɨvɨdɨŋ ma lamavɨlalɨ agɨlaŋ valɨ me hɨniavɨlalɨ uami. Vana nɨbɨlaŋ nukeŋ hulaŋ valɨ agɨladɨ mavavɨbali uami. Nama ve viaŋ hula hɨdɨha uami. ");
INSERT INTO ena_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Lavɨla Jisasɨ hunɨga hɨvɨ mɨgua mɨgahɨnimi. Lɨci nudɨ hulemɨlɨ agɨlaŋ avi nɨbu hula mɨguavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","La uavɨdaci Jisasɨ hunɨga tulɨ heŋ ani hɨsɨvami. Ani hɨsɨvɨdaci huŋe sagaŋ hekɨlɨ agaŋ vemi. Veve avɨli agadɨ lɨdaci aibubuŋ ifu ifu hunɨga tulɨ hɨvɨ mɨgumi. Lɨdaci hunɨga agaŋ luvia mɨguben aba lɨmi. ");
INSERT INTO ena_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Lɨci Jisasɨ dɨ hulemɨlɨ agɨlaŋ ua nudɨ mɨŋaiualavɨla abavɨmi. Aludɨ Hekɨlɨ uavɨmi. Aludɨ ahɨliahuha uavɨmi. Alaŋ amɨŋ ci avɨli nahɨmɨbalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Lɨhavɨci Jisasɨ iaha nulɨdɨ abami. Namɨlaŋ lɨdɨmɨlaŋ uami. Namɨlaŋ hulaŋ hɨji vɨdɨvɨdɨŋ apalɨ me hɨnihɨni lɨdɨlaŋ uami. Lavɨla iaha huŋe sagaŋ agadɨdaŋ avɨli aibubuŋ ifami agadɨdaŋ abɨci valavɨmi. Valavɨci avɨli agaŋ cɨhu havɨ me hɨnimi. ");
INSERT INTO ena_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Lɨci cɨhu abavɨmi. I uavɨmi. Hulaŋ nana akɨ me hulaŋ uavɨmi. La nɨbu avɨli agadɨdaŋ huŋe sagaŋ agadɨdaŋ abɨci valavi uavɨmi. Valavɨci avɨli agaŋ havɨ me sɨbaŋ hɨnidi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisasɨ agaŋ nudɨ hulemɨlɨ agɨlaŋ hula hunɨga hɨvɨ Galili idu hekɨlɨ limu caba heŋ ivouavɨmi. Ivouavɨci hunɨga agaŋ Gadala haiabɨla hɨsɨŋ agɨladɨ fɨli tɨbɨ heŋ ua itɨlamami. Lɨci hulaŋ ahica sudɨ sɨbɨlɨ daŋ agɨlaŋ ve nudɨ igavɨmi. Nɨbɨlaŋ sudɨ savu haca hɨvɨ ivo ivo ani hɨniavɨhadami. Heŋ hɨnihɨni ivaveve hulaŋ iamɨgali hɨhɨle agɨladɨ havɨ havɨ ifu ifu sɨbɨlɨ lamavɨhadami. Hameŋ sadaŋ hulaŋ iamɨgali agɨlaŋ nulɨsaŋ lɨdalɨda hɨbɨ nɨbɨlaŋ hɨniavɨhadami heŋ ma hɨdavɨhadami. ");
INSERT INTO ena_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Hulaŋ ahica agɨlaŋ Jisasɨ dɨ igavɨla heŋ vɨdɨvɨdɨŋ livaliva abavɨmi. Nama Asɨ dɨ Ninaŋ uavɨmi. Nama aludɨ akɨ lɨben aba lɨdanaŋ uavɨmi. Alaŋ sɨbɨlɨ lɨbalu agaŋ mɨhiŋ vakala hɨnidi uavɨmi. Nama akɨ saŋ alusaŋ avɨha avɨha iguben aba venaŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Hameŋ aba aba hɨniavɨdaci sabaŋ akape agɨlaŋ ataŋ tagɨlaŋ hɨvɨ hɨnihɨni sɨmɨŋ nana hɨdavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nana hɨdavɨdaci sudɨ sɨbɨlɨ agɨlaŋ Jisasɨ saŋ mavɨn ciaŋ ciaŋ igu igu abavɨmi. Aludɨ lahuavɨla abɨnaŋ alaŋ huaci sabaŋ adagɨladɨ hɨvɨ ivoua hɨnivɨlu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Lɨhavɨci Jisasɨ nulɨdɨ abami. Alialaŋ uami. Uhalaŋ uami. Lɨci sudɨ sɨbɨlɨ agɨlaŋ hulaŋ ahica agɨladɨ valavala sabaŋ agɨladɨ hɨvɨ ivouavɨmi. Ivouavɨdaci sabaŋ sɨkasɨkan agɨlaŋ haba haŋɨlavɨmi. Haŋɨla haŋɨla uavɨla uvɨ sɨbɨlɨ idu caba hɨniadami heŋ havala havala mɨgumɨgu avɨli nahɨmavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nahɨmavɨci hulaŋ sabaŋ migɨlavɨhadami agɨlaŋ igavɨla haba haŋɨlavɨmi. Haŋɨla haŋɨla haiabɨla hekɨlɨ heŋ uavɨla akuaba akuaba sabaŋ agɨladɨ hɨvɨ iahavɨdaci igavɨmi agɨlasaŋ hulaŋ iamɨgali agɨladɨ sulavɨmi. La hulaŋ ahica sudɨ sɨbɨlɨ daŋ agɨladɨ hɨvɨ iahavɨdaci igavɨmi agɨlasaŋ avi sulavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Lɨhavɨci hulaŋ iamɨgali haiabɨla hekɨlɨ heŋ hɨsɨŋ agɨlaŋ Jisasɨ dɨ pɨŋ vehavɨmi. Vevɨla nudɨ igavɨla lahubalu aba mavɨn ciaŋ ciaŋ nameŋ abavɨmi. Nama aludɨ fɨli tɨbɨ nagadɨ valavɨla mu abɨla hɨvɨ uha uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisasɨ agaŋ hunɨga hɨvɨ mɨguavɨla idu hekɨlɨ limu caba cɨhu vemi. Vevɨla nudɨ nukeŋ haiabɨla heŋ iahami. ");
INSERT INTO ena_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Iaha hɨnidaci hulaŋ mu dɨ hɨcɨ human haba hɨmavɨci vadɨm hɨvɨ pam hɨsɨvadami agadɨ hava vavehavɨmi. Vavehavɨci Jisasɨ nulɨdɨ hɨji vɨdɨvɨdɨŋ agɨladɨ igami. Igavɨla hulaŋ hɨcɨ human haba hɨmavɨmi agadɨ abami. Ci igɨnaŋ uami. Nama vɨdɨvɨdɨŋ hɨniha uami. Nadɨ hugɨ agɨladɨ ci hivin uami. ");
INSERT INTO ena_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Lɨci Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agadɨ lamalubilubi hɨsɨŋ hulaŋ limu hɨhɨle agɨlaŋ igahɨlavɨla nɨbɨlaŋ nukeŋ nukeŋ abavɨmi. Hulaŋ nagaŋ Asɨ dɨ uvɨsɨjiŋ viavɨla hulaŋ mu nɨbu hula hugɨ apalɨ hɨnilalɨ agadɨ hugɨ hivɨben aba li uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Lɨhavɨci Jisasɨ nulɨdɨ hɨji agɨladɨ igavɨla abami. Namɨlaŋ akɨ saŋ hɨji sɨbɨlɨ sɨbɨlɨ lamalama hɨnidalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Viaŋ hulaŋ hɨcɨ human haba hɨmavɨmi agadɨ akɨ lɨlɨŋ namɨlaŋ igavɨla nameŋ abɨbalaŋ uami. Hulaŋ dɨ Ninaŋ nɨbu fɨli neŋ hugɨ hivahiva hɨsɨŋ hulaŋ ibi daŋ hɨnilalɨ aba abɨbalaŋ uami. Akɨ me ciaŋ agadɨ huaci abɨben uami. Viaŋ nadɨ hugɨ ci hivin aba abɨben ua nama iahavɨla uha aba abɨben uami. Lavɨla hulaŋ hɨcɨ human haba hɨmavɨmi agadɨ abami. Nama iaha nadɨ vadɨm agadɨ via havavɨla nadɨ ulaŋ hɨvɨ uha uami. ");
INSERT INTO ena_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Lɨci hulaŋ agaŋ iaha nudɨ nukeŋ ulaŋ heŋ umi. ");
INSERT INTO ena_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Udaci hulaŋ iamɨgali agɨlaŋ nudɨ iga iga lɨdalɨda abavɨmi. Asɨ hulaŋ iamɨgali agɨlasaŋ ibi hekɨlɨ igudaci hulaŋ iamɨgali limu hɨhɨle agɨladɨ huaci lamavadi uavɨmi. Lɨdɨŋ Asɨ dɨ ibi mɨŋaiahavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Lɨhavɨci Jisasɨ agaŋ iaha uavɨla Matiu dɨ igami. Igɨci nɨbu huban saŋ anɨm hɨlɨcɨ vivi hɨsɨŋ ulaŋ heŋ mɨgahɨnimi. Lɨci Jisasɨ nudɨ abami. Nama venaŋ ahica umɨli uami. Lɨci Matiu iaha Jisasɨ hula uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Uavɨla Matiu dɨ ulaŋ heŋ ivouavɨla sɨmɨŋ hekɨlɨ nana saŋ mɨgahɨniavɨmi. Lɨhavɨdaci lusɨŋ sɨbɨlɨ hɨsɨŋ agɨlaŋ hula nulɨdɨ hulaŋ limu hɨhɨle huban saŋ anɨm hɨlɨcɨ vihavɨhadami agɨlaŋ hula vehavɨmi. Jisasɨ dɨ hulemɨlɨ agɨlaŋ avi vehavɨmi. Ve hafalavɨla sɨmɨŋ hekɨlɨ navɨmi. ");
INSERT INTO ena_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Navɨdaci Falisi hɨdɨlɨ agɨlaŋ Jisasɨ dɨ hulemɨlɨ agɨladɨ abavɨmi. Akɨ saŋ naludɨ iaganalu agaŋ lusɨŋ sɨbɨlɨ hɨsɨŋ agɨlaŋ hula sɨmɨŋ navadi uavɨmi. Akɨ saŋ nulɨdɨ hulaŋ hɨhɨle huban saŋ anɨm hɨlɨcɨ vivi hɨsɨŋ agɨlaŋ hula sɨmɨŋ navadi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Lɨhavɨci Jisasɨ agaŋ ciaŋ agadɨ igahɨlavɨla nameŋ abami. Hulaŋ hɨmuhɨmu apalɨ agɨlaŋ fim hahahaha hɨsɨŋ agɨladɨ pɨŋ ma uavɨlalɨ uami. Hulaŋ hɨmuhɨmu daŋ agɨlaŋ pam fim hahahaha hɨsɨŋ agɨladɨ pɨŋ uavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Asɨ agaŋ nameŋ abami uami. Viaŋ namɨlaŋ sagalɨ havɨ havɨ igulalaŋ agɨlasaŋ mavɨn ma hɨnilan aba abami uami. Viaŋ hulaŋ iamɨgali limu hɨhɨle agɨlaŋ hulaŋ iamɨgali limu hɨhɨle agɨlasaŋ mavɨn hɨnihɨni nulɨdɨ huaci lamalama agasaŋ pam mavɨn hɨnilan aba abami uami. Lavɨla Jisasɨ cɨhu abami. Namɨlaŋ Asɨ hameŋ abami agasaŋ hɨji lamɨhalaŋ uami. Viaŋ hulaŋ Asɨ dɨ ciaŋ sɨhɨvia lubiahɨlavɨlalɨ agɨladɨ abɨdalɨŋ iadɨ hulemɨlɨ hɨnihɨni saŋ ma vemin uami. Viaŋ hulaŋ lusɨŋ sɨbɨlɨ vihavɨlalɨ agɨladɨ abɨdalɨŋ iadɨ hulemɨlɨ hɨnihɨni saŋ vemin uami. ");
INSERT INTO ena_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Lɨci hadɨhu heŋ ala Jon dɨ hulemɨlɨ agɨlaŋ vevɨla Jisasɨ dɨ abavɨmi. Alaŋ Falisi hɨdɨlɨ agɨlaŋ hula Asɨ dɨ abɨbalu aba sɨmɨŋ valɨlalu uavɨmi. Agadɨ ala nadɨ hulemɨlɨ agɨlaŋ hameŋ ma lɨhavɨlalɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Lɨhavɨci Jisasɨ hɨve lama nulɨdɨ abami. Hulaŋ mu iamɨgali sabiben aba lɨvi uami. La nɨbu hɨnidaci namɨlaŋ nudɨ isaima agɨladɨ sɨmɨŋ valavala ilɨha ilɨha hɨnihɨni saŋ abɨlaŋ nɨbɨlaŋ hameŋ ma lɨhavɨvi uami. Mufɨli me hɨvɨ hulaŋ agadɨ via uavɨci nudɨ isaima agɨlaŋ nusaŋ mavɨn lamalama sɨmɨŋ heŋ valavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hameŋ abavɨla cɨhu hɨve lama abami. Hadi hɨlahɨla hutesɨ hasɨ agaŋ fɨlu daŋ hɨnidaci uami. Havɨlɨ tɨbɨ hɨhi agadɨ via fɨlu agadɨ hɨvɨ ma lama hɨcɨvi uami. Hameŋ lavɨla hadi hɨlahɨla hutesɨ agadɨ husɨci uami. Havɨlɨ tɨbɨ hɨhi fɨlu agadɨ hɨvɨ lama hɨcɨvi agaŋ nigula nigula uavɨla lɨdɨmɨŋɨci hadi hɨlahɨla hutesɨ hasɨ agaŋ pilɨvi uami. Hɨhi agaŋ hasɨ agadɨ lɨci pilɨvi uami. Pilɨci fɨlu agaŋ cɨhu hekɨlɨ lɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Hameŋ abavɨla cɨhu tɨbɨ hɨve lama abami. Lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ hɨhi agadɨ uami. Sabaŋ meme sɨgɨtɨ hɨcavɨci sɨbɨ hɨlɨcɨ me hɨnihɨni hasɨ lɨhavɨlalɨ agɨladɨ hɨvɨ ma hapilavɨvi uami. Nulɨdɨ hɨvɨ hapilavɨci hɨnia huhɨlavɨci sabaŋ meme sɨgɨtɨ hasɨ agɨlaŋ vɨkuavɨci fɨli hɨvɨ mɨjia mɨgavɨvi uami. Lɨhavɨci sɨbɨ hɨlɨcɨ me agɨlaŋ avi sɨbɨlɨ lɨhavɨvi uami. Hameŋ sadaŋ lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ hɨhi agadɨ uami. Sabaŋ meme sɨgɨtɨ hɨhi agɨladɨ hɨcavɨci sɨbɨ hɨlɨcɨ me hɨniavɨlalɨ agɨladɨ hɨvɨ pam hapilavɨlalɨ uami. Lɨhavɨdaci ahica hameŋ huaci laci hɨniavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisasɨ agaŋ Jon dɨ hulemɨlɨ agɨlasaŋ ciaŋ sulɨdaci manɨgali mu agaŋ vevɨla mavɨn ciaŋ ciaŋ aba aba saŋ nudɨ hɨcɨ pɨŋ mɨgalɨfɨlɨbavɨla abami. Iadɨ nadi malɨciŋ sɨbaŋ hɨmi uami. Nama ve uavɨla nadɨ human agadɨ nudɨ sabɨ hɨvɨ lamɨnaŋ cɨhu hɨhi iaham uami. ");
INSERT INTO ena_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Lɨci Jisasɨ iaha nudɨ hulemɨlɨ agɨlaŋ hula manɨgali agadɨ sɨvɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Uavɨdaci iamɨgali mu husɨŋ hɨbɨ hutesɨ hɨniadami agaŋ avi nɨbɨlaŋ hula uavɨmi. Nɨbu husɨŋ hɨbɨ hutesɨ hɨnidaci hualɨ human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ umi. Iamɨgali agaŋ hɨji nameŋ lamami. Viaŋ nudɨ hadi hɨlahɨla hutesɨ agadɨ fɨdɨm heŋ mɨŋaigavɨla huaci lɨben uami. Lavɨla Jisasɨ dɨ hulɨpɨŋ hulɨpɨŋ heŋ uavɨla nudɨ hadi hɨlahɨla hutesɨ agadɨ fɨdɨm heŋ mɨŋaigami. ");
INSERT INTO ena_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Mɨŋaigɨci husɨŋ hɨbɨ hutesɨ hɨniadami agaŋ heŋ valami. Valɨci Jisasɨ limu cimɨlavɨla iamɨgali agadɨ igavɨla abami. Ci igɨnaŋ uami. Nama vɨdɨvɨdɨŋ hɨniha uami. Nama iasaŋ hɨji vɨdɨvɨdɨŋ lamɨnaŋ sadaŋ Asɨ agaŋ nadɨ ci huaci lami uami. ");
INSERT INTO ena_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Lavɨla Jisasɨ manɨgali agadɨ ulaŋ uavɨla igɨci hulaŋ hɨhɨle sai mahɨlavɨdaci hulaŋ iamɨgali agɨlaŋ ilɨha ilɨha ihuihu hekɨlɨ lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Lɨhavɨdaci Jisasɨ nulɨdɨ abami. Namɨlaŋ uhalaŋ uami. Nadi agaŋ ma hɨmi uami. Nɨbu havɨ ani hɨsɨvadi uami. Lɨci hulaŋ iamɨgali agɨlaŋ nudɨ ciaŋ agasaŋ niuŋ lɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Lɨhavɨci Jisasɨ hulaŋ iamɨgali agɨladɨ lahuci haiabɨla ivavehavɨmi. Ivavehavɨdaci Jisasɨ nadi agadɨ valɨ mikɨ pɨŋ umi. Uavɨla nadi agadɨ human mɨŋalɨva mɨŋaiahɨci lagulamami. ");
INSERT INTO ena_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Lɨci ciaŋ hɨjɨ agaŋ fɨli tɨbɨ heŋ sɨkasɨkan umi vemi. ");
INSERT INTO ena_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Lɨci Jisasɨ haiabɨla agadɨ valavɨla umi. Udaci hulaŋ ahica lamɨgaŋ sɨbɨlɨ agɨlaŋ sɨvɨ uu ula ula abavɨmi. Nama Devitɨ dɨ iamɨlɨnu uavɨmi. Alusaŋ mavɨn hɨniavɨla aludɨ huaci lamɨha uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Lɨhavɨdaci Jisasɨ ua nudɨ nukeŋ ulaŋ hɨvɨ ivoumi. Ivoudaci hulaŋ ahica lamɨgaŋ sɨbɨlɨ agɨlaŋ nudɨ sɨvɨ ivouavɨmi. Ivouavɨci Jisasɨ nulɨdɨ abitɨhami. Viaŋ naludɨ huaci lamalama saŋ hɨji vɨdɨvɨdɨŋ lamɨlaŋ ua hɨma uami. Lɨci nudɨ abavɨmi. Aludɨ Hekɨlɨ uavɨmi. Alaŋ hɨji vɨdɨvɨdɨŋ lamalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Lɨhavɨci nulɨdɨ lamɨgaŋ sabɨ hɨvɨ human lamavɨla abami. Namɨlaŋ iasaŋ hɨji vɨdɨvɨdɨŋ lamɨlaŋ sadaŋ akuaba akuaba saŋ abɨlaŋ agɨlaŋ hameŋ laci ala naludɨ hɨvɨ iahavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Lɨci nulɨdɨ lamɨgaŋ agɨlaŋ huaci lɨhavɨci igasulavɨmi. Igasulavɨdaci nulɨdɨ vɨdɨvɨdɨŋ sɨbaŋ abami. Akuaba akuaba naludɨ hɨvɨ iahavi agɨladɨ lɨlaŋ hulaŋ mu avi igahɨlavɨmɨdɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Agadɨ ala nɨbɨlaŋ fɨli tɨbɨ heŋ hɨsɨŋ hulaŋ iamɨgali sɨkasɨkan agɨladɨ sulavɨmi. Jisasɨ nulɨdɨ huaci lamami agasaŋ sulavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hulaŋ ahica agɨlaŋ Jisasɨ dɨ vala uavɨdaci hulaŋ mu sudɨ sɨbɨlɨ daŋ sɨbɨsaŋ mumia hɨniadami agadɨ via Jisasɨ dɨ pɨŋ vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Vavehavɨci Jisasɨ sudɨ sɨbɨlɨ agadɨ lahumi. Lahuci hulaŋ sɨbɨsaŋ mumia hɨniadami agaŋ cɨhu ciaŋ abami. Ciaŋ abɨdaci hulaŋ iamɨgali agɨlaŋ iga iga i uavɨmi. Vaka akuaba akuaba sibɨla hameŋ agɨlaŋ Isɨlaelɨ fɨli tɨbɨ neŋ ma iahavɨhadami uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Lɨhavɨci Falisi hɨdɨlɨ agɨlaŋ abavɨmi. Nɨbu sudɨ sɨbɨlɨ agɨladɨ manɨgali agadɨ vɨdɨvɨdɨŋ hɨvɨ sudɨ sɨbɨlɨ lahulalɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisasɨ agaŋ haiabɨla hekɨlɨ hekɨlɨ haiabɨla sudɨme sudɨme heŋ hɨdadami. Hɨdahɨda Isɨlaelɨ hɨdɨlɨ agɨladɨ aŋam ulaŋ hɨvɨ ivo ivo hulaŋ iamɨgali agɨladɨ lamalubiadami. Asɨ hulaŋ iamɨgali likɨlɨci nudɨ lɨhu hɨvɨ hɨniavɨbali agasaŋ suladami. Sulasula hɨdahɨda hulaŋ iamɨgali hɨmuhɨmu daŋ agɨladɨ huaci lamadami. Akuaba akuaba hɨmuhɨmu mu hɨdɨlɨ mu hɨdɨlɨ hulaŋ iamɨgali agɨladɨ sɨbɨlɨ lamavɨhadami agɨladɨ avi lɨdaci huaci lɨhavɨhadami. ");
INSERT INTO ena_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Lɨdɨŋ hulaŋ iamɨgali agɨladɨ igɨdaci sabaŋ sipsipɨ iagaŋ apalɨ agɨlaŋ me hɨniavɨhadami. Hɨnihɨni ninanadi mavacɨŋ me uava iahuiahu hɨniavɨhadami. Lɨhavɨdaci Jisasɨ nulɨsaŋ mavɨn hekɨlɨ lamami. ");
INSERT INTO ena_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Lavɨla nudɨ hulemɨlɨ agɨladɨ hɨve lama abami. Hualabɨla hɨsɨŋ sɨmɨŋ akape ci mɨdɨ lɨhuavi uami. Agadɨ ala hualabɨla agadɨ sibɨla vivi sɨmɨŋ mɨgudɨbalɨba hɨsɨŋ hulaŋ akape hɨma uami. ");
INSERT INTO ena_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Namɨlaŋ hualɨ iaganu agadɨ abitɨhɨhalaŋ uami. Abitɨhɨlaŋ nɨbu nudɨ sibɨla hɨsɨŋ hulaŋ agɨladɨ abɨci uavɨla nudɨ sɨmɨŋ agɨladɨ mɨgudɨbavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisasɨ nudɨ hulemɨlɨ human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ agɨladɨ abɨci nudɨ pɨŋ vehavɨmi. Vehavɨci sudɨ sɨbɨlɨ lahuavɨbali aba nulɨsaŋ ibi igu igu umi. Akuaba akuaba hɨmuhɨmu mu hɨdɨlɨ mu hɨdɨlɨ hulaŋ iamɨgali agɨladɨ sɨbɨlɨ lamavɨhadami agɨladɨ avi lɨhavɨdaci huaci lɨhavɨbali aba ibi igu igu umi. ");
INSERT INTO ena_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Hulaŋ lɨbɨmɨŋami agɨladɨ ibi nameŋ. Mu Saimon. Jisasɨ agaŋ Saimon dɨ ibi mu lamavɨla abami. Pita uami. Mu Saimon imanu Edɨlu. Mu Sebedi ninanu Jemɨsɨ. Mu Jemɨsɨ imanu Jon. ");
INSERT INTO ena_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Mu Filipɨ. Mu Balɨtolomiu. Mu Tomasɨ. Mu Matiu. Matiu nɨbu huban saŋ anɨm hɨlɨcɨ vihadami. Mu Alɨfiusɨ dɨ ninanu Jemɨsɨ. Mu Tadiusɨ. ");
INSERT INTO ena_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Mu Saimon. Saimon nɨbu Selotɨ hɨdɨlɨ. Mu Judasɨ. Nudɨ ibi mu Isɨkaliotɨ. Hulaŋ nɨbu ala Jisasɨ dɨ ilasami. ");
INSERT INTO ena_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisasɨ agaŋ hulaŋ human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ sibɨla vivi saŋ lɨbɨmɨŋami agɨladɨ milɨbalɨba abami. Hulaŋ iamɨgali hɨdɨlɨ mu mu agɨladɨ pɨŋ umɨlaŋ uami. Samalia fɨli tɨbɨ hɨsɨŋ agɨladɨ haiabɨla mu mu ivoumɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isɨlaelɨ hɨdɨlɨ hulaŋ iamɨgali agɨlaŋ sabaŋ sipsipɨ abeba abeba uu haba sɨvɨla sɨvɨla hɨnihɨni me hɨniavɨlalɨ uami. Namɨlaŋ nulɨdɨ pɨŋ uhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Uavɨla nulɨdɨ nameŋ abɨhalaŋ uami. Asɨ agaŋ hulaŋ iamɨgali agɨladɨ amɨŋ ci likɨlɨci nudɨ lɨhu hɨvɨ hɨniavɨbali aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Lavɨla hulaŋ iamɨgali hɨmuhɨmu daŋ agɨladɨ huaci lamɨhalaŋ uami. Hulaŋ iamɨgali hɨmavɨla valɨ hɨniavɨci abɨlaŋ cɨhu hɨhi iahavɨm uami. Hulaŋ lɨpɨlɨm lɨpɨlɨm daŋ agɨladɨ huaci lamɨhalaŋ uami. Hulaŋ sudɨ sɨbɨlɨ daŋ agɨladɨ iga iga sudɨ sɨbɨlɨ agɨladɨ lahuhalaŋ uami. Namɨlaŋ nulɨdɨ ahɨliahuiahu saŋ Asɨ agaŋ vɨdɨvɨdɨŋ hameŋ agɨladɨ nalusaŋ igulalɨ uami. Namɨlaŋ vɨdɨvɨdɨŋ hameŋ agɨladɨ anɨm hɨlɨcɨ hɨvɨ ma lavɨlalaŋ uami. Asɨ agaŋ nudɨ nukeŋ hɨji hɨvɨ nalusaŋ vɨdɨvɨdɨŋ agadɨ havɨ igulalɨ uami. Hameŋ sadaŋ namɨlaŋ hulaŋ iamɨgali limu hɨhɨle agɨladɨ ahɨliahudalaŋ huaci lɨhavɨdaci akuaba akuaba hɨbɨŋ vivi saŋ abɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Hulaŋ sibɨla vivi vubɨŋ fɨhalavɨlalɨ agɨlasaŋ sɨmɨŋ igunavɨlalɨ uami. Hameŋ ala nalusaŋ avi sɨmɨŋ igunavɨbali uami. Hameŋ sadaŋ namɨlaŋ sɨmɨŋ lavalava saŋ anɨm hɨlɨcɨ lɨba golɨ lɨba silɨva lɨba kapa hɨvɨ vihavalɨ agɨladɨ naludɨ anɨm hɨlɨcɨ vaŋ hɨvɨ hudavɨla via umɨlaŋ uami. Vaŋ hala agɨladɨ via umɨlaŋ uami. Hadi hɨlahɨla mu via umɨlaŋ uami. Hɨcɨ sɨgɨtɨ agɨladɨ via umɨlaŋ uami. Kɨlɨ lɨmɨ mɨŋalɨva hɨdahɨda hɨsɨŋ agɨladɨ avi via umɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Namɨlaŋ uavɨla akuaba me haiabɨla hɨvɨ iahavɨla uami. Haiabɨla heŋ hɨsɨŋ hulaŋ mu naludɨ huaci migɨlɨbali agasaŋ abitɨhatɨha suhɨla suhɨla hɨdɨhalaŋ uami. Suhɨla suhɨla hɨda igavɨla nɨbu hula laci hɨnihalaŋ uami. La haiabɨla mu hɨvɨ ubalu aba nudɨ heŋ vala uhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Uavɨla ulaŋ mu hɨvɨ ivouavɨla uami. Hulaŋ iamɨgali ulaŋ heŋ hɨniavɨlalɨ agɨladɨ nameŋ abɨhalaŋ uami. Asɨ agaŋ naludɨ huaci lamɨbali aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Lɨlaŋ hulaŋ iamɨgali ulaŋ heŋ hɨniavɨlalɨ agɨlaŋ naludɨ igavɨla hɨjɨŋalavɨci uami. Naludɨ ciaŋ huaci agaŋ nulɨdɨ huaci lamɨci nulɨdɨ humɨgaŋ agɨlaŋ simɨ hɨniavɨbali uami. Agadɨ ala naludɨ igavɨla ma hɨjɨŋalavɨci uami. Ha ciaŋ huaci agaŋ namɨlaŋ hula laci hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ua iahulaŋ haiabɨla heŋ hɨsɨŋ agɨlaŋ naludɨ ciaŋ igahɨlahɨla saŋ valavɨla nalusaŋ ulaŋ ma iguavɨci uami. Ulaŋ haiabɨla agadɨ vala ubalu aba hɨcɨ ibɨlɨ ifɨlaŋ mɨgɨci uhalaŋ uami. Lɨlaŋ hulaŋ iamɨgali haiabɨla heŋ hɨsɨŋ agɨlaŋ igavɨla hɨji lamalama abavɨbali uami. Ha alaŋ ma abɨmɨli ve aludɨ ulaŋ hɨvɨ hɨnihɨni ciaŋ sulavɨdaci igahɨlalu agasaŋ hɨcɨ ibɨlɨ ifavɨci mɨgɨci uavadi aba abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Viaŋ naludɨ amɨŋ abadin uami. Asɨ hulaŋ iamɨgali ciaŋ hɨvɨ lamɨbali agadɨ mɨhiŋ hekɨlɨ agaŋ iahɨci nɨbɨlaŋ vɨhɨlɨ hekɨlɨ igavɨbali uami. Sodom haiabɨla Gomola haiabɨla agɨladɨ fɨli tɨbɨ hɨsɨŋ hɨmavɨmi agɨlaŋ vɨhɨlɨ igavɨbali hameŋ agadɨ ma igavɨbali uami. Vɨhɨlɨ hekɨlɨ sɨbaŋ agadɨ igavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Lavɨla Jisasɨ cɨhu abami. Ci igɨlaŋ uami. Viaŋ naludɨ abɨlɨŋ sabaŋ sipsipɨ agɨlaŋ sudɨ iŋam alɨhaŋ alɨhaŋ uavɨlalɨ hameŋ ubalaŋ uami. Namɨlaŋ hɨji sɨhɨvia igahɨlahɨla lahu hɨdavɨlalɨ hameŋ hɨdɨhalaŋ uami. Havaŋ ibɨlabi hɨdavɨlalɨ hameŋ hɨdahɨda akuaba lusɨŋ sɨbɨlɨ vivi saŋ ma igahɨlɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","18","Namɨlaŋ sɨhɨvia sɨbaŋ migɨlɨhalaŋ uami. Namɨlaŋ iadɨ ciaŋ lubiahɨlɨlalaŋ sadaŋ naludɨ ciaŋ hɨvɨ lamalama saŋ cihu tɨbaŋ daŋ agɨladɨ pɨŋ vivi uavɨbali uami. Lɨhavɨdaci nulɨdɨ aŋam ulaŋ mu mu agɨladɨ hɨvɨ ivo ivo hɨnidalaŋ nɨbɨlaŋ naludɨ vɨgɨlavɨbali uami. Lɨdɨŋ naludɨ mɨŋamagɨlamagɨla huban agɨladɨ pɨŋ vivi uavɨbali uami. Manɨgali fɨli tɨbɨ hɨtɨŋ hɨtɨŋ migɨlavɨbali agɨladɨ pɨŋ vivi uavɨbali uami. Hameŋ lɨhavɨdaci namɨlaŋ nulɨsadaŋ hɨdɨlɨ mu mu agɨlasadaŋ Asɨ dɨ ciaŋ sulɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nɨbɨlaŋ naludɨ ciaŋ hɨvɨ lamalama saŋ vivi uavɨdaci namɨlaŋ hɨji cuvɨlɨŋ cuvɨlɨŋ lamɨmɨlaŋ uami. Alaŋ iabi akɨ ubalu aba hɨji cuvɨlɨŋ cuvɨlɨŋ lamɨmɨlaŋ uami. Naludɨ abavɨbali hadɨhu Asɨ dɨ Amɨŋ agaŋ nalusaŋ hɨji igudaci ciaŋ abɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Namɨlaŋ nukeŋ ma abɨbalaŋ uami. Naludɨ Iaganalu Asɨ dɨ Amɨŋ agaŋ nalusaŋ hɨji igudaci abɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Hulaŋ mu nudɨ isaimahalinu agɨladɨ ifɨhɨmuhɨmu saŋ huban agɨladɨ pɨŋ via ubali uami. Iagagalinɨlu agɨlaŋ ninanadinɨlu agɨladɨ hameŋ ala lɨhavɨbali uami. Ninanadinɨlu agɨlaŋ iamiagagalinɨlu agɨladɨ nagɨli lamalama hulaŋ hɨhɨle agɨladɨ abavɨdaci nulɨdɨ ifɨhɨmavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Namɨlaŋ iadɨ ibi hɨvɨ sibɨla vibalaŋ sadaŋ hulaŋ iamɨgali sɨkasɨkan agɨlaŋ nalusaŋ igɨvɨ hɨniavɨbali uami. Hulaŋ iamɨgali hɨji vɨdɨvɨdɨŋ daŋ hɨnihɨni vɨhɨlɨ mu mu agɨladɨ havahava hɨniavɨla hɨmavɨci uami. Ha Asɨ agaŋ nulɨdɨ ahɨliahudaci huaci hameŋ laci hameŋ laci hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Hulaŋ iamɨgali haiabɨla mu hɨsɨŋ agɨlaŋ naludɨ sɨbɨlɨ lamavɨci uami. Haŋɨla haiabɨla mu hɨvɨ uhalaŋ uami. Viaŋ naludɨ amɨŋ abadin uami. Isɨlaelɨ hɨdɨlɨ agɨladɨ haiabɨla sɨkasɨkan agɨladɨ hɨvɨ sibɨla ma vi fɨhalɨmaŋ lɨdalaŋ Hulaŋ dɨ Ninaŋ agaŋ vebali uami. ");
INSERT INTO ena_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Sɨhɨ ciaŋ hɨsɨŋ hulemɨlɨ agaŋ nudɨ manasɨŋ sihɨ hɨsɨŋ agadɨ ma lɨvalɨlalɨ uami. Sibɨla hɨsɨŋ hulaŋ agaŋ avi nudɨ manɨgali agadɨ ma lɨvalɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sɨhɨ ciaŋ hɨsɨŋ hulemɨlɨ agaŋ nudɨ manasɨŋ sihɨ hɨsɨŋ me hɨnici uami. Ha ci uami. Sibɨla hɨsɨŋ hulaŋ agaŋ nudɨ manɨgali me hɨnici uami. Han avi ci uami. Ulaŋ iaganu agadɨ Belɨsebulɨ aba abavalɨ uami. Nudɨ hulemɨlɨ agɨladɨ avi ibi sɨbɨlɨ sɨbaŋ agɨladɨ lamavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Lavɨla Jisasɨ cɨhu abami. Asɨ agaŋ mufɨli akuaba akuaba sɨvɨla sɨvɨla hɨniavɨlalɨ agɨladɨ lɨdaci cɨhu haiabɨla iahavɨbali uami. Hulaŋ iamɨgali agɨlaŋ akuaba akuaba ciaŋ nɨfɨlɨ hɨsɨŋ agɨladɨ igahɨlavɨbali uami. Hameŋ sadaŋ hulaŋ hɨhɨle naludɨ sɨbɨlɨ lamɨbalu aba lɨhavɨlalɨ agɨlasaŋ lɨdɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Viaŋ ciaŋ hɨfɨlɨ hɨvɨ naludɨ abin agadɨ uami. Namɨlaŋ uaiadi hɨvɨ sulɨhalaŋ uami. Akuaba ciaŋ nɨfɨlɨ cɨki igahɨlɨlalaŋ agɨladɨ uami. Haiabɨla lagulamalama ula ula abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Hulaŋ naludɨ ifɨhɨmavɨlalɨ agɨlasaŋ lɨdɨmɨlaŋ uami. Nɨbɨlaŋ naludɨ amɨŋ agɨladɨ ma ifɨhɨmavɨbali uami. Asɨ saŋ pam lɨdɨhalaŋ uami. Nɨbu naludɨ huaci ifɨhɨmuhɨmu naludɨ amɨŋ agɨladɨ vivi avɨŋ hɨvɨ havalɨdaci mɨguavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Namɨlaŋ igɨlalaŋ uami. Hulaŋ iamɨgali agɨlaŋ havaŋ cɨki cɨki ahica agɨladɨ anɨm hɨlɨcɨ pabiŋ cɨki hɨvɨ lavavɨlalɨ uami. Havaŋ agɨlaŋ sudɨme cɨki cɨki sɨbaŋ uami. Agadɨ ala naludɨ Iaganalu Asɨ agaŋ havaŋ agɨladɨ sɨhɨvia sɨbaŋ migɨlɨlalɨ uami. Migɨla migɨla hɨnidaci havaŋ mu akuaba lɨci hɨmɨlalɨ agadɨ nɨbu igɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Asɨ naludɨ iga fɨhalɨlalɨ uami. Lɨdɨŋ naludɨ hali mɨnɨ agɨladɨ ci lugɨla fɨhalɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Naludɨ amɨŋ agɨlaŋ Asɨ dɨ Amɨŋ me sadaŋ namɨlaŋ havaŋ cɨki cɨki akape agɨladɨ lɨvalɨlalaŋ uami. Hameŋ sadaŋ namɨlaŋ lɨdɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Lavɨla Jisasɨ cɨhu abami. Hulaŋ mu agaŋ hulaŋ iamɨgali limu hɨhɨle agɨladɨ hɨvɨ uavɨla nameŋ abɨci uami. Viaŋ Jisasɨ dɨ hulemɨlɨ hɨnilan aba abɨci uami. Viaŋ avi iadɨ Iavaŋ iahua hɨvɨ hɨnilalɨ agadɨ abɨben uami. Nɨbu iadɨ hulemɨlɨ aba abɨben uami. ");
INSERT INTO ena_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Agadɨ ala hulaŋ mu agaŋ hulaŋ iamɨgali limu hɨhɨle agɨladɨ hɨvɨ uavɨla nameŋ abɨci uami. Viaŋ Jisasɨ dɨ hulemɨlɨ hɨma aba abɨci uami. Ha viaŋ avi iadɨ Iavaŋ iahua hɨvɨ hɨnilalɨ agadɨ abɨben uami. Nɨbu iadɨ hulemɨlɨ hɨma aba abɨben uami. ");
INSERT INTO ena_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Lavɨla Jisasɨ cɨhu abami. Namɨlaŋ hɨji nameŋ lamɨmɨlaŋ uami. Jisasɨ nɨbu fɨli neŋ hɨnihɨni sagaŋ abamɨgɨlamɨgɨla saŋ vemi aba abɨmɨlaŋ uami. Viaŋ sagaŋ abamɨgɨlamɨgɨla saŋ ma vemin uami. Viaŋ sagaŋ lɨbalɨba saŋ puia hutesɨ vavemin uami. ");
INSERT INTO ena_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Viaŋ hulaŋ iamɨgali nɨbɨlaŋ nukeŋ nukeŋ nagɨli lamalama saŋ vemin uami. Ninanu agaŋ iaganu dɨ nagɨli lamɨbali uami. Nadinu agaŋ iamɨnu dɨ nagɨli lamɨbali uami. Nabenu agaŋ amɨjinu dɨ nagɨli lamɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Hulaŋ mu agadɨ abinu ninanadinu ajihalinu ulaŋ pabiŋ hɨvɨ hɨniavɨlalɨ agɨlaŋ iaha nudɨ nagɨli lamavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Hulaŋ mu iamiaganu saŋ pam mavɨn hekɨlɨ sɨbaŋ hɨnilalɨ agaŋ uami. Viaŋ hula hɨnihɨni saŋ mavɨn hekɨlɨ sɨbaŋ ma hɨnilalɨ uami. Nɨbu iadɨ hulemɨlɨ ma hɨnibali uami. Hulaŋ mu nudɨ ninanadinu saŋ mavɨn hekɨlɨ sɨbaŋ hɨnilalɨ agaŋ uami. Viaŋ hula hɨnihɨni saŋ mavɨn hekɨlɨ sɨbaŋ ma hɨnilalɨ uami. Nɨbu iadɨ hulemɨlɨ ma hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Hulaŋ mu vɨhɨlɨ havahava viaŋ hula hɨdahɨda saŋ valɨlalɨ agaŋ uami. Nɨbu iadɨ hulemɨlɨ ma hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Hulaŋ mu nudɨ hadipɨlɨ hɨhi hɨnihɨni agasaŋ pam hɨji lamalama hɨnici uami. Nudɨ amɨŋ agaŋ huaci hameŋ laci hameŋ laci ma hɨnibali uami. Agadɨ ala hulaŋ mu iasaŋ pam igahɨlahɨla nudɨ hadipɨlɨ agadɨ vana sɨbɨlɨ lɨm aba abɨci uami. Nudɨ amɨŋ agaŋ huaci hameŋ laci hameŋ laci hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Lavɨla Jisasɨ cɨhu abami. Hulaŋ mu nalusaŋ hɨjɨŋalɨlalɨ agaŋ iasaŋ avi hɨjɨŋalɨlalɨ uami. Hulaŋ mu iasaŋ hɨjɨŋalɨlalɨ agaŋ Asɨ iadɨ abɨci vemin agasaŋ avi hɨjɨŋalɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Hulaŋ mu agaŋ Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ agadɨ igavɨla hɨji nameŋ lamɨbali uami. Hulaŋ nagaŋ Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ aba abɨbali uami. Hameŋ hɨji igahɨlavɨla nudɨ ahɨliahuci uami. Asɨ agaŋ nusaŋ akuaba akuaba huaci huaci igubali uami. Akuaba akuaba huaci huaci nudɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ agɨlasaŋ igulalɨ hameŋ agɨladɨ igubali uami. Hulaŋ mu agaŋ hulaŋ Asɨ dɨ ciaŋ sɨhɨvia lubiahɨlɨlalɨ agadɨ igavɨla hɨji nameŋ lamɨbali uami. Hulaŋ nagaŋ Asɨ dɨ ciaŋ sɨhɨvia lubiahɨlɨlalɨ aba abɨbali uami. Hameŋ hɨji igahɨlavɨla nudɨ ahɨliahuci uami. Asɨ agaŋ nusaŋ akuaba akuaba huaci huaci igubali uami. Akuaba akuaba huaci huaci hulaŋ nudɨ ciaŋ sɨhɨvia lubiahɨlɨlalɨ agasaŋ igulalɨ hameŋ agɨladɨ igubali uami. ");
INSERT INTO ena_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Hulaŋ mu agaŋ Jisasɨ dɨ hulemɨlɨ mu ibi apalɨ agadɨ igavɨla hɨji nameŋ lamɨbali uami. Hulaŋ nagaŋ Jisasɨ dɨ hulemɨlɨ aba abɨbali uami. Hameŋ hɨji igahɨlavɨla nudɨ huaci lamavɨla avɨli vumɨli iguci uami. Asɨ agaŋ akuaba akuaba huaci huaci agɨladɨ hulaŋ agasaŋ igubali uami. Viaŋ naludɨ amɨŋ abadin uami. Akuaba akuaba huaci huaci Asɨ nusaŋ igubali agɨlaŋ ma sɨbɨlɨ lɨhavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisasɨ agaŋ nudɨ hulemɨlɨ agɨladɨ sɨhɨvia sɨbaŋ lamalubilubi abami. Abɨci ci lɨci iaha haiabɨla agadɨ valavɨla umi. Ua Galili fɨli tɨbɨ agadɨ haiabɨla mu hɨvɨ mu hɨvɨ hɨdahɨda hulaŋ iamɨgali agɨladɨ lamalubilubi Asɨ dɨ ciaŋ agadɨ nulɨsaŋ suladami. ");
INSERT INTO ena_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Lɨdaci Jon agaŋ lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ hɨnihɨni Jisasɨ Kɨlaisɨ akuaba akuaba lɨmi agadɨ ciaŋ hɨjɨ igahɨlami. Lavɨla nudɨ hulemɨlɨ agɨladɨ abɨci uavɨla Jisasɨ dɨ abavɨmi. Jon agaŋ nadɨ nameŋ abalɨ uavɨmi. Asɨ agaŋ hulaŋ mu vebali agasaŋ abami aba abalɨ uavɨmi. Asɨ hameŋ abami ha nasaŋ ala abami ua hulaŋ mu saŋ migɨlɨbalu agasaŋ abami aba abalɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Lɨhavɨci Jisasɨ nulɨdɨ abami. Namɨlaŋ uavɨla Jon dɨ sulɨhalaŋ uami. Akuaba akuaba ciaŋ igahɨlɨlaŋ agɨladɨ sulɨhalaŋ uami. Akuaba akuaba igɨlaŋ agɨlasaŋ avi sulɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Lamɨgaŋ sɨbɨlɨ sɨbɨlɨ agɨlaŋ cɨhu igasulavɨlalɨ aba abɨhalaŋ uami. Hɨcɨ sɨbɨlɨ sɨbɨlɨ agɨlaŋ cɨhu huaci hɨdavɨlalɨ aba abɨhalaŋ uami. Hulaŋ lɨpɨlɨm lɨpɨlɨm daŋ agɨlaŋ huaci lɨdɨŋ lɨpɨlɨm lɨpɨlɨm apalɨ hɨniavɨlalɨ aba abɨhalaŋ uami. Hɨji uavauava daŋ agɨlaŋ cɨhu huaci lɨdɨŋ ciaŋ igahɨlavɨlalɨ aba abɨhalaŋ uami. Hulaŋ hɨmavɨlalɨ agɨlaŋ cɨhu hɨhi iahavɨlalɨ aba abɨhalaŋ uami. Hulaŋ iamɨgali akuaba akuaba apalɨ agɨlaŋ Asɨ dɨ ciaŋ igahɨlavɨlalɨ aba abɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Viaŋ sibɨla vilan agɨladɨ iga iga hɨji vɨdɨvɨdɨŋ daŋ hɨnihɨni hɨji vɨdɨvɨdɨŋ ma valavɨlalɨ agɨlaŋ hɨjɨŋalavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Lɨci Jon dɨ hulemɨlɨ agɨlaŋ cɨhu uavɨmi. Uavɨdaci Jisasɨ agaŋ Jon nɨbu fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ hɨniadami agasaŋ igahɨlavɨla hulaŋ iamɨgali agɨladɨ nameŋ abami. Namɨlaŋ fɨli tɨbɨ kɨlɨ humɨsɨ akuaba akuaba apalɨ heŋ ulalaŋ uami. Ha huŋe veve suhan agɨladɨ mɨŋasese lɨlalɨ agadɨ iga iga saŋ ma ulalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Namɨlaŋ hulaŋ mu hadi hɨlahɨla huaci huaci lamɨlalɨ agadɨ iga iga saŋ ma ulalaŋ uami. Hulaŋ hadi hɨlahɨla huaci huaci lamavɨlalɨ agɨlaŋ uami. Nɨbɨlaŋ manɨgali fɨli tɨbɨ mu mu migɨlavɨlalɨ agɨladɨ ulaŋ hɨvɨ hɨniavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Namɨlaŋ akuaba akuaba iga iga saŋ ma ulalaŋ uami. Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ Jon dɨ iga iga saŋ ulalaŋ uami. Viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Jon agaŋ Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ sɨkasɨkan agɨladɨ lɨvalɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nusaŋ ala Asɨ dɨ manasɨŋ hekɨlɨ agaŋ nameŋ abami uami. Asɨ agaŋ Ninanu dɨ abi aba abami uami. Ci igɨnaŋ aba abi aba abami uami. Viaŋ abɨlɨŋ hulaŋ mu iadɨ ciaŋ aba aba hɨsɨŋ agaŋ hali ubali aba abi aba abami uami. Udaci nama sɨvɨ ubanaŋ aba abi aba abami uami. Nɨbu hali uavɨla hɨdahɨda nasaŋ hɨbɨ me vɨcibali aba abi aba abami uami. ");
INSERT INTO ena_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Viaŋ naludɨ amɨŋ abadin uami. Asɨ igɨdaci Jon hulaŋ iamɨgali avɨli hɨvɨ mɨŋamɨgu mɨŋaiahaiaha hɨsɨŋ agaŋ hulaŋ iamɨgali fɨli neŋ hɨniavɨlalɨ agɨladɨ lɨvalavɨla ibi hekɨlɨ daŋ hɨnilalɨ uami. Agadɨ ala Asɨ agaŋ hulemɨlɨ mu ibi apalɨ hameŋ agadɨ vici nudɨ lɨhu hɨvɨ hɨnilalɨ agaŋ Jon dɨ lɨvala ibi hekɨlɨ daŋ hɨnilalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Hameŋ sadaŋ hulaŋ vɨdɨvɨdɨŋ daŋ agɨlaŋ hɨji nameŋ lamavɨlalɨ uami. Asɨ agaŋ aludɨ likɨlɨci nudɨ lɨhu hɨvɨ hɨnibalu aba abavɨlalɨ uami. Lɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ sagaŋ me lɨbalɨba alusaŋ vɨhɨlɨ mu mu agɨladɨ iguavɨlalɨ uami. Hulaŋ iamɨgali avɨli hɨvɨ mɨŋamɨgu mɨŋaiahaiaha hɨsɨŋ hulaŋ Jon agaŋ ciaŋ sulɨdaci hameŋ lɨhavɨlalɨ uami. La iabi neŋ avi hameŋ ala lɨhavadi uami. ");
INSERT INTO ena_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ agɨlaŋ uami. Hulaŋ Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ Mosesɨ lɨbami agadɨ iga iga abavɨlalɨ agɨlaŋ uami. Asɨ hulaŋ iamɨgali likɨlɨci nudɨ lɨhu hɨvɨ hɨniavɨbali agasaŋ abavɨhadami uami. Aba aba hɨniavɨdaci hulaŋ iamɨgali avɨli hɨvɨ mɨŋamɨgu mɨŋaiahaiaha hɨsɨŋ hulaŋ Jon agaŋ iahami uami. ");
INSERT INTO ena_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Namɨlaŋ iadɨ ciaŋ nagadɨ igahɨlɨben aba igahɨlɨhalaŋ uami. Asɨ dɨ manasɨŋ hekɨlɨ agaŋ nameŋ abami uami. Elaija amɨŋ ci vebali aba abami uami. Ha hulaŋ iamɨgali avɨli hɨvɨ mɨŋamɨgu mɨŋaiahaiaha hɨsɨŋ hulaŋ Jon vebali agasaŋ abami uami. ");
INSERT INTO ena_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","La abami. Hulaŋ iamɨgali hɨji daŋ lɨci ciaŋ nagadɨ sɨhɨvia sɨbaŋ igahɨlavɨm uami. ");
INSERT INTO ena_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Viaŋ hulaŋ iamɨgali iabi neŋ hɨnidalaŋ nalusaŋ hɨve lama abɨben uami. Namɨlaŋ ninanadi mutɨŋ vivi sabɨlɨm hɨvɨ mɨgahɨniavɨvi agɨlaŋ me uami. Lavɨla ninanadi limu hɨhɨle agɨladɨ ulavɨla abavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Alaŋ sai mahɨlɨdamɨli namɨlaŋ ma sɨcilaŋ aba abavɨvi uami. Alaŋ hulaŋ valɨ agasaŋ mavɨn ciaŋ ciaŋ daŋ sɨhɨ iahɨdamɨli namɨlaŋ ma mavɨn mɨŋamɨŋa ilɨhɨlaŋ aba abavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Lavɨla cɨhu ala abami. Avɨli hɨvɨ mɨŋamɨgu mɨŋaiahaiaha hɨsɨŋ hulaŋ Jon agaŋ vevɨla maci ma nɨlalɨ uami. Lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ avi ma nɨlalɨ uami. Lɨdaci nɨbɨlaŋ abavɨlalɨ uami. Sudɨ sɨbɨlɨ nɨbu hula hɨnidi aba abavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Hulaŋ dɨ Ninaŋ agaŋ vevɨla maci nɨlalɨ uami. Lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ nɨlalɨ uami. Lɨdaci nameŋ abavɨlalɨ uami. Nɨbu maci nana saŋ pam igahɨlɨlalɨ aba abavɨlalɨ uami. Nɨbu lɨmɨn uain agɨladɨ amɨŋ agɨladɨ mɨtɨ nana saŋ pam igahɨlɨlalɨ aba abavɨlalɨ uami. Nɨbu lusɨŋ sɨbɨlɨ hɨsɨŋ agɨladɨ nagɨli huaci hɨnilalɨ aba abavɨlalɨ uami. Nulɨdɨ hulaŋ hɨhɨle huban saŋ anɨm hɨlɨcɨ vihavɨlalɨ agɨladɨ avi nagɨli huaci hɨnilalɨ aba abavɨlalɨ uami. Nɨbɨlaŋ hameŋ abavɨlalɨ uami. Agadɨ ala hulaŋ iamɨgali Asɨ dɨ hɨji hutesɨ agadɨ lubiahɨlavɨdaci hulaŋ limu hɨhɨle agɨlaŋ nulɨdɨ iga iga abavɨlalɨ uami. Asɨ dɨ hɨji nɨbu huaci sɨbaŋ aba abavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisasɨ agaŋ haiabɨla mu hɨvɨ mu hɨvɨ hɨdahɨda vɨdɨvɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ abalamadami. Agadɨ ala hulaŋ iamɨgali agɨlaŋ nulɨdɨ lusɨŋ sɨbɨlɨ sɨbɨlɨ agɨladɨ ma valavɨhadami. Lɨhavɨdaci haiabɨla heŋ hɨsɨŋ agɨlasaŋ ciaŋ vɨdɨvɨdɨŋ nameŋ abami. ");
INSERT INTO ena_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Hulaŋ iamɨgali Kolasin haiabɨla hɨsɨŋ namɨlaŋ vɨhɨlɨ igɨbalaŋ uami. Hulaŋ iamɨgali Betɨsaida haiabɨla hɨsɨŋ namɨlaŋ avi vɨhɨlɨ igɨbalaŋ uami. Viaŋ namɨlaŋ hula hɨnihɨni Asɨ dɨ vɨdɨvɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ abalamɨdalɨŋ igɨlalaŋ uami. Agadɨ ala namɨlaŋ naludɨ lusɨŋ sɨbɨlɨ sɨbɨlɨ agɨladɨ ma valɨlalaŋ uami. Viaŋ Asɨ dɨ vɨdɨvɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ hameŋ agɨladɨ abalamalama saŋ Tailɨ haiabɨla ma uacin uami. Viaŋ ua nulɨsaŋ vɨdɨvɨdɨŋ mu mu hameŋ agɨladɨ abalamɨdalɨŋ igavalɨ padaŋ lusɨŋ sɨbɨlɨ sɨbɨlɨ agɨladɨ vakaci valavɨvi uami. Lavɨla havɨlɨ hasɨ hasɨ agɨladɨ lɨbavɨla mɨgahɨnihɨni avɨnibɨlɨ agɨladɨ vivi mɨŋaiapalavɨvi uami. Saidon haiabɨla hɨsɨŋ nɨbɨlaŋ avi hameŋ laci ala lɨhavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Asɨ hulaŋ iamɨgali ciaŋ hɨvɨ lamɨbali agadɨ mɨhiŋ hekɨlɨ agaŋ iahɨci uami. Kolasin haiabɨla hɨsɨŋ Betɨsaida haiabɨla hɨsɨŋ namɨlaŋ mɨhiŋ heŋ ala vɨhɨlɨ hekɨlɨ igɨbalaŋ uami. Tailɨ haiabɨla hɨsɨŋ Saidon haiabɨla hɨsɨŋ igavɨbali hameŋ agadɨ ma igɨbalaŋ uami. Vɨhɨlɨ hekɨlɨ sɨbaŋ agadɨ igɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kapelɨneam haiabɨla hɨsɨŋ namɨlaŋ nameŋ abɨlalaŋ uami. Alaŋ Asɨ dɨ haiabɨla uavɨla ibi hekɨlɨ daŋ hɨnibalu aba abɨlalaŋ uami. Agadɨ ala hɨma sɨbaŋ uami. Namɨlaŋ mɨgua sudɨ fɨli haiabɨla heŋ avɨha avɨha iga iga hɨnibalaŋ uami. Viaŋ naludɨ hɨvɨ hɨnihɨni vɨdɨvɨdɨŋ mu mu agɨladɨ abalamɨlan uami. Hulaŋ mu Sodom haiabɨla uavɨla vɨdɨvɨdɨŋ hameŋ agɨladɨ abalamɨdaci igavɨhadami padaŋ uami. Ha haiabɨla heŋ hɨsɨŋ hulaŋ iamɨgali agɨlaŋ malɨciŋ hanɨbuŋ hɨniavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Namɨlaŋ vɨdɨvɨdɨŋ mu mu agɨladɨ igɨlalaŋ uami. Agadɨ ala lusɨŋ sɨbɨlɨ ma valɨlalaŋ uami. Asɨ hulaŋ iamɨgali ciaŋ hɨvɨ lamɨbali agadɨ mɨhiŋ hekɨlɨ agaŋ iahɨci hulaŋ iamɨgali lusɨŋ sɨbɨlɨ ma valɨlalaŋ namɨlaŋ vɨhɨlɨ hekɨlɨ igɨbalaŋ uami. Sodom haiabɨla hɨsɨŋ hɨmavɨmi agɨlaŋ vɨhɨlɨ igavɨbali hameŋ agadɨ ma igɨbalaŋ uami. Vɨhɨlɨ hekɨlɨ sɨbaŋ agadɨ igɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Hadɨhu Jisasɨ agaŋ Asɨ dɨ abami. Iavaŋ uami. Nama akuaba akuaba fɨli hɨsɨŋ uaiaŋ susu hɨsɨŋ agɨladɨ migɨlɨlanaŋ uami. Iadɨ Iavaŋ nama huaci sɨbaŋ uami. Nama akuaba akuaba agɨladɨ mɨŋasɨvɨlɨdanaŋ hulaŋ hɨji hutesɨ hutesɨ daŋ agɨlaŋ ma igavɨlalɨ uami. Sɨhɨ ciaŋ hekɨlɨ ivavalɨ agɨlaŋ avi ma igavɨlalɨ uami. Lɨhavɨdaci hulemɨlɨ hɨji apalɨ me agɨlasaŋ pam abalamɨlanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iavaŋ viaŋ nadɨ huaci aba abadin uami. Nama nadɨ nukeŋ hɨji agadɨ lubiahɨlahɨla hameŋ lɨlanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Lavɨla Jisasɨ cɨhu nulɨdɨ abami. Iadɨ Iavaŋ agaŋ abɨci viaŋ pam akuaba akuaba sɨkasɨkan agɨladɨ migɨlɨlan uami. Hulaŋ iamɨgali agɨlaŋ Ninanu dɨ ma igavɨlalɨ uami. Iaganu laci Ninanu dɨ igɨlalɨ uami. Iaganu avi hameŋ laci ala uami. Ninanu laci Iaganu dɨ igɨlalɨ uami. Ninanu agaŋ hulaŋ iamɨgali hɨhɨle agɨladɨ abalamɨdaci Iaganu dɨ heŋ igavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","La cɨhu nameŋ abami. Hulaŋ iamɨgali avɨha avɨha iga iga vɨhɨlɨfɨlalaŋ namɨlaŋ iadɨ pɨŋ vehalaŋ uami. Vevɨla viaŋ hula hɨnihɨni alusɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Viaŋ akuaba akuaba nalusaŋ vɨhɨlɨ igu igu hɨsɨŋ agɨladɨ ma lɨlan uami. Viaŋ hulaŋ iamɨgali agɨlaŋ hula simɨ hɨnilan uami. Lɨdɨŋ iadɨ nukeŋ ibi ma mɨŋaiahɨlan uami. Viaŋ hameŋ lɨdalɨŋ naludɨ hɨji humɨgaŋ agɨlaŋ simɨ hɨniavɨdaci huaci hɨnilalaŋ uami. Namɨlaŋ iadɨ iga iga iadɨ lɨhu hɨvɨ hɨnihɨni iadɨ ciaŋ lubiahɨlɨlalaŋ uami. Hameŋ lɨdɨŋ kɨlɨ tɨbɨ sabaŋ bulɨmakau sabɨ hɨvɨ lama lɨbɨhahavɨci akuaba akuaba magɨlavɨlalɨ hameŋ agɨladɨ havɨlalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kɨlɨ tɨbɨ me naludɨ sabɨ lamɨlan agɨladɨ huaci havɨbalaŋ uami. Akuaba akuaba namɨlaŋ havahava saŋ igulan agɨlaŋ vɨhɨlɨ apalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mu tɨbɨ Isɨlaelɨ hɨdɨlɨ agɨladɨ alusɨsɨ mɨhiŋ hɨvɨ Jisasɨ agaŋ nudɨ hulemɨlɨ agɨlaŋ hula uavɨmi. Hɨbɨ pɨlɨ mu halɨha cahu uitɨ hualabɨla alɨhaŋ hɨniadami heŋ uavɨmi. Uavɨdaci nudɨ hulemɨlɨ agɨladɨ humɨgaŋ ibɨlɨci halɨha cahu uitɨ hɨlɨcɨ agɨladɨ likɨla likɨla navɨmi. ");
INSERT INTO ena_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Lɨhavɨdaci Falisi hɨdɨlɨ agɨlaŋ igavɨla Jisasɨ dɨ abavɨmi. Ci igɨnaŋ uavɨmi. Alaŋ alusɨsɨ mɨhiŋ hɨvɨ hameŋ ma lɨlalu uavɨmi. Nadɨ hulemɨlɨ agɨlaŋ akɨ saŋ hameŋ lɨhavi uavɨmi. Ha nɨbu hɨbuŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Lɨhavɨci Jisasɨ cɨhu nulɨdɨ abami. Mu tɨbɨ Devitɨ nudɨ hulemɨlɨ agɨlaŋ hula humɨgaŋ saŋ hɨmavɨmi uami. Lavɨla Devitɨ agaŋ Asɨ dɨ havɨlɨ ulaŋ caba heŋ umi uami. Uavɨla maci agɨladɨ vimi uami. Maci Asɨ saŋ sagalɨ iguavɨmi agɨladɨ vave haiabɨla lamavɨci hɨniavɨmi agɨladɨ vimi uami. Hulaŋ havɨ havɨ hɨsɨŋ agɨlaŋ maci agɨladɨ ma navɨhadami uami. Ha nɨbu hɨbuŋ uami. Asɨ saŋ sagalɨ igu igu hɨsɨŋ hulaŋ agɨlaŋ pam maci agɨladɨ navɨhadami uami. Agadɨ ala Devitɨ nɨbu nami uami. Navɨla nudɨ hulemɨlɨ agɨlasaŋ avi iguci navɨmi uami. Namɨlaŋ Devitɨ akuaba akuaba lɨmi agasaŋ ciaŋ Asɨ dɨ manasɨŋ hekɨlɨ hɨvɨ lɨbavɨci hɨnilalɨ agadɨ ma akua igɨlalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Asɨ saŋ sagalɨ igu igu hɨsɨŋ hulaŋ agɨlaŋ alusɨsɨ mɨhiŋ hɨvɨ Asɨ dɨ aŋam ulaŋ hekɨlɨ heŋ uu sibɨla vihavɨlalɨ uami. Lɨdɨŋ alusɨsɨ mɨhiŋ hɨsɨŋ ciaŋ vɨdɨvɨdɨŋ agadɨ lulalula sibɨla vihavɨlalɨ uami. Ciaŋ vɨdɨvɨdɨŋ Mosesɨ lɨbami agaŋ sagalɨ igu igu hɨsɨŋ hulaŋ agɨlaŋ sibɨla hameŋ agɨladɨ alusɨsɨ mɨhiŋ hɨvɨ avi vivi saŋ abami uami. Hameŋ sadaŋ nɨbɨlaŋ hugɨ apalɨ hɨniavɨlalɨ uami. Namɨlaŋ ciaŋ vɨdɨvɨdɨŋ Mosesɨ lɨbami agadɨ ma akua igɨlalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Hulaŋ mu neŋ hɨnilalɨ agaŋ Asɨ dɨ aŋam ulaŋ hekɨlɨ agadɨ lɨvala ibi hekɨlɨ daŋ hɨnilalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Asɨ agaŋ nameŋ abami uami. Viaŋ namɨlaŋ sagalɨ havɨ havɨ igulalaŋ agɨlasaŋ mavɨn ma hɨnilan aba abami uami. Viaŋ hulaŋ iamɨgali limu hɨhɨle agɨlaŋ hulaŋ iamɨgali limu hɨhɨle agɨlasaŋ mavɨn hɨnihɨni nulɨdɨ huaci lamalama agasaŋ pam mavɨn hɨnilan aba abami uami. Lavɨla Falisi hɨdɨlɨ agɨladɨ abami. Namɨlaŋ hameŋ lavɨla hulaŋ hugɨ apalɨ agɨlasaŋ vɨhɨlɨ igu igu saŋ mu ciaŋ mu ciaŋ ma abɨvalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Hulaŋ dɨ Ninaŋ agaŋ nɨbu Isɨlaelɨ hɨdɨlɨ agɨladɨ alusɨsɨ mɨhiŋ agadɨ manɨgali uami. ");
INSERT INTO ena_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","La Jisasɨ agaŋ hualabɨla agadɨ valavɨla ua Isɨlaelɨ hɨdɨlɨ agɨladɨ aŋam ulaŋ heŋ ivoumi. ");
INSERT INTO ena_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Hulaŋ mu nudɨ human limu husɨŋ husɨŋ lɨmi agaŋ heŋ ala hɨnimi. Hulaŋ hɨhɨle agɨlaŋ Jisasɨ dɨ ciaŋ hɨvɨ lamɨbalu aba Jisasɨ dɨ abitɨhavɨmi. Ciaŋ vɨdɨvɨdɨŋ Mosesɨ lɨbami agaŋ aludɨ alialaŋ aba abɨci alaŋ huaci alusɨsɨ mɨhiŋ hɨvɨ hulaŋ mu dɨ huaci lamavɨlu ua hɨma uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Lɨhavɨci Jisasɨ cɨhu nulɨdɨ abami. Naludɨ hulaŋ mu agaŋ sabaŋ sipsipɨ daŋ hɨnivi uami. Hɨnidaci nudɨ sabaŋ sipsipɨ agaŋ alusɨsɨ mɨhiŋ hɨvɨ hɨdavɨla haca hɨvɨ laguvila mɨguci uami. Ha sabaŋ sipsipɨ iaganu agaŋ alusɨsɨ mɨhiŋ heŋ ala sabaŋ sipsipɨ agadɨ mɨŋamagɨlɨci iahɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sabaŋ sipsipɨ agɨlaŋ ibi apalɨ uami. Hulaŋ iamɨgali agɨlaŋ ibi daŋ uami. Hameŋ sadaŋ alaŋ huaci alusɨsɨ mɨhiŋ hɨvɨ hulaŋ iamɨgali agɨladɨ ahɨliahuiahu huaci lamɨbalu uami. Ciaŋ vɨdɨvɨdɨŋ Mosesɨ lɨbami agaŋ aludɨ alialaŋ aba abɨci alaŋ sibɨla hameŋ agɨladɨ huaci vibalu uami. ");
INSERT INTO ena_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Lavɨla hulaŋ human husɨŋ husɨŋ lɨmi agadɨ abami. Nadɨ human husɨŋ husɨŋ lɨmi agadɨ sɨlɨvɨ lamɨha uami. Lɨci human agadɨ sɨlɨvɨ lamami. Sɨlɨvɨ lamɨci nudɨ human agaŋ huaci lavɨla nudɨ human limu agaŋ hɨniadami hameŋ hɨnimi. ");
INSERT INTO ena_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Lɨci Falisi hɨdɨlɨ agɨlaŋ aŋam ulaŋ agadɨ vala cɨhu haiabɨla ivave mɨgudɨba hɨnihɨni Jisasɨ dɨ ifɨhɨmuhɨmu saŋ abaigahɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Falisi hɨdɨlɨ agɨlaŋ Jisasɨ dɨ ifɨhɨmɨbalu aba lɨhavɨmi agadɨ Jisasɨ ci igami. Lavɨla haiabɨla agadɨ valavɨla umi. Udaci hulaŋ iamɨgali akape nɨbu hula uavɨmi. Uavɨdaci nulɨdɨ hɨmuhɨmu sɨkasɨkan agɨladɨ huaci lamami. ");
INSERT INTO ena_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Lavɨla nulɨdɨ huaci lamami agasaŋ hulaŋ hɨhɨle agɨladɨ abavɨmɨdɨ aba nulɨdɨ abamɨgɨlami. ");
INSERT INTO ena_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jisasɨ agaŋ Asɨ dɨ sibɨla hɨsɨŋ hulaŋ hɨnihɨni akuaba akuaba hameŋ lɨmi agɨlasaŋ ala vaka Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ Aisaia agaŋ abami. Asɨ agaŋ nudɨ sibɨla hɨsɨŋ hulaŋ agasaŋ nameŋ abami uami. ");
INSERT INTO ena_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nɨbu iadɨ sibɨla hɨsɨŋ hulaŋ aba abami uami. Viaŋ nukeŋ nudɨ lɨbɨmɨŋamin aba abami uami. La nusaŋ mavɨn hekɨlɨ hɨnihɨni hɨjɨŋalɨlan aba abami uami. Iadɨ Amɨŋ agaŋ nɨbu hula hɨnibali aba abami uami. Nɨbu hula hɨnidaci nameŋ abɨbali aba abami uami. Asɨ agaŋ hulaŋ iamɨgali hɨdɨlɨ mu mu agɨladɨ ciaŋ sɨhɨvia sɨbaŋ hihɨlɨbali aba abɨbali aba abami uami. ");
INSERT INTO ena_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nɨbu hulaŋ iamɨgali abacabɨlacabɨla vɨdɨvɨdɨŋ ula ula ma abɨbali aba abami uami. Hɨbɨ pɨlɨ caba caba ma lagulama ciaŋ abɨbali aba abami uami. ");
INSERT INTO ena_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nɨbu suhan pɨlɨ lɨfuhɨla hɨnilalɨ agadɨ sɨkasɨkan ma mɨŋalɨfɨci mɨgɨbali aba abami uami. Unɨ sɨhɨvia ma lɨhulalɨ agadɨ sɨkasɨkan ma ifɨhɨmɨbali aba abami uami. Nɨbu lɨdaci hulaŋ iamɨgali agɨlaŋ iga iga abavɨbali aba abami uami. Asɨ dɨ sibɨla hɨsɨŋ hulaŋ agaŋ akuaba akuaba ciaŋ sɨhɨvia sɨbaŋ hihɨlɨlalɨ aba abavɨbali aba abami uami. Hihɨla hihɨla via ua akuaba akuaba sɨbɨlɨ sɨbɨlɨ agɨladɨ sɨkasɨkan lɨvalɨbali aba abavɨbali aba abami uami. Lavɨla akuaba akuaba huaci sɨlɨvɨ laci agɨladɨ lɨbali aba abavɨbali aba abami uami. ");
INSERT INTO ena_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Hameŋ lɨdaci hulaŋ iamɨgali hɨdɨlɨ mu mu agɨlaŋ nusaŋ migɨla migɨla hɨniavɨbali aba abami uami. Nɨbu nulɨdɨ ahɨliahuiahu saŋ migɨla migɨla hɨniavɨbali aba abami uami. Lɨci Aisaia abami hameŋ laci ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sudɨ sɨbɨlɨ agaŋ hulaŋ mu agadɨ hɨvɨ hɨnidaci nudɨ sɨbɨsaŋ mumia hɨniadami. Nudɨ lamɨgaŋ agaŋ avi sɨbɨlɨ lavɨla hɨnidaci ma igasuladami. Lɨci Jisasɨ dɨ pɨŋ vavehavɨmi. Vavehavɨci Jisasɨ sudɨ sɨbɨlɨ agadɨ lahuci cɨhu igasulasula ciaŋ heŋ abami. ");
INSERT INTO ena_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Lɨci hulaŋ iamɨgali agɨlaŋ igavɨla i uavɨmi. Nana Devitɨ dɨ iamɨlɨnu akua uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lɨhavɨci Falisi hɨdɨlɨ agɨlaŋ igahɨlavɨla abavɨmi. Nɨbu Belɨsebulɨ dɨ vɨdɨvɨdɨŋ hɨvɨ sudɨ sɨbɨlɨ agɨladɨ lahulalɨ uavɨmi. Belɨsebulɨ nɨbu sudɨ sɨbɨlɨ agɨladɨ manɨgali uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Lɨhavɨci Jisasɨ nulɨdɨ hɨji agɨladɨ igavɨla nameŋ abami. Hulaŋ iamɨgali fɨli tɨbɨ pam hɨsɨŋ agɨlaŋ latɨhavɨla nɨbɨlaŋ masa masa sagaŋ lɨbavɨci fɨli tɨbɨ agaŋ sɨbɨlɨ lɨvi uami. Hulaŋ iamɨgali haiabɨla pam hɨsɨŋ agɨlaŋ latɨhavɨla sagaŋ lɨbavɨla hɨtɨŋ hɨtɨŋ lɨhavɨci haiabɨla agaŋ hulaŋ iamɨgali apalɨ hɨnivi uami. Hulaŋ iamɨgali ulaŋ pam hɨsɨŋ agɨlaŋ latɨhavɨla sagaŋ lɨbavɨla hɨtɨŋ hɨtɨŋ lɨhavɨci ulaŋ agaŋ hulaŋ iamɨgali apalɨ hɨnivi uami. ");
INSERT INTO ena_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satan agaŋ nudɨ hulemɨlɨ agɨladɨ lahuci cɨhu latɨhavɨla nɨbɨlaŋ nukeŋ nukeŋ sagaŋ lɨbavɨdaci Satan agaŋ akuaba akuaba agɨladɨ ma migɨlɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Belɨsebulɨ iasaŋ vɨdɨvɨdɨŋ igudaci sudɨ sɨbɨlɨ lahulan lɨci uami. Isɨlaelɨ hɨdɨlɨ naludɨ hulemɨlɨ agɨlasaŋ ani agaŋ vɨdɨvɨdɨŋ igudaci sudɨ sɨbɨlɨ agɨladɨ lahuavɨlalɨ uami. Naludɨ nukeŋ hulemɨlɨ agɨlaŋ abavɨbali uami. Namɨlaŋ analɨ nameŋ abɨlalaŋ aba abavɨbali uami. Belɨsebulɨ agaŋ Jisasɨ saŋ vɨdɨvɨdɨŋ igudaci sudɨ sɨbɨlɨ lahulalɨ aba abɨlalaŋ aba abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Asɨ dɨ Amɨŋ agaŋ iasaŋ vɨdɨvɨdɨŋ igudaci sudɨ sɨbɨlɨ agɨladɨ lahulan lɨci uami. Ha Asɨ hulaŋ iamɨgali likɨlɨci nudɨ lɨhu hɨvɨ hɨniavadi agadɨ ci igadalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Hulaŋ mu vɨdɨvɨdɨŋ hekɨlɨ daŋ agaŋ nudɨ ulaŋ agadɨ sɨhɨvia sɨbaŋ migɨlɨvi uami. Migɨlɨdaci hulaŋ mu agaŋ hulaŋ vɨdɨvɨdɨŋ hekɨlɨ daŋ agadɨ ulaŋ hɨvɨ akuaba akuaba viben aba ma ivouvi uami. Nɨbu uleŋ muji ivouben aba lɨmɨn viavɨla hulaŋ vɨdɨvɨdɨŋ hekɨlɨ daŋ agadɨ lɨbɨhahɨvi uami. Lɨbɨhahɨci hɨnidaci uleŋ muji heŋ huaci ivoua akuaba akuaba agɨladɨ vivi uami. ");
INSERT INTO ena_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Hulaŋ mu viaŋ hula hɨji humɨgaŋ pam ma hɨnilalɨ agaŋ iadɨ nagɨli lamɨlalɨ uami. Hulaŋ mu iadɨ ciaŋ agadɨ hulaŋ iamɨgali iadɨ pɨŋ veve saŋ ma lamalubilubi abɨlalɨ agaŋ uami. Nɨbu hulaŋ iamɨgali agɨladɨ lahulahu me lahudaci valavala uavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Hameŋ sadaŋ viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Hulaŋ iamɨgali akuaba akuaba lusɨŋ sɨbɨlɨ sɨbɨlɨ vivi Asɨ dɨ abacuvacuva ciaŋ abavɨci Asɨ nulɨdɨ hugɨ agɨladɨ hivɨbali uami. Agadɨ ala hulaŋ iamɨgali Asɨ dɨ Amɨŋ agadɨ abacuvacuva ciaŋ abavɨci uami. Asɨ nulɨdɨ hugɨ agɨladɨ ma hivɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Hulaŋ iamɨgali agɨlaŋ Hulaŋ dɨ Ninaŋ agadɨ ciaŋ sɨbɨlɨ abavɨci uami. Asɨ nulɨdɨ hugɨ agɨladɨ hivɨbali uami. Agadɨ ala Asɨ dɨ Amɨŋ agadɨ ciaŋ sɨbɨlɨ abavɨci uami. Asɨ nulɨdɨ hugɨ agɨladɨ ma hivɨbali uami. Nulɨdɨ hugɨ agɨlaŋ iabi avi mufɨli avi hameŋ laci hameŋ laci hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Lavɨla Jisasɨ cɨhu abami. Kɨlɨ huaci agaŋ amɨŋ huaci huaci agɨladɨ lamɨlalɨ uami. Kɨlɨ sɨbɨlɨ agaŋ amɨŋ sɨbɨlɨ sɨbɨlɨ agɨladɨ lamɨlalɨ uami. Hulaŋ iamɨgali agɨlaŋ kɨlɨ agɨladɨ amɨŋ agɨladɨ iga iga abavɨlalɨ uami. Ha kɨlɨ huaci aba abavɨlalɨ uami. Ha kɨlɨ sɨbɨlɨ aba abavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Hulaŋ namɨlaŋ lahu sɨhɨpɨŋ dɨ ninanadi uami. Namɨlaŋ sɨbɨlɨ sɨbaŋ sadaŋ ciaŋ huaci cɨki avi ma abɨlalaŋ uami. Hulaŋ iamɨgali akuaba me hɨji daŋ hɨniavɨlalɨ agɨlaŋ uami. Nɨbɨlaŋ hɨji lamavɨlalɨ hameŋ laci ala abavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Hulaŋ iamɨgali hɨji huaci daŋ agɨlaŋ akuaba akuaba sibɨla huaci huaci agɨladɨ vihavɨlalɨ uami. Hulaŋ iamɨgali hɨji sɨbɨlɨ daŋ agɨlaŋ akuaba akuaba lusɨŋ sɨbɨlɨ sɨbɨlɨ agɨladɨ vihavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","37","La abami. Viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Asɨ hulaŋ iamɨgali ciaŋ hɨvɨ lamalama saŋ mɨhiŋ lamami heŋ uami. Hulaŋ iamɨgali uavauava ciaŋ abavɨlalɨ agɨladɨ abitɨhɨbali uami. Abitɨhɨdaci akuaba akuaba uavauava ciaŋ abavɨlalɨ agɨladɨ sulavɨbali uami. Sulavɨdaci igahɨlahɨla nulɨdɨ lamalɨhɨlɨbali uami. Lɨdɨŋ hulaŋ huaci agadɨ abɨbali uami. Nama hulaŋ huaci aba abɨbali uami. Hulaŋ sɨbɨlɨ agadɨ abɨbali uami. Nama hulaŋ sɨbɨlɨ aba abɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agadɨ lamalubilubi hɨsɨŋ hulaŋ limu hɨhɨle agɨlaŋ hula Falisi hɨdɨlɨ limu hɨhɨle agɨlaŋ hula Jisasɨ dɨ abavɨmi. Iavaŋ uavɨmi. Alaŋ Asɨ dɨ vɨdɨvɨdɨŋ agadɨ iga iga saŋ lɨlalu uavɨmi. Akuaba sihɨ abalamɨnaŋ igavɨla abɨbalu uavɨmi. Amɨŋ ala aba abɨbalu uavɨmi. Nɨbu Asɨ dɨ sibɨla vilalɨ aba abɨbalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Lɨhavɨci Jisasɨ nulɨdɨ abami. Hulaŋ iamɨgali iabi neŋ hɨniavɨlalɨ agɨlaŋ sɨbɨlɨ sɨbaŋ hɨniavɨlalɨ uami. Nɨbɨlaŋ Asɨ hula hɨji humɨgaŋ pam ma hɨniavɨlalɨ uami. Lɨdɨŋ akuaba sihɨ agaŋ iahɨdaci iga iga saŋ pam lɨhavɨlalɨ uami. Agadɨ ala akuaba sihɨ ma igavɨbali uami. Jona nɨbu Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ uami. Nɨbu akuaba akuaba lɨmi agɨladɨ pam sulɨdalɨŋ igahɨlahɨla iasaŋ nameŋ abavɨbali uami. Amɨŋ ala aba abavɨbali uami. Asɨ nukeŋ nudɨ abɨci vemi aba abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona agaŋ hehɨlaŋ hekɨlɨ agadɨ humɨgaŋ ulaŋ muji hɨvɨ hɨnidaci hɨfɨlɨ ahica umi uami. Hulaŋ dɨ Ninaŋ agaŋ avi sudɨ fɨli haiabɨla heŋ hɨnidaci hɨfɨlɨ ahica ubali uami. ");
INSERT INTO ena_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mufɨli Asɨ agaŋ hulaŋ iamɨgali agɨladɨ ciaŋ hɨvɨ lamɨbali uami. Lɨci hadɨhu Ninive haiabɨla hɨsɨŋ hulaŋ iamɨgali agɨlaŋ haiabɨla iahaiaha hulaŋ iamɨgali iabi neŋ hɨniavɨlalɨ agɨladɨ lɨbɨmɨgumɨgu abavɨbali uami. Namɨlaŋ lusɨŋ sɨbɨlɨ vilalaŋ aba abavɨbali uami. Ninive haiabɨla hɨsɨŋ alaŋ Jona dɨ ciaŋ igahɨlavɨla lusɨŋ sɨbɨlɨ ci valamɨlu aba abavɨbali uami. Hulaŋ mu namɨlaŋ hula hɨnidi agaŋ nɨbu ibi daŋ sadaŋ Jona dɨ lɨvali aba abavɨbali uami. Agadɨ ala namɨlaŋ lusɨŋ sɨbɨlɨ ma valɨlalaŋ aba abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mufɨli Asɨ agaŋ hulaŋ iamɨgali agɨladɨ ciaŋ hɨvɨ lamɨbali uami. Hadɨhu iamɨgali mu manɨgali hɨnihɨni fɨli tɨbɨ ium kɨlikɨli agadɨ migɨladami agaŋ iahɨbali uami. Iahavɨla hulaŋ iamɨgali iabi neŋ hɨniavɨlalɨ agɨladɨ lɨbɨmɨgumɨgu nameŋ abɨbali uami. Namɨlaŋ lusɨŋ sɨbɨlɨ vilalaŋ aba abɨbali uami. Viaŋ ium kɨlikɨli hɨnia Jelusalem haiabɨla saŋ hɨbɨ hutesɨ vemin aba abɨbali uami. Hulaŋ hɨji hutesɨ daŋ Solomon agaŋ ciaŋ suladami agadɨ igahɨlɨben aba vemin aba abɨbali uami. Hulaŋ namɨlaŋ hula hɨnidi agadɨ hɨji hutesɨ agaŋ Solomon dɨ hɨji hutesɨ agadɨ lɨvali aba abɨbali uami. Agadɨ ala namɨlaŋ nudɨ ciaŋ igahɨlahɨla saŋ valɨlalaŋ aba abɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","Lavɨla Jisasɨ cɨhu abami. Sudɨ sɨbɨlɨ hulaŋ mu dɨ hɨvɨ hɨnivi agaŋ nudɨ valavɨla uvi uami. Uavɨla fɨli tɨbɨ avɨli apalɨ heŋ uvɨ suhɨla suhɨla hɨdɨvi uami. Abeŋ hɨnia alusɨben aba suhɨla suhɨla hɨdɨvi uami. Suhɨla suhɨla hɨdɨci hɨma lɨci hɨji lamavɨla abɨvi uami. Viaŋ ulaŋ vaka hɨnimin heŋ cɨhu ala ua igɨben aba abɨvi uami. Lavɨla ua igɨci ulaŋ agaŋ hulaŋ apalɨ hɨnivi uami. Sɨmum lulavɨla hajɨŋ lamavɨci huaci sɨbaŋ hɨnivi uami. ");
INSERT INTO ena_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Lɨci nɨbu uavɨla sudɨ sɨbɨlɨ vɨdɨvɨdɨŋ daŋ limu hɨhɨle agɨladɨ likɨla vavevi uami. Human limu fɨhala human limu ahica cɨjɨŋ agɨladɨ likɨla vave uleŋ muji heŋ ivouavɨla hɨniavɨvi uami. Vaka sudɨ sɨbɨlɨ pabiŋ sɨbaŋ hulaŋ agadɨ hɨvɨ hɨnivi sadaŋ nɨbu huaci tagɨlaŋ daŋ hɨnivi uami. Agadɨ ala husivɨ sudɨ sɨbɨlɨ akape agɨlaŋ hulaŋ agadɨ hɨvɨ hɨniavɨvi sadaŋ nɨbu sɨbɨlɨ sɨbaŋ hɨnivi uami. Hulaŋ iamɨgali iabi neŋ lusɨŋ sɨbɨlɨ sɨbɨlɨ vihavɨlalɨ agɨlaŋ hameŋ ala hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisasɨ agaŋ hulaŋ iamɨgali akape agɨlasaŋ ciaŋ sulasula hɨnidaci imahalinu agɨlaŋ iamɨnɨlu hula vehavɨmi. Nɨbu hula ciaŋ aba aba saŋ ve haiabɨla lagulama hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Lagulama hɨniavɨdaci hulaŋ mu agaŋ Jisasɨ dɨ abami. Nadɨ iamɨna hula imahalina agɨlaŋ hula vevɨla haiabɨla adan lagulama hɨniavadi uami. Nama hula ciaŋ abɨben aba ve hɨniavadi uami. ");
INSERT INTO ena_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Lɨci Jisasɨ agaŋ nudɨ abami. Ani agɨlaŋ iadɨ iamɨgagali hɨniavadi uami. Ani agɨlaŋ iadɨ imahali hɨniavadi uami. ");
INSERT INTO ena_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Lavɨla nudɨ hulemɨlɨ agɨladɨ abalamavɨla abami. Iadɨ iamɨgagali nanagaŋ uami. Iadɨ imahali nanagaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Hulaŋ iamɨgali iadɨ Iavaŋ iahua hɨvɨ hɨnilalɨ agadɨ hɨji lubiahɨlavɨlalɨ agɨlaŋ uami. Nɨbɨlaŋ pam iadɨ iamɨgagali me hɨniavɨlalɨ uami. Iadɨ imahali me hɨniavɨlalɨ uami. Iadɨ nanadi humɨgaŋ pam me hɨniavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Lavɨla uaiaŋ heŋ ala Jisasɨ agaŋ uleŋ muji vala haiabɨla ivavevɨla ua idu hekɨlɨ caba heŋ mɨgahɨnimi. ");
INSERT INTO ena_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mɨgahɨnidaci hulaŋ iamɨgali akape agɨlaŋ nudɨ pɨŋ vehavɨmi. Vehavɨdaci nɨbu hunɨga hɨvɨ mɨgua mɨgahɨnimi. Mɨgahɨnidaci hulaŋ iamɨgali agɨlaŋ avɨli caba heŋ lagulama hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Hɨniavɨdaci Jisasɨ agaŋ hɨve lamalama ciaŋ akape agɨladɨ sulasula abami. Ci igɨlaŋ uami. Hulaŋ mu halɨha cahu uitɨ hɨlɨcɨ havala havala saŋ hualabɨla uvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Uavɨla havala havala udaci halɨha cahu uitɨ hɨlɨcɨ hɨhɨle hɨbɨ pɨlɨ hɨvɨ mɨgalahɨlavɨvi uami. Mɨgalahɨlavɨdaci havaŋ agɨlaŋ veve na fɨhalavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Halɨha cahu uitɨ hɨlɨcɨ hɨhɨle fɨli lɨba daŋ heŋ mɨgalahɨlavɨvi uami. Fɨli sudɨme cɨki lɨba sabɨ hɨvɨ hɨnivi heŋ mɨgalahɨlavɨvi uami. Mɨgalahɨla iahavɨhehavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Agadɨ ala halɨha cahu uitɨ hɨdɨlɨ hɨdɨlɨ agɨlaŋ muji ma mɨguavɨvi uami. Hameŋ sadaŋ uaiaŋ agaŋ hɨlacabɨlɨdaci sɨkasɨkan haba hɨmavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Halɨha cahu uitɨ hɨlɨcɨ hɨhɨle agɨlaŋ lɨbulɨbu henaŋ henaŋ daŋ hɨniavɨvi heŋ mɨgalahɨlavɨvi uami. Mɨgalahɨlalahɨla iahavɨdaci lɨbulɨbu henaŋ henaŋ daŋ agɨlaŋ iahaiaha hafilɨbavɨdaci sɨbɨlɨ sɨbɨlɨ lɨhavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Halɨha cahu uitɨ hɨlɨcɨ hɨhɨle fɨli huaci hɨvɨ mɨgalahɨlavɨvi uami. Mɨgalahɨlavɨla iahaiaha hɨlɨcɨ akape lamavɨvi uami. Hɨhɨle 100 hameŋ lamavɨvi uami. Hɨhɨle 60 hameŋ lamavɨvi uami. Hɨhɨle 30 hameŋ lamavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Hulaŋ iamɨgali hɨji daŋ lɨci ciaŋ nagadɨ sɨhɨvia sɨbaŋ igahɨlavɨm uami. ");
INSERT INTO ena_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Lɨci Jisasɨ dɨ hulemɨlɨ agɨlaŋ nudɨ pɨŋ vevɨla abitɨhavɨmi. Nama akɨ saŋ hulaŋ iamɨgali agɨlasaŋ hɨve lamalama ciaŋ pam abɨlanaŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Lɨhavɨci Jisasɨ agaŋ nulɨdɨ abami. Viaŋ naludɨ abɨdalɨŋ Asɨ nalusaŋ hɨji igudaci ci igahɨlɨlalaŋ uami. Lɨdɨŋ Asɨ hulaŋ iamɨgali likɨlɨci nudɨ lɨhu hɨvɨ hɨniavɨbali agadɨ ciaŋ hɨdɨlɨ sɨvɨla hɨniadami agadɨ ci igahɨlɨlalaŋ uami. Agadɨ ala hulaŋ iamɨgali limu hɨhɨle agɨlasaŋ ciaŋ hɨdɨlɨ sɨhɨvia ma abɨlan uami. Asɨ nukeŋ iasaŋ hɨji igudaci viaŋ nulɨdɨ ma abɨlan uami. Nulɨdɨ hɨve lamalama ciaŋ pam abɨlan uami. ");
INSERT INTO ena_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Hulaŋ mu akuaba akuaba daŋ hɨnidaci Asɨ nusaŋ akuaba akuaba hɨhɨle agɨladɨ cɨhu igubali uami. Lɨci nɨbu akuaba akuaba akape sɨbaŋ daŋ hɨnibali uami. Hulaŋ mu akuaba akuaba apalɨ agaŋ nɨbu hɨji hɨvɨ nameŋ abɨbali uami. Viaŋ akuaba cɨki daŋ hɨnidin aba abɨbali uami. Hɨji hɨvɨ hameŋ abɨbali ala Asɨ agaŋ nudɨ akuaba cɨki agadɨ sɨkan vibali uami. ");
INSERT INTO ena_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Viaŋ nusaŋ ala nulɨdɨ hɨve lamalama ciaŋ abɨlan uami. Lɨdalɨŋ igasulavɨlalɨ agadɨ ala akuaba akuaba ma igavɨlalɨ uami. Ciaŋ igahɨlavɨlalɨ agadɨ ala nulɨdɨ hɨji ma tovelalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ Aisaia agaŋ nameŋ abami uami. Asɨ agaŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ nameŋ abi aba abami uami. Namɨlaŋ ciaŋ igahɨlɨlalaŋ agadɨ ala naludɨ hɨji ma tovelalɨ aba abi aba abami uami. Namɨlaŋ igasulɨlalaŋ agadɨ ala akuaba akuaba agɨladɨ ma igɨlalaŋ aba abi aba abami uami. La cɨhu Isɨlaelɨ hɨdɨlɨ agɨlasaŋ nameŋ avi abi aba abami uami. Hulaŋ iamɨgali agɨlaŋ iadɨ ciaŋ igahɨlahɨla saŋ ihɨlu lavavɨlalɨ aba abi aba abami uami. Lɨdɨŋ nulɨdɨ hɨji sɨmɨ agɨladɨ lɨbɨsɨjiavɨlalɨ aba abi aba abami uami. Nulɨdɨ lamɨgaŋ agɨladɨ avi mɨŋasɨjiavɨlalɨ aba abi aba abami uami. Nɨbɨlaŋ hameŋ ma lavɨla aba abi aba abami uami. Ha akuaba akuaba agɨladɨ iga iga ciaŋ avi igahɨlavɨvi aba abi aba abami uami. Lavɨla hɨji huaci viavɨla lusɨŋ sɨbɨlɨ sɨbɨlɨ agɨladɨ valavɨla iadɨ pɨŋ vehavɨvi aba abi aba abami uami. Vehavɨci nulɨdɨ huaci lamavin aba abi aba abami uami. Ciaŋ Aisaia Isɨlaelɨ hɨdɨlɨ agɨlasaŋ lɨbami agaŋ hameŋ laci ala lɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","La nudɨ hulemɨlɨ agɨladɨ abami. Viaŋ naludɨ amɨŋ abadin uami. Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ akape agɨlaŋ uami. Hulaŋ Asɨ dɨ ciaŋ sɨhɨvia lubiahɨlavɨhadami agɨlaŋ uami. Akuaba akuaba namɨlaŋ igɨlalaŋ hameŋ agɨladɨ igɨbalu aba lɨhavɨhadami uami. Agadɨ ala nɨbɨlaŋ ma igavɨhadami uami. Ciaŋ namɨlaŋ igahɨlɨlalaŋ hameŋ agɨladɨ igahɨlɨbalu aba lɨhavɨhadami uami. Agadɨ ala nɨbɨlaŋ ma igahɨlavɨhadami uami. Hameŋ sadaŋ namɨlaŋ akuaba akuaba agɨladɨ iga iga ciaŋ sɨhɨvia igahɨlɨlalaŋ agasaŋ hɨjɨŋalɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Lavɨla Jisasɨ cɨhu abami. Hulaŋ mu halɨha cahu uitɨ hɨlɨcɨ havalɨvi agasaŋ hɨve lama abin agadɨ hɨdɨlɨ nɨbu nameŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Halɨha cahu uitɨ hɨlɨcɨ hɨhɨle hɨbɨ pɨlɨ hɨvɨ mɨgalahɨlavɨvi hana uami. Ha hulaŋ iamɨgali Asɨ nulɨdɨ likɨlɨci nudɨ lɨhu hɨvɨ hɨnihɨni hɨsɨŋ ciaŋ igahɨlavɨvi agɨlaŋ me uami. Agadɨ ala nulɨdɨ hɨji ma tovevi agɨlaŋ me uami. Lɨci laguŋ agaŋ vevɨla ciaŋ nulɨdɨ hɨji hɨvɨ hɨnivi agadɨ mɨŋaihuihu lɨvi agaŋ me uami. ");
INSERT INTO ena_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Halɨha cahu uitɨ hɨlɨcɨ hɨhɨle fɨli lɨba daŋ hɨvɨ mɨgalahɨlalahɨla iahavɨdaci nulɨdɨ hɨdɨlɨ agɨlaŋ fɨli hɨvɨ sɨhɨvia ma mɨguavɨla hutesɨ ma hɨniavɨvi hana uami. Ha hulaŋ iamɨgali Asɨ dɨ ciaŋ igahɨlahɨla hɨjɨŋalavɨvi agɨlaŋ me uami. ");
INSERT INTO ena_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Agadɨ ala nɨbɨlaŋ Asɨ dɨ ciaŋ lubiahɨlavɨvi agasaŋ hulaŋ limu hɨhɨle agɨlaŋ nulɨdɨ sɨbɨlɨ lamalama vɨhɨlɨ iguavɨvi agɨlaŋ me uami. Lɨhavɨci nulɨdɨ hɨji vɨdɨvɨdɨŋ agɨladɨ sɨkasɨkan valavɨvi agɨlaŋ me uami. ");
INSERT INTO ena_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Halɨha cahu uitɨ hɨlɨcɨ lɨbulɨbu henaŋ henaŋ daŋ hɨniavɨvi heŋ mɨgalahɨlavɨdaci uami. Lɨbulɨbu agɨlaŋ iahaiaha hafilɨbavɨdaci halɨha cahu uitɨ agɨlaŋ iahaiaha hɨlɨcɨ sɨhɨvia ma lamavɨvi hana uami. Ha hulaŋ iamɨgali Asɨ dɨ ciaŋ igahɨlavɨvi agɨlaŋ me uami. Agadɨ ala cɨhu akuaba akuaba fɨli hɨsɨŋ agɨlasaŋ hɨji cuvɨlɨŋ cuvɨlɨŋ lamavɨvi agɨlaŋ me uami. Anɨm hɨlɨcɨ hekɨlɨ daŋ hɨnihɨni saŋ igahɨlavɨvi agɨlaŋ me uami. Lɨhavɨdaci nulɨdɨ hɨji agɨladɨ mɨŋaihuihu lɨhavɨvi agɨlaŋ me uami. Nulɨdɨ hɨji agɨladɨ mɨŋaihuihu lɨhavɨdaci Asɨ dɨ ciaŋ agadɨ ma lubiahɨlavɨvi agɨlaŋ me uami. ");
INSERT INTO ena_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Halɨha cahu uitɨ hɨlɨcɨ fɨli huaci hɨvɨ mɨgalahɨlavɨvi hana uami. Ha hulaŋ iamɨgali ciaŋ igahɨlavɨdaci nulɨdɨ hɨji tovedaci ciaŋ hɨdɨlɨ igavɨvi agɨlaŋ me uami. Lavɨla akuaba akuaba sibɨla huaci huaci vihavɨlalɨ agɨlaŋ halɨha cahu uitɨ hɨlɨcɨ lamavɨlalɨ agɨlaŋ me uami. Hɨhɨle 100 lamavɨlalɨ agɨlaŋ me uami. Hɨhɨle 60 lamavɨlalɨ agɨlaŋ me uami. Hɨhɨle 30 lamavɨlalɨ agɨlaŋ me uami. ");
INSERT INTO ena_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Asɨ hulaŋ iamɨgali likɨlɨci nudɨ lɨhu hɨvɨ hɨnihɨni agasaŋ Jisasɨ hɨve lama nameŋ abami. Hulaŋ mu nudɨ hualabɨla uavɨla halɨha cahu uitɨ hɨlɨcɨ huaci agɨladɨ havalɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","La vala ua hɨsɨvɨdaci hɨfɨlɨ hulaŋ mu nudɨ nagɨli lamɨvi agaŋ vevi uami. Vevɨla lɨbulɨbu sɨbɨlɨ agɨladɨ hɨlɨcɨ vivi halɨha cahu uitɨ hɨlɨcɨ alɨhaŋ alɨhaŋ heŋ havalɨvi uami. Havala fɨhalavɨla vala uvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Lɨci halɨha cahu uitɨ agɨlaŋ lɨbulɨbu sɨbɨlɨ agɨlaŋ hula iaha hekɨlɨ lavɨla hɨlɨcɨ lamavɨci heŋ sɨhɨvia igavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Lavɨla hualɨ sibɨla vivi hɨsɨŋ hulemɨlɨ agɨlaŋ hualɨ iaganu agadɨ abavɨvi uami. Manɨgali aba abavɨvi uami. Nama nadɨ hualabɨla heŋ halɨha cahu uitɨ hɨlɨcɨ laci havalahanaŋ aba abavɨvi uami. Agadɨ ala akɨ lɨci lɨbulɨbu sɨbɨlɨ agɨlaŋ halɨha cahu uitɨ agɨlaŋ hula iaha hekɨlɨ lɨhavalɨ aba abavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Lɨhavɨci nulɨdɨ abɨvi uami. Hulaŋ mu iadɨ nagɨli lamɨlalɨ agaŋ lɨbulɨbu sɨbɨlɨ agɨladɨ hɨlɨcɨ havalalɨ aba abɨvi uami. Lɨci hualɨ sibɨla vivi hɨsɨŋ hulemɨlɨ agɨlaŋ abavɨvi uami. Uavɨla lɨbulɨbu sɨbɨlɨ agɨladɨ hubɨlɨmɨli aba abavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Lɨhavɨci nulɨdɨ abɨvi uami. Eke aba abɨvi uami. Halɨha cahu uitɨ agɨlaŋ lɨbulɨbu sɨbɨlɨ agɨladɨ lɨkɨla lɨkɨla heŋ hɨniavi aba abɨvi uami. Hameŋ sadaŋ namɨlaŋ lɨbulɨbu sɨbɨlɨ agɨladɨ hubɨlɨdalaŋ halɨha cahu uitɨ agɨlaŋ avi hubɨla hubɨla iahaiaha haba hɨmavɨmɨdɨ aba abɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Hameŋ sadaŋ vana ahica hameŋ iaha hekɨlɨ lɨhavɨm aba abɨvi uami. Hekɨlɨ lavɨla halɨha cahu uitɨ agɨlaŋ mɨdɨ lɨhuavɨci hualɨ sibɨla vivi hɨsɨŋ naludɨ abɨben aba abɨvi uami. Lɨbulɨbu sɨbɨlɨ agɨladɨ hubɨla hubɨla avɨŋ hɨvɨ hɨlahɨla saŋ hubɨhahɨhalaŋ aba abɨben aba abɨvi uami. Lɨdɨŋ halɨha cahu uitɨ hɨlɨcɨ agɨladɨ vivi iadɨ sɨmɨŋ mɨgudɨbalɨba hɨsɨŋ ulaŋ agadɨ hɨvɨ lamɨhalaŋ aba abɨben aba abɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisasɨ agaŋ cɨhu hɨve lama abami. Asɨ hulaŋ iamɨgali likɨlɨci nudɨ lɨhu hɨvɨ hɨniavɨbali agaŋ nɨbu isabɨlaŋ masɨtetɨ hɨlɨcɨ me uami. Hulaŋ mu isabɨlaŋ masɨtetɨ hɨlɨcɨ agɨladɨ via uavɨla nudɨ hualabɨla hɨvɨ havalɨdaci mɨgavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Isabɨlaŋ mu mu agɨlaŋ hɨlɨcɨ hekɨlɨ hekɨlɨ lamavɨlalɨ uami. Nulɨdɨ hɨlɨcɨ sɨkasɨkan agɨlaŋ isabɨlaŋ masɨtetɨ agɨladɨ hɨlɨcɨ lɨvalavɨlalɨ uami. Isabɨlaŋ masɨtetɨ agɨladɨ hɨlɨcɨ nɨbɨlaŋ sudɨme cɨki cɨki sɨbaŋ uami. Agadɨ ala nulɨdɨ havalavɨdaci mɨgamɨga iahaiaha kɨlɨ cɨki cɨki me hɨniavɨvi uami. Hɨnihɨni isabɨlaŋ mu mu agɨladɨ lɨvalavɨvi uami. Lɨdɨŋ makaŋ makaŋ lamavɨdaci havaŋ agɨlaŋ veve nulɨdɨ makaŋ makaŋ heŋ ulaŋ hafiavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Lavɨla Jisasɨ agaŋ cɨhu tɨbɨ hɨve lama abami. Asɨ hulaŋ iamɨgali likɨlɨci nudɨ lɨhu hɨvɨ hɨniavɨbali agaŋ nɨbu maci huhɨla huhɨla hɨsɨŋ isɨ aba abavɨlalɨ agaŋ me uami. Iamɨgali mu agaŋ maci agadɨ hunaŋ mu hɨvɨ ahica pam tɨbɨ vivi hunaŋ mɨsɨn hekɨlɨ hɨvɨ mɨŋamɨjidaci mɨguvi uami. Lavɨla maci huhɨla huhɨla hɨsɨŋ isɨ aba abavɨlalɨ agadɨ sudɨme cɨki vivi uami. Viavɨla maci hunaŋ mɨsɨn hekɨlɨ hɨvɨ mɨŋamɨjici mɨguvi heŋ isɨ aba abavɨlalɨ agadɨ mɨŋamɨjici mɨguvi uami. La eŋalɨci maci agaŋ sɨkasɨkan huhɨlɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisasɨ hulaŋ iamɨgali agɨlasaŋ ciaŋ akape suladami. Agadɨ ala ciaŋ agɨladɨ hɨdɨlɨ haiabɨla lamalama ma suladami. Nɨbu hɨve lamalama ciaŋ pam suladami. ");
INSERT INTO ena_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jisasɨ hameŋ lɨhadami agasaŋ ala vaka Asɨ agaŋ nudɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ mu agasaŋ hɨji igudaci nameŋ abami. Asɨ agaŋ nameŋ abi uami. Viaŋ hɨdɨlɨ maha fɨli uaiaŋ susu akuaba akuaba lamamin hadɨhu ciaŋ nagɨladɨ sɨvɨlalɨbamin aba abi uami. Lɨlɨŋ hulaŋ iamɨgali agɨlaŋ ma igahɨlavɨhadami aba abi uami. Agadɨ ala malɨciŋ nalusaŋ hɨve lamalama ciaŋ sulɨdalɨŋ akuaba akuaba sɨvɨla hɨniavɨlalɨ agɨlaŋ haiabɨla iahavɨdaci igɨbalaŋ aba abi uami. Lɨci Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ abami hameŋ laci ala lɨmi. ");
INSERT INTO ena_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisasɨ hulaŋ iamɨgali agɨladɨ vala uleŋ muji ivoumi. Nudɨ hulemɨlɨ agɨlaŋ avi nɨbu hula ivouavɨla nudɨ abavɨmi. Lɨbulɨbu sɨbɨlɨ hualabɨla alɨhaŋ iahavɨvi agɨladɨ ciaŋ hɨdɨlɨ alusaŋ sulɨnaŋ igahɨlɨmɨli uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Lɨhavɨci Jisasɨ nulɨdɨ abami. Hulaŋ halɨha cahu uitɨ hɨlɨcɨ huaci havalɨvi ha Hulaŋ dɨ Ninaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Hualabɨla ha fɨli nagasaŋ abin uami. Halɨha cahu uitɨ hɨlɨcɨ huaci ha hulaŋ iamɨgali Asɨ likɨlɨci nudɨ lɨhu hɨvɨ hɨniavi agɨlasaŋ abin uami. Lɨbulɨbu sɨbɨlɨ ha laguŋ dɨ hulaŋ iamɨgali agɨlasaŋ abin uami. ");
INSERT INTO ena_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Hulaŋ nudɨ nagɨli lama lɨbulɨbu sɨbɨlɨ agɨladɨ hɨlɨcɨ hualabɨla heŋ havalɨvi ha laguŋ agasaŋ abin uami. Halɨha cahu uitɨ hɨlɨcɨ viavɨla sɨmɨŋ ulaŋ hɨvɨ lamalama hana uami. Ha fɨli uaiaŋ susu akuaba akuaba sɨkasɨkan haba sɨvɨlavɨbali agɨladɨ mɨhiŋ hekɨlɨ agasaŋ abin uami. Hualɨ sibɨla hɨsɨŋ hulaŋ ha Asɨ dɨ ciaŋ hali hɨsɨŋ agɨlasaŋ abin uami. ");
INSERT INTO ena_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Fɨli uaiaŋ susu akuaba akuaba sɨkasɨkan haba sɨvɨlavɨbali agɨladɨ mɨhiŋ hekɨlɨ heŋ uami. Hualɨ sibɨla hɨsɨŋ hulaŋ agɨlaŋ lɨbulɨbu sɨbɨlɨ sɨbɨlɨ agɨladɨ hubɨhahahaha avɨŋ hɨvɨ hɨlavɨlalɨ hameŋ lɨhavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Asɨ hulaŋ iamɨgali likɨlɨci nudɨ lɨhu hɨvɨ hɨniavɨdaci hulaŋ iamɨgali limu hɨhɨle agɨlaŋ nulɨdɨ hɨji vɨdɨvɨdɨŋ agɨladɨ mɨŋaihuihu lɨhavɨlalɨ uami. Mufɨli Hulaŋ dɨ Ninaŋ agaŋ nudɨ ciaŋ hali hɨsɨŋ agɨladɨ abɨci nulɨdɨ likɨlavɨbali uami. Hulaŋ iamɨgali ciaŋ vɨdɨvɨdɨŋ lulavɨlalɨ agɨladɨ avi likɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Likɨla likɨla avɨŋ hekɨlɨ hɨvɨ havalavɨbali uami. Havalavɨdaci mɨgumɨgu avɨŋ hekɨlɨ heŋ hɨnihɨni ilɨha ilɨha mɨka hɨkɨŋ laguavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mɨhiŋ heŋ ala hulaŋ iamɨgali Asɨ dɨ ciaŋ sɨhɨvia lubiahɨlavɨlalɨ agɨladɨ Iaganɨlu Asɨ agaŋ nulɨdɨ likɨlɨci nudɨ lɨhu hɨvɨ hɨniavɨbali uami. Hɨnihɨni uaiaŋ abɨlu me hɨniavɨbali uami. Hulaŋ iamɨgali hɨji daŋ lɨci ciaŋ nagadɨ sɨhɨvia sɨbaŋ igahɨlavɨm uami. ");
INSERT INTO ena_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Lavɨla Jisasɨ cɨhu hɨve lama abami. Asɨ hulaŋ iamɨgali likɨlɨci nudɨ lɨhu hɨvɨ hɨnihɨni agaŋ nɨbu anɨm hɨlɨcɨ hɨbɨn hɨbɨn me uami. Hulaŋ mu agaŋ anɨm hɨlɨcɨ hɨbɨn hɨbɨn agadɨ vakaci hualabɨla hɨvɨ haca mava hudɨci hɨnivi uami. Lɨci hulaŋ mu agaŋ hɨda igavɨla via ua hualabɨla heŋ laci ala fipɨ mu hɨvɨ haca mava hudɨvi uami. Lavɨla hualabɨla anɨm hɨlɨcɨ hɨbɨn hɨbɨn hɨnivi agadɨ lavɨben aba hɨjɨŋalaŋala nudɨ nukeŋ akuaba akuaba sɨkasɨkan agɨladɨ mutɨŋ hɨvɨ lamɨci lavavɨvi uami. Lavavɨci anɨm hɨlɨcɨ agɨladɨ viavɨla cɨhu hualabɨla anɨm hɨlɨcɨ hɨbɨn hɨbɨn daŋ agadɨ lavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Lavɨla Jisasɨ cɨhu hɨve lama abami. Asɨ hulaŋ iamɨgali likɨlɨci nudɨ lɨhu hɨvɨ hɨnihɨni agaŋ nɨbu malɨluŋ huaci sɨbaŋ me uami. Hulaŋ mu anɨm hɨlɨcɨ akuaba akuaba akape daŋ agaŋ malɨluŋ huaci huaci agɨladɨ suhɨla suhɨla hɨdɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Lavɨla malɨluŋ huaci sɨbaŋ agadɨ igɨvi uami. Igavɨla ua nudɨ nukeŋ akuaba akuaba sɨkasɨkan agɨladɨ mutɨŋ hɨvɨ lamɨvi uami. Lamɨci hulaŋ hɨhɨle lavavɨci anɨm hɨlɨcɨ agɨladɨ viavɨla malɨluŋ huaci sɨbaŋ agadɨ lavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Lavɨla Jisasɨ cɨhu hɨve lama abami. Asɨ hulaŋ iamɨgali likɨlɨci nudɨ lɨhu hɨvɨ hɨnihɨni agaŋ nɨbu mɨkɨdiŋ me uami. Mɨkɨdiŋ mu idu hekɨlɨ hɨvɨ lamavɨci hehɨlaŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ mɨŋɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","La mɨlɨci heŋ magɨlavɨci caba hɨvɨ vevi uami. Magɨlavɨci veci mɨgahɨnia hehɨlaŋ agɨladɨ vihavɨvi uami. Vivi hehɨlaŋ huaci huaci agɨladɨ hunaŋ mɨsɨn agɨladɨ hɨvɨ lamavɨvi uami. Sɨbɨlɨ sɨbɨlɨ agɨladɨ havalavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Fɨli uaiaŋ susu akuaba akuaba sɨkasɨkan haba sɨvɨlavɨbali agɨladɨ mɨhiŋ hekɨlɨ heŋ hameŋ ala lɨhavɨbali uami. Hulaŋ iamɨgali Asɨ dɨ ciaŋ sɨhɨvia lubiahɨlavɨlalɨ agɨlaŋ hula hulaŋ iamɨgali lusɨŋ sɨbɨlɨ sɨbɨlɨ vihavɨlalɨ agɨlaŋ hula pam hɨniavɨbali uami. Hɨniavɨdaci Asɨ dɨ ciaŋ hali hɨsɨŋ agɨlaŋ hulaŋ iamɨgali lusɨŋ sɨbɨlɨ sɨbɨlɨ vihavɨlalɨ agɨladɨ likɨlavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Likɨla likɨla avɨŋ hekɨlɨ hɨvɨ havalavɨbali uami. Havalavɨdaci mɨgumɨgu avɨŋ hekɨlɨ heŋ hɨnihɨni ilɨha ilɨha mɨka hɨkɨŋ laguavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Lavɨla nudɨ hulemɨlɨ agɨladɨ abitɨhami. Namɨlaŋ hɨve lamalama ciaŋ mu mu abin agɨladɨ hɨdɨlɨ igɨlaŋ ua hɨma uami. Lɨci abavɨmi. Alaŋ ciaŋ hɨdɨlɨ ci igalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Lɨhavɨci nulɨdɨ abami. Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agadɨ lamalubilubi hɨsɨŋ hulaŋ limu hɨhɨle agɨlaŋ uami. Asɨ hulaŋ iamɨgali likɨlɨci nudɨ lɨhu hɨvɨ hɨniavɨbali agadɨ ciaŋ igahɨlavɨlalɨ uami. Hameŋ sadaŋ nɨbɨlaŋ hulaŋ mu ulaŋ hekɨlɨ daŋ agaŋ me hɨniavɨlalɨ uami. Hulaŋ ulaŋ hekɨlɨ daŋ agaŋ nudɨ uleŋ muji ivouavɨla akuaba akuaba huaci huaci vaka hɨsɨŋ agɨladɨdaŋ iabi me hɨsɨŋ agɨladɨdaŋ vavevi uami. ");
INSERT INTO ena_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Jisasɨ agaŋ hɨve lamalama ciaŋ abɨci ci lɨci haiabɨla agadɨ valavɨla nudɨ hɨvɨ vemi. Vevɨla Isɨlaelɨ hɨdɨlɨ agɨladɨ aŋam ulaŋ heŋ ivoumi. Ivoua hulaŋ iamɨgali agɨlasaŋ Asɨ dɨ ciaŋ sulami. Sulɨdaci nudɨ ciaŋ agadɨ igahɨlahɨla i uavɨmi. Nɨbu hɨji hutesɨ agadɨ abeŋ hɨsɨŋ vilɨ uavɨmi. Nɨbu akɨ me lɨdɨŋ vɨdɨvɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ abalamɨlalɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Alaŋ nudɨ igɨlalu uavɨmi. Nɨbu ulaŋ sibɨla vivi hɨsɨŋ hulaŋ agadɨ ninaŋ uavɨmi. Nudɨ numɨgaŋ Malia uavɨmi. Nudɨ imahalinu agɨladɨ ibi nameŋ uavɨmi. Mu Jemɨsɨ uavɨmi. Mu Josepɨ uavɨmi. Mu Saimon uavɨmi. Mu Judasɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nudɨ nanadinu humɨgaŋ pam sɨkasɨkan agɨlaŋ avi alaŋ hula hɨniavɨlalɨ uavɨmi. Nɨbu akɨ lavɨla akuaba akuaba hameŋ agɨladɨ lɨlalɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Lavɨla Jisasɨ saŋ humɨgaŋ vɨhɨlɨ vihavɨci Jisasɨ nulɨdɨ abami. Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ agɨlaŋ nulɨdɨ nukeŋ haiabɨla hɨnihɨni ciaŋ sulavɨdaci nulɨdɨ hɨvɨ hɨsɨŋ agɨlaŋ nulɨdɨ ibi ma mɨŋaiahavɨlalɨ uami. Nulɨdɨ ulaŋ pam hɨsɨŋ agɨlaŋ avi nulɨdɨ ibi ma mɨŋaiahavɨlalɨ uami. Agadɨ ala mu haiabɨla mu haiabɨla hɨdahɨda sulavɨdaci haiabɨla heŋ hɨsɨŋ agɨlaŋ pam nulɨdɨ ibi mɨŋaiahavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Hulaŋ iamɨgali nudɨ hɨvɨ hɨsɨŋ agɨlaŋ nusaŋ hɨji vɨdɨvɨdɨŋ ma lamavɨmi. Hameŋ sadaŋ nulɨsaŋ vɨdɨvɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ ma abalamami. ");
INSERT INTO ena_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Hadɨhu heŋ manɨgali Helotɨ Galili fɨli tɨbɨ migɨladami agaŋ Jisasɨ akuaba akuaba lɨmi agɨladɨ ciaŋ hɨjɨ igahɨlami. ");
INSERT INTO ena_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Lavɨla nudɨ sibɨla hɨsɨŋ hulaŋ agɨladɨ abami. Hulaŋ hana Jon hulaŋ iamɨgali avɨli hɨvɨ mɨŋamɨgu mɨŋaiahaiaha hɨsɨŋ hulaŋ agaŋ uami. Nɨbu hɨmavɨla cɨhu hɨhi iahalɨ uami. Hameŋ sadaŋ nɨbu vɨdɨvɨdɨŋ mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ abalamɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Vaka Helotɨ agaŋ isanu Filipɨ dɨ abinu Helodiasɨ dɨ mɨŋahuha viavɨla sabimi. Lɨci Jon agaŋ Helotɨ dɨ lusɨŋ sɨbɨlɨ agadɨ igavɨla nudɨ abacabɨlavɨla abami. Nama ciaŋ vɨdɨvɨdɨŋ Mosesɨ lɨbami agadɨ lulavɨla isana dɨ abinu agadɨ sabihanaŋ uami. Lɨci Helotɨ agaŋ nudɨ sagaŋ hɨsɨŋ hulemɨlɨ agɨladɨ abɨci Jon dɨ mɨŋalɨva lɨmɨn vɨdɨvɨdɨŋ hɨvɨ hahavɨla via ua lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ lamavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hulaŋ iamɨgali agɨlaŋ Jon saŋ nameŋ abavɨhadami. Jon nɨbu Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ uavɨhadami. Hameŋ sadaŋ Helotɨ agaŋ Jon dɨ ifɨhɨmɨben aba lɨmi. Agadɨ ala hulaŋ iamɨgali agɨlasaŋ lɨdavɨla ma ifɨhɨmami. ");
INSERT INTO ena_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mu tɨbɨ Helotɨ agaŋ mɨhiŋ hekɨlɨ iamɨnu nudɨ huhɨlami agasaŋ igahɨlavɨla sɨmɨŋ hekɨlɨ hɨlanami. Lɨci hulaŋ iamɨgali hɨhɨle ve nɨbu hula sɨmɨŋ navɨmi. Navɨdaci Helodiasɨ dɨ nadi agaŋ nɨbɨlaŋ hɨniavɨmi heŋ sɨcisɨci hɨdami. Lɨci nadi agaŋ sɨcisɨci hɨdami agasaŋ Helotɨ hɨjɨŋalami. ");
INSERT INTO ena_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Lavɨla ciaŋ mɨguavɨla abami. Hɨvɨ hekɨlɨ uami. Nama iadɨ akuaba saŋ abitɨhɨnaŋ viaŋ nasaŋ iguben uami. ");
INSERT INTO ena_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Lɨci Helodiasɨ agaŋ nadinu saŋ hɨji mu igumi. Lɨci nudɨ nadinu agaŋ iamɨnu dɨ hɨji lubiahɨlavɨla Helotɨ dɨ abami. Malɨciŋ sɨbaŋ nadɨ sagaŋ hɨsɨŋ hulemɨlɨ mu agadɨ abɨnaŋ uavɨla Jon hulaŋ iamɨgali avɨli hɨvɨ mɨŋamɨgu mɨŋaiahaiaha hɨsɨŋ hulaŋ agadɨ sugɨtaŋ ihalaham uami. Ihalaha nudɨ hali agadɨ halɨha hɨbɨn hɨbɨn me hɨvɨ lamavɨla vave iasaŋ igum uami. ");
INSERT INTO ena_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Lɨci Helotɨ agaŋ ciaŋ agadɨ igahɨlavɨla ma hɨjɨŋalami. Agadɨ ala sɨmɨŋ hekɨlɨ nana hɨnihɨni ciaŋ mɨguavɨla abami agasaŋ igahɨlami. La sɨhumahɨlɨmagaŋ aba akuaba akuaba nadi agaŋ abami hameŋ lɨlɨ saŋ igahɨlami. Lavɨla hulaŋ mu agadɨ abɨci lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ umi. Uavɨla sagaŋ hɨsɨŋ hulemɨlɨ agadɨ abɨci Jon dɨ sugɨtaŋ ihalahami. ");
INSERT INTO ena_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ihalahavɨla nudɨ hali agadɨ halɨha hɨbɨn hɨbɨn me agadɨ hɨvɨ lamavɨla nadi agasaŋ vavemi. Vave iguci nɨbu cɨhu via ua iamɨnu saŋ igumi. ");
INSERT INTO ena_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Lɨci Jon dɨ hulemɨlɨ agɨlaŋ vevɨla nudɨ valɨ agadɨ via ua haca mava hudavɨmi. Lavɨla ua Jisasɨ dɨ abavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Lɨhavɨci Jisasɨ agaŋ Jon dɨ ifɨhɨmavɨmi agadɨ ciaŋ hɨjɨ igahɨlami. Lavɨla haiabɨla agadɨ valavɨla nudɨ hulemɨlɨ agɨlaŋ hula hunɨga hɨvɨ mɨguavɨla fipɨ hulaŋ apalɨ heŋ uavɨmi. Nɨbu nudɨ hulemɨlɨ agɨlaŋ hula hɨtɨŋ sɨbaŋ uavɨmi. Uavɨdaci hulaŋ iamɨgali agɨlaŋ Jisasɨ nudɨ hulemɨlɨ agɨlaŋ hula uavɨmi agadɨ ciaŋ hɨjɨ igahɨlavɨmi. Lavɨla nulɨdɨ haiabɨla hekɨlɨ hekɨlɨ agɨladɨ valavɨla nudɨ igɨbalu aba fɨli hɨbɨ hɨvɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Uavɨdaci hunɨga Jisasɨ nudɨ hulemɨlɨ hula vehavɨmi agaŋ ve caba itɨlamɨci hulaŋ iamɨgali akape agɨladɨ igami. La nulɨsaŋ mavɨn hekɨlɨ lamavɨla nulɨdɨ hulaŋ iamɨgali hɨmuhɨmu daŋ agɨladɨ huaci lamami. ");
INSERT INTO ena_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Lɨci uaiaŋ sijaŋ sijaŋ hɨlɨdaci nudɨ hulemɨlɨ agɨlaŋ vevɨla nudɨ abavɨmi. Ulaŋ haiabɨla apalɨ uavɨmi. Uaiaŋ amɨŋ ci mɨgua sɨvɨladi uavɨmi. Hameŋ sadaŋ hulaŋ iamɨgali agɨladɨ abɨnaŋ haiabɨla cɨki cɨki abeba abeba hɨniavadi heŋ uavɨm uavɨmi. Uu sɨmɨŋ lavalava navɨm uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Lɨhavɨci Jisasɨ nudɨ hulemɨlɨ agɨladɨ abami. Nɨbɨlaŋ uavɨmɨdɨ uami. Namɨlaŋ nukeŋ nulɨsaŋ sɨmɨŋ igunɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Lɨci nudɨ abavɨmi. Alaŋ sɨmɨŋ akape daŋ ma hɨnidalu uavɨmi. Maci luli human limu fɨhala agɨlaŋ pam hɨniavadi uavɨmi. Hehɨlaŋ culɨ culɨ ahica cɨki uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Lɨhavɨci nulɨdɨ abami. Maci luli agɨladɨdaŋ hehɨlaŋ agɨladɨdaŋ iasaŋ vavehalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Vavehavɨdaci Jisasɨ agaŋ hulaŋ iamɨgali agɨladɨ abɨci humɨsɨ sabɨ heŋ mɨgahɨniavɨmi. Mɨgahɨniavɨci Jisasɨ maci luli human limu fɨhala agɨladɨdaŋ hehɨlaŋ culɨ culɨ ahica agɨladɨdaŋ vimi. Viavɨla hɨvɨ igaiahua iga iga Asɨ dɨ nameŋ abami. Nama sɨmɨŋ nagɨladɨ huaci lamɨha uami. La maci luli agɨladɨdaŋ hehɨlaŋ agɨladɨdaŋ mɨŋa cɨkɨ cɨkɨ lavɨla nudɨ hulemɨlɨ agɨlasaŋ igumi. Lɨci nudɨ hulemɨlɨ agɨlaŋ hulaŋ iamɨgali sɨkasɨkan agɨlasaŋ iguavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Iguavɨci navɨmi. Navɨci humɨgaŋ ci lɨci maci luli cɨkaŋ cɨkaŋ agɨladɨ valavɨmi. Lavɨla sɨmɨŋ tɨbɨ tɨbɨ valavɨmi agɨladɨ mɨgudɨbavɨmi. Mɨgudɨbavɨla cinacina human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ agɨladɨ hɨvɨ hudavɨci cinacina agɨlaŋ mɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Hulaŋ sɨmɨŋ navɨmi agɨladɨ lugɨlavɨci ua 5,000 iahami. Agadɨ ala iamɨgali ninanadi agɨladɨ ma lugɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jisasɨ agaŋ nudɨ hulemɨlɨ agɨladɨ hali uu saŋ lɨbɨsɨlɨvasɨlɨva abami. Hunɨga hɨvɨ mɨguavɨla idu hekɨlɨ limu caba heŋ uhalaŋ uami. Namɨlaŋ hali udalaŋ viaŋ hulaŋ iamɨgali nagɨladɨ abɨlɨŋ nulɨdɨ hɨvɨ uavɨdaci viaŋ naludɨ sɨvɨ uben uami. Hameŋ abɨci nudɨ hulemɨlɨ agɨlaŋ hali uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Uavɨdaci nɨbu hulaŋ iamɨgali agɨladɨ abɨci uavɨdaci Asɨ dɨ abɨben aba halu iahumi. Iahuavɨla hɨnidaci uaiaŋ sijaŋ sijaŋ hɨlami. Lɨci nɨbu halu heŋ hɨtɨŋ hɨnidaci hɨfɨlɨ lɨmi. ");
INSERT INTO ena_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Lɨdaci nudɨ hulemɨlɨ hunɨga hɨvɨ mɨguavɨla uavɨmi agɨlaŋ idu hekɨlɨ agadɨ alɨhaŋ alɨhaŋ sɨbaŋ heŋ uavɨdaci huŋe vemi. Huŋe agaŋ hunɨga hali lama umi heŋ vemi. Vedaci avɨli agaŋ aibubuŋ ifu ifu hunɨga agadɨ ifɨnikɨlami. ");
INSERT INTO ena_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Lɨdaci fɨli amɨŋ mɨŋalahɨben aba lɨmi. Lɨdaci Jisasɨ agaŋ avɨli sabɨ hɨvɨ lagulagu ua nudɨ hulemɨlɨ hunɨga hɨvɨ hɨniavɨmi agɨladɨ hɨvɨ iahami. ");
INSERT INTO ena_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Lɨci nudɨ hulemɨlɨ agɨlaŋ nudɨ iga lɨdavɨla abavɨmi. Ha sudɨ uavɨmi. Lavɨla lɨdalɨda agalavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Lɨhavɨdaci Jisasɨ lɨhalɨha sɨbaŋ nulɨdɨ abami. Namɨlaŋ vɨdɨvɨdɨŋ hɨnihalaŋ uami. Lɨdɨmɨlaŋ uami. Nana viaŋ nukeŋ ala uami. ");
INSERT INTO ena_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Lɨci Pita agaŋ nudɨ abami. Iadɨ Hekɨlɨ uami. Ha nama nukeŋ lɨci iadɨ abɨnaŋ avɨli sabɨ hɨvɨ lagulagu nadɨ pɨŋ ulɨŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Lɨci Jisasɨ abami. Alia veha uami. Lɨci Pita hunɨga valavɨla avɨli sabɨ hɨvɨ lagulagu Jisasɨ dɨ pɨŋ umi. ");
INSERT INTO ena_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Uu huŋe hekɨlɨ agadɨ iga lɨdavɨla avɨli hɨvɨ sɨlɨhala mɨguben aba lɨmi. Lavɨla Jisasɨ dɨ ulavɨla abami. Iadɨ Hekɨlɨ uami. Iadɨ ahɨliahuha uami. ");
INSERT INTO ena_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Lɨci Jisasɨ lɨhalɨha sɨbaŋ human mɨŋa ua Pita dɨ mɨŋalɨvami. Lavɨla nudɨ abami. Nama hulaŋ hɨji vɨdɨvɨdɨŋ apalɨ me hɨnihɨni lɨdɨnaŋ uami. Nama hɨji cuvɨlɨŋ cuvɨlɨŋ lamɨmɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Lavɨla ahica hameŋ hunɨga hɨvɨ mɨguavɨci huŋe agaŋ heŋ valami. ");
INSERT INTO ena_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Lɨci nudɨ hulemɨlɨ hunɨga hɨvɨ hɨniavɨmi agɨlaŋ nudɨ ibi mɨŋaiahaiaha saŋ mɨgalɨfɨlɨbavɨla abavɨmi. Amɨŋ sɨbaŋ uavɨmi. Nama Asɨ dɨ Ninaŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hunɨga Jisasɨ nudɨ hulemɨlɨ hula uavɨmi agaŋ ua Genesaletɨ haiabɨla mikɨ heŋ itɨlamami. ");
INSERT INTO ena_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Lɨci hulaŋ heŋ hɨsɨŋ agɨlaŋ Jisasɨ dɨ igavɨla hɨji lamavɨmi. Na Jisasɨ ala uavɨmi. Lavɨla haiabɨla mu mu mikɨ heŋ hɨniavɨhadami agɨlasaŋ ciaŋ iguavɨci umi. Ciaŋ iguavɨci uci hulaŋ iamɨgali akape hɨmuhɨmu daŋ agɨladɨ vavehavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Vavevɨla hɨmuhɨmu daŋ agɨlaŋ Jisasɨ dɨ hadi hɨlahɨla hutesɨ agadɨ fɨdɨm heŋ mɨŋaigaiga saŋ nudɨ mavɨn ciaŋ ciaŋ abavɨmi. Abavɨci hulaŋ iamɨgali hɨmuhɨmu daŋ agɨlaŋ Jisasɨ dɨ hadi hɨlahɨla hutesɨ agadɨ fɨdɨm heŋ mɨŋaigaiga huaci lɨhavɨhadami. ");
INSERT INTO ena_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Falisi hɨdɨlɨ agɨlaŋ hula Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agadɨ lamalubilubi hɨsɨŋ hulaŋ agɨlaŋ hula Jelusalem haiabɨla vala Jisasɨ dɨ pɨŋ vehavɨmi. Vevɨla nudɨ abitɨhavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Nadɨ hulemɨlɨ agɨlaŋ akɨ saŋ aludɨ ave iauacaŋ agɨladɨ ciaŋ vɨdɨvɨdɨŋ agɨladɨ ma lubiahɨlavɨlalɨ uavɨmi. Nɨbɨlaŋ sɨmɨŋ nɨbalu aba human ma husavɨlalɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Lɨhavɨci Jisasɨ agaŋ nulɨdɨ abami. Namɨlaŋ akɨ saŋ naludɨ ave iauacaŋ agɨladɨ ciaŋ vɨdɨvɨdɨŋ agɨladɨ lubiahɨlahɨla Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agadɨ lulɨlalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Asɨ nameŋ abami uami. Namɨlaŋ naludɨ iamiagagalinalu agɨladɨ lɨhu hɨvɨ hɨnihɨni nulɨdɨ ciaŋ agɨladɨ lubiahɨlɨhalaŋ aba abami uami. Hulaŋ mu iamiaganu dɨ cilu lɨhuci namɨlaŋ nudɨ ifɨhɨmɨhalaŋ aba abami uami. ");
INSERT INTO ena_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Agadɨ ala namɨlaŋ nameŋ abɨlalaŋ uami. Hulaŋ mu anɨm hɨlɨcɨ akuaba akuaba daŋ hɨniavɨla iamiaganu saŋ iguben aba nulɨdɨ nameŋ abam aba abɨlalaŋ uami. Viaŋ anɨm hɨlɨcɨ akuaba akuaba nagɨladɨ Asɨ saŋ sagalɨ igu igu saŋ ci lɨbɨmɨŋacin aba abam aba abɨlalaŋ uami. Hameŋ sadaŋ viaŋ naludɨ ahɨliahua nalusaŋ akuaba akuaba igu igu agaŋ apalɨ aba abam aba abɨlalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Hulaŋ hameŋ agaŋ nudɨ iamiaganu dɨ lɨhu hɨvɨ hɨnihɨni nulɨdɨ ciaŋ ma lubiahɨlɨlalɨ uami. Namɨlaŋ hameŋ lɨdɨŋ Asɨ dɨ ciaŋ agadɨ lulalula ave iauacagalinalu agɨladɨ ciaŋ pam lubiahɨlalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Namɨlaŋ nalusaŋ nukeŋ analɨ hɨji nameŋ lamalama abɨlalaŋ uami. Alaŋ hulaŋ huaci aba abɨlalaŋ uami. Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ Aisaia agaŋ akuaba akuaba lɨlalaŋ hameŋ agɨlasaŋ ala nameŋ abami uami. ");
INSERT INTO ena_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Asɨ agaŋ nameŋ abi aba abami uami. Hulaŋ iamɨgali agɨlaŋ sɨbɨsaŋ hɨvɨ pam iadɨ ibi mɨŋaiahavɨlalɨ aba abi aba abami uami. Agadɨ ala nulɨdɨ hɨji humɨgaŋ agɨlaŋ viaŋ hula ma sɨbaŋ hɨniavɨlalɨ aba abi aba abami uami. ");
INSERT INTO ena_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Lɨhavɨdaci analɨ havɨ havɨ sɨhɨ iahaiaha iadɨ ibi mɨŋaiahavɨlalɨ aba abi aba abami uami. Lɨdɨŋ hulaŋ agɨladɨ ciaŋ vɨdɨvɨdɨŋ agɨladɨ sulasula nameŋ abavɨlalɨ aba abi aba abami uami. Na Asɨ dɨ ciaŋ suladalu aba abavɨlalɨ aba abi aba abami uami. ");
INSERT INTO ena_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisasɨ agaŋ hulaŋ iamɨgali agɨladɨ abɨci vehavɨci nulɨdɨ abami. Namɨlaŋ ciaŋ nagadɨ igahɨlavɨla sɨhɨvia sɨbaŋ hɨji lamɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Asɨ igɨdaci hulaŋ iamɨgali sɨmɨŋ akuaba akuaba vivi navɨlalɨ agasaŋ nɨbɨlaŋ hugɨ daŋ ma hɨniavɨlalɨ uami. Agadɨ ala Asɨ igɨdaci akuaba akuaba ciaŋ sɨbɨlɨ sɨbɨlɨ abavɨlalɨ agasaŋ nɨbɨlaŋ hugɨ daŋ hɨniavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Lɨci Jisasɨ dɨ hulemɨlɨ agɨlaŋ ve nudɨ abavɨmi. Falisi hɨdɨlɨ agɨlaŋ nadɨ ciaŋ agadɨ igahɨlavɨla nasaŋ humɨgaŋ vɨhɨlɨ vihavi agadɨ ci akua igɨnaŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Lɨhavɨci Jisasɨ agaŋ nulɨdɨ hɨve lama abami. Iadɨ Iavaŋ iahua hɨvɨ hɨnilalɨ agaŋ nɨbu hualabɨla daŋ uami. Akuaba akuaba nudɨ nukeŋ human hɨvɨ ma hulimaŋ agɨladɨ uami. Nɨbu huaci sɨkasɨkan hɨdɨlɨ daŋ hubɨlɨdaci iahavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nɨbɨlaŋ akuaba akuaba lɨhavɨlalɨ agɨlasaŋ hɨji cuvɨlɨŋ cuvɨlɨŋ lamɨmɨlaŋ uami. Nɨbɨlaŋ hulaŋ lamɨgaŋ sɨbɨlɨ mu agaŋ lamɨgaŋ sɨbɨlɨ sɨbɨlɨ hɨhɨle agɨlasaŋ hɨbɨ abalamɨben aba lɨlalɨ agaŋ me uami. Hulaŋ lamɨgaŋ sɨbɨlɨ mu agaŋ hulaŋ lamɨgaŋ sɨbɨlɨ mu agasaŋ hɨbɨ abalamɨben aba lavɨla uami. Ha ahica hameŋ haca hɨvɨ lalɨfa mɨguavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Lɨci Pita agaŋ Jisasɨ dɨ abami. Nama hulaŋ iamɨgali agɨlasaŋ hɨve lamalama ciaŋ abɨnaŋ agadɨ alusaŋ ciaŋ hɨdɨlɨ abɨnaŋ igahɨlɨmɨli uami. ");
INSERT INTO ena_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Lɨci Jisasɨ abami. Namɨlaŋ hɨji apalɨ akua uami. Hameŋ sadaŋ naludɨ hɨji agɨlaŋ ma tovelalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Akuaba akuaba sɨmɨŋ navɨlalɨ agɨlaŋ humɨgaŋ hɨvɨ hɨnihɨni su ulaŋ hɨvɨ uavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Agadɨ ala Asɨ igɨdaci hulaŋ iamɨgali hɨji hɨvɨ igahɨlahɨla akuaba akuaba ciaŋ sɨbɨlɨ sɨbɨlɨ abavɨlalɨ agɨlaŋ hugɨ daŋ hɨniavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Akuaba akuaba hɨji hɨvɨ iahavɨlalɨ agɨlaŋ nameŋ uami. Hɨji sɨbɨlɨ sɨbɨlɨ agɨlaŋ uami. Hulaŋ mu dɨ ifɨhɨmuhɨmu hɨji agaŋ uami. Hulaŋ iamɨgali daŋ agaŋ abinu dɨ valavala iamɨgali mu mu sɨgɨlɨ vivi hɨji agaŋ uami. Iamɨgali hulaŋ daŋ agaŋ muŋanu dɨ valavala hulaŋ mu mu sɨgɨlɨ vivi hɨji agaŋ uami. Hɨvɨkalɨ saŋ hɨdahɨda hɨji agaŋ uami. Akuaba akuaba sɨgɨlɨ vivi hɨji agaŋ uami. Hulaŋ mu dɨ analɨ abavɨla ciaŋ hɨvɨ lamalama hɨji agaŋ uami. Hulaŋ hɨhɨle agɨladɨ abacuvacuva hɨji agaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Asɨ igɨdaci hulaŋ iamɨgali akuaba akuaba hameŋ lɨhavɨlalɨ agɨlaŋ hugɨ daŋ hɨniavɨlalɨ uami. Asɨ igɨdaci hulaŋ human ma husahusa sɨmɨŋ navɨlalɨ agɨlaŋ hugɨ daŋ ma hɨniavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Lavɨla Jisasɨ agaŋ haiabɨla agadɨ valavɨla cɨhu haiabɨla hɨhɨle Tailɨ haiabɨla Saidon haiabɨla agɨladɨ fɨli tɨbɨ hɨniavɨhadami heŋ umi. ");
INSERT INTO ena_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Lɨci Kenan hɨdɨlɨ iamɨgali mu heŋ hɨniadami agaŋ vevɨla Jisasɨ dɨ ula ula abami. Iadɨ Hekɨlɨ uami. Nama Devitɨ dɨ iamɨlɨnu uami. Iasaŋ mavɨn hɨniha uami. Sudɨ sɨbɨlɨ agaŋ iadɨ nadi agadɨ sɨbɨlɨ lamɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Lɨci Jisasɨ nudɨ akuaba ciaŋ cɨki avi ma abami. Lɨci Jisasɨ dɨ hulemɨlɨ agɨlaŋ nudɨ pɨŋ vevɨla abavɨmi. Iamɨgali agaŋ ula ula aludɨ sɨvɨ vedi uavɨmi. Nama nudɨ abɨnaŋ cɨhu um uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Lɨhavɨci Jisasɨ nulɨdɨ abami. Isɨlaelɨ hɨdɨlɨ agɨlaŋ sabaŋ sipsipɨ abeba abeba uu haba sɨvɨla sɨvɨla hɨdavɨlalɨ hameŋ hɨniavɨlalɨ uami. Hɨniavɨdaci nulɨdɨ ahɨliahuiahu saŋ Asɨ iadɨ abɨci vemin uami. ");
INSERT INTO ena_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Hameŋ abɨci iamɨgali agaŋ nudɨ pɨŋ vemi. Vevɨla mavɨn ciaŋ ciaŋ aba aba saŋ mɨgalɨfɨlɨbavɨla abami. Iadɨ Hekɨlɨ uami. Iadɨ ahɨliahuha uami. ");
INSERT INTO ena_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Lɨci Jisasɨ hɨve lama nudɨ abami. Alaŋ ninanadi agɨladɨ sɨmɨŋ vivi iŋam agɨlasaŋ ma igunɨlalu uami. ");
INSERT INTO ena_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Lɨci iamɨgali agaŋ hɨji nameŋ lamami. Ninanadi saŋ abi ha Isɨlaelɨ hɨdɨlɨ agɨlasaŋ hɨve lama abi uami. Iŋam saŋ abi ha hɨdɨlɨ mu mu alusaŋ hɨve lama abi uami. Hɨji hameŋ lamavɨla abami. Iadɨ Hekɨlɨ uami. Ha amɨŋ ala abɨnaŋ uami. Agadɨ ala iŋam nɨbɨlaŋ iamiagagalinɨlu dɨ vadɨm lɨhu hɨvɨ hɨdahɨda sɨmɨŋ suvɨli suvɨli mɨgalahɨlavɨlalɨ agɨladɨ navɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Lɨci Jisasɨ iamɨgali agadɨ abami. Nadɨ hɨji vɨdɨvɨdɨŋ agaŋ hekɨlɨ sɨbaŋ uami. Hameŋ sadaŋ akuaba akuaba nadɨ hɨvɨ iahaiaha saŋ abɨnaŋ agaŋ vana iaham uami. Lɨci hadɨhu laci ala sudɨ sɨbɨlɨ agaŋ nadi agadɨ vala uci cɨhu huaci lɨmi. ");
INSERT INTO ena_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","La Jisasɨ agaŋ haiabɨla agadɨ vala Galili idu hekɨlɨ agadɨ caba heŋ umi. Uavɨla iahua halu hɨvɨ mɨgahɨnimi. ");
INSERT INTO ena_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mɨgahɨnidaci hulaŋ iamɨgali akape sɨbaŋ agɨlaŋ nudɨ pɨŋ vehavɨmi. Hulaŋ iamɨgali hɨmuhɨmu mu hɨdɨlɨ mu hɨdɨlɨ daŋ agɨladɨ vavehavɨmi. Hɨhɨle hɨcɨ sɨbɨlɨ sɨbɨlɨ agɨladɨ vavehavɨmi. Hɨhɨle lamɨgaŋ sɨbɨlɨ sɨbɨlɨ agɨladɨ vavehavɨmi. Hɨhɨle hɨcɨ human lidɨŋ lidɨŋ daŋ agɨladɨ vavehavɨmi. Hɨhɨle sɨbɨsaŋ mumimumi agɨladɨ vavehavɨmi. Akuaba akuaba hɨmuhɨmu mu hɨdɨlɨ mu hɨdɨlɨ daŋ agɨladɨ avi vavevave Jisasɨ dɨ hɨcɨ pɨŋ lamavɨmi. Lɨhavɨdaci hɨmuhɨmu daŋ agɨladɨ huaci lamami. ");
INSERT INTO ena_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Huaci lamɨdaci sɨbɨsaŋ mumimumi agɨlaŋ cɨhu ciaŋ abavɨmi. Hɨcɨ human lidɨŋ lidɨŋ daŋ agɨlaŋ cɨhu huaci lɨhavɨmi. Hɨcɨ sɨbɨlɨ sɨbɨlɨ agɨlaŋ cɨhu hɨdavɨmi. Lamɨgaŋ sɨbɨlɨ sɨbɨlɨ agɨlaŋ cɨhu igasulavɨmi. Lɨhavɨdaci hulaŋ iamɨgali limu hɨhɨle agɨlaŋ iga iga i uavɨmi. Lavɨla Asɨ dɨ ibi mɨŋaiahavɨmi. Asɨ nɨbu Isɨlaelɨ hɨdɨlɨ agɨladɨ Asɨ. ");
INSERT INTO ena_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Lavɨla Jisasɨ nudɨ hulemɨlɨ agɨladɨ abɨci vehavɨci nulɨdɨ abami. Viaŋ hulaŋ iamɨgali nagɨlasaŋ mavɨn hekɨlɨ lamadin uami. Nɨbɨlaŋ anihuliŋ vehavalɨ sadaŋ sɨmɨŋ apalɨ sɨbaŋ hɨniavadi uami. Nɨbɨlaŋ havɨ humɨgaŋ sɨbaŋ hɨniavɨdaci ma abɨlɨŋ uavɨbali uami. Sɨmɨŋ saŋ hɨmahɨma uavɨdaci hɨbɨ cina lamɨgaŋ hɨvɨhɨvɨ iloudaci lalɨfavɨmɨdɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Lɨci nudɨ hulemɨlɨ agɨlaŋ nudɨ abavɨmi. Neŋ ulaŋ haiabɨla apalɨ uavɨmi. Alaŋ maci luli akape abeŋ hɨsɨŋ viavɨla hulaŋ iamɨgali akape nagɨlasaŋ igunɨbalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Lɨhavɨci Jisasɨ agaŋ nulɨdɨ abitɨhami. Maci luli vameŋ hɨniavi uami. Lɨci abavɨmi. Maci luli human limu fɨhala human limu ahica cɨjɨŋ agɨlaŋ hɨniavi uavɨmi. Hehɨlaŋ cɨki cɨki pabiŋ pabiŋ agɨlaŋ avi hɨniavi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Lɨhavɨci Jisasɨ hulaŋ iamɨgali agɨladɨ abɨci fɨli hɨvɨ mɨgahɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","37","Mɨgahɨniavɨdaci Jisasɨ maci luli human limu fɨhala human limu ahica cɨjɨŋ agɨladɨdaŋ hehɨlaŋ pabiŋ pabiŋ agɨladɨdaŋ viavɨla Asɨ dɨ huaci uami. La mɨŋa cɨkɨ cɨkɨ lavɨla nudɨ hulemɨlɨ agɨlasaŋ iguci hulaŋ iamɨgali agɨlasaŋ iguavɨdaci navɨmi. Navɨci humɨgaŋ ci lɨci sɨmɨŋ limu tɨbɨ valavɨmi. Lavɨla cinacina hekɨlɨ hekɨlɨ human limu fɨhala human limu ahica cɨjɨŋ agɨladɨ hɨvɨ hudavɨci mɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Hulaŋ sɨmɨŋ navɨmi agɨladɨ lugɨlavɨci ua 4,000 iahami. Iamɨgali ninanadi agɨladɨ ma lugɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Lɨhavɨci Jisasɨ agaŋ hulaŋ iamɨgali agɨladɨ abɨci uavɨmi. Uavɨdaci nɨbu hunɨga hɨvɨ mɨguavɨla fɨli tɨbɨ mu Magadan haiabɨla mikɨ hɨniadami heŋ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Falisi hɨdɨlɨ agɨlaŋ hula Sadiusi hɨdɨlɨ agɨlaŋ hula Jisasɨ dɨ vɨdɨvɨdɨŋ agadɨ igɨbalu aba lɨhavɨmi. Lavɨla nudɨ ilasɨsɨ saŋ nudɨ mikɨ pɨŋ uavɨla abavɨmi. Asɨ agaŋ nasaŋ vɨdɨvɨdɨŋ igudaci nama akuaba sihɨ abalamɨnaŋ igavɨla abɨbalu uavɨmi. Amɨŋ ala aba abɨbalu uavɨmi. Nɨbu Asɨ dɨ sibɨla vilalɨ aba abɨbalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Lɨhavɨci nulɨdɨ abami. Hɨfɨlɨdaŋ uaiaŋ mɨdɨ lɨhuavɨla mɨgudaci iga iga abɨlalaŋ uami. Uaiaŋ mɨdɨ lɨhuadi aba abɨlalaŋ uami. Amɨli uaiaŋ hɨnibali aba abɨlalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Cimɨdaŋ hɨvɨ avɨli susu agaŋ cɨbɨŋ hɨmɨdaci uaiaŋ susu agaŋ mɨdɨ lɨhudaci iga iga abɨlalaŋ uami. Iabi avɨli huŋe sagaŋ vebali aba abɨlalaŋ uami. Namɨlaŋ akuaba akuaba sihɨ hameŋ agɨladɨ iga iga sɨhɨvia sɨbaŋ lamalɨhɨlɨlalaŋ uami. Agadɨ ala namɨlaŋ akuaba akuaba iabi neŋ iahavadi agɨladɨ sɨhɨvia ma lamalɨhɨlɨlalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Hulaŋ iamɨgali iabi neŋ hɨniavɨlalɨ agɨlaŋ sɨbɨlɨ sɨbaŋ hɨniavɨlalɨ uami. Nɨbɨlaŋ Asɨ hula hɨji humɨgaŋ pam ma hɨniavɨlalɨ uami. Lɨdɨŋ akuaba sihɨ agaŋ iahɨdaci iga iga saŋ pam lɨhavɨlalɨ uami. Agadɨ ala akuaba sihɨ ma igavɨbali uami. Jona nɨbu Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ uami. Nɨbu akuaba akuaba lɨmi agɨladɨ pam sulɨdalɨŋ igahɨlahɨla abavɨbali uami. Amɨŋ ala aba abavɨbali uami. Asɨ nukeŋ nudɨ abɨci vemi aba abavɨbali uami. Lavɨla Jisasɨ nulɨdɨ vala umi. ");
INSERT INTO ena_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisasɨ nudɨ hulemɨlɨ agɨlaŋ hula idu hekɨlɨ agadɨ limu caba heŋ ivouavɨmi. Nudɨ hulemɨlɨ agɨlaŋ uava iahuavɨla maci luli nɨbɨlaŋ nana hɨsɨŋ agɨladɨ ma via uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ua iahuavɨla Jisasɨ agaŋ hɨve lama nudɨ hulemɨlɨ agɨladɨ abami. Namɨlaŋ Falisi hɨdɨlɨ agɨladɨ maci huhɨla huhɨla hɨsɨŋ isɨ aba abavɨlalɨ agɨlasaŋ sɨhɨvia sɨbaŋ migɨlɨhalaŋ uami. Sadiusi hɨdɨlɨ agɨladɨ maci huhɨla huhɨla hɨsɨŋ isɨ aba abavɨlalɨ agɨlasaŋ avi sɨhɨvia sɨbaŋ migɨlɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Lɨci nudɨ hulemɨlɨ agɨlaŋ nɨbɨlaŋ nukeŋ nukeŋ abavɨmi. Alaŋ maci luli nana hɨsɨŋ ma vavelu agasaŋ akua igahɨlavɨla abi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Lɨhavɨci Jisasɨ agaŋ nulɨdɨ ciaŋ agɨladɨ igahɨlavɨla nulɨdɨ abami. Namɨlaŋ hulaŋ hɨji vɨdɨvɨdɨŋ apalɨ me hɨnihɨni hɨji cuvɨlɨŋ cuvɨlɨŋ lamɨlalaŋ uami. Namɨlaŋ maci luli nana hɨsɨŋ apalɨ agasaŋ hɨji cuvɨlɨŋ cuvɨlɨŋ lamɨmɨlaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Naludɨ hɨji agɨlaŋ sɨhɨvia sɨbaŋ toveci igahɨlɨhalaŋ uami. Maci luli human limu fɨhala agɨladɨ hulaŋ 5,000 hameŋ agɨlaŋ navalɨ agasaŋ igahɨlɨhalaŋ uami. Navɨci ci lɨci sɨmɨŋ limu tɨbɨ cinacina vameba agɨladɨ hɨvɨ hudahalaŋ agasaŋ igahɨlɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mu ha hulaŋ 4,000 hameŋ agɨlaŋ maci luli human limu fɨhala human limu ahica cɨjɨŋ agɨladɨ navalɨ agasaŋ igahɨlɨhalaŋ uami. Navɨci ci lɨci cinacina hekɨlɨ hekɨlɨ vameba agɨladɨ hɨvɨ hudahalaŋ agasaŋ igahɨlɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Naludɨ hɨji agɨlaŋ sɨhɨvia sɨbaŋ tovedaci igahɨlɨhalaŋ uami. Viaŋ maci luli nana hɨsɨŋ agasaŋ igahɨlavɨla ma abadin uami. Namɨlaŋ Falisi hɨdɨlɨ agɨladɨ maci huhɨla huhɨla hɨsɨŋ isɨ aba abavɨlalɨ agasaŋ sɨhɨvia sɨbaŋ migɨla migɨla saŋ abadin uami. Sadiusi hɨdɨlɨ agɨladɨ maci huhɨla huhɨla hɨsɨŋ isɨ aba abavɨlalɨ agasaŋ avi sɨhɨvia sɨbaŋ migɨla migɨla saŋ abadin uami. ");
INSERT INTO ena_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Lɨci nulɨdɨ hɨji toveci abavɨmi. Maci huhɨla huhɨla hɨsɨŋ isɨ aba abavɨlalɨ agasaŋ ma abi uavɨmi. Falisi hɨdɨlɨ ciaŋ sulavɨlalɨ agasaŋ alaŋ sɨhɨvia sɨbaŋ migɨla migɨla saŋ abi uavɨmi. Sadiusi hɨdɨlɨ ciaŋ sulavɨlalɨ agasaŋ avi alaŋ sɨhɨvia sɨbaŋ migɨla migɨla saŋ abi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisasɨ agaŋ nudɨ hulemɨlɨ hula Sisaliafilipai haiabɨla saŋ uavɨmi. Ua haiabɨla agadɨ mikɨ mikɨ lavɨla nudɨ hulemɨlɨ agɨladɨ abitɨhami. Hulaŋ iamɨgali agɨlaŋ Hulaŋ dɨ Ninaŋ agasaŋ nɨbu ani aba abavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Lɨci nudɨ abavɨmi. Limu hɨhɨle agɨlaŋ nusaŋ ala nameŋ abavɨlalɨ uavɨmi. Nɨbu hulaŋ iamɨgali avɨli hɨvɨ mɨŋamɨgu mɨŋaiahaiaha hɨsɨŋ hulaŋ Jon aba abavɨlalɨ uavɨmi. Hɨhɨle agɨlaŋ nameŋ abavɨlalɨ uavɨmi. Nɨbu Elaija aba abavɨlalɨ uavɨmi. Hɨhɨle agɨlaŋ nameŋ abavɨlalɨ uavɨmi. Nɨbu Jelemaia ua nɨbu Asɨ dɨ ciaŋ igalahalaha hɨsɨŋ hulaŋ mu agaŋ aba abavɨlalɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Lɨhavɨci Jisasɨ cɨhu nulɨdɨ abitɨhami. Namɨlaŋ iadɨ ani aba abɨlalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Lɨci Saimon Pita agaŋ nudɨ abami. Nama Asɨ hameŋ laci hameŋ laci hɨnilalɨ agadɨ Ninaŋ uami. Asɨ agaŋ nadɨ ala lɨbɨmɨŋavɨla hulaŋ iamɨgali ahɨliahuiahu saŋ abɨci vemanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Lɨci Jisasɨ nudɨ abami. Jon dɨ ninaŋ Saimon nama hɨjɨŋalɨha uami. Aniaba hulaŋ mu agaŋ nasaŋ hɨji iguci ciaŋ agadɨ ma abɨnaŋ uami. Iadɨ Iavaŋ iahua nudɨ haiabɨla hɨnilalɨ agaŋ nasaŋ hɨji igudaci abɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nadɨ ibi mu Pita uami. Viaŋ nadɨ abadin uami. Nama lɨba vɨdɨvɨdɨŋ daŋ agaŋ me hɨnibanaŋ uami. Hɨnihɨni hulaŋ iamɨgali avɨli hɨvɨ mɨŋamɨgu mɨŋaiahavɨbali agɨladɨ migɨlɨbanaŋ uami. Migɨlɨdanaŋ sudɨ fɨli haiabɨla agadɨ vɨdɨvɨdɨŋ agaŋ nulɨdɨ ma sɨbɨlɨ lamɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Asɨ hulaŋ iamɨgali likɨlɨci nudɨ lɨhu hɨvɨ hɨnihɨni hɨsɨŋ agadɨ hɨbɨ lavɨla lavɨla hɨsɨŋ me agɨladɨ nasaŋ iguben uami. Lɨlɨŋ nama fɨli neŋ hɨnihɨni akuaba akuaba sibɨla vivi hɨbɨ me lɨbɨbanaŋ uami. Lɨdanaŋ Asɨ iahua nudɨ haiabɨla hɨnilalɨ agaŋ avi hɨbɨ me lɨbɨbali uami. Nama fɨli neŋ hɨnihɨni akuaba akuaba sibɨla vivi hɨbɨ me lavɨlɨbanaŋ uami. Lɨdanaŋ Asɨ iahua nudɨ haiabɨla hɨnilalɨ agaŋ avi hɨbɨ me lavɨlɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Lavɨla nudɨ hulemɨlɨ agɨladɨ abami. Asɨ agaŋ iadɨ lɨbɨmɨŋavɨla hulaŋ iamɨgali agɨladɨ ahɨliahuiahu saŋ abɨci vemin agasaŋ hulaŋ limu hɨhɨle agɨladɨ abɨmɨlaŋ sɨbaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Hadɨhu ala Jisasɨ agaŋ hɨdɨlɨ maha nudɨ hulemɨlɨ agɨladɨ abami. Asɨ abɨci viaŋ Jelusalem haiabɨla uben uami. Ulɨŋ Isɨlaelɨ hɨdɨlɨ agɨladɨ hulaŋ hekɨlɨ hekɨlɨ agɨlaŋ uami. Asɨ saŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali agɨlaŋ uami. Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agadɨ lamalubilubi hɨsɨŋ hulaŋ agɨlaŋ uami. Iasaŋ avɨha avɨha akape iguavɨbali uami. Lavɨla abavɨci iadɨ ifɨhɨmavɨbali uami. Ifɨhɨmavɨci hɨmavɨla anihuliŋ me hɨvɨ cɨhu hɨhi iahɨben uami. ");
INSERT INTO ena_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Lɨci Pita Jisasɨ dɨ ciaŋ agadɨ igahɨla nudɨ via uavɨla ahica hɨtɨŋ cɨki sɨbaŋ hɨnihɨni nudɨ abacabɨlavɨla abami. Aludɨ Hekɨlɨ uami. Ha hɨma sɨbaŋ uami. Asɨ nasaŋ mavɨn hɨnihɨni nadɨ huaci lamɨdaci akuaba akuaba abɨnaŋ hameŋ agɨlaŋ nadɨ hɨvɨ ma iahavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Lɨci Jisasɨ limu cimɨlavɨla Pita dɨ abami. Satan nama iadɨ valavɨla uha uami. Nama Asɨ dɨ hɨji ma lubiahɨlɨnaŋ uami. Ha hulaŋ dɨ hɨji lubiahɨlɨnaŋ uami. Lavɨla iadɨ sibɨla ifɨlahɨben aba lɨnaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Lavɨla nudɨ hulemɨlɨ agɨladɨ abami. Hulaŋ mu viaŋ hula hɨdɨben aba nudɨ nukeŋ hɨji lubiahɨlahɨla hɨdɨlalɨ agadɨ valam uami. Valavɨla vɨhɨlɨ havahava viaŋ hula hɨdam uami. ");
INSERT INTO ena_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Hulaŋ mu nudɨ hadipɨlɨ hɨhi hɨnihɨni agasaŋ pam hɨji lamalama hɨnidaci uami. Nudɨ amɨŋ agaŋ huaci hameŋ laci hameŋ laci ma hɨnibali uami. Agadɨ ala hulaŋ mu iasaŋ pam igahɨlahɨla nudɨ hadipɨlɨ agadɨ vana sɨbɨlɨ lɨm aba abɨci nudɨ amɨŋ agaŋ huaci hameŋ laci hameŋ laci hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Hulaŋ mu fɨli neŋ hɨnihɨni akuaba akuaba huaci huaci agɨladɨ vibali uami. Agadɨ ala akuaba akuaba agɨlaŋ nudɨ amɨŋ agadɨ ma ahɨliahuavɨbali uami. Anɨm hɨlɨcɨ akuaba akuaba agɨlaŋ nudɨ amɨŋ agadɨ ahɨliahuavɨci huaci hameŋ laci hameŋ laci ma hɨnibali uami. ");
INSERT INTO ena_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Hulaŋ dɨ Ninaŋ agaŋ nudɨ Iaganu dɨ abɨlu hekɨlɨ vɨdɨvɨdɨŋ daŋ hɨnibali uami. Hɨniavɨla nudɨ ciaŋ hali hɨsɨŋ agɨlaŋ hula vebali uami. Vevɨla hulaŋ iamɨgali akuaba akuaba huaci huaci lɨhavɨlalɨ agɨlasaŋ hɨbɨŋ nulɨsaŋ akuaba akuaba huaci huaci agɨladɨ igubali uami. Igu igu hulaŋ iamɨgali akuaba akuaba sɨbɨlɨ sɨbɨlɨ lɨhavɨlalɨ agɨlasaŋ hɨbɨŋ nulɨsaŋ akuaba akuaba sɨbɨlɨ sɨbɨlɨ agɨladɨ igubali uami. ");
INSERT INTO ena_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Viaŋ naludɨ amɨŋ abadin uami. Hulaŋ iamɨgali hɨhɨle neŋ lagulama hɨniavadi nagɨlaŋ ma hɨmɨmaŋ lɨdɨŋ igavɨdaci Hulaŋ dɨ Ninaŋ agaŋ manɨgali hɨniavɨla vebali uami. ");
INSERT INTO ena_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jisasɨ agaŋ ciaŋ aba fɨhala hɨnidaci uaiaŋ limu ahica limu ahica umi. Lɨci nudɨ hulemɨlɨ ahica pam agɨladɨ likɨla halu huva huva sɨbaŋ heŋ iahuavɨmi. Nudɨ hulemɨlɨ agɨladɨ ibi nameŋ. Mu Pita. Mu Jemɨsɨ. Mu Jon. Jon nɨbu Jemɨsɨ imanu. Nulɨdɨ likɨlavɨla ahuata hameŋ iahuavɨmi. Iahuavɨla nɨbɨlaŋ hɨtɨŋ sɨbaŋ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Hɨnihɨni Jisasɨ dɨ hadipɨlɨ agadɨ igavɨdaci mu hɨdɨlɨ sɨbaŋ hɨnimi. Nudɨ mugaŋ lamɨgaŋ agaŋ uaiaŋ abɨlu me hɨlami. Lɨdaci nudɨ hadi hɨlahɨla hutesɨ hutesɨ agɨlaŋ mila sɨbaŋ unɨ abɨlu me hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Lɨhavɨdaci nudɨ hulemɨlɨ agɨlaŋ igavɨdaci Mosesɨ hula Elaija hula iahavɨla Jisasɨ hula ciaŋ aba aba hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Hɨniavɨdaci Pita agaŋ abami. Aludɨ Hekɨlɨ uami. Alaŋ neŋ hɨnimɨli huaci li uami. Nama cavaŋ ulaŋ hafihafi saŋ abɨnaŋ cavaŋ ulaŋ ahica pam agɨladɨ hafiben uami. Mu nasaŋ hafiben uami. Mu Mosesɨ saŋ hafiben uami. Mu Elaija saŋ hafiben uami. ");
INSERT INTO ena_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Hameŋ abɨdaci hamu mila sɨbaŋ agaŋ mɨgavɨla nulɨdɨ hafilɨbami. Lɨci Asɨ hamu lɨkɨla lɨkɨla heŋ hɨnihɨni abami. Ha iadɨ nukeŋ Ninaŋ uami. Viaŋ nusaŋ mavɨn hekɨlɨ hɨnihɨni nusaŋ hɨjɨŋalɨlan uami. Namɨlaŋ nudɨ ciaŋ agadɨ igahɨlɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Lɨci Jisasɨ dɨ hulemɨlɨ agɨlaŋ hekɨlɨ lɨdavɨla fɨli hɨvɨ sɨkasɨkan mɨgavɨla ipalavɨci mɨguavɨci ani valɨ hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Lɨhavɨci Jisasɨ nulɨdɨ mikɨ pɨŋ uavɨla nulɨdɨ mɨŋaigavɨla abami. Namɨlaŋ lɨdɨmɨlaŋ uami. Iahɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Lɨci Jisasɨ dɨ igaiahua igavɨci nɨbu hɨtɨŋ hɨnimi. Hulaŋ mu nɨbu hula ma hɨniavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","La halu agadɨ vala mɨgamɨga hɨbɨ cina hɨvɨ nudɨ hulemɨlɨ ahica pam agɨladɨ vɨdɨvɨdɨŋ sɨbaŋ abami. Akuaba akuaba igɨlaŋ agɨladɨ aniaba hulaŋ mu dɨ abɨmɨlaŋ sɨbaŋ uami. Mufɨli Hulaŋ dɨ Ninaŋ hɨmavɨla cɨhu hɨhi iahɨci uami. Akuaba akuaba igɨlaŋ agɨladɨ heŋ sulɨhalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Lɨci nudɨ hulemɨlɨ agɨlaŋ nudɨ abitɨhavɨmi. Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agadɨ lamalubilubi hɨsɨŋ hulaŋ agɨlaŋ akɨ saŋ nameŋ abavɨlalɨ uavɨmi. Asɨ abɨci Elaija mɨse hali vebali aba abavɨlalɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Lɨhavɨci nulɨdɨ abami. Ha amɨŋ ala abavɨlalɨ uami. Elaija mɨse hali vevɨla akuaba akuaba sɨkasɨkan agɨladɨ hihɨlɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Elaija ci velɨ uami. Veci hulaŋ iamɨgali nudɨ igavalɨ uami. Agadɨ ala nulɨdɨ hɨji ma toveci nulɨdɨ nukeŋ hɨji lubiahɨlahɨla nudɨ sɨbɨlɨ lamavalɨ uami. La iabi neŋ avi Hulaŋ dɨ Ninaŋ agadɨ hameŋ ala lɨhavɨdaci avɨha avɨha igɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jisasɨ hameŋ abɨci nudɨ hulemɨlɨ agɨlaŋ hɨji nameŋ lamavɨmi. Ha hulaŋ iamɨgali avɨli hɨvɨ mɨŋamɨgu mɨŋaiahaiaha hɨsɨŋ hulaŋ Jon saŋ ala abi uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jisasɨ nudɨ hulemɨlɨ ahica pam agɨlaŋ hula uavɨla hulaŋ iamɨgali akape hɨniavɨmi heŋ iahuavɨmi. Iahuavɨci hulaŋ mu agaŋ ve Jisasɨ dɨ pɨŋ mɨgalɨfɨlɨbavɨla abami. ");
INSERT INTO ena_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Iadɨ Hekɨlɨ uami. Iadɨ ninaŋ agasaŋ mavɨn hɨniha uami. Nɨbu uava hɨmahɨma avɨŋ hɨvɨ mɨgaifɨlalɨ uami. Avɨli hɨvɨ mɨgaifɨlalɨ uami. Lɨdaci nudɨ hadipɨlɨ avi sɨbɨlɨ sɨbaŋ hɨnilalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Viaŋ nadɨ hulemɨlɨ agɨlaŋ sudɨ sɨbɨlɨ agadɨ lahulahu saŋ nulɨdɨ pɨŋ via uavɨla abiemin uami. Abɨlɨŋ nɨbɨlaŋ sudɨ sɨbɨlɨ agadɨ lahubalu aba lɨhavɨci hɨma liemi uami. ");
INSERT INTO ena_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Lɨci Jisasɨ abami. Viaŋ akape tɨbɨ namɨlaŋ hula hɨnilan uami. Hɨnihɨni naludɨ vɨhɨlɨ agɨladɨ havɨlan uami. Agadɨ ala namɨlaŋ hɨji vɨdɨvɨdɨŋ ma lamɨlalaŋ uami. Lɨdalaŋ naludɨ hɨji humɨgaŋ agɨlaŋ sɨbɨlɨ sɨbɨlɨ laci hɨniavɨlalɨ uami. Lavɨla abami. Ninaŋ agadɨ iadɨ pɨŋ vavehalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Abɨci vavehavɨci Jisasɨ sudɨ sɨbɨlɨ agadɨ abacabɨlɨci ninaŋ agadɨ vala umi. Lɨci ninaŋ agaŋ cɨhu huaci lɨmi. ");
INSERT INTO ena_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Lɨci nudɨ hulemɨlɨ agɨlaŋ hɨtɨŋ vevɨla nudɨ abitɨhavɨmi. Akɨ lɨci alaŋ sudɨ sɨbɨlɨ agadɨ ma lahuiemɨlu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Lɨhavɨci nulɨdɨ abami. Naludɨ hɨji vɨdɨvɨdɨŋ agɨlaŋ hekɨlɨ hɨma sadaŋ namɨlaŋ akuaba akuaba ma lɨlalaŋ uami. Viaŋ naludɨ amɨŋ abadin uami. Naludɨ hɨji vɨdɨvɨdɨŋ agɨlaŋ hekɨlɨ hɨniavɨci namɨlaŋ akuaba akuaba hameŋ agɨladɨ lɨbalaŋ uami. Naludɨ hɨji vɨdɨvɨdɨŋ agɨlaŋ isabɨlaŋ masɨtetɨ agadɨ hɨlɨcɨ sudɨme cɨki sɨbaŋ hɨnilalɨ hameŋ avi hɨniavɨci uami. Ha namɨlaŋ halu mu agadɨ nameŋ abɨbalaŋ uami. Nadɨ uvɨ agadɨ vala ua mu abɨla hɨvɨ hɨniha aba abɨbalaŋ uami. Lɨlaŋ halu agaŋ namɨlaŋ abɨbalaŋ hameŋ ala lɨbali uami. La akuaba akuaba sibɨla mu hɨdɨlɨ mu hɨdɨlɨ agɨladɨ avi huaci vibalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisasɨ agaŋ nudɨ hulemɨlɨ agɨlaŋ hula Galili fɨli tɨbɨ heŋ mɨgudɨba hɨniavɨla nudɨ hulemɨlɨ agɨladɨ abami. Hulaŋ mu agaŋ Hulaŋ dɨ Ninaŋ agadɨ amɨŋ ci ilasɨbali uami. Ilasavɨla via ua hulaŋ sɨbɨlɨ agɨladɨ human hɨvɨ lamɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Lɨci nudɨ ifɨhɨmavɨbali uami. Ifɨhɨmavɨci anihuliŋ me hɨvɨ cɨhu hɨhi iahɨbali uami. Lɨci nudɨ hulemɨlɨ agɨlaŋ nudɨ ciaŋ agadɨ igahɨlavɨla nusaŋ mavɨn mɨŋamɨŋa ma hɨjɨŋalavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisasɨ nudɨ hulemɨlɨ agɨlaŋ hula ua Kapelɨneam haiabɨla iahavɨmi. Lɨhavɨci hulaŋ Asɨ dɨ aŋam ulaŋ hekɨlɨ agadɨ sibɨla vivi saŋ anɨm hɨlɨcɨ vihavɨhadami agɨlaŋ vevɨla Pita dɨ abavɨmi. Naludɨ manasɨŋ sihɨ hɨsɨŋ agaŋ hualɨ pabiŋ pabiŋ hɨvɨ Asɨ dɨ aŋam ulaŋ hekɨlɨ agadɨ sibɨla vivi saŋ anɨm hɨlɨcɨ igulalɨ ua ma igulalɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Lɨhavɨci Pita abami. Nɨbu igulalɨ uami. Lavɨla Pita agaŋ uleŋ muji ivoumi. Ivoua ciaŋ ma abɨmaŋ lɨdaci Jisasɨ nudɨ abami. Saimon uami. Viaŋ nadɨ abitɨhɨben aba lin uami. Manɨgali fɨli neŋ hɨsɨŋ agɨlaŋ vɨdɨvɨdɨŋ aba aba huban saŋ anɨm hɨlɨcɨ akuaba akuaba ani ani dɨ hɨvɨ vihavɨlalɨ uami. Nulɨdɨ hɨdɨlɨ pam agɨladɨ hɨvɨ vihavɨlalɨ ua hulaŋ iamɨgali limu hɨhɨle agɨladɨ hɨvɨ vihavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Lɨci Pita abami. Hulaŋ iamɨgali limu hɨhɨle agɨladɨ hɨvɨ vihavɨlalɨ uami. Lɨci Jisasɨ nudɨ abami. Hameŋ lɨhavɨdaci nulɨdɨ hɨdɨlɨ pam agɨlaŋ anɨm hɨlɨcɨ ma iguavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Agadɨ ala anɨm hɨlɨcɨ vivi hɨsɨŋ agɨlaŋ alusaŋ humɨgaŋ vɨhɨlɨ vihavɨmɨdɨ aba nadɨ abɨben uami. Nama idu hekɨlɨ heŋ uavɨla aluguli lamɨha uami. La hehɨlaŋ mu nudɨ mɨse magɨlavɨla nudɨ sɨbɨsaŋ agadɨ mɨŋacɨkɨla igɨnaŋ anɨm hɨlɨcɨ nudɨ sɨbɨsaŋ muji heŋ hɨnibali uami. Lɨci anɨm hɨlɨcɨ agadɨ viavɨla nasadaŋ iasadaŋ igahɨlavɨla Asɨ dɨ aŋam ulaŋ hekɨlɨ agadɨ sibɨla vivi saŋ iguha uami. ");
INSERT INTO ena_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Hadɨhu heŋ ala Jisasɨ dɨ hulemɨlɨ agɨlaŋ nudɨ pɨŋ vevɨla abavɨmi. Asɨ hulaŋ iamɨgali likɨlɨci nudɨ lɨhu hɨvɨ hɨniavɨbali heŋ ani agaŋ ibi hekɨlɨ daŋ hɨnibali uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Lɨhavɨci Jisasɨ ninaŋ cɨkɨ mu agadɨ ulɨci veci via ua nɨbɨlaŋ hɨniavɨmi agadɨ alɨhaŋ heŋ lamavɨla abami. ");
INSERT INTO ena_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Viaŋ naludɨ amɨŋ abadin uami. Asɨ agaŋ hulaŋ iamɨgali nulɨdɨ lusɨŋ sɨbɨlɨ sɨbɨlɨ agɨladɨ valavala ninanadi cɨki cɨki me ma hɨniavɨlalɨ agɨladɨ ma likɨlɨbali uami. Lɨci nudɨ lɨhu hɨvɨ ma sɨbaŋ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hulaŋ iamɨgali ninanadi cɨki cɨki me hɨnihɨni ibi apalɨ hɨniavɨlalɨ agɨlaŋ uami. Asɨ hulaŋ iamɨgali likɨlɨci nudɨ lɨhu hɨvɨ hɨniavɨbali heŋ nɨbɨlaŋ ibi hekɨlɨ daŋ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Hulaŋ mu iasaŋ igahɨlahɨla ninaŋ cɨki ibi apalɨ nameŋ agasaŋ hɨjɨŋalɨlalɨ agaŋ iasaŋ avi hɨjɨŋalɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Lavɨla Jisasɨ cɨhu abami. Hulaŋ mu agaŋ vevɨla hɨji humɨgaŋ aiamagɨlamagɨla saŋ akuaba akuaba lɨci hulaŋ mu iasaŋ hɨji vɨdɨvɨdɨŋ cɨki daŋ hɨnilalɨ agaŋ igavɨla lusɨŋ sɨbɨlɨ vici uami. Ha hulaŋ limu hɨhɨle agɨlaŋ lɨba kum hekɨlɨ viavɨla aiamagɨlamagɨla hɨsɨŋ hulaŋ agadɨ sugɨtaŋ hɨvɨ lɨbɨhahavɨm uami. Lɨbɨhaha havalavɨci avɨli hekɨlɨ agadɨ huhaŋ heŋ mɨgua nahɨmam uami. Nahɨmɨci ha nɨbu huaci uami. Lusɨŋ hameŋ agaŋ cɨhu cɨhu ma iahɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Akuaba akuaba mu hɨdɨlɨ mu hɨdɨlɨ agɨlaŋ iahaiaha hulaŋ iamɨgali agɨladɨ hɨji mɨŋaiahavɨdaci lusɨŋ sɨbɨlɨ sɨbɨlɨ vihavɨlalɨ uami. Lusɨŋ sɨbɨlɨ sɨbɨlɨ vihavɨlalɨ agɨlaŋ vɨhɨlɨ igavɨbali uami. Agadɨ ala aniaba hulaŋ nulɨdɨ aiamagɨlamagɨla hɨsɨŋ agɨlaŋ vɨhɨlɨ hekɨlɨ hekɨlɨ igavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nadɨ human limu agaŋ lɨci nama lusɨŋ sɨbɨlɨ viavɨla uami. Human agadɨ ihalaha havalɨha uami. Hameŋ lɨnaŋ ha huaci uami. Human limu laci hɨnici nama huaci hameŋ laci hameŋ laci hɨnibanaŋ uami. Nama human limu limu daŋ hɨninaŋ Asɨ agaŋ nadɨ via avɨŋ hɨvɨ havalɨci mɨgubanaŋ uami. Avɨŋ agaŋ hameŋ laci hameŋ laci lɨhulɨhu hɨnilalɨ uami. Nadɨ hɨcɨ limu agaŋ lɨci nama lusɨŋ sɨbɨlɨ viavɨla uami. Hɨcɨ agadɨ ihalaha havalɨha uami. Hameŋ lɨnaŋ ha huaci uami. Hɨcɨ limu laci hɨnici nama huaci hameŋ laci hameŋ laci hɨnibanaŋ uami. Nama hɨcɨ limu limu daŋ hɨninaŋ Asɨ agaŋ nadɨ viavɨla avɨŋ hɨvɨ havalɨci mɨgubanaŋ uami. Avɨŋ agaŋ hameŋ laci hameŋ laci lɨhulɨhu hɨnilalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nadɨ lamɨgaŋ limu agaŋ lɨci nama lusɨŋ sɨbɨlɨ viavɨla uami. Lamɨgaŋ agadɨ mɨŋatɨhua havalɨha uami. Hameŋ lɨnaŋ ha huaci uami. Lamɨgaŋ limu laci hɨnici nama huaci hameŋ laci hameŋ laci hɨnibanaŋ uami. Nama lamɨgaŋ limu limu daŋ hɨninaŋ Asɨ agaŋ nadɨ via avɨŋ hekɨlɨ hɨvɨ havalɨci mɨgubanaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Ci igɨlaŋ uami. Namɨlaŋ hɨji nameŋ lamɨmɨlaŋ uami. Hulemɨlɨ cɨki cɨki nagɨlaŋ ibi apalɨ aba abɨmɨlaŋ uami. Viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Asɨ dɨ ciaŋ hali hɨsɨŋ nulɨdɨ migɨlavɨlalɨ agɨlaŋ uami. Asɨ dɨ haiabɨla heŋ hɨnihɨni Asɨ mavɨn lama hɨnilalɨ heŋ lagulamalama hɨniavɨlalɨ uami. Hɨnihɨni hulemɨlɨ cɨki cɨki ibi apalɨ agɨladɨ ahɨliahuiahu saŋ Asɨ dɨ abavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Lavɨla Jisasɨ cɨhu hɨve lama abami. Namɨlaŋ vameŋ hɨji lamɨlaŋ uami. Hulaŋ mu sabaŋ sipsipɨ 100 daŋ hɨnivi uami. Lɨci sabaŋ sipsipɨ mu agaŋ ua sɨvɨlɨvi uami. Sɨvɨlɨci sabaŋ sipsipɨ 99 agɨladɨ valɨci fɨli tɨbɨ halu daŋ halu daŋ heŋ hɨniavɨvi uami. Hɨniavɨdaci nɨbu ua sabaŋ sipsipɨ mu agadɨ suhɨla suhɨla hɨdɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Viaŋ naludɨ amɨŋ abadin uami. Suhɨla suhɨla hɨda viavɨla hekɨlɨ sɨbaŋ hɨjɨŋalɨvi uami. Sabaŋ sipsipɨ 99 huaci hɨniavɨvi agɨlasaŋ hɨjɨŋalɨvi uami. Agadɨ ala sabaŋ sipsipɨ mu agadɨ suhɨla vivi agasaŋ hekɨlɨ sɨbaŋ hɨjɨŋalɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Naludɨ Iaganalu Asɨ iahua hɨvɨ hɨnilalɨ agaŋ avi hameŋ ala lɨlalɨ uami. Hulemɨlɨ cɨki cɨki ibi apalɨ agɨladɨ hulaŋ mu agaŋ ua sɨvɨla sɨvɨla saŋ valɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Lavɨla Jisasɨ cɨhu abami. Nadɨ isaima me agaŋ nama hula hugɨ daŋ hɨnici nama ua nudɨ igɨha uami. La ahica hɨtɨŋ sɨbaŋ hɨnihɨni nɨbu hula ciaŋ hihɨla hihɨla saŋ nudɨ abɨha uami. Abɨnaŋ nadɨ ciaŋ agadɨ igahɨlɨci nama nɨbu hula hɨji humɨgaŋ pam hɨnibalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Abɨnaŋ nadɨ ciaŋ agadɨ ma igahɨlɨmaŋ lɨci uami. Ha nama uavɨla hulaŋ pabiŋ ua ahica agɨladɨ viavɨla nudɨ pɨŋ cɨhu vehalaŋ uami. Nɨbu lusɨŋ sɨbɨlɨ vidaci igavalɨ agɨladɨ vaveha uami. Hameŋ lɨnaŋ hulaŋ ahica ua ahica pam agɨlaŋ nadɨ ahɨliahua nudɨ hugɨ agadɨ haiabɨla lama abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Haiabɨla lama abavɨci nulɨdɨ ciaŋ ma igahɨlɨmaŋ lɨci uami. Hulaŋ iamɨgali avɨli hɨvɨ mɨŋamɨgu mɨŋaiahavalɨ sɨkasɨkan agɨladɨ abɨha uami. Lɨnaŋ vevɨla abavɨci nulɨdɨ ciaŋ agadɨ avi ma igahɨlɨmaŋ lɨci uami. Ha valɨnaŋ hulaŋ avɨli hɨvɨ ma mɨŋamɨgu mɨŋaiahɨmaŋ agaŋ me hɨnim uami. Huban saŋ anɨm hɨlɨcɨ vivi hɨsɨŋ hulaŋ me hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Viaŋ naludɨ amɨŋ abadin uami. Namɨlaŋ fɨli neŋ hɨnihɨni akuaba akuaba sibɨla vivi hɨbɨ me lɨbɨbalaŋ uami. Lɨdalaŋ Asɨ iahua nudɨ haiabɨla hɨnilalɨ agaŋ avi hɨbɨ me lɨbɨbali uami. Namɨlaŋ fɨli neŋ hɨnihɨni akuaba akuaba sibɨla vivi hɨbɨ me lavɨlɨbalaŋ uami. Lɨdalaŋ Asɨ iahua nudɨ haiabɨla hɨnilalɨ agaŋ avi hɨbɨ me lavɨlɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","Viaŋ naludɨ cɨhu ala abadin uami. Hulaŋ ahica ua ahica pam agɨlaŋ mɨgudɨba hɨnihɨni iasaŋ igahɨlavɨci uami. Viaŋ nɨbɨlaŋ hula hɨniben uami. Aniaba hulaŋ ahica agɨlaŋ hɨji humɨgaŋ pam hɨniavɨla akuaba akuaba vivi saŋ iadɨ Iavaŋ iahua nudɨ haiabɨla hɨnilalɨ agadɨ abavɨci uami. Nɨbu nulɨsaŋ igubali uami. ");
INSERT INTO ena_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita agaŋ Jisasɨ dɨ pɨŋ vevɨla abami. Iadɨ Hekɨlɨ uami. Iadɨ isaima me agaŋ viaŋ hula hugɨ daŋ hɨnidaci viaŋ nudɨ nameŋ abɨben uami. Viaŋ nama hula ciaŋ apalɨ aba abɨben uami. Cɨhu tɨbɨ avi lɨci hameŋ laci ala abɨben uami. Lɨdalɨŋ nɨbu cɨhu tɨbɨ cɨhu tɨbɨ lɨdaci viaŋ hameŋ laci hameŋ laci aba aba lugɨlɨdalɨŋ human limu fɨhala uci heŋ akua valɨben uami. ");
INSERT INTO ena_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Lɨci Jisasɨ nudɨ abami. Viaŋ nama human limu fɨhala human limu ahica cɨjɨŋ tɨbɨ laci aba aba saŋ ma abadin uami. Viaŋ namɨlaŋ mu tɨbɨ mu tɨbɨ hameŋ laci hameŋ laci aba aba saŋ abadin uami. ");
INSERT INTO ena_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ci igɨlaŋ uami. Asɨ hulaŋ iamɨgali likɨlɨci nudɨ lɨhu hɨvɨ hɨnihɨni agaŋ uami. Manɨgali mu nudɨ sibɨla hɨsɨŋ hulemɨlɨ agɨlaŋ nusaŋ akuaba akuaba hɨbɨŋ igu igu saŋ abɨvi me uami. ");
INSERT INTO ena_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","La akuaba akuaba nusaŋ hɨbɨŋ igu igu saŋ hɨdɨlɨ maha abɨdaci hulaŋ mu agadɨ nudɨ pɨŋ vavehavɨvi uami. Nɨbu nudɨ manɨgali saŋ hɨbɨŋ anɨm hɨlɨcɨ 10 milion hameŋ agadɨ igu igu saŋ vavehavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Agadɨ ala hulaŋ agaŋ hɨbɨŋ igu igu hɨsɨŋ anɨm hɨlɨcɨ apalɨ hɨnivi uami. Lɨci manɨgali agaŋ hulaŋ limu hɨhɨle agɨladɨ abɨvi uami. Nudɨdaŋ nudɨ iamɨgali ninanadi akuaba akuaba sɨkasɨkan agɨladɨdaŋ via ua mutɨŋ hɨvɨ lamɨlaŋ lavavɨm aba abɨvi uami. Lavavɨci sibɨla havɨ havɨ vihavɨdaci viaŋ hɨbɨŋ anɨm hɨlɨcɨ akuaba akuaba agɨladɨ viben aba abɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Lɨci sibɨla hɨsɨŋ hulemɨlɨ agaŋ mavɨn ciaŋ ciaŋ aba aba saŋ manɨgali agadɨ hɨcɨ pɨŋ mɨgalɨfɨlɨbavɨla nudɨ hali agadɨ fɨli hɨvɨ lɨbɨlɨva hɨnihɨni nameŋ abɨvi uami. Iasaŋ makamɨŋa hɨnidanaŋ nasaŋ hɨbɨŋ akuaba akuaba agɨladɨ sɨkasɨkan iguben aba abɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Lɨci manɨgali agaŋ nusaŋ mavɨn hekɨlɨ lamavɨla abɨvi uami. Viaŋ nama iasaŋ hɨbɨŋ igu igu saŋ ma abɨben aba abɨvi uami. Lavɨla nudɨ valɨci uvi uami. ");
INSERT INTO ena_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Lɨci sibɨla hɨsɨŋ hulemɨlɨ agaŋ vala haiabɨla ivavevi uami. Ivavevɨla nudɨ sibɨla pam hɨsɨŋ agadɨ igɨvi uami. Lavɨla hulaŋ agaŋ nudɨ anɨm hɨlɨcɨ 100 vivi agasaŋ igahɨlavɨla hulaŋ agadɨ mɨŋahubɨhaha sugɨtaŋ mɨŋalatɨha hɨnihɨni abɨvi uami. Nama iadɨ anɨm hɨlɨcɨ vihanaŋ agasaŋ hɨbɨŋ iguha aba abɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Lɨci nudɨ sibɨla pam hɨsɨŋ agaŋ nudɨ pɨŋ mɨgalɨfɨlɨbavɨla nudɨ hali agadɨ fɨli hɨvɨ lɨbɨlɨva hɨnihɨni mavɨn ciaŋ ciaŋ abɨvi uami. Nama iasaŋ makamɨŋa hɨnidanaŋ nasaŋ hɨbɨŋ akuaba akuaba iguben aba abɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Lɨci ala nudɨ ciaŋ ma igahɨlɨvi uami. Lavɨla nudɨ sibɨla pam hɨsɨŋ agadɨ via ua lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ lamɨvi uami. Lamavɨla abɨvi uami. Nama iasaŋ hɨbɨŋ akuaba akuaba iguavɨla heŋ ivavebanaŋ aba abɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Lɨci hulaŋ lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ hɨnivi agadɨ sibɨla pam hɨsɨŋ agɨlaŋ mavɨn mɨŋamɨŋa ma sɨbaŋ hɨjɨŋalavɨvi uami. Lavɨla ua manɨgali agadɨ abavɨvi uami. Hulaŋ nasaŋ hɨbɨŋ anɨm hɨlɨcɨ ma iguiemi agaŋ nameŋ li aba abavɨvi uami. Nɨbu hulaŋ mu nɨbu hula hɨbɨŋ daŋ agadɨ via ua lɨmɨn sɨbɨlɨ ulaŋ hɨvɨ lami aba abavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Lɨhavɨci manɨgali agaŋ sibɨla hɨsɨŋ hulemɨlɨ nusaŋ hɨbɨŋ anɨm hɨlɨcɨ ma igumaŋ agadɨ abɨci veci nudɨ abɨvi uami. Nama hulaŋ sɨbɨlɨ aba abɨvi uami. Viaŋ nama iasaŋ mavɨn ciaŋ ciaŋ agadɨ igunabɨla viaŋ nama hula ciaŋ apalɨ aba abiemin aba abɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Viaŋ nasaŋ mavɨn hɨniemin hameŋ nama nadɨ sibɨla pam hɨsɨŋ agasaŋ mavɨn ma hɨninaŋ aba abɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Hameŋ abɨci nudɨ igɨvɨ lɨci hulaŋ sɨbɨlɨ sɨbɨlɨ agɨladɨ human hɨvɨ lamɨvi uami. Lɨci nusaŋ avɨha avɨha iguavɨdaci hɨnihɨni manɨgali saŋ hɨbɨŋ akuaba akuaba agɨladɨ iguci heŋ valavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","La abami. Hulaŋ namɨlaŋ hula hugɨ daŋ hɨnilalɨ agadɨ hugɨ amɨŋ ma hivɨlaŋ uami. Iadɨ Iavaŋ iahua hɨvɨ hɨnilalɨ agaŋ naludɨ hugɨ agɨladɨ ma hivɨbali uami. Manɨgali agaŋ lɨvi hameŋ laci ala nalusaŋ avɨha avɨha igubali uami. ");
INSERT INTO ena_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisasɨ ciaŋ hameŋ agadɨ abɨci ci lɨci Galili fɨli tɨbɨ agadɨ valavɨla Judia fɨli tɨbɨ saŋ umi. Hɨbɨ pɨlɨ mu Jolɨdan avɨli limu caba hɨniadami heŋ umi. ");
INSERT INTO ena_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Udaci hulaŋ iamɨgali akape sɨbaŋ nɨbu hula uavɨmi. Ua heŋ hɨniavɨdaci Jisasɨ nulɨdɨ hɨmuhɨmu agɨladɨ huaci lamami. ");
INSERT INTO ena_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Lɨci Falisi hɨdɨlɨ agɨlaŋ Jisasɨ dɨ pɨŋ vevɨla nudɨ ilasɨbalu aba abitɨhavɨmi. Hulaŋ mu aludɨ ciaŋ vɨdɨvɨdɨŋ agadɨ lubiahɨlavɨla nudɨ nukeŋ hɨji hɨvɨ abinu dɨ huaci valavɨla lahuvi ua hɨma uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Lɨhavɨci Jisasɨ nulɨdɨ abami. Namɨlaŋ ciaŋ Asɨ dɨ manasɨŋ hekɨlɨ hɨvɨ hɨnilalɨ agadɨ ma akua igɨlalaŋ uami. Vaka sɨbaŋ Asɨ hɨdɨlɨ maha akuaba akuaba lamami agasaŋ nudɨ manasɨŋ hekɨlɨ agaŋ nameŋ abami uami. Hulaŋ daŋ iamɨgali daŋ lamami aba abami uami. ");
INSERT INTO ena_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Lavɨla Asɨ nameŋ abami uami. Hameŋ sadaŋ hulaŋ agɨlaŋ nulɨdɨ numɨgaiagagalinɨlu agɨladɨ valavala iamɨgali sabisabi nulɨdɨ abinadinɨlu agɨlaŋ hula hadipɨlɨ pabiŋ me hɨniavɨlalɨ aba abami uami. ");
INSERT INTO ena_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","La abami. Hameŋ sadaŋ nɨbɨlaŋ ahica me ma hɨniavɨlalɨ uami. Hadipɨlɨ pabiŋ laci me hɨniavɨlalɨ uami. Hameŋ sadaŋ Asɨ agaŋ lɨci hadipɨlɨ pabiŋ me hɨniavɨlalɨ agadɨ hulaŋ mu mɨŋalatɨhɨmɨdɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Lɨci Falisi hɨdɨlɨ agɨlaŋ abavɨmi. Mosesɨ dɨ ciaŋ vɨdɨvɨdɨŋ agaŋ akɨ saŋ nameŋ abami uavɨmi. Hulaŋ mu abinu dɨ valavɨla lahuben aba nusaŋ manasɨŋ lɨbavɨla igum aba abami uavɨmi. Lavɨla iamɨgali agadɨ huaci valavɨla lahubali aba abami uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Lɨhavɨci Jisasɨ nulɨdɨ abami. Isɨlaelɨ hɨdɨlɨ naludɨ hɨji humɨgaŋ agɨlaŋ ci sɨjiavɨmi sadaŋ Mosesɨ ciaŋ vɨdɨvɨdɨŋ nameŋ lɨbami uami. Hulaŋ mu abinu dɨ valavɨla lahuben aba nɨbu vana lahum aba abami uami. Agadɨ ala vaka sɨbaŋ hameŋ ma lɨhavɨhadami uami. ");
INSERT INTO ena_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Viaŋ naludɨ abadin agadɨ igahɨlɨhalaŋ uami. Iamɨgali mu hɨvɨkalɨ saŋ ma hɨdɨvi uami. Agadɨ ala muŋanu nudɨ lahuci ua havɨ hɨnivi uami. Hɨnidaci muŋanu lɨvɨlu agaŋ iamɨgali mu sabivi uami. Asɨ hulaŋ hameŋ agadɨ igɨci nɨbu abinu lɨvɨlu agadɨ vala ua abinu hɨvɨ agaŋ hula hɨnivi agasaŋ nɨbu hugɨ daŋ hɨnivi uami. Hulaŋ agɨlaŋ iamɨgali mu mu sɨgɨlɨ vihavɨlalɨ agɨlaŋ me hɨnivi uami. ");
INSERT INTO ena_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Lɨci Jisasɨ dɨ hulemɨlɨ agɨlaŋ nudɨ ciaŋ agadɨ igahɨlavɨla abavɨmi. Hulaŋ mu iamɨgali sabici hɨvɨkalɨ saŋ ma hɨdɨlalɨ agadɨ valɨmɨdɨ aba abɨnaŋ uavɨmi. Hulaŋ mu ciaŋ hameŋ abɨnaŋ agasaŋ igahɨlɨci hɨma lɨci nɨbu iamɨgali sabimɨdɨ uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Lɨhavɨci Jisasɨ nulɨdɨ abami. Hulaŋ sɨkasɨkan agɨlaŋ iamɨgali daŋ hɨniavɨlalɨ uami. Agadɨ ala Asɨ nukeŋ hulaŋ limu hɨhɨle agɨlasaŋ pam vɨdɨvɨdɨŋ igudaci iamɨgali ma sabiavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ci igɨlaŋ uami. Hulaŋ hɨhɨle iamɨgali ma sabiavɨlalɨ agadɨ hɨdɨlɨ nɨbu nameŋ uami. Hulaŋ hɨhɨle iamɨgagalinɨlu nulɨdɨ huhɨlavɨci ninanadi havahava hɨsɨŋ vɨdɨvɨdɨŋ apalɨ hɨniavɨlalɨ uami. Hameŋ hɨnihɨni iaha hekɨlɨ lavɨla iamɨgali ma sabiavɨlalɨ uami. Hɨhɨle ninanadi havahava hɨbɨ agɨladɨ hulaŋ limu hɨhɨle agɨlaŋ ihalahavɨlalɨ sadaŋ iamɨgali ma sabiavɨlalɨ uami. Hɨhɨle Asɨ hulaŋ iamɨgali likɨlɨci nudɨ lɨhu hɨvɨ hɨniavɨbali agadɨ sibɨla vivi saŋ igahɨlahɨla iamɨgali ma sabiavɨlalɨ uami. Aniaba hulaŋ mu ciaŋ nagadɨ igahɨlavɨla lubiahɨlɨben aba vana lubiahɨlam uami. ");
INSERT INTO ena_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","La hadɨhu ala hulaŋ iamɨgali agɨlaŋ ninanadi cɨki cɨki agɨladɨ Jisasɨ dɨ pɨŋ vavehavɨmi. Jisasɨ agaŋ nudɨ human agadɨ nulɨdɨ sabɨ hɨvɨ lamavɨla Asɨ dɨ abɨci Asɨ nulɨdɨ huaci lamɨbali aba nudɨ pɨŋ vavehavɨmi. Lɨhavɨdaci nudɨ hulemɨlɨ agɨlaŋ hulaŋ iamɨgali agɨladɨ abacabɨlavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Lɨhavɨci Jisasɨ nudɨ hulemɨlɨ agɨladɨ abami. Namɨlaŋ valɨlaŋ ninanadi cɨki cɨki agɨlaŋ iadɨ pɨŋ vehavɨm uami. Nulɨdɨ abamɨgɨlɨmɨlaŋ uami. Asɨ agaŋ hulaŋ iamɨgali ninanadi cɨki cɨki me hɨnihɨni manɨgali dɨ lɨhu hɨvɨ hɨniavɨlalɨ agɨladɨ likɨlɨbali uami. Likɨlɨci nudɨ lɨhu hɨvɨ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Lavɨla nudɨ human agadɨ ninanadi cɨki cɨki agɨladɨ sabɨ hɨvɨ lama Asɨ nulɨdɨ huaci lamalama saŋ Asɨ dɨ abami. La nulɨdɨ vala umi. ");
INSERT INTO ena_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Hulaŋ mɨnibɨlɨ agaŋ vevɨla Jisasɨ dɨ abami. Iavaŋ uami. Viaŋ akɨ sibɨla huaci agɨladɨ viavɨla Asɨ dɨ haiabɨla uavɨla huaci hameŋ laci hameŋ laci hɨnivin uami. ");
INSERT INTO ena_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Lɨci Jisasɨ nudɨ abami. Nama akɨ saŋ akuaba akuaba huaci huaci agɨlasaŋ iadɨ abitɨhɨnaŋ uami. Asɨ pam nɨbu huaci uami. Nama huaci hameŋ laci hameŋ laci hɨniben aba uami. Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agɨladɨ lubiahɨlɨha uami. ");
INSERT INTO ena_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Lɨci hulaŋ agaŋ Jisasɨ dɨ abami. Akɨ ciaŋ vɨdɨvɨdɨŋ agɨladɨ lubiahɨlahɨla saŋ abɨnaŋ uami. Lɨci Jisasɨ nudɨ abami. Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agaŋ nɨbu nameŋ abami uami. Hulaŋ iamɨgali limu hɨhɨle agɨladɨ ifɨhɨmɨmɨlaŋ aba abami uami. Hulaŋ iamɨgali daŋ namɨlaŋ naludɨ abinadinalu agɨladɨ valavala uu iamɨgali mu mu agɨladɨ sɨgɨlɨ vimɨlaŋ aba abami uami. Iamɨgali hulaŋ daŋ namɨlaŋ naludɨ muŋanadinalu agɨladɨ valavala uu hulaŋ mu mu agɨladɨ sɨgɨlɨ vimɨlaŋ aba abami uami. Namɨlaŋ mu hulaŋ dɨ akuaba akuaba agɨladɨ avi sɨgɨlɨ vimɨlaŋ aba abami uami. Namɨlaŋ analɨ ciaŋ aba aba mu hulaŋ dɨ ciaŋ hɨvɨ lamɨmɨlaŋ aba abami uami. ");
INSERT INTO ena_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Namɨlaŋ naludɨ iamiagagalinalu agɨladɨ lɨhu hɨvɨ hɨnihɨni nulɨdɨ ciaŋ agɨladɨ lubiahɨlɨhalaŋ aba abami uami. Nalusaŋ nukeŋ mavɨn hekɨlɨ hɨnilalaŋ hameŋ laci ala naludɨ isagalinalu imahalinalu agɨlasaŋ mavɨn hekɨlɨ hɨnihalaŋ aba abami uami. ");
INSERT INTO ena_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Lɨci hulaŋ mɨnibɨlɨ agaŋ Jisasɨ dɨ abami. Viaŋ Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agɨladɨ lubiahɨladamin uami. Iabi avi lubiahɨlɨlan uami. Agadɨ ala akɨakɨ saŋ tɨbɨ mɨgin uami. ");
INSERT INTO ena_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Lɨci Jisasɨ nudɨ abami. Asɨ igɨci nama huaci sɨlɨvɨ sɨbaŋ hɨniben aba uami. Nama nadɨ akuaba akuaba agɨladɨ viavɨla mutɨŋ hɨvɨ lamɨnaŋ lavavɨm uami. Lavavɨci anɨm hɨlɨcɨ agɨladɨ via labɨlavɨla hulaŋ iamɨgali limu hɨhɨle akuaba akuaba apalɨ agɨlasaŋ iguha uami. Nama hameŋ lavɨla akuaba akuaba huaci huaci Asɨ dɨ haiabɨla hɨniavɨlalɨ agɨladɨ vibanaŋ uami. Nadɨ akuaba akuaba agɨladɨ hulaŋ iamɨgali agɨlasaŋ igu fɨhalavɨla ve viaŋ hula hɨdɨha uami. ");
INSERT INTO ena_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Lɨci nudɨ akuaba akuaba huaci huaci akape sɨbaŋ hɨniavɨmi agɨlasaŋ igahɨlavɨla ma hɨjɨŋalami. La Jisasɨ dɨ vala umi. ");
INSERT INTO ena_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Lɨci cɨhu Jisasɨ nudɨ hulemɨlɨ agɨladɨ abami. Viaŋ naludɨ amɨŋ abadin uami. Hulaŋ anɨm hɨlɨcɨ akuaba akuaba akape daŋ agɨlaŋ Asɨ nulɨdɨ likɨlɨci nudɨ lɨhu hɨvɨ hɨnihɨni saŋ vɨhɨlɨfavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Lavɨla hɨve lama sabaŋ kamelɨ agasaŋ abami. Viaŋ naludɨ cɨhu abadin uami. Havɨlɨ hɨcahɨca hɨsɨŋ henaŋ agadɨ haca agaŋ nɨbu sudɨme cɨki sɨbaŋ uami. Sabaŋ kamelɨ nɨbu hekɨlɨ sɨbaŋ uami. Agadɨ ala nɨbu havɨlɨ hɨcahɨca hɨsɨŋ henaŋ agadɨ haca heŋ huaci ivouvi uami. Ivo ivo saŋ ma vɨhɨlɨfɨvi uami. Hulaŋ anɨm hɨlɨcɨ hekɨlɨ daŋ agɨlaŋ Asɨ nulɨdɨ likɨlɨci nudɨ lɨhu hɨvɨ hɨnihɨni saŋ vɨhɨlɨfavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Lɨci Jisasɨ dɨ hulemɨlɨ agɨlaŋ nudɨ ciaŋ agadɨ igahɨlavɨla abavɨmi. I uavɨmi. Hameŋ lɨci hulaŋ mu Asɨ dɨ haiabɨla uavɨla huaci hameŋ laci hameŋ laci ma hɨnibali uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Lɨhavɨci Jisasɨ nulɨdɨ igasulasula abami. Hulaŋ igavɨdaci akuaba akuaba agɨlaŋ halu me hɨniavɨlalɨ uami. Agadɨ ala Asɨ igɨdaci akuaba akuaba agɨlaŋ halu me ma hɨniavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Lɨci Pita nudɨ abami. Ci igɨnaŋ uami. Alaŋ aludɨ akuaba akuaba sɨkasɨkan agɨladɨ vala vevɨla nama hula hɨdɨlalu agasaŋ akɨ vibalu uami. ");
INSERT INTO ena_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Lɨci Jisasɨ nulɨdɨ abami. Viaŋ naludɨ amɨŋ abadin uami. Mufɨli akuaba akuaba sebɨlɨ iahavɨbali heŋ Hulaŋ dɨ Ninaŋ agaŋ ibi hekɨlɨ daŋ hɨnibali uami. Lavɨla manɨgali dɨ mɨgahɨnihɨni hɨsɨŋ uvɨ heŋ mɨgahɨnibali uami. Hadɨhu hulaŋ viaŋ hula hɨdɨlalaŋ namɨlaŋ manɨgali hɨnibalaŋ uami. Lavɨla manɨgali dɨ mɨgahɨnihɨni hɨsɨŋ uvɨ human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ agɨladɨ hɨtɨŋ hɨtɨŋ heŋ mɨgahɨnibalaŋ uami. Mɨgahɨnihɨni Isɨlaelɨ hɨdɨlɨ agɨladɨ latɨhiŋ human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ agɨladɨ hɨtɨŋ hɨtɨŋ migɨlɨbalaŋ uami. ");
INSERT INTO ena_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hulaŋ iamɨgali iasaŋ igahɨlavɨla nulɨdɨ ulaŋ pabiŋ agadɨ vala uavɨci Asɨ hɨbɨŋ nulɨsaŋ ulaŋ 100 hameŋ agɨladɨ igubali uami. Nulɨdɨ isagalinɨlu imahalinɨlu agɨladɨ vala uavɨci Asɨ hɨbɨŋ nulɨsaŋ isagali imahali 100 hameŋ agɨladɨ igubali uami. Nulɨdɨ nanadi humɨgaŋ pam agɨladɨ vala uavɨci Asɨ hɨbɨŋ nulɨsaŋ nanadi humɨgaŋ pam 100 hameŋ agɨladɨ igubali uami. Nulɨdɨ iamiagagalinɨlu agɨladɨ vala uavɨci Asɨ hɨbɨŋ nulɨsaŋ iamiagagalinɨlu 100 hameŋ agɨladɨ igubali uami. Nulɨdɨ ninanadinɨlu agɨladɨ vala uavɨci Asɨ hɨbɨŋ nulɨsaŋ ninanadi 100 hameŋ agɨladɨ igubali uami. Nulɨdɨ hualɨ pabiŋ vala uavɨci Asɨ hɨbɨŋ nulɨsaŋ hualɨ 100 hameŋ agɨladɨ igubali uami. Lɨci mufɨli avi Asɨ dɨ haiabɨla uavɨla huaci hameŋ laci hameŋ laci hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Agadɨ ala hulaŋ akape iabi neŋ hali hɨsɨŋ hɨniavadi agɨlaŋ uami. Mufɨli nɨbɨlaŋ sijaŋ sɨbaŋ hɨniavɨbali uami. Hulaŋ akape iabi neŋ sijaŋ sɨbaŋ hɨniavadi agɨlaŋ uami. Mufɨli nɨbɨlaŋ hali hɨsɨŋ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Lavɨla Jisasɨ cɨhu abami. Hulaŋ sijaŋ sɨbaŋ hɨnilalɨ agaŋ cɨhu hali hɨsɨŋ hɨnibali aba abin agaŋ nɨbu nameŋ uami. Asɨ hulaŋ iamɨgali likɨlɨci nudɨ lɨhu hɨvɨ hɨnihɨni agaŋ nɨbu hulaŋ mu lɨmɨn uain hualɨ hekɨlɨ daŋ hɨnivi agaŋ me uami. Hualɨ iaganu agaŋ cimɨdaŋ sɨbaŋ iaha uavɨla nudɨ lɨmɨn uain hualɨ agadɨ sibɨla vivi saŋ hulaŋ likɨlɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Lɨci sibɨla hɨsɨŋ hulemɨlɨ agɨlaŋ uaiaŋ pabiŋ hɨvɨ anɨm hɨlɨcɨ pabiŋ hɨlɨcɨ hameŋ vivi saŋ mavɨn hɨniavɨvi uami. Lɨhavɨci hualɨ iaganu agaŋ nulɨdɨ alialaŋ aba abɨvi uami. Lɨci cimɨdaŋ sɨbaŋ uavɨla nudɨ lɨmɨn uain hualɨ agadɨ sibɨla vihavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Vihavɨdaci uaiaŋ 9 kilokɨ hɨvɨ hualɨ iaganu agaŋ mutɨŋ sabɨlɨm heŋ uavɨla igɨci hulaŋ hɨhɨle havɨ lagulamalama hɨniavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Lɨhavɨci cɨhu nulɨdɨ nameŋ abɨvi uami. Namɨlaŋ avi uavɨla iadɨ lɨmɨn uain hualɨ sibɨla vihalaŋ aba abɨvi uami. Lɨlaŋ akuaba akuaba sibɨla vibalaŋ agasaŋ sɨhɨvia sɨbaŋ igahɨlahɨla hɨbɨŋ nalusaŋ iguben aba abɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Lɨci hulaŋ agɨlaŋ heŋ uavɨvi uami. Uavɨdaci uaiaŋ huva hɨvɨ hɨdahɨda hulaŋ hɨhɨle agɨladɨ iga iga hameŋ ala lɨvi uami. Hɨfɨlɨdaŋ uaiadi hɨvɨ avi hɨdahɨda hulaŋ hɨhɨle agɨladɨ iga iga cɨhu hameŋ laci ala lɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Lavɨla hɨfɨlɨdaŋ sɨbaŋ uaiaŋ 5 kilokɨ hɨvɨ uavɨla hulaŋ hɨhɨle havɨ lagulama hɨniavɨvi agɨladɨ igɨvi uami. Lavɨla nulɨdɨ abɨvi uami. Namɨlaŋ akɨ saŋ uaiaŋ nagadɨ hɨvɨ havɨ havɨ lagulama hɨnidalaŋ uaiaŋ ci mɨguadi aba abɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Lɨci abavɨvi uami. Aniaba hulaŋ alusaŋ sibɨla ma iguavɨci alaŋ havɨ havɨ hɨnidalu aba abavɨvi uami. Lɨhavɨci abɨvi uami. Namɨlaŋ avi uavɨla iadɨ lɨmɨn uain hualɨ sibɨla vihalaŋ aba abɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","La uaiaŋ sijaŋ sijaŋ hɨlɨdaci hualɨ iaganu agaŋ hɨmamɨgɨlɨ daŋ agadɨ abɨvi uami. Sibɨla hɨsɨŋ hulaŋ agɨladɨ abɨnaŋ vehavɨci hɨbɨŋ nulɨsaŋ anɨm hɨlɨcɨ iguha aba abɨvi uami. Hulaŋ hɨfɨlɨdaŋ sɨbaŋ hɨdɨlɨ maha sibɨla vihavi agɨlasaŋ mɨse iguha aba abɨvi uami. Igu igu via ua cimɨdaŋ sɨbaŋ hɨdɨlɨ maha sibɨla vihaviemi agɨlasaŋ sijaŋ sɨbaŋ iguha aba abɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Lɨci hulaŋ hɨfɨlɨdaŋ sɨbaŋ 5 kilokɨ hɨvɨ sibɨla vihavɨvi agɨlasaŋ anɨm hɨlɨcɨ pabiŋ lɨdɨŋ pabiŋ lɨdɨŋ nulɨsaŋ hɨtɨŋ hɨtɨŋ iguvi uami. ");
INSERT INTO ena_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Igudaci hulaŋ cimɨdaŋ sɨbaŋ hɨdɨlɨ maha sibɨla vihavɨvi agɨlaŋ hɨji nameŋ lamavɨvi uami. Alaŋ anɨm hɨlɨcɨ hekɨlɨ vibalu aba abavɨvi uami. Agadɨ ala nulɨsaŋ avi hɨlihɨli hameŋ laci ala iguvi uami. ");
INSERT INTO ena_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Lɨci hualɨ iaganu agasaŋ humɨgaŋ vɨhɨlɨ viavɨla nameŋ abavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Alaŋ cimɨdaŋ sɨbaŋ ve hɨdɨlɨ maha sibɨla hekɨlɨ vidamɨli uaiaŋ agaŋ aludɨ hɨlacabɨliemi aba abavɨvi uami. Agadɨ ala hulaŋ hɨhɨle nagɨlaŋ hɨfɨlɨdaŋ sɨbaŋ ve sibɨla vihavi aba abavɨvi uami. Hameŋ sadaŋ akɨ saŋ nama anɨm hɨlɨcɨ alusadaŋ nulɨsadaŋ hɨlihɨli laci igunaŋ aba abavɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Lɨhavɨci hualɨ iaganu agaŋ ciaŋ agadɨ igahɨlavɨla sibɨla hɨsɨŋ hulaŋ mu agadɨ nameŋ abɨvi uami. Nagɨli huaci aba abɨvi uami. Viaŋ nadɨ sɨbɨlɨ ma lamin aba abɨvi uami. Viaŋ anɨm hɨlɨcɨ pabiŋ hɨlɨcɨ agadɨ igu igu saŋ abɨlɨŋ namɨlaŋ iadɨ alia aba abiemɨlaŋ aba abɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Hameŋ sadaŋ namɨlaŋ anɨm hɨlɨcɨ nagɨladɨ viavɨla uhalaŋ aba abɨvi uami. Viaŋ iadɨ nukeŋ hɨji lubiahɨlavɨla anɨm hɨlɨcɨ hɨlihɨli laci iguin aba abɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Akuaba akuaba iadɨ nukeŋ sadaŋ viaŋ iadɨ nukeŋ hɨji lubiahɨlavɨla iadɨ anɨm hɨlɨcɨ agɨladɨ labɨlɨben aba abɨvi uami. Viaŋ akuaba akuaba huaci huaci agɨladɨ lin agasaŋ namɨlaŋ humɨgaŋ vɨhɨlɨ vimɨlaŋ aba abɨvi uami. ");
INSERT INTO ena_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Lavɨla Jisasɨ cɨhu abami. Hulaŋ iabi neŋ sijaŋ sɨbaŋ hɨniavadi agɨlaŋ mufɨli nɨbɨlaŋ hali hɨsɨŋ hɨniavɨbali uami. Hulaŋ iabi neŋ hali hɨsɨŋ hɨniavadi agɨlaŋ mufɨli sijaŋ sɨbaŋ hɨniavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisasɨ agaŋ Jelusalem haiabɨla uben aba nudɨ hulemɨlɨ human limu limu fɨhala hɨcɨ limu ahica cɨjɨŋ agɨladɨ pam likɨlavɨla uavɨmi. Uu hɨbɨ cina hɨvɨ nulɨdɨ nameŋ abami. ");
INSERT INTO ena_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ci igɨlaŋ uami. Alaŋ Jelusalem haiabɨla uadalu uami. Umɨli hulaŋ mu agaŋ Hulaŋ dɨ Ninaŋ agadɨ ilasavɨla manɨgali mɨgudɨba hɨniavɨbali agɨladɨ human hɨvɨ lamɨbali uami. Manɨgali hɨhɨle Asɨ saŋ sagalɨ igu igu hɨsɨŋ agɨladɨ manɨgali uami. Hɨhɨle Asɨ dɨ ciaŋ vɨdɨvɨdɨŋ agadɨ lamalubilubi hɨsɨŋ hulaŋ uami. Nulɨdɨ human hɨvɨ lamɨci nudɨ via ua ciaŋ hɨvɨ lama lɨbɨmɨgumɨgu abavɨbali uami. Nama hɨmɨbanaŋ aba abavɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Lavɨla nudɨ mɨŋalɨvavɨla hulaŋ hɨdɨlɨ mu mu agɨladɨ human hɨvɨ lamavɨbali uami. Lɨhavɨci nudɨ abacuvacuva vɨgɨlavɨbali uami. La kɨlɨ cɨkaŋ hɨlihua lamalama agadɨ hɨvɨ nudɨ lama henaŋ hɨvɨ ifavɨci uci hɨmɨbali uami. Hɨmavɨla anihuliŋ me hɨvɨ cɨhu hɨhi iahɨbali uami. ");
INSERT INTO ena_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedi dɨ ninaŋ ahica agɨlaŋ iamɨnɨlu hula Jisasɨ dɨ pɨŋ vehavɨmi. Vevɨla iamɨnɨlu agaŋ Jisasɨ nudɨ ciaŋ agadɨ igahɨlahɨla saŋ mavɨn ciaŋ ciaŋ abɨben aba mɨgalɨfɨlɨbami. ");
INSERT INTO ena_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Lɨci Jisasɨ iamɨgali agadɨ nameŋ abami. Nama akɨ lɨlɨ saŋ abɨnaŋ uami. Lɨci iamɨgali agaŋ nudɨ abami. Mufɨli nama manɨgali hɨniavɨla iadɨ ninaŋ ahica nagɨladɨ abɨnaŋ nadɨ mikɨ pɨŋ mɨgahɨniavɨm uami. Mu nadɨ human sɨmi kɨlikɨli hɨvɨ mɨgahɨnim uami. Mu nadɨ human sakalɨ kɨlikɨli hɨvɨ mɨgahɨnim uami. ");
INSERT INTO ena_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Lɨci Jisasɨ abami. Namɨlaŋ iadɨ abitɨhɨlaŋ agadɨ hɨdɨlɨ agadɨ namɨlaŋ ma igɨlalaŋ uami. Hulaŋ ahica namɨlaŋ avɨha avɨha viaŋ igɨben hameŋ agadɨ namɨlaŋ huaci igɨbalaŋ uami. Lɨci abavɨmi. Alaŋ huaci avɨha avɨha igɨbalu uavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Lɨhavɨci Jisasɨ nulɨdɨ nameŋ abami. Viaŋ avɨha avɨha igɨben hameŋ namɨlaŋ avi avɨha avɨha igɨbalaŋ uami. Agadɨ ala iadɨ human sɨmi kɨlikɨli sakalɨ kɨlikɨli mɨgahɨnihɨni saŋ lɨbɨmɨŋamɨŋa sibɨla nɨbu iadɨ hɨma uami. Iadɨ Iavaŋ Asɨ nukeŋ hulaŋ hɨtɨŋ hɨtɨŋ agɨlaŋ iadɨ human sɨmi kɨlikɨli mɨgahɨnihɨni saŋ ci lɨbɨmɨŋalɨ uami. Sakalɨ kɨlikɨli mɨgahɨnihɨni saŋ avi ci lɨbɨmɨŋalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jisasɨ dɨ hulemɨlɨ limu hɨhɨle human limu limu fɨhala agɨlaŋ ciaŋ agadɨ igahɨlavɨmi. Lavɨla hulaŋ ahica agɨlasaŋ humɨgaŋ vɨhɨlɨ hekɨlɨ vihavɨmi. ");
INSERT INTO ena_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Lɨhavɨci cɨhu Jisasɨ nudɨ hulemɨlɨ limu hɨhɨle agɨladɨ abɨci nudɨ pɨŋ vehavɨci abami. Hɨdɨlɨ mu mu agɨladɨ manɨgali agɨlaŋ ibi daŋ hɨnihɨni nameŋ abavɨlalɨ uami. Alaŋ nukeŋ ibi daŋ hɨnidalu aba abavɨlalɨ uami. Lɨdɨŋ hulaŋ iamɨgali agɨladɨ abavɨdaci sibɨla havɨ havɨ vihavɨlalɨ uami. Nulɨdɨ hulaŋ hekɨlɨ hekɨlɨ agɨlaŋ avi hulaŋ iamɨgali agɨladɨ vɨdɨvɨdɨŋ sɨbaŋ abavɨlalɨ uami. Aludɨ ciaŋ agɨladɨ lubiahɨlavɨbali aba ciaŋ vɨdɨvɨdɨŋ sɨbaŋ abavɨlalɨ uami. ");
INSERT INTO ena_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Agadɨ ala namɨlaŋ nɨbɨlaŋ lɨhavɨlalɨ hameŋ lɨmɨlaŋ uami. Aniaba naludɨ manɨgali hɨniben aba uami. Nɨbu naludɨ sibɨla hɨsɨŋ hulemɨlɨ me hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aniaba naludɨ hali hɨsɨŋ hɨniben aba nɨbu naludɨ sibɨla havɨ havɨ vivi hɨsɨŋ hulemɨlɨ me hɨnim uami. ");
INSERT INTO ena_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Hulaŋ dɨ Ninaŋ agaŋ avi hameŋ laci ala uami. Nɨbu hɨmamɨgɨlɨ daŋ me hɨnihɨni hulaŋ hɨhɨle agɨladɨ lɨbɨsɨlɨvɨdaci nudɨ sibɨla agɨladɨ vivi saŋ ma vemi uami. Nɨbu sibɨla hɨsɨŋ hulemɨlɨ me hɨnihɨni hulaŋ iamɨgali agɨladɨ ahɨliahuiahu sibɨla vivi saŋ vemi uami. Nɨbu hulaŋ iamɨgali akape agɨladɨ vivi saŋ hɨmɨben aba vemi uami. ");
INSERT INTO ena_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisasɨ agaŋ nudɨ hulemɨlɨ hu