﻿USE sofia;
DROP TABLE IF EXISTS sofia.empNTpo_vpl;
CREATE TABLE empNTpo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES empNTpo_vpl WRITE;
INSERT INTO empNTpo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Naãrãed̶a Ãcõrẽba bajãda idjab̶a naʌ̃ ẽjũãda osia. ");
INSERT INTO empNTpo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Maʌ̃ne naʌ̃ ẽjũãra mĩã cawaiẽ́ b̶asia idjab̶a ne neẽ́ b̶asia. Pusa nãbuada pãĩmaba pãĩsosoa ũmasia. Maʌ̃ne Ãcõrẽ Jaureda pusa ʌ̃rʌ̃ domica b̶abadjia. ");
INSERT INTO empNTpo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Maʌ̃be Ãcõrẽba jarasia: –Ʌ̃nadua.– Ara maʌ̃da ʌ̃nasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Maʌ̃ ʌ̃naara Ãcõrẽba bia unusia. Maʌ̃be Ãcõrẽba ʌ̃naara pãĩma umebemada awara b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ʌ̃naara trʌ̃ b̶ʌsia “ãsa.” Pãĩmara trʌ̃ b̶ʌsia “diamasi.” Ãcõrẽba nabema ewarid̶e mãwã osia. ");
INSERT INTO empNTpo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Maʌ̃be Ãcõrẽba jarasia: –Baido ẽsi ded̶aada b̶aya baido ab̶a ʌ̃taa wãmãrẽã, ab̶a edre b̶emãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ara mãwã jarabʌrʌba Ãcõrẽba maʌ̃ ded̶aara osia. Maʌ̃ne baidora ab̶a ʌ̃taa wãsia. Ab̶a edre b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ãcõrẽba maʌ̃ ded̶aara trʌ̃ b̶ʌsia “bajã.” Umébema ewarid̶e mãwã osia. ");
INSERT INTO empNTpo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Maʌ̃be Ãcõrẽba jarasia: –Ded̶aa edrebema baidora jũma ãbaa ũmedua ẽjũã põãsada odjamãrẽã.– Ara maʌ̃da ẽjũã põãsada odjasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Maʌ̃ra Ãcõrẽba bia unusia. Ẽjũã põãsara Ãcõrẽba trʌ̃ b̶ʌsia “egoro.” Baido ãbaa ũmenada trʌ̃ b̶ʌsia “pusa.” ");
INSERT INTO empNTpo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","12","Maʌ̃be Ãcõrẽba jarasia: –Egorod̶e ne quĩrãtanoa tununadua; chirua ta zaubari b̶eada idjab̶a nejõ bacuru sid̶a. Jũma maʌ̃ra ta zaud̶ia ara ãdji b̶ea quĩrãca tununamãrẽã.– Ara maʌ̃da egorod̶e ne quĩrãtanoa tunusid̶aa. Jũma chirua ta diabari b̶eara idjab̶a bacuru nejõ zaubari b̶ea sid̶a ãdji ta bara tunusid̶aa ara ãdji b̶ea quĩrãca tununamãrẽã. Maʌ̃ra Ãcõrẽba bia unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ũbeabema ewarid̶e mãwã osia. ");
INSERT INTO empNTpo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Maʌ̃be Ãcõrẽba jarasia: –Urua b̶eada bajãne b̶ead̶adua naʌ̃ ẽjũã ʌ̃na b̶amãrẽã idjab̶a ãsara, diamasi ume quĩrã awara b̶amãrẽã. Maʌ̃gʌba cawabi b̶aya ewarida, poada idjab̶a sãʌ̃be ewari dromada od̶ida panʌda.– ");
INSERT INTO empNTpo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ara mãwã jarabʌrʌba Ãcõrẽba ʌ̃mãdauda ãsabema carea osia. Jed̶ecoda diamasibema carea osia. Idjab̶a chĩdau sid̶a ocuasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Ãcõrẽba maʌ̃ra jũma bajãne b̶ʌcuasia naʌ̃ ẽjũã ʌ̃na b̶amãrẽã, ãsa beseamãrẽã, diamasi ʌ̃na b̶amãrẽã, idjab̶a ãsara diamasi ume quĩrã awara b̶amãrẽã. Maʌ̃ra idjia bia unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Quĩmãrẽbema ewarid̶e mãwã osia. ");
INSERT INTO empNTpo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Maʌ̃be Ãcõrẽba jarasia: –Dojãne ne jũma zocai b̶eada baraa baya. Idjab̶a ʌ̃tʌ wãb̶aribada sid̶a baraa baya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ara mãwã jarabʌrʌba Ãcõrẽba b̶eda waib̶ʌga b̶eada ocuasia. Dojãne zocai b̶eada quĩrãtanoa ocuasia. Idjab̶a i bara b̶eada quĩrãtanoa ocuasia. Maʌ̃ra idjia bia unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Maʌ̃be ãdjirãra nãwã bia jarasia: –Zocãrã yõnadua. Pusara, do sid̶a birad̶adua. Idjab̶a ĩbana sid̶a naʌ̃ ẽjũãne zocãrã yõnadua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ãcõrẽba juesumabema ewarid̶e mãwã osia. ");
INSERT INTO empNTpo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Maʌ̃be Ãcõrẽba jarasia: –Animarã quĩrãtanoa b̶eada naʌ̃ ẽjũãne baraa baya: daupẽbada animarãda, ãdji jãne wãbada animarãda, mẽãbema animarã sid̶a baraa baya.– Ara mãwã jarabʌrʌba Ãcõrẽba mẽãbema animarãda, daupẽbada animarãda, animarã ãdji jãne wãbada sid̶a quĩrãtanoa ocuasia. Maʌ̃ra idjia bia unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Maʌ̃be Ãcõrẽba jarasia: –Jãʌ̃be ẽberãda od̶adrʌ dadji quĩrãca. Maʌ̃ ẽberãba ĩbana b̶eada, animarã pusad̶e b̶eada, daupẽbada b̶eada, mẽãbema b̶eada, idjab̶a jũma ãdji jãne wãbada sid̶a poya erob̶aya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ara mãwã jarabʌrʌba Ãcõrẽba ẽberãda osia idji quĩrãca. Wãrãda idji quĩrãca osia. Dji umaquĩrã, dji wẽrã sid̶a osia. ");
INSERT INTO empNTpo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Maʌ̃be Ãcõrẽba ãdjira nãwã bia jarasia: –Warra zocãrã ununadua. Naʌ̃ ẽjũãra birad̶adua idjab̶a jũma naʌ̃ ẽjũãne b̶eara bãrã jʌwaed̶a erob̶ead̶adua. B̸eda b̶eara, ĩbana b̶eara, druabema animarã sid̶a jũma poya erob̶ead̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Maʌ̃ awara Ãcõrẽba ãdjía jarasia: –Acʌd̶adua, mʌ̃a bãrãa diaya jũma naʌ̃ ẽjũãne chirua ta bara b̶eada, jũma bacuru nejõ ta bara b̶ea sid̶a. Maʌ̃nebemada bãrãba jũma cod̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Idjab̶a animarã druabemaa, ĩbana b̶eaa, jũma animarã ãdji jãne wãbada b̶eaa bid̶a mʌ̃a chiruara diaya cod̶amãrẽã.– Ara maʌ̃da mãwã b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Maʌ̃be Ãcõrẽba idjia od̶ara jũma bio bia unusia. Seibema ewarid̶e mãwã osia. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Mãwã Ãcõrẽba bajãra, naʌ̃ ẽjũã sid̶a jũma pãrãsia. Jũma bajãne b̶eara, naʌ̃ ẽjũãne b̶ea sid̶a pãrãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Sietebema ewarid̶e jũma pãrã erob̶asia. Maʌ̃ bẽrã sietebema ewarid̶e ʌ̃nãũsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Jũma pãrãped̶a ʌ̃nãũna bẽrã, sietebema ewarira dji biara b̶ʌda b̶ʌsia jũmarãba idjía bia bed̶ea pananamãrẽã idjab̶a ʌ̃nãũ pananamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Mãwã Ãcõrẽba bajãra, naʌ̃ ẽjũã sid̶a jũma osia. Ãcõrẽba naʌ̃ ẽjũã, bajã sid̶a osi ewarid̶e, ");
INSERT INTO empNTpo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","6","chiruada põãjãrã sid̶a neẽ́ basía Ãcõrẽba naʌ̃ ẽjũãne wad̶ibid̶a cueda zebica bad̶a bẽrã. Baribʌrʌ egorod̶eba ʌ̃taa towaada odjabadjia naʌ̃ ẽjũã jũma b̶eguea oi carea. Idjab̶a ẽberãda neẽ́ basía ẽjũã oi carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Maʌ̃ne Ãcõrẽba egoro porad̶eba ẽberãda osia. Maʌ̃ ẽberã quẽbʌd̶e Ãcõrẽba jãrãpuasia ʌ̃yãba edamãrẽã. Mãwã ẽberãra zocai b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Mãwãnacarea Ãcõrẽba néu ẽjũãda ʌ̃mãdau odjabariare osia. Maʌ̃ néu ẽjũãra Edeʌ̃ abadaa. Ãcõrẽba ẽberã od̶ara néu ẽjũãne b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Mama quĩrãtanoa bacuru bia qued̶eada nejõ bia zaubadada waribisia. Maʌ̃ ẽjũã ẽsi úsia nejõ zocai b̶ai diabarida. Idjab̶a úsia nejõ crĩcha bia, crĩcha cadjirua cawabibari sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Edeʌ̃ ẽjũãne doda b̶asia maʌ̃ néu ẽjũãra jũma cũrãsa erob̶amãrẽã. Maʌ̃ dora dji taed̶aa quĩmãrẽ nẽrã b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Do nẽrã b̶ʌra ab̶a Pisoʌ̃ basía. Pisoʌ̃ra Havila druad̶e b̶ʌa. Havila druara oro bara b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Dji orora bio bia b̶ʌa. Idjab̶a ónice mõgara sid̶a bara b̶ʌa. Bacuru b̶a tũãpa b̶ʌ bedelio abada sid̶a bara b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Dewarabema dora Gihoʌ̃ abadaa. Gihoʌ̃ra Cus druad̶e b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Maʌ̃arebema dora Tigri abadaa. Maʌ̃ dora Asiria purud̶eba ʌ̃mãdau odjabariare b̶ʌa. Jĩrũarebema dora Euprate abadaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Maʌ̃ne Ãcõrẽba ẽberãra edaped̶a Edeʌ̃ néu ẽjũãne b̶ʌsia acʌ b̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Maʌ̃be Ãcõrẽba ẽberãa jara b̶ʌsia: –Jũma naʌ̃ néu ẽjũãne b̶ea nejõra bʌa jõida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Baribʌrʌ crĩcha bia, crĩcha cadjirua cawabibari nejõra jõcara b̶ʌa. Maʌ̃da jõsira ara maʌ̃ ewarid̶e bʌra wãrãda beuya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Maʌ̃be Ãcõrẽba jarasia: –Bia b̶ʌẽ́a ẽberã idub̶a b̶aida. Carebabari biada idji itea oya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Maʌ̃ne Ãcõrẽba egorod̶eba jũma animarã druabemada, jũma ĩbana sid̶a osia. Maʌ̃ animarã b̶eara ẽberãmaa enesia cãrẽ trʌ̃da ãdjiza b̶ʌcuai cawaya. Ara maʌ̃da ẽberã Adaʌ̃ba animarã b̶eara trʌ̃ b̶ʌcuasia. Animarã trʌ̃ra ãdjiza b̶esia Adaʌ̃ba trʌ̃ b̶ʌcuad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Mãwã Adaʌ̃ba daupẽbada animarãra, ĩbana bajãne wãb̶aribadara, mẽãbema animarã sid̶a jũma trʌ̃ b̶ʌcuasia. Mãwãmĩna Adaʌ̃ itea carebabari biada wad̶i neẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Maʌ̃ carea Ãcõrẽba Adaʌ̃ra bio cãĩbisia. Adaʌ̃ cãĩ b̶ʌd̶e Ãcõrẽba idji orro b̶ʌwʌrʌda ab̶a edasia. Edaped̶a waya dji djarara cara b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Maʌ̃be Ãcõrẽba Adaʌ̃ orro b̶ʌwʌrʌ edad̶ara wẽrãda osia. Oped̶a Adaʌ̃maa enesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Maʌ̃ne Adaʌ̃ba jarasia: ¡Id̶ibʌrʌ naʌ̃ra mʌ̃ orroa! Idjidrʌ wãrãda mʌ̃ djarad̶eba od̶aa. Mʌ̃a trʌ̃ b̶ʌya “wẽrã”, Ãcõrẽba idjira umaquĩrãneba od̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Maʌ̃ carea umaquĩrãba dji zezara, dji papa sid̶a ameped̶a idji quima ume ãbaa b̶eya. Mãwã cacua ab̶a b̶ʌ quĩrãca panania. ");
INSERT INTO empNTpo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Maʌ̃ne Adaʌ̃ra, dji wẽrã sid̶a ãcad̶a panasid̶aa baribʌrʌ perad̶aca basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Jũma Ãcõrẽba ocuad̶a animarã cãyãbara damada crĩcha cawaara b̶asia djãrã cũrũgai carea. Maʌ̃ damaba wẽrãa jarasia: –¿Ãcõrẽba wãrãda jarasica jũma naʌ̃ néud̶e b̶ea nejõra bãrãba jõcara panʌda?– ");
INSERT INTO empNTpo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Wẽrãba panusia: –Mãwãẽ́a. Naʌ̃ néud̶ebema nejõra daiba jõnida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Baribʌrʌ bacuru néu ẽsi nũmʌnebemada Ãcõrẽba jarasia: “Jãʌ̃gʌ nejõra jõrãnadua idjab̶a jidarãnadua. Mãwã od̶ibʌrʌ beud̶ia.”– ");
INSERT INTO empNTpo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Maʌ̃ne damaba wẽrãa jarasia: –Bãrãra beud̶aẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ãtebʌrʌ maʌ̃ nejõ jõbʌda ewarid̶e bãrãba ab̶ed̶a jũma cawad̶ia biada, cadjirua sid̶a. Mãwã Ãcõrẽ quĩrãca crĩcha cawa panania. Maʌ̃gʌra idjia cawa b̶ʌa, maʌ̃ carea bãrãa jõbi ama b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Maʌ̃ne wẽrãba unusia bacuru néu ẽsi nũmʌ nejõra biya purea jira b̶ʌda idjab̶a jõi biya quiruda. Ara maʌ̃da jõ quĩrĩãsia crĩcha cawa b̶ai carea. Maʌ̃be b̶a edaped̶a jõsia. Jõped̶a dji quimaa diasia. Maʌ̃ne idjia bid̶a jõsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ara maʌ̃da ãdjia umena ab̶ed̶a cawasid̶aa ãdjira ãcad̶a panʌda. Maʌ̃ carea higojõ queduada ĩgud̶aped̶a jʌ̃sid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Quewara cũrãdrʌbʌrʌd̶e Ãcõrẽra néu ẽjũãne nĩbasia. Adaʌ̃ba dji wẽrã bid̶a maʌ̃ ũrĩsid̶ad̶e néud̶e mĩrũsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Maʌ̃ bẽrã Ãcõrẽba Adaʌ̃ra nãwã trʌ̃sia: –¿Bʌra sãma b̶ʌ?– ");
INSERT INTO empNTpo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Adaʌ̃ba panusia: –Bʌ zebʌrʌda ũrĩsid̶e ne wayaaba mʌ̃ra mĩrũsia ãcad̶a b̶ʌ bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Maʌ̃ne Ãcõrẽba iwid̶isia: –¿Caiba jarasi bʌra ãcad̶a b̶ʌda? ¿Bʌa jõsica mʌ̃a jõrãduad̶a nejõra?– ");
INSERT INTO empNTpo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adaʌ̃ba panusia: –Bʌa mʌ̃́a wẽrã diad̶aba jõbisia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Maʌ̃ bẽrã Ãcõrẽba wẽrãa iwid̶isia: –¿Bʌa cãrẽ cãrẽã jãwã osi?– Wẽrãba panusia: –Damaba mʌ̃ra cũrũgasia. Maʌ̃ bẽrã mʌ̃a jõsia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Maʌ̃ bẽrã Ãcõrẽba damara nãwã biẽ́ jara b̶ʌsia: Bʌa jãwã cũrũgad̶a bẽrã, mʌ̃a bʌra daupẽbada animarã idjab̶a mẽãbema animarã cãyãbara biẽ́ara b̶ʌya. Nãwã b̶aya: id̶iba ʌ̃taa bʌdji jãne nĩbaya idjab̶a ewariza bʌ itera egoro pora caita b̶aya ab̶a beubʌrʌd̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Idjab̶a mʌ̃a bʌra wẽrã ume dji quĩrũda b̶ʌya. Id̶iba ʌ̃taa bʌ warrara wẽrã warra ume dji quĩrũ baya. Bʌa wẽrã warrara jĩrũgarronane caya. Baribʌrʌ idjia bʌ borora berradʌgaya. ");
INSERT INTO empNTpo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Maʌ̃ne Ãcõrẽba wẽrãa jarasia: Bʌ b̶iogoa b̶ʌd̶e mʌ̃a bʌra bia mĩgabiya. Warra tobʌrʌd̶e puad̶eba toya. Mãwã bia mĩga b̶aimĩna bʌ quima ume b̶a quĩrĩã b̶aya, baribʌrʌ idjia bʌra idji jʌwaed̶a erob̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","18","Maʌ̃ne Ãcõrẽba umaquĩrãa jarasia: Mʌ̃a bʌ́a jarasia jãʌ̃ nejõra jõrãmãrẽã. Mãwãmĩna bʌ wẽrã bed̶eada ĩjãsia. Maʌ̃ bẽrã mʌ̃a naʌ̃ ẽjũãra jũma biẽ́ b̶ʌya. Ʌrʌda, jũĩchichi sid̶a odjacuaya. Bʌra bio bia mĩga b̶aya bʌ néud̶ebemada coi carea. Idjab̶a bʌa chiruada co b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ne coi carea traja b̶ʌd̶e bʌ dratud̶e jʌa zowua nũmaya ab̶a beubʌrʌd̶aa. Bʌra egoro porad̶ebemaa. Maʌ̃ carea bʌra wayacusa egoro pora baya. ");
INSERT INTO empNTpo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adaʌ̃ba idji wẽrãra trʌ̃ b̶ʌsia Eva, idjira jũma dadji zocai b̶ea papa bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Maʌ̃be Ãcõrẽba animarã ed̶ebema wuada oped̶a ãdjía jʌ̃bisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Mãwãnacarea Ãcõrẽba jarasia: –Naʌ̃ ẽberãba jãʌ̃ nejõra jõna bẽrã biada cadjirua sid̶a jũma cawa b̶ʌa. Mãwã dadji quĩrãca b̶esia. Maʌ̃ bẽrã zocai b̶ai diabari nejõda idjía idu jõbid̶aẽ́a. Maʌ̃da jõsira beuca baya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ara maʌ̃da Ãcõrẽba ẽberãra Edeʌ̃ néu ẽjũãnebemada ãyã jʌretasia ẽjũã o b̶amãrẽã. Ãcõrẽba idjira egorod̶eba osia. Maʌ̃ bẽrã idjira b̶ʌsia egorod̶e ne u b̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ãcõrẽba ẽberãra ãyã jʌretaped̶a Edeʌ̃ néu ẽjũã ʌ̃mãdau odjabariare bajãnebema nezocarã i bara panʌda b̶ʌsia. Idjab̶a b̶ʌsia djõbada neco urua b̶ʌda, idub̶a pʌrrʌga tucua jira b̶ʌda. Maʌ̃gʌrãba zocai b̶ai diabari nejõra waga panesid̶aa ni ab̶aʌba jõrãmãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Maʌ̃be Adaʌ̃ra dji quima Eva ume cãĩsia. Evara b̶iogoa b̶eped̶a warra tosia. Maʌ̃ne Evaba jarasia: “Mʌ̃a umaquĩrã warrada erob̶esia Ãcõrẽba carebad̶a bẽrã.” Mãwã dji warrara trʌ̃ b̶ʌsia Caiʌ̃. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Mãwãnacarea dji djaba Abelda tosia. Maʌ̃ Abelera oveja daupẽbari basía. Maʌ̃ne Caiʌ̃ra ne ubari basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Mãwã panʌne ewari ab̶a Caiʌ̃ba idji néud̶ebemada Ãcõrẽa diasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Maʌ̃ne Abelba oveja zaquerã dji naãrã toped̶ad̶ada beaped̶a dji dragada Ãcõrẽa diasia. Ãcõrẽba Abelera idjia diad̶a sid̶a bia unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Baribʌrʌ Caiʌ̃da idjia diad̶a sid̶a bia unuẽ́ basía. Maʌ̃ carea Caiʌ̃ra bio quĩrũsia. Ab̶ed̶a quĩrã cadjirua nũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Maʌ̃ carea Ãcõrẽba Caiʌ̃a jarasia: –¿Cãrẽ cãrẽã quĩrũ nũmʌ? ¿Cãrẽ cãrẽã quĩrã cadjirua nũmʌ? ");
INSERT INTO empNTpo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Bʌa biada oibʌrʌ ¿bʌra b̶ʌsrid̶a b̶aẽ́ca? Baribʌrʌ bʌa biada oẽ́bʌrʌ cadjirua jʌwaed̶a b̶aya. Baribʌrʌ bʌa cadjiruara poyaida b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ewari ab̶a Caiʌ̃ba idji djabaa jarasia: “Ãyã pʌrrʌad̶e wãna.” Ara maʌ̃da wãsid̶aa. Néud̶e ãbaa nĩnane Caiʌ̃ba Abelera adua b̶ʌd̶e beatasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Maʌ̃ bẽrã Ãcõrẽba Caiʌ̃a iwid̶isia: –¿Sãma b̶ʌ bʌ djaba Abelera?– Maʌ̃ne Caiʌ̃ba panusia: –Cawaẽ́a. Mãwãra ¿mʌ̃ra idji acʌbarica?– ");
INSERT INTO empNTpo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ãcõrẽba jarasia: –¿Cãrẽ cãrẽã bʌ djabara jãwã beasi? Idji oa egorod̶e erozoad̶aba jĩgua jara b̶ʌa mʌ̃a jipa cawa omãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Bʌ djabada bead̶a bẽrã mʌ̃a bʌra biẽ́ b̶ʌya. Mʌ̃a bʌra idji oa erozoad̶amaʌba ãyã jʌretaya. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Bʌa ẽjũã obʌrʌmĩna bʌ néura bia zauca baya. Bʌra naʌ̃ ẽjũãne ara jãwã pʌrrʌa nĩbaya. Ʌ̃nãũi sid̶a neẽ́ b̶aya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Caiʌ̃ba Ãcõrẽa jarasia: –Mʌ̃ mãwã b̶aira jũmawãyã zarea b̶ʌa. Maʌ̃ra mʌ̃a droaẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Id̶i bʌa mʌ̃ra naʌ̃ druad̶ebemada ãyã jʌretabʌrʌa. Bʌ quĩrãpita mʌ̃ra wãcara b̶aya. Id̶iba ʌ̃taa mʌ̃ra naʌ̃ ẽjũãne pʌrrʌa nĩbaya drua ãĩbema quĩrãca. Bariduaba mʌ̃ra ununibʌrʌ, bead̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ãcõrẽba jarasia: –Bariduaba bʌda beaibʌrʌ, mʌ̃a idjira bʌ cãyãbara aud̶uara cawa oya.– Maʌ̃ bẽrã Ãcõrẽba Caiʌ̃ cacuad̶e sẽyãda b̶ʌsia, bariduaba maʌ̃ sẽyãda unusid̶ara Caiʌ̃ra bearãnamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ara maʌ̃da Caiʌ̃ra Ãcõrẽ quĩrãpitabemada ãyã wãped̶a Nod druad̶e b̶ad̶e wãsia. Maʌ̃ Nod druara Edeʌ̃neba ʌ̃mãdau odjabariare b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Caiʌ̃ra idji quima ume cãĩsia. Dji wẽrãra b̶iogoa b̶eped̶a Enocoda tosia. Maʌ̃ Enoco tosid̶e Caiʌ̃ba puruda o b̶asia. Dji puru trʌ̃ra dji warra trʌ̃ quĩrãca Enoco trʌ̃ b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enocora Irá zeza basía. Irára Mehujael zeza basía. Mehujaelera Metusael zeza basía. Metusaelera Lame zeza basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Maʌ̃ Lameba wẽrãda umé erob̶asia. Ab̶ara Adá abadjid̶aa, dewarabemara Zila abadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adába Jabalda tosia. Jabald̶eba yõsid̶aa wua ded̶e b̶eabadada, animarã daupẽbadarã sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Dji djaba trʌ̃ra Jubal basía. Jubald̶eba yõsid̶aa arpa zá cawa b̶eada idjab̶a chiru zá cawa b̶ea sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zilaba Tubal-Caiʌ̃da tosia. Idjia bronced̶ebemada idjab̶a jiorrod̶ebema sid̶a ne o cawa b̶asia. Tubal-Caiʌ̃ djabawẽrãra Naamá abadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ewari ab̶a Lameba idji quimarã Adáa, Zilaa bid̶a jarasia: Adá, Zila, mʌ̃ bed̶eada ũrĩnadua. Mʌ̃a ẽberã cũdra b̶ʌda beasia idjia mʌ̃ djara tud̶a carea, mʌ̃ puod̶a carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Bariduaba Caiʌ̃da beaibʌrʌ, Ãcõrẽba maʌ̃gʌra bio cawa oya. Baribʌrʌ bariduaba mʌ̃da dji cũdra carea beaibʌrʌ Ãcõrẽba maʌ̃ ẽberãra aud̶uara cawa oya. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Maʌ̃ ewarid̶e Adaʌ̃ra wayacusa dji quima ume cãĩsia. Maʌ̃be dji quimaba umaquĩrã warrada tosia. Maʌ̃ne jarasia: “Caiʌ̃ba Abel bead̶acarea Ãcõrẽba mʌ̃́a dewara warrada Abel cacuabari diasia.” Mãwã dji warrara trʌ̃ b̶ʌsia Se. ");
INSERT INTO empNTpo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Maʌ̃be Seba warrada unusia. Dji trʌ̃ra b̶ʌsia Enó. Maʌ̃ ewarid̶eba ʌ̃taa ẽberãrãba Ãcõrẽa ewari iwid̶ibʌdad̶e idji trʌ̃ra “Jehová” a panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Nama b̶ʌ́ b̶ʌa Adaʌ̃neba yõped̶ad̶ad̶ebemada. Ãcõrẽba ẽberãrã osid̶e ara idji quĩrãca osia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Dji umaquĩrã, dji wẽrã sid̶a osia. Maʌ̃ne Ãcõrẽba ãdjira yõnamãrẽã bia jara b̶ʌsia. Ãdji osi ewarid̶e ãdjira trʌ̃ b̶ʌsia “ẽberãrã.” ");
INSERT INTO empNTpo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adaʌ̃ ciento treinta poa b̶asid̶e warrada unusia ara idji quĩrãca b̶ʌda. Idjira trʌ̃ b̶ʌsia Se. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Se ununacarea Adaʌ̃ra ochociento poa b̶asia. Maʌ̃ne warrarã, wẽrãcaurã sid̶a unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Jũma ãbaa Adaʌ̃ba noveciento treinta poa unusia. Mãwã b̶ʌda jaid̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sera ciento cinco poa b̶asid̶e Enóda unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enó ununacarea Sera ochociento siete poa b̶asia. Maʌ̃ne warrarã, wẽrãcaurã sid̶a unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Jũma ãbaa Seba noveciento doce poa unusia. Mãwã b̶ʌda jaid̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enó noventa poa b̶asid̶e idji warra Cainaʌ̃da unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Cainaʌ̃ ununacarea Enóra ochociento quince poa b̶asia. Maʌ̃ne warrarã, wẽrãcaurã sid̶a unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Jũma ãbaa Enóba noveciento cinco poa unusia. Mãwã b̶ʌda jaid̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Cainaʌ̃ setenta poa b̶asid̶e idji warra Majalaleelda unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Majalaleel ununacarea Cainaʌ̃ra ochociento cuarenta poa b̶asia. Maʌ̃ne warrarã, wẽrãcaurã sid̶a unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Jũma ãbaa Cainaʌ̃ba noveciento die poa unusia. Mãwã b̶ʌda jaid̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Majalaleel sesenta y cinco poa b̶asid̶e idji warra Jaréda unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Jaré ununacarea Majalaleelera ochociento treinta poa b̶asia. Maʌ̃ne warrarã, wẽrãcaurã sid̶a unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Jũma ãbaa ochociento noventa y cinco poa unusia. Mãwã b̶ʌda jaid̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jaré ciento sesenta y dos poa b̶asid̶e idji warra Enocoda unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Maʌ̃ Enoco ununacarea Jaréra ochociento poa b̶asia. Maʌ̃ne warrarã, wẽrãcaurã sid̶a unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jũma ãbaa Jaréba noveciento sesenta y dos poa unusia. Mãwã b̶ʌda jaid̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoco sesenta y cinco poa b̶asid̶e idji warra Matusaleʌ̃da unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Matusaleʌ̃ ununacarea Enocora tresciento poa Ãcõrẽ ume jipa nĩbasia. Maʌ̃ne warrarã, wẽrãcaurã sid̶a unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Jũma ãbaa tresciento sesenta y cinco poa unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enocora ewariza Ãcõrẽ ume jipa nĩbasia. Mãwã b̶ʌd̶e nẽbasia Ãcõrẽba zocai eded̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matusaleʌ̃ ciento ochenta y siete poa b̶asid̶e idji warra Lameda unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Maʌ̃ Lame ununacarea Matusaleʌ̃ra seteciento ochenta y dos poa b̶asia. Maʌ̃ne warrarã, wẽrãcaurã sid̶a unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Jũma ãbaa noveciento sesenta y nueve poa unusia. Mãwã b̶ʌda jaid̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lame ciento ochenta y dos poa b̶asid̶e warrada unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Maʌ̃ne Lameba jarasia: “Ãcõrẽba naʌ̃ ẽjũãra biẽ́ b̶ʌsia. Maʌ̃ bẽrã dadjirã jʌwaba ẽjũã o panʌra zarea b̶ʌa, baribʌrʌ naʌ̃ warrabʌrʌ dadjirãra ʌ̃nãũbiya.” Mãwã dji warrara trʌ̃ b̶ʌsia Noé. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Maʌ̃ Noé ununacarea Lamera quiniento noventa y cinco poa b̶asia. Maʌ̃ne warrarã, wẽrãcaurã sid̶a unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Jũma ãbaa seteciento setenta y siete poa unusia. Mãwã b̶ʌda jaid̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noé quiniento poa b̶asid̶e dji warrarã Seʌ̃da, Caʌ̃da, Jape sid̶a unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Naʌ̃ ẽjũãne ẽberãrã yõsid̶ad̶e caurãda unucuasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Maʌ̃be Ãcõrẽ warrarãba maʌ̃ awẽrãrãra quĩrãwãrẽã unusid̶aa. Maʌ̃ bẽrã ãdjirãba awuabʌdada edasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","4","Edaped̶ad̶acarea warrarãda yõsid̶aa. Maʌ̃ warrarãra naʌ̃ ẽjũãne drasoa waib̶ʌa warisid̶aa. Ãdjirãra trʌ̃ b̶ʌga b̶easia maʌ̃ drõãenabema ewarid̶e, nocoarebema ewarid̶e bid̶a. Ãdjirã carea Ãcõrẽba jarasia: “Mʌ̃a ẽberãrãa ʌ̃yãba diasia zocai pananamãrẽã baribʌrʌ djara bẽrã beud̶ia. Poa ciento veintebe b̶ead̶ia.” ");
INSERT INTO empNTpo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ãcõrẽba unusia ẽberãrãba jũma naʌ̃ ẽjũãne cadjiruada jũmawãyã o panʌda. Unusia ãdjia ab̶abe cadjirua od̶idrʌ ewariza crĩcha panʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Maʌ̃ne Ãcõrẽra sopua b̶esia naʌ̃ ẽjũãne ẽberãrã od̶a carea. Idjimaarã biara b̶acasia ãdjira od̶aẽ́bara. ");
INSERT INTO empNTpo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Nãwã crĩchasia: “Mʌ̃a ẽberãrãda, animarãda, animarã ãdji jãne wãbadada, ĩbana sid̶a jũma jõbiya. Mʌ̃a ãdjira od̶aẽ́bara biara b̶acasia.” ");
INSERT INTO empNTpo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Baribʌrʌ Ãcõrẽba Noéda bia unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nama Noéd̶ebemada nẽbʌrʌ b̶ʌa. Noéra ẽberã jipa b̶asia. Ãcõrẽ ume jipa nĩbabadjia. Idji ewarid̶ebemarã tãẽna ab̶abe idjidrʌ jarad̶i neẽ́ b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noéba warrarãda ũbea unusia: Seʌ̃, Caʌ̃, idjab̶a Jape. ");
INSERT INTO empNTpo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Maʌ̃ne naʌ̃ ẽjũãne b̶eara Ãcõrẽ quĩrãpita biẽ́ duanesid̶aa baridua cadjiruara jũmawãyã o b̶ea bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ãcõrẽba naʌ̃ ẽjũã acʌbʌrʌd̶e wãrãda jũma biẽ́ b̶ʌda unusia jũma ẽberãrãba ne jũmane cadjirua o b̶ea bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Maʌ̃ carea Ãcõrẽba Noéa jarasia: –Mʌ̃a naʌ̃ ẽjũãne zocai b̶eara jũma jõbiya jũmawãyã cadjiruada o b̶ea bẽrã. Idjab̶a naʌ̃ ẽjũã sid̶a jũma ãrĩya. ");
INSERT INTO empNTpo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","16","Maʌ̃ carea bʌa jãba dromada bacuru biad̶ebemada odua. Oped̶a cãdorronaba soadua ed̶aare, dajadaare bid̶a. Maʌ̃ jãbara naʌ̃ waib̶ʌad̶e odua: dji drasoada setenta y cinco braza, dji jed̶eada doce braza, idjab̶a dji ʌ̃tʌada siete braza. Jãba dromara cʌd̶apõ ũbea odua. Cʌd̶apõza zocãrã tʌajucuadua. Maʌ̃be cʌd̶apõ ʌ̃taarebemane dajadaa acʌbadada odua. Dji ʌ̃tʌara bicaca ab̶a b̶aida b̶ʌa dji ãquid̶ad̶eba ed̶aa. Idjab̶a ed̶a wãbadada jãba droma orrod̶e odua. ");
INSERT INTO empNTpo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Pãrãnacarea mʌ̃a dopapada zebiya naʌ̃ ẽjũãra jũma ũ wãmãrẽã. Mãwã jũma zocai b̶eara mʌ̃a jõbiya. Animarã b̶eara, ẽberãrã sid̶a jũma quininia. ");
INSERT INTO empNTpo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Baribʌrʌ mʌ̃ra bʌ ume bed̶ea b̶ʌya bãrã ẽdrʌ edai carea. Bʌda, bʌ warrarãda, bʌ quimada, bʌ ãĩgurã sid̶a jãba dromane b̶adod̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Idjab̶a jũma animarãda umé uméa, dji umaquĩrãda dji wẽrãda jãba dromane ed̶a wãbid̶ia bʌ quĩrãca zocai b̶ead̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ĩbanada, dewara animarãda, animarã ãdji jãne wãbada sid̶a umé uméa bʌmaa zed̶ia bʌa ãdjirã zocai wagamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Idjab̶a cod̶i careabemada jʌrʌ peped̶a wagadua bãrãba maʌ̃ animarã bid̶a co panani carea.– ");
INSERT INTO empNTpo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ãcõrẽba jarad̶a quĩrãca Noéba jũma osia. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Mãwãnacarea Ãcõrẽba Noéa jarasia: –Naʌ̃ ẽjũãnebema ẽberãrã tãẽna mʌ̃a ab̶abe bʌdrʌ jipa unu b̶ʌa. Maʌ̃ bẽrã bʌra jũma bʌ ẽberãrã sid̶a jãba dromane ed̶a wãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Dji mʌ̃́a babue diaida b̶ʌ animarãnebemada dji umaquĩrãrãda siete idjab̶a dji wẽrãrãda siete edadua, baribʌrʌ animarã mʌ̃́a babue diacara panʌnebemada ab̶a dji umaquĩrãda, ab̶a dji wẽrãda edadua. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ara maʌ̃ quĩrãca ĩbanaza dji umaquĩrãrãda siete, dji wẽrãrãda siete edadua naʌ̃ ẽjũãne zocai b̶ead̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Siete ewari bad̶acarea mʌ̃a cuarenta ewari ãsa diamasi bid̶a cueda zebiya. Maʌ̃ba mʌ̃a naʌ̃ ẽjũãne zocai b̶ea od̶ara jũma jõbiya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ara maʌ̃da Noéba jũma osia Ãcõrẽba jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noé seisciento poa b̶asid̶e dopapaba naʌ̃ ẽjũãra jũma ũ wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Dopapa carea Noéra jãba dromane ed̶a wãsia. Dji warrarãda, dji quimada, dji ãĩgurã sid̶a ed̶a wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Jãba dromane ed̶a wãsid̶aa Ãcõrẽa babue diabada animarãda, Ãcõrẽa babue diacara panʌ animarã sid̶a. Ĩbana b̶eada, jũma ãdji jãne wãbada animarã sid̶a ed̶a wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Umé uméa dji umaquĩrãda dji wẽrãrã sid̶a jãba dromane ed̶a wãsid̶aa Ãcõrẽba Noéa jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Siete ewari bad̶acarea dopapaba ẽjũãra ũ wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noé seisciento poa b̶asid̶e ara maʌ̃ poad̶e jed̶eco ab̶a aud̶u diecisiete ewari b̶ʌd̶e ũ wãsia. Ara maʌ̃ ewarid̶e pusa edrebema baidora ʌ̃taa bogadrʌ ze nũmesia, idjab̶a cue sid̶a bio ze nũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Naʌ̃ ẽjũãne cue ze nũmasia cuarenta ewari ãsa, diamasi bid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Cue ze nũmesid̶e Noéra idji warrarã Seʌ̃, Caʌ̃, idjab̶a Jape sid̶a jãba dromane ed̶a wãsid̶aa. Noé quimada, dji ãĩgurã sid̶a ed̶a wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ãdjirã ume quĩrãtanoa animarã mẽãbemada, daupẽbadada, ãdji jãne wãbadada, ĩbana sid̶a jãba dromane ed̶a wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Animarã b̶eara jũma umé uméa Noémaa zesed̶aped̶a jãba dromane ed̶a wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Animarã b̶eaza ed̶a wãsid̶aa dji umaquĩrãda dji wẽrãda, Ãcõrẽba Noéa jarad̶a quĩrãca. Noé ed̶a wãnacarea Ãcõrẽba dji ed̶a wãbadara jũãtrʌ nũmʌsia wagai carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Cuarenta ewarid̶e dopapaba jũma ũ wãbʌrʌ basía. Ʌ̃taa ũ wãbʌrʌd̶e jãba dromara baido ʌ̃rʌ̃ ũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Dora ewariza ʌ̃taa ũ wãsia. Waib̶ʌa ũ wãsia. Maʌ̃ bẽrã jãba dromara baido ʌ̃rʌ̃ pʌrrʌga ũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Mãwã b̶ʌd̶e doba naʌ̃ ẽjũãra jũma ũ wãsia. Eya ʌ̃tʌara b̶ea sid̶a jũma ũ wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Eyara jũma ũ nũmeped̶a wad̶i braza quĩmãrẽ aud̶u ũ wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Maʌ̃ bẽrã naʌ̃ ẽjũãne zocai b̶eara jũma quinisid̶aa. Ĩbana b̶eada, daupẽbada animarãda, mẽãbemada, jũma animarã ãdji jãne wãbada sid̶a quinisid̶aa. Idjab̶a ẽberãrã sid̶a jũma quinisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Jũma druabema ʌ̃yãbabada b̶eara quinisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Wãrãda jũma druabema zocai b̶eara quinisid̶aa. Ẽberãrãda, animarãda, ãdji jãne wãbadada, ĩbana sid̶a quinisid̶aa. Mãwã Ãcõrẽba naʌ̃ ẽjũãne b̶ead̶ara jũma jõbisia. Maʌ̃ne ab̶abe panesid̶aa Noéda, idji ume jãba dromane ed̶a wãped̶ad̶a sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Naʌ̃ ẽjũãra dopapaba ciento cincuenta ewari ũ nũmasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","2","Naʌ̃ ẽjũã ũ nũmasid̶e Ãcõrẽba Noéra jũma animarã jãba dromane duanʌ sid̶a quĩrãdoaẽ́ b̶asia. Maʌ̃ bẽrã Ãcõrẽba nãũrãda jũma naʌ̃ ẽjũãne tʌbisia, pusa edrebema baidora tʌdrʌbisia, idjab̶a cue sid̶a poabisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","4","Maʌ̃ bẽrã dora pĩãca ed̶aa erru wãsia. Cue zesi ewarid̶eba ciento cincuenta ewari bad̶acarea jãba dromara Ararat eyaid̶a b̶ʌ druad̶e poa b̶esia. Cue zesi poad̶e sei jed̶eco aud̶u diecisiete ewari b̶ʌd̶e mãwã poasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Baribʌrʌ wad̶ibid̶a dora erru b̶asia. Pĩãca erru wãne diebema jed̶eco nabema ewarid̶e waabema eya borora odjacuasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Cuarenta ewari bad̶acarea Noéba jãba dromane dajadaa acʌbada od̶ara ewasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ewaped̶a ĩbana ne mĩguia cobarida ẽdrʌbisia egoro põãsada unui cawaya. Maʌ̃ ĩbanara wãped̶a waa zeẽ́ basía, ãtebʌrʌ pʌrrʌa wãb̶ari nĩbabadjia do errubʌrʌmisa. ");
INSERT INTO empNTpo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Mãwã b̶ʌd̶e Noéba puchirãda wãbisia dora errusi cawaya. ");
INSERT INTO empNTpo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Maʌ̃ puchirãra jãba dromanaa waya jẽda zesia sãma b̶arida unuẽ́ bẽrã. Maʌ̃be Noéba puchirãra idji jʌwaba edaped̶a jãba dromane ed̶a b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Siete ewari jʌ̃ãped̶a Noéba wayacusa puchirãra jãba dromaneba wãbisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Queubʌrʌd̶e puchirãra waya jẽda zesia. Maʌ̃ne dji quid̶ad̶e olivo bacuru queduada enesia. Maʌ̃neba Noéba cawasia ẽjũã ũ nũmanara wãrãda errubʌrʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Waya siete ewari jʌ̃ãped̶a Noéba wayacusa puchirãra wãbisia. Maʌ̃ne puchirãra waa Noémaa zeẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noé 601 poa b̶asid̶e naʌ̃ ẽjũãne dora jũma errusia. Ara maʌ̃ poad̶e dji nabema jed̶ecod̶e nabema ewarid̶e Noéba jãba droma de ẽcarrara ogapetasia. Maʌ̃ne ẽjũãra põãsa b̶ʌda unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Jed̶eco ab̶a aud̶u veintisiete ewari b̶ʌd̶e ẽjũãra wãrãda bio põãsa b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Maʌ̃bebʌrʌ Ãcõrẽba Noéa jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","–Bʌra, bʌ quima, bʌ warrarã, bʌ ãĩgurã sid̶a jãba dromaneba ẽdrʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Idjab̶a ẽdrʌbigadua jũma animarã bʌ ume duanʌra: ĩbanada, animarã daupẽbadada, animarã ãdji jãne wãbada sid̶a jũma naʌ̃ ẽjũãne wãnaped̶a yõnamãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ara maʌ̃da Noéra, dji quima, dji warrarã, dji ãĩgurã sid̶a ẽdrʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Idjab̶a jãba dromaneba ẽdrʌsid̶aa jũma animarã daupẽbadada, mẽãbemada, ãdji jãne wãbadada idjab̶a wãb̶aribada sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Maʌ̃be Noéba mõgarada ʌ̃tʌ pã buesia animarã Ãcõrẽa babue diai carea. Mãwã oped̶a Ãcõrẽa babue diaida b̶ʌ animarãda, ĩbana sid̶a ab̶a ab̶a beacuasia. Beacuaped̶a mõgara ʌ̃tʌ pã bued̶a ʌ̃rʌ̃ Ãcõrẽa babue diasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Maʌ̃ babue diad̶ara Ãcõrẽba bia unusia. Maʌ̃ne jarasia: –Id̶iba ʌ̃taa mʌ̃a naʌ̃ ẽjũãra waa biẽ́ b̶ʌẽ́a, ẽberãrãba caibe ed̶aʌba ãdji sod̶e cadjirua od̶idrʌ crĩcha b̶eamĩna. Idjab̶a mʌ̃a jũma zocai b̶eara waa quinibiẽ́a mʌ̃a od̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Naʌ̃ ẽjũã b̶ʌmisa ẽberãrãra ne u panania, ne ewa panania. Ewari jʌ̃wʌ̃rʌ̃ãra, ewari cũrãsa sid̶a b̶aya. Doid̶aada, poa sid̶a b̶aya. Ãsa, diamasi sid̶a b̶aya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Maʌ̃be Ãcõrẽba Noéa, dji warrarãa bid̶a nãwã bia jarasia: –Warra zocãrã yõnadua. Naʌ̃ ẽjũãra jũma birad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Jũma animarã naʌ̃ ẽjũãne b̶eaba bãrãra wayad̶ia. Ĩbanara, animarã druabemara, pusad̶ebema sid̶a jũma bãrã jʌwaed̶a b̶ead̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Mʌ̃a naẽna chiruada, nejõ sid̶a cod̶amãrẽã diasia. Ara maʌ̃ quĩrãca id̶i mʌ̃a jũma animarã b̶ea sid̶a diabʌrʌa cod̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Baribʌrʌ animarã oara cocara panʌa, oad̶eba jũmarãda zocai duanʌ bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ẽberãba wa animarãba ẽberãda beaibʌrʌ, mʌ̃a cawa oya. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Mʌ̃a ẽberãra ara mʌ̃dji quĩrãca osia. Maʌ̃ carea bariduada mĩã beaibʌrʌ, bãrã bororãba maʌ̃ ẽberãra beabid̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Mʌ̃a bãrãa jaraya: warra zocãrã yõnadua. Naʌ̃ ẽjũãra jũma birad̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Maʌ̃ awara Ãcõrẽba Noéa, dji warrarãa bid̶a nãwã jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","10","–Ũrĩnadua, mʌ̃a bed̶eada b̶ʌya bãrã ume, bãrãneba yõbʌdarã ume bid̶a, jũma animarã bãrã ume jãba dromaneba ẽdrʌped̶ad̶a ume bid̶a. Animarã daupẽbada, mẽãbema, ĩbana, jũma naʌ̃ ẽjũãne b̶ea animarã ume mʌ̃a bed̶eada b̶ʌya. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Mʌ̃a bed̶ea b̶ʌbʌrʌra naʌ̃gʌa: naʌ̃ ẽjũãne zocai b̶eara waa dopapaba jõbiẽ́a. Waa naʌ̃ ẽjũãra ũ wãẽ́a naʌ̃ ẽjũãne b̶ea quininamãrẽã. Mʌ̃a bed̶ea b̶ʌd̶ara wãrãda mãwã b̶aya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Maʌ̃ awara Ãcõrẽba jarasia: –Mʌ̃a bãrã ume, bãrãneba yõbʌdarã ume, animarã ume bid̶a bed̶ea b̶ʌd̶ara jõca baya. Maʌ̃ carea mʌ̃a sẽyãda jʌ̃rãrãne jira b̶ʌbʌrʌa cawad̶amãrẽã mʌ̃a naʌ̃ ẽjũãne b̶ea ume bed̶ea b̶ʌd̶ara wãrãda mãwã b̶aida. Maʌ̃ sẽyãra eumaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Mʌ̃a jʌ̃rãrã zebibʌrʌd̶e mʌ̃ eumara odjabari baya. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Maʌ̃gʌd̶eba mʌ̃a quĩrãneba b̶aya mʌ̃a bãrã ume animarã ume bid̶a bed̶ea b̶ʌd̶ara. Waa dopapara wãbiẽ́a naʌ̃ ẽjũãne b̶ea quinibi carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Euma jʌ̃rãrãne jira b̶ʌ unubʌrʌd̶e mʌ̃a quĩrãneba b̶aya jũma naʌ̃ ẽjũãne zocai b̶ea ume bed̶ea b̶ʌd̶ara. Maʌ̃ra jõca baya. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Wãrãda eumaba quĩrãnebabi b̶aya mʌ̃a jũma naʌ̃ ẽjũãne zocai b̶ea ume bed̶ea b̶ʌd̶ara.– Ãcõrẽba Noéa mãwã jarasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noé warrarã jãba dromaneba ẽdrʌped̶ad̶ara Seʌ̃, Caʌ̃, idjab̶a Jape basía. Caʌ̃ra Canaaʌ̃ zeza basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Noé warrarãra ũbea panasid̶aa, baribʌrʌ ãdjid̶eba yõped̶ad̶arãba naʌ̃ ẽjũãra wayacusa birasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Maʌ̃be Noéba peada oped̶a uvada úsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ewari ab̶a Noéba uva b̶a aseada do b̶asia. Maʌ̃ba idjira beu b̶esia. Maʌ̃ bẽrã idji dejãne ãcad̶a tab̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Mãwã tab̶ʌd̶e dji warra Caʌ̃da ed̶a zesia. Caʌ̃ra Canaaʌ̃ zeza basía. Maʌ̃ne Caʌ̃ba idji zeza ãcad̶a tab̶ʌda unuped̶a idji djabarã dajadaare panʌ́a jarad̶e wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Maʌ̃ carea Seʌ̃ba Jape bid̶a borob̶ada ab̶a edasid̶aa. Maʌ̃ borob̶ara ãdji equiad̶e b̶ʌd̶aped̶a ãdaunaa wãsid̶aa ãdji zezamaa. Maʌ̃be araa acʌd̶aẽ́ ãdji zezara ãnẽb̶ari b̶ʌsid̶aa. Mãwã ãdji zeza cacuara ununaẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noé quĩrã bad̶acarea cawasia idji warra tẽãbema Caʌ̃ba od̶ara. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Maʌ̃ carea jarasia: Caʌ̃ warra Canaaʌ̃ra mʌ̃a biẽ́ jara b̶ʌya. Canaaʌ̃ra idji zeza djabarã nezoca ed̶aara b̶ʌda b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Mãwã jarad̶acarea Noéba idji warrarã Seʌ̃ra Jape sid̶a nãwã bia jara b̶ʌsia: Mʌ̃ Ãcõrẽba Seʌ̃ra bia b̶ʌya. Canaaʌ̃ra Seʌ̃ nezoca baya. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Japera Ãcõrẽba dji dromada b̶ʌya. Idji djaba Seʌ̃ ume necai b̶aya. Canaaʌ̃ra idji nezoca baya. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Dopapa wãnacarea Noéra 350 poa b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Mãwã 950 poa b̶asid̶e jaid̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Dopapa wãnacarea Noé warrarã Seʌ̃ba, Caʌ̃ba, Jape bid̶a warrarãda unucuasid̶aa. Nama b̶ʌ́ b̶ʌa ãdjid̶eba yõped̶ad̶ad̶ebemada. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Japed̶eba yõped̶ad̶ara naʌ̃gʌrã basía: Gomer, Magog, Madai, Javaʌ̃, Tubal, Mesec, Tiras sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Jape warra Gomerd̶eba yõped̶ad̶ara naʌ̃gʌrã basía: Asquenaz, Ripat, Togarmá sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Jape warra Javaʌ̃neba yõped̶ad̶ara naʌ̃gʌrã basía: Elisá, Tarsi, Quitiʌ̃, Rodaniʌ̃ sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Javaʌ̃neba yõped̶ad̶ara pusa icawa drua osid̶aa. Maʌ̃ne jũma Jape warrarãba ãdjirãza puruda osid̶aa idjab̶a ãdji puruza ãdji quĩrãmera awara awara bed̶ea b̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Caʌ̃neba yõped̶ad̶ara naʌ̃gʌrã basía: Cus, Mizraiʌ̃, Put, Canaaʌ̃ sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Caʌ̃ warra Cusd̶eba yõped̶ad̶ara naʌ̃gʌrã basía: Sebá, Havila, Sabtá, Raamá, Sabteca sid̶a. Raamáneba yõped̶ad̶ara Chebá idjab̶a Dedaʌ̃ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cusba idjab̶a Nimroda unusia. Maʌ̃ Nimrora naʌ̃ ẽjũãne nabema ẽberã dji droma basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nimrora mẽã wãi carea dji bia basía Ãcõrẽba mãwã quĩrĩãna bẽrã. Maʌ̃ bẽrã ẽberãrãba jarabadjid̶aa: “Nimro quĩrãca jãʌ̃ ẽberãda mẽã wãi carea dji biaa, Ãcõrẽba mãwã quĩrĩã b̶ʌ bẽrã.” ");
INSERT INTO empNTpo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Idji jʌwaed̶a erob̶asia puru dromarãda. Naãrã Sinar druad̶e erob̶asia Babelda, Erecoda, Acada, Calne sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Mamaʌba Asiria druad̶aa wãsia. Mama puru osia Niniveda, Rehoboda, Cala sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Idjab̶a Reseʌ̃ puru dromada osia Ninive idjab̶a Cala ẽsi. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Caʌ̃ warra Mizraiʌ̃neba yõsid̶aa naʌ̃gʌrãda: Ludiʌ̃, Anamiʌ̃, Lehabiʌ̃, Naptuhiʌ̃, ");
INSERT INTO empNTpo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusiʌ̃, Casluhiʌ̃, Captoriʌ̃ sid̶a. Captoriʌ̃neba pilisteorãda yõsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Caʌ̃ warra Canaaʌ̃ba idji warra iwina Sidoʌ̃da unusia. Maʌ̃are unusia Het. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Idjab̶a Canaaʌ̃neba yõsid̶aa jebuseorãda, amorreorãda, gergeseorãda, ");
INSERT INTO empNTpo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","heveorãda, araceorãda, sineorãda, ");
INSERT INTO empNTpo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","arvadeorãda, zemareorãda, hamateorã sid̶a. Canaaʌ̃neba yõped̶ad̶aba puru zocãrã o wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Naãrã ãdji druara b̶asia Sidoʌ̃ purud̶eba ab̶a Gaza purud̶aa idjab̶a Guerar caita bid̶a. Maʌ̃ awara ãdji puru Sodomada, Gomorrada, Admada, Zeboiʌ̃da, Lasa sid̶a ãdji drua daucha icawa panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Jũma maʌ̃gʌrãra Caʌ̃neba yõsid̶aa. Ãdjirãza ãdji ẽberãrãra erob̶easia, ãdji bed̶eara quĩrã awara b̶easia, ãdji druara awara erob̶easia, idjab̶a ãdji puru sid̶a awara erob̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Seʌ̃ra Jape djaba dji nabema basía. Seʌ̃ bid̶a warrarãda unusia. Hebere warrarãda jũma Seʌ̃neba yõsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Seʌ̃neba yõped̶ad̶ara naʌ̃gʌrã basía: Elaʌ̃, Asur, Arpaxa, Lud, Araʌ̃ sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Seʌ̃ warra Araʌ̃neba yõped̶ad̶ara naʌ̃gʌrã basía: Uz, Hul, Gueter, Mas sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Seʌ̃ warra Arpaxaba Salada unusia. Salara Hebere zeza basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Hebereba warrarãda umé unusia. Ab̶abemara trʌ̃ b̶ʌsid̶aa Pele, idji ewarid̶e ẽberãra druaza ãyã wãbʌrʌsid̶a bẽrã. Pele djabara Joctaʌ̃ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joctaʌ̃neba yõped̶ad̶ara naʌ̃gʌrã basía: Almodad, Selep, Hazar-mavet, Jerá, ");
INSERT INTO empNTpo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoraʌ̃, Uzal, Dicla, ");
INSERT INTO empNTpo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sebá, ");
INSERT INTO empNTpo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opir, Havila, Jobá sid̶a. Jũma maʌ̃gʌrãra Joctaʌ̃ warrarã basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ãdjirãba birasid̶aa Mesá purud̶eba Sepa ẽjũã eyaid̶a b̶ʌd̶aa. Separa Mesád̶eba ʌ̃mãdau odjabariare b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Jũma maʌ̃gʌrãra Seʌ̃neba yõped̶ad̶arã basía. Ãdjirãza ãdji ẽberãrãra erob̶easia, ãdji bed̶eara quĩrã awara b̶easia, ãdji druara awara erob̶easia, idjab̶a ãdji puru sid̶a awara erob̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Jũma maʌ̃gʌrãra Noé warrarãneba yõsid̶aa. Dopapa wãnacarea ãdjirãra ãyã wãbʌrʌd̶aped̶a ãdjiza druada osid̶aa. Mãwã jũma naʌ̃ ẽjũãne duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ẽberãrã druaza wãbʌrʌd̶i naẽna jũmarãda ab̶ari bed̶ead̶e bed̶eabadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ãdjirãra arima pananaca basía. Maʌ̃ba ʌ̃mãdau odjabariare pʌrrʌa nĩnane Sinar ẽjũãne jũẽne wãsid̶aa. Maʌ̃ ẽjũãne jewed̶ada ununaped̶a mama panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ewari ab̶a ãbaa nãwã bed̶eadruasid̶aa: “Egoroda mõgara quĩrãca od̶aped̶a tʌbʌd̶e bád̶adrʌ de od̶i carea.” Ara maʌ̃da egorora mõgara quĩrãca od̶aped̶a básid̶aa mõgarara neẽ́ bad̶a bẽrã. Maʌ̃be cãdorronada edasid̶aa maʌ̃ mõgara quĩrãca od̶ara carad̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Maʌ̃be jarasid̶aa: –Jãʌ̃be puruda od̶adrʌ. Idjab̶a de ʌ̃tʌ drasoga b̶ʌda od̶ia. Dji de borora ab̶ed̶a bajãnaa tẽũbid̶ia. Mãwã osid̶ara dadjirãra trʌ̃ b̶ʌga b̶ead̶ia idjab̶a ni ab̶aʌba dadjirãra namabemada ãyã memenebid̶aẽ́a druaza wãnamãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ẽberãrãba puru idjab̶a de ʌ̃tʌ drasoga b̶ʌ o panʌra Ãcõrẽba bajãneba acʌd̶e zesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Maʌ̃ne Ãcõrẽba jarasia: –Ãdjirãra jũma ãbaa duanʌa idjab̶a ab̶ari bed̶ead̶e bed̶eabadaa. Maʌ̃ bẽrã jʌwa b̶ʌsid̶aa jãʌ̃ de drasoga b̶ʌra od̶i carea. Maʌ̃ba bariduada o quĩrĩã panʌbʌrʌ poya od̶ia. Dadjia mãwã iduaribid̶aẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Biara b̶ʌa dadjira wãnaped̶a ãdji bed̶eara quĩrãtanoa bed̶eabid̶ida ara ãdub̶a cawa ũrĩnaẽ́ duanenamãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","9","Ara maʌ̃da Ãcõrẽba jũma naʌ̃ ẽjũãne b̶ea ẽberãrãra quĩrãtanoa bed̶eabisia cawa ũrĩrãnamãrẽã. Mãwã dji puru trʌ̃ra b̶esia Babel. Maʌ̃ bẽrã ẽberãrãba puru o pananara idu b̶ʌsid̶aa. Mãwã Ãcõrẽba ãdjirãra mamaʌba druaza wãbʌrʌbigasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Nama b̶ʌ́ b̶ʌa Seʌ̃neba yõped̶ad̶ad̶ebemada. Dopapa wãnacarea poa umé b̶ʌd̶e, Seʌ̃ 100 poa b̶asid̶e, dji warra Arpaxada unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Maʌ̃ Arpaxa ununacarea Seʌ̃ra 500 poa b̶asia. Maʌ̃ne warrarã, wẽrãcaurã sid̶a unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpaxa 35 poa b̶asid̶e dji warra Salada unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Maʌ̃ Sala ununacarea Arpaxara 403 poa b̶asia. Maʌ̃ne warrarã, wẽrãcaurã sid̶a unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sala 30 poa b̶asid̶e dji warra Hebereda unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Maʌ̃ Hebere ununacarea Salara 403 poa b̶asia. Maʌ̃ne warrarã, wẽrãcaurã sid̶a unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Hebere 34 poa b̶asid̶e dji warra Peleda unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Maʌ̃ Pele ununacarea Heberera 430 poa b̶asia. Maʌ̃ne warrarã, wẽrãcaurã sid̶a unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pele 30 poa b̶asid̶e dji warra Reúda unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Maʌ̃ Reú ununacarea Pelera 209 poa b̶asia. Maʌ̃ne warrarã, wẽrãcaurã sid̶a unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reú 32 poa b̶asid̶e dji warra Seruda unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Maʌ̃ Seru ununacarea Reúra 207 poa b̶asia. Maʌ̃ne warrarã, wẽrãcaurã sid̶a unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seru 30 poa b̶asid̶e dji warra Nacoda unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Maʌ̃ Naco ununacarea Serura 200 poa b̶asia. Maʌ̃ne warrarã, wẽrãcaurã sid̶a unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naco 29 poa b̶asid̶e dji warra Tareda unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Maʌ̃ Tare ununacarea Nacora 119 poa b̶asia. Maʌ̃ne warrarã, wẽrãcaurã sid̶a unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tare 70 poa b̶asid̶e dji warrarã Abraʌ̃da, dewarabema Nacoda, Haraʌ̃ sid̶a unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Nama b̶ʌ́ b̶ʌa Tared̶eba yõped̶ad̶ad̶ebemada. Tareba naʌ̃ warrarãda unusia: Abraʌ̃da, Nacoda, Haraʌ̃ sid̶a. Maʌ̃ Haraʌ̃ra Lo zeza basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haraʌ̃ra idji toped̶ad̶a puru Ur abadad̶e Caldea druad̶e dji zeza na jaid̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abraʌ̃ra Naco sid̶a quima barasid̶aa. Nacoba Milcada edasia. Milcara Haraʌ̃ cau basía, Iscá djabawẽrã basía. Maʌ̃ne Abraʌ̃ba Saraida edasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Maʌ̃ Saraira warra neẽ́ b̶asia warra toca bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Abraʌ̃ zeza Tarera caldeorã puru Urd̶eba ẽdrʌsia Canaaʌ̃ druad̶aa wãi carea. Idji warra Abraʌ̃da, idji wiuzaque Loda, idji ãĩgu Sarai sid̶a edesia. Baribʌrʌ Haraʌ̃ purud̶e jũẽne wãnaped̶a mama panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tare 205 poa b̶asid̶e Haraʌ̃ purud̶e jaid̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ewari ab̶a Ãcõrẽba Abraʌ̃a jarasia: –Bʌ druara, bʌ ẽberãra, bʌ zeza ded̶ebemarã sid̶a ameped̶a wãdua. Mʌ̃a druada bʌ́a acʌbiya mamaa wãmãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Bʌd̶eba puru dromada mʌ̃a yõbiya, bʌra bia b̶ʌya, trʌ̃ b̶ʌga b̶ʌya, idjab̶a bʌd̶eba dewararãda bia duanania. ");
INSERT INTO empNTpo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Bʌ carebabʌdara mʌ̃a carebaya. Bʌ biẽ́ obʌdara mʌ̃a biẽ́ b̶ʌya. Bʌd̶eba mʌ̃a naʌ̃ ẽjũãne b̶ea purura jũma carebaya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ara maʌ̃da Abraʌ̃ra wãsia Ãcõrẽba jarad̶a quĩrãca. Lo sid̶a idji ume wãsia. Haraʌ̃ purud̶eba ẽdrʌsid̶e Abraʌ̃ra 75 poa b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abraʌ̃ba idji quima Saraida, idji tẽãbea Loda, ne jũma idjia erob̶ʌ sid̶a edesia. Idji nezocarã Haraʌ̃ne edad̶a sid̶a edesia. Haraʌ̃neba ẽdrʌd̶aped̶a wãsid̶aa. Wãbʌdad̶e Canaaʌ̃ druad̶e jũẽsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Maʌ̃ ewarid̶e cananeorãda maʌ̃ druad̶e duanasid̶aa. Abraʌ̃ra Canaaʌ̃ druad̶e nĩne Siqueʌ̃ purud̶e jũẽne wãsia, Moré bacuru droma nũmʌma. ");
INSERT INTO empNTpo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Mama Ãcõrẽra Abraʌ̃ma odjaped̶a nãwã jarasia: “Mʌ̃a naʌ̃ ẽjũãra bʌd̶eba yõbʌdarãa diaya.” Maʌ̃be Abraʌ̃ba mõgarada ʌ̃tʌ pã buesia ara maʌ̃ Ãcõrẽ idjima odjad̶aa bia bed̶eai carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Mãwãnacarea Abraʌ̃ra Beteld̶eba ʌ̃mãdau odjabariare b̶ʌ eyad̶aa wãsia. Mama idji wua dera osia. Idji wua demaʌba Betelera ʌ̃mãdau b̶aebariare b̶asia. Ʌ̃mãdau odjabariare Hai puruda b̶asia. Idji wua de caita wayacusa mõgarada ʌ̃tʌ pã buesia Ãcõrẽa ewari iwid̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Mamaʌba Abraʌ̃ra ʌ̃nãũ eda wãsia ab̶a Negue abada ẽjũãnaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Maʌ̃ ewarid̶e jũma Canaaʌ̃ druad̶e jarrabada zesia. Maʌ̃ne Abraʌ̃ra Egiptod̶aa b̶ad̶e wãsia cod̶ira ab̶ed̶a neẽ́ bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Egiptod̶e jũẽbod̶od̶e Abraʌ̃ba dji quima Saraia jarasia: –Bʌra wãrãda wẽrã quĩrãwãrẽã b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Egiptod̶ebemarãba bʌ unubʌdad̶e jarad̶ia: “Jãʌ̃ra idji quimaa.” Maʌ̃ bẽrã mʌ̃ra bead̶ia. Baribʌrʌ bʌra zocai b̶ʌd̶ia edad̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Maʌ̃ba mʌ̃ quĩrã djuburia jaradua bʌra mʌ̃ djabawẽrãda. Mãwãra mʌ̃ra bead̶aẽ́a, ãtebʌrʌ bʌd̶eba mʌ̃ra bia b̶eya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abraʌ̃ jũẽnacarea Egiptod̶ebemarãba unusid̶aa idji quima Saraira quĩrãwãrẽã b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Dji dromarã bid̶a unusid̶aa Saraira wãrãda bio quĩrãwãrẽã b̶ʌda. Maʌ̃ bẽrã ãdjia Egiptod̶ebema boroa Saraid̶ebemada bia jarasid̶aa. Ara maʌ̃da ãdji boroba Saraira idji ded̶aa edebisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Sarai carea Egiptod̶ebema boroba Abraʌ̃ra bia osia. Abraʌ̃a diacuasia ovejada, pacada, burroda, nezoca umaquĩrãda, nezoca wẽrãda, cameyo sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Baribʌrʌ Abraʌ̃ quima Sarai carea Ãcõrẽba dji borora, idji de dromane panabada sid̶a cacua biẽ́ b̶ʌcuasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","19","Maʌ̃neba dji boroba cawasia Saraira Abraʌ̃ quimada. Maʌ̃ bẽrã Abraʌ̃ra trʌ̃biped̶a jarasia: –¿Cãrẽ cãrẽã mʌ̃́a jaraẽ́ basi Saraira bʌ quimada? ¿Cãrẽ cãrẽã bʌ djabawẽrãana asi? Mʌ̃a bʌ quimara berara edasia. ¿Cãrẽ cãrẽã mʌ̃ra jãwã osi? Za b̶ʌa bʌ quimara. Edaped̶a isabe wãdua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Maʌ̃ bẽrã dji boroba idji zarrarãa jarasia Abraʌ̃ra idji quima ume ãyã eded̶amãrẽã. Jũma ãdjia eropanʌ sid̶a edebisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Mãwãnacarea Abraʌ̃ra dji quima ume Egiptod̶eba jẽda wãsia Negue ẽjũãnaa. Jũma idjia erob̶ʌra edesia. Idji tẽãbea Lo sid̶a idji ume wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Maʌ̃ne Abraʌ̃ba paratada, oro sid̶a waib̶ʌa erob̶asia. Animarã sid̶a zocãrã erob̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Maʌ̃be Negued̶eba jẽda ʌ̃nãũ eda wãsia idji wua de erob̶ad̶amaa, Betel puru idjab̶a Hai puru ẽsi. ");
INSERT INTO empNTpo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Idjia mõgara ʌ̃tʌ pã bued̶ama jũẽped̶a Ãcõrẽa ewari iwid̶isia. ");
INSERT INTO empNTpo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Maʌ̃ne Lora Abraʌ̃ ume b̶asia. Idjia bid̶a ovejada, paca sid̶a zocãrã erob̶asia. Wua deda zocãrã erob̶asia idji ẽberãrã itea, idji nezocarã itea bid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Baribʌrʌ Abraʌ̃ra Lo sid̶a bio bara panʌ bẽrã ẽjũãba araẽ́ basía. Maʌ̃ carea ab̶ari ẽjũãne ãbaa poya pananaẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Maʌ̃ awara Abraʌ̃ animarã wagabadada Lo animarã wagabada ume ijarabadjid̶aa. Idjab̶a cananeorãda, perezeorã sid̶a mama b̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Maʌ̃ bẽrã Abraʌ̃ba Loa jarasia: –Dadjira ab̶ari ẽberãrã bẽrã bia b̶ʌẽ́a ijarad̶ida; bia b̶ʌẽ́a bʌ animarã wagabadara mʌ̃ animarã wagabada ume ijara pananida. ");
INSERT INTO empNTpo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Maʌ̃ bẽrã mʌ̃a bed̶ea djuburiaya bʌra awara wãmãrẽã. Naʌ̃ druad̶e ẽjũã baraa. Bʌabʌrʌ cawa b̶ʌa sãmaa wãida. Bʌda jʌwa acʌd̶aa wãibʌrʌ, mʌ̃ra jʌwa arad̶aa wãya. Bʌda jʌwa arad̶aa wãibʌrʌ, mʌ̃ra jʌwa acʌd̶aa wãya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Maʌ̃ne Loba Jordaʌ̃ do jewed̶ada jũma unusia ab̶a Zoar purud̶aa. Maʌ̃ jewed̶ad̶e dji ẽjũãra bia b̶asia Ãcõrẽ néu b̶ad̶a quĩrãca idjab̶a Egipto drua quĩrãca. Maʌ̃ jewed̶ara mãwã b̶asia Ãcõrẽba Sodoma puruda Gomorra puru sid̶a babuei naẽna. ");
INSERT INTO empNTpo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","12","Maʌ̃ bẽrã Loba Jordaʌ̃ do jewed̶ara jũma edasia. Maʌ̃be ʌ̃mãdau odjabariare ed̶aa wãsia. Abraʌ̃ra Canaaʌ̃ eyaid̶a b̶ʌ ẽjũãne b̶esia. Mãwã ãdjira awara wãsid̶aa. Maʌ̃ne Lora puru jewed̶ad̶e b̶ea caita b̶esia. Idji wua dera osia Sodoma puru caita. ");
INSERT INTO empNTpo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodomanebemarãra dji cadjiruarã basía. Ãdjirãba Ãcõrẽ quĩrãpita cadjiruada awua obadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lo Abraʌ̃ umebemada awara wãnacarea Ãcõrẽba Abraʌ̃a jarasia: –Jãʌ̃be bʌdji b̶ʌmaʌba acʌdua jʌwa acʌd̶aa, jʌwa arad̶aa, ʌ̃mãdau odjabarid̶aa idjab̶a ʌ̃mãdau b̶aebarid̶aa bid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Jũma naʌ̃ ẽjũãra mʌ̃a bʌ́a, bʌd̶eba yõbʌdarãa bid̶a diaya ewariza bãrãne bamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Mʌ̃a bʌ warrarãra zocãrã yõbiya. Egoro pora poya juachad̶aca quĩrãca bʌ warrarã sid̶a poya juachad̶aca baya. ");
INSERT INTO empNTpo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Mʌ̃a bʌ́a naʌ̃ ẽjũãra diai bẽrã dji drasoara dji jed̶ea sid̶a acʌd̶e wãdua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ara maʌ̃da Abraʌ̃ba idji wua dera ẽrãped̶a Mamre abada ẽjũãne b̶ad̶e wãsia. Mamre ẽjũãra bacuru dromaid̶a b̶ʌa idjab̶a Hebroʌ̃ puru caita b̶ʌa. Mama Abraʌ̃ba mõgarada ʌ̃tʌ pã buesia Ãcõrẽa ewari iwid̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Maʌ̃ ewarid̶e Quedorlaóme abadada Elaʌ̃ druad̶ebema boro basía. Idjiare naʌ̃ bororãda panasid̶aa: Amrapel, Sinar ẽjũãnebemada; Ario, Elasar purud̶ebemada; idjab̶a Tidale, Goiʌ̃ druad̶ebemada. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Maʌ̃ Quedorlaómeare b̶eara Berá abada ume djõ panasid̶aa. Maʌ̃ Berára Sodoma purud̶ebema boro basía. Idjiare naʌ̃ bororãda panasid̶aa: Birsa, Gomorra purud̶ebemada; Sinabo, Admá purud̶ebemada; Semebé, Zeboiʌ̃ purud̶ebemada; idjab̶a Bela purud̶ebema boro sid̶a. Bela purura Zoar abadaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Maʌ̃gʌrãra Sidim jewed̶ad̶e jũma ãbaa dji jʌresid̶aa Pusa Beud̶a abada icawa Quedorlaómeare b̶ea ume djõni carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Maʌ̃ Quedorlaómeba Sodomanebema boroare panʌra idji jʌwaed̶a doce poa erob̶asia. Baribʌrʌ trecebema poad̶e maʌ̃gʌrãba Quedorlaómera waa ĩjãnaẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Maʌ̃ carea poa catorcebemane Quedorlaómera idjiare panʌ bororã sid̶a wãsid̶aa ãdjirã ume djõni carea. Wãbʌdad̶e naãrã Astarot-carnaim purud̶e jũẽsid̶aa. Mama repairãda poyasid̶aa. Mamaʌba Ham purud̶aa wãnaped̶a zuzirãda poyasid̶aa. Mamaʌba Quiriataim jewed̶ad̶e jũẽne wãnaped̶a emirãda poyasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Maʌ̃be Seír eyad̶e jũẽnaped̶a horeorãda quena wãsid̶aa ab̶a Paraʌ̃ ẽjũã ewara b̶ʌmaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Jẽda zebʌdad̶e En-mispat purud̶e jũẽsid̶aa. Maʌ̃ purura idjab̶a Cadé abadaa. Mama amalecitarãda poyad̶aped̶a jũma ãdjia eropanʌra ãrĩsid̶aa. Amorreorãda ara maʌ̃ quĩrãca osid̶aa Hazezon-tamar purud̶e. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Quedorlaómeare panʌba maʌ̃ puru b̶eara jũma poyad̶aped̶a Sidim jewed̶ad̶aa wãsid̶aa. Mama Sodomanebema boroare panʌra ãbaa dji jʌre panasid̶aa ãdjirã ume djõni carea. Sodomanebema boroare panʌra naʌ̃gʌrã basía: Gomorrad̶ebema boroda, Admánebema boroda, Zeboiʌ̃nebema boroda, idjab̶a Belad̶ebema boro sid̶a. Bela purura Zoar abadaa. Maʌ̃ bororãra juesuma panasid̶aa. Maʌ̃ne Elaʌ̃nebema boro Quedorlaómeare panʌra naʌ̃gʌrã basía: Goiʌ̃nebema boro Tidaleda, Sinard̶ebema boro Amrapelda, Elasard̶ebema boro Ario sid̶a. Ãdjira quĩmãrẽ panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Djõbʌdad̶e Quedorlaómeare panʌba poyasid̶aa. Maʌ̃ carea Sodomanebema boroare b̶eara mĩrũ wãbʌrʌsid̶aa. Maʌ̃ Sidim jewed̶ara egorod̶ebema cãdorrona susuaid̶a b̶asia. Maʌ̃ bẽrã mĩrũ wãbʌdad̶e ʌ̃cʌrʌ maʌ̃ susuad̶e ed̶a b̶aesid̶aa. Waabemarãra eyad̶aa mĩrũ wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","12","Maʌ̃ne Quedorlaómeare panʌba Sodomanebema nebiada, cobada sid̶a jũma jãrĩsid̶aa. Ab̶arica osid̶aa Gomorrad̶e. Maʌ̃ne Abraʌ̃ tẽãbea Lora Sodomane b̶ad̶a bẽrã Quedorlaómeare panʌba jida edesid̶aa. Ne jũma jãrĩnaped̶a wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Mãwãnacarea mĩrũ wãna ab̶aʌba Abraʌ̃a jũma nẽbʌrʌsia. Maʌ̃ ewarid̶e Abraʌ̃ “hebreo” abadara bacuruid̶a b̶ʌ ẽjũãne b̶abadjia. Maʌ̃ ẽjũãra Mamre abadjid̶aa Mamrera djibari bẽrã. Idji djabarãra Escol idjab̶a Aner basía. Maʌ̃gʌ amorreorãra Abraʌ̃are panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Maʌ̃ne Abraʌ̃ba ũrĩsia Quedorlaómeare panʌba idji tẽãbeara jida eropanʌda. Maʌ̃ carea Abraʌ̃ba idji ded̶e tocuad̶a mẽsrã b̶eada 318 jʌresia. Maʌ̃be Quedorlaómeare panʌ caid̶u ẽpẽ wãsid̶aa Daʌ̃ purud̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Mama diamasi Abraʌ̃ba dji mẽsrã b̶eara zocãrã awara awara wãbiped̶a djõsid̶aa. Maʌ̃ne Quedorlaómeare panʌra poyad̶aped̶a dji mĩrũ wãbʌda caid̶u wãsid̶aa Hobá purud̶aa, Damasco wagaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Maʌ̃be Quedorlaómeare panʌba nebia jãrĩped̶ad̶ara Abraʌ̃ba jũma jãrĩsia. Lod̶e sid̶a jãrĩsia. Maʌ̃ne idji tẽãbea Lora, wẽrãrãda, dewara ẽberãrã sid̶a ẽdrʌ edasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abraʌ̃ba Quedorlaómera dji bororã idjiare djõ panʌ sid̶a poyaped̶a idji druad̶aa jẽda zesia. Savé jewed̶a “Ẽberãrã Boro Jewed̶a” abadad̶e wãbʌrʌd̶e Sodomanebema boroda Abraʌ̃ audiab̶arid̶e zesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Mãwã b̶ʌd̶e Saleʌ̃nebema boro Melquisedéda zesia. Maʌ̃ Melquisedéba paʌ̃da uva b̶a sid̶a enesia. Melquisedéra Ãcõrẽ dji Dromaara b̶ʌ sacerdote basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Maʌ̃ne idjia Abraʌ̃ra nãwã bia jara b̶ʌsia: Abraʌ̃, Ãcõrẽ dji Dromaara b̶ʌba, bajã idjab̶a naʌ̃ ẽjũã od̶aba bʌra carebaya. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ãcõrẽ dji Dromaara b̶ʌra bio biya quirua. Idjia bʌ dji quĩrũrãra bʌ́a poyabisia. Maʌ̃ne Abraʌ̃ba ne jũma jãrĩnanebemada die juachabʌrʌza Melquisedéa ab̶a dia wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mãwãnacarea Sodomanebema boroba Abraʌ̃a jarasia: –Mʌ̃́a diadua mʌ̃ ẽberãrã ẽdrʌ edad̶ada. Baribʌrʌ bʌa nebia waya jãrĩnara edadua, mʌ̃re sid̶a edadua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","23","Maʌ̃ne Abraʌ̃ba Sodomanebema boroa jarasia: –Edaẽ́a. Mʌ̃a wãrã arada Ãcõrẽ dji Dromaara b̶ʌ, naʌ̃ ẽjũã idjab̶a bajã od̶a ume nãwã bed̶ea b̶ʌsia: mʌ̃a bʌrera edaẽ́a. Ni maãrĩara quiru sid̶a edaẽ́a. Bʌ jĩrũne jʌ̃bari jʌ̃cara sid̶a edaẽ́a. Mãwã edaẽ́a bʌa jararãmãrẽã mʌ̃ra ne bara b̶ʌsida. ");
INSERT INTO empNTpo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Mʌ̃ nezocarãba coped̶ad̶a awara mʌ̃a waa quĩrĩãẽ́a. Baribʌrʌ mʌ̃are djõ panana Anerba, Escolba, Mamre bid̶a ara ãdjia quĩrĩãbʌdada edad̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Mãwãnacarea Abraʌ̃ba cãĩmocara quĩrãca Ãcõrẽba idjía nãwã bed̶eabʌrʌda unusia: –Abraʌ̃, wayarãdua. Mʌ̃ra bʌ wagabaria. Mʌ̃a bʌra aud̶uara ne bara b̶ʌya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Maʌ̃ne Abraʌ̃ba jarasia: –Ay, Ãcõrẽ, ¿cãrẽ cãrẽã mʌ̃ra ne bara b̶ʌi? Mʌ̃ra warra sid̶a neẽ́ b̶ʌa. Mʌ̃ beud̶acarea mʌ̃a erob̶ʌra mʌ̃ nezoca Elieze Damasco purud̶ebemaba jũma edaya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Idjab̶a Abraʌ̃ba jarasia: –Bʌa mʌ̃́a warra unubiẽ́ b̶ʌ bẽrã mʌ̃a erob̶ʌra nezoca mʌ̃ ded̶e tod̶aba jũma edaya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Maʌ̃ne Ãcõrẽba Abraʌ̃a jarasia: –Eliezeba bʌa erob̶ʌra edaẽ́a, ãtebʌrʌ bʌ warra araba edaya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Maʌ̃be dajadaa edeped̶a Ãcõrẽba jarasia: –Bajãnaa acʌdua, maʌ̃be chĩdauda jũma poya juachaibʌrʌ, juachadua. Jãʌ̃ chĩdau zocãrã b̶ʌ quĩrãca bʌd̶eba yõbʌdarã sid̶a zocãrã duanania.– ");
INSERT INTO empNTpo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abraʌ̃ba Ãcõrẽra wãrãda ĩjãsia. Maʌ̃ carea Ãcõrẽba idjira jipa unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Maʌ̃be Ãcõrẽba jarasia: –Mʌ̃ra Ãcõrẽa. Mʌ̃abʌrʌ bʌra caldeorã puru Urd̶eba ẽdrʌ enesia naʌ̃ Canaaʌ̃ ẽjũãra diai carea.– ");
INSERT INTO empNTpo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Maʌ̃ne Abraʌ̃ba jarasia: –Mʌ̃ Boro Ãcõrẽ, ¿sãwã cawai mʌ̃a naʌ̃ ẽjũãra wãrãda edaida?– ");
INSERT INTO empNTpo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ãcõrẽba panusia: –Mʌ̃a nãwã unubiya naʌ̃ ẽjũãra diaida: enedua paca zaque poa ũbea b̶ʌda, chiwatu poa ũbea b̶ʌda, oveja umaquĩrã poa ũbea b̶ʌda, puchirãda, putuju sid̶a.– ");
INSERT INTO empNTpo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ara maʌ̃da Abraʌ̃ba maʌ̃ animarã b̶eara jũma enesia. Eneped̶a, beaped̶a, ẽsidra drapetaped̶a, orro ab̶a dewara orro ume quĩrã djica cob̶ʌsia. Ĩbanara drapetaẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Maʌ̃ne ãgosora zesesid̶aa animarã bead̶a cod̶i carea. Zesebʌdad̶e Abraʌ̃ba ãyã jʌrecuabadjia. ");
INSERT INTO empNTpo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Queubʌrʌd̶e Abraʌ̃ra bio cãĩ nũmesia. Cãĩ b̶ʌd̶e unusia bio pãĩsosoa minijĩchia nũmʌda. Maʌ̃ bẽrã bio ne wayasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","15","Mãwã b̶ʌd̶e Ãcõrẽba Abraʌ̃a jarasia: –Bʌra drõã b̶ed̶acarea necai waraga jaid̶aped̶a tʌb̶arid̶ia. Baribʌrʌ cawa b̶adua bʌd̶eba yõi purura djãrã druad̶e b̶aida. Maʌ̃ druad̶ebemarãba ãdjirãra nezocarãda b̶ʌd̶aped̶a cuatrociento poa bia mĩga eropanania. Baribʌrʌ ãdjirã biẽ́ o panʌra mʌ̃a biẽ́ b̶ʌya. Maʌ̃be bʌd̶eba yõi purura mamaʌba ne bara ẽdrʌya. ");
INSERT INTO empNTpo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Maʌ̃ cuatrociento poa bad̶acarea bʌd̶eba yõi purura namaa jẽda zeya. Maʌ̃ ewarid̶e mʌ̃a amorreorã naʌ̃ ẽjũãne duanʌra cawa oped̶a naʌ̃ ẽjũãra bʌd̶eba yõi purua diaya. Bʌ zocai b̶ʌ ewarid̶e mʌ̃a ãdjirãra cawa oẽ́a ãdjia cadjirua od̶ida panʌra wad̶i jũma od̶aẽ́ panʌ bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Queud̶acarea pãĩma nũmesia. Mãwã b̶ʌd̶e cawaẽ́ne cuguru waib̶ʌa cowa nũmʌda idjab̶a cãdorrona ĩbĩrã urua nũmʌ sid̶a odjad̶aped̶a dji animarã drapetad̶a ẽsi wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ara maʌ̃ba Ãcõrẽba Abraʌ̃ ume nãwã bed̶ea b̶ʌsia: –Wãrãda mʌ̃a bʌd̶eba yõi purua naʌ̃gʌ ẽjũãra diaya Egipto quĩrãpe b̶ʌ dod̶eba ab̶a do waib̶ʌa Euprate abadad̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Quenitarã, quenizirã, cadmoneorã, ");
INSERT INTO empNTpo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","hititarã, perezeorã, repairã, ");
INSERT INTO empNTpo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","amorreorã, cananeorã, gergeseorã, jebuseorã ẽjũã sid̶a mʌ̃a bʌd̶eba yõbʌdarãa jũma diaya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abraʌ̃ quima Saraira warra toca basía, baribʌrʌ Saraiba Egiptod̶ebema nezocawẽrãda erob̶asia. Maʌ̃ nezocawẽrã trʌ̃ra Agara abadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ewari ab̶a Saraiba Abraʌ̃a jarasia: –Mʌ̃ra Ãcõrẽba warra toca wẽrãda b̶ʌd̶a bẽrã, mʌ̃a bʌ́a bed̶ea djuburiaya mʌ̃ nezocawẽrã ume cãĩmãrẽã. Ãĩbẽrã mʌ̃a warrada idjid̶eba erob̶aisicada.– Saraiba jarad̶ara Abraʌ̃ba ĩjãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ara maʌ̃da Saraiba idji Egiptod̶ebema nezocawẽrãra Abraʌ̃a quima quĩrãca diasia warrada to diamãrẽã. Mãwã osia ãdji Canaaʌ̃ne die poa panasid̶ad̶e. ");
INSERT INTO empNTpo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ara maʌ̃da Abraʌ̃ra Agara ume cãĩsia. Maʌ̃ne Agarara b̶iogoa b̶esia. Maʌ̃ cawad̶acarea Agaraba idji boro Saraira igara b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Maʌ̃ bẽrã Saraiba Abraʌ̃a jarasia: –Bʌdrʌ bed̶ead̶e b̶ʌa Agaraba mʌ̃ igara b̶ʌ carea. Mʌ̃a bʌ́a idjira diasia quima quĩrãca. Baribʌrʌ idji b̶iogoa b̶ʌ cawasid̶eba ʌ̃taa mʌ̃ra igara b̶ʌa. Ãcõrẽbʌrʌ cawa b̶ʌa caida bed̶ead̶e b̶ʌda: mʌ̃da wa bʌda.– ");
INSERT INTO empNTpo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Maʌ̃ne Abraʌ̃ba Saraia jarasia: –Acʌdua, bʌ nezocawẽrãra bʌ jʌwaed̶a b̶ʌa. Bʌdjia quĩrĩã b̶ʌ quĩrãca odua.– Ara maʌ̃da Saraiba dji nezocawẽrãra biẽ́ o b̶esia. Maʌ̃ carea dji nezocawẽrãra mĩrũ wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Agara mĩrũ wãne Ãcõrẽ nezoca bajãnebemaba idji acʌd̶e zesia. Idjia Agarara unusia ẽjũã põãsa ewaraga b̶ʌd̶e egorod̶eba baido ʌ̃ta bogadrʌ b̶ʌma. Maʌ̃ baido ʌ̃ta bogadrʌ b̶ʌra Sur ẽjũãnaa wãbada od̶e b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Maʌ̃ne Ãcõrẽ nezoca bajãnebemaba Agaraa iwid̶isia: –Agara, Sarai nezocawẽrã, ¿bʌra sãmaʌba zebʌrʌ? ¿Sãmaa wã?– Agaraba panusia: –Mʌ̃ra mʌ̃ boro Sarai ume b̶ad̶ada mĩrũ wãa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Maʌ̃ne Ãcõrẽ nezoca bajãnebemaba jarasia: –Bʌ boro Saraimaa jẽda wãdua. Idji bed̶eara jũma ĩjã odua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Maʌ̃ awara jarasia: –Mʌ̃a bʌd̶eba zocãrã yõbiya. Mãwã zocãrã yõni bẽrã poya juachad̶aca baya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Idjab̶a jarasia: Bʌ b̶iogoa b̶ʌra umaquĩrã warrada toya. Maʌ̃ warrara trʌ̃ b̶ʌdua Ismael, mʌ̃a bʌ bia mĩga b̶ʌd̶ebemada ũrĩna bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Idjira ni ab̶aʌ jʌwaed̶a b̶aẽ́a. Jũmarã ume djõ b̶aya. Idjab̶a jũmarãda idji ume djõ b̶ead̶ia. Idji ẽberãrãnebemada jĩga b̶abari baya. ");
INSERT INTO empNTpo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Agaraba cawasia Ãcõrẽdrʌ mãwã bed̶ea b̶asida. Maʌ̃ bẽrã Agaraba jarasia “Mʌ̃ unubari Ãcõrẽda mʌ̃a unusia.” Maʌ̃ carea Ãcõrẽ trʌ̃ra nãwã jarasia: “Bʌra mʌ̃ unubari Ãcõrẽa.” ");
INSERT INTO empNTpo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Maʌ̃ bẽrã dji egorod̶eba baido bogadrʌ b̶ʌra trʌ̃ b̶ʌsia “baido bogadrʌ b̶ʌ Ãcõrẽ zocai b̶ʌ mʌ̃ unubarid̶e.” Maʌ̃ baidora Cadé puru idjab̶a Bered puru ẽsi b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Agara jẽda wãped̶a umaquĩrã warrada Abraʌ̃a to diasia. Abraʌ̃ba Agara warrara trʌ̃ b̶ʌsia Ismael. ");
INSERT INTO empNTpo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Agaraba idji warra Ismael tosid̶e Abraʌ̃ra 86 poa b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abraʌ̃ 99 poa b̶asid̶e Ãcõrẽra idjima odjaped̶a nãwã jarasia: –Mʌ̃ra ne jũma poya obari Ãcõrẽa. Bʌra mʌ̃ quĩrãpita jipa nĩbadua. ");
INSERT INTO empNTpo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Mʌ̃a bʌ ume bed̶ea b̶ʌd̶ara wãrãda oya. Mãwã bʌd̶eba zocãrã yõbiya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ara maʌ̃da Abraʌ̃ba Ãcõrẽra bio waya b̶ʌ bẽrã chĩrãborod̶e cob̶eped̶a idji dratura egorod̶aa b̶arru tẽũ cob̶esia. Maʌ̃ne Ãcõrẽba jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","–Mʌ̃a bʌ ume bed̶ea b̶ʌd̶ara naʌ̃gʌa: bʌra zocãrã puru zeza baya. ");
INSERT INTO empNTpo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Maʌ̃ bẽrã bʌra waa Abraʌ̃ ad̶aẽ́a. Id̶iba ʌ̃taa bʌ trʌ̃ra Abrahaʌ̃ ad̶ia, mʌ̃a bʌra zocãrã puru zezada b̶ʌbʌrʌ bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Mʌ̃a bʌd̶eba zocãrã yõbiya; bʌd̶eba mʌ̃a puruda zocãrã ocuaya. Idjab̶a bʌd̶eba ẽberãrã bororãda odjad̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Mʌ̃a bʌ ume, bʌd̶eba yõbʌda ume bid̶a bed̶ea b̶ʌd̶ara naʌ̃gʌa: mʌ̃ra ewariza bʌ Ãcõrẽa idjab̶a ãdjirã Ãcõrẽ baya. Mʌ̃a bãrãra waga b̶aya idjab̶a bãrãba mʌ̃ra ẽpẽ panania. ");
INSERT INTO empNTpo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Idjab̶a bʌ b̶abari ẽjũãra bʌ́a, bʌd̶eba yõbʌdarãa bid̶a mʌ̃a diaya. Mʌ̃a bãrãa jũma Canaaʌ̃ druara diaya ewariza bãrãne bamãrẽã. Maʌ̃ne mʌ̃drʌ bãrã Ãcõrẽ baya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Idjab̶a Ãcõrẽba Abrahaʌ̃a jarasia: –Mʌ̃a bʌ ume bed̶ea b̶ʌd̶a bẽrã, bʌa ne oida b̶ʌa. Idjab̶a id̶iba ʌ̃taa bʌ warrarãba, ãdjid̶eba yõbʌdarã bid̶a ab̶arica od̶ida panʌa. Bãrãba nãwã od̶ida panʌa: bãrã tãẽnabema umaquĩrãrã jũmarãba ãdji cacuara wẽãgod̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Bãrã umaquĩrã cacua wẽãgod̶ara mʌ̃a bãrã ume bed̶ea b̶ʌd̶a sẽyã baya. ");
INSERT INTO empNTpo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Id̶iba ʌ̃taa umaquĩrã warrada tod̶ibʌrʌ, ocho ewari b̶ʌd̶e idji cacuara wẽãgod̶ida panʌa. Maʌ̃ awara nezoca warrarã bãrã ded̶e tobʌdarãda idjab̶a ãĩbema nẽdod̶a nezocarã sid̶a cacua wẽãgod̶ida panʌa. Mãwã mʌ̃a bãrã ume bed̶ea b̶ʌd̶a sẽyãra ara bãdji cacuad̶e erob̶ead̶ia. Mʌ̃a bed̶ea b̶ʌd̶ara ewariza mãwã b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Maʌ̃ carea baridua umaquĩrãba idji cacuada wẽãgoẽ́bʌrʌ, maʌ̃ ẽberãra bãrãnebemada ãyã b̶ʌd̶ida panʌa, mʌ̃a bãrã ume bed̶ea b̶ʌd̶ara igara b̶ʌ bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","16","Maʌ̃ awara Ãcõrẽba Abrahaʌ̃a jarasia: –Mʌ̃a bʌ quima Saraira nãwã bia b̶ʌya: idjid̶eba mʌ̃a bʌ́a warrada wãrãda diaya. Maʌ̃ awara idjid̶eba puruda zocãrã yõnia idjab̶a idjid̶eba ẽberãrã bororãda odjad̶ia. Maʌ̃ carea bʌ quimara waa Sarai arãdua, ãtebʌrʌ idji trʌ̃ra Sara adua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Maʌ̃be Abrahaʌ̃ba Ãcõrẽra waya b̶ʌ bẽrã chĩrãborod̶e cob̶eped̶a idji dratura egorod̶e b̶arru tẽũ cob̶esia. Baribʌrʌ ipid̶asia. Idji sod̶e crĩchasia: “Ẽberã cien poa b̶ʌba ¿sãwã warrada oi? Sara noventa poa b̶ʌda ¿sãwã mãwã b̶iogoa b̶ei?” ");
INSERT INTO empNTpo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Maʌ̃ne Abrahaʌ̃ba Ismaeld̶ebemada crĩchasia. Maʌ̃ bẽrã Abrahaʌ̃ba Ãcõrẽa jarasia: –¡Ismaelda bʌ quĩrãpita bia b̶ʌbara bia b̶acasia!– ");
INSERT INTO empNTpo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Maʌ̃ne Ãcõrẽba panusia: –Mãwãẽ́a. Bʌ quima Sarabʌrʌ umaquĩrã warrada bʌ́a to diaya. Bʌa idji trʌ̃ra b̶ʌdua Isa. Mʌ̃a bʌ ume bed̶ea b̶ʌd̶ara jõca baya. Maʌ̃ bẽrã maʌ̃ bed̶eara idjab̶a Isa itea b̶aya, idjid̶eba yõbʌdarã itea bid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Idjab̶a bʌ warra Ismaeld̶ebema jarad̶ara mʌ̃a ũrĩsia. Mʌ̃a idji sid̶a bia b̶ʌya. Maʌ̃ bẽrã warra zocãrã unubiya. Mãwã idjid̶eba ẽberãrã zocãrã yõnia. Idjia doce warra dji dromarãda unuya. Mãwã mʌ̃a idjid̶eba puru waib̶ʌada oya. ");
INSERT INTO empNTpo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Baribʌrʌ mʌ̃a bʌ ume bed̶ea b̶ʌd̶ara Isa itea b̶aya. Id̶iba poa ab̶a babʌrʌd̶e Isara Saraba bʌ́a to diaya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ãcõrẽra Abrahaʌ̃ ume bed̶ea b̶aped̶a wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ara maʌ̃ ewarid̶e Abrahaʌ̃ba idji warra Ismaelda, nezocarã idji ded̶e toped̶ad̶arãda, idjia nẽdod̶a nezocarã sid̶a trʌ̃cuaped̶a Ãcõrẽba jarad̶a quĩrãca jũmarãda cacua wẽãgocuasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrahaʌ̃ra 99 poa b̶asia idji cacua wẽãgosid̶e. ");
INSERT INTO empNTpo_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Dji warra Ismaelera trece poa b̶asia idji cacua wẽãgosid̶e. ");
INSERT INTO empNTpo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abrahaʌ̃ cacua wẽãgosid̶e ab̶ari ewarid̶e dji warra Ismael sid̶a cacua wẽãgosia. ");
INSERT INTO empNTpo_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Jũma umaquĩrãrã idji ded̶e panabadada, nezocarã idji ded̶e toped̶ad̶ada, ãĩbemarã nẽdod̶arã sid̶a ab̶ari ewarid̶e cacua wẽãgosid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abrahaʌ̃ Mamre ẽjũã bacuru dromaid̶a b̶ʌma b̶asid̶e Ãcõrẽra idjima nãwã odjasia: Abrahaʌ̃ra idji wua ded̶e ed̶a wãbadama umatipa chũmasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Acʌbʌrʌd̶e ẽberãda ũbea caita nũpanʌda unusia. Maʌ̃ ẽberãrã unubʌrʌd̶e araa pira wãsia audiab̶arid̶e. Chĩrãborod̶e cob̶eped̶a idji dratura egorod̶aa b̶arru tẽũ cob̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Maʌ̃be jarasia: –Mʌ̃ Boro, mʌ̃ quĩrã djuburia wãyã wãrãdua. ");
INSERT INTO empNTpo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Bʌmaa bia b̶ʌbʌrʌ, mʌ̃a baidoda enebiya bãrã jĩrũ sʌgʌd̶amãrẽã. Maʌ̃be bacuru edre ʌ̃nãũnida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Mʌ̃maa ze panʌ bẽrã mʌ̃a bãrã itea ne djubiya ne cod̶aped̶a cacua ʌb̶ʌad̶amãrẽã. Mãwãnacarea wãnida panʌa.– Ãdjia panusid̶aa: –Bia b̶ʌa, odua bʌa jara b̶ʌ quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ara maʌ̃da Abrahaʌ̃ra idji ded̶e isabe ed̶aa wãped̶a Saraa jarasia: –Harinada cuarenta libra edaped̶a isabe bʌrachiradua. Maʌ̃be ãbucuadua jari panʌ ẽberãba cod̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Maʌ̃be Abrahaʌ̃ra idji pacamaa pira wãped̶a paca zaque boreguea b̶ʌda ab̶a edaped̶a idji nezocaa diasia isabe beaped̶a omãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Oped̶a Abrahaʌ̃ba dji paca zaque djarara ãdjía cobisia. Idjab̶a paca jub̶ada diasia. Paca jub̶ad̶eba ne od̶a sid̶a diasia. Ãdji ne co panʌne Abrahaʌ̃ra bacuru edre nũmasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Mãwã panʌne ãdjirãba iwid̶isid̶aa: –¿Bʌ quima Sarara sãma b̶ʌ?– Abrahaʌ̃ba panusia: –Nama wua ded̶e ed̶a b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Maʌ̃ne ãdjirãnebema ab̶aʌba jarasia: –Za zei poad̶e mʌ̃ra wayacusa bʌ acʌd̶e zeya. Maʌ̃ne bʌ quimaba umaquĩrã warrada to erob̶aya.– Mãwã bed̶ea panʌda Saraba Abrahaʌ̃ ẽcarraare ãdji ded̶e ed̶aa wãbadad̶eba jũma ũrĩ b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abrahaʌ̃ra Sara sid̶a drõãda panasid̶aa. Maʌ̃ bẽrã Saraba idji jed̶eco unuca basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Maʌ̃ carea Saraba nãwã crĩchasia: “Mʌ̃ jãwã djora b̶ʌba, mʌ̃ quima sid̶a drõã b̶ʌba ¿sãwã warrada od̶i?” Mãwã crĩchaped̶a idub̶a ipid̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Maʌ̃ bẽrã Ãcõrẽba Abrahaʌ̃a jarasia: –¿Cãrẽ cãrẽã Sarara ipid̶asi? ¿Cãrẽ cãrẽã crĩcha b̶ʌ idji djora b̶ʌba warrara poya toẽ́da? ");
INSERT INTO empNTpo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿Mʌ̃a ne jũma poya o b̶ʌẽ́ca? Mʌ̃a jarad̶a quĩrãca za zei poad̶e mʌ̃ra bʌmaa wayacusa zeya. Maʌ̃ ewarid̶e Saraba umaquĩrã warrada to erob̶aya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Maʌ̃ne Sara dauperabʌrʌba jarasia: –Mʌ̃ra ipid̶aẽ́ basía.– Baribʌrʌ Ãcõrẽba jarasia: –Mãwãẽ́a. Mʌ̃a cawa b̶ʌa bʌra ipid̶asida.– ");
INSERT INTO empNTpo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Maʌ̃be maʌ̃ ẽberãrã ũbea panʌra piradrʌd̶aped̶a Sodoma purud̶aa wãbʌda basía. Abrahaʌ̃ra ãdji ume wãsia bia wãnaduad̶a ai carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","19","Maʌ̃ne Ãcõrẽba nãwã crĩchasia: “Abrahaʌ̃neba yõbʌdara puru droma baya, idjab̶a idjid̶eba mʌ̃a jũma naʌ̃ ẽjũãne b̶ea purura carebaya. Mʌ̃a idjira edasia idji warrarãa, ãdjirãneba yõbʌdarãa bid̶a jaradiamãrẽã. Idjia ãdjirãa jaradiaya mʌ̃ od̶e nĩbad̶amãrẽã idjab̶a jipa od̶amãrẽã. Mãwã od̶ibʌrʌ mʌ̃a Abrahaʌ̃ ume bed̶ea b̶ʌd̶ara jũma oya. Maʌ̃ bẽrã mʌ̃a idjía jaraya mʌ̃a Sodoma purura sãwã oida.” ");
INSERT INTO empNTpo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Maʌ̃be Ãcõrẽba Abrahaʌ̃a jarasia: –Mʌ̃a ũrĩ b̶ʌa Sodoma purud̶ebemarãba, Gomorrad̶ebemarã bid̶a cadjiruada jũmawãyã o panʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Maʌ̃ bẽrã mʌ̃ra ed̶aa wãya ãdjirãba wãrãda jũmawãyã cadjiruada o panʌ cawaya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Maʌ̃be ãdjid̶ebemada umé Sodomanaa wãsid̶aa, baribʌrʌ Abrahaʌ̃ra Ãcõrẽ ume b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abrahaʌ̃ra Ãcõrẽ caitaara wãped̶a jarasia: –Bʌa Sodomanebemarã cawa obʌrʌd̶e, ¿ẽberã jipa b̶eada dji cadjiruarã ume ãbaa quinibica? ");
INSERT INTO empNTpo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Jãʌ̃ purud̶e ẽberã jipa b̶eada cincuenta panʌbʌrʌ, ¿bʌa ãdji purura jũma ãrĩca? Bʌa maʌ̃ cincuenta ẽberã jipa b̶ea carea ¿ãdji puru ãrĩ crĩcha b̶ʌra idu b̶ʌẽ́ca? ");
INSERT INTO empNTpo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Bʌa ẽberã jipa b̶eara ẽberã cadjiruarã ume ãbaa quinibicaa. Bʌra jũma naʌ̃ ẽjũãne b̶ea cawa obaria. Mãwãra ¿bʌa jipa cawa oẽ́ca?– ");
INSERT INTO empNTpo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Maʌ̃ne Ãcõrẽba panusia: –Mʌ̃a Sodoma purud̶e jipa b̶eada cincuenta unuibʌrʌ, maʌ̃ cincuenta ẽberãrã carea jãʌ̃ purura ãrĩẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Wayacusa Abrahaʌ̃ba jarasia: –Mʌ̃ Boro, mʌ̃ra ne wayaa neẽ́ b̶ʌ quĩrãca bʌ ume bed̶ea b̶ʌa. Mʌ̃ra ẽberãda quirumĩna, egoro quĩrãca b̶ʌmĩna, tʌbʌ pora quĩrãca b̶ʌmĩna, mʌ̃ra bʌ ume wad̶i idu bed̶eabidua. ");
INSERT INTO empNTpo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ãĩbẽrã cincuenta jipa b̶ead̶ebemarãda bʌa juesuma unuẽ́sicada. Maʌ̃ juesuma unuẽ́ carea ¿ãdji purura jũma ãrĩca?– Maʌ̃ne Ãcõrẽba panusia: –Mʌ̃a jipa b̶eada 45 unuibʌrʌ, ãdji purura ãrĩẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abrahaʌ̃ba wayacusa jarasia: –Ãĩbẽrã cuarentabe unuisicada.– Maʌ̃ne Ãcõrẽba jarasia: –Jipa b̶eada cuarenta panʌbʌrʌ, ãrĩẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abrahaʌ̃ba jarasia: –Mʌ̃ Boro, quĩrũrãdua mʌ̃a bʌ́a waya iwid̶ibʌrʌ carea. Ãĩbẽrã treintabe panʌsicada.– Maʌ̃ne Ãcõrẽba panusia: –Mʌ̃a treinta unuibʌrʌ, ãrĩẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abrahaʌ̃ba jarasia: –Mʌ̃ Boro, mʌ̃ra ne wayaa neẽ́ b̶ʌ quĩrãca bʌ ume bed̶ea b̶ʌa. Ãĩbẽrã arima veintebe panʌsicada.– Ãcõrẽba panusia: –Jipa b̶eada veinte panʌbʌrʌ, ãrĩẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abrahaʌ̃ba wayacusa jarasia: –Mʌ̃ Boro, mʌ̃a bed̶eada ab̶abe jaraya. Quĩrũrãdua. Mʌ̃a maʌ̃ bed̶eara jarasira waa jaraẽ́a. Ãĩbẽrã arima diebe panʌsicada.– Maʌ̃ne Ãcõrẽba jarasia: –Jipa b̶eada die panʌbʌrʌ, ãrĩẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ãcõrẽra Abrahaʌ̃ ume mãwã bed̶eaped̶a wãsia. Maʌ̃ne Abrahaʌ̃ra jẽda wãsia idji b̶abarimaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Queubod̶od̶e bajãnebema nezoca umébemara Sodoma purud̶e jũẽsid̶aa. Maʌ̃ne Abrahaʌ̃ tẽãbea Lora dji puru ed̶a wãbadama chũmasia. Mãwã b̶ʌd̶e Loba maʌ̃ bajãnebema nezocarãra unusia. Ara maʌ̃da ãdji audiab̶arid̶e wãsia. Wayaad̶eba chĩrãborod̶e cob̶eped̶a idji dratura egorod̶aa b̶arru tẽũ cob̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Maʌ̃be Loba ãdjía jarasia: –Mʌ̃ bororã, mʌ̃a bãrãa bed̶ea djuburiaya naʌ̃ diamasi mʌ̃ ded̶e cãĩne zed̶amãrẽã. Mama bãrã jĩrũra sʌgʌd̶ida panʌa. Nu diaped̶a wãnadua bãdji wãbʌdamaa.– Maʌ̃ne bajãnebema nezocarãba panusid̶aa: –Mãwãẽ́a. Naʌ̃ diamasi daira puru jãne cãĩnia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Baribʌrʌ Loba mĩã sẽ jara b̶esia idji diguid̶aa wãnamãrẽã. Maʌ̃ carea Lo ume wãsid̶aa. Jũẽnacarea Loba djico biada osia idjab̶a paʌ̃ dji ẽsãbari neẽ́ b̶ʌda ocuasia. Maʌ̃da cosid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Wad̶i cãĩni naẽna jũma purud̶ebema umaquĩrãrãba Lo dera jũrã edasid̶aa. Cũdrarãda, drõãrã sid̶a duanasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Maʌ̃be dajadaareba Loa b̶ia iwid̶isid̶aa: –Naʌ̃ diamasi ẽberã bʌmaa zeped̶ad̶ara ¿sãma panʌ? Dajadaa enedua dairãra ãdji ume cãĩni carea.– ");
INSERT INTO empNTpo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Maʌ̃ne Lora dajadaa ãdjirã ume bed̶ead̶e wãped̶a dji ed̶a wãbadara bio jũãtrʌ nũmʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Maʌ̃be jarasia: –Achirã, mʌ̃a bãrãa bed̶ea djuburiaya maʌ̃ cadjiruara orãnamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Baribʌrʌ mʌ̃a caurã umaquĩrã adua panʌda umé erob̶ʌa. Mʌ̃a ãdjira dajada b̶ʌya bãdjia quĩrĩã panʌ quĩrãca od̶amãrẽã. Baribʌrʌ naʌ̃ ẽberãrãra mʌ̃ diguid̶aa ze panʌ bẽrã mʌ̃a wagaida b̶ʌa. Maʌ̃ bẽrã ãdjira biẽ́ orãnadua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Maʌ̃ne purud̶ebemarãba jarasid̶aa: –Bʌra drua ãĩba dai purud̶e b̶ad̶e zesia. Maʌ̃ba id̶ira ¿dairãra jãwã quẽã b̶ʌca? ¡Ãyã wãdua! Bʌda ãyã wãẽ́bʌrʌ, daiba ãdji cãyãbara bʌda cadjiruaara od̶ia.– Ara maʌ̃da Lora chãtad̶aped̶a dji ed̶a wãbada ãrĩni carea panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Baribʌrʌ bajãnebema nezocarã Lo diguid̶aa panʌba Lora ãdji jʌwaba ed̶a edad̶aped̶a dji ed̶a wãbadara jũãtrʌ nũmʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ara maʌ̃da ãdjia dji ed̶a wãbadama duanʌra jũma daub̶erreabisid̶aa, cũdrarãra drõãrã sid̶a. Maʌ̃ne ãdjirãra dji ed̶a wãbada jʌrʌ panʌba sẽsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Maʌ̃be bajãnebema nezocarã Lo ded̶e panʌba idjía jarasid̶aa: –Naʌ̃ purud̶e ¿bʌa ẽberãrãda dewara erob̶ʌca? Bʌ warrarã, bʌ caurã, bʌ wigurã, idjab̶a jũma naʌ̃ purud̶e erob̶ʌ sid̶a namabemada ãyã ededua. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Daiba naʌ̃ purura jũma ãrĩnia. Ãcõrẽba ũrĩ b̶ʌa naʌ̃ purud̶ebemarãba bio cadjirua obadada. Maʌ̃ bẽrã Ãcõrẽba daira diabuesia ãdjirã cawa od̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ara maʌ̃da Lora cũdra idji caurã ume bed̶ea bia panʌrã acʌd̶e wãped̶a jarasia: –Pirab̶arid̶aped̶a namabemada isabe ãyã wãnadua. Ãcõrẽba naʌ̃ purura ãrĩya.– Mãwãmĩna cũdrarãba crĩchasid̶aa Loba ijaramiada o b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ʌ̃nadrʌbod̶od̶e bajãnebema nezocarãba Loa jarasid̶aa: –Bʌ quimada, bʌ caurã umé panʌ sid̶a isabe ãyã ededua daiba naʌ̃ puru ãrĩbʌdad̶e beurãnamãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Mãwãmĩna Lora isabe wãẽ́ b̶asia. Maʌ̃ bẽrã bajãnebema nezocarãba idjida, idji quimada, idji caurã sid̶a jʌwad̶e jidad̶aped̶a puru dajadaa erreb̶ari edesid̶aa ẽdrʌ b̶ʌd̶i carea. Mãwã Ãcõrẽba Lora idji ẽberãrã sid̶a quĩrã djuburiasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Puru dajada bad̶acarea bajãnebema nezocarãba Loa jarasid̶aa: –Ẽdrʌi carea pira wãdua. Jẽda acʌrãdua idjab̶a ni maãrĩ bid̶a naʌ̃ jewed̶ad̶e nũmerãdua. Beu amaaba eya baramaa wãdua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Baribʌrʌ Loba jarasia: –Mãwãẽ́a, mʌ̃ bororã. Mʌ̃ quĩrã djuburia jãʌ̃ eyad̶aa wãbirãdua. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Bãrãba mʌ̃ra bio quĩrã djuburiasid̶aa purud̶ebemada ẽdrʌ eneped̶ad̶a bẽrã. Baribʌrʌ mʌ̃ra eya barama poya jũẽẽ́a. Pĩãca wãbʌrʌd̶e bãrãba dji puru ãrĩbʌdaba mʌ̃ra ota jidaisicada. Maʌ̃ba mʌ̃ra beaya. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Nama caita puru zaqueda b̶ʌa. ¿Mʌ̃ra mamaa mĩrũ wãida b̶ʌca? Dji purura wãrãda caibe quirua. ¿Bãrãba maʌ̃gʌra ãrĩnaẽ́ame? Mʌ̃ra mamaa idu wãbid̶adua beu amaaba.– ");
INSERT INTO empNTpo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Maʌ̃ne Ãcõrẽ nezoca ab̶aʌba jarasia: –Mãẽteara bia b̶ʌa. Bʌa jara b̶ʌ quĩrãca mʌ̃a iduaribiya. Bʌa jara b̶ʌ purura mʌ̃a ãrĩẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Baribʌrʌ isabe wãdua jãma jũẽi carea. Mʌ̃a ni cãrẽ sid̶a poya oẽ́a bʌ jãma jũẽi naẽna.– Loba maʌ̃ purura wãrãda caibe quiruad̶a ad̶a bẽrã dji puru trʌ̃ra b̶esia Zoar. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lo Zoard̶e jũẽbʌrʌbara ʌ̃mãdaura odjabʌrʌ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Maʌ̃bebʌrʌ Ãcõrẽba azupre uruada Sodomane, Gomorrad̶e bid̶a bajãneba jurrubisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Maʌ̃ba puru umé panʌra, maʌ̃ purud̶e ed̶a duanʌra, idjab̶a chirua maʌ̃ jewed̶ad̶e b̶ʌ sid̶a jũma bá wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Baribʌrʌ Lo quima caid̶u nĩba jẽda acʌsia. Ara maʌ̃da idjira ab̶ed̶a zarea tã ba nũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Nurẽma diaped̶a Abrahaʌ̃ra wãsia Ãcõrẽ ume bed̶ea b̶ad̶amaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Mamaʌba Sodomara, Gomorrara, jũma dji jewed̶a sid̶a acʌsia. Maʌ̃ne unusia dji ẽjũãra ʌ̃ta cowaga nũmʌda pea bad̶a cowabari quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ãcõrẽba puru maʌ̃ jewed̶ad̶e panʌra ãrĩnamĩna Abrahaʌ̃ra quĩrãdoaẽ́ b̶asia. Maʌ̃ carea Abrahaʌ̃ tẽãbea Lora Sodoma ãrĩbʌrʌd̶ebemada ãyã ẽdrʌ edesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Mãwãnacarea Lora Zoar purud̶e b̶aida wayasia. Maʌ̃ carea idji caurã ume ẽjũã eyaid̶a b̶ʌmaa wãsia. Mama ãdjira eya uriad̶e panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ewari ab̶a dji cau nabemaba dji tẽãbemaa jarasia: –Dadji zezara drõãda quirua. Maʌ̃ awara nama naʌ̃ ẽjũãne ni ab̶aʌ umaquĩrãda neẽ́a dadji edad̶amãrẽã jũmarãda quima edabada quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Maʌ̃ carea dadji zezaa uva b̶a aseada dobid̶ia beu b̶emãrẽã. Mãwã osid̶ara idji ume poya cãĩnia idji warrada eropanani carea.– ");
INSERT INTO empNTpo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ara maʌ̃ diamasi ãdji zeza Loa uva b̶a aseara dobisid̶aa. Lora beu b̶eped̶a idji cau nabemada araa wãped̶a idji ume cãĩsia. Baribʌrʌ Lora beu b̶ʌ bẽrã cawaẽ́ basía idji caura cãĩ b̶aped̶a ãyã wãnada. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Nurẽma dji nabemaba dji tẽãbemaa jarasia: –Mʌ̃ra nuena diamasi dadji zeza ume cãĩsia. Nane bid̶a uva b̶a aseada dobid̶ia bʌ sid̶a idji ume cãĩmãrẽã. Mãwã dadji zeza warrarãda eropanania.– ");
INSERT INTO empNTpo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ara maʌ̃ diamasi uva b̶a aseara ãdji zezaa dobisid̶aa. Maʌ̃be dji tẽãbemara idji ume cãĩsia. Baribʌrʌ Loba cawaẽ́ basía dji caura cãĩ b̶aped̶a ãyã wãnada. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Mãwã Lo caura umena b̶iogoa panesid̶aa ara ãdji zezad̶eda. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Maʌ̃be dji nabemaba umaquĩrã warrada tosia. Dji trʌ̃ra b̶ʌsia Moab. Moab abadad̶eba moabitarãda yõsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Dji tẽãbema bid̶a umaquĩrã warrada tosia. Dji trʌ̃ra b̶ʌsia Benamí. Benamíneba amonitarãda yõsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Mãwãnacarea Abrahaʌ̃ra idji b̶ad̶amaʌba Negue ẽjũãnaa wãped̶a Guerar purud̶e b̶esia. Maʌ̃ purura Cadé puru idjab̶a Sur ẽjũã ẽsi b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Mama b̶asid̶e Abrahaʌ̃ba jarabadjia idji quima Sarara idji djabawẽrãda. Maʌ̃ bẽrã Guerard̶ebema boro Abimele abadaba Sarara idji ded̶aa edebisia edai carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Mãwãmĩna diamasi Ãcõrẽba Abimelea cãĩmocarad̶e nãwã jarasia: “Bʌra beuya bʌa edebid̶a wẽrãra quima bara b̶ʌ bẽrã.” ");
INSERT INTO empNTpo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","5","Baribʌrʌ Abimelera wad̶i Sara ume cãĩẽ́ b̶asia. Maʌ̃ bẽrã idjia Ãcõrẽa jarasia: –Mʌ̃ Boro, Abrahaʌ̃ba mʌ̃́a jarasia jãʌ̃gʌ wẽrãra idji djabawẽrãda. Dji wẽrã bid̶a jarasia Abrahaʌ̃ra idji djabada. Maʌ̃ bẽrã mʌ̃a crĩcha biad̶eba edai carea enebisia. Mʌ̃ra bed̶ead̶e b̶ʌẽ́a. ¿Bʌa nẽbʌra neẽ́ b̶ʌda cawa oica?– ");
INSERT INTO empNTpo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Maʌ̃ne Ãcõrẽba cãĩmocarad̶e panusia: –Mʌ̃a bio cawa b̶ʌa bʌa crĩcha biad̶eba mãwã osida. Maʌ̃ bẽrã mʌ̃a bʌra mʌ̃ quĩrãpita idu cadjirua obiẽ́ basía. Mʌ̃a bʌra maʌ̃ wẽrã ume idu cãĩbiẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Jãʌ̃be idjira Abrahaʌ̃a jẽda diadua. Abrahaʌ̃ra mʌ̃neba bed̶eabaria. Idjia mʌ̃́a iwid̶ida b̶ʌa bʌ beurãmãrẽã. Baribʌrʌ bʌa jẽda diaẽ́bʌrʌ, bʌra bʌ ẽberãrã sid̶a ab̶ed̶a jũma quininia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Nurẽma diaped̶a Abimelera pirab̶ariped̶a idjiare dji droma b̶eara jũma trʌ̃sia. Maʌ̃be Ãcõrẽba jarad̶ara ãdjirãa jũma jarasia. Maʌ̃ bed̶ea ũrĩbʌdad̶e ãdjirãra bio dauperasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Mãwãnacarea Abimeleba Abrahaʌ̃ra trʌ̃ped̶a jarasia: –¡Bʌa mʌ̃ra, mʌ̃ druad̶ebemarã sid̶a Ãcõrẽ quĩrãpita bed̶ead̶e b̶ʌsia! Mʌ̃a bʌra biẽ́ oẽ́ basía. Baribʌrʌ bʌa mʌ̃ ume osia mĩã oiẽ́ b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Bʌa ¿cãrẽ crĩchad̶eba jãwã osi?– ");
INSERT INTO empNTpo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Maʌ̃ne Abrahaʌ̃ba panusia: –Mʌ̃a crĩchasia namabemarãba Ãcõrẽra wayad̶acada. Maʌ̃ bẽrã crĩchasia mʌ̃ra bead̶ida mʌ̃ quima edad̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Idjira wãrãda mʌ̃ djabawẽrãa mʌ̃ zeza cau bẽrã, baribʌrʌ mʌ̃ papa cauẽ́a. Maʌ̃ bẽrã mʌ̃a edasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ãcõrẽba mʌ̃ra mʌ̃ zeza diguid̶abemada ãyã wãbisid̶e mʌ̃a mʌ̃ quimaa nãwã jarasia: “Bʌa wãrãda mʌ̃da quĩrĩã b̶ʌbʌrʌ, dadji wãbʌdama ẽberãrãa jaradua mʌ̃ra bʌ djabada.”– ");
INSERT INTO empNTpo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Maʌ̃be Abimeleba Abrahaʌ̃ quima Sarara jẽda diasia. Idjab̶a ovejada, pacada, nezoca umaquĩrãda, nezoca wẽrã sid̶a zocãrã diacuasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Diacuaped̶a jarasia: –Acʌdua, mʌ̃ druara b̶ʌa. Bʌdjia ẽjũã awuabʌrʌmaa b̶ad̶e wãdua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Maʌ̃ne Abimeleba Saraa jarasia: –Mʌ̃a bʌ djabamanaa parata torroda mil diasia bʌ ume b̶eaba cawad̶amãrẽã bʌra daunemaẽ́ basida. Bʌra bed̶ead̶e b̶ʌẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Abimeleba Abrahaʌ̃ quima Sara edai basid̶e Ãcõrẽba wẽrãrã Abimele ded̶e panabadada idu b̶iogoabigaẽ́ basía. Maʌ̃ carea Abrahaʌ̃ba Ãcõrẽa iwid̶isia. Maʌ̃be Ãcõrẽba Abimele cacua biẽ́ b̶ad̶ada biabisia. Maʌ̃ awara dji quimada, nezocawẽrãrã sid̶a biabisia warra ununamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Mãwãnacarea Ãcõrẽba Sarara carebasia idjia wãrãneba jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Abrahaʌ̃ra bio drõãda b̶ʌmĩna Sarara b̶iogoa b̶eped̶a Ãcõrẽba jarad̶a ewarid̶e warrada tosia. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Saraba warra tod̶ara Abrahaʌ̃ba trʌ̃ b̶ʌsia Isa. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Idji warra Isa ocho ewari b̶ʌd̶e Abrahaʌ̃ba Isa cacuara wẽãgosia Ãcõrẽba jara b̶ʌd̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abrahaʌ̃ra cien poa b̶asia idji warra Isa tosid̶ad̶e. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Maʌ̃ne Saraba crĩchasia: “Ãcõrẽba mʌ̃ra ipid̶abi b̶ʌa. Bariduaba mʌ̃ warra tod̶ad̶ebemada ũrĩnibʌrʌ mʌ̃ carea b̶ʌsrid̶aba ipid̶ad̶ia.” ");
INSERT INTO empNTpo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Idjab̶a jarasia: “Ni ab̶aʌba crĩchad̶aca basía mʌ̃ra warra toida. Abrahaʌ̃ra drõãda b̶ʌmĩna mʌ̃a idjía warrada to diasia.” ");
INSERT INTO empNTpo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ãdji warra Isara warisia. Ju amasid̶e Abrahaʌ̃ba b̶ʌsrid̶a ewari waib̶ʌada osia. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Mama b̶asia Ismael, Egiptod̶ebema nezocawẽrã Agara warrada. Mãwã b̶ʌd̶e Saraba unusia Ismaelba idji warra Isara biẽ́ ipid̶a jara b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Maʌ̃ carea Saraba Abrahaʌ̃a jarasia: –Jãʌ̃ nezocawẽrãra, idji warra sid̶a jʌretadua. Bʌ beud̶acarea bʌa erob̶ʌd̶ebemara jãʌ̃ Ismaelba mʌ̃ warra ume edaiẽ́ b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Maʌ̃ bed̶ea ũrĩbʌrʌd̶e Abrahaʌ̃ra bio sopua b̶esia Ismael sid̶a idji warra bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Maʌ̃ carea Ãcõrẽba Abrahaʌ̃a jarasia: –Bʌ warra Ismael carea, bʌ nezocawẽrã carea bid̶a sopuarãdua. Saraba jara b̶ʌra jũma odua, mʌ̃a warrarã diai jarad̶ara Isad̶ebabʌrʌ zed̶i bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Baribʌrʌ bʌ nezocawẽrã warrad̶eba mʌ̃a puru dromada yõbiya, idjira bʌ warra bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Nurẽma diaped̶ed̶a Abrahaʌ̃ra pirab̶arisia. Maʌ̃be baidoda animarã e od̶ad̶e tʌped̶a maʌ̃ baidora paʌ̃ sid̶a Agaraa diasia. Agara equiad̶e b̶ʌped̶a dji warra Ismael sid̶a diasia. Maʌ̃bebʌrʌ ãdjira wãbisia. Maʌ̃ wãbʌdad̶e baridua nĩbasid̶aa Beersebá ẽjũã ewaraga b̶ʌd̶e. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Mãwã nĩnane ãdji baidora jõsia. Maʌ̃ carea Agaraba idji warrara bacuru zaque edrecare b̶eesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Nãwã crĩchasia: “Mʌ̃a unu quĩrĩãẽ́ b̶ʌa mʌ̃ warrara beubʌrʌda.” Maʌ̃ bẽrã tʌmʌa arid̶e chũmane wãsia. Mama chũmʌne idji warrara jĩgua jĩã nũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Mãwã b̶ʌd̶e Ãcõrẽba dji warrara jĩã b̶ʌda ũrĩsia. Maʌ̃ne bajãneba Ãcõrẽ nezocaba Agarada trʌ̃ jarasia: –Agara, ¿sãwãsi? Wayarãdua. Ãcõrẽba bʌ warra jĩã b̶ʌda ũrĩ b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Piradrʌdua. Bʌ warrara piradrʌ edaped̶a sobiabidua. Mʌ̃a idjid̶eba puru dromada yõbiya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Maʌ̃be Ãcõrẽba Agaraa unubisia egorod̶eba baidoda ʌ̃taa bogadrʌ nũmʌda. Ara maʌ̃da wãped̶a animarã e od̶ara bira tʌ edasia. Maʌ̃be Ismaelea dawasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ãcõrẽba Ismaelera carebabadjia. Maʌ̃ba Ismaelera wariped̶a bio cha drʌ cawa b̶esia idjab̶a ẽjũã põãsa ewaraga b̶ʌd̶e b̶abadjia. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Maʌ̃ ẽjũãra Paraʌ̃ abadjid̶aa. Mãwã b̶ʌd̶e dji papaba Egiptod̶ebema wẽrãda diasia idji quima bamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Maʌ̃ ewarid̶e Abimelera idji djõbadarã boro Picol ume wãsia Abrahaʌ̃ ume bed̶ead̶e. Abimeleba Abrahaʌ̃a jarasia: –Bʌa ne jũma obʌrʌza Ãcõrẽba bʌra carebabaria. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Maʌ̃ carea mʌ̃a quĩrĩã b̶ʌa bʌa Ãcõrẽ quĩrãpita wãrãneba jaraida bʌa mʌ̃ra, mʌ̃ warrarãra, ãdjirãneba yõbʌdarã sid̶a cũrũgaẽ́da. Bʌra drua ãĩbemamĩna mʌ̃a bʌra bia o b̶ʌa. Maʌ̃ bẽrã wãrãneba jaradua bʌa bid̶a mʌ̃ra idjab̶a mʌ̃ druad̶ebemarã sid̶a bia o b̶aida.– ");
INSERT INTO empNTpo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abrahaʌ̃ba panusia: –Mʌ̃a wãrãneba jaraya bãrãra bia o b̶aida.– ");
INSERT INTO empNTpo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Maʌ̃ ewarid̶e Abrahaʌ̃ba baido juebada uriada coro erob̶asia. Baribʌrʌ maʌ̃gʌra Abimele nezocarãba jãrĩsid̶aa. Maʌ̃nebemada Abrahaʌ̃ba Abimelea jarasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Maʌ̃ne Abimeleba panusia: –Mʌ̃a adua b̶ʌa caiba mãwã osida. Id̶ibe mʌ̃a maʌ̃nebemada ũrĩbʌrʌa, bʌa mʌ̃́a jaraẽ́ b̶ad̶a bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Maʌ̃ ewarid̶e ãdji umérãba bed̶ea b̶ʌsid̶aa. Maʌ̃ne Abrahaʌ̃ba ovejada, paca sid̶a zocãrã eneped̶a Abimelea diasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Maʌ̃be oveja wẽrãda siete awara b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Maʌ̃ carea Abimeleba Abrahaʌ̃a iwid̶isia: –¿Cãrẽ cãrẽã za panʌ oveja wẽrãra siete awara b̶ʌsi?– ");
INSERT INTO empNTpo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abrahaʌ̃ba panusia: –Naʌ̃ siete oveja mʌ̃a diabʌrʌda bʌa edaibʌrʌ, cawabiya mʌ̃abʌrʌ maʌ̃ baido juebada uriara corosida.– ");
INSERT INTO empNTpo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Umérãba bed̶ea b̶ʌped̶ad̶a bẽrã maʌ̃ baido juebada uria trʌ̃ra Beersebá b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Beersebád̶e bed̶ea b̶ʌped̶ad̶acarea Abimelera idji djõbadarã boro Picol ume jẽda wãsid̶aa ãdji panabadamaa pilisteorã druad̶e. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Maʌ̃be Beersebád̶e Abrahaʌ̃ba tamarisco bacuruda u b̶ʌsia. Mama Ãcõrẽ beucaa ewari iwid̶isia. ");
INSERT INTO empNTpo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abrahaʌ̃ra pilisteorã druad̶e dãrã b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Mãwãnacarea Ãcõrẽba nãwã osia Abrahaʌ̃ba wãrãda ĩjã b̶ʌ cawaya. Idjia Abrahaʌ̃ra trʌ̃ jarasia: –¡Abrahaʌ̃!– Abrahaʌ̃ba panusia: –¡Mʌ̃ra nama b̶ʌa!– ");
INSERT INTO empNTpo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Maʌ̃ne Ãcõrẽba jarasia: –Bʌ warra Isa ab̶abe quiruda bio quĩrĩã erob̶ʌda edaped̶a wãdua Moria druad̶aa. Mama mʌ̃a bʌ́a eyada jaradiaya. Maʌ̃ eyad̶e bʌa Isara mʌ̃́a babue diadua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ara maʌ̃da Abrahaʌ̃ra diaped̶ed̶a pirab̶ariped̶a idjia edeida b̶ʌra burro ʌ̃rʌ̃ jʌ̃cuasia. Tʌbʌda b̶ʌasia idji warrara Ãcõrẽa babue diai carea. Maʌ̃be idji warra Isara, nezocarã sid̶a umé edesia Ãcõrẽba jarad̶a eyad̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ewari ũbea babʌrʌd̶e Abrahaʌ̃ba dji eyara tʌmʌba unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Maʌ̃ne idji nezocarãa jarasia: –Nama panenadua. Burro sid̶a eropanenadua. Mʌ̃ra mʌ̃ warra ume awuá nocod̶aa wãnia Ãcõrẽa bia bed̶ead̶i carea. Mãwãnacarea bãrãmaa waya zed̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Maʌ̃be Abrahaʌ̃ba dji tʌbʌra edaped̶a idji warra Isa equiad̶e cob̶ʌsia. Necoda, tʌbʌdau sid̶a edasia. Maʌ̃be umena ãbaa wãsid̶aa Ãcõrẽa ne babue diad̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Wãbʌdad̶e Isaba Abrahaʌ̃a jarasia: –¡Zeza!– Abrahaʌ̃ba panusia: –¿Cãrẽ, warra?– Isaba iwid̶isia: –Nama dadjia tʌbʌda, tʌbʌdau sid̶a eropanʌa baribʌrʌ ¿sãma b̶ʌ oveja zaque Ãcõrẽa babue diad̶ira?– ");
INSERT INTO empNTpo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abrahaʌ̃ba panusia: –Warra, Ãcõrẽbʌrʌ oveja zaquera diaya babue diad̶i carea.– Maʌ̃be nocod̶aa wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ãcõrẽba jarad̶a eyad̶e jũẽnaped̶a Abrahaʌ̃ba mõgarada pã buesia Ãcõrẽa babue diabadada oi carea. Maʌ̃ ʌ̃rʌ̃ tʌbʌra cajẽrãped̶a idji warra Isara cabʌrá jʌ̃ped̶a tʌbʌ ʌ̃rʌ̃ cob̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Maʌ̃be Abrahaʌ̃ba necora jʌwad̶e edasia idji warra beai carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Baribʌrʌ Ãcõrẽ nezocaba bajãneba trʌ̃ jarasia: –¡Abrahaʌ̃, Abrahaʌ̃!– Abrahaʌ̃ba panusia: –Mʌ̃ra nama b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Maʌ̃ne bajãnebema nezocaba jarasia: –Bʌ warrara bearãdua. Idjira ni maãrĩ biẽ́ orãdua. Bʌa id̶ibʌrʌ mʌ̃́a cawabisia bʌa Ãcõrẽra wãrãda waya b̶ʌda, bʌ warra ab̶abe quiruda Ãcõrẽa wãgaẽ́ diai bad̶a bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abrahaʌ̃ba jẽda acʌbʌrʌd̶e oveja umaquĩrãda unusia. Maʌ̃ oveja cachura bacuru zaque jʌwated̶e jũẽ nũmasia. Ara maʌ̃da Abrahaʌ̃ra wãped̶a maʌ̃ ovejara jidasia. Maʌ̃drʌ Ãcõrẽa babue diasia idji warra cacuabari. ");
INSERT INTO empNTpo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Maʌ̃ carea Abrahaʌ̃ba dji eyara trʌ̃ b̶ʌsia “Ãcõrẽba diabaria.” Maʌ̃ bẽrã hebreorãba wad̶ibid̶a jarabadaa: “Ãcõrẽba idji eyad̶e diabaria.” ");
INSERT INTO empNTpo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Maʌ̃ne Ãcõrẽ nezocaba wayacusa bajãneba Abrahaʌ̃ra trʌ̃ jarasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","17","Nãwã jarasia: –Ãcõrẽba nãwã jara b̶ʌa: “Bʌ warra ab̶abe quiruda wãgaẽ́ diai bad̶a bẽrã, ara mʌ̃dji trʌ̃neba mʌ̃a wãrãneba jarabʌrʌa bʌra careba b̶aida. Mʌ̃a bʌd̶eba zocãrã yõbiya chĩdau zocãrã panʌ quĩrãca, pusa icawa ĩbʌ pichi zocãrã baraa quĩrãca. Maʌ̃ awara bʌd̶eba yõbʌdaba ãdji dji quĩrũ puru b̶eara jãrĩnia. ");
INSERT INTO empNTpo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Bʌa mʌ̃ bed̶eara ĩjã od̶a bẽrã mʌ̃a bʌd̶eba yõbʌrʌd̶eba naʌ̃ ẽjũãne b̶ea purura jũma carebaya.”– ");
INSERT INTO empNTpo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Mãwãnacarea Abrahaʌ̃ra jẽda wãsia idji nezocarã amenamaa. Mamaʌba ãbaa wãsid̶aa Beersebád̶aa. Mama Abrahaʌ̃ra b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Mãwãnacarea Abrahaʌ̃ba ũrĩsia idji djaba Nacoba dji quima Milca ume warrarãda unusid̶ada. ");
INSERT INTO empNTpo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Dji nabema warrara Uz abadjid̶aa. Maʌ̃are dji djaba Buzuda b̶asia. Buzuare Quemuelda b̶asia. Quemuelera Araʌ̃ zeza basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Idjab̶a Milcaba tosia Queseda, Hazoda, Pildáda, Jidlada, Betuel sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuelera Rebeca zeza basía. Milcaba maʌ̃ ocho warrarãra Abrahaʌ̃ djaba Nacoa to diasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nacoba dewara wẽrãda Reuma abadada erob̶asia. Reumaba tosia Tebada, Gahaʌ̃da, Tahada, Maacá sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Abrahaʌ̃ quima Sarara 127 poa b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Maʌ̃ne Arbá purud̶e Canaaʌ̃ druad̶e jaid̶asia. Arbá purura idjab̶a Hebroʌ̃ abadaa. Abrahaʌ̃ra Sara carea jĩã b̶ʌba sopua ewarira wagasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Mãwã b̶ʌd̶e Abrahaʌ̃ra idji quima jaid̶ad̶amaʌba hititarãmaa bed̶ead̶e wãsia. Ãdjirãa nãwã jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","–Mʌ̃ra drua ãĩbema bẽrã bãrã tãẽna ẽjũã neẽ́ b̶ʌa. Mʌ̃a quĩrĩã b̶ʌa bãrãba mʌ̃́a ẽjũãda nẽdobued̶ida mʌ̃ quima tʌb̶ari carea.– ");
INSERT INTO empNTpo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Maʌ̃ne hititarãba Abrahaʌ̃a panusid̶aa: ");
INSERT INTO empNTpo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","–Dai boro, ũrĩdua dai bed̶eara. Ãcõrẽba bʌra dairã tãẽna dji dromada b̶ʌsia. Maʌ̃ bẽrã bʌ quimara tʌb̶aridua daiba coro eropanʌ uria dji biara b̶ʌd̶e. Dairãba wãgad̶aẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Maʌ̃ne Abrahaʌ̃ra ʌ̃ta nũmeped̶a quĩrã ed̶aa b̶arrusia hititarã quĩrãpita bia quiruad̶a ai carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Maʌ̃be jarasia: –Bãrãmaa mʌ̃ quimara nama tʌb̶arida wãrãda bia b̶ʌbʌrʌ, mʌ̃ djuburia Zohar warra Eproʌ̃ ume bed̶ead̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Iwid̶id̶adua bẽwãrã joubada uria Macpela abadara mʌ̃́a nẽdobuemãrẽã. Maʌ̃ uriara idji ẽjũã icawa b̶ʌa. Maʌ̃ uria carea mʌ̃a diaya idjia iwid̶ibʌrʌ quĩrãca. Mãwãra naʌ̃ druad̶e ẽjũãda erob̶aya mʌ̃ ẽberãrã tʌb̶ari carea.– ");
INSERT INTO empNTpo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Maʌ̃ Eproʌ̃ra hitita basía. Idjira arima chũmasia. Maʌ̃ne idji ẽberãrã quĩrãpita, purud̶e ed̶a wãbʌdarã quĩrãpita bid̶a idjia Abrahaʌ̃a nãwã jĩgua jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","–Mãwãẽ́a, mʌ̃ boro, ũrĩdua. Mʌ̃ ẽberãrã quĩrãpita mʌ̃a maʌ̃ ẽjũãra dji uria sid̶a bari diaya bʌ quima tʌb̶arimãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Maʌ̃ne Abrahaʌ̃ra hititarã quĩrãpita waya quĩrã ed̶aa b̶arrusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","B̸arruped̶a jũmarã quĩrãpita Eproʌ̃a nãwã jĩgua jarasia: –Mʌ̃ quĩrã djuburia waya ũrĩdua. Dji ẽjũãbari bʌa parata iwid̶ibʌrʌ quĩrãca mʌ̃a diaya. Mʌ̃a jara b̶ʌra ĩjãdua. Mãwãbʌrʌ mʌ̃ quimara maʌ̃ ẽjũãne tʌb̶ariya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Eproʌ̃ba panusia: ");
INSERT INTO empNTpo_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","–Mʌ̃ boro, ũrĩdua. Dji ẽjũãra nẽdobueida b̶ʌa cuatrociento parata torrobari, baribʌrʌ ¿dadjimaarã maʌ̃da parataca? Bʌ quimara tʌb̶aridua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Eproʌ̃ba jarad̶ara Abrahaʌ̃ba bia ũrĩsia. Ara maʌ̃da hititarã quĩrãpita cuatrociento parata torroda juachaped̶a Eproʌ̃a jũma daucha diasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Maʌ̃ juachad̶ara hititarãba, purud̶e ed̶a wãbʌdarã bid̶a unusid̶aa. Mãwã cawasid̶aa Abrahaʌ̃ba Eproʌ̃ ẽjũã Macpela abadara nẽdosida. Maʌ̃ ẽjũãra Mamred̶eba ʌ̃mãdau odjabariare b̶ʌa. Abrahaʌ̃ba nẽdosia dji ẽjũãra, dji joubada uriara, bacuru dji ẽjũãne b̶ea sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Mãwãnacarea Abrahaʌ̃ba idji quima Sarara idjia nẽdod̶a uriad̶e tʌb̶arisia. Maʌ̃ uriara ẽjũã Macpela abadad̶e b̶ʌa. Maʌ̃ ẽjũãra Mamred̶eba ʌ̃mãdau odjabariare b̶ʌa. Mamrera idjab̶a Hebroʌ̃ abadaa. Hebroʌ̃ra Canaaʌ̃ druad̶e b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Mãwã Macpela ẽjũã, dji uria sid̶a hititarãne bad̶ada Abrahaʌ̃ba jũma edasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abrahaʌ̃ra bio drõãda b̶asia idjab̶a Ãcõrẽba idjira ne jũmane careba b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ewari ab̶a Abrahaʌ̃ba idji nezoca dji dromada trʌ̃sia. Abrahaʌ̃ba ne erob̶ʌra maʌ̃ nezocaba jũma wagabadjia. Abrahaʌ̃ba idjía jarasia: –Bʌ jʌwara mʌ̃ b̶acara edre b̶ʌdua mʌ̃́a wãrãneba jarai carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Maʌ̃be bajãne idjab̶a naʌ̃ ẽjũãne b̶ʌ Ãcõrẽ quĩrãpita mʌ̃́a jaradua bʌa mʌ̃ warra itea naʌ̃ Canaaʌ̃ druad̶ebema wẽrãda jʌrʌẽ́da. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ãtebʌrʌ wãdua mʌ̃ b̶ad̶a druad̶aa mʌ̃ ẽberãrãmaa. Wãrãneba jaradua mamabema wẽrãda mʌ̃ warra Isa itea eneida.– ");
INSERT INTO empNTpo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Maʌ̃ne dji nezocaba panusia: –Baribʌrʌ dji wẽrãda mʌ̃ ume naʌ̃ druad̶aa ze quĩrĩãẽ́bʌrʌ ¿mʌ̃a bʌ warrara bʌ b̶ad̶a druad̶aa edeica?– ");
INSERT INTO empNTpo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abrahaʌ̃ba panusia: –¡Mʌ̃ warrara jãmaa ederãdua! ");
INSERT INTO empNTpo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ãcõrẽ bajãne b̶ʌba mʌ̃ra nama enesia mʌ̃ zeza ded̶ebemada, mʌ̃ ẽberãrã druad̶ebemada. Ãcõrẽba mʌ̃́a wãrãneba jarasia idjia mʌ̃ warrarãa naʌ̃gʌ druada diaida. Ara maʌ̃ Ãcõrẽba idji bajãnebema nezocada bʌ na diabueya bʌa mʌ̃ warra itea mamabema wẽrãda enemãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Dji wẽrãda bʌ ume ze quĩrĩãẽ́bʌrʌ, bʌra naʌ̃ wãrãneba jarad̶ad̶ebemada ẽdrʌya. Baribʌrʌ mʌ̃ warrara jãmaa ederãdua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ara maʌ̃da dji nezocaba idji jʌwara Abrahaʌ̃ b̶acara edre b̶ʌsia. Maʌ̃ne wãrãneba jarasia Abrahaʌ̃ba jarad̶ara idjia oida. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Maʌ̃be dji nezocaba Abrahaʌ̃ nebiad̶ebemada quĩrãtanoa pesia dji wẽrã ẽberãrãa diai carea. Idjab̶a Abrahaʌ̃ cameyoda die edaped̶a Naco purud̶aa wãsia Mesopotamia druad̶e. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Wãbʌrʌd̶e Naco puru caita baido juebada uria corod̶ama jũẽne wãsia. Quewara jũẽna bẽrã dji nezocaba cameyora ʌ̃nãũnamãrẽã egode chũmebigasia. Maʌ̃ne wẽrãrãra baido jued̶e zesesid̶aa ãdjia ewariza obada quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Mãwã b̶ʌd̶e dji nezocaba Ãcõrẽa jarasia: –Mʌ̃ Ãcõrẽ, mʌ̃ boro Abrahaʌ̃ Ãcõrẽ, mʌ̃a bʌ́a bed̶ea djuburiaya nane bʌa quĩrĩãneba mʌ̃ boro Abrahaʌ̃ra quĩrã djuburiamãrẽã idjab̶a mʌ̃ sid̶a carebamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Mʌ̃ra naʌ̃ baidoma b̶ʌa. Naʌ̃ purud̶ebema awẽrãra namaa baido jued̶e zebadaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Mʌ̃a ab̶aʌ awẽrãa jaraya: “Mʌ̃ quĩrã djuburia bʌ zocora egode b̶ʌped̶a mʌ̃́a baidoda diadua.” Maʌ̃ne dji awẽrãba mʌ̃́a doduad̶a aibʌrʌ, idjab̶a bʌ cameyoa bid̶a baidora diayad̶a aibʌrʌ, mʌ̃a cawaya bʌa maʌ̃ awẽrãra bʌ nezoca Isa itea erob̶ʌda. Mãwãbʌrʌ mʌ̃a cawaya bʌa mʌ̃ borora quĩrĩãneba careba b̶ʌda.– ");
INSERT INTO empNTpo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Wad̶i Ãcõrẽa iwid̶i b̶ʌd̶e unusia awẽrãda zebʌrʌda. Idjia zocoda equiad̶e erob̶asia. Maʌ̃ awẽrãra Rebeca abadjid̶aa. Idjira Betuel cau basía. Betuelera Abrahaʌ̃ djaba Naco warra basía. Betuel papara Milca basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebecara bio quĩrãwãrẽã b̶asia idjab̶a wad̶i umaquĩrã adua b̶asia. Idjira baido juebada uriama jũẽsia. Maʌ̃be idji zocod̶e baidora tʌped̶a diguid̶aa wãbʌrʌ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Maʌ̃ne Abrahaʌ̃ nezocara Rebecamaa pira wãped̶a jarasia: –Mʌ̃ quĩrã djuburia, bʌ zocod̶ebema baidoda mʌ̃́a maãrĩ diadua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Maʌ̃ne Rebecaba jarasia: –Dodua, mʌ̃ boro.– Ara maʌ̃da idji zocora ed̶a edaped̶a idji jʌwad̶e erob̶ʌd̶e Abrahaʌ̃ nezocaa dobisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Dobid̶acarea jarasia: –Bʌ cameyo itea bid̶a mʌ̃a baidoda jueya ãdjia do quĩrĩãbʌda quĩrãca dod̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ara maʌ̃da baido idji zocod̶e b̶ʌra animarãba dobadad̶e weasia. Weaped̶a b̶arima zocãrã baidora juesia jũmarã cameyoba dod̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mãwã jue b̶ʌd̶e Abrahaʌ̃ nezocaba chupea acʌ b̶esia Ãcõrẽba maʌ̃ awẽrãra Isa itea wãrãda erob̶ʌ cawaya. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Cameyo baido doped̶ad̶acarea dji nezocaba Rebecaa pĩrũ oro od̶a bio nẽbʌa b̶ʌda quẽbʌd̶e jʌ̃mãrẽã diasia. Idjab̶a mania oro od̶a nẽbʌa b̶eada bio zʌgʌa b̶eada umé diasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Maʌ̃ne iwid̶isia: –¿Bʌra cai cau? Mʌ̃ djuburia jaradua, ¿bʌ zeza dera bari b̶ʌca dai cãĩni carea?– ");
INSERT INTO empNTpo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rebecaba panusia: –Mʌ̃ra Betuel caua. Betuelera Naco warraa. Idji papara Milcaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Dai dera bari b̶ʌa bãrã cãĩnamãrẽã, idjab̶a bʌ cameyoba cod̶amãrẽã baraa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Maʌ̃ carea dji nezocara chĩrãborod̶e cob̶eped̶a Ãcõrẽa bia bed̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Nãwã jarasia: –Bia quirua Ãcõrẽ, mʌ̃ boro Abrahaʌ̃ Ãcõrẽ. Bʌa mʌ̃ boro Abrahaʌ̃ra quĩrã djuburiad̶eba wãrãda careba b̶ʌa. Mʌ̃ra od̶e jipa enesia idji ẽberãrãmaa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Maʌ̃ne Rebecara dji papa diguid̶aa pira wãsia. Jũẽped̶a Abrahaʌ̃ nezocaba jarad̶ara jũma nẽbʌrʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Rebecaba djabada erob̶asia Labaʌ̃ abadada. Maʌ̃ Labaʌ̃ba ũrĩsia idji djabawẽrãba nẽbʌrʌ b̶ʌda. Idjab̶a unusia idji djabawẽrãba pĩrũda quẽbʌd̶e jʌ̃ b̶ʌda, mania sid̶a jʌwaza jʌ̃ b̶ʌda. Maʌ̃ carea baido juebadamaa pira wãsia Abrahaʌ̃ nezoca jʌrʌd̶e. Jũẽbʌrʌd̶e unusia dji nezocara idji cameyo ume baido juebadama panʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Maʌ̃ne Labaʌ̃ba jarasia: –Ãcõrẽba careba b̶ʌ ẽberã, mʌ̃ diguid̶aa zedua. Bʌra ¿cãrẽ cãrẽã puru dajada b̶ʌ? Mʌ̃ dera b̶ʌa bʌ cãĩmãrẽã idjab̶a bʌ cameyo panani sid̶a b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ara maʌ̃da dji nezocara Labaʌ̃ diguid̶aa wãsia. Jũẽnaped̶a Labaʌ̃ba cameyo ʌ̃rʌ̃ jʌ̃ b̶ead̶ara jũma ẽrãcuaped̶a ne cobigasia. Maʌ̃ awara baidoda jue diasia Abrahaʌ̃ nezoca ume zeped̶ad̶ara jĩrũ sʌgʌd̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Maʌ̃be Labaʌ̃ba ne cod̶amãrẽã diabisia baribʌrʌ Abrahaʌ̃ nezocaba jarasia: –Mʌ̃ra poya ne coẽ́a mʌ̃a bed̶ea enena jarai naẽna.– Labaʌ̃ba jarasia: –Mãẽteara jaradua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ara maʌ̃da dji nezocaba jarasia: –Mʌ̃ra Abrahaʌ̃ nezocaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Mʌ̃ borora Ãcõrẽba bio careba b̶ʌ bẽrã idjira bio ne bara b̶ʌa. Ãcõrẽba idjía ovejada, pacada, parata torroda, oroda, nezoca umaquĩrãda, nezoca wẽrãda, cameyoda, burro sid̶a zocãrã diasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Maʌ̃ awara mʌ̃ boro quima Sara djora b̶ʌba umaquĩrã warrada tosia. Mʌ̃ boroba erob̶ʌra maʌ̃ warraa jũma diasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Idjab̶a mʌ̃ boroba mʌ̃́a wãrãneba jarabisia. Idjia nãwã jarasia: “Mʌ̃ra naʌ̃ Canaaʌ̃ druad̶e b̶abaria, baribʌrʌ mʌ̃ warra itea Canaaʌ̃nebema wẽrãda jʌrʌrãdua. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ãtebʌrʌ mʌ̃ zeza druad̶aa wãdua. Mama wẽrã mʌ̃ ẽberãrãnebemada mʌ̃ warra itea jʌrʌd̶e wãdua.” ");
INSERT INTO empNTpo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Maʌ̃ne mʌ̃a jarasia: “Dji wẽrãda mʌ̃ ume ze quĩrĩãẽ́bʌrʌ ¿mʌ̃a sãwã oi?” ");
INSERT INTO empNTpo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Mʌ̃ boroba jarasia: “Mʌ̃ra Ãcõrẽ ume ewariza nĩbabaria. Ara maʌ̃ Ãcõrẽba idji bajãnebema nezocada bʌ ume diabueya bʌ wãbʌrʌma carebamãrẽã. Mãwã bʌa wẽrã mʌ̃ zeza b̶asi ẽberãrãnebemada mʌ̃ warra itea poya eneya. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Mʌ̃ ẽberãrãma jũẽnacarea ãdjirãba wẽrãda diad̶aẽ́bʌrʌ, naʌ̃ wãrãneba jarad̶ad̶ebemada bʌra ẽdrʌya.” ");
INSERT INTO empNTpo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Maʌ̃da id̶i mʌ̃ra baido juebadama jũẽped̶a Ãcõrẽa nãwã iwid̶isia: Ãcõrẽ, mʌ̃ boro Abrahaʌ̃ Ãcõrẽ, carebadua mʌ̃a od̶e zed̶ara bia odjamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Mʌ̃ra naʌ̃ baidoma b̶ʌa. Awẽrãda baido jued̶e zebʌrʌd̶e mʌ̃a idjía jaraya: “Mʌ̃ quĩrã djuburia, bʌ zocod̶ebema baidoda maãrĩ diadua.” ");
INSERT INTO empNTpo_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Maʌ̃ awẽrãba mʌ̃́a doduad̶a aibʌrʌ, idjab̶a bʌ cameyoa bid̶a baidora diayad̶a aibʌrʌ, mʌ̃a cawaya bʌa maʌ̃ wẽrãra mʌ̃ boro warra Isa itea erob̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Wad̶i mʌ̃ sod̶e bed̶ea b̶ʌd̶e unusia Rebecaba idji zocora equiad̶e eronĩda. Idjira baido juebadamaa zeped̶a baidora juesia. Maʌ̃ne mʌ̃a idjía jarasia: “Mʌ̃ quĩrã djuburia baidoda diadua.” ");
INSERT INTO empNTpo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ara maʌ̃da zoco equiad̶e erob̶ad̶ara ed̶aa edaped̶a mʌ̃́a jarasia: “Dodua, idjab̶a bʌ cameyoa bid̶a baidora diaya.” Ara maʌ̃da mʌ̃a dosia. Idjab̶a mʌ̃ cameyoa bid̶a idjia baidora dobigasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Maʌ̃be mʌ̃a iwid̶isia: “¿Bʌra cai cau?” Idjia panusia: “Mʌ̃ra Betuel caua. Betuelera Naco warraa. Idji papara Milcaa.” Maʌ̃ carea mʌ̃a pĩrũda idji quẽbʌd̶e jʌ̃ b̶ʌsia. Mania sid̶a idji jʌwad̶e jʌ̃ b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Maʌ̃be mʌ̃ra chĩrãborod̶e cob̶eped̶a Ãcõrẽa bia bed̶easia. Mʌ̃ boro Abrahaʌ̃ Ãcõrẽa bia quiruad̶a asia. Idjia mʌ̃ra bia enesia mʌ̃ boro djaba ãĩzaqueda idji warra itea edemãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Bãrãba mʌ̃ boroda wãrãda quĩrã djuburiad̶eba carebad̶ibʌrʌ, mʌ̃́a jarad̶adua Rebecara mʌ̃ ume diabued̶ida. Baribʌrʌ diabued̶aẽ́bʌrʌ jarad̶adua mʌ̃a cawa crĩchai carea.– ");
INSERT INTO empNTpo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Maʌ̃ ũrĩnaped̶a Labaʌ̃ba Betuel bid̶a panusid̶aa: –Maʌ̃gʌra wãrãda Ãcõrẽneba ze b̶ʌa. Maʌ̃ bẽrã daiba poya jarad̶aẽ́a bia b̶ʌda wa biẽ́ b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebecara nama bʌ quĩrãpita b̶ʌa. Ededua idjira bʌ boro warra quima bamãrẽã Ãcõrẽba jarad̶a quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Maʌ̃ bed̶ea carea Abrahaʌ̃ nezocara chĩrãborod̶e cob̶eped̶a Ãcõrẽa bia bed̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Maʌ̃be oro od̶ada, parata od̶ada, cacuad̶e jʌ̃bada sid̶a Rebecaa diasia. Idjab̶a nebia nẽbʌa b̶eada Rebeca djabaa, dji papaa bid̶a diasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Maʌ̃bebʌrʌ dji nezocara, idji ume zeped̶ad̶a sid̶a ne cosid̶aa. Ne cod̶aped̶a cãĩsid̶aa. Nurẽma pirab̶ariped̶a dji nezocaba jarasia: –Mʌ̃ra idu wãbid̶adua mʌ̃ boromaa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Baribʌrʌ Rebeca djababa, dji papa bid̶a panusid̶aa: –Rebecara wad̶ibid̶a die ewari dai ume b̶aida b̶ʌa. Mãwãnacarea bʌ ume wãida b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Maʌ̃ne dji nezocaba jarasia: –Ãcõrẽba mʌ̃́a dji wẽrãda unubid̶a bẽrã mʌ̃ra nama dãrãbirãnadua. Mʌ̃ra idu wãbid̶adua mʌ̃ boromaa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Baribʌrʌ Rebeca djababa, dji papa bid̶a panusid̶aa: –Mãwã baibʌrʌ, Rebecara trʌ̃nia cãrẽda jarai cawaya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ara maʌ̃da Rebecara trʌ̃naped̶a iwid̶isid̶aa: –¿Bʌra naʌ̃ ẽberã ume nawena wãica?– Maʌ̃ne Rebecaba panusia: –Mãẽ, mʌ̃ra wãya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ara maʌ̃da Rebecara idji wagabari wẽrã ume idu wãbisid̶aa. Idjab̶a Abrahaʌ̃ nezocara, idji ume zeped̶ad̶a sid̶a idu wãbisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Maʌ̃ne Rebeca djabarãba idjira nãwã bia jarasid̶aa: Djabawẽrã, daiba quĩrĩã panʌa bʌa warrarãra zocãrã unuida. Idjab̶a quĩrĩã panʌa bʌ warrarãba ãdji dji quĩrũrãda poyad̶ida. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Maʌ̃be Rebecara idji nezocawẽrãrã sid̶a cameyo ʌ̃rʌ̃ chũmenaped̶a Abrahaʌ̃ nezoca ume wãsid̶aa. Mãwã Abrahaʌ̃ nezocaba Rebecara edesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Maʌ̃misa Abrahaʌ̃ warra Isara Beer-Lajai-Roid̶eba zed̶ada Negue druad̶e b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ewari ab̶a quewara babʌrʌd̶e idjira drua pʌrrʌa nĩbasia. Maʌ̃ne cameyoda zesebʌdada unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","65","Ara maʌ̃ne Rebeca cameyo ʌ̃rʌ̃ chũmʌba Isara unusia. Maʌ̃ bẽrã Rebecaba Abrahaʌ̃ nezocaa iwid̶isia: –¿Cai awuá dadjirãmaa zebʌrʌra?– Nezocaba panusia: –Jãʌ̃ra mʌ̃ boro Isaa.– Maʌ̃ bed̶ea ũrĩped̶a Rebecara cameyod̶eba ud̶aa b̶adosia. Mãwãped̶a idji quĩrãdarrara quẽbʌ daucha wuaba bʌrasia, Isa quima baida bed̶ea b̶ʌd̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Maʌ̃ne Abrahaʌ̃ nezocaba od̶ara jũma Isaa nẽbʌrʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ara maʌ̃da Isaba Rebecara idji papa querasi wua demaa edesia. Mãwã Isaba Rebecara edaped̶a bio quĩrĩã b̶esia. Idjab̶a idji papa jaid̶ad̶a carea sopuara jõsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrahaʌ̃ra waya quima edasia. Dji wẽrã trʌ̃ra Queturá basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Maʌ̃ Queturába tosia Zimraʌ̃, Jocsaʌ̃, Medaʌ̃, Madiaʌ̃, Isbac, Súa sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jocsaʌ̃ warrarãra naʌ̃gʌrã basía: Sebá, Dedaʌ̃ sid̶a. Dedaʌ̃neba yõsid̶aa asureorã, letuseorã, leumeorã sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Madiaʌ̃ warrarãra naʌ̃gʌrã basía: Epá, Eper, Hanoc, Abidá, Eldá sid̶a. Jũma maʌ̃gʌrãda Queturád̶eba yõsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Abrahaʌ̃ wad̶i zocai b̶ʌd̶e Queturába tod̶a warrarãa, Agaraba tod̶a warraa bid̶a Abrahaʌ̃ba nebiada diacuasia. Maʌ̃be ãdjirãra Isa b̶ʌmaʌba ʌ̃mãdau odjabariare tʌmʌ wãbigasia. Maʌ̃bebʌrʌ Abrahaʌ̃ba idjia erob̶ʌra jũma Isaa diasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrahaʌ̃ra 175 poa b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Maʌ̃ne bio drõãda quiruda waraga jaid̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Dji warrarã Isaba, Ismael bid̶a idjira tʌb̶arisid̶aa bẽwãrã joubada uria Macpela abadad̶e Sara tʌb̶ariped̶ad̶ama. Maʌ̃ uriara Mamre ẽjũãneba ʌ̃mãdau odjabariare b̶ʌa. Dji ẽjũãra Abrahaʌ̃ba hitita Zohar warra Eproʌ̃neda nẽdosia. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abrahaʌ̃ jaid̶ad̶acarea Ãcõrẽba dji warra Isara bia b̶ʌsia. Isara baido juebada uria caita b̶abadjia. Dji baido juebada uriara Beer-Lajai-Roi abadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Nama b̶ʌ́ b̶ʌa Ismaeld̶eba yõped̶ad̶ad̶ebemada. Maʌ̃ Ismaelera Abrahaʌ̃ba unusia Agarad̶eba. Agarara Sara nezocawẽrã Egiptod̶ebema basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismael warrarã trʌ̃ra naʌ̃gʌrã basía: dji iwinada Nebayo basía. Idjiare Cedar basía. Maʌ̃are Adbeel basía. Maʌ̃are Mibsaʌ̃ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Maʌ̃are Mismá basía. Maʌ̃are Dumá basía. Maʌ̃are Masá basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Maʌ̃are Hadar basía. Maʌ̃are Temá basía. Maʌ̃are Jetu basía. Maʌ̃are Napi basía. Dji jĩrũarebemara Cedemá basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Maʌ̃gʌrã docera Ismael warrarã basía. Ãdjirãneba puruda doce yõsid̶aa. Ãdjira maʌ̃ puru bororãda b̶easia. Maʌ̃ doce purura ara ãdji trʌ̃da b̶ʌcuasid̶aa. Dji ẽberãrã sid̶a ara maʌ̃ trʌ̃ra eropanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismaelera 137 poa b̶asid̶e jaid̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Idji warrarãba birasid̶aa Sur ẽjũãneba ab̶a Havila ẽjũãnaa. Sur ẽjũãra Egipto drua caita b̶ʌa. Havilara Asiria druad̶aa wãbada od̶e b̶ʌa. Ãdji ẽberãrãnebemada jĩga panabadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Nama b̶ʌ́ b̶ʌa Isa warrarãnebemada. Isara Abrahaʌ̃ warra basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isa cuarenta poa b̶asid̶e idji quima Rebecara edasia. Rebecara Betuel cau basía idjab̶a Labaʌ̃ djabawẽrã basía. Ãdjirãra arameorã basía. Padan-Araʌ̃ druad̶ebemarã basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isa quima Rebecara warra toca basía. Maʌ̃ carea Isaba Ãcõrẽa iwid̶isia Rebeca b̶iogoamãrẽã. Idjia iwid̶id̶ara Ãcõrẽba bia ũrĩsia. Mãwã Rebecara mĩguisoda b̶iogoa b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Maʌ̃ne warrarãra idji b̶ited̶a djõ panʌ bẽrã idjia crĩchasia: “¿Sãwãẽrã mʌ̃ra jãwã mĩga b̶ʌ?” Maʌ̃ carea Ãcõrẽa iwid̶id̶e wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Maʌ̃ne Ãcõrẽba panusia: Bʌ b̶ited̶a warrada umé djõ panʌ bẽrã bʌra jãwã b̶ʌa. Ãdjid̶eba puruda umé odjad̶ia. Ab̶aʌda dewarabema cãyãbara mẽsrãara b̶aya. Dji nabemada dji tẽãbema jʌwaed̶a b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Dji toi ewari jũẽsid̶e Rebecaba umé tosia. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Dji nabemara bio caraid̶a b̶asia. Idjira cara purea b̶asia. Maʌ̃ carea dji trʌ̃ra b̶ʌsid̶aa Esaú. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Esaú tobʌrʌd̶e dji tẽãbemaba idji jĩrũgarronane jida to b̶aesia. Maʌ̃ carea idjira trʌ̃ b̶ʌsid̶aa Jacobo. Rebeca warra tosid̶e Isara sesenta poa b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Maʌ̃ warrarãra warisid̶aa. Esaúra mẽã wã cawa b̶asia. Baribʌrʌ Jacobora diguid̶a necai b̶abadjia. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Esaúba animarã beaped̶a dji zezaa cobibadjia. Maʌ̃ bẽrã Isaba Esaúra bio quĩrĩã b̶asia. Maʌ̃ne Rebecaba biara Jacoboda quĩrĩã b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ewari ab̶a Jacobora ne dju b̶asia. Maʌ̃ne Esaúra mẽã nĩbad̶ada jarra jũẽsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esaúba jarasia: –Mʌ̃ djuburia, bʌa lenteja purea dju b̶ʌda mʌ̃́a cobidua. Mʌ̃ra cacua ʌb̶ʌaẽ́ b̶ʌa, ne coẽ́ b̶ʌ bẽrã.– Lenteja purea b̶ʌ carea Esaúra idjab̶a trʌ̃ b̶ʌsid̶aa “Edoʌ̃.” ");
INSERT INTO empNTpo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Maʌ̃ne Jacoboba jarasia: –Bʌra dji warra iwina bẽrã dadji zezaba erob̶ʌd̶ebemada bʌa waib̶ʌara edaya. Bʌa edaida b̶ʌra za b̶ʌ lentejabari mʌ̃́a nẽdobuedua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esaúba jarasia: –Mʌ̃ra jarrababa beubod̶oa. Mʌ̃da beuibʌrʌ, dadji zezad̶e edaida b̶ʌra ¿sãwã edai?– ");
INSERT INTO empNTpo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Maʌ̃ne Jacoboba jarasia: –Naãrã wãrãneba jaradua bʌa dadji zezad̶e edaida b̶ʌra mʌ̃́a diaida.– Ara maʌ̃da Esaúba wãrãneba jarasia. Mãwã dji warra iwinaba edaida b̶ʌra Esaúba Jacoboa nẽdobuesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Maʌ̃bebʌrʌ Jacoboba lentejara paʌ̃ sid̶a Esaúa diasia. Esaúba coped̶a baido do b̶aped̶a wãsia. Mãwã dji warra iwinaba edaida b̶ad̶ara Esaúba igarasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Maʌ̃ ewarid̶e Isa druad̶e jarrabada zesia Abrahaʌ̃ ewarid̶e zed̶a quĩrãca. Maʌ̃ carea Isara Guerar purud̶aa wãsia pilisteorã boro Abimelemaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Isa mama b̶ʌd̶e Ãcõrẽra idjimaa zeped̶a jarasia: –Egipto druad̶aa wãrãdua, ãtebʌrʌ mʌ̃a jarabʌrʌ druad̶e b̶edua. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Bʌra drua ãĩbemamĩna nama b̶edua. Mʌ̃ra bʌ ume b̶aya. Mʌ̃a bʌra carebaya: mʌ̃a bʌ́a, bʌ warrarãa bid̶a naʌ̃ druara diaya. Mãwã mʌ̃a bʌ zeza Abrahaʌ̃a wãrãneba jarad̶ara oya. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Mʌ̃a bʌ warrarãra zocãrã yõbiya bajãne chĩdau zocãrã panʌ quĩrãca. Mʌ̃a jũma naʌ̃ druara bʌd̶eba yõbʌdarãa diaya idjab̶a mʌ̃a bʌd̶eba yõbʌrʌd̶eba naʌ̃ ẽjũãne b̶ea purura jũma carebaya. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Mʌ̃a mãwã oya Abrahaʌ̃ba mʌ̃ bed̶eara jũma ĩjã od̶a bẽrã; mʌ̃a obid̶ada, mʌ̃a jara b̶ʌd̶ada, mʌ̃a jaradiad̶ada, mʌ̃ ley sid̶a idjia jũma ĩjã osia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Maʌ̃ bẽrã Isara Guerar purud̶e b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Maʌ̃ne Guerard̶ebemarãba Isaa dji quima Rebecad̶ebemada iwid̶isid̶aa, idjira quĩrãwãrẽã b̶ʌ bẽrã. Maʌ̃ carea Isara ne wayasia. Idub̶a crĩcha b̶esia mʌ̃ quimaana aibʌrʌ, mʌ̃ra bead̶isicada edad̶i carea. Maʌ̃ carea ãdjia iwid̶ibʌdad̶e panubadjia: “Idjira mʌ̃ djabawẽrãa.” ");
INSERT INTO empNTpo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isa mama dãrã b̶ʌd̶e pilisteorã boro Abimeleba dajadaa acʌbadad̶eba unusia Isaba idji quima Rebecara yãga nũmʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Maʌ̃ bẽrã Abimeleba Isara trʌ̃biped̶a jarasia: –Jãʌ̃ wẽrãra wãrãda bʌ quimaa. ¿Cãrẽ cãrẽã bʌa jarasi bʌ djabawẽrãda?– Isaba panusia: –Mʌ̃a crĩchasia bãrãba mʌ̃ra bead̶ida mʌ̃ quima edad̶i carea.– ");
INSERT INTO empNTpo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimeleba jarasia: –¿Cãrẽ cãrẽã jãwã osi? Mʌ̃ purud̶ebemarã ab̶aʌda bʌ quima ume cãĩnabara, bʌabʌrʌ daia maʌ̃ cadjiruara obicasia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Maʌ̃ bẽrã Abimeleba idji ẽberãrãa jarasia: –Bariduaba Isada mĩã sẽibʌrʌ wa dji quimada mĩã sẽibʌrʌ, maʌ̃ ẽberãra beuida b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Maʌ̃ druad̶e Isara ne úsia. Ab̶ari poad̶e idjia waib̶ʌa ewasia, Ãcõrẽba idjira ne jũmane careba b̶ad̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Mãwã idjira bio bara b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ovejada, pacada, nezocarã sid̶a zocãrã erob̶esia. Maʌ̃ carea pilisteorãra idji ume biẽ́ panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Idji zeza Abrahaʌ̃ zocai b̶asid̶e Abrahaʌ̃ nezocarãba baido juebada uriada corocuasid̶aa. Baribʌrʌ pilisteorãra Isa ume biẽ́ panʌ bẽrã maʌ̃ baido juebada uriara jũma egoroba ãnãcuasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Maʌ̃be dji boro Abimeleba Isaa jarasia: –Dai tãẽnabemada ãyã wãdua, bʌra dairã cãyãbara dji dromaara b̶ebʌrʌ bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ara maʌ̃da Isara Guerar purud̶e b̶ad̶ada ãyã wãsia. Guerar jewed̶ad̶e jũẽped̶a idji wua dera oped̶a mama b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Abrahaʌ̃ wad̶i zocai b̶asid̶e idjia baido juebada uriada mama corobicuasia. Idji beud̶acarea pilisteorãba maʌ̃ baido juebada uriara egoroba jũma ãnãcuasid̶aa. Baribʌrʌ Isa mama b̶ad̶e zesid̶e waya corobicuaped̶a ab̶ari trʌ̃da b̶ʌcuasia dji zezaba naẽna b̶ʌd̶ada. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ewari ab̶a Isa nezocarãba dji jewed̶ad̶e coro panasid̶aa. Coro panʌne baido ʌ̃taa bogadrʌ b̶ʌda unusid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Baribʌrʌ maʌ̃ baido carea Guerard̶ebema oveja wagabadada Isa oveja wagabada ume ijarasid̶aa. Guerard̶ebemarãba jarasid̶aa: –Naʌ̃ baidora dairãnea.– Maʌ̃ carea ijaraped̶ad̶a bẽrã Isaba baido juebada uriara trʌ̃ b̶ʌsia Esec. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Mãwãnacarea Isa nezocarãba dewara baido juebada uriada corosid̶aa. Baribʌrʌ maʌ̃ carea bid̶a ijarasid̶aa. Maʌ̃ baido juebada uriara trʌ̃ b̶ʌsia Sitna. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Maʌ̃be Isara mamabemada ãyã b̶ad̶e wãsia. Mama dewara baido juebada uriada corosia. Maʌ̃ baido carea ijarad̶aẽ́ basía. Maʌ̃ne Isaba jarasia: –Ʌ̃rãbʌrʌ Ãcõrẽba dadjirãra bia b̶ʌsia naʌ̃gʌ ẽjũãne ne bara paneni carea.– Mãwã dji baido juebada uriara trʌ̃ b̶ʌsia Rehobo. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Mamaʌba Beersebád̶aa wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Maʌ̃ diamasi Ãcõrẽra Isama odjaped̶a nãwã jarasia: Mʌ̃ra bʌ zeza Abrahaʌ̃ba ĩjã b̶ad̶a Ãcõrẽa. Ne wayarãdua. Mʌ̃ra bʌ ume b̶ʌa. Mʌ̃a bʌra nãwã careba b̶aya: bʌ warrarãra mʌ̃a zocãrã yõbiya mʌ̃ nezoca Abrahaʌ̃ra carebayad̶a ad̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ãcõrẽda mama odjad̶a bẽrã Isaba mõgarada ʌ̃tʌ pã bueped̶a idjía ewari iwid̶isia. Maʌ̃be idji wua dera osia mama dãrã b̶ai carea. Idjab̶a idji nezocarãba mama baido juebada uriada corosid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ewari ab̶a Guerar purud̶ebema boro Abimelera Isamaa zesia. Abimelera zesia idji crĩcha diabari Ahuzat ume, idji djõbadarã boro Picol ume bid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Maʌ̃ne Isaba Abimelea jarasia: –Bãrãba mʌ̃ra unu ama panana bẽrã, bãrã tãẽnabemada ãyã jʌretasid̶aa. Maʌ̃da ¿cãrẽ cãrẽã mʌ̃maa ze panʌ?– ");
INSERT INTO empNTpo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","29","Maʌ̃ne ãdjia panusid̶aa: –Daiba unu panʌa Ãcõrẽra bʌ ume b̶ʌda. Maʌ̃ carea daiba crĩcha panʌa bʌ ume necai panani carea bed̶eada b̶ʌd̶ida. Daiba bʌra necai wãbisid̶aa idjab̶a bʌ ume ab̶abe biada osid̶aa. Maʌ̃ bẽrã wãrãneba nãwã bed̶ea b̶ʌd̶ia: daiba bʌ mĩã sẽnaẽ́ panʌ quĩrãca bʌa bid̶a daira mĩã sẽẽ́da. Wãrãda Ãcõrẽba bʌra bio careba b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Maʌ̃ carea Isaba b̶ʌsrid̶a ne cobada waib̶ʌada oped̶a ãdjirãra ne codruasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Nurẽma pirab̶arid̶aped̶a wãrãneba bed̶ea b̶ʌsid̶aa necai panani carea. Maʌ̃be Isaba ãdjía bia wãnaduad̶a asia. Ãdjirã bid̶a bia b̶eduad̶a ad̶aped̶a wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","33","Maʌ̃misa Isa nezocarãba egoro coro panʌne baidoda unusid̶aa. Ununaped̶a Isamaa jarad̶e zesid̶aa. Idjia maʌ̃gʌ ewarid̶e bed̶ea b̶ʌd̶a carea maʌ̃ baido juebada uriara trʌ̃ b̶ʌsia Sebá. Maʌ̃ carea mamabema purura wad̶ibid̶a Beersebá abadaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Isa warra Esaú cuarenta poa b̶asid̶e Beerí cau Judida edasia. Maʌ̃ awara edasia Eloʌ̃ cau Basemá sid̶a. Maʌ̃ Judira, Basemá sid̶a hitita wẽrãrã basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Maʌ̃ne ãdji umena Isa ume Rebeca ume bid̶a bia pananaca basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isara drõãda b̶ʌ bẽrã dauba unuca basía. Ewari ab̶a idji warra nabema Esaúda trʌ̃ped̶a jarasia: –¡Warra!– Esaúba panusia: –¿Cãrẽ, zeza?– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Maʌ̃ne Isaba jarasia: –Acʌdua, warra, mʌ̃ra drõãda b̶ʌa. Mʌ̃ beui ewarira adua b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Maʌ̃ carea mʌ̃ djuburia bʌ enedrʌmada cha sid̶a edaped̶a mẽã wãdua. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ne beasira mʌ̃ itea djudua mʌ̃a awua cobari quĩrãca. Maʌ̃da cobisira mʌ̃a bʌra bia jara b̶ʌya mʌ̃ beui naẽna.– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Isara idji warra Esaú ume bed̶ea b̶ʌda Rebecaba ũrĩ b̶asia. Maʌ̃be Esaúra mẽã wãsia dji zezaa cobi carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Esaú wãnacarea Rebecaba idji warra Jacoboa jarasia: –Warra, mʌ̃a ũrĩsia bʌ zezara bʌ djaba Esaú ume bed̶ea b̶ʌda. Bʌ zezaba Esaúa nãwã jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Mẽã ne bead̶e wãped̶a mʌ̃ itea djudua. Maʌ̃ djicora coped̶a mʌ̃ beui naẽna bʌda Ãcõrẽ quĩrãpita bia jara b̶ʌya.” ");
INSERT INTO empNTpo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Jãʌ̃be, warra, mʌ̃a jarabʌrʌda odua. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Dadji animarã b̶eamaa wãped̶a chiwatu zaque boreguea panʌda umé enedua. Maʌ̃be mʌ̃ra bʌ zeza itea ne djuya idjia awua cobari quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Maʌ̃da bʌa bʌ zezamaa edeya idjia comãrẽã. Mãwã idji beui naẽna bʌdrʌ bia jara b̶ʌya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Maʌ̃ne Jacoboba dji papa Rebecaa jarasia: –Mʌ̃ djaba Esaúra caraid̶a b̶ʌa, maʌ̃ne mʌ̃ra cara neẽ́ b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Mʌ̃ zezaba mʌ̃da tãibʌrʌ, cawaya mʌ̃a idjira cũrũga b̶ʌda. Maʌ̃da cawasira idjia mʌ̃ra bia jara b̶ʌẽ́a, ãtebʌrʌ biẽ́ jara b̶ʌya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Maʌ̃ne dji papaba panusia: –Mãwã biẽ́ jara b̶ʌsira mʌ̃maabʌrʌ zeya. Warra, odua mʌ̃a jara b̶ʌ quĩrãca. Chiwatu zaquera isabe jʌrʌd̶e wãdua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ara maʌ̃da Jacobora wãped̶a chiwatu zaquera enesia idji papamaa. Eneped̶a idji papaba djicoda osia Jacobo zezaba awua cobari quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Maʌ̃be dji warra nabema Esaúba jʌ̃bari dji biara b̶ʌda Rebecaba enesia. Esaúba maʌ̃ jʌ̃barira ãdji ded̶e erob̶asia. Maʌ̃da Rebecaba Jacoboa jʌ̃bisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Maʌ̃ awara Jacobora cara neẽ́ b̶ʌ bẽrã Rebecaba chiwatu zaque eda idji jʌwad̶e, ʌ̃rʌ̃mʌsid̶e bid̶a caracuasia. Mãwã osia dji zezaba Esaúdrʌ crĩchamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Maʌ̃be djico warra djud̶ada paʌ̃ sid̶a idji warra Jacoboa diasia dji zezamaa edemãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Idji zezamaa wãped̶a Jacoboba jarasia: –¡Zeza!– Isaba panusia: –¿Cãrẽ, warra? Bʌra ¿caida mãwã b̶ʌ?– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Maʌ̃ne Jacoboba idji zezaa jarasia: –Mʌ̃ra bʌ warra nabema Esaúa. Mʌ̃a osia bʌa jarad̶a quĩrãca. Ʌ̃ta chũmeped̶a ne codua. Maʌ̃be mʌ̃ra bia jara b̶ʌdua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaba dji warraa iwid̶isia: –Mʌ̃ warra, ¿sãwã jãcua isabe ne beasi?– Jacoboba panusia: –Bʌ ume b̶ʌ Ãcõrẽba mʌ̃́a unubisia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Maʌ̃ne Isaba jarasia: –Warra, mʌ̃ caita zedua. Mʌ̃́a idu tãbidua bʌra wãrãda mʌ̃ warra Esaú cawaya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ara maʌ̃da Jacobora dji zezaba tãmãrẽã caita wãsia. Maʌ̃ne Isaba jarasia: –Bʌ bed̶eara Jacobo bed̶eaca b̶ʌa, baribʌrʌ bʌ jʌwara Esaú jʌwaca b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","24","Isaba Jacobora cawaẽ́ basía idji jʌwara Esaú jʌwa quĩrãca caraid̶a b̶ʌ bẽrã. Isaba Jacobo bia jara b̶ʌbʌrʌd̶e wayacusa iwid̶isia: –¿Bʌra wãrãda mʌ̃ warra Esaúca?– Jacoboba panusia: –Mãẽ, zeza. Mʌ̃ra Esaúa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Maʌ̃ne dji zezaba jarasia: –Warra, bʌa ne bead̶ara diadua mʌ̃a coi carea. Maʌ̃be mʌ̃a bʌra bia jara b̶ʌya.– Ara maʌ̃da Jacoboba diasia. Diad̶acarea Isaba cosia. Mãwã b̶ʌd̶e Jacoboba uva b̶a sid̶a diasia. Maʌ̃gʌ sid̶a Isaba dosia. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Maʌ̃bebʌrʌ Isaba jarasia: –Jãʌ̃be warra, mʌ̃ caita chũmeped̶a mʌ̃ uridarrad̶e isõdua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ara maʌ̃da Jacobora caita chũmeped̶a isõsia. Maʌ̃ne Jacoboba jʌ̃ b̶asia Esaúba jʌ̃barida. Isaba maʌ̃ra ʌ̃ped̶a crĩchasia wãrãda Esaúda idji ume b̶ʌda. Maʌ̃ bẽrã idjia Jacobodrʌ nãwã bia jara b̶ʌsia. Mʌ̃ warrara tũãpa b̶ʌa Ãcõrẽba bia zaubi b̶ʌ ẽjũã quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Mʌ̃a quĩrĩã b̶ʌa Ãcõrẽba bʌ itea bajãneba cue zebi b̶aida bʌa ubʌrʌra bia zaumãrẽã. Mãwã bʌ trigora ad̶uba zauya. Bʌ uva sid̶a bia zauya. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Mʌ̃a quĩrĩã b̶ʌa puruda zocãrã bʌ jʌwaed̶a b̶ead̶ida, druazabemada bʌ quĩrãpita wayaad̶eba chĩrãborod̶e cob̶ead̶ida. Mʌ̃a quĩrĩã b̶ʌa bʌra bʌ djabarã boro baida, bʌ papa warrarãda bʌ quĩrãpita chĩrãborod̶e cob̶ead̶ida. Mʌ̃a quĩrĩã b̶ʌa bʌ biẽ́ jarabʌdara biẽ́ b̶ead̶ida idjab̶a bʌ bia jarabʌdara bia b̶ead̶ida. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaba mãwã bia jara b̶ʌd̶acarea Jacobora idji zeza ume b̶ad̶ada ẽdrʌsia. Ara ẽdrʌbʌrʌd̶e idji djaba Esaúra mẽã wã b̶ad̶ada jũẽsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Idjia bid̶a djicoda warra osia. Maʌ̃da dji zezamaa edeped̶a jarasia: –Zeza, mʌ̃ra ne beasia. Ʌ̃ta chũmeped̶a codua. Maʌ̃be mʌ̃ra bia jara b̶ʌdua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Maʌ̃ne Isaba Esaúa jarasia: –Bʌra ¿caida mãwã b̶ʌ?– Esaúba panusia: –Mʌ̃ra bʌ warra iwina Esaúa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaba maʌ̃ ũrĩbʌrʌd̶e dauperaped̶a ure nũmesia. Maʌ̃ne jarasia: –Mãẽteara ¿caida bʌ na ze b̶asi? Idjia bead̶ara mʌ̃́a diasia. Maʌ̃da mʌ̃a jũma cosia bʌ zei naẽna. Mʌ̃a idjira bia jara b̶ʌsia. Maʌ̃ bẽrã idjidrʌ bia b̶aya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esaúba dji zeza bed̶ea ũrĩsid̶e ab̶ed̶a bio sopuasia. Maʌ̃ne jĩã b̶ʌba jĩgua jarasia: –¡Zeza, mʌ̃ sid̶a bia jara b̶ʌdua!– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Maʌ̃ne dji zezaba panusia: –Bʌ djababa mʌ̃ra cũrũgad̶e ze b̶asia. Mãwã mʌ̃a bʌ bia jara b̶ʌi bad̶ara idjiabʌrʌ edasia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Maʌ̃ne Esaúba jarasia: –¡Bãrãba jãʌ̃ cũrũgabari Jacobora arid̶e trʌ̃ b̶ʌsid̶aa! ¡Idjia mʌ̃ra b̶arima umé cũrũgabʌrʌa! Mʌ̃a warra iwinaba edaida b̶ad̶ara idjia edasia. Jãʌ̃be id̶i bʌa mʌ̃ bia jara b̶ʌi bad̶ara idjia jãrĩsia.– Maʌ̃ne Esaúba wayacusa iwid̶isia: –¿Bʌa mʌ̃ sid̶a poya bia jara b̶ʌẽ́ca?– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaba panusia: –Mʌ̃a Jacobora bʌ boroda b̶ʌsia. Bʌ ẽberãrãra, bʌd̶eba yõbʌda sid̶a idji jʌwaed̶a b̶ʌsia. Idjab̶a mʌ̃a jara b̶ʌsia idji trigora uva sid̶a ad̶uba zaumãrẽã. Maʌ̃ba, warra, mʌ̃a bʌ́a ¿cãrẽda poya diai?– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Maʌ̃ne Esaúba dji zezaa b̶ia iwid̶isia: –Zeza, bʌa ¿ab̶abe idjidrʌ poya bia jara b̶ʌica? ¡Ay, zeza, mʌ̃ sid̶a bia jara b̶ʌdua!– Mãwã jara b̶ʌd̶e Esaúra bio jĩã nũmasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Mãwã b̶ʌd̶e dji zeza Isaba jarasia: Bʌra ẽjũã biad̶ebemada, cue zebarimabemada jĩga b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Bʌra dewara ẽberãrã ume djõ b̶aya, idjab̶a bʌ djaba jʌwaed̶a b̶aya. Baribʌrʌ bʌa ĩjã o ama b̶ebʌrʌd̶e idji jʌwaed̶a b̶ad̶ada ẽdrʌya. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ãdji zeza Isaba Jacoboda bia jara b̶ʌd̶a bẽrã Esaúba Jacobora bio quĩrãma b̶esia. Maʌ̃ carea nãwã crĩchasia: “Mʌ̃ zeza beud̶acarea mʌ̃a sopua ewarida wagaya. Maʌ̃bebʌrʌ mʌ̃ djaba Jacobora beaya.” ");
INSERT INTO empNTpo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Esaúba oi crĩcha b̶ʌra dji papa Rebecaba cawasia. Maʌ̃ carea idji warra tẽãbema Jacobora trʌ̃ped̶a jarasia: –Ũrĩdua, bʌa od̶a carea bʌ djaba Esaúba bʌra bea quĩrĩã b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","45","Idjia bʌda beaibʌrʌ, idji sid̶a bead̶ida panʌa. Mãwãra mʌ̃a ab̶ari ewarid̶e bãrã umena aduaya. Maʌ̃ carea, warra, mʌ̃a jarabʌrʌda ĩjã odua. Isabe Haraʌ̃ purud̶aa mĩrũ wãdua mʌ̃ djaba Labaʌ̃maa. Jãma idji ume dãrã b̶adua ab̶a bʌ djaba quĩrũbi jõbʌrʌd̶aa. Bʌa od̶ada idjia quĩrãdoasira mʌ̃a bʌ́a bed̶eada diabueya waya zemãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Jacobo wãi naẽna Rebecaba dji quima Isaa jarasia: –Mʌ̃ra sẽ b̶ʌa Esaú quima hititarã carea. Jacobo bid̶a naʌ̃ druad̶ebema hitita wẽrãda edaibʌrʌ, biara b̶ʌa mʌ̃ra beuida.– ");
INSERT INTO empNTpo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Maʌ̃ bẽrã Isaba Jacobora trʌ̃ped̶a bia jara b̶ʌsia. Idjab̶a nãwã jarasia: –Canaaʌ̃nebema wẽrãda edarãdua. ");
INSERT INTO empNTpo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Padan-Araʌ̃ druad̶aa wãdua bʌ zezadrõã Betuelmaa. Mama bʌ djabadrõã Labaʌ̃ caurãnebemada ab̶a edadua. ");
INSERT INTO empNTpo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ãcõrẽ ne jũma poya o b̶ʌba bʌra careba b̶aya warra zocãrã unumãrẽã. Mãwã bʌd̶eba puruda zocãrã yõnia. ");
INSERT INTO empNTpo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Idjab̶a Ãcõrẽba Abrahaʌ̃a diai jarad̶a ẽjũãda idjia bʌ́a, bʌd̶eba yõbʌdarãa bid̶a diaya. Mãwã naʌ̃ ẽjũãra bãrãne baya, bʌra nawena nama ãĩbema quĩrãca b̶ʌmĩna.– ");
INSERT INTO empNTpo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Mãwã Isaba Jacobora wãbisia Padan-Araʌ̃ druad̶aa. Maʌ̃be Jacobora wãsia idji djabadrõã Labaʌ̃ ded̶aa. Maʌ̃ Labaʌ̃ra Betuel warra basía. Betuelera arameo basía. Labaʌ̃ra Rebeca djaba basía. Rebecara Jacobo idjab̶a Esaú papa basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Jacobo wãi naẽna idji zeza Isaba idjira bia jara b̶ʌped̶a jarasia Canaaʌ̃nebema wẽrãda edarãmãrẽã. Ãtebʌrʌ wãbisia Padan-Araʌ̃ druad̶ebema wẽrãda edamãrẽã. Esaúba maʌ̃gʌra jũma unu b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Maʌ̃ awara unu b̶asia Jacoboba idji zeza bed̶ea, idji papa bed̶ea sid̶a ĩjã oped̶a Padan-Araʌ̃ druad̶aa wãsida. ");
INSERT INTO empNTpo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Maʌ̃gʌd̶eba Esaúba cawasia idji zezaba Canaaʌ̃nebema wẽrãrãra quĩrĩãcada. ");
INSERT INTO empNTpo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Maʌ̃ carea Esaúra wãsia Abrahaʌ̃ warra Ismaelmaa. Ismaelera Esaú djabadrõã basía. Maʌ̃ne Esaúba Ismael cau Majalada edasia. Majalara Nebayo djabawẽrã basía. Esaúba dewara quimarã pe erob̶ʌd̶e maʌ̃ wẽrã sid̶a edasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Maʌ̃ne Jacobora Beersebád̶eba Haraʌ̃ purud̶aa wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Wãbʌrʌd̶e ota queusia. Mama mõgarada cob̶ʌsia idji borocaui carea. Maʌ̃be egode tab̶eped̶a cãĩsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Cãĩ b̶ʌd̶e cãĩmocarad̶e unusia dume drasoga b̶ʌda chũ nũmʌda. Maʌ̃ dumera dud̶aʌba bajãnaa tẽũ nũmasia. Maʌ̃ne Jacoboba unusia Ãcõrẽ bajãnebema nezocarãda dumene ʌ̃taa wã duanʌda idjab̶a ed̶aa ze duanʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Idjab̶a unusia Ãcõrẽda dume borod̶e nũmʌda. Mãwã b̶ʌd̶e Ãcõrẽba jarasia: –Mʌ̃ra bʌ zezadrõã Abrahaʌ̃ Ãcõrẽa, bʌ zeza Isa Ãcõrẽa. Bʌ cãĩ b̶ʌ ẽjũãra mʌ̃a bʌ́a, bʌ warrarãa bid̶a diaya. ");
INSERT INTO empNTpo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Bʌ warrarãra zocãrã yõnia egoro pora quĩrãca. Ãdjirãra wãbʌrʌd̶ia ʌ̃mãdau odjabariare, ʌ̃mãdau b̶aebariare, jʌwa araare, jʌwa acʌare bid̶a. Idjab̶a bʌd̶eba, bʌd̶eba yõbʌrʌd̶eba bid̶a mʌ̃a jũma naʌ̃ ẽjũãne b̶ea purura carebaya. ");
INSERT INTO empNTpo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mʌ̃ra bʌ ume b̶ʌa. Mʌ̃a bʌra wagaya bʌ wãbʌrʌza, idjab̶a mʌ̃a bʌra naʌ̃ ẽjũãnaa waya eneya. Bʌra igaraẽ́a, ãtebʌrʌ wãrãda mʌ̃a jara b̶ʌd̶ada jũma bʌ itea oya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Maʌ̃ne Jacobora cãĩ b̶ad̶ada ʌ̃rʌ̃maped̶a nãwã crĩchasia: “Wãrãda Ãcõrẽra nama b̶ʌa, baribʌrʌ mʌ̃a adua b̶asia.” ");
INSERT INTO empNTpo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ne wayaad̶eba jarasia: “¡Nama bio minijĩchia b̶ʌa! Ãcõrẽ dera nama b̶ʌa, idjab̶a bajãnaa wãbada o sid̶a nama b̶ʌa.” ");
INSERT INTO empNTpo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Nurẽma diaped̶ed̶a Jacobora pirab̶ariped̶a borocau erob̶ad̶a mõgarara ʌ̃ta nũmʌsia sẽyãda b̶amãrẽã. Maʌ̃ mõgara ʌ̃rʌ̃ nedragada weasia Ãcõrẽra mama b̶ʌ bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","22","Mama Jacoboba wãrãneba nãwã jarasia: –Ãcõrẽda mʌ̃ ume wãibʌrʌ, mʌ̃ wãbʌrʌma wagaibʌrʌ, ne coi carea diaibʌrʌ, cacuad̶e jʌ̃barida diaibʌrʌ, idjab̶a mʌ̃ zezamaa waya jẽda eneibʌrʌ, mʌ̃a idjidrʌ ĩjã b̶aya. Maʌ̃ carea naʌ̃ mõgara sẽyã b̶ʌd̶ara Ãcõrẽ de baya.– Mãwã dji mama b̶ʌ puru Luz abadara Jacoboba trʌ̃ b̶ʌsia Betel. Idjab̶a Jacoboba Ãcõrẽa jarasia: –Bʌa mʌ̃́a die diabʌrʌza mʌ̃a bʌ́a ab̶a dia b̶aya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Mãwãnacarea Jacobora nocod̶aa wãsia. Wãne ʌ̃mãdau odjabariarebema ẽberãrã druad̶e jũẽne wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Mama baido juebada uria corod̶ada unusia. Maʌ̃ caita ovejada zocãrã panasid̶aa. Maʌ̃ ovejara ãdji djibarirã ũbea panʌ caita awara awara ʌ̃nãũ duanasid̶aa. Djibarirãba maʌ̃ baidora ãdji ovejaa jue diabadjid̶aa. Dji baido juebada uria ʌ̃rʌ̃ mõgara waib̶ʌada cob̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ewariza oveja jũma eneped̶ad̶acarea dji oveja wagabadaba maʌ̃ mõgarara ãyã b̶ʌbadjid̶aa ãdji ovejaa baido jue diad̶i carea. Jue diaped̶ad̶acarea wayacusa mõgarara dji uria ʌ̃rʌ̃ cob̶ʌbadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Maʌ̃ne Jacoboba dji oveja wagabadaa iwid̶isia: –Djabarã, ¿bãrãra sãmabema?– Ãdjia panusid̶aa: –Daira Haraʌ̃ purud̶ebemaa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Jacoboba iwid̶isia: –¿Bãrãba Naco warra Labaʌ̃ra unubadaca?– Ãdjia panusid̶aa: –Mãẽ, daiba unubadaa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Jacoboba waya iwid̶isia: –¿Idjira bia b̶ʌca?– Ãdjia panusid̶aa: –Idjira bia b̶ʌa. Acʌdua, jari urua dji cau Raquelda. Idji zeza ovejada pe enebʌrʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Maʌ̃ne Jacoboba jarasia: –Acʌd̶adua, wad̶i ãsa nũmʌ bẽrã animarãra cãĩne eded̶iẽ́ panʌa. Ovejara baido dobigad̶aped̶a waya põãjãrã cobid̶e eded̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ãdjirãba panusid̶aa: –Wad̶ibid̶a poya baido dobid̶aẽ́a. Daiba jʌ̃ãbadaa jũmarãba ãdji ovejara enenamãrẽã. Maʌ̃bebʌrʌ mõgara baido juebada uria ʌ̃rʌ̃ cob̶ʌra ãyã b̶ʌbadaa ovejara baido dobigad̶i carea.– ");
INSERT INTO empNTpo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Jacobo ãdjirã ume bed̶ea b̶ʌd̶e Raquelba idji zeza ovejara pe enesia. Idjira dji oveja wagabari basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Raquel zeza Labaʌ̃ra Jacobo papa Rebeca ume dji djaba basía. Jacoboba Raquel, Labaʌ̃ oveja sid̶a unusid̶e baido juebada uriamaa wãped̶a dji mõgara uria ʌ̃rʌ̃ cob̶ʌra ãyã b̶ʌsia. Ãyã b̶ʌped̶a idji djabadrõã Labaʌ̃ ovejara baido dobigasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Maʌ̃ne Jacobora b̶ʌsrid̶asia idji papa ẽberãrãma jũẽna bẽrã. Maʌ̃ carea Raquel uridarrad̶e isõped̶a jĩãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Maʌ̃be Jacoboba jarasia: –Mʌ̃ra bʌ zeza Labaʌ̃ tẽãbeaa. Mʌ̃ papa Rebecara bʌ apipia.– Ara maʌ̃da Raquelera diguid̶aa pira wãsia idji zeza jarad̶e. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labaʌ̃ba maʌ̃ ũrĩped̶a pira wãsia idji djabawẽrã warra Jacobo audiab̶arid̶e. Jacobo b̶ʌmaa wãped̶a ojũẽ edaped̶a uridarrad̶e isõsia. Maʌ̃be diguid̶aa edesia. Diguid̶a jũẽnaped̶a Jacoboba Labaʌ̃a idji sãwãnanebemada jũma nẽbʌrʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Maʌ̃ne Labaʌ̃ba Jacoboa jarasia: –Wãrãda bʌra mʌ̃ ẽberãrãa.– Mãwãnacarea Jacobora Labaʌ̃ ume jed̶eco ab̶a b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Jed̶eco ab̶a b̶ad̶acarea Labaʌ̃ba Jacoboa jarasia: –Bʌra mʌ̃ tẽãbeamĩna mʌ̃ itea bari trajaiẽ́ b̶ʌa. Mʌ̃́a jaradua jũmasãwã diaida b̶ʌda bʌ trajubari.– ");
INSERT INTO empNTpo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labaʌ̃ba cauda umé erob̶asia. Dji nabema trʌ̃da Lea basía. Raquelera dji tẽãbema basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leara mãcua quĩrãwãrẽãẽ́ b̶asia. Baribʌrʌ Raquelera bio quĩrãwãrẽã b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Maʌ̃ne Jacoboba Raquelda bio quĩrĩã b̶asia. Maʌ̃ carea Labaʌ̃a jarasia: –Bʌ cau tẽãbema Raquel edai carea mʌ̃ra siete poa bʌ itea bari traja b̶aya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Maʌ̃ne Labaʌ̃ba panusia: –Biara b̶ʌa mʌ̃ caura bʌ́a diaida dewara ẽberãa diai cãyãbara. Mãẽteara mʌ̃ itea bari traja b̶edua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ara maʌ̃da Jacobora Raquel edai carea Labaʌ̃ itea siete poa bari trajasia. Jacoboba Raquelera bio quĩrĩã b̶ʌ bẽrã idjimaarã maʌ̃ siete poara dãrãẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Siete poa bad̶acarea Jacoboba Labaʌ̃a jarasia: –Dadjia b̶ʌped̶ad̶a ewarira jũẽna bẽrã bʌ caura diadua mʌ̃ quima bamãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ara maʌ̃da Labaʌ̃ba mamabemarãra jũma trʌ̃bigasia dji cau quima edabʌrʌ b̶ʌsrid̶ada oi carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","24","Baribʌrʌ diamasi maʌ̃ b̶ʌsrid̶a o panasid̶ad̶e Labaʌ̃ba idji cau nabema Leada Jacoboa diasia. Idjab̶a idji nezocawẽrã Zilpa abadada Leaa diasia nezoca bara b̶amãrẽã. Maʌ̃ne Jacoboba Leada mãwã b̶ʌda adua b̶asia, diamasi nũmʌ bẽrã. Ara maʌ̃da Jacobora Lea ume cãĩsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Nurẽma Jacoboba unusia Leadrʌ idji cʌd̶ad̶e b̶ʌda. Maʌ̃ carea Labaʌ̃maa wãped̶a jarasia: –¿Cãrẽ cãrẽã bʌa mʌ̃ra jãwã osi? ¿Mʌ̃ra Raquel carea bʌ itea bari trajaẽ́ basica? ¿Cãrẽ cãrẽã mʌ̃ra cũrũgasi?– ");
INSERT INTO empNTpo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Maʌ̃ne Labaʌ̃ba panusia: –Nama dai druad̶e dji nabemadrʌ na quima diabadaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Lea edabʌrʌ b̶ʌsrid̶ara domia ab̶a odua. Mãwãnacarea mʌ̃a dewarabema sid̶a diaya baribʌrʌ bʌra wayacusa siete poa idji carea mʌ̃ itea bari trajaida b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacoboba bia b̶ʌad̶a asia. Maʌ̃ bẽrã b̶ʌsrid̶ara domia ab̶a osia. Maʌ̃be Labaʌ̃ba idji cau Raquelera Jacoboa diasia dji quima bamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labaʌ̃ba idji nezocawẽrã Bilha abadada idji cau Raquelea diasia nezoca bara b̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ara maʌ̃da Jacobora Raquel ume cãĩsia idjab̶a idjira Lea cãyãbara quĩrĩãra erob̶esia. Maʌ̃be Jacobora wad̶i siete poa bari traja b̶esia Labaʌ̃ itea. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Maʌ̃ne Ãcõrẽba unusia Jacoboba Leara quĩrĩãẽ́ b̶ʌda. Maʌ̃ carea Ãcõrẽba Leaa warrarãda diasia, baribʌrʌ Raquelera warra toca basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leara b̶iogoa b̶eped̶a umaquĩrã warrada tosia. Maʌ̃ne crĩchasia: “Mʌ̃ mĩga b̶ʌra Ãcõrẽba acʌsia. Id̶ibʌrʌ mʌ̃ quimaba mʌ̃ra biara quĩrĩãya.” Mãwã dji warrara trʌ̃ b̶ʌsia Rubeʌ̃. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Leara wayacusa b̶iogoa b̶eped̶a umaquĩrã warrada tosia. Maʌ̃ne crĩchasia: “Ãcõrẽba mʌ̃́a naʌ̃ warra sid̶a diasia mʌ̃ quimaba mʌ̃ quĩrĩãẽ́ b̶ʌ ũrĩna bẽrã.” Mãwã dji warrara trʌ̃ b̶ʌsia Simeoʌ̃. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Wayacusa b̶iogoa b̶eped̶a umaquĩrã warrada tosia. Maʌ̃ne crĩchasia: “Id̶ibʌrʌ mʌ̃ quimara mʌ̃ ume ãbaa b̶aya, mʌ̃a idji warrada ũbea tobʌrʌ bẽrã.” Mãwã dji warrara trʌ̃ b̶ʌsia Levi. ");
INSERT INTO empNTpo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Wayacusa b̶iogoa b̶eped̶a umaquĩrã warrada tosia. Maʌ̃ne crĩchasia: “Naʌ̃ne mʌ̃a Ãcõrẽa bia bed̶eaya.” Mãwã dji warrara trʌ̃ b̶ʌsia Juda. Maʌ̃are Leara dãrãsia warra toẽ́ b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raquelera warra toca bẽrã idji djabawẽrã Lea ume sod̶e biẽ́ b̶esia. Maʌ̃ carea Raquelba Jacoboa jarasia: –Mʌ̃ra warra quĩrĩã b̶ʌa. Warrada unuẽ́bʌrʌ, biara b̶ʌa mʌ̃ra beuida.– ");
INSERT INTO empNTpo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Maʌ̃ carea Jacobora Raquel ume quĩrũped̶a jarasia: –¿Mãwãra mʌ̃da Ãcõrẽca? Idjiabʌrʌ bʌra warra idu unubiẽ́ b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Maʌ̃be Raquelba jarasia: –Mʌ̃ nezocawẽrã Bilhada b̶ʌa. Idji ume cãĩdua. Idjia warrada toibʌrʌ, maʌ̃ warrara mʌ̃re baya. Mãwã mʌ̃ra Bilhad̶eba warra erob̶aya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ara maʌ̃da Raquelba idji nezocawẽrã Bilhara Jacoboa quima quĩrãca diasia. Maʌ̃be Jacobora Bilha ume cãĩsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhara b̶iogoa b̶eped̶a umaquĩrã warrada tosia. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Maʌ̃ne Raquelba jarasia: “Mʌ̃a iwid̶id̶ara Ãcõrẽba ũrĩsia. Idjia mʌ̃́a warra diad̶aba cawabi b̶ʌa mʌ̃a jipa osida.” Mãwã dji warrara trʌ̃ b̶ʌsia Daʌ̃. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Mãwãnacarea Raquel nezocawẽrã Bilhara wayacusa b̶iogoa b̶eped̶a umaquĩrã warrada Jacoboa to diasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raquelba jarasia: “Mʌ̃ djabawẽrã ume bio djõ b̶ʌd̶e mʌ̃a poyasia.” Mãwã dji warrara trʌ̃ b̶ʌsia Neptali. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Maʌ̃ ewarid̶e Leaba crĩchasia waa warrara toẽ́da. Maʌ̃ carea idji nezocawẽrã Zilpada Jacoboa quima quĩrãca diasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Mãwã Zilpaba umaquĩrã warrada Jacoboa to diasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Maʌ̃ne Leaba jarasia: “Mʌ̃ra boro biasia.” Mãwã dji warrara trʌ̃ b̶ʌsia Ga. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Mãwãnacarea Lea nezocawẽrã Zilpaba wayacusa umaquĩrã warrada Jacoboa to diasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Maʌ̃ne Leaba jarasia: “Mʌ̃ra bio b̶ʌsrid̶a b̶ʌa. Id̶ibʌrʌ wẽrãrãba jarad̶ia mʌ̃ra b̶ʌsrid̶a b̶ʌda.” Mãwã dji warrara trʌ̃ b̶ʌsia Aser. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Trigo ewabada ewarid̶e Jacobo warra iwina Rubeʌ̃ra trigo ud̶amaa wãsia. Mama unusia mandragojõda. Maʌ̃ra Rubeʌ̃ba b̶a edaped̶a idji papa Lea itea edesia. Lea djabawẽrã Raquelba maʌ̃ unuped̶a Leaa jarasia: –Mʌ̃ quĩrã djuburia bʌ warraba mandragojõ enenanebemada mʌ̃́a diadua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Maʌ̃ne Leaba jarasia: –¿Ya bia b̶ʌẽ́ca bʌa mʌ̃ quima jãrĩnada? Maʌ̃ awara ¿bʌa mʌ̃ warra mandragojõ sid̶a jãrĩca?– Raquelba panusia: –Bʌ warra mandragojõda mʌ̃́a diasira nane diamasi Jacobora bʌ ume cãĩya.– Raquelba jarad̶ara Leaba bia ũrĩsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Maʌ̃ bẽrã Jacobo quewara idji ẽjũãneba jũẽbʌrʌd̶e Leara idji audiab̶arid̶e wãsia. Maʌ̃be jarasia: –Nane diamasi bʌra mʌ̃ ume cãĩya mʌ̃ warra mandragojõra Raquelea diad̶abari.– Maʌ̃ diamasi Jacobora idji ume cãĩsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Leaba iwid̶id̶ara Ãcõrẽba ũrĩsia. Mãwã Leara waya b̶iogoa b̶eped̶a umaquĩrã warrada tosia. Maʌ̃ warrara idjia juesuma tod̶a basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Maʌ̃ne Leaba jarasia: “Mʌ̃ nezocawẽrãda mʌ̃ quimaa diad̶abari Ãcõrẽba mʌ̃́a nebiada diasia.” Mãwã dji warrara trʌ̃ b̶ʌsia Isacar. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Mãwãnacarea Leara wayacusa b̶iogoa b̶eped̶a umaquĩrã warrada Jacoboa to diasia. Maʌ̃ warrara idjia sei tod̶a basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leaba jarasia: “Ãcõrẽba mʌ̃́a nebiada diasia. Mʌ̃a sei umaquĩrã warra tod̶a bẽrã mʌ̃ quimaba mʌ̃ra bia unuya.” Mãwã dji warrara trʌ̃ b̶ʌsia Zabuloʌ̃. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Mãwãnacarea wẽrãcauda tosia. Idjira trʌ̃ b̶ʌsia Dina. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Maʌ̃ne Ãcõrẽba Raquelera quĩrãdoaẽ́ b̶asia. Raquelba iwid̶id̶ara idjia ũrĩna bẽrã warrada idu unubisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Maʌ̃ warra tosid̶e Raquelba jarasia: “Mʌ̃ warra toca carea pera b̶ad̶ara Ãcõrẽba ãyã b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Mʌ̃a quĩrĩã b̶ʌa Ãcõrẽba warrada dewara diaida.” Mãwã dji warrara trʌ̃ b̶ʌsia Jose. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Jose tod̶acarea ewari ab̶a Jacoboba dji zãwãrẽ Labaʌ̃a nãwã jarasia: –Mʌ̃ra mʌ̃ druad̶aa idu wãbidua. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Mʌ̃ quimarãda, mʌ̃ warrarã sid̶a idu edebidua. Mʌ̃ quimarã carea bʌ itea bari traja b̶asia. Maʌ̃ bẽrã mʌ̃ra idu wãbidua. Bʌa cawa b̶ʌa mʌ̃ra bʌ itea bio trajasida.– ");
INSERT INTO empNTpo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Baribʌrʌ Labaʌ̃ba jarasia: –Mʌ̃ quĩrã djuburia mʌ̃ ume b̶edua. Mʌ̃a quĩrãcuita acʌ b̶ʌd̶eba cawa b̶ʌa Ãcõrẽba mʌ̃ra bʌd̶eba careba b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Mʌ̃́a jaradua bʌ traja b̶ʌbari jũmasãwã quĩrĩã b̶ʌda. Ara maʌ̃ quĩrãca mʌ̃a diaya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jacoboba jarasia: –Bʌa cawa b̶ʌa mʌ̃ra bʌ itea sãwã bia traja b̶ʌda idjab̶a bʌ animarã qued̶eara sãwã panʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Mʌ̃ zei naẽna bʌa zocãrãẽ́be erob̶asia. Baribʌrʌ mʌ̃ jũẽnacarea zocãrã yõsia Ãcõrẽba bʌra careba b̶ʌ bẽrã. Id̶iba ʌ̃taa mʌ̃ra mʌ̃dji warrarã itea traja quĩrĩã b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","32","Maʌ̃ne Labaʌ̃ba iwid̶isia: –¿Bʌ waya nama traja b̶ei carea paratada jũmasãwã iwid̶i b̶ʌ?– Jacoboba panusia: –Mʌ̃a paratara iwid̶iẽ́ b̶ʌa. Mʌ̃a bʌ ovejara wayacusa waga b̶eya mʌ̃a jarabʌrʌda ĩjãibʌrʌ: nane mʌ̃ra bʌ ovejamaa, chiwatumaa bid̶a wãped̶a dji gorogoroa qued̶eada, dji bagabaga qued̶eada, oveja zaque pãĩma qued̶ea sid̶a awara b̶ʌya. Jũma mãwã b̶eara mʌ̃a edaya nama traja b̶ei carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Mʌ̃ animarã bʌa acʌd̶e zebʌrʌd̶e ab̶abe chiwatu bagabaga b̶eada, gorogoroa b̶eada, idjab̶a oveja pãĩma b̶eada unuibʌrʌ cawaya mʌ̃a arid̶e o b̶ʌda. Baribʌrʌ mãwã b̶eaẽ́da mʌ̃ animarã tãẽna unuibʌrʌ, ebud̶a b̶aya mʌ̃a bʌreda drʌasida.– ");
INSERT INTO empNTpo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labaʌ̃ba jarasia: –Bia b̶ʌa, odua bʌa jara b̶ʌ quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Baribʌrʌ ara maʌ̃ ewarid̶e Jacoboba oveja, chiwatu sid̶a awara b̶ʌd̶e wãi naẽna Labaʌ̃ba chiwatu dji umaquĩrã bagabaga b̶eara, gorogoroa b̶eara, chiwatu wẽrãrã bagabaga b̶eara, jĩjĩjĩjĩã b̶eara, tod̶otod̶oa b̶eara idjab̶a oveja pãĩma b̶ea sid̶a chupea ãyã b̶ʌsia. Maʌ̃gʌ animarãra Jacoboba edaida b̶ad̶amĩna Labaʌ̃ba idji warrarãa diasia ara idji itea wagad̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Maʌ̃be ãdjirãba Jacobo b̶ʌmaʌba ãyã ewari ũbea edesid̶aa. Maʌ̃ne Jacoboba waabema animarã idjia edaiẽ́ b̶ʌda arima waga b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Maʌ̃be Jacoboba animarã idji itea edai carea nãwã osia: bacuru jʌwate onoada b̶ʌá tu edasia. Álamoda, almendroda, castaño sid̶a b̶ʌá tu edasia. Maʌ̃ra erruerrua jod̶acuasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Maʌ̃be bacuru erruerrua jod̶acuad̶ara dji animarã baido dobadama b̶ʌcuasia. Mama animarãra warra obadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ãdjia maʌ̃ bacuru quĩrãpita warra osid̶ara, bagabaga, jĩjĩjĩjĩã b̶ea sid̶a tocuabadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Maʌ̃gʌ animarã qued̶eara Jacoboba awara b̶ʌ wãsia. Maʌ̃ awara oveja warra o panʌne Jacoboba dji oveja wẽrãa Labaʌ̃ animarã patrupatrua b̶eada, pãĩma b̶ea sid̶a acʌbibadjia. Maʌ̃ ovejaba patrupatrua qued̶eada, pãĩma b̶ea sid̶a tosid̶a bẽrã Jacoboba awara b̶ʌ wãsia ara idji itea. Labaʌ̃ animarã ume ãbaa b̶ʌẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Maʌ̃ awara animarã boregueara b̶eara warra obʌdaza Jacoboba bacuru jod̶acuad̶ara ãdji baido dobadama b̶ʌbadjia maʌ̃ bacuru ununamãrẽã. Mãwã dji boreguea b̶eaba patrupatrua b̶eada, bagabaga b̶eada jĩjĩjĩjĩã b̶ea sid̶a tocuabadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Baribʌrʌ animarã caya qued̶ea mamaa zebʌdad̶e Jacoboba bacurura b̶ʌca basía. Maʌ̃ bẽrã animarã caya qued̶eara Labaʌ̃ itea b̶esia, baribʌrʌ dji boreguea b̶eara Jacobo itea b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Mãwã Jacobora ne barasia. Ovejada, chiwatuda, nezoca umaquĩrãda, nezoca wẽrãda, cameyoda, burro sid̶a zocãrã erob̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Maʌ̃ ewarid̶e Labaʌ̃ warrarãba Jacoboda nãwã biẽ́ jara panasid̶aa: –Jacoboba jũma dai zezad̶eda edaped̶a bio ne bara b̶esia.– Mãwã jara panʌda Jacoboba cawasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Maʌ̃ awara unubadjia Labaʌ̃ra idji ume naãrã bia b̶ad̶a quĩrãca b̶ʌẽ́da. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Mãwã b̶ʌd̶e Ãcõrẽba Jacoboa jarasia: –Wãdua bʌ djibarirã druad̶aa, bʌ ẽberãrãmaa. Mʌ̃ra bʌ ume b̶aya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Maʌ̃be Jacoboba idji quimarã Raquelda, Lea sid̶a trʌ̃bisia idji oveja erob̶ʌmaa zed̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ãdji jũẽped̶ad̶acarea Jacoboba jarasia: –Mʌ̃a unu b̶ʌa bãrã zezara mʌ̃ ume naãrã b̶ad̶a quĩrãca b̶ʌẽ́da, baribʌrʌ mʌ̃ zezaba ĩjã b̶ʌ Ãcõrẽda mʌ̃ ume b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Bãrãba cawa panʌa mʌ̃ra bãrã zeza itea bio trajasida. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Baribʌrʌ idjia mʌ̃ra cũrũgabadjia. Mʌ̃a edaida b̶ʌra idjia b̶arima zocãrã quĩrã awara obadjia. Wãrãda idjia mʌ̃ ume biẽ́ o quĩrĩã b̶asia. Baribʌrʌ Ãcõrẽba idu mãwã obiẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Labaʌ̃ba mʌ̃ traja b̶ʌbari jũma dji animarã gorogoroa b̶eada edaida b̶ʌad̶a asid̶e mamaʌba ʌ̃taa jũma ovejaba gorogoroa tobadjid̶aa. Idjab̶a dji patrupatrua b̶eada mʌ̃a edaida b̶ʌad̶a asid̶e mamaʌba ʌ̃taa jũma ovejaba patrupatrua tobadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Mãwã Ãcõrẽba bãrã zeza animarãra jãrĩsia mʌ̃́a diai carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Maʌ̃ ewarid̶e animarã dji wẽrãrã põnõ b̶easid̶e mʌ̃a cãĩmocarasia. Maʌ̃ cãĩmocarad̶e mʌ̃a unusia animarãra warra o b̶eada. Dji umaquĩrãra ʌ̃cʌrʌ gorogoroa b̶easia, ʌ̃cʌrʌ patrupatrua b̶easia, idjab̶a ʌ̃cʌrʌ bagabaga b̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Mãwã b̶ʌd̶e Ãcõrẽba mʌ̃ra trʌ̃sia: “¡Jacobo!” Mʌ̃a panusia: “Nama b̶ʌa.” ");
INSERT INTO empNTpo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","13","Maʌ̃ne idjia jarasia: “Mʌ̃ra bʌa Beteld̶e ununa Ãcõrẽa. Maʌ̃ Beteld̶e bʌa mõgara ʌ̃rʌ̃ nedraga wead̶ama bʌa wãrãneba jarasia mʌ̃a bʌda wagaibʌrʌ, bʌa mʌ̃drʌ ĩjã b̶aida. Bio acʌdua animarãra warra o b̶eada. Dji umaquĩrãra jũma gorogoroa b̶eaa, patrupatrua b̶eaa, idjab̶a bagabaga b̶eaa. Mãwã mʌ̃a bʌra careba b̶ʌa Labaʌ̃ba bʌra biẽ́ o b̶ʌ bẽrã. Jãʌ̃be piradrʌped̶a namaʌba bʌ tod̶a druad̶aa wãdua.”– ");
INSERT INTO empNTpo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Maʌ̃ne Raquelba Lea bid̶a jarasid̶aa: –Dai zezaba erob̶ʌd̶ebemada daia ni cãrẽ sid̶a diaẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ãtebʌrʌ daira drua ãĩbema quĩrãca osia. Idjia daira nẽdobuesia. Maʌ̃ awara dai nẽdobued̶abari edad̶ara jũma cobuesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Baribʌrʌ Ãcõrẽba dai zezad̶era jãrĩsia. Maʌ̃gʌra wãrãda dadjid̶ea idjab̶a dadji warrarãnea. Maʌ̃ carea jũma Ãcõrẽba bʌ́a jara b̶ʌ quĩrãca odua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","19","Maʌ̃ ewarid̶e Labaʌ̃ra idji oveja cara tʌ b̶ʌda tʌmʌ b̶asia. Maʌ̃misa Raquelera chupea idji zeza ded̶e ed̶a wãped̶a dji zeza jʌwaba od̶a ãcõrẽda drʌasia. Maʌ̃be Jacoboba idji warrarãra, idji quimarã sid̶a cameyo ʌ̃rʌ̃ chũmʌsia. Ara maʌ̃da Canaaʌ̃ druad̶aa wãsia idji zeza Isamaa. Jũma idjia Padan-Araʌ̃ druad̶e edad̶ara edesia. Dji animarã sid̶a jʌre edesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jacoboba idji wãinebemada Labaʌ̃a jaraẽ́ basía. Mãwã Jacoboba arameo Labaʌ̃ra cũrũgasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Jacobora jũma idjia erob̶ʌ bara mĩrũ wãsia. Wãbʌrʌd̶e Euprate do quĩrãrã chãsia. Maʌ̃be Gala eyaid̶a b̶ʌ druad̶aa wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ewari ũbea bad̶acarea Labaʌ̃ba cawasia Jacobora mĩrũ wãsida. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Maʌ̃ bẽrã Labaʌ̃ba idji ẽberãrã edaped̶a Jacobo caid̶u ẽpẽ wãsia. Siete ewari ẽpẽ wãbʌrʌd̶e Labaʌ̃ba Jacobora tʌmʌba unusia Gala eyaid̶a b̶ʌ druad̶e. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","25","Maʌ̃ne Labaʌ̃ra idji ẽberãrã sid̶a ota cãĩsid̶aa. Maʌ̃ diamasi Ãcõrẽba arameo Labaʌ̃a cãĩmocarad̶e nãwã jarasia: “¡Labaʌ̃, ũrĩdua! ¡Jacobo ume quĩrũ bed̶earãdua!” Nurẽma Labaʌ̃ra idji ẽberãrã ume Gala druad̶e Jacobo b̶ʌma jũẽnaped̶a ãdji wua dera ocuasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Maʌ̃be Labaʌ̃ba Jacoboa jarasia: –¿Cãrẽ cãrẽã bʌa mʌ̃ra cũrũgasi? Bʌa mʌ̃ caurãra namaa enesia djõbadarãba ãdjia poyaped̶ad̶ara jida edebada quĩrãca. ¿Cãrẽ cãrẽã jãwã osi? ");
INSERT INTO empNTpo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Bʌ wãira mʌ̃́a jaraẽ́ basía. ¿Cãrẽ cãrẽã jãwã chupea wãsi? Bʌa jarad̶abara mʌ̃a b̶ʌsrid̶a ewarida ocasia. Trʌ̃ãbiba, tõnõãba, arpa bid̶a b̶ʌsrid̶ada ocasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Maʌ̃ awara bʌa mʌ̃ wiuzaquerãra, mʌ̃ caurã sid̶a idu isõbiẽ́ basía. Crĩcha neẽ́ b̶ʌ quĩrãca bʌa osia. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mʌ̃a bãrãra poya biẽ́ oida b̶ʌa. Mãwãmĩna id̶i diamasi bʌ zeza ume b̶ʌ Ãcõrẽba mʌ̃́a jarasia: “¡Jacobo ume quĩrũ bed̶earãdua!” ");
INSERT INTO empNTpo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Bʌra waya bʌ zezamaa wã quĩrĩã b̶ʌbʌrʌ, bia b̶ʌa. Baribʌrʌ ¿cãrẽ cãrẽã bʌa mʌ̃ jʌwaba od̶a ãcõrẽra drʌasi?– ");
INSERT INTO empNTpo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacoboba panusia: –Mʌ̃ wãira jaraẽ́ basía bʌda waya b̶ʌ bẽrã. Mʌ̃a crĩchasia bʌa bʌ caurãda jãrĩda. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Mʌ̃a bʌ jʌwaba od̶a ãcõrẽra drʌaẽ́ basía. Baridua nama b̶ʌba erob̶ʌbʌrʌ, beuida b̶ʌa. Jũmarã quĩrãpita jʌrʌdua mʌ̃a bʌreda erob̶ʌ cawaya. Mʌ̃a erob̶ʌbʌrʌ, edadua.– Jacoboba adua b̶asia Labaʌ̃ jʌwaba od̶a ãcõrẽra Raquelba drʌa erob̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ara maʌ̃da Labaʌ̃ba Jacobo wua ded̶e ed̶a jʌrʌd̶e wãsia. Maʌ̃are nezocawẽrãrã wua ded̶e ed̶a jʌrʌd̶e wãsia. Lea wua ded̶e bid̶a jʌrʌd̶e wãsia. Mãwãmĩna idji jʌwaba od̶a ãcõrẽra unuẽ́ basía. Maʌ̃ bẽrã Lea wua ded̶eba ẽdrʌped̶a Raquel wua ded̶aa wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Baribʌrʌ ed̶a wãi naẽna Labaʌ̃ jʌwaba od̶a ãcõrẽra Raquelba cameyo ʌ̃rʌ̃ chũmebada edrecare mẽrãsia. Maʌ̃be maʌ̃gʌ ʌ̃rʌ̃ chũmesia. Labaʌ̃ba jũma dji dejãne jʌrʌd̶amĩna unuẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Maʌ̃ne Raquelba jarasia: –Zeza, quĩrũrãdua mʌ̃ra bʌ quĩrãpita poya piradrʌẽ́ bẽrã. Mʌ̃ra jed̶eco unu b̶ʌa.– Labaʌ̃ba idji jʌwaba od̶a ãcõrẽra unuẽ́ bad̶amĩna wad̶i jʌrʌ b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Maʌ̃ carea Jacobora quĩrũped̶a jarasia: –¿Cãrẽ cadjiruada od̶a bẽrã bʌa mʌ̃ra jãcua ẽpẽ b̶ʌ? ");
INSERT INTO empNTpo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Bʌa mʌ̃ netatara ab̶ed̶a jũma ware acʌsia. Dai ded̶e ¿bʌreda unusica? Mʌ̃a drʌad̶ada unusibʌrʌ, jũmarãa ebud̶a acʌbidua. Mãwã ãdjirãba poya cawa jarad̶ia dadji umébemarã caida jipa b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Mʌ̃ra veinte poa bʌ itea traja b̶asia. Maʌ̃ne bʌ ovejara, bʌ chiwatu sid̶a warra ʌradʌgad̶aca basía. Mʌ̃a bʌ oveja umaquĩrãda coida b̶ad̶amĩna ni ab̶a bid̶a coẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Animarã cadrʌaba bʌ animarãda beasira, mʌ̃a maʌ̃ animarã beud̶ara bʌmaa edeca basía cawabi carea. Ãtebʌrʌ maʌ̃bari ara mʌ̃dji animarãnebemada bʌ́a ab̶a diabadjia. Maʌ̃ awara ãsa wa diamasi bid̶a bʌ animarãda drʌasid̶ara bʌa maʌ̃bari mʌ̃reda jẽda diabibadjia. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ãsa mʌ̃ra beseaba bia mĩga b̶abadjia. Diamasi jĩsuaba mĩga b̶ʌ bẽrã poya cãĩca basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Veinte poa mʌ̃ra bʌ diguid̶a b̶asia. Bʌ cau umé panʌ carea mʌ̃ra catorce poa bʌ itea bari trajasia. Bʌ animarã carea mʌ̃ra sei poa bari trajasia, baribʌrʌ mʌ̃a edaida b̶ʌra bʌa b̶arima zocãrã quĩrã awara obadjia. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Abrahaʌ̃ Ãcõrẽda, mʌ̃ zeza Isaba waya b̶ʌ Ãcõrẽda mʌ̃ ume b̶ad̶aẽ́bara, bʌa mʌ̃ra ne neẽ́ wãbicasia. Baribʌrʌ Ãcõrẽba mʌ̃ bia mĩga b̶ʌra, mʌ̃ bio traja b̶ʌ sid̶a unusia. Maʌ̃ carea id̶i diamasi idjia bʌra quẽãsia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Maʌ̃ ũrĩped̶a Labaʌ̃ba Jacoboa jarasia: –Naʌ̃ wẽrãrãda mʌ̃ caurãa, naʌ̃ warrarãda mʌ̃ wiuzaquerãa, za b̶ea ovejara mʌ̃rea. Za bʌa unu b̶ʌra jũma mʌ̃rea. Mãwãmĩna mʌ̃ caurãra, ãdjia toped̶ad̶a warrarã sid̶a ¿mʌ̃a sãwã oi? ");
INSERT INTO empNTpo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Jãʌ̃be djõna amaaba dadjia bed̶eada b̶ʌd̶ia. Dadji umérãba mõgarada boromea bued̶ia dadjia bed̶ea b̶ʌped̶ad̶ara quĩrãneba panani carea.– Jacoboba maʌ̃ra bia b̶ʌad̶a asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Maʌ̃ carea mõgara waib̶ʌada edaped̶a ʌ̃ta nũmʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Maʌ̃be Jacoboba idji ẽberãrãa jarasia: –Naʌ̃ mõgara jĩgabe mõgarada boromea bued̶adua.– Ara maʌ̃da jũmarãba mõgarara ãbaa boromea buesid̶aa. Maʌ̃be maʌ̃ mõgara boromea bue nũmʌma ne cosid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","48","Labaʌ̃ba jarasia: –Id̶i naʌ̃ mõgara boromea bue nũmʌba cawabi b̶ʌa dadjira bed̶ea b̶ʌsid̶ada.– Labaʌ̃ba mõgara boromea bue nũmʌra idji bed̶ead̶e trʌ̃ b̶ʌsia Jegar Sahaduta. Jacoboba idji bed̶ead̶e trʌ̃ b̶ʌsia Gala. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","50","Labaʌ̃ba idjab̶a jarasia: –Dadjira awara wãbʌdamĩna Ãcõrẽba dadji umena acʌ b̶aya. Bʌa mʌ̃ caurãda biẽ́ oibʌrʌ wa mʌ̃ caurã awara dewara wẽrãda edaibʌrʌ, ẽberã naʌ̃ bed̶ea b̶ʌped̶ad̶a ũrĩnada arima b̶ʌẽ́mĩna Ãcõrẽba acʌ b̶aya.– Mãwã mõgara boromea bue nũmʌra idjab̶a trʌ̃ b̶ʌsia Mizpa. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Idjab̶a Labaʌ̃ba Jacoboa jarasia: –Acʌdua za boromea nũmʌ mõgarada, za mõgara ʌ̃ta nũmʌ sid̶a. Mʌ̃a maʌ̃ra dadji ẽsi b̶ʌbisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Naʌ̃ mõgarara sẽyãda b̶aya. Naʌ̃ mõgara aud̶u bʌra mʌ̃ ume djõne zecara b̶ʌa idjab̶a mʌ̃ sid̶a bʌ ume djõne wãcara b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Dadjid̶ebema ab̶aʌda naʌ̃ mõgara aud̶u djõne wãibʌrʌ, Ãcõrẽ bʌ zezadrõã Abrahaʌ̃ ume b̶ad̶a idjab̶a mʌ̃ zezadrõã Naco ume b̶ad̶aba cawa oya. ¿Bia b̶ʌca?– Maʌ̃ne Jacoboba idji zeza Isaba waya b̶ʌ Ãcõrẽ quĩrãpita Labaʌ̃a wãrãneba jarasia “bia b̶ʌa.” ");
INSERT INTO empNTpo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Mãwãped̶a Jacoboba Gala eyad̶e animarãda Ãcõrẽa babue diasia. Maʌ̃be ẽberãrãra trʌ̃sia ne cod̶amãrẽã. Ne cod̶aped̶a maʌ̃ eyad̶e cãĩsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Nurẽma diaped̶ed̶a Labaʌ̃ra piradrʌped̶a dji wiuzaquerã, dji caurã sid̶a isõsia. Mãwãped̶a ãdjía bia wãnaduad̶a aped̶a idji druad̶aa jẽda wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Mamaʌba Jacobora nocod̶aa wãsia. Wãbʌrʌd̶e Ãcõrẽ nezocarã bajãnebemada idjimaa zesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Maʌ̃gʌrã unubʌrʌd̶e Jacoboba jarasia: “Ãcõrẽ sordaorãda nama duanʌa.” Maʌ̃ carea mama trʌ̃ b̶ʌsia Mahanaiʌ̃. ");
INSERT INTO empNTpo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Mamaʌba Jacoboba idji nezocarãda Seír druad̶aa diabuesia idji djaba Esaúmaa. Seír druara idjab̶a Edoʌ̃ abadaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Idji nezocarã diabuei naẽna Jacoboba jarasia: –Mʌ̃ djaba Esaúa nãwã jarad̶e wãnadua: “Dai boro, bʌ nezoca Jacoboba nãwã jarabisia: mʌ̃ wãna ewarid̶eba ʌ̃taa mʌ̃ra dadji djabadrõã Labaʌ̃ma b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Mʌ̃a pacada, burroda, ovejada, nezoca umaquĩrãrãda, nezoca wẽrãrã sid̶a erob̶ʌa. Mʌ̃a naʌ̃ bed̶eara diabuebʌrʌa mʌ̃ quĩrã djuburia bʌra mʌ̃ ume bia b̶amãrẽã.”– Mãwã jaraped̶a idji nezocarãra diabuesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Dji nezocarã Jacobomaa jẽda zed̶aped̶a nãwã jarasid̶aa: –Dairãra bʌ djaba Esaúmaa wãnaped̶a bʌ bed̶eara jarasid̶aa. Ara nawena idjira bʌmaa zebʌrʌa. Maʌ̃ awara idji ume ẽberãrãda cuatrociento zebʌdaa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Maʌ̃ ũrĩbʌrʌd̶e Jacobora bio ne wayasia. Maʌ̃ba cawa crĩchaẽ́ basía. Maʌ̃ bẽrã idji ẽberãrãda ẽsadra awara b̶ʌsia. Idji ovejada, pacada, cameyo sid̶a ara maʌ̃ quĩrãca osia. ");
INSERT INTO empNTpo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Nãwã crĩcha b̶asia: “Esaúda zeped̶a ab̶abemada uraibʌrʌ, waabemada ẽdrʌd̶ia.” ");
INSERT INTO empNTpo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Maʌ̃be Jacoboba Ãcõrẽa iwid̶isia: –Mʌ̃ zezadrõã Abrahaʌ̃ Ãcõrẽ, mʌ̃ zeza Isa Ãcõrẽ, mʌ̃ Boro, bʌa mʌ̃́a jarasia: “Wãdua bʌ djibarirã druad̶aa. Mʌ̃a bʌra ne jũmane carebaya.” ");
INSERT INTO empNTpo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Mʌ̃ra ẽberã biaẽ́ bẽrã bʌa mʌ̃ra quĩrã djuburiaiẽ́ b̶ʌa. Baribʌrʌ bʌa mʌ̃ra wãrãda careba b̶ʌa. Labaʌ̃maa wãi carea naʌ̃ Jordaʌ̃ do chãsid̶e mʌ̃ jʌwad̶e ab̶abe bacuruda erob̶asia. Baribʌrʌ id̶ira mʌ̃a ẽberãrãra zocãrã pe erob̶ʌ bẽrã daira puru umé panʌ quĩrãca panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","12","Mʌ̃a waya b̶ʌa mʌ̃ djaba Esaúra zeped̶a mʌ̃da, mʌ̃ wẽrãrãda, mʌ̃ warrarã sid̶a quenaida. Bʌa jarasia mʌ̃ra ne jũmane careba b̶aida idjab̶a mʌ̃ warrarãra zocãrã yõni bẽrã pusa ĩbʌ quĩrãca poya juachad̶aca baida. Wãrãda mãwã b̶aibʌrʌ, mʌ̃ quĩrã djuburia mʌ̃ra ẽdrʌ edadua mʌ̃ djaba Esaú jʌwad̶ebemada.– ");
INSERT INTO empNTpo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Maʌ̃ diamasi Jacobora mama cãĩsia. Nurẽma idjia animarã erob̶ʌd̶ebemada jʌrʌ pesia idji djaba Esaúa diai carea: ");
INSERT INTO empNTpo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","chiwatu wẽrãda dosciento, dji umaquĩrãda veinte, oveja wẽrãda dosciento, dji umaquĩrãda veinte, ");
INSERT INTO empNTpo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","cameyo wẽrã warra bara b̶eada treinta, paca wẽrãda cuarenta, dji umaquĩrãda die, burro wẽrãda veinte, idjab̶a dji umaquĩrãda die. ");
INSERT INTO empNTpo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Mãwã oped̶a maʌ̃ animarãra idji nezocarãa diasia. Maʌ̃ne ãdjía jarasia: –Bãrãra mʌ̃ na wãnadua. Chiwatura, ovejara, cameyora, paca sid̶a awara awara pe eded̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Maʌ̃be dji nocoare wãbʌrʌ nezocaa jarasia: –Mʌ̃ djaba Esaúba bʌ unubʌrʌd̶e bʌ́a nãwã iwid̶isicada: “¿Bʌra cai nezoca, sãmaa wã, naʌ̃ animarã edebʌrʌra caid̶e?” ");
INSERT INTO empNTpo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Mãwã iwid̶isira nãwã panudua: “Mʌ̃ boro Esaú, naʌ̃gʌra bʌ nezoca Jacoboba bʌ itea diabuebʌrʌa. Idjira dai caid̶u zebʌrʌa.”– ");
INSERT INTO empNTpo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Jacoboba waabema nezoca dji animarã edebʌdarãa jarasia: –Esaú unubʌdad̶e ab̶arida jarad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Maʌ̃ awara jarad̶adua: “Bʌ nezoca Jacobora dairã caid̶u zebʌrʌa.”– Jacoboba crĩchasia: “Mʌ̃a jãwã diabuebʌrʌd̶eba Esaú quĩrũbira tumabiya. Maʌ̃be dji unubʌdad̶e ãĩbẽrã idjia mʌ̃ra bia edaisicada.” ");
INSERT INTO empNTpo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Mãwã Jacoboba Esaúa diaira na diabuesia baribʌrʌ maʌ̃ diamasi wad̶i arima cãĩsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ara maʌ̃ diamasi Jacobora piradrʌped̶a idji quima umena, idji nezocawẽrã umena, idji once warrarã sid̶a Jabó do ĩchitad̶e chãbigasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ãdjirã chãbigaped̶a jũma idjia erob̶ʌ sid̶a chãbisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Mãwã Jacobora idub̶a b̶esia. Maʌ̃ne ẽberãda idji ume djõsia ab̶a ʌ̃mãdau odjabʌrʌd̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Djõ panʌne maʌ̃ ẽberãba cawasia Jacobora poyaẽ́da. Maʌ̃ bẽrã Jacobo chĩded̶e chĩsia. Maʌ̃ba Jacobo chĩdera ãĩ dogosia. ");
INSERT INTO empNTpo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Maʌ̃ne dji ẽberãba Jacoboa jarasia: –Mʌ̃ra quenab̶aridua. Ʌ̃nadrʌbʌrʌa.– Jacoboba panusia: –Bʌa mʌ̃da bia jara b̶ʌẽ́bʌrʌ, mʌ̃a quenab̶ariẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Maʌ̃be dji ẽberãba iwid̶isia: –¿Bʌra casa trʌ̃bada?– Jacoboba panusia: –Mʌ̃ra Jacobo abadaa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Maʌ̃ne dji ẽberãba jarasia: –Waa bʌra Jacobo ad̶aẽ́a. Namaʌba ʌ̃taa bʌ trʌ̃ra Israel ad̶ia, bʌra Ãcõrẽ ume, ẽberãrã ume bid̶a djõna bẽrã. Maʌ̃ne bʌa poyasia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Maʌ̃be Jacoboba jarasia: –Jãʌ̃be mʌ̃ djuburia bʌ trʌ̃ra jaradua.– Dji ẽberãba panusia: –¿Cãrẽ cãrẽã mʌ̃ trʌ̃ra iwid̶i b̶ʌ? Mʌ̃ trʌ̃ra mʌ̃a bʌ́a jaraẽ́a.– Mama dji ẽberãba Jacobora bia jara b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Maʌ̃ne Jacoboba jarasia: “Mʌ̃dji dauba Ãcõrẽ quĩrãdarrada ununamĩna mʌ̃ra wad̶i zocai b̶ʌa.” Mãwã mama trʌ̃ b̶ʌsia Penuel. ");
INSERT INTO empNTpo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ʌ̃mãdau odjabʌrʌd̶e Jacobora maʌ̃ Penueld̶eba wãsia. Baribʌrʌ idji chĩdera ãĩ wãna bẽrã pĩãca b̶ʌcaeda wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Bajãnebemaba Jacobora chĩded̶e chĩna bẽrã id̶ibema ewarid̶e israelerãba chĩded̶ebema quẽgura cod̶acaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jacoboba unusia Esaúra idji cuatrociento ẽberãrã ume zebʌrʌda. Maʌ̃ carea Jacoboba idji warrarãra ãdjirã papa ume awara awara b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Dji nezocawẽrãrã umé panʌda ãdji warrarã ume nocoare b̶ʌsia. Ãdjirãare Leada idji warrarã ume b̶ʌsia. Jĩrũare Raquelda idji warra Jose ume b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Maʌ̃be Jacobora ãdjirã na wãsia. Idji djaba waya b̶ʌd̶eba chĩrãborod̶e cob̶eped̶a b̶arima siete egode b̶arru cob̶e eda wãsia ab̶a idji djaba caita jũẽbʌrʌd̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Baribʌrʌ Esaúra araa pira wãsia Jacobo audiab̶arid̶e. Ojũẽped̶a uridarrad̶e isõped̶a ãdji umena b̶ʌsrid̶aba jĩãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Mãwã panʌne Esaúba Jacobo wẽrãrãra, jũma idji warrarã sid̶a unuped̶a iwid̶isia: –Za panʌra ¿cai?– Jacoboba panusia: –Mʌ̃ boro, naʌ̃gʌrãra mʌ̃ warrarãa, Ãcõrẽba idji biad̶eba mʌ̃́a diad̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Jacobo nezocawẽrãrãra ãdji warrarã ume Esaúmaa wãnaped̶a wayaad̶eba egode chĩrãborod̶e b̶arru copanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Maʌ̃are Leada idji warrarã sid̶a wãnaped̶a chĩrãborod̶e b̶arru copanesid̶aa. Jĩrũare Joseda Raquel sid̶a wãnaped̶a chĩrãborod̶e b̶arru copanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Maʌ̃be Esaúba iwid̶isia: –Mʌ̃a animarã cãbana ota unucuad̶ara bʌa ¿cãrẽ crĩchad̶eba jãwã diabuesi?– Jacoboba panusia: –Mʌ̃ boro, jãwã osia bʌra mʌ̃ ume bia b̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esaúba jarasia: –Crĩcharãdua, djaba, mʌ̃a ad̶uba erob̶ʌa. Bʌdjid̶era wagadua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jacoboba jarasia: –Mãwãẽ́a. Bʌda mʌ̃ ume bia b̶ʌbʌrʌ, mʌ̃a dia b̶ʌra edadua. Mʌ̃maarã bʌ unubʌrʌra Ãcõrẽ quĩrãdarra unubʌrʌ quĩrãca b̶ʌa, bʌa mʌ̃ra bia edad̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Mʌ̃ quĩrã djuburia, bʌ itea enenara edadua. Ãcõrẽba mʌ̃ra bio careba b̶ʌ bẽrã ne jũmada erob̶ʌa.– Jacoboba maʌ̃ra ara pichia jara b̶esia ab̶a Esaúba edabʌrʌd̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Maʌ̃be Esaúba jarasia: –Wãna. Mʌ̃ra bʌ na nĩbaya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jacoboba jarasia: –Mãwãẽ́a, mʌ̃ boro. Bʌa unu b̶ʌa mʌ̃ warrarãra wad̶i caibe qued̶eada, idjab̶a mʌ̃ ovejaba, mʌ̃ paca bid̶a warra djiwid̶i tod̶ada erob̶eada. Isabe wãnibʌrʌ jũmawãyã sẽnia. Maʌ̃ba ab̶ari ewarid̶e mʌ̃ animarãra jũma quininia. ");
INSERT INTO empNTpo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Maʌ̃ bẽrã, mʌ̃ boro, bʌra mʌ̃ na wãdua. Mʌ̃ra pĩãca caid̶u wãya mʌ̃ animarã, mʌ̃ warrarã nĩbabada quĩrãca. Maʌ̃be Seír druad̶e bʌ b̶abarima dji ununia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Maʌ̃ne Esaúba jarasia: –Mʌ̃a ẽberãrã mʌ̃ ume zeped̶ad̶ada ameya bãrã wagad̶amãrẽã.– Jacoboba jarasia: –Mãwãẽ́a, mʌ̃ boro. Bʌra mʌ̃ ume bia b̶ed̶a bẽrã ¿cãrẽda waa iwid̶i?– ");
INSERT INTO empNTpo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ara maʌ̃ ewarid̶e Esaúra Seír druad̶aa jẽda wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Baribʌrʌ Jacobora Suco purud̶aa wãsia. Mama deda osia idjab̶a de zaquerãda idji animarã itea ocuasia. Maʌ̃ carea mama trʌ̃ b̶ʌsia Suco. ");
INSERT INTO empNTpo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Mãwãnacarea Jacobora Siqueʌ̃ purud̶aa wãsia. Mãwã Araʌ̃ druad̶e b̶ad̶ada jẽda zeped̶a Canaaʌ̃ druad̶e bia jũẽsia. Siqueʌ̃ puru quĩrãpe idji wua dera osia. ");
INSERT INTO empNTpo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Dji ẽjũãda Hamo warrarãne basía. Hamora Siqueʌ̃ zeza basía. Jacoboba maʌ̃ ẽjũãra nẽdosia cien parata torrobari. Nẽdoped̶a idji wua ded̶e mama b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Mama Jacoboba mõgarada ʌ̃tʌ pã buesia Ãcõrẽa bia bed̶eai carea. Maʌ̃ mõgara ʌ̃tʌ pã bued̶ara trʌ̃ b̶ʌsia El-Elohe-Israel. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Jacoboba Lea ume cauda ab̶a eropanasid̶aa Dina abadada. Ewari ab̶a Dinara maʌ̃ druad̶ebema awẽrãrãmaa pʌrrʌad̶e wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Maʌ̃ druad̶ebema borora Hamo abadjid̶aa. Idjira heveo basía. Hamoba warrada erob̶asia Siqueʌ̃ abadada. Maʌ̃ Siqueʌ̃ba Dina unubʌrʌd̶e awuasia. Maʌ̃ bẽrã jidaped̶a idji ume cãĩsia. Mãwã Dinara biẽ́ osia. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Baribʌrʌ idji sod̶e Siqueʌ̃ba Lea cau Dinara wãrãda quĩrĩã b̶ʌ bẽrã ijara o b̶abadjia. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Maʌ̃ ewarid̶e Siqueʌ̃ba idji zeza Hamoa jarasia: –Zeza, jãʌ̃ wẽrãra mʌ̃ itea iwid̶id̶e wãdua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","6","Ara maʌ̃da Siqueʌ̃ zeza Hamora Jacobo ume bed̶ead̶e wãsia. Idji jũẽi naẽna Jacoboba ũrĩsia Siqueʌ̃ba Dinara biẽ́ osida. Baribʌrʌ idji warrarãba idji animarãra acʌd̶e wã panʌ bẽrã Jacobora chupea b̶esia ab̶a ãdji zebʌdad̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Jũẽsid̶ad̶e ũrĩsid̶aa Siqueʌ̃ba ãdji djabawẽrãra biẽ́ osida. Maʌ̃ carea sopuasid̶aa. Bio quĩrũsid̶aa Siqueʌ̃ba mãwã israelerãda bio cadjirua od̶a bẽrã. Israelerãba maʌ̃ra ab̶ed̶a quĩrĩãnacaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Siqueʌ̃ zeza Hamo jũẽsid̶e ãdjía nãwã jarasia: –Mʌ̃ warra Siqueʌ̃ba bãrã djabawẽrãda bio quĩrĩã b̶ʌa. Mʌ̃ quĩrã djuburia, idjira mʌ̃ warraa diad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mãwã bãrãra dai ẽberãrã baya. Dairã caurã ume poya dji edad̶ia, dairã sid̶a bãrã caurã ume poya dji edad̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Nama dairã ume pananadua. Naʌ̃ druara bãrã itea b̶ʌa. Naʌ̃ ẽjũãne bãdjia awuabʌdama pananadua. Ne nẽdod̶ida panʌa idjab̶a nẽdobued̶ida panʌa. Ẽjũã sid̶a nẽdod̶ida panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Maʌ̃ne Siqueʌ̃ba Dina zezaa, idji djabarãa bid̶a jarasia: –Mʌ̃ quĩrã djuburia, jãʌ̃ wẽrãda mʌ̃́a diad̶adua. Bãrãba iwid̶ibʌdada mʌ̃a diaya. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Bãrãba idji carea waib̶ʌa iwid̶id̶ibʌrʌ, mʌ̃a diaya. Baribʌrʌ mʌ̃ quĩrã djuburia jãʌ̃ wẽrãra mʌ̃́a diad̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","14","Siqueʌ̃ba Dinara biẽ́ od̶a bẽrã Jacobo warrarãba Siqueʌ̃ zezaa, Siqueʌ̃a bid̶a sewad̶eba nãwã jarasid̶aa: –Dai djabawẽrãra umaquĩrã cacua wẽãgoẽ́ b̶ʌ́a poya diad̶aẽ́a. Mãwã diad̶ibʌrʌ, daimaarã cadjiruada o panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Baribʌrʌ jũma bãrã umaquĩrãrãda dai quĩrãca cacua wẽãgod̶ibʌrʌ, dairãba idjira diad̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Mãwãbʌrʌ bãrãra dai caurã ume poya dji edad̶ia idjab̶a dairã sid̶a bãrã caurã ume poya dji edad̶ia. Mãwã dairãra bãrã tãẽna panania. Dadjirãra puru ab̶abe b̶eya. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Baribʌrʌ daiba jara panʌ quĩrãca bãrãda cacua wẽãgod̶aẽ́bʌrʌ, daiba dai djabawẽrãra namabemada ãyã eded̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Maʌ̃ra Hamoba, idji warra Siqueʌ̃ bid̶a bia ũrĩsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ara maʌ̃da Siqueʌ̃ra cacua wẽãgosia Jacobo caura quĩrĩã b̶ʌ bẽrã. Hamo ẽberãrã tãẽna jũmarãba Siqueʌ̃ra biara waya panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Maʌ̃ bẽrã idjira dji zeza Hamo ume purud̶e ed̶a wãbadamaa wãnaped̶a purud̶ebemarãa nãwã jarasid̶aa: ");
INSERT INTO empNTpo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","–Jacobora, idji warrarã sid̶a ẽberã biarãa. Ẽjũãra baraa ãdjirã pananamãrẽã. Maʌ̃ bẽrã ãdjirãra dadjirã druad̶e idu b̶ebid̶ia. Idu ne nẽdobid̶ia idjab̶a nẽdobuebid̶ia. Dadjirãra ãdjirã caurã ume poya dji edad̶ia. Ãdjirã sid̶a dadjirã caurã ume poya dji edad̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Baribʌrʌ dadjirãra ãdjirã ume puru ab̶a b̶ei carea ãdjirãba jara panʌa jũma dadjirã umaquĩrã cacuara wẽãgod̶ida panʌda ãdjia obada quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Mãwã od̶ibʌrʌ ãdjid̶era, ãdji animarã erob̶ea sid̶a jũma dadjirãne baya. Dadjirãba ab̶abe maʌ̃ obi panʌda ĩjã od̶ida panʌa. Mãwãra ãdjirãra dadjirã ume panenia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Hamoba, Siqueʌ̃ bid̶a jaraped̶ad̶ara jũma maʌ̃ purud̶e ed̶a wãbadama panʌba ĩjãsid̶aa. Ara maʌ̃da jũmarãda cacua wẽãgosid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ewari ũbea babʌrʌd̶e ãdjirã cacuara wad̶i bio pua panasid̶aa. Maʌ̃ne Dina djabarã Simeoʌ̃ba, Levi bid̶a ãdji djõbada necora edad̶aped̶a Siqueʌ̃ purud̶aa wãsid̶aa. Ãdji quenane zebʌdara puruba adua b̶asia. Ara maʌ̃da Jacobo warrarã Simeoʌ̃ba, Levi bid̶a jũma dji umaquĩrãrãra quenasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamora dji warra Siqueʌ̃ sid̶a necoba beasid̶aa. Maʌ̃be Dinara Siqueʌ̃ ded̶e b̶ad̶ada edad̶aped̶a wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Maʌ̃be Jacobo warrarã waabemarã sid̶a ãdji djabarãba beaped̶ad̶a ẽberãrãmaa zed̶aped̶a deza ed̶aa wãsid̶aa. Mama ne jũma pesid̶aa. Mãwã osid̶aa Siqueʌ̃ba ãdji djabawẽrã biẽ́ od̶a carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Siqueʌ̃nebema ovejada, pacada, burro sid̶a pesid̶aa. Ne jũma purud̶e b̶eara, ãdji ẽjũãne b̶ea sid̶a jũma pesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ãdji nebiada jũma pesid̶aa. Ãdjia diguid̶a erob̶ead̶a sid̶a jũma ped̶aped̶a ãdji warrarãda, wẽrãrã sid̶a jũma jida edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Mãwãnacarea Jacoboba Simeoʌ̃a, Levia bid̶a jarasia: –Bãrãba biẽ́ oped̶ad̶a bẽrã mʌ̃ra nẽbʌrad̶e b̶ʌsid̶aa. Naʌ̃ druad̶ebema cananeorãba, perezeorã bid̶a mʌ̃ra quĩrãma panesid̶aa. Ãdjirãda bed̶ea aud̶aped̶a mʌ̃ ume djõne zed̶ibʌrʌ, dadjira zocãrãẽ́be panʌ bẽrã mʌ̃ra jũma mʌ̃ ẽberãrã sid̶a bead̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Maʌ̃ne ãdjia panusid̶aa: –¿Mãwãra idjia dai djabawẽrãra wẽrã aud̶ua quĩrãca oida b̶asica?– ");
INSERT INTO empNTpo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Mãwãnacarea Ãcõrẽba Jacoboa jarasia: –Piradrʌped̶a Beteld̶aa b̶ad̶e wãdua, bʌ djaba Esaú wayaad̶eba mĩrũ wãsid̶e mʌ̃ bʌma odjad̶amaa. Mama mõgarada pã buedua mʌ̃́a bia bed̶eai carea.– ");
INSERT INTO empNTpo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ara maʌ̃da Jacoboba idji ẽberãrãa, waabema idji ume duanʌ́a bid̶a jarasia: –Bãrãba jʌwaba od̶a ãcõrẽda eropanʌbʌrʌ, jũma b̶atacuad̶adua. Maʌ̃be cuid̶aped̶a cacuad̶e jʌ̃bada tãtod̶ada jʌ̃nadua Ãcõrẽ quĩrãpita bia b̶ead̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Maʌ̃bebʌrʌ Beteld̶aa wãnia. Mama mʌ̃a mõgarada pã bueya Ãcõrẽa bia bed̶eai carea. Mʌ̃ nẽbʌrad̶e b̶asid̶e idjia mʌ̃ra carebasia idjab̶a mʌ̃ wãbʌrʌza mʌ̃ ume b̶abaria.– ");
INSERT INTO empNTpo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ara maʌ̃da jũma ãdji jʌwaba od̶a ãcõrẽra Jacoboa diasid̶aa. Ãdji cʌwʌrʌd̶e pĩrũ jʌ̃ panʌ sid̶a ẽrãnaped̶a Jacoboa diasid̶aa. Jũma maʌ̃gʌra Jacoboba Siqueʌ̃ puru caita bacuru droma nũmʌ edre jou b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Mãwãnacarea Jacobora, ẽberãrã idji ume panʌ sid̶a wãsid̶aa. Wãbʌdad̶e Ãcõrẽba jũma mama b̶ea purua ãdjirãra bio wayabisia. Maʌ̃ bẽrã ãdjirãba Jacobo ẽberãrã biẽ́ od̶i carea caid̶u ẽpẽnaẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Canaaʌ̃ druad̶e nĩne Jacobora jũma idji ẽberãrã ume Luz purud̶e jũẽsid̶aa. Luz purura idjab̶a Betel abadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Mama Jacoboba mõgarada pã buesia Ãcõrẽa bia bed̶eai carea. Maʌ̃ mõgara pã bued̶ara trʌ̃ b̶ʌsia El-Betel, idji djaba carea mĩrũ wãsid̶e mama Ãcõrẽra idjima odjad̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Maʌ̃ Beteld̶e Deboráda jaid̶asia. Deborára Jacobo papa Rebeca wagabari basía. Jacoboba Deborára tʌb̶arisia Betel caita, bacuru droma nũmʌ edre. Maʌ̃ bacurura trʌ̃ b̶ʌsia Alon-Bacut. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","10","Jacobo Padan-Araʌ̃ druad̶eba jẽda zesi ewarid̶e Ãcõrẽra idjimaa waya zesia. Maʌ̃ ewarid̶e Ãcõrẽba idjira nãwã bia jara b̶ʌsia: –Bʌ trʌ̃ra Jacobo abadaa baribʌrʌ bʌra waa Jacobo ad̶aẽ́a. Ãtebʌrʌ bʌ trʌ̃ra Israel ad̶ia.– Mãwã Ãcõrẽba Jacobora trʌ̃ b̶ʌsia Israel. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ãcõrẽba mãwã trʌ̃ b̶ʌped̶a jarasia: –Mʌ̃ra ne jũma poya b̶ʌ Ãcõrẽa. Warrada zocãrã yõdua. Bʌd̶eba puruda zocãrã yõnia. Idjab̶a bʌd̶eba ẽberãrã bororãda yõnia. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Mʌ̃a naʌ̃ druara Abrahaʌ̃a, Isaa bid̶a diasia. Idjab̶a mʌ̃a bʌ́a, bʌd̶eba yõbʌdarãa bid̶a diaya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Mãwãped̶a Ãcõrẽra Jacobo ume bed̶ea b̶ad̶ada wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Mãwãnacarea Jacoboba Ãcõrẽ ume bed̶ea b̶ad̶ama mõgarada ʌ̃ta nũmʌsia. Maʌ̃ mõgara ʌ̃rʌ̃ uva b̶ada, nedraga sid̶a Ãcõrẽa wea diasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Maʌ̃ne Jacoboba Ãcõrẽ ume bed̶ea b̶ad̶ama trʌ̃ b̶ʌsia Betel. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Mãwãnacarea Beteld̶eba wãsid̶aa. Wad̶i Eprata purud̶e jũẽni naẽna Jacobo quima Raquelera warra pua nũmesia. Poya tocara nũmʌ bẽrã bia mĩga b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Wetara pua nũmebʌrʌd̶e dji warra careba tobibari wẽrãba Raquelea jarasia: –Wayarãdua, bʌa umaquĩrã warrada tobʌrʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Baribʌrʌ Raquelera beubʌrʌ basía. Wad̶i beui naẽna idji warrara trʌ̃ b̶ʌsia Benoní. Baribʌrʌ Jacoboba trʌ̃ b̶ʌsia Benjamiʌ̃. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Raquelera mãwã jaid̶asia. Idjira tʌb̶arisia Eprata purud̶aa wãbada o icawa. Maʌ̃ Eprata purura Beleʌ̃ abadaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacoboba dji quima tʌb̶arid̶ama mõgarada ʌ̃ta nũmʌsia. Id̶i ewarid̶e maʌ̃ mõgarara wad̶ibid̶a nũmʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Jacobo, Israel abadara mamaʌba wãped̶a idji wua dera Migdal-edar puru zaque wagaa osia. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Israel maʌ̃ druad̶e b̶asid̶e idji warra iwina Rubeʌ̃ra idji zeza nezocawẽrã Bilha ume cãĩsia. Maʌ̃ra Israelba cawaped̶a bio quĩrũsia. Israel warrarãra doce panasid̶aa: ");
INSERT INTO empNTpo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leaba tod̶ara naʌ̃gʌrã basía: dji iwinada Rubeʌ̃, idjiare Simeoʌ̃, Levi, Juda, Isacar, Zabuloʌ̃ sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Raquelba tod̶ara naʌ̃gʌrã basía: Jose idjab̶a Benjamiʌ̃. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Raquel nezocawẽrã Bilhaba tod̶ara naʌ̃gʌrã basía: Daʌ̃ idjab̶a Neptali. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lea nezocawẽrã Zilpaba tod̶ara naʌ̃gʌrã basía: Ga idjab̶a Aser. Jũma maʌ̃gʌrã basía Jacobo warrarã Padan-Araʌ̃ druad̶e toped̶ad̶ada. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Maʌ̃ ewarid̶e Jacobora Mamre ẽjũãnaa idji zeza Isa acʌd̶e wãsia. Mamrera idjab̶a Arbá wa Hebroʌ̃ abadaa. Mama Abrahaʌ̃ra, Isa sid̶a panabadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isara 180 poa b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Mãwã idjira bio waraga jaid̶asia. Idji warrarã Esaúba, Jacobo bid̶a tʌb̶arisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Nama b̶ʌ́ b̶ʌa Esaúd̶eba yõped̶ad̶ad̶ebemada. Esaúra idjab̶a Edoʌ̃ abadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaúba quimada ũbea erob̶asia. Canaaʌ̃nebemada umé erob̶asia. Ab̶a Adá abadjid̶aa. Adára hitita Eloʌ̃ cau basía. Dewarabemara Aholibamá basía. Aholibamára Aná cau basía; Anára heveo Zibeoʌ̃ warra basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Dewarabema quima Esaúba erob̶ad̶ara Ismael cau Basemá basía. Basemára Nebayo djabawẽrã basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","5","Esaúra wad̶ibid̶a Canaaʌ̃ druad̶e b̶asid̶e warrarãda unusia. Dji quima Adába Elipada tosia. Basemába Reuelda tosia. Aholibamába Jeúda, Jaalaʌ̃da, Core sid̶a tosia. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","7","Maʌ̃ne Esaúba idji djaba Jacobo bid̶a animarãra, nebia sid̶a zocãrã eropanasid̶aa. Ãdjia animarãra zocãrã eropanʌ bẽrã dji ẽjũãba araẽ́ basía. Maʌ̃ bẽrã ãdjira poya ãbaa pananaẽ́ basía. Maʌ̃ carea Esaúra Jacobo umebemada ãyã wãsia dewara druad̶e b̶ai carea. Idji quimarãda, warrarãda, caurãda, ẽberãrã idji ded̶e erob̶ʌda, idji animarãda, idjia Canaaʌ̃ne edad̶a sid̶a jũma edesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Mãwã Esaú, Edoʌ̃ abadara Seír eyaid̶a b̶ʌ druad̶e b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Esaúd̶eba Edoʌ̃ puruda yõsia. Maʌ̃ edomitarãra Seír eyaid̶a b̶ʌ druad̶e duanabadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esaú warrarã trʌ̃ra naʌ̃gʌrãa: Elipa idjab̶a Reuel. Esaú quima Adába Elipada tosia. Esaú quima Basemába Reuelda tosia. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elipaba naʌ̃ warrarãda unusia: Temaʌ̃, Omar, Zepo, Gataʌ̃, Quenaz sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elipaba Timnada idji quima quĩrãca erob̶asia. Timnaba Amaleda tosia. Maʌ̃ warrarãra Adá wiuzaquerã basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Maʌ̃ne Reuelba naʌ̃ warrarãda unusia: Nahat, Zerá, Samá idjab̶a Miza. Maʌ̃ warrarãra Basemá wiuzaquerã basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esaú quima Aholibamáda Aná cau basía, Zibeoʌ̃ ãĩzaque basía. Aholibamába naʌ̃ warrarãda Esaúa to diasia: Jeú, Jaalaʌ̃, Core sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Esaúd̶eba yõna purud̶ebema bororã trʌ̃da nama b̶ʌ́ b̶ʌa. Dji warra iwina Elipad̶eba yõna bororãda naʌ̃gʌrã basía: Temaʌ̃, Omar, Zepo, Quenaz, Core, Gataʌ̃, Amale sid̶a. Ãdjirãra Edoʌ̃ druad̶e duanabadjid̶aa. Jũma ãdjirãda Esaú quima Adád̶eba yõsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esaú warra Reueld̶eba yõped̶ad̶a bororãda naʌ̃gʌrã basía: Nahat, Zerá, Samá, Miza sid̶a. Ãdjirã sid̶a Edoʌ̃ druad̶e duanabadjid̶aa. Jũma ãdjirãda Esaú quima Basemáneba yõsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esaú quima Aholibamáneba yõped̶ad̶a bororãda naʌ̃gʌrã basía: Jeú, Jaalaʌ̃, Core sid̶a. Aholibamára Aná cau basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Maʌ̃ ẽberãrãra jũma Esaú, Edoʌ̃ abadad̶eba yõsid̶aa. Ãdjirãra Edoʌ̃ druad̶e ãdji ẽberãrã bororã basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Esaú Edoʌ̃ druad̶aa wãi naẽna horeorãda maʌ̃ druad̶e panabadjid̶aa. Maʌ̃ horeorãra Seírd̶eba yõsid̶aa. Seír warrarãra naʌ̃gʌrã basía: Lotaʌ̃, Sobal, Zibeoʌ̃, Aná, Disoʌ̃, Ezer, Disaʌ̃ sid̶a. Maʌ̃gʌrãra Edoʌ̃ druad̶e horeorã bororã basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Seír warra Lotaʌ̃ba unusia Hori, Hemaʌ̃ sid̶a. Lotaʌ̃ djabawẽrãra Timna basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Seír warra Sobalba unusia Alvaʌ̃, Manahat, Ebal, Sepo, Onaʌ̃ sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Seír warra Zibeoʌ̃ba Ajada idjab̶a Aná sid̶a unusia. Maʌ̃ Anába idji zeza burrora ẽjũã ewaraga b̶ʌd̶e ne cobi b̶asid̶e egorod̶eba baidoda ʌ̃taa bogadrʌ b̶ʌda unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Aná warrara Disoʌ̃ basía. Dji caura Aholibamá basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disoʌ̃ warrarãra naʌ̃gʌrã basía: Hemdaʌ̃, Esbaʌ̃, Itraʌ̃, Queraʌ̃ sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Seír warra Ezerba unusia Bilhaʌ̃, Zaavaʌ̃, Acaʌ̃ sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Seír warra Disaʌ̃ba unusia Uz, Araʌ̃ sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Horeorã bororãra naʌ̃gʌrã basía: Lotaʌ̃, Sobal, Zibeoʌ̃, Aná, ");
INSERT INTO empNTpo_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disoʌ̃, Ezer, Disaʌ̃ sid̶a. Jũma maʌ̃gʌrãra Seír druad̶e ãdji ẽberãrã bororã basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Israelerãba ãdji boro eropanani naẽna Edoʌ̃ ẽberãrã bororãra naʌ̃gʌrã basía: ");
INSERT INTO empNTpo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beor warra Belara Edoʌ̃ ẽberãrã boro basía. Idji purura Dinabá abadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela beud̶acarea Zerá warra Jobáda dji boro basía. Jobára Bosra purud̶ebema basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobá beud̶acarea Husaʌ̃da dji boro basía. Husaʌ̃ra Temaʌ̃ druad̶ebema basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husaʌ̃ beud̶acarea Bedad warra Hadada dji boro basía. Hadaba madianitarãra Moab druad̶e poyasia. Idji purura Avit abadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hada beud̶acarea Samlada dji boro basía. Samlara Masreca purud̶ebema basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla beud̶acarea Saulda dji boro basía. Saulora dji do icawa b̶ʌ Rehobo purud̶ebema basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul beud̶acarea Baal-hanaʌ̃da dji boro basía. Idjira Acbor warra basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal-hanaʌ̃ beud̶acarea Hadarda dji boro basía. Idji purura Pau abadjid̶aa. Hadar quimada Mehetabel abadjid̶aa. Idjira Matred cau basía idjab̶a Mezaab ãĩzaque basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Esaúd̶eba yõped̶ad̶a bororãra naʌ̃gʌrã basía: Timna, Alva, Jetet, Aholibamá, Ela, Pinoʌ̃, Quenaz, Temaʌ̃, Mibzar, Magdiel, Iraʌ̃ sid̶a. Jũma maʌ̃gʌrãra Edoʌ̃ purud̶ebema bororã basía. Maʌ̃ bororãneba yõped̶ad̶arãba dji bororã trʌ̃ra ẽpẽsid̶aa. Idjab̶a ãdji b̶eaza dji bororã trʌ̃da b̶ʌcuasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Idji zeza Isa jaid̶ad̶acarea Jacobora Canaaʌ̃ druad̶e idji zeza b̶ad̶ama b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Nama nẽbʌrʌ b̶ʌa Jacobo warrarãba oped̶ad̶ad̶ebemada. Jacobo warra Jose diecisiete poa b̶asid̶e idji djabarã ume oveja waga b̶abadjia. Idji zezaba quima quĩrãca erob̶ʌ wẽrãrã Bilhaba idjab̶a Zilpaba toped̶ad̶a ume Josera biara trajabadjia. Diguid̶a wãbʌrʌd̶e Joseba idji zezaa jarabadjia idji djabarãba cadjirua o panʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israelba Joseda waabema warrarã cãyãbara biara quĩrĩã b̶asia Josera idji drõã b̶ʌd̶e tosid̶a bẽrã. Maʌ̃ carea Israelba Jose itea cacuad̶e jʌ̃bada drasoa bio bia quiruda osia. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Jose djabarãba cawasid̶aa ãdji zezaba Josera ãdjirã cãyãbara biara quĩrĩã b̶ʌda. Maʌ̃ carea idjira quĩrãma panesid̶aa. Idji ume bia bed̶ead̶aca basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ewari ab̶a Josera cãĩmocarasia. Nurẽma maʌ̃ cãĩmocarad̶ara idji djabarãa nẽbʌrʌsia. Maʌ̃ carea ãdjirãba idjira wetara quĩrãmasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Idjia nãwã jarasia: –Ũrĩnadua, mʌ̃a cãĩmocarad̶ada nẽbʌrʌya. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Mʌ̃a unusia dadjirãba dadji ẽjũãne trigoda tʌd̶aped̶a ãbaa cajʌ̃ panʌda. Cawaẽ́ne mʌ̃a trigo cajʌ̃nara ʌ̃ta nũmesia. Maʌ̃ne bãrãba cajʌ̃ped̶ad̶ara mʌ̃re quĩrãpita ed̶aa b̶arru copanesid̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Maʌ̃ carea Jose djabarãba quĩrũbid̶eba nãwã jarasid̶aa: –Mãwãra ¿bʌra dai boroda b̶eica? ¿Daira bʌ jʌwaed̶a erob̶aica?– Joseba maʌ̃ cãĩmocarad̶eba ãdjirã boro baida nẽbʌrʌd̶a carea dji djabarãba idjira wetara quĩrãmasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Mãwãnacarea Josera wayacusa cãĩmocarasia. Maʌ̃ cãĩmocarad̶a sid̶a idji djabarãa nẽbʌrʌsia. Nãwã jarasia: –Ũrĩnadua, mʌ̃a waya cãĩmocarasia. Unusia ʌ̃mãdauda, jed̶ecoda, idjab̶a once chĩdauda. Maʌ̃gʌrãra ẽberã quĩrãca mʌ̃ quĩrãpita chĩrãborod̶e b̶arru copanesid̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Joseba idji djabarãa nẽbʌrʌd̶acarea dji zezaa bid̶a nẽbʌrʌsia. Maʌ̃ bẽrã idji zezaba idjira nãwã quẽãsia: –Maʌ̃ cãĩmocarad̶eba bʌa ¿cãrẽda jara b̶ʌ? Mãwãra ¿bʌ papara, bʌ djabarãra, mʌ̃ sid̶a bʌ quĩrãpita chĩrãborod̶e b̶arru copanenica?– ");
INSERT INTO empNTpo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Maʌ̃ carea dji djabarãra idji ume sod̶e biẽ́ panesid̶aa baribʌrʌ dji zezaba maʌ̃ cãĩmocarad̶ebemada bio crĩcha b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ewari ab̶a Jose djabarãba dji zeza ovejara Siqueʌ̃ puru caita põãjãrã cobid̶e edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Maʌ̃ne Israelba Josea nãwã jarasia: –Warra, bʌ djabarãba Siqueʌ̃ caita mʌ̃ ovejara waga panʌa. Mʌ̃a quĩrĩã b̶ʌa bʌa ãdjira acʌd̶e wãida.– Joseba panusia: –Bia b̶ʌa, mʌ̃a ãdjira acʌd̶e wãya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Israelba jarasia: –Bʌ djabarã, dadji animarã sid̶a sãwã panʌ cawaya acʌd̶e wãdua. Maʌ̃be mʌ̃́a jarad̶e zedua.– Mãwã jaraped̶a Israelba Josera Hebroʌ̃ jewed̶ad̶eba Siqueʌ̃naa wãbisia. Wãne Josera Siqueʌ̃ne jũẽsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Joseba idji djabarã jʌrʌ nĩne ẽberãba idjira unuped̶a nãwã iwid̶isia: –¿Cãrẽda jʌrʌ b̶ʌ?– ");
INSERT INTO empNTpo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Joseba panusia: –Mʌ̃ djabarãda jʌrʌ b̶ʌa. Ãdjirãba ovejada waga panʌa. ¿Bʌa cawa b̶ʌca sãma panʌda?– ");
INSERT INTO empNTpo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ẽberãba panusia: –Mãẽ, ãdjirãra nama duananaped̶a wãbʌrʌsid̶aa. Mʌ̃a ũrĩsia Dotaʌ̃ ẽjũãnaa wãniana abʌdada.– Ara maʌ̃da Josera idji djabarã caid̶u wãsia. Wãbʌrʌd̶e ãdjirãra Dotaʌ̃ ẽjũãne unune wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Maʌ̃ne ãdjirãba Josera tʌmʌ uruda unusid̶aa. Jose ãdji caita jũẽi naẽna ãdjirãra bed̶ea ausid̶aa idji bead̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Nãwã jarasid̶aa: –Acʌd̶adua, cãĩmocarabarira jari bueábʌrʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Idjira bead̶aped̶a baido juebada uriad̶e b̶atabued̶ia. Maʌ̃be dadji zezaa jarad̶ia animarãba cobuesida. ¡Mãwã osid̶ara acʌd̶ia idjia cãĩmocarad̶ara wãrãda mãwãi cawaya!– ");
INSERT INTO empNTpo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Maʌ̃ bed̶ea ũrĩbʌrʌd̶e ãdji djaba Rubeʌ̃ba Josera ãdji jʌwad̶ebemada ẽdrʌ b̶ʌida crĩchasia. Maʌ̃ carea nãwã jarasia: –Bead̶aẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Idji oara erozoabid̶aẽ́a. Za b̶ʌ baido juebada uriad̶e b̶atabued̶ia, baribʌrʌ bead̶aẽ́a.– Rubeʌ̃ba mãwã jarasia Josera ẽdrʌ b̶ʌped̶a dji zezamaa wayacusa edeida crĩchad̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Jose idji djabarãma jũẽsid̶e ãdjirãba idjira jidad̶aped̶a idji cacuad̶e jʌ̃ b̶ʌ drasoa bio bia quiruda ẽrã edasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Maʌ̃be idjira baido juebada uriad̶e b̶atabuesid̶aa. Dji uriara põãsa baido neẽ́ b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Mãwã od̶aped̶a ne co chũpanesid̶aa. Maʌ̃ne ismaelerãda Gala druad̶eba zebʌdada unusid̶aa. Maʌ̃ ismaelerãba cameyod̶e quera tũãpa b̶eada Egipto druad̶aa nẽdobued̶e edebʌda basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Maʌ̃ne Judaba idji djabarãa jarasia: –Dadji djabada bead̶aped̶a mẽrãnibʌrʌ, maʌ̃ba ¿cãrẽ biada edad̶i? ");
INSERT INTO empNTpo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Idjira dadjirã djabaa. Maʌ̃ bẽrã idji bead̶i cãyãbara biara b̶ʌa jari uda ismaelerãa nẽdobued̶ida.– Juda djabarãba idji crĩchara bia ũrĩsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Mãwã panʌne maʌ̃ ismaelerã madianita abadara ãdji caita zebʌda basía. Ãdjirãra ne nẽdod̶aped̶a nẽdobuebadarã basía. Jose djabarãba idjira uriad̶e b̶ʌda ʌ̃taa erreb̶ari edad̶aped̶a maʌ̃ ismaelerãa veinte parata torrobari nẽdobuesid̶aa. Ara maʌ̃da ismaelerãba Josera Egiptod̶aa edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Mãwãnacarea Rubeʌ̃ra ãyã wã b̶ad̶ada dji uriamaa jẽda zesia. Maʌ̃ne Josera ed̶a unuẽ́ bẽrã sopuad̶eba idjia cacuad̶e jʌ̃ b̶ʌra cõãtasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Maʌ̃be idji djabarãmaa wãped̶a jarasia: –¡Warrara uriad̶e neẽ́a! Jãʌ̃be mʌ̃a ¿sãwã oi?– ");
INSERT INTO empNTpo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Maʌ̃ carea ãdjirãba chiwatu zaqueda bead̶aped̶a Joseba cacuad̶e drasoa jʌ̃ b̶ad̶ara dji oaba jũma tãũcuasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Maʌ̃gʌra ãdji zezamaa diabuesid̶aa. Nãwã jarabisid̶aa: “Dairãba za b̶ʌda unusid̶aa. ¿Naʌ̃gʌra bʌ warraba cacuad̶e jʌ̃ b̶ad̶aẽ́ca?” ");
INSERT INTO empNTpo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jacoboba maʌ̃ unusid̶e nãwã jarasia: –Za b̶ʌra mʌ̃ warraba cacuad̶e jʌ̃ b̶ad̶aa. Animarãba idjira beaped̶a cobuesia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Maʌ̃ bẽrã sopuad̶eba Jacoboba cacuad̶e jʌ̃ b̶ʌra cõãtaped̶a sopua careabema jʌ̃badada jʌ̃sia. Maʌ̃be dji warra carea sopua ewarida dãrã wagasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Dji warrarãba, dji caurã bid̶a obadjid̶aa sobiabid̶i carea, baribʌrʌ idjia iduaribica basía. Nãwã jarabadjia: –Mʌ̃ sopuara quĩrãdoaẽ́a ab̶a mʌ̃ beubʌrʌd̶aa.– Mãwã Jose carea aujĩãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Maʌ̃misa madianitarãba Josera ẽberã Potipa abadaa Egiptod̶e nẽdobuesid̶aa. Maʌ̃ Potipara Egiptod̶ebema boro wagabadarã dji droma basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Maʌ̃ ewarid̶e Judara idji djabarãnebemada ãyã wãsia. Adulaʌ̃ purud̶e ẽberã Hira abadama b̶ad̶e wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Mama Judaba cananeo Súa cauda unusia. Judaba Súa caura edaped̶a idji ume cãĩsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Dji wẽrãra b̶iogoa b̶eped̶a umaquĩrã warrada tosia. Judaba idjira trʌ̃ b̶ʌsia Ere. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Dji wẽrãra wayacusa b̶iogoa b̶eped̶a umaquĩrã warrada tosia. Idjira trʌ̃ b̶ʌsia Onaʌ̃. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Wayacusa b̶iogoa b̶eped̶a umaquĩrã warrada tosia. Idjira trʌ̃ b̶ʌsia Sela. Sela tosid̶ad̶e Judara Quezib purud̶e b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Juda warra iwina Ere cũdra bad̶acarea Judaba idji itea wẽrãda jʌrʌsia. Maʌ̃ wẽrãra Tamará abadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Juda warra iwina Erera Ãcõrẽ quĩrãpita dji cadjirua basía. Maʌ̃ carea Ãcõrẽba idjira beubisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Mãwãnacarea Judaba idji warra Onaʌ̃a jarasia: –Bʌ djaba quima bad̶ara edadua dadjia obada quĩrãca. Mãwã bʌa bʌ djaba b̶asi itea warrada oya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Baribʌrʌ Onaʌ̃ba cawa b̶asia maʌ̃ warrara idjid̶ead̶a ad̶aẽ́da, ãtebʌrʌ idji djaba b̶asid̶ead̶a ad̶ida. Maʌ̃ carea dji wẽrã ume cãĩ b̶ʌd̶e wagabadjia wẽrã b̶iogoa b̶erãmãrẽã. Mãwã idji djaba b̶asi itea warra oẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Idjia mãwã o b̶ʌda Ãcõrẽba biẽ́ unusia. Maʌ̃ bẽrã Onaʌ̃ sid̶a beubisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Mãwãnacarea Judaba idji ãĩgu Tamaráa jarasia: –Mʌ̃ warra Sela waribʌrʌmisa quima edaẽ́ bʌ zeza ded̶e b̶ad̶e wãdua. Sela drõã bad̶acarea idjia bʌra edaya.– Ara maʌ̃da Tamarára dji zeza ded̶e b̶ad̶e wãsia. (Idji zezara Timnata purud̶e b̶abadjia.) Baribʌrʌ Judaba wãrãda quĩrĩãẽ́ b̶asia Selaba Tamará edaida. Waya b̶asia Sela sid̶a dji djabarã quĩrãca beuida. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Dãrã b̶ad̶acarea Juda quimara beusia. Idji quimara Súa cau basía. Idji sopua jõnacarea Judara Timnata purud̶aa wãsia idji oveja cara tʌbadamaa. Idji dji bia Hira Adulaʌ̃ purud̶ebemara idji ume wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Maʌ̃ne Timnatad̶ebemarãba Tamaráa jarasid̶aa: –Bʌ zãwãrẽra namaa zebʌrʌa idji oveja cara tʌbi carea.– ");
INSERT INTO empNTpo_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Maʌ̃ ũrĩsid̶e Tamarába pẽdrarãba jʌ̃bada jʌ̃ b̶ad̶ara ẽrãped̶a idji quĩrãra quẽbʌ daucha wuaba bʌrasia ni ab̶aʌba cawarãnamãrẽã. Maʌ̃be Enaiʌ̃ purud̶aa wãsia. Maʌ̃ purura Timnatad̶aa wãbada o caita b̶asia. Tamarára dji purud̶e ed̶a wãbadama chũmesia wẽrã aud̶uaba obada quĩrãca. Idjia mãwã osia Judara idji ume cãĩmãrẽã. Cawa b̶asia Selara cũdra b̶ʌmĩna Judaba idjía diaẽ́da idji quima bamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Judaba Tamará unubʌrʌd̶e wẽrã aud̶uada crĩchasia, idji quĩrãra wuaba bʌrá erob̶ʌ bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Judaba adua b̶asia idji ãĩguda mãwã b̶ʌda. Maʌ̃ bẽrã Tamarámaa wãped̶a jarasia: –¿Bʌra mʌ̃ ume cãĩca?– Tamarába panusia: –Mʌ̃da bʌ ume cãĩbʌrʌ, ¿bʌa mʌ̃́a cãrẽda diai?– ");
INSERT INTO empNTpo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Judaba jarasia: –Mʌ̃ animarãnebema chiwatu zaqueda ab̶a diabueya.– Tamarába jarasia: –Bia b̶ʌa, baribʌrʌ maʌ̃ diabuebʌrʌmisa bʌa nebia erob̶ʌd̶ebemada mʌ̃ ume b̶eedua cawai carea bʌa wãrãda diabueida.– ");
INSERT INTO empNTpo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Judaba iwid̶isia: –¿Cãrẽ nebiada mʌ̃a bʌ́a diai?– Maʌ̃ne Tamarába panusia: –Mʌ̃ ume b̶eedua bʌa sẽyã obarida dji jʌ̃cara bara, idjab̶a bacuru bʌ jʌwad̶e erob̶ʌ sid̶a.– Ara maʌ̃da idjia iwid̶id̶ara Judaba diaped̶a idji ume cãĩsia. Mãwã Tamarába Juda warrada b̶iogoa b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Mãwãnacarea Tamarára diguid̶a wãsia. Idji quĩrã bʌrá erob̶ʌ wuara ẽrãped̶a wayacusa pẽdrarãba jʌ̃badara jʌ̃sia. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Maʌ̃be Judaba idji dji bia Hira Adulaʌ̃nebemara diabuesia chiwatu zaquera wẽrã aud̶uaa diamãrẽã. Diaped̶a Hiraba Juda nebia b̶eed̶ara wayacusa edaida b̶asia. Baribʌrʌ Hiraba dji wẽrãra unuẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Maʌ̃ carea idjia mamabemarãa iwid̶isia: –Wẽrã aud̶ua nama Enaiʌ̃ purud̶aa zebada o icawa chũmanara ¿sãma b̶ʌ?– Ãdjirãba panusid̶aa: –Nama wẽrã aud̶uara ni ab̶a bid̶a neẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Maʌ̃be Hirara Judamaa jẽda zeped̶a jarasia: –Jãʌ̃ wẽrãra mʌ̃a unuẽ́ basía. Arimabemarãba jarasid̶aa jãma wẽrã aud̶uara ni ab̶a bid̶a neẽ́da.– ");
INSERT INTO empNTpo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Maʌ̃ne Judaba jarasia: –Mʌ̃a nebia b̶eed̶ara idjid̶e baya. Mʌ̃a chiwatu zaquera idji itea diabued̶amĩna bʌa idjira unuẽ́ basía. Waa diabueẽ́a jãmabemarãba dadjira ipid̶a jararãnamãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Jed̶eco ũbea babʌrʌd̶e Judaa nãwã jarasid̶aa: –Bʌ ãĩgu Tamarába aud̶uada od̶a bẽrã b̶iogoa b̶esia.– Maʌ̃ carea Judaba jĩgua jarasia: –¡Purud̶eba dajadaa eded̶aped̶a bá bead̶adua!– ");
INSERT INTO empNTpo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ara maʌ̃da Tamará edad̶e wãsid̶aa. Baribʌrʌ dajadaa edebʌdad̶e Tamarába dji zãwãrẽ Judaa nãwã bed̶ea diabuesia: “Naʌ̃ nebia djibariba mʌ̃ra b̶iogoa osia. Acʌdua za b̶ʌ sẽyã obarida dji jʌ̃cara bara, idjab̶a za b̶ʌ bacuru sid̶a. ¿Caida djibari?” ");
INSERT INTO empNTpo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judaba maʌ̃ nebiara idjid̶eda cawad̶a bẽrã nãwã jarasia: –Jãʌ̃ wẽrãba od̶ara mʌ̃a od̶a cãyãbara jipaara b̶ʌa, mʌ̃ warra Selara idjía diad̶aẽ́ bẽrã.– Idjira ẽdrʌ b̶ʌped̶a Judara idji ume waa cãĩẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamará warra toi ewarid̶e cawasia mĩguisoda toida. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Tobʌrʌd̶e jʌwada na odjasia. Maʌ̃ne dji warra careba tobibari wẽrãba maʌ̃ jʌwad̶e jʌ̃cara purruda jʌ̃ b̶ʌsia. Jarasia: “Za b̶ʌda na odjasia.” ");
INSERT INTO empNTpo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Baribʌrʌ jʌwara waya ed̶a wãsia. Maʌ̃ne dewarabemada na tosia. Dji careba tobibari wẽrãba jarasia: “Bʌra ¿sãwãbʌrʌ na tosi?” Mãwã idjira trʌ̃ b̶ʌsid̶aa Paré. ");
INSERT INTO empNTpo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Mãwãnacarea idji djaba, jʌwad̶e jʌ̃cara purru jʌ̃ b̶ʌda tosia. Maʌ̃ carea idjira trʌ̃ b̶ʌsid̶aa Zará. ");
INSERT INTO empNTpo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ismaelerãba Josera Egipto druad̶aa nẽdobued̶e edesid̶aa. Mama ẽberã Potipa abadaba idjira nẽdosia idji nezocada b̶amãrẽã. Potipara Egiptod̶ebema basía. Idjira maʌ̃ druad̶ebema boro wagabadarã dji droma basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ãcõrẽda Jose ume b̶ʌ bẽrã idjia o b̶ʌra jũma bia odjabadjia. Maʌ̃ carea idji boro ded̶e traja b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Joseba o b̶ʌra Ãcõrẽba jũma bia odjabibadjia. Mãwã Jose boro Potipaba cawasia Ãcõrẽra Jose ume b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Maʌ̃ bẽrã idjia Josera bia unuped̶a idji nezocarã boroda b̶ʌsia. Idjab̶a jũma idjia erob̶ʌra Jose jʌwaed̶a b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Maʌ̃ ewarid̶eba ʌ̃taa Ãcõrẽba Potipaba idji ded̶e, idji ẽjũãne erob̶ʌ sid̶a Josed̶eba aud̶uara waribisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potipaba jũma idjid̶eda Jose jʌwaed̶a b̶ʌd̶a bẽrã jũmawãyã crĩchaca basía. Ab̶abe idjia coid̶ebemadrʌ crĩchabadjia. Josera jũma quĩrãwãrẽã b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Maʌ̃ bẽrã Potipa quimaba idjira awua nũmesia. Ewari ab̶a maʌ̃ wẽrãba Josea jarasia: –Wãnaa cãĩne.– ");
INSERT INTO empNTpo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Maʌ̃ne Joseba quĩrĩãẽ́ bẽrã Potipa quimaa jarasia: –Mʌ̃ra bʌ ume cãĩẽ́a. Mʌ̃ boroba idjid̶era jũma mʌ̃ jʌwaed̶a b̶ʌsia. Maʌ̃ bẽrã idjia erob̶ʌd̶ebemada jũmawãyã crĩcha b̶acaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Naʌ̃ ded̶e nezoca mʌ̃ cãyãbara dji dromaara b̶ʌra neẽ́a. Mʌ̃ boroba jũma naʌ̃ ded̶e b̶ʌra mʌ̃ jʌwad̶e b̶ʌsia. Ab̶abe bʌdrʌ mʌ̃ jʌwad̶e b̶ʌẽ́ b̶ʌa, idji quima bẽrã. Maʌ̃ cadjirua waib̶ʌada mʌ̃a ¿cãrẽã oi? ¡Mãwã oibʌrʌ Ãcõrẽ quĩrãpita cadjiruada oya!– ");
INSERT INTO empNTpo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Potipa quimaba nurẽmaza Josea jara b̶abadjia idji ume cãĩmãrẽã wa idji ume nẽbʌrʌ b̶amãrẽã. Mãwãmĩna Joseba idji bed̶eara ĩjãca basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ewari ab̶a Josera Potipa ded̶e trajad̶e wãsid̶e ni ab̶aʌ nezocada neẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Maʌ̃ne Joseba jʌ̃ b̶ʌra Potipa quimaba jida dogoped̶a nãwã jarasia: –¡Mʌ̃ ume cãĩdua!– Baribʌrʌ Joseba jʌ̃ b̶ʌra wẽãtaped̶a dajadaa pira wãsia. Mãwã idjia jʌ̃ b̶ad̶ara dji wẽrã jʌwad̶e b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Dji wẽrãba unusia Josera pira wãbʌrʌda idjab̶a Joseba jʌ̃ b̶ad̶ara idji jʌwad̶e b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Maʌ̃ bẽrã idji ded̶ebema nezocarãda trʌ̃ped̶a nãwã jarasia: –Acʌd̶adua, mʌ̃ quimaba jãʌ̃ hebreora dadjirãmaa enesia. Baribʌrʌ jãʌ̃ ẽberãba dadjirãra biẽ́ oya b̶ʌa. Idjira nama zeped̶a mʌ̃ ume cãĩ quĩrĩã nũmasia. Maʌ̃ carea mʌ̃ra jĩgua b̶iasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Mʌ̃ b̶iabʌrʌ carea idjira dajadaa mĩrũ pira wãsia. Acʌd̶adua, idjia jʌ̃ b̶ad̶ara nama b̶eesia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Maʌ̃be Joseba jʌ̃ b̶ad̶ara dji wẽrãba wagasia ab̶a idji quima Potipa diguid̶aa zebʌrʌd̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Idji quima jũẽsid̶e idjia ab̶arida jarasia: –Bʌa dadji itea enena hebreo nezocara nama zeped̶a mʌ̃ra biẽ́ o quĩrĩã b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Baribʌrʌ mʌ̃ jĩgua b̶iabʌrʌ carea idjira dajadaa mĩrũ pira wãsia. Acʌdua, idjia jʌ̃ b̶ad̶ara nama b̶eesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Bʌ nezocaba mʌ̃ra jãwã osia.– Idji quimaba jara b̶ʌ ũrĩsid̶e Potipara bio quĩrũsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","21","Maʌ̃ carea Josera jidabiped̶a preso b̶ʌbisia Egiptod̶ebema boroba preso b̶ʌbari ded̶e. Baribʌrʌ Jose mama preso b̶ʌd̶e bid̶a Ãcõrẽra idji ume b̶asia. Idjira bio careba b̶asia. Maʌ̃ carea dji preso b̶ʌbada boroba Josera bia unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Maʌ̃ bẽrã idjia preso b̶eara Jose jʌwaed̶a jũma b̶ʌsia wagamãrẽã. Mãwã jũma mama oida b̶ʌra Josebʌrʌ obibadjia. ");
INSERT INTO empNTpo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Joseba jũma bia o b̶ʌ bẽrã dji preso b̶ʌbada boroba idjia o b̶ʌra quĩrãcuitaca basía. Mãwã b̶asia Ãcõrẽra Jose ume b̶ʌ bẽrã. Jũma Joseba o b̶ʌra Ãcõrẽba bia odjabisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Jose preso b̶asid̶e Egiptod̶ebema boro itea umé traja panasid̶aa. Ab̶a uva b̶a jue diabada boro basía. Dewarabemada paʌ̃ obada boro basía. Maʌ̃ umébemaba Egiptod̶ebema borora bio quĩrũbisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Maʌ̃ carea dji boroba ãdjira idji wagabadarã boro ded̶e preso b̶ʌbisia. Josera maʌ̃ preso b̶ʌbada ded̶e b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Dji preso b̶ʌbada boroba Josera b̶ʌsia maʌ̃ umébemara acʌ b̶amãrẽã. Mama ãdjira dãrã preso panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ewari ab̶a Egiptod̶ebema boroa uva b̶a jue diabari bad̶ara, paʌ̃ obari bad̶a sid̶a ab̶ari diamasi cãĩmocarasid̶aa. Cãĩmocaraza ne jara awara b̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Diaped̶ed̶a Jose ãdjimaa wãbʌrʌd̶e unusia ãdjira sopua panʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Maʌ̃ carea Joseba ãdjía iwid̶isia: –¿Cãrẽ cãrẽã bãrãra sopua panʌ?– ");
INSERT INTO empNTpo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ãdjia panusid̶aa: –Daiba id̶i cãĩmocaraped̶ad̶ara caiba cawa jaraida neẽ́ bẽrã jãwã sopua panʌa.– Maʌ̃ne Joseba jarasia: –Ab̶a Ãcõrẽbʌrʌ cãĩmocarara poya cawa jarabiya. Bãrãba cãĩmocaraped̶ad̶ara mʌ̃́a nẽbʌrʌd̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ara maʌ̃da uva b̶a jue diabada boro bad̶aba idji cãĩmocarara Josea nẽbʌrʌsia. Nãwã jarasia: –Mʌ̃a cãĩmocarad̶e unusia uva jʌ̃carada mʌ̃ caita nũmʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Maʌ̃ uva jʌ̃carara jʌwate ũbea b̶asia. Maʌ̃ jʌ̃carara tucuped̶a, põnõped̶a, bio zau nũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Maʌ̃ne nama dai druad̶ebema boro tazada mʌ̃ jʌwad̶e erob̶asia. Maʌ̃ tazad̶e mʌ̃a uvada b̶arrajuped̶a dai boroa diasia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Maʌ̃ jarad̶acarea Joseba nãwã jarasia: –Bʌ cãĩmocaraba naʌ̃da jara b̶ʌa: uva jʌwate ũbea bʌa ununaba jara b̶ʌa ewari ũbea. ");
INSERT INTO empNTpo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ewari ũbead̶e Egiptod̶ebema boroba bʌra idji quĩrãpita trʌ̃ya bʌa naãrã o b̶ad̶a quĩrãca wayacusa o b̶amãrẽã. Mãwã bʌa waya idjía uva b̶ara jue dia b̶aya bʌa naẽna o b̶ad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Bʌ bia b̶ebʌrʌd̶e mʌ̃ djuburia mʌ̃ra quĩrãdoarãdua. Bʌ boroa mʌ̃nebemada jaradua naʌ̃ ded̶ebemada ẽdrʌ b̶ʌmãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Mʌ̃ra hebreorã druad̶ebemada jida enesid̶aa idjab̶a mʌ̃a ni cãrẽ sid̶a oẽ́ b̶ʌda nama preso eropanʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Paʌ̃ obada boro bad̶aba ũrĩ b̶asia Joseba maʌ̃ cãĩmocarara cawa jara b̶ʌda. Joseba cawa jarad̶ara bia b̶ad̶a bẽrã idjia jarasia: –Mʌ̃ sid̶a cãĩmocarasia. Mʌ̃a unusia mʌ̃ boro ʌ̃rʌ̃ jamara paʌ̃ bara b̶eada ũbea eronĩda. ");
INSERT INTO empNTpo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Dji ʌ̃rʌ̃bemane paʌ̃ cũãda quĩrãtanoa erob̶asia nama dai druad̶ebema boro itea. Baribʌrʌ cawaẽ́ne maʌ̃ paʌ̃ cũãra ĩbanaba co duanesid̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Mãwã jarad̶acarea Joseba idjía jarasia: –Bʌ cãĩmocaraba naʌ̃da jara b̶ʌa: maʌ̃ jamara ũbea bʌa ununaba jara b̶ʌa ewari ũbea. ");
INSERT INTO empNTpo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ewari ũbead̶e Egiptod̶ebema boroba bʌra idji quĩrãpita trʌ̃ya. Baribʌrʌ bʌra ob̶ʌá tubiped̶a bacuru cũmiane ʌ̃tʌ su jira b̶ʌbiya. Maʌ̃be ãgosoba bʌ djarara cod̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ewari ũbea bad̶acarea Egiptod̶ebema boroba idji tod̶a ewari b̶ʌsrid̶ada osia. Dji dromarã itea djicoda waib̶ʌa obisia. Maʌ̃ne uva b̶a jue diabada boro bad̶ara, paʌ̃ obada boro bad̶a sid̶a idji quĩrãpita enebisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Maʌ̃be uva b̶a jue diabada boro bad̶ara b̶ʌsia wayacusa idjia naãrã o b̶ad̶a quĩrãca o b̶amãrẽã. Mãwã idjia wayacusa uva b̶ara Egiptod̶ebema boroa jue dia b̶esia Joseba jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Baribʌrʌ paʌ̃ obada boro bad̶ara bacuru cũmiane ʌ̃tʌ su jira b̶ʌbisia Joseba jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Uva b̶a jue diabada borora bia b̶ed̶amĩna Josera ab̶ed̶a quĩrãdoasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Jose poa umé preso b̶ad̶acarea Egiptod̶ebema borora cãĩmocarasia. Maʌ̃ cãĩmocarad̶e unusia idjira Nilo do icawa nũmʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Maʌ̃ne siete paca biya boreguea qued̶eada doed̶aʌba odjad̶aped̶a põãjãrã co duanasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ãdji caid̶u dewara siete paca mititia caya b̶eada doed̶aʌba odjasid̶aa. Maʌ̃ caya b̶eara dji boreguea b̶ea caita do icawa nũpanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Maʌ̃ne dji mititia caya b̶eaba dji biya boreguea qued̶eara cocuasid̶aa. Maʌ̃ne Egiptod̶ebema borora ʌ̃rʌ̃masia. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Baribʌrʌ wayacusa cãĩped̶a cãĩmocarad̶e unusia trigo b̶ʌwʌrʌ ab̶aʌd̶e siete cʌmʌ biya uga b̶eada. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Maʌ̃be unusia dewara trigo b̶ʌwʌrʌd̶e siete cʌmʌ ugaẽ́ b̶eada. Maʌ̃gʌra nãũrã jʌ̃wʌ̃rʌ̃ã ʌ̃mãdau odjabariareba tʌ nũmʌba jãrãzaza b̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Maʌ̃ne cʌmʌ ugaẽ́ b̶eaba dji biya uga qued̶eara cocuasid̶aa. Mãwã b̶ʌd̶e Egiptod̶ebema borora ʌ̃rʌ̃masia. Maʌ̃ne cawasia idjia ununara cãĩmocara basida. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Nurẽma diaped̶a idjia cãĩmocarad̶a carea cawa crĩchaẽ́ b̶esia. Maʌ̃ bẽrã Egiptod̶ebema daubararãda, ne cawa b̶ea sid̶a trʌ̃cuabiped̶a idjia cãĩmocarad̶ara ãdjía nẽbʌrʌsia cawa jarad̶amãrẽã. Mãwãmĩna ni ab̶aʌba poya cawa jarad̶aẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Mãwã panʌne uva b̶a jue diabada boroba Egiptod̶ebema boroa jarasia: –Mʌ̃ boro, mʌ̃a biẽ́ osia. Mʌ̃a ne jaraida b̶ad̶ara quĩrãdoa b̶asia. Id̶ibe quĩrãnebabʌrʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Bʌ paʌ̃ obada boro ume, mʌ̃ ume bid̶a quĩrũped̶a daira preso b̶ʌbisia bʌ wagabadarã boro ded̶e. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Dai preso panasid̶ad̶e ab̶ari diamasi daira cãĩmocarasid̶aa. Cãĩmocaraza ne jara awara b̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Maʌ̃ne hebreo cũdrada dai ume b̶asia. Maʌ̃ hebreora bʌ wagabada boro nezoca basía. Daiba cãĩmocaraped̶ad̶ara idjía nẽbʌrʌsid̶aa. Maʌ̃ne idjia dai cãĩmocarara umena cawa jarasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Idjia daia jarad̶a quĩrãca wãrãda mãwãsia. Bʌa mʌ̃ra wayacusa b̶ʌsia mʌ̃a naẽna bʌ itea o b̶ad̶a quĩrãca o b̶amãrẽã. Maʌ̃ne dewarabemara bʌa beabiped̶a bacuru cũmiane ʌ̃tʌ su jira b̶ʌbisia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Maʌ̃ carea Egiptod̶ebema boroba Josera trʌ̃bisia. Ara maʌ̃da preso b̶ad̶ada isabe ẽdrʌ b̶ʌsid̶aa. Josera icara wẽped̶a, bud̶a tʌped̶a, bia djioped̶a Egiptod̶ebema boromaa wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Maʌ̃be dji boroba Josea jarasia: –Mʌ̃ra cãĩmocarasia, mãwãmĩna ni ab̶aʌba poya cawa jarad̶aẽ́ panʌa. Baribʌrʌ mʌ̃a ũrĩsia bʌa cãĩmocarara cawa jarabarida.– ");
INSERT INTO empNTpo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseba jarasia: –Mʌ̃ boro, maʌ̃gʌra mʌ̃dub̶a poya oẽ́a. Bʌa cãĩmocarad̶ara Ãcõrẽbʌrʌ cawa jarabiya necai b̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Egiptod̶ebema boroba Josea jarasia: –Mʌ̃a cãĩmocarasia mʌ̃ra Nilo do icawa nũmʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Maʌ̃ne siete paca biya boreguea qued̶eada doed̶aʌba odjad̶aped̶a põãjãrã co duanasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ãdji caid̶u dewara siete paca mititia caya b̶eada doed̶aʌba odjasid̶aa. Naʌ̃ Egipto druad̶e mʌ̃a unucaa paca jãcua mititia b̶eada. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Maʌ̃ paca mititia caya b̶eaba dji naãrã odjaped̶ad̶a boreguea b̶eara cocuasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Dji caya b̶eaba dji boreguea qued̶eara cocuaped̶ad̶amĩna ara mãwã bio caya panesid̶aa ãdji naãrã panana quĩrãca. Maʌ̃ne mʌ̃ra ʌ̃rʌ̃masia. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Baribʌrʌ mʌ̃ra waya cãĩmocarasia. Unusia trigo b̶ʌwʌrʌ ab̶aʌd̶e siete cʌmʌ biya uga b̶eada. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Maʌ̃are unusia trigo b̶ʌwʌrʌd̶e siete cʌmʌ ugaẽ́ b̶eada. Maʌ̃gʌra nãũrã jʌ̃wʌ̃rʌ̃ã ʌ̃mãdau odjabariareba tʌ nũmʌba jãrãzaza b̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Maʌ̃ne ugaẽ́ b̶eaba dji uga qued̶eara jũma cosid̶aa. Mʌ̃a maʌ̃ cãĩmocarad̶ara daubararãa jarasia. Mãwãmĩna poya cawa jarad̶aẽ́ basía.– ");
INSERT INTO empNTpo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Maʌ̃ne Joseba Egiptod̶ebema boroa jarasia: –Mʌ̃ boro, maʌ̃ cãĩmocara uméba ab̶arida jara b̶ʌa. Ãcõrẽba sãwã oida bʌ́a unubisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Dji siete paca bia qued̶eaba jara b̶ʌa siete poa cod̶id̶ebema ad̶uba eropananida. Dji siete trigo cʌmʌ uga qued̶ea bid̶a ab̶ari quĩrãca jara b̶ʌa siete poa cod̶id̶ebema ad̶uba eropananida. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Baribʌrʌ dji siete paca mititia caya b̶ea ãdji caid̶u odjaped̶ad̶aba jara b̶ʌa siete poa jarrabada zeida. Dji siete trigo cʌmʌ ugaẽ́ b̶eaba ab̶arida jara b̶ʌa. Maʌ̃ cʌmʌra nãũrã jʌ̃wʌ̃rʌ̃ã ʌ̃mãdau odjabariareba tʌ nũmʌba jãrãzaza b̶easia. Maʌ̃ba jara b̶ʌa siete poa jarrabada zeida. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Mʌ̃ boro, Ãcõrẽba bʌ́a unubisia idjia oida mʌ̃a jara b̶ʌ quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Siete poa naʌ̃ Egipto druad̶e cod̶id̶ebemara ad̶uba eropanania. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Maʌ̃are siete poa naʌ̃ Egiptod̶e jarrabada zeya. Maʌ̃ jarrabara bio dãrãi bẽrã egiptorãba dji ad̶uba eropanana ewarira ab̶ed̶a quĩrãdoad̶ia. Maʌ̃ne cod̶id̶ebema naʌ̃ druad̶e b̶ʌra jõya. Dji ad̶uba eropanananebemada ni maãrĩ bid̶a neẽ́ b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Bʌa b̶arima umé cãĩmocarad̶aba jara b̶ʌa Ãcõrẽba dãrãẽ́ne wãrãda mãwã oida. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Maʌ̃ bẽrã, mʌ̃ boro, bʌa ẽberã crĩcha cawa b̶ʌda jʌrʌped̶a b̶ʌida b̶ʌa naʌ̃ Egipto druara acʌ b̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","35","Maʌ̃are jũma naʌ̃ Egipto druad̶e trigo wagabada bororãda b̶ʌcuaida b̶ʌa. Siete poa ad̶uba eropanʌne ẽberãrãba ewabʌdad̶ebemada maʌ̃ bororãba maãrĩ wagad̶ida panʌa. Ẽ juesuma ewabʌdaza ab̶a wagad̶ida panʌa. Mãwã od̶ida panʌa puru b̶eaza. Ãdjia wagaped̶ad̶ara bʌabʌrʌ cawa jaraya sãwã jed̶eida. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Mãwã osira siete poa jarraba zebʌrʌd̶e trigora waga eropanania naʌ̃ Egipto druad̶ebemarã quinirãnamãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Maʌ̃ crĩchara Egiptod̶ebema boroba, dji dromarã bid̶a bio bia ũrĩsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Dji boroba ãdjirãa jarasia: –Ãcõrẽ Jaureda naʌ̃ ẽberã ume b̶ʌa. Dadjirãba dewara ẽberãda idji quĩrãca ununaẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ara maʌ̃da idjia Josea jarasia: –Ãcõrẽba bʌ́a maʌ̃ra cawabisia. Bʌ quĩrãca crĩcha cawa b̶ʌra neẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Maʌ̃ carea mʌ̃a bʌra dji dromarã boroda b̶ʌya. Bʌa jarabʌrʌra jũmarãba ĩjã od̶ia. Ab̶abe mʌ̃drʌ bʌ cãyãbara dji dromara b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Mʌ̃a jũma naʌ̃ druad̶ebemara bʌ jʌwaed̶a b̶ʌbʌrʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Maʌ̃ne Egiptod̶ebema boroba idji sẽyã bara b̶ʌ sortijada Jose jʌwad̶e wẽãju b̶ʌsia Joseba dji boro trʌ̃neba jũma poya o b̶amãrẽã. Dji biara b̶ʌ lino od̶a djioda, oro od̶a carena sid̶a Josea jʌ̃bisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Maʌ̃be idji carretad̶e b̶adoped̶a Josera idjiare dewara carretad̶e pʌrrʌa edesia. Wãbʌdad̶e idji wagabadarãda Jose na wãbibadjia nãwã jĩgua jarad̶amãrẽã: “¡Chĩrãne cob̶ead̶adua!” Mãwã Egiptod̶ebema boroba jũma Egipto druara Jose jʌwaed̶a b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Maʌ̃be idjia Josea jarasia: –Mʌ̃ra jũmarã boroa, baribʌrʌ jũma naʌ̃ druad̶ebemarãra bʌ jʌwaed̶a b̶ead̶ia. Ãdjirãba bʌ́a iwid̶id̶aẽ́ ni cãrẽ sid̶a ocara panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Egiptod̶ebema boroba Jose trʌ̃ra b̶ʌsia Zapnat-panea. Maʌ̃ awara wẽrã Asena abadada Josea diasia idji quima bamãrẽã. Maʌ̃ Asenara Potipera cau basía. Potiperara Oʌ̃ purud̶e ʌ̃mãdaúa bia bed̶eabadarã sacerdote basía. Mãwã Josera jũma Egipto druad̶e dji dromada b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Egiptod̶ebema boroba Josera dji dromada b̶ʌsid̶e idjira treinta poa b̶asia. Josera dji boroma b̶ad̶ada jũma Egipto druad̶e pʌrrʌa wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Maʌ̃be siete poa ne jũmada bia zaud̶a bẽrã cod̶id̶ebemara ad̶uba nũmasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Maʌ̃ siete poad̶e Egipto druad̶e ewaped̶ad̶ad̶ebemada Joseba waga b̶ʌbisia. Puruza dji puru caita ewaped̶ad̶ara maãrĩ waga b̶ʌbisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Mãwã trigora waib̶ʌa waga b̶ʌsid̶aa. Pusa ĩbʌ quĩrãca ãdjirãba waib̶ʌa waga eropanasid̶aa. Maʌ̃ bẽrã juacha pananada idu b̶ʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Jarraba ewari zei naẽna Joseba idji quima Asena ume warrarãda umé unusia. Asena zeza Potiperara Oʌ̃ purud̶e ʌ̃mãdaúa bia bed̶eabadarã sacerdote basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Idji warra iwina tosid̶ad̶e Joseba nãwã crĩchasia: “Ãcõrẽba jũma mʌ̃ bia mĩga b̶ad̶ara, mʌ̃ ẽberãrã sid̶a quĩrãdoabisia.” Mãwã idji warra iwinara trʌ̃ b̶ʌsia Manase. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Dewarabema warra tosid̶ad̶e Joseba nãwã crĩchasia: “Mʌ̃ biẽ́ b̶ad̶a druad̶e Ãcõrẽba mʌ̃́a warrarãra unubisia.” Mãwã dji warrara trʌ̃ b̶ʌsia Epraiʌ̃. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","54","Siete poa Egipto druad̶e ad̶uba zau nũmana jõnacarea siete poa jarrabada zesia Joseba jarad̶a quĩrãca. Druaza jarrabara wãsia. Baribʌrʌ egiptorãba cod̶ira eropanasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Mãwã b̶ʌd̶e egiptorãba cod̶i carea erob̶ead̶a sid̶a jõsia. Maʌ̃ bẽrã ãdji boromaa cod̶ira iwid̶id̶e wãsid̶aa. Ãdji boroba jũmarãa jarasia: –Josemaa wãnadua. Idjia jarabʌrʌ quĩrãca od̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Jarraba Egipto druad̶e zesid̶e Joseba trigo wagabada dera jũma ewabicuasia. Maʌ̃be trigora egiptorãa nẽdobuebadjia, jarrabara wãrãda jũma Egipto druad̶e zed̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Maʌ̃ awara druazabemada Josemaa trigo nẽdod̶e zebadjid̶aa jarrabara jũma druaza wãna bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","2","Maʌ̃ ewarid̶e Jose zeza Jacobora wad̶i Canaaʌ̃ druad̶e b̶abadjia. Jacoboba cawasia Egipto druad̶e trigora baraada. Maʌ̃ bẽrã idji warrarãa nãwã jarasia: –Mʌ̃a ũrĩsia Egiptod̶e trigora baraada. ¿Cãrẽda jʌ̃ã panʌ? Jãmaa nẽdod̶e wãnadua dadjirãba cod̶i carea. Mãwã dadjirãra jarrababa beud̶aẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","4","Ara maʌ̃da Jose djabarãra Egiptod̶aa trigo nẽdod̶e wãsid̶aa. Jacoboba Jose djaba Benjamiʌ̃ra diabueẽ́ basía, wayad̶a bẽrã Benjamiʌ̃ra beuida. Maʌ̃ bẽrã Jose djabarãra diebe wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Israel warrarãra dewara ẽberãrã ume trigo nẽdod̶e wãsid̶aa, jũma Canaaʌ̃ druad̶e jarrabara zed̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Maʌ̃ne Josera Egipto druad̶e dji droma basía. Idjiabʌrʌ jũma druazabemarãa trigora nẽdobuebadjia. Mãwã b̶ʌd̶e Jose djabarãra jũẽsid̶aa. Jũẽnaped̶a Jose quĩrãpita wayaad̶eba egorod̶e b̶arru copanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","Joseba idji djabarã unusid̶e cawasia ãdjida mãwã panʌda baribʌrʌ adua b̶ʌ quĩrãca b̶esia. Idji djabarãba idjira cawad̶aẽ́ basía. Maʌ̃ne Josera ãdji ume quĩrũ b̶ʌ quĩrãca b̶ed̶easia. Iwid̶isia: –Bãrãra ¿sãmaʌba zebʌda?– Ãdjia panusid̶aa: –Canaaʌ̃ druad̶eba trigo nẽdod̶e ze panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Maʌ̃ne Joseba quĩrãnebasia ãdjid̶ebema cãĩmocarad̶ada. Maʌ̃ bẽrã jarasia: –¡Bãrãba dairã sãwã poyad̶i cawaya acʌd̶e ze panʌa!– ");
INSERT INTO empNTpo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","11","Ãdjia panusid̶aa: –¡Mãwãẽ́a, dai boro! ¡Daira maʌ̃ carea nĩnaẽ́a! Dai bʌ nezocarãra jipa b̶eaa. Daira jũmaena ab̶ari zezad̶ebemaa. Daiba trigodrʌ nẽdod̶e ze panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Joseba jarasia: –¡Sewaa! Bãrãba dairã sãwã poyad̶i cawaya acʌd̶e ze panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ãdjirãba panusid̶aa: –Dai bʌ nezocarãra wãrãda ab̶ari zezad̶ebemaa. Daira doce djabarã panasid̶aa. Baribʌrʌ dai djaba tẽãbemara dai zeza ume Canaaʌ̃ druad̶e b̶esia. Maʌ̃ne ab̶a nẽbasia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Joseba jarasia: –Mʌ̃a jarad̶a quĩrãca ebud̶a b̶ʌa bãrãba acʌd̶e ze panʌda dairã sãwã poyad̶i cawaya. ");
INSERT INTO empNTpo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Baribʌrʌ mʌ̃a acʌya bãrãba jara panʌra wãrã cawaya. Dai Egiptod̶ebema boro trʌ̃neba mʌ̃a wãrãneba jaraya bãrãra namabemada ẽdrʌd̶aẽ́a ab̶a bãrã djaba tẽãbemada namaa zebʌrʌd̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Bãrãnebemada ab̶a wãbid̶adua bãrã djaba tẽãbemada enemãrẽã. Maʌ̃misa waabemarãra nama preso panenia. Idjida zeibʌrʌ, mʌ̃a cawaya bãrãba jara panʌra wãrãda. Idjida zeẽ́bʌrʌ, dai Egiptod̶ebema boro trʌ̃neba mʌ̃a wãrãneba jaraya bãrãra bed̶ead̶e pananida dairã sãwã poyad̶i cawaya acʌd̶e ze panʌ carea.– ");
INSERT INTO empNTpo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ara maʌ̃da Joseba ãdjira ewari ũbea preso b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ewari ũbea babʌrʌd̶e Joseba ãdjía jarasia: –Mʌ̃a Ãcõrẽra waya b̶ʌa. Maʌ̃ bẽrã bãrãba nãwã od̶ibʌrʌ, mʌ̃a beabiẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Bãrãda wãrãda ẽberã jipa b̶eabʌrʌ, nama bãrãnebemada ab̶a preso b̶eya. Maʌ̃ne waabemara bãrã diguid̶aa trigo diad̶e wãnadua bãrã ẽberãrãba cod̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Baribʌrʌ bãrã djaba tẽãbemara enenadua. Mãwã mʌ̃a cawaya bãrãba jara panʌra wãrãda. Mãwã od̶aẽ́bʌrʌ, bãrãra beud̶ia.– Ãdjirãba maʌ̃ bed̶eara ĩjãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Mãwã panʌne ãdjidub̶a jara duanesid̶aa: –Wãrãda dadji djaba Joseda biẽ́ osid̶aa. Dadjirãba unusid̶aa idji biẽ́ orãnamãrẽã dadjirãa bed̶ea djuburia b̶ʌda. Mãwãmĩna dadjirãba ĩjãnaẽ́ basía. Maʌ̃ carea nama bia mĩga panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Maʌ̃ne Rubeʌ̃ba jarasia: –Maʌ̃ carea mʌ̃a bãrãa jarasia idjira biẽ́ orãnamãrẽã, mãwãmĩna bãrãba ĩjãnaẽ́ basía. Idji beaped̶ad̶a carea id̶ibʌrʌ Ãcõrẽba dadjira cawa obʌrʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Maʌ̃ne Josera egiptorã bed̶ead̶e ãdji ume bed̶ea b̶asia. Idjia jarabʌrʌra dewaraba ãdjía jarabadjia hebreo bed̶ead̶e. Maʌ̃ bẽrã adua panasid̶aa ãdjia jara panʌra Joseba jũma ũrĩ b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ãdjia biẽ́ oped̶ad̶ad̶ebema bed̶ea panʌ ũrĩsid̶e Josera idub̶a ãyã wãped̶a jĩãsia. Mãwã b̶aped̶a waya poya bed̶easia. Maʌ̃be ãdji ume bed̶ead̶e wãped̶a Simeoʌ̃da jidabisia preso b̶emãrẽã. Ara maʌ̃da ãdjia acʌ panʌne Simeoʌ̃ra jʌ̃tabisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Maʌ̃be Joseba idji nezocarãa jarasia idji djabarãba trigo nẽdoped̶ad̶aba ãdji sacora biracuad̶amãrẽã. Maʌ̃ne ãdji parata sid̶a waya sacoza b̶ʌcuabisia. Maʌ̃ awara Joseba diabisia od̶e ne cod̶amãrẽã. Ara maʌ̃da idji nezocarãba mãwã osid̶aa. Baribʌrʌ parata ãdji sacoza b̶ʌped̶ad̶ada Jose djabarãba adua panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Maʌ̃be Jose djabarãba trigora ãdji burro ʌ̃rʌ̃ b̶ʌcuad̶aped̶a wãbʌrʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Wãbʌdad̶e ota cãĩnima jũẽsid̶aa. Maʌ̃be ab̶aʌba idji burro ne cobi carea saco ewabʌrʌd̶e idji paratara ed̶a cob̶ʌda unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Dauperaped̶a idji djabarãa jarasia: –Mʌ̃ paratara jẽda diasid̶aa. Za mʌ̃ sacod̶e ed̶a cob̶ʌa.– Maʌ̃ carea jũmarãda dauperasid̶aa. Ne wayaaba ure duanʌne nãwã jarasid̶aa: –¿Cãrẽ cãrẽã Ãcõrẽba dadjira jãwã o b̶ʌ?– ");
INSERT INTO empNTpo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Canaaʌ̃ druad̶e ãdji zeza Jacoboma jũẽnaped̶a ãdji Egipto druad̶e sãwãped̶ad̶ara jũma nẽbʌrʌsid̶aa. Nãwã jarasid̶aa: ");
INSERT INTO empNTpo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","–Jãʌ̃ druad̶ebema ẽberã dji droma b̶ʌba daia quĩrũbid̶eba nãwã jarasia: “Bãrãba dairã sãwã poyad̶i cawaya acʌd̶e zesid̶aa.” ");
INSERT INTO empNTpo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Baribʌrʌ dairãba jarasid̶aa mãwã od̶i carea ze panʌẽ́da, ãtebʌrʌ ẽberã jipa b̶eada. ");
INSERT INTO empNTpo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Idjab̶a jarasid̶aa dairãra ab̶ari zezad̶ebemada doce djabarã panasid̶ada. Jarasid̶aa ab̶ara nẽbasida, ab̶ara dai zeza ume Canaaʌ̃ druad̶e b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Maʌ̃ne jãʌ̃ dji dromaba dairãa jarasia: “Nãwã cawaya bãrãra ẽberã jipa b̶eada: bãrã djabarãnebemada ab̶a mʌ̃ ume amenaped̶a trigora eded̶adua bãrã ẽberãrã jarra qued̶eaa cobid̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Maʌ̃be bãrã djaba tẽãbemara mʌ̃maa enenadua mʌ̃a cawai carea bãrãra jipa b̶eada. Mãwã mʌ̃a cawaya bãrãba wãrãda acʌd̶e zed̶aẽ́ panʌda dairã sãwã poyad̶i cawaya. Mãwã osid̶ara mʌ̃a bãrã djabara jẽda diaya. Idjab̶a naʌ̃ druad̶e bãrãba quĩrĩãbʌdada poya nẽdod̶ia idjab̶a nẽdobued̶ia.”– ");
INSERT INTO empNTpo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Mãwã nẽbʌrʌd̶aped̶a ãdji saco ẽrãcuabʌdad̶e sacoza ãdji paratara ed̶a cob̶eada unusid̶aa. Maʌ̃ unubʌdad̶e ãdji zezara, ãdjirã sid̶a bio dauperasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Maʌ̃ carea ãdji zeza Jacoboba jarasia: –Bãrãba mʌ̃ra warra neẽ́ obʌdaa. Joseda idjab̶a Simeoʌ̃ sid̶a neẽ́a. Maʌ̃ awara Benjamiʌ̃ sid̶a jãmaa ede quĩrĩã panʌa. Maʌ̃neba mʌ̃drʌ bia sopua unu b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Maʌ̃ne Rubeʌ̃ba jarasia: –Zeza, mʌ̃a Benjamiʌ̃ra waya bʌmaa eneya. Eneẽ́bʌrʌ, mʌ̃ warrarãda umé beaida b̶ʌa. Mʌ̃́a idu Benjamiʌ̃ra edebidua. Wãrãda waya jẽda eneya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Mãwã jarad̶amĩna Jacoboba jarasia: –Mʌ̃ warrara bãrã ume diabueẽ́a. Idji djaba arara beud̶a bẽrã ab̶a idjidrʌ b̶ʌa. Idjida od̶e beuibʌrʌ, bãrãba mʌ̃ra sopuaba bead̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Mãwã panʌne Canaaʌ̃ druad̶e jarrabara wetara zesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Maʌ̃ne ãdjia trigo Egipto druad̶e nẽdoped̶ad̶ara jũma cosid̶aa. Maʌ̃ bẽrã ãdji zeza Jacoboba jarasia: –Wayacusa Egiptod̶aa trigo nẽdod̶e wãnadua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Baribʌrʌ Judaba panusia: –Jãʌ̃ ẽberãba daia ebud̶a jarasia: “Bãrãra mʌ̃maa zecara panʌa, bãrã djaba tẽãbemada enenaẽ́bʌrʌ.” ");
INSERT INTO empNTpo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Maʌ̃ba, zeza, dai djaba tẽãbemara bʌa dai ume diabueibʌrʌ, daira trigo nẽdod̶e wãnia. ");
INSERT INTO empNTpo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Baribʌrʌ dai ume diabueẽ́bʌrʌ, poya wãnaẽ́a jãʌ̃ ẽberãba jarad̶a bẽrã: “Bãrãra mʌ̃maa zecara panʌa, bãrã djabada enenaẽ́bʌrʌ.”– ");
INSERT INTO empNTpo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Maʌ̃ne Jacobo Israel abadaba iwid̶isia: –Bãrãba ¿cãrẽ cãrẽã maʌ̃ ẽberãa jarasid̶a dewara djabada eropanʌda? Maʌ̃ jaraped̶ad̶aba mʌ̃ra biẽ́ osid̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ãdjirãba panusid̶aa: –Jãʌ̃ ẽberãba daia bio iwid̶isia daid̶ebemada, dai ẽberãrãnebema sid̶a. Nãwã iwid̶isia: “Bãrã zezara ¿wad̶i b̶ʌca? Bãrãba ¿dewara djabada eropanʌca?” Maʌ̃ bẽrã daiba idjía wãrãda jarasid̶aa. Daiba adua panasid̶aa idjia jaraida dai djaba eded̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Maʌ̃ne Judaba idji zeza Israelea jarasia: –Bʌa Benjamiʌ̃da mʌ̃ ume diabueibʌrʌ, daira ara nawena trigo nẽdod̶e wãbʌrʌd̶ia. Wãnaẽ́bʌrʌ bʌda, daida, dai warrarã sid̶a jũma quininia. ");
INSERT INTO empNTpo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mʌ̃abʌrʌ Benjamiʌ̃ra wagaya. Mʌ̃a idjira eneped̶a wayacusa bʌ quĩrãpita b̶ʌẽ́bʌrʌ, mʌ̃da bed̶ead̶e b̶eya ab̶a mʌ̃ beubʌrʌd̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Daida nama jãcua dãrãnaẽ́ pananabara, Egiptod̶aa b̶arima umé wãnoacasid̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Maʌ̃ne dji zeza Israelba panusia: –Wãrãda Benjamiʌ̃da eded̶ida panʌbʌrʌ, nãwã od̶adua. Dadjirã ẽjũãnebema ne biara b̶eada bãrã sacod̶e b̶ʌd̶aped̶a maʌ̃ ẽberãa diad̶e wãnadua. Balsamo nẽãrãda, urrajõda, mirra querada, dewara quera tũãpa b̶eada, pistacho bacuru tada, almendra sid̶a maãrĩ diad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Parata sid̶a waib̶ʌara eded̶adua dji parata bãrã sacod̶e zed̶ara jẽda diad̶i carea. Ãĩbẽrã quĩrãdoa ed̶a b̶ʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Bãrã djaba tẽãbema sid̶a maʌ̃ ẽberãmaa isabe eded̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Mʌ̃a quĩrĩã b̶ʌa Ãcõrẽ ne jũma poya obariba bãrãra quĩrã djuburiaida maʌ̃ ẽberãba bãrã djaba jãma preso b̶ʌra, Benjamiʌ̃ sid̶a idu jẽda zebimãrẽã. Baribʌrʌ idu zebiẽ́bʌrʌ mʌ̃ra warra neẽ́ b̶eya. Mãwã warra neẽ́ b̶eibʌrʌ, mãwã b̶aya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ara maʌ̃da ãdjirãba nebiada ped̶aped̶a Egiptod̶aa wãbʌrʌsid̶aa. Ãdjia parata naẽna edeped̶ad̶a cãyãbara waib̶ʌara edesid̶aa. Benjamiʌ̃ sid̶a edesid̶aa. Jũẽnaped̶a Josemaa wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Joseba Benjamiʌ̃ ãdji ume unusid̶e idji nezocarã boroa jarasia: –Naʌ̃ ẽberãrãra mʌ̃ diguid̶aa ededua. Maʌ̃be pacada beaped̶a ne djudua ãdjirãra nane umatipa mʌ̃ ume ne cod̶i bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ara maʌ̃da dji nezocarã boroba Joseba jarad̶a quĩrãca osia. Dji djabarãra Jose ded̶aa edesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Wãbʌdad̶e Jose djabarãra daupera panʌ bẽrã nãwã jara panasid̶aa: –Naãrã zesid̶ad̶e parata dadji sacod̶e b̶ʌped̶ad̶a carea jãwã idji diguid̶aa edebibʌrʌa. Idjia jaraya dadjia maʌ̃ paratara drʌasid̶ada. Maʌ̃ carea dadjira jidabiya idji nezocarãda b̶ead̶amãrẽã. Dadjirã burro sid̶a jãrĩya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Jose ded̶e ed̶a wãbadad̶e dji nezocarã boro caita wãnaped̶a idji ume bed̶easid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ãdjia nãwã jarasid̶aa: –Dai boro, dairã naãrã ze panasid̶ad̶e wãrã arada trigo nẽdod̶e ze panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Dai jẽda wãsid̶ad̶e ota cãĩnima jũẽsid̶aa. Mama dai saco ewabʌdad̶e trigo nẽdoped̶ad̶a paratada jũma daucha dairã sacoza ed̶a b̶ʌda unusid̶aa. Dairãba adua panʌa caiba maʌ̃ paratara ed̶a b̶ʌsida. Jũma maʌ̃ paratara daiba jẽda enesid̶aa diad̶i carea. Maʌ̃ awara daiba paratara enesid̶aa wayacusa trigo nẽdod̶i carea.– ");
INSERT INTO empNTpo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Dji nezocarã boroba panusia: –Jũmawãyã crĩcharãnadua. Dauperarãnadua. Bãrãba parata diaped̶ad̶ara mʌ̃a edaped̶a mʌ̃ boroa diasia. Bãrãba, bãrã zezaba ĩjã b̶ʌ Ãcõrẽba maʌ̃ paratara bãrã sacod̶e b̶ʌsia.– Maʌ̃be idjia Simeoʌ̃ preso b̶ad̶ada ãdjimaa enesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Eneped̶a ãdjirãra Jose ded̶e ed̶a edesia. Idjia baidoda diasia ãdji jĩrũ sʌgʌd̶amãrẽã. Ãdji burro sid̶a ne cobigasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Mãwã panʌne cawasid̶aa ãdjira Jose ded̶e ne cod̶ida. Jose umatipa zeida jʌ̃ã panʌmisa ãdjia nebia eneped̶ad̶ara edasid̶aa Josea diad̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Jose diguid̶a jũẽnacarea ãdjirãba nebia eneped̶ad̶ara idjía diasid̶aa. Maʌ̃ne wayaad̶eba idji quĩrãpita egode b̶arru copanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Joseba ãdjía iwid̶isia sãwã panʌ cawaya. Maʌ̃ awara iwid̶isia: –Bãrã zezara ¿bia b̶ʌca? ¿Drõãra wad̶i b̶ʌca?– ");
INSERT INTO empNTpo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ãdjirãba panusid̶aa: –Dairã zeza bʌ nezocara bia b̶ʌa. Idjira wad̶i b̶ʌa.– Maʌ̃ne wayaad̶eba ãdjira b̶arru copanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Joseba acʌbʌrʌd̶e idji djaba ara Benjamiʌ̃da unuped̶a nãwã jarasia: –Bãrã djaba tẽãbema mʌ̃́a jaraped̶ad̶ara ¿naʌ̃gʌca?– Maʌ̃be Benjamiʌ̃a jarasia: –Mʌ̃ warra, Ãcõrẽba bʌra carebaya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Idji djaba arada ununa bẽrã Josera b̶ʌsrid̶aba so borequeasia. Ara maʌ̃da dji ed̶aara b̶ʌ dejãne idub̶a jĩãne wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Jĩã b̶aped̶a so zaread̶acarea quĩrã sʌgʌped̶a waya ãdjimaa zesia. Maʌ̃be jarasia: –Daiba cod̶ira enenadua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ara maʌ̃da dji nezocarãba enesid̶aa. Joseba coira awara b̶ʌsid̶aa, dji djabarãba cod̶i sid̶a awara b̶ʌsid̶aa, idjab̶a Josema ne cobada egiptorãba cod̶i sid̶a awara b̶ʌsid̶aa. Mãwã osid̶aa egiptorãra hebreorã ume ãbaa ne cocara panʌ bẽrã. Egiptorãmaarã maʌ̃ra cadjiruaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Maʌ̃ne Joseba idji djabarãra chũmebisia dji nabemaneba ab̶a dji tẽãbemanaa. Maʌ̃ carea idji djabarãba cawa crĩchad̶aẽ́ panʌba ab̶arica dji quĩrã acʌ duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Maʌ̃ne Jose itea diaped̶ad̶a djicod̶ebemada ãdjiza jed̶ecabisia, baribʌrʌ Benjamiʌ̃a waib̶ʌara diabisia. Mãwã jed̶ecad̶aped̶a ãdjira Jose ume b̶ʌsrid̶a ne codruasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Mãwãnacarea Joseba idji nezocarã boroa jarasia: –Naʌ̃ ẽberãrã sacora trigoba biracuadua. Ãdji parata sid̶a ãdji sacoza ed̶a b̶ʌcuadua. ");
INSERT INTO empNTpo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Maʌ̃be mʌ̃ taza parata od̶ada dji tẽãbema sacod̶e trigo nẽdod̶a parata ume b̶ʌdua.– Ara maʌ̃da dji nezocarã boroba Joseba jarad̶a quĩrãca osia. ");
INSERT INTO empNTpo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Nurẽma ãsabod̶od̶e Jose djabarãra ãdji burrod̶e idu wãbisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ãdjira purud̶eba wad̶i tʌmʌ wãẽ́ panʌne Joseba idji nezocarã boroa jarasia: –Jãʌ̃ ẽberãrã caid̶u wãdua. Jidad̶e wãsira nãwã jaradua: “¿Cãrẽneba mʌ̃ boroba bãrãra biẽ́ od̶a bẽrã bãrãba jãwã idjira biẽ́ osid̶a? ¿Cãrẽ cãrẽã bãrãba idji taza parata od̶ara drʌasid̶a? ");
INSERT INTO empNTpo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Jãʌ̃ tazad̶e mʌ̃ borora ne dobaria. Idjab̶a ab̶ari tazad̶eba ne cawaiẽ́ b̶eara cawabaria. Bãrãba oped̶ad̶ara biẽ́ b̶ʌa.”– ");
INSERT INTO empNTpo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ara maʌ̃da caid̶u wãsia. Jidad̶e wãped̶a Joseba jarabid̶ara jarasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Maʌ̃ne dji djabarãba jarasid̶aa: –¿Cãrẽ cãrẽã dadji boroba mãwã jara b̶ʌ? Dairãra ne drʌad̶acaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Acʌdua, parata dai sacod̶e b̶ad̶ada daiba ununaped̶a Canaaʌ̃ druad̶eba jẽda enesid̶aa. Mãwã daiba jipa osid̶abʌrʌ ¿cãrẽ cãrẽã bʌ boro paratara wa oro sid̶a drʌad̶i? ");
INSERT INTO empNTpo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Bʌa maʌ̃ tazada dairã sacod̶e unuibʌrʌ dji erob̶ʌra beuida b̶ʌa. Maʌ̃ awara dairãra bʌ boro nezocarãda b̶ead̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Maʌ̃ne Jose nezocarã boroba jarasia: –Bia b̶ʌa, mãẽteara bãrãba jara panʌ quĩrãca oya. Dji ne drʌad̶ara mʌ̃ nezoca baya, baribʌrʌ waabemara bed̶ea neẽ́ b̶ead̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ara maʌ̃da ãdji sacora burrod̶e jʌ̃ b̶eada ẽrãnaped̶a egode b̶ʌsid̶aa. Maʌ̃be ãdjiza ewacuasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ewacuaped̶ad̶acarea Jose nezocarã boroba jʌrʌ wãsia dji nabema djaba sacod̶eba ab̶a dji tẽãbema sacod̶aa. Maʌ̃ne tazara dji tẽãbema Benjamiʌ̃ sacod̶e unusia. ");
INSERT INTO empNTpo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ara maʌ̃da sopuad̶eba dji djabarãba cacuad̶e jʌ̃ panʌra cũẽtacuasid̶aa. Maʌ̃be ãdji sacora wayacusa ãdji burrod̶e b̶ʌcuad̶aped̶a jẽda purud̶aa wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Jose wad̶i diguid̶a b̶ʌd̶e Judara dji djabarã sid̶a idjima jũẽsid̶aa. Ãdjirãra ne wayaad̶eba idji quĩrãpita egode b̶arru copanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Maʌ̃be Joseba ãdjirãa jarasia: –Bãrãba ¿cãrẽ cãrẽã mʌ̃ tazara jãwã drʌasid̶a? ¿Bãrãba adua panʌca ne cawaiẽ́ b̶eada mʌ̃a cawabarida?– ");
INSERT INTO empNTpo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judaba panusia: –Dai boro, ¿cãrẽda jarad̶i? ¿Sãwã jarad̶i daira bed̶ead̶e panʌẽ́da? Jũma daiba biẽ́ oped̶ad̶a carea Ãcõrẽba cawa obʌrʌa. Dairãra bʌ jʌwaed̶a panʌa. Bʌ nezocarã bad̶ia, idjab̶a bʌ taza drʌa erob̶ad̶a sid̶a bʌ nezoca baya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Maʌ̃ne Joseba jarasia: –Mʌ̃a mãwã oẽ́a. Dji taza drʌa erob̶ad̶adrʌ mʌ̃ nezoca baya. Waabemara necai wãnadua bãrã zezamaa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Maʌ̃be Judara Jose caita wãped̶a jarasia: –Mʌ̃ boro, mʌ̃ ume quĩrũrãdua. Bʌra Egiptod̶ebema boro quĩrãca b̶ʌmĩna mʌ̃ quĩrã djuburia bʌ ume idu bed̶eabidua. ");
INSERT INTO empNTpo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Dai naãrã zesid̶ad̶e bʌa iwid̶isia daira zeza bara panʌ cawaya idjab̶a djaba bara panʌ cawaya. ");
INSERT INTO empNTpo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Maʌ̃ne daiba panusid̶aa zeza drõã quiruda eropanʌda idjab̶a djaba cũdra b̶ʌda ab̶a eropanʌda. Maʌ̃ warrara dai zezaba drõã b̶ʌd̶e unusia. Idji djaba arada beusia. Ãdji papad̶ebemara ab̶abe idjidrʌ b̶ʌa. Idjira dai zezaba bio quĩrĩã b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Idjab̶a bʌa daia jarasia, “Maʌ̃ warrara enenadua mʌ̃a unui carea.” ");
INSERT INTO empNTpo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Baribʌrʌ daiba bʌ́a jarasid̶aa maʌ̃ warrara dji zeza b̶ʌmaʌba ãyã wãcara b̶ʌda. Ãyã wãibʌrʌ dji zezara sopuaba beuyad̶a asid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Maʌ̃ne bʌa daia jarasia: “Bãrã djaba tẽãbemada bãrã ume zeẽ́bʌrʌ, bãrãra mʌ̃maa wayacusa zecara panʌda.” ");
INSERT INTO empNTpo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Maʌ̃be dairãra dai zezama jũẽnaped̶a bʌa jarad̶ara jũma nẽbʌrʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Dãrãbʌrʌd̶e dai zezaba jarasia: “Waya trigo nẽdod̶e wãnadua.” ");
INSERT INTO empNTpo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Maʌ̃ne dairãba idjía jarasid̶aa: “Dairãra poya wãnaẽ́a. Ab̶abe dai djaba tẽãbemada dai ume wãibʌrʌ wãnia. Idjida dai ume wãẽ́bʌrʌ, jãʌ̃ ẽberãmaa wãcara panʌa.” ");
INSERT INTO empNTpo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Maʌ̃ne mʌ̃ zeza bʌ nezocaba daia jarasia: “Bãrãba cawa panʌa mʌ̃ wẽrãba warra umébe mʌ̃́a to diasida. ");
INSERT INTO empNTpo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ab̶ara nẽbasia. Maʌ̃ ewarid̶eba ʌ̃taa waa unuẽ́ b̶ʌ bẽrã mʌ̃maarã animarãba beaped̶a cobuesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Maʌ̃ bẽrã idji djaba arada eded̶aped̶a beuibʌrʌ, bãrãba mʌ̃ra sopuaba bead̶ia.” ");
INSERT INTO empNTpo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Dairã boro, dji cũdra carea dai zezara wad̶i b̶ʌa. Maʌ̃ bẽrã mʌ̃ra dji cũdra neẽ́ mʌ̃ zezamaa wãsira maʌ̃ne idji warrada unuẽ́bʌrʌ mʌ̃ zezara beuya. Mãwã dai bʌ nezocarãba dai zeza drõã b̶ʌra sopuaba bead̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Mʌ̃ bʌ nezocaba mʌ̃ zezaa wãrãneba jarasia dji cũdrara waya eneida. Mʌ̃a jarasia: “Zeza, mʌ̃a waya bʌmaa eneẽ́bʌrʌ, bʌ quĩrãpita mʌ̃ra bed̶ead̶e b̶aya ab̶a mʌ̃ beubʌrʌd̶aa.” ");
INSERT INTO empNTpo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Maʌ̃ bẽrã mʌ̃a bʌ́a bed̶ea djuburiaya dji cũdrabari mʌ̃drʌ nama erob̶emãrẽã bʌ nezoca bai carea. Maʌ̃ne dji cũdrara idji djabarã ume idu wãbidua. ");
INSERT INTO empNTpo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","¿Sãwã mʌ̃da dji cũdra neẽ́ mʌ̃ zezamaa wãi? Mʌ̃ zeza sopuaba biẽ́ b̶ʌda unu quĩrĩãẽ́ b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","2","Maʌ̃ bed̶ea ũrĩbʌrʌd̶e Josera so borequea nũmesia. Waa poya droaẽ́ bẽrã jũma idji nezocarã arima b̶eaa jĩgua jarasia: –¡Jũma dajadaa wãnadua!– Ara maʌ̃da wãsid̶aa. Ab̶abe idji djabarãda idji ume panesid̶aa. Mãwã panʌne Josera bio jĩãsia. Maʌ̃ jĩãbira idji nezocarã dajada panʌba ũrĩsid̶aa. Maʌ̃ awara idji jĩãnanebemada Egiptod̶ebema boro ded̶e panabadarãba ũrĩsid̶aa. Jĩãnacarea Joseba idji djabarãa cawabisia idjida mãwã b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Nãwã jarasia: –Mʌ̃ra Josea. ¿Mʌ̃ zezara wad̶i b̶ʌca?– Maʌ̃ne idji djabarãba poya panunaẽ́ basía bio dauperasid̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Maʌ̃ carea Joseba ãdjía jarasia: –Mʌ̃ caita zed̶adua.– Ara maʌ̃da Jose caita wãsid̶aa. Maʌ̃ne Joseba ãdjía jarasia: –Mʌ̃ra bãrã djaba Josea, bãrãba nẽdobueped̶ad̶aa Egiptod̶aa eded̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Baribʌrʌ sopuarãnadua. Bãrãba mʌ̃ra nẽdobueped̶ad̶amĩna jũmawãyã crĩcharãnadua. Ãcõrẽbʌrʌ mʌ̃ra nama bãrã na diabuesia ẽberãrã beud̶id̶ebemada ẽdrʌ edamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Poa umé babʌrʌa jarraba zed̶ada. Idjab̶a wad̶i poa juesuma mãwã b̶aya. Maʌ̃ne poya ne ud̶aẽ́a ni ewad̶aẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ãcõrẽba mʌ̃ra bãrã na diabuesia bãrã ẽberãrã naʌ̃ ẽjũãne jũma beurãnamãrẽã. Mʌ̃ra nama b̶ʌsia bãrãra beud̶id̶ebemada ẽdrʌ edamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Bãrãba mʌ̃ra namaa diabued̶aẽ́ basía, ãtebʌrʌ Ãcõrẽbʌrʌ mʌ̃ra diabuesia. Idjiabʌrʌ mʌ̃ra b̶ʌsia Egiptod̶ebema boroa crĩcha diabarida b̶amãrẽã, idji ded̶ebema boroda b̶amãrẽã, idjab̶a Egipto druad̶e dji dromada b̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Jãʌ̃be bãrãra isabe wãnadua mʌ̃ zezamaa. Idjía nãwã jarad̶adua: “Bʌ warra Joseba nãwã jara b̶ʌa: Ãcõrẽba mʌ̃ra Egiptod̶ebema boroare b̶ʌsia. Mʌ̃maa isabe zedua. Dãrãrãdua. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Zeped̶a Goseʌ̃ ẽjũãne b̶eya. Mãwã bʌra, bʌ warrarã sid̶a, bʌ wiuzaquerã sid̶a mʌ̃ caita duanania. Bʌ animarã b̶eara, jũma bʌa erob̶ʌ sid̶a enedua. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Mʌ̃a bʌra mama ne cobi b̶aya, wad̶i poa juesuma jarrabara b̶ai bẽrã. Mãwã bʌra, bʌ ẽberãrãra, bʌ animarã sid̶a jarrababa beud̶aẽ́a.” ");
INSERT INTO empNTpo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Bãrãba, mʌ̃ djaba Benjamiʌ̃ bid̶a bãdji dauba unu panʌa wãrãda mʌ̃da bãrã ume mãwã bed̶ea b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mʌ̃ zezaa jarad̶adua mʌ̃ra naʌ̃ Egipto druad̶e dji dromada. Bãrãba unuped̶ad̶a sid̶a jũma mʌ̃ zezaa jarad̶adua. Isabe wãnaped̶a mʌ̃ zezara namaa enenadua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Maʌ̃be idji djaba Benjamiʌ̃ ume ojũẽnaped̶a jĩãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Mãwãnacarea Joseba waabema djabarãra uridarrad̶e isõcuaped̶a jĩãsia. Maʌ̃bebʌrʌ idji djabarãra idji ume bed̶easid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Egiptod̶ebema boro ded̶e panabadaba ũrĩsid̶aa Jose djabarãra zesid̶ada. Dji boroba, dji droma b̶ea bid̶a maʌ̃nebemada bia crĩchasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Maʌ̃ carea dji boroba Josea jarasia: –Bʌ djabarãa jaradua: “Bãrã animarã ʌ̃rʌ̃ ne ataubid̶aped̶a Canaaʌ̃ druad̶aa wãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Maʌ̃be bãrã zezara, bãrã ẽberãrã sid̶a mʌ̃maa enenadua. Mʌ̃a bãrãa Egipto druad̶e ẽjũã biara b̶ʌda diaya. Bãrãba naʌ̃ druad̶ebema dji biara b̶ʌda cod̶ia.” ");
INSERT INTO empNTpo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Idjab̶a bʌ djabarãa jaradua nama Egiptod̶eba carretada edecuad̶amãrẽã ãdji warrarã, ãdji wẽrãrã, bãrã zeza sid̶a enenamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Maʌ̃ awara jaradua ãdjia erob̶eara b̶ecuad̶amãrẽã, Egiptod̶ebema ne biara b̶ʌda jũma ãdjid̶e b̶ai bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Israel warrarãba mãwã osid̶aa. Egiptod̶ebema boroba jarad̶a quĩrãca Joseba ãdjía carretara diacuasia. Ãdjia od̶e cod̶i sid̶a diasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ãdjiza cacuad̶e jʌ̃bada djiwid̶ida ab̶a ab̶a diacuasia. Baribʌrʌ Benjamiʌ̃a cacuad̶e jʌ̃badada juesuma diasia. Parata torro sid̶a tresciento diasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Idji zeza itea Egiptod̶ebema ne bia qued̶eada die burrod̶e diabuesia. Maʌ̃ awara die burro wẽrãne trigoda, paʌ̃da, idji zebʌrʌd̶e coi sid̶a diabuesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Maʌ̃be idji djabarãra wãbigasia. Ãdji wãbʌdad̶e Joseba ãdjía jarasia: –Od̶e ijararãnadua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Maʌ̃be Egiptod̶eba wãnaped̶a Canaaʌ̃ druad̶e ãdji zeza Jacoboma jũẽsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Jũẽnaped̶a ãdjia Jacoboa jarasid̶aa Josera wad̶i zocai b̶ʌda idjab̶a idjira Egiptod̶ebema boroare b̶ʌda. Baribʌrʌ Jacoboba cawa crĩchaẽ́ basía. Maʌ̃gʌra ĩjãẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Maʌ̃ne ãdjirãba Joseba jarad̶ara jũma nẽbʌrʌsid̶aa. Maʌ̃ awara Jacoboba unusia Joseba carreta diabuecuad̶ada idji eded̶amãrẽã. Maʌ̃ unubʌrʌd̶e Jacobora sobiasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Jacobo Israel abadaba jarasia: –Ara naʌ̃ba bia b̶ʌa. Mʌ̃ warra Josera wãrãda wad̶i zocai b̶ʌa. Mʌ̃ beui naẽna idji acʌd̶e wãya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ara maʌ̃da Jacobo Israel abadara wãsia jũma idjia erob̶ʌ bara. Wãbʌrʌd̶e Beersebád̶e jũẽsia. Mama idjia animarãda idji zeza Isaba ĩjã b̶ad̶a Ãcõrẽa babue diacuasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Maʌ̃ diamasi Israelba cãĩmocara quĩrãca ũrĩsia Ãcõrẽra idji ume bed̶ea b̶ʌda. Ãcõrẽba trʌ̃ jarasia: –Jacobo, Jacobo.– Jacoboba panusia: –Mʌ̃ra nama b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ãcõrẽba jarasia: –Mʌ̃ra bʌ zezaba ĩjã b̶ad̶a Ãcõrẽa. Wayarãdua Egiptod̶aa wãi carea. Jãma mʌ̃a puru waib̶ʌada bʌd̶eba yõbiya. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mʌ̃ra bʌ ume Egiptod̶aa wãya. Maʌ̃be bʌd̶eba yõbʌdarãra jẽda eneya. Idjab̶a bʌ beubʌrʌd̶e Josera arima b̶aya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ara maʌ̃da Jacobora Beersebád̶eba wãsia. Egiptod̶ebema boroba carreta diabuecuad̶ad̶e Jacobo warrarãba idjira, ãdji warrarãra, ãdji quimarã sid̶a edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Jacoboba idji warrarã bid̶a ãdji animarã b̶eara idjab̶a jũma ãdjia Canaaʌ̃ druad̶e edaped̶ad̶a sid̶a Egiptod̶aa edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Jacoboba idji warrarãra, idji caurãra, idji wiuzaquerãra, idji ãĩzaquerã sid̶a Egiptod̶aa jũma edesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Jacobo Israel abada warrarã Egiptod̶aa wãped̶ad̶ara naʌ̃gʌrã basía: Jacobo warra iwina Rubeʌ̃da wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubeʌ̃ba edesia idji warrarã Hanoc, Palú, Hezroʌ̃, Carmi sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Jacobo warra Simeoʌ̃ sid̶a wãsia. Simeoʌ̃ba edesia idji warrarã Jemuel, Jamiʌ̃, Ohad, Jaquiʌ̃, Zohar, Saul sid̶a. Saulora cananeo wẽrãba tod̶a basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Jacobo warra Levi sid̶a wãsia. Leviba edesia idji warrarã Gersoʌ̃, Coá, Merari sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Jacobo warra Juda sid̶a wãsia. Judaba edesia idji warrarã Sela, Paré, Zará sid̶a. Idji warrarã Erera, Onaʌ̃ sid̶a Canaaʌ̃ druad̶e beusid̶aa. Paréba idji warrarã Hezroʌ̃da, Hamul sid̶a edesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Jacobo warra Isacar sid̶a wãsia. Isacarba idji warrarã Tola, Puvá, Job, Simroʌ̃ sid̶a edesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Jacobo warra Zabuloʌ̃ sid̶a wãsia. Zabuloʌ̃ba idji warrarã Sered, Eloʌ̃, Jahleel sid̶a edesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Maʌ̃ warrarã sei panʌra Leaba Jacoboa Araʌ̃ druad̶e to diasia. Leaba Jacobo cau Dina sid̶a tosia. Ãdjid̶eba yõped̶ad̶ara 33 wãsid̶aa dji umaquĩrãrã, dji wẽrãrã ãbaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","18","Jacoboba Lea edasid̶e dji zãwãrẽ Labaʌ̃ba nezocawẽrã Zilpara Leaa diasia. Zilpaba warrarãda Jacoboa to diasia. Maʌ̃gʌrã sid̶a Egiptod̶aa wãsid̶aa ãdji warrarã bara. Jũma ãbaa diecisei wãsid̶aa. Ãdji warra Gaba idji warrarã Zipioʌ̃, Hagui, Ezboʌ̃, Suni, Eri, Arodi, Areli sid̶a edesia. Ãdji warra Aserba edesia idji warrarã Imna, Isúa, Isúi, Beria, dji cau Será sid̶a. Beria warrarãra Hebere idjab̶a Malquiel basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jacobo quima Raquel warrarãra Jose idjab̶a Benjamiʌ̃ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Jose warrarã Egiptod̶e toped̶ad̶ara Manase idjab̶a Epraiʌ̃ basía. Ãdji papara Asena basía. Asena zezara Potipera basía. Idjira Oʌ̃ purud̶e ʌ̃mãdaúa bia bed̶eabadarã sacerdote basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamiʌ̃ warrarãra naʌ̃gʌrã basía: Bela, Bequer, Asbel, Gera, Naamaʌ̃, Ehi, Ros, Mupiʌ̃, Hupiʌ̃, idjab̶a Ard. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Jũma maʌ̃gʌrãra Raqueld̶eba Jacobo ume yõsid̶aa. Jũma ãbaa catorce wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","25","Jacoboba Raquel edasid̶e dji zãwãrẽ Labaʌ̃ba nezocawẽrã Bilhara Raquelea diasia. Bilhaba warrarãda Jacoboa to diasia. Maʌ̃gʌrã sid̶a Egiptod̶aa wãsid̶aa ãdji warrarã bara. Ãdji warra Daʌ̃ba idji warra Husiʌ̃ edesia. Ãdji warra Neptaliba edesia idji warrarã Jahzeel, Guni, Jezer, Sileʌ̃ sid̶a. Jũma ãbaa siete wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Jũma Jacobod̶eba yõped̶ad̶arãra idji ume Egiptod̶aa wãsid̶aa. Idji ãĩgurã juachaẽ́, jũma ãbaa 66 wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Maʌ̃gʌ awara Jose warrarã Egiptod̶e toped̶ad̶ada umé panasid̶aa. Jũma ãbaa Jacobo ẽberãrã Egiptod̶e jũẽped̶ad̶ara setenta panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacobo Israel abadaba Judada Josemaa na wãbisia ãdjira Goseʌ̃ ẽjũãne acʌd̶e zemãrẽã. Maʌ̃misa ãdjirãra Goseʌ̃ ẽjũãne jũẽsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Ãdji jũẽsid̶ad̶e Joseba idji nezocaa jarasia idji carreta enemãrẽã. Ara maʌ̃da Goseʌ̃naa idji zeza Israel audiab̶arid̶e wãsia. Idji zeza unusid̶e ojũẽped̶a dãrã jĩãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Mãwã b̶ʌd̶e Israelba Josea jarasia: –Mʌ̃a bʌ quĩrãra unubʌrʌ bẽrã cawa b̶ʌa bʌra wad̶i zocai b̶ʌda. Jãʌ̃be mʌ̃ra necai beuya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Maʌ̃be Joseba idji djabarãa, jũma idji zeza ẽberãrãa bid̶a jarasia: –Egiptod̶ebema boromaa mʌ̃a jarad̶e wãya bãrãra jũẽsid̶ada. Mʌ̃a idjía jaraya: “Mʌ̃ djabarãra, mʌ̃ zeza ẽberãrã Canaaʌ̃ druad̶e duananara jũma mʌ̃maa zesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ãdjirãra animarã wagabada bẽrã ãdji ovejada, paca sid̶a enesid̶aa. Jũma ãdjirãba erob̶ea sid̶a enesid̶aa.” ");
INSERT INTO empNTpo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","34","Maʌ̃be dji boroba bãrã trʌ̃ped̶a iwid̶ibʌrʌd̶e “¿Bãrãba cãrẽda obada?”, nãwã jarad̶adua: “Daira warra ed̶aʌba animarã daupẽ cawa b̶eaa, dai drõã naẽnabemarãba obadaped̶ad̶a quĩrãca.” Mãwã jarasid̶ara dji boroba bãrãra jĩga Goseʌ̃ ẽjũãne idu b̶ebiya, egiptorãmaarã oveja wagabadara dji biaẽ́ bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ara maʌ̃da Josera Egiptod̶ebema boro ume bed̶ead̶e wãsia. Idjia jarasia: –Mʌ̃ zezara, mʌ̃ djabarã sid̶a Canaaʌ̃ druad̶eba zesid̶aa ãdji oveja bara, ãdji paca bara, jũma ãdjia eropanʌ bara. Ãdjirãra Goseʌ̃ ẽjũãne duanʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Maʌ̃be Joseba idji djabarãda juesuma Egiptod̶ebema boro quĩrãpita edesia ãdjira cawamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Maʌ̃ne dji boroba Jose djabarãa iwid̶isia: –Bãrãba ¿cãrẽda obada?– Ãdjirãba panusid̶aa: –Dairãra oveja wagabadaa dai drõã naẽnabemarãba obadaped̶ad̶a quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Maʌ̃ awara jarasid̶aa: –Canaaʌ̃ druad̶e jarrabara dji cãbãyã b̶ʌa. Idjab̶a dairã oveja itea põãjãrã neẽ́a. Maʌ̃ bẽrã dairãra naʌ̃ druad̶e panane zesid̶aa. Dairãra bʌ nezocarãa. Dai quĩrã djuburia Goseʌ̃ ẽjũãne idu b̶ebidua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","6","Maʌ̃ne Egiptod̶ebema boroba Josea jarasia: –Naʌ̃ Egipto druara bʌ jʌwaed̶a b̶ʌa. Bʌ zezara, bʌ djabarã sid̶a ze panʌ bẽrã ãdjía Goseʌ̃ ẽjũãda diadua. Mãwã dji biara b̶ʌ ẽjũãne duanania. Idjab̶a ʌ̃cʌrʌ bʌ djabarãnebemaba animarãda bio daupẽ cawa b̶eabʌrʌ, ãdjirãra mʌ̃ animarã wagabada bororãda b̶ʌcuadua.– ");
INSERT INTO empNTpo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Idjab̶a Joseba idji zeza Jacobora Egiptod̶ebema boromaa edesia cawamãrẽã. Maʌ̃ne Jacoboba dji boroa bia jarasia. ");
INSERT INTO empNTpo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Dji boroba Jacoboa iwid̶isia: –Bʌra ¿poa jũmasãwã b̶ʌ?– ");
INSERT INTO empNTpo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacoboba panusia: –Mʌ̃ra ciento treinta poa b̶ʌa. Naʌ̃ ẽjũãne pʌrrʌa b̶ʌd̶e bio bia mĩga b̶ʌa. Mʌ̃ drõãenabemarã jaid̶asid̶ad̶e mʌ̃ cãyãbara drõãara panasid̶aa. Mʌ̃ra ãdjirã quĩrãca jãcua dãrã b̶aẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Maʌ̃be Jacoboba Egiptod̶ebema boroa wayacusa bia jaraped̶a dajadaa wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ara maʌ̃da dji boroba jarad̶a quĩrãca Joseba idji zezaa, idji djabarãa bid̶a Egiptod̶ebema ẽjũã biara b̶ʌda diasia. Nocoarebema ewarid̶e maʌ̃ ẽjũãne Ramese puruda osid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Idjab̶a Joseba idji zezaa, idji djabarãa, jũma ãdji ẽberãrãa bid̶a cod̶ira dia b̶abadjia ãdjia cobada quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Druaza cod̶ira neẽ́ b̶asia. Ab̶ed̶a jarrabara zareara nũmʌ bẽrã ẽberãrãra Egiptod̶e, Canaaʌ̃ druad̶e bid̶a jarrababa quinibod̶o basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Maʌ̃ carea jũma egiptorãra, Canaaʌ̃nebemarã sid̶a Josemaa trigo nẽdod̶e wãbadjid̶aa. Joseba dji paratara jũma peped̶a Egiptod̶ebema boro ded̶e wagabadjia. ");
INSERT INTO empNTpo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Mãwã panʌne egiptorã paratara, Canaaʌ̃nebemarãne sid̶a jõsia. Maʌ̃ bẽrã egiptorãra wayacusa Josemaa zed̶aped̶a nãwã jarasid̶aa: –Dairã paratara jõsia. Dairãa trigora diadua. Diaẽ́bʌrʌ dairãra beud̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Joseba panusia: –Bãrã paratara jõsibʌrʌ, bãrã animarãda enenadua. Maʌ̃bari mʌ̃a bãrãa trigora diaya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ara maʌ̃da ãdji animarãra Josemaa enesid̶aa. Jũma maʌ̃ poad̶e Joseba ãdjirãa trigora diasia ãdji cawayobari, ovejabari, chiwatubari, pacabari, burrobari bid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Maʌ̃ poa jõnacarea wayacusa Josemaa zed̶aped̶a nãwã jarasid̶aa: –Dairã boro, bʌa cawa b̶ʌa dai paratara jõsida, dai animarã sid̶a jũma bʌre basida. Dewara diad̶ida waa neẽ́ panʌa. Ab̶abe dairãdrʌ, dai ẽjũã sid̶a b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Dairãra idu beubirãdua. Iduaribirãdua dai ẽjũãra idub̶a tab̶eida. Dairãda, dai ẽjũã sid̶a trigobari nẽdodua. Mãwã dairãra, dai ẽjũã sid̶a Egiptod̶ebema borod̶e baya. Trigoda dairãa diadua ud̶i carea. Mãwã beud̶aẽ́a idjab̶a dai ẽjũã sid̶a idub̶a tab̶eẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ara maʌ̃da Joseba egiptorã ẽjũãra jũma nẽdosia Egiptod̶ebema boro itea. Egiptorãba ãdji ẽjũãra nẽdobuesid̶aa jarrabara ãdjirãma wetara nũmʌ bẽrã. Mãwã ãdji ẽjũãra jũma dji borod̶e basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Maʌ̃ne jũma Egiptod̶ebema ẽberãrãra dji boro nezocarã basid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Joseba ab̶abe ʌ̃mãdaúa bia bed̶eabada sacerdoterã ẽjũãdrʌ nẽdoẽ́ basía, Egiptod̶ebema boroba ãdjirã cod̶ira diabadji bẽrã. Ãdjirãba maʌ̃gʌda cobadjid̶a bẽrã ãdji ẽjũãra nẽdobued̶aẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Maʌ̃be Joseba ẽberãrãa jarasia: –Mʌ̃a bãrãra, bãrã ẽjũã sid̶a dadjirã boro itea nẽdod̶a bẽrã mʌ̃a trigoda diaya ud̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Maʌ̃ ewabʌdad̶e ẽ juesumanebemada ab̶a dadjirã boroa diad̶ida panʌa. Ẽ quĩmãrẽ bãrãba edad̶ia wayacusa ud̶i carea idjab̶a bãrãba, bãrã ded̶e panabadaba, bãrã warrarã bid̶a cod̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Maʌ̃ne ãdjirãba panusid̶aa: –Bʌa dairãra zocai b̶ʌsia. Dairãra quĩrã djuburia b̶ʌa. Maʌ̃ bẽrã dairãra Egiptod̶ebema boro nezocarã bad̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ara maʌ̃da Joseba leyda b̶ʌsia egiptorãba ewabʌdad̶e ẽ juesumanebemada ab̶a Egiptod̶ebema boroa diad̶ida panʌda. Wad̶ibid̶a Egipto druad̶e mãwã obadaa. Ab̶abe ʌ̃mãdaúa bia bed̶eabada sacerdoterãba mãwã diad̶acaa, Egiptod̶ebema boroba ãdji ẽjũãra nẽdod̶aẽ́ bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Maʌ̃ ewarid̶e Jose ẽberãrã israelerã abadara Egipto druad̶e duanesid̶aa. Goseʌ̃ ẽjũãra eropanesid̶aa. Ãdjirãra zocãrã yõsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jose zeza Jacobora Egipto druad̶e diecisiete poa b̶asia. Maʌ̃ne Jacobora 147 poa b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Jacobo Israel abadaba cawasia dãrãẽ́ne idjira beuida. Maʌ̃ bẽrã idji warra Joseda trʌ̃biped̶a jarasia: –Mʌ̃ quĩrã djuburia bʌ jʌwara mʌ̃ b̶acara edre b̶ʌped̶a wãrãneba jaradua mʌ̃a jarabʌrʌda quĩrĩãneba bʌa jũma oida. Mʌ̃ra naʌ̃ Egiptod̶e tʌb̶arirãdua. ");
INSERT INTO empNTpo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ãtebʌrʌ naʌ̃ Egiptod̶eba mʌ̃ drõãenabemarã tʌb̶ariped̶ad̶amaa edeped̶a mʌ̃ra mama tʌb̶aridua.– Joseba panusia: –Mãwã oya, zeza.– ");
INSERT INTO empNTpo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Maʌ̃ne Jacoboba jarasia: –Mʌ̃́a wãrãneba jaradua.– Ara maʌ̃da Joseba wãrãneba jarasia. Maʌ̃ bẽrã Jacobo Israel abadara idji cʌd̶ad̶e chĩrãborod̶e b̶arru cob̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Mãwãnacarea Jose ẽberãrãba idjía jarasid̶aa idji zezara cacua biẽ́ b̶ʌda. Maʌ̃ carea Joseba idji warrarã Manase, Epraiʌ̃ sid̶a idji zeza acʌd̶e edesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Maʌ̃ne Jacoboa jarasid̶aa Josera zesida. Maʌ̃ carea Jacobo Israel abadara ʌb̶ʌaẽ́ b̶ʌmĩna idji cʌd̶ad̶e ʌ̃ta chũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Maʌ̃ne Josea jarasia: –Canaaʌ̃ druad̶e mʌ̃ Luz purud̶e b̶asid̶e ne jũma poya b̶ʌ Ãcõrẽra mʌ̃ma odjaped̶a mʌ̃ra nãwã bia jara b̶ʌsia: ");
INSERT INTO empNTpo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","“Mʌ̃a bʌd̶eba ẽberãrã zocãrã yõbiya. Idjab̶a bʌd̶eba puruda zocãrã yõbiya. Maʌ̃ awara mʌ̃a bʌ ẽberãrãa naʌ̃ Canaaʌ̃ druara diaya ewariza ãdjid̶e bamãrẽã.” ");
INSERT INTO empNTpo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Mʌ̃ bʌmaa zei naẽna bʌ warrarã Epraiʌ̃ra, Manase sid̶a naʌ̃ Egiptod̶e tosid̶aa. Ãdjira Rubeʌ̃ quĩrãca idjab̶a Simeoʌ̃ quĩrãca mʌ̃ warrarã araad̶a aya. ");
INSERT INTO empNTpo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Baribʌrʌ bʌa dewara warrarãda unuibʌrʌ, ãdjirãra mʌ̃ warrarã araad̶a aẽ́a. Maʌ̃ bẽrã Canaaʌ̃ druad̶e mʌ̃ warrarã araba ẽjũã edabʌda quĩrãca ãdjirãba edad̶aẽ́a. Ãtebʌrʌ Epraiʌ̃ba, Manase bid̶a edabʌda ẽjũãnebemada ãdjia edad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Mʌ̃ Padan-Araʌ̃ druad̶eba zebʌrʌd̶e bʌ papa Raquelera Canaaʌ̃ druad̶e jaid̶asia Eprata Beleʌ̃ abada caita. Mama mʌ̃a idjira tʌb̶arisia. Mʌ̃ra idji carea bio sopua b̶asia. Maʌ̃ carea mʌ̃a bʌ warra umébemarã mʌ̃reana abʌrʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Jacobo Israel abadaba Jose warrarãra unuped̶a iwid̶isia: –Za panʌra ¿cai?– ");
INSERT INTO empNTpo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseba idji zezaa panusia: –Mʌ̃ warrarãa, Ãcõrẽba mʌ̃́a naʌ̃ Egiptod̶e diad̶aa.– Israelba jarasia: –Mʌ̃ djuburia mʌ̃ caita zebidua ãdjira bia jara b̶ʌi carea.– ");
INSERT INTO empNTpo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israelera drõãda quiru bẽrã dau towa b̶asia. Maʌ̃ne Joseba idji warrarãra idji zeza caitaara edasia. Israelba ãdjira bʌrʌ edaped̶a isõsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israelba Josea jarasia: –Mʌ̃a crĩcha b̶asia bʌ quĩrãra waa unuẽ́da, baribʌrʌ ¡Ãcõrẽba mʌ̃́a bʌra bʌ warrarã sid̶a unubisia!– ");
INSERT INTO empNTpo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Maʌ̃be Joseba idji warrarã idji zeza b̶acarad̶e chũpanʌda ãyã b̶ʌsia. Ãyã b̶ʌped̶a idji zeza quĩrãpita chĩrãborod̶e b̶arru cob̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Joseba idji warrarãra wayacusa idji zeza quĩrãpita caita b̶ʌsia. Epraiʌ̃ra idji jʌwa araare b̶ʌsia idji zeza jʌwa acʌare b̶emãrẽã. Manasera idji jʌwa acʌare b̶ʌsia idji zeza jʌwa araare b̶emãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Baribʌrʌ Israelba idji jʌwara carusia. Epraiʌ̃ra dji tẽãbemamĩna Israelba idji jʌwa arada Epraiʌ̃ boro ʌ̃rʌ̃ b̶ʌsia. Manasera dji iwinamĩna Israelba idji jʌwa acʌda Manase boro ʌ̃rʌ̃ b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Maʌ̃ne Israelba Josera nãwã bia jara b̶ʌsia: Mʌ̃ zezadrõã Abrahaʌ̃ba idjab̶a mʌ̃ zeza Isa bid̶a Ãcõrẽda ĩjã panasid̶aa. Mʌ̃ tosid̶a ewarid̶eba ʌ̃taa ara maʌ̃ Ãcõrẽba mʌ̃ra waga b̶abaria. ");
INSERT INTO empNTpo_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Idjia jũma mʌ̃ bia mĩga b̶ʌd̶ebemada ẽdrʌ edabaria. Maʌ̃gʌ Ãcõrẽba naʌ̃ warrarãra carebaya. Mʌ̃a quĩrĩã b̶ʌa ãdjid̶eba naʌ̃ ẽjũãne zocãrã yõnida. Mãwã naʌ̃ warrarãneba mʌ̃ trʌ̃ra, mʌ̃ zezadrõã Abrahaʌ̃ trʌ̃ra, mʌ̃ zeza Isa trʌ̃ sid̶a jũmarãba quĩrãneba panania. ");
INSERT INTO empNTpo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","18","Joseba unusia idji zeza jʌwa arara dji tẽãbema Epraiʌ̃ boro ʌ̃rʌ̃ b̶ʌda. Maʌ̃ra Joseba biẽ́ unusia. Maʌ̃ carea idji zezaa jarasia: –Zeza, jãwãẽ́a. Za b̶ʌdrʌ mʌ̃ warra iwinaa. Idji boro ʌ̃rʌ̃bʌrʌ bʌ jʌwa arara b̶ʌdua.– Mãwã jarabʌrʌd̶e idji zeza jʌwara Epraiʌ̃ borod̶e b̶ʌda jidaped̶a Manase boro ʌ̃rʌ̃ b̶ʌ quĩrĩã b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Baribʌrʌ idji zezaba mãwã o quĩrĩãẽ́ basía. Ãtebʌrʌ jarasia: –Warra, mʌ̃a cawa b̶ʌa mʌ̃ jʌwara cai ʌ̃rʌ̃ b̶ʌsida. Bʌ warra iwinaneba ẽberãrãda zocãrã yõnia. Idjira dji dromada b̶aya. Baribʌrʌ dji djaba tẽãbemara idji cãyãbara dji dromaara b̶aya. Dji tẽãbema warrarãneba puruda zocãrã yõnia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Maʌ̃ ewarid̶e Israelba Jose warra tẽãbema Epraiʌ̃ra dji nabema Manase cãyãbara dji dromaara b̶ʌsia. Maʌ̃ne ãdjira nãwã bia jara b̶ʌsia: –Nocoarebema ewarid̶e israelerãba bãrã trʌ̃neba nãwã dewaraa bia jarad̶ia: “Ãcõrẽba Epraiʌ̃, Manase sid̶a bia od̶a quĩrãca bʌ sid̶a bia oya.”– ");
INSERT INTO empNTpo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Mãwãped̶a Israelba Josea jarasia: –Dãrãẽ́ne mʌ̃ra beuya. Baribʌrʌ Ãcõrẽra bãrã ume b̶aya. Idjia bãrãra bãdji drõãenabemarã druad̶aa jẽda edeya. ");
INSERT INTO empNTpo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Mʌ̃a bʌ́a ẽjũãra aud̶uara diabʌrʌa bʌ djabarã cãyãbara. Mʌ̃a bʌ́a Siqueʌ̃ eyada diabʌrʌa. Maʌ̃ ẽjũãra mʌ̃a jãrĩsia necoba cha bid̶a amorreorã ume djõ b̶ʌd̶eba.– ");
INSERT INTO empNTpo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","2","Maʌ̃be Jacoboba jũma idji warrarã trʌ̃bigaped̶a jarasia: –Mʌ̃ warrarã, mʌ̃ bed̶ea ũrĩne caita zed̶adua. Mʌ̃a jaraya nocoarebema ewarid̶e bãrãra sãwãnida. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubeʌ̃, bʌra mʌ̃ warra iwinaa. Mʌ̃ drõã bad̶acarea bʌdrʌ naãrã unusia. Mʌ̃ ʌb̶ʌara bʌd̶eba unubi b̶ʌa. Bʌdrʌ biara wayabadaa. Bʌra dji dromaara b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Baribʌrʌ do zebʌrʌd̶e poyad̶aca quĩrãca bʌa ara bʌdji cacuara poyaẽ́ basía. Bʌra mʌ̃ wẽrã ume cãĩsia. Mʌ̃ cʌd̶ad̶e cadjiruada osia. Maʌ̃ carea bʌra bʌ djabarãnebemada dji dromaara b̶aẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeoʌ̃, Levi, bãrãba ab̶ari crĩchada jʌrʌbadaa. Bãrãra bed̶ea ausid̶aa biẽ́ od̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Quĩrũbid̶eba bãrãba ẽberãrãra quenasid̶aa. Bãdji quĩrĩãã paca jĩrũ quẽgura necoba tʌcuasid̶aa. Bãrã ãbaa dji jʌrebʌdad̶e mʌ̃ra ed̶a b̶aẽ́a. Bãrãba crĩcha panʌ quĩrãca mʌ̃a oẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Bãrãra cadrʌa panʌ bẽrã djãrãra jũmawãyã biẽ́ obadaa. Maʌ̃ carea bio biẽ́ panania. Mʌ̃a bãrã ẽberãrãra jũma israelerã tãẽna wãbiya. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, bʌ dji quĩrũrãda bʌ jʌwaed̶a erob̶aya. Bʌ djabarãba wayaad̶eba bʌ quĩrãpita b̶arru copanenaped̶a bia jarad̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda, bʌra imama quĩrãca b̶ʌa. Imamara ne beaped̶a, ne coped̶a jãwũãbaria. Maʌ̃be egode chũmeped̶a ʌ̃nãũbaria. ¿Caiba idjira mĩã sẽi? Ara maʌ̃ quĩrãca bʌa ẽberãrãra poyaped̶a ʌ̃nãũya, dewararãba wayad̶i bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ni ab̶aʌba dji boro bacuru Juda jʌwad̶e b̶ʌra jãrĩnaẽ́a. Idjid̶eba yõbʌdarãba maʌ̃ bacurura ewariza erob̶ead̶ia. Maʌ̃ bacuru djibari zebʌrʌd̶e jũmarãba idji bed̶eara ĩjã o duanania. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Juda ẽberãrãra bio bara panania. Ãdji uvara bio zaui bẽrã ãdji burro zaquera uva jʌ̃carama jʌ̃nia jõnamãrẽã. Uva b̶a sid̶a bio barai bẽrã ãdjirãba quĩrĩã panʌbara ãdji wuara uva b̶ad̶e tãtocasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ãdjirã daura uva b̶a cãyãbara purea pãĩmaara b̶ead̶ia. Ãdjirã quid̶ara totroa b̶ead̶ia paca jub̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabuloʌ̃, bʌ ẽberãrãda pusa icawa duanania. Ãdji druad̶e barcora necai wib̶arid̶ia. Ãdji ẽjũãra ab̶a Sidoʌ̃ drua daucha b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isacar, bʌra burro quĩrãca zarea b̶ʌa. Baribʌrʌ bʌa atau b̶ʌ edre tab̶abaria. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Bʌ ẽberãrãba ẽjũã biada ʌ̃nãũni carea unubʌdad̶e ãdjirãra nezocarãda duanenia. Maʌ̃ne ed̶aa jũrã tʌd̶ia ne ataud̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Daʌ̃, bʌ purura jipa pe erob̶aya waabema israelerãba ãdji puru obada quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Daʌ̃, bʌ ẽberãrãra minijĩchia panania dama o icawa b̶ʌ quĩrãca. Damaba cawayora jĩrũne caped̶a dji cawayo ʌ̃rʌ̃ chũmʌra ud̶u b̶aebibaria. Ab̶ari quĩrãca bʌ ẽberãrãra zocãrãẽ́ panʌmĩna mẽsrã panania. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","¡Ay Ãcõrẽ, mʌ̃a jʌ̃ã b̶ʌa bʌa mʌ̃ra ẽdrʌ b̶ʌmãrẽã! ");
INSERT INTO empNTpo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ga, dewararãba bʌ purura urad̶e zed̶imĩna bʌ ẽberãrãba ãdjirãra poyad̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser, bʌ ẽberãrãba cod̶ira dji bia baya. Maʌ̃da ẽberãrã bororãa cobigad̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Neptali, bʌ ẽberãrãra b̶egui mẽã nĩbabari quĩrãca duanʌa. Ãdji warrarãra quĩrãwãrẽã qued̶eaa. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Jose, bʌra bacuru do icawa b̶ʌ quĩrãca b̶ʌa. Dji jʌwatera bia zaubaria, mõgara puru aud̶u jũrã ca b̶ʌ cãyãbara ʌ̃tʌara waribaria. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Cha drʌ cawa b̶eaba bʌra bariduaareba chaba drʌ panesid̶aa. Bʌra quĩrãma panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Baribʌrʌ bʌ enedrʌmara bio enatʌ eronũmasia jʌwa wẽsa ãdjimaa drʌi carea. Bʌa ãdjirãra poyasia mʌ̃ Ãcõrẽ ne jũma poya b̶ʌba bʌra carebad̶a bẽrã, dadji israelerã wagabari Ãcõrẽba bʌra waga b̶ʌ bẽrã, dadji israelerã Ãcõrẽ mõgara droma quĩrãca b̶ʌba bʌra jũãtrʌ erob̶ʌ bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Bʌ zezaba ĩjã b̶ʌ Ãcõrẽneba bʌa poyasia. Ara maʌ̃ Ãcõrẽba bʌra carebaya. Ãcõrẽ ne jũma poya o b̶ʌba bʌ ẽberãrãa bajãneba cueda diaya. Idjab̶a naʌ̃ ẽjũãne baidoda diaya. Bʌd̶eba yõbʌda wẽrãrãba, bʌ animarã b̶ea bid̶a warrarãda zocãrã to b̶ead̶ia idjab̶a ju dawa b̶ead̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Jose, mʌ̃a bʌra biara jara b̶ʌsia mʌ̃ djibarirãba mʌ̃ bia jara b̶ʌped̶ad̶a cãyãbara. Eya jõca quĩrãca bʌ bia jara b̶ʌd̶ara jõca baya, bʌ djabarã cãyãbara bʌdrʌ Ãcõrẽba biara b̶ʌd̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamiʌ̃, bʌra usa cadrʌa quĩrãca b̶ʌa. Usa cadrʌaba diaped̶a bead̶ara coped̶a dji ad̶ubad̶ada quewara jed̶ecabaria. Ara maʌ̃ quĩrãca bʌa dji quĩrũra poyaped̶a ãdji nebiada jed̶ecaya.– ");
INSERT INTO empNTpo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Mãwã Jacoboba idji warrarãra bia jara b̶ʌsia. Ãdjiza idjia arid̶e jarasia. Idji warrarã doce panʌneba yõped̶ad̶ara Israel puru doce panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","32","Maʌ̃be Jacoboba idji warrarãa jarasia: –Mʌ̃ra beubʌrʌa. Mʌ̃ra tʌb̶arid̶adua mʌ̃ drõãenabemarã tʌb̶ariped̶ad̶ama Macpela ẽjũã uriad̶e. Macpelara Canaaʌ̃ne b̶ʌa Mamred̶eba ʌ̃mãdau odjabariare. Abrahaʌ̃ba maʌ̃ ẽjũãra dji uria sid̶a hitita Eproʌ̃ne b̶ad̶ada nẽdosia idji quima tʌb̶ari carea. Mama Abrahaʌ̃ sid̶a tʌb̶arisid̶aa. Mʌ̃ zeza Isara, dji quima Rebeca sid̶a mama tʌb̶arisid̶aa. Mʌ̃a Lea sid̶a mama tʌb̶arisia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jacoboba idji warrarãa mãwã jaraped̶a idji cʌd̶ad̶e wayacusa tab̶esia. Tab̶eped̶a jaid̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Maʌ̃ne Joseba idji zezara bʌrʌ edaped̶a jĩã b̶ʌba isõsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Mãwãnacarea Joseba dji nẽãrã obadarãa idji zeza Israel cacuara pʌrʌbisia b̶erawarãmãrẽã. Ara maʌ̃da pʌrʌ panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Cuarenta ewari mãwã pʌrʌ panasid̶aa, jũma daucha oi carea dãrãbari bẽrã. Jũma ãbaa egiptorãra setenta ewari Jacobo carea sopua ewarida wagasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Sopua ewari jõnacarea Joseba Egiptod̶ebema boro ded̶e panabadaa jarasia: –Mʌ̃ djuburia, dadjirã boroa nãwã jarad̶adua: ");
INSERT INTO empNTpo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","“Mʌ̃ zezaba mʌ̃́a wãrãneba jarabisia idjira Canaaʌ̃ druad̶e tʌb̶arid̶e edemãrẽã. Idjia jarasia: ‘Mʌ̃ra beuya. Canaaʌ̃ druad̶e mʌ̃a joubada uriada erob̶ʌa. Mama mʌ̃ra tʌb̶aridua.’ Maʌ̃ carea mʌ̃a bed̶ea djuburiaya idu mʌ̃ zeza tʌb̶arid̶e wãbimãrẽã. Tʌb̶ariped̶a waya zeya.”– ");
INSERT INTO empNTpo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ãdjia Egiptod̶ebema boroa mãwã jaraped̶ad̶acarea dji boroba Josea jarasia: –Bʌ zeza tʌb̶arid̶e wãdua idjia bʌ́a wãrãneba jarabid̶a quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ara maʌ̃da Josera idji zeza tʌb̶arid̶e wãsia. Idji ume wãbʌrʌsid̶aa jũma Egiptod̶ebema boroare b̶eada, dji boro ẽberãrãnebema dji dromarãda, jũma Egipto druad̶ebema dji dromarã sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Jose ẽberãrãda, idji djabarãda, idji zeza ẽberãrã sid̶a jũma wãbʌrʌsid̶aa. Ãdji warrarãda, ãdji ovejada, ãdji paca sid̶a Goseʌ̃ne amesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Carretad̶eba djõbadarãda idjab̶a cawayod̶eba djõbadarã sid̶a Jose ume wãsid̶aa. Ẽberãrãra bio cãbana wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Wãbʌdad̶e trigo tẽũbada Atad abadama jũẽsid̶aa. Maʌ̃gʌra Jordaʌ̃ dod̶eba ʌ̃mãdau odjabariare b̶ʌa. Mama Josera waabemarã sid̶a idji zeza Jacobo carea wayacusa aujĩãsid̶aa. Siete ewari bio ororoa aujĩãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Mamabema cananeorãba ãdji bio ororoa aujĩã duanʌra ũrĩsid̶aa. Maʌ̃ bẽrã jarasid̶aa: –Egiptorãda sopuaba bio jĩãbi ororoa duanʌa.– Maʌ̃ carea Atad ẽjũãra trʌ̃ b̶ʌsid̶aa Abel-mizraiʌ̃. ");
INSERT INTO empNTpo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Jacobo warrarãba ãdji zezaba jarad̶a quĩrãca osid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Idji cacuara edesid̶aa Canaaʌ̃ druad̶aa. Maʌ̃be Macpela joubada uriad̶e tʌb̶arisid̶aa. Dji ẽjũãra Mamred̶eba ʌ̃mãdau odjabariare b̶ʌa. Abrahaʌ̃ba maʌ̃ ẽjũãra, dji uria sid̶a hitita Eproʌ̃ne bad̶ada nẽdosia idji ẽberãrã jaid̶abʌdada tʌb̶ari carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Jacobo tʌb̶ariped̶ad̶acarea Josera, idji djabarã, waabemarã sid̶a waya Egipto druad̶aa wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ãdji zezara beud̶a bẽrã Jose djabarãba nãwã crĩcha panesid̶aa: “Ãĩbẽrã Joseba dadjirãra quĩrãma b̶ʌa. Ʌ̃rãbʌrʌ dadjirãra biẽ́ oya idji biẽ́ oped̶ad̶a carea.” ");
INSERT INTO empNTpo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","17","Maʌ̃ bẽrã naʌ̃ bed̶eada Josemaa diabuesid̶aa: “Dadji zeza jaid̶ai naẽna daia jarasia bʌ́a nãwã jarad̶amãrẽã: ‘Bʌ djabarãba wãrãda cadjirua oped̶ad̶amĩna mʌ̃ djuburia maʌ̃ra quĩrãdoadua.’ Maʌ̃ bẽrã dai djuburia, bʌ biẽ́ oped̶ad̶ara quĩrãdoadua. Daira dadji zeza Jacoboba ĩjã b̶ad̶a Ãcõrẽ nezocarãa.” Maʌ̃ ũrĩbʌrʌd̶e Josera jĩãsia. ");
INSERT INTO empNTpo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Maʌ̃be Jose djabarãra idjimaa wãsid̶aa. Ne wayaad̶eba idji quĩrãpita chĩrãborod̶e copanenaped̶a jarasid̶aa: –Daira bʌ nezocarãa.– ");
INSERT INTO empNTpo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Maʌ̃ne Joseba panusia: –Wayarãnadua. Mʌ̃ra Ãcõrẽẽ́a bãrã cawa oi carea. ");
INSERT INTO empNTpo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Bãrãba mʌ̃ra biẽ́ od̶ida crĩchasid̶aa baribʌrʌ maʌ̃ biẽ́ oped̶ad̶ad̶eba Ãcõrẽba biada osia maʌ̃neba zocãrã ẽberãrãda jarrababa beud̶id̶ebemada ẽdrʌ edai carea. Maʌ̃gʌra bãrãba naʌ̃ ewarid̶e unu panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Wayarãnadua. Mʌ̃a bãrãra careba b̶aya. Mʌ̃a dia b̶aya bãrãra, bãrã warrarã sid̶a ne cod̶amãrẽã.– Mãwã quĩrĩãneba jarad̶a bẽrã Joseba ãdjira sobiabisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josera, idji zeza ẽberãrã sid̶a Egiptod̶e panesid̶aa. Josera ciento die poa b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Beui naẽna idji warra Epraiʌ̃ wiuzaquerãra, ãdji warrarã sid̶a unusia. Idjab̶a Manase wiuzaquerã sid̶a unusia. Ãdji zezara Maquir basía. Joseba maʌ̃gʌrãra idji b̶acarad̶e edaped̶a idji warrarã araad̶a asia. ");
INSERT INTO empNTpo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ewari ab̶a Joseba idji djabarãa jarasia: –Mʌ̃ra dãrãẽ́ne beuya, baribʌrʌ Ãcõrẽba bãrãra carebaya. Idjia bãrãra, bãrãneba yõbʌdarã sid̶a naʌ̃ druad̶eba Canaaʌ̃ druad̶aa edeya. Maʌ̃ druara idjia Abrahaʌ̃a, Isaa, Jacoboa bid̶a wãrãneba diai jarasia.– ");
INSERT INTO empNTpo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Maʌ̃ne Joseba Israel ẽberãrãa jarasia: –Wãrãda Ãcõrẽba bãrãra carebaya. Maʌ̃ ewarid̶e bãrãba mʌ̃ b̶ʌwʌrʌra namaʌba Canaaʌ̃ druad̶aa tʌb̶arid̶e eded̶adua.– Maʌ̃gʌra Joseba Israel ẽberãrãa wãrãneba jarabisia. ");
INSERT INTO empNTpo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Jose ciento die poa b̶ʌda Egipto druad̶e jaid̶asia. Idji cacuara nẽãrãba pʌrʌsid̶aa b̶erawarãmãrẽã. Pʌrʌd̶aped̶a cajona biad̶e b̶ʌsid̶aa.");
INSERT INTO empNTpo_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Israel warrarã idji ume ãdji warrarã bara Egiptod̶aa b̶ad̶e wãped̶ad̶ara naʌ̃gʌrã basía: ");
INSERT INTO empNTpo_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubeʌ̃, Simeoʌ̃, Levi, Juda, ");
INSERT INTO empNTpo_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isacar, Zabuloʌ̃, Benjamiʌ̃, ");
INSERT INTO empNTpo_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Daʌ̃, Neptali, Ga, Aser sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Israel warra Josera dãrãbʌrʌ basía Egiptod̶e b̶ʌda. Maʌ̃ ewarid̶e Jacobo Israel abadad̶eba yõped̶ad̶ara Egiptod̶e setentabe panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Mãwã b̶ʌd̶e Josera, idji djabarãra idjab̶a jũma idji daucha b̶ead̶a sid̶a jaid̶asid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Baribʌrʌ ãdjirãza warrarã zocãrã unubadjid̶a bẽrã isabe yõnaped̶a bio cãbana panesid̶aa. Maʌ̃ bẽrã dji druara ãdjirãba birasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Mãwã b̶ʌd̶e dewara ẽberãda Egiptod̶ebema boroda b̶esia. Maʌ̃gʌba Josed̶ebemada adua b̶ad̶a bẽrã idji purua nãwã jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","–¡Quĩrãcuitad̶adua! Jãʌ̃ israelerãra dadjirã cãyãbara cãbanaara panʌ bẽrã ʌb̶ʌara panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Maʌ̃ bẽrã crĩcha cawaad̶eba dadjirãba od̶ia ãdjirãra aud̶uara yõrãnamãrẽã. Mãwã od̶aẽ́bʌrʌ, dji quĩrũda dadjirã ume djõbʌdad̶e israelerãra ãdjirãare djõnia. Mãwãra naʌ̃ druad̶ebemada ẽdrʌd̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Maʌ̃ carea egiptorãba israelerãa traju zareada õgo obid̶i carea dji bororãda b̶ʌcuasid̶aa. Maʌ̃gʌrãba israelerãa Egiptod̶ebema boro itea puruda umé obisid̶aa. Ab̶a Pitoʌ̃, ab̶a Ramese abadjid̶aa. Maʌ̃ puru umé panʌne dji boroba idji itea ewaped̶ad̶ara wagabadjia. ");
INSERT INTO empNTpo_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Egiptorãba wetara mĩgabibadjid̶amĩna israelerãra aud̶uara yõ wãsid̶aa. Maʌ̃ bẽrã egiptorãba israelerãra waya panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Maʌ̃ carea egiptorãba quĩrã djuburia neẽ́ israelerãra wetara trajabibadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Traju zarea obi panʌneba israelerãra bio bia mĩgabibadjid̶aa. Egoroda chiruad̶aa puerad̶aped̶a de obada mõgarara obibadjid̶aa. Idjab̶a jũma ãdji ẽjũãnebema trajuda obibadjid̶aa. Jũma maʌ̃gʌra ãdjirãba quĩrã djuburia neẽ́ israelerãa obibadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Maʌ̃ ewarid̶e wẽrãda umé panasid̶aa, Siprada idjab̶a Púada. Maʌ̃gʌrãba hebreo wẽrãrãda careba warra tobibadjid̶aa. Egiptod̶ebema boroba ãdjía jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","–Bãrãba hebreo wẽrãda careba warra tobibʌdad̶e acʌd̶adua dji cãrẽda tosi cawaya. Umaquĩrã warrada toibʌrʌ, bead̶adua. Wẽrãcauda toibʌrʌ, idu b̶ʌd̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Baribʌrʌ dji wẽrãrã careba warra tobibadarãba Ãcõrẽda wayasid̶aa. Maʌ̃ bẽrã Egiptod̶ebema boroba jarad̶a quĩrãca od̶aẽ́ basía, ãtebʌrʌ umaquĩrã warra zaquerãra zocai b̶ʌbadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Maʌ̃ carea Egiptod̶ebema boroba ãdjira trʌ̃ped̶a iwid̶isia: –¿Cãrẽã bãrãba jãwã o panʌ? ¿Cãrẽã umaquĩrã warra zaquerãra zocai b̶ʌ panʌ?– ");
INSERT INTO empNTpo_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ãdjirãba panusid̶aa: –Hebreo wẽrãrãra dai Egiptod̶ebema wẽrãrã quĩrãca b̶eaẽ́a. Ãdjirãra warra to bia b̶ea bẽrã dai jũẽbʌdabara ãdji warrara to eropanabadaa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Maʌ̃ bẽrã israelerãra wad̶ibid̶a aud̶uara yõ wãsid̶aa. Maʌ̃ba ʌb̶ʌara panesid̶aa. Ãcõrẽba dji wẽrãrã careba warra tobibadarãra carebasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Idjida wayaped̶ad̶a bẽrã ãdjía warrarãda zocãrã unubisia. ");
INSERT INTO empNTpo_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Maʌ̃be Egiptod̶ebema boroba idji purua jarasia: –Hebreorãba umaquĩrã warrada tod̶ibʌrʌ daid̶u b̶atacuad̶adua, baribʌrʌ wẽrãcauda tod̶ibʌrʌ zocai b̶ʌd̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Umaquĩrã Levid̶eba yõnaba wẽrãda edasia. Dji wẽrã sid̶a Levid̶eba yõna basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Maʌ̃ wẽrãra b̶iogoaped̶a umaquĩrã warrada tosia. Maʌ̃ warrara quĩrãwãrẽã ununa bẽrã jed̶eco ũbea mẽrã erob̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Baribʌrʌ waa poya mẽrã erob̶aẽ́ bẽrã jamarada caped̶a cãdorronaba soasia. Maʌ̃be idji warrara ed̶a b̶ʌped̶a Nilo do ĩchitad̶e dojoro tãẽna ũmʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Maʌ̃ne dji warra zaque djabawẽrãba tʌmʌba acʌ b̶asia idjira sãwãi cawaya. ");
INSERT INTO empNTpo_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Mãwã b̶ʌd̶e Egiptod̶ebema boro cauda doed̶a cuid̶e wãsia. Idji nezocawẽrãrãda doya pʌrrʌa panasid̶aa. Maʌ̃ne idjia unusia dji jamarara dojoro tãẽna ũmʌda. Ara maʌ̃da idji nezocawẽrãa edad̶e wãbisia. ");
INSERT INTO empNTpo_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Eneped̶a Egiptod̶ebema boro cauba dji jamara ewa acʌbʌrʌd̶e warra zaqueda ed̶a mĩã djuburi jĩã quiruda unusia. Maʌ̃ne idjia jarasia: –Naʌ̃ra hebreo warra zaqueda jãwã quirua.– ");
INSERT INTO empNTpo_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Maʌ̃ne dji warra zaque djabawẽrãra caita zeped̶a Egiptod̶ebema boro caua jarasia: –¿Bʌmaarã bia b̶ʌca mʌ̃a hebreo wẽrãda trʌ̃ne wãida naʌ̃ warra bʌ itea daupẽmãrẽã?– ");
INSERT INTO empNTpo_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Egiptod̶ebema boro cauba jarasia: –Bia b̶ʌa. Trʌ̃ne wãdua.– Ara maʌ̃da wẽrãcaura wãped̶a dji papada enesia. ");
INSERT INTO empNTpo_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Maʌ̃be Egiptod̶ebema boro cauba dji warra papaa jarasia: –Naʌ̃ warrara edeped̶a mʌ̃ itea daupẽdua. Maʌ̃bari mʌ̃a bʌ́a ne diaya.– Maʌ̃ bẽrã dji warra papaba edeped̶a daupẽsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Dji warra dawara b̶ed̶acarea dji papaba Egiptod̶ebema boro caua diad̶e wãsia. Maʌ̃be Egiptod̶ebema boro cauba maʌ̃ warrara idjid̶e ara quĩrãca erob̶esia. Dji warrara trʌ̃ b̶ʌsia Moise, nãwã jarad̶a bẽrã: –Mʌ̃a idjira doed̶a ũmʌda edasia.– ");
INSERT INTO empNTpo_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Moise drõã bad̶acarea ewari ab̶a idji ẽberãrã hebreorãda acʌd̶e wãsia. Maʌ̃ne unusia sãwã ãdjirãra bia mĩga traja panʌda. Idjab̶a unusia Egiptod̶ebemaba hebreoda ab̶a u erob̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Maʌ̃ carea idjia pʌrrʌa acʌbʌrʌd̶e ni ab̶aʌda unuẽ́ bẽrã dji Egiptod̶ebemara beataped̶a ĩbʌd̶e joutasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Nurẽma wayacusa araa wãbʌrʌd̶e unusia ab̶arica hebreorãda umé djõ panʌda. Maʌ̃ carea dji djõ jʌrʌd̶aa iwid̶isia: –¿Ab̶arica hebreoda bʌa cãrẽ cãrẽã jãwã puo b̶ʌ?– ");
INSERT INTO empNTpo_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Dji djõ jʌrʌd̶aba panusia: –¿Caiba bʌra dai boroda b̶ʌsi? ¿Caiba bʌra dai cawa obarida b̶ʌsi? ¿Mʌ̃ sid̶a bʌa beaida crĩcha b̶ʌca Egiptod̶ebema bead̶a quĩrãca?– Maʌ̃ ũrĩbʌrʌd̶e Moisera dauperasia cawad̶a bẽrã idji mĩã bead̶ara cawasid̶ada. ");
INSERT INTO empNTpo_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Egiptod̶ebema boroba Moise mĩã bead̶a cawasid̶e idjira jidabisia beabi carea. Baribʌrʌ jidad̶i naẽna Moisera Egiptod̶eba Madiaʌ̃ druad̶aa mĩrũ wãsia. Mama jũẽped̶a Moisera baido juebada uria corod̶a caita chũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Maʌ̃ne wẽrãrãda siete zesid̶aa. Maʌ̃ wẽrãrãra Madiaʌ̃nebema sacerdote caurã basía. Ãdjirãra zesid̶aa animarãba baido dobadad̶e baido jued̶aped̶a ãdji zeza ovejara baido dobid̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Baribʌrʌ dewara oveja wagabadarãda zed̶aped̶a maʌ̃ wẽrãrãra ãyã jʌretasid̶aa. Maʌ̃ carea Moisera araa wãped̶a dji wẽrãrãra carebaped̶a ãdji ovejara baido dobigasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Mãwãnacarea dji wẽrãrã wayacusa ãdji zeza Reuelma jũẽsid̶ad̶e idjia iwid̶isia: –¿Id̶i bãrãra sãcua isabe zesid̶a?– ");
INSERT INTO empNTpo_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ãdjirãba panusid̶aa: –Oveja wagabadaba dai ãyã jʌretasid̶ad̶e Egiptod̶ebemaba daira carebasia. Maʌ̃ awara baido jueped̶a dadjirã ovejara baido dobigasia.– ");
INSERT INTO empNTpo_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Reuelba idji caurãa iwid̶isia: –¿Maʌ̃ ẽberãra sãma b̶ʌ? ¿Cãrẽ cãrẽã idjira b̶eesid̶a? Trʌ̃ne wãnadua ne cod̶e zemãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mãwã Moisera Reuel diguid̶a b̶esia. Mama b̶ʌd̶e Reuelba idji cau Seporáda Moisea diasia idji quima bamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Mãwã b̶ʌd̶e dji wẽrãba umaquĩrã warrada tosia. Moiseba maʌ̃ warra trʌ̃ra b̶ʌsia Gersoʌ̃, nãwã jarad̶a bẽrã: “Naʌ̃ druad̶e mʌ̃ra drua ãĩbemada jãwã b̶ʌa.” ");
INSERT INTO empNTpo_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Mãwãnacarea dãrãbʌrʌd̶e Egiptod̶ebema borora beusia. Baribʌrʌ egiptorãba israelerãra wad̶i zoca eropanʌ bẽrã ãdub̶a mĩã sopua bed̶eabadjid̶aa. Ãdjirãba Ãcõrẽa quĩrã djuburiada iwid̶ibadjid̶aa. Maʌ̃ra Ãcõrẽba ũrĩsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Idjab̶a mĩã sopua bed̶ea panʌ sid̶a ũrĩsia. Maʌ̃ne idjia Abrahaʌ̃ ume, Isa ume, idjab̶a Jacobo ume bid̶a ãdji carebai carea bed̶ea b̶ʌd̶ara quĩrãdoaẽ́ b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Maʌ̃ bẽrã israelerã bia mĩga panʌra acʌ b̶aped̶a carebai carea b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moise zãwãrẽ Reuel Jetro abadada Madiaʌ̃nebemarã sacerdote basía. Moiseba idji ovejara wagabadjia. Ewari ab̶a Moiseba dji ovejara dewara orroare ne cobid̶e edesia. Maʌ̃ne idjira ẽjũã põãsa ewaraga b̶ʌd̶e Horeb eyad̶e jũẽne wãsia. Maʌ̃ eyara Ãcõrẽ eya abadaa. ");
INSERT INTO empNTpo_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Mama Ãcõrẽba ara idjida unubisia bacuru zaqued̶e uruga nũmʌda. Moiseba unusia maʌ̃ bacurura eradrʌ nũmʌmĩna baẽ́ b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Maʌ̃ carea crĩchasia: “¿Cãrẽda jãwã uruga nũmʌ? Caitaara acʌd̶e wãya sãwãẽrã jãwã baẽ́ b̶ʌ cawaya.” ");
INSERT INTO empNTpo_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ãcõrẽba Moise caitaara zebʌrʌda unusid̶e maʌ̃ bacuru zaque uruga nũmʌneba trʌ̃ jarasia: –Moise, Moise.– Moiseba panusia: –Mʌ̃ra nama b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Maʌ̃ne Ãcõrẽba idjía jarasia: –¡Caitaara zerãdua! Nama bʌra mʌ̃ quĩrãpita b̶ʌ bẽrã bʌ jĩrũ jãne jʌ̃ b̶ʌra ẽrãdua. ");
INSERT INTO empNTpo_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Mʌ̃ra bʌ zezaba ĩjã b̶ad̶a Ãcõrẽa. Abrahaʌ̃ba, Isaba, idjab̶a Jacoboba mʌ̃ra ĩjã panasid̶aa.– Maʌ̃ne Moiseba Ãcõrẽra waya b̶ʌ bẽrã idji quĩrãdarrara jũãtrʌsia Ãcõrẽ acʌ amaaba. ");
INSERT INTO empNTpo_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ãcõrẽba jarasia: –Mʌ̃a unu b̶ʌa mʌ̃ purura Egipto druad̶e bio bia mĩga b̶ʌda. Idjab̶a mʌ̃a ũrĩ b̶ʌa ãdjirãba quĩrã djuburiada iwid̶i panʌda. Iwid̶i panʌa mʌ̃a ãdjirãra dji traju obibada bororã jʌwaed̶abemada ẽdrʌ b̶ʌmãrẽã. Mʌ̃a cawa b̶ʌa ãdjirãra wãrãda bia mĩga panʌda. ");
INSERT INTO empNTpo_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Maʌ̃ bẽrã mʌ̃a ãdjirãra egiptorã jʌwaed̶a panʌnebemada ẽdrʌ b̶ʌi carea ze b̶ʌa. Egipto druad̶ebemada ẽdrʌ b̶ʌped̶a mʌ̃a dewara druad̶aa edeya. Maʌ̃ druara bio bia b̶ʌa idjab̶a waib̶ʌa b̶ʌa. Maʌ̃ druad̶e baridua ne uped̶ad̶ara bia zaubaria. Mama cananeorãda, hititarãda, amorreorãda, perezeorãda, heveorãda, idjab̶a jebuseorã sid̶a duanʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Israelerãba quĩrã djuburia iwid̶i panʌra mʌ̃a ũrĩ b̶ʌa. Idjab̶a unu b̶ʌa egiptorãba ãdjirãra bia mĩga eropanʌda. ");
INSERT INTO empNTpo_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Maʌ̃ carea mʌ̃a bʌra Egiptod̶ebema boromaa diabueya. Idjía jaradua mʌ̃ puru Israel ẽdrʌ b̶ʌmãrẽã. Ẽdrʌ b̶ʌsira ãdjirãra Egiptod̶ebemada ãyã pe ededua.– ");
INSERT INTO empNTpo_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Baribʌrʌ Moiseba jarasia: –¿Mãwãra mʌ̃ra cai Egiptod̶ebema boro quĩrãpita bed̶ead̶e wãi carea idjab̶a israelerãra Egiptod̶eba ãyã edei carea?– ");
INSERT INTO empNTpo_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Maʌ̃ne Ãcõrẽba panusia: –Wãdua. Mʌ̃ra bʌ ume b̶aya. Mʌ̃a nãwã unubiya bʌra wãrãda diabuesida. Bʌa israelerãra Egiptod̶ebemada ãyã edeped̶a bãrãba naʌ̃ eyad̶e mʌ̃́a bia bed̶ead̶e zed̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Baribʌrʌ Moiseba jarasia: –Israelerãmaa wãped̶a bãrã drõã naẽnabemarãba ĩjã panana Ãcõrẽba mʌ̃ra bãrãmaa diabuesiad̶a abʌrʌd̶e ãdjirãba iwid̶id̶ia: “¿Idjira casa trʌ̃bada?” Maʌ̃ne ¿mʌ̃a cãrẽda jarai?– ");
INSERT INTO empNTpo_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ãcõrẽba panusia: –Mʌ̃ trʌ̃ra nãwã jarabadaa: “Mʌ̃ra mʌ̃a.” Maʌ̃ bẽrã israelerãa jaradua: “Dadji Ãcõrẽ ‘Mʌ̃ra mʌ̃a’ abadaba mʌ̃ra bãrãmaa diabuesia.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Idjab̶a jarasia: –Israelerãa jaradua: “Dadji Ãcõrẽba mʌ̃ra bãrãmaa diabuesia. Dadji drõã naẽnabema Abrahaʌ̃ba, Isaba, idjab̶a Jacobo bid̶a idjira ĩjã panasid̶aa.” Mʌ̃ trʌ̃ Jehová abadara ewariza b̶aya. Maʌ̃ trʌ̃neba ẽberãrãba mʌ̃ra cawa panania. ");
INSERT INTO empNTpo_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Egiptod̶aa wãdua. Jãma jũẽped̶a israelerã bororã ume bed̶eadua. Ãdjirãa jaradua: “Dadji Boro Ãcõrẽba mʌ̃́a ara idjida unubisia. Dadji drõã naẽnabema Abrahaʌ̃ba, Isaba, idjab̶a Jacoboba idjira ĩjã panasid̶aa. Idjia nãwã jarasia: mʌ̃a bãrã israelerãra acʌ b̶ʌ bẽrã unu b̶ʌa egiptorãba bãrãra biẽ́ o panʌda. ");
INSERT INTO empNTpo_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Idjia bãrãra Egiptod̶e bia mĩga panʌda ẽdrʌ b̶ʌped̶a dewara druad̶aa edeyad̶a asia. Maʌ̃ druad̶e baridua ne uped̶ad̶ara bia zaubaria. Mama cananeorãda, hititarãda, amorreorãda, perezeorãda, heveorãda, idjab̶a jebuseorã sid̶a duanʌa.” ");
INSERT INTO empNTpo_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Bʌa jarabʌrʌra israelerã bororãba ĩjãnia. Maʌ̃be ãdjirãra bʌ ume ededua Egiptod̶ebema boromaa. Bãrãba idjía jarad̶adua: “Dai hebreorã Ãcõrẽda daima odjaped̶a jarasia idjía animarã babue diad̶e wãnamãrẽã. Maʌ̃ bẽrã dairãra ẽjũã põãsa ewaraga b̶ʌd̶e ewari ũbea idu wãbidua mãwã od̶i carea.” ");
INSERT INTO empNTpo_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Baribʌrʌ mʌ̃a cawa b̶ʌa Egiptod̶ebema boroba israelerãra ẽdrʌ b̶ʌẽ́da mʌ̃a idjía mãwã obiẽ́bʌrʌ. ");
INSERT INTO empNTpo_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Maʌ̃ bẽrã mʌ̃ ʌb̶ʌada egiptorãa unubiya. Zocãrã ne ununaca waib̶ʌa b̶eada oya ãdjirãra cawa oi carea. Mãwãbʌrʌ Egiptod̶ebema boroba israelerãra idu wãbiya. ");
INSERT INTO empNTpo_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Idjab̶a mʌ̃a o b̶ʌ carea egiptorãba israelerãra bia ununi bẽrã ne diad̶ia. Mãwã israelerãra Egiptod̶eba ẽdrʌbʌdad̶e ara jãwã ẽdrʌd̶aẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Jũma israelerã wẽrãrãba ãdji caita panʌ egiptorãa parata od̶ada, oro od̶a sid̶a iwid̶id̶ida panʌa. Cacuad̶e jʌ̃bada sid̶a ãdji warrarã itea, wẽrãcaurã itea bid̶a iwid̶id̶ida panʌa. Ara maʌ̃ quĩrãca baridua Egiptod̶ebema wẽrã maʌ̃ ded̶e b̶ʌ́a bid̶a iwid̶id̶ida panʌa. Mãwã israelerãba ne jũma bia Egiptod̶ebemara edad̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Baribʌrʌ Moiseba jarasia: –Israelerãba mʌ̃a jarabʌrʌra ĩjãnaẽ́a idjab̶a ũrĩ quĩrĩãnaẽ́a. Ãdjirãba jarad̶ia: “Ãcõrẽba ara idjida bʌ́a unubiẽ́ b̶ʌa.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Maʌ̃ne Ãcõrẽba iwid̶isia: –¿Bʌa cãrẽda jʌwad̶e erob̶ʌ?– Moiseba panusia: –Bacuruda erob̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ãcõrẽba jarasia: –Egode b̶aebidua.– B̸aebibʌrʌd̶e bacurura dama ba dogosia. Maʌ̃ unusid̶e Moisera ãyã jʌ̃drʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Baribʌrʌ Ãcõrẽba jarasia: –Dji drud̶e jidadua.– Ara maʌ̃da Moiseba dji drud̶e jidabʌrʌd̶e waya bacuru basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Maʌ̃be Ãcõrẽba Moisea jarasia: –Bʌa maʌ̃da osira israelerãba ĩjãnia mʌ̃a ara mʌ̃djida bʌ́a unubisida. Cawad̶ia mʌ̃ra ãdji drõã naẽnabemarã Abrahaʌ̃ba, Isaba, idjab̶a Jacobo bid̶a ĩjã panana Ãcõrẽda.– ");
INSERT INTO empNTpo_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Maʌ̃ awara Ãcõrẽba jarasia: –Bʌ jʌwara bʌa jʌ̃ b̶ʌ edre berajudua.– Ara maʌ̃da Moiseba berajuped̶a ẽũta edabʌrʌd̶e ab̶ed̶a idji jʌwara aid̶aba bira b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ãcõrẽba jarasia: –Wayacusa bʌ jʌwara bʌa jʌ̃ b̶ʌ edre berajudua.– Ara maʌ̃da Moiseba waya berajuped̶a ẽũta edabʌrʌd̶e idji jʌwara ab̶ed̶a bia b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Maʌ̃be Ãcõrẽba jarasia: –Dji nabema ne ununaca obʌrʌd̶e israelerãba bʌa jara b̶ʌda ĩjãnaẽ́bʌrʌ, dji umébema ne ununaca obʌrʌd̶e ĩjãnia. ");
INSERT INTO empNTpo_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Baribʌrʌ maʌ̃ ne ununaca umé obʌrʌd̶e ãdjirãba wad̶ibid̶a bʌa jara b̶ʌda ĩjãnaẽ́bʌrʌ, naʌ̃ quĩrãca odua. Nilo dod̶e baidoda jue edaped̶a drua weatadua. Maʌ̃ne maʌ̃ baidora oa baya.– ");
INSERT INTO empNTpo_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ãcõrẽba mãwã jarad̶amĩna Moiseba idjía jarasia: –¡Ay, mʌ̃ Boro! Mʌ̃ra ẽberãrã quĩrãpita warrá bed̶eacaa. Maʌ̃ra id̶ibemaẽ́a. Bʌra mʌ̃ ume bed̶ea b̶ʌmĩna mʌ̃ra ara mãwã warrá bed̶eacaa. Mʌ̃ra ẽberãrã quĩrãpita cawa bed̶eacaa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Baribʌrʌ Ãcõrẽba jarasia: –¿Caiba ẽberãrã itera osi? ¿Mʌ̃abʌrʌ oẽ́ basica ẽberãrã quĩrãme cara b̶eada, cʌwʌrʌ qui b̶eada, dau bia b̶eada, idjab̶a daub̶errea b̶ea sid̶a? Mʌ̃ra Ãcõrẽ bẽrã mãwã oida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Bʌ bed̶eabʌrʌd̶e mʌ̃a carebaya. Mʌ̃a cawabiya bʌa cãrẽda jaraida b̶ʌda. Jãʌ̃be Egiptod̶aa wãdua.– ");
INSERT INTO empNTpo_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Baribʌrʌ Moiseba panusia: –¡Ay, mʌ̃ Boro! Mʌ̃ quĩrã djuburia dewara ẽberãda diabuedua.– ");
INSERT INTO empNTpo_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Maʌ̃ carea Ãcõrẽra Moise ume quĩrũsia. Nãwã jarasia: –¿Bʌ djaba Aaroʌ̃ Levid̶eba yõnada b̶ʌẽ́ca? Mʌ̃a cawa b̶ʌa idjira bia bed̶eabarida. Idjira bʌ acʌd̶e zebʌrʌa. Bʌ unubʌrʌd̶e idjira b̶ʌsrid̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","16","Idjira Egiptod̶e bʌ cacuabari bed̶eaya. Mʌ̃a jarabi b̶ʌda bʌa idjía jaraya. Maʌ̃gʌra idjia purua jaraya. Mʌ̃a bãrãra carebaya bia bed̶ead̶amãrẽã idjab̶a cawabiya sãwãbʌrʌ od̶ida panʌda. Bʌa ãcõrẽ quĩrãca Aaroʌ̃a bed̶ea b̶aya idjab̶a idjira bʌd̶eba bed̶ea b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Bʌ jʌwad̶e erob̶ʌ bacurura ededua maʌ̃gʌd̶eba ne ununacada oi bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Maʌ̃be Moisera idji zãwãrẽ Jetro abadamaa wãped̶a jarasia: –Mʌ̃ra Egiptod̶aa wãya mʌ̃ ẽberãrã acʌd̶e wad̶i zocai panʌ cawaya.– Jetroba jarasia: –Bia b̶ʌa. Necai wãdua.– ");
INSERT INTO empNTpo_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Moise wad̶i Madiaʌ̃ druad̶e b̶asid̶e Ãcõrẽba idjía jarasia: –Egiptod̶aa wãdua. Bʌ bea quĩrĩã pananara jũma beusid̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Maʌ̃be Moiseba dji quimada, dji warrarã sid̶a burro ʌ̃rʌ̃ b̶ʌped̶a Egiptod̶aa wãsid̶aa. Idji jʌwad̶e edesia Ãcõrẽba ne ununaca obi b̶ad̶a bacuruda. ");
INSERT INTO empNTpo_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Moise wãbʌrʌd̶e Ãcõrẽba idjía jarasia: –Egiptod̶e jũẽped̶a jũma ne ununaca mʌ̃a obi b̶ʌda Egiptod̶ebema boro quĩrãpita odua. Baribʌrʌ mʌ̃a idjira so zarea b̶ʌya israelerã ẽdrʌ b̶ʌrãmãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Mãwãnacarea Egiptod̶ebema boroa jaradua: “Ãcõrẽba nãwã jara b̶ʌa: mʌ̃a Israel purura mʌ̃ umaquĩrã warra dji nabemaana abaria. ");
INSERT INTO empNTpo_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Maʌ̃ carea mʌ̃a jara b̶ʌa: mʌ̃ warrara ẽdrʌ b̶ʌdua mʌ̃́a animarãda babue diad̶e wãmãrẽã. Baribʌrʌ bʌa jarasia ẽdrʌ b̶ʌẽ́da. Maʌ̃ carea bʌ umaquĩrã warra dji nabemada beuya.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Moise idji warrarã bara Egiptod̶aa wãbʌdad̶e ota cãĩsid̶aa. Mama Ãcõrẽra ãdjimaa zesia. Maʌ̃ne idjia Moisera beai basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Baribʌrʌ Moise quima Seporába ãdji warra zaque cacuara neco mõgara od̶aba wẽãgosia. Maʌ̃ e wẽãgod̶ara Moise jĩrũ caita cob̶ʌsia. Maʌ̃ bẽrã Ãcõrẽba Moisera beaẽ́ basía. Maʌ̃ carea Seporába Moisea jarasia: –Wãrãda bʌra mʌ̃ quima arada b̶esia warra zaque cacua wẽãgod̶a oad̶eba zocai b̶ed̶a bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Maʌ̃ naẽna Ãcõrẽba Aaroʌ̃a jarasia: –Ẽjũã põãsa ewaraga b̶ʌd̶e Moise acʌd̶e wãdua.– Ara maʌ̃da Aaroʌ̃ra wãped̶a Moisera unusia Ãcõrẽ eya abadama. Unuped̶a b̶ʌsrid̶aba idji uridarrad̶e isõsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Maʌ̃be Moiseba Aaroʌ̃a jũma nẽbʌrʌsia Ãcõrẽba Egiptod̶e jarabi b̶ʌda idjab̶a ne ununaca obi b̶ʌ sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Egiptod̶e jũẽnaped̶a Moisera Aaroʌ̃ sid̶a israelerã bororã ume ãbaa dji jʌresid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Maʌ̃ne Aaroʌ̃ba ãdjirãa nẽbʌrʌsia jũma Ãcõrẽba Moisea jarad̶ada. Idjab̶a ne ununaca Ãcõrẽba obicuad̶ara ãdjirã quĩrãpita osia. ");
INSERT INTO empNTpo_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Maʌ̃ bẽrã Aaroʌ̃ba jarad̶ara ĩjãsid̶aa. Ãcõrẽba ãdji bia mĩga panʌda unuped̶a ãdjirã carebai carea b̶ʌda ĩjãsid̶aa. Maʌ̃ bẽrã chĩrãborod̶e b̶arru copanenaped̶a Ãcõrẽa bia bed̶easid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Mãwãnacarea Moisera, Aaroʌ̃ sid̶a Egiptod̶ebema boromaa wãnaped̶a jarasid̶aa: –Israelerã Ãcõrẽba nãwã jara b̶ʌa: “Mʌ̃ purura ẽjũã põãsa ewaraga b̶ʌd̶e idu wãbidua mʌ̃́a animarãda babue diad̶amãrẽã.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Maʌ̃ne Egiptod̶ebema boroba panusia: –¿Cai maʌ̃ Ãcõrẽ mãwã idjia israelerã idu wãbiduad̶a ad̶ara mʌ̃a ĩjãi carea? Mʌ̃a idjira adua b̶ʌa. Maʌ̃ bẽrã mʌ̃a bãrã israelerãra idu wãbiẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Moiseba Aaroʌ̃ bid̶a jarasid̶aa: –Dai hebreorã Ãcõrẽda daima odjaped̶a jarasia idji itea animarãda babue diad̶e wãnamãrẽã. Maʌ̃ bẽrã dairãra ẽjũã põãsa ewaraga b̶ʌd̶e ewari ũbea idu wãbidua mãwã od̶i carea. Mãwã od̶aẽ́bʌrʌ, Ãcõrẽba dairãra cacua biẽ́ b̶ʌped̶a quinibiya wa necoba quenabiya. ");
INSERT INTO empNTpo_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","5","Baribʌrʌ Egiptod̶ebema boroba jarasia: –¡Moise, Aaroʌ̃! Israelerãra zocãrã panʌa. ¿Cãrẽ cãrẽã bãrãba ãdjirã trajura obi ama panʌ? Bãrã israelerãra jũma trajad̶e wãbʌrʌd̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ara maʌ̃ ewarid̶e Egiptod̶ebema boroba dji traju obibada bororãa, dji traja panʌ bororã israelerãa bid̶a jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","–Id̶iba ʌ̃taa israelerãa chiruada waa diarãnadua. Ãdjirãbʌrʌ chiruara jʌrʌ ped̶e wãnaped̶a de obada mõgarara od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Baribʌrʌ wad̶ibid̶a ãdjia o panana quĩrãca obid̶adua. Ni ab̶a bid̶a ed̶aara od̶iẽ́ panʌa. Ãdjirãra coaid̶a tab̶ea bẽrã nãwã jara panʌa: “Dairãra idu wãbidua dai Ãcõrẽa animarãda babue diacuad̶i carea.” ");
INSERT INTO empNTpo_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Israelerãra wetara trajabid̶adua bari b̶earãnamãrẽã. Mãwã ãdjirãba Moise sewara ĩjãnaẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ara maʌ̃da dji traju obibada bororãra, dji traja panʌ bororã israelerã sid̶a Egiptod̶ebema boromaʌba ẽdrʌd̶aped̶a israelerãa nãwã jarad̶e wãsid̶aa: –Egiptod̶ebema boroba nãwã jara b̶ʌa: “Mʌ̃a waa chiruara diabiẽ́a de obada mõgara od̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Bãdjiabʌrʌ chiruara jʌrʌ ped̶e wãnida panʌa bãdjia jʌrʌbʌdamaa. Baribʌrʌ naãrã o panana quĩrãca od̶ida panʌa. Ni ab̶a bid̶a ed̶aara od̶iẽ́ panʌa.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Maʌ̃ bẽrã israelerãba jũma Egipto druad̶e chiruara jʌrʌ ped̶e wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Mãwã dji traju obibada bororãba israelerãra wetara trajabisid̶aa. Nãwã jarasid̶aa: –Ewariza daucha od̶adua naẽna chirua diabadjid̶ad̶e o panana quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Idjab̶a dji traju obibada bororãba dji traja panʌ bororã israelerãda ubadjid̶aa ãdjia b̶ʌped̶ad̶amĩna. Dji traju obibada bororãba ãdjirãa iwid̶ibadjid̶aa: –¿Sãwãẽrã nuena, id̶i bid̶a bãrãba de obada mõgarara daucha od̶aẽ́ panʌ? Naẽna bãrãba ewariza daucha obadjid̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Maʌ̃ bẽrã dji traja panʌ bororã israelerãra Egiptod̶ebema boromaa wãnaped̶a nãwã jarasid̶aa: –Dairã bʌ nezocarãra bʌa jãwã oiẽ́ b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Id̶ira chiruada diad̶aẽ́ panʌa, baribʌrʌ wad̶ibid̶a dji traju obibada bororãba de obada mõgarara ab̶arica daucha obi panʌa. Mãwã poya od̶aẽ́ panʌ carea ãdjirãba dairãra ubadaa. Baribʌrʌ dairãra bed̶ead̶e panʌẽ́a, ãtebʌrʌ bʌa b̶ʌcuad̶a traju obibada bororãda bed̶ead̶e panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Maʌ̃ne Egiptod̶ebema boroba panusia: –Bãrãra coaid̶a tab̶eaa. Maʌ̃ bẽrã nãwã jara panʌa: “Dairãra wãnia Ãcõrẽa animarãda babue diacuad̶i carea.” ");
INSERT INTO empNTpo_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Wãnadua bãdji trajud̶aa. Daiba chiruara bãrãa waa diad̶aẽ́a. Baribʌrʌ bãrãba de obada mõgarara naãrã o panana quĩrãca od̶ida panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Maʌ̃ ũrĩsid̶ad̶e dji traja panʌ bororãba cawasid̶aa nẽbʌrad̶e panʌda. ");
INSERT INTO empNTpo_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ãdjirã Egiptod̶ebema boromaʌba ẽdrʌbʌdad̶e unusid̶aa Moiseba Aaroʌ̃ bid̶a dajadaare ãdji jʌ̃ã panʌda. ");
INSERT INTO empNTpo_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Dji traja panʌ bororãba ãdjía jarasid̶aa: –Ãcõrẽba bãrãra cawa oya. Bãrãdrʌ bed̶ead̶e panʌa dairãra Egiptod̶ebema boro quĩrãpita, dji dromarã quĩrãpita bid̶a biẽ́ panebʌda carea. Id̶ibʌrʌ bãrãba dairãra quenabid̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Maʌ̃be Moiseba Ãcõrẽa iwid̶isia: –¡Mʌ̃ Boro! ¿Cãrẽ cãrẽã bʌ purura biẽ́ o b̶ʌ? ¿Cãrẽ cãrẽã mʌ̃ra diabuesi? ");
INSERT INTO empNTpo_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Mʌ̃a Egiptod̶ebema boro ume bʌ trʌ̃neba bed̶ead̶amĩna, maʌ̃ ewarid̶eba idjia Israel purura wetara biẽ́ o b̶ʌa. Maʌ̃ awara bʌa ẽdrʌ b̶ʌyad̶a ad̶ara wad̶ibid̶a oẽ́ b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Maʌ̃ne Ãcõrẽba Moisea panusia: –Id̶ibʌrʌ bʌa unuya sãwã mʌ̃a Egiptod̶ebema borora cawa oida. Mʌ̃ ʌb̶ʌad̶eba cawa o b̶ʌ carea idjia bãrã israelerãra idu wãbiya. Ab̶ed̶a bãrãra idji druad̶ebemada ãyã jʌrecuaya.– ");
INSERT INTO empNTpo_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Idjab̶a Ãcõrẽba jarasia: –Mʌ̃ra Ãcõrẽa. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Mʌ̃a Abrahaʌ̃a, Isaa, idjab̶a Jacoboa bid̶a cawabisia mʌ̃ra ne jũma poya obari Ãcõrẽda. Baribʌrʌ mʌ̃ trʌ̃ Jehová abadada ãdjirãa cawabiẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Mʌ̃ra ãdjirã ume bed̶ea b̶ʌsia Canaaʌ̃ druara ãdjirãa diai carea. Mama ãdjirãra drua ãĩbemarã quĩrãca panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Baribʌrʌ mʌ̃a ũrĩ b̶ʌa israelerãra mĩã sopua bed̶ea panʌda egiptorãba ãdjira õgo trajabi panʌ bẽrã. Maʌ̃ awara mʌ̃a quĩrãdoaẽ́ b̶ʌa ãdji drõã naẽnabemarã ume bed̶ea b̶ʌd̶ara. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Jãʌ̃be israelerãa jaradua: “Mʌ̃ra Ãcõrẽa. Mʌ̃ ʌb̶ʌad̶eba ne waib̶ʌada oya egiptorã cawa oi carea. Mãwã mʌ̃a bãrãra Egiptod̶e bia mĩga traja panʌnebemada ẽdrʌ b̶ʌya. Egiptorã jʌwaed̶a panʌnebemada ẽdrʌ b̶ʌya. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Mʌ̃a bãrãra mʌ̃ puru babiya. Maʌ̃ne mʌ̃ra bãrã Ãcõrẽ baya. Mãwã bãrãba cawad̶ia mʌ̃drʌ bãrã Ãcõrẽda, mʌ̃a bãrãra Egiptod̶e bia mĩga traja panʌnebemada ẽdrʌ b̶ʌd̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Bãrãra mʌ̃a diai jarad̶a ẽjũãnaa edeya. Maʌ̃ ẽjũãra mʌ̃a Abrahaʌ̃a, Isaa, idjab̶a Jacoboa bid̶a wãrãneba diai jarasia. Mʌ̃ra Ãcõrẽ bẽrã maʌ̃ ẽjũãra diaya bãrãne bamãrẽã.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Jũma maʌ̃gʌra Moiseba israelerãa jarasia. Mãwãmĩna ĩjãnaẽ́ basía. Ãdjirãra sopua panasid̶aa Moiseba naẽna jarad̶a ĩjã panʌ carea wetara mĩga traja panesid̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Maʌ̃be Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","–Egiptod̶ebema boromaa wãped̶a jaradua israelerãra idji druad̶ebemada idu ẽdrʌbimãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Baribʌrʌ Moiseba Ãcõrẽa jarasia: –Israelerãba mʌ̃ bed̶eada ĩjãnaẽ́ panʌa. Mʌ̃ra warrá bed̶eaca bẽrã ¿Egiptod̶ebema boroba mʌ̃ bed̶eara ĩjãica?– ");
INSERT INTO empNTpo_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Moiseba mãwã jarad̶amĩna Ãcõrẽba idjira Aaroʌ̃ sid̶a israelerãmaa idjab̶a Egiptod̶ebema boromaa diabuesia. Maʌ̃ne jarasid̶aa Ãcõrẽba ãdjira diabuesida israelerã Egiptod̶eba ẽdrʌ eded̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Israeld̶eba yõped̶ad̶arã bororãda naʌ̃gʌrã basía: Rubeʌ̃ra Israel warra iwina basía. Rubeʌ̃ warrarãra naʌ̃gʌrã basía: Hanoc, Palú, Hezroʌ̃, idjab̶a Carmi. Maʌ̃gʌrãra Rubeʌ̃neba yõped̶ad̶a bororã basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeoʌ̃ warrarãra naʌ̃gʌrã basía: Jemuel, Jamiʌ̃, Ohad, Jaquiʌ̃, Zoha, idjab̶a Saul. Saulora cananeo wẽrãba tod̶a basía. Maʌ̃gʌrãra Simeoʌ̃neba yõped̶ad̶a bororã basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Levi jaid̶asid̶e 137 poa b̶asia. Levi warrarãra dji nabemaneba ab̶a dji tẽãbemanaa naʌ̃gʌrã basía: Gersoʌ̃, Coá, idjab̶a Merari. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gersoʌ̃ warrarãra naʌ̃gʌrã basía: Libni idjab̶a Simei. Ãdjira Gersoʌ̃neba yõped̶ad̶a bororã basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Coá jaid̶asid̶e 133 poa b̶asia. Coá warrarãra naʌ̃gʌrã basía: Amraʌ̃, Izhar, Hebroʌ̃, idjab̶a Uziel. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari warrarãra naʌ̃gʌrã basía: Mahli idjab̶a Musi. Jũma maʌ̃gʌrãra Levi warrarã basía dji nabemaneba ab̶a dji tẽãbemanaa ãdji warrarã bara. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amraʌ̃da idji apipi Jocabé ume dji edasid̶aa. Jocabéba warrada umé tosia. Ab̶a Aaroʌ̃ basía, ab̶a Moise basía. Amraʌ̃ jaid̶asid̶e 137 poa b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Izar warrarãra naʌ̃gʌrã basía: Core, Nepeg, idjab̶a Zicri. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uziel warrarãra naʌ̃gʌrã basía: Misael, Elzapaʌ̃, idjab̶a Sitri. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaroʌ̃ra Elisabe ume dji edasid̶aa. Elisabera Aminadá cau basía, Naasoʌ̃ djabawẽrã basía. Idjia warrada quĩmãrẽ tosia. Ãdjirã trʌ̃ra naʌ̃gʌrã basía: Nadá, Abiu, Eleaza, idjab̶a Itamar. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Core warrarãra naʌ̃gʌrã basía: Asir, Elcana, idjab̶a Abiasá. Maʌ̃ ũbeara Cored̶eba yõped̶ad̶a bororã basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aaroʌ̃ warra Eleazara Putiel cau ume dji edasid̶aa. Maʌ̃ wẽrãba warrada tosia. Dji warrara trʌ̃ b̶ʌsia Piné. Jũma maʌ̃gʌrãra Levid̶eba yõped̶ad̶a bororã basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ãcõrẽba maʌ̃ Aaroʌ̃a, Moisea bid̶a jarasia israelerã Egiptod̶eba ẽdrʌ eded̶amãrẽã sordaorã djõne wãbada quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ãdjidrʌ Egiptod̶ebema boro ume bed̶easid̶aa israelerã Egiptod̶eba ẽdrʌ eded̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","29","Egiptod̶e Ãcõrẽba Moisea jarasia: –Mʌ̃ra Ãcõrẽa. Mʌ̃a bʌ́a jarabʌrʌda Egiptod̶ebema boroa jũma jaradua.– ");
INSERT INTO empNTpo_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Baribʌrʌ Moiseba Ãcõrẽa jarasia: –Mʌ̃ra warrá bed̶eacaa. ¿Mʌ̃a jarabʌrʌra Egiptod̶ebema boroba ũrĩca?– ");
INSERT INTO empNTpo_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Maʌ̃ne Ãcõrẽba Moisea jarasia: –Ũrĩdua. Mʌ̃a Egiptod̶ebema boroa bʌra ãcõrẽ quĩrãca unubiya. Maʌ̃ne bʌ djaba Aaroʌ̃ra bʌd̶eba bed̶eabarida b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Mʌ̃a jarabi b̶ʌda bʌ djaba Aaroʌ̃a jũma jaradua. Maʌ̃gʌra idjia Egiptod̶ebema boroa jaraya bãrã israelerãra idji druad̶eba idu ẽdrʌbimãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Baribʌrʌ mʌ̃a Egiptod̶ebema borora so zarea b̶ʌya. Maʌ̃be Egiptod̶e mʌ̃a ne ununacada zocãrã ocuaya cawabi carea mʌ̃drʌ dji dromaara b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Baribʌrʌ bãrãba jara panʌra Egiptod̶ebema boroba ĩjãẽ́a. Maʌ̃ bẽrã mʌ̃ ʌb̶ʌad̶eba mʌ̃a ne ununaca waib̶ʌa b̶eada oya egiptorã cawa oi carea. Mãwã mʌ̃ puru Israelera Egipto druad̶eba ẽdrʌ edeya sordaorã djõne wãbada quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Mʌ̃ ʌb̶ʌad̶eba mʌ̃a egiptorã cawa obʌrʌd̶e idjab̶a israelerã Egiptod̶eba ẽdrʌ edebʌrʌd̶e egiptorãba cawad̶ia mʌ̃drʌ Ãcõrẽda.– ");
INSERT INTO empNTpo_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Maʌ̃be Moiseba Aaroʌ̃ bid̶a osid̶aa Ãcõrẽba jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Egiptod̶ebema boro ume bed̶ead̶e wãsid̶ad̶e Moisera 80 poa b̶asia. Aaroʌ̃ra 83 poa b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ãcõrẽba Moisea Aaroʌ̃a bid̶a jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","–Egiptod̶ebema boroba jaraya ne ununacada od̶amãrẽã bãrãba jara panʌra ĩjãi carea. Ne ununacada od̶aduad̶a abʌrʌd̶e Aaroʌ̃a jaradua idji bacurura dji boro quĩrãpita egode b̶aebimãrẽã. Maʌ̃ne bacurura dama ba dogoya.– ");
INSERT INTO empNTpo_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ara maʌ̃da Moisera Aaroʌ̃ sid̶a Egiptod̶ebema boromaa wãnaped̶a Ãcõrẽba jarad̶a quĩrãca osid̶aa. Aaroʌ̃ba idji bacurura egode b̶aebisia Egiptod̶ebema boro quĩrãpita, Egiptod̶ebema dji dromarã quĩrãpita bid̶a. Ara maʌ̃da bacurura dama ba dogosia. ");
INSERT INTO empNTpo_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Baribʌrʌ Egiptod̶ebema boroba idji druad̶ebema ne cawa b̶eada, daubararã sid̶a trʌ̃cuasia. Maʌ̃ne ãdjia bid̶a necawaad̶eba Aaroʌ̃ba od̶a quĩrãca osid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ãdji bacurura egode b̶aebibʌdad̶e dama bacuasid̶aa. Baribʌrʌ Aaroʌ̃ bacuru dama bad̶aba ãdji bacuru dama bacuad̶ara mĩcuasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Mãwã ununamĩna Egiptod̶ebema borora so zarea b̶esia Ãcõrẽba jarad̶a quĩrãca. Maʌ̃ bẽrã Moiseba Aaroʌ̃ bid̶a jaraped̶ad̶ara ĩjãẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Maʌ̃be Ãcõrẽba Moisea jarasia: –Egiptod̶ebema borora so zarea b̶ʌa. Maʌ̃ bẽrã israelerãra ẽdrʌbueẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","16","Jãʌ̃be nu diaped̶a Egiptod̶ebema boro doed̶a wãbʌrʌd̶e idjimaa wãdua. Dama bad̶a bacurura bʌ jʌwad̶e ededua. Do icawa Egiptod̶ebema boro quĩrãpita nũmeped̶a jaradua: “Dai hebreorã Ãcõrẽba mʌ̃ra bʌmaa diabuesia. Idjia nãwã jara b̶ʌa: mʌ̃ puru Israelera idu wãbidua ẽjũã põãsa ewaraga b̶ʌd̶aa. Mama ãdjirãba mʌ̃́a animarãda babue diad̶ida panʌa. Mʌ̃a mãwã jara b̶ʌmĩna bʌa wad̶ibid̶a ĩjãẽ́ b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Maʌ̃ bẽrã Ãcõrẽba nãwã jara b̶ʌa: naʌ̃gʌd̶eba bʌa cawaya mʌ̃drʌ Ãcõrẽda; Moiseba jʌwad̶e erob̶ʌ bacuruba mʌ̃a Nilo dod̶e tawebiya. Maʌ̃ne dora ab̶ed̶a oa baya. ");
INSERT INTO empNTpo_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Maʌ̃ba b̶edara jũma quininia. Dora ab̶ed̶a mĩguia b̶ai bẽrã, bãrã egiptorãba baidora poya dod̶aẽ́a.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Idjab̶a Ãcõrẽba Moisea jarasia: –Aaroʌ̃a jaradua bʌ bacuruda edamãrẽã. Idjia maʌ̃ bacuru ʌ̃taa wabʌrʌd̶e jũma Egiptod̶e b̶ʌ baidora oa baya. Dora, do zaquera, amenera, baido juebada uriad̶e b̶ʌra, zoco waib̶ʌad̶e jue erob̶eara, jiadod̶e jue erob̶ea sid̶a jũma oa baya.– ");
INSERT INTO empNTpo_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moiseba Aaroʌ̃ bid̶a Ãcõrẽba jarad̶a quĩrãca osid̶aa. Moise jʌwad̶e b̶ad̶a bacuruda Aaroʌ̃ba edaped̶a ʌ̃taa wasia. Ʌ̃taa waped̶a Nilo dod̶e tawesia Egiptod̶ebema boro quĩrãpita, Egiptod̶ebema dji dromarã quĩrãpita bid̶a. Ara maʌ̃da dora oa basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Maʌ̃ba b̶edara jũma quinisid̶aa. Dora mĩguia b̶ed̶a bẽrã egiptorãba baidora poya dod̶aẽ́ basía. Ab̶ed̶a jũma Egipto druad̶e baidora oa basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Baribʌrʌ Egiptod̶ebema daubararãba ãdji necawaad̶eba ab̶arica baidora oa babisid̶aa. Maʌ̃ bẽrã Egiptod̶ebema borora so zarea b̶esia. Moiseba Aaroʌ̃ ume jaraped̶ad̶ara idjia ĩjãẽ́ basía Ãcõrẽba jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Maʌ̃ ne ununacara ununamĩna ne crĩchaẽ́ diguid̶aa wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Maʌ̃be egiptorãba do icawa corosid̶aa baido biada ununi carea. Mãwã osid̶aa doed̶abema baidora poya dod̶aẽ́ bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ãcõrẽba Nilo do oa babid̶acarea siete ewari b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Maʌ̃ne Ãcõrẽba Moisea jarasia: –Egiptod̶ebema boroa nãwã jarad̶e wãdua: “Ãcõrẽba nãwã jara b̶ʌa: mʌ̃ purura idu wãbidua mʌ̃́a animarã babue diad̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Baribʌrʌ bʌa mʌ̃ puruda idu wãbiẽ́bʌrʌ mʌ̃a cawa oya. Jũma bʌ druara baujĩãba birabiya. ");
INSERT INTO empNTpo_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Nilo dora baujĩãba biraya. Maʌ̃ne doed̶aʌba baujĩãra bʌ diguid̶aa wãbʌrʌd̶ia. Mãwã bʌ cãĩbarima, bʌ cʌd̶ad̶e, dji dromarã ded̶e, bʌ druad̶ebemarã ded̶e bid̶a baujĩãra baraya. Baujĩãra bãrã paʌ̃ ãbubadad̶e, bãrã paʌ̃ bʌratʌbadad̶e bid̶a baraya. ");
INSERT INTO empNTpo_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Bʌ ʌ̃rʌ̃, dji dromarã ʌ̃rʌ̃, bʌ druad̶ebemarã ʌ̃rʌ̃ bid̶a baujĩãra jʌ̃drʌcuad̶ia.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Maʌ̃be Ãcõrẽba Moisea jarasia: –Aaroʌ̃a nãwã jaradua: “Bʌ jʌwad̶e erob̶ʌ bacurura dojã ʌ̃rʌ̃, do zaque ʌ̃rʌ̃, amene ʌ̃rʌ̃, baido juebada uria ʌ̃rʌ̃ bid̶a ʌ̃taa wadua. Mãwã baidod̶eba baujĩãda jũma Egipto druad̶e odjacuaya.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ara maʌ̃da Aaroʌ̃ba idji bacurura Egiptod̶ebema do ʌ̃rʌ̃ wasia. Maʌ̃ne baujĩãra doed̶aʌba odjacuad̶aped̶a jũma Egipto druara birasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Baribʌrʌ Egiptod̶ebema daubararãba ãdji necawaad̶eba ab̶arica osid̶aa. Ãdjirã bid̶a baujĩãda doed̶aʌba Egipto druad̶e odjabisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Maʌ̃be Egiptod̶ebema boroba Moisera Aaroʌ̃ sid̶a trʌ̃biped̶a ãdjía nãwã jarasia: –Ãcõrẽa iwid̶id̶adua naʌ̃ baujĩãra mʌ̃nebemada idjab̶a mʌ̃ purud̶ebemada ãyã wãbimãrẽã. Maʌ̃bebʌrʌ mʌ̃a bãrã israelerãra idu wãbiya Ãcõrẽa animarã babue diacuad̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moiseba panusia: –Bia b̶ʌa. Jaradua sãʌ̃be bʌa quĩrĩã b̶ʌda mʌ̃a Ãcõrẽa iwid̶ida bʌ carea, dji dromarã carea, idjab̶a bʌ druad̶ebemarã carea bid̶a. ¿Sãʌ̃be quĩrĩã b̶ʌ mʌ̃a Ãcõrẽa iwid̶ida naʌ̃ baujĩãra bʌd̶ebemada, bʌ diguid̶abema sid̶a jõbimãrẽã? Iwid̶isira ab̶abe doed̶abʌrʌ baujĩãra baraa baya.– ");
INSERT INTO empNTpo_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Egiptod̶ebema boroba panusia: –Nu iwid̶idua.– Moiseba jarasia: –Bʌa jara b̶ʌ quĩrãca oya. Mãwã bʌa cawaya dewara ãcõrẽra neẽ́da dai Boro Ãcõrẽ quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Nu bʌ diguid̶a, dji dromarãma, bʌ druad̶ebema ẽberãrãma bid̶a baujĩãra neẽ́ b̶aya. Baujĩãra ab̶abe doed̶abʌrʌ baraa baya.– ");
INSERT INTO empNTpo_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Maʌ̃be Moisera Aaroʌ̃ sid̶a Egiptod̶ebema boromaʌba ẽdrʌsid̶aa. Nurẽma Moiseba Ãcõrẽa iwid̶isia baujĩã Egiptod̶ebema boromaa diabued̶ara jõbimãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ara maʌ̃da Ãcõrẽba Moiseba iwid̶id̶a quĩrãca osia. Baujĩãra egiptorã ded̶e, ud̶a bid̶a, ãdji ẽjũãne bid̶a jũma quinisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Maʌ̃be egiptorãba baujĩã quininara ãbaa boromea bue nũmʌsid̶aa. Maʌ̃ba Egipto druara jũma mĩguia nũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Egiptod̶ebema boroba unusia baujĩãba waa mĩã sẽnaẽ́ panʌda. Maʌ̃ bẽrã idjira so zareaped̶a Moiseba Aaroʌ̃ bid̶a jaraped̶ad̶ara ĩjãẽ́ basía Ãcõrẽba jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Maʌ̃be Ãcõrẽba Moisea jarasia: –Aaroʌ̃a jaradua idji jʌwad̶e erob̶ʌ bacuruda ʌ̃taa waped̶a egorod̶aa umãrẽã. Maʌ̃ne egoro porara pochĩdau baya jũma Egipto druad̶e.– ");
INSERT INTO empNTpo_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ara maʌ̃da ãdjia mãwã osid̶aa. Aaroʌ̃ba idji bacurura ʌ̃taa waped̶a egorod̶aa usía. Maʌ̃ne egoro porara pochĩdau basía jũma Egipto druad̶e. Ab̶ed̶a ẽberãrãra, animarã sid̶a pochĩdauba ca eropanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Maʌ̃be Egiptod̶ebema daubararãba ãdji necawaad̶eba ab̶ari quĩrãca pochĩdauda o quĩrĩãsid̶aa. Mãwãmĩna poya od̶aẽ́ basía. Mãwã panʌne ẽberãrãra, animarã sid̶a pochĩdauba ca eropanasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Maʌ̃ bẽrã daubararãba Egiptod̶ebema boroa jarasid̶aa: –Moiseba Aaroʌ̃ ume pochĩdau oped̶ad̶ara Ãcõrẽ ʌb̶ʌad̶eba osid̶aa.– Mãwã jaraped̶ad̶amĩna Egiptod̶ebema borora so zarea b̶esia. Idjia ĩjãẽ́ basía Moiseba Aaroʌ̃ bid̶a jaraped̶ad̶ara Ãcõrẽba jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Maʌ̃be Ãcõrẽba Moisea jarasia: –Nu diaped̶ed̶a piradrʌped̶a Egiptod̶ebema boro doed̶a wãbʌrʌd̶e idjimaa wãped̶a nãwã jaradua: “Ãcõrẽba nãwã jara b̶ʌa: mʌ̃ purura idu wãbidua mʌ̃́a animarãda babue diad̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Baribʌrʌ mʌ̃ puruda idu wãbiẽ́bʌrʌ, mʌ̃a ĩgananada bʌmaa, dji dromarãmaa, bʌ druad̶ebemarãmaa bid̶a quĩrãtanoa diabueya. Maʌ̃ ĩgananara jũma Egiptod̶ebema ded̶e, ãdjirã wãbʌdama bid̶a powuaga nũmaya. ");
INSERT INTO empNTpo_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","23","Baribʌrʌ maʌ̃ ewarid̶e Goseʌ̃ druad̶e mʌ̃a mãwã oẽ́a. Mʌ̃ ẽberãrãda mama panʌ bẽrã ĩgananara neẽ́ baya. Mʌ̃ purura bʌ puru quĩrãca oẽ́a. Maʌ̃ba bʌa cawaya mʌ̃abʌrʌ naʌ̃ druad̶e mãwã o b̶ʌda. Maʌ̃ ne ununacara nu oya.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Nurẽma Ãcõrẽba mãwã osia. Egiptod̶ebema boro dera, dji dromarã dera, idjab̶a jũma Egipto drua sid̶a ĩganana quĩrãtanoaba birasia. Ab̶ed̶a jũma Egipto druara biẽ́ nũmesia ĩgananaba. ");
INSERT INTO empNTpo_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Maʌ̃be Egiptod̶ebema boroba Moisera, Aaroʌ̃ sid̶a trʌ̃biped̶a nãwã jarasia: –Bãrã Ãcõrẽa animarãda babue diad̶e wãnida panʌa ara naʌ̃ Egipto druad̶e.– ");
INSERT INTO empNTpo_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Baribʌrʌ Moiseba panusia: –Dairãba naʌ̃ Egipto druad̶e mãwã poya od̶aẽ́a, animarã dairãba Ãcõrẽa babue diad̶ida panʌra bãrã egiptorãba idu babue diabid̶aca bẽrã. Maʌ̃ animarãda bãrã quĩrãpita Ãcõrẽa babue diad̶ibʌrʌ, ¿bãrãba dairãra mõgaraba tab̶ari bead̶aẽ́ca? ");
INSERT INTO empNTpo_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Maʌ̃ bẽrã dairãra ewari ũbea ẽjũã põãsa ewaraga b̶ʌd̶e wãnia. Mamabʌrʌ dai Ãcõrẽa animarãda babue diacuad̶ia idjia jara b̶ʌ quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Maʌ̃be Egiptod̶ebema boroba jarasia: –Mãẽteara bia b̶ʌa. Mʌ̃a bãrãra ẽjũã põãsa ewaraga b̶ʌd̶aa idu wãbiya bãrã Ãcõrẽa animarãda babue diacuad̶amãrẽã. Baribʌrʌ bãrãra tʌmʌ wãcara panʌa. Idjab̶a mʌ̃ carea bid̶a Ãcõrẽa iwid̶id̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moiseba jarasia: –Mʌ̃ra namaʌba ẽdrʌped̶a Ãcõrẽa iwid̶iya. Maʌ̃be nu ĩgananara neẽ́ baya bʌma, dji dromarãma, bʌ druad̶ebemarãma bid̶a. Baribʌrʌ dairãra waa cũrũgarãdua. Dairãra idu wãbidua Ãcõrẽa animarãda babue diacuad̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Moisera Egiptod̶ebema boromaʌba ẽdrʌped̶a Ãcõrẽa iwid̶isia. ");
INSERT INTO empNTpo_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ara maʌ̃da Ãcõrẽba Moiseba iwid̶id̶a quĩrãca osia. Idjia ĩgananara jõbisia Egiptod̶ebema boroma, dji dromarãma, idjab̶a Egipto druad̶ebemarãma bid̶a. Ni ab̶a bid̶a b̶eẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Baribʌrʌ Egiptod̶ebema borora wad̶ibid̶a so zarea b̶ed̶a bẽrã israelerãra idu wãbiẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Maʌ̃be Ãcõrẽba Moisea jarasia: –Egiptod̶ebema boroa nãwã jarad̶e wãdua: “Dai hebreorã Ãcõrẽba nãwã jara b̶ʌa: mʌ̃ purura idu wãbidua mʌ̃́a animarãda babue diad̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","3","Baribʌrʌ bʌa dai israelerãda idu wãbiẽ́bʌrʌ ãtebʌrʌ naʌ̃ druad̶e b̶ebibʌrʌ, Ãcõrẽba bãrã animarãra idji ʌb̶ʌad̶eba quinibiya. Bãrã cawayoda, burroda, cameyoda, pacada, oveja sid̶a quininia. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Baribʌrʌ Ãcõrẽba animarã dai israelerãneda mãwã oẽ́a. Dai animarãra ni ab̶a bid̶a beud̶aẽ́a egiptorã animarã quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ãcõrẽba ewarida b̶ʌsia naʌ̃ Egiptod̶e mãwã oi carea. Nubʌrʌ mãwã oya.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Nurẽma Ãcõrẽba mãwã osia. Jũma egiptorã animarãra quinisid̶aa. Baribʌrʌ israelerã animarãra ni ab̶a bid̶a beud̶aẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Egiptod̶ebema boroba ẽberãrãda israelerã animarã acʌd̶e diabuesia. Wãnaped̶a unusid̶aa israelerã animarãra ni ab̶a bid̶a beud̶aẽ́ basida. Baribʌrʌ Egiptod̶ebema boroba maʌ̃da cawasimĩna so zarea b̶esia. Maʌ̃ bẽrã israelerãra idu wãbiẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Maʌ̃be Ãcõrẽba Moisea, Aaroʌ̃a bid̶a jarasia: –Jãʌ̃be tʌbʌ porada jʌwad̶e edad̶aped̶a Egiptod̶ebema boro quĩrãpita ʌ̃taa jãmãpod̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Maʌ̃ tʌbʌ porara jũma Egipto druad̶e cowa nũmaya. Maʌ̃ba Egipto druad̶e ẽberãrãra animarã sid̶a jũma cabʌba biracuaya.– ");
INSERT INTO empNTpo_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ara maʌ̃da Moiseba Aaroʌ̃ ume tʌbʌ porada edad̶aped̶a Egiptod̶ebema boromaa wãsid̶aa. Jũẽnaped̶a Moiseba tʌbʌ porara idji quĩrãpita ʌ̃taa jãmãposia. Ara maʌ̃da ẽberãrãra animarã sid̶a jũma cabʌba biracuasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Maʌ̃ne Egiptod̶ebema daubararãra Moise quĩrãpita poya wãnaẽ́ basía ãdjirã sid̶a waabemarã quĩrãca cabʌba jũma biraped̶ad̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Baribʌrʌ Ãcõrẽba Egiptod̶ebema borora so zarea b̶ʌsia. Maʌ̃ bẽrã Moiseba Aaroʌ̃ bid̶a jaraped̶ad̶ara ĩjãẽ́ basía Ãcõrẽba jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Maʌ̃be Ãcõrẽba Moisea jarasia: –Nu diaped̶a Egiptod̶ebema boromaa wãped̶a jaradua: “Dai hebreorã Ãcõrẽba nãwã jara b̶ʌa: mʌ̃ purura idu wãbidua mʌ̃́a animarãda babue diad̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Baribʌrʌ bʌa mãwã oẽ́bʌrʌ mʌ̃ ʌb̶ʌad̶eba bʌra, dji dromarãra, jũma bʌ druad̶ebemarã sid̶a wetara mĩgabiya. Mãwã bʌa cawaya mʌ̃a obari quĩrãca naʌ̃ ẽjũãne neẽ́da. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Wãrãda naʌ̃ naẽna mʌ̃ ʌb̶ʌad̶eba bʌra, bʌ druad̶ebemarã sid̶a jũma quinibida b̶asia ni ab̶a bid̶a naʌ̃ ẽjũãne b̶erãmãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Baribʌrʌ mʌ̃a mãwã oẽ́ b̶ʌa. Mʌ̃a bʌra zocai b̶ʌsia bʌ mĩgabi b̶ʌd̶eba mʌ̃ ʌb̶ʌada unubi carea. Mãwã mʌ̃ra jũma naʌ̃ ẽjũãne trʌ̃ b̶ʌga b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Baribʌrʌ bʌa wad̶ibid̶a mʌ̃ puruda biẽ́ o b̶ʌa. Wad̶ibid̶a ãdjirãra idu wãbiẽ́ b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Maʌ̃ carea nu naʌ̃ horaca mʌ̃a hielo waib̶ʌada bajãneba jurrubiya. Egipto puru osid̶a ewarid̶eba wad̶ibid̶a hielora maʌ̃ quĩrãca jurrucaa. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Maʌ̃ bẽrã jũma bãrã animarãda de edre b̶ʌbicuadua. Mãwã oẽ́bʌrʌ hielo waib̶ʌa jurrubʌrʌba quenaya. Baridua ẽberãda, animarã sid̶a de edre b̶ead̶aẽ́bʌrʌ, hielo waib̶ʌa jurrubʌrʌba beaya.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ne wayaaba ʌ̃cʌrʌ Egiptod̶ebema dji dromarãba Ãcõrẽba jarad̶ara ĩjãsid̶aa. Maʌ̃ bẽrã ãdji nezocara, ãdji animarã sid̶a de edre isabe b̶ʌcuasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Baribʌrʌ ʌ̃cʌrʌ Egiptod̶ebema dji dromarãba Ãcõrẽba jarad̶ara ĩjãnaẽ́ basía. Maʌ̃ bẽrã ãdji nezocara, ãdji animarã sid̶a de edre b̶ʌcuad̶aẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Maʌ̃be Ãcõrẽba Moisea jarasia: –Bʌ jʌwara bajãnaa ʌ̃taa wadua. Maʌ̃ne jũma Egipto druad̶e hielora ẽberãrã ʌ̃rʌ̃, animarã ʌ̃rʌ̃, idjab̶a néud̶e bid̶a jurruzoaya.– ");
INSERT INTO empNTpo_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","24","Ara maʌ̃da Moiseba idji bacurura bajãnaa ʌ̃taa wasia. Maʌ̃ne Ãcõrẽba jũma Egipto druad̶e hieloda jurrubisia. Ab̶ed̶a baa bara b̶ae nũmesia. Egipto puru osid̶a ewarid̶eba maʌ̃ quĩrãca wad̶ibid̶a ununaca basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Maʌ̃ hielo waib̶ʌa jurrubʌrʌba Egipto druad̶e jũma de edre b̶ead̶aẽ́ra quenasia. Ẽberãrãda, animarãda, néu b̶ea sid̶a jũma quenasia. Bacuru sid̶a jũma ãrĩsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ab̶abe Goseʌ̃ druad̶e israelerã duanʌmaa hielora jurruẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Maʌ̃be Egiptod̶ebema boroba Moisera, Aaroʌ̃ sid̶a trʌ̃biped̶a ãdjía nãwã jarasia: –Id̶ibʌrʌ mʌ̃a cawasia biẽ́ o b̶ʌda. Ãcõrẽbʌrʌ jipa o b̶ʌa. Mʌ̃da, mʌ̃ puru sid̶a bed̶ead̶e panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Maʌ̃ bẽrã Ãcõrẽa iwid̶id̶adua naʌ̃ hielo jurru nũmʌra, baa sid̶a jõbimãrẽã. Maʌ̃be mʌ̃a israelerãra idu wãbiya. Waa ãdjirãra Egiptod̶e b̶ebiẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moiseba Egiptod̶ebema boroa jarasia: –Naʌ̃ purud̶eba ẽdrʌd̶acarea mʌ̃ jʌwara umena ʌ̃taa waped̶a Ãcõrẽa iwid̶iya. Maʌ̃ne hielo jurru nũmʌra, baa sid̶a jõya. Maʌ̃neba bʌa cawaya Ãcõrẽra naʌ̃ ẽjũã djibarida. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Baribʌrʌ mʌ̃a cawa b̶ʌa dji dromarãba, bʌa bid̶a wad̶ibid̶a Ãcõrẽra wayad̶aẽ́ panʌda.– ");
INSERT INTO empNTpo_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Egiptorãba u eropanana linoda põnõ b̶ad̶a bẽrã idjab̶a cebadada zau b̶ad̶a bẽrã hielo jurrubʌrʌba jũma ãrĩsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Baribʌrʌ ãdjirãba u eropanana trigora, centeno sid̶a wad̶i zauẽ́ b̶ad̶a bẽrã ãrĩẽ́ basía.) ");
INSERT INTO empNTpo_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Maʌ̃be Moisera Egiptod̶ebema boromaʌba ẽdrʌped̶a puru dajadaa wãsia. Mama idji jʌwara umena ʌ̃taa waped̶a Ãcõrẽa iwid̶isia. Ara maʌ̃da hielo jurru nũmanara, baara, cue sid̶a Egipto druad̶e cãbasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","35","Maʌ̃ unusid̶e Egiptod̶ebema boroba wayacusa biẽ́ osia. Idjida, dji dromarã sid̶a so zarea panena bẽrã israelerãra idu wãbiẽ́ basía Ãcõrẽba Moised̶eba jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","2","Maʌ̃be Ãcõrẽba Moisea jarasia: –Mʌ̃a Egiptod̶ebema borora, dji dromarã sid̶a so zarea b̶ʌsia ne ununacada ãdjirã tãẽna oi carea. Mãwãra bãrã warrarãa, bãrã wiuzaquerãa bid̶a nẽbʌrʌd̶ia sãwã maʌ̃ ne ununacad̶eba mʌ̃a unubisida egiptorãra siriẽ́ b̶eada. Mãwã bãrãba cawad̶ia mʌ̃drʌ Ãcõrẽda. Jãʌ̃be Egiptod̶ebema boromaa jarad̶e wãdua mʌ̃a ad̶ichichida zocãrã idji druad̶e b̶aebida.– ");
INSERT INTO empNTpo_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ara maʌ̃da Moisera Aaroʌ̃ sid̶a Egiptod̶ebema boromaa wãnaped̶a nãwã jarasid̶aa: –Dai hebreorã Ãcõrẽba nãwã jara b̶ʌa: “¿Bʌa sãʌ̃bebʌrʌ mʌ̃ra wayai? Mʌ̃ purura idu wãbidua mʌ̃́a animarãda babue diad̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Baribʌrʌ mʌ̃ puruda idu wãbiẽ́bʌrʌ, nu mʌ̃a ad̶ichichida bʌ druad̶e zocãrã b̶aebiya. ");
INSERT INTO empNTpo_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Maʌ̃ne bʌ druara ad̶ichichiba jũma biraya. Egorora ab̶ed̶a poya ununaẽ́a. Maʌ̃ ad̶ichichiba bãrã néu hieloba ãrĩnaẽ́ra jũma cod̶ia. Bacuru quedua sid̶a bãrã ẽjũãne ad̶ichichiba jũma cod̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Bʌ dera, dji dromarã dera, jũma waabema egiptorã de sid̶a ad̶ichichiba biraya. Bãrã drõã naẽnabemarãba, bãrã zeza bid̶a ununaca basía ad̶ichichira naʌ̃ quĩrãca b̶aebʌrʌda. Naʌ̃ druad̶e jũẽped̶ad̶a ewarid̶eba wad̶ibid̶a naʌ̃ quĩrãca ununacaa.”– Moiseba Egiptod̶ebema boroa mãwã jaraped̶a wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Maʌ̃be Egiptod̶ebema dji dromarãba dji boroa jarasid̶aa: –¿Bʌa wad̶ibid̶a jãʌ̃ ẽberãa idu dadjirãra mĩã sẽbi b̶aica? Israelerãra idu wãbidua ãdji Ãcõrẽa animarãda babue diad̶amãrẽã. ¿Bʌa wad̶ibid̶a adua b̶ʌca Egipto druara jũma ãrĩbʌrʌda?– ");
INSERT INTO empNTpo_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Maʌ̃be Egiptod̶ebema boroba Moisera Aaroʌ̃ sid̶a wayacusa trʌ̃biped̶a nãwã jarasia: –Bãrã Ãcõrẽa animarãda babue diad̶e wãnida panʌa. ¿Baribʌrʌ bãrãra jũmasãwã wãni?– ");
INSERT INTO empNTpo_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moiseba panusia: –Dairãra jũma wãnia. Warra zaquerãra, drõãrãra, dai warrarãra, dai caurã sid̶a wãnia. Dai animarã sid̶a eded̶ia. Dairãra jũma wãnia Ãcõrẽa animarã babue diad̶i bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","11","Baribʌrʌ Egiptod̶ebema boroba panusia: –Mãwãẽ́a. Ebud̶a b̶ʌa bãrãba biẽ́ o quĩrĩã panʌda. Ãcõrẽba bãrãra careba b̶ʌad̶a a panʌa. Baribʌrʌ mʌ̃a bãrãra warrarã bara idu wãbiẽ́a. Ab̶abe drõãrãda wãnida panʌa Ãcõrẽa animarãda babue diad̶i carea. ¿Maʌ̃drʌ bãrãba iwid̶i panʌẽ́ca?– Maʌ̃be Egiptod̶ebema boroba Moisera Aaroʌ̃ sid̶a idji quĩrãpitabemada ãyã jʌretabisia. ");
INSERT INTO empNTpo_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ãcõrẽba Moisea jarasia: –Bʌ jʌwara naʌ̃ Egipto druad̶e wadua ad̶ichichida zocãrã b̶aemãrẽã. Mãwã jũma Egipto druara ad̶ichichiba biraya. Maʌ̃ ad̶ichichiba jũma chirua hieloba ãrĩnaẽ́ra cod̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ara maʌ̃da Moiseba idji jʌwad̶e erob̶ʌ bacurura Egiptod̶e wasia. Maʌ̃ne Ãcõrẽba nãũrãda ʌ̃mãdau odjabariareba tʌbisia. Ãsa, diamasi bid̶a Egipto druad̶e tʌ nũmasia. Maʌ̃ nãũrãba nurẽma diaped̶a ad̶ichichida zocãrã b̶aebisia. ");
INSERT INTO empNTpo_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","15","Maʌ̃ne jũma Egipto druara ad̶ichichiba birasia. Ab̶ed̶a egorora poya ununaca basía. Maʌ̃ ewari naẽna ad̶ichichira maʌ̃ quĩrãca Egipto druad̶e ununaca basía idjab̶a waa maʌ̃ quĩrãca ununaẽ́a. Hieloba ãrĩnaẽ́ chiruara, nejõ b̶ea sid̶a ad̶ichichiba jũma cosid̶aa. Jũma Egipto druad̶e chiruada, bacuru quedua sid̶a ab̶ed̶a neẽ́ b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Maʌ̃be Egiptod̶ebema boroba Moisera, Aaroʌ̃ sid̶a isabe trʌ̃biped̶a nãwã jarasia: –Id̶ibʌrʌ bãrã Ãcõrẽ quĩrãpita, bãrã quĩrãpita bid̶a mʌ̃a biẽ́ osia. ");
INSERT INTO empNTpo_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Maʌ̃ bẽrã mʌ̃a bãrãa bed̶ea djuburiaya mʌ̃a biẽ́ od̶ada quĩrãdoad̶amãrẽã. Idjab̶a bãrã Ãcõrẽa iwid̶id̶adua naʌ̃ ad̶ichichira mʌ̃ druad̶e jõbimãrẽã. Mãwã od̶aẽ́bʌrʌ dairãra jarrababa quininia.– ");
INSERT INTO empNTpo_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ara maʌ̃da Moisera Egiptod̶ebema boromaʌba ẽdrʌped̶a Ãcõrẽa iwid̶isia. ");
INSERT INTO empNTpo_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Iwid̶ibʌrʌd̶e Ãcõrẽba nãũrãda dji cãbãyã ʌ̃mãdau b̶aebariareba tʌbisia. Maʌ̃ nãũrãba ad̶ichichira Pusa Purru abadad̶e jũma b̶atabuesia. Ab̶ed̶a ad̶ichichira Egipto druad̶e ni ab̶a bid̶a b̶eẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Baribʌrʌ Ãcõrẽba Egiptod̶ebema borora so zarea b̶ʌd̶a bẽrã idjia israelerãra idu wãbiẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Maʌ̃be Ãcõrẽba Moisea jarasia: –Bʌ jʌwara ʌ̃taa bajãnaa wadua. Maʌ̃ne ewarira qui dogoya. Jũma Egipto druad̶e ab̶ed̶a pãĩsosoa nũmeya.– ");
INSERT INTO empNTpo_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ara maʌ̃da Moiseba idji jʌwara ʌ̃taa bajãnaa wasia. Maʌ̃ne ewarira qui dogoped̶a ewari ũbea Egipto druad̶e bio pãĩsosoa nũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Maʌ̃ ewari ũbead̶e ni ab̶aʌda idji diguid̶aʌba poya ãyã wãnaẽ́ basía. Ni ãdji caita b̶ea sid̶a poya ununaẽ́ basía. Baribʌrʌ israelerã panʌma ʌ̃na b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Maʌ̃be Egiptod̶ebema boroba Moisera trʌ̃biped̶a nãwã jarasia: –Bãrãra bãdji warrarã bara wãnida panʌa Ãcõrẽa animarãda babue diad̶i carea. Baribʌrʌ bãrã animarãra amenida panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moiseba panusia: –Mãwãẽ́a. Bʌa dai animarãra idu edebida b̶ʌa ʌ̃cʌrʌ dai Ãcõrẽa bea diad̶ida panʌ bẽrã idjab̶a ʌ̃cʌrʌ idjía babue diad̶ida panʌ bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Maʌ̃ bẽrã dai animarã sid̶a eded̶ia. Ni ab̶a bid̶a amenaẽ́a. Dai animarãnebemada ʌ̃cʌrʌ dai Ãcõrẽa babue diad̶ida panʌmĩna ara nawena adua panʌa sãʌ̃gʌdrʌ mãwã od̶ida panʌda. Araa jũẽped̶ad̶acarea cawad̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Baribʌrʌ Ãcõrẽba Egiptod̶ebema borora so zarea b̶ʌsia. Maʌ̃ bẽrã Egiptod̶ebema boroba israelerãra idu wãbiẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Maʌ̃ne idjia Moisea jarasia: –Mʌ̃ quĩrãpitabemada ãyã wãdua. Mʌ̃maa waa zerãdua. Bʌda mʌ̃maa zeibʌrʌ, mʌ̃a bʌra beaya.– ");
INSERT INTO empNTpo_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moiseba panusia: –Bia b̶ʌa. Mʌ̃ra bʌmaa waa zeẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Maʌ̃be Ãcõrẽba Moisea jarasia: –Mʌ̃a Egiptod̶ebema borora, egiptorã sid̶a wayacusa cawa oya. Mãwã cawa od̶acarea dji boroba bãrã israelerãra idu wãbiya. Ab̶ed̶a bãrãra idji druad̶ebemada ãyã jʌrecuaya. ");
INSERT INTO empNTpo_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Maʌ̃ bẽrã israelerãa jaradua ãdjirã caita b̶ea egiptorãa oro od̶ada, parata od̶a sid̶a iwid̶id̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ãcõrẽba egiptorãa israelerãra bia unubisia. Dji dromarãba, waabema egiptorã bid̶a Moisera dji dromada cawasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Egiptod̶ebema boromaʌba ãyã wãi naẽna Moiseba idjía jarasia: –Ãcõrẽba nãwã jara b̶ʌa: “Ariquẽtra mʌ̃ra jũma Egipto druad̶e pʌrrʌaya. ");
INSERT INTO empNTpo_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Maʌ̃ne umaquĩrã warra dji nabemarãra jũma beud̶ia. Egiptod̶ebema boro umaquĩrã warra dji nabemara beuya. Dji ed̶aara b̶ʌ nezocawẽrãba erob̶ʌ umaquĩrã warra dji nabema sid̶a beuya. Idjab̶a animarã warra dji umaquĩrã naãrã tod̶a sid̶a jũma beud̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Maʌ̃ne jũma Egiptod̶e sopua dromaba ẽberãrãra jĩãbi b̶ʌgad̶ia. Maʌ̃ ewari naẽna sopuara maʌ̃ quĩrãca ununaca basía ni maʌ̃ quĩrãca waa ununaẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Baribʌrʌ dai israelerã duanʌma chupea nũmaya sopuad̶aẽ́ bẽrã. Usa sid̶a berud̶aẽ́a ni cãrẽ sid̶a sãwãnaẽ́ bẽrã.” Mãwã bãrã egiptorãba cawad̶ia Ãcõrẽba dai israelerãra quĩrã awara obarida. ");
INSERT INTO empNTpo_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Mãwãbʌrʌd̶e dji dromarãda mʌ̃maa zed̶ia. Ãdjirãra mʌ̃ quĩrãpita chĩrãborod̶e copanenaped̶a jarad̶ia: “Wãdua. Jũma israelerã sid̶a pe ededua.” Bãrãba mãwã jarabʌdad̶ebʌrʌ mʌ̃ra wãya.– Moisera bio quĩrũ b̶ʌda Egiptod̶ebema boromaʌba ẽdrʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Naẽna Ãcõrẽba Moisea jarad̶oasia: –Egiptod̶ebema boroba bãrãba jara panʌra ĩjãẽ́ b̶aya. Mãwã mʌ̃a ne ununacada Egiptod̶e zocãrã ocuaya.– ");
INSERT INTO empNTpo_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moiseba Aaroʌ̃ bid̶a maʌ̃ ne ununaca b̶eara Egiptod̶ebema boro quĩrãpita ocuasid̶aa. Baribʌrʌ Ãcõrẽba idjira so zarea b̶ʌsia. Maʌ̃ bẽrã Egiptod̶ebema boroba israelerãra idji druad̶ebemada idu ẽdrʌbiẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Egiptod̶e panasid̶ad̶e Ãcõrẽba Moisea, Aaroʌ̃a bid̶a nãwã jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","–Id̶iba ʌ̃taa naʌ̃ jed̶ecora bãrã israelerã itea dji nabema jed̶eco baya. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Jũma israelerãa jarad̶adua: naʌ̃ jed̶ecod̶e die ewari jũẽnacarea jũma de bara b̶ea umaquĩrãrãba oveja zaqueda wa chiwatu zaqueda ab̶a awara b̶ʌd̶ida panʌa ãdji ded̶ebemarã itea. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Baribʌrʌ ʌ̃cʌrʌ ded̶e zocãrãẽ́be panʌ bẽrã maʌ̃ animarã djarara jũma poya cod̶aẽ́a. Maʌ̃ bẽrã dji de djibariba idji caitabema de djibari ume animarãda ab̶a awara b̶ʌd̶ida panʌa. Maʌ̃ animarã beabʌda ewarid̶e dji djarara ãdji ded̶e b̶earãba cobada quĩrãca diad̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Maʌ̃ animarãra jũma bia b̶aida b̶ʌa, dji umaquĩrã baida b̶ʌa, poa ab̶a b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Maʌ̃ animarãra ewari quĩmãrẽ bio wagad̶ida panʌa. Catorcebema ewari queubʌrʌd̶e jũma israelerãba maʌ̃ animarãra bead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Beabʌdad̶e dji oada piad̶aped̶a maʌ̃ oaba ãdji ded̶e ed̶a wãbada icawa pʌrʌd̶ida panʌa. Ara maʌ̃ ded̶e dji djarada cod̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Maʌ̃ diamasi dji djarara bá cod̶ida panʌa. Chirua aseada, paʌ̃ dji ẽsãbari neẽ́ b̶ʌ sid̶a cod̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Dji djarara õgo õgoa cod̶acara panʌa idjab̶a djud̶ada cod̶acara panʌa. Ab̶abe bád̶ada cod̶ida panʌa. Bábʌdad̶e dji boro bara, dji jĩrũ bara, idjab̶a dji jʌ̃sira sʌgʌd̶aped̶a b̶ited̶a b̶ʌd̶aped̶a jũma bád̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Dji djarara ni maãrĩ bid̶a wagad̶iẽ́ panʌa nurẽma cod̶i carea. Jũma cod̶aẽ́bʌrʌ nurẽma diaped̶a dji ad̶ubad̶ara babued̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Maʌ̃ co panʌne bãrã cacuad̶e jʌ̃badara jũma jʌ̃ b̶ead̶ida panʌa, jĩrũne jʌ̃badara jʌ̃ b̶ead̶ida panʌa, idjab̶a bãrã bardonara jʌwad̶e erob̶ead̶ida panʌa. Isabe ne cod̶ida panʌa, Egiptod̶eba ẽdrʌd̶ida panʌ bẽrã. Maʌ̃ ewarira bãrãba trʌ̃ b̶ʌd̶ia “Egiptod̶eba ẽdrʌped̶ad̶a quĩrãnebabada ewari.” ");
INSERT INTO empNTpo_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Maʌ̃ diamasi mʌ̃ra jũma Egipto druad̶e pʌrrʌaya. Maʌ̃ne mʌ̃a quinibiya jũma Egiptod̶ebema umaquĩrã warra dji nabemarãda idjab̶a Egiptod̶ebema animarã warra dji umaquĩrã naãrã tod̶a sid̶a. Mãwã mʌ̃a unubiya egiptorãba ãcõrẽ quĩrãca erob̶eara siriẽ́ b̶eada. Mʌ̃drʌ Ãcõrẽa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Baribʌrʌ bãrãba pʌrʌped̶ad̶a oaba cawabiya bãrãra sãʌ̃gʌ ded̶e panʌda. Maʌ̃ oa unubʌrʌd̶e mʌ̃ra wãyã wãya. Mãwã mʌ̃a Egiptod̶ebema warrarã quinibibʌrʌd̶e bãrã umaquĩrã warra dji nabemarãda ni ab̶a bid̶a beud̶aẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Id̶iba ʌ̃taa poaza bãrãba, bãrã warrarãneba yõbʌda bid̶a ewari dromada mʌ̃ itea od̶ida panʌa mʌ̃a maʌ̃ diamasi obʌrʌda quĩrãnebad̶i carea. Maʌ̃ ewari dromada nãwã od̶ida panʌa: ");
INSERT INTO empNTpo_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","siete ewari bãrãba paʌ̃ dji ẽsãbari neẽ́ b̶ʌda cod̶ida panʌa. Maʌ̃ ewarid̶e ni ab̶aʌba paʌ̃ ẽsãbarida idji diguid̶a erob̶acara b̶ʌa. Maʌ̃ siete ewarid̶e ab̶aʌba paʌ̃ ẽsãbari bara b̶ʌda coibʌrʌ idjira ãyã jʌretabued̶ida panʌa bãrã israelerã tãẽnabemada. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Maʌ̃ siete ewari o panʌne dji naãrãbema ewarid̶e, dji jĩrũarebema ewarid̶e bid̶a jũma bãrã israelerãra ãbaa dji jʌred̶ida panʌa mʌ̃́a bia bed̶ead̶i carea. Maʌ̃ ewari umébemane ni ab̶aʌda trajacara panʌa. Ab̶abe poya ne djud̶ida panʌa maʌ̃ ewarid̶e ne cod̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Bãrãba paʌ̃ dji ẽsãbari neẽ́ cobada ewarida o pananida panʌa, maʌ̃ ewarid̶e mʌ̃a bãrãra Egiptod̶eba ẽdrʌ eded̶a bẽrã sordaorã djõne wãbada quĩrãca. Poa zebʌrʌza bãrãba, bãrã warrarãneba yõbʌda bid̶a maʌ̃ ewari dromara o pananida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Poaza dji nabema jed̶ecod̶e siete ewari bãrãba paʌ̃ dji ẽsãbari neẽ́ b̶ʌda cod̶ida panʌa. Maʌ̃ jed̶ecod̶e catorce ewari queud̶ad̶eba ab̶a siete ewari queubʌrʌd̶aa bãrãba mãwã od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Maʌ̃ siete ewarid̶e bãrãba paʌ̃ ẽsãbarida bãrã diguid̶a erob̶eacara panʌa. Baridua bãrãnebemaba, ãĩbema bãrã tãẽna b̶ʌ bid̶a paʌ̃ ẽsãbarira coibʌrʌ, idjira ãyã jʌretabued̶ida panʌa bãrã tãẽnabemada. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Maʌ̃ siete ewarid̶e bãrãba ni cãrẽ sid̶a cod̶iẽ́ panʌa paʌ̃ ẽsãbari bara b̶ʌda. Bãdji wãbʌdama ab̶abe cod̶ida panʌa paʌ̃ ẽsãbari neẽ́ b̶eada.– ");
INSERT INTO empNTpo_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ãcõrẽba mãwã jarad̶acarea Moiseba Israeld̶ebema dji bororãda trʌ̃ped̶a nãwã jarasia: –Dji de bara b̶ea umaquĩrãba ãdji ded̶ebemarã itea oveja zaqueda wa chiwatu zaqueda edad̶aped̶a awara b̶ʌd̶adua. Dji ewari jũẽped̶a queubʌrʌd̶e maʌ̃gʌ animarãra bead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Beabʌdad̶e dji oara eped̶eco waib̶ʌad̶e piad̶ida panʌa. Maʌ̃be chirua hisopo abadada ãbaa cajʌ̃naped̶a maʌ̃ oad̶e b̶eguead̶aped̶a bãrã ded̶e ed̶a wãbada icawa pʌrʌd̶adua. Ʌ̃nadrʌi naẽna ni ab̶aʌda idji ded̶eba ẽdrʌiẽ́ b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ãcõrẽba Egiptod̶ebema umaquĩrã warra dji nabemarãda quinibi carea pʌrrʌabʌrʌd̶e maʌ̃ oa bãrã ded̶e ed̶a wãbada icawa pʌrʌd̶ara unuya. Maʌ̃ bẽrã idjira wãyã wãya. Maʌ̃ oa unubʌrʌd̶e dji beabarida bãrã ded̶e idu ed̶a wãbiẽ́a bãrã umaquĩrã warra dji nabemarã quinibirãmãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Id̶iba ʌ̃taa poaza bãrãba, bãrã warrarãneba yõbʌda bid̶a maʌ̃ ewari dromada o pananida panʌa Ãcõrẽba jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ãcõrẽba diai jarad̶a ẽjũãne jũẽped̶ad̶acarea bãrãba poaza maʌ̃ ewari dromara o pananida panʌa idjia jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","27","Bãrã warrarãba iwid̶ibʌdad̶e: “¿Cãrẽ cãrẽã naʌ̃ ewari dromara jãwã o panʌ?”, bãrãba panunida panʌa: “Naʌ̃ animarãra bea panʌa Ãcõrẽa bia bed̶ead̶i carea. Naʌ̃ ewarid̶e quĩrãneba panʌa Ãcõrẽba Egiptod̶ebema umaquĩrã warra dji nabemarã quinibisid̶e dadjirã ded̶ebemada wãyã wãsida dadji umaquĩrã warra dji nabemarã beurãnamãrẽã.”– Moiseba mãwã jarad̶acarea israelerãra chĩrãborod̶e b̶arru copanenaped̶a Ãcõrẽa bia bed̶easid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Maʌ̃be jũma osid̶aa Ãcõrẽba Moisea Aaroʌ̃a bid̶a jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Maʌ̃ diamasi ariquẽtra Ãcõrẽba Egiptod̶ebema umaquĩrã warra dji nabemarãda jũma quinibisia. Egiptod̶ebema boro umaquĩrã warra dji nabemada beusia. Preso b̶ea umaquĩrã warra dji nabemarã sid̶a beusid̶aa. Idjab̶a jũma Egiptod̶ebema animarã warra dji umaquĩrã naãrã tod̶a sid̶a beusid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Diamasi Egiptod̶ebema borora, dji dromarãra, jũma waabema egiptorã sid̶a piraposid̶aa. Maʌ̃ne deza jĩãbi b̶ʌgasia ãdji umaquĩrã warra dji nabemara jũma quinisid̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ara maʌ̃ diamasi Egiptod̶ebema boroba Moisera Aaroʌ̃ sid̶a trʌ̃biped̶a nãwã jarasia: –Bãrã israelerãra isabe mʌ̃ druad̶ebemada ãyã wãbʌrʌd̶adua. Ãcõrẽa animarãda babue diad̶e wãnadua bãrãba jara panʌ quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Bãrã animarã sid̶a jũma eded̶adua bãrãba jara panʌ quĩrãca. Idjab̶a Ãcõrẽa iwid̶id̶adua mʌ̃ carebamãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Egiptorãba israelerãra ãdji druad̶ebemada isabe ãyã wãbi panasid̶aa nãwã crĩcha panana bẽrã: “Israelerãda ãyã wãnaẽ́bʌrʌ dairãra jũma quininia.” ");
INSERT INTO empNTpo_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Maʌ̃ bẽrã israelerãba ãdji paʌ̃ od̶i carea bʌratʌped̶ad̶ada eped̶ecod̶e b̶ʌsid̶aa. Maʌ̃ bʌratʌped̶ad̶ara ẽsãbari neẽ́ b̶asia. Jũma maʌ̃gʌra wuad̶e bʌrad̶aped̶a equiad̶e edad̶aped̶a edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ẽdrʌbʌdad̶e israelerãba Moiseba jarad̶a quĩrãca osid̶aa. Ãdjirãba parata od̶ada, oro od̶ada, cacuad̶e jʌ̃bada sid̶a egiptorãa iwid̶isid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Ãcõrẽba egiptorãa israelerãra bia unubid̶a bẽrã ne jũma israelerãba iwid̶iped̶ad̶ara ãdjirãba diasid̶aa. Mãwã ne jũma egiptorãba eropananada israelerãba edasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Egiptod̶eba ẽdrʌsid̶ad̶e israelerãra Ramese purud̶eba Suco purud̶aa wãsid̶aa. Seisciento mil drõãrãda jĩrũba wãsid̶aa wẽrãrã, warrarã sid̶a juachad̶aẽ́. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ãdji animarã zocãrã eropanʌ sid̶a jũma edesid̶aa. Israelerã ume dewara ẽberãrã sid̶a zocãrã wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Egiptorãba isabe wãbisid̶a bẽrã israelerãra poya ne djud̶aẽ́ basía eded̶i carea. Maʌ̃ bẽrã ãdjia Egiptod̶e bʌratʌped̶ad̶a paʌ̃ dji ẽsãbari neẽ́ b̶ʌda ota ãbusid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Egiptod̶e israelerãra cuatrociento treinta poa panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Maʌ̃ cuatrociento treinta poa daucha jũẽsid̶e israelerãra Ãcõrẽ sordaorã quĩrãca Egipto druad̶eba jũma ẽdrʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Maʌ̃ diamasi Ãcõrẽba israelerãra waga b̶asia Egiptod̶eba ẽdrʌ edei carea. Maʌ̃ bẽrã poaza israelerãba, ãdji warrarãneba yõbʌda bid̶a ab̶ari ewari quĩrãca diamasi idji itea wagad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ãcõrẽba Moisea Aaroʌ̃a bid̶a jarasia: –Bãrã Egiptod̶eba ẽdrʌped̶ad̶a quĩrãnebad̶i carea ne cobadara nãwã od̶ida panʌa. Ni ab̶aʌ ãĩbema israelerã tãẽna b̶ʌba maʌ̃ cobadara cocara b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Baribʌrʌ Israeld̶ebema ab̶aʌba ãĩbemada idji nezoca bamãrẽã nẽdoibʌrʌ, maʌ̃ nezocara cacua wẽãgosira ne cobadara coida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Baribʌrʌ parata carea traja b̶ʌ ãĩbemaba maʌ̃ cobadara cocara b̶ʌa. Idjab̶a baridua bãrã tãẽna b̶ʌ ãĩbemaba maʌ̃ cobadara cocara b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Maʌ̃ ne cobadara bãdji ded̶e ed̶a cod̶ida panʌa. Maʌ̃ne dji djarada ni maãrĩ bid̶a dajadaa eded̶acara panʌa. Idjab̶a dji b̶ʌwʌrʌra b̶ʌawed̶acara panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Jũma israelerãba maʌ̃ cobadara cod̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Bãrã tãẽna b̶ʌ ãĩbemaba maʌ̃ ne cobadara co quĩrĩã b̶ʌbʌrʌ, naãrã idji cacuara wẽãgoida b̶ʌa. Idjab̶a jũma umaquĩrã idji ẽberãrã sid̶a mãwã od̶ida panʌa. Maʌ̃bebʌrʌ idjia maʌ̃ cobadara coida b̶ʌa, israelerã quĩrãca b̶ʌ bẽrã. Baribʌrʌ cacua wẽãgoẽ́ b̶ʌba maʌ̃ cobadara cocara b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Maʌ̃ ne cobadara bãrã israelerãba, ãĩbema bãrã tãẽna panʌ bid̶a ara mʌ̃a jara b̶ʌ quĩrãca od̶ida panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Israelerãba Ãcõrẽba Moisea Aaroʌ̃a bid̶a jarad̶a quĩrãca jũma osid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ara maʌ̃ ewarid̶e Ãcõrẽba israelerãra Egiptod̶eba jũma ẽdrʌ edesia sordaorã djõne wãbada quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Maʌ̃be Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","–Israelerãba ãdji umaquĩrã warra dji nabemarãda, ãdji animarã dji umaquĩrã naãrã toped̶ad̶a sid̶a mʌ̃́a jũma diad̶ida panʌa. Jũma maʌ̃gʌrãra mʌ̃rea.– ");
INSERT INTO empNTpo_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Maʌ̃be Moiseba israelerãa jarasia: –Naʌ̃ ewarira quĩrãnebad̶adua Ãcõrẽba idji ʌb̶ʌad̶eba bãrãra Egiptod̶e nezoca b̶ead̶ada ẽdrʌ edad̶a bẽrã. Poaza ara naʌ̃ ewari quĩrãca bãrãba paʌ̃ ẽsãbari bara b̶ʌda cocara panʌa bãrã Egiptod̶eba ẽdrʌped̶ad̶ara quĩrãnebad̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Id̶i naʌ̃ jed̶eco Abib abadad̶e bãrãra Egiptod̶eba ẽdrʌbʌdaa. ");
INSERT INTO empNTpo_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Ãcõrẽba bãrãra Canaaʌ̃ druad̶aa edeya. Maʌ̃ druad̶e baridua ne uped̶ad̶ara bia zaubaria. Mama cananeorãda, hititarãda, amorreorãda, heveorãda, idjab̶a jebuseorã sid̶a duanʌa. Baribʌrʌ Ãcõrẽba bãrã drõã naẽnabemarãa wãrãneba jarasia maʌ̃ druara bãrãa diaida. Jãma jũẽped̶ad̶acarea poaza naʌ̃ jed̶ecod̶e bãrãba naʌ̃ quĩrãca od̶ida panʌa bãrã Egiptod̶eba ẽdrʌped̶ad̶a ewarida quĩrãnebad̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","7","Siete ewari bãrãba paʌ̃ dji ẽsãbari neẽ́ b̶ʌda cod̶ida panʌa. Maʌ̃ siete ewarid̶e paʌ̃ ẽsãbarira ni maãrĩ bid̶a bãrã druad̶e erob̶ead̶iẽ́ panʌa. Jĩrũarebema ewarid̶e Ãcõrẽa bia bed̶ead̶i carea bãrãra ãbaa dji jʌred̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Mãwã o panʌne bãrã warrarãa nãwã jarad̶ida panʌa: “Dadjirãba nãwã o panʌa Ãcõrẽba dadji israelerãra Egiptod̶eba ẽdrʌ edad̶a quĩrãnebad̶i carea.” ");
INSERT INTO empNTpo_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Naʌ̃ ewari obadara bãrã jʌwad̶e wa dratud̶e sẽyã quĩrãca b̶ʌa. Maʌ̃ba quĩrãnebabi b̶aya bãrãba Ãcõrẽ leyra jaradia pananida panʌda idji ʌb̶ʌad̶eba dadji israelerãra Egiptod̶eba ẽdrʌ edad̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Maʌ̃ carea poaza ara naʌ̃ ewari quĩrãca bãrãba maʌ̃ ewari dromada o pananida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Ãcõrẽba bãrãra cananeorã druad̶aa edeped̶a maʌ̃ druara diaya idjia bãrã drõã naẽnabemarãa, bãrãa bid̶a wãrãneba diaida jarad̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Jãma jũẽped̶ad̶acarea bãrãba jũma bãrã umaquĩrã warra dji nabema tobʌdara, jũma bãrã animarã dji nabema umaquĩrã tobʌda sid̶a Ãcõrẽa diad̶ida panʌa. Jũma maʌ̃gʌrãra Ãcõrẽnea. ");
INSERT INTO empNTpo_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Bãrã burro warra dji nabema umaquĩrã tobʌrʌda Ãcõrẽnemĩna, bãrãba maʌ̃ animarãra poya edad̶ida panʌa. Edad̶i carea ovejada wa chiwatuda maʌ̃ burro cacuabari Ãcõrẽa babue diad̶ida panʌa. Baribʌrʌ maʌ̃ burroda eda quĩrĩãnaẽ́bʌrʌ, bãrãba otapuya bead̶ida panʌa. Idjab̶a bãrã umaquĩrã warra dji nabema tobʌdara Ãcõrẽne bẽrã, idji cacuabari ovejada wa chiwatuda Ãcõrẽa babue diad̶ida panʌa maʌ̃ warrara zocai b̶emãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Id̶iba ʌ̃taa bãrã warrarãba iwid̶ibʌdad̶e: “¿Cãrẽ cãrẽã jãwã obada?”, bãrãba nãwã panunida panʌa: “Jãwã obadaa Ãcõrẽba idji ʌb̶ʌad̶eba dadjirãra Egiptod̶e nezoca b̶ead̶ada ẽdrʌ edad̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Maʌ̃ ewarid̶e Egiptod̶ebema borora so zarea b̶ed̶a bẽrã dadjirãra ẽdrʌ b̶ʌ quĩrĩãẽ́ basía. Maʌ̃ carea Ãcõrẽba jũma Egiptod̶ebema umaquĩrã warra dji nabemarãda quinibisia. Egiptod̶ebema animarã warra dji umaquĩrã naãrã toped̶ad̶a sid̶a quinibisia. Maʌ̃ carea dadjirãba jũma animarã warra dji nabema umaquĩrã tobʌdara Ãcõrẽa babue diabadaa. Baribʌrʌ jũma dadjirã umaquĩrã warra dji nabema tobʌda cacuabari oveja zaqueda Ãcõrẽa babue diabadaa. ");
INSERT INTO empNTpo_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Mãwã obadara dadji jʌwad̶e wa dratud̶e sẽyã quĩrãca b̶ʌa. Maʌ̃ba quĩrãnebabi b̶ʌa Ãcõrẽba idji ʌb̶ʌad̶eba dadjirãra Egiptod̶eba ẽdrʌ edasida.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Egiptod̶ebema boroba israelerã idu wãbisid̶e Ãcõrẽba ãdjirãra dji caitaara b̶ʌ óare edeẽ́ basía, maʌ̃ ora pilisteorã druad̶e wã b̶ʌ bẽrã. Ãcõrẽba nãwã crĩchasia: “Israelerã wãbʌdad̶e pilisteorãda ãdji ume djõne zed̶ibʌrʌ, Canaaʌ̃ druad̶aa wãni crĩcha eropananara igarad̶aped̶a Egiptod̶aa jẽda wãnia.” ");
INSERT INTO empNTpo_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Maʌ̃ carea Ãcõrẽba ãdjirãra ẽjũã põãsa ewaraga b̶ʌd̶e wã b̶ʌ óare edesia. Maʌ̃ ora Pusa Purru abadad̶aa wã b̶ʌa. Egiptod̶eba ẽdrʌsid̶ad̶e israelerãra djõne wãbʌda quĩrãca wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Maʌ̃ne Moiseba Jose querasi b̶ʌwʌrʌra edesia Canaaʌ̃ druad̶e tʌb̶ari carea. Mãwã osia Jose querasiba naẽna israelerãa wãrãneba jarabid̶a bẽrã mãwã od̶amãrẽã. Jose querasiba nãwã jarasia: –Wãrãda Ãcõrẽba bãrãra carebaya. Maʌ̃ ewarid̶e bãrãba mʌ̃ b̶ʌwʌrʌra namaʌba Canaaʌ̃ druad̶aa tʌb̶arid̶e eded̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Egiptod̶eba ẽdrʌsid̶ad̶e israelerãra naãrã Suco purud̶e jũẽne wãnaped̶a Etaʌ̃ purud̶aa wãsid̶aa. Maʌ̃ purura ẽjũã põãsa ewaraga b̶ʌ icawa b̶ʌa. Mama ãdji wua dera ocuasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Israelerã wãbʌdad̶e Ãcõrẽra ãdji na wãbadjia cawad̶amãrẽã sãma wãnida panʌda. Ãsa idjira jʌ̃rãrã quĩrãca ʌ̃tʌba ed̶aa drasoa jira b̶abadjia. Diamasi maʌ̃ jʌ̃rãrãra tʌbʌ quĩrãca uruga jira b̶abadjia ʌ̃naane pananamãrẽã. Mãwã ãsa, diamasi bid̶a israelerãra poya wãnida panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Maʌ̃ jʌ̃rãrã ʌ̃tʌba ed̶aa drasoa jira b̶ʌra ãdjirã umebemada ãyã wãca basía. Ãsa jʌ̃rãrã quĩrãca b̶asia. Diamasira tʌbʌ quĩrãca uruga jira b̶abadjia. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Maʌ̃be Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","–Israelerãa jaradua Pi-Ajirod̶aa jẽda wãnamãrẽã. Jãma Migdol puru quĩrãpe pusa icawa ãdji wua dera Baal-Zepoʌ̃ caita ocuad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Mãwãra Egiptod̶ebema boroba crĩchaya ẽjũã põãsa ewaraga b̶ʌd̶e bãrã israelerãra nocod̶aa poya wãnaẽ́ bẽrã baridua nĩnada. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Maʌ̃ne mʌ̃a Egiptod̶ebema borora so zarea b̶ʌya. Maʌ̃ bẽrã idjia bãrãra caid̶u ẽpẽya. Baribʌrʌ mʌ̃a idjira, idji sordaorã sid̶a poyaya mʌ̃drʌ dji dromaara b̶ʌda unubi carea. Mãwã egiptorãba cawad̶ia mʌ̃ra Ãcõrẽda.– Ara maʌ̃da israelerãra Ãcõrẽba jarad̶a quĩrãca jẽda wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Maʌ̃ ewarid̶e Egiptod̶ebema boroa israelerã mĩrũ wãsid̶ada jarasid̶aa. Maʌ̃ne idjia, dji dromarã bid̶a israelerã idu wãbiped̶ad̶ada jẽda crĩchasid̶aa. Nãwã jarasid̶aa: “¿Cãrẽ cãrẽã jãwã israelerãra idu wãbisid̶a? Dadjirãba õgo trajabibadara neẽ́ panesid̶aa.” ");
INSERT INTO empNTpo_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ara maʌ̃da Egiptod̶ebema boroba djõbada carretara cawayod̶e jʌ̃bicuasia israelerã caid̶u wãi carea. Idjab̶a idji sordaorãra trʌ̃bisia idji ume wãnamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Carreta dji biara b̶eada seisciento edesia. Maʌ̃ awara jũma dewara carreta sid̶a pe edesia. Carretaza sordaorã boroda ab̶a b̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Maʌ̃ne Ãcõrẽba Egiptod̶ebema borora so zarea b̶ʌsia israelerã caid̶u wãmãrẽã. Ãcõrẽ ʌb̶ʌad̶eba israelerãra Egiptod̶eba ẽdrʌped̶ad̶amĩna Egiptod̶ebema borora idji sordaorã ume caid̶u wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Jũma Egiptod̶ebema sordaorãra israelerã caid̶u wãsid̶aa; cawayod̶eba djõbadarãda, carretad̶eba djõbadarãda, waabema sordaorã sid̶a. Israelerãra pusa icawa Pi-Ajiro caita Baal-Zepoʌ̃ quĩrãpe unune wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Israelerãba Egiptod̶ebema boro, idji sordaorã ume ãdji caid̶u zebʌdada unusid̶ad̶e bio ne wayad̶aped̶a Ãcõrẽa quĩrã djuburiada iwid̶i duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Maʌ̃ne ãdjirãba Moisea jarasid̶aa: –¿Bʌa cãrẽ cãrẽã jãwã osi? ¿Cãrẽ cãrẽã Egiptod̶eba dairãra nama pe enesi? ¿Egiptod̶e dairã joud̶i carea ẽjũãra neẽ́ basica? ¿Bʌa dairãra naʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶e beubi carea enesica? ");
INSERT INTO empNTpo_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","¿Egiptod̶e panasid̶ad̶e dairãba bʌ́a egiptorã itea idu trajabiduad̶a ad̶aẽ́ basica? Naʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶e beud̶i cãyãbara biara b̶acasia egiptorã nezocarãda b̶ead̶ida.– ");
INSERT INTO empNTpo_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Baribʌrʌ Moiseba ãdjirãa jarasia: –Ne wayarãnadua. Necai duananadua. Id̶i ununia sãwã Ãcõrẽba bãrãra egiptorãba ẽpẽ panʌnebemada ẽdrʌ b̶ʌida. Id̶iba ʌ̃taa bãrãba naʌ̃ egiptorã bãrã caid̶u zebʌdara waa ununaẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Ãcõrẽra bãrã carea djõya. Maʌ̃ bẽrã necai pananida panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Maʌ̃be Ãcõrẽba Moisea jarasia: –¿Bʌa cãrẽ cãrẽã wad̶ibid̶a mʌ̃́a quĩrã djuburiada iwid̶i b̶ʌ? Israelerãa jaradua nocod̶aa wãnamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Bʌa jʌwad̶e erob̶ʌ bacurura pusad̶aa wadua oda pusa ẽsi ewamãrẽã. Maʌ̃ od̶e israelerãra pusa quĩrãrã chãnia. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","18","Maʌ̃ne mʌ̃a egiptorãra so zarea b̶ʌya bãrã ẽpẽnamãrẽã. Maʌ̃be mʌ̃a Egiptod̶ebema borora, carretad̶eba djõbada sordaorãra, cawayod̶eba djõbada sordaorãra, waabema sordaorã sid̶a jũma poyaya mʌ̃drʌ dji dromaara b̶ʌda unubi carea. Mãwã egiptorãba cawad̶ia mʌ̃ra Ãcõrẽda.– ");
INSERT INTO empNTpo_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","20","Maʌ̃be Ãcõrẽ bajãnebema nezoca israelerã na nĩbad̶ara ãdjirã jẽdaare b̶esia. Mãwã israelerã nocoare b̶ad̶a jʌ̃rãrã ʌ̃tʌba ed̶aa drasoa jira b̶ʌra ãdjirã jẽdaare b̶esia idjab̶a egiptorã nocoare b̶esia. Diamasi maʌ̃ jʌ̃rãrãba israelerãma ʌ̃na erob̶asia baribʌrʌ egiptorãma pãĩsosoa erob̶asia. Maʌ̃ bẽrã maʌ̃ diamasi egiptorãra israelerãma poya jũẽnaẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moiseba idji jʌwara pusad̶aa ʌ̃taa wasia. Ara maʌ̃da ʌ̃mãdau odjabariareba Ãcõrẽba nãũrãda dji cãbãyã tʌbisia. Maʌ̃ diamasi nãũrãra tʌ nũmʌda ʌ̃nadrʌsia. Maʌ̃ba pusa ẽsi oda ewasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Israelerãra maʌ̃ o ewa jira b̶ʌd̶e chãsid̶aa. Chãbʌdad̶e pusara ãdjirã jʌwa araare idjab̶a ãdjirã jʌwa acʌare bid̶a ʌ̃tʌba ed̶aa jũãtrʌ nũmʌ quĩrãca nũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Maʌ̃be jũma Egiptod̶ebema boroba eded̶a cawayod̶eba djõbada sordaorãra, carretad̶eba djõbada sordaorãra, waabema sordaorã sid̶a maʌ̃ o ewa jira b̶ʌd̶e israelerã caid̶u wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ʌ̃nadrʌbod̶od̶e Ãcõrẽba egiptorãra dji jʌ̃rãrã ʌ̃tʌba ed̶aa drasoa uruga jira b̶ʌd̶eba acʌ b̶asia. Maʌ̃ne idjia ãdjirãra cawad̶aẽ́ errunĩbabisia. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Idjab̶a ãdji carreta jĩrũra ẽcuabisia. Egiptorãra nocod̶aa poya wãnaẽ́ bẽrã nãwã jara duanesid̶aa: –¡Jẽda wãnadrʌ! ¡Israelerãra waa ẽpẽnaẽ́a! ¡Ãcõrẽra ãdjirãare dadjirã ume djõ b̶ʌa!– ");
INSERT INTO empNTpo_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Israelerã chãped̶ad̶acarea Ãcõrẽba Moisea jarasia: –Bʌ jʌwara pusad̶aa ʌ̃taa wadua Egiptod̶ebema sordaorãra, carretad̶eba djõbada sordaorãra, cawayod̶eba djõbada sordaorã sid̶a pusaba ãnẽb̶ari edamãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Ara maʌ̃da Moiseba idji jʌwara pusad̶aa ʌ̃taa wasia. Ʌ̃nadrʌbʌrʌd̶e pusara wayacusa idji b̶ad̶a quĩrãca dogosia. Maʌ̃ne egiptorãra ẽdrʌd̶i carea jẽda piracuasid̶amĩna pusaba ãnẽb̶ari edasia. Mãwã Ãcõrẽba ãdjirãra pusad̶e quinibisia. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Pusa idji b̶ad̶a quĩrãca ũmesid̶e Egiptod̶ebema boroba eded̶a carretad̶eba djõbada sordaorãra, cawayod̶eba djõbada sordaorã sid̶a jũma ãnẽb̶ari edasia. Ab̶ed̶a jũma israelerã caid̶u wãped̶ad̶ara pusaba ãnẽb̶ari edasia. Ni ab̶a bid̶a zocai b̶eẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Baribʌrʌ israelerãra pusa ẽsi o ewa jira b̶ʌd̶e chãsid̶aa. Chãsid̶ad̶e pusara ãdjirã jʌwa araare, ãdjirã jʌwa acʌare bid̶a ʌ̃tʌba ed̶aa jũãtrʌ nũmʌ quĩrãca nũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Maʌ̃ ewarid̶e Ãcõrẽba israelerãra egiptorãba ẽpẽ panananebemada ẽdrʌ edasia. Maʌ̃ne israelerãba unusid̶aa Egiptod̶ebema quiniped̶ad̶ara pusa ĩbʌd̶e tab̶eada. ");
INSERT INTO empNTpo_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Israelerãba unusid̶aa sãwã Ãcõrẽba idji ʌb̶ʌad̶eba egiptorãra poyasida. Maʌ̃ bẽrã idjira wayasid̶aa. Idjia jara b̶ʌra, idji nezoca Moiseba jara b̶ʌ sid̶a ãdjirãba ĩjãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Maʌ̃be Moiseba jũma israelerã bid̶a Ãcõrẽa nãwã trʌ̃ãsid̶aa: Mʌ̃a Ãcõrẽa trʌ̃ãya idjira dji dromaara b̶ʌda unubid̶a bẽrã. Pusad̶e b̶atabuebʌrʌ quĩrãca idjia Egiptod̶ebema sordaorãda ãdji cawayo bara pusad̶e quinibisia. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Ãcõrẽba mʌ̃́a ʌb̶ʌada dia b̶ʌa. Idji carea mʌ̃ra trʌ̃ã b̶ʌa. Idjia mʌ̃ra ẽdrʌ edasia. Idjira mʌ̃ Ãcõrẽa. Mʌ̃a idjía bia bed̶eaya. Idjira mʌ̃ zezaba ĩjã b̶ad̶a Ãcõrẽa. Idjira dji dromaara b̶ʌad̶a aya. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Ãcõrẽra djõ cawa b̶ʌa. Idji trʌ̃ra Jehová abadaa. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Egiptod̶ebema boro sordaorãda ãdji carreta bara Ãcõrẽba jũma pusad̶e b̶atacuasia. Maʌ̃ sordaorã bororã dji biara b̶ea sid̶a Pusa Purrud̶e jũma nãbʌrʌ quinisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Egiptorãra pusa nãbuaba ãnẽb̶ari edasia. Ãdjirãra mõgara quĩrãca pusa nãbuad̶e ta wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ãcõrẽ, bʌ jʌwa arara bio ʌb̶ʌa b̶ʌa. Bʌ ʌb̶ʌad̶eba dji quĩrũra jũma poyasia. Bʌ jʌwa araba ãdjirãra berrachisia. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Bʌ ʌb̶ʌa waib̶ʌa b̶ʌd̶eba jũma bʌmaa djõne zeped̶ad̶ara poyasia. Bʌ quĩrũbira ãdjirãa unubisia. Maʌ̃ne jũma ãdjirãra chirua quĩrãca bá wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Bʌ quẽbʌba jãrãpuabʌrʌba pusa ẽsi oda ewasia. Maʌ̃ o orroza pusara ʌ̃tʌba ed̶aa jũãtrʌ nũmʌ quĩrãca nũmesia. Pusajãne bid̶a baidora maʌ̃ o orroza ipi nũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Maʌ̃ne dji quĩrũba crĩchasid̶aa: “Israelerã caid̶u ẽpẽnaped̶a jidad̶ia. Maʌ̃be ne jũma ãdjia eropanʌra jãrĩnaped̶a dadjirãza jed̶ecad̶ia. Mãwã ne jũma dadjirãba quĩrĩã panʌra eropanania. Dadjirã necora ẽũta edad̶aped̶a ãdjirãra beacuad̶ia.” ");
INSERT INTO empNTpo_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Baribʌrʌ bʌa nãũrã tʌbibʌrʌd̶e dji quĩrũra pusaba jũma ãnẽb̶ari edasia. Ãdjirãra mõgara quĩrãca pusa quĩrũ nũmʌne ta wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ãcõrẽ, ẽberãrãba ãcõrẽ abada tãẽna dewarada neẽ́a bʌ quĩrãca. Ni ab̶aʌda neẽ́a bʌ cãyãbara dji dromaara b̶ʌda. Bʌa o b̶ʌ carea jũmarãba bʌra wayabadaa. Bʌabʌrʌ ne ununaca waib̶ʌa b̶eara obaria. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Bʌ ʌb̶ʌara bʌa unubisia. Maʌ̃neba pusaba dji quĩrũra mĩsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Bʌ quĩrĩã jõcad̶eba dairã bʌa ẽdrʌ edad̶a purura cawa edeya. Bʌ ʌb̶ʌad̶eba dairãra bʌ b̶abarima bia jũẽbiya. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Maʌ̃ ũrĩbʌdad̶e dewara puru b̶eara ne wayaaba ure duanania. Pilisteorãra sopua duanania. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edoʌ̃ druad̶ebema bororãra bio ne waya duanania. Moab druad̶ebema mẽsrã b̶earãda ne wayaaba ure duanania. Jũma Canaaʌ̃nebemarãra sozarra pananada ne waya duanania. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Jũma maʌ̃gʌrã ẽberãrãra bio ne waya duanania. Ãcõrẽ, bʌ ʌb̶ʌa carea ãdjirãra mõgara quĩrãca chupea panania bʌ purura wãyã wãbʌrʌd̶e. Ãdjirãra chupea panania bʌa edad̶a purura wãyã wãbʌrʌd̶e. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ãcõrẽ, bʌa dairãra bʌ itea edad̶a eyad̶e pananamãrẽã edeya. Bʌa dairãra edeya bʌa dairã tãẽna b̶ai carea edad̶a ẽjũãnaa. Ãcõrẽ, mama bʌ de dromara dairã tãẽna osia. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Ãcõrẽra ewariza jũmarã boro baya. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Israelerãra pusa ẽsi o ewa jira b̶ʌd̶e chãsid̶ad̶e pusa quĩrãrẽ bia jũẽsid̶aa. Baribʌrʌ Egiptod̶ebema boroba eded̶a cawayod̶eba djõbada sordaorãba, carretad̶eba djõbada sordaorã bid̶a israelerã caid̶u ẽpẽsid̶ad̶e Ãcõrẽba pusara ãdjirã ʌ̃rʌ̃ ãnẽb̶ari wãbisia. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Maʌ̃ne Aaroʌ̃ djabawẽrã Mariada Ãcõrẽneba bed̶eabari basía. Maʌ̃ Mariaba, jũma Israeld̶ebema wẽrãrã bid̶a tõnõãda edad̶aped̶a b̶ʌsrid̶aba cari duanasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Mariaba ãdjirãa nãwã trʌ̃ãsia: Trʌ̃ãnadua Ãcõrẽa, idjira dji dromaara b̶ʌda unubid̶a bẽrã. Idjia Egiptod̶ebema sordaorãda ãdji cawayo bara pusad̶e b̶atacuasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Pusa Purru abadad̶eba Moiseba israelerãra ẽjũã põãsa ewaraga b̶ʌd̶e pe edesia. Maʌ̃ ẽjũã põãsa ewaraga b̶ʌra Sur abadaa. Ãdjirãra ewari ũbea baido ununaẽ́ nĩbasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Mãwã nĩnane baido b̶ʌma jũẽsid̶aa. Baribʌrʌ maʌ̃ baidora asea b̶ʌ bẽrã poya dod̶aẽ́ basía. Maʌ̃ carea maʌ̃ baidora trʌ̃ b̶ʌsid̶aa Mará. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Maʌ̃ne ãdjirãba Moisea quĩrũbid̶eba nãwã biẽ́ jarasid̶aa: –¿Dadjirãba nama cãrẽda dod̶i?– ");
INSERT INTO empNTpo_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Maʌ̃ carea Moiseba Ãcõrẽa quĩrã djuburiada iwid̶isia. Maʌ̃ne Ãcõrẽba Moisea bacuru tab̶ʌda unubisia. Maʌ̃ bacuruda Moiseba baidod̶e b̶atabuesid̶e baido asea b̶ad̶ara cũã b̶esia. Mama Ãcõrẽba naʌ̃ bed̶eada b̶ʌsia israelerãba ĩjãni cawaya. ");
INSERT INTO empNTpo_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Nãwã jarasia: “Mʌ̃ra bãrã Ãcõrẽa. Mʌ̃a jara b̶ʌda bãrãba quĩrãcuita ũrĩnibʌrʌ, idjab̶a ne jũmane mʌ̃ quĩrãpita jipa od̶ibʌrʌ, idjab̶a mʌ̃ leyda jũma od̶ibʌrʌ, mʌ̃a bãrãra cacua biẽ́ b̶ebiẽ́a egiptorã cacua biẽ́ b̶ebid̶a quĩrãca. Mʌ̃ra bãrã cacua biabibari Ãcõrẽa.” ");
INSERT INTO empNTpo_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Marád̶eba israelerãra Eliʌ̃ abadad̶e jũẽne wãsid̶aa. Mama baido egorod̶eba ʌ̃taa bogadrʌ b̶ʌda doce panasid̶aa. Idjab̶a uruta quĩrãca b̶eada setenta panasid̶aa. Maʌ̃ baido caita israelerãra duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Egiptod̶eba ẽdrʌped̶ad̶acarea jed̶eco ab̶a babʌrʌd̶e israelerãra Eliʌ̃ abadad̶eba ẽjũã põãsa ewaraga b̶ʌ Siʌ̃ abadad̶aa wãsid̶aa. Siʌ̃ra Eliʌ̃ idjab̶a Sinai eya ẽsi b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Maʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶e cod̶i neẽ́ b̶ʌ bẽrã jũma israelerãba Moisera, Aaroʌ̃ sid̶a biẽ́ jarasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Quĩrũbid̶eba ãdjirãba Moisea, Aaroʌ̃a bid̶a nãwã jarasid̶aa: –Biara b̶acasia Ãcõrẽba dairãra idu Egipto druad̶e beubid̶abara. Jãma dairãra necai ne co duanabadjid̶aa. Nedjarada, paʌ̃ sid̶a ad̶uba eropanasid̶aa. Baribʌrʌ bãrãba dairãra naʌ̃ ẽjũã põãsa ewaraga b̶ʌmaa jarrababa quenani carea enesid̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Maʌ̃ne Ãcõrẽba Moisea jarasia: –Mʌ̃a cue bajãneba zebibari quĩrãca paʌ̃da bajãneba zebiya israelerãba cod̶amãrẽã. Nãwã mʌ̃a cawaya ãdjirãba jũma mʌ̃a jara b̶ʌra ĩjã pananida wa ĩjã pananaẽ́da: diaped̶aza ãdjirãba ara maʌ̃ ewarid̶e cod̶ira jʌrʌ ped̶e wãnida panʌa. Ewari juesuma mãwã od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Baribʌrʌ seibema ewarid̶e diaped̶ed̶a jʌrʌ ped̶ida panʌa ara maʌ̃ ewarid̶e cod̶ira idjab̶a nurẽma cod̶i sid̶a.– ");
INSERT INTO empNTpo_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","8","Maʌ̃be Moiseba Aaroʌ̃ ume israelerãa jarasid̶aa: –¿Daira mãwãra cai, bãrãba mãwã daidrʌ biẽ́ jarad̶i carea? Bãrãba daida biẽ́ jara panʌẽ́a; Ãcõrẽdrʌ biẽ́ jara panʌa. Idjia maʌ̃ra ũrĩ b̶ʌa. Maʌ̃ carea nane quewara idjia bãrãa cawabiya idjiabʌrʌ bãrãra Egiptod̶eba nama ẽdrʌ enesida. Idjab̶a nu diaped̶a bãrãba ununia idjia ne ununaca waib̶ʌada obʌrʌda. Nane quewara idjia nedjarada diaya idjab̶a nu diaped̶a paʌ̃da ad̶uba diaya bãrãra jãwũã ne cod̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Maʌ̃be Moiseba Aaroʌ̃a jarasia: –Israelerãba ne cod̶i carea quĩrũbid̶eba biẽ́ jara panʌ bẽrã ãdjirãa jaradua jũmaena Ãcõrẽ quĩrãpita ãbaa dji jʌred̶ida panʌda.– ");
INSERT INTO empNTpo_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aaroʌ̃ba israelerãa mãwã jara b̶ʌd̶e jũmarãba ẽjũã põãsa ewaraga b̶ʌd̶aa acʌsid̶aa. Maʌ̃ne jʌ̃rãrã ãdji na jira b̶ʌd̶e Ãcõrẽ quĩrãwãrẽã dorrodorroada unusid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Maʌ̃be Ãcõrẽba Moisea nãwã jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","–Mʌ̃a ũrĩ b̶ʌa israelerãba quĩrũbid̶eba biẽ́ jara panʌda. Maʌ̃ bẽrã ãdjirãa jaradua: “Nane queubod̶od̶e bãrãba nedjarada cod̶ia. Nu diaped̶a paʌ̃da jãwũã cod̶ia. Maʌ̃neba cawad̶ia mʌ̃ra bãrã Ãcõrẽda.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Quewara israelerã duanʌma põrãba birasia. Maʌ̃ awara diaped̶ed̶a cũrãsaba ẽjũãra b̶eguea nũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ẽjũã põãsabʌrʌd̶e nãũcha torroa qued̶eada odjacuaped̶a ecasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Maʌ̃ unusid̶ad̶e israelerãba cawaẽ́ panasid̶aa cãrẽda mãwã b̶ʌda. Maʌ̃ bẽrã ãdjidub̶a iwid̶i duanasid̶aa: –¿Jãʌ̃ra cãrẽ?– Maʌ̃ne Moiseba ãdjirãa jarasia: –Jãʌ̃ra Ãcõrẽba dia b̶ʌ paʌ̃a. Idjia dia b̶ʌa dadjirãba cod̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ãcõrẽba nãwã obi b̶ʌa: jãʌ̃ paʌ̃ra dadjirãba dadji diguid̶abemarã itea jʌrʌ ped̶ida panʌa ara dadjia ewari ab̶aʌd̶e cobada quĩrãca. Ãdjiza eped̶eco jũgurua ab̶a eded̶ida panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","18","Ara maʌ̃da israelerãba ãdji diguid̶abemarãba cobada quĩrãca jʌrʌ pesid̶aa. Ʌ̃cʌrʌba waitabeara jʌrʌ pesid̶aa idjab̶a ʌ̃cʌrʌba maãrĩara jʌrʌ pesid̶aa. Maʌ̃be ãdji diguid̶abemarã itea eped̶eco jũguruad̶e zasid̶aa. Dji waitabeara jʌrʌ ped̶aba ad̶uba erob̶aẽ́ basía idjab̶a dji maãrĩara jʌrʌ ped̶aba cʌrebaeẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Maʌ̃be Moiseba ãdjirãa jarasia: –Ni ab̶aʌba nurẽmabema carea wagaiẽ́ b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Baribʌrʌ Moiseba jarad̶ara ʌ̃cʌrʌba ĩjãnaẽ́ basía. Ãdjirãba waga b̶ʌsid̶aa nurẽma cod̶i carea. Baribʌrʌ ãdjia waga b̶ʌped̶ad̶ara oregueaped̶a qui barasia. Ĩjãnaẽ́ panʌ carea Moisera ãdjirã ume quĩrũsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Nurẽmaza maʌ̃ paʌ̃ra jʌrʌ pebadjid̶aa ãdji diguid̶abemarãba ewari ab̶aʌd̶e cobada quĩrãca daucha. Diaped̶ed̶a jʌrʌ pebadjid̶aa besea jʌ̃wʌ̃rʌ̃ãba maʌ̃ paʌ̃ra dorrab̶ariped̶a nẽbabadji bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Seibema ewarid̶e ãdjirãba ewari umé carea jʌrʌ pesid̶aa. Ãdji diguid̶abemarã itea eped̶eco jũgurua umé edasid̶aa. Maʌ̃be israelerã bororãba Moisea jarad̶e wãsid̶aa ãdjia arid̶e osid̶ada. ");
INSERT INTO empNTpo_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Maʌ̃ne Moiseba ãdjirãa jarasia: –Ara maʌ̃ quĩrãca Ãcõrẽba obi b̶ʌa. Ãcõrẽba jarasia: “Nubema ewarira bãrã ʌ̃nãũbada ewaria. Mʌ̃ itea maʌ̃ ewarira bãrãba wagad̶ida panʌa. Ʌ̃nãũbada ewarid̶e bãrãra ne djud̶iẽ́ panʌ bẽrã, nane od̶adua bãrãba nu co quĩrĩã panʌ quĩrãca. Ne djud̶ibʌrʌ nane ne djud̶adua. Ãbud̶ibʌrʌ nane ãbud̶adua. Maʌ̃gʌra nubema carea waga b̶ʌd̶adua.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Moiseba jarad̶a quĩrãca israelerãba jũma od̶aped̶a waga b̶ʌsid̶aa nurẽma cod̶i carea. Nurẽma maʌ̃ djico waga b̶ʌped̶ad̶ara oregueaẽ́ b̶asia idjab̶a qui neẽ́ b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Maʌ̃ne Moiseba israelerãa jarasia: –Bãrãba waga b̶ʌped̶ad̶a djicora id̶i cod̶adua ʌ̃nãũbada ewari bẽrã. Naʌ̃ ewarira Ãcõrẽ itea wagad̶ida panʌa. Maʌ̃ bẽrã id̶ira Ãcõrẽba dia b̶ʌ paʌ̃ra neẽ́ baya. ");
INSERT INTO empNTpo_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Domiaza sei ewarid̶e bãrãba paʌ̃ra jʌrʌ ped̶ida panʌa. Baribʌrʌ sietebema ewarid̶era neẽ́ baya, Ãcõrẽba maʌ̃ ewarira bãrã ʌ̃nãũnamãrẽã b̶ʌd̶a bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Moiseba mãwã jarad̶amĩna ʌ̃cʌrʌra maʌ̃ ʌ̃nãũbada ewarid̶e Ãcõrẽba dia b̶ʌ paʌ̃ra jʌrʌ ped̶e wãsid̶aa. Mãwãmĩna ununaẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Maʌ̃ carea Ãcõrẽba Moisea jarasia: –¿Ab̶a sãʌ̃be israelerãba mʌ̃a jara b̶ʌra ĩjãnaẽ́ panani? ");
INSERT INTO empNTpo_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Bio cawad̶adua mʌ̃abʌrʌ bãrãa ʌ̃nãũbada ewarida diasida. Maʌ̃ carea domiaza seibema ewarid̶e paʌ̃ra ewari umébema carea diabaria. Baribʌrʌ sietebema ewarid̶e bãrãra diguid̶a ʌ̃nãũnida panʌa. Maʌ̃ ewarid̶e mʌ̃a dia b̶ʌ paʌ̃ra jʌrʌ ped̶e wãniẽ́ panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Maʌ̃ bẽrã israelerãra sietebema ewarid̶e ʌ̃nãũbadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ãcõrẽba dia b̶ʌ paʌ̃ra israelerãba trʌ̃ b̶ʌsid̶aa “maná.” Culãdrʌ ta quĩrãca pichia querasia. Torroa b̶asia idjab̶a cũã b̶asia urrajõnaa od̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Maʌ̃be Moiseba israelerãa jarasia: –Ãcõrẽba nãwã jarasia: “Manára eped̶eco jũgurua ab̶a zad̶aped̶a waga b̶ʌd̶adua bãrã warrarãneba yõbʌdarãba ununamãrẽã. Mãwã ãdjirãba cawad̶ia mʌ̃a bãrã Egiptod̶eba ẽdrʌ enesid̶e cãrẽda naʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶e cobisida.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Maʌ̃be Moiseba Aaroʌ̃a jarasia: –Manára eped̶eco jũgurua ab̶a zaped̶a zocod̶e wagadua. Maʌ̃ra Ãcõrẽ quĩrãpita b̶ʌdua. Jãma waga eropanania dadji warrarãneba yõbʌdarãba ununamãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Ara maʌ̃da Aaroʌ̃ba manáda zaped̶a waga b̶ʌsia Ãcõrẽba Moisea jarad̶a quĩrãca. (Nocoarebema ewarid̶e maʌ̃ manára Ãcõrẽ bauruded̶e waga b̶ʌsid̶aa.) ");
INSERT INTO empNTpo_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Israelerãba manáda cuarenta poa cosid̶aa Canaaʌ̃ druad̶e jũẽbʌdamisa. Canaaʌ̃ druad̶e jũẽsid̶ad̶e manára waa cod̶aẽ́ basía maʌ̃ druad̶ebemarãba uped̶ad̶ada baraad̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Ãdji eped̶eco jũgurua ab̶a ẽberã ab̶aʌba ewari ab̶aʌd̶e cobari quĩrãca daucha poya b̶ʌa.) ");
INSERT INTO empNTpo_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Maʌ̃be israelerãra ẽjũã põãsa ewaraga b̶ʌ Siʌ̃ abadad̶eba jũma wãbʌrʌsid̶aa. Wãnane Ãcõrẽba cawabibadjia sãma wãnida panʌda idjab̶a sãma cãĩnida panʌda. Maʌ̃ne Repidiʌ̃ abadama jũẽne wãsid̶aa. Baribʌrʌ mama baidora neẽ́ basía dod̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Maʌ̃ bẽrã ãdjirãba quĩrũbid̶eba Moiseda biẽ́ jarasid̶aa: –Bʌa dairãa baidora diaida b̶ʌa dod̶i carea.– Maʌ̃ne Moiseba ãdjirãa jarasia: –¿Cãrẽ cãrẽã jãwã mʌ̃́a biẽ́ bed̶ea panʌ? ¿Ãcõrẽba sãwã oi cawaya jãwã panʌca?– ");
INSERT INTO empNTpo_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Baribʌrʌ israelerã opichia panʌ bẽrã quĩrũbid̶eba Moisea jara duanasia: –¿Cãrẽ cãrẽã dairãra Egiptod̶eba ẽdrʌ enesi? Dairãra, dai warrarãra, idjab̶a dai animarã sid̶a opichiaba jũma quininia.– ");
INSERT INTO empNTpo_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Maʌ̃ne Moiseba Ãcõrẽa quĩrã djuburiada nãwã iwid̶isia: –Mʌ̃a naʌ̃ ẽberãrãra ¿sãwã oi? Mʌ̃a isabe baidoda diaẽ́bʌrʌ ãdjirãba mʌ̃ra mõgaraba tab̶ari bead̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ãcõrẽba panusia: –Israelerã duanʌmaʌba nocod̶aa wãdua. Israelerã bororãda bʌ ume ededua. Idjab̶a bʌ bacuru Egiptod̶e Nilo dod̶e tawed̶ara bʌ jʌwad̶e ededua. Maʌ̃be wãnadua Horeb eyad̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Mama mõgara waib̶ʌa b̶ʌda ununia. Mʌ̃ra ara maʌ̃ mõgara ʌ̃rʌ̃ b̶aya bʌ carebai carea. Bʌ bacuruba maʌ̃ mõgarara udua. Ara maʌ̃da baidora wea dogoya israelerãba dod̶amãrẽã.– Ara maʌ̃da Moiseba israelerã bororã quĩrãpita Ãcõrẽba jarad̶a quĩrãca osia. Maʌ̃ne baidora wea dogosia jũma israelerãba dod̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Israelerã baido neẽ́ pananama Moiseba trʌ̃ b̶ʌsia Masá idjab̶a Meribá. Idjia trʌ̃ b̶ʌsia Meribá, israelerãba quĩrũbid̶eba biẽ́ bed̶easid̶a bẽrã. Idjab̶a trʌ̃ b̶ʌsia Masá, Ãcõrẽba sãwã oi cawaya israelerãba nãwã jarasid̶a bẽrã: –¿Ãcõrẽra dadjirã tãẽna b̶ʌca wa neẽ́?– ");
INSERT INTO empNTpo_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Israelerãra wad̶i Repidiʌ̃ne panasid̶ad̶e amalecitarãda zed̶aped̶a ãdjirã ume djõni carea panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Maʌ̃ bẽrã Moiseba idji carebabari Josueda trʌ̃ped̶a jarasia: –Ʌ̃cʌrʌ umaquĩrãrãda jʌrʌ pedua nu amalecitarã ume djõne wãni carea. Maʌ̃ne mʌ̃ra eya zaque borod̶e b̶aya. Ãcõrẽba ne ununaca obi b̶ad̶a bacuruda mʌ̃ jʌwad̶e erob̶aya.– ");
INSERT INTO empNTpo_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Nurẽma Josuera idjia jʌrʌ ped̶a ẽberãrã sid̶a amalecitarã ume djõne wãsid̶aa Moiseba jarad̶a quĩrãca. Maʌ̃misa Moisera, Aaroʌ̃ra, Hur sid̶a eya zaque borod̶aa wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mama Moiseba idji jʌwara ʌ̃taa wa nũmesia. Idji jʌwa ʌ̃taa wa nũmʌne israelerãba amalecitarãra poyabʌda basía. Baribʌrʌ idji jʌwara sẽped̶a ed̶aa norrab̶aribʌrʌd̶e amalecitarãba israelerãra poyabʌda basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Maʌ̃ne Moise jʌwara bio norrab̶ari b̶ʌ bẽrã Aaroʌ̃ba Hur ume mõgara waib̶ʌada enesid̶aa Moisera maʌ̃ ʌ̃rʌ̃ chũmemãrẽã. Maʌ̃be Aaroʌ̃ba Hur bid̶a idji jʌwara ʌ̃taa jira eropanesid̶aa, ab̶aʌba jʌwa acʌare, dewarabemaba jʌwa araare. Mãwã Moiseba idji jʌwara ʌ̃taa jira erob̶asia ab̶a ʌ̃mãdau b̶aebʌrʌd̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Maʌ̃ne Josueba idjia edad̶a ẽberãrã ume amalecitarãra poyasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Maʌ̃be Ãcõrẽba Moisea jarasia: –Bãrãba amalecitarã poyaped̶ad̶ara cartad̶e b̶ʌdua israelerãba quĩrãdoarãnamãrẽã. Idjab̶a Josuéa jaradua mʌ̃a amalecitarãra naʌ̃ ẽjũãne jũma jõbida.– ");
INSERT INTO empNTpo_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moiseba mõgarada ʌ̃tʌ pã buesia Ãcõrẽba poyabid̶ada quĩrãnebad̶i carea. Maʌ̃ mõgara ʌ̃tʌ pã bued̶ara Moiseba trʌ̃ b̶ʌsia “Ãcõrẽba dadjirãa poyabibaria.” ");
INSERT INTO empNTpo_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Moiseba nãwã jarasia: –Amalecitarãra Ãcõrẽ ume djõne zeped̶ad̶a bẽrã id̶iba ʌ̃taa Ãcõrẽra ãdjirã ume djõ b̶aya.– ");
INSERT INTO empNTpo_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Moise zãwãrẽ Jetro abadara Madiaʌ̃nebemarã sacerdote basía. Jetroba ũrĩsia sãwã Ãcõrẽba israelerãra Egiptod̶eba ẽdrʌ enesida. Idjab̶a ũrĩsia sãwã Ãcõrẽba idji puru Israelera, Moise sid̶a carebasida. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Naẽna Moiseba idji quima Seporáda ãdji warrarã sid̶a dji zezamaa diabuesia. Maʌ̃ne Jetroba idji caura, dji warrarã umé panʌ sid̶a idji ded̶e bia edasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Idji warra nabema tosid̶ad̶e Moiseba jarasia: “Naʌ̃ druad̶e mʌ̃ra drua ãĩbemada jãwã b̶ʌa.” Mãwã dji warrara trʌ̃ b̶ʌsia Gersoʌ̃. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Dji tẽãbema tosid̶ad̶e Moiseba jarasia: “Mʌ̃ zezaba ĩjã b̶ad̶a Ãcõrẽba mʌ̃ra carebasia. Egiptod̶ebema boroba beai bad̶ada idjia mʌ̃ra ẽdrʌ b̶ʌsia.” Mãwã dji warrara trʌ̃ b̶ʌsia Elieze. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","6","Ẽjũã põãsa ewaraga b̶ʌd̶e Moisera israelerã ume Ãcõrẽ eya caita duanasid̶aa. Maʌ̃ne Moise zãwãrẽ Jetroba idjía naʌ̃ bed̶eada diabuesia: “Mʌ̃da, bʌ quimada, bʌ warrarã sid̶a bʌmaa wãnia.” Maʌ̃ bed̶ea diabued̶acarea ãdjirãra Moisemaa wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Jũẽbʌdad̶e Moiseba idji zãwãrẽra bio b̶ʌsrid̶a audiab̶arid̶e wãsia. Idji zãwãrẽ quĩrãpita quĩrã ed̶aa b̶arruped̶a idji uridarrad̶e isõsia. Maʌ̃ne sãwã b̶ʌ cawaya dji iwid̶id̶aped̶a Moise wua ded̶e ed̶a wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Maʌ̃be Moiseba idji zãwãrẽa Ãcõrẽba israelerã itea od̶ada jũma nẽbʌrʌsia. Ãcõrẽba Egiptod̶ebema boro, jũma egiptorã sid̶a cawa od̶ad̶ebemada, ãdjirã od̶e zesid̶ad̶e bia mĩga panananebemada, idjab̶a Ãcõrẽba ãdjirã ne jũmane carebad̶ad̶ebema sid̶a jũma nẽbʌrʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Maʌ̃ ũrĩped̶a Jetrora bio b̶ʌsrid̶asia Ãcõrẽba israelerãra ne jũmane carebad̶a bẽrã idjab̶a ãdjirãra egiptorã jʌwaed̶abemada ẽdrʌ edad̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jetroba nãwã jarasia: –Bio biya quirua Ãcõrẽra, idjia bãrã israelerãra egiptorã jʌwaed̶abemada, ãdjirã boro jʌwaed̶abema sid̶a ẽdrʌ edad̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Id̶ibʌrʌ mʌ̃a cawasia Ãcõrẽra dji dromaara b̶ʌda. Dewara ãcõrẽda idji quĩrãca neẽ́a. Mãwã cawa b̶ʌa Ãcõrẽba israelerã biẽ́ o eropananarã poyasi bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Mãwã jaraped̶a Moise zãwãrẽ Jetroba Ãcõrẽa animarãda babue diasia. Dewara animarã sid̶a Ãcõrẽa bea diasid̶e Aaroʌ̃ra, jũma israelerã bororã sid̶a idji ume ãbaa dji jʌred̶aped̶a Ãcõrẽ quĩrãpita maʌ̃ animarã djarara cosid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Nurẽma Moisera chũmesia israelerã nẽbʌra cawa oi carea. Diaped̶abemada ab̶a queubʌrʌd̶aa israelerãra Moisema powua duanasid̶aa ãdji nẽbʌrada cawa omãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Moise zãwãrẽba maʌ̃ unusid̶e idjía jarasia: –¿Cãrẽ cãrẽã jãwã bʌdub̶aʌba naʌ̃ ẽberãrã nẽbʌrara cawa o b̶ʌ? Bʌdub̶a b̶ʌ bẽrã ãdjirãra bʌma ʌ̃ta powua duanʌa diaped̶abemada ab̶a queubʌrʌd̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moiseba idji zãwãrẽa panusia: –Jãwã o b̶ʌa naʌ̃ ẽberãrãra mʌ̃maa zebada bẽrã Ãcõrẽba obi b̶ʌra cawad̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ãdjirã nẽbʌrad̶e panebʌdad̶e mʌ̃maa zebadaa cawa omãrẽã. Cawa obʌrʌd̶e mʌ̃a ãdjirãa Ãcõrẽ leyda cawabibaria.– ");
INSERT INTO empNTpo_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Moise zãwãrẽba jarasia: –Mʌ̃maarã bʌa o b̶ʌra bia b̶ʌẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Diaped̶aʌba ab̶a queubʌrʌd̶aa bʌa cawa o b̶ʌ bẽrã sẽya. Ẽberãrã bʌmaa ze panʌ sid̶a jũma sẽnia. Bʌa o b̶ʌra jũmawãyã b̶ʌa. Naʌ̃ra bʌdub̶aʌba jũma poya oẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Maʌ̃ bẽrã mʌ̃ bed̶eada quĩrãcuita ũrĩdua. Mʌ̃a jarabʌrʌ quĩrãca oibʌrʌ Ãcõrẽba bʌra carebaya. Mʌ̃a jara b̶ʌra naʌ̃gʌa: bʌabʌrʌ naʌ̃ ẽberãrã nẽbʌrara Ãcõrẽa jaraida b̶ʌa idjia cawa omãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Maʌ̃ne Ãcõrẽ leyda bʌa ãdjirãa jaradiaida b̶ʌa. Idjab̶a bʌa ãdjirãa cawabida b̶ʌa cãrẽda od̶ida panʌda quĩrãipa nĩbad̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Maʌ̃ awara bʌ carebad̶amãrẽã ʌ̃cʌrʌ umaquĩrã poya cawa od̶ida b̶eada edadua. Maʌ̃gʌrãba Ãcõrẽra waya b̶ead̶ida panʌa, bed̶ea ab̶a b̶ead̶ida panʌa, idjab̶a paratada awua b̶ead̶iẽ́ panʌa. Mãwã b̶eadrʌ b̶ʌdua israelerã bororãda b̶ead̶amãrẽã. Mil ẽberãrã juachabʌdaza dji boroda ab̶a b̶ʌdua. Cien ẽberãrã juachabʌdaza ab̶a b̶ʌdua. Cincuenta ẽberãrã juachabʌdaza ab̶a b̶ʌdua. Idjab̶a die ẽberãrã juachabʌdaza ab̶a b̶ʌdua. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Maʌ̃ bororãba ẽberãrã nẽbʌrara cawa od̶ida panʌa. Baridua nẽbʌrada ãdub̶a poya cawa od̶aẽ́bʌrʌ, bʌmaa zed̶ida panʌa bʌa cawa omãrẽã. Baribʌrʌ jũma nẽbʌra mãcua zareaẽ́ b̶eara ãdub̶a cawa od̶ida panʌa. Maʌ̃ bororãba careba cawa o panʌ bẽrã bʌra jũmawãyã sẽ b̶aẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Mʌ̃a jara b̶ʌra Ãcõrẽba obi b̶ʌa. Maʌ̃ bẽrã bʌa mãwã oibʌrʌ naʌ̃ ẽberãrã cawa o b̶ʌd̶ebemada biara ʌ̃nãũya. Idjab̶a dji nẽbʌrad̶e pananara ãdji ded̶aa necai wãnia.– ");
INSERT INTO empNTpo_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moiseba idji zãwãrẽba jarad̶ara jũma ĩjã osia. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Idjia Israeld̶ebema umaquĩrã poya cawa od̶ida b̶eada edaped̶a israelerã bororãda b̶ʌcuasia. Mil ẽberãrã juachabʌdaza dji boroda ab̶a b̶ʌsia. Cien ẽberãrã juachabʌdaza ab̶a b̶ʌsia. Cincuenta ẽberãrã juachabʌdaza ab̶a b̶ʌsia. Idjab̶a die ẽberãrã juachabʌdaza ab̶a b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Maʌ̃ bororãba ẽberãrã nẽbʌrada cawa obadjid̶aa. Baridua nẽbʌrada ãdub̶a poya cawa od̶aẽ́ panebʌdad̶e Moisemaa wãbadjid̶aa cawa omãrẽã. Baribʌrʌ jũma nẽbʌra mãcua zareaẽ́ b̶eara maʌ̃ bororãba ãdub̶a cawa obadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Mãwãnacarea Moiseba bia wãduad̶a aped̶a dji zãwãrẽra idji druad̶aa jẽda wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Israelerãra Repidiʌ̃neba wãbʌrʌd̶aped̶a Sinai ẽjũã põãsa ewaraga b̶ʌd̶e jũẽne wãsid̶aa. Jũẽnaped̶a Sinai eya caita duanesid̶aa. Ãdjirã Egiptod̶eba ẽdrʌped̶ad̶acarea jed̶eco uméne mama jũẽsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","4","Maʌ̃be Moisera Sinai eyad̶e ʌ̃taa wãsia Ãcõrẽ ume bed̶eai carea. Maʌ̃ eyad̶e Ãcõrẽba idjira trʌ̃ped̶a nãwã jarasia: –Israelerãa nãwã jaradua: “Bãrã Jacobod̶eba yõped̶ad̶arãba unusid̶aa mʌ̃a sãwã egiptorãra cawa osida. Idjab̶a unusid̶aa sãwã mʌ̃a bãrãra nama mʌ̃maa bio waga enesida nejõbʌba idji warrarãra waga enibabari quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","6","Id̶i mʌ̃a bãrã ume bed̶eada b̶ʌya. Maʌ̃ bed̶eada ĩjã od̶ibʌrʌ, mʌ̃a dewara puru b̶ea cãyãbara bãrãda bio quĩrĩã erob̶aya. Jũma naʌ̃ ẽjũãne b̶eara mʌ̃remĩna mʌ̃a bãrãdrʌ b̶ʌya mʌ̃ itea b̶ead̶amãrẽã idjab̶a jũmarã itea sacerdoterãda b̶ead̶amãrẽã.” Bʌa maʌ̃da israelerãa jarad̶e wãida b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Maʌ̃be Moisera Sinai eyad̶eba ed̶aa wãsia israelerã duanʌmaa. Jũẽped̶a dji bororãra trʌ̃ped̶a ãdjirãa ebud̶a nẽbʌrʌsia jũma Ãcõrẽba idjía jarad̶ada. ");
INSERT INTO empNTpo_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Maʌ̃ne jũmarã israelerãba ab̶ari quĩrãca panusid̶aa: –Ãcõrẽba jara b̶ʌra dairãba jũma od̶ia.– Ara maʌ̃da Moisera Sinai eyad̶e ʌ̃taa wãped̶a Ãcõrẽa mãwã panuped̶ad̶ara jarasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Maʌ̃ne Ãcõrẽba idjía jarasia: –Mʌ̃ra jʌ̃rãrã pãĩmane bʌ ume bed̶ead̶e zeya israelerãba dadji bed̶eabʌdara ũrĩnamãrẽã. Mãwã ãdjirãba jũma bʌa jarabʌrʌra ĩjã panania.– ");
INSERT INTO empNTpo_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","11","Idjab̶a Ãcõrẽba Moisea jarasia: –Israelerãa jarad̶e wãdua nu nurẽma ãdjia acʌ duanʌne mʌ̃ra Sinai eyad̶aa zeida. Maʌ̃ bẽrã id̶i, nu bid̶a ãdjirãba od̶ida panʌa maʌ̃ ewarid̶e mʌ̃ itea bia duanani carea. Mʌ̃ quĩrãpita duanani bẽrã wua tãtod̶ada jʌ̃ pananida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Idjab̶a naʌ̃ eya carra sẽyãda aud̶u jũrã b̶ʌdua. Israelerãra maʌ̃ sẽyã b̶ʌd̶eba ed̶aa wãnacara panʌa. Ãdjirãa jaradua: “Naʌ̃ eyad̶e ʌ̃taa bãrãra wãnacara panʌa ni dji carraya bid̶a wãnacara panʌa. Bariduada wãibʌrʌ wãrãda beuida b̶ʌa.” ");
INSERT INTO empNTpo_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Bariduada maʌ̃ sẽyã b̶ʌd̶eba ed̶aa wãibʌrʌ ni ab̶aʌba idjira jidad̶e wãcara b̶ʌa, ãtebʌrʌ mõgaraba tab̶ari bead̶ida panʌa wa chaba drʌ bead̶ida panʌa. Animarãda wa ẽberã sid̶a ed̶aa wãibʌrʌ idjira bead̶ida panʌa. Ab̶abe cachiru dãrã jĩguabʌrʌd̶e bãrãra naʌ̃ eya carra sẽyã jũrã b̶ʌ caita wãnida panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Maʌ̃be Moisera Sinai eyad̶eba ed̶aa wãsia israelerãmaa. Jũẽped̶a ãdjirãa jarasia: –Bãrãba od̶ida panʌa nu nurẽma Ãcõrẽ itea bia duanani carea.– Ara maʌ̃da ãdji wuara tãtosid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Idjab̶a Moiseba ãdjirãa jarasia: –Nu nurẽmabema carea bãrãra bãdji quima ume quĩrãipa cãĩnida panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ewari ũbead̶e diaped̶a baada b̶ae nũmesia. Maʌ̃ne jʌ̃rãrã pãĩmaba Sinai eyara ãnã eronũmesia idjab̶a cachiru quĩrãca dãrã jĩgua nũmesia. Maʌ̃ carea jũma israelerãra dauperabʌdaba ure duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Maʌ̃be Moiseba israelerãra ãdjirã duanʌmaʌba Sinai eya carrad̶aa edesia Ãcõrẽra bed̶ea b̶ʌda ũrĩnamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Sinai eyara cowaga nũmesia Ãcõrẽra tʌbʌ urua bara zed̶a bẽrã. Maʌ̃ cowaara pea bad̶a cowa quĩrãca nũmasia. Idjab̶a jũma maʌ̃ eyara minijĩchia ure nũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Maʌ̃ne cachiru quĩrãca jĩguabarira jĩguaara nũmesia. Moiseba Ãcõrẽa bed̶eabʌrʌza Ãcõrẽba panubadjia baa jĩguabʌrʌ quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ãcõrẽ Sinai eya borod̶aa zesid̶e Moisera trʌ̃sia ʌ̃taa zemãrẽã. Ara maʌ̃da Moisera ʌ̃taa wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Maʌ̃ne Ãcõrẽba Moisea jarasia: –Israelerãmaa ed̶aa wãdua. Ãdjirãa jaradua naʌ̃ eya carra aud̶u jũrã b̶ʌ sẽyãneba ed̶aa zecara panʌda mʌ̃ acʌd̶i carea. Mãwã od̶ibʌrʌ beud̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Sacerdoterãba ẽberãrã carea mʌ̃́a bed̶eabadamĩna maʌ̃ sẽyãneba ed̶aa zed̶acara panʌa mʌ̃ acʌd̶i carea. Ãdjirã bid̶a od̶ida panʌa mʌ̃ itea bia duanani carea. Mãwã od̶aẽ́bʌrʌ mʌ̃a ãdjirãra quinibiya.– ");
INSERT INTO empNTpo_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moiseba Ãcõrẽa jarasia: –Israelerãra naʌ̃ Sinai eyad̶e ʌ̃taa poya zed̶aẽ́a, bʌa dairãa mãwã jara b̶ʌd̶a bẽrã. Bʌa naʌ̃ eya carra aud̶u jũrã dairãa sẽyãda b̶ʌbisia, naʌ̃ eyara ab̶abe bʌ itea b̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ãcõrẽba idjía jarasia: –Israelerãmaa ed̶aa wãdua. Maʌ̃be Aaroʌ̃da nama ʌ̃taa enedua. Baribʌrʌ sacerdoterãra, dewararã sid̶a naʌ̃ eya carra aud̶u jũrã b̶ʌ sẽyãneba ed̶aa zed̶acara panʌa ʌ̃taa mʌ̃maa zed̶i carea. Mãwã od̶ibʌrʌ mʌ̃a ãdjirãra quinibiya.– ");
INSERT INTO empNTpo_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ara maʌ̃da Moisera ed̶aa wãped̶a israelerãa Ãcõrẽba jarad̶ara jũma nẽbʌrʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ãcõrẽba naʌ̃gʌda jũma jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","–Mʌ̃ra Ãcõrẽa. Mʌ̃abʌrʌ bãrãra Egiptod̶e nezoca b̶ead̶ada ẽdrʌ enesia. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Mʌ̃ awara bãrãba bariduada ãcõrẽ quĩrãca erob̶earãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Baridua bajãnebema za quĩrãca, naʌ̃ ẽjũãnebema za quĩrãca, doed̶abema za quĩrãca bid̶a orãnadua maʌ̃́a iwid̶id̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Baridua jʌwaba od̶a quĩrãpita quĩrã ed̶aa b̶arrud̶aped̶a maʌ̃́a iwid̶irãnadua idjab̶a bia bed̶earãnadua. Mʌ̃drʌ Ãcõrẽ bẽrã mʌ̃a quĩrĩã b̶ʌa bãrãba ab̶abe mʌ̃́abʌrʌ iwid̶id̶ida idjab̶a bia bed̶ead̶ida. Maʌ̃ bẽrã bãrãba mʌ̃da igarad̶aped̶a cadjiruada o pananibʌrʌ, mʌ̃a bãrãda, bãrã warrarãda, bãrã wiuzaquerãda, ãdjirã warrarã sid̶a cawa o b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Baribʌrʌ bãrãba mʌ̃da quĩrĩã panananibʌrʌ, idjab̶a mʌ̃ leyra ĩjã o pananibʌrʌ, mʌ̃a bãrãra, jũma bãrã warrarãneba yõbʌdarã sid̶a ewariza quĩrĩã b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Mʌ̃ra bãrã Ãcõrẽa. Mʌ̃ trʌ̃ra bariduad̶e trʌ̃ jararãnadua. Ab̶aʌba mʌ̃ trʌ̃da bariduad̶e trʌ̃ jaraibʌrʌ, mʌ̃a maʌ̃ ẽberãra cawa oya. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Quĩrãnebad̶adua ʌ̃nãũbada ewarira mʌ̃ itea wagad̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Bãrãba od̶ida panʌra sei ewarid̶e jũma od̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Sietebema ewarira ʌ̃nãũbada ewaria. Maʌ̃ ewarira mʌ̃ itea wagad̶ida panʌa. Maʌ̃ ewarid̶e bãrãba ni cãrẽ trajura od̶acara panʌa. Bãrã warrarãba, bãrã caurãba, bãrã nezoca umaquĩrãrãba, bãrã nezoca wẽrãrãba, bãrã animarãba, ãĩbemarã bãrã tãẽna b̶ea bid̶a ni cãrẽ trajura od̶acara panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Mʌ̃a bajãda, ẽjũãda, pusada, jũma ãdjid̶e b̶ea sid̶a sei ewarid̶e jũma oped̶a sietebema ewarid̶e ʌ̃nãũna bẽrã, maʌ̃ ewarira dji biara b̶ʌda b̶ʌsia idjab̶a mʌ̃ itea wagad̶amãrẽã b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Bãrã zezara, bãrã papa sid̶a waya pananadua. Mãwã bãrãra dãrã duanania mʌ̃a bãrãa diai ẽjũãne. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Mĩã bearãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Daunemarãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Ne drʌarãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Djãrãda sewad̶eba bed̶ead̶e b̶ʌrãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Djãrã dera awuarãnadua. Djãrã quimara awuarãnadua. Djãrã nezoca umaquĩrãda, djãrã nezoca wẽrãda, djãrã pacada, burro sid̶a awuarãnadua. Ab̶ed̶a ne jũma djãrãba erob̶ʌra awuarãnadua.– ");
INSERT INTO empNTpo_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Israelerãba cachiru quĩrãca jĩgua nũmʌda, baa sid̶a ũrĩsid̶aa. Idjab̶a Sinai eyad̶e cowaga nũmʌda unusid̶aa. Maʌ̃ne ne wayaaba ure duanʌda tʌmʌ jĩga duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ãdjirãba Moisea jarasid̶aa: –Dairãba quĩrĩãnaẽ́a Ãcõrẽra dairã ume bed̶eaida. Idjida dairã ume bed̶eaibʌrʌ, beud̶ia. Bʌabʌrʌ dairãa bed̶eadua. Maʌ̃drʌ quĩrãcuita ũrĩnia.– ");
INSERT INTO empNTpo_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moiseba panusia: –Ne wayarãnadua. Ãcõrẽra nãwã ze b̶ʌa bãrãba sãwã od̶i cawaya. Idjia quĩrĩã b̶ʌa bãrãba idji wayaad̶eba cadjiruara o pananaẽ́da.– ");
INSERT INTO empNTpo_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Maʌ̃be Moisera Sinai eyad̶e ʌ̃taa wãsia jʌ̃rãrã pãĩma cowaga nũmʌne ed̶a Ãcõrẽ b̶ʌmaa. Baribʌrʌ israelerãra tʌmʌ jĩga duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Maʌ̃ne Ãcõrẽba Moisea jarasia: –Israelerãa nãwã jaradua: “Bãrã cʌwʌrʌba ũrĩsid̶aa mʌ̃a bajãneba bãrãa bed̶ea b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Maʌ̃ bẽrã oro od̶ada idjab̶a parata od̶ada baridua za quĩrãca orãnadua maʌ̃́a iwid̶id̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Animarã babue diabada mʌ̃ itea od̶i carea egoroda ʌ̃tʌ boromea bued̶adua. Bãrã ovejada, chiwatuda, paca sid̶a bead̶aped̶a maʌ̃ ʌ̃rʌ̃ mʌ̃́a babue diad̶ida panʌa. Maʌ̃ awara mʌ̃ ume necai b̶ai careabema animarãda maʌ̃ ʌ̃rʌ̃ diad̶ida panʌa. Mʌ̃a bãrãa jarabʌrʌma ara maʌ̃ quĩrãca od̶adua mʌ̃da bia jarad̶i carea. Mama mʌ̃ra zeya bãrã carebai carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Mʌ̃ itea animarã babue diabada obʌdad̶e mõgarada ʌ̃tʌ pã bued̶ibʌrʌ, maʌ̃ mõgarara daucha chĩ orãnadua. Bãrãba mõgarada daucha chĩ od̶ibʌrʌ maʌ̃ mõgarara mʌ̃ quĩrãpita biẽ́ b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Idjab̶a animarã babue diabadad̶e ʌ̃taa dumeneba wãrãnadua dewararãba bãrãra ãcad̶a jira b̶ʌ quĩrãca unurãnamãrẽã.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Ãcõrẽba Moisea jarasia: –Naʌ̃ leyda israelerãa jaradua. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Bariduaba ab̶arica hebreoda idji nezoca bamãrẽã nẽdoibʌrʌ, sei poabe idji nezoca baya. Siete poa jũẽnacarea maʌ̃ ẽberãra nezoca bad̶ada ẽdrʌya. Ẽdrʌbʌrʌd̶e idjia ẽdrʌi careabema parata diaida b̶ad̶ara diaẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Maʌ̃ nezoca nẽdosid̶e deu b̶asibʌrʌ, ẽdrʌbʌrʌd̶e idub̶a ẽdrʌida b̶ʌa. Quima bara b̶asibʌrʌ, ẽdrʌbʌrʌd̶e dji quima bara ẽdrʌida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Baribʌrʌ dji nẽdod̶aba maʌ̃ nezocada quima diaibʌrʌ, maʌ̃ne nezocaba warrarãda wa caurãda unuibʌrʌ, ẽdrʌbʌrʌd̶e idub̶a ẽdrʌida b̶ʌa. Idji quimara, warrarã sid̶a dji nẽdod̶aba idji itea jũma peida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Baribʌrʌ maʌ̃ nezocaba dji quimada, dji warrarãda, idji nẽdod̶a sid̶a quĩrĩã b̶ʌbʌrʌ, ẽdrʌ amaaba nãwã jaraida b̶ʌa: “Mʌ̃ quimada, mʌ̃ warrarãda, mʌ̃ nẽdod̶a sid̶a quĩrĩã b̶ʌ bẽrã mʌ̃ra ẽdrʌ quĩrĩãẽ́ b̶ʌa.” ");
INSERT INTO empNTpo_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Maʌ̃ne dji nẽdod̶aba idjira dji bororãmaa edeida b̶ʌa jũmarãba cawad̶amãrẽã maʌ̃ nezocara ẽdrʌ quĩrĩãẽ́ b̶ʌda. Maʌ̃be dji nezocara ded̶e ed̶a wãbada icawa edeped̶a dji nẽdod̶aba idji cʌwʌrʌra cũmia b̶ʌba uya suida b̶ʌa. Maʌ̃be maʌ̃ nezocara idji nẽdod̶ad̶e baya ab̶a jaid̶abʌrʌd̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Bariduaba idji cauda nezoca bamãrẽã nẽdobueibʌrʌ, maʌ̃ wẽrãcaura poya ẽdrʌẽ́a umaquĩrã nezoca ẽdrʌbari quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Dji nẽdod̶aba maʌ̃ wẽrãcaura edai carea nẽdosibʌrʌ, baribʌrʌ idjira biẽ́ unuped̶a edaẽ́bʌrʌ, idji ẽdrʌi careabema paratara idu diabida b̶ʌa. Dji nẽdod̶aba maʌ̃ wẽrãra igarasimĩna drua ãĩbemarãa nẽdobuecara b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Dji nẽdod̶aba maʌ̃ wẽrãcauda idji warra quima bamãrẽã nẽdosibʌrʌ, idji cau quĩrãca erob̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Dji nẽdod̶aba dewara wẽrãda edaibʌrʌ, idjia naãrã erob̶ad̶ara igaraiẽ́ b̶ʌa. Idjia wad̶ibid̶a ne coi careabemada, wua sid̶a dia b̶aida b̶ʌa. Wad̶ibid̶a idji quima ara quĩrãca erob̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Idjia ne coi careabemada, wua sid̶a dia b̶aẽ́bʌrʌ, idjab̶a idji quima araa quĩrãca erob̶aẽ́bʌrʌ, maʌ̃ wẽrãra ẽdrʌida b̶ʌa idji ẽdrʌi careabema parata diaida b̶ad̶a diaẽ́. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Bariduaba djãrã puo b̶ʌd̶e beaibʌrʌ, idjira bead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Baribʌrʌ mĩã beai crĩchaẽ́ b̶ʌd̶e ab̶aʌba djãrãda beaibʌrʌ, idjira bead̶iẽ́ panʌa Ãcõrẽba maʌ̃gʌra iduaribid̶a bẽrã. Baribʌrʌ djãrã bead̶ara mʌ̃a jara b̶ʌmaa wãida b̶ʌa. Mama dewararãba idjira jidad̶acara panʌa bead̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Baribʌrʌ bariduaba mĩã beai crĩcha erob̶ʌd̶e djãrãda beaibʌrʌ, idjira animarã babue diabadamaa mĩrũ wãbʌrʌ sid̶a dji bororãba jidad̶aped̶a bead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Bariduaba dji zezada dji papa sid̶a puoibʌrʌ, idjira bead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Bariduaba djãrãda nẽdobuei carea jidaibʌrʌ, idjira bead̶ida panʌa. Idjia jidad̶ada nẽdobuesibʌrʌ wa wad̶ibid̶a jida erob̶ʌbʌrʌ, idjira bead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Bariduaba dji zezada, dji papa sid̶a biẽ́ jaraibʌrʌ, idjira bead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","Ijara panʌne ab̶aʌba dewarabemada mõgaraba wa jʌwaba chĩbʌrʌ, baribʌrʌ beaẽ́bʌrʌ, idjira bead̶iẽ́ panʌa. Idjia puod̶ara cʌd̶ad̶e b̶eibʌrʌ idjab̶a pirab̶aribʌrʌd̶e bardonaba wãida b̶ʌbʌrʌ, djãrã puod̶aba idji cacua bia b̶emãrẽã diaida b̶ʌa. Idji traju poya oẽ́ b̶ʌ ewari sid̶a jũma diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Bariduaba idji nezoca wẽrãda wa nezoca umaquĩrãda bacuruba u erob̶ʌd̶e beaibʌrʌ, idjira cawa od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Baribʌrʌ ewari umé babʌrʌd̶e idji nezocara wad̶i zocai b̶ʌbʌrʌ, idjira cawa od̶iẽ́ panʌa maʌ̃ nezocara idjid̶e bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Umaquĩrã djõ panʌne ab̶aʌba wẽrã b̶iogoa b̶ʌda puoped̶a warrada ʌradʌgaibʌrʌ, baribʌrʌ dji wẽrãda bia b̶esira, dji puod̶aba diaida b̶ʌa dji wẽrã quimaba bãrã bororã bid̶a jara panʌ quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Baribʌrʌ maʌ̃ wẽrãra beusira dji bead̶ara ab̶arica bead̶ida panʌa. Dji wẽrãra bio cacua biẽ́ b̶esira dji mãwã od̶ara nãwã od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Dauda ãrĩsira ab̶arica dau ãrĩnida panʌa. Quid̶ada b̶ʌasira ab̶arica quid̶a b̶ʌatad̶ida panʌa. Jʌwada biẽ́ b̶esira ab̶arica jʌwa biẽ́ b̶ʌd̶ida panʌa. Jĩrũda biẽ́ b̶esira ab̶arica jĩrũ biẽ́ b̶ʌd̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Õgo bátasira ab̶arica bátad̶ida panʌa. Djarada cõãsira ab̶arica cõãtad̶ida panʌa. Idjab̶a parreba osira ab̶arica parreba otad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Bariduaba idji nezoca wẽrã daud̶e wa nezoca umaquĩrã daud̶e chĩped̶a ãrĩbʌrʌ, maʌ̃ nezocara ẽdrʌ b̶ʌida b̶ʌa idji dau ãrĩna carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Idji nezoca wẽrã quid̶ada wa nezoca umaquĩrã quid̶ada b̶ʌaibʌrʌ, maʌ̃ nezocara ẽdrʌ b̶ʌida b̶ʌa idji quid̶a b̶ʌad̶a carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Pacaba umaquĩrãda wa wẽrãda cachuba su beaibʌrʌ, maʌ̃ pacara mõgaraba tab̶ari bead̶ida panʌa. Bead̶aped̶a dji djarada cocara panʌa. Maʌ̃ne djibarira bed̶ead̶e b̶aẽ́a dji ẽberã beud̶a carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Baribʌrʌ djibariba maʌ̃ pacara cadrʌa b̶ʌda cawa b̶ʌmĩna ẽrã erob̶aibʌrʌ, idjira bed̶ead̶e b̶aya maʌ̃ pacaba wẽrãda wa umaquĩrãda beaibʌrʌ. Maʌ̃ pacara mõgaraba tab̶ari bead̶ida panʌa. Djibari sid̶a bead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Baribʌrʌ beabid̶i cãyãbara dji beud̶a ẽberãrãba paratada iwid̶id̶ibʌrʌ, paca djibariba beu amaaba dji bororãba jarabʌda quĩrãca diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ara maʌ̃ quĩrãca od̶ida panʌa pacaba umaquĩrã warrada su beaibʌrʌ wa wẽrãcauda su beaibʌrʌ. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Pacaba djãrã nezoca umaquĩrãda wa djãrã nezoca wẽrãda cachuba su beaibʌrʌ, maʌ̃ pacara mõgaraba tab̶ari bead̶ida panʌa. Maʌ̃ paca djibariba nezoca djibaría parata torroda treinta diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","34","Bariduaba baido juebada uria corod̶a ʌ̃rʌ̃ jũãtrʌ b̶ʌda ãyã b̶ʌibʌrʌ, wa baido juebada uria coroped̶a ewa b̶eibʌrʌ, djãrã pacada wa burroda maʌ̃ uriad̶e ed̶a b̶aeped̶a beuibʌrʌ, dji uria ewa b̶ʌd̶aba djibariba iwid̶ibʌrʌ quĩrãca diaida b̶ʌa. Maʌ̃ne maʌ̃ animarã beud̶ada idjid̶e baya. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Pacaba djãrã pacada beaibʌrʌ, djibarirãba dji zocai b̶ʌ pacada nẽdobued̶aped̶a maʌ̃ paratara ãdjiza ẽsadra edad̶ida panʌa. Dji paca beud̶a sid̶a ãdjiza ẽsadra edad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Baribʌrʌ bariduaba idji pacada cadrʌa b̶ʌda cawa b̶ʌmĩna ẽrã erob̶aibʌrʌ, maʌ̃ne idji pacaba djãrã pacada beaibʌrʌ, idji pacada diaida b̶ʌa dji paca beud̶abari. Maʌ̃ne dji paca beud̶ada idjid̶e baya. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Bariduaba pacada wa ovejada drʌaped̶a beaibʌrʌ wa nẽdobueibʌrʌ, naʌ̃ quĩrãca oida b̶ʌa. Pacada drʌasira paca juesuma jẽda diaida b̶ʌa. Ovejada drʌasira oveja quĩmãrẽ jẽda diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Bariduada diamasi ne drʌa b̶ʌd̶e de djibariba beaibʌrʌ, mĩã bead̶a carea bed̶ead̶e b̶aẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Baribʌrʌ ãsa de djibariba maʌ̃ ne drʌa b̶ʌda beaibʌrʌ, mĩã bead̶a carea bed̶ead̶e b̶aya. Bariduada ne drʌaped̶a jidad̶ibʌrʌ, idjia drʌad̶abari jẽda diaida b̶ʌa. Jẽda diai carea neẽ́ b̶ʌbʌrʌ, idjira nezoca bamãrẽã nẽdobued̶ida panʌa idjia drʌad̶abari jẽda diad̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Bariduaba pacada, burroda, wa ovejada drʌaibʌrʌ, idji jidabʌdad̶e maʌ̃ animarãda wad̶i zocai erob̶ʌbʌrʌ, jẽda diaida b̶ʌa. Maʌ̃ awara ab̶a aud̶u diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Bariduaba idji ẽjũãne wa uva u erob̶ʌma idji animarãda ne cod̶amãrẽã ẽrãbueibʌrʌ, baribʌrʌ maʌ̃ animarãra djãrã ẽjũãne ne cod̶e wãnibʌrʌ, djibarira bed̶ead̶e b̶ʌa. Maʌ̃ bẽrã dji ẽjũã djibaría idji néud̶ebema dji biara b̶ʌda diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Bariduaba idji ẽjũã babuebʌrʌd̶e djãrã néu ewad̶ada wa ewaẽ́ b̶ʌ sid̶a bá wãibʌrʌ, dji bád̶aba jũma dji bá wãnabari diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Ab̶aʌba paratada wa ne bariduada djãrã ded̶e waga erob̶ʌd̶e dewaraʌba drʌaibʌrʌ, dji ne drʌad̶ara jidad̶aped̶a idjia drʌad̶ada jẽda diaida b̶ʌa. Maʌ̃ awara ab̶a aud̶u diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Baribʌrʌ dji ne drʌad̶ada jidad̶aẽ́bʌrʌ, dji ne waga erob̶ad̶ara bãrã bororãmaa eded̶ida panʌa. Maʌ̃be ãdjia quĩrãcuita iwid̶id̶ida panʌa idjia maʌ̃ ne waga erob̶ad̶ara drʌasi cawaya. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Paca carea, burro carea, oveja carea, cacuad̶e jʌ̃bada carea, ne baridua adua b̶ad̶a carea bid̶a ijarad̶ibʌrʌ, ãdjira bãrã bororãmaa wãnida panʌa. Maʌ̃ne dji bororãba quĩrãcuita iwid̶id̶aped̶a cawa jarad̶ia caida bed̶ead̶e b̶ʌda. Maʌ̃be dji bed̶ead̶e b̶ʌba djibaría ãdji ijara panʌ careabemada umé diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","11","Bariduaba burroda, pacada, ovejada, wa baridua animarã sid̶a dewaraa wagabi b̶ʌd̶e maʌ̃ animarãda beuibʌrʌ, wa cawaẽ́ne idub̶a puaibʌrʌ, wa ni ab̶aʌba ununaẽ́ne drʌad̶ibʌrʌ, dji animarã waga erob̶ad̶aba Ãcõrẽ quĩrãpita wãrãneba jaraida b̶ʌa maʌ̃ animarã drʌaẽ́ b̶ʌda. Maʌ̃ jarad̶ara djibariba ĩjãida b̶ʌa. Mãwãra dji animarã waga erob̶ad̶aba djibaría maʌ̃ animarãbari diaiẽ́ b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Baribʌrʌ idjia idu drʌabibʌrʌ, maʌ̃ animarãbari djibaría diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Idjia waga erob̶ʌ animarãda mẽãbema animarãba beaibʌrʌ, dji beud̶ara edeida b̶ʌa acʌbi carea mẽãbema animarãba wãrãda beasida. Mãwãra maʌ̃ animarãbari djibaría diaiẽ́ b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Bariduaba trajabada animarãda iwid̶i edeped̶a djibari neẽ́ne maʌ̃ animarãra idub̶a puaibʌrʌ wa beuibʌrʌ, dji eded̶aba maʌ̃ animarãbari djibaría diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Baribʌrʌ maʌ̃ animarã puabʌrʌd̶e wa beubʌrʌd̶e djibarida aria b̶aibʌrʌ, dji animarã eded̶aba maʌ̃ animarãbari diaiẽ́ b̶ʌa. Idjab̶a maʌ̃ animarã edei carea paratada diasibʌrʌ, maʌ̃ animarãda idub̶a puaibʌrʌ wa beuibʌrʌ, dji eded̶aba maʌ̃ animarãbari waa diaiẽ́ b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Ẽberãba wẽrã umaquĩrã adua b̶ʌda cũrũgaped̶a idji ume cãĩbʌrʌ, maʌ̃ wẽrãra dewara ume quima edai carea bed̶ea b̶ʌẽ́ b̶ʌbʌrʌ, maʌ̃ ẽberãba quima edai careabema paratara dji wẽrã zezaa diaida b̶ʌa idjab̶a dji wẽrãra edaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Baribʌrʌ dji wẽrã zezaba idji cauda maʌ̃ ẽberãa dia quĩrĩãẽ́bʌrʌ, dji ẽberãba maʌ̃ wẽrãra edaẽ́mĩna quima edai careabema paratara diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Jũma jãĩbana wẽrãrãda bead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Bariduaba animarãda oibʌrʌ, idjira bead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Bariduaba animarãda mʌ̃́a babue diai cãyãbara dewara ãcõrẽa babue diaibʌrʌ, idjira bead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Ãĩbema bãrã tãẽna b̶eada biẽ́ orãnadua. Quĩrãnebad̶adua bãrã sid̶a Egiptod̶e ãĩbemarã basida. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Pẽdra wẽrãra wa jẽrãmãrã sid̶a biẽ́ orãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Bãrãba ãdjirã biẽ́ o panʌ carea mʌ̃́a quĩrã djuburiada iwid̶id̶ibʌrʌ, ãdjia iwid̶i panʌra mʌ̃a ũrĩped̶a carebaya. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Mʌ̃ quĩrũbid̶eba iduaribiya dji quĩrũba djõne zed̶aped̶a bãrãra necoba bead̶ida. Mãwã bãrã quimara pẽdra bad̶ia idjab̶a bãrã warrarã sid̶a jẽrãmãrã bad̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Mʌ̃ purud̶ebema ne neẽ́ quiruba parata iwid̶id̶ara diad̶ibʌrʌ, idjia jẽda diabʌrʌd̶e aud̶u iwid̶irãnadua ʌ̃cʌrʌba aud̶u jẽda diabibada quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","27","Bariduaba parata iwid̶id̶a wãrãda jẽda diaida cawabi carea idjia jĩsua carea jʌ̃barida b̶eibʌrʌ, dji parata diad̶aba maʌ̃ra erob̶eiẽ́ b̶ʌa. Queui naẽna dji parata diad̶aba maʌ̃ra diad̶e wãida b̶ʌa djibariba boro cãĩ carea waa neẽ́ b̶ʌ bẽrã. Diad̶e wãẽ́bʌrʌ, djibariba jĩsua carea mʌ̃́a quĩrã djuburiada iwid̶ibʌrʌ, mʌ̃a carebaya mʌ̃ra quĩrã djuburiaid̶a b̶ʌ bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Mʌ̃da, bãrã bororã sid̶a biẽ́ jararãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Mʌ̃a b̶ʌd̶a ewarid̶e bãrã néu naãrã ewabʌdad̶ebemada, uva b̶ad̶ebema sid̶a arid̶e diad̶adua. Jũma bãrã umaquĩrã warra dji nabema tobʌrʌda mʌ̃́a diad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Paca umaquĩrã dji nabema tobʌrʌda, oveja umaquĩrã dji nabema tobʌrʌ sid̶a bãrãba jũma mʌ̃́a bea diad̶ida panʌa. Maʌ̃ animarã zaquera dji papa ume siete ewaribe b̶aya. Nurẽma ochobema ewarid̶e mʌ̃́a bea diad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Bãrã israelerãra mʌ̃ itea bia b̶ead̶ida panʌa. Maʌ̃ bẽrã baridua animarã mẽãbemaba bead̶ada bãrãba cod̶acara panʌa. Maʌ̃ djarara usaa diad̶adua cod̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Djãrãda sewad̶eba jararãnadua. Ẽberã cadjirua od̶ara sewad̶eba carebarãnadua dji cawa obari quĩrãpita. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Dewararãba cadjirua o duanʌne ab̶arica orãnadua. Dji cawa obari quĩrãpita dewararãba dji cadjirua od̶aare sewad̶eba bed̶ea duanʌne ab̶arica orãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Idjab̶a dji cawa obari quĩrãpita mĩã djuburi quiruare sewad̶eba bed̶earãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Bʌ dji quĩrũ paca aduad̶ada wa burro aduad̶ada unuibʌrʌ, idjía diad̶e wãdua. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Burroda ne zʌgʌaba b̶ae tab̶ʌda unusira ara mãwã b̶erãdua. Djibarira bʌ ume dji quĩrũmĩna carebadua maʌ̃ animarãra piradrʌmãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Mĩã djuburi quiru cawa obʌdad̶e arid̶e od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Sewad̶eba djãrã jara panʌra ũrĩniẽ́ panʌa. Ẽberã bed̶ea neẽ́ b̶ʌra bead̶iẽ́ panʌa. Mãwã obʌrʌra mʌ̃ quĩrãpita bed̶ead̶e b̶eya. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Bariduaba paratada idjiare bed̶eamãrẽã diaibʌrʌ, maʌ̃ paratara edarãnadua. Edad̶ibʌrʌ daub̶errea panʌ quĩrãca panenaped̶a jipa cawa od̶aẽ́a. Mãwãra dji bed̶ea neẽ́ b̶ʌda bed̶ead̶e b̶ʌd̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Ãĩbema bãrã tãẽna b̶eara biẽ́ orãnadua. Bãrãba cawa panʌa djãrã druad̶e b̶ʌd̶e dadjira sãwã b̶abarida, bãrãra Egiptod̶e drua ãĩbemarã basi bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Sei poa bãrã ẽjũãra od̶aped̶a ewad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Baribʌrʌ siete poa jũẽbʌrʌd̶e ẽjũãra od̶iẽ́ panʌa. Maʌ̃ poad̶e bãrãnebema ne neẽ́ qued̶eaa dji tununa pureabʌrʌra idu ewabid̶adua, idjab̶a ãdjia ewaped̶ad̶aẽ́ra idu b̶ʌd̶adua animarã mẽãbemarãba cod̶amãrẽã. Ara maʌ̃ quĩrãca od̶adua bãrã uvara, olivo sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Bãrãra sei ewari trajad̶ida panʌa. Baribʌrʌ sietebema ewarid̶e bãrãra ʌ̃nãũnida panʌa. Bãrã pacada, burroda, nezocada, idjab̶a drua ãĩbema bãrã tãẽna panʌ sid̶a ʌ̃nãũnida panʌa wayacusa ʌb̶ʌad̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Jũma mʌ̃a jarad̶ada quĩrãcuita od̶adua. Dewara ãcõrẽca b̶eaa ni maãrĩ bid̶a iwid̶irãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Poaza b̶arima ũbea bãrãba ewari dromada mʌ̃ itea od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Naãrã paʌ̃ ẽsãbari neẽ́ cobada ewarida od̶ida panʌa. Bãrãba siete ewari paʌ̃ ẽsãbari neẽ́ b̶ʌda cod̶ida panʌa mʌ̃a jarad̶a quĩrãca. Maʌ̃ra od̶adua mʌ̃a jara b̶ʌd̶a ewari Abib jed̶ecod̶e, bãrãra maʌ̃ jed̶ecod̶e Egiptod̶eba ẽdrʌped̶ad̶a bẽrã. Maʌ̃ ewarid̶e mʌ̃́a ne diai carea neẽ́ b̶ʌra mʌ̃ quĩrãpita wãcara b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Maʌ̃ awara bãrã néud̶ebema naãrã ewaped̶ad̶a carea b̶ʌsrid̶a ewarida od̶ida panʌa. Idjab̶a bãrã néu jũma ewaped̶ad̶acarea bid̶a b̶ʌsrid̶a ewarida od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Mʌ̃ra bãrã Boroa. Poaza jũma umaquĩrãrãba mʌ̃ quĩrãpita maʌ̃ ũbeabema ewari dromara od̶e ze pananida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Animarã mʌ̃́a babue diabʌdad̶e dji oada paʌ̃ ẽsãbari bara b̶ʌ ume babue diarãnadua. Idjab̶a ʌ̃nadrʌi naẽna dji dragara jũma babued̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Bãrã néu naãrã ewabʌdad̶ebemada dji biara b̶ʌdrʌ mʌ̃ ded̶aa diad̶e zed̶adua. Chiwatu zaquera dji papa jub̶ad̶e djurãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Ũrĩnadua. Mʌ̃ nezoca bajãnebemada bãrã na wãbiya bia waga edemãrẽã mʌ̃a bãrã itea erob̶ʌ ẽjũãnaa. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Jũma idjia jara b̶ʌra ĩjã od̶adua. Ĩjã od̶aẽ́bʌrʌ idjia bãrãra quĩrã djuburiaẽ́a, mʌ̃ trʌ̃neba bed̶ea b̶ʌ bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Baribʌrʌ idjia jara b̶ʌda quĩrãcuita ĩjã od̶ibʌrʌ idjab̶a mʌ̃a obi jarad̶ada jũma ĩjã od̶ibʌrʌ, bãrã dji quĩrũ ume mʌ̃ra dji quĩrũ baya. Bãrã ume djõne zebʌdad̶e mʌ̃drʌ ãdjirã ume djõya. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Mʌ̃ nezoca bajãnebemada bãrã na wãya. Idjia bãrãra edeya amorreorã, hititarã, perezeorã, cananeorã, heveorã, jebuseorã druad̶aa. Maʌ̃rã ẽberãrãra mʌ̃a jũma jõbiya. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Mama jũẽbʌdad̶e ãdjirãba obada quĩrãca orãnadua. Ãdji jʌwaba ocuad̶a ãcõrẽ quĩrãpita quĩrã ed̶aa b̶arrud̶aped̶a iwid̶irãnadua ni bia bed̶earãnadua. Ãdji jʌwaba ocuad̶a ãcõrẽra idjab̶a maʌ̃ ãcõrẽa bia bed̶ead̶i carea eropanʌ sid̶a ab̶ed̶a jũma ãrĩnadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ab̶abe mʌ̃́abʌrʌ bia bed̶ead̶adua. Maʌ̃ne mʌ̃a bãrãra carebaya. Mʌ̃a baidoda, cod̶i sid̶a diaya. Mʌ̃a iduaribiẽ́a bãrãra cacua biẽ́ b̶ead̶ida. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Bãrã druad̶e wẽrãrãra warra ʌradʌgad̶aẽ́a. Wẽrãrã warra tod̶acara neẽ́ baya. Idjab̶a mʌ̃a bãrãra dãrã zocai b̶ʌya. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Bãrã wãbʌdaza mʌ̃a maʌ̃ druad̶ebemarãra ne wayabiya. Ãdjirãba sãwã od̶ida cawaẽ́ panania. Maʌ̃ba bãrã jũẽbʌdad̶e ãyã mĩrũ pirapod̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Mʌ̃a heveorãra, hititarãra, cananeorã sid̶a ãyã pirapobiya nedʌrrʌba ãdjirã ãyã pirapobibari quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Baribʌrʌ poa ab̶aʌd̶e mʌ̃a ãdjirãra jũma ãyã jʌretaẽ́a. Mãwã obʌrʌbara maʌ̃ druara ẽberã neẽ́ b̶eped̶a mẽãbema animarãra jũmawãyã yõnaped̶a bãrãra biẽ́ ocasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Maʌ̃ carea mʌ̃a maʌ̃ druad̶ebemarãra pĩãca ãyã jʌrecuaya. Maʌ̃ne bãrã yõ wãnane maʌ̃ ẽjũãra jũma edad̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Mʌ̃a bãrãa dia b̶ʌ ẽjũãra b̶ʌa Pusa Purru abadad̶eba ab̶a Pusa Mediterraneo abadad̶aa idjab̶a ẽjũã põãsa ewaraga b̶ʌd̶eba ab̶a Euprate dod̶aa. Mʌ̃a bãrãra carebaya jũma ẽberãrã maʌ̃ ẽjũãne panʌra poyad̶aped̶a ãyã jʌrecuad̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Maʌ̃ ẽberãrã ume bed̶ea b̶ʌrãnadua. Ãdji ãcõrẽca b̶eada bãrã druad̶e erob̶earãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Maʌ̃ ẽberãrãra bãrã druad̶e idu b̶ebirãnadua. Iduaribid̶ibʌrʌ ãdjirãba bãrãa ãdji ãcõrẽca b̶eara ẽpẽbid̶ia. Mãwã bãrãba cadjiruara od̶aped̶a biẽ́ panania.– ");
INSERT INTO empNTpo_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Maʌ̃be Ãcõrẽba Moisea jarasia: –Aaroʌ̃da, Nadáda, Abiuda, idjab̶a setenta israelerã bororã sid̶a bʌ ume naʌ̃ eyad̶e ʌ̃taa enedua. Ãdjirãra tʌmʌ chĩrãborod̶e b̶arru copanenaped̶a mʌ̃́a bia bed̶ead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ãdjirãra mʌ̃ caita zecara panʌa. Ab̶abe bʌdrʌ mʌ̃ caita zeida b̶ʌa. Maʌ̃ awara ni ab̶aʌda bʌ ume naʌ̃ eyad̶e ʌ̃taa zecara b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Maʌ̃be Moisera israelerãmaa ed̶aa zeped̶a Ãcõrẽ leyra jũma nẽbʌrʌsia. Maʌ̃ne jũma israelerãba ab̶ari quĩrãca nãwã jarasid̶aa: –Dairãba Ãcõrẽ leyra jũma ĩjã od̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ara maʌ̃da Moiseba Ãcõrẽ leyra jũma b̶ʌsia. Nurẽma diaped̶ed̶a pirab̶ariped̶a Moiseba animarã babue diabadada Sinai eya carra osia. Maʌ̃ awara animarã babue diabada caita idjia mõgara waib̶ʌada doce ʌ̃ta nũmʌcuasia. Maʌ̃ doce mõgaraba jara b̶ʌa Israel warrarãneba doce puru yõped̶ad̶ada. ");
INSERT INTO empNTpo_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Maʌ̃be Moiseba cũdrarãda diabuesia paca zaquerãda Ãcõrẽa babue diacuad̶amãrẽã idjab̶a Ãcõrẽ ume necai b̶ai careabema paca zaquerãda bea diacuad̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Maʌ̃ paca zaque oa piaped̶ad̶ada ẽsadra Moiseba eped̶ecod̶e wea edasia. Dji ẽsadra b̶ed̶ada animarã babue diabada ʌ̃rʌ̃ jĩãposia. ");
INSERT INTO empNTpo_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Maʌ̃be Ãcõrẽ leyra edaped̶a Moiseba israelerã quĩrãpita jĩgua lesia. Maʌ̃ ũrĩnaped̶a israelerãba jarasid̶aa: –Ãcõrẽ leyra dairãba jũma ĩjã od̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Maʌ̃be Moiseba eped̶ecod̶e wea erob̶ʌ oada edaped̶a israelerã ʌ̃rʌ̃ jĩãpo b̶ʌd̶e nãwã jarasia: –Naʌ̃ oaba jara b̶ʌa Ãcõrẽba dadjirã ume bed̶ea b̶ʌd̶ara dadjirãba, idjia bid̶a jũma od̶ida.– ");
INSERT INTO empNTpo_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mãwãnacarea Moisera, Aaroʌ̃ra, Nadára, Abiura, idjab̶a setenta israelerã bororã sid̶a Sinai eyad̶e ʌ̃taa wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Maʌ̃ne israelerã Ãcõrẽda unusid̶aa. Idji jĩrũ edrera zapiro mõgara od̶a quĩrãca b̶asia. Bajã quĩrãca ẽsã pãwãrã b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Israelerã bororãba Ãcõrẽra unusid̶amĩna Ãcõrẽba ãdjirãra beubiẽ́ basía. Ãcõrẽ quĩrãpita ne cosid̶aa idjab̶a baido dosid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Mãwãnacarea Ãcõrẽba Moisea jarasia: –Sinai eyad̶e mʌ̃maa ʌ̃taa zeped̶a jʌ̃ã b̶edua. Mʌ̃a mõgara pewed̶ea b̶ʌda umé diaya. Maʌ̃ mõgarad̶e mʌ̃a ĩjã obi b̶ʌ bed̶eada b̶ʌ́ erob̶ʌa israelerãa jaradia b̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ara maʌ̃da Moisera idji carebabari Josue ume Sinai eyad̶e ʌ̃taa wãsid̶aa Ãcõrẽ b̶ʌmaa. ");
INSERT INTO empNTpo_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Wãni naẽna Moiseba israelerã bororãa jarasia: –Nama pananadua ab̶a dai zebʌdad̶aa. Aaroʌ̃ra, Hur sid̶a bãrã ume panania. Bariduaba nẽbʌrada oibʌrʌ, ãdjimaa wãnida panʌa maʌ̃ nẽbʌra cawa od̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moise Sinai eyad̶e ʌ̃taa wãsid̶e jʌ̃rãrãba maʌ̃ eyara ãnã edasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Maʌ̃ne Ãcõrẽ quĩrãwãrẽã dorrodorroara Sinai eya ʌ̃rʌ̃ zesia. Dji jewed̶ad̶eba israelerãba Ãcõrẽ quĩrãwãrẽã dorrodorroara maʌ̃ eya borod̶e tʌbʌ eradrʌ nũmʌ quĩrãca unusid̶aa. Jʌ̃rãrãba Sinai eyara sei ewari ãnã erob̶asia. Sietebema ewarid̶e Ãcõrẽba maʌ̃ jʌ̃rãrãneba Moisera trʌ̃sia. ");
INSERT INTO empNTpo_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ara maʌ̃da Moisera eyad̶e ʌ̃taara wãsia jʌ̃rãrãne ed̶a. Mama b̶esia cuarenta ewari ãsa diamasi bid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Maʌ̃ne Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","–Israelerãa jaradua jũma mʌ̃ itea ne dia quĩrĩã b̶eaba bʌmaa enenida panʌda ara ãdji sod̶eba dia quĩrĩã panʌ quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Ãdjirãba diad̶ida panʌra naʌ̃gʌa: oroda, paratada, bronceda, ");
INSERT INTO empNTpo_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","oveja cara nayãna pãwãrã od̶ada, pursupursua od̶ada, purea od̶a sid̶a. Maʌ̃ awara diad̶ida panʌa wua dji biara b̶ʌ lino od̶ada, wua chiwatu cara od̶ada, ");
INSERT INTO empNTpo_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","oveja e purea od̶ada, animarã e biada, acacia bacuruda, ");
INSERT INTO empNTpo_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","olivo dragada ĩbĩrã coad̶i carea. Idjab̶a querada diad̶ida panʌa olivo dragad̶aa puerad̶i carea. Maʌ̃ba ne jũma Ãcõrẽ iteabemada soad̶ida panʌa. Maʌ̃ awara diad̶ida panʌa quera bad̶i careabemada, ");
INSERT INTO empNTpo_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ónice mõgarada, dewara mõgara bia qued̶ea sid̶a sacerdote dji droma djiod̶e carad̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Jũma maʌ̃gʌra ped̶aped̶a bãrãba mʌ̃ itea wua deda od̶ida panʌa mʌ̃ bãrã tãẽna b̶ai carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Maʌ̃ wua dera, dji ed̶a b̶ea sid̶a jũma mʌ̃a obi b̶ʌ quĩrãca daucha od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Baurude acacia bacurud̶eda od̶adua. Maʌ̃ baurude drasoara bicaca umé ʌ̃rʌ̃ ẽsadra b̶aida b̶ʌa. Dji joub̶ʌara bicaca ab̶a ʌ̃rʌ̃ ẽsadra b̶aida b̶ʌa. Dji ʌ̃tʌara bicaca ab̶a ʌ̃rʌ̃ ẽsadra b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Dji jãra, dajadaare bid̶a oro idji awa quiruba bʌrad̶adua. Iquid̶aza jũma pʌrrʌga oroba tuca b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Idjab̶a pĩrũ orod̶eda quĩmãrẽ omoa od̶adua. Maʌ̃ pĩrũra baurude jĩrũza cara b̶ʌd̶adua. Mãwã orroza pĩrũra umé panania. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Idjab̶a acacia bacuruda umé biya erad̶aped̶a oroba bʌrad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Maʌ̃ bacurura pĩrũne ed̶a berajud̶adua baurude jira eded̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Bacurura pĩrũne ed̶a berajusid̶ara waa ẽũtarãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Maʌ̃ bauruded̶e mʌ̃a ĩjã obi b̶ʌ bed̶ea mõgarad̶e b̶ʌ́ diaira waga b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Maʌ̃be oro idji awa quiruda pewed̶ea bad̶aa arid̶e od̶adua baurude ʌ̃rʌ̃ cob̶ʌd̶i carea. Dji drasoara bicaca umé ʌ̃rʌ̃ ẽsadra b̶aida b̶ʌa. Dji joub̶ʌara bicaca ab̶a ʌ̃rʌ̃ ẽsadra b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","19","Idjab̶a oroda edad̶aped̶a mʌ̃ nezoca bajãnebema i bara b̶ʌ za quĩrãca umé toa chĩ od̶adua. Maʌ̃ra bio cara b̶ʌd̶adua dji baurude ʌ̃rʌ̃ cob̶ʌd̶i carea oped̶ad̶a ʌ̃rʌ̃. Quĩrãza iquid̶a ab̶a b̶ʌd̶ad̶ua. Mãwã jũma maʌ̃gʌra ab̶a b̶ʌ od̶a quĩrãca b̶eya. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Mʌ̃ nezoca bajãnebema i bara b̶ʌ za quĩrãca panʌra quĩrã djica ed̶aa b̶arru b̶ʌd̶adua. Ãdji iba dji baurude ʌ̃rʌ̃ cob̶ʌd̶i carea oped̶ad̶ara jũãtrʌ eropanania. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Mãwã od̶aped̶a dji baurude ʌ̃rʌ̃ cob̶ʌd̶adua. Maʌ̃ bauruded̶e mʌ̃a ĩjã obi b̶ʌ bed̶ea mõgarad̶e b̶ʌ́ diaira waga b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Mama mʌ̃ra zeya bʌ ume bed̶eai carea. Mʌ̃ baurude ʌ̃rʌ̃ bajãnebema nezoca i bara panʌ ẽsi mʌ̃a israelerãa obi b̶ʌra cawabiya. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Mesa acacia bacurud̶eda od̶adua. Dji drasoara bicaca umé b̶aida b̶ʌa. Dji joub̶ʌara bicaca ab̶a b̶aida b̶ʌa. Idjab̶a dji ʌ̃tʌara bicaca ab̶a ʌ̃rʌ̃ ẽsadra b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Maʌ̃ mesara oro idji awa quiruba jũma bʌrad̶adua. Dji icawa orroza pʌrrʌga oroba tuca b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Mesa ʌ̃rʌ̃ icawa bacuruda cara b̶ʌd̶adua jũgurua b̶emãrẽã. Maʌ̃ bacuru ʌ̃tʌara jʌwa jĩwĩnĩ quĩmãrẽ b̶aida b̶ʌa. Maʌ̃ sid̶a icawa pʌrrʌga oroba tuca b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","28","Maʌ̃be pĩrũ orod̶eda quĩmãrẽ omoa od̶adua. Maʌ̃ra mesa jĩrũza cara b̶ʌd̶adua dji jũgurua od̶a edrecarebe. Maʌ̃gʌd̶e ed̶a bacuruda berajud̶adua jira eded̶i carea. Maʌ̃ra acacia bacuru od̶a baida b̶ʌa. Biya eraped̶a oroba bʌrad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Idjab̶a oro idji awa quiruda edad̶aped̶a eped̶eco b̶eada, eped̶eco jũgurua b̶eada, taza b̶eada, zoco b̶ea sid̶a mesad̶e b̶ʌd̶i carea od̶adua. Taza b̶eara, zoco b̶ea sid̶a mesad̶e b̶ʌd̶adua uva b̶a mʌ̃́a wea diad̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Idjab̶a paʌ̃ mʌ̃ quĩrãpita b̶aida b̶ʌra maʌ̃ mesad̶e ewariza eropananadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Idjab̶a oro idji awa quiruda edad̶aped̶a ĩbĩrã b̶ʌbadada toa chĩ od̶adua. Dji jĩrũda, dji cacuada, dji gʌ̃rʌ̃gʌ̃rʌ̃ã nepõnõ zaca b̶eara, dji ĩbĩrã b̶ʌd̶i careabema sid̶a ab̶ari oro idji awa quirud̶ebemada b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Maʌ̃ ĩbĩrã b̶ʌbada cacuara sei jʌwate erob̶aya. Orro ab̶aare ũbea b̶aya. Dewarabema orroare bid̶a ũbea b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Jʌwateza gʌ̃rʌ̃gʌ̃rʌ̃ã nepõnõ zaca b̶eada ũbea od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Dji cacuad̶e bid̶a gʌ̃rʌ̃gʌ̃rʌ̃ã nepõnõ zaca b̶eada quĩmãrẽ od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Dji jʌwate cara b̶eaza ab̶a od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Dji gʌ̃rʌ̃gʌ̃rʌ̃ã nepõnõ zaca b̶eara, dji jʌwate b̶eara, dji cacua sid̶a ab̶ari oro idji awa quirud̶ebemada toa chĩ od̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Idjab̶a ĩbĩrãda siete od̶adua. Maʌ̃gʌrã ĩbĩrãra dji ĩbĩrã b̶ʌbada jʌwate quẽbʌza b̶ʌd̶adua mʌ̃ dejãra ʌ̃na erob̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Idjab̶a oro idji awa quiruda edad̶aped̶a ĩbĩrã quĩrã tʌbadara, ĩbĩrã quĩrã tʌd̶a ãyã edebada eped̶eco zaque sid̶a od̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Oro idji awa quiru ĩbĩrã b̶ʌbadara idjab̶a ne jũma idjid̶ebema sid̶a zabʌdad̶e dji zʌgʌara 75 libra b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Jũma daucha od̶adua mʌ̃a naʌ̃ eyad̶e unubid̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Idjab̶a wua deda mʌ̃ itea nãwã od̶adua. Dji biara b̶ʌ lino wuada die edad̶aped̶a maʌ̃ wuad̶e ed̶a mʌ̃ nezoca bajãnebema i bara b̶ʌ zaca b̶eada oveja cara nayãna pãwãrã od̶aba, pursupursua od̶aba, purea od̶a bid̶a biya cad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Maʌ̃ die lino wuara ab̶ari quĩrãca b̶ead̶ida panʌa. Dji drasoara veintiocho bicaca b̶ead̶ida panʌa. Dji joub̶ʌara bicaca quĩmãrẽ b̶ead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Maʌ̃ die wuad̶ebemada juesuma edad̶aped̶a ãbaa cajud̶adua joub̶ʌa b̶emãrẽã. Ab̶ari quĩrãca ãbaa cajud̶adua dewarabema juesuma panʌ sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","5","Maʌ̃ wua joub̶ʌa cajud̶aza i orro ab̶aare cincuenta cʌwʌrʌ cajud̶adua. Maʌ̃ cʌwʌrʌra wua pãwãrã b̶ʌba od̶ida panʌa. Dji cʌwʌrʌra daucha quĩrã tẽũ cob̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Maʌ̃be oroda edad̶aped̶a wua jũẽbarida cincuenta od̶adua. Maʌ̃gʌd̶e cʌwʌrʌza jũẽcuad̶adua maʌ̃ umébema wuara ab̶abe b̶ʌ quĩrãca b̶emãrẽã. Maʌ̃ba mʌ̃ dera ãnẽb̶ari cob̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Maʌ̃be wua chiwatu cara od̶ada once edad̶aped̶a drasoa joub̶ʌa cajud̶adua dji nabema wua ʌ̃rʌ̃ ãnẽb̶ari cob̶ʌd̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Maʌ̃ once wua chiwatu cara od̶ara ab̶ari quĩrãca b̶ead̶ida panʌa. Dji drasoara treinta bicaca b̶ead̶ida panʌa. Dji joub̶ʌara bicaca quĩmãrẽ b̶ead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Maʌ̃ once wuad̶ebemada sei edad̶aped̶a ãbaa cajud̶adua joub̶ʌa b̶emãrẽã. Dewarabema juesuma sid̶a ab̶ari quĩrãca cajud̶adua. Dji sei wua ãbaa cajuped̶ad̶a nocoare b̶ʌ wuara ẽsadra ʌ̃taa b̶ed̶á cob̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Maʌ̃ wua joub̶ʌa cajud̶aza i orro ab̶aare cincuenta cʌwʌrʌ cajud̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Idjab̶a bronceda edad̶aped̶a wua jũẽbarida cincuenta od̶adua. Maʌ̃gʌd̶e cʌwʌrʌza jũẽcuad̶adua maʌ̃ umébema wuara ab̶abe b̶ʌ quĩrãca b̶emãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","13","Maʌ̃ chiwatu cara od̶a wuara dji edrebema wua cãyãbara joub̶ʌara b̶ʌ bẽrã idjab̶a drasoara b̶ʌ bẽrã, mʌ̃ de jẽdaare drasoara jira b̶ʌd̶adua. Idjab̶a orrozara bicaca ab̶a aud̶u jira b̶ʌd̶adua mʌ̃ dera bio ãnẽb̶ari b̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Maʌ̃be oveja e purea od̶ada ãbaa cajud̶adua joub̶ʌa drasoa b̶emãrẽã. Maʌ̃gʌba chiwatu cara od̶a wua ʌ̃rʌ̃ ãnẽb̶ari cob̶ʌd̶adua. Maʌ̃ ʌ̃rʌ̃ dewarabema animarã e biada joub̶ʌa drasoa cajud̶aped̶a ãnẽb̶ari cob̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Idjab̶a mʌ̃ wua de carea acacia bacuruda ʌrrad̶adua maʌ̃ba daucha ʌ̃ta catʌ pẽni carea. Maʌ̃gʌra dji wua cajud̶aba ãnẽb̶ariya. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Dji bacuru ʌrrad̶a drasoara die bicaca b̶ead̶ida panʌa. Dji joub̶ʌara bicaca ab̶a ʌ̃rʌ̃ ẽsadra b̶ead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Dji ed̶aa b̶eira quid̶ate bara od̶adua. Jũma mʌ̃ wua de carea bacuru ʌrrad̶ara mãwã od̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","21","Mʌ̃ wua de orroza veinte bacuru ʌrrad̶ada ʌ̃ta catʌ pẽnida panʌa. Maʌ̃ bacuru ʌrrad̶aza edre parata od̶a uria b̶eada umé uméa b̶ʌd̶adua dji quid̶atera maʌ̃ne ed̶a berajud̶i carea. Mãwã orroza cuarenta parata od̶a uria b̶eara b̶ʌd̶ia maʌ̃ bacuru ʌrrad̶ada daucha pẽ wãni carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Mʌ̃ wua de jẽdaarebemara ʌ̃mãdau b̶aebariare b̶eida b̶ʌa. Maʌ̃are sei bacuru ʌrrad̶ada ʌ̃ta catʌ pẽnida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Maʌ̃ awara bacuru ʌrrad̶ada umé iquid̶aza ʌ̃ta catʌ pẽnida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Dji quẽbʌra jũẽbari bara od̶adua ʌ̃tʌba ed̶aa ara catʌ cob̶emãrẽã. Iquid̶aza mãwã b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Jũma ãbaa ocho bacuru ʌrrad̶ada ʌ̃ta catʌ pẽnida panʌa. Maʌ̃ bacuru ʌrrad̶aza edre parata od̶a uria b̶eada umé uméa b̶ʌd̶adua dji quid̶atera maʌ̃ne ed̶a berajud̶i carea. Mãwã jẽdaarebema parata od̶a uria b̶eara diecisei b̶ʌd̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","27","Idjab̶a acacia bacuruda juesuma erad̶adua de orroza pĩrũ omoa b̶ead̶e berajud̶i carea. Jẽdaare ʌ̃mãdau b̶aebariare bid̶a acacia bacuruda juesuma pĩrũ omoa b̶ead̶e berajud̶adua mʌ̃ wua dera zarea cob̶emãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Orroza dji ẽsibema bacuru berajud̶ara dji de drasoa daucha b̶aida b̶ʌa. Dji jẽdaare b̶ʌ bacuru ẽsi berajud̶ara dji de jed̶ea daucha b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Mʌ̃ wua de carea bacuru ʌrrad̶ara oroba jũma bʌracuad̶adua. Idjab̶a pĩrũ omoa b̶eara orod̶eda od̶adua. Maʌ̃ pĩrũ b̶eara bacuru ʌrrad̶ad̶aa cara b̶ʌd̶adua maʌ̃ne ed̶a bacuru erad̶ara berajud̶i carea. Bacuru erad̶ara oroba jũma bʌrad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Mʌ̃ wua dera od̶adua mʌ̃a naʌ̃ eyad̶e unubid̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Idjab̶a wuada od̶adua mʌ̃ dejãne eatʌ jira b̶ʌd̶i carea. Dji biara b̶ʌ lino wuada edad̶aped̶a maʌ̃ wuad̶e ed̶a mʌ̃ nezoca bajãnebema i bara b̶ʌ zaca b̶eada oveja cara nayãna pãwãrã od̶aba, pursupursua od̶aba, purea od̶a bid̶a biya cad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","33","Maʌ̃be acacia bacuruda quĩmãrẽ tẽnaped̶a oroba bʌracuad̶adua. Maʌ̃ bacurura parata od̶a uria b̶ead̶e berajud̶adua mʌ̃ dejãne ʌ̃ta nũmeanamãrẽã. Bacuruza wua jũẽbari oro od̶ada cara b̶ʌd̶adua. Maʌ̃gʌd̶e wua caped̶ad̶ara eatʌ jira b̶ʌd̶adua mʌ̃ dejãra tʌaju b̶emãrẽã. Mãwã mʌ̃ wua dera dejã umé erob̶aya. Dji nocoarebema dejãra “Ãcõrẽ itea b̶ʌ dejã” ad̶ia. Dji ed̶aare b̶ʌ dejãra “Ãcõrẽ itea biara b̶ʌ dejã” ad̶ia. Mʌ̃ baurudera dji mʌ̃ itea biara b̶ʌ dejãne b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Mama dji oro pewed̶ea b̶ad̶aa arid̶e od̶aped̶ad̶ara baurude ʌ̃rʌ̃ cob̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Idjab̶a wua eatʌ jira b̶ʌ nocoare b̶ʌ dejãne paʌ̃ b̶ʌbada mesara jʌwa araare b̶ʌd̶adua. Jʌwa acʌare ĩbĩrã b̶ʌbadada dji mesa quĩrãpe b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","37","Idjab̶a dji biara b̶ʌ lino wuada edad̶aped̶a maʌ̃ wuad̶e ed̶a oveja cara nayãna pãwãrã od̶ada, pursupursua od̶ada, purea od̶a sid̶a biya cad̶adua. Maʌ̃be acacia bacuruda juesuma tẽnaped̶a oroba bʌracuad̶adua. Maʌ̃ bacurura bronce od̶a uria b̶ead̶e berajud̶adua mʌ̃ wua ded̶e ed̶a wãbadamaa ʌ̃ta nũmeanamãrẽã. Bacuruza wua jũẽbari oro od̶ada cara b̶ʌd̶adua. Maʌ̃gʌd̶e wua cad̶ara dji ed̶a wãbadad̶e jũãtrʌ jira b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Idjab̶a animarã babue diabada acacia bacurud̶eda od̶adua. Dji drasoara bicaca juesuma b̶aida b̶ʌa. Dji joub̶ʌa sid̶a bicaca juesuma b̶aida b̶ʌa quĩrã quĩmãrẽena ab̶arica b̶amãrẽã. Dji ʌ̃tʌara bicaca ũbea b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ab̶ari bacurud̶e iquid̶aza cachu quĩrãca od̶aped̶a maʌ̃ animarã babue diabadara bronceba jũma bʌrad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Idjab̶a tʌbʌ pora ãyã cuabadada, tʌbʌ pora tãĩbadada, oa piabadada, warebada mĩãsuda, tʌbʌdau edebada sid̶a jũma bronced̶eda od̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","5","Idjab̶a jʌrrʌjʌrrʌa bronced̶eda od̶adua. Maʌ̃ jʌrrʌjʌrrʌara animarã babue diabadad̶e dji id̶eba ed̶aa ẽsidra cara b̶ʌd̶adua. Maʌ̃be pĩrũ omoa bronced̶eda quĩmãrẽ od̶aped̶a jʌrrʌjʌrrʌa b̶ʌmaa animarã babue diabada iquid̶aza cara b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","7","Maʌ̃be acacia bacuruda umé erad̶aped̶a bronceba bʌrad̶adua. Maʌ̃ bacurura animarã babue diabada orroza pĩrũ b̶ead̶e berajud̶adua jira eded̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Animarã babue diabadara wãyã uria b̶aya bacuru ʌrrad̶ad̶eda od̶i bẽrã. Ara mʌ̃a naʌ̃ eyad̶e unubid̶a quĩrãca jũma daucha od̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","11","Mʌ̃ wua dera aud̶u jũrã b̶ʌd̶adua dji biara b̶ʌ lino wuaba. Maʌ̃ aud̶u jũrã b̶ʌ orroza veinte bronce od̶a uria b̶eada b̶ʌd̶aped̶a bacuru tẽnara maʌ̃gʌd̶e ed̶a wẽãju nũmʌnadua. Maʌ̃ bacuru quẽbʌra parataba bʌrad̶adua idjab̶a wua jũẽbari parata od̶a sid̶a cara b̶ʌd̶adua. Lino wuara maʌ̃ne eatʌ jũẽcuad̶adua. Mʌ̃ wua de aud̶u jũrã b̶ʌ drasoara cien bicaca b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Jẽdaare bid̶a bronce od̶a uria b̶eada die b̶ʌd̶aped̶a maʌ̃ne bacuru tẽnara ed̶a wẽãju nũmʌnadua. Lino wuara maʌ̃gʌd̶e eatʌ jũẽcuad̶adua. Mʌ̃ wua de aud̶u jũrã b̶ʌ jẽdaarebemara cincuenta bicaca b̶aya idjab̶a ʌ̃mãdau b̶aebariare b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Dji nocoarebemara ʌ̃mãdau odjabariare b̶aida b̶ʌa. Maʌ̃ sid̶a cincuenta bicaca b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Maʌ̃ne dji ed̶a wãbadara ẽsidra b̶aya. Dji ed̶a wãbada jʌwa acʌare bronce od̶a uria b̶eada ũbea b̶ʌd̶aped̶a bacuru tẽnara maʌ̃ne ed̶a wẽãju nũmʌnadua. Jʌwa araare bid̶a ab̶ari quĩrãca od̶adua. Maʌ̃ne lino wuara eatʌ jũẽcuad̶adua. Dji ed̶a wãbada orro ab̶aare wuara quince bicaca b̶aya idjab̶a dewarabema orroare bid̶a quince bicaca b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Mʌ̃ wua de aud̶u jũrã b̶ʌd̶e ed̶a wãbadara veinte bicaca b̶aya. Bronce od̶a uria b̶eada quĩmãrẽ dji ed̶a wãbadama b̶ʌd̶aped̶a bacuru tẽnara wẽãju nũmʌnadua. Maʌ̃be dji biara b̶ʌ lino wuada edad̶aped̶a maʌ̃ wuad̶e ed̶a oveja cara nayãna pãwãrã od̶ada, pursupursua od̶ada, purea od̶a sid̶a cad̶adua. Maʌ̃ wuaba dji ed̶a wãbadara jũãtrʌ b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","18","Jũma mʌ̃ wua de aud̶u jũrã b̶ʌ bacuru tẽnara bronce od̶a uria b̶ead̶e ed̶a wẽãju nũmeania. Bacuru quẽbʌza parata od̶a wua jũẽbarida erob̶ead̶ia idjab̶a parataba bʌrá b̶ead̶ia. Maʌ̃ bacurud̶e eatʌ jũẽ b̶ʌ lino wua joub̶ʌara bicaca juesuma b̶aya. Mʌ̃ wua de aud̶u jũrã b̶ʌ ẽjũã drasoara cien bicaca b̶aya. Dji jed̶eara cincuenta bicaca b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Jũma mʌ̃ wua de dajadaarebema sid̶a bronce od̶a baya. Dji egorod̶e cachid̶i careabema sid̶a bronce od̶a baya. ");
INSERT INTO empNTpo_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Israelerãa jaradua olivo draga idji awa quiruda enenamãrẽã. Maʌ̃ dragara ĩbĩrãne wead̶ia urua b̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aaroʌ̃ba idji warrarã bid̶a mʌ̃ wua ded̶e b̶ʌ ĩbĩrãra quewaraza coad̶ida panʌa mʌ̃ quĩrãpita urua b̶amãrẽã quewara ed̶aʌba ab̶a ʌ̃nadrʌbʌrʌd̶aa. Maʌ̃ ĩbĩrãra mʌ̃ baurude quĩrãpe b̶aya dji wua eatʌ jira b̶ʌ nocoare. Mʌ̃a ĩbĩrã coabi b̶ʌ leyra bãrã israelerãba, bãrã warrarãneba yõbʌdarã bid̶a ewariza ĩjã o pananida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Bʌ djaba Aaroʌ̃ra, idji warrarã Nadára, Abiura, Eleazara, Itamar sid̶a bʌmaa trʌ̃cuadua mʌ̃ sacerdoterã b̶ʌmãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","3","Bʌ djaba Aaroʌ̃ itea djioda quĩrãwãrẽã obidua unubi carea idjidrʌ mʌ̃ sacerdote dji dromaara b̶ʌda. Mãwã israelerãba idjira waya panania. Mʌ̃a ʌ̃cʌrʌa necawaada diasia maʌ̃ djiora od̶amãrẽã. Ãdjía maʌ̃ djiora obidua. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Naʌ̃gʌda bʌ djaba Aaroʌ̃ itea od̶ida panʌa: idjia cacuad̶e wẽãju jʌ̃ida b̶ʌ torro b̶ʌda, ab̶a pãwãrã b̶ʌda, idji jãare jʌ̃ida b̶ʌda, borod̶e jʌ̃ida b̶ʌda, “mʌ̃a quĩrĩã b̶ʌ cawabibari” idji so ʌ̃rʌ̃ jʌ̃ida b̶ʌda, cʌrrʌ trãjʌ̃bari sid̶a. Aaroʌ̃ warrarã itea bid̶a djiora od̶adua. Mãwã Aaroʌ̃ra, idji warrarã sid̶a mʌ̃ sacerdoterãda b̶ead̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Oro bʌrachid̶ada, lino wuada, oveja cara nayãna pãwãrã od̶ada, pursupursua od̶ada, purea od̶a sid̶a edad̶aped̶a maʌ̃gʌ djiora od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Idji jãare jʌ̃ida b̶ʌra dji biara b̶ʌ lino wuaba od̶adua. Maʌ̃ wuad̶e ed̶a oro bʌrachid̶ada, oveja cara nayãna pãwãrã od̶ada, pursupursua od̶ada, purea od̶a sid̶a biya cad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Equiaza jʌ̃bari bara b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Dji cʌrrʌ trãjʌ̃barida dji biara b̶ʌ lino wuaba od̶adua. Maʌ̃ cʌrrʌ trãjʌ̃barira idji jãare jʌ̃ida b̶ʌ ume ãbaa cad̶ida panʌa ab̶a b̶ʌ quĩrãca b̶emãrẽã. Maʌ̃ cʌrrʌ trãjʌ̃barid̶e ed̶a oro bʌrachid̶ada, lino nayãnada, oveja cara pãwãrã od̶ada, pursupursua od̶ada, purea od̶a sid̶a biya cad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","10","Idjab̶a mõgara ónice abadada umé edad̶aped̶a maʌ̃ mõgarad̶e Israel doce warrarã trʌ̃ra jaya b̶ʌd̶adua dji nabemaneba ab̶a dji tẽãbemanaa. Mõgara ab̶aʌd̶e trʌ̃ra sei panania. Dewarabema mõgarad̶e bid̶a trʌ̃ra sei panania. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Djio obariba sẽyã jaya corobari quĩrãca ãdji trʌ̃ra maʌ̃ umébema mõgarad̶e biya jaya b̶ʌd̶ida panʌa. Maʌ̃be mõgarara oro od̶ad̶aa cara b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Maʌ̃ mõgarara Aaroʌ̃ba jãare jʌ̃ida b̶ʌ equiaza ab̶a cajud̶adua. Maʌ̃ mõgarad̶e b̶ʌ́ b̶ʌba Israel warrarãda quĩrãnebabiya. Mãwã Ãcõrẽ quĩrãpita wãbʌrʌd̶e Aaroʌ̃ba Israel warrarã trʌ̃ra idji equiad̶e edeya ãdjirãnebema quĩrãnebabi carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","14","Idjab̶a oro idji awa quiruba carenada umé cad̶adua. Dji quẽbʌra Aaroʌ̃ba jãare jʌ̃ida b̶ʌ equiaza oro od̶ad̶aa cara b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Idjab̶a “mʌ̃a quĩrĩã b̶ʌ cawabibarida” biya od̶adua Aaroʌ̃ba idji so ʌ̃rʌ̃ jʌ̃mãrẽã. Maʌ̃gʌra dji biara b̶ʌ lino wuaba od̶adua. Maʌ̃ wuad̶e ed̶a oro bʌrachid̶ada, oveja cara nayãna pãwãrã od̶ada, pursupursua od̶ada, purea od̶a sid̶a cad̶adua Aaroʌ̃ba jãare jʌ̃ida b̶ʌ caped̶ad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Maʌ̃ wua cad̶ara ẽsidra b̶ed̶á capirud̶adua ne wagabari quĩrãca bamãrẽã. Dji drasoara, dji joub̶ʌa sid̶a jʌwajã ewarama ab̶a b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Maʌ̃ ʌ̃rʌ̃ mõgara biya qued̶eada errecama quĩmãrẽ cara b̶ʌd̶adua. Dji nabema errecad̶e naʌ̃gʌ mõgarada b̶ʌd̶adua: rubí, crisólito, esmeralda. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Umébema errecad̶e b̶ʌd̶adua: granate, zapiro, jade. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Ũbeabema errecad̶e b̶ʌd̶adua: jacinto, ágata, amatista. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Quĩmãrẽbema errecad̶e b̶ʌd̶adua: topacio, ónice, jaspe. Jũma maʌ̃ mõgarara oro od̶ad̶aa carad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Maʌ̃ doce mõgaraba jara b̶ʌa Israel warrarãneba doce puru yõped̶ad̶ada. Mõgaraza sẽyã quĩrãca ãdji trʌ̃ra ab̶a ab̶a jaya b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Idjab̶a oro idji awa quiruba carenada umé cad̶adua “mʌ̃a quĩrĩã b̶ʌ cawabibarira” Aaroʌ̃ba idji so ʌ̃rʌ̃ jʌ̃mãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Pĩrũ orod̶eda umé od̶aped̶a “mʌ̃a quĩrĩã b̶ʌ cawabibari” ʌ̃rʌ̃bema iquid̶aza cajud̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Pĩrũza carena oro cad̶a quẽbʌra ab̶a ab̶a cara b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Dewarabema quẽbʌra cara b̶ʌd̶adua umébema oro od̶ad̶aa Aaroʌ̃ba jãare jʌ̃ida b̶ʌ equiaza. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Dewara pĩrũ orod̶eda umé od̶aped̶a “mʌ̃a quĩrĩã b̶ʌ cawabibari” ed̶aarebema iquid̶aza edrecare cajud̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Dewara pĩrũ orod̶eda umé od̶aped̶a Aaroʌ̃ba jãare jʌ̃ida b̶ʌd̶e cajud̶adua dji cʌrrʌ trãjʌ̃bari ʌ̃taarebe. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Jʌ̃cara pãwãrã od̶aba maʌ̃ pĩrũra ãbaa jʌ̃nadua “mʌ̃a quĩrĩã b̶ʌ cawabibari” edre panʌ pĩrũnaa. Mãwã “mʌ̃a quĩrĩã b̶ʌ cawabibarira” Aaroʌ̃ so ʌ̃rʌ̃ catʌ cob̶eya. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Mʌ̃a quĩrĩã b̶ʌ cawabibarira” Aaroʌ̃ba jʌ̃ b̶aida b̶ʌa mʌ̃ wua ded̶e ed̶a wãbʌrʌd̶e. Mãwã mʌ̃ quĩrãpita b̶ʌd̶e Israel warrarã trʌ̃ra idji so ʌ̃rʌ̃ jʌ̃ erob̶aya israelerãnebemada quĩrãnebabi carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","“Mʌ̃a quĩrĩã b̶ʌ cawabibarid̶e” Uriʌ̃ idjab̶a Tumiʌ̃ abadada ed̶a b̶ʌd̶adua Aaroʌ̃ba idji so ʌ̃rʌ̃ jʌ̃ erob̶amãrẽã. Mãwã mʌ̃ quĩrãpita wãbʌrʌza maʌ̃ Uriʌ̃ idjab̶a Tumiʌ̃neba Aaroʌ̃ba poya cawaya mʌ̃a israelerãa obi b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Idjab̶a wua pãwãrã b̶ʌda edad̶aped̶a Aaroʌ̃ba djio wẽãju jʌ̃ida b̶ʌda od̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Maʌ̃ wuara idji boro berajumãrẽã ẽsidra uria od̶adua. Maʌ̃ uria ira b̶ed̶atʌ cajud̶adua cõãrãmãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Idjab̶a granadajõ za quĩrãca cad̶adua oveja cara nayãna pãwãrã od̶aba, pursupursua od̶aba, purea od̶a bid̶a. Maʌ̃ra Aaroʌ̃ba jʌ̃ida b̶ʌ pãwãrã b̶ʌ ed̶ubema id̶e mimizua pʌrrʌga cajud̶adua. Idjab̶a mimizua pʌrrʌga cajud̶adua pĩrãchiru oro od̶ada. Granadajõ za quĩrãca cad̶ada ab̶a id̶e cajud̶aped̶a maʌ̃are pĩrãchiru oro od̶ada ab̶a cajud̶adua. Jũma pʌrrʌga mãwã cajud̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Maʌ̃ djio pãwãrã b̶ʌra Aaroʌ̃ba jʌ̃ b̶aida b̶ʌa mʌ̃ wua ded̶e ne od̶e wãbʌrʌza. Mʌ̃ wua ded̶e ed̶a mʌ̃ quĩrãpita wãbʌrʌd̶e ab̶a ẽdrʌbʌrʌd̶aa pĩrãchirura jĩguad̶ia. Mãwã idjira beuẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Idjab̶a oroda pewed̶ea berrachid̶adua. Maʌ̃ne naʌ̃ bed̶eada jaya b̶ʌd̶adua: “Ab̶a Ãcõrẽ itea b̶ʌ.” ");
INSERT INTO empNTpo_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Maʌ̃ oro pewed̶ea berrachid̶ara Aaroʌ̃ba borod̶e jʌ̃ida b̶ʌ dratuare jʌ̃cara pãwãrã b̶ʌba jʌ̃ cob̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Maʌ̃ra idji dratud̶e jʌ̃ b̶aida b̶ʌa jũma israelerãba dia panʌda mʌ̃a bia edai carea. Idjab̶a israelerãba mʌ̃́a ne diabʌdad̶e mʌ̃ quĩrãpita biẽ́ od̶ibʌrʌ, maʌ̃ biẽ́ oped̶ad̶ara Aaroʌ̃ba edaya. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Idjab̶a Aaroʌ̃ba djio wẽãju jʌ̃ida b̶ʌ torroa b̶ʌda dji biara b̶ʌ linoba cad̶adua. Cʌrrʌ trãjʌ̃bari sid̶a biya cad̶adua. Idji borod̶e jʌ̃ida b̶ʌ sid̶a dji biara b̶ʌ lino wuaba cad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Aaroʌ̃ warrarã itea bid̶a djio torroa b̶ʌda, cʌrrʌ trãjʌ̃barida, ãdji borod̶e jʌ̃nida panʌ sid̶a od̶adua. Maʌ̃ djio quĩrãwãrẽã b̶ʌda jʌ̃ panʌne israelerãba ãdjirãra waya panania. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Bãrãba jũma oped̶ad̶acarea bʌ djaba Aaroʌ̃a idji warrarãa bid̶a maʌ̃ djiora jʌ̃bidua. Jʌ̃naped̶a olivo dragada ãdjirã boro ʌ̃rʌ̃ weadua unubi carea bʌa ãdjirãra mʌ̃ sacerdoterãda b̶ʌbʌrʌda. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Ãdjirãba edre jʌ̃nida panʌra lino wuad̶eda od̶adua. Maʌ̃ra cʌrrʌd̶eba ab̶a b̶acara daucha b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaroʌ̃ba, idji warrarã bid̶a maʌ̃ edrebemara jʌ̃nida panʌa mʌ̃ wua ded̶e ed̶a wãbʌdaza idjab̶a mʌ̃́a animarã babue diabʌdaza. Mãwã jʌ̃naẽ́bʌrʌ, ãdjirãra beud̶ia cadjiruada o panʌ bẽrã. Maʌ̃ djio jʌ̃bi b̶ʌ bed̶eara Aaroʌ̃ba, idji warrarãba, idji warrarãneba yõbʌdarã bid̶a ewariza ĩjã o pananida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Aaroʌ̃ra, idji warrarã sid̶a mʌ̃ sacerdoterãda b̶ʌi carea bʌa nãwã oida b̶ʌa: paca zaque dji umaquĩrãda ab̶a, oveja dji umaquĩrãda umé edadua. Maʌ̃ animarãra dji biara b̶ʌdrʌ b̶ead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Idjab̶a dji biara b̶ʌ harina trigod̶eda edaped̶a paʌ̃ ẽsãbari neẽ́ b̶eada quĩrã cacua ũbea odua; ʌ̃cʌrʌ harina awa qued̶eada, ʌ̃cʌrʌ nedraga bara b̶eada, idjab̶a ʌ̃cʌrʌ nedragaba ʌ̃rʌ̃ pʌrʌd̶ada. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Maʌ̃ paʌ̃ra jamarad̶e b̶ʌped̶a mʌ̃ wua ded̶aa ededua. Paca zaquera, oveja sid̶a ededua. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Aaroʌ̃ra idji warrarã sid̶a mʌ̃ wua ded̶e ed̶a wãbadamaa ededua. Mama ãdjirãra baidoba sʌgʌdua. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Maʌ̃be Aaroʌ̃ba jʌ̃mãrẽã oped̶ad̶ara idjía jʌ̃bidua. Idjia wẽãju jʌ̃ida b̶ʌ torroa b̶ʌda naãrã jʌ̃bidua. Maʌ̃ ʌ̃rʌ̃ dji pãwãrã b̶ʌda jʌ̃bidua. Maʌ̃ ʌ̃rʌ̃ idji jãare jʌ̃ida b̶ʌra jʌ̃biped̶a cʌrrʌ trãjʌ̃bariba trãjʌ̃ cob̶ʌdua. Maʌ̃be idji so ʌ̃rʌ̃ “mʌ̃a quĩrĩã b̶ʌ cawabibarida” jʌ̃ cob̶ʌdua. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Idji borod̶e jʌ̃ida b̶ʌra jʌ̃biped̶a idji dratud̶e jʌ̃ida b̶ʌ oro pewed̶ea od̶ada jʌ̃ cob̶ʌdua. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Maʌ̃be Aaroʌ̃ boro ʌ̃rʌ̃ olivo draga quera bara b̶ʌda weadua sacerdote dji dromada b̶ʌi carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Idjab̶a Aaroʌ̃ warrarã sid̶a trʌ̃ped̶a ãdjia jʌ̃namãrẽã oped̶ad̶a torroa b̶eada wẽãju jʌ̃bidua. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Ãdjia jʌ̃ panʌra, Aaroʌ̃ba jʌ̃ b̶ʌ sid̶a cʌrrʌ trãjʌ̃bariba trãjʌ̃ cob̶ʌdua. Ãdjia borod̶e jʌ̃nida panʌ sid̶a jʌ̃bidua. Mãwã oida b̶ʌa ãdjirãra sacerdoterãda b̶ʌbʌrʌd̶e. Ãdjirãdrʌ, ãdji warrarãneba yõbʌdarã sid̶a ewariza mʌ̃ sacerdoterãda b̶ead̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Maʌ̃be paca zaqueda mʌ̃ wua ded̶e ed̶a wãbada quĩrãpe eneped̶a Aaroʌ̃ba idji warrarã bid̶a ãdji jʌwara maʌ̃ paca zaque boro ʌ̃rʌ̃ b̶ʌd̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Mama paca zaquera mʌ̃ quĩrãpita beadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Maʌ̃be dji oara piaped̶a bʌ jʌwa jĩwĩnĩra maãrĩ b̶egueaped̶a animarã babue diabada cachu quĩrãca b̶ead̶e soadua. Mãwã soaped̶a oa b̶ed̶ara animarã babue diabada cob̶ʌ caita weadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Maʌ̃be paca zaque b̶ited̶abemada edadua: dji tʌrida, nequimada, idjab̶a cotrua umena dji draga bara. Maʌ̃ra jũma babuedua animarã babue diabadad̶e. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Maʌ̃ paca zaque cacuara, dji era, dji ã sid̶a ãyã tʌmʌ edeped̶a jũma babuedua. Maʌ̃ animarãra mãwã oida b̶ʌa Aaroʌ̃ba idji warrarã bid̶a cadjirua oped̶ad̶ara mʌ̃a quĩrãdoamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Mãwãnacarea umébema oveja mʌ̃ wua ded̶e enenada ab̶a edaped̶a Aaroʌ̃ba idji warrarã bid̶a ãdji jʌwara maʌ̃ oveja boro ʌ̃rʌ̃ b̶ʌd̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Maʌ̃be beabʌrʌd̶e dji oara piadua. Maʌ̃ oaba jĩãpodua animarã babue diabada ʌ̃rʌ̃ idjab̶a orrocawa bid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Maʌ̃be ovejara drapetaped̶a tʌcuadua. Dji jĩrũra, dji jʌ̃si sid̶a sʌgʌped̶a jũma ãbaa buedua dji boro bara. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Maʌ̃be animarã babue diabadad̶e jũma mʌ̃́a babue diadua. Maʌ̃ra mʌ̃a bia unuya. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Oveja b̶ed̶ara edaped̶a Aaroʌ̃ba idji warrarã bid̶a ãdji jʌwara oveja boro ʌ̃rʌ̃ b̶ʌd̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Maʌ̃be beabʌrʌd̶e dji oara piaped̶a soadua Aaroʌ̃ jʌwa araarebema cʌwʌrʌ id̶e, idji jʌwa araarebema jʌwapapad̶e, idjab̶a idji jʌwa araarebema jĩrũpapad̶e bid̶a. Ara maʌ̃ quĩrãca idji warrarã sid̶a odua. Oa b̶ed̶ara animarã babue diabada orroza jĩãpodua. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Maʌ̃ oa dji animarã babue diabadad̶e jĩãpod̶ada maãrĩ edaped̶a pueradua olivo draga quera bara b̶ʌd̶aa. Maʌ̃gʌba Aaroʌ̃ ʌ̃rʌ̃, idji warrarã ʌ̃rʌ̃, ãdjia jʌ̃ panʌ ʌ̃rʌ̃ bid̶a jĩãpodua. Mãwã Aaroʌ̃ra, idji warrarãra, ãdjia jʌ̃ panʌ sid̶a mʌ̃ itea b̶ead̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Maʌ̃be dji oveja dragada, dji druda, dji tʌrida, nequimada, cotruada umena dji draga bara, idjab̶a jʌwa araarebema chĩde sid̶a edadua. (Bʌa maʌ̃ ovejara beaya Aaroʌ̃ra, idji warrarã sid̶a mʌ̃ sacerdoterãda b̶ʌcuai carea.) ");
INSERT INTO empNTpo_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Idjab̶a mʌ̃ quĩrãpita enena jamarad̶e b̶ʌ paʌ̃ ẽsãbari neẽ́ b̶eada ũbea edadua; ab̶a harina awa od̶ada, ab̶a nedraga bara od̶ada, idjab̶a nedragaba ʌ̃rʌ̃ pʌrʌd̶ada. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Maʌ̃ paʌ̃ra, dji oveja b̶ited̶abema edad̶ara, dji chĩde sid̶a b̶ʌdua Aaroʌ̃ jʌwad̶e, idji warrarã jʌwad̶e bid̶a. Jũma ãdji jʌwad̶e b̶ʌd̶ara ãdjirãba ʌ̃taa wad̶ida panʌa mʌ̃́a diad̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ʌ̃taa waped̶ad̶acarea wayacusa edaped̶a jũma babuedua dji animarã babue diabadad̶e oveja naãrã babued̶a ʌ̃rʌ̃. Maʌ̃ babue diabʌrʌra mʌ̃a bia unuya. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Maʌ̃be oveja jã nocoarebema djarada bʌ jʌwad̶e edaped̶a ʌ̃taa wadua mʌ̃́a diai carea. Ʌ̃taa waped̶a maʌ̃ djarara bʌre baya. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","28","Id̶iba ʌ̃taa bãrã israelerãba mʌ̃ ume necai b̶ai careabema oveja mʌ̃́a diad̶e zebʌdaza dji jã nocoarebema djarada, jʌwa araarebema chĩde sid̶a Aaroʌ̃ba idji warrarã bid̶a ʌ̃taa wad̶aped̶a ãdji itea edad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","30","Aaroʌ̃ jaid̶ad̶acarea idjid̶eba yõbʌdarãba idjia jʌ̃ b̶ad̶ara eropanania. Ãdjid̶ebemada ab̶a edad̶aped̶a maʌ̃ra domia ab̶a jʌ̃ b̶aida b̶ʌa sacerdote dji droma bai carea. Mãwãnacarea mʌ̃ wua ded̶e Aaroʌ̃ba ob̶abada quĩrãca o b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Aaroʌ̃ra mʌ̃ sacerdoteda b̶ʌbʌrʌd̶e oveja jã nocoarebema djarada edaped̶a mʌ̃ wua de aud̶u jũrã b̶ʌd̶e ed̶a djudua. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Djuped̶a Aaroʌ̃ba idji warrarã bid̶a maʌ̃ oveja djarara, paʌ̃ jamarad̶e b̶ed̶a sid̶a cod̶ida panʌa mʌ̃ wua ded̶e ed̶a wãbada caita. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Maʌ̃ djarad̶ebemada, paʌ̃nebema sid̶a mʌ̃́a babue diaya ãdjirãra mʌ̃ itea b̶ʌi carea idjab̶a ãdjirãba cadjirua oped̶ad̶ara mʌ̃a quĩrãdoamãrẽã. Maʌ̃ bẽrã ab̶abe ãdjiabʌrʌ maʌ̃ ad̶ubad̶ara cod̶ida panʌa. Maʌ̃ra mʌ̃́a diad̶a bẽrã dewara ẽberãba cocara b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Maʌ̃ oveja djara djud̶ara, paʌ̃ sid̶a jũma cod̶aẽ́bʌrʌ nurẽma diaped̶ed̶a dji ad̶ubad̶ara jũma babued̶ida panʌa. Dji ad̶ubad̶ara cocara panʌa maʌ̃ ovejara mʌ̃́a diaped̶ad̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Domia ab̶a mʌ̃a jarad̶a quĩrãca odua Aaroʌ̃ra idji warrarã sid̶a mʌ̃ sacerdoterãda b̶ʌi carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","37","Maʌ̃ne ewariza paca zaque dji umaquĩrãda ab̶a beaped̶a mʌ̃́a babue diadua Aaroʌ̃ba idji warrarã bid̶a cadjirua oped̶ad̶ara mʌ̃a quĩrãdoamãrẽã idjab̶a animarã babue diabadara mʌ̃ quĩrãpita bia b̶ʌmãrẽã. Ewariza animarã babue diabadara olivo draga quera bara b̶ʌba soadua mʌ̃ itea bia b̶ʌmãrẽã. Mãwã animarã babue diabadara mʌ̃ itea bio bia b̶eped̶a bariduaba waraibʌrʌ maʌ̃ sid̶a mʌ̃ itea b̶eya. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Ewariza sacerdoterãba animarã babue diabadad̶e oveja zaque poa ab̶a b̶eada umé babue diad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Diaped̶ed̶a ab̶a babue diad̶ida panʌa, dewarabemara queubʌrʌd̶e babue diad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","41","Diaped̶ed̶a oveja babue diabʌdad̶e dji biara b̶ʌ harinada eped̶eco jũgurua umé edad̶aped̶a olivo dragad̶aa boteya ab̶a bʌratʌd̶aped̶a maʌ̃ sid̶a mʌ̃́a babue diad̶ida panʌa. Maʌ̃ awara animarã babue diabada ʌ̃rʌ̃ uva b̶ada boteya ab̶a wead̶ida panʌa. Queubʌrʌd̶e oveja babue diabʌdad̶e ara maʌ̃ quĩrãca od̶ida panʌa. Maʌ̃ra mʌ̃a bia unuya. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","43","Aaroʌ̃ warrarãneba yõbʌdarã bid̶a ara maʌ̃ quĩrãca ovejara mʌ̃ quĩrãpita babue diad̶ida panʌa mʌ̃ wua ded̶e ed̶a wãbada quĩrãpe. Mama mʌ̃ra bãrã israelerãmaa zeped̶a bʌ ume bed̶ea b̶aya. Maʌ̃ne mʌ̃ quĩrãwãrẽã dorrodorroaba jũma mʌ̃ wua de aud̶u jũrã b̶ʌd̶e ed̶a b̶ʌra mʌ̃ itea erob̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Mãwã wua dera, animarã babue diabada sid̶a mʌ̃ itea bia b̶ʌya. Aaroʌ̃ra, idji warrarã sid̶a mʌ̃ itea bia b̶ʌya mʌ̃ sacerdoterãda b̶ead̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Mʌ̃ra bãrã israelerã tãẽna b̶aya idjab̶a bãrã Ãcõrẽ baya. ");
INSERT INTO empNTpo_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Maʌ̃ne bãrãba cawad̶ia mʌ̃ra bãrã Ãcõrẽda. Cawad̶ia mʌ̃abʌrʌ bãrãra Egiptod̶eba ẽdrʌ enesida bãrã tãẽna b̶ai carea. Mʌ̃ra bãrã Ãcõrẽa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Idjab̶a Ãcõrẽba jarasia: –Quera bá diabadada acacia bacurud̶eda od̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Dji drasoara, joub̶ʌa sid̶a bicaca ab̶a b̶aida b̶ʌa quĩrã quĩmãrẽena ab̶arica b̶amãrẽã. Dji ʌ̃tʌara bicaca umé b̶aida b̶ʌa. Iquid̶aza ab̶ari bacurud̶e cachu quĩrãca od̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Oro idji awa quiruba jũma bʌrad̶adua. Icawa pʌrrʌga oroba tuca b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Pĩrũ omoa b̶ea orod̶eda quĩmãrẽ od̶aped̶a orroza umé cara b̶ʌd̶adua dji tuca b̶ʌ edrecare. Maʌ̃ pĩrũne ed̶a bacuruda berajud̶adua jira eded̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Maʌ̃ra acacia bacurud̶eda baida b̶ʌa. Biya erad̶aped̶a oroba bʌrad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Quera bá diabadara mʌ̃ wua ded̶e ed̶a b̶ʌd̶adua dji ed̶aarebema wua eatʌ jira b̶ʌ quĩrãpe. Maʌ̃ wua jẽdaare mʌ̃ baurudeda dji ʌ̃rʌ̃ cob̶ʌi bara b̶aya. Mama mʌ̃ra bʌ ume bed̶ea b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Diaped̶aza Aaroʌ̃ba ĩbĩrã acʌd̶e zebʌrʌd̶e quera bá diabadad̶e querada bá diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Quewaraza bid̶a ĩbĩrã coad̶e zebʌrʌd̶e querada bá diaida b̶ʌa. Ara maʌ̃ quĩrãca ewariza bãrãba bãrã warrarãneba yõbʌdarã bid̶a querada mʌ̃ quĩrãpita bá dia pananida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Quera bá diabadad̶e baridua quera mʌ̃a jarad̶aẽ́ra bá diarãnadua. Idjab̶a animarãda, harina od̶a sid̶a maʌ̃ ʌ̃rʌ̃ mʌ̃́a babue diarãnadua. Uva b̶a sid̶a maʌ̃ ʌ̃rʌ̃ mʌ̃́a wea diarãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Quera bá diabadara mʌ̃ itea bio bia b̶aida b̶ʌa. Maʌ̃ bẽrã poaza b̶arima ab̶a Aaroʌ̃ba maʌ̃ quera bá diabada cachu quĩrãca b̶ead̶e oaba soaida b̶ʌa mʌ̃ itea bia b̶amãrẽã. Maʌ̃ oara idjia edaida b̶ʌa bãrã israelerãba cadjirua oped̶ad̶a carea animarã beabʌrʌd̶e. Idji warrarãneba yõbʌdarã bid̶a ara maʌ̃ quĩrãca poaza o pananida panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Idjab̶a Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","–Israeld̶ebema umaquĩrã juachabʌrʌd̶e beud̶a amaaba jũma ãdjirãba mʌ̃́a paratada diad̶ida panʌa. Mãwã ãdjirã juachabʌrʌd̶e quininaẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Juachabʌrʌd̶e ãdjirãza paratada sei gramo mʌ̃ ded̶e zabada quĩrãca mʌ̃́a diad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Jũma umaquĩrã veinte poad̶eba ʌ̃taa b̶ea juachabʌrʌd̶e maʌ̃ paratara mʌ̃́a diad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Dji parata bara b̶ʌba sei gramo aud̶u diaiẽ́ b̶ʌa idjab̶a dji parata neẽ́ quiruba sei gramo ed̶aara diaiẽ́ b̶ʌa. Ãdjirã juachabʌrʌd̶e beud̶a amaaba jũmarãba daucha diad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ãdjirãba diaped̶ad̶a paratara edaped̶a mʌ̃ wua ded̶ebema parataba od̶ida panʌra obidua. Maʌ̃ parataba mʌ̃́a quĩrãnebabi b̶aya bãrã israelerãba maʌ̃gʌra diasid̶ada beud̶a amaaba.– ");
INSERT INTO empNTpo_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Idjab̶a Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","–Ne sʌgʌbada eped̶eco waib̶ʌada dji acʌ b̶ʌd̶i bara bronced̶eda od̶adua. Maʌ̃ra animarã babue diabada jẽdaare mʌ̃ wua de caita b̶ʌd̶adua. Maʌ̃gʌd̶e baidoda jue ũmʌnadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","21","Aaroʌ̃ra idji warrarã sid̶a mʌ̃ wua ded̶e ed̶a wãni naẽna wa animarã mʌ̃́a babue diad̶i naẽna ãdji jʌwara jĩrũ sid̶a maʌ̃ baidoba sʌgʌd̶ida panʌa. Mãwã ãdjirãra beud̶aẽ́a. Maʌ̃ sʌgʌbi jarad̶ara Aaroʌ̃ba idji warrarãneba yõbʌdarã bid̶a ewariza ĩjã o pananida panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Idjab̶a Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","24","–Naʌ̃gʌ querada edad̶adua: mirra querada doce libra, canela querada sei libra, cálamo querada sei libra, casia querada doce libra. Maʌ̃ quera zʌgʌara mʌ̃ ded̶e zabada quĩrãca zadua. Maʌ̃ awara olivo dragada galoʌ̃ ab̶a edad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Jũma maʌ̃ querara olivo dragad̶aa puerad̶adua quera o cawa b̶ʌba obari quĩrãca. Maʌ̃ olivo draga quera bara b̶ʌba ne jũma mʌ̃ iteabemara soad̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","28","Maʌ̃gʌba mʌ̃ wua deda soadua: mʌ̃ baurudeda, paʌ̃ b̶ʌbada mesada, jũma maʌ̃ mesad̶e b̶eada, ĩbĩrã b̶ʌbadada, jũma maʌ̃ ĩbĩrãnebemada, quera bá diabadada, animarã babue diabadada, jũma maʌ̃ animarã babue diabadad̶ebemada, idjab̶a ne sʌgʌbada eped̶eco waib̶ʌada dji acʌ b̶ʌbada bara. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Jũma maʌ̃gʌra mʌ̃ itea bio bia b̶ʌi carea mãwã soad̶ida panʌa. Mãwãnacarea bariduaba waraibʌrʌ, maʌ̃ sid̶a mʌ̃ itea b̶eya. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Maʌ̃ olivo draga quera bara b̶ʌda Aaroʌ̃ boro ʌ̃rʌ̃, idji warrarã boro ʌ̃rʌ̃ bid̶a weadua mʌ̃ sacerdoterãda b̶ead̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Israelerãa nãwã jaradua: “Naʌ̃ ewarid̶eba ʌ̃taa naʌ̃ olivo draga quera bara b̶ʌba ab̶abe Ãcõrẽ iteabemadrʌ soad̶ida panʌa, idji itea od̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Baridua ẽberã ʌ̃rʌ̃ weacara panʌa. Idjab̶a ni ab̶aʌba naʌ̃ olivo draga quera bara b̶ʌ quĩrãca ara idji itea ocara b̶ʌa. Naʌ̃ olivo draga quera bara b̶ʌra ab̶abe mʌ̃ itea b̶ʌ bẽrã baridua quera quĩrãca erob̶ead̶iẽ́ panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Bariduaba naʌ̃ olivo draga quera bara b̶ʌ quĩrãca ara idji itea oibʌrʌ, idjira ãyã jʌretabued̶ida panʌa bãrã israelerã tãẽnabemada. Idjab̶a baridua ẽberã ʌ̃rʌ̃ naʌ̃ olivo draga quera bara b̶ʌda weaibʌrʌ, dji wead̶ara ãyã jʌretabued̶ida panʌa.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","35","Idjab̶a Ãcõrẽba Moisea jarasia: –Naʌ̃gʌ querada edad̶adua: estacte querada, ámbar querada, gálbano querada, idjab̶a incienso quera idji awa quiruda. Maʌ̃ quera b̶eara ab̶ari quĩrãca edad̶aped̶a ãbaa puerad̶adua bai careabema quera oi carea, quera o cawa b̶ʌba obari quĩrãca. Ãbaa puerabʌdad̶e tãda ed̶a b̶ʌd̶adua maʌ̃ querara mʌ̃ itea bio bia b̶emãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Maʌ̃be maãrĩ edad̶aped̶a nãũcha ʌrab̶ad̶adua. Maʌ̃ra bá nũmʌnida panʌa quera bá diabada ʌ̃rʌ̃ mʌ̃ baurude quĩrãpe. Mama mʌ̃ra bʌ ume bed̶ea b̶aya. Maʌ̃ bai careabema querara ab̶abe mʌ̃ itea b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ni ab̶aʌba maʌ̃ quera quĩrãca ara idji itea ocara b̶ʌa. Maʌ̃ra ab̶abe mʌ̃ itea b̶ʌ bẽrã, baridua bai careabema quera quĩrãca erob̶ead̶iẽ́ panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Bariduaba maʌ̃ quera quĩrãca ara idji itea oibʌrʌ, maʌ̃ ẽberãra bãrã israelerã tãẽnabemada ãyã jʌretabued̶ida panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Maʌ̃be Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","–Ũrĩdua. Mʌ̃a Uri warra Bezaleelda edasia mʌ̃ wua de od̶i ẽberãrã boroda b̶amãrẽã. Idjira Judad̶eba yõna Hur wiuzaquea. ");
INSERT INTO empNTpo_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Mʌ̃ Jaureda, necawaada, crĩcha cawaada, idjab̶a ne o cawa b̶ai crĩcha sid̶a mʌ̃a idjía diasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Mãwã idjira biya ne o cawa b̶ʌa orod̶ebemada, paratad̶ebemada, bronced̶ebema sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Mõgara biya qued̶ead̶ebemada o cawa b̶ʌa idjab̶a cara cawa b̶ʌa. Bacurud̶ebema sid̶a o cawa b̶ʌa. Ab̶ed̶a ne jũmada o cawa b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Maʌ̃ awara mʌ̃a Ahisamá warra Aholiáda edasia Bezaleel carebamãrẽã. Idjira Daʌ̃neba yõnaa. Jũma mʌ̃ wua de od̶i ẽberãrãa mʌ̃a necawaada diasia mʌ̃a obi jarad̶ara jũma od̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Ãdjirãba naʌ̃da od̶ida panʌa: mʌ̃ wua deda, mʌ̃ baurudeda, maʌ̃ baurude ʌ̃rʌ̃ cob̶eida, jũma mʌ̃ wua ded̶e b̶ead̶i sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","9","Mʌ̃ wua ded̶e b̶ead̶ira naʌ̃gʌa: paʌ̃ b̶ʌbada mesada, jũma maʌ̃ mesad̶e b̶aida, ĩbĩrã b̶ʌbada oro idji awa quiruda, jũma maʌ̃ ĩbĩrãnebemada, quera bá diabadada, animarã babue diabadada, jũma maʌ̃ animarã babue diabadad̶ebemada, ne sʌgʌbada eped̶eco waib̶ʌa sid̶a dji acʌ b̶ʌd̶i bara. ");
INSERT INTO empNTpo_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Idjab̶a Aaroʌ̃ba jʌ̃ida b̶ʌra, idji warrarãba jʌ̃nida panʌ sid̶a ãdjirãba od̶ia. Mãwã Aaroʌ̃ra idji warrarã sid̶a mʌ̃ sacerdoterãda b̶ead̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Maʌ̃ awara mʌ̃ wua de o panʌba olivo draga quera bara b̶ʌda od̶ia mʌ̃ iteabemada soad̶i carea. Idjab̶a mʌ̃ dejãne quera bad̶i careabemada od̶ia. Ãdjirãba jũma maʌ̃gʌra mʌ̃a jarad̶a quĩrãca daucha od̶ida panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Idjab̶a Ãcõrẽba Moisea nãwã jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","–Israelerãa nãwã jaradua: “Id̶iba ʌ̃taa ʌ̃nãũbada ewarida mʌ̃ itea waga pananida panʌa. Ʌ̃nãũbada ewari wagad̶ira sẽyã quĩrãca b̶aya bãrã israelerãba bãrã warrarãneba yõbʌdarã bid̶a cawad̶amãrẽã mʌ̃a bãrãra mʌ̃ itea b̶ʌsida. ");
INSERT INTO empNTpo_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Ʌ̃nãũbada ewarira waga pananida panʌa maʌ̃ ewarira mʌ̃ itea b̶ʌd̶a bẽrã. Bariduaba maʌ̃ ewarida mʌ̃ itea wagaẽ́bʌrʌ wa maʌ̃ ewarid̶e trajuda oibʌrʌ, maʌ̃ ẽberãra bãrã tãẽnabemada ãyã b̶ʌd̶aped̶a bead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Sei ewari bãrã trajura od̶ida panʌa, baribʌrʌ sietebema ewarid̶e ʌ̃nãũnida panʌa. Maʌ̃ ewarira mʌ̃ itea wagad̶ida panʌa. Bariduaba ʌ̃nãũbada ewarid̶e trajuda oibʌrʌ, idjira bead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Bãrã israelerãba, bãrã warrarãneba yõbʌdarã bid̶a ʌ̃nãũbada ewarira waga pananida panʌa. Maʌ̃ra mãwã b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ʌ̃nãũbada ewari wagad̶ira sẽyã quĩrãca b̶aya bãrã israelerãba cawad̶amãrẽã mʌ̃a bãrãra mʌ̃ itea b̶ʌsida. Mãwã b̶aya mʌ̃a sei ewarid̶e bajãda, naʌ̃ ẽjũã sid̶a jũma oped̶a sietebema ewarid̶e ʌ̃nãũna bẽrã.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ãcõrẽba Moisea Sinai eyad̶e maʌ̃ra jũma jaraped̶a mõgara pewed̶ea b̶ʌda umé diasia. Maʌ̃ mõgarad̶e idjia ĩjã obi b̶ʌ bed̶eada b̶ʌ́ diasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Moisera Sinai eyad̶eba ed̶aa zeẽ́ b̶ʌda dãrãbʌrʌ bẽrã israelerãra Aaroʌ̃maa wãnaped̶a nãwã jarasid̶aa: –Jãʌ̃ Moiseba dairãra Egiptod̶eba ẽdrʌ enesia, baribʌrʌ idji sãwãnada dairãba cawad̶aẽ́a. Maʌ̃ bẽrã dairã nocod̶aa edemãrẽã ãcõrẽda odua.– ");
INSERT INTO empNTpo_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaroʌ̃ba panusia: –Bia b̶ʌa. Bãrã wẽrãrãba, bãrã warrarãba, bãrã caurã bid̶a pĩrũ oro od̶ada mʌ̃́a jũma ẽrã diad̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ara maʌ̃da ãdjirãba pĩrũ oro od̶ara Aaroʌ̃a jũma ẽrã diacuasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Aaroʌ̃ba maʌ̃ pĩrũra edaped̶a tʌbʌd̶e dorrab̶aribisia. Maʌ̃ oro dorrab̶arid̶aba paca zaque quĩrãca osia. Maʌ̃ ununaped̶a israelerãba jarasid̶aa: –Naʌ̃drʌ dadjirã Egiptod̶eba ẽdrʌ enena ãcõrẽa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Maʌ̃ ũrĩped̶a Aaroʌ̃ba animarã babue diabadada osia paca zaque jʌwaba od̶a caita. Maʌ̃be israelerãa nãwã jarasia: –Nu ewari dromada Ãcõrẽ itea od̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Nurẽma diaped̶ed̶a israelerãra pirab̶arid̶aped̶a animarãda babue diacuasid̶aa idjab̶a Ãcõrẽ ume necai b̶ai careabema animarãda beacuasid̶aa. Maʌ̃be chũpanenaped̶a b̶ʌsrid̶a ne co duanasid̶aa idjab̶a itua do duanasid̶aa. Mãwãnacarea pirab̶arid̶aped̶a ãdji cacuaba o quĩrĩã b̶ʌda o duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Maʌ̃ne Ãcõrẽba Moisea jarasia: –Isabe ed̶aa wãdua bʌ ẽberãrã Egiptod̶eba enenaba cadjiruada o duanʌ bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ãdjirãba dãrãẽ́ne mʌ̃ leyra igarad̶aped̶a oroda dorrab̶aribid̶aped̶a paca zaque quĩrãca osid̶aa. Maʌ̃gʌ́a ãdjirãba bia bed̶ea panʌa idjab̶a animarãda babue diacuad̶aped̶a jara panʌa: “Naʌ̃drʌ dadjirã Egiptod̶eba ẽdrʌ enena Ãcõrẽa.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Idjab̶a Ãcõrẽba Moisea jarasia: –Mʌ̃a unu b̶ʌa naʌ̃ ẽberãrãra cʌwʌrʌ zarea b̶eada. ");
INSERT INTO empNTpo_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ãdjirã carea mʌ̃́a bed̶ea djuburiarãdua. Mʌ̃ quĩrũbid̶eba ãdjirãra jũma quinibiya. Baribʌrʌ bʌd̶eba mʌ̃a puru waib̶ʌada oya.– ");
INSERT INTO empNTpo_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mãwãmĩna Moiseba idji Ãcõrẽa bed̶ea djuburiasia. Nãwã jarasia: –Ay, Ãcõrẽ, bʌ quĩrũbid̶eba bʌ puru Egiptod̶eba enenara mãwã orãdua. ¿Bʌ ʌb̶ʌa waib̶ʌa b̶ʌd̶eba maʌ̃ purura Egiptod̶eba ẽdrʌ enesiẽ́ca? ");
INSERT INTO empNTpo_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ãdjirãda mãwã quinibibʌrʌ egiptorãba jarad̶ia bʌa israelerãra ẽdrʌ enesida biẽ́ oi carea. Jarad̶ia naʌ̃ eyad̶aa enesida quenai carea ni ab̶aʌ ãdjid̶ebemada naʌ̃ ẽjũãne b̶erãmãrẽã. ¿Bʌa quĩrĩã b̶ʌca egiptorãba mãwã jarad̶ida? Maʌ̃ bẽrã bʌ quĩrũbira tumadua. Bʌ puru quinibi crĩcha erob̶ʌra quĩrãdoadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Quĩrãnebadua bʌ nezocarã Abrahaʌ̃ ume, Isa ume, idjab̶a Jacobo ume bid̶a bed̶ea b̶ʌd̶ada. Bʌa ara bʌdji trʌ̃neba ãdjirãa wãrãneba nãwã jarasia: “Mʌ̃a bãrãneba ẽberãrã zocãrã yõbiya chĩdau zocãrã bajãne panʌ quĩrãca. Idjab̶a jũma mʌ̃a diai jarad̶a druara mʌ̃a bãrãneba yõbʌdarãa diaya ãdjirãne bamãrẽã.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Moiseba jara b̶ʌ carea Ãcõrẽba idji puru quinibi crĩcha erob̶ad̶ara idu b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Maʌ̃be Moisera Sinai eyad̶eba ed̶aa zesia. Idji jʌwad̶e mõgara pewed̶ea b̶ʌda umé enesia. Maʌ̃ mõgarad̶e Ãcõrẽba ĩjã obi b̶ʌ bed̶eada quĩrã umena b̶ʌ́ b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ãcõrẽbʌrʌ maʌ̃ umébema mõgara pewed̶ea b̶ʌda osia; idjiabʌrʌ maʌ̃ mõgarad̶e jaya b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Maʌ̃ zebʌdad̶e Josueba israelerãra b̶ʌga nũmʌda ũrĩsia. Maʌ̃ne idjia Moisea jarasia: –Mʌ̃a israelerã duanʌma djõ panʌ quĩrãca ũrĩ b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Moiseba panusia: –Mʌ̃a ũrĩ b̶ʌra dji quĩrũ poyabʌdad̶e b̶iabada quĩrãca b̶ʌẽ́a, ni dji quĩrũba poyabʌdad̶e b̶iabada quĩrãca b̶ʌẽ́a. Mʌ̃a ũrĩ b̶ʌ quĩrãca ãdjirãra b̶ʌsrid̶a trʌ̃ã duanʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Moise israelerã duanʌ caita jũẽsid̶e unusia ãdjirãra cari duanʌda idjab̶a paca zaque ãdji jʌwaba oped̶ad̶ada. Maʌ̃ carea bio quĩrũped̶a Ãcõrẽba diad̶a mõgara pewed̶eada Sinai eya carrad̶aa jĩãwẽsia. Maʌ̃ mõgarara jũma tod̶ozoasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ara maʌ̃da ãdji jʌwaba oped̶ad̶a paca zaquera edaped̶a tʌbʌd̶e dorrab̶ariped̶a ʌrab̶asia. Maʌ̃ porara doed̶a jĩãposia ãdjirãa dobi carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Maʌ̃be Moiseba Aaroʌ̃a jarasia: –¿Naʌ̃ ẽberãrãba bʌra sãwã osid̶a bʌa naʌ̃ cadjirua waib̶ʌada ãdjirãa obi carea?– ");
INSERT INTO empNTpo_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaroʌ̃ba idji djabaa nãwã panusia: –Ay, mʌ̃ boro, mʌ̃ ume quĩrũrãdua. Bʌa bio cawa b̶ʌa naʌ̃ ẽberãrãba cadjiruadrʌ o quĩrĩãbadada. ");
INSERT INTO empNTpo_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ãdjirãba mʌ̃́a jarasid̶aa: “Jãʌ̃ Moiseba dairãra Egiptod̶eba ẽdrʌ enesia, baribʌrʌ idji sãwãnada dairãba cawad̶aẽ́a. Maʌ̃ bẽrã dairã nocod̶aa edemãrẽã ãcõrẽda odua.” ");
INSERT INTO empNTpo_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Maʌ̃ carea mʌ̃a panusia: “Oro od̶a pĩrũ erob̶eaba mʌ̃́a ẽrã diad̶adua.” Ara maʌ̃da ãdjirãba ẽrã diacuasid̶aa. Maʌ̃da mʌ̃a tʌbʌd̶e b̶atabueped̶a cawaẽ́ne paca zaque quĩrãca b̶ʌda odjasia.– ");
INSERT INTO empNTpo_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moiseba unusia israelerãba baridua quĩrã perada o duanʌda Aaroʌ̃ba iduaribid̶a bẽrã. Idjia cawasia maʌ̃gʌ carea dji quĩrũba ãdjida ipid̶a jara duananida. ");
INSERT INTO empNTpo_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Maʌ̃ carea Moisera ãdji duanʌma ed̶a wãbada od̶e ʌ̃ta nũmeped̶a jarasia: –Ãcõrẽare panʌra mʌ̃maa zed̶adua.– Ara maʌ̃da jũma Levid̶eba yõped̶ad̶adrʌ idjimaa wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Maʌ̃ne Moiseba ãdjirãa jarasia: –Dadji israelerã Ãcõrẽba nãwã jara b̶ʌa: “Bãdjiza bãrã djõbada necora edad̶aped̶a jẽda wãnadua israelerã duanʌmaa. Deza mʌ̃ igara panʌra bead̶e wãnadua. Bãrã djabarã sid̶a, bãrã ume dji biarã sid̶a, bãrã de caitabemarã sid̶a bead̶adua.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Ara maʌ̃da Levid̶eba yõped̶ad̶arãba Moiseba jarad̶a quĩrãca osid̶aa. Maʌ̃ ewarid̶e ãdjirãba israelerãda mil ũbea beasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Maʌ̃be Moiseba jarasia: –Bãrã warrarãra, bãrã djabarã sid̶a beasid̶a bẽrã id̶ira Ãcõrẽ itea panesid̶aa. Ãcõrẽba obid̶ara ĩjãsid̶a bẽrã id̶ira idjia bãrãra bia carebaya.– ");
INSERT INTO empNTpo_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Nurẽma Moiseba israelerãa jarasia: –Bãrãba cadjirua waib̶ʌada osid̶aa. Maʌ̃ bẽrã mʌ̃ra Sinai eyad̶e ʌ̃taa Ãcõrẽmaa wãya. Ãĩbẽrã mʌ̃a Ãcõrẽa bãrãba cadjirua oped̶ad̶ara quĩrãdoabisicada.– ");
INSERT INTO empNTpo_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ara maʌ̃da Moisera wayacusa Sinai eyad̶e ʌ̃taa wãped̶a Ãcõrẽa nãwã bed̶ea djuburiasia: –Wãrãda jãʌ̃ ẽberãrãba cadjirua waib̶ʌada osid̶aa. Paca zaque orod̶eda osid̶aa ãdji ãcõrẽ bamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Mãwãmĩna mʌ̃ quĩrã djuburia ãdjirãba cadjirua oped̶ad̶ara quĩrãdoadua. Baribʌrʌ poya quĩrãdoaẽ́bʌrʌ, mʌ̃ trʌ̃ sid̶a ãyã b̶ʌdua bʌ ẽberãrã trʌ̃ b̶ʌ́ erob̶ʌd̶ebemada.– ");
INSERT INTO empNTpo_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ãcõrẽba Moisea panusia: –Mʌ̃a ab̶abe cadjirua od̶a ẽberã trʌ̃da ãyã b̶ʌya. ");
INSERT INTO empNTpo_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Jãʌ̃be wãdua. Jãʌ̃ ẽberãrãra ededua mʌ̃a bʌ́a jarad̶a druad̶aa. Mʌ̃ nezoca bajãnebemara bãrã na wãya. Baribʌrʌ mʌ̃a cawa oi ewarid̶e ãdjirãra cawa oya cadjirua oped̶ad̶a carea.– ");
INSERT INTO empNTpo_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Maʌ̃be Ãcõrẽba israelerãra zocãrã quinibisia Aaroʌ̃ba jʌwaba od̶a paca zaquea bia bed̶ea duanana carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Maʌ̃be Ãcõrẽba Moisea jarasia: –Namaʌba bʌra, ẽberãrã bʌa Egiptod̶eba ẽdrʌ enena ume wãnadua mʌ̃a diai jarad̶a druad̶aa. Maʌ̃ druara mʌ̃a Abrahaʌ̃a, Isaa, Jacoboa bid̶a wãrãneba jarasia ãdjid̶eba yõbʌdarãa diaida. ");
INSERT INTO empNTpo_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Mʌ̃ nezoca bajãnebemada bãrã na wãbiya cananeorãda, amorreorãda, hititarãda, perezeorãda, heveorãda, jebuseorã sid̶a jũma ãyã jʌrecuai carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Maʌ̃ druad̶e baridua ne uped̶ad̶ara bia zaubaria. Baribʌrʌ mʌ̃ra bãrã ume wãẽ́a cʌwʌrʌ zarea b̶ea carea quinibi amaaba.– ");
INSERT INTO empNTpo_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Maʌ̃ bed̶ea ũrĩsid̶ad̶e israelerãra sopua duanesid̶aa. Maʌ̃ bẽrã ni ab̶aʌba djiora jʌ̃naẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Mãwã osid̶aa Ãcõrẽba Moisea nãwã jarad̶a bẽrã: –Israelerãa nãwã jaradua: “Bãrãra cʌwʌrʌ zarea b̶eaa. Mʌ̃da bãrã ume maãrĩ bid̶a wãibʌrʌ, ab̶ed̶a jũma quinibiya. Jãʌ̃be bãrã djiora jũma ẽrãcuad̶aped̶a mʌ̃a bãrãra sãwã oida cawa jaraya.”– ");
INSERT INTO empNTpo_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Maʌ̃ carea israelerãba ãdji djiora jũma ẽrãcuad̶aped̶a idu b̶ʌsid̶aa Horeb eya jewed̶ad̶e duanasid̶ad̶e. ");
INSERT INTO empNTpo_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Maʌ̃ ewarid̶e Moiseba wua deda israelerã panʌmaʌba jĩgabe obadjia. Maʌ̃ wua dera idjia trʌ̃ b̶ʌsia “Ãcõrẽ ume bed̶eabari de.” Bariduaba Ãcõrẽa iwid̶i quĩrĩã b̶ʌd̶e israelerã panʌmaʌba maʌ̃ ded̶aa wãbadjia. ");
INSERT INTO empNTpo_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Moise maʌ̃ ded̶aa wãbʌrʌza israelerã jũmarãda ãdji wua ded̶e ed̶a wãbadad̶e ʌ̃ta piradrʌd̶aped̶a idjira ed̶a wãbʌrʌda acʌ duanabadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Moise ed̶a wãnacarea israelerã na wãbari jʌ̃rãrã ʌ̃tʌba ed̶aa drasoa jira b̶ʌda maʌ̃ wua ded̶aa zeped̶a dji ed̶a wãbada caita b̶ebadjia. Maʌ̃ne Ãcõrẽra Moise ume bed̶eabadjia. ");
INSERT INTO empNTpo_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Israelerãba jʌ̃rãrã wua ded̶e ed̶a wãbada caita b̶ebʌrʌda unusid̶ad̶e jũmarãda chĩrãborod̶e copanenaped̶a ãdji wua ded̶e ed̶a wãbadamaʌba Ãcõrẽa bia bed̶eabadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Maʌ̃ne Ãcõrẽra Moise ume jĩgua bed̶eabadjia ẽberã umé nẽbʌrʌ panʌ quĩrãca. Nẽbʌrʌped̶ad̶acarea Moisera jẽda zebadjia israelerã duanʌmaa. Baribʌrʌ idji carebabari Josueda maʌ̃ wua ded̶e b̶ebadjia. Maʌ̃ cũdrara Nuʌ̃ warra basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moiseba Ãcõrẽa jarasia: –Bʌa mʌ̃́a jara b̶ʌa naʌ̃ ẽberãrãra nocod̶aa edemãrẽã. Baribʌrʌ bʌa jaraẽ́ b̶ʌa caida diabueida mʌ̃ carebamãrẽã. Idjab̶a bʌa jara b̶ʌa mʌ̃ra bio cawa b̶ʌda idjab̶a bio bia unu b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Wãrãda mãwã baibʌrʌ, bʌa oi crĩcha b̶ʌda mʌ̃́a cawabidua. Mãwã mʌ̃a bʌra biara cawaya idjab̶a bʌa mʌ̃ra bia unu b̶eya. Quĩrãnebadua naʌ̃ ẽberãrãra bʌreda.– ");
INSERT INTO empNTpo_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ãcõrẽba panusia: –Mʌ̃ra bʌ ume wãya necai b̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moiseba jarasia: –Bʌda jũmarã ume wãẽ́bʌrʌ, namaʌba ãyã wãbirãdua. ");
INSERT INTO empNTpo_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Bʌda dairã ume wãẽ́bʌrʌ, ¿dewararãba sãwã cawad̶i mʌ̃da, bʌ puru sid̶a bʌa bia unu b̶ʌda? ¿Sãwã cawad̶i dairãra jũma naʌ̃ ẽjũãne b̶ea puru cãyãbara awara panʌda?– ");
INSERT INTO empNTpo_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ãcõrẽba panusia: –Bʌa jara b̶ʌ quĩrãca mʌ̃a oya, bʌra bia unu b̶ʌ bẽrã idjab̶a mʌ̃a bʌra bio cawa b̶ʌ bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Moiseba Ãcõrẽa jarasia: –Mʌ̃ quĩrã djuburia bʌ quĩrãwãrẽã dorrodorroada mʌ̃́a ebud̶a unubidua.– ");
INSERT INTO empNTpo_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ãcõrẽba panusia: –Mʌ̃ biada bʌ́a jũma unubiya. Mʌ̃ trʌ̃ sid̶a bʌ́a jaraya. Mãwã bʌa cawaya mʌ̃a quĩrã djuburia quĩrĩã b̶ʌ ẽberãda quĩrã djuburiaida, idjab̶a mʌ̃a quĩrĩãneba careba quĩrĩã b̶ʌ ẽberãda quĩrĩãneba carebaida. ");
INSERT INTO empNTpo_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Baribʌrʌ mʌ̃ quĩrãdarrada bʌa poya unuẽ́a. Bariduaba mʌ̃da unusira beuya.– ");
INSERT INTO empNTpo_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Maʌ̃ne Ãcõrẽba jarasia: –Mʌ̃ caita mõgarada b̶ʌa. Maʌ̃ ʌ̃rʌ̃ nũmedua. ");
INSERT INTO empNTpo_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Mʌ̃ quĩrãwãrẽã dorrodorroada bʌ caita wãyã wãbʌrʌd̶e mʌ̃a bʌda mõgara uriad̶e b̶ʌped̶a mʌ̃ jʌwaba jũãtrʌya. ");
INSERT INTO empNTpo_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Wãyã wãnacarea mʌ̃ jʌwa ãyã edabʌrʌd̶e bʌa mʌ̃ ẽcarradrʌ unuya baribʌrʌ mʌ̃ quĩrãdarrara unuẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Idjab̶a Ãcõrẽba Moisea jarasia: –Mõgarada umé pewed̶ea odua mʌ̃a naãrã o diad̶a quĩrãca. Maʌ̃ mõgarad̶e mʌ̃a mõgara naãrã o diad̶ad̶e jaya b̶ʌd̶ara wayacusa jaya b̶ʌya, dji naãrãbemara bʌa jũma tod̶ozoabid̶a bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Jũma oped̶a nu diaped̶ed̶a Sinai eya borod̶aa zedua mʌ̃ quĩrãpita b̶ai carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ni ab̶aʌda bʌ ume zecara b̶ʌa idjab̶a ni ab̶aʌda eyad̶e b̶acara b̶ʌa. Ovejara paca sid̶a eya carrad̶e ne cod̶acara panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ara maʌ̃da Moiseba mõgarada umé pewed̶ea osia Ãcõrẽba naãrã o diad̶a quĩrãca. Nurẽma diaped̶ed̶a Sinai eyad̶e ʌ̃taa wãsia Ãcõrẽba idjía jarad̶a quĩrãca. Mõgara umé pewed̶ea od̶ada idji jʌwad̶e edesia. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Maʌ̃ne Ãcõrẽra jʌ̃rãrãne ed̶aa zeped̶a Moise caita nũmesia. Mama idji trʌ̃ Jehováda Moisea jarasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Idji wãyã wãbʌrʌd̶e Moisea nãwã jarasia: –Mʌ̃ra Ãcõrẽa. Mʌ̃ra Ãcõrẽa. Mʌ̃ra quĩrã djuburiaid̶a b̶ʌa idjab̶a quĩrĩãneba carebabaria. Mʌ̃ra baridua quĩrũcaa. Mʌ̃a ẽberãrãra bio quĩrĩã b̶ʌa idjab̶a bed̶ea ab̶a b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Mʌ̃ quĩrĩã jõcada zocãrã ẽberãrãa unubibaria. Ãdjia cadjirua obadara, mʌ̃ bed̶ea igarabadara idjab̶a ãĩ obada sid̶a mʌ̃a quĩrãdoabaria. Baribʌrʌ dji bed̶ead̶e b̶ʌra mʌ̃a cawa obaria. Dji zezaba cadjirua od̶a carea idjida, idji warrarãda, idji wiuzaquerãda, ãdjirã warrarã sid̶a cawa o b̶abaria.– ");
INSERT INTO empNTpo_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ara maʌ̃da Moisera chĩrãborod̶e idji dratura egorod̶e tẽũ cob̶eped̶a Ãcõrẽa bia bed̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Nãwã jarasia: –Mʌ̃ Boro, bʌa mʌ̃da bia unu b̶ʌbʌrʌ, dairã ume wãdua. Naʌ̃ ẽberãrãra cʌwʌrʌ zarea panʌmĩna dairãba cadjirua oped̶ad̶ara quĩrãdoadua idjab̶a dairãra edadua bʌ puru bamãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ãcõrẽba panusia: –Ũrĩdua. Mʌ̃ra bãrã puru ume bed̶ea b̶ʌya. Bãrã quĩrãpita mʌ̃a ne ununacara o b̶aya. Maʌ̃ ne ununacara mʌ̃a wad̶ibid̶a ni ab̶aʌ puru naʌ̃ ẽjũã b̶ead̶e ocaa. Mãwã obʌrʌd̶e ẽberãrã bʌ ume panʌba bãrã israelerã carea o b̶ʌda ununaped̶a mʌ̃ ʌb̶ʌara waya panania. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Jũma mʌ̃a id̶i jara b̶ʌra ĩjã od̶adua. Maʌ̃ne bãrã quĩrãpita mʌ̃a amorreorãda, cananeorãda, hititarãda, perezeorãda, heveorãda, jebuseorã sid̶a jũma ãyã jʌrecuaya. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Quĩrãcuitad̶adua. Bãrã wãbʌda druad̶ebemarã ume bed̶ea b̶ʌrãnadua. Mãwã od̶ibʌrʌ cawaẽ́ne bãrã bid̶a ãdji jʌwaba od̶a ãcõrẽa bia bed̶ead̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Maʌ̃ bẽrã ãdji animarã babue diabadara jũma ãrĩnadua. Idjab̶a ãdji ãcõrẽ mõgara od̶ada, ãdji ãcõrẽwẽrã Aserá bacuru od̶a sid̶a jũma toapetacuad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Dewara ãcõrẽa bia bed̶earãnadua. Mʌ̃a quĩrĩã b̶ʌa bãrãba ab̶abe mʌ̃́a bia bed̶ead̶ida. Maʌ̃ carea mʌ̃ trʌ̃ra “Ãcõrẽ jiwaid̶a b̶ʌ” abadaa. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Quĩrãcuitad̶adua. Bãrã wãbʌda druad̶ebemarã ume bed̶ea b̶ʌrãnadua. Mãwã od̶ibʌrʌ ãdjirãba ãdji jʌwaba od̶a ãcõrẽa bia bed̶ead̶e wãbʌdad̶e idjab̶a animarã bea diad̶e wãbʌdad̶e bãrãa jarad̶ia ab̶arica od̶amãrẽã. Maʌ̃ne bãrã bid̶a ãdji ãcõrẽa animarã bea diaped̶ad̶a djarada cod̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Idjab̶a bãrã warrarãa maʌ̃ druad̶ebema wẽrãrãda idu edabid̶ibʌrʌ, maʌ̃ wẽrãrãba ãdji jʌwaba od̶a ãcõrẽa bia bed̶eabʌdad̶e bãrã warrarã bid̶a maʌ̃ jʌwaba od̶a ãcõrẽa bia bed̶ead̶ia daunema panʌ quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Jʌwaba obada ãcõrẽra orãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Paʌ̃ ẽsãbari neẽ́ cobada ewarida od̶adua. Bãrãba siete ewari paʌ̃ ẽsãbari neẽ́ b̶ʌda cod̶ida panʌa mʌ̃a jarad̶a quĩrãca. Maʌ̃ra od̶adua mʌ̃a jara b̶ʌd̶a ewari Abib jed̶ecod̶e, bãrãra maʌ̃ jed̶ecod̶e Egiptod̶eba ẽdrʌped̶ad̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Jũma bãrã umaquĩrã warra dji nabemarã, bãrã animarã dji umaquĩrã naãrã toped̶ad̶a sid̶a mʌ̃rea. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Bãrã burro warra dji nabema umaquĩrã tobʌrʌda mʌ̃remĩna bãrãba maʌ̃ animarãda poya edad̶ida panʌa. Edad̶i carea ovejada wa chiwatuda maʌ̃ burro cacuabari mʌ̃́a babue diad̶ida panʌa. Baribʌrʌ maʌ̃ burroda eda quĩrĩãnaẽ́bʌrʌ, otapuya bead̶ida panʌa. Idjab̶a bãrã umaquĩrã warra dji nabema tobʌdara mʌ̃re bẽrã idji cacuabari ovejada wa chiwatuda mʌ̃́a babue diad̶ida panʌa maʌ̃ warrara zocai b̶emãrẽã. Maʌ̃ ewarid̶e mʌ̃́a ne diai carea neẽ́ b̶ʌra mʌ̃ quĩrãpita zecara b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Sei ewari bãrã trajura od̶ida panʌa, baribʌrʌ sietebema ewarid̶e ʌ̃nãũnida panʌa. Bãrã ẽjũã obʌdad̶e, ewabʌdad̶e bid̶a sietebema ewarid̶e ʌ̃nãũnida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Bãrã néud̶ebema naãrã ewaped̶ad̶a carea b̶ʌsrid̶a ewarida od̶ida panʌa trigo naãrã ewabʌdad̶e. Idjab̶a bãrã néu jũma ewaped̶ad̶a carea b̶ʌsrid̶a ewarida od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Mʌ̃ra Ãcõrẽa, bãrã israelerã Boroa. Poaza b̶arima ũbea umaquĩrãrãra mʌ̃ quĩrãpita jũma zed̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Bãrã quĩrãpita mʌ̃a Canaaʌ̃ druad̶ebemarãra jũma ãyã jʌrecuaya idjab̶a bãrãa druara waib̶ʌa diaya. Maʌ̃ bẽrã poaza b̶arima ũbea bãrã mʌ̃ quĩrãpita wãbʌdad̶e ni ab̶aʌba bãrã ẽjũãra jãrĩne zed̶aẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Animarã mʌ̃́a babue diabʌdad̶e dji oada paʌ̃ ẽsãbari bara b̶ʌ ume babue diarãnadua. Bãrã Egiptod̶eba ẽdrʌped̶ad̶a quĩrãnebad̶i carea ne cobadara obʌdad̶e oveja mʌ̃́a bea diaped̶ad̶a djarara ni maãrĩ bid̶a wagad̶iẽ́ panʌa nurẽma carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Bãrã néu naãrã ewabʌdad̶ebemada dji biara b̶ʌdrʌ mʌ̃ ded̶aa diad̶e zed̶adua. Chiwatu zaquera dji papa jub̶ad̶e djurãnadua.– ");
INSERT INTO empNTpo_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Maʌ̃be Ãcõrẽba Moisea jarasia: –Mʌ̃a jarad̶ara jũma b̶ʌdua, maʌ̃neba mʌ̃ra bʌ ume idjab̶a israelerã ume bed̶ea b̶ʌbʌrʌ bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Maʌ̃ne Moisera Ãcõrẽ ume Sinai eyad̶e b̶asia cuarenta ewari ãsa diamasi bid̶a. Idjira ne coẽ́ b̶asia idjab̶a baido sid̶a doẽ́ b̶asia. Mõgara umé pewed̶ea od̶ad̶e Ãcõrẽba ĩjã obi b̶ʌ bed̶ea die diad̶ara jũma jaya b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Maʌ̃be Moisera Sinai eyad̶eba ed̶aa zesia. Ãcõrẽ ley mõgara umé pewed̶ead̶e jaya b̶ʌ́ b̶ʌda idji jʌwad̶e enesia. Ãcõrẽ ume bed̶ea b̶ad̶a bẽrã idji quĩrãdarrara dorrodorroa b̶asia baribʌrʌ maʌ̃nebemada adua b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Moise quĩrãdarra dorrodorroa b̶ʌda Aaroʌ̃ba israelerã bid̶a unusid̶ad̶e idji caita wãnida wayasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Baribʌrʌ Moiseba ãdjirãra trʌ̃cuasia. Ara maʌ̃da Aaroʌ̃ra israelerã bororã sid̶a wãnaped̶a Moisera ãdjirã ume bed̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Mãwãnacarea jũma israelerã sid̶a idjimaa wãsid̶aa. Maʌ̃be Ãcõrẽba Sinai eyad̶e jarad̶ara Moiseba ãdjirãa jũma jarasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ãdjirãa jarad̶acarea Moiseba idji quĩrãdarrara quẽbʌ daucha wuaba bʌrasia idji quĩrãdarra dorrodorroa b̶ʌda unurãnamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Baribʌrʌ Ãcõrẽ ume bed̶eabari ded̶aa wãbʌrʌza Ãcõrẽ ume bed̶ea b̶ʌd̶e Moiseba maʌ̃ wuara ẽrãbadjia. Mamaʌba ẽdrʌd̶acarea idjia israelerãa Ãcõrẽba obi jarad̶ada jarabadjia. ");
INSERT INTO empNTpo_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Maʌ̃ne israelerãba unubadjid̶aa Moise quĩrãdarrara dorrodorroa nũmʌda. Jũma jarad̶acarea Moiseba idji quĩrãdarrara wayacusa quẽbʌ daucha wuaba bʌrasia. Mãwã bʌrá b̶esia ab̶a wayacusa Ãcõrẽ ume bed̶ead̶e wãbʌrʌd̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Maʌ̃be Moiseba israelerãra jũma trʌ̃ped̶a nãwã jarasia: –Naʌ̃da Ãcõrẽba bãrãa obi b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Sei ewari bãrã trajura od̶ida panʌa, baribʌrʌ sietebema ewarid̶e bãrãra ʌ̃nãũnida panʌa. Maʌ̃ ewarira Ãcõrẽ itea wagad̶ida panʌa. Bariduaba ʌ̃nãũbada ewarid̶e trajuda oibʌrʌ, idjira bead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ʌ̃nãũbada ewarid̶e bãrã diguid̶a tʌbʌ sid̶a coad̶acara panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moiseba jũma israelerãa jarasia: –Naʌ̃ sid̶a Ãcõrẽba obi b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Bãrãba erob̶ead̶ebemada Ãcõrẽa diad̶adua. Sod̶eba ne dia quĩrĩã b̶eaba Ãcõrẽa naʌ̃gʌda diad̶ida panʌa: oroda, paratada, bronceda, ");
INSERT INTO empNTpo_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","oveja cara nayãna pãwãrã od̶ada, pursupursua od̶ada, purea od̶a sid̶a. Idjab̶a diad̶ida panʌa wua dji biara b̶ʌ lino od̶ada, wua chiwatu cara od̶ada, ");
INSERT INTO empNTpo_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","oveja e purea od̶ada, animarã e biada, acacia bacuruda, ");
INSERT INTO empNTpo_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","olivo draga ĩbĩrã coad̶i careabemada, querada olivo dragad̶aa puerad̶i carea. Maʌ̃ quera olivo dragad̶aa puerad̶ara od̶ia ne jũma Ãcõrẽ iteabemada soad̶i carea. Idjab̶a quera bad̶i careabemada, ");
INSERT INTO empNTpo_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ónice mõgarada, dewara mõgara bia qued̶ea sid̶a diad̶ida panʌa sacerdoteba jãare jʌ̃ida b̶ʌd̶e, “Ãcõrẽba quĩrĩã b̶ʌ cawabibarid̶e” bid̶a cajud̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Ne o cawa b̶earãra jũma zed̶aped̶a ne jũma Ãcõrẽba obi b̶ʌda od̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Ãcõrẽ wua ded̶ebema od̶ida panʌra naʌ̃gʌa: de ãnẽb̶ari cob̶ʌd̶i wuada, maʌ̃ ʌ̃rʌ̃ ãnẽb̶ari cob̶ʌd̶i sid̶a, wua jũẽbarida, bacuru ʌrrad̶ada, bacuru erad̶ada orroza berajud̶i carea, bacuru tẽnada, edrebema parata od̶a uria b̶ea sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Naʌ̃ sid̶a od̶ida panʌa: Ãcõrẽ baurudeda dji jira eded̶i bacuru bara, maʌ̃ baurude ʌ̃rʌ̃ cob̶eida, baurude nocoare eatʌ jira b̶ai wuada, ");
INSERT INTO empNTpo_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Ãcõrẽ quĩrãpita paʌ̃ b̶ʌbada mesada dji jira eded̶i bacuru bara, jũma maʌ̃ mesad̶e b̶aida, paʌ̃ Ãcõrẽ quĩrãpita b̶ʌi careabemada, ");
INSERT INTO empNTpo_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ĩbĩrã b̶ʌbadada, ĩbĩrãda, jũma maʌ̃ ĩbĩrãnebemada, olivo dragada ĩbĩrã coad̶i carea, ");
INSERT INTO empNTpo_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","quera bá diabadada dji ãyã jira eded̶i bacuru bara, quera bad̶i careabemada, olivo draga quera bara b̶ʌda jũma Ãcõrẽ iteabema soad̶i carea, Ãcõrẽ wua ded̶e ed̶a wãbada eatʌ jũãtrʌ b̶ai wuara, ");
INSERT INTO empNTpo_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","animarã babue diabadada dji jʌrrʌjʌrrʌa bronce od̶a bara idjab̶a dji jira eded̶i bacuru bara, jũma maʌ̃ animarã babue diabadad̶ebemada, bronce od̶a ne sʌgʌbadada dji acʌ b̶ʌd̶i bara, ");
INSERT INTO empNTpo_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Ãcõrẽ wua de aud̶u jũrã b̶ʌ eatʌ jira b̶ai wuada, maʌ̃ aud̶u jũrã b̶ai bacuru tẽnada, bronce od̶a uria b̶eada bacuru berajud̶i carea, dji aud̶u jũrã b̶ʌd̶e ed̶a wãbada eatʌ jũãtrʌ b̶ai wuada, ");
INSERT INTO empNTpo_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","jʌ̃carada, dji egorod̶e cachid̶i careabemada Ãcõrẽ wua de, dji aud̶u jũrã b̶ai sid̶a erreb̶ari jʌ̃ni carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Idjab̶a Aaroʌ̃ba cacuad̶e jʌ̃ida b̶ʌda, idji warrarãba cacuad̶e jʌ̃nida panʌ sid̶a od̶ida panʌa ãdjirãra sacerdoterãda b̶ead̶amãrẽã. Maʌ̃ra ãdjia jʌ̃nida panʌa Ãcõrẽ wua ded̶e ne obʌdad̶e.– ");
INSERT INTO empNTpo_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Moiseba mãwã jarad̶acarea jũma israelerãra idji ume pananada wãbʌrʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Maʌ̃be ãdji sod̶eba wãrãda dia quĩrĩã panʌba Ãcõrẽ itea ne enesid̶aa idji wua de, maʌ̃ ded̶e ed̶a b̶ead̶i sid̶a od̶i carea. Idjab̶a enesid̶aa Aaroʌ̃ba cacuad̶e jʌ̃ida b̶ʌ, idji warrarãba cacuad̶e jʌ̃nida panʌ sid̶a od̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Umaquĩrãrãba, wẽrãrã bid̶a ara ãdji sod̶eba dia quĩrĩã panʌ quĩrãca quĩrãtanoa djio oro od̶ada Ãcõrẽa diad̶e zesid̶aa: carenada, chid̶ichid̶ida, jʌwa jĩwĩnĩne jʌ̃badada, dewara djio sid̶a. Jũmarãba oro od̶ara Ãcõrẽa diasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Maʌ̃ awara dji erob̶eaba oveja cara nayãna pãwãrã od̶ada, pursupursua od̶ada, purea od̶a sid̶a diad̶e zesid̶aa. Idjab̶a wua dji biara b̶ʌ lino od̶ada, wua chiwatu cara od̶ada, oveja e purea od̶ada, dewara animarã e bia sid̶a diad̶e zesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Maʌ̃ awara dji erob̶eaba paratada, bronce sid̶a Ãcõrẽa diad̶e zesid̶aa. Acacia bacuru erob̶eaba Ãcõrẽ wua de od̶i carea diad̶e zesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Jũma wẽrãrã ne ca cawa b̶eaba oveja cara pãwãrã od̶ada, pursupursua od̶ada, purea od̶a sid̶a nayãnaped̶a diad̶e zesid̶aa. Dji biara b̶ʌ lino wua sid̶a cad̶aped̶a diad̶e zesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Jũma wẽrãrã ne ca cawa b̶eaba sod̶eba careba quĩrĩã panʌneba chiwatu cara nayãnaped̶a wuada osid̶aa Ãcõrẽa diad̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Maʌ̃ awara israelerã bororãba ónice mõgarada, dewara mõgara biya qued̶ea sid̶a diad̶e zesid̶aa sacerdoteba jãare jʌ̃ida b̶ʌd̶e, “Ãcõrẽba quĩrĩã b̶ʌ cawabibarid̶e” bid̶a cajud̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Idjab̶a olivo dragada ĩbĩrã coad̶i carea diad̶e zesid̶aa. Quera sid̶a diad̶e zesid̶aa olivo dragad̶aa puerad̶aped̶a ne jũma Ãcõrẽ iteabemada soad̶i carea. Quera bad̶i careabema sid̶a diad̶e zesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Mãwã jũma Israeld̶ebema umaquĩrãrãba wẽrãrã bid̶a ara ãdji sod̶eba dia quĩrĩã panʌ quĩrãca Ãcõrẽa diasid̶aa idji wua de, jũma maʌ̃ wua ded̶ebema sid̶a od̶i carea Ãcõrẽba Moised̶eba jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Maʌ̃be Moiseba israelerãa jarasia: –Ũrĩnadua. Ãcõrẽba Uri warra Bezaleelda edasia idji wua de od̶i ẽberãrã boro bamãrẽã. Idjira Judad̶eba yõna Hur wiuzaquea. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Ãcõrẽba idji Jaureda, necawaada, crĩcha cawaada, idjab̶a ne o cawa b̶ai sid̶a Bezaleelea diasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Mãwã orod̶ebemada, paratad̶ebemada, bronced̶ebema sid̶a biya o cawa b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Mõgara biya qued̶ead̶ebemada o cawa b̶ʌa idjab̶a cara cawa b̶ʌa. Bacurud̶ebema sid̶a o cawa b̶ʌa. Ab̶ed̶a ne jũmada o cawa b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Maʌ̃ awara Ãcõrẽba necawaara diasia jaradia b̶amãrẽã. Daʌ̃neba yõna Ahisamá warra Aholiáa bid̶a necawaara diasia jaradia b̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Maʌ̃ umébemarãa Ãcõrẽba ne o cawa b̶ai crĩchada diasia. Mãwã ãdjirãba dji biara b̶ʌ lino wuad̶e oveja cara nayãna pãwãrã od̶ada, pursupursua od̶ada, purea od̶a sid̶a ed̶a ca cawa panʌa. Ab̶ed̶a ne jũmada biya o cawa panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Maʌ̃ bẽrã Bezaleelba, Aholiába, idjab̶a jũma ne o cawa b̶ea bid̶a Ãcõrẽ wua deda, maʌ̃ wua ded̶ebema sid̶a od̶ida panʌa. Ãcõrẽba jũma ãdjirãa crĩcha cawaada, ne o cawa b̶ai crĩcha sid̶a diasia idjia obi jarad̶ara biya od̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Maʌ̃be Moiseba Bezaleelda, Aholiáda, jũma ne o cawa b̶ea sid̶a trʌ̃sia Ãcõrẽ wua dera od̶amãrẽã. Ãdjirãba Ãcõrẽ wua dera careba o quĩrĩãsid̶aa. Maʌ̃ne Ãcõrẽba ãdjirãa ne o cawa b̶ai crĩchada diasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Israelerãba Ãcõrẽ wua de od̶amãrẽã eneped̶ad̶ara Moiseba ãdjirãa jũma diasia. Baribʌrʌ israelerãba wad̶ibid̶a ewariza Ãcõrẽ de od̶amãrẽã diad̶e zebadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Maʌ̃ bẽrã jũma ne o cawa b̶earãba Ãcõrẽ wua de o panʌra idu b̶ʌd̶aped̶a Moisemaa wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Idjía jarasid̶aa: –Puruba jũmawãyã enebʌdaa Ãcõrẽba obi b̶ʌ de pãrãni carea.– ");
INSERT INTO empNTpo_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Maʌ̃ bẽrã Moiseba deza jaracuabisia umaquĩrãrãba, wẽrãrã bid̶a Ãcõrẽ wua de od̶i careabemada waa diarãnamãrẽã. Mãwã israelerãa waa idu diabid̶aẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Ãdjia diaped̶ad̶ara ad̶ubasia Ãcõrẽ wua de pãrãni carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Maʌ̃be jũma ne o cawa b̶eaba Ãcõrẽ wua dera osid̶aa. Dji biara b̶ʌ lino wuada die edad̶aped̶a maʌ̃ wuad̶e ed̶a Ãcõrẽ nezoca bajãnebema i bara b̶ʌ zaca b̶eada oveja cara nayãna pãwãrã od̶aba, pursupursua od̶aba, purea od̶a bid̶a biya casid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Maʌ̃ die lino wuara ab̶ari quĩrãca b̶easia. Dji drasoara veintiocho bicaca b̶easia. Dji joub̶ʌara bicaca quĩmãrẽ b̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Maʌ̃ die wuad̶ebemada juesuma edad̶aped̶a ãbaa cajusid̶aa joub̶ʌa b̶emãrẽã. Ab̶ari quĩrãca ãbaa cajusid̶aa dewarabema juesuma panʌ sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","12","Maʌ̃ wua joub̶ʌa cajud̶aza i orro ab̶aare cincuenta cʌwʌrʌ cajusid̶aa. Maʌ̃ cʌwʌrʌra wua pãwãrã b̶ʌba osid̶aa. Dji cʌwʌrʌra daucha quĩrã tẽũ cob̶ʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Maʌ̃be oroda edad̶aped̶a cincuenta wua jũẽbarida osid̶aa. Maʌ̃gʌd̶e cʌwʌrʌza jũẽcuasid̶aa maʌ̃ umébema wuara ab̶abe b̶ʌ quĩrãca b̶emãrẽã. Mãwã osid̶aa Ãcõrẽ dera ãnẽb̶ari cob̶ʌd̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Maʌ̃be wua chiwatu cara od̶ada once edad̶aped̶a drasoa joub̶ʌa cajusid̶aa dji nabema wua ʌ̃rʌ̃ ãnẽb̶ari cob̶ʌd̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Maʌ̃ once wua chiwatu cara od̶ara ab̶ari quĩrãca b̶easia. Dji drasoara treinta bicaca b̶easia. Dji joub̶ʌara bicaca quĩmãrẽ b̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Maʌ̃ once wuad̶ebemada sei edad̶aped̶a ãbaa cajusid̶aa joub̶ʌa b̶emãrẽã. Dewarabema juesuma sid̶a ab̶ari quĩrãca cajusid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Maʌ̃ wua joub̶ʌa cajud̶aza i orro ab̶aare cincuenta cʌwʌrʌ cajusid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Idjab̶a bronceda edad̶aped̶a wua jũẽbarida cincuenta osid̶aa. Maʌ̃gʌd̶e cʌwʌrʌza jũẽcuasid̶aa maʌ̃ umébema wuara ab̶abe b̶ʌ quĩrãca b̶emãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Maʌ̃be oveja e purea od̶ada ãbaa cajusid̶aa joub̶ʌa drasoa b̶emãrẽã. Maʌ̃gʌra osid̶aa chiwatu cara od̶a wua ʌ̃rʌ̃ ãnẽb̶ari cob̶ʌd̶i carea. Maʌ̃ ʌ̃rʌ̃ dewarabema animarã e biada joub̶ʌa drasoa cajusid̶aa ãnẽb̶ari cob̶ʌd̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Idjab̶a Ãcõrẽ wua de carea acacia bacuruda ʌrrasid̶aa maʌ̃ba daucha ʌ̃ta catʌ pẽni carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Dji bacuru ʌrrad̶a drasoara die bicaca b̶easia. Dji joub̶ʌara bicaca ab̶a ʌ̃rʌ̃ ẽsidra b̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Dji ed̶aa b̶eira quid̶ate bara osid̶aa. Jũma Ãcõrẽ wua de carea bacuru ʌrrad̶ara mãwã osid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","26","Ãcõrẽ wua de orroza veinte bacuru ʌrrad̶ada ʌ̃ta catʌ pẽsid̶aa. Maʌ̃ bacuru ʌrrad̶aza edre parata od̶a uria b̶eada umé uméa b̶ʌsid̶aa dji quid̶atera maʌ̃ne ed̶a berajud̶i carea. Mãwã orroza cuarenta parata od̶a uria b̶eara b̶ʌsid̶aa maʌ̃ bacuru ʌrrad̶ada daucha pẽ wãni carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ãcõrẽ wua de jẽdaarebemara ʌ̃mãdau b̶aebariare b̶ebadjia. Maʌ̃are sei bacuru ʌrrad̶ada ʌ̃ta catʌ pẽsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Maʌ̃ awara bacuru ʌrrad̶ada umé iquid̶aza ʌ̃ta catʌ pẽsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Dji quẽbʌra jũẽbari bara osid̶aa ʌ̃tʌba ed̶aa ara catʌ cob̶emãrẽã. Iquid̶aza mãwã osid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Jũma ãbaa ocho bacuru ʌrrad̶ada ʌ̃ta catʌ pẽsid̶aa. Maʌ̃ bacuru ʌrrad̶aza edre parata od̶a uria b̶eada umé uméa b̶ʌsid̶aa dji quid̶atera maʌ̃ne ed̶a berajud̶i carea. Mãwã jẽdaarebema parata od̶a uria b̶eara diecisei b̶ʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","32","Idjab̶a acacia bacuruda juesuma erasid̶aa de orroza pĩrũ omoa b̶ead̶e berajud̶i carea. Jẽdaare ʌ̃mãdau b̶aebariare bid̶a acacia bacuruda juesuma pĩrũ omoa b̶ead̶e berajusid̶aa Ãcõrẽ wua dera zarea cob̶emãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Orroza dji ẽsibema bacuru berajud̶ara dji de drasoa daucha b̶asia. Dji jẽdaare b̶ʌ bacuru ẽsi berajud̶ara dji de jed̶ea daucha b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ãcõrẽ wua de carea bacuru ʌrrad̶ara oroba jũma bʌracuasid̶aa. Idjab̶a pĩrũ omoa b̶eara orod̶eda jũma osid̶aa. Maʌ̃ pĩrũra bacuru ʌrrad̶ad̶aa cara b̶ʌsid̶aa maʌ̃ne ed̶a bacuru erad̶ara berajud̶i carea. Bacuru erad̶ara oroba jũma bʌracuasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Idjab̶a wuada osid̶aa Ãcõrẽ dejãne eatʌ jira b̶ʌd̶i carea. Dji biara b̶ʌ lino wuada edad̶aped̶a maʌ̃ wuad̶e ed̶a Ãcõrẽ nezoca bajãnebema i bara b̶ʌ zaca b̶eada oveja cara nayãna pãwãrã od̶aba, pursupursua od̶aba, purea od̶a bid̶a biya casid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Maʌ̃be acacia bacuruda quĩmãrẽ tẽnaped̶a oroba bʌracuasid̶aa. Maʌ̃ bacurura parata od̶a uria b̶ead̶e berajusid̶aa Ãcõrẽ dejãne ʌ̃ta nũmeanamãrẽã. Bacuruza wua jũẽbari oro od̶ada cara b̶ʌsid̶aa wua caped̶ad̶ara eatʌ jira b̶ʌd̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","38","Idjab̶a dji biara b̶ʌ lino wuada edad̶aped̶a maʌ̃ wuad̶e ed̶a oveja cara nayãna pãwãrã od̶ada, pursupursua od̶ada, purea od̶a sid̶a biya casid̶aa. Maʌ̃be acacia bacuruda juesuma tẽnaped̶a dji quẽbʌd̶e oroba bʌracuasid̶aa. Maʌ̃ bacurura bronce od̶a uria b̶ead̶e berajusid̶aa Ãcõrẽ wua ded̶e ed̶a wãbadamaa ʌ̃ta nũmeanamãrẽã. Bacuruza wua jũẽbari oro od̶ada cara b̶ʌsid̶aa wuara dji ed̶a wãbada jũãtrʌ jira b̶ʌd̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezaleelba baurude acacia bacurud̶eda osia. Dji drasoara bicaca umé ʌ̃rʌ̃ ẽsadra b̶asia. Dji joub̶ʌara bicaca ab̶a ʌ̃rʌ̃ ẽsadra b̶asia. Dji ʌ̃tʌara bicaca ab̶a ʌ̃rʌ̃ ẽsadra b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Dji jãra, dajadaare bid̶a oro idji awa quiruba bʌrasia. Iquid̶aza jũma pʌrrʌga oroba tuca b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Idjab̶a pĩrũ orod̶eda quĩmãrẽ omoa osia. Maʌ̃ pĩrũra baurude jĩrũza cara b̶ʌsia. Mãwã orroza pĩrũra umé cara b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Idjab̶a acacia bacuruda umé biya eraped̶a oroba bʌrasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Maʌ̃ bacurura pĩrũne ed̶a beraju b̶ʌsia baurude jira eded̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Maʌ̃be Bezaleelba oro idji awa quiruda pewed̶ea bad̶aa arid̶e osia baurude ʌ̃rʌ̃ cob̶ʌi carea. Dji drasoara bicaca umé ʌ̃rʌ̃ ẽsadra osia. Dji joub̶ʌara bicaca ab̶a ʌ̃rʌ̃ ẽsadra osia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","8","Idjab̶a oroda edaped̶a Ãcõrẽ nezoca bajãnebema i bara b̶ʌ za quĩrãca umé toa chĩ osia. Maʌ̃ra dji baurude ʌ̃rʌ̃ cob̶ʌi carea od̶a ʌ̃rʌ̃ bio cara b̶ʌsia. Quĩrãza iquid̶a ab̶a b̶ʌsia. Mãwã jũma maʌ̃gʌra ab̶a b̶ʌ od̶a quĩrãca b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Ãcõrẽ nezoca bajãnebema i bara b̶ʌ za quĩrãca panʌra idjia quĩrã djica ed̶a b̶arru b̶ʌsia. Ãdji iba dji baurude ʌ̃rʌ̃ cob̶ʌi carea od̶ara jũãtrʌ eropanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Idjab̶a Bezaleelba mesa acacia bacurud̶eda osia. Dji drasoara bicaca umé osia. Dji joub̶ʌara bicaca ab̶a osia. Dji ʌ̃tʌara bicaca ab̶a ʌ̃rʌ̃ ẽsadra osia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Maʌ̃ mesara oro idji awa quiruba jũma bʌrasia. Dji icawa orroza pʌrrʌga tuca b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Mesa ʌ̃rʌ̃ icawa bacuruda cara b̶ʌsia jũgurua b̶emãrẽã. Maʌ̃ bacuru ʌ̃tʌara jʌwa jĩwĩnĩ quĩmãrẽ osia. Maʌ̃ sid̶a icawa pʌrrʌga oroba tuca b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","14","Maʌ̃be pĩrũ orod̶eda quĩmãrẽ omoa osia. Maʌ̃ra mesa jĩrũza cara b̶ʌsia dji jũgurua od̶a edrecarebe. Mãwã b̶ʌsia maʌ̃ne ed̶a bacuruda berajud̶aped̶a mesa jira eded̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Maʌ̃ra acacia bacurud̶eda osia. Biya eraped̶a oroba bʌrasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Idjab̶a oro idji awa quiruda edaped̶a eped̶eco b̶eada, eped̶eco jũgurua b̶eada, taza b̶eada, zoco b̶ea sid̶a osia mesad̶e b̶ʌi carea. Taza b̶eara, zoco b̶ea sid̶a osia uva b̶ada Ãcõrẽa diad̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Idjab̶a Bezaleelba oro idji awa quiruda edaped̶a ĩbĩrã b̶ʌbadada toa chĩ osia. Dji jĩrũda, dji cacuada, dji gʌ̃rʌ̃gʌ̃rʌ̃ã nepõnõ zaca b̶ea sid̶a ab̶ari oro idji awa quirud̶ebemada osia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Maʌ̃ ĩbĩrã b̶ʌbada cacuara sei jʌwate bara osia. Orro ab̶aare ũbea osia. Dewarabema orroare bid̶a ũbea osia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Jʌwateza dji gʌ̃rʌ̃gʌ̃rʌ̃ã nepõnõ zaca b̶eada ũbea osia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Dji cacuad̶e bid̶a gʌ̃rʌ̃gʌ̃rʌ̃ã nepõnõ zaca b̶eada quĩmãrẽ osia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Dji jʌwate cara b̶eaza ab̶a osia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Dji gʌ̃rʌ̃gʌ̃rʌ̃ã nepõnõ quĩrãca b̶eara, dji jʌwate b̶eara, dji cacua sid̶a ab̶ari oro idji awa quirud̶ebemada toa chĩ osia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Idjab̶a oro idji awa quiruda edaped̶a siete ĩbĩrãda, ĩbĩrã quĩrã tʌbadada, ĩbĩrã quĩrã tʌd̶a ãyã edebada eped̶eco zaque sid̶a osia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Maʌ̃ ĩbĩrã b̶ʌbada oro idji awa quiru od̶ada idjab̶a ne jũma idjid̶ebema sid̶a ãbaa zasid̶ad̶e dji zʌgʌara 75 libra b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Idjab̶a Bezaleelba quera bá diabadada acacia bacurud̶eda osia. Dji drasoara, joub̶ʌa sid̶a bicaca ab̶a osia quĩrã quĩmãrẽena ab̶arica b̶amãrẽã. Dji ʌ̃tʌara bicaca umé osia. Iquid̶aza ab̶ari bacurud̶e cachu quĩrãca osia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Oro idji awa quiruba jũma bʌrasia. Icawa pʌrrʌga oroba tuca b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Pĩrũ omoa b̶ea orod̶eda quĩmãrẽ oped̶a orroza umé cara b̶ʌsia dji tuca b̶ʌd̶a edrecare. Mãwã cara b̶ʌsia maʌ̃ne ed̶a bacuruda berajud̶aped̶a quera bá diabadada jira eded̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Maʌ̃ra acacia bacurud̶eda osia. Biya eraped̶a oroba bʌrasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Idjab̶a Bezaleelba olivo draga quera bara b̶ʌda osia ne jũma Ãcõrẽ iteabemada soad̶i carea. Quera bad̶i careabema sid̶a osia. Maʌ̃gʌra jũma osia quera o cawa b̶ʌba obari quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Idjab̶a Bezaleelba animarã babue diabadada acacia bacurud̶eda osia. Dji drasoara bicaca juesuma osia. Dji joub̶ʌa sid̶a bicaca juesuma osia dji quĩrã quĩmãrẽena ab̶arica b̶amãrẽã. Dji ʌ̃tʌara bicaca ũbea osia. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ab̶ari bacurud̶e iquid̶aza cachu quĩrãca oped̶a maʌ̃ animarã babue diabadara bronceba jũma bʌrasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Idjab̶a tʌbʌ pora ãyã cuabadada, tʌbʌ pora tãĩbadada, oa piabadada, warebada mĩãsuda, tʌbʌdau edebada sid̶a jũma bronced̶eda osia. Ab̶ed̶a ne jũma Ãcõrẽa animarã babue diabadad̶ebemada bronced̶eda osia. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Idjab̶a jʌrrʌjʌrrʌa bronced̶eda osia. Maʌ̃ jʌrrʌjʌrrʌara animarã babue diabadad̶e dji id̶eba ed̶aa ẽsidra cara b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Maʌ̃be pĩrũ omoa bronced̶eda quĩmãrẽ od̶aped̶a jʌrrʌjʌrrʌa b̶ʌmaa animarã babue diabada iquid̶aza cara b̶ʌsia maʌ̃ne ed̶a bacuruda berajuped̶a jira eded̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Acacia bacuruda eraped̶a bronceba bʌrasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Maʌ̃ bacurura animarã babue diabada orroza pĩrũ b̶ead̶e berajusia jira eded̶i carea. Maʌ̃ animarã babue diabadara wãyã uria b̶asia. Bacuru ʌrrad̶a basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Idjab̶a Bezaleelba ne sʌgʌbada eped̶eco waib̶ʌada dji acʌ b̶ʌbada bara bronced̶eda osia. Ãcõrẽ wua ded̶e ed̶a wãbadama ne obada wẽrãrãba ãdji bronce od̶a quĩrã acʌbadara diasid̶aa maʌ̃ra omãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","11","Idjab̶a Bezaleelba Ãcõrẽ wua dera aud̶u jũrã b̶ʌsia dji biara b̶ʌ lino wuaba. Maʌ̃ aud̶u jũrã b̶ʌ orroza veinte bronce od̶a uria b̶eada b̶ʌcuaped̶a bacuru tẽnara maʌ̃ne ed̶a wẽãju nũmʌsia. Maʌ̃ bacuru quẽbʌra parataba bʌrasia idjab̶a wua jũẽbari parata od̶a sid̶a cara b̶ʌsia. Lino wuara maʌ̃ne eatʌ jũẽcuasia. Ãcõrẽ wua de aud̶u jũrã b̶ʌ drasoara cien bicaca b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Jẽdaare bid̶a bronce od̶a uria b̶eada die b̶ʌcuaped̶a bacuru tẽnara maʌ̃ne ed̶a wẽãju nũmʌsia. Maʌ̃ bacuru quẽbʌra parataba bʌrasia idjab̶a parata od̶a wua jũẽbari sid̶a cara b̶ʌsia. Maʌ̃ne wuara eatʌ jũẽcuasia. Ãcõrẽ wua de aud̶u jũrã b̶ʌ jẽdaarebemara cincuenta bicaca b̶asia idjab̶a ʌ̃mãdau b̶aebariare b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Dji nocoarebemara ʌ̃mãdau odjabariare b̶asia. Maʌ̃ sid̶a cincuenta bicaca b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Maʌ̃ne dji ed̶a wãbadara ẽsidra osia. Dji ed̶a wãbada jʌwa acʌare bronce od̶a uria b̶eada ũbea b̶ʌped̶a bacuru tẽnara maʌ̃ne ed̶a wẽãju nũmʌsia. Jʌwa araare bid̶a ab̶ari quĩrãca osia. Maʌ̃ne lino wuara eatʌ jũẽcuasia. Dji ed̶a wãbada orro ab̶aare wuara quince bicaca b̶asia idjab̶a dewarabema orroare bid̶a quince bicaca b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Jũma Ãcõrẽ wua de aud̶u jũrã b̶ʌra dji biara b̶ʌ lino wua basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Dji bacuru tẽnara Bezaleelba bronce od̶a uria b̶ead̶e ed̶a wẽãju nũmʌsia. Bacuru quẽbʌza parataba bʌrasia idjab̶a parata od̶a wua jũẽbarida cara b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","19","Idjab̶a Ãcõrẽ wua de aud̶u jũrã b̶ʌd̶e ed̶a wãbadara osia. Bronce od̶a uria b̶eada quĩmãrẽ dji ed̶a wãbadama b̶ʌped̶a maʌ̃ne ed̶a bacuru tẽnara wẽãju nũmʌsia. Maʌ̃ bacuru quẽbʌra parataba bʌrasia idjab̶a parata od̶a wua jũẽbari sid̶a cara b̶ʌsia. Maʌ̃be dji biara b̶ʌ lino wuada edad̶aped̶a maʌ̃ wuad̶e ed̶a oveja cara nayãna pãwãrã od̶ada, pursupursua od̶ada, purea od̶a sid̶a biya casía. Maʌ̃ wuaba dji ed̶a wãbadara jũãtrʌ b̶ʌsia. Maʌ̃ wua jũãtrʌ jira b̶ʌ drasoara veinte bicaca b̶asia. Dji joub̶ʌara bicaca juesuma b̶asia. Jũma Ãcõrẽ wua de aud̶u jũrã b̶ʌ eatʌ jira b̶ʌ wuara ara maʌ̃ joub̶ʌad̶e b̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Jũma Ãcõrẽ wua de egorod̶e cachid̶i careabemara, maʌ̃ de aud̶u jũrã b̶ʌ egorod̶e cachid̶i careabema sid̶a bronce od̶a basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","23","Uri warra Bezaleelba ne jũma Ãcõrẽba Moisea obi jarad̶ara osia. Idjira Judad̶eba yõna Hur wiuzaque basía. Ahisamá warra Aholiába idjira carebabadjia. Aholiára Daʌ̃neba yõna basía. Idjia ne jũmada biya o cawa b̶asia idjab̶a dji biara b̶ʌ lino wuad̶e ed̶a oveja cara nayãna pãwãrã od̶ada, pursupursua od̶ada, purea od̶a sid̶a ca cawa b̶asia. Maʌ̃ de oped̶ad̶acarea Ãcõrẽ baurudeda ed̶a wagabadjid̶aa. Israelerãba maʌ̃ wua de od̶i carea diaped̶ad̶ara levitarãba juachasid̶aa Moiseba jarad̶a quĩrãca. Dji juacha panʌ borora sacerdote Aaroʌ̃ warra Itamar basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Ãdjia Ãcõrẽa diaped̶ad̶a oro zʌgʌara jũma ãbaa 2,000 libra aud̶u b̶asia Ãcõrẽ ded̶e zabada quĩrãca. Maʌ̃gʌba Ãcõrẽ wua ded̶e orod̶ebema oida b̶ad̶ara jũma osid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","26","Israeld̶ebema umaquĩrãrã veinte poad̶eba ʌ̃taa b̶eada juachasid̶ad̶e 603,550 panasid̶aa. Juachasid̶ad̶e ãdjirãza sei gramo paratada diasid̶aa Ãcõrẽ ded̶e zabada quĩrãca. Jũma ãbaa ãdjia diaped̶ad̶a parata zʌgʌara 7,550 libra b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Maʌ̃ paratad̶ebemada 7,500 libra edaped̶a Bezaleelba parata od̶a uria b̶eada 100 ocuasia maʌ̃ne ed̶a Ãcõrẽ wua de bacuru ʌrrad̶ara ʌ̃ta wẽãju pẽi carea idjab̶a Ãcõrẽ wua dejãnebema bacuru tẽnara ʌ̃ta wẽãju nũmʌi carea. Maʌ̃ bacurud̶e dji ed̶aarebema wuara eatʌ jira b̶ʌsia. Parata od̶a uria b̶eaza dji zʌgʌara 75 libra b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Parata od̶a uria b̶ea od̶acarea israelerãba diaped̶ad̶a parata ad̶ubad̶ada 50 libra b̶asia. Maʌ̃ra edaped̶a wua jũẽbari b̶eada ocuasia idjab̶a bacuru tẽna quẽbʌra jũma bʌracuasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Israelerãba Ãcõrẽa diaped̶ad̶a bronce zʌgʌara jũma ãbaa 5,300 libra b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","31","Maʌ̃ bronce edaped̶a Bezaleelba bronce od̶a uria b̶eada ocuasia Ãcõrẽ wua ded̶e ed̶a wãbadama bacuru tẽnara ʌ̃ta wẽãju nũmʌi carea, Ãcõrẽ wua de aud̶u jũrã b̶ʌ bacuru tẽnara ʌ̃ta wẽãju nũmʌi carea, idjab̶a dji aud̶u jũrã b̶ʌd̶e ed̶a wãbadama bacuru tẽnara ʌ̃ta wẽãju nũmʌi carea. Idjab̶a maʌ̃ bronceba idjia osia animarã babue diabadada dji jʌrrʌjʌrrʌa bara idjab̶a jũma maʌ̃ animarã babue diabadad̶ebema sid̶a. Idjab̶a maʌ̃ bronceba idjia osia jũma Ãcõrẽ wua dera egorod̶aa erreb̶ari cachid̶i careabemara, maʌ̃ de aud̶u jũrã b̶ʌra egorod̶aa erreb̶ari cachid̶i careabema sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Bezaleelba idji ume traja panʌ bid̶a Aaroʌ̃ba cacuad̶e jʌ̃ida b̶ʌda osid̶aa oveja cara nayãna pãwãrã od̶aba, pursupursua od̶aba, purea od̶a bid̶a Ãcõrẽba Moisea jarad̶a quĩrãca. Aaroʌ̃ba maʌ̃ra jʌ̃badjia Ãcõrẽ wua ded̶e ne o b̶ʌd̶e. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","3","Aaroʌ̃ba jãare jʌ̃ida b̶ʌra dji biara b̶ʌ lino wuaba osid̶aa. Maʌ̃ wuad̶e ed̶a ãdjirãba oveja cara nayãna pãwãrã od̶ada, pursupursua od̶ada, purea od̶a sid̶a casid̶aa. Idjab̶a oroda pewed̶ea berrachid̶aped̶a chõda tʌcuad̶aped̶a maʌ̃ oro sid̶a dji wuad̶e ed̶a biya casid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Equiaza jʌ̃bari bara osid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Idjab̶a cʌrrʌ trãjʌ̃barida dji biara b̶ʌ lino wuaba osid̶aa. Maʌ̃ cʌrrʌ trãjʌ̃barira idjia jãare jʌ̃ida b̶ʌ ume ãbaa casid̶aa ab̶a b̶ʌ quĩrãca b̶emãrẽã. Maʌ̃ cʌrrʌ trãjʌ̃barid̶e ed̶a oro bʌrachid̶ada, oveja cara nayãna pãwãrã od̶ada, pursupursua od̶ada, purea od̶a sid̶a casid̶aa Ãcõrẽba Moisea jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Idjab̶a ónice mõgarada umé edad̶aped̶a maʌ̃ mõgarad̶e Israel doce warrarã trʌ̃da sẽyã quĩrãca jaya b̶ʌsid̶aa. Maʌ̃ mõgarara oro od̶ad̶e cara b̶ʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Maʌ̃ mõgarara Aaroʌ̃ba jãare jʌ̃ida b̶ʌ equiaza ab̶a cajusid̶aa Ãcõrẽba Moisea jarad̶a quĩrãca. Maʌ̃ mõgarad̶e b̶ʌd̶aba Israel doce warrarãda quĩrãnebabibadjia. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Idjab̶a “Ãcõrẽba quĩrĩã b̶ʌ cawabibarida” Bezaleelba idji ume traja panʌ bid̶a osid̶aa Aaroʌ̃ba idji so ʌ̃rʌ̃ jʌ̃ b̶amãrẽã. Maʌ̃gʌra dji biara b̶ʌ lino wuaba osid̶aa. Maʌ̃ wuad̶e ed̶a oro bʌrachid̶ada, oveja cara nayãna pãwãrã od̶ada, pursupursua od̶ada, purea od̶a sid̶a biya casid̶aa Aaroʌ̃ba jãare jʌ̃ida b̶ʌd̶e caped̶ad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Maʌ̃ wua cad̶ara ẽsidra b̶ed̶a capirusid̶aa ne wagabada quĩrãca b̶amãrẽã. Mãwã dji drasoara, joub̶ʌa sid̶a jʌwajã ewarama ab̶a b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Maʌ̃ ʌ̃rʌ̃ mõgara biya qued̶eada errecama quĩmãrẽ cara b̶ʌcuasid̶aa. Dji nabema errecad̶e naʌ̃gʌ mõgarada b̶ʌsid̶aa: rubí, crisólito, esmeralda. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Umébema errecad̶e b̶ʌsid̶aa: granate, zapiro, jade. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Ũbeabema errecad̶e b̶ʌsid̶aa: jacinto, ágata, amatista. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Quĩmãrẽbema errecad̶e b̶ʌsid̶aa: topacio, ónice, jaspe. Jũma maʌ̃ mõgarara oro od̶ad̶aa cara b̶ʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Maʌ̃ doce mõgaraba jara b̶ʌa Israel warrarãneba doce puru yõped̶ad̶ada. Mõgaraza sẽyã quĩrãca ãdji trʌ̃ra ab̶a ab̶a jaya b̶ʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Idjab̶a oro idji awa quiruba carenada umé casid̶aa “Ãcõrẽba quĩrĩã b̶ʌ cawabibarira” Aaroʌ̃ba idji so ʌ̃rʌ̃ jʌ̃mãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Pĩrũ orod̶eda umé od̶aped̶a “Ãcõrẽba quĩrĩã b̶ʌ cawabibari” ʌ̃rʌ̃bema iquid̶aza cajusid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Pĩrũza carena oro cad̶a quẽbʌra ab̶a ab̶a cara b̶ʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Dewarabema quẽbʌra cara b̶ʌsid̶aa umébema oro od̶ad̶aa Aaroʌ̃ba jãare jʌ̃ida b̶ʌ equiaza. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Dewara pĩrũ orod̶eda umé od̶aped̶a “Ãcõrẽba quĩrĩã b̶ʌ cawabibari” ed̶aarebema iquid̶aza edrecare cajusid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Dewara pĩrũ orod̶eda umé od̶aped̶a Aaroʌ̃ba jãare jʌ̃ida b̶ʌd̶e cajusid̶aa cʌrrʌ trãjʌ̃bari ʌ̃taarebe. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Jʌ̃cara pãwãrã od̶aba maʌ̃ pĩrũra ãbaa jʌ̃sid̶aa “Ãcõrẽba quĩrĩã b̶ʌ cawabibari” edre panʌ pĩrũnaa. Mãwã “Ãcõrẽba quĩrĩã b̶ʌ cawabibarira” Aaroʌ̃ so ʌ̃rʌ̃ catʌ cob̶esia. Ãdjirãba maʌ̃gʌra jũma osid̶aa Ãcõrẽba Moisea jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Idjab̶a wua pãwãrã b̶ʌda edad̶aped̶a Aaroʌ̃ba djio wẽãju jʌ̃ida b̶ʌda osid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Maʌ̃ wuara ẽsidra uria osid̶aa. Maʌ̃ uria ira b̶ed̶atʌ cajusid̶aa cõãrãmãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Idjab̶a granadajõ za quĩrãca casid̶aa oveja cara nayãna pãwãrã od̶aba, pursupursua od̶aba, purea od̶a bid̶a. Maʌ̃ra Aaroʌ̃ba jʌ̃ida b̶ʌ pãwãrã b̶ʌ ed̶ubema id̶e mimizua pʌrrʌga cajusid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","26","Idjab̶a oro idji awa quiruda edad̶aped̶a pĩrãchiruda ocuasid̶aa. Maʌ̃ sid̶a mimizua pʌrrʌga cajusid̶aa Aaroʌ̃ba jʌ̃ida b̶ʌ pãwãrã b̶ʌ id̶e. Granadajõ za quĩrãca cad̶ada ab̶a maʌ̃ id̶e cajud̶aped̶a maʌ̃are pĩrãchiruda ab̶a cajusid̶aa. Jũma pʌrrʌga mãwã caju wãsid̶aa. Ãcõrẽba Moisea jarad̶a quĩrãca maʌ̃ djio pãwãrã b̶ʌra osid̶aa Aaroʌ̃ba jʌ̃ b̶amãrẽã Ãcõrẽ wua ded̶e ne o b̶ʌd̶e. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Idjab̶a Aaroʌ̃ itea, idji warrarã itea bid̶a ãdjia cacuad̶e jʌ̃nida panʌ torroa b̶eada dji biara b̶ʌ lino wuaba osid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Idjab̶a ãdji borod̶e jʌ̃nida panʌra, ãdjia edreare jʌ̃nida panʌ sid̶a dji biara b̶ʌ lino wuaba osid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Idjab̶a ãdji itea cʌrrʌ trãjʌ̃barida dji biara b̶ʌ lino wuaba osid̶aa. Maʌ̃ wuad̶e ed̶a oveja cara nayãna pãwãrã od̶ada, pursupursua od̶ada, purea od̶a sid̶a casid̶aa. Jũma maʌ̃gʌra ãdjirãba osid̶aa Ãcõrẽba Moisea jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Aaroʌ̃ itea borob̶arida osid̶aa maʌ̃ jʌ̃ b̶ʌd̶e Ãcõrẽ itea b̶amãrẽã. Oro idji awa quiruda pewed̶ea berrachi od̶aped̶a naʌ̃ bed̶eada jaya b̶ʌsid̶aa: “Ab̶a Ãcõrẽ itea b̶ʌ.” ");
INSERT INTO empNTpo_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Maʌ̃be jʌ̃cara pãwãrã b̶ʌba maʌ̃ oro pewed̶ea berrachi od̶ara ãdjirãba jʌ̃ cob̶ʌsid̶aa Aaroʌ̃ba borod̶e jʌ̃ida b̶ʌd̶e. Jũma maʌ̃gʌra osid̶aa Ãcõrẽba Moisea jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Mãwã israelerãba ne jũma Ãcõrẽ wua de careabemada pãrãsid̶aa. Maʌ̃gʌra jũma osid̶aa Ãcõrẽba Moisea jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ãcõrẽ wua de careabemara jũma pãrãnaped̶a Moisemaa edesid̶aa. Maʌ̃ de od̶i careabema wuara edesid̶aa. Idjab̶a jũma maʌ̃ de careabema sid̶a edesid̶aa: wua jũẽbarida, bacuru ʌrrad̶ada, bacuru erad̶a orroza berajud̶i careabemada, bacuru tẽnada, bacuru tẽna berajud̶i careabema sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","35","Edesid̶aa Ãcõrẽ wua de ãnẽb̶ari b̶ʌd̶i oveja e purea od̶ada, maʌ̃ ʌ̃rʌ̃ ãnẽb̶ari b̶ʌd̶i animarã e biada, Ãcõrẽ baurudeda dji jira eded̶i bacuru bara, maʌ̃ baurude ʌ̃rʌ̃ cob̶ʌd̶i careabemada, baurude nocoare eatʌ jira b̶ai wua sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Idjab̶a paʌ̃ b̶ʌbada mesada, jũma maʌ̃ mesad̶e b̶aira, paʌ̃ Ãcõrẽ quĩrãpita b̶ai careabema sid̶a edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Ĩbĩrã b̶ʌbada oro idji awa quiru od̶ada, ĩbĩrãra maʌ̃ ʌ̃rʌ̃ erreca b̶ʌd̶i carea, jũma maʌ̃ ĩbĩrãnebemada, idjab̶a olivo draga ĩbĩrã coad̶i careabema sid̶a edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Quera bá diabada oro od̶ada, quera bad̶i careabemada, olivo draga quera bara b̶ʌda jũma Ãcõrẽ iteabema soad̶i carea, Ãcõrẽ wua ded̶e ed̶a wãbadama eatʌ jũãtrʌ b̶ai wua sid̶a edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Animarã babue diabada bronce bʌrad̶ada, dji jʌrrʌjʌrrʌa bronce od̶ada, dji jira eded̶i bacuruda, jũma maʌ̃ animarã babue diabadad̶ebema sid̶a edesid̶aa. Idjab̶a ne sʌgʌbadada dji acʌ b̶ʌd̶i bara edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Ãcõrẽ wua de aud̶u jũrã b̶ʌi careabema wuada, dji bacuru tẽnada, maʌ̃ bacuru berajud̶i careabemada, dji aud̶u jũrã b̶ʌd̶e ed̶a wãbadama eatʌ jũãtrʌ b̶ai wuada, dji egorod̶e cachid̶i careabemara jʌ̃cara bara edesid̶aa. Ne jũma Ãcõrẽ wua de careabemada edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Idjab̶a Aaroʌ̃ djiora, idji warrarã djio sid̶a edesid̶aa ãdjira sacerdoterãda b̶ead̶amãrẽã. Maʌ̃ djiora jʌ̃nida panʌa Ãcõrẽ wua ded̶e ne od̶e wãbʌdad̶e. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Jũma israelerãba oped̶ad̶ara Ãcõrẽba Moisea obi jarad̶a quĩrãca b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Maʌ̃ra Moiseba acʌped̶a unusia ãdjirãba jũma arid̶e osid̶ada Ãcõrẽba jarad̶a quĩrãca. Maʌ̃ bẽrã ãdjirãra bia jarasia. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Maʌ̃be Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","–Poa djiwid̶id̶e nabema jed̶ecod̶e dji nabema ewarid̶e mʌ̃ wua dera carawad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Mʌ̃ baurudeda maʌ̃ ded̶e ed̶aara b̶ʌ dejãne b̶ʌd̶adua. Maʌ̃ baurude nocoare wuada eatʌ jira b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Idjab̶a mesada ed̶a enenaped̶a jũma maʌ̃ mesad̶e b̶aida b̶ʌra ʌ̃rʌ̃ b̶ʌd̶adua. Ĩbĩrã b̶ʌbada sid̶a ed̶a enenaped̶a ĩbĩrãra jʌwateza b̶ʌcuad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Quera babada oro od̶ada mʌ̃ wua ded̶e ed̶a b̶ʌd̶adua mʌ̃ baurude quĩrãpe. Mãwã b̶ʌd̶aped̶a dji ed̶a wãbadara wuaba eatʌ jũãtrʌ b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Mʌ̃ wua ded̶e ed̶a wãbada quĩrãpe animarã babue diabadara b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ne sʌgʌbadada b̶ʌd̶adua animarã babue diabada jẽdaare mʌ̃ wua de caita. Maʌ̃gʌd̶e baidoda jue ũmʌnadua. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Maʌ̃be mʌ̃ dera wuaba aud̶u jũrã b̶ʌd̶adua. Maʌ̃ aud̶u jũrã b̶ʌd̶e ed̶a wãbadara wuaba eatʌ jũãtrʌ b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Maʌ̃be olivo draga quera bara b̶ʌra edaped̶a mʌ̃ wua deda, jũma maʌ̃ ded̶e nũmea sid̶a soadua mʌ̃ itea bia b̶emãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Animarã babue diabadada, jũma maʌ̃ animarã babue diabadad̶ebema sid̶a soadua mʌ̃ itea bio bia b̶emãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ne sʌgʌbada sid̶a dji acʌ b̶ʌd̶i bara soadua mʌ̃ itea b̶emãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Maʌ̃be Aaroʌ̃ra idji warrarã sid̶a mʌ̃ wua ded̶e ed̶a wãbadamaa edeped̶a baidoba sʌgʌdua. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Sʌgʌd̶acarea djio Aaroʌ̃ itea oped̶ad̶ara idjía jʌ̃bidua. Maʌ̃be olivo draga quera bara b̶ʌda Aaroʌ̃ boro ʌ̃rʌ̃ weadua mʌ̃ sacerdote dji dromada b̶emãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Aaroʌ̃ warrarãra caita zebiped̶a ãdjia jʌ̃nida panʌ torroa b̶eada jʌ̃bidua. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ãdjirã boro ʌ̃rʌ̃ olivo draga quera bara b̶ʌda weadua ara ãdji zeza boro ʌ̃rʌ̃ wead̶a quĩrãca. Mãwã ãdjirãra mʌ̃ sacerdoterãda b̶ead̶ia. Olivo draga ãdjirã boro ʌ̃rʌ̃ weabʌrʌba ãdjirãdrʌ, ãdjid̶eba yõbʌdarã sid̶a mʌ̃ sacerdoterãda b̶ead̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Ara maʌ̃da Moiseba jũma osia Ãcõrẽba jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","18","Egiptod̶eba ẽdrʌped̶ad̶acarea poa ab̶a babʌrʌd̶e nabema jed̶ecod̶e dji nabema ewarid̶e Moiseba Ãcõrẽ wua dera carawabisia. Idjia parata od̶a uria b̶eara erreca b̶ʌcuabisia. Maʌ̃gʌd̶e ed̶a bacuru ʌrrad̶a quid̶atera berajucuabisia maʌ̃ bacurura ʌ̃ta catʌ pẽni carea. Orroza bacuru erad̶ara pĩrũ omoa b̶ead̶e berajucuabisia maʌ̃ dera zarea cob̶emãrẽã. Dji dejãnebema bacuru tẽnara, dji ed̶a wãbadama bacuru tẽna sid̶a ʌ̃ta nũmʌbisia. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Jũma maʌ̃ ʌ̃rʌ̃ idjia wuada umé ãnẽb̶ari b̶ʌbisia. Maʌ̃ ʌ̃rʌ̃ animarã e od̶ada umé ãnẽb̶ari b̶ʌbisia Ãcõrẽba idjía jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ãcõrẽba ĩjã obi b̶ʌ bed̶ea mõgarad̶e b̶ʌ́ b̶ʌda Moiseba bauruded̶e ed̶a waga b̶ʌsia. Waga b̶ʌped̶a maʌ̃ baurude ʌ̃rʌ̃ cob̶eira cob̶ʌsia. Bacuru erad̶ara pĩrũ omoa b̶ead̶e ed̶a beraju b̶ʌsia jira eded̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Baurudera Ãcõrẽ wua ded̶e ed̶a b̶ʌbisia. B̸ʌd̶aped̶a wuada eatʌ jira b̶ʌbisia baurude jũãtrʌ erob̶amãrẽã Ãcõrẽba idjía jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Maʌ̃ wua eatʌ jira b̶ʌ nocoare Moiseba mesada Ãcõrẽ wua ded̶e jʌwa araare b̶ʌbisia. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Maʌ̃ mesa ʌ̃rʌ̃ paʌ̃da Ãcõrẽ quĩrãpita b̶ʌsia Ãcõrẽba idjía jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ãcõrẽ wua ded̶e jʌwa acʌare dji mesa quĩrãpe Moiseba ĩbĩrã b̶ʌbadara b̶ʌbisia. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Maʌ̃ ĩbĩrã b̶ʌbada jʌwateza ĩbĩrãda b̶ʌcuabisia Ãcõrẽ quĩrãpita coai carea Ãcõrẽba idjía jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ãcõrẽ dejãne eatʌ jira b̶ʌ wua nocoare Moiseba quera bá diabadada b̶ʌbisia. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Maʌ̃ ʌ̃rʌ̃ querada bá diasia Ãcõrẽba idjía jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Dji ed̶a wãbadara Moiseba wuaba eatʌ jũãtrʌ b̶ʌbisia. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ãcõrẽ wua ded̶e ed̶a wãbada quĩrãpe Moiseba animarã babue diabadara b̶ʌbisia. Maʌ̃ ʌ̃rʌ̃ animarãda, harina od̶a sid̶a Ãcõrẽa babue diasia Ãcõrẽba idjía jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Animarã babue diabada jẽdaare Ãcõrẽ wua de caita Moiseba ne sʌgʌbadada b̶ʌbisia. Maʌ̃gʌd̶e baidoda jue ũmʌbisia. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moiseba, Aaroʌ̃ba, Aaroʌ̃ warrarã bid̶a ãdji jʌwara, jĩrũ sid̶a maʌ̃ baidoba sʌgʌbadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Mãwã sʌgʌbadjid̶aa Ãcõrẽ wua ded̶e ed̶a wãbʌdaza idjab̶a Ãcõrẽa animarã babue diabʌdaza Ãcõrẽba Moisea jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Moiseba Ãcõrẽ wua dera, animarã babue diabada sid̶a wuaba aud̶u jũrã b̶ʌbisia. Maʌ̃ne ed̶a wãbadara wuaba eatʌ jũãtrʌ b̶ʌbisia. Mãwã Moiseba Ãcõrẽ wua dera pãrãsia. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","35","Jũma pãrãnacarea jʌ̃rãrã ʌ̃tʌba ed̶aa jira b̶ʌba Ãcõrẽ wua dera ãnã edasia. Maʌ̃ne Ãcõrẽ quĩrãwãrẽã dorrodorroada maʌ̃ ded̶e ed̶a wãsia. Maʌ̃ba Moisera ed̶a poya wãẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Maʌ̃ ewarid̶eba ʌ̃taa maʌ̃ jʌ̃rãrã Ãcõrẽ wua de ʌ̃rʌ̃ b̶ʌda nocod̶aa wãbʌrʌd̶e israelerã sid̶a nocod̶aa wãbadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Baribʌrʌ jʌ̃rãrãra Ãcõrẽ wua de ʌ̃rʌ̃ b̶esira israelerã sid̶a aria panebadjid̶aa ab̶a jʌ̃rãrã wayacusa nocod̶aa wãbʌrʌd̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Jũma israelerãba acʌ panʌ daid̶e ãsa Ãcõrẽ jʌ̃rãrãra idji wua de ʌ̃rʌ̃ b̶abadjia. Diamasi tʌbʌ quĩrãca uruga jira b̶abadjia. Mãwã b̶asia ãdjirã wãbʌdaza.");
INSERT INTO empNTpo_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Ãcõrẽba idji wua ded̶eba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","–Israelerãa nãwã jaradua: “Ab̶aʌba idji animarãnebemada Ãcõrẽa diaibʌrʌ, pacada, ovejada, wa chiwatuda diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Pacada babue diaibʌrʌ, dji umaquĩrãdrʌ diaida b̶ʌa. Maʌ̃ pacara jũma bia b̶aida b̶ʌa. Maʌ̃ra Ãcõrẽ wua ded̶e ed̶a wãbadamaa edeida b̶ʌa idjia diabʌrʌra Ãcõrẽba bia unumãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Dji diabʌrʌba idji jʌwara paca boro ʌ̃rʌ̃ b̶ʌida b̶ʌa. Mãwã Ãcõrẽba maʌ̃ pacara dji ẽberã cacuabari edaya idjia cadjirua od̶a quĩrãdoai carea. ");
INSERT INTO empNTpo_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Maʌ̃be Ãcõrẽ quĩrãpita pacara o ʌrrãgo beaida b̶ʌa. Maʌ̃ne Aaroʌ̃ warrarã sacerdoterãba dji oara piad̶aped̶a animarã babue diabada orroza jĩãpod̶ida panʌa Ãcõrẽ wua de quĩrãpe. ");
INSERT INTO empNTpo_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Dji diad̶aba pacara epaped̶a, drapetaped̶a tʌcuaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Mãwã o b̶ʌd̶e sacerdote Aaroʌ̃ warrarãba animarã babue diabada ʌ̃rʌ̃ tʌbʌra uruga nũmʌnida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","9","Dji diad̶aba paca jʌ̃sira, dji jĩrũ sid̶a baidoba sʌgʌida b̶ʌa. Sʌgʌd̶acarea Aaroʌ̃ warrarã sacerdoterãba maʌ̃gʌra, dji animarã tʌcuad̶ara, dji borora, dji draga sid̶a animarã babue diabadad̶e tʌbʌ uruga nũmʌ ʌ̃rʌ̃ b̶ʌd̶aped̶a jũma babue diad̶ida panʌa. Maʌ̃ paca babue diabʌrʌra Ãcõrẽba bia unuya. ");
INSERT INTO empNTpo_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Ab̶aʌba idji animarãnebema ovejada wa chiwatuda Ãcõrẽa babue diaibʌrʌ, dji umaquĩrãdrʌ diaida b̶ʌa. Maʌ̃ animarãra jũma bia b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Maʌ̃ra Ãcõrẽ quĩrãpita animarã babue diabada jʌwa araare o ʌrrãgo beaida b̶ʌa. Maʌ̃ne Aaroʌ̃ warrarã sacerdoterãba dji oara piad̶aped̶a animarã babue diabada orroza jĩãpod̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","13","Dji diad̶aba animarãra drapetaped̶a tʌcuaida b̶ʌa. Tʌcuaped̶a dji jʌ̃sira, dji jĩrũ sid̶a baidoba sʌgʌida b̶ʌa. Maʌ̃gʌra, dji animarã tʌcuad̶ara, dji borora, dji draga sid̶a sacerdoteba animarã babue diabadad̶e tʌbʌ uruga nũmʌ ʌ̃rʌ̃ b̶ʌped̶a jũma babue diaida b̶ʌa. Maʌ̃ animarã babue diabʌrʌra Ãcõrẽba bia unuya. ");
INSERT INTO empNTpo_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Ab̶aʌba ĩbanada Ãcõrẽa babue diaibʌrʌ, puchirãda wa putujuda diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Sacerdoteba maʌ̃ ĩbanara animarã babue diabadamaa edeped̶a otapuya beaida b̶ʌa. Beaped̶a dji borora animarã babue diabadad̶e babueida b̶ʌa. Dji oara animarã babue diabada orrod̶e zowuabida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Maʌ̃be carab̶aped̶a, jẽsaped̶a dji jʌ̃sida, dji cara sid̶a animarã babue diabada orrocawa b̶ʌida b̶ʌa dji tʌbʌ pora b̶ʌmaa. Dji tʌbʌ porara animarã babue diabada ʌ̃mãdau odjabariare b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Maʌ̃be dji id̶e jidaped̶a ĩbanara drawe ewara cob̶ʌida b̶ʌa. Mãwã cob̶ʌped̶a animarã babue diabadad̶e babue diaida b̶ʌa. Maʌ̃ ĩbana babue diabʌrʌra Ãcõrẽba bia unuya.”– ");
INSERT INTO empNTpo_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Ab̶aʌba idji néud̶ebema harina od̶ada Ãcõrẽa diaibʌrʌ, dji biara b̶ʌ harinada diaida b̶ʌa. Maʌ̃ harina ʌ̃rʌ̃ nedragada weaped̶a incienso querada ʌ̃rʌ̃ cob̶ʌida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Maʌ̃ra idjia Aaroʌ̃ warrarã sacerdoterãmaa edeida b̶ʌa. Maʌ̃ harinanebemada sacerdoteba jʌwa baratʌma ab̶a edaida b̶ʌa nedraga bara idjab̶a jũma dji incienso quera bara. Maʌ̃gʌra animarã babue diabada ʌ̃rʌ̃ babue diaida b̶ʌa. Maʌ̃ maãrĩ babue diabʌrʌd̶eba acʌbi b̶ʌa jũma maʌ̃ harinara Ãcõrẽa dia b̶ʌda. Maʌ̃ babue diabʌrʌra Ãcõrẽba bia unuya. ");
INSERT INTO empNTpo_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Maʌ̃ harinanebemada maãrĩ Ãcõrẽa babue diad̶a bẽrã jũma dji b̶ed̶a sid̶a Ãcõrẽ itea b̶esia. Maʌ̃ bẽrã ab̶abe Aaroʌ̃ba idji warrarã bid̶a arima cod̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Ab̶aʌba paʌ̃ ãbud̶ada Ãcõrẽa diaibʌrʌ, dji biara b̶ʌ harina od̶ada diaida b̶ʌa. Maʌ̃ paʌ̃ra ẽsãbari neẽ́ b̶aida b̶ʌa. Nedraga bara oida b̶ʌa wa nedragaba ʌ̃rʌ̃ pʌrʌida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Jiorro pewed̶ea od̶ad̶e paʌ̃ ãbud̶ada diad̶e edeibʌrʌ, dji biara b̶ʌ harina nedraga bara od̶ada diaida b̶ʌa. Maʌ̃gʌra ẽsãbari neẽ́ b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Maʌ̃ paʌ̃ra jũma cõrãcuaped̶a nedragada ʌ̃rʌ̃ weaida b̶ʌa, Ãcõrẽa diai bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Paʌ̃ cugurud̶e ãbud̶ada diad̶e edeibʌrʌ, dji biara b̶ʌ harina nedraga bara od̶ada diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Maʌ̃ paʌ̃ ãbud̶ad̶ebemada dji Ãcõrẽa diabʌrʌba sacerdotemaa edeped̶a sacerdoteba animarã babue diabadamaa edeida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Maʌ̃be maãrĩ edaped̶a maʌ̃gʌra animarã babue diabadad̶e Ãcõrẽa babue diaida b̶ʌa. Maʌ̃ maãrĩ babue diabʌrʌd̶eba acʌbi b̶ʌa jũma maʌ̃ paʌ̃ra Ãcõrẽa dia b̶ʌda. Maʌ̃ paʌ̃ babue diabʌrʌra Ãcõrẽba bia unuya. ");
INSERT INTO empNTpo_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Maʌ̃ paʌ̃nebemada maãrĩ Ãcõrẽa babue diad̶a bẽrã jũma dji b̶ed̶a sid̶a Ãcõrẽ itea b̶esia. Maʌ̃ bẽrã ab̶abe Aaroʌ̃ba idji warrarã bid̶a arima cod̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Bãrã néud̶ebemada Ãcõrẽa diabʌdad̶e paʌ̃ ẽsãbari bara b̶ʌda diacara panʌa, paʌ̃ ẽsãbarida, urrajõ sid̶a Ãcõrẽa babue diacara panʌ bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Bãrãba naãrã ewabʌdad̶ebemada Ãcõrẽa diabʌdad̶e paʌ̃ ẽsãbari bara, urrajõ bara diad̶ida panʌa. Baribʌrʌ animarã babue diabadad̶e babue diacara panʌa, Ãcõrẽba bia unuẽ́ bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Jũma bãrã néud̶ebemada Ãcõrẽa diabʌdad̶e tã bara diad̶ida panʌa. Tã neẽ́ b̶ʌra diacara panʌa. Tãba cawabi b̶ʌa Ãcõrẽba bãrã ume bed̶ea b̶ʌd̶ada jõẽ́da. Maʌ̃ bẽrã jũma Ãcõrẽa diabʌdara tã bara b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Bãrãba naãrã ewabʌdad̶ebemada Ãcõrẽa diabʌdad̶e jututiad̶aped̶a tẽũnada Ãcõrẽa diad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Maʌ̃ ʌ̃rʌ̃ nedragada wead̶aped̶a incienso querada ʌ̃rʌ̃ cob̶ʌd̶ida panʌa, Ãcõrẽa diad̶i bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Sacerdoteba maʌ̃nebemada Ãcõrẽa babue diaida b̶ʌa dji nedraga bara idjab̶a jũma dji incienso quera bara. Maʌ̃ maãrĩ babue diabʌrʌd̶eba acʌbi b̶ʌa jũma maʌ̃ jututiad̶ara Ãcõrẽa dia b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Ab̶aʌba Ãcõrẽ ume necai b̶ai carea pacada diaibʌrʌ, dji umaquĩrãda wa dji wẽrãda diaida b̶ʌa. Maʌ̃ pacara jũma bia b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Dji dia b̶ʌba idji jʌwara paca boro ʌ̃rʌ̃ b̶ʌped̶a o ʌrrãgo beaida b̶ʌa Ãcõrẽ wua ded̶e ed̶a wãbada caita. Maʌ̃be Aaroʌ̃ warrarã sacerdoterãba dji oara animarã babue diabada ʌ̃rʌ̃ idjab̶a orroza bid̶a jĩãpod̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","4","Dji dia b̶ʌba dji tʌrida, b̶ited̶abema dragada, cotruada umena dji draga bara, nequima sid̶a Aaroʌ̃ warrarãa diaida b̶ʌa Ãcõrẽa babue diad̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Ãdjirãba jũma maʌ̃gʌra animarã babue diabadad̶e Ãcõrẽa babue diad̶ida panʌa animarã bá nũmʌcãda ʌ̃rʌ̃. Maʌ̃ babue diabʌrʌra Ãcõrẽba bia unuya. ");
INSERT INTO empNTpo_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Ab̶aʌba Ãcõrẽ ume necai b̶ai carea ovejada wa chiwatuda diaibʌrʌ, dji umaquĩrãda wa dji wẽrãda diaida b̶ʌa. Maʌ̃ra jũma bia b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ovejada diaibʌrʌ, Ãcõrẽ quĩrãpita edeida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Idji jʌwara oveja boro ʌ̃rʌ̃ b̶ʌped̶a o ʌrrãgo beaida b̶ʌa Ãcõrẽ wua de quĩrãpe. Maʌ̃be Aaroʌ̃ warrarãba dji oara animarã babue diabada ʌ̃rʌ̃ idjab̶a orroza bid̶a jĩãpod̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","10","Dji dia b̶ʌba dji dragada, dji dru carraya tʌd̶ada, dji tʌrida, cotrua umena dji draga bara, nequima sid̶a sacerdoterãa diaida b̶ʌa Ãcõrẽa babue diad̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Sacerdoteba jũma maʌ̃gʌra animarã babue diabadad̶e Ãcõrẽa babue diaida b̶ʌa. Maʌ̃ babue diabʌrʌra Ãcõrẽa djico diabʌrʌ quĩrãca b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Ãcõrẽ ume necai b̶ai carea dia b̶ʌba chiwatuda diaibʌrʌ, Ãcõrẽ quĩrãpita edeida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Mama idji jʌwara chiwatu boro ʌ̃rʌ̃ b̶ʌped̶a o ʌrrãgo beaida b̶ʌa Ãcõrẽ wua de quĩrãpe. Maʌ̃be Aaroʌ̃ warrarãba dji oara animarã babue diabada ʌ̃rʌ̃ idjab̶a orroza bid̶a jĩãpod̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","15","Dji dia b̶ʌba dji tʌrida, cotruada umena dji draga bara, nequima sid̶a sacerdotea diaida b̶ʌa Ãcõrẽa babue diamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Maʌ̃be sacerdoteba jũma maʌ̃gʌra animarã babue diabadad̶e Ãcõrẽa babue diaida b̶ʌa. Maʌ̃ babue diabʌrʌra Ãcõrẽa djico diabʌrʌ quĩrãca b̶ʌa. Ãcõrẽba maʌ̃ra bia unuya. Jũma dji dragada Ãcõrẽa babue diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Id̶iba ʌ̃taa naʌ̃ bed̶eada ĩjã od̶ida panʌa: bãrã wãbʌdaza bãrãba, bãrã warrarãneba yõbʌdarã bid̶a animarã dragada, oa sid̶a cocara panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Idjab̶a Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","–Israelerãa nãwã jaradua: “Ab̶aʌba cadjirua oi crĩchaẽ́ b̶ʌd̶e Ãcõrẽ leyda ãĩ oibʌrʌ, maʌ̃ cadjirua od̶a carea nãwã oida b̶ʌa: ");
INSERT INTO empNTpo_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Sacerdote dji dromaara b̶ʌba mãwã cadjiruada oibʌrʌ, puru sid̶a Ãcõrẽ quĩrãpita bed̶ead̶e b̶aya. Maʌ̃ cadjirua od̶a carea paca umaquĩrã zaqueda Ãcõrẽa babue diaida b̶ʌa. Maʌ̃ pacara jũma bia b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Maʌ̃ra Ãcõrẽ wua ded̶e ed̶a wãbada quĩrãpe edeped̶a idji jʌwara paca boro ʌ̃rʌ̃ b̶ʌped̶a o ʌrrãgo beaida b̶ʌa Ãcõrẽ quĩrãpita. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Maʌ̃be dji oada maãrĩ edaped̶a Ãcõrẽ wua ded̶e ed̶a edeida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Mama ed̶a idji jʌwa jĩwĩnĩra maʌ̃ oad̶e b̶eguea edaped̶a b̶arima siete Ãcõrẽ quĩrãpita jĩãpoida b̶ʌa wua eatʌ jira b̶ʌ quĩrãpe. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Maʌ̃be quera bá diabadad̶e cachu quĩrãca b̶eara maʌ̃ oaba soaida b̶ʌa Ãcõrẽ quĩrãpita. Ãcõrẽ wua ded̶eba dajadaa zeped̶a dji ed̶a wãbada quĩrãpe paca oa b̶ed̶ara animarã babue diabada cob̶ʌ caita jũma weaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","9","Maʌ̃be cadjirua od̶a carea paca bead̶a b̶ited̶abema dragada jũma edaida b̶ʌa: dji tʌrida, cotruada umena dji draga bara, nequima sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","(Ãcõrẽ ume necai b̶ai carea animarã draga edabari quĩrãca oida b̶ʌa.) Edaped̶a jũma maʌ̃gʌra animarã babue diabadad̶e Ãcõrẽa babue diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","12","Pacad̶ebema b̶ed̶ara israelerã duanʌmaʌba jũma ãyã edeida b̶ʌa: dji eda, dji djarada, dji boroda, dji jĩrũda, jũma b̶ited̶abemada, dji ã sid̶a. Jũma maʌ̃gʌra edeida b̶ʌa animarã babued̶a pora cuabadamaa. Maʌ̃ pora ʌ̃rʌ̃ tʌbʌ cajẽrãped̶a pacara jũma babueida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Cadjirua oi crĩchaẽ́ b̶ʌd̶e Israel puruba Ãcõrẽ leyda ãĩ oibʌrʌ, cadjirua od̶ara adua b̶ʌmĩna Ãcõrẽ quĩrãpita bed̶ead̶e b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Baribʌrʌ puruba cawasira, maʌ̃ cadjirua carea paca umaquĩrã zaqueda Ãcõrẽ wua demaa edeida b̶ʌa babue diabi carea. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Maʌ̃be Ãcõrẽ quĩrãpita israelerã bororãba ãdji jʌwara paca boro ʌ̃rʌ̃ b̶ʌd̶aped̶a o ʌrrãgo bead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Maʌ̃be sacerdote dji dromaara b̶ʌba dji oada maãrĩ Ãcõrẽ wua ded̶e ed̶a edeida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Mama ed̶a idji jʌwa jĩwĩnĩra maʌ̃ oad̶e b̶eguea edaped̶a b̶arima siete Ãcõrẽ quĩrãpita jĩãpoida b̶ʌa wua eatʌ jira b̶ʌ quĩrãpe. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Maʌ̃be Ãcõrẽ quĩrãpita quera bá diabadad̶e cachu quĩrãca b̶eara maʌ̃ oaba soaida b̶ʌa. Ãcõrẽ wua ded̶eba dajadaa zeped̶a dji ed̶a wãbada quĩrãpe paca oa b̶ed̶ara animarã babue diabada cob̶ʌ caita jũma weaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Maʌ̃be paca b̶ited̶abema dragada jũma edaped̶a animarã babue diabadad̶e Ãcõrẽa babue diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Idjia oida b̶ʌa ara idji cadjirua carea od̶a quĩrãca. Sacerdoteba mãwã oida b̶ʌa bãrãba cadjirua oped̶ad̶a carea. Mãwãbʌrʌ Ãcõrẽba maʌ̃ cadjiruara quĩrãdoaya. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Maʌ̃be pacad̶ebema b̶ed̶ara israelerã duanʌmaʌba ãyã edeped̶a jũma babueida b̶ʌa ara idji cadjirua carea bead̶a paca ãyã edeped̶a jũma babued̶a quĩrãca. Mãwã oida b̶ʌa maʌ̃ pacara bead̶a bẽrã Israel puruba cadjirua od̶a carea. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Cadjirua oi crĩchaẽ́ b̶ʌd̶e bãrã bororãnebemaba Ãcõrẽ leyda ãĩ oibʌrʌ, cadjirua od̶ara adua b̶ʌmĩna Ãcõrẽ quĩrãpita bed̶ead̶e b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Baribʌrʌ cadjirua od̶ada cawasira, chiwatu dji umaquĩrãda edeida b̶ʌa Ãcõrẽ quĩrãpita babue diabi carea. Maʌ̃ chiwatura jũma bia b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Animarã babue diad̶i careabema beabadama idji jʌwara chiwatu boro ʌ̃rʌ̃ b̶ʌped̶a Ãcõrẽ quĩrãpita o ʌrrãgo beaida b̶ʌa idjia cadjirua od̶a carea. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Maʌ̃be sacerdoteba maʌ̃ cadjirua carea bead̶a chiwatu oad̶e idji jʌwa jĩwĩnĩra b̶eguea edaped̶a animarã babue diabadad̶e cachu quĩrãca b̶eara soaida b̶ʌa. Chiwatu oa b̶ed̶ara animarã babue diabada cob̶ʌ caita jũma weaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Maʌ̃be jũma dji draga b̶ited̶abemada Ãcõrẽa babue diaida b̶ʌa Ãcõrẽ ume necai b̶ai careabema animarã dragada babue diabari quĩrãca. Maʌ̃gʌra sacerdoteba oida b̶ʌa bãrã boroba cadjirua od̶a carea. Mãwãbʌrʌ Ãcõrẽba maʌ̃ cadjiruara quĩrãdoaya. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Cadjirua oi crĩchaẽ́ b̶ʌd̶e bãrãnebemaba Ãcõrẽ leyda ãĩ oibʌrʌ, cadjirua od̶ara adua b̶ʌmĩna Ãcõrẽ quĩrãpita bed̶ead̶e b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Baribʌrʌ cadjirua od̶ada cawasira, chiwatu wẽrãda edeida b̶ʌa Ãcõrẽ quĩrãpita babue diabi carea. Maʌ̃ chiwatura jũma bia b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Animarã babue diad̶i careabema beabadama idji jʌwara chiwatu boro ʌ̃rʌ̃ b̶ʌped̶a o ʌrrãgo beaida b̶ʌa idjia cadjirua od̶a carea. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Maʌ̃be sacerdoteba chiwatu oad̶e idji jʌwa jĩwĩnĩra b̶eguea edaped̶a animarã babue diabadad̶e cachu quĩrãca b̶eara soaida b̶ʌa. Chiwatu oa b̶ed̶ara animarã babue diabada cob̶ʌ caita jũma weaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Maʌ̃be dji dragada jũma edaida b̶ʌa Ãcõrẽ ume necai b̶ai careabema animarã draga edabari quĩrãca. Edaped̶a dji dragara animarã babue diabadad̶e jũma babue diaida b̶ʌa Ãcõrẽba bia unumãrẽã. Maʌ̃gʌra sacerdoteba oida b̶ʌa ab̶aʌba cadjirua od̶a carea. Mãwãbʌrʌ Ãcõrẽba maʌ̃ cadjiruara quĩrãdoaya. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Ab̶aʌba chiwatu cãyãbara ovejada idjia cadjirua od̶a carea babue diabi quĩrĩã b̶ʌbʌrʌ, oveja wẽrãda edeida b̶ʌa. Maʌ̃ ovejara jũma bia b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Animarã babue diad̶i careabema beabadama idji jʌwara oveja boro ʌ̃rʌ̃ b̶ʌped̶a o ʌrrãgo beaida b̶ʌa idjia cadjirua od̶a carea. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Maʌ̃be sacerdoteba maʌ̃ cadjirua carea oveja bead̶a oad̶e idji jʌwa jĩwĩnĩra b̶eguea edaped̶a animarã babue diabadad̶e cachu quĩrãca b̶eara soaida b̶ʌa. Oveja oa b̶ed̶ara animarã babue diabada cob̶ʌ caita jũma weaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Maʌ̃be dji dragada jũma edaida b̶ʌa Ãcõrẽ ume necai b̶ai careabema animarã draga edabari quĩrãca. Edaped̶a dji dragara Ãcõrẽa jũma babue diaida b̶ʌa animarã babue diabadad̶e bá nũmʌcãda animarã ʌ̃rʌ̃. Maʌ̃gʌra idjia oida b̶ʌa ab̶aʌba cadjirua od̶a carea. Mãwãbʌrʌ Ãcõrẽba maʌ̃ cadjiruara quĩrãdoaya. ");
INSERT INTO empNTpo_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Bãrã bororãba ẽberã cawa obʌdad̶e ab̶aʌda trʌ̃nibʌrʌ, maʌ̃gʌ ẽberãba ununada wa ũrĩnada jaraẽ́bʌrʌ cadjiruada o b̶ʌa. Maʌ̃ carea bed̶ead̶e b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Bãrãba cocara panʌ animarã mẽãbemada, daupẽbadada, wa jãne wãbada beud̶ada ab̶aʌba waraibʌrʌ, warad̶ada adua b̶ʌmĩna maʌ̃ ẽberãra Ãcõrẽ quĩrãpita biẽ́ b̶ed̶a bẽrã bed̶ead̶e b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ab̶aʌba Ãcõrẽ quĩrãpita biẽ́ b̶ʌ ẽberãda waraibʌrʌ wa maʌ̃ ẽberãnebemada waraibʌrʌ, mãwã warad̶ara adua b̶ʌmĩna cawabʌrʌd̶e bed̶ead̶e b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Ab̶aʌba quĩrãcuita crĩchaẽ́ne bariduad̶e oida wãrãneba jaraibʌrʌ, mãwã jarad̶ara quĩrãdoaimĩna cawabʌrʌd̶e Ãcõrẽ quĩrãpita bed̶ead̶e b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Mãwã b̶ea cadjirua od̶aba idjia od̶ara jũmarãa ebud̶a jaraida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Idjia cadjirua od̶a carea idji animarãnebema oveja wẽrãda wa chiwatu wẽrãda edeida b̶ʌa Ãcõrẽa babue diabi carea. Maʌ̃be sacerdoteba maʌ̃gʌ animarã dragara Ãcõrẽa babue diaida b̶ʌa maʌ̃ ẽberãba cadjirua od̶a carea. ");
INSERT INTO empNTpo_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Ne neẽ́ quiruba ovejada diai carea neẽ́ b̶ʌbʌrʌ, puchirãda umé wa putujuda umé edeida b̶ʌa. Ab̶a Ãcõrẽ quĩrãpita beabida b̶ʌa idjia cadjirua od̶a carea idjab̶a ab̶a Ãcõrẽa jũma babue diabida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Maʌ̃ umébema ĩbanara sacerdotemaa edeped̶a sacerdoteba ab̶a otapuya beaida b̶ʌa dji eded̶aba cadjirua od̶a carea. Otapuya beabʌrʌd̶e ab̶ed̶a dji borora tʌcara b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Maʌ̃ cadjirua carea ĩbana bead̶a oara animarã babue diabada orro ab̶aare maãrĩ jĩãpoida b̶ʌa. Oa b̶ed̶ara animarã babue diabada cob̶ʌ caita jũma weaida b̶ʌa. Mãwã oida b̶ʌa dji eded̶aba cadjirua od̶a carea. ");
INSERT INTO empNTpo_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Maʌ̃be sacerdoteba dewarabema ĩbanara jũma Ãcõrẽa babue diaida b̶ʌa Ãcõrẽba obi jarad̶a quĩrãca. Jũma maʌ̃gʌra idjia oida b̶ʌa dji eded̶aba cadjirua od̶a carea. Mãwãbʌrʌ Ãcõrẽba maʌ̃ cadjiruara quĩrãdoaya. ");
INSERT INTO empNTpo_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Baribʌrʌ ne neẽ́ quiruba puchirãda umé wa putujuda umé diai carea neẽ́ b̶ʌbʌrʌ, dji biara b̶ʌ harinada eped̶eco jũgurua umé diaida b̶ʌa idjia cadjirua od̶a carea. Maʌ̃ harinane nedragada, incienso quera sid̶a b̶ʌcara b̶ʌa cadjirua carea dia b̶ʌ bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Maʌ̃ harinara sacerdotemaa edeped̶a sacerdoteba jʌwa baratʌma ab̶a edaped̶a Ãcõrẽa babue diaida b̶ʌa animarã babue diabadad̶e bá nũmʌcãda ʌ̃rʌ̃. Maʌ̃ maãrĩ babue diabʌrʌd̶eba acʌbi b̶ʌa harinara jũma Ãcõrẽa dia b̶ʌda. Maʌ̃ harina diad̶ara cadjirua carea diasia. ");
INSERT INTO empNTpo_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Sacerdoteba mãwã oida b̶ʌa dji eded̶aba cadjirua od̶a carea. Mãwãbʌrʌ Ãcõrẽba maʌ̃ cadjiruara quĩrãdoaya. Harina b̶ed̶ara sacerdote itea b̶aya bãrã néud̶ebema Ãcõrẽa babue diabʌrʌd̶e dji b̶ed̶ara idji itea b̶ebari quĩrãca.”– ");
INSERT INTO empNTpo_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Idjab̶a Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","–Cadjirua oi crĩchaẽ́ b̶ʌd̶e ab̶aʌba Ãcõrẽa diaida b̶ʌd̶ebemada jũma diaẽ́bʌrʌ, maʌ̃ cadjirua od̶a carea idji animarãnebema oveja dji umaquĩrãda Ãcõrẽa diaida b̶ʌa. Maʌ̃ ovejara jũma bia b̶aida b̶ʌa. Dji nẽbʌara daucha b̶aida b̶ʌa idjia diaida b̶ʌ quĩrãca. Maʌ̃bari paratara diabʌrʌbara Ãcõrẽ ded̶e zabada quĩrãca diaida b̶acasia. ");
INSERT INTO empNTpo_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Idjia Ãcõrẽa diaẽ́ b̶ʌda diaped̶a sacerdotea maʌ̃ aud̶u diaida b̶ʌa. Maʌ̃be idjia ovejara beaped̶a idji cadjirua carea sacerdoteba Ãcõrẽa babue diaya. Mãwãbʌrʌ Ãcõrẽba maʌ̃ cadjiruara quĩrãdoaya. ");
INSERT INTO empNTpo_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Ab̶aʌba Ãcõrẽ leyda ãĩ oibʌrʌ, ãĩ od̶ada adua b̶ʌmĩna Ãcõrẽ quĩrãpita maʌ̃ cadjirua carea bed̶ead̶e b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Cawabʌrʌd̶e idji animarãnebema oveja dji umaquĩrãda sacerdotemaa edeida b̶ʌa Ãcõrẽa babue diamãrẽã maʌ̃ cadjirua od̶a carea. Maʌ̃ ovejara jũma bia b̶aida b̶ʌa. Dji nẽbʌara daucha b̶aida b̶ʌa idjia diaida b̶ʌ quĩrãca. Ovejara beaped̶a idji cadjirua carea sacerdoteba Ãcõrẽa babue diaya. Mãwã idjia adua b̶ʌd̶e cadjirua od̶ara Ãcõrẽba quĩrãdoaya. ");
INSERT INTO empNTpo_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Maʌ̃ ẽberãba Ãcõrẽ leyda ãĩ od̶a bẽrã bed̶ead̶e b̶ʌa. Maʌ̃ bẽrã ovejara babue diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Idjab̶a Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","–Ab̶aʌba idjia wagamãrẽã ne b̶ed̶ada sewad̶eba adua b̶ʌad̶a aibʌrʌ, wa idjia drʌad̶ada drʌaẽ́ b̶ʌad̶a aibʌrʌ, wa cũrũga b̶ʌd̶eba djãrãneda jãrĩbʌrʌ, Ãcõrẽ quĩrãpita cadjiruada o b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Maʌ̃ awara ab̶aʌba ne aduad̶ada unuped̶a sewad̶eba unuẽ́ b̶ʌad̶a aibʌrʌ, wa baridua maʌ̃ quĩrãca b̶eada oped̶a mẽrãibʌrʌ, Ãcõrẽ quĩrãpita cadjiruada o b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","5","Bariduaba maʌ̃ cadjirua quĩrãca b̶eada oibʌrʌ, Ãcõrẽ quĩrãpita bed̶ead̶e b̶aya. Maʌ̃ bẽrã idjia drʌa erob̶ʌra, wa cũrũga b̶ʌd̶eba jãrĩ erob̶ʌra, wa idjima b̶ed̶a sewad̶eba jẽda diaẽ́ b̶ʌra, wa djãrã ne aduad̶a mẽrã erob̶ʌra, wa baridua djãrãne mẽrã erob̶ʌ sid̶a djibaría jẽda diaida b̶ʌa. Jẽda diaped̶a maʌ̃ aud̶u diaida b̶ʌa. Mãwã diaida b̶ʌa idjia cadjirua od̶a carea oveja beabʌrʌ ewarid̶e. ");
INSERT INTO empNTpo_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Maʌ̃ne idji animarãnebema oveja dji umaquĩrãda sacerdotemaa edeida b̶ʌa babue diamãrẽã idjia cadjirua od̶a carea. Maʌ̃ ovejara jũma bia b̶aida b̶ʌa. Dji nẽbʌara daucha b̶aida b̶ʌa idjia diaida b̶ʌ quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Idjia ovejara beaped̶a idji cadjirua carea sacerdoteba Ãcõrẽ quĩrãpita babue diaya. Mãwãbʌrʌ Ãcõrẽba maʌ̃ cadjiruara quĩrãdoaya. ");
INSERT INTO empNTpo_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Aaroʌ̃ warrarã Nadába, Abiu bid̶a ãdji quera babada eped̶ecoda edad̶aped̶a tʌbʌdauda quera sid̶a maʌ̃ eped̶ecod̶e b̶ʌsid̶aa. Maʌ̃da Ãcõrẽba jarad̶a awara idji quĩrãpita básid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Maʌ̃ carea Ãcõrẽba tʌbʌ uruada idji b̶ʌmaʌba eradrʌbisia. Maʌ̃ uruaba ãdjira bá beasia. Mãwã idji quĩrãpita beusid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Maʌ̃be Moiseba Aaroʌ̃a jarasia: –Naʌ̃ra jãwãsia Ãcõrẽba jarad̶a quĩrãca oped̶ad̶aẽ́ bẽrã. Ãcõrẽba nãwã jarasia: Mʌ̃ caita zebʌdaba mʌ̃ra waya pananida panʌa. Mʌ̃drʌ jũmarã quĩrãpita bia jarad̶ida panʌa. Maʌ̃da ũrĩped̶a Aaroʌ̃ra chupea b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Maʌ̃be Moiseba Aaroʌ̃ djabadrõã Uziel warrarã Misaelda, Elzapaʌ̃ sid̶a trʌ̃ped̶a jarasia: –Zed̶adua. Bãrã ẽberãrã beuped̶ad̶ara Ãcõrẽ wua de caitabemada puru jĩga eded̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ara maʌ̃da zed̶aped̶a Moiseba jarad̶a quĩrãca dji beuped̶ad̶ara ãdji djio jʌ̃ panʌ bara puru jĩga edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Ãcõrẽba jarad̶a awara idji quĩrãpita quera babʌda carea Aaroʌ̃ warrarãra umé beusid̶aa. Beuped̶ad̶acarea Ãcõrẽra Moise ume bed̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Nãwã jarasia: –Bʌ djaba Aaroʌ̃a jaradua mʌ̃ ded̶e wua eatʌ jira b̶ʌ jẽdaare mʌ̃ itea biara b̶ʌ dejãne baridua ewarid̶e ed̶a wãrãmãrẽã. Baridua ewarid̶e ed̶a wãsira beuya, mʌ̃ra baurude ʌ̃rʌ̃ jʌ̃rãrãne b̶ʌ bẽrã. Ab̶abe mʌ̃a b̶ʌd̶a ewarid̶e ed̶a wãida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Maʌ̃ ewarid̶e Aaroʌ̃ba nãwã oida b̶ʌa: idjia cadjirua od̶a carea paca dji umaquĩrã zaqueda eneida b̶ʌa babue diai carea. Idjab̶a oveja dji umaquĩrãda eneida b̶ʌa jũma babue diai carea. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Maʌ̃be cuiped̶a idjia edre jʌ̃bari lino wua od̶ada jʌ̃ida b̶ʌa. Maʌ̃ ʌ̃rʌ̃ idjia jʌ̃bari lino wua od̶a torroa b̶ʌda jʌ̃ped̶a cʌrrʌ trãjʌ̃bari lino od̶aba trãjʌ̃ cob̶ʌida b̶ʌa. Idji borod̶e jʌ̃bari lino od̶a sid̶a jʌ̃ida b̶ʌa. Maʌ̃gʌra idjia jʌ̃ida b̶ʌa mʌ̃ quĩrãpita ne obʌrʌd̶e. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Maʌ̃ awara israelerãba cadjirua oped̶ad̶a carea idjía chiwatu dji umaquĩrãda umé diad̶ida panʌa dji draga babue diamãrẽã. Idjab̶a oveja dji umaquĩrãda diad̶ida panʌa jũma babue diamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aaroʌ̃ba cadjirua od̶a carea, idji ẽberãrãba cadjirua oped̶ad̶a carea bid̶a paca umaquĩrã zaquera eneya babue diai carea. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Chiwatura umena mʌ̃ quĩrãpita eneida b̶ʌa mʌ̃ wua ded̶e ed̶a wãbada caita. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Maʌ̃be bãrãba cawad̶i carea jemenebada quĩrãca Aaroʌ̃ba oya cawai carea sãʌ̃gʌ chiwatuda mʌ̃ itea b̶aida idjab̶a sãʌ̃gʌda ẽjũã põãsa ewaraga b̶ʌd̶e ẽrãbueida. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Chiwatu mʌ̃ itea b̶ed̶ara Aaroʌ̃ba babue diai carea b̶ʌya israelerãba cadjirua oped̶ad̶a carea. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Chiwatu ẽrãbuei carea b̶ed̶ara Aaroʌ̃ba mʌ̃ quĩrãpita zocai erob̶aya israelerãba cadjirua oped̶ad̶ara ãyã edemãrẽã ẽjũã põãsa ewaraga b̶ʌd̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aaroʌ̃ba paca zaquera o ʌrrãgo beaida b̶ʌa idjia cadjirua od̶a carea idjab̶a idji ẽberãrãba cadjirua oped̶ad̶a carea bid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Maʌ̃be quera babada eped̶ecoda edaped̶a tʌbʌdau mʌ̃ quĩrãpita b̶ʌ animarã babue diabadad̶ebemaba biraida b̶ʌa. Idjab̶a incienso quera dji ʌrabad̶ada jʌwa baratʌma umé edaida b̶ʌa. Maʌ̃ra jũma edeida b̶ʌa mʌ̃ ded̶e wua eatʌ jira b̶ʌ jẽdaare. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Mama mʌ̃ quĩrãpita querada tʌbʌdau ʌ̃rʌ̃ cuaida b̶ʌa cowa nũmemãrẽã. Maʌ̃ cowaaba mʌ̃ baurude ʌ̃rʌ̃ cob̶ʌra ãnã edaya. Mãwãbʌrʌ Aaroʌ̃ra beuẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Maʌ̃be paca oada edaped̶a idji jʌwa jĩwĩnĩba maãrĩ jĩãpoida b̶ʌa baurude ʌ̃rʌ̃ iquid̶a. Idjab̶a baurude quĩrãpe egode b̶arima siete jĩãpoida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Maʌ̃be dajadaa wãped̶a chiwatu mʌ̃ itea b̶ed̶ara o ʌrrãgo beaida b̶ʌa israelerãba cadjirua oped̶ad̶a carea. Chiwatu oara mʌ̃ wua ded̶e eatʌ jira b̶ʌ jẽdaare edeped̶a baurude ʌ̃rʌ̃, baurude quĩrãpe egode bid̶a jĩãpoida b̶ʌa idjia naãrã paca oa jĩãpod̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Mʌ̃ wua dera bãrã dji cadjirua obadarã tãẽna b̶ʌ bẽrã Aaroʌ̃ba mãwã oaba jĩãpoida b̶ʌa. Mãwã mʌ̃ itea biara b̶ʌ dejãda mʌ̃ quĩrãpita bia b̶ʌya israelerãba cadjirua o panʌnebemada, mʌ̃ quĩrãpita biẽ́ panʌnebemada, idjab̶a mʌ̃ bed̶ea ĩjã od̶aẽ́ panʌnebema sid̶a. Mʌ̃ itea b̶ʌ dejãra ara maʌ̃ quĩrãca oida b̶ʌa mʌ̃ quĩrãpita bia b̶emãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Aaroʌ̃ba cadjirua carea mʌ̃ itea biara b̶ʌ dejãne oa jĩãpod̶e wãbʌrʌd̶e ab̶a ẽdrʌbʌrʌd̶aa ni ab̶aʌda mʌ̃ wua ded̶e b̶acara b̶ʌa. Mama ed̶a b̶ʌd̶e Aaroʌ̃ba oara jĩãpoya idjia cadjirua od̶a carea, idji ẽberãrãba cadjirua oped̶ad̶a carea, idjab̶a israelerãba cadjirua oped̶ad̶a carea bid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Mʌ̃ wua ded̶eba dajadaa zeped̶a mʌ̃ quĩrãpita b̶ʌ animarã babue diabadamaa wãida b̶ʌa bia b̶ʌi carea. Idjia paca oara, chiwatu oa sid̶a maãrĩ edaped̶a animarã babue diabadad̶e cachu quĩrãca b̶eara soaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Maʌ̃be animarã babue diabada ʌ̃rʌ̃ idji jʌwa jĩwĩnĩba oada b̶arima siete jĩãpoida b̶ʌa animarã babue diabadara mʌ̃ quĩrãpita bia b̶ʌi carea. Mãwã oida b̶ʌa animarã babue diabadara israelerã mʌ̃ quĩrãpita biẽ́ panʌneba biẽ́ b̶ebari bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Mʌ̃ itea biara b̶ʌ dejã, mʌ̃ itea b̶ʌ dejã, animarã babue diabada sid̶a mʌ̃ quĩrãpita bia b̶ʌd̶acarea Aaroʌ̃ba chiwatu wad̶i zocai erob̶ʌra caita eneida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Idji jʌwara chiwatu boro ʌ̃rʌ̃ b̶ʌped̶a jũma israelerãba cadjirua oped̶ad̶ara, mʌ̃ bed̶ea ĩjã od̶aẽ́ panana sid̶a Aaroʌ̃ba ebud̶a jaraida b̶ʌa maʌ̃ cadjiruara chiwatu ʌ̃rʌ̃ b̶ʌi carea. Maʌ̃be ab̶aʌda b̶ʌya chiwatura ẽjũã põãsa ewaraga b̶ʌd̶aa edemãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Maʌ̃ chiwatuba jũma bãrã cadjiruara ãyã edeya ẽberãrã neẽ́maa. Mama ẽjũã põãsa ewaraga b̶ʌd̶e dji eded̶aba chiwatura ẽrãbueida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Maʌ̃misa Aaroʌ̃ra mʌ̃ wua ded̶e ed̶a wãped̶a idjia jʌ̃ b̶ʌ lino wua od̶ara ẽrãped̶a mama ameida b̶ʌa. Maʌ̃ra idjia jʌ̃baria mʌ̃ itea biara b̶ʌ dejãne wãi carea. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Maʌ̃be arima cuiped̶a idjia ewariza jʌ̃barida jʌ̃ida b̶ʌa. Maʌ̃be dajadaa wãped̶a idjia enena ovejada, israelerãba diaped̶ad̶a oveja sid̶a beaped̶a jũma babue diaida b̶ʌa idjia cadjirua od̶a carea, israelerãba cadjirua oped̶ad̶a carea bid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Maʌ̃be cadjirua carea paca, chiwatu sid̶a bead̶a dragada animarã babue diabadad̶e jũma babueida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Chiwatu ẽjũã põãsa ewaraga b̶ʌd̶e ẽrãbued̶ara jẽda zebʌrʌd̶e cuida b̶ʌa idjab̶a idjia cacuad̶e jʌ̃ b̶ʌra tãtoida b̶ʌa. Maʌ̃bebʌrʌ bãrã duanʌmaa zeida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Bãrã cadjirua carea bead̶a pacara, chiwatu sid̶a israelerã duanʌmaʌba ãyã edeida b̶ʌa babuei carea. Dji era, dji djarara, dji ã sid̶a jũma babueida b̶ʌa. Aaroʌ̃ba maʌ̃ animarã oara mʌ̃ itea biara b̶ʌ dejãne jĩãposia. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ẽberã maʌ̃ animarã ãyã bád̶e wã b̶ad̶ara jẽda zebʌrʌd̶e cuida b̶ʌa idjab̶a idjia cacuad̶e jʌ̃ b̶ʌra tãtoida b̶ʌa. Maʌ̃bebʌrʌ bãrã duanʌmaa zeida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Id̶iba ʌ̃taa bãrã israelerãba naʌ̃ bed̶eada ĩjã od̶ida panʌa. Poaza sietebema jed̶ecod̶e die ewari b̶ʌd̶e bãrãba ne cod̶aca ewarida od̶ida panʌa. Maʌ̃ ewarid̶e trajacara panʌa. Ãĩbemarã bãrã tãẽna panʌ sid̶a trajacara panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Poaza maʌ̃ ewarid̶e sacerdote dji dromaara b̶ʌba mʌ̃a jarad̶a quĩrãca oya bãrãba cadjirua oped̶ad̶a carea. Mãwã bãrãra mʌ̃ quĩrãpita bia b̶ead̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Maʌ̃ ewarira ʌ̃nãũbada ewari dromaa. Maʌ̃ne bãrãra ne cod̶acara panʌa. Id̶iba ʌ̃taa poaza maʌ̃ ewarid̶e mãwã od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Sacerdote dji dromaara b̶ʌ jaid̶abʌrʌd̶e idji warra boro ʌ̃rʌ̃ olivo dragada wead̶ida panʌa idji zeza cacuabari b̶emãrẽã. Maʌ̃ warraba israelerãba cadjirua oped̶ad̶a carea oida b̶ʌ quĩrãca oya. Maʌ̃ ewarid̶e sacerdoteba lino wua od̶a jʌ̃ida b̶ʌra jʌ̃ya. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Maʌ̃ne oa jĩãpo b̶ʌd̶eba idjia mʌ̃ itea biara b̶ʌ dejãda, mʌ̃ itea b̶ʌ dejãda, animarã babue diabada sid̶a bia b̶ʌya. Idjab̶a sacerdoterãba cadjirua oped̶ad̶a carea, jũma bãrãba cadjirua oped̶ad̶a carea bid̶a idjia oida b̶ʌ quĩrãca oya. ");
INSERT INTO empNTpo_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Id̶iba ʌ̃taa mʌ̃a naʌ̃ra ĩjã obi b̶ʌa: poaza b̶arima ab̶a sacerdote dji dromaara b̶ʌba mʌ̃a jarad̶a quĩrãca oida b̶ʌa jũma israelerãba cadjirua oped̶ad̶a carea. Maʌ̃be Ãcõrẽba Moisea jarad̶a quĩrãca o panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Maʌ̃be Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","–Israelerãa jaradua mʌ̃a naʌ̃gʌ ewari droma b̶eada poaza obi b̶ʌda. Maʌ̃ ewari b̶ead̶e bãrãra ãbaa dji jʌred̶ida panʌa mʌ̃́a bia bed̶ead̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Sei ewari bãrã trajura od̶ida panʌa, baribʌrʌ sietebema ewarid̶e ʌ̃nãũnida panʌa. Maʌ̃ ewarid̶e bãrãra ni maãrĩ bid̶a trajad̶acara panʌa. Maʌ̃ awara ãbaa dji jʌred̶ida panʌa mʌ̃́a bia bed̶ead̶i carea. Bãrã panane wãbʌdama bid̶a ʌ̃nãũbada ewarira mʌ̃ itea wagad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Mʌ̃a naʌ̃gʌ ewari droma b̶eada poaza obi b̶ʌa. Mʌ̃a b̶ʌd̶a ewarid̶e maʌ̃ ewari b̶eara bãrãba od̶ida panʌa. Maʌ̃ ewarid̶e ãbaa dji jʌred̶ida panʌa mʌ̃́a bia bed̶ead̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Poaza dji naãrãbema jed̶ecod̶e catorce ewari queubʌrʌd̶e bãrã Egiptod̶eba ẽdrʌped̶ad̶a quĩrãnebabada ewarira od̶ida panʌa mʌ̃́a bia bed̶ead̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Maʌ̃be ab̶ari jed̶ecod̶e quince ewarid̶eba ʌ̃taa bãrãba paʌ̃ ẽsãbari neẽ́ b̶ʌ cobada ewarira od̶ida panʌa mʌ̃́a bia bed̶ead̶i carea. Maʌ̃ne siete ewari bãrãba paʌ̃ ẽsãbari neẽ́ b̶ʌda cod̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Dji naãrãbema ewarid̶e bãrãra ãbaa dji jʌred̶ida panʌa mʌ̃́a bia bed̶ead̶i carea. Maʌ̃ ewarid̶e bãrãra trajad̶acara panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Maʌ̃ siete ewarid̶e animarãda mʌ̃́a ewariza babue diabid̶ida panʌa. Jĩrũarebema ewarid̶e bãrãra wayacusa ãbaa dji jʌred̶ida panʌa mʌ̃́a bia bed̶ead̶i carea. Maʌ̃ ewarid̶e bid̶a bãrãra trajad̶acara panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Idjab̶a Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","–Israelerãa nãwã jaradua: “Mʌ̃a bãrãa diai jarad̶a ẽjũãne jũẽped̶ad̶acarea poaza bãrã néu naãrã ewabʌdad̶ebemada jʌwa jãmãtʌma ab̶a sacerdotemaa eded̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Maʌ̃ra idjia mʌ̃ quĩrãpita ʌ̃taa waida b̶ʌa mʌ̃a bãrã bia unui carea. Mãwã oida b̶ʌa bãrã Egiptod̶eba ẽdrʌped̶ad̶a quĩrãnebabada ewari nurẽma. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Ara maʌ̃ ewarid̶e bãrãba oveja poa ab̶a b̶ʌda mʌ̃́a babue diabid̶ida panʌa. Maʌ̃ ovejara jũma bia b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Maʌ̃ awara dji biara b̶ʌ harinada eped̶eco jũgurua umé nedragad̶aa bʌratʌd̶aped̶a maʌ̃nebema sid̶a mʌ̃́a maãrĩ babue diabid̶ida panʌa. Maʌ̃ harina babue diabʌrʌra mʌ̃a bia unuya. Idjab̶a uva b̶ada boteya ab̶a animarã babue diabada ʌ̃rʌ̃ mʌ̃́a wea diabid̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Poaza maʌ̃gʌra mʌ̃́a diad̶i naẽna maʌ̃ poad̶ebema ewabʌdara cocara panʌa. Djiwid̶i puread̶ara, dji jututiad̶a sid̶a cocara panʌa. Paʌ̃ sid̶a od̶aped̶a cocara panʌa. Id̶iba ʌ̃taa bãrã panane wãbʌdaza maʌ̃ bed̶eara ĩjã od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Bãrã Egiptod̶eba ẽdrʌped̶ad̶a quĩrãnebabada ewari nurẽma bãrã néu naãrã ewabʌdad̶ebemada mʌ̃́a jʌwa jãmãtʌma ab̶a diad̶aped̶a domia siete juachad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Maʌ̃ siete domia juachaped̶ad̶acarea nurẽma cincuenta ewari baya. Maʌ̃ ewarid̶e bãrã néu naãrã ewaped̶ad̶ad̶ebemada mʌ̃́a wayacusa diad̶e zed̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Nãwã od̶ida panʌa: bãrã diguid̶aʌba paʌ̃da umé enenida panʌa mʌ̃́a ʌ̃taa wa diabid̶i carea. Maʌ̃ paʌ̃ra eped̶eco jũgurua umé dji biara b̶ʌ harina ẽsãbari bara od̶a baida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Maʌ̃ paʌ̃ diabʌdad̶e paca dji umaquĩrã zaqueda ab̶a, oveja dji umaquĩrãda umé, idjab̶a oveja dji umaquĩrã zaquerã poa ab̶a b̶eada siete diad̶ida panʌa. Maʌ̃ animarãra jũma bia b̶ead̶ida panʌa. Maʌ̃gʌra diad̶ia sacerdoteba mʌ̃́a jũma babue diamãrẽã. Maʌ̃gʌrã animarã babue diabʌrʌd̶e bãrã néud̶ebema harina od̶ara mʌ̃́a diabid̶ida panʌa, uva b̶a sid̶a wea diabid̶ida panʌa. Maʌ̃ babue diabʌrʌra mʌ̃a bia unuya. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Maʌ̃be bãrãba cadjirua oped̶ad̶a carea chiwatu dji umaquĩrãda ab̶a bead̶aped̶a sacerdoteba babue diaida b̶ʌa. Idjab̶a Ãcõrẽ ume necai b̶ai carea oveja zaquerã poa ab̶a b̶eada umé bead̶apeda sacerdoteba dji dragada babue diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Maʌ̃ umébema oveja zaque djarara, bãrã néu naãrã ewaped̶ad̶ad̶ebema paʌ̃ od̶a sid̶a sacerdoteba mʌ̃́a ʌ̃taa wa diaida b̶ʌa. Maʌ̃ne jũma maʌ̃gʌra mʌ̃ itea b̶eya. Maʌ̃ bẽrã sacerdoterãba jũma edad̶ida panʌa cod̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Ara maʌ̃ ewarid̶e bãrãra ãbaa dji jʌred̶ida panʌa mʌ̃́a bia bed̶ead̶i carea. Maʌ̃ ewarid̶e trajad̶acara panʌa. Id̶iba ʌ̃taa bãrã panane wãbʌdaza bãrãba, bãrã warrarãneba yõbʌdarã bid̶a maʌ̃ bed̶eara ĩjã od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Bãrã néu ewabʌdad̶e jũma ewarãnadua. Icawa maãrĩ b̶ed̶adua. Dji b̶aed̶a sid̶a jʌrʌ perãnadua. Maʌ̃gʌra b̶ed̶adua dji ne neẽ́ qued̶ea itea idjab̶a ãĩbemarã bãrã tãẽna panʌ itea. Mʌ̃ra bãrã Ãcõrẽa.”– ");
INSERT INTO empNTpo_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Idjab̶a Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","25","–Israelerãa nãwã jaradua: “Poaza sietebema jed̶ecod̶e dji nabema ewarid̶e bãrãba ʌ̃nãũbada ewarida wagad̶ida panʌa. Bãrãra trajad̶acara panʌa. Maʌ̃ ewarid̶e bãrãba cachiruda zad̶aped̶a ãbaa dji jʌred̶ida panʌa mʌ̃́a bia bed̶ead̶i carea. Idjab̶a animarãda mʌ̃́a babue diabid̶ida panʌa.”– ");
INSERT INTO empNTpo_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Idjab̶a Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","–Poaza sietebema jed̶ecod̶e die ewari b̶ʌd̶e mʌ̃a cadjirua quĩrãdoabari ewarida bãrãba od̶ida panʌa. Maʌ̃ ewarid̶e bãrãra ne cod̶acara panʌa, ãbaa dji jʌred̶ida panʌa mʌ̃́a bia bed̶ead̶i carea, idjab̶a animarãda mʌ̃́a babue diabid̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Maʌ̃ ewarira mʌ̃a cadjirua quĩrãdoabari ewari bẽrã bãrãra trajad̶acara panʌa. Maʌ̃ ewarid̶e sacerdoteba oya bãrãba cadjirua oped̶ad̶ara mʌ̃a quĩrãdoamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Maʌ̃ ewarid̶e bariduaba ne cod̶aca ewarida oẽ́bʌrʌ, idjira bãrã tãẽnabemada ãyã jʌretad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Idjab̶a bariduaba trajuda maʌ̃ ewarid̶e oibʌrʌ, maʌ̃ ẽberãra mʌ̃a beubiya. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Maʌ̃ ewarid̶e bãrãra ni maãrĩ bid̶a trajad̶acara panʌa. Id̶iba ʌ̃taa bãrã panane wãbʌdaza bãrãba, bãrã warrarãneba yõbʌdarã bid̶a maʌ̃ bed̶eara ĩjã od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Maʌ̃ ewarira bãrã ʌ̃nãũbada ewari dromaa. Maʌ̃ ewarid̶e bãrãra ne cod̶acara panʌa. Maʌ̃ ʌ̃nãũbada ewarira wagad̶ida panʌa poaza sietebema jed̶ecod̶e nueve ewari queud̶ad̶eba ab̶a nurẽma queubʌrʌd̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Idjab̶a Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","–Israelerãa nãwã jaradua: “Poaza sietebema jed̶ecod̶e quince ewarid̶eba ʌ̃taa siete ewari warrewarreabema de zaqued̶e pananida panʌa mʌ̃́a bia bed̶ead̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Dji nabema ewarid̶e bãrãra ãbaa dji jʌred̶ida panʌa mʌ̃́a bia bed̶ead̶i carea. Maʌ̃ ewarid̶e bãrãra trajad̶acara panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Maʌ̃ siete ewarid̶e animarãda mʌ̃́a ewariza babue diabid̶ida panʌa. Maʌ̃ siete ewari jõnacarea nurẽma bãrãra wayacusa ãbaa dji jʌred̶ida panʌa mʌ̃́a bia bed̶ead̶i carea. Idjab̶a maʌ̃ ewarid̶e bãrãba mʌ̃́a animarãda babue diabid̶ida panʌa. Maʌ̃ ewarira mʌ̃ itea waga panʌ bẽrã bãrãra trajad̶acara panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Jũma mʌ̃a jarad̶a ewari droma b̶eara bãrãba od̶ida panʌa. Maʌ̃ ewari b̶ead̶e bãrãra ãbaa dji jʌred̶ida panʌa mʌ̃́a bia bed̶ead̶i carea idjab̶a mʌ̃́a animarãda babue diabid̶i carea. Ewariza mʌ̃a jarad̶a quĩrãca bãrãba animarã b̶eada babue diabid̶ida panʌa, bãrã néud̶ebemada diabid̶ida panʌa, mʌ̃ ume necai b̶ead̶i carea animarã b̶eada babue diabid̶ida panʌa, idjab̶a uva b̶ada wea diabid̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Domiazabema ʌ̃nãũbada ewari awara mʌ̃a jarad̶a ewari droma b̶eara bãrãba od̶ida panʌa. Bãrãba ewariza mʌ̃́a diad̶ida panʌ awara, sod̶eba mʌ̃́a dia panʌ awara, mʌ̃́a diad̶ida jaraped̶ad̶a awara, mʌ̃a jarad̶a ewari droma b̶ead̶e diabi b̶ʌra diad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Bãrã néu jũma ewaped̶ad̶acarea siete ewari bãrãra warrewarreabema de zaqued̶e panabada ewarida od̶ida panʌa mʌ̃́a bia bed̶ead̶i carea. Maʌ̃ ewarira od̶ida panʌa poaza sietebema jed̶ecod̶e quince ewarid̶eba ʌ̃taa. Dji nabema ewarid̶e bãrãba ʌ̃nãũbada ewarida wagad̶ida panʌa. Idjab̶a maʌ̃ siete ewari jõnacarea nurẽma bãrãba ʌ̃nãũbada ewarida wagad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Dji nabema ewarid̶e bãrãba dji biara b̶ea nejõda, uruta queduaca b̶eada, bacuru jʌwate quedua bara b̶eada, do icawabema bacuru jʌwate quedua bara b̶ea sid̶a edad̶ida panʌa. Maʌ̃be siete ewari bãrãra mʌ̃ quĩrãpita b̶ʌsrid̶a duananida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Poaza sietebema jed̶ecod̶e bãrãba maʌ̃ ewari dromada siete ewari od̶ida panʌa mʌ̃́a bia bed̶ead̶i carea. Id̶iba ʌ̃taa bãrãba, bãrã warrarãneba yõbʌdarã bid̶a naʌ̃ bed̶eara ĩjã od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Maʌ̃ siete ewari droma o panʌne jũma bãrã israelerãra warrewarreabema de zaqued̶e pananida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Mãwã bãrã warrarãneba yõbʌdarãba cawad̶ia bãrãra warrewarreabema de zaqued̶e panabadjid̶ada mʌ̃a bãrãra Egiptod̶eba ẽdrʌ enesid̶e. Mʌ̃ra bãrã Ãcõrẽa.”– ");
INSERT INTO empNTpo_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ãcõrẽba mãwã jarad̶acarea Moiseba israelerãa jarasia jũma Ãcõrẽba jarad̶a ewari droma b̶ea od̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","–Israelerãa jaradua olivo draga idji awa quiruda bʌmaa enenamãrẽã. Maʌ̃ olivo dragaba mʌ̃ ded̶e ĩbĩrãra quewaraza coad̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Mʌ̃ ded̶e eatʌ jira b̶ʌ wua nocoare Aaroʌ̃ba ĩbĩrãra quewaraza coa b̶ʌya urua b̶amãrẽã ab̶a ʌ̃nadrʌbʌrʌd̶aa. Id̶iba ʌ̃taa bãrãneba yõbʌdarãba naʌ̃ bed̶eara ĩjã od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Ĩbĩrã b̶ʌbada oro idji awa quiru od̶a jʌwateza ĩbĩrãra mʌ̃ quĩrãpita quewaraza coad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Dji biara b̶ʌ harinada edad̶aped̶a paʌ̃ra doce ãbud̶adua. Paʌ̃za harinara eped̶eco jũgurua umé b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Maʌ̃ paʌ̃ra mesa oro idji awa quiru od̶ad̶e Ãcõrẽ quĩrãpita errecama umé b̶ʌd̶adua. Errecamaza sei paʌ̃ b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Errecamaza orrocawa incienso quera idji awa quiruda cob̶ʌd̶adua. Maʌ̃ querara dji paʌ̃ cacuabari Ãcõrẽa bá diaya. Maʌ̃ quera bá diabʌrʌba acʌbiya paʌ̃ra jũma Ãcõrẽa dia b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Ʌ̃nãũbada ewariza paʌ̃ djiwid̶ida Ãcõrẽ quĩrãpita b̶ʌd̶ida panʌa. Ãcõrẽra israelerã ume bed̶ea b̶ʌd̶a bẽrã id̶iba ʌ̃taa mãwã od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Maʌ̃ paʌ̃ cacuabari querara Ãcõrẽa bá diai bẽrã jũma maʌ̃ paʌ̃ra Ãcõrẽ itea b̶eya. Maʌ̃ bẽrã ab̶abe Aaroʌ̃ba, idji warrarã bid̶a arima cod̶ida panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Ẽberãda b̶asia. Dji papara Israeld̶ebema basía baribʌrʌ dji zezara Egiptod̶ebema basía. Ewari ab̶a maʌ̃ ẽberãra israelerã tãẽna pʌrrʌad̶e wãsia. Pʌrrʌa nĩne idjira ẽberã Israeld̶ebema ume djõsia. ");
INSERT INTO empNTpo_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Djõ panʌne idjia Ãcõrẽda biẽ́ jarasia. Maʌ̃ carea israelerãba idjira Moisemaa edesid̶aa cawa omãrẽã. Maʌ̃ ẽberã papara Daʌ̃neba yõna Dibri cau Selomí basía. ");
INSERT INTO empNTpo_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Maʌ̃ ẽberãra jida eropanesid̶aa ab̶a Ãcõrẽba cawabibʌrʌd̶aa sãwã od̶ida panʌda. ");
INSERT INTO empNTpo_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Maʌ̃ne Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","–Jãʌ̃ ẽberã mʌ̃ biẽ́ jarad̶ara bãrã duanʌmaʌba ãyã eded̶adua. Jũma idjia mʌ̃ biẽ́ jara b̶ʌ ũrĩped̶ad̶aba ãdji jʌwara idji boro ʌ̃rʌ̃ b̶ʌd̶ida panʌa acʌbid̶i carea wãrãda bed̶ead̶e b̶ʌda. Mãwãnacarea jũmarãba idjira mõgaraba tab̶ari bead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Israelerãa nãwã jaradua: “Bariduaba mʌ̃da biẽ́ jaraibʌrʌ, idjira bed̶ead̶e b̶ʌ bẽrã beuida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Maʌ̃ bẽrã jũma bãrãba idjira mõgaraba tab̶ari bead̶ida panʌa. Mʌ̃ biẽ́ jarad̶ada Israeld̶ebema baibʌrʌ wa ãĩbema baibʌrʌ, idjira bead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Ab̶aʌda mĩã beaibʌrʌ, idji sid̶a bead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Ab̶aʌba djãrã animarãda beaibʌrʌ, maʌ̃ animarã bead̶abari ab̶arica animarãda djibaría diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Ab̶aʌba djãrãda puoibʌrʌ, ara idjia puod̶a quĩrãca idji sid̶a puod̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Djãrã b̶ʌwʌrʌda b̶ʌasira, idji b̶ʌwʌrʌ sid̶a b̶ʌad̶ida panʌa. Djãrã dauda ãrĩsira, idji dau sid̶a ãrĩnida panʌa. Djãrã quid̶ada b̶ʌasira, idji quid̶a sid̶a b̶ʌad̶ida panʌa. Ara idjia djãrã puod̶a quĩrãca idji sid̶a puod̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Ab̶aʌba djãrã animarãda beaibʌrʌ, maʌ̃ animarã cacuabari ab̶arica animarãda djibaría diaida b̶ʌa. Baribʌrʌ mĩã beaibʌrʌ, idjira bead̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Dji puod̶ara Israeld̶ebema baibʌrʌ wa ãĩbema baibʌrʌ, ab̶arica od̶ida panʌa. Mʌ̃ra bãrã Ãcõrẽa.”– ");
INSERT INTO empNTpo_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Moiseba jũma maʌ̃gʌra israelerãa jarasia. Mãwã jarad̶acarea ãdjirãba dji Ãcõrẽ biẽ́ jarad̶ara ãyã eded̶aped̶a mõgaraba tab̶ari beasid̶aa Ãcõrẽba Moisea jarad̶a quĩrãca.");
INSERT INTO empNTpo_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","–Israelerãa nãwã jaradua: Umaquĩrãba wa wẽrãba ara idjida Ãcõrẽ itea b̶eyad̶a aibʌrʌ, maʌ̃ ewarid̶eba ʌ̃taa idjira nazareo ad̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","Maʌ̃ bẽrã idjia uva b̶a aseada, baridua b̶a aseada, uva b̶a oregueada, baridua b̶a asea oreguea od̶ada, uva b̶a cũã sid̶a docara b̶ʌa. Idjab̶a uvada, uva besead̶e paed̶a sid̶a cocara b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Idji nazareo b̶eyad̶a ad̶a ewarid̶eba ab̶a idji ẽdrʌi jarad̶a ewarid̶aa ne jũma uva bara b̶ʌda cocara b̶ʌa. Uva tada, dji e sid̶a cocara b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Maʌ̃ awara Ãcõrẽ itea b̶eyad̶a ad̶a ewarid̶eba ab̶a idji ẽdrʌi jarad̶a ewarid̶aa idji bud̶ara tʌcara b̶ʌa. Maʌ̃ ewarid̶e idjira Ãcõrẽ itea b̶ʌ bẽrã idji bud̶ara idu urea zebida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Idjab̶a Ãcõrẽ itea b̶eyad̶a ad̶a ewarid̶eba ab̶a idji ẽdrʌi jarad̶a ewarid̶aa ẽberã jaid̶ad̶a caita wãcara b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Dji zezada, dji papada, dji djabada, dji djabawẽrã sid̶a jaid̶asira dji bẽwãrã caita wãcara b̶ʌa Ãcõrẽ quĩrãpita biẽ́ b̶e amaaba. Maʌ̃ ewarid̶e idji bud̶ara Ãcõrẽ itea urea erob̶ʌ bẽrã Ãcõrẽ quĩrãpita bia b̶eida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Ãcõrẽ itea b̶eyad̶a ad̶a ewarid̶eba ab̶a idji ẽdrʌi jarad̶a ewarid̶aa idjira Ãcõrẽ itea bia b̶aida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Cawaẽ́ne ẽberãda idji caita beuibʌrʌ, idji bud̶a Ãcõrẽ itea urea erob̶ʌra Ãcõrẽ quĩrãpita biẽ́ b̶eya. Maʌ̃ bẽrã idjira Ãcõrẽ quĩrãpita wayacusa bia b̶ei ewarid̶e borob̶ichia tʌida b̶ʌa. Mãwã oya sietebema ewarid̶e. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Nurẽma puchirãda wa putujuda umé sacerdotea diad̶e wãida b̶ʌa Ãcõrẽ wua ded̶e ed̶a wãbadamaa. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Maʌ̃be sacerdoteba ab̶a Ãcõrẽa bea diaida b̶ʌa maʌ̃ ẽberãba cadjirua od̶a carea. Dewarabemara Ãcõrẽa jũma babue diaida b̶ʌa. Mãwã Ãcõrẽba maʌ̃ cadjiruara quĩrãdoaya. Maʌ̃ ẽberãba cadjiruada osia ẽberã beud̶a caita b̶ad̶a bẽrã. Maʌ̃ ewarid̶eba ʌ̃taa idji bud̶ara Ãcõrẽ itea idu urea zebida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Maʌ̃ ewarid̶e oveja dji umaquĩrã poa ab̶a b̶ʌda babue diabida b̶ʌa idji biẽ́ b̶ed̶a carea. Maʌ̃ ewarid̶eba ʌ̃taa idjira wayacusa Ãcõrẽ itea b̶eida b̶ʌa ara idjia naẽna ewari jara b̶ʌd̶a quĩrãca. Naẽna idjia Ãcõrẽ itea b̶ei jarad̶a ewari o b̶asid̶e Ãcõrẽ ume biẽ́ b̶ed̶a bẽrã, maʌ̃ ewarira juachaiẽ́ b̶ʌa Ãcõrẽ itea b̶ei jarad̶a ewari jũma daucha oi carea. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Ãcõrẽ itea b̶eyad̶a ad̶a ewari jõnacarea nazareoba nãwã oida b̶ʌa: Ãcõrẽ wua ded̶e ed̶a wãbadamaa wãida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Mama oveja dji umaquĩrãda poa ab̶a b̶ʌda sacerdotea diaida b̶ʌa Ãcõrẽa jũma babue diamãrẽã. Maʌ̃ ovejara jũma bia b̶aida b̶ʌa. Maʌ̃ awara idjia cadjirua od̶a carea oveja wẽrãda poa ab̶a b̶ʌda sacerdotea diaida b̶ʌa dji dragara Ãcõrẽa babue diamãrẽã. Maʌ̃ oveja sid̶a jũma bia b̶aida b̶ʌa. Idjab̶a Ãcõrẽ ume necai b̶ai carea oveja dji umaquĩrãda sacerdotea diaida b̶ʌa dji dragara babue diamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Néud̶ebema sid̶a sacerdotea diaida b̶ʌa Ãcõrẽa diamãrẽã. Uva b̶a sid̶a diaida b̶ʌa Ãcõrẽa wea diamãrẽã. Maʌ̃ awara paʌ̃ ẽsãbari neẽ́ b̶ʌda jamara ab̶a diaida b̶ʌa. Maʌ̃ paʌ̃ra quĩrã cacua umé b̶aida b̶ʌa: ab̶a dji biara b̶ʌ harina nedraga bara od̶aa, dewarabemara nedragaba ʌ̃rʌ̃ pʌrʌd̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Sacerdoteba dji oveja wẽrã dragada Ãcõrẽa babue diaya nazareoba cadjirua od̶a carea. Oveja dji umaquĩrãda Ãcõrẽa jũma babue diaya. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Maʌ̃are Ãcõrẽ ume necai b̶ai careabema oveja dragada babue diaya. Maʌ̃ babue diabʌrʌd̶e jamarad̶e b̶ʌ paʌ̃ ẽsãbari neẽ́ b̶ʌda, néud̶ebema sid̶a Ãcõrẽa diaya. Idjab̶a uva b̶ada Ãcõrẽa wea diaya. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Maʌ̃be Ãcõrẽ wua ded̶e ed̶a wãbada caita nazareora borob̶ichia tʌped̶a idji bud̶a Ãcõrẽ itea idu ureabi b̶ad̶ara babueida b̶ʌa Ãcõrẽ ume necai b̶ai careabema oveja djara dju panʌ tʌbʌd̶e. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Borob̶ichia tʌd̶acarea sacerdoteba oveja jĩrũ nocoarebema djud̶ada nazareo jʌwad̶e b̶ʌya. Idjab̶a jamarad̶e b̶ʌ paʌ̃ ẽsãbari neẽ́ b̶ʌda umé edaped̶a maʌ̃ sid̶a idji jʌwad̶e b̶ʌya: ab̶a nedraga bara od̶ada idjab̶a ab̶a nedragaba ʌ̃rʌ̃ pʌrʌd̶ada. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Maʌ̃be sacerdoteba jũma maʌ̃gʌra Ãcõrẽ quĩrãpita ʌ̃taa waida b̶ʌa diai carea. Mãwã jũma maʌ̃gʌra Ãcõrẽ itea b̶ed̶a bẽrã sacerdoteba edaida b̶ʌa. Maʌ̃ awara oveja jã nocoarebema djara Ãcõrẽ quĩrãpita ʌ̃taa wad̶ada, chĩde ʌ̃taa wad̶a sid̶a idji itea b̶eya. Jũma mãwã od̶acarea nazareo bad̶aba uva b̶ada doida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Jũma maʌ̃gʌra Ãcõrẽ ley nazareod̶ebemaa. Ãcõrẽ itea b̶ad̶ada ẽdrʌbʌrʌd̶e maʌ̃ leyba jara b̶ʌ quĩrãca jũma diaida b̶ʌa. Maʌ̃ awara idjia Ãcõrẽ itea b̶eyad̶a ad̶a ewarid̶e aud̶u poya diayad̶a asibʌrʌ, ẽdrʌbʌrʌd̶e idjia jarad̶a quĩrãca jũma diaida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","–Aaroʌ̃a, idji warrarãa bid̶a jaradua nãwã israelerã bia jara b̶ʌd̶amãrẽã: ");
INSERT INTO empNTpo_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Ãcõrẽba bãrãra carebaya idjab̶a wagaya. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ãcõrẽba bãrãra bia unu b̶aya idjab̶a idji biad̶eba bia erob̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Ãcõrẽba bãrãra quĩrĩã b̶aya idjab̶a necai b̶ʌya. ");
INSERT INTO empNTpo_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Aaroʌ̃ba, idji warrarã bid̶a mʌ̃ trʌ̃neba israelerãra mãwã bia jara b̶ʌd̶ibʌrʌ, mʌ̃a wãrãda carebaya.– ");
INSERT INTO empNTpo_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","–Paratada edad̶aped̶a cachiruda umé chĩ od̶ad̶ua. Maʌ̃ cachirura zad̶ia puru ãbaa trʌ̃ni carea idjab̶a nocod̶aa wãbid̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Cachiru umena dãrã jĩguabʌrʌd̶e puruda jũmaena bʌ ume ãbaa dji jʌred̶ida panʌa mʌ̃ wua ded̶e ed̶a wãbadama. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Cachiru ab̶a dãrã jĩguabʌrʌd̶e israelerã bororã awa bʌ ume ãbaa dji jʌred̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Cachiru ara pichia jĩguabʌrʌd̶e israelerã ʌ̃mãdau odjabariare duanʌra nocod̶aa wãnida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Wayacusa ara maʌ̃ quĩrãca jĩguabʌrʌd̶e israelerã jʌwa acʌare duanʌra wãnida panʌa. Ara maʌ̃ quĩrãca jĩguabʌrʌd̶e israelerã jʌwa araare duanʌra, ʌ̃mãdau b̶aebariare duanʌ sid̶a wãnida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Israelerã ãbaa dji jʌred̶amãrẽã cachirura dãrã zad̶adua. Nocod̶aa wãnamãrẽã quĩrã awara zad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Aaroʌ̃ warrarã sacerdoterãba maʌ̃ cachirura zad̶ida panʌa. Id̶iba ʌ̃taa ãdjirãba, ãdji warrarãneba yõbʌdarã bid̶a mãwã od̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Bãrã druad̶e jũẽped̶ad̶acarea dji quĩrũda bãrã ume djõne zesid̶ara, bãrã djõne wãbʌdad̶e cachirura zad̶adua. Mãwã mʌ̃a bãrãra quĩrãdoaẽ́a ãtebʌrʌ dji quĩrũnebemada ẽdrʌ edaya. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Maʌ̃ awara mʌ̃a jarad̶a ewari droma b̶ea b̶ʌsrid̶aba obʌdad̶e, jed̶eco djiwid̶i ewari obʌdad̶e bid̶a cachirura zad̶adua. Animarã babue diabʌdad̶e, mʌ̃ ume necai b̶ai careabema animarã beabʌdad̶e bid̶a cachirura zad̶adua. Maʌ̃ zabʌdaba mʌ̃́a bãrãnebemada quĩrãnebabi b̶aya. Mʌ̃ra bãrã Ãcõrẽa. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Israelerã Egiptod̶eba ẽdrʌped̶ad̶acarea poa ab̶a ʌ̃rʌ̃ jed̶eco umé veinte ewari b̶ʌd̶e jʌ̃rãrã Ãcõrẽ wua de ʌ̃rʌ̃ b̶ad̶ara nocod̶aa wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Ara maʌ̃da israelerãra Sinai ẽjũã põãsa ewaraga b̶ʌd̶eba maʌ̃ jʌ̃rãrã caid̶u wãsid̶aa. Ʌ̃nãũ eda wãbʌdad̶e Paraʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶e jũẽne wãsid̶aa. Mama jʌ̃rãrãra jira b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Sinaid̶eba ẽdrʌsid̶ad̶e israelerãra wãbʌrʌsid̶aa Ãcõrẽba Moisea jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Naãrã Judad̶eba yõna puruda ãdji bandera bara wãsia. Ãdji borora Aminadá warra Naasoʌ̃ basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Ãdjirã ume Isacard̶eba yõna puruda wãsia. Ãdji borora Zuá warra Natanael basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Idjab̶a Zabuloʌ̃neba yõna puru sid̶a ãdjirã ume wãsia. Ãdji borora Heloʌ̃ warra Eliá basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Maʌ̃ ũbeaare Levi warra Gersoʌ̃neba yõped̶ad̶arãba, Levi warra Merarid̶eba yõped̶ad̶arã bid̶a Ãcõrẽ wua deda jũma ẽrãcuad̶aped̶a edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ãdjirãare Rubeʌ̃neba yõna puruda ãdji bandera bara wãsia. Ãdji borora Sedeu warra Elisu basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Ãdjirã ume Simeoʌ̃neba yõna puruda wãsia. Ãdji borora Zurisadai warra Selumiel basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Idjab̶a Gad̶eba yõna puru sid̶a ãdjirã ume wãsia. Ãdji borora Deuel warra Eliasa basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Maʌ̃ ũbeaare Levi warra Coád̶eba yõped̶ad̶arãba Ãcõrẽ wua ded̶e ed̶abemada jũma edesid̶aa. Ãdji cãĩnima jũẽbʌdad̶e Ãcõrẽ wua de naẽna edeped̶ad̶aba maʌ̃ dera o eropanabadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ãdjirãare Epraiʌ̃neba yõna puruda ãdji bandera bara wãsia. Ãdji borora Amiú warra Elisamá basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Ãdjirã ume Manased̶eba yõna puruda wãsia. Ãdji borora Pedasu warra Gamaliel basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Idjab̶a Benjamiʌ̃neba yõna puru sid̶a ãdjirã ume wãsia. Ãdjirã borora Gedeoni warra Abidaʌ̃ basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Jĩrũare Daʌ̃neba yõna puruda ãdji bandera bara wãsia. Ãdjirãra panasid̶aa dji quĩrũba ẽpẽsid̶ara maʌ̃ ẽberãrã ume djõni carea. Ãdji borora Amisadai warra Ajieze basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Ãdjirã ume Aserd̶eba yõna puruda wãsia. Ãdji borora Ocraʌ̃ warra Pagiel basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Idjab̶a Neptalid̶eba yõna puru sid̶a ãdjirã ume wãsia. Ãdji borora Enaʌ̃ warra Ahira basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Israelerã nocod̶aa wãbʌdaza ara maʌ̃ quĩrãca wãbadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Israelerã Sinaid̶eba ẽdrʌd̶i naẽna Moisera Hobá ume bed̶easia. Hobára Moise zãwãrẽ Reuel warra basía. Madiaʌ̃ druad̶ebema basía. Moiseba Hobáa jarasia: –Dairãra wãbʌrʌd̶ia Ãcõrẽba diai jarad̶a druad̶aa. Dairã ume wãdua. Ãcõrẽba dai israelerãa ne biada diayad̶a asia. Maʌ̃ bẽrã dairãba bʌ́a ne biada waib̶ʌa diad̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobába panusia: –Mʌ̃ra wãẽ́a. Mʌ̃ druad̶aa jẽda wãya mʌ̃ ẽberãrãmaa.– ");
INSERT INTO empNTpo_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Maʌ̃ne Moiseba jarasia: –Mʌ̃ quĩrã djuburia jẽda wãrãdua. Bʌa bio cawa b̶ʌa sãma ẽjũã põãsa ewaraga b̶ʌd̶e dairãra cãĩnida panʌda. Bʌa dairãra poya jipa pe edeya. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Bʌda dairã ume wãibʌrʌ, ne jũma bia Ãcõrẽba dairãa diabʌrʌd̶ebemada bʌ́a diad̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Mãwã bed̶ead̶acarea israelerãra Sinai eya Ãcõrẽ eya abadad̶eba wãsid̶aa. Ewari ũbea nĩbasid̶aa. Mãwã nĩnane Ãcõrẽ baurudera ãdjirã na eronĩbasid̶aa cawabimãrẽã sãma ʌ̃nãũnida. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ãsa israelerã nocod̶aa wãbʌdad̶e Ãcõrẽ jʌ̃rãrãra ãdjirã ʌ̃rʌ̃ wãbadjia. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Ãcõrẽ baurude nocod̶aa edebʌdaza Moiseba nãwã jarabadjia: Ãcõrẽ, na wãdua. Bʌ ume dji quĩrũra ãyã jʌrecuadua. Bʌ quĩrĩãnacara ãyã mĩrũ wãbicuadua. ");
INSERT INTO empNTpo_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ãcõrẽ baurude ãdji cãĩnima jũẽbibʌdad̶e Moiseba nãwã jarabadjia: Ãcõrẽ, jẽda zedua dai israelerã zocãrã duanʌmaa. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Mãwã nĩnane israelerãra ãdji bia mĩga panʌ carea Ãcõrẽ quĩrãpita biẽ́ bed̶ea duanesid̶aa. Maʌ̃ ũrĩsid̶e Ãcõrẽra quĩrũped̶a tʌbʌ uruada ãdjirãmaa eradrʌbisia. Maʌ̃ tʌbʌ uruaba puru iquid̶abema deda ʌ̃cʌrʌ bácuasia. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Maʌ̃ carea israelerãba Moisea quĩrã djuburiada iwid̶isid̶aa. Ara maʌ̃da Moiseba ãdjirã carea Ãcõrẽa bed̶ea djuburiabʌrʌd̶e tʌbʌ uruara quisia. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Mama trʌ̃ b̶ʌsid̶aa Taberá, Ãcõrẽba tʌbʌ uruada ãdjirã tãẽna eradrʌbid̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Ʌ̃cʌrʌ ãĩbemarã israelerã ume nĩnaba ãdjia co panʌ awara dewara djicoda co quĩrĩã panasid̶aa. Maʌ̃ bẽrã israelerã sid̶a sod̶e biẽ́ panenaped̶a nãwã jarasid̶aa: –¡Ay, nedjarada cobʌdabara! ");
INSERT INTO empNTpo_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Dadjirãba quĩrãneba panʌa Egiptod̶e b̶edada bari co panabadjid̶ada. Idjab̶a pepinoda, nejõda, ceboyada, puerroda, recao sid̶a co panabadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Baribʌrʌ id̶ira ab̶ari co panʌba sẽ panʌa. Ab̶abe naʌ̃ manádrʌ co tapanʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manára culãdrʌ ta quĩrãca pichia querasia. Bedelio quĩrãca torroa cuaracuara b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Diamasiza ẽjũã cũrãsaba b̶eguea nũmebʌrʌd̶e manára odjabadjia. Israelerãba manára jʌrʌ ped̶aped̶a birajubadjid̶aa wa yud̶e ʌrab̶abadjid̶aa. Maʌ̃gʌra djubadjid̶aa wa paʌ̃da obadjid̶aa. Dji warraara paʌ̃ olivo dragad̶aa od̶aca b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Maʌ̃ne Moiseba ũrĩsia deza dji ed̶a wãbadama israelerãra ãdjia co quĩrĩã panʌ carea jĩã panʌda. Maʌ̃ carea Ãcõrẽra ãdjirã ume bio quĩrũsia. Moise bid̶a maʌ̃ra biẽ́ unusia. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Maʌ̃ carea Moiseba Ãcõrẽa jarasia: –Mʌ̃ra bʌ nezocaa. Maʌ̃da ¿cãrẽ cãrẽã bʌa mʌ̃ra jãwã biẽ́ o b̶ʌ? ¿Mʌ̃a cãrẽda bʌ quĩrãpita biẽ́ od̶a bẽrã bʌa jãwã naʌ̃ purura mʌ̃ jʌwad̶e b̶ʌsi? ");
INSERT INTO empNTpo_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","¿Mʌ̃ra ãdji papaca? ¿Mʌ̃abʌrʌ ãdjirãra tocuasica? Mãwãra ¿cãrẽ cãrẽã jara b̶ʌ ãdjirãra bʌa ãdji drõã naẽnabemarãa diai jarad̶a druad̶aa edemãrẽã daupẽbariba warra jʌwad̶e bara edebari quĩrãca? ");
INSERT INTO empNTpo_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Naʌ̃ ẽberãrã jĩã panʌba mʌ̃́a jara panʌa: “Dairãa nedjarada cod̶i carea diadua.” Baribʌrʌ mʌ̃a ¿sãma nedjarada edai ãdjirãa diai carea? ");
INSERT INTO empNTpo_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Mʌ̃dub̶aʌba naʌ̃ purura poya edeẽ́a. Mãwã edeira jũmawãyã zarea b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Bʌa naʌ̃ puruda mʌ̃dub̶aʌa edebibʌrʌ biara b̶ʌa mʌ̃ra beaida. Bʌa wãrãda mʌ̃da bia unu b̶ʌbʌrʌ, mʌ̃ra beadua waa bia mĩgarãmãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Ãcõrẽba panusia: –Israelerã bororã bʌa bio cawa b̶ʌda setenta edaped̶a mʌ̃ wua de caita ededua. Mama bʌ ume jʌ̃ãnida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Maʌ̃ne mʌ̃ra mama ed̶aa zeped̶a bʌ ume bed̶eaya. Mʌ̃a bʌ́a diad̶a Jaureda ãdjirãa bid̶a diaya naʌ̃ puruda careba eded̶amãrẽã. Mãwã bʌdub̶aʌba naʌ̃ purura edeẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Israelerãa jaradua nedjarada nu cod̶i bẽrã nane ãdjirãba od̶ida panʌa nu mʌ̃ quĩrãpita bia duanani carea. Mʌ̃a ũrĩsia ãdjirã jĩã panʌba nãwã jara panʌda: “¡Ay, nedjarada cobʌdabara! ¡Dadjirãra Egiptod̶e biara duanabadjid̶aa!” Mãwã jara panʌ bẽrã mʌ̃a ãdjirãa nedjarada diaya cod̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","20","Maʌ̃ nedjarara ãdjirãba ewari ab̶abe, ewari umé, ewari juesuma, die ewari, veinte ewari bid̶a cod̶aẽ́a, ãtebʌrʌ jed̶eco ab̶a cod̶ia ab̶a nedjaraba jaitabʌdad̶aa. Mãwã oya mʌ̃ra bãrã ume b̶ʌmĩna. Ãdjirãba mʌ̃da igarad̶aped̶a jĩã panʌba mʌ̃ quĩrãpita nãwã jara panʌa: “¿Dadjirãra cãrẽ cãrẽã Egiptod̶eba ẽdrʌsid̶a?”– ");
INSERT INTO empNTpo_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Moiseba jarasia: –Umaquĩrãrã awa mʌ̃ ume seisciento mil panʌa. Maʌ̃da bʌa jara b̶ʌa jed̶eco ab̶a nedjarada dairãba cod̶amãrẽã diaida. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Dai ovejada, pacada jũma beabʌda sid̶a jũmarã itea araẽ́a. ¡Pusad̶ebema b̶eda jũma beabʌda sid̶a araẽ́a!– ");
INSERT INTO empNTpo_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Ãcõrẽba Moisea jarasia: –¿Mʌ̃a jũma poya oẽ́ca? Id̶i bʌa unuya mʌ̃a jarad̶ara poya oida wa poya oẽ́da.– ");
INSERT INTO empNTpo_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Ãcõrẽ ume bed̶ea b̶ad̶ara Moiseba israelerãa jarad̶e wãsia. Maʌ̃ne israelerã bororãda setenta edaped̶a Ãcõrẽ wua de caita pe edesia. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Mama Ãcõrẽra jʌ̃rãrãne ed̶aa zeped̶a Moise ume bed̶easia. Idjia Moisea diad̶a Jaureda maʌ̃ setenta israelerã bororãa bid̶a diasia. Maʌ̃ Jaurera ãdjirãmaa zeped̶a cawaẽ́ne Ãcõrẽneba bed̶ea duanesid̶aa. Mãwãnacarea waa ara maʌ̃ quĩrãca bed̶ead̶aẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Maʌ̃ne Moiseba setenta bororã edad̶ad̶ebemada umé Ãcõrẽ wua demaa wãnaẽ́ basía, ãtebʌrʌ israelerã duanʌma panesid̶aa. Ab̶ara Eldá basía. Dewarabemara Medá basía. Ãcõrẽ wua demaa wãnaẽ́ bad̶amĩna Ãcõrẽba diad̶a Jaurera ãdjia bid̶a edasid̶aa. Maʌ̃ bẽrã ãdji sid̶a cawaẽ́ne Ãcõrẽneba bed̶ea panesid̶aa israelerã duanʌma. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Maʌ̃ carea cũdra ab̶a Moisemaa pira wãped̶a nãwã jarasia: –¡Eldáda, Medá sid̶a Ãcõrẽneba bed̶ea panʌa israelerã duanʌma!– ");
INSERT INTO empNTpo_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Maʌ̃ne Nuʌ̃ warra Josueba jarasia: –Mʌ̃ boro Moise, ãdjía idu mãwã bed̶eabirãdua.– (Josuera cũdra ed̶aʌba Moise carebabari basía.) ");
INSERT INTO empNTpo_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Moiseba jarasia: –¿Bʌa crĩcha b̶ʌca ab̶abe mʌ̃abʌrʌ Ãcõrẽ Jaurera erob̶aida b̶ʌda? Mʌ̃maarã bia b̶acasia Ãcõrẽba idji Jaureda jũmarãa diabʌrʌbara idjab̶a jũmarãda idjid̶eba bed̶eabʌdabara.– ");
INSERT INTO empNTpo_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Mãwãnacarea Moisera, israelerã bororã sid̶a jẽda wãsid̶aa israelerã duanʌmaa. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Maʌ̃be Ãcõrẽba nãũrãda pusaareba tʌbisia. Maʌ̃ nãũrãba põrãda zocãrã enesia israelerã duanʌmaa. Israelerã duanʌmaʌba ewari ab̶a wãida b̶ʌ quĩrãca maʌ̃ põrãra jewed̶a jãrẽb̶aribusi b̶asia. Egorod̶eba dji ʌ̃tʌara dadji b̶acara daucha b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Maʌ̃ ewarid̶e ãsa, diamasi, nurẽma bid̶a israelerãba põrãra quenabadjid̶aa. Dji maãrĩara bead̶aba ẽda cincuenta birasia. Maʌ̃gʌra besead̶e pae duanasid̶aa ãdjirã duanʌma. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Maʌ̃ põrã djara jũma cod̶i naẽna Ãcõrẽra ãdjirã ume quĩrũsia. Maʌ̃ bẽrã israelerãra zocãrã quinibisia. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Dji zocai panenaba maná awara co quĩrĩã pananara joucuasid̶aa. Maʌ̃ carea maʌ̃ ẽjũãra trʌ̃ b̶ʌsid̶aa Kibro-hataava. ");
INSERT INTO empNTpo_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kibro-hataavad̶eba israelerãra Hazerod̶aa wãnaped̶a mama duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mariaba, Aaroʌ̃ bid̶a ãdji djaba Moiseda biẽ́ jara panesid̶aa ãĩbema wẽrã edad̶a carea. ");
INSERT INTO empNTpo_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ãdjia nãwã jarasid̶aa: –¿Ãcõrẽra ab̶abe Moised̶eba bed̶eabarica? ¿Dadjid̶eba bid̶a bed̶eacaca?– Mãwã bed̶ea panʌra Ãcõrẽba biẽ́ ũrĩsia. ( ");
INSERT INTO empNTpo_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Jũma naʌ̃ ẽjũãne Moisera dji dromaara b̶ai crĩchara neẽ́ b̶asia.) ");
INSERT INTO empNTpo_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Ara maʌ̃da Ãcõrẽba Moisea, Aaroʌ̃a, Mariaa bid̶a jarasia: –Bãrã ũbea mʌ̃ wua demaa zed̶adua.– Ara maʌ̃da wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Maʌ̃ne Ãcõrẽra jʌ̃rãrã ʌ̃tʌba ed̶aa drasoa jira b̶ʌd̶e ed̶aa zesia idji wua ded̶e ed̶a wãbadamaa. Mama Aaroʌ̃ra Maria sid̶a caitaara trʌ̃sia. Ara maʌ̃da caitaara wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Maʌ̃be Ãcõrẽba ãdjía jarasia: –Mʌ̃a jarabʌrʌda bio ũrĩnadua. Mʌ̃neba bed̶eabadarã bãrã tãẽna b̶ea ume mʌ̃ra cãĩmocarad̶eba idjab̶a cãĩmocara quĩrãca ne unubi b̶ʌd̶eba bed̶eabaria. ");
INSERT INTO empNTpo_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Baribʌrʌ mʌ̃ nezoca Moise ume mãwã bed̶eacaa. Jũma mʌ̃ ẽberãrã cãyãbara idjiabʌrʌ mʌ̃ra biara ĩjã b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Idji ume mʌ̃ra nẽbʌrʌbaria. Ne jara b̶ʌd̶eba idji ume bed̶eacaa. Ãtebʌrʌ ebud̶a jarabaria. Idjia mʌ̃ra unubaria. Mãwã b̶ʌ bẽrã ¿bãrãba cãrẽ cãrẽã wayad̶aẽ́ basi mʌ̃ nezoca Moisera biẽ́ jarad̶i carea?– ");
INSERT INTO empNTpo_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Ãcõrẽra ãdji ume bio quĩrũped̶a wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","11","Ãcõrẽ wua demaʌba jʌ̃rãrã ʌ̃taa wãbʌrʌd̶e Mariara aid̶aba bira nũmesia. Maʌ̃ unusid̶e Aaroʌ̃ba Moisea nãwã bed̶ea djuburiasia: –Mʌ̃ boro, mʌ̃ quĩrã djuburia daiba crĩchad̶aẽ́ne cadjirua oped̶ad̶ara quĩrãdoadua. ");
INSERT INTO empNTpo_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Maria cacuara idu jũma ãrĩ b̶ebirãdua warra ʌradʌgad̶a quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Ara maʌ̃da Moiseba Maria carea Ãcõrẽa quĩrã djuburiada nãwã iwid̶isia: –Ãcõrẽ, mʌ̃ quĩrã djuburia mʌ̃ djabawẽrã Mariara biabidua.– ");
INSERT INTO empNTpo_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Ãcõrẽba panusia: –Idji zezaba cawa obʌrʌd̶e idji quĩrãdarrad̶e id̶od̶abara, ¿siete ewari puru jĩga b̶ʌd̶aẽ́ bacasid̶aca quĩrã peramãrẽã? Ara maʌ̃ quĩrãca bãrãba idjira siete ewari puru jĩga b̶ʌd̶ida panʌa. Mãwãnacarea poya jẽda zeya. ");
INSERT INTO empNTpo_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Ara maʌ̃da israelerãba Mariara puru jĩga b̶ʌd̶e wãsid̶aa siete ewari mama b̶amãrẽã. Maʌ̃ siete ewarid̶e israelerãra nocod̶aa wãnaẽ́ basía ab̶a Maria jẽda zebʌrʌd̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Zed̶acarea Hazerod̶eba Paraʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶e jũẽne wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Maʌ̃be Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","–Ʌ̃cʌrʌ umaquĩrãrãda Canaaʌ̃ drua acʌd̶e diabuedua. Maʌ̃ druara mʌ̃a israelerãa diaya. Israeld̶eba yõna doce purud̶ebemada ab̶a ab̶a edadua diabuei carea. Ãdjira puru boroda b̶ead̶ida panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ara maʌ̃da Moiseba ʌ̃cʌrʌ umaquĩrãrãda Paraʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶eba Canaaʌ̃naa diabuesia Ãcõrẽba jarad̶a quĩrãca. Jũma ãdjirãra israelerã bororã basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Ãdjirãra naʌ̃gʌrã basía: Rubeʌ̃neba yõna purud̶ebema Zacu warra Samuada, ");
INSERT INTO empNTpo_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simeoʌ̃neba yõna purud̶ebema Hori warra Sapada, ");
INSERT INTO empNTpo_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Judad̶eba yõna purud̶ebema Jepone warra Caleda, ");
INSERT INTO empNTpo_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Isacard̶eba yõna purud̶ebema Jose warra Igalda, ");
INSERT INTO empNTpo_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Epraiʌ̃neba yõna purud̶ebema Nuʌ̃ warra Oseada, ");
INSERT INTO empNTpo_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Benjamiʌ̃neba yõna purud̶ebema Rapu warra Paltida, ");
INSERT INTO empNTpo_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zabuloʌ̃neba yõna purud̶ebema Sodi warra Gadielda, ");
INSERT INTO empNTpo_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Jose warra Manased̶eba yõna purud̶ebema Susi warra Gadida, ");
INSERT INTO empNTpo_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Daʌ̃neba yõna purud̶ebema Gemali warra Amielda, ");
INSERT INTO empNTpo_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Aserd̶eba yõna purud̶ebema Micael warra Setuda, ");
INSERT INTO empNTpo_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Neptalid̶eba yõna purud̶ebema Vapsi warra Nahbida, ");
INSERT INTO empNTpo_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","idjab̶a Gad̶eba yõna purud̶ebema Maqui warra Geuelda. ");
INSERT INTO empNTpo_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Moiseba Canaaʌ̃ drua acʌd̶e diabued̶arã trʌ̃ra maʌ̃gʌrã basía. (Nuʌ̃ warra Oseara Moiseba trʌ̃ b̶ʌsia Josue.) ");
INSERT INTO empNTpo_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moiseba maʌ̃ ẽberãrã Canaaʌ̃ drua acʌd̶e diabuesid̶e nãwã jarasia: –Negue ẽjũã põãsa ewaraga b̶ʌareba ẽjũã eyaid̶a b̶ʌd̶aa wãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Acʌd̶adua maʌ̃ druara sãwã b̶ʌda idjab̶a maʌ̃ druad̶ebemarãra sãwã b̶eada; mẽsrã b̶eada wa mẽsrãẽ́ b̶eada; zocãrã panʌda wa zocãrãẽ́ panʌda. ");
INSERT INTO empNTpo_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Acʌd̶adua ãdji druara sãwã b̶ʌda; bia b̶ʌda wa biẽ́ b̶ʌda. Idjab̶a acʌd̶adua ãdji purura sãwã b̶eada; mõgaraba aud̶u jũrã ca b̶eada wa ara jãwã b̶eada. ");
INSERT INTO empNTpo_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Acʌd̶adua dji ẽjũãda; ẽjũã biada wa ẽjũã biaẽ́da, bacuru baraada wa neẽ́da. ¡Sozarra b̶ead̶adua! Idjab̶a maʌ̃ druad̶ebema nejõda ʌ̃cʌrʌ b̶a enenadua.– (Moiseba ãdjirãra uva jara diabuesia.) ");
INSERT INTO empNTpo_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ara maʌ̃da Canaaʌ̃ drua acʌd̶e wãsid̶aa. Ãdjirãba jũma acʌsid̶aa Ziʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶eba ab̶a Reho purud̶aa. (Reho purura Hamá drua caita b̶ʌa.) ");
INSERT INTO empNTpo_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Negue ẽjũã põãsa ewaraga b̶ʌare wãnaped̶a Hebroʌ̃ purud̶e jũẽne wãsid̶aa. Maʌ̃ purud̶e Ahimaʌ̃da, Sesaida, Talmai sid̶a panabadjid̶aa. Ãdjira Anacad̶eba yõped̶ad̶a basía. (Ãdji drõã naẽnabemarãba Hebroʌ̃ purura osid̶aa siete poa egiptorãba Zoaʌ̃ puru od̶i naẽna.) ");
INSERT INTO empNTpo_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Dji acʌd̶e wã panʌra jewed̶a Escol abadad̶e jũẽne wãsid̶aa. Mama uva cʌmʌ droma b̶ʌda ab̶a tʌ edasid̶aa. Maʌ̃gʌra bacurud̶e jʌ̃naped̶a ẽberã uméba equiad̶eba edesid̶aa. Idjab̶a granadajõda, higojõ sid̶a b̶a edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Maʌ̃ jewed̶ara ãdjirãba trʌ̃ b̶ʌsid̶aa Escol, uva cʌmʌ droma b̶ʌda tʌ edaped̶ad̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Cuarenta ewari Canaaʌ̃ druara jũma acʌ pananaped̶a jẽda wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Paraʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶e Cadé abadama ãdjirãra Moise ume, Aaroʌ̃ ume, idjab̶a jũma israelerã ume ãbaa dji jʌresid̶aa. Maʌ̃ne jũma ãdjia unuped̶ad̶ada nẽbʌrʌd̶aped̶a Canaaʌ̃ druad̶ebema nejõda acʌbisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ãdjirãba Moisea nãwã nẽbʌrʌsid̶aa: –Bʌa wãbid̶a druad̶e dairãra jũẽsid̶aa. Wãrãda maʌ̃ druad̶e baridua ne uped̶ad̶ara bia zaubaria. Maʌ̃ druad̶ebema nejõda acʌdua. ");
INSERT INTO empNTpo_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Baribʌrʌ maʌ̃ druad̶e b̶ea ẽberãrãra bio mẽsrã b̶eaa. Ãdji purura waib̶ʌa b̶eaa idjab̶a mõgaraba aud̶u jũrã ca b̶eaa. Mama dairãba Anacad̶eba yõped̶ad̶arãda unusid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Ãdjirã awara Negue ẽjũã põãsa ewaraga b̶ʌd̶e amalecitarãda panabadaa. Ẽjũã eyaid̶a b̶ʌd̶e hititarãda, jebuseorãda, amorreorã sid̶a panabadaa. Pusaare, Jordaʌ̃ doare bid̶a cananeorãda panabadaa.– ");
INSERT INTO empNTpo_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Maʌ̃ bed̶ea carea puru Moise quĩrãpita b̶ʌga nũmʌra Caleba chupeabisia. Maʌ̃be jarasia: –¡Wãna! ¡Maʌ̃ druara dadjirãba poya edad̶ia! ¡Maʌ̃ druad̶e b̶ea ẽberãrãra wãrãda poyad̶ia!– ");
INSERT INTO empNTpo_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Baribʌrʌ idji ume acʌd̶e wã pananaba jarasid̶aa: –¡Dadjirãra wãnaẽ́a! ¡Maʌ̃ druad̶e b̶ea ẽberãrãra dadjirã cãyãbara mẽsrãara b̶eaa!– ");
INSERT INTO empNTpo_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Maʌ̃be sewad̶eba ãdjirãba israelerãa jara panesid̶aa ãdjia acʌd̶e wã panana druara dji biaẽ́da. Nãwã jarasid̶aa: –Jãʌ̃ drua daiba acʌd̶e wã pananane ẽberãrãra dji quini nũmabaria. Maʌ̃ awara ẽberãrã daiba unuped̶ad̶ara jũma waib̶ʌga b̶eaa. ");
INSERT INTO empNTpo_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Mama dairãba unusid̶aa Anacad̶eba yõped̶ad̶a ẽberãrã drasoa waib̶ʌga b̶eada. Ãdjirã acʌd̶abara dairãra djuburi qued̶eaa ad̶ichichi quĩrãca. Idjab̶a ãdjirãba dairãra ara maʌ̃ quĩrãca unusid̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Maʌ̃ ũrĩsid̶ad̶e israelerã jũmarãda b̶ʌga nũmesia idjab̶a maʌ̃ diamasi jĩã panʌda ʌ̃nadrʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Puruba Moiseda, Aaroʌ̃ sid̶a biẽ́ jarad̶aped̶a ãdjía nãwã jarasid̶aa: –¡Dairãra Egiptod̶e beuped̶ad̶abara biara b̶acasia! ¡Naʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶e bid̶a beuped̶ad̶abara biara b̶acasia! ");
INSERT INTO empNTpo_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","¿Ãcõrẽba cãrẽ cãrẽã dairãra maʌ̃ druad̶aa edebʌrʌ? ¿Mama djõ panʌne maʌ̃ druad̶ebemarãba dairãra quenanamãrẽã edebʌrʌca? ¿Dai wẽrãrãra, warrarã sid̶a maʌ̃ ẽberãrãba ara ãdjirã itea jidad̶amãrẽã edebʌrʌca? ¿Egiptod̶aa jẽda wãnida biara b̶ʌẽ́ca?– ");
INSERT INTO empNTpo_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Maʌ̃be ãdjidub̶a jara duanesid̶aa: –Ab̶a edad̶ia dadjirã boro bamãrẽã. Maʌ̃be Egiptod̶aa jẽda wãnia.– ");
INSERT INTO empNTpo_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Maʌ̃ ũrĩsid̶ad̶e Moisera, Aaroʌ̃ sid̶a jũma israelerã quĩrãpita chĩrãborod̶e b̶arru copanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Maʌ̃ne Nuʌ̃ warra Josueba, Jepone warra Cale bid̶a ãdjia cacuad̶e jʌ̃ panʌda sopuaba cõãtasid̶aa. Maʌ̃ umébemara Canaaʌ̃ drua acʌd̶e wã panananebema basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Ãdjia israelerãa jarasid̶aa: –Dairãba acʌd̶e wã panana ẽjũãra bio bia b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Maʌ̃ druad̶e baridua ne uped̶ad̶ara bia zaubaria. Ãcõrẽba dadjirãda bia unu b̶ʌbʌrʌ maʌ̃ druad̶aa edeped̶a jũma diaya. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Maʌ̃ bẽrã Ãcõrẽra igararãnadua. Idjab̶a maʌ̃ druad̶ebemarãda wayarãnadua. Dadjirãba poyad̶ia, ãdjirãra caiba carebai neẽ́ panʌ bẽrã. Baribʌrʌ Ãcõrẽda dadjirã ume b̶ʌa. Maʌ̃ bẽrã ãdjirãra wayarãnadua.– ");
INSERT INTO empNTpo_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Mãwã jara pananamĩna puruba ãdjira mõgaraba tab̶ari bead̶iad̶a asid̶aa. Mãwã duanʌne cawaẽ́ne ãdjirãba unusid̶aa Ãcõrẽ quĩrãwãrẽã dorrodorroada idji wua ded̶e ʌ̃naga dogoda. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Maʌ̃ne Ãcõrẽba Moisea jarasia: –¡Naʌ̃ ẽberãrãba baridua carea mʌ̃ra igarabadaa! ¡Mʌ̃a ãdjirã tãẽna ne ununaca waib̶ʌa b̶eada od̶amĩna wad̶ibid̶a mʌ̃ra ĩjã amabadaa! ");
INSERT INTO empNTpo_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Maʌ̃ carea mʌ̃a ãdjirãra quinibiya. Baribʌrʌ bʌd̶eba mʌ̃a ãdjirã cãyãbara puru waib̶ʌara b̶ʌda idjab̶a ʌb̶ʌara b̶ʌda yõbiya.– ");
INSERT INTO empNTpo_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","14","Moiseba Ãcõrẽa jarasia: –Bʌ ʌb̶ʌad̶eba naʌ̃ ẽberãrãra Egiptod̶eba ẽdrʌ enesia. Maʌ̃da bʌa ãdjirãda quinibibʌrʌ egiptorãba ũrĩnaped̶a Canaaʌ̃ druad̶ebemarãa nẽbʌrʌd̶ia. Mʌ̃ Boro, Canaaʌ̃nebemarãba naẽna ũrĩsid̶aa bʌra dairã ume b̶ʌda, dairãma ebud̶a odjasida, bʌ jʌ̃rãrãda dairã ʌ̃rʌ̃ nĩbabarida, ãsa bʌra jʌ̃rãrã ʌ̃tʌba ed̶aa drasoa jira b̶ʌd̶e dairã na wãbarida idjab̶a diamasi ara maʌ̃ jʌ̃rãrãda tʌbʌ quĩrãca eradrʌ nũmabarida. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Bʌa naʌ̃ ẽberãrãda jũma quinibibʌrʌ, bʌa o b̶ʌ ũrĩped̶ad̶aba nãwã jarad̶ia: ");
INSERT INTO empNTpo_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","“Ãcõrẽba israelerãra idjia diai jarad̶a ẽjũãnaa poya edeẽ́ basía. Maʌ̃ bẽrã ãdjirãra ẽjũã põãsa ewaraga b̶ʌd̶e jũma quinibisia.” ");
INSERT INTO empNTpo_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Mʌ̃ Boro, mãwã jararãnamãrẽã mʌ̃ quĩrã djuburia bʌ ʌb̶ʌara unubidua ara bʌa jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Bʌa jarasia bʌra baridua quĩrũcada idjab̶a ẽberãrãra bio quĩrĩã b̶ʌda. Maʌ̃ awara jarasia ãdjia cadjirua obadara, bʌ bed̶ea igarabada sid̶a bʌa quĩrãdoabarida. Mãwãmĩna dji bed̶ead̶e b̶ʌra bʌa cawa obariad̶a asia. Dji zezaba cadjirua od̶a carea idjida, idji warrarãda, idji wiuzaquerãda, ãdjirã warrarã sid̶a cawa o b̶abariad̶a asia. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Maʌ̃ bẽrã bʌ quĩrĩã waib̶ʌa b̶ʌd̶eba naʌ̃ ẽberãrãba cadjirua oped̶ad̶ara quĩrãdoadua ãdji Egiptod̶eba ẽdrʌped̶ad̶a ewarid̶eba ab̶a id̶id̶aa bʌa quĩrãdoad̶a quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Ãcõrẽba jarasia: –Ãdjia cadjirua oped̶ad̶ara mʌ̃a quĩrãdoasia bʌa bed̶ea djuburiad̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Mãwãmĩna mʌ̃ra wãrãda zocai b̶ʌ bẽrã, idjab̶a wãrãda jũma naʌ̃ ẽjũãne dji dromaara b̶ʌ bẽrã, wãrãda nãwã cawa oya. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","23","Naʌ̃ ẽberãrã ni ab̶aʌda mʌ̃a ãdji drõã naẽnabemarãa diai jarad̶a ẽjũãne idu jũẽbiẽ́a. Ãdjirãba mʌ̃ quĩrãwãrẽã dorrodorroada unuped̶ad̶amĩna idjab̶a Egiptod̶e, ẽjũã põãsa ewaraga b̶ʌd̶e bid̶a mʌ̃a ne ununaca o b̶ʌda unuped̶ad̶amĩna mʌ̃ra ĩjãnaẽ́ basía. Ãtebʌrʌ mʌ̃a poya oẽ́ quĩrãca b̶arima zocãrã biẽ́ bed̶easid̶aa. Mʌ̃da igaraped̶ad̶a bẽrã ãdjirã ni ab̶aʌda Canaaʌ̃ druad̶e jũẽnaẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Baribʌrʌ mʌ̃ nezoca Cale crĩchara awara b̶ʌa. Idjiabʌrʌ mʌ̃ra ne jũmane bia ẽpẽbaria. Maʌ̃ bẽrã idjia acʌd̶e wã b̶ad̶a ẽjũãne mʌ̃a idjira jũẽbiya. Idjia, idjid̶eba yõbʌdarã bid̶a maʌ̃ ẽjũãra edad̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Baribʌrʌ nu bãrãra Pusa Purrud̶aa wãbada od̶e jẽda wãnadua ẽjũã põãsa ewaraga b̶ʌd̶aa. Ara nawena amalecitarãda cananeorã sid̶a Canaaʌ̃ drua jewed̶ad̶e duanʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Idjab̶a Ãcõrẽba Moisea, Aaroʌ̃a bid̶a nãwã jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","–¿Ab̶a sãʌ̃be naʌ̃ puru cadjiruaba mʌ̃ra biẽ́ jara panani? Mʌ̃a ũrĩ b̶ʌa ãdjia mʌ̃da biẽ́ jara panabadada. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Maʌ̃ bẽrã ãdjirãa nãwã jarad̶e wãnadua: “Ãcõrẽba nãwã jara b̶ʌa: mʌ̃ra wãrãda zocai b̶ʌ bẽrã bãrãba jaraped̶ad̶a quĩrãca wãrãda oya. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Jũma bãrã veinte poa aud̶u b̶ea mʌ̃a juachabid̶aba mʌ̃da biẽ́ jaraped̶ad̶a bẽrã naʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶e beud̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Bãrãnebema ni ab̶aʌda mʌ̃a wãrãneba bãrãa diai jarad̶a ẽjũãnaa jũẽne wãnaẽ́a. Ab̶abe Jepone warra Caledrʌ, Nuʌ̃ warra Josue sid̶a maʌ̃ ẽjũãne jũẽne wãnia. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Bãrãba jarasid̶aa maʌ̃ druad̶ebemarãba bãrã warrarãra ara ãdji itea jida eded̶ida. Baribʌrʌ maʌ̃ drua bãrãba igaraped̶ad̶ara mʌ̃a bãrã warrarãa diaya. Maʌ̃be ãdjirãra maʌ̃ druad̶e bia panania. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Baribʌrʌ bãrã dji drõãrãra naʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶e beud̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Bãrã warrarãra bãrã ume naʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶e cuarenta poa pʌrrʌa nĩbad̶ia oveja wagabari pʌrrʌa nĩbabari quĩrãca. Bãrãba mʌ̃ra igaraped̶ad̶a bẽrã, bãrã warrarãra bia mĩga panania ab̶a bãrã jũma beubʌdad̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Canaaʌ̃ drua acʌd̶e wã panana ẽberãrãra cuarenta ewari mama panasid̶a bẽrã, bãrãra cuarenta poa bia mĩga pananida panʌa mʌ̃ igaraped̶ad̶a carea. Mãwã bãrãba cawad̶ia mʌ̃ quĩrũbira sãwãbʌrʌ b̶ʌda.” ");
INSERT INTO empNTpo_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Mʌ̃ra Ãcõrẽa. Mʌ̃a jarad̶ara wãrãda oya. Naʌ̃ puru dji cadjiruada mʌ̃a cawa oya jũmarãba mʌ̃da igaraped̶ad̶a bẽrã. Naʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶e beud̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","Maʌ̃be Moiseba Canaaʌ̃ drua acʌd̶e diabued̶arãra Ãcõrẽba cawaẽ́ne quinibisia. Mãwã quinibisia Canaaʌ̃ druad̶eba jẽda zed̶aped̶a israelerãa idjida biẽ́ jarabisid̶a bẽrã idjab̶a sewad̶eba maʌ̃ ẽjũãra biẽ́ tab̶ʌad̶a asid̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Canaaʌ̃ drua acʌd̶e wã panananebemada umébe beud̶aẽ́ basía; Nuʌ̃ warra Josueda idjab̶a Jepone warra Cale sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Moiseba jũma Ãcõrẽba jarad̶ara israelerãa jarasia. Maʌ̃ carea ãdjirãra sopuad̶eba bio jĩã duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Maʌ̃ bẽrã nurẽma diaped̶ed̶a ãdjirãra piradrʌd̶aped̶a Canaaʌ̃ druad̶e eyaid̶a b̶ʌmaa wãni carea panasid̶aa. Nãwã jarasid̶aa: –Dairãba cadjiruada osid̶aa maʌ̃ druara poya edad̶aẽ́ana asid̶ad̶e. Dairãra wãnia Ãcõrẽba diai jarad̶a druad̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Baribʌrʌ Moiseba jarasia: –¿Bãrãba cãrẽ cãrẽã Ãcõrẽba jarad̶ara ĩjãnaẽ́? Bãrãda Canaaʌ̃ druad̶aa wãnibʌrʌ, bia wãnaẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Mama wãrãnadua. Ãcõrẽra bãrã ume wãẽ́ bẽrã dadjirã dji quĩrũba bãrãra quenania. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Bãrãba Ãcõrẽra igarasid̶a bẽrã idjira bãrã ume b̶aẽ́a. Maʌ̃ bẽrã amalecitarã ume idjab̶a cananeorã ume djõbʌdad̶e ãdjirãba bãrãra quenania.– ");
INSERT INTO empNTpo_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Mãwã jarad̶amĩna israelerãba ĩjãnaẽ́ basía. Canaaʌ̃ druad̶e eyaid̶a b̶ʌare wãsid̶aa. Baribʌrʌ Moisera wãẽ́ basía. Ãcõrẽ baurude sid̶a israelerã wua de eropanʌma b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Maʌ̃ne eyad̶e panʌ amalecitarãra, cananeorã sid̶a israelerã ume djõne zesid̶aa. Israelerãra poyad̶aped̶a ãdjirã caid̶u ẽpẽ quena wãsid̶aa ab̶a Hormá abadad̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","Izar warrada Core abadjid̶aa. Idjira Levi warra Coád̶eba yõna basía. Corera dewara ẽberãrã ũbea panʌ ume bed̶ea ausid̶aa Moise ãyã b̶ʌd̶i carea. Maʌ̃ ũbeabemara Rubeʌ̃neba yõped̶ad̶a basía; ab̶a Eliá warra Dataʌ̃ basía, ab̶a idji warra Abiraʌ̃ basía, idjab̶a ab̶a Pele warra Oʌ̃ basía. Ãdjirãare israelerã bororãda 250 panasid̶aa. Maʌ̃ bororãra dji biara b̶eada puruba edad̶a basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Jũma maʌ̃ ẽberãrãra Moisemaa Aaroʌ̃maa bid̶a wãnaped̶a nãwã jarasid̶aa: –¡Ab̶a id̶ibe bãrãra dairã boro bad̶ia! Purura jũmaena Ãcõrẽba idji itea edasia. Idjira dairã ume bid̶a b̶ʌa. Mãwã b̶ʌ bẽrã ¿cãrẽ cãrẽã jũma Ãcõrẽ puru cãyãbara bãrãra dji dromaara panʌda crĩcha panʌ?– ");
INSERT INTO empNTpo_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Maʌ̃ ũrĩsid̶e Moisera chĩrãborod̶e b̶arru cob̶esia Ãcõrẽa bed̶ea djuburiai carea. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Maʌ̃be Corea, idjiare panʌrãa bid̶a jarasia: –Nu diaped̶a Ãcõrẽba cawabiya caida idjid̶eda idjab̶a caida edasida idji sacerdote bamãrẽã. Idjia edad̶a ẽberãdrʌ idji caita idu wãbiya. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","7","Core, bʌa, bʌare panʌrã bid̶a nãwã od̶adua: bãdjiza quera babada eped̶ecoda edad̶aped̶a nu tʌbʌdauda, quera bad̶i careabema sid̶a maʌ̃ eped̶ecod̶e b̶ʌd̶adua. Maʌ̃da Ãcõrẽ quĩrãpita b̶ʌd̶e wãnadua. Maʌ̃ne Ãcõrẽba cawabiya caida edasida idji sacerdote bamãrẽã. ¡Bãrã levitarãra jũmawãyã bed̶ea panʌa. Ya b̶esia!– ");
INSERT INTO empNTpo_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moiseba Corea idjab̶a jarasia: –Bãrã levitarã, ũrĩnadua. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Dadji israelerã Ãcõrẽba bãrãdrʌ awara b̶ʌsia idji caita poya wãnamãrẽã. Mãwã israelerãba Ãcõrẽa animarã babue diad̶e wãbʌdad̶e bãrãbʌrʌ ãdjirãra carebabadaa idjab̶a dadjirã nocod̶aa wãbʌdad̶e Ãcõrẽ wua dera edebadaa. ¿Ara maʌ̃ba bia b̶ʌẽ́ca? ");
INSERT INTO empNTpo_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Core, Ãcõrẽba bʌra, waabema levitarã sid̶a idji caita idu wãbibaria mãwã od̶amãrẽã. Baribʌrʌ bãrãmaarã maʌ̃gʌra bia b̶ʌẽ́a ãtebʌrʌ Ãcõrẽ sacerdoterã ba quĩrĩã panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Maʌ̃ bẽrã bʌa, bʌare b̶ea bid̶a Ãcõrẽra igara panʌa. ¿Cãrẽ cãrẽã Aaroʌ̃ra biẽ́ jara panʌ? ¿Aaroʌ̃ra bed̶ead̶e b̶ʌca Ãcõrẽba idji sacerdote bamãrẽã b̶ʌd̶a bẽrã?– ");
INSERT INTO empNTpo_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Maʌ̃be Moiseba Eliá warrarã Dataʌ̃da, Abiraʌ̃ sid̶a trʌ̃bisia. Baribʌrʌ ãdjia jarabisid̶aa: –Daira bʌmaa wãnaẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Bʌa daira drua biad̶eba ẽdrʌ enesia. Maʌ̃ druad̶ebʌrʌ baridua ne uped̶ad̶ara bia zaubaria. Bʌa daira naʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶e jũma quinibibʌrʌa. Maʌ̃da ¿bʌra wad̶ibid̶a dai boroda b̶a quĩrĩã b̶ʌca? ");
INSERT INTO empNTpo_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Bʌa drua biad̶aa edeyad̶a asia. Maʌ̃ druad̶e baridua ne uped̶ad̶ara bia zaubariad̶a asia. Baribʌrʌ bʌa daira mamaa edeẽ́ tab̶ʌa. Ẽjũãda, uva bara b̶ʌ ẽjũã sid̶a diaẽ́ tab̶ʌa. ¿Bʌa wad̶ibid̶a daira cũrũga quĩrĩã b̶ʌca? Daira bʌmaa wãnaẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Mãwã jara panʌ carea Moisera bio quĩrũped̶a Ãcõrẽa jarasia: –Ãdjia bʌ́a diabʌdara bia unurãdua. Mʌ̃ra ãdji boromĩna ãdji burroda, ni cãrẽ sid̶a ãdjid̶era jãrĩẽ́ b̶ʌa. Mʌ̃a ãdjira ni ab̶a bid̶a biẽ́ oẽ́ b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Maʌ̃be Moiseba Corea jarasia: –Nu bʌra, bʌare panʌrã sid̶a Ãcõrẽ quĩrãpita wãnadua idji wua demaa. Aaroʌ̃ sid̶a mama b̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Bʌare panʌ 250 ẽberãrãba ãdji quera babada eped̶ecora edad̶aped̶a querara coa nũmʌnadua. Maʌ̃gʌra Ãcõrẽ wua demaa idji quĩrãpita eded̶adua. Bʌa, Aaroʌ̃ bid̶a bãrã quera babada eped̶ecora eded̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Nurẽma ãdjirãza quera babada eped̶ecoda edad̶aped̶a tʌbʌdauda ed̶a b̶ʌd̶aped̶a querada coa nũmʌsid̶aa. Ãdjirãra, Moisera, Aaroʌ̃ sid̶a Ãcõrẽ wua ded̶e ed̶a wãbada caita duanasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Coreba jũma Israel purura Ãcõrẽ wua ded̶e ed̶a wãbadamaa zebisia Moise, Aaroʌ̃ sid̶a ãyã b̶ʌd̶i carea. Cawaẽ́ne Ãcõrẽ quĩrãwãrẽã dorrodorroada ãdjirã quĩrãpita ʌ̃naga dogosia. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Maʌ̃ne Ãcõrẽba Moisea, Aaroʌ̃a bid̶a jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","–Naʌ̃ ẽberãrã caitabemada ãyã wãnadua. Mʌ̃a ãdjirãra ab̶ed̶a jũma quinibiya.– ");
INSERT INTO empNTpo_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Baribʌrʌ Moisera Aaroʌ̃ sid̶a chĩrãborod̶e b̶arru copanenaped̶a Ãcõrẽa nãwã bed̶ea djuburiasid̶aa: –Ãcõrẽ, bʌd̶eba ẽberãrãra jũma zocai b̶eaa. ¿Ab̶aʌba cadjirua od̶a carea bʌra jũma naʌ̃ puru ume quĩrũ b̶aica?– ");
INSERT INTO empNTpo_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","–Purua jaradua Core wua de caitabemada, Dataʌ̃ wua de caitabemada, idjab̶a Abiraʌ̃ wua de caitabemada ãyã wãnamãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Ara maʌ̃da Moisera piradrʌped̶a Dataʌ̃ b̶ʌmaa idjab̶a Abiraʌ̃maa bid̶a wãsia. Israelerã bororã sid̶a Moise caid̶u wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Maʌ̃ne Moiseba purua jarasia: –Jãʌ̃ cadjirua obadarã wua de caitabemada ãyã wãnadua. Ãdjia eropanʌnebemada tãrãnadua. Tãnibʌrʌ bãrã sid̶a beud̶ia jũma ãdjia cadjirua oped̶ad̶a carea.– ");
INSERT INTO empNTpo_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ara maʌ̃da israelerãra Core wua de caitabemada, Dataʌ̃ wua de caitabemada idjab̶a Abiraʌ̃ wua de caitabemada ãyã wãsid̶aa. Maʌ̃ne Dataʌ̃ra, Abiraʌ̃ sid̶a ãdji wua de dajada zed̶aped̶a ãdji ded̶e ed̶a wãbada caita ʌ̃ta nũmeasia. Ãdji ume dji quimada, jũma ãdji warrarã sid̶a nũpanasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Maʌ̃ne Moiseba jarasia: –Nãwã bãrãba cawad̶ia ara mʌ̃djia quĩrĩã b̶ʌd̶eba bãrã boroda b̶eẽ́ basida, ãtebʌrʌ Ãcõrẽbʌrʌ mʌ̃ra b̶ʌsida: ");
INSERT INTO empNTpo_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","naʌ̃ ẽberãrãda dadji beubada quĩrãca beud̶ibʌrʌ, bãrãba cawad̶ia Ãcõrẽba mʌ̃ra b̶ʌẽ́ basida bãrã boro bamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Baribʌrʌ Ãcõrẽba egoroda cawaẽ́ne yã dogobiped̶a ãdjira, jũma ãdjia eropanʌ sid̶a egoroba mĩbʌrʌ, ãdjirã zocai panʌne beud̶arã jaure panabadamaa wãnibʌrʌ, bãrãba cawad̶ia ãdjiabʌrʌ Ãcõrẽda igarasid̶ada. Mãwã cawad̶ia, ẽberãrã maʌ̃ quĩrãca beubʌdada dadjirãba wad̶ibid̶a ununaca bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Moiseba mãwã jarabʌrʌd̶e Dataʌ̃ b̶ʌmaʌba ab̶a Abiraʌ̃ b̶ʌmaa egorora yã dogosia. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Maʌ̃ne egoroba ãdjira, ãdji ẽberãrãra, Corera, idji ẽberãrãra, idjab̶a jũma ãdjia eropanana sid̶a mĩsia. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ãdjirã mĩped̶a egorora wayacusa araa catʌ dogosia. Mãwã zocai panʌne maʌ̃ ẽberãrãra jũma ãdjia eropanana sid̶a beud̶arã jaure panabadamaa wãsid̶aa. Israelerã tãẽnabemada nẽbasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Egoroba mĩbʌrʌd̶e maʌ̃ ẽberãrã b̶iabʌda carea ãdjirã caita duanʌra ãyã pira wãsid̶aa. Maʌ̃ne nãwã b̶iasid̶aa: –¡Egoroba dadjirã sid̶a mĩcuaya!– ");
INSERT INTO empNTpo_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Maʌ̃ awara Ãcõrẽba tʌbʌ uruada idji b̶ʌmaʌba quera bá dia panʌ ẽberãrãmaa eradrʌbisia. Mãwã eradrʌbʌrʌba maʌ̃ 250 ẽberãrãra jũma bá quenasia. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Maʌ̃be Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","38","–Sacerdote Aaroʌ̃ warra Eleazaa jaradua quera babada eped̶ecora tʌbʌ cowa nũmʌnebemada jʌrʌ pemãrẽã. Tʌbʌdau eped̶ecod̶e wad̶i b̶ʌra ãyã tʌmʌ peabueida b̶ʌa. Maʌ̃ eped̶ecod̶e mʌ̃́a querada bá diasid̶a bẽrã eped̶ecora mʌ̃ itea b̶esia. Jãʌ̃ ẽberãrãba cadjiruada oped̶ad̶a bẽrã beusid̶aa. Maʌ̃ bẽrã ãdji eped̶ecora pewed̶ea berrachid̶aped̶a animarã babue diabadad̶e cara b̶ʌd̶adua israelerãba quĩrãnebad̶amãrẽã baridua ẽberãba querada mʌ̃́a bá diacara b̶ʌda.– ");
INSERT INTO empNTpo_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Ara maʌ̃da sacerdote Eleazaba ẽberãrã tʌbʌba bá beuped̶ad̶a quera babada eped̶ecora jʌrʌ pesia. Jʌrʌ peped̶a maʌ̃ eped̶eco bronce od̶ara pewed̶ea berrachibisia animarã babue diabadad̶e cara b̶ʌi carea. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Maʌ̃ra cara b̶ʌsia israelerãba quĩrãnebad̶amãrẽã Aaroʌ̃ idjab̶a idjid̶eba yõbʌdarã awara ni ab̶aʌba querada Ãcõrẽa bá diacara b̶ʌda Ãcõrẽba Moisea jarad̶a quĩrãca. Ãdjirã awara bariduaba Ãcõrẽa querada bá diaibʌrʌ, maʌ̃ ẽberã sid̶a beuya, Core, idjiare panana sid̶a beuped̶ad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Nurẽma jũma israelerãba wayacusa Moiseda Aaroʌ̃ sid̶a nãwã biẽ́ jara duanesid̶aa: –¡Bãrãba Ãcõrẽ ẽberãrãra beasid̶aa!– ");
INSERT INTO empNTpo_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Mãwã biẽ́ jara panʌra Moisema, Aaroʌ̃ma bid̶a powua nũmasia. Maʌ̃ne Ãcõrẽ wua demaa acʌbʌd̶ad̶e cawaẽ́ne jʌ̃rãrãba dera ãnã edaped̶a Ãcõrẽ quĩrãwãrẽã dorrodorroada ʌ̃naga dogosia. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Ara maʌ̃da Moisera Aaroʌ̃ sid̶a Ãcõrẽ wua de quĩrãpe wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Maʌ̃ne Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","–¡Naʌ̃ puru caitabemada ãyã wãnadua! ¡Mʌ̃a ãdjirãra ab̶ed̶a jũma quinibiya!– Ara maʌ̃da Moisera Aaroʌ̃ sid̶a chĩrãborod̶e b̶arru copanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Moiseba Aaroʌ̃a jarasia: –Bʌ quera babada eped̶ecora isabe enedua. Animarã babue diabadad̶e b̶ʌ tʌbʌdauda ed̶a b̶ʌped̶a incienso querada coa nũmʌdua. Maʌ̃be israelerã duanʌmaa isabe wãped̶a Ãcõrẽa diadua ãdjirãba cadjirua oped̶ad̶ara quĩrãdoamãrẽã. Ãcõrẽra bio quĩrũ b̶ʌ bẽrã ãdjirãra quinibʌdaa.– ");
INSERT INTO empNTpo_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Ara maʌ̃da Aaroʌ̃ba osia Moiseba jarad̶a quĩrãca. Idji quera babada eped̶ecora edaped̶a israelerã duanʌmaa pira wãsia. Jũẽbʌrʌbara israelerãra ʌ̃cʌrʌ beucuad̶oasia. Maʌ̃ne idjia querada coa nũmʌsia ãdjirãba cadjirua oped̶ad̶ara Ãcõrẽba quĩrãdoamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Idjira nũmesia dji quiniped̶ad̶a tab̶ea, dji zocai panʌ ẽsi. Mãwã ãdjirãra waa quininaẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Maʌ̃ ewarid̶e 14,700 ẽberãrãra quinisid̶aa Coreare b̶ead̶a naẽna quiniped̶ad̶a juachad̶aẽ́. ");
INSERT INTO empNTpo_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Ẽberãrãra waa quininaẽ́ bẽrã Aaroʌ̃ra Moisemaa wãsia Ãcõrẽ wua ded̶e ed̶a wãbada caita. ");
INSERT INTO empNTpo_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Maʌ̃be Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","–Israelerãa jaradua bacuruda doce enenamãrẽã. Israeld̶eba yõna doce purud̶ebema bororãba bacuruda ab̶a ab̶a diad̶ida panʌa. Maʌ̃ bacurud̶e dji bororã trʌ̃da b̶ʌdua. ");
INSERT INTO empNTpo_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Levid̶eba yõna puruba enena bacurud̶e Aaroʌ̃ trʌ̃da b̶ʌdua. Israeld̶eba yõna puruza bacuru ab̶a diad̶ida panʌa ãdji boro trʌ̃da b̶ʌmãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Maʌ̃ bacurura mʌ̃ wua ded̶e baurude quĩrãpe b̶ʌdua mʌ̃ bãrã ume bed̶eabarima. ");
INSERT INTO empNTpo_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Nu bacuru ab̶a quedua bara b̶aya. Maʌ̃ bacuru djibarira mʌ̃a edasia mʌ̃ sacerdote bamãrẽã. Maʌ̃ ununaped̶a israelerãba bãrãda waa biẽ́ jarad̶aẽ́a. Mãwã mʌ̃a ãdjirãra chupeabiya.– ");
INSERT INTO empNTpo_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Moiseba israelerãa mãwã jarasia. Ara maʌ̃da Israeld̶eba yõna doce purud̶ebema bororãba ãdji bacuru cawacawa Moisea diad̶e zesid̶aa. Doce bacurura diasid̶aa. Aaroʌ̃ne sid̶a diasia. ");
INSERT INTO empNTpo_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Moiseba maʌ̃ bacurura Ãcõrẽ wua ded̶e baurude quĩrãpe b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Nurẽma Moise Ãcõrẽ wua ded̶e ed̶a wãbʌrʌd̶e unusia Levid̶eba yõna Aaroʌ̃ bacurura pãwãrã quedua bara b̶ʌda, põnõ bara b̶ʌda, idjab̶a almendra tada zauped̶a purea jira b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Moiseba bacurura Ãcõrẽ wua ded̶eba dajada israelerãmaa jũma edesia. Israelerãba acʌd̶aped̶a ãdjid̶e cawacawa edasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Maʌ̃be Ãcõrẽba Moisea jarasia: –Aaroʌ̃ bacurura wayacusa mʌ̃ baurude quĩrãpe waga b̶ʌdua. Maʌ̃ bacurura waga eropananida panʌa mʌ̃ igarabadarãba quĩrãnebad̶amãrẽã mʌ̃a Aaroʌ̃drʌ, idjid̶eba yõbʌdarã sid̶a edasida mʌ̃ sacerdoterã b̶ead̶amãrẽã. Mãwã ãdjirãba mʌ̃ biẽ́ jara panʌda bʌa chupeabiya quinirãnamãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Ara maʌ̃da Moiseba jũma osia Ãcõrẽba idjía jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Maʌ̃be israelerãba Moisea jarasid̶aa: –¡Dairãra beud̶ia! ¡Ab̶ed̶a jũma quininia! ¡Jũma nẽbad̶ia! ");
INSERT INTO empNTpo_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","¡Bariduada Ãcõrẽ wua de caita wãibʌrʌ beuya! ¡Dairãra jũma quininia!– ");
INSERT INTO empNTpo_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Poa djiwid̶id̶e dji nabema jed̶ecod̶e israelerãra Cadé abadama jũẽne wãsid̶aa. Maʌ̃ Cadéra Ziʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶e b̶ʌa. Mama Moise djabawẽrã Mariara jaid̶aped̶a tʌb̶arisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Mama baido dod̶i carea neẽ́ basía. Maʌ̃ bẽrã purura Moisemaa, Aaroʌ̃maa bid̶a wãsid̶aa biẽ́ jarad̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Quĩrũbid̶eba Moisea nãwã jarasid̶aa: –¡Ãcõrẽba dai djabarã quinibisid̶e dairã sid̶a quiniped̶ad̶abara biara b̶acasia! ");
INSERT INTO empNTpo_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","¿Bãrãba cãrẽ cãrẽã dairã, Ãcõrẽ purura naʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶aa enesid̶aa? ¿Dairãra dai animarã sid̶a nama beud̶amãrẽã enesid̶aca? ");
INSERT INTO empNTpo_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","¿Cãrẽ cãrẽã Egiptod̶eba naʌ̃ ẽjũã biẽ́ tab̶ʌd̶aa enesid̶a? ¡Nama poya ne ucara tab̶ʌa! ¡Higojõda, uvada, granadajõ sid̶a neẽ́ tab̶ʌa! ¡Baido sid̶a neẽ́ tab̶ʌa!– ");
INSERT INTO empNTpo_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Ara maʌ̃da Moisera Aaroʌ̃ sid̶a israelerã duanʌmaʌba Ãcõrẽ wua ded̶e ed̶a wãbada caita wãnaped̶a chĩrãborod̶e b̶arru copanesid̶aa Ãcõrẽa iwid̶id̶i carea. Maʌ̃ne Ãcõrẽ quĩrãwãrẽã dorrodorroada ãdji quĩrãpita ʌ̃naga dogosia. ");
INSERT INTO empNTpo_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","–Bʌ bacuruda edaped̶a bʌ djaba Aaroʌ̃ ume purura eded̶adua awuá mõgara waib̶ʌa b̶ʌmaa. Ãdjirã quĩrãpita maʌ̃ mõgaraa bed̶eadua baidoda weamãrẽã. Ara mãwã bed̶eabʌrʌd̶e baidora mõgarad̶eba wea dogoya. Mãwã bʌa baidora weabiya israelerãba ãdji animarã bid̶a dod̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Ara maʌ̃da Moiseba idji bacurura Ãcõrẽ wua ded̶e b̶ʌda edasia Ãcõrẽba jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Idjia Aaroʌ̃ ume purura ãbaa jʌresid̶aa Ãcõrẽba jarad̶a mõgara quĩrãpe. Maʌ̃ne Moiseba israelerãa jarasia: –¡Bãrã cʌwʌrʌ zarea b̶ea, ũrĩnadua! ¿Bãrãba ĩjãnamãrẽã daiba bãrã itea baidoda naʌ̃ mõgarad̶eba weabid̶ida panʌca?– ");
INSERT INTO empNTpo_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Mãwã jaraped̶a Moiseba idji bacurura ʌ̃taa waped̶a mõgarad̶aa b̶arima umé usía. Ara maʌ̃da baidora wea dogoped̶a israelerãba ãdji animarã bid̶a dosid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Mãwãnacarea Ãcõrẽba Moisea Aaroʌ̃a bid̶a nãwã jarasia: –Mʌ̃ ĩjãnaẽ́ panʌneba bãrãba israelerã quĩrãpita cawabid̶aẽ́ basía mʌ̃ra wãrãda Ãcõrẽda. Maʌ̃ bẽrã bãrãra naʌ̃ puru ume jũẽne wãnaẽ́a mʌ̃a diai jarad̶a druad̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Maʌ̃ baido weabid̶ama trʌ̃ b̶ʌsid̶aa Meribá, israelerãra baido carea quĩrũbid̶eba Ãcõrẽ quĩrãpita biẽ́ bed̶eaped̶ad̶a bẽrã. Maʌ̃ baido weabi b̶ʌd̶eba Ãcõrẽba ãdjirãa cawabisia idjira wãrãda Ãcõrẽda. ");
INSERT INTO empNTpo_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Cadé abadad̶eba Moiseba ʌ̃cʌrʌ ẽberãrãda Edoʌ̃nebema boromaa nãwã jarad̶e diabuesia: –Dai israelerãra bãrã djabarãa. Maʌ̃ bẽrã dairãra bʌ ume bed̶ead̶e ze panʌa. Bʌa bio cawa b̶ʌa dairã bia mĩga panʌnebemada. ");
INSERT INTO empNTpo_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Dairã drõã naẽnabemara Egiptod̶aa wãnaped̶a mama dãrã panasid̶aa. Maʌ̃ne egiptorãba ãdjirãra, dairã sid̶a biẽ́ o eropanasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Maʌ̃ carea Ãcõrẽa quĩrã djuburiada iwid̶isid̶aa. Maʌ̃ra Ãcõrẽba ũrĩped̶a idji nezoca bajãnebemada ab̶a diabuesia dairã Egiptod̶eba ẽdrʌ enemãrẽã. Id̶ira bʌ drua caita Cadé abadad̶e panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Dai quĩrã djuburia, bʌ druad̶e idu wãyã wãbidua. Bãrã néud̶e ed̶a wãnaẽ́a, bãrã uva ẽjũãne ed̶a wãnaẽ́a, ni bãrã baido juebada uriad̶ebemada dod̶aẽ́a. Ẽberãrã Boro abada od̶e quĩrãipa wãnia. Bʌ druad̶e panʌne maʌ̃ od̶ebemada jʌwa araare ni jʌwa acʌare bid̶a ãyã wãnaẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Baribʌrʌ Edoʌ̃nebema boroba panusia: –Bãrãra mʌ̃ druad̶e wãnacara panʌa. Maʌ̃da ĩjãnaẽ́bʌrʌ dairãra bãrãmaa djõne wãnia.– ");
INSERT INTO empNTpo_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Dji iwid̶id̶e wã panʌba jarasid̶aa: –Wãrãda quĩrãipa od̶e wãnia. Maʌ̃ne dairãba wa dai animarãba bãrã baidoda dod̶ibʌrʌ, maʌ̃bari paratada diad̶ia. Ab̶abe bʌ druad̶e wãyã wãna quĩrĩã panʌa. Ab̶abe maʌ̃drʌ iwid̶i panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Baribʌrʌ Edoʌ̃nebema boroba wayacusa panusia: –Bãrãra mʌ̃ druad̶e wãnacara panʌa.– Ara maʌ̃da Edoʌ̃nebema boroba sordaorã bio mẽsrã b̶eara zocãrã israelerãmaa djõne edesia. ");
INSERT INTO empNTpo_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Edoʌ̃nebema boroba idji druad̶e idu wãbiẽ́ bẽrã israelerãra dewara óare wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Cadé abadad̶eba Israel purura Hor eyad̶aa wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Hor eyara Edoʌ̃ drua caita b̶ʌa. Mama Ãcõrẽba Moisea Aaroʌ̃a bid̶a jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","–Nama Aaroʌ̃ra jaid̶aya. Idjira mʌ̃a israelerãa diai jarad̶a druad̶e ed̶a wãcara b̶ʌa, Meribád̶e mʌ̃a baido weabid̶ama bãrãba mʌ̃a jarad̶ara ĩjã od̶aẽ́ basi bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Moise, bʌ djaba Aaroʌ̃ra idji warra Eleaza sid̶a Hor eyad̶e ʌ̃taa ededua. ");
INSERT INTO empNTpo_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Mama Aaroʌ̃ba jʌ̃ b̶ʌ djiora ẽrãped̶a idji warra Eleazaa jʌ̃bidua sacerdote dji dromada b̶emãrẽã. Maʌ̃be Aaroʌ̃ra mama jaid̶aya.– ");
INSERT INTO empNTpo_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Ara maʌ̃da Moiseba jũma osia Ãcõrẽba jarad̶a quĩrãca. Jũma israelerãba acʌ panʌne Aaroʌ̃ra, Eleaza sid̶a Hor eyad̶e ʌ̃taa edesia. ");
INSERT INTO empNTpo_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Mama Aaroʌ̃ba jʌ̃ b̶ʌ djiora jũma ẽrãped̶a Moiseba Aaroʌ̃ warra Eleazaa jʌ̃bisia. Maʌ̃be Aaroʌ̃ra eya borod̶e jaid̶asia. Mãwãnacarea Moisera Eleaza sid̶a eyad̶eba ed̶aa zesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Israelerãba Aaroʌ̃ jaid̶ad̶a cawasid̶ad̶e idji carea jũmarãda jed̶eco ab̶a jĩãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Arad purud̶ebema borora cananeo basía. Negue ẽjũã põãsa ewaraga b̶ʌra idji drua basía. Idjia ũrĩsia israelerãra Atariʌ̃naa wãbada od̶e zebʌdada. Maʌ̃ bẽrã idji sordaorãda israelerã ume djõne edesia. Djõ panʌne ãdjirãba ʌ̃cʌrʌ israelerãra jida edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Maʌ̃ bẽrã israelerãba Ãcõrẽa wãrãneba nãwã jarasid̶aa: “Dairãba naʌ̃ ẽberãrã poyad̶amãrẽã bʌa carebaibʌrʌ, ãdji purura jũma ãrĩcuad̶aped̶a babued̶ia.” ");
INSERT INTO empNTpo_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Israelerãba wãrãneba jaraped̶ad̶ara Ãcõrẽba bia ũrĩsia. Idjia carebasia ãdjirãba maʌ̃ cananeorãda poyad̶amãrẽã. Israelerãba jũma quenanaped̶a ãdji purura jũma ãrĩnaped̶a babuesid̶aa. Maʌ̃ bẽrã mama trʌ̃ b̶ʌsid̶aa Hormá. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Hor eyad̶eba israelerãra Pusa Purrud̶aa wãbada óare wãsid̶aa Edoʌ̃ drua aud̶u pʌrrʌgad̶i carea. Mãwã wãnane sẽ panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Maʌ̃ carea Ãcõrẽda, Moise sid̶a nãwã biẽ́ jara duanesid̶aa: –¿Bʌa dairãra Egiptod̶eba ẽdrʌ enesica naʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶e quininamãrẽã? Cod̶ira neẽ́a. Baido sid̶a neẽ́a. Idjab̶a naʌ̃ maná warraẽ́ tab̶ʌ co panʌba sẽ panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Maʌ̃gʌ carea Ãcõrẽba israelerãmaa dama dji arada zocãrã diabuesia. Maʌ̃ damaba israelerãra cácuad̶aped̶a zocãrã quinisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Maʌ̃ bẽrã israelerãra Moisemaa wãnaped̶a jarasid̶aa: –Dairãba cadjiruada osid̶aa Ãcõrẽda, bʌ sid̶a biẽ́ jarasid̶a bẽrã. Dai quĩrã djuburia Ãcõrẽa iwid̶idua naʌ̃ damara ãyã wãbicuamãrẽã.– Ara maʌ̃da Moiseba ãdjirã carea Ãcõrẽa bed̶ea djuburiasia. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Maʌ̃ne Ãcõrẽba Moisea jarasia: –Bronceda dama quĩrãca ab̶a oped̶a bacuru erad̶ad̶e ʌ̃tʌ jira b̶ʌdua. Damaba ab̶aʌda casira, maʌ̃ ẽberãba bronce od̶a damada acʌibʌrʌ biaya.– ");
INSERT INTO empNTpo_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ara maʌ̃da Moiseba bronceda dama quĩrãca oped̶a bacuru erad̶ad̶e ʌ̃tʌ jira b̶ʌsia. Damaba ab̶a cabʌrʌd̶e maʌ̃ ẽberãba bronce od̶a damada acʌsira biabadjia. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Mamaʌba wãnaped̶a israelerãra Obot abadad̶e duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Mamaʌba wãnaped̶a Ije-Abariʌ̃ne duanesid̶aa. Maʌ̃ra Moab druad̶eba ʌ̃mãdau odjabariare ẽjũã põãsa ewaraga b̶ʌd̶e b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Mamaʌba wãnaped̶a Zared do jewed̶ad̶e duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Mamaʌba wãnaped̶a Arnoʌ̃ do quĩrãrẽ duanesid̶aa ẽjũã põãsa ewaraga b̶ʌd̶e. Maʌ̃ ẽjũãra amorreorã druad̶e b̶ʌa. Arnoʌ̃ dora Moab drua idjab̶a amorreorã drua ẽsi b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","15","Maʌ̃ bẽrã carta Ãcõrẽ Djõna abadad̶e nãwã b̶ʌ́ b̶ʌa: Vaheb puru Supa druad̶e b̶ʌare, Arnoʌ̃ do jʌwateare bid̶a wãyã wãsid̶aa. Do zaque b̶ea caita Ar abadad̶aa wãsid̶aa Moab drua orrocawa. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Mamaʌba israelerãra baido juebada uria Beer abadad̶aa wãsid̶aa. Mama Ãcõrẽba Moisea nãwã jarasia: –Purura ãbaa jʌredua. Mʌ̃a ãdjirãa baidoda diaya.– ");
INSERT INTO empNTpo_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Maʌ̃ne israelerãra nãwã trʌ̃ãsid̶aa: Baido juebada uriara bogadrʌ b̶adua. Maʌ̃ baido carea trʌ̃ãnia. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Dadjirã bororãba ãdji bacuruba naʌ̃ baido juebada uriara corosid̶aa. Dji dromarãba ãdji bardonaba corosid̶aa. Mama ẽjũã põãsa ewaraga b̶ʌd̶eba Matanánaa wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Mamaʌba Najalield̶aa wãsid̶aa. Mamaʌba Bamod̶aa wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Mamaʌba jewed̶a Moab druad̶e b̶ʌd̶e jũẽne wãnaped̶a Pisga eyad̶e duanesid̶aa. Pisga eyad̶eba Jesimoʌ̃ ẽjũã põãsa ewaraga b̶ʌra unubaria. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Maʌ̃be israelerãba amorreorã boro Sehoʌ̃ abadamaa ʌ̃cʌrʌ diabuesia nãwã jarad̶amãrẽã: ");
INSERT INTO empNTpo_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","–Dai quĩrã djuburia bʌ druad̶e idu wãyã wãbidua. Dairãra bãrã néud̶e ed̶a wãnaẽ́a, bãrã uva ẽjũãne bid̶a ed̶a wãnaẽ́a, ni bãrã baido juebada uriad̶ebemada dod̶aẽ́a. Ẽberãrã Boro abada od̶e quĩrãipa wãnia.– ");
INSERT INTO empNTpo_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Baribʌrʌ Sehoʌ̃ba israelerãra idji druad̶e idu wãbiẽ́ basía. Idji sordaorãra jũma trʌ̃cuaped̶a ẽjũã põãsa ewaraga b̶ʌd̶e israelerãmaa wãnaped̶a Jahaza puru caita djõsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Baribʌrʌ israelerãba ãdjirãra poyad̶aped̶a ãdji druara jãrĩsid̶aa Arnoʌ̃ dod̶eba ab̶a Jabó dod̶aa amonitarã drua daucha. Amonitarãba ãdji druara bio waga eropanasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israelerãba amorreorã puru b̶eada jũma poyasid̶aa; dji puru droma Hesboʌ̃ abadara, puru zaquerã sid̶a. Poyad̶aped̶a maʌ̃ purud̶e panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Amorreorã boro Sehoʌ̃ra Hesboʌ̃ purud̶e b̶abadjia. Naẽna idjira moabitarã boro ume djõped̶a ãdji druara jũma jãrĩsia ab̶a Arnoʌ̃ do daucha. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Maʌ̃ carea nãwã jarabadaa: ¡Hesboʌ̃ purura wayacusa od̶e zed̶adua! Sehoʌ̃ purura idji b̶ad̶a quĩrãca bia od̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Sehoʌ̃ sordaorãra Hesboʌ̃ purud̶eba wãsid̶aa. Tʌbʌ urua eradrʌbʌrʌ quĩrãca Sehoʌ̃ purud̶eba wãsid̶aa. Maʌ̃ne Ar puru Moab druad̶e b̶ʌra babuesid̶aa. Arnoʌ̃ do icawa eyad̶e b̶ea puru sid̶a jũma babuesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","¡Ay, moabitarã! ¡Bãrãra mĩã djuburi b̶eaa! Bãrã ãcõrẽ Quemo ẽpẽbadara beusid̶aa. Amorreorã boro Sehoʌ̃ba bãrã warrarãra memenebisia. Bãrã caurãra jida edesia. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Baribʌrʌ dadjirãba ãdjira jũma poyasid̶aa. Hesboʌ̃ purud̶eba ab̶a Diboʌ̃ purud̶aa jũma quenasid̶aa. Nopa purud̶eba ab̶a Medebá purud̶aa jũma ãrĩnaped̶a babuesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Mãwã israelerãra amorreorã druad̶e panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Maʌ̃ne Moiseba ʌ̃cʌrʌ diabuesia Jazer drua acʌd̶amãrẽã. Israelerãba puru maʌ̃ druad̶e b̶eara poyad̶aped̶a amorreorãra ãyã jʌretasid̶aa. Mama bid̶a israelerãra panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Mamaʌba israelerãra Basaʌ̃naa wãbada od̶e wãsid̶aa. Maʌ̃ne Basaʌ̃nebema boro Og abadaba idji sordaorãda Edrei puru b̶ʌmaa edesia israelerã ume djõni carea. ");
INSERT INTO empNTpo_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Mãwã panʌne Ãcõrẽba Moisea jarasia: –Ne wayarãdua. Mʌ̃a idjida, idji sordaorã sid̶a bãrãa jũma poyabiya. Idji drua sid̶a mʌ̃a bãrãa diaya. Bãrãba Hesboʌ̃ne b̶ad̶a amorreorã boro Sehoʌ̃ beaped̶ad̶a quĩrãca idji sid̶a bead̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Ara maʌ̃da israelerãba Basaʌ̃nebema boro Og abadara, idji warrarãra, idji sordaorã sid̶a jũma quenasid̶aa. Ni ab̶aʌda zocai b̶ʌd̶aẽ́ basía. Maʌ̃be idji druara jũma edasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Maʌ̃be israelerãra Moab drua jewed̶a b̶ʌmaa wãbʌrʌsid̶aa. Mama Jordaʌ̃ do caita duanesid̶aa. Wa quĩrãrẽ ãdjirã quĩrãpe Jerico puruda b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","4","Maʌ̃ ewarid̶e Zipor warra Baláda moabitarã boro basía. Maʌ̃ Balába cawasia israelerãba amorreorãda poyad̶aped̶a ãdji druara jãrĩsid̶ada. Idjira, jũma moabitarã sid̶a bio ne waya duanesid̶aa israelerã cãbana panʌ bẽrã. Maʌ̃ carea moabitarãba Madiaʌ̃nebema dji dromarãa jarasid̶aa: –Naʌ̃ israelerãra cãbana panʌ bẽrã dadjirã druara jũma jãrĩnia pacaba chirua jũma cobari quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Maʌ̃ bẽrã moabitarã boro Balába ʌ̃cʌrʌ diabuesia Beor warra Balaaʌ̃ trʌ̃ne. Maʌ̃ Balaaʌ̃ra Amav druad̶e b̶abadjia Petor purud̶e. Petor purura Euprate do icawa b̶asia. Balába nãwã jarabisia: “Egiptod̶eba israelerãda mʌ̃ druad̶e cãbana duanane zesid̶aa. Ãdjirãba mʌ̃ druara ab̶ed̶a birasia. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Ãdjirãra dairã cãyãbara ʌb̶ʌara panʌa. Maʌ̃ bẽrã ãdjirã biẽ́ jara b̶ʌd̶e zedua. Mãwã mʌ̃a ãdjirãra poyaped̶a mʌ̃ druad̶ebemada ãyã jʌrecuaisicada. Mʌ̃a cawa b̶ʌa bʌa bariduada bia jara b̶ʌibʌrʌ, maʌ̃gʌra bia b̶ebaria. Idjab̶a bariduada biẽ́ jara b̶ʌibʌrʌ, maʌ̃gʌra biẽ́ b̶ebaria.” ");
INSERT INTO empNTpo_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Moab druad̶ebema dji dromarãra, Madiaʌ̃nebema dji dromarã sid̶a Balaaʌ̃maa wãsid̶aa. Paratada Balaaʌ̃a diad̶i carea edesid̶aa israelerã biẽ́ jara b̶ʌd̶e zemãrẽã. Balaaʌ̃ma jũẽsid̶ad̶e jũma Balába jarabid̶ada nẽbʌrʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaaʌ̃ba jarasia: –Nama cãĩnadua. Nubʌrʌ mʌ̃a bãrãa jaraya Ãcõrẽba mʌ̃ra idu wãbida wa idu wãbiẽ́da.– Mãwã jarad̶a bẽrã Moab druad̶ebema dji dromarãra mama cãĩsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Maʌ̃ diamasi Ãcõrẽra Balaaʌ̃ma odjaped̶a nãwã iwid̶isia: –¿Ẽberãrã bʌ ded̶e panʌra cairãda jãwã panʌ? ");
INSERT INTO empNTpo_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaaʌ̃ba Ãcõrẽa panusia: –Naʌ̃ ẽberãrãra moabitarã boro Zipor warra Balába nãwã jarad̶amãrẽã diabuesia: ");
INSERT INTO empNTpo_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","“Egiptod̶eba ẽberãrãda cãbana mʌ̃ druad̶e jũẽsid̶aa. Mʌ̃ druara maʌ̃ ẽberãrãba ab̶ed̶a birasia. Maʌ̃ carea ãdjirã biẽ́ jara b̶ʌd̶e zedua. Mãwã mʌ̃a ãdjirãra poyaped̶a mʌ̃ druad̶ebemada poya ãyã jʌrecuaisicada.”– ");
INSERT INTO empNTpo_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Ãcõrẽba Balaaʌ̃a jarasia: –Naʌ̃ ẽberãrã ume wãrãdua. Ãdjia jara panʌ ẽberãrãra biẽ́ jara b̶ʌrãdua mʌ̃a ãdjirãra careba b̶ʌ bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Nurẽma Balaaʌ̃ra pirab̶ariped̶a Balába diabued̶a dji dromarãa nãwã jarasia: –Bãrã druad̶aa jẽda wãnadua. Ãcõrẽba mʌ̃ra bãrã ume idu wãbiẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Moab druad̶ebema dji dromarãra jẽda Balámaa wãnaped̶a jarasid̶aa: –Balaaʌ̃ra dairã ume ze quĩrĩãẽ́ basía.– ");
INSERT INTO empNTpo_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Maʌ̃ carea Balába wayacusa dewararãda Balaaʌ̃maa diabuesia. Maʌ̃gʌrãra dji naãrã wã panana cãyãbara dji dromaara b̶easia idjab̶a cãbanaara wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ãdjirãra Balaaʌ̃ma jũẽnaped̶a jarasid̶aa: –Zipor warra Balába nãwã jarabisia: “Mʌ̃ quĩrã djuburia bʌra mʌ̃maa ze ama b̶arãdua. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Mʌ̃a bʌ́a paratada waib̶ʌa diaya. Idjab̶a jũma bʌa jarabʌrʌ quĩrãca mʌ̃a oya. Maʌ̃ bẽrã mʌ̃ quĩrã djuburia naʌ̃ ẽberãrãra biẽ́ jara b̶ʌd̶e zedua.”– ");
INSERT INTO empNTpo_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Baribʌrʌ Balaaʌ̃ba panusia: –Balába idji de parataba idjab̶a oroba bira cob̶ʌda diabʌrʌ sid̶a mʌ̃a ni cãrẽ sid̶a oẽ́a mʌ̃ Boro Ãcõrẽba mãwã obiẽ́bʌrʌ. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Mʌ̃ djuburia bãrã sid̶a id̶i nama cãĩnadua. Naʌ̃ diamasi Ãcõrẽba mʌ̃́a quĩrã awara jaraisicada.– ");
INSERT INTO empNTpo_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Maʌ̃ diamasi Ãcõrẽra Balaaʌ̃ma odjaped̶a nãwã jarasia: –Naʌ̃ ẽberãrãba bʌ jʌrʌd̶e ze panʌ bẽrã ãdjirã ume wãdua. Baribʌrʌ ab̶abe odua mʌ̃a bʌ́a jarabʌrʌ quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Nurẽma Balaaʌ̃ra pirab̶ariped̶a idji burro ʌ̃rʌ̃ chũmebarira jʌ̃ped̶a Moab druad̶ebema dji dromarã ume wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Balaaʌ̃ nezocarãda umé idji ume wãsid̶aa. Idjira burro ʌ̃rʌ̃ nĩbasia. Baribʌrʌ idji wãbʌrʌ carea Ãcõrẽra bio quĩrũsia. Maʌ̃ bẽrã Ãcõrẽ nezoca bajãnebemada idji nocod̶aa wãrãmãrẽã o ẽsidra nũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Djõbada necoda idji jʌwad̶e erob̶asia. Balaaʌ̃ burroba idjira o ẽsidra nũmʌda unusid̶e o ãyã wãsia. Maʌ̃ carea Balaaʌ̃ba idji burrora ubadjia wayacusa od̶aa wãmãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Nocod̶aa wãbʌdad̶e uva ẽjũãne jũẽsid̶aa. Dji ora maʌ̃ ẽjũã ẽsi wãbadjia. Orroza ẽjũãra mõgaraba aud̶u jũrã ca b̶asia. Mama pẽsua wãbadjid̶aa maʌ̃ mõgaraba aud̶u jũrã ca b̶ʌ ẽsi. Maʌ̃be Ãcõrẽ nezoca bajãnebemara wayacusa o ẽsidra nũmesia Balaaʌ̃ nocod̶aa wãrãmãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Balaaʌ̃ burroba Ãcõrẽ nezoca bajãnebema unusid̶e dji mõgaraba aud̶u jũrã ca b̶ʌd̶aa catʌ ʌra nĩbad̶e wãsia. Maʌ̃ba Balaaʌ̃ jĩrũra catʌ ʌrratʌ edesia. Maʌ̃ carea Balaaʌ̃ba idji burrora wayacusa u jidasia. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Maʌ̃be o pẽsua wãbadad̶e Ãcõrẽ nezoca bajãnebemara ãdji nocoare nũmane wãsia. Mama poya ãyã wãẽ́ b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Mama Balaaʌ̃ burroba Ãcõrẽ nezoca bajãnebema waya unusid̶e ab̶ed̶a egode tab̶esia. Maʌ̃ carea Balaaʌ̃ra bio quĩrũped̶a idji burrora bacuruba wayacusa u jidasia. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Maʌ̃ne Ãcõrẽba Balaaʌ̃ burrora bed̶eabisia. Dji burroba iwid̶isia: –¿Mʌ̃a cãrẽda od̶a bẽrã bʌa mʌ̃ra jãwã b̶arima ũbea usí?– ");
INSERT INTO empNTpo_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaaʌ̃ba panusia: –Jãwã o b̶ʌa bʌa mʌ̃ra mĩã sẽ b̶ʌ bẽrã. ¡Necoda mʌ̃ jʌwad̶e erob̶ʌbara ara nawena bʌra beatacasia!– ");
INSERT INTO empNTpo_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Maʌ̃ne burroba jarasia: –Mʌ̃ra bʌ burroa. Bʌa mʌ̃ edad̶a ewarid̶eba mʌ̃ ʌ̃rʌ̃ nĩbabaria. Bʌa bio cawa b̶ʌa naʌ̃ naẽna mʌ̃ra bʌ ume jãwã nĩbaca basida.– Balaaʌ̃ba jarasia: –Wãrãda mãwã b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Maʌ̃be Ãcõrẽba idji nezoca bajãnebemara o ẽsidra nũmʌda Balaaʌ̃a unubisia. Djõbada neco idji jʌwad̶e erob̶ʌ sid̶a unusia. Maʌ̃ne Balaaʌ̃ra chĩrãborod̶e b̶arru cob̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Ãcõrẽ nezoca bajãnebemaba Balaaʌ̃a jarasia: –¿Bʌa cãrẽ cãrẽã bʌ burrora b̶arima ũbea usí? Mʌ̃abʌrʌ ora jũãtrʌ erob̶ʌa bʌ nocod̶aa wãrãmãrẽã. Bʌa od̶e wãbʌrʌra mʌ̃a quĩrĩãẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Bʌ burroba mʌ̃da b̶arima ũbea unuped̶a mʌ̃ caita zeẽ́ basía. Mʌ̃ caita zed̶abara mʌ̃a bʌra beacasia baribʌrʌ bʌ burrora zocai b̶ʌcasia.– ");
INSERT INTO empNTpo_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaaʌ̃ba panusia: –Mʌ̃a cadjiruada osia. Adua b̶asia bʌdrʌ o ẽsidra nũmʌda mʌ̃ nocod̶aa wãrãmãrẽã. Bʌmaarã mʌ̃da Balámaa wãida biẽ́ b̶ʌbʌrʌ, jẽda wãya.– ");
INSERT INTO empNTpo_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ãcõrẽ nezoca bajãnebemaba jarasia: –Naʌ̃ ẽberãrã ume bʌra wãida b̶ʌa, baribʌrʌ ab̶abe mʌ̃a jarabi b̶ʌdrʌ jaradua.– Ara maʌ̃da Balaaʌ̃ra Balába diabued̶a dji dromarã ume wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balába Balaaʌ̃ zebʌrʌ cawasid̶e Ar purud̶aa audiab̶arid̶e wãsia. Ar purura Arnoʌ̃ do icawa b̶ʌa Moab drua daucha. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaaʌ̃ jũẽsid̶e Balába idjía jarasia: –Mʌ̃a bʌ naãrã trʌ̃bisid̶e ¿cãrẽ cãrẽã isabe zeẽ́ basi? ¿Mʌ̃a paratada waib̶ʌa poya diaẽ́da crĩcha b̶asica?– ");
INSERT INTO empNTpo_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaaʌ̃ba panusia: –Bʌa trʌ̃bued̶a bẽrã mʌ̃ra nama b̶ʌa. Baribʌrʌ mʌ̃a bariduada jaracara b̶ʌa. Ab̶abe Ãcõrẽba jarabi b̶ʌdrʌ jaraida b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Maʌ̃be Balaaʌ̃ra Balá ume Quiriat-huzot purud̶aa wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Mama Balába pacada, oveja sid̶a beaped̶a dji dragada Ãcõrẽa babue diasia. Dji djarada Balaaʌ̃a, idji ume panʌ dji dromarãa bid̶a cod̶amãrẽã diasia. ");
INSERT INTO empNTpo_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Nurẽma diaped̶ed̶a Balába Balaaʌ̃ra eya Bamo-baal abadad̶e ʌ̃taa edesia. Mamaʌba israelerã caitaara panʌra unusia. ");
INSERT INTO empNTpo_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaaʌ̃ba Baláa jarasia: –Nama animarã babue diabadada siete odua. Maʌ̃be paca dji umaquĩrãda siete idjab̶a oveja dji umaquĩrãda siete enedua Ãcõrẽa babue diad̶i carea.– ");
INSERT INTO empNTpo_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Ara maʌ̃da Balába osia Balaaʌ̃ba jarad̶a quĩrãca. Animarã babue diabadaza ãdji umérãba pacada ab̶a idjab̶a ovejada ab̶a Ãcõrẽa babue diasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Maʌ̃be Balaaʌ̃ba jarasia: –Nama jʌ̃ãdua bʌa animarã Ãcõrẽa babue dia b̶ʌma. Mʌ̃ra awuá wãya. Mama Ãcõrẽra mʌ̃ma odjaisicada. Idjia mʌ̃́a bed̶easira bʌ́a jarad̶e zeya.– Mãwã jaraped̶a Balaaʌ̃ra eya zaque chirua neẽ́ b̶ʌd̶aa wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Mama Ãcõrẽra idjimaa zesia. Balaaʌ̃ba idjía jarasia: –Mʌ̃a animarã babue diabadara siete obisia. Maʌ̃za mʌ̃a paca zaqueda ab̶a idjab̶a ovejada ab̶a bʌ́a babue diasia.– ");
INSERT INTO empNTpo_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Maʌ̃ne Ãcõrẽba Balaaʌ̃a cawabisia cãrẽda jaraida b̶ʌda. Cawabiped̶a Balaaʌ̃a jarasia jẽda Balámaa jarad̶e wãmãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ara maʌ̃da jẽda wãsia. Jũẽbʌrʌd̶e Balaaʌ̃ba unusia Balára, jũma Moab druad̶ebema dji dromarã sid̶a Ãcõrẽa animarã babue dia panʌ caita duanʌda. ");
INSERT INTO empNTpo_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Maʌ̃be Balaaʌ̃ra nãwã bed̶easia: Moab druad̶ebema boro Balába mʌ̃ra Araʌ̃ druad̶eba zebisia. Ʌ̃mãdau odjabariare b̶ʌ drua eyaid̶a b̶ʌmaʌba mʌ̃ra zebisia. Idjia mʌ̃́a jarasia: “Mʌ̃ quĩrã djuburia israelerã biẽ́ jara b̶ʌd̶e zedua. Naʌ̃ Jacobod̶eba yõped̶ad̶arãra biẽ́ o b̶ʌdua.” ");
INSERT INTO empNTpo_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Mãwãmĩna Ãcõrẽba bia jara b̶ʌd̶a ẽberãrãda ¿mʌ̃a sãwã biẽ́ jara b̶ʌi? Ãcõrẽba bia o b̶ʌd̶a ẽberãrãda ¿mʌ̃a sãwã biẽ́ o b̶ʌi? ");
INSERT INTO empNTpo_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Naʌ̃ eya mõgaraid̶a b̶ʌd̶eba mʌ̃a israelerãra unu b̶ʌa. Naʌ̃ eya zaqued̶eba mʌ̃a ãdjirãra acʌ b̶ʌa. Jãʌ̃ purura ãdub̶a jĩga panabaria. Cawa panʌa ãdjirãra dewara puru quĩrãca panʌẽ́da. ");
INSERT INTO empNTpo_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Jacobod̶eba yõped̶ad̶arãra ĩbʌ quĩrãca zocãrã panʌ bẽrã ni ab̶aʌba ãdjirãra poya juachad̶aẽ́a. ¿Caiba israelerãra maãrĩ poya juachai? Jãʌ̃ ẽberãrã jipa b̶ea beubʌdad̶e bid̶a bia b̶ead̶ia. Mʌ̃ beubʌrʌd̶e ara ãdji quĩrãca b̶e quĩrĩã b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaaʌ̃ mãwã bed̶eabʌrʌ carea Balába quĩrũbid̶eba jarasia: –¿Bʌa cãrẽda jara b̶ʌ? Mʌ̃a bʌra zebisia mʌ̃ ume dji quĩrũda biẽ́ jara b̶ʌmãrẽã. Baribʌrʌ bʌa ãdjirãra bia jara b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balaaʌ̃ba panusia: –Mãwãra ¿Ãcõrẽba jarabi b̶ʌra mʌ̃a jaracara b̶ʌca?– ");
INSERT INTO empNTpo_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balába jarasia: –Wãna. Dewara orroare wãnia. Mamaʌba bʌa israelerãra unuya jũma poya unuẽ́mĩna. Mamaʌba ãdjirãra biẽ́ jara b̶ʌdua.– ");
INSERT INTO empNTpo_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Ara maʌ̃da Balába idjira Pisga eyad̶e ʌ̃taa edesia Zopiʌ̃ ẽjũãnaa. Mama Balába wayacusa animarã babue diabadada siete osia. Maʌ̃za paca dji umaquĩrãda ab̶a idjab̶a oveja dji umaquĩrãda ab̶a Ãcõrẽa babue diasia. ");
INSERT INTO empNTpo_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Maʌ̃be Balaaʌ̃ba idjía jarasia: –Nama jʌ̃ãdua bʌa animarã Ãcõrẽa babue dia b̶ʌmaa. Mʌ̃ra awuá wãya Ãcõrẽ ume bed̶eai carea.– ");
INSERT INTO empNTpo_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Mama Ãcõrẽra Balaaʌ̃maa zeped̶a cawabisia cãrẽda jaraida b̶ʌda. Cawabiped̶a Balaaʌ̃a jarasia jẽda Balámaa jarad̶e wãmãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ara maʌ̃da Balaaʌ̃ra jẽda wãsia. Jũẽbʌrʌd̶e unusia Balára jũma Moab druad̶ebema dji dromarã sid̶a Ãcõrẽa animarã babue dia panʌ caita duanʌda. Balába idjía iwid̶isia: –¿Ãcõrẽba cãrẽda jarasi?– ");
INSERT INTO empNTpo_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Maʌ̃ne Balaaʌ̃ra nãwã bed̶easia: Zipor warra Balá, mʌ̃a jara b̶ʌra bio quĩrãcuita ũrĩdua. ");
INSERT INTO empNTpo_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Ãcõrẽra ẽberã quĩrãca b̶ʌẽ́a. Idjira sewa ocaa. Idjia jarad̶ada quĩrã awara ocaa. Idjia jarabʌrʌra obaria. Idjia wãrãneba jarad̶ara obaria. ");
INSERT INTO empNTpo_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Idjia mʌ̃́a jarasia israelerã bia jara b̶ʌmãrẽã. Bia jara b̶ʌduad̶a ad̶a bẽrã mʌ̃a quĩrã awara jaracara b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Ãcõrẽba Jacobod̶eba yõped̶ad̶ara idu bia mĩgabiẽ́a. Idjia israelerãra idu sopuabiẽ́a. Ãcõrẽra ãdjirã ume b̶ʌa. Maʌ̃ bẽrã b̶ʌsrid̶a jara panʌa idjira ãdjirã boroda. ");
INSERT INTO empNTpo_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Ãcõrẽba ãdjirãra Egiptod̶eba ẽdrʌ enesia. Idjid̶eba ãdjirãra bio ʌb̶ʌa b̶eaa, paca mẽã warid̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Ni ab̶aʌba Jacobod̶eba yõped̶ad̶ara poya ne ãĩ od̶aẽ́a. Ni ab̶aʌba israelerãra poya biẽ́ b̶ʌd̶aẽ́a. Ẽberãrãba nãwã jarad̶ia: “Acʌdua sãwã Ãcõrẽba israelerãra bio careba b̶ʌda.” ");
INSERT INTO empNTpo_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Israelerãra imama quĩrãca panʌa. Jarra b̶ʌd̶e imamara ʌ̃nãũcaa, ãtebʌrʌ ne beaped̶a jũma cobaria. Dji oa sid̶a jũma senebaria. Ara maʌ̃ quĩrãca israelerãra ʌ̃nãũnaẽ́a ab̶a naʌ̃ druad̶ebema ẽberãrã jũma poyabʌdad̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balaaʌ̃ mãwã bed̶eabʌrʌ carea Balába quĩrũbid̶eba nãwã jarasia: –¡Bʌa naʌ̃ ẽberãrãda poya biẽ́ jara b̶ʌẽ́bʌrʌ chupeadua! ¡Ãdjirãra waa bia jara b̶ʌrãdua! ");
INSERT INTO empNTpo_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Maʌ̃ne Balaaʌ̃ba panusia: –¿Mʌ̃a ab̶abe Ãcõrẽba jarabid̶adrʌ jaraida b̶ʌad̶a asiẽ́ca? ");
INSERT INTO empNTpo_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Maʌ̃be Balába idjía jarasia: –Wãna. Mʌ̃a bʌra dewara orroare edeya. Ãĩbẽrã mamabʌrʌ Ãcõrẽba bʌ́a israelerãra idu biẽ́ jarabisicada.– ");
INSERT INTO empNTpo_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Ara maʌ̃da Balába idjira Peor eya borod̶aa edesia. Mamaʌba ẽjũã põãsa ewaraga b̶ʌra jũma unubaria. ");
INSERT INTO empNTpo_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Mama Balaaʌ̃ba jarasia: –Nama animarã babue diabadada siete odua. Paca dji umaquĩrãda siete idjab̶a oveja dji umaquĩrãda siete enedua Ãcõrẽa babue diad̶i carea.– ");
INSERT INTO empNTpo_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Ara maʌ̃da Balába osia Balaaʌ̃ba jarad̶a quĩrãca. Maʌ̃be animarã babue diabadaza pacada ab̶a idjab̶a ovejada ab̶a Ãcõrẽa babue diasia. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Baribʌrʌ Balaaʌ̃ba cawasia idjia israelerã bia jara b̶ʌra Ãcõrẽba bia unu b̶ʌda. Maʌ̃ bẽrã idjia naãrã o b̶ad̶a quĩrãca ãyã wãẽ́ basía Ãcõrẽba cãrẽda jarabi cawaya. Ãtebʌrʌ ẽjũã põãsa ewaraga b̶ʌd̶aa acʌ nũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Maʌ̃ne unusia Israeld̶eba yõped̶ad̶a doce puruda duanʌda. Ãdjirã acʌ nũmʌne Ãcõrẽ Jaured̶eba b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Maʌ̃ne nãwã bed̶easia: Mʌ̃ra Beor warra Balaaʌ̃a. Mʌ̃a ẽsã unu b̶ʌa. Mʌ̃ra nãwã bed̶ea b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Mʌ̃a ũrĩ b̶ʌa Ãcõrẽba jara b̶ʌda. Mʌ̃a ẽsã unu b̶ʌa Ãcõrẽ jũma poya b̶ʌba unubi b̶ʌda. Idji quĩrãpita chĩrãborod̶e cob̶ʌd̶e mʌ̃ dauba ẽsã unu b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Israelerã, bãrã wua dera bio biya qued̶eaa. Jacobod̶eba yõped̶ad̶arã, bãrã purura bio biya quirua. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Israel purura waib̶ʌa b̶ʌa do zaque drasoa b̶ʌ quĩrãca. Bio wari b̶ʌa néu do icawa u tab̶ʌ quĩrãca. Bio biya b̶ʌa áloe bacuru Ãcõrẽba ud̶a quĩrãca idjab̶a ogo do icawa nũmea quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Ãdjirãneba yõbʌdarãba baidoda ad̶uba eropanania. Ãdji zocod̶eba baidoda wewezoaya. Ãdji boroba amalecitarã boro Agáda poyaya. Ãdji boroba puruda zocãrã idji jʌwaed̶a erob̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Ãcõrẽba israelerãra Egiptod̶eba ẽdrʌ enesia. Idjid̶eba ãdjirãra bio ʌb̶ʌa b̶eaa, paca mẽã warid̶a quĩrãca. Ãdji dji quĩrũra jũma poyad̶ia imamaba animarã beaped̶a dji b̶ʌwʌrʌra b̶ʌagaped̶a jũma cobari quĩrãca. Ãdji dji quĩrũra chaba drʌ quenania. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Imamara egode chũmeped̶a ʌ̃nãũbaria. ¿Caiba idjira mĩã sẽi? Ara maʌ̃ quĩrãca Israel puruba ẽberãrãra poyaped̶a ʌ̃nãũya, dewararãba wayad̶i bẽrã. Jũma israelerã bia jara panʌ ẽberãrãra Ãcõrẽba carebaya. Baribʌrʌ jũma ãdji biẽ́ jara panʌra Ãcõrẽba biẽ́ b̶ʌya. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balaaʌ̃ mãwã bed̶eabʌrʌ carea Balára idji ume bio quĩrũsia. Quĩrũbid̶eba jʌwa taweped̶a jarasia: –¡Mʌ̃a bʌra zebisia mʌ̃ dji quĩrũra biẽ́ jara b̶ʌmãrẽã! ¡Mãwãmĩna b̶arima ũbea ãdjirãra bia jara b̶ʌsia! ");
INSERT INTO empNTpo_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","¡Bʌdji druad̶aa jẽda wãdua! Ãcõrẽba bʌ́a israelerãra idu biẽ́ jarabiẽ́ bẽrã parata waib̶ʌa diayad̶a ad̶ara mʌ̃a diaẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","13","Balaaʌ̃ba panusia: –Bʌa mʌ̃maa diabued̶a ẽberãrãa mʌ̃a ebud̶a nãwã jarasia: “Balába idji de parataba idjab̶a oroba bira cob̶ʌda diabʌrʌ sid̶a mʌ̃a ni cãrẽ sid̶a oẽ́a Ãcõrẽba mãwã obiẽ́bʌrʌ.” Ab̶abe Ãcõrẽba jarabi b̶ʌdrʌ jaraida b̶ʌad̶a asia. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Mʌ̃ druad̶aa jẽda wãya. Baribʌrʌ wãi naẽna mʌ̃a jaraya israelerãba jĩrũarebema ewarid̶e bʌ purura sãwã od̶ida.– ");
INSERT INTO empNTpo_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ara maʌ̃da Balaaʌ̃ra nãwã bed̶easia: Mʌ̃ra Beor warra Balaaʌ̃a. Mʌ̃a ẽsã unu b̶ʌa. Mʌ̃ra nãwã bed̶ea b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Ãcõrẽba jara b̶ʌra mʌ̃a ũrĩ b̶ʌa. Ãcõrẽ dji Dromaara b̶ʌ necawaada mʌ̃a erob̶ʌa. Ãcõrẽ jũma poya o b̶ʌba unubi b̶ʌra mʌ̃a ẽsã unu b̶ʌa. Idji quĩrãpita chĩrãborod̶e cob̶ʌd̶e mʌ̃ dauba ẽsã unu b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Jĩrũarebema ewarid̶e cãrẽda sãwãida mʌ̃a ẽsã unu b̶ʌa. Mʌ̃a unu b̶ʌra ara nawenabemaẽ́a. Jacobod̶eba dji dromada zeya chĩdau ebud̶a odjabari quĩrãca. Israeld̶eba dji boroda zeya. Maʌ̃ba moabitarã borora jũma berradʌgaya. Séd̶eba yõped̶ad̶arã sid̶a jũma quenaya. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Idji dji quĩrũ Edoʌ̃nebemarãda poyaya. Ãdji drua Seír abadara idji jʌwaed̶a erob̶aya. Maʌ̃ne Israel purura ʌb̶ʌara wariya. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Jacobod̶eba yõna dji dromaba naʌ̃ Ar purud̶e panenara jũma quenaya. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Mãwã bed̶ead̶acarea Balaaʌ̃ba Amale purura ẽsã unuped̶a nãwã bed̶easia: Amale purura dji dromaara b̶ʌa. Baribʌrʌ ewari ab̶a nẽbaya. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Mãwã bed̶ead̶acarea Balaaʌ̃ba quenitarãda ẽsã unuped̶a nãwã bed̶easia: Quenitarã, bãrã dera bio o eropanʌa nejõbʌba idji de mõgara eya ʌ̃tʌ b̶ʌd̶e o erob̶ʌ quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Mãwãmĩna bãrãra nẽbad̶ia asiriarãba jũma ãyã jida edebʌdad̶e. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Maʌ̃ awara Balaaʌ̃ra nãwã bed̶easia: Ay, ¿caida zocai b̶ei Ãcõrẽba jũma nãwã obʌrʌd̶e? ");
INSERT INTO empNTpo_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Chipred̶eba barcoda zed̶ia. Maʌ̃ barcod̶e zebʌdaba Asiria druara, Hebere ẽberãrã sid̶a jũma poyad̶ia. Baribʌrʌ jĩrũare maʌ̃ barcod̶e zeped̶ad̶a sid̶a nẽbad̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Mãwã jarad̶acarea Balaaʌ̃ra idji druad̶aa jẽda wãsia. Balá sid̶a idji od̶e jẽda wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israelerã Sitiʌ̃ne duanasid̶ad̶e ʌ̃cʌrʌ umaquĩrãrãba moabitarã wẽrãrã ume cadjiruada o duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Maʌ̃ wẽrãrãba dji umaquĩrãrãra ed̶obadjid̶aa moabitarãba ãdji ãcõrẽa animarã babue diabʌdad̶e. Maʌ̃ne umaquĩrãrãra ne cod̶aped̶a maʌ̃ ãcõrẽ quĩrãpita chĩrãborod̶e copanenaped̶a bia bed̶eabadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Mãwã israelerãba moabitarã ãcõrẽ Baal-peor abadada ẽpẽ panesid̶aa. Maʌ̃ carea Ãcõrẽra israelerã ume bio quĩrũped̶a quinibibʌrʌ basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Maʌ̃ne Ãcõrẽba Moisea jarasia: –Jũma Baal-peor ẽpẽ panʌ dji bororãda jidad̶aped̶a bead̶adua. Mʌ̃ quĩrãpita ãsa ãdjirãra bacuru cũmiane ʌ̃tʌ su jira b̶ʌd̶adua jũmarãba acʌd̶amãrẽã. Mãwãbʌrʌ mʌ̃ quĩrũbira bãrã israelerã ume b̶ʌda tumaya.– ");
INSERT INTO empNTpo_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Ara maʌ̃da Moiseba israelerã bororãa jarasia: –Bãrã jʌwaed̶a b̶earã dji Baal-peor ẽpẽ b̶eada jũma bead̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Maʌ̃ne Moisera puru sid̶a Ãcõrẽ wua ded̶e ed̶a wãbada caita sopuaba jĩã duanasid̶aa. Moiseba acʌ b̶ʌd̶e, puruba acʌ b̶ʌd̶e bid̶a Israeld̶ebema ab̶aʌba madianita wẽrãda diguid̶aa edesia. ");
INSERT INTO empNTpo_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Maʌ̃ unusid̶e Eleaza warra Pinéra israelerã ãbaa dji jʌre panʌmaʌba idji mĩãsu edad̶e wãsia. (Pinéra sacerdote Aaroʌ̃ wiuzaque basía.) ");
INSERT INTO empNTpo_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Idji mĩãsura edaped̶a dji ẽberã caid̶u wãsia. Maʌ̃ ẽberã wua ded̶e ed̶a wãped̶a dji umaquĩrãra dji wẽrã ume ãbaa b̶id̶e su beasia. Mãwã bead̶a bẽrã israelerã quini nũmanara waa quininaẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Mãwãbʌrʌbara 24,000 ẽberãrãra quininoasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Maʌ̃be Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","–Mʌ̃a quĩrĩã b̶ʌa israelerãba ab̶abe mʌ̃drʌ ẽpẽnida. Maʌ̃ carea Baal-peor ẽpẽsid̶ad̶e mʌ̃ quĩrũbid̶eba ãdjirãra jũma quinibi basía. Baribʌrʌ Eleaza warra Pinéba mʌ̃ quĩrũbira tumabisia. Idjia od̶ad̶eba unubisia idjia bid̶a quĩrĩã b̶ʌda ẽberãrãba ab̶abe mʌ̃drʌ ẽpẽnida. Idjia od̶a carea mʌ̃a israelerãra jũma quinibiẽ́ basía. (Pinéra sacerdote Aaroʌ̃ wiuzaque basía.) ");
INSERT INTO empNTpo_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Pinéa jaradua idjia od̶a carea mʌ̃ra idji ume bed̶ea b̶ʌbʌrʌda idji ume necai b̶ai carea. ");
INSERT INTO empNTpo_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Mʌ̃a bed̶ea b̶ʌbʌrʌba jara b̶ʌa idjira, idjid̶eba yõbʌdarã sid̶a id̶iba ʌ̃taa mʌ̃ sacerdoterãda b̶ead̶ida. Mãwã obʌrʌa idjia quĩrĩã b̶ʌ bẽrã ẽberãrãba ab̶abe mʌ̃drʌ ẽpẽnida. Mʌ̃ igara b̶ʌda bead̶a bẽrã israelerãba cadjirua oped̶ad̶ara mʌ̃́a quĩrãdoabisia.– ");
INSERT INTO empNTpo_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Ẽberã madianita wẽrã ume ãbaa beud̶ara Zimri abadjid̶aa. Idjira Salu warra basía. Simeoʌ̃neba yõna purud̶ebema dji droma basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Dji madianita wẽrã trʌ̃ra Cozbi abadjid̶aa. Idjira Zu cau basía. Zura Madiaʌ̃nebema dji droma basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Maʌ̃be Ãcõrẽba Moisea jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","–Madianitarãda quenane wãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Mãwã od̶ad̶ua ãdjirãba bãrãra quinibisid̶a bẽrã. Cũrũga panʌneba bãrãa ãdji ãcõrẽ Baal-peor abadada ẽpẽbisid̶aa mʌ̃a bãrãra quinibimãrẽã. Cozbiba od̶a carea bid̶a mʌ̃a bãrãra quinibibʌrʌ basía. Baal-peor ẽpẽ panʌ carea bãrã quinibʌda basid̶e Pinéba maʌ̃ wẽrãra beasia.– (Cozbira Madiaʌ̃nebema dji droma cau basía.) ");
INSERT INTO empNTpo_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Wẽrãrãda juesuma panasid̶aa: Maala, Noa, Hogla, Milca idjab̶a Tirsa. Ãdji zeza querasira Zelopeha basía. Idjira Jose warra Manased̶eba yõna basía. Heper warra basía idjab̶a Gala wiuzaque basía. Galara Maqui warra basía. Maquira Manase warra basía. ");
INSERT INTO empNTpo_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Ewari ab̶a Zelopeha querasi caurãra Ãcõrẽ wua ded̶e ed̶a wãbadamaa wãsid̶aa. Mama Moise quĩrãpita, sacerdote Eleaza quĩrãpita, puru quĩrãpita bid̶a nũpanenaped̶a nãwã jarasid̶aa: ");
INSERT INTO empNTpo_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","–Dai zezara ẽjũã põãsa ewaraga b̶ʌd̶e jaid̶asia. Coreba, idjiare b̶ea bid̶a Ãcõrẽ igarasid̶ad̶e dai zezara beuẽ́ basía, ãtebʌrʌ idjia cadjirua od̶a carea jaid̶asia. Idjira umaquĩrã warra neẽ́ b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Daimaarã biẽ́ b̶ʌa maʌ̃ carea dai, idjid̶eba yõbʌdarãba ẽjũãda edad̶aẽ́da. Dai zeza djabarãba edabʌda ẽjũãnebemada dairãa bid̶a diad̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Ãdjia bed̶ea djuburia panʌra Moiseba Ãcõrẽa jarasia. ");
INSERT INTO empNTpo_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Maʌ̃ne Ãcõrẽba panusia: ");
INSERT INTO empNTpo_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","–Zelopeha caurãba arid̶e jara panʌa. Ãdji zeza djabarãba edabʌda ẽjũãnebemada diad̶adua ãdjid̶eba yõbʌdarãba erob̶ead̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Israelerãa nãwã jaradua: “Ab̶aʌda umaquĩrã warra neẽ́ jaid̶aibʌrʌ, idji ẽjũãra dji caua diad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Baribʌrʌ idjia cau sid̶a neẽ́ b̶ʌbʌrʌ, ẽjũãra idji djabarãa diad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Djabarã sid̶a neẽ́ b̶ʌbʌrʌ, ẽjũãra idji zeza djabarãa diad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Idji zeza bid̶a djabarãda neẽ́ b̶ʌbʌrʌ, idji ẽberãrãnebema dji caitaara b̶ʌ́a diad̶adua maʌ̃gʌd̶e bamãrẽã.” Israelerãba maʌ̃ leyra ẽpẽnida panʌa mʌ̃a bʌ́a jara b̶ʌ quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Maʌ̃be Ãcõrẽba Moisea jarasia: –Abariʌ̃ eyad̶e ʌ̃taa wãdua. Mamaʌba mʌ̃a israelerãa diai druara acʌdua. ");
INSERT INTO empNTpo_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Maʌ̃ drua ununacarea bʌra jaid̶aya bʌ djaba Aaroʌ̃ jaid̶ad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Mãwã jaid̶aya bãrãba Ziʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶e mʌ̃a jarad̶ara ĩjã od̶aẽ́ basi bẽrã. Mama israelerãba quĩrũbid̶eba baido iwid̶isid̶ad̶e bãrãba ãdjirãa mʌ̃ra wãrãda Ãcõrẽda cawabid̶aẽ́ basía.– (Maʌ̃ra mãwãsia Ziʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶e Cadé abadama. Mama Ãcõrẽba mõgarad̶eba baido weabid̶ama trʌ̃ b̶ʌsid̶aa “Meribá.”) ");
INSERT INTO empNTpo_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Moiseba jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","–Mʌ̃ Boro Ãcõrẽ, bʌd̶eba jũmarãda zocai b̶eaa. Maʌ̃ bẽrã mʌ̃ cacuabari ab̶a b̶ʌdua naʌ̃ puru boro bamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Maʌ̃ ẽberãra puru na nĩbaida b̶ʌa bia pe enibai carea. Mãwã bʌ purura oveja dji wagabari neẽ́ b̶ʌ quĩrãca b̶aẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","19","Ãcõrẽba jarasia: –Mãẽteara israelerã boro bamãrẽã Nuʌ̃ warra Josueda b̶ʌdua. Idjia mʌ̃ Jaureda erob̶ʌa. Idjira sacerdote Eleaza quĩrãpita, puru quĩrãpita bid̶a ededua. Mama bʌ jʌwara idji boro ʌ̃rʌ̃ b̶ʌdua acʌbi carea idjira ãdji boroda b̶ʌbʌrʌda. ");
INSERT INTO empNTpo_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Idjira b̶ʌdua berara ne jũmane bʌa o b̶ad̶a quĩrãca poya o b̶amãrẽã. Mãwã Israel puruba jũma idjia jarabʌrʌra ĩjã o panania. ");
INSERT INTO empNTpo_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Israelerã boro b̶ed̶acarea Josuera sacerdote Eleazamaa wãida b̶ʌa mʌ̃a quĩrĩã b̶ʌra cawai carea. Mʌ̃ quĩrãpita b̶ʌd̶e Eleazaba Uriʌ̃ abadad̶eba mʌ̃a quĩrĩã b̶ʌra cawaya. Maʌ̃be idjia jarabʌrʌra Josueba, israelerã bid̶a jũma ĩjã o pananida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Ara maʌ̃da Moiseba osia Ãcõrẽba jarad̶a quĩrãca. Josuera edesia sacerdote Eleaza quĩrãpita, puru quĩrãpita bid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Mama idji jʌwara Josue boro ʌ̃rʌ̃ b̶ʌsia acʌbi carea Josuera ãdjirã boroda b̶ʌbʌrʌda Ãcõrẽba jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Rubeʌ̃neba yõped̶ad̶aba, Gad̶eba yõped̶ad̶a bid̶a pacada, oveja sid̶a zocãrã eropanasid̶aa. Ãdjirãba cawasid̶aa Jazer ẽjũãra Gala ẽjũã sid̶a animarã daupẽni carea bia b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Maʌ̃ bẽrã Moisemaa, sacerdote Eleazamaa, israelerã dji dromarãmaa bid̶a wãnaped̶a nãwã jarasid̶aa: ");
INSERT INTO empNTpo_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","–Ãcõrẽba dadjirãa naʌ̃ puru b̶eada poyabisia: Atarot, Diboʌ̃, Jazer, Nimra, Hesboʌ̃, Eleale, Sebaʌ̃, Nebo, Beoʌ̃ sid̶a. Maʌ̃ ẽjũãra bio bia b̶ʌa animarã daupẽni carea. Dairãba animarãda zocãrã eropanʌa. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Maʌ̃ bẽrã dai quĩrã djuburia maʌ̃ ẽjũãra dairãa diad̶adua. Dairãra Jordaʌ̃ do wa quĩrãrã wãbirãnadua.– ");
INSERT INTO empNTpo_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Baribʌrʌ Moiseba panusia: –Mãwãra dewararã nocod̶aa djõne wãbʌdad̶e ¿bãrãra nama panenica? ");
INSERT INTO empNTpo_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Bãrãda nama panesid̶ara ¿dewararã sid̶a Ãcõrẽba diad̶a ẽjũãnaa wãna ama panenaẽ́ca? ");
INSERT INTO empNTpo_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","¿Ara maʌ̃ quĩrãca bãrã drõã naẽnabemarãba osid̶aẽ́ca mʌ̃a ãdjirã Cadé-barnead̶eba Canaaʌ̃ drua acʌd̶e diabuesid̶e? ");
INSERT INTO empNTpo_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Jũma maʌ̃ drua pʌrrʌa acʌd̶aped̶a Escol jewed̶ad̶e jũẽne wãsid̶aa. Baribʌrʌ jẽda zed̶aped̶a ẽjũãra biẽ́ tab̶ʌad̶a asid̶aa, purura Ãcõrẽba dia b̶ʌ ẽjũãnaa wãrãnamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","11","Maʌ̃ carea Ãcõrẽra ãdjirã ume bio quĩrũsia. Maʌ̃ ewarid̶e idjia wãrãneba jarasia jũma Egiptod̶eba ẽdrʌped̶ad̶arã veinte poa ʌ̃taa b̶eaba sod̶eba ĩjãnaẽ́ bẽrã, idjia Abrahaʌ̃a, Isaa, Jacoboa bid̶a diai jarad̶a ẽjũãra ununaẽ́da. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Ab̶abe Jepone warra Calebʌrʌ idjab̶a Nuʌ̃ warra Josue bid̶a sod̶eba ĩjã panʌ bẽrã maʌ̃ ẽjũãra ununiana asia. (Jeponera cenezeo basía.) ");
INSERT INTO empNTpo_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Maʌ̃ ewarid̶e Ãcõrẽra dadji israelerã ume bio quĩrũna bẽrã, ẽjũã põãsa ewaraga b̶ʌd̶e cuarenta poa pʌrrʌabisia jũma maʌ̃ ẽberãrã Ãcõrẽ quĩrãpita biẽ́ oped̶ad̶a beubʌdamisa. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","¿Id̶i bid̶a bãrã zezarãba cadjirua oped̶ad̶a quĩrãca o quĩrĩã panʌca? ¡Bãrã dji cadjirua obadarãba wetara Ãcõrẽra dadji israelerã ume quĩrũbid̶ia! ");
INSERT INTO empNTpo_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Bãrãba Ãcõrẽda igara pananibʌrʌ, idjia dadjirãra wad̶ibid̶a naʌ̃ ẽjũã põãsa ewaraga b̶ʌd̶e pʌrrʌabiya. Mãwã bãrãra bed̶ead̶e panania jũma dadjirã biẽ́ panebʌda carea.– ");
INSERT INTO empNTpo_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Dji ẽjũã iwid̶i panʌra Moisemaa caitaara wãnaped̶a jarasid̶aa: –Dai boro, nama puru b̶eada o quĩrĩã panʌa dai wẽrãrã itea, dai warrarã itea bid̶a. Idjab̶a corra b̶eada o quĩrĩã panʌa dai animarã itea. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","18","Maʌ̃be dairãra djõne wãni carea panania. Bãrã djõne wãbʌdad̶e dairãra bãrã na nĩbad̶ia idjab̶a djõnia ab̶a jũmarãba ẽjũã edabʌdad̶aa. Mãwã djõ panʌne dairãra jẽda dai ẽberãrãmaa zed̶aẽ́a. Baribʌrʌ dai wẽrãrãra, dai warrarã sid̶a nama puru mõgaraba aud̶u jũrã ca b̶ead̶e duanania naʌ̃ druad̶ebemarãba bearãnamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Dairãra djõne wãbʌdamĩna Jordaʌ̃ do quĩrãrẽbema ẽjũãra edad̶aẽ́a bãrã quĩrãca, ãtebʌrʌ dairãba edabʌda ẽjũãra nama b̶aya Jordaʌ̃ dod̶eba ʌ̃mãdau odjabariare.– ");
INSERT INTO empNTpo_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","22","Moiseba ãdjirãa jarasia: –Bãrãba wãrãda mãwã od̶ibʌrʌ naʌ̃ ẽjũãra edad̶ia. Baribʌrʌ Ãcõrẽba jara b̶ʌ quĩrãca djõni carea pananida panʌa. Jũma bãrã dji mẽsrã b̶eada Jordaʌ̃ do wa quĩrãrẽ wãnaped̶a djõnida panʌa ab̶a Ãcõrẽba dji quĩrũrã ãyã jʌretabʌrʌd̶aa. Jũma maʌ̃ drua Ãcõrẽ jʌwaed̶a b̶ed̶acareabʌrʌ bãrãra namaa jẽda zed̶ida panʌa. Ãcõrẽba bãrãa waabemarã itea obi b̶ʌra jũma osid̶ara Ãcõrẽba jara b̶ʌ quĩrãca naʌ̃ ẽjũãra bãrãne baya. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Baribʌrʌ mãwã od̶aẽ́bʌrʌ bio cawad̶adua Ãcõrẽ quĩrãpita cadjiruad̶e pananida. Maʌ̃ cadjirua carea Ãcõrẽba bãrãra wãrãda cawa oya. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Bãrã ẽberãrã itea puru b̶eada naʌ̃ druad̶e ocuad̶adua. Idjab̶a bãrã animarã itea corra b̶eada naʌ̃ druad̶e ocuad̶adua. Baribʌrʌ wãrãda djõni carea pananadua bãrãba jara panʌ quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Maʌ̃be Gad̶eba yõped̶ad̶aba, Rubeʌ̃neba yõped̶ad̶a bid̶a panusid̶aa: –Dai boro, dairãba jũma od̶ia bʌa jara b̶ʌ quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Naʌ̃ Gala druad̶e b̶ea purud̶e dai wẽrãrãra, dai warrarãra, dai animarã sid̶a b̶eed̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Baribʌrʌ dairãra djõne wãni carea panʌa. Ãcõrẽba jarabʌrʌd̶e dairãra Jordaʌ̃ do wa quĩrãrẽ djõne wãnia bʌa jara b̶ʌ quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Maʌ̃be Moiseba sacerdote Eleazaa, Nuʌ̃ warra Josuéa, jũma Israeld̶eba yõped̶ad̶a puru bororãa bid̶a nãwã jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","–Dadji israelerã Jordaʌ̃ do wa quĩrãrẽ djõne wãbʌdad̶e Gad̶eba yõped̶ad̶ara, Rubeʌ̃neba yõped̶ad̶a sid̶a Ãcõrẽba jara b̶ʌ quĩrãca wãnibʌrʌ, maʌ̃ drua poyaped̶ad̶acarea bãrãba ãdjirãa naʌ̃ Gala druara diad̶adua ãdjirãne bamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Baribʌrʌ bãrã ume Jordaʌ̃ do wa quĩrãrẽ djõne wãnaẽ́bʌrʌ, ãdjirãba ẽjũãda Canaaʌ̃ druad̶e edad̶ida panʌa bãrã quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Gad̶eba yõped̶ad̶arãba, Rubeʌ̃neba yõped̶ad̶arã bid̶a jarasid̶aa: –Dai boro, dairãba jũma od̶ia Ãcõrẽba jara b̶ʌ quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Dairãra Jordaʌ̃ do wa quĩrãrẽ Canaaʌ̃ druad̶aa djõne wãnia Ãcõrẽba jara b̶ʌ quĩrãca. Baribʌrʌ dairãba edabʌda ẽjũãra Jordaʌ̃ do namaarecare b̶aya.– ");
INSERT INTO empNTpo_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Maʌ̃be Moiseba Gad̶eba yõped̶ad̶arãa, Rubeʌ̃neba yõped̶ad̶arãa, idjab̶a ʌ̃cʌrʌ Jose warra Manased̶eba yõped̶ad̶arãa bid̶a amorreorã boro Sehoʌ̃ba erob̶ad̶a druara, Basaʌ̃nebema boro Ogba erob̶ad̶a drua sid̶a diasia. Jũma maʌ̃ druara, puru b̶ea sid̶a ãdjirãa diasia. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Maʌ̃ druad̶e Gad̶eba yõped̶ad̶arãba naʌ̃ puru b̶eada wayacusa osid̶aa: Diboʌ̃, Atarot, Aroer, ");
INSERT INTO empNTpo_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atarot-sopaʌ̃, Jazer, Jogbeha, ");
INSERT INTO empNTpo_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bet-nimra idjab̶a Bet-Araʌ̃. Jũma maʌ̃ puru b̶eara mõgaraba aud̶u jũrã casid̶aa. Idjab̶a corra b̶eada ãdjirã animarã itea osid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Rubeʌ̃neba yõped̶ad̶arãba naʌ̃ puru b̶eada wayacusa osid̶aa: Hesboʌ̃, Eleale, Quiriataim, ");
INSERT INTO empNTpo_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, Baal-meoʌ̃, Sibmá sid̶a. Maʌ̃ puru b̶eara trʌ̃ awara b̶ʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Manase warra Maquid̶eba yõped̶ad̶arãda Gala druad̶aa wãnaped̶a amorreorã mama b̶eara poyad̶aped̶a ãyã jʌretasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Moiseba ãdjirãa maʌ̃ druara diad̶a bẽrã mama panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Manased̶eba yõna Jaír sid̶a wãped̶a ʌ̃cʌrʌ puru zaquerãda poyasia. Maʌ̃ puru b̶eara idjia trʌ̃ b̶ʌsia Havot-Jaír. ");
INSERT INTO empNTpo_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Ara maʌ̃ quĩrãca Nobá abadada wãped̶a puru zaquerã Kenat druad̶e b̶eara poyasia. Mama idjia trʌ̃ b̶ʌsia Nobá.");
INSERT INTO empNTpo_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","Maʌ̃be Moab drua jewed̶ad̶eba Moisera Pisga eyad̶e ʌ̃taa wãsia Nebo eya borod̶aa. Maʌ̃ eyara Jerico puru quĩrãpe b̶ʌa. Mamaʌba Ãcõrẽba Moisea Canaaʌ̃ druara jũma acʌbisia. Gala ẽjũãneba ab̶a Daʌ̃ purud̶aa acʌbisia. ");
INSERT INTO empNTpo_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","Neptalid̶eba yõped̶ad̶arãba edad̶i ẽjũãda, Epraiʌ̃neba yõped̶ad̶arãba edad̶i ẽjũãda, Manased̶eba yõped̶ad̶arãba edad̶i ẽjũã sid̶a jũma acʌbisia. Judad̶eba yõped̶ad̶arãba edad̶i ẽjũã sid̶a jũma acʌbisia ab̶a Pusa Mediterraneo daucha. ");
INSERT INTO empNTpo_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","Negue ẽjũãda, Jerico puru icawa b̶ʌ jewed̶a sid̶a jũma acʌbisia ab̶a Zoar purud̶aa. Jerico purura idjab̶a Uruta Puru abadaa. ");
INSERT INTO empNTpo_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Maʌ̃be Ãcõrẽba Moisea jarasia: –Mʌ̃a Abrahaʌ̃a, Isaa, Jacoboa bid̶a wãrãneba jarasia jãʌ̃ druara ãdjirãneba yõbʌdarãa diaida. Mʌ̃a jãʌ̃ druara bʌ́a idu unubi b̶ʌa, baribʌrʌ bʌra jãmaa wãẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Mãwãnacarea Ãcõrẽ nezoca Moisera Moab druad̶e jaid̶asia Ãcõrẽba jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","Idjira tʌb̶arisia Moab druad̶e b̶ʌ jewed̶ad̶e Bet-peor caita. Baribʌrʌ id̶i bid̶a idji tʌb̶arid̶ada ni ab̶aʌba adua panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Moisera 120 poa b̶ʌda jaid̶asia. Jaid̶asid̶e idjira dau towaẽ́ b̶asia idjab̶a wad̶ibid̶a cacua ʌb̶ʌa b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Moise jaid̶ad̶acarea Moab drua jewed̶ad̶e israelerãra jed̶eco ab̶a idji carea jĩã panasid̶aa ãdjia sopua ewari wagabada quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Maʌ̃be Nuʌ̃ warra Josuera israelerã boroda b̶esia. Moiseba idji jʌwara Josue ʌ̃rʌ̃ b̶ʌd̶a bẽrã Ãcõrẽba crĩcha cawaada diasia. Jũma Josueba jarabʌrʌda, jũma Ãcõrẽba Moised̶eba jarad̶a sid̶a israelerãba ĩjã o panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","Maʌ̃ ewarid̶eba Moise quĩrãca Ãcõrẽneba bed̶eabarida waa neẽ́ basía. Ãcõrẽra idji ume nẽbʌrʌbadjia. ");
INSERT INTO empNTpo_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","Maʌ̃ awara Ãcõrẽba ne ununaca Egiptod̶e obi jarad̶ada Moiseba jũma ocuasia. Moised̶eba Egiptod̶ebema borora, dji dromarãra, jũma egiptorã sid̶a cawa osia. ");
INSERT INTO empNTpo_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","Idjab̶a Ãcõrẽ ʌb̶ʌa waib̶ʌa b̶ʌd̶eba Moiseba ne ununaca israelerã quĩrãpita ocuad̶ara jũmarãba wayasid̶aa. Moise quĩrãca ni ab̶aʌda neẽ́ basía.");
INSERT INTO empNTpo_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Nuʌ̃ warra Josuera Ãcõrẽ nezoca Moise carebabari basía. Moise jaid̶ad̶acarea Ãcõrẽba Josuéa nãwã jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","–Mʌ̃ nezoca Moisera jaid̶ad̶a bẽrã bʌa israelerãra ededua Jordaʌ̃ do wa quĩrãrẽ chãnamãrẽã mʌ̃a diai jarad̶a druad̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Mʌ̃a Moisea jarad̶a quĩrãca bãrã wãbʌdaza jũma ẽjũãda bãrãa diaya. ");
INSERT INTO empNTpo_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Mʌ̃a diai jarad̶a druara b̶ʌa ẽjũã põãsa ewaraga b̶ʌd̶eba ab̶a Libano eyad̶aa idjab̶a Euprate dod̶eba ab̶a pusa droma Mediterraneo abadad̶aa. Hititarã ẽjũãra jũma edad̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","6","Mʌ̃a bãrã drõãenabemarãa maʌ̃ druara diai jarasia ewariza bãrãne bamãrẽã. Bʌabʌrʌ purura edeya maʌ̃ ẽjũã edad̶amãrẽã. Maʌ̃ bẽrã ʌb̶ʌa b̶aped̶a sozarra b̶adua. Mʌ̃a bʌra bʌdub̶a ameẽ́a idjab̶a igaraẽ́a. Bʌ zocai b̶ʌmisa ni ab̶aʌba bʌra poyad̶aẽ́a. Mʌ̃ra bʌ ume b̶aya Moise ume b̶ad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Maʌ̃ bẽrã ʌb̶ʌa b̶aped̶a bio sozarra b̶adua. Mʌ̃ nezoca Moiseba ley b̶ʌ́ amenara jũma ĩjã o b̶adua. Ni maãrĩ bid̶a ãĩ oẽ́bʌrʌ bʌa obʌrʌra jũma bia odjaya. ");
INSERT INTO empNTpo_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Mʌ̃ ley cartad̶e b̶ʌ́ b̶ʌra jaradia b̶adua. Maʌ̃ leyra ãsa, diamasi bid̶a bio crĩcha b̶adua jũma jipa oi carea. Mãwã bʌa obʌrʌra jũma bia odjaya. ");
INSERT INTO empNTpo_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Mʌ̃ra bʌ Ãcõrẽa. Bʌ wãbʌrʌza mʌ̃ra bʌ ume b̶aya. Maʌ̃ bẽrã mʌ̃a bʌ́a wayacusa jaraya: ʌb̶ʌa b̶aped̶a sozarra b̶adua. Ne wayarãdua. Jẽda crĩcharãdua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Maʌ̃be Josueba israelerã bororãa nãwã jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","–Deza israelerãa nãwã jarad̶e wãnadua: “Ewari ũbead̶e dadjirãra namaʌba wãbʌrʌd̶ia. Cod̶ira eded̶adua. Jordaʌ̃ do wa quĩrãrẽ chãnaped̶a dadji Ãcõrẽba diai jarad̶a druara eda wãnia.”– ");
INSERT INTO empNTpo_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Maʌ̃ne Josueba Rubeʌ̃neba, Gad̶eba, idjab̶a ʌ̃cʌrʌ Manased̶eba yõped̶ad̶arãa nãwã jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","–Ãcõrẽ nezoca Moiseba jarad̶ara quĩrãnebad̶adua. Idjia jarasia bãrã Ãcõrẽba naʌ̃ druara diabʌrʌda necai duananamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","15","Jãʌ̃be bãrã quimara, warrarãra, animarã sid̶a nama amenadua naʌ̃ Jordaʌ̃ do orroare Moiseba diad̶a ẽjũãne. Baribʌrʌ bãrã mẽsrã b̶eaba djõni careabemada edad̶aped̶a na chãnida panʌa. Chãnaped̶a dairãare djõnida panʌa ab̶a dadji Ãcõrẽba dairãa diai jarad̶a ẽjũã edabʌdad̶aa. Idjia bãrã naʌ̃ ẽjũãne necai b̶ʌd̶a quĩrãca dairã sid̶a maʌ̃ ẽjũãne necai b̶ʌya. Mãwãnacarea bãrãra namaa jẽda zed̶ida panʌa bãrã ẽjũã Jordaʌ̃ dod̶eba ʌ̃mãdau odjabariare b̶ʌd̶aa, Ãcõrẽ nezoca Moiseba naʌ̃ ẽjũãra bãrãa diad̶a bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Ãdjirãba panusid̶aa: –Bʌa jara b̶ʌra dairãba jũma od̶ia idjab̶a bʌa diabuebʌrʌmaa wãnia. ");
INSERT INTO empNTpo_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Dairãba maʌ̃ra jũma ĩjã od̶ia, Moise bed̶ea ĩjã oped̶ad̶a quĩrãca. Dairãba quĩrĩã panʌa Ãcõrẽra bʌ ume b̶aida Moise ume b̶ad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Bʌ bed̶ea igara b̶ʌra, bʌa jara b̶ʌ ĩjã oẽ́ b̶ʌra beuida b̶ʌa. Baribʌrʌ bʌra ʌb̶ʌa b̶aped̶a sozarra b̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Maʌ̃be Nuʌ̃ warra Josueba ẽberãda umé trʌ̃ped̶a nãwã jarasia: –Canaaʌ̃ druara acʌd̶e wãnadua. Sãwã b̶ʌ cawaya Jerico puruda chupea acʌd̶adua.– Mãwã jaraped̶a Josueba ãdjira Sitiʌ̃ ẽjũãneba diabuesia. Wãbʌdad̶e Jericod̶e jũẽne wãsid̶aa. Mama wẽrã aud̶ua b̶ʌ Rahá abada ded̶e cãĩne wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Baribʌrʌ ʌ̃cʌrʌba ãdjira ununaped̶a Jericod̶ebema boroa nãwã jarad̶e wãsid̶aa: –Queubʌrʌd̶e israelerãda umé jũẽsid̶aa. Dadjirã drua acʌd̶e ze panʌa sãwã poyad̶i cawaya.– ");
INSERT INTO empNTpo_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","4","Maʌ̃ carea Jericod̶ebema boroba zarrarãda Rahámaa diabuesia. Maʌ̃misa Rahába israelerã umé panʌra mĩrũbisia. Zarrarãra jũẽnaped̶a nãwã jarasid̶aa: –Ẽberãrã bʌ diguid̶a jũẽped̶ad̶ara isabe dajadaa zebidua. Dadjirã drua acʌd̶e ze panʌa sãwã poyad̶i cawaya.– Rahába jarasia: –Wãrãda mʌ̃ ded̶e ẽberãrãra zesid̶aa, baribʌrʌ ãdjira sãmabemada mʌ̃a adua b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Queubʌrʌd̶e purud̶e ed̶a wãbada jũãtrʌd̶i naẽna ãdjira wãsid̶aa. Mʌ̃a adua b̶ʌa sãmaa wãsid̶ada. Baribʌrʌ bãrãda ãdji caid̶u isabe wãnibʌrʌ jidad̶e wãnisicada.– ");
INSERT INTO empNTpo_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","Rahába jarad̶ara sewa basía. Idjia maʌ̃ ẽberãrãra idji de ʌ̃rʌ̃ edeped̶a lino cajʌ̃na pae erob̶ʌ edrecare mĩrũbisia. ");
INSERT INTO empNTpo_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Rahába mãwã jarad̶a bẽrã zarrarãra israelerã caid̶u wãsid̶aa jidad̶i carea. Puru dajadaa wãnaped̶a dewararãba purud̶e ed̶a wãbadara jũãtrʌsid̶aa. Zarrarãra Jordaʌ̃ dod̶aa wãbada od̶e israelerã jʌrʌd̶e wãsid̶aa ab̶a Jordaʌ̃ do chãbadamaa. ");
INSERT INTO empNTpo_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Israelerã cãĩni naẽna Rahára idji de ʌ̃rʌ̃ wãped̶a jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","–Mʌ̃a cawa b̶ʌa Ãcõrẽba wãrãda naʌ̃ Canaaʌ̃ druara bãrãa diaida. Maʌ̃ bẽrã dairãba bãrãra bio waya panʌa. Jũma naʌ̃ druad̶ebemarãra bãrã bio waya panʌneba ure duanʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Daiba cawa panʌa bãrã Egiptod̶eba ẽdrʌsid̶ad̶e Ãcõrẽba Pusa Purrud̶e oda ewasida bãrã chãnamãrẽã. Maʌ̃ awara cawa panʌa bãrãba amorreorã Jordaʌ̃ do quĩrãrẽ pananara poyad̶aped̶a ãdji bororã Sehoʌ̃da, Og sid̶a beasid̶ada. ");
INSERT INTO empNTpo_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Maʌ̃ cawasid̶ad̶e dairãra bio ne waya panesid̶aa. Sozarra b̶ea sid̶a ne wayasid̶aa bãrã Ãcõrẽra dji wãrã Ãcõrẽ bẽrã. Idjia bajãne, naʌ̃ ẽjũãne bid̶a ne jũmada poya b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","13","Maʌ̃ carea mʌ̃ quĩrã djuburia, Ãcõrẽ trʌ̃neba bãrãba wãrãneba jarad̶adua mʌ̃ ẽberãrãra carebad̶ida mʌ̃a bãrã carebad̶a quĩrãca. Mʌ̃ djibarirãra, mʌ̃ djabarãra, mʌ̃ djabawẽrãrãra, jũma ãdji ẽberãrã sid̶a bearãnadua. ¡Daira zocai b̶ʌd̶adua! Bãrãba mãwã wãrãneba jarad̶ibʌrʌ, mʌ̃́a ebud̶a cawabid̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Ãdjia panusid̶aa: –Bia b̶ʌa. Bãrãnebemada bead̶ibʌrʌ, dai sid̶a beud̶ida panʌa. Baribʌrʌ daiba o panʌra bʌa djãrãa jaracara b̶ʌa. Ãcõrẽba naʌ̃ drua dairãa diabʌrʌd̶e bãrãra biad̶eba carebad̶ia. Daiba jara panʌ quĩrãca wãrãda od̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Rahá dera dji puru mõgaraba jũrã ca b̶ʌd̶e ed̶a b̶asia. Maʌ̃ bẽrã dajadaa acʌbadad̶e idjia jʌ̃carada jʌ̃ jira b̶ʌsia ãdji ẽdrʌd̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Wãni naẽna Rahába nãwã jarasia: –Ẽjũã eyaid̶a b̶ʌd̶aa mĩrũ wãnadua zarrarãba unurãnamãrẽã. Mama ewari ũbea mĩrũ pananadua ab̶a bãrã jʌrʌ panʌra jẽda zebʌdad̶aa. Maʌ̃bebʌrʌ wãnadua bãdji wãbʌdamaa.– ");
INSERT INTO empNTpo_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Ãdjia nãwã jarasid̶aa: –Daiba bʌ́a wãrãneba jaraped̶ad̶ara jũma od̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","Baribʌrʌ naʌ̃ druad̶e djõne zebʌdad̶e bʌa dai ẽdrʌ b̶ʌd̶a dajadaa acʌbadad̶e naʌ̃ jʌ̃cara purruda jʌ̃ jira b̶ʌida b̶ʌa. Idjab̶a bʌ djibarirãda, bʌ djabarãda, jũma bʌ ẽberãrã sid̶a nama bʌ diguid̶a eneida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Ab̶aʌda dajadaa wãibʌrʌ maʌ̃ne daiba bead̶ibʌrʌ, daira bed̶ead̶e pananaẽ́a. Baribʌrʌ nama bʌ diguid̶a b̶eada bead̶ibʌrʌ, dai sid̶a wãrãda beud̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Maʌ̃ awara daiba o panʌda bʌa djãrãa jaraibʌrʌ, daiba bʌ́a wãrãneba jaraped̶ad̶ara od̶aẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Maʌ̃ne Rahába jarasia: –Bia b̶ʌa, bãrãba jara panʌ quĩrãca od̶ia.– Maʌ̃be ãdjira wãbisia. Wãped̶ad̶acarea Rahába jʌ̃cara purrura dajadaa acʌbadad̶e jʌ̃ b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Israelerã umé panʌra ẽjũã eyaid̶a b̶ʌd̶aa wãnaped̶a ewari ũbea mĩrũ panasid̶aa. Maʌ̃misa zarrarãba ãdjira o b̶eaza jʌrʌ panʌmĩna ununaẽ́ basía. Maʌ̃ bẽrã wayacusa Jerico purud̶aa jẽda wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Maʌ̃bebʌrʌ ẽjũã eyaid̶a b̶ʌd̶e mĩrũ pananara ẽdrʌsid̶aa. Jordaʌ̃ do chãnaped̶a wayacusa Nuʌ̃ warra Josue b̶ʌma jũẽsid̶aa. Ãdji sãwãped̶ad̶ara idjía jũma nẽbʌrʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Ãdjia Josuéa nãwã jarasid̶aa: –Wãrãda Ãcõrẽba jãʌ̃ Canaaʌ̃ druara dadjirãa diaya. Dadjirã carea ãdjirãra bio ne waya panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Nurẽma diaped̶ed̶a Josuera israelerã ume Sitiʌ̃neba wãnaped̶a Jordaʌ̃ do icawa jũẽne wãsid̶aa. Baribʌrʌ chãni naẽna mama duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Ewari ũbea bad̶acarea dji bororãra deza wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","Maʌ̃ne jũmarãa nãwã jarasid̶aa: –Dãrãẽ́ne sacerdoterã Levid̶eba yõped̶ad̶aba dadji Ãcõrẽ baurudeda nocod̶aa eded̶ia. Maʌ̃da unusid̶ara caid̶u wãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Mãwã cawad̶ia sãmaa wãnida panʌda, bãrãra wad̶i naʌ̃ od̶e wãnaca bẽrã. Baribʌrʌ Ãcõrẽ baurude caita wãrãnadua; ab̶a unuicha b̶ʌmaʌba nĩbad̶ida panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Maʌ̃ awara Josueba israelerãa jarasia: –Nu Ãcõrẽba dadjirã quĩrãpita ne ununacada oya. Maʌ̃ bẽrã idji quĩrãpita bia duanani carea od̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Maʌ̃be Josueba sacerdoterãa jarasia: –Ãcõrẽ baurude jira edad̶aped̶a puru na wãnadua.– Ara maʌ̃da sacerdoterãba baurudera jira edad̶aped̶a puru na wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Maʌ̃ne Ãcõrẽba Josuéa jarasia: –Id̶iba ʌ̃taa israelerã quĩrãpita mʌ̃a bʌra dji dromada b̶ʌya. Mãwã ãdjirãba cawad̶ia mʌ̃ra bʌ ume b̶ʌda Moise ume b̶ad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Sacerdoterã mʌ̃ baurude edebʌdarãa jaradua do icawa jũẽsid̶ara doed̶a nũpanenamãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Ara maʌ̃da Josueba israelerãa nãwã jarasia: –Dadji Ãcõrẽba jarad̶ara ũrĩne zed̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","11","Ãcõrẽ zocai b̶ʌra dadjirã tãẽna b̶ʌa. Idjia jũma naʌ̃ ẽjũãra poya b̶ʌa. Idjiabʌrʌ cananeorãda, hititarãda, heveorãda, perezeorãda, gergeseorãda, amorreorãda, jebuseorã sid̶a dadjirãa jũma poyabiya. Maʌ̃ra bãrãba nãwã cawad̶ia: sacerdoterãba Ãcõrẽ baurudera Jordaʌ̃ dod̶e bãrã na eded̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Israeld̶eba yõna doce purud̶ebemada ab̶a ab̶a edad̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Sacerdoterã Ãcõrẽ baurude edebʌdara doed̶a tʌgabʌdad̶e oda ewa dogoped̶a dora wãrãga jũãtrʌ b̶ʌ quĩrãca tuma nãbua ũmeya. Ãcõrẽ naʌ̃ ẽjũã jũma poya b̶ʌba mãwã oya.– ");
INSERT INTO empNTpo_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Ara maʌ̃da israelerãba ãdji wua dera bʌrad̶aped̶a wãbʌrʌsid̶aa Jordaʌ̃ do wa quĩrãrẽ chãni carea. Ãdji na sacerdoterãba Ãcõrẽ baurudera edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","16","Maʌ̃ne Jordaʌ̃ dora nãbua ũmasia. Poaza mãwã b̶abaria cebada jara. Sacerdoterã doed̶a tʌgabʌdad̶e oda do quĩrãrã ewa dogosia. Maʌ̃ne dora wãrãga jũãtrʌ b̶ʌ quĩrãca tuma nãbua ũmesia. Dji tumara Adam puruma jũẽsia Saretaʌ̃ caita. B̸arrea dora põãsasia ab̶a Pusa Beud̶ad̶aa. Mãwã b̶ʌd̶e israelerãra Jordaʌ̃ do chãnaped̶a Jerico puruare wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Israelerã chãbʌdamisa sacerdoterãba Ãcõrẽ baurudera doed̶a jira eronũpanasid̶aa. Mama nũpanesid̶aa ab̶a jũmarãda põãsad̶e chãbʌdad̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Jũmarãda Jordaʌ̃ do quĩrãrãa chãped̶ad̶acarea Ãcõrẽba Josuéa nãwã jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","–Israeld̶eba yõped̶ad̶a doce purud̶ebemada ab̶a ab̶a edadua. ");
INSERT INTO empNTpo_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","Ãdjirãra doed̶a wãbidua sacerdoterãba mʌ̃ baurude jira eropanʌmaa. Mamaʌba mõgarada doce enebidua bãrã cãĩnimaa eded̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Ara maʌ̃da Israeld̶eba yõped̶ad̶a doce purud̶ebema edad̶ara Josueba trʌ̃cuasia. ");
INSERT INTO empNTpo_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","Maʌ̃ne nãwã jarasia: –Bãrãra doed̶a wãnadua dadji Ãcõrẽ baurude jira eropanʌmaa. Bãdjiza mõgarada ab̶a equiad̶e edad̶aped̶a enenadua dadji cãĩnimaa ʌ̃tʌ boromea bued̶i carea. Israeld̶eba yõped̶ad̶a puruza mõgarada ab̶a eneida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Maʌ̃ mõgara ʌ̃tʌ boromea bued̶aba quĩrãnebabi b̶aya sãwã Ãcõrẽba dadjirãra carebasida. Nocoarebema ewarid̶e bãrã warrarãba maʌ̃ mõgara unubʌdad̶e nãwã iwid̶id̶isicada: “Naʌ̃ mõgarara ¿cãrẽã jãwã ʌ̃tʌ boromea buesid̶a?” ");
INSERT INTO empNTpo_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","Mãwã iwid̶isid̶ara nãwã panunadua: “Sacerdoterãba Ãcõrẽ baurude Jordaʌ̃ dod̶e edesid̶ad̶e oda põãsa ewasia. Naʌ̃ mõgarara ʌ̃tʌ boromea buesid̶aa dadji israelerãba ewariza quĩrãnebad̶amãrẽã sãwã Ãcõrẽba dadjirãra carebasida.”– ");
INSERT INTO empNTpo_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Ara maʌ̃da israelerãba jũma osid̶aa Josueba jarad̶a quĩrãca. Doce mõgarara Jordaʌ̃ doed̶a edasid̶aa. Israeld̶eba yõped̶ad̶a puruza mõgarada ab̶a edasid̶aa. Maʌ̃be ãdjirã cãĩnimaa eded̶aped̶a jũma ãbaa buesid̶aa Ãcõrẽba Josuéa jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Maʌ̃ awara Josueba mõgarada doce jʌrʌ peped̶a doed̶a ʌ̃tʌ boromea buesia sacerdoterãba Ãcõrẽ baurude jira eronũpanʌma. Maʌ̃ mõgarara wad̶ibid̶a mama bue nũmʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Sacerdoterã Ãcõrẽ baurude jira eropanʌra Jordaʌ̃ doed̶a nũpanasid̶aa ab̶a Ãcõrẽba Josuéa jarad̶ara puruba jũma obʌdad̶aa. Moiseba Josuéa naẽna jarad̶a quĩrãca puruba jũma osia. Purura isabe chãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Jũmarã chãped̶ad̶acarea sacerdoterã Ãcõrẽ baurude jira eropanʌra chãnaped̶a wayacusa puru na wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Maʌ̃ awara Rubeʌ̃neba, Gad̶eba, idjab̶a ʌ̃cʌrʌ Manased̶eba yõped̶ad̶a mẽsrã b̶eara chãnaped̶a waabema israelerã na wãsid̶aa Moiseba ãdjirãa jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","Maʌ̃ mẽsrã b̶eara cuarenta mil panasid̶aca b̶ʌa. Ãdjia Ãcõrẽ quĩrãpita jaraped̶ad̶a quĩrãca Jerico jewed̶ad̶aa wãsid̶aa djõni carea. ");
INSERT INTO empNTpo_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Maʌ̃ ewarid̶e Ãcõrẽba Josuera israelerã quĩrãpita dji dromada b̶ʌsia. Mamaʌba ʌ̃taa ewariza israelerãba Josuera waya panesid̶aa Moise waya panana quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Jũmarã chãped̶ad̶acarea Ãcõrẽba Josuéa nãwã jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","–Sacerdoterã mʌ̃ baurude jira eropanʌrãa jaradua drua zed̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Ara maʌ̃da Josueba sacerdoterãa jarasia Jordaʌ̃ dod̶eba drua zed̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","Maʌ̃ne sacerdoterã Ãcõrẽ baurude jira eropanʌra drua zesid̶aa. Ẽjũã põãsa tʌgabʌdad̶e dora wayacusa wea dogoped̶a nãbua ũmesia idji b̶ad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Poa djiwid̶i nabema jed̶ecod̶e die ewarid̶e israelerãra Jordaʌ̃ do chãnaped̶a Gilgal abadad̶aa wãbʌrʌsid̶aa. Gilgalera Jericod̶eba ʌ̃mãdau odjabariare b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Mama doce mõgara Jordaʌ̃ dod̶eba edeped̶ad̶ara Josueba ʌ̃tʌ boromea buesia. ");
INSERT INTO empNTpo_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Maʌ̃ne idjia israelerãa nãwã jarasia: –Nocoarebema ewarid̶e bãrã warrarãba nãwã iwid̶id̶isicada: “Naʌ̃ mõgarara ¿cãrẽã ʌ̃tʌ boromea buesid̶a?” ");
INSERT INTO empNTpo_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","Mãwã iwid̶isid̶ara nãwã panunadua: “Dairãba mãwã osid̶aa quĩrãnebad̶i carea dadji israelerãra Jordaʌ̃ dojã põãsad̶e chãsid̶ada. ");
INSERT INTO empNTpo_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Dadji Ãcõrẽba dora jũãtrʌ erob̶asia dadji israelerã dojã põãsad̶e jũma chãbʌdamisa. Ara maʌ̃ quĩrãca Pusa Purrud̶e oda ewasia pusajã põãsad̶e chãnamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Dadji Ãcõrẽba mãwã osia bãrãba idjira ewariza waya pananamãrẽã idjab̶a jũma naʌ̃ ẽjũãnebemarãba cawad̶amãrẽã idjira bio ʌb̶ʌa b̶ʌda.”– ");
INSERT INTO empNTpo_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Maʌ̃ ewarid̶e ʌ̃cʌrʌ amorreorãda Jordaʌ̃ dod̶eba ʌ̃mãdau b̶aebariare panasid̶aa. Cananeorãda pusa Mediterraneo abadaare panasid̶aa. Ãdji bororãba ũrĩsid̶aa Ãcõrẽba Jordaʌ̃ dora põãsabisida israelerã chãnamãrẽã. Maʌ̃ba bio ne wayad̶aped̶a israelerã ume djõni crĩchara neẽ́ panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Maʌ̃ ewarid̶e Ãcõrẽba Josuéa jarasia: –Mõgarada edaped̶a neco zaqueda ocuadua. Maʌ̃ba wayacusa israelerã dji umaquĩrãda jũma cacua wẽãgobicuadua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Ara maʌ̃da Aralot eya zaqued̶e Josueba mõgarada edaped̶a neco zaquera ocuaped̶a jũma israelerãra cacua wẽãgobicuasia. ");
INSERT INTO empNTpo_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","5","Josueba mãwã osia israelerã Egiptod̶eba ẽdrʌped̶ad̶acarea ẽjũã põãsa ewaraga b̶ʌd̶e nĩnane umaquĩrã warra toped̶ad̶ara cacua wẽãgoẽ́ b̶ead̶a bẽrã. Jũma mẽsrã b̶ea Egiptod̶eba ẽdrʌped̶ad̶ara cacua wẽãgo b̶easia baribʌrʌ ẽjũã põãsa ewaraga b̶ʌd̶e quinisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","Ãcõrẽba ãdjirãa nãwã jarasia: “Mʌ̃a bãrã drõã naẽnabemarãa wãrãneba jarasia Canaaʌ̃ druada diaida. Maʌ̃ druad̶e baridua ne uped̶ad̶ara bia zaubaria.” Baribʌrʌ Ãcõrẽba jarad̶ara ãdjirãba ĩjã od̶aẽ́ basía. Maʌ̃ carea idjia wãrãneba jarasia ãdjirãba maʌ̃ ẽjũãra edad̶aẽ́da. Mãwã jarad̶a bẽrã ãdjirãra cuarenta poa ẽjũã põãsa ewaraga b̶ʌd̶e pʌrrʌa nĩbabadjid̶aa. Mãwã nĩnane jũma dji mẽsrã b̶ea Egiptod̶eba ẽdrʌped̶ad̶ara quinisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Ãdjirã cacuabari Ãcõrẽba ãdji warrarãa Canaaʌ̃ druara diayad̶a asia. Baribʌrʌ ãdjirãra cacua wẽãgoẽ́ b̶easia od̶e nĩnane toped̶ad̶a bẽrã. Maʌ̃ carea Josueba ãdjirãra cacua wẽãgobicuasia. ");
INSERT INTO empNTpo_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Jũma cacua wẽãgoped̶ad̶acarea diguid̶a duanesid̶aa ab̶a ãdji cacua anibʌdad̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Ãcõrẽba Josuéa jarasia: –Egiptod̶e nezoca panasid̶ad̶e bãrãra mĩã pera panasid̶aa baribʌrʌ id̶i bãrã cacua wẽãgosid̶a bẽrã maʌ̃ mĩã perara mʌ̃a ãyã b̶ʌsia.– Maʌ̃ bẽrã maʌ̃ ẽjũãra wad̶ibid̶a Gilgal abadaa. ");
INSERT INTO empNTpo_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Israelerãra Gilgald̶e duanesid̶aa. Ãdji jũẽped̶ad̶a jed̶ecod̶e ewari catorced̶e quewara Egiptod̶eba ẽdrʌped̶ad̶a quĩrãnebada ewarida osid̶aa mama Jerico caita b̶ʌ jewed̶ad̶e. ");
INSERT INTO empNTpo_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Nurẽma Canaaʌ̃ ẽjũãne zau b̶ʌda co panesid̶aa. Paʌ̃ ẽsãbari neẽ́ b̶ʌda od̶aped̶a cosid̶aa. Cebada jututiad̶a sid̶a cosid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Mamaʌba ʌ̃taa manára waa odjaẽ́ basía israelerãba cod̶amãrẽã. Maʌ̃ poad̶e Canaaʌ̃ ẽjũãne zau b̶ʌda co panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Mama Jerico caita b̶ʌd̶e ewari ab̶a Josueba ẽberãda neco jũẽ nũmʌda unusia. Maʌ̃ ẽberã caita wãped̶a iwid̶isia: –¿Bʌra daiare b̶ʌca wa dai dji quĩrũare b̶ʌ?– ");
INSERT INTO empNTpo_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Ẽberãba nãwã panusia: –Mʌ̃ra ni ab̶aʌare b̶ʌẽ́a. Mʌ̃ra Ãcõrẽ sordaorã boro bẽrã ze b̶ʌa.– Maʌ̃ ũrĩsid̶e Josuera idji waya b̶ʌd̶eba chĩrãborod̶e b̶arru cob̶eped̶a iwid̶isia: –Mʌ̃ Boro, mʌ̃ra bʌ nezocaa. ¿Cãrẽda obi quĩrĩã b̶ʌ?– ");
INSERT INTO empNTpo_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Maʌ̃ne Ãcõrẽ sordaorã boroba jarasia: –Bʌra Ãcõrẽ quĩrãpita b̶ʌ bẽrã bʌ jĩrũne jʌ̃ b̶ʌra ẽrãdua.– Ara maʌ̃da Josueba ĩjã osia. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Jericod̶ebemarãba israelerã wayaaba ãdji purud̶e ed̶a wãbadara bio jũãtrʌ eropanasid̶aa. Maʌ̃ba ni ab̶aʌda purud̶eba ẽdrʌd̶aca basía, ni ed̶a zed̶aca basía. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Maʌ̃ne Ãcõrẽba Josuéa jarasia: –Ũrĩdua. Mʌ̃a Jerico puruda, dji boroda, sordaorã sid̶a bãrãa poyabiya. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Bãrã sordaorãra ewariza b̶arima ab̶a Jerico aud̶u pʌrrʌgad̶adua. Sei ewari mãwã od̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Maʌ̃ne sacerdoterãba mʌ̃ baurudera eronĩbad̶ida panʌa. Dewara siete sacerdoterãda ãdji na nĩbad̶ida panʌa. Ãdjirãza cachiru oveja cachu od̶ada eded̶ida panʌa. Sietebema ewarid̶e bãrãra b̶arima siete Jerico aud̶u pʌrrʌgad̶adua. Maʌ̃ne jũma maʌ̃ cachiru eropanʌba jĩgua zad̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Cachiru dãrã jĩguabʌdad̶e bãrãra jĩgua b̶iad̶adua. Maʌ̃ne Jerico aud̶u jũrã ca b̶ʌra idub̶a tod̶ogozoaya. Maʌ̃ne bãrãra daucha pirapod̶aped̶a purud̶e ed̶a djõne wãbʌrʌd̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Ara maʌ̃da Nuʌ̃ warra Josueba israelerã sacerdoterãra jũma trʌ̃cuaped̶a jarasia: –Ãcõrẽ baurudera Jerico puru aud̶u pʌrrʌga eded̶adua. Idjab̶a bãrãnebemada siete edad̶aped̶a baurude nocoare cachiru bara nĩbad̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Maʌ̃be sordaorãa nãwã jarasia: –Bãrã sid̶a wãnaped̶a Jerico puru aud̶u pʌrrʌgad̶adua. Ʌ̃cʌrʌ sordaorã djõni careabema bara Ãcõrẽ baurude na nĩbad̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Josueba jarad̶ara jũma ĩjã osid̶aa. Sacerdoterã siete panʌra Ãcõrẽ baurude nocoare nĩbasid̶aa ãdji cachiru zá panʌda. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Ãdjirã nocoare ʌ̃cʌrʌ sordaorãda djõni careabema bara nĩbasid̶aa. Waabema sordaorãra Ãcõrẽ baurude caid̶u errubusibasia. Mãwã nĩnane sacerdoterãba ãdji cachirura zá jõnaca basía. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Baribʌrʌ Josueba sordaorãa nãwã jarasia: –B̸iarãnadua. Ni maãrĩ bid̶a bed̶earãnadua. Chupea pananadua ab̶a mʌ̃a jarabʌrʌd̶aa. Mʌ̃a bãrãa jarabʌrʌd̶e b̶iad̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Maʌ̃ ewarid̶e Josueba Ãcõrẽ baurudera b̶arima ab̶a Jerico puru aud̶u pʌrrʌga edebisia. Mãwã od̶aped̶a wayacusa ãdji cãĩbadamaa zesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Nurẽma diaped̶ed̶a Josuera piradrʌped̶a sacerdoterãa Ãcõrẽ baurudera wayacusa Jerico puru aud̶u pʌrrʌga edebisia. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Sacerdoterã siete panʌra Ãcõrẽ baurude nocoare nĩbasid̶aa. Ãdjiza cachirura zá nĩbasid̶aa. Ãdjirã nocoare ʌ̃cʌrʌ sordaorãra djõni careabema bara nĩbasid̶aa. Waabema sordaorãra Ãcõrẽ baurude caid̶u errubusibasia. Mãwã nĩnane sacerdoterãba ãdji cachirura zá jõnaca basía. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Maʌ̃ umébema ewarid̶e ãdjirãra wayacusa b̶arima ab̶a Jerico puru aud̶u pʌrrʌgad̶aped̶a ãdji cãĩbadamaa jẽda zesid̶aa. Sei ewari mãwã osid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Sietebema ewarid̶e ãdjirãra diaped̶ed̶a piradrʌd̶aped̶a Jerico puru aud̶u pʌrrʌgasid̶aa naãrã oped̶ad̶a quĩrãca. Baribʌrʌ maʌ̃ ewarid̶e b̶arima siete pʌrrʌgasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","B̸arima siete pʌrrʌgaped̶ad̶acarea cachirura dãrã jĩgua zasid̶aa. Maʌ̃ne Josueba jĩgua jarasia: –¡B̸iad̶adua! Ãcõrẽba naʌ̃ Jerico purura dadjirãa poyabibʌrʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Jũmarãda quenanaped̶a purura, ne jũma purud̶e b̶ʌ sid̶a babued̶adua Ãcõrẽba idji itea mãwã obi b̶ʌ bẽrã. Ab̶abe wẽrã aud̶ua b̶ʌ Rahádrʌ, idji ded̶e panʌ sid̶a zocai b̶ʌd̶adua dadjia wãrãneba mãwã od̶ida jaraped̶ad̶a bẽrã. Naʌ̃ puru sãwã poyad̶i cawaya mʌ̃a diabued̶a ẽberãrãda idjia mẽrãsia. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Baribʌrʌ bãrãra bio quĩrãcuitad̶adua. Purud̶e ne bia b̶eara ni cãrẽ sid̶a edarãnadua, Ãcõrẽba idji itea ne jũmada babued̶aduad̶a ad̶a bẽrã. Bãrãba ĩjãnaẽ́bʌrʌ, dadji purura bed̶ead̶e b̶ʌd̶aped̶a Ãcõrẽba quinibiya. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Paratada, oroda, bronce od̶ada, jiorro od̶a sid̶a jũma Ãcõrẽa diad̶ida panʌa. Maʌ̃drʌ Ãcõrẽa diad̶a wagabadad̶e b̶ʌd̶ida panʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Sacerdoterãba ãdji cachiru dãrã jĩgua zasid̶ad̶e jũmarãda jĩgua b̶iasid̶aa. Maʌ̃ne Jerico puru aud̶u jũrã ca b̶ʌra idub̶a tod̶ogozoasia. Ara maʌ̃da israelerãra daucha djõne pirapod̶aped̶a purura poyasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Maʌ̃ purud̶ebema umaquĩrãrãda, wẽrãrãda, warrarãda, drõãrã sid̶a necoba jũma quenasid̶aa. Ãdji pacada, ovejada, burro sid̶a jũma quenasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Maʌ̃ne Josueba Canaaʌ̃ drua acʌd̶e diabued̶a ẽberãrãa nãwã jarasia: –Wẽrã aud̶ua b̶ʌ Rahá diguid̶aa wãnaped̶a idjira, idji ded̶e duanʌ sid̶a ẽdrʌ enenadua. Bãrãba idjía wãrãneba jaraped̶ad̶ara od̶e wãnadua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Ara maʌ̃da Rahá diguid̶aa wãnaped̶a dji zezada, dji papada, dji djabarãda, dji djabawẽrãda, jũma ãdji ẽberãrã sid̶a dajadaa enesid̶aa. Maʌ̃be israelerã duanʌmaʌba jĩga b̶ʌd̶e wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Maʌ̃misa waabema israelerãba Jerico purura ab̶ed̶a jũma babuesid̶aa. Baribʌrʌ paratada, oroda, bronce od̶ada, jiorro od̶a sid̶a Ãcõrẽa diad̶a wagabadad̶e b̶ʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Josueba wẽrã aud̶ua b̶ʌ Rahára, idji ẽberãrã sid̶a zocai b̶ʌsia, maʌ̃ wẽrãba idjia Jerico chupea acʌd̶e diabued̶ara mẽrãna bẽrã. Rahá ẽberãrãra wad̶ibid̶a israelerã tãẽna panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Mãwãnacarea Josueba wãrãneba nãwã jarasia: Ab̶aʌba naʌ̃ Jerico puru wayacusa oi carea jʌwa b̶ʌibʌrʌ, maʌ̃ ẽberãra Ãcõrẽba biẽ́ b̶ʌya. Dji mõgara jũrã ca b̶ad̶a wayacusa obʌrʌd̶e idji warra iwinada beuya. Dji ed̶a wãbada pãrãbʌrʌd̶e idji warra tẽãbemada beuya. Mãwã idji warrarãra jũma quininia. ");
INSERT INTO empNTpo_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Ãcõrẽra Josue ume b̶asia. Maʌ̃ bẽrã Josuera jũma maʌ̃ druad̶e trʌ̃ b̶ʌga b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Judad̶eba yõna ẽberãda ab̶a b̶asia Acaʌ̃ abadada. Idjira Carmi warra basía. Carmira Zabdi warra basía. Zabdira Zerá warra basía. Jericod̶e Ãcõrẽba israelerãa ne jũma babued̶aduad̶a ad̶amĩna Acaʌ̃ba ĩjãẽ́ ʌ̃cʌrʌ mẽrã edasia. Mãwã od̶a bẽrã israelerãra Ãcõrẽ quĩrãpita bed̶ead̶e panesid̶aa. Ãcõrẽra ãdjirã ume bio quĩrũna bẽrã naʌ̃da mãwãsia. ");
INSERT INTO empNTpo_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Jericod̶eba Josueba ẽberãrãda Hai puru acʌd̶e diabuesia. Hai purura Beteld̶eba ʌ̃mãdau odjabariare Bet-Aveʌ̃ caita b̶asia. Josueba diabued̶arãra wãnaped̶a Hai purura quĩrãcuita acʌsid̶aa sãwã poyad̶i cawaya. ");
INSERT INTO empNTpo_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","Maʌ̃be wayacusa jẽda zed̶aped̶a Josuéa nãwã jarasid̶aa: –Haid̶ebema sordaorãra zocãrãẽ́be panʌa. Dadjirãba mil uméba wa mil ũbeaba ãdjirãra poyad̶ida panʌa. Maʌ̃ bẽrã dadjirã sordaorãra jũma diabuerãdua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","Maʌ̃ba Josueba sordaorãra mil ũbeabe diabuesia Hai purud̶ebemarã ume djõnamãrẽã. Baribʌrʌ Haid̶ebemarãba poyad̶aped̶a israelerãra mĩrũ wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","Maʌ̃ne Haid̶ebemarãba purud̶e ed̶a wãbadamaʌba israelerãra ẽpẽ wãsid̶aa eya ed̶aa tuca jira b̶ʌd̶aa. Ed̶aa wãbʌdad̶e israelerãra 36 beasid̶aa. Maʌ̃ carea israelerãra ne wayad̶aped̶a ab̶ed̶a djõni crĩchara neẽ́ panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Josuera, israelerã bororã sid̶a bio sopuasid̶aa. Maʌ̃ carea ãdjia jʌ̃ panʌra jũma cõãtad̶aped̶a ãdji boro ʌ̃rʌ̃ egoro porada cuasid̶aa. Maʌ̃be Ãcõrẽ baurude caita chĩrãborod̶e b̶arru copanesid̶aa ab̶a queubod̶od̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","Mãwã panʌne Josueba Ãcõrẽa nãwã jarasia: –¡Ay, dai Boro Ãcõrẽ! ¿Cãrẽ cãrẽã dairãra Jordaʌ̃ do quĩrãrã chãbisi? ¿Dairãra amorreorã jʌwaed̶a b̶ʌi carea enesica? ¿Ãdjirãba dairã quenanamãrẽã enesica? ¡Jordaʌ̃ do quĩrãrẽ panenabara biara b̶acasia! ");
INSERT INTO empNTpo_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","¡Ay, mʌ̃ Boro! Haid̶ebemarã wayaad̶eba dai israelerãra jẽda pira zesid̶aa. Maʌ̃ba mʌ̃ra bed̶ea jaure neẽ́ b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","Cananeorãba waabemarã bid̶a maʌ̃ra ũrĩnia. Maʌ̃da cawasid̶ara ãdjirãra dairã ume djõne zed̶ia. Maʌ̃ne dairãda jũrã edad̶aped̶a ab̶ed̶a jũma quenanibʌrʌ, ¿bʌa sãwã cawabi bʌra wãrãda Ãcõrẽda?– ");
INSERT INTO empNTpo_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Maʌ̃ne Ãcõrẽba jarasia: –¿Cãrẽ cãrẽã sopuaba bʌra egode cob̶ʌ? ¡Piradrʌdua! ");
INSERT INTO empNTpo_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","Bãrã israelerãba cadjiruada osid̶aa. Mʌ̃a jarad̶ara bãrãba ĩjã od̶aẽ́ basía. Mʌ̃a Jericod̶ebema nebiara edarãnaduad̶a ad̶amĩna edasid̶aa. Mãwã mʌ̃reda drʌad̶aped̶a diguid̶a mẽrã eropanʌa. Maʌ̃ne sewad̶eba edad̶aẽ́ panʌana a panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","Maʌ̃ carea bãrã israelerãba dji quĩrũra waa poyad̶aẽ́a. Djõnibʌrʌ bãrãdrʌ mĩrũ pirapod̶ia. Bãrãra bed̶ead̶e panʌ bẽrã mʌ̃a jũma quenabiya. Bãrãba mẽrã eropanʌda isabe jũma babued̶aẽ́bʌrʌ, mʌ̃ra bãrã ume waa b̶aẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","Jãʌ̃be purua nãwã jarad̶e wãdua: “Nu Ãcõrẽ quĩrãpita dji jʌred̶ida panʌ bẽrã idji itea bia panani carea od̶ida panʌra nane od̶adua. Dadji israelerã Ãcõrẽba nãwã jara b̶ʌa: mʌ̃a Jericod̶ebema jũma babued̶aduad̶a ad̶amĩna bãrã israelerãba ʌ̃cʌrʌ edad̶aped̶a mẽrã eropanʌa. Bãrãba maʌ̃gʌra ãyã eded̶aped̶a jũma babued̶aẽ́bʌrʌ, bãrã dji quĩrũra poyad̶aẽ́a.” ");
INSERT INTO empNTpo_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","Nu mʌ̃ quĩrãpita jũmarãda zed̶ida panʌa. Maʌ̃ne mʌ̃a cawabiya Israel doce purud̶ebemada ab̶a bed̶ead̶e b̶ʌda. Maʌ̃ purura caitaara zeped̶a mʌ̃a cawabiya cai drõã b̶asid̶eba yõped̶ad̶arãda bed̶ead̶e panʌda. Maʌ̃gʌrãra caitaara zed̶aped̶a mʌ̃a cawabiya ab̶aʌ drõãda idji ẽberãrã sid̶a bed̶ead̶e panʌda. Ãdjid̶ebema umaquĩrãrãda caitaara zed̶ida panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","Zebʌdad̶e mʌ̃a cawabiya caida bed̶ead̶e b̶ʌda. Maʌ̃ba Jericod̶ebema babueida b̶ad̶ada mẽrã erob̶ʌa. Waabema israelerã tãẽna cadjirua od̶a bẽrã idjab̶a mʌ̃a jarad̶ara ĩjã od̶aẽ́ bẽrã idjida, idji ẽberãrã sid̶a bead̶adua. Maʌ̃be ãdjira, ãdjia eropanʌ sid̶a jũma babued̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","Nurẽma diaped̶ed̶a Josuera piradrʌped̶a israelerãra ãbaa jʌresia. Maʌ̃ne Ãcõrẽba cawabisia Judad̶eba yõna puruda bed̶ead̶e b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","Maʌ̃be ãdji drõã b̶asid̶eba yõped̶ad̶arã caitaara zebʌdad̶e Ãcõrẽba cawabisia Zerád̶eba yõped̶ad̶arãda bed̶ead̶e panʌda. Zerád̶eba yõped̶ad̶arã caitaara zebʌdad̶e Ãcõrẽba cawabisia Zabdi ẽberãrãda bed̶ead̶e panʌda. ");
INSERT INTO empNTpo_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","Zabdid̶ebema umaquĩrãrã ab̶a ab̶a zebʌdad̶e Ãcõrẽba cawabisia Carmi warra Acaʌ̃da bed̶ead̶e b̶ʌda. Acaʌ̃ra Zabdi wiuzaque basía. Zabdira Zerá warra basía. Ãdjira Judad̶eba yõna purud̶ebema basía. ");
INSERT INTO empNTpo_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","Maʌ̃ne Josueba jarasia: –Acaʌ̃, dadji israelerã Ãcõrẽ quĩrãpita jũma bʌa od̶ada wãrãda jaradua. Ni maãrĩ bid̶a mẽrãrãdua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Acaʌ̃ba panusia: –Wãrãda mʌ̃a dadji israelerã Ãcõrẽ quĩrãpita nãwã cadjiruada osia. ");
INSERT INTO empNTpo_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","Jericod̶e djõ panasid̶ad̶e mʌ̃a wua biya quiruda Babilonia druad̶e caped̶ad̶ada, paratada libra juesuma, idjab̶a oroda libra ab̶a aud̶u unusia. Jũma maʌ̃gʌra awuad̶a bẽrã edaped̶a mʌ̃ wua dejãne jou b̶ʌsia. Dji paratara edrecare b̶ʌsia.– ");
INSERT INTO empNTpo_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","Ara maʌ̃da Josueba ẽberãrãda diabuesia acʌd̶e wãnamãrẽã. Acaʌ̃ wua ded̶aa pira wãnaped̶a Acaʌ̃ba jarad̶a quĩrãca jũma unusid̶aa. Dji paratara edrecare b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","Jũma edad̶aped̶a Ãcõrẽ quĩrãpita cob̶ʌsid̶aa Josueba israelerã bid̶a ununamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","Maʌ̃be Josueba, waabema israelerã ume Acaʌ̃ra Acor jogoad̶aa edesid̶aa. Idjia drʌa erob̶ad̶a sid̶a edesid̶aa: wua Babiloniane cad̶ada, paratada, oro sid̶a. Maʌ̃ awara idji warrarãda, idji caurãda, idji pacada, idji burroda, idji ovejada, idji wua de sid̶a edesid̶aa. Idjia erob̶ad̶ara ab̶ed̶a jũma edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","Maʌ̃ne Josueba Acaʌ̃ra nãwã quẽãsia: –¿Bʌa cãrẽ cãrẽã daira nẽbʌrad̶e b̶ʌsi? ¡Bʌa nẽbʌra od̶ara Ãcõrẽba ara bʌdji ʌ̃rʌ̃ b̶aebiya!– Mãwã jarad̶acarea israelerãba Acaʌ̃ra idji ẽberãrã sid̶a mõgaraba tab̶ari bead̶aped̶a jũma babuesid̶aa. Jũma idjia erob̶ad̶a sid̶a babuesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Maʌ̃be ãdji ʌ̃rʌ̃ mõgarada boromea buesid̶aa. Maʌ̃ra wad̶ibid̶a boromea nũmʌa. Maʌ̃ jogoara wad̶ibid̶a Acor abadaa. Israelerãba mãwã oped̶ad̶a bẽrã Ãcõrẽ quĩrũbira tumasia. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","Maʌ̃be Ãcõrẽba Josuéa nãwã jarasia: –Bʌ sordaorãda jũma trʌ̃cuaped̶a waya Haid̶ebemarã ume djõne wãnadua. Ne wayarãdua. Jẽda crĩcharãdua. Mʌ̃a Haid̶ebemarãda, ãdji boro sid̶a bʌ́a poyabiya. Ãdji ẽjũãra, ãdji puru sid̶a bʌ jʌwaed̶a b̶ʌya. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","Bãrãba Jericod̶ebemarã quenaped̶ad̶a quĩrãca Haid̶ebemarãra, ãdji boro sid̶a quenanadua. Baribʌrʌ ãdjia erob̶eara, ãdji animarã sid̶a bãrãba edad̶ida panʌa. Bãrãra puru jẽdaare wãnaped̶a ãdjia adua panʌne quenane wãnadua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","Ara maʌ̃da Josuera jũma idji sordaorã sid̶a Haid̶ebemarã ume djõne wãsid̶aa. Josueba sordaorã bio mẽsrã b̶eada treinta mil awara b̶ʌped̶a diamasi Hai purud̶aa na diabuesia. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","Diabuei naẽna nãwã jarasia: –Bio ũrĩnadua. Bãrãra Hai puru wagaa wãnaped̶a mĩrũnadua. Jẽda Haid̶aa djõne zed̶i carea pananadua. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","6","Maʌ̃misa waabemara mʌ̃ ume wãnia puru quĩrãpe. Maʌ̃ne Haid̶ebemarã dairã ume djõne zebʌdad̶e sewada dairãra jẽda pira wãnia naãrã mĩrũ wãped̶ad̶a quĩrãca. Mãwã unubʌdad̶e ãdjia crĩchad̶ia wayacusa ãdji waya panʌneba mĩrũ wãbʌdada. Maʌ̃ bẽrã dairãra ẽpẽnia. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","Ãdjirãba dai ẽpẽbʌdad̶e bãrãra mĩrũ pananada purud̶e ed̶a wãnaped̶a poyad̶adua, Ãcõrẽba bãrãa poyabi bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","Purura poyad̶aped̶a jũma babued̶adua dadji Ãcõrẽba jarad̶a quĩrãca. Mʌ̃a jara b̶ʌra od̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","Mãwã jaraped̶a Josueba dji treinta mil panʌra Hai purud̶aa diabuesia. Ãdjirãra puru wagaa wãnaped̶a ʌ̃mãdau b̶aebariare Betel yagaa mĩrũsid̶aa. Maʌ̃misa Josuera waabema sordaorã panʌma cãĩsia. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","Nurẽma diaped̶a piradrʌped̶a Josueba idji sordaorãra ãbaa jʌreped̶a Haid̶aa wãsid̶aa. Josuera israelerã bororã ume sordaorã na nĩbasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","Jũma sordaorã idji ume panʌra Hai quĩrãpe jũẽnaped̶a mama panesid̶aa. Puru quĩrãpe jewed̶ada b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","Maʌ̃ne Josueba idji sordaorãnebemada cinco mil edaped̶a Hai puru wagaa ʌ̃mãdau b̶aebariare Betel yagaa mĩrũbisia. Mãwã osia Haid̶ebemarãba adua panʌne ãdjirã ume djõne zed̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","Mãwã Hai wagaa mĩrũ panʌne waabemada Hai quĩrãpe panesid̶aa. Maʌ̃ diamasi Josuera idji sordaorã ume dji jewed̶a ẽsi jũẽne wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","Diaped̶ed̶a Haid̶ebema boroba unusia israelerãra djõne zebʌdada. Maʌ̃ bẽrã idji sordaorãda isabe edesia Arabá ẽjũãare israelerã ume djõni carea. Baribʌrʌ Haid̶ebema boroba adua b̶asia idji puru wagabe dewara israelerãra mĩrũ panʌda. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","Josueba Haid̶ebemarã zebʌda unubʌrʌd̶e ne wayabʌda quĩrãca idji sordaorãra ẽjũã põãsa ewaraga b̶ʌd̶aa wãbada óare pira wãbisia. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","17","Maʌ̃ bẽrã Haid̶ebema boroba jũma idji sordaorãra trʌ̃cuasia israelerã ẽpẽnamãrẽã. Jũma Beteld̶ebema sid̶a israelerã caid̶u wãbʌrʌsid̶aa Haiare djõ panʌ bẽrã. Ni ab̶aʌ sordaoda purud̶e b̶eẽ́ basía. Mãwã ẽpẽ panʌne ãdjirã purud̶eba tʌmʌ wãsid̶aa. Maʌ̃ awara isabe wãped̶ad̶a bẽrã dji puru ed̶a wãbadara jũãtrʌd̶aẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","Maʌ̃ne Ãcõrẽba Josuéa jarasia: –Hai purura mʌ̃a bãrãa poyabibʌrʌa. Maʌ̃ bẽrã bʌ mĩãsura purud̶aa ʌ̃taa wadua.– Ara maʌ̃da Josueba idji mĩãsura Hai purud̶aa ʌ̃taa wasia. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","Mãwã obʌrʌd̶e dji puru wagabe mĩrũ pananara isabe purud̶e ed̶a wãsid̶aa. Poyad̶aped̶a ara maʌ̃da babuesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","21","Josueba idji sordaorã bid̶a Hai purura cowaga nũmʌda unusid̶aa. Maʌ̃ba cawasid̶aa dji mĩrũ pananaba purura poyad̶aped̶a babuebʌdada. Maʌ̃ carea ãdjirãra waya jẽda pirasid̶aa Haid̶ebemarã ume djõni carea. Haid̶ebema sordaorãba ãdji purud̶aa jẽda acʌbʌdad̶e cowaga nũmʌda unusid̶aa. Idjab̶a unusid̶aa israelerã mĩrũ pira wãped̶ad̶ara waya jẽda ãdjirã ume djõne zebʌdada. Maʌ̃ bẽrã neẽ́ basía sãmaa ẽdrʌd̶ida. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","Mãwã panʌne dji puru poyaped̶ad̶ara Haid̶ebema sordaorã caid̶u zesid̶aa. Mãwã israelerãba Haid̶ebemarãra jũrã edad̶aped̶a quenasid̶aa. Ni ab̶aʌda idu mĩrũ wãbid̶aẽ́ basía ni zocai b̶ʌd̶aẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","Ab̶abe Haid̶ebema borodrʌ zocai jidad̶aped̶a Josuemaa edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","Israelerãba Haid̶ebemarã ãdjirã caid̶u zeped̶ad̶ara ãdji ẽjũãne idjab̶a ẽjũã põãsa ewaraga b̶ʌare necoba quenanaped̶a wayacusa Haid̶aa wãsid̶aa dji wad̶i zocai b̶eara bead̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","26","Josueba sordaorãa jarad̶oasia djõnamãrẽã ab̶a Haid̶ebemarã jũma beabʌdad̶aa. Maʌ̃ ewarid̶e Haid̶ebema umaquĩrãrãda wẽrãrã sid̶a doce mil quenasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","Maʌ̃be israelerãba Haid̶ebema animarãra, purud̶e b̶ʌ nebia sid̶a ãdjirã itea jũma edasid̶aa Ãcõrẽba Josuéa jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","Mãwãnacarea Josueba Hai purura jũma babuesia. Ni cãrẽ sid̶a b̶eẽ́ basía. Wad̶ibid̶a ni cãrẽ sid̶a neẽ́ b̶ʌa Hai puru b̶ad̶ama. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","Maʌ̃be Josueba Haid̶ebema borora beaped̶a bacuru cũmiane ʌ̃tʌ su jira b̶ʌbisia ab̶a queubʌrʌd̶aa. Queud̶acarea ed̶aa edad̶aped̶a Hai purud̶e ed̶a wãbadama tab̶ʌsid̶aa. Maʌ̃be idji ʌ̃rʌ̃ mõgarada boromea buesid̶aa. Maʌ̃ mõgarara wad̶ibid̶a boromea nũmʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","Mãwãnacarea Josueba Ebal eyad̶e mõgarada ʌ̃tʌ pã buesia animarã israelerã Ãcõrẽa babue diai carea. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","Josueba maʌ̃ra osia Ãcõrẽ nezoca Moiseba israelerãa jarad̶a quĩrãca. Ãcõrẽ ley Moiseba cartad̶e b̶ʌd̶aba nãwã jara b̶ʌa: “Animarã babue diabada obʌdad̶e mõgarada ʌ̃tʌ pã bued̶ibʌrʌ, maʌ̃ mõgarara daucha chĩ orãnadua.” Maʌ̃ mõgara pã bued̶a ʌ̃rʌ̃ israelerãba ʌ̃cʌrʌ animarãda Ãcõrẽa jũma babue diasid̶aa. Idjab̶a Ãcõrẽ ume necai b̶ead̶i carea animarã dragada Ãcõrẽa babue diasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","Mama Josueba israelerã quĩrãpita Ãcõrẽ ley Moiseba b̶ʌd̶ara mõgarad̶e jaya b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","Maʌ̃ne israelerã ẽsi levitarã dji sacerdoterãba Ãcõrẽ baurudera equiad̶e eronũpanasid̶aa. Israelerãra, ãĩbemarã ãdjirã tãẽna panabada sid̶a arima panasid̶aa. Dji bororãra, dji dromarãra, dji cawa obadarã sid̶a panasid̶aa. Guerizim eya orroare ãdjirã ẽsidra panasid̶aa, idjab̶a Ebal eya orroare ẽsidra panasid̶aa. Ãcõrẽ nezoca Moiseba naẽna jarad̶oasia mãwã od̶amãrẽã. Mãwã jarasia sacerdoterãba israelerã bia jara b̶ʌd̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","Mãwã panʌne Josueba israelerã quĩrãpita Ãcõrẽ ley cartad̶e b̶ʌd̶ada jũma jĩgua lesia. Idjia lesia israelerãba maʌ̃ leyda ĩjã od̶ibʌrʌ Ãcõrẽba careba b̶aida baribʌrʌ ĩjãnaẽ́bʌrʌ Ãcõrẽba biẽ́ b̶ʌida. ");
INSERT INTO empNTpo_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","Moiseba b̶ʌd̶ara Josueba israelerã dji umaquĩrãrã, wẽrãrã, warrarã, drua ãĩbema ãdjirã tãẽna panʌ quĩrãpita jũma jĩgua lesia. ");
INSERT INTO empNTpo_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","Maʌ̃ ewarid̶e hititarãda, amorreorãda, cananeorãda, perezeorãda, heveorãda, jebuseorã sid̶a Canaaʌ̃ druad̶e panabadjid̶aa. Jordaʌ̃ dod̶eba ʌ̃mãdau b̶aebariare jewed̶ad̶e, eyad̶e bid̶a ʌ̃cʌrʌ panabadjid̶aa, idjab̶a jũma Mediterraneo pusa orroare ʌ̃cʌrʌ panabadjid̶aa ab̶a Libanonaa. Ãdji bororãba ũrĩsid̶aa israelerãba Jericora, Hai sid̶a poyasid̶ada. ");
INSERT INTO empNTpo_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","Maʌ̃ carea jũma ãbaa bed̶ea ausid̶aa Josue ume idjab̶a israelerã ume djõne wãni carea. ");
INSERT INTO empNTpo_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","Baribʌrʌ heveorã Gabaoʌ̃nebemada maʌ̃ bororã ume bed̶ea aud̶aẽ́ basía. Ãdjia bid̶a ũrĩsid̶aa Josueba Jericod̶ebemarãra, Haid̶ebemarã sid̶a jũma quenabisida. ");
INSERT INTO empNTpo_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","5","Maʌ̃ba crĩchasid̶aa israelerãra cũrũgad̶ida ãdji quenarãnamãrẽã. Maʌ̃ carea ʌ̃cʌrʌ edasid̶aa israelerãmaa wãnamãrẽã. Ãdjia edaped̶ad̶aba cacuad̶e jʌ̃bada soresorea b̶eada jʌ̃sid̶aa. Ãdjia jĩrũne jʌ̃bada sid̶a capirud̶aid̶a b̶eada jʌ̃sid̶aa. Maʌ̃be Josuemaa wãbʌrʌsid̶aa. Ãdji netata edebadara soresorea b̶eada burro ʌ̃rʌ̃ edesid̶aa. Uva b̶a tʌbada animarã e od̶ara capirud̶aid̶a b̶eada, paʌ̃ zarea ãrĩna sid̶a edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","Gilgal ẽjũãne Josue b̶ʌma jũẽnaped̶a Josuéa waabema israelerãa bid̶a nãwã jarasid̶aa: –Daira drua tʌmʌba zebʌdaa. Quĩrĩã panʌa bãrãra dai ume bed̶ea b̶ʌd̶ida necai duanani carea.– ");
INSERT INTO empNTpo_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","Maʌ̃ne israelerãba nãwã jarasid̶aa: –Ãĩbẽrã bãrãra dairã caita panʌda jãwã panʌsicada. Mãwãra ¿sãwã bãrã ume bed̶ea b̶ʌd̶i?– ");
INSERT INTO empNTpo_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","Gabaoʌ̃nebemarãba nãwã panusid̶aa: –Daira bãrã nezocarãa.– Maʌ̃ne Josueba nãwã iwid̶isia: –¿Bãrãra cairãda jãwã panʌ? ¿Sãmaʌba ze panʌ?– ");
INSERT INTO empNTpo_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","Ãdjia panusid̶aa: –Daira drua ãĩba tʌmʌba ze panʌa bãrã Ãcõrẽra trʌ̃ b̶ʌga b̶ʌ bẽrã. Daiba ũrĩsid̶aa idjia sãwã Egiptod̶e osida. ");
INSERT INTO empNTpo_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","Idjab̶a ũrĩsid̶aa sãwã Jordaʌ̃ quĩrãrẽbema amorreo bororãda poyasida. Naãrã Sehoʌ̃, Hesboʌ̃ purud̶ebemada poyasia. Maʌ̃are Og, Basaʌ̃ druad̶ebema Astarot purud̶e b̶ad̶a sid̶a poyasia. ");
INSERT INTO empNTpo_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","Maʌ̃ bẽrã dai bororãba, dai druad̶ebemarã bid̶a nãwã jarasid̶aa: “Ota cod̶ira edad̶aped̶a israelerãmaa wãnadua. Ãdjirãa jarad̶adua dadjirãra ãdji nezocarã bẽrã necai b̶ead̶i carea ãdjirã ume bed̶ea b̶ʌ quĩrĩã panʌda.” ");
INSERT INTO empNTpo_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","Acʌd̶adua, dai zesid̶a ewarid̶e naʌ̃ paʌ̃ra wad̶ibid̶a jʌ̃wʌ̃rʌ̃ã b̶easia baribʌrʌ id̶ira zareacuaped̶a jũma ãrĩcuasia. ");
INSERT INTO empNTpo_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","Idjab̶a za panʌ uva b̶a tʌbada animarã e od̶a sid̶a enesid̶ad̶e wad̶ibid̶a djiwid̶ida b̶easia. Baribʌrʌ jũma dji sore bacuasia. Daiba cacuad̶e jʌ̃badara, jĩrũne jʌ̃ panʌ sid̶a dji sore bacuasia.– ");
INSERT INTO empNTpo_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","Gabaoʌ̃nebemarãba paʌ̃ eneped̶ad̶ara israelerãba ʌ̃cʌrʌ cosid̶aa. Mãwã cawabisid̶aa Gabaoʌ̃nebemarã ume bed̶ea b̶ʌd̶ida. Baribʌrʌ mãwã od̶i naẽna Ãcõrẽa iwid̶id̶aẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","Maʌ̃ne Josuera Gabaoʌ̃nebemarã ume bed̶ea b̶ʌsia necai panani carea. Wãrãneba jarasia ãdjirãra bead̶aẽ́da. Waabema israelerã bororã bid̶a ab̶arida wãrãneba jarasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","Ewari ũbea bad̶acarea israelerãba cawasid̶aa Gabaoʌ̃nebemarãba ãdjirãra cũrũgasid̶ada. Cawasid̶aa tʌmʌba zed̶aẽ́ basida, ãtebʌrʌ ãdjirã caita panabadada. ");
INSERT INTO empNTpo_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","Ara maʌ̃da israelerãra ãdjirã caid̶u wãsid̶aa. Ewari ũbea babʌrʌd̶e ãdji puru b̶ead̶aa jũẽne wãsid̶aa. (Ãdji purura naʌ̃gʌrã basía: Gabaoʌ̃ araa, Capira, Beerot idjab̶a Quiriat-jeariʌ̃.) ");
INSERT INTO empNTpo_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","Baribʌrʌ israelerãba Gabaoʌ̃nebemarãra bead̶aẽ́ basía, Ãcõrẽ trʌ̃neba dji bororãba wãrãneba jaraped̶ad̶a bẽrã ãdjirãra bead̶aẽ́da. Maʌ̃ carea israelerãba ara ãdji bororãda biẽ́ jara panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","Baribʌrʌ dji bororãba nãwã jarasid̶aa: –Dadji israelerã Ãcõrẽ trʌ̃neba naʌ̃ Gabaoʌ̃nebemarã ume bed̶ea b̶ʌsid̶aa. Maʌ̃ bẽrã ãdjirãra bead̶acara panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","Ãtebʌrʌ zocai b̶ʌd̶ia. Dadjirãba wãrãneba jaraped̶ad̶ara ĩjã od̶aẽ́bʌrʌ Ãcõrẽda dadjirã ume quĩrũya.– ");
INSERT INTO empNTpo_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","Maʌ̃ba israelerã bororãba jarasid̶aa Gabaoʌ̃nebemarã zocai b̶ʌd̶amãrẽã. Baribʌrʌ ãdjirãra b̶ʌsid̶aa israelerã itea tʌbʌ b̶ʌá pananamãrẽã idjab̶a baido jue pananamãrẽã. Mãwã israelerã bororãba wãrãneba jaraped̶ad̶ara osid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","Josueba Gabaoʌ̃nebemarãra trʌ̃biped̶a nãwã jarasia: –Bãrãba ¿cãrẽ cãrẽã dairãra cũrũgasid̶a? ¿Cãrẽ cãrẽã tʌmʌba ze panʌana asid̶a? ¡Bãrãra dairã caita panabadaa! ");
INSERT INTO empNTpo_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","Bãrãba dairãda cũrũgaped̶ad̶a bẽrã dai Ãcõrẽba bãrãra biẽ́ erob̶aya. Id̶iba ʌ̃ta bãrãra dai nezocarãda panania. Dai Ãcõrẽ de itea tʌbʌ b̶ʌá panania idjab̶a baido jue panania.– ");
INSERT INTO empNTpo_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","Ãdjia Josuéa nãwã panusid̶aa: –Ne wayaad̶eba dairãba mãwã osid̶aa. Cawasid̶aa bãrã Ãcõrẽba idji nezoca Moisea jarasida dai drua bãrãa jũma diamãrẽã idjab̶a dairã jũma quenamãrẽã. Maʌ̃ bẽrã crĩchasid̶aa bãrãba dairãra jũma quenanida. ");
INSERT INTO empNTpo_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","Dairãra bãrã jʌwaed̶a panʌa. Bʌa jipa oida crĩcha b̶ʌ quĩrãca odua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","Mãwã jaraped̶ad̶a bẽrã Josueba israelerãa Gabaoʌ̃nebemarãra idu beabiẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","Baribʌrʌ ãdjirãra b̶ʌsia israelerã itea tʌbʌ b̶ʌá pananamãrẽã idjab̶a baido jue pananamãrẽã. Ãcõrẽa animarã babue diabada itea bid̶a mãwã o panesid̶aa. Wad̶ibid̶a mãwã obadaa Ãcõrẽba idji de obid̶ama. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Maʌ̃ ewarid̶e Adonisedéda Jerusaleʌ̃nebema boro basía. Adonisedéba ũrĩsia Josueba Haid̶ebemarãra poyaped̶a purura jũma babueped̶a dji borora beasida Jericod̶e od̶a quĩrãca. Maʌ̃ awara ũrĩsia Gabaoʌ̃nebemarãda israelerã ume necai panani carea bed̶ea b̶ʌd̶aped̶a ãdjirãare panesid̶ada. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","Maʌ̃ba idjira bio ne waya b̶esia, Gabaoʌ̃ra Hai puru cãyãbara waib̶ʌara b̶ad̶a bẽrã. Dji bororã panabada puru quĩrãca b̶asia. Maʌ̃ awara Gabaoʌ̃nebema sordaorãra bio mẽsrã b̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Maʌ̃ bẽrã Jerusaleʌ̃nebema boro Adonisedéba bed̶ea diabuesia Hebroʌ̃nebema boro Hohaʌ̃maa, Jarmud̶ebema boro Pireaʌ̃maa, Laquid̶ebema boro Japiamaa, idjab̶a Egloʌ̃nebema boro Debiramaa bid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","Nãwã jarabisia: –Mʌ̃ carebad̶e zed̶adua. Gabaoʌ̃nebemarã ume djõne wãnia. Ãdjira Josue ume idjab̶a israelerã ume necai panani carea bed̶ea b̶ʌsid̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Ara maʌ̃da amorreorã bororã juesuma panʌra jũma ãdji sordaorã ume ãbaa wãnaped̶a Gabaoʌ̃ purura jũrã edasid̶aa urad̶i carea. Jerusaleʌ̃nebemada, Hebroʌ̃nebemada, Jarmud̶ebemada, Laquid̶ebemada idjab̶a Egloʌ̃nebema sid̶a wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Maʌ̃ unusid̶ad̶e Gabaoʌ̃nebemarãba Gilgald̶aa Josue b̶ʌmaa nãwã jarabisid̶aa: –Eyad̶ebema amorreo bororãra jũma ãbaa dairã ume djõne zesid̶aa. Dairãra bãrã nezocarã bẽrã dadub̶a djõbirãnadua. ¡Isabe dairã carebad̶e zed̶adua!– ");
INSERT INTO empNTpo_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Ara maʌ̃da Josuera, idji sordaorã bio mẽsrã b̶eada, waabema sordaorã sid̶a Gilgald̶eba ãdjimaa wãbʌrʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Maʌ̃ne Ãcõrẽba Josuéa nãwã jarasia: –Amorreorãra wayarãdua. Mʌ̃a bãrãa ãdjirãra poyabiya. Djõbʌdad̶e ãdjirã ni ab̶aʌba droad̶aẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Gilgald̶eba jũma maʌ̃ diamasi nĩbad̶aped̶a Josuera idji sordaorã ume araa jũẽnaped̶a amorreorãba adua panʌne urasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Israelerãba urabʌdad̶e Ãcõrẽba amorreorãra ne wayabiped̶a memenesid̶aa. Mãwã israelerãba ãdjirãra Gabaoʌ̃ druad̶e zocãrã quenasid̶aa. Amorreorã ʌ̃taa Bet-horoʌ̃naa mĩrũ wãbʌdad̶e israelerãba caid̶u quena wãsid̶aa ab̶a Azecá purud̶aa idjab̶a Maquedá purud̶aa bid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Amorreorã Bet-horoʌ̃neba ed̶aa Azecád̶aa mĩrũ wãbʌdad̶e Ãcõrẽba hielo waib̶ʌada cue quĩrãca ãdjirã ʌ̃rʌ̃ jurrubisia. Israelerãba necoba quenaped̶ad̶a cãyãbara maʌ̃gʌba zocãrãara quenasia. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Ãcõrẽba israelerãa amorreorã poyabid̶a ewarid̶e Josueba israelerã quĩrãpita nãwã jĩgua jarasia: Ãcõrẽ, ʌ̃mãdaura Gabaoʌ̃ ẽjũãne ipi cob̶ʌdua; jed̶eco sid̶a Ajaloʌ̃ jewed̶ad̶e ipi cob̶ʌdua. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Ara maʌ̃da ʌ̃mãdaura, jed̶eco sid̶a ipi copanesid̶aa ab̶a israelerãba ãdjirã dji quĩrũ jũma quenabʌdad̶aa. Maʌ̃gʌra Jaserba idji cartad̶e jũma b̶ʌsia. Josueba mãwã jarabʌrʌd̶e ʌ̃mãdaura umatipa cob̶ʌda berara ewari ab̶a b̶aeẽ́ b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Josueba Ãcõrẽa iwid̶id̶ara ne ununaca droma basía. Maʌ̃ naẽna ẽberãba ne ununaca droma iwid̶id̶ara Ãcõrẽba ĩjã oca basía. Idjab̶a maʌ̃ ewarid̶eba ʌ̃taa ĩjã oẽ́ b̶ʌa. Baribʌrʌ maʌ̃ ewarid̶e Ãcõrẽba ĩjã osia israelerãare djõ b̶ʌ bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Mãwãnacarea Josuera israelerã sid̶a wayacusa Gilgald̶aa ãdji cãĩbadamaa wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","Maʌ̃misa amorreo bororã juesuma panʌra Maquedá puru caita uriad̶e mĩrũsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","Baribʌrʌ mama mĩrũ panʌda ununaped̶a ʌ̃cʌrʌba Josuéa jarad̶e wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","Maʌ̃ne Josueba idji sordaorãa nãwã jarasia: –Mõgara waib̶ʌada bʌrab̶ari eded̶aped̶a uriara jũãtrʌ nũmʌnadua. Maʌ̃be ʌ̃cʌrʌba mama jʌ̃ã panenadua ãdjirã ẽdrʌrãnamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","Waabemarãba dji quĩrũra ẽpẽnaped̶a jẽdaareba quena wãnadua ãdji purud̶e jũẽrãnamãrẽã. Dadji Ãcõrẽba bãrãa ãdjirãra jũma poyabibʌrʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","Mãwã Josueba israelerã ume amorreorãra berara jũma quenasid̶aa. Zocãrãẽ́be ãdji puru mõgaraba jũrã ca b̶ead̶e jũẽnaped̶a mĩrũ panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","Maʌ̃ne israelerã ni ab̶aʌda beud̶aẽ́ basía. Jũmaena bia jẽda zesid̶aa Maquedá purud̶aa Josue b̶ʌmaa. Maʌ̃ bẽrã jũmarãba wayasid̶aa israelerã biẽ́ od̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","Maʌ̃ne Josueba idji sordaorãa jarasia: –Isabe mõgara uria jũãtrʌ b̶ʌra ãyã b̶ʌd̶adua. Maʌ̃be dji bororã juesuma panʌra dajadaa mʌ̃maa enenadua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","Ara maʌ̃da dji bororã juesuma panʌra dajadaa enesid̶aa: Jerusaleʌ̃nebema boro, Hebroʌ̃nebema boro, Jarmud̶ebema boro, Laquid̶ebema boro, Egloʌ̃nebema boro sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","Maʌ̃ bororã Josuemaa enenapeda Josueba idji sordaorãra jũma trʌ̃ped̶a sordaorã bororã idji ume panʌ́a nãwã jarasia: –Nama zed̶aped̶a jĩrũba ãdji ochirud̶e tʌga eronũpananadua.– Ara maʌ̃da zed̶aped̶a ochirud̶e tʌga eronũpanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","Maʌ̃ne Josueba israelerãa jarasia: –Za dadjirãba obʌda quĩrãca Ãcõrẽba jũma dadjirã dji quĩrũ sid̶a oya. Ne wayarãnadua. Ni maãrĩ bid̶a jẽda crĩcharãnadua. Ʌb̶ʌa b̶ead̶aped̶a sozarra b̶ead̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","Mãwã jaraped̶a Josueba dji bororã juesuma panʌra beasia. Beaped̶a ãdjira bacuru cũmiane su jira b̶ʌcuabisia. Mãwã jira panesid̶aa ab̶a queubʌrʌd̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","Queubod̶od̶e Josueba ãdjira ed̶aa edabiped̶a ãdji mĩrũ panana uriad̶e b̶atacuabisia. Maʌ̃be mõgara waib̶ʌa b̶eaba dji uriara jũãtrʌ nũmʌsid̶aa. Maʌ̃ mõgarara wad̶ibid̶a mama b̶eaa. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","Maʌ̃ ewarid̶e Josueba idji sordaorã ume Maquedá purura poyad̶aped̶a jũma babuesid̶aa. Mamabemarãda necoba jũma quenasid̶aa. Ni ab̶aʌda zocai b̶ʌd̶aẽ́ basía. Josueba Maquedád̶ebema borora beasia Jericod̶ebema boro bead̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","Mamaʌba Josuera idji sordaorã ume Libna purud̶aa djõne wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","Ãcõrẽba Libna purura, dji boro sid̶a israelerãa poyabiped̶a Josueba jũma quenabisia. Ni ab̶aʌda zocai b̶ʌẽ́ basía. Dji boro sid̶a beasia Jericod̶ebema boro bead̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","Mamaʌba Josueba idji sordaorã ume Laqui purura jũrã edad̶aped̶a araa djõne wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","Ewari umé babʌrʌd̶e Ãcõrẽba israelerãa Laquid̶ebemarãra poyabisia. Ãdjirã sid̶a necoba jũma quenasid̶aa Libnanebemarã quenaped̶ad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","Maʌ̃ne Guezerd̶ebema boro Horaʌ̃ra idji sordaorã ume Laquid̶ebemarã carebad̶e wãsid̶aa. Baribʌrʌ Josueba idjira, idji sordaorã sid̶a poyaped̶a ãdjirãra jũma quenabisia. Ni ab̶aʌda zocai b̶ʌẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","Mamaʌba Josuera idji sordaorã ume wãbʌrʌsid̶aa Egloʌ̃ purud̶aa. Purura jũrã edad̶aped̶a araa djõne wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","Ara maʌ̃ ewarid̶e Josue sordaorãba poyad̶aped̶a necoba jũma quenasid̶aa Laquid̶e oped̶ad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","Egloʌ̃neba Josuera idji sordaorã ume Hebroʌ̃ purud̶aa djõne wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","Poyad̶aped̶a necoba jũma quenasid̶aa. Dji borora, puru caita b̶ea ẽberãrã sid̶a quenasid̶aa. Ni ab̶aʌda zocai b̶ʌd̶aẽ́ basía. Egloʌ̃ne oped̶ad̶a quĩrãca Hebroʌ̃nebemarãra quenanaped̶a purura jũma babuesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","Mamaʌba Josuera israelerã ume Debir purud̶aa djõne wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","Poyad̶aped̶a dji borora, puru caita b̶ea ẽberãrã sid̶a necoba jũma quenasid̶aa. Ni ab̶aʌda zocai b̶ʌd̶aẽ́ basía. Hebroʌ̃nebemarã, Libnanebemarã, idjab̶a maʌ̃ purud̶ebema bororã oped̶ad̶a quĩrãca jũma quenasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","Mãwã Josueba maʌ̃ ẽjũãne b̶ead̶arãra jũma poyasia. Eyad̶e b̶ead̶ada, Negue ẽjũãne b̶ead̶ada, jewed̶ad̶e b̶ead̶ada, eya carrad̶e b̶ead̶ada, dji puru bororã sid̶a jũma poyaped̶a quenasia israelerã Ãcõrẽba jarad̶a quĩrãca. Ni ab̶aʌda zocai b̶ʌẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","Josueba jũmarãda poyasia Cadé-barnead̶eba ab̶a Gazad̶aa idjab̶a Goseʌ̃neba ab̶a Gabaoʌ̃naa. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","Dãrãẽ́ne Josueba jũma maʌ̃ ẽjũãne b̶ea puru bororãda poyaped̶a ãdji ẽjũãra edasia Ãcõrẽra israelerãare djõna bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","Mãwãnacarea Josuera idji sordaorã ume Gilgald̶aa jẽda wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","Maʌ̃ ewarid̶e Jabiʌ̃ abadada Hazor purud̶ebema boro basía. Maʌ̃ Jabiʌ̃ba ũrĩsia Josueba zocãrã poyasida. Maʌ̃ carea dewara puru bororãmaa bed̶eada diabuecuasia israelerã ume djõne wãni carea. Maʌ̃ bed̶eara diabuesia Madoʌ̃ purud̶ebema boro Jobámaa, Simroʌ̃ purud̶ebema boromaa, Acsap purud̶ebema boromaa, ");
INSERT INTO empNTpo_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","dji wãrãga eyaid̶a b̶ʌ ẽjũãne b̶ea bororãmaa, Cineret amene caita b̶ea bororãmaa, Dor puru caita b̶ea bororãmaa, ʌ̃mãdau b̶aebariare b̶ʌ jewed̶ad̶e b̶ea bororãmaa, ");
INSERT INTO empNTpo_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","ʌ̃mãdau odjabariare b̶ea cananeorã bororãmaa, ʌ̃mãdau b̶aebariare b̶ea cananeorã bororãmaa, amorreorã bororãmaa, hititarã bororãmaa, perezeorã bororãmaa, eyaid̶a b̶ʌ ẽjũãne b̶eaa jebuseorã bororãmaa, Hermoʌ̃ eya carrad̶e b̶ea heveorã bororãmaa idjab̶a Mizpa jewed̶ad̶e b̶ea bororãmaa bid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","Maʌ̃ bororãba cawayod̶eba djõbadarãda, carretad̶eba djõbadarãda, waabema sordaorã sid̶a jũma djõne edesid̶aa. Bio cãbana wãsid̶aa. Pusa ĩbʌ quĩrãca ãdjirãra poya juachad̶aca basía. ");
INSERT INTO empNTpo_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","Maʌ̃ bororãra israelerã ume djõni carea ãbaa wãnaped̶a Meroʌ̃ do zaqued̶e duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","Maʌ̃ne Ãcõrẽba Josuéa jarasia: –Ãdjirãra wayarãdua. Nu ara naʌ̃ hora quĩrãca mʌ̃a bãrãa ãdjirãra jũma quenabiya. Maʌ̃ne ãdji cawayo jĩrũ quẽgura jũma tʌcuad̶adua idjab̶a ãdji djõbada carretara jũma bácuad̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","Maʌ̃be Josueba idji sordaorã ume Meroʌ̃ do zaqued̶e cawaẽ́ne urad̶e wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","Ãcõrẽba israelerãa ãdjirãra poyabisia. Maʌ̃ne israelerãba ʌ̃cʌrʌ ẽpẽsid̶aa ab̶a Misrepot dod̶aa idjab̶a Sidoʌ̃ puru caita. Maʌ̃ awara ʌ̃cʌrʌ ẽpẽsid̶aa ab̶a Mizpa ẽjũãnaa. Ab̶ed̶a jũma quenasid̶aa. Ni ab̶aʌda zocai b̶ʌd̶aẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","Ãcõrẽba jarad̶a quĩrãca Josueba jũma osia. Ãdji cawayo jĩrũ quẽgura jũma tʌcuasia idjab̶a ãdji djõbada carretara jũma bácuasia. ");
INSERT INTO empNTpo_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","Maʌ̃be Josue idji sordaorã ume jẽda zebʌdad̶e Hazor purud̶aa djõne wãsid̶aa. Poyad̶aped̶a Josueba dji borora beasia. (Hazord̶ebema borora dewararã cãyãbara dji dromaara b̶asia.) ");
INSERT INTO empNTpo_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","Mama jũmarãda necoba quenasid̶aa. Ni ab̶aʌda zocai b̶ʌd̶aẽ́ basía. Puru sid̶a jũma babuesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","Israelerã ume djõped̶ad̶a bororãra Josueba necoba jũma beasia. Maʌ̃ bororã puru b̶eara poyaped̶a jũma babuesia Ãcõrẽ nezoca Moiseba jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","Israelerãba puru eya zaqued̶e b̶eara jũma babued̶aẽ́ basía. Josueba ab̶abe Hazordrʌ babuesia. ");
INSERT INTO empNTpo_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","Baribʌrʌ puruza jũmarãda necoba quenasid̶aa. Ni ab̶aʌda zocai b̶ʌd̶aẽ́ basía. Ãdji animarãra, ne bia qued̶ea sid̶a ãdji itea jũma edasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","Ãcõrẽba Moisea jarad̶ara Moiseba Josuéa jũma jarasia. Maʌ̃ra Josueba jũma daucha osia. ");
INSERT INTO empNTpo_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","Josueba poyaped̶a ẽjũãda jũma edasia: Negue ẽjũãda, maʌ̃are b̶ʌ eyaid̶a b̶ʌ ẽjũãda, Goseʌ̃ ẽjũãda, ʌ̃mãdau b̶aebariare b̶ʌ jewed̶ada, Jordaʌ̃ do jewed̶ada, idjab̶a eyaid̶a b̶ʌ ẽjũã Israel abadada dji jewed̶a sid̶a. ");
INSERT INTO empNTpo_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","Jũma edasia Halac eyad̶eba ab̶a Baal-ga purud̶aa. Halac eyara Seír druad̶e b̶ʌa. Baal-ga purura Libano ẽjũãne b̶ʌa Hermoʌ̃ eya carrad̶e. Puruza dji borora Josueba jidaped̶a jũma beasia. ");
INSERT INTO empNTpo_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","Idjira maʌ̃ bororã ume dãrã djõsia. ");
INSERT INTO empNTpo_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","Ab̶abe heveorã Gabaoʌ̃nebemada israelerã ume necai panani carea bed̶ea b̶ʌsid̶aa. Waabema purura israelerãba poyasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","Wãrãda Ãcõrẽbʌrʌ maʌ̃ purud̶ebemarãra so zarea b̶ʌsia israelerã ume djõne wãnamãrẽã. Mãwã quĩrã djuburia neẽ́ israelerãba ãdjirãra jũma quenasid̶aa Ãcõrẽba Moisea jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","Maʌ̃ ewarid̶e Josueba anaquitarã ẽjũã eyaid̶a b̶ʌd̶e pananara poyaped̶a jũma quenasia. Hebroʌ̃ purud̶e b̶ead̶ada, Debir purud̶e b̶ead̶ada, Anab purud̶e b̶ead̶a sid̶a quenaped̶a ãdji purura jũma babuesia. Mãwã Juda ẽjũã eyaid̶a b̶ʌd̶e, waabema israelerã ẽjũã eyaid̶a b̶ʌd̶e bid̶a anaquitarãra jũma quenasia. ");
INSERT INTO empNTpo_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","Anaquitarã ni ab̶aʌda Israel druad̶e zocai b̶eẽ́ basía. Ab̶abe Gaza purud̶e, Gat purud̶e, Asdo purud̶e bid̶a panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","Mãwã Josueba jũma maʌ̃ druara edasia Ãcõrẽba Moisea jarad̶a quĩrãca. Dji ẽjũãra Josueba israelerãa jũma jed̶ecasia. Israeld̶eba yõped̶ad̶a puruza ẽjũãda diasia ãdjirãne bamãrẽã. Maʌ̃be israelerãra ãdji druad̶e necai duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","Ãcõrẽba Josuéa nãwã jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","–Israelerãa jaradua mĩrũbada puruda b̶ʌcuad̶amãrẽã mʌ̃a Moised̶eba bãrãa jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","Mĩã beai crĩchaẽ́ b̶ʌd̶e ab̶aʌba djãrãda beaibʌrʌ, dji beud̶a ẽberãrãba idji bead̶i naẽna maʌ̃ purud̶aa mĩrũ wãida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","Mama jũẽped̶a ed̶a wãi naẽna purud̶e ed̶a wãbadama dji bororãa jũma nẽbʌrʌida b̶ʌa sãwãsida. Dji bororãba cawasid̶ara maʌ̃ ẽberãba jara b̶ʌra wãrãda, idjira purud̶e idu ed̶a wãbid̶aped̶a jarad̶ida panʌa sãma b̶eida b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","Maʌ̃ne dji beud̶a ẽberãrãba idjida bead̶i carea maʌ̃ purud̶e iwid̶id̶e wãnibʌrʌ, dji bororãba idjira diacara panʌa mĩã beai crĩchaẽ́ b̶ʌd̶e bead̶a bẽrã idjab̶a quĩrũbid̶eba mĩã bead̶aẽ́ bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","Baribʌrʌ idjira mamaʌba ãyã wãcara b̶ʌa ab̶a dji cawa obadarãba jũmarã quĩrãpita wãrãda bed̶ead̶e b̶ʌẽ́ana abʌdad̶aa. Maʌ̃ awara ãyã wãcara b̶ʌa ab̶a sacerdote dji dromaara b̶ʌda jaid̶abʌrʌd̶aa. Mãwãnacarea wayacusa idji purud̶e b̶ad̶e wãida b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","Mãwã jarad̶a bẽrã israelerãba mĩrũbada puruda b̶ʌcuasid̶aa. Neptali ẽjũã eyaid̶a b̶ʌd̶e Quedé puruda b̶ʌsid̶aa. Maʌ̃ purura Galilea druad̶e b̶ʌa. Epraiʌ̃ ẽjũã eyaid̶a b̶ʌd̶e Siqueʌ̃ puruda b̶ʌsid̶aa. Juda ẽjũã eyaid̶a b̶ʌd̶e Quiriat-arbá puruda b̶ʌsid̶aa. Maʌ̃ purura idjab̶a Hebroʌ̃ abadaa. ");
INSERT INTO empNTpo_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","Jordaʌ̃ quĩrãrẽ Jericod̶eba ʌ̃mãdau odjabariare mĩrũbada puruda ũbea b̶ʌsid̶aa. Rubeʌ̃ ẽjũãne eya boro jewed̶ad̶e Beser puruda b̶ʌsid̶aa. Maʌ̃ purura ẽjũã põãsa ewaraga b̶ʌd̶e b̶ʌa. Ga ẽjũãne Ramo puruda b̶ʌsid̶aa. Maʌ̃ purura Gala druad̶e b̶ʌa. Manase ẽjũãne Golaʌ̃ puruda b̶ʌsid̶aa. Maʌ̃ purura Basaʌ̃ druad̶e b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","Maʌ̃ mĩrũbada puruda b̶ʌcuasid̶aa israelerã, drua ãĩbema ãdjirã tãẽna panʌ sid̶a poya mĩrũnamãrẽã. Mĩã beai crĩchaẽ́ b̶ʌd̶e ab̶aʌba djãrãda beasira mama mĩrũ b̶aida b̶asia ab̶a dji cawa obadarãba puru quĩrãpita wãrãda bed̶ea neẽ́ b̶ʌad̶a abʌdad̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","Mãwãnacarea Josueba Rubeʌ̃neba yõped̶ad̶ada, Gad̶eba yõped̶ad̶ada, idjab̶a ʌ̃cʌrʌ Manased̶eba yõped̶ad̶a sid̶a trʌ̃cuasia. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","Ãdjirãa nãwã jarasia: –Ãcõrẽ nezoca Moiseba obi jarad̶ara bãrãba jũma ĩjã osid̶aa. Mʌ̃a jarad̶a sid̶a jũma ĩjã osid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","Dairãra bãrã djabarã bẽrã, bãrãra dairãare dãrã djõsid̶aa. Id̶i bid̶a wad̶i mãwã panʌa. Dadji Ãcõrẽba obi jarad̶ara jũma osid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","Dadji Ãcõrẽba jarad̶a quĩrãca dairã, bãrã djabarãra naʌ̃ ẽjũãne necai b̶ʌsia. Jãʌ̃be bãrãra jẽda diguid̶aa wãnadua Ãcõrẽ nezoca Moiseba Jordaʌ̃ do quĩrãrẽ ẽjũã diad̶amaa. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","Baribʌrʌ Ãcõrẽ nezoca Moiseba ley diad̶ara quĩrãcuita jũma ĩjã od̶adua. Maʌ̃ leyba nãwã jara b̶ʌa: dadji Ãcõrẽra quĩrĩãnadua. Idji quĩrãpita jipa nĩbad̶adua. Idjia obi b̶ʌra ĩjã od̶adua. Ewariza idjira ẽpẽnadua. Jũma bãrã sod̶eba, jũma bãrã jaured̶eba bid̶a idjia jara b̶ʌra od̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","8","Mãwã jaraped̶a Josueba ãdjirãra nãwã bia jara b̶ʌsia: –Jãʌ̃be bãrã diguid̶aa jẽda wãnadua. Bãrã dji quĩrũ nebiara edaped̶ad̶a bẽrã id̶ibʌrʌ bio ne bara panesid̶aa. Animarãda, oroda, paratada, bronceda, jiorroda, cacuad̶e jʌ̃bada sid̶a zocãrã edasid̶aa. Maʌ̃ra bãrã djabarãa jed̶ecad̶adua.– Mãwã jaraped̶a Josueba ãdjirãra wãbisia. Ara maʌ̃da jẽda ãdji druad̶aa diguid̶aa wãsid̶aa. (Naẽna Moiseba Basaʌ̃ druara ʌ̃cʌrʌ Manased̶eba yõped̶ad̶arãa diasia. Mãwãnacarea Josueba waabema Manased̶eba yõped̶ad̶arãa Jordaʌ̃ dod̶eba ʌ̃mãdau b̶aebariare b̶ʌ ẽjũãda diasia ãdji djabarã israelerã tãẽna.) ");
INSERT INTO empNTpo_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","Rubeʌ̃neba yõped̶ad̶ara, Gad̶eba yõped̶ad̶ara idjab̶a ʌ̃cʌrʌ Manased̶eba yõped̶ad̶a sid̶a waabema israelerã ume Canaaʌ̃ druad̶e pananada Silo purud̶eba ãdji drua Galad̶aa jẽda wãbʌrʌsid̶aa. Gala druara ãdjirãba naẽna edasid̶aa Ãcõrẽba Moised̶eba jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","Gala druad̶aa wãbʌdad̶e Jordaʌ̃ dod̶e jũẽne wãsid̶aa. Mama Canaaʌ̃ orroare Jordaʌ̃ do icawa mõgarada waib̶ʌa ʌ̃tʌ pã buesid̶aa animarã babue diabada quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","Mãwã oped̶ad̶ara waabema israelerãba ũrĩsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","Maʌ̃ba ãdjirãba crĩchasid̶aa Galad̶e panʌba Ãcõrẽra igarasid̶ada. Maʌ̃ carea Silo purud̶e jũma ãbaa dji jʌresid̶aa Galad̶e panʌ ume djõne wãni carea. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","Baribʌrʌ djõne wãni naẽna sacerdote Eleaza warra Piné abadada Gala druad̶aa na diabuesid̶aa Rubeʌ̃neba yõped̶ad̶arã ume, Gad̶eba yõped̶ad̶arã ume, idjab̶a mama panʌ Manased̶eba yõped̶ad̶arã ume bed̶eamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","Piné ume israelerã bororãda die diabuesid̶aa. Ãdjira dji dromarãda b̶easia. Israeld̶eba yõped̶ad̶a puruzabemada ab̶a ab̶a diabuesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","Maʌ̃gʌrãra Galad̶aa wãsid̶aa Rubeʌ̃neba yõped̶ad̶arã ume, Gad̶eba yõped̶ad̶arã ume, idjab̶a mama panʌ Manased̶eba yõped̶ad̶arã ume bed̶ead̶amãrẽã. Jũẽnaped̶a nãwã jarasid̶aa: ");
INSERT INTO empNTpo_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","–Daira Ãcõrẽ puru trʌ̃neba nãwã bed̶eabʌdaa. ¿Bãrãba cãrẽ cãrẽã dadji israelerã Ãcõrẽra igarasid̶a? ¿Cãrẽ cãrẽã dadji Ãcõrẽ ẽpẽ pananada idu b̶ʌd̶aped̶a mõgarara ʌ̃tʌ pã buesid̶a dewara ãcõrẽa animarã babue diad̶i carea? ¿Cãrẽ cãrẽã idjia jara b̶ʌra ĩjã od̶aẽ́ basi? ");
INSERT INTO empNTpo_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","Dadji israelerãba Peor abadad̶e jũmawãyã cadjiruada osid̶a bẽrã zocãrã quinisid̶aa. Maʌ̃ cadjirua oped̶ad̶a carea wad̶ibid̶a bia mĩga panʌa. ¿Ara maʌ̃ba bia b̶ʌẽ́ca? ");
INSERT INTO empNTpo_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","Mãwãra ¿bãrãba wayacusa Ãcõrẽra igarad̶ica? Id̶i bãrãba mãwã od̶ibʌrʌ, nu Ãcõrẽra wayacusa jũma dadji israelerã ume bio quĩrũya. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","Bãrãmaa naʌ̃ Gala ẽjũãda Ãcõrẽ quĩrãpita biẽ́ b̶ʌbʌrʌ, idji wua de obid̶a druad̶aa zed̶aped̶a dairã tãẽna ẽjũãra edad̶adua. Baribʌrʌ Ãcõrẽba jarad̶ara igararãnadua. Daiba jara panʌ sid̶a igararãnadua. Dadjirãba Ãcõrẽ wua de caita animarã babue diabadada ab̶a eropanʌa. Maʌ̃ bẽrã dewarada orãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","Quĩrãnebad̶adua Jericod̶e Ãcõrẽba ne jũma babued̶aduad̶a ad̶amĩna Zerá warra Acaʌ̃ba ĩjãẽ́ ʌ̃cʌrʌ mẽrã edasida. Maʌ̃ carea Ãcõrẽra jũma dadji israelerã ume bio quĩrũsia. Acaʌ̃ba cadjirua od̶a carea idji awa beuẽ́ basía ãtebʌrʌ dewararã sid̶a beusid̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","Maʌ̃ne Rubeʌ̃neba yõped̶ad̶aba, Gad̶eba yõped̶ad̶aba idjab̶a mama panʌ Manased̶eba yõped̶ad̶a bid̶a israelerã bororãa nãwã panusid̶aa: ");
INSERT INTO empNTpo_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","–Ãcõrẽ dji dromaara b̶ʌba cawa b̶ʌa daiba ĩjã oẽ́ panʌneba ni idji igara panʌneba mãwã od̶aẽ́ basida. Maʌ̃ra jũma Israel puru bid̶a cawad̶ida panʌa. Dairãba Ãcõrẽ igarad̶i carea mãwã osid̶abʌrʌ, wa ĩjã oẽ́ panʌneba mãwã osid̶abʌrʌ, dairãra jũma quenanadua. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","Dairãba Ãcõrẽ igarad̶i carea maʌ̃ mõgarada ʌ̃tʌ pã buesid̶abʌrʌ idjia cawa oya. Maʌ̃ awara dewara ãcõrẽa animarã jũma babue diad̶i carea osid̶abʌrʌ, néud̶ebema babue diad̶i carea osid̶abʌrʌ, waa maʌ̃ ãcõrẽ ume necai b̶ead̶i carea animarã draga babue diad̶i carea osid̶abʌrʌ, Ãcõrẽba cawa oya. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","Wãrãda dairãba maʌ̃ mõgarara ʌ̃tʌ pã buesid̶aa bãrã warrarãba dai warrarã igararãnamãrẽã. Crĩchasid̶aa ewari ab̶a bãrã warrarãba dai warrarãa nãwã jarad̶isicada: “Bãrãra dai israelerã Ãcõrẽ ẽberãrãẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","Dai Ãcõrẽba Jordaʌ̃ dora dadjirã ẽsi b̶ʌsia bãrã Rubeʌ̃neba yõped̶ad̶ara, Gad̶eba yõped̶ad̶a sid̶a awara b̶ead̶amãrẽã. Maʌ̃ba bãrãra Ãcõrẽ ẽberãrãẽ́a.” Bãrã warrarãba mãwã jarasid̶ara dai warrarãa Ãcõrẽra igarabid̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","Maʌ̃ carea dairãba mõgarara ʌ̃tʌ pã buesid̶aa. Dewara ãcõrẽa animarã jũma babue diad̶i carea od̶aẽ́ basía, ni dewara sid̶a babue diad̶i carea od̶aẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","Ãtebʌrʌ jãwã osid̶aa bãrãba, dairãba, dadji warrarã bid̶a quĩrãnebad̶amãrẽã dairã bid̶a Ãcõrẽ de b̶ʌma animarãda babue diad̶ida panʌda, dewara sid̶a babued̶ida panʌda, idjab̶a Ãcõrẽ ume necai b̶ead̶i carea animarã dragada babue diad̶ida panʌda. Mãwãra nocoarebema ewarid̶e bãrã warrarãba dai warrarãa nãwã poya jarad̶aẽ́a: “Bãrãra Ãcõrẽ ẽberãrãẽ́a.” ");
INSERT INTO empNTpo_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","Dairãba crĩchasid̶aa ab̶aʌba dairãa wa dai warrarãa bid̶a mãwã jarad̶ibʌrʌ dairãba nãwã poya panunida: “Acʌd̶adua, dai drõãrãba za panʌ mõgara Ãcõrẽa animarã babue diabada quĩrãca b̶ʌda ʌ̃tʌ pã buesid̶aa. Baribʌrʌ animarã Ãcõrẽa babue diad̶i carea od̶aẽ́ basida. Ãtebʌrʌ maʌ̃ra osid̶aa bãrãba, dairã bid̶a quĩrãnebad̶amãrẽã jũma dadjirãra Ãcõrẽ ẽberãrãda.” ");
INSERT INTO empNTpo_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","Dairãba Ãcõrẽ igarad̶ira ni maãrĩ bid̶a crĩchad̶acaa. Idji ẽpẽ panʌda idu b̶ʌd̶aẽ́a. Ab̶abe idji wua de b̶ʌma animarãda jũma babue diad̶ia, néud̶ebemada babue diad̶ia, dewara sid̶a babue diad̶ia. Dewara animarã babue diabadada od̶aẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","31","Rubeʌ̃neba yõped̶ad̶aba, Gad̶eba yõped̶ad̶aba, idjab̶a mama panʌ Manased̶eba yõped̶ad̶a bid̶a jaraped̶ad̶ara sacerdote Eleaza warra Pinéba, israelerã bororã die panʌ bid̶a bia ũrĩsid̶aa. Maʌ̃ne Pinéba ãdjirãa nãwã jarasia: –Id̶i cawa panʌa Ãcõrẽra dadjirã ume b̶ʌda. Bãrãba Ãcõrẽra igarad̶aẽ́ panʌ bẽrã idjia dadji israelerãra cawa oẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","Mãwã bed̶eaped̶ad̶acarea sacerdote Eleaza warra Pinéra, israelerã bororã sid̶a jẽda Canaaʌ̃ druad̶aa wãsid̶aa. Maʌ̃be Rubeʌ̃neba yõped̶ad̶aba, Gad̶eba yõped̶ad̶a bid̶a Gala druad̶e jaraped̶ad̶ara ãdjirãba israelerãa jũma nẽbʌrʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","Maʌ̃ra israelerãba bia ũrĩnaped̶a Ãcõrẽa bia bed̶easid̶aa. Mamaʌba ʌ̃taa Rubeʌ̃neba yõped̶ad̶arã ume idjab̶a Gad̶eba yõped̶ad̶arã ume djõnida waa bed̶ead̶aẽ́ basía. Ãdji ẽjũã jũma ãrĩni sid̶a waa bed̶ead̶aẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","Rubeʌ̃neba yõped̶ad̶aba Gad̶eba yõped̶ad̶a ume mõgara ʌ̃tʌ pã bueped̶ad̶ara nãwã trʌ̃ b̶ʌsid̶aa: “Za panʌ mõgara ʌ̃tʌ pã bueped̶ad̶aba bãrãa, dairãa bid̶a quĩrãnebabi b̶ʌa dadjirã Borora Ãcõrẽda.” ");
INSERT INTO empNTpo_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","Israelerã dji quĩrũ ume djõ pananada Ãcõrẽba necai b̶ʌd̶acarea dãrãbʌrʌd̶e Josuera drõãda b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","Maʌ̃ne idjia israelerã dji drõãrãda, dji bororãda, dji cawa obadarãda, dji dromarã sid̶a jũma trʌ̃biped̶a nãwã jarasia: –Mʌ̃ra drõãda b̶ʌ bẽrã dãrã droaẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","Bãrãba unusid̶aa sãwã dadjirã Boro Ãcõrẽra dadjirãare djõsida. Idjia carebasia naʌ̃ druad̶e b̶ea purura poyad̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","Mãwãnacarea mʌ̃a ãdji ẽjũãra dadji Israeld̶eba yõped̶ad̶a puru doce panʌ́a jũma jed̶ecasia. Maʌ̃ awara dadjirãba wad̶i edad̶aẽ́ panʌ ẽjũã sid̶a mʌ̃a jarasia sãwã jed̶ecad̶ida panʌda. Jordaʌ̃ dod̶eba ab̶a ʌ̃mãdau b̶aebariare b̶ʌ Pusa Droma Mediterraneo abadad̶aa mʌ̃a jarasia sãwã ẽjũãra jed̶ecad̶ida panʌda. ");
INSERT INTO empNTpo_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","Dadji Boro Ãcõrẽba maʌ̃ ẽjũãne b̶ea ẽberãrãra bãrã quĩrãpitabemada jũma ãyã jʌrecuaya. Mãwã bãrãba ãdji ẽjũã sid̶a jũma edad̶ia idjia jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","Quĩrãcuita b̶ead̶adua. Ãcõrẽ ley Moiseba cartad̶e b̶ʌd̶ara jũma ĩjã o pananadua. Ni maãrĩ bid̶a ãĩ orãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","Ẽberãrã wad̶i naʌ̃ druad̶e b̶ea ume ãbaa b̶earãnadua. Ãdji ãcõrẽ b̶eara ẽpẽrãnadua. Maʌ̃rã quĩrãpita chĩrãborod̶e copanenaped̶a bia bed̶earãnadua idjab̶a iwid̶irãnadua. Wãrãneba jarad̶ibʌrʌ ãdji trʌ̃neba mãwã orãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","Ewariza ab̶a dadjirã Ãcõrẽdrʌ ĩjã pananadua id̶i ĩjã panʌ quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","Dadji Ãcõrẽba puru droma mẽsrã b̶eada bãrã quĩrãpitabemada ãyã jʌretacuasia. Ab̶a id̶i bid̶a ni ab̶aʌba bãrãra droad̶aẽ́ panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","Dadjirãnebema ab̶aʌba ãdjirã mil panʌra ãyã mĩrũ pirabibaria Ãcõrẽra dadjirãare djõ b̶ʌ bẽrã idjia jarad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","Maʌ̃ bẽrã quĩrãcuita b̶ead̶adua. Dadji Ãcõrẽra bio quĩrĩãnadua. ");
INSERT INTO empNTpo_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","13","Idjira igararãnadua. Maʌ̃ awara naʌ̃ druad̶ebemarã wad̶i dadjirã tãẽna b̶ea ume ãbaa b̶earãnadua. Bãrãba ãdji caurãda edad̶ibʌrʌ wa bãrã caurãda ãdjirãa diad̶ibʌrʌ, bio cawad̶adua dadji Ãcõrẽba ãdjirãra bãrã quĩrãpitabemada waa ãyã jʌretaẽ́da. Ãtebʌrʌ jʌ̃caraba animarã jidabada quĩrãca ãdjirãba bãrãra biẽ́ b̶ʌd̶ia. Soaba bãrã ẽcarrad̶e ubʌda quĩrãca wa ʌrʌ bãrã daud̶e b̶ʌ quĩrãca ãdjirãneba bãrãra bio mĩga panania ab̶a naʌ̃ ẽjũã bio bia b̶ʌ Ãcõrẽba diad̶ad̶e bãrã jũma quinibʌdad̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","Dãrãẽ́ne mʌ̃ra beuya. Mãwãmĩna bãrãba sod̶eba, jaured̶eba bid̶a cawa panʌa dadji Ãcõrẽba dadjirã itea oyad̶a ad̶ara wãrãda jũma osida. Ni maãrĩ bid̶a ãĩ oẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","Dadji Ãcõrẽba dadjirã itea ne bia oyad̶a ad̶ara wãrãda osimĩna idjida igarad̶ibʌrʌ idjia dadjirã biẽ́ b̶ʌi jarad̶a sid̶a wãrãda oya. Mãwã naʌ̃ ẽjũã bio bia b̶ʌ idjia diad̶ad̶e dadjirãra jũma quinibiya. ");
INSERT INTO empNTpo_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","Ãcõrẽba dadjirã ume bed̶ea b̶ʌd̶ada bãrãba ĩjã od̶aẽ́bʌrʌ, dewara ãcõrẽ b̶eada ẽpẽnaped̶a ãdji quĩrãpita chĩrãborod̶e copanenibʌrʌ, dadji Ãcõrẽra bãrã ume bio quĩrũya. Maʌ̃ba bãrãra dãrãẽ́ne naʌ̃ ẽjũã bio bia b̶ʌ idjia diad̶ad̶e jũma quininia.– ");
INSERT INTO empNTpo_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Josueba Siqueʌ̃ purud̶e israelerãra jũma ãbaa jʌresia. Maʌ̃ne dji drõãrãda, dji bororãda, dji cawa obadarãda, dji dromarã sid̶a caita trʌ̃cuaped̶a Ãcõrẽ quĩrãpita nũpanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Maʌ̃be Josueba purua nãwã jarasia: –Dadji Ãcõrẽba nãwã jara b̶ʌa: “Bãrã drõã naẽnabemarã Euprate do quĩrãrẽ panabadjid̶ad̶e jʌwaba od̶a ãcõrẽrãda ẽpẽbadjid̶aa. Tareba mãwã obadjia. Abrahaʌ̃ba, Naco bid̶a Tarera ãdji zeza basía. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Baribʌrʌ mʌ̃a Abrahaʌ̃da Euprate do quĩrãrẽba eneped̶a naʌ̃ Canaaʌ̃ druad̶e pʌrrʌabisia. Idjid̶eba mʌ̃a ẽberãrãda zocãrã yõbisia. Mʌ̃a idji warra Isada unubisia. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","Mʌ̃a Isaa warrada umé unubisia: Jacobo idjab̶a Esaú. Esaúa Seír eyaid̶a b̶ʌ druada diasia. Maʌ̃ne Jacobora idji warrarã sid̶a Egiptod̶e panane wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","Mãwãnacarea mʌ̃a Moiseda Aaroʌ̃ sid̶a Egiptod̶aa diabuesia bãrã ẽdrʌ enenamãrẽã. Mʌ̃a egiptorãra bia mĩgabiped̶a bãrãra ẽdrʌ enesia. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","Egiptod̶eba ẽdrʌ enebʌrʌd̶e Pusa Purru icawa jũẽsid̶aa. Maʌ̃ne Egiptod̶ebema carretad̶eba djõbadarãba, cawayod̶eba djõbadarã bid̶a bãrãra ẽpẽsid̶aa ab̶a Pusa Purrud̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","Maʌ̃ne bãrãba quĩrã djuburiada iwid̶id̶aped̶a mʌ̃a bãrã jẽdaare jʌ̃rãrã pãĩmada jira b̶ʌsia egiptorã nocoare. Egiptorãba Pusa Purrud̶e bãrã ẽpẽsid̶ad̶e mʌ̃a pusaa ãdjirãra ãnẽb̶ari edabisia. Mʌ̃a egiptorã cawa od̶ara bãrãba bio cawa panʌa bãrã drõãrãba unuped̶ad̶a bẽrã. Mãwãnacarea bãrãra ẽjũã põãsa ewaraga b̶ʌd̶e bio dãrã pʌrrʌa nĩbasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","Mãwã nĩnane mʌ̃a bãrãra Jordaʌ̃ dod̶eba ʌ̃mãdau odjabariare panʌ amorreorãmaa edesia. Maʌ̃ne ãdjirãra bãrã ume djõsid̶aa. Baribʌrʌ mʌ̃a bãrãa ãdjirãra poyabisia. Bãrã djõsid̶ad̶e mʌ̃a ãdjirãra quenabiped̶a bãrãba ãdji ẽjũãra jũma edasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Mãwãnacarea moabitarã boro Zipor warra Baláda bãrã israelerã ume djõ quĩrĩã b̶asia. Maʌ̃ne idjia Beor warra Balaaʌ̃da trʌ̃bisia bãrã biẽ́ jara b̶ʌmãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","Baribʌrʌ mʌ̃a Balaaʌ̃a idu mãwã obiẽ́ basía. Ãtebʌrʌ idjia bãrãra b̶arima zocãrã bia jara b̶ʌsia. Mãwã idjia biẽ́ jara b̶ʌi bad̶ad̶ebemada mʌ̃a bãrãra ẽdrʌ edasia. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","Mamaʌba Jordaʌ̃ do chãnaped̶a bãrãra Jerico caita jũẽne wãsid̶aa. Maʌ̃ne Jericod̶ebemarãra bãrã ume djõsid̶aa baribʌrʌ mʌ̃a bãrãa poyabisia. Ara maʌ̃ quĩrãca mʌ̃a amorreorãda, perezeorãda, cananeorãda, hititarãda, gergeseorãda, heveorãda, jebuseorã sid̶a bãrãa jũma poyabisia. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","Bãrãba chaba idjab̶a necoba ãdjirãra poyad̶aẽ́ basía. Ãtebʌrʌ bãrã djõne wãsid̶ad̶e mʌ̃abʌrʌ ãdjirãra ne wayabiped̶a mĩrũ wãbʌrʌsid̶aa nedʌrrʌba orrabʌrʌ quĩrãca. Ara maʌ̃ quĩrãca mʌ̃a naẽna osia amorreo bororã umé pananara. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","Mʌ̃a ãdji ẽjũãra néu bara, puru sid̶a bãrãa jũma diasia. Mãwã uva, olivo sid̶a bãrãba uped̶ad̶aẽ́da cobadaa. Idjab̶a bãrãba oped̶ad̶aẽ́ puru b̶ead̶e panabadaa.”– ");
INSERT INTO empNTpo_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","Maʌ̃ awara Josueba nãwã jarasia: –Ãcõrẽba mãwã od̶a bẽrã idjira wayad̶adua. Ewariza sod̶eba idjira ĩjã pananadua. Jʌwaba od̶a ãcõrẽ b̶ea dadji drõã naẽnabemaba Euprate do quĩrãrẽ ẽpẽ pananada idjab̶a Egiptod̶e ẽpẽ panana sid̶a jũma b̶atacuad̶adua. Ab̶abe dadjirã Ãcõrẽdrʌ ẽpẽnadua. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Baribʌrʌ bãrãba dadji Ãcõrẽda ẽpẽ quĩrĩãnaẽ́bʌrʌ, id̶i jarad̶adua sãʌ̃gʌda ẽpẽnida: dadji drõã naẽnabemaba Euprate do quĩrãrẽ ẽpẽ pananada wa naʌ̃ druad̶e amorreorãba ẽpẽ panʌda. Baribʌrʌ mʌ̃a, mʌ̃ quimaba, mʌ̃ warrarã bid̶a Ãcõrẽdrʌ ẽpẽnia.– ");
INSERT INTO empNTpo_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Josueba mãwã jarad̶acarea israelerãba nãwã panusid̶aa: –Dairã bid̶a Ãcõrẽdrʌ ẽpẽnia. Idjira ni maãrĩ bid̶a igarad̶aẽ́a dewara ãcõrẽ ẽpẽni carea. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Dadji Ãcõrẽbʌrʌ dadjirãra, dadji drõãrã sid̶a Egiptod̶e nezocarã pananada ẽdrʌ enesia. Idjiabʌrʌ dadjirã quĩrãpita ne ununaca dromada ocuasia. Dadjirã Egiptod̶eba zesid̶ad̶e idjiabʌrʌ od̶e, djãrã druaza bid̶a waga b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Idjiabʌrʌ jũmarãda dadjirã quĩrãpitabemada ãyã jʌretacuasia. Amorreorã naʌ̃ druad̶e panana sid̶a ãyã jʌretacuasia. Maʌ̃ bẽrã dairã bid̶a idjidrʌ ẽpẽnia. Idjidrʌ dai Ãcõrẽa.– ");
INSERT INTO empNTpo_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Maʌ̃ne Josueba nãwã jarasia: –Bãrãba Ãcõrẽra poya ẽpẽnaẽ́a. Dewarada idji quĩrãca neẽ́a. Idjia quĩrĩã b̶ʌa bãrãba ab̶abe idjidrʌ quĩrĩãnida. Maʌ̃ bẽrã idjia jara b̶ʌda ĩjã od̶aẽ́bʌrʌ idjab̶a cadjiruada od̶ibʌrʌ idjia maʌ̃ra quĩrãdoaẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","Bãrãba Ãcõrẽda igarad̶aped̶a dewara ãcõrẽ b̶eada ẽpẽnibʌrʌ, idjia bãrãra biẽ́ b̶ʌya. Mãwã bãrã careba b̶ad̶ada idjia quinibiya.– ");
INSERT INTO empNTpo_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Maʌ̃ne puruba jarasia: –Dairãba dewara ãcõrẽ b̶eara ẽpẽnaẽ́a; ab̶abe Ãcõrẽdrʌ ẽpẽnia.– ");
INSERT INTO empNTpo_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Josueba wayacusa jarasia: –Bãrãne b̶ʌa. Bãrãba wãrãneba jarabʌdaa Ãcõrẽdrʌ ẽpẽnida.– Ãdjirãba jarasid̶aa: –Mãẽ, mãwã wãrãneba jarabʌdaa.– ");
INSERT INTO empNTpo_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Maʌ̃ne Josueba jarasia: –Mãwã b̶aibʌrʌ bãrã jʌwaba od̶a ãcõrẽ b̶eara isabe b̶atacuad̶aped̶a sod̶eba dadji israelerã Ãcõrẽda ẽpẽnadua.– ");
INSERT INTO empNTpo_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Puruba panusia: –Dadji Ãcõrẽdrʌ ẽpẽnia; ab̶abe idjia jara b̶ʌdrʌ ĩjã od̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Maʌ̃ ewarid̶e Siqueʌ̃ purud̶e Josuera israelerã ume bed̶ea b̶ʌsid̶aa ab̶a Ãcõrẽdrʌ ẽpẽnida. Maʌ̃be idjia leyda b̶ʌsia ãdjirãba ĩjã od̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Maʌ̃gʌra Josueba Ãcõrẽ ley cartad̶e b̶ʌsia. Maʌ̃be mõgara waib̶ʌada ʌ̃ta nũmʌsia encina bacuru edre Ãcõrẽ wua de caita. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Maʌ̃ne jũma israelerãa nãwã jarasia: –Za b̶ʌ mõgarara b̶ʌbʌrʌa bãrãba Ãcõrẽ ẽpẽniana aped̶ad̶ara quĩrãnebad̶amãrẽã. Bãrãba Ãcõrẽda igarad̶ibʌrʌ naʌ̃ mõgaraba jũmarãa cawabiya bãrãba sewada osid̶ada.– ");
INSERT INTO empNTpo_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Mãwã jaraped̶a Josueba purura ãdjia edaped̶ad̶a ẽjũãza wãbisia. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Mãwãnacarea Nuʌ̃ warra Josue Ãcõrẽ nezocara 110 poa b̶asid̶e jaid̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Timnat-sera abadad̶e idjia edad̶a ẽjũãne israelerãba idjira tʌb̶arisid̶aa. Maʌ̃ ẽjũãra Epraiʌ̃ eyaid̶a b̶ʌ druad̶e b̶ʌa Gaa eya caita. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Josue zocai b̶asid̶e israelerãba Ãcõrẽra ẽpẽ panasid̶aa. Idji jaid̶ad̶acarea dji bororã idji ume panana zocai panasid̶ad̶e bid̶a ẽpẽ panasid̶aa. Maʌ̃ bororãba jũma unusid̶aa Ãcõrẽba israelerã itea od̶ada. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Israelerãba Jose querasi b̶ʌwʌrʌ Egiptod̶eba eneped̶ad̶ara Siqueʌ̃ne tʌb̶arisid̶aa. Dji ẽjũãra Jacoboba Hamo warrarãa cien parata torrobari nẽdosia. Hamora Siqueʌ̃ zeza basía. Maʌ̃ ẽjũãra Josed̶eba yõped̶ad̶arãba edasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Aaroʌ̃ warra Eleaza sid̶a jaid̶asia. Idjira Epraiʌ̃ eyaid̶a b̶ʌ druad̶e tʌb̶arisid̶aa idji warra Pinéba eya zaque edad̶ad̶e.");
INSERT INTO empNTpo_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","Ãcõrẽ nezoca bajãnebemada Gilgald̶eba Boquiʌ̃naa wãped̶a israelerãa nãwã jarasia: –Mʌ̃a bãrãra Egipto druad̶eba ẽdrʌ edaped̶a mʌ̃a diai jarad̶a ẽjũãnaa enesia. Mʌ̃a bãrã drõãenabemarãa nãwã jarasia: “Mʌ̃a bãrã ume bed̶ea b̶ʌd̶ara ãyã b̶ʌẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","Baribʌrʌ naʌ̃ druad̶e b̶earã ume bed̶ea b̶ʌrãnadua. Mõgara ãdji ãcõrẽ b̶ea itea ʌ̃tʌ pã bueped̶ad̶ada corapetacuad̶adua.” Mãwã jarad̶amĩna bãrãba ĩjãnaẽ́ basía. ¿Cãrẽ cãrẽã mãwã od̶aẽ́ basi? ");
INSERT INTO empNTpo_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","Bãrãba ĩjãnaẽ́ bẽrã mʌ̃a jaraya: puru naʌ̃ druad̶e b̶eara mʌ̃a waa bãrã quĩrãpitabemada ãyã jʌretaẽ́a. Ãtebʌrʌ soaba bãrã ẽcarrad̶e ubʌda quĩrãca ãdjirãneba bãrãra bia mĩga panania. Maʌ̃ awara bãrãba ãdji ãcõrẽ b̶ea ẽpẽnaped̶a bio biẽ́ panenia.– ");
INSERT INTO empNTpo_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","Ãcõrẽ nezoca bajãnebemaba mãwã jarasid̶e jũma israelerãra jĩgua jĩã duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","Maʌ̃ bẽrã mama trʌ̃ b̶ʌsid̶aa Boquiʌ̃. Idjab̶a mama animarãda Ãcõrẽa babue diasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","Josueba israelerã wãbisid̶e ãdjia edaped̶ad̶a ẽjũãza wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","Josue zocai b̶asid̶e israelerãba Ãcõrẽra ẽpẽ panasid̶aa. Idji jaid̶ad̶acarea dji bororã idji ume panana zocai panasid̶ad̶e bid̶a ãdjirãba ẽpẽ panasid̶aa. Maʌ̃ bororãba jũma unusid̶aa Ãcõrẽba israelerã itea od̶ada. ");
INSERT INTO empNTpo_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","Nuʌ̃ warra Josue Ãcõrẽ nezocara 110 poa b̶asid̶e jaid̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","Timnat-sera abadad̶e idjia edad̶a ẽjũãne israelerãba idjira tʌb̶arisid̶aa. Maʌ̃ ẽjũãra Epraiʌ̃ eyaid̶a b̶ʌ druad̶e b̶ʌa Gaa eya caita. ");
INSERT INTO empNTpo_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Josue ewarid̶ebemarã jũma jaid̶aped̶ad̶acarea ãdjid̶eba yõped̶ad̶arãba Ãcõrẽra, idjia israelerã itea o b̶ad̶a sid̶a quĩrãdoasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Mãwãnacarea israelerãba Ãcõrẽ quĩrãpita cadjiruada osid̶aa. Jʌwaba od̶a ãcõrẽ Baal abadada ẽpẽsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","Ãcõrẽba ãdji drõã naẽnabemarãra Egiptod̶eba ẽdrʌ edad̶amĩna idjira igarad̶aped̶a ãdji caita b̶earã ãcõrẽda ẽpẽsid̶aa. Mãwã Ãcõrẽra quĩrũbisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","Ãdjirãba Ãcõrẽra igarad̶aped̶a Baal abadada, Astarte abada sid̶a ẽpẽsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Maʌ̃ carea Ãcõrẽra israelerã ume bio quĩrũsia. Maʌ̃ba idjia ne drʌabadarãa ãdjia erob̶eara idu jãrĩbisia. Idjab̶a ãdji dji quĩrũa ãdjirãra idu poyabisia. Djõbʌdad̶e israelerãba waa poyad̶aẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Djõne wãbʌdaza Ãcõrẽra dji quĩrũare djõbadjia. Maʌ̃ bẽrã israelerãba poyad̶aca basía Ãcõrẽba naẽna jarad̶a quĩrãca. Mãwã bia mĩga duanabadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Mãwã bia mĩga panʌne Ãcõrẽba ʌ̃cʌrʌ ẽberãrãda b̶ʌbadjia israelerãra ne drʌabadarã jʌwaed̶abemada ẽdrʌ b̶ʌd̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Baribʌrʌ israelerãba maʌ̃ ẽdrʌ b̶ʌbadarã bed̶eara ĩjãnaca basía. Ãtebʌrʌ dãrãẽ́ne Ãcõrẽra wayacusa igarad̶aped̶a dewara ãcõrẽ b̶eada ẽpẽnaped̶a bia bed̶eabadjid̶aa. Ãcõrẽba obi jarad̶ara ãdji drõã naẽnabemaba ĩjã o pananamĩna ãdjirãba ĩjã od̶aẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Dji quĩrũba ãdjirã biẽ́ o panʌne bia mĩga panʌ bẽrã ãdub̶a mĩã sopua bed̶eabadjid̶aa. Ãcõrẽba maʌ̃ ũrĩbʌrʌza ãdjirãra quĩrã djuburiaped̶a ab̶a b̶ʌbadjia ãdjirã dji quĩrũ jʌwaed̶abemada ẽdrʌ b̶ʌmãrẽã. Ãcõrẽra maʌ̃ ẽberã ume b̶ʌ bẽrã idji zocai b̶ʌmisa israelerãra dji quĩrũ jʌwaed̶abemada ẽdrʌ b̶ʌbadjia. ");
INSERT INTO empNTpo_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Baribʌrʌ dji ẽdrʌ b̶ʌbari jaid̶ad̶acarea israelerãba wayacusa dewara ãcõrẽ b̶eada ẽpẽnaped̶a bia bed̶eabadjid̶aa. Maʌ̃ cadjirua obʌdaza ãdji djibarirãba oped̶ad̶a cãyãbara aud̶uara obadjid̶aa. Cʌwʌrʌ zaread̶eba ãdjia cadjirua obadara igarad̶aca basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","Maʌ̃ carea Ãcõrẽra israelerã ume bio quĩrũped̶a nãwã jarasia: –Mʌ̃a israelerã drõã naẽnabemarã ume bed̶ea b̶ʌd̶ara naʌ̃ ẽberãrãba igarasid̶aa. Mʌ̃a jarad̶ara ĩjãnacaa. ");
INSERT INTO empNTpo_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","Maʌ̃ bẽrã puru b̶ea Josueba poyad̶aẽ́ra mʌ̃a israelerã quĩrãpitabemada ni ab̶a bid̶a ãyã jʌretaẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","Ãcõrẽba maʌ̃ puru b̶eara Canaaʌ̃ druad̶e idu b̶ebisia israelerãba idjida ẽpẽni cawaya ãdji drõã naẽnabemaba ẽpẽped̶ad̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","Josue ewarid̶e Ãcõrẽba maʌ̃ puru b̶eara ãyã jʌretaẽ́ basía. Idjia Josuéa poyabiẽ́ basía, ãtebʌrʌ Canaaʌ̃ druad̶e idu b̶ebisia. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","Ehud jaid̶ad̶acarea israelerãba wayacusa Ãcõrẽ quĩrãpita cadjiruada o panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","Maʌ̃ carea Ãcõrẽba ãdjirãra cananeorã boro Jabiʌ̃ jʌwaed̶a b̶ʌsia. Jabiʌ̃ra Hazor purud̶e b̶abadjia. Jabiʌ̃ sordaorã borora Sisará basía. Maʌ̃ Sisarára Haroset-goiʌ̃ne b̶abadjia. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","Jabiʌ̃ba djõbada carreta jiorro od̶ada noveciento erob̶asia. Veinte poa israelerãra quĩrã djuburia neẽ́ bio bia mĩga erob̶asia. Maʌ̃ne israelerãba Ãcõrẽa quĩrã djuburiada iwid̶isid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","Maʌ̃ ewarid̶e Deboráda israelerã cawa obari basía. Idjira Ãcõrẽneba bed̶eabadjia. Lapidot quima basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","Maʌ̃ Deborára Epraiʌ̃ eyaid̶a b̶ʌ druad̶e b̶abadjia Ramá puru idjab̶a Betel puru ẽsi. Israelerã nẽbʌrad̶e panʌne idjimaa wãbadjid̶aa cawa omãrẽã. Cawa obʌrʌd̶e Deborára urutaca b̶ʌ edre chũmabadjia. Maʌ̃ bẽrã maʌ̃ bacurura Deborá Uruta trʌ̃ b̶ʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","Ewari ab̶a Deborába Abinoaʌ̃ warra Baracoda trʌ̃bisia. Idjira Neptali druad̶e Quedé purud̶e b̶abadjia. Baraco zed̶acarea Deborába nãwã jarasia: –Dadji israelerã Ãcõrẽba bʌ́a nãwã jara b̶ʌa: “Sordaorã Neptalid̶ebemada Zabuloʌ̃nebema sid̶a die mil ededua Tabor eyad̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","Mʌ̃a Jabiʌ̃ sordaorã boro Sisaráda bʌ ume djõne wãbiya. Dji carretad̶eba djõbadarãda, waabema sordaorã sid̶a eneya Quisoʌ̃ do zaqued̶aa. Baribʌrʌ mʌ̃a bʌ́a ãdjirãra poyabiya.”– ");
INSERT INTO empNTpo_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","Maʌ̃ne Baracoba Deboráa jarasia: –Bʌda mʌ̃ ume wãibʌrʌ mʌ̃ra wãya. Bʌda wãẽ́bʌrʌ mʌ̃ sid̶a wãẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","Deborába jarasia: –Bia b̶ʌa, mãẽteara mʌ̃ra bʌ ume wãya. Baribʌrʌ Sisará poyad̶acarea bʌra trʌ̃ b̶ʌgaẽ́a, Ãcõrẽba Sisarára wẽrãa poyabi bẽrã.– Ara maʌ̃da Deborára Baraco ume Quedes purud̶aa wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","Mama Baracoba sordaorã Zabuloʌ̃nebemada, Neptalid̶ebema sid̶a die mil ãbaa jʌreped̶a Tabor eyad̶aa edesia. Deborá sid̶a idji ume wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","Maʌ̃ ewarid̶e quenita Hebere abadada Quedes puru caita b̶abadjia. Naẽna idjira waabema quenitarã ume b̶ad̶ada Zaanaim jewed̶ad̶e idji wua dera o erob̶asia. Maʌ̃ Heberera Moise zãwãrẽ Hobád̶eba yõna basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","Maʌ̃ne Sisarába ũrĩsia Abinoaʌ̃ warra Baracora idji sordaorã ume Tabor eyad̶aa wãsid̶ada. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","Maʌ̃ carea idji jiorro od̶a djõbada carreta noveciento panʌda, idji sordaorã sid̶a ãbaa jʌreped̶a Haroset-goiʌ̃neba Quisoʌ̃ do zaqued̶aa wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","Maʌ̃be Deborába Baracoa jarasia: –¡Ãdjirã ume isabe djõne wãnadua! ¡Id̶ibʌrʌ Ãcõrẽba bʌ́a Sisarára poyabiya! ¡Ãcõrẽra bʌ na wãbʌrʌa!– Ara maʌ̃da Baracora idji sordaorã die mil panʌ ume Tabor eyad̶eba ed̶aa djõne wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","Djõne wãbʌdad̶e Ãcõrẽba Sisarára, carretad̶eba djõbadarãra, waabema sordaorã sid̶a bio ne wayabisia. Maʌ̃ bẽrã Baracoba idji sordaorã ume necoba zocãrã quenasid̶aa. Baribʌrʌ Sisarára idji carretad̶eba ud̶u jʌ̃drʌped̶a mĩrũ pira wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","Maʌ̃ne Baracoba Sisará carretad̶eba djõbadarãra, waabema sordaorã sid̶a ẽpẽsid̶aa ab̶a Haroset-goiʌ̃naa. Mãwã Sisará sordaorãra jũma quenasid̶aa. Ni ab̶a bid̶a zocai b̶eẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","18","Maʌ̃ ewarid̶e Hazord̶ebema boro Jabiʌ̃ra quenita Hebere ẽberãrã ume necai b̶asia. Maʌ̃ carea Sisarára ãdjimaa mĩrũ wãsia. Jũẽsid̶e wẽrã Jael abadaba idjira audiab̶arid̶e wãsia. Maʌ̃ wẽrãra Hebere quima basía. Jaelba nãwã jarasia: –Mʌ̃ boro, diguid̶aa zedua. Ne wayarãdua.– Ara maʌ̃da Sisarára Jael wua ded̶e ed̶aa wãped̶a tab̶esia. Maʌ̃ne Jaelba idjira borob̶aba ãnẽb̶ari b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","Sisarába jarasia: –Mʌ̃ quĩrã djuburia baidoda diadua. Mʌ̃ra opichia b̶ʌa.– Jaelba paca jub̶ada animarã e od̶ad̶e tʌ erob̶asia. Maʌ̃ra ewaped̶a paca jub̶ara diasia. Maʌ̃be Sisarára wayacusa ãnẽb̶ari b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","Sisarába jarasia: –Wua ded̶e ed̶a wãbadama chũmedua. Bariduada zeped̶a nãwã iwid̶ibʌrʌ: “¿caida nama b̶ʌ?”, jaradua ẽberã neẽ́da.– ");
INSERT INTO empNTpo_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","Sisarára sẽ b̶ʌ bẽrã bio cãĩ b̶esia. Maʌ̃be Hebere quima Jaelba wua de egorod̶aa cachibada bacuru cũmiada, dji cachibada sid̶a edasia. Jaelera chupea ed̶a wãped̶a maʌ̃ bacuruba Sisará borora egorod̶aa wãyã cachi nũmʌsia. Mãwã Sisarára beasia. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","Baracoba Sisará jʌrʌ b̶ʌd̶e Jael purud̶e jũẽsia. Maʌ̃ne Jaelba idji audiab̶arid̶e wãped̶a nãwã jarasia: –Zedua, bʌa jʌrʌ b̶ʌra mʌ̃a acʌbiya.– Ara maʌ̃da Baracora Jael wua ded̶e ed̶a wãped̶a Sisarára beu tab̶ʌda unusia. Jaelba cachid̶a bacurura wad̶i Sisará borod̶e su nũmasia. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","Maʌ̃ ewarid̶e Ãcõrẽba israelerã quĩrãpita cananeorã boro Jabiʌ̃ra mãwã poyasia. ");
INSERT INTO empNTpo_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","Mamaʌba ʌ̃taa israelerãra cananeorã boro Jabiʌ̃ ume djõbʌdaza poyabadjid̶aa ab̶a idji beabʌdad̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","Mãwãnacarea israelerãba wayacusa Ãcõrẽ quĩrãpita cadjiruada o panesid̶aa. Maʌ̃ carea Ãcõrẽba ãdjirãra siete poa madianitarã jʌwaed̶a b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","Madianitarãba ãdjirãra bio bia mĩga eropanʌ bẽrã eyad̶aa wãnaped̶a uria b̶ead̶e, jogoa b̶ead̶e, ʌ̃tʌ dji quĩrũ poya wãcara b̶ʌmaa bid̶a mĩrũ panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","Israelerãba u eropanʌra madianitarãba, amalecitarãba, idjab̶a ʌ̃mãdau odjabariarebemarã bid̶a jãrĩcuad̶e zebadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","Ãdjirã israelerã ẽjũãne panʌne israelerãba u eropanʌra jũma ãrĩbadjid̶aa ab̶a Gaza ẽjũãnaa. Maʌ̃ bẽrã israelerãba cod̶i carea ni cãrẽ sid̶a neẽ́ panasid̶aa. Ovejada, pacada, burro sid̶a neẽ́ panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","Madianitarãra, waabemarã sid̶a ãdji wua de bara idjab̶a ãdji animarã bara israelerã druad̶aa zed̶aped̶a ne jũma ãrĩ wãbadjid̶aa ad̶ichichi zocãrãba néu jũma cobada quĩrãca. Ãdjirãra ãdji cameyo sid̶a zocãrã panʌ bẽrã poya juachad̶aca basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","Madianitarãba ne jũma jãrĩcuabadjid̶a bẽrã israelerãra ne neẽ́ panasid̶aa. Maʌ̃ carea israelerãba Ãcõrẽa quĩrã djuburiada iwid̶isid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","8","Mãwã quĩrã djuburiada iwid̶i panʌ bẽrã Ãcõrẽba idjid̶eba bed̶eabarida ab̶a ãdjirãmaa diabuesia. Maʌ̃ ẽberãba ãdjirãa nãwã jarasia: –Dadji israelerã Ãcõrẽba nãwã jara b̶ʌa: “Mʌ̃a bãrãra Egiptod̶e nezoca pananada ẽdrʌ enesia. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","Egiptorã jʌwaed̶abemada, jũma bãrã biẽ́ o erob̶ea jʌwaed̶abema sid̶a mʌ̃a bãrãra ẽdrʌ b̶ʌsia. Mʌ̃a ãdjirãra bãrã quĩrãpitabemada jũma ãyã jʌretaped̶a ãdjirã druara bãrãa diasia. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","Id̶ira bãrãra amorreorã drua bad̶ad̶e panabadaa, baribʌrʌ mʌ̃a bãrãa jarasia ãdjirã ãcõrẽ b̶eada ẽpẽrãnamãrẽã. Ab̶abe mʌ̃, bãrã Ãcõrẽdrʌ ẽpẽnida panʌana asia. Baribʌrʌ mʌ̃a jarad̶ara ĩjãnacaa.”– ");
INSERT INTO empNTpo_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","Maʌ̃ ewarid̶e Ãcõrẽ nezoca bajãnebemada zeped̶a Opra puru caita encina bacuru edre chũmesia. Maʌ̃ bacuru djibarira Abiezed̶eba yõna Joasa basía. Mama caita Joasa warra Gedeoʌ̃ba trigoda uva biwadʌgabada uriad̶e mẽrã ezoa b̶asia madianitarãba unurãnamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","Ãcõrẽ nezoca bajãnebemara Gedeoʌ̃ma odjasid̶e nãwã jarasia: –Ẽberã mẽsrã b̶ʌ idjab̶a sozarra b̶ʌ, Ãcõrẽra bʌ ume b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","Maʌ̃ne Gedeoʌ̃ba nãwã jarasia: –Mʌ̃ boro, Ãcõrẽda wãrãda dadjirã ume b̶ʌbʌrʌ, ¿sãwã jãcua mĩga panʌ? Ãcõrẽba dadjirãra madianitarã jʌwaed̶a b̶ʌsia. Dadji drõãrãba nẽbʌrʌsid̶aa Ãcõrẽba ne ununaca o b̶ʌd̶eba dadjirãra Egiptod̶e nezoca pananada ẽdrʌ edasida. Maʌ̃da ¿sãʌ̃be waya ne ununacara dadjirã itea oi?– ");
INSERT INTO empNTpo_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","Maʌ̃ne Ãcõrẽba Gedeoʌ̃ acʌped̶a nãwã jarasia: –Bʌ ʌb̶ʌad̶eba israelerãra madianitarã jʌwaed̶abemada ẽdrʌ b̶ʌdua. ¿Mʌ̃abʌrʌ bʌra wãbi b̶ʌẽ́ca?– ");
INSERT INTO empNTpo_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","Baribʌrʌ Gedeoʌ̃ba panusia: –Mʌ̃ boro, ¿mʌ̃a sãwã dadji israelerãra ẽdrʌ b̶ʌi? Mʌ̃ ẽberãrãra jũma Manased̶ebema dji ne neẽ́ara qued̶eaa. Maʌ̃ awara mʌ̃ra mʌ̃ ẽberãrãnebema dji ed̶aara quirua.– ");
INSERT INTO empNTpo_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","Ãcõrẽba jarasia: –Mʌ̃ra bʌ ume b̶ai bẽrã bʌa madianitarãra poyaya ẽberã ab̶a poyabʌrʌ quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","Maʌ̃ne Gedeoʌ̃ba jarasia: –Bʌa wãrãda mʌ̃da bia unu b̶ʌbʌrʌ, cawabidua bʌdrʌ wãrãda mʌ̃ ume bed̶ea b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","Mʌ̃a bʌ itea ne eneped̶a bʌ quĩrãpita b̶ʌya. Mʌ̃ quĩrã djuburia ãyã wãrãdua maʌ̃ enebʌrʌmisa.– Ãcõrẽba panusia: –Mʌ̃a jʌ̃ãya ab̶a bʌ zebʌrʌd̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","Ara maʌ̃da Gedeoʌ̃ra wãped̶a chiwatu zaqueda beaped̶a djusia. Idjab̶a harinada veintidos libra edaped̶a paʌ̃ dji ẽsãbari neẽ́ b̶ʌda ocuasia. Jũma wid̶acarea nedjarara jamarad̶e b̶ʌped̶a dji b̶ara cugurud̶e jue edaped̶a encina bacurud̶aa jũma edesia. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","Maʌ̃ne Ãcõrẽ nezoca bajãnebemaba Gedeoʌ̃a jarasia nedjarara, paʌ̃ sid̶a mõgara ʌ̃rʌ̃ cob̶ʌped̶a dji b̶ara jũma ʌ̃rʌ̃ weamãrẽã. Ara maʌ̃da Gedeoʌ̃ba mãwã osia. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","Maʌ̃be Ãcõrẽ nezoca bajãnebemaba nedjarara, paʌ̃ dji ẽsãbari neẽ́ b̶ʌ sid̶a bacuru quẽbʌba warasia. Ara maʌ̃ne mõgarad̶eba tʌbʌda eradrʌped̶a nedjarara, paʌ̃ sid̶a jũma bá wãsia. Mãwãbʌrʌd̶e Ãcõrẽ nezoca bajãnebema sid̶a nẽbasia. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","Maʌ̃ne Gedeoʌ̃ba cawasia idjia Ãcõrẽ nezoca bajãnebemada unusida. Maʌ̃ carea jarasia: –¡Ay, mʌ̃ Boro Ãcõrẽ! Id̶ibʌrʌ mʌ̃ra beuya bʌ nezoca bajãnebema quĩrãda ununa bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","Baribʌrʌ Ãcõrẽba jarasia: –Bʌra beuẽ́a. Ne wayarãdua. Necai b̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","Mama Gedeoʌ̃ba mõgarada ʌ̃tʌ pã buesia Ãcõrẽda idji ume bed̶ead̶a bẽrã. Maʌ̃ mõgara ʌ̃tʌ pã bued̶ara trʌ̃ b̶ʌsia “Ãcõrẽba necai b̶ai diabari.” Maʌ̃ mõgara ʌ̃tʌ pã bued̶ara wad̶ibid̶a Opra purud̶e b̶ʌa Abiezed̶eba yõped̶ad̶arã ẽjũãne. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","Ara maʌ̃ diamasi Ãcõrẽba Gedeoʌ̃a nãwã jarasia: –Bʌ zeza paca dji umébemada siete poa b̶ʌda edadua. Maʌ̃ba bʌ zezaba mõgara Baal quĩrãca od̶a ʌ̃ta nũmʌcãrĩda erreb̶ari coratadua. Maʌ̃ orrocawa b̶ʌ bacuru Aserá quĩrãca od̶a nũmʌcãrĩ sid̶a coratadua. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","Maʌ̃be naʌ̃ eya borod̶e mõgarada ʌ̃tʌ pã buedua animarã mʌ̃́a babue diai carea. Maʌ̃ mõgara pã bued̶a ʌ̃rʌ̃ bacuru Aserá quĩrãca od̶ara cajẽrãped̶a bʌ zeza paca dji umébemara beaped̶a mʌ̃́a babue diadua.– ");
INSERT INTO empNTpo_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","Ara maʌ̃da Gedeoʌ̃ba idji nezocarãda die trʌ̃ped̶a Ãcõrẽba jarad̶a quĩrãca diamasi osia. Ãsa oẽ́ basía idji zeza ẽberãrãda, purud̶ebemarã sid̶a waya b̶ad̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","Nurẽma purud̶ebemarã piradrʌbʌdad̶e unusid̶aa mõgara Baal quĩrãca od̶ara tab̶ʌda idjab̶a bacuru Aserá quĩrãca od̶a mama b̶ad̶a sid̶a neẽ́da. Maʌ̃ awara unusid̶aa ab̶aʌba Gedeoʌ̃ zeza paca dji umébemara mõgara ʌ̃tʌ pã bued̶a ʌ̃rʌ̃ babuesida. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","Maʌ̃ne ãdjiza dji iwid̶i duanesid̶aa: –¿Caiba jãwã osi?– Jũmarãa iwid̶id̶aped̶a cawasid̶aa Gedeoʌ̃ba mãwã osida. Maʌ̃ carea Gedeoʌ̃ zeza Joasamaa wãnaped̶a jarasid̶aa: ");
INSERT INTO empNTpo_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","–Bʌ warrara dajadaa zebidua. Mõgara Baal quĩrãca od̶ara idjab̶a bacuru Aserá quĩrãca od̶a mama b̶ad̶a sid̶a coracuasia. Maʌ̃ carea dairãba idjira bead̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","Maʌ̃ne Joasaba idji ume quĩrũ panʌ́a nãwã jarasia: –¿Mãwãra bãrãba Baalda carebad̶ica? ¿Idjiare djõnica? Mʌ̃a jaraya bariduaba Baalera carebaibʌrʌ ʌ̃nadrʌi naẽna beuida b̶ʌa. Baalda wãrãda ãcõrẽbʌrʌ, idjidrʌ idji mõgara coratad̶a ume djõida b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","Gedeoʌ̃ba mõgara Baal quĩrãca od̶ara coratad̶a bẽrã maʌ̃ ewarid̶eba ʌ̃taa idjira trʌ̃ jarasid̶aa Jerobaal. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","Maʌ̃ ewarid̶e madianitarãda, amalecitarãda, ʌ̃mãdau odjabariarebemarã sid̶a jũma ãbaa dji jʌred̶aped̶a Jordaʌ̃ do chãnaped̶a Jezreel jewed̶ad̶e duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","Maʌ̃ne Ãcõrẽ Jaurera Gedeoʌ̃maa zesia. Maʌ̃ bẽrã Gedeoʌ̃ba oveja cachuda jĩgua zásia Abiezed̶eba yõna purura ãbaa jʌrei carea. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","Maʌ̃be idjia bed̶eada diabuesia Manased̶eba, Aserd̶eba, Zabuloʌ̃neba, idjab̶a Neptalid̶eba yõped̶ad̶arã zed̶amãrẽã. Jũmarã zed̶aped̶a Gedeoʌ̃ careba djõni carea panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","Maʌ̃ne Gedeoʌ̃ba Ãcõrẽa nãwã jarasia: –Bʌa jarasia mʌ̃neba dai israelerãra ẽdrʌ b̶ʌida. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","Mʌ̃a cawa quĩrĩã b̶ʌa bʌa jarad̶ara wãrãda. Daiba trigo cʌradʌgabadama mʌ̃a oveja cara mõda b̶ʌda egode b̶ʌya. Nurẽma maʌ̃ oveja carada b̶eguea b̶aibʌrʌ maʌ̃ne egorora põãsa b̶aibʌrʌ, mʌ̃a cawaya wãrãda mʌ̃neba dai israelerãra ẽdrʌ b̶ʌida, bʌa jarad̶a quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","Gedeoʌ̃ba jarad̶a quĩrãca mãwãsia. Nurẽma piradrʌped̶a oveja carara tapuyabʌrʌd̶e baidoda taza ab̶a piasia. ");
INSERT INTO empNTpo_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","Baribʌrʌ Gedeoʌ̃ba Ãcõrẽa jarasia: –Mʌ̃a jãwã mĩã sẽ b̶ʌmĩna mʌ̃ djuburia quĩrũrãdua. Waya cawabidua bʌa jarad̶ara wãrãda. Naʌ̃ diamasi ẽjũãra b̶egueabidua baribʌrʌ oveja carara põãsa b̶ʌdua.– ");
INSERT INTO empNTpo_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","Maʌ̃ diamasi Ãcõrẽba mãwã osia. Nurẽma ẽjũãra jũma b̶eguea b̶asia, maʌ̃ne oveja carara põãsa b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","Nurẽma diaped̶ed̶a Gedeoʌ̃, Jerobaal abadara idji ume panʌ sid̶a pirab̶arid̶aped̶a Harod baido ʌ̃ta bogadrʌ b̶ʌmaa wãsid̶aa. Mama madianitarã ume djõni carea panesid̶aa. Madianitarãra ãdjirã quĩrãpe duanasid̶aa Jezreel jewed̶ad̶e Moré eya caita. ");
INSERT INTO empNTpo_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","Maʌ̃be Ãcõrẽba Gedeoʌ̃a jarasia: –Bʌa sordaorãra jũmawãyã erob̶ʌa. Mʌ̃a bãrã israelerã zocãrã panʌ́a madianitarãda idu poyabibʌrʌ, bãrãba jarad̶ia ara bãdji ʌb̶ʌad̶eba poyasid̶ada. ");
INSERT INTO empNTpo_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","Maʌ̃ carea bʌ sordaorãa jaradua ab̶aʌda ne waya b̶ʌbʌrʌ, naʌ̃ Gala eyad̶eba diguid̶aa wãida b̶ʌda.– Gedeoʌ̃ba mãwã jarabʌrʌd̶e veintidos mil jẽda wãsid̶aa. Maʌ̃ne die mil panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","Maʌ̃be Ãcõrẽba jarasia: –Wad̶ibid̶a jũmawãyã zocãrã panʌa. Do zaqued̶aa baido dod̶amãrẽã ededua. Mama mʌ̃a cawabiya cairãda djõne wãnida panʌda. Mʌ̃a naʌ̃ ẽberãda bʌ ume wãyana aibʌrʌ, idjira wãida b̶ʌa. Wãẽ́ana aibʌrʌ wãiẽ́ b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","Ara maʌ̃da Gedeoʌ̃ba idji sordaorãra edesia baido dod̶amãrẽã. Mãwã panʌne Ãcõrẽba Gedeoʌ̃a nãwã jarasia: –Ʌ̃cʌrʌba baidora ãdji jʌwa jãne jue edad̶aped̶a usa quĩrãca sene do panʌa. Waabemaba chĩrãborod̶e copanenaped̶a baidora do panʌa. Ãdji jʌwa jãneba do nũpanʌra awara b̶ʌdua.– ");
INSERT INTO empNTpo_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","Dji jʌwa jãneba do nũpanʌra tresciento panasid̶aa. Waabemaba chĩrãborod̶eba baidora do panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","Maʌ̃be Ãcõrẽba Gedeoʌ̃a jarasia: –Maʌ̃ tresciento panʌba mʌ̃a bʌ́a madianitarãra poyabiya. Mãwã mʌ̃a bãrã israelerãra ẽdrʌ b̶ʌya. Waabema sordaorãa jaradua ãdji diguid̶aa wãnamãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","Ara maʌ̃da Gedeoʌ̃ba ãdjirãa jarasia diguid̶aa wãnamãrẽã baribʌrʌ ãdjia cod̶i careabemada, oveja cachu sid̶a amebisia. Ãdjirã wãped̶ad̶acarea Gedeoʌ̃ sordaorãra trescientobe panesid̶aa. Maʌ̃ne madianitarãra ed̶aa Jezreel jewed̶ad̶e duanasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","Diamasi Ãcõrẽba Gedeoʌ̃a nãwã jarasia: –Pirab̶arid̶aped̶a madianitarã ume djõne wãnadua. Mʌ̃a bʌ́a ãdjirãra poyabiya. ");
INSERT INTO empNTpo_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","Baribʌrʌ bʌa ãdjirã ume djõne wãi carea waya b̶ʌbʌrʌ, naãrã ãdjirã duanʌmaa bʌ nezoca Purá ume ed̶aa wãdua. ");
INSERT INTO empNTpo_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","Maʌ̃be ãdjirãba jara panʌda ũrĩdua. Maʌ̃ba bʌra sozarraara b̶eya ãdjirã ume djõi carea.– Ara maʌ̃da Gedeoʌ̃ra idji nezoca Purá ume ed̶aa wãsia madianitarã panʌ caita. ");
INSERT INTO empNTpo_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","Maʌ̃ne Jezreel jewed̶ara bira nũmasia madianitarãba, amalecitarãba, ʌ̃mãdau odjabariarebemarã bid̶a. Ãdjirãra cãbana panasid̶aa ad̶ichichi néu cod̶e zebada quĩrãca. Ãdji cameyora poya juachad̶aca basía ĩbʌ pusa icawa b̶ʌ quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","Gedeoʌ̃ madianitarã duanʌma jũẽsid̶e ũrĩsia ẽberãda umé bed̶ea panʌda. Ab̶aʌba nẽbʌrʌ b̶asia idjia cãĩmocarad̶e ununada. Nãwã jarasia: –Mʌ̃ cãĩmocarad̶e unusia cebada paʌ̃ borococoa od̶ada nama dadjirã duanʌmaa bʌrab̶ari zebʌrʌda. Maʌ̃ba wua ded̶aa tab̶arid̶e zebʌrʌba coratasia.– ");
INSERT INTO empNTpo_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","Maʌ̃ne dewarabemaba jarasia: –Maʌ̃gʌba jara b̶ʌa jãʌ̃ Israeld̶ebema Joasa warra Gedeoʌ̃da idji neco bara djõne zebʌrʌda. Wãrãda Ãcõrẽba idjía dadji madianitarãra dadjirãare panʌ sid̶a jũma poyabiya.– ");
INSERT INTO empNTpo_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","Gedeoʌ̃ba maʌ̃ cãĩmocarara, dji cawa jarad̶a sid̶a ũrĩped̶a Ãcõrẽa bia bed̶easia. Maʌ̃be israelerã sordaorã panʌmaa jẽda wãped̶a jarasia: –Ãcõrẽba dadjirãa jãʌ̃ madianitarãra poyabiya. ¡Ara nawena pirab̶arid̶adua djõne wãni carea!– ");
INSERT INTO empNTpo_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","Maʌ̃be Gedeoʌ̃ba idji sordaorã tresciento panʌda awara awara b̶ʌsia. Idjia cien edasia, dewara boro umé panʌ́a ãdjiza cien diasia. Maʌ̃be oveja cachuda, zoco sid̶a jũmarãa jed̶ecasia. Cãdorrona ĩbĩrãda maʌ̃ zocod̶e ed̶a b̶ʌbicuasia ebud̶a ʌ̃narãmãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","18","Maʌ̃be ãdjirãa jarasia: –Naãrã dadjirãba madianitarãra jũrã edad̶ia. Mʌ̃da acʌd̶adua. Mʌ̃da ãdjirã duanʌ wagabe jũẽsira mʌ̃a obʌrʌ quĩrãca od̶adua. Mʌ̃a, mʌ̃ ume wãbʌda bid̶a cachura jĩgua zabʌdad̶e bãrã bid̶a zad̶adua. Maʌ̃be nãwã b̶iad̶adua: “¡Ãcõrẽ trʌ̃neba, Gedeoʌ̃ trʌ̃ne bid̶a djõbʌdaa!”– ");
INSERT INTO empNTpo_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","Maʌ̃be Gedeoʌ̃ra idji sordaorã cien panʌ ume madianitarã panʌ wagaa jũẽsid̶aa. Dãrãẽ́ b̶asia madianitarãba ãdji ariquẽtra wagabadarãda b̶ʌcuaped̶ad̶ada. Maʌ̃ne Gedeoʌ̃ba idji ume panʌ bid̶a cachura jĩgua zasid̶aa. Zoco ãdji jʌwad̶e eropanʌ sid̶a ab̶ed̶a bogatasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","Ara maʌ̃ne dji bororã umé panʌba ãdji sordaorã bid̶a cachura zasid̶aa. Ãdji zoco sid̶a bogatasid̶aa. Maʌ̃be dji ĩbĩrãda ãdji jʌwa acʌare edasid̶aa. Cachura ãdji jʌwa araare eropanasid̶aa. Maʌ̃ne nãwã b̶iasid̶aa: –¡Ãcõrẽ trʌ̃neba, Gedeoʌ̃ trʌ̃ne bid̶a djõbʌdaa!– ");
INSERT INTO empNTpo_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","22","Maʌ̃ne israelerã tresciento panʌba cachura ãdji duanʌma zá panesid̶aa. Ãdjirãba madianitarãra jũrã eropanana bẽrã madianitarãra b̶iad̶aped̶a mĩrũ piraposid̶aa. Maʌ̃ne Ãcõrẽba madianitarãra ara ãdjidub̶a necoba djõbigasia. Mãwã panʌne madianitarãra Zererad̶aa wãbada od̶e Bet-sita purud̶aa mĩrũ wãsid̶aa. Idjab̶a Abel-mehola purud̶aa Tabat caita mĩrũ wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","Maʌ̃ne Gedeoʌ̃ba israelerã Neptalid̶ebemada, Aserd̶ebemada, jũma Manased̶ebema sid̶a trʌ̃bigasia madianitarã ẽpẽnamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","Gedeoʌ̃ba bed̶eada Epraiʌ̃ eyaid̶a b̶ʌ ẽjũãnaa diabuesia Epraiʌ̃nebemarã djõne zed̶aped̶a madianitarã Jordaʌ̃ dod̶e idu chãbirãnamãrẽã. Ara maʌ̃da Epraiʌ̃nebemarãra ed̶a zed̶aped̶a Bet-barad̶e, Jordaʌ̃ jewed̶ad̶e bid̶a do chãbadama jʌ̃ãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","Mãwã panʌne madianita bororãda umé jidasid̶aa, Oreb idjab̶a Zeeb. Oreb abadara beasid̶aa eya ʌra jira b̶ʌma. Mama trʌ̃ b̶ʌsid̶aa “Oreb eya ʌra jira b̶ʌ.” Zeeb abadara beasid̶aa uva biwadʌgabada uriad̶e. Mama trʌ̃ b̶ʌsid̶aa “Zeeb uva biwadʌgabada.” Israelerãba waabema madianitarã ẽpẽped̶ad̶acarea ãdjia Oreb borora, Zeeb boro sid̶a b̶ʌá tud̶aped̶a Jordaʌ̃ do quĩrãrẽ Gedeoʌ̃maa edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG10_1","008_10_1","JDG","10","1","1","Abimele jaid̶ad̶acarea Puvá warra Tola abadaba israelerãra dji quĩrũ jʌwaed̶abemada ẽdrʌ b̶ʌbadjia. Idjira Dodo wiuzaque basía. Isacard̶eba yõna basía. Epraiʌ̃ eyaid̶a b̶ʌ ẽjũãne Samir purud̶e b̶abadjia. ");
INSERT INTO empNTpo_vpl VALUES ("JG10_2","008_10_2","JDG","10","2","2","Tolaba israelerãra 23 poa ẽdrʌ b̶ʌbadjia. Jaid̶asid̶e Samir purud̶e tʌb̶arisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG10_3","008_10_3","JDG","10","3","3","Tola jaid̶ad̶acarea Jaír Gala druad̶ebemada 22 poa israelerã ẽdrʌ b̶ʌbari basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG10_4","008_10_4","JDG","10","4","4","Idjia warrarãda treinta erob̶asia. Maʌ̃gʌrãra treinta burro ʌ̃rʌ̃ nĩbabadjid̶aa. Gala druad̶e treinta puru ãdjirã jʌwaed̶a eropanasid̶aa. Maʌ̃ puru b̶eara wad̶ibid̶a Jaír puru abadaa. ");
INSERT INTO empNTpo_vpl VALUES ("JG10_5","008_10_5","JDG","10","5","5","Jaír jaid̶asid̶e Camoʌ̃ purud̶e tʌb̶arisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG10_6","008_10_6","JDG","10","6","6","Maʌ̃ ewarid̶e israelerãba wayacusa Ãcõrẽ quĩrãpita cadjiruada o panesid̶aa. Baal abadada, Astarte abada sid̶a ẽpẽsid̶aa. Idjab̶a Siriad̶ebemarã, Sidoʌ̃nebemarã, moabitarã, amonitarã idjab̶a pilisteorã ãcõrẽ b̶eada ẽpẽsid̶aa. Ãcõrẽra ab̶ed̶a igarasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG10_7","008_10_7","JDG","10","7","7","Maʌ̃ carea Ãcõrẽra bio quĩrũped̶a israelerãra pilisteorã idjab̶a amonitarã jʌwaed̶a b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("JG10_8","008_10_8","JDG","10","8","8","Maʌ̃ ewarid̶e pilisteorãba, amonitarã bid̶a israelerã Gala ẽjũãne b̶eada poyad̶aped̶a dieciocho poa biẽ́ o panasid̶aa. Gala ẽjũãra amorreorã ẽjũã bad̶a basía. Jordaʌ̃ dod̶eba ʌ̃mãdau odjabariare b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JG10_9","008_10_9","JDG","10","9","9","Maʌ̃be amonitarãra Jordaʌ̃ do chãsid̶aa Judad̶ebemarã ume, Benjamiʌ̃nebemarã ume, idjab̶a Epraiʌ̃nebemarã ume djõni carea. Mãwã jũma israelerãra bio bia mĩga duanabadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG10_10","008_10_10","JDG","10","10","10","Mãwã panʌne israelerãba Ãcõrẽa quĩrã djuburiada nãwã iwid̶isid̶aa: –Dai Ãcõrẽ, bʌ quĩrãpita dairãba cadjirua waib̶ʌada osid̶aa. Bʌra igarad̶aped̶a Baalda ẽpẽsid̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("JG10_11","008_10_11","JDG","10","11","12","Ãcõrẽba panusia: –Egiptorãba, amorreorãba, amonitarãba, pilisteorãba, Sidoʌ̃nebemarãba, amalecitarãba, madianitarã bid̶a bãrã biẽ́ obʌdaza bãrãba quĩrã djuburia iwid̶ibʌdad̶e mʌ̃a bãrãra ẽdrʌ b̶ʌbadjia. ");
INSERT INTO empNTpo_vpl VALUES ("JG10_13","008_10_13","JDG","10","13","13","Mãwã od̶amĩna bãrãba mʌ̃ra igarad̶aped̶a dewara ãcõrẽ b̶eada ẽpẽsid̶aa. Maʌ̃ bẽrã mʌ̃a bãrãra waa ẽdrʌ b̶ʌẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("JG10_14","008_10_14","JDG","10","14","14","¡Bãdjia ẽpẽbada ãcõrẽ b̶eaa quĩrã djuburiada iwid̶id̶e wãnadua! ¡Ãdjirãbʌrʌ bãrã bia mĩga panʌnebemada ẽdrʌ b̶ʌd̶isicada!– ");
INSERT INTO empNTpo_vpl VALUES ("JG10_15","008_10_15","JDG","10","15","15","Maʌ̃ne israelerãba Ãcõrẽa jarasid̶aa: –Daiba wãrãda cadjiruada osid̶aa. Bʌa dairã cawa o quĩrĩã b̶ʌ quĩrãca odua, baribʌrʌ ¡dai quĩrã djuburia nawena ẽdrʌ b̶ʌdua!– ");
INSERT INTO empNTpo_vpl VALUES ("JG10_16","008_10_16","JDG","10","16","16","Maʌ̃ne dewara ãcõrẽ b̶eara israelerãba b̶atacuad̶aped̶a Ãcõrẽra wayacusa ẽpẽsid̶aa. Israelerã bia mĩga panʌ bẽrã Ãcõrẽba waa droaẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG10_17","008_10_17","JDG","10","17","17","Maʌ̃ ewarid̶e amonitarãra Gala ẽjũãne dji jʌresid̶aa israelerã ume djõni carea. Maʌ̃ne Galad̶ebema israelerãra Mizpa purud̶e dji jʌresid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG10_18","008_10_18","JDG","10","18","18","Mãwã panʌne ãdjirãba, dji bororã bid̶a ãdjiza iwid̶isid̶aa: –¿Caida naãrã amonitarã ume djõne wãi?– Maʌ̃be nãwã bed̶ea b̶ʌsid̶aa: –Djõbʌdad̶e dji nocoare b̶ebʌrʌda jũma dadji Galad̶ebemarã boro baya.– ");
INSERT INTO empNTpo_vpl VALUES ("JG11_1","008_11_1","JDG","11","1","1","Maʌ̃ ewarid̶e Jepteda Gala ẽjũãne b̶abadjia. Idjira bio mẽsrã b̶asia idjab̶a sozarra b̶asia. Dji zezara Gala abadjid̶aa. Galaba wẽrã aud̶ua ume Jeptera unusia. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_2","008_11_2","JDG","11","2","2","Gala quima bid̶a warrarãda tosia. Maʌ̃ warrarã wariped̶ad̶acarea Jeptea jarasid̶aa ãdji zezaba erob̶ʌd̶ebemada edaẽ́da, dewara wẽrãba tod̶a bẽrã. Mãwã jarad̶aped̶a Jeptera ãyã jʌretasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_3","008_11_3","JDG","11","3","3","Maʌ̃ carea idji djabarã ume b̶ad̶ada Tob ẽjũãne b̶ad̶e wãsia. Mama ẽberãrã cadjirua b̶eada peped̶a ãdjia quĩrĩãbʌdada od̶e wãbadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_4","008_11_4","JDG","11","4","4","Maʌ̃misa amonitarãra Mizpa purud̶aa zesid̶aa Galad̶ebema israelerã ume djõni carea. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_5","008_11_5","JDG","11","5","5","Maʌ̃ carea Galad̶ebema israelerã bororãra Tob ẽjũãnaa Jepte trʌ̃ne wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_6","008_11_6","JDG","11","6","6","Dji bororãba idjía nãwã jarasid̶aa: –Amonitarãra dairã ume djõne zesid̶a bẽrã daiba quĩrĩã panʌa bʌra dai ume wãped̶a dai sordaorã boro baida.– ");
INSERT INTO empNTpo_vpl VALUES ("JG11_7","008_11_7","JDG","11","7","7","Dji bororã tãẽna idji djabarãda panʌ bẽrã Jepteba nãwã jarasia: –¿Bãrãba mʌ̃ra quĩrãma panasid̶aẽ́ca? ¿Mʌ̃ zeza ded̶ebemada ãyã jʌretad̶aẽ́ basica? Bãrãra minijĩchiad̶e panʌ bẽrã ¿mʌ̃ra jãwã jʌrʌd̶e ze panʌca?– ");
INSERT INTO empNTpo_vpl VALUES ("JG11_8","008_11_8","JDG","11","8","8","Maʌ̃ne dji bororãba nãwã jarasid̶aa: –Mãẽ, maʌ̃ carea dairãba bʌra jʌrʌd̶e ze panʌa. Quĩrĩã panʌa bʌra dairãare amonitarã ume djõne wãida. Wãsira bʌra dai Galad̶ebema israelerã boro baya.– ");
INSERT INTO empNTpo_vpl VALUES ("JG11_9","008_11_9","JDG","11","9","9","Jepteba jarasia: –Bãrãba mʌ̃ra jẽda amonitarã ume djõne eded̶aped̶a Ãcõrẽba mʌ̃́a ãdjirãda poyabibʌrʌ, ¿wãrãda mʌ̃ra bãrã boroda b̶ʌd̶ica?– ");
INSERT INTO empNTpo_vpl VALUES ("JG11_10","008_11_10","JDG","11","10","10","Dji bororãba panusid̶aa: –Mãẽ, dairãba Ãcõrẽ quĩrãpita jarabʌdaa bʌa jara b̶ʌra wãrãda od̶ida.– ");
INSERT INTO empNTpo_vpl VALUES ("JG11_11","008_11_11","JDG","11","11","11","Ara maʌ̃da Jeptera ãdjirã ume wãped̶a Galad̶ebema israelerãba idjira b̶ʌsid̶aa ãdji sordaorã boroda idjab̶a puru boroda. Maʌ̃be Mizpa purud̶e Jepteba dji bororãa jarad̶ara waya Ãcõrẽ quĩrãpita jarasia. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_12","008_11_12","JDG","11","12","12","Mãwãnacarea Jepteba ʌ̃cʌrʌ diabuesia amonitarã boroa nãwã iwid̶id̶amãrẽã: –Bʌra ¿cãrẽ cãrẽã dairã ume quĩrũ b̶ʌ? ¿Cãrẽ cãrẽã dai druad̶e djõne ze b̶ʌ?– ");
INSERT INTO empNTpo_vpl VALUES ("JG11_13","008_11_13","JDG","11","13","13","Amonitarã boroba Jepteba diabued̶arãa nãwã panusia: –Bãrã israelerã Egiptod̶eba zesid̶ad̶e dai druara jãrĩsid̶aa Arnoʌ̃ dod̶eba ab̶a Jabó dod̶aa. Jũma Jordaʌ̃ do icawa b̶ʌ ẽjũã ʌ̃mãdau odjabariare b̶ʌra jãrĩsid̶aa. Bãrãba maʌ̃ ẽjũãda biad̶eba jẽda diad̶ibʌrʌ bãrã ume djõnaẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("JG11_14","008_11_14","JDG","11","14","15","Maʌ̃be Jepteba dewararãda diabuesia amonitarã boroa nãwã jarad̶amãrẽã: –Jepteba nãwã jara b̶ʌa: “Dai israelerãba bãrã amonitarã druara ni moabitarã drua sid̶a jãrĩnaẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_16","008_11_16","JDG","11","16","16","Dai israelerã Egiptod̶eba ẽdrʌsid̶ad̶e naãrã ẽjũã põãsa ewaraga b̶ʌd̶e Pusa Purrud̶aa wãsid̶aa. Mamaʌba Cadé purud̶e jũẽne wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_17","008_11_17","JDG","11","17","17","Maʌ̃ne dai israelerã bororãba ʌ̃cʌrʌ diabuesid̶aa Edoʌ̃ druad̶ebema boromaa. Idjía iwid̶isid̶aa dai israelerã idji druad̶e wãyã wãbimãrẽã. Baribʌrʌ idjia iduaribiẽ́ basía. Moab druad̶ebema boroa bid̶a ab̶arida iwid̶isid̶aa. Baribʌrʌ idjia bid̶a iduaribiẽ́ basía. Maʌ̃ bẽrã dai israelerãra Cadéd̶e duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_18","008_11_18","JDG","11","18","18","Maʌ̃be ẽjũã põãsa ewaraga b̶ʌd̶e Edoʌ̃ drua aud̶u idjab̶a Moab drua aud̶u pʌrrʌga wãnaped̶a Arnoʌ̃ do icawa jũẽne wãsid̶aa. Mama Moab drua quĩrãpe ʌ̃mãdau odjabariare duanesid̶aa baribʌrʌ do chãnaẽ́ basía, wa quĩrãrẽ moabitarã drua bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_19","008_11_19","JDG","11","19","19","Maʌ̃be dai israelerã bororãba ʌ̃cʌrʌ Hesboʌ̃ purud̶aa diabuesid̶aa amorreorã boro Sehoʌ̃maa. Idjía bid̶a iwid̶isid̶aa dai israelerãra idji druad̶e idu wãyã wãbimãrẽã dai druad̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_20","008_11_20","JDG","11","20","20","Baribʌrʌ dai israelerãba iwid̶iped̶ad̶ara Sehoʌ̃ba sewada crĩchad̶a bẽrã idji druad̶e idu wãyã wãbiẽ́ basía. Maʌ̃ awara idji sordaorãda jũma ãbaa jʌreped̶a Jahaza puru caita zed̶aped̶a dai israelerã ume djõsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_21","008_11_21","JDG","11","21","21","Baribʌrʌ dai israelerã Ãcõrẽba Sehoʌ̃ra, idji sordaorã sid̶a jũma poyabisia. Maʌ̃be dai israelerãba maʌ̃ druad̶e b̶ea amorreorã ẽjũãra jũma edasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_22","008_11_22","JDG","11","22","22","Arnoʌ̃ dod̶eba ab̶a Jabó dod̶aa idjab̶a ẽjũã põãsa ewaraga b̶ʌd̶eba ab̶a Jordaʌ̃ dod̶aa ãdji ẽjũãra jũma edasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_23","008_11_23","JDG","11","23","23","Dai israelerã Ãcõrẽba amorreorãra ãyã jʌretaped̶a maʌ̃ ẽjũãra dairã, idji purua diad̶a bẽrã ¿bʌra cai mãwã jãrĩ carea? ");
INSERT INTO empNTpo_vpl VALUES ("JG11_24","008_11_24","JDG","11","24","24","¿Bʌ ãcõrẽ Quemoba bʌ́a diad̶ara bʌreẽ́ca? Ab̶ari quĩrãca dai Ãcõrẽba dairãa diad̶ara daid̶ea. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_25","008_11_25","JDG","11","25","25","¿Bʌa moabitarã boro bad̶a Zipor warra Baláda quĩrãneba b̶ʌca? Naʌ̃ ẽjũã carea idjira dairã ume ijaraẽ́ basía ni djõne zeẽ́ basía. ¿Bʌra Balá cãyãbara dji dromaara b̶ʌca? ");
INSERT INTO empNTpo_vpl VALUES ("JG11_26","008_11_26","JDG","11","26","26","Dai israelerãra Hesboʌ̃ purud̶e, Aroer purud̶e, maʌ̃ caita b̶ea puru zaqued̶e, idjab̶a Arnoʌ̃ do icawa b̶ea purud̶e bid̶a tresciento poa panʌa. Dairãra naʌ̃ druad̶e dãrãbʌdaa. Bãrãba ¿cãrẽ cãrẽã ʌ̃rãbʌrʌ naʌ̃ druara iwid̶i panʌ? ");
INSERT INTO empNTpo_vpl VALUES ("JG11_27","008_11_27","JDG","11","27","27","Mʌ̃a bʌra biẽ́ oẽ́ b̶ʌa. Bʌdrʌ dairã ume djõ quĩrĩã b̶ʌ bẽrã biẽ́ o b̶ʌa. Ãcõrẽ dadji cawa obariba id̶i cawabiya cairãba jipa o panʌda: dai israelerãba wa bãrã amonitarãba.”– ");
INSERT INTO empNTpo_vpl VALUES ("JG11_28","008_11_28","JDG","11","28","28","Jepteba mãwã jarabid̶amĩna amonitarã boroba ĩjãẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_29","008_11_29","JDG","11","29","29","Maʌ̃ne Ãcõrẽ Jaurera Jeptemaa zesia. Maʌ̃ bẽrã Jeptera Gala ẽjũãne, Manased̶eba yõped̶ad̶arã ẽjũãne bid̶a jũma pʌrrʌasia sordaorã jʌrei carea. Sordaorã ãbaa jʌreped̶a Gala druad̶e b̶ʌ Mizpa purud̶e jũẽsia. Mamaʌba amonitarã ume djõne wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_30","008_11_30","JDG","11","30","31","Mãwã b̶ʌd̶e Jepteba Ãcõrẽa wãrãneba nãwã jarasia: –Bʌa amonitarãda mʌ̃́a poyabibʌrʌ, diguid̶aa wãbʌrʌd̶e naãrã mʌ̃ audiab̶arid̶e zebʌrʌda mʌ̃a bʌ́a babue diaya.– ");
INSERT INTO empNTpo_vpl VALUES ("JG11_32","008_11_32","JDG","11","32","32","Mãwã jaraped̶a amonitarã ume djõne wãsia. Maʌ̃ne Ãcõrẽba idjía poyabisia. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_33","008_11_33","JDG","11","33","33","Jepteba amonitarãra zocãrã quenasia. Aroer purud̶eba ab̶a Minit purud̶aa idjab̶a Abel-queramiʌ̃ purud̶aa bid̶a veinte puru poyasia. Mãwã amonitarãra israelerã jʌwaed̶a panesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_34","008_11_34","JDG","11","34","34","Mãwãnacarea Jeptera Mizpa purud̶aa jẽda wãsia. Diguid̶aa jũẽbʌrʌd̶e idji cauba audiab̶arisia. Tõnõã zá b̶ʌd̶e cari b̶asia. Jepteba dewara cauda ni warra sid̶a neẽ́ b̶asia. Ab̶a idjidrʌ erob̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_35","008_11_35","JDG","11","35","35","Idji cau unubʌrʌd̶e Jeptera bio sopuasia. Maʌ̃ carea idjia cacuad̶e jʌ̃ b̶ʌda cũẽtacuaped̶a idji caua nãwã jarasia: –¡Ay, cau, bʌa mʌ̃ra bio sopuabibʌrʌa! Mʌ̃a Ãcõrẽa wãrãneba diai jarad̶ara diaida b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("JG11_36","008_11_36","JDG","11","36","36","Dji cauba nãwã jarasia: –Zeza, bʌa Ãcõrẽa iwid̶id̶a quĩrãca idjia amonitarã bʌ dji quĩrũra poyabisia. Maʌ̃ bẽrã bʌa idjía wãrãneba jarad̶ara odua. Mʌ̃ra Ãcõrẽa babue diadua. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_37","008_11_37","JDG","11","37","37","Baribʌrʌ mʌ̃ quĩrã djuburia jed̶eco umé mʌ̃ra eyad̶e idu pʌrrʌad̶e wãbidua. Mʌ̃ dji biarã ume jĩãne wãya mʌ̃ra quima edaẽ́ beui bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("JG11_38","008_11_38","JDG","11","38","38","Jepteba panusia: –Bia b̶ʌa. Wãdua.– Idjira jed̶eco umé idu wãbisia. Maʌ̃ne idji biarã ume eyad̶e jĩã nĩbasid̶aa, quima edaẽ́ beui bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_39","008_11_39","JDG","11","39","39","Mãwãnacarea idjira Jeptemaa jẽda zesia. Maʌ̃be Jepteba Ãcõrẽa wãrãneba jarad̶ara osia. Mãwã idji caura umaquĩrã adua b̶ʌda jaid̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("JG11_40","008_11_40","JDG","11","40","40","Maʌ̃ carea Israeld̶ebema awẽrãrãba poaza ewari quĩmãrẽ Galad̶ebema Jepte cau carea jĩãbadaa. ");
INSERT INTO empNTpo_vpl VALUES ("JG12_1","008_12_1","JDG","12","1","1","Jepteba amonitarã poyad̶acarea Epraiʌ̃nebema sordaorãda dji jʌred̶aped̶a Jordaʌ̃ do chãnaped̶a Sapoʌ̃ puruare Jepte b̶ʌmaa wãsid̶aa. Quĩrũbid̶eba Jeptea nãwã iwid̶isid̶aa: –¿Cãrẽ cãrẽã bʌdub̶a amonitarã ume djõne wãsi? ¿Cãrẽ cãrẽã dairãra trʌ̃ẽ́ basi bʌ ume wãnamãrẽã? Mãwã od̶a bẽrã dairãba bʌra, bʌ de sid̶a jũma babued̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("JG12_2","008_12_2","JDG","12","2","2","Maʌ̃ne Jepteba ãdjirãa nãwã panusia: –Mʌ̃ra, mʌ̃ ẽberãrã sid̶a amonitarã ume djõ panasid̶aa. Maʌ̃ne bãrãra trʌ̃bisia baribʌrʌ bãrãba carebad̶e zed̶aẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG12_3","008_12_3","JDG","12","3","3","Carebad̶e zed̶aẽ́ bẽrã mʌ̃ra bead̶i adua amonitarã ume djõne wãsid̶e Ãcõrẽba mʌ̃́a ãdjirãra poyabisia. Maʌ̃da bãrãra ¿cãrẽ cãrẽã mʌ̃ ume djõne ze panʌ?– ");
INSERT INTO empNTpo_vpl VALUES ("JG12_4","008_12_4","JDG","12","4","4","Maʌ̃ne Epraiʌ̃nebemarãba ãdjira nãwã biẽ́ jarasid̶aa: –Bãrã Galad̶e b̶eara dadji Epraiʌ̃neba yõped̶ad̶amĩna dairãra igarad̶aped̶a bãdjia o quĩrĩã panʌda obadaa. Dai Epraiʌ̃neba yõped̶ad̶a tãẽna idjab̶a Manased̶eba yõped̶ad̶a tãẽna panabadamĩna bãrãra awara quĩrãca panabadaa.– Mãwã jara panʌ carea Jepteba Galad̶ebema sordaorãda ãbaa jʌreped̶a Epraiʌ̃nebemarã ume djõne wãnaped̶a zocãrã quenasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG12_5","008_12_5","JDG","12","5","6","Maʌ̃ne Galad̶ebemarãba Jordaʌ̃ do chãbadama jʌ̃ãsid̶aa. Mama Epraiʌ̃nebemarãra chãnida panasid̶aa jẽda ãdji druad̶aa mĩrũ wãni carea. Ab̶aʌba chãi carea iwid̶ibʌrʌd̶e Galad̶ebemarãba iwid̶ibadjid̶aa: –¿Bʌra Epraiʌ̃nebemaca?– Maʌ̃ne Epraiʌ̃nebemaba mãwãẽ́ana asira Galad̶ebemarãba jarabadjid̶aa: –“Chibolet” adua.– Epraiʌ̃nebemarãba maʌ̃ bed̶eara poya arid̶e jarad̶aca basía. Biara “Sibolet” abadjid̶aa. Maʌ̃ne ab̶aʌba Sibolet asira Galad̶ebemarãba cawabadjid̶aa idjira Epraiʌ̃nebemada. Maʌ̃ bẽrã jidad̶aped̶a ara mama Jordaʌ̃ do icawa beabadjid̶aa. Maʌ̃ ewarid̶e Epraiʌ̃nebemarãra 42 mil beasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG12_7","008_12_7","JDG","12","7","7","Jepteba sei poa israelerãra dji quĩrũ jʌwaed̶abemada ẽdrʌ b̶ʌbadjia. Jaid̶ad̶acarea Gala druad̶e idji purud̶e tʌb̶arisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG12_8","008_12_8","JDG","12","8","8","Jepte jaid̶ad̶acarea Ibzaʌ̃ Beleʌ̃nebemada israelerã ẽdrʌ b̶ʌbari basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG12_9","008_12_9","JDG","12","9","9","Maʌ̃ Ibzaʌ̃ba warrarãda treinta, caurã sid̶a treinta erob̶asia. Idji caurãda dewara purud̶ebemarãa quima diasia. Idji warrarã itea dewara purud̶ebema wẽrãrãda treinta enesia ãdji quimada b̶ead̶amãrẽã. Ibzaʌ̃ra siete poa israelerã ẽdrʌ b̶ʌbari basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG12_10","008_12_10","JDG","12","10","10","Jaid̶asid̶e Beleʌ̃ purud̶e tʌb̶arisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG12_11","008_12_11","JDG","12","11","11","Ibzaʌ̃ jaid̶ad̶acarea Eloʌ̃da die poa israelerã ẽdrʌ b̶ʌbari basía. Maʌ̃ Eloʌ̃ra Zabuloʌ̃neba yõna basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG12_12","008_12_12","JDG","12","12","12","Jaid̶asid̶e Ajaloʌ̃ purud̶e tʌb̶arisid̶aa Zabuloʌ̃neba yõped̶ad̶arã ẽjũãne. ");
INSERT INTO empNTpo_vpl VALUES ("JG12_13","008_12_13","JDG","12","13","13","Eloʌ̃ jaid̶ad̶acarea Hilel warra Abdoʌ̃da israelerã ẽdrʌ b̶ʌbari basía. Maʌ̃ Abdoʌ̃ra Piratoʌ̃ purud̶ebema basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG12_14","008_12_14","JDG","12","14","14","Idjia warrarãda cuarenta idjab̶a wiuzaquerãda treinta erob̶asia. Ãdjirãra setenta burro ʌ̃rʌ̃ nĩbabadjid̶aa. Abdoʌ̃ra ocho poa israelerã ẽdrʌ b̶ʌbari basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG12_15","008_12_15","JDG","12","15","15","Hilel warra Abdoʌ̃ jaid̶asid̶e Piratoʌ̃ purud̶e tʌb̶arisid̶aa Epraiʌ̃neba yõped̶ad̶arã ẽjũã eyaid̶a b̶ʌd̶e. Naẽna amalecitarãda maʌ̃ ẽjũãne panabadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","Mãwãnacarea israelerãba wayacusa Ãcõrẽ quĩrãpita cadjiruada o panesid̶aa. Maʌ̃ carea Ãcõrẽba ãdjirãra cuarenta poa pilisteorã jʌwaed̶a b̶ʌsia. ");
INSERT INTO empNTpo_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","Maʌ̃ ewarid̶e Zora purud̶e ẽberãda b̶abadjia Manoa abadada. Idjira Daʌ̃neba yõna basía. Idji quimada warra toca bẽrã warra neẽ́ b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","Ewari ab̶a Ãcõrẽ nezoca bajãnebemada maʌ̃ wẽrãma odjaped̶a nãwã jarasia: –Mʌ̃a cawa b̶ʌa bʌra warra toca bẽrã warra neẽ́ b̶ʌda. Baribʌrʌ bʌra b̶iogoa b̶eped̶a umaquĩrã warrada toya. ");
INSERT INTO empNTpo_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","5","Maʌ̃ warrara bʌ b̶ited̶a b̶ʌ ewarid̶eba ʌ̃taa Ãcõrẽ itea b̶aya. Maʌ̃ bẽrã uva b̶a aseada, dewara itua sid̶a dorãdua. Maʌ̃ awara Ãcõrẽba idu cobicara corãdua. Bʌ warrara nazareo bai bẽrã idji bud̶ara tʌcara b̶ʌa. Idjia jʌwa b̶ʌya bãrã israelerãra pilisteorã jʌwaed̶abemada ẽdrʌ b̶ʌi carea.– ");
INSERT INTO empNTpo_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","Maʌ̃be dji wẽrãra idji quima Manoamaa wãped̶a nãwã jarasia: –Ẽberã Ãcõrẽba diabued̶ada mʌ̃maa zesia. Idjira bajãnebema nezoca quĩrãca ununa bẽrã mʌ̃a wayasia. Idjira sãmabemada, idji trʌ̃ sid̶a mʌ̃a iwid̶iẽ́ basía. Idjia mʌ̃́a jaraẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","Baribʌrʌ idjia jarasia mʌ̃ra b̶iogoa b̶eped̶a warrada toida. Maʌ̃ warrara mʌ̃ b̶ited̶a b̶ʌ ewarid̶eba ab̶a idji beubʌrʌd̶aa Ãcõrẽ itea b̶ayad̶a asia. Idjira nazareo bai bẽrã mʌ̃a uva b̶a aseada, dewara itua sid̶a docara b̶ʌad̶a asia. Maʌ̃ awara Ãcõrẽba idu cobicada mʌ̃a cocara b̶ʌad̶a asia.– ");
INSERT INTO empNTpo_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","Maʌ̃ne Manoaba Ãcõrẽa nãwã iwid̶isia: –Dai Ãcõrẽ, mʌ̃ djuburia bʌa diabued̶a ẽberãda wayacusa daimaa diabuedua jaradiamãrẽã mʌ̃ quimaba toi warrara sãwã daupẽnida panʌda.– ");
INSERT INTO empNTpo_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","Manoaba iwid̶id̶ara Ãcõrẽba bia ũrĩsia. Maʌ̃ bẽrã bajãnebema nezocara dji wẽrãmaa waya zesia. Maʌ̃ne wẽrãra néud̶e b̶asia. Baribʌrʌ idji quima Manoara neẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","Maʌ̃ bẽrã dji wẽrãra idji quimamaa pira wãped̶a nãwã jarasia: –¡Mʌ̃a ẽberã sãʌ̃bed̶a ununara waya zesia!– ");
INSERT INTO empNTpo_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","Maʌ̃ carea Manoara piradrʌped̶a idji quima ume wãsia. Dji ẽberã b̶ʌma jũẽped̶a nãwã jarasia: –Sãʌ̃bed̶a mʌ̃ quima ume bed̶ea b̶ad̶ara ¿bʌ basica?– Dji ẽberãba panusia: –Mãẽ. Mʌ̃ basía.– ");
INSERT INTO empNTpo_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","Maʌ̃ne Manoaba nãwã iwid̶isia: –Bʌa jarad̶a quĩrãca mʌ̃ quimaba warrada tosira, daiba idjira ¿sãwã daupẽnida panʌ? ¿Idjira sãwã eropananida panʌ?– ");
INSERT INTO empNTpo_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","Bajãnebema nezocaba panusia: –Mʌ̃a jarad̶a quĩrãca bʌ quimaba jũma ĩjã oida b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","Uvara cocara b̶ʌa. Uva b̶a aseada, dewara itua sid̶a docara b̶ʌa. Maʌ̃ awara Ãcõrẽba idu cobicara ni maãrĩ bid̶a cocara b̶ʌa. Mʌ̃a jarad̶ara idjia jũma ĩjã oida b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","Manoaba bajãnebema nezocaa nãwã jarasia: –Dai djuburia wad̶i wãrãdua. Chiwatu zaqueda bead̶aped̶a bʌ itea djud̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","Bajãnebema nezocaba panusia: –Mʌ̃ b̶ebʌrʌ sid̶a bãrã djicora coẽ́a. Baribʌrʌ bãrãba quĩrĩã panʌbʌrʌ, maʌ̃ chiwatu zaquera Ãcõrẽa babue diad̶adua.– Manoaba bajãnebema nezocada mãwã b̶ʌda wad̶i cawaẽ́ b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","Maʌ̃ne Manoaba Ãcõrẽ nezoca bajãnebemaa jarasia: –Bʌ trʌ̃ra daia jaradua. Mãwã bʌa jarad̶a quĩrãca dai warra tod̶acarea bʌra bia jarad̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","Baribʌrʌ bajãnebema nezocaba jarasia: –Bʌa ¿cãrẽ cãrẽã mʌ̃ trʌ̃ra cawa quĩrĩã b̶ʌ? Mʌ̃ trʌ̃ra jũmawãyã bia quirua. Ẽberãrãba poya cawad̶aẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","Manoaba chiwatu zaquera beaped̶a néud̶ebema sid̶a edaped̶a umena mõgara ʌ̃rʌ̃ cob̶ʌped̶a Ãcõrẽa jũma babue diasia. Maʌ̃ne Manoaba idji quima bid̶a acʌ panʌne Ãcõrẽba ne ununacada nãwã osia: ");
INSERT INTO empNTpo_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","Manoaba babue diad̶ara waib̶ʌa eradrʌ nũmʌne Ãcõrẽ nezoca bajãnebemara maʌ̃ uruad̶eba bajãnaa wãsia. Manoaba idji quima bid̶a maʌ̃ ununaped̶a Ãcõrẽ wayaad̶eba chĩrãborod̶e copanenaped̶a ãdji dratura egorod̶aa tẽũ copanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","Ãcõrẽ nezoca bajãnebemara Manoama, dji quimama bid̶a waa odjaẽ́ basía. Maʌ̃ bẽrã Manoaba cawasia dji ẽberãra wãrãda Ãcõrẽ nezoca bajãnebemada mãwã b̶asida. ");
INSERT INTO empNTpo_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","Maʌ̃ne idji quimaa nãwã jarasia: –Ãcõrẽda unuped̶ad̶a bẽrã dadjira beud̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","Baribʌrʌ dji quimaba jarasia: –Mãwãẽ́a. Ãcõrẽba dadjida bea quĩrĩã b̶ad̶abara dadjia chiwatu idjab̶a néud̶ebema babue diaped̶ad̶ara bia edaẽ́ bacasia. Maʌ̃ awara idjia ne ununaca od̶ara unubiẽ́ bacasia ni dadji warra ununinebemada jaraẽ́ bacasia.– ");
INSERT INTO empNTpo_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","Mãwãnacarea dji wẽrãba warrada tosia. Maʌ̃ warrara trʌ̃ b̶ʌsia Sansoʌ̃. Sansoʌ̃ waribʌrʌd̶e Ãcõrẽba idjira careba b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","Maʌ̃ ewarid̶e Sansoʌ̃ra Daʌ̃neba yõped̶ad̶arã purud̶e b̶abadjia Zora puru idjab̶a Estaol puru ẽsi. Mama Ãcõrẽ Jaureba unubibadjia idjira Sansoʌ̃ ume b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","Ewari ab̶a Sansoʌ̃ra pilisteorã puru Timnatad̶aa wãsia. Mama pilisteo wẽrãda unuped̶a awuasia. ");
INSERT INTO empNTpo_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","Jẽda diguid̶aa wãped̶a idji djibarirãa nãwã jarasia: –Mʌ̃a Timnata purud̶e pilisteo wẽrãda unusia. Mʌ̃ djuburia, idji djibarirãa idjira iwid̶id̶adua mʌ̃a edai carea.– ");
INSERT INTO empNTpo_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","Maʌ̃ne Sansoʌ̃ djibarirãba jarasid̶aa: –¿Cãrẽ cãrẽã pilisteo wẽrãda eda quĩrĩã b̶ʌ? Pilisteorãra cacua wẽãgoẽ́ tab̶eaa. ¿Dadji Daʌ̃neba yõped̶ad̶arã idjab̶a waabema israelerã tãẽna wẽrã biada neẽ́ca?– Sansoʌ̃ba panusia: –Mʌ̃a jãʌ̃ wẽrãda awua b̶ʌa. Idjira mʌ̃ itea iwid̶id̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","Idji djibarirãba adua panasid̶aa Ãcõrẽbʌrʌ Sansoʌ̃a mãwã crĩchabisida. Mãwã osia Sansoʌ̃ra pilisteorã ume djõne wãmãrẽã. Maʌ̃ ewarid̶e israelerãra pilisteorã jʌwaed̶a panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","Maʌ̃be Sansoʌ̃ djibarirãra Timnata purud̶aa wãsid̶aa. Idji sid̶a ãdji caid̶u wãsia. Sansoʌ̃ Timnatad̶ebema uva ẽjũãne jũẽbʌrʌd̶e imamaba idjira orrasia. ");
INSERT INTO empNTpo_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","Ara maʌ̃da Ãcõrẽ Jaured̶eba Sansoʌ̃ra bio juerza baraped̶a ara idji jʌwaba imamara beasia chiwatu zaque beabʌrʌ quĩrãca. Mãwã bead̶amĩna idji djibarirãa jaraẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","Maʌ̃be Timnatad̶e jũẽped̶a dji wẽrã ume bed̶easia. Maʌ̃ wẽrãra bio awuasia. ");
INSERT INTO empNTpo_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","Dãrãbʌrʌd̶e Sansoʌ̃ra wayacusa Timnatad̶aa wãsia maʌ̃ wẽrã edai carea. Puru caita jũẽbʌrʌd̶e imama bead̶ada acʌd̶e wãsia. Maʌ̃ne imama b̶ʌwʌrʌd̶e urrajõ dʌrrʌda powua nũmasia idjab̶a urrajõda ed̶a b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","Maʌ̃ urrajõra idji jʌwaba tue edaped̶a jõ wãsia. Idji djibarirã unusid̶e urrajõra diasia. Maʌ̃ne ãdjia jõsid̶aa. Baribʌrʌ Sansoʌ̃ba jaraẽ́ basía imama beud̶a b̶ʌwʌrʌd̶e urrajõra edasida. ");
INSERT INTO empNTpo_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","Sansoʌ̃ zezara dji wẽrã b̶ʌmaa wãsia. Mama Sansoʌ̃ba b̶ʌsrid̶a ne cobada waib̶ʌada osia cũdrarãba quima edabʌdad̶e obada quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","Pilisteorãba Sansoʌ̃ unusid̶ad̶e ãdji dji biarãda treinta edasid̶aa idji ume pananamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","Sansoʌ̃ba maʌ̃ treinta panʌ́a nãwã jarasia: –Mʌ̃a bãrãa mĩãdjiruda jaraya. Siete ewari naʌ̃ b̶ʌsrid̶a cobada ewari o panʌne bãrãba maʌ̃ mĩãdjiruda cawa jarad̶ibʌrʌ, mʌ̃a bãrãza lino od̶a djioda ab̶a idjab̶a b̶ʌsrid̶a od̶i careabema djio sid̶a ab̶a diaya. ");
INSERT INTO empNTpo_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","Baribʌrʌ cawa jarad̶aẽ́bʌrʌ, bãrãza mʌ̃́a lino od̶a djioda ab̶a idjab̶a b̶ʌsrid̶a od̶i careabema djio sid̶a ab̶a diad̶ida panʌa.– Ãdjia jarasid̶aa: –Bia b̶ʌa. Jaradua.– ");
INSERT INTO empNTpo_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","Maʌ̃ne Sansoʌ̃ba nãwã jarasia: –Mĩãdjiru, mĩãdjiru, mĩãdjiru. Dadji cobarid̶eba cod̶ida edasia. Dji mẽsrãara b̶ʌd̶eba cũãda edasia. Maʌ̃gʌra ¿cãrẽ?– Ewari ũbead̶e pilisteorã treinta panʌba mĩãdjirura cawa jarad̶aẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","Maʌ̃ carea quĩmãrẽbema ewarid̶e Sansoʌ̃ba edai wẽrãa nãwã jarasid̶aa: –¿Bãrãba dairãra trʌ̃sid̶aca dairãneda jãrĩni carea? Jãʌ̃ mĩãdjiruba jara b̶ʌra bʌdji quimaa iwid̶idua. Mãwã oẽ́bʌrʌ daiba bʌra, bʌ ẽberãrã sid̶a babued̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","Ara maʌ̃da dji wẽrãra Sansoʌ̃maa wãped̶a jĩã b̶ʌba nãwã jarasia: –¡Bʌa mʌ̃ra quĩrĩãẽ́ b̶ʌa! Jãʌ̃ mĩãdjiru mʌ̃ ẽberãrãa jarad̶ara bʌa mʌ̃́a jaraẽ́ b̶ʌa cãrẽda jara b̶ʌda. ¡Bʌa mʌ̃ra quĩrãma b̶ʌa!– Sansoʌ̃ba panusia: –Mʌ̃a bʌ́a ¿cãrẽã jarai? Mʌ̃ djibarirãa bid̶a jaraẽ́ b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","Baribʌrʌ dji wẽrãra maʌ̃ b̶ʌsrid̶a cobada ewari siete panʌne jĩãbadjia. Baridua mĩã sẽ b̶ʌ bẽrã sietebema ewarid̶e Sansoʌ̃ba idjía jarasia. Ara maʌ̃da wẽrãba pilisteorã treinta panʌ́a jarasia mĩãdjiruba jara b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","Sietebema ewarid̶e queui naẽna pilisteorãra Sansoʌ̃maa wãnaped̶a mĩãdjirura arid̶e nãwã jarasid̶aa: –Urrajõ cãyãbara ¿cãrẽda cũãara b̶ʌ? Imama cãyãbara ¿cãrẽda mẽsrãara b̶ʌ?– Maʌ̃ne Sansoʌ̃ba jarasia: –Bãrãra mʌ̃ wẽrã ume bed̶eaped̶ad̶aẽ́bara poya panunaẽ́ bacasia.– ");
INSERT INTO empNTpo_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","Maʌ̃ne Ãcõrẽ Jaured̶eba Sansoʌ̃ra bio juerza baraped̶a pilisteorã puru Ascaloʌ̃naa wãsia. Mamabemarãda treinta beaped̶a ãdjia cacuad̶e jʌ̃badara edaped̶a mĩãdjiru arid̶e jaraped̶ad̶arãa diasia. Mãwãnacarea bio quĩrũ b̶ʌda idji zeza ded̶aa jẽda wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","Maʌ̃ bẽrã idji quima bai b̶ad̶a zezaba dji caura Sansoʌ̃ ume b̶ad̶a ẽberãa diasia. ");
INSERT INTO empNTpo_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","Mãwãnacarea trigo jara Sansoʌ̃ba idji quima bai b̶ad̶ara acʌd̶e wãsia. Idjía diai carea chiwatu zaqueda edesia. Jũẽped̶a dji zãwãrẽ bai b̶ad̶aa jarasia: –Mʌ̃ wẽrã cãĩbarimaa acʌd̶e wãya.– Baribʌrʌ dji wẽrã zezaba idu wãbiẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","Idjia jarasia: –Mʌ̃a crĩchasia bʌa mʌ̃ caura ab̶ed̶a igarasida. Maʌ̃ carea bʌ ume b̶ad̶a ẽberãa idjira diasia. Mʌ̃ cau tẽãbemara biara quirua. Idjidrʌ dji nabema cacuabari edadua.– ");
INSERT INTO empNTpo_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","Maʌ̃ carea Sansoʌ̃ba jarasia: –¡Bãrãba mãwã oped̶ad̶a bẽrã mʌ̃a bãrã pilisteorã biẽ́ obʌrʌd̶e bed̶ead̶e b̶aẽ́a!– ");
INSERT INTO empNTpo_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","Maʌ̃be Sansoʌ̃ba usa pãda tresciento jidacuasia. Maʌ̃ra umé uméa ãbaa dji drud̶e jʌ̃cuaped̶a cãdorrona ĩbĩrãda ãdji drud̶e jʌ̃cuasia. ");
INSERT INTO empNTpo_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","Maʌ̃be ĩbĩrãra coacuaped̶a usa pãra pilisteorã néud̶e buecuasia. Maʌ̃ba ãdji trigora jũma bá wãsia, dji ewaped̶ad̶ada, dji ewad̶aẽ́ panʌ sid̶a. Maʌ̃ awara ãdji uva ẽjũãra, olivo ẽjũã sid̶a jũma bá wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","Maʌ̃ carea pilisteorãba jũmarãa iwid̶isid̶aa caiba mãwã osi cawaya. Maʌ̃ne cawasid̶aa Sansoʌ̃ba mãwã osida idji zãwãrẽ bai b̶ad̶aba idji caura Sansoʌ̃a diai cãyãbara Sansoʌ̃ ume b̶ad̶a ẽberãa diad̶a bẽrã. Maʌ̃ carea pilisteorãba dji wẽrãra, dji zeza sid̶a bá beasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","Maʌ̃ne Sansoʌ̃ba jarasia: –Bãrãba mãwã oped̶ad̶a bẽrã mʌ̃a wãrãneba jaraya ʌ̃nãũẽ́ bãrãra biẽ́ o b̶aida ab̶a mʌ̃a quĩrĩãbʌrʌ quĩrãca obʌrʌd̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","Mãwã jaraped̶a quĩrũbid̶eba pilisteorãra zocãrã quenasia. Maʌ̃be Sansoʌ̃ra Etam eya ʌra jira b̶ad̶aa wãsia. Mama uriad̶e b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","Sansoʌ̃ mama b̶ʌd̶e pilisteorãra Juda druad̶aa zed̶aped̶a ẽjũã Lehi abada caita duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","Maʌ̃ne Judad̶ebemarãba ãdjirãa nãwã iwid̶isid̶aa: –¿Cãrẽ cãrẽã dairã ume djõne ze panʌ?– Pilisteorãba panusid̶aa: –Sansoʌ̃da jidad̶e ze panʌa dairãra biẽ́ od̶a bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","Maʌ̃ carea Judad̶ebemarãra Etam eya ʌra jira b̶ʌd̶aa tres mil wãsid̶aa. Sansoʌ̃ b̶abari uriama jũẽnaped̶a idjía nãwã jarasid̶aa: –Bʌa ¿cãrẽ cãrẽã dadjirãra nẽbʌrad̶e b̶ʌsi? ¿Adua b̶ʌca dadjirãra pilisteorã jʌwaed̶a panʌda?– Sansoʌ̃ba panusia: –Ãdjirãba mʌ̃da biẽ́ oped̶ad̶a bẽrã mʌ̃a ãdjira ara maʌ̃ quĩrãca osia.– ");
INSERT INTO empNTpo_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","Maʌ̃ne Judad̶ebemarãba jarasid̶aa: –Dairãra ze panʌa bʌra pilisteorãa jida diad̶i carea.– Maʌ̃ne Sansoʌ̃ba jarasia: –Naãrã wãrãneba jarad̶adua bãrãba mʌ̃ra bead̶aẽ́da.– ");
INSERT INTO empNTpo_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","Judad̶ebemarãba jarasid̶aa: –Bʌra bead̶aẽ́a. Ab̶abe bʌ jʌwara jʌ̃naped̶a pilisteorãa jida diad̶ia.– Ara maʌ̃da jʌ̃cara djiwid̶i uméba Sansoʌ̃ra jʌ̃naped̶a idji b̶abari uriad̶eba jida edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","Ẽjũã Lehi abadad̶e jũẽbʌdad̶e pilisteorãra b̶ʌsrid̶a b̶ʌga duanʌda idjimaa zesid̶aa. Baribʌrʌ Ãcõrẽ Jaured̶eba Sansoʌ̃ra bio juerza baraped̶a idji jʌwa jʌ̃ b̶ad̶a jʌ̃carada tʌcuasia lino nayãna bá wãna quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","Maʌ̃ne burro beud̶a quid̶atrʌda unuped̶a edasia. Maʌ̃ba pilisteorãda mil quenasia. ");
INSERT INTO empNTpo_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","Quenaped̶a nãwã jarasia: Mʌ̃a burro quid̶atrʌba ãdjira boromea bue nũmʌsia. Burro quid̶atrʌba mʌ̃a ẽberãrãda mil quenasia. ");
INSERT INTO empNTpo_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","Mãwã jaraped̶a Sansoʌ̃ba quid̶atrʌra b̶atabuesia. Mama trʌ̃ b̶ʌsid̶aa Ramat-Lehi. ");
INSERT INTO empNTpo_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","Sansoʌ̃ra bio opichia nũmʌ bẽrã Ãcõrẽa quĩrã djuburiada nãwã iwid̶isia: –Bʌa mʌ̃, bʌ nezocaa ãdjirãra poyabisia. Maʌ̃da ¿mʌ̃ra opichiaba idu beubica? ¿Opichiaba cacua norrab̶ariped̶a mʌ̃ra pilisteorã idu jidabica?– ");
INSERT INTO empNTpo_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","Maʌ̃ne Ãcõrẽba uriad̶eba baidoda ʌ̃taa bogadrʌbisia. Sansoʌ̃ba doped̶a cacua ʌb̶ʌasia. Maʌ̃ baido Lehid̶e ʌ̃taa bogadrʌ b̶ʌra trʌ̃ b̶ʌsid̶aa En-hacore. Maʌ̃ra wad̶i Lehid̶e b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","Israelerã pilisteorã jʌwaed̶a panasid̶ad̶e Sansoʌ̃ra veinte poa ãdji ẽdrʌ b̶ʌbari basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","Ewari ab̶a Sansoʌ̃ra pilisteorã puru Gazad̶aa wãsia. Mama wẽrã aud̶uada unuped̶a idji ume cãĩne wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","Maʌ̃ne Gazad̶ebemarãba cawasid̶aa Sansoʌ̃ra mama b̶ʌda. Maʌ̃ carea diamasi purura jũrã edad̶aped̶a dji purud̶e ed̶a wãbada caita mĩrũnaped̶a chupea jʌ̃ã panesid̶aa. Ãdjia nãwã crĩchasid̶aa: –Nu diaped̶a idji wãbʌrʌd̶e jidad̶aped̶a bead̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","Baribʌrʌ Sansoʌ̃ra ariquẽtrabe cãĩsia. Piradrʌped̶a dji purud̶e ed̶a wãbadada, dji jĩrũ egorod̶e jou nũmʌ sid̶a ẽũta edasia. Maʌ̃gʌra dji bacuru caru nũmʌ sid̶a jũma idji equiad̶e jira edaped̶a tʌmʌ Hebroʌ̃ puru quĩrãpe b̶ʌ eyad̶aa edesia. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","Mãwãnacarea Sansoʌ̃ba dewara wẽrãda awuasia. Maʌ̃ wẽrã Dalila abadara Sorec jewed̶ad̶e b̶abadjia. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","Ewari ab̶a pilisteorã bororãra Dalilamaa wãnaped̶a nãwã jarasid̶aa: –Daiba quĩrĩã panʌa bʌa Sansoʌ̃ra cũrũgaida jaramãrẽã idji juerzara cãrẽneba ze b̶ʌda idjab̶a sãwã idjira poyad̶ida. Mãwã idjira jʌ̃naped̶a dai jʌwaed̶a eropanania. Bʌa mãwã osira daiza bʌ́a parata torroda mil cien diad̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","Maʌ̃ carea Dalilaba Sansoʌ̃a nãwã iwid̶isia: –Mʌ̃ djuburia, jaradua bʌ juerzara ¿cãrẽneba ze b̶ʌ? ¿Bʌra sãwã jʌ̃nida panʌ poya ẽdrʌrãmãrẽã?– ");
INSERT INTO empNTpo_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","Sansoʌ̃ba sewad̶eba panusia: –Siete enedrʌma jʌ̃cara djiwid̶iba mʌ̃da jʌ̃nibʌrʌ, mʌ̃ra juerza neẽ́ b̶eya. Baridua ẽberãca b̶eya.– ");
INSERT INTO empNTpo_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","Maʌ̃ bẽrã pilisteorãba Dalilamaa enedrʌma jʌ̃cara djiwid̶ida siete edesid̶aa. Maʌ̃ba Dalilaba Sansoʌ̃ra jʌ̃sia. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","Ʌ̃cʌrʌ pilisteorãda idji ded̶e mĩrũ panʌ bẽrã Dalilaba jĩgua jarasia: –¡Sansoʌ̃, pilisteorãba bʌra jidad̶e zebʌdaa!– Ara maʌ̃da Sansoʌ̃ba jʌ̃carara tʌcuasia oveja cara nayãna bá wãna quĩrãca. Maʌ̃ bẽrã pilisteorãba wad̶ibid̶a cawad̶aẽ́ basía idji juerzara cãrẽneba ze b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","Mãwãnacarea Dalilaba Sansoʌ̃a jarasia: –¡Bʌa mʌ̃ra cũrũgasia! Bʌa sewada osia. Mʌ̃ quĩrã djuburia, wãrãda jaradua sãwã bʌra jʌ̃nida poya ẽdrʌrãmãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","Sansoʌ̃ba waya sewad̶eba jarasia: –Mʌ̃ra jʌ̃cara nayãna djiwid̶iba jʌ̃nibʌrʌ juerza neẽ́ b̶eya. Baridua ẽberãca b̶eya.– ");
INSERT INTO empNTpo_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","Ara maʌ̃da Dalilaba jʌ̃cara nayãna djiwid̶i b̶eaba Sansoʌ̃ra jʌ̃sia. Maʌ̃ne pilisteorãda idji ded̶e mĩrũ panʌ bẽrã Dalilaba jĩgua jarasia: –¡Sansoʌ̃, pilisteorãba bʌra jidad̶e zebʌdaa!– Ara maʌ̃da Sansoʌ̃ba jʌ̃cara omoa nayãnara tʌcuasia jʌ̃cara chõda quiru quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","Mãwãnacarea Dalilaba jarasia: –¡Bʌa mʌ̃ra waya cũrũgasia! Bʌra sewaid̶a b̶ʌa. Mʌ̃́a wãrãda jaradua sãwã bʌra jʌ̃nida poya ẽdrʌrãmãrẽã.– Sansoʌ̃ba waya sewad̶eba jarasia: –Mʌ̃ bud̶a cad̶a siete panʌda wua cabadad̶e wua ume ãbaa caped̶a dji bacurud̶aa bio jʌ̃ nũmʌsira mʌ̃ra juerza neẽ́ b̶eya. Mʌ̃ra baridua ẽberãca b̶eya.– Ara maʌ̃da Dalilaba Sansoʌ̃ra cãĩbisia. Maʌ̃be idji bud̶a siete cad̶ara wua cabadad̶e wua ume ãbaa casía. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","Maʌ̃be bacurud̶aa bio jʌ̃ nũmʌped̶a jĩgua jarasia: –¡Sansoʌ̃, pilisteorãba bʌra jidad̶e zebʌdaa!– Sansoʌ̃ra cãĩ b̶ad̶ada piradrʌped̶a wua cabadara dji bacuru sid̶a idji bud̶aba ẽũta edasia. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","Mãwãnacarea Dalilaba jarasia: –Bʌa mʌ̃ra quĩrĩã b̶ʌad̶a abaria. Mãwãmĩna mʌ̃́a sewa obaria. B̸arima ũbea mʌ̃ra cũrũgabʌrʌa. Wad̶ibid̶a jaraẽ́ b̶ʌa bʌ juerzara cãrẽneba ze b̶ʌda.– ");
INSERT INTO empNTpo_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","Dalilaba ewariza ara pichia iwid̶ibadjia. Mãwã mĩã sẽ b̶ʌ bẽrã Sansoʌ̃ra sẽped̶a beu quĩrĩã nũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","Maʌ̃ carea idji juerzara cãrẽneba ze b̶ʌda wãrãda jarasia: –Mʌ̃ra nazareo bẽrã mʌ̃ bud̶ara tʌd̶acaa. Mʌ̃ papa b̶ited̶aʌba mʌ̃ra Ãcõrẽ itea b̶esia. Mʌ̃ bud̶ada tʌd̶ibʌrʌ mʌ̃ra juerza neẽ́ b̶eya. Baridua ẽberãca b̶eya.– ");
INSERT INTO empNTpo_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","Dalilaba cawasia Sansoʌ̃ba jarad̶ara wãrãda. Maʌ̃ bẽrã pilisteorã bororãa nãwã jarabisia: –Wayacusa zed̶adua. Sansoʌ̃ba idji juerzad̶ebemada mʌ̃́a wãrãda jarasia.– Ara maʌ̃da pilisteorãra Dalilamaa zesid̶aa parata diad̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","Maʌ̃be Sansoʌ̃ boro idji b̶acarad̶e b̶ʌd̶e Dalilaba Sansoʌ̃ra cãĩbisia. Maʌ̃ne ab̶a trʌ̃sia Sansoʌ̃ bud̶a cad̶a siete panʌra tʌmãrẽã. Mãwã Dalilaba Sansoʌ̃ra biẽ́ osia. Juerza bara b̶ad̶ada Sansoʌ̃ra juerza neẽ́ b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","Maʌ̃be Dalilaba jĩgua jarasia: –¡Sansoʌ̃, pilisteorãba bʌra jidad̶e zebʌdaa!– Ara maʌ̃da Sansoʌ̃ra ʌ̃rʌ̃maped̶a ẽdrʌida crĩchasia naẽna ẽdrʌbari bad̶a quĩrãca. Baribʌrʌ adua b̶asia Ãcõrẽra idji ume b̶ad̶ada ãyã wãsida. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","Maʌ̃be pilisteorãba idjira jidad̶aped̶a idji daura nuẽtad̶aped̶a Gaza purud̶aa edesid̶aa. Mama bronce od̶a carena omoaba jʌ̃naped̶a preso b̶ʌsid̶aa. Maʌ̃ne trigora yud̶e b̶abibadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","Baribʌrʌ idji bud̶ara waya ureabʌrʌ basía. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","Sansoʌ̃ra preso jidaped̶ad̶a bẽrã pilisteorã bororãda dji jʌresid̶aa ãdji ãcõrẽ Dagoʌ̃a ne babue diacuad̶i carea idjab̶a b̶ʌsrid̶a od̶i carea. Mãwã o panʌne nãwã trʌ̃ãsid̶aa: Dadji ãcõrẽ Dagoʌ̃ba dadjía dji quĩrũ Sansoʌ̃ra poyabisia. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","Puruba Sansoʌ̃ unusid̶ad̶e ãdjirã bid̶a ãdji ãcõrẽ Dagoʌ̃a nãwã trʌ̃ãsid̶aa: Dadji ãcõrẽ Dagoʌ̃ba dadjía dji quĩrũ Sansoʌ̃ra poyabisia. Dadji néu ãrĩbarira, dadji ẽberãrã beabarira poyabisia. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","Ãdjirãra bio b̶ʌsrid̶a duanʌ bẽrã Sansoʌ̃ carea ipid̶a quĩrĩã panasid̶aa. Maʌ̃ bẽrã iwid̶isid̶aa Sansoʌ̃ enenamãrẽã. Ara maʌ̃da preso b̶ʌbada ded̶eba enenaped̶a idji carea bio ipid̶asid̶aa. Maʌ̃ne ãdji ãcõrẽ Dagoʌ̃ de droma de jĩrũ umé panʌ ẽsi nũmʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","Cũdraba Sansoʌ̃ra jʌwad̶e erreb̶ari edebadjia. Maʌ̃ne Sansoʌ̃ba cũdraa nãwã jarasia: –Mʌ̃ra de jĩrũ caita ededua. Maʌ̃naa chũ nũme quĩrĩã b̶ʌa.– Ara maʌ̃da cũdraba idjira de jĩrũ caita edesia. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","Maʌ̃ ded̶e pilisteorã bororãda jũma panasid̶aa. Umaquĩrãba, wẽrãrã bid̶a dera bira nũmasia. Maʌ̃ awara dejã ʌ̃tʌara b̶ʌd̶e pilisteorãra tres mil panasid̶aa. Ãdjirã bid̶a Sansoʌ̃ acʌ panʌne ipid̶a panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","Maʌ̃ne Sansoʌ̃ba Ãcõrẽa nãwã iwid̶isia: –Mʌ̃ Boro Ãcõrẽ, mʌ̃ djuburia mʌ̃a iwid̶i b̶ʌra ũrĩdua. Waya b̶arima ab̶a mʌ̃ra juerza bara b̶ʌdua mʌ̃a pilisteorã quenai carea mʌ̃ daura nuẽtaped̶ad̶a bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","30","Maʌ̃be idji jʌwaba tã jʌrʌsia dji ẽsibema de jĩrũ umé panʌda. Maʌ̃ de jĩrũba dji de borora eronũmasia. Maʌ̃ne idji jʌwaba de jĩrũra umena tãped̶a nãwã b̶iasia: –¡Mʌ̃ra pilisteorã ume beuya!– Maʌ̃be jũma idji juerzaba chãb̶aribʌrʌd̶e pilisteorã ãcõrẽ Dagoʌ̃ de dromara ãdji bororã ʌ̃rʌ̃, dewararã ʌ̃rʌ̃ bid̶a tod̶ogozoasia. Sansoʌ̃ sid̶a beusia. Mãwã idji beusi ewarid̶e Sansoʌ̃ba pilisteorãra aud̶uara quenasia idji zocai b̶asid̶e quenana cãyãbara. ");
INSERT INTO empNTpo_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","Mãwãnacarea idji djabarãba, jũma idji zeza ẽberãrã bid̶a idjira edad̶e wãsid̶aa. Maʌ̃be jẽda eded̶aped̶a tʌb̶arisid̶aa idji zeza Manoa tʌb̶ariped̶ad̶a uriad̶e Zora puru idjab̶a Estaol puru ẽsi. Sansoʌ̃ra veinte poa israelerã ẽdrʌ b̶ʌbari basía.");
INSERT INTO empNTpo_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Ẽberãda b̶asia Elcana abadada. Elcanara Jerohaʌ̃ warra basía. Jerohaʌ̃ra Elihú warra basía. Elihúra Tohu warra basía. Tohura Zup warra basía. Zup ẽberãrãra Epraiʌ̃neba yõped̶ad̶arã basía. Maʌ̃ Elcanara Ramá purud̶e Epraiʌ̃ ẽjũã eyaid̶a b̶ʌd̶e b̶abadjia. ");
INSERT INTO empNTpo_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Elcanaba quimada umé erob̶asia. Ab̶a Ana abadjid̶aa. Dewarabemara Penina abadjid̶aa. Peninaba warrarãda erob̶asia baribʌrʌ Anara warra unuca basía. ");
INSERT INTO empNTpo_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Poaza Elcanara idji purud̶eba Silod̶aa wãbadjia jũma poya b̶ʌ Ãcõrẽa bia bed̶eai carea idjab̶a animarã babue diai carea. Maʌ̃ ewarid̶e Elida, idji warrarã Opnida idjab̶a Pinéda Ãcõrẽ sacerdoterã basía. ");
INSERT INTO empNTpo_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Elcanaba Ãcõrẽa animarã draga babue diabʌrʌza nedjarada idji quima Peninaa, idji warrarãa bid̶a diabadjia. ");
INSERT INTO empNTpo_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Baribʌrʌ idji quima Anaa nedjara dji biara b̶ʌda diabadjia. Ãcõrẽba Anara warra unubicamĩna Elcanaba idjira bio quĩrĩã b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Ãcõrẽba Anara warra unubica bad̶a bẽrã Peninaba idjira baridua mĩã sẽbadjia sopua b̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Poaza Ãcõrẽ ded̶aa wãbʌdad̶e Peninaba Anara mĩã sẽbadjia. Maʌ̃ carea Anara jĩã b̶ʌba ne coca basía. ");
INSERT INTO empNTpo_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Baribʌrʌ dji quima Elcanaba jarabadjia: –Ana, ¿cãrẽ cãrẽã jĩã b̶ʌ? ¿Cãrẽã bʌra jãwã ne coẽ́ b̶abari? ¿Cãrẽã sopua b̶ʌ? ¿Bʌmaarã mʌ̃ quĩrĩãra biara b̶ʌẽ́ca die warrarã erob̶ai cãyãbara?– ");
INSERT INTO empNTpo_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","Ewari ab̶a Silod̶e ne coped̶ad̶acarea Anara piradrʌped̶a Ãcõrẽ ded̶aa wãsia. Maʌ̃ne sacerdote Elida dji ed̶a wãbada caita chũmasia. ");
INSERT INTO empNTpo_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","Mama Anara bio sopuaba jĩã b̶ʌda Ãcõrẽa bed̶ea b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Idjia wãrãneba nãwã jarasia: –Ne jũma poya b̶ʌ Ãcõrẽ, mʌ̃ sopua carea bʌa mʌ̃da quĩrã djuburiaibʌrʌ mʌ̃́a warrada diadua. Mãwã diasira mʌ̃a maʌ̃ warrara bʌ́a diaya idji zocai b̶ʌmisa bʌa quĩrĩã b̶ʌda o b̶amãrẽã. Maʌ̃ne idji bud̶ara tʌca baya.– ");
INSERT INTO empNTpo_vpl VALUES ("S11_12","010_1_12","1SA","1","12","13","Anara dãrã Ãcõrẽa bed̶ea djuburiasia. Chupea bed̶ea b̶asia, jĩgua bed̶eaẽ́ b̶asia. Maʌ̃ne Eliba idji i doudowa b̶ʌda unu b̶asia. Baribʌrʌ idjia bed̶ea b̶ʌra ũrĩẽ́ bẽrã Eliba crĩchasia idjira beu chũmʌda. ");
INSERT INTO empNTpo_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","Maʌ̃ bẽrã Eliba jarasia: –¿Ab̶a sãʌ̃be bʌra jãwã beu chũmai? ¡Waa itua dorãdua!– ");
INSERT INTO empNTpo_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Anaba jarasia: –Mʌ̃ra beu b̶ʌẽ́a. Uva b̶a aseada, ni dewara itua sid̶a doẽ́ b̶ʌa. Ãtebʌrʌ bio sopua b̶ʌ bẽrã sod̶eba Ãcõrẽa quĩrã djuburiada iwid̶i b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Crĩcharãdua mʌ̃ra wẽrã cadjiruada. Bio sopua b̶ʌ bẽrã Ãcõrẽa mãwã iwid̶i b̶asia.– ");
INSERT INTO empNTpo_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Maʌ̃ne Eliba jarasia: –Mãẽteara necai wãdua. Mʌ̃a quĩrĩã b̶ʌa dadji israelerã Ãcõrẽba bʌa iwid̶id̶ara diaida.– ");
INSERT INTO empNTpo_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Anaba jarasia: –Bia b̶ʌa.– Mãwãped̶a Anara jẽda idji ẽberãrã panʌmaa wãsia. Jũẽped̶a ne cosia. Waa sopuaẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Nurẽma diaped̶ed̶a Ãcõrẽa bia bed̶ead̶aped̶a Ramánaa ãdji ded̶aa wãsid̶aa. Elcanara idji quima Ana ume cãĩsia. Maʌ̃ne Ãcõrẽba Anara carebasia. ");
INSERT INTO empNTpo_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Mãwã Anara b̶iogoa b̶esia. Idji warra toi ewari jũẽsid̶e umaquĩrã warrada tosia. Maʌ̃ne jarasia: “Mʌ̃a Ãcõrẽa idjida iwid̶isia.” Mãwã dji warrara trʌ̃ b̶ʌsia Samuel. ");
INSERT INTO empNTpo_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Mãwãnacarea Elcanaba poaza obari quĩrãca jũma idji ẽberãrã ume Silod̶aa wãsia Ãcõrẽa animarã babue diai carea idjab̶a Ãcõrẽa diayad̶a ad̶ara jũma diai carea. ");
INSERT INTO empNTpo_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Baribʌrʌ Anara wãẽ́ basía. Idji quimaa nãwã jarasia: –Mʌ̃ra wãẽ́a ab̶a mʌ̃ warra ju amabʌrʌd̶aa. Ju amasira mʌ̃a idjira Ãcõrẽ quĩrãpita b̶ʌd̶e wãya. Maʌ̃be idjira mama b̶eya.– ");
INSERT INTO empNTpo_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Maʌ̃ carea dji quima Elcanaba jarasia: –Bʌa o quĩrĩã b̶ʌ quĩrãca odua. B̸edua ab̶a bʌ warra ju amabʌrʌd̶aa. Ãcõrẽba bʌra carebaya bʌa oi jarad̶ara omãrẽã.– Maʌ̃ bẽrã Anara wãẽ́ basía ab̶a dji warra ju amabʌrʌd̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Warra ju amanacarea wad̶i caibe quirud̶e Anaba idjira Silod̶e Ãcõrẽ ded̶aa edesia. Maʌ̃ne paca zaque poa ũbea b̶ʌda, harinada veintidos libra, idjab̶a animarã e od̶ad̶e uva b̶ada tʌ edesia. ");
INSERT INTO empNTpo_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Paca zaque Ãcõrẽa babue diad̶aped̶a dji warra zaquera Elimaa edesia. ");
INSERT INTO empNTpo_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Maʌ̃ne Anaba Elia jarasia: –Mʌ̃ boro, ¿bʌa quĩrãneba b̶ʌca wẽrã nama bʌ caita Ãcõrẽa bed̶ea b̶ad̶ara? Wãrãneba jaraya: mʌ̃ra maʌ̃ wẽrãa. ");
INSERT INTO empNTpo_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Mʌ̃a Ãcõrẽa warrada iwid̶i b̶asia. Maʌ̃be mʌ̃a iwid̶id̶a quĩrãca idjia naʌ̃ warrada mʌ̃́a diasia. ");
INSERT INTO empNTpo_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Maʌ̃ carea mʌ̃ warrada Ãcõrẽa diad̶e ze b̶ʌa. Idji zocai b̶ʌmisa Ãcõrẽ itea b̶aya.– Maʌ̃ne Ãcõrẽa bia bed̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Maʌ̃be Anaba Ãcõrẽa nãwã bed̶easia: Ãcõrẽ, bʌ carea mʌ̃ra sod̶eba wãrãda b̶ʌsrid̶a b̶ʌa. Bʌabʌrʌ mʌ̃́a ʌb̶ʌada dia b̶ʌa. Mʌ̃ dji quĩrũ quĩrãpita ipid̶aya bʌa mʌ̃ra ẽdrʌ b̶ʌd̶a bẽrã. Wãrãda mʌ̃ra bio b̶ʌsrid̶a b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","Ãcõrẽ, ni ab̶aʌda bʌ quĩrãca neẽ́a. Dai Ãcõrẽ, ni ab̶aʌba daira poya wagacaa bʌa wagabari quĩrãca. Dewara ãcõrẽda bʌ quĩrãca neẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","Ãcõrẽba ne jũmada cawa b̶ʌa. Idjiabʌrʌ dadjia o panʌra cawa obaria. Maʌ̃ bẽrã ni ab̶aʌda dji droma quĩrãca bed̶eaiẽ́ b̶ʌa. Ni maãrĩ bid̶a mãwã bed̶eaiẽ́ b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","Idjiabʌrʌ ẽberã mẽsrã b̶eara poyabaria baribʌrʌ dji ʌb̶ʌaẽ́ qued̶eaa ʌb̶ʌada diabaria. ");
INSERT INTO empNTpo_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Ne bara b̶ead̶ara id̶ira ne cod̶i carea djãrã itea traja panʌa, baribʌrʌ ne neẽ́ b̶ead̶aba id̶ira ad̶uba eropanʌa. Wẽrã warra toca bad̶aba warrarãda siete tosia. Baribʌrʌ warra zocãrã tod̶aba waa warra toẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","Ãcõrẽbʌrʌ zocai b̶aira, beui sid̶a diabaria. Idjia ẽberãra beud̶arã panabadama b̶ʌbaria idjab̶a ʌ̃rẽbabibaria. ");
INSERT INTO empNTpo_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","Ãcõrẽbʌrʌ ne neẽ́ b̶eada, ne bara b̶ea sid̶a b̶ʌbaria. Dji droma b̶eara ed̶aara b̶ʌbaria idjab̶a dji ed̶aara b̶eada dji dromada b̶ʌbaria. ");
INSERT INTO empNTpo_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Ãcõrẽba naʌ̃ ẽjũãra od̶a bẽrã idjidrʌ djibaria. Idjid̶eba ne jũmada b̶ʌa. Maʌ̃ bẽrã ne neẽ́ quirura dji dromada poya b̶ʌya. Ne b̶atabuebadama b̶abarira dji bororã ded̶e dji dromada poya b̶ʌya. ");
INSERT INTO empNTpo_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Ãcõrẽba idji ĩjã b̶eara wagabaria baribʌrʌ dji cadjiruarãda beud̶arã panabadama pãĩmane b̶ʌbaria. Ni ab̶aʌba ara idji ʌb̶ʌad̶eba poyacaa. ");
INSERT INTO empNTpo_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Ãcõrẽba idji dji quĩrũra jũma poyaya. Bajãneba baa b̶aebʌrʌ quĩrãca ãdjirãra bio cawa oya. Ãcõrẽba jũma naʌ̃ ẽjũãne b̶eara cawa oya. Idjia b̶ʌd̶a boroa ʌb̶ʌada diaya. Idjia edad̶a borora dji dromaara b̶ʌya. ");
INSERT INTO empNTpo_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Mãwãnacarea Elcanara Ramá purud̶aa jẽda wãsia. Baribʌrʌ idji warra zaquera sacerdote Eli ume b̶esia Ãcõrẽ ded̶e carebamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","Eli warrarãra dji cadjiruarã basía. Ãcõrẽda wayad̶aca basía. ");
INSERT INTO empNTpo_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","Sacerdoterãba od̶ida panʌ quĩrãca od̶aca basía. Ãtebʌrʌ nãwã obadjid̶aa: ab̶aʌba Ãcõrẽa animarã dragada babue diabiped̶a dji djara dju b̶ʌd̶e sacerdote nezocaba mĩãsu quid̶a ũbea erob̶ʌra enebadjia. ");
INSERT INTO empNTpo_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","Maʌ̃ba nedjara dju nũmʌra suped̶a idjia jira edad̶ara edebadjia sacerdoteba comãrẽã. Israelerãba Silod̶e Ãcõrẽa animarã draga babue diabʌdaza mãwã obadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","Maʌ̃ awara dji draga babue diai naẽna sacerdote nezocara zeped̶a dji draga babue diabi b̶ʌ́a nãwã jarabadjia: –Ne djarara diadua sacerdoteba bá comãrẽã. Idjia nedjara djud̶ada quĩrĩãẽ́a, ãtebʌrʌ dji õgoada quĩrĩã b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","Maʌ̃ne ẽberãba dji dragada naãrã babue diad̶ida panʌana aibʌrʌ, dji nezocaba panubadjia: –Mãwãẽ́a. Ara nawena diadua. Mãwãẽ́bʌrʌ mʌ̃a jãrĩ edaya.– ");
INSERT INTO empNTpo_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","Mãwã Eli warrarãba cadjirua o panʌra Ãcõrẽ quĩrãpita bio biẽ́ b̶asia. Israelerãba animarã Ãcõrẽa babue diabadara ãdjia siriẽ́ unubadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","Mãwã panʌne Samuelba Ãcõrẽ ded̶e careba b̶abadjia. Idjia sacerdote djio lino wua od̶ara jʌ̃badjia. ");
INSERT INTO empNTpo_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Poaza dji papaba idjia cacuad̶e jʌ̃mãrẽã obadjia. Maʌ̃ra diad̶e wãbadjia dji quima ume poaza animarã babue diad̶e wãbʌdad̶e. ");
INSERT INTO empNTpo_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Maʌ̃ne Eliba Elcanara dji quima sid̶a nãwã bia jara b̶ʌbadjia: –Elcana, Ãcõrẽba bʌ́a dewara warrarãda bʌ quima Ana ume unubiya idjia warra naãrã iwid̶id̶ada Ãcõrẽa diad̶a bẽrã.– Mãwãnacarea Elcanara idji quima ume jẽda diguid̶aa wãbadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Maʌ̃be Ãcõrẽba Anara carebabadjia. Mãwã Anaba umaquĩrã warrada ũbea idjab̶a wẽrãcaurãda umé tosia. Maʌ̃misa Samuelera Ãcõrẽ quĩrãpita b̶ʌda warisia. ");
INSERT INTO empNTpo_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","Maʌ̃ ewarid̶e Elira bio drõãda b̶asia. Idjia ũrĩsia idji warrarãba israelerãra biẽ́ o panʌda. Maʌ̃ awara ũrĩsia ãdjirãra wẽrãrã Ãcõrẽ wua ded̶e ed̶a wãbadama ne obadarã ume mĩã comʌa panabadada. ");
INSERT INTO empNTpo_vpl VALUES ("S12_23","010_2_23","1SA","2","23","24","Maʌ̃ carea idji warrarãa nãwã jarasia: –Mʌ̃ warrarã, bãrãba cadjirua o panʌra jũmarãba jara panʌa. Wãrãda Ãcõrẽ puruba jara b̶ʌra bio cadjirua b̶ʌa. ¿Cãrẽ cãrẽã mãwã o panʌ? ");
INSERT INTO empNTpo_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","Ab̶aʌba djãrãda biẽ́ oibʌrʌ, Ãcõrẽba maʌ̃ ẽberãra poya carebaya dewarabema ume bia b̶emãrẽã. Baribʌrʌ ab̶aʌba Ãcõrẽda biẽ́ oibʌrʌ ¿caiba idjira carebai?– Mãwãmĩna Eli warrarãba ãdji zezaba jarad̶ara ĩjãnaẽ́ basía. Ãcõrẽba ãdjira mãwã erob̶asia beud̶ida quĩrĩãna bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","Maʌ̃misa Samuelera wari b̶asia. Ãcõrẽba, ẽberãrã bid̶a idjira bia unusid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","Maʌ̃ ewarid̶e Ãcõrẽneba bed̶eabarida ab̶a Elimaa zeped̶a nãwã jarasia: –Ãcõrẽba nãwã jara b̶ʌa: “Bãrã drõã naẽnabemarã Egiptod̶ebema boro jʌwaed̶a panasid̶ad̶e mʌ̃a ãdjirãa ara mʌ̃nebemada ebud̶a cawabisia. ");
INSERT INTO empNTpo_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","Maʌ̃ne mʌ̃a jũma israelerãnebemada Aaroʌ̃drʌ idjab̶a bãrã, idjid̶eba yõbʌdarã sid̶a edasia mʌ̃ sacerdoterãda b̶ead̶amãrẽã. Mãwã bãrãba animarãda mʌ̃́a babue diabadaa, incienso querada bá diabadaa, idjab̶a mʌ̃ quĩrãpita sacerdote djiora jʌ̃badaa. Maʌ̃ awara mʌ̃a bãrã drõã naẽnabemarãa jarasia israelerãba animarã draga mʌ̃́a babue diabʌdad̶e bãrã sacerdoterãba dji djarad̶ebemada edad̶ida panʌda cod̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","¿Bãrãba cãrẽ cãrẽã mʌ̃a animarã babue diabi jarad̶ara, dewara diabi jarad̶a sid̶a siriẽ́ unubada? ¿Cãrẽ cãrẽã bʌ warrarãra mʌ̃ cãyãbara biara quĩrĩã b̶ʌ? Mʌ̃ puru israelerãba animarã draga babue diabʌdad̶e dji biara b̶ʌ nedjara co panʌneba bʌ warrarãra boreguea panʌa.” ");
INSERT INTO empNTpo_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","Dadji israelerã Ãcõrẽba naẽna jarasia bʌ ded̶ebemarãra, jũma bʌ ẽberãrã sid̶a ewariza idji sacerdoterãda b̶ead̶ida. Baribʌrʌ id̶ira nãwã jara b̶ʌa: “Mʌ̃a bãrãra waa mʌ̃ sacerdoterã idu babiẽ́a. Ãtebʌrʌ mʌ̃ bia jara panʌda mʌ̃a bia b̶ʌya idjab̶a mʌ̃ igara panʌra mʌ̃a biẽ́ b̶ʌya. ");
INSERT INTO empNTpo_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","Mʌ̃a bãrã cawa oi ewarira jũẽbʌrʌa. Maʌ̃ne bʌ ded̶ebema drõãẽ́ b̶eara, bʌ ẽberãrã drõãẽ́ b̶ea sid̶a mʌ̃a jũma quinibiya. Ni ab̶aʌda waraga beud̶aẽ́a. ");
INSERT INTO empNTpo_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","Maʌ̃ ewarid̶e mʌ̃a israelerãra bia o b̶aya baribʌrʌ bʌ ẽberãrãnebema ni ab̶aʌda waraga beud̶aẽ́a. Maʌ̃ bẽrã ewariza bãrãra sobiẽ́ panania idjab̶a sopua panania. ");
INSERT INTO empNTpo_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","Mʌ̃a bʌ ẽberãrãnebemada ab̶a idu sacerdote babiya. Mãwãmĩna idjira sobiẽ́ b̶aya idjab̶a sopua b̶aya. Maʌ̃ne waabema bʌd̶eba yõbʌdarãra drõã b̶ad̶aẽ́ne beud̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","Naʌ̃gʌba cawabiya mʌ̃a jarad̶ara wãrãda mãwãida: bʌ warrarã Opnira, Piné sid̶a ab̶ari ewarid̶e beud̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","Mãwãnacarea mʌ̃a dewarada b̶ʌya mʌ̃ sacerdote bamãrẽã. Mʌ̃a quĩrĩã b̶ʌ quĩrãca idjia jũma arid̶e o b̶aya. Idjid̶eba yõbʌdarãda mʌ̃a b̶ʌya ewariza mʌ̃ sacerdoterãda b̶ead̶amãrẽã. Mʌ̃a israelerã boro b̶ʌi ewarid̶eba ʌ̃taa ãdjira ewariza mãwã b̶ead̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","Maʌ̃ ewarid̶e bʌ ẽberãrãnebema wad̶i zocai b̶eara ãdji quĩrãpita zed̶aped̶a quĩrã djuburiada iwid̶id̶ia paratada, cod̶i sid̶a maãrĩ diad̶amãrẽã. Maʌ̃ awara ne cod̶i carea iwid̶id̶ia sacerdoterã nezocarãda b̶ʌd̶amãrẽã.”– ");
INSERT INTO empNTpo_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Cũdra Samuelba Ãcõrẽ quĩrãpita Elira carebabadjia. Maʌ̃ ewarid̶e Ãcõrẽra ẽberãrã ume ara cadrʌa bed̶eaca basía. Mãcua cãĩmocara quĩrãca ne unubica basía. ");
INSERT INTO empNTpo_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Elira dau towa b̶ʌ bẽrã bia unuca basía. Ewari ab̶a idji cʌd̶ad̶e cãĩ b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Maʌ̃ne Samuelera Ãcõrẽ wua ded̶e cãĩ b̶asia. Mama Ãcõrẽ baurudeda b̶asia idjab̶a ĩbĩrãra wad̶i urua nũmasia. ");
INSERT INTO empNTpo_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","Mãwã b̶ʌd̶e Ãcõrẽba Samuelera trʌ̃ jarasia: –¡Samuel!– Samuelba panusia: –Nama b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Ara maʌ̃da Eli cãĩ b̶ʌmaa pira wãped̶a nãwã jarasia: –Nama b̶ʌa. ¿Cãrẽ cãrẽã trʌ̃ b̶ʌ?– Eliba panusia: –Bʌra trʌ̃ẽ́ b̶ʌa. Cãĩne wãdua.– Samuelera jẽda wãped̶a idji cʌd̶ad̶e tab̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Maʌ̃ne Ãcõrẽba idjira waya trʌ̃ jarasia: –¡Samuel!– Ara maʌ̃da Samuelera piradrʌped̶a Eli b̶ʌmaa wãsia. Maʌ̃ne jarasia: –Nama b̶ʌa. ¿Cãrẽ cãrẽã trʌ̃ b̶ʌ?– Eliba panusia: –Warra, bʌra trʌ̃ẽ́ b̶ʌa. Cãĩne wãdua.– ");
INSERT INTO empNTpo_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Samuelba Ãcõrẽ sãwã bed̶eabarida adua b̶asia Ãcõrẽra wad̶i idji ume bed̶eaca bad̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Maʌ̃be Ãcõrẽba waya Samuelera trʌ̃ jarasia. Ara maʌ̃da Samuelera piradrʌped̶a Elimaa wãsia. Maʌ̃ne jarasia: –¿Cãrẽ cãrẽã trʌ̃ b̶ʌ?– Maʌ̃nebʌrʌ Eliba cawasia Ãcõrẽbʌrʌ Samuelera trʌ̃ jara b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Maʌ̃ bẽrã idjia Samuelea jarasia: –Cãĩne wãdua. Baribʌrʌ Ãcõrẽba bʌra waya trʌ̃ jaraibʌrʌ idjía nãwã panudua: “Bed̶eadua mʌ̃ Boro, mʌ̃a ũrĩ b̶ʌa.”– Maʌ̃ bẽrã Samuelera jẽda wãped̶a idji cʌd̶ad̶e tab̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Maʌ̃ne Ãcõrẽra wayacusa zeped̶a Samuelera trʌ̃ jarasia naẽna od̶a quĩrãca: –¡Samuel! ¡Samuel!– Samuelba panusia: –Bed̶eadua mʌ̃ Boro, mʌ̃a ũrĩ b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Ãcõrẽba jarasia: –Dãrãẽ́ne mʌ̃a bãrã israelerãra ʌ̃cʌrʌ bio cawa oya. Maʌ̃ ũrĩbʌdara bio dauperad̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Maʌ̃ ewarid̶e mʌ̃a Eli, idji ẽberãrã sid̶a cawa oi jarad̶ara jũma oya. ");
INSERT INTO empNTpo_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Idji warrarãba mʌ̃ quĩrãpita cadjirua obadara bio cawa b̶ʌmĩna idu obi b̶ʌa. Maʌ̃ carea mʌ̃a jarasia idji ẽberãrãra ewariza cawa o b̶aida. ");
INSERT INTO empNTpo_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Mʌ̃a wãrãneba Eli ẽberãrãa jarasia ãdjia cadjirua obadara ni maãrĩ bid̶a quĩrãdoaẽ́da. Animarãra mʌ̃́a babue diacuabʌda sid̶a wad̶ibid̶a mʌ̃a quĩrãdoaẽ́a. Ne diabʌda sid̶a mʌ̃a quĩrãdoaẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Ãcõrẽ bed̶ead̶acarea Samuelera idji cʌd̶ad̶e cãĩ b̶esia. Diaped̶a ʌ̃rʌ̃maped̶a Ãcõrẽ ded̶e ed̶a wãbadara ewa nũmʌsia. Baribʌrʌ Samuelba cãĩmocara quĩrãca ũrĩnada Elia jara quĩrĩãẽ́ basía. Waya b̶asia mãwã jaraida. ");
INSERT INTO empNTpo_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Baribʌrʌ Eliba Samuelera trʌ̃sia: –¡Warra, Samuel!– Samuelba panusia: –Nama b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Maʌ̃ne Eliba iwid̶isia: –¿Ãcõrẽba bʌ́a cãrẽda jarasi? Idjia jarad̶ara ni maãrĩ bid̶a mẽrãrãdua. ¡Ãcõrẽba bʌra bio cawa oya idjia jarad̶ada mʌ̃́a jũma jaraẽ́bʌrʌ!– ");
INSERT INTO empNTpo_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Maʌ̃ carea Samuelba Elia jũma jarasia. Ni maãrĩ bid̶a mẽrãẽ́ basía. Maʌ̃ne Eliba sopuaba nãwã jarasia: –Idjidrʌ Ãcõrẽ bẽrã idjia quĩrĩã b̶ʌ quĩrãca oida b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Samuel waribʌrʌd̶e Ãcõrẽra idji ume b̶asia. Idjia Samueld̶eba jarad̶ara jũma obadjia. ");
INSERT INTO empNTpo_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Maʌ̃ bẽrã jũma israelerãba Daʌ̃ eyad̶eba ab̶a Beersebá jewed̶ad̶aa cawasid̶aa Samuelera wãrãda Ãcõrẽneba bed̶eabarida. ");
INSERT INTO empNTpo_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Maʌ̃ ewarid̶e Ãcõrẽra Silod̶e Samuelma odjaped̶a idji bed̶eara cawabibadjia. ");
INSERT INTO empNTpo_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","Maʌ̃ra Samuelba jũma israelerãa jarabadjia. Maʌ̃ ewarid̶e pilisteorãra israelerã ume djõni carea Apec purud̶e ãbaa dji jʌresid̶aa. Maʌ̃ bẽrã israelerãra ãdjirãmaa djõne wãnaped̶a Ebenezer caita duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","Djõsid̶ad̶e pilisteorãba israelerãra mil quĩmãrẽ quenanaped̶a poyasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","Israeld̶ebema sordaorã jẽda zebʌda unusid̶ad̶e dji bororãba ãdjiza iwid̶isid̶aa: –¿Cãrẽ cãrẽã id̶i Ãcõrẽba pilisteorãa idu poyabisi? Ãcõrẽ baurudera Silod̶e edad̶e wãna dadjirã tãẽna b̶amãrẽã. Mãwã Ãcõrẽba dadjirãra dji quĩrũ jʌwaed̶abemada ẽdrʌ b̶ʌya.– ");
INSERT INTO empNTpo_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","Maʌ̃ carea sordaorãba ʌ̃cʌrʌ Silod̶aa diabuesid̶aa Ãcõrẽ baurude enenamãrẽã. Maʌ̃ baurude ʌ̃rʌ̃ Ãcõrẽ jũma poya b̶ʌra bajãnebema nezocarã zaca i bara panʌ ẽsi b̶abadjia. Eli warrarã Opnira, Piné sid̶a Ãcõrẽ baurude enebʌdarã ume zesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","Ãcõrẽ baurude israelerã sordaorã duanʌma jũẽbisid̶ad̶e jũmarãda b̶ʌsrid̶a jĩgua b̶iasid̶aa. Maʌ̃ba egorora uresia. ");
INSERT INTO empNTpo_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","Maʌ̃ b̶ʌga duanʌra pilisteorãba ũrĩnaped̶a ãdjiza iwid̶isid̶aa: –¿Cãrẽ cãrẽã hebreorãra jãcua b̶ʌga duanʌ?– Maʌ̃ne cawasid̶aa Ãcõrẽ baurudera israelerã duanʌmaa enesid̶ada. ");
INSERT INTO empNTpo_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","Maʌ̃ carea bio ne waya panʌneba jarasid̶aa: –¡Ãdji Ãcõrẽra ãdjirã duanʌma jũẽsia! ¡Ay, dadjirãra mĩã djuburi panʌa! Wad̶ibid̶a ni ab̶aʌba ãdji ãcõrẽra dadjirã ume djõne enenaca basía. ");
INSERT INTO empNTpo_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","¡Ay, dadjirãra mĩã djuburi panʌa! ¿Caiba dadjirãra jãʌ̃ ãcõrẽ ʌb̶ʌa b̶ea jʌwaed̶abemada ẽdrʌ b̶ʌi? Ara maʌ̃ ãcõrẽ b̶eaba egiptorãra ẽjũã põãsa ewaraga b̶ʌd̶e ne quĩrãtanoaneba quinibisid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","Maʌ̃ carea ¡dadjirãra sozarra b̶ead̶adrʌ! ¡Mẽsrã djõnadrʌ hebreorã jʌwaed̶a b̶aed̶a amaaba, ãdjirãra dadjirã jʌwaed̶a panana quĩrãca!– ");
INSERT INTO empNTpo_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","Maʌ̃be pilisteorãra waya djõne wãnaped̶a israelerãra poyasid̶aa. Mãwã poyabʌda carea israelerãra ãdji ded̶aa mĩrũ wãbʌrʌsid̶aa. Pilisteorãba zocãrã quenasid̶aa. Israeld̶ebema sordaorã jĩrũba djõne wãbadara treinta mil quenasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","Maʌ̃be pilisteorãba Ãcõrẽ baurudera edasid̶aa. Maʌ̃ awara Eli warrarã Opnira, Piné sid̶a beasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","Benjamiʌ̃neba yõnada ab̶a ãdji djõ duanʌmaʌba pira wãped̶a ab̶ari ewarid̶e Silod̶e jũẽne wãsia. Sopuaba idjia cacuad̶e jʌ̃ b̶ʌra jũma cõãcuaped̶a egoro sid̶a idji boro ʌ̃rʌ̃ cua erob̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("S14_13","010_4_13","1SA","4","13","15","Maʌ̃ne Elira idji bugued̶e óare chũmasia quĩrãcuita b̶ai carea. Idjira 98 poa b̶ʌ bẽrã dau towa b̶asia. Baribʌrʌ Ãcõrẽ baurude carea jũmawãyã crĩcha b̶ʌ bẽrã mãwã quĩrãcuita b̶asia. Maʌ̃ne dji ẽberã mĩrũ wãnara purud̶e jũẽped̶a israelerã sordaorã sãwãped̶ad̶ada jũma nẽbʌrʌsia. Maʌ̃ ũrĩnaped̶a sopuaba purura b̶ʌga duanesia. Mãwã b̶ʌga duanʌ ũrĩbʌrʌd̶e Eliba iwid̶isia: –¿Cãrẽ cãrẽã ẽberãrãra jãcua b̶ʌga duanʌ?– Maʌ̃ne dji ẽberã mĩrũ wãnaba israelerã sordaorã sãwãped̶ad̶ada Elia jarad̶e wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","Idjia Elia nãwã jarasia: –Dadji israelerã djõ duanʌmaʌba mʌ̃ra mĩrũ zesia.– Eliba iwid̶isia: –Warra ¿sãwãsi?– ");
INSERT INTO empNTpo_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","Dji jarad̶e zed̶a ẽberãba nãwã panusia: –Pilisteorãba poyabʌda carea dadji israelerãra mĩrũsid̶aa. Ãdjirãba zocãrã quenasid̶aa. Bʌ warrarã Opnira, Piné sid̶a beasid̶aa. Maʌ̃ awara Ãcõrẽ baurudera pilisteorãba edasid̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","Ãcõrẽ bauruded̶ebema ũrĩbʌrʌd̶e Elira purud̶e ed̶a wãbada orrocawa jẽdaa b̶aesia. Idjira drõãda b̶ʌ bẽrã idjab̶a bio boreguea b̶ʌ bẽrã, b̶aebʌrʌd̶e idji ʌ̃rʌ̃mʌsira b̶ʌaped̶a beusia. Elira cuarenta poa israelerã ẽdrʌ b̶ʌbari basía. ");
INSERT INTO empNTpo_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","Maʌ̃ ewarid̶e Eli ãĩguda b̶iogoa b̶asia, warra toi carea b̶asia. Idjira Piné quima basía. Maʌ̃ne idjia ũrĩsia pilisteorãba Ãcõrẽ baurudera edasid̶ada, idji quimara beasid̶ada, idjab̶a dji zãwãrẽ sid̶a jaid̶asida. Maʌ̃ ũrĩbʌrʌba cawaẽ́ne warra puaped̶a tosia. Baribʌrʌ warra puara droaẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","Beubʌrʌd̶e idji carebabʌda wẽrãrãba idjía nãwã jarasid̶aa: –Necai b̶adua. Bʌa umaquĩrã warrada tosia.– Mãwã jaraped̶ad̶amĩna idjira quĩrã cawaẽ́ nũmʌ bẽrã ni cãrẽ sid̶a panuẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("S14_21","010_4_21","1SA","4","21","22","Ãtebʌrʌ nãwã jarasia: –Ãcõrẽra dadji israelerã tãẽna b̶ad̶ada neẽ́a, idji baurudera dewaraba edaped̶ad̶a bẽrã.– Mãwã jarasia idji zãwãrẽ Elida, dji quima Piné sid̶a beuped̶ad̶a bẽrã idjab̶a Ãcõrẽ baurudera dewaraba edaped̶ad̶a bẽrã. Ãcõrẽra dadji israelerã tãẽna b̶ad̶ada neẽ́ana ad̶a bẽrã idji warrara trʌ̃ b̶ʌsia Icabod.– ");
INSERT INTO empNTpo_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","Pilisteorãba Ãcõrẽ baurudera Ebenezerd̶eba ãdji puru Asdod̶aa edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","Maʌ̃be ãdji ãcõrẽ Dagoʌ̃ ded̶e eded̶aped̶a idji caita cob̶ʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","Nurẽma diaped̶ed̶a Asdod̶ebemarã Dagoʌ̃ ded̶e ed̶aa wãbʌdad̶e ãdji jʌwaba od̶a ãcõrẽ Dagoʌ̃ra egode b̶arru tab̶ʌda unusid̶aa Ãcõrẽ baurude quĩrãpita. Maʌ̃da idji b̶abarima ãdjia waya ʌ̃ta nũmʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","Nurẽma diaped̶a Dagoʌ̃ ded̶aa wãbʌdad̶e wayacusa unusid̶aa Dagoʌ̃ra Ãcõrẽ baurude quĩrãpita egode b̶arru tab̶ʌda. Dji borora jʌwa sid̶a umena ded̶e ed̶a wãbadama b̶ʌá tapanasid̶aa. Dji cacua awa tab̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","Maʌ̃ ewarid̶eba ʌ̃taa Dagoʌ̃ sacerdoterãda, dewara ẽberãrã sid̶a Dagoʌ̃ ded̶e ed̶a wãbʌdad̶e dji boro, jʌwa sid̶a tapananama jed̶adʌgabadaa. ");
INSERT INTO empNTpo_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","Maʌ̃ ewarid̶e Ãcõrẽba Asdo purura, maʌ̃ puru caita b̶ea sid̶a bio biẽ́ b̶ʌsia. Ãdji cacuad̶e zarega odjacuabisia. ");
INSERT INTO empNTpo_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","Maʌ̃ carea ãdjirãba nãwã jarasid̶aa: –Israelerã Ãcõrẽ baurudera dadjirã tãẽna eropananiẽ́ panʌa. Idjia dadjirãda, Dagoʌ̃ sid̶a bio biẽ́ o b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","Maʌ̃ carea pilisteorãba jũma dji bororãra trʌ̃bid̶aped̶a nãwã iwid̶isid̶aa: –Israelerã Ãcõrẽ baurudera ¿sãwã od̶i?– Dji bororãba panusid̶aa: –Gat purud̶aa eded̶adua.– Ara maʌ̃da Gat purud̶aa edesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","Edeped̶ad̶acarea Ãcõrẽba maʌ̃ puru sid̶a biẽ́ b̶ʌsia. Jũmarã cacuad̶e zarega odjacuabisia. Drõãrãda warrarã sid̶a mãwã osia. Maʌ̃ba purura bio ne wayasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","Maʌ̃ bẽrã pilisteorãba Ãcõrẽ baurudera Ecroʌ̃ purud̶aa edesid̶aa. Baribʌrʌ jũẽbʌdad̶e maʌ̃ purud̶ebemarãba Ãcõrẽ baurudera ununaped̶a nãwã b̶ia jarasid̶aa: –¡Israelerã Ãcõrẽ baurudera dadjirã quenani carea namaa enebʌdaa!– ");
INSERT INTO empNTpo_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","Ãcõrẽba maʌ̃ purura bio biẽ́ b̶ʌd̶a bẽrã zocãrã quinibʌda basía. Maʌ̃ba purura bio ne wayasia. Pilisteorãba ãdji bororãa wayacusa trʌ̃bid̶aped̶a nãwã jarasid̶aa: –Israelerã Ãcõrẽ baurudera ãdjirãmaa jẽda eded̶adua. Mãwã od̶aẽ́bʌrʌ dadjirãra jũma quenaya.– ");
INSERT INTO empNTpo_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","Jũma dji zocai b̶ea cacuad̶e zarega odjacuad̶a bẽrã ãdji ãcõrẽ b̶eaa quĩrã djuburiada iwid̶i duanasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","Pilisteorãba Ãcõrẽ baurudera ãdji druad̶e siete jed̶eco eropanasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","Maʌ̃be Dagoʌ̃ sacerdoterãda, dau ẽsã unubadarã sid̶a ãbaa trʌ̃cuad̶aped̶a iwid̶isid̶aa: –¿Ãcõrẽ baurudera sãwã od̶i? Daia jarad̶adua sãwã waya idji b̶ad̶amaa diabued̶ida.– ");
INSERT INTO empNTpo_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","Ãdjirãba panusid̶aa: –Bãrãba israelerã Ãcõrẽ baurudera jẽda diabued̶ibʌrʌ ara jãwã diabuerãnadua. Ãtebʌrʌ Ãcõrẽa ne diabued̶ida panʌa bãrãba idji baurude nama eropanana carea. Mãwãbʌrʌ bãrãba cawad̶ia cãrẽ cãrẽã Ãcõrẽba bãrãra bio biẽ́ o b̶ʌda. Maʌ̃ awara cacua biacuad̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("S16_4","010_6_4","1SA","6","4","5","Pilisteorãba iwid̶isid̶aa: –Mãẽteara ¿cãrẽda idjía diabued̶i?– Ãdjirãba panusid̶aa: –Bãrã bororãra juesuma panʌ bẽrã nãwã od̶ida panʌa: oroda edad̶aped̶a bãrã cacuad̶e zarega odjacuad̶a quĩrãca juesuma od̶adua. Maʌ̃ awara dadji drua ãrĩ b̶ʌ churi quĩrãca juesuma od̶adua. Maʌ̃gʌra israelerã Ãcõrẽa diabued̶adua bãrãra, bãrã bororã sid̶a bia mĩga panʌ bẽrã. Mãwã bãrãba unubid̶ia idjida waya panʌda. Ãĩbẽrã idjia dadjirãra, dadji ãcõrẽ b̶eada, idjab̶a dadji ẽjũã sid̶a waa biẽ́ oẽ́sicada. ");
INSERT INTO empNTpo_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","¿Cãrẽ cãrẽã bãrãra egiptorã ãdji boro sid̶a so zarea panana quĩrãca so zarea panʌ? Ãcõrẽ baurudera jẽda diabued̶adua. Ãcõrẽba egiptorã bio cawa osid̶e ¿ãdjirãba israelerãra idu wãbisid̶aẽ́ca? ");
INSERT INTO empNTpo_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","Maʌ̃ bẽrã carreta djiwid̶ida obid̶adua. Idjab̶a paca warra bara panʌda umé edad̶adua. Maʌ̃ pacara wad̶i carreta erreb̶arid̶acada b̶ead̶ida panʌa. Ãdjira carretad̶aa jʌ̃ nũmʌnadua baribʌrʌ dji warrara ãdji ume idu wãbirãnadua; ãtebʌrʌ corrad̶e b̶ʌd̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","Maʌ̃be Ãcõrẽ baurudera carretad̶e cob̶ʌd̶adua. Maʌ̃ orrocawa dewara baurudeda cob̶ʌd̶adua. Maʌ̃ne ed̶a bãrãba oro ocuad̶ara b̶ʌd̶adua. Maʌ̃ra Ãcõrẽa diabued̶adua idji baurude eropanana carea. Maʌ̃bebʌrʌ pacaa carretara idu edebid̶adua. ");
INSERT INTO empNTpo_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","Baribʌrʌ naʌ̃gʌda quĩrãcuitad̶adua: pacaba carretara israelerã puru Bet-semed̶aa eded̶ibʌrʌ, wãrãda Ãcõrẽba dadjirãra biẽ́ erob̶asia. Mamaa eded̶aẽ́bʌrʌ dadjirãba cawad̶ia idjia dadjirãra jãwã oẽ́ b̶asida; ãtebʌrʌ ara jãwã biẽ́ panesid̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","Ara maʌ̃da mãwã osid̶aa. Paca warra bara panʌda umé edad̶aped̶a carretad̶aa jʌ̃sid̶aa. Dji warrara corrad̶e b̶ʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","Maʌ̃be Ãcõrẽ baurudera carretad̶e cob̶ʌd̶aped̶a dewara baurudeda orrocawa b̶ʌsid̶aa. Maʌ̃ne ed̶a churi oro ocuad̶ara, ãdji cacuad̶e zarega odjacuad̶a quĩrãca od̶a sid̶a b̶ʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","Paca quenabuesid̶ad̶e jipa Bet-semenaa b̶ia wãsid̶aa, ni maãrĩ bid̶a o ãyã wãnaẽ́ basía. Maʌ̃ne pilisteorã dji droma b̶eara caid̶u acʌd̶e wãsid̶aa ab̶a Bet-seme daucha. ");
INSERT INTO empNTpo_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","Maʌ̃ ewarid̶e israelerã Bet-semed̶ebemaba ãdji trigoda jewed̶ad̶e ewa duanasia. Maʌ̃ne cawaẽ́ne pacaba dji carretara Ãcõrẽ baurude bara erreb̶ari enebʌdada unusid̶aa. Maʌ̃ carea bio b̶ʌsrid̶asid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S16_14","010_6_14","1SA","6","14","15","Dji carreta Bet-seme druad̶e jũẽsid̶e pacara nũpanesid̶aa ẽberã Josue abada ẽjũãne, mõgara waib̶ʌa cob̶ʌ caita. Mama levitarãba Ãcõrẽ baurudera, oro ocuad̶a bara b̶ʌ baurude sid̶a edad̶aped̶a maʌ̃ mõgara waib̶ʌa ʌ̃rʌ̃ cob̶ʌsid̶aa. Maʌ̃ne ẽberãrãba carretara ẽgawed̶aped̶a tʌbʌda cajẽrãsid̶aa. Maʌ̃be pacara, dewara animarã sid̶a Ãcõrẽa babue diasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","Pilisteorã bororã juesuma panʌba maʌ̃da ununaped̶a Ecroʌ̃naa jẽda wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","Pilisteorãba ãdji cacuad̶e zarega odjacuad̶a quĩrãca orod̶eda od̶aped̶a Ãcõrẽ baurude eropanana carea Asdo puruba, Gaza puruba, Ascaloʌ̃ puruba, Gat puruba, Ecroʌ̃ puru bid̶a Ãcõrẽa ab̶a ab̶a diasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","Maʌ̃ awara pilisteorã boro juesuma panʌba dewara puru b̶eada ãdjirã jʌwaed̶a eropanasid̶aa. Puruza churi quĩrãca oro od̶ada ab̶a diasid̶aa. Ʌ̃cʌrʌ purura mõgaraba jũrã ca b̶easia idjab̶a ʌ̃cʌrʌ ara jãwã b̶easia. Maʌ̃ purura b̶easia pilisteo druad̶eba ab̶a mõgara waib̶ʌa cob̶ʌma. Maʌ̃ mõgarara wad̶ibid̶a Josue Bet-Semed̶ebema ẽjũãne b̶ʌa israelerãba Ãcõrẽ baurudera ʌ̃rʌ̃ cob̶ʌped̶ad̶ama. ");
INSERT INTO empNTpo_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","Ãcõrẽba israelerã Bet-semed̶ebemara setenta quinibisia idji bauruded̶e ed̶a acʌped̶ad̶a carea. Maʌ̃ne purura bio jĩãsia Ãcõrẽba zocãrã quinibid̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","Maʌ̃ carea jarasid̶aa: –Ãcõrẽra jipa b̶ʌ bẽrã ¿caida idji quĩrãpita poya b̶ai? Naʌ̃ baurudera ãyã diabued̶ida panʌa baribʌrʌ ¿cairãmaa diabued̶i?– ");
INSERT INTO empNTpo_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","Maʌ̃ carea Quiriat-jeariʌ̃ purud̶aa ʌ̃cʌrʌ diabuesid̶aa nãwã jarad̶amãrẽã: –Pilisteorãba Ãcõrẽ baurudera waya jẽda diabuesid̶aa. Maʌ̃ bẽrã jʌrʌd̶e zed̶adua.– ");
INSERT INTO empNTpo_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","Ara maʌ̃da Quiriat-jeariʌ̃nebemarã zed̶aped̶a Ãcõrẽ baurudera edesid̶aa. Maʌ̃be eya zaqued̶e Abinadá ded̶e b̶ʌd̶aped̶a Abinadá warra Eleazada edasid̶aa waga b̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("S18_1","010_8_1","1SA","8","1","2","Samuelba warrada umé erob̶asia. Dji nabemara Joel abadjid̶aa. Dewarabemara Abías abadjid̶aa. Samuel drõã b̶ed̶acarea idji warrarãra israelerã nẽbʌra cawa obadarãda b̶ʌsia. Ãdjia Beersebá purud̶e cawa obadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Baribʌrʌ Samuel warrarãra idji quĩrãca jipa nĩbad̶aca basía. Ãtebʌrʌ biara parata awua panasid̶aa. Ab̶aʌba paratada diasira maʌ̃ ẽberãare panebadjid̶aa. Maʌ̃ bẽrã jipa cawa od̶aca basía. ");
INSERT INTO empNTpo_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Maʌ̃ carea Israeld̶ebema dji dromarãda ãbaa dji jʌred̶aped̶a Ramá purud̶aa Samuel ume bed̶ead̶e wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","Samuelea nãwã jarasid̶aa: –Bʌra drõãda b̶esia idjab̶a bʌ warrarãra bʌ quĩrãca jipa nĩbad̶acaa. Maʌ̃ bẽrã ab̶a b̶ʌdua dadjirã boroda b̶emãrẽã dewara druad̶e erob̶ea quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Mãwã jarabʌdara Samuelba biẽ́ ũrĩna bẽrã Ãcõrẽa iwid̶isia sãwã oida b̶ʌ cawaya. ");
INSERT INTO empNTpo_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Maʌ̃ne Ãcõrẽba nãwã panusia: –Ãdjirãba jara panʌra jũma odua. Mãwã jara panʌneba bʌda igara panʌẽ́a. Mʌ̃drʌ igara panʌa. Quĩrĩãẽ́ panʌa mʌ̃ra ãdji boro baida. ");
INSERT INTO empNTpo_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Mʌ̃a ãdjirã Egiptod̶eba ẽdrʌ edad̶ad̶eba ʌ̃taa ab̶arida obadaa. Ãdjia ara cadrʌa mʌ̃ra igarabadaa dewara ãcõrẽ b̶eada ẽpẽni carea. Ara maʌ̃ quĩrãca bʌda o panʌa. ");
INSERT INTO empNTpo_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Maʌ̃ carea ãdjirãba jara panʌ quĩrãca ab̶a b̶ʌdua ãdjirã boroda b̶emãrẽã. Baribʌrʌ maʌ̃ naẽna ãdjirãa ebud̶a jaradua maʌ̃ boroba sãwã o b̶aida.– ");
INSERT INTO empNTpo_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Jũma Ãcõrẽba jarad̶ara Samuelba dji boro iwid̶i panʌrãa nãwã jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","–Bãrãba ab̶a bãrã boroda b̶ʌd̶ibʌrʌ, idjia nãwã oya: bãrã warrarã cũdra b̶eara zocaya. Idjia ʌ̃cʌrʌ b̶ʌcuaya carretad̶eba idjab̶a cawayod̶eba djõnamãrẽã. Dewararãda idji carreta nocoare pira wãbicuaya ẽberãrã od̶ebemada ãyã jʌrecuad̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Ʌ̃cʌrʌ b̶ʌcuaya mil sordaorã bororãda b̶ead̶amãrẽã idjab̶a ʌ̃cʌrʌ b̶ʌcuaya cincuenta sordaorã bororãda b̶ead̶amãrẽã. Ʌ̃cʌrʌ b̶ʌcuaya idji ẽjũã od̶amãrẽã idjab̶a néu ewad̶amãrẽã. Maʌ̃ awara ʌ̃cʌrʌ b̶ʌcuaya carretad̶ebema idjab̶a djõi careabema od̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Maʌ̃ awara bãrã cau awẽrã b̶eara zocaya. Ãdjirãra b̶ʌcuaya quera od̶amãrẽã, ne djud̶amãrẽã, idjab̶a paʌ̃ ãbud̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Idjab̶a bãrã ẽjũã dji biara b̶eara, bãrã uva ẽjũã dji biara b̶eara, bãrã olivo ẽjũã sid̶a edaped̶a idjiare b̶earãa diacuaya. ");
INSERT INTO empNTpo_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Maʌ̃ awara bãrãba trigo ewabʌdad̶ebemada, uva ewabʌdad̶ebema sid̶a edaya. Bãrãba ẽ die ewabʌdaza idjia ab̶a edaped̶a idjiare b̶earãa diacuaya. ");
INSERT INTO empNTpo_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Maʌ̃ awara bãrã nezocarã dji umaquĩrãda, dji wẽrã sid̶a idji itea edaya. Bãrã pacara, burro sid̶a dji biara b̶eada idji itea edaya. ");
INSERT INTO empNTpo_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Maʌ̃ awara bãrã ovejad̶ebemada, bãrã chiwatud̶ebema sid̶a edaya. Bãrãba die juachabʌdaza idjia ab̶a edaya. Maʌ̃ awara ara bãdjida idji nezocarãda b̶ead̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Maʌ̃ ewarid̶e bãrã boroba mãwã o b̶ʌ carea Ãcõrẽa quĩrã djuburiada iwid̶id̶ia baribʌrʌ idjia bãrã bed̶eara ũrĩẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Samuelba mãwã jarad̶amĩna israelerãba ni maãrĩ bid̶a ĩjãnaẽ́ basía. Ãtebʌrʌ nãwã jarasid̶aa: –Ĩjãnaẽ́a. Dairãba quĩrĩã panʌa ab̶a dadjirã boro baida. ");
INSERT INTO empNTpo_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Mãwã dewara drua b̶eaba ãdji boro eropanʌ quĩrãca dadjirã bid̶a eropanania. Maʌ̃ boroba dadjirãra pe erob̶aya. Idjab̶a djõne wãbʌdad̶e idjidrʌ nocoare wãya.– ");
INSERT INTO empNTpo_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Maʌ̃ ũrĩped̶a Samuelba ãdji bed̶eara jũma Ãcõrẽa jarasia. ");
INSERT INTO empNTpo_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Maʌ̃ne Ãcõrẽba panusia: –Ãdjirãba jara panʌ quĩrãca odua. Ab̶a b̶ʌdua ãdjirã boro bamãrẽã.– Maʌ̃ bẽrã Samuelba israelerã boroda ab̶a b̶ʌyad̶a aped̶a jũmarãda ãdji puruza wãbisia. ");
INSERT INTO empNTpo_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Benjamiʌ̃neba yõna Quis abadada b̶asia. Idjira Abiel warra basía. Abielera Zero warra basía. Zerora Becorá warra basía. Becorára Apía warra basía. Apíara Benjamiʌ̃neba yõna basía. Maʌ̃ ẽberã Quis abadara dji droma basía. ");
INSERT INTO empNTpo_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Idjia warra cũdrada erob̶asia Saul abadada. Saulora jũma israelerã cãyãbara quĩrãwãrẽãra b̶asia idjab̶a drasoara b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Ewari ab̶a Saul zeza Quis burroda ʌ̃cʌrʌ nẽbasid̶aa. Maʌ̃ carea idji warra Sauloa nãwã jarasia: –Dadji burrora jʌrʌd̶e wãdua. Nezocada ab̶a ededua.– ");
INSERT INTO empNTpo_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","Ara maʌ̃da Saulba Epraiʌ̃ eyaid̶a b̶ʌ ẽjũãne, Salisad̶e, Saaliʌ̃ne, Benjamiʌ̃ ẽjũãne bid̶a jʌrʌ nĩbasia. Mãwãmĩna unuẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Zup ẽjũãne jũẽsid̶ad̶e Saulba idji nezocaa jarasia: –Jẽda wãna. Naʌ̃bara mʌ̃ zezara idji burro carea sopua b̶ʌẽ́a ãtebʌrʌ dadji carea sopua b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Dji nezocaba panusia: –Naʌ̃ purud̶e Ãcõrẽneba bed̶eabarida b̶ʌa. Jũmarãba idjira waya panʌa. Jũma idjia jarabʌrʌra wãrãda mãwãbaria. Idjimaa wãna. Idjia poya jaraisicada sãma burrora jʌrʌd̶e wãnida panʌda.– ");
INSERT INTO empNTpo_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","Saulba panusia: –Mãẽteara wãna. Baribʌrʌ ¿cãrẽda idji itea eded̶i? Dadjia eneped̶ad̶a paʌ̃ra jõsia. Ni cãrẽ sid̶a neẽ́ panʌa idjía diad̶i carea.– ");
INSERT INTO empNTpo_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","Dji nezocaba panusia: –Mʌ̃a nama parata torroda ab̶a erob̶ʌa. Maʌ̃gʌra idjía diad̶ia jaramãrẽã sãma burrora jʌrʌd̶e wãnida panʌda.– ");
INSERT INTO empNTpo_vpl VALUES ("S19_9","010_9_9","1SA","9","9","10","Saulba jarasia: –Bia b̶ʌa. Wãna.– Ara maʌ̃da Saulora idji nezoca ume purud̶aa Ãcõrẽneba bed̶eabarimaa wãsid̶aa. (Maʌ̃ ewarid̶e israelerãba Ãcõrẽneba bed̶eabarira dau ẽsã unubarida jarabadjid̶aa. Maʌ̃ bẽrã ab̶aʌba Ãcõrẽa iwid̶i quĩrĩã b̶ʌd̶e jarabadjia: “Dau ẽsã unubarida acʌd̶e wãna.”) ");
INSERT INTO empNTpo_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","Jũẽbod̶od̶ad̶e eyad̶e ʌ̃taa nĩbasid̶aa. Maʌ̃ne awẽrãrã baido jued̶e wãbʌdada unusid̶aa. Ãdjia maʌ̃ awẽrãrãa nãwã iwid̶isid̶aa: –Dji dau ẽsã unubarira ¿naʌ̃ purud̶e b̶ʌca?– ");
INSERT INTO empNTpo_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","Awẽrãrãba nãwã panusid̶aa: –Mãẽ, nocoare b̶ʌa. Isabe wãnadua. Id̶i puruba eya borod̶e animarãda Ãcõrẽa babue diad̶i bẽrã idjira zesia. ");
INSERT INTO empNTpo_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","Purud̶e jũẽsid̶ara idjira isabe jʌrʌd̶adua. Mãwãẽ́bʌrʌ idjira eya borod̶aa ne cod̶e wãya. Idjiabʌrʌ animarã Ãcõrẽa babue diaped̶ad̶ada bia jara b̶ʌida b̶ʌa ẽberãrãba cod̶i naẽna. Isabe wãnibʌrʌ idjira ununia.– ");
INSERT INTO empNTpo_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","Ara maʌ̃da ãdjira purud̶aa ʌ̃taa wãsid̶aa. Jũẽbʌdad̶e Samuelera eya borod̶aa wãbʌrʌda ãdji ume quĩrãdjusia. ");
INSERT INTO empNTpo_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Nurẽmaena Saul jũẽi naẽna Ãcõrẽba Samuelea naʌ̃gʌda cawabisia: ");
INSERT INTO empNTpo_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","–Nu ara naʌ̃ horaca mʌ̃a Benjamiʌ̃ ẽjũãnebemada ab̶a bʌmaa diabueya. Idjidrʌ b̶ʌdua mʌ̃ puru Israel boro bamãrẽã. Idjiabʌrʌ bãrãra pilisteorã jʌwaed̶abemada ẽdrʌ b̶ʌya. Mʌ̃a unu b̶ʌa mʌ̃ purura bio bia mĩga b̶ʌda. Idjab̶a mʌ̃a ũrĩ b̶ʌa ãdjirãba quĩrã djuburiada iwid̶i panʌda.– ");
INSERT INTO empNTpo_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Samuelba Saul unusid̶e Ãcõrẽba idjía jarasia: –Jãʌ̃ ẽberãdrʌ mʌ̃a bʌ́a nuena jara b̶asia. Idjiabʌrʌ mʌ̃ purura pe erob̶aya.– ");
INSERT INTO empNTpo_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Purud̶e ed̶a wãbadama Saulora Samuel caita wãped̶a jarasia: –Mʌ̃ djuburia mʌ̃́a jaradua dji dau ẽsã unubari dera sãma b̶ʌda.– ");
INSERT INTO empNTpo_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Samuelba jarasia: –Dau ẽsã unubarira mʌ̃́a. Eya borod̶aa mʌ̃ na wãdua. Mʌ̃a quĩrĩã b̶ʌa id̶i bʌra mʌ̃ ume ne coida. Nu diaped̶a bʌa iwid̶ibʌrʌda mʌ̃a jaraya. Mãwãnacarea mʌ̃a bʌra idu wãbiya. ");
INSERT INTO empNTpo_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Burro ewari ũbea adua panʌ carea sopuarãdua. Bʌ ẽberãrãba unusid̶aa. Maʌ̃ awara jũma israelerãba quĩrĩã panʌa bʌda, bʌ zezad̶eba yõbʌdarã sid̶a ãdjirã boroda b̶ead̶ida.– ");
INSERT INTO empNTpo_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","Saulba panusia: –Baribʌrʌ mʌ̃ra Benjamiʌ̃neba yõnada jãwã b̶ʌa. Dai purura Israeld̶eba yõped̶ad̶a doce purud̶ebemada dji caibeara b̶ʌa. Maʌ̃ awara Benjamiʌ̃neba yõped̶ad̶ad̶ebemada mʌ̃ ẽberãrãra dji ed̶aara b̶eaa. Maʌ̃da ¿cãrẽ cãrẽã bʌa mʌ̃́a mãwã jara b̶ʌ?– ");
INSERT INTO empNTpo_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","Maʌ̃be Samuelba Saulora, idji nezoca sid̶a eya borod̶e b̶ʌ ded̶aa edeped̶a ẽberãrã treinta panʌ tãẽna chũmebisia dji dromaara b̶ea chũmebadama. ");
INSERT INTO empNTpo_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","Maʌ̃be Samuelba ne djubaría nãwã jarasia: –Ne djara mʌ̃a bʌ́a awara b̶ʌbid̶ara enedua.– ");
INSERT INTO empNTpo_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","Ara maʌ̃da ne djubariba chĩded̶ebema djarada enesia Saulba comãrẽã. Maʌ̃ne Samuelba jarasia: –Codua. Mʌ̃a purua ãbaa ne cod̶i jarasid̶e naʌ̃gʌra bʌ itea awara b̶ʌbisia.– Ara maʌ̃da Saulora Samuel ume ne cosia. ");
INSERT INTO empNTpo_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Mãwãnacarea ãdjira eya borod̶eba purud̶aa ed̶aa zed̶aped̶a Samuel ded̶e dji ʌ̃taarebema dejãne Saul itea cʌd̶ada osid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Mama Saulora cãĩsia. Nurẽma Samuelba Saul maʌ̃ ʌ̃taarebema dejãne b̶ʌda trʌ̃ped̶a jarasia: –Pirab̶aridua, wãida b̶ʌa.– Ara maʌ̃da Saulora piradrʌped̶a Samuel ume dajadaa wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","Purud̶eba wãbʌdad̶e Samuelba Sauloa jarasia: –Bʌ nezocaa jaradua na wãmãrẽã baribʌrʌ bʌra wad̶i wãrãdua. Ãcõrẽba jarabi b̶ʌra mʌ̃a bʌ́a jaraida b̶ʌa.– Ara maʌ̃da Saul nezocara na wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Maʌ̃be Samuelba nedragada edaped̶a Saul boro ʌ̃rʌ̃ weasia. Uridarrad̶e isõped̶a nãwã jarasia: –Ãcõrẽba id̶i bʌra b̶ʌbʌrʌa idji puru Israel boroda b̶amãrẽã. Bʌabʌrʌ naʌ̃ purura pe erob̶aya idjab̶a ãdjirã dji quĩrũnebemada ẽdrʌ b̶ʌya. Nãwã bʌa cawaya Ãcõrẽba wãrãda bʌra israelerã boroda b̶ʌsida. ");
INSERT INTO empNTpo_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","Namaʌba bʌ wãbʌrʌd̶e Benjamiʌ̃neba yõped̶ad̶arã ẽjũãne Selsa purud̶e ẽberãda umé unuya. Ãdjira Isa quima Raquel tʌb̶ariped̶ad̶a caita panania. Ãdjia bʌ́a nãwã jarad̶ia: “Bʌa burro jʌrʌ b̶ad̶ara unusid̶aa. Maʌ̃ bẽrã burro carea bʌ zezara sopuaẽ́ b̶ʌa, ãtebʌrʌ bãrã carea sopua b̶ʌa. Idjia iwid̶i b̶ʌa sãwã bʌra unuida.” ");
INSERT INTO empNTpo_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","Maʌ̃ awara Tabor ẽjũãne bacuru waib̶ʌama jũẽbʌrʌd̶e ẽberãda ũbea unuya. Ãdjira Beteld̶aa wãbʌdaa Ãcõrẽa ne diad̶i carea. Ab̶aʌba chiwatuda ũbea erob̶aya. Ab̶aʌba paʌ̃da ũbea erob̶aya. Dewarabemaba uva b̶ada animarã e od̶ad̶e erob̶aya. ");
INSERT INTO empNTpo_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","Ãdjia bʌ́a bed̶ead̶aped̶a paʌ̃da umé diad̶ia. Maʌ̃ra edadua. ");
INSERT INTO empNTpo_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","Mamaʌba bʌra Guibea purud̶aa wãya pilisteorã sordaorã panabadama. Purud̶e jũẽbod̶od̶e Ãcõrẽneba bed̶eabadarãda eya borod̶eba ed̶aa zebʌdada unuya. Ãdjirãra Ãcõrẽneba bed̶ea panania. Ãdji nocoare ẽberãrãba tõnõãda, chiruda, arpa sid̶a zá nĩbad̶ia. ");
INSERT INTO empNTpo_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Maʌ̃ unubʌrʌd̶e Ãcõrẽ Jaurera bʌmaa zeya. Maʌ̃ bẽrã bʌ sid̶a ãdjirã quĩrãca Ãcõrẽneba bed̶eaya. Mamaʌba ʌ̃taa bʌra awara b̶eya. ");
INSERT INTO empNTpo_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Mʌ̃a jarad̶a jũma mãwãnacarea bʌa o quĩrĩãbʌrʌda odua, Ãcõrẽra bʌ ume b̶ai bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","Maʌ̃ bẽrã Gilgald̶aa na wãped̶a mʌ̃ra jʌ̃ãdua. Domia ab̶aʌd̶e mʌ̃ra bʌma jũẽya. Maʌ̃be Ãcõrẽa animarãda jũma babue diad̶ia idjab̶a idji ume necai b̶ai careabema animarã dragada babue diad̶ia. Mãwãnacarea mʌ̃a jaraya bʌa cãrẽda oida b̶ʌda.– ");
INSERT INTO empNTpo_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Saul Samuelmaʌba wãbʌrʌd̶e Ãcõrẽba idji crĩchara awara b̶ʌsia. Ara maʌ̃ ewarid̶e Samuelba jarad̶ara jũma mãwãsia. ");
INSERT INTO empNTpo_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Maʌ̃ bẽrã Saul idji nezoca ume Guibead̶e jũẽsid̶ad̶e Ãcõrẽneba bed̶eabadarãda zebʌdada unusid̶aa. Ara maʌ̃da Ãcõrẽ Jaurera Saulmaa zesia. Maʌ̃ba Saul sid̶a ãdjirã quĩrãca Ãcõrẽneba bed̶ea b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Baribʌrʌ Saul unubadarãba idjira Ãcõrẽneba bed̶ea b̶ʌda unusid̶ad̶e ara ãdjidub̶a jarasid̶aa: –¿Cãrẽda sãwãsi Quis warra Saulora jãwã nũmʌra? ¿Idji sid̶a Ãcõrẽneba bed̶eabarica?– ");
INSERT INTO empNTpo_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","Mamabema ab̶aʌba jarasia: –¿Ãdjirã zezara cai?– Maʌ̃ carea ab̶aʌba ne oca bad̶ada cawaẽ́ne o b̶eibʌrʌ israelerãba nãwã jarabadaa: “¿Saul sid̶a Ãcõrẽneba bed̶eabarica?” ");
INSERT INTO empNTpo_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Mãwãnacarea Saulora idji diguid̶a jũẽsia. ");
INSERT INTO empNTpo_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","Maʌ̃ne idji djabadrõãba idjía, dji nezocaa bid̶a nãwã iwid̶isia: –Bãrãra ¿sãma panasid̶a?– Saulba panusia: –Dai burroda jʌrʌ panasid̶aa. Baribʌrʌ ununaẽ́ bẽrã Samuelmaa bed̶ead̶e wãsid̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Idji djabadrõãba iwid̶isia: –¿Samuelba cãrẽda jarasi? Mʌ̃ djuburia idjia jarad̶ara jũma nẽbʌrʌdua.– ");
INSERT INTO empNTpo_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Saulba jarasia: –Idjia daia ebud̶a jarasia bãrãba burrora unusid̶ada.– Baribʌrʌ Saulba jaraẽ́ basía Samuelba idjira israelerã boro bai jarad̶ara. ");
INSERT INTO empNTpo_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Mãwãnacarea Samuelba Mizpa purud̶e israelerãra Ãcõrẽ quĩrãpita ãbaa jʌresia. ");
INSERT INTO empNTpo_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Maʌ̃be jarasia: –Dadji israelerã Ãcõrẽba nãwã jara b̶ʌa: “Mʌ̃a bãrãra Egiptod̶eba ẽdrʌ enesia. Ãdji jʌwaed̶abemada idjab̶a jũma dewara puruba bãrã biẽ́ o panʌnebemada ẽdrʌ edasia.” ");
INSERT INTO empNTpo_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Ãcõrẽba bãrãra bia mĩga panʌnebemada idjab̶a sopuad̶ebemada ẽdrʌ edabarimĩna naʌ̃ ewarid̶e idjira igara panʌa. Maʌ̃ carea jara panʌa: “Ab̶a b̶ʌdua dadji boroda b̶amãrẽã.” Maʌ̃ bẽrã ab̶a b̶ʌd̶ia. Bãrã doce purura Ãcõrẽ quĩrãpita zed̶aped̶a idjia cawabiya sãʌ̃gʌ purud̶ebemada dji boro baida. Maʌ̃be maʌ̃ purud̶ebema ẽberãrãra idji quĩrãpita zed̶aped̶a idjia cawabiya caida dji boro baida.– ");
INSERT INTO empNTpo_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Maʌ̃be Samuelba israelerã doce puruda Ãcõrẽ quĩrãpita jũma trʌ̃cuaped̶a Ãcõrẽba cawabisia dji borora Benjamiʌ̃neba yõna purud̶ebema baida. ");
INSERT INTO empNTpo_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Mãwãnacarea Samuelba Benjamiʌ̃ purud̶ebemarãra caitaara zebisia. Maʌ̃ne Ãcõrẽba cawabisia dji borora Matrid̶eba yõped̶ad̶ad̶ebema baida. Maʌ̃ ẽberãrãnebemada Ãcõrẽba cawabisia Quis warra Sauldrʌ edasida israelerã boroda b̶amãrẽã. Maʌ̃ bẽrã Saulora jʌrʌsid̶aa baribʌrʌ ununaẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Maʌ̃ carea wayacusa Ãcõrẽa iwid̶isid̶aa Saulora zesi cawaya. Maʌ̃ne Ãcõrẽba jarasia Saulora b̶ʌmĩna netatad̶e mĩrũ b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Ara maʌ̃da idjira jʌrʌd̶e pira wãnaped̶a puru quĩrãpita enesid̶aa. Maʌ̃ne puruba unusid̶aa idjira jũmarã cãyãbara drasoara b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Samuelba purua jarasia: –Ãcõrẽba naʌ̃ ẽberãda edasia bãrã boro bamãrẽã. Dadjirã tãẽna dewarada idji quĩrãca neẽ́a.– Ara maʌ̃da puruba nãwã b̶ia jarasia: –¡Bia b̶ʌa dadjirã boroda!– ");
INSERT INTO empNTpo_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","Ara maʌ̃da Samuelba purua jarasia ãdji boroba cãrẽda o b̶aida b̶ʌda. Maʌ̃ra jũma cartad̶e b̶ʌsia. Maʌ̃be dji cartara Ãcõrẽ ded̶e idji quĩrãpita waga b̶ʌsia. Mãwãnacarea Samuelba jũmarãda ãdji deza wãbicuasia. ");
INSERT INTO empNTpo_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","Saul sid̶a idji puru Guibead̶aa wãsia. Idji ume ʌ̃cʌrʌ ẽberã sozarra b̶eada wãsid̶aa Ãcõrẽba ãdjirã sod̶e b̶ʌd̶a bẽrã idjiare pananamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","Baribʌrʌ ʌ̃cʌrʌ ẽberã cadjiruarãba Saulora siriẽ́ b̶ʌda ununa bẽrã idji itea nebiada diad̶aẽ́ basía. Maʌ̃ awara nãwã jarasid̶aa: –Jãʌ̃ ẽberãba dadjirãra ¿sãwã ẽdrʌ b̶ʌi?– Baribʌrʌ Saulba ãdjia jara panʌra quĩrãcuitaẽ́ basía. Ãtebʌrʌ chupea b̶esia. ");
INSERT INTO empNTpo_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","Mãwãnacarea amonitarã boro Nahasada idji sordaorã ume Gala druad̶e wãnaped̶a Jabe puruda jũrã edasid̶aa urad̶i carea. Baribʌrʌ maʌ̃ purud̶ebemarãba Nahasaa jarasid̶aa: –Dai ume bed̶ea b̶ʌdua ãbaa necai panani carea. Maʌ̃be dairãra bʌ nezocarãda b̶ead̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","Amonitarã boro Nahasaba panusia: –Mʌ̃a bãrã ume bed̶ea b̶ʌya ãbaa necai panani carea. Baribʌrʌ mãwã od̶i naẽna jũmarãba jʌwa araarebema dauda mʌ̃́a idu nuẽtabid̶ida panʌa. Mãwã dewara puru quĩrãpita mʌ̃a jũma bãrã israelerãra quĩrã perabiya.– ");
INSERT INTO empNTpo_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","Jabed̶ebema bororãba nãwã panusid̶aa: –Daia domia ab̶a diadua jũma israelerãmaa bed̶ea diabued̶i carea. Maʌ̃ne ni ab̶aʌba daida carebad̶e zed̶aẽ́bʌrʌ, daira bʌ jʌwaed̶a panenia.– ");
INSERT INTO empNTpo_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","Jabed̶ebemarãba diabueped̶ad̶ara Guibea purud̶e Saul b̶abarima jũẽsid̶aa. Mama Nahasaba jarad̶ara purua jũma nẽbʌrʌsid̶aa. Maʌ̃ carea jũmarãda jĩãbi b̶ʌga nũmesia. ");
INSERT INTO empNTpo_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","Mãwã panʌne Saulora idji paca bara idji ẽjũãneba zeped̶a nãwã iwid̶isia: –¿Sãwãsid̶a? ¿Cãrẽ cãrẽã jãcua jĩã duanʌ?– Maʌ̃ne puruba Sauloa Jabed̶ebemarãba jaraped̶ad̶ara jũma nẽbʌrʌsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","Saulba maʌ̃ ũrĩsid̶e Ãcõrẽ Jaured̶eba b̶esia. Nahasaba israelerã biẽ́ oi jarad̶a carea Saulora bio quĩrũsia. ");
INSERT INTO empNTpo_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","Ara maʌ̃da pacada umé beasia. Drapetaped̶a tʌcuasia. Dji tʌcuad̶ara Israel puru b̶eaza diabuecuasia. Dji edeped̶ad̶aba puruza nãwã jarasid̶aa: –Bariduada Sauloare idjab̶a Samueleare djõne wãnaẽ́bʌrʌ, idji pacara ara naʌ̃ paca quĩrãca bead̶ia.– Ẽberãrã maʌ̃ ũrĩped̶ad̶ara Ãcõrẽba bio ne wayabisia. Maʌ̃ bẽrã ab̶ari crĩchada edad̶aped̶a djõne wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","Saulba ãdjirãra Beze purud̶e jʌresia. Ãdji juachasid̶e Judad̶ebemada treinta mil panasid̶aa, waabema israelerãda tresciento mil panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","Maʌ̃be Jabed̶ebemaba diabueped̶ad̶arãa Saulba nãwã jarasia: –Jabed̶ebemarãa jarad̶adua nu umatipa b̶ai naẽna dairãba ãdjirãra ẽdrʌ b̶ʌd̶ida.– Ara maʌ̃da ẽberãrã Jabed̶ebemaba diabueped̶ad̶ara jẽda wãnaped̶a Saulba jarad̶ara purua jarasid̶aa. Maʌ̃ ũrĩsid̶ad̶e Jabed̶ebemarãra bio b̶ʌsrid̶asid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","Maʌ̃ne ãdjirãba amonitarã boro Nahasaa sewad̶eba jarasid̶aa: –Nu dairãra bʌ jʌwaed̶a panenia. Maʌ̃ne dairãra bʌa quĩrĩã b̶ʌ quĩrãca odua.– ");
INSERT INTO empNTpo_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","Baribʌrʌ nurẽma Saulba idji sordaorãda cãbana awara awara b̶ʌsia. Idjia zocãrã edasia idjab̶a dewara boro umé panʌ́a ãdjiza ab̶ari quĩrãca diasia. Wad̶i pãĩmaena amonitarãra urad̶e wãnaped̶a quena panasid̶aa ab̶a umatipa babʌrʌd̶aa. Dji zocai panenara memenesid̶aa. Ni ab̶a bid̶a ãbaa panenaẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","Maʌ̃ne israelerãba Samuelea jarasid̶aa: –¿Cairãbʌrʌ Saulora dadjirã boro baida quĩrĩãẽ́ panasid̶a? Dairãa jarad̶adua bead̶i carea.– ");
INSERT INTO empNTpo_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","Baribʌrʌ Saulba jarasia: –Mãwãẽ́a. Id̶i ni ab̶aʌda bead̶aẽ́a Ãcõrẽba dadji israelerãra ẽdrʌ edad̶a bẽrã.– ");
INSERT INTO empNTpo_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Maʌ̃be Samuelba purua jarasia: –Gilgald̶aa wãna. Jãmabʌrʌ Saulora dadjirã boroda wayacusa jara b̶ʌd̶ia.– ");
INSERT INTO empNTpo_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Ara maʌ̃da jũma israelerãra Gilgald̶aa wãnaped̶a Ãcõrẽ quĩrãpita Saulora b̶ʌsid̶aa ãdjirã boroda b̶amãrẽã. Maʌ̃be Ãcõrẽ ume necai b̶ead̶i careabema animarã dragada babue diad̶aped̶a purura Saul sid̶a ãbaa bio b̶ʌsrid̶a ne cosid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","Mãwãnacarea Samuelba jũma israelerãa nãwã jarasia: –Bãrãba jaraped̶ad̶ara mʌ̃a jũma osia. Mʌ̃a ab̶a b̶ʌsia bãrã boroda b̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","Id̶ira idjiabʌrʌ bãrãra pe erob̶aya. Mʌ̃ra drõãda b̶ʌ bẽrã boro torroa b̶ʌa. Mʌ̃ warrarã drõã b̶ea sid̶a bãrã ume panʌa. Mʌ̃ cũdra ed̶aʌba ab̶a id̶i ewarid̶aa bãrãra pe erob̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","Mʌ̃ra bãrã quĩrãpita b̶ʌa. Mʌ̃a djãrã pacada, burro sid̶a jãrĩca basía idjab̶a sewad̶eba djãrãra biẽ́ jaraca basía ni biẽ́ oca basía. Mʌ̃ra paratabari ni ab̶aʌare b̶aca basía. Baribʌrʌ mʌ̃a cadjiruada osibʌrʌ, bãrãba Ãcõrẽ quĩrãpita, dadjirã boro idjia edad̶a quĩrãpita bid̶a jarad̶adua. Biẽ́ o b̶ʌd̶eba djãrãneda edasibʌrʌ mʌ̃a jũma jẽda diaya.– ");
INSERT INTO empNTpo_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","Puruba panusia: –Bʌa dairãra sewad̶eba biẽ́ jaraca basía ni biẽ́ oca basía. Djãrãneda jãrĩca basía.– ");
INSERT INTO empNTpo_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","Samuelba jarasia: –Ãcõrẽba, dadjirã boro idjia edad̶a bid̶a ũrĩsid̶aa bãrãba mʌ̃ra bed̶ead̶e b̶ʌẽ́ana a panʌda.– Puruba panusia: –Mãẽ, mãwã b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","Maʌ̃be Samuelba jarasia: –Ãcõrẽbʌrʌ Moiseda, Aaroʌ̃ sid̶a edaped̶a dadji drõã naẽnabemarãra Egiptod̶eba ẽdrʌ enesia. ");
INSERT INTO empNTpo_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","Maʌ̃ bẽrã quĩrãcuita ũrĩnadua. Bãrãba Ãcõrẽ awara ab̶a bãrã boroda b̶amãrẽã b̶ʌbisid̶ad̶e biẽ́ osid̶aa. Maʌ̃gʌra Ãcõrẽ quĩrãpita mʌ̃a bãrãa ebud̶a cawabiya. Ãcõrẽba bãrãra, bãrã drõã naẽnabemarã sid̶a bio carebasia. ");
INSERT INTO empNTpo_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","Jacobo Egiptod̶e b̶ad̶e wãnacarea egiptorãba idjid̶eba yõped̶ad̶arãda biẽ́ osid̶aa. Maʌ̃ bẽrã ãdjirãba Ãcõrẽa quĩrã djuburiada iwid̶id̶aped̶a idjia Moiseda Aaroʌ̃ sid̶a ãdjirãmaa diabuesia. Maʌ̃be Moiseba Aaroʌ̃ ume bãrã drõã naẽnabemarãra Egiptod̶eba ẽdrʌ enesid̶aa naʌ̃ ẽjũãne pananamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","Baribʌrʌ dãrãẽ́ne ãdjirãba Ãcõrẽra igarasid̶aa. Maʌ̃ carea idjia Hazord̶ebema sordaorã boro Sisaráa ãdjirãra idu poyabisia. Maʌ̃ awara pilisteorãa, Moab druad̶ebema boroa bid̶a ãdjirãra idu poyabisia. ");
INSERT INTO empNTpo_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","Mãwã panʌne israelerãba Ãcõrẽa nãwã quĩrã djuburiada iwid̶isid̶aa: “Dairãba cadjiruada osid̶aa. Bʌra igarad̶aped̶a Baalda, Astarte sid̶a ẽpẽsid̶aa. Baribʌrʌ bʌa dairãra dji quĩrũ jʌwaed̶abemada ẽdrʌ b̶ʌibʌrʌ, bʌdrʌ ẽpẽ panania.” ");
INSERT INTO empNTpo_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","Maʌ̃ carea Ãcõrẽba Gedeoʌ̃ Jerobaal abadada, Baracoda, Jepteda idjab̶a mʌ̃ sid̶a diabuesia bãrã dji quĩrũnebemada ẽdrʌ b̶ʌmãrẽã. Mãwã bãrãra necai panebadjid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","Baribʌrʌ amonitarã boro Nahasada bãrã ume djõne zebʌrʌda cawasid̶ad̶e bãrãba mʌ̃́a nãwã jarasid̶aa: “Ab̶a b̶ʌdua dadjirã boroda b̶amãrẽã.” Ãcõrẽra dadjirã boromĩna bãrãba mãwã jarasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","Id̶i bãrãba edaped̶ad̶a borora nama b̶ʌa. Bãrãba iwid̶iped̶ad̶ara Ãcõrẽba diasia. ");
INSERT INTO empNTpo_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","Baribʌrʌ Ãcõrẽra waya pananadua. Idjia jara b̶ʌra ĩjã od̶adua. Ni maãrĩ bid̶a igararãnadua. Bãrãba, bãrã boro bid̶a idjida wãrãda ẽpẽnibʌrʌ, bia duanania. ");
INSERT INTO empNTpo_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","Baribʌrʌ idjia jara b̶ʌda ĩjãnaẽ́bʌrʌ idjab̶a igarad̶ibʌrʌ, idjia cawa oya bãrã drõã naẽnabemarã cawa od̶a quĩrãca. ");
INSERT INTO empNTpo_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","Acʌd̶adua. Bãrãba ununia Ãcõrẽba bãrã quĩrãpita ne ununacada obʌrʌda. ");
INSERT INTO empNTpo_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","Ara nawena trigo jara nũmʌ bẽrã cue zecaa. Baribʌrʌ mʌ̃a Ãcõrẽa iwid̶iya cue zebimãrẽã idjab̶a baa sid̶a b̶aebimãrẽã. Maʌ̃neba bãrãba cawad̶ia Ãcõrẽ quĩrãpita cadjiruada osid̶ada idji awara ab̶a bãrã boroda b̶amãrẽã iwid̶isid̶ad̶e.– ");
INSERT INTO empNTpo_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","Ara maʌ̃da Samuelba Ãcõrẽa iwid̶isia. Maʌ̃ne Ãcõrẽba cuera zebisia. Baa sid̶a b̶ae nũmebisia. Maʌ̃ unubʌdad̶e puruba Ãcõrẽda, Samuel sid̶a bio wayasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","Maʌ̃ carea jũmarãba Samuelea jarasid̶aa: –Dairã, bʌ nezocarã beurãnamãrẽã Ãcõrẽa iwid̶idua. Dairãba naẽna cadjirua oped̶ad̶a awara wayacusa cadjiruada osid̶aa Ãcõrẽ awara ab̶a dairã boroda b̶amãrẽã iwid̶isid̶ad̶e.– ");
INSERT INTO empNTpo_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","Samuelba jarasia: –Ne wayarãnadua. Wãrãda bãrãba bio cadjiruada osid̶aa. Jãʌ̃be Ãcõrẽra waa igararãnadua. Wãrãda sod̶eba idjira ẽpẽnadua. ");
INSERT INTO empNTpo_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","Jʌwaba od̶a ãcõrẽ b̶eada ẽpẽrãnadua. Maʌ̃gʌrãba bãrãra poya carebad̶aẽ́a ni poya ẽdrʌ b̶ʌd̶aẽ́a, wãrã ãcõrẽẽ́ bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","Baribʌrʌ Ãcõrẽba quĩrĩãna bẽrã bãrãra edasia idji puru bamãrẽã. Maʌ̃ bẽrã idjia bãrãra igaraẽ́a ni ab̶aʌba idjida biẽ́ jararãnamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","Mʌ̃a bãrã carea iwid̶i b̶aya. Mãwã oẽ́bʌrʌ Ãcõrẽ quĩrãpita cadjiruada o b̶aya. Maʌ̃ awara mʌ̃a wad̶ibid̶a jaradia b̶aya sãwã jipa nĩbad̶ida panʌda. ");
INSERT INTO empNTpo_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","Bãrãba unusid̶aa Ãcõrẽba bãrã itea ne waib̶ʌada o b̶ʌda. Maʌ̃ bẽrã ab̶a idjidrʌ wayad̶adua. Sod̶eba idjida ẽpẽnadua. ");
INSERT INTO empNTpo_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","Baribʌrʌ cadjiruada o pananibʌrʌ, Ãcõrẽba bãrãra, bãrã boro sid̶a ãyã b̶ʌya.– ");
INSERT INTO empNTpo_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","Saul 30 poa b̶asid̶e israelerã boroda b̶esia. Idjira 42 poa ãdji boro basía. ");
INSERT INTO empNTpo_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","Saulba sordaorãda mil ũbea edasia. Mil umé idji ume panasid̶aa Micmá purud̶e Betel eyaid̶a b̶ʌ ẽjũãne. Mil ab̶a idji warra Jonataʌ̃ ume panasid̶aa Guibea purud̶e Benjamiʌ̃neba yõped̶ad̶arã ẽjũãne. Saulba waabema sordaorãra ãdji diguid̶aa jũma wãbisia. ");
INSERT INTO empNTpo_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","Guebá purud̶e Jonataʌ̃ra pilisteorã sordaorã duanabadamaa wãped̶a ãdjirãra quenasia. Maʌ̃da pilisteorãba cawasid̶aa. Maʌ̃ carea Saulba jũma Israel druad̶e cachirura zabisia jũmarãda djõne zed̶amãrẽã. Maʌ̃ne nãwã jarabisia: “Hebreorã, ũrĩnadua.” ");
INSERT INTO empNTpo_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","Naʌ̃ bed̶eada ãdjirãba ũrĩsid̶aa: “Saulba pilisteorãra quenasia. Maʌ̃ carea pilisteorãba dadji israelerãra quĩrãma panʌa.” Ara maʌ̃da israelerãra Gilgal purud̶aa wãsid̶aa Sauloare djõni carea. ");
INSERT INTO empNTpo_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","Maʌ̃misa pilisteorãra dji jʌresid̶aa israelerã ume djõni carea. Djõbada carretada treinta mil idjab̶a cawayod̶eba djõbada sordaorãda sei mil edesid̶aa. Waabema sordaorã edeped̶ad̶ara bio cãbana panʌ bẽrã poya juachad̶aẽ́ basía. Ãdjirãra Micmánaa wãnaped̶a Bet-aveʌ̃neba ʌ̃mãdau odjabariare duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","Israelerãba cawasid̶aa ãdjirãra minijĩchiad̶e panʌda, pilisteorãra ãdji cãyãbara zocãrãara panʌ bẽrã. Maʌ̃ carea uria b̶ead̶e, jogoa b̶ead̶e, mõgara waib̶ʌa cob̶ead̶e, idjab̶a baido juebada uria baido neẽ́ b̶ead̶e bid̶a mĩrũcuasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Idjab̶a Jordaʌ̃ do quĩrãrẽ ʌ̃cʌrʌ mĩrũcuasid̶aa Gad̶eba yõped̶ad̶arã duanʌma Gala druad̶e. Baribʌrʌ Saulora Gilgald̶e b̶esia. Idji ume panʌ sordaorãra bio ne wayaaba cacua ure duanasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","Samuelba jarad̶a quĩrãca Saulba domia ab̶a idjira jʌ̃ã b̶asia. Mãwãmĩna Samuelera wad̶ibid̶a Gilgald̶e jũẽẽ́ b̶asia. Maʌ̃ne Saul sordaorãra memenebʌda basía. ");
INSERT INTO empNTpo_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","Maʌ̃ carea Saulba jarasia: –Animarãda jũma babue diad̶i carea enenadua. Animarã Ãcõrẽ ume necai b̶ead̶i careabema sid̶a enenadua dji dragada babue diad̶i carea.– Maʌ̃be Saulba animarãra Ãcõrẽa jũma babue diasia. ");
INSERT INTO empNTpo_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","Ara mãwã od̶acarea Samuelera jũẽsia. Ara maʌ̃da Saulba idjira audiab̶arid̶e wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","Maʌ̃ne Samuelba jarasia: –¿Cãrẽ cãrẽã bʌa jãwã animarãra Ãcõrẽa babue diasi?– Saulba panusia: –Mʌ̃a jãwã osia mʌ̃ sordaorãra memenebʌda bẽrã idjab̶a bʌa jarad̶a ewarid̶e bʌra zeẽ́ b̶ad̶a bẽrã. Maʌ̃ awara pilisteorãra Micmáne jʌre duanʌa dadjirã ume djõni carea. ");
INSERT INTO empNTpo_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","Mʌ̃a crĩchasia nama Gilgald̶e ãdjirãra dadjirã ume isabe djõne zed̶ida. Maʌ̃ne mʌ̃a wad̶ibid̶a Ãcõrẽa diaẽ́ b̶asia carebamãrẽã. Maʌ̃ carea mãwã ocara b̶ad̶amĩna mʌ̃a animarãda babue diasia.– ");
INSERT INTO empNTpo_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Baribʌrʌ Samuelba panusia: –Bʌa crĩcha neẽ́ b̶ʌ quĩrãca jãwã osia. Ãcõrẽba jarad̶ara bʌa ĩjãẽ́ basía. Ĩjãnabara idjia bʌda, bʌd̶eba yõbʌdarã sid̶a ewariza israelerã bororãda b̶ʌcasia. ");
INSERT INTO empNTpo_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Baribʌrʌ idjia jarad̶ara ĩjãnaẽ́ bẽrã bʌra dãrã israelerã boro baẽ́a. Ãcõrẽba dewara ẽberãda b̶ʌya idji puru boroda b̶amãrẽã. Maʌ̃ ẽberãba oya Ãcõrẽba quĩrĩã b̶ʌ quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","Ara maʌ̃da Samuelera Gilgald̶eba Guibea purud̶aa wãsia Benjamiʌ̃neba yõped̶ad̶arã ẽjũãne. Maʌ̃be Saulba sordaorã wad̶i idji ume panʌda juachasia. Jũma ãbaa seisciento panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Ewari ab̶a Samuelba Sauloa jarasia: –Ãcõrẽba mʌ̃ra diabuesia bʌra idji puru Israel boroda b̶ʌmãrẽã. Maʌ̃ bẽrã Ãcõrẽba jara b̶ʌra quĩrãcuita ũrĩdua. ");
INSERT INTO empNTpo_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Ãcõrẽ ne jũma poya b̶ʌba nãwã jara b̶ʌa: “Mʌ̃a amalecitarãda cawa oya israelerã biẽ́ oped̶ad̶a carea. Israelerã Egiptod̶eba ẽdrʌsid̶ad̶e amalecitarãba ãdjirãra idu wãyã wãbid̶aẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Maʌ̃ carea ãdjirãra jũma quenane wãnadua. Ãdjirãba ne erob̶ea sid̶a jũma babued̶adua. Ni maãrĩ bid̶a ãdjirãra quĩrã djuburiarãnadua. Umaquĩrãrãda, wẽrãrãda, warrarãda, djiwid̶i toped̶ad̶a sid̶a jũma quenanadua. Ãdji pacada, ovejada, cameyoda, burro sid̶a jũma quenanadua.”– ");
INSERT INTO empNTpo_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Ara maʌ̃da Saulba idji sordaorãra Telaiʌ̃ purud̶e ãbaa jʌreped̶a juachasia. Maʌ̃ne Judad̶ebemada die mil panasid̶aa. Waabema sordaorãda dosciento mil panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Maʌ̃be Saulora idji sordaorã ume Amale purud̶aa wãsid̶aa. Puru caita jũẽnaped̶a do zaque orrocawa mĩrũsid̶aa cawaẽ́ne urad̶e wãni carea. ");
INSERT INTO empNTpo_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","Maʌ̃ne Saulba quenitarãa nãwã jarasia: –Dairãba amalecitarãra jũma quenania. Maʌ̃ bẽrã ãdjirã tãẽnabemada isabe ãyã wãnadua. Dairãba bãrãra bea quĩrĩãẽ́ panʌa, dai drõã naẽnabemarã Egiptod̶eba ẽdrʌsid̶ad̶e bãrãba carebaped̶ad̶a bẽrã.– Ara maʌ̃da quenitarãra amalecitarã tãẽnabemada ãyã wãsid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Mãwãnacarea Saulba idji sordaorã ume amalecitarãra quenane wãsid̶aa Havilad̶eba ab̶a Sur ẽjũãnaa. Sur ẽjũãra Egiptod̶eba ʌ̃mãdau odjabariare b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Amalecitarãra necoba jũma quenasid̶aa. Baribʌrʌ ãdjirã boro Agá abadada jidasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Ãcõrẽba jũma quenanaduad̶a ad̶amĩna idjab̶a ãdjia erob̶ea sid̶a babued̶aduad̶a ad̶amĩna Saulba idji sordaorã bid̶a mãwã od̶aẽ́ basía. Amalecitarã boro Agára bead̶aẽ́ basía. Idjab̶a dji biara b̶ea ovejada, pacada, paca zaque boreguea b̶eada, oveja zaque sid̶a bead̶aẽ́ basía. Maʌ̃ awara jũma ne bia b̶eada babued̶aẽ́ basía. Ab̶abe dji mãcuaẽ́ b̶eada idjab̶a siriẽ́ b̶eada babuesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Mãwãnacarea Ãcõrẽba Samuelea nãwã jarasia: ");
INSERT INTO empNTpo_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","–Mʌ̃ra sopua b̶ʌa Saul carea. Idjira bãrã boroda b̶ʌd̶amĩna idjia mʌ̃ra igarasia. Mʌ̃a jarad̶ara ĩjã oẽ́ basía.– Maʌ̃ ũrĩna carea Samuelera biẽ́ b̶esia. Jũma maʌ̃ diamasi Ãcõrẽa bed̶ea b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Nurẽma diaped̶ed̶a pirab̶ariped̶a Saulora jʌrʌd̶e wãsia. Maʌ̃ne ʌ̃cʌrʌba jarasid̶aa Saulora Carmel purud̶aa wãped̶a mõgara waib̶ʌada ʌ̃ta nũmʌsida amalecitarã poyad̶ada quĩrãnebabi carea. Mamaʌba idjira jẽda Gilgald̶aa wãsiad̶a asid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Samuel Saul b̶ʌma jũẽsid̶e Saulba nãwã jarasia: –Ãcõrẽba bʌra carebaya. Idjia jarad̶ara mʌ̃a jũma ĩjã osia.– ");
INSERT INTO empNTpo_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Samuelba panusia: –Mãwã baibʌrʌ ¿mʌ̃a sãwã ovejara, paca sid̶a b̶ia duanʌda ũrĩ b̶ʌ?– ");
INSERT INTO empNTpo_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Saulba jarasia: –Mʌ̃ sordaorãba amalecitarãneda jãrĩnaped̶a enesid̶aa. Dji biara b̶ea ovejara, paca sid̶a zocai b̶ʌsid̶aa bʌ Ãcõrẽa babue diad̶i carea. Baribʌrʌ waabemada dairãba jũma quenasid̶aa.– ");
INSERT INTO empNTpo_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Maʌ̃ne Samuelba Sauloa jarasia: –Chupea ũrĩdua. Ãcõrẽba id̶i diamasi jarad̶ada mʌ̃a jaraya.– Saulba panusia: –Mãẽteara jaradua.– ");
INSERT INTO empNTpo_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Samuelba jarasia: –Naẽna bʌra dji dromaẽ́da crĩcha b̶ad̶amĩna ¿id̶ira bʌra Israeld̶eba doce puru yõped̶ad̶arã boroẽ́ca? ¿Ãcõrẽba bʌra dadji israelerã boroda b̶ʌẽ́ basica? ");
INSERT INTO empNTpo_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Ãcõrẽba bʌ́a ebud̶a jarasia jãʌ̃ cadjirua obada amalecitarã ume djõmãrẽã ab̶a jũma quenabʌrʌd̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","Maʌ̃da ¿cãrẽ cãrẽã idjia jarad̶ara ĩjã oẽ́ basi? ¿Cãrẽ cãrẽã ãdjirã ne bia b̶eara babueẽ́ basi? ¿Cãrẽ cãrẽã edacuasi? Mãwã od̶ara Ãcõrẽ quĩrãpita cadjirua basía.– ");
INSERT INTO empNTpo_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Saulba panusia: –¡Mãwãẽ́a, mʌ̃a Ãcõrẽba jarad̶ara ĩjãsia! Idjia jarad̶a quĩrãca mʌ̃ra amalecitarã ume djõne wãsia. Ãdjirãra quenaped̶a ãdjirã boro Agára nama enesia. ");
INSERT INTO empNTpo_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Mʌ̃ sordaorãbʌrʌ dji biara b̶ea pacara, oveja sid̶a quenanaẽ́ basía. Ãtebʌrʌ nama Gilgald̶e enesid̶aa bʌ Ãcõrẽa babue diad̶i carea.– ");
INSERT INTO empNTpo_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Maʌ̃ne Samuelba jarasia: Animarã babue diad̶i cãyãbara Ãcõrẽba biara quĩrĩã b̶ʌa idji bed̶eara ĩjã pananida. Oveja draga babue diad̶i cãyãbara biara b̶ʌa idjia jara b̶ʌra ĩjã od̶ida. ");
INSERT INTO empNTpo_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Ãcõrẽba jara b̶ʌ igara b̶ʌba daubara quĩrãca bio cadjiruada o b̶ʌa. Cʌwʌrʌ zarea b̶ʌba jʌwaba od̶a ãcõrẽ ẽpẽ b̶ʌ quĩrãca bio cadjiruada o b̶ʌa. Bʌa Ãcõrẽba jarad̶ara igarad̶a bẽrã idjia bʌra israelerã boro bad̶ada igarasia. ");
INSERT INTO empNTpo_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Saulba Samuelea jarasia: –Mʌ̃a cadjiruada osia. Ãcõrẽba jarad̶ara, bʌa jarad̶a sid̶a mʌ̃a ĩjã oẽ́ basía. Mʌ̃ sordaorãda wayad̶a bẽrã ãdjia o quĩrĩã panʌda idu obisia. ");
INSERT INTO empNTpo_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Baribʌrʌ mʌ̃ quĩrã djuburia mʌ̃ cadjiruara quĩrãdoadua. Sordaorã panʌmaa wãna mʌ̃a Ãcõrẽa bia bed̶eai carea.– ");
INSERT INTO empNTpo_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","Samuelba panusia: –Mʌ̃ra bʌ ume wãẽ́a. Bʌa Ãcõrẽba jarad̶ara igarad̶a bẽrã idjia bʌra israelerã boro bad̶ada igarasia.– ");
INSERT INTO empNTpo_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Mãwã jaraped̶a Samuelera wãbʌrʌ basía. Maʌ̃ne Saulba idjia cacuad̶e jʌ̃ b̶ʌ id̶e jidabʌrʌd̶e maãrĩ cõã edasia. ");
INSERT INTO empNTpo_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Samuelba idjía jarasia: –Bʌa mʌ̃ wua cõã edad̶a quĩrãca Ãcõrẽba bʌ israelerã boro bad̶ada id̶i jãrĩped̶a dewara ẽberãa diasia. Maʌ̃ ẽberãra bʌ cãyãbara biara b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Israel Ãcõrẽ dji Droma b̶ʌra sewa ocaa idjab̶a bed̶ea ab̶a b̶ʌa. Maʌ̃ bẽrã idjia oyad̶a ad̶ara quĩrã awara ocaa ẽberãba obada quĩrãca.– ");
INSERT INTO empNTpo_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","Saulba jarasia: –Mʌ̃a wãrãda cadjiruada osia. Baribʌrʌ mʌ̃ quĩrã djuburia israelerã quĩrãpita, dji nocorã quĩrãpita bid̶a mʌ̃ra quĩrã perabirãdua. Sordaorã panʌmaa wãna mʌ̃a Ãcõrẽa bia bed̶eai carea.– ");
INSERT INTO empNTpo_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","Maʌ̃be Samuelera Saul ume sordaorã panʌmaa wãnaped̶a Saulba Ãcõrẽa bia bed̶easia. ");
INSERT INTO empNTpo_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Mãwãnacarea Samuelba jarasia: –Amalecitarã boro Agára namaa enenadua.– Samuelmaa enebʌdad̶e Agára necai b̶asia bead̶aẽ́da crĩcha b̶ad̶a bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","Baribʌrʌ Samuelba idjía jarasia: –Bʌa necoba zocãrã beaped̶a wẽrãrãda warra neẽ́ b̶ʌsia. Ara maʌ̃ quĩrãca mʌ̃a bʌ papa sid̶a warra neẽ́ b̶ʌya.– Mãwã jaraped̶a Gilgald̶e Ãcõrẽ quĩrãpita Samuelba idjira necoba beataped̶a pichipichia tʌcuasia. ");
INSERT INTO empNTpo_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Mãwãnacarea Samuelera idji puru Ramánaa wãsia. Saulora idji puru Guibead̶aa wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Mamaʌba ʌ̃taa Samuelba waa Saulora acʌd̶e wãẽ́ basía. Baribʌrʌ Ãcõrẽba Saulora israelerã boro bad̶ada igarad̶a bẽrã Samuelera idji carea bio sopua b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Ãcõrẽba Samuelea jarasia: –¿Bʌra ab̶a sãʌ̃be Saul carea sopua b̶ai? Mʌ̃a idjira israelerã boro bad̶ada igarasia. Mʌ̃a quĩrĩã b̶ʌa bʌra Beleʌ̃naa wãida ẽberã Jesé abadamaa. Idji warrad̶ebemada mʌ̃a ab̶a b̶ʌya israelerã boroda b̶amãrẽã. Maʌ̃ carea nedragada cachud̶e tʌ edaped̶a idjimaa wãdua.– ");
INSERT INTO empNTpo_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Samuelba Ãcõrẽa jarasia: –Baribʌrʌ mʌ̃da wãibʌrʌ, Saulba cawasira mʌ̃ra beaya.– Ãcõrẽba panusia: –Mãẽteara paca zaqueda ededua. Bariduaba iwid̶ibʌrʌ jaradua bʌa animarãda Ãcõrẽa babue diad̶e ze b̶ʌda. ");
INSERT INTO empNTpo_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Bʌa animarã babue diad̶e wãbʌrʌd̶e Jeséra ed̶odua bʌ ume wãmãrẽã. Maʌ̃ne mʌ̃a cawabiya bʌa sãwã oida b̶ʌda. Mʌ̃a jarabʌrʌ ẽberãda b̶ʌdua israelerã boroda b̶amãrẽã. Maʌ̃ne nedragara idji boro ʌ̃rʌ̃ weadua.– ");
INSERT INTO empNTpo_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Ãcõrẽba jarad̶a quĩrãca Samuelba osia. Beleʌ̃ne jũẽsid̶e mamabema nocorãba ne wayaaba idjira audiab̶arid̶aped̶a nãwã iwid̶isid̶aa: –¿Bʌra necai zebʌrʌca?– ");
INSERT INTO empNTpo_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Samuelba panusia: –Mãẽ, mʌ̃a naʌ̃ paca zaqueda Ãcõrẽa babue diad̶e ze b̶ʌa. Maʌ̃ carea Ãcõrẽ quĩrãpita bia duanani carea od̶adua. Mãwãnacarea animarãda babue diad̶e wãnia.– Maʌ̃be Samuelba Jeséra idji warrarã sid̶a Ãcõrẽ quĩrãpita bia b̶ʌped̶a ed̶osia idji ume animarã babue diad̶e wãnamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Ãdji jũẽsid̶ad̶e Samuelba Jesé warra Eliáda unuped̶a nãwã crĩchasia: –Wãrãda naʌ̃drʌ Ãcõrẽba edasia israelerã boroda b̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Baribʌrʌ Ãcõrẽba idjía jarasia: –Ab̶abe dji drasoada, quĩrãwãrẽã sid̶a acʌrãdua. Ẽberãba maʌ̃ra acʌbaria. Baribʌrʌ mʌ̃ara sodrʌ acʌbaria. Naʌ̃ ẽberãda mʌ̃a edaẽ́ b̶ʌa israelerã boroda b̶amãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Maʌ̃be Jeséba idji warra Abinadáda Samuel quĩrãpita trʌ̃sia. Baribʌrʌ Samuelba jarasia: –Naʌ̃gʌ sid̶a Ãcõrẽba edaẽ́ b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Maʌ̃be Jeséba idji warra Samáda Samuel quĩrãpita trʌ̃sia. Baribʌrʌ Samuelba jarasia: –Naʌ̃gʌ sid̶a Ãcõrẽba edaẽ́ b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Jeséba siete warrarãra Samuel quĩrãpita trʌ̃sia. Baribʌrʌ Samuelba jarasia Ãcõrẽba ni ab̶aʌ ãdjid̶ebemada edaẽ́ b̶ʌda israelerã boroda b̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Maʌ̃ne Samuelba iwid̶isia: –Bʌa ¿waa warrarã neẽ́ b̶ʌca?– Jeséba panusia: –Dji jĩrũarebemada neẽ́a ovejada waga b̶ʌ bẽrã.– Maʌ̃ carea Samuelba jarasia: –Idjira jʌrʌbidua. Idji jũẽi naẽna ne cod̶aẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Ara maʌ̃da Jeséba idjira jʌrʌbisia. Maʌ̃ warrara quĩrãwãrẽã b̶asia idjab̶a cacua dowa b̶asia. Idjira dau biya querasia. Maʌ̃ne Ãcõrẽba Samuelea jarasia: –Naʌ̃drʌ mʌ̃a edasia. Maʌ̃ bẽrã idji boro ʌ̃rʌ̃ nedragara weadua israelerã boroda b̶ʌmãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Ara maʌ̃da Samuelba nedragara edaped̶a dji djabarã quĩrãpita maʌ̃ warra ʌ̃rʌ̃ weasia israelerã boroda b̶amãrẽã. Maʌ̃ ewarid̶eba ʌ̃taa Ãcõrẽ Jaurera maʌ̃ warra Davi ume b̶abadjia. Mãwãnacarea Samuelera ãdjima b̶ad̶ada idji puru Ramánaa wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Maʌ̃ ewarid̶e Ãcõrẽ Jaurera Saul ume b̶ad̶ada ãyã wãsia. Maʌ̃ne Ãcõrẽba jaida idjimaa idu zebisia ewariza mĩã sẽ b̶amãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Maʌ̃ carea Sauloare b̶eaba idjía jarasid̶aa: –Dai djuburia ũrĩdua: Ãcõrẽba bʌra jaia idu mĩã sẽbi b̶ʌa. ");
INSERT INTO empNTpo_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Maʌ̃ carea dai boro, dairãa arpa zá cawa b̶ʌda jʌrʌbidua. Mãwãra jaiba mĩã sẽbʌrʌd̶e maʌ̃ ẽberãba arpara zaya bʌ necai b̶emãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Saulba jarasia: –Mãẽteara arpa bio zá cawa b̶ʌda jʌrʌd̶e wãnaped̶a mʌ̃maa enenadua.– ");
INSERT INTO empNTpo_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","Maʌ̃ne idjiare b̶ea ab̶aʌba nãwã jarasia: –Mʌ̃a Beleʌ̃nebema Jesé warrada ab̶a unusia. Maʌ̃ ẽberãba arpara bio zá cawa b̶ʌa. Idjira quĩrãwãrẽã b̶ʌa, sozarra b̶ʌa, bio mẽsrã b̶ʌa, idjab̶a crĩcha cawaad̶eba bed̶eabaria. Maʌ̃ awara Ãcõrẽra idji ume b̶ʌa.– ");
INSERT INTO empNTpo_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","Ara maʌ̃da Saulba Jesémaa ʌ̃cʌrʌ nãwã jarad̶e diabuesia: –Dadjirã boro Saulba nãwã jara b̶ʌa: bʌ warra Davi, dji oveja wagabarida mʌ̃maa diabuedua.– ");
INSERT INTO empNTpo_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Ara maʌ̃da Jeséba idji warra Davira Saulmaa diabuesia. Maʌ̃ awara paʌ̃da, uva b̶a animarã e od̶ad̶e b̶ʌ sid̶a burro ʌ̃rʌ̃ jʌ̃cuaped̶a diabuesia. Chiwatu zaque sid̶a ab̶a diabuesia. ");
INSERT INTO empNTpo_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","Davira jũẽped̶a Saul itea traja b̶esia. Saulba Davira bio quĩrĩã b̶asia. Maʌ̃ bẽrã idjira b̶ʌsia idji djõi careabemada eronĩbamãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Saulba Davira bio bia unu b̶ʌ bẽrã bed̶eada Jesémaa diabuesia Davira idji ume idu b̶ebimãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Jaiba Saul mĩã sẽbʌrʌd̶e Daviba arpada zabadjia. Mãwã zá b̶ʌd̶e Saulora necai b̶ebadjia jaira ãyã wãbadji bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Maʌ̃ ewarid̶e pilisteo sordaorãda Soco purud̶e Judad̶eba yõped̶ad̶arã ẽjũãne ãbaa dji jʌred̶aped̶a Epes-damiʌ̃ abadad̶e duanesid̶aa. Maʌ̃ ẽjũãra Soco puru idjab̶a Azecá puru ẽsi b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Maʌ̃ne Saulora israelerã sordaorã ume Ela do caita b̶ʌ jewed̶ad̶e dji jʌresid̶aa. Mama chãwẽ duanasid̶aa pilisteorã ume djõni carea. ");
INSERT INTO empNTpo_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","Pilisteorãra eya ab̶aʌd̶e duanasid̶aa. Maʌ̃ne israelerãra dewara eyad̶e panasid̶aa. Jewed̶ada ãdjirã ẽsi b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Maʌ̃ne pilisteorã duanʌmaʌba ẽberã bio mẽsrã b̶ʌda jewed̶ad̶aa zesia. Maʌ̃ ẽberãra Goliá abadjid̶aa. Goliára Gat purud̶ebema basía. Idji drasoara sei bicaca aud̶u b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","Idji borod̶e ne zarea bronce od̶ada jʌ̃ b̶abadjia. Idji jãare bronce cad̶aba jũãtrʌ jʌ̃ b̶abadjia. Dji zʌgʌara cien libra aud̶u b̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","Idji jĩrũ epanane bronce od̶aba jũãtrʌ jʌ̃ b̶abadjia. Maʌ̃ awara mĩãsu zaque bronce od̶ada ẽcarrad̶e awa b̶abadjia. ");
INSERT INTO empNTpo_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","Idji mĩãsu waib̶ʌada bio omoa b̶asia. Dji quid̶ara jiorro od̶a basía. Dji quid̶a zʌgʌara quince libra b̶asica b̶ʌa. Idji djõi careabema eronĩbabarida idji nocoare nĩbasia. ");
INSERT INTO empNTpo_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Goliára jewed̶ad̶e nũmeped̶a israelerã sordaorãa nãwã b̶iasia: –¿Cãrẽ cãrẽã jãwã chãwẽ duanʌ? Mʌ̃ra pilisteoa. Jũma bãrãra Sauloare djõbadaa. Mʌ̃dub̶a pilisteorã carea djõya. Maʌ̃ bẽrã ẽberãda ab̶a edad̶adua bãrã carea mʌ̃ ume djõne zemãrẽã. ");
INSERT INTO empNTpo_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Idjia mʌ̃da poya beaibʌrʌ jũma dairãra bãrã nezocarãda panenia. Baribʌrʌ mʌ̃a idjida beasira bãrãra dai nezocarãda panenia. ");
INSERT INTO empNTpo_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Id̶i mʌ̃a bãrã israelerãa orra bed̶ea b̶ʌa: ẽberãda ab̶a namaa diabued̶adua mʌ̃ ume djõmãrẽã.– ");
INSERT INTO empNTpo_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Maʌ̃ ũrĩbʌdad̶e Saulora, idji sordaorã sid̶a bio ne wayasid̶aa. Ab̶ed̶a sãwã od̶ida cawa crĩchad̶aẽ́ basía. ");
INSERT INTO empNTpo_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","Davira Jesé warra basía. Jeséra Epratad̶eba yõna basía. Juda druad̶e Beleʌ̃ purud̶e b̶abadjia. Saul israelerã boro basid̶e Jeséra bio drõãda b̶asia. Idjia warrarãda ocho erob̶asia. ");
INSERT INTO empNTpo_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","Idji warrarã drõãara panʌda ũbea Sauloare djõ panasid̶aa. Dji nabemara Eliá basía. Idjiarebemara Abinadá basía. Maʌ̃arebemara Samá basía. ");
INSERT INTO empNTpo_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","Maʌ̃ ũbeabema warrarãra Sauloare djõ panasid̶aa. Davira Jesé warra dji jĩrũarebema basía. ");
INSERT INTO empNTpo_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","Davira Saul b̶ʌmaa wãped̶a jẽda Beleʌ̃naa zebadjia idji zeza oveja waga b̶ai carea. ");
INSERT INTO empNTpo_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Maʌ̃misa pilisteo Goliába diaped̶a, quewara bid̶a israelerãa orra bed̶eabadjia. Cuarenta ewari mãwã osia. ");
INSERT INTO empNTpo_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Ewari ab̶a Jeséba idji warra Davia jarasia: –Warra, bʌ djabarã itea naʌ̃ die paʌ̃da, naʌ̃ trigo jututiad̶a sid̶a ẽ ab̶a ededua. ");
INSERT INTO empNTpo_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","Maʌ̃ awara sordaorã boro itea naʌ̃ die quesoda ededua. Maʌ̃be bʌ djabarã sãwã panʌda iwid̶iped̶a ãdjía jaradua ne diabued̶amãrẽã. Maʌ̃neba mʌ̃a cawaya ãdjira bia panʌda. ");
INSERT INTO empNTpo_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Maʌ̃misa Saulora, Davi djabarãra, waabema sordaorã sid̶a Ela jewed̶ad̶e pilisteorã ume djõni carea panasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Diaped̶ed̶a Daviba idji ovejara dewara ume b̶eesia wagamãrẽã. Maʌ̃be idji zezaba jarad̶ara edaped̶a wãsia. Davi jũẽne wãsid̶e israelerã sordaorãra djõne wãbʌda bẽrã b̶ʌga duanasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Maʌ̃ne israelerãra pilisteorã chãwẽ duanʌ quĩrãpe chãwẽ duanesid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Daviba eded̶ara ne wagabari jʌwad̶e ameped̶a idji djabarã chãwẽ duanʌmaa pira wãsia ãdji sãwã panʌda iwid̶i carea. ");
INSERT INTO empNTpo_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Ãdji ume bed̶ea b̶ʌd̶e Gat purud̶ebema mẽsrã b̶ʌ Goliára pilisteorã chãwẽ duanʌmaʌba jewed̶ad̶aa zeped̶a israelerãa orra bed̶easia idjia obari quĩrãca. Maʌ̃gʌra Daviba jũma ũrĩsia. ");
INSERT INTO empNTpo_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Israelerãba Goliá unubʌdad̶e bio ne wayad̶aped̶a jẽda pirasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","Ãdjidub̶a jarasid̶aa: –¿Bãrãba jãʌ̃ ẽberãra unusid̶aca? Idjia dadjirãa orra bed̶ead̶e zebaria. Bariduaba jãʌ̃ pilisteoda beaibʌrʌ dadji boroba maʌ̃ ẽberãra ne bara b̶ʌya. Idji cau sid̶a diaya. Maʌ̃ awara idjia parata diabi b̶ʌra dji zeza ẽberãrãa waa diabiẽ́a.– ");
INSERT INTO empNTpo_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Daviba idji caita duanʌ ẽberãrãa nãwã iwid̶isia: –Jãʌ̃ pilisteo cacua wẽãgoẽ́ tab̶ʌra ¿cai jãwã Ãcõrẽ zocai b̶ʌ sordaorãda orra bed̶eai carea? Jãwã dadji israelerã biẽ́ jara b̶ʌda ab̶aʌba beaibʌrʌ, ¿cãrẽda idjía diad̶i?– ");
INSERT INTO empNTpo_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Ãdjia naẽna jaraped̶ad̶ara wayacusa jarasid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","Davi djaba dji nabema Eliába ũrĩsia Davira dewararã ume nẽbʌrʌ b̶ʌda. Maʌ̃ carea quĩrũped̶a Davia nãwã jarasia: –¿Cãrẽ cãrẽã zesi? ¿Jãʌ̃ oveja zocãrãẽ́be tab̶ʌda ẽjũã põãsa ewaraga b̶ʌd̶e ãdub̶a b̶eesica? Mʌ̃a cawa b̶ʌa bʌra sãwã b̶ʌda. Bʌra namaa ze b̶ʌa ab̶abe dairã djõ duanʌda acʌi carea.– ");
INSERT INTO empNTpo_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","Daviba panusia: –Mʌ̃a ¿cãrẽ cadjiruada osi? ¿Ab̶abe iwid̶i b̶ʌẽ́ca?– ");
INSERT INTO empNTpo_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Ara maʌ̃da idji djaba caitabemada ãyã wãsia. Maʌ̃be dewara ẽberãrãa Goliá beaid̶ebemada iwid̶isid̶e ãdjia bid̶a ab̶arida panusid̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Daviba mãwã iwid̶i b̶ʌda ũrĩsid̶ad̶e ʌ̃cʌrʌba Saulmaa jarad̶e wãsid̶aa. Maʌ̃ carea Saulba idjira trʌ̃bisia. ");
INSERT INTO empNTpo_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","Maʌ̃be Daviba Sauloa jarasia: –Mʌ̃ boro, ni ab̶aʌba jãʌ̃ pilisteora wayaiẽ́ b̶ʌa. Mʌ̃, bʌ nezocara idji ume djõne wãya.– ");
INSERT INTO empNTpo_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Saulba panusia: –Bʌdub̶a jãʌ̃ pilisteo ume poya djõne wãẽ́a. Acʌdua bʌra wad̶i cũdrada b̶ʌda. Maʌ̃ne idjira drõãda b̶ʌa. Idjira cũdra ed̶aʌba djõ b̶abaria.– ");
INSERT INTO empNTpo_vpl VALUES ("S117_34","010_17_34","1SA","17","34","35","Daviba panusia: –Mʌ̃ boro, mʌ̃ zeza oveja waga b̶ʌd̶e imamada wa wida zeped̶a ovejada ca edesira mʌ̃ra caid̶u wãped̶a idjia ca erob̶ʌra jãrĩbaria. Idjab̶a maʌ̃ animarãba mʌ̃da orraibʌrʌ idji quid̶atrʌd̶e jidaped̶a u jidabaria ab̶a beabʌrʌd̶aa. ");
INSERT INTO empNTpo_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Wida imama sid̶a mãwã obaria. Mʌ̃a jãʌ̃ pilisteo cacua wẽãgoẽ́ tab̶ʌra ara maʌ̃ quĩrãca oya, Ãcõrẽ zocai b̶ʌ sordaorãda orra bed̶ea b̶ʌ bẽrã. ");
INSERT INTO empNTpo_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Ãcõrẽba mʌ̃ra imama jʌwad̶ebemada idjab̶a wi jʌwad̶ebemada ẽdrʌ edasia. Ara maʌ̃ Ãcõrẽba mʌ̃ra jãʌ̃ pilisteo jʌwad̶ebemada ẽdrʌ edaya.– Maʌ̃ne Saulba idjía jarasia: –Mãẽteara wãdua. Ãcõrẽra bʌ ume b̶aya.– ");
INSERT INTO empNTpo_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Ara maʌ̃da Saulba idjia djõi careabema jʌ̃barida Davia jʌ̃bisia. Ne zarea bronce od̶ada Davi borod̶e jʌ̃biped̶a jã jũãtrʌbari sid̶a Davia jʌ̃bisia. ");
INSERT INTO empNTpo_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","Maʌ̃be Daviba Saul necoda cʌrrʌd̶e jʌ̃ped̶a arima pʌrrʌa zasia. Baribʌrʌ jʌ̃ca bẽrã poya wãẽ́ basía. Daviba Sauloa jarasia: –Naʌ̃ra jʌ̃ca bẽrã mʌ̃ra poya wãẽ́a.– Ara maʌ̃da Daviba jũma ẽrãcuasia. ");
INSERT INTO empNTpo_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","Maʌ̃be idjia eronĩbabari bacurura edaped̶a do zaqued̶aa wãped̶a mõgara borogoa qued̶eada juesuma idji buchacad̶e pe edasia. Mõgara tab̶aribarida idji jʌwad̶e edaped̶a pilisteo Goliá ume djõne wãsia. ");
INSERT INTO empNTpo_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Maʌ̃ne Goliára Davimaa pĩãca zebʌrʌ basía. Idji djõi careabema eronĩbabarida idji nocoare nĩbasia. ");
INSERT INTO empNTpo_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Goliába bio acʌbʌrʌ