﻿USE sofia;
DROP TABLE IF EXISTS sofia.emi_vpl;
CREATE TABLE emi_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES emi_vpl WRITE;
INSERT INTO emi_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Nau ta namu ngatoa laghe aitoiaa aIsraeli etoa, paka maloo ateva ghe lutula. Taita ateva aBetlehem ia ta pai nge Juda ghe lao sio tani toka tau tale kateae masaliki eMoabi, ia me vausenna ateva me natuna taita alua. ");
INSERT INTO emi_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Taumattu ngateva o ararina ateae ta Elimelek, vausenna ateva ta Naomi, me natuna taita alua arariirarua ta Maloni me Kilion. Ila ararimangali nge Eprata ila, me tanganueira eBetlehem ta pai nge Juda. Laghe siola eMoabi tani toka. ");
INSERT INTO emi_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Vara me Elimelek ghe matela, ghe mate vulula vausenna ateva ta Naomi, me natuna taita alua. ");
INSERT INTO emi_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Natuna taita alua lalu ghe laila. Lalu ghe ghaala vause nge Moabi elua, arariirarua ta Opa me Rutu. Laghe tokala ghe roola koti kasangauluae (10) ninamanama. ");
INSERT INTO emi_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Vara me Maloni me Kilion lalu ghe mene matela, me Naomi nonga ghe tokala, poli taitanna ateva me natuna alua lotolu ghe mate akapala. ");
INSERT INTO emi_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Naomi ghe nongola va Iaue ang ghe tau lao sio masi nau ta kapuna atoa me inana ang ghe mene oroi ila. Liuna avalua o ia me alumuna vause alua laghe aimonomonosiaala tani kasu vuli eMoabi. ");
INSERT INTO emi_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Ang ghe kasukasu vuli nongina ghe tokatoka, ia me alumuna vause alua. Ngilotolu ghe kasukasu tani oghi lao eJuda, etapaa salana me ");
INSERT INTO emi_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Naomi ghe uela etairarua va, “Amalu oghila, me amalu lao tanganueimalua. Amalu laa toka tee kinaimalua alua. Iaue aue eghelei voto masina etaimalua, nongina amalu ghe aitara ngamasinaailiieghila, me lo tee alua ngilalu ghe matela. ");
INSERT INTO emi_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Iaue aue eaisausieiniemalua tani mene lai ppae. Me aue amalu toka masina tee!” Naomi ghe ngusulaluela, me lalu ghe sauaa saela, me ngilalu ghe ngangngala. ");
INSERT INTO emi_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Me lalu ghe uela etana va, “Angalu usio, me itolu lao ta kapum atoa.” ");
INSERT INTO emi_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Me Naomi ghe uela va, “Masina, amalu oghila, alumughu elua! Vaalua me amalu anna tani usieghi? Karika arooroo tani mene ssu righi natughu taita va amalu ghaa me etaitaniimalua. ");
INSERT INTO emi_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Amalu oghila, alumughu elua, me amalu lao tanganueimalua. Ngaghele vause namuula. Karika arooroo tani mene ghaa teva taita. Arova aghele ghaa teva taita, ghaine nonga eleivoo, me ghele mene alutu toa natughu taita, ");
INSERT INTO emi_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","aue karika amalu ghele anna tani mene lai, me amalu ghele toila ta la ghele tani namuu? Karika aghannaa va eisaa avalua o, alumughu elua. Amalua mene masina, me aghi karika masina, ta poli Iaue ang ghe gheleila voto sesa ang ghele lutula tale maamaulueaghi.” ");
INSERT INTO emi_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Me lalu ghe mene sauaa saela tani mene ngala. Vara me Opa ghe ngusula alumuna vause ateva tani akorovaia, me ghe kaili emasinala etana. Rutu nonga karika ghe anna tani oghi vulu Naomi. ");
INSERT INTO emi_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Me Naomi ghe uela va, “Tarala, iloam ange oghila tani laa tara kapuna atoa me kapuna goto atoa. Laa usia, me amalu oghi.” ");
INSERT INTO emi_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Rutu ghe liula me ghe uela va, “Karika aghaloanna va uue va aoghi vuluo. Poli aue eaa ulao, aghi tee aue alao. Me eaa ulaa toka, aghi tee aue atoka. Kapum atoa aue kapughu ila, kapum Goto ateva, aue kapughu tee ia. ");
INSERT INTO emi_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Eaa ulaa mate, aghi tee aue amate, me la kaia teeieghi. Nimate nonga ateva aue epolaitalua. Arova nganim kamekame, Iaue aue eliu aipolighi sesaaili.” ");
INSERT INTO emi_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Nau Naomi ghe tarala va Rutu ghe arrekana tani usi, ghe vira ruula tani auliaa etana va eoghi. ");
INSERT INTO emi_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Lalu ghe kasula, kasula me lalu ghe laa rekata sio eBetlehem. Nau lalu ghe lao sio eBetlehem, ila akapa taumattu ngatoa laghe soghieinielaluela. Me vause atoa laghe aikolomieinila va, “Tani koronna, va ia okae Naomi?” ");
INSERT INTO emi_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Me Naomi, ghe uela etaira va, “Am rau mene kolo Naomi etaghi, am koloaghi va Mara poli Vau ngepona ateva sarasarakanaaili ia ghe gheleila voto kaakaalanaaili etaghi. ");
INSERT INTO emi_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Oroi peighi me aghe kasula. Iaue ang ghele ghaa oghieghi mae sio me ngaghele nim peisaanela. Vaalua me am kolokolo Naomi etaghi? Iaue ghe taueghi siola euu me ia sarasarakanaaili ia ghe gheleila voto sesa ta ngetaghi.” ");
INSERT INTO emi_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Isaa o kiukiuna Naomi nau ghe oghi lao sio tanganuena, lalua me Rutu atala nge Moabi ia. Lalu ghe kasu vulila eMoabi, me lalu ghe laa rekata sio eBetlehem nau laghe tiuaala tani sai bali raisi. ");
INSERT INTO emi_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Kateva taumattu, tue peipeiena ia me namuu ia, ghe tokatoka eBetlehem, ararina ateae ta Boasi. Mangalina ia Elimelek, taitanna ateva Naomi. ");
INSERT INTO emi_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Kateva nau Rutu atala nge Moabi ia ghe uela ta Naomi va, “Aghanna tani laa usi lo atoa la saisai bali raisi tapaa ngutana, me aghaa righi ta lo ateva taumattu aue eanna va aghaimuli tee kapuna atoa me aghaa llo ekaokao alokoi.” Naomi ghe uela va, “Ue, alumughu, laa usi.” ");
INSERT INTO emi_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Rutu ghe lao sio tani aimuli tee lo atoa laghe saisai bali raisi, me ghe reirei llo laghe aakao. Karika ghe kilakila va paa ngutana ateae o umane ia Boasi, mangalina ia Elimelek. ");
INSERT INTO emi_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Vara me Boasi ghe rekatala, ghe kasula eBetlehem. Me ghe uela ta tau ngai sai bali raisi etoa va, “Iaue aue etoka teeiem.” Laghe liula me laghe uela va, “Iaue aue earangiseio.” ");
INSERT INTO emi_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Boasi ghe uela ta lo ateva ghe aaitoiaa tau ngai uungu etoa va, “See ia aliki vause ateva okae?” ");
INSERT INTO emi_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Me kapuira tau ngai toitoi eteva tau ngai uungu etoa ghe liula me ghe uela va, “Aliki vause nge Moabi ia. Lalu ghe kasula eMoabi me Naomi. ");
INSERT INTO emi_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Emae sio tani nongonongoaa va eaimuli tee lo atoa la saisai bali raisi me erei righi. Etiuaala arau elue talaua tani reirei, me ia okae ange vira mene lao sio tani ainoana toka tale ale paapali erighi.” ");
INSERT INTO emi_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Vara me Boasi ghe uela ta Rutu va, “Natughu, unongo, urau mene laa rei bali raisi ta mene righi ppae paa ngutana, ureirei nonga oia. Utoka tee lo atoa vause la uungu oia. ");
INSERT INTO emi_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Utara amasina paa ngutana la saisai bali raisi, me uaimuli teeila. Ngaghauliaala ta aliki taita atoa va la rau mene ghelei righi voto ta ngetam. Me arova uanna tani ropi, ulaa ropi tale aikaai manu eteva o aliki taita atoa la akuela.” ");
INSERT INTO emi_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Vara me Rutu ghe suuiaala me ghe turruula tapaa kosa, me ghe uela ta Boasi va, “Aghi ativuu ieghi. Vaalua me angu kaakaarasi tani ghelei masi voto etaghi?” ");
INSERT INTO emi_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Me Boasi ghe liula me ghe uela etana va, “Ngaghe nongo akapala voto ughe gheleila ta alumum vause ateva nau taitainim ateva ghe matela, me vaalua ughe kasu vulila kinam, tamam me tanganuem, me ughe mae sio tani toka tee llo taumattu karika ukilakila. ");
INSERT INTO emi_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Iaue aue eliu masi uunguaam, me isaa akapa aipolim kapuira Goto ateva aIsraeli etoa aue etau aatu, poli ughe tuutuliela tani aitarainio.” ");
INSERT INTO emi_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rutu ghe uela ta Boasi va, “Masinaaili voto angu gheleila ta ngetaghi, vaughu eteva. Arongona ta karika masina aghi nongina kapum vause atoa tau ngai uungu ila, me angu gheleila voto masina etaghi. Nau uaippooa ngamasina teeieghila, egheleieghila aghateateaa ngamasinala me nannaaghi tee emasinala.” ");
INSERT INTO emi_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Nau ninamanama, Boasi ghe mene uela ta Rutu va, “Mae ghaa righi verete, me uasuu tale uaeni, me unama tee.” Rutu ghe toka tee siola tau ngai uungu etoa, me ghe namanama teeilala. Boasi ghe tau lao sio bali raisi etana laghe tuu saela tale kuraa. Rutu ghe namala me ghe ssoiela, me kasina ghe oghi etokala. ");
INSERT INTO emi_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Nau ghe mene lao sio tani mene reirei, Boasi ghe uela ta kapuna aliki taita atoa va, “Am tau velu Rutu me erei ekalakalangina tale isaa o llo ngam iri eitaua ngatinginala. Am rau mene sama anamuu teeia va epalata. ");
INSERT INTO emi_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Me am ghaa righi bali raisi tale llo ngam iri eitaua ngatinginala, me am velu elokoi, me aue erei. Am rau mene tiu velua.” ");
INSERT INTO emi_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Rutu ghe reireila tale bali raisi elomosi ta sinaka ateva ghe suula. Me ghe paruparuaala llo ghe reila. Ghe ghaala vorovoro bali raisi ghe roola kateva efa. ");
INSERT INTO emi_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Rutu ghe ghaala isaa o bali, me ghe lao sio elo ale, me ghe apasungaala ta alumuna. Ghe sau teela tapiri nginana ghe nama vulula elo sinaka. ");
INSERT INTO emi_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Alumuna ghe kolomiela va, “Eaa ureireila tale nau eteva oia? Iaue earangise lo ateva taumattu etaraiola me eaikoloainiola.” Rutu ghe uela va, “Areireila tale paa ngutana ateae umana ia taumattu ngateva la ghasease Boasi etana.” ");
INSERT INTO emi_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Naomi ghe uela ta alumuna va, “Iaue aue earangiseia! Me Iaue karika ekakkaluaa kanna inangari nialokoi ta lo atoa la tokatoka me lo atoa angila ghe matela.” Naomi ghe uela va, “Ia ona taumattu ngateva uunguaane va, ia esausitalua me tani ghaa oghitalua, ta kalakalanginaaili ia etaitalua.” ");
INSERT INTO emi_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Me Rutu atala nge Moabi ia ghe uela va, “Boasi euela etaghi va auungu tee kapuna atoa elomosi ta la ruu tani sai bali raisi ta ngumana.” ");
INSERT INTO emi_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Naomi ghe uela ta alumuna va, “Alumughu, aue emasinaaili ta ughuungu tee kapuna tau ngai uungu etoa vause ila. Urau mene lao ta uma katoa, la rau tam laa ghaitara ngamasinaio.” ");
INSERT INTO emi_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Mausina avalua o me Rutu ghe kara ngaparasila ta kapuna tau ngai uungu etoa Boasi vause ila, elomosi ta laghe tani ruula tani sai bali raisi me uiti. Rutu ghe tokatoka tee alumuna vause ateva. ");
INSERT INTO emi_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Kateva nau Naomi ghe uela ta alumuna va, “Alumughu, aghanna tani pae teva taita, me ulai etana, me aue eaitarainio me utoka amasina. ");
INSERT INTO emi_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ia o taita ateva Boasi etana, kapuna vause tau ngai uungu etoa ughe reirei teeilala, kalakalangina ia etaitalua. Ghaine eleivoo elaa kuluki bali raisi, liu ta la kuukuluki bali raisi. ");
INSERT INTO emi_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ulaa suusuu, ukolikoli me uatoka righi unem aiaao masi ngusungusuaane, me usio kona ghaine euungu. Urau mene laa otuotu etana. Utani toi ta enamanama me eropi mua. ");
INSERT INTO emi_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Nau eteva ange anna tani asekanua, utara tootoonga nongina eaa elaa ghaso. Me umange koukouna atiulu, me uaso sio kalakalaa ta komo kkena. Auena eauliaa va sa ateva umene gheleia.” ");
INSERT INTO emi_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rutu ghe liula me ghe uela va, “Masina, aue ausila ngakapa inangarim.” ");
INSERT INTO emi_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Me Rutu ghe siola nongina la kuukuluki bali, me ghe ghelei ekapala voto alumuna vause ateva ghe auliaa tau lao sio. ");
INSERT INTO emi_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Nau Boasi ghe ruula tani ropi me namanama, ghe masimasila. Vara me ang ghe anna tani asekanua. Ghe lao sio tani aso nongina laghe kaokao aitauaa bali raisi. Rutu ghe kasu emorooia ssola, me ghe mangela koukouna atiulu Boasi, me ghe aso siola ta komo kkena. ");
INSERT INTO emi_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Elo matuaa voo me Boasi ghe soghila. Vara ghe kiria me ghe soghiaala vause ateva ghe asoaso ta komo kkena. ");
INSERT INTO emi_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Me Boasi ghe uela va, “Io see?” Me vause ateva ghe liula me ghe uela va, “Aghi Rutu, kapum vause tau ngai uungu ieghi. Pulela me uakoueghi me emannem ieghi, poli io mangalim ta Elimelek. Liuna avalua o me uunguaam tani sausieghi me aitarainaghi.” ");
INSERT INTO emi_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Me Boasi ghe uela etana va, “Iaue aue earangiseio, natughu, poli angu apasungaala masi voto ghaine, ange lau ekapanaailila masi voto ughe gheleila ta Naomi. Me karika ughusiusi kkai aliki taita atoa, tue peipeiena ila me lo atoa karika peiira. ");
INSERT INTO emi_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ghaine, natughu, urau mene matautu. Aue aghelei ekapa voto ukolomila. Ila akapa taumattu ngatoa tale masaliki eteae oia la kilakila va io eeleiaam me tokatokaam masinaaili. ");
INSERT INTO emi_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Koronna va aghi mangalina aghi taitanim ateva, me uunguaaghi tani ghaa oghio. Me mene kateva taumattu ararimangaliimami eitauaa, ia tee uunguaane tani sausio me ghaa oghio, poli ia kalakalanginaaili ia ta taitanim ateva. ");
INSERT INTO emi_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Asola oia, me aue epai alaa pae ia o taumattu ngateva, me anongo va vaalua nannaane. Arova ealoanna tani aitarainio, masina. Arova karika, aghi aue aghaitarainio. Koronnaaili Iaue ang ghe kilala. Masina, asola oia me aue elue talaua ukasu.” ");
INSERT INTO emi_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Rutu ghe aso siola ta komo kkena Boasi. Ghe tam pai emasina elue talaua me ghe totula. Me Boasi ghe uela va, “Karika toa la mene kila va vause ateva emae sio oia nongina la kuukuluki bali raisi.” ");
INSERT INTO emi_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Boasi ghe uela va, “Ghaa mae sio tuku kaliom atiulu uvaovaoa, me upuleia me uposoa.” Boasi ghe kala tau lao sio bali raisi me ghe sau etoka saela ta Rutu. Ghe ruula me ghe lao sio elo masaliki. ");
INSERT INTO emi_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Nau Rutu ghe laa rekataa sio ta alumuna, alumuna ghe taraiela me ghe uela va, “Ane vaalua? Masina?” Rutu ghe aulia ngakapaailiila voto Boasi ghe gheleila. ");
INSERT INTO emi_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Me Rutu ghe uela va, “Boasi ekala tau mae sio bali raisi. Euela va, ‘Karika erooroo va unim lao ta usau righi bali raisi me ughunusi lao.’” ");
INSERT INTO emi_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Me Naomi ghe uela va, “Alumughu, unim matua atoka me utoitoi, poli karika ngitalu kilakila va sa ateva ninannaa ghaine elutu. Utara Boasi karika aue eainoana amasina lomose ta inangari evira masina.” ");
INSERT INTO emi_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Boasi ghe saela tale liu ngai veluvelu eitaua ngateva kona laghe kupikupi sso, me ghe toka siola. Karika masau, me ghe tarala mangaliirarua ateva me Elimelek, ia o ghe aaulieinia ang ghe reerekata me ghe uela va, “Ei! Mangali, mae toka sio mua!” Ghe lao sio me ghe toka siola. ");
INSERT INTO emi_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Me Boasi ghe kolola kasangaulu (10) namuu laghe aaitoiaa masaliki eteae okae me ghe uela va, “Am mae toka sio.” Me laghe toka siola. ");
INSERT INTO emi_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Me ghe uela ta mangalina va, “Naomi ang ghe oghi mae sio, ghe kasula eMoabi. Me ealoanna va teva taumattu kapuna Elimelek, ia o mangaliitalue ia, epoli tuku kosane ateva. ");
INSERT INTO emi_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Liuna avalua o, me auela va aghauliaa kiem. Arova ualoanna tani polia, upolia ta mataira namu ngatoa me taumattu ngatoa. Me arova utam aloanna tani polia, uauliaa etaghi me akila. Karika mene teva, ta italua nonga. Io tani kalakalanginaaili io, me auena aghi.” Me ghe uela va, “Aue apolia.” ");
INSERT INTO emi_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Boasi ghe uela va, “Arova upoli tuku kosa ateva ta Naomi, ughaa tee Rutu me evausenim ia. Me isaa o kosa elao ta natuna atoa lo ateva taumattu ang ghe matela.” ");
INSERT INTO emi_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Me ia o taumattu ngateva ghe uela va, “Karika amene polia, ta karika aghaloanna va peighi elao ta mene katoa aliki karika va natughu ila. Io upolia me ughaa isaa o voto.” ");
INSERT INTO emi_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Emua arau ta Israeli etoa, arova angila aloanna tani aipolia voto, tani auliaa, me aikolikoliaa righi voto, laghe gheelei evalua toko va taumattu ghe lullu velu unna aikasukasu, me ghe tautau lao ta mene kateva. Isaa o voto laghe gheelei eIsraeli. ");
INSERT INTO emi_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Liuna avalua o me mangalina ateva Boasi ghe uela va, “Io upoli tuku kosa ateva,” me ghe llu tau lao sio kateva tana unna aikasukasu ta kkena. ");
INSERT INTO emi_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Me Boasi ghe uela ta namu ngatoa me ila akapa taumattu ngatoa va, “Am akapa ngam tarala va voto kanna Elimelek, Maloni me Kilion, isaa o ghe tokatoka ta nimana Naomi, ghaine ngapolipoli ekapa. ");
INSERT INTO emi_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Aghi ngaghaaghaa Rutu ia o vauseni nge Moabi eteva, Maloni ghe mate vuluela me evausenighi ia. Kosane Maloni aue etoka ta kapuna atoa. Liu ta la tokatoka, kapuna atoa karika la mene aikkaluaa ararina ateae. Ghaine am akapaaili ngam tarala me ngam nongo akapaailiila voto.” ");
INSERT INTO emi_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Me ila akapa taumattu ngatoa me lo atoa laghe aaitoieinila laghe uela va, “Ue, ngami tarala me ngami nongola. Iaue aue eghelei emasina ta ia o vause ateva ang ghe mae sio ta ngetam. Aue ealutu oroi aliki, nongina tuvuita vause alua aIsraeli etoa ta Resolo me Lia. Me io aue unamuu ta ararimangali eteva eEprata, me aue la kila akapaio eBetlehem. ");
INSERT INTO emi_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Iaue aue etau aatu oroi aliki etaimalua. Aue la oroieili nongina natuna atoa Peresi, natuirarua taita ateva Juda me Tama.” ");
INSERT INTO emi_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Vara me Boasi ghe ghaala Rutu, me ghe vausenna iela me ghe aso teeiela, me Iaue ghe arangiseilaluela, me Rutu ghe kkaaila, me ghe ghaala aliki eteva taita ia. ");
INSERT INTO emi_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Me vause atoa laghe uela ta Naomi va, “Ukkauaa Iaue poli ange tau aatu sio natum taita ateva ia o tuvum ia. Ia aue eaitarainio, me ararina ateae aue enamuu ta aIsraeli etoa. ");
INSERT INTO emi_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Alumum ealoannaailiio me io tee ualoannaailiia. Arova natum taita ghaitu, karika aue ughele ailousieinila nongina uaailousiaa alumum vause ateva. Liuna avalua o me ia o natum taita ateva ang ghele lutula, aue esausi tokatokaam, me aue eaitarainio nau uvause namuu.” ");
INSERT INTO emi_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Naomi ghe saula aliki eteva. Ghe tokatoka teeia, me ghe aaitarainia. ");
INSERT INTO emi_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Mene katoa vause laghe tokatoka aitauaa laghe uela va, “Naomi ang ghele saula aliki eteva taita ia,” me laghe asela ararina ate ta Obet. Tamane ia Jesi, me Jesi tamane ia King Deivit. ");
INSERT INTO emi_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Vituu etoa ta Peresi: Peresi ghe alutula Eseroni. ");
INSERT INTO emi_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Eseroni ghe alutula Ram, me Ram ghe alutula Aminadab. ");
INSERT INTO emi_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab ghe alutula Nasoni, me Nasoni ghe alutula Salmoni. ");
INSERT INTO emi_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmoni ghe alutula Boasi, me Boasi ghe alutula Obet. ");
INSERT INTO emi_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Me Obet ghe alutula Jesi, me Jesi ghe alutula Deivit. ");
INSERT INTO emi_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Inangarina Iaue ghe mae sio ta Jona natuna ia Amittai. Ghe uela va, ");
INSERT INTO emi_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Kasula me ulao eNinive, kinatama masaliki taatara ateae. Ulaa ppooa ngaotu eeleiaaira karika masina, poli ataatara va ang ghe namungaili ila.” ");
INSERT INTO emi_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Jona ghe anna tani ilou eisulia tee Iaue. Karika ghe lao sio eNinive, ta ghe lao ppae sio tale kateae ppae masaliki eTarsis. Ghe siola eJopa me ghe paela anua ateva ghe aloanna tani lao eTarsis. Ghe polila salana me ghe saesaela etana tani lao eTarsis, tani ilou eisulia tee Iaue. ");
INSERT INTO emi_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Me Iaue ghe suula kinatama kuukuu ttasi eteva ghe lutu teeilala elamana, ttasi vaoo ateva namungaili ia. Anua ateva ghaisa ngarighi ghe tapolapolaka. ");
INSERT INTO emi_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Me tau ngai uungu etoa tale anua ateva laghe tiuaala tani matautu, me laghe kolokoloa nganamuu kapuira kuturu etoa. Me laghe tiuaala tani sau veluvelu sio ghinna atoa elamana tani ghelei oeakana anua ateva. Me Jona ghe siola arau euu tale paa nganua ateva. Ghe laa sio aso me ghe asekanuela me ghe llusula. ");
INSERT INTO emi_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Kapteni eteva ghe siola etana me ghe uela etana va, “Vaalua me uaseasekanua? Totula me ukolokoloaa kuturum eteva. Koti ia aue ealousiusi teeita me aue esausita, me karika aue ita mate.” ");
INSERT INTO emi_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Me tau ngai uungu etoa tale anua ateva laghe uela va, “Ita piti arariita me ita kape nonga katengaata. Lo ateae arari ita kapea akasina, ia aue ita kila va, ia o taumattu ngateva mausina me ngita sessa.” Laghe ghelei evaluela o, me ararina ateae Jona ghe otuela. ");
INSERT INTO emi_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Vara me laghe uela etana va, “Uauliaa kiemami mausi saa me voto sesa ange saetala? Saa uunguam? Me aliaa io, me eaa tanganuem? Me see ila kapum atoa?” ");
INSERT INTO emi_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Me ghe uela etaira va, “Aghi aHibru ieghi. Akakkauaa Iaue, God epona liu ghe gheleila paamanu eteva me kosa ateva.” ");
INSERT INTO emi_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Jona ghe uela ta tau ngai uungu etoa tale anua ateva va, “Aghe ilou eisuliaala ta Iaue.” Laghe nongola me laghe matautu saasakiaala. Me laghe uela ta Jona va, “Vaalua me ughe gheleila voto oia sesaaili?” ");
INSERT INTO emi_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Laghe uela etana va, “Ami saa etam me aue lueiemami?” Poli ttasi eteva ange sesaaili. ");
INSERT INTO emi_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Me ghe uela etaira va, “Am saueghila me am sau velueghi sio elamana me aue luei, ta mausighi me kinatama ttasi eteva euviuviem.” ");
INSERT INTO emi_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Me karika, ta tau ngai uungu etoa tale anua ateva laghe oseose paraparasi tani sso elae, me karika laghe rooroo, poli ttasi eteva ang ghe naanamungaili. ");
INSERT INTO emi_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Vara me laghe kolokolo saela ta Iaue. Laghe ue va, “O Iaue, urau mene tau veluemami va ami mate, ta poli ngami ghaaghaa velu maamaulueane ia oia taumattu ngateva. Me urau mene tau velu righi voto sesa eailutua tale maamaulueaaimami, poli ngami uviuvi emate taumattu ngateva karika righi eeleiaane sesa, poli io Iaue, ughelei voto tale aloaloannaam.” ");
INSERT INTO emi_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Laghe saula Jona me laghe sau velue siola elamana, me ghe lueila. ");
INSERT INTO emi_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Tau ngai uungu etoa tale anua ateva laghe matautangailila Iaue. La ghe gheleila aiaavusuvusuena, me laghe auliaala inangariira nialokoi ta Iaue. ");
INSERT INTO emi_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Iaue ghe suula kinatama kko ateva ghe olomila Jona. Ghe laa sso toka kotolu llaa me voo ta kova kko ateva. ");
INSERT INTO emi_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Elome tale kova kko ateva me Jona ang ghe looloo sae ta Iaue. ");
INSERT INTO emi_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Ghe ue va, “Voto sesa eghe lutu teeieghila, liuna avalua o me aghe kolo taula Iaue, me eghe liula. Aghe tokatoka tale voto ateva sesa ia, llo taumattu matena la tokatoka etana, me aghe kolokolo saela etam, me ughe nongoaghila. ");
INSERT INTO emi_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Ughe sau velueghi sio mae arau euueili tale paamanu eteva. Manu eteva ghe akoueghila me ugheleila kinatama kotoo atoa la ghasuula epona etaghi. ");
INSERT INTO emi_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Aghe annaa va, angu ghe tiu velueghila tale taataram me karika, ta aue aghi amene tara alem ale manga ateva. ");
INSERT INTO emi_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Kotoo atoa la ghasuula epona etaghi, me egheleieghila gharighi tau ghele arropieghi me malionge ateva ghe akoueghila. Me rarrasa ngelamana atoa la ghakou taliaala urughu eteva. ");
INSERT INTO emi_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Aghe siola arau tale liue motouru etoa tale paamanu eteva. Sesa voto ia nongina va atokatoka laalaa liu tale ale mata voovoo. Iaue, io kapughu Goto io, ughe ghaa oghieghila me aghe kasu vulila sesa voto ateva. ");
INSERT INTO emi_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Nau maamaulueaghi ange kapakapa, aghe annaala Iaue, me aghe looloo saela etam tale alem ale manga ateva. ");
INSERT INTO emi_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Llo taumattu ghe kakkaua kamena atoa kuturu, laghe kasu vulila aielousiaam ateva. ");
INSERT INTO emi_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Aghanna tani kkaueinio tale nikkinari me tale niaiaavusuvusuena, tani tau sae ararim ateae. Isaa akapa voto aghe gheleila inangari nialokoi etana, aue aghelei. Iaue nonga erooroo tani asaangita.” ");
INSERT INTO emi_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Me Iaue ghe auliaala ta kko ateva, me kko ateva ghe laa sso lue atoka Jona elae. ");
INSERT INTO emi_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Inangarina Iaue ghe mene mae sio ta Jona ghaluene va, ");
INSERT INTO emi_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Kasula, me ulao eNinive, kinatama masaliki taatara ateae. Ulaa ppooa ngaotu inangari atau aatu.” ");
INSERT INTO emi_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Jona ghe aimuli teela inangarina Iaue me ghe lao sio eNinive, kinatama masaliki taatara ia. Urooroo tani kasu talia etana kotolu nau. ");
INSERT INTO emi_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Jona ghe kasula me ghe laa rekata sio. Aitiutiu eteva nau ghe rekatala eNinive, ghe tiuaala tani ppooaa ta taumattu ngatoa. Ghe ue va, “Ghaatingaulu (40) nau aue eruu, me Ninive aue God euvi tuuturungia.” ");
INSERT INTO emi_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Taumattu nge Ninive atoa laghe aiesoaala ta God. Laghe samaa seela va, “Ita rau mene namanama, me ita rau mene ropi.” Me laghe asaela ghinna nialousiusi, namuu me aliki etoa. ");
INSERT INTO emi_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Inangarina ghe laa rekata sio ta kingi nge Ninive ateva. Kingi eteva ghe tingina vulu saela aitokatokane ateva, me ghe llu vella unna aiaasae ateva, uneira ia namu ngatoa, me ghe asaela ghinna nialousiusi, me ghe toka siola tale au kura. ");
INSERT INTO emi_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Me ghe uela va, “Am laa aulia ngakapa see eNinive va, “‘Aghi me kapughu namu ngatoa ami uela va, karika teva taumattu me ghaata kkena emene ropi, me enamanama. ");
INSERT INTO emi_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Am akapaaili taumattu me ghaata kkena atoa am asae ghinna nialousiusi. Am kolokolo anamuu sae ta God. Me am oghi vulu sesa gheeleiaaimim me am ruu tani kiiuaa mene kateva. ");
INSERT INTO emi_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Arova ita ghelei evalua o, koti God aue eaikolikoliaa nannaane tani sessaia me karika ita mene mate.’” ");
INSERT INTO emi_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Laghe oghi vulula eeleiaaira sesa, me God ghe tarala voto laghe gheleila, me ghe aikolikoliaala nannaane, me karika ghe gheleila voto ghe uela va eghelei. ");
INSERT INTO emi_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Jona ghe sessai saasakieiniela me ghe tam masimasila. ");
INSERT INTO emi_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Ghe looloo saela ta Iaue, ghe ue va, “O Iaue, karika aghe kasu vuli tanganueghi me aghe kilala va karika aue utturu eNinive. Liuna avalua o, me aghe ilou eisuliaala tani lao eTarsis. Aghe kilakila va io masinaaili io, me karika urooroo tani tturuu, me karika esessai parasio. Unem niaielousi namungaili me gharovaeaata ta uaikolikoliaa nannaam. ");
INSERT INTO emi_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","O Iaue, ughaa velu maamaulueaghi, poli arova amate aue emasina. Arova atam mate, karika aue emasina.” ");
INSERT INTO emi_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Iaue ghe liula me ghe uela va, “Jona! Vaalua, masina ta esessaio?” ");
INSERT INTO emi_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Jona ghe kupi vulu ghoala kinatama masaliki taatara ateae, me ghe lao sio ta pai sinaka esae. Ghe gheleila natu paapali erighi tani toka me tani tara sa ateva ghe mene lutu tale kinatama masaliki taatara ateae eNinive. ");
INSERT INTO emi_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Vau ngepona Iaue ghe apinosala ngaapa ateae, tani apallungia. Me ghe sausia, poli karika ghe annaa me ateateaa righi masina. Jona ghe masimasiangailiia ia o ngaapa ateae. ");
INSERT INTO emi_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Vara elue talaua ta mene kateva nau, God ghe suula gharighi natu voto erarra tani laa nama amate ia o ngaapa ateae, me emmate. ");
INSERT INTO emi_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Nau ta sinaka ateva ghe saela, God ghe suula kuukuu eteva aanasa ia ghe mae sio ta pai nge sinaka esae, me sinaka ateva ghe sinakila uruna ateva Jona, me matane ghe leeleela, me ang ghe anna tani katuu. Me Jona ang ghe aannaa va, “Arova amate aue emasina. Arova atam mate, karika aue emasina.” ");
INSERT INTO emi_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Vara me God ghe uela ta Jona va, “Vaalua, masina ta esessaio tale ngaapa ateae?” Me Jona ghe liula me ghe uela va, “Ue! Ange sessaieiliieghila, me aghanna va arova aghele mate.” ");
INSERT INTO emi_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Iaue ghe uela va, “Uaalousiusi tee ngaapa ateae io karika ughe uungu aanasala etana, me karika ughe apinosaiela, ta ghe nim pinosala eleivoo, me mene kateva voo ghe mmatela. ");
INSERT INTO emi_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Aghi tee aghalousiusieili tee eNinive, ta oroieili taumattu ngatoa, tani ioila elaulau kateva ai ghaluengaulu airari (120,000). Me karika la rooroo tani kila va eaa sesa me eaa masina, me oroinaaili tee ghaata kkena atoa.” ");
INSERT INTO emi_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Lo ateva oia vuku eaauliaa tuvuna atoa Iesu Karisto. Iesu tuvuna ia Deivit. Me Deivit tuvuna ia Abraham. ");
INSERT INTO emi_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham tamane ia Aisiki, me Aisiki tamane ia Jekop, me Jekop tamane ia Jiuda me tuena atoa me nengane atoa, ");
INSERT INTO emi_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","me Jiuda tamairarue ia Peres me Sera, kinairarua ta Tamar, me Peres tamane ia Hesron, me Hesron tamane ia Ram, ");
INSERT INTO emi_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","me Ram tamane ia Aminadab, me Aminadab tamane ia Nason, me Nason tamane ia Salmon, ");
INSERT INTO emi_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","me Salmon tamane ia Boas, kinna ta Reiab, me Boas tamane ia Obet, kinna ta Rutu, me Obet tamane ia Jesi, ");
INSERT INTO emi_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","me Jesi tamane ia King Deivit, me Deivit tamane ia Solomon, kinna Solomon manna akasina ia Uraea, ");
INSERT INTO emi_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","me Solomon tamane ia Rehoboam, me Rehoboam tamane ia Abia, me Abia tamane ia Eisa, ");
INSERT INTO emi_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","me Eisa tamane ia Jehosapat, me Jehosapat tamane ia Jehoram, me Jehoram tamane ia Usaea, ");
INSERT INTO emi_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","me Usaea tamane ia Jotam, me Jotam tamane ia Eihas, me Eihas tamane ia Hesikaea, ");
INSERT INTO emi_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","me Hesikaea tamane ia Manase, me Manase tamane ia Eimon, me Eimon tamane ia Josaea, ");
INSERT INTO emi_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","me Josaea tamane ia Jehoiasin me nengane atoa. Isaa o nau laghe soallotila aIsraeli etoa me laghe siola eBabilon. ");
INSERT INTO emi_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ghe mene tiuaala nau eteva laghe siola eBabilon: Jehoiasin tamane ia Sealtiel, me Sealtiel tamane ia Serubabel, ");
INSERT INTO emi_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","me Serubabel tamane ia Abiut, me Abiut tamane ia Eliakim, me Eliakim tamane ia Eisor, ");
INSERT INTO emi_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","me Eisor tamane ia Sadok, me Sadok tamane ia Akim, me Akim tamane ia Eliut, ");
INSERT INTO emi_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","me Eliut tamane ia Eleasar, me Eleasar tamane ia Matan, me Matan tamane ia Jekop, ");
INSERT INTO emi_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","me Jekop tamane ia Josep, manna ia Meri, ta ngetana Meri Iesu ghe lutula, la aseasea va Mesaea ia. ");
INSERT INTO emi_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Liuna avalua o me tuvuna atoa Abraham ghe tiuaala me ghe mae sio ta Deivit erooroo kasangaulu ghaata (14) vituu. Me ghe tiuaala ta Deivit me ghe ghaala nau eteva laghe siola eBabilon erooroo kasangaulu ghaata (14) vituu. Me ghe mene tiuaala nau laghe siola eBabilon me ghe ghaala nau ta Mesaea erooroo mene kasangaulu ghaata (14) vituu. ");
INSERT INTO emi_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kiukiuna Iesu Karisto nau eteva ghe lutula, isaa avalua toko. Kinna ta Meri, laghe uela va aue eghaa Josep me emanna ia, me karika lalu ghe aso aitauaa me laghe tarala va tale sarasarakaniaane Spirit Manga ateva me Meri ghe kkaaila aliki eteva. ");
INSERT INTO emi_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josep ghulughuluena ia, ghe nongola va Meri ang ghe suusunuku, ghe tam annala tani ghelei epalata Meri ta mataira taumattu ngatoa, liuna avalua o me ghe nnaala va enim ruu einao inangari etingiu etairarua. ");
INSERT INTO emi_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nau eteva Josep ghe annangaili llo, arovaeaata ta kapuna ensolo ateva Vau eteva ghe mae sio etana tale niasoasopoi eteae. Me ghe auliaala etana va, “Josep io tuvuna io Deivit, urau mene matautu tani ghaa Meri va evausenimi ia. Unongo, ia o aliki eteva ekakkaaia ta kovana, Spirit Manga ateva ghe taue lao sio etana. ");
INSERT INTO emi_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Aliki eteva aue elutu etana, taita ia, me ukolo ararina ateae ta Iesu, poli ia aue easaangi kapuna taumattu ngatoa tale kaluira ssavoto.” ");
INSERT INTO emi_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Isaa akapa llo Vau eteva ghe auliaala ta propete ateva emua arau ang ghele kaurekatila, ghe uela va, ");
INSERT INTO emi_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Am nongola, kateva vause karika ghe aso tee teva taita aue esunuku me emolena aliki eteva taita ia, me aue la kolo ararina ateae ta Immanuel” — malloeana va “God etokatoka teeita.” ");
INSERT INTO emi_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nau eteva Josep ghe anguula, ghe gheleila voto kapuna ensolo ateva Vau eteva ghe auliaala etana, me ghe ghaala vause ateva. ");
INSERT INTO emi_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Me karika ghe aso teeiela lomosina ta ghe molenaala aliki eteva, taita ia. Me ghe kolola ararina ateae ta Iesu. ");
INSERT INTO emi_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Meri ghe molenaala Iesu eBetlehem nge Jiudia nau ta King Herot. Iesu ang ghe lutula me emulina tau ngalomasaanga atoa, tale pai nge sinaka esae laghe mae sio eJerusalem ");
INSERT INTO emi_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","me laghe aaikolomaa see va, “Eaa ia aliki eteva ghe lutula, kapuira Kingi ia aJiu etoa? Ami ghe tarala kattona ateva tale pai nge sinaka esae ativilau, me ami mae sio tani kkaueinia.” ");
INSERT INTO emi_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nau eteva King Herot ghe nongola isaa o inangari ghe annangailiila, me tee ila akapa taumattu nge Jerusalem atoa, ila tee laghe anna ngatingina. ");
INSERT INTO emi_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Vara me ghe kolola namu ngatoa tana pristi me tau ngalomasaanga atoa tale inangari nipaopao kapuira ila taumattu ngatoa, laghe mae sio tani velu eitauaa, me ghe kolomilala va eaa Mesaea ngateva aue elaa lutu. ");
INSERT INTO emi_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Me laghe liula etana va, “Aue elutu eBetlehem nge Jiudia. Poli propete ateva ghe pitila inangari isaa avalua toko, ");
INSERT INTO emi_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Me io Betlehem tale kosa nge Jiuda, karika tani ghaunaaili ararim ateae tale isaa akapaaili masaliki nge Jiuda, ta poli ta ngetam aue taumattu ngateva namuu ia aue etingina. Me ia aue eaitoiaa kapughu aIsraeli etoa.’” ");
INSERT INTO emi_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herot ghe nongola isaa o inangari me ghe suu eisuliaala inangari ta tau ngalomasaanga nge sinaka esae atoa va la laa taraia. Nau eteva laghe lao sio, ghe kolomi emasinailala va, “Elovisa am ghe tani tarala katto ateva ghe kaurekatila?” ");
INSERT INTO emi_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Vara me ghe sungilala va, “Am lao sio eBetlehem, me am laa pae aotu va eaa ang ghele lutula ia o aliki eteva. Nau eteva am tani taraia am mene mae auliaa etaghi, me aghi tee alaa kkaueinia.” ");
INSERT INTO emi_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Nau laghe ruula tani nongo inangarina Kingi, laghe kasula. Laghe laolao me laghe mene tarala katto ateva, laghe taraiela esinaka esae. Nau eteva laghe mene tarala katto ateva laghe masimasieiliila. Ia o katto ateva ghe muemueinila elaolao me ghe tokala epona kona aliki eteva ghe asoaso. ");
INSERT INTO emi_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tau ngalomasaanga atoa laghe kupi ssola tale ale ateva, me laghe tarala aliki eteva me kinna ta Meri. Laghe tturru siola me laghe kkaueiniela, me laghe otila uneira aikaai, me laghe kapela golo, frankinsens, me murr tani taula etana. ");
INSERT INTO emi_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","God ghe auliaala kieira tale niasoasopoi va la rau mene lao nongina Herot etokatoka, me laghe lao ppae sio tale katikirighi salana me laghe lao sio tanganueira. ");
INSERT INTO emi_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Laghe kasula, me kapuna ensolo ateva Vau eteva ghe rekataala ta Josep, tale niasoasopoi eteae. Ensolo ateva ghe uela etana va, “Totula, me ughaa aliki eteva me kinna, me amatolu kasu parasi sio eIjip. Am sio toka eIjip, aue aghauliaa etam va elovisa am mene kiri sae. Poli Herot epaepae aliki eteva tani uvi ematea.” ");
INSERT INTO emi_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josep ghe totula me ghe ghaala aliki eteva me kinna, me eleivoo arau laghe siola eIjip. ");
INSERT INTO emi_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Josep ghe tokala eIjip me ghe ghaala nau eteva Herot ghe matela. Isaa o voto ghe lutula tani akaurekati llo Vau eteva ghe auliaala ta propete ateva emua arau. Ghe uela va, “Natughu taita ateva ghe tokatoka eIjip, me aghe mene kolo veluela eIjip.” ");
INSERT INTO emi_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nau eteva Herot ghe kilala va tau ngalomasaanga atoa laghe kameala me karika laghe mene kiriaa lao sio, ghe sessai emateala, me ghe uela va la uvi emate isaa akapaaili natu ngaliki taita eBetlehem me llo masaliki etokatoka akalakalaa, aliki aneira ninamanama etittiuaa ta ghaluae me esiosio aloi, poli tau ngalomasaanga atoa laghe uela va laghe tarala katto ateva ghe kaurekatila ghaluae ninamanama ang ghe lange sio. ");
INSERT INTO emi_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Llo propete Jerimaea ghe auliaala ang ghele tani kauerekatila, ghe uela va, ");
INSERT INTO emi_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Laghe nongola lingi ngalo ateva eRama. Laghe ngangngala me laghe ale amate, Resol ghe ngangngala natuna atoa. Karika ghe aloanna righi airuui ngalo, poli ila akapa natuna atoa ngila ghe matela.” ");
INSERT INTO emi_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nau Herot ghe matela, ensolo ateva ghe rekatala ta Josep tale niasoasopoi eteae eIjip ");
INSERT INTO emi_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","me ghe auliaala etana va, “Ughaa aliki eteva me kinna me amatolu mene sae eIsrael. Ta lo atoa laghe aaloanna tani uvi emate aliki eteva angila ghe mate akapala.” ");
INSERT INTO emi_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josep ghe totula me ghe ghaala aliki eteva me kinna me laghe saela eIsrael. ");
INSERT INTO emi_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Vara me Josep ghe nongola va ouna ateva King ta Arkelaus ghe ghaala liuna ateva tamana ta Herot eJiudia me ghe matautula tani lao. Vara me God ghe auliaala kiena tale niasoasopoi eteae va erau mene toka eJiudia, me ghe saela eGalilii. ");
INSERT INTO emi_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ghe lao sio tani toka tale masaliki eteae laghe aseasea va eNasareti. Isaa o llo propete atoa laghe auliaala ghe tani kaurekatila va, “La aseasea va aNasareti ia.” ");
INSERT INTO emi_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tale isaa o nau Jon tau ngai aasuu ia ghe mae sio me ghe tokatoka tale voto karika righi taumattu etana eJiudia. Ghe poppooaa tale taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ghe ue va, “Am nna ngaioghioghiaa poli ararimangali ngepona liu eteva ange aakalakalaa.” ");
INSERT INTO emi_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ia o taumattu ngateva ta Jon, God ghe aulieiniela ta propet Aisaea va, “Tale voto ateva karika righi taumattu etokatoka etana, lingi ngalo taumattu ngateva ekolokolo, eue va, ‘Am aimonomonosiaa salane atikirighi Vau eteva, am ghelei eghulughuluenala akapa salane.’” ");
INSERT INTO emi_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Unna aiaasae Jon laghe gheleila tale uu kamolo, me ghe ai-iriaa paisi eteae viliki vulumakao ia. Ghe namanama toto me iruena nge tapaa tuvui. ");
INSERT INTO emi_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tale isaa o nau taumattu nge Jerusalem me isaa akapa eJiudia me taumattu ghe tokatoka kalakalaa tale ateo ateae eJodan laghe mae sio ta Jon. ");
INSERT INTO emi_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Laghe aaulia ngaotu kaluira ssavoto me ghe aasuula tale ateo ateae eJodan. ");
INSERT INTO emi_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jon ghe taatara va oroieili Paresi me Sadiusi etoa laghe mae sio va easuula. Vara me ghe uela etaira va, “Am nongina va natuira iem katu ngatoa! See euela etaimim va am ilou vuli sessaiaane Vau eteva ange anna tani lutu etaimim? ");
INSERT INTO emi_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Am kuneaa righi ueimim tani apasunga va ngam ghe vella kaluimim ssavoto. ");
INSERT INTO emi_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Am rau mene ue va, ‘Ami tuvuna amami Abraham.’ Poli aghaauliaa etaimim va God erooroo tani ghelei isaa o atu etuvuna Abraham. ");
INSERT INTO emi_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kulum ateva aimonomonosiaanna ia tani tue akatuu ai, me isaa o ai karika ekuukuneaa masi uene aue la tue me la sau velu sae tale kuraa ateae. ");
INSERT INTO emi_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Aghi aghaasuuem tale manu tani apasunga va ngam ghe nna ngaioghioghiaala. Me taumattu ngateva auena emae, ia sarasarakaniaane elaulau sarasarakaniaaghi, karika masi taumattu ngieghi tani sau unna aikasukasu. Ia aue eaasuuem tale Spirit Manga ateva me tale kuraa ateae. ");
INSERT INTO emi_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ia emaemae arova taumattu ngateva eposoposo unna poko ateva aisaraki uiti, tani pola uiti me kou uiti. Me eatoka aitauaa uiti tale ale ngai atoka uiti eteva, me aue evelu sae kou uiti tale kuraa ateae karika erooroo tani pala.” ");
INSERT INTO emi_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tale isaa o nau Iesu ghe kasula eGalilii me ghe mae sio eJodan va Jon easuua. ");
INSERT INTO emi_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jon ghe gheeghelei rungainia tani ue va, “Emaamasina arova io uasuueghi, vaalua me umae sio etaghi?” ");
INSERT INTO emi_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Iesu ghe liula etana va, “Masina. Ghaine ughelei nongina aghauliaa. Tale isaa o salana, ita ghelei isaa akapaaili voto God ealoanna va ita ghelei.” Liuna avalua o me Jon ghe aimulisi teela inangarina Iesu. ");
INSERT INTO emi_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nau Jon ghe asuula Iesu, Iesu ghe laa sae tingina epona, me epona liu ghe otiela me ghe tarala Spiriti eteva kanna ia God ghe sio mae nongina ghila ateva valusu ia, me ghe toka saoaala etana. ");
INSERT INTO emi_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Me epona liu kateva lingi ngalo ghe ue va, “Ia o natughu eteva aghaailousieinia, me masimasiaaghi ta ngetana namungaili.” ");
INSERT INTO emi_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tale isaa o nau Spiriti eteva ghe ssoaala Iesu tale voto ateva karika righi taumattu etana va namu ngateva ta raroai etoa etootoongainia. ");
INSERT INTO emi_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Iesu ghe naela ghe roola ghaatingaulu (40) llaa me ghaatingaulu voo, me airuuruu tale isaa o nau, ghe maloola. ");
INSERT INTO emi_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Vara me saikame ateva ghe mae sio tani rekataa etana, me ghe uela etana va, “Arova koronna va Natuna io God, uauliaa tale atu o me ekoli me everete.” ");
INSERT INTO emi_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Iesu ghe liula me ghe uela va, “Uru ngai Manga ateva eue va, ‘Karika taumattu ngatoa va la maamaulue nonga tale inana, karika, ta nau la aimulisi tee isaa akapaaili inangarina God aue la maulue.’” ");
INSERT INTO emi_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ghe aulia ngavaluela o, me namu ngateva ta raroai etoa ghe mene laoainie sio tale masaliki taatara ateae manga ia. Me ghe saeainiela tale pungani ale manga ateva, ");
INSERT INTO emi_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","me ghe uela etana va, “Arova koronna va Natuna io God, ulove velu sio, poli Uru ngai Manga ateva eauliaa va, “‘Aue esuu kapuna ensolo atoa aue la sau evukalaio me karika aue utaghua kekem tale atu.’” ");
INSERT INTO emi_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iesu ghe uela etana va, “Uru ngai Manga ateva emene ue va, ‘Urau mene tootoonga Vau eteva kapum Goto ia.’” ");
INSERT INTO emi_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Namu ngateva ta raroai etoa ghe mene ghaaie saela tale motouru eteva iaaili epona, me ghe apasungaala patunganua namu ngakapa atoa tale kosa ateva oia, me masi voto atoa etaira. ");
INSERT INTO emi_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Me ghe uela ta Iesu va, “Aue atau aatu isaa akapaaili voto angu tarala, arova ussuuiaa me ukkaueinieghi.” ");
INSERT INTO emi_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iesu ghe uela etana va, “Vellaio Satana, ta poli Uru ngai Manga ateva eauliaa va, ‘Ukkauaa Vau eteva kapum Goto ia, me uaimulisi teeia nonga.’” ");
INSERT INTO emi_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Me namu ngateva ta raroai etoa ghe kasu vuliela, vara me ensolo atoa laghe mae sio tani sausia. ");
INSERT INTO emi_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nau eteva Iesu ghe nongola va Jon ie tale ale mata voovoo, ghe oghi lao sio eGalilii. ");
INSERT INTO emi_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ghe kasu vulila eNasareti me ghe lao sio tani toka eKapenium tale ateo talia ngateae tale kosaira ararimangali elua ta Sebulon me Naptalae. ");
INSERT INTO emi_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iesu ghe gheleila isaa o voto tani akauerekati inangari propet Aisaea ghe auliaala, ");
INSERT INTO emi_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Taumattu tale kosa nge Sebulon me Naptalae, kosa etokatoka tale salana atikirighi elaa ghoa elamana, me kosa tale pai kativilau tale ateo ateae eJodan, Galilii kosaira ia taumattu ngeleka atoa. ");
INSERT INTO emi_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Isaa o taumattu etokatoka tale saurrom ateva ngila ghe tarala paka mallanga ateva, lo atoa la tokatoka tale saurrom masau ta Vau ngepona ateva mallanga ateva ang ghe llaala etaira.” ");
INSERT INTO emi_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tale isaa o nau Iesu ghe tiuaala tani ppooaa, ghe ue va, “Am nna ngaioghioghiaa, poli ararimangali eteva epona liu ange aakalakalaa.” ");
INSERT INTO emi_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesu ghe kasukasu elaolao tale sama ateo talia ngateae eGalilii, me ghe tarala tue me nenga alua, Saemon la kolokoloa va Pita etana, me nengane ta Andru. Lalu ghe lukuluku ta tau ngelamana ilalua. ");
INSERT INTO emi_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Me ghe uela ta ngetairarua va, “Amalu mae usieghi me aue agheleiemalua me amalu tau ngai luku taumattu.” ");
INSERT INTO emi_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Me arovaeaata ta lalu ghe velu elokoila uvena me lalu ghe usiela. ");
INSERT INTO emi_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Iesu ghe mene kasu tee lao sio me ghe mene tarala mene ghalua tue me nenga, Jon me Jeimis, natuna ilalua Sebedi, lalu ghe tokatoka tee tamairarua ta Sebedi, laghe anuunumi uneira uvena epona tale paanaka ateva, me Iesu ghe kololaluela. ");
INSERT INTO emi_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Karika lalu ghe aitoila ta lalu ghe kkure vulula paanaka ateva me tamairarua me lalu ghe usiela. ");
INSERT INTO emi_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesu ghe kasukasu ekapa see eGalilii, me ghe aapasunga tale aleira ale nivelu eitauaa me ghe poppooaa masi kiukiuna ararimangali eteva, me ghe gheeghelei emasina isaa akapa asease sessa atoa. ");
INSERT INTO emi_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kiukiuna Iesu ghe lao akapa seela tale provinsi eteva eSiria, me taumattu ngatoa laghe maemaeaa asease tau sessa atoa, lo atoa ghe anoanongi ila, me lo atoa raroai etoa laghe kupilala, me lo atoa laghe oo, me lo atoa karakanna ila, me Iesu ghe ghelei emasinailala. ");
INSERT INTO emi_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Oroi ila taumattu nge Galilii etoa me taumattu tale Kasangauluae Masaliki Taatara, me aJerusalem atoa, me aJiudia ngatoa me lo atoa tale pai kativilau tale ateo ateae eJodan, laghe usiusie see. ");
INSERT INTO emi_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nau eteva Iesu ghe tarala taumattu ngatoa laghe oroieili ila, ghe saela tale motouru eteva, me ghe toka siola, me kapuna disaepolo atoa laghe mae sio etana. ");
INSERT INTO emi_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Me ghe tiuaala tani apasunga etaira va, ");
INSERT INTO emi_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Aue emasinaaili ta lo atoa la kilakila va masi uunguaane ateva God karika ia etaira me la aloannaaili tani ghaaia, ta ararimangali ngepona liu eteva aue anueira ia. ");
INSERT INTO emi_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Aue emasinaaili ta lo atoa la ghaalousiusi, ta God aue airuui ngalo ia ta ngetaira. ");
INSERT INTO emi_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Aue emasinaaili ta lo atoa la siosioaa nannaaira, poli kosa akapa ateva aue kaluira ia. ");
INSERT INTO emi_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Aue emasinaaili ta lo atoa la ghaaloannaaili ghulughuluena, nonginaaili lo ateva emaamaloo ealoannaaili tani namanama, me ekaakangngata tani ropi, ta God aue eghelei eroorooaa aloannaaira. ");
INSERT INTO emi_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Aue emasinaaili ta lo atoa la aalousiusi tee mene katoa, ta God aue ealousiusi teeila. ");
INSERT INTO emi_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Aue emasinaaili ta lo atoa urunguitaniira raarangisana, ta aue la tara God. ");
INSERT INTO emi_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Aue emasinaaili ta lo atoa la ghaalokoi luei, ta God aue easela va natuna ila God. ");
INSERT INTO emi_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Aue emasinaaili ta lo atoa la ghaaghaa mmarikana mausi masi gheegheleiaaira, ta ararimangali ngepona liu eteva aue anueira ia. ");
INSERT INTO emi_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Aue emasinaaili etaimim arova taumattu ngatoa la pilosiem, me la ghelei saasakiaa teeiem, me la ghaikameaa teeiem, poli ararighi eteae. ");
INSERT INTO emi_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Voto sesa laghe tani gheeghelei tee propete atoa emua arau, isaa oia la mene gheeghelei teeiem. Am masimasi etingina, ta aipoliimim namungaili isaa epona liu. ");
INSERT INTO emi_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Am uela am tale kosa ateva oia, me arova namina ateva uela ateva ekapa, o vaalua aue ita mene gheleia me emene tue namina? Ta ia o ange kapala maamasikaniaane. Taumattu ngatoa aue la nim sau velua me la sakieinia tale kosa ateva. ");
INSERT INTO emi_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Am mallanga am tale kosa ateva. Masaliki taatara ateae etokatoka epona tale motouru, karika erooroo tani aisulia. ");
INSERT INTO emi_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Me tee taumattu ngatoa karika la ghaarokoti kuraaira lam ateae va la ghaatoka pakeainia tale keru. Ta la ghaatokaie sae tale aitiitinginane, ta etautau lao mallanga tale taumattu ngatoa tale ale ateva. ");
INSERT INTO emi_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ia avalua o me, am apasunga mallangiimim tale taumattu ngatoa, me aue la tara masi gheeleiaaimim, me aue la tau sae ararina ateae Tamaimim epona liu. ");
INSERT INTO emi_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Am rau mene annaa va aghe mae sio tani ghaa velu inangari nipaopao me inangariira propete atoa. Karika! Aghe tam mae sio tani ghaa velu, ta aghe mae sio tani ghelei eroorooa. ");
INSERT INTO emi_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Aghaaulia ngakoronna etaimim va elomarase me kosa ateva oia aue ekapa, me aue karika teva mata nginangari ghaunaaili tale inangari nipaopao aue ekapa, karika, lomosina ta llo God ghe auliaala tale inangari nipaopao etani lutu ekapa. ");
INSERT INTO emi_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Arova see ia taumattu ngateva etam aimulisi tee tuku kateva tale inangari nipaopao me eapasunga ta mene katoa tana taumattu tani tam aimulisi tee, karika aue enamuu tale ararimangali ngepona liu eteva, me lo ateva eaimulisi tee, ia ararina ateae aue enamuu tale ararimangali ngepona liu eteva. ");
INSERT INTO emi_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Aghaauliaa etaimim va, arova gheegheleiaaimim ghulughuluena etam lau masi gheegheleiaaira Paresi etoa me tau ngai aapasunga ngatoa tale inangari nipaopao, karika aue am sso tale ararimangali ngepona liu eteva. ");
INSERT INTO emi_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ngam ghe nongo vella va laghe auliaala ta lo atoa emua arau va, ‘Am rau mene aiuvi emate. Me arova lo ateva eaiuvii emate aue elaa ghaisakei.’ ");
INSERT INTO emi_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Me aghi aghaauliaa etaimim va, lo ateva esessaia ta nengane ateva, aue eaisakei, me see eue ta nengane va, ‘Alo kapakapa ateva,’ aue elaa ghaisakei ta kansolo atoa, me lo ateva eue ta nengane va, ‘Tau veevee ateva!’ aue kuraa ateae eataia eGehenna. ");
INSERT INTO emi_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Liuna avalua o me arova angu maemaeaa kalum aighelei masi aiaavusuvusuena, me uannaa lao mua kapum ateva ghe annaa va ughe ghelei saasakiaala etana, ");
INSERT INTO emi_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","uatoka sio mua kalum aighelei masi aiaavusuvusuena me ulaa taraia me amalu mene sama aitauaa, me auena umae ghelei masi aiaavusuvusuena sae ta God. ");
INSERT INTO emi_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Arova aissanim ateva ange laolao tani aulieinio ta tau ngai ghelei niaisakei eteva, ulaa tara parasia, me uauliaa etana va ualoanna va amalu kkaluaa llo voto amalu ghe gheleila karika masina, ta erau laa aulieinio ta tau ngai ghelei niaisakei eteva va elaa tauo ta polisi eteva, va elaa ghatokaio sso tale ale mata voovoo. ");
INSERT INTO emi_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Aghaaulia ngakoronna etam va karika aue ukupi ghoa tale ale mata voovoo lomosina ta utau ekapa lao viliki veu la ghase va utau lao. ");
INSERT INTO emi_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ngam ghe nongo vella va laghe auliaala va, ‘Karika umene lai sari.’ ");
INSERT INTO emi_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Me aghi aghaauliaa etaimim va, arova see ange tara ssaiila vause ateva me ange annaa saasakiaala etana, ia ange lai sari teeiela tale urunguitanina ateva. ");
INSERT INTO emi_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Arova matam muenna ativilau eghaaghaaio lao tale ssavoto, uvaliki velua me usau velua. Emaamasina arova kateva nonga ia tuku voto tale vilikim evulla ia, me karika va isaa akapa vilikim elao eGehenna. ");
INSERT INTO emi_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Me arova nimam muenna atelange ange gheleila va angu lao sio tale ssavoto, usai kotooia me usau velua. Emaamasina arova kateva nonga ia tuku voto tale vilikim evulla ia, me karika va isaa akapa vilikim elao eGehenna. ");
INSERT INTO emi_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ngam ghe nongo vella va, ‘Arova taita ateva ange ratila vausenna ateva, eghelei tikirighi unna uru ngai tani apasunga va ange ratirati vause ateva me etau lao ta vause ateva.’ ");
INSERT INTO emi_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Me aghi aghaauliaa etaimim va arova taita ateva enim rati vause ateva tale kasina ppae asease voto me karika tale uunguaa niailai salosaloaa see, ia o taita ateva egheelei vause ateva aue eaikune taita, me lo ateva taita emene lai ta vause ateva o ange lai sarila. ");
INSERT INTO emi_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ngam ghe nongo vella va laghe auliaala ta lo atoa emua arau va, ‘Am rau mene kamekame nau ngam gheleila inangari nialokoi, me nau ngam gheleila inangari nialokoi ta Vau palepale ateva, utani aimulisi tee llo uaauliaa.’ ");
INSERT INTO emi_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Me aghi aghaauliaa etaimim, am rau mene auliaa sae inangari nialokoi, karika epona liu tee, poli aitokatokane ateva o God, ");
INSERT INTO emi_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","me tale kosa ateva oia, poli God eaatingina saoaa kkena etana, me am rau mene auliaa sae inangari nialokoi tee eJerusalem, ta kinatama masalikina ia Kingi eteva iaaili epona. ");
INSERT INTO emi_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Urau mene auliaa inangari nialokoi tale urum ateva, ta karika urooroo tani ghelei katikirighi uu ngurum va eusousoana me evoovongiena. ");
INSERT INTO emi_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Am nim ue va ‘ue’ o ‘karika’, me karika am mene auliaa sae inangari nialokoi. Llo am nim mene auliaa, kanna sesa taumattu ngateva. ");
INSERT INTO emi_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ngam ghe nongo vella va laghe auliaala va, ‘Arova ughelei saasakiaa matana taumattu ngateva, eroo tani ghelei saasakiaa tee matam, me arova utumari kotoo ngalungaluna, eroo tani tumari kotoo tee ngalungalum.’ ");
INSERT INTO emi_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Me aghi aghaauliaa etaimim va am rau mene liu voto sesa ngila ghelei teeiemla, arova ngila posalala bbam muenna ativilau, umene kirio me la mene posala mene kativilau. ");
INSERT INTO emi_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Arova taumattu ngateva ange laoainio sio tale niaisakei me eue tale niaisakei va upolia tale unem sioto ateva, masina utau tee lao aiaasae ngeleka ateva. ");
INSERT INTO emi_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Me arova la ue etam va usunuki ghinna me ukasuaa tale kateva kilomita, masina usunuki me ukasuaa lao ta ghalua kilomita. ");
INSERT INTO emi_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Utau lao voto tale lo ateva elooloo, me urau mene aroo tale taumattu eanna tani ghaa voto pei niliu auena. ");
INSERT INTO emi_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ngam ghe nongo vella va laghe auliaala va, ‘Uaielousiaa taumattu ngateva kalakalangina ia etam me ussa tee aissateem ateva.’ ");
INSERT INTO emi_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Me aghi aghaauliaa etaimim va am ailousiaa aissaniimim atoa, me am looloo sae va God aue esausi lo atoa la gheelei saasakieinam. ");
INSERT INTO emi_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Arova am ghelei evalua o, aue natuna am Tamaimim ateva etokatoka epona liu, ta ia egheeghelei sinaka esaesae tale taumattu sesa me masina, me egheeghelei vaoo ateva ekaakatuu tale ghulughuluena atoa me tale tam ghulughuluena atoa. ");
INSERT INTO emi_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Arova am ailousiaa lo atoa la aailousieinam, saa aipolipoli aue am ghaa? Tau ngai ghaa takis atoa la gheelei evalua tee o. ");
INSERT INTO emi_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Me arova am ue va, ‘Elue talaua,’ nonga ta kapuimim atoa, am nim gheelei nongina katoa la gheelei. Tau ngeleka tee atoa la gheelei evalua o! ");
INSERT INTO emi_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Am ghulughuluenaaili nongina Tamaimim ateva epona liu ghulughuluenaaili ia. ");
INSERT INTO emi_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Am tani nanna ngamasina nau eteva am anna tani apasunga masi uunguaaimim ta mataira taumattu ngatoa va la tara. Arova am gheeghelei evalua o, karika aue am ghaa aipolipoli ta Tamaimim ateva etokatoka epona liu. ");
INSERT INTO emi_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Liuna avalua o me nau eteva angu tautau lao voto ta lo atoa karika righi peiira, urau mene ghelei nongina usimaghalua atoa, la saasama me la gheeghelei tale ale nivelu eitauaa me tale salana, va la taraila me la asaesae arariira. Aghaaulia ngakoronna etaimim va, ila o taumattu ngatoa angila ghe ghaala arau aipoliira. ");
INSERT INTO emi_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Me io, nau eteva uparruu lo ateva karika righi peina, ugheelei eisulia. ");
INSERT INTO emi_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Unem niaiparruuii unim ghelei eisulia, Tamam ateva etaatara voto ugheelei eisulia, me ia aue etau aatu aipolipoli etam.” ");
INSERT INTO emi_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Me nau am aloanna tani looloo sae, am rau mene ghelei nongina usimaghalua atoa. La ghaloannaaili tani looloo sae tale ale nivelu eitaua ngatoa me tale aighoughou tale salana va taumattu ngatoa la taraila. Aghaaulia ngakoronna etaimim va, ila o taumattu ngatoa angila ghe ghaala arau aipoliira. ");
INSERT INTO emi_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Me io, nau eteva ualoanna tani looloo sae, ukupi sso tale alem atiulu, me ukavati atamana ateae me io nonga ulooloo sae ta Tamam, me Tamam etaatara llo ugheeghelei eisulia aue etau aatu aipolim. ");
INSERT INTO emi_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Me nau eteva am looloo sae, am rau mene auliaa oroieili inangari karika malloeana nongina tau ngeleka atoa. La annaa va arova la auliaa oroieili inangari aue kapuira goto atoa la nongola. ");
INSERT INTO emi_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Am rau mene usi gheegheleiaaira, poli Tamaimim ateva ekilakila akasina llo voto am aloanna me am nim aaimuli tani kolomia. ");
INSERT INTO emi_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Liuna avalua o me am looloo sae avalue toko va: “‘Tamaimami epona liu usausiemami tani oneoneaa ararim ateae va manga ia, ");
INSERT INTO emi_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ami aloanna va ararimangalim ateva emae, me tale kosa ateva oia ami ghelei aloannaam nongina epona liu. ");
INSERT INTO emi_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Utau roorooaa mae aneimami inana tale lo ateva oia nau. ");
INSERT INTO emi_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ukkaluaa gheeleiaamami sesa, nongina ami kakkaluaa lo atoa gheeleiaaira sesa etaimami. ");
INSERT INTO emi_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Urau mene tau veluemami va ami lao tale nitootoonga, me uakekkeliemami tale sesa taumattu ngateva.’ ");
INSERT INTO emi_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Poli arova am kkaluaa kaluira ssavoto lo atoa la gheelei teeiem, aue Tamaimim epona liu aue ekkaluaa kaluimim tana ssavoto. ");
INSERT INTO emi_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Me arova am tam kkaluaa kaluira ssavoto taumattu ngatoa, aue Tamaimim ateva karika aue ekkaluaa kaluimim tana ssavoto.” ");
INSERT INTO emi_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nau angam naela, am rau mene ghelei taataraimim va esesaaili nongina usimaghalua atoa la gheeghelei. Nau la naenae, la ghaloanna va taumattu ngatoa la kilaila, liuna avalua o me karika la gheelei eraarangisanaila. Aghaaulia ngakoronna etaimim, ila o taumattu ngatoa angila ghe ghaala arau aipoliira. ");
INSERT INTO emi_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Me io, nau unaenae usile urum ateva me upora matam ");
INSERT INTO emi_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","me karika aue taumattu ngatoa la tara kilaio va unaenae, ta Tamam ateva etaatara voto ita tam taatara eaaisulia, ie nonga aue ekila, me etau aatu aipolim.” ");
INSERT INTO emi_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Am rau mene ghaa aitauaa peiimim tale kosa ateva oia. Aue ane ateva enama ghinna me tee aue erroso me tau niainao atoa tee aue la rruti ale me la ainao. ");
INSERT INTO emi_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ta am atoka aitauaa peiimim epona liu, me aue karika ane ateva enama me tee karika aue erroso, me tau niainao atoa karika aue la rruti ale me la ainao. ");
INSERT INTO emi_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ta poli voto ateva peim etokatoka etana, aue urunguitanim tee ateva etoka etana. ");
INSERT INTO emi_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Matam alua mallanga ilalua tale vilikim. Arova matam va masina, vilikim akapaaili aue epasu tale mallanga ateva. ");
INSERT INTO emi_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Me arova matam va sesa, aue vilikim akapaaili aue saurrom. Liuna avalua o me arova mallanga ateva etam va saurorromiena ia, aue saurrom ateva enamungaili. ");
INSERT INTO emi_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Karika teva taumattu erooroo tani uunguu ta ghalua vau, ta aue tani ssa tee kateva me aue emasiaa kateva, me aue enongo usilaa kateva me eliu vilina ta mene kateva. Karika urooroo tani uungu ta God me viliki veu. ");
INSERT INTO emi_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Liuna avalua o me aghaauliaa etaimim va, am rau mene annangaili maamauluaaimim va sa ateva aue am namaia, me am ropia, me am rau mene annangaili vilikiimim va sa ateva am asaeaa. Karika am kilakila va maulue ateva namuu ia ta matane God, me inana isaa euu, me vilikiimim isaa epona, me aiaasae isaa euu? ");
INSERT INTO emi_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Am tara ghila atoa la looloo. Karika la pasapasa utana me karika la mukemuke atoka, ta Tamaimim ateva epona liu eangiinginila. Karika am kilakila va Tamaimim ateva, nannaane etaimim elaulau aitaraane tale ghila atoa? ");
INSERT INTO emi_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Me arova utoka annaa nonga sa ateva aue elutu tale maamauluaam, isaa o voto aue etau aatu maulue me umene toka tau lao? ");
INSERT INTO emi_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Vaalua me am annangaili aiaasae? Am tara palaoa ngatoa la piipinosa, karika la uungu me karika la gheeghelei kalioira. ");
INSERT INTO emi_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Aghaauliaa etaimim va molumoluaane Solomon masinaaili, me karika ta palaoa ngatoa, la laulau molumoluaane Solomon. ");
INSERT INTO emi_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","God eaamolumolu evalua o rarrasa atoa, la piipinosa ghaine, me nimanaa la taula sae tale kura ateae. Am rooroo tani aikaaiaa va aue eaamolumolu evalueiem tee o, uneimim niaikaaiaa ghaunaaili. ");
INSERT INTO emi_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Liuna avalua o me am rau mene annangaili va, ‘Sa ateva aue ami namaia?’ me ‘Sa ateva aue ami ropia?’ me ‘Aue ami asae sa ateva?’ ");
INSERT INTO emi_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tau ngeleka atoa la iilou paepae isaa o voto, Tamaimim ateva epona liu ekilakila isaa o voto am tuutukuna etana. ");
INSERT INTO emi_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mata ngemua ateva voto am gheleia, am pae mua ararimangalina ateva God me gheegheleiaane ghulughuluena tale maamauluaaimim, me ia aue etau aatu isaa o voto etaimim. ");
INSERT INTO emi_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Liuna avalua o me am rau mene annaa nimanaa, poli maamaataniaa nimanaa epei nimanaa. Me kateva kateva nau, rooroona ia tale maate. ");
INSERT INTO emi_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Am rau mene ue va katoa nonga taumattu la gheelei ssavoto, ta God erau auliaa teeiem va am tee am gheelei ssavoto. ");
INSERT INTO emi_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Poli God aue eghelei niaisakei etaimim nongina am gheelei niaisakei ta katoa, me saa ase voto am gheelei ta mene kateva, God aue eghelei tee etaimim. ");
INSERT INTO emi_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Vaalua me utaatara nonga tuku vongovongo arighi ta matana kapum ateva me karika uannaa tuku palanga ateva ta matam? ");
INSERT INTO emi_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Vaalua me uue ta kapum ateva va, ‘Mae sio me aghaa velu tuku vongovongo arighi ta matam,’ me nau etoa tuku palanga ateva etokatoka ta matam? ");
INSERT INTO emi_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Usimaghalue io! Ta ughaa velu ekasina mua tuku palanga ateva ta matam, me aue utaatara amasina nau eteva ualoanna tani ghaa velu tuku vongovongo arighi ta matana kapum ateva. ");
INSERT INTO emi_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Am rau mene ghaa voto manga va am tau lao ta paua atoa, ta aue la kirila me la ametiem me la namaiem. Me tee am rau mene velu sio uneimim pel ta mosu etoa, ta aue la asa saasakiaa. ");
INSERT INTO emi_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Am kolomi me aue etau aatu; me am pae me aue am tara; me am mirimiri me atamana ateae aue eotia. ");
INSERT INTO emi_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Lo atoa la kookolomi, la ghaaghaa, me lo atoa la paepae, la taatara, me atamana eotioti ta lo atoa la mirimiri. ");
INSERT INTO emi_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“See etaimim tamatama atoa, arova teva natum elooloo teva tuku verete, aue utau lao teva atu? ");
INSERT INTO emi_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Me arova elooloo teva kko, aue utau lao teva katuu? ");
INSERT INTO emi_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Me gheegheleiaaimim sesa, me am kilakila tani tau lao masi voto ta natuimim atoa, am annaa va ghaisa ooroiaa voto Tamaimim ateva etokatoka epona liu etautau lao ta lo atoa la kookolomia? ");
INSERT INTO emi_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Tale isaa akapaaili voto, am ghelei lao ta katoa, llo am aloanna va la ghelei mae etaimim. Isaa o llo isaa tale inangari nipaopao me tale propete. ");
INSERT INTO emi_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Am kupi sso tale ghauna arighi atamana. Atamana ateae namuu ia me salana atikirighi namuu ia elaolao tale voto sesa, me oroi taumattu la kupikupi sso etana. ");
INSERT INTO emi_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Me atamana tani ghaa maulue ateva ghauna ia me salane atikirighi masukasukaleaili ia tani usilainia, me karika oroi ila lo atoa la uusilainia.” ");
INSERT INTO emi_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Am paniem nonga tale propete kamekame atoa. Gheeleiaaira eleka masina nongina sipsipi etoa, me nannaaira elome la nannaa sesa tani ghelei saasakieinam nongina sesa paua ngetapaa tuvui etoa. ");
INSERT INTO emi_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tale ueira aue am kilaila. Karika teva taumattu elaa paapariki ue ngai tale uasa karasa me ue uasa tale ai rorroana. ");
INSERT INTO emi_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tale ie nonga o salana atikirighi, masi ngai eteae ekuukuneaa masi uene, me sesa ngai eteae ekuukuneaa sesa uene. ");
INSERT INTO emi_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Masi ngai eteae karika erooroo tani kuneaa sesa ue ngai, me sesa ngai eteae karika erooroo tani kuneaa masi ue ngai, ");
INSERT INTO emi_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ta isaa akapaaili ai karika ekuukuneaa masi uene la tuetuea katuu me la veluvelu sae tale kuraa. ");
INSERT INTO emi_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Am roo tani tara kila va see ila propete kamekame atoa tale gheeleiaaira, nongina am kilakila ai eteae tale uenenna. ");
INSERT INTO emi_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Karika isaa akapa taumattu la aseaseaghi va, ‘Vau eteva,’ aue la kupi sso tale ararimangali ngepona liu eteva, karika. Ta lo atoa nonga la aimulisi tee gheeleiaane Tamaghi etokatoka epona liu aue la kupi sso tale ararimangali ngepona liu eteva. ");
INSERT INTO emi_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Oroi ila lo atoa aue la mae etaghi tale airuuruu eteva nau, aue la ue etaghi va, ‘Vau eteva, Vau eteva, karika va ami ghe aauliaa inangarina God tale ararim ateae, me ami ghe tiutiu velu raroai etoa tale ararim ateae, me ami ghe gheelei oroieili voto atoa sarasarakana ila laghe lutulutu tale ararim ateae?’ ");
INSERT INTO emi_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Me aue aliu etaira va, ‘Karika akilakilaiem. Am kasu emasalikaala, tau nighelei ssavoto am!’” ");
INSERT INTO emi_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“See ila lo atoa la nongonongo inangarighi me la uusilaa, ila nongina taumattu ngateva alomasaanga ia, ghe atulula alena ateva epona tale atu. ");
INSERT INTO emi_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nau eteva vaoo ateva ghe sio mae, me ateo ghe akalala, me kuukuu eteva ghe lutula, laghe tonge poila ale ateva, ale ateva karika ghe katuula, poli ie tale atu korokorongana. ");
INSERT INTO emi_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Me see ila lo atoa la nongonongo inangarighi me karika la uusilaa, ila nongina alo kapakapa ateva tana taumattu ghe atulula alena ateva tale rira. ");
INSERT INTO emi_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nau eteva vaoo ateva ghe sio mae, me ateo ghe akalala, me kuukuu eteva ghe mae sio, laghe gheleila ale ateva ghe katuula, me namungaili kaakatungaane.” ");
INSERT INTO emi_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nau eteva Iesu ghe ruula tani auliaa isaa o voto, taumattu ngatoa laghe soghiaala llo ghe apasungaala, ");
INSERT INTO emi_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","poli karika ghe aippooaa nongina tau ngai aapasunga ngatoa tale inangari nipaopao, ta nongina taumattu ngateva matuutuliena ia. ");
INSERT INTO emi_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nau Iesu ghe kkureaala tale motouru eteva, taumattu ngatoa oroieili ila laghe usiela. ");
INSERT INTO emi_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Me taumattu ngateva, tasussukuna ia, ghe mae sio ta Iesu, me ghe suuiaala ta liue kkena Iesu me ghe uela va, “Vau eteva, arova ualoanna, urooroo tani ghelei eraarangisanaieghi ta mata God.” ");
INSERT INTO emi_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iesu ghe ssuaala nimane me ghe tuliela, me ghe uela etana va, “Aghaloanna; angu raarangisana.” Me gharavaea nonga ta ghe raarangisanala. ");
INSERT INTO emi_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Me Iesu ghe uela etana va, “Urau mene auliaa ta teva voto elutula etam. Ulao me ulaa ghapasungainio ta pristi eteva, me ughelei aiaavusuvusuena tani apasunga va vilikim ange raarangisanala, nongina Moses ghe auliaala. Me taumattu ngatoa aue la kila va angu raarangisanala.” ");
INSERT INTO emi_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nau eteva Iesu ghe ssola tale masaliki eteae eKapenium, kateva namuu ghe aaitoiaa kateva ai (100) tau ngai uvii ghe mae sio tani kolomia. ");
INSERT INTO emi_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ghe ue va, “Vau eteva, kapughu tau ngai nongonongo anna ateva ange karakanna alokoila elo ale, karika erooroo tani kasukasu, me vilikina atoa la mammarikana atingina.” ");
INSERT INTO emi_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iesu ghe uela etana va, “Aghi aue alaa ghelei emasinaia.” ");
INSERT INTO emi_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Namu ngateva ghe liula etana va, “Vau eteva, karika masina ieghi va umae tanganueghi. Unim aippooaa me kapughu tau ngai nongonongo anna ateva emasina. ");
INSERT INTO emi_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Aghi tee auungu ta namu ngatoa, me aghaaitoiaa katoa tani tau ngai uvii. Nau eteva aue ta kateva va, ‘Lao sio,’ elaolao, me aue ta kateva va, ‘Mae sio,’ emaemae. Me aghaauliaa ta kapughu tau ngai nongonongo anna ateva va, ‘Gheleila voto toko,’ egheeghelei.” ");
INSERT INTO emi_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nau eteva Iesu ghe nongola isaa o voto, ghe soghiaala me ghe uela ta lo atoa laghe usiusia va, “Aghaaulia ngakoronna etaimim va karika aghe tara poi teva taumattu eIsrael kanna niaikaaiaa namuu nongina lo ateva oia taumattu. ");
INSERT INTO emi_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Aghaauliaa etaimim va oroi ila lo atoa aue la mae akapa see tale kosa ateva oia, tani toka tee Abraham, Aisiki me Jekop tani namanama, tale ararimangali ngepona liu eteva. ");
INSERT INTO emi_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Me lo atoa aIsraeli ila laghe annaa va aue la kupi sso tale ararimangali eteva, me karika, ta aue la vella ghoa tale kinatama saurrom ateva, me aue la ghoa toka ngangngala me la aingeresia ngalungaluira.” ");
INSERT INTO emi_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Me Iesu ghe uela ta namu ngateva oia va, “Lao sio elo ale, voto aue elutu nongina angu aikaaiaala.” Me gharavaea ta tau ngai nongonongo anna ateva ghe masinala. ");
INSERT INTO emi_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nau eteva Iesu ghe rekatala tanganue Pita, ghe tarala alumuna vause ateva Pita ghe asoaso tale komo, me vilikina ghe aanasa me matana ghe valavalanga. ");
INSERT INTO emi_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Iesu ghe posola nimane, me mata valavalanga ateva ghe kapala, me ghe totu saela me ghe kaisila anna inana. ");
INSERT INTO emi_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nau sinaka ateva ang ghe suusuu me oroieili ila lo atoa raroai etoa laghe tokatoka etaira, laghe maeainila sio etana va eghelei emasinaila, ghe nim aippooaa me raroai etoa laghe kupikupi ghoa, me ghe gheeghelei emasina tee tau sessa akapa atoa. ");
INSERT INTO emi_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Isaa o voto ghe akauerekatila llo voto propete Aisaea ghe auliaala, “Ia ghe ghaala kaluita saghuighuina, me ghe saula kaluita sessa.” ");
INSERT INTO emi_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nau eteva Iesu ghe tarala taumattu ngatoa angila ghe ooroieili, ghe uela ta kapuna atoa va, “Ita kasu, ita lao ta pai kativilau.” ");
INSERT INTO emi_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Angila ghe aloanna tani kasu, me tau ngai aapasunga ateva tale inangari nipaopao ghe mae sio, me ghe uela etana va, “Tisa, aghaloanna tani usio nongina eaa ulao.” ");
INSERT INTO emi_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Vara me Iesu ghe uela etana va, “Paua atoa aleira tale pake valienga, me ghila atoa aleira manee, me Natuna ateva Taumattu ngateva karika teva alena tani aso.” ");
INSERT INTO emi_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mene kateva tana kapuna disaepolo ghe uela etana va, “Vau eteva, tau velueghila me alaa kaiaa mua tamaghi.” ");
INSERT INTO emi_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Iesu ghe uela etana va, “Usieghila me ratila lo atoa matena ila la kaiaa matena atoa.” ");
INSERT INTO emi_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iesu ghe aikaaila tale paanaka ateva me kapuna disaepolo atoa laghe usiela, me laghe tiu ghoala. ");
INSERT INTO emi_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Elome tale ateo talia ngateae, paka kuukuu ttasi eteva ghe lutula. Paka kotoo atoa laghe aasuu kaakaai tale paanaka ateva, me Iesu ghe asekanue alokoila. ");
INSERT INTO emi_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Disaepolo atoa laghe anguniela, me laghe ue etana va, “Vau eteva, sausiemamila! Angita vuuvuluu!” ");
INSERT INTO emi_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Iesu ghe liula inangariira, me ghe uela etaira va, “Vaalua me am maamatautu, ghaunaaili aikaaiaaimim?” Ghe tingina saela me ghe paola kuukuu ttasi eteva tale ateo talia ngateae, me kinatama luei eteva ghe asola. ");
INSERT INTO emi_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Taumattu ngatoa tale paanaka ateva, laghe soghiaala me laghe ue va, “Saa taumattu ia taumattu ngateva oia, ta ttasi eteva me paamanu eteva la nongonongo usilainia?” ");
INSERT INTO emi_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nau eteva Iesu ghe laa rekata sio tale pai kativilau, tale kosaira aGadara ngatoa, me ghe sousoula taumattu ngalua lalu ghe kasula tale liu niaikkaiaa, raroai etoa laghe tokatoka etairarua. Taumattu ngatoa karika laghe laolao akalakalaa etairarua poli lalu ghe aaiuvii. ");
INSERT INTO emi_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Lalu ghe aaore me lalu ghe ue va, “Sa ateva ualoannaia etaimami, Natuna ateva God? Vaalua me umae sio tani ghelei saasakieinamami me karika ghe ghaa nau?” ");
INSERT INTO emi_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mala masau nongina laghe tiitingina, tinaua mosu etingiu ghe tingina namanama. ");
INSERT INTO emi_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Raroai etoa laghe kolomi esarasarakanala Iesu va, “Arova utiu veluemami, usuu tauemami lao ta mosu etoa.” ");
INSERT INTO emi_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Me ghe uela etaira va, “Am lao sio.” Laghe kupi vulu ghoala taumattu ngalua me laghe laa sae kupi sso ta mosu etoa. Me tinaua atingiu ghe ttiroula, me laghe ilou velu siola tale vallae me laghe aoso velu siola tapaa manu me ghe arropi ematelala. ");
INSERT INTO emi_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Lo atoa laghe aaitaraa mosu etoa laghe iloula, me laghe lao sio tale masaliki eteae, me laghe kiukiuaa ngakapala kiukiuirarua. ");
INSERT INTO emi_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nau eteva taumattu ngatoa tale ia o masaliki taatara ateae laghe nongola kiukiu, ila akapa laghe mae sio tani sou Iesu me laghe aulia ngasarasarakanala ta Iesu va karika emene toka tale masalikiira ateae. ");
INSERT INTO emi_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iesu ghe aikaai ghoala tale paanaka ateva, me laghe lao sio tale pai kativilau, me laghe rekatala tale masalikina ateae. ");
INSERT INTO emi_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Katoa taumattu laghe maeaa sio taumattu ngateva karakanna ia, me ghe asoaso tale komo atiulu. Nau eteva Iesu ghe tarala uneira niaikaaiaa, me ghe uela etana va “Urau mene annaa, natughu, kalum ssavoto ange kapala.” ");
INSERT INTO emi_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Katoa tana tau ngai aapasunga tale inangari nipaopao laghe tingina nannaa me laghe aippooaa elome etaira va, “Ierai oia ange ghaala liuna ateva God.” ");
INSERT INTO emi_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Iesu ghe kilala nannaaira me ghe uela va, “Vaalua me ninannaa sesa etokatoka tale urunguitaniimim? ");
INSERT INTO emi_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Eaa teva voto malumina tani auliaa, tani ue va, ‘Kalum ssavoto ange kapala,’ o tani ue va, ‘Tingina saela me ukasu’? ");
INSERT INTO emi_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Me aghaaloanna va am tara kila, va Natuna ateva Taumattu ngateva matuutuliena teeia tani kkaluaa ssavoto tale kosa ateva.” Me ghe uela ta taumattu ngateva karakanna ia va, “Tingina saela, me usau komom, me ulao tanganuem.” ");
INSERT INTO emi_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Me ia o taumattu ngateva ghe tingina saela me ghe lao sio tanganuena. ");
INSERT INTO emi_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nau eteva taumattu ngatoa laghe tarala isaa o voto, laghe soghiaala me laghe tau saela God, poli ghe tau lao sio matuutuliena tale taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nau Iesu ghe kasukasu elaolao me ghe tarala taumattu ngateva ararina ateae ta Matiu, ghe tokatoka tale natu ngale arighi aighaa takis ia me Iesu ghe uela etana va, “Mae usieghi,” me Matiu ghe tingina saela me ghe usiela. ");
INSERT INTO emi_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nau eteva Iesu ghe namanama tanganue Matiu, oroieili tau ngai ghaa takis atoa me tau ssavoto atoa laghe mae sio tani namanama teeia, me kapuna disaepolo atoa. ");
INSERT INTO emi_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nau eteva Paresi etoa laghe tarala isaa o voto, laghe kookolomi kapuna disaepolo atoa Iesu va, “Vaalua me kapuimim tisa ngateva enamanama tee tau ngai ghaa takis atoa me tau ssavoto atoa?” ");
INSERT INTO emi_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nau Iesu ghe nongola, ghe uela va, “Karika va lo atoa masina ila la anna va dokta etaraila, ta lo atoa nonga isikinna ila. ");
INSERT INTO emi_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Me am lao me am laa pae aotu vaalua malloeana nau Uru ngai Manga ateva eue va, ‘Aghi aghaaloanna va am alousiusi tee mene kateva me karika va tani ghelei niaiaavusuvusuena,’ poli karika aghe mae sio tani kolo ghulughuluena atoa ta aghe mae sio tani kolo tau ssavoto atoa.” ");
INSERT INTO emi_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Vara me kapuna disaepolo atoa Jon laghe mae sio me laghe kolomila Iesu va, “Vaalua me ami me Paresi etoa ami naenae, me kapum disaepolo atoa karika?” ");
INSERT INTO emi_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Iesu ghe liula me ghe uela va, “Kapuna atoa taumattu ngateva ange anna tani lai karika la aalousiusi nau eteva etokatoka teeila. Nau eteva aue emae me la ghaa velu taita ateva, ia o nau eteva aue la vira nae. ");
INSERT INTO emi_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Karika teva eghaaghaa tuku ouna ateva kalio va evabbai pokane ateva aiaasae, ta tuku ouna ateva kalio aue emene ghelei mara ateva tale pokane ateva aiaasae emara anamuu. ");
INSERT INTO emi_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Karika teva taumattu etottoli ouna uaeni tale pokane ateva aikaai uaeni. Arova eghelei evalua o, aue ouna uaeni eghelei polaki aikaai uaeni eteva pokane ia, me uaeni eteva aue ekaoa me aikaai uaeni eteva aue esesa. Ta la tottoli ouna uaeni tale ouna ateva aikaai uaeni ta ilalua akapa aue lalu masina.” ");
INSERT INTO emi_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nau eteva Iesu ghe aaippooaa nonga me kateva namuu ghe mae sio me ghe suuiaala emua etana, me ghe uela va, “Natughu vause arighi ghaviri nonga oia ematela. Mae sio me ulaa saoaa nimam etana me emene sakesake.” ");
INSERT INTO emi_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iesu ghe tingina saela me ghe usiela tee me kapuna disaepolo atoa. ");
INSERT INTO emi_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Vara me vause ateva rae ateva ghe iloueiniela tale kasangaulu ghaluae (12) ninamanama, ghe nannaa va, “Arova aghele nim poso unna aiaasae ngeleka ateva koti aue aghele masina.” Me ghe lao sio emuli ta Iesu me ghe posola euu tale sama unna aiaasae ngeleka ateva. ");
INSERT INTO emi_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Iesu ghe kiriela me ghe taraiela me ghe uela etana va, “Urau mene matautu, natughu. Tale unem niaikaaiaa etaghi angu masinala.” Tale ia o nau eteva vause ateva o ghe masinala. ");
INSERT INTO emi_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nau eteva Iesu ghe kupi ssola tale alena ateva namu ngateva, ghe tarala lo atoa laghe vuuvuu flut atoa me taumattu ngatoa laghe aalousiusi etingina. ");
INSERT INTO emi_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Me ghe uela etaira va, “Am kupi ghoala. Vause arighi karika matena ia ta enim aseasekanua,” me laghe tiuaala tani kangainia. ");
INSERT INTO emi_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nau eteva taumattu ngatoa laghe kupi ghoala eleka, Iesu ghe kupi ssola me ghe kune siola nimane vause arighi, me ghe totula. ");
INSERT INTO emi_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kiukiuna vause arighi oia ghe kasu ekapa seela tale masaliki tale ia o distriki eteva. ");
INSERT INTO emi_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nau eteva Iesu ghe mene kasukasu elaolao, mata salusalu elua lalu ghe usiela, me lalu ghe kolokolo. Lalu ghe ue va, “Io Natuna io Deivit, ualousiusi teeiengalua.” ");
INSERT INTO emi_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nau eteva ghe kupi ssola tale ale ateva, mata salusalu elua lalu ghe usiela. Me Iesu ghe kolomilaluela va, “Amalu aikaaiaa va arooroo tani ghelei emasinaiemalua?” Lalu ghe liula me lalu ghe uela va, “Ue, vau eteva.” ");
INSERT INTO emi_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Vara me ghe posola matairarua, me ghe uela va, “Tale uneimalua niaikaaiaa, aue amalu taatara.” ");
INSERT INTO emi_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Me matairarua ghe mene taatarala. Iesu ghe aulia ngakorokoronganala etairarua va, “Karika amalu mene laa kiukiuaa see isaa o voto.” ");
INSERT INTO emi_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nau eteva lalu ghe kupi ghoala, lalu ghe kiukiueinie seela tale masaliki etoa. ");
INSERT INTO emi_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nau eteva angilalu ghe kasukasu, me laghe mene maeaa sio taumattu ngateva raroai eteva ghe kupiela me karika ghe rooroo tani sama. ");
INSERT INTO emi_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Me nau eteva raroai eteva ghe kupi vulue ghoala, taumattu ngateva paavoo ia ghe samala. Taumattu ngatoa laghe tarala isaa o voto me laghe soghiaala, me laghe ue va, “Karika righi voto avalua o ghe lutu eIsrael.” ");
INSERT INTO emi_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Paresi etoa laghe ue va, “Enim tiutiu velu raroai etoa tale sarasarakaniaane kapuira namu ngateva raroai etoa.” ");
INSERT INTO emi_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesu ghe kasu ekapa seela tale masaliki taatara atoa me tale lutu ghauna masaliki. Ghe aapasunga tale aleira ale nivelu eitauaa me ghe poppooa ngaotu masi kiukiu tale ararimangali ngepona liu eteva me ghe gheeghelei emasina isaa akapa asease sessa atoa. ");
INSERT INTO emi_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nau ghe tarala taumattu ngatoa, ghe alousiusi teeilala poli nannaaira maateaili me karika teva taumattu tani sausila me ila nongina sipsipi etoa karika teva aitoiira. ");
INSERT INTO emi_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Me ghe uela ta kapuna disaepolo atoa va, “Utana ateva ang ghele matuela, me tau ngai uungu etoa karika oroi ila. ");
INSERT INTO emi_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Liuna avalua o, am kolomi sae Vau tale tau ngai mukemuke atoa va emene sungi toa tau ngai mukemuke tani lao tale utana atingiu matuenna ia.” ");
INSERT INTO emi_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu ghe kolo aitauaala kapuna disaepolo kasangaulu ghalua (12), me ghe tau lao sio matuutuliena tani tiu velu raroai etoa me tani ghelei emasina isaa akapa asease sessa atoa. ");
INSERT INTO emi_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Arariira toko kasangaulu ghalua (12) apostolo: Aitiutiu eteva ta Saemon (la kolokoloa va Pita) me nengane ta Andru, me Jeimis natuna ia Sebedi, me nengane ta Jon. ");
INSERT INTO emi_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Me Pilip me Batolomiu, Tomas me Matiu tau ngai ghaa takis ia, me Jeimis natuna ia Alpeas, me Tadias, ");
INSERT INTO emi_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","me Saemon laghe aseala va Selot ia, me Jiudas Iskariot (ia auena ghe tau lao Iesu ta nimaira tau ngai ssateena atoa). ");
INSERT INTO emi_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iesu ghe suula isaa oia kasangaulu ghalua, me ghe tau lao sio inangari niloeloe etaira va, “Nau eteva am kasu, am rau mene lao ta tau ngeleka ngatoa, me am rau mene sso tale masalikiira aSameria ngatoa. ");
INSERT INTO emi_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ta am lao ta aIsraeli etoa, ila nongina sipsipi etoa laghe rauela. ");
INSERT INTO emi_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nau am lao am ppooa ngavalua toko va, ‘Ararimangali ngepona liu eteva ange aakalakalaa.’ ");
INSERT INTO emi_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Am ghelei emasina tau sessa atoa, me am totu matena atoa, me am ghelei eraarangisana tasussukuna atoa, me am tiu velu raroai etoa. Isaa o sarasarakana, aghe nim tau aatu sio, am nim mene taula, me karika am mene ghaa aipolipoli. ");
INSERT INTO emi_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nau eteva am kasu, am rau mene annaa tani ghaa righi viliki veu, golo me silva me kopa. ");
INSERT INTO emi_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Am rau mene ghaa aikakkaai tale lo ateva o nikasu, me am rau mene ghaa ghalua aiaasae me aikasukasu, me aikkatulu. Poli emaamasina va tau ngai uungu eteva eghaaghaa anna inana ta lo atoa euungu etaira. ");
INSERT INTO emi_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Arova ngam rekataala tale kateae masaliki, am pae lo ateva taumattu aue emasimasi tani aikoloainam, me am toka teeia, lomosina ta am kasu vuli ia o masaliki eteae. ");
INSERT INTO emi_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nau eteva ngila aloannala va am toka teeila, am ue va, ‘Luei aue etoka etaimim.’ ");
INSERT INTO emi_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Arova am kupi sso tale aleira masi taumattu ngatoa, am alokoi luei etaira, me arova karika, am mene ghaa oghi niarangise me luei etaira. ");
INSERT INTO emi_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Arova toa la tam ghaaiem me la tam aloanna tani nongo usilaa inangariimim, am rariaa velu au kosa ateva ta kkeimim nau am kasu vuli ia o ale ateva o masaliki eteae. ");
INSERT INTO emi_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Aghaaulia ngakoronna etaimim va, aue nau niaisakei eteva, God aue eapasunga maomaona nimmarikana tale masaliki eteae eSodom me eGomorra, me sesaaili tale ia o masaliki eteae. ");
INSERT INTO emi_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Am nongo! Asungisungiem nongina sipsipi etoa elome tale sesa paua ngetapaa tuvui etoa, liuna avalua o me am anguu taatara nongina katu ngateva, me am nongina tee ghila ateva valusu ia karika egheelei righi sesa. ");
INSERT INTO emi_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Am tani taatara amasina poli taumattu ngatoa aue la kuneiem me la laoainam tale aleira ale nivelu eitauaa me la uetaiem. ");
INSERT INTO emi_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Poli mausighi me aue la laoainam ta gavana ngatoa me kingi etoa, me ia o aue emasi nauimim tani aulia ngaotueghi etaira me ta tau ngeleka ngatoa. ");
INSERT INTO emi_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nau eteva la kuneiem, am rau mene annaa va sa ateva aue am aulieinia me vaalua aue am aippooaa. Ta God aue etau aatu inangari aue am auliaa. ");
INSERT INTO emi_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ta karika va am aue am aippooaa ta aue Spirit Manga ateva kapuna ia Tamaimim ateva aue etau aatu inangari aue am auliaa. ");
INSERT INTO emi_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Taumattu ngatoa aue la tau velu tueira me nengaira atoa ta lo atoa aue la uvi ematela, me tamatama atoa aue la ghelei evalua tee o ta natuira atoa. Aliki etoa tee aue la ssa tee tamaira me kinaira atoa, me aue la uvi ematela. ");
INSERT INTO emi_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Taumattu ngakapa atoa aue la ssa teeiem poli ararighi eteae. Me see etingina akorokorongana tale unna niaikaaiaa tale airuuruu, maamauluaane aue esaanga. ");
INSERT INTO emi_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Arova la ghelei teeiem tale kateae masaliki, am kasu vulia me am mene lao ppae tale kateae masaliki. Aghaaulia ngakoronna va karika aue am ruu masaliki ekapa eIsrael me Natuna ateva Taumattu ngateva emae. ");
INSERT INTO emi_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Tau ngai ghaa alomasaanga ateva karika namuu ia ta kapuna tau ngai aapasunga ngateva, me tee tau ngai nongonongo anna ateva karika namuu ia ta vauna ateva. ");
INSERT INTO emi_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tau ngai ghaa alomasaanga ateva erooroo va enongina tau ngai aapasunga ateva, me tau ngai nongonongo anna ateva erooroo va enongina vauna ateva. Arova la aseaghi va aghi Belsibul, namuu ta raroai etoa, aue la tau tee sesa arari etaimim. ");
INSERT INTO emi_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ia avalua o me am rau mene matautainila. Karika righi voto am aaituttuia va aue etam otu, isaa akapa voto pei niaisulia, aue la kila. ");
INSERT INTO emi_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sa ateva aghaaulieinia eleivoo, am aulieinia ellaa me sa ateva aghaulia ngaghaunaie sso ta talingaimim, am sae tingina tale pungani ngale atoa me am auliaa. ");
INSERT INTO emi_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Am rau mene matauta lo atoa la anna tani uvi emateam, ta aue la nim turungi vilikiimim me karika aue la uvi emate maamauluaaimim. Ta am matauta nonga lo ateva erooroo tani turungi ekapa vilikiimim me maamauluaaimim eGehenna. ");
INSERT INTO emi_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ghaluepai natu ghila la polipoli tale maketi tale kativilau nonga viliki veu me arova aloannaane God va karika teva emene mate, karika teva erooroo tani mate. ");
INSERT INTO emi_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Tee me isaa akapaaili uu nguruimim, God ekilakila va ghaisa akapa. ");
INSERT INTO emi_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ia avalua o me urau mene matautu ta maamauluaam namungaili ta matane God, elaulau ghila atoa. ");
INSERT INTO emi_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“See eaulia ngaotu tale taumattu ngatoa tale kosa ateva oia va kapughu ia, aghi tee aue aghaulia ngaotu ta Tamaghi epona liu va ia kapughu ia. ");
INSERT INTO emi_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Arova lo ateva uauliaa ta katoa va karika ukilakilaieghi, aue aghauliaa tee ta Tamaghi epona liu va karika akilakilaio. ");
INSERT INTO emi_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Am rau mene annaa va aghe maeaa sio luei tale kosa ateva oia, karika aghe maeaa sio luei ta aghe maeaa sio baenata ateva. ");
INSERT INTO emi_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Aghe mae sio tani ghelei va “‘taita ateva essa tee tamana ateva, me vause ateva essa tee kinna ateva me vause ateva essa tee alumuna vause ateva. ");
INSERT INTO emi_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tau ngaissanira atoa karika aue la laa kasu emasau ta aue la tani kasu etoka elome tale paa ngaleira aitauaa.’ ");
INSERT INTO emi_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Lo ateva taumattu eaaielousiaa nonga tamane me kinna me natuna taita atoa me natuna vause atoa, me karika eaaielousieinaghi, karika emaamasina va kapughu disaepolo ia. ");
INSERT INTO emi_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Me lo ateva karika eaalona tani sunuki unna aikotoo ateva me eaimuli teeieghi, karika emaamasina va kapughu disaepolo ia. ");
INSERT INTO emi_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Arova teva easaangi maamauluaana, aue eraua, me arova eraua ta mausighi aue eghaa maulue ateva. ");
INSERT INTO emi_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“See eghaaghaaiem eghaaghaaieghi, me see eghaaghaaieghi, eghaaghaa lo ateva ghe sungieghila. ");
INSERT INTO emi_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","See eaikoloaa propete ateva poli propete ia aue eghaa aipolipoli nongina propete ateva eghaaghaa. Me see eaikoloaa tau ghulughuluena ateva poli tau ghulughuluena ateva kapuna ia God, aue eghaa aipolipolina tau ghulughuluena ateva. ");
INSERT INTO emi_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Me arova see etara teva tale isaa oia disaepolo taumattu ngatoa la taatara aloila sio euu, me earopiropi teva ta poli kapughu disaepolo ia, aghaaulia ngakoronna va aue eghaa aipolipoli.” ");
INSERT INTO emi_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nau Iesu ghe ruula tani apasunga taula voto ta kapuna kasangaulu ghalua (12) disaepolo, ghe kasu vulila ia o voto ateva me ghe mene lao sio tani ppooaa me apasunga tale masaliki taatara atoa eGalilii. ");
INSERT INTO emi_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nau eteva Jon ghe tokatoka tale ale mata voovoo me ghe nongola voto Mesaea ngateva ghe gheelei, me ghe suula kapuna disaepolo atoa ");
INSERT INTO emi_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","tani laa kolomi Iesu va, “Io ia o taumattu ngateva God ghe uela va aue emae, o aue ami toi mene teva?” ");
INSERT INTO emi_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Iesu ghe liula me ghe uela va, “Am oghi lao sio me am laa ghauliaa ta Jon voto am tarala me am nongola. ");
INSERT INTO emi_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mata salusaluna atoa mataira eotila me vereverenna atoa la kasukasula, me lo atoa tasussukuna ila la raarangisanala, me talinga volongo atoa la mene nongonongola, me matena atoa la totula, me llo taumattu karika peina la nongola masi kiukiu. ");
INSERT INTO emi_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Me aue emasinaaili ta taumattu ngateva, unna niaiesoaa karika ekaakatuu vulueghi.” ");
INSERT INTO emi_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nau kapuna disaepolo atoa Jon laghe kasula, me Iesu ang ghe auliaa Jon ta taumattu ngatoa. Ghe ue etaira va, “Sa ateva am ghe lao sio tani taraia tale voto ateva karika righi taumattu etana? Pitpiti eteva ghe kuukuueinia? ");
INSERT INTO emi_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Arova karika, tani sa ateva am ghe lao sio tani taraia? Teva taumattu ghe molumolu tale masi ghinna? Karika, ta lo atoa la aasae masi ghinna la tokatoka tanganue king. ");
INSERT INTO emi_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tani sa ateva am ghe kasueiniela? Propete ateva? Ue, aghaauliaa etaimim va am ghe tarala propete ateva me emene laulau mene katoa propete. ");
INSERT INTO emi_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ia o taumattu ngateva, Uru ngai Manga ateva ghe aulieiniela nau ghe uela va, “‘Tarala, aue asuu aikasuaa inangarighi eteva emuemueinio, me ia aue eaimonomonosiaa ngamuemue alokoi salam.’ ");
INSERT INTO emi_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Aghaaulia ngakoronna etaimim va elome ta lo atoa laghe lutula tale kosa ateva oia, karika teva erooroo ta Jon ia o tau ngai aasuu ia. Me lo ateva karika teae ararina, me iaaili euu tale ararimangali ngepona liu eteva, elaulau Jon. ");
INSERT INTO emi_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ghe tiuaala ta nauna Jon tau ngai aasuu ia me ang ghe mae sio ta nauita ghaine, sesa taumattu ngatoa la korokorongana tani sari ararimangali ngepona liu eteva tale nim aloaloannaaira. ");
INSERT INTO emi_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Propete akapa atoa me inangari nipaopao laghe aulia ngaotula inangarina God ghe mae ghaa sio nau ta Jon. ");
INSERT INTO emi_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Me arova am aiesoaa inangariira, Jon Elaija ta ngetana ia o laghe aulia ngamuemua alokoiela va aue emae. ");
INSERT INTO emi_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Lo ateva talingane manee tani nongo, aue enongo. ");
INSERT INTO emi_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Sa ateva voto arooroo tani auliaa me eaimatoonga taumattu tale lo ateva oia vituu? Ila nonginaaili aliki etoa la tokatoka tale liu nianamisi, katoa la ue lao ta mene lutu katoa va, ");
INSERT INTO emi_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“‘Ami ghe vuuvuu kkinari nilai eteae etaimim, me karika am ghe lokuloku; ami ghe uuei kkinari tani kkinariaa matena atoa, me karika am ghe aalousiusi.’ ");
INSERT INTO emi_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nau Jon ghe mae sio me karika ghe namanama me ghe tam ropiropi, laghe ue teeia va, ‘Raroai eteva ghe tokatoka etana.’ ");
INSERT INTO emi_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Me Natuna ateva Taumattu ngateva ghe mae sio me ghe namanama me ghe ropiropi, laghe ue teeia va, ‘Tau ninamanama ia, me tau niropi sesa manu ia, kapuira ia aighaa takis atoa me tau ssavoto atoa.’ Me masi ninannaa kanna God eaapasunga va koronna ia tale maamauluaaira lo atoa la aaimuli teeia.” ");
INSERT INTO emi_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Iesu ghe sama anamuu teela llo masaliki taatara ghe gheleila oroiannaaili mirikol poli taumattuna karika ghe nna ngaioghioghiaa. ");
INSERT INTO emi_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Aue esesaaili ta ngetam, Korasin, me aue esesaaili ta ngetam, Betsaida! Marova mirikolo oia laghe gheleila eTaer me eSaedon, taumattu ngatoa aue laghe molu tale ghinna nialousiusi me au kura, tani apasunga va ngila ghe oghi vulula sesa gheegheleiaaira. ");
INSERT INTO emi_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Aue emaomaona nimmarikana ta eTaer me eSaedon tale nau niaisakei eteva, me am karika. ");
INSERT INTO emi_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Me io, Kapenium? Uannaa va aue usae epona liu? Karika, io aue usioaili euu. Arova isaa o mirikol laghe gheleila etam va laghe gheleila eSodom, isaa oia nau Sodom ie tokatoka. ");
INSERT INTO emi_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Aghaauliaa etam va nau eteva God aue eghelei niaisakei, voto Sodom eghaa aue emala masina me io aue sesaaili.” ");
INSERT INTO emi_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ia o nau eteva Iesu ghe uela va, “Atautauo sae Tamaghi, Vau ngepona liu io me kosa ateva, poli ughe aisuliaala isaa o voto tale lo atoa nannaaira masina me lo atoa alomasaangaaili ila me ughe aulia ngaotula ta lutu ngaliki etoa. ");
INSERT INTO emi_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ue Tamaghi, ugheelei isaa o voto tani aimuli tee masi aaloannaam. ");
INSERT INTO emi_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Isaa akapa voto Tamaghi ghe atokala ta nimaghi, me karika teva ekilakila Natuna ta Tamana nonga. Me karika teva ekilakila Tamaghi ta Natuna nonga, me lo atoa Natuna ghe apasungaala Tamane etaira tale aloaloannaane. ");
INSERT INTO emi_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Am mae etaghi, lo atoa ngam maamangoo poli am sausau llo maate, me aue atau aatu niainoana etaimim. ");
INSERT INTO emi_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Am aimuli teeieghi me am ghaa alomasaanga etaghi me am uungu etaghi nongina vulumakao ateva euungu ta vauna ateva, poli aghi saghuighuina gheeleiaaghi me asiosiuaa nannaaghi me maamaulueaimim aue eghaa niainoana. ");
INSERT INTO emi_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Poli gheeleiaaghi karika masukasukale me llo aue atau aatu karika maate.” ");
INSERT INTO emi_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nau eteva o Iesu ghe kasu longotila tale utani uiti etingiu, tale nau manga ateva, kapuna disaepolo atoa laghe maamaloo, liuna avalua o me laghe ghaala kasina tani uiti me laghe tiuaala tani gholu. ");
INSERT INTO emi_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nau Paresi etoa laghe tarailala laghe uela etana va, “Tarala! Kapum disaepolo atoa la gheelei voto karika masina tani ghelei tale nau manga ateva.” ");
INSERT INTO emi_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Iesu ghe liula me ghe uela etaira va, “Koti karika am ghe ritila llo Deivit me kapuna atoa laghe gheleila nau laghe maamaloo? ");
INSERT INTO emi_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Vaalua ghe ssola, ia me kapuna atoa, tale alena ateva God me laghe ghaala verete laghe amangala, pristi etoa nonga la rooroo tani nama, me laghe namala. ");
INSERT INTO emi_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Me karika am ghe ritila tale inangari nipaopao eue va karika sesa arongona ta pristi etoa la uungu tale ale manga ateva ta nau manga ateva tani ghelei aiaavusuvusuena? ");
INSERT INTO emi_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Aghaauliaa etaimim va lo ateva matuutuliena uunguaane, me enaanamuu vulu ale manga ateva ia oia tale ale manga ateva. ");
INSERT INTO emi_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Karika am ghe kilala malloeana isaa o inangari va, ‘Aghi aghaaloanna va am alousiusi tee mene kateva me karika va tani ghelei niaiaavusuvusuena.’ Liuna avalua o me am ghe nim uela va sesa ila lo atoa karika righi sesa etaira. ");
INSERT INTO emi_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Poli Natuna ateva Taumattu ngateva Vau ia tale nau manga ateva.” ");
INSERT INTO emi_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iesu ghe kasu vulila ia o masaliki eteae me ghe mene lao sio tale kateae masaliki me ghe kupi ssola tale aleira ale nivelu eitaua ngateva. ");
INSERT INTO emi_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Taumattu ngateva, katelange nimane matena ia, ghe tokatoka me laghe kolomila Iesu va, “Uneita inangari nipaopao eue va masina tani ghelei emasina ta nau manga ateva?” Poli laghe paepae salana tani laoaa Iesu tale niaisakei. ");
INSERT INTO emi_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Me Iesu ghe uela etaira va, “Arova teva etaimim teva kiena sipsipi ghele katuu velu sio tale teva liu ta nau manga ateva, karika aue ughele laa ghaaie sio? ");
INSERT INTO emi_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","God aloaloannaane tale taumattu elaulau sipsipi eteva! Liuna avalua o me masina tani ghelei masi voto ta nau manga ateva.” ");
INSERT INTO emi_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Me ghe uela ta ia o taumattu ngateva va, “Korosila nimam atelange.” Me ghe korosiela me nimane atelange ghe masinala nongina mene katelange. ");
INSERT INTO emi_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Paresi etoa laghe kasula tani laa loe salana vaalua tani uvi emate Iesu. ");
INSERT INTO emi_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iesu ghe kilala sa ateva Paresi etoa laghe aloanna tani gheleia. Liuna avalua o me ghe kasu vulila ia o masaliki eteae. Oroienaaili taumattu ghe usiela me ghe ghelei emasinailala tale aneira isiki. ");
INSERT INTO emi_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Iesu ghe aaulia ngakorokorongana ta ngetaira va la rau mene laa ghaotu va ia see. ");
INSERT INTO emi_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Voto o ghe gheleila inangarina propete ateva Aisaea ghe kaurekatila, ghe uela va, ");
INSERT INTO emi_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ia oia kapughu tau ngai nongonongo anna ateva, aghi aghe suitoongainiela, me aghaaielousiangailiia, me nannaaghi emaamasinaaili ta polina; me aue aghatoka kalughu Spiriti eteva etana. Me aue eaulia ngaotu voto ghulughuluena tale patunganue akapa atoa. ");
INSERT INTO emi_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Karika aue eaissakeana me esama anamungaili ta tummatavanga. ");
INSERT INTO emi_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Aue eghelei voto masina tale taumattu saghuighuiena, me karika aue eghelei saasakiaa ta lo atoa karika sarasarakana ila. Aue eghelei isaa o voto lomosina ta llo masina eapala llo sesa. ");
INSERT INTO emi_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Patunganua akapa atoa aue la ghatoka tuutuliira tale ararina ateae.” ");
INSERT INTO emi_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Laghe maeaa sio taumattu ngateva raroai eteva ghe tokatoka etana me tee mata salusalu ia me paavoo ia. Iesu ghe ghelei emasinaiela me ghe samala me ghe taatarala. ");
INSERT INTO emi_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Me taumattu ngatoa laghe soghiaala voto ghe gheleila me laghe aikolomieinila va, “Koti taumattu ngateva oia natuna ia Deivit, va?” ");
INSERT INTO emi_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nau Paresi etoa laghe nongola laghe uela va, “Tale sarasarakaniaane Belsibul, kapuira namu ngateva raroai etoa, me egheelei isaa o voto tani tiu velu raroai tale taumattu.” ");
INSERT INTO emi_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Iesu ghe kilala nannaaira me ghe uela etaira va, “Arova masaliki eteae eaipola, karika aue etoka amasina, me lo ateae masaliki taatara o ale eaaipola karika erooroo tani tingina akorokorongana. ");
INSERT INTO emi_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Arova Satana emene tiutiu velu Satana, aue eaipola, o vaalua ararimangalina ateva aue etingina? ");
INSERT INTO emi_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Me arova atiutiu velu raroai tale ararina ateae Belsibul, kapuim atoa tani taumattu laghe tiutiu velu raroai tale ararina ateae see? Ila aue la ghele auliaa va inangari am auliaa kamena. ");
INSERT INTO emi_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Me arova atiutiu velu raroai tale Spiriti eteva kanna ia God, eaapasunga va ararimangalina ateva God ang ghe mae sio ta ngetaimim. ");
INSERT INTO emi_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Vaalua aue ughaa peina sarasarakana ateva taumattu tanganuena? Arova ughele iria mua, aue ughele roo tani ghaa peina. ");
INSERT INTO emi_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Lo ateva karika kapughu ia, tau ngai ssateeghi ia, me lo ateva karika esaasausieghi tani atoka aitauaa, ia etani aatoka apolapola. ");
INSERT INTO emi_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Liuna avalua o me aghaauliaa etaimim va God aue ekkaluaa isaa akapa ssavoto me inangari taumattu eaauliaa saasakiaa, me lo ateva eauliaa saasakiaa tale Spiriti eteva, God karika aue ekkaluaa. ");
INSERT INTO emi_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Lo ateva eauliaa saasakiaa tee Natuna ateva Taumattu ngateva, God aue ekkaluaa kanna ssavoto, me lo ateva taumattu eauliaa saasakiaa tee Spirit Manga ateva, God karika aue ekkaluaa, tale nau oia me nau ngemuli. ");
INSERT INTO emi_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Arova uue va ai eteae masina ia, utani ue tee va uenena masina. Me arova uue va ai eteae sesa ia, utani ue tee va uenena sesa. Poli ai eteae la kilakila maamasinaane me sesaane tale uenena. ");
INSERT INTO emi_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Am nongina natuira iem katu ngatoa, vaalua aue am auliaa masi voto nau eteva sesa taumattu ngam? Taumattu ngateva epoppooaa voto ekasukasu tale urunguitanina ateva. ");
INSERT INTO emi_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Masi taumattu ngateva etautau mae masi voto ekaakaai elome etana, me sesa taumattu ngateva etautau mae sesa voto ekaakaai elome etana. ");
INSERT INTO emi_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Aghaauliaa etaimim va tale nau niaisakei eteva, taumattu ngatoa aue la ghauliaa ta God asease inangari laghe nim poppooaa. ");
INSERT INTO emi_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Poli tale inangarim God aue ekoloo va masi taumattu io o sesa taumattu io.” ");
INSERT INTO emi_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Me Paresi etoa me tau ngai aapasunga tale inangari nipaopao atoa laghe uela ta Iesu va, “Tisa, ami anna tani tara righi niaimatoonga ughelei.” ");
INSERT INTO emi_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Iesu ghe liula me ghe uela etaira va, “Sesa taumattu ngam me karika am uusilaa aloannaane God, me am anna tani tara niaimatoonga. Saa ghe lutu teela propete ateva ta Jona, ie nonga o niaimatootoongana ateva aue elutu. ");
INSERT INTO emi_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nongina Jona ghe asola elome tale kova kko ateva kotolu llaa me kotolu voo, Natuna tee ateva Taumattu ngateva aue easo tale urunguitani kosa ateva kotolu llaa me kotolu voo. ");
INSERT INTO emi_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aue taumattu nge Ninive atoa la tingina tale niaisakei eitauaa teeiem, me la ue va sesa am, poli aNinive atoa laghe nna ngaioghioghiaala, nau Jona ghe poppooaa etaira, me ia oia, lo ateva namuu ia ta Jona ange toka teeiemla. ");
INSERT INTO emi_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tale nau niaisakei, aue Kuin nge Saot ateva etingina tee lo ateva oia vituu, me aue eue va sesa am, poli Kuin ateva ghe kasu emasaueiliila tani mae nongo alomasaanganiaane Solomon, me lo ateva taumattu namuu ia ta Solomon ange toka teeiemla. ");
INSERT INTO emi_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nau eteva sesa spiriti eteva ekupikupi ghoa tale taumattu ngateva, ekasukasu tale voto mallangona tani pae niainoana me nau etam tara ");
INSERT INTO emi_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","eue va, ‘Amene kiri lao tale ale ateva aghe kasu vuliela.’ Nau elaa reerekata me etaatara va ale ateva karika toa etana me kaakalaa ngaraarangisana ia me elome masina tani toka etana. ");
INSERT INTO emi_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Me emene kasu, tani laa kolo ghaitu (7) sesa spiriti gheeleiaaira mene sesaaili. Me la kupi sso, me la sso tokatoka tale ale ateva. Gheeleiaane aue esesaaili, aue elau isaa akasina. Lo ateva oia vituu aue eghelei evalua o.” ");
INSERT INTO emi_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nau Iesu ghe samasama tee taumattu ngatoa, kinna me nengane atoa laghe tiitingina eleka, laghe aloanna tani sama teeia. ");
INSERT INTO emi_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kateva taumattu ghe auliaala etana va, “Kinam me nengam taita atoa eleka, la ghanna tani sama teeio.” ");
INSERT INTO emi_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Iesu ghe liula me ghe uela etana va, “See ia kinaghi me see ila nengaghi etoa?” ");
INSERT INTO emi_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ghe suisui lao kapuna disaepolo atoa me ghe ue va, “Kinaghi me nengaghi etoa o. ");
INSERT INTO emi_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Lo ateva egheelei aloannaane Tamaghi epona liu, nengaghi ia me kapughu vause ia me kinaghi ia.” ");
INSERT INTO emi_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ia nonga o nau eteva me Iesu ghe kupi ghoala tale ale ateva me ghe lao sio tani toka tale sama ateo talia ngateae. ");
INSERT INTO emi_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Oroiannaaili taumattu ghe mae sio ta ngetana, mausina avalua o me ghe saesaela tale paanaka ateva me ghe tokala etana me taumattu ngatoa laghe tiitingina elo samarra. ");
INSERT INTO emi_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ghe ppooaala oroiannaaili voto tale kiukiu niaimatoonga. Ghe uela va, “Am nongola! Tau ngai pasa katu ue ngai eteva ghe kasula tani pasa aina katu ue ngai. ");
INSERT INTO emi_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nau eteva ghe kaokaoaala katu ue ngai, kasina ghe katuula tapaa salana me ghila atoa laghe mae sio tani nama. ");
INSERT INTO emi_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kasina ghe katuula tale voto ateva sakolo ia, karika oroi kosa me arovaeaata nonga ta ghe pinosala, poli karika lluse ia. ");
INSERT INTO emi_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Me nau sinaka ateva ghe saela ghe sinaki ematelala. Laghe matela poli oane karika ghe sio liula ta euu atu ia. ");
INSERT INTO emi_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kasina katu ue ngai ghe katuula elome tale uasa karasa. Laghe pinosala me uasa karasa ateva ghe kavili ematelala. ");
INSERT INTO emi_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Me kasina katu ue ngai ghe katuula tale masi kosa me laghe kuneaala ueira, kasina ghe kuneaala kateva ai (100), kasina ghe kuneaala ghaonomongaulu (60), me kasina kotolungaulu (30). ");
INSERT INTO emi_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Lo ateva talingane manee tani nongo, aue enongo.” ");
INSERT INTO emi_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Disaepolo atoa laghe mae sio ta Iesu me laghe kolomiela va, “Vaalua me upoppooaa kiukiu niaimatoonga ta taumattu ngatoa?” ");
INSERT INTO emi_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Iesu ghe liula me ghe uela etaira va, “Alomasaanga tale voto eaaisulia tale ararimangali ngepona liu eteva, God ghe tau aatu etaimim, me ila karika. ");
INSERT INTO emi_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","See righi voto etana, aue God emene taula me aue eghaa oroi voto, me lo ateva karika righi voto etana aue eghaa velu righi lutu voto etana. ");
INSERT INTO emi_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Liuna avalua o me aghaauliaa voto etaira tale kiukiu niaimatoonga: “Arongona ta la taatara me karika aue la tara kila, me arongona ta la nongonongo me karika aue la nongo me aloira emasaanga. ");
INSERT INTO emi_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ta ngetaira me llo Aisaea ghe aulia ngamuemua alokoila aue ekaurekati. Ghe uela va, “‘Aue am nongo me karika aue am kila; aue am tara me karika aue am alomasaanga tee. ");
INSERT INTO emi_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Urunguitaniira aue ekorokorongana, me talingaira aue evolovolongina tani nongo, me laghe akou rungaala mataira va karika la mene taatara. Ta la rau tara nonga ta mataira, me la nongo ta talingaira, va la kila ta urunguitaniira, me la kiri mae va aghelei emasinaila.’ ");
INSERT INTO emi_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Me am, niarangise etaimim, poli mataimim etaatara me talingaimim enongonongo. ");
INSERT INTO emi_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Aghaaulia ngakoronna etaimim va oroi ila propete atoa me taumattu ghulughuluena laghe aloannaaili tani tara voto am taatara ghaine, me karika laghe tarala, me tani nongo voto am nongonongo ghaine, me karika laghe nongola. ");
INSERT INTO emi_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Am nongo malloeanina kiukiu niaimatoongana ateae ta tau ngai pasa katu ue ngai eteva: ");
INSERT INTO emi_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Arova lo ateva enongonongo inangarina ararimangali eteva epona liu me alona etam maamasaangania, sesa taumattu ngateva eghaaghaa velu voto tau ngai pasa katu ue ngai eteva epasapasa tale urunguitanina ateva. Nongina katu ue ngai ghe katuula tapaa salana. ");
INSERT INTO emi_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Me llo katu ue ngai ghe katuula tale voto ateva sakolo ia, nongina taumattu ngateva enongonongo inangari me arovaeaata ta eghaaghaa me emasimasi etingina. ");
INSERT INTO emi_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Me poli karika righi oane, karika etiitingina liu nau eteva sesa nau me niaiuvii elutulutu teeia mausi inangarina God, me arovaeaata ta ekaakatuu. ");
INSERT INTO emi_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Me llo katu ue ngai ghe katuula elome tale uasa karasa nongina taumattu ngateva enongonongo inangari me enannangaili voto kamena tale kosa ateva oia me ealoannaaili va isaa oia voto aue egheleia va etue peipeiena, me ekakkaluaa inangari tale ararimangali eteva. Liuna avalua o me karika righi uene. ");
INSERT INTO emi_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Me llo katu ue ngai ghe katuula tale masi kosa nongina taumattu ngateva enongonongo inangari me alona emaamasaanga ekuukuneaa uene, kasina kateva ai (100), kasina ghaonomongaulu (60), me kasina kotolungaulu (30) oroiaane elaulau llo laghe pasa akasinala.” ");
INSERT INTO emi_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesu ghe mene auliaala kateae kiukiu niaimatoonga. Ghe uela va, “Ararimangali ngepona liu eteva nongina taumattu ngateva ghe pasala katu ue ngai masina tale utana atingiu. ");
INSERT INTO emi_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Me vara taumattu ngakapa atoa laghe lao sio tani asekanua, me tau ngai ssateena ateva ghe mae sio tani pasa ssa tuvui eteva elome tale katu uit, me ghe kasula. ");
INSERT INTO emi_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nau eteva katu uit ghe pinosala me ghe kuneaala uenenna, ssa tuvui tee ateva ghe pinosa teeilala. ");
INSERT INTO emi_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Me kapuna tau ngai nongonongo anna atoa laghe lao sio me laghe uela ta tau ngumane va, ‘Vau eteva, ami annaa va ughe vella nonga katu uit tale umam utana atingiu, me vaalua ssa tuvui eteva ghe pinosala?’ ");
INSERT INTO emi_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ghe liula me ghe uela va, ‘Tau ngai ssateeghi eteva ghe kaokaoaala.’ “Me tau ngai nongonongo anna atoa laghe kolomiela va, ‘Uanna va ami laa muke velu?’ ");
INSERT INTO emi_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ghe uela va, ‘Karika. Am rau mukemuke velu ssa tuvui etoa, va am muke velu tee uit. ");
INSERT INTO emi_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Am tau vellaluela me lalu sae aitauaa me elaa ghaa nau nisai uit. Ia o nau eteva aue aghauliaa ta lo atoa la sai uit tani ghaa akasina ssa tuvui etoa me la iri eitaueinila me pei nitungiaa me la ghaa aitauaa uit me aue la laa ghatoka tale aleghi ale nginana ateva.’” ");
INSERT INTO emi_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ghe mene auliaala kateae kiukiu niaimatoonga. Ghe uela va, “Ararimangali ngepona liu eteva nongina katu ue ngai erighi la kolokoloa va mastet, taumattu ngateva ghe ghaaiela, me ghe lao sio tani pasaia tapaa ngutana. ");
INSERT INTO emi_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Arongona ta ghaunaaili ia tale isaa akapaaili katu ue ngai me nau epiipinosa, enaanamuu vulu ekapa isaa akapa ai laghe pasala eutana. Me ia oia ai eteae ghila atoa la looloo la mae tokatoka tale laangina.” ");
INSERT INTO emi_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Me ghe mene auliaala kateae kiukiu niaimatoonga. Ghe uela va, “Ararimangali ngepona liu eteva nonginaaili isti eteva vause ateva ghe ghaaiela me ghe ghelei eitauaa teela palaoa oroieili lomosi ta palaoa ngateva ghe rrangala.” ");
INSERT INTO emi_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesu ghe aauliaa isaa akapa o voto ta taumattu ngatoa tale kiukiu niaimatoonga. Karika ghe aaulia ngamasalika teva voto ta ghe aauliaa nonga tale kiukiu niaimatoonga. ");
INSERT INTO emi_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Mausina avalua o me llo propete ateva ghe auliaala ghe kaurekatila. Ghe uela va, “Aghi aghaauliaa kiukiu niaimatoonga etaimim. Me aue akiukiuaa voto aisulianna ghe tiuaala emua arau nau God ghe gheleila kosa ateva oia.” ");
INSERT INTO emi_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nau ghe kasu vulila taumattu ngatoa, ghe ssola tale ale ateva. Me kapuna disaepolo atoa laghe lao sio etana me laghe uela etana va, “Uaulia ngamasina etaimami malloeana kiukiu niaimatoonga ngateae ta ssa tuvui eteva me utana atingiu.” ");
INSERT INTO emi_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ghe liula me ghe uela etaira va, “Natuna ateva Taumattu ngateva ia o lo ateva ghe kaokaoaala masi ue ngai. ");
INSERT INTO emi_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Me paa ngutana atingiu eaaimatoonga kosa ateva, me masi ue ngai eaaimatoonga lo atoa natuna ila ararimangali eteva. Me ssa tuvui eteva eaimatoonga natuna atoa sesa taumattu ngateva. ");
INSERT INTO emi_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Me Satana tau ngai ssateena ateva God ghe pasala ssa tuvui eteva. Me nau nisai uit eaaimatoonga airuuruu tale kosa ateva me tau ngai sai uiti etoa, la aaimatoonga ensolo atoa. ");
INSERT INTO emi_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Nongina laghe muke vella ssa tuvui eteva me laghe tungie saela tale kuraa, airuuruu tale kosa ateva aue ia avalua o. ");
INSERT INTO emi_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Natuna ateva Taumattu ngateva aue esuu kapuna ensolo atoa me aue la muke velu tale ararimangalina ateva voto akapa sesa etiitiuaa ssavoto me lo atoa la gheelei voto sesa. ");
INSERT INTO emi_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Aue la sau vella sai tale paka kura ateae ataataaili ia me aue niaingalaaii me niaingeresa ngalungalu elutu. ");
INSERT INTO emi_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Me ghulughuluena atoa taumattu aue la llaa nongina sinaka ateva tale ararimangalina ateva Tamaira ateva. Lo ateva talingane manee tani nongo, aue enongo.” ");
INSERT INTO emi_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ararimangali ngepona liu eteva nonginaaili aikaai viliki veu eteva laghe kaieiniela tale paa ngutana ateae. Nau eteva taumattu ngateva ghe taraiela ghe mene aisulieiniela me tale masimasiaane ghe aitaua ngakapala peina me laghe polila, me ghe polila ia o paa ngutana ateae. ");
INSERT INTO emi_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Me tee ararimangali ngepona liu eteva nonginaaili tau bisnisi eteva ghe paepae pel tani poli. ");
INSERT INTO emi_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nau eteva ghe tarala lo ateva pel masinaaili ia ghe lao sio, ghe aitaua ngakapala peina me laghe polila, me ghe polila ia o pel ateva. ");
INSERT INTO emi_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ararimangali ngepona liu eteva nonginaaili uvena ateae laghe velue siola tale ateo talia ngateae me ghe ghaala asease kko atoa. ");
INSERT INTO emi_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nau eteva ghe pasula, tau luku etoa laghe aea ssola elae me laghe toka siola me laghe ghaala masi kko, laghe kaaila tale keru, me laghe sau vella llo sesa. ");
INSERT INTO emi_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Airuuruu tale kosa ateva aue ia avalue ia o, aue ensolo atoa la mae pola sesa atoa ta ghulughuluena atoa taumattu, ");
INSERT INTO emi_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","aue la sau vella sai tale paka kura ateae ataataaili ia me aue niaingalaaii me niaingeresa ngalungalu elutu.” ");
INSERT INTO emi_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iesu ghe kolomilala va, “Aloimim ange masaangala isaa o voto?” Me laghe uela va, “Ue.” ");
INSERT INTO emi_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Me ghe uela etaira va, “Liuna avalua o me isaa akapa tau ngai aapasunga tale inangari nipaopao laghe disaepolola tale ararimangali ngepona liu eteva nonginaaili taumattu ngateva eghaaghaa ouna me pokane masi voto tale rum atiulu la ghatoka masi voto etana tale alena ateva.” ");
INSERT INTO emi_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nau eteva Iesu ghe ruula tani auliaa isaa o kiukiu niaimatoonga me ghe kasu vulila ia o voto ateva. ");
INSERT INTO emi_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ghe lao sio tale masalikina tunga ateae me ghe tiuaala tani apasunga ta taumattu ngatoa tale aleira ale nivelu eitauaa. Me laghe soghiaala voto ghe aauliaa me ghe gheelei, me laghe kookolomi va, “Ia oia taumattu ngateva eaa ghe ghaala alomasaanga me sarasarakana tani ghelei mirikolo? ");
INSERT INTO emi_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ita kilakila va natuna ia tau ngai atulu ale ateva ia oia taumattu ngateva, me ararina ateae kinna ta Meri me nengana atoa ta Jeimis, Josep me Saemon me Jiuda. ");
INSERT INTO emi_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Me kapuna vause akapa atoa la tokatoka teeita. Me arova eaa ghe ghaala isaa o voto?” ");
INSERT INTO emi_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Me ang ghe sessaila etana. Me Iesu ghe uela etaira va, “Propete ateva la oneoneainia tale kasina ppae masaliki, me tale masalikina tunga ateae me tanganuena, karika.” ");
INSERT INTO emi_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Karika ghe gheleila righi oroi mirikolo tale ia o masaliki eteae poli karika laghe aikaaiaa etana. ");
INSERT INTO emi_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Isaa o nau, gavana ngateva Herot ghe nongonongo kiukiuna Iesu. ");
INSERT INTO emi_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Me ghe uela ta kapuna tau ngai uungu etoa va, “Ia oka taumattu ngateva Jon tau ngai aasuu ia etana ghe mene totula tale nimate! Liuna avalua o me sarasarakanaaili ia tani ghelei mirikolo.” ");
INSERT INTO emi_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Poli emua akasina, Herot ghe suula inangari me laghe poso atokala Jon me ghe iriela me ghe atokaie ssola tale ale mata voovoo poli Herodias, vausenna ia tuena ta Pilip. ");
INSERT INTO emi_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Poli Jon ghe ue ta Herot va, “Karika masina ta ughe lai sariela.” ");
INSERT INTO emi_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot ghe anna tani uvi ematea me poli ghe maamatauta taumattu ngatoa ta ila laghe ue va Jon propete ia, liuna avalua o me karika ghe roola tani uvi ematea. ");
INSERT INTO emi_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nau eteva ghe rekatala tani nnaa nau eteva Herot ghe lutula etana, natuna vause ateva Herodias ghe ssiiuaala ta mataira Herot me kapuna atoa, me Herot ghe masimasiangailiiela, ");
INSERT INTO emi_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","me ghe auliaala inangari nialokoi me ghe aulia ngakoronnaailiila etana va aue etaula saa voto aue ekolomi. ");
INSERT INTO emi_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Me kinna ghe auliaa tau lao sio ninanna ngateva me ghe uela va, “Ghaine arau aghaloanna uruna ateva Jon tau ngai aasuu ia tale tivilau terei.” ");
INSERT INTO emi_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","King ghe alousiusila, me poli ghe gheleila inangari nialokoi eteva ta mataira namu ngatoa, ghe auliaala va la taula llo ghe kolomila. ");
INSERT INTO emi_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Me ghe suula soldia ngatoa me laghe sai pulela alona atiulu Jon tale ale mata voovoo. ");
INSERT INTO emi_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Laghe sau lao sio uruna ateva Jon tale terei etivilau me ghe taue lao sio ta aliki vause ateva. Ghe ghaaiela me ghe laoainie sio ta kinna. ");
INSERT INTO emi_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kapuna disaepolo atoa Jon laghe mae sio tani ghaa vaulanna ateva Jon me laghe lao sio tani kaieinia. Me laghe lao sio tani auliaa ta Iesu. ");
INSERT INTO emi_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iesu ghe nongola isaa o voto ghe lutula me ia nonga me disaepolo atoa laghe aikaaila tale paanaka ateva tani lao tale vaara. Nau eteva taumattu ngatoa laghe nongola, laghe kasu vulila masalikiira me laghe kasuaala tani laa ghaimuli teeia. ");
INSERT INTO emi_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nau Iesu ghe ssola elae, ghe tarala oroieili taumattu ngatoa. Ghe alousiusi teeilala me ghe ghelei emasinailala tale aneira isiki. ");
INSERT INTO emi_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Auena sinaka ateva ghe suu me disaepolo atoa laghe lao sio etana me laghe uela va, “Voto ateva oia vurunganna ia, me ange aaitarrauii. Sungi vella taumattu ngatoa me la lao tale masaliki taumattu etana me la laa poli righi aneira inana.” ");
INSERT INTO emi_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Iesu ghe liula me ghe uela va, “La rooroo tani toka. Am taula righi inana, me la nama.” ");
INSERT INTO emi_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Disaepolo atoa laghe uela va, “Ami posoposo ghalima nonga verete me ghalua kko.” ");
INSERT INTO emi_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Iesu ghe uela va, “Am maeaa sio etaghi.” ");
INSERT INTO emi_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Me ghe auliaala ta taumattu ngatoa va la toka sio tale rarrasa me ghe ghaala verete ghalima me kko alua, me ghe taatara saela epona liu me ghe kaili emasina saela, me ghe pirila, me ghe tau lao sio ta disaepolo atoa me ila laghe lao sio tani aikoita ta taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Laghe namanamala me ghe ssoilala, me disaepolo atoa laghe kaai esokosokoiaala kasangaulu ghaluae (12) laka tale tapiri nginana ghe oghila. ");
INSERT INTO emi_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Lo atoa laghe namanamala ghe roola ghalima airari (5,000) taita, karika iraira tee vause me aliki etoa. ");
INSERT INTO emi_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Gheania nonga ta Iesu ghe auliaala va kapuna disaepolo atoa laghe aikaai tale paanaka ateva, me laghe muemue lao ta pai kativilau me ia ghe sungi velu mua taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Vara ghe sungi vellala, me ie nonga ghe saela tale motouru tani looloo sae. Ie nonga, me ghe aitarrauiila. ");
INSERT INTO emi_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Paanaka ateva ang ghe mala masau ghoala me kotoo atoa angila ghe uviuvia poli laghe sousou kuukuu eteva. ");
INSERT INTO emi_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Elopai me Iesu ghe laa ghoa rekata etaira ghe kasukasu epona tale paamanu eteva. ");
INSERT INTO emi_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nau eteva disaepolo atoa laghe taraiela ta ghe kasukasu epona tale paamanu ghe moi saasakieinilala me laghe ue va, “Raroai ia!” Me laghe aaipiia poli laghe maamatautu. ");
INSERT INTO emi_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Me gheania nonga ta Iesu ghe sama teeilala, me ghe uela va, “Am rau mene annaa, ta aghi oia. Am rau mene matautu.” ");
INSERT INTO emi_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Me Pita ghe uela ta Iesu va, “Vau eteva! Arova koronna va io Iesu, uauliaa mae etaghi me akasu mae etam epona tale paamanu.” ");
INSERT INTO emi_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Iesu ghe uela va, “Kkure sio mae.” Me Pita ghe kkure vulula paanaka ateva me ang ghe kasukasu elaolao ta Iesu epona tale paamanu. ");
INSERT INTO emi_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Me vara ghe tarala kotoo ateva me ang ghe maamatautu me ang ghe lullusu me ang ghe kolokolo, ghe ue va, “Vau eteva, asaangieghila!” ");
INSERT INTO emi_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Gheania nonga ta Iesu ghe ssuuaala nimane me ghe kunela Pita me ghe uela va, “Ghaunaaili unem niaikaaiaa. Vaalua me eghaaghalua nannaam?” ");
INSERT INTO emi_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Me nau eteva lalu ghe saesaela tale paanaka ateva me kuukuu eteva ghe kapala. ");
INSERT INTO emi_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Me lo atoa tale paanaka ateva laghe kkaueiniela, me laghe ue va, “Koronnaaili va Natuna io God.” ");
INSERT INTO emi_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Laghe ose longotila me laghe kautula tale distriki eteva eGenesaret. ");
INSERT INTO emi_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nau eteva taumattu ngatoa tale ia o masaliki eteae laghe tara kilala Iesu, laghe suula inangari ta mene katoa masaliki me taumattu ghe maeaa sio kapuira tau sessa etana. ");
INSERT INTO emi_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Me laghe tani kookolomi ekorokorongana ia va etau velu tau sessa atoa me la nim poso sama ghinnanina. Lo atoa laghe posoposo sama ghinnanina Iesu laghe maamasina. ");
INSERT INTO emi_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Katoa Paresi me tau ngai aapasunga tale inangari nipaopao, laghe kasula eJerusalem me laghe mae sio ta Iesu tani kolomia va, ");
INSERT INTO emi_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mausi saa me kapum disaepolo atoa karika la ghaaimuli tee voto tuvuita atoa laghe apasungaala etaita va ita gheelei? Karika la porapora nimaira nau la namanama.” ");
INSERT INTO emi_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iesu ghe liula me ghe uela va, “Me vaalua me karika am aaimuli usi tee inangari nipaopao kanna God me am aaimuli usi tee voto tuvuimim atoa laghe apasungaala va am gheelei? ");
INSERT INTO emi_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Poli God ghe uela va, ‘Am oneoneaa tamaimim me kinaimim,’ me, ‘Lo ateva ekaakasikiena tamana o kinna aue la uvi ematea.’ ");
INSERT INTO emi_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Me am auliaa va arova kateva righi peina erooroo tani sausi tamana o kinna, me eue etairarua va, ‘Peighi tani sausiemalua ngagheleila inangari nialokoi tani taula ta Vau palepale,’ ");
INSERT INTO emi_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","am aapasunga va ia o taumattu ngateva karika erooroo tani oneoneaa tamana o kinna. Tale isaa o ase salana am gheelei inangarina God enim peepeisaane, ta am aaimuli usi tee aauliaaira tuvuimim atoa. ");
INSERT INTO emi_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Am usimaghalua am! Propet Aisaea ghe aulia ngakoronnala nau ghe aulia ngamuemua alokoila gheeleiaaimim, ghe uela va: ");
INSERT INTO emi_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Isaa oia taumattu la nim oneoneainaghi ta paaira me urunguitaniira masaueili etaghi. ");
INSERT INTO emi_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Karika righi malloeana uneira nikkauaa poli la ghaapasunga llo nim kaluira taumattu ngatoa nonginaaili va kanna God.’” ");
INSERT INTO emi_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iesu ghe kolola taumattu ngatoa me ghe uela etaira va, “Am nongo me aloimim emasaanga! ");
INSERT INTO emi_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Saa llo voto ekupikupi sso elome tale paa taumattu ngateva, karika egheleia va etam raarangisana, ta saa llo voto epoppooaa ekupikupi ghoa tale paane ateva egheeleia etam raarangisana.” ");
INSERT INTO emi_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Vara me disaepolo atoa laghe mae sio tani auliaa ta Iesu va, “Ukilakila va Paresi etoa esessaila tale inangari uauliaala?” ");
INSERT INTO emi_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Iesu ghe liula me ghe uela va, “Isaa akapaaili voto eutana Tamaghi epona liu karika ghe pasala, aue emuke akapaaili. ");
INSERT INTO emi_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Am rau mene annaa isaa o ase taumattu! Ila nongina mata salusalu, la ghaloanna tani apasunga salana ta katoa, me arova mata salusalu eteva ekatulaa mene kateva mata salusalu, ilalua akapa aue lalu kupi tale liu.” ");
INSERT INTO emi_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Vara me Pita ghe uela va, “Erooroo va uauliaa malloeanina isaa o inangari?” ");
INSERT INTO emi_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Iesu ghe liula me ghe uela va, “Vaalua? Am tee aloimim karika ghe masaanga? ");
INSERT INTO emi_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Karika am kilakila? Saa llo voto ekupikupi sso tale paa taumattu, esiosio tale kova taumattu, me emene kupikupi ghoa nau taumattu ngateva elaa tiutiu. ");
INSERT INTO emi_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Me saa llo voto ekupikupi ghoa tale paa taumattu, ekasukasu tale urunguita, isaa o voto egheeghelei taumattu ngateva etam raarangisana. ");
INSERT INTO emi_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tale isaa akapa voto urunguita ateva eaalutu sesa ninanna, tani aiuvi emate, tani lai sari katoa maneeira, tani lai saasaloaa, niainao, inangari kamena me niauliaa saasakiaa. ");
INSERT INTO emi_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Isaa o voto egheeghelei taumattu ngateva etam raarangisana, me tani namanama me karika upora nimam, isaa o llo karika eghelei taumattu ngateva etam raarangisana.” ");
INSERT INTO emi_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iesu ghe kasu vulila lo ateae o masaliki me ghe lao sio tale llo masaliki kalakalangina eTaer me eSaedon. ");
INSERT INTO emi_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Vauseni nge Keinan ateva, ghe tokatoka tale ia o pai etivilau, ghe mae sio ta Iesu, me ghe sama anamuula va, “Vau eteva, Natuna io Deivit, ualousiusi teeieghi! Natughu vause ateva raroai eteva etokatoka etana me egheelei saasakieinia.” ");
INSERT INTO emi_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Iesu karika poi ghe nim aaisaueinia. Kapuna disaepolo atoa laghe lao sio me laghe aauliaa etana va, “Sungi aoghiela! Eusiusita me egheelei kinatama mangalia ateva!” ");
INSERT INTO emi_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Iesu ghe liula me ghe uela va, “God ghe sungieghila nonga tani mae sausi lo atoa aIsraeli ang ghe raulala.” ");
INSERT INTO emi_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Vara me vause ateva ghe mae sio ghe suuiaala ta liue kkena Iesu, me ghe uela va, “Sausieghila, Vau eteva!” ");
INSERT INTO emi_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iesu ghe liula me ghe uela va, “Karika masina tani tau lao aneira inana aliki etoa ta paua atoa.” ");
INSERT INTO emi_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Vause ateva ghe liula me ghe uela va, “Koronnaaili, Vau eteva. Me paua tee atoa la namanama aneira vorovoro nginana vauira atoa ekaakatuu tale uneira tevoo.” ");
INSERT INTO emi_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Iesu ghe liula me ghe uela etana va, “Vause ateva, niaikaaiaa etam namungaili! Saa llo voto ualoanna va elutu etam, aue elutu.” Ia arau o nau eteva, natuna vause ateva ghe masinala. ");
INSERT INTO emi_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesu ghe kasu vulila voto ateva o, me ghe lao akalakalangina sio tale ateo talia ngateae eGalilii. Ghe saela tale motouru eteva me ghe toka siola. ");
INSERT INTO emi_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Oroieili ila taumattu ngatoa laghe mae sio etana, laghe maeaa sio lo atoa kasukasuaaira sesa, mata salusalu, riu makeakeana, paavoo me oroieili ila tau sessa atoa, laghe atokailala tale liue kkena Iesu, me ghe ghelei emasinailala. ");
INSERT INTO emi_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Taumattu ngatoa laghe annangailiila nau laghe tarala paavoo atoa laghe samala, lo atoa riuira makeakeana laghe korosilala, lo atoa kasukasuaaira sesa laghe masinala, me mata salusalu etoa ghe otila mataira. Me laghe tau saela kapuira Goto ateva aIsraeli etoa. ");
INSERT INTO emi_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iesu ghe kolola kapuna disaepolo atoa, me ghe uela va, “Aghaalousiusi tee taumattu ngatoa, ta laghe toka aitauaa teeieghila kotolu nau, me ghaine karika righi inana va la nama. Karika aghaloanna tani suu vella me maloona ila, la rau taatarruu elaolao va la katuu etapaa salana.” ");
INSERT INTO emi_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Disaepolo atoa laghe kolomiela va, “Eaa ita ghele laa ghaa righi inana ghelei oroieili tale voto ateva oio vurunganna ia, me ita anginila taumattu ngatoa oio oroienaaili ila?” ");
INSERT INTO emi_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Iesu ghe kolomila va, “Ghaisa akapa verete am uunusi?” Me laghe liula me laghe uela va, “Ghaitu (7) verete me lutu kko ghauna.” ");
INSERT INTO emi_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Me Iesu ghe auliaala ta taumattu ngatoa va la toka sio tale kosa. ");
INSERT INTO emi_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Vara me ghe ghaala ghaitu verete me kko, me ghe kaili emasina saela, ghe pirila, me ghe taula ta kapuna disaepolo atoa, me disaepolo atoa laghe tau lao sio ta taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ila akapa laghe namanamala me laghe tuvula. Vara me disaepolo atoa laghe kaai aitauaala tapiri nginana ghe oghila, ghe roola ghaituae (7) laka. ");
INSERT INTO emi_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ila akapa taita atoa laghe namanamala, ghe roola ghaata airari (4,000), karika laghe ioila vause atoa me aliki etoa. ");
INSERT INTO emi_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Vara me Iesu ghe suu vella taumattu ngatoa, me ghe aikaaila tale paanaka ateva, me ghe lao sio tale masaliki etoa kalakalangina ila tale distriki eteva eMagadan. ");
INSERT INTO emi_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Paresi etoa me Sadiusi etoa laghe lao sio ta Iesu, me laghe kolomiela va eapasunga teva niaimatoongana ngepona liu. Laghe auliaa llo tani nim tootoongainia. ");
INSERT INTO emi_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ghe liula me ghe uela va, “Nau ange elo alai am ue va, ‘Aue masi nau poli karaane ateva eraeraeana,’ ");
INSERT INTO emi_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","me elue talaua am ue va, ‘Ghaine ettasi poli karaane ateva ange raeraeanala me ange aavoo.’ Am taatara kila kookoo ngateva me karika am taatara kila niaimatoonga tale nau. ");
INSERT INTO emi_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Sesa taumattu ngam me karika am uusilaa aloannaane God, am anna tani tara niaimatoonga. Saa ghe lutu teela Jona, ie nonga o niaimatootoongana ateva aue elutu.” Vara me Iesu ghe kasu vulilala me ghe lao ppae sio. ");
INSERT INTO emi_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nau laghe lao sio ta pai kativilau tale ateo talia ngateae me disaepolo atoa laghe tarala va laghe aikkaluaala verete. ");
INSERT INTO emi_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iesu ghe uela etaira va, “Am aikinikinitaa tani tara amasina uneira isti Paresi me Sadiusi etoa.” ");
INSERT INTO emi_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Laghe aikolomieinila tani ue va, “Koti eaauliaa llo oia poli karika ita ghaala righi verete.” ");
INSERT INTO emi_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iesu ghe kilala sa ateva laghe aissakeana teeia me ghe uela etaira va, “Uneimim niaikaaiaa ghaunaaili, vaalua me am aissakeana va poli karika righi verete? ");
INSERT INTO emi_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Vaalua, aloimim karika ghe masaanga? Karika am annaa ghalima verete ghe roola ta ghalima airari (5,000) me ghaisae keru am ghe kaaila? ");
INSERT INTO emi_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Me karika am annaa ghaitu verete ghe roola ta ghaata airari (4,000) taumattu me ghe roola ghaisae laka am ghe kaaila? ");
INSERT INTO emi_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Vaalua, me karika am kilakila va karika va aghaauliaa verete? Am aikinikinitaa tani tara amasina uneira isti Paresi me Sadiusi etoa.” ");
INSERT INTO emi_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Vara me laghe vira mene kilala va ghe aauliaa llo Paresi me Sadiusi etoa laghe aapasunga, me karika va la taatara amasina tale isti la ghelei tale verete. ");
INSERT INTO emi_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nau Iesu ghe lao sio tale voto ateva kalakalangina ia eSiisaria Pilipae, ghe kolomila kapuna disaepolo atoa va, “Taumattu ngatoa la ue va see ta Natuna ateva Taumattu ngateva?” ");
INSERT INTO emi_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Laghe liula me laghe uela va, “Katoa la ue va Jon tau ngai aasuu ia, me katoa la ue va Elaija, me katoa la ue va Jerimaea o mene katoa tani propete.” ");
INSERT INTO emi_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Me ghe kolomilala va, “Me am, am ue va aghi see?” ");
INSERT INTO emi_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saemon Pita ghe liula me ghe uela va, “Io Mesaea io, Natuna io God ateva tokatoka liu ia.” ");
INSERT INTO emi_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Iesu ghe liula me ghe uela va, “Niarangise etam Saemon natuna io Jona, poli karika teva taumattu eauliaa tau aatu llo ona ta Tamaghi etokatoka epona liu. ");
INSERT INTO emi_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Me aghaauliaa etam va io Pita, me tale ia o atu eteva aue aghatulu aleghi ale manga ateva etana, me atamana ateae tale voto ateva aleira ia matena atoa karika erooroo tani apalaia. ");
INSERT INTO emi_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Aue atau aatu kii eteva tale ararimangali ngepona liu eteva; saa llo ugheelei runga tale kosa ateva, aue la ghelei runga tee epona liu, me llo utautau velu tale kosa ateva aue la tau velu tee epona liu.” ");
INSERT INTO emi_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Me ghe paola kapuna disaepolo atoa va la rau mene laa ghauliaa see va ia Mesaea ia. ");
INSERT INTO emi_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Isaa o nau Iesu ghe tiuaala tani aulia ngamasalika ta kapuna disaepolo atoa va aue etani sae eJerusalem me aue esae ghaa oroieili mmarikana, ta namu ngatoa, me namu ngatoa ta pristi etoa me tau ngai aapasunga ngatoa tale inangari nipaopao, me aue la uvi ematea, me aue kotonna ateva nau, emene totu. ");
INSERT INTO emi_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita ghe koloala me lalu ghe laa tingina ppae sio, me ghe tiuaala tani kisoia, ghe ue va, “Karika, Vau eteva! Isaa o voto karika erooroo tani lutu ta ngetam.” ");
INSERT INTO emi_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Iesu ghe kiriela me ghe uela ta Pita va, “Kasu vulieghila, Satana! Ugheelei rungarunga salaghi. Nannaam karika eannaa voto kanna God ta voto kaluira taumattu ngatoa.” ");
INSERT INTO emi_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Vara me Iesu ghe uela ta kapuna disaepolo atoa va, “Lo ateva eanna tani usieghi, etani sioaa nannaane me erau mene nnainia nonga me esunuki unna aikotoo ateva, me eaimuli teeieghi. ");
INSERT INTO emi_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Poli see eanna tani asaangi maamauluaane aue eraua, me lo ateva maamauluaane eraua ta poli mausighi aue emene ghaa. ");
INSERT INTO emi_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Saa righi masi voto aue elutu arova taumattu ngateva ghele ghaa voto akapaaili tale kosa ateva me ghele rau maamauluaane? O sa ateva aue ghele tauela tani aikolikolieinia tani mene ghaa maamauluaane? ");
INSERT INTO emi_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Poli Natuna ateva Taumattu ngateva aue emae tee mallangina ateva Tamane me kapuna ensolo atoa me aue etaula aipoliira kateva kateva taumattu tale voto laghe gheleila. ");
INSERT INTO emi_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Aghaaulia ngakoronna etaimim va katoa oia am tiitingina, karika aue am mate me aue am tara Natuna ateva Taumattu ngateva emae tee ararimangalina ateva.” ");
INSERT INTO emi_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ghaonomo (6) nau ghe lange sio me Iesu ghe kolola Pita, Jeimis me Jon nengana Jeimis, me ila nonga laghe saela tale motouru eteva saesaenaaili ia. ");
INSERT INTO emi_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tale ia o voto ateva taataraane Iesu ghe aikolikoliaala emua ta mataira. Matana ghe lallaa arova sinaka ateva, me ghinnanina ghe usola arova mallanga ateva. ");
INSERT INTO emi_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Vara me Moses me Elaija lalu ghe kaurekatila me lalu ghe tiuaala tani sama tee Iesu. ");
INSERT INTO emi_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Me Pita ghe uela ta Iesu va, “Vau eteva, masinaaili ta ita sae mae oia. Arova uanna, aue aghelei kotolu ale paapali, kateva alem ia, me kateva alena ia Moses, me kateva Elaija.” ");
INSERT INTO emi_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita ghe aippooaa nonga me kookoo ngateva mallanginaaili ia ghe akoulala me lingi ngalo ateva elome tale kookoo ngateva ghe uela va, “Ia o natughu eteva aghaailousieinia, me masimasiaaghi ta ngetana namungaili. Am nongoa.” ");
INSERT INTO emi_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nau eteva disaepolo atoa laghe nongola, laghe aso siola tapaa kosa, mataira ghe tau siola euu. Me laghe matautu etinginala. ");
INSERT INTO emi_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Iesu ghe lao sio me ghe posolala me ghe uela etaira va, “Am totula. Am rau mene matautu.” ");
INSERT INTO emi_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nau eteva laghe atangaro saela, karika laghe tarala righi taumattu ta laghe tarala nonga Iesu. ");
INSERT INTO emi_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nau laghe mae siosio tale motouru, me Iesu ghe ttoieinilala va la rau mene auliaa ta mene teva saa llo laghe tarala lomosina ta Natuna ateva Taumattu ngateva etotu tale nimate. ");
INSERT INTO emi_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Me disaepolo atoa laghe kolomiela va, “Vaalua me tau ngai aapasunga tale inangari nipaopao la ue va Elaija aue etani muemue mae?” ");
INSERT INTO emi_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Iesu ghe liula me ghe uela va, “Elaija aue emae akasina tani ghelei emasina akapa voto. ");
INSERT INTO emi_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Me aghaauliaa etaimim va Elaija ghe mae sio me karika laghe tara kilaiela, me laghe ghelei teeiela isaa akapa voto laghe anna tani ghelei etana. Tale ie nonga o salana atikirighi Natuna ateva Taumattu ngateva aue eghaa nimmarikana ta nimaira.” ");
INSERT INTO emi_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Me nannaaira disaepolo atoa ghe vira mene masalikela tani kila va ghe auliaa Jon tau ngai aasuu ia etaira. ");
INSERT INTO emi_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nau laghe rekatala nongina taumattu ngatoa, taita ateva ghe lao sio tani tara Iesu me ghe suuiaala emua ta Iesu. ");
INSERT INTO emi_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Me ghe uela va, “Vau eteva, ualousiusi tee natughu taita arighi, poli eoo me egheeleia esessaaili me oroiaata ta ekaakatuu velu sae tale kuraa me tale manu tee. ");
INSERT INTO emi_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Amaeainie sio ta kapum disaepolo atoa me karika la roola tani ghelei emasinaia.” ");
INSERT INTO emi_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Me Iesu ghe liula me ghe uela va, “Am lo ateva oia vituu, karika righi uneimim niaiesoaa, nannaaimim me gheeleiaaimim karika ghulughuluena. Ghaisaata aue atoka aitauaa teeiem? Me aue ghaisaata aue atoiem va am aiesoaa? Am ghaa mae sio aliki eteva etaghi.” ");
INSERT INTO emi_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Iesu ghe paola raroai eteva, me ghe kasu vulila aliki eteva me ia arau o nau eteva, aliki eteva ghe masinala. ");
INSERT INTO emi_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Me disaepolo atoa laghe lao sio tani tara Iesu nau ie nonga me laghe kolomiela va, “Vaalua me ami karika ami roola tani tiu velu raroai eteva?” ");
INSERT INTO emi_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Iesu ghe liula me ghe uela va, “Poli uneim niaikaaiaa ghaunaaili. Aghaaulia ngakoronna etaimim va, arova uneimim niaikaaiaa naanamungaane nongina katu ue ngai erighi ghaunaaili ia (mastet), am rooroo tani ue ta motouru eteva o va, ‘Kasula ona me umene lao teke,’ aue ghele kasu. Aue am rooroo tani ghelei voto akapa.” ");
INSERT INTO emi_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nau eteva laghe mae aitauaa sio eGalilii me Iesu ghe uela etaira va, “Natuna ateva Taumattu ngateva aue la tauela ta nimaira taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Aue la uvi ematea me vara aiaakotonna ateva nau me aue emene totu.” Nau disaepolo atoa laghe nongola laghe alousiusila. ");
INSERT INTO emi_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Vara me Iesu me kapuna disaepolo atoa laghe laa rekata sio eKapenium, me lo atoa taumattu laghe ghaaghaa takis moni pei tale ale manga ateva laghe uela ta Pita va, “Kapuimim tisa ngateva eveluvelu takis tale ale manga ateva?” ");
INSERT INTO emi_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Me Pita ghe uela va, “Ue, eveluvelu.” Me Pita ghe kupi ssola tale ale ateva, me Iesu ghe sama akasinala tani ue ta Pita va, “Saemon, uannaa va kingi etoa tale kosa ateva oia la ghaaghaa takis tale ase voto atoa ta see atoa, ta kapuira atoa o ta mene katoa ppae?” ");
INSERT INTO emi_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Me Pita ghe uela va, “La ghaaghaa takis ta mene katoa ppae.” Me Iesu ghe uela etana va, “Mausina avalua o me kapuira atoa la tam tautaula takis. ");
INSERT INTO emi_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ta rau gheleila va esessaila etaita, siola tale ateo talia ngateae me uvelu ghoa unem airrekati eteae. Me nau urrekati aitiutiu eteva kko, uoti paane ateva, me aue ughaa viliki veu etivilau. Ughaaia me ulaa tauela etaira aipoli kaluitalua takis.” ");
INSERT INTO emi_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Isaa o nau disaepolo atoa laghe lao sio ta Iesu me laghe kolomiela va, “See atoa namuu ila tale ararimangali ngepona liu eteva?” ");
INSERT INTO emi_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iesu ghe kolola aliki erighi me ghe atinginaiela elome etaira. ");
INSERT INTO emi_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Me ghe uela va, “Aghaaulia ngakoronna etaimim va am aikolikoliaa me am nongina lutu ngaliki etoa, arova karika, karika aue am kupi sso tale ararimangali ngepona liu eteva. ");
INSERT INTO emi_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Liuna avalua o me lo ateva esioaa nannaane nongina aliki eteva o, namuu ia tale ararimangali ngepona liu eteva. ");
INSERT INTO emi_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Me see emasimasi tani ghaa lutu ngaliki etoa poli ararighi eteae eghaaghaa teeieghi. ");
INSERT INTO emi_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Arova aliki erighi eaaiesoaa etaghi, me teva taumattu eghelei unna niaikaaiaa ekatuu, ghele masinaaili ta arova la ghele iri teva paka ngatu ta ngalona, me la ghele ghoa allusia elo malionge. ");
INSERT INTO emi_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Aue esesaaili ta taumattu tale kosa ateva mausi voto la gheelei me katoa tani taumattu uneira niaikaaiaa ekaakatuu. Isaa o voto aue elutu me aue esesaaili ta lo ateva taumattu egheelei voto o elutulutu. ");
INSERT INTO emi_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Arova nimam o kekem egheeleio me ukaakatuu tani ghelei voto sesa, usai kotoo me usau velu. Aue masina arova ughaa maulue me katelange kekem me nimam karika ia, me karika masina arova nimam me kekem masina me aue la sau veluo sae tale kura ateae tokatoka liu ia. ");
INSERT INTO emi_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Me arova teva matam egheeleio me ukaakatuu tani ghelei voto sesa, uvaliki velua me usau velu, masina tani ghaa maulue ta kateva nonga matam, me karika masina arova matam akapa alua me la sau veluo sae tale kuraa ateae eGehenna. ");
INSERT INTO emi_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Karika am mene tara aliki etoa va peisaane ila. Aghaauliaa etaimim va kapuira ensolo atoa la laa reerekataa ta matane Tamaghi epona liu. ");
INSERT INTO emi_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Vaalua am annaa? Arova teva taumattu kiena sipsipi erooroo kateva ai (100) me kateva ghele tiu ppae, am annaa va karika aue ghele kasu vuli ghasiongaulu ghasio (99) tale voto saesaena me ghele kasu tani laa pae lo ateva ghe tiu ppaela? ");
INSERT INTO emi_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Arova ghele taraia, aghaaulia ngakoronna etaimim va masimasiaane tale ia o sipsipi eteva namungaili me tale lo ghasiongaulu ghasio (99) karika laghe tiu ppaela. ");
INSERT INTO emi_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tale ia nonga o salana atikirighi Tamaim ateva epona liu karika eanna va teva ta lutu ngaliki etoa eraua. ");
INSERT INTO emi_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Arova teva tuem o nengam eghelei teeio righi voto sesa, ulaa taraia me uauliaa voto sesa egheleila etam elome etaimalua nonga. Arova enongo usilainio, angu sausiela tani ghaa oghia. ");
INSERT INTO emi_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Arova etam nongo usilainio, ughaa kateva o ghalua tani mene laa taraia me la rooroo tani auliaa va voto o koronna. ");
INSERT INTO emi_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Arova etam nongo usilainila, am auliaa tale ale manga, me arova etam nongo usilaa tee ale manga, am tau velua, me enim toka nongina tau ngeleka ateva o tau ngai ghaa takis. ");
INSERT INTO emi_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Aghaaulia ngakoronna etaimim va voto llo am gheelei runga tale kosa ateva, aue la ghelei runga tee epona liu, me llo am tautau velu tale kosa ateva aue la tau velu tee epona liu. ");
INSERT INTO emi_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Amene aauliaa etaimim va arova lo alua taumattu tale kosa ateva lalu mae aitauaa tale kateva nonga ninannaa me lalu kolomieghi tale righi voto aue Tamaghi epona liu aue ghele taula. ");
INSERT INTO emi_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Poli arova ghalua o kotolu la maemae aitauaa tale ararighi eteae, aghi atokatoka aitauaa teeila.” ");
INSERT INTO emi_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Me Pita ghe mae sio ta Iesu me ghe kolomiela va, “Vau eteva, aue ghaisaata akkaluaa voto sesa ateva tueghi o nengaghi ghele ghelei etaghi, aue esae ta ghaituaata (7)?” ");
INSERT INTO emi_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iesu ghe liula me ghe uela va, “Aghaauliaa etam va karika va ghaituaata nonga, ta ghaitungauluaata me mene ghaitu (77). ");
INSERT INTO emi_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Liuna avalua o me ararimangali ngepona liu eteva nonginaaili kateva king ghe aloanna tani ghelei eghulughuluena uneira dinao kapuna tau ngai nongonongo anna atoa. ");
INSERT INTO emi_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nau ghe tiuaala, laghe maeaa sio ia o taumattu ngateva unna kinatama dinao ateva. ");
INSERT INTO emi_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Poli karika ghe rooroo tani liu, vauna ateva ghe uela va la laa taua me la polia, ia me vausenna ateva me natuna atoa me peina akapa atoa, tani liu unna dinao ateva. ");
INSERT INTO emi_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ia o tau ngai nongonongo anna ateva ghe suuiaala patu kkena emua etana me ghe annala va vauna ateva ealousiusi teeia me aue eliu ekapa voto. ");
INSERT INTO emi_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Vauna ateva ghe alousiusi teeiela me ghe uela va vulla tani liu unna dinao, me ghe tau veluela me ghe kasula. ");
INSERT INTO emi_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nau ghe kasula, ghe lao sio me ghe tarala kateva kapuna lalu ghe uungu eitauaa ghe dinaola etana ta kateva ai (100) silva koen. Ghe poso atokaiela me ang ghe aloanna tani kii pule alona atiulu. Me ghe ue etana va, ‘Utani liu kalum dinao ateva.’ ");
INSERT INTO emi_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Kapuna ateva lalu ghe uungu eitauaa ghe suuiaala patu kkena emua etana me ghe anna va ghe alousiusi teeia me aue ghe liu unna dinao ateva. ");
INSERT INTO emi_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Me kapuna ateva ghe ratila, ghe tani atoka ssola taumattu ngateva tale ale mata voovoo lomosina ta ghe tani liula kanna dinao ateva. ");
INSERT INTO emi_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nau mene katoa tani tau ngai nongonongo anna laghe tara isaa o voto ghe lutula, nannaaira karika ghe masinala. Liuna avalua o me laghe aulia ngakapala voto ghe lutula ta vauira ateva. ");
INSERT INTO emi_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Me vauna ateva ghe mene koloala ia o tau ngai nongonongo anna ateva me ghe uela etana va, ‘Io sesa taumattu io. Aghe ghaa velu ekapala kalum dinao poli ughe ue va aghalousiusi teeio. ");
INSERT INTO emi_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Vaalua me karika ughe mene alousiusi teela mene lo ateva kapum amalu ghe uungu eitauaa nongina aghe gheleila etam?’ ");
INSERT INTO emi_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Vauna ateva ghe sessaiela me ghe auliaala me lo atoa la ghaaitoiaa ale mata voovoo ateva va laghe ghelei teeia voto mmarikana lomosina ta etani liu ekapa kanna dinao. ");
INSERT INTO emi_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Tamaghi epona liu egheelei evalua o etaimim, arova am tam kkaluaa kateva tueimim me nengaimim tale urunguitaniimim.” ");
INSERT INTO emi_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nau eteva Iesu ghe ruula tani auliaa isaa o voto, ghe kasu vulila eGalilii me ghe lao sio tale distriki eteva eJiudia ta pai kativilau eJodan. ");
INSERT INTO emi_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Oroiannaaili taumattu ghe usiusia me ghe ghelei emasinailala tale ia o voto ateva. ");
INSERT INTO emi_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Katoa Paresi laghe mae sio etana tani tootoongainia tale kateva nikokkolomi. Laghe uela etana va, “Uneita inangari nipaopao eue va masina arova taita ateva erooroo tani rati vausenna ateva tale aloaloannaane?” ");
INSERT INTO emi_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ghe liula me ghe uela va, “Karika am ghe ritila va tale aitiutiu tale voto akapaaili lo ateva ghe gheleila voto ‘ghe gheleila taita me vause’? ");
INSERT INTO emi_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Me God ghe uela va, ‘Liuna avalua o me taita ateva ekasukasu vuli tamane me kinna me ekaakateva nonga ilalua me vausenna ateva, me ilalua aue lalu kateva nonga tale vilikiirarua.’ ");
INSERT INTO emi_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Karika va emene ghaaghalue ilalua, ta ekaakateva nonga ilalua. Liuna avalua o me llo God eaatoka aitauaa, karika teva taumattu emene pola.” ");
INSERT INTO emi_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Me laghe kolomiela va, “Me vaalua me Moses ghe pitila va taita ateva erooroo tani taula uru ngai niairatii ta vausenna ateva, me esungi velua?” ");
INSERT INTO emi_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Iesu ghe liula me ghe uela va, “Moses ghe uela va am rooroo tani rati vauseniimim poli urunguitaniimim korokoronganaaili, me aitiutiu tale voto akapaaili karika isaa avalua o. ");
INSERT INTO emi_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Aghaauliaa kieimim va lo ateva erati vausenna ateva nau karika tale uunguaa niailai salosaloaa see, me emene ghaa mene teva vause, ange lai sarila.” ");
INSERT INTO emi_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Disaepolo atoa laghe uela etana va, “Arova ia avalua o, aue emasina arova taita ateva erau mene lai.” ");
INSERT INTO emi_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Iesu ghe liula me ghe uela va, “Karika va taumattu ngakapa aue eghaa isaa oia inangari, ta llo nonga atoa God ghe akorokoronganailala tani ghaa isaa oia inangari. ");
INSERT INTO emi_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Poli katoa, nau laghe lutula laghe lutu saasakiaala me karika la rooroo tani lai. Me katoa taumattu laghe kaatilala, me katoa la tam anna tani lai poli la ghanna tani ghelei uunguaane ararimangali ngepona liu eteva. Lo ateva erooroo tani ghaa isaa oia inangari aue eghaa.” ");
INSERT INTO emi_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Me laghe maeaa sio lutu ngaliki etoa ta Iesu va esaoaa nimane etaira me epure etaira. Disaepolo atoa laghe kisokiso lo atoa laghe maeainila sio. ");
INSERT INTO emi_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Me Iesu ghe uela va, “Am tau velu lutu ngaliki etoa, me la mae etaghi. Am rau mene ghelei rungainila poli ararimangali ngepona liu eteva kaluira ia lo atoa nongina ila o lutu ngaliki etoa.” ");
INSERT INTO emi_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ghe saoaala nimane etaira me ghe kasu vulila lo ateae o masaliki. ");
INSERT INTO emi_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Vara me kateva taita ghe mae sio ta Iesu me ghe kolomila Iesu va, “Tisa, saa arighi masi voto aue aghelei me aghaa maulue ateva tokatoka liu ia?” ");
INSERT INTO emi_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iesu ghe liula me ghe uela va, “Vaalua me ukokkolomi voto masina etaghi? Nim kateva nonga masina ia. Arova uanna tani ghaa maulue, unongo usilaa inangari nipaopao.” ");
INSERT INTO emi_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Me taita ateva ghe kolomila Iesu va, “Sa ateva inangari nipaopao?” Iesu ghe liula me ghe uela va, “Urau mene aiuvi emate, urau mene lai sari, urau mene ainao, urau mene kamekame tale niaisakei, ");
INSERT INTO emi_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","uoneoneaa tamam me kinam, me uaielousiaa taumattu ngateva kalakalangina ia etam nongina uaaielousieinio.” ");
INSERT INTO emi_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Me aliki taita ateva ghe uela va, “Isaa akapa voto ona ngaghe gheleila. Mene sa ateva voto karika aghe ghelei?” ");
INSERT INTO emi_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iesu ghe liula etana me ghe uela va, “Arova uanna tani ghulughuluenaaili, ulao me ulaa tau peim me la poli me ughaa viliki veu me utau lao ta lo atoa karika righi peiira, me aue utau peipeiena epona liu. Me umae usieghi.” ");
INSERT INTO emi_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nau eteva aliki taita ateva ghe nongo avaluela o, ghe alousiusila me ghe kasula, poli oroiannaaili peina. ");
INSERT INTO emi_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Me Iesu ghe uela ta kapuna disaepolo atoa va, “Aghaaulia ngakoronna etaimim va aanasaaili ta tue peipeiena atoa tani kupi sso tale ararimangali ngepona liu eteva. ");
INSERT INTO emi_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Me aghaauliaa etaimim va marova masukasukale ta teva kamolo tani kupi sso tale teae mata raum, aue emasukasukaleaili tee ta teva tue peipeiena tani kupi sso tale ararimangalina ateva God.” ");
INSERT INTO emi_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Disaepolo atoa laghe soghiaa saasakiaa teela isaa o inangari me laghe kolomila va, “Me see nonga erooroo tani saanga?” ");
INSERT INTO emi_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iesu ghe taatara lao sio etaira me ghe uela va, “Ta taumattu ngatoa, karika la rooroo tani ghelei isaa o voto, me ta God, erooroo tani ghelei isaa akapa voto.” ");
INSERT INTO emi_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita ghe liula me ghe uela va, “Ami ghe kasu vuli ekapala voto tani mae usio! Saa nonga ateva aue ami ghaaia?” ");
INSERT INTO emi_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Iesu ghe uela etaira va, “Aghaaulia ngakoronna etaimim va, nau voto emene aikolikoliaa nau Natuna ateva Taumattu ngateva etoka tale masi aitokatokane ateva king, lo atoa am aaimuli teeieghi aue am toka tale kasangaulu ghalua (12) aitokatoka uneira namu ngatoa. Me aue am ghelei niaisakei tale kasangaulu ghalua ararimangali nge Israel. ");
INSERT INTO emi_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Me lo atoa laghe kasu vulila tanganueira, o tueira me nengaira atoa o tamaira me kinaira me natuira atoa o umaira paa ngutana ta poli ararighi eteae, aue la ghaa ailiuliu tale isaa o voto elau kateva ai (100), me aue la ghaa tee maulue ateva tokatoka liu ia. ");
INSERT INTO emi_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Me oroi ila taumattu ngatoa matuutuliena ila aue la sioaili euu, me see ila lo atoa arariira euu aue la matuutuliena.” ");
INSERT INTO emi_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Iesu ghe mene kiukiu tee lao sio va, “Aghaaulia ngavalua o poli ararimangali ngepona liu eteva nongina kateva tau kosa. Elue talaua poopooa, ghe lao sio tani kolo tau ngai uungu etoa va la uungu tale umana utani uaeni. ");
INSERT INTO emi_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ila oia tau ngai uungu etoa laghe masimasila tani ghaa kateva kateva silva koen tale lo ateva o nau, me namu ngateva ghe sungilala tani laa uungu tale umana utani uaeni etingiu. ");
INSERT INTO emi_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Elue talaua ta 9 kilok, namu ngateva ghe lao sio, me ghe tarala taumattu ngatoa laghe aaitokaa see nongina laghe veluvelu eitauaa. ");
INSERT INTO emi_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Me eghe uela etaira va, ‘Am tee am rooroo tani laa uungu tale utani uaeni etingiu, me aue apoliem tale sa ateva ghulughuluena ia.’ ");
INSERT INTO emi_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Me laghe kasula. “Elo sinaka ta 12 kilok, me mene elo alai ta 3 kilok, namu ngateva ghe mene lao sio tani mene gheleila llo eghe ghelei. ");
INSERT INTO emi_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Elo alai ta 5 kilok, ghe lao sio me ghe tarala kasina taumattu ghe aaitokaa see, me ghe kolomilala va, ‘Vaalua me ia oia nau eteva am nim tokala etana?’ ");
INSERT INTO emi_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Me laghe uela va, ‘Karika teva taumattu etau mae sio righi niuungu etaimami.’ “Ghe uela etaira va, ‘Am tee am laa uungu tale utani uaeni etingiu.’ ");
INSERT INTO emi_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Elo alai ta 6 kilok me tau kosa ateva ghe auliaala ta kapuna tau ngai toitoi eteva va, ‘Kolola tau ngai uungu etoa me utau lao aipoliira. Utau lao aipoliira kateva kateva, utiuaa ta lo atoa laghe airuuruula tani mae uungu, me elaa ruu ta lo atoa laghe aitiutiula tani mae uungu.’ ");
INSERT INTO emi_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Lo atoa taumattu laghe tiuaala ta 5 kilok elo alai laghe mae sio me laghe ghaala kateva kateva silva koen. ");
INSERT INTO emi_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Me nau eteva lo atoa laghe tiuaa ngakasinala laghe mae sio, laghe nnaala va laghe ghaa oroi viliki veu, me karika, ila tee laghe ghaala kateva kateva silva koen. ");
INSERT INTO emi_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Laghe tarala viliki veu laghe ghaala me ghe sessailala ta tau kosa ateva, me laghe tiuaala tani auliulieinia, laghe ue va, ");
INSERT INTO emi_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Ta lo atoa la airuuruula tani uungu, la uungula nonga kateva aoa, me upolilala nongina upoliemamila. Ami gheleila kinatama niuungu eteva, ta ami tiuaala arau elue talaua poopooa me sinaka ateva ange sinaki emateamamila.’ ");
INSERT INTO emi_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Tau kosa ateva ghe nongola inangariira me eghe liu evaluela toko ta kateva kapuna tau ngai uungu va, ‘Kapughu, karika agheleila teva voto sesa etam. Karika ughe asokoi teeieghila va aue ughaa kateva silva koen? ");
INSERT INTO emi_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ghaala aipolim me ukasu. Aghi aghe auliaala va la poli evalueiem o lo atoa laghe airuuruula tani uungu, tale aloannaaghi. ");
INSERT INTO emi_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Koti karika erooroo va aghaimuli tee aloannaaghi tani aikoita uneghi viliki veu, va? Arova aghanna tani ghelei masi niuungu tale taumattu ateva oia, vaalua me esessaio?’” ");
INSERT INTO emi_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Iesu ghe uela ta kapuna disaepolo atoa va, “Isaa avalua o me oroi ila taumattu ngatoa matuutuliena ila aue la sioaili euu, me see ila lo atoa arariira euu aue la matuutuliena.” ");
INSERT INTO emi_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iesu ghe kasula me ghe laa saesae eJerusalem. Me nau eteva laghe laa saesae, Iesu ghe kolo apalluula nonga kapuna kasangaulu ghalua (12) disaepolo, me ghe auliaala etaira va, ");
INSERT INTO emi_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Am nongo, ita laa saesae eJerusalem, me aue la tau lao Natuna ateva Taumattu ngateva ta nimaira namu ngatoa tale pristi etoa me tau ngai aapasunga tale inangari nipaopao atoa, me aue la ghelei niaisakei etana, me la tingina aitauaa tani uvi ematea. ");
INSERT INTO emi_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Aue la taue lao ta taumattu ngeleka atoa, me aue la kusiaa teeia, la uetaia, me la avukalaia tale aikotoo. Emuli tale kotolu nau, aue etotu.” ");
INSERT INTO emi_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Emulina, kinairarua ateva natuna alua Sebedi me natuna alua lotolu ghe mae sio ta Iesu. Me kinairarua ghe suuiaala me ghe uela va ealoanna kateva voto ta Iesu. ");
INSERT INTO emi_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Me Iesu ghe uela va, “Sa ateva uaaloannaia?” Me vause ateva oia ghe uela va, “Aghaloanna va uue va ilalua oia natughu elua, lalu toka kalakalangina tale ararimangalim eteva, kateva tale pai muenna ativilau, me kateva tale pai uaise ativilau.” ");
INSERT INTO emi_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Iesu ghe nongola isaa oia inangari me ghe liula tani ue va, “Karika amalu kilakila amasina llo amalu kookolomi. Amalu rooroo tani ropi tale ia o kapa ateva nimmarikana etana aue aropi etana?” Me lalu ghe uela va, “Ue, angalu rooroo.” ");
INSERT INTO emi_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Iesu ghe uela etairarua va, “Koronna, aue amalu ropi tale uneghi kapa ateva, me tani toka tale pai muenna o uaise ativilau, aghi karika uunguaaghi tani tau aatu. Isaa o voto uneira isaa o taumattu Tamaghi ang ghe aimonomonosiaa tau lao sio.” ");
INSERT INTO emi_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nau eteva kasangaulu (10) disaepolo laghe nongola isaa o inangari tue me nenga alua lalu ghe kolomila Iesu, eghe sessailala. ");
INSERT INTO emi_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Iesu ghe kolo aitaueinilala me ghe uela etaira va, “Am kilakila, isaa o tau ngai toitoi tale tau ngeleka atoa, la gheelei taumattu enim uungu aanasa etaira. Me lo atoa matuutuliena ila, la gheelei saasakiaa ta taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Isaa o ase gheeleiaaira erau mene toka elome etaimim, karika. Lo ateva taumattu eaaloanna tani namuu elome etaimim, esio euu me eghelei nongina tau ngai nongonongo anna atoa. ");
INSERT INTO emi_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Me lo ateva taumattu ealoanna tani muemueinam, etani kapuimim tau ngai uungu. ");
INSERT INTO emi_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nongina Natuna ateva Taumattu ngateva ghe tam sio mae va la uungu etana, karika, ta ghe sio mae tani uungu etaira me tani taula maamauluaane tani ghaa oghi oroi taita me vause.” ");
INSERT INTO emi_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iesu me kapuna disaepolo atoa laghe kasu vulila masaliki taatara ateae eJeriko, me oroieili taumattu ghe mene usiela. ");
INSERT INTO emi_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Me ghalua taumattu lalu ghe tokatoka tale sama salana atikirighi, mata salusalu ilalua. Me nau eteva lalu ghe nongola va Iesu ekasukasu emaemae, me namuu ta lalu ghe kolokoloa va, “Vau eteva, io Natuna io Deivit, ualousiusi teeiengalua!” ");
INSERT INTO emi_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nau eteva taumattu ngatoa laghe nongolaluela lalu ghe kolokolo, taumattu ngatoa laghe paopao rungainilalua va, “Amalu rau mene sama.” Me ilalu ghe kolokolo anamuu va, “Vau eteva, Natuna ateva Deivit, ualousiusi teeiengalua!” ");
INSERT INTO emi_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iesu ghe tinginala, ghe kololaluela me ghe uela va, “Saa llo amalu aloanna va aghelei etaimalua?” ");
INSERT INTO emi_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Lalu ghe uela etana va, “Vau eteva, angalu aloanna va uoti matangalua.” ");
INSERT INTO emi_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iesu ghe alousiusi teeilaluela, ghe posola matairarua, me arovaeaata matairarua ghe taatarala, me lalu ghe usiela. ");
INSERT INTO emi_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nau eteva ngila ghe aakalakalaa eJerusalem me ngila ghe rekatala tale masaliki eteva eBetpeis tale motouru eteva eOliv, me Iesu ghe suula ghalua tani kapuna disaepolo. ");
INSERT INTO emi_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ghe uela etairarua va, “Amalu muemuela me amalu lao tale masaliki eteae ngeita taraie lao sio me arovaea ta aue amalu tara donki eteva me natuna ateva la iiri etinginailaluela. Amalu pulakailalua, me amalu maeainalua etaghi. ");
INSERT INTO emi_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Arova teva ekolomiemalua, amalu ue etana va, ‘Vau eteva eanna tani ghelei uunguaane etairarua me aue arovaeaa nonga ta etau velulalua.’” ");
INSERT INTO emi_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Isaa o voto ghe lutula tani ghelei inangarina propete ateva ghe kaurekatila, ");
INSERT INTO emi_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ghe uela va: “Auliaala ta masaliki taatara ateae eSaeon, ‘Am tara kapuimim kingi eteva emaemae etaimim, esiosioaili euu me eiilou tale donki, lo ateva donki aliki taita ia.’” ");
INSERT INTO emi_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Disaepolo alua lalu ghe kasula tani ghelei voto Iesu ghe auliaala etairarua. ");
INSERT INTO emi_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Lalu ghe maeaa sio donki eteva kinna ia me natuna ateva, me lalu ghe alokoi saela uneirarua aiaasae ngeleka etairarua, me Iesu ghe laa sae toka etairarua. ");
INSERT INTO emi_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Oroiannaaili taumattu laghe lullu velu uneira aiaasae ngeleka me laghe pulepule alokoi tapaa salana, me katoa laghe saisai laa ngai me laghe aalokoi sio tapaa salana. ");
INSERT INTO emi_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Lo atoa taumattu laghe muemueainia me lo atoa laghe aimuli etana laghe ovaova tani ue va, “Tau sae ararina ateae Natuna ateva Deivit!” “Niarangise aue etoka ta lo ateva emaemae tale ararina ateae Vau eteva!” “Tau sae ararina ateae God iaaili epona!” ");
INSERT INTO emi_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nau eteva Iesu ghe kupi ssola eJerusalem, taumattu ngakapa eJerusalem ghe soghieiniela, me laghe aikolomieinila va, “See okae?” ");
INSERT INTO emi_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Me lo atoa laghe kasukasu teeia laghe ue va, “Iesu oke, propete ia me aNasareti ia eGalilii.” ");
INSERT INTO emi_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesu ghe kupi ssola nongina ale ngeleka atiulu tale ale manga ateva me ghe sungi vella lo atoa laghe aaitauaa me laghe poppoli. Ghe sau etakila uneira tevoo atoa lo atoa laghe aikolikoliaa viliki veu me uneira aitokatoka lo atoa laghe aaitauaa ghila valusu va la poli. ");
INSERT INTO emi_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ghe uela etaira va, “Laghe pitila tale Uru ngai Manga ateva va, ‘Aleghi ale manga ateva la ghaseasea va ale ailooloo sae ia.’ Me am ngam eleiela arova ‘aleira ale niaisulia ia tau niainao atoa.’” ");
INSERT INTO emi_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mata salusalu etoa me tangorengorena atoa laghe mae sio tani taraia tale ale ngeleka atiulu tale ale manga ateva, me ghe ghelei emasinalala. ");
INSERT INTO emi_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Namuu ta pristi etoa me tau ngai aapasunga atoa tale inangari nipaopao laghe tarala masi voto ghe ghelei me vaalua aliki etoa laghe aore tale ale ngeleka atiulu tale ale manga ateva tani ue va, “Tau sae ararina ateae Natuna ateva Deivit,” me ghe sessai etinginailala. ");
INSERT INTO emi_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Me laghe kolomila Iesu va, “Unongonongo llo aliki etoa la ghauliaa?” Iesu ghe liula me ghe uela va, “Ue. Me koti karika am ghe ritila inangari laghe piti elokoila laghe uela va, “‘Ughe aimonomonosiaala lutu ngaliki etoa va aue la tau sae ararim ateae.’” ");
INSERT INTO emi_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ghe kasu vulilala me ghe kupi ghoala tale masaliki taatara ateae me ia o voo ngateva ghe tokala tale masaliki eteva eBetani. ");
INSERT INTO emi_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Elue talaua poopooa ghe mene laa sosso tale masaliki taatara ateae me ang ghe maamaloo. ");
INSERT INTO emi_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Me ghe tarala fig ateae ghe tiitingina tale sama salana atikirighi me ghe lao akalakalangina sio etana me karika righi uenena, nim uruena ia, me ghe uela ta fig ateae va, “Karika aue umene kuneaa righi uem.” Me arovaeaa ta fig ateae ghe mmatela. ");
INSERT INTO emi_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nau eteva disaepolo atoa laghe tarala isaa o voto laghe soghiaala me laghe kokkolomi va, “Vaalua me arovaeaa nonga ta emmatela?” ");
INSERT INTO emi_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iesu ghe liula me ghe uela etaira va, “Aghaaulia ngakoronna etaimim va arova am aikaaiaa me karika nannaaimim eghaaghalua, karika aue am ghele ghelei nonga voto nongina llo elutula tale fig ateae, ta am rooroo tani ue ta ia o motouru eteva va ekasu me eghoa katuu elamana me aue ghele ghelei. ");
INSERT INTO emi_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Arova am aiesoaa, aue am ghaa saa ase voto aue am kokkolomi tale nilooloo sae.” ");
INSERT INTO emi_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesu ghe kupi ssola tale ale ngeleka atiulu tale ale manga ateva, me nau ghe tiuaala tani apasunga, namu ngatoa ta pristi etoa me lo atoa laghe naanamuu ta taumattu ngatoa laghe mae sio etana, me laghe kolomiela va, “See ghe tau aatu sio matuutuliena etam, me see ghe sungiola tani mae ghelei isaa oia voto?” ");
INSERT INTO emi_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iesu ghe liula me ghe uela etaira va, “Akolomiem mua tale kateva nikokkolomi, me arova am liu ia o nikokkolomi eteva, aue aghauliaa va see ghe tau mae sio matuutuliena etaghi. ");
INSERT INTO emi_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ia Jon ghe asuu taumattu, see ghe tau lao sio matuutuliena etana, taumattu ngatoa, o God?” Me laghe tiuaala tani aissakea elome etaira. Laghe ue va, “Arova ita ue va, ‘God,’ aue eue teeita va, ‘Me vaalua me karika am ghe aaiesoaa etana?’ ");
INSERT INTO emi_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Me arova ita ue va, ‘Ta nim taumattu,’ ita maamatauta taumattu ngatoa poli ila akapa la ue va Jon propete ia.” ");
INSERT INTO emi_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Liuna avalua o laghe liula me laghe uela ta Iesu va, “Karika ami kilakila.” Me Iesu ghe uela etaira va, “Aghi tee, karika aue aghauliaa etaimim va see ghe tau mae sio matuutuliena etaghi. ");
INSERT INTO emi_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Vaalua am annaa tale kiukiu eteae toko? Kateva taumattu natuna taita alua ghe lao sio ta mua ateva, me ghe uela va, ‘Natughu, laa uungu tale utani uaeni.’ ");
INSERT INTO emi_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Me mua ateva ghe uela etana va, ‘Karika aue alao,’ vara me ghe nnaa aioghioghiaala me ghe lao sio. ");
INSERT INTO emi_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Me tamairarua ghe mene auliaala isaa o inangari ta mene aiaaghaluena ateva aliki. Ia o lo ateva aliki ghe liula me ghe uela va, ‘Ue, namu ngateva, aue alao,’ me karika ghe lao sio. ");
INSERT INTO emi_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“See ta ngetairarua ghe gheleila llo tamairarua ghe aloanna?” Laghe liula me laghe uela va, “Aitiutiu eteva.” Me Iesu ghe uela etaira va, “Aghaaulia ngakoronna etaimim va aighaa takis atoa, me vause ngetapaa salana atoa ngeila muemueinam sso tale ararimangalina ateva God. ");
INSERT INTO emi_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Poli Jon ghe mae sio etaimim tani apasunga salana ghulughuluena, me karika am ghe aiesoaa llo ghe auliaala, nim aighaa takis nonga atoa me vause ngetapaa salana atoa laghe aiesoaa. Me am ghe taatara poi voto me karika am ghe nanna ngaioghioghiaa me am ghe aiesoaa etana. ");
INSERT INTO emi_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Am mene nongo kateae kiukiu niaimatoonga. Kateva taumattu ghe pasala utani uaeni etingiu tale kosane ateva, me ghe iri taliaala valavala ateae me ghe kaila aiposoaa uaeni eteva, me ghe atulula aitiketike ateva, me ghe taue lao sio ta katoa tau ngeutana tani aitarainia, me ghe kasu emasaula. ");
INSERT INTO emi_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nau utana atingiu ghe massola, ghe suula kapuna tau ngai nongonongo anna atoa tani laa ghaa righi uenenna utani uaeni etingiu. ");
INSERT INTO emi_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Lo atoa laghe aitaraa utana atingiu laghe kune atokailala: laghe paru emaamatela kateva, me laghe uvi ematela kateva, me aiaakotonna ateva laghe osaiela. ");
INSERT INTO emi_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Me ghe mene suu tau lao sio mene katoa tani kapuna tau ngai nongonongo anna etaira, oroiaaira elaulau lo atoa laghe lao akasina sio. Tau ngai toi utana atingiu laghe ghelei teeilala voto nongina lo atoa laghe muemueainilala. ");
INSERT INTO emi_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Airuuruu ghe suula natuna ateva tani lao etaira, poli ghe ue va, ‘Aue la oneoneaa natughu eteva.’ ");
INSERT INTO emi_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Me nau tau ngai toi utana atingiu laghe tarala natuna ateva, laghe sama aitauaala elome etaira va, ‘Lo ateva aue eghaa utana atingiu okae. Ita laa uvi ematea me ita ghaa voto aue peina.’ ");
INSERT INTO emi_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mausina avalua o me laghe ghaaiela me laghe sau velue ghoala eleka tale utani uaeni etingiu me laghe uvi emateala. ");
INSERT INTO emi_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Liuna avalua o me lo ateva umana ia utani uaeni etingiu nau erekata, sa ateva aue egheleia ta lo atoa laghe aaitarainia?” ");
INSERT INTO emi_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Laghe liula me laghe uela va, “Aue eghelei voto sesaaili tale ila o sesa taumattu ngatoa, me aue emene taula utani uaeni etingiu ta mene katoa ppae lo atoa aue la taula uaeni etana nau la pariki.” ");
INSERT INTO emi_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iesu ghe uela etaira va, “Koti am ghe ritila tale Uru ngai Manga ateva, eue va, “‘Atu eteva tau ngai atulu ale atoa laghe ratiela ghe aitiutiula tale atu ekapa atoa tani suei ale ateva. Vau eteva ghe gheleila isaa o voto, me taataraane masinaaili ta mataita.’ ");
INSERT INTO emi_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Liuna avalua o me aghaauliaa etaimim va ararimangali eteva epona liu aue God eghaa velua etaimim me emene tauela ta lo atoa taumattu aue la nongo usilainia. ");
INSERT INTO emi_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Lo ateva aue ekatuu saoaa tale ia o atu eteva aue etakotokoto, me arova atu eteva ekatuu saoaa etana aue etaputuputu.” ");
INSERT INTO emi_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nau eteva namu ngatoa ta pristi etoa me Paresi etoa laghe nongola ta Iesu ghe auliaala ia o kiukiu niaimatoongana ateae, laghe kilala va ghe aauliaa teeila. ");
INSERT INTO emi_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Laghe paepae tikirighi salana tani kuneia, me laghe maamatauta taumattu ngatoa poli ila laghe ue va Iesu propete ia. ");
INSERT INTO emi_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesu ghe mene poppooaa etaira tale kiukiu niaimatoonga, ghe ue va, ");
INSERT INTO emi_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ararimangali ngepona liu eteva nonginaaili kingi eteva ghe aimonomonosiaala ninamanama ateae tale nilai eteae ta natuna. ");
INSERT INTO emi_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ghe suula kapuna tau ngai nongonongo anna atoa tani laa ghauliaa ta kolokolona atoa tale ia o ninamanama ateae va la mae, me karika laghe annala tani mae. ");
INSERT INTO emi_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Me ghe mene suula katoa tani kapuna tau ngai nongonongo anna. Ghe uela etaira va, ‘Am laa ue ta kolokolona atoa va: Ngaghaimonomonosiaala inana. Kieghi vulumakao atoa taita ila, me morona atoa natu vulumakao ngila uvila me pasila me isaa akapa voto ange aimonomonosiaala. La mae tale ninamanama ateae tale nilai eteae.’ ");
INSERT INTO emi_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Me karika laghe anna tani nongo me laghe aitiuaala. Kateva ghe lao sio ta ngumane, me kateva ghe lao sio tani ghelei voto aue eghaa viliki veu etana. ");
INSERT INTO emi_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Me mene katoa laghe poso atokala kapuna tau ngai nongonongo anna atoa king me laghe ghelei teeilala voto karika masina, me laghe uvi ematelala. ");
INSERT INTO emi_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","King ghe sessaiela, me ghe suula kapuna tau ngai uvii etoa laghe lao sio tani tturu tau ngai uvii emate atoa, me laghe suluila masaliki taataraira ateae. ");
INSERT INTO emi_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Me ghe uela ta kapuna tau ngai nongonongo anna atoa va, ‘Ninamanama ateae tale nilai eteae ange aimonomonosiaala, me lo atoa aghe uela va la mae karika masina ila tani mae. ");
INSERT INTO emi_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Am lao sio tapaa salana me am kolo sa ateva taumattu am rooroo tani tara.’ ");
INSERT INTO emi_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Liuna avalua o me tau ngai nongonongo anna atoa laghe lao sio tapaa salana me laghe kolola saa taumattu laghe roola tani tara, sesa me masina, me ale ngai namanama atiulu ghe pasula tale taumattu. ");
INSERT INTO emi_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Me vara kingi eteva ghe kupi ssola tani tara taumattu ghe mae sio me ghe tarala kateva taumattu, karika ghe aasae koloso nilai eteae. ");
INSERT INTO emi_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Me ghe kolomiela va, ‘Kapughu, vaalua ukupi sso mae nau karika uaasae teva koloso nilai?’ Me taumattu ngateva karika ghe samala. ");
INSERT INTO emi_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Me king ghe auliaala ta tau ngai uungu etoa va, ‘Am irila kkena me nimane, me am sau velue ghoa eleka tale aavoona me eghoa toka ngangngala me aingeresia ngalungaluna.’ ");
INSERT INTO emi_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Poli oroi la kolokolo me malaki llo la suisuitoonga.” ");
INSERT INTO emi_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Vara me Paresi etoa laghe kasula tani laa ghaimonomonosiaa salana vaalua tani ghaa Iesu tale inangarina. ");
INSERT INTO emi_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Laghe suula kapuira disaepolo atoa, me kapuna tee atoa Herot tani lao etana. Laghe uela etana va, “Tisa, io nau ekapa atoa uaauliaa nonga voto koronna me voto uaapasunga tale salane God, koronna ia, karika unannangaili saa llo taumattu ngatoa la annaa, me karika utaatara taumattu tale naanamungaane me uunguaane. ");
INSERT INTO emi_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Auliaala etaimami io vaalua nannaam. Vaalua? Masina tani tau lao takis ta Siisa?” ");
INSERT INTO emi_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Iesu ghe kilakila voto laghe ailoeaala karika masina, me ghe uela etaira va, “Am usimaghalua am, vaalua me am aloanna tani tootoongainaghi? ");
INSERT INTO emi_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Am apasungaala viliki veu etivilau etaghi am tautau ta Siisa.” Me laghe maeaa sio viliki veu etivilau ta ngetana. ");
INSERT INTO emi_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Me ghe kolomilala va, “See tootoona ateva me ararina ateae o?” ");
INSERT INTO emi_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Laghe liula me laghe uela va, “Siisa.” Me ghe uela etaira va, “Am taula llo voto kanna Siisa ta Siisa, me voto kanna God ta God.” ");
INSERT INTO emi_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Laghe soghiaala isaa o inangari laghe nongola, liuna avalua o me laghe kasu vuliela. ");
INSERT INTO emi_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tale ie nonga o nau eteva, Sadiusi etoa, karika la ghaaiesoaa tale nitotu tale nimate, laghe mae sio tee uneira nikokkolomi eteva. ");
INSERT INTO emi_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Laghe uela va, “Tisa, Moses ghe pitila etaimami va, arova taita ateva lailai ia emate me karika righi natuna, nengane aue eghaa vause ateva eraue vuluela, tani alutu natuna tuena. ");
INSERT INTO emi_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ghaitu (7) tue me nenga laghe tokatoka teeiemami. Aitiutiu eteva ghe laila, me ghe matela. Me, poli karika righi natuna, nengane ghe mene ghaala vausenna ateva. ");
INSERT INTO emi_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ase voto ateva o ghe mene lutula ta aiaaghaluene ateva taita me kotonna ateva, me ghe laa sio ruu tale aiaaghaituna ateva. ");
INSERT INTO emi_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Airuuruu me vause ateva ghe matela. ");
INSERT INTO emi_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nau nitotu tale nimate, see aue evausenna ia ta ila o tue me nenga ghaitu, poli ila akapa laghe laila etana?” ");
INSERT INTO emi_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iesu ghe liula me ghe uela etaira va, “Nannaaimim karika ghulughuluena, poli karika am kilakila Uru ngai Manga ateva me sarasarakaniaane God. ");
INSERT INTO emi_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nau nitotu tale nimate, taumattu karika aue elai; aue la nongina ensolo atoa epona liu. ");
INSERT INTO emi_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Me tale tottotuaaira lo atoa matena ila, karika am ghe ritila voto llo God ghe auliaala etaimim? ");
INSERT INTO emi_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Aghi kapuira Goto ieghi Abraham, Aisiki me Jekop.’ Karika va kapuira Goto ia matena atoa ta kapuira Goto ia lo atoa maulue ila.” ");
INSERT INTO emi_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nau taumattu ngatoa laghe nongola laghe soghiaala llo ghe aapasunga. ");
INSERT INTO emi_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Paresi etoa laghe velu eitauaala nau laghe nongola va inangarina Iesu ghe ghelei epaavoola Sadiusi etoa. ");
INSERT INTO emi_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kateva etaira, muennaaili ia tale inangari nipaopao, ghe toongiela tale ie toko nikokkolomi eteva. ");
INSERT INTO emi_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ghe uela va, “Tisa, sa ateva inangari tale isaa o inangari nipaopao namuu?” ");
INSERT INTO emi_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Iesu ghe liula me ghe uela va, “‘Uaielousiaa Vaum ateva kapum Goto ia tale urunguitanim me tale maamauluaam me tale nannaam.’ ");
INSERT INTO emi_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aitiutiu eteva o, me namuu ia tale isaa akapa inangari nipaopao. ");
INSERT INTO emi_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Me aiaaghaluene ateva, nongina aitiutiu eteva, ‘Uaielousiaa taumattu ngateva kalakalangina ia etam, nongina uaaielousieinio.’ ");
INSERT INTO emi_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Isaa akapa inangari nipaopao me lo inangari propete atoa laghe auliaala, etani laolao aitauaa tee ilalua o inangari nipaopao alua.” ");
INSERT INTO emi_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tale ie nonga o nau eteva Paresi etoa laghe velu eitauaala me Iesu ghe kolomilala va, ");
INSERT INTO emi_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Vaalua am annaa ta Mesaea ngateva? See tuvuna ia?” Laghe liula me laghe uela va, “Tuvuna ia Deivit.” ");
INSERT INTO emi_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Me ghe uela etaira va, “Me vaalua me Deivit, Spiriti eteva ghe tokala etana, me ghe kolola ia o taumattu ngateva va Vau ia? Ghe uela va, ");
INSERT INTO emi_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Vau ngepona ateva ghe uela ta kapughu vau eteva va, “Toka siola tale pai muenna ativilau, lomose ta aghatoka sio lo atoa la sessa teeio euu, me uatingina saoaa kkem etaira.”’ ");
INSERT INTO emi_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Arova Deivit ghe kolokoloa va ‘Kapuna vau eteva,’ vaalua me ghe mene nim tuvuna ia?” ");
INSERT INTO emi_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Karika teva ghe liula tani mene auliaa righi inangari. Ghe tiuaala o, karika teva ghe mene anna tani kolomia tale mene righi nikokkolomi. ");
INSERT INTO emi_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Vara me Iesu ghe uela ta taumattu ngatoa me kapuna disaepolo atoa va, ");
INSERT INTO emi_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Tau ngai aapasunga ngatoa tale inangari nipaopao me Paresi etoa la tokatoka tale unna aitokatoka ateva Moses. ");
INSERT INTO emi_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Liuna avalua o me am nongo usilaa me am ghelei ekapa voto la aauliaa etaimim, me am rau mene aimuli tee gheeleiaaira, poli voto la ghaauliaa karika la gheelei. ");
INSERT INTO emi_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Inangariira aanasaaili tale taumattu ngatoa tani aimuli tee, nongina la aatoka sae voto maamatana karika kaakaai me iriiri emasina, ta pappaira taumattu ngatoa, me karika la aaloanna tani sausi tani sau. ");
INSERT INTO emi_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Isaa akapaaili voto la gheelei va taumattu ngatoa la taraila. La gheelei enamuu uneira lutu ngaikaai me la pitipiti inangarina ateva God me la kaakaai sio etana, me kalio atiulu la aakou uruira etana, euu tale aighoughou ghaata, la aavukala voto ghaata la kolokolo va tassel, tani apasunga va ila tau ngai kkauaa ila. ");
INSERT INTO emi_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","La ghaaloannaaili va taumattu ngatoa la oneoneainila, me la ghaaloannaaili tani toka tale uneira aitokatoka namu ngatoa elome tale ale nivelu eitauaa, me nongina namu ngatoa la namanama. ");
INSERT INTO emi_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","La aloanna va taumattu ngatoa la soula tale masi inangari nongina oroi taumattu etokatoka me la asela va Rabae. ");
INSERT INTO emi_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Me la rau mene aseam va Rabae, poli kateva nonga vauimim ateva, me am tue me nenga am. ");
INSERT INTO emi_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Me am rau mene ase teva taumattu tale kosa ateva oia va tamaimi ia, poli kateva nonga Tamaim ateva ia epona liu. ");
INSERT INTO emi_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Me la rau mene aseam va tau ngai aapasunga iem, poli kateva nonga tau ngai aapasunga ngateva, ia Mesaea ia. ");
INSERT INTO emi_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Me lo ateva namuu ia elome etaimim, ia kapuimim tau ngai nongonongo anna ia. ");
INSERT INTO emi_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Lo ateva taumattu eaaloanna tani saeaa ararina ateae, ararina ateae aue esio euu, me lo ateva taumattu esioaa nannaane euu, aue ararina ateae esae epona. ");
INSERT INTO emi_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Aue esesaaili etaimim, tau ngai aapasunga ngatoa tale inangari nipaopao me Paresi etoa, am usimaghalua am! Karika am roo tani tau velu katoa taumattu tani sso tale ararimangali ngepona liu eteva me am, karika am kupikupi sso. ");
INSERT INTO emi_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Aue esesaaili etaimim, tau ngai aapasunga ngatoa tale inangari nipaopao me Paresi etoa, am usimaghalua am! Am kasukasu ekapa see elae me elamana tani ghelei kateva taumattu eJiu, me nau angam ghaaiela, am gheeleia va etau ngai uungu ta raroai eteva, me sesa uunguaane elaulau uunguaaimim. ");
INSERT INTO emi_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Aue esesaaili etaimim, tau ngai katula ngatoa mata salusalu iem! Am ue va, ‘Arova teva eauliaa inangarina tani ue va, “Koronnaaili tale ale manga ateva,” isaa o inangari karika righi malloeanina, me arova teva eauliaa inangarina tani ue va, “Koronnaaili tale golo tale ale manga ateva,” etani ghelei nongina eaauliaa.’ ");
INSERT INTO emi_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Am mata salusalu iem me alokapakapa am! Sa ateva namuu ia: golo, o ale manga ateva, eaamanga golo? ");
INSERT INTO emi_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Me am ue tee va, ‘Arova teva eauliaa inangarina tani ue va, “Koronnaaili tale liu nighelei aiaavusuvusuena,” isaa o inangari karika righi malloeanina, me marova teva eauliaa inangarina tani ue va, “Koronnaaili tale isaa o voto epona tale liu nighelei aiaavusuvusuena,” etani ghelei nongina eaauliaa.’ ");
INSERT INTO emi_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Am mata salusaluna am! Sa ateva namuu ia: voto epona la maemaeaa tani ghelei aiaavusuvusuena, o liu nighelei aiaavusuvusuena ateva eaamanga voto o? ");
INSERT INTO emi_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Liuna avalua o me lo ateva eauliaa inangari tani ue va, ‘Koronnaaili tale liu nighelei aiaavusuvusuena ateva,’ eaaulia ngakoronna tale liu nighelei aiaavusuvusuena me voto akapa etokatoka epona etana. ");
INSERT INTO emi_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Me lo ateva eauliaa inangari tani ue va, ‘Koronnaaili tale ale manga ateva,’ eaaulia ngakoronna ta ale manga ateva me ta God, poli God etokatoka tale ale manga ateva. ");
INSERT INTO emi_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Me lo ateva eue va, ‘Koronnaaili epona liu,’ eaaulia ngakoronna tale unna aitokatoka ateva God me lo ateva etokatoka etana. ");
INSERT INTO emi_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Aue esesaaili etaimim, tau ngai aapasunga ngatoa tale inangari nipaopao me Paresi etoa, am usimaghalua am! Am tani gheelei emasinaaili aiaasokolo tale uneimim lutu voto ghaunaaili am ghaaghaa eutana, me karika am uusilaa maamasinaane inangari nipaopao nongina voto ghulughuluena me nialousiusi me uunguaa niaikaaiaa. Isaa o voto am roo tani ghelei me karika am mene kkaluaa isaa o voto ghaunaaili. ");
INSERT INTO emi_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Alousiusi etaimim, tau ngai katula ngatoa mata salusalu iem! Me am nongina taumattu ngateva ghe anna tani ghaa velu looloo arighi tale ropina manu, me ghe tam taatara kamolo ateva tale ropina manu, me ghe ropi teeiela. ");
INSERT INTO emi_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Aue esesaaili etaimim, tau ngai aapasunga ngatoa tale inangari nipaopao me Paresi etoa, usimaghalua am! Am gheelei eraarangisana eleka tale kapa ateva me pelete ativilau, me elome pasu ia tale nikuruetu me nitam nanna ngamasina. ");
INSERT INTO emi_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Paresi etoa am mata salusalu iem! Am ghelei eraarangisana akasina elome tale kapa ateva me pelete ativilau, me auena eleka emene raarangisana tee. ");
INSERT INTO emi_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Aue esesaaili etaimim, tau ngai aapasunga ngatoa tale inangari nipaopao me Paresi etoa, am usimaghalua am! Am nonginaaili liu niaikkaia ngateva la porapora araarangisanaailiila eleka me taataraane masinaaili ia, me elome, pasueili ia tale riu taumattu matena me voto atoa karika raarangisana ila. ");
INSERT INTO emi_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tale ia o salana atikirighi, eleka etaimim am aapasunga ta taumattu ngatoa va ghulughuluena am, me karika poi, ta elome etaimim pasueili ia tale usimaghalua me sesa voto. ");
INSERT INTO emi_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Aue esesaaili etaimim, tau ngai aapasunga ngatoa tale inangari nipaopao me Paresi etoa, am usimaghalua am! Am, am atuutulu liu niaikkaiaa uneira propete atoa me am aamolumolu atu niaimatoonga uneira ghulughuluena atoa, ");
INSERT INTO emi_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","me am ue va, ‘Marova ita ghe tokatoka emua arau nau ta tuvuita atoa, karika aue ita ghe usi tani uvi emate propete atoa.’ ");
INSERT INTO emi_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Am aaulia ngakoronna va tuvuim atoa laghe uvi ematela propete atoa, me am tee am uusilaa uunguaaira tuvuim atoa. ");
INSERT INTO emi_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Gheleila am me am laa ruu emasina sa ateva tuvuim atoa laghe tiueiniela! ");
INSERT INTO emi_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Otuena am me natuira am otuena atoa! Vaalua aue am kasu vuli sessaiaane God tale nau niaisakei eteae? ");
INSERT INTO emi_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Liuna avalua o me aue asuu propete atoa, me tau ngalomasaanga, me tau ngai aapasunga ngatoa. Katoa etaira aue am uvi ematela me am avukalaila sae tale aikotoo, me katoa aue am uetaila tale aleimim ale nivelu eitauaa, me katoa aue am laa paela see tale masaliki taatara atoa. ");
INSERT INTO emi_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Liuna avalua o me aue am ghaa sesa ngaipolipoli tale taumattu ghulughuluena tale kosa ateva am ghe uvi ematela. Etiitiuaa ta ghulughuluena ateva taumattu Eibol me eruuruu ta Sekaraea natuna ia Barakaea, ia o am ghe uvi emateala elome tale ale manga ateva me tale liu nighelei aiaavusuvusuena ateva. ");
INSERT INTO emi_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Aghaaulia ngakoronna va sesa ngaipolipolina isaa oia voto aue elutu tale lo ateva oia vituu. ");
INSERT INTO emi_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem, Jerusalem! Ughe uvi ematela propete atoa, ughe osala tau ngai kasuaa inangarina atoa God tale atu! Ghaisaata aghaloanna tani atoka aitaueinam kapughu taumattu ngatoa, nongina kina paolo ateva eaakou natuna atoa tale kaekaena, me karika am aaloanna! ");
INSERT INTO emi_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Liuna avalua o, me am nongola! God aue ekasu vuli alena ale manga ateva, me masalikiimim taatara ateae aue taunganua. ");
INSERT INTO emi_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Poli aghaauliaa etaimim va karika aue am mene taraieghi, lomosi ta nau eteva aue emae, me aue am ue va, ‘Niarangise ta lo ateva emaemae tale ararina ateae Vau eteva.’” ");
INSERT INTO emi_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu ghe kupi ghoala tale ale manga ateva me ang ghe kasukasu me kapuna disaepolo atoa laghe mae sio etana. Laghe anna tani apasunga ale atoa tale ale manga ateva. ");
INSERT INTO emi_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Iesu ghe kolomilala va, “Am taatara isaa oia ale? Koronnaaili aghaauliaa etaimim va karika teva atu aue etoka saoaa ta mene kateva. Aue taumattu ngatoa la puli reerekata isaa akapaaili oia voto.” ");
INSERT INTO emi_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nau Iesu ghe toka siola tale motouru eteva eOliv me kapuna disaepolo atoa laghe mae sio tani kolomi einaoa va, “Auliaala etaimami, lovisaa isaa oia voto elutu me saa righi aimatoonga aue elutu tani apasunga maemaeaam me airuuruu tale kosa ateva?” ");
INSERT INTO emi_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iesu ghe liula me ghe uela va, “Am paniem teva taumattu erau kameam. ");
INSERT INTO emi_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Poli oroi taumattu aue la mae tale ararighi eteae me la ue va, ‘Aghi Mesaea ieghi,’ me aue la kame oroi taumattu. ");
INSERT INTO emi_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Aue am nongo niaiuvii me kiukiuna me am rau mene matauta isaa o voto, poli isaa o voto aue elutu me airuuruu tale kosa ateva auena emae. ");
INSERT INTO emi_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Patunganua atoa aue la ghaiuvieinila me ararimangali etoa aue la ghaiuvieinila tee. Nimaloo atoa me rukeruke aue la lutu tale kasina patunganua tale kosa ateva. ");
INSERT INTO emi_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Isaa o voto aue enim aitiutiu tale nimmarikana, nongina mmarikana eghaaghaa kinna ateva aliki eteva nau elutulutu. ");
INSERT INTO emi_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Me aue la kuneiem me la tauem lao tani ghaa nimmarikana me aue la uvi emateam. Ila akapa patunganua atoa aue la ssa teeiem poli ararighi eteae. ");
INSERT INTO emi_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tale ia o nau eteva, oroieili taumattu ngatoa aue la oghi vulu uneira niaikaaiaa, me aue la aissa elome etaira, me aue la aitaueinila lao ta tau ngai ssateeira atoa. ");
INSERT INTO emi_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Me oroieili propete kamekame atoa aue la kaurekati me aue la kame oroieili taumattu. ");
INSERT INTO emi_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Poli ssavoto ateva aue enamungaili me niaielousi eteva tale oroi taumattu aue ekapa. ");
INSERT INTO emi_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Me see etingina akorokorongana tale unna niaikaaiaa tale airuuruu, maamauluaane aue esaanga. ");
INSERT INTO emi_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Me ia oia masi kiukiu eteva tale ararimangali eteva epona liu, aue la ppooa ngakapaie see tale kosa ateva va taumattu ngakapa atoa aue la nongoa, vara me airuuruu tale kosa ateva evira mae.” ");
INSERT INTO emi_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Iesu ghe mene auliaa tee lao sio va, “Kasina nau aue am tara voto propet Deniol ghe auliaala, va voto sesaaili aue elutu elome tale ale manga ateva, me eghelei taumattu ngatoa la kasu vulia me ale manga ateva aue enim toka (lo ateva taumattu aue eriti aue alona aue masaanga). ");
INSERT INTO emi_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nau am tara isaa o voto elutu, lo atoa elome eJiudia am ilou sae tale motouru. ");
INSERT INTO emi_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Lo ateva taumattu etokatoka eleka tale ale ateva, erau mene kupi sso va esso ghaa righi ghinnanina tanganuena. ");
INSERT INTO emi_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Karika mene teva taumattu eutana emene oghi lao tanganuena tani laa ghaa unna aiaasae ngeleka. ");
INSERT INTO emi_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Alousiusi ta lo atoa la suusunuku me lo atoa la sussu tale isaa o nau! ");
INSERT INTO emi_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Am looloo sae va am rau mene ilou vuli niaiuvii eteae tale nau kkaili o tale nau manga ateva. ");
INSERT INTO emi_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tale isaa o nau taumattu ngatoa aue la ghaa nimmarikana namungaili, aue elau nongina emua arau tale aitiutiu tale kosa ateva me nau ghaine, me auena karika aue mene righi voto avalua o elutu. ");
INSERT INTO emi_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Me marova God karika ghe nnaala tani atukuna isaa o nau, karika teva aue ghele saanga. Me poli enannangaili isaa o taumattu ghe suitoongaala, sesa nau aue etukuna. ");
INSERT INTO emi_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Tale isaa o nau, arova teva eue etaimim va, ‘Tarala! Mesaea ngateva toko,’ o, ‘Ie teke,’ am rou mene aikaaiaa. ");
INSERT INTO emi_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ta poli katoa taumattu aue la mae me aue la kame va, ‘Aghi Mesaea ngateva’ mene katoa aue la kame va, ‘Aghi propete ieghi,’ aue la mae la ghelei aimatootoongana me voto tani apasunga sarasarakaniaaira tani kame taumattu Vau palepale ghe suitoongaala, kotiva isaa o voto aue eroo. ");
INSERT INTO emi_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Am nongola, llo oia ngaghe aulia ngamuemue alokoila etaimim, me auena elutu. ");
INSERT INTO emi_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Liuna avalua o me arova la ue etaimim va, ‘Ie teke tale voto ateva karika righi taumattu etana,’ karika am mene lao. Me marova la ue va, ‘Ie toko elome tale ale atiulu,’ am rau mene aiesoaa. ");
INSERT INTO emi_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Poli nongina ravaravaia ateva eramerame aloi lao ta sinaka esae me sinaka esuu, aue enongina maemaeaane Natuna ateva Taumattu ngateva. ");
INSERT INTO emi_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kona eaa taumattu matena easoaso, taotaokko atoa la veluvelu eitauaa. ");
INSERT INTO emi_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Nongina Uru ngai Manga ateva eue va, ‘Nau isaa o sesa nau elange, arovaeangaili ta “‘“sinaka ateva aue esaurrom me ulana ateva karika aue emallanga me katto atoa aue la katuu me voto atoa korokorongana ila elomarase aue la ghaisiisia.”’ ");
INSERT INTO emi_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Tale ia o nau eteva aimatootoongane Natuna ateva Taumattu ngateva ekauerekati elomarase. Patunganua akapa atoa tale kosa ateva aue la alousiusi, nau la tara Natuna ateva Taumattu ngateva aue emae tale urukookoo elomarase, tee sarasarakaniaane me kinatama mallangina ateva. ");
INSERT INTO emi_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Me taue ateva aue eaangari enamungaili, me aue esuu kapuna ensolo atoa tani laa kolo aitauaa taumattu ngatoa, ghe suuilala va kapuna ila tale isaa akapanaaili patunganua tale kosa ateva. ");
INSERT INTO emi_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Am rooroo tani ghaa alomasaanga tale kiukiu niaimatoonga tale fig ateae. Nau eteva am tara ai eteae ange tulutulu, am kila va masi nau tale sinaka ateva ange kalakalaala. ");
INSERT INTO emi_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Liuna avalua o, nau am tara isaa o voto, aue am kila va ange kalakalanginala, tapaa ngatamana. ");
INSERT INTO emi_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Aghaaulia ngakoronna ta lo ateva oia vituu va karika poi aue ekapa me isaa o voto aue elutu. ");
INSERT INTO emi_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Elomarase me kosa ateva oia aue ekapa me inangarighi karika poi aue ekapa. ");
INSERT INTO emi_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Me karika teva taumattu ekilakila ia o nau eteva me aoa ngateva tee, tee me ensolo atoa epona liu me Natuna, ta Tamaghi nonga. ");
INSERT INTO emi_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nongina ta nau Noa, aue emene nongina maemaeaane Natuna ateva Taumattu ngateva. ");
INSERT INTO emi_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tale isaa o nau auena manu ghagga ateva ghe mae, taumattu ngatoa laghe namanama me laghe ropiropi me taita me vause atoa laghe lailai me ghe ghaala nau eteva Noa ghe kupi ssola tale anua ateva. ");
INSERT INTO emi_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Me karika laghe kilakila sa ateva aue ghe lutu, lomosi ta manu ghagga ateva ghe mae sio, me ghe gga vellala. Isaa o voto aue nonginaaili maemaeaane Natuna ateva Taumattu ngateva. ");
INSERT INTO emi_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Taita alua aue lalu uungu eutana: kateva aue la ghaaia me kateva aue la rati etokaia. ");
INSERT INTO emi_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ghalua vause aue lalu moomonnaa ngaputuputu katu uiti tani ghelei palaoa: kateva aue la ghaaia, me kateva la rati etokaia. ");
INSERT INTO emi_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Liuna avalua o, me am anguu taatara ta poli karika am kilakila nauna ateva Vauimim ateva aue emae etana. ");
INSERT INTO emi_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Am kila llo toko va, marova taumattu ngateva ekila va tau niainao ateva aue emae ainao tale alena ateva, aue etoka anguenguu me karika aue etau velu alena ateva va tau niainao ateva errutia me ekupi sso. ");
INSERT INTO emi_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Liuna avalua o me am tee, am aimonomonosiaa poli Natuna ateva Taumattu ngateva aue emae tale ia o nau eteva karika am nannaa va aue emae etana. ");
INSERT INTO emi_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Lo ateva tau ngai uungu egheelei emasina uunguaane me alomasaanga ia tani aitaraa voto, vauna ateva erooroo tani atokaia tanganuena tani aitaraa kapuna tau ngai uungu etoa me tani taula aneira inana tale nau nighaa inana. ");
INSERT INTO emi_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Niarangise aue etoka tale lo ateva tau ngai nongonongo anna, vauna ateva etara va egheelei isaa o niuungu, nau eteva ekiriaa mae. ");
INSERT INTO emi_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Aghaaulia ngakoronna etaimim va aue eatokaia va eaitaraa ngakapaaili peina. ");
INSERT INTO emi_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Me arova tau ngai nongonongo anna ateva uunguaane sesa, aue eue ta urunguitanina ateva va, ‘Vaughu eteva karika aue emae parasi,’ ");
INSERT INTO emi_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","me etiuaa tani namanama me tani ropi sesa manu tee katoa, me etiuaa tani uvi kapuna tau ngai uungu etoa la uungu eitauaa teeia. ");
INSERT INTO emi_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ia o tau ngai nongonongo anna ateva kapuna vau eteva aue emae tale ia o nau eteva ennaa va karika aue emae etana. ");
INSERT INTO emi_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nau eteva emae, aue esai putuputua me eatoka teeie lao ta usiemaghalua atoa. Aue la ngala me la aingeresa ngalungaluira. ");
INSERT INTO emi_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Tale nau eteva o ararimangali ngepona liu eteva aue nongina kasangaulu aliki vause. Laghe ghaala kuraaira lam me laghe lao sio tani sou taita ateva elai. ");
INSERT INTO emi_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ghalima etaira alokapakapa me ghalima alomasaanga. ");
INSERT INTO emi_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Alokapakapa atoa laghe saula kuraaira lam me laghe tam ghaa teela mene righi oeli. ");
INSERT INTO emi_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Alomasaanga nonga atoa laghe ghaala uneira oeli laghe kaola tale uneira aikaai oeli me laghe sau teela kuraaira lam. ");
INSERT INTO emi_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Taita ateva elai ghe tam rekataa parasila me laghe mangoola. Liuna avalua o me laghe asekanuela me laghe llusula. ");
INSERT INTO emi_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Elo matuaa voo me laghe aaore me laghe ue va, ‘Lo ateva elai ange reerekata! Am kupi ghoa mae me am ghoa soua!’ ");
INSERT INTO emi_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Me aliki vause atoa laghe totula me laghe kanukanuaala kuraaira lam. ");
INSERT INTO emi_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Alokapakapa atoa laghe uela ta alomasaanga atoa va, ‘Am tau mae sio righi uneimim oeli etaimami ta kuraaimami lam ange palapala.’ ");
INSERT INTO emi_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Laghe liula me laghe uela va, ‘Karika ami rooroo poli erau tam roo etaita. Am lao sio ta lo atoa ita polipoli etaira me am laa poli righi uneimim.’ ");
INSERT INTO emi_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Nau laghe kasukasu elaolao tapaa salana, me taita ateva elai ghe rekataala. Llo ghalima aliki vause laghe aimanomanosiaala, laghe kupi eitauaa teeie ssola tale ninamanama ateae tale nilai eteae, me laghe kavatila atamana ateae. ");
INSERT INTO emi_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Vara me ghalima aliki vause laghe mene rekataala me ngila ghe kolokolo laghe ue va, ‘Namu ngateva, namu ngateva, otila atamana ateae me ami kupi sso.’ ");
INSERT INTO emi_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ghe liula me ghe uela va, ‘Aghaaulia ngakoronna etaimim va karika akilakilaiem.’” ");
INSERT INTO emi_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Me Iesu ghe uela va, “Liuna avalua o me am tani anguu taatara poli karika am kilakila nau eteva me aoa ngateva. ");
INSERT INTO emi_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ararimangali eteva epona liu aue mene nongina taita ateva ghe anna tani kasu me auena emene kiri mae, me ghe kolola kapuna tau ngai nongonongo anna atoa me ghe taula peina etaira. ");
INSERT INTO emi_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kateva ghe taula ghalima airari (5,000) gol koen me kateva ghalua airari (2,000) me mene kateva ghe taula kateva airari (1,000). Ghe tau roorooaa lao sio tale uunguaa kateva kateva erooroo tani ghelei me ghe kasula. ");
INSERT INTO emi_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Lo ateva tau ngai nongonongo anna ghe ghaala ghalima airari arovaeaa ta ghe kasula tani uungu tale unna tani viliki veu me ghe mene ghaala ghalima airari. ");
INSERT INTO emi_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Me lo tee ateva tau ngai nongonongo anna ghe ghaala ghalua airari, ghe mene ghaala ghalua airari. ");
INSERT INTO emi_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Me lo ateva tau ngai nongonongo anna ghe ghaala kateva airari ghe lao sio me ghe laa kai sio liu eteva tapaa kosa me ghe aisuliaala unna viliki veu vauna ateva. ");
INSERT INTO emi_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Oroi nau ghe lange sio me vauira ateva tau ngai nongonongo anna atoa ghe rekatala me ghe anna tani tara llo laghe gheleila tale viliki veu ghe tau lao sio etaira. ");
INSERT INTO emi_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Lo ateva tau ngai nongonongo anna ghe ghaala ghalima airari ghe lao tee sio mene ghalima ghe uunguaala, me ghe uela va, ‘Vau eteva! Ughe tau mae sio ghalima airari, me tarala, aghe uunguaala mene ghalima airari.’ ");
INSERT INTO emi_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Vauna ateva ghe liula me ghe uela va, ‘Amasimasieinio, poli ugheelei emasina uunguaam. Poli ughe ghelei emasinala llo niuungu pisike, aue aghatokaio me uaitaraa oroi voto. Mae sio me umasimasi eitauaa teeieghi.’ ");
INSERT INTO emi_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Lo tee ateva tau ngai nongonongo anna ghe ghaala ghalua airari, ie tee ghe lao sio me ghe uela va, ‘Vau eteva! Ughe tau mae sio ghalua airari me tarala, aghe ghaala mene ghalua.’ ");
INSERT INTO emi_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Vauna ateva ghe liula me ghe uela va, ‘Amasimasieinio, poli ugheelei emasina uunguaam. Poli ughe ghelei emasinala llo niuungu pisike, aue aghatokaio me uaitaraa oroi voto. Mae sio me umae masimasi eitauaa teeieghi.’ ");
INSERT INTO emi_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Vara me lo ateva tau ngai nongonongo anna ghe ghaala kateva airari ghe lao sio me ghe uela va, ‘Vau eteva, akilakila va io tau nisessaieili io, umukemuke voto utam pasapasa me ughaaghaa uiti karika ughe uungu aanasala etana. ");
INSERT INTO emi_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Liuna avalua o me aghe matautula, me aghe lao sio tani kai me aghe aisuliaala unem viliki veu tapaa kosa. Tarala peim isaa toko.’ ");
INSERT INTO emi_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Vauna ateva ghe liula me ghe uela va, ‘Io sesa tau ngai nongonongo anna io me mangoona io! Ukilakila poi va, amukemuke voto atam pasapasa me aghaaghaa uiti karika aghe uungu aanasala etana. ");
INSERT INTO emi_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ughe roola tani laa ghalokoi uneghi viliki veu, tale ale aialokoi viliki veu, me nau eteva aghe rekata, aue aghe mene ghaa me tee righi laghe mene saoaa sae. ");
INSERT INTO emi_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“‘Liuna avalua o me am ghaala kateva airari etana me am tau lao ta lo ateva unna kasangaulu airari (10,000). ");
INSERT INTO emi_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Poli see righi voto etana, aue God emene taula me aue eghaa oroi voto, me lo ateva karika righi voto etana, saa righi lutu voto etana, aue eghaa velu ekapa etana. ");
INSERT INTO emi_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Am sau velu ghoala mangoona ateva tau ngai nongonongo anna eleka. Aue la vella ghoa tale kinatama saurrom ateva, me aue la ghoa toka ngangngala me la aingeresia ngalungaluira.’ ");
INSERT INTO emi_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Nau Natuna ateva Taumattu ngateva emae tale mallangina ateva tee me kapuna ensolo atoa, aue etoka tale aitokatokane ateva king eaapasunga matuutulienaane. ");
INSERT INTO emi_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Taumattu ngakapa atoa tale patunganua akapa atoa tale kosa ateva oia aue la mae velu eitauaa etana me aue epolaila nongina aitoi sipsipi eteva epolapola sipsipi etoa me meemee atoa. ");
INSERT INTO emi_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Aue eatingina sipsipi etoa ta pai muenna ativilau me meemee atoa ta pai uaise ativilau. ");
INSERT INTO emi_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Me king aue eue ta lo atoa tale pai muenna ativilau va, ‘Am mae sio, Tamaghi ghe arangiseiemla. Ta ararimangali eteva ange kaakaluimi ia, tale nau eteva ghe tiuaala emua arau nau God ghe gheleila kosa ateva oia. ");
INSERT INTO emi_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Poli nau aghe maamaloo am ghe tautau mae inana etaghi, me nau aghe anna tani ropi am ghe aaropiropieghi, nau ouna aghi tale masalikiimim am ghe ghaaieghi lao tanganueimim. ");
INSERT INTO emi_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nau karika ghinnanighi am ghe tautau mae ghinna etaghi. Nau aghe iisiki am ghe aaitarainaghi, aghe tokatoka tale ale mata voovoo am ghe mae taataraieghi.’ ");
INSERT INTO emi_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Me ghulughuluena atoa taumattu aue la kolomia va, ‘Vau ngepona, lovisaa ami ghe taraiola ta ughe maamaloo me ami ghe anginiola, me ughe anna tani ropi me ami ghe tau aatu me ughe ropila? ");
INSERT INTO emi_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Lovisaa ouna io tale masalikiimami me ami ghe ghaaio lao sio tanganuemami, o karika ghinnanim me ami ghe tau aatu ghinna? ");
INSERT INTO emi_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Me lovisaa ami ghe taraiola ughe iisiki me ughe tokatoka tale ale mata voovoo me ami ghe atu taataraio?’ ");
INSERT INTO emi_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Me king aue eliu me eue etaira va, ‘Aghaaulia ngakoronna etaimim va, saa voto am ghe gheelei tee kateva nengaghi aliki mela ia, am ghe gheelei etaghi.’ ");
INSERT INTO emi_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Me aue eue ta lo atoa tale pai uaise ativilau va, ‘Am kasu emasalikaala etaghi, nikasikiena etaimim, me ngam laolao tale kura ateae tokatoka liu ia God ghe aimanomanosieiniela ta Satana me kapuna ensolo atoa. ");
INSERT INTO emi_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Poli aghe maamaloo karika am ghe tautau mae inana etaghi, me nau aghe anna tani ropi karika am ghe aaropiropieghi. ");
INSERT INTO emi_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ouna ieghi tale masalikiimim, karika am ghe aaikoloainaghi. Karika ghinnanighi, karika am ghe tautau mae righi ghinnanighi. Aghe iisiki me aghe tokatoka tale ale mata voovoo karika am ghe aaitarainaghi.’ ");
INSERT INTO emi_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Aue la kolomi va, ‘Vau ngepona, lovisaa ami ghe taraiola ughe maamaloo me ughe anna tani ropi me ouna io tale masalikiimami? Me lovisaa karika ghinnanim me ughe iisiki me ughe tokatoka tale ale mata voovoo me karika ami ghe sausiola?’ ");
INSERT INTO emi_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Aue eliu etaira va, ‘Aghaaulia ngakoronna etaimim va, nau karika am ghe gheelei ta kateva nengaghi aliki mela ia, isaa o voto, am ghe tam gheelei etaghi.’ ");
INSERT INTO emi_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Me aue la lao tale sesa nimmarikana ateva tokatoka liu ia me ghulughuluena atoa aue la lao tale maulue ateva tokatoka liu ia.” ");
INSERT INTO emi_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nau eteva Iesu ghe ruula tani apasunga isaa akapa o voto, me ghe uela ta kapuna disaepolo atoa va, ");
INSERT INTO emi_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Am kilakila va kasi ghalua nau me Pasova ngateva etiuaa, me Natuna ateva Taumattu ngateva aue la taue lao me esae vukala tale aikotoo.” ");
INSERT INTO emi_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Me namu ngatoa tale pristi etoa me namu ngatoa la muemua taumattu ngatoa laghe velu eitauaala tale alena ateva Kaeapas, namuu ia ta pristi ekapa atoa, ");
INSERT INTO emi_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","tani ailoeaa vaalua la kune aisulia Iesu me la uvi ematea. ");
INSERT INTO emi_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Me laghe mae sio nonga ta kateva ninannaa va la rau mene ghelei isaa o voto nau Pasova poli teae niaiuvii erau lutu. ");
INSERT INTO emi_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nau Iesu ghe tokala eBetani tanganue Saemon taita ateva emua arau anna tasussuku eteva, ");
INSERT INTO emi_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","laghe namanama me vause ateva ghe kupi sso mae tee masi aikakkaai eteva laghe gheleiela tale atu eteva alabasta ia, ghe kaakaai llo masi ngusungusuaane me aipolina namungaili me ghe kaola ta uruna ateva Iesu. ");
INSERT INTO emi_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Disaepolo atoa ghe sessailala nau laghe tarala llo ghe lutula me laghe ue va, “Eghelei elaelaeaala voto ita rooroo tani ghaa viliki veu etana. ");
INSERT INTO emi_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ghe roola va ghe tauela me aue laghe polia tale viliki veu oroi me isaa o viliki veu, laghe roo tani laa tau lao ta lo atoa karika tue peipeiena ila.” ");
INSERT INTO emi_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iesu ghe kilala nannaaira, me ghe liula me ghe uela va, “Vaalua me esessaiem etana nau egheleila masi voto etaghi? ");
INSERT INTO emi_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Aue lo atoa karika tue peipeiena ila la toka teeiem nau ekapa atoa, me aghi karika oroi nau aue atoka teeiem. ");
INSERT INTO emi_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ekaola voto masi ngusungusuaane etaghi tani aimanomanosieinaghi tale nau niaikkaia. ");
INSERT INTO emi_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Aghaaulia ngakoronna va eaa aue la ppooaa isaa o masi kiukiu tale kosa ateva, aue la ghauliaa tee masi gheeleiaane vause ateva oia, tani nnainia.” ");
INSERT INTO emi_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Me kateva ta kasangaulu ghalua (12) disaepolo, la kolokoloa va Jiudas Iskariot, ghe lao sio ta namu ngatoa ta pristi etoa, ");
INSERT INTO emi_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","me ghe kolomilala va, “Aue am ghele polieghi ta ghaisa arova aghele tau aatu Iesu etaimim?” Me laghe tau lao sio kotolungaulu (30) viliki veu. ");
INSERT INTO emi_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ghe tiuaala tale ia o nau eteva, Jiudas ghe tiuaala tani tara teva masi nau aue etauela etaira. ");
INSERT INTO emi_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tale aitiutiu eteva nau tale nivelu eitauaa tale verete karika righi isti etana, disaepolo atoa laghe lao sio ta Iesu me laghe kolomiela va, “Uanna va eaa aloi ami laa ghaimonomonosiaa ninamanama ateae ta Pasova?” ");
INSERT INTO emi_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ghe uela etaira va, “Nau eteva am kupi sso tale masaliki taatara ateae, aue am tara taumattu ngateva. Am ue etana va, ‘Tisa euela va: Nauna ange rekatala me eanna tani nama Pasova ngateva tee kapuna disaepolo atoa tanganuem.’” ");
INSERT INTO emi_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Liuna avalua o me disaepolo atoa laghe gheleila voto nongina Iesu ghe auliaala, me laghe aipanipaniaala inana tale Pasova ngateva. ");
INSERT INTO emi_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Vara elo alai me Iesu ghe toka tee siola kasangaulu ghalua (12) kapuna disaepolo tale tevoo ainamanama ateva. ");
INSERT INTO emi_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Laghe namanama me Iesu ghe uela etaira va, “Aghaaulia ngakoronna etaimim va kateva etaimim aue etaueghi lao ta tau ngai ssateeghi etoa.” ");
INSERT INTO emi_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nau disaepolo atoa laghe nongola, laghe alousiusieiliila me kateva kateva ghe kookolomia va, “Vau eteva, koti aghi, no?” ");
INSERT INTO emi_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ghe liula me ghe uela va, “Kateva etaimim ita namanama aitauaa, ia aue etaueghi lao ta tau ngai ssateeghi etoa. ");
INSERT INTO emi_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Poli Natuna ateva Taumattu ngateva aue elao nongina Uru ngai Manga ateva eaauliaa va emate. Me alousiusi tale taumattu ngateva etautau lao Natuna ateva Taumattu ngateva ta tau ngai ssateena atoa. Aue ghele masina etana arova ghe tam lutula.” ");
INSERT INTO emi_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jiudas, lo ateva taumattu aue ghe tau lao Iesu, ie tee ghe kolomila ghe uela va, “Koti aghi, no, va Rabae?” Me Iesu ghe uela etana va, “Inangari isaa ona angu auliaala.” ");
INSERT INTO emi_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Laghe namanama me Iesu ghe ghaala verete ateva, me ghe kokkolomi saela ta God tani arangiseia, me ghe piriela me ghe taue lao sio ta disaepolo atoa, me ghe uela etaira va, “Am ghaala me am nama. Isaa oia verete malataughu.” ");
INSERT INTO emi_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Me ghe mene ghaala kapa uaeni eteva me ghe mene kaili emasina saela ta God me ghe tau lao sio etaira me ghe uela va, “Am akapa am ropi etana, ");
INSERT INTO emi_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","poli uaeni eteva oia raeghi ia tani ghelei ouna inangari niaippooa ngaitauaa. Raeghi eteva aue eakalaa ta oroi taumattu ngatoa, tani kkaluaa sesa gheeleiaaira. ");
INSERT INTO emi_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Aghaauliaa etaimim va karika aue amene ropi righi uaeni lomosi ta aue amene ropi ouna uaeni teeiem tale ararimangalina ateva Tamaghi.” ");
INSERT INTO emi_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Me laghe ueila kkinari eteae me laghe kupi ghoala tale masaliki taatara ateae me laghe saela tale motouru eteva eOliv. ");
INSERT INTO emi_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Iesu ghe uela etaira va, “Ghaine eleivoo am akapaaili aue am ilou vulieghi, poli Uru ngai Manga ateva eue va, “‘Aue auvi emate tau ngai toi sipsipi eteva me aue sipsipi etoa la ilou reerekataa.’ ");
INSERT INTO emi_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Me nau atotu tale nimate aue amuemue lao eGalilii me aue am laa taraieghi okae.” ");
INSERT INTO emi_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita ghe aulia ngaotula va, “Arova ila akapa la ilou vulio, aghi karika poi arooroo tani ilou vulio.” ");
INSERT INTO emi_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iesu ghe liula me ghe uela va, “Pita, llo koronna isaa avalua toko va, ia o voo ngateva auena paolo ateva taita eaangari, aue uue akasina kotoluaata va karika ukilakilaieghi.” ");
INSERT INTO emi_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Me Pita ghe aasarasarakana tani ue va, “Karika poi arooroo tani ue va karika akilakilaio! Arova umate aghi tee aue amate teeio.” Ila akapa disaepolo atoa laghe aulia ngavalua o ta Iesu. ");
INSERT INTO emi_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Me Iesu ghe ghaala kapuna disaepolo atoa me laghe lao sio tale voto ateva la kolokoloa va eGetsemeni, me ghe uela etaira va, “Am toka oia me aghi aue amene kasu tee lao tani laa looloo sae.” ");
INSERT INTO emi_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ghe kolola Pita me natuna alua Sebedi me ghe tiuaala tani alousiusieili, me ang ghe ateateaa saasakiaa. ");
INSERT INTO emi_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Me ghe uela etairotolu va, “Maamauluaaghi ange sessaaili tee nialousiusi eteva, me egheleieghi arova amate. Am toka oia me am anguu taatara teeieghi.” ");
INSERT INTO emi_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ghe kasu tee lao sio me ghe tturru siola tapaa kosa matane ghe tau siola me ghe tiuaala tani looloo sae. Ghe ue va, “Tamaghi, arova erooroo uakekkelieghi tale ia oia kapa nimmarikana ateva ange aanna tani ghaaieghi. Me karika umene ghelei tale aloaloannaaghi ta ughelei tale aloannaam.” ");
INSERT INTO emi_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ghe kiriaa lao sio ta disaepolo kotolu me ghe tarailotolla ta lotolu ghe aseasekanua me ghe uela ta Pita va, “Karika erooroo va am nim anguu taatara teeieghi ta kateva nonga aoa? ");
INSERT INTO emi_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Am anguu taatara me am looloo sae ta God va karika am mene katuu tale nitootoonga. Nannaaimim eanna tani ghelei voto, me vilikiimim mangoona.” ");
INSERT INTO emi_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ghe kasu vulilala me ghe mene lao sio tani looloo sae, ghe ue va, “Tamaghi, arova ia oia kapa nimmarikana ateva etam kkelieghi me aropia, aue aghelei aloaloannaam.” ");
INSERT INTO emi_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Vara ghe mene kiriaa mae sio etairotolu me ghe mene saopilotolla ta latolu ghe aseesekanua, poli matairotolu ghe maamaateaili. ");
INSERT INTO emi_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Me ghe mene lao sio tani looloo sae aiaakotonna. Ghe aauliaa inangari ang ghe auliaala mua. ");
INSERT INTO emi_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ghe mene kiriaa lao sio ta disaepolo atoa me ghe uela etaira va, “Am aseasekanua me am kaakaarasi tani ainoana, va? Am tarala! Nau ange rekatala va Natuna ateva Taumattu ngateva ngila tautauela ta nimaira sesa taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Amotolu totula me ita kasu! Lo ateva etautaueghi lao ta tau ngai ssateeghi etoa ange reerekata.” ");
INSERT INTO emi_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nau ghe auliaala llo me Jiudas, kateva ta kasangaulu ghalua (12) disaepolo, ghe rekata teela taumattu ngatoa oroiannaaili ila me laghe posoposo baenata me tuku ngai. Namu ngatoa ta pristi etoa me namu ngatoa laghe sungilala. ");
INSERT INTO emi_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Lo ateva ghe taue lao sio etaira ghe auliaa tau lao sio niaimatoongana ateva aue egheleia. Ghe uela va, “Lo ateva taumattu angusua, ia o lo ateva am kuneia.” ");
INSERT INTO emi_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Liuna avalua o me Jiudas ghe lao sio ta Iesu me ghe uela va, “Rabae!” me ghe ngusuela. ");
INSERT INTO emi_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Me Iesu ghe uela etana va, “Kapughu, gheleila voto umae sio tani ghelei.” Laghe kunela Iesu me laghe poso atinginaiela. ");
INSERT INTO emi_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kateva taumattu ghe tiitingina tee Iesu ghe ghaala baenata ateva me ghe sai patela talingane ativilau kateva kapuna tau ngai nongonongo anna namu ngateva ta pristi etoa. ");
INSERT INTO emi_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Me Iesu ghe uela etana va, “Kaaila baenata ateva, poli lo atoa la aaiuvii tale baenata, aue la uvila tale baenata ateva. ");
INSERT INTO emi_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Karika ukilakila va arooroo tani kolomi sae Tamaghi tani tau sio oroienaaili ensolo atoa me arovaeaa nonga ta aue ghele sungila? ");
INSERT INTO emi_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Me arova aghele ghelei, vaalua aue voto Uru ngai Manga ateva ghe auliaala aue ghele lutu ekoronna?” ");
INSERT INTO emi_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Me Iesu ghe uela ta taumattu ngatoa va, “Am annaa vara aghi tau ngai uvii me sari ghinna ieghi va am sau mae sio baenata me tuku ngai tani kuneieghi? Vaalua me karika am ghe kunekuneieghi nau aghe aapasunga nau ekapa atoa tale ale manga ateva? ");
INSERT INTO emi_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Isaa o voto ghe lutulutu tani rooaa inangariira propete atoa laghe piti elokoila tale Uru ngai Manga ateva.” Tale ia o nau eteva, disaepolo akapa atoa laghe kasu vuliela me laghe iloula. ");
INSERT INTO emi_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Me taumattu ngatoa laghe kunela Iesu me laghe laoainie sio tanganue Kaeapas namuu ia ta pristi etoa, nongina tau ngai aapasunga ngatoa tale inangari nipaopao me namu ngatoa laghe velu eitauaala. ");
INSERT INTO emi_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Vara me Pita ghe aaimuli me karika ghe kalakalaa. Ghe kupi ssola tale valavala ateae ghe taataliaa alena ateva namu ngateva tale pristi etoa me ghe toka tee siola tau ngai toitoi etoa. Ghe toitoi tani tara va sa ateva aue ghe lutu ta Iesu. ");
INSERT INTO emi_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Namu ngatoa ta pristi etoa, me kansolo akapa atoa, laghe paepae righi taumattu aue laghe aikamea righi voto tee Iesu me laghe uvi ematea. ");
INSERT INTO emi_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Oroi taumattu laghe ghaala tani auliaa tee Iesu tale inangari kamena, me kansolo atoa karika laghe tara poila righi voto laghe aauliaa tee Iesu me laghe roo tani uvi ematea. Vara me ghalua taumattu lalu ghe mae sio. ");
INSERT INTO emi_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Lalu ghe uela va, “Taumattu ngateva oia ghe uela va, ‘Arooroo tani rruti alena ale manga ateva God me aue aghatulua ta kotolu nonga nau.’” ");
INSERT INTO emi_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Namu ngateva ta pristi etoa ghe tingina saela me ghe uela ta Iesu va, “Karika aue uliu inangariira? Vaalua tale inangari la ghaauliaa teeio?” ");
INSERT INTO emi_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Me Iesu ghe nim maamatuaa tingina. Me namu ngateva ta pristi etoa ghe uela etana va, “Tale ararina ateae God tokatoka liu ia, aghanna va uauliaa etaimami va koronna va io Mesaea, Natuna io God?” ");
INSERT INTO emi_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Iesu ghe liula me ghe uela va, “Ue, nongina angu auliaala. Aue am tara Natuna ateva Taumattu ngateva ta etoka sio tale pai muenna ativilau ta lo ateva sarasarakana ia, me esio tale karaane epona liu.” ");
INSERT INTO emi_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Vara me namu ngateva ta pristi etoa ghe rasila ghinnanina tani apasunga va ghe tam aloannala tani nongo, me ghe uela va, “Ange ghaala liuna ateva God! Karika ita mene aloanna mene righi taumattu tani auliaa mene righi inangariira poli ngam nongola voto ange auliaala. ");
INSERT INTO emi_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Vaalua am annaa?” Laghe liula me laghe uela va, “Ange gheleila voto sesa erooroo va emate.” ");
INSERT INTO emi_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Me laghe tiuaala tani kanusuiaa matane Iesu me laghe tuutumaria me katoa laghe pooposalaia. ");
INSERT INTO emi_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Me laghe ue etana va, “Poli Mesaea io, uauliaa inangarina God va see ange posalaiola.” ");
INSERT INTO emi_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita ghe tokatoka elome tale valavala ateae ghe taataliaa alena ateva namu ngateva ta pristi etoa, me kapuna vause tau ngai nongonongo anna ateva ghe lao sio etana me ghe uela va, “Io tee ughe kasukasu tee Iesu aGalilii ia.” ");
INSERT INTO emi_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Me ta mataira akapa, Pita ghe liula me ghe uela va, “Karika akilakila isaa ona inangari uaauliaa.” ");
INSERT INTO emi_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Me ghe kupi ghoala tale atamana ateae tale valavala ateae me mene kateva vause tau ngai nongonongo anna ia ghe taraiela me ghe uela ta taumattu ngatoa va, “Ia oia taumattu ngateva ghe kasukasu tee Iesu aNasareti ia.” ");
INSERT INTO emi_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Me Pita ghe mene uela va, “Karika!” Me ghe uela va, “Koronnaaili ta epona liu va karika akilakila ia ona taumattu ngateva.” ");
INSERT INTO emi_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Vara karika masau me lo atoa laghe tiitingina akalakalangina teeia laghe uela etana va, “Koronnaaili va io kateva etaira, poli samasamaam arova aGalilii eteva.” ");
INSERT INTO emi_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Me Pita ghe uela va, “Koronnaaili ta God va karika akilakila ia ona taumattu ngateva!” Vara me paolo ateva taita ia ghe aangarila. ");
INSERT INTO emi_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Arovaea ta Pita ghe annaala inangarina Iesu ghe uela va, “Auena paolo ateva taita ia eaangari, aue uue akasina kotoluaata va karika ukilakilaieghi.” Pita ghe kupi ghoala me ghe ngala alousiusieiliila. ");
INSERT INTO emi_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Elue talaua poopooa namu ngakapa atoa ta pristi etoa me namu ngatoa laghe mae sio nonga tale kateva ninannaa va la uvi emate Iesu. ");
INSERT INTO emi_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Laghe iriela me laghe kasueiniela tani laoainia ta Paelat gavanaa ia. ");
INSERT INTO emi_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nau Jiudas, ia o taumattu ngateva ghe tau lao sio Iesu ta tau ngai ssateena atoa, ghe tarala va aue la uvi emate Iesu, ghe maateailiila ta nannaane me ghe mene laoaa sio viliki veu erooroo kotolungaulu (30) silva koen namu ngatoa ta pristi etoa me namu ngatoa laghe tau lao sio etana. ");
INSERT INTO emi_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ghe uela va, “Ngagheleila voto karika masina tani tau lao taumattu ngateva karika righi kanna ssavoto va la uvi ematea.” Laghe liula me laghe uela va, “Ami saa etana? Uunguaam ona.” ");
INSERT INTO emi_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Jiudas ghe sau velu elokoi siola viliki veu tale ale manga ateva me ghe kasula tani laa naua. ");
INSERT INTO emi_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Namu ngatoa ta pristi etoa laghe ghaa siola viliki veu me laghe uela va, “Uneita loo eue va karika masina tani alokoi sso tale ale viliki veu, poli viliki veu rae llo oia.” ");
INSERT INTO emi_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Liuna avalua o me laghe mae sio tale kateva ninannaa va, tale isaa o viliki veu aue la poli tuku kosa ateva kaluira ia lo atoa laghe gheelei sospena tale kosa me aue liu niaikkaiaaira ia ativuu etoa. ");
INSERT INTO emi_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Liuna avalua o me tale isaa oia nau la aseasea va kosa tale rae ia. ");
INSERT INTO emi_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Me llo voto propete Jerimaea ghe auliaala ghe kaurekatila, ghe uela va, “Laghe ghaala kotolungaulu silva koen, aipolipoli eteva taumattu nge Israeli etoa laghe aseala etana va la polia, ");
INSERT INTO emi_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","me tale isaa o viliki veu laghe polila tuku kosa ateva laghe gheelei sospena kosa etana, nongina Vau ngepona ateva ghe auliaala etaghi.” ");
INSERT INTO emi_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Vara me Iesu ghe tinginala emua ta Paelat gavana ia me ghe kolomiela va, “Io kingi io ta aJiu etoa?” Iesu ghe liula me ghe uela va, “Ue, nongina uaauliaa.” ");
INSERT INTO emi_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nau eteva namu ngatoa ta pristi etoa me namu ngatoa laghe aauliaa teeia inangari emua ta matane Paelat, karika poi Iesu ghe liula. ");
INSERT INTO emi_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Me Paelat ghe kolomiela va, “Karika unongonongo inangari la ghaauliaa teeio?” ");
INSERT INTO emi_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Me karika poi Iesu ghe liula teva tuku inangari laghe aauliaa teeia. Me gavana ghe soghiaala isaa o voto ghe tarala etana. ");
INSERT INTO emi_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kateva voto gavana ghe gheeleia nonga nau tale nivelu eitaua ngateae ta Pasova, ghe tautau velu lo ateva taumattu tale ale mata voovoo taumattu ngatoa laghe anna va etau velua. ");
INSERT INTO emi_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Isaa o nau kateva taumattu, taumattu ngakapa atoa laghe kilakilaia va sesa taumattu ia, ghe tokatoka tale ale mata voovoo, ararina ateae ta Barabas. ");
INSERT INTO emi_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nau taumattu ngatoa laghe mae sio tani velu eitauaa, Paelat ghe kolomilala va, “Am alona va atau velu see me emene atu etaimim: Barabas o Iesu la kolokoloa va Mesaea etana?” ");
INSERT INTO emi_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Poli Paelat ghe kilakila va laghe tam nannaa tee Iesu righi masina, liuna avalua o me laghe maeainie sio etana. ");
INSERT INTO emi_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Paelat ghe tokatoka tale aitokatoka ateva aighelei niaisakei ia, me vausenna ateva ghe suula inangari va, “Urau mene ghelei righi voto tale taumattu ngateva ona karika righi gheeleiaane sesa. Poli ia me ngaghaala oroieili mmarikana tale maamauluaaghi nau aghasoasopoila eleivoo.” ");
INSERT INTO emi_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Namu ngatoa ta pristi etoa me namu ngatoa laghe paapasali taumattu ngatoa va etau velu Barabas me euvi emate Iesu. ");
INSERT INTO emi_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gavana ghe kolomilala va, “See etairarua am anna va atau velua me emene atu etaimim?” Laghe liula me laghe uela va, “Barabas.” ");
INSERT INTO emi_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Me Paelat ghe kolomilala va, “O sa ateva agheleia ta Iesu la aseasea va Mesaea ia?” Ila akapa laghe liula me laghe uela va, “Uavukalaie sae tale aikotoo.” ");
INSERT INTO emi_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Me Paelat ghe kolomilala va, “Poli sa ateva voto sesa ghe gheleila?” Vara me laghe tiuaala tani sama anamungaili va, “Uavukalaie sae tale aikotoo.” ");
INSERT INTO emi_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nau Paelat ghe tarala va karika ang ghe rooroo tani ghelei righi llo, me niaikkaluii eteae ang ghe tiitiuaa, ghe ghaala manu me ghe porala nimane emua ta taumattu ngatoa me ghe uela va, “Karika righi inangarighi tale raena ateva taumattu ngateva oia. Sa ateva elutu etana uunguaaimim.” ");
INSERT INTO emi_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Taumattu ngatoa laghe liula me laghe ue va, “Utau velu rangane ateva etoka etaimami me natuimami etoa.” ");
INSERT INTO emi_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Me ghe tau vella Barabas ghe mene lao sio etaira me Iesu laghe uetaiela mua me ghe taue lao sio va la laa ghavukalaie sae tale aikotoo. ");
INSERT INTO emi_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Me kapuna soldia ngatoa gavana laghe ghaala Iesu me laghe ssoainiela tanganuena Gavana ngateva, me laghe kolo akapala soldia ngatoa me laghe tomuela. ");
INSERT INTO emi_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Laghe ghaa vella ghinnanina me laghe asae taula aiaasae ateva raeraeana ia, ");
INSERT INTO emi_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","me laghe ghaala uasa rorroana me laghe navitaala kou nguru eteva me laghe atokaie saela ta uruna. Me laghe atinginala ai eteae ta nimane muenna atelange, me laghe suusuuiaa emua etana me laghe piipilosia tani ue etana va, “Ei, kapuira kingi eteva aJiu etoa!” ");
INSERT INTO emi_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Laghe kaakanusuia me laghe ghaala ai eteae ta nimane me laghe paruparu uruna ateva. ");
INSERT INTO emi_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nau laghe ruula tani anamisainia, laghe ghaa vella aiaasae ateva etana me laghe mene asae taula ghinnanina me laghe kasueiniela tani laa avukalaie sae tale aikotoo. ");
INSERT INTO emi_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nau laghe laa ghoa eleka, laghe soula taumattu ngateva atala nge Saerini ia, ararina ateae ta Saemon, me laghe aeala me laghe sungiela va esau aikotoo ateva. ");
INSERT INTO emi_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Laghe rekatala tale voto ateva ararina ateae ta Golgota, malloeana va Voto ateva arova Riu uru taumattu ngateva. ");
INSERT INTO emi_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tale ia o voto ateva laghe tau lao sio uaeni ta Iesu va eropi. Laghe kao aitauaa teela voto kaakaalina, me nau Iesu ghe tootoongaala, ghe tam annala tani ropi. ");
INSERT INTO emi_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nau laghe avukalaie saela tale aikotoo me laghe tiuaala tani anamisi tani aikoita ghinnanina. ");
INSERT INTO emi_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Me laghe toka siola tale ia o voto ateva tani toi etokaia va ghe tani mate. ");
INSERT INTO emi_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Epona nongina uruna ateva laghe pitila me laghe avukalala inangari laghe laoainie sio tale niaisakei etana eue va, “Ia oia Iesu, kapuira kingi ia aJiu etoa.” ");
INSERT INTO emi_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Taita alua lalu ghe aaiuvii me lalu ghe ghaaghaa peiira taumattu ngatoa, lalua tee laghe avukala teeilalue saela, kateva ta pai muenna ativilau me kateva ta pai uaise ativilau. ");
INSERT INTO emi_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Me taumattu ngatoa laghe kasukasu tapaa salana, laghe aauliaa teeia inangari karika masina. Laghe ringaringa uruira, ");
INSERT INTO emi_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","me laghe ue va, “Io urooroo tani rruti ale manga ateva me umene atulua ta kotolu nonga nau, asaangiola me ukkure sio tale aikotoo ateva, arova Natuna io God.” ");
INSERT INTO emi_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Namu ngatoa ta pristi etoa me tau ngai aapasunga ngatoa tale inangari nipaopao me namu ngatoa, ila tee laghe aauliaa teeia inangari. ");
INSERT INTO emi_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Laghe ue va, “Eghe asaangila katoa, me karika erooroo tani asaangia! Ia kapuira kingi ia aIsraeli etoa! Am tau veluela me ekkure sio tale aikotoo ateva me aue ami aiesoaa etana. ");
INSERT INTO emi_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ghe aatoka tuutulina ta God. Tau veluela me ghaine God easaangia arova eaannaia, poli ghe ue va, ‘Aghi Natuna aghi God.’” ");
INSERT INTO emi_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tale ie nonga o salana atikirighi tau niainao tee alua laghe avukala teeilalue saela tale aikotoo, lalu ghe aauliaa teeia inangari. ");
INSERT INTO emi_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ghe tiuaala ta pai ngelo sinaka me saurrom ateva ghe akoula kosa ateva, ghe roola kotolu aoa. ");
INSERT INTO emi_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Gharighi ghe 3 kilok me Iesu ghe ngala anamungailiila me ghe uela va, “Eli, Eli, lama sabaktani?” malloeana va, “Kapughu Goto ateva, kapughu Goto ateva, vaalua me angu tau velueghila?” ");
INSERT INTO emi_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nau katoa ta lo atoa laghe tiitingina akalakalangina laghe nongola, laghe uela va, “Ekolokolo Elaija.” ");
INSERT INTO emi_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Arovaea ta kateva ghe iloula tani laa ghaa tuku spans ateva me ghe asuuela tale uaeni kaakaalina me ghe apasapasaiela tale ai eteae me ghe taue saela va Iesu ghe mmua. ");
INSERT INTO emi_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mene katoa laghe ue va, “Tau veluela me ie nonga evukala, me ita tara arova Elaija aue emae asaangia.” ");
INSERT INTO emi_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Me nau eteva Iesu ghe mene aore namungailiila me ghe tau vella maamauluaane. ");
INSERT INTO emi_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tale ia o nau eteva, kalio atiulu ghe vuuvukala tale ale manga ateva ghe tarriila me ghe ghaluevilaula, ghe laa sae tiuaa epona me ghe laa sio ruu euu. Me kosa ateva ghe aisiisiaala me atu etoa laghe tapolapolakala. ");
INSERT INTO emi_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Liengani niaikkaia ngatoa ghe otilala me oroi ila taumattu ngatoa manga ila laghe matela laghe totula me laghe mene mauluela, ");
INSERT INTO emi_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","me laghe totu vulula liengani niaikkaiaa me vara Iesu ghe totula tale nimate me laghe aotuotula ta oroieili ila taumattu ngatoa tale masaliki taatara ateae manga ia. ");
INSERT INTO emi_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nau lo ateva tau ngai uvii ghe aaitoiaa kateva ai (100) tau ngai uvii me lo atoa laghe toitoi evukala Iesu, laghe tarala rukeruke ateva me isaa akapa voto ghe lutula, laghe matautu etinginala me laghe uela va, “Koronna taumattu ngateva oia Natuna ia God.” ");
INSERT INTO emi_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Oroi ila vause atoa laghe tiitingina amasau me laghe taatara. Laghe usilaa Iesu eGalilii tani aisausieinia. ");
INSERT INTO emi_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Elome ta ila o vause atoa, Meri aMakdala ia me Meri kinairarue ia Jeimis me Josep me kinairarua ateva natuna alua Sebedi. ");
INSERT INTO emi_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ghe elo alaila me taumattu ngateva, tue peipeiena ia, ararina ateae ta Josep me tanganuena tale masaliki taatara ateae eArimatia, ghe rekatala, ie tee kapuna disaepolo ia Iesu. ");
INSERT INTO emi_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ghe lao sio ta Paelat me ghe kolomila Iesu etana. Me Paelat ghe uela va la tau lao Iesu etana. ");
INSERT INTO emi_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josep ghe ghaala Iesu me ghe sumuela tale masi kalio raarangisana. ");
INSERT INTO emi_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Me ghe alokoiela tale unna liengani niaikkaia ngateae, ghe kaie ssola elome tale vallae. Ghe atakirila kinatama atu eteva tani tingina airungaa liengani niaikkaia ngateae, me ghe kasula. ");
INSERT INTO emi_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri aMakdala ia me mene kateva Meri lalu ghe tokatoka tale kativilau pai nongina liengani niaikkaia ngateae. ");
INSERT INTO emi_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Vara mene kateva nau, nau manga ia, me namu ngatoa ta pristi etoa me Paresi etoa laghe lao sio ta Paelat. ");
INSERT INTO emi_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Me laghe uela etana va, “Namu ngateva, ami nannaa ia o tau nikamekame ateva nau maulue ia ghe ue va, ‘Vara kotolu nau elange me aue amene totu.’ ");
INSERT INTO emi_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Liuna avalua o me uaulia ngasarasarakana me la tani ghelei ekorokorongana lienga niaikkaia ngateae lomosi ta kotolu nau elange, poli kapuna disaepolo atoa la rau laa ghainaoa me la laa ue ta taumattu ngatoa va ange totula tale nimate. Lo ateva o nikamekame aue sesaaili tale lo akasina ateva nikamekame.” ");
INSERT INTO emi_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Paelat ghe liula me ghe uela va, “Am ghaala tau ngaitoitoi etoa me am laa ghelei ekorokorongana liengani niaikkaia ngateae nongina vaalua am kilakila.” ");
INSERT INTO emi_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Liuna avalua o me laghe lao sio me laghe ghelei ekorokoronganala liengani niaikkaia ngateae me laghe atokala aimatootoongana ateva tale atu eteva va arova teva eghaa velua, aue la kila, me laghe atinginala tau ngaitoitoi etoa tani aitoieinia. ");
INSERT INTO emi_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nau eteva nau manga ateva ghe ruula, me elue talaua poopooa tale aitiutiu eteva tana nau, Meri aMakdala ia me mene kateva Meri lalu ghe lao sio tani taatara tale liengani niaikkaia ngateae. ");
INSERT INTO emi_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Paka rukeruke ateva ghe lutula nongina lalu ghe tiitingina ta kapuna ensolo ateva Vau palepale ghe sio mae epona liu me ghe atakiri vella atu eteva ghe gheelei runga liengani niaikkaia ngateae me ghe tokala epona tale atu eteva. ");
INSERT INTO emi_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mallanga ateva ta vilikina tani nonginaaili ravaravaia ateva me unna aiaasae usousoanaaili nongina karaane ateva. ");
INSERT INTO emi_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Lo atoa laghe aitoiaa liu niaikkaia ngateva laghe matautu saasakiaala, laghe reterete me laghe katu ngalokoi siola tapaa kosa tani nonginaaili matena atoa taumattu laghe asoaso. ");
INSERT INTO emi_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Vara me ensolo ateva ghe uela ta vause atoa va, “Am rau mene matautu. Akilakila va am aloanna tani tara Iesu, ia o ghe matela tale aikotoo. ");
INSERT INTO emi_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Karika ia oia. Ange totula nongina ghe auliaala. Am lange sso tara nongina laghe alokoiela. ");
INSERT INTO emi_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Gharovaeaata ta am kasu me am laa auliaa ta kapuna disaepolo atoa va ange totula tale nimate, me aue am taraia eGalilii, ta ange muemue lao sio okae.” ");
INSERT INTO emi_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Vause atoa laghe matautula me laghe pasula tale nimasimasi. Gharovaea ta laghe kasu vulila liengani niaikkaia ngateae me laghe masimasi etinginala tani laa ghauliaa kieira disaepolo atoa. ");
INSERT INTO emi_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nau eteva laghe laolao, Iesu ghe sousoulala me ghe uela etaira va, “Elue talaua.” Me laghe mae akalakalaa sio tale liue kkena Iesu me laghe posoposo kkena me laghe kkaueiniela. ");
INSERT INTO emi_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Me Iesu ghe uela etaira va, “Am rau mene matautu. Am laa ghauliaa ta tueghi me nengaghi etoa va la lao eGalilii me aue la laa taraieghi okae.” ");
INSERT INTO emi_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nau eteva vause atoa laghe kasukasu elaolao tau ngai uvii etoa laghe aaitoiaa liengani niaikkaia ngateae laghe ssola tale masaliki taatara ateae me laghe aulia ngakapaailiila voto ghe lutula ta namu ngatoa ta pristi etoa. ");
INSERT INTO emi_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nau eteva namu ngatoa ta pristi etoa laghe nongola, laghe kolo aitauaala namu ngatoa me laghe aippooa ngaitauaala tani ghelei righi salana va la poli tau ngai uvii etoa tale namuu viliki veu, me la nim usilaa nongina vaalua aue ila la ghauliaa. ");
INSERT INTO emi_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Laghe uela ta tau ngai uvii etoa va, “Am ue va, ‘Kapuna disaepolo atoa Iesu la mae sio tani ainao Iesu eleivoo nau eteva ami ghe aseasekanua.’ ");
INSERT INTO emi_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Me arova gavana ngateva enongo va am ue va am ghe asekanuela me laghe ainaola Iesu, am rau mene annaa. Aue ami aippooaa teeia me karika aue am ghaa righi maamatana etana.” ");
INSERT INTO emi_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tau ngai uvii etoa laghe ghaala viliki veu me laghe auliaala voto laghe uela va la ghauliaa, me ia o kiukiu eteae ghe kasu ekapa seela ta aJiu etoa tale ia o nau eteva. ");
INSERT INTO emi_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Vara me kasangaulu me kateva (11) disaepolo laghe lao sio eGalilii me laghe saela tale motouru eteva nongina ghe auliaala etaira va aue la laa taraia etana. ");
INSERT INTO emi_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nau eteva laghe taraiela laghe kkaueiniela, me katoa etaira laghe tam aikaaiaala va laghe tarala Iesu. ");
INSERT INTO emi_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Vara me Iesu ghe mae sio etaira, me ghe uela etaira va, “Ngaghele ghaala nimatuutuliena akapa epona liu me tale kosa ateva oia. ");
INSERT INTO emi_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Liuna avalua o me am kasu me am mene ghaa righi disaepolo tale patunganua akapa atoa me am asuula tale ararina ateae Tamaghi me ta Natuna me tale Spirit Manga. ");
INSERT INTO emi_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Me am apasunga etaira tani nongo usilaa isaa akapaaili voto aghe auliaala etaimim me aue atoka teeiem tale nau ekapa atoa elaa ghaa airuuruu tale kosa ateva.” ");
INSERT INTO emi_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Aitiutiu tale masi kiukiuna Iesu Karisto, natuna ia God. ");
INSERT INTO emi_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Isaa oia masi kiukiu nongina propet Aisaea ghe pitila: “Nongola, aue asuu aikasuaa inangarighi eteva, ia aue emuemueinio. Ia aue eaimonomonosiaa salam atikirighi.” ");
INSERT INTO emi_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Tale voto ateva karika righi taumattu ghe tokatoka etana, kateva lingi ngalo taumattu ekolokolo, eue va, ‘Am aimonomonosiaala salane atikirighi Vau palepale. Am ghelei eghulughuluena akapa salane.’” ");
INSERT INTO emi_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jon, ia o taumattu ngateva uunguaane tani asuu taumattu, eghe lao sio tale voto ateva karika righi taumattu etana, me ghe poppooaa ta taumattu ngatoa va la nna ngaioghioghiaa, me la ghaa niasuu, me God aue ekkaluaa kaluira ssavoto. ");
INSERT INTO emi_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ila akapa eJiudia, me taumattu ngakapa atoa eJerusalem, laghe lao sio tani nongo Jon. Laghe aaulia ngaotu kaluira ssavoto, me Jon ghe asuulala tale ateo ateae eJodan. ");
INSERT INTO emi_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon ghe aasae ghinnanina laghe gheleila tale uu kamolo, me ghe ai-iriaa paisi eteae viliki vulumakao ia. Ghe namanama toto me iruena nge tapaa tuvui. ");
INSERT INTO emi_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Eghe aaulia ngaotu va, “Kateva taumattu aue emae emuli ta ngetaghi, ia sarasarakaniaane elaulau sarasarakaniaaghi. Karika masi taumattu ngieghi va asuuiaa patu kkeghi, me apulaka oasa enaghinaghi unna aikasukasu. ");
INSERT INTO emi_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Aghi aghaasuuem tale manu, me ia aue easuuem tale Spirit Manga ateva.” ");
INSERT INTO emi_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tale isaa o nau Iesu ghe kasula eNasareti eGalilii, me ghe lao sio, me Jon ghe asuuela eJodan. ");
INSERT INTO emi_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nau eteva Iesu ghe lau sae mae tale paamanu eteva, eghe tarala epona liu ghe otiela, me Spiriti eteva nongina ghila ateva valusu ia ghe sio mae ta ngetana. ");
INSERT INTO emi_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Epona liu kateva lingi ngalo ghe uela va, “Io natughu io, aghailousiangailiio, me masimasiaaghi ta ngetam namungaili.” ");
INSERT INTO emi_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Katengaata ta Spiriti eteva ghe suula Iesu ghe ssola tale voto ateva karika righi taumattu ta ngetana. ");
INSERT INTO emi_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Iesu ghe tokala ghaatingaulu (40) nau, me Satana ghe mae sio tani tootoongainia. Eghe tokatoka tee ghaata kkena nge tapaa tuvui etoa, me ensolo atoa laghe sio mae tani sausia. ");
INSERT INTO emi_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nau eteva laghe atoka ssola Jon tale ale mata voovoo, Iesu ghe lao sio eGalilii, me ghe tiuaala tani ppooaa masi kiukiuna God. ");
INSERT INTO emi_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Eghe ue va, “Nau eteva God ghe aulieiniela ange rekatala, me ararimangalina ateva God ange kalakalanginala. Am nna ngaioghioghiaa, me am aikaaiaa masi kiukiu.” ");
INSERT INTO emi_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Iesu ghe kasukasu elaolao tale sama ateo talia ngateae eGalilii, me ghe tarala Saemon me nengana ta Andru. Lalu ghe lukuluku, poli tau ngelamana ilalua. ");
INSERT INTO emi_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iesu ghe uela ta ngetairarua va, “Amalu mae usieghi, me aue agheleiemalua me amalu tau ngai luku taumattu.” ");
INSERT INTO emi_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Arovaeaata ta lalu ghe velu elokoila uneirarua uvena me lalu ghe usiela. ");
INSERT INTO emi_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iesu ghe mene kasu tau lao sio, me ghe tarala mene ghalua, Jeimis me nengana ta Jon, natuna ilalua Sebedi. Lalu ghe tokatoka tale olimoirarua paanaka ateva, me lalu ghe aaimonomonosiaa uneirarua uvena. ");
INSERT INTO emi_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nau Iesu ghe tarailaluela me ghe kololaluela, me lalu ghe tingina vulu saela tamairarua tale paanaka ateva tee tau ngai uungu etoa, me lalu ghe usiela. ");
INSERT INTO emi_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Laghe lao sio tale masaliki eteae eKapenium. Ta nau manga ateva, Iesu ghe ssola tale ale nivelu eitaua ngateva, me ghe aapasunga inangarina God ta taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nau eteva laghe nongola inangarina, laghe soghiaala, poli karika ghe aippooaa nongina tau ngai aapasunga ngatoa tale inangari nipaopao, ta nongina taumattu ngateva matuutuliena ia. ");
INSERT INTO emi_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Elome tale ale nivelu eitaua ngateva, kateva taumattu raroai eteva ghe tokatoka etana. Ghe sama anamungailiila me ghe uela va, ");
INSERT INTO emi_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iesu aNasareti io, umae sio tani ghelei sa ateva etaimami? Vara ughelei saasakieinamami? Akilakilaio, io manga io kapuna io God.” ");
INSERT INTO emi_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iesu ghe uela ta raroai eteva va, “Umatua atoka, me ukupi vulue ghoa.” ");
INSERT INTO emi_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Me raroai eteva ghe soghesogheainiela, me ghe aore anamungailiila, me ghe kupi vulu ghoa mae taumattu ngateva. ");
INSERT INTO emi_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Taumattu ngatoa laghe soghiaala voto ateva o ghe lutula, me laghe tiuaala tani aippooaa elome ta ngetaira. Laghe ue va, “Sa ateva ange lutula? Taumattu ngateva oia ange auliaala ouna niapasunga, me nongina taumattu ngateva matuutuliena aippooaane. Nau eaippooaa tee, raroai etoa la nongonongoa.” ");
INSERT INTO emi_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Arovaeaataaili ta kiukiuna voto Iesu ghe gheleila ghe kasu ekapa seela eGalilii. ");
INSERT INTO emi_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Arovaeaata ta Iesu me taumattu ngatoa laghe kupi ghoa mae tale ale nivelu eitaua ngateva, me laghe lao sio tanganue Saemon me Andru, tee Jeimis me Jon. ");
INSERT INTO emi_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Alumuna vause ateva Saemon ghe iisiki, ghe asoaso tale komo poli vilikina ghe aanasa me matana ghe valavalanga. Vara me laghe auliaala ta Iesu va alumuna Saemon eiisiki. ");
INSERT INTO emi_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iesu ghe lao sio me ghe kunela nimane atelange, me ghe totu etokaiela. Aanasa ateva ghe kapala, me ia o vause ateva ghe kaisila aneira inana. ");
INSERT INTO emi_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ang ghe aaitarrauii poli sinaka ateva ang ghe suula, me taumattu ngatoa laghe maeaa sio ta Iesu lo akapa atoa tau sessa ila me tee taumattu raroai etoa laghe tokatoka ta ngetaira. ");
INSERT INTO emi_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Taumattu ngakapa atoa tale masaliki eteae laghe velu eitauaala tale paa ngatamana ateae tale ale ateva. ");
INSERT INTO emi_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Iesu ghe ghelei emasinala oroi tau sessa atoa, me ghe tiu vella oroi raroai etoa. Raroai etoa laghe kilakilaia, liuna avalua o me ghe pao rungainilala va karika la mene sama. ");
INSERT INTO emi_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Elue talaua poopooa Iesu ghe ghue totula, me ghe kasu vulila masaliki eteae, me ghe ssola tale kateva voto karika righi taumattu etana, me ghe tiuaala tani looloo sae. ");
INSERT INTO emi_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saemon me kapuna atoa laghe aimulila tani laa paea. ");
INSERT INTO emi_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nau laghe taraiela me laghe uela va, “Taumattu ngakapaaili etoa la paepaeo!” ");
INSERT INTO emi_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Iesu ghe liula me ghe uela va, “Ita lao tale mene kasina masaliki kalakalangina. Aghaloanna tani laa ppooaa tee etaira, poli mausina avalua o me aghe mae sio.” ");
INSERT INTO emi_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Eghe kasu ekapa seela tale masaliki eGalilii me ghe poppooaa tale aleira ale nivelu eitauaa, me ghe tiutiu velu raroai etoa ta taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kateva taita tau tasussukuna ia ghe mae sio ta Iesu, me namungaili ta ghe kolomila Iesu. Taita ateva oia ghe suuiaala ta liue kkena Iesu, me ghe uela va, “Marova ualoanna, uroo tani ghelei eraarangisanaieghi ta matane God.” ");
INSERT INTO emi_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesu ghe alousiusi teeiela, me ghe saoaa saela nimane atelange etana me ghe uela va, “Aghaloanna. Angu raarangisanala!” ");
INSERT INTO emi_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Katengaata ta tasussuku eteva ghe kapala, me taita ateva ghe masinala. ");
INSERT INTO emi_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Iesu ghe sungiela va ekasu parasi, me eghe aulia ngasarasarakanala va, ");
INSERT INTO emi_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Urau mene auliaa voto elutula etam. Ulao me ulaa ghapasungainio ta pristi eteva, me ughelei aiaavusuvusuena tani apasunga va vilikim ange raarangisanala, nongina Moses ghe auliaala. Me taumattu ngatoa aue la kila va angu raarangisanala.” ");
INSERT INTO emi_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Me nau taita ateva ghe kupi ghoala eghe auliaala ta taumattu ngatoa sa ateva ghe lutula etana. Ghe kiukiuaa ngakapa seela tale masaliki ghe lao sio etana. Liuna avalua o me Iesu karika ghe mene laolao tale tummatavanga, ta ghe nim tokatoka tale voto atoa karika righi taumattu etaira, me taumattu ngatoa tale isaa akapa masaliki laghe mae taataraia. ");
INSERT INTO emi_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kasina nau ghe lange sio me Iesu ghe mene lao sio tale masalikina ateae eKapenium, me taumattu ngatoa laghe nongola va etokatoka elome tale ale ateva. ");
INSERT INTO emi_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Taumattu ngatoa laghe pasula tale ale ateva, eghe ghoala arau etapaa ngatamana, me Iesu ghe poppooaa inangarina God. ");
INSERT INTO emi_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Katoa taumattu laghe maeaa sio kateva taita, karakanna ia, ta Iesu. Ghaata etaira laghe saue mae sio. ");
INSERT INTO emi_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pasueili ale ateva, me karika laghe rooroo tani laoaa ngakalakalaa tau sessa ateva ta Iesu. Liuna avalua o me laghe saula tau sessa ateva, me laghe saeainiela tale pungani ngale ateva, Iesu ghe tokatoka elome etana. Laghe ghaa vella kasina aiaakou tale pungani ngale ateva, me laghe tau siola tau sessa ateva tale komona ateae elome tale ale ateva. ");
INSERT INTO emi_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iesu ghe tarala uneira niaikaaiaa va namuu, me ghe uela ta tau sessa ateva va, “Natughu, kalum ssavoto ange kapala.” ");
INSERT INTO emi_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Katoa tani tau ngai aapasunga tale inangari nipaopao laghe tokatoka elome tale ale ateva laghe nongola, me laghe aannaa va, ");
INSERT INTO emi_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Vaalua me eaippooa ngavalua o? Ange ghaala liuna ateva God! Karika teva erooroo tani kkaluaa ssavoto, ta God nonga!” ");
INSERT INTO emi_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Arovaeaata ta Iesu ghe kilala tale urunguitanina ateva, me ghe uela etaira va, “Vaalua me am nanna ngavalua o elome etaimim? ");
INSERT INTO emi_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Sa ateva voto malumina tani auliaa ta taumattu ngateva karakanna ia? Tani ue va, ‘Kalum ssavoto ange kapala’ o tani ue va, ‘Tingina saela, me usau komom me ukasu’? ");
INSERT INTO emi_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Me aghaloanna va am tara kila, va Natuna ateva Taumattu ngateva matuutuliena teeia tani kkaluaa ssavoto tale kosa ateva...” Vara me Iesu ghe taatara lao sio tale taumattu ngateva karakanna ia, me ghe uela va, ");
INSERT INTO emi_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Aghaauliaa ta ngetam va tingina saela, me usau komom, me ulao tanganuem.” ");
INSERT INTO emi_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Taumattu ngateva ghe tingina saela, me ghe saula komona, me ghe kasula. Ila akapa taumattu ngatoa laghe tarala sa ateva ghe lutula, laghe soghiaala, me laghe tau saela ararina ateae God, me laghe uela va, “Emua arau karika ami ghe taatara righi voto avalua oia, karikaaili!” ");
INSERT INTO emi_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu ghe kupi ghoala tale ale ateva, me ghe kasukasu elaolao elosamarra tale kinatama ateo talia ngateae. Oroieili taumattu ngatoa laghe mene mae sio tani nongoa nau ghe aapasunga voto. ");
INSERT INTO emi_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Eghe kasukasu elaolao me ghe tarala Livae, natuna Alpeas, ghe tokatoka tale natu ngale arighi aighaa takis ia, me Iesu ghe uela etana va, “Mae usieghi.” Ghe tingina saela, me ghe usila Iesu. ");
INSERT INTO emi_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nau Iesu ghe namanama tanganue Livae, oroi ila taumattu ngatoa aighaa takis ila, me tau ssavoto atoa, laghe lao sio tani namanama tee Iesu me kapuna disaepolo atoa, poli oroi ila lo atoa laghe usiusia. ");
INSERT INTO emi_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Katoa tana taumattu tau ngai aapasunga ila tale inangari nipaopao, me taumattu tale Paresi ila, laghe tarala Iesu ghe namanama tee tau ngai ghelei ssavoto atoa me tau ngai ghaa takis atoa. Laghe uela ta kapuna disaepolo atoa va, “Vaalua me enamanama tee tau ngai ghaa takis me tau ssavoto atoa?” ");
INSERT INTO emi_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iesu ghe nongola inangariira me ghe uela ta tau ngai aapasunga ngatoa va, “Lo atoa masina ila karika la ghaloanna niaisausi. Tau sessa nonga atoa la laa taatara dokta. Karika aghe sio mae tani kolo ghulughuluena atoa taumattu. Aghe sio mae tani kolo tau ssavoto atoa.” ");
INSERT INTO emi_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kateva nau kapuna disaepolo atoa Jon me kapuira tee atoa disaepolo Paresi etoa laghe naenae. Katoa tana taumattu laghe mae sio ta Iesu, me laghe kolomila va, “Vaalua me kapuna disaepolo atoa Jon me kapuira disaepolo tee atoa Paresi etoa la naenae, me kapum atoa disaepolo karika?” ");
INSERT INTO emi_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iesu ghe uela va, “Vaalua kapuna atoa taumattu ngateva ange anna tani lai la ghele nae? Karika la rooroo, nau taita ateva ange aloanna tani lai me etokatoka tee kapuna atoa, karika la naenae. ");
INSERT INTO emi_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nau eteva aue emae me la ghaa velu taita ateva, ia o nau eteva aue la nae. ");
INSERT INTO emi_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Karika teva eghaaghaa tuku ouna ateva kalio, me evabbai teva tuku pokane aiaasae. Marova eghelei me nau eporaia, tuku ouna ateva aue eghauna, me eghelei mara ateva emene namuu. ");
INSERT INTO emi_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Me karika teva taumattu etottoli kaai ouna uaeni tale pokane ateva aikaai. Marova eghelei evalua o, aue ouna uaeni eghelei polaki aikaai manu eteva, me aue ilalua akapa uaeni eteva me aikaaina ateva aue lalu peisaane. Karika, la kaokao ouna uaeni tale ouna aikaai.” ");
INSERT INTO emi_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kateva nau manga, Iesu ghe kasu valaala tale utana atingiu, utani uiti ia. Kapuna disaepolo atoa laghe kasukasu eitauaa teeia, me laghe ghaala kasina tani uiti me laghe namala. ");
INSERT INTO emi_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Paresi etoa laghe uela ta Iesu va, “Tarala, vaalua me la gheelei voto o, inangari nipaopao eue va karika masina tani ghelei tale nau manga ateva?” ");
INSERT INTO emi_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iesu ghe liula inangariira me ghe uela va, “Vaalua, karika am ghe ritila kiukiuna ateae Deivit ghe gheleiela, nau ia me kapuna atoa laghe maloola? ");
INSERT INTO emi_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nau ta Abiata, namuu ia tale pristi etoa, Deivit ghe kupi ssola tale alena ateva God, me ghe namala verete laghe amangala, pristi etoa nonga la rooroo tani nama, me ghe taula kasina ta kapuna atoa.” ");
INSERT INTO emi_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iesu ghe mene auliaa tee lao sio va, “God ghe gheleila nau manga ateva mausi taumattu ngatoa, karika God ghe gheleila taumattu ngatoa mausi nau manga ateva. ");
INSERT INTO emi_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Liuna avalua o me Natuna ateva Taumattu ngateva ia tee Vau ia tale nau manga ateva.” ");
INSERT INTO emi_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iesu ghe mene kupi ssola tale kateva ale nivelu eitauaa, me kateva taita ghe tokatoka, katelange nimane matena ia. ");
INSERT INTO emi_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Katoa tau ngai ssateena Iesu mataira ghe laolao nonga ta Iesu va, Iesu aue eghelei emasinaia tale nau manga ateva, o karika. Laghe annaa va marova eghelei emasinaia, aue la laoaa Iesu tale niaisakei. ");
INSERT INTO emi_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Iesu ghe uela ta taita ateva nimane atelange matena ia va, “Tingina saela, me umae toko.” ");
INSERT INTO emi_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Me Iesu ghe kolomilala va, “Vaalua, tale inangari nipaopao, ita rooroo tani ghelei masi niuungu ta nau manga ateva, o tani ghelei sesa niuungu? Ita rooroo tani sausi mene kateva taumattu me erooroo tani toka amasina, o ita uvi ematea?” Tau ngai ssateena atoa Iesu karika laghe liu poila inangarina Iesu. ");
INSERT INTO emi_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iesu ghe aitaraa seela ta taumattu ngatoa me ghe sessaiela. Eghe tarala va karika righi niaielousi tale urunguitaniira, liuna avalua o me karika ghe masinala ta ngetana. Eghe uela ta taita ateva va, “Korosila nimam atelange.” Taita ateva ghe korosila nimane atelange, me ghe masinala. ");
INSERT INTO emi_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nau Paresi etoa laghe tarala voto o ghe lutula, laghe kupi ghoala, me laghe lao sio tani tara kapuna atoa Herot. Laghe ailoeaala salana vaalua la rooroo tani uvi emate Iesu. ");
INSERT INTO emi_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu me kapuna disaepolo atoa laghe kasu vulila voto ateva o, me laghe lao sio tale ateo talia ngateae eGalilii. Tana taumattu ngatoa laghe aimuli teeiela. Taumattu tale distriki eteva eGalilii, eJiudia, ");
INSERT INTO emi_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","eJerusalem, distriki eteva eIdumea, me pai kativilau tale ateo ateae eJodan, me tale patunganue masau eTaer me Saedon, laghe nongola voto Iesu ghe gheleila, me oroieili taumattu laghe mene mae sio ta Iesu. ");
INSERT INTO emi_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Iesu ghe uela ta kapuna disaepolo atoa va, “Am aimonomonosiaala teva paanaka, poli oroieili taumattu ngatoa aue la mae, me aue la ghaisiriki tani mae taraieghi.” ");
INSERT INTO emi_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Poli ang ghe ghelei emasinala oroieili tau sessa atoa, liuna avalua o me oroi tau sessa atoa laghe aloanna tani mae akalakalaa me tani poso Iesu. ");
INSERT INTO emi_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nau ekapa atoa lo atoa raroai etoa laghe tokatoka ta ngetaira laghe taatara Iesu, laghe tuuturru ta liue kkena me laghe samasama atingina me laghe ue va, “Io natuna io God.” ");
INSERT INTO emi_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Iesu ghe aulia ngakorokorongana ta ngetaira va la rau mene aotu va ia see. ");
INSERT INTO emi_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iesu ghe saela tale motouru. Eghe kolola lo atoa ghe aaloannaailiila, me laghe mae sio ta ngetana. ");
INSERT INTO emi_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Eghe suietoongaala kasangaulu ghalua (12) taumattu va ila la toka aitauaa teeia, me ghe aselala va apostolo ila. Aue esungila tani ppooa ngakapa see inangarina ateva God, ");
INSERT INTO emi_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","me aue etau lao sarasarakana tani suu velu raroai etoa. ");
INSERT INTO emi_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Eghe kolola kasangaulu ghalua: Saemon ta kateva, Iesu ghe aseala va Pita etana; ");
INSERT INTO emi_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","eghe kolo teela Jeimis me Jon, natuna ilalua Sebedi (eghe asela arariirarua aluae ta Boaneges, malloeanina va “taumattu nongina palapalanga ateva eaangari”); ");
INSERT INTO emi_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","eghe kolo teela Andru, Pilip, Batolomiu, Matiu, Tomas, Jeimis natuna ia Alpeas, Tadias, Saemon laghe aseala va Selot ia, ");
INSERT INTO emi_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","me Jiudas Iskariot, ia auena ghe tau lao Iesu ta nimaira tau ngai ssateena atoa. ");
INSERT INTO emi_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iesu eghe lao sio tale ale ateva eghe tokatoka etana, me poli tana taumattu ngatoa laghe mene mae sio tani velu eitauaa, Iesu me kapuna disaepolo atoa karika righi nauira tani namanama. ");
INSERT INTO emi_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kapuna atoa Iesu laghe nongola voto eghe poppooaa me ghe gheelei, me laghe mae sio tani kune velua, ta laghe ue va, “Ang ghe veeveenala.” ");
INSERT INTO emi_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Katoa tau ngai aapasunga tale inangari nipaopao laghe kasula eJerusalem me laghe ue va, “Belsibul ange kupiela. Etiutiu velu raroai etoa tale sarasarakaniaane Belsibul, ia namuu ia tale raroai etoa.” ");
INSERT INTO emi_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Iesu ghe kolo aitaueinilala me ghe auliaala kateae kiukiu niaimatoonga. Eghe uela va, “Vaalua, Satana erooroo tani sungi velu Satana? ");
INSERT INTO emi_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Marova taumattu tale kateva patunganua la tam tingina aitauaa, me niaiuvii eteae elutu, karika aue la korokorongana. ");
INSERT INTO emi_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Marova taumattu tale ale ateva la tam tingina aitauaa me niaiuvii elutu, karika aue la korokorongana. ");
INSERT INTO emi_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Me marova Satana essa tee kapuna atoa aue ghalue ila, me eghalua atoka ila, karika aue la korokorongana. Aue la ruu ekilanga. ");
INSERT INTO emi_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Karika teva taumattu erooroo tani kupi sso tanganue taumattu ngateva sarasarakana ia me eghaa peina. Marova ealoanna, eiri etoka tau ngalena ateva, me evira ghaa peina. ");
INSERT INTO emi_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Aghaaulia ngakoronna etaimim va God aue ekkaluaa isaa akapa ssavoto me sesa nginangari taumattu eaauliaa saasakiaa tee God. ");
INSERT INTO emi_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Me marova taumattu eauliaa saasakiaa tale Spirit Manga ateva, God karika aue ekkaluaa isaa oia me auena. Ia oia lo ateva ssavoto aue etoka ta ngetana nau ekapa atoa.” ");
INSERT INTO emi_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu ghe auliaala poli laghe ue va, “Raroai eteva etokatoka etana.” ");
INSERT INTO emi_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kinna Iesu me nengane taita atoa laghe rekatala, me laghe nim suula inangari va eghoa taraila. ");
INSERT INTO emi_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Oroieili taumattu ngatoa laghe tokatoka talieinia, me laghe uela ta ngetana va, “Kinam me nengam taita atoa me vause atoa eleka la paepaeo.” ");
INSERT INTO emi_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Iesu ghe liula me ghe uela va, “See ia kinaghi me see ila kapughu taita atoa?” ");
INSERT INTO emi_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Eghe aitaraa seela tale taumattu ghe taatalia ngatokaia, me ghe uela va, “Taumattu oia kinaghi me nengaghi ila! ");
INSERT INTO emi_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","See eaimuli tee nannaane Tamaghi, ia nengaghi taita ia me nengaghi vause ia me kinaghi ia.” ");
INSERT INTO emi_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kateva nau Iesu ghe mene tiuaala tani apasunga tale sama ateo talia ngateae, me tana taumattu ngatoa laghe mae sio tani mene velu eitauaa. Poli oroieili taumattu, Iesu ghe saesaela tale paanaka ateva, me ghe vukala ghoala elamana, me ghe toka siola, me taumattu ngatoa laghe tinginala elosamarra. ");
INSERT INTO emi_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Iesu ghe aapasunga oroieili voto tale kiukiu niaimatoonga. Ghe ue ta ngetaira va, ");
INSERT INTO emi_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Am nongola! Tau ngai pasa katu ue ngai eteva ghe lao sio tani pasa aina katu ue ngai. ");
INSERT INTO emi_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nau eteva ghe kaokaoaala katu ue ngai, kasina ghe katuula tapaa salana, me ghila atoa laghe namala. ");
INSERT INTO emi_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kasina tana katu ue ngai ghe katuula tale voto ateva sakolo ia, karika oroi kosa, gharovaeaata ta ghe pinosala, poli karika lluse ia. ");
INSERT INTO emi_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nau eteva sinaka ateva ghe saela, eghe sinaki ematela, poli oane karika ghe sio liula ta euu atu ia. ");
INSERT INTO emi_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kasina ghe katuula tale voto ateva uasa karasa atoa ta ngetana. Nau laghe pinosala, uasa karasa atoa laghe kavililala, karika laghe kunela. ");
INSERT INTO emi_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kasina katu ue ngai ghe katuula tale masi kosa. Nau laghe pinosala laghe kuneaala ueneira, kasina ghe kuneaala kotolungaulu (30), kasina ghaonomongaulu (60), me kasina kateva ai (100).” ");
INSERT INTO emi_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Vara me ghe uela va, “Lo ateva talingane manee tani nongo, aue enongo!” ");
INSERT INTO emi_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nau eteva Iesu nonga, me kasangaulu ghalua kapuna disaepolo, me mene katoa tana taumattu laghe tokatoka, me laghe kolomila Iesu tale malloeana kiukiu niaimatoonga. ");
INSERT INTO emi_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Iesu ghe liula me ghe uela va, “God ang ghe apasungaala etaimim voto eaaisulia tale ararimangalina ateva God, me tale taumattu ngeleka, isaa akapa voto aghaauliaa tale kiukiu niaimatoonga. ");
INSERT INTO emi_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Liuna avalua o me inangari tale Uru ngai Manga ateva aue elutu ekoronna, poli, “‘aue la tara me karika aue la tara kila, aue la nongo me karika aloira aue emasaanga, la rau aikolikoliaa, me God ekkaluaa kaluira ssavoto.’” ");
INSERT INTO emi_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Vara me Iesu ghe uela va, “Karika aloimim ange masaangaala kiukiu niaimatoonga ateae? Vaalua aue aloimim emasaanga mene kasina kiukiu niaimatoonga? ");
INSERT INTO emi_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tau ngai pasa katu ue ngai eteva ghe pasala inangari eteva. ");
INSERT INTO emi_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kasina taumattu nongina katu ue ngai ghe katuula tale salana atikirighi. Nau la nongonongo inangarina ateva God, katengaata ta Satana emae ghaaghaa velu isaa o inangari. ");
INSERT INTO emi_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Me katoa tana taumattu nongina katu ue ngai ghe katuula tale voto ateva sakolo ia. La nongonongo me la ghaaghaa me la masimasi. ");
INSERT INTO emi_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Me nongina ai erighi ghauna oane karika esiosio liu, la masimasi nau eteva la nongonongo ta aitiutiu, va nau eteva la ghaaghaa maamatana mausi inangarina ateva God, la kaakatuu. ");
INSERT INTO emi_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Lo tana katu ue ngai ghe katuula elome tale uasa karasa eaimatoonga taumattu la nongonongo inangarina God, ");
INSERT INTO emi_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","me nannaaira namungaili tale voto tale kosa ateva, nongina aloannaaira tani ghaa viliki veu me mene kasina voto. Isaa o voto tale kosa ateva ekaakavili ekatuu inangarina ateva God me karika epiipinosa va emene kuneaa righi ueneira. ");
INSERT INTO emi_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Me llo katu ue ngai ghe katuula tale masi kosa, eaimatoonga taumattu la nongonongo inangarina ateva God me la aiesoaa ta ngetana, me la kuukuneaa masi uene, kasina kotolungaulu, kasina ghaonomongaulu me kasina kateva ai.” ");
INSERT INTO emi_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Vara me Iesu ghe kolomilala va, “Vaalua! Nau eteva am ghaaghaa lam ateae, am aatoka pakeainia tale aikaai eteva me tale aisalo, o am aatokaie sae tale aitiitinginane ateva? ");
INSERT INTO emi_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Voto ghaine eaaisulia auena eotu tale tummatavanga, me isaa akapa voto taumattu egheelei eisulia, auena eotu. ");
INSERT INTO emi_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Lo ateva talingane manee tani nongo, aue enongo!” ");
INSERT INTO emi_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Iesu ghe mene auliaa tee lao sio va, “Inangari angam nongola, am nnaa parasi. Arova am ghelei emasina tale taumattu, Vau palepale aue emene liu ta ngetaimim, me aue emene saoaa sae mene righi. ");
INSERT INTO emi_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","See righi voto etana, aue God emene taula, me lo ateva karika righi voto etana aue eghaa velu righi lutu voto etana.” ");
INSERT INTO emi_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesu ghe mene auliaa tee lao sio va, “Ararimangalina ateva God nongina taumattu ngateva ghe lao sio tani velu katu uiti tale utana atingiu, ");
INSERT INTO emi_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","vara eleivoo taumattu ngateva ghe aseasekanua, me ellaa ghe laa ghelei mene kasina uunguaane, me katu uiti ghe pinosala, me ghe namuula, me taumattu ngateva karika ghe kilala vaalua ghe pinosala me ghe namuula. ");
INSERT INTO emi_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kosa ateva nonga ghe apinosala — me emulina laghe kunela. Aitiutiu vulena ateva, vara me aikouna ateva, emulina ghe kuneaala uene. ");
INSERT INTO emi_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nau eteva utana atingiu ghe matuennala, taumattu ngateva ghe lao sio tani sai uiti.” ");
INSERT INTO emi_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesu ghe mene auliaala va, “Aue ita kolomi va, ‘Ararimangalina ateva God vaalue ia? Vaalua aue ita aimatoongainia?’ ");
INSERT INTO emi_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ia nongina katu ue ngai erighi la kolokoloa va mastet. Nau eteva la pasapasaia tapaa kosa, ghaunaaili ia. ");
INSERT INTO emi_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nau la pasapasaia epiipinosa me enaanamungaili, karika nongina mene kasina katu ue ngai tale utana ateva. Laangina atoa namungaili ila, ghila atoa la rooroo tani laa toka palluu.” ");
INSERT INTO emi_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nau eteva Iesu ghe aaulia ngaotu inangarina tale taumattu ngatoa, ghe aauliaa tale kiukiu niaimatoonga ghe rooroo tale nongonongoaaira taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Karika ghe aaulia ngamasalika teva voto ta ghe aauliaa nonga tale kiukiu niaimatoonga. Nau eteva ia nonga me kapuna disaepolo atoa, me ghe auliaala malloeanina isaa o kiukiu niaimatoonga. ");
INSERT INTO emi_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Elo alai tale ia o nau eteva, Iesu ghe uela ta kapuna disaepolo atoa va, “Ita lao tale pai kativilau tale ateo talia ngateae.” ");
INSERT INTO emi_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Laghe kasu vulila taumattu ngatoa, me laghe saesaela tale paanaka ateva Iesu ang ghe saesae atokala etana, me laghe tiu ghoala. Mene kasina tana paanaka tee laghe tiu ghoa aitauaa teeilala. ");
INSERT INTO emi_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Vara me paka ttasi eteva ghe tiuaala, me kotoo atoa laghe tiuaala tani sae tale paanaka ateva, me manu eteva ang ghe pasupasu tale paanaka ateva. ");
INSERT INTO emi_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iesu ghe aseasekanua emuli tale paanaka ateva, ghe panukanala tale pilo ateva. Vara me laghe anguniela me laghe uela va, “Tisa, ghaisa ngarighi ita vuluu, me koti karika unannaa maamauluaaita va ita rau mate?” ");
INSERT INTO emi_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iesu ghe anguula, me ghe paola ttasi eteva, me ghe uela ta kotoo atoa va, “Am matua avukalala!” me ttasi eteva ghe ruula, me luei eteva ghe asola. ");
INSERT INTO emi_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Vara me ghe kolomila kapuna disaepolo atoa va, “Vaalua me am maamatautu? Karika am ghe aikaaiaa?” ");
INSERT INTO emi_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Laghe matautu saasakiaala, me laghe toka aikolomieinila va, “Saa taumattu ia taumattu ngateva oia, ta kotoo atoa me kuukuu eteva ngila nongo usilainiela?” ");
INSERT INTO emi_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iesu me kapuna disaepolo atoa laghe laa rekata sio tale pai kativilau tale ateo talia ngateae, tanganueira aGerasa ngatoa. ");
INSERT INTO emi_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nau eteva ghe kkurela tale paanaka ateva, arovaeaata ta kateva taumattu raroai eteva ghe tokatoka etana ghe mae sio tani sou Iesu. Taita ateva oia ghe kupi ghoa mae tale voto ateva liu niaikkaiaa ia. ");
INSERT INTO emi_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Eghe tokatoka tale isaa o voto, me karika teva taumattu ghe rooroo tani iri etokaia, me karika laghe rooroo tani iri etokaia tee tale sene. ");
INSERT INTO emi_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Oroiaata laghe gheelei runga poi nimana me kekena tale sene, me ghe gheelei epatepate poli sarasarakanaaili ia. Karika teva taumattu ghe rooroo tani poso atokaia. ");
INSERT INTO emi_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nau ekapaaili tale voo me llaa eghe tokatoka tale voto ateva liu niaikkaiaa ia me tale motouru. Eghe ovaova atingina, me eghe saisai rirrii vilikina tale atu matakerengana. ");
INSERT INTO emi_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nau eghe tara amasau lao sio Iesu, eghe iloula tani laa sousou Iesu, me ghe suuiaala ta liue kkena Iesu. ");
INSERT INTO emi_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Me namuu ta ghe samala me ghe uela va, “Iesu io natuna io God iaaili epona, sa ateva ualoanna tani gheleia etaghi? Aghaaulia ngakoronna tale ararina ateae God va, karika umene ghelei saasakieinieghi.” ");
INSERT INTO emi_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Poli Iesu ang ghe uela etana va, “Raroai eteva, kupi vulu ghoa mae taumattu ngateva.” ");
INSERT INTO emi_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Vara me Iesu ghe kolomiela va, “See ararim ateae?” Me ghe uela va, “Ararighi eteae ta Liijen, poli karika va aghi nonga, ta oroi iemami.” ");
INSERT INTO emi_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ghaisaata arau ghe kolomi esarasarakanala Iesu va erau mene tiu vella va la kasu vuli ia o voto ateva. ");
INSERT INTO emi_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Karika masau tale tuku saesaena ateva tinaua mosu etingiu ghe tingina namanama. ");
INSERT INTO emi_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Raroai etoa laghe kolomi esarasarakanala Iesu va, “Usungi veluemami sae tale mosu etoa, me ami sae kupi etaira.” ");
INSERT INTO emi_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Iesu ghe tau vella raroai etoa laghe kupi vulu ghoa mae taita ateva, me laghe laa sae kupi sso tale mosu etoa. Katengaata ta tinaua atingiu ghe ttiroula, me laghe laa ghoa aoso velu sio tale vallae. Laghe katuu velu siola tale ateo talia ngateae, me laghe matela. Tinaua atingiu eghe arropi ematelala ghe roola ghalua airari (2,000). ");
INSERT INTO emi_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Lo atoa laghe aaitaraa mosu etoa laghe iloula. Laghe lao sio elo ale me tapaa ngutana, me laghe kiukiuaala voto ghe lutula ta mene katoa taumattu, me taumattu ngatoa laghe mae sio tani tara voto ghe lutula. ");
INSERT INTO emi_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Laghe rekatala ta Iesu me laghe tarala taumattu ngateva emua arau oroieili raroai etoa laghe tokatoka etana. Me ia oia, eghe aaitiitii, me nannaane masina me eghe tokatoka. Laghe taraiela, me laghe matautula. ");
INSERT INTO emi_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Taumattu ngatoa laghe tarala voto Iesu ghe gheleila, me laghe kiukiuaala taita ateva raroai etoa etana me Iesu ghe ghelei emasinaiela me voto ghe lutula tale tinaua mosu etingiu. ");
INSERT INTO emi_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nau eteva laghe nongola kiukiu, ila akapa laghe aulia ngasarasarakanala ta Iesu va karika emene toka tale masalikiira ateae, ta elao ppae tale kasina masaliki. ");
INSERT INTO emi_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nau Iesu ang ghe saesae tale paanaka ateva, taita ateva Iesu ghe tiu vella raroai etoa etana ghe kolomi esarasarakanala Iesu va, “Aghaloanna tani usio.” ");
INSERT INTO emi_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Iesu karika ghe annala. Ghe uela etana va, “Lao sio tanganuem me ta kapum atoa. Ulaa ghauliaa voto Vau eteva ghe gheleila tani sausio, me alousiusiaane etam.” ");
INSERT INTO emi_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Taita ateva ghe lao sio tanganuena, me ghe tiuaala tani auliaa inangari me voto Iesu ghe gheleila etana tale Kasangauluae Masaliki Taatara. Taumattu ngakapa atoa laghe nongola, me laghe soghiaala isaa o voto. ");
INSERT INTO emi_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nau Iesu ghe mene lao sio tale pai kativilau tale ateo talia ngateae, oroi taumattu ngatoa laghe mene aimuli teeiela, nau ghe tokatoka elosamarra. ");
INSERT INTO emi_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kateva namuu tale ale nivelu eitaua ngateva, ararina ateae ta Jaeras, ghe mae sio me ghe suuiaala ta liue kkena Iesu, ");
INSERT INTO emi_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","me ghe kolomi esarasarakanala Iesu va, “Natughu vause arighi gharighi tau emate. Aghaloannaaili va umae saoaa nimam etana, me aue emasina me emene toka.” ");
INSERT INTO emi_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Me Iesu ghe usiela. Oroieili taumattu ngatoa laghe usiusi Iesu, me laghe tomtomua. ");
INSERT INTO emi_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kateva vause ie tee elome tale taumattu o, rae ateva eghe iiloueinia ghe roola kasangaulu ghaluae (12) ninamanama. ");
INSERT INTO emi_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nau etoa ghe laa taatara dokta ngatoa. Laghe tootoonga tani sausia, me karika, ta laghe nim tautau lao oroi mmarikana. Unna viliki veu ghe nim kapakapa tani pae niaisausi, me karika ghe maamasina, me ang ghe nim sessaaili. ");
INSERT INTO emi_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nau eghe nongola kiukiuna Iesu, eghe mae sio tani paea, me ie tee eghe tiitingina elome tale taumattu ngatoa pasueili ila me laghe tomtom Iesu. Eghe lao akalakalangina sio emuli ta Iesu, me ghe posola unna aiaasae ngeleka ateva Iesu, ");
INSERT INTO emi_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","poli eghe annaala va, “Marova anim poso unna aiaasae ngeleka ateva, aue amasina.” ");
INSERT INTO emi_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Katengaata ta rae ateva ghe iiloueinia ghe ruula, me ghe ateateaala va ghe masinala. ");
INSERT INTO emi_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Katengaata ta Iesu ghe ateateaala va kasina tani sarasarakaniaane tani ghelei emasina taumattu ghe kasula etana. Liuna avalua o me ghe kiriela me ghe uela va, “See eposola uneghi aiaasae ngeleka ateva?” ");
INSERT INTO emi_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kapuna disaepolo atoa laghe uela va, “Karika utaatara tana taumattu ngatoa la tomtomuo? Vaalua me ukookolomi va see eposola unem aiaasae ngeleka ateva?” ");
INSERT INTO emi_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Iesu ghe kiriela me ghe aaitaraa see va see ghe posoala. ");
INSERT INTO emi_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Me vause ateva ghe kilala voto ghe lutula etana, me ang ghe maamatautu, me ang ghe reterete. Eghe mae sio me ghe suuiaala ta liue kkena Iesu, me ghe aulia ngakapala voto ghe lutula etana. ");
INSERT INTO emi_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iesu ghe uela etana va, “Natughu, tale unem niaikaaiaa etaghi angu masinala. Kasula, me urau mene annaa poli anem isiki eteva ange kapala.” ");
INSERT INTO emi_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesu ghe aippooaa nonga me taumattu ngatoa, kapuna ila namu ngateva tale ale nivelu eitaua ngateva, laghe rekatala. Laghe auliaala ta Jaeras va, “Natum ange matela. Vaalua me uanna tani ghelei Tisa va eainongieinia tani lao tanganuem?” ");
INSERT INTO emi_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iesu karika ghe nongo usilaala. Eghe uela ta namu ngateva va, “Urau mene matautu. Uaikaaiaa nonga.” ");
INSERT INTO emi_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pita, Jeimis me Jon, nengana Jeimis, ilotolu nonga lotolu ghe lao aitauaa teeie sio tanganue Jaeras, me eghe uela ta mene katoa taumattu va la rau mene usia. ");
INSERT INTO emi_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Laghe laa rekata sio tanganue namu ngateva, me Iesu ghe nongola niaingalaaii eteae, me ghe tarala taumattu ngatoa laghe ngangngala anamungaili. ");
INSERT INTO emi_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Eghe kupi ssola me ghe uela etaira va, “Vaalua me am ghelei niaingalaaii eteae, me am ngangngala atingina? Aliki eteva oia karika va ematela. Enim asesekanua.” ");
INSERT INTO emi_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Laghe rrila me laghe kangaala Iesu. Eghe rrila me ghe sungi velu ekapaila ghoala eleka, me ghe kolola nonga kinna me tamane vause arighi me kapuna disaepolo kotolu, me laghe kupi ssola tale rum atiulu aliki eteva eghe asoaso etana. ");
INSERT INTO emi_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Eghe kune siola nimane aliki eteva me ghe uela va, “Talita kum!” (malloeanina va, “Aliki vause arighi, aghauliaa etam va totula!”) ");
INSERT INTO emi_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Katengaata ta aliki vause arighi ghe totu saela, me ghe kasukasula. Nau laghe tarala voto o ghe lutula, laghe soghiaala. Aliki vause arighi oia anna ninamanama kasangaulu ghaluae (12). ");
INSERT INTO emi_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Iesu ghe aulia ngasarasarakanala etaira va karika la mene laa auliaa see voto o ghe lutula. Eghe uela va la tau lao righi inana, me aliki vause arighi enama. ");
INSERT INTO emi_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu ghe kasu vulila masaliki eteae o, me ghe lao sio tale masalikina tuunga ateae. Kapuna disaepolo atoa laghe aimuli teeiela. ");
INSERT INTO emi_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Vara nau manga ateva, me ghe tiuaala tani apasunga voto tale taumattu ngatoa tale ale nivelu eitaua ngateva. Oroieili taumattu laghe nongola inangari, me laghe mene ounala tani nongo, me laghe uela va, “Ia oia taumattu ngateva, eaa ghe ghaala inangari oia? Vaalua ghe ghaala ase alomasaanga ateva oia? Me vaalua me egheelei tee mirikolo sarasarakanaaili? ");
INSERT INTO emi_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nim tau ngai atulu ale ia, nenge? Natuna ia Meri tue me nenga ila me Jeimis, Josep, Jiuda me Saemon. Kapuna vause atoa la tokatoka teeita.” Laghe aaulia ngavalua o poli ghe sessaila etana. ");
INSERT INTO emi_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iesu ghe uela etaira va, “Propete ateva ararina ateae tale isaa akapa masaliki. Me tale masalikina tuunga ateae, me elome tale mangalina atoa, me tale alena tuunga ateva, karika teae ararina.” ");
INSERT INTO emi_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Karika ghe rooroo tani ghelei righi mirikolo okae. Eghe nim saoaala nimane tale taumattu karika oroi, me ghe ghelei emasinailala. ");
INSERT INTO emi_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Eghe soghiaala uneira niaikaaiaa ta ngetana karika namuu. Me ghe lao ppae sio tale kasina masaliki tani apasunga. ");
INSERT INTO emi_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Me ghe kolo aitauaala kasangaulu ghalua (12) disaepolo, me ghe sungilala ghalua ghalua. Ghe tau lao sio matuutuliena tani tiu velu raroai ta taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Me ghe uela etaira va, “Am ghaa aikkatuluimim me am rau mene ghaa mene righi voto. Am rau mene ghaa righi inana, aikakkaai me righi viliki veu tale aikaai viliki veu. ");
INSERT INTO emi_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Am asae aikasukasu, me karika am mene ghaa ghalua aiaasae. ");
INSERT INTO emi_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Arova am rekata tale kateae masaliki, me am toka tale lo ateva ale, am toka o, lomosina ta am kasu vuli lo ateae o masaliki. ");
INSERT INTO emi_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Me arova teae masaliki etam ghaaiem, me karika la ghaloanna tani nongo inangariimim, am kasu. Me nau eteva ngam aloanna tani kasu, am rariaa velu au kosa ta kekeimim, me aue la kila va voto la gheelei karika masina.” ");
INSERT INTO emi_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Disaepolo atoa laghe kasula tani ppooaa tale taumattu ngatoa va la nna ngaioghioghiaa. ");
INSERT INTO emi_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Laghe tiutiu velu raroai, me laghe raarariaa oeli tale tau sessa atoa, me laghe gheelei emasinaila. ");
INSERT INTO emi_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","King Herot ghe nongola kiukiu tale isaa o niuungu poli taumattu ngakapa atoa laghe kiukiuaa see Iesu, me katoa laghe uela va, “Jon tau ngai aasuu eteva ange totula tale nimate, liuna avalua o me sarasarakana ia tani ghelei mirikolo.” ");
INSERT INTO emi_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Me katoa taumattu laghe ue va, “Ia Elaija.” Mene katoa laghe ue va, “Ia propete ia, nongina mene katoa propete emua arau.” ");
INSERT INTO emi_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nau Herot ghe nongola ghe uela va, “Jon, ia o aghe sai pulela alona atiulu, ange mene sakesakela!” ");
INSERT INTO emi_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ia Herot ghe suula inangari me laghe poso atokala Jon. Laghe iriela me laghe atokaiela tale ale mata voovoo mausi Herodias, vausenna ateva tuena ta Pilip, ghe mene lai sariela. ");
INSERT INTO emi_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Poli Jon ghe uela ta Herot va, “Inangari nipaopao ateva eue va karika masina ta ughe mene lai sarila vausenna ateva tuem.” ");
INSERT INTO emi_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias ghe sessaieiliela ta Jon, me ghe aloannaailiila tani uvi ematea, me karika ghe rooroo. ");
INSERT INTO emi_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herot ghe kaakaarasi tani aitaraa Jon, poli ghe maamatautangailiia ta ghe kilakila va Jon ghulughuluena ia me manga ia. Nau ghe nongonongo ta ghe aaippooaa, ghe nannangaili me nannaane ghe maamaate, me ghe aloannaaili tani nongo. ");
INSERT INTO emi_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Masi nau eteva ghe rekatala ta Herodias nau Herot ghe gheleila kinatama ninamanama ateae tani nnaa nau eteva Herot ghe lutula etana. Ghe gheleila ninamanama ateae ta namu ngatoa la uungu ta gavman, namuu ta soldia ngatoa, me namu nge Galilii etoa. ");
INSERT INTO emi_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Laghe toka namanama, me natuna aliki vause ateva Herodias ghe kupi ssola tani ssiiuaa. Herot me lo atoa laghe namanama laghe masimasiangailiila nissiiua ngateae. Herot ghe uela ta aliki vause ateva o va, “Sa ateva voto arova ukolomia etaghi, aue atau aatu.” ");
INSERT INTO emi_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Herot ghe auliaala inangari nialokoi va, “Sa ateva voto arova ukolomi aue atau aatu. Arova uue va atau aatu kativilau tale peighi, aue atau aatu.” ");
INSERT INTO emi_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Aliki vause ateva ghe kupi ghoala, me ghe lao sio tani kolomi kinna va, “Sa ateva voto asso kolomi king etana?” Kinna ghe uela va, “Usso ue va, ‘Aghaloanna uruna ateva Jon tau ngai aasuu eteva.’” ");
INSERT INTO emi_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Arovaeaata ta aliki vause ateva ghe kiri ssola ta king me ghe uela va, “Ghaine arau aghaloanna uruna ateva Jon tau ngai aasuu ia tale tivilau terei.” ");
INSERT INTO emi_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","King ghe nongola me ghe alousiusieiliila. Me poli ang ghe gheleila inangari nialokoi, me karika ghe aloanna tani palata ta mata namu ngatoa, karika ghe roola tani nongo vulu inangarina natuna Herodias. ");
INSERT INTO emi_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","King karika ghe aitoila. Ghe suula soldia ngateva tani laa ghaa uruna ateva Jon. Soldia ngateva ghe lao sio tale ale mata voovoo me ghe sai pulela alona atiulu Jon. ");
INSERT INTO emi_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ghe sau mae sio uruna ateva Jon tale terei etivilau me ghe taue lao sio ta aliki vause ateva. Me aliki vause ateva ghe laoainie sio ta kinna. ");
INSERT INTO emi_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kapuna disaepolo atoa Jon laghe nongola isaa o voto Herot ghe gheleila ta Jon. Laghe lao sio tani ghaa vaulanna ateva Jon, me laghe lao sio tani kaieinia. ");
INSERT INTO emi_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apostolo atoa laghe oghi mae sio, me laghe toka teela Iesu. Laghe kiukiuaala voto laghe gheleila me inangari laghe auliaala ta taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Iesu me kapuna apostolo atoa karika righi nauira tani namanama, poli oroieili taumattu ngatoa laghe mae taatara Iesu me laghe mene kasukasu. Liuna avalua o me Iesu ghe uela etaira va, “Ita lao ta pai kativilau karika righi taumattu etana, me am laa ghainoana.” ");
INSERT INTO emi_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ila nonga laghe kasula tale olimoira paanaka ateva tani lao tale vaara. ");
INSERT INTO emi_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Taumattu ngatoa laghe tarailala ta laghe tiu ghoala, me laghe kilailala. Me oroi taumattu tale kateae kateae masaliki laghe kilala voto ateva laghe laolao etana, me laghe kasu emuemuela tani lao. ");
INSERT INTO emi_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nau Iesu ghe ssola elae, ghe tarala oroieili taumattu ngatoa. Ghe alousiusi teeilala, poli ila nongina sipsipi etoa karika teva aitoiira, me ghe tiuaala tani apasunga oroi voto etaira. ");
INSERT INTO emi_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nau sinaka ateva ang ghe suusuu, kapuna disaepolo atoa laghe lao sio ta ngetana, me laghe uela va, “Ange voovoo, me voto ateva oia nim vaara ia. ");
INSERT INTO emi_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Sungi vellala me la lao tale righi masaliki kalakalangina, me la laa poli righi inana me la nama.” ");
INSERT INTO emi_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Iesu ghe liula me ghe uela va, “Am taula righi inana, me la nama.” Laghe uela va, “Ualoanna va ami laa poliaa velu ghalua ai silva koen tani poli inana tani anginila?” ");
INSERT INTO emi_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Iesu ghe uela etaira va, “Ghaisa verete? Am laa tara.” Nau laghe lao sio, laghe tarala verete ghalima me tee kko alua. ");
INSERT INTO emi_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Iesu ghe uela ta taumattu ngakapa atoa va, “Am laa toka sio tale rarrasa, me am toka tale uela.” ");
INSERT INTO emi_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Laghe tokala katoa kateva ai (100), me katoa ghalimangaulu (50). ");
INSERT INTO emi_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Emulina Iesu ghe ghaala verete ghalima me kko alua, me ghe taatara saela epona liu me ghe kaili emasina saela, me ghe pirila, me ghe tiuaala tani taula ta kapuna disaepolo atoa va la taula. Me ghe koita teela kko alua. ");
INSERT INTO emi_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ila akapa ghe ssoilala nau laghe namanamala. ");
INSERT INTO emi_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Emulina kapuna disaepolo atoa laghe kaai esokosokoiaala tapiri verete me tapiri kko. Laghe kaaila laka erooroo kasangaulu ghaluae (12). ");
INSERT INTO emi_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Taita atoa laghe namala verete ghe roola ghalima airari (5,000). ");
INSERT INTO emi_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Arovaeaata ta Iesu ghe auliaala va kapuna disaepolo atoa laghe aikaaila tale paanaka ateva, me la muemue lao eBetsaida ta pai kativilau, me ia etoka me esungi velu mua taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Vara ghe suu vella taumattu ngatoa, me ghe saela tale motouru tani looloo sae. ");
INSERT INTO emi_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nau ang ghe voola, paanaka ateva ang ghe rekatala elome tale ateo talia ngateae, me Iesu nonga elae. ");
INSERT INTO emi_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ghe taatara va disaepolo atoa laghe oseose poi, me kuukuu eteva ghe aaoghila. Auena ghe pai, me Iesu ang ghe soosokotila. Ghe kasukasu epona tale paamanu eteva, me ang ghe anna tani laula. ");
INSERT INTO emi_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nau disaepolo atoa laghe tarala Iesu ghe kasukasu epona tale paamanu eteva, laghe annaa va raroaina ia teva taumattu, me angeila ghe aaipiia, ");
INSERT INTO emi_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","poli ila akapa laghe taraiela me laghe matautueiliila. Arovaeaata ta Iesu ghe sama teeilala, me ghe uela va, “Am rau mene annaa, ta aghi oia. Am rau mene matautu.” ");
INSERT INTO emi_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Me ghe aikaai teeilala, me kuukuu eteva ghe kapala, me disaepolo atoa laghe soghiaa saasakiaala ia o voto ateva ghe lutula. ");
INSERT INTO emi_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ta poli nannaaira karika marekate tani annaa me tani kila amasina malloeana verete. ");
INSERT INTO emi_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Iesu me kapuna disaepolo atoa laghe ose longotila me laghe kautuula tale distriki eteva eGenesaret, me laghe rekati evukalala olimoira paanaka ateva. ");
INSERT INTO emi_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nau eteva laghe kkurela tale olimoira paanaka ateva, taumattu ngatoa laghe tara kilala Iesu, ");
INSERT INTO emi_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","me laghe ilou ekapa seela eGenesaret tani laa ghauliaa ta mene katoa va Iesu ange rekataala. Me tau sessa atoa, laghe sausau teeila me komoira tani laoainila kona laghe nongonongo nongina eaa Iesu ghe tokatoka. ");
INSERT INTO emi_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nau Iesu ghe laolao tale masaliki pisike me namuu masaliki me tale voto karika oroi masaliki etana, tau sessa atoa laghe aalokoila tale maketi, me laghe kookolomi esarasarakana Iesu, va erooroo va la poso sama ghinnanina, me lo atoa laghe posoposoa laghe maamasina. ");
INSERT INTO emi_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Paresi etoa me katoa tana tau ngai aapasunga tale inangari nipaopao, laghe kasula eJerusalem, laghe lao sio me laghe tomla Iesu. ");
INSERT INTO emi_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Laghe tarala va katoa tana disaepolo kapuna ila Iesu, karika laghe porala nimaira, me laghe tam uusilaa salana tani ghelei me la raarangisana. ");
INSERT INTO emi_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Poli Paresi etoa me ila akapa aJiu etoa laghe aimulisi tee voto tuvuira atoa laghe apasungaala, laghe tam rooroo tani namanama arova la tam pora amasina nimaira. ");
INSERT INTO emi_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Inana laghe polipoli tale maketi, karika la rooroo tani nama, ta laghe vira porapora me laghe namanama. Laghe aaimuli tee mene kasina ase salana nongina vaalua tani pora airopi manu, me aiaku manu, me aituu inana.) ");
INSERT INTO emi_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Paresi etoa me tau ngai aapasunga tale inangari nipaopao laghe kolomila Iesu va, “Vaalua me kapum disaepolo atoa la tam aimuli usi tee voto tuvuita atoa laghe apasungaala etaita va ita gheelei, me la nim namanama me karika la porapora nimaira?” ");
INSERT INTO emi_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iesu ghe liula etaira me ghe uela va, “Koronnaaili voto Aisaea ghe auliaala nau ghe aulia ngamuemua alokoila gheleiaaimim, am usimaghalua am. Nongina Uru ngai Manga ateva eaauliaa, eue va, “‘Isaa oia taumattu la nim oneoneainaghi ta paaira me urunguitaniira masaueili etaghi. ");
INSERT INTO emi_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Karika righi malloeana, uneira nikkauaa poli la ghapasunga llo nim kaluira taumattu ngatoa nonginaaili va kanna God.’” ");
INSERT INTO emi_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Iesu ghe uela etaira va, “Am tam aaimuli tee inangari nipaopao kanna God, ta am nongonongo uusilaa voto taumattu ngatoa laghe nim apasungala. ");
INSERT INTO emi_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Muennaaili iem tani rati inangari nipaopao kanna God, me am anna tani aimuli usi tee voto am, am gheeghelei. ");
INSERT INTO emi_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses ghe uela va, ‘Am oneoneaa kinaimim me tamaimim,’ me ‘Lo ateva ekaakasikiena tamana o kinna aue la uvi ematea.’ ");
INSERT INTO emi_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Me am, am ue va taumattu ngateva erooroo tani aulia ngavalua toko ta kinna me tamana va, ‘Peighi tani sausiemalua ngagheleila inangari nialokoi tani taula ta God.’ ");
INSERT INTO emi_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Arova ange aulia ngavaluela o, am gheeghelei rungainia va erau mene sausi tamana me kinna. ");
INSERT INTO emi_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tale isaa o salana, am gheelei inangarina God enim peepeisaane, ta am aaimulisi tee aauliaaira tuvuimim atoa. Oroieili mene kasina asease voto am gheelei.” ");
INSERT INTO emi_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iesu ghe mene kolo aitauaala taumattu ngatoa me ghe uela etaira va, “Am nongoaghi, me aloimim emasaanga. ");
INSERT INTO emi_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Karika va voto ekasukasu eleka me esosso tale taumattu ngateva va egheeleia etam raarangisana. Saa llo ekupikupi ghoa, isaa o voto egheelei taumattu ngateva etam raarangisana.” ");
INSERT INTO emi_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nau ghe kasu vulila taumattu ngatoa me ghe lao sio elo ale, me kapuna disaepolo atoa laghe lao sio tani kolomia tale isaa o kiukiu niaimatoonga. ");
INSERT INTO emi_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iesu ghe uela etaira va, “Am tee karika am kilakila sa ateva aghaaulieinia? Karika righi voto ekasukasu eleka me esosso tale taumattu ngateva egheeleia va etam raarangisana. ");
INSERT INTO emi_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Poli voto o, karika esosso tale urunguitanina ateva ta esiosio ta kovane, me elaa kupikupi velu ghoa nau eteva elaa tiutiu.” (Tale isaa o inangari, Iesu ghe uela va isaa akapa inana raarangisana.) ");
INSERT INTO emi_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Me ghe mene uela va, “Saa llo voto ekupikupi ghoa tale taumattu ngateva, isaa o voto egheeleia etam raarangisana. ");
INSERT INTO emi_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Elome tale urunguitani taumattu, voto sesa ekasukasu etana. Tani nnaa saasakiaa, me niailai salosaloaa see, me tani ainao, me tani aiuvi emate, ");
INSERT INTO emi_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tani lai sari kateva manna ateva, me tani ssaii, me mene kasina tani voto sesa. Me tani kamekame, me ninanna ngakorokorongana tani ghelei ssavoto marova ghaata kkena atoa, me tani kiiuaa kateva, me tani auliaa saasakiaa tee kateva, me tani tau sae ninannaa, me tani ghelei voto arova alo kapakapa ateva. ");
INSERT INTO emi_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Isaa o voto ekasukasu elome tale taumattu ngateva, liuna avalua o me egheeleia etam raarangisana.” ");
INSERT INTO emi_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iesu ghe kasu vulila masaliki eteae me ghe lao sio tale kateae masaliki kalakalangina ia eTaer, me ghe ssola elome tale kateva ale, me karika eghe aloanna va teva eghe kilaia, me karika ghe roola tani aisulia. ");
INSERT INTO emi_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Arovaeaata ta vause ateva, natuna ateva raroai eteva ghe tokatoka etana, ghe nongola va Iesu ange rekatala, me eghe ailuilui lao sio me ghe suuiaala ta liue kkena Iesu. ");
INSERT INTO emi_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Vause ateva karika aJiu ia, me ghe lutula ePoenisia elome tale patunganua ateva eSiria, ghe kookolomi esarasarakana Iesu tani tiu velu raroai eteva ta natuna aliki vause ateva. ");
INSERT INTO emi_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Iesu ghe uela etana va, “Ami tau ekasina lao inana ta aliki etoa, karika masina tani tau lao aneira inana aliki etoa ta paua atoa.” ");
INSERT INTO emi_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Vause ateva ghe liula, me ghe uela va, “Koronna, vau eteva. Me paua atoa tee la namanama aneira vorovoro nginana aliki etoa tale pake tevoo.” ");
INSERT INTO emi_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Me Iesu ghe uela etana va, “Ta poli angu aulia ngavaluela o, lao sio tanganuem me ulaa tara natum, ta raroai eteva ange kasu vuliela.” ");
INSERT INTO emi_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Vause ateva ghe lao sio tanganuena, me ghe tara alokoila natuna tale komona atiulu, me raroai eteva ang ghe kasu vuliela. ");
INSERT INTO emi_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iesu ghe kasu vulila masaliki taatara ateae eTaer me ghe saela eSaedon, me ghe kasu tee lao sio tale Kasangauluae Masaliki Taatara. Emulina ghe lao sio tale ateo talia ngateae eGalilii. ");
INSERT INTO emi_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Taumattu ngatoa laghe maeaa sio tau sessa ateva ta Iesu, talingana volovolongina me tee paavoo ia, me laghe kolomila Iesu tani saoaa nimana atelange tale taumattu ngateva. ");
INSERT INTO emi_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iesu ghe kolola taumattu ngateva elome ta taumattu ngatoa, me lalu ghe kasu vulilala, me Iesu ghe siki laala vuuvuu nimana alua ta talingane aluelange. Iesu ghe mene kanusuila vuuvuu nimana alua me ghe posola ramuramuti paana ateva. ");
INSERT INTO emi_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Iesu ghe taatara saela epona liu, me ghe ainoana anamuula, me ghe uela ta taumattu ngateva va, “Eppata!” (malloeana va “Talingana eoti!”). ");
INSERT INTO emi_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Katengaata ta talingana taumattu ngateva ghe otila, me ghe sama amasinala. ");
INSERT INTO emi_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iesu ghe paopao poila va, “Am rau mene kkai laa see,” me karika, ta laghe kakkai laa see. ");
INSERT INTO emi_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Taumattu ngatoa laghe soghia ngatinginala mirikolo ateva, me laghe uela va, “Ia oia taumattu ngateva, voto akapa egheelei, masinaaili. Ia nonga ghe gheleila taumattu talingana volovolongina laghe nongonongola me paavoo atoa laghe samala.” ");
INSERT INTO emi_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Isaa o nau oroiannaaili taumattu ghe velu eitauaala, me karika righi inana tani nama. Me Iesu ghe kolola kapuna disaepolo atoa me ghe uela etaira va, ");
INSERT INTO emi_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Aloghu eusiusi taumattu oia, poli ngeila ghe toka teeieghila kotolu nau, me karika righi aneira inana tani nama. ");
INSERT INTO emi_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Arova maloona ila me asungila va la lao tanganueira, aue la taatarruu elaolao ta poli katoa laghe kasu emasaueiliila.” ");
INSERT INTO emi_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Me kapuna disaepolo atoa laghe liula me laghe uela va, “Voto ateva oia karika righi taumattu etana. Eaa aue ita laa ghaa verete me ita angini isaa oia taumattu?” ");
INSERT INTO emi_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Iesu ghe kolomilala va, “Ghaisa verete am uunusi?” Me laghe uela va, “Ghaitu (7).” ");
INSERT INTO emi_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Me ghe uela ta taumattu ngatoa va la toka sio tapaa kosa. Me ghe ghaala verete ghaitu me ghe kaili emasina saela, me ghe pirila, me ghe tau lao sio ta kapuna disaepolo atoa va la laa ghaikoita, me laghe lao sio tani aikoita. ");
INSERT INTO emi_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Me aneira lutu pisi tee paapakala karika oroi, ghe arangisela me ghe uela ta kapuna disaepolo atoa va la laa ghaikoita. ");
INSERT INTO emi_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Taumattu ngatoa laghe namanamala me ghe ssoilala, me laghe kaaila ghaituae laka tale llo tapiri nginana laghe nama vulula. ");
INSERT INTO emi_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ghe roola ghaata airari (4,000) taumattu. Me ghe sungi vellala, ");
INSERT INTO emi_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","me katengaata ta ia me kapuna disaepolo atoa laghe aikaaila tale paanaka ateva, me laghe lao sio tale distriki eteva eDalmanuta. ");
INSERT INTO emi_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Paresi etoa laghe lao sio ta Iesu, me laghe kolomiela va eapasunga teva niaimatootoongana ngepona liu. Laghe aauliaa llo tani nim tootoongainia. ");
INSERT INTO emi_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iesu ghe ateateaala maamatana me ghe uela va, “Vaalua me taumattu ghaine atoa am aloanna tani tara niaimatootoongana? Aghaaulia ngakoronna etaimim va karika aue am tara poi teva.” ");
INSERT INTO emi_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ghe kasu vulilala me ghe mene ghoala tale olimoira paanaka ateva, tani lao ta pai kativilau tale ateo talia ngateae. ");
INSERT INTO emi_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Disaepolo atoa laghe aikkaluaala me karika laghe saula verete. Kateva nonga ia lo ateva ghe kaakaaia tale paanaka ateva. ");
INSERT INTO emi_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iesu ghe aulia ngasarasarakanala etaira va, “Am aikinikinitaa! Me am taatara amasina tale uneira isti Paresi etoa me Herot.” ");
INSERT INTO emi_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Laghe tiuaala tani aippooaa elome etaira va, “Koti eaauliaa llo oia ta karika ita ghaala righi verete.” ");
INSERT INTO emi_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iesu ghe kilala sa ateva laghe aulieinia, me ghe kolomilala va, “Vaalua me am aauliaa va karika righi verete? Karika am ghe kila? Nannaaimim karika ghe oti? ");
INSERT INTO emi_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mataimim karika etaatara? Talingaimim karika enongonongo? Karika am nannaa? ");
INSERT INTO emi_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nau eteva aghe pirila ghalima (5) verete tale ghalima airari (5,000) taumattu, ghaisae laka tapiri verete am ghe kaaila?” “Kasangaulu ghalua (12),” laghe liula. ");
INSERT INTO emi_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Me ghe mene uela va, “Me nau eteva aghe pirila ghaitu (7) verete tale ghaata airari (4,000) taumattu, ghaisae laka am ghe kaaila tapiri verete etana?” “Ghaitu,” laghe liula. ");
INSERT INTO emi_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Me ghe kolomilala va, “Karika am ghe kila poi?” ");
INSERT INTO emi_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Iesu me kapuna disaepolo atoa laghe laa rekata sio eBetsaida. Taumattu ngatoa laghe maeaa sio mata salusalu eteva ta Iesu va ghe posoa me ghe masina. ");
INSERT INTO emi_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Iesu ghe kunela nimana atelange, me lalu ghe kasu tee tau lao sio. Iesu ghe kanusuila matana alua me ghe saoaala nimane etana, me ghe kolomiela va, “Utaatara teva voto, o karika?” ");
INSERT INTO emi_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Taumattu ngateva ghe taatarala me ghe uela va, “Ataatara taumattu ngatoa arova ai etoa la kasukasu.” ");
INSERT INTO emi_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Iesu ghe mene posola matana taumattu ngateva me ghe taatarala, me ghe masinala me ghe tara amasinala voto atoa. ");
INSERT INTO emi_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iesu ghe sungi velue lao sio tanganuena, me ghe uela etana va, “Urau mene lao tapaa masaliki.” ");
INSERT INTO emi_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iesu me kapuna disaepolo atoa laghe saela tale kasina masaliki taatara kalakalangina eSiisaria Pilipae. Tapaa salana me Iesu ghe kolomila kapuna disaepolo atoa va, “Taumattu ngatoa la ue va aghi see?” ");
INSERT INTO emi_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Me laghe liula etana me laghe uela va, “Katoa taumattu la ue va io Jon tau ngai aasuu eteva; kasina eue va io Elaija; me mene katoa la ue va io kateva propete.” ");
INSERT INTO emi_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Iesu ghe mene kolomilala va, “Me am vaalua? Am uue va aghi see?” Pita ghe liula etana va, “Io Mesaea io.” ");
INSERT INTO emi_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Iesu ghe paolala va karika la mene laa kkaila va ia see. ");
INSERT INTO emi_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Me Iesu ghe tiuaala tani tau lao alomasaanga ta kapuna disaepolo atoa, ghe ue va, “Natuna ateva Taumattu ngateva aue etani ghaa oroieili mmarikana. Namu ngatoa, me namu ngatoa ta pristi etoa, me tau ngai aapasunga ngatoa tale inangari nipaopao, aue la ratia. Aue la uvi ematea, me kotolu nau elange me aue etotu tale nimate.” ");
INSERT INTO emi_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ghe ghelei emasalikangailiila etaira, me Pita ghe koloala me lalu ghe laa tingina ppae sio me ghe tiuaala tani kisoia. ");
INSERT INTO emi_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Me Iesu ghe kiriela me ghe taatara lao sio ta kapuna disaepolo atoa, me ghe tiuaala tani kiso Pita. Ghe uela va, “Kasu vulieghila, Satana! Nannaam karika eannaa voto kanna God, ta voto kaluira taumattu ngatoa.” ");
INSERT INTO emi_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Me Iesu ghe kolola oroi taumattu me kapuna disaepolo atoa tani mae etana. Ghe auliaala etaira va, “Marova teva ealoanna tani usieghi, etani sioaa nannaane, me esunuki unna aikotoo ateva, me eaimuli etaghi. ");
INSERT INTO emi_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Me lo ateva ealoanna tani asaangi maamauluaane aue eraua, me lo ateva earau maamauluaane ta poli mausighi, me tee tale masi kiukiu, aue esaanga. ");
INSERT INTO emi_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Marova taumattu ngateva eghaa voto akapaaili tale kosa ateva me maamauluaane ekapa, vaalua isaa o voto aue esausia? Koti karika. ");
INSERT INTO emi_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Sa ateva taumattu ngateva aue etaue lao tani ghaa oghi maamauluaane? ");
INSERT INTO emi_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Vituu eteva oia karika la uusilaa aloannaane God, me la gheeghelei ssavoto, me lo ateva taumattu tale lo ateva oia vituu epalatainaghi me inangarighi, aue Natuna ateva Taumattu ngateva aue epalatainia nau aue esio tee mallangina ateva Tamane me kapuna ensolo atoa manga ila. ");
INSERT INTO emi_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","“Aghaaulia ngakoronna etaimim va katoa etaimim oia am tiitingina, karika aue am mate me aue am tara ararimangalina ateva God emae tee sarasarakaniaane.” ");
INSERT INTO emi_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ghaonomo (6) nau ghe lange sio me Iesu ghe kolola Pita, Jeimis me Jon, me ilaata nonga laata ghe saela tale motouru eteva saesaenaaili ia. Taataraane Iesu ghe aikolikoliaala ta matairotolu, ");
INSERT INTO emi_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","me ghinnanina ghe mallangala me ghe usousoanaailiila, karika poi teva taumattu tale kosa ateva erooroo tani pora kalio va ghe uso avalua o. ");
INSERT INTO emi_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Me lotolu ghe tarala Elaija me Moses lalu ghe kauerekatila me lalu ghe tiuaala tani sama tee Iesu. ");
INSERT INTO emi_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita ghe uela ta Iesu va, “Tisa, masinaaili ta ita tokatoka oia. Angatolu ghelei kotolu ale paapali — kateva alem ia, me kateva alena ia Moses, me kateva Elaija.” ");
INSERT INTO emi_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Pita me kapuna alua lotolu ghe matautu saasakiaala, me ghe tam kilala va sa arighi voto tani auliaa.) ");
INSERT INTO emi_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Me karaane ateva ghe mae sio, me tootoona ateva ghe akoulala, me lingi ngalo ateva elome tale karaane ateva ghe uela va, “Natughu eteva oia, aghaailousiangailiia. Am nongoa.” ");
INSERT INTO emi_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Arovaeaata ta vara lotolu ghe mene taatara, me lotolu ghe luula mene ghalua. Lotolu ghe aaitaraa, me lotolu ghe tara nongala Iesu. ");
INSERT INTO emi_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nau laghe mae siosio tale motouru, Iesu ghe ttoieinilotolla va la rau mene auliaa ta toa saa llo laghe tarala lomosi ta Natuna ateva Taumattu ngateva etotu tale nimate. ");
INSERT INTO emi_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Lotolu ghe nongo usilaala voto ghe ppooaala ta ngetairatolu, me vara lotolu nonga me ngilotolu ghe aikolomieinilotolu va vaalua me euela va etotu tale nimate. ");
INSERT INTO emi_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Me disaepolo kotolu lotolu ghe kolomila Iesu va, “Vaalua me tau ngai aapasunga ngatoa tale inangari nipaopao la ue va Elaija aue etani muemue mae?” ");
INSERT INTO emi_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Iesu ghe liula me ghe uela va, “Elaija aue emae amuemue tani ghelei emasina akapa voto. Me vaalua me Uru ngai Manga ateva eue tee va Natuna ateva Taumattu ngateva aue eghaa oroi voto sesa me aue la ratia? ");
INSERT INTO emi_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Aghaauliaa etaimim va Elaija ang ghe mae sio, me taumattu ngatoa ngeila ghe ghelei ekapala saa llo voto laghe anna tani ghelei etana, nongina Uru ngai Manga ateva eaauliaa.” ");
INSERT INTO emi_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nau laata ghe sio mae tani mene tara katoa disaepolo, laghe tarala oroieili taumattu laghe tomtomla, me tau ngai aapasunga ngatoa tale inangari nipaopao laghe aissakeana teeila tale inangari. ");
INSERT INTO emi_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nau taumattu ngatoa laghe tarala Iesu, ila akapa laghe soghieiniela, me laghe iloula tani laa soua. ");
INSERT INTO emi_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iesu ghe kolomilala va “Sa ateva am aaissakeana teeia?” ");
INSERT INTO emi_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kateva elome tale uta taumattu ngatoa ghe liula me ghe uela va, “Tisa, amaeaa sio natughu eteva etam, poli raroai eteva etokatoka ta ngetana egheeleia karika esamasama. ");
INSERT INTO emi_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nau epoopotainia me usouso paane eghooa me eaaingeresa ngalungaluna me ekakkarakeana. Akolomila kapum disaepolo atoa va la suu velu raroai eteva etana, me karika la roola.” ");
INSERT INTO emi_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iesu ghe liula me ghe uela ta taumattu ngatoa va, “Am lo atoa oia taumattu, karika righi uneimim niaikaaiaa, ghaisaa ta aue atoka teeiem? Me aue ghaisaata ta aue atoiem va am aiesoaa? Am maeaa sio aliki eteva etaghi.” ");
INSERT INTO emi_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Laghe maeaa sio aliki eteva ta Iesu, me nau raroai eteva ghe tarala Iesu ghe gheleila me aliki eteva ghe tiuaala tani oo, me ghe ghelei ekatungiela, me ghe tiuaala tani vilieinia tapaa kosa, me usouso paane ghe ghooa ta paane. ");
INSERT INTO emi_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iesu ghe kolomila tamane aliki eteva va, “Lovisaa isaa oia voto ghe tiuaala etana?” Tamane ghe liula me ghe uela va, “Nau aliki aarau. ");
INSERT INTO emi_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Oroiaata raroai eteva eanna tani uvi ematea. Egheeleia ekaakatuu saoaa tale kura, me tale manu va earropia. Ualousiusi teeiengalua, me usausiengalua arova urooroo.” ");
INSERT INTO emi_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iesu ghe liula me ghe uela va, “Vaalua me uue va, ‘Arova urooroo?’ Poli lo ateva eaaikaaiaa, erooroo tani ghelei ekapa voto.” ");
INSERT INTO emi_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Arovaeaata ta tamane aliki eteva ghe sama anamuula me ghe uela va, “Aghaaikaaiaa; me uasarasarakana uneghi niaikaaiaa.” ");
INSERT INTO emi_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nau Iesu ghe tarala va taumattu ngatoa ngeila ghe maemae akalakalanginaaili etana, me ghe paola raroai eteva; ghe uela va, “Raroai volovolongina me paavoo ateva, aghaauliaa etam va kupi vulu ghoa mae aliki eteva, me auena urau mene laa kupie sso.” ");
INSERT INTO emi_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Raroai eteva ghe piila me ghe gheleila aliki eteva ang ghe oo, me ghe kupi vulue ghoala. Aliki eteva taataraane nonginaaili va ghe matela, oroi taumattu laghe taraiela laghe annaa va ang ghe matela. ");
INSERT INTO emi_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Iesu ghe kunela nimane atelange me ghe sausiela tani tingina, me ghe tinginala. ");
INSERT INTO emi_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nau Iesu me kapuna disaepolo atoa laghe lao sio elo ale me ila nonga laghe tokatoka, me ngeila ghe kookolomi Iesu va, “Vaalua me ami karika ami roola tani tiu velu raroai eteva?” ");
INSERT INTO emi_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iesu ghe liula me ghe uela va, “Nikokkolomi sae nonga ateva erooroo tani tiu velu ia o ase lo ateva raroai. Karika mene tikirighi salana.” ");
INSERT INTO emi_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Laghe kasu vulila masaliki eteae o, me laghe lao tee sio eGalilii, me karika ghe mene anna va teva taumattu ghe kilaia, ");
INSERT INTO emi_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","poli ghe poppooaa tani apasunga ta kapuna disaepolo atoa, me ghe ue etaira va, “Natuna ateva Taumattu ngateva ngeila tautauela ta nimaira taumattu ngatoa, me aue la uvi ematea, me vara kotolu nau elange me aue emene totu.” ");
INSERT INTO emi_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Karika aloira ghe masaangaala llo ghe auliaala, me laghe maamatautu tani kolomia. ");
INSERT INTO emi_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Iesu me kapuna disaepolo atoa laghe lao sio eKapenium. Laghe kupi ssola tale ale ateva me Iesu ang ghe kookolomila va, “Sa ateva am aissakeana teeia tapaa salana?” ");
INSERT INTO emi_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Karika laghe aisauaala, poli nau laghe maemae tapaa salana, laghe aaissakeana va tani see etaira namuu ia. ");
INSERT INTO emi_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iesu ghe toka siola me ghe kolo aitauaala kapuna disaepolo atoa me ghe uela va, “See eanna va emuemue, etani gheleia eairuuruu, me etau ngai uungu ta mene katoa.” ");
INSERT INTO emi_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Me ghe ghaala aliki erighi me ghe atinginaiela elome etaira, me ghe vaghuiela, me ghe uela etaira va, ");
INSERT INTO emi_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“See eannainaghi me eaikoloa aliki etoa, eaaikoloainaghi, me lo ateva taumattu eaikoloainaghi, karika va eaaikoloainaghi nonga, ta eaaikoloa tee Tamaghi ghe sungieghila tani sio.” ");
INSERT INTO emi_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon ghe uela va, “Tisa! Ami tarala taumattu ngateva etiutiu velu raroai eteva tale ararim ateae, me ami paoala va eruu poli karika va ita me ia.” ");
INSERT INTO emi_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Iesu ghe uela etaira va, “Am rau mene paoa, poli lo ateva taumattu eghelei mirikol tale ararighi eteae karika aue ailuilui tani auliaa teeieghi righi voto sesa, ");
INSERT INTO emi_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","poli see karika aissaniita ia, kapuita ia. ");
INSERT INTO emi_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Aghaaulia ngakoronna etaimim va lo ateva taumattu etau aatu righi manu tale ararighi eteae va uropi, poli io kapuna io Karisto, aue eghaa aipolina. ");
INSERT INTO emi_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Arova aliki erighi eaiesoaa etaghi, me teva taumattu egheelei unna niaikaaiaa ekatuu, ghele masinaaili ta arova la ghele iri teva paka ngatu ta ngalona, me la ghele ghoa allusia elo malionge. ");
INSERT INTO emi_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Arova nimam atelange egheleio me ukaakatuu tani ghelei voto sesa, usai kotooia, poli aue emasina ta ngetam arova nimam atelange takotoona me usso tale maulue ateva. Me aue esesaaili arova nimam atelange etokatoka me angu laolao tale Gehenna tale kura ateae karika epalapala. ");
INSERT INTO emi_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Arova kekem atelange egheleio me ukaakatuu tani ghelei voto sesa, usai kotooia, poli aue emasina ta ngetam arova kekem atelange takotoona me ughaa maulue ateva, me esesaaili arova kekem atelange masina me angu laolao tale Gehenna tale kura ateae karika epalapala. ");
INSERT INTO emi_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Me arova teva matam egheleio me ughelei voto sesa, uvaliki velua. Emaamasina arova ukupi sso tale ararimangalina ateva God tee kateva nonga matam, me esesaaili arova matam akapa alua lalu tokatoka me la sau veluo sae tale kura ateae eGehenna, ");
INSERT INTO emi_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","tale ia o voto ateva, “‘ttoliti etoa karika la matemate me kura ateae karika epalapala.’ ");
INSERT INTO emi_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Taumattu ngakapa kura ateae aue gheleila la raarangisana. ");
INSERT INTO emi_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Uela ateva masina ia, me arova namina ateva ekapa, vaalua emene ghelei me aue emene tue namina? Karika erooroo. Am, am toka arova masi uela ateva tani toka amasina, me luei easo elome etaimim me mene katoa taumattu.” ");
INSERT INTO emi_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iesu ghe kasu vulila masaliki eteae, me ghe lao sio tale kativilau tale ateo ateae eJodan, me tale distriki eteva eJiudia. Oroi taita me vause laghe mae sio tani velu eitauaa ta Iesu. Me Iesu ghe aapasunga inangarina God ta ngetaira, nongina ghe gheelei nau etoa. ");
INSERT INTO emi_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Katoa Paresi laghe mae sio tani tootoonga Iesu tale nikokkolomi eteva va, “Uneita inangari nipaopao eue va masina arova taita ateva erati vausenna ateva, o karika?” ");
INSERT INTO emi_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Iesu ghe liula me ghe uela va, “Saa inangari nipaopao Moses ghe tau aatu sio etaimim?” ");
INSERT INTO emi_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Me laghe uela va, “Moses ghe pitila va taita ateva erooroo tani piti uru ngai niairatii, me etaue lao ta vausenna ateva, me esungi velua.” ");
INSERT INTO emi_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iesu ghe uela etaira va, “Moses ghe pitila llo inangari nipaopao etaimim poli urunguitaniimim korokoronganaaili. ");
INSERT INTO emi_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Emua arau nau ta God ghe gheleila kosa ateva, ‘God ghe gheleila taita me vause.’ ");
INSERT INTO emi_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Liuna avalua o me taita ateva ekasukasu vuli tamane me kinna me ekaakateva nonga ilalua me vausenna ateva, ");
INSERT INTO emi_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","me ilalua aue lalu kateva nonga tale vilikiirarua.’ God ghe uela va karika va ghalue ilalua ta kateva nonga ilalua. ");
INSERT INTO emi_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Liuna avalua o me voto God eaatoka aitauaa, karika mene teva taumattu emene pola.” ");
INSERT INTO emi_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nau eteva Iesu me disaepolo atoa laghe kiri lao sio elo ale, me disaepolo atoa ngila ghe mene kookolomi Iesu tale isaa o inangari. ");
INSERT INTO emi_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Me Iesu ghe uela etaira va, “Arova taita ateva ngeratila vausenna ateva me emene lai ppae ta kateva vause, elailai salosaloaa, ta enim ghaaghaa mene kateva vause, me vausenna tuunga ateva ie etokatoka. ");
INSERT INTO emi_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Vause tee ateva arova erati taitanna ateva me elaa lai ta kateva ppae taita ia, ia tee elailai sari, ta enim ghaaghaa taita ateva me taitanna tuunga ateva ie etokatoka.” ");
INSERT INTO emi_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Katoa vause me taita laghe maeaa sio lutu ngaliki etoa ta Iesu va esaoaa nimane etaira, me disaepolo atoa laghe paopaola. ");
INSERT INTO emi_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Me nau eteva Iesu ghe tarailala, karika ghe masimasiaala kapuna disaepolo atoa me ghe uela va, “Am maeainila sio etaghi. Am rau mene tiu velu natu aliki etoa tani mae etaghi, ta ararimangalina ateva God tanganueira ia ase taumattu ngatoa nongina natu aliki etoa. ");
INSERT INTO emi_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Aghaaulia ngakoronna etaimim va arova see karika eghaa ararimangalina ateva God nongina aliki etoa, karikaaili va aue elao tale ararimangalina ateva God.” ");
INSERT INTO emi_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Me Iesu ghe sausau aliki etoa me ghe saasaoaa nimane etaira me ghe aarangiseila. ");
INSERT INTO emi_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nau Iesu ghe mene kasukasu elaolao tapaa salana, taumattu ngateva ghe iloula emuli etana me ghe suuiaala ta liue kkena Iesu, me ghe uela va, “Masi tisa ngateva, vaalua aghelei me aghaa maulue ateva etokatoka liu?” ");
INSERT INTO emi_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iesu ghe liula me ghe uela etana va, “Vaalua me ukolokoloaghi va masina ieghi? Karika teva masina ia ta God nonga. ");
INSERT INTO emi_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ukilakila inangari nipaopao, va karika umene aiuvi emate, karika umene lai sari, karika umene ainao, karika umene kamekame tale niaisakei, karika umene aikameaa tani ghaa voto, me uoneoneaa tamam me kinam.” ");
INSERT INTO emi_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Me ghe liula me ghe uela va, “Tisa, isaa ona inangari nipaopao ngaghe usilaala nau aliki taita aghi.” ");
INSERT INTO emi_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesu ghe tara usiusiela me ghe aielousieiniela, me ghe uela etana va, “Kasina ateva voto karika ughe gheleiela. Lao sio me ulaa tau lao ghinnanim me la poli, me ulaa tau lao viliki veu ta lo atoa karika righi ghinnaniira, me aue utau peipeiena epona liu, me umae aimuli etaghi.” ");
INSERT INTO emi_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Me taumattu ngateva oia nannaane ghe katungailiila tale isaa o inangari, me ghe alousiusila me ghe kasula, poli tue peipeiena ia. ");
INSERT INTO emi_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Me Iesu ghe aitaraala me ghe uela ta kapuna disaepolo atoa va, “Tue peipeiena atoa aue aanasaaili etaira tani sso tale ararimangalina ateva God.” ");
INSERT INTO emi_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Me disaepolo atoa laghe soghiaala tani nongo inangarina Iesu. Iesu ghe mene ppooaa tee tau lao sio va, “Aliki etoa, tani sso tale ararimangalina ateva God, aanasa ia. ");
INSERT INTO emi_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Marova masukasukale ta teva kamolo tani kupi sso tale teae mata raum, aue emasukasukaleaili tee ta teva tue peipeiena tani kupi sso tale ararimangalina ateva God.” ");
INSERT INTO emi_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Mausina avalua o me disaepolo atoa laghe soghiaa saasakiaa teeila inangarina Iesu me ngila ghe aaikolomieinila va, “Arova isaa avalua o, see nonga erooroo tani saanga?” ");
INSERT INTO emi_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu ghe pasiaala matane etaira me ghe uela va, “Ta taumattu ngatoa, karika la rooroo, me ta God la rooroo, poli God erooroo tani ghelei ekapa voto.” ");
INSERT INTO emi_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Me Pita ghe tiuaala tani auliaa ta Iesu va, “Utara, ami ghe kasu vuli ekapannaailiila voto, me ami ghe aimuli teeiola.” ");
INSERT INTO emi_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Me Iesu ghe uela va, “Aghaaulia ngakoronna etaimim va see ia taumattu ngateva eamuemueieghi me uunguaa masi kiukiu me ghe kasu vulila tanganuena, tuena atoa, nengana atoa, kinna me tamane me natuna atoa me umane utana, ");
INSERT INTO emi_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","aue eghaa sae ta kateva ai (100). God aue etau lao oroi voto etana. Nau ta etokatoka tale kosa ateva oia, voto aue eghaa aue eoroieili, me aue elau voto llo peina ghe kasu vulila, aue eghaa oroi ale me tuena me nengana me kinna me natuna me umana utana. Katoa taumattu aue la ghelei voto sesa etana, me emulina aue eghaa maulue ateva etokatoka liu. ");
INSERT INTO emi_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Me oroi ila taumattu ngatoa matuutuliena ila aue la sioaili euu, me see ila lo atoa arariira euu aue la matuutuliena.” ");
INSERT INTO emi_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iesu me kapuna disaepolo atoa laghe mene kasukasu elaolao eJerusalem. Iesu ghe muemueainila me kapuna disaepolo atoa laghe soosoghiaa voto laghe taatara ta Iesu. Taumattu ngatoa laghe aaimuli usi tee Iesu me kapuna disaepolo atoa laghe maamatautu. Iesu ghe mene kolola kasangaulu ghalua (12) kapuna disaepolo, me ghe mene aulia ngaotula voto aue elutu ta maamauluaane. ");
INSERT INTO emi_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ghe uela va, “Am nongo! Nau eteva ngita laa sosso eJerusalem aue la tau lao Natuna ateva Taumattu ngateva ta nimaira namu ngatoa ta pristi etoa me tau ngai aapasunga tale inangari nipaopao atoa, me aue la ghelei niaisakei etana, me la tingina aitauaa tale niaisakei eteae va la uvi ematea. La ruu o, me la taue lao ta nimaira mene katoa ppae karika va aJiu ila. ");
INSERT INTO emi_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Me ila o katoa ppae taumattu aue la ghauliaa inangari niattara etana, la kanusueinia, me la uetaia, me la uvi ematea. Emate me vara aiaakotonna ateva nau, aue etotu.” ");
INSERT INTO emi_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jeimis me Jon, natuna ilalua Sebedi, lalu ghe mae sio ta Iesu me lalu ghe kolomiela va, “Tisa, angalu aloanna tani kolomio tale kateva voto, me angalu aloanna va ughelei ia o voto ateva etaingalua.” ");
INSERT INTO emi_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Me Iesu ghe kolomilaluela va, “Sa ateva amalu aloannaia va agheleia etaimalua?” ");
INSERT INTO emi_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Me lalu ghe uela etana va, “Nau eteva ukingi, kateva etaingalua etoka tale pai muenna ativilau, me kateva tale pai uaise ativilau.” ");
INSERT INTO emi_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Vara me Iesu ghe uela etairarua va, “Karika amalu tani kilakila amasina llo voto amalu kookolomieghi etana. Koti karika amalu rooroo tani ropi tale kapa ateva nimmarikana anga ghaainasiaa tani ropia? Me tani suu tale lo ateva nisuu anga ghaainasiaa tani suu etana?” ");
INSERT INTO emi_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Me lalu ghe uela ta Iesu va, “Angalu rooroo.” Me Iesu ghe uela va, “Koronna. Kapa ateva anga ghaainasiaa tani ropia, aue amalu ropi tee etana, me nisuu eteva anga ghaainasiaa tani suu etana aue amalu suu etana. ");
INSERT INTO emi_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Me see ia lo ateva aue etoka tale pai muenna ativilau me tale pai uaise ativilau, karika uunguaaghi tani tau aatu; karika. Llo o aitokatoka God ang ghe aimonomonosiaala va uneira ila taumattu ngatoa God aue sui toongainila.” ");
INSERT INTO emi_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nau eteva disaepolo kasangaulu (10) laghe nongola inangari Jeimis me Jon, eghe sessailala etairarua. ");
INSERT INTO emi_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Me Iesu ghe kolo aitaueinilala me ghe uela etaira va, “Am kilakila va lo atoa arariira ateae va namuu ila ta tau ngeleka atoa, ila la gheelei taumattu enim uungu aanasa etaira. Me lo atoa matuutuliena ila, la gheelei saasakiaa etaira. ");
INSERT INTO emi_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Isaa o ase gheeleiaaira erau mene toka elome etaimim, karika. Lo ateva taumattu ealoanna tani namuu elome etaimim, esio euu me eghelei nongina tau ngai nongonongo anna atoa. ");
INSERT INTO emi_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Me see ia lo ateva ealoanna tani muemue etaimim, ia aue ekapuimim tau ngai uungu ia. ");
INSERT INTO emi_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mausina avalua o, me Natuna ateva Taumattu ngateva karika ghe sio mae va taumattu ngatoa la uungu etana, karika. Ghe sio mae tani uungu etaira, me tani tau lao maamauluaane, tani ghaa oghi oroi taita me vause.” ");
INSERT INTO emi_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Iesu me kapuna disaepolo atoa laghe rekatala eJeriko, laghe aso taula, me ngila ghe anna tani mene kasu eJeriko. Ia me kapuna disaepolo atoa me taumattu ngatoa oroieili ila laghe usiusia. Me Batimease, natuna ia Timease, ghe tokatoka tale sama salana atikirighi. Mata salusalu ia me uunguaane tani loo viliki veu tale taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Me eghe nongola va Iesu aNasareti ia ange rekatala, me ghe taila tani ovaova atingina va, “Iesu, natuna ia Deivit, ualousiusi teeieghi!” ");
INSERT INTO emi_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Oroi ila taumattu ngatoa laghe kisokisoia me laghe ue etana va, “Urau mene sama.” Me eghe mene ovaova anamungaili va, “Natuna ateva Deivit, ualousiusi teeieghi!” ");
INSERT INTO emi_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Me Iesu ghe tinginala, me ghe uela va, “Am kolo taue mae.” Me laghe uela etana va, “Umasimasi, tingina saela, ange kolokoloo tani lao etana.” ");
INSERT INTO emi_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Vara me ghe uei vella unna aiaasae ngeleka ateva, me ghe tingina parasi saela me ghe lao sio ta Iesu. ");
INSERT INTO emi_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Me Iesu ghe kolomiela va, “Sa ateva ualoannaia va agheleia etam?” Me mata salusalu eteva ghe uela va, “Vau eteva! Aghaloanna tani taatara.” ");
INSERT INTO emi_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Me Iesu ghe uela etana va, “Kasula, ta unem niaikaaiaa ngeghelei emasinaiola.” Me arovaeaata ta matane alua ghe otila o, me ghe usila Iesu tapaa salana. ");
INSERT INTO emi_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nau eteva laghe mae akalakalangina sio eJerusalem, me eBetpeis me eBetani, masaliki eluae tale motouru eteva eOliv, Iesu ghe suula kapuna disaepolo alua, ");
INSERT INTO emi_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","me ghe uela va, “Amalu lao tale masaliki eteae ita taataraie ia o. Nau amalu rekata etana, amalu tara atingina natu donki eteva naunau etingina ia karika teva taumattu ghe sae toka me ghe ilou etana. Amalu pulakaia me amalu maeainia. ");
INSERT INTO emi_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Arova teva taumattu eue etaimalua va, ‘Vaalua me amalu ghaaghaaia?’ amalu ue va, ‘Vau eteva ealoannaailiia me auena emene oghieinie mae.’” ");
INSERT INTO emi_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Me lalu ghe lao sio lalu ghe laa tara atingina sio natu donki eteva tapaa ngatamana tale ale ateva, tapaa salana, me lalu ghe pulakaiela. ");
INSERT INTO emi_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Katoa laghe tiitingina laghe uela etairarua va, “Vaalua me amalu puupulaka donki eteva?” ");
INSERT INTO emi_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Me lalu ghe auliaala saa llo Iesu ghe auliaala etairarua, me laghe tau vellaluela me lalu ghe kasula. ");
INSERT INTO emi_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Lalu ghe laoainie sio ta Iesu. Lalu ghe alokoi saela uneirarua aiaasae ngeleka etana me Iesu ghe laa sae toka etana. ");
INSERT INTO emi_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Me oroieili ila lo atoa laghe tiuaala tani llu velu uneira aiaasae ngeleka epona tale salana atikirighi. Mene katoa laghe laa saisai laa ootou, me laghe veluvelu epona tale salana atikirighi. ");
INSERT INTO emi_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Lo atoa laghe kasukasu emua me lo atoa laghe usiusia laghe ovaova tani ue va, “Tau sae ararina ateae God! God aue earangise lo ateva emaemae elome tale ararina ateae Vau ngepona ateva!” ");
INSERT INTO emi_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Niarangise tale ararimangalina ateva tuvuita ateva ta Deivit aue emae!” “Tau sae ararina ateae God iaaili epona!” ");
INSERT INTO emi_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iesu ghe ssola eJerusalem, me ghe kupi ssola tale ale manga ateva, me ghe aaitaraa see tale voto atoa. Me ia o ang ghe elo alaila me Iesu ghe kiri lao sio eBetani tee me kapuna kasangaulu ghalua (12) disaepolo. ");
INSERT INTO emi_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Elue talaua, laghe kasu vulila eBetani, me Iesu ang ghe maamaloo. ");
INSERT INTO emi_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Eghe taatara amasau lao sio me ghe tarala fig ateae uruenaaili ia. Me ghe lao sio tani taraia va arova righi uene. Me nau eteva ghe laa rekataa sio, ghe tarala va uruna nonga, poli karika ghe ghaa nauna tani kune. ");
INSERT INTO emi_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Vara me Iesu ghe uela tale ai eteae va, “Karika teva aue emene nama righi uem!” Me kapuna disaepolo atoa laghe nongoala. ");
INSERT INTO emi_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nau eteva laghe rekatala eJerusalem, Iesu ghe ssola tale ale manga ateva, me ghe tiuaala tani sungi veluvelu lo atoa laghe aaitauaa me laghe poppoli. Eghe sau etakila tevoo atoa uneira ila lo atoa laghe aaikolikoliaa viliki veu, me aitokatoka uneira lo atoa laghe aaitaraa valusu, ");
INSERT INTO emi_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","me karika poi ghe aalona va toa la sau longoti righi peiira eleka nongina ale manga ateva. ");
INSERT INTO emi_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Vara me eghe tiuaala tani apasunga tale taumattu ngatoa. “Karika am ghe kilala llo laghe pitila tale Uru ngai Manga ateva, ghe uela va, “‘Aleghi ale manga ateva aue la ghasea va ale ailooloo sae ia tale taumattu ngakapa atoa tale anua akapa atoa’? Me am, ngam gheeleiela ‘nongina va aleira ale niaisulia ia tau niainao atoa!’” ");
INSERT INTO emi_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Namu ngatoa ta pristi etoa me tau ngai aapasunga ngatoa tale inangari nipaopao laghe nongola voto oia, me ngila ghe paepae righi salana tani uvi emate Iesu, me laghe maamatautainia, ta poli taumattu ngakapa atoa laghe oouna tee inangarina. ");
INSERT INTO emi_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Elo alai tale ia o nau eteva, Iesu me kapuna disaepolo atoa laghe kasu vulila masaliki taatara ateae. ");
INSERT INTO emi_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Elue talaua poopooa, Iesu me kapuna disaepolo atoa laghe kasukasu elaolao, me laghe tarala fig ateae ta ang ghe mmatela. Oane me ia akapaaili ai eteae ghe mmatela. ");
INSERT INTO emi_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita ghe mene nnaa lao sio sa ateva Iesu ghe ppooainiela tale ai eteae. Ghe uela va, “Tisa, tarala, fig ateae ughele kasikienainiela ange mmatela!” ");
INSERT INTO emi_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iesu ghe liula etaira me ghe uela va, “Am aiesoaa ta God. ");
INSERT INTO emi_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Aghaaulia ngakoronna etaimim va, see arova eue tale motouru eteva o va, ‘Ukasu me ughoa katuu elamana,’ isaa o voto aue elutu etana, arova eaiesoaa tale urunguitanina ateva me karika eghaaghalua nannaane, voto o aue elutu. ");
INSERT INTO emi_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Liuna avalua o me aghaauliaa etaimim va, sa ateva am kolomia tale uneimim nilooloo sae, me am aiesoaa va angam ghaala, aue am ghaa me aue kaluimim. ");
INSERT INTO emi_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Me nau am tingina me am looloo sae, am kkaluaa sesa katoa la gheelei etaimim, me Tamaimim ateva epona liu aue ekkaluea tee gheeleiaaimim sesa.” ");
INSERT INTO emi_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Laghe kiriaa mae sio eJerusalem, me vara Iesu ghe kasukasu elome tale ale ngeleka etiulu tale ale manga ateva, me namuu ta pristi etoa me tau ngai aapasunga ngatoa tale inangari nipaopao me namu ngatoa laghe mae sio ta ngetana. ");
INSERT INTO emi_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Me laghe uela etana va, “See ghe tau aatu sio matuutuliena etam, me see ghe sungiola tani mae ghelei isaa oia voto?” ");
INSERT INTO emi_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Me Iesu ghe uela etaira va, “Akolomiem mua tale kateva nikokkolomi, me arova am liu emasinaia, aue aghauliaa etaimim va see ghe tau mae sio matuutuliena etaghi. ");
INSERT INTO emi_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Am liu etaghi va see ghe tau lao sio matuutuliena ta Jon me ghe aasuu taumattu: Vau ngepona ateva o nim taumattu?” ");
INSERT INTO emi_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Me ngeila ghe tingina aissakea va sa ateva la ghaulieinia etana, “Arova ita ue va, ‘Vau ngepona ateva,’ aue eue va, ‘Me vaalua me karika am ghe aaikaaiaa ta Jon?’ ");
INSERT INTO emi_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Me arova ita ue va, ‘Nim taumattu’...” (Laghe maamatauta taumattu ngatoa, poli taumattu ngakapa atoa laghe annaa va Jon propete ia.) ");
INSERT INTO emi_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Liuna avalua o laghe liula me laghe uela ta Iesu va, “Karika ami kilakila.” Me Iesu ghe uela etaira va, “Aghi tee, karika aue aghauliaa etaimim va see ghe tau mae sio matuutuliena etaghi.” ");
INSERT INTO emi_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iesu ghe tiuaala tani aippooaa tee taumattu ngatoa tale kiukiu niaimatoongana atoa va, “Kateva taumattu ghe pasala utani uaeni etingiu, me ghe iri taliaala valavala ateae, me ghe kaila aimonnaa uaeni eteva, me ghe atulula aitiketike ateva. Vara me ghe taue lao sio ta katoa tau ngeutana tani aitarainia, me ghe kasu emasaula. ");
INSERT INTO emi_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nau eteva utana atingiu ghe matuela, ghe suula kateva kapuna tau ngai uungu tani laa tara lo atoa laghe aaitaraa utana atingiu me aue ghe ghaa righi ue uaeni. ");
INSERT INTO emi_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Lo atoa laghe aaitaraa utana atingiu laghe llotiela, me laghe uvi saasakieiniela, me laghe sungi veluela, me karika ghe ghaala righi ue uaeni. ");
INSERT INTO emi_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Vara me ghe mene suula mene kateva kapuna tau ngai uungu tani mene lao etaira. Laghe mene lloti etokaiela, me laghe paru rriila uruna ateva, me laghe apalataiela. ");
INSERT INTO emi_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ghe mene suula mene kateva, lo ateva o tau ngai uungu laghe uvi emateala. Oroieili ila lo atoa ghe mene sungilala kateva kateva ghe laolao; katoa laghe nim uvilala, me katoa laghe uvi ematelala. ");
INSERT INTO emi_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Kateva nonga ia taumattu ghe tokala, natuna ia ghe tani aaielousieinia, ghe airuuruula tani sungia ta ghe ue va, ‘Aue la oneoneaa natughu eteva.’ ");
INSERT INTO emi_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Nau eteva lo atoa laghe aaitaraa utana atingiu laghe taraiela, laghe aippooa ngaitauaala elome etaira va, ‘Taumattu ngateva okae aue eghaa akapa llo oia. Ita uvi ematea, me ita ghaa utana atingiu me ekaluita ia.’ ");
INSERT INTO emi_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Laghe llotiela, me laghe uvi emateala, me laghe sau velue ghoala eleka tale utana atingiu. ");
INSERT INTO emi_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Sa ateva taumattu ngateva, umana ia utana atingiu, aue egheleia? Aue emae euvi ematela me emene tau lao utana atingiu ta katoa ppae. ");
INSERT INTO emi_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Koti karika am ghe ritila tale Uru ngai Manga ateva? Eue va, “‘Atu eteva tau ngai atulu ale atoa laghe ratiela ghe aitiutiula tale atu ekapa atoa tani suei ale ateva; ");
INSERT INTO emi_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Vau palepale ghe gheleila isaa o voto me taataraane masinaaili ta mataita.’” ");
INSERT INTO emi_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Namu ngatoa laghe nongola me laghe kilala va Iesu ghe aauliaa teeila tale kiukiu niaimatoonga. Laghe aloanna tani kuneia, me laghe nim maamatauta taumattu ngatoa, me laghe tau veluela, me laghe kasula. ");
INSERT INTO emi_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Laghe suula katoa tana Paresi me katoa tana kapuna Herot tani laa ghareaa Iesu va ghe ppooaa righi inangarina, me laghe ghaaia me laghe laa ghatinginaia tale niaisakei. ");
INSERT INTO emi_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nau laghe lao sio, laghe uela va, “Tisa, io nau ekapa atoa uaauliaa nonga voto koronna. Karika unannangaili saa llo taumattu ngatoa la annaa, me karika utaatara taumattu tale naanamungaaira me uunguaaira, me uaapasunga ngakoronna salane God. Vaalua? Masina tani taula takis ta Siisa? Ita taula, o karika ita mene taula?” ");
INSERT INTO emi_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Me ia ghe kilakilaaili va usimaghalue ila, me ghe uela etaira va, “Vaalua me am tootoongainaghi? Ghaa mae tivilau viliki veu me atara.” ");
INSERT INTO emi_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Laghe tau lao sio viliki veu etivilau etana me ghe uela etaira va, “See tootoona ateva me ararina ateae o?” Me laghe uela va, “Siisa.” ");
INSERT INTO emi_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Me Iesu ghe liula me ghe uela etaira va, “Am taula voto kanna Siisa ta Siisa, me voto kanna God ta God.” Me laghe soghiaala tani nongo llo ghe auliaala. ");
INSERT INTO emi_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadiusi etoa, karika la ghaaiesoaa tale nitotu tale nimate, katoa etaira laghe mae sio ta Iesu me laghe uela etana va, ");
INSERT INTO emi_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tisa! Moses ghe piti elokoila va arova taita ateva lailai ia emate me karika righi natuna, nengane ateva aue eghaa vausenna ateva ang ghe raue vuluela, me aue natuirarua aitiutiu eteva aliki, la nnainia va natuna ia tuena. ");
INSERT INTO emi_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tue me nenga ghaitu (7). Aitiutiu eteva ghe laila, me karika righi natuna me ghe matela. ");
INSERT INTO emi_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ghaluene ateva ghe ghaala vausenna ateva tuena, ghe raue vuluela. Me ie tee ghe mene matela nau karika righi natuna. Ase voto ateva o ghe mene lutula ta aiaakotonna ateva aliki. ");
INSERT INTO emi_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tue me nenga ghaitu laghe ghaala vause ateva, me karika righi natuira me laghe matela, me vause ateva ghe mate aruula. ");
INSERT INTO emi_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nau nitotu tale nimate, see aue evausenna ia vause ateva o, poli ila akapa laghe laila etana?” ");
INSERT INTO emi_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iesu ghe liula me ghe uela va, “Nannaaimim karika ghulughuluena, poli karika am kilakila Uru ngai Manga ateva me sarasarakaniaane God. ");
INSERT INTO emi_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nau God aue etotu taumattu matena, taita atoa me vause atoa karika aue la lai; aue la nongina ensolo atoa epona liu. ");
INSERT INTO emi_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Me tale nitotu ta taumattu matena, karika am ghe ritila tale unna vuku eteva Moses, tale kiukiu natu ai erighi, God ghe uela va, ‘Aghi kapuna Goto ieghi Abraham, Aisiki me Jekop.’ ");
INSERT INTO emi_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","God karika va kapuira Goto ia lo atoa taumattu matena ila, ta kapuira Goto ia lo atoa maulue ila. Am Sadiusi etoa, inangariimim nim kamena.” ");
INSERT INTO emi_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tau ngai aapasunga ngateva tale inangari nipaopao ghe usila tani nongo nau eteva Sadiusi etoa laghe sama teela Iesu. Ghe nongola va Iesu ghe liu emasinaailiila inangariira Sadiusi etoa. Liuna avalua o me ghe kolomila Iesu tale nikokkolomi eteva va, “Sa ateva inangari nipaopao mata ngemua ia me namuu ia tale isaa akapa inangari nipaopao?” ");
INSERT INTO emi_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iesu ghe liula me ghe uela va, “Mata ngemua ateva voto va, ‘Israeli etoa, am nongo, Vau palepale ateva kapuimim ia, ia nonga vau tuungi ia. ");
INSERT INTO emi_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Uaielousiaa Vaum ateva kapum Goto ia tale urunguitanim ateva, me tale maamauluaam, me tale nannaam, me tale sarasarakaniaam akapa.’ ");
INSERT INTO emi_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Me aiaaghaluena ateva inangari nipaopao eue va, ‘Uaielousiaa taumattu ngateva kalakalangina ia etam, nongina uaaielousieinio.’ Inangari nipaopao alua o, namuu ilalua tale isaa akapa inangari nipaopao.” ");
INSERT INTO emi_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Me tau ngai aapasunga ngateva tale inangari nipaopao ghe uela va, “Masinaaili, tisa. Koronna llo inangari nguauliaala va Vau eteva epona liu ia nonga Vau palepale ia, karika mene teva nongina ia. ");
INSERT INTO emi_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Me ita aielousiaa Vau ngepona liu eteva tale urunguitaniita, me tale nannaaita, me tale sarasarakaniaaita, me ita aielousiaa taumattu ngatoa kalakalangina ila etaita, nongina ita aaielousieinita. Poli masina tani aimuli tee inangari nipaopao alua o, me tani ghelei asease aiaavusuvusuena.” ");
INSERT INTO emi_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iesu ghe nongo kilala alomasaanganiaane taumattu ngateva o, me ghe uela etana va, “Io karika masau io tale ararimangalina ateva God.” Ghe ruu evaluela o me ila akapa laghe matautula tani kolomi Iesu tale mene righi nikokkolomi. ");
INSERT INTO emi_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesu ghe tokatoka elome tale ale manga ateva me ghe aapasunga voto ta taumattu ngatoa. Ghe ue va, “Vaalua me tau ngai aapasunga ngatoa tale inangari nipaopao la uue va Mesaea tuvuna ia Deivit? ");
INSERT INTO emi_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Me Spirit Manga ateva ghe tokala ta Deivit, me Deivit ghe uela va, “‘Vau eteva ghe uela ta kapughu vau eteva va, “Toka siola tale pai muenna ativilau lomose ta aghatoka sio lo atoa la sessa teeio euu, me uatingina saoaa kkem etaira.”’ ");
INSERT INTO emi_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deivit ghe uela va Mesaea vauna ia. Vaalua me ghele mene tuvuna ia?” Oroiannaaili taumattu laghe nongonongoa me laghe maamasiangaili llo ghe aauliaa. ");
INSERT INTO emi_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nau Iesu ghe mene aapasunga, ghe uela va, “Am taatara amasina tale gheegheleiaaira, tau ngai aapasunga ngatoa tale inangari nipaopao. La ghaloanna nonga tani asae masi ghinna nongina namu ngatoa, me tani ghaa nioneoneaa tale tummatavanga. ");
INSERT INTO emi_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Me ila la ghaloanna tani toka tale masi aitokatoka uneira namu ngatoa tale ale nivelu eitaua ngatoa, me tale ninamanama atoa. ");
INSERT INTO emi_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tisa ngatoa la kamekame vause atoa raue vulu ila me la ghainao peiira, me la ghaitaratarainila tani ghelei aluse nilooloo sae atoa. Nau niaisakei, aue la ghaa nimmarikana namungaili.” ");
INSERT INTO emi_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesu ghe ssola tale ale manga ateva me ghe toka siola ta pai kativilau tale voto ateva la kaakaai viliki veu, me ghe taatara taumattu ngatoa laghe kaakaai kaluira viliki veu. Oroi tau peipeiena atoa laghe kaakaai oroieili kaluira viliki veu. ");
INSERT INTO emi_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Vara me vause raue vulu eteva, karika tau peipeiena ia, ghe kaaila tapiri viliki veu eluevilau. ");
INSERT INTO emi_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iesu ghe kolola kapuna disaepolo atoa me ghe uela etaira va, “Aghaaulia ngakoronna etaimim va ia o vause ateva ange kaaila oroi viliki veu tale aikaai viliki veu eteva, me katoa la kaaila malaki. ");
INSERT INTO emi_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ta ila akapaaili, la kaaila kasina nonga uneira viliki veu, me oroi isaa elo ale, me ia o vause ateva etau ekapa lao sio unna viliki veu tale aikaai viliki veu eteva, karika righi viliki veu tani mene poli righi peina.” ");
INSERT INTO emi_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nau Iesu ghe kupi ghoala tale ale manga ateva, kateva tana kapuna disaepolo ghe uela etana va, “Tisa, tarala masi atu etoa namungaili ila, me masi ale atoa.” ");
INSERT INTO emi_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iesu ghe liula me ghe uela va, “Utaatara kinatama ale okae? Karika teva atu aue etoka saoaa ta mene kateva. Aue taumattu ngatoa la puli reerekata isaa akapaaili oia voto.” ");
INSERT INTO emi_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nau eteva Iesu ghe nim tokatoka poi sio tale motouru eteva eOliv tale pai kativilau tale ale manga ateva, me Pita, Jeimis, Jon me Andru laghe mae sio tani kolomi einaoa, ");
INSERT INTO emi_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","laghe uela va, “Auliaala etaimami, isaa o voto lovisaa elutu? Me sa aimatootoongana aue elutu, me auena voto o emae?” ");
INSERT INTO emi_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iesu ghe uela etaira va, “Am paniem, teva taumattu erau kameam. ");
INSERT INTO emi_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Oroi ila lo atoa aue la mae tale ararighi eteae, me aue la ue va, ‘Aghi oia Mesaea ngateva,’ me aue la kame oroieili taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Me nau am nongo niaiuvii me kiukiuna, am rau mene matautu. Isaa o voto aue elutu, me airuuruu tale kosa ateva karika ghe mae. ");
INSERT INTO emi_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Patunganua atoa aue la ghaiuvieinila; me ararimangali etoa aue la ghaiuvieinila tee. Aue rukeruke atoa la ruke kasina voto tale kosa ateva me maloo atoa aue la lutu tee. Isaa o voto aue enim aitiutiu tale nimmarikana, nongina mmarikana eghaaghaa kinna ateva aliki eteva nau elutulutu. ");
INSERT INTO emi_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Am oia am anguu taatara, ta isaa toko voto aue elutu. Am aue la kuneiem me la laoainiem tale liu niaisakei. Aue la mae la uviem tale ale nivelu eitauaa, me aue la ghatinginaiem emua ta gavana ngatoa me kingi etoa poli ararighi eteae, me aue am rooroo tani auliaa masi kiukiu tee etaira. ");
INSERT INTO emi_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Me mata ngemua ateva voto, masi kiukiu oia etani lao akapa see tale patunganua akapa atoa. ");
INSERT INTO emi_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nau eteva la kuneiem me la laoainiem tale liu niaisakei, karika am mene matautu, me am annaa va sa ateva aue am aulieinia; ia o nau eteva, am ppooaa voto God aue etau aatu tale nannaaimim. Poli inangari am ppooaa karika va inangariimim; ta inangarina Spirit Manga ateva. ");
INSERT INTO emi_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Taumattu ngatoa aue la tau velu tueira me nengaira atoa ta lo atoa aue la uvi ematela, me tamaira atoa aue la ghelei tee ta natuira atoa. Aliki etoa tee aue la ssa tee tamaira me kinaira atoa, me aue la uvi ematela. ");
INSERT INTO emi_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Taumattu ngakapa atoa aue la ssa teeiem poli ararighi eteae. Me see etingina akorokorongana tale unna niaikaaiaa tale airuuruu, maamauluaane aue esaanga. ");
INSERT INTO emi_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nau am tara voto sesaaili elutu tale voto karika liuna tani lutu me eghelei taumattu ngatoa la kasu me ale manga ateva aue enim toka, (lo ateva taumattu aue etara kila aue ealomasaanga) lo atoa elome eJiudia am ilou sae tale motouru. ");
INSERT INTO emi_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Me karika teva etokatoka eleka tale alena ateva emene kupi sso elo ale me esso ghaa righi voto. ");
INSERT INTO emi_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Karika teva eutana emene kiri lao tanganuena me elaa ghaa teva unna aiaasae ngeleka. ");
INSERT INTO emi_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Alousiusi ta lo atoa la suusunuku me lo atoa la sussu tale isaa o nau! ");
INSERT INTO emi_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Am looloo sae va voto o erau mene lutu tale nau kkaili, ");
INSERT INTO emi_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","poli voto sesa tale nau o, aue esesaaili tale isaa too nau ang ghe lao sio. Tale kosa ateva oia, karika aue emene righi ase nau evalua o, nongina aitiutiu nau God ghe gheleila kosa ateva me nau ghaine, me auena karika aue emene righi voto avalua o elutu. ");
INSERT INTO emi_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Arova Vau palepale ateva karika ghe nnaala tani atukuna isaa o sesa nau, taumattu ngakapa atoa aue la ghele raua, me poli enannangaili isaa o taumattu ghe suitoongaala, liuna avalua o me aue eatukuna isaa o nau. ");
INSERT INTO emi_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Aue lo ateva o nau arova toa la ue etaimim va, ‘Tarala, Mesaea ngateva toko!’ me mene, ‘Tarala, ie too!’ karika am mene aikaaiaa inangariira. ");
INSERT INTO emi_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ta poli katoa taumattu aue la mae me aue la kame va, ‘Aghi Mesaea ngateva,’ me mene katoa aue la kame va, ‘Aghi propete ieghi’ aue la mae la ghelei aimatootoongana me voto tani apasunga sarasarakaniaaira tani kame taumattu Vau palepale ghe suitoongaala, kotiva isaa o voto aue eroo. ");
INSERT INTO emi_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Liuna avalua o me aghaauliaa va am taatara amasina, voto akapa oia ngaghe aulia ngamuemue alokoila etaimim, me auena elutu. ");
INSERT INTO emi_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Tale isaa o nau me sesa nau auena, “‘sinaka ateva aue esaurrom, me ulana ateva karika aue emallanga, ");
INSERT INTO emi_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","me katto atoa elomarase aue la katuu, me voto atoa korokorongana ila elomarase aue la ghaisiisia.’ ");
INSERT INTO emi_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Me aue la tara Natuna ateva Taumattu ngateva aue emae tale urukookoo. Emae tee korokoronganiaane me kinatama mallangina. ");
INSERT INTO emi_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Me aue esungi ensolo atoa la lao tale ghaata aighoughou tale kosa ateva tani kolo aitauaa lo atoa ghe suitoongainilala, tale kosa akapa ateva. ");
INSERT INTO emi_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Am rooroo tani ghaa alomasaanga tale kiukiu niaimatoonga tale fig ateae. Nau eteva am tara ai eteae ange tulutulu, am kila va masi nau tale sinaka ateva ange kalakalaala. ");
INSERT INTO emi_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Liuna avalua o, nau eteva am tara isaa o voto, aue am kila va ange kalakalanginala, tapaa ngatamana. ");
INSERT INTO emi_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Aghaaulia ngakoronna etaimim va lo ateva oia vituu karika poi aue ekapa me isaa o voto aue elutu. ");
INSERT INTO emi_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Elomarase me kosa ateva oia aue ekapa me inangarighi karika poi aue ekapa. ");
INSERT INTO emi_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Me ia o nau eteva o aoa ngateva, karika teva ekilakilaia. Ensolo ngepona liu tee atoa karika la kilakila, me Natuna tee. Nim Tamaghi nonga ekilakila. ");
INSERT INTO emi_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Am anguu taatara me am aimonomonosiaa poli am tam kilakila va saa nau eteva isaa o voto aue emae. ");
INSERT INTO emi_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nonginaaili taumattu ngateva ang ghe kasukasu vuli tanganuena, me ghe taula niuungu ta kapuna tau ngai nongonongo anna atoa. Ghe aikoitaala niuungu ta kateva kateva etaira, me ghe uela ta lo ateva ghe aaitoiaa atamana ateae va eanguu taatara. ");
INSERT INTO emi_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Mausina avalua o me am anguu taatara atoka poli karika am kilakila va lovisaa tau ngalena emene kiriaa: aue elo alai, o eleivoo, o elopai, o elue talaua. ");
INSERT INTO emi_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Erau rekata parasi va etaraiem ta am aseasekanua. ");
INSERT INTO emi_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Voto aghaauliaa etaimim, aghaauliaa tee ta taumattu ngakapa atoa va, ‘Am anguu taatara atoka!’” ");
INSERT INTO emi_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kasi ghalua nau me auena niaimonomonosiaa tale nivelu eitaua ngateae ta Pasova ngateva me nivelu eitaua ngateae tale verete karika righi isti etana ghe mae, me namu ngatoa ta pristi etoa me tau ngai aapasunga ngatoa tale inangari nipaopao ngila ghe paepae righi salana tani kune aisulia Iesu me la uvi ematea. ");
INSERT INTO emi_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Laghe uela va, “Ita rau mene ghelei tale nau nivelu eitauaa, ta taumattu ngatoa la rau tiuaa teae niaiuvii.” ");
INSERT INTO emi_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iesu ghe tokatoka eBetani tale alena ateva Saemon emua arau anna tasussuku eteva. Nau Iesu ang ghe namanama, me vause ateva ghe sso tee mae aikakkaai eteva, laghe gheleiela tale atu eteva alabasta ia, pasu ia tale aiaaoo masi ngusungusuaane laghe gheleiela nonga tale oane natu ai erighi la koloa va nadi ia, aipolina namungaili. Ghe ghelei polakila aikakkaai eteva me ghe kaola aiaavusuvusuena ateva ta uruna Iesu. ");
INSERT INTO emi_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Katoa taumattu laghe tokatoka ghe sessailala me laghe aippooaa elome etaira va, “Vaalua me eruuruungia aiaaoo ateva masi ngusungusuaane? ");
INSERT INTO emi_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","La rooroo tani polia ta kotolu ai (300) silva koen, me viliki veu la tau lao ta taumattu karika righi peiira.” Me laghe kisokisoia. ");
INSERT INTO emi_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Me Iesu ghe uela va, “Ratiela! Vaalua me am poppooaa teeia? Ange gheleila masi voto etaghi. ");
INSERT INTO emi_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Llo taumattu karika peiira la tokatoka teeiem nau ekapa atoa. Am rooroo tani sausila nau eteva am aloanna. Aghi karika aue atoka teeiem nau ekapa atoa. ");
INSERT INTO emi_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nge gheleila voto erooroo tani ghelei; ange kaola aiaaoo masi ngusungusuaane ta vilikighi tani aimonomonosiaa ngamuemua tale nikkaiaa. ");
INSERT INTO emi_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Aghaaulia ngakoronna va eaa aue la ppooaa masi kiukiu eteva tale kosa ateva, aue la ghauliaa tee masi gheeleiaane vause ateva oia, tani nnainia.” ");
INSERT INTO emi_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Me Jiudas Iskariot, kateva ta kasangaulu ghalua (12) disaepolo, ghe lao sio ta namu ngatoa ta pristi etoa tani taula Iesu ta nimaira. ");
INSERT INTO emi_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Laghe nongo avaluela o me laghe masimasila, me laghe gheleila inangari nialokoi va aue la taula righi viliki veu. Me Jiudas ghe tiuaala tani pae salana tani tau lao Iesu ta ngetaira. ");
INSERT INTO emi_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tale aitiutiu eteva nau tale nivelu eitauaa tale verete karika righi isti etana, nau eteva laghe uviuvi emate Pasova sipsipi eteva, kapuna disaepolo atoa Iesu laghe mae sio me laghe uela etana va, “Eaa uanna va ami laa ghaimonomonosiaa voto me ughelei ninamanama ateae ta Pasova?” ");
INSERT INTO emi_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Liuna avalua o me ghe suula ghalua tani kapuna disaepolo. Ghe uela etairarua va, “Amalu lao tale masaliki taatara ateae, me nau amalu tara taumattu ngateva, esuusunuki aikaai manu eteva, amalu usia. ");
INSERT INTO emi_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Lo ateva ale elaa kupi sso etana, amalu ue ta tau ngalena va, ‘Tisa euela va: Eaa ia lo atiulu rum aue atoka etana, me aue anama Pasova ngateva tee kapughu disaepolo atoa?’ ");
INSERT INTO emi_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Me aue eapasunga rum atiulu epona namuu ia, me ngeila aimonomonosiaa ngatokaiela. Amalu aimonomonosiaa aneita inana tale ia o rum atiulu.” ");
INSERT INTO emi_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Disaepolo alua lalu ghe lao sio tale masaliki taatara ateae, me lalu ghe saopi ekapala voto Iesu ghe auliaala. Me lalu ghe aipanipaniaala inana tale Pasova ngateva. ");
INSERT INTO emi_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Vara elo alai me Iesu me kasangaulu ghalua disaepolo laghe rekatala. ");
INSERT INTO emi_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Laghe tiuaala tani namanama, me Iesu ghe uela etaira va, “Aghaaulia ngakoronna etaimim va kateva etaimim aue etaueghi lao ta nimaira tau ngai ssateeghi etoa. Taumattu ngateva ia oia ange namanama teeieghi.” ");
INSERT INTO emi_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Disaepolo atoa laghe tiuaala tani alousiusi, me kateva kateva etaira ghe kokkolomi Iesu va, “Koti aghi, no?” ");
INSERT INTO emi_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ghe liula me ghe uela va, “Kateva ta kasangaulu ghalua kapughu disaepolo, ita namanama aitauaa. ");
INSERT INTO emi_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Poli Natuna ateva Taumattu ngateva aue elao nongina Uru ngai Manga ateva eaauliaa va emate. Me alousiusi tale taumattu ngateva etautau lao Natuna ateva Taumattu ngateva ta tau ngai ssateena atoa. Aue ghele masina etana arova ghe tam lutula.” ");
INSERT INTO emi_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Laghe namanama, me Iesu ghe ghaala verete ateva me ghe kaili emasina saela, me ghe piriela me ghe taue lao sio ta disaepolo atoa, me ghe uela va, “Am ghaala. Isaa oia verete malataughu.” ");
INSERT INTO emi_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Me ghe mene ghaala kapa uaeni eteva, me ghe kaili emasina saela ta God, me ghe taue lao sio etaira, me ila akapa laghe ropila tale ia o kapa uaeni eteva. ");
INSERT INTO emi_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Me ghe uela etaira va, “Uaeni eteva oia raeghi ia tani ghelei ouna inangari niaippooa ngaitauaa me aue eakalaa tani sausi oroi taumattu. ");
INSERT INTO emi_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Aghaaulia ngakoronna etaimim va karika aue amene ropi uaeni lomosi ta aropi ouna uaeni tale ararimangalina ateva God.” ");
INSERT INTO emi_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Me laghe ueila kkinari eteae, me laghe kupi ghoala tale masaliki taatara ateae me laghe saela tale motouru eteva eOliv. ");
INSERT INTO emi_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iesu ghe uela ta kapuna disaepolo atoa va, “Am akapaaili aue am ilou vulieghi, nongina Uru ngai Manga ateva eaauliaa. Eue va, ‘Aue auvi emate tau ngai toi sipsipi eteva, me sipsipi etoa aue la ilou reerekataa.’ ");
INSERT INTO emi_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Me nau atotu tale nimate aue amuemue lao eGalilii me aue am laa taraieghi okae.” ");
INSERT INTO emi_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Me Pita ghe uela va, “Arova ila akapa la ilou vulio, aghi karika poi arooroo tani ilou vulio.” ");
INSERT INTO emi_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iesu ghe liula me ghe uela etana va, “Aghaaulia ngakoronna etam va, ia o voo ngateva auena taita ateva paolo eaangari ghaluaata, aue uue akasina kotoluaata va karika ukilakilaieghi.” ");
INSERT INTO emi_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita ghe aikaaia ngakoronganaaili liuna avalua o me ghe uela va, “Aue amate teeio, me karika arooroo tani ue va karika akilakilaio.” Ila akapa inangariira nongina Pita. ");
INSERT INTO emi_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Iesu me kapuna disaepolo atoa laghe lao sio tale voto ateva la kolokolo Getsemeni etana, me Iesu ghe uela ta kapuna disaepolo atoa va, “Am toka oia, me alaa looloo sae.” ");
INSERT INTO emi_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Me ghe kolola Pita, Jeimis me Jon va la usia, me nannaane ghe tiuaala tani maate, me ang ghe ateateaa saasakiaa. ");
INSERT INTO emi_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Me ghe uela etairatolu va, “Maamauluaaghi ange sessaaili tee nialousiusi eteva, me egheleieghi arova amate. Am toka oia me am anguu taatara.” ");
INSERT INTO emi_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ghe nim kasu tee lao sio, me ghe tau siola paane, me ang ghe looloo sae va, arova erooroo, isaa o sesa nau eghele kkelia. ");
INSERT INTO emi_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Me ghe uela va, “Abba, Tamaghi, isaa akapa voto urooroo tani ghelei. Ughaa velu kapa nimmarikana ateva etaghi, me urau mene ghelei tale aloaloannaaghi ta ughelei tale aloaloannaam.” ");
INSERT INTO emi_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ghe kiriaa lao sio ta disaepolo kotolu me ghe tarailotolla ta latolu ghe aseasekanua, me ghe uela ta Pita va, “Saemon, uaseasekanua? Karika urooroo tani anguu ta nim teva aoa? ");
INSERT INTO emi_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Am anguu taatara me am looloo sae ta God va karika am mene sso tale nitootoonga. Nannaimim eanna tani ghelei voto, me vilikiimim mangoona.” ");
INSERT INTO emi_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Me ghe mene kasula tani looloo sae nongina ghe ghelei muela. ");
INSERT INTO emi_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Vara ghe mene kiriaa mae sio etairotolu me ghe mene saopilotolla ta latolu ghe aseasekanua, poli matairotolu ghe maamaateaili. Me karika latolu ghe kilakila sa ateva tani aulieinia. ");
INSERT INTO emi_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ghe kiriaa mae sio aiaakotonna me ghe uela etairotolu va, “Amotolu aseasekanua me amotolu maamatua ngatoka, va? Ange roola! Nau eteva ange rekatala. Am tarala, Natuna ateva Taumattu ngateva ngeila tautauela ta nimaira sesa taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Amotolu totula me ita kasu! Lo ateva etautaueghi lao ta tau ngai ssateeieghi etoa ange reerekata.” ");
INSERT INTO emi_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nau Iesu ghe samasama nonga me Jiudas, kateva ta kasangaulu ghalua (12) disaepolo, ghe rekata teela taumattu ngatoa. Laghe posoposo baenata atoa me tuku ngai etoa. Namu ngatoa ta pristi etoa, me tau ngai aapasunga ngatoa tale inangari nipaopao, me namu ngatoa laghe sungilala. ");
INSERT INTO emi_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Lo ateva ghe taue lao sio etaira ghe auliaala aimatootoongana ateva va, “Lo ateva taumattu angusua, ia o lo ateva am kuneia me am kasueinia.” ");
INSERT INTO emi_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nau ghe rekatala, ghe lao sio arau ta Iesu me ghe uela va, “Rabae!” me ghe ngusuela. ");
INSERT INTO emi_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Laghe kuneiela me laghe poso atinginaiela. ");
INSERT INTO emi_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kateva tana taumattu ghe tiitingina ghe ghaala iemana baenata ateva, me ghe sai patela talingana ativilau kateva kapuna tau ngai nongonongo anna namu ngateva ta pristi etoa. ");
INSERT INTO emi_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iesu ghe liula me ghe uela etaira va, “Am annaa va aghi tau niainao aghi, va am maeaa sio iemaimim baenata me tuku ngai tani ghaaieghi? ");
INSERT INTO emi_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nau etoa aghe tokatoka teeiem tale ale manga tani apasunga, me karika am ghe kunekuneieghi. Me masina, inangari tale Uru ngai Manga ateva ghaine elutu ekoronna.” ");
INSERT INTO emi_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Me ila akapa disaepolo atoa laghe aitiuaala, me laghe ilou vuliela. ");
INSERT INTO emi_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kateva aliki taita ghe usiusia, ghe aaitiitiiaa nonga kalio atiulu usousoana ia, nau laghe kune teeiela ");
INSERT INTO emi_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ghe vella kaliona atiulu usousoana ia me ghe nim iloula karika kaliona. ");
INSERT INTO emi_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Laghe ghaala Iesu me laghe laoainie sio ta namu ngateva ta pristi etoa. Namu ngatoa ta pristi etoa, namu ngatoa, me tau ngai aapasunga ngatoa tale inangari nipaopao, laghe velu eitauaala. ");
INSERT INTO emi_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita ghe aaimuli me karika ghe akalakalaa ta Iesu. Vara me ghe ssola tale valavala ateae ghe taataliaa alena ateva namu ngateva tale pristi etoa. Ghe toka tee siola kapuira tau ngai toitoi etoa pristi etoa tale sama kura ateae me ghe maamaruu. ");
INSERT INTO emi_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Namu ngatoa ta pristi etoa me kansolo atoa laghe tootoongala tani pae teva taumattu ghe auliaa righi sesa gheeleiaane Iesu me laghe uvi ematea, me karika laghe tarala teva. ");
INSERT INTO emi_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Katoa taumattu laghe aauliaa inangari kamena tee Iesu, me inangariira laghe poppooaa karika ghe laolao aitauaa. ");
INSERT INTO emi_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Vara me katoa etaira laghe tinginala me laghe aikamea teela Iesu tani ue va, ");
INSERT INTO emi_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ami ghe nongola ta ghe uela va, ‘Aghi aue arruti velu ale manga ateva taumattu ngatoa laghe atuluela ta nimaira, me elome tale kotolu nau aue aghatulu mene kateva, karika taumattu aue atulua ta nimaira.’” ");
INSERT INTO emi_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Me isaa o tee inangari laghe gheleila ghe aikasakasaliaala me ghe aitiuaala. ");
INSERT INTO emi_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Vara me namu ngateva ta pristi etoa ghe tinginala emua etaira me ghe kolomila Iesu va, “Karika aue uliu inangariira? Vaalua tale inangari la ghaauliaa teeio?” ");
INSERT INTO emi_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Me Iesu ghe nim maamatuaa tingina me karika poi ghe liula inangariira. Me namu ngateva ta pristi etoa ghe mene kolomiela va, “Koronna va io Mesaea ngateva, natuna io Goto ateva taumattu ngatoa la tautau sae niarangise etana?” ");
INSERT INTO emi_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iesu ghe liula me ghe uela va, “Ue, aghi! Aue am tara Natuna ateva Taumattu ngateva ta etoka sio tale pai muenna ativilau ta lo ateva sarasarakana ia, me esio tale karaane epona liu.” ");
INSERT INTO emi_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Namu ngateva ta pristi etoa ghe rasila ghinnanina, me ghe uela va, “Karika ita mene aloanna mene righi taumattu tani auliaa mene righi inangari. ");
INSERT INTO emi_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ngam nongola ange ghaala liuna ateva God. Sa ateva am aloanna va ita gheleia etana?” Laghe uela va, “Ange gheleila ssavoto, ita uvi ematea.” ");
INSERT INTO emi_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Me katoa etaira laghe tiuaala tani kanusuia; laghe iri rungaala matane tale kalio, me laghe tuutumaria ta nimaira, me laghe ue va, “Arova propete io, uauliaa va see ange uviuvio!” Me lo atoa la ghaitaraa ale manga ateva laghe ghaaiela me laghe tiuaala tani posalaia. ");
INSERT INTO emi_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita ghe tokatoka euu, elome tale valavala ateae, me kateva vause kapuna tau ngai uungu ia namu ngateva ta pristi etoa ghe mae sio etana. ");
INSERT INTO emi_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nau eteva ghe tarala Pita ta ghe maamaruu, ghe lao akalakalangina sio me ghe taatara lao sio etana me ghe uela va, “Io tee ughe kasukasu tee Iesu aNasareti ia.” ");
INSERT INTO emi_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pita ghe uela va, “Karika poi akilakila isaa ona inangari uaauliaa.” Me ghe kasula me ghe kupi ghoala tale atamana ateae. Vara me taita paolo ateva ghe aangarila. ");
INSERT INTO emi_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Me ia o vause ateva tau ngai uungu ia ghe mene taraiela me ghe uela ta lo atoa laghe tiitingina teeia va, “Kateva tee o.” ");
INSERT INTO emi_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Me Pita ghe mene uela va, “Karika.” Karika masau me lo atoa laghe tiitingina kalakalaa laghe uela ta Pita va, “Koronna io kateva etaira, poli io aGalilii io.” ");
INSERT INTO emi_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Me Pita ghe aaulia ngakorokorongana va, “Koronnaaili karika akilakila taumattu ngateva ona am aaulieinia. Arova anim kamekame, God aue eghelei righi voto sesa etaghi.” ");
INSERT INTO emi_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Vara me taita paolo ateva ghe mene angari eghaluenela, me Pita ghe annaala inangarina Iesu ghe uela va, “Auena paolo taita ateva eaangari ghaluaata aue uue akasina kotoluaata va karika ukilakilaieghi.” Me ghe ngala alousiusieiliila. ");
INSERT INTO emi_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Elue talaua poopooa, namu ngatoa ta pristi etoa, namu ngatoa, me tau ngai aapasunga ngatoa tale inangari nipaopao, laghe velu eitauaala me laghe mae aitauaa sio nonga tale kateva ninannaa. Laghe irila Iesu, me laghe kasueiniela tani laoainia ta Paelat. ");
INSERT INTO emi_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Paelat ghe kolomiela va, “Io kingi io ta aJiu etoa?” Me Iesu ghe uela va, “Ue, nongina uaauliaa.” ");
INSERT INTO emi_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Me namu ngatoa ta pristi etoa laghe ppooaala ta Paelat oroi voto karika masina ta Iesu. ");
INSERT INTO emi_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Me Paelat ghe mene kolomiela va, “Karika aue uliu? Tarala, oroi inangari ngeila auliaa teeio.” ");
INSERT INTO emi_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Me Iesu karika ghe liula inangarina, me Paelat ghe soghiaala gheeleiaane. ");
INSERT INTO emi_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Paelat ghe gheelei kateva ase voto nau ekapa atoa nau Pasova ngateva. Ghe tautau velu lo ateva taumattu, taumattu ngatoa la ghanna va ekupi ghoa tale ale mata voovoo. ");
INSERT INTO emi_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Taumattu ngateva, ararina ateae ta Barabas, ghe tokatoka tale ale mata voovoo, ia me mene katoa taumattu, poli laghe aiuvii teela gavmani me laghe uvi ematela katoa tana taumattu. ");
INSERT INTO emi_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Taumattu ngatoa laghe lao sio ta Paelat me laghe uela etana va eghelei voto nongina egheelei. ");
INSERT INTO emi_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Paelat ghe kolomilala va, “Am anna va atau velu kapuira kingi eteva aJiu etoa?” ");
INSERT INTO emi_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Poli Paelat ghe kilakila va namu ngatoa ta pristi etoa laghe sessaila ta Iesu poli taumattu ngakapa atoa laghe maamasiaa Iesu, liuna avalua o me laghe maeainie sio tale liu niaisakei. ");
INSERT INTO emi_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Namuu ta pristi etoa laghe suusulungi taumattu tani ue sae ta Paelat va erau mene tau velu Iesu, ta la ghanna va etau velu Barabas. ");
INSERT INTO emi_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Me Paelat ghe mene kolomilala va, “Sa ateva am anna va agheleia ta lo ateva am ue va kapuira kingi ia aJiu etoa?” ");
INSERT INTO emi_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Laghe ovaova atingina tani ue sae va, “Uavukalaie sae tale aikotoo!” ");
INSERT INTO emi_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Paelat ghe kolomilala va, “Poli sa? Sa ateva voto sesa ghe gheleila?” Me laghe mene ovaova anamuu tee lao sio tani ue va, “Avukalaie saela tale aikotoo!” ");
INSERT INTO emi_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Poli Paelat ghe aanna tani ghelei emasimasi taumattu ngatoa, liuna avalua o me ghe tau vella Barabas, me ghe taula Iesu ta soldia ngatoa, me laghe uetaiela mua me ghe vira mene tauela va la ghavukalaie sae tale aikotoo. ");
INSERT INTO emi_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Soldia ngatoa laghe ssoaala Iesu tale tanganuena Gavana ngateva, la kolokoloa va Praetorium ateva, me laghe kolo aitauaala soldia ngatoa me laghe mae akapa sio. ");
INSERT INTO emi_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Laghe asaela aiaasae ateva ghueghuenna ia ta Iesu me laghe navitaala kou nguru eteva tale uasa ateva rorroana ia, me laghe atokaie saela ta uruna Iesu. ");
INSERT INTO emi_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Me laghe uue etana va, “Ei, kapuira kingi eteva aJiu etoa!” ");
INSERT INTO emi_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Me laghe parula uruna ateva tale ai eteae, me laghe kanusuiela, me kateva kateva etaira ghe suusuuiaa ta liue kkena Iesu tani tau lao ninamu ngateae etana. ");
INSERT INTO emi_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Laghe ruu ekapala tani attara ta Iesu, me laghe ghaa vella aiaasae ateva ghueghuenna ia laghe asae tau lao sio etana, me laghe asae taula ghinnanina, me laghe ghaaie lao sio tani laa avukalaie sae tale aikotoo. ");
INSERT INTO emi_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Saemon atala nge Saerini ia, natuna ta Aleksanda me Rufus, ghe rekata mae sio me ghe aloanna tani kupi sso, me soldia ngatoa laghe aeala me laghe sungiela va esau aikotoo ateva unna ia Iesu. ");
INSERT INTO emi_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Laghe ghaala Iesu me laghe laoainie sio tale voto ateva ararina ateae ta Golgota, malloeana va “Voto ateva arova Riu uru taumattu ngateva”. ");
INSERT INTO emi_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Laghe tau lao sio uaeni laghe kaai teela murr ta Iesu, me ghe tam aloannala tani ropi. ");
INSERT INTO emi_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Me laghe avukala saela Iesu tale aikotoo, me laghe tiuaala tani anamisi tani aikoita ghinnanina. ");
INSERT INTO emi_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ta 9 kilok elue talaua laghe avukala saela Iesu tale aikotoo. ");
INSERT INTO emi_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Me laghe pitila inangari me laghe avukala tee saela. Laghe pitila laghe uela va, “Ierai oia kapuira Kingi ia aJiu etoa.” ");
INSERT INTO emi_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Laghe avukala tee saela taita alua lalu ghe aaiuvii me lalu ghe ghaaghaa peiira taumattu ngatoa, kateva ta pai muenna ativilau, me kateva ta pai uaise ativilau. ");
INSERT INTO emi_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Taumattu ngatoa laghe kasukasu tapaa salana laghe aauliaa teeia inangari karika masina. Laghe samasama ringaringa me laghe uela va, “Ei! Io oia ughe uela va urooroo tani rruti ale manga ateva me umene atulua ta kotolu nonga nau, ");
INSERT INTO emi_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","erooroo va ghaine uasaangio me ukkure vulu sio aikotoo ateva?” ");
INSERT INTO emi_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Namu ngatoa ta pristi etoa me tau ngai aapasunga ngatoa tale inangari nipaopao laghe aamammarasaia tani ue elome etaira va, “Ghe asaangi katoa, me karika erooroo tani asaangia! ");
INSERT INTO emi_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Arova Mesaea ia, kapuira kingi ia aIsraeli etoa, ghaine etani kkure vulu sio aikotoo ateva, me aue ita aiesoaa etana nau ita tara.” Tau niainao me tau niaiuvii tee alua, lalu ghe aauliaa teeia inangari. ");
INSERT INTO emi_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tale pai ngelo sinaka ativilau me saurrom ateva ghe mae sio, ghe akoula kosa ateva ghe roola kotolu aoa. ");
INSERT INTO emi_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Me ta 3 kilok elo alai Iesu ghe sama anamungailiila me ghe uela va, “Eloi, Eloi, lama sabaktani?” (malloeanina va, “Kapughu Goto ateva, Kapughu Goto ateva, vaalua me angu tau velueghila?”) ");
INSERT INTO emi_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nau katoa taumattu laghe tiitingina akalakalangina laghe nongola isaa o inangari, laghe uela va, “Am nongola, ekolokolo Elaija.” ");
INSERT INTO emi_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Me kateva taumattu ghe iloula tani laa asuu tuku spans ateva tale uaeni kaakaalina, me ghe apasapasaiela tale ai eteae, me ghe taue saela va Iesu ghe mmua. Ghe uela va, “Ita toitoi mua, me ita tara va kotiva Elaija esio me eghaa velue sio.” ");
INSERT INTO emi_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Me Iesu ghe ovaova anamungailiila, me inoane ghe kapala. ");
INSERT INTO emi_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kalio atiulu ghe vuuvukala tale ale manga ateva ghe tarriila elome, ghe tiuaala epona me ghe laa sio ruu euu. ");
INSERT INTO emi_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Me nau lo ateva tau ngai uvii eaitoiaa kateva ai (100) tau ngai uvii, ghe tiitingina emua ta Iesu, ghe nongola Iesu ghe samala, me ghe tarala vaalua ghe matela, soldia ngateva ghe uela va, “Koronnaaili taumattu ngateva oia Natuna ia God!” ");
INSERT INTO emi_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Katoa tana vause laghe tiitingina amasau me laghe taatara. Elome etaira Meri aMakdala ia, Salome, me Meri kinairarue ia Jeimis ghauna me Joses. ");
INSERT INTO emi_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nau Iesu ghe tokatoka eGalilii, ila o vause atoa laghe aaimuli teeia me laghe saasausia, me mene oroi katoa vause laghe mae aitauaa teeie sio eJerusalem. ");
INSERT INTO emi_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nau ghe elo alaila ta nau niaimonomonosia ngateva, lo ateva nau emuli ia ta nau manga ateva, ");
INSERT INTO emi_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josep, tanganuena tale masaliki taatara ateae eArimatia, namuu ia ta Kansolo atoa, me ie tee ghe toitoi ararimangalina ateva God, karika ghe moiela tani sso tara Paelat. Ghe loola Iesu tani laa kaieinia. ");
INSERT INTO emi_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Paelat ghe soghila tani nongo va gharovaeaata ta ghe matela, me ghe kolola namu ngateva ta soldia ngatoa, me ghe kolomiela va, “Ange matela?” ");
INSERT INTO emi_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nau namu ngateva ghe uela va ange matela, Paelat ghe uela va Josep erooroo tani ghaa Iesu. ");
INSERT INTO emi_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josep ghe polila masi kalio atiulu usousoana ia, ghe ghaa velu siola Iesu tale aikotoo. Me ghe sumuela, me ghe laoainie sio tani alokoia tale lienga niaikkaia ngateae laghe kaie ssola elome tale vallae. Ghe atakirila atu eteva tani atingina runga liu eteva. ");
INSERT INTO emi_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Me Meri aMakdala ia me Meri kinna ia Joses lalu ghe tarala nongina laghe alokoiela. ");
INSERT INTO emi_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nau eteva nau manga ateva ghe kapala, Meri aMakdala ia, Salome me Meri kinna ia Jeimis, laghe polila oeli masi ngusungusuaane tani laa rariaa ta vilikina Iesu. ");
INSERT INTO emi_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Elue talaua poopooa tale aitiutiu eteva nau, laghe lao sio tale lienga niaikkaia ngateae nau sinaka ateva ang ghe saela. ");
INSERT INTO emi_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Laghe kasu aaikolomi va, “See aue eatakiri velu atu eteva tale paa lienga ateae?” ");
INSERT INTO emi_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Vara laghe taatarala, me laghe tarala va karika teva atu tale paa lienga niaikkaia ngateae, me atu eteva namungaili ia ang ghe toka ppae lao sio. ");
INSERT INTO emi_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Laghe kupi ssola tale paa lienga niaikkaia ngateae, me laghe tarala aliki taita ateva ghe tokatoka tale pai muenna ativilau, ghe aasae ghinna usousoana, me laghe matautula. ");
INSERT INTO emi_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Aliki taita ateva ghe uela etaira va, “Am rau mene matautu. Am paepae Iesu aNasareti ia, ia o ghe matela tale aikotoo. Ange totula, karika ia oia. Am tarala voto ateva laghe alokoiela etana. ");
INSERT INTO emi_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Am laa auliaa ta kapuna disaepolo atoa, me Pita tee, va Iesu ange muemue lao sio eGalilii. Aue am sio taraia okae, nongina ghe auliaala etaimim.” ");
INSERT INTO emi_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Gharovaeaata ta laghe kupi velu ghoala, me laghe kasu vulila paa lienga niaikkaia ngateae, me laghe iloula. Kovaira ghe tallula, me laghe reterete. Karika laghe aippooaa, ta laghe maamatautu. ");
INSERT INTO emi_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nau Iesu ghe totula elue talaua poopooa, tale aitiutiu eteva nau, ghe aotuotue akasinala ta Meri aMakdala ia, ia, ia o Iesu ghe ghaa vella raroai ghaitu (7) etana. ");
INSERT INTO emi_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Vause ateva o ghe lao sio ghe auliaala ta lo atoa laghe tokatoka tee Iesu, me laghe aale amate teeia. ");
INSERT INTO emi_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Me nau laghe nongola Meri ghe uela va Iesu ang ghe sakesakela, me ia ghe taraiela, karika laghe aiesoaala. ");
INSERT INTO emi_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Emulina ghe mene aotuotula ta ghalua kapuna disaepolo lalu ghe kasukasu elaolao tale salana atikirighi, me taataraane ghe isaa ppaela. ");
INSERT INTO emi_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Lalu ghe kiri lao sio ta mene katoa kapuna disaepolo tani auliaa, me karika laghe aiesoaala. ");
INSERT INTO emi_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Emulina ghe mene aotuotula ta kasangaulu kateva (11) kapuna disaepolo, nau laghe namanama. Karika ghe masimasieinilala poli karika laghe aaiesoainia me urunguitaniira korokoronganaaili, ta poli karika laghe aaiesoaa lo atoa laghe auliaa va Iesu ange totula. ");
INSERT INTO emi_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Me ghe uela etaira va, “Am lao tale kosa akapa ateva, me am laa ppooaa masi kiukiu tale taumattu ngakapa atoa. ");
INSERT INTO emi_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Lo ateva taumattu aue eaiesoaa me la ghasuua, aue esaanga. Lo ateva karika eaiesoaa aue eaisakei me eghaa nimmarikana. ");
INSERT INTO emi_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Lo atoa la ghaiesoaa aue la ghelei niaimatootoongana: Tale ararighi eteae aue la ghaa velu raroai etoa, me aue la ghaippooaa tale oroieili asease nisama. ");
INSERT INTO emi_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Aue la poso katu ngatoa ta nimaira. Arova la ropi righi manu sesaaili, karika la rooroo tani mate. Aue la poso tau sessa atoa me tau sessa atoa aue la masina.” ");
INSERT INTO emi_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Emuli nau Vau eteva Iesu ghe ruula tani aippooaa teeila, God ghe ghaaiela, me ghe saela epona liu, me ghe tokala tale pai muenna ativilau ta God. ");
INSERT INTO emi_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Disaepolo atoa laghe lao sio tani ppooa ngakapa see. Vau Palepale ghe uungu eitauaa teeila tani ghelei aiematootoongana atoa tani asarasarakana inangariira. ");
INSERT INTO emi_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Namu ngateva Tiopilus, kasina ninamanama ang ghe lao sio, oroi taumattu laghe tootoongaala tani piti kiukiuna voto Vau eteva ghe gheleila me ghe lutula elome etaimami. ");
INSERT INTO emi_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Laghe aaimuli tee inangariira lo atoa laghe tarala isaa o voto ta mataira. Laghe tiula ta nau voto ghe tani tiuaala. Isaa o taumattu ghe uungu tale inangarina ateva Vau ngepona ateva me ila laghe tau mae sio isaa oia kiukiu. ");
INSERT INTO emi_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Liuna avalua o me aghi tee aghaloanna tani piti eghulughuluena isaa o kiukiu me aghasaokie atu ta ngetam. Aghe uungula oroi nau tani kolomi emasina vaalua isaa o inangari ghe tani tiuaala. Namu ngateva, isaa oia voto ngapitila isaa akapaaili koronna. ");
INSERT INTO emi_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Utara me aue ukila amasina va isaa o inangari laghe apasungaala etam koronna akapa. ");
INSERT INTO emi_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nau Herot kingi ia eJiudia, kateva pristi ghe tokatoka, ararina ateae ta Sekaraea, tuvuna ia Abija, me vausenna ateva, ararina ateae ta Elisabet, ie tee tuvuna ta Eron. ");
INSERT INTO emi_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ilalua ghulughuluena ilalua ta matane Vau eteva. Lalu ghe aaimuli tee kanna inangari nipaopao me inangarina Vau eteva me karika righi gheeleiaairarua sesa ta matane. ");
INSERT INTO emi_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Me tee, karika righi natuirarua ta poli Elisabet kina ngere ia, me tee lalu ghe taita namuula me vause namuula. ");
INSERT INTO emi_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kateva nau, kapuna atoa Sekaraea, laghe uungu tani ghelei uunguaaira pristi etoa, me Sekaraea, ie tee ghe uungu. ");
INSERT INTO emi_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Vara me laghe gheleila kasina salana tani kila va saa pristi eteva esso tale rum manga atiulu tani sso ghelei asu eteva masi ngusungusuaane esae ta Vau eteva. Laghe gheleila isaa o voto me laghe kilala va aue Sekaraea esso. ");
INSERT INTO emi_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nau ghe gheelei isaa o voto tani ghelei asu eteva masi ngusungusuaane, taumattu ngatoa laghe looloo sae eleka, elome tale vanisi eteva tale ale manga ateva. ");
INSERT INTO emi_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Vara me ensolo ateva kapuna ia Vau eteva ghe otuotula ta Sekaraea. Ghe tiitingina tale pai muenna ativilau tale olta ngateva laghe gheeghelei asu eteva masi ngusungusuaane etana. ");
INSERT INTO emi_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekaraea ghe tarala ensolo ateva, me ghe soghieiniela, me ghe matautula. ");
INSERT INTO emi_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Me ensolo ateva ghe uela etana va, “Sekaraea, urau mene matautu. Vau eteva ang ghe nongola kalum nilooloo sae etana. Vausenim ateva ta Elisabet aue eghaa aliki eteva taita ia me uase ararina ateae ta Jon. ");
INSERT INTO emi_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nimasimasi aue etoka ta ngetaimalua me aue amalu toka amasina. Oroi tee taumattu aue emasimasi poli aliki eteva aue elutu, ");
INSERT INTO emi_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","poli ia aue enamuu ta taataraane Vau eteva, me erau mene ropi uaeni me manu sarasarakana. Aue Spirit Manga ateva etoka etana nau ia ta kova kinna, me nau ekapa atoa. ");
INSERT INTO emi_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ia aue ekatulaa oroi taumattu nge Israeli etoa me aue la mene kiri me la oghi lao ta Vau eteva kapuira God ia. ");
INSERT INTO emi_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Uunguaane me sarasarakaniaane aue nongina Elaija, me aue emuemue ta Vau eteva. Aue eghelei tamatama atoa me natuira atoa la mae aitauaa, me aue la kateva nonga, me aue eghelei emasina nannaaira lo atoa karika la nongonongo usilaa me aue la ghaa masi ninannaa nongina lo atoa ghulughuluena ila. Aue eghelei taumattu eaimonomonosiaa tale maemaeaane Vau eteva.” ");
INSERT INTO emi_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Me Sekaraea ghe kolomila ensolo ateva va, “Vaalua arooroo tani kila va inangarim koronna, poli ngaghe taita namuula me vausenighi tee ateva ang ghe vause namuula?” ");
INSERT INTO emi_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Me ensolo ateva ghe liula me ghe uela va, “Aghi Gabriel. Atiitingina emua ta matane Vau eteva me ia esungieghila tani sio auliaa isaa oia masi inangari ta ngetam. ");
INSERT INTO emi_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Unongo! Poli karika uaaiesoaa inangarighi, aue upaavoo. Karika aue usama lomosi ta voto aghauliaala aue elutu. Inangarighi aue elutu ekoronna tale nau Vau eteva eaaloanna.” ");
INSERT INTO emi_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Me taumattu ngatoa laghe toitoi poi Sekaraea me ngila ghe nannaa va sa ateva ange lutula me karika ange kupikupi ghoa parasi tale rum manga atiulu. ");
INSERT INTO emi_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Vara me ghe kupi ghoa mae, me karika ghe roola tani aippooaa teeila, me laghe nim kilala va koti ange tarala teva nitaatara ie nonga ange kilaiela tale rum manga atiulu, poli ghe nim suisui me ghe aimatoonga ta nimane, ta ghe paavoola. ");
INSERT INTO emi_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Vara nauna tani uungu ghe ruula, me Sekaraea ghe oghi lao sio tanganuena. ");
INSERT INTO emi_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Emuli tale isaa o nau, me vausenna ateva ta Elisabet ang ghe suusunuku, me ghe tam aotuotu poila ghe roola ghalima ulana. ");
INSERT INTO emi_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ghe uela va, “Vau eteva ghe alousiusi teeieghila, me ang ghele gheleila ia oia voto ateva ange lutu etaghi, tani ghaa velu nipalata ateva etaghi ta mataira taumattu ngatoa.” ");
INSERT INTO emi_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tale aiaaghaonomina ateva (6) ulanina Elisabet nau ghe suusunuku, Vau eteva ghe suula ensol Gabriel tani sio tale natu masaliki erighi eGalilii, ararina ateae ta Nasareti. ");
INSERT INTO emi_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ghe lao sio tani tara aliki vause ateva, karika ghe aso tee poi teva taita, ararina ateae ta Meri. Laghe aseainiela va elai ta Josep, tuvuna ia Deivit. ");
INSERT INTO emi_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ensolo ateva ghe lao sio etana me ghe uela va, “Elue talaua etam! God ang ghe arangiseiola, me Vau eteva etokatoka teeio.” ");
INSERT INTO emi_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Meri ghe soghiaala tani nongo isaa o inangari, me ghe annangailiila va tani saa inangari llo oia. ");
INSERT INTO emi_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Me ensolo ateva ghe uela va, “Meri, urou mene matautu. Vau eteva aue eghelei masi voto etam. ");
INSERT INTO emi_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Unongo! Aue ukkaai aliki eteva taita ia, me uase ararina ateae ta Iesu. ");
INSERT INTO emi_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ia aue enamuu, me aue la koloa va Natuna ateva Lo ateva Iaaili Epona. Me Vau eteva God aue egheleia ekingi nongina tuvuna ta Deivit. ");
INSERT INTO emi_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ia aue namuu tale ararimangalina ateva Jekop nau ekapa atoa, me ninamu ngateae etana karika aue ekapa.” ");
INSERT INTO emi_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Me Meri ghe kolomila ensolo ateva va, “Isaa o voto, vaalua aue elutu, poli karika aghe aso tee poi teva taita?” ");
INSERT INTO emi_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Me ensolo ateva ghe liula inangarina me ghe uela va, “Aue Spirit Manga ateva emae toka etam, me sarasarakaniaane Lo ateva Iaaili Epona aue eakouo. Ia o aliki eteva aue umolenainia aue emanga, me aue la koloa va Natuna ia God. ");
INSERT INTO emi_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Unongo, mangalim ta Elisabet ang ghe vause namuula, me ia oia ekakkaai me aue emolenaa, aliki eteva taita ia. Nau to ang ghe lao sio, laghe ue va karika erooroo tani ghaa aliki. Me ia oia esuusunuku ang ghele ghaonomola (6) ulanina. ");
INSERT INTO emi_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Poli karika teva voto God etam rooroo tani ghelei.” ");
INSERT INTO emi_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Me Meri ghe uela va, “Unongo, aghi kapuna vause tau ngai uungu ieghi Vau ngepona ateva. Erooroo tani ghelei etaghi voto nongina uauliaa.” Vara me ensolo ateva ghe kasu vuliela. ");
INSERT INTO emi_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kasina nau ghe lange sio tale isaa o nau, Meri ghe ailuiluila tani lao tale voto ateva oroi motouru etana tale kateae ppae natu masaliki tale masaliki eteae eJiudia. ");
INSERT INTO emi_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Me ghe kupi ssola tanganuena Sekaraea me ghe tarala Elisabet me ghe uela va, “Elo alai etam.” ");
INSERT INTO emi_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nau Elisabet ghe nongola Meri ghe samasama teeia, aliki eteva ta kovane namungaili ta ghe aisiisiaala, me Spirit Manga ateva ghe pasula ta Elisabet. ");
INSERT INTO emi_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Me ghe sama anamungailiila tani ue va, “Vau eteva ang ghe tau aatu sio niarangise elaulau niarangise etautau ta mene katoa vause. Ia ona aliki eteva ukaakaaia aue eghaa niarangise ta Vau eteva. ");
INSERT INTO emi_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kalughu sa ateva me kinna ateva Vaughu eteva ange mae sio tani taraieghi? ");
INSERT INTO emi_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nau eteva anongola ta usamala, arovaeaata ta aliki eteva ta kovaghi emasimasila me eaisiisiaala. ");
INSERT INTO emi_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","God aue earangiseio poli ughe aiesoaala voto Vau eteva ghe uela va aue elutu ta ngetam.” ");
INSERT INTO emi_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Meri ghe uela va, “Maamauluaaghi etautau sae ararina ateae Vau eteva, ");
INSERT INTO emi_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","me urunguitanighi eteva emasimasiangaili God ta eaasaangieghi. ");
INSERT INTO emi_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Aghi nim tau ngai uungu ieghi etana, karika teae ararighi, me ghe taraieghila tale maamasinaane. Ia oia vituu eteva me llo auena vituu aue la ue va Vau eteva ghe arangiseieghila, ");
INSERT INTO emi_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Lo ateva sarasarakanaaili ia ghe gheleila voto namungaili etaghi, me ararina ateae manga ia. ");
INSERT INTO emi_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Eaapasunga masi aalousiusiaane ta lo atoa la oneoneainia aue etoka gheelei evalua o tale ia oia vituu eteva me llo auena vituu. ");
INSERT INTO emi_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ghe gheleila kinatama voto ta nimana, me ta lo atoa la tautau sae nannaaira, aue egheleila la ghaitiuaa see. ");
INSERT INTO emi_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ghe atoka siola lo atoa taumattu namu ngila me sarasarakanaaili ila me ghe atingina saela lo atoa taumattu karika righi arariira. ");
INSERT INTO emi_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ghe tautau masi voto ta lo atoa taumattu maloona ila, me lo atoa tau peipeiena ila, ghe sungisungi vella, nim ila laghe kasukasu karika laghe ghaaghaa righi voto. ");
INSERT INTO emi_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ghe sausila kapuna tau ngai nongonongo anna atoa ta Israeli etoa, poli eannaa alousiusiaane ");
INSERT INTO emi_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ta Abraham me lo atoa tuvuna auena la lutu, nongina ghe auliaala ta tuvuita atoa.” ");
INSERT INTO emi_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meri ghe toka teela Elisabet ghe roola kotolu ulana me ghe vira mene kiriaa lao sio tanganuena. ");
INSERT INTO emi_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nauna Elisabet tani molenaa, me ghe molenaala aliki eteva taita ia. ");
INSERT INTO emi_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Lo atoa taumattu tanganueira aitauaa me kapuna atoa, laghe nongola kiukiu vaalua Vau eteva aalousiusiaane ta Elisabet. Laghe masimasi eitauaa teeiela. ");
INSERT INTO emi_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Aiaaghaoaluna (8) ateva nau, taumattu ngatoa laghe mae sio tani velu eitauaa tani iso aliki eteva, me laghe aloanna tani ase ararina ateae ta Sekaraea, poli ararina ia tamane. ");
INSERT INTO emi_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kinna aliki eteva ghe uela va, “Karika! Ararina ateae ta Jon.” ");
INSERT INTO emi_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Me laghe uela etana va, “Karika teva kapuimim ararina ia arari eteae ona.” ");
INSERT INTO emi_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Me laghe aaimatoonga ta nimaira tani kolomi tamana aliki eteva va saa arari eteae eaaloannaia. ");
INSERT INTO emi_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sekaraea ghe aimatoongaala etaira va la ghaa taula teva aipitipiti me epiti inangarina. Inangarina ghe pitila ghe uela va, “Aliki eteva, ararina ateae ta Jon.” Taumattu ngatoa laghe soghiaala voto laghe tarala. ");
INSERT INTO emi_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Arovaeaata ta God ghe otila paane ateva Sekaraea, me Sekaraea ghe samala, me ghe mene tiuaala tani sama me ghe tau saela ararina ateae God. ");
INSERT INTO emi_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Me lo atoa masaliki kalakalangina ila laghe tarala isaa o voto ghe lutula, me ghe moilala, me kiukiu ghe kasu ekapa seela, me lo akapa atoa laghe tokatoka tale voto ateva oroi motouru etana eJiudia, laghe nongo akapala. ");
INSERT INTO emi_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Lo akapa atoa taumattu laghe nongola, laghe nnaa sosso laala isaa o kiukiu, me laghe aaikolomieinila va, “Aliki eteva oia, aue saa taumattu nau enamuu?” Poli laghe tarala va sarasarakaniaane Vau eteva ghe toka aitauaa teeiela. ");
INSERT INTO emi_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Spirit Manga ateva ghe pasula ta Sekaraea, tamane aliki eteva, me ghe aulia ngamuemua alokoila inangari tani ue va, ");
INSERT INTO emi_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ita tau sae ararina ateae Vau eteva, kapuira Goto ia Israeli etoa, poli ghe mae sio tani sausi kapuna taumattu ngatoa me ghe poli aoghi teeilala. ");
INSERT INTO emi_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ghe tau mae sio kateva taumattu sarasarakanaaili ia tani sausita elome ta tuvuna atoa Deivit, kapuna tau ngai nongonongo anna ateva God. ");
INSERT INTO emi_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nongina ghe gheleila inangari nialokoi ta propete atoa manga ila me ila laghe auliaala emua arau, ");
INSERT INTO emi_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","va aue easaangita ta tau ngai ssateeita atoa, me ta nimaira lo atoa esessaieiliila etaita. ");
INSERT INTO emi_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ta poli aalousiusiaane ghe sausila tuvuita atoa, me eannaa inangari manga emua arau ghe aulia ngalokoila ");
INSERT INTO emi_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ghe auliaala inangari nialokoi ta tuvuita ateva ta Abraham. ");
INSERT INTO emi_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Eanna tani asaangita ta nimaira tau ngai ssateeita atoa me ita kkaueinia me ita rau mene matautu. ");
INSERT INTO emi_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Liuna avalua o me nau ekapa atoa, nau sakesake ita, ita kasu tale salana manga me ghulughuluena ta matane. ");
INSERT INTO emi_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Me io, natughu, aue la ghaseo va kapuna propete io Vau eteva; me io aue umuemuea Vau eteva tani aimonomonosiaa salane atikirighi, ");
INSERT INTO emi_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","tani ghelei masalika tale kapuna taumattu ngatoa, vaalua tani saanga me eghaa velu kaluira ssavoto, ");
INSERT INTO emi_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","tale aalousiusiaane kapuita Goto ateva, me mallanga ngepona liu eteva aue esio etaita ");
INSERT INTO emi_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","tani tau mae mallanga ateva tale taumattu ngatoa la tokatoka tale saurrom me tootoo nimate ateva me tani aitaraa kasukasuaaita tani lao tale salana luei.” ");
INSERT INTO emi_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ia o aliki eteva ghe namuula, me alomasaanganiaane ghe sarasarakanaailiila, me ghe tokatoka tale voto ateva karika righi taumattu etana, elomosina ta ghe vira mene ghaala nauna tani ppooaa tale taumattu nge Israeli etoa. ");
INSERT INTO emi_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tale isaa o nau, Siisa Augustus ghe alokoila kateva inangari va la ghaa akapa arariira taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nau eteva Kuirinius gavana ia eSiria, laghe gheleila aitiutiu eteva sensis. ");
INSERT INTO emi_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Liuna avalua o me isaa akapa taumattu ghe oghioghi lao tale masaliki tuvuira atoa, me gavmani ghe ghaaghaa arariira. ");
INSERT INTO emi_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Poli Josep ararimangalina aitauaa tee Deivit, liuna avalua o me ghe kasu vulila masaliki eteae eNasareti nge Galilii, me ghe saela eJiudia tale masalikina ateae Deivit, la kolokoloa va Betlehem, tani alokoi ararina ateae. ");
INSERT INTO emi_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ia me vause ateva laghe aseainiela va eghaaia, ararina ateae ta Meri, lalu ghe saela va gavmani ghe ghaa arariirarua. Isaa o nau Meri ghe suusunuku. ");
INSERT INTO emi_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ilalua eBetlehem me ghe ghaala nauna Meri tani molenaa, ");
INSERT INTO emi_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","me ghe molenaala natuna aitiutiu eteva aliki taita ia, me ghe ghiisainiela tale kalio me ghe alokoie siola tale aikaai aneira inana ateva vulumakao atoa, poli isaa akapa ale aiasoaso ghe pasula. ");
INSERT INTO emi_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Eleka tale masaliki eteae eBetlehem, katoa tana tau ngai toi sipsipi laghe aaitoiaa kieira ghaata kkena tale voto ateva rarrasa etana, eleivoo. ");
INSERT INTO emi_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Me kateva kapuna ensolo Vau eteva ghe rekataala etaira me mallangina ateva ghe talieinilala me laghe matautu saasakiaala. ");
INSERT INTO emi_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ensolo ateva ghe uela etaira va, “Am rau mene matautu, poli amae sio tani auliaa kieimim tale masi kiukiu. Isaa oia inangari aue eghelei isaa akapa taumattu la masimasieili. ");
INSERT INTO emi_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ia oia nau eteva aliki eteva, aiasaangimim ia, ange lutula tale masalikina ateae Deivit, ia Mesaea ia, me Vau ia. ");
INSERT INTO emi_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Vaalua aue am kilaia, aue am taraia ghiighiisainia tale kalio, me easoaso tale aikaai aneira inana ateva vulumakao atoa.” ");
INSERT INTO emi_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Arovaea nonga ta mene katoa ensolo oroiannaaili ila la tokatoka epona liu, laghe kaurekatila, me laghe tingina teela ia o ensolo ateva, me laghe tiuaala tani kkaua ararina ateae God, laghe ue va, ");
INSERT INTO emi_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ita tau sae ararina ateae Vau eteva epona liu me tale kosa ateva luei aue etoka ta lo atoa God emaamasieinila.” ");
INSERT INTO emi_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nau ensolo atoa laghe kasu vulilala, me laghe saela epona liu, me tau ngai toi sipsipi etoa laghe aippooa ngaitauaala va, “Ita kasu me ita lao eBetlehem, me ita laa tara isaa o voto ange lutula, Vau eteva eauliaala.” ");
INSERT INTO emi_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Laghe ailuiluila tani kasu, me laghe laa saopi sio Meri me Josep me aliki eteva, ghe asoaso tale aikaai aneira inana ateva vulumakao atoa. ");
INSERT INTO emi_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nau eteva laghe taraiela, laghe auliaa seela inangarina aliki eteva, ensolo ateva ghe auliaala etaira. ");
INSERT INTO emi_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Me ila akapa taumattu ngatoa laghe nongola kiukiu tau ngai toi sipsipi etoa laghe auliaala, me laghe soghiaala. ");
INSERT INTO emi_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Meri ghe ailokoia ngakapala isaa o inangari tale urunguitanina, me nau ekapa atoa ghe annaa. ");
INSERT INTO emi_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tau ngai toi sipsipi etoa laghe oghiaala, me laghe tau saela ararina ateae God, me laghe masimasiangailiila God, poli isaa akapa voto ensolo ateva ghe auliaala, laghe tarala me laghe nongola, nongina ghe auliaala. ");
INSERT INTO emi_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Aiaaghaoaluna (8) ateva nau laghe isola aliki eteva, me laghe asela ararina ateae ta Iesu, kinna karika ghe kaaia me ensolo ateva ghe ase alokoila ararina ateae. ");
INSERT INTO emi_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ghe ghaala nau ta Josep me Meri tani raarangisana, tani aimulusi tee inangari nipaopao Moses ghe piti elokoila. Liuna avalua o me lalu ghe saula aliki eteva, me laghe saela eJerusalem tani apasungainia ta Vau eteva. ");
INSERT INTO emi_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Lalu ghe anna tani aimuli tee Uru ngai Manga ateva eue va, “Isaa akapa aliki taita aitiutiu tani lutu, la taula lao me la ghamangaila ta Vau eteva.” ");
INSERT INTO emi_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Lalu ghe saela tani ghelei aiaavusuvusuena, nongina inangarina Vau eteva ghe auliaala va, “Ghila alua nongina alikaoo alua, o valusu elua, lalu vira mene naanamuu.” ");
INSERT INTO emi_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Isaa o nau kateva taumattu ghe tokatoka eJerusalem, ararina ateae ta Simion, ghe gheelei nonga voto ghulughuluena, me ghe aaimuli tee God. Spirit Manga ateva ghe tokatoka ta ngetana. Ghe toitoi ia o taumattu ngateva aue alona eusi Israeli etoa. ");
INSERT INTO emi_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Spirit Manga ateva ang ghe aotula etana va karika aue emate lomosi ta etara mua kapuna Mesaea ngateva Vau eteva. ");
INSERT INTO emi_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Spirit Manga ateva ghe katulainiela me ghe kupi ssola tale ale ngeleka atiulu tale ale manga ateva, me kinna me tamane Iesu lalu ghe maeaa sio ia o aliki eteva Iesu etana, tani ghelei voto inangari nipaopao eaauliaa. ");
INSERT INTO emi_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Me Simion ghe sauela me ghe kalopiela, me ghe tau saela ararina ateae God, me ghe uela va, ");
INSERT INTO emi_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Vau eteva, aghi kapum tau ngai nongonongo anna ieghi, ia oia urooroo tani tau velueghi tale luei, nongina ughe auliaala. ");
INSERT INTO emi_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mataghi ange tarala kalum niasaangi eteva, ");
INSERT INTO emi_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ughe aimanomanosieiniela ta mataira isaa akapa taumattu ngatoa, ");
INSERT INTO emi_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ia mallanga ia eaapasunga Vau eteva ta mene katoa patunganue namuu, me aue la gharuaa kapum taumattu nge Israeli etoa.” ");
INSERT INTO emi_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tamana me kinna Iesu lalu ghe soosoghiaa voto Simion ghe aauliaa tee Iesu. ");
INSERT INTO emi_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Me Simion ghe arangiseilaluela, me ghe uela ta Meri va, “Ia oia natum ateva aue eghelei oroi taumattu nge Israeli, katoa aue la mate, me katoa aue la saanga, aue etoka tani aimatootoongana ta taumattu ngatoa, me karika poi aue la annaia, ");
INSERT INTO emi_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","me aue eghelei nannaaira aisuliaane aue eotu. Me io, Meri, alousiusiaam aue enongina baenata ateva epasapasa urunguitanim ateva.” ");
INSERT INTO emi_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Vause ateva, propete ia, ghe vause namungailiila, ararina ateae ta Anna, natuna ia Panuel, tale ararimangali eteva ta Asa, ie tee ghe tokatoka tale ale manga ateva. Nau ghe laila ghe toka teela taitanna ateva ghaituae (7) ninamanama nonga me taitanna ateva ghe raue vuluela. ");
INSERT INTO emi_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Taitanna ateva ghe raue vuluela, me ghe tokala ghe roola ghaoalungaulu ghaatiae (84) anna ninamanama, me ghe kakkaua tale ale manga ateva ellaa me eleivoo, me ghe naenae me ghe looloo sae tale nau laghe suitoongaala va la lao aitauaa etana tale ale manga. ");
INSERT INTO emi_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nau Simion ghe aaippooaa tee Meri me Josep, Anna ghe rekatala, me ghe tiuaala tani tau sae God, me ghe aauliaa aliki eteva ta lo atoa laghe toitoi kapuira tau ngai asaangi eteva Israeli etoa. ");
INSERT INTO emi_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nau Josep me Meri lalu ghe ghelei ekapala voto tale inangarina Vau eteva, me lalu ghe mene oghi siola tanganueirarua eNasareti, ta pai nge Galilii. ");
INSERT INTO emi_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ia o aliki eteva ang ghe naanamuu, me sarasarakana ia, alomasaanga ia, me God ghe aarangiseia. ");
INSERT INTO emi_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Isaa akapaaili ninamanama, tamana me kinna Iesu lalu ghe saesae eJerusalem tale nivelu eitaua ngateae, laghe aseasea va Pasova. ");
INSERT INTO emi_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nau anna ninamanama Iesu ghe kasangaulu ghaluaela (12), laghe saela tale nivelu eitaua ngateae, nongina laghe gheelei arau. ");
INSERT INTO emi_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nau nivelu eitaua ngateae ghe ruula, tamane me kinna ngila ghe mene ooghiaa tani lao tanganueira, me taita arighi ta Iesu ghe tokala eJerusalem. Karika lalu ghe kilala. ");
INSERT INTO emi_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Lalu ghe annaa va Iesu ghe kasukasu tee mene katoa taumattu. Laghe kasula ghe roola kateva nau, me lalu ghe tiuaala tani paea. Lalu ghe aaikolomainie see, ta mangaliirarua atoa me kapuirarua atoa. ");
INSERT INTO emi_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nau karika lalu ghe taraiela, lalu ghe mene oghiaa lao sio eJerusalem tani mene paea. ");
INSERT INTO emi_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ghalua nau ghe lange sio, me lalu ghe taraiela elome tale ale manga, ghe tokatoka tee tau ngai aapasunga ngatoa. Ghe nongonongola, me ghe kookolomila tale nikokkolomi. ");
INSERT INTO emi_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Lo atoa laghe nongonongoa laghe soosoghiaa aalomasaanganiaane, me vaalua ghe liuliu uneira nikokkolomi. ");
INSERT INTO emi_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nau eteva kinna me tamane lalu ghe taraiela, lalu ghe soghieiniela, me kinna ghe uela etana va, “Natughu, vaalua me ughe ghelei evalueiengaluela o? Angalua me tamam angalu ghele nannangailiio nau eteva angalu ghele paepaeo.” ");
INSERT INTO emi_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ghe kolomilaluela va, “Vaalua me amalu paepaeaghi? Amalu rooroo tani kila va aghi tale alena ateva Tamaghi.” ");
INSERT INTO emi_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Karika lalu ghe kila amasinala malloeanina voto ghe auliaala etairarua. ");
INSERT INTO emi_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Me ghe usilaluela, me laghe siola eNasareti, me nau ekapa atoa ghe nongonongo usilainilalua. Me kinna ghe ailokoia ngakapaailila isaa o voto tale urunguitanina ateva. ");
INSERT INTO emi_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Me Iesu ghe naanamuu, me aalomasaanganiaane tee ghe laa saesae, me God me taumattu ngatoa laghe aaloannaailiia. ");
INSERT INTO emi_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tale aiaakasangaulu ghalimae (15) ateae ninamanama ta Taiberias Siisa tani aitoiaa eRom, me Pontius Paelat gavana ia eJiudia, me Herot ghe aaitoiaa eGalilii, me tuena ta Pilip ghe aaitoiaa eIturea me eTrakonitis, me Lisanias ghe aaitoiaa eAbilen — ");
INSERT INTO emi_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","isaa o nau Annas me Kaeapas namuu ilalua ta pristi etoa ta aJiu etoa, me isaa o nau tee, Jon natuna Sekaraea ghe tokatoka tale voto ateva karika righi taumattu ta ngetana, me inangarina God ghe mae sio etana. ");
INSERT INTO emi_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jon ghe kasukasu ekapa see tale masaliki eJodan, kalakalaa tale ateo ateae, me ghe poppooaa ta taumattu ngatoa va la nna ngaioghioghiaa me la ghaa niasuu, me God aue ekkaluaa kaluira ssavoto. ");
INSERT INTO emi_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nongina propet Aisaea ghe pitila emua arau, ghe uela va, “Tale voto ateva karika righi taumattu etokatoka etana, lingi ngalo taumattu ngateva ekolokolo, eue va, ‘Am aimonomonosiaa salane atikirighi Vau eteva, am ghelei eghulughuluena akapala salane. ");
INSERT INTO emi_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Aue la rovii liu me voto saesaena pei nikai emasina, me llo salana viloviloana pei nighelei eghulughuluena me voto sesaaili aue la ghelei emasina. ");
INSERT INTO emi_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Me taumattu ngakapa atoa aue la tara kanna niasaangi God.’” ");
INSERT INTO emi_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Oroienaaili taumattu ghe mae sio ta Jon va easuula, me Jon ghe uela etaira va, “Am nongina va natuira iem katu ngatoa! See euela etaimim va am ilou vuli sessaiaane Vau eteva ange anna tani lutu etaimim? ");
INSERT INTO emi_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Am kuneaa righi ueimim tani apasunga va ngam ghe vella kaluimim ssavoto. Am rau mene ue va, ‘Ami tuvuna amami Abraham.’ Poli aghaauliaa etaimim va God erooroo tani ghelei isaa o atu etuvuna Abraham. ");
INSERT INTO emi_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kulum ateva aimonomonosiaanna ia tani tue akatuu ai, me isaa o ai karika ekuukuneaa masi uene aue la tue me la sau velu sae tale kuraa ateae.” ");
INSERT INTO emi_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Me taumattu ngatoa laghe kolomila Jon va, “O sa ateva ami gheleia?” ");
INSERT INTO emi_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jon ghe uela etaira va, “Arova ghalua unem sioto, utau lao teva ta lo ateva karika teva unna, me arova righi anem inana, uparruu mene katoa.” ");
INSERT INTO emi_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tau ngai ghaa takis atoa tee laghe mae sio va easuula, me laghe uela ta Jon va, “Tisa, ami vaalua ami ghelei?” ");
INSERT INTO emi_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Jon ghe uela etaira va, “Am ghaa lo viliki veu gavmani eue va am ghaa, am rau mene nim ghaa righi ta aloaloannaaimim.” ");
INSERT INTO emi_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Me katoa tana soldia laghe kolomiela va, “Me ami, sa ateva ami gheleia?” Jon ghe uela etaira va, “Am rau mene amatautu taumattu ngatoa tani ghaa uneira viliki veu, me am rau mene aikameaa. Am masimasi tee aipoliimim.” ");
INSERT INTO emi_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ila akapa taumattu ngatoa laghe toitoi Mesaea ngateva, laghe nannaa va koti Jon Mesaea ia. ");
INSERT INTO emi_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jon ghe uela etaira va, “Aghi aghaasuuem tale manu, me mene kateva aue emae, ia sarasarakaniaane elaulau sarasarakaniaaghi. Karika masi taumattu ngieghi tani pulaka unna ai-iri aikasukasu. Ia aue easuuem tale Spirit Manga ateva me tale kuraa ateae. ");
INSERT INTO emi_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Aue emae arova taumattu ngateva eposoposo unna poko ateva aisaraki uiti ia tani pola uiti tale kou uit, me aue eatoka aitauaa uiti tale ale ngai atoka uiti eteva, me aue evelu sae kou uiti tale kuraa ateae karika erooroo tani pala.” ");
INSERT INTO emi_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tale oroi asease salana, Jon ghe poppooaa masi kiukiu tale taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Me Herot ia o gavana ia, Jon ghe uela etana va, “Karika masina ta ughe lai sarila Herodias, poli vausenni ia tuem.” Oroi mene kasina ase gheeleiaane sesa ");
INSERT INTO emi_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","me Herot ghe gheleila voto ateva sesaaili ia, nau ghe atoka ssola Jon tale ale mata voovoo. ");
INSERT INTO emi_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nau Jon ghe aasuu taumattu ngatoa, ghe asuu teela Iesu. Epona liu ghe otiela nau Iesu ghe looloo sae, ");
INSERT INTO emi_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","me Spirit Manga ateva ghe sio mae ta Iesu nongina ghila ateva, valusu ia. Me lingi ngalo ateva epona liu ghe uela va, “Io natughu io, aghaailousiangailiio me masimasiaaghi ta ngetam namungaili.” ");
INSERT INTO emi_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nau Iesu ghe tiuaala uunguaane koti anna ninamanama kotolungauluae (30). Taumattu ngatoa laghe annaa va natuna ia Josep, Josep natuna ia Heli, ");
INSERT INTO emi_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","me Heli natuna ia Matat, me Matat natuna ia Livae, me Livae natuna ia Melki, me Melki natuna ia Jannai, me Jannai natuna ia Josep, ");
INSERT INTO emi_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","me Josep natuna ia Mattataeas, me Mattataeas natuna ia Eimos, me Eimos natuna ia Nahum, me Nahum natuna ia Esli, me Esli natuna ia Naggai, ");
INSERT INTO emi_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","me Naggai natuna ia Mahat, me Mahat natuna ia Mattataeas, me Mattataeas natuna ia Semein, me Semein natuna ia Josek, me Josek natuna ia Joda, ");
INSERT INTO emi_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","me Joda natuna ia Joanan, me Joanan natuna ia Resa, me Resa natuna ia Serubabel, me Serubabel natuna ia Sealtiel, me Sealtiel natuna ia Neri, ");
INSERT INTO emi_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","me Neri natuna ia Melki, me Melki natuna ia Addi, me Addi natuna ia Kosam, me Kosam natuna ia Elmadam, me Elmadam natuna ia Er, ");
INSERT INTO emi_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","me Er natuna ia Josua, me Josua natuna ia Eliesa, me Eliesa natuna ia Jorim, me Jorim natuna ia Mattat, me Mattat natuna ia Livae, ");
INSERT INTO emi_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","me Livae natuna ia Simion, me Simion natuna ia Jiuda, me Jiuda natuna ia Josep, me Josep natuna ia Jonam, me Jonam natuna ia Eliakim, ");
INSERT INTO emi_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","me Eliakim natuna ia Melea, me Melea natuna ia Menna, me Menna natuna ia Mattata, me Mattata natuna ia Naetan, me Naetan natuna ia Deivit, ");
INSERT INTO emi_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","me Deivit natuna ia Jesi, me Jesi natuna ia Obed, me Obed natuna ia Boasi, me Boasi natuna ia Salmon, me Salmon natuna ia Nason, ");
INSERT INTO emi_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","me Nason natuna ia Aminadab, me Aminadab natuna ia Admin, me Admin natuna ia Arni, me Arni natuna ia Hesron, me Hesron natuna ia Peres, me Peres natuna ia Jiuda, ");
INSERT INTO emi_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","me Jiuda natuna ia Jekop, me Jekop natuna ia Aisiki, me Aisiki natuna ia Abraham, me Abraham natuna ia Tera, me Tera natuna ia Nahor, ");
INSERT INTO emi_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","me Nahor natuna ia Seruk, me Seruk natuna ia Reu, me Reu natuna ia Pelek, me Pelek natuna ia Eber, me Eber natuna ia Sela, ");
INSERT INTO emi_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","me Sela natuna ia Keinan, me Keinan natuna ia Apaksat, me Apaksat natuna ia Sem, me Sem natuna ia Noa, me Noa natuna ia Lemek, ");
INSERT INTO emi_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","me Lemek natuna ia Metiusila, me Metiusila natuna ia Inok, me Inok natuna ia Jaret, me Jaret natuna ia Mahalalel, me Mahalalel natuna ia Kenan, ");
INSERT INTO emi_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","me Kenan natuna ia Enos, me Enos natuna ia Set, me Set natuna ia Adam, me Adam natuna ia God. ");
INSERT INTO emi_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesu ghe lau sae mae tale ateo ateae eJodan, me Spirit Manga ateva ghe pasula etana, me ghe ssoainiela tale voto ateva karika righi taumattu etana. ");
INSERT INTO emi_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Namu ngateva ta raroai etoa ghe tootoongaala Iesu tale ghaatingaulu (40) nau. Isaa o nau karika ghe namanama poila, me airuuruu tale isaa o nau ghe maloola. ");
INSERT INTO emi_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Namu ngateva ta raroai etoa ghe mae sio ta Iesu me ghe uela va, “Arova koronna va Natuna io God, uauliaa tale atu etiulu o me ekoli me everete.” ");
INSERT INTO emi_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Iesu ghe liula me ghe uela va, “Uru ngai Manga ateva eaauliaa va, ‘Karika taumattu ngatoa va la maamaulue nonga tale inana.’” ");
INSERT INTO emi_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Namu ngateva ta raroai etoa ghe saeaala Iesu tale motouru tani apasunga patunganue namu ngakapa atoa tale kosa ateva oia, me tale ia o tuku nau erighi ghe apasunga ngakapala kosa ateva. ");
INSERT INTO emi_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Me ghe uela ta Iesu va, “Aue atau aatu matuutuliena, me unamuu tani aitaraa isaa o voto. Ta aghe ghaala isaa akapa o voto, me arova aghaloanna tani taula ta see, aue ataula. ");
INSERT INTO emi_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Isaa o voto aue peim arova usuuiaa me ukkaueinaghi.” ");
INSERT INTO emi_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iesu ghe liula me ghe uela va, “Uru ngai Manga ateva eue va, ‘Ukkaua Vau eteva kapum Goto ia, me uaimulusi teeia nonga.’” ");
INSERT INTO emi_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ghe mene saeaala Iesu tale pungani ale manga ateva eJerusalem, me ghe uela va, “Arova Natuna io God, ulove velu sio. ");
INSERT INTO emi_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ta Uru ngai Manga ateva eue va, “‘Ia aue esuu kapuna ensolo atoa tani sio aitara ngamasinaailiio, ");
INSERT INTO emi_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Me aue la sau evukalaio me karika aue utaghua kekem tale atu.’” ");
INSERT INTO emi_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iesu ghe uela etana va, “Uru ngai Manga ateva eue va, ‘Urau mene tootoonga Vau eteva kapum Goto ia.’” ");
INSERT INTO emi_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Namu ngateva ta raroai etoa ghe ruu ekapala unna nitootoonga ta Iesu, me ghe kasu vuliela tani mene toi mene teva masi nau ppae. ");
INSERT INTO emi_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iesu ghe ghaala sarasarakana tale Spirit Manga ateva, me ghe kiri lao sio eGalilii, me kiukiuna ghe lao sio tale masaliki ekapa atoa. ");
INSERT INTO emi_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ghe aapasunga tale aleira ale nivelu eitaua ngatoa, me ila akapa laghe aarueinia. ");
INSERT INTO emi_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Iesu ghe lao sio eNasareti nongina ghe namuula, me tale nau manga ghe ssola tale ale nivelu eitaua ngateva, nongina eghe gheelei nau ekapa atoa, me ghe tingina saela tani riti Uru ngai Manga ateva. ");
INSERT INTO emi_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Me laghe taula vuku eteva unna ia propete Aisaea, laghe aseasea va skrol, ghe pulakaiela, me ghe paela inangari Aisaea ghe pitila, ");
INSERT INTO emi_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ghe uela va, “Spiriti eteva ta Vau eteva etokatoka etaghi, poli eghe suitoongainaghila tani ppooaa masi inangari ta lo atoa karika peiira. Me ghe sungieghila tani ppooaa va la ghaa velu lo atoa tale ale mata voovoo, mata salusalu etoa aue la taatara, tani ruu maamatana ta lo atoa la gheelei sesa etaira, ");
INSERT INTO emi_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","me tani aulia ngaotu va nauna oia Vau eteva tani asaangi kapuna taumattu.” ");
INSERT INTO emi_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Iesu ghe mene talila skrol ateva, me ghe taue lao sio ta lo ateva ghe aaitaraa skrol atoa, me ghe toka siola tani ppooaa. Ila akapa laghe pasiaala mataira etana, ");
INSERT INTO emi_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","me Iesu ang ghe aauliaa etaira va, “Inangari oia tale Uru ngai Manga ateva ange koronnala ghaine tale nongonongoaaimim.” ");
INSERT INTO emi_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Laghe soghiaala tani nongo masi inangari ghe kupi ghoa mae ta paane, me laghe masimasila, me laghe aaikolomieinila va, “Ia oia natuna Josep, o karika?” ");
INSERT INTO emi_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iesu ghe auliaala etaira va, “Akilakila va aue am ue ta tuku inangari eteva va, ‘Io dokta io, ughelei emasinaio mua.’ Me aue am ue etaghi va, ‘Ughelei mua righi voto oia tanganuem, nongina ami ghe nongola ughe gheelei voto eKapenium.’” ");
INSERT INTO emi_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ghe mene uela va, “Aghaaulia ngakoronna etaimim va karika toa la rooroo tani oneoneaa teva propete tanganueira aitauaa me ia. ");
INSERT INTO emi_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Aghaaulia ngakoronna va oroi vause raue vulu eIsraeli nau ta Elaija, nau karika teva vaoo tale kotoluae (3) ninamanama me ghaonomo (6) ulana, me paka maloo ateva ghe asola eIsraeli. ");
INSERT INTO emi_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Vau eteva ghe tam suula Elaija va ghe lao ta teva aIsraeli, ta ghe lao sio tale masaliki eteae eSarepat, ta vause raue vulu eteva elome tale patunganue namu ngateae eSaedon. ");
INSERT INTO emi_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Me tee, oroi taumattu nge Israeli, isiki tasussuku eteva ghe ghaailala, nau ta propete ateva Elaisa, karika laghe raarangisanala, me Naaman nonga, aSiria ia, ghe raarangisanala.” ");
INSERT INTO emi_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Lo atoa elome tale ale nivelu eitaua ngateva laghe nongola inangarina me ghe sessaieiliilala. ");
INSERT INTO emi_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Laghe tingina saela, me laghe kuneiela, me laghe ae velue ghoala eleka tale masaliki taatara ateae, me laghe saeainiela tale motouru eteva. Laghe aloanna tani bbi velue sio tale vallae. ");
INSERT INTO emi_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Me Iesu ghe kasula ta mallomeira, me ghe kasu vulilala. ");
INSERT INTO emi_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iesu ghe lao sio eKapenium, masaliki taatara ia eGalilii. Vara nau manga ateva ghe mae sio, me ghe tiuaala tani apasunga inangarina God ta taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Laghe soghiaala voto ghe aauliaa, ta nonginaaili taumattu ngateva matuutuliena ia. ");
INSERT INTO emi_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Elome tale ale nivelu eitaua ngateva, taita ateva, raroai eteva ghe tokatoka etana. Ghe sama anamuula, ");
INSERT INTO emi_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","me ghe uela va, “Iesu aNasareti io, umae sio tani ghelei sa ateva etaimami? Vara ughelei saasakieinamami? Akilakilaio, io manga io kapuna io God.” ");
INSERT INTO emi_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iesu ghe uela va, “Urau mene sama! Kupi ghoa mae!” Ghe kupi ghoala, me ghe gheleila taumattu ngateva ghe katuula elome ta taumattu ngatoa, me karika ghe vakovakola. ");
INSERT INTO emi_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ila akapa laghe soghiaala tani nongo me tara, me ngila ghe aippooaa elome etaira va, “Saa voto llo oia? Matuutuliena me sarasarakana inangarina! Epoppooaa ta raroai etoa, me la kupikupi ghoa!” ");
INSERT INTO emi_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kiukiuna Iesu ghe lao sio tale mene kasina masaliki. ");
INSERT INTO emi_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu ghe kupi ghoala tale ale nivelu eitaua ngateva, me ghe lao sio tanganue Saemon. Alumuna Saemon ghe iisiki, vilikina ghe aanasa atingina me matana ghe valavalanga. Laghe aulieiniela ta Iesu va esausia. ");
INSERT INTO emi_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iesu ghe tingina valaala ta komona vause ateva, me ghe paola isiki eteva, me ghe kapala. Vause ateva ghe masinala, ghe totula, me ghe kaisila aneira inana. ");
INSERT INTO emi_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nau sinaka ateva ang ghe suusuu, laghe maea ngakapa sio taumattu asease isiki etaira, tani ghaa niaisausi ta Iesu. Ghe nim saasaoaa nimana etaira me laghe maamasina. ");
INSERT INTO emi_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Raroai etoa laghe kupikupi vulu ghoa taumattu ngatoa, me laghe samasama anamungaili, laghe ue va, “Io Natuna io God.” Iesu ghe paopaola me ghe ue ta raroai etoa va, “Am rau mene sama,” poli ila raroai etoa la kilakila va ia Mesaea ia. ");
INSERT INTO emi_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Elue talaua poopooa Iesu ghe ssola tale voto ateva karika righi taumattu etana, me laghe paepaea. Nau laghe taraiela, laghe auliaala etana va erau mene kasu. ");
INSERT INTO emi_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ghe uela etaira va, “Karika apoppooaa nonga etaimim. Atani ppooaa masi kiukiuna ararimangalina ateva God ta mene kasina masaliki taatara, mausina avalua o me Tamaghi ghe sungieghila.” ");
INSERT INTO emi_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Liuna avalua o me ghe poppooaa tale ale nivelu eitaua ngatoa eJiudia. ");
INSERT INTO emi_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kateva nau, Iesu ghe tiitingina elosamarra tale ateo talia ngateae eGenesaret, me oroieili taumattu ngatoa laghe mene tomuela, tani nongo inangarina ateva God. ");
INSERT INTO emi_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Me Iesu ghe tarala paanaka aluepai, lalu ghe vuuvukala tale ateo talia ngateae, me tau ngai pae kko atoa laghe kkure vululaluela, me laghe porapora uneira uvena. ");
INSERT INTO emi_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Me ghe aikaaila tale gharighi paanaka, unna ia Saemon, me ghe uela ta Saemon va esiki tee ghoa paanaka arighi mala masau elosamarra. Me ghe toka siola tale paanaka arighi, me ghe mene tiuaala tani apasunga. ");
INSERT INTO emi_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nau ghe ruula tani sama, me ghe uela ta Saemon va, “Ose tee ghoala elo malionge, me am velu sio uneimim uvena aighaa kko.” ");
INSERT INTO emi_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saemon ghe liula tani ue va, “Namu ngateva, eleivoo ami tootoonga poila tani luku, me karika poi ami ghaala teva, me elue talaua teeiemamila. Me poli angu aauliaa, aue amene ghoa velu sio isaa oia uvena.” ");
INSERT INTO emi_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Me nau eteva laghe velu siola uneira uvena, laghe ghaala oroieili kko, me uneira uvena ghaisa ngarighi ghe tarrii. ");
INSERT INTO emi_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Vara me angila ghe palepale lao mene kasina kapuira, laghe vuuvukala tale mene kateva paanaka, tani mae sausila. Me laghe mae sio, laghe kaaila kko tale paanaka alua, me ghaisa ngarighi lalu ghe vuluu. ");
INSERT INTO emi_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nau eteva Saemon Pita ghe tara avaluela o, ghe tturrula ta liue kkena Iesu, me ghe uela va, “Vau eteva, kasu vulueghila; ta aghi tau ssavoto ieghi.” ");
INSERT INTO emi_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Poli ia me kapuna atoa laghe soghiaala voto oia, nau laghe tarala, ");
INSERT INTO emi_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","me tee Jeimis me Jon, natuna ilalua Sebedi, lalu ghe uungu eitauaa tee Saemon. Me Iesu ghe uela ta Saemon va, “Karika umene matautu: aue llo to nau emaemae, aue utau ngai luku taumattu.” ");
INSERT INTO emi_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Me nau eteva laghe ssola elae, laghe kasu vulila isaa akapa voto me laghe usiela. ");
INSERT INTO emi_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kateva nau, Iesu ghe tokatoka tale kateae masaliki, me kateva taumattu, anna tasussuku eteva, ghe tarala Iesu, me ghe suuiaala ta liue kkena Iesu, me ghe uela etana va, “Vau eteva, marova ualoanna, urooroo tani ghelei eraarangisanaieghi ta mata God!” ");
INSERT INTO emi_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iesu ghe ssuuaala nimana, me ghe posoala, me ghe uela va, “Aghaaloanna. Angu raarangisanala!” Arovaeaata ta tasussuku eteva ghe kasu vulila taumattu ngateva. ");
INSERT INTO emi_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Iesu ghe uela etana va, “Urou mene kiukiu ta teva taumattu, ta ulaa tara mua pristi eteva, me ia aue eauliaa ta taumattu ngatoa va angu raarangisanala, me ughelei sae aiaavusuvusuena, nongina Moses ghe auliaala.” ");
INSERT INTO emi_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Me kiukiuna Iesu ghe kasu ekapa seela, me oroieili taumattu ghe mae sio tani nongoa, me ghe ghelei emasinailala. ");
INSERT INTO emi_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Me oroiaata nau ghe kasukasu vuli taumattu ngatoa, me ghe laolao tale voto karika righi taumattu etana, me ghe looloo sae. ");
INSERT INTO emi_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kateva nau, Iesu ghe mene aapasunga, me katoa Paresi me tau ngai aapasunga ngatoa tale inangari nipaopao, laghe mene mae sio tani toka. Laghe kasula eJerusalem, me isaa akapa lutu masaliki eGalilii me eJiudia. Me sarasarakaniaane Vau eteva ghe toka aitauaa teela Iesu, tani ghelei emasina lo atoa laghe iisiki. ");
INSERT INTO emi_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Katoa taumattu laghe sau mae sio kateva taita. Ia oia taita ateva riuna atoa matena ila, me ghe asoaso tale komona atiulu. Laghe aaloanna tani saue sso tale ale ateva tani taue lao ta Iesu. ");
INSERT INTO emi_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Me poli oroieili taumattu ghe tokatoka, me karika righi salana tani ssoainia, laghe saue saela epona tale pungani ngale ateva, laghe ghaa vella aiaakou, me laghe taue siola tee komona atiulu elome ta taumattu ngakapa atoa, me emua ta Iesu. ");
INSERT INTO emi_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nau eteva Iesu ghe tarala uneira niaiesoaa, me ghe uela ta taumattu ngateva va, “Kapughu, kalum ssavoto ange kapala!” ");
INSERT INTO emi_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tau ngai aapasunga ngatoa tale inangari nipaopao, me Paresi etoa, laghe tiuaala tani nnaa elome tale nannaaira va, “Saa taumattu ia ierai oia me eaauliaa saasakiaa tee God, nau egheeleia va eaairooa tee God! Poli God nonga erooroo tani kkaluaa ssavoto!” ");
INSERT INTO emi_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesu ghe kilala nannaaira, me ghe uela etaira va, “Vaalua me am nannaa isaa ona ase voto tale urunguitaniimim? ");
INSERT INTO emi_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Vaalua, malumina tani ue va, ‘Kalum ssavoto ange kapala,’ o tani ue va, ‘Tingina saela, me ukasu’? ");
INSERT INTO emi_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ghaine aghaloanna va am tara kila, va Natuna ateva Taumattu ngateva matuutuliena teeia tani kkaluaa ssavoto tale kosa ateva.” Me Iesu ghe uela ta taumattu ngateva oia va, “Aghaauliaa etam va, tingina saela, me usau komom, me ulao tanganuem!” ");
INSERT INTO emi_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Katengaata ta taumattu ngateva ghe tingina saela, ta mataira taumattu ngakapa atoa, ghe saula komona ghe asoaso etana, me ghe lao sio tanganuena, me ghe tau saela ararina ateae God. ");
INSERT INTO emi_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Taumattu ngakapa atoa laghe soghiaala isaa oia voto ghe lutula. Laghe matautula, me ila tee laghe tau saela God, laghe ue va, “Ngami tarala kateva ase voto ghaine!” ");
INSERT INTO emi_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Emulina, Iesu ghe laolao, me ghe tarala tau ngai ghaa takis eteva, ararina ateae ta Livae, ghe tokatoka tale natu ngale arighi aighaa takis ia. Iesu ghe uela etana va, “Mae usieghi.” ");
INSERT INTO emi_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Livae ghe tingina saela, ghe kasu vuli ekapaailiila voto, me ghe usiela. ");
INSERT INTO emi_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Me Livae ghe gheleila kinatama ninamanama ateae tanganuena mausi Iesu, me tale ninamanama ateae, oroieili tau ngai ghaa takis atoa, me mene katoa taumattu, laghe toka aitauaa teeilaluela. ");
INSERT INTO emi_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Paresi etoa me tau ngai aapasunga ngatoa tale inangari nipaopao, ila tee Paresi ila, angila ghe samasama anamuu kapuna disaepolo atoa Iesu. Laghe ue va, “Vaalua me am namanama me am ropiropi, aitauaa tee tau ngai ghaa takis atoa me tau ssavoto atoa?” ");
INSERT INTO emi_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Me Iesu ghe liula inangariira me ghe uela va, “Karika va masina atoa la laa taatara dokta, ta isikinna atoa. ");
INSERT INTO emi_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Karika aghe sio mae tani kolo ghulughuluena taumattu, ta aghe sio mae tani kolo tau ssavoto atoa tani nna ngaioghioghiaa.” ");
INSERT INTO emi_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Me taumattu ngatoa laghe uela ta Iesu va, “Oroiaata nau, kapuna disaepolo atoa Jon laghe naenae, me laghe looloo sae, me kapuira disaepolo tee atoa Paresi etoa, la gheelei evalua o. Me io, kapum disaepolo atoa la tam naenae.” ");
INSERT INTO emi_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Me Iesu ghe uela va, “Marova kateva taita ealoanna tani lai, koti aue am auliaa ta kapuna atoa va la rau mene namanama, nau eteva ia o taita ateva etokatoka teeila? Karika! ");
INSERT INTO emi_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Me auena, nau la vira ghaaghaa velu taita ateva, ia o nau eteva, la vira nae.” ");
INSERT INTO emi_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iesu ghe auliaa teela kateae kiukiu niaimatoonga etaira va, “Marova pokane ateva aiaasae ange tarriila, karika teva taumattu erooroo tani mene rasi ouna ateva aiaasae, tani samapi tarrii eteva tale pokane ateva aiaasae. Marova egheelei evalua o, aue eghelei kiikiiuaa ouna ateva aiaasae, me tee ia o ouna ateva aiaasae, karika aue masina tee pokane ateva aiaasae. ");
INSERT INTO emi_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Karika teva taumattu etottoli kaai ouna uaeni tale pokane ateva aikaai gheelei tale viliki meemee. Marova eghelei evalua o, aue ouna uaeni eghelei polaki aikaai eteva, me aue ilalua akapa uaeni eteva me aikaaina ateva aue lalu peisaane. ");
INSERT INTO emi_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Liuna avalua o me la tottoli kaai ouna uaeni tale ouna aikaai manu gheelei tale viliki meemee. ");
INSERT INTO emi_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Me lo atoa taumattu la ropiropi pokane uaeni, karika aue la aloanna ouna. La ue va, ‘Llo pokane masinaaili.’” ");
INSERT INTO emi_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kateva nau manga, Iesu ghe kasu longotila tale utani uiti eteae. Kapuna disaepolo atoa laghe ghaala kasina tana uiti, me laghe sapusapulaa vella vilikina ta nimaira, me laghe namala. ");
INSERT INTO emi_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Katoa tana Paresi laghe uela etaira va, “Vaalua me am gheelei voto ona, inangari nipaopao eue va karika masina tani ghelei tale nau manga ateva?” ");
INSERT INTO emi_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iesu ghe liula me ghe uela etaira va, “Koti karika am ghe ritila kiukiuna ateae Deivit, nau ia me kapuna atoa laghe maloola, ");
INSERT INTO emi_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","me ghe ssola tale alena ateva God, me ghe ghaala verete laghe amangala, me ghe namala, me ghe tau lao sio tee ta lo atoa laghe kasukasu teeia. Isaa oia verete karika erooroo va nim taumattu enama, ta pristi nonga atoa.” ");
INSERT INTO emi_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Me Iesu ghe uela etaira va, “Natuna ateva Taumattu ngateva Vau ia tale nau manga ateva.” ");
INSERT INTO emi_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mene kateva nau manga, Iesu ghe kupi ssola tale ale nivelu eitaua ngateva tani ppooaa, me kateva taita ghe tokatoka, nimane muenna atelange matena ia. ");
INSERT INTO emi_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tau ngai aapasunga ngatoa tale inangari nipaopao, me Paresi etoa, laghe taatara usiusi Iesu, laghe aloanna tani kila va aue eghelei emasina tau sessa atoa ta nau manga ateva, o karika. Laghe paepae righi salana tani laoaa Iesu tale niaisakei. ");
INSERT INTO emi_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Me Iesu ang ghe kila vella nannaaira, me ghe uela ta taumattu ngateva, nimana atelange matena ia, va, “Tingina saela, me la taraio.” Me ghe tingina saela. ");
INSERT INTO emi_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Me Iesu ghe uela etaira va, “Aghaloanna tani kolomiem kateva voto. Emaamasina tani ghelei masi voto, o sesa voto, ta nau manga ateva? Tani asaangi maamauluaa kateva taumattu, o tani turungia?” ");
INSERT INTO emi_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ghe aitara ngakapa seela etaira, me ghe uela ta taumattu ngateva va, “Korosila nimam atelange.” Me ghe gheleila, me nimana atelange ghe masinala nongina emua arau. ");
INSERT INTO emi_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Me tau ngai aapasunga ngatoa tale inangari nipaopao, me Paresi etoa, ghe sessai etinginailala. Me angila ghe aailoe va, “Sa ateva ita gheleia ta Iesu?” ");
INSERT INTO emi_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kateva nau tale isaa o nau, me Iesu ghe saela tale motouru tani looloo sae, ghe looloo saela ta God tale ia o voo ngateva, lomosi ta ghe paila. ");
INSERT INTO emi_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nau eteva ghe paila, ghe kolo aitauaala kapuna disaepolo atoa, me ghe suitoongaala kasangaulu ghalua (12), me ghe mene aselala va apostolo ila. ");
INSERT INTO emi_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kateva ta Saemon (Iesu ghe aseala va Pita etana), me ghe kolo teela Andru, tue me nenga ilalua me Saemon, me Jeimis, me Jon, me Pilip, me Batolomiu, ");
INSERT INTO emi_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","me Matiu me Tomas, Jeimis natuna ia Alpeas, me Saemon laghe asease Selot etana, ");
INSERT INTO emi_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","me Jiudas natuna ia Jeimis, me Jiudas Iskariot, ia auena ghe tau lao Iesu ta nimaira tau ngai ssateena atoa. ");
INSERT INTO emi_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iesu me ila o kapuna disaepolo atoa, laghe sio mae tale motouru eteva, me laghe tinginala tale malaale. Ia, me oroieili kapuna disaepolo atoa, me oroieili tee taumattu, laghe kasula tale distriki eteva eJiudia, me masaliki taatara ateae eJerusalem, me tale samarra ateva kalakalangina tale masaliki taatara aluae eTaer me eSaedon, ");
INSERT INTO emi_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","laghe mae sio tani nongoa, me laghe maeaa tee sio kapuira tau sessa atoa va la masina. Me lo atoa tee sesa spiriti eteva ghe tokatoka etaira, Iesu ghe ghelei emasinailala. ");
INSERT INTO emi_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Me oroieili taumattu angila ghe paepaea tani nim tulia, poli sarasarakana ghe kasukasu etana, me ghe ghelei emasina akapailala. ");
INSERT INTO emi_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu ghe taatara lao sio ta kapuna disaepolo atoa, me ghe uela va, “Aue emasinaaili ta lo atoa karika tue peipeiena am, poli ararimangalina ateva God kaluimmi ia. ");
INSERT INTO emi_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Aue emasinaaili ta lo atoa ghaine am maamaloo, ta auena essoiem. Aue emasinaaili ta lo atoa ghaine am aalousiusi, ta auena am kanga. ");
INSERT INTO emi_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Aue emasinaaili etaimim nau eteva taumattu ngatoa la sessa teeiem, me nau eteva la aatoka apolapolaiem, me la lakolakoam, me la ue va, ‘Io sesa taumattu io,’ mausi Natuna ateva Taumattu ngateva! ");
INSERT INTO emi_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Am rooroo tani masimasi nau eteva llo o elutu, me am loku, me am masimasi, poli namungaili aipoliimim etoitoiem epona liu. Nongina emua arau, tuvuira atoa laghe gheleila isaa oia voto ta propete atoa. ");
INSERT INTO emi_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Me am lo atoa tue peipeiena am, aue esesaaili etaimim, poli nimasimasi ghaine am ghaaghaa, auena ekarika. ");
INSERT INTO emi_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Me am lo atoa ghaine esossoiem, aue esesaaili etaimim; auena am maloo! Me lo atoa ghaine am kangkanga, aue esesaaili etaimim; auena am alousiusi me am ngala! ");
INSERT INTO emi_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Me marova taumattu ngakapa atoa la aasaesae arariimim, aue esesaaili etaimim; nongina emua arau, tuvuira atoa laghe gheleila isaa oia voto ta propete kamekame atoa. ");
INSERT INTO emi_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Me aghaauliaa ta lo atoa am nongonongo, va am ailousiaa tau ngai ssateeimim atoa, am ghelei masi niuungu ta lo atoa la sessa teeiem. ");
INSERT INTO emi_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Am arangise lo atoa la poppooaa saasakiaa teeiem, me am pure ta lo atoa la aloanna tani ghelei saasakieiniem. ");
INSERT INTO emi_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Me marova teva eposala kativilau bbam, utau lao mene kativilau me eposala teeia; me marova teva taumattu ealoanna tani ghaa unem aiaasae ngeleka ateva, masina eghaa tee unem sioto ateva. ");
INSERT INTO emi_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Utau lao peim ta lo ateva ekolomio, me marova lo ateva ange ghaala righi peim, urau mene kolomia va emene kiriaa mae. ");
INSERT INTO emi_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Am ghelei voto ta mene kateva taumattu nongina am aloanna va emene ghelei mae etaimim. ");
INSERT INTO emi_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Marova am ailousiaa nonga lo atoa la aailousieiniem, vaalua me am aaloanna tani ghaa nimasimasi? Poli tau ngai gheelei ssavoto atoa tee la ailousiaa lo atoa la aailousieinila! ");
INSERT INTO emi_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Me marova am gheelei emasina ta lo atoa la gheelei emasina etaimim, vaalua me am aaloanna tani ghaa nimasimasi? Tau ngai gheelei ssavoto tee atoa, la gheelei evalua o! ");
INSERT INTO emi_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Me marova am tau viliki veu nonga ta lo atoa am nannaa va ila aue la mene liu etaimim, vaalua me am aaloanna tani ghaa nimasimasi? Tau ngai gheelei ssavoto tee atoa la tautau viliki veu ta tau ngai gheelei ssavoto atoa, me ila tee la annaa va aue la ghaa ailiuliu! ");
INSERT INTO emi_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Am ailousiaa tau ngai ssateeimim atoa, me am ghelei masi voto etaira; am aiparruaa viliki veu, me am rau mene nnaa va am mene ghaa ailiuna. Poli am, aue am ghaa namungaili aipolipoli, me aue natuna iem lo ateva Iaaili Epona. Ta egheelei masina ta lo atoa karika la kaakaili emasina me lo atoa sesa gheeleiaaira. ");
INSERT INTO emi_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Am alousiusi tee mene katoa taumattu, nongina Tamaimim ateva eaalousiusi teeiem.” ");
INSERT INTO emi_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Iesu ghe mene uela va, “Am rau mene ue va katoa nonga taumattu la gheelei ssavoto, me God karika aue eue teeiem va am tee am gheelei ssavoto; am rau mene sunganaa tau lao sesa aipolipoli ta kateva; me God karika aue esunganaa tau aatu sesa aipolipoli etaimim. Am kkaluaa gheeleiaa kateva taumattu, me God aue ekkaluaa gheeleiaaimim. ");
INSERT INTO emi_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Am parruu, aue God emene tau aatu etaimim; ekaai, me emonnaa tau sio, me emene kaai, me aue epasu, me aue ekao velu kasina. Llo am tautau lao ta katoa, aue God emene tau aatu nongina am tautaula.” ");
INSERT INTO emi_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iesu ghe kiukiuaala kateae kiukiu niaimatoonga, “Teva mata salusalu karika erooroo tani katulaa mene teva mata salusalu; marova egheelei, aue lalu katuu velu sio tale liu eteva. ");
INSERT INTO emi_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tau ngai ghaa alomasaanga ateva karika namuu ia ta kapuna tau ngai aapasunga ngateva. Nau ange kila akapala voto, aue enongina kapuna tau ngai aapasunga ngateva. ");
INSERT INTO emi_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Vaalua me utaatara nonga vongovongo ta matana kapum ateva, me karika utaatara paka palanga ateva ta matam? ");
INSERT INTO emi_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Vaalua me ualoanna tani ue ta kapum ateva va, ‘Kapughu, aghaaloanna tani ghaa velu tuku vongovongo ateva ta matam,’ me io karika urooroo tani tara paka palanga ateva ta matam? Usimaghalue io, ughaa velu mua paka palanga ateva ta matam, me utaatara amasina tani ghaa velu tuku vongovongo ateva ta matana kapum ateva. ");
INSERT INTO emi_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Masi ai eteae karika ekuukuneaa sesa ue ngai, tee sesa ai eteae karika ekuukuneaa masi ue ngai. ");
INSERT INTO emi_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Isaa akapa ai la taatara kila tale ueira la kuukuneaa. Karika am ghaaghaa ue ngai tale uasa karasa atikirighi, me ue uasa tale ai rorroana ateae. ");
INSERT INTO emi_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Masi taumattu ngateva eaapasunga masi voto tale masi urunguitanina ateva, me sesa taumattu ngateva, sesa voto eghooa tale llo sesa etokatoka tale urunguitanina ateva. Sesa voto taumattu ngateva egheelei, etokatoka tale urunguitanina ateva, eaapasunga nau eteva eaaippooaa.” ");
INSERT INTO emi_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Iesu ghe mene auliaa tee lao sio va, “Vaalua me am aseaseaghi va, ‘Vau eteva,’ me karika am gheelei nongina aghaauliaa? ");
INSERT INTO emi_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Aue aghapasunga va saa taumattu ia lo ateva emaemae etaghi, me enongonongo inangarighi, me eaimulusi tee. ");
INSERT INTO emi_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ia nongina lo ateva taumattu ghe kai liu siola, me ghe atulula alena ateva epona tale atu. Nau eteva ateo ateae ghe ghoala, me ghe akala poila ale ateva, karika poi ghe aisiisiaala, poli ghe atulu ekorokoronganaailiiela. ");
INSERT INTO emi_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Me lo ateva taumattu enongonongo inangarighi, me karika egheelei, ia nongina lo ateva taumattu ghe atulula alena ateva tale kosa karika korokorongana. Me nau eteva ateo ateae ghe ghoala, me ghe akalala ale ateva, ale ateva ghe katuula, me ghe akalainiela.” ");
INSERT INTO emi_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nau eteva Iesu ghe ruula tani auliaa isaa o voto ta nongonongoaa taumattu ngatoa, me ghe ssola eKapenium. ");
INSERT INTO emi_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kateva namuu ghe aaitoiaa kateva ai (100) tau ngai uvii, kapuna tau ngai nongonongo anna ateva ghe isikila, me ghe aailousiangailiia, me ang ghe aainasiaa tani mate. ");
INSERT INTO emi_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Namu ngateva ta tau ngai uvii etoa ghe nongola va Iesu ang ghe rekatala, me ghe suula namuu ta aJiu etoa, tani laa koloa va emae ghelei emasina kapuna tau ngai nongonongo anna ateva. ");
INSERT INTO emi_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nau laghe lao sio ta Iesu laghe aipoopoliangaili tani kolo Iesu, me laghe ue va, “Utani sausia, ");
INSERT INTO emi_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","poli eailousiangailiita aJiu etoa, me ghe sausitala tani atulu aleita ale nivelu eitaua ngateva.” ");
INSERT INTO emi_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Liuna avalua o me Iesu ghe usilala. Ang ghe aakalakalaa tanganuena, me namu ngateva ta tau ngai uvii etoa ghe suula kapuna atoa tani laa ue etana va, “Vau eteva, urau mene nnaa. Karika masina ieghi va umae tanganueghi. ");
INSERT INTO emi_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mausina avalua o me karika ataataraieghi va masi taumattu ieghi tani mae taraio. Anim anna va uppooaa teva tuku inangari, me aue kapughu tau ngai nongonongo anna ateva emasina. ");
INSERT INTO emi_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Aghi tee auungu ta namu ngatoa, me aghaaitoiaa katoa tani tau ngai uvii. Arova aue ta kateva va, ‘Lao sio,’ aue elao, va aue va, ‘Mae sio,’ aue emae, me arova aghele ue ta kapughu tau ngai nongonongo anna ateva va, ‘Gheleila llo toko,’ egheelei.” ");
INSERT INTO emi_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iesu ghe soghieiniela nau ghe nongoala. Ghe kiriela, me ghe taatara lao sio ta taumattu ngatoa laghe aaimuli teeia, me ghe uela va, “Aghaauliaa etaimim va ia oia ase niaikaaia ngateva namuu ia, karika aghe tara poia eIsraeli.” ");
INSERT INTO emi_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Me taumattu ngatoa ghe sungilala, laghe oghi lao sio elo ale, me laghe tarala tau ngai nongonongo anna ateva, ta ang ghe masinala. ");
INSERT INTO emi_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kasina nau ghe lange sio, me Iesu ghe lao sio tale masaliki eteae eNain. Kapuna disaepolo atoa me tana taumattu ngatoa laghe usiela tani lao. ");
INSERT INTO emi_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nau ang ghe reerekata tale namu ngateae atamana tale ia o masaliki eteae, me ngeila ghe sausau emae ghooa taumattu ngateva matena ia. Vause ateva raue vulu ia, ie nonga o natuna ateva ghe matela. Me oroieili taumattu tale ia o masaliki eteae laghe usiusi kinna. ");
INSERT INTO emi_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nau Vau eteva ghe taraiela, urunguitanina ateva ghe alousiusi teeiela, me ghe uela etana va, “Urou mene ngala.” ");
INSERT INTO emi_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ghe lao sio tale aisalo ateae laghe sausaua etana, me ghe posoala, me lo atoa laghe sausaua laghe matua atinginala. Me ghe uela va, “Taita ateva, aghaauliaa etam va totula!” ");
INSERT INTO emi_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Taumattu ngateva matena ia ghe totu etokala, me ghe tiuaala tani sama. Me Iesu ghe taue lao sio ta kinna. ");
INSERT INTO emi_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Taumattu ngatoa laghe soghiaala, me laghe tau saela God, me laghe ue va, “Propete ateva namuu ia ange rekataala elome etaita. Me God ange mae sio tani sausi kapuna taumattu ngatoa.” ");
INSERT INTO emi_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Isaa o kiukiuna Iesu ghe kasu ekapa seela eJiudia, me tale distriki kalakalangina eJiudia. ");
INSERT INTO emi_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Kapuna disaepolo atoa Jon laghe aulia ngakapala isaa o kiukiu etana. Ghe kolola ghalua, ");
INSERT INTO emi_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","me ghe sungilaluela va lalu laa kolomi Vau eteva va, “Io ia o taumattu ngateva laghe uela va aue emae, o aue ami mene toi ppae mene teva?” ");
INSERT INTO emi_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nau lalu ghe laa rekata sio ta Iesu, lalu ghe uela ta Iesu va, “Jon tau ngai aasuu ia esungiengaluela tani mae kolomio va, ‘Io ia o taumattu ngateva laghe uela va aue emae, o ami mene toi ppae mene teva?’” ");
INSERT INTO emi_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ia o nau eteva, Iesu ghe ghelei emasinala oroi taumattu tau sessa, me lo atoa raroai etoa laghe tokatoka etaira, me ghe gheleila mata salusaluna atoa laghe taatarala. ");
INSERT INTO emi_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ghe liula ta lo atoa Jon ghe sungilala va, “Am oghi lao sio, me am laa ghauliaa ta Jon llo ngam tarala, me ngam nongola. Mata salusaluna atoa la taatarala, me vereverenna atoa la kasukasula me tasussukuna atoa la raarangisanala, me talinga volongo atoa la nongonongola, me matena atoa la totula, me lo atoa karika peiira la nongola masi kiukiu. ");
INSERT INTO emi_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Me aue emasinaaili ta taumattu ngateva, unna niaiesoaa etam kaakatuu vulueghi.” ");
INSERT INTO emi_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Vara me lo atoa Jon ghe sungilala laghe kasula, me Iesu ghe tiuaala tani auliaa Jon ta taumattu ngatoa. Ghe ue va, “Sa ateva am ghe ssola tani taraia tale voto ateva karika righi taumattu etana? Pitpiti eteva ghe kuukuueinia? ");
INSERT INTO emi_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Arova karika, tani sa ateva am ghe kasueiniela tani sso taraia? Teva taumattu ghe aasae righi masi ghinna? Karika va isaa avalua o, ta lo atoa la asae masi ghinna, me la tokatoka tale masi nitoka, la tokatoka tanganuena king. ");
INSERT INTO emi_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tani sa ateva am ghe kasula tani sso taraia? Propete ateva? Aghaauliaa etaimim va ue, me emene laulau mene katoa propete. ");
INSERT INTO emi_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ia o taumattu ngateva, Uru ngai Manga ateva ghe aaulieinia nau ghe uela va, “‘Tarala, aue asuu aikasuaa inangarighi eteva emuemueinio, me ia aue eaimonomonosiaa ngamuemue ngalokoi salam.’ ");
INSERT INTO emi_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Aghaauliaa etaimim va, ta lo atoa laghe lutula tale kosa ateva oia, karika teva erooroo ta Jon. Me lo ateva karika teae ararina, me iaaili euu tale ararimangalina ateva God, elaulau Jon.” ");
INSERT INTO emi_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Taumattu ngakapa atoa, me tau ngai ghaa takis atoa, nau laghe nongola inangarina Iesu, laghe akoronnala va salane God koronna, poli Jon ghe asuulala. ");
INSERT INTO emi_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Paresi etoa me lo atoa tau ngalomasaanga ila tale inangari nipaopao, laghe ratila aloaloannaane God etaira poli karika va Jon ghe asuulala.) ");
INSERT INTO emi_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Me Iesu ghe mene uela va, “Sa ateva voto arooroo tani auliaa me eaimatoonga taumattu tale lo ateva oia vituu? Me ila saa taumattu ngila? ");
INSERT INTO emi_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ila nonginaaili aliki etoa la tokatoka tale liu nianamisi, katoa la ue lao ta mene lutu katoa va, “‘Ami ghe vuuvuu kkinari nilai eteae etaimim, me karika am ghe lokuloku; ami ghe uuei kkinari nialousiusi, me karika am ghe ngangngala.’ ");
INSERT INTO emi_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nau Jon tau ngai aasuu ia ghe mae sio, me karika ghe namanama verete, me karika ghe ropiropi uaeni, am ue va, ‘Raroai eteva ghe tokatoka etana.’ ");
INSERT INTO emi_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Me nau Natuna ateva Taumattu ngateva ghe mae sio, me ghe namanama, me ghe ropiropi, am ue va, ‘Tau ninamanama ia, me tau niropiropi ia, me kapuira ia tau ngai ghaa takis atoa, me tau ssavoto atoa.’ ");
INSERT INTO emi_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Masi ninannaa kanna God eaapasunga va koronna ia tale maamauluaaira lo akapa atoa la aaimuli teeia.” ");
INSERT INTO emi_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kateva Paresi ghe kolola Iesu va ghe laa namanama teeia tanganuena. Liuna avalua o me Iesu ghe lao sio tanganuena, me ghe lao sio tale tevoo tani namanama. ");
INSERT INTO emi_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kateva vause tale ia o masaliki eteae, tau ngai ghelei ssavoto ia, ghe nongola va Iesu ghe namanama tanganuena Paresi eteva. Liuna avalua o me ghe ghaa lao sio aikaai eteva alabasta ia, pasu ia tale aiaaoo masinaaili ngusungusuaane. ");
INSERT INTO emi_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ghe suuiaala emuli ta liue kkena Iesu, me ghe tiuaala tani ngala, me ghe apposi kkena Iesu tale rarum matane, me ghe uluulu tale uu nguruna, me ghe nguungusuaa kkena, me ghe kaokao masi aiaaoo. ");
INSERT INTO emi_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Paresi eteva ghe koloala ghe tarala isaa o voto, me ghe tiuaala tani nna ngainao elome etana va, “Arova taumattu ngateva oia va propete ia, aue ghele kila va see eposoposoa, ta vause ateva oia tau ssavoto ia.” ");
INSERT INTO emi_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iesu ghe liula etana me ghe uela va, “Saemon, aghanna tani auliaa kateva voto ta ngetam.” Saemon ghe liula me ghe uela va, “Tisa, aulieiniela.” ");
INSERT INTO emi_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Iesu ghe kiukiuaala kiukiu eteae, ghe uela va, “Taumattu ngalua lalu ghe ghaala viliki veu pei niliu ta kateva taumattu. Kateva ghe ghaala ghalima ai (500) silva koen, me mene kateva ghe ghaala ghalimangaulu (50). ");
INSERT INTO emi_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Karika teva etairarua ghe roola tani liu unna viliki veu lao taumattu ngateva. Liuna avalua o me ghe uela va unna viliki veu pei niliu enim vulla. See etairarua aue eailousiangaili ia o taumattu ngateva?” ");
INSERT INTO emi_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saemon ghe liula me ghe uela va, “Aghannaa va koti lo ateva taumattu, unna viliki veu pei niliu oroi.” Iesu ghe liula me ghe uela va, “Angu aulia ngakoronnala.” ");
INSERT INTO emi_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Vara me ghe kiriela, me ghe taatara lao sio ta vause ateva, me ghe uela ta Saemon va, “Tarala vause ateva o. Amae sio tanganuem, me karika utau mae sio righi manu aipora kkeghi. Eporala kkeghi tale rarum matane, me eulula tale uu nguruna. ");
INSERT INTO emi_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Karika ungusueghila nau arekatala, me ia, nau akupi sso mae arau, karika ghe ruu poi tani ngusu kkeghi. ");
INSERT INTO emi_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Io karika ukaola righi oeli ta urughu, me ia ekaola llo masi ngusungusuaane ta kkeghi. ");
INSERT INTO emi_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Liuna avalua o me aghaauliaa etam va kanna ssavoto oroieili, ange kapala, liuna avalua o me ailousiaane namungaili. Me lo ateva karika oroi llo laghe kkaluaala etana, aielousiaane karika namuu.” ");
INSERT INTO emi_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Me Iesu ghe uela ta vause ateva va, “Kalum ssavoto ange kapala.” ");
INSERT INTO emi_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mene katoa laghe kololala tani mae namanama, laghe ue elome etaira va, “See etana ierai, me eue va ekakkaluaa ssavoto?” ");
INSERT INTO emi_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Iesu ghe uela ta vause ateva va, “Kalum niaikaaiaa ange asaangiola. Kasula tale luei.” ");
INSERT INTO emi_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Emulina, Iesu ghe lao sio tale mene kasina masaliki taatara me llo masaliki ghauna, tani ppooaa masi kiukiu tale ararimangalina ateva God. Kasangaulu ghalua (12) disaepolo laghe usiusia, ");
INSERT INTO emi_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","me tee lo atoa vause Iesu ghe tiu vella raroai etoa me ghe ghaa vella isiki etoa etaira; Meri aMakdala ia, lo ateva vause ghaitu (7) raroai laghe kupi ghoala etana; ");
INSERT INTO emi_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana vausenna ia Kusa (Kusa ia namuu ia ta lo atoa laghe aaitaraa voto tale paa ngalena ateva Herot); Susana; me oroila mene katoa vause. Ila laghe saasausi Iesu me kapuna atoa tani tau lao peiira me viliki veu tani sausi niuungu. ");
INSERT INTO emi_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Taumattu ngatoa laghe kasukasu tale masaliki taatara atoa tani mae tara Iesu. Nau laghe oroieili ila, me Iesu ghe auliaala kiukiu niaimatoongana ateae, ghe uela va, ");
INSERT INTO emi_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Tau ngai pasa katu ue ngai eteva ghe kasula tani pasa katu ue ngai. Nau eteva ghe kaokaoaala katu ue ngai, kasina katu ue ngai ghe katuula tapaa salana, me laghe asala me ghila atoa laghe namala. ");
INSERT INTO emi_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kasina ghe katuula tale voto ateva sakolo ia. Nau eteva ghe piipinosa, ghe mallela me ghe mmatela, ta poli euu atu ia, me karika righi manu. ");
INSERT INTO emi_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kasina ghe katuu ssola elome tale uasa karasa atoa, me nau eteva laghe pinosa aitauaa teela uasa karasa atoa, uasa karasa atoa laghe kavili ematelala. ");
INSERT INTO emi_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kasina ghe katuula tale masi kosa. Ghe pinosala me ghe kuneaala katu ue ngai ghe roola kateva ai (100), me ghe laula ooroiaa llo katu ue ngai ekasina ghe kaokaoaala.” Nau eteva ghe ruula tani kiukiu, ghe sama anamuula me ghe uela va, “Lo ateva talingane manee tani nongo, aue enongo.” ");
INSERT INTO emi_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kapuna disaepolo atoa Iesu laghe kolomiela tale malloeanina kiukiu niaimatoongana ateae. ");
INSERT INTO emi_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Iesu ghe uela va, “Alomasaanga tale voto eaaisulia tale ararimangalina ateva God, Tamaghi ghe tau aatu sio etaimim, me ta mene katoa aghaauliaa kiukiu niaimatoonga, poli, “‘La taatara, me karika aue la tara kila; la nongonongo me karika la aalomasaanga tee.’ ");
INSERT INTO emi_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Malloeanina kiukiu niaimatoongana ateae ia avalua toko va: Katu ue ngai eaaimatoonga inangarina ateva God. ");
INSERT INTO emi_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Llo ghe katuula etapaa salana eaaimatoonga lo atoa la nongonongo, vara me namu ngateva ta raroai etoa emaemae, me eghaaghaa velu inangari tale urunguitaniira. Liuna avalua o me karika aue la aikaaiaa me la saanga. ");
INSERT INTO emi_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Llo tale voto ateva sakolo ia, aue la masimasi tani nongo inangarina God, me aikaaiaaira karika aluse, ta poli karika righi oaira. Nau nitootoonga emae, aue la katuu vulu God. ");
INSERT INTO emi_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Llo katu ue ngai ghe katuu ssola elome tale uasa karasa eaaimatoonga lo atoa la nongonongo, me nau la tokatoka, la nannangaili asease voto atoa, me la aloanna tani tue peipeiena, me la aloanna tani ghaa voto aue eaamasimasi maamauluaaira, me isaa o voto aue ekavili ekatungila. Me karika aue la kuneaa righi uene. ");
INSERT INTO emi_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Katu ue ngai tale masi kosa eaaimatoonga lo atoa masina nannaaira me urunguitaniira masina, la nongonongo aikaaiaa inangari, me la posoposo parasi tale inangarina ateva God me la kuukuneaa masi ue ngai. ");
INSERT INTO emi_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Karika teva eaarokoti lam ateae me eaakou rungainia tale teva aiaku manu, me eaatoka pakeainia tale aisalo. Ta eaatokaie sae tale aitiitinginane ateva, me lo atoa la kupi sso tale ale ateva, aue la taatara etana. ");
INSERT INTO emi_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Me karika righi voto eaaisulia va aue etam otu, me karika righi voto la aituttuia va aue etam otu, va taumattu ngakapa atoa karika aue la kila. ");
INSERT INTO emi_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Lo ateva righi voto etana, God aue emene tau lao kasina etana; me lo ateva karika righi voto etana, voto eannaa va isaa etana, God aue eghaa velu etana.” ");
INSERT INTO emi_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Vara me kinna Iesu me nengane atoa laghe mae sio tani tara Iesu, karika laghe roola tani lao akalakalangina ta Iesu, poli oroieili taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Katoa laghe auliaala ta Iesu va, “Kinam me nengam atoa ila eleka, me la ghaloanna tani taraio.” ");
INSERT INTO emi_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Iesu ghe liula me ghe uela va, “Lo atoa la nongonongo inangarina ateva God me la gheelei uunguaane, ila kinaghi ila me nengaghi ila.” ");
INSERT INTO emi_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kateva nau Iesu me kapuna disaepolo atoa laghe aikaaila tale paanaka ateva, me Iesu ghe uela va, “Ita lao tale pai kativilau tale ateo talia ngateae.” Vara me laghe tiu ghoala. ");
INSERT INTO emi_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nau eteva laghe oseose elaolao, Iesu ghe asekanue alokoila, me ghe llusula. Paka kuukuu ttasi eteva ghe lutu teeilala, me ang ghe aavuluu paanaka ateva, me laghe tokala tale paka nimoia. ");
INSERT INTO emi_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Disaepolo atoa laghe angunila Iesu me laghe uela va, “Vau eteva, vau eteva, ngita raaraua!” Iesu ghe tingina saela me ghe paola kuukuu eteva me paka kotoo atoa laghe aakope, me ttasi eteva ghe kapala, me luei eteva ghe asola. ");
INSERT INTO emi_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ghe kolomila kapuna disaepolo atoa va, “Vaalua karika righi aikaaiaaimim?” Tale nimoia laghe soghiaala voto oia ghe lutula, me ngila ghe aaikolomieinila va, “Saa taumattu ia lo ateva oia? Esamasama tee ttasi eteva me kotoo atoa, me la nongonongo usilainia.” ");
INSERT INTO emi_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Laghe ose lao sio tanganue aGerasa ngatoa, tale mene pai kativilau eGalilii. ");
INSERT INTO emi_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nau Iesu ghe tingina ssola elae, taita ateva, raroai etoa laghe tokatoka etana, tale masaliki taatara ateae, ghe ghoa mae tani sou Iesu. Oroi nau ang ghe lao sio ghe tam aasae righi ghinna, me ghe tam tokatoka tale teva ale ta ghe tokatoka tale liu niaikkaiaa. ");
INSERT INTO emi_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nau ghe tarala Iesu ghe aore anamungailiila, me ghe tturru siola ta liue kkena Iesu, me namungaili ta ghe samala me ghe uela va, “Sa ateva ualoannaia etaghi Iesu, Natuna io God iaaili Epona? Aghaaloanna va urau mene ghelei righi sesa etaghi!” ");
INSERT INTO emi_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Poli Iesu ghe aulia ngasarasarakanala ta raroai etoa va la kupi vulu ghoa ia o taumattu ngateva. Oroiaata raroai etoa ngila ghe tokala etana, liuna avalua o me nau laghe iriiri poi nimane me kkena tale sene, me taumattu ngateva ghe aaitoiaa poia, ghe gheeghelei patepate sene, me raroai etoa laghe kookoueinie see tale voto karika righi taumattu etana. ");
INSERT INTO emi_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iesu ghe kolomiela va, “See ia ararim ateae?” Ghe liula va, “Aghi Liijen,” ta oroi raroai etoa laghe tokatoka etana. ");
INSERT INTO emi_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Me laghe aipoopolia ta Iesu va ghe rau mene suu vella lao tale liu eteva karika aioghioghi etana. ");
INSERT INTO emi_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Oroieili mosu ghe tingina suesue see tale motouru. Raroai etoa laghe kookolomi esarasarakanaaili ta Iesu va etau vella me la laa kupi sso ta mosu etoa, me Iesu ghe tau vellala. ");
INSERT INTO emi_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nau eteva raroai etoa laghe kasu vulila taumattu ngateva oia, laghe kupila mosu etoa, me mosu etoa laghe aikarati velu siola tale voto ateva siosiona ia, me laghe aoso velu siola tale ateo talia ngateae, me ghe arropi ematelala. ");
INSERT INTO emi_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Lo atoa laghe aaitaraa mosu, laghe tarala vaalua isaa o voto ghe lutula. Laghe iloula tani laa kkailaa tale masaliki taatara ateae, me mene kasina lutu masaliki kalakalangina. ");
INSERT INTO emi_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Me taumattu ngatoa laghe lao sio tani tara isaa o voto ghe lutula. Nau eteva laghe mae sio ta Iesu, laghe tarala taumattu ngateva ia o raroai etoa laghe kasu vuliela, ghe tokatoka ta liue kkena Iesu, ghe molu etokala, me nannaane ang ghe masinala; me laghe matautula. ");
INSERT INTO emi_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Lo atoa laghe tarala, laghe auliaala kiukiuna taumattu ngateva oia, raroai etoa etana, saa voto ghe lutula, me ghe masinala. ");
INSERT INTO emi_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Isaa avalua o me taumattu tale masaliki eteae eGerasa me llo masaliki kalakalaa etana, laghe kolomila Iesu va ekasu, poli paka nimoia ateva ghe ghaailala. Iesu ghe aikaaila tale paanaka ateva, me laghe aimonomonosiaala tani kasu. ");
INSERT INTO emi_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Taumattu ngateva raroai etoa laghe kasu vuliela, ghe aloannaaili tani usi Iesu. Iesu ghe sungi aaoghiela, me ghe uela etana va, ");
INSERT INTO emi_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ukiri lao tanganuem, me ulaa ghauliaa saa voto God ghe gheleila etam.” Liuna avalua o, taumattu ngateva oia ghe lao sio tanganuena, me ghe kiukiuaala tale masaliki taatara ateae saa voto Iesu ghe gheleila etana. ");
INSERT INTO emi_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nau eteva Iesu ghe oghiaala, taumattu ngatoa laghe souela tale nimasimasi, poli ila akapa laghe aloanna tani taraia. ");
INSERT INTO emi_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Taumattu ngateva ararina ateae ta Jaeras, namuu ia tale ale nivelu eitaua ngateva, ghe mae sio, me ghe suuiaala ta liue kkena Iesu, poli ghe aloannaaili va Iesu ghe usia, me lalu ghe lao tanganuena, ");
INSERT INTO emi_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","poli kateva nonga ia natuna aliki vause ateva, anna ninamanama erooroo kasangaulu ghaluae (12), me ang ghe aainasiaa tani mate. Nau eteva Iesu ang ghe laolao, taumattu ngatoa laghe tomtomua. ");
INSERT INTO emi_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Me vause ateva rae ateva ghe iiloueinia ghe roola kasangaulu ghaluae (12) ninamanama, ie tee elome ta taumattu ngatoa. Ghe rungiaala unna viliki veu tani ghaa niaisausi, me karika teva ghe roola tani ghelei emasinaia. ");
INSERT INTO emi_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ghe keola emuli ta Iesu, me ghe posola euu tale sama unna aiaasae ateva Iesu, me katengaata nonga ta rae ateva ghe ruula tani ilou. ");
INSERT INTO emi_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iesu ghe kolomila va, “See etulieghila?” Nau eteva laghe uela va karika poi teva ghe tuliela, Pita ghe uela va, “Vau eteva, taumattu ngatoa oroieili ila, me la aikerreii tani atu etam.” ");
INSERT INTO emi_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Me karika ta Iesu ghe mene uela va, “Kateva etulieghila; aghateateaala va kasina tani sarasarakana ange kasula etaghi.” ");
INSERT INTO emi_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Me vause ateva, ghe kilala va karika ghe roola tani aisulia, ghe moiela, me ghe lao sio tani suuiaa ta liue kkena Iesu. Ta mata taumattu ngatoa, ghe auliaala mausi saa, me ghe tulila Iesu, me vaalua arovaeaata nonga ta ghe masinala. ");
INSERT INTO emi_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Iesu ghe uela ta vause ateva va, “Natughu, tale unem niaikaaiaa etaghi angu masinala. Kasula tale luei.” ");
INSERT INTO emi_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nau eteva Iesu ghe aippooaa, me taumattu ngateva ghe kasula tanganuena Jaeras, ia o namuu ia tale ale nivelu eitaua ngateva, ghe rekatala. Ghe uela va, “Natum vause arighi ange matela. Urou mene ghelei va emene aanasa ta tisa ngateva.” ");
INSERT INTO emi_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iesu ghe nongola, me ghe uela ta Jaeras va, “Urou mene matautu; unim aikaaiaa, me aue emasina.” ");
INSERT INTO emi_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nau eteva ghe rekatala tanganuena Jaeras, ghe tam aloannala righi taumattu tani usie sso elo ale, ta Pita nonga me Jeimis, Jon, me tamane me kinna aliki vause arighi, ila nonga laghe ssola. ");
INSERT INTO emi_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Taumattu ngatoa laghe ngangngala, me laghe aalousiusi teeia. Iesu ghe uela va, “Angenna ngam ngalala. Aliki vause arighi karika ematela, ta enim aseasekanua.” ");
INSERT INTO emi_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Laghe kangainiela, ta laghe kilakila va aliki vause ateva matena ia. ");
INSERT INTO emi_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Iesu ghe kune siola nimane atelange, me ghe uela va, “Aliki erighi, totula!” ");
INSERT INTO emi_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Aliki vause arighi ghe sakesakela, me arovaeaata ta ghe laa sio totu, me ghe tingina saela. Me Iesu ghe uela etaira va la tau lao righi inana, me enama. ");
INSERT INTO emi_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tamane me kinna lalu ghe soghiaala tani tara, me Iesu ghe aulia ngakorokoronganala etairarua va lalu rou mene auliaa ta righi taumattu isaa o voto ghe lutula. ");
INSERT INTO emi_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iesu ghe kolo aitauaala kasangaulu ghalua (12) kapuna disaepolo, me ghe taula sarasarakana me nimatuutuliena etaira tani ghaa velu raroai, me tani ghaa velu isiki ta taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Me ghe sungilala tani laa ppooa ngaotu ararimangalina ateva God, me tani ghelei emasina tau sessa atoa. ");
INSERT INTO emi_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ghe uela etaira va, “Am rau mene ghaa righi voto nau am kasu. Karika mene tiulu aikkatulu tani kkatulu, teva aikaai ghinna, me righi inana me viliki veu, me karika am mene ghaa ghalua aiaasae. ");
INSERT INTO emi_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Me arova am laa toka tale lo ateva ale, am toka elaa ghaa nau am kasu vuli lo ateae o masaliki. ");
INSERT INTO emi_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Me arova karika la ghaaiem, am kasu. Nau am kasu, am rariaa velu kosa ta kkeimim, me aue la kila va voto laghe gheleila karika masina.” ");
INSERT INTO emi_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Me disaepolo atoa laghe kasula tani laa ppooaa see masi inangari tale kateae kateae masaliki, me tani ghelei emasina tau sessa atoa. ");
INSERT INTO emi_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Gavana ngateva Herot ghe nannangaili ta ghe nongola oroieili voto Iesu ghe gheelei, poli laghe uue va Jon ang ghe mene totula tale nimate, ");
INSERT INTO emi_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","me katoa laghe uue va Elaija ghe kaurekatila, me katoa laghe uue va kateva ta propete atoa emua arau ang ghe mene totula. ");
INSERT INTO emi_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Liuna avalua o me Herot ghe ue va, “Jon ngaghe auliaala me laghe sai pulela alona atiulu, me tani see ia taumattu ngateva oia, amene nongonongo uunguaane?” Me ghe aaloanna tani taraia. ");
INSERT INTO emi_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Apostolo atoa laghe kiriaa mae sio ta Iesu, me laghe aulia ngakapala voto laghe gheleila. Ghe ghaailala, me ila nonga laghe lao sio tale masaliki taatara ateae eBetsaida. ");
INSERT INTO emi_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nau taumattu ngatoa laghe nongola va ang ghe kasula, laghe aimulila etana. Ia ghe masimasieinilala, me ghe tiuaala tani ppooaa ararimangalina ateva God etaira, me ghe gheelei emasina tau sessa atoa. ");
INSERT INTO emi_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Auena sinaka ateva ghe suu, me kasangaulu ghalua (12) disaepolo laghe lao sio, me laghe uela ta Iesu va, “Sungi vellala, me la lao tale righi masaliki, o paa ngutana, tani laa poli righi inana me la nama, me la ghaso. Ta voto ateva oia ita tokatoka etana vurunganna ia.” ");
INSERT INTO emi_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Iesu ghe uela etaira va, “Am, am taula righi inana, me la nama.” Laghe liula me laghe uela va, “Ghalima nonga verete me ghaluepai kko. Ualoanna va ami laa poli see righi aneira inana?” ");
INSERT INTO emi_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Erooroo ghalima airari (5,000) taita oia ghe tokatoka. Iesu ghe uela ta disaepolo atoa va, “Am laa ghauliaa etaira va la laa toka aitauaa sio ghalimangaulu (50) taumattu ta kateae uela.” ");
INSERT INTO emi_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Disaepolo atoa laghe auliaala, me laghe toka siola tale uela. ");
INSERT INTO emi_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Iesu ghe ghaala verete ghalima me kko aluepai, me ghe taatara saela epona liu, me ghe kaili emasina saela, me ghe pirila, me ghe taula ta disaepolo atoa tani laa koita ta taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Laghe namala, me ila akapa laghe tuvula, me disaepolo atoa laghe kaai esokosokoiaala tapiri nginana, ghe roola kasangaulu ghaluae (12) laka. ");
INSERT INTO emi_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kateva nau Iesu ghe puupure, me kapuna disaepolo atoa laghe tokatoka teeia, me ghe kolomilala va, “Taumattu ngatoa la uue va aghi tani see?” ");
INSERT INTO emi_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Laghe liula me laghe uela va, “Katoa la ue va io Jon tau ngai aasuu ia, me katoa la ue va io Elaija, me katoa la ue va io kateva ta propete atoa emua arau ang ghe mene totula.” ");
INSERT INTO emi_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Me ghe kolomilala va, “Me am, am ue va aghi see?” Me Pita ghe liula me ghe uela va, “Io kapuna Mesaea ngateva God.” ");
INSERT INTO emi_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Iesu ghe paolala va karika la mene laa ghauliaa see va ia see. ");
INSERT INTO emi_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Me ghe uela va, “Natuna ateva Taumattu ngateva aue eghaa oroieili mmarikana, me namu ngatoa, me namu ngatoa ta pristi etoa, me tau ngai aapasunga ngatoa tale inangari nipaopao, aue la liu viliira etana, me aue la uvi ematea. Me aue kotonna ateva nau, emene totu.” ");
INSERT INTO emi_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Vara me ghe uela ta kapuna disaepolo atoa va, “Arova lo ateva ealoanna tani usieghi, etani sioaa nannaane, me esunuki unna aikotoo ateva nau ekapa atoa, me eaimuli etaghi. ");
INSERT INTO emi_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ta poli arova lo ateva eannaa nonga maamauluaane, aue eraua. Me arova lo ateva eraua ta poli mausighi, aue esaanga. ");
INSERT INTO emi_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Me arova lo ateva eghaa voto akapaaili tale kosa ateva, me maamauluaane ekapa, vaalua isaa o voto aue esausia? ");
INSERT INTO emi_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Arova lo ateva taumattu epalatainaghi me inangarighi eteva, aue Natuna ateva Taumattu ngateva epalatainia, nau eteva emae tee maamallangiaane, me maamallangiaane Tamane, me tee kapuna ensolo atoa manga ila. ");
INSERT INTO emi_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Aghaaulia ngakoronna etaimim va katoa oia etaimim am tiitingina, karika aue am mate, me aue am tara ararimangalina ateva God.” ");
INSERT INTO emi_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Koti ghaoalu (8) nau ghe lange sio, nau ghe ppooaala llo inangari, me ghe kolola Pita me Jon me Jeimis, me laghe saela tale motouru tani looloo sae. ");
INSERT INTO emi_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ghe looloo sae, me taatara matane ghe isaa ppaela, ghinnanina ghe usousoanaailiila, me ghe ravaravaienaailiila. ");
INSERT INTO emi_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Vara me ghalua taumattu, Moses me Elaija, lalu ghe kaurekatila tale mallanginaane ateva God, me lalu ghe samasama tee Iesu. Lalu ghe aauliaa saa llo voto aue elutu etana eJerusalem, me vaalua aue ekasu vuli kosa ateva oia. ");
INSERT INTO emi_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Matana Pita me mene ghalua tana kapuna ghe maamatana tani asekanu. Me nau laghe totula, laghe tarala mallanga ateva ta matana Iesu, me mene ghalua lalu ghe tiitingina teeia. ");
INSERT INTO emi_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Me nau lalu ghe aloanna tani kasu vuli Iesu, me Pita ghe uela ta Iesu va, “Vau eteva, masina ta ngeita tokala oia, me angatolu atulu ale paapali kotolu, kateva alem ia, me kateva alena ia Moses, me kateva Elaija.” Pita ghe auliaala isaa o inangari, me karika ghe kilakila sa ateva ghe aaulieinia. ");
INSERT INTO emi_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nau Pita ghe aauliaa isaa o inangari, me urukookoo ateva ghe akoulala, me ngilotolu ghe maamatautu. ");
INSERT INTO emi_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lingi ngalo ateva ghe mae sio tale urukookoo ateva, ghe uela va, “Ia o taita ateva natughu ia, ngaghe suitoongainiela. Am nongoa.” ");
INSERT INTO emi_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nau lingi ngalo eteva ghe ruula, me laghe tara nongala Iesu. Nau laghe oghi sio mae, karika laghe auliaa poila ta mene toa tale voto laghe tarala. ");
INSERT INTO emi_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ghe paila ta mene kateva nau, nau eteva laghe sio mae tale motouru eteva, me laghe tarala oroieili taumattu ngatoa, laghe mae sio tani sou Iesu. ");
INSERT INTO emi_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kateva etaira ghe samala me ghe uela va, “Tisa! Mae tara natughu eteva, ta kateva nonga natughu, me ughelei emasinaia. ");
INSERT INTO emi_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nau eteva raroai eteva ekupikupia, esamasama anamungaili, me egheeleia eoo, me usouso paane eghoa, me egheelei saasakiaa vilikina, me karika poi ekasukasu vuli parasia. ");
INSERT INTO emi_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Anim auliaa poila ta kapum disaepolo atoa tani ghaa velu raroai eteva, me karika la roola.” ");
INSERT INTO emi_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iesu ghe liula me ghe uela va, “Am lo ateva oia vituu, karika righi uneimim niaiesoaa, nannaaimim me gheeleiaaimim karika ghulughuluena. Ghaisaata aue atoka teeiem, me ghaisaata aue asau sesa gheeleiaaimim? Ghaa mae natum ateva.” ");
INSERT INTO emi_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nau aliki eteva ghe maemae, me raroai eteva ghe sau velu elokoie siola tapaa kosa, me ghe tiuaala tani oo. Iesu ghe paola raroai eteva, me ghe ghelei emasinala aliki eteva, me ghe tauela ta tamana. ");
INSERT INTO emi_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ila akapa taumattu ngatoa laghe soghiaala tani tara sarasarakaniaane God. Taumattu ngakapa atoa laghe nannangaili isaa akapa voto Iesu ghe gheleila, me Iesu ghe uela ta kapuna disaepolo atoa va, ");
INSERT INTO emi_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Am nongo amasina sa ateva aghaaulieinia ta ngetaimim, va Natuna ateva Taumattu ngateva aue la taue lao ta nimaira taumattu ngatoa.” ");
INSERT INTO emi_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Karika laghe alomasaanga teela malloeanina inangari Iesu ghe auliaala, ta malloeanina ghe aaisulia etaira. Laghe maamatautu tani kolomia. ");
INSERT INTO emi_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kateva nau, laghe aaissakeana va tani see aue enamuu etaira. ");
INSERT INTO emi_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iesu ghe kilala nannaaira, liuna avalua o me ghe ghaala aliki erighi, me ghe mae atingina valainie sio etana. ");
INSERT INTO emi_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Vara me ghe uela etaira va, “See umasimasi tani aikoloaa aliki etoa tale ararighi eteae, ughaaghaa teeieghi, me ughaaghaa tee lo ateva ghe sungieghila. See etaimim esio euu, ia namuu ia etaimim.” ");
INSERT INTO emi_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon ghe liula me ghe uela va, “Vau eteva, ami ghe tarala taumattu ngateva, ghe sungi vella raroai etoa tale ararim ateae, me ami ghe tootoonga tani pao rungainia, poli karika va eusiusita.” ");
INSERT INTO emi_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Iesu ghe uela va, “Am rau mene paoa, ta lo ateva karika esessa teeita, kapuita ia.” ");
INSERT INTO emi_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nauna Iesu ang ghe aakalakalangina tani sae epona liu, me ghe annaaili tani sae eJerusalem. ");
INSERT INTO emi_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ghe sungi emuemuela katoa kapuna tani laa ghaimanomanosieinila tale kateae masalikiira aSameria ngatoa. ");
INSERT INTO emi_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Karika laghe aloanna tani aikoloainia, ta poli ghe aloanna tani sae eJerusalem. ");
INSERT INTO emi_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Disaepolo alua ta Jeimis me Jon, lalu ghe tarala ta laghe ghelei evaluela o, me lalu ghe kolomila Iesu va, “Vau eteva, ualoanna va ami kolo sae kura ateae epona liu, me esio ataila?” ");
INSERT INTO emi_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Iesu ghe kiriela, me ghe paolaluela, ");
INSERT INTO emi_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","me laghe mene lao sio ta mene kateae masaliki. ");
INSERT INTO emi_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nau laghe kasukasu elaolao tapaa salana, kateva taumattu ghe uela ta Iesu va, “Aghaloanna tani usio nongina eaa ulao.” ");
INSERT INTO emi_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iesu ghe liula me ghe uela va, “Paua nge tapaa tuvui etoa tue liuira, me ghila atoa aleira, me Natuna ateva Taumattu ngateva karika teva alena tani laa ghasekanua etana.” ");
INSERT INTO emi_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Me ghe uela ta mene kateva taumattu va, “Mae usieghi.” Me taumattu ngateva ghe liula me ghe uela va, “Vau eteva, utau velueghi mua, me alaa kaiaa tamaghi.” ");
INSERT INTO emi_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Iesu ghe uela etana va, “Utau vella matena atoa la laa kaiaa matena atoa. Me ukasu, me ulaa ghauliaa see ararimangalina ateva God.” ");
INSERT INTO emi_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kateva ghe uela ta Iesu va, “Aghi aghaloanna tani usio, me utau velueghi mua, me alaa ghakorova kapughu etoa tanganueghi.” ");
INSERT INTO emi_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iesu ghe liula me ghe uela etana va, “Arova teva taumattu eoseose me etaatara lao emuli, karika erooroo tani uungu tale ararimangalina ateva God.” ");
INSERT INTO emi_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Emulina tale isaa o voto, Vau eteva ghe mene suitoongaala ghaitungaulu ghalua (72), me ghe sungi emuemueilala ghalua ghalua ta ngetaira, tani lao akapa see tale masaliki taatara, me tale masaliki auena ghe lao etana. ");
INSERT INTO emi_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ghe uela ta ngetaira va, “Utana atingiu ang ghele matuela, me tau ngai uungu etoa karika oroi ila. Liuna avalua o, am kolomi sae Vau tale tau ngai mukemuke ateva, va emene sungi toa tau ngai mukemuke, tani lao tale utana atingiu matuenna ia. ");
INSERT INTO emi_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Am kasula! Asungisungiem nongina natu sipsipi etoa la tiitingina tee sesa paua ngetapaa tuvui etoa. ");
INSERT INTO emi_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Karika am mene ghaa aikaai viliki veu, aikaai ghinna, o aiaasae tale keke. Karika am mene tingina aippooaa elaolao etapaa salana. ");
INSERT INTO emi_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Nau am kupi sso tale ale ateva, am ue akasina va, ‘Luei etoka tale ale ateva oia.’ ");
INSERT INTO emi_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Marova teva taumattu tale luei etokatoka, kaluimim luei aue easo ta ngetana; marova karika, aue luei eteva eoghi atu ta ngetaimim. ");
INSERT INTO emi_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Am toka tale ia o ale ateva, marova la tau aatu inana me manu, am ghaa, poli emaamasina va tau ngai uungu eteva eghaa aipolipoli tale uunguaane egheelei. Karika am mene kasu ekapa see tale ale atoa. ");
INSERT INTO emi_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Nau am lao tale masaliki taatara me la ghaaiem, am nama inana la tau aatu. ");
INSERT INTO emi_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Am ghelei emasina tau sessa atoa, me am ue ta ngetaira va, ‘Ararimangalina ateva God ange kalakalanginala etaimim.’ ");
INSERT INTO emi_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Me marova am sso tale masaliki taatara, me la ratiem, am lao tale tummatavanga, me am ue va, ");
INSERT INTO emi_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Kosa tale masalikiimim etokatoka tale kkengalua, ngangalu raarariaa velu poli ngam ratiengaluela. Me am kila isaa oia voto: Ararimangalina ateva God ange aakalakalaala.’ ");
INSERT INTO emi_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Aghaauliaa ta ngetaimim va, aue nau niaisakei eteva, God aue eapasunga maomaona nimmarikana tale masaliki eteae eSodom, me sesaaili tale lo ateae oia masaliki! ");
INSERT INTO emi_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Aue esesaaili ta ngetam, Korasin! Aue esesaaili tee ta ngetam, Betsaida! Marova mirikolo oia laghe gheleila eTaer me eSaedon, taumattu ngatoa aue laghe molu tale ghinna nialousiusi me au kura, tani apasunga va ngila ghe oghi vulula sesa gheeleiaaira. ");
INSERT INTO emi_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Aue emaomaona nimmarikana ta eTaer me eSaedon tale nau niaisakei eteva, me am karika. ");
INSERT INTO emi_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Me io, Kapenium, uannaa va aue usae epona? Karika, io aue usioaili euu. ");
INSERT INTO emi_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“See enongonongoam, enongonongoaghi; me see eratiem, eratiratieghi, me see eratiratieghi, eratirati lo ateva ghe sungieghila.” ");
INSERT INTO emi_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kasina nau ghe lange sio, me ghaitungaulu ghalua (72) taumattu, laghe oghi mae sio tee nimasimasi, me laghe uela va, “Vau eteva, raroai etoa tee laghe nongonongo usilainamami, nau ami ghe aauliaa voto tale ararim ateae.” ");
INSERT INTO emi_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Eghe liula me ghe uela va, “Aghe tarala Satana ghe katuula nongina ravaravaia ateva ghe sio mae epona liu. ");
INSERT INTO emi_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ngaghe tau aatu sio sarasarakana tani asa katuu me onioni, me tani apala tau ngai ssateeim ateva; karika righi voto aue eghelei saasakieinam. ");
INSERT INTO emi_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Karika am mene masimasi va raroai etoa la nongonongo usilainam, ta am masimasi va arariimim laghe piti elokoila epona liu.” ");
INSERT INTO emi_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tale ia o nau eteva, Iesu ghe pasula tale nimasimasi kanna Spirit Manga ateva, me ghe uela va, “Atautauo sae, Tamaghi, Vau ngepona liu io me kosa ateva, poli ughe aisuliaala isaa oia voto ta tau ngalomasaanga atoa, me angu aotuotula ta natum natu aliki etoa. Ue Tamaghi, ugheelei isaa o voto tani aimuli tee masi aaloannaam. ");
INSERT INTO emi_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Tamaghi ang ghe tau mae sio isaa akapa voto oia etaghi. Karika teva ekilakila va see ia Natuna, Tamane nonga; me karika teva ekilakila va see ia Tamane, Natuna nonga, me lo atoa Natuna ghe suitoongainilala, me ghe apasungaala Tamane etaira.” ");
INSERT INTO emi_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Eghe kiriela me ghe aulia ngainaola ta kapuna disaepolo atoa va, “Niarangise tale lo atoa taumattu la taatara voto am taatara. ");
INSERT INTO emi_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Aghaauliaa ta ngetaimim va oroieili propete atoa me kingi etoa laghe aaloanna tani tara voto am taatara ghaine, me karika laghe tarala, me laghe aaloanna tani nongo voto am nongonongo ghaine, me karika laghe nongola!” ");
INSERT INTO emi_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kateva nau, kateva taumattu, muennaaili ia tale inangari nipaopao, ghe tingina saela tani tootoonga Iesu tale kateva nikokkolomi. Ghe uela va, “Tisa, sa ateva agheleia tani ghaa maulue ateva tokatoka liu ia?” ");
INSERT INTO emi_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Iesu ghe liula me ghe uela va, “Sa ateva laghe pitiela tale inangari nipaopao? Saa kilakilaam ta ngetana?” ");
INSERT INTO emi_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Eghe liula me ghe uela va, “Uaielousiaa Vaum ateva kapum Goto ia tale urunguitanim ateva, me tale maamauluaam, me tale sarasarakaniaam, me tale nannaam; me uaielousiaa tee taumattu ngateva kalakalangina ia etam, nongina uaielousieinio.” ");
INSERT INTO emi_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iesu ghe liula me ghe uela va, “Inangari angu liula koronnaaili; ughelei isaa o voto, me aue utoka.” ");
INSERT INTO emi_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Eghe aloanna tani apasunga va ia ghulughuluena ia, me ghe kolomila Iesu va, “See ia taumattu ngateva kalakalangina ia etaghi?” ");
INSERT INTO emi_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iesu ghe liula me ghe uela va, “Kateva taumattu ghe kasula eJerusalem tani sio eJeriko, me tau niainao atoa laghe uviela. Laghe ghaa velu ekapala ghinnanina, laghe uviela, me laghe kasu vuli elokoiela, me ghaisa ngarighi ghe mate. ");
INSERT INTO emi_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pristi eteva ghe usilaala ie nonga o salana atikirighi. Nau ghe tarala taumattu ngateva uviuvina ia, ghe keoa ngalokoiela, me ghe kasula. ");
INSERT INTO emi_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tee me Livae ateva, nau eteva ghe mae sio tale ia o voto ateva taumattu ngateva ghe asoaso etana, ghe taraiela, me ghe keoa ngalokoiela. ");
INSERT INTO emi_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Vara me taumattu nge Sameria ngateva, ie tee ghe usilaala ia o salana atikirighi. Ghe mae sio nongina taumattu ngateva ghe asoaso; nau ghe taraiela, ghe alousiusi teeiela. ");
INSERT INTO emi_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ghe lao akalakalaa sio ta ngetana, me ghe kaola oeli me uaeni ta vilikina, me usaina, me ghe ghiisila. Ghe sau etokaie saela tale kiena donki eteva, me ghe laoainie sio tale ale aiasoaso ateva me ghe aitarainiela. ");
INSERT INTO emi_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Elue talaua, ghe tau lao sio ghaluevilau viliki veu ta tau ngai toitoi eteva, me ghe uela va, ‘Uaitarainia, me marova uaitarainia tee tale mene righi peim, aue amae aliu voto akapa ughe gheleila ta ngetana.’ ");
INSERT INTO emi_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“See ta ngetairotolu uannaa va ia kalakalangina ia ta taumattu ngateva, tau niainao atoa laghe uviela?” ");
INSERT INTO emi_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tau ngalomasaanga ateva tale inangari nipaopao ghe liula me ghe uela va, “Ia o taumattu ngateva ghe alousiusi teeiela.” Iesu ghe uela va, “Lao sio, me ughelei nongina ia o taumattu ngateva ghe gheleila.” ");
INSERT INTO emi_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nau Iesu me kapuna disaepolo atoa laghe kasukasu elaolao, me laghe rekatala tale masaliki eteae. Vause ateva, ararina ateae ta Mata, ghe kolola lao sio tanganuena. ");
INSERT INTO emi_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nengana vause ateva, ararina ateae ta Meri, ghe toka siola ta liue kkena Vau eteva, tani nongoa ta ghe aaippooaa. ");
INSERT INTO emi_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mata ghe aaivengevengesi, poli ia nonga ghe aaimonomonosiaa inana. Ghe mae sio, me ghe uela va, “Vau eteva, emaamasina va aghi nonga aghaimonomonosiaa inana, me nengaghi enim tokatoka? Auliaala, me emae sausieghi!” ");
INSERT INTO emi_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Vau eteva ghe liula me ghe uela va, “Mata, Mata, unannaa oroieili voto, ");
INSERT INTO emi_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","me kateva nonga voto ateva ualoannaia, me karika ia etam. Meri ange aloannala ia o voto ateva masina ia, me karika aue aghaa velua etana.” ");
INSERT INTO emi_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kateva nau Iesu ghe looloo sae tale kateva voto, me nau ghe ruula, kateva kapuna disaepolo ghe uela etana va, “Vau eteva, uapasunga etaimami vaalua tani looloo sae, nongina Jon ghe aapasunga ta kapuna disaepolo atoa.” ");
INSERT INTO emi_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Iesu ghe uela etaira va, “Nau am looloo sae, am looloo sae avalua toko va, “‘Tamamami, usausiemami tani oneoneaa ararim ateae va manga ia, ami aloanna va ararimangalim ateva esio. ");
INSERT INTO emi_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Utau roorooa mae anemami inana tale kateva kateva nau. ");
INSERT INTO emi_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Me ukkaluaa kaluimami ssavoto, nongina ami kakkaluaa lo akapa atoa la gheelei sesa voto etaimami, me urau mene tau veluemami va ami lao tale nitootoonga.’” ");
INSERT INTO emi_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Iesu ghe mene uela etaira va, “Arova teva kapum ghele mae rekataa etam elomatuaa voo, me ughele laa kolomi mene teva kapum va, ‘Aghaloanna va utau mae verete kotolu, ");
INSERT INTO emi_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","poli kapughu eteva ekasu emasaula, me ange mae sio tanganueghi, me karikaaili righi inana etaghi va atau lao.’ ");
INSERT INTO emi_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Arova kapum ateva ghele liu etam va, ‘Urau mene angunainaghi. Anga kavatila atamana ateae. Aghi me natughu etoa angami asekanuela. Atam rooroo tani totu va atau aatu voto ualoanna.’ ");
INSERT INTO emi_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Aghaauliaa etaimim va karika aue ghele totu me ghele tau aatu verete, me poli uarrekana tani toka kookolomia, aue ghele totu, me ghele tau aatu voto akapaaili uaaloanna, poli karika upaapalata tani toka kookolomi nau ekapa atoa. ");
INSERT INTO emi_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Aghaauliaa etaimim va am kolomi, me aue etau aatu, me am pae, aue am tara, me am mirimiri, aue atamana ateae eotia. ");
INSERT INTO emi_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Lo atoa la kookolomi, la ghaaghaa, me lo atoa la paepae, la taatara, me atamana eotioti ta lo atoa la mirimiri. ");
INSERT INTO emi_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Arova teva natum elooloo teva kko, aue ughele taula teva katuu etana? ");
INSERT INTO emi_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O arova ghele loo teva otolu ghila, aue ughele tau lao teva onioni? ");
INSERT INTO emi_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Am arova sesa gheegheleiaaimim, me am kilakila tani tau lao masi voto ta natuimim atoa, aue Tamaimim ateva epona liu aue etau sio Spirit Manga ateva oroiaata ta lo atoa la kookolomia.” ");
INSERT INTO emi_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iesu ghe tiu vella raroai eteva tale taumattu ngateva ghe gheeleia me taumattu ngateva ghe tam samasama. Nau raroai eteva ghe kupi vulu ghoala taumattu ngateva, me ghe tiuaala tani sama, oroieili taumattu ngatoa laghe soghiaala ia o voto ateva Iesu ghe gheleiela. ");
INSERT INTO emi_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Me katoa laghe ue va, “Etiutiu velu raroai etoa tale sarasarakaniaane Belsibul, kapuira namuu ia raroai etoa.” ");
INSERT INTO emi_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Me katoa laghe nim anna tani tootoonga Iesu. Laghe kookolomia tale righi aimatootoongana ngepona liu. ");
INSERT INTO emi_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Me Iesu ghe kilakila nannaaira, me ghe uela etaira va, “Lo ateva ararimangali eaaipola, karika aue etoka liu, me lo ateva pamili eaaipola aue ila tee la ghaitiuaa. ");
INSERT INTO emi_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Arova ararimangalina ateva Satana eghaluevilau ia, vaalua aue etingina aitauaa? Aghaauliaa etaimim poli am ue va atiutiu velu raroai tale sarasarakaniaane Belsibul. ");
INSERT INTO emi_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Me arova atiutiu velu raroai tale ararina ateae Belsibul, kapuim atoa tani taumattu laghe tiutiu velu raroai tale ararina ateae see? Ila aue la ghele auliaa va inangari am auliaa kamena. ");
INSERT INTO emi_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ta poli arova atiutiu velu ta nimane God, eaapasunga va ararimangalina ateva God ang ghe sio mae ta ngetaimim. ");
INSERT INTO emi_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Nau eteva lo ateva taumattu sarasarakana ia, me eposoposo ghinna niaiuvii, aue eaitara ngamasina alena ateva, me ghinnanina aue etoka amasina. ");
INSERT INTO emi_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Me arova sarasarakanaaili eteva taumattu emae tee ghinna niaiuvii, aue euvia, me eghaa velu ekapa ghinna niaiuvii me eaikoita peina ta mene katoa taumattu. ");
INSERT INTO emi_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Lo ateva karika kapughu ia, tau ngai ssateeghi ia, me lo ateva karika esaasausieghi tani atoka aitauaa, ia etani aatoka apolapola. ");
INSERT INTO emi_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Nau sesa spiriti eteva ekasukasu vuli taumattu ngateva, ekasukasu ekapa see tale voto mallangona, epaepae teva voto aue eainoana etana. Va etam rooroo tani tara teva voto tani ainoana, ange ue va, ‘Amene oghi lao tale ale ateva aghe tokatoka etana.’ ");
INSERT INTO emi_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nau ange laa rekataa sio va ange tarala alena ateva raarangisana ia, me elome masina tani toka etana, ");
INSERT INTO emi_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","liuna avalua o me aue emene kasu tani laa kolo ghaitu (7) sesa spiriti gheeleiaaira mene sesaaili. Me aue la kupi sso, me la sso toka tale ale ateva. Gheeleiaane taumattu ngateva esesaaili, elaulau llo gheeleiaane akasina.” ");
INSERT INTO emi_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nau Iesu ghe aippooaa, me vause ateva ghe tokatoka teeila ghe sama anamuula, me ghe uela ta Iesu va, “Niarangise etokatoka ta lo ateva vause ghe kaaiola, me ghe ssuola.” ");
INSERT INTO emi_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Iesu ghe liula me ghe uela va, “Koronnaaili inangarim, me kinatama niarangise ta lo atoa la nongonongo me la uusilaa inangarina God.” ");
INSERT INTO emi_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nau taumattu ngatoa ngeila ghe ooroi, Iesu ghe uela va, “Lo ateva oia vituu, karika va masi taumattu ngam, ta am anna nonga tani tara niaimatoonga. Saa ghe lutu teela Jona, ie nonga o niaimatootoongana ateva aue elutu. ");
INSERT INTO emi_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nongina emua arau ta nau Jona, ia ghe aimatootoongana ta taumattu nge Ninive, aue enongina Natuna ateva Taumattu ngateva tale lo ateva oia vituu. ");
INSERT INTO emi_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tale nau niaisakei, aue Kuin nge Saot ateva etingina tee lo ateva oia vituu, me aue eue va sesa am, poli Kuin ateva ghe kasu emasaueilila tani mae nongo alomasaanganiaane Solomon, me lo ateva taumattu namuu ia ta Solomon ange toka teeiemla. ");
INSERT INTO emi_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Aue taumattu nge Ninive atoa la tingina tale niaisakei eitauaa teeiem, me la ue va sesa am, poli aNinive atoa laghe nna ngaioghioghiaala, nau Jona ghe poppooaa etaira, me ia oia, lo ateva namuu ia ta Jona ange toka teeiemla. ");
INSERT INTO emi_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Karika teva eaarokoti kuraane lam ateae va eaatoka aisulieinia, o eaakou rungainia tale teva aikaai manu, ta eaatokaie sae epona tale aitiitinginane ateva, me nau taumattu ngatoa la kupi sso, aue la rooroo tani tara mallangina ateva. ");
INSERT INTO emi_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matam alua emaamallangi vilikim. Arova matam va masina, vilikim akapaaili aue epasu tale mallanga ateva, va nau matam nge sesala, isaa akapa vilikim aue esaurorromiena. ");
INSERT INTO emi_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Liuna avalua o me ukaarasi tani aimonomonosiaa, poli mallanga ateva etam karika va saurrom ia. ");
INSERT INTO emi_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Liuna avalua o me arova vilikim akapaaili emallanga me karika mene teva tuku vilikim saurorromiena, isaa akapaaili aue emallanga, nonginaaili lam ateae emaamallanga etam.” ");
INSERT INTO emi_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nau Iesu ghe ruula tani aippooaa, me kateva Paresi ghe koloala tani laa namanama tanganuena. Iesu ghe usiela me ghe lao sio tale tevoo ateva tani namanama. ");
INSERT INTO emi_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Paresi eteva ghe soghiaala tani tara va Iesu ghe tam pora akasinala nimana, nongina gheeleiaaira Paresi etoa, me ghe nim namanama. ");
INSERT INTO emi_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Me Vau eteva ghe uela etana va, “Am Paresi etoa, am porapora araarangisana uneimim kapa me pelete eleka, me elome etaimim kuruetuna am, me sesaaili iem. ");
INSERT INTO emi_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Am alo kapakapa am! Am tam kilakila va lo ateva ghe gheleila eleka ghe ghelei teela elome? ");
INSERT INTO emi_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Me am taula saa llo voto elome tale uneimim aikakkaai ta lo atoa karika peiira, me aue isaa akapaaili voto aue eraarangisana etaimim. ");
INSERT INTO emi_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Aue esesaaili etaimim Paresi etoa, poli am tautau lao aiaasokolo tale lutu voto ghaunaaili am ghaaghaa eutana, me am kakkaluaa tani ghelei voto ghulughuluena me tani aielousiaa God. Am ghelei ekapa voto tani ghelei ghulughuluena voto, me tani aielousiaa God, me tee tani taula aiaasokolo. ");
INSERT INTO emi_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Aue esesaaili etaimim Paresi etoa, poli am tani aloannaaili aitokatoka ngemua tale ale nivelu eitauaa, me am aloanna va taumattu ngatoa la souem me la ue va, ‘Elue talaua’ me ‘Elo sinaka’ etaimim tale maketi. ");
INSERT INTO emi_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Aue esesaaili etaimim, ta am nongina liu niaikkaia ngateva taumattu ngatoa la kasukasu saoaa etana, me la tam kilakila va liu niaikkaia ia.” ");
INSERT INTO emi_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kateva tau ngai aapasunga tale inangari nipaopao ghe liula, me ghe uela va, “Tisa, nau eteva uaauliaa isaa oia voto, uaauliaa teeiemami.” ");
INSERT INTO emi_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Iesu ghe liula me ghe uela va, “Am tau ngai aapasunga iem tale inangari nipaopao, aue esesaaili etaimim, poli inangariimim aanasaaili tale taumattu ngatoa tani aimuli tee, nongina am aatoka sae voto maamatanaaili ta katoa, me karika la rooroo tani sau, me karika am saasausila. ");
INSERT INTO emi_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Aue esesaaili etaimim ta am atuutulu atu niaimatoonga tale liu niaikkaiaaira propete atoa, tuvuim atoa laghe uvi ematelala. ");
INSERT INTO emi_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Am aaulia ngaotu va am masimasiaa saa voto tuvuim atoa laghe gheleila nau laghe uvi ematela propete atoa. Liuna avalua o me am atuutulu atu niaimatoonga tale pongasovuira. ");
INSERT INTO emi_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Liuna avalua o me tale aalomasaanganiaane God ghe uela va, ‘Aue asungi tau lao propete atoa me apostolo atoa, katoa aue la uvi saasakieinila, me katoa aue la uvi ematela.’ ");
INSERT INTO emi_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Liuna avalua o me lo ateva oia vituu, aue la ghaa sesa ngaipolipoli mausi propete akapa atoa laghe uvi ematelala emua arau, tale aitiutiu tale kosa ateva, ");
INSERT INTO emi_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ghe tiuaala ta matemateaane Eibol, me ghe mae sio ta Sekaraea, laghe uvi emateala tale mallome liu nighelei aiaavusuvusuena me tale rum manga atiulu. Aghaaulia ngakoronnaaili etaimim va lo ateva oia vituu aue eghaa sesa aipolipoli. ");
INSERT INTO emi_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Aue esesaaili etaimim lo atoa alomasaangaaili iem tale inangari nipaopao, poli am ghe ghaa vella kii eteva tani ghaa alomasaanga, me am, karika am sosso, me lo atoa vara la kupi sso, am gheelei rungainila.” ");
INSERT INTO emi_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Me nau Iesu ghe kasu vulila ia o voto ateva me Paresi etoa me tau ngai aapasunga ngatoa tale inangari nipaopao laghe sessaieiliilala, me laghe kookolomi oroieili nikokkolomi. ");
INSERT INTO emi_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Laghe sassaia tani nongo va ghe auliaa righi sesa inangari. ");
INSERT INTO emi_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nau eteva oroi airari taumattu laghe mae aitauaa sio, laghe aisiriki tani tara, me Iesu ghe tiua ngakasinala tani aippooaa tee kapuna disaepolo atoa. Ghe uela va, “Am taatara amasina tale uneira isti Paresi etoa, usimaghalue ia. ");
INSERT INTO emi_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Karika righi voto am aaituttuia va aue etam otu, isaa akapa voto pei niaisulia, aue la kila. ");
INSERT INTO emi_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Liuna avalua o, me voto ngam auliaala tale voo ngateva aue la nongo ellaa, me voto ngam aulia ngaghaunala tale paa ngaleimim, aue la aulia ngaotu tale tummatavanga. ");
INSERT INTO emi_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Aghaauliaa etaimim, kapughu etoa, am rau mene matauta lo atoa la uvi emateam, poli auena karika mene righi uunguaaira etaimim. ");
INSERT INTO emi_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Aue aghapasunga lo ateva am matautainia. Am matauta lo ateva matuutuliena ia tani uvi emate taumattu, me tani sau velula sae tale Gehenna. Aghaauliaa etaimim va am matautainia! ");
INSERT INTO emi_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","God karika erooroo tani aikkaluaa kateva ta ghalima natu ghila aipoliira erooroo ghaluevilau viliki veu. ");
INSERT INTO emi_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ekilakila ghaisa uu ngurum tale urum ateva. Urau mene matautu, ta maamauluaam namungaili ta matane God, elaulau ghila atoa. ");
INSERT INTO emi_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Aghaauliaa etaimim, va lo ateva eaulia ngaotu ta taumattu ngatoa va kapughi ia, aue Natuna ateva Taumattu ngateva eaulia ngaotua ta kapuna ensolo atoa God va ia kapuna ia. ");
INSERT INTO emi_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Lo ateva taumattu eue va karika ekilakilaieghi, aue aghauliaa ta kapuna ensolo atoa God va karika akilakilaia. ");
INSERT INTO emi_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Me lo atoa la auliaa tee Natuna ateva Taumattu ngateva, aue God ekkaluaa. Me lo atoa la auliaa saasakiaa tee Spirit Manga ateva, God karika aue ekkaluaa. ");
INSERT INTO emi_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nau eteva la ssoainiem tale liu niaisakei, emua ta namu ngatoa me taumattu matuutuliena, am rau mene matautu tani nnaa va, ‘Vaalua ami liu inangari, me sa ateva ami aulieinia?’ ");
INSERT INTO emi_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ta Spirit Manga ateva, tale ia o nau eteva, aue eapasunga sa ateva aue am aulieinia.” ");
INSERT INTO emi_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kateva elome tale taumattu ngatoa ghe uela etana va, “Tisa, uauliaa ta tueghi eteva me eaikoita peina tamaingalua etaingalua.” ");
INSERT INTO emi_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Iesu ghe liula va, “See ghe uela va aghi aghelei niaisakei, me akoita voto etaimalua?” ");
INSERT INTO emi_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Vara me ghe uela etaira va, “Am taatara amasina, me am tingina akorokorongana. Am rau mene raungaa peiimim, poli karika aue am ghaa maulue ateva tale peiimim.” ");
INSERT INTO emi_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Me ghe auliaala kiukiu niaimatoongana ateae etaira va, “Kateva taita tue peipeiena ia, kosane ateva ghe apinosala oroieili masi inana atoa tale kateae ninamanama. ");
INSERT INTO emi_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ghe nannaa va, ‘Sa ateva agheleia? Karika teva ale tani atoka aitauaa aneghi inana.’ ");
INSERT INTO emi_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Vara me ghe uela va, ‘Aghelei evalua toko, va arruti aleghi ale nginana atoa, me amene atulu righi namuu, me aghatoka aitauaa sso aneghi inana me peighi. ");
INSERT INTO emi_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Me aghauliaa etaghi va, “Aghi ngaghaala oroieili masi voto atoa, aue la toka oroi ninamanama. Aghainoana, anamanama, aropi, me amasimasi.”’ ");
INSERT INTO emi_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“God ghe uela etana va, ‘Alo kapakapa ateva! Ghaine eleivoo aghaa velu maamauluaam, me see eghaa voto ughe aimonomonosiaala?’ ");
INSERT INTO emi_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Aue enongina avalua o tale tue peipeiena atoa la ghaaghaa oroieili voto, me karika la nannaa God.” ");
INSERT INTO emi_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Vara me Iesu ghe uela ta kapuna disaepolo atoa va, “Liuna avalua o, me aghaauliaa etaimim va, am rau mene annaa maamauluaaimim me am ue va, ‘Sa ateva ami namaia,’ me am rau mene annaa vilikiimim, me am ue va, ‘Sa ateva ami asaea?’ ");
INSERT INTO emi_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Karika am kilakila va maulue ateva namuu ia ta matane God, me inana isaa euu, me vilikiimim isaa epona, me aiaasae isaa euu? ");
INSERT INTO emi_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Am tara ghila atoa. Karika la pasapasa, me karika la mukemuke, me karika righi aleira tani atoka aneira inana, ta God eangiinginila. Am taumattu ngatoa namuu iem ta matana God. ");
INSERT INTO emi_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","See etaimim enannangaili erooroo tani ghelei maamauluaane emene toka tee lao? Karika poi! ");
INSERT INTO emi_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ta poli karika am rooroo tani ghelei isaa o lutu voto, vaalua me am nannaa mene kasina voto? ");
INSERT INTO emi_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Am tara vaalua palaoa ngatoa la piipinosa. Karika la uungu aanasa tani ghaa peiira. Aghaauliaa etaimim va molumoluaane Solomon masinaaili, me palaoa ngatoa, la laulau molumoluaane Solomon. ");
INSERT INTO emi_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","God eaamolumolu evalua o rarrasa atoa, la piipinosa ghaine, me nimanaa la taula sae tale kura ateae. Am rooroo tani aikaaiaa va aue eaamolumolu evalueiem tee o, ghauna uneimim niaikaaiaa. ");
INSERT INTO emi_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Karika am mene atoka nannaaimim va sa ateva am namaia, me sa ateva am ropia. Am rau mene nnaa isaa o voto. ");
INSERT INTO emi_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ta poli taumattu tale kosa ateva la iilou paepae isaa o voto, me Tamaimim epona liu ekilakila va sa ateva am tuutukuna etana. ");
INSERT INTO emi_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Am pae ararimangalina ateva God, me aue etau aatu isaa o voto etaimim. ");
INSERT INTO emi_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Am rau mene matautu, lutu lo atoa sipsip karika oroi iem, ta poli Tamaimim epona liu emasimasi tani tau aatu ararimangalina ateva etaimim. ");
INSERT INTO emi_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Am taula peiimim me la poli, me viliki veu am taula ta lo atoa karika righi peiira. Me am ghaa lo ateva aikkaai viliki veu karika aue epoka, me am ghaa ghinnani ngepona liu, karika aue esesa, me karika teva tau niainao erooroo tani ainao, me karika aue eavu. ");
INSERT INTO emi_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ta poli voto ateva peiimim etokatoka etana, aue urunguitaniimim tee ateva aue etoka etana. ");
INSERT INTO emi_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Am aimonomonosiaa tale niuungu. Am ghelei kuraimim lam etoka ramerame, ");
INSERT INTO emi_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","nongina lo atoa tau ngai nongonongo anna, la toitoi vauira ateva tani kiri mae tale nisigha ngateae. Nau eteva emae, me emirimiri etapaa ngatamana, gharovaeaata nonga ta aue la oti, me ekupi sso. ");
INSERT INTO emi_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Niarangise etoka ta lo atoa tau ngai uungu, vauira ateva etaraila va karika la aseasekanua, nau emae. Aghaaulia ngakoronna etaimim va aue emolu tani aipanipaniaa aneira inana kapuna tau ngai nongonongo anna atoa, me aue la mae tale tevoo ateva, me etau lao inana etaira. ");
INSERT INTO emi_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Niarangise aue etoka ta lo atoa tau ngai uungu vauira ateva etara va la aaimonomonosiaa, marova emae elomatuaa voo, o elopai. ");
INSERT INTO emi_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Am nim nnaa va marova taumattu ngateva ekilakila nau eteva tau niainao ateva emae etana, karika aue ghele tau velu alena ateva va ghele rrutia. ");
INSERT INTO emi_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Am tee am aimonomonosiaa, ta poli Natuna ateva Taumattu ngateva aue emae tale nau eteva karika am nannaa va aue emae etana.” ");
INSERT INTO emi_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita ghe kolomila va, “Vau eteva, uaauliaa ia ona kiukiu niaimatoongana ateae etaimami, o ta taumattu ngakapaaili etoa?” ");
INSERT INTO emi_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Iesu ghe liula va, “See ia lo ateva egheelei emasina uunguaane, me alomasaanga ia tani aitaraa voto, aue eaitara ngakapaaili tau ngai nongonongo anna atoa, tani taula inana tale nau nighaa inana. ");
INSERT INTO emi_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Niarangise aue etoka tale lo ateva tau ngai nongonongo anna, vauna ateva etara va egheelei isaa o niuungu, nau eteva ekiriaa mae. ");
INSERT INTO emi_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Aghaaulia ngakoronna etaimim va aue eatokaia va eaitara ngakapaaili peina. ");
INSERT INTO emi_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Me marova ia o tau ngai nongonongo anna ateva ennaa va, ‘Vaughu eteva karika aue emae parasi,’ me etiuaa tani uvi mene katoa tau ngai nongonongo anna, me etiuaa tani namanama, me ropi uaeni, me nannaane eaisavisavila, ");
INSERT INTO emi_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","aue kapuna vau ateva ia o tau ngai nongonongo anna ateva emae, tale ia o nau eteva eannaa va karika aue emae etana, aue esai putuputua me eatoka aitauaa teeia me lo atoa karika la aikaaiaa. ");
INSERT INTO emi_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Lo ateva tau ngai nongonongo anna ekilakila sa ateva vauna ateva ealoanna va egheleia, me karika eaimonomonosiaa tani ghelei, aue vauna ateva euvi saasakieinia. ");
INSERT INTO emi_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Me lo ateva karika ekilakila sa ateva vauna ateva ealoannaia etana, me egheelei voto sesa, ia o lo ateva karika aue la uvi saasakieinia. Lo atoa laghe taula oroi voto, la ghanna tani ghaa oroi voto etaira, me lo ateva laghe taula oroieili voto va eaitaraa, aue la ghanna oroieili voto va eliu etaira. ");
INSERT INTO emi_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Aghe mae sio tani tau kura ateae tale kosa ateva oio, me aghannaaili va arova ghele rame. ");
INSERT INTO emi_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Me aue asuu tale kateva ase niaasuu, me ngamammarikana teeia, lomosi ta niaasuu eteae eruu etaghi. ");
INSERT INTO emi_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Am annaa va aghe mae sio tani tau luei tale kosa ateva? Karika! Aghaauliaa etaimim va, karika va luei, ta niaipolapolaii. ");
INSERT INTO emi_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ange tiitiuaa oia me ange laolao; aue ghalima taumattu tale kateva pamili aue la aitiuaa, kotolu aue lotolu ssa tee ghalua, me ghalua aue lalu ssa tee kotolu. ");
INSERT INTO emi_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Aliki taita ateva aue essa tee tamane, me tamane aue essa tee natuna aliki taita ateva. Me aliki vause ateva aue essa tee kinna, me kinna aue essa tee natuna aliki vause ateva. Vause ateva aue essa tee alumuna vause ateva, me alumuna vause ateva aue essa tee vause ateva.” ");
INSERT INTO emi_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ghe uela ta taumattu ngatoa va, “Nau am taatara urukookoo esaesae ta pai sinaka esuu, gharovaeaata nonga ta am ue va, ‘Aue evaoo,’ me evaavaoo. ");
INSERT INTO emi_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Me nau eteva am taatara kuukuu eteva emaemae ta saot, am ue va, ‘Aue aanasa ateva elutu’, me aanasa ateva emaemae. ");
INSERT INTO emi_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Am usimaghalua am! Am kilakila tani tara kila voto euu me eunaakookoo, me vaalua me karika am rooroo tani tara kila nau etiulu oia? ");
INSERT INTO emi_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Vaalua me am, karika am rooroo tani kila saa voto ghulughuluena? ");
INSERT INTO emi_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Marova ngamalu laolao tale niaisakei me teva aissanim, utootoonga tani kkaluaa etana etapaa salana, ta erau laoainio ta lo ateva egheelei niaisakei, va etauo lao ta polisi etoa, va la atokaio sso tale ale mata voovoo. ");
INSERT INTO emi_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Aghaauliaa etam va karika aue ukupi ghoa lomosina ta utau ekapa lao viliki veu la ghase va utau lao.” ");
INSERT INTO emi_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tale ia o nau eteva, katoa tana taumattu laghe auliaala ta Iesu vaalua Paelat ghe uvi ematela katoa tana aGalilii nau eteva laghe gheelei sae aiaavusuvusuena ta Vau ngepona ateva. ");
INSERT INTO emi_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iesu ghe liula etaira me ghe uela va, “Poli ila o aGalilii etoa laghe mate avaluela o, am annaa va ila sesaaili kaluira ssavoto, me lo atoa oia aGalilii karika laghe matela? ");
INSERT INTO emi_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aghaauliaa etaimim va karika! Arova am tam nna ngaioghioghiaa, am tee aue am mate. ");
INSERT INTO emi_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Vaalua tale kasangaulu ghaoalu (18) taumattu nge Siloam laghe matela nau aitiketike ateva ghe katuu sauaala ta ngetaira? Am annaa va gheeleiaaira sesaaili ta mene lo atoa eJerusalem? ");
INSERT INTO emi_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aghaauliaa etaimim va karika! Arova am tam nna ngaioghioghiaa, am tee aue am mate.” ");
INSERT INTO emi_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iesu ghe auliaala kateae kiukiu niaimatoongana ta taumattu ngatoa, ghe uela va, “Kateva taumattu, aina fig ateae ghe tiitingina tale umana paa ngutani uaeni etingiu. Ghe lao sio tani taatara poi va ghe tara righi uene me karika ghe tarala righi. ");
INSERT INTO emi_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ghe uela ta kapuna tau ngai pasa utana atingiu va, ‘Tarala, kotoluae ninamanama aghe mae taatara vara aghe tara righi uene, me karika poi righi ataatara. Tue veluela! Vaalua me enim ruurungia inanina kosa ateva?’ ");
INSERT INTO emi_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Tau ngai pasa utana atingiu ghe liula me ghe uela va, ‘Vau eteva, rati etinginaiela, me emene tingina kateae ninamanama. Aue amene kai talieinia, me amene kuukumui poia. ");
INSERT INTO emi_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Marova ekune tale mene kateae ninamanama, aue emasinaaili. Marova karika, aue ita tue velua.’” ");
INSERT INTO emi_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kateva nau manga, Iesu ghe aapasunga tale kateva ale nivelu eitauaa. ");
INSERT INTO emi_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Vause ateva raroai eteva ghe tokala ta ngetana ghe roola kasangaulu ghaoaluae (18) ninamanama; raroai eteva ghe gheeleia ghe poupou tani kasu, me karika ghe rooroo tani korosia. ");
INSERT INTO emi_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nau eteva Iesu ghe taraiela, eghe koloa mae sio etana, me ghe uela va, “Vause ateva, angu masinala tale voto ghe gheelei saasakieinio.” ");
INSERT INTO emi_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Eghe saoaala nimane ta ngetana, me katengaata ta ghe korosiela, me ghe tiuaala tani tau sae God. ");
INSERT INTO emi_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kateva tana namuu tale ale nivelu eitaua ngateva ghe sessaiela ta Iesu, poli ghe ghelei emasinala vause ateva ta nau manga ateva, ghe samala me ghe uela ta taumattu ngatoa va, “Nauita ghaonomo tani ghelei uunguaaita, am mae tale isaa o nau va la ghelei emasinaiem, karika va ta nau manga ateva!” ");
INSERT INTO emi_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Vau eteva ghe liula me ghe uela etana va, “Usimaghalua am! Am oia, aue am ghele pulaka kieimim vulumakao o donki, me aue am ghele laa gharopiropi tale nau manga ateva. ");
INSERT INTO emi_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Vaalua, karika ita rooroo tani sausi ia oia vause ateva tale nau manga ateva? Poli ie tee natuna vause ia Abraham, Satana ghe ghaaiela ghe roola kasangaulu ghaoaluae (18) ninamanama.” ");
INSERT INTO emi_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ailiuliu tale inangarina ghe ghelei epalatala tau ngai ssateena atoa, me taumattu ghe taatara masi voto ghe gheelei, laghe masimasi. ");
INSERT INTO emi_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Vara me Iesu ghe kolomila va, “Vaalue ia ararimangalina ateva God? Aue asuimatoongainia tale sa ateva? ");
INSERT INTO emi_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ia nongina katu ue ngai erighi la kolokoloa va mastet, taumattu ngateva ghe ghaala katu ue ngai erighi, ghe pasaiela tale umana utana atingiu. Ai erighi ghe pinosala, me ghe namungailiila, me ghila atoa laghe gheleila aleira tale laangina.” ");
INSERT INTO emi_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iesu ghe mene kolomila va, “Sa ateva aue asuimatoonga ararimangalina ateva God etana? ");
INSERT INTO emi_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ia avalua toko, va vause ateva ghe ghaala isti me ghe ghelei eitauaa teela oroieili palaoa lomosi ta palaoa ngateva ghe rrangala.” ");
INSERT INTO emi_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iesu ghe laolao see tale masaliki taatara atoa, me tale ghauna atoa masaliki, ghe aapasunga elaolao ta taumattu ngatoa, me ghe lao sio eJerusalem. ");
INSERT INTO emi_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kateva taumattu ghe kolomiela va, “Vau eteva, karika oroi taumattu aue esaanga?” Iesu ghe uela etaira va, ");
INSERT INTO emi_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Am sarasarakana tani kupi sso tale atamana ateae ghauna ia; poli oroieili taumattu ngatoa aue la tootoonga tani kupi sso, me karika aue la roo. ");
INSERT INTO emi_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Namuu tale ale ateva aue etingina, me eghoa kavati atamana ateae; me aue am tingina eleka, me am mirimiri, me am kolokolo tale atamana ateae, me aue am ue va, ‘Namu ngateva, otila atamana ateae etaimami!’ “Aue eliu etaimim me eue va, ‘Karika akilakilaiem va am see iem!’ ");
INSERT INTO emi_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Aue am liu me am ue va, ‘Ami ghe namanama me ropiropi eitauaa teeio; ughe aapasunga tale masalikiimami!’ ");
INSERT INTO emi_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Aue emene ue va, ‘Karika akilakilaiem va am see iem. Am kasu vulieghila, am akapa sesa gheeleiaaimim!’ ");
INSERT INTO emi_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Aue am ngala me am aingeresia ngalungaluimim, nau am tara Abraham, Aisiki me Jekop, me propete akapa atoa tale ararimangalina ateva God, me am, aue la tiu veluem! ");
INSERT INTO emi_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Taumattu aue ekasu tale sinaka esae me sinaka esuu, me tale mene ghaluevilau pai not me saot tale kosa ateva, aue la mae tale tevoo ateva tale kinatama ninamanama ateae tale ararimangalina ateva God. ");
INSERT INTO emi_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nongola! Kasina taumattu arariira euu aue la matuutuliena, me kasina taumattu matuutuliena ila aue la sioaili euu.” ");
INSERT INTO emi_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ia o nau eteva katoa tana Paresi laghe mae sio ta Iesu, me laghe uela etana va, “Ukasu vuli voto ateva oia, me ulao ppae tale mene teae masaliki, poli Herot ealoanna tani uvi emateo.” ");
INSERT INTO emi_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Iesu ghe liula etaira me ghe uela va, “Am laa ghauliaa etana tau nikamekame ateva okae va, ‘Aghi aue atiu velu raroai etoa, me aue aghelei emasina taumattu ghaine me nimanaa, me tale aiaakotonna ateva nau, aue aruu uunguaaghi.’ ");
INSERT INTO emi_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Karika aue atoka, ghaine, nimanaa me luevo; koronnaaili karika teva propete aue emate eleka eJerusalem! ");
INSERT INTO emi_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem, Jerusalem! Ughe uvi ematela propete atoa, ughe osala tau ngai kasuaa inangarina atoa God tale atu! Oroiaata aghaaloanna tani atoka aitaueinam kapughu taumattu ngatoa, nongina kina paolo ateva eaakou natuna atoa tale kaekaena, me karika am aaloanna! ");
INSERT INTO emi_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Liuna avalua o, me am nongola! God aue ekasu vuli alena ale manga ateva, me masalikiimim taatara ateae aue eturungia. Aghaauliaa etaimim va karika aue am mene taraieghi, lomosi ta nau eteva aue emae, me aue am ue va, ‘Niarangise ta lo ateva emaemae tale ararina ateae Vau eteva.’” ");
INSERT INTO emi_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kateva nau manga, Iesu ghe lao sio tani namanama tanganue kateva namuu ta Paresi etoa, me taumattu ngatoa karika laghe ghaaghaa velu mataira ta Iesu. ");
INSERT INTO emi_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Taita ateva, nimane me kkena ghe rorrongo, ghe tokatoka emua ta Iesu. ");
INSERT INTO emi_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iesu ghe kolomila tau ngai aapasunga tale inangari nipaopao me Paresi etoa va, “Vaalua uneita inangari nipaopao eaauliaa, masina tani ghelei emasina teva taumattu tale nau manga ateva, o karika?” ");
INSERT INTO emi_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Karika laghe liu poila. Iesu ghe posola taita ateva, me ghe ghelei emasinaiela, me ghe sungi veluela. ");
INSERT INTO emi_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Vara me ghe uela etaira va, “Arova teva etaimim, teva natuna o kiena ghaata kkena, ghele katuu velu sio tale liu eteva tale nau manga ateva, karika aue am ghele ae velue sae parasi?” ");
INSERT INTO emi_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Karika laghe roola tani liu inangarina. ");
INSERT INTO emi_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iesu ghe taatara vaalua katoa tana namuu ta Paresi etoa laghe taatara masi liuira tani toka, me ghe auliaala lo ateae oia kiukiu niaimatoongana ta taumattu ngakapa atoa: ");
INSERT INTO emi_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nau eteva kateva ange koloola tani lao tale ninamanama eteae, karika umene tara masi aitokatoka va utoka ta ngetana. Karika ukilakila va mene kateva taumattu la kolo teeiela mene namuu teeia ta ngetam. ");
INSERT INTO emi_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Lo ateva, unna ninamanama ateae, ghe kolo akapaiemaluela, aue emae etam me eue va, ‘Tinginala, me ierai etoka sio!’ Aue upalata, nau la ghaaio me la ghoa atokaio emuli. ");
INSERT INTO emi_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nau eteva ngila koloola, ulaa toka sio tale aitokatoka ateva emuli. Nau lo ateva, unna ninamanama ateae, emae, eue va, ‘Kapughu, mae sio, me ulaa toka tale masi aitokatoka ateva.’ Isaa o voto aue eghelei, masi ararim ateae emua tale taumattu ngakapa atoa tale lo ateae o nivelu eitauaa. ");
INSERT INTO emi_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","See ualoanna tani saeaa nannaam, aue God eatokaio sio euu, me see usiuaa nannaam aue God eatokaio sae epona.” ");
INSERT INTO emi_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Iesu ghe uela ta taumattu ngateva unna ninamanama ateae va, “Nau eteva ualoanna tani ghelei ninamanama, urau mene kolo kapum atoa, tuem atoa, nengam atoa, mangalim atoa, o taumattu tue peipeiena, poli auena la mene koloo me la liu voto ughe gheleila ta ngetaira. ");
INSERT INTO emi_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nau ughelei ninamanama ateae, ukolo lo atoa karika righi peiira, tokatoka ngeuu etoa, kke tapakase atoa, me mata salusaluna atoa; ");
INSERT INTO emi_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","aue ughaa niarangise, poli ila karika la rooroo tani liu voto ughelei ta ngetaira. God aue eliu, tale nau eteva tau ghulughuluena atoa aue la totu tale nimate.” ");
INSERT INTO emi_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nau eteva kateva tana taumattu ghe tokatoka tale ia o ninamanama ateae ghe nongola isaa oia inangari, me ghe uela ta Iesu va, “Niarangise aue eghaa lo atoa aue la toka tale paka ninamanama ateae tale ararimangalina ateva God!” ");
INSERT INTO emi_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iesu ghe uela etana va, “Kateva taumattu ghe aimonomonosiaala kinatama ninamanama ateae, me ghe suula inangari ta oroi taumattu va la mae. ");
INSERT INTO emi_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ghe ghaala nau ninamanama, me ghe suula kapuna tau ngai nongonongo anna ateva va elaa kolo taumattu ang ghe uela va la mae, ta voto akapa ang ghe aimonomonosiaala. ");
INSERT INTO emi_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ila akapa laghe tiuaala tani aikamekameaa me laghe aauliaa vaalua me karika laghe roola tani lao. Aitiutiu eteva ghe uela ta tau ngai nongonongo anna ateva va, ‘Aghe polila tuku kosa ateva. Aghaloanna tani laa taraia. Alousiusi, ta karika aue amae.’ ");
INSERT INTO emi_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Mene kateva ghe uela va, ‘Aghe polila kasangaulu (10) kieghi vulumakao, me alaolao tani taraila, me atoongainila tani uungu, alousiusi ta karika aue amae.’ ");
INSERT INTO emi_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Mene kateva ghe uela va, ‘Amina laila, o karika arooroo tani mae.’ ");
INSERT INTO emi_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Tau ngai nongonongo anna ateva ghe lao sio, me ghe auliaala ta vauna ateva. Vau eteva ghe sessaiela, me ghe uela etana va, ‘Ailuiluila, me ukasu parasi me ulao tale liu nivelu eitauaa, me tale salana atoa tale masaliki taatara, me ukolo mae lo atoa karika righi peiira, tokatoka ngeuu etoa, mata salusaluna atoa, me kke tapakase atoa.’ ");
INSERT INTO emi_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Tau ngai nongonongo anna ateva ghe kasula tani ghelei llo vauna ateva ghe auliaala, me nau ghe kiriaa mae sio, ghe uela va, ‘Inangarim ngami gheleila, me oroi aitokatoka karika righi taumattuna.’ ");
INSERT INTO emi_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Vauna ateva ghe uela va, ‘Ulao tale salana namuu, me ukkele valaa tale ghauna salana, me ukolo asarasarakana taumattu ngatoa, me la mae, me la ghapasu aleghi eteva. ");
INSERT INTO emi_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Aghaauliaa etaimim va karika poi teva taumattu aghe kolo akasinala, aue la nama aneghi inana!’” ");
INSERT INTO emi_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Oroieili taumattu ngatoa laghe usiusi see Iesu. Ghe kiriela me ghe uela etaira va, ");
INSERT INTO emi_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Lo ateva ualoanna tani aimuli teeieghi, karika urooroo va ukapughu disaepolo arova utam rooroo tani rati etoka tamam me kinam, vausenim ateva me natum atoa, tuem atoa me nengam atoa, me maamauluaam. ");
INSERT INTO emi_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","See karika urooroo tani sunuki unem ateva tani aikotoo, me umae aimuli etaghi, karika urooroo tani kapughu disaepolo. ");
INSERT INTO emi_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Arova teva etaimim eaimonomonosiaa tani atulu ale ateva, etokatoka sio mua, me etara mua va ghaisa aipolina, me tani tara va viliki veu rooroona tani ruu ale ateva, o karika. ");
INSERT INTO emi_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Arova etiuaa ale ateva me etam rungia, taumattu ngatoa aue la amammarasa, ");
INSERT INTO emi_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","me la ue va, ‘Ia o taumattu ngateva ghe tiuaala ale ateva, me karikaaili ang ghe roola tani rungia!’ ");
INSERT INTO emi_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Arova kingi eteva ange laolao tani aiuuvii, me kapuna tau ngai uuvi etoa erooroo kasangaulu airari (10,000), aue etoka mua, me eannaa va erooroo tani laa aiuvii tee mene kateva kingi, kapuna tau ngai uuvi etoa erooroo ghaluengaulu airari (20,000), me aue apalaia, o karika? ");
INSERT INTO emi_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Arova karika erooroo, aue esungi kapuna tau ngaikasuaa inangari etoa tani laa sou kingi eteva, me la loo luei nau eteva masau ila. ");
INSERT INTO emi_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Tale ia nonga o salana atikirighi, karika teva etaimim erooroo tani kapughu disaepolo, arova etam oghi vulu peina akapaaili. ");
INSERT INTO emi_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Uela ateva masina ia, me marova ekapa namina, vaalua urooroo tani mene ghelei me emene tue namina? ");
INSERT INTO emi_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ia o ase uela ateva karika ita rooroo tani ghelei righi voto etana, liuna avalua o me la nim sausau velu. “Lo ateva talingane manee tani nongo, aue enongo.” ");
INSERT INTO emi_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kateva nau, tau ngai ghaa takis atoa me tau ssavoto atoa, laghe mae sio tani nongo Iesu. ");
INSERT INTO emi_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Paresi etoa me tau ngai aapasunga tale inangari nipaopao atoa, laghe tiuaala tani auliuliaa Iesu, laghe ue va, “Ia oia taumattu ngateva ealoanna tau ssavoto atoa tani toka, me tani namanama teeila.” ");
INSERT INTO emi_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Me Iesu ghe auliaala etaira kiukiu niaimatoongana ateae etaira. Ghe uela va, ");
INSERT INTO emi_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Arova kateva etaimim kiena sipsipi erooroo kateva ai (100), me kateva etaira ghele raua, am annaa va karika aue ghele kasu vuli ghasiongaulu ghasio (99) sipsipi nongina la ghele namanama, me ghele laa pae lo ateva ghe rauela, lomosi ta aue ghele taraia? ");
INSERT INTO emi_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nau eteva ghele taraia, aue ghele masimasi, ghele saua, me ghele alokoie sae ta pappana, ");
INSERT INTO emi_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","me ghele saue lao tanganuena. Aue ghele kolo kapuna akapa atoa, me lo atoa la tokatoka kalakalaa teeia, me ghele ue ta ngetaira va, ‘Masimasiaaghi namungaili, poli ngatarala kieghi sipsipi eteva ghe rauela. Am mae masimasi teeieghi!’ ");
INSERT INTO emi_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Aghaauliaa etaimim va, tale isaa o ase salana, namungaili nimasimasi elutulutu epona liu, nau eteva kateva tana tau ssavoto enanna ngaioghioghiaa ta ghasiongaulu ghasio (99) taumattu ghulughuluena, karika righi kaluira ssavoto va la nna ngaioghioghiaa. ");
INSERT INTO emi_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Marova teva vause unna kasangauluvilau (10) viliki veu, me ghele rau kativilau, sa ateva aue ghele gheleia? Aue ghele arokoti kurane lam ateae, me ghele kkala tani paea amasinaaili alena ateva, lomosi ta ghele taraia. ");
INSERT INTO emi_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nau ghele taraia, ghele kolo kapuna atoa, me lo atoa la tokatoka akalakalangina tanganuena, me ghele ue va, ‘Masimasiaaghi namungaili, ta ngatarala uneghi viliki veu etivilau ghe rauela. Am mae masimasi eitauaa teeieghi!’ ");
INSERT INTO emi_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Tale ia o ase salana atikirighi, aghaauliaa etaimim va ensolo atoa kapuna ila God, masimasiaaira namungaili, nau eteva kateva tana tau ssavoto enanna ngaioghioghiaa.” ");
INSERT INTO emi_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iesu ghe mene uela va, “Taumattu ngateva, natuna taita alua. ");
INSERT INTO emi_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Muli eteva taita ghe uela ta tamane va, ‘Tamaghi, tau mae peighi nau umate aue aghaa.’ Me tamairarua ghe koitaala peiirarua natuna taita alua. ");
INSERT INTO emi_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Karika masau nau ghe lange sio me muli eteva taita ghe tau ekapala peina laghe polila, ghe ghaala viliki veu, me ghe kasula tani lao tale masau patunganue namuu. Ghe tiuaala tani poli aloannaane, ");
INSERT INTO emi_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","me unna viliki veu ghe kapala, me tale isaa o nau, paka maloo ateva ghe tinginala, me ghe karikala righi peina. ");
INSERT INTO emi_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Liuna avalua o me ghe lao sio tani pae niuungu. Kateva taumattu tale ia o patunganue namu ngateae ghe sungiela tani laa ghaitoiaa mosu etoa me eanginila. ");
INSERT INTO emi_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Eghe aloannaaili tani nama righi inana aneira mosu etoa, poli karika teva ghe tautau lao righi inana va ghe nama. ");
INSERT INTO emi_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Nau eteva masi ninannaa ghe ghaaiela me ghe uela va, ‘Kapuna tau ngai uungu etoa tamaghi oroieili aneira inana, me aghi oia maloo ateva ange gheelei emateaghi! ");
INSERT INTO emi_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Akasu, me alao ta tamaghi, me aue alaa ue va, “Tamaghi, aghe ghelei saasakiaala ta mata God, me ta matam. ");
INSERT INTO emi_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Karika masina aghi va uaseaghi va natum ieghi; uaseaghi va marova kateva kapum tau ngai uungu.”’ ");
INSERT INTO emi_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ghe tingina saela, me ange laolao ta tamane. “Masau ia tanganue tamane, me tamane ghe taraiela; urunguitanina ateva ghe pasula tale nialousiusi, me ghe ilou lao sio tani sou natuna, me ghe llotiela me ghe ngusuela. ");
INSERT INTO emi_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Aliki taita ateva ghe uela va, ‘Tamaghi, aghe ghelei saasakiaala ta mata God, me ta matam. Karika masina aghi va uaseaghi va natum ieghi.’ ");
INSERT INTO emi_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Me tamane ghe uela ta kapuna tau ngai uungu etoa va, ‘Am ailuiluila! Am maeaa sio teva aiaasae masinaaili, me easae. Am atokala teva ringi ta vuuvuu nimane, me am asae taula lua aikasukasu ta kkena. ");
INSERT INTO emi_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Am laa ghaa morona ateva natu vulumakao, me am uvi ematea, me ita namanama aitauaa teeia, me ita masimasi. ");
INSERT INTO emi_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Poli ia oia natughu taita ateva ghe matela, me ange mene sakesakela, me ghe rauela, me ange rekatala.’ Me laghe tiuaala tani masimasi. ");
INSERT INTO emi_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Karika masau, me natuna mua ateva taita ghe oghiaa mae sio etapaa ngutana. Eghe kasukasu emaemae, ang ghe kalakalangina elo ale, me ghe nongola paka mangalia ateva tale nikau me niloku. ");
INSERT INTO emi_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ghe kolola kateva tani aliki, me ghe kolomiela va, ‘Vaalua me la gheelei mangalia ateva okae?’ ");
INSERT INTO emi_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Aliki eteva ghe liula me ghe uela va, ‘Nengam ateva ange rekatala. Tamam euvi ematela morona ateva natu vulumakao, poli nengam ange mae sio tani rekataa etana, me ange masimasi.’ ");
INSERT INTO emi_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Mua ateva taita ghe sessaiela, me ghe tam aloannala tani sso elo ale. Tamane ghe ghoa mae tani aipoopoliaa poi teeia. ");
INSERT INTO emi_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ghe liula ta tamane me ghe uela va, ‘Tarala, ninamanama atoa ngaghe uungula etam nonginaaili tau ngai nongonongo anna ateva, me karika poi aghe nongonongo vulu inangarim. Sa ateva ughe taue mae sio etaghi? Karika poi va ughe tau mae sio arova nim teva natu meemee va aghe ghelei teae ninamanama, me aghe masimasi eitauaa tee kapughu etoa! ");
INSERT INTO emi_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Me natum taita ateva oia ghe nim lao sio tani rungia see peim tale vause ngetapaa salana atoa, me nau erekatala, ughuvi ematela morona ateva natu vulumakao va eanna ia!’ ");
INSERT INTO emi_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Tamane ghe liula me ghe uela va, ‘Natughu, io utokatoka teeieghi nau ekapa atoa, isaa akapa peighi peim. ");
INSERT INTO emi_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Me ita velu eitauaa me ita tani masimasi, poli nengam ghe matela, me ange sakesakela, me ghe rauela, me ange rekatala.’” ");
INSERT INTO emi_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu ghe uela ta kapuna disaepolo atoa va, “Kateva tau peipeiena, kapuna tau ngai uungu eteva, laghe ue va karika masina ia, ta karika ghe aaitara ngamasina peina kapuna namu ngateva. ");
INSERT INTO emi_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kapuna namu ngateva ghe koloala me ghe kolomiela va, ‘Vaalua tale inangari anongonongo la ghaauliaa teeio? Laa ghaimonomonosiaa kiukiuna uunguaam tale peighi uaaitaraa, poli karika urooroo tani mene aitaraa peighi.’ ");
INSERT INTO emi_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Tau ngai uungu eteva ghe nnaala va, ‘Kapughu namu ngateva ange ghaaghaa velu niuungu etaghi. Sa ateva agheleia? Karika sarasarakana ieghi tani kaikai me palatanna ieghi tani nim loo viliki veu. ");
INSERT INTO emi_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ngakilala sa ateva agheleia, me nau eteva aruu tale niuungu, taumattu ngatoa aue la ghaikoloainaghi nau alao tanganueira.’ ");
INSERT INTO emi_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Liuna avalua o me ghe kolokolo kateva kateva tale taumattu laghe nim ghaala voto ta vauna ateva. Ghe kolomila aitiutiu eteva va, ‘Ghaisa kalum voto ughe nim ghaala ta vaughu eteva?’ ");
INSERT INTO emi_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Lo ateva taumattu ghe nim ghaala voto ghe liula me ghe uela va, ‘Ghaoalu ai (800) galon oliv oeli.’ “Tau ngai uungu eteva ghe uela etana va, ‘Ghaala uru ngai etikirighi laghe pitila kalum voto ughe nim ghaala ta vaughu eteva, me arovaeaata ta utoka sio, me upiti nonga ghaata ai (400).’ ");
INSERT INTO emi_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Me ghe kolomila mene kateva va, ‘Ghaisa kalum voto ughe nim ghaala?’ “Me taumattu ngateva ghe uela va, ‘Kateva ai (100) aikaai uiti.’ “Tau ngai uungu eteva ghe uela etana va, ‘Ghaala uru ngai eteva laghe pitila kalum voto ughe nim ghaala etana, me upiti nonga ghaoalungaulu (80).’ ");
INSERT INTO emi_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Nau vauna ateva ghe kilala voto kapuna sesa tau ngai uungu eteva ghe gheleila, ghe arueiniela, poli ghe gheleila voto tau muenna nonga atoa la gheelei. Taumattu tale kosa ateva oia muennaaili ila tale ase salana tani ghelei uunguaaira, me taumattu tale mallanga atoa karika. ");
INSERT INTO emi_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Aghaauliaa etaimim va am ghinaghina masi voto tale kosa ateva tani ghelei, me eoroi kapuimim. Me nau eteva isaa o voto ekapa aue la masimasi tani ghaaiem tale voto ateva tokatoka liu ia. ");
INSERT INTO emi_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Lo ateva la atoka tuutuliira etana tale lutu voto pisike, aue la atoka tee tuutuliira tee etana tale namuu voto. Me lo ateva etam gheelei voto koronna tale lutu voto pisike, karika aue eghelei voto koronna tale llo voto namuu. ");
INSERT INTO emi_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Arova karika la ghaatoka tuutuliira etaimim tani aitaraa masi voto tale kosa ateva, karika teva aue eatoka tuutulina etaimim tani ghaa voto koronna. ");
INSERT INTO emi_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Me arova la tam aatoka tuutuliira va am rooroo tani aitaraa katoa peiira, karika teva aue ghele tau aatu righi voto va ghele peiimim. ");
INSERT INTO emi_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Karika teva tau ngai nongonongo anna erooroo tani uungu ta ghalua vau, poli aue ghele ssa tee kateva, me ghele aielousiaa kateva. O aue ghele nongo usilaa kateva, me ghele liu vilina ta mene kateva. Karika am rooroo tani uungu ta God me viliki veu.” ");
INSERT INTO emi_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Paresi etoa, la ghaielousiangaili viliki veu, nau laghe nongola isaa o inangari, laghe tiuaala tani amammarasa Iesu. ");
INSERT INTO emi_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Iesu ghe uela etaira va, “Am, am nim aaloanna tani aitaratarainam tani ghelei masi voto ta mata taumattu ngatoa, me karika, ta God nonga ekilakila urunguitaniimim, poli voto masinaaili ta mata taumattu ngatoa, sesaaili ta matane God. ");
INSERT INTO emi_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Inangari nipaopao me inangariira propete atoa laghe pitila, ghe laa ghaa sio nau ta Jon, me ghe tiuaala tale nau etiulu o, masi inangari tale ararimangalina ateva God laghe tiuaala tani ppooa ngaotua, me taumattu ngakapa atoa laghe annaaili tani kupi sso etana. ");
INSERT INTO emi_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Elomarase me kosa ateva lalu rooroo tani kapa, me teva tuku voto ghaunaaili tale inangari nipaopao karika erooroo tani kapa. ");
INSERT INTO emi_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Lo ateva erati vausenna ateva me elai ta mene teva vause ange lai sarila. Me lo ateva taita emene ghaa vause ateva oia laghe rati etokaiela, ia tee ange lai sarila. ");
INSERT INTO emi_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Kateva tau peipeiena ghe molumolu me ghe aasae masi ghinna atoa, me ghe gheelei ninamanama nau ekapa atoa. ");
INSERT INTO emi_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tapaa ngatamana tale valavala ateae tanganuena, tau nilooloo ateva, ararina ateae ta Lasarus, laghe mae aatokaia, pasu ia tale usai. ");
INSERT INTO emi_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ghe anna va enama llo inana aue ekatuu tale unna tevoo ateva tue peipeiena ateva. Me tee paua atoa laghe mae raarameaa usaina. ");
INSERT INTO emi_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ghe ghaala nau eteva, tau nilooloo ateva ghe matela, me ensolo atoa laghe saue lao sio, me laghe laa ghalokoi valainie sio ta Abraham. Tau peipeiena tee ateva ghe matela, me laghe kaieiniela. ");
INSERT INTO emi_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tale Hades, ghe aateateaa paka mmarikana ateva, me vara ghe sae taatara, me ghe tarala Abraham masaueili ia, me Lasarus ghe tokatoka valaa etana. ");
INSERT INTO emi_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ghe kolokolo saela etana me ghe uela va, ‘Tamaghi Abraham, alom eusieghi me usuu Lasarus tani asuu elo velena tale vuuvuu nimane ateva tale manu me esio amakarrii ramuramuti paaghi eteva, poli aghateateaa paka mmarikana tale kura ateae oia.’ ");
INSERT INTO emi_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Abraham ghe liula me ghe uela va, ‘Natughu, unnaa nau ta sakesake, io ughe ghaaghaa masi voto, nau Lasarus ghe ghaaghaa voto sesa. Me ghaine ange tokatoka amasina oia, me io angu ghaaghaa mmarikana. ");
INSERT INTO emi_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Me tee, elome etaimami me io, paka salesalena ateva easoaso. Lo atoa la anna tani kasu oia me la ghatu ona, karika la rooroo, me lo tee atoa la anna tani kasu ona me la mae etaimami, karika aue la roo.’ ");
INSERT INTO emi_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ghe liula me ghe uela va, ‘Tana aghaloannaaili, Tamaghi, va usuu Lasarus me elao tanganue tamaghi, ");
INSERT INTO emi_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","poli ghalima nengaghi, me Lasarus elaa ghauliaa kieira, poli ila tee la rau mae tale voto ateva oia sesaaili ia.’ ");
INSERT INTO emi_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abraham ghe liula me ghe uela va, ‘Inangariira Moses me propete atoa isaa okae etaira; aue la nongola.’ ");
INSERT INTO emi_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Tau peipeiena ateva ghe uela va, ‘Karika, Tamaghi Abraham! Arova teva ang ghe matela ghele lao etaira, aue la ghele nna ngaioghioghiaa tale kaluira ssavoto.’ ");
INSERT INTO emi_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Abraham ghe uela etana va, ‘Arova la tam rooroo tani nongo Moses me propete atoa, karika aue la akoronna voto, arova teva ghele totu tale nimate, me ghe auliaa etaira.’” ");
INSERT INTO emi_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu ghe uela ta kapuna disaepolo atoa va, “Voto egheelei taumattu ekaakatuu tale ssavoto ange ailutua, me aue esesaaili ta taumattu ngateva egheelei voto oia elutulutu! ");
INSERT INTO emi_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Aue ghele masinaaili etana marova la ghele iri atu etiulu maate ia ta ngalona, me la ghele ghoa allusia elo malionge, ta erau ghelei teva aliki va unna niaikaaiaa ekatuu. ");
INSERT INTO emi_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Am paniem tale voto am gheelei! “Marova tuem ateva o nengam ateva egheelei ssavoto, uaulia ngakorokorongana etana, me marova enna ngaioghioghiaa, ukkaluaa. ");
INSERT INTO emi_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Marova eghelei teeio voto karika masina ghaituaata (7) tale kateva nau, me emae kkaluaa ghaituaata, me eue va, ‘Nganna ngaioghioghiaala,’ ukkaluaa voto egheelei teeio etana.” ");
INSERT INTO emi_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apostolo atoa laghe uela ta Vau eteva va, “Ughelei unemami niaikaaiaa me enamuu.” ");
INSERT INTO emi_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Vau eteva ghe liula va, “Marova uneimim niaikaaiaa naanamungaane nongina katu ue ngai erighi ghaunaaili ia (mastet), am rooroo tani ue ta ai eteae o va etammuti tee uane, me emene ghoa pinosa elamana, aue ghele roo tani nongo usilainiem. ");
INSERT INTO emi_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Marova kateva etaimim kapuna tau ngai nongonongo anna ateva euungu etapaa ngutana, o eaaitaraa kiem sipsipi, nau ekiriaa mae elo ale, vaalua, aue uailuiluieinia tani namanama? ");
INSERT INTO emi_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Karika! Aue ughele ue etana va, ‘Uaimonomonosiaa aneghi inana, me uaipanipaniaa, me ukaisi tau mae aneghi inana, me uaku ateoghu me anamanama me aropi, me auena umina namanama me uropi.’ ");
INSERT INTO emi_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Vaalua, karika aue ukaili emasina tale uunguaane ange gheleila? ");
INSERT INTO emi_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nim nongina am, nau ngam gheleila voto God eaauliaa etaimim tani ghelei, airuuruu am nim ue va, ‘Uunguaamami arau, poli ami nim tau ngai nongonongo anna iemami erau.’” ");
INSERT INTO emi_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iesu ghe mene laa saesae eJerusalem, ghe kasu eloi lao sio tale aioloa ngateva eSameria me eGalilii. ");
INSERT INTO emi_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ghe kasukasu elaolao tale masaliki eteae, me kasangaulu (10) taita aneira tasussuku eteva, laghe sousouela, laghe tingina amasaula, ");
INSERT INTO emi_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","me laghe kolokolo atingina tani ue va, “Iesu! Namu ngateva! Alousiusi teeiemamila!” ");
INSERT INTO emi_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nau Iesu ghe tarailala, me ghe uela va, “Am lao sio, me am laa apasungainam ta pristi etoa.” Laghe kasukasu elaolao, me laghe raarangisanala. ");
INSERT INTO emi_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kateva etaira, nau ghe tarala va ghe raarangisanala, ghe oghi lao sio, me namungaili ta ghe tau saela God. ");
INSERT INTO emi_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ghe lao sio me ghe suuiaala ta liue kkena Iesu, me ghe kaili emasinala etana. Taita ateva oia aSameria ia. ");
INSERT INTO emi_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iesu ghe uela va, “Kasangaulu (10) taumattu la raarangisanala, me eaa ghasio (9)? ");
INSERT INTO emi_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Vaalua me taitani ngeleka ateva, ia nonga emae sio tani amasina ta God?” ");
INSERT INTO emi_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Iesu ghe uela etana va, “Tingina saela me ukasu; unem niaikaaiaa ange ghelei emasinaiola.” ");
INSERT INTO emi_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Katoa tana Paresi laghe kookolomi Iesu va lovisa ararimangalina ateva God aue emae. Ghe liula me ghe uela va, “Ararimangalina ateva God karika aue emae nongina am, am taatara. ");
INSERT INTO emi_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Karika teva aue eue va, ‘Tarala, ie toko!’ o, ‘Ie teke!’ ta ararimangalina ateva God ia oia elome ta ngetaimim.” ");
INSERT INTO emi_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Vara me ghe uela ta kapuna disaepolo atoa va, “Nau too emaemae, aue am aloannaaili tani tara Natuna ateva Taumattu ngateva tale teva nau, me karika aue am taraia. ");
INSERT INTO emi_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Katoa aue la ue etaimim va, ‘Tarala, ie teke!’ o, ‘Tarala, ie toko!’ Karika am mene akoronnaila va am usilaa. ");
INSERT INTO emi_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Poli nongina ravaravaia ateva eravaravaia elomarase, me emammallanga akapa tale pai etoa, aue enongina Natuna ateva Taumattu ngateva tale nauna ateva. ");
INSERT INTO emi_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Aitiutiu aue eateateaa mmarikana, me taumattu tale lo ateva oia vituu aue la ratia. ");
INSERT INTO emi_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Me nauna Natuna ateva Taumattu ngateva aue enongina nau Noa. ");
INSERT INTO emi_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Taumattu ngatoa laghe namanama me ropiropi, taita me vause atoa laghe lailai, me ghe ghaala nau eteva Noa ghe kupi ssola tale anua ateva, me manu ghagga ateva ghe mae sio, me ghe tturungi ekapailala. ");
INSERT INTO emi_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Aue enongina tee nau ta Lot. Taumattu ngatoa laghe namanama, ropiropi me laghe aaipoliaa peiira, laghe pasapasa, me laghe atuutulu. ");
INSERT INTO emi_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Me nau eteva Lot ghe kasu vulila eSodom, kura ateae me atu ramerame ghe sio mae epona liu, ghe tturungi ekapailala. ");
INSERT INTO emi_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Aue enongina nau eteva Natuna ateva Taumattu ngateva emae rekata. ");
INSERT INTO emi_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tale ia o nau eteva, taumattu ngateva etokatoka eleka tale ale ateva, erau mene kupi sso tanganuena va eso ghaa peina; aue enongina tee taumattu ngateva euungu tapaa ngutana, erau mene oghi ghoa tanganuena. ");
INSERT INTO emi_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Am annaa sa ateva ghe lutula ta vausenna ateva Lot! ");
INSERT INTO emi_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","See etootoonga tani asaangi maamauluaane, aue eraua; me see earau maamauluaane, aue esaanga. ");
INSERT INTO emi_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Tale ia o nau eteva, aghauliaa etaimim va, aue ghalua taumattu lalu aso tale kateae nonga aisalo eleivoo: kateva aue la ghaaia, me kateva aue la rati elokoia. ");
INSERT INTO emi_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Ghalua vause aue lalu gheelei putuputu palaoa: kateva aue la ghaaia, me kateva la rati etokaia.” ");
INSERT INTO emi_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Disaepolo atoa laghe kolomiela va, “Vau eteva, llo oia eaa aue elaa lutu?” Iesu ghe liula me ghe uela va, “Nongina eaa matena ateva taumattu easoaso, paka ghila atoa la veluvelu eitauaa.” ");
INSERT INTO emi_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iesu ghe auliaala kiukiu niaimatoongana ateae ta disaepolo atoa tani apasunga etaira va la tani looloo sae tale nau ekapa atoa, me karika la mene sio asoasoaa. ");
INSERT INTO emi_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Me ghe uela va, “Tale kateae masaliki tau ngai ghelei niaisakei eteva, karika ghe maamatauta God ateva, me tee karika ghe oneoneaa tee kasina taumattu. ");
INSERT INTO emi_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Me tee vause raue vulu eteva, ie tee elome tale masaliki eteae, ghe maemae nonga ta tau ngai ghelei niaisakei eteva. Ghe aaloannaaili va esausia, tale aloaloannaane. Ghe ue etana va, ‘Usausieghi tale tau ngai ssateeieghi eteva.’ ");
INSERT INTO emi_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","“Kasina nau ang ghe lange sio, karika ghe aloanna tani nongoa me sausia, vara me ghe nnaala va, ‘Arongona ta karika aoneoneaa God me taumattu tee atoa, me poli vause raue vulu eteva oia etautau mae maate etaghi, asausia, poli erou toka maemae nonga va eghelei emangooieghi.’” ");
INSERT INTO emi_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Vau eteva ghe uela va, “Am nongo inangarina sesa tau ngai ghelei niaisakei eteva ghe auliaala. ");
INSERT INTO emi_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Am annaa va God karika aue eghele sausi kapuna atoa ghe aimatoongainilala, la looloo sae etana tale llaa me voo? Vaalua, am annaa tee va aue ghele aippetana tani sausila? ");
INSERT INTO emi_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Aghaauliaa etaimim va arovaeangaili ta aue ghele sausila. Tale isaa o salana, nau Natuna ateva Taumattu ngateva aue esio tale kosa ateva, aue etara righi taumattu eaiesoaa etana?” ");
INSERT INTO emi_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kasina taumattu la nannainila nonga va ila ghulughuluena ila, me katoa taumattu karika. Iesu ghe kiukiuaala etaira ia oia kiukiu niaimatoongana ateae, ghe uela va, ");
INSERT INTO emi_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ghalua taumattu lalu ghe saela tale ale manga ateva tani looloo sae, kateva taumattu Paresi ia, me kateva tau ngai ghaa takis ia. ");
INSERT INTO emi_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Taumattu tale Paresi eteva ghe tingina saela me ghe looloo saela, me ghe aauliaa masi uunguaane. Ghe uela va, ‘God, aghi akaakaili emasina etam va aghi karika nongina lo atoa taumattu la ainao, gheeleiaaira karika masina, me la lailai sari, me nongina ia o tau ngai ghaa takis ateva. ");
INSERT INTO emi_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ghaluaata tale ghaitu (7) nau anaenae, me atautau aiaasokolo tale voto akapa aghaaghaa.’ ");
INSERT INTO emi_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Tau ngai ghaa takis ateva ghe tingina amasaula, me ghe sioaala nannaane, me ghe looloo saela, ghe uela va, ‘God, ualousiusi teeieghi, poli aghi tau ssavoto aghi.’ ");
INSERT INTO emi_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Aghaauliaa etaimim va ia oia taumattu ngateva, karika nongina Paresi eteva, nau ghe kasula tani lao tanganuena, God ghe taraiela va ia ghulughuluena ia. See esaeaa nannaane, aue God etaue sio euu, see esioaa nannaane euu, God aue eanamunamunganeia.” ");
INSERT INTO emi_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Taumattu ngatoa laghe maeaa sio natuira raaraina atoa ta Iesu, va esaoaa nimane etaira me earangiseila. Disaepolo atoa laghe tarailala me laghe pao rungainilala. ");
INSERT INTO emi_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Me Iesu ghe kolola natu ngaliki etoa laghe mae sio etana me ghe uela va, “Am tau velu natu aliki etoa la mae etaghi, karika am mene ghelei rungainila. Ta poli ararimangalina ateva God anueira ia taumattu ngatoa nongina natu ngaliki etoa. ");
INSERT INTO emi_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Aghaaulia ngakoronnaaili, va arova see karika eghaa lo ateva o ararimangalina God nongina natu aliki etoa, karika aue esso etana.” ");
INSERT INTO emi_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kateva namuu ghe mae sio ta Iesu, me ghe kolomiela va, “Masi tisa ngateva, vaalua aroo tani ghelei, me aghaa lo ateva o maulue tokatoka liu ia?” ");
INSERT INTO emi_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iesu ghe liula me ghe uela etana va, “Vaalua me uue va masina ieghi? Karika teva masina, ta God nonga masina ia. ");
INSERT INTO emi_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ukilakila inangari nipaopao eue va, ‘Karika umene lai sari, karika umene aiuvi emate, karika umene ainao, me tee karika umene kamekame tale niaisakei, uoneoneaa tamam me kinam.’” ");
INSERT INTO emi_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ghe uela ta Iesu va, “Isaa ona voto ngaghe aimuli teela nau aliki ieghi arau.” ");
INSERT INTO emi_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nau Iesu ghe nongola isaa o inangarina, ghe uela etana va, “Kateva voto karika ughe gheleia. Utau lao peim la poli, me ughaa viliki veu me ulaoa ta taumattu karika righi peiira. Arova ughelei evalua o, aue utau peipeiena epona liu, me umae aimuli teeieghi.” ");
INSERT INTO emi_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Me nau ghe nongola isaa o inangari, ghe alousiusila, ta poli ia tau peipeiena ia. ");
INSERT INTO emi_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iesu ghe taatara lao sio etana, me ghe uela va, “Aanasaaili ta tau peipeiena ateva tani kupi sso tale ararimangalina ateva God! ");
INSERT INTO emi_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Poli marova masukasukale ta teva kamolo tani kupi sso tale teae mata raum, aue emasukasukaleaili tee ta teva tue peipeiena tani kupi sso tale ararimangalina ateva God.” ");
INSERT INTO emi_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Taumattu ngatoa laghe nongoala, me laghe kolomiela va, “See nonga erooroo tani saanga?” ");
INSERT INTO emi_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iesu ghe liula me ghe uela va, “Voto taumattu karika erooroo tani ghelei, God nonga erooroo.” ");
INSERT INTO emi_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pita ghe uela etana va, “Tarala, ngami ghe kasu vulila tanganueimami me peiimami tani aimuli teeio!” ");
INSERT INTO emi_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Iesu ghe uela ta ngetaira va, “Aghaaulia ngakoronna etaimim va, arova teva taumattu ekasu vuli tanganuena, manna, tuena atoa, nengana atoa, kinna me tamana me natuna atoa, mausi ararimangalina ateva God, ");
INSERT INTO emi_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","aue God etau lao etana oroieili peina tale nau oia, me nau aue emae, eghaa lo ateva maulue tokatoka liu ia.” ");
INSERT INTO emi_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesu ghe kolo aitauaala kapuna kasangaulu ghalua (12) disaepolo, me ghe uela etaira va, “Ngita laa saesae eJerusalem, me isaa akapa inangari propete atoa laghe piti emuemuela ta Natuna ateva Taumattu ngateva aue ekoronna. ");
INSERT INTO emi_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Aue la taue lao ta taumattu ngeleka atoa, me aue la kusiaa teeia, me kangainia, me kanusuia, la parua, me la uvi ematea. ");
INSERT INTO emi_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Emuli tale kotolu nau, aue etotu.” ");
INSERT INTO emi_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Aloira disaepolo atoa karika ghe maamasaanga tee inangarina. Malloeana inangari ghe aaisulia, karika laghe kilakila sa ateva Iesu ghe aaulieinia etaira. ");
INSERT INTO emi_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nau Iesu ang ghe mae akalakalaa sio eJeriko, mata salusalu eteva ghe tokatoka tale sama salana atikirighi, uunguaane tani looloo. ");
INSERT INTO emi_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ghe nongonongo oroieili taumattu ngatoa laghe kasukasu elangelange nongina ghe tokatoka, me ghe samala, me ghe kolomilala va sa ateva ange lutula. ");
INSERT INTO emi_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Laghe uela etana va, “Iesu aNasareti ia toko ekasukasu emaemae.” ");
INSERT INTO emi_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Me ghe kolokolo va, “Iesu, natuna io Deivit, ualousiusi teeieghi!” ");
INSERT INTO emi_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Taumattu ngatoa laghe muemue, laghe paopaoa va, “Urou mene sama.” Me karika, ta ghe mene kolokolo anamuula tani ue va, “Natuna ateva Deivit, ualousiusi teeieghi!” ");
INSERT INTO emi_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iesu ghe tinginala, me ghe uela va, “Taumattu ngateva emae etaghi.” Nau ghe mae akalakalaa sio, Iesu ghe kolomiela va, ");
INSERT INTO emi_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Sa ateva ualoanna va agheleia etam?” Ghe liula me ghe uela va, “Vau eteva, aghaloanna tani taatara.” ");
INSERT INTO emi_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Vara me Iesu ghe uela etana va, “Angu taatarala; tale kalum niaikaaiaa angu masinala.” ");
INSERT INTO emi_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ia arau o me ghe taatarala, me ghe aimulila ta Iesu, ghe tautau sae ararina ateae God. Nau taumattu ngatoa laghe taraiela, ila tee laghe tau saela ararina ateae God. ");
INSERT INTO emi_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesu ghe ssola eJeriko, me ang ghe mene aainasiaa tani kasu. ");
INSERT INTO emi_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kateva taumattu ghe tokatoka okae, ararina ateae ta Sakies, namuu ia ta lo atoa uunguaaira tani ghaa takis, me tue peipeiena ia. ");
INSERT INTO emi_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ghe aloanna tani tara va Iesu saa taumattu ia, me karika ghe rooroo, ta poli tukunaaili ia, me oroieili taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Liuna avalua o me ghe ilou emuemuela me ghe saela ai eteae ta ghe kilakila va Iesu aue ghe mae avalua o. ");
INSERT INTO emi_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nau Iesu ghe rekatala tale ia o ai eteae, ghe taatara saela, me ghe uela va, “Sakies, kkure parasi sio mae, ta ghaine atani laa toka teeio tanganuem.” ");
INSERT INTO emi_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Gharavaea nonga ta ghe kkure siola, me ghe masimasieiliila me ghe kolola Iesu va lalu lao tanganuena. ");
INSERT INTO emi_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nau taumattu ngatoa laghe tara avaluela o, laghe tiuaala tani auliulieinia tani uue va Iesu ange lao sio tani toka tee tau ssavoto ateva. ");
INSERT INTO emi_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakies ghe tingina saela me ghe uela ta Iesu va, “Vau eteva, aue ataula kasina peighi ta lo atoa karika righi peiira. Me arova aghe kamekame me aghe ghaaghaa peiira taumattu ngatoa, aue aliu ghaatiaata.” ");
INSERT INTO emi_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Iesu ghe uela etana va, “God ange asaangila taumattu tale lo ateva oia ale, poli ia tee taumattu ngateva oia, tuvuna ia Abraham. ");
INSERT INTO emi_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Poli Natuna ateva Taumattu ngateva ghe sio mae tani pae me asaangi taumattu ghe rauela.” ");
INSERT INTO emi_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nau eteva laghe nongonongo isaa o inangari Iesu ghe aauliaa, me ghe mene tiuaala tani auliaa kateae kiukiu niaimatoongana, ta poli ang ghe reerekata eJerusalem, me taumattu ngatoa laghe annaa va Iesu aue ekingi tale ia arau o nau eteva. ");
INSERT INTO emi_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ghe uela va, “Kateva namuu ghe lao sio tale patunganue namuu masau tani ghaa ninamuu va ekingi, me auena emene kiri mae. ");
INSERT INTO emi_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ghe kolola kasangaulu (10) kapuna tau ngai nongonongo anna me ghe tau lao sio kativilau gol koen ta kateva kateva etaira. Me auena ghe kasu, ghe uela etaira va, ‘Am uungu tani mene saoaa mene righi lomose ta amene kiri mae.’ ");
INSERT INTO emi_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Taumattu ngatoa tale masalikina ateae karika laghe masimasieiniela, me laghe suula kasina etaira tani laa auliaa va, ‘Karika ami aaloanna va ierai enamuu etaimami.’ ");
INSERT INTO emi_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Me karika, ta ghe ghaala ninamu ngateae va ekingi, me ghe kiri lao sio tanganuena. Ghe kolola kapuna tau ngai nongonongo anna kasangaulu me tani tara va ngila ghe uunguaala mene righi viliki veu tani saoaa tale llo laghe ghaa akasinala o karika. ");
INSERT INTO emi_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Aitiutiu eteva ghe lao sio me ghe uela va, ‘Namu ngateva, unem gol koen ativilau, aghe uunguaala me aghe mene ghaala kasangauluvilau.’ ");
INSERT INTO emi_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Vauna ateva ghe liula va, ‘Masi uunguaam, poli ughe ghelei emasinala tale pisike niuungu, aue uaitaraa kasangauluae masaliki taatara.’ ");
INSERT INTO emi_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Aiaaghalua ateva ghe lao sio me ghe uela va, ‘Namu ngateva, unem gol koen ativilau, aghe uungula me aghe mene gheleila ghalimavilau.’ ");
INSERT INTO emi_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Me ghe uela etana va, ‘Me io, aue uaitaraa ghalimae masaliki taatara.’ ");
INSERT INTO emi_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Mene kateva kapuna tau ngai nongonongo anna ghe lao sio me ghe uela va, ‘Unem gol koen ativilau toko. Aghe suumi elokoiela tale tuku tapiri kalio ateva. ");
INSERT INTO emi_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Aghe matautainiola ta io karika masi taumattu io, unim ghaaghaa voto karika kalum, me unim mukemuke voto karika ughe pasala.’ ");
INSERT INTO emi_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Namu ngateva ghe liula me ghe uela etana va, ‘Aue uaisakei tale isaa o inangari uaauliaa, io sesa tau ngai nongonongo anna io. Ughe kilakila va aghi karika masi taumattu ieghi, anim ghaaghaa voto karika kalughu, me anim mukemuke voto karika aghe pasala. ");
INSERT INTO emi_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Vaalua me karika ughe alokoi ssola uneghi viliki veu tale ale aialokoi viliki veu eteva? Me nau eteva ngaghe kiriaa mae sio aue aghele ghaa tee llo laghe saoaa saela tee me llo aghe tau aatu.’ ");
INSERT INTO emi_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Me ghe auliaala ta lo atoa laghe tiitingina akalakalaa va, ‘Am ghaa vella unna gol koen ativilau, me am taue lao ta lo ateva ghe ghaala kasangauluvilau gol koen.’ ");
INSERT INTO emi_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Laghe uela va, ‘Namu ngateva, ia ang ghe ghaala kasangauluvilau!’ ");
INSERT INTO emi_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Me ghe liula me ghe uela va, ‘Aghaauliaa etaimim va lo ateva euungu aanasa tale voto laghe taula aue la mene saoaa mene kasina, me lo ateva karika euunguaa voto laghe taula etana aue la ghaa velu saa voto isaa etana. ");
INSERT INTO emi_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Me isaa o taumattu karika laghe aloanna va aghi akapuira kingi, am ghaaila mae me am uvi ematela emua ta ngetaghi.’” ");
INSERT INTO emi_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nau eteva Iesu ghe ruula tani auliaa llo oia, me ghe kasu emuemuela tani sae eJerusalem. ");
INSERT INTO emi_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nau eteva ang ghe aakalakalaa tale masaliki elua eBetpeis me eBetani tale motouru eteva la kolokolo va Oliv, ghe sungila disaepolo alua, ");
INSERT INTO emi_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","me ghe uela etairarua va, “Amalu lao tale ia o masaliki eteae. Me nau amalu kupi sso tale masaliki eteae, aue amalu tara atingina natu donki eteva iriiri etingina ia, karika teva taumattu ghe sae toka ta ngetana me ghe iloueinia. Amalu pulakaia, me amalu maeainia oia. ");
INSERT INTO emi_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Marova teva ekolomiemalua va, ‘Vaalua me amalu puupulakaia?’ amalu ue etana va, ‘Vau eteva eaaloannaia.’” ");
INSERT INTO emi_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nau lalu ghe lao sio, lalu ghe tarala va llo Iesu ghe auliaala, ghe koronnala. ");
INSERT INTO emi_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nau lalu ghe puupulakaia, tau kiena ghe kolomilaluela va, “Vaalua me amalu puupulaka natu donki eteva?” ");
INSERT INTO emi_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Lalu ghe liula me lalu ghe uela va, “Vau eteva eaaloannaia.” ");
INSERT INTO emi_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Lalu ghe laoainie sio ta Iesu, me lalu ghe pulela uneirarua aiaasae ngeleka epona tale ghaata kkena ateva, me laghe sausila Iesu tani sae toka sae etana. ");
INSERT INTO emi_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nau eteva Iesu ghe iilou elaolao, taumattu ngatoa laghe aalokoi aiaasae ngeleka tapaa salana. ");
INSERT INTO emi_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nau eteva ang ghe aakalakalaa tale voto ateva nongina salana atikirighi ghe laa siosio tale motouru eteva eOliv, ila akapaaili lo atoa laghe usiusi Iesu laghe tiuaala tani masimasieili. Laghe kikkinari enamungaili tani kkauaa sae God, ta poli laghe annaa isaa o mirikol laghe tarala Iesu ghe gheleila. ");
INSERT INTO emi_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Aue God eghelei emasina ta kingi eteva emaemae tale ararina ateae Vau ngepona ateva!” “Luei etoka epona liu, me ita tau sae ararina ateae God iaaili epona!” ");
INSERT INTO emi_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Katoa elome tale ila o taumattu ngatoa Paresi ila laghe ue ta Iesu va, “Tisa, pao rungaala kapum disaepolo atoa!” ");
INSERT INTO emi_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Iesu ghe liula me ghe uela etaira va, “Aghaauliaa etaimim va, marova la matua atoka, aue atu etoa la sama anamungaili tani tau sae ararighi eteae.” ");
INSERT INTO emi_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nau eteva ang ghe aakalakalaa me ghe taatara siola eJerusalem, ghe alousiusi teeiela. ");
INSERT INTO emi_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Me ghe uela va, “Jerusalem, ghaine tale nau eteva oia aghaloanna va arova ughele kila sa ateva ghele gheleio me ughele toka tale luei. Me karika, ta isaa o voto eaaisulia etam, me karika urooroo tani tara kila. ");
INSERT INTO emi_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nau too emaemae aue tau ngai ssateem atoa, aue la atulu aivativati eteva, me la talieinio, me la toka rungainio tale pai ekapa. ");
INSERT INTO emi_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Aue la tturungio, io me taumattu ngatoa la tokatoka elome etam. Karika aue la rati etoka tiulu atu va aue emene toka saoaa ta mene tiulu, ta poli karika ughe kilala nau eteva God ghe mae sio tani sausio.” ");
INSERT INTO emi_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Iesu ghe ssola tale ale ngeleka atiulu tale ale manga ateva, me ghe ameti velu ghoala lo atoa laghe aaitauaa me laghe aaipoliaa elome. ");
INSERT INTO emi_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Me ghe uela etaira va, “Uru ngai Manga ateva eue va, ‘Aleghi eteva aue eale ailooloo sae ia,’ me ngam gheleiela va ‘aleira ale niaisulia ia tau niainao atoa.’” ");
INSERT INTO emi_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nau ekapa atoa ghe aapasunga asease voto tale ale manga. Namu ngatoa ta pristi etoa me tau ngai aapasunga tale inangari nipaopao, me lo atoa laghe muemueaa taumattu ngatoa, laghe paepae salana tani uvi emate Iesu. ");
INSERT INTO emi_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Me karika laghe rooroo, poli taumattu ngatoa laghe aloannaaili tani nongo Iesu. ");
INSERT INTO emi_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kateva nau Iesu ghe aapasunga ta taumattu ngatoa elome tale ale ngeleka atiulu tale ale manga ateva, ghe poppooaa masi inangari, me namu ngatoa ta pristi etoa, tau ngai aapasunga atoa tale inangari nipaopao me lo atoa la muemueaa taumattu ngatoa, laghe mae akalakalaa sio etana. ");
INSERT INTO emi_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Me laghe uela etana va, “See ghe tau aatu sio matuutuliena etam, me see ghe sungiola tani mae ghelei isaa oia voto?” ");
INSERT INTO emi_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Iesu ghe liula me ghe uela va, “Aghi tee amene kolomiem, me am liu mae etaghi. ");
INSERT INTO emi_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","See ghe tau lao sio matuutuliena ta Jon tani asuu, taumattu ngatoa, o God?” ");
INSERT INTO emi_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Laghe ailoela me laghe uela va, “Marova ita ue va, ‘God,’ aue eue va, ‘Me vaalua me karika am ghe aaiesoaa ta ngetana?’ ");
INSERT INTO emi_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Me marova ita ue va, ‘Taumattu ngatoa,’ taumattu ngakapa atoa aue la osaita tale atu, ta ila, la ghaaiesoaa va Jon propete ia.” ");
INSERT INTO emi_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Me laghe liula tani ue va, “Karika ami kilakila va see ghe taula matuutuliena.” ");
INSERT INTO emi_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Me Iesu ghe uela etaira va, “Aghi tee karika aue aghauliaa va see ghe tau mae sio matuutuliena etaghi.” ");
INSERT INTO emi_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Me ghe tiuaala tani kiukiuaa kateae kiukiu niaimatoonga. Ghe uela va, “Kateva taumattu ghe pasala utani uaeni etingiu, ghe taue lao sio ta katoa tau ngeutana tani aitarainia, me ghe kasu emasaueilila tani laa toka see. ");
INSERT INTO emi_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ghe ghaala nau eteva tani pariki utani uaeni etingiu, me ghe sungila kateva kapuna tau ngai uungu tani laa ghaa righi ue uaeni tale utani uaeni etingiu, me lo atoa laghe aaitaraa utana atingiu laghe uvi emaamateala me laghe sungi aaoghiela; karika ghe ghaala righi voto. ");
INSERT INTO emi_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ghe mene sungila mene kateva tau ngai uungu; me laghe mene uvi emaamateala, me laghe apalataiela me laghe sungi aaoghiela; ie tee karika ghe ghaala righi voto. ");
INSERT INTO emi_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Aiaakotolu eteva tau ngai uungu laghe uvi saasakieiniela me laghe sau velue ghoala eleka. ");
INSERT INTO emi_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Me tau ngumana ghe nnaala va, ‘Sa ateva agheleia? Aue asungi lo ateva natughu taita aghaailousiangailiia, me koti aue la oneoneainia.’ ");
INSERT INTO emi_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Nau eteva lo atoa laghe aaitaraa utani uaeni etingiu laghe tarala natuna ateva tau ngumana ghe maemae, laghe aailoe va, ‘Ia oia taumattu ngateva, auena eghaa peina tamane. Ita uvi ematea, me ita, aue ita ghaa akapa utana atingiu.’ ");
INSERT INTO emi_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Me laghe sau velue ghoala eleka me la ghe uvi emateala. “Sa ateva tau ngumana aue egheleia ta ngetaira? ");
INSERT INTO emi_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Aue emae me euvi emate akapa lo atoa laghe aaitaraa utani uaeni etingiu, me etau lao utana atingiu ta mene kasina ppae taumattu.” Me nau eteva taumattu ngatoa laghe nongola isaa oia inangari, laghe uela va, “Karika emene ghelei evalua o!” ");
INSERT INTO emi_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iesu ghe taatara lao sio etaira me ghe kolomilala va, “Isaa oia voto laghe pitila tale Uru ngai Manga ateva, malloeanina avalue toko? “‘Ia o atu eteva tau ngai atulu ale atoa laghe ratiela ghe aitiutiula tale atu ekapa atoa tani suei ale ateva.’ ");
INSERT INTO emi_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","See ukatuu saoaa tale ia o atu eteva, aue utakotokoto. Me arova ia oia atu eteva ekatuu saoaa sae etam, aue utaputuputu.” ");
INSERT INTO emi_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Me tau ngai aapasunga tale inangari nipaopao atoa me namu ngatoa ta pristi etoa laghe kilala va Iesu ghe auliaala kiukiu niaimatoonga mausi gheeleiaaira, me angila ghe paepae va vaalua la kuneia. Karika laghe roola, ta laghe maamatauta taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tau ngalomasaanga tale inangari nipaopao atoa me namu ngatoa ta pristi etoa laghe paepae salana tani kune Iesu. Laghe suula katoa tani gheleila va voto laghe aauliaa vara mene koronna. Laghe annaa tani ghaaia tale inangari ghe aauliaa, me la rooroo tani taue lao ta Gavana. ");
INSERT INTO emi_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Vara me laghe kolomiela va, “Tisa, ami kilakila va inangarim me llo uaapasunga koronna. Karika uaaimassiaa, me uaapasunga ngakoronna salane God. ");
INSERT INTO emi_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Vaalua uannaa? Inangari nipaopao eue va masina etaita tani tau lao takis ta Siisa o karika?” ");
INSERT INTO emi_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Iesu ang ghe kila vella kamekameaaira taumattu ngatoa oia laghe anna tani ghelei, me ghe uela etaira va, ");
INSERT INTO emi_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Am apasungaala tivilau viliki veu etaghi. See tootoona ateva me ararina ateae o etana?” Me laghe uela va, “Siisa.” ");
INSERT INTO emi_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Iesu ghe uela etaira va, “Liuna avalua o me am tau lao llo voto kanna Siisa, me llo voto kanna God am tau lao ta God.” ");
INSERT INTO emi_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Karika laghe roola tani ghaaia tale inangarina ghe aauliaa tale matavanga. Laghe soghiaala llo ghe liula me laghe paavoola. ");
INSERT INTO emi_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadiusi etoa, karika la ghaiesoaa tale nitotu tale nimate, katoa etaira laghe mae sio ta Iesu me laghe kolomiela kateva nikokkolomi. ");
INSERT INTO emi_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Laghe uela va, “Tisa, Moses ghe pitila va, ‘Arova taita ateva emate vulu vausenna ateva, me karika teva natuirarua, teva tuena o nengane taita etani ghaa vause ateva, me ealutu righi natuna lo ateva taita ang ghe matela.’ ");
INSERT INTO emi_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ia avalua o, me ghaitu (7) taita tue me nenga laghe tokatoka. Mua ateva ghe ghaala vause ateva, me karika teva natuna, me ghe matela. ");
INSERT INTO emi_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Aiaaghaluene ateva taita, ");
INSERT INTO emi_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","vara me aiaakotolu eteva ghe mene ghaala vause ateva, me ghe nim isaa avaluela o, me taita ghaitu oio laghe mate akapala, karika laghe alutula righi aliki. ");
INSERT INTO emi_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Airuuruu, vause ateva tee ghe matela. ");
INSERT INTO emi_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Isaa avalua o, me nau la totu tale nimate, nongina uauliaa, see aue evausenna ia, poli ila akapa laghe laila etana?” ");
INSERT INTO emi_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iesu ghe liula me ghe uela va, “Taumattu tale nau etiulu oia la lailai. ");
INSERT INTO emi_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Me lo atoa Vau ngepona ateva aue etaraila va ila ghulughuluena ila va la totu tale nimate, me la toka tale nau ekapa atoa, karika aue la mene lai, ");
INSERT INTO emi_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","poli karika aue la mene mate. Aue la nongina ensolo atoa. Ila natuna ila God, poli laghe totula tale nimate. ");
INSERT INTO emi_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moses tee ghe apasungaala etaita va taumattu la matemate aue la mene totu. Tale kiukiu eteae ghe pitiela tale nau eteva ghe tarala natu ai erighi ghe ataataia, ghe uela va, ‘Vau ngepona ateva kapuna Goto ia Abraham, me kapuna Goto ia Aisiki, me kapuna Goto ia Jekop.’ ");
INSERT INTO emi_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Me God ateva, karika va kapuira ia lo atoa matena ila, karika. Kapuira ia lo atoa maulue ila, poli ta taataraane God ila akapa maulue ila.” ");
INSERT INTO emi_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kasina tau ngai aapasunga tale inangari nipaopao laghe liula me laghe uela va, “Masinaaili, Tisa!” ");
INSERT INTO emi_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Me karika laghe mene roo poila tani kolomi mene righi nikokkolomi. ");
INSERT INTO emi_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Me Iesu ghe uela etaira va, “Vaalua me la ue va Mesaea tuvuna ia Deivit? ");
INSERT INTO emi_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Poli ia Deivit ghe uela ta vuku eteva ta Sams va, “‘Vau ngepona ateva ghe uela ta kapughu Vau eteva va, “Toka siola tale pai muenna ativilau ");
INSERT INTO emi_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","lomose ta aghatoka sio lo atoa la sessa teeio euu, me uatingina saoaa kkem etaira.”’ ");
INSERT INTO emi_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Isaa avalua o, me Deivit ekolokoloa va kapuna Vau eteva. Vaalua me mene tuvuna ia?” ");
INSERT INTO emi_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nau eteva taumattu ngakapa atoa laghe nongonongo, me Iesu ghe uela ta kapuna disaepolo atoa va, ");
INSERT INTO emi_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Am paniem tale tau ngai aapasunga atoa tale inangari nipaopao. La aloannaaili tani asae masi ghinna me nongina namu ngatoa, me la tingina kasu see, me la aloanna va taumattu ngatoa la soula tale masi inangari nongina oroi taumattu etokatoka. Me la aloannaaili tani toka tale uneira aitokatoka namu ngatoa elome tale ale nivelu eitauaa me nongina namu ngatoa la namanama. ");
INSERT INTO emi_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","La ghaaghaa aitautauaa peiira vause raue vulu etoa, me la kamekame tani ghelei aluseaili nilooloo sae. Nau eteva la lao tale niaisakei, aue la ghaa namungaili nimmarikana.” ");
INSERT INTO emi_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tale ale manga ateva, Iesu ghe atangarola me ghe tarala taumattu ngatoa tue peipeiena ila, laghe veluvelu viliki veu tale aikaai viliki veu eteva. ");
INSERT INTO emi_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Me ghe tara teela vause ateva raue vulu ia, karikaaili righi peina, ghe velu kaaila tapiri viliki veu eluevilau. ");
INSERT INTO emi_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Me ghe uela va, “Aghaaulia ngakoronna etaimim va ia o vause ateva raue vulu ia karika peina, ange kaaila oroi viliki veu, me ngeapalala katoa. ");
INSERT INTO emi_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Poli katoa oia oroieili uneira viliki veu etokatoka, me la nim vella nonga kasina tale aikaai eteva. Me ia o vause ateva karikaaili tivilau eoghi elokoila, ange kapaailila viliki veu eposoposo tani poli anna inana.” ");
INSERT INTO emi_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Katoa laghe aaruaa ale manga ateva. Laghe ue va, “Masinaaili taataraane atu, me kasina masi voto laghe tau lao sio ta God tani amolumolu emasina ia o ale ateva.” Me Iesu ghe uela va, ");
INSERT INTO emi_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Isaa o llo am aaruaa — nau too emaemae karika teva atu aue etoka saoaa ta mene kateva. Aue taumattu ngatoa aue la puli reerekata isaa akapaaili oia voto.” ");
INSERT INTO emi_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Me laghe kolomila va, “Tisa, aue lovisa isaa oia voto aue elutu? Me saa voto aue elutu tani apasunga va ange naula?” ");
INSERT INTO emi_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Iesu ghe liula me ghe uela va, “Am paniem teva taumattu erau mene kameam. Poli oroi taumattu aue la mae tale ararighi eteae, me la ue va, ‘Aghi Mesaea ieghi.’ Me aue la ghauliaa va nau ange mae akalakalaa sio, me am rau mene aimuli teeila. ");
INSERT INTO emi_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Am rau mene matautu nau am nongo niaiuvii me niamakatakata. Isaa o voto etani lutu ekasina me karika la ghaaimatoonga va airuuruu tale kosa ateva, ange rekatala.” ");
INSERT INTO emi_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Eghe mene auliaa tee lao sio etaira va, “Anua atoa aue la aiuvieinila, me ararimangali etoa tee. ");
INSERT INTO emi_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kinatama rukeruke atoa aue la lutu tale kosa ateva. Maloo atoa aue la lutu tale kasina masaliki me sessa atoa aue la lutu. Aue niaimatoonga sesaaili me matautuna aue elutu elomarase. ");
INSERT INTO emi_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Emua ta isaa akapa o voto, aue la kuneiem me aue am ghaa nimmarikana, me la laoainiem tale ale nivelu eitaua ngatoa tani aisakei, me la atokaiem tale ale mata voovoo. Aue la ghaaiem tani atinginaiem emua ta mata kingi etoa me gavana ngatoa tani aisakei, mausi ararighi eteae. ");
INSERT INTO emi_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Isaa avalua o me aue eoti salaimim tani ppooaa aikaaiaaimim ta ngetaghi. ");
INSERT INTO emi_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Liuna avalua o am rau mene aimonomonosiaa va saa inangari aue am liu etaira, ");
INSERT INTO emi_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ta aghi aue atau aatu inangari tani ppooaa me alomasaanga, me tau ngai ssateeimim atoa karika aue la rooroo tani liu. ");
INSERT INTO emi_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tamaimim me kinaimim, tueimim atoa me nengaimim atoa, me mangaliimim atoa me kapuimim atoa, ila tee aue la tauem lao ta tau ngai ssateeimim atoa, me aue la uvi emate katoa etaimim. ");
INSERT INTO emi_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ila akapaaili aue la ssa teeiem poli ararighi eteae. ");
INSERT INTO emi_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Me karikaaili tikirighi uu nguruimim aue eraua. ");
INSERT INTO emi_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Am tingina akorokorongana, me aue am ghaa maulue ateva tokatoka liu ia. ");
INSERT INTO emi_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nau eteva am tara eJerusalem tau niaiuvii etoa angila taatalieinia, aue am kila va eJerusalem nauna ange kalakalaala va la turungia. ");
INSERT INTO emi_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tale ia o nau eteva, lo atoa elome eJiudia am ilou sae tale motouru, me see atoa elome eJerusalem am kupi ghoa me am ilou. Me see atoa am tokatoka tale paa ngutana, karika am mene kupi sso eJerusalem. ");
INSERT INTO emi_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Poli nau tani ghaa aipolipoli tale sesa gheeleiaaira aJerusalem atoa me voto laghe piti elokoila tale Uru ngai Manga ateva ange lutulutu. ");
INSERT INTO emi_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Alousiusi ta lo atoa la suusunuku me lo atoa la sussu tale isaa o nau! Poli namungaili voto sesa tale ia o masaliki eteae, me sessaiaane God aue etoka tale isaa o taumattu. ");
INSERT INTO emi_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Katoa aue la uvi ematela tale baenata, me katoa aue la ghaaila nongina karavusu etoa tani lao tale kasina anua, anueira ativuu etoa, me aue anueira ativuu etoa la asa tau sio eJerusalem lomosina ta nauira eruu. ");
INSERT INTO emi_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Aue niaimatootoongana aue elutu tale sinaka ateva me ulana ateva me katto atoa. Tale kosa ateva, taumattu tale anua atoa aue la matautu me karika aue la alomasaanga tee lingi niaangarina manu eteva me manu ghagga ateva. ");
INSERT INTO emi_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Me taumattu aue ennangaili me la matautu poli la kila va voto sesa ange maemae tale kosa akapa ateva, poli God aue eghelei voto atoa korokorongana ila elomarase la ghaisiisia. ");
INSERT INTO emi_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tale ia o nau eteva aue la tara Natuna ateva Taumattu ngateva esio tale urukookoo tee sarasarakaniaane me kinatama mallangina ateva. ");
INSERT INTO emi_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nau isaa o voto etiuaa tani lutu, am tingina sae me am masimasi, poli nauna Vau ngepona tani asaangiem ange akalakalaala.” ");
INSERT INTO emi_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Me Iesu ghe mene auliaala kateae kiukiu niaimatoongana, “Am tarala fig ateae me mene kasina tana ai. ");
INSERT INTO emi_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nau eteva utara ange vubbuleaa uruna, angu kilala va masi nau tale sinaka ateva ange aakalakalaa. ");
INSERT INTO emi_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Liuna avalua o me nau eteva am tara isaa o voto, aue am kila va maemaeaane Natuna ateva Taumattu ngateva nongina kingi ange aakalakalaa. ");
INSERT INTO emi_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Aghaaulia ngakoronna etaimim va ia oia vituu eteva karika poi aue ekapa me isaa o voto aue elutu. ");
INSERT INTO emi_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Elomarase me kosa ateva aue lalu kapa, me inangarighi eteva karika poi aue ekapa. ");
INSERT INTO emi_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Am tani taatara amasina. Am rau mene laa ropi see sesa manu va am veeveena, me am rau mene annaa voto tale kosa ateva, ta erau gheleiem va am katuu, me am nim soghi ta ia o nau eteva erekata, ");
INSERT INTO emi_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","am nannaa va karika aue emae etana. Isaa o voto aue elutu tale taumattu ngakapa atoa la tokatoka tale kosa ateva. ");
INSERT INTO emi_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nau ekapa atoa am anguu taatara me am looloo sae va aue am sarasarakana tani saanga tale isaa oia voto ange anna tani lutu, me am rooroo tani tingina emua ta matane Natuna ateva Taumattu ngateva.” ");
INSERT INTO emi_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ellaa Iesu ghe aapasunga tale ale manga ateva, vara elo alai ghe sae asoaso tale motouru eteva eOliv. ");
INSERT INTO emi_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Vara elue talaua poopooa, taumattu ngakapa atoa laghe maemae tale ale manga ateva tani nongoa. ");
INSERT INTO emi_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nau nivelu eitaua ngateae tani nama verete karika righi isti etana ang ghe aakalakalaa, la kolokoloa va “Pasova.” ");
INSERT INTO emi_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Namu ngatoa ta pristi etoa me tau ngai aapasunga ngatoa tale inangari nipaopao laghe paepae righi salana tani uvi eisulia Iesu, me laghe maamatauta taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Satana ghe kupila Jiudas la kolokoloa va Iskariot, ia tee kateva ta kasangaulu ghalua (12) disaepolo. ");
INSERT INTO emi_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Liuna avalua o me ghe kasula tani laa aippooaa tee namu ngatoa ta pristi etoa me namu ngatoa ta polisi etoa, laghe aaitoiaa ale manga ateva, va vaalua erooroo tani tau lao Iesu etaira. ");
INSERT INTO emi_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Laghe masimasiangailiiela me laghe uela etana va, “Aue ami tau aatu righi viliki veu.” ");
INSERT INTO emi_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jiudas ghe aloannala me ghe tiuaala tani pae righi salana tani ghelei va la kune Iesu, nau taumattu ngatoa karika ila. ");
INSERT INTO emi_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ang ghe ghaala nau eteva tale nivelu eitauaa tale verete karika righi isti etana, me nau niuvi emate sipsipi, me la nama tale ia o Pasova ngateva. ");
INSERT INTO emi_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iesu ghe uela ta Pita me Jon va, “Amalu kasu me amalu laa aipanipaniaa ninamanama ateae ta Pasova.” ");
INSERT INTO emi_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Lalu ghe kolomiela va, “Eaa uanna va angalu laa aipanipanieinia?” ");
INSERT INTO emi_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ghe liula me ghe uela va, “Nau eteva amalu laa sosso tale masaliki taatara ateae, aue amalu sou taita ateva esuusunuki manu tale aikaai manu eteva. Nau eteva amalu taraia, amalu usie sso tale ale ateva. ");
INSERT INTO emi_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Me amalu ue ta lo ateva alena ateva va, ‘Tisa ngateva eanna tani kila va eaa ia rum atiulu enama inani Pasova tee kapuna disaepolo atoa.’ ");
INSERT INTO emi_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Me aue ia eapasunga rum atiulu, ia epona tale ale ateva namuu ia, voto akapa isaa etana. Amalu sae aipanipaniaa inana etana.” ");
INSERT INTO emi_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Lalu ghe kasula me lalu ghe lao sio, me lalu ghe tarala voto Iesu ghe auliaala etairarua, me lalu ghe aipanipaniaala inana tale Pasova ngateva. ");
INSERT INTO emi_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nau eteva ghe ghaala nau ninamanama, me Iesu me apostolo atoa laghe lao sio tale tevoo tani namanama. ");
INSERT INTO emi_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Me ghe uela etaira va, “Aghaaloannaaili tani namanama teeiem tale lo ateva oia Pasova, me auena aghaa nimmarikana. ");
INSERT INTO emi_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ta poli aghaauliaa etaimim va karika aue amene namanama tale mene teva Pasova lomose ta malloeanina koronna elutu tale ararimangalina ateva God.” ");
INSERT INTO emi_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iesu ghe ghaala kapa uaeni eteva, me ghe kaili emasina saela ta God, me ghe uela va, “Am ghaala, me am aikoita see elome etaimim. ");
INSERT INTO emi_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ta poli aghaauliaa etaimim va, karika aue amene ropi righi uaeni lomosina ta God aue eaitoia ngakapa kosa ateva.” ");
INSERT INTO emi_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Iesu ghe mene ghaala verete ateva, me ghe kaili emasinala, me ghe pirila, me ghe taue lao sio ta kapuna disaepolo atoa, me ghe uela va, “Isaa oia verete ateva malataughu ia, ngatautau aatu. Nau am namaia, am annainaghi nau ekapa atoa.” ");
INSERT INTO emi_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nau laghe ruula tani namanama, tale ia o salana atikirighi, ghe mene ghaala kapa ateva airopiropi ia, me ghe uela va, “Ia oia ouna ateva inangari niaippooa ngaitauaa tale raeghi eteva aue eakalaa etaimim. ");
INSERT INTO emi_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Me lo ateva aue etaueghi lao ta tau ngai ssateeghi etoa, ie tee oia tale tevoo ateva. ");
INSERT INTO emi_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ta poli Natuna ateva Taumattu ngateva aue elao nongina God ghe uela va elao, me alousiusi ta lo ateva ange tautau velua.” ");
INSERT INTO emi_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Me laghe tiuaala tani aikolomieinila va see etaira ange gheelei evalua o. ");
INSERT INTO emi_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Karika masau, me angila ghe mene aissakeana tee ninamu ngateae va see etaira aue tani namuu. ");
INSERT INTO emi_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iesu ghe uela etaira va, “Kapuira kingi etoa tau ngeleka atoa, la gheelei taumattu enim uungu aanasa etaira, me lo atoa la aitarainila, la ghaaloanna va taumattu ngatoa la asaesae arariira. ");
INSERT INTO emi_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Me am, karika am mene ghelei nongina ila la gheeghelei. Ta lo ateva etaimim namuu ia, etani sio euu nongina teva aliki, me lo ateva emuemuaa niuungu, etani nongina teva tau ngai nongonongo anna. ");
INSERT INTO emi_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Am annaa va, see tani namuu ia? Lo ateva etokatoka tale tevoo me enamanama, o lo ateva ekaakaisi anna inana? Lo ateva etokatoka tale tevoo me enamanama. Aghi atokatoka elome etaimim nongina tau ngai nongonongo anna ateva. ");
INSERT INTO emi_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Am, am ghe toka teeieghila, nau aghe ghaala nitootoonga. ");
INSERT INTO emi_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Me nongina Tamaghi ghe tau mae sio ararimangalina ateva tani aitarainia, ngamene tautau aatu ararimangali eteva etaimim tani aitarainia. ");
INSERT INTO emi_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Liuna avalua o me aue am namanama me am ropi tale uneghi tevoo ateva tale ararimangalighi eteva, me aue am toka tale uneira aitokatoka namu ngatoa, me am ghelei niaisakei tale kasangaulu ghalua (12) ararimangali nge Israel.” ");
INSERT INTO emi_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Vara me Iesu ghe mene uela va, “Saemon, Saemon, aghaauliaa etam va Satana ange kolomila va etootoongainam nongina la sausau kirikiri uit. ");
INSERT INTO emi_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Me aghe looloo saela mausim Saemon, va unem niaikaaiaa karika emene katuu. Me nau eteva ukiriaa mae etaghi, uakorokorongana nengam atoa.” ");
INSERT INTO emi_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pita ghe liula ta Iesu me ghe uela va, “Vau eteva, aghi aaipanipaniaa tani usio tani lao tale ale mata voovoo me tani mate teeio.” ");
INSERT INTO emi_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Iesu ghe liula me ghe uela va, “Aghaauliaa etam Pita, va auena paolo ateva taita ia eaangari elopai, aue uue akasina kotoluaata va karika ukilakilaieghi.” ");
INSERT INTO emi_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Vara me Iesu ghe kolomilala va, “Ia o nau eteva aghe sungiemla tani laa ppooaa masi kiukiu, me karika am ghe ghaala righi aikaai viliki veu, me aikaai ghinna, o aiaasae tale keke, am ghe annala mene righi voto?” Laghe liula me laghe uela va, “Karika.” ");
INSERT INTO emi_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Me ghe uela etaira va, “Isaa oia arova righi uneimim aikkaai viliki veu, am ghaa tee me uneimim aikkaai ghinna, me arova karika righi iemaimim baenata, am tau uneimim aiaasae ngeleka ateva me la polia, me am poli iemaimim. ");
INSERT INTO emi_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ta poli Uru ngai Manga ateva eue va, ‘Laghe ioi teeiela va, ie tee sesa taumattu ia,’ me aghaauliaa etaimim va, isaa o voto aue elutu etaghi. Nongina saa voto laghe pitila va aue elutu etaghi, ange maemae ta ekaurekati ekapa.” ");
INSERT INTO emi_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Disaepolo atoa laghe ue va, “Vau eteva, tarala, ghalua toko baenata.” Me ghe uela etaira va, “Ange roola.” ");
INSERT INTO emi_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iesu ghe kupi ghoala me ghe mene saela tale motouru eteva eOliv tani mene looloo sae nongina arau ghe gheeghelei, me disaepolo atoa laghe usiela. ");
INSERT INTO emi_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nau eteva laghe laa sae rekata, ghe uela etaira va, “Am looloo sae va karika am mene katuu tale nitootoonga.” ");
INSERT INTO emi_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Me ghe kasu vulilala, me ghe lao tee sio, maamasauaane nongina ughele osaosa tiulu atu, me ghe suuiaa siola patu kkena me ghe tiuaala tani looloo sae. ");
INSERT INTO emi_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ghe looloo sae avalua toko va, “Tamaghi, arova uanna, ughaa velu kapa nimmarikana ateva etaghi. Me ughelei nongina aloaloannaam, me karika va aloaloannaaghi.” ");
INSERT INTO emi_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ensolo ateva ghe kasula epona liu ghe sio mae tani akorokoronganaia. ");
INSERT INTO emi_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Iesu ghe ateateaala maamatana namungaili, me karika ghe aamaomao tani looloo sae. Ghe aaupaka, me aupaka ateva ghe akaakalaa sio tale kosa ateva tani nonginaaili rae ateva. ");
INSERT INTO emi_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ghe tingina saela nau eteva ghe ruula tani looloo sae, me ghe lao sio ta disaepolo atoa, me ghe tarailala va laghe aseasekanua, poli nialousiusi ghe ghelei emangoolala. ");
INSERT INTO emi_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ghe kolomilala va, “Vaalua me am aseasekanua? Am anguula, me am looloo sae va karika am mene katuu tale nitootoonga.” ");
INSERT INTO emi_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nau ghe tingina aippooaa me tana taumattu ngatoa laghe rekatala. Jiudas, kateva ta kasangaulu ghalua (12) disaepolo, ghe muemueinila. Ghe mae akalakalaa sio ta Iesu, tani ngusua. ");
INSERT INTO emi_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Me Iesu ghe uela etana va, “Aghaalousiusi teeio Jiudas, ta vara umene ngusungusueghi tale masi niaingusu, me karika ta angu aaitauaa Natuna ateva Taumattu ngateva ta tau ngai ssateena atoa.” ");
INSERT INTO emi_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nau eteva lo atoa laghe tiitingina tee Iesu laghe tarala sa ateva aue elutu, me laghe uela va, “Vau eteva, erooroo va ami aiuvii tale baenata?” ");
INSERT INTO emi_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Me kateva etaira ghe sai patela talingana muenna ativilau kapuna tau ngai nongonongo anna ateva namu ngateva ta pristi etoa. ");
INSERT INTO emi_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Iesu ghe uela va, “Ange roola!” Me Iesu ghe tulila talingana taumattu ngateva, me ghe mene masinala. ");
INSERT INTO emi_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Iesu ghe uela ta namu ngatoa ta pristi etoa, me polisi etoa laghe aaitaraa ale manga ateva, me lo atoa la muemueaa taumattu ngatoa, laghe mae sio tani kuneia va, “Am annaa va aghi amuemua tau niainao atoa, va am mae sio tee tuku ngai me baenata tani kuneieghi? ");
INSERT INTO emi_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Me isaa o nau ekapaaili aghe tokatoka teeiem tale ale manga ateva, me karika am ghe kunekuneieghi? Nau eteva oia ange nauimmi iela, nau eteva sarasarakaniaa saurrom ateva ange muemueinamla.” ");
INSERT INTO emi_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Laghe kuneiela, me laghe kasueiniela. Laghe laoainie sio tale alena ateva namu ngateva ta pristi etoa. Pita ghe aaimuli, me masaueili ia etana. ");
INSERT INTO emi_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Katoa taumattu laghe gheleila kura ateae elome tale valavala ateae, me laghe toka taliaala etana. Me Pita ghe toka teeila siola. ");
INSERT INTO emi_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Vause ateva tau ngai nongonongo anna ia ghe taraiela ta ghe tokatoka nongina kura ateae ghe ramerame, me ghe tara sossolainiela, me ghe uela va, “Ia tee, ia o taumattu ngateva ghe kasukasu teeia.” ");
INSERT INTO emi_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pita ghe ssakeaala me ghe uela ta vause ateva va, “Karika poi akilakilaia.” ");
INSERT INTO emi_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Karika masauna arighi me mene kateva ghe taraiela, me ghe ue etana va, “Io tee kateva etaira.” Me Pita ghe uela ta taita ateva va, “Karika va aghi tee.” ");
INSERT INTO emi_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kateva aoa ghe lange sio me kateva etaira ghe mene uela va, “Koronnaaili, ia oia taumattu ngateva ghe usiusia, ta ie tee aGalilii ia.” ");
INSERT INTO emi_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Me Pita ghe uela ta taumattu ngateva va, “Karika akilakila sa ateva uaaulieinia.” Nau eteva ghe tingina aippooaa me paolo ateva taita ia ghe aangarila. ");
INSERT INTO emi_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Vau eteva ghe kiriela me ghe taatara lao sio ta Pita, me Pita ghe annaala inangarina Vau eteva ghe auliaala etana ghe uela va, “Ghaine auena paolo ateva taita ia eaangari, aue kotoluaata uue va utam kilakilaieghi.” ");
INSERT INTO emi_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Liuna avalua o me ghe kupi ghoala, me ghe ngala alousiusieiliila. ");
INSERT INTO emi_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Lo atoa laghe aaitoiaa Iesu laghe tiuaala tani pilosia, me laghe uviuvia. ");
INSERT INTO emi_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Laghe sum rungaala matane, me laghe kookolomia va, “Uauliaa inangarina God va see ange posalaiola.” ");
INSERT INTO emi_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Me laghe aauliaa oroieili inangari karika masina tani auliaa teeia. ");
INSERT INTO emi_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nau eteva ghe paila, namu ngatoa me namu ngatoa ta pristi etoa me tau ngai aapasunga ngatoa tale inangari nipaopao, laghe toka aitauaala me laghe ssoaala Iesu etaira. ");
INSERT INTO emi_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Me laghe uela va, “Arova Mesaea io, uauliaa etaimami.” Me Iesu ghe liula me ghe uela va, “Arova aghauliaa etaimim, karika poi aue am aiesoaa etaghi. ");
INSERT INTO emi_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Me arova aghele kolomiem va vaalua nannaaimim tale Mesaea, karika poi aue am ghele liu. ");
INSERT INTO emi_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Me nau too emaemae karika masau me aue Natuna ateva Taumattu ngateva aue etoka tale pai muenna ativilau ta God ateva sarasarakanaaili ia.” ");
INSERT INTO emi_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Laghe kolomiela va, “Ia avalua o, me io Natuna io God?” Ghe liula me ghe uela va, “Ngam auliaala va aghi Natuna aghi God.” ");
INSERT INTO emi_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Laghe uela va, “Sa ateva inangari ita mene laa pae ta mene righi taumattu? Ta angita tani nongola ta paane.” ");
INSERT INTO emi_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Vara me ila akapa kansolo atoa laghe tingina saela me laghe kasueiniela, laghe laoainie sio ta Paelat. ");
INSERT INTO emi_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Me laghe tiuaala tani auliaa teeia. Laghe ue va, “Ngami ghe tarala taumattu ngateva etiitiuaa ppae kasina ninannaa tani ghelei saasakiaa tokatokaa taumattu. Karika ealoanna va ami tau lao takis ta Siisa, me eue va ia Mesaea ngateva, kingi ia.” ");
INSERT INTO emi_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Paelat ghe kolomila Iesu va, “Io kapuira kingi io aJiu etoa?” Iesu ghe liula me ghe uela va, “Ue, nongina uaauliaa.” ");
INSERT INTO emi_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Paelat ghe auliaala ta namu ngatoa ta pristi etoa me taumattu ngatoa va, “Karika ngatarala righi sesa gheeleiaane taumattu ngateva oia.” ");
INSERT INTO emi_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Me laghe aaulia ngasarasarakana va, “Ekasukasu ekapa see oia eJiudia, me etiitiuaa voto sesa tale voto eaapasunga tale taumattu ngatoa. Ghe tiuaala eGalilii me ange mae sio eriere.” ");
INSERT INTO emi_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tale nongonongoaane Paelat tale isaa o voto, ghe kolomila va, “Taumattu ngateva oia aGalilii ia, o karika?” ");
INSERT INTO emi_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nau eteva ghe kilala va Iesu ghe tokatoka tale pai etivilau King Herot ghe aaitarainia, ghe sungi taue lao sio ta Herot. Isaa o nau, Herot ghe sae mae eJerusalem. ");
INSERT INTO emi_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nau eteva Herot ghe tarala Iesu, ghe masimasieiliila, ta poli ang ghe aloanna vella tani taraia. Poli tale uunguaane ghe nongonongo, me ghe aloannaaili tani taraia eghelei righi mirikol. ");
INSERT INTO emi_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Eghe kolomiela tale oroi nikokkolomi, me Iesu karika ghe liu poila. ");
INSERT INTO emi_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Namu ngatoa ta pristi etoa me tau ngai aapasunga ngatoa tale inangari nipaopao laghe tiitingina, laghe aauliaa teeia inangari sarasarakanaaili. ");
INSERT INTO emi_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herot me kapuna tau ngai uvii etoa laghe piipilosia, laghe kangkangainia, me laghe amolumolu emasinaailiela, me laghe sungiela ghe mene lao sio ta Paelat. ");
INSERT INTO emi_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ia o nau eteva, Paelat me Herot lalu ghe aikapukapuaala, poli nau too ang ghe lao sio lalu ghe aaisessaii. ");
INSERT INTO emi_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Paelat ghe kolo aitauaala namuu ta pristi etoa, namu ngatoa me taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Me ghe uela etaira va, “Am maeaa sio taumattu ngateva oio etaghi poli am ue va ia etiitiuaa ppae kasina ninannaa tani ghelei saasakiaa tokatokaa taumattu. Ghe tiitingina emua etaimim me aghe kolomiela kasina nikokkolomi, me aghe tarala va karika righi gheeleiaane sesa. ");
INSERT INTO emi_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ta nim nongina Herot ange sungi aaoghie mae sio etaita. Am taatara va karika righi sesa gheeleiaane va eghaa nimate. ");
INSERT INTO emi_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Liuna avalua o anim parua, me atau velua.” ");
INSERT INTO emi_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Katengaata nonga ta laghe aiovaova ngalokoila tani ue va, “Ukasuaa taumattu ngateva ona, me utau velu Barabas emae etaimami!” ");
INSERT INTO emi_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas laghe atokaie ssola tale ale mata voovoo, ta poli ia ghe muemua niamakatakata tale masaliki taatara, me ghe aiuvi ematela.) ");
INSERT INTO emi_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Poli aaloannaane tani tau velu Iesu, Paelat ghe mene kolo taula taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Me laghe ovaova atingina me laghe ue va, “Avukalaie saela tale aikotoo!” ");
INSERT INTO emi_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Aiaakotonna ghe mene uela etaira va, “Poli saa? Sa ateva voto sesa taumattu ngateva oio ghe gheleila? Karika ngaghe tarala righi gheeleiaane sesa va emate, liuna avalua o aparua me atau velua.” ");
INSERT INTO emi_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Laghe ovaova me laghe akorokorongana va esae vukala tale aikotoo. Uneira niaore ghe koronnala. ");
INSERT INTO emi_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Paelat ghe nnaala va eaimuli tee aaloannaaira. ");
INSERT INTO emi_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ghe tau vella taita ateva laghe aloannaiela ghe tokatoka tale ale mata voovoo mausi ghe muemua niamakatakata me ghe aiuvi ematela, me ghe taula Iesu tale aloannaaira. ");
INSERT INTO emi_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nau eteva tau ngai uvii etoa laghe kaakasueinia elaolao, laghe kune atokala Saemon atala nge Saerini ia, ghe rekata sae mae me ghe aloanna tani sso tale masaliki taatara ateae. Me laghe tau lao sio aikotoo ateva etana va esaua, me eaimuli tee Iesu. ");
INSERT INTO emi_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Oroieili taumattu ngatoa laghe aaimuli tee Iesu, me elome etaira vause atoa laghe aalousiusi teeia. ");
INSERT INTO emi_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iesu ghe kiriela me ghe uela etaira va, “Vauseni nge Jerusalem atoa, am rau mene alousiusi teeieghi. Am alousiusi teeiem me natuim atoa. ");
INSERT INTO emi_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ta poli kateva nau aue emae, aue am ue va, ‘Nimasimasi tale vause atoa kina ngere ila, lo atoa karika righi natuira, me lo atoa karika laghe sussu.’ ");
INSERT INTO emi_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tale isaa o nau, “‘Aue la kolo motouru etoa va, “Am katuu saoaala etaimami!” me saesaena atoa va, “Am akouemamila!”’ ");
INSERT INTO emi_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Taumattu ngatoa la gheelei teeieghi, me karika aghe gheleila righi voto sesa. Alousiusi etaimim arova auena la ghelei teeiem, poli am ghe gheleila voto sesa.” ");
INSERT INTO emi_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mene ghalua taumattu, gheeleiaairarua sesa, laghe ghaa teeilaluela tani laa uvi ematelalua. ");
INSERT INTO emi_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nau eteva laghe lao sio tale voto ateva la kolokoloa va “Voto ateva arova Riu uru taumattu ngateva” etana, tale ia o voto ateva laghe avukalaie saela tee lo alua gheeleiaairarua sesa, kateva tale pai muenna ativilau, me kateva tale pai uaise ativilau. ");
INSERT INTO emi_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Iesu ghe uela va, “Tamaghi, ukkaluaa, ta poli karika la kilakila va voto ateva la gheeleia sesaaili ia.” Me tau ngai uvii etoa laghe tiuaala tani anamisi tani aikoita ghinnanina. ");
INSERT INTO emi_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Taumattu ngatoa laghe tingina taatara, me namu ngatoa laghe attara teeia. Me laghe ue va, “Ghe asaangila katoa, tau veluela me easaangia, kotiva kapuna Mesaea ia God, me God ghe suitoongainiela.” ");
INSERT INTO emi_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Tau ngai uvii tee atoa laghe saela, me laghe piipilosia, me laghe tau lao sio manu eteva sarasarakana ia, ");
INSERT INTO emi_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","me laghe ue va, “Kotiva kapuira kingi io aJiu etoa, uasaangio.” ");
INSERT INTO emi_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Epona etana laghe pitila tuku inangari eteva va, “Ierai oia kapuira kingi ia aJiu etoa.” ");
INSERT INTO emi_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kateva ta lo alua gheeleiaairarua sesa ghe aauliaa tee Iesu va, “Karika io va Mesaea io? Uasaangio me uasaangi teeiengalua!” ");
INSERT INTO emi_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mene kateva ghe sessaiela tani nongo, me ghe uela va, “Karika umaamatauta God? Poli kateva nonga ia aipolipoli eteva angita ghaaiela. ");
INSERT INTO emi_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Italua, italu ghaaghaa aipolipoli tale gheeleiaaitalua sesa. Me ia oio taumattu ngateva karika righi sesa gheeleiaane!” ");
INSERT INTO emi_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Vara me ghe uela va, “Iesu, unnainaghi nau eteva umae tale ararimangalim ateva.” ");
INSERT INTO emi_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Iesu ghe liula me ghe uela va, “Aghaaulia ngakoronna etam, ghaine angu toka teeieghila tale umana utana atingiu God.” ");
INSERT INTO emi_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Pai ngelo sinaka ativilau ghe mae sio, me saurrom ateva ghe akou ekapala kosa ateva lomosina ta 3 kilok elo alai, ");
INSERT INTO emi_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ta poli sinaka ateva ghe saurorromienala tale ia o voto ateva. Me kalio atiulu ghe vuuvukala tale ale manga ateva ghe tarriila me ghe ghaluevilaula. ");
INSERT INTO emi_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iesu ghe sama anamuula me ghe uela va, “Tamaghi, maamauluaaghi ngatautau aatu ta nimam.” Nau eteva ghe auliaala llo me ghe ainoana aruula me ghe matela. ");
INSERT INTO emi_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kapuira namu ngateva tau ngai uvii etoa ghe tarala isaa o voto ghe lutula, ghe tau saela God me ghe uela va, “Koronna, ia oia taumattu ngateva tau ghulughuluena ia.” ");
INSERT INTO emi_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Oroi taumattu laghe mae sio laghe tarala sa ateva ghe lutula, laghe aalousiusi me laghe kasula. ");
INSERT INTO emi_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Me lo atoa laghe kilakilaia me vause atoa laghe usiela arau eGalilii laghe tiitingina amasau, me laghe tarala sa ateva ghe lutula. ");
INSERT INTO emi_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kateva taita, ararina ateae ta Josep, ia kateva ta kansolo atoa me masi taumattu ia me ghulughuluena ia, ");
INSERT INTO emi_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","karika ghe lao aitauaa tee sio nannaaira kansolo atoa laghe nnaala me voto laghe gheleila. Tanganuena tale masaliki taatara ateae eArimatia, kateae uneira masaliki taatara aJiu etoa. Me ghe toitoi tani tara ararimangalina ateva God. ");
INSERT INTO emi_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ghe lao sio ta Paelat me ghe kolomila Iesu etana. ");
INSERT INTO emi_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Me ghe ghaaiela me ghe sumuela tale kalio, me ghe alokoiela tale lienga ateae laghe kai essola tale atu. Karika laghe alokoi poi teva taumattu etana. ");
INSERT INTO emi_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nau eteva oia nau niaimonomonosiaa ia, me nau manga ateva ang ghe aakalakalaa. ");
INSERT INTO emi_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Vause atoa laghe mae aitauaa tee sio Iesu eGalilii laghe mene usila Josep, laghe tarala lienga ateae, me laghe tarala vaalua laghe alokoie ssola. ");
INSERT INTO emi_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Vara me laghe lao sio tanganueira, laghe aimonomonosiaala voto masi ngusungusuaane. Me laghe ainoanala tale nau manga ateva nongina inangari nipaopao eaauliaa. ");
INSERT INTO emi_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Me tale aitiutiu eteva nau, elue talaua poopooa, vause atoa laghe ghaala voto masi ngusungusuaane laghe aimonomonosiaala me laghe lao sio tale lienga niaikkaia ngateae. ");
INSERT INTO emi_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Me laghe tarala atu eteva angila ghe atakiri veluela nongina laghe atingina rungaala atamani lienga niaikkaia ngateae. ");
INSERT INTO emi_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Laghe kupi ssola me karika laghe tarala Vau eteva Iesu. ");
INSERT INTO emi_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Laghe tingina nannaa, vara me laghe tarala taita alua lalu ghe tiitingina akalakalaa etaira, mallanga ateva tale ghinnaniirarua. ");
INSERT INTO emi_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Vause atoa oia laghe matautula, me laghe tturru siola tapaa kosa, me taita alua oia lalu ghe uela etaira va, “Vaalua me am paepae taumattu sakesake nongina taumattu matena? ");
INSERT INTO emi_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Karika ia oia; ange totula! Am rooroo tani annaa nongina ghe auliaala etaimim nau eteva ghe tokatoka arau eGalilii. ");
INSERT INTO emi_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ghe uela etaimim va, ‘Aue la tau lao Natuna ateva Taumattu ngateva ta nimaira tau ngai ghelei ssavoto atoa, me aue la avukalaie sae tale aikotoo ateva, me aue kotonna ateva nau aue emene totu.’” ");
INSERT INTO emi_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Me laghe nnaala isaa oia inangari Iesu ghe auliaala. ");
INSERT INTO emi_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Me laghe kasu vulila lienga niaikkaia ngateae. Nau eteva laghe kiriaa lao sio, laghe kiukiuaala isaa oia voto ta kasangaulu kateva (11) disaepolo, me mene katoa taumattu. ");
INSERT INTO emi_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Meri aMakdala ia, Joana, me Meri kinna Jeimis, me mene kasina vause, laghe auliaala isaa oia voto ta apostolo atoa. ");
INSERT INTO emi_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Me laghe nannaa va vause atoa laghe auliaa kapa atoa, me karika laghe aiesoaala inangariira. ");
INSERT INTO emi_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Vara me Pita ghe tingina saela me ghe ilou lao sio tale lienga niaikkaia ngateae, ghe turruaa siola me ghe tarala nonga kalio, me ghe oghiaa lao sio tanganuena, me ghe nnangailiila isaa o voto ghe lutula. ");
INSERT INTO emi_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ie nonga o nau eteva ghalua tana kapuna Iesu lalu ghe laolao tale kateae masaliki la asease va Emmaus, erooroo kasangaulu kateva (11) kilomita tani kasu eJerusalem me tani lao etana, ");
INSERT INTO emi_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","me lalu ghe kiukiuaa isaa akapa oia voto ghe lutula. ");
INSERT INTO emi_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Lalu ghe aaikolomi me lalu ghe kiukiu, me Iesu ghe sokotilaluela me ghe kasu eitauaa teeilaluela; ");
INSERT INTO emi_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","God ghe ghelei rungainilaluela va lalu rau mene tara kila Iesu. ");
INSERT INTO emi_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iesu ghe uela etairarua va, “Sa ateva amalu kiukiueinia nau eteva amalu kasukasu emaemae?” Lalu ghe tinginala, me taatarairarua ghe alousiusinnala. ");
INSERT INTO emi_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kateva etairarua, ararina ateae ta Kliopas, ghe liula me ghe uela etana va, “Koti io nonga kateva taumattu eJerusalem karika ukilakila saa voto ghe lutula isaa to nau ang ghe lao sio, no?” ");
INSERT INTO emi_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Iesu ghe kolomilaluela va, “Saa voto?” Lalu ghe liula me lalu ghe uela va, “Voto ghe lutula ta Iesu aNasareti ia. Ia oia taumattu ngateva propete ia, me inangarina me gheeleiaane sarasarakana ta matane God me taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kapuita namu ngatoa ta pristi etoa me mene katoa tau ngai toitoi laghe tau veluela me laghe uvi emateala tale aikotoo. ");
INSERT INTO emi_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ami ghe nannaa va ia oia taumattu ngateva aue ghe ghaa oghi ita aIsraeli etoa! Me tee, ghaine ange kotonna atevala nau isaa oia voto ghe lutula. ");
INSERT INTO emi_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Me tee, katoa kapuimami vause la asoghisoghiemamila; nau la siola nongina laghe alokoila Iesu, ");
INSERT INTO emi_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","me karika la taraiela. La oghila, me la uela va la tara nongala ensolo alua, me ensolo alua lalu uela va ange totula. ");
INSERT INTO emi_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Me katoa kapuimami la lao sio nongina laghe alokoila Iesu, me la tarala va koronna llo vause atoa la ghauliaala, poli karika la taraiela.” ");
INSERT INTO emi_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Me Iesu ghe uela etaira va, “Alokapakapa iemalua? Aanasaaili iemalua tani aiesoaa voto akapa propete atoa laghe auliaala! ");
INSERT INTO emi_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Karika amalu kilakila va Mesaea etani ghaa mua nimmarikana tale isaa o voto me auena ekupi sso tale mallangina ateva?” ");
INSERT INTO emi_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Vara me Iesu ghe kiri tau lao sio etairarua saa voto laghe auliaala ekiukiueinia elome tale Uru ngai Manga akapa ateva. Etiitiuaa tale unna vuku Moses me voto propete atoa laghe pitila. ");
INSERT INTO emi_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Vara angilotolu ghe reerekata tale masaliki eteae lalu ghe laolao etana, me Iesu ang ghe gheelei va ghe kasu vulilalua. ");
INSERT INTO emi_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Me angilalu ghe gheelei rungarungainia tani ue va, “Ita ghaso. Sinaka ateva ange laa siosio, me ghaisa ngarighi evoo.” Me ghe kupi ssola tani toka teeilalua. ");
INSERT INTO emi_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nau eteva ghe toka aitauaa teeilalue siola tale tevoo ateva, ghe ghaala verete, ghe kaili emasinala, ghe pirila me ghe tiuaala tani tau lao etairarua. ");
INSERT INTO emi_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Me matairarua ghe otila, me lalu ghe tara kilaiela, me ghe aikapakapaaiila tale taatarairarua. ");
INSERT INTO emi_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Me angilalu ghe aikolomieinilalua va, “Karika va isaa oia voto eataatala tale urunguitaniitalua nau eteva esamasama teeitalua tapaa salana me nau ekiri tau mae sio Uru ngai Manga ateva etaitalua.” ");
INSERT INTO emi_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Arovaeangaili ta lalu ghe tingina saela me lalu ghe kiriaa siola eJerusalem. Me lalu ghe tarala kasangaulu kateva disaepolo me mene katoa kapuira taumattu laghe tokatoka aitauaa ");
INSERT INTO emi_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","me laghe ue va, “Koronna! Vau eteva ange totula me erekataala ta Saemon.” ");
INSERT INTO emi_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Me taita alua lalu ghe kiukiuaala sa ateva ghe lutula tapaa salana, me vaalua lalu ghe tara kilala Iesu nau eteva ghe pirila verete. ");
INSERT INTO emi_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nau eteva laghe toka kiukiuaa isaa o voto me katengaata ta Iesu ghe tingina polakila elome etaira, me ghe uela etaira va, “Luei aue etoka aitauaa teeiem.” ");
INSERT INTO emi_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Laghe soghila me laghe matautula, ta laghe annaa va laghe tarala raroaina ateva Iesu. ");
INSERT INTO emi_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ghe uela etaira va, “Vaalua me am soghila? Vaalua me nannaaimim eghaaghalua? ");
INSERT INTO emi_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Am tarala nimaghi me kekeghi. Aghi oia! Am posoaghila me am tara; raroai eteva karika righi malatauna me riuna, nongina aghi!” ");
INSERT INTO emi_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nau eteva ghe auliaala voto oia me ghe apasungaala nimane me kekena. ");
INSERT INTO emi_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Laghe masimasieiliila me laghe soghila tani tara Iesu, me karika laghe aaiesoaa va voto laghe tarala koronna, me Iesu ghe kolomilala va, “Righi aneimim inana?” ");
INSERT INTO emi_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Laghe tau lao sio tuku kko arighi laghe tungi esaela tale kura, ");
INSERT INTO emi_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ghe ghaaiela, laghe taatara me ghe namaiela. ");
INSERT INTO emi_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ghe uela etaira va, “Isaa oia voto ngaghe auliaala etaimim nau eteva aghe tokatoka teeiem. Isaa akapa voto laghe piti elokoila elome tale kanna inangari nipaopao Moses, propete atoa me Sams, etani lutu ekoronna.” ");
INSERT INTO emi_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Me ghe otila nannaaira va la tara kila Uru ngai Manga ateva. ");
INSERT INTO emi_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ghe uela etaira va, “Isaa o voto laghe piti elokoila va: Mesaea aue emmarikana me aue emate, me aue emene totu tale nimate tale kotonna ateva nau, ");
INSERT INTO emi_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","me aue la ppooaa ninna ngaioghioghiaa tale ararina ateae, me nikkaluaa tale uunguaa ssavoto, aue erooa ngakapa kosa ateva, etiuaa eJerusalem. ");
INSERT INTO emi_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Am oia am ghe tarala me aue am ppooaa isaa oia voto. ");
INSERT INTO emi_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Aghi aue asungi tau aatu sa ateva Tamaghi ghe aulieiniela tale inangari nialokoi; am toka arau oia tale masaliki taatara ateae lomose ta am ghaa sarasarakana aue ekasu epona liu.” ");
INSERT INTO emi_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Vara me ghe kasueinilala, me laghe lao sio eBetani, ghe atingina saela nimana epona me ghe arangiseilala. ");
INSERT INTO emi_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nau eteva ghe aarangiseila, me ghe kasu vulilala me God ghe ghaaie saela epona liu. ");
INSERT INTO emi_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Me laghe kkaueiniela, me laghe oghi lao sio eJerusalem tee nimasimasi. ");
INSERT INTO emi_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Laghe nim tokala o tale ale manga ateva me laghe tautau sae ararina ateae God. ");
INSERT INTO emi_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Emua arau, nau karika righi voto ghe lutu, Inangari eteva ghe tokatoka. Ghe tokatoka tee God, me ie tee Goto ia. ");
INSERT INTO emi_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Emua arau, ia ghe tokatoka tee God. ");
INSERT INTO emi_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tale ia o Inangari eteva God ghe ghelei ekapala voto. Karika righi voto God ghe gheleila aue ghe lutu arova Inangari eteva karika ia. ");
INSERT INTO emi_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Maulue ateva etokatoka ta ngetana, me maulue ateva, mallangiira ia taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ia o mallanga ateva, elallaa tale saurrom ateva, me saurrom ateva karika erooroo tani ghelei epalaia. ");
INSERT INTO emi_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","God ghe suula taumattu ngateva, ararina ateae ta Jon. ");
INSERT INTO emi_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ghe mae sio tani auliaa mallanga ateva oia ta taumattu ngatoa, poli ghe aloanna va ila akapa la ghaiesoaa inangarina. ");
INSERT INTO emi_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon karika va mallanga ia. Ia ghe nim mae sio tani ppooa ngaotu inangarina mallanga ateva. ");
INSERT INTO emi_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mallanga ateva koronna ia ghe sso mae tale kosa ateva, me emaamallanga tale taumattu ngakapa atoa. ");
INSERT INTO emi_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ia o Inangari eteva ghe tokala oia tale kosa ateva, me arongona ta God ghe gheleila kosa ateva tale ia o Inangari eteva, me karika teva ghe kilakilaia. ");
INSERT INTO emi_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ghe tani mae sio tanganuena, me kapuna atoa karika laghe aikoloainiela. ");
INSERT INTO emi_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Katoa tana taumattu laghe aikoloainiela, me laghe aiesoaala etana, me tale ararina ateae. Liuna avalua o, me ghe tau lao sio niavauvau eteae va ila natuna ila God. ");
INSERT INTO emi_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Karika va natuna ila God tale raeira taumattu ngatoa, me aloannaaira taita atoa me vause atoa, me nannaa taita atoa. Nim ia God ghe gheleilala va natuna ila. ");
INSERT INTO emi_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Inangari eteva ghe taumattula, me ghe toka teeiemamila. Ami ghe tarala naanamunganiaane ateva tale ie nonga o Natuna ateva, Tamana ghe sungiela. Ia pasu ia tale maamasinaane me inangari koronna. ");
INSERT INTO emi_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon ghe aulieiniela nau ghe sama anamungailiila me ghe uela va, “Ia oia taumattu ngateva aghe aaulieinia va aue emae. Ia namuu ia etaghi, me aghi ghauna aghi etana, poli ia ghe tokala arau, me avirina aghe lutula.” ");
INSERT INTO emi_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Poli pasu ia tale maamasinaane, liuna avalua o me ita ghaaghaa asease niarangise. ");
INSERT INTO emi_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Poli God ghe tau lao sio inangari nipaopao ta Moses, me Moses ghe tau mae sio etaita, me Iesu Karisto ghe tau lao sio maamasinaane me inangari koronna. ");
INSERT INTO emi_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Karika poi teva ghe tara God. Natuna nonga, ia koronna ia va Goto ia me kalakalanginaaili ia ta Tamana, ia ghe apasungaala etaita va God vaalue ia. ");
INSERT INTO emi_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","AJiu etoa laghe suula pristi etoa me Livae atoa eJerusalem tani laa kolomi Jon va ia see. ");
INSERT INTO emi_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jon karika ghe aisuliaala etaira, me ghe uela etaira va, “Karika aghi va Mesaea ieghi.” ");
INSERT INTO emi_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Laghe mene kolomiela va, “Io Elaija?” Ghe liula me ghe uela va, “Karika.” Me laghe mene kolomiela va, “Io Propete io?” Ghe mene liula me ghe uela va, “Karika.” ");
INSERT INTO emi_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Vara me laghe uela etana va, “Me uue va io see? Me ami laa ghauliaa ta lo atoa la sungiemamila tani mae kolomi va io see.” ");
INSERT INTO emi_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jon ghe liula tale inangarina propet Aisaea ghe uela va, “Aghi lingi ngalo taumattu ngateva ekolokolo tale voto ateva karika righi taumattu etokatoka etana ghe ue va, ‘Ghelei eghulughuluenala salane atikirighi Vau eteva.’” ");
INSERT INTO emi_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Elome tale lo atoa laghe lao sio tani kolomi Jon, katoa etaira Paresi ila. ");
INSERT INTO emi_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Laghe kolomiela va, “Vaalua me uaasuu taumattu me karika va Mesaea etam, karika va Elaija etam me karika va Propete io?” ");
INSERT INTO emi_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon ghe uela etaira va, “Aghi aghaasuuem tale manu, me kateva elome etaimim karika am kilakilaia. ");
INSERT INTO emi_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Arongo ta aghi aghe muemue mae sio, me karika masi taumattu ngieghi tani pulaka velu oasa tale unna aikasukasu elua, ia aue eaimuli etaghi.” ");
INSERT INTO emi_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Isaa o voto ghe lutula eBetani tale pai kativilau eJodan, nongina Jon ghe aasuu. ");
INSERT INTO emi_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mene kateva nau me Jon ghe tarala Iesu ghe maemae aloi etana me ghe uela va, “Am tarala! Taumattu ngateva oia, natuna sipsipi ia God! Ia aue eghaa velu ssavoto tale kosa ateva. ");
INSERT INTO emi_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ia aghe aulieiniela etaimim, nau aghe ue va, ‘Kateva taumattu aue emae, ia namuu ia ta ngetaghi, poli ghe tokala arau, me avirina aghe lutula.’ ");
INSERT INTO emi_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Karika aghe kilala va ia see, ta anim aasuu taumattu tale manu va aue aIsraeli etoa la taraia.” ");
INSERT INTO emi_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jon ghe aulia ngaotula ta taumattu ngatoa, ghe uela va, “Aghi tee okae, me aghe tarala Spiriti eteva ghe kasula epona liu nonginaaili va ghila ateva valusu ia ghe mae sio toka etana. ");
INSERT INTO emi_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Karika aghe kilala va ia see, ta lo ateva ghe sungieghila tani asuuem tale manu eghe uela etaghi va, ‘Aue utara Spiriti eteva esio toka tale kateva taumattu, me aue ukila va ia o taumattu ngateva aue easuuem tale Spirit Manga ateva.’ ");
INSERT INTO emi_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Aghi aghe tarala isaa o voto ghe lutula. Liuna avalua o me aghaauliaa etaimim va ia Natuna ia God.” ");
INSERT INTO emi_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mene kateva nau Jon me ghalua tana kapuna disaepolo latolu ghe tiitingina aitauaa. ");
INSERT INTO emi_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nau ghe tarala Iesu ghe kasukasu elaolao me ghe uela va, “Am tarala! Ia o natuna sipsipi eteva God!” ");
INSERT INTO emi_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ilalua o disaepolo alua lalu ghe nongola, me lalu ghe lao sio tani aimuli tee Iesu. ");
INSERT INTO emi_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iesu ghe kiriela me ghe tarailaluela, me ghe uela va, “Sa ateva amalu aloannaia?” Lalu ghe liula me laghe uela va, “Rabae, eaa utokatoka?” (Ta inangari nge Hibru, “Rabae” malloeana va “tisa”.) ");
INSERT INTO emi_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Iesu ghe liula me ghe uela va, “Amalu usieghila, me amalu laa tara.” Lalu ghe usiela tani laa tara nongina Iesu ghe tokatoka. Ang ghe 4 kilokola elo alai, me laghe toka teeiela vara me ghe voola. ");
INSERT INTO emi_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andru, nengane ia Saemon Pita, kateva ta ilalua o taumattu ngalua lalu ghe nongola Jon, me lalu ghe usila Iesu. ");
INSERT INTO emi_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Aitiutiu eteva voto Andru ghe gheleiela, ghe kasula tani pae tuena ta Saemon Pita tani auliaa etana va, “Ngami ghe tarala Mesaea ngateva.” (Ta inangari nge Hibru, malloeana “Mesaea” elaolao aitauaa tee samasama nge Grik va “Karisto.”) ");
INSERT INTO emi_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andru ghe laoaa sio tuena ta Iesu. Me nau Iesu ghe taraiela, ghe uela va, “Saemon natuna io Jon. Aue la kolo ararim ateae ta Kepas” (malloeana ta inangari nge Grik va Pita, atu ia). ");
INSERT INTO emi_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Vara ghe pai saela ta mene kateva nau, me Iesu ang ghe anna tani lao eGalilii. Nau ta ghe lao sio, ghe paela me ghe tarala Pilip, me ghe uela etana va, “Mae usieghi.” ");
INSERT INTO emi_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip atala nge Betsaida ia, tanganueirarua Andru me Pita. ");
INSERT INTO emi_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip ghe paela me ghe tarala Nataniel me ghe uela etana va, “Ngami tarala taumattu ngateva Moses ghe pitila me ghe aulieiniela tale inangari nipaopao, me propete atoa laghe piti emuemue alokoila maemaeaane, Iesu ta ngetana, natuna ia Josep aNasareti ia.” ");
INSERT INTO emi_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Me Nataniel ghe kolomiela va, “Righi masi voto elutulutu eNasareti?” Pilip ghe liula me ghe uela va, “Mae sio me ulaa tara.” ");
INSERT INTO emi_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nau Iesu ghe tarala Nataniel ghe kasukasu emaemae etana me ghe uela va, “Tarala! Taumattu ngateva o, ia taumattu koronna ia ta aIsraeli etoa, karika egheelei me eaauliaa voto kamena.” ");
INSERT INTO emi_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel ghe kolomila Iesu va, “Vaalua ughe kilaieghila?” Iesu ghe liula me ghe uela va, “Ngaghe taraiola nau Pilip ghe koloola ta ughe tokatoka tale liue fig ateae.” ");
INSERT INTO emi_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Me Nataniel ghe uela va, “Tisa, io Natuna io God, me io kingi nge Israeli io.” ");
INSERT INTO emi_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iesu ghe liula me ghe uela va, “Uaikaaiaa etaghi poli auela va aghe taraiola ughe tokatoka tale liue fig ateae? Aue utara mene kasina voto namungaili aue elutu. ");
INSERT INTO emi_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aghaaulia ngakoronna etaimim va aue am tara epona liu aue eotia, me kapuna ensolo atoa God aue la siosio me la saesae ta Natuna ateva Taumattu ngateva.” ");
INSERT INTO emi_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ghalua nau ghe lange sio me Meri, kinna Iesu, ghe siola tale nisigha ngateae tale masaliki eteae eKena ta pai nge Galilii. ");
INSERT INTO emi_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Laghe aloanna va Iesu me kapuna disaepolo atoa la usi sio tale nisigha ngateae. ");
INSERT INTO emi_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nau uaeni ghe kapala, kinna ghe lao sio tani auliaa ta Iesu va, “Uaeni ange kapala.” ");
INSERT INTO emi_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iesu ghe liula me ghe uela va, “Vause ateva, urau mene auliaa voto va aghelei, ta naughu karika ghe mae.” ");
INSERT INTO emi_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kinna ghe uela ta tau ngai nongonongo anna atoa va, “Am ghelei saa voto eauliaa etaimim.” ");
INSERT INTO emi_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Elome tale ale ateva, ghaonomo (6) aikaai manu laghe gheleila tale atu ghe tokatoka, uneira aJiu etoa aiporapora nau la ghaloanna tani aimuli tee uneira lo. Kateva aikaai manu erooroo tani kaai koti kateva ai (100) lita. ");
INSERT INTO emi_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesu ghe uela ta tau ngai nongonongo anna atoa va, “Am aku kaai manu esae pasu tale aikaai manu.” Me laghe gheleila voto ghe auliaala. ");
INSERT INTO emi_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Me Iesu ghe mene uela va, “Am akula righi me am laa tau ta lo ateva eaaitoiaa ninamanama ateae.” Tau ngai nongonongo anna atoa laghe gheleila voto Iesu ghe auliaala. ");
INSERT INTO emi_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Taumattu ngateva ghe aaitoiaa ninamanama ateae ghe tootoongala manu ang ghe uaenila. Karika ghe kilala va eaa laghe ghaala; tau ngai nongonongo anna atoa laghe akula manu, ila nonga laghe kilala. Vara me tau ngaitoi ninamanama ateae ghe kolola lo ateva taita ghe laila, ");
INSERT INTO emi_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","me ghe uela etana va, “Ila akapa taumattu ngatoa la ghaaikoita ngakasina masi uaeni, me nau taumattu ngatoa la ropiropi, me nannaaira ange aisavisavilaala, me la vira mene tautau lao llo uaeni karika tani masina. Me io, uarongi etokala masinaaili uaeni, me angu vira mene maeaa sio.” ");
INSERT INTO emi_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ia o niaimatoongana ateva Iesu ghe gheleiela, aitiutiu ia tale isaa akapa niaimatoonga. Ghe gheleiela eKena ta pai nge Galilii. Tale ia o nau eteva Iesu ghe apasungaala sarasarakaniaane, me kapuna disaepolo atoa laghe aiesoaala etana. ");
INSERT INTO emi_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Vara me Iesu ghe kasula eKena me ghe siola eKapenium, ia, kinna, nengane atoa me kapuna disaepolo atoa. Laghe tokala kasina nau tale ia o masaliki eteae. ");
INSERT INTO emi_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nivelu eitauaa ta nau Pasova uneira aJiu etoa ang ghe aakalakalaa, liuna avalua o me Iesu ghe saela eJerusalem. ");
INSERT INTO emi_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ghe tarala taumattu ngatoa elome tale valavala ateae tale ale manga ateva, laghe aitauaa me aipoliaa vulumakao me sipsipi me valusu. Ghe tara teela lo atoa laghe aaikolikoliaa viliki veu. ");
INSERT INTO emi_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Iesu ghe ghaala uasa me ghe gheleila uip ateva, me ghe ameti velu ghoala taumattu ngatoa tale ale manga ateva, tee me kieira ghaata kkena, me ghe sau etakila uneira tevoo atoa lo atoa laghe aikolikoliaa viliki veu, me uneira viliki veu ghe kao reerekataala. ");
INSERT INTO emi_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Me ghe uela ta lo atoa laghe aitauaa ghila valusu va, “Am ghaala valusu me am kasu. Am rau mene ghelei alena ateva Tamaghi va arova maketi ia.” ");
INSERT INTO emi_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Me disaepolo atoa laghe annaala sa ateva Uru ngai Manga ateva ghe aulieiniela, ghe uela va, “Aielousiaaghi tale alem ateva eramerame elome etaghi arova kura ateae.” ");
INSERT INTO emi_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Namuu ta aJiu etoa laghe kolomila Iesu va, “Sa ateva aimatootoongana aue ugheleia tani apasunga etaimami va io ughe ghaala matuutuliena tani ghelei isaa o voto angu gheleila ghaine?” ");
INSERT INTO emi_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iesu ghe liula me ghe uela va, “Am rruti ale manga ateva o, me aue aghatulua ta kotolu nonga nau.” ");
INSERT INTO emi_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Me aJiu etoa laghe uela va, “Ghe roola ghaatingaulu ghaonomo (46) ninamanama laghe gheleila ale manga ateva, me io aue unim gheleia ta kotolu nonga nau?” ");
INSERT INTO emi_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ta ale manga ateva Iesu ghe aaulieinia, vilikina ia. ");
INSERT INTO emi_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Liuna avalua o me nau God ghe totuela tale nimate, kapuna disaepolo atoa laghe nnaala inangarina ghe auliaala, me laghe aiesoaala tale Uru ngai Manga ateva tee me inangari Iesu ghe auliaala. ");
INSERT INTO emi_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nau ghe tokatoka eJerusalem tale nivelu eitaua ngateae ta nau Pasova, oroi taumattu laghe aikaaiaala ta Iesu poli laghe tarala ghe gheleila niaimatoonga. ");
INSERT INTO emi_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Iesu ghe kilakila saa voto elome tale maamauluaaira, liuna avalua o me karika ghe aatoka tuutulina etaira. ");
INSERT INTO emi_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Karika teva ghe rooroo tani auliaa ta ngetana va saa taumattu ila, poli ghe kilakila urunguitaniira. ");
INSERT INTO emi_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kateva taumattu, ararina ateae ta Nikodimas, Paresi ia me namuu ia ta aJiu etoa. ");
INSERT INTO emi_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kateva nau, nau ang ghe aitarrauiila, Nikodimas ghe lao sio tani tara Iesu, me ghe uela va, “Tisa, ami kilakila va God ghe sungiola tani sio apasunga voto etaimami, poli karika teva erooroo tani ghelei niaimatoonga ugheelei, arova God karika etokatoka teeia.” ");
INSERT INTO emi_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Iesu ghe liula me ghe uela va, “Aghaaulia ngakoronna etam va, karika teva erooroo tani kupi sso tale ararimangalina ateva God, arova karika etam lutu ppae.” ");
INSERT INTO emi_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Me Nikodimas ghe kolomila va, “Vaalua aue lo ateva taumattu ang ghe namuula emene lutu? Erooroo tani kupi sso ta kova kinna me emene lutu eghaluene?” ");
INSERT INTO emi_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iesu ghe liula me ghe uela va, “Aghaaulia ngakoronna etam va, arova uanna tani sso tale ararimangalina ateva God, utani lutu tale manu me Spiriti eteva. ");
INSERT INTO emi_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","See elutulutu tale taumattu, taumattu ia, me see elutulutu tale Spiriti eteva, spiriti ia. ");
INSERT INTO emi_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Urau mene soghiaa inangarighi nau aue va, ‘Am tani lutu ppae.’ ");
INSERT INTO emi_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kuukuu eteva ekuukuu ekapa see tale voto ealoanna tani lao etana. Arongona ta urooroo tani nongoa, me karika ukilakila va eaa ekasukasu me eaa elaolao. See elutu tale Spiriti eteva, ia nongina kuukuu eteva, karika teva erooroo tani tara kilaia.” ");
INSERT INTO emi_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Me Nikodimas ghe kolomila Iesu va, “Vaalua isaa o voto aue elutu?” ");
INSERT INTO emi_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iesu ghe liula me ghe uela va, “Vaalua me io tau ngai aapasunga io ta aIsraeli atoa, me karika ukilakila isaa o voto? ");
INSERT INTO emi_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Aghaaulia ngakoronna etam va ami, ami kilakila sa ateva ami aaulieinia poli ngami ghe tarala. Karika teva etaimim aue ealoanna voto ami aauliaa. ");
INSERT INTO emi_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Arova am tam aiesoaa nau aghaauliaa etaimim voto oia tale kosa ateva, vaalua aue am ghele aiesoaa nau aghele auliaa voto epona liu? ");
INSERT INTO emi_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Karika teva ghe sae epona liu. Natuna ateva Taumattu ngateva nonga ghe kasula epona liu, me ghe sio mae tale kosa ateva. ");
INSERT INTO emi_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nongina Moses ghe avukala saela katu ngateva tale voto ateva karika righi taumattu etokatoka etana, Natuna ateva Taumattu ngateva aue esae vukala, ");
INSERT INTO emi_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tani tau lao maulue ateva etoka nau ekapa atoa ta lo atoa aue la ghaikaaiaa ta Natuna ateva Taumattu ngateva.” ");
INSERT INTO emi_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Poli God ghe aaielousiangaili taumattu tale kosa ateva oia, liuna avalua o me ghe tau mae sio Natuna ateva, kateva nonga ia, me see aue eaikaaiaa etana karika aue emate, ta aue eghaa maulue ateva etokatoka nau ekapa atoa. ");
INSERT INTO emi_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Karika va God ghe suula Natuna tani sio tale kosa ateva oia tani ghelei niaisakei ta taumattu tale kosa ateva. Ghe sungiela tani sio asaangi taumattu. ");
INSERT INTO emi_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Lo ateva eaikaaiaa ta ngetana, karika aue eghaa sesa aipolipoli tale niaisakei, me lo ateva etam aikaaiaa ta ngetana aue evira ghaa sesa aipolipoli tale niaisakei, ta poli karika eaikaaiaa tale ararina ateae Natuna ateva God. ");
INSERT INTO emi_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Niaisakei eteae ia avalua toko: Mallanga ateva ghe mae sio tale kosa ateva, me taumattu ngatoa la ghaloanna saurrom, me karika la ghaloanna mallanga, poli gheeleiaaira sesa. ");
INSERT INTO emi_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Lo atoa taumattu la gheelei voto sesa la tam maamasiaa mallanga ateva, me karika la ghaloanna tani mae etana, poli mallanga ateva eaapasunga voto la gheelei. ");
INSERT INTO emi_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Me lo atoa la tokatoka tale voto koronna, aue la lao tale mallanga ateva, poli la ghaaloanna va mene katoa taumattu la kila va voto la gheelei God egheelei taula. ");
INSERT INTO emi_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Vara me Iesu me kapuna disaepolo atoa laghe siola eJiudia, ghe toka teeilala, me ghe aasuu taumattu. ");
INSERT INTO emi_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon tee ghe aasuu taumattu tale voto ateva la kolokolo Aenon ta ngetana, kalakalaa tale masaliki eteae eSalim, poli ia o voto ateva manu ia. Me oroi taumattu ghe mae sio ta Jon, me Jon ghe asuulala. ");
INSERT INTO emi_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Isaa o nau Herot karika ghe atoka sso Jon tale ale mata voovoo.) ");
INSERT INTO emi_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Vara me kapuna disaepolo atoa Jon me kateva tana aJiu laghe tiuaala tani aissakeana tee saa tikirighi salana nisuu me niporapora la usilaa nau la ghaloanna tani aimuli tee uneira lo. ");
INSERT INTO emi_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kapuna disaepolo atoa Jon laghe lao sio ta Jon me laghe uela etana va, “Tisa, taumattu ngateva ghe toka teeiola ta pai kativilau tale ateo ateae eJodan me ughe aauliaa kiukiuna, ia oia ange aasuu taumattu, me ila akapa ngeila laolao ta ngetana.” ");
INSERT INTO emi_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon ghe liula me ghe uela va, “Karika teva taumattu erooroo tani ghaa righi voto, arova God epona liu etam anna va eghaa. ");
INSERT INTO emi_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Am ghe nongoaghila nau aghe ue etaimim va, ‘Karika va aghi Mesaea ieghi. Aghi God ghe sungieghila tani muemueainia.’ ");
INSERT INTO emi_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nau taita ateva elailai vause ateva, lalu lai me ia aue vausenna ia. Me lo ateva taita euiiuitnesi, ie tee emasimasi nau enongonongo kapuna ateva elailai, nongina aghi nimasimasi eteva elome etaghi namungaili ia. ");
INSERT INTO emi_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Emaamasina va ararina ateae esae epona, me ararighi eteae esio euu.” ");
INSERT INTO emi_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Lo ateva ghe kasula epona liu me ghe sio mae, ia epona, me elaulau isaa akapa voto. Taumattuna kosa ateva oia egheelei gheeleiaa kosa ateva, me eaauliaa voto tale kosa ateva. Me lo ateva ghe kasula epona liu, ia epona tale taumattu ngakapa atoa. ");
INSERT INTO emi_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Eaauliaa poi voto ghe tarala me ghe nongola, me karika teva eaaiesoaa inangarina. ");
INSERT INTO emi_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Me lo ateva eaiesoaa inangarina eaapasunga va God koronna ia. ");
INSERT INTO emi_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Poli lo ateva God ghe sungiela eaauliaa inangarina God, me God ghe tau lao sio Spiriti eteva etana, karika erooroo tani kapa. ");
INSERT INTO emi_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tamane eaailousiaa Natuna, liuna avalua o me ghe taula isaa akapa voto ta ngetana. ");
INSERT INTO emi_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Lo ateva eaikaaiaa ta Natuna, maulue ateva aue etoka liu etana. Lo ateva etam nongo usilainia, karika aue eghaa lo ateva o maulue, me God sessaiaane etana aue etoka nau ekapa atoa. ");
INSERT INTO emi_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Iesu ghe kilala va Paresi etoa ngeila ghe nongola va ia ang ghe ghaaghaa oroi taumattu tani asuu, me Jon karika. ");
INSERT INTO emi_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Me karika va Iesu ghe aasuu, ta kapuna disaepolo atoa. ");
INSERT INTO emi_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Iesu ghe kasu vulila eJiudia, me ang ghe mene laa saesae eGalilii. ");
INSERT INTO emi_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","God ghe aloanna va eusilaa salana atikirighi esosso elome eSameria. ");
INSERT INTO emi_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ghe kasukasu elaolao me ghe rekatala tale masaliki eteae la kolokoloa va Sika eSameria, kalakalangina ia tale tuku kosa ateva Jekop ghe taue lao sio ta natuna ta Josep emua arau. ");
INSERT INTO emi_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ateo kaikai eteae Jekop ghe kaiela ghe asoaso tale masaliki eteae Iesu ghe kasukasu elaolao etana. Vara me ang ghe maamangoo poli ghe kasula tale aluse salana, me ghe toka siola kalakalangina tale ateo kaikai eteae. Ang ghe pai ngelo sinakala. ");
INSERT INTO emi_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Kateva vauseni nge Sameria ghe mae sio tani aku, me Iesu ghe uela etana va, “Aku tau mae sio righi manu, me aropi.” ");
INSERT INTO emi_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Kapuna disaepolo atoa laghe ssola elo masaliki tani poli inana.) ");
INSERT INTO emi_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Vauseni nge Sameria ngateva ghe uela etana va, “Io aJiu io me aghi vauseni nge Sameria ngaghi. Vaalua me ulooloo manu etaghi?” (Ghe auliaala llo poli aJiu etoa me aSameria ngatoa karika laghe samasama aitauaa.) ");
INSERT INTO emi_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iesu ghe liula me ghe uela va, “Arova ughele kila masi voto God eanna tani tau aatu, me ughele kila tee lo ateva ekookolomio tani ropi, aue ughele kolomia tale llo ateo etautau mae maulue.” ");
INSERT INTO emi_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Me vause ateva ghe uela va, “Namu ngateva, karika teva unem aiakueku, me ateo ateae sio liuna ia, me eaa aue ulaa ghaaia lo ateae ateo etau mae maulue? ");
INSERT INTO emi_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tuvuimami eteva ta Jekop ghe kaiela ateoimami eteae oia, me natuna atoa me kieira ghaata kkena atoa laghe ropiropi etana. Koti io namuu io ta Jekop, va?” ");
INSERT INTO emi_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iesu ghe liula me ghe uela va, “Lo atoa aue la ropi tale ia oia ateo kaikai eteae, aue la mene aloanna tani ropi. ");
INSERT INTO emi_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Me lo ateva eropi tale ateo ateae aghi aue atauela, karika aue emene kangngata tani ropi. Lo ateae ateo aue atauela aue etoka etana nonginaaili lo ateae ateo enim toka akaakalaa me karika ematimati, me aue etaula maulue ateva karika ekapakapa.” ");
INSERT INTO emi_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Me vause ateva ghe uela ta Iesu va, “Namu ngateva, utau mae ia o ateo ateae, me auena arau mene aloanna tani ropi va amene mae aku oia.” ");
INSERT INTO emi_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Me Iesu ghe uela etana va, “Lao sio me ulaa kolo taitanim ateva, me amalu mae.” ");
INSERT INTO emi_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Me vause ateva ghe uela va, “Karika teva taitanighi.” Me Iesu ghe uela va, “Uaulia ngakoronna va karika teva taitanim. ");
INSERT INTO emi_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Poli angu ghe ghaa muela ghalima taita, me lo ateva taita utokatoka teeia karika va taitanim ia. Liuna avalua o me inangarim uauliaa koronnaaili.” ");
INSERT INTO emi_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Me vause ateva ghe uela va, “Namu ngateva, ngakilala va io propete io. ");
INSERT INTO emi_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tuvuimami etoa la kakkaua tale ia o motouru eteva, me am aJiu etoa, am ue va masaliki nikkaua ngateae eJerusalem.” ");
INSERT INTO emi_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iesu ghe uela etana va, “Uaiesoaa inangarighi va aue kateva nau ta isaa to nau emaemae karika aue am kkaua Tamaita ateva tale ia o motouru eteva me eJerusalem. ");
INSERT INTO emi_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Am aSameria ngatoa, karika am kilakila see am kaakaueinia. Ami aJiu etoa, ami kilakila God ateva ami kaakaueinia, poli ta aJiu etoa aue niasaangi emae. ");
INSERT INTO emi_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Me nau ie emaemae me ange rekatala va Spiriti eteva kanna ia God aue eghelei taumattu la rooroo tani kkaua God tale koronna. Tamaita ateva ealoanna va isaa o ase taumattu la kaueinia. ");
INSERT INTO emi_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God spiriti ia, me lo atoa la kaakaueinia, Spirit Manga ateva ekaakatulainila tani kkaua tale voto koronna.” ");
INSERT INTO emi_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Me vause ateva ghe uela va, “Akilakila va Mesaea ngateva aue emae (la kolokoloa va Karisto etana). Nau emae aue eaulia ngamasinaaili ekapa voto etaimami.” ");
INSERT INTO emi_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Me Iesu ghe uela etana va, “Aghi oia asamasama, aghi oia taumattu ngateva uaaulieinia.” ");
INSERT INTO emi_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Isaa o nau me kapuna disaepolo atoa ngila ghe kiriaala, me laghe soghiaala tani tara Iesu ghe samasama tee vause ateva. Me karika teva ghe kookolomia va, “Sa ateva ualoannaia?” me, “Vaalua me usamasama teeia?” ");
INSERT INTO emi_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Vause ateva ghe velu etokala ateona aikaai manu eteva, me ghe ilou ssola tale masaliki eteae, me ghe uela ta taumattu ngatoa va, ");
INSERT INTO emi_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Am mae sio, me am laa tara taumattu ngateva, eaulia ngakapala voto agheelei. Koti ia Mesaea ia?” ");
INSERT INTO emi_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Taumattu ngatoa tale masaliki eteae laghe lao sio tani taraia. ");
INSERT INTO emi_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nau isaa o voto ghe lutulutu, me kapuna disaepolo atoa Iesu laghe ue etana va, “Tisa, namanamala mua.” ");
INSERT INTO emi_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Iesu ghe liula me ghe uela etaira va, “Aneghi tani inana karika am kilakila.” ");
INSERT INTO emi_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Disaepolo atoa laghe tiuaala tani aikolomieinila va, “Teva taumattu emae sio tani anginia?” ");
INSERT INTO emi_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Iesu ghe uela etaira va, “Inana anamanama nau agheelei uunguaane lo ateva ghe sungieghila, me tani ruu isaa o niuungu ghe uela va aghelei. ");
INSERT INTO emi_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Am roo tani ue va, ‘Kasi ghaata ulana me ita laa ghaa inana tale utana atingiu.’ Aghaauliaa etaimim va am taatara sso, me am tara utana atingiu ang ghele matuela, me ang ghele roola tani ghaa inanina. ");
INSERT INTO emi_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Lo ateva taumattu euungu tani ghaa inana tapaa ngutana eghaaghaa arau aipolina, me eghaaghaa aitauaa inana aue etoka nau ekapa atoa. Liuna avalua o me lo ateva epasapasa inana me lo ateva eghaaghaa, ilalua akapa lalu masimasi. ");
INSERT INTO emi_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Koronnaaili ia tuku inangari eteva eue va, ‘Kateva epasapasa, me mene kateva emukemuke.’ ");
INSERT INTO emi_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ngasungisungiem tani laa ghaa inana tale utana atingiu, katoa ppae ghe matela uunguaaira etana, me am, am ghe nim ssola tani ghelei eruu uunguaaira.” ");
INSERT INTO emi_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Oroi taumattu nge Sameria tale ia o masaliki erighi laghe aikaaiaala ta Iesu poli vause ateva ghe uela va, “Ia oia taumattu ngateva eaulia ngakapala voto agheelei.” ");
INSERT INTO emi_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Laghe lao sio tani kolomi esarasarakana Iesu va emene toka teeila mua. Liuna avalua o me Iesu ghe mene toka teeilala ghalua nau. ");
INSERT INTO emi_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ghe mene oroi ila taumattu nge Sameria ghe aikaaiaala ta Iesu poli inangarina laghe nongola. ");
INSERT INTO emi_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Me laghe ue ta vause ateva va, “Karika va ami aikaaiaa ta Iesu poli isaa o inangari uauliaala etaimami. Ami tee ngami nongoala, me ngami kila akoronnala va ia aue easaangi taumattu ngatoa tale kosa ateva.” ");
INSERT INTO emi_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iesu ghe toka teela aSameria ngatoa ghalua nau, me ghe kasu vulilala tani mene sae eGalilii. ");
INSERT INTO emi_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Iesu ghe auliaala va, propete ateva, la oneoneainia tale kasina ppae masaliki, me tanganuena karika. ");
INSERT INTO emi_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Liuna avalua o, nau ghe saela eGalilii, laghe masimasila va etoka teeila, poli ila tee laghe saela tale nivelu eitaua ngateae eJerusalem, me laghe tarala voto Iesu ghe gheleila. ");
INSERT INTO emi_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nau ia eGalilii, Iesu ghe mene lao sio eKena, masaliki eteae ghe gheleila manu ghe uaenila. EKapenium, kateva namuu, kapuna tau ngai uungu ia kingi, natuna taita arighi ghe iisiki. ");
INSERT INTO emi_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nau eteva ghe nongola va Iesu ang ghe kasula eJiudia me ang ghe rekatala eGalilii, ghe lao sio tani tara Iesu, me tani koloa va esio ghelei emasina natuna, poli ang ghe ainasiaa tani mate. ");
INSERT INTO emi_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iesu ghe uela etana va, “Karika am rooroo tani aikaaiaa, arova am tam tara niaimatoonga me mirikolo atoa.” ");
INSERT INTO emi_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Me taumattu ngateva ghe uela va, “Namu ngateva, italu sio tara parasi natughu, me erau mate.” ");
INSERT INTO emi_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Me Iesu ghe uela etana va, “Natum aue etoka. Kasula, me ulaa taraia.” Namu ngateva ghe aiesoaala inangarina Iesu, me ghe kasula. ");
INSERT INTO emi_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Karika ghe rekata eKapenium, me kapuna tau ngai uungu etoa laghe sousouela tapaa salana tani auliaa etana va natuna ang ghe masinala. ");
INSERT INTO emi_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Me ghe kolomilala va lovisa ghe masinala, me laghe uela va, “Ghalailloo ta 1 kilok aanasa ateva ghele kapala.” ");
INSERT INTO emi_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Me tamane ghe kilala va ia o nau eteva ghalailloo Iesu ghele uela va, “Natum aue etoka.” Taumattu ngateva me lo atoa elome tale paa ngalena ateva, laghe aiesoaala ta Iesu. ");
INSERT INTO emi_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Aiaaghaluene ateva o niaimatoongana Iesu ghe gheleiela nau ghe kasula eJiudia me ghe saela eGalilii. ");
INSERT INTO emi_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kasina nau ang ghe lao sio me Iesu ghe saela eJerusalem tale mene kateva uneira nivelu eitauaa aJiu etoa. ");
INSERT INTO emi_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","EJerusalem kateae atamana laghe aseasea va Atamani Sipsipi ia. Kalakalaa tale atamana ateae, ateo talia ngateae taumattu ngatoa laghe kaiela ghe asoaso, ghalima varandaane, me ta samasamaaira aHibru etoa laghe aseasea va Betesda. ");
INSERT INTO emi_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Oroi tau sessa ghe asoaso akalakalaa tale ia o ateo talia ngateae, katoa mata salusalu ila me katoa tangorengore ila me katoa vilikiira matena. ");
INSERT INTO emi_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kateva taumattu ghe tangorengorela kotolungaulu ghaoaluae (38) ninamanama, ie tee ghe asoaso akalakalaa tale ateo talia ngateae. ");
INSERT INTO emi_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iesu ghe tarala ia o taumattu ngateva ghe asoaso, ghe kilala va ang ghe tangorengorela oroi ninamanama, me ghe uela etana va, “Ualoanna tani masina?” ");
INSERT INTO emi_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tangorengorena ateva ghe liula me ghe uela ta Iesu va, “Namu ngateva, karika teva tani saueghi, me elaa sau velueghi sio tale ateo talia ngateae nau eaisiisia. Vara atootoonga, me karika arooroo, ta mene katoa ppae taumattu la siosio akasina.” ");
INSERT INTO emi_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Iesu ghe uela etana va, “Tingina saela, usau komom, me ukasu.” ");
INSERT INTO emi_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Gharavaeaata ta taumattu ngateva ghe masinala, ghe saula komona, me ghe tiuaala tani kasu. Isaa o voto ghe lutula tale nau manga ateva. ");
INSERT INTO emi_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Liuna avalua o me nau aJiu etoa laghe tarala ia o taumattu ngateva ghe masinala, me laghe uela etana va, “Ghaine nau manga ateva. Karika masina tani sau komom etana.” ");
INSERT INTO emi_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ghe liula me ghe uela va, “Lo ateva taumattu eghelei emasinaieghila, euela va asau komoghu me akasu.” ");
INSERT INTO emi_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Me laghe kolomiela va, “See ia taumattu ngateva euela etam va usau komom me ukasu?” ");
INSERT INTO emi_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Taumattu ngateva ghe masinala karika ghe kilala va see ghe ghelei emasinaiela, poli oroiannaaili taumattu, me Iesu ang ghe aisavisavilainiela elome tale taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Emulina Iesu ghe ssola tale ale manga ateva, me ghe paela me ghe tarala taumattu ngateva. Me ghe uela etana va, “Tarala, angughe masinala. Isaa oio nau urau nim ghelei ssavoto va llo sesaaili emene lutu ta ngetam.” ");
INSERT INTO emi_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ghe lao sio me ghe laa ghauliaa sio ta aJiu etoa va Iesu ghe ghelei emasinaiela. ");
INSERT INTO emi_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Liuna avalua o me aJiu etoa laghe tiuaala tani ghelei voto sesaaili ta Iesu, poli ghe gheelei isaa o voto tale nau manga ateva. ");
INSERT INTO emi_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Iesu ghe uela va, “Tamaghi euungu me karika ghe ruu, me aghi tee auungu.” ");
INSERT INTO emi_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","AJiu etoa laghe aloannaaili tani uvi emate Iesu, poli karika va ghe gheelei laelaeaa nonga nau manga ateva, me poli ghe ue tee va Tamane ta God, ghe gheeleia va lalu ghe aairooaa me God. ");
INSERT INTO emi_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iesu ghe uela ta aJiu etoa va, “Aghaaulia ngakoronna etaimim va Natuna ateva God karika erooroo tani ghelei voto ta nannaane, ta egheelei nonga voto etaatara ta Tamane egheelei. Isaa akapa voto Tamane egheelei, Natuna tee ateva egheelei. ");
INSERT INTO emi_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tamana eaaielousiaa Natuna, liuna avalua o me isaa akapa voto egheelei, eaapasunga etana. Me ealoanna va am soghiaa, liuna avalua o me aue emene apasunga taula mene kasina paka voto. ");
INSERT INTO emi_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nongina Tamane etottotu taumattu matena, me etautau lao maulue etaira, Natuna tee etautau lao maulue ta taumattu tale aloaloannaane. ");
INSERT INTO emi_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tamane karika egheelei niaisakei ta teva taumattu. Ghe taula ta Natuna va ie nonga eghelei niaisakei tale isaa akapa taumattu. ");
INSERT INTO emi_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Liuna avalua o me taumattu ngakapa atoa aue la tau sae ararina ateae Natuna ateva God, nongina la tautau sae ararina ateae Tamane. Lo ateva etam tautau sae ararina ateae Natuna, karika etautau sae ararina ateae Tamane, ia ghe sungiela. ");
INSERT INTO emi_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Aghaaulia ngakoronna etaimim va lo ateva enongo inangarighi, me eaikaaiaa ta lo ateva ghe sungieghila va asio, maamauluaane aue etoka amasina nau ekapa atoa, me karika aue eghaa sesa aipolipoli tale niaisakei, poli ang ghe kasu vulila nimate, me ang ghe tokala tale maulue. ");
INSERT INTO emi_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Aghaaulia ngakoronna etaimim va aue kateva nau, me nau eteva oia ange rekatala, lo atoa taumattu laghe matela, aue la nongo lingi ngalona ateva Natuna ateva God, me lo atoa taumattu la nongoa, aue la ghaa maulue. ");
INSERT INTO emi_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Maulue ateva etokatoka ta Tamane, me ghe tauela ta Natuna, me maulue ateva etokatoka tee ta Natuna. ");
INSERT INTO emi_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tamane ghe avauvauela me ghe tau lao sio niuungu tani ghelei niaisakei tale taumattu, poli Natuna ia Taumattu ngateva. ");
INSERT INTO emi_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Am rau mene nnangaili inangari oio aghaauliaa, poli aue nau to emaemae lo atoa taumattu la asoaso tale liu, aue la nongo lingi ngalona ateva Natuna ateva Taumattu ngateva, ");
INSERT INTO emi_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","me aue la totu tale liu. Lo atoa laghe gheelei masi voto, aue la totu me la ghaa maulue, me lo atoa laghe gheelei sesa voto, aue la totu me la ghaa sesa aipolipoli. ");
INSERT INTO emi_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Karika arooroo tani ghelei voto tale aloaloannaaghi. Aghaaimuli tee inangarina lo ateva ghe sungieghila. Me ia eaauliaa tau mae vaalua aghelei niaisakei. Niaisakei agheelei ghulughuluena, poli karika aghaimuli tee nannaaghi.” ");
INSERT INTO emi_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Iesu ghe mene uela va, “Arova aghi nonga aghaaulia ngaotu uunguaaghi me gheeleiaaghi, taumattu ngatoa la rau mene aiesoaa inangarighi aghaauliaa. ");
INSERT INTO emi_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mene kateva tee eaaulia ngaotu uunguaaghi me gheeleiaaghi, me akilakila va inangarina koronna. ");
INSERT INTO emi_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Am ghe suula taumattu tani laa kolomi Jon, me Jon ghe auliaala voto koronna etaira. ");
INSERT INTO emi_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Aghi karika atuutuli inangariira taumattu ngatoa, mausina me aghaauliaa inangari oia poli aghaaloanna va am saanga. ");
INSERT INTO emi_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon nongina lama ateae eramerame me emaamallanga, me am ghe masimasi tani ghaa isaa o mallanga, vara karika masau me ngam ghe maamangoo. ");
INSERT INTO emi_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Isaa o voto Jon ghe auliaala eaaimatoonga mae etaghi, me karika erooroo tale voto isaa oia nau agheelei. Isaa akapa o niuungu, Tamaghi ghe tau mae sio va aghelei me aruu. Isaa o niuungu agheelei eaaulia ngaotu ta taumattu ngatoa va Tamaghi ghe sungieghila tani sio oia. ");
INSERT INTO emi_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tamaghi, ia o ghe sungieghila tani sio, ie tee eaaulia ngaotueghi. Am karika am ghe nongo poi lingi ngalona ateva, me karika am ghe tara taataraane, ");
INSERT INTO emi_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","me inangarina tee karika elome tale maamauluaaimim, poli karika am aiesoaa tale taumattu ngateva ghe sungiela, me ghe sio mae oia. ");
INSERT INTO emi_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tale nannaaimim am annaa va inangari tale Uru ngai Manga ateva aue etau aatu maulue tokatoka liu ia, liuna avalua o me am paepae me am ritiritia. Me Uru ngai Manga ateva eaaulieinaghi, ");
INSERT INTO emi_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","me karika am aloanna tani mae etaghi va am ghaa maulue. ");
INSERT INTO emi_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Karika aghanna va taumattu ngatoa la arueinaghi. ");
INSERT INTO emi_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Akilakilaiem va aielousiaane ateva God karika ia etaimim. ");
INSERT INTO emi_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Aghe sio mae ta ararina ateae Tamaghi, me karika am anna inangarighi, me arova teva ghele mae tale aloaloannaane, arovaeaata ta aue am ghele anna tani nongo inangarina. ");
INSERT INTO emi_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Vaalua aue am aikaaiaa? Poli am anna nonga va kapuimim atoa la arueinam, me karika am anna niaruaa God nonga erooroo tani tau aatu. ");
INSERT INTO emi_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Karika am mene nnaa va aghi aue aghauliaa gheeleiaaimim sesa ta Tamaghi. Ia o Moses am annaa va aue esausiem, ia aue eauliaa sesa gheeleiaaimim. ");
INSERT INTO emi_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Arova am ghele aiesoaa tale inangarina Moses, aue am ghele aiesoaa tee tale inangarighi, poli inangari ghe pitila eaaulieinaghi. ");
INSERT INTO emi_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Arova karika am aiesoaa tale inangari ghe pitila, vaalua aue am aiesoaa inangarighi?” ");
INSERT INTO emi_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Vara me Iesu ghe mene lao sio ta pai kativilau tale ateo talia ngateae eGalilii, mene kateae ararina ta Taiberias. ");
INSERT INTO emi_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Oroiannaaili taumattu laghe usiela, poli laghe taraiela ghe gheleila niaimatoonga tani ghelei emasina tau sessa atoa. ");
INSERT INTO emi_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Iesu ghe saela tale motouru tani toka tee kapuna disaepolo atoa. ");
INSERT INTO emi_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pasova ngateva, nivelu eitauaa ia ta aJiu etoa, ang ghe aakalakalaa. ");
INSERT INTO emi_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nau Iesu ghe atangarola me ghe tarala taumattu ngatoa laghe maemae etana, me ghe uela ta Pilip va, “Eaa ita laa ghaa verete me ita angini isaa oia taumattu?” ");
INSERT INTO emi_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ghe auliaala isaa o voto tani tootoonga unna niaikaaiaa Pilip, me Iesu ang ghe kila vella sa ateva aue egheleia. ");
INSERT INTO emi_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilip ghe uela va, “Arova ita ghele poli verete ta ghalua ai (200) silva koen, karika aue ghele roo. Marova ita ghele taula tuku gharighi ta kateva kateva taumattu, karika aue ghele roo akapa etaira.” ");
INSERT INTO emi_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Kateva kapuna disaepolo, Andru etana, tue me nenga ilalua me Saemon Pita, ghe uela ta Iesu va, ");
INSERT INTO emi_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kateva aliki oia anna bali verete ghalima me anna kko ghalua. Me karika aue eroo tani sausi tani angini ekapa taumattu oia oroiannaaili.” ");
INSERT INTO emi_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iesu ghe uela ta kapuna disaepolo atoa va la ghauliaa ta taumattu ngatoa me la toka sio. Oroiannaaili rarrasa etana ia o voto ateva, me oroi tee taita atoa, ghe rooroo ghalima airari (5,000). ");
INSERT INTO emi_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nau laghe toka siola, Iesu ghe ghaala verete, me ghe kaili emasina saela ta God, me ghe taula ta kapuna disaepolo atoa va la laa ghaikoita. Ghe ghelei evalue teela o tale kko. Me ila akapa laghe roola tale inana. ");
INSERT INTO emi_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nau ghe ssoilala tani namanama, Iesu ghe uela ta kapuna disaepolo atoa va la kaai eitauaa tapiri nginana, me erau nim vulla nonga. ");
INSERT INTO emi_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Disaepolo atoa laghe ghaa aisokosokoiaala tapiri nginana laghe nama vulla tale verete ghalima, me laghe kaaila kasangaulu ghaluae (12) laka isaa o inana ghe oghila ta ghe ssoilala. ");
INSERT INTO emi_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Taumattu ngatoa laghe tarala isaa o niaimatoonga Iesu ghe gheleila, me laghe ue va, “Koronna, ia propete ateva laghe uela va aue emae tale kosa ateva oia.” ");
INSERT INTO emi_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iesu ghe kilala va laghe anna tani gheleia va ghe kapuira kingi ia, me karika aloannaane Iesu. Liuna avalua o me ghe kasu vulilala, me ie nonga ghe saela tale motouru. ");
INSERT INTO emi_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pai ngelo alai, kapuna disaepolo atoa Iesu laghe siola elamana tale ateo talia ngateae. ");
INSERT INTO emi_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Laghe aikaaila tale paanaka ateva, me laghe tiuaala tani ose tani lao eKapenium. Ang ghe aaitarrauii me Iesu ghe tam laa rekata etaira. ");
INSERT INTO emi_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kuukuu eteva ghe tiuaala, me ttasi eteva ghe lutula tale paamanu eteva. ");
INSERT INTO emi_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nau ta disaepolo atoa laghe osela ghe roola 5-6 kilomita me laghe tarala Iesu ghe kasukasu epona tale paamanu eteva. Ghe kasukasu emaemae etaira me ngeila ghe maamatautu etingina. ");
INSERT INTO emi_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Me Iesu ghe uela etaira va, “Aghi oia. Am rau mene matautu.” ");
INSERT INTO emi_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Me disaepolo atoa laghe vira mene masimasila tani kaaia, me arovaeaata ta paanaka ateva ghe ssola elae nongina eaa laghe aloanna tani lao. ");
INSERT INTO emi_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Vara ghe paila ta mene kateva nau, me taumattu ngatoa elamana ta pai nge sinaka sae tale ateo talia ngateae laghe kilala va ghalailloo kateva nonga paanaka ghele vuuvukala, me nau disaepolo atoa laghe aikaaila, Iesu ghe tam aikaai teeilala. ");
INSERT INTO emi_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mene katoa tani paanaka nge Taiberias laghe mae sio nongina Vau eteva ghe kaili emasinala tale verete me laghe namala. ");
INSERT INTO emi_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Taumattu ngatoa laghe tarala va Iesu me kapuna disaepolo atoa karika ila, liuna avalua o me laghe aikaaila tale isaa o paanaka me laghe lao sio eKapenium tani pae Iesu. ");
INSERT INTO emi_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Laghe laa rekata sio tale pai kativilau tale ateo talia ngateae, me laghe tarala Iesu, me laghe kolomiela va, “Tisa, lovisaa umae sio oia?” ");
INSERT INTO emi_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iesu ghe liula me ghe uela etaira va, “Aghaaulia ngakoronna etaimim va karika am paepaeaghi poli am taatara niaimatoonga agheelei, ta nim mausi inana am namanama me esossoiem. Liuna avalua o me am paepaeaghi. ");
INSERT INTO emi_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Am rau mene uungu tani ghaa llo inana esesa. Am uungu tani ghaa lo ateva inana etautau aatu maulue etokatoka liu, Natuna ateva Taumattu ngateva aue etau aatu ia o inana ateva, poli Tamane ta God ghe anamunamungainiela tani ghelei isaa o voto.” ");
INSERT INTO emi_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Vara me laghe uela etana va, “Saa righi voto ami ghelei, me aue ami roo tani ghelei niuungu God ealoanna?” ");
INSERT INTO emi_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Me Iesu ghe liula me ghe uela etaira va, “Kateva nonga niuungu God ealoannaia, va am aikaaiaa tale taumattu ngateva God ghe sungiela tani mae.” ");
INSERT INTO emi_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Liuna avalua o me laghe mene uela va, “Sa ateva niaimatoonga aue ughelei me aue ami tara, me ami aikaaiaa ta ngetam? Me saa niuungu aue ugheelei? ");
INSERT INTO emi_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nongina tuvuimami etoa, nau ila tale voto ateva karika righi taumattu etokatoka etana, laghe namanama mena, nongina Uru ngai Manga ateva eue va, ‘Moses ghe tau lao sio inana ngepona liu eteva va la namaia.’” ");
INSERT INTO emi_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Liuna avalua o me Iesu ghe uela etaira va, “Aghaaulia ngakoronna etaimim va karika va Moses ghe tau aatu sio isaa o verete ngepona liu. Tamaghi nonga etautau aatu lo ateva verete ngepona liu koronna ia. ");
INSERT INTO emi_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Lo ateva verete God etautauela, ia o taumattu ngateva ghe kasula epona liu tani tau lao maulue tale taumattu tale kosa ateva.” ");
INSERT INTO emi_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Me laghe uela etana va, “Namu ngateva, utau mae ia o verete ateva tale nau ekapa atoa.” ");
INSERT INTO emi_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Iesu ghe liula me ghe uela va, “Aghi ia o verete ateva etautaula maulue. Lo ateva emae etaghi, karika aue emaloo, me lo ateva eaikaaiaa etaghi, karika aue eanna tani mene ropi. ");
INSERT INTO emi_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ngaghe auliaala etaimim me ngam ghe taraieghila, me karika am aikaaiaa etaghi. ");
INSERT INTO emi_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Isaa akapa taumattu Tamaghi etautau mae etaghi, aue la mae etaghi, me karika poi arooroo tani sungi velu teva. ");
INSERT INTO emi_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Karika aghe kasula epona liu tani sio ghelei nannaaghi. Aghe sio mae tani ghelei nannaane lo ateva ghe sungieghila. ");
INSERT INTO emi_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nannaane lo ateva ghe sungieghila va karika teva ta lo atoa ghe taula mae sio etaghi emene raua. Eanna va atotula, me la ghaa maulue nau airuuruu tale kosa ateva. ");
INSERT INTO emi_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Aloannaane Tamaghi va ila akapa lo atoa la tara Natuna me la ghaikaaiaa etana, la ghaa maulue ateva etokatoka nau ekapa atoa me aghi aue atotula me la ghaa maulue tale airuuruu tale kosa ateva.” ");
INSERT INTO emi_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Vara me aJiu etoa laghe tiuaala tani olueinia tale inangari, poli Iesu ghe uela va, “Aghi verete ateva ghe kasula epona liu.” ");
INSERT INTO emi_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Laghe ue va, “Taumattu ngateva oia Iesu etana, natuna ia Josep, ami kilakila tamana me kinna, vaalua me eue va ghe kasula epona liu?” ");
INSERT INTO emi_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iesu ghe uela etaira va, “Am rau mene olueinaghi. ");
INSERT INTO emi_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Karika teva erooroo tani mae etaghi arova Tamaghi, ia o ghe sungieghila, etam gheleia tani mae etaghi. Me arova teva emae etaghi, aghi aue atotua, me eghaa maulue tale airuuruu eteva nau. ");
INSERT INTO emi_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kateva propet ghe pitila ghe uela va, ‘God aue eapasunga voto tale isaa akapa taumattu.’ Liuna avalua o me lo atoa la nongonongo usilaa Tamaghi me la ghaaghaa alomasaanga etana, aue la mae etaghi. ");
INSERT INTO emi_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Karika mene teva taumattu ghe tarala Tamaghi, ta llo nonga ateva ghe tokatoka teeia, me ghe sio mae. Nim ie nonga, me mene karika teva. ");
INSERT INTO emi_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Aghaaulia ngakoronna etaimim va lo ateva eaikaaiaa etaghi, maulue ateva tokatoka liu ia etokatoka etana. ");
INSERT INTO emi_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Aghi verete ateva etautau maulue ateva. ");
INSERT INTO emi_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tuvuimim atoa laghe namala mena tale voto ateva karika righi taumattu etokatoka etana, vara me laghe matela. ");
INSERT INTO emi_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Me lo ateva verete ghe kasula epona liu me ghe sio mae, lo ateva enamaia, karika aue emate. ");
INSERT INTO emi_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Aghi verete maulue ieghi, aghe kasula epona liu. Lo ateva enama ia o verete ateva aue etoka nau ekapa atoa. Me ia o verete ateva aue atauela, malataughu eteva. Aghe taue lao sio tale taumattu tale kosa ateva oia, me aue la roo tani ghaa maulue.” ");
INSERT INTO emi_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nau eteva aJiu etoa laghe nongola isaa o inangarina, ghe sessailala, me laghe ue va, “Vaalua aue etau mae malatauna, me ita nama?” ");
INSERT INTO emi_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iesu ghe liula me ghe uela etaira va, “Aghaaulia ngakoronna etaimim va karika am rooroo tani ghaa maulue, arova am tam nama malatauna Natuna ateva Taumattu ngateva, me am tam ropi raena ateva. ");
INSERT INTO emi_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Lo ateva taumattu enama malataughu, me eropi raeghi eteva, aue eghaa maulue ateva tokatoka liu ia, me aue atotua, me eghaa maulue tale airuuruu tale kosa ateva. ");
INSERT INTO emi_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Poli malataughu eteva inana tuungia, me raeghi eteva ateo tuungia. ");
INSERT INTO emi_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Lo ateva enama malataughu, me eropi raeghi, etokatoka teeieghi, me aghi atokatoka teeia. ");
INSERT INTO emi_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tamaghi, aitau maulue ia, ghe sungieghila tani sio, me atokatoka poli Tamaghi etautau mae maulue. Liuna avalua o me lo ateva enamaieghi, mausighi me aue eghaa maulue. ");
INSERT INTO emi_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Lo ateva o verete ghe kasula epona liu karika nongina lo ateva verete tuvuimim atoa laghe namaiela, me ngeila ghe matela. See enama lo ateva oia verete aue etoka nau ekapa atoa.” ");
INSERT INTO emi_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Isaa o inangari Iesu ghe aauliaa me ghe aapasunga tale aleira ale nivelu eitauaa aJiu etoa eKapenium. ");
INSERT INTO emi_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Oroi ila lo atoa disaepolo laghe nongola me laghe uela va, “See aue enongo, poli aanasaaili inangari eaauliaa?” ");
INSERT INTO emi_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iesu ghe kilala sa ateva kapuna disaepolo atoa laghe annainia, liuna avalua o me ghe kolomilala va, “Vaalua me isaa o inangari ange ghelei saasakiaala aikaaiaaimim? ");
INSERT INTO emi_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Vaalua ta arova am ghele tara Natuna ateva Taumattu ngateva ghele sae nongina ghe kasula? ");
INSERT INTO emi_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Spirit Manga nonga ateva etautau lao maulue tale taumattu. Sarasarakaniaa taumattu karika aue eghelei righi llo. Isaa o inangari aghaauliaa etaimim ekasukasu tale Spirit Manga ateva, me etautau aatu maulue ateva. ");
INSERT INTO emi_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Me katoa etaimim karika am aikaaiaa.” (Iesu ghe auliaa llo poli ang ghe kila vella va see karika aue eaikaaiaa etana, me ang ghe kila teela see aue etaue lao ta nimaira tau ngai ssateena atoa.) ");
INSERT INTO emi_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Me Iesu ghe uela etaira va, “Mausina avalua o me aghaauliaa etaimim, va karika teva erooroo tani mae etaghi, arova Tamaghi etam gheleia tani mae.” ");
INSERT INTO emi_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Poli isaa o inangarina Iesu ghe auliaala me oroi kapuna disaepolo laghe liula viliira ta Iesu, me laghe ruula tani usia. ");
INSERT INTO emi_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Iesu ghe kolomila kapuna kasangaulu ghalua (12) disaepolo va, “Am tee am aloanna tani kasu vulieghi?” ");
INSERT INTO emi_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saemon Pita ghe liula me ghe uela va, “Vau eteva, ami mene lao ta see? Poli inangari maulue ateva tokatoka liu ia, ia etam. ");
INSERT INTO emi_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ami aikaaiaa etam, me ami kilakilaaili va io taumattu ngateva manga ia kapuna ia God.” ");
INSERT INTO emi_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Iesu ghe liula me ghe uela va, “Am oia kasangaulu ghalue iem aghe suitoongainiemla, me kateva etaimim nongina raroai eteva!” ");
INSERT INTO emi_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iesu ghe aauliaa Jiudas, natuna ia Saemon Iskariot, ie tee elome ta kasangaulu ghalua kapuna disaepolo, me ia aue etau lao Iesu ta tau ngai ssateena atoa. ");
INSERT INTO emi_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Vara me Iesu ghe kasu seela eGalilii, me karika ghe aloanna tani sae eJiudia, poli aJiu etoa laghe anna tani uvi ematea. ");
INSERT INTO emi_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nau ang ghe aakalakalaa tani velu eitauaa me aJiu etoa laghe ghelei lutu ale kamekame. ");
INSERT INTO emi_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nengane atoa Iesu laghe ue etana va, “Kasula me usae eJiudia, me kapum disaepolo atoa aue la tara uunguaam ugheelei. ");
INSERT INTO emi_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Lo ateva eanna va taumattu ngatoa la kilaia karika eaaisulia va egheelei voto. Liuna avalua o me emasina va ughelei tale tummatavanga me kosa akapa ateva aue ekilaio.” ");
INSERT INTO emi_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nengane atoa laghe aulia ngavaluela o, poli ila tee karika laghe aaikaaiaa ta Iesu. ");
INSERT INTO emi_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Iesu ghe uela etaira va, “Naughu karika ghe mae. Am nauimim etokatoka arau. ");
INSERT INTO emi_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Taumattu tale kosa ateva oio karika aue la ssa teeiem. Aue esessaila nonga etaghi, poli aghaaulia ngaotu gheeleiaaira karika masina. ");
INSERT INTO emi_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Am saela tale nivelu eitaua ngateae. Karika aue asae poli naughu karika ghe mae.” ");
INSERT INTO emi_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ghe auliaala isaa o inangari, me ghe tokala eGalilii. ");
INSERT INTO emi_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Vara nengana atoa laghe kasula tani sae tale nivelu eitaua ngateae, me Iesu ghe vira aimulila. Kasukasuaane karika toa laghe kilaiela, ghe nim kasu einaola tani sae. ");
INSERT INTO emi_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tale ia o nivelu eitaua ngateae, namuu ta aJiu etoa ngila ghe paepae Iesu, me laghe aikolomainie see va, “Eaa ia?” ");
INSERT INTO emi_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ta polina me taumattu ngatoa ngila ghe auliuliueinia. Katoa laghe ue va, “Iesu masi taumattu ia.” Me katoa laghe ue va, “Enim kamekame taumattu ngatoa.” ");
INSERT INTO emi_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Karika teva ghe auliaa isaa o inangari ta mata ngoroi etoa, poli laghe maamatauta kapuira namu ngatoa aJiu etoa. ");
INSERT INTO emi_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Laghe ghaa longotila tale ia o nivelu eitaua ngateae, me Iesu ghe tiuaala tani apasunga voto ta taumattu ngatoa tale ale ngeleka atiulu tale ale manga ateva. ");
INSERT INTO emi_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Namuu ta aJiu etoa laghe soghiaala tani nongoa, me laghe ue va, “Vaalua me ekilakila oroi voto nau karika teva ghe apasungaala etana?” ");
INSERT INTO emi_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iesu ghe liula me ghe uela va, “Karika aghaapasunga nim nannaaghi. Voto aghaapasunga kanna lo ateva ghe sungieghila. ");
INSERT INTO emi_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Arova teva eannaaili tani aimuli tee aloannaane God, aue ghele kila va voto aghaapasunga ekasukasu ta God, me karika va nim kalughu. ");
INSERT INTO emi_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Lo ateva taumattu eauliaa nannaane enim aloanna tani ghelei ararina ateae, me lo ateva ealoanna tani tau sae ararina ateae lo ateva ghe sungiela, voto eaauliaa koronna, karika kamena. ");
INSERT INTO emi_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses ghe tau aatu sio inangari nipaopao etaimim, me karika teva etaimim eaaimuli tee. Mausi saa me am anna tani uvi emateaghi?” ");
INSERT INTO emi_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Taumattu ngatoa laghe ue etana va, “Raroai eteva etam. See eanna tani uvio?” ");
INSERT INTO emi_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Iesu ghe liula me ghe uela va, “Aghe gheleila kateva voto, me am ghe soghieiniela. ");
INSERT INTO emi_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses ghe uela etaimim va am iso natuimim taita atoa (karika va tani Moses ghe auliaala, ta tuvuimim atoa). Me am isoisoila tale nau manga ateva. ");
INSERT INTO emi_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Arova am rooroo tani iso aliki eteva tale nau manga ateva, tani nongo usilaa inangari nipaopao kanna Moses ghe auliaala, o vaalua esessaiem etaghi, poli aghe ghelei emasina akapala vilikina taumattu ngateva tee tale nau manga ateva? ");
INSERT INTO emi_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Am rau mene auliaa gheeleia taumattu tale taataraimim, am ghelei niaisakei tale ghulughuluena salana.” ");
INSERT INTO emi_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Katoa tana taumattu nge Jerusalem laghe ue va, “Ia oia taumattu ngateva la paepaea tani uvia? ");
INSERT INTO emi_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tarala, epoppooaa ta mata ngoroi etoa, me karika la gheelei righi voto etana. Koti namu ngatoa la kilakila akoronna va ia Mesaea ia. ");
INSERT INTO emi_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Me iekai ita kilakila tanganuena, me Mesaea ngateva, karika aue ita kila va eaa tanganuena.” ");
INSERT INTO emi_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Iesu ghe aapasunga tale ale manga ateva, me ghe sama anamungailiila, me ghe uela va, “Am annaa vara am kilakilaieghi, me vara am kilakila tanganueghi. Aghi karika aghe mae sio tale aloaloannaaghi. Lo ateva ghe sungieghila koronna ia, me am, karika am kilakilaia. ");
INSERT INTO emi_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Aghi akilakilaia, poli aghe tokatoka teeia, me ghe sungieghila tani sio.” ");
INSERT INTO emi_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Katoa taumattu laghe anna tani kuneia, me karika laghe roola tani kuneia, poli nauna karika ghe mae. ");
INSERT INTO emi_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Oroi taumattu ghe aikaaiaala etana, me laghe ue va, “Arova Mesaea ngateva esio, koti voto aue eghelei aue elau llo ia oia taumattu ngateva egheelei?” ");
INSERT INTO emi_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nau Paresi etoa laghe nongola taumattu ngatoa laghe aissakeana, laghe lao sio tani tara namuu ta pristi etoa, ila me namuu ta pristi etoa laghe suula polisi etoa tani laa kune Iesu. ");
INSERT INTO emi_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Me Iesu ghe uela etaira va, “Karika oroi nau aue atoka teeiem, me amene kasu tani sae ta lo ateva ghe sungieghila. ");
INSERT INTO emi_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Aue am pae poieghi, me karika aue am taraieghi, poli voto ateva alao etana am karika am rooroo tani lao etana.” ");
INSERT INTO emi_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Taumattu nge Jiu etoa laghe tiuaala tani aikolomieinila va, “Eaa aue elao me karika aue ita taraia? Koti aue elao tale llo masaliki aGrik atoa la ghaaitoiaa, me katoa tani kapuita la tokatoka etana. Koti aue mene laa ghapasunga ta aGrik atoa. ");
INSERT INTO emi_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Saa malloeana inangarina nau eue va, ‘Aue am pae poieghi, me karika aue am taraieghi’, me ‘Voto ateva alao etana am karika am rooroo tani lao etana’?” ");
INSERT INTO emi_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Airuuruu tale ia o nivelu eitaua ngateae, kinatama nauira ateva, Iesu ghe tinginala, me ghe sama anamungailiila me ghe uela va, “Lo ateva ukaakangngata tani ropi, umae etaghi me uropi. ");
INSERT INTO emi_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Lo ateva eaikaaiaa etaghi, aue ateo ateae maulue ia aue eakalaa elome tale urunguitanina ateva, nongina Uru ngai Manga ateva eaauliaa.” ");
INSERT INTO emi_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iesu ghe aauliaa Spirit Manga ateva va lo atoa la aikaaiaa etana aue la ghaaia. Isaa o nau Spirit Manga ateva karika ghe mae, poli God karika ghe tau sae Iesu. ");
INSERT INTO emi_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Katoa taumattu laghe nongola isaa o inangari Iesu ghe aauliaa etaira me laghe uela va, “Koronna, taumattu ngateva oia, ia o propete ateva Moses ghe aulieiniela.” ");
INSERT INTO emi_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Mene katoa laghe ue va, “Ia oia taumattu ngateva Mesaea etana.” Mene katoa laghe ue va, “Karika va Mesaea ngateva aue ekasu eGalilii. ");
INSERT INTO emi_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Uru ngai Manga ateva eue va Mesaea ngateva aue elutu ta mangalina atoa Deivit, me aue elutu eBetlehem, ia o masalikina ia Deivit.” ");
INSERT INTO emi_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Taumattu ngatoa ghe ghalueilala tale ninannaa ta poli Iesu. ");
INSERT INTO emi_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Katoa ngila ghe anna tani kuneia, me karika teva ghe roola. ");
INSERT INTO emi_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Polisi etoa laghe laa rekata sio, me namuu ta pristi etoa me Paresi etoa laghe kolomilala va, “Vaalua me am tam maeaa sio Iesu?” ");
INSERT INTO emi_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Polisi etoa laghe liula me laghe uela va, “Karika teva taumattu erooroo tani aippooaa nongina taumattu ngateva okae.” ");
INSERT INTO emi_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Me Paresi etoa laghe uela va, “Ae! Am tee ange kamekameam? ");
INSERT INTO emi_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ngam tarala va teva namuu ta aJiu etoa me Paresi etoa eaaikaaiaa etana? ");
INSERT INTO emi_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Lo atoa la ghaikaaiaa etana karika la kilakila inangari nipaopao, me God ang ghe kasikienainilala.” ");
INSERT INTO emi_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimas, ia o ghe lao akasina sio ta Iesu, ie tee ghe tokatoka me ghe uela va, ");
INSERT INTO emi_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Uneita inangari nipaopao eue va, ita rau mene ghelei righi voto ta teva taumattu, ita tani nongo mua va sa ateva ghe gheleiela.” ");
INSERT INTO emi_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Me laghe uela etana va, “Koti io tee aGalilii io? Uriti Uru ngai Manga ateva, me utara va karika teva propete aue ekasu eGalilii.” ");
INSERT INTO emi_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Me laghe tiu reerekataala tani lao tanganueira. ");
INSERT INTO emi_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Iesu ghe saela tale motouru eteva ararina ateae eOliv. ");
INSERT INTO emi_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Elue talaua poopooa ghe mene ssola tale ale manga ateva, me taumattu ngakapa atoa laghe mene mae sio tani taraia, me ghe toka siola, me ghe tiuaala tani apasunga etaira. ");
INSERT INTO emi_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Vara me Paresi etoa me tau ngai aapasunga ngatoa tale inangari nipaopao ngila ghe reerekataa vause ateva etana. Laghe taraiela ghe aso teela taita ateva karika manna ia, me laghe atinginaiela elome ta mata taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Me laghe uela ta Iesu va, “Tisa, ia oia vause ateva easoaso tee taita ateva karika manna ia, me ami ghaaiela. ");
INSERT INTO emi_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Tale inangari nipaopao Moses ghe uela va ia oia ase vause ateva egheelei evalua o pei nikumu ematea. Me io, aue uue va saa?” ");
INSERT INTO emi_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Laghe aaulia ngavalua o tani tootoonga Iesu, me saa llo ghe auliaa aue laghe tingina etana tani ghelei niaisakei etana. Iesu ghe tturru siola euu, me ghe tiuaala tani pitipiti tale vuuvuu nimane ateva nonginaaili va karika ghe nongonongola. ");
INSERT INTO emi_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Laghe mene kookolomia, me Iesu ghe tinginala, me ghe uela etaira va, “Lo ateva elome etaimim etam gheelei righi voto sesa, ughaa tiulu atu, me io uaitiutiu tani kumua.” ");
INSERT INTO emi_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Vara me ghe mene tturru siola euu, me ghe mene tiuaala tani pitipiti. ");
INSERT INTO emi_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Me lo atoa laghe nongola, laghe tiuaala tani kasu kateva kateva, ghe tiuaala ta namu ngatoa, me ghe laa ruu sio tale airuuruu eteva taumattu. Me Iesu nonga me vause ateva lalu ghe tokala. ");
INSERT INTO emi_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iesu ghe mene tingina saela, me ghe uela etana va, “Eaa ila? Karika teva eanna tani tau aatu sesa aipolipoli etam?” ");
INSERT INTO emi_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ghe liula me ghe uela va, “Karika teva, namu ngateva.” Me Iesu ghe uela va, “Aghi tee atam anna tani tau aatu sesa aipolipoli etam. Kasula, me unim ruu tani ghelei ssavoto.” ");
INSERT INTO emi_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Iesu ghe mene uela ta taumattu ngatoa va, “Aghi mallanga ieghi tale kosa ateva oia. Lo ateva eaimuli teeieghi, karika aue ekasu tale saurrom ateva, ta aue eghaa lo ateva o mallanga etautau aatu maulue.” ");
INSERT INTO emi_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Paresi etoa laghe nongola, me laghe uela ta Iesu va, “Io nonga uaaulia ngaotu gheeleiaam me uunguaam. Liuna avalua o me inangarim karika koronna.” ");
INSERT INTO emi_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iesu ghe liula me ghe uela va, “Koronna va aghaulieinaghi nonga, me inangarighi koronna. Ta poli akilakila tanganueghi me eaa alaolao, me am, am tam kilakila tanganueghi me eaa aue alao. ");
INSERT INTO emi_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Am, am gheelei niaisakei tale taumattu nongina gheeleiaa kosa ateva, me aghi karika. Karika agheelei niaisakei tale teva taumattu. ");
INSERT INTO emi_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Arova aghele ghelei niaisakei aue aghele ghelei ekoronna poli karika va aghi nonga aue aghele ghelei, ta aghi me Tamaghi ghe sungieghila aue angalu ghele ghelei. ");
INSERT INTO emi_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Uneimim inangari nipaopao eue va, arova ghalua taumattu lalu auliaa inangariirarua me elao aitauaa, isaa o inangari am vira kaili ekoronna. ");
INSERT INTO emi_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Aghi aghaaulia ngaotu uunguaaghi me gheeleiaaghi, me Tamaghi, ia o ghe sungieghila, ie tee eaauliaa uunguaaghi me gheeleiaaghi.” ");
INSERT INTO emi_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Vara me laghe kolomiela va, “O eaa ia tamam?” Iesu ghe liula me ghe uela va, “Arova am kilakilaieghi, aue am ghele kila Tamaghi, me poli am tam kilakilaieghi, karika aue am kila Tamaghi.” ");
INSERT INTO emi_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesu ghe aauliaa isaa o inangari kalakalaa tale ale atiulu laghe kaakaai viliki veu etana tale ale manga ateva. Karika teva taumattu ghe anna tani kuneia, poli nauna karika ghe mae. ");
INSERT INTO emi_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iesu ghe mene uela etaira va, “Aue akasu vuliem, me aue am pae poieghi, me am mate tee kaluimim ssavoto. Karika am rooroo tani lao nongina aue alao.” ");
INSERT INTO emi_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","AJiu etoa laghe aikolomieinila va, “Vaalua me eue va, ‘Karika am rooroo tani lao nongina aue alao’? Koti enim aloanna tani uvi ematea, no?” ");
INSERT INTO emi_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Iesu ghe uela etaira va, “Am, tanganueimim oia euu, me aghi, tanganueghi epona liu, me am taumattu tale kosa ateva oia, me aghi karika. ");
INSERT INTO emi_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Aghaauliaa etaimim va aue am mate tee kaluimim ssavoto, poli arova am tam aiesoaa va aghi see, aue am mate tee kaluimim ssavoto.” ");
INSERT INTO emi_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Me laghe kolomiela va, “Io see io?” Me Iesu ghe uela etaira va, “Aghi ia o taumattu ngateva aghe aulieiniela etaimim emua arau. ");
INSERT INTO emi_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Oroiannaaili voto arooroo tani auliaa tani aotu gheeleiaaimim karika masina, me tani ghelei niaisakei etaimim. Ta lo ateva aghaaulieinia koronna ia, poli lo ateva ghe sungieghila koronna ia, me aghi aghaulia ngaotu tale taumattu tale kosa ateva saa voto aghe nongola etana.” ");
INSERT INTO emi_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Karika laghe kilakila va Iesu ghe aauliaa Tamane. ");
INSERT INTO emi_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Iesu ghe ue etaira va, “Nau eteva aue am avukala sae Natuna ateva Taumattu ngateva, me aue am vira mene kila va aghi see. Me karika agheelei righi voto ta nannaaghi, ta agheelei nonga voto Tamaghi ghe apasungaala. ");
INSERT INTO emi_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Lo ateva ghe sungieghila etokatoka teeieghi. Karika etautau velueghi va aghi nonga atokatoka, poli nau ekapa atoa agheeghelei llo voto ealoanna.” ");
INSERT INTO emi_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nau taumattu ngatoa laghe nongola inangarina, oroi ila lo atoa laghe aikaaiaala etana. ");
INSERT INTO emi_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Vara me Iesu ghe uela ta lo atoa aJiu laghe aaiesoaa etana va, “Arova nau ekapa atoa am aimuli tee inangarighi, am aue kapughu disaepolo tuungi iem, ");
INSERT INTO emi_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","me aue am kila koronna inangari, me llo koronna aue gheleiem am ruu tani nim uungu ta katoa me karika am tokatoka tale aloannaaimim.” ");
INSERT INTO emi_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Laghe liula me laghe uela va, “Ami tuvuimami ta Abraham, karika teva etaimami enim uungu me karika etokatoka tale aloaloannaane. Vaalua me uue va, ‘Aue am ruu tani uungu ta katoa’?” ");
INSERT INTO emi_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iesu ghe liula me ghe uela va, “Aghaaulia ngakoronna etaimim va lo ateva enim toka gheelei voto sesa, ia tau ngai uungu ia tale voto llo sesa, karika etokatoka tale aloannaane. ");
INSERT INTO emi_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tau ngai nongonongo anna ateva enim tokatoka tau tee vauna ateva. Natuna nonga ateva vauna ateva aue etoka teeia nau ekapa atoa. ");
INSERT INTO emi_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Arova natuna ateva egheleiem am ruu tani uungu ta katoa, aue am vira ruu tani uungu ta katoa. ");
INSERT INTO emi_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Akilakila va tuvuna am Abraham, me poli inangarighi karika elome tale urunguitaniimim, me am aloanna tani uvi emateaghi. ");
INSERT INTO emi_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Voto aghe tarala ta Tamaghi, aghaauliaa. Voto am ghe nongola ta tamaimim ateva am gheeghelei.” ");
INSERT INTO emi_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Laghe liula me laghe uela ta Iesu va, “Ami tuvuimami eteva ta Abraham.” Me Iesu ghe uela etaira va, “Arova tuvuna am Abraham aue am ghele ghelei voto nongina Abraham ghe gheelei. ");
INSERT INTO emi_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nau eteva aghaauliaa voto koronna aghe nongola ta God, am aloanna tani uvi emateaghi. Abraham karika ghe gheelei evalua o. ");
INSERT INTO emi_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Am, am tani gheelei nonginaaili tamaimim ateva.” Me laghe uela etana va, “Vara natu ngerengere iemami? Ami kateva nonga tamaimami God ta ngetana.” ");
INSERT INTO emi_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iesu ghe uela etaira va, “Arova natuna iem God, aue am ghele aielousieinaghi, poli aghe kasula nongina etokatoka. Karika nim nannaaghi va aghe sio mae, ia ghe sungieghila tani sio. ");
INSERT INTO emi_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Vaalua me karika am nongonongo kila inangarighi? Poli karika am rooroo tani nongo inangarighi, ");
INSERT INTO emi_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","am tamaimim ateva ta Satana, poli am aloanna tani ghelei voto ealoanna. Ia emua arau ghe aiuuvi ematela, me karika eaauliaa righi koronna poli karika righi koronna etana. Nau eaauliaa kamena, euusila ngarau gheegheleiaane kamena. Poli ia ekamekame, o tamaira akapa ia lo atoa la kamekame. ");
INSERT INTO emi_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ta poli aghaauliaa voto koronna, karika am aikaaiaa etaghi. ");
INSERT INTO emi_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Teva etaimim erooroo tani auliaa righi gheeleiaaghi karika masina? Arova aghauliaa koronna, vaalua me am tam aikaaiaa ta ngetaghi? ");
INSERT INTO emi_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Lo atoa natuna ila God, aue la nongo usilaa inangarina, me am, karika am aloanna tani nongo inangarina, poli karika va natuna am God.” ");
INSERT INTO emi_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Me aJiu etoa laghe liula me laghe uela ta Iesu va, “Inangariimami ami aauliaa koronna va io aSameria io, me raroai eteva etokatoka etam, va?” ");
INSERT INTO emi_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Iesu ghe liula me ghe uela va, “Karika teva raroai etaghi, ta anim tautau sae ararina ateae Tamaghi, me am aasiosio ararighi eteae. ");
INSERT INTO emi_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Me aghi karika aghanna tani ghelei ararighi eteae. Kateva nonga eanna tani tau sae ararighi eteae, me ia tau ngai ghelei niaisakei ia. ");
INSERT INTO emi_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Aghaaulia ngakoronna etaimim va arova lo ateva enongo usilaa inangarighi, ia o taumattu ngateva karika aue etara nimate.” ");
INSERT INTO emi_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Me aJiu etoa laghe uela etana va, “Ia oia ngami kilala va raroai eteva etokatoka etam, poli Abraham me mene katoa propete ngila ghe matela. O me uue va, ‘Lo atoa la nongo usilaa inangarighi karika aue la ateateaa nimate.’ ");
INSERT INTO emi_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Vara io va namuu io ta tuvuimami eteva ta Abraham me mene katoa propete ngila ghe matela? Vara mene see etam?” ");
INSERT INTO emi_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iesu ghe liula me ghe uela va, “Arova aghele tau sae ararighi eteae, ararighi eteae nim kapa ia. Me Tamaghi, ia o am ue va kapuimim Goto ia, etautau sae ararighi eteae. ");
INSERT INTO emi_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Am karika am kilakilaia. Aghi nonga akilakilaia. Arova aghele ue va karika akilakila, aue aghele kamekame nongina am tau nikamekame iem. Aghi akilakilaia, me anongonongo usilaa inangarina. ");
INSERT INTO emi_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tuvuimim ateva ta Abraham ghe masimasieiliila tani tara isaa oia naughu. Nau eteva ghe tarala ghe masimasieiliila.” ");
INSERT INTO emi_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Me aJiu etoa laghe uela etana va, “Meie! Anem ninamanama karika ghe nim sae ta ghalimangauluae (50), me vaalua ughe tarala Abraham?” ");
INSERT INTO emi_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iesu ghe uela etaira va, “Aghaaulia ngakoronna etaimim va auena Abraham ghe lutu, aghi ngaghe toka vella arau!” ");
INSERT INTO emi_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Me ngila ghe reirei atu tani kumua. Iesu ghe aisuliaala, me ghe kupi ghoala tale ale manga ateva. ");
INSERT INTO emi_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iesu ghe kasukasu elaolao, me ghe tarala taumattu ngateva ghe lutu emata salusalula. ");
INSERT INTO emi_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kapuna disaepolo atoa laghe kolomiela va, “Tisa, vaalua me ghe mata salusalunala, poli ia kanna ssavoto, o tamana me kinna?” ");
INSERT INTO emi_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iesu ghe liula etaira me ghe uela va, “Karika va ia kanna ssavoto, o tamana me kinna, ta mausi aue taumattu ngatoa la tara uunguaane God etana. ");
INSERT INTO emi_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Aue ita ghelei uunguaane lo ateva ghe sungieghila tani mae ghelei. Ellaa ita tani uungu, va nau eleivoo, karika teva erooroo tani uungu. ");
INSERT INTO emi_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nau atokatoka oia tale kosa ateva, aghi mallanga aghi tale kosa ateva.” ");
INSERT INTO emi_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nau ghe aippooaa, me ghe kanusuila tuku kosa ateva, va ghe maramarakanala, me ghe atavainie saela tale matana alua, ");
INSERT INTO emi_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","me ghe uela etana va, “Kasula, me ulaa pora matam tale ateo ateae kaikaina ia, ararina ateae ta Siloam.” (Malloeana Siloam va “sungiela”.) Ghe porala matana, me ghe kiriaala, me ghe taatara. ");
INSERT INTO emi_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kapuna atoa me lo atoa laghe taataraia ta ghe toka looloo, laghe ue va, “Karika va ia okae taumattu ngateva ghe toka looloo nonga tapaa ngatamana tale ale manga ateva?” ");
INSERT INTO emi_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Katoa laghe ue va, “Ia oio taumattu ngateva.” Mene katoa laghe ue va, “Karika, arova taataraane va ia okae.” Ia ghe uela va, “Aghi oia.” ");
INSERT INTO emi_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Laghe kolomiela va, “Vaalua me matam ghe taatarala?” ");
INSERT INTO emi_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ghe liula me ghe uela va, “Taumattu ngateva la kolokoloa va Iesu etana, ghe ghelei emaramarakanala tuku kosa ateva, me ghe atavainie saela ta mataghi, me ghe uela etaghi va, ‘Ulaa pora matam tale ateo ateae eSiloam.’ Aghe lao sio va aghe porala mataghi, me aghe taatarala.” ");
INSERT INTO emi_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Laghe kolomiela va, “Eaa ia, ia ona taumattu ngateva uaulieinia?” Ghe liula me ghe uela etaira va, “Karika anga kilala.” ");
INSERT INTO emi_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Laghe laoaa sio taumattu ngateva mata salusalu ia ta Paresi etoa. ");
INSERT INTO emi_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ia o nau eteva nau manga ia Iesu ghe ghelei emaramarakanala tuku kosa ateva, me ghe gheleila matana alua lalu ghe taatarala. ");
INSERT INTO emi_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Paresi tee atoa laghe kolomiela va, “Vaalua utaatarala?” Ghe uela etaira va, “Ghe atava saela kosa maramarakana ta mataghi, me aghe lao sio tani pora mataghi, me aghe taatarala.” ");
INSERT INTO emi_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Katoa Paresi laghe ue etana va, “Taumattu ngateva oia karika va God ghe sungiela, poli etam aitaraa nau manga ateva.” Mene katoa laghe ue va, “Vaalua sesa taumattu ngateva erooroo tani ghelei righi niaimatoonga?” Ghe ghaluela nannaaira me laghe aitiuaala. ");
INSERT INTO emi_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Laghe mene ue ta mata salusalu eteva va, “Io, vaalua nannaam etana, ta poli ghe otila matam alua?” Ghe uela va, “Ia propete ia.” ");
INSERT INTO emi_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Poli aJiu etoa laghe tam aikaaiaa inangarina mata salusalu eteva, va ia mata salusaluna ia, me ghe mene taatarala, laghe suula inangari ta tamana me kinna va lalu mae. ");
INSERT INTO emi_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Angila ghe kookolomi tamana me kinna va, “Ierai natuimalue ia? Amalu ghe ue va ghe lutu emata salusalunala? Me vaalua me ghaine etaatara?” ");
INSERT INTO emi_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tamana me kinna lalu ghe liula etaira va, “Angalu kilakilaia va natungalue ia ta ghe lutu emata salusalunala. ");
INSERT INTO emi_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Vaalua me ghaine etaatara, angalu tam kilakila va see ghe otila matana alua. Am kolomia, ta namuu ia, me ia aue eauliaa etaimim.” ");
INSERT INTO emi_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Lalu ghe aulia ngavalua o poli lalu ghe maamatauta namuu ta aJiu etoa, ta namuu ta aJiu etoa laghe ue va arova lo atoa la ue va Iesu Mesaea ia, aue la tiu vella tale ale nivelu eitaua ngateva, me karika aue la mene mae kkaua teeila. ");
INSERT INTO emi_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Liuna avalua o tamana me kinna lalu ghe uela va, “Am kolomia, ta namuu ia.” ");
INSERT INTO emi_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Laghe mene kolola mata salusalu eteva ghe mae sio. Me laghe uela etana va, “Utau sae God, poli ami kilakila taumattu ngateva ona va tau ngai gheelei ssavoto ia.” ");
INSERT INTO emi_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ghe liula etaira va, “Arova tau ngai gheelei ssavoto ia o karika, atam kilakila. Kateva nonga voto akilakilaia va, aghi mata salusalu ieghi, me isaa oia ngataatarala.” ");
INSERT INTO emi_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Laghe mene kolomiela va, “Saa llo ghe gheleila etam, me vaalua ghe otila matam?” ");
INSERT INTO emi_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ghe liula etaira va, “Ngaghe auliaa muela etaimim, me karika am ghe aloanna tani nongo. Vaalua me am aloanna tani mene nongo? Koti am tee, am anna va ekapuna disaepolo iem?” ");
INSERT INTO emi_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Paresi etoa laghe auliaa saasakiaala etana. Laghe uela etana va, “Io nonga kapuna disaepolo io, ami kapuna disaepolo iemami Moses. ");
INSERT INTO emi_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ami kilakila va God ghe aippooaa teela Moses. Me ia ona taumattu ngateva, ami tam kilakila tanganuena.” ");
INSERT INTO emi_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Taita ateva oia ghe liula etaira va, “Ngasoghiaala inangariimim! Am ue va am tam kilakila tanganuena, me ia oia taumattu ngateva ghe otila mataghi elua. ");
INSERT INTO emi_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ita kilakila va God etam rooroo tani nongo usilaa tau ngai gheelei ssavoto atoa, me arova lo ateva ekakkaua God me eaimuli usi tee aloannaane God, ia aue God enongo usilainia. ");
INSERT INTO emi_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Emua arau nau kosa ateva ghe tiuaala, karika ita ghe nongo poila righi taumattu ghe lutu esalusalunala me matana ghe mene otila. ");
INSERT INTO emi_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Arova ghe tam kasula ta God, karika erooroo tani ghelei righi voto.” ");
INSERT INTO emi_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Me laghe liula me laghe uela etana va, “Ughe lutula tale ssavoto, me vaalua me uanna tani apasunga voto etaimami!” Me laghe tiu veluela va karika emene mae kkaua teeila. ");
INSERT INTO emi_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iesu ghe nongola va ngila ghe tiu veluela. Nau ta ghe paeala me ghe taraiela, ghe uela etana va, “Uaikaaiaa ta Natuna ateva Taumattu ngateva?” ");
INSERT INTO emi_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Me taumattu ngateva o ghe kolomila va, “Namu ngateva, auliaala etaghi va see ia, ia ona taumattu ngateva, me aue aghaikaaiaa ta ngetana.” ");
INSERT INTO emi_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iesu ghe uela etana va, “Angu ghe taraiela, me ia oia esamasama teeio.” ");
INSERT INTO emi_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Me taumattu ngateva o ghe uela va, “Vau eteva, aghaaikaaiaa,” me ghe suuiaala ta liue kkena Iesu me ghe kaueiniela. ");
INSERT INTO emi_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iesu ghe uela va, “Aghe sio mae tale kosa ateva tani ghelei niaisakei ta taumattu ngatoa, me aue lo atoa mata salusaluna ila la taatara, me lo atoa la taatara la mata salusaluna.” ");
INSERT INTO emi_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Katoa Paresi laghe tokatoka me laghe nongola llo Iesu ghe auliaala, me laghe kolomiela va, “O ami tee mata salusalu iemami?” ");
INSERT INTO emi_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iesu ghe liula me ghe uela va, “Arova mataimim salusaluna, karika aue ghele righi kaluimim ssavoto, me poli am ue va, ‘Ami taatara,’ liuna avalua o me kaluimim ssavoto, ie etokatoka etaimim.” ");
INSERT INTO emi_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Iesu ghe mene uela va, “Aghaaulia ngakoronna etaimim va lo ateva taumattu, karika ekupikupi sso tale atamani valavala sipsipi eteae, ta etattakole tale valavala ateae, tau niainao ia, me aisari katoa ghinnaniira ia. ");
INSERT INTO emi_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Lo ateva taumattu ekupikupi sso tale atamana ateae, ia tau ngai toi sipsipi ia. ");
INSERT INTO emi_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tau ngai toi atamana ateae etaatara kila tau ngai toi sipsipi eteva, me eotioti atamana ateae, me tau ngai toi sipsipi eteva ekupikupi sso, me sipsipi etoa la nongonongo kila lingi ngalona ateva. Ekolokoloa arariira kiena sipsipi etoa, me ekuukupieinila ghoa eleka. ");
INSERT INTO emi_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nau eteva ekuukupia ngakapa ghoa kiena sipsipi, me emuemueinila, me kiena sipsipi etoa la ghaaimuli teeia, poli la nongonongo kila lingi ngalona ateva. ");
INSERT INTO emi_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Karika la rooroo tani usi mene teva ppae taumattu. Me aue la ghele ilou vuli teeia, poli karika la nongonongo kila lingi ngalona ateva.” ");
INSERT INTO emi_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu ghe auliaala ia o kiukiu niaimatoongana ateae, me nannaaira karika ghe masalike teela voto ghe auliaala etaira. ");
INSERT INTO emi_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Liuna avalua o me Iesu ghe mene uela etaira va, “Aghaaulia ngakoronna etaimim va aghi atamani sipsipi etoa ieghi. ");
INSERT INTO emi_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Lo atoa laghe muemue mae akasina sio etaghi, tau niainao ila me aisari ghinna ila, me sipsipi etoa karika laghe nongo kilailala. ");
INSERT INTO emi_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Aghi atamana ieghi. Lo ateva ekupikupi sso etaghi aue esaanga. Aue esso me eghoa, me aue eghaa masi inana. ");
INSERT INTO emi_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tau niainao ateva emaemae tani ainao, me tani aiuuvii emate, me tani tturuu. Me aghi aghe mae sio va la ghaa maulue, me maamauluaaira epasu tale masi voto. ");
INSERT INTO emi_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Aghi masi tau ngai toi sipsipi ieghi. Masi aitoi sipsipi eteva, etautau maamauluaane tani sausi kiena sipsipi etoa. ");
INSERT INTO emi_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Polipolina ateva taumattu, nau eteva sesa paua ngetapaa tuvui eteva emaemae tani nama sipsipi etoa, aue eilou vuli sipsipi etoa, poli karika va tau ngai toi sipsipi ia, me karika va kiena tuungi ila. Me paua ateva aue ghele namaila me ghele ameti reerekatainila. ");
INSERT INTO emi_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ia o taumattu ngateva eiilou vuli sipsipi etoa poli enim uungu tani ghaa viliki veu, me karika nannaane tani aitaraa sipsipi. ");
INSERT INTO emi_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Aghi masi aitoi sipsipi ieghi. Akilakila kieghi sipsipi, me ila la kilakilaieghi, ");
INSERT INTO emi_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","nongina Tamaghi ekilakilaieghi, me aghi akilakila Tamaghi, me atautau maamauluaaghi tani sausi kieghi sipsipi etoa. ");
INSERT INTO emi_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mene katoa tana kieghi sipsipi, karika ila elome tale ia oia valavala ateae. Aue atani ghaaila, me la mae kupi sso, me ila tee aue la nongo lingi ngaloghu eteva, me aue ekateva nonga ila, me ekateva nonga tau ngai toiira. ");
INSERT INTO emi_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tamaghi eailousieinaghi, poli aue atau velu maamauluaaghi, me auena amene ghaa. ");
INSERT INTO emi_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Karika teva erooroo tani ghaa velu maamauluaaghi. Aghi atautau velu maamauluaaghi, me aghi nonga matuutuliena aghi tani tau velu maamauluaaghi me matuutuliena aghi tani mene ghaa. Tamaghi ghe auliaa tau mae isaa oia inangari va aghelei.” ");
INSERT INTO emi_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Isaa o inangarina ghe gheleila me aJiu etoa ghe ghalueilala. ");
INSERT INTO emi_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Oroi ila taumattu ngatoa laghe ue va, “Raroai eteva etokatoka etana, me veeveena ia. Vaalua me am anna tani nongo inangarina?” ");
INSERT INTO emi_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Me katoa laghe ue va, “Lo ateva raroai eteva etokatoka etana karika erooroo tani auliaa isaa o voto. Raroai eteva karika erooroo tani oti mataira salusaluna atoa.” ");
INSERT INTO emi_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nau eteva tani nnaa lao nau laghe tau saela ale manga ateva ghe rekatala. Ia o nivelu eitaua ngateae ghe lutulutu tale nau kkaili eJerusalem, ");
INSERT INTO emi_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","me Iesu eleka tale ale manga ateva ghe kasukasu tale varanda ngateva laghe asease Solomon etana. ");
INSERT INTO emi_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Me aJiu etoa laghe mae sio tani tingina talieinia me ngila ghe ue etana va, “Lovisaa uauliaa kiemami? Ange matemate toitoiaaimami. Arova io Mesaea ngateva, uaulia ngamasina etaimami.” ");
INSERT INTO emi_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Iesu ghe liula me ghe uela etaira va, “Aghaauliaa etaimim, me karika am aaiesoaa. Niuungu aghe gheelei tale ararina ateae Tamaghi eaauliaa va aghi see ieghi. ");
INSERT INTO emi_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Am tam aaiesoaa poli karika va kieghi sipsipi iem. ");
INSERT INTO emi_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kieghi etoa sipsipi la nongonongo kila lingi ngaloghu eteva. Akilakilaila me la ghaaimuli teeieghi. ");
INSERT INTO emi_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Atautaula maulue ateva etokatoka nau ekapa atoa, me karika aue la mate. Karika teva erooroo tani ghaa vella ta nimaghi. ");
INSERT INTO emi_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tamaghi, ghe taula mae sio etaghi, enaanamuu vulu isaa akapaaili taumattu, me karika teva erooroo tani ghaa vella ta nimane Tamaghi. ");
INSERT INTO emi_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Aghi me Tamaghi kateva nonga iengalua.” ");
INSERT INTO emi_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Me aJiu etoa ngila ghe mene reirei atu tani kumua. ");
INSERT INTO emi_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Me Iesu ghe uela etaira va, “Aghe apasungala oroiannaaili masi niuungu kanna Tamaghi. Am anna tani kumueghi tale mausi sa ateva tale isaa o niuungu?” ");
INSERT INTO emi_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","AJiu etoa laghe liula me laghe uela va, “Karika ami anna tani kumuo poli isaa o voto, ta poli uaauliaa saasakiaa tee God, poli nim taumattu io, me uue va io God.” ");
INSERT INTO emi_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Me Iesu ghe liula me ghe uela etaira va, “Karika am ghe ritila tale uneimim inangari nipaopao, eue va, ‘Aghe uela va am goto iem’? ");
INSERT INTO emi_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Emua arau God ghe ppooaala inangarina ta taumattu ngatoa me ghe uela va goto ila. Inangarina God tale Uru ngai Manga ateva karika eaikolikoliaa. ");
INSERT INTO emi_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Me aghi, Tamaghi ghe amangaieghila me ghe sungieghila tani sio tale kosa ateva oia. Liuna avalua o me aue va Natuna ieghi God. Vaalua me am ue va aghaauliaa saasakiaa ta God? ");
INSERT INTO emi_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Am rau mene aiesoaa etaghi arova atam gheelei uunguaane Tamaghi. ");
INSERT INTO emi_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Arova am tam aiesoaa etaghi, am aiesoaa tale niuungu agheelei, poli agheelei uunguaane Tamaghi, me aue am kila va Tamaghi etaghi me aghi ta Tamaghi.” ");
INSERT INTO emi_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Laghe mene anna tani kuneia, me karika laghe roola. ");
INSERT INTO emi_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Me Iesu ghe mene oghi lao sio, me ghe lau longotila eJodan, me ghe lao sio tale voto ateva Jon ghe aasuu taumattu etana, me ghe tokala tale ia o voto ateva. ");
INSERT INTO emi_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Me oroieili taumattu ghe mae sio etana. Laghe ue va, “Koronna va Jon ghe tam gheleila teva niaimatoonga, me voto ghe auliaala tale ia oia taumattu ngateva koronna akapa.” ");
INSERT INTO emi_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tale ia o voto ateva oroi taumattu ghe aiesoaala ta Iesu. ");
INSERT INTO emi_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kateva taumattu, Lasarus etana, ghe iisiki. Ghe tokatoka eBetani, tanganueirarua Meri me tuena ta Mata. ");
INSERT INTO emi_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Meri ia o vause ateva ghe kaola voto masi ngusungusuaane ta kkena Vau eteva, me ghe ulula tale uu nguruna, ia o Meri kapuna taita ateva oia ta Lasarus ghe iisiki. ");
INSERT INTO emi_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Liuna avalua o me kapuna vause alua lalu ghe suula inangari ta Iesu tani auliaa kiena va, “Vau eteva, unongo, masi kapum ateva eiisiki.” ");
INSERT INTO emi_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nau eteva Iesu ghe nongola, ghe uela va, “Ia okae isiki eteva karika aue eruu tale nimate. Enim lutula tani apasunga sarasarakaniaane God, me la tau tee sae ararina ateae Natuna ateva God.” ");
INSERT INTO emi_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesu ghe aielousiangaili Mata me nengane ta Meri me Lasarus. ");
INSERT INTO emi_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Liuna avalua o, nau eteva Iesu ghe ghaala inangari va Lasarus eiisiki, ghe mene tokala ghalue nau nongina ghe tokatoka arau. ");
INSERT INTO emi_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Vara me ghe uela ta kapuna disaepolo atoa va, “Ita kasu me ita mene sae eJiudia.” ");
INSERT INTO emi_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Me kapuna disaepolo atoa laghe uela etana va, “Tisa, vaalua me umene anna tani sae eJiudia, aJiu etoa okae ghalavoo nonga laghe anna tani kumu emateo tale atu?” ");
INSERT INTO emi_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iesu ghe uela etaira va, “Karika am kilakila va kasangaulu ghalua (12) aoa ta kateva nau? Arova lo ateva ekasu ellaa, karika aue etaghueinia, poli etaatara tale mallanga ateva tale kosa ateva. ");
INSERT INTO emi_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Me arova lo ateva taumattu ekasu eleivoo, aue etaghueinia, poli karika etaatara teva mallanga.” ");
INSERT INTO emi_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Vara ghe ruula tani auliaa llo me ghe mene uela etaira va, “Kapuita ateva ta Lasarus enim sio aseasekanua, me anga laa siosio oia tani angunia.” ");
INSERT INTO emi_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Me disaepolo atoa laghe uela etana va, “Vau eteva, arova enim sio aseasekanua, aue emasina.” ");
INSERT INTO emi_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iesu ghe aauliaa va ang ghe matela, me ila laghe annaa va ghe aauliaa niasekanue ateae ta ghainoana etana. ");
INSERT INTO emi_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Me Iesu ghe vira mene aulia ngamasinala va, “Lasarus ang ghe matela. ");
INSERT INTO emi_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nau eteva aghannainam anim masimasi va karika aghe toka teeiela, poli isaa o voto aue egheleiem am aiesoaa. Ita kasu, me ita sio taraia.” ");
INSERT INTO emi_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Vara me Tomasi, kateae ararina laghe kolokoloa va Palue ia, ghe uela ta disaepolo akapa atoa va, “Elauo! Ita akapa ita usia, me ita laa mate teeia.” ");
INSERT INTO emi_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nau eteva Iesu ghe laa rekata sio eBetani, ghe nongola va ang ghe asola ghaata nau tale lienga niaikkaia. ");
INSERT INTO emi_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani kalakalangina ia eJerusalem, maamasauaane erooroo nim kotolu nonga kilomita. ");
INSERT INTO emi_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Oroi aJiu etoa laghe mae sio tani aippooaa me toka tee Mata me Meri tani aale amate, poli kapuirarua taita ateva ghe matela. ");
INSERT INTO emi_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nau eteva Mata ghe nongola va Iesu ang ghe rekatala, ghe lao sio tani soua, me Meri ghe tokala elo ale. ");
INSERT INTO emi_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Me Mata ghe uela ta Iesu va, “Vau eteva, arova ughe tokatoka oia, kapughu taita ateva karika aue ghe mate. ");
INSERT INTO emi_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Me ia oia akilakila va arova ughele kolomi righi voto ta God, aue ghele tau aatu.” ");
INSERT INTO emi_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Iesu ghe uela etana va, “Kapum taita ateva aue emene sakesake.” ");
INSERT INTO emi_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata ghe uela etana va, “Akilakila va aue etotu tale nau taumattu ngatoa aue la totu tale liu, tale airuuruu tale nau.” ");
INSERT INTO emi_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iesu ghe uela etana va, “Aghi atottotu taumattu matena, me atautau lao maulue. Lo ateva eaiesoaa etaghi, arova emate, aue emene sakesake. ");
INSERT INTO emi_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Lo ateva etokatoka me maulue ia, arova eaikaaiaa etaghi, karika aue emate. Uaaiesoaa tale isaa oia inangari?” ");
INSERT INTO emi_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mata ghe uela ta Iesu va, “Ue, Vau eteva. Aghaaiesoaa va io Natuna io God, me io Mesaea io, ia o laghe uela va aue emae.” ");
INSERT INTO emi_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata ghe ruula tani ppooaa isaa o inangari me ghe lao sio tani tara Meri, me ghe aulia ngainaola etana va, “Tisa ange rekatala, me eanna tani taraio.” ");
INSERT INTO emi_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nau eteva Meri ghe nongola, arovaeaata ta ghe tinginala, me ghe lao sio tani tara Iesu. ");
INSERT INTO emi_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Iesu karika ie ghe mae rekata. Ghe aaitoka see tale voto ateva Mata ghe lao sio tani soua etana. ");
INSERT INTO emi_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","AJiu etoa laghe tokatoka tee Meri elo ale tani alousiusi eitauaa teeia. Vara me laghe taraiela ta ghe tinginala, me ghe ailuiluila tani kupi ghoa. Laghe usiela, poli laghe annaa va ang ghe laolao tani ngala nongina laghe alokoila taumattu ngateva matena ia. ");
INSERT INTO emi_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nau eteva Meri ghe laa rekata sio nongina Iesu ghe tiitingina, ghe taraiela, me ghe suuiaala ta liue kkena, me ghe uela va, “Vau eteva, arova ughe tokatoka oia, kapughu taita ateva karika aue ghe mate.” ");
INSERT INTO emi_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Iesu ghe tarala Meri me aJiu etoa laghe ngangngala me ghe sessaiela, me ie tee ang ghe anna tani ngala. ");
INSERT INTO emi_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Me ghe uela va, “Eaa am ghe alokoiela?” Me laghe uela etana va, “Vau eteva, mae sio me ulaa tara.” ");
INSERT INTO emi_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Me Iesu ghe ngalala. ");
INSERT INTO emi_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","AJiu etoa laghe ue va, “Am tarala, Iesu eailousiangaili Lasarus.” ");
INSERT INTO emi_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Me katoa laghe ue va, “Ghe ghelei emasinala mata salusaluna ateva, me vaalua me karika ghe roola va ghe sausi Lasarus va karika ghe mene mate?” ");
INSERT INTO emi_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Iesu ghe mene sessaiela nau eteva ghe kasukasu elaolao nongina laghe alokoila Lasarus. Tale voto ateva liengani niaikkaia ia me laghe atoka rungaala atu eteva etana. ");
INSERT INTO emi_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iesu ghe uela va, “Am ghaa vella atu eteva.” Me Mata, kapuna vause ia tau raua, ghe uela va, “Vau eteva, aiaaghaatane ateva oia nau ang ghe asola tale liu. Nei mauuna ateva ang ghe tiuaala.” ");
INSERT INTO emi_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Me Iesu ghe uela etana va, “Auela va saa etam? Auela va arova uaaiesoaa, ghaine utara sarasarakaniaane God.” ");
INSERT INTO emi_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Vara me laghe ghaa vella atu eteva. Me Iesu ghe taatara saela epona me ghe uela va, “Tamaghi, akaakaili emasinaaili ta ughe nongola kalughu nikokkolomi. ");
INSERT INTO emi_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Me akilakila va nau ekapa atoa unongonongoaghi, me poli mausi taumattu toko la tiitingina, liuna avalua o me ngamene aauliaa isaa oia inangari me aue la ghaiesoaa va io ughe sungieghila tani sio.” ");
INSERT INTO emi_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nau eteva ghe ruula tani auliaa llo, me ghe kolokolo anamungailiila me ghe uela va, “Lasarus, kupi ghoa mae!” ");
INSERT INTO emi_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Me ia o taumattu ngateva ghe matela ghe kupi ghoa mae. Nimane me kkena sumsum tale kalio la sumsumaa matena atoa, me matane sumsum tale mene tuku kateva kalio. Iesu ghe uela va, “Am pulaka vella tapiri kalio, me am tau velua me ekasu.” ");
INSERT INTO emi_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Oroi ila aJiu etoa laghe mae sio tani alousiusi tee Meri, laghe tarala ia o voto ateva Iesu ghe gheleiela, me laghe aiesoaala etana. ");
INSERT INTO emi_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Me katoa etaira laghe lao sio tani tara Paresi etoa tani auliaa etaira sa ateva Iesu ghe gheleiela. ");
INSERT INTO emi_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Namu ngatoa ta pristi me Paresi etoa laghe lao sio tani kolo kansolo atoa. Me laghe velu eitauaala me laghe uela va, “Sa ateva ita gheleia, poli taumattu ngateva oia ange gheelei oroi niaimatoonga? ");
INSERT INTO emi_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Arova ita tau velua, me ita tam ghelei rungainia, taumattu ngakapa atoa aue la ghaikaaiaa etana, me aue aRom atoa la mae, me la uvi tuuturungita, me la ghaa velu ale manga ateva.” ");
INSERT INTO emi_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kateva taumattu elome etaira, ararina ateae ta Kaeapas, ia namuu ia ta pristi etoa tale ia o ninamanama ateae, ghe uela va, “Am oia, karika am kilakila righi voto! ");
INSERT INTO emi_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Am tee, karika am kilakila va emaamasina arova kateva nonga taumattu ghele mate tani ghaa liuira akapa taumattu ngatoa, me karika masina arova taumattu ngakapa ghele mate.” ");
INSERT INTO emi_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Karika Kaeapas ghe nim aauliaa isaa o inangari tale aloannaane, poli ia namuu ia ta pristi etoa tale ia o ninamanama ateae, me ghe aulia ngamuemua alokoila inangari o va Iesu aue emate tani sausi taumattu ngakapa atoa. ");
INSERT INTO emi_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Karika va aue emate ta aJiu nonga atoa, ta mene katoa tani natuna God la tokatoka see, aue egheleila la velu eitauaa me ekateva nonga ila. ");
INSERT INTO emi_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ghe tiuaala tale ia o nau eteva, namu ngatoa laghe tiuaala tani aippooaa tee salana vaalua tani uvi ematea. ");
INSERT INTO emi_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Poli isaa o voto me Iesu ghe ruula tani kasu ta mata ngoroi etoa elome ta aJiu etoa. Ghe ssola tani toka tau tale masaliki eteae eEpraim, kalakalangina tale voto ateva karika righi taumattu ta ngetana, ia me kapuna disaepolo atoa. ");
INSERT INTO emi_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pasova ngateva ang ghe aakalakalaa. Oroieili taumattu nge Jiu etoa la tokatoka amasau eJerusalem laghe tiuaala tani rekata eJerusalem tani ghelei eraarangisanaila me auena Pasova ngateva ghe tiuaa. ");
INSERT INTO emi_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Laghe paepae Iesu me laghe ssola kona ale manga ateva, me laghe tiuaala tani aikolomieinila. Laghe ue va, “Am annaa va aue emae tale ia oia nivelu eitaua ngateae?” ");
INSERT INTO emi_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Namuu ta pristi etoa me Paresi etoa laghe uela ta taumattu ngatoa va, arova lo ateva etara Iesu, elaa ghaulienia etaira. Ia o salana atikirighi laghe annaa va aue la kune Iesu ta ngetana. ");
INSERT INTO emi_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Kasi ghaonomo (6) nau ghe tokatoka me ghe laa ghaa nau Pasova, Iesu ghe mene siola eBetani, tanganue Lasarus, ia o Iesu ghe totuela tale nimate. ");
INSERT INTO emi_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Laghe gheleila ninamanama ateae tani amasimasi Iesu. Mata ghe aaikoita see inana, me Lasarus ghe tokatoka tee taumattu ngatoa laghe mae sio tani namanama tee Iesu. ");
INSERT INTO emi_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Meri ghe ghaala botolo ateva ghe kaakaai voto masi ngusungusuaane laghe gheleiela nonga tale oane natu ai erighi la aseasea va nadi ia me aipolina namungaili, me ghe kaoala ta kkena Iesu, me ghe uluulu kekena tale uu nguruna, me masi neina ateva ghe rooaala ale ateva tani aaoo. ");
INSERT INTO emi_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Me kateva kapuna disaepolo, Jiudas Iskariot etana, ia aue etau lao Iesu ta tau ngai ssateena atoa, ghe uela va, ");
INSERT INTO emi_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Vaalua me karika am rooroo tani tauela va la poli ia okae voto ateva masi ngusungusuaane ta kotolu ai (300) silva koen, me am ghele taula ta lo atoa karika righi peiira?” ");
INSERT INTO emi_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Jiudas ghe aauliaa isaa o inangari karika va poli ghe annaa llo taumattu karika righi peiira, ghe auliaa poli ia tau niainao ia, me ia ghe posoposo aikaai viliki veu eteva, me kasina nau ghe aainao etana. ");
INSERT INTO emi_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Iesu ghe liula me ghe uela etana va, “Tau veluela, poli eaatoka ia oia voto ateva masi neina, me aue elaa ghaa nau eteva aue amate, me la laa kaieinaghi. ");
INSERT INTO emi_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Lo atoa karika righi peiira, la tokatoka teeiem nau ekapa atoa, me aghi, karika aue atoka teeiem nau ekapa atoa.” ");
INSERT INTO emi_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Oroieili aJiu etoa laghe kilala va Iesu eBetani. Liuna avalua o me laghe lao sio karika mausi Iesu nonga va laghe lao sio. Laghe lao tee sio poli laghe aloanna tani tara tee Lasarus, ia o Iesu ghe totuela tale nimate. ");
INSERT INTO emi_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Liuna avalua o me namuu ta pristi etoa laghe aailoe va la uvi emate tee Lasarus, ");
INSERT INTO emi_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ta mausi Lasarus me oroieili aJiu etoa ngeila ghe liuliu viliira ta pristi etoa, me ngeila ghe aaikaaiaa ta Iesu. ");
INSERT INTO emi_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Vara mene kateva nau, me oroieili taumattu laghe saela eJerusalem tale Pasova ngateva, me laghe nongo teela va Iesu aue emae tee tale ia o nivelu eitaua ngateae. ");
INSERT INTO emi_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Liuna avalua o me laghe ghaala uru ootou, me laghe lao sio tani sou Iesu tapaa salana. Laghe aaore me laghe ue va, “Ita tau sae ararina ateae God! God aue eghelei masi voto ta ia oia taumattu ngateva ghe mae sio tale ararina ateae! Ia kingi ia ta aIsraeli etoa!” ");
INSERT INTO emi_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iesu ghe ghaala donki eteva, me ghe laa sae toka etana, nongina inangari laghe pitila tale Uru ngai Manga ateva va, ");
INSERT INTO emi_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Natuna aliki vause ateva Saeon, urau mene matautu. Am tara kapuimim kingi eteva emaemae eiilou tale natu donki eteva.” ");
INSERT INTO emi_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Isaa o nau kapuna disaepolo atoa karika laghe kilakila malloeana isaa o voto, me nau eteva God ghe vira mene tau saela ararina ateae Iesu, me laghe vira mene nnaala voto Uru ngai Manga ateva ghe auliaala, me vaalua me taumattu ngatoa laghe gheleila isaa o voto ta ngetana. ");
INSERT INTO emi_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lo atoa taumattu laghe tarala Iesu ghe kolola Lasarus tani kupi ghoa tale lienga niaikkaia ngateae, laghe aauliaa isaa o voto laghe tarala. ");
INSERT INTO emi_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Taumattu ngatoa laghe nongola ia o niaimatoongana ngateva ghe gheleiela, liuna avalua o me laghe ghoala tani soua tapaa salana. ");
INSERT INTO emi_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Paresi etoa laghe tarala isaa o voto me laghe ue va, “Tarala! Llo ita anna tani ghelei karika ita rooroo, poli taumattu ngakapa tale kosa ateva ngila usiusia.” ");
INSERT INTO emi_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Katoa taumattu nge Grik laghe sae teela eJerusalem tani kkaua ta nau nivelu eitaua ngateae. ");
INSERT INTO emi_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Laghe lao sio tani tara Pilip aBetsaida ia eGalilii, me laghe kolomiela va, “Namu ngateva, ami aloanna tani sama tee Iesu.” ");
INSERT INTO emi_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilip ghe lao sio tani auliaa ta Andru, me lalu ghe lao sio tani tara Iesu, me lalu ghe auliaala etana. ");
INSERT INTO emi_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iesu ghe liula me ghe uela va, “Ange ghaala nauna God tani tau sae ararina ateae Natuna ateva Taumattu ngateva. ");
INSERT INTO emi_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Aghaaulia ngakoronna etaimim va, arova la tam pasa katu uiti eteva tale kosa ateva va emate, aue nim kateva nonga aue etoka. Me arova emate, aue eapinosa oroiannaaili uit. ");
INSERT INTO emi_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Lo ateva eaaielousiaa maamauluaane, aue eraua. Me lo ateva etam aloanna maamauluaane tale kosa ateva oia, egheelei tani ghaa maulue ateva etokatoka liu ia. ");
INSERT INTO emi_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Lo ateva taumattu esaasausieghi, eaaimuli teeieghi me voto ateva atokatoka etana, ie tee aue etoka aitauaa teeieghi etana. Lo ateva taumattu esaasausieghi, Tamaghi etautau sae ararina ateae. ");
INSERT INTO emi_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ia oia voto maateaili ange lutulutu tale maamauluaaghi, me nganannangaili, me karika akilakila sa ateva atani aulieinia. Koti aue va, ‘Tamaghi, ughaa velu isaa o llo voto maamaatana.’ Karika! Ta poli isaa o voto maamaatana me aghe sio mae va elutu etaghi. ");
INSERT INTO emi_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tamaghi, utau sae ararim ateae!” Vara Iesu ghe aauliaa isaa o inangari me lingi ngalo ateva ghe kasula epona liu ghe uela va, “Ngaghe tau saela ararighi eteae me aue amene ghelei.” ");
INSERT INTO emi_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Taumattu ghe tiitingina teeia laghe nongola, me katoa laghe uela va palapalanga ateva, me katoa laghe ue va, “Ensolo ateva ghe sama teeiela.” ");
INSERT INTO emi_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Me Iesu ghe uela etaira va, “Ia o lingi ngalo ateva eppooaala inangari tani sausiem, karika va esaasausieghi. ");
INSERT INTO emi_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Taumattu tale kosa ateva oia, God ange tiitiuaa tani ghelei niaisakei ta ngetaira. Me vau tapaa kosa ateva oia, God aue esau velue sio. ");
INSERT INTO emi_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Me aghi, nau la ghavukalaieghi sae tale kosa ateva oia, aue aghelei taumattu ngakapa atoa la mae etaghi.” ");
INSERT INTO emi_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iesu ghe aauliaala inangari o tani auliaa vaalua aue emate. ");
INSERT INTO emi_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Me taumattu ngatoa laghe uela ta Iesu va, “Inangari nipaopao eue va Mesaea ngateva aue etoka nau ekapa atoa. Vaalua me uue va aue la avukala sae Natuna ateva Taumattu ngateva? See ia Natuna ateva Taumattu ngateva?” ");
INSERT INTO emi_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Iesu ghe liula me ghe uela va, “Nauna mallanga ateva tani toka teeiem karika aluse. Liuna avalua o me nau etokatoka teeiem am kasu teeia, poli saurrom ateva erau akouem. Poli lo ateva ekasukasu tale saurrom etam kilakila va eaa elaolao. ");
INSERT INTO emi_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Am aikaaiaa tale mallanga ateva nau etokatoka teeiem, me aue natuna am mallanga ateva.” Nau eteva Iesu ghe ruula tani ppooaa isaa o inangari, ghe kasu vulilala me ghe lao sio tani aisulia. ");
INSERT INTO emi_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ghe gheleila oroiannaaili niaimatoonga elome ta mata ngoroi etoa, me karika laghe aikaaiaa ta ngetana. ");
INSERT INTO emi_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Isaa o voto ghe lutula tani ghelei ekoronna inangarina Aisaea propete ia ghe uela va, “Vau eteva, karika teva ghe aikaaiaa inangariimami, me karika teva ang ghe tarala sarasarakaniaam.” ");
INSERT INTO emi_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Taumattu ngatoa karika la rooroo tani aiesoaa ta Iesu, nongina Aisaea ghe mene uela va, ");
INSERT INTO emi_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Vau ngepona ateva ghe ghelei emata salusaluna ilala me urunguitaniira korokoronganaaili poli la rau taatara ta mataira me la kila tale urunguitaniira me la mae etaghi me agheleila va la mene masina.” ");
INSERT INTO emi_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaea ghe tarala sarasarakaniaane Iesu, liuna avalua o me ghe auliaala isaa o voto ta ngetana. ");
INSERT INTO emi_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Me oroi ila kapuira namu ngatoa laghe aikaaiaala ta Iesu, me karika laghe aaotu, poli Paresi etoa laghe uela va lo ateva eaikaaiaa ta Iesu, aue la tiu velua tale ale nivelu eitaua ngateva, ");
INSERT INTO emi_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","poli laghe annaaili va taumattu earueinila, me karika va God. ");
INSERT INTO emi_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Iesu ghe sama anamungailiila me ghe uela va, “Lo ateva eaaikaaiaa etaghi, eaikaaiaa tee ta lo ateva ghe sungieghila. ");
INSERT INTO emi_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Me lo ateva etaraieghi, etaatara tee lo ateva ghe sungieghila. ");
INSERT INTO emi_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Aghi aghe mae sio tale kosa ateva oia arova mallanga ateva va lo ateva eaaiesoaa etaghi, karika aue etoka tale saurrom. ");
INSERT INTO emi_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Arova lo ateva enongo inangarighi me etam aimuli tee, karika aue agheleia va eaisakei, poli karika aghe mae sio tani ghelei niaisakei tale taumattu tale kosa ateva oia, ta aghe mae sio tani asaangila. ");
INSERT INTO emi_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Lo ateva etam annaieghi, me erati inangarighi, aue isaa o inangari aue egheleia eaisakei nau airuuruu tale kosa ateva. ");
INSERT INTO emi_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Karika aghaauliaa righi voto tale nim nannaaghi. Tamaghi ghe sungieghila ghe auliaala sa ateva tani aulieinia me vaalua tani auliaa. ");
INSERT INTO emi_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Akilakila va llo ghe auliaala aue etau mae maulue ateva tokatoka liu ia. Liuna avalua o me atani auliaa voto Tamaghi ghe auliaa tau mae sio.” ");
INSERT INTO emi_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nau Pasova ngateva karika ghe mae, me Iesu ang ghe kilala va nauna ange aakalakalaa tani kasu vuli kosa ateva, me emene sae ta Tamane. Ghe aielousiangaili kapuna atoa tale kosa ateva oia. Aielousiaane etaira ghe laa ghaa sio nau ghe mate vululala. ");
INSERT INTO emi_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nau laghe namanama ta pai ngelo alai, Satana ang ghe atoka ssola ninanna ngateva ta Jiudas, natuna ia Saemon Iskariot, tani laoaa Iesu ta tau ngai ssateena atoa. ");
INSERT INTO emi_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesu ghe kilakila va God ghe tau ekapala voto ta nimane, me ia ghe kasula ta God, me aue emene sae ta God. ");
INSERT INTO emi_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Liuna avalua o me Iesu ghe tingina saela nongina laghe namanama, me ghe ghaa vella unna aiaasae ngeleka ateva, me ghe ainavitaala taolo ateva. ");
INSERT INTO emi_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ghe kao kaaila manu tale aikaai manu etivilau, me ghe tiuaala tani pora kkeira disaepolo atoa, me ghe uluulu tale taolo ateva ghe aainavitainia etana. ");
INSERT INTO emi_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ghe rekatala ta Saemon Pita, me Pita ghe uela etana va, “Vau eteva, uaanna tani pora kkeghi?” ");
INSERT INTO emi_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Me Iesu ghe liula me ghe uela etana va, “Voto agheelei, karika aue ukila ghaine, auena uvira mene kila.” ");
INSERT INTO emi_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Me Pita ghe uela etana va, “Karikaaili umene pora kkeghi!” Me Iesu ghe uela va, “Arova atam pora kkem, karika urooroo tani toka teeieghi.” ");
INSERT INTO emi_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saemon Pita ghe uela etana va, “Vau eteva, karika umene pora nonga kkeghi ta upora tee nimaghi me urughu eteva!” ");
INSERT INTO emi_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Me Iesu ghe uela va, “Lo ateva ang ghe suusuula karika erooroo tani mene suusuu, ta enim pora nonga kkena, me aue eraarangisana. Am raarangisana am, karika va am akapa.” ");
INSERT INTO emi_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Poli Iesu ghe kilakila va see aue etaue lao ta tau ngai ssateena atoa, liuna avalua o me ghe uela va, “Karika va am akapa raarangisana am.” ");
INSERT INTO emi_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nau eteva ghe ruula tani pora kkeira, me ghe mene asaela unna aiaasae ngeleka ateva, me ghe toka siola nongina aillai inana ateva, me ghe uela etaira va, “Ngam tara kilala voto ngagheleila? ");
INSERT INTO emi_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Am ue etaghi va kapuimim tisa ieghi me Vauimmi ieghi. Isaa o voto am asease etaghi masinaaili, ta koronna. ");
INSERT INTO emi_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Arova aghi, vauimmi ieghi me tisa ieghi, me ngaporala kkeimim, am tee am pora kkeira mene katoa etaimim. ");
INSERT INTO emi_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ngaghaapasunga tau aatu voto am ghelei, am ghelei nongina ngagheleila. ");
INSERT INTO emi_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Aghaaulia ngakoronna etaimim va tau ngai nongonongo anna ateva karika namuu ia ta vauna ateva, me tau ngai kasuaa inangari eteva karika tee enaanamuu ta lo ateva esungisungia. ");
INSERT INTO emi_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Arova am kila isaa o voto me am ghelei, aue emasinaaili etaimim. ");
INSERT INTO emi_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Karika va aghaauliaa inangari oia etaimim akapa, ta poli akilakila lo atoa aghe suitoongainiemla, me llo Uru ngai Manga ateva ghe auliaala aue ekoronna. Ghe uela va, ‘Lo ateva enamanama teeieghi aue essa teeieghi.’ ");
INSERT INTO emi_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Aghaaulia ngamuemue aalokoi llo oia, me nau aue elutu aue am aiesoaa etaghi va aghi ia o taumattu ngateva. ");
INSERT INTO emi_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Aghaaulia ngakoronna etaimim va lo ateva eghaaghaa lo ateva aghe sungiela, eghaaghaaieghi, me lo ateva eghaaghaaieghi, eghaaghaa lo ateva ghe sungieghila.” ");
INSERT INTO emi_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nau eteva Iesu ghe ruula tani auliaa isaa o inangari, nannaane ghe maatela me ghe siuailila euu, me ghe uela va, “Aghaaulia ngakoronna etaimim va kateva etaimim aue etaueghi lao ta nimaira tau ngai ssateeghi etoa.” ");
INSERT INTO emi_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Aloira disaepolo atoa ghe kaakapa va ghe auliaa tee see, liuna avalua o me laghe aitara atokala. ");
INSERT INTO emi_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Me lo ateva disaepolo Iesu ghe ailousiangailiia ghe tokatoka akalakalanginaaili ta Iesu. ");
INSERT INTO emi_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saemon Pita ghe matamatai elao va ghe kolomi Iesu va see aue ghe ghelei isaa o voto ghe aauliaa. ");
INSERT INTO emi_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ia o disaepolo ateva ghe valaa lao sio ta Iesu me ghe kolomiela va, “Vau eteva, see aue eghelei isaa o voto?” ");
INSERT INTO emi_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Iesu ghe liula me ghe uela va, “Lo ateva aue aghasuu verete me ataula etana.” Me ghe asuula verete me ghe taula ta Jiudas, natuna ia Saemon Iskariot. ");
INSERT INTO emi_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jiudas ghe ghaala isaa o inana me Satana ghe valaiela. Me Iesu ghe uela etana va, “Voto uanna tani ghelei, ughelei parasi.” ");
INSERT INTO emi_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Lo atoa laghe tokatoka tale ia o ninamanama ateae laghe tam kilala malloeanina inangari Iesu ghe aauliaa etana. ");
INSERT INTO emi_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Katoa laghe annaa va poli Jiudas ghe posoposo uneira viliki veu, o Iesu ghe sungisungia tani laa poli righi voto eaimonomonosiaa tale nivelu eitaua ngateva, o tani laa tau righi voto ta lo atoa karika peiira. ");
INSERT INTO emi_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Jiudas ghe ghaala tuku verete ateva me ghe kupi ghoala. Ang ghe voola. ");
INSERT INTO emi_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Vara Jiudas ghe kasula me Iesu ghe uela va, “Ia oia Natuna ateva Taumattu ngateva ararina ateae ange saela epona, me God tee ararina ateae ange saela epona tale Natuna ateva Taumattu ngateva. ");
INSERT INTO emi_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Arova ararina ateae God esae epona tale Natuna ateva Taumattu ngateva, God nonga aue emene asaesae ararina ateae Natuna ateva Taumattu ngateva, me isaa o voto aue eghelei parasi. ");
INSERT INTO emi_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Kapughu aliki etoa! Karika oroi nau aue atoka teeiem, me ghaisa ngarighi am tiuaa tani paeaghi. Aghaauliaa llo nongina aghe aauliaa ta aJiu etoa, ‘Karika am rooroo tani lao nongina ngalaolao.’ ");
INSERT INTO emi_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Ngatautau aatu ouna inangari niloeloe: elome etaimim am aielousi. Nongina aghi aghe aielousieiniemla, elome etaimim am tani aielousi. ");
INSERT INTO emi_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Arova elome etaimim va am aielousi, ila akapa aue la kila va am kapughu disaepolo iem.” ");
INSERT INTO emi_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saemon Pita ghe kolomila Iesu va, “Vau eteva, eaa aue ulao?” Iesu ghe liula me ghe uela va, “Karika urooroo tani lao nongina ngalaolao tale isaa oia nau. Auena aue uaimuli.” ");
INSERT INTO emi_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita ghe liula me ghe uela va, “Vau eteva, vaalua me karika arooroo tani usio tale isaa oia nau? Aghi aue amate ta polim.” ");
INSERT INTO emi_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Iesu ghe kolomiela va, “Uannaa va aue umate ta mausighi? Aghaaulia ngakoronna etam va aue uaulia ngakasina kotoluaata va karika ukilakilaieghi, me auena taita ateva paolo eaangari. ");
INSERT INTO emi_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Am rau mene alousiusi. Am aiesoaa ta God, me am aiesoaa tee etaghi. ");
INSERT INTO emi_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tanganuena Tamaghi oroiannaaili voto tani toka etana, me ngalaolao tani aimonomonosiaa isaa o voto aue kaluimim. Karika aue aghele auliaa arova isaa o voto kamena. ");
INSERT INTO emi_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Poli ngalaolao tani aimonomonosiaa tanganueimim, me aue amene sio ghaaiem, me am laa toka teeieghi tale voto ateva atokatoka etana. ");
INSERT INTO emi_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ngam ghe kilala salana atikirighi tani lao tale voto ateva ngalaolao etana.” ");
INSERT INTO emi_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Me Tomasi ghe uela etana va, “Vau eteva, karika ami kilakila va eaa aue ulao. Vaalua aue ami kila salana atikirighi?” ");
INSERT INTO emi_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iesu ghe uela etana va, “Aghi salana aghi, koronna ieghi me maulue ieghi. Karika teva aue erooroo tani lao ta Tamaghi ta emae mua etaghi. ");
INSERT INTO emi_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Arova ngam ghe kilaieghila, ngam ghe kilala Tamaghi. Etiitiuaa ghaine ngam kilaiela, me ngam ghe taraiela.” ");
INSERT INTO emi_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilip ghe uela etana va, “Vau eteva, ami anna va uapasunga Tamam etaimami, me aue vira mene masina etaimami.” ");
INSERT INTO emi_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iesu ghe uela etana va, “Ei Pilip! Vaalua me ngaghe toka teeiemla oroi nau, me karika ughe kilaieghi? Lo ateva ang ghe taraieghila, ang ghe tarala Tamaghi. Vaalua me uue va, ‘Uapasunga Tamam etaimami’? ");
INSERT INTO emi_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Karika uaiesoaa va aghi ta Tamaghi, me ia etaghi? Inangari aghaauliaa etaimim karika nim nannaaghi, ta Tamaghi etokatoka etaghi, me ia eghelei isaa o niuungu. ");
INSERT INTO emi_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Am aiesoaa nau eteva aue va aghi ta Tamaghi, me ia etaghi. Arova karika, am annaa niuungu aghe gheleila me aue eakorokorongana uneimim niaikaaiaa. ");
INSERT INTO emi_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Aghaaulia ngakoronna etaimim va lo ateva eaiesoaa etaghi, isaa o niuungu agheelei ie tee aue eghelei me voto aue eghelei aue elau llo oia agheelei, ta poli ngalaa saesae ta Tamaghi. ");
INSERT INTO emi_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Me saa voto am kolomi tale ararighi eteae aue aghelei. Tale ia o salana atikirighi, Natuna aue etau sae ararina ateae Tamane. ");
INSERT INTO emi_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Arova righi voto am kolomi etaghi, tale ararighi eteae, aue aghelei. ");
INSERT INTO emi_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Arova am aielousieinieghi, aue am nongo usilaa inangarighi aue va am ghelei. ");
INSERT INTO emi_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Aue akolomi Tamaghi, me aue etau aatu mene kateva tau ngai sausi aue etoka teeiem nau ekapa atoa, ");
INSERT INTO emi_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Spiriti eteva aue eapasunga voto koronna. Taumattu tale kosa ateva oia karika la rooroo tani ghaaia, poli karika la kilakilaia, me karika laghe taraia. Me am, am kilakilaia, poli etokatoka teeiem, me auena aue etoka elome etaimim. ");
INSERT INTO emi_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Karika aue anim kasu vuliem arova aliki raue vulu etoa; aue amene mae taraiem. ");
INSERT INTO emi_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Karika aue emasau, me taumattu tale kosa ateva oia la ruu tani taraieghi, me am aue am taraieghi. Poli aghi maulue ieghi, am tee aue am maulue. ");
INSERT INTO emi_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Me ia o nau eteva aue am kila va aghi ta Tamaghi, me am etaghi, me aghi etaimim. ");
INSERT INTO emi_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Lo ateva taumattu ekila inangarighi niloeloe me enongo usilaa, eaielousieinaghi. Me Tamaghi eaielousieinia, me aghi tee aue aghaielousieinia, me aue aghapasungainaghi etana.” ");
INSERT INTO emi_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mene kateva Jiudas (karika va Iskariot) ghe uela ta Iesu va, “Vau eteva, vaalua me aue uapasungainio nonga etaimami, me karika va taumattu tale kosa akapa ateva?” ");
INSERT INTO emi_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iesu ghe liula me ghe uela etana va, “Lo ateva taumattu eaielousieinaghi, aue enongo usilaa inangarighi, me Tamaghi aue eaielousieinia, me aue angalu mae etana tani toka aitauaa teeia. ");
INSERT INTO emi_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Lo ateva etam aielousieinaghi, karika aue enongo usilaa inangarighi. Isaa oia inangari am nongonongo karika inangarighi, ta inangarina Tamaghi, ia ghe sungieghila tani sio. ");
INSERT INTO emi_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Isaa oia inangari aghaauliaa nau atokatoka teeiem. ");
INSERT INTO emi_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Me Tau ngai sausi eteva, Spirit Manga ia, aue Tamaghi esungia tani sio tale ararighi eteae, aue eapasunga ngakapa voto etaimim me aue esausiem tani mene nnaa llo voto aghe auliaala etaimim. ");
INSERT INTO emi_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Luei eteva aghalokoia etaimim. Kalughu luei eteva ngatautau aatu etaimim. Lo ateva o luei karika nongina lo ateva luei kosa ateva etautau aatu. Am rau mene alousiusi me am matautu. ");
INSERT INTO emi_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Ngam ghe nongola ngaghe auliaala etaimim va, ‘Aue akasu, me aue amene mae taraiem.’ Arova am ailousieinaghi, aue am ghele masimasi poli aue asae ta Tamaghi, ta poli Tamaghi namuu ia etaghi. ");
INSERT INTO emi_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Auena isaa o voto elutu, me anim aulia ngakasina alokoi kieimim, poli nau isaa o voto elutu, aue am aikaaiaa etaghi. ");
INSERT INTO emi_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Karika aue aghaippooa ngaoroi teeiem, poli vau tapaa kosa ateva ange reerekata. Me karika righi sarasarakaniaane tani ghelei righi voto ta ngetaghi, ");
INSERT INTO emi_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","me aue taumattu tale kosa ateva la kila va aghaielousiaa Tamaghi, poli llo Tamaghi ghe auliaa tau mae sio agheelei. “Am tingina saela me ita kasu.” ");
INSERT INTO emi_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Iesu ghe mene uela va, “Aghi koronna ateae uasa uaeni, me Tamaghi umana paa ngutana atingiu. ");
INSERT INTO emi_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Lo atikirighi tuuna etaghi etam kuukuneaa righi uenenna, esaisai velua, me llo tuuna ekunekune, esaisai velu lutu llo tuuna karika masina, me eraarangisana tani mene kuneaa mene righi uenena. ");
INSERT INTO emi_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Inangari aghe ppooaala etaimim ghe gheleiemla ngam ghe raarangisanala. ");
INSERT INTO emi_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Am toka etaghi me aue atoka etaimim. Laa ngai eteva karika aue righi uenenna arova etam tuutuu tale aina ateva. Nongina am, arova am tam toka etaghi, karika aue am kuneaa righi ue ngai. ");
INSERT INTO emi_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Aghi aina aghi me am laangina iem. Lo ateva etoka etaghi me aghi atoka etana, aue ekuneaa oroi ue ngai. Poli karika urooroo tani ghelei teva voto arova karika ieghi. ");
INSERT INTO emi_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Lo ateva taumattu karika etokatoka etaghi, aue la ghaa velua nongina la ghaaghaa velu laa ngai, me nau ange mmatela, la ghaaghaa me la tautau sae tale kuraa. ");
INSERT INTO emi_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Arova am toka etaghi me inangarighi etoka etaimim, nau am kolomi righi voto, aue am ghaa. ");
INSERT INTO emi_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Arova am kuneaa oroi ue ngai, aue la tau sae ararina ateae Tamaghi, me am aue ekapughu disaepolo iem. ");
INSERT INTO emi_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Nongina Tamaghi ghe aielousieinaghila, aghi tee aghe aielousieinamla. Am toka tale ia o niaielousi eteva kalughu ia. ");
INSERT INTO emi_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Arova am nongo usilaa inangarighi niloeloe, aue am toka tale aielousiaaghi eteva, nongina aghi aghe nongo usilaala inangarina niloeloe Tamaghi, me aghe tokatoka tale aielousiaane ateva. ");
INSERT INTO emi_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Aghannaaili va lo ateva nimasimasi kalughu ia etoka etaimim, me epasu tale maamauluaaimim. Liuna avalua o me aghaauliaa isaa oia inangari etaimim. ");
INSERT INTO emi_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Inangarighi niloeloe isaa avalua toko: am aielousiaa mene kateva elome etaimim nongina aghi aghe aielousieinamla. ");
INSERT INTO emi_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Arova teva taumattu eaielousiangaili kapuna atoa me ghele tau velu maamauluaane tani sausila, ia o lo ateva ase niaielousi, namungaili ia elaulau ekapa mene kasina ase niaielousi. ");
INSERT INTO emi_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Aue kapughu iem arova am ghelei voto aloeloeam etana. ");
INSERT INTO emi_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ia oia karika ngakolokoloam va tau ngai nongonongo anna iem, poli tau ngai nongonongo anna ateva etam kilakila voto vauna ateva eannaa tani ghelei. Ngakolokoloam va kapughu iem poli isaa akapa voto aghe nongola ta Tamaghi ngaghe aulia ngaotula etaimim. ");
INSERT INTO emi_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Karika va am, am ghe suitoongainieghila, ta aghi aghe suitoongainiemla, me aghe tau aatu sio niuungu tani kasu, me am kuneaa oroi llo ue ngai etokatoka liu. Liuna avalua o me nau eteva am kolomi righi voto ta Tamaghi tale ararighi eteae, aue Tamaghi etau aatu. ");
INSERT INTO emi_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Isaa o inangari niloeloe aghaauliaa etaimim: am aielousiaa mene kateva elome etaimim. ");
INSERT INTO emi_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Arova taumattu tale kosa ateva oia la ssa teeiem, am nim annaa va laghe ssa tee akasina teeieghila. ");
INSERT INTO emi_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Arova kosa ateva oia tanganueimim tuungia, aue la ghele masieinam va kapuira iem, me poli ngaghe suitoongainamla tale kosa ateva oia, liuna avalua o me la sessa teeiem. ");
INSERT INTO emi_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Am annaa llo aghe auliaala etaimim va, ‘Tau ngai nongonongo anna ateva karika namuu ia ta vauna ateva.’ Arova laghe gheelei saasakiaa etaghi, aue la ghelei tee etaimim. Arova laghe nongo usilaala inangarighi, aue la ghele nongo usilaa tee inangariimim. ");
INSERT INTO emi_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Aue la ghelei teeiem isaa o voto poli mausi ararighi eteae, ta poli karika la kilakila lo ateva ghe sungieghila tani sio. ");
INSERT INTO emi_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Arova aghe tam sio mae tani auliaa inangari etaira, karika aue la ghele tara kila va gheegheleiaaira sesa, me ia oia karika la rooroo tani ue va la tam kilakila va gheegheleiaaira sesa. ");
INSERT INTO emi_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Lo ateva esessa teeieghi, esessa tee Tamaghi. ");
INSERT INTO emi_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Arova aghe tam toka teeilala me aghe tam gheleila niuungu elome etaira, nongina karika mene teva taumattu ghe gheleila emua arau, karika aue la ghele tara kila va gheegheleiaaira sesa. Me poli laghe tarala, liuna avalua o me la sessa teeiengalua me Tamaghi. ");
INSERT INTO emi_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Isaa oia voto elutulutu tani asokoi inangari laghe pitila tale uneira inangari nipaopao, eue va, ‘Karika esuisui kkai tale teva voto me la nim sessaila etaghi.’ ");
INSERT INTO emi_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nau tau ngai sausi eteva emae, aue eauliaa uunguaaghi etaimim. Aue asungia tani sio etaimim, ia o Spiriti eteva eaapasunga voto koronna, aue ekasu ta Tamaghi. ");
INSERT INTO emi_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Me am tee, aue am aulia ngaotueghi poli am ghe toka teeieghila nau aghe tiuaala uunguaaghi. ");
INSERT INTO emi_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Aghaauliaa isaa o voto etaimim poli am rau mene oghi vulu aikaaiaaimim. ");
INSERT INTO emi_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Aue la tiu veluem tale aleira ale nivelu eitauaa, me aue nau emaemae lo atoa la uvi emateam, aue la ghannaa va la gheelei uunguaane God. ");
INSERT INTO emi_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Isaa o voto aue la ghelei etaimim poli karika la kilakilaiengalua me Tamaghi. ");
INSERT INTO emi_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Aghaauliaa isaa o voto etaimim me nau isaa o voto etiuaa tani lutu, aue am nnaa va ngaghe auliaala kieimim. “Aghe tokatoka teeiem, liuna avalua o me karika aghe aauliaa isaa o voto emua arau. ");
INSERT INTO emi_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Me ia oia ngamene laa saesae ta lo ateva ghe sungieghila tani sio, me karika teva etaimim ekookolomieghi va, ‘Eaa ulao?’ ");
INSERT INTO emi_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nau ngaghaauliaa me ngam nongonongo isaa o inangari ngam nim aalousiusi. ");
INSERT INTO emi_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Aghaaulia ngakoronna etaimim va emaamasina va akasu, poli arova atam kasu, tau ngai sausi eteva karika aue esio etaimim, me poli ngakasukasu aue asungia tani mae etaimim. ");
INSERT INTO emi_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nau eteva emae aue eghelei taumattu tale kosa ateva oia la kila amasina ssavoto me ghulughuluena me niaisakei. ");
INSERT INTO emi_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Tale ssavoto, poli la tam aiesoaa etaghi, ");
INSERT INTO emi_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","me tale ghulughuluena, poli ngalaa saesae ta Tamaghi, me karika aue am mene taraieghi. ");
INSERT INTO emi_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Me tale niaisakei, poli vau tapaa kosa ateva oia ang ghe aisakeila, me ghe tam roola. ");
INSERT INTO emi_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Oroiannaaili voto aghanna tani auliaa etaimim, me poli isaa oia nau karika aue am kila amasina. ");
INSERT INTO emi_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nau Spiriti eteva eaapasunga voto koronna aue emae, aue eauliaa voto koronna etaimim. Karika aue eauliaa righi voto nim nannaane. Aue eauliaa llo ghe nongola me aue eauliaa kieimim tale voto auena emae. ");
INSERT INTO emi_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Aue easaesae ararighi eteae, poli aue eghaa inangarighi me eauliaa etaimim. ");
INSERT INTO emi_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Isaa akapannaaili voto kanna Tamaghi, kalughu. Liuna avalua o me aue va, ‘Aue eghaa inangarighi, me eauliaa etaimim.’ ");
INSERT INTO emi_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Karika masauna arighi me aue am lungieghi, me karika aue emasau me aue am mene taraieghi.” ");
INSERT INTO emi_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Me katoa tani kapuna disaepolo laghe aikolomieinila va, “Vaalua me eue va, ‘Karika masauna arighi me aue am lungieghi, me karika masau me aue am mene taraieghi,’ me eue tee va, ‘Alao ta Tamaghi’?” ");
INSERT INTO emi_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Laghe aikolomieinila va, “Vaalua malloeana nau eue va ‘karika masauna arighi’? Karika ita kilakila amasina llo eaauliaa.” ");
INSERT INTO emi_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iesu ghe kilakila saa voto ateva laghe anna tani kolomia. Liuna avalua o me ghe uela etaira va, “Ngauela va, ‘Karika masauna arighi me aue am lungieghi, me karika masau me aue am mene taraieghi.’ Isaa o llo am aikolomainiem etana? ");
INSERT INTO emi_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Aghaaulia ngakoronna etaimim va aue am ngala me am alousiusieili, me taumattu tale kosa ateva oia aue la masimasi. Me am, aue am alousiusieili, me alousiusiaaimim aue am mene masimasi etana. ");
INSERT INTO emi_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nau aliki eteva ange anna tani lutu, vause ateva ealousiusi poli ekilakila va nau nimmarikana ange rekatala, me nau aliki eteva elutulutu, eaikkaluaa nimmarikana ghe ghaala, poli emasimasi va aliki eteva ange lutula tale kosa ateva. ");
INSERT INTO emi_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ia o voto ateva nonginaaili am. Ia oia am aalousiusi me aue amene taraiem, me aue am masimasi. Lo ateva nimasimasi, karika teva aue eghaa velua etaimim. ");
INSERT INTO emi_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ia o nau eteva karika aue am kolomieghi tale teva voto. Aghaaulia ngakoronna etaimim va Tamaghi aue etau aatu voto am kolomi tale ararighi eteae. ");
INSERT INTO emi_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nau too ang ghe lao sio karika am ghe kookolomi righi voto tale ararighi eteae. Am kolomi me aue am ghaa me aue am pasu tale nimasimasi. ");
INSERT INTO emi_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Isaa o voto aghaauliaa etaimim tale inangari niaimatoonga, me aue nau too emaemae, karika aue aghauliaa voto etaimim tale inangari niaimatoonga. Aue aghaulia ngamasalikangaili Tamaghi etaimim, me aue am kila amasinaailiia. ");
INSERT INTO emi_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ia o nau eteva aue am kokkolomi tale ararighi eteae, me karika aue va aghi aue akolomi Tamaghi tani sausiem, ");
INSERT INTO emi_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","poli Tamaghi tee eaielousieinam ta am, am ghe aielousieinaghila me am aiesoaa va aghi aghe tokatoka tee God, me aghe sio mae. ");
INSERT INTO emi_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Aghe kasula ta Tamaghi, me aghe sio mae tale kosa ateva oia, me aue amene kasu vuli kosa ateva oia tani mene sae ta Tamaghi.” ");
INSERT INTO emi_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Me kapuna disaepolo atoa laghe uela va, “Ngami vira mene ghaaghaa amasina inangarim, poli karika umene poppooaa inangari niaimatoonga. ");
INSERT INTO emi_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ia oia ngami kilakila va ukilakila akapa voto, me karika teva aue ekolomio tale righi nikokkolomi, poli ukilakila akapa nannaaimami. Liuna avalua o me ami aiesoaa va ughe kasula ta God.” ");
INSERT INTO emi_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iesu ghe liula me ghe uela etaira va, “Angam vira aikaaiaa etaghi? ");
INSERT INTO emi_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nau ange aakalakalaa me ange rekatala va aue la ghameti reerekatainam, me kateva kateva etaimim aue eilou lao tanganuena. Aue am ilou vulieghi me aue ekapa kapughu, me karika va aue ekapaaili kapughu, ta poli Tamaghi aue etoka teeieghi. ");
INSERT INTO emi_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Aghe aauliaa isaa oia inangari etaimim, poli aghanna va am toka etaghi, me aue luei eteva etoka etaimim. Kosa ateva oia oroieili nimmarikana am ghaaghaa, me am rau mene sio asoasoa, poli ngaghe apalala voto tale kosa ateva oia.” ");
INSERT INTO emi_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nau Iesu ghe ruula tani aippooaa me ghe taatara saela epona liu me ghe uela va, “Tamaghi, ange ghaala nau. Utau sae ararina ateae natum, me natum tee etau sae ararim ateae. ");
INSERT INTO emi_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Poli ughe tau lao sio ninamu ngateva etana tani aitaraa taumattu ngakapaaili, va aue etaula maulue ateva tokatoka liu ia ta lo atoa taumattu ughe taula lao sio etana. ");
INSERT INTO emi_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Maulue ateva tokatoka liu ia, ia avalua toko, va taumattu ekilaio, va io God koronna io, me la kila tee Iesu Karisto ughe sungiela tani sio. ");
INSERT INTO emi_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Aghe asaesaela ararim ateae me sarasarakaniaam tale kosa ateva; ngaghe ruula niuungu ughe tau mae sio etaghi va aghelei. ");
INSERT INTO emi_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Isaa oia Tamaghi, tale voto ateva utokatoka, utau mae ninamu ngateae ghe tokatoka teeieghi emua arau, nau kosa ateva karika ghe lutu. ");
INSERT INTO emi_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ngaghe aulia ngaotula ararim ateae tale taumattu tale kosa ateva oia ughe taula mae sio etaghi. Kapum ila me ughe taula mae sio etaghi, me ngila ghe nongo usilaala inangarim. ");
INSERT INTO emi_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ia oia ngila ghe kilala va isaa akapa voto ughe tau mae sio etaghi kalum. ");
INSERT INTO emi_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ngaghe auliaa tau lao sio inangari ughe auliaa tau mae sio etaghi me ngila ghe ghaala, me ngila ghe akoronnaailila va aghi aghe kasula etam me ngila ghe aikaaiaala va io ughe sungieghila. ");
INSERT INTO emi_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Akookolomi sae mausiira. Karika akookolomio sae tale taumattu ngakapa atoa tale kosa ateva oia. Akookolomio sae mausi taumattu ughe tau mae sio, poli kapum ila. ");
INSERT INTO emi_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Taumattu ngakapa kapughu, kapum tee, me lo kapum kapughu tee ila, la ghaapasunga masi gheeleiaaghi. ");
INSERT INTO emi_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Me ia oia karika aue amene toka tale kosa ateva ta ngamene laa saesae etam. Me ila ngila tokatoka. Tamaghi manga io, uaitarainila tale ararim ateae sarasarakana ia, ia o ararim eteae ughe taue mae sio etaghi, me aue ekateva nonga ila, nongina italua ekaakateva nonga italua. ");
INSERT INTO emi_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nau aghe tokatoka teeila, aghe aitara ngamasinaila tale sarasarakaniaa ararim ateae, ia o arari eteae ughe taue mae sio. Aghe aitarainilala, karika teva ghe rauela, llo nonga ateva taumattu elaolao tale salana nitturuu ghe rauela. Isaa avalua o me inangari tale Uru ngai Manga ateva ghe koronnala. ");
INSERT INTO emi_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ia oia ngamene mae saesae etam. Isaa oia voto aghaauliaa tale nau oia atokatoka tale kosa ateva, me aue la ghaa kalughu nimasimasi, me aue epasu tale urunguitaniira. ");
INSERT INTO emi_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Aghe auliaa tau lao sio inangarim, me taumattu ngatoa tale kosa ateva oia esessaila etaira, poli karika va mene taumattu tale kosa ila, nongina aghi karika va taumattu tale ia oia kosa ateva. ");
INSERT INTO emi_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Karika va akookolomio sae va ughaa vella tale kosa ateva oia. Akookolomio tani aitarainila tale sesa taumattu ngateva. ");
INSERT INTO emi_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Karika va taumattu tale kosa ila, nongina aghi karika va taumattu tale kosa ieghi. ");
INSERT INTO emi_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Uamangaila tale llo voto koronna; poli inangarim koronna. ");
INSERT INTO emi_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nongina ughe sungieghila tani sio tale kosa ateva, aghi ngamene sungisungila tani lao akapa see tale kosa ateva. ");
INSERT INTO emi_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mausiira me aghe tau ekapa aatu sio maamauluaaghi etam, me ila tee aue la tau ekoronna lao maamauluaaira etam. ");
INSERT INTO emi_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Karika apuupure nonga etaira, ta apuupure tee ta lo atoa aue la ghaikaaiaa etaghi nau eteva la nongo inangariira. ");
INSERT INTO emi_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","O Tamaghi, apuupure etaira va ekateva nonga ila, nongina io utokatoka etaghi, me aghi etam. Aghaloanna va ila tee la toka etaitalua, me taumattu ngatoa tale kosa ateva oia aue la ghaikaaiaa va io ughe sungieghila. ");
INSERT INTO emi_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ughe tau mae sio sarasarakana etaghi, me aghi, ngaghe tau lao sio isaa o sarasarakana etaira va aue ekateva nonga ila, nongina italua ekaakateva nonga italua, ");
INSERT INTO emi_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","aghi etaira me io etaghi, me aue ugheleila la tani kateva nonga ila, me aue taumattu tale kosa ateva oia la kila va io ughe sungieghila tani sio, me uailousieinila nongina uailousieinaghi. ");
INSERT INTO emi_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tamaghi, aghaloannaaili va taumattu ughe tau mae sio etaghi, la toka teeieghi tale masaliki eteae alaa toka etana, me aue la tara sarasarakana ughe tau mae sio etaghi nau ughe tam ghelei kosa ateva, poli ughe ailousieinaghi. ");
INSERT INTO emi_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“O Tamaghi, eeleiaam ghulughuluena, me taumattu tale kosa ateva la tam kilakilaio, ta aghi akilakilaio, me kapughu etoa la kilakila va io ughe sungieghila tani sio. ");
INSERT INTO emi_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Aghe auliaala me apasungaala eeleiaam etaira, me aue amene auliaa etaira. Me aue lo ateva niaielousi ugheleia etaghi aue etoka tee etaira, me aghi tee atoka etaira.” ");
INSERT INTO emi_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nau eteva Iesu ghe ruula tani looloo sae, ia me kapuna disaepolo atoa laghe laula tale ateo arighi Kidron ta ngetana, me laghe lao sio tale paa ngutana atingiu. ");
INSERT INTO emi_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jiudas, ia o taumattu ngateva aue etaula Iesu ta tau ngai ssateena atoa, ghe kilakila nongina Iesu ghe lao sio, poli oroi nau ia me kapuna disaepolo atoa laghe laolao tale ia o voto ateva. ");
INSERT INTO emi_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jiudas ghe lao sio tale paa ngutana atingiu tee soldia ngatoa me polisi etoa, namuu ta pristi etoa me Paresi etoa laghe sungilala. Laghe sausau lam me usulu me voto aiaaiuvii. ");
INSERT INTO emi_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iesu ange kila akapala voto aue elutu tale maamauluaane. Liuna avalua o me ghe tingina ghoala etaira me ghe uela etaira va, “Am paepae see?” ");
INSERT INTO emi_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Laghe liula me laghe uela va, “Ami paepae Iesu aNasareti ia.” Me Iesu ghe uela va, “Aghi oia.” Jiudas, ia o ghe tau lao sio Iesu, ghe tiitingina teeila. ");
INSERT INTO emi_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nau eteva ghe ruula tani ue va, “Aghi oia,” me laghe kaakatungaala viliira etapaa kosa. ");
INSERT INTO emi_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Me Iesu ghe mene kolomilala va, “Am paepae see?” Me laghe uela va, “Iesu aNasareti ia.” ");
INSERT INTO emi_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iesu ghe liula me ghe uela etaira va, “Ngaghauliaala etaimim va aghi oia. Arova am paepaeaghi, am tau velu lo atoa toko, me la kasu.” ");
INSERT INTO emi_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Isaa o voto ghe lutula me inangari ghe aulia ngakasina alokoila ghe koronnala va, “Karika teva ughe tau mae sio etaghi ghe rauela.” ");
INSERT INTO emi_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saemon Pita ghe sausau baenata ateva. Ghe kapeala, me ghe patoala kapuna tau ngai nongonongo anna ateva Namu ngateva ta pristi etoa, me ghe sai patela talingane ativilau tale pai muenna atelange. Ararina ateae ia o tau ngai nongonongo anna ateva ta Malkus. ");
INSERT INTO emi_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Me Iesu ghe uela ta Pita va, “Kaaila baenata ateva tale aikakkaaina ateva. Uannaa va karika arooroo tani ropi kapa ateva Tamaghi ghe taue mae sio?” ");
INSERT INTO emi_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Me kapuira namu ngateva soldia me kapuna soldia ngatoa me polisi etoa me kapuira namu ngatoa aJiu etoa laghe kunela Iesu, me laghe irila nimana. ");
INSERT INTO emi_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Me laghe laoa ngakasinaie sio mua ta Annas. Annas alumuna ta Kaeapas, Kaeapas namuu ia ta pristi etoa tale ia o ninamanama ateae. ");
INSERT INTO emi_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaeapas ia o taumattu ngateva ghe uela ta aJiu etoa va emaamasina arova kateva nonga taumattu ghele mate tani ghaa liuira akapa taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saemon Pita me mene kateva disaepolo lalu ghe aimuli tee Iesu. Poli namu ngateva tana pristi ekilakila ia o disaepolo ateva, liuna avalua o me ia o disaepolo ateva ghe sso teela Iesu elome tale unna valavala ateae ia o namu ngateva tana pristi. ");
INSERT INTO emi_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Me Pita nonga ghe toitoi eleka tale atamana ateae. Ia o disaepolo ateva, namu ngateva tana pristi ghe kilakilaia, ghe oghi ghoala, me ghe aippooaa teela aliki vause ateva ghe aaitoiaa atamana ateae, me ghe kolola Pita, me lalu ghe kupi ssola. ");
INSERT INTO emi_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Me aliki vause ateva ghe aaitoiaa atamana ateae ghe uela ta Pita va, “Io tee kateva kapuna disaepolo ia okae taumattu ngateva, va?” Pita ghe liula me ghe uela va, “Karika va aghi tee.” ");
INSERT INTO emi_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Poli kkaili eteva me tau ngai nongonongo anna atoa me polisi etoa laghe aisokosokolaala kura ateae, me laghe maamaruu. Pita tee ghe tiitingina teeila tani maruu. ");
INSERT INTO emi_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Namu ngateva tana pristi ghe kolomila Iesu ta kapuna disaepolo atoa me tale voto ghe aapasunga. ");
INSERT INTO emi_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Iesu ghe liula me ghe uela va, “Aghe aapasunga voto ta mata ngoroi etoa. Aghe aapasunga tale ale nivelu eitauaa me tale ale manga, isaa o voto aJiu etoa laghe mae veluvelu eitauaa etana. Karika aghe aisulia righi voto. ");
INSERT INTO emi_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Vaalua me ukookolomieghi? Ukolomi lo atoa laghe nongonongoaghi, poli ila la kilakila sa ateva aghe aaulieinia.” ");
INSERT INTO emi_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nau ta Iesu ghe aulia ngavaluela o, me kateva polisi ghe tiitingina akalakalaa etana ghe posalaiela me ghe uela va, “Vaalua me uliuliu ase inangari eteva o ta namu ngateva tana pristi?” ");
INSERT INTO emi_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iesu ghe liula me ghe uela va, “Arova aghauliaala righi voto sesa, uaulia ngaotu, me arova aghauliaa voto koronna, vaalua me uposalaieghila?” ");
INSERT INTO emi_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Me Annas ghe sungiela va elao ta Kaeapas, ia namuu ia ta pristi etoa. Iriiri ia me laghe laoainie sio. ");
INSERT INTO emi_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saemon Pita ghe tingina maamaruu me laghe kolomiela va, “Io tee kateva kapuna disaepolo, va?” Ghe liula me ghe uela va, “Karika va aghi tee.” ");
INSERT INTO emi_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kateva kapuna tau ngai nongonongo anna namu ngateva ta pristi etoa, kapuna ia ia o taumattu ngateva Pita ghe patoa vella talingane atelange, ghe uela va, “Aghe tara teeiola tapaa ngutana nau eteva am me ia, va?” ");
INSERT INTO emi_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Me Pita ghe mene uela va, “Karika.” Me paolo ateva taita ia ghe aangarila. ");
INSERT INTO emi_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Vara me aJiu etoa laghe ghaala Iesu ta Kaeapas, me laghe laoainie sio tanganuena Gavana ngateva. Elue talaua poopooa. Laghe tam aloanna tani kupi sso tanganuena, poli laghe rau gheleila va laghe tam raarangisana, poli laghe aloanna va la usi tani namanama ta Pasova ngateae. ");
INSERT INTO emi_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Paelat ghe kupi ghoa mae me ghe uela va, “Vaalua me am maeaa sio taumattu ngateva oia va eaisakei?” ");
INSERT INTO emi_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Me laghe uela va, “Arova karika ghe gheelei righi sesa voto, karika aue ami ghele maeainia etam.” ");
INSERT INTO emi_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Me Paelat ghe uela etaira va, “Am ghaaiela, me am laa ghelei niaisakei etana nongina uneimim lo eaauliaa.” Me aJiu etoa laghe liula me laghe uela va, “Karika erooroo va ami, ami uvi emate teva taumattu.” ");
INSERT INTO emi_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Isaa o voto ghe lutula me inangarina Iesu ghe aaimatoonga ase nimate ateae aue eghaaia ghe lutu ekoronnala. ");
INSERT INTO emi_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Paelat ghe mene kupi ssola tale ale ateva me ghe uela va la kolo mae Iesu, me ghe kolomila Iesu va, “Io kapuira kingi io aJiu etoa?” ");
INSERT INTO emi_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Me Iesu ghe kolomiela va, “Nannaam llo ona, o toa laghe auliaa tau aatu sio etam?” ");
INSERT INTO emi_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Paelat ghe liula me ghe uela va, “Vara aJiu eghi? Kapum atoa me namuu ta pristi etoa la maeainio sio etaghi. Sa ateva ughe gheleiela?” ");
INSERT INTO emi_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iesu ghe uela va, “Ararimangalighi eteva karika va pei tale kosa ateva oia. Arova pei tale kosa ia, aue kapughu tau ngai nongonongo anna atoa la ghele aiuuvi tani ghelei runga aJiu etoa, me karika aue la ghele kuneieghi. Me ia oia, ararimangalighi eteva karika pei tale kosa ateva ia.” ");
INSERT INTO emi_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Paelat ghe uela va, “O io kingi io, va?” Me Iesu ghe uela va, “Uaulia ngakoronna tani ue va aghi kingi eghi, poli mausina avalua o me aghe lutula, me aghe sio mae tale kosa ateva tani aulia ngaotu voto koronna. Lo atoa tale pai koronna ativilau, la nongonongo usilainaghi.” ");
INSERT INTO emi_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Paelat ghe kolomiela va, “Saa ia koronna ateva voto?” Ghe aulia ngavaluela o me ghe ghoala eleka nongina aJiu etoa, me ghe uela va, “Karika ngatarala righi voto esuisui kkai va sesa voto ghe ghelei. ");
INSERT INTO emi_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kateva ase voto agheeleia nau Pasova, atautau velu kateva taumattu etokatoka tale ale mata voovoo ekupikupi ghoa. Am aloanna va atau velu kapuimim kingi eteva aJiu etoa?” ");
INSERT INTO emi_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Laghe ovaova anamuu tani liu va, “Karika mene ia! Utau velu Barabas!” Barabas tau niaiuvii ia. ");
INSERT INTO emi_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Me Paelat ghe uela va la ghaa Iesu me la uetaia. ");
INSERT INTO emi_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Me soldia ngatoa laghe navitaala uasa rorroana tani ghelei unna kou nguru eteva, me laghe atokaie saela ta uruna, me laghe amolumoluela tale aiaasae ateva ghuaghuanna ia. ");
INSERT INTO emi_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Laghe laolao akalakalaa etana me laghe ue va, “Ei, kapuira kingi eteva aJiu etoa!” Me laghe pooposala pasipasi matane. ");
INSERT INTO emi_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Paelat ghe mene kupi ghoala me ghe uela ta aJiu etoa va, “Am tarala, ngamene aatinginaie ghoa etaimim tani auliaa kieimim va karika ngatarala righi voto esuisui kkai va sesa voto ghe gheelei.” ");
INSERT INTO emi_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nau ta Iesu ghe kupi ghoa mae, ghe aatoka kou nguru eteva rorroana ia me ghe aasae aiaasae ateva ghuaghuanna ia. Me Paelat ghe uela etaira va, “Taumattu ngateva ie toko, am taraiela.” ");
INSERT INTO emi_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nau eteva namuu ta pristi etoa me polisi etoa laghe taraiela, laghe ovaova atingina tani ue va, “Esae vukala tale aikotoo, esae vukala tale aikotoo!” Me Paelat ghe uela va, “Am ghaaiela, me am laa ghavukalaie sae tale aikotoo. Ta ngetaghi, karika ngatarala righi voto sesa ghe gheleila.” ");
INSERT INTO emi_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","AJiu etoa laghe liula me laghe uela va, “Tale uneimami inangari nipaopao, eauliaa va etani mate, poli eue va Natuna ia God.” ");
INSERT INTO emi_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nau Paelat ghe nongola isaa o inangari, maamatautuaane ghe mene lao tee sio, ");
INSERT INTO emi_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","me ghe mene kupi ssola tanganue Gavana ngateva, me ghe kolomila Iesu va, “Eaa ughe kasula?” Me Iesu karika ghe liula unna nikokkolomi eteva. ");
INSERT INTO emi_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Me Paelat ghe uela va, “Karika uanna tani sama teeieghi, va? Karika ukilakila va aghi matuutuliena aghi tani auliaa, me aue ughele kasu, o la ghele avukalaio sae tale aikotoo?” ");
INSERT INTO emi_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iesu ghe liula me ghe uela va, “Karika aue ghele righi sarasarakaniaa inangarim ta ngetaghi arova God epona liu ghe tam tau aatu sio. Liuna avalua o me lo ateva etautaueghi atu etam, kanna ssavoto elaulau kalum tani ssavoto, me namungaili.” ");
INSERT INTO emi_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ghe tiuaala o, Paelat ang ghe paepae salana vaalua tani ghelei, me etau velu Iesu me ekasu, me la rau mene uvi ematea. O me karika ta aJiu etoa laghe ovaova atingina, me laghe ue va, “Arova utau velua va ekasu, karika kapuna io Siisa. Poli lo ateva taumattu eue va kingi ia, ia tau ngai ssateena ia Siisa.” ");
INSERT INTO emi_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nau Paelat ghe nongola isaa o voto, ghe kupiaa ghoa mae Iesu, me ghe toka siola tale aitokatoka ateva aighelei niaisakei ia, tale voto ateva eleka la kolokoloa va “Atu ia”, me tale inangari nge Aramaik la ue va “Gabbata”. ");
INSERT INTO emi_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ia o nau eteva laghe aimonomonosiaa Pasova ngateva, me sinaka ateva ange tokatoka polaki, me Paelat ghe uela ta aJiu etoa va, “Kapuimim kingi eteva toko!” ");
INSERT INTO emi_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Laghe ovaova atingina me laghe ue va, “Kasueiniela! Kasueiniela me elaa vukala tale aikotoo!” Me Paelat ghe kolomilala va, “Alaa ghavukala sae kapuimim kingi eteva tale aikotoo?” Me namuu ta pristi etoa laghe liula me laghe uela va, “Karika mene teva kapuimami kingi, ta nim Siisa nonga.” ");
INSERT INTO emi_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Liuna avalua o me Paelat ghe taue lao sio etaira va la laa ghavukalaie sae tale aikotoo. Me laghe ghaala Iesu me laghe kasueiniela. ");
INSERT INTO emi_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ghe saula unna aikotoo ateva me ghe kupi ghoala, me ghe lao sio tale voto ateva arova Riu uru taumattu ngateva, tale inangari nge Aramaik la aseasea va Golgota. ");
INSERT INTO emi_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tale ia o voto ateva laghe nili evukala saela Iesu tale aikotoo ateva, ia me mene ghalua taumattu, kateva ta kativilau, me kateva ta mene kativilau, me Iesu elome. ");
INSERT INTO emi_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Paelat ghe aimonomonosiaala inangari ghe pitila, me laghe nili evukala tee saela tale aikotoo. Inangari isaa avalua toko va, “Iesu aNasareti ia, kapuira kingi ia aJiu etoa.” ");
INSERT INTO emi_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Oroi ila aJiu etoa laghe ritila isaa o inangari, poli voto ateva laghe avukalala Iesu etana kalakalangina ia tale masaliki taatara, me inangari laghe pitila tale inangari nge Aramaik, Latin me Grik. ");
INSERT INTO emi_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Namuu ta pristi etoa aJiu ila laghe lao sio tani tara Paelat, me laghe uela etana va, “Urau mene piti va uue va ‘Kapuira kingi ia aJiu etoa,’ ta upiti va ‘Ghe ue va, “Aghi kingi ieghi ta aJiu etoa.”’” ");
INSERT INTO emi_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Paelat ghe liula me ghe uela va, “Llo ngapitila, etoka nongina ngapitila.” ");
INSERT INTO emi_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Soldia ngatoa laghe ruula tani nili evukala sae Iesu tale aikotoo, me laghe ghaala ghinnanina, me laghe aikoitaala ghe rooaala taumattu ghaata. Me aiaasae ngelome nonga ateva ghe oghila, me laghe tarala va karika laghe saikiela tale oroi tuku kalio, ta laghe gheleiela tale tuku kateva nonga kalio, karika saasaiki ia. ");
INSERT INTO emi_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Liuna avalua o me soldia ngatoa laghe uela va, “Ita rau mene rasia, ta ita anamisi tani kila va see aue eghaaia.” Isaa o voto ghe lutula tani asokoi inangari Uru ngai Manga ateva ghe aulia ngamuemua alokoila va, “Aue la ghaikoita uneghi aiaasae ngelome ateva etaira, me aue la anamisi tani kila va see eghaa uneghi koloso ateva.” Soldia ngatoa laghe ghelei evaluela o. ");
INSERT INTO emi_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Kinna ghe tiitingina akalakalangina tale aikotoo ateva Iesu ghe vuuvukala etana, ia me nengane vause ateva kinna, me Meri vausenna ia Klopas, me mene kateva Meri aMakdala ia. ");
INSERT INTO emi_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nau eteva Iesu ghe tarala kinna me disaepolo ateva ghe ailousiangailiia, lalu ghe tiitingina akalakalaa, me ghe uela ta kinna va, “Kinaghi, ierai o natum ia.” ");
INSERT INTO emi_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Me ta disaepolo ateva ghe uela va, “Kinam o.” Ghe tiuaala ta ia o nau eteva ia o disaepolo ateva ghe ghaaiela me ghe laoainie sio tanganuena. ");
INSERT INTO emi_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nau eteva Iesu ghe kilala va isaa akapa voto ang ghe ruula, me tani ghelei voto Uru ngai Manga ateva ghe auliaala ekoronna, ghe uela va, “Aloghu etiulu ange kangngatala.” ");
INSERT INTO emi_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Aikaai uaeni kaakaalina ghe tokatoka. Liuna avalua o me laghe asuula tuku spans ateva me laghe tueiela tale tuu ngai eteva isopi ia, me laghe ssueinie saela ta paane Iesu. ");
INSERT INTO emi_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nau Iesu ghe ropila uaeni kaakaalina, me ghe uela va, “Ngaruu ekapala uunguaaghi!” Me ghe tturrula, me ghe tau vella maamauluaane. ");
INSERT INTO emi_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ia o nau eteva nau niaipanipaniaa ia, me aue ghe pai sae nau manga ia. Poli aJiu etoa laghe tam aloanna va vilikiira ghe vukala tale nau manga ateva tale aikotoo, liuna avalua o me laghe kolomila Paelat va la paru kotokotoo kkeira, me la ghaa velu sio vilikiira. ");
INSERT INTO emi_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Soldia ngatoa laghe lao sio tale aitiutiu eteva taumattu, me laghe paru kotoola kekena, me laghe mene lao sio ta mene kateva ta ilalua o taumattu ngalua laghe avukala teeilalue saela me Iesu. ");
INSERT INTO emi_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nau eteva laghe mae sio ta Iesu va laghe tarala va ang ghe matela, karika laghe paru kotoola kkena. ");
INSERT INTO emi_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kateva soldia ghe soala kativilau ta Iesu tale vaalau eteva, me arovaeaata ta rae me manu ghe akalala. ");
INSERT INTO emi_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Lo ateva taumattu ghe tarala eaauliaa voto ghe tarala, me inangarina koronna. Ekilakila va voto eaauliaa koronna, me aue am aikaaiaa. ");
INSERT INTO emi_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Isaa o voto ghe lutula tani ghelei inangari tale Uru ngai Manga ateva laghe aulia ngalokoila ekoronna va, “Karika aue la paru kotoo teae riuna.” ");
INSERT INTO emi_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Me mene kasina inangari tale Uru ngai Manga ateva ghe uela va, “Aue la tara lo ateva taumattu laghe soaiela.” ");
INSERT INTO emi_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Vara me Josep, tanganuena tale masaliki taatara ateae eArimatia, ghe lao sio tani kolomi Paelat va ghe ghaa Iesu ang ghe matela. Josep kateva kapuna disaepolo Iesu, me ghe aaisulia poli ghe maamatauta aJiu etoa. Paelat ghe uela va eghaaia, liuna avalua o me Josep ghe lao sio tani ghaa Iesu me ghe kasueiniela. ");
INSERT INTO emi_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Me Nikodimas tee ghe mae sio. Ia, ia o taumattu ngateva ghe lao sio tani tara Iesu eleivoo. Nikodimas ghe ghaa lao sio voto masi ngusungusuaane la gheelei tale murr me aloi laghe kao aitauaala, maamataniaane erooroo kotolungaulu ghaata (34) kilogram. ");
INSERT INTO emi_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Lalu ghe ghaala Iesu me lalu ghe rariaala voto masi ngusungusuaane, me lalu ghe sumuela tale masi kalio, nongina aJiu etoa laghe gheelei. ");
INSERT INTO emi_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Voto ateva laghe avukala saela Iesu etana tale aikotoo, utana atingiu ta ngetana, me liengani niaikkaia ngateae ouna ia etana, karika laghe alokoi teva taumattu ta ngetana. ");
INSERT INTO emi_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Me poli nau niaipanipaniaa ia tale nau manga ateva, me liengani niaikkaia ngateae kalakalangina ia, laghe alokoila Iesu tale ia o voto ateva. ");
INSERT INTO emi_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Elue talaua poopooa tale aitiutiu eteva nau tale uiki, nau ghe tam pai emasina, Meri aMakdala ia ghe ssola tale liengani niaikkaia ngateae, me ghe tarala va ngeila ghe atakiri vella atu eteva tale atamani liengani niaikkaia ngateae. ");
INSERT INTO emi_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Liuna avalua o me Meri ghe ilou lao sio ta Saemon Pita me lo ateva disaepolo Iesu ghe ailousiangailiia, me ghe uela etairarua va, “Ngeila sau vella Vau eteva tale liengani niaikkaia ngateae, me karika ngami kilala va eaa ngeila alokoiela!” ");
INSERT INTO emi_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Liuna avalua o me Pita me mene kateva disaepolo ngilalu ghe laolao tale liu eteva. ");
INSERT INTO emi_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Lalua akapa lalu ghe iilou, me kateva etairarua ghe ilou emuemuela ta Pita, me ghe laa sso rekata akasina. ");
INSERT INTO emi_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ghe tturruaala tani taatara sso, me ghe tarala kalio laghe sumuela etana, me karika ghe kupi ssola. ");
INSERT INTO emi_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Vara me Saemon Pita ghe aaimuli etana ghe rekatala me ghe kupi ssola tale liengani niaikkaia ngateae me ghe tara alokoila kalio ghe asoaso. ");
INSERT INTO emi_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Me lo atiulu kalio laghe sumla uruna ateva etana ghoughou ia, me ghe asoaso ppae. ");
INSERT INTO emi_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Vara me ia o disaepolo ateva ghe rekata akasinala ghe kupi ssola, ghe tarala isaa o voto me ghe aikaaiaala. ");
INSERT INTO emi_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Karika aloira ghe maamasaanga llo Uru ngai Manga ateva ghe auliaala va Iesu aue emene totu tale nimate. ");
INSERT INTO emi_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Me disaepolo alua lalu ghe lao sio nongina laghe tokatoka, ");
INSERT INTO emi_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","me Meri ghe tingina ngangngala eleka tale liu eteva. Ghe ngangngala, me ghe tturruaala tani taatara sso elome tale liengani niaikkaia ngateae, ");
INSERT INTO emi_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","me ghe tarala ensolo alua tale usousoana ghinna lalu ghe tokatoka nongina Iesu ghe asola, kateva ta komo ghuruna, me kateva ta komo kkena. ");
INSERT INTO emi_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Me lalu ghe kolomiela va, “Vause ateva, vaalua me ungangngala?” Meri ghe liula me ghe uela va, “Ngeila sau vella Vaughu eteva, me karika akilakila va eaa ngeila alokoiela.” ");
INSERT INTO emi_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ghe aauliaa llo me vara ghe kiriela, me ghe tarala Iesu ghe tiitingina, me karika ghe kilakila va Iesu etana. ");
INSERT INTO emi_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Me Iesu ghe uela etana va, “Vause ateva, vaalua me ungangngala, me upaepae see?” Meri ghe annaa va tau ngai toi utana ia, ghe liula me ghe uela va, “Namu ngateva, arova io ughe ghaaiela, uauliaa va eaa ughe alokoiela me alaa ghaaia.” ");
INSERT INTO emi_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iesu ghe uela etana va, “Meri.” Ghe kiriela me ghe uela va, “Rabboni!” (Inangari nge Aramaik, malloeana va “Tisa”.) ");
INSERT INTO emi_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iesu ghe uela va, “Urou mene posoaghi, poli karika aghe sae ta Tamaghi. Lao sio me ulaa ghauliaa ta nengaghi etoa va, ‘Ngalaa saesae ta Tamaghi me Tamaimim teeia, me kapughu Goto ia me am tee kapuimmi ia.’” ");
INSERT INTO emi_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Meri aMakdala ia ghe laoaa sio masi kiukiu ta disaepolo atoa, me ghe uela va, “Aghe tarala Vau eteva!” Me ghe auliaala inangari Iesu ghe auliaala etana. ");
INSERT INTO emi_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Elo alaina ateva aitiutiu eteva nau tale uiki, nau disaepolo atoa laghe lao aitauaa sio, me laghe aikavati runga poli laghe maamatauta aJiu etoa, Iesu ghe rekataala me ghe tinginala elome etaira, me ghe uela va, “Luei etoka etaimim.” ");
INSERT INTO emi_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ghe aulia ngavaluela o me ghe apasungaala nimane me lo ativilau pai laghe soaiela. Disaepolo atoa laghe masimasi etinginala nau laghe tarala Vauira ateva. ");
INSERT INTO emi_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Me Iesu ghe mene uela va, “Luei etoka etaimim. Nongina Tamaghi ghe sungieghila, aghi ngamene sungisungiem.” ");
INSERT INTO emi_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ghe aulia ngavaluela o, me ghe inoaa tau lao sio etaira me ghe uela va, “Am ghaa Spirit Manga ateva. ");
INSERT INTO emi_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Arova am kkaluaa sesa gheeleiaaira mene katoa, aue isaa o voto aue ekapa, me arova am tam kkaluaa, isaa o voto karika aue ekapa.” ");
INSERT INTO emi_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ia o nau eteva Iesu ghe rekataala ta disaepolo atoa, Tomasi (la kolokoloa va Palue ia), kateva ta kasangaulu ghalua (12) disaepolo, karika ia. ");
INSERT INTO emi_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Liuna avalua o me katoa tani disaepolo laghe uela etana va, “Ami tarala Vau eteva!” Me Tomasi ghe uela va, “Arova atani tara liu nili ta nimane, me atuli liu nili ta nimane tale vuuvuu nimaghi, me aposo lo ativilau pai laghe soaiela, aue avira mene aikaaiaa.” ");
INSERT INTO emi_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ghaitu (7) nau ghe lange sio me disaepolo atoa laghe mene tokatoka tale ale ateva, ila me Tomasi, me laghe aaikavati runga, me Iesu ghe tinginala elome etaira me ghe uela va, “Luei etoka etaimim.” ");
INSERT INTO emi_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Me ghe uela ta Tomasi va, “Posola toko, me utara nimaghi. Ssuaa mae sio nimam, me uposo lo ativilau pai laghe soaiela etaghi. Erau mene ghalua nannaam, unim aiesoaa.” ");
INSERT INTO emi_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi ghe uela etana va, “Vaughu io me kapughu Goto io!” ");
INSERT INTO emi_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Me Iesu ghe uela etana va, “Poli angu taraieghila, uaaiesoaa. Niarangise ta lo atoa karika la taatara, me la nim aaiesoaa.” ");
INSERT INTO emi_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesu ghe gheleila oroi mene kasina niaimatoongana ta mataira disaepolo atoa, me karika aghe pitila tale ia oia vuku eteva. ");
INSERT INTO emi_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Me llo oia aghe pitila va am aiesoaa etana va Iesu Mesaea ia, me Natuna ia God, me nau am aiesoaa, aue am ghaa maulue tale ararina ateae. ");
INSERT INTO emi_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Vara me Iesu ghe mene rekataala ta kapuna disaepolo atoa tale manu talia ngateae eTaiberias. Ghe rekataala etaira avalue toko va: ");
INSERT INTO emi_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saemon Pita, Tomasi (la kolokoloa va Palue ia), me Nataniel aKena ia ta pai nge Galilii, me natuna taita alua Sebedi, me mene ghalua tana disaepolo laghe mae aitauaa sio. ");
INSERT INTO emi_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Me Pita ghe uela etaira va, “Aghoa luku.” Me laghe uela etana va, “Ami usio.” Liuna avalua o me laghe saesaela tale paanaka ateva, me laghe ghoala tani luku, me ia o voo ngateva, karika laghe lukula righi kko. ");
INSERT INTO emi_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Elue talaua poopooa me laghe tarala Iesu ghe tiitingina elosamarra, me karika laghe tara kilaiela. ");
INSERT INTO emi_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ghe ue ghoa etaira va, “Kapughu aliki etoa, am ghaala righi kko?” Me laghe ue sso va, “Karika.” ");
INSERT INTO emi_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ghe uela etaira va, “Am velu uenaimim uvena ateae tale pai muenna ativilau tale olimoim paanaka ateva, me aue am ghaa righi kko.” Nau laghe gheleila isaa o voto karika ngila ghe rooroo tani ae uvena ateae, poli kko ghe oroiannaaili ila. ");
INSERT INTO emi_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Me lo ateva disaepolo Iesu ghe ailousieiniaaili ghe uela ta Pita va, “Vau eteva okae!” Nau eteva Saemon Pita ghe kilala va Iesu okae, ghe mene asaela unna aiaasae ngeleka ateva (poli ghe ghaa velu elokoiela) me ghe aoso velu siola tapaa manu. ");
INSERT INTO emi_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Me mene katoa etaira tana disaepolo laghe aaimuli tale paanaka ateva, laghe aeae uvena ateae pasu ia tale kko. Karika masau ila elae, ghe rooroo kateva ai (100) mita nonga. ");
INSERT INTO emi_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nau eteva laghe sokolaala, me laghe tarala kura ateae me kko etoa laghe asoaso etana me verete. ");
INSERT INTO emi_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Me Iesu ghe uela etaira va, “Am ghaa mae sio righi kko avirina am lukula.” ");
INSERT INTO emi_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saemon Pita ghe saesaela me ghe ae alokoi saela uvena ateae elae, pasu ia tale kko namuu, ghe roola kateva ai ghalimangaulu kotolu (153). Arongona ta oroi kko me uvena ateae karika ghe marala. ");
INSERT INTO emi_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iesu ghe uela etaira va, “Am mae namanama.” Disaepolo atoa laghe anna tani kolomia va ia see, me karika teva ghe rooroo tani ue va ekolomia, poli laghe kilakila va ia Vau eteva. ");
INSERT INTO emi_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iesu ghe lao sio tale kura ateae me ghe suraki saela verete me ghe tau lao sio etaira. Me ghe ghelei evalue tee lao o tale kko. ");
INSERT INTO emi_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Aiaakotonna ateva o nau Iesu ghe rekataala ta disaepolo atoa nau eteva ghe totula tale nimate. ");
INSERT INTO emi_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nau eteva laghe ruula tani namanama me Iesu ghe uela ta Pita va, “Saemon natuna io Jon, tani koronna va uailousieinaghi? Me ailousiaam etaghi elaulau mene katoa disaepolo?” Me Pita ghe uela va, “Ue, Vau eteva, ukilakila va aghailousieinio.” Iesu ghe uela etana va, “Uangini kieghi lutu sipsipi etoa.” ");
INSERT INTO emi_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Me Iesu ghe mene uela etana va, “Saemon natuna io Jon, koronnaaili va uailousieinaghi?” Me Pita ghe liula me ghe uela va, “Ue, Vau eteva, io ukilakila va aghailousieinio.” Me Iesu ghe uela etana va, “Uaitaraa kieghi sipsipi.” ");
INSERT INTO emi_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Aiaakotonna ta Iesu ghe mene uela etana va, “Saemon natuna io Jon, uailousieinaghi?” Pita ghe tam masimasila poli ghe mene kolomiela aiaakotonnaata ateva va koronna va eaielousiaa Iesu. Pita ghe liula me ghe uela va, “Vau eteva, ukilakila akapa voto, me ukilakila va aghaailousieinio.” Iesu ghe uela etana va, “Uangini kieghi sipsipi. ");
INSERT INTO emi_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Aghaaulia ngakoronna etam va nau eteva aliki taita io, uaaitiitiio, me ulaolao nongina aloannaam, me nau utaita namuu, aue ussuaa sae nimam, me kateva ppae aue eaitiitiio, me ekatulainio lao nongina utam aloanna tani lao.” ");
INSERT INTO emi_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iesu ghe aaulia ngavalua o tani apasunga ase nimate ateva Pita aue ghaaia tani tau sae God. Vara me Iesu ghe uela ta Pita va, “Uaimuli teeieghi!” ");
INSERT INTO emi_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita ghe kiriela me ghe tarala lo ateva disaepolo Iesu ghe ailousieinia ghe aimuli teeilalua. (Ia, ia o ghe tani vaavalaa lao ta Iesu nau laghe namanama me ghe ue va, “Vau eteva, see aue etauo lao ta nimaira tau ngai ssateem atoa?”) ");
INSERT INTO emi_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nau Pita ghe taraie lao sio me ghe kolomila Iesu va, “Vau eteva, vaalua ta ierai o?” ");
INSERT INTO emi_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Iesu ghe liula me ghe uela va, “Arova aghanna va ghele tokatoka me aghele mene kiriaa mae, vaalua ta ngetam? Unim aimuli teeieghi.” ");
INSERT INTO emi_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Poli isaa o inangari me kiukiu ghe kasu ekapa seela ta tue me nenga atoa va ia o lo ateva disaepolo karika aue emate. O me Iesu karika va ghe uela va karika aue emate, ta ghe nim ue va, “Arova aghanna va ghele tokatoka me aghele kiriaa mae, vaalua ta ngetam?” ");
INSERT INTO emi_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ia o disaepolo ateva, ia oia eaaulia ngaotu isaa o voto me ghe piti elokoila. Ami kilakila va inangarina koronna. ");
INSERT INTO emi_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iesu ghe gheleila mene oroieili voto. Aghannaa va arova la ghele piti kateva kateva tale vuku, aue karika righi voto tale kosa ateva oia tani alokoi isaa o vuku. ");
INSERT INTO emi_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiopilus, tale lo ateva to vuku aghe piti ekasinaiela, aghe auliaala niuungu Iesu ghe tiuaala tani ghelei me tani apasunga, ");
INSERT INTO emi_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","nau ghe ruula tani aippooaa tee kapuna apostolo atoa ia o ghe suitoongainilala, me tale sarasarakaniaane Spirit Manga ateva ghe auliaa tau lao sio vaalua la uungu me ghe ghaala nau eteva ghe oghi saela epona liu. ");
INSERT INTO emi_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Emuli tale nimmarikana ghe ghaala, ghe apasungaala oroieili voto tani apasunga va ia maulue ia ta ila o apostolo atoa. Ghe kaurekatila etaira ghe roola ghaatingaulu (40) nau, me tani auliaa ararimangalina ateva God. ");
INSERT INTO emi_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Kateva nau laghe namanama aitauaa me ghe uela etaira va, “Karika am mene kasu vuli mua eJerusalem. Am toi kateva voto Tamaghi ghe aulieiniela tale inangari nialokoi va aue enim tau aatu etaimim, ia o aghe aulieiniela. ");
INSERT INTO emi_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon ghe aasuu taumattu tale manu, me karika masau me aue am ghaa niaasuu tale Spirit Manga ateva.” ");
INSERT INTO emi_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nau laghe velu eitauaala me laghe kolomiela va, “Vau eteva, tale isaa oia nau erooroo va umene asaesae arariira ateae aIsraeli etoa?” ");
INSERT INTO emi_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ghe uela etaira va, “Karika uunguaaimim tani kila nau Tamaghi ghe atokala tale sarasarakaniaane. ");
INSERT INTO emi_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Me am, aue am ghaa sarasarakana nau Spirit Manga ateva emae etaimim, me saa llo am ghe tarala me nongola, aue am laa ppooaa tale masaliki taatara eJerusalem, tale provinsi eteva eJiudia, eSameria me tale kosa akapa ateva.” ");
INSERT INTO emi_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nau ghe ruula tani auliaa llo me God ghe ghaaie saela epona liu emua ta mataira, me urukookoo ateva ghe aisulieiniela tale taataraira. ");
INSERT INTO emi_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nau laghe taatara usiusie sae elomarase nongina ghe laa saesae, arovaeaata ta taumattu ngalua lalu ghe aasae kalio usousoana lalu ghe kaurekatila me lalu ghe tingina teeilala. ");
INSERT INTO emi_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Me lalu ghe uela va, “Taumattu nge Galilii etoa, vaalua me am tingina taatara sae elomarase? Ia o Iesu God ange ghaaie saela epona liu aue emene oghi sio nongina ngam taraiela elaa saesae.” ");
INSERT INTO emi_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nau ensolo alua lalu ghe kasula, laghe oghi sio mae eJerusalem ta laghe laa sae kasu tale motouru eteva la aseasea va eOliv, maamasauaane erooroo kasukasuaaira ta sambati. ");
INSERT INTO emi_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nau laghe rekatala, laghe saela tale ale ngepona atiulu nongina laghe tokatoka. Lo atoa laghe mae sio, Pita, Jon, Jeimis me Andru me Pilip, Tomas, Batolomiu, Matiu, Jeimis natuna ia Alpeas, me Saemon laghe aseasea va Selot ia, me Jiudas natuna ia Jeimis. ");
INSERT INTO emi_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ila me vause atoa, me Meri kinna ia Iesu, me tuena atoa me nengane atoa Iesu, laghe maemae aitauaa nonga tani looloo sae. ");
INSERT INTO emi_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tale isaa o nau Pita ghe tingina saela elome ta lo atoa laghe aaiesoaa, ila akapaaili erooroo kateva ai me ghaluengaulu (120). ");
INSERT INTO emi_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ghe uela va, “Tueghi me nengaghi etoa, Spirit Manga ateva ghe auliaala emua arau ta paane Deivit va Jiudas aue emuemuaa lo atoa aue la laa kune Iesu. Isaa o inangari Uru ngai Manga ateva ghe tani lutu ekoronnala. ");
INSERT INTO emi_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Poli Iesu ghe suitoongainiela tani uungu teeita, Jiudas ia kateva elome etaita.” ");
INSERT INTO emi_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ia o taumattu ngateva ghe ghaala aipolipoli tale sesa gheeleiaane me ghe polila kosa ateva, ghe katuula ghe akasa ngamateala, me kovane ateva ghe tapolakala, me tinena ghe ghoa mae eleka. ");
INSERT INTO emi_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ila akapa eJerusalem laghe nongola me laghe asela voto ateva o tale inangari tanganueira va Akeldama, malloeana va “Kosa ateva rae etana”.) ");
INSERT INTO emi_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita ghe uela va, “Laghe pitila tale vuku eteva ta Sams va, “‘Alena ateva aue enim toka me karika teva tani toka etana’ me, “‘Liuna ateva tani muemuaa niuungu kateva ppae aue eghaaia.’ ");
INSERT INTO emi_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Liuna avalua o me ita tara teva taumattu ghe kasukasu teeita nau ekapa atoa nau Vau eteva Iesu ghe tokatoka teeita, ");
INSERT INTO emi_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","etiitiuaa nau Jon ghe aasuu me ghe laa ghaa sio nau God ghe ghaa saela Iesu epona liu. Ita ghaa teva ghe tani tarala isaa o voto me tottotuaane Iesu.” ");
INSERT INTO emi_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Laghe asela ghalua taumattu, Josep laghe aseasea va Barsabas, me laghe asease teeia va Jastas, me mene kateva taumattu, Mataeasi etana. ");
INSERT INTO emi_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Me laghe looloo saela, laghe uela va, “Vau ngepona ateva, io ukilakila akapa urunguitaniira taumattu ngatoa, uapasunga va see etairarua ughe suitoongainiela va ");
INSERT INTO emi_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","eghaa niuungu eteva va eapostolo me eghaa niuungu eteva Jiudas ghe katuu vuluela tani lao nongina aue elao.” ");
INSERT INTO emi_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Laghe kaaila voto aluepai eaimatoonga arariirarua aluae. Nau laghe senusenuaala, ararina ateae Mataeasi ghe katuu ekasinala, me ie tee ghe lao aitauaa tee sio kasangaulu kateva apostolo. ");
INSERT INTO emi_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ghe ghaala nau ta Pentikos, taumattu ngatoa laghe aaikaaiaa, ila akapa laghe mae sio tani velu eitauaa tale kateva voto. ");
INSERT INTO emi_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Katengaata nonga ta laghe nongola niaangari eteva arova paka kuukuu eteva, ghe sio mae epona liu me ghe pasula elome tale ale ateva. ");
INSERT INTO emi_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Laghe tarala lo ateva ghe sio mae arova kura ataata ateae, me ghe polaie seela nonginaaili ramuramuti paa atoa, me ghe tokala epona ta kateva kateva etaira. ");
INSERT INTO emi_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Laghe pasula tale Spirit Manga ateva, me laghe tiuaala tani aippooaa tale asease nisama karika samasama tanganueira, ta Spirit Manga ateva ghe tau lao sio. ");
INSERT INTO emi_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tale ia o nau eteva oroi aJiu etoa laghe aaiesoaa ta God, laghe mae akapa see sio tale kosa akapa ateva tani velu eitauaa eJerusalem. ");
INSERT INTO emi_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nau laghe nongola mangalia ateva, laghe mae sio tani velu eitauaa, me laghe soghila tani nongo inangari tanganueira, disaepolo atoa laghe aauliaa. ");
INSERT INTO emi_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Mataira ghe otila me laghe kolomila va, “Taumattu ngatoa oia la aippooaa ila akapa laghe mae sio eGalilii. ");
INSERT INTO emi_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Vaalua me kateva kateva etaita ita nongonongo kila inangari tanganueita? ");
INSERT INTO emi_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ita taumattu tale Patia, Midia, Elam, me taumattu nge Mesopoteimia, Jiudia, Kapadosia, Pontus me Eisia, ");
INSERT INTO emi_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Prigia me Pampilia, Ijip, me katoa laghe mae sio tale kasina masaliki eLibia kalakalangina tale masaliki eteae eSaerini, me katoa laghe mae sio eRom, ");
INSERT INTO emi_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ita aJiu etoa me lo atoa ghavirina laghe mene aiesoaa teeitala, aKrit me aArabia, ita akapa ngita nongola kinatama voto ateva God nge gheleila nau ngila ppooaala tale inangari tanganueita.” ");
INSERT INTO emi_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Laghe soghila me aloira ghe kapaala me laghe aikolomieinila va, “Sa malloeana llo oia?” ");
INSERT INTO emi_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Katoa laghe aanamisainila tani ue va, “La ropila manu eteva sarasarakana ia.” ");
INSERT INTO emi_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pita ghe tingina aitauaa teela kasangaulu kateva (11) apostolo, ghe sama anamuula me ghe uela va, “Am aJiu etoa me lo atoa am tokatoka eJerusalem, am nongo amasina inangari aghauliaa. ");
INSERT INTO emi_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Taumattu oia karika la ropila nongina am aauliaa. Elue talaua arau oia ta 9 kilok. ");
INSERT INTO emi_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Isaa oia voto am taatara, propet Joel ang ghe aulia ngalokoila, ");
INSERT INTO emi_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ghe uela va, “‘God eue va, Airuuruu tale kosa ateva, aue atau sio kapughu Spirit Manga ateva tale taumattu ngatoa. Natuimim taita atoa me vause atoa aue la aulia ngaotu inangarighi. Aliki taita atoa aue la tara nitaatara, me taita namu ngatoa aue la asoasopoi. ");
INSERT INTO emi_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Me kapughu tau ngai uungu etoa, taita ila me vause ila, aue atau sio tee Spirit Manga ateva etaira, me aue la aulia ngaotu inangarighi. ");
INSERT INTO emi_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Aghi aue aghapasunga aimatootoongana elomarase me epona tale kosa ateva, rae, kura ateae, me paka asu eteva. ");
INSERT INTO emi_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Sinaka ateva aue saurrom, ulana ateva aue eraeraeana, me auena kinatama nau eteva emae, ia o nau eteva, aue aghi Vau ngepona ateva aue enaughi ia. ");
INSERT INTO emi_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Me lo atoa la kolo tau ararina ateae Vau ngepona ateva aue la saanga.’” ");
INSERT INTO emi_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita ghe mene uela va, “Israeli etoa, am nongo. Iesu aNasareti ia God ghe sungie mae sio etaimim, ghe gheleila paka mirikol me aimatootoongana elome etaimim tani apasunga etaimim va ia ghe kasula ta God. Am akapa am kilakila isaa oia voto. ");
INSERT INTO emi_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ia o taumattu ngateva emua arau God ghe kilaiela me ghe loela tani taue sio etaimim, am me ssa taumattu ngatoa am ghe uvi emateala tale aikotoo. ");
INSERT INTO emi_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","God ang ghe totuela tale mammarikana nimate ateae, poli nimate ateae karika righi sarasarakaniaane tani poso aoghia. ");
INSERT INTO emi_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Deivit ghe pitila va Mesaea ghe auliaala va, “‘Aghe taatara Vau ngepona ateva emua ta ngetaghi tale nau ekapa atoa, poli ia etokatoka tale pai muenna ativilau etaghi, me karika arooroo tani katuu. ");
INSERT INTO emi_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Liuna avalua o me urunguitanighi eteva emasimasi me paaghi eteva ekkinari tau sae ararina ateae, me vaulanighi eteva aue etoka tale voto anannaa va aue aghaa maulue etana. ");
INSERT INTO emi_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Poli io karika urooroo tani tau velueghi va alao tanganueira matena atoa, me karika aue utau velu kapum taumattu manga va emauu. ");
INSERT INTO emi_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ughe apasungaala va aue amene sakesake, me tokatokaam teeieghi aue eapasueghi tale nimasimasi.’ ");
INSERT INTO emi_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Tueghi me nengaghi etoa, aghi aghaaulia ngakorokoronganaaili etaimim va, tuvuita ateva ta Deivit ghe matela, laghe kaieiniela, me liuna ateva, etokatoka teeita tale isaa oia nau. ");
INSERT INTO emi_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ia propete ia, me God ghe gheleila kinatama inangari nialokoi eteva va teva tuvuna aue ekingi nongina ia. ");
INSERT INTO emi_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Me ia ghe taatara lao sio emua, me ghe auliaala tottotuaane Mesaea, poli karika ghe tau veluela va ghe aso tanganueira matena atoa, me vilikina karika ghe mauula tale liu. ");
INSERT INTO emi_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ia o Iesu, God ghe totuela tale nimate, ami oia ami ghe taraiela, me ami aaulia ngaotua. ");
INSERT INTO emi_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","God ghe asaesaeala tani toka tale pai muenna ativilau, me ghe tau sio mae Spirit Manga ateva nongina ghe auliaala tale inangari nialokoi. Me Iesu ghe tau sio mae Spirit Manga ateva etaimami, ghaine am taataraia me am nongonongoa. ");
INSERT INTO emi_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Poli Deivit karika ghe saela epona liu, me ghe uela va, “‘Vau ngepona ateva ghe uela ta kapughu Vau eteva va, “Toka siola tale pai muenna ativilau ");
INSERT INTO emi_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","lomosi ta aghatoka sio lo atoa la sessa teeio euu, me uatingina saoaa kkem etaira.”’ ");
INSERT INTO emi_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Liuna avalua o me Israeli ekapa atoa am tani kila amasina va ia o taumattu ngateva am ghe avukalaie saela tale aikotoo, Iesu etana, God ghe gheleiela va Vau ia me Mesaea ia.” ");
INSERT INTO emi_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nau laghe nongola inangarina Pita ghe ppooaala, ghe pasala urunguitaniira me laghe uela ta Pita me mene katoa apostolo va, “Kapumami etoa, sa ateva ami gheleia?” ");
INSERT INTO emi_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita ghe liula etaira me ghe uela va, “Am nna ngaioghioghiaa, me am ghaa niaasuu tale ararina ateae Iesu Karisto, me kaluimim ssavoto aue ekapa, me God aue etau aatu Spirit Manga ateva etaimim. ");
INSERT INTO emi_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Inangari nialokoi uneimim me natuimim atoa me taumattu ngeleka atoa, lo akapa atoa oia Vau ngepona ateva kapuita Goto ia aue ekolola.” ");
INSERT INTO emi_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Oroieili inangari Pita ghe aulia ngasarasarakanaailiila etaira tani ue va, “Am asaangiem tale vituu eteva oia sesa ia.” ");
INSERT INTO emi_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Lo atoa laghe aikaaiaala inangari laghe ghaala niaasuu, ghe roola kotolu airari (3,000) taumattu taita me vause tale ia o nau eteva. ");
INSERT INTO emi_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nau ekapa atoa tau ngaikaaia ngatoa laghe veluvelu eitauaa tee apostolo atoa, me laghe nongonongo me laghe taatara voto apostolo atoa laghe aapasunga, me laghe namanama, me laghe looloo sae aitauaa. ");
INSERT INTO emi_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ila akapa laghe taatara sarasarakaniaane God tale mirikol me aimatootoongana apostolo atoa laghe gheelei, liuna avalua o me laghe oneoneaa God. ");
INSERT INTO emi_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Me ghe kateva nonga ilala, me laghe aaitauaa peiira. ");
INSERT INTO emi_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Laghe tautau velu kasina kosa me peiira laghe polipoli me viliki veu laghe kookoitaa ta lo atoa laghe tuutukuna tale kasina voto. ");
INSERT INTO emi_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nau ekapa atoa laghe veluvelu eitauaa tale ale ngeleka atiulu tale ale manga, me laghe aaikasuaa see elome tale paa ngaleira tani namanama me laghe masimasi eitauaa, ");
INSERT INTO emi_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","laghe tautau sae ararina ateae God, me taumattu ngatoa laghe oneoneainila. Me tale nau ekapa atoa Vau ngepona ateva ghe mene tautau sso ouna taumattu ghe aasaangi, tani lao aitauaa tee lo atoa akasina. ");
INSERT INTO emi_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kateva nau Pita me Jon lalu ghe laa saesae tale ale manga ateva tani looloo sae ta 3 kilok elo alai, nau nilooloo sae. ");
INSERT INTO emi_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Taumattu ngateva, ghe lutu etangorengorenala, laghe sausaue sae tale atamani ale manga ateva la ghaseasea va Masi Taataraane. Laghe aatokaia nau ekapa atoa tani loo viliki veu tale taumattu ghe kupikupi sso tale ale manga ateva. ");
INSERT INTO emi_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nau ghe tarala Pita me Jon ta lalu ghe mae sosso tale ale manga ateva, ghe looloo viliki veu etairarua. ");
INSERT INTO emi_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pita ghe tara sossolainiela, me tee Jon, me Pita ghe uela etana va, “Utaraiengalue mae.” ");
INSERT INTO emi_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nau ghe taatarailalua ghe annaa va ghe ghaa righi voto etairarua. ");
INSERT INTO emi_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Me Pita ghe uela etana va, “Karika righi viliki veu etaghi. Voto auunusi aue atau aatu etam. Tale ararina nonga ateae Iesu Karisto aNasareti ia aghaauliaa etam va, tingina saela me ukasukasu.” ");
INSERT INTO emi_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pita ghe kunela nimana muenna atelange me ghe kune atinginaie saela me katengaata nonga ta kkena me kunikuni kkena ghe sarasarakanala. ");
INSERT INTO emi_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ghe aosola me ghe tingina saela me ang ghe kasukasu, ghe kupi eitauaa tee ssola taita alua tale ale manga ateva, ghe aoaoso me ghe kakkaua sae ararina ateae God. ");
INSERT INTO emi_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nau taumattu ngatoa laghe taraiela ta ghe kasukasula me ghe kakkaua ararina ateae God, ");
INSERT INTO emi_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","laghe kilaiela va ia oia taita ateva ghe tokatoka nonga tale atamani ale manga ateva la ghaseasea va Masi Taataraane tani loo viliki veu, laghe soghiaala tani taraia va ghe kasukasula. ");
INSERT INTO emi_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nau laghe nongola kiukiuna tangorengorena ateva va ang ghe kasukasula, ila akapaaili taumattu ngatoa laghe lao sio tani taraia elome tale ale manga ateva tale varanda ngateva laghe asease va Solomon etana. Ghe kunekune atingina ta taita alua tale ale manga ateva. ");
INSERT INTO emi_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nau Pita ghe tara avaluela o, ghe uela ta taumattu ngatoa va, “Am Israeli etoa, vaalua me am mammanuena voto oia elutula, me vaalua me am taatara sossolainangalua? Am nannaa va taumattu ngateva oia emasinala tale sarasarakaniaangalua o masi tokatokaangalua? ");
INSERT INTO emi_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kapuira Goto ateva Abraham, Aisiki me Jekop, kapuira Goto ateva tuvuita ia, ia ghe asaesaela ararina ateae kapuna tau ngai nongonongo anna ateva ta Iesu. Am ghe tauela ta aRom atoa va la uvi ematea, me am ghe ratiela va ia king ia emua ta Paelat, arongona ta Paelat ghe kilala va Iesu karika righi sesa gheegheleiaane. ");
INSERT INTO emi_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Iesu raarangisana ia me ghulughuluena ia, me am, am ghe ratiela, me am ghe aloannala va tau ngai uvii emate ateva etoka. ");
INSERT INTO emi_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Lo ateva etautau mae maulue, am ghe uvi emateala, me God ghe totuela tale nimate. Angalua oia angalu ghe taraiela ta mataingalua me angalu aaulieinia etaimim. ");
INSERT INTO emi_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Tale niaikaaiaa ta ararina ateae Iesu, taumattu ngateva am taataraia me am kilakilaia, ange korokoronganala. Lo ateva o niaikaaiaa ta Iesu ghe ghelei emasina akapaailiela tale taataraimim. ");
INSERT INTO emi_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Me anga kilaiemla, tueghi me nengaghi etoa, va voto am me kapuim namu ngatoa am ghe gheelei karika am ghe aalomasaanga tee. ");
INSERT INTO emi_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Aviri am ghe gheleila, me God ang ghe kila vella emua arau sa ateva auena elutu. Kapuna propete atoa laghe aulia ngamuemue alokoila va Mesaea aue emae ghaa nimmarikana. ");
INSERT INTO emi_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Am aikolikoliaa me am nna ngaioghioghiaa tale kaluimim ssavoto, me God aue ekkaluaa, me esei velu kaluimim ssavoto. ");
INSERT INTO emi_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Me Vau ngepona ateva aue etau aatu nau tani mene akorokorongana maamauluaaimim, me aue emene suu Mesaea, eghe suimatoongainiela tani sausiem, Iesu etana. ");
INSERT INTO emi_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ia etani toka epona liu lomosina ta emene oghi sio tani mene ghelei eouna voto akapaaili. Ghe auliaala ta propet manga atoa emua arau. ");
INSERT INTO emi_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Llo Moses ghe auliaala va, ‘Vau eteva kapuimim Goto ateva aue etau mae teva propete aue enongina ghe atinginaieghi saela, elome ta ngetaimim. Nau propete ateva emae, am rooroo tani nongo usilainia, me am ghelei voto eauliaa. ");
INSERT INTO emi_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Arova see atoa la tam nongo usilaa voto eauliaa aue God etturuu vella elome ta kapuna atoa.’ ");
INSERT INTO emi_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Etiitiuaa ta Samuel me elaolao ta mene katoa propete, laghe aulia ngaotu teela isaa oia nau. ");
INSERT INTO emi_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Am natuira iem propete atoa, me tale niaippooa ngaitaua ngateva God ghe gheleiela ta tuvuimim atoa nau ghe uela ta Abraham va, ‘Ta tuvum ateva isaa akapaaili taumattu tale kosa ateva aue la ghaa niarangise.’ ");
INSERT INTO emi_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nau eteva God ghe atingina saela kapuna tau ngai nongonongo anna ateva, ghe sungi ekasinaie mae sio etaimim tani arangiseiem me tani ghelei eoghiem tale gheeleiaaimim sesa.” ");
INSERT INTO emi_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita me Jon karika lalu ghe ruu tani aippooaa tee taumattu ngatoa, me pristi etoa, me namu ngateva ghe aaitoiaa polisi etoa tale ale manga ateva, me Sadiusi etoa laghe rekatala. ");
INSERT INTO emi_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Laghe kilakila va lalu ghe aauliaa ta taumattu ngatoa me aapasunga va Iesu ang ghe totula tale nimate, me ila akapa taumattu ngatoa ngila ghe matela ila tee aue la totu. Liuna avalua o me ghe sessaieiliila etairarua. ");
INSERT INTO emi_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Me laghe kuneilaluela tani laoainilalua tale niaisakei. Poli ang ghe elo alaila, laghe atokailalua ssola tale ale mata voovoo, me laghe toi ta ghe pai sae ta mene kateva nau. ");
INSERT INTO emi_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Oroiannaaili ila lo atoa laghe nongola me laghe aikaaiaala ta Iesu, me lo atoa taita laghe aikaaiaala erooroo ghalima airari (5,000). ");
INSERT INTO emi_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ghe paila ta mene kateva nau, tau ngai toitoi etoa, namu ngatoa me tau ngai aapasunga atoa tale inangari nipaopao laghe velu eitauaala eJerusalem. ");
INSERT INTO emi_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Annas, namuu ia ta pristi etoa, ghe toka teeilala. Ila me Kaeapas, me Jon, Aleksanda, me mene katoa taumattu mangalina ila Annas, laghe toka teeilala. ");
INSERT INTO emi_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Laghe atinginala Pita me Jon emua etaira, me laghe kolomilaluela va, “See ghe tau aatu sio sarasarakana etaimalua tani ghelei isaa oia voto? Me ta see ararina ateae amalu gheeghelei isaa o voto?” ");
INSERT INTO emi_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Spirit Manga ateva ghe pasula ta Pita me ghe uela etaira va, “Am tau ngai toitoi me namuu nge Israeli etoa, ");
INSERT INTO emi_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ngam aloanna tani kolomiengalua ghaine poli angalu ghe gheleila masi niuungu ta tangorengorena ateva, me am aloanna tee tani kila va vaalua taumattu ngateva ghe masinala. ");
INSERT INTO emi_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Me isaa oia am me Israeli ekapa atoa am rooroo tani kila va tale ararina ateae Iesu Karisto aNasareti ia, am ghe avukalaie saela tale aikotoo, me God ghe totuela tale nimate, ia ghele gheleila me ia o taumattu ngateva ghele masinala, me ange tinginala emua etaimim. ");
INSERT INTO emi_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ia Iesu, ‘Atu eteva am tau ngai atulu ale atoa am ghe uela va sesa ia me am ghe ratiela, ia ghe aitiutiula tale atu ekapa atoa tani suei ale ateva.’ ");
INSERT INTO emi_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Karika teva taumattu erooroo tani mene asaangita, karika poi. Nim ararina ateae nonga Iesu taumattu ngatoa tale kosa ateva oia ita rooroo tani saanga.” ");
INSERT INTO emi_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Namu ngatoa laghe kilakila va Pita me Jon karika lalu ghe sikulula, nim taumattu ilalua, me laghe taatara ta karika ghe moimoilalua. Liuna avalua o me laghe soghiaala tani tara, me laghe kilala va lalu ghe toka teela Iesu. ");
INSERT INTO emi_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Me laghe tarala ia o taumattu ngateva, vilikina ghe masinala, ghe tiitingina eitauaa teeilalua, liuna avalua o me ghe karikala righi inangariira tani liu etairarua. ");
INSERT INTO emi_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Isaa avalua o me namu ngatoa laghe uela etairotolu va lotolu kupi vulu ghoa kansolo atoa. Nau angilotolu ghe kupi ghoala, laghe aaikolomi va, ");
INSERT INTO emi_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Vaalua aue ita ghelei taita alua oia? Ngilalu ghele gheleila kateva ppae ase niaimatootoongana, me taumattu ngakapa atoa eJerusalem angila ghele kilaiela, ita tee karika poi ita rooroo tani ue va kamena. ");
INSERT INTO emi_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Me inangari erau namungaili va elao akapa see ta taumattu ngatoa. Liuna avalua o me ita aulia ngasarasarakana etairarua va lalu rau mene ppooaa tale ararina ateae ia o taumattu ngateva tale mene katoa tana taumattu.” ");
INSERT INTO emi_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Emulina laghe kololaluela, me laghe paolaluela va lalu rau mene ppooaa me apasunga tale ararina ateae Iesu. ");
INSERT INTO emi_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pita me Jon lalu ghe liula me lalu ghe uela va, “Vaalua, emaamasina ta matane God tani nongo usilaa inangariimim me karika va inangarina God? Am tani laa anna ngamasina. ");
INSERT INTO emi_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Karika aue angalu rooroo tani matuaa, angalu tani aulia ngakapa voto angalu ghe tarala me angalu ghe nongola.” ");
INSERT INTO emi_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kansolo atoa laghe mene tau lao sio inangari sarasarakana etairarua, me laghe sungi velulaluela, poli laghe maamatauta taumattu ngatoa. Ila akapa taumattu ngatoa laghe nnaala voto ateva oia God ghe gheleiela, me laghe tautau sae ararina ateae God. Liuna avalua o me karika righi salaira kansolo atoa tani ghelei teeilalua. ");
INSERT INTO emi_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ia o taumattu ngateva lalu ghe gheleila niaimatoonga etana me ghe masinala, anna ninamanama ang ghe laula ghaatingaulu (40). ");
INSERT INTO emi_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kansolo atoa laghe tau vella Pita me Jon me lalu ghe oghi lao sio ta mene katoa tau ngaiesoaa, me lalu ghe aulia ngakapaailiila inangariira namu ngatoa ta pristi etoa me namu ngatoa laghe auliaala etairarua. ");
INSERT INTO emi_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nau laghe nongola, me nannaaira ghe kateva nongala me laghe kakkauaa sae tale kaluira nilooloo sae ta God va, “Vau palepale, ughe gheleila eunaakookoo me kosa ateva me manu etoa me isaa akapaaili voto etokatoka etana. ");
INSERT INTO emi_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Emua arau kapum Spirit Manga ateva ghe tau lao sio inangari eteva ta tuvuimami eteva, ia o kapum tau ngai uungu ia ta Deivit, me Deivit ghe uela va, “‘Vaalua me tau ngeleka atoa esessaieiliila? Vaalua me taumattu ngatoa la loeloe asease salana atoa, me karika God etautau vella va la ghelei? ");
INSERT INTO emi_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kingi etoa tale kosa akapa ateva la ghaimonomonosiaa tani aiuvii me namu ngatoa la veluvelu eitauaa tani tau sio Vau ngepona ateva me tani tau sio kapuna Mesaea ngateva.’ ");
INSERT INTO emi_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Koronnaaili Herot me Pontius Paelat me katoa tau ngeleka me Israeli etoa, laghe velu eitauaala tale ia o masaliki taatara ateae tani loe Iesu tani uvi ematea, ia o kapum tau ngai uungu eteva manga ia ughe suitoongainiela va ia Mesaea ia. ");
INSERT INTO emi_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nau laghe gheleila isaa o voto laghe nim aimulisi teela nannaam me aloaloannaam. Tale sarasarakaniaam emua arau ughe suimatoongaala va isaa o voto aue elutu. ");
INSERT INTO emi_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Me ghaine, Vau eteva, urooroo tani annaa inangari isaa o laghe gheelei tani amatautuemami, me usausiemami kapum tau ngai uungu etoa, me ami rooroo tani ppooa ngasarasarakana inangarim me karika ami mene matautu. ");
INSERT INTO emi_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Me urooroo tani saoaa nimam ta tau sessa atoa tani gheleila me la mene masina, me urooroo tani ghelei asease aimatoonga me mirikolo tale ararina ateae Iesu, ia kapum tau ngai uungu eteva manga ia.” ");
INSERT INTO emi_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nau eteva laghe ruula tani looloo sae, ale ateva laghe velu eitauaala etana ghe aisiisiaala, me laghe pasula tale Spirit Manga ateva, me laghe ppooa ngaotula inangarina God. Laghe aippooa ngasarasarakana me karika laghe maamatautu. ");
INSERT INTO emi_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ila akapa tau ngaiesoa ngatoa laghe kateva nonga ilala tale ninanna me nialoanna. Karika teva taumattu ghe ue va peina kanna nonga. Karika, isaa akapaaili voto laghe aitauaa elome etaira. ");
INSERT INTO emi_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tale kinatama sarasarakana atoa, apostolo atoa laghe aulia ngaotula tottotuaane Vau eteva Iesu. Me oroieili maamasinaane God ghe tokala etaira akapa, ");
INSERT INTO emi_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","me karika teva taumattu elome ta ngetaira ghe tuutukuna tale inana me voto. Kasina taumattu kosaira me aleira laghe tau lao sio va la poli. Nau eteva laghe polipoli, isaa o viliki veu laghe ghaaghaa laghe laolaoa ");
INSERT INTO emi_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ta apostolo atoa, me apostolo atoa laghe aikoita ta lo atoa laghe tuutukuna tale kasina voto. ");
INSERT INTO emi_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kateva taumattu tale ararimangalina ateva Livae, ararina ateae ta Josep, ghe lutula tale patunganua ateva eSaeprasi me ghe tokatoka eJerusalem, apostolo atoa laghe kolokolo Banabas etana (malloeana va tau ngai sausia ia tale masi ninannaa), ");
INSERT INTO emi_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ghe taula tuku kosane ateva me laghe poliela, me ghe ghaala viliki veu me ghe laoaa sio ta apostolo atoa. ");
INSERT INTO emi_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Taita ateva ararina ateae ta Ananaeas me vausenna ateva ta Sapaera, lalu ghe tau vella tuku kosairarua ateva laghe poliela. ");
INSERT INTO emi_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananaeas me vausenna ateva lalu ghe ghaa oghila kasina viliki veu. Ananaeas ghe laoaa sio nonga kasina viliki veu ta apostolo atoa. ");
INSERT INTO emi_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Vara me Pita ghe uela ta Ananaeas va, “Vaalua me utau vella Satana eapasula urunguitanim ateva me angu kamela Spirit Manga ateva, me angu ghaa oghila kasina aipolipoli tale kosa ateva? ");
INSERT INTO emi_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nau ghe asoaso kosami ia, ughe ghelei aloannaam etana, me nau ughe aitaueiniela me laghe poliela, viliki veu ghe unem. Me vaalua me ughe aloannala tani mene ghelei evalua o? Karika ukamekame nonga taumattu ngatoa, ta ukamekame tee God.” ");
INSERT INTO emi_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nau Ananaeas ghe nongola, ghe matela me ghe katuula. Kinatama nimatautu ghe ghaala taumattu ngatoa laghe nongola sa ateva ghe lutula. ");
INSERT INTO emi_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Vara me aliki taita atoa laghe kupi sso mae me laghe ghiisainiela me laghe sauela, me laghe lao sio tani kaieinia. ");
INSERT INTO emi_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Koti erooroo kotolu aoa ghe lange sio me vausenna ateva ghe kupi ssola. Karika ghe kilala sa ateva ang ghe lutula. ");
INSERT INTO emi_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita ghe kolomiela va, “Auliaala etaghi, va isaa nonga oia aipolipoli tale tuku kosa ateva?” Me ghe liula me ghe uela va, “Ue, nim isaa nonga o.” ");
INSERT INTO emi_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pita ghe uela etana va, “Vaalua amalu aloanna tani kame kapuna Spiriti eteva Vau eteva? Tarala! Lo atoa la lao sio tani kaiaa taitanim ateva, ila etapaa ngatamana, me aue la mene sau teeio.” ");
INSERT INTO emi_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Me katengaata nonga ta vause ateva ghe matela me ghe katuula ta liue kkena Pita. Aliki taita atoa laghe sso mae me laghe saopiela ta ang ghe matela. Laghe sauela tani laa kaiaa valainia ta taitanna ateva. ");
INSERT INTO emi_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kinatama nimatautu ghe lutula ta tau ngaiesoa ngatoa, me see ila lo atoa laghe nongola llo kiukiu. ");
INSERT INTO emi_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ta ngetaira apostolo atoa, oroieili niaimatootoongana me mirikolo laghe gheelei. Tau ngaiesoa ngakapa atoa laghe tokatoka aitauaa tale varanda ngateva laghe asease Solomon etana. ");
INSERT INTO emi_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Lo atoa karika tau ngaiesoaa ila laghe maamatautu tani mae aitauaa tee tau ngaiesoa ngatoa, me karika, ta taumattu ngatoa laghe oneoneainila. ");
INSERT INTO emi_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Me oroieili taita me vause laghe aiesoaala ta Vau ngepona ateva laghe lao aitauaa tee sio kapuna atoa. ");
INSERT INTO emi_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Taumattu ngatoa laghe tarala oroieili voto apostolo atoa laghe gheelei, o laghe sausau tau sessa atoa laghe ghoa aalokoila tapaa salana tale aisalo me tale komo va nau Pita ghe kasukasu emaemae, tootoona ateva ghe tulila. ");
INSERT INTO emi_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Oroieili taumattu ngatoa tanganueira kalakalaa eJerusalem, laghe maemaeaa tau sessa atoa me lo atoa raroai etoa laghe ghelei saasakieinila, ila akapa laghe maamasina. ");
INSERT INTO emi_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Namu ngateva ta pristi etoa me kapuna akapa atoa, ila elome tale pati eteva ta Sadiusi, laghe nannaa saasakiaa tee apostolo atoa. ");
INSERT INTO emi_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Liuna avalua o me laghe kunela apostolo atoa, me laghe atokaila ssola tale ale mata voovoo. ");
INSERT INTO emi_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nau eleivoo ensolo ateva kapuna ia Vau ngepona ateva ghe otila atamana atoa tale ale mata voovoo ateva me ghe kupieinila ghoala. Me ghe uela va, ");
INSERT INTO emi_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Am kasula, me am laa tingina tale ale ngeleka atiulu tale ale manga ateva me am ppooaa ta taumattu ngatoa inangari tale ia oia maulue ateva.” ");
INSERT INTO emi_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Elue talaua poopooa tale mene kateva nau laghe ssola tale ale ngeleka atiulu tale ale manga, nongina ensolo ateva ghe auliaala etaira, me laghe tiuaala tani apasunga ta taumattu ngatoa. Vara me namu ngateva ta pristi etoa me kapuna atoa laghe kolo aitauaala kansolo atoa, namu ngatoa ta natuna atoa Israeli. Laghe suu lao sio inangari tale ale mata voovoo va la maeaa apostolo atoa. ");
INSERT INTO emi_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nau polisi etoa tale ale manga ateva laghe rekataala tale ale mata voovoo, laghe tara luulala. Laghe oghi lao sio tani auliaa va, ");
INSERT INTO emi_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Ale mata voovoo ateva kaakavati emasinaaili ia, tee tau ngai toitoi etoa la tiitingina etapaa ngatamana. Nau ami otila karika ami tarala toa elome.” ");
INSERT INTO emi_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nau laghe nongola kiukiu namu ngateva ghe aaitoiaa polisi etoa tale ale manga ateva, me namu ngatoa ta pristi etoa laghe annaa sossolaa va sa ateva aue elutu. ");
INSERT INTO emi_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kateva taumattu ghe mae sio etaira me ghe uela va, “Am nongola! Taumattu am ghe atoka ssola tale ale mata voovoo, ila tale ale manga ateva la sso aapasunga ta taumattu ngatoa.” ");
INSERT INTO emi_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Liuna avalua o, polisi etoa me lo ateva ghe aitoieinila laghe ssola tani kuneila, karika laghe karatainilala poli laghe maamatauta taumattu ngatoa, va la rau kumla arova la uvi apostolo atoa. ");
INSERT INTO emi_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nau laghe maeainila sio tale liu niaisakei, namu ngateva ta pristi etoa ghe tiuaala tani kolomila. ");
INSERT INTO emi_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ghe uela va, “Ami ghe tau aatu sio inangari sarasarakana va karika am mene laa ghapasunga see tale ararina ateae ia o taumattu ngateva. Me karika, ta ngam ghele rooa ngakapa seela eJerusalem, me am aaliu teeiemami va ami, ami ghe uvi emateala.” ");
INSERT INTO emi_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Vara me Pita ghe ghaala liuira apostolo atoa tani liu inangariira, me ghe uela va, “Ami nongo usilaa nonga God me karika taumattu. ");
INSERT INTO emi_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kapuira Goto ateva tuvuita atoa ghe totula Iesu tale nimate. Ia o am ghe avukalaie saela tale aikotoo. ");
INSERT INTO emi_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ia God ghe asaesaeala me ghe atokaiela tale pai muenna ativilau va ia Vauita ia me tau ngai asaangiita ia, tani taula ninna ngaioghioghiaa me nikkaluaa kaluira ssavoto Israeli etoa. ");
INSERT INTO emi_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ami tee ami aauliaa voto oio, me tee Spirit Manga ateva, ia o God ghe nim taue lao sio ta lo atoa laghe nongo usilainiela.” ");
INSERT INTO emi_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nau laghe nongola llo ghe sessailala etaira, me laghe aippooa ngaitauaala tani uvi ematela. ");
INSERT INTO emi_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Me kateva etaira ghe tingina saela, ararina ateae ta Gamaliel, ie tee Paresi ia, tau ngai aapasunga ia tale inangari nipaopao me taumattu ngakapa atoa laghe oneoneainia, ghe uela va, “Tau vellala me la kasu mua.” ");
INSERT INTO emi_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Me ghe uela etaira va, “Am taumattu nge Israeli etoa, am paniem arova am aaloanna tani ghelei righi voto etaira. ");
INSERT INTO emi_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Poli kasina nau ang ghe lange sio taumattu ngateva ghe tingina saela, ghe poppooaa va ia namuu ia, ararina ateae ta Tiudas. Ghe ghaala kapuna ghaata ai (400) taumattu. Me aRom atoa laghe uvi emateala me kapuna atoa laghe ilou reerekataa seela. Uunguaaira ghe nim kapala. ");
INSERT INTO emi_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Emuli etana, Jiudas nge Galilii ghe mene kaurekatila, ta nau nimene ghelei sensis, me oroi taumattu ghe mene usiela. Vara me laghe mene uvi emateala. Me kapuna atoa laghe mene ilou reerekataa seela. ");
INSERT INTO emi_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Liuna avalua o me tale lo ateae oia niaisakei aghaauliaa etaimim va am tau vellala me la kasu, ta arova nim uunguaaira taumattu ngatoa, aue enim peisaane. ");
INSERT INTO emi_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Va arova kanna God, karika am rooroo tani paola. Am rau nim aiuvii tee nonga God.” Me ila akapa laghe aimuli teela inangarina Gamaliel. ");
INSERT INTO emi_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Laghe kolola apostolo atoa laghe kupi ssola, me laghe uela va la parula me laghe uela etaira va karika la mene laa ppooaa see tale ararina ateae Iesu, me laghe sungi vellala. ");
INSERT INTO emi_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nau laghe kasula laghe masimasila, poli God ghe tarailala va la rooroo tani ghaa nimmarikana tale ararina ateae Iesu. ");
INSERT INTO emi_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tale nau ekapaaili elome tale ale ngeleka atiulu tale ale manga ateva me tale ale akapaaili, apostolo atoa karika laghe ruula tani ppooaa me apasunga va Iesu Mesaea ia. ");
INSERT INTO emi_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tale isaa o nau, disaepolo atoa ngila ghe ooroi me lo atoa etaira laghe samasamaa nge Grik laghe aauliuliaa aHibru etoa ta poli karika laghe aikoita ngamasina voto ta kapuira vause raue vulu etoa tale nau ekapa atoa. ");
INSERT INTO emi_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Liuna avalua o me kasangaulu ghalua (12) apostolo laghe kolo aitauaala tau ngaikaaia ngakapa atoa me laghe uela etaira va, “Karika masina arova ami ruu tani ppooaa inangarina ateva God me ami mae koita inana. ");
INSERT INTO emi_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Isaa avalua o tuemami me nengamami etoa, am tara elome etaimim ghaitu (7) taita pasu ila tale Spirit me alomasaanga, me ami suitoongainila tani ghelei ia o niuungu eteva, ");
INSERT INTO emi_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","me ami uunguaa nonga tani looloo sae me tani ppooaa inangarina God.” ");
INSERT INTO emi_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Isaa o inangari ghe masinala ta taumattu ngakapa atoa, me laghe asela Stipeni pasu ia tale niaikaaiaa me Spirit Manga ateva, me Pilip, Prokorus, Nikano, Timon, Pamenas, Nikolasi atala nge Antioko ia, karika aJiu ia nau ghe lutula, vara me ghe aiesoaala me ghe aJiula, me emulina ghe mene aiesoaala ta Karisto. ");
INSERT INTO emi_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Laghe laoainila sio ta apostolo atoa, me laghe looloo saela me laghe saoaala nimaira etaira tani amangaila va la ghelei ia o niuungu eteva. ");
INSERT INTO emi_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Inangarina ateva God ang ghe naanamuu me eJerusalem oroieili taumattu laghe aiesoaala, me oroieili pristi tee atoa laghe nongo usilaala masi inangari. ");
INSERT INTO emi_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stipeni pasu ia tale sarasarakana me maamasinaane God. Ghe gheelei mirikolo me niaimatoonga sarasarakana elome tale taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Me katoa taumattu karika laghe laolao aitauaa tee aloannaane Stipeni. Isaa o taumattu laghe velu eitauaala tale kateva ale nivelu eitauaa la kolokoloa va aleira ia lo atoa emua akasina karika laghe tokatoka tale aloannaaira. Isaa o taumattu atala nge Saerini ila me Aleksandria ila, me provinsi elua ta eSilisia me eEisia. Katoa ta ngetaira laghe sessaila ta Stipeni. ");
INSERT INTO emi_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Spirit Manga ateva ghe tau lao sio alomasaanga ta Stipeni, liuna avalua o me karika laghe rooroo tani apala inangari Stipeni ghe poppooaa. ");
INSERT INTO emi_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kasina taumattu laghe polilala tani aikamea tee Stipeni va laghe nongoala ghe poppooaa saasakiaa ta Moses me God. ");
INSERT INTO emi_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Tale isaa o inangari, taumattu ngatoa laghe sessailala, me taumattu ngatoa me namu ngatoa me tau ngai aapasunga atoa tale inangari nipaopao laghe kunela Stipeni me laghe laoainie sio ta Kansolo atoa. ");
INSERT INTO emi_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Laghe ghaala kasina taumattu va eaikamea teeia, ila o taumattu ngatoa laghe uela va, “Ia oia taumattu ngateva enim toka aauliaa saasakiaa tee voto ateva oia manga ia me kanna inangari nipaopao Moses. ");
INSERT INTO emi_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Poli ami ghe nongola ta ghe uela va ia o Iesu atala nge Nasareti ia ghe uela va aue etturuu ale manga ateva me eaikolikoliaa voto emua arau Moses ghe tau mae sio.” ");
INSERT INTO emi_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Me taumattu ngatoa tale ia o nivelu eitaua ngateae laghe taatara lao sio ta Stipeni, me laghe tarala matane ghe nonginala ensolo ateva. ");
INSERT INTO emi_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Namu ngateva ta pristi etoa ghe kolomila Stipeni va, “Koronna llo oia?” ");
INSERT INTO emi_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","3","Stipeni ghe liula me ghe uela va, “Tueghi me nengaghi me tamaghi etoa, am nongoaghi va God ateva pasu ia tale mallanga ghe rekataala ta tuvuita ateva ta Abraham nau eteva ghe tokatoka eMesopoteimia. Ghe uela etana va, ‘Ukasu vuli tanganuem me kapum atoa, me ulao tale kosa ateva aue aghapasungainia etam.’ Me auena ghe laa toka eHaran. ");
INSERT INTO emi_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Me ghe kasu vulila tanganue aKaldia ngatoa me ghe lao sio tani toka eHaran, me vara tamane ghe matela me ghe mene mae sio tani toka tale kosa ateva oia am tokatoka etana. ");
INSERT INTO emi_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","God karika ghe tau lao sio teva tuku kosa etana va ghe kanna. Karikaaili tuku teva. God ghe alokoila inangari nialokoi etana va ia me tuvuna atoa emuli etana aue la ghaa kosa ateva oia, arongona ta ia o nau eteva Abraham karika righi natuna. ");
INSERT INTO emi_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","God ghe uela etana va, ‘Aue tuvum atoa aue la ativuu tale mene kateae ppae masaliki me la nim tau ngai uungu me taumattu ngatoa tale ia o masaliki eteae aue la ghelei saasakiaa etaira aue eroo ghaata ai (400) ninamanama. ");
INSERT INTO emi_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Me aue aghi aghattara matana lo ateva anua eghaaila va la nim tau ngai uungu.’ Me God ghe mene uela va, ‘Emulina aue la kasu vuli ia o anua ateva me aue la mene mae kkaueinaghi tale masaliki eteae oia.’ ");
INSERT INTO emi_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","God ghe gheleila inangari niaippooa ngaitauaa tee Abraham tale ni-isoiso ateae me Abraham ghe tamane iela Aisiki me vara ghaitu nau ghe lange sio me Abraham ghe isola Aisiki. Vara me Aisiki ghe natunala ta Jekop me Jekop ghe natunala kasangaulu ghalua (12) ghe tuvuitala. ");
INSERT INTO emi_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Me tuena taita namu ngatoa Josep laghe nannaa saasakiaa teeia, liuna avalua o me laghe taue lao sio me ghe siola eIjip me laghe ghaala aipolipoli, me God ghe tokatoka aitauaa teeia, ");
INSERT INTO emi_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","me ghe aasaangia tale isaa akapaaili voto sesa, me ghe tau lao sio alomasaanga etana va Peroo kingi nge Ijip ateva ghe maamasiaa uunguaane me ghe gheleiela ghe namuula eIjip me tale alena akapa ateva. ");
INSERT INTO emi_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Vara me kinatama maloo ateva ghe lutula eIjip me eKeinan me voto sesa ghe lutu teeilala, me tuvuita atoa karika laghe roola tani ghaa righi inana. ");
INSERT INTO emi_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nau Jekop ghe nongola va inana eIjip, ghe suula tuvuita atoa tani sio eIjip tale aitiutiu eteva uneira nisio. ");
INSERT INTO emi_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Aiaaghaluene ateae nisio, Josep ghe aulia ngaotula ta tuena atoa va ia see, me liuna avalua o me Peroo ghe kilala kapuna atoa. ");
INSERT INTO emi_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josep ghe suula inangari va tamane ta Jekop me kapuna akapa atoa la sio. Ila akapaaili erooroo ghaitungaulu ghalima (75) taumattu. ");
INSERT INTO emi_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Vara me Jekop ghe siola eIjip, ia me tuvuita atoa laghe matela okae. ");
INSERT INTO emi_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nau laghe matela laghe mene saeainilala eSekem tale liu niaikkaia ngateva Abraham ghe polie lao sio ta natuna atoa Hamor tale kasina ase viliki veu. ");
INSERT INTO emi_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Nau ang ghe aakalakalaa va God ghe ghelei roorooaa inangari nialokoi ghe auliaala ta Abraham, me aIsraeli etoa eIjip laghe oroienaaili ila. ");
INSERT INTO emi_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Vara me kingi eteva ghe tam kilakila Josep ghe tiuaala tani aitoiaa eIjip. ");
INSERT INTO emi_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ghe tiuaala tani pae salana tani ghelei saasakiaa tuvura atoa me tani ghelei voto karika masina etaira. Tee ghe uela va la sau velu natuira aliki etoa me aue la mate. ");
INSERT INTO emi_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Tale isaa o nau Moses ghe lutula. Masi taataraane ta matane God me laghe aitarainiela elo ale erooroo kotolu (3) ulana. ");
INSERT INTO emi_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Me nau laghe ghaa velue ghoala eleka tanganueira, natuna vause ateva king ghe ghaaiela, me ghe aitarainiela va natuna ia. ");
INSERT INTO emi_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ghe ghaa akapala alomasaangania nge Ijip me inangarina me gheeleiaane sarasarakanaaili. ");
INSERT INTO emi_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Nau anna ninamanama ghe ghaatingauluaela (40), ghe nnaala tani laa tara kapuna atoa, tuvuna atoa Jekop. ");
INSERT INTO emi_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ghe tarala kateva aIsraeli, aIjipi eteva ghe gheelei saasakieinia me ghe sausila kapuna ateva, me tani liu, ghe uvi ematela aIjipi eteva. ");
INSERT INTO emi_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ghe annaa va kapuna atoa aue laghe kila va God ang ghe tiitiuaa tani sausila tani asaangila tale niuungu Moses ang ghe tiitiuaa tani ghelei, me aloira karika laghe maamasaanga. ");
INSERT INTO emi_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mene kateva nau ghe mene tarala kapuna alua aIsraeli ilalua lalu ghe aaiuvii me ghe tootoongaala tani ghelei rungainilalua me ghe uela etairarua va, ‘Amalua, aHibru nonga iemalua, me vaalua me amalu aaiuvieinamalua?’ ");
INSERT INTO emi_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Me lo ateva ghe tiuaala tani aiuvii ghe bbi velu lao sio Moses me ghe uela etana va, ‘See ghe uela va io unamuu me ughelei niaisakei etaimami? ");
INSERT INTO emi_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ualoanna tani uvi emateaghi nongina ughele uvi ematela aIjipi eteva ghalailloo?’ ");
INSERT INTO emi_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nau Moses ghe nongola llo, ghe iloula eIjip me ghe lao sio tani ativuu etoka eMidien me isaa okae me ghe natunala ghalua. ");
INSERT INTO emi_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Nau ghaatingauluae (40) ninamanama ghe ruula me ensolo ateva ghe otuotula ta ngetana tale voto ateva karika righi taumattu etana kalakalaa ia tale motouru eteva eSaenae, tale ramerame kura ateae ghe ataata ai erighi. ");
INSERT INTO emi_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses ghe soghiaala nau ghe tarala me ghe lao akalakalangina sio tale ai erighi tani tara amasinaia me ghe nongola lingi ngalona ateva Vau eteva. ");
INSERT INTO emi_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Ghe uela va, ‘Aghi kapuira Goto ieghi tuvum atoa me kapuna Goto ieghi Abraham, Aisiki me Jekop.’ Moses ang ghe reterete poli ghe matautula, me karika ghe aloanna tani taatara lao. ");
INSERT INTO emi_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Vau eteva ghe uela etana va, ‘Ghaa vella unem aikasukasu ta kkem ta voto ateva utiitingina etana, manga ia. ");
INSERT INTO emi_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Aghe tarala sesa nimmarikana kapughu etoa laghe ghaala eIjip me ngaghe nongola ngangngalaaira me ngasio mae tani ghaa vella tale karavusu. Mae sio me asungio me umene oghi sio eIjip.’ ");
INSERT INTO emi_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Nim ie nonga o lo ateva Moses aIsraeli etoa laghe ratiela me laghe auliaa teeia inangari va, ‘See ghe uela va unamuu me ughelei niaisakei?’ Ta God nonga, tale ensolo ateva eghe aotuotula etana tale ai erighi ghe ataata, ghe sungiela va ia namuu ia me tau ngai ghaa oghi ia. ");
INSERT INTO emi_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ia ghe ghaa vellala eIjip me ghe gheleila niaimatoongana me ase mirikolo atoa eIjip me eRet Sii me ghaatingauluae (40) ninamanama tale voto ateva karika righi taumattu etana. ");
INSERT INTO emi_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Ie nonga o Moses ghe uela ta Israeli etoa va, ‘God aue etau aatu propete ateva aue enongina ghe atinginaieghi saela, elome ta ngetaimim.’ ");
INSERT INTO emi_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses ghe tokatoka aitauaa teeila tale voto ateva karika righi taumattu etana, me ensolo ateva ghe sama teeiela tale motouru eteva eSaenae me ghe ghaala inangari maulue tani asaoki etaita. ");
INSERT INTO emi_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Me tuvuita atoa laghe tam nongo usilainiela me laghe ratiela me elome tale urunguitaniira, laghe mene oghiaa lao sio eIjip. ");
INSERT INTO emi_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Laghe uela ta Eron va, ‘Gheleila righi kapuita goto me emuemueinita, poli ia oia taumattu ngateva ta Moses ghe kolo velutala eIjip, karika ngami ghe kilala va sa ateva ang ghe lutula etana.’ ");
INSERT INTO emi_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Isaa o nau laghe gheleila natu tootoo vulumakao arighi me laghe gheleila aiaavusuvusuena etana, me laghe gheleila paka maakiikii eteva tani tau sae voto nimaira ghe gheleila. ");
INSERT INTO emi_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","God ghe oghi vululala me ghe tau vellala tani kkaua voto elomarase. Isaa o voto ghe asokoila llo propete atoa laghe pitila tale uneira vuku va, “‘Am Israeli etoa karika am ghe tau mae sio righi aiaavusuvusuena etaghi nau am ghe kasula ghaatingauluae (40) ninamanama tale voto ateva karika righi taumattu etana. ");
INSERT INTO emi_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Am ghe sausau see alena ale kandisi eteva kapuimim goto ateva ta Molok me kapuimim katto goto ateva ta Repan tootoo ateva am ghe gheleiela va am kkaueinia. Liuna avalua o me aue atau veluem me la ghaaiem sio eBabilon.’ ");
INSERT INTO emi_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Tuvuita atoa laghe tokatoka tee ale manga kandisi eteva ia o laghe sausaua see tani apasunga va God etokatoka elome etaira nau laghe kasukasu tale voto ateva karika righi taumattu etana. Laghe gheleiela nongina vaalua God ghe auliaala ta Moses me vaalua ghe tarala tootoona ateva. ");
INSERT INTO emi_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Mene kateva vituu ta tuvuita atoa laghe ghaaiela, me nau Josua ghe mene aitarainilala, laghe sau teeie mae sio nau laghe mae sio tani ghaa ia oia kosa ateva tale llo anua God ghe karati vellala. Ghe tokala o lomosina ta ghe laa ghaa sio nau ta Deivit. ");
INSERT INTO emi_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","God ghe masimasieiniela, liuna avalua o me Deivit ghe kolomila va eghelei teva ale aitokatokane kapuna Goto ateva Jekop. ");
INSERT INTO emi_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Me karika, ta Solomon ghe atulula alena ateva. ");
INSERT INTO emi_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Me lo ateva Iaaili Epona karika etokatoka tale ale taumattu ngatoa la gheelei, nongina propete ateva ghe uela va, ");
INSERT INTO emi_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“‘Vau ngepona ateva ghe uela va, “Epona liu aitokatokaghi ia me kosa ateva, aiatingina kkeghi ia. Sa ateva ale am mene anna tani atulu me ealeghi? O saa mene teva voto aue aghainoana etana? ");
INSERT INTO emi_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Karika va nimaghi ghe gheleila isaa akapa o voto?”’ ");
INSERT INTO emi_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Am aakorokorongana nannaaimim me urunguitaniimim me nongonongoaaimim nongina tau ngeleka atoa. Nau ekapa atoa karika am aaloanna tani nongo Spirit Manga ateva nongina tuvuim atoa. ");
INSERT INTO emi_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Am annaa teva propete tuvuim atoa karika laghe ghelei saasakiaa teeiela? Laghe uvi emate teela lo atoa laghe aaulia ngamuemua ngalokoi, maemaeaane lo ateva ghulughuluena ia. Me isaa oia nau ngam ghe aitaueiniela me ngam ghe uvi emateala. ");
INSERT INTO emi_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Am oia am ghe ghaala inangari nipaopao ensolo atoa laghe taula ta Moses me karika am aimuli tee!” ");
INSERT INTO emi_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nau laghe nongola llo ghe sessai etinginailala me laghe aingeresia ngalungaluira etana. ");
INSERT INTO emi_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Me Stipeni, pasu ia tale Spirit Manga ateva, ghe taatara saela epona liu me ghe tarala mallangina ateva God me Iesu ghe tiitingina tale pai muenna ativilau ta God. ");
INSERT INTO emi_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Me ghe uela va, “Am tarala, ngatarala epona liu ange otiela me Natuna ateva Taumattu ngateva etiitingina tale pai muenna ativilau ta God.” ");
INSERT INTO emi_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tale isaa o inangarina me laghe rrongi rungaala talingaira me laghe aaore atingina me ila akapa laghe ilou lao sio etana. ");
INSERT INTO emi_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Laghe ae velue ghoala tale masaliki taatara ateae me laghe tiuaala tani kumua tale atu. Me lo atoa laghe nongoala laghe alokoila ghinnaniira ta liue kkena aliki taita ateva, Sol ta ngetana. ");
INSERT INTO emi_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nau laghe kumkumua, Stipeni ghe looloo saela me ghe uela va, “Vau eteva Iesu, ughaa maamauluaaghi.” ");
INSERT INTO emi_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Me ghe suuiaala ta patu kkena me ghe sama anamuula me ghe uela va, “Vau eteva, urau mene annaa kaluira ssavoto.” Nau ghe aulia ngavaluela o me ghe asekanuela. ");
INSERT INTO emi_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Me Sol ie tee okae, me ta matane Sol, voto laghe ghelei teela Stipeni ghe tarala va masina. Tale nau eteva Stipeni ghe matela etana, laghe tiuaala o tani uvi saasakiaa tau ngaiesoa ngatoa eJerusalem. Liuna avalua o me tau ngaiesoa ngatoa laghe iloula eJerusalem me laghe lao sio tale masaliki etoa eJiudia me eSameria. Me apostolo atoa laghe tokala. ");
INSERT INTO emi_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Kapuna taita atoa laghe tani aikaaiaa ta God laghe kaiaala Stipeni me laghe kaarasila tani ngalaia. ");
INSERT INTO emi_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Me Sol ghe tiuaala tani tturuu tau ngaiesoa ngatoa. Ghe kupikupi kateva kateva ale me ghe kunekune velu ghoa taita me vause atoa me ghe laa ghaatokaila sso tale ale mata voovoo. ");
INSERT INTO emi_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Lo atoa laghe ilou reerekataa seela laghe poppooaa inangarina ateva Iesu ta kona laghe laolao. ");
INSERT INTO emi_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilipi ghe lao sio tale kateae masaliki taatara eSameria me ghe ppooaala Mesaea etaira. ");
INSERT INTO emi_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Oroi ila taumattu ngatoa nau eteva laghe nongola inangarina Pilipi, me laghe tarala niaimatootoongana ghe gheleila me laghe nongo amasinaailiila inangari ghe auliaala. ");
INSERT INTO emi_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Laghe tarala Pilipi ghe tiu vella raroai etoa tale oroi taita me vause. Raroai etoa laghe aaore anamuu nau eteva laghe kupikupi vulu ghoa taumattu ngatoa. Me oroi ila lo atoa vilikiira matena me tangorengorena laghe masinala. ");
INSERT INTO emi_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Isaa avalua o me paka nimasimasi eteva ghe lutula elome tale ia o masaliki taatara ateae. ");
INSERT INTO emi_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kateva taumattu ghe tokatoka elome tale masaliki taatara ateae, ararina ateae ta Saemon, muennaaili ia tani ghelei nialaala. ASameria ngatoa laghe soosoghiaa voto laghe taatara ta ghe gheeghelei, me ghe saasaea nannaa va ia namuu ia. ");
INSERT INTO emi_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tau ngaitoitoi etoa me nim taumattu ngatoa, ila akapa laghe nongonongo inangarina, me laghe ue va, “Taumattu ngateva oia sarasarakaniaa ngepona liu namungaili etana.” ");
INSERT INTO emi_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Laghe nongonongoa poli oroiaata laghe soosoghiaa nialaala ghe gheelei. ");
INSERT INTO emi_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Me nau eteva Pilipi ghe poppooaa masi inangari tale ararimangalina ateva God me ararina ateae Iesu Karisto, lo atoa laghe aikaaiaa, taita atoa me vause atoa, laghe ghaala niaasuu. ");
INSERT INTO emi_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saemon ia tee eghe aikaaiaala me ghe ghaala niaasuu. Ghe aimuli teela Pilipi me ghe taatara kinatama niaimatootoongana me mirikolo Pilipi ghe gheelei me ghe soosoghiaa. ");
INSERT INTO emi_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nau apostolo atoa eJerusalem laghe nongola va aSameria ngatoa laghe aikaaiaala inangarina God, laghe suula Pita me Jon tani laa taraila. ");
INSERT INTO emi_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nau lalu ghe rekatala, lalu ghe looloo saela ta God va Spirit Manga ateva esio ta aSameria ngatoa, ");
INSERT INTO emi_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","poli Spiriti eteva karika ghe mae etaira. Laghe nim ghaala niaasuu tale ararina ateae Vau eteva Iesu. ");
INSERT INTO emi_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nau eteva lalu ghe ruula tani looloo sae, lalu ghe saoaala nimairarua etaira me laghe ghaala Spirit Manga ateva. ");
INSERT INTO emi_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saemon ghe tarala va apostolo alua lalu ghe saoaala nimairarua etaira me laghe ghaala Spiriti eteva. Liuna avalua o me eghe ghaala viliki veu me ghe laoaa sio etairarua, me ghe uela va, ");
INSERT INTO emi_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Amalu tau mae sarasarakana ateva ona tee etaghi, me arova asaoaa tee nimaghi ta toa taumattu, la rooroo tani ghaa Spirit Manga ateva.” ");
INSERT INTO emi_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pita ghe liula ta Saemon me ghe uela va, “Aue God eturungi eitauaa teeio me unem viliki veu, poli unannaa va upoli tale viliki veu voto God enim tautau mae. ");
INSERT INTO emi_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Karika righi uunguaam tale niuungu eteva oia, ta nannaam karika ghulughuluena ta matane God. ");
INSERT INTO emi_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Unna ngaioghioghiaa me uvelu sesa ninanna me ulooloo sae ta Vau ngepona ateva va marova ealoanna, aue ekkaluaa isaa o sesa ninanna tale urunguitanim ateva. ");
INSERT INTO emi_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ataatara va nannaam epasupasu tale nissaii, liuna avalua o ssavoto ateva ang ghele iri etokaiola.” ");
INSERT INTO emi_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Vara me Saemon ghe uela va, “Amalu looloo sae ta Vau ngepona ateva me amalu aulieinaghi sae me isaa o voto amalu auliaala erau mene lutu etaghi.” ");
INSERT INTO emi_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nau lalu ghe ruula tani ppooa ngaotu inangarina ateva Vau ngepona ateva, lalu ghe kiriaa saela eJerusalem, lalu ghe kasu poppooaa elaa saesae masi kiukiu tale oroi masaliki eSameria. ");
INSERT INTO emi_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kateva kapuna ensolo Vau ngepona ateva ghe uela ta Pilipi va, “Ukasu me ulao tale pai saot ativilau tale salana atikirighi karika righi taumattu etana, ia o salana atikirighi ekasukasu eJerusalem me esiosio eGaza.” ");
INSERT INTO emi_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Pilipi ghe tiuaala tani kasu, ghe laolao me ghe soula taumattu nge Itiopia ngateva, namuu ia, uunguaane tani aitara isaa akapaaili unna viliki veu Kandake, kuiini nge Itiopia ia. Ia o taumattu ngateva ghe saela tani kkaua eJerusalem, ");
INSERT INTO emi_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","me ghe oghiaala tani lao tanganuena, ghe tokatoka epona tale ai-ilou eteva, me ghe ritiriti vuku eteva ta propete ateva ta Aisaea. ");
INSERT INTO emi_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Me Spiriti eteva ghe uela ta Pilipi va, “Ulaa kasu karanga tale unna ai-ilou eteva.” ");
INSERT INTO emi_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Liuna avalua o me Pilipi ghe ilou lao sio tale unna ai-ilou eteva, me ghe nongola taumattu ngateva ghe ritiriti inangari tale vuku eteva ta propete ateva Aisaea. Me Pilipi ghe kolomiela va, “Vaalua, ukilakila llo ona uritiriti?” ");
INSERT INTO emi_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ghe uela ta Pilipi va, “Vaalua akila, nau eteva karika teva tani asaoki tau mae me akila? Lau sae mae tale ai-ilou eteva me usae toka teeieghi.” ");
INSERT INTO emi_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Namu ngateva ghe ritiriti inangari tale Uru ngai Manga ateva eue va, “Laghe ghaaie lao sio tani uvia nongina sipsipi eteva, me nonginaaili tee natu sipsipi erighi nau la ghaaloanna tani sunapi velu uuna tale vilikina, karika ghe otila paane ateva tani ppooaa righi inangari. ");
INSERT INTO emi_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Laghe gheleila ararina ateae ghe siola euu me ghe sesala. Karika laghe gheleie eghulughuluenala unna niaisakei eteae. Isaa avalua o me karika aue la kiukiuaa natuna atoa, poli laghe ruula maamauluaane tale kosa ateva.” ");
INSERT INTO emi_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Namu ngateva ghe kolomila Pilipi va, “Uauliaa etaghi va propete ateva oia ghe aauliaa see? Eaulieinia, o mene kateva ppae taumattu?” ");
INSERT INTO emi_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Vara me Pilipi ghe otila paane ateva me ghe tiuaala tani auliaa isaa o inangari tale Uru ngai Manga ateva me ghe auliaala masi kiukiuna Iesu etana. ");
INSERT INTO emi_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Lalu ghe iilou elaolao tale salana atikirighi me lalu ghe rekatala tale ateo ateae, me ghe uela namu ngateva oia va, “Tarala, ateo ateae o. Vaalua, karika urooroo tani asuueghi?” ");
INSERT INTO emi_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Namu ngateva ghe auliaala ta lo ateva ghe iilouaa ai-ilou eteva va etoka mua. Pilipi me namu ngateva lalu ghe kkure siola me lalu ghe siola tale ateo ateae me Pilipi ghe asuuela. ");
INSERT INTO emi_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nau eteva lalu ghe lau sae mae tale ateo ateae, kapuna Spiriti eteva Vau ngepona ateva ghe ghaala Pilipi me ghe kasueiniela. Namu ngateva ghe tam mene tara poila Pilipi. Ghe pasula tale nimasimasi poli ghe aiesoaala ta God, me ghe lao sio tanganuena. ");
INSERT INTO emi_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilipi ghe rekataala tale masaliki taatara ateae eAsotus, me ghe kasu ekapa seela tale mene kasina masaliki tani ppooaa masi inangari lomosi ta ghe laa rekata sio eSiisaria. ");
INSERT INTO emi_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Tale isaa o nau Sol ghe kakkalui tani uvi emate lo atoa laghe aaimuli tee Vau eteva. Liuna avalua o me ghe lao sio tani tara namu ngateva ta pristi etoa, ");
INSERT INTO emi_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","me ghe kolomiela va epiti uru ngai me Sol esau sio ta namu ngatoa tale ale nivelu eitaua ngakapaaili eDamaskas. Me uru ngai eauliaa va arova Sol etara lo atoa, taita me vause, la uusilaa salane Iesu, aue ekuneila me esaeainila tale ale mata voovoo ateva eJerusalem. ");
INSERT INTO emi_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nau Sol ghe kasu vulila eJerusalem me ang ghe kalakalaa eDamaskas me arovaeaata nonga ta mallanga ateva ghe sio mae epona liu me ghe akouela. ");
INSERT INTO emi_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Me Sol ghe katuu siola tapaa kosa me ghe nongola lingi ngalo ateva ghe uela va, “Sol, Sol, vaalua me ugheelei saasakieinaghi?” ");
INSERT INTO emi_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Me Sol ghe kolomila va, “Namu ngateva, io see?” Lingi ngalo ateva ghe liula me ghe uela va, “Aghi Iesu ugheelei saasakieinaghi. ");
INSERT INTO emi_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Totula me usso tale masaliki taatara ateae me aue uso kila sa ateva aue ugheleia.” ");
INSERT INTO emi_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Taita atoa laghe kasukasu tee Sol laghe matautu etinginala me karika righi nisama etaira. Laghe nongola lingi ngalo ateva me karika laghe taatara teva taumattu. ");
INSERT INTO emi_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol ghe totu saela tapaa kosa me nau ghe otila matane karika ghe roola tani tara teva voto. Liuna avalua o me laghe kunela nimane me laghe katulainie ssola eDamaskas. ");
INSERT INTO emi_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kotolu nau ghe mata salusalula me karika ghe namanamala me karika ghe ropi poila. ");
INSERT INTO emi_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kateva disaepolo eDamaskas, ararina ateae ta Ananaeas, Iesu ghe sama teeiela tale nitaatara ateae, ghe uela etana va, “Ananaeas!” Ananaeas ghe liula me ghe uela va, “Ue Vau eteva, aghi toko.” ");
INSERT INTO emi_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Me Vau eteva ghe uela etana va, “Aimanomanosiaala me ukasu lao tale salana atikirighi la kolokoloa va Ghulughuluena etana, me tanganuena Jiudas ukolomi taumattu ngateva atala nge Tases ia, ararina ateae ta Sol. Ia okae esso looloo sae, ");
INSERT INTO emi_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","me tale nitaatara ateae Sol ghe tarala taita ateva ararina ateae ta Ananaeas ghe kupi ssola me ghe saoaala nimane etana me matana ghe mene taatarala.” ");
INSERT INTO emi_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaeas ghe liula me ghe uela va, “Vau eteva, oroi taumattu ghe auliaala etaghi kiukiuna Sol me voto sesa ghe gheleila ta kapum taumattu ngatoa eJerusalem. ");
INSERT INTO emi_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Me ghe sio mae oia eDamaskas ta ghe ghaala matuutuliena ta namu ngatoa ta pristi etoa tani kune lo atoa la kolokolo tau ararim ateae.” ");
INSERT INTO emi_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Vau eteva ghe uela ta Ananaeas va, “Lao sio poli ngaghe suitoongainiela va ia aue eghelei uunguaaghi tani aulia ngaotu ararighi eteae ta taumattu ngeleka atoa me kingi etoa me taumattu nge Israeli tee atoa. ");
INSERT INTO emi_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Aue aghapasunga etana va aue etani ghaa oroi nimmarikana ta poli ararighi eteae.” ");
INSERT INTO emi_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Vara me Ananaeas ghe lao sio me ghe ssola tale ale ateva Sol ghe tokatoka etana me ghe saoaala nimane ta Sol me ghe uela va, “Nengaghi Sol, Vau eteva esungieghila, ia o Iesu etana ghe aotuotula etam etapaa salana nau ughe mae siosio. Esungieghi mae sio etam va io urooroo tani mene taatara, me aue upasu tale Spirit Manga ateva.” ");
INSERT INTO emi_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Arovaeaata nonga ta llo arova vaka kko ghe kao vella ta matane Sol me ghe mene taatarala. Ghe totu saela me ghe ghaala niaasuu. ");
INSERT INTO emi_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Me nau eteva ghe namanamala me ghe mene sarasarakanala. Sol ghe mene tokala kasina nau tee disaepolo atoa eDamaskas. ");
INSERT INTO emi_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Arovaeaata ta ghe tiuaala tani ppooaa Iesu tale aleira ale nivelu eitauaa, ghe aaulia ngaotu va Iesu Natuna ia God. ");
INSERT INTO emi_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Taumattu ngakapa atoa laghe nongola me laghe soghieiniela me laghe aippooaa elome etaira va, “Ia oia taumattu ngateva ghe uviuvi lo atoa eJerusalem la kolokolo tau ararina ateae Iesu. Me ghe sio mae oia tani kune tau ngaiesoa ngatoa va esaeainila ta namu ngatoa ta pristi etoa.” ");
INSERT INTO emi_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Me nau eteva Sol ghe poppooaa inangarina ateva Iesu, ghe tuttukueili aJiu etoa laghe tokatoka eDamaskas, me laghe soghiaala me karika laghe roola tani kaili ekamena va Iesu Mesaea ia. ");
INSERT INTO emi_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Oroi nau ghe lange sio me aJiu etoa laghe velu eitauaala me ngila ghe loeloe Sol tani uvi ematea. ");
INSERT INTO emi_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Me karika, ta Sol ghe kilala voto laghe loela. Ellaa me eleivoo laghe lollosainia tale isaa akapa paa ngatamana elome tale masaliki taatara ateae tani uvi ematea. ");
INSERT INTO emi_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kateva eleivoo, kapuna disaepolo atoa Sol laghe ghaala kinatama keru eteva me laghe kaaila Sol me laghe rekatila uasa eluekirighi, me laghe taue siola eleka tale valata me ghe kasula. ");
INSERT INTO emi_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nau eteva Sol ghe rekatala eJerusalem ghe tootoonga tani lao aitauaa tee disaepolo atoa, me ila akapa laghe maamatautainia ta karika laghe aaiesoaa va Sol ang ghe disaepolola. ");
INSERT INTO emi_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Vara me Banabas ghe mae sio tani sausia. Ghe ghaala Sol me ghe laoainie sio ta apostolo atoa tani aulia ngamasalika etaira vaalua Sol ghe tarala Vau eteva etapaa salana me Vau eteva ghe sama teeiela, me ghe mene lao tee sio tani auliaa vaalua Sol karika ghe maamatautu tani ppooaa tale ararina ateae Iesu eDamaskas. ");
INSERT INTO emi_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Liuna avalua o me Sol ghe toka aitauaa teeilala me ghe kasukasu ekapa see eJerusalem me karika ghe maamatautu tani ppooaa tale ararina ateae Vau eteva. ");
INSERT INTO emi_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sol me lo atoa aJiu ila la samasama nge Grik laghe aissakeanaala me ngila ghe loeloe tani uvi ematea. ");
INSERT INTO emi_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nau katoa disaepolo laghe kilala, laghe sioaala Sol eSiisaria me laghe sungie lao sio eTases. ");
INSERT INTO emi_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Liuna avalua o me ale manga akapaaili eJiudia, eGalilii me eSameria laghe tokala tale luei me Spirit Manga ateva ghe akorokoronganailala tani toka me tani tau sae Vau eteva, me ghe aisausieinilala me laghe oroieili ila. ");
INSERT INTO emi_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nau Pita ghe kasu ekapa seela ghe lao tee sio eLida tani tara katoa kapuna taumattu God laghe tokatoka okae. ");
INSERT INTO emi_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Isaa eLida me ghe tarala taumattu ngateva ararina ateae ta Aenias tangorengorena ia me ghe asola tale komo ghaoaluae (8) ninamanama. ");
INSERT INTO emi_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita ghe uela etana va, “Aenias, Iesu Karisto aue eghelei emasinaio. Totu saela me ughou komom.” Arovaeangaili ta Aenias ghe totu saela. ");
INSERT INTO emi_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Taumattu ngakapa atoa laghe tokatoka eLida me eSeron laghe taraiela me laghe tiuaala tani aiesoaa ta Vau ngepona ateva. ");
INSERT INTO emi_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Isaa eJopa kateva disaepolo vause ia ararina ateae ta Tabita (tale aseasea nge Grik, Dokas, malloeana va, kateva ghaata kkena la aseasea va dia). Tale nau ekapaaili ghe gheelei masi niuungu me ghe saasausi taumattu karika righi peiira. ");
INSERT INTO emi_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tale isaa o nau Pita ghe tokatoka eLida, me Tabita ghe isikila me ghe matela. Laghe suusiela me laghe saeainiela tale ale ngepona atiulu. ");
INSERT INTO emi_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","EJopa kalakalangina ia eLida, liuna avalua o me nau disaepolo atoa laghe nongola va Pita eLida, laghe suula taumattu ngalua tani laa kolo Pita va emae parasi. ");
INSERT INTO emi_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Isaa arau o Pita ghe usilaluela. Nau lotolu ghe rekatala eJopa lotolu ghe saela epona tale ale ngepona atiulu me ghe tarala vause atoa raue vulu ila pasueili ila tale ale atiulu, me laghe tiitingina emua ta Pita me laghe ngangngala, me laghe aapasunga ghinna Dokas ghe gheleila nau maulue ia. ");
INSERT INTO emi_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita ghe sungi vella ghoala eleka me ghe suuiaala tani looloo sae. Vara me ghe taatara lao sio tale vause ateva matena ia me ghe uela va, “Tabita, totu saela.” Tabita ghe otila matane, me nau ghe tarala Pita me ghe totu etokala. ");
INSERT INTO emi_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita ghe posola nimane atelange me ghe sausiela tani tingina sae. Vara me ghe kolola vause atoa raue vulu ila tee mene katoa tau ngaiesoaa me ghe tau lao sio Tabita etaira maulue ia. ");
INSERT INTO emi_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kiukiu ghe rooaala eJopa me oroieili taumattu ghe aikaaiaala ta Vau ngepona ateva. ");
INSERT INTO emi_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita ghe mene tokala oroi nau eJopa tee taumattu ngateva ararina ateae ta Saemon uunguaane tani kuluki viliki ghaata kkena tani ghelei mene kasina asease voto. ");
INSERT INTO emi_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Isaa eSiisaria, taumattu ngateva, ararina ateae ta Konilies, ghe tokatoka. Ia kateva namuu ghe muemuaa kateva ai (100) tau ngai uvii tale Kohot ateva laghe aseasea va Kohot nge Itali ia. ");
INSERT INTO emi_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ia me vausenna ateva me natuna atoa laghe aikaaiaa ta God me laghe oneoneainia. Ghe tautau lao voto tale taumattu karika righi peiira me ghe looloo sae ta God nau ekapa atoa. ");
INSERT INTO emi_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kateva nau ta 3 kilok elo alai ghe tarala kateva nitaatara. Ghe tarala kapuna ensolo ateva God ghe mae sio etana me ghe uela etana va, “Konilies!” ");
INSERT INTO emi_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Konilies ghe taatara lao sio etana me ghe matautula me ghe uela va, “Vau eteva, vaalua?” Me ensolo ateva ghe uela etana va, “Unem nilooloo sae me masi uunguaam tale taumattu karika peiira, God ghe masimasiaala. ");
INSERT INTO emi_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ghaine usuu righi taumattu tani lao eJopa me la laa kolo taumattu ngateva Saemon la kolokoloa va Pita etana. ");
INSERT INTO emi_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Etokatoka tee mene kateva Saemon uunguaane tani kuluki viliki ghaata kkena tani ghelei mene kasina asease voto, me alena ateva etokatoka kalakalangina ghoa elamana.” ");
INSERT INTO emi_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nau ensolo ateva ghe kasula, me Konilies ghe kolola ghalua tana kapuna tau ngai nongonongo anna me kateva kapuna tau ngai uvii ie tee ghe aaiesoaa ta Vau ngepona ateva, ");
INSERT INTO emi_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","me ghe aulia ngakapala voto ghe lutula me ghe sungilotolla me laghe lao sio eJopa. ");
INSERT INTO emi_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mene kateva elo sinaka, nau ngila ghe kalakalangina tale masaliki taatara ateae eJopa, me Pita ghe saela epona tale ale ateva tani looloo sae. ");
INSERT INTO emi_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ghe maamaloo me ghe anna tani nama righi inana. Nau laghe aaimonomonosiaa inana me ghe tarala nitaatara ateae. ");
INSERT INTO emi_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ghe tarala epona liu ghe otiela me ghe tarala voto ateva namuu ia nongina tiulu kalio reerekati aighoughouna ghaata me ghe sio mae tale kosa ateva. ");
INSERT INTO emi_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Elome etana asease ghaata kkena atoa me llo erarraa euu me ghila atoa la looloo elomarase. ");
INSERT INTO emi_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Vara me lingi ngalo ateva ghe uela va, “Pita! Totu saela me ughuvi emate llo me unama.” ");
INSERT INTO emi_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pita ghe liula me ghe uela va, “Karika poi arooroo, Vau ngepona ateva! Karika poi aghe nama righi voto karika raarangisana.” ");
INSERT INTO emi_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Lingi ngalo ateva ghe mene mae sio ghaluene etana me ghe uela va, “Urau mene ue va karika raarangisana llo God ang ghe ghelei eraarangisanala.” ");
INSERT INTO emi_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ghe lutula kotoluaata vara me arovaeaata ta kalio atiulu ghe mene saela epona liu. ");
INSERT INTO emi_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nau Pita ghe annaa poi va saa malloeana ia o nitaatara ateae me taumattu Konilies ghe suula laghe tarala alena ateva Saemon me laghe tingina ssola tapaa ngatamana. ");
INSERT INTO emi_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Laghe kolokolola me laghe kolomila va, “Saemon Pita etokatoka oia?” ");
INSERT INTO emi_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita karika ghe ruu tani nnaa nitaatara ateae me Spiriti eteva ghe uela etana va, “Saemon, taumattu kotolu lotolu paepaeo. ");
INSERT INTO emi_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tingina saela me usio tarailotolu me urau mene rati tani usilotolu ta aghi asungilotolula.” ");
INSERT INTO emi_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pita ghe siola me ghe uela ta taita kotolu va, “Aghi oia, am paepaeaghi. Vaalua me am mae sio?” ");
INSERT INTO emi_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Taita kotolu lotolu ghe liula va, “Ami kasula tanganue Konilies, kateva namuu, tau ghulughuluena ia me eoneoneaa God. Taumattu nge Jiu ekapa atoa la oneoneainia. Ensolo manga ateva ghe auliaala etana va ekoloo me ulao tanganuena me ulaa ghauliaa saa llo voto aue uauliaa me aue enongo.” ");
INSERT INTO emi_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pita ghe uela etairotolu va, “Ita ghaso.” Ghe pai saela ta mene kateva nau, me Pita me mene katoa tau ngaiesoa nge Jopa laghe usila taita kotolu me laghe kasula. ");
INSERT INTO emi_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Vara aiaaghaluene ateva nau, laghe rekataala eSiisaria. Konilies ghe kolo aitauaala mangalina atoa me kapuna atoa, me laghe toitoi Pita. ");
INSERT INTO emi_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nau eteva Pita ghe maemae, Konilies ghe souela me ghe suuiaala ta liue kkena tani oneoneainia. ");
INSERT INTO emi_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pita ghe kune atinginaie saela me ghe uela etana va, “Tingina saela! Aghi nim taumattu ieghi nongina io.” ");
INSERT INTO emi_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nau lalu ghe samasama, me lalu ghe kupi ssola me Pita ghe tarala oroi taumattu ngatoa ngila ghe velu eitauaala. ");
INSERT INTO emi_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ghe uela etaira va, “Am kilakilaaili uneimami inangari nipaopao va aJiu etoa karika la rooroo tani aighui tee tau ngeleka atoa me tani laa taraila. Me God ghe apasungaala etaghi va karika amene ue va kasina taumattu karika raarangisana. ");
INSERT INTO emi_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Liuna avalua o me nau eteva am ghe suula inangari etaghi va amae, karika aghe ratila tani mae. Erooroo va am auliaa vaalua me am ghe uela va amae?” ");
INSERT INTO emi_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konilies ghe liula me ghe uela va, “Kotolu nau ang ghe lange sio, aghe tokatoka tanganueghi me ta 3 kilok elo alai, nongina ghaine, aghe looloo sae me taumattu ngateva ghinnanina ghe maamallanga ghe tinginala emua etaghi. ");
INSERT INTO emi_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Me ghe uela etaghi va, ‘Konilies, unem nilooloo sae me masi uunguaam tale taumattu ngatoa karika peiira, God ghe masimasiaala. ");
INSERT INTO emi_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Usungi righi taumattu elao ta Saemon Pita eJopa etokatoka tanganuena Saemon uunguaane tani kuluki viliki ghaata kkena tani ghelei mene kasina asease voto, me alena ateva etokatoka akalakalangina ghoa elamana.’ ");
INSERT INTO emi_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Liuna avalua o me arovaeaata ta aghe suula inangari etam me masinaaili etam ta angu mae sio. Vau ngepona ateva aue etoka aitauaa teeita nau eteva uauliaa sa ateva ghe sungiola tani mae aulieinia me ami nongoa.” ");
INSERT INTO emi_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Vara me Pita ghe tiuaala tani aippooaa, ghe uela va, “Ghaine ngatarala va koronna God karika eaaimassiaa. ");
INSERT INTO emi_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Me tale isaa akapaaili patunganua namuu, God ealoanna lo atoa la oneoneaa nonga God, me la gheelei voto masina. ");
INSERT INTO emi_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Am kilakila inangarina God ghe suula ta taumattu nge Israeli etoa, masi inangari va luei ekasu ta Iesu Karisto, ia Vau ia tale ila akapaaili taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Am kilakila sa ateva ghe ailutuaala eJiudia. Jon ghe aippooaa tale niaasuu eteae, me emulina, Iesu ghe tiuaala tani uungu eGalilii. ");
INSERT INTO emi_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Me am kilakila vaalua God ghe tau lao sio Spirit Manga ateva me sarasarakana ta Iesu aNasareti ia, me vaalua ghe kasu ekapa seela me ghe gheeghelei masi niuungu me ghe gheeghelei emasina lo atoa taumattu sesa taumattu ngateva ghe ghelei saasakieinilala, ta poli God ghe tokatoka teeia. ");
INSERT INTO emi_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Ami, ami ghe tara akapala voto ghe gheleila tale masalikiira aJiu etoa me eJerusalem. Laghe avukalaie saela tale ai eteae tani uvi ematea. ");
INSERT INTO emi_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Tale aiaakotonna ateva nau, God ghe totuela tale nimate va taumattu ngatoa la taraia. ");
INSERT INTO emi_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Karika va ila akapa taumattu ngatoa laghe taraiela ta llo nonga atoa God ang ghe suitoongainilala. Nau ghe totula tale nimate, ami, ami ghe namanama me ami ghe ropi teeiela. ");
INSERT INTO emi_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ghe uela etaimami va ami ppooaa ta taumattu ngatoa me aulia ngaotu etaira va ia God ghe suitoongainiela va eghelei niaisakei ta lo atoa sakesake ila me lo atoa matena ila. ");
INSERT INTO emi_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ila akapa propete atoa laghe aaulieinia va lo atoa la ghaiesoaa etana God aue ekkaluaa kaluira ssavoto tale ararina ateae Iesu.” ");
INSERT INTO emi_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nau eteva Pita ghe poppooaa isaa o inangari me Spirit Manga ateva ghe sio mae ta lo akapa atoa laghe nongonongo isaa o inangari. ");
INSERT INTO emi_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tau ngaiesoa ngatoa isoisona ila laghe mae aitauaa tee sio Pita laghe soghila tani tara va Spirit Manga ateva ghe sio mae tee ta taumattu ngeleka atoa. ");
INSERT INTO emi_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Laghe nongolala ta laghe aippooaa tale asease nisama karika samasama tanganueira me tee laghe tautau sae God. Me Pita ghe uela va, ");
INSERT INTO emi_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Teva erooroo tani ue va isaa oia taumattu erau mene ghaa niaasuu tale manu? Poli ngila ghaala Spirit Manga ateva nongina ita.” ");
INSERT INTO emi_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Me Pita ghe uela va la ghaa niaasuu tale ararina ateae Iesu Karisto. Me laghe kolomila Pita va emene toka teeila mua mene righi nau. ");
INSERT INTO emi_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Vara me apostolo atoa me tau ngaiesoa ngakapa atoa eJiudia laghe nongola va taumattu ngeleka atoa tee laghe aikaaiaala inangarina ateva God. ");
INSERT INTO emi_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Liuna avalua o me nau Pita ghe saela eJerusalem lo atoa isoiso ila tau ngaiesoaa ila laghe sama anamuu teeiela, ");
INSERT INTO emi_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","me laghe ue va, “Io ughe lao sio tanganueira lo atoa karika isoiso ila me ughe namanama teeilala.” ");
INSERT INTO emi_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Me Pita ghe tiuaala tani aulia ngamasalika saa voto ghe lutula. ");
INSERT INTO emi_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Aghe tokatoka tale masaliki taatara ateae eJopa me aghe looloo sae me aghe tarala nitaatara ateae. Aghe tarala voto ateva namuu ia nongina tiulu kalio reerekati aighoughouna ghaata me ghe kasula epona liu me ghe sio mae nongina aghe tokatoka. ");
INSERT INTO emi_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nau aghe taatara ssola elome tale kalio atiulu aghe tarala asease ghaata kkena atoa, lo atoa ita aaitarainila me lo atoa karika ita aaitarainila, me llo erarraa euu me ghila atoa la looloo elomarase. ");
INSERT INTO emi_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Vara me aghe nongola lingi ngalo ateva ghe ue etaghi va, ‘Pita, utotu me ughuvi emate llo me unama.’ ");
INSERT INTO emi_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Aghe liula me aghe uela va, ‘Karika poi, Vau ngepona ateva! Karika poi aghe nama righi voto karika raarangisana.’ ");
INSERT INTO emi_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Lingi ngalo ateva ghe mae sio epona liu ghe mene aippooaala ghaluene me ghe uela va, ‘Urau mene ue va karika raarangisana llo God ang ghe ghelei eraarangisanala.’ ");
INSERT INTO emi_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Llo oia ghe lutula kotoluaata me isaa akapa llo ghe mene saela epona liu. ");
INSERT INTO emi_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Karika masau me taita kotolu laghe sungilotolla eSiisaria tani mae taraieghi, lotolu ghe mae sio tale ale ateva ami ghe tokatoka etana. ");
INSERT INTO emi_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Me Spiriti eteva ghe uela etaghi va, ‘Urau mene rati tani usilotolu ta aghi aghe sungilotolla,’ me isaa toko ghaonomo (6) kapughu laghe usieghila ami ghe kupi ssola tale alena ateva taumattu ngateva. ");
INSERT INTO emi_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ghe auliaala etaimami vaalua ghe tarala ensolo ateva ghe lao sio tanganuena me ghe uela va, ‘Suula inangari ta Saemon la kolokoloa va Pita etana, ia eJopa. ");
INSERT INTO emi_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ia aue emaeaa inangari egheleio me lo atoa tee tanganuem aue am saanga.’ ");
INSERT INTO emi_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Nau eteva aghe tiuaala tani aippooaa, Spirit Manga ateva ghe sio mae etaira nongina ghe sio mae etaita nau ta Pentikos. ");
INSERT INTO emi_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Me aghe annaala sa ateva Vau ngepona ateva ghe aulieiniela nau ghe uela va, ‘Jon ghe aasuu taumattu tale manu me am aue am ghaa niaasuu tale Spirit Manga ateva.’ ");
INSERT INTO emi_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Liuna avalua o me poli God ghe tau lao sio kateva nonga ia voto ateva karika ita polipolia nongina ang ghe taue mae sio etaita lo atoa ita aikaaiaa ta Iesu Karisto, aghi tee karika arooroo tani ghelei runga uunguaane God.” ");
INSERT INTO emi_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nau eteva laghe nongo avaluela o karika laghe mene auliaala righi voto. Ta ngila ghe nim tautau sae God me laghe ue va, “God ange tau lao sio ninna ngaioghioghiaa ta taumattu ngeleka atoa va la kiri mae etana me la saanga.” ");
INSERT INTO emi_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nau eteva lo atoa laghe ilou reerekata seela nau laghe uvi ematela Stipeni, laghe lao sio arau tale distriki eteva ePoenisia me patunganua ateva eSaeprasi me tale masaliki taatara eAntiok tale provinsi eteva eSiria me laghe poppooaa ta aJiu nonga atoa. ");
INSERT INTO emi_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Katoa etaira atala nge Saeprasi ila me tale masaliki taatara ateae eSaerini laghe lao sio eAntiok me laghe tiuaala tani ppooaa ta aGrik tee atoa. Laghe aauliaa masi inangarina Vau eteva Iesu. ");
INSERT INTO emi_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Sarasarakaniaane Vau eteva ghe tokatoka teeila, mausina avalua o me oroieili taumattu ghe aikaaiaala me laghe kiri mae sio ta Vau eteva. ");
INSERT INTO emi_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tau ngaiesoa ngatoa eJerusalem laghe nongola voto o me laghe suula Banabas tani lao eAntiok. ");
INSERT INTO emi_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nau eteva ghe rekatala me ghe tarala vaalua maamasinaane God namungaili, ghe masimasieiliila me ghe asarasarakanailala tani toka akorokorongana ta Vau eteva tale urunguitaniira. ");
INSERT INTO emi_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ia masi taumattu ia me pasu ia tale Spirit Manga ateva me korokorongana ia tale niaikaaiaa, me oroieili lo atoa laghe mene sso mae tani aimuli tee Vau eteva. ");
INSERT INTO emi_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Vara me Banabas ghe lao sio eTases tani pae Sol. ");
INSERT INTO emi_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nau eteva ghe taraiela ghe koloala me ghe laoainie sio eAntiok. Tale kasangaulu ghalua (12) ulana lalu ghe toka teela ale manga atoa me lalu ghe aapasunga inangarina ateva God ta oroi taumattu ngatoa. Me isaa eAntiok laghe ase akasinala disaepolo atoa va Kristen ila. ");
INSERT INTO emi_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tale isaa o nau katoa propete laghe kasula eJerusalem me laghe sio mae eAntiok. ");
INSERT INTO emi_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Kateva etaira, ararina ateae ta Agabas, ghe tinginala tale korokoronganiaane Spiriti eteva me ghe aulia ngaotula va maloo ateva sesaaili ia aue erooa ngakapa kosa ateva, me nau Klaodies Siisa ghe aaitoiaa eRom, maloo ateva ghe lutula. ");
INSERT INTO emi_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nau laghe nongola inangarina Agabas, laghe annaala va la sausi lo atoa eJiudia, me kateva kateva ta disaepolo atoa laghe aisokosokoiaala viliki veu tale aloannaaira. ");
INSERT INTO emi_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Banabas me Sol lalu ghe ghaala viliki veu me lalu ghe laoaa sio ta namu ngatoa tale ale manga eJerusalem. ");
INSERT INTO emi_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Isaa o nau king Herot ghe tiuaala tani kune katoa tale ale manga, tani ghelei saasakieinila. ");
INSERT INTO emi_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ghe auliaala me laghe sai pulela alona atiulu Jeimis tuena Jon tale baenata ateva. ");
INSERT INTO emi_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nau Herot ghe tarala va aJiu etoa laghe masimasiaala llo ghe gheleila, me ghe mene auliaala me laghe mene kunela Pita, tale nau nivelu eitaua ngateae tani nama verete karika righi isti etana. ");
INSERT INTO emi_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ghe atoka ssola Pita tale ale mata voovoo me ghe atinginala kasangaulu ghaonomo (16) soldia laghe aaikoli tani aitoieinia, ghaata mua soldia ta kateae nitoitoi. Herot ghe anna va eaisakei tale tummatavanga nau Pasova eruu. ");
INSERT INTO emi_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nau Pita ghe tokatoka tale ale mata voovoo me tau ngaiesoa ngatoa tale ale manga laghe looloo asarasarakana sae ta God va esausia. ");
INSERT INTO emi_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ia o voo ngateva me ghe pai Herot ghe atinginaia emua ta mata ngoroi etoa me ghe aisakei, Pita ghe aseasekanua ta mallomeirarua soldia ngalua iriiri ia tale sene alua, me mene ghalua soldia lalu ghe aaitoiaa atamana ateae. ");
INSERT INTO emi_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Vara me kapuna ensolo ateva Vau ngepona ateva ghe rekatala me mallanga ateva ghe lutula tale ale mata voovoo me ensolo ateva ghe posola usuena ativilau Pita tani angunia me ghe uela etana va, “Totu parasila,” me sene alua lalu ghe kao vellaluela ta nimane. ");
INSERT INTO emi_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Me ensolo ateva ghe uela etana va, “Asaela ghinnanim me unem aikasukasu ta kkem.” Me Pita ghe gheleila llo ensolo ateva ghe auliaala. Vara me ensolo ateva ghe uela va, “Uasae unem aiaasae ngeleka ateva me uaimuli teeieghi.” ");
INSERT INTO emi_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Liuna avalua o me Pita ghe kasu vulila ale mata voovoo atiulu me ghe aimuli teela ensolo ateva. Ghe annaa va ghe nim asoasopoi. Karika ghe kilakila va isaa o voto ghe lutulutu ekoronna. ");
INSERT INTO emi_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Lalu ghe laula aitiutiu eteva soldia ghe toitoi atamana ateae me mene aiaaghaluene ateva me lalu ghe rekatala tale atamana ateae aeana ia tale ale mata voovoo tale ia o masaliki taatara ateae, me ia o atamana ateae ghe otiela, karika teva ghe otiela, me lalu ghe kupi ghoala. Lalu ghe kasu tee siola tale mene katikirighi salana, vara me arovaeaata nonga ta ensolo ateva ghe kasu vulila Pita. ");
INSERT INTO emi_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Vara me Pita ghe vira kilala sa ateva ghe lutula etana me ghe uela va, “Koronnaaili Vau ngepona ateva esuula kapuna ensolo ateva tani sio asaangieghi ta nimane Herot me voto aJiu etoa la ghanna tani ghelei etaghi.” ");
INSERT INTO emi_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ghe tinginala ghe nannaala mua me ang ghe laolao tanganue Meri kinna ia Jon, kateae ararina ta Mak, nongina oroi taumattu ghe veluvelu eitauaa tani looloo sae. ");
INSERT INTO emi_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ghe mirimirila tale atamani ngeleka ateae me vause ateva Roda etana tau ngai nongonongo anna ia ghe ghoa mae tani nongo. ");
INSERT INTO emi_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nau eteva ghe nongo kilala lingi ngalona ateva Pita ghe masimasi etinginala me karika ghe otila atamana ateae ta ghe ilou ssola elome me ghe uela ta taumattu ngatoa va, “Pita eleka tale atamana ateae eghoa tiitingina.” ");
INSERT INTO emi_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Me laghe ue teeiela va, “Angu veeveela?” Me nau ghe sarasarakana tani auliaa me laghe nnaala va, “Koti kapuna ensolo ateva okae.” ");
INSERT INTO emi_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pita ghe mene mirimirila me laghe ghoala tani oti atamana ateae me laghe soghiaala tani taraia. ");
INSERT INTO emi_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Me Pita ghe paopaola ta nimane va la rau mene sama, me ghe auliaala sa ateva ghe lutula me vaalua Vau ngepona ateva ghe ghaa velue ghoa mae tale ale mata voovoo, me ghe uela etaira va, “Am auliaa ta Jeimis me mene katoa kapuita, sa ateva ghe lutula.” Me ghe mene lao ppae sio. ");
INSERT INTO emi_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Vara ghe paila me soldia ngatoa nannaaira ghe aisavisavilaala me ngila ghe aaikolomieinila va, “Sa ateva ghe lutula ta Pita?” ");
INSERT INTO emi_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herot ghe uela va la laa paea. Nau eteva karika laghe roola tani taraia, ghe kolomila soldia ngatoa laghe aaitoieiniela, me karika laghe roola tani liu, me ghe uela va la uvi ematela. Vara me Herot ghe kasula eJiudia tani mene laa toka tau eSiisaria. ");
INSERT INTO emi_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herot ghe sessaia ta taumattu nge Taer me Saedon, me laghe aloannala luei etana, poli laghe ghaaghaa inana tale llo masaliki king ghe aaitaraa. Liuna avalua o me katoa etaira laghe mae aitauaa sio me laghe siola tani taraia. Laghe lao akasina sio ta Blastus, ia ghe aaitaraa tanganuena king, va ghe sausila, me laghe vira lao sio tani tara king. ");
INSERT INTO emi_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tale nau eteva laghe suitoongainiela, Herot ghe asaela ase aiaasae ateva tani apasunga va ia kingi ia me ghe tokala tale unna aitokatoka ateva uneira ia kingi etoa me ghe gheleila kateva niaippooaa ta taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Me taumattu ngatoa laghe aaore tani ue va, “Karika va lingi ngalo taumattu ia, ta lingi ngalo goto ia.” ");
INSERT INTO emi_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Arovaeaa nonga ta kapuna ensolo ateva Vau ngepona ateva ghe taula sessa ateva etana me ttoliti etoa laghe nama amateala, poli taumattu ngatoa laghe kaakaueinia tani arueinia me karika ghe tautau sae ararina ateae God. ");
INSERT INTO emi_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Me masi inangarina ateva God ang ghe laolao akapa see me ang ghe piipinosa anamuu. ");
INSERT INTO emi_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabas me Sol lalu ghe ruula uunguaairarua tani taula viliki veu eJerusalem me lalu ghe mene lao sio eAntiok me lalu ghe kolo teela Jon Mak. ");
INSERT INTO emi_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Tale ale manga ateva eAntiok katoa propete me tisa laghe aapasunga masi nitoka God ghe aloanna: Banabas, me Simion, mene kateae ararina ta Niger, me Lusias aSaerini ia, me Sol, me Manain, lalu ghe namu ngaitauaala me Herot, gavana ia. ");
INSERT INTO emi_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Kateva nau laghe kakkaua Vau ngepona ateva, me laghe naenae, me Spirit Manga ateva ghe uela va, “Am amanga Banabas me Sol me lalu ghelei niuungu eteva oia, aghe suitoongainilaluela tani gheleia.” ");
INSERT INTO emi_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Liuna avalua o me nau laghe mene naela me laghe looloo saela, me laghe saoaala nimaira etairarua, me laghe sungilaluela tani kasu. ");
INSERT INTO emi_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Spirit Manga ateva ghe sungi taulalue ghoala eSeleusia, lalu ghe aikaaila me lalu ghe lao sio tale patunganua ateva eSaeprasi. ");
INSERT INTO emi_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nau eteva lalu ghe rekatala tale masaliki taatara ateae eSalamis, lalu ghe ppooaala inangarina ateva God elome tale aleira ale nivelu eitauaa aJiu etoa. Jon Mak ghe toka teeilaluela tani sausilalua. ");
INSERT INTO emi_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Lotolu ghe kasu ekapa seela tale patunganua ateva me lalu ghe mae sio ePapos. EPapos lalu ghe tarala kateva aJiu, tau nighelei nialaala ia me propete kamekame ia, ararina ateae ta Bar-Iesu. ");
INSERT INTO emi_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ia oia taumattu ngateva ghe tokatoka tee gavana ngateva, ararina ateae ta Sejias Polus. Gavana tee alomasaanga ia. Ghe kolola Banabas me Sol ta ghe aaloanna tani nongo inangarina God. ");
INSERT INTO emi_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ia o ase taumattu ngateva ghe gheelei nialaala, tale inangari nge Grik la aseasea arariira ateae ta Elimas. Elimas ghe aloanna tani ghelei saasakiaa uunguaairarua Banabas me Sol, ta karika ghe aloanna va gavana ngateva eaiesoaa ta Iesu. ");
INSERT INTO emi_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Me Sol, mene kateae ararina ta Pol, pasu ia tale Spirit Manga ateva, ghe alumila Elimas me ghe uela va, ");
INSERT INTO emi_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Io natuna io Satana. Me tau ngai ssateeira io voto llo ghulughuluena! Me isaa akapa gheeleia nikamekame me ssavoto epasupasu etam. Erooroo va uruu tani ghelei saasakiaa salane Vau ngepona ghulughuluena? ");
INSERT INTO emi_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ghaine nimane atelange Vau ngepona ateva esae etam, me umata salusalu. Karika aue utara sinaka ateva me aue utoka mala ngaluse nau.” Pol ghe nim ruuruu poi tani auliaa me matane Elimas ghe saurorromienala me ghe mata salusalula me ang ghe paepae teva taumattu tani posoa me ekatulainia. ");
INSERT INTO emi_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nau eteva gavana ngateva ghe taraiela, ghe aiesoaala, me ghe soghiangailiila kanna niapasunga Vau ngepona ateva. ");
INSERT INTO emi_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol me kapuna atoa laghe kasu vulila ePapos, me anua ateva ghe kaailala me laghe lao sio tale masaliki taatara ateae ePerga tale provins ateva ePampilia. Me Jon Mak ghe oghi vululaluela me ghe oghi lao sio eJerusalem. ");
INSERT INTO emi_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Lalu ghe kasu vulila ePerga, me laghe kasu lao sio eAntiok elome ePisidia Distrik. Me ta nau manga ateva, laghe kupi ssola tale aleira ale nivelu eitaua ngateva aJiu etoa me laghe toka siola. ");
INSERT INTO emi_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Vara katoa laghe ruula tani riti inangari tale inangari nipaopao me propete atoa me namu ngatoa tale ale nivelu eitaua ngateva laghe suula inangari ta Pol me kapuna atoa va, “Kapuimami etoa, marova righi inangari niasarasarakana am aaloanna tani auliaa etaimami, masina am rooroo tani sso auliaa.” ");
INSERT INTO emi_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pol ghe tingina saela me ghe paolala tale nimane atelange va karika la mene toka samasama, me ghe uela va, “Am Israeli etoa me am tau ngeleka atoa am tautau sae ararina ateae God, am nongoaghi! ");
INSERT INTO emi_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Kapuira Goto ateva Israeli etoa, ghe suitoongaala tuvuita atoa va kapuna ila. Me nau eteva laghe kasu vulila kosaira me laghe siola eIjip, ghe gheleilala laghe oroienaailiila. Vara me tale sarasarakaniaane, ghe mene ghaa vellala eIjip. ");
INSERT INTO emi_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Me nau eteva laghe tokala tale voto ateva karika righi taumattu etana, karika ghe liula sesa ta ngetaira erooroo ghaatingauluae (40) ninamanama. ");
INSERT INTO emi_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ghe tturuula ghaitu (7) ararimangali nge Keinan, me ghe tau lao sio isaa o kosa va ekosaira kapuna atoa. ");
INSERT INTO emi_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Isaa akapa voto o ghe lutula erooroo ghaata ai me ghalimangauluae (450) ninamanama. “Vara me God ghe tau lao sio kapuira namu ngatoa tani aitarainila erooroo nau eteva propete Samuel ghe tinginala. ");
INSERT INTO emi_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Vara me taumattu ngatoa angila ghe kookolomi teva kingi, me God ghe tau lao sio Sol natuna ia Kish, tale ararimangali eteva ta Benjamin. Ghe aitarainilala ta ghaatingauluae (40) ninamanama. ");
INSERT INTO emi_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Vara ghe ghaa vella Sol, me ghe gheleila Deivit ghe kingila. Ghe auliaa tootoongaala va, ‘Ngatarala Deivit, natuna ia Jesi, ia lo ateva taumattu aghaloannaailiia tale urunguitanighi eteva. Ia aue eghelei ekapa voto aghaloanna va eghelei.’ ");
INSERT INTO emi_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Nongina God ang ghe auliaala tale inangari nialokoi, va ghe tau lao sio tau ngai asaangi eteva ta Israeli etoa, tuvuna ia Deivit, Iesu etana. ");
INSERT INTO emi_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Auena Iesu ghe mae, Jon ghe ppooaala ninna ngaioghioghiaa me niaasuu ta taumattu nge Israeli ekapa atoa. ");
INSERT INTO emi_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jon ang ghe maemae ta ghe ruu uunguaane, me ghe uela va, ‘Am annaa va aghi see etaghi? Karika va aghi Mesaea am toitoia. Karika, ia eaaimuli etaghi, me aghi karika tani masina aghi tani pulaka unna ai-iri aikasukasu ta kkena.’ ");
INSERT INTO emi_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Kapughu etoa, tuvuna atoa Abraham, me am tau ngeleka atoa am kakkaua God, God ghe tau mae sio isaa oia inangari niasaangi etaita! ");
INSERT INTO emi_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Taumattu nge Jerusalem atoa me kapuira namu ngatoa karika laghe tara kilala Iesu, aloira karika ghe masaangaala inangariira propete atoa isaa o laghe ritiriti tale isaa akapa nau manga, laghe ghelei roorooaala nau laghe uela va aue emate. ");
INSERT INTO emi_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Karika laghe tarala righi masi salana tani tingina etana me la uvi ematea, me laghe kolomila Paelat va la uvi ematea. ");
INSERT INTO emi_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nau eteva laghe ghelei ekapala voto Uru ngai Manga ateva ghe uela va la ghelei, laghe ghaa veluela tale ai eteae me laghe lao sio tani alokoie sso tale lienga niaikkaia ngateae. ");
INSERT INTO emi_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","God ghe mene totuela tale nimate ");
INSERT INTO emi_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","me oroieili nau, ghe otuotula ta lo atoa laghe kasu teeiela eGalilii tani sae eJerusalem nau maulue ia. Ila lo atoa laghe taraiela, ghaine la aaulia ngaotu ta kapuita taumattu ngatoa. ");
INSERT INTO emi_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Me angalu aauliaa masi kiukiu etaimim: Sa ateva God ghe aulieiniela tale inangari nialokoi ta tuvuita atoa ");
INSERT INTO emi_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ang ghe ghelei eroorooaala etaita, nau ghe totula Iesu. Nongina laghe piti elokoila ta aiaaghalua ateva Sam, va “‘Io natughu io, Ghaine nge tamami ieghila.’ ");
INSERT INTO emi_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Koronna inangari va God ghe totuela tale nimate, karika aue emene mate, nongina ghe auliaala tale isaa toko inangari, va “‘Aue atau aatu etaimim niarangise ateva manga ia me koronna ia tale inangari nialokoi aghe auliaala ta Deivit.’ ");
INSERT INTO emi_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nongina ghe auliaala tale mene kateva inangari va, “‘Karika aue utau velu kapum taumattu ngateva manga ia va emauu.’ ");
INSERT INTO emi_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Nau eteva Deivit ghe ruula tani ghelei uunguaane God tale unna ateva vituu, ghe matela; me laghe kaieiniela nongina tuvuna atoa me vilikina ghe mauula. ");
INSERT INTO emi_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Me lo ateva taumattu God ghe totuela tale nimate karika ghe mauula. ");
INSERT INTO emi_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Liuna avalua o, kapughu etoa, aghaloanna tani aulia ngaotu me am kila va ta Iesu, God aue ekkaluaa kaluita ssavoto. ");
INSERT INTO emi_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ta ngetana lo atoa la ghaikaaiaa aue egheleila va karika righi kaluira ssavoto. Isaa avalua o me inangari nipaopao kanna Moses karika erooroo tani asaangiem tale kaluimim ssavoto. ");
INSERT INTO emi_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Am paniem! Saa voto God ghe auliaala ta propete atoa erau lutu etaimim, laghe uela va, ");
INSERT INTO emi_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“‘Am tarala, lo atoa taumattu am aattara nonga tani sama, aue am soghiaa sa ateva aue agheleia, me aue am mate, Tale nau oia aue aghelei kasina voto, karika aue am nnaa va koronna, arongona ta marova kasina taumattu aue eauliaa poi etaimim!’” ");
INSERT INTO emi_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Nau eteva Pol me Banabas angilalu ghe kasukasu vuli ale nivelu eitaua ngateva, taumattu ngatoa laghe mene aloannailaluela va lalu mene ppooaa isaa oia voto tale lo ateva too nau manga. ");
INSERT INTO emi_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nau eteva lo atoa laghe mae sio tani velu eitauaa laghe kasu reerekatala, oroi aJiu etoa me mene katoa taumattu avirina laghe vira aiesoaala tee aJiu etoa, laghe usilaa Pol me Banabas. Lalu ghe tani aippooaa teeila tale inangari niaisausiaa tani poso parasi maamasinaane God. ");
INSERT INTO emi_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Tale mene kateva nau manga, ghaisa ngarighi me taumattu ngakapa atoa tale lo ateae o masaliki taatara laghe velu eitauaala tani nongo inangarina ateva Vau ngepona ateva. ");
INSERT INTO emi_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nau eteva aJiu etoa laghe tarala oroieili taumattu, me angila ghe nannaa saasakiaa me angila ghe aauliaa tee Pol me saa voto ghe aauliaa. ");
INSERT INTO emi_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pol me Banabas, karika lalu ghe matautula, lalu ghe liula me lalu ghe uela etaira va, “Ami tani ppooaa inangarina ateva God akasina etaimim. Ta am, am ghe ratiela me eaapasunga va God karika ghe suitoongainiemla tani ghaa maulue ateva etokatoka liu. Liuna avalua o, koti ami lao ta tau ngeleka atoa. ");
INSERT INTO emi_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Vau ngepona ghe uela ta kateva kateva etaingalua va, “‘Aghe gheleiola va io mallanga io ta taumattu ngeleka atoa, me urooroo tani sausila tani ghaa niasaangi tale kosa akapa ateva.’” ");
INSERT INTO emi_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nau eteva taumattu ngeleka atoa laghe nongola llo oia, laghe masimasieiliila me laghe tau saela inangarina ateva Vau ngepona ateva, me lo atoa God ghe suimatoongainilala va la ghaa maulue ateva etokatoka nau ekapa atoa, laghe aiesoaala. ");
INSERT INTO emi_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Inangarina ateva Vau ngepona ateva ghe rooa ngakapaailiila ia o voto ateva. ");
INSERT INTO emi_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Vara me aJiu etoa laghe ghelei saasakiaala nannaaira lo atoa vause laghe oneoneaa God me ila namuu ila, me lo atoa taita namuu ila tale lo ateae o masaliki taatara, me laghe tiuaala tani ghelei saasakiaa tee Pol me Banabas, me laghe tiu vellaluela tale ia o voto ateva. ");
INSERT INTO emi_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Lalu ghe rariaa vella au kosa ta kkeirarua tani apasunga va gheeleiaaira sesa. Me lalu ghe lao sio eIkoniam. ");
INSERT INTO emi_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Me disaepolo atoa eAntiok elome tale distriki eteva ePisidia laghe pasula tale nimasimasi me tale Spirit Manga. ");
INSERT INTO emi_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","EIkoniam Pol me Banabas lalu ghe mene gheleila uunguaairarua nongina lalu ghe gheelei eAntiok elome tale distriki eteva ePisidia. Lalu ghe ssola tale aleira ale nivelu eitaua ngateva aJiu etoa me lalu ghe aippooaala me tale poppooaairarua sarasarakanaaili, oroieili taumattu ngatoa aJiu ila me aGrik ila laghe aiesoaala. ");
INSERT INTO emi_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Katoa tana aJiu karika laghe aikaaiaala laghe tau lao sio sesa ninannaa ta katoa tana taumattu ngeleka me laghe ghelei esessaila tau ngaiesoa ngatoa. ");
INSERT INTO emi_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Lalu ghe tokala oroi nau eIkoniam me karika lalu ghe maamatautu tani aulia ngaotu Vau ngepona ateva, me Vau eteva ghe tau lao sio sarasarakana etairarua me lalu ghe gheleila oroieili ase niaimatootoongana me mirikolo atoa, me tale isaa o voto lalu ghe gheelei, Vau eteva ghe aapasunga ta taumattu ngatoa va voto o lalu ghe aulia ngaotu tale maamasinaane koronna akapa. ");
INSERT INTO emi_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Me taumattu tale ia o masaliki taatara ateae ghe ghalua atokailala; katoa laghe lao aitauaa tee sio aJiu etoa, me katoa laghe lao aitauaa tee sio apostolo alua. ");
INSERT INTO emi_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Emulina aJiu etoa me mene katoa tana taumattu ngeleka laghe tingina aitauaa teela kapuira namu ngatoa, me laghe aaloanna tani uvi taita alua me tani kumlalua tale atu va lalu mate. ");
INSERT INTO emi_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pol me Banabas lalu ghe nongola me lalu ghe iloula. Lalu ghe lao sio tale distriki eteva eLikaonia, tale masaliki taatara aluae eListra me eDebi me mene kasina lutu masaliki. ");
INSERT INTO emi_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Me lalu ghe mene ppooaala masi kiukiu. ");
INSERT INTO emi_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","EListra kateva tana taita, tangorengorena ia, tokatoka ngeuu ia nau ghe lutula, karika ghe kasukasula. ");
INSERT INTO emi_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ghe tokala me ghe nongola nau Pol ghe aippooaala. Pol ghe taatara lao sio etana me ghe tarala va aikaaiaane erooroo tani ghelei emasinaia, ");
INSERT INTO emi_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","me ghe sama anamuula etana me ghe uela va, “Tingina saela,” me taita ateva ghe aoso atingina saela me ghe kasukasula. ");
INSERT INTO emi_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nau eteva taumattu ngatoa laghe tarala isaa o voto Pol ghe gheleila, laghe tiuaala tani sama me aore atingina tale inangari tanganueira eLikaonia, laghe ue va, “Goto atoa ngila nonginala taumattu ngatoa me ngila sio mae etaita.” ");
INSERT INTO emi_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Banabas laghe asela ararina ateae ta Sius me Pol laghe asela ararina ateae ta Hermes poli ia ghe muemuaa niaippooaa. ");
INSERT INTO emi_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Alena ale manga ateva goto ateva Sius ghe tokatoka akalakalangina eleka tale masaliki taatara ateae. Pristi eteva ta goto ateva ta Sius ghe maeaa sio vulumakao me pusi ngai tale namu ngateae atamana poli ia me taumattu ngatoa laghe anna tani ghelei aiaavusuvusuena etairarua. ");
INSERT INTO emi_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Apostolo alua ta Banabas me Pol lalu ghe nongola voto o laghe aaloanna tani ghelei etairarua me lalu ghe rasila uneirarua aiaasae tani apasunga va karika lalu ghe masimasi me lalu ghe ilou ssola elome ta taumattu ngatoa me lalu ghe tiuaala tani sama anamuu. ");
INSERT INTO emi_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Lalu ghe ue va, “Vaalua me am anna tani ghelei isaa ona voto? Angalua nim taumattu iengalua nongina am. Angalu ghe mae sio tani aulia ngaotu masi kiukiu va am kiri tale voto kamena me am taatara lao tale Goto ateva tokatoka liu ia ghe gheleila elomarase me kosa ateva, paamanu eteva me isaa akapaaili voto elome tale isaa o voto. ");
INSERT INTO emi_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Emua arau taumattu ngeleka atoa karika laghe kilakila God, liuna avalua o me God ghe tau vellala tani kasu tale aloaloannaaira. ");
INSERT INTO emi_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Me ghe aapasunga voto tani aimatoonga va ia etautau masi voto, me eaapasunga maamasinaane ta etautau sio vaoo ateva epona liu, me inana tale nauna, me etautau aatu inana, me eaapasu urunguitaniimim tale nimasimasi.” ");
INSERT INTO emi_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Tale isaa o inangari, ghaisa ngarighi karika lalu ghe roo tani ghelei runga taumattu ngatoa tani ghelei aiaavusuvusuena lao ta ngetairarua. ");
INSERT INTO emi_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Katoa tana aJiu laghe kasula eAntiok elome ePisidia Distrik me eIkoniam laghe pasalila taumattu ngatoa me laghe kumla Pol tale atu me laghe ae velue ghoala tale masaliki taatara ateae poli laghe annaa va ang ghe matela. ");
INSERT INTO emi_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nau disaepolo atoa laghe tingina talieiniela me ghe totu saela me ghe kiriaa ssola tale masaliki taatara ateae. Eghe paila tale mene kateva nau, ia me Banabas lalu ghe lao sio eDebi. ");
INSERT INTO emi_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pol me Banabas lalu ghe ppooaala masi kiukiu eDebi me oroieili taumattu laghe aiesoaala. Vara me lalu ghe oghiaa siola eListra, eIkoniam me eAntiok elome ePisidia Distrik. ");
INSERT INTO emi_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Lalu ghe aasarasarakanala tau ngaiesoa ngatoa me lalu ghe auliaala va la poso parasi lo ateva o niaikaaiaa. Lalu ghe ue ta taumattu ngatoa va, “Tani kupi sso tale ararimangalina ateva God, aue ita tani sou oroieili vo