﻿USE sofia;
DROP TABLE IF EXISTS sofia.eko_vpl;
CREATE TABLE eko_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES eko_vpl WRITE;
INSERT INTO eko_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Omwanzo, Nluku aphattucha pinku na vathi. ");
INSERT INTO eko_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Olumwenku waari ohineeyane matthentto na khayaarimo hatha etthu, yaarivo yiizaru vatulu wa pahari yawiicha. Rooho ya Nluku yaari ozukulela vatulu wa maati. ");
INSERT INTO eko_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Aphano Nluku khuri: “Yiiyevo nuuru!” Khwiiyavo. ");
INSERT INTO eko_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nluku khoona yoori nuuru yaari yooshapweya; khuvalula nuuru na yiiza. ");
INSERT INTO eko_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Nuuru khutthaja “nthana”, yiiza khutthaja “osikhu”. Khuripa khucha, siikhu yamwanzo. ");
INSERT INTO eko_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Aphano Nluku khulupa theenya yoori: “Wiiyevo mwaawanyo vakatthi wa maati onvalulaaye maati na maati!” ");
INSERT INTO eko_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Nluku khuretta mwaawanyo ovaluliyeeyo maati vathi na vatulu. Khurettikhana etthiipo. ");
INSERT INTO eko_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Mwaawanyo opule, Nluku khutthaja “pinku”. Khuripa khucha, siikhu yaphiiri. ");
INSERT INTO eko_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Nluku khuri: “Akusanyeye maati apa ari vathi wa pinku vahali vamote epuwe tuulu yawuuma!” Khurettikhana etthiipo. ");
INSERT INTO eko_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Tuulu yaya ethiito yawuuma khutthaja nzina la “tuniya”, maati apale aakusanyeyiyeeyo khutthaja n zina la “pahari”. Nluku khoona yoori pi zooshapweya. ");
INSERT INTO eko_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Nluku khulupa theenya yoori: “Tuniya yootthele tthuttu: waaza nyaani ziniimaaye peewu na miitthi ziniimaaye mishumo, wakhula nshumo na phunje yaya!” Khurettikhana etthiipo. ");
INSERT INTO eko_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Tuniya khootthela tthuttu: nyaani ziniimaaye peewu, miitthi ziniimaaye mishumo. Nluku khoona yoori pi zooshapweya. ");
INSERT INTO eko_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Khuripa khucha, siikhu yattaatthu. ");
INSERT INTO eko_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Aphano Nluku khuri: “Otulu ziiyewo vimwasikhelo yoori ovaluleye nthana na osikhu! Ziiye alama zinthoonyezaaye elimwe na mwiita, siikhu na nyaakha. ");
INSERT INTO eko_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Vimwasikhelo ziriiye otulu ziiye zoomwasikhela vathi.” Khurettikhana etthiipo. ");
INSERT INTO eko_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Nluku khuphattucha vimwasikhelo piiri khuulu. Emwasikhelo eti khuulu yaya yoori esala elokozela nthana, eti ttiitthi esala elokozela osikhu. Na theenya khuphattucha matthottowa. ");
INSERT INTO eko_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Nluku khutthaawo vimwasikhelo epile otulu yoori zisala zimwasikhela vathi, ");
INSERT INTO eko_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","na olokozela nthana na osikhu, zaawanye nuuru na yiiza. Khoona yoori pi zooshapweya. ");
INSERT INTO eko_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Khuripa khucha, siikhu yanne. ");
INSERT INTO eko_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Aphano Nluku khuri: “Mpahari ziiyemo zumpe za waatta za wiiyana ohaayi, na eeyevo anyannyi anvavaaye otulu!” ");
INSERT INTO eko_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Nluku khumpa zumpe z'oohaayi khuluzeene za mpahari, na jaati zooshi za zumpe zineettettaaye na ziniitaalaaye mpahari. Khumpa theenya jaati zooshi za anyannyi. Nluku khoona yoori pi zooshapweya. ");
INSERT INTO eko_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Nluku khuparikhiya araka: “Mwittheerelane mwaattelane, mwiitaale mpahari, na anyannyi aattelane vatuniya!” ");
INSERT INTO eko_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Khuripa khucha, siikhu yathaanu. ");
INSERT INTO eko_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Aphano Nluku khuri: “Ziiyemo ntuniya jaati zooshi za zumpe za wiiyana ohaayi, nyama za ntthuttu, mifuwo za vaje na nyama zoojipurula!” Khurettikhana etthiipo. ");
INSERT INTO eko_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Nluku khumpa nyama za ntthuttu za wakhula jaati, zoojipurula za wakhula jaati, na mifuwo za wakhula jaati. Khoona yoori pi zooshapweya. ");
INSERT INTO eko_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Nluku khulupa theenya yoori: “Nimumpe pinaatamu woonishapihi wa wiiya nkhama Fweeyo! Yoori eeyane owahi wooshintta swi za mpahari na anyannyi o'otulu; mifuwo za vaje na nyama za ntthuttu mpakha nyama zooshi zinjipurulaaye vathi.” ");
INSERT INTO eko_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Aphano Nluku khumumpa pinaatamu wa wiiya nkhama Ye; nlume na muukha ompiwa ti Ye. ");
INSERT INTO eko_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Nluku khuwaaparikhiya khuwooza yoori: “Mwivokolelane, mwaattelane mwiitaale voolumwenku! Mwiiyane oshintta vatuniya, swi za mpahari, anyannyi o'otulu na nyama zooshi zineettettaaye vathi!” ");
INSERT INTO eko_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Nluku khulupa theenya araka: “Yoori mweeyo mwiiyane etthu-yooja, kiniwinkhani nyaani zooshi za ntuniya ziniimaaye peewu, miitthi zooshi ziniimaaye mishumo na phunje zaya. ");
INSERT INTO eko_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Kininkha mathapa ooshi nkhama vitthu-zooja za nyama zooshi ziriina ohaayi: anyannyi ooshi o'otulu na nyama zooshi mpakha epile zinjipurulaaye vathi.” Khurettikhana etthiipo. ");
INSERT INTO eko_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Nluku khoona yoori pi zooshapweya channu. Khuripa khucha, siikhu yasiitha. ");
INSERT INTO eko_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ti nanna yiishisiweezo ophattuchiwa pinku na vathi na zooshi ziriimo. ");
INSERT INTO eko_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Nluku amarisiyeevo khaazi yawe, siikhu yasaapa khuvumula. ");
INSERT INTO eko_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Siikhu ethiito yasaapa, Nluku khuparikhiya na khuttakatthisa mwaasa woovumula khwa khaazi yawe aakholiyeeyo yoophattucha. ");
INSERT INTO eko_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Eti hatiithi yoophattuchiwa pinku na vathi. Siikhu Mbwana Nnyizinku aphattuchiyeevo pinku na vathi, ");
INSERT INTO eko_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","vatuniya khawaarivo hatha muutthi wala nyaani zaari zihinootthe, maana Mbwana Nnyizinku aari ahinanyisele vuula vathi na khaarivo hatha ntthu woolima tuniya. ");
INSERT INTO eko_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ila maati aari opuwa vathi khusala anaanisa tuniya yooshi. ");
INSERT INTO eko_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Aphano, Nnyizinku khumumpa pinaatamu khwa ottophe wa vathi. Khunvitelela mphula mwawe khumwinkha phuumu y'oohaayi, pinaatamu khwiiya yumpe haayi. ");
INSERT INTO eko_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Mbwana Nnyizinku khuzala woorotha nti wa Eeteni, phantte y'ookhu lintthamuwaawo njuwa, khuntthaamo pinaatamu otule aamumpiyeeyo. ");
INSERT INTO eko_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Mbwana Nnyizinku khootthisa miitthi za wakhula nanna, zooshapweya woona na zootuva oja mishumo zaya. Vakatthi wa woorotha khuzalavo muutthi woohaayi, na muutthi onjuwisaaye yooshapweya na yootakhala. ");
INSERT INTO eko_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","N'Eeteni nttumpho waarimo muuttho waari okhuwaraaye woorotha opule; muuttho otthuupo khwaawanyeya khupuwavo nyuuttho mine. ");
INSERT INTO eko_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Wamwanzo oniitthiwa Pishoni, opo wazukulela nti wooshi wa Havila, ohali wa waattawo thahapu. ");
INSERT INTO eko_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Thahapu za nti opo pi zooshapweya na theenya ewaakho miitthi enlazaaye manlela oonukhela na mawe ootafikhana. ");
INSERT INTO eko_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Muuttho opu waphiiri oniitthiwa Kihoni, ozukuleliyeeyo nti wooshi wa Kuushi. ");
INSERT INTO eko_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Muuttho opo wattaatthu, onviraaye phantte lintthamuwaawo njuwa ya nti wa Shuuru, oniitthiwa Tiikiri. Opu wanne Efwarathi. ");
INSERT INTO eko_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Mbwana Nnyizinku khunthuula pinaatamu otule khunttha nwoorotha wa Eeteni yoori asala alimela na weekesela. ");
INSERT INTO eko_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Mbwana Nnyizinku khunruma pinaatamu otule yoori: “Miitthi epi ziriiye nwoorotha mphu oje mishumo zaya woohiina hatha shaakha. ");
INSERT INTO eko_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ila muutthi opo woojuwisa yooshapweya na yootakhala ohije; siikhu onttelaaye oja satakithu ontta ofwa.” ");
INSERT INTO eko_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Aphano Mbwana Nnyizinku khuri: “Khahi yooshapweya pinaatamu wiiya otthwe, kintta omumpa pinaatamu wa wiiya nkhama ye asala ankhiza.” ");
INSERT INTO eko_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Paata ya Mbwana Nnyizinku wumpa khwa ottophe wa vathi nyama zooshi za ntthuttu na anyannyi apa o'otulu, zooshi khuntiisela Adamu yoori amoone nanna aari weettelaazo otthaja; wakhula yumpe aari otthajaaye, nzina laya laari wiiya nttinttho. ");
INSERT INTO eko_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Adamu khutthaja mazina mifuwo za vaje, anyannyi o'otulu na nyama zooshi za ntthuttu. Ila khuhipuwivo hatha moote ya wiiya nkhama ye yaari weettelaaye onkhiza. ");
INSERT INTO eko_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Aphano, Mbwana Nnyizinku khuntiisela Adamu osikizi wa waatta. Eettaka olala, khunlaza likhonkolo limote la pavu yawe, aphale vaya aalaziyeevo khuttiyavo na nyama. ");
INSERT INTO eko_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Likhonkolo limote la pavu anlaziyeeyo Adamu, Mbwana Nnyizinku khumumpa muukha, khumwinkha Adamu. ");
INSERT INTO eko_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ye khuri: “Ahee! Ntthi likhonkolo la likhonkolo laka na nyama ya nyama yaka. Nka eetthiwaka oriwa muukha, maana alaziwa vamwiili wanlume.” ");
INSERT INTO eko_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ti eto nlume oninlikha papaawe na mamaawe khukusanyeya na muukhaawe oowiiri khwiiya nyama moote. ");
INSERT INTO eko_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Oowiiri, Adamu na muukhaawe aari wiiya waazu woohiina haaya. ");
INSERT INTO eko_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nyookha yaari nlavilavi zayita nyama zooshi za ntthuttu Mbwana Nnyizinku ompiyeeyo. Khumuuzela muukha eraka: “Atthi Nluku alupa yoori mwihije mishumo za miitthi zooshi ziriiye nwoorotha mphu?” ");
INSERT INTO eko_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Muukha otule khujipu yoori: “Ninaaye ruhusa yooja mishumo za miitthi ziriiye nwoorotha mphu, ");
INSERT INTO eko_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ila Nluku anuuza yoori: ‘Nshumo wa muutthi oriiye vakatthi wa woorotha mwihije wala mwihisape. Mwijaru mwintta ofwa.’” ");
INSERT INTO eko_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Aphano nyookha khumuuza muukha otule yoori: “Hatha khamwimfwa! ");
INSERT INTO eko_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Maana Nluku ajuwa yoori siikhu mwinttelaavo oja nshumo opo antta ofunuwa maasho enu, mweeyo mwinttela wiiya nkhama Ye, ojuwa yooshapweya na yootakhala.” ");
INSERT INTO eko_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Muukha khoona yoori muutthi opule waari wooshapweya, mishumo zaya zaari zooshapweyela oja na zaarina fwayita yoojuwisa. Attaapho, khushuma khuja, khumwinkha mannawe na-ye khuja. ");
INSERT INTO eko_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Paata ya toowo, oowiiri khufunuwa maasho aya khujuwa yoori ari waazu. Khurukela mathapa a muutthi oniitthiwaaye mfikeera khuretta wiiya kuwo zaya. ");
INSERT INTO eko_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","N'oosiila shintto ya Mbwana Nnyizinku eettettaka nwoorotha mphule, wakathi wa pheevo ya matulayi njuwa-looveva, pinaatamu na muukhaawe khujivitha na miitthi nwoorotha nttumphule yoori Mbwana Nnyizinku ahiwoone. ");
INSERT INTO eko_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Mbwana Nnyizinku khunkhuwela pinaatamu khumuuzela yoori: “Ori vayi?” ");
INSERT INTO eko_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ye khujipu araka: “Keetta osiila shintto yawo nwoorotha mphu, miiyo khoova na khujivitha mwaasa wa wiiya waazu.” ");
INSERT INTO eko_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Mbwana Nnyizinku khumuuzela theenya yoori: “Wooziwa paani yoori ori waazu? Nshumo wa muutthi opule kookhattaziyeeyo yoori ohije weetta oja?” ");
INSERT INTO eko_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Pinaatamu khujipu yoori: “Muukha otu okinkhiyeeyo yoori asala akikhiza, ti ye akinkhiyeeyo nshumo aya opo miiyo khuja.” ");
INSERT INTO eko_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Mbwana Nnyizinku khumuuzela muukha araka: “Niini eto orettiyeeyo?” Muukha khujipu yoori: “Nyookha ti ye ekittettekhiyeeyo miiyo khuja.” ");
INSERT INTO eko_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Aphano Mbwana Nnyizinku khuuza nyookha yoori: “Wiiya waretta vitthu epi, woolaanikha ti weyo vakatthi wa mifuwo za vaje na nyama zooshi za ntthuttu, nka weettettanaka erukulu na ojaka ottophe siikhu zooshi z'oohaayi awo. ");
INSERT INTO eko_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Kinttela otthaavo wuumani weeyo na muukha; peewu yawo na peewu ya muukha. Peewu ya muukha nka yuuvulalisaka eeshwa yawo, na weeyo nka ottovolaka ekwakuno yaya.” ");
INSERT INTO eko_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Mbwana Nnyizinku khumuuza muukha yoori: “Kintta ozitisa thwaapu yawo amana wiimittha ompatthaka mwaana. Weeyo onlawa watakhe onlokozela mannawo, ila mannawo onlawa ooshintte.” ");
INSERT INTO eko_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ye khumuuza Pinaatamu yoori: “Wiiya wansiileza muukhaawo khuja nshumo wa muutthi opu kookhattaziyeeyo, yalaanikha tuniya yooshi mwaasa wa weeyo, nka okholaka khaazi yoolipa yoori opatthe etthu-yooja ohaayi awo wooshi. ");
INSERT INTO eko_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tuniya eniwinkha wakhula nanna ya miiwa, weeyo nka ojaka mishumo za ntthuttu. ");
INSERT INTO eko_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Okholaka khaazi yoovujuwela yoori opatthe etthu-yooja yawo mansha awo ooshi. Maana weeyo wompaniwa ottophe, n'oofwa mpakha orutele voottophe.” ");
INSERT INTO eko_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Pinaatamu khuntthaja muukhaawe nzina la Haawa, mwaasa wa wiiya maama wa anaatamu ooshi. ");
INSERT INTO eko_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Mbwana Nnyizinku khwaattala kuwo za shapala khunwalisa pinaatamu na muukhaawe. ");
INSERT INTO eko_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Mbwana Nnyizinku khuri: “Mpakha apha pinaatamu wampattha wiiya nkhama fweeyo, ajuwa etthu yooshapweya na yootakhala. Ye ahilikheleliwe oshuma nshumo wa muutthi w'oohaayi aja yoori eeyane ohaayi wa mileele.” ");
INSERT INTO eko_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Paata ya toowo, Mbwana Nnyizinku khumwiikaramo nwoorotha wa Eeteni, yoori asala alima ottophe otthuupule ompaniweeyo. ");
INSERT INTO eko_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","N'oomwiikaramo pinaatamu nwoorotha phantte lintthamuwaawo njuwa ya Eeteni, khutthaamo kerupiina na phanka ya moottho yaari ozukulelaaye. Ye aarettiye toowo yoori esala yeekesela tarikhi yaari weettaaye okhule oriiwo muutthi w'oohaayi. ");
INSERT INTO eko_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu khurapalelana muukhaawe Haawa, khwiimittha khumpattha mwaana khuntthaja nzina la Kayiini. Ye khulupa yoori: “Khwa otakha wa Nnyizinku kampattha mwaana wanlume.” ");
INSERT INTO eko_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Khwiimittha theenya khumpattha mwaana nkina wanlume, ttwiiye Kayiini. Khuntthaja nzina la Apeele. Apeele khwiiya makhampuzi wa pwittipwitthi, Kayiini khwiiya namalima. ");
INSERT INTO eko_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Siikhu moote, Kayiini khutiisa mishumo za mmashapa oteela omwinkha zaakha Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Apeele na-ye zwaamu yawe khutiisa pwittipwitthi etile yaari yamwanzo ottheeriwa ya nliphanko mwawe, khushija khuthawula phantte epile zoosamini waya oteela omwinkha zaakha Nnyizinku, Ye khwiiya wootuveliwa ti Apeele na zaakha yawe. ");
INSERT INTO eko_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ila Kayiini na zaakha yawe etile aatiisiyeeyo, Nnyizinku khuhituveliwi. Kayiini khukatipukha khujiinamela. ");
INSERT INTO eko_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Nnyizinku khumuuzela araka: “Wakatipukhela-ni khujiinamela? ");
INSERT INTO eko_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Amana weeyo weettetta saana akinuukhupalela? Ila amana weeyo oheettetti saana, ojuwe yoori twampi eri vanlako entta wuuwejela yoori ewiirukhele yuushintte. Weeyo enuuhithajiya oshintta twampi yaya eto.” ");
INSERT INTO eko_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Aphano Kayiini khumuuza ttwiiye Apeele yoori: “Nlawe ntthuttu.” N'oofiya khunzukuluwela khumuula. ");
INSERT INTO eko_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Paata ya toole, Nnyizinku khumuuzela Kayiini araka: “Ttwiiyo Apeele ori vayi?” Khujipu yoori: “Akijuweeni! Namweekesela wa ttwiiyaku ti miyo?” ");
INSERT INTO eko_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Nnyizinku khumuuzela theenya araka: “Warettela-ni etthu nkhama eti? Huula ya taamu ya ttwiiyo entta okikhuwela vathi. ");
INSERT INTO eko_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Nasaapi ethiiti, woolaanikha ti weyo vatuniya ethiito enywiiyeeyo taamu ya ttwiiyo. ");
INSERT INTO eko_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Amana weeyo olima nka ohiruweraka. Vatuniya weeyo nka weettaka ojeettettela nkhama ntthu wootthira.” ");
INSERT INTO eko_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kayiini khumuuza Nnyizinku yoori: “Hukhumu yaka khuluyeene channu akinkhitiri. ");
INSERT INTO eko_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Leelo wakiikara vatuniya apha yoori kihiiye vamote na-weyo, miiyo kinttela ojeettettela nkhama namatthira vatuniya na wakhula anttelaaye okisikana ontta okuula.” ");
INSERT INTO eko_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Nnyizinku khunjipu yoori: “Wala! Khahiyo toowo! Wakhula otule anttelaaye owuula oniiya woohukhumwiwa swaafu sapa.” Ye khunttha alama vamwiili yoori wakhula aninsikanaaye ahimuule. ");
INSERT INTO eko_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Aphano Kayiini khwumwazeyanana Nnyizinku khulawa khwiikhala nti wa Nooti, okhu lintthamuwaawo njuwa phantte ya Eeteni. ");
INSERT INTO eko_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ye khurapalelana muukhaawe, khwiimittha khumpattha mwanawe Enookhi. Kayiini khujeka sitati khutthaja nzina nttintthile la mwanawe Enookhi. ");
INSERT INTO eko_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enookhi khunvokola Eraati, Eraati khunvokola Mehuyayele, Mehuyayele khunvokola Lameekhi ");
INSERT INTO eko_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameekhi khuwaarala aakha awiri, mmote nzina lawe laari Aada. Otu nkina lawe laari Siila. ");
INSERT INTO eko_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Aada khumpattha mwanawe khuntthaja nzina la Yapaali, paapa wa atthu apale aari wiikhalaaye mmaheema aari ofuwaaye nyama. ");
INSERT INTO eko_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ttwiiye nzina lawe laari Yupaali, oto aari paapa wa atthu apale ooshi animpiyaaye tthakare na apale ampiyaaye phivi. ");
INSERT INTO eko_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Siila khumpattha mwaana khuntthaja nzina la Tupaali-Kayiini, ye aari funti wa waattala zaana za khoopiri na zuuma. Tupaali-Kayiini aarina nlupuwe aari wiitthiwaaye Naama. ");
INSERT INTO eko_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameekhi khuwooza aakhaawe yoori: “Aada na Siila! Mwikisiileze aakhaaka: Kamuula ntthu mwaasa wookivulalisa, na shapu mmote mwaasa wookiluwattha. ");
INSERT INTO eko_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Amana Kayiini ariphiwa hukhumu swaafu sapa, Lameekhi onttela oriphiwa swaafu sapiini na sapa.” ");
INSERT INTO eko_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu khurapalelana muukhaawe theenya khumpattha mwaana khuntthaja nzina la Seethi, Haawa khuri: “Nnyizinku akinkha mwaana nkinoko wonriphelavo Apeele otule ooliweeyo ti Kayiini.” ");
INSERT INTO eko_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seethi na-ye khumpattha mwaana khuntthaja nzina la Enooshi. Wakathi aya otthuupo phi laaziyeevo waaputwiwa nzina la Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Eti warakha yoovokola wa peewu ya Adamu. Wakathi Nluku amumpiyeeyo pinaatamu, aamumpiye wa wiiya nkhama ye; ");
INSERT INTO eko_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","nlume na muukha ti ye awompiyeeyo. N'oowompa khuwaaparikhiya. Khuwaatthaja nzina la “anaatamu”. ");
INSERT INTO eko_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu afiiyeevo nyaakha miiya na talaathiini khumpattha mwaana wa wiiya nkhama ye na khwa wumpo awe khuntthaja nzina la Seethi. ");
INSERT INTO eko_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Paata yonvokola Seethi, Adamu khwiikhala theenya nyaakha miiya naane khuwaapattha aana a waatta aalume na aakha. ");
INSERT INTO eko_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adamu afwa arina nyaakha miiya tiisiya na talaathiini. ");
INSERT INTO eko_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seethi afiiyeevo nyaakha miiya na mithaanu, khunvokola Enooshi. ");
INSERT INTO eko_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Paata yonvokola Enooshi, Seethi khwiikhala theenya nyaakha miiya naane na sapa khuwaapattha aana akina aalume na aakha. ");
INSERT INTO eko_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seethi afwa arina nyaakha miiya tiisiya na khumi na miwiri. ");
INSERT INTO eko_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enooshi afiiyeevo nyaakha tiisiini, khunvokola Kenaani. ");
INSERT INTO eko_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Paata yonvokola Kenaani, Enooshi khwiikhala theenya nyaakha miiya naane na khumi na mithaanu, khuwaapattha aana akina aalume na aakha. ");
INSERT INTO eko_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enooshi afwa arina nyaakha miiya tiisiya na mithaanu. ");
INSERT INTO eko_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenaani afiiyeevo nyaakha sapiini, khunvokola Mahalaleeli. ");
INSERT INTO eko_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Paata yonvokola Mahalaleeli, Kenaani khwiikhala theenya nyaakha miiya naane na arupayiini, khuwaapattha aana akina aalume na aakha. ");
INSERT INTO eko_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenaani afwa arina nyaakha miiya tiisiya na khumi. ");
INSERT INTO eko_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleeli afiiyeevo nyaakha siithiini na mithaanu, khumpattha mwaana khuntthaja nzina la Yareeti. ");
INSERT INTO eko_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Paata yonvokola Yareeti, Mahalaleeli khwiikhala nyaakha miiya naane na talaathiini khuwaapattha aana akina aakha na aalume. ");
INSERT INTO eko_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalaleeli afwa arina nyaakha miiya naane na tiisiini na mithaanu. ");
INSERT INTO eko_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yareeti afiiyeevo nyaakha miiya na siithiini na miwiri, khumpattha mwaana khuntthaja nzina la Henookhi. ");
INSERT INTO eko_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Paata yonvokola Henookhi, Yareeti khwiikhala nyaakha miiya naane, khuwaapattha aana akina aalume na aakha. ");
INSERT INTO eko_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yareeti afwa arina nyaakha miiya tiisiya na siithiini na miwiri. ");
INSERT INTO eko_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henookhi afiiyeevo nyaakha siithiini na mithaanu, khumpattha mwaana khuntthaja nzina la Methuseela. ");
INSERT INTO eko_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Paata yonvokola Methuseela, Henookhi khulotta mwentto wa Nnyizinku nyaakha miiya ttatthu, khuwaapattha aana akina aalume na aakha. ");
INSERT INTO eko_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ye eekhaliye nyaakha miiya ttatthu na siithiini na mithaanu. ");
INSERT INTO eko_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henookhi aarina osiilana nwulweene na Nluku. Ye eettiye woophaziwa ti Nluku. ");
INSERT INTO eko_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Methuseela afiiyeevo nyaakha miiya na thamaaniini na sapa, khunvokola Lameekhi. ");
INSERT INTO eko_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Paata yonvokola Lameekhi, Methuseela khwiikhala nyaakha miiya sapa na thamaaniini na miwiri, khuwaapattha aana akina aalume na aakha. ");
INSERT INTO eko_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Methuseela afwa arina nyaakha miiya tiisiya na siithiini na tiisiya. ");
INSERT INTO eko_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameekhi afiiyeevo nyaakha miiya na thamaaniini na miwiri khumpattha mwaana mmote. ");
INSERT INTO eko_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Mwaana otule mmote ampatthiyeeyo khuntthaja nzina la Nuuhi, ye khulupa yoori: “Khwa khaazi zoolwaaza ninkholaazo nilimaka tuniya eti elaaniweeyo ti Nnyizinku, mwaana otu ti ye anttela wiitthaaza rooho zetthu.” ");
INSERT INTO eko_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Paata yonvokola Nuuhi, Lameekhi khwiikhala theenya nyaakha miiya thaanu na tiisiini na mithaanu, khuwaapattha aana akina aalume na aakha. ");
INSERT INTO eko_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lameekhi afwa arina nyaakha miiya sapa na sapiini na sapa. ");
INSERT INTO eko_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuuhi eekhaliye nyaakha miiya thaanu khuwaapattha aana aalume khuwaatthaja mazina: Sheemu, Haamu na Yafeeti. ");
INSERT INTO eko_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Wakathi anaatamu aaziyeevo waattelana muulumwenku na khuwaavokola aana aakha, ");
INSERT INTO eko_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","mahaakhimu khuwoona yoori aakha apale aari ooshapweya, wakhula mmote wa yo khusala awaathuula apale aari owaatakhaaye. ");
INSERT INTO eko_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Aphano Nnyizinku khuri: “Akinteela onlikhela pinaatamu phuumu z'oohaayi khwa mileele, maana ye nyama ya taamu; siikhu zawe enttela wiiya nyaakha miiya na eshiriini.” ");
INSERT INTO eko_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Wakathi aya opo muulumwenku aarimo atthu awulu-awulu na oozivala, aruteliye wiiyavo theenya. Aari aana aalume aavokoliweeyo pi mahaakhimu n'oorapalelana aana aakha a anaatamu. Aana atthaapo, pa yo aari atthu oozivala na ootafikhana. ");
INSERT INTO eko_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Nnyizinku khoona yoori vatuniya zootakhala za anaatamu zeetta ovira zeekezeleyaka; Menttezi aya ooshi aari ooretta vitthu zootakhala wakhula siikhu. ");
INSERT INTO eko_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Aphano Nnyizinku khukasirikha mwaasa woomumpa pinaatamu vatuniya, khwiiya woolemeliwa nroho mwawe. ");
INSERT INTO eko_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Khuri: “Kintta owaafujavo anaatamu aya apa kiwompiyeeyo voolumwenku apha; waaza anaatamu, nyama, anyanyama, na anyannyi o'otulu, kiwookasirikha mwaasa woowumpa.” ");
INSERT INTO eko_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ila Nuuhi khwiiya ntthu aapatthiiyeeyo rehema omaasho wa Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Eti hatiithi ya Nuuhi. Vakatthi wa atthu ooshi ye otthwe paasi ti ye ari ntthu w'eekhweeli na washariya, aari weettettelaaye mwentto wa Nluku ");
INSERT INTO eko_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuuhi awaavokoliye aanaawe aalume attatthu; Sheemu, Haamu na Yafeeti. ");
INSERT INTO eko_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Olumwenku waazukuleliwe pi vitthu zootakhala na zoohusuti omaasho wa Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Nnyizinku khweekesa olumwenku khusala oona ori wooharipweya, maana zumpe zooshi zaari zooharipweya menttezi aya. ");
INSERT INTO eko_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Nnyizinku khumuuza Nuuhi yoori: “Kintta wiishisa zumpe zooshi z'oohaayi, vamote na olumwenku aya kipweche. ");
INSERT INTO eko_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Weeyo omwaattale aaraka nwulweene na thaapwa za mpila, onremule ontthe kaatthi, onkokotte ontthe piriniisi oje waya na nkatthi. ");
INSERT INTO eko_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Omwaattale nanna eti: phiima miiya na talaathiini na thaanu olepa waya, phiima eshiriini na piiri na nuusu owula waya, phiima khumi na ttatthu chanka yaya. ");
INSERT INTO eko_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ontthe tarato enfiyaaye nuusu ya phiima vatulu vaya. Waawanye tarato moote vathi, moote vakatthi, kinoko vatulu, ontthe nlako mpavu mwaya. ");
INSERT INTO eko_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Onjuwa! Miiyo kasaleela ozamisa olumwenku wooshi na maati a nnyeri, kiishise zumpe zooshi ziriina phuumu z'oohaayi ziriiye vathi wa pinku. Zooshi ziriiye vatuniya zinttela ofwa. ");
INSERT INTO eko_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ila wahati aka kinretta na-weyo, onttela weetta mmwaaraka, weeyo, muukhaawo, aanaawo na aakhaaya. ");
INSERT INTO eko_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Othuule nyama wakhula jaati piiri-piiri, yeelume na yeekha opakhire mmwaaraka mwawo yoori ziiye haayi vamote na-weyo. ");
INSERT INTO eko_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Wakhula jaati ya anyannyi, wakhula jaati ya nyama, wakhula jaati ya epile zinjipurulaaye vathi, zooshi piiri-piiri ziiye vamote na-weyo yoori ziiye haayi. ");
INSERT INTO eko_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Othuule vitthu zooshi zinjiwaazo opwehe yoori osala oja weeyo na nyama epo zooshi.” ");
INSERT INTO eko_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuuhi khuretta zooshi epile aarumiweezo ti Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Aphano Nnyizinku khumuuza Nuuhi yoori: “Weeyo na ajamaazo ooshi opakhire mmwaaraka. Vakatthi wa atthu apa ooshi ariivo, Miiyo kawoona weeyo paasi wiiya ntthu washariya. ");
INSERT INTO eko_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Othuule nyama za halaali sapa zeelume na sapa zeekha ila epile zoohiiyi za halaali othuule piiri-piiri yeelume na yeekha. ");
INSERT INTO eko_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Owaathuule theenya anyannyi sapa eelume na sapa eekha yoori jaati yaya ehaashikhe. ");
INSERT INTO eko_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Mmana zivira siikhu sapa kinlawa kanyisele vuula vatuniya siikhu arupayiini nthana na osikhu, kipweteche zumpe zooshi kumpiyeezo.” ");
INSERT INTO eko_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nuuhi khuretta zooshi epile Nnyizinku anrumiyeezo. ");
INSERT INTO eko_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Wakathi maati aazamisiyeevo tuniya, Nuuhi aari oretta arina nyaakha miiya sitha. ");
INSERT INTO eko_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ye khupakhira mmwaaraka vamote na muukhaawe, aanaawe na aakhaaya mwaasa wa maati a nnyeri aari oteelaaye ozamisa olumwenku. ");
INSERT INTO eko_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Nyama za halaali na zoohiiyi za halaali, anyannyi na nyama epile zinjipurulaaye vathi, ");
INSERT INTO eko_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","khupakhira mmwaaraka vamote na Nuuhi piiri-piiri zeelume na zeekha, nkhama etthiipo Nnyizinku aamuuziyeezo. ");
INSERT INTO eko_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ziviriyeevo siikhu sapa, maati oozamisa olumwenku khwaaza opuwa vatuniya. ");
INSERT INTO eko_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Siikhu Nuuhi afiiyeevo nyaakha miiya sitha, mweezi waphiiri orina siikhu khumi na sapa, khuphutuwa matthatta a vathi ooshi apale awiicha na milako za pinku khufukuwa. ");
INSERT INTO eko_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Khunya vuula vatuniya siikhu arupayiini nthana na osikhu. ");
INSERT INTO eko_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Siikhu ethiito Nuuhi, muukhaawe, aanaawe Sheemu, Haamu, Yafeeti, na aakha attatthu a aanaawe aarettiye ari mmwaaraka. ");
INSERT INTO eko_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Nuuhi aapakhiriye nyama zooshi za ntthuttu, mifuwo zooshi za vaje, nyama epile zooshi zinjipurulaaye, na anyannyi a wakhula jaati na epile zooshi za wiiyana mapaphelo. ");
INSERT INTO eko_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Zumpe zooshi ziriina phuumu z'oohaayi khupakhira piiri-piiri mmwaaraka mphule vamote na-ye. ");
INSERT INTO eko_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Nyama zooshi zeettiyeemo zaari zeekha na zeelume za wakhula jaati nkhama etthiipo Nluku anrumiyeezo. Nawiisha opakhira, Nnyizinku khufuka nlako wa aaraka. ");
INSERT INTO eko_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Nnyeri weeshiye siikhu arupayiini vatuniya. Maati khuvira eekezeleyaka mpakha khweeleela aaraka ");
INSERT INTO eko_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Maati eetta ovira atepaka waatta mpakha aaraka otule khusala eeleela vatulu a maati. ");
INSERT INTO eko_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Khwaatta channu mpakha khufiyelela ozamisa nyaako. ");
INSERT INTO eko_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Maati khuvikana nyaako epile kiyasi ya phiima sapa. ");
INSERT INTO eko_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Zumpe zooshi z'oohaayi zaari vatuniya khufwa; anyannyi, mifuwo za vaje, nyama za ntthuttu, epile zinjipurulaaye vathi na anaatamu ooshi. ");
INSERT INTO eko_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Zumpe zooshi epile zaariina phuumu y'oohaayi, zaari ovumulaaye voolumwenku apha khufwa. ");
INSERT INTO eko_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Nnyizinku khupwetecha zumpe zooshi z'oohaayi zaari vatuniya. Pinaatamu, nyama za ntthuttu, na epile zinjipurulaaye vathi na anyannyi o'otulu zooshi khupwetheya. Khusala Nuuhi otthwe na ajamaaze na nyama epile zaari vamote na-ye mmwaaraka. ");
INSERT INTO eko_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Maati aarupaziye vatuniya siikhu miiya na hamusiini. ");
INSERT INTO eko_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ila Nluku khuhinsahawu Nuuhi na nyama epile za ntthuttu na mifuwo za vaje epile aarinaazo mmwaaraka, khuperekha pheevo yoori evitelele vatuniya, maati khwaaza ovwa. ");
INSERT INTO eko_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Matthatta apale awiicha na milako za pinku khufukiwa, vuula khwaamusa, ");
INSERT INTO eko_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","maati khwaaza ovwa vattiitthi-vattiitthi mpakha siikhu miiya na hamusiini. ");
INSERT INTO eko_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Siikhu khumi na sapa ya mweezi wasaapa aaraka otule khuphweruwa vanyaako za Araraati. ");
INSERT INTO eko_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Maati apale khusala avwa paasi mpakha siikhu yamonsi mweezi wakhuumi khwaaza wooneya mithoma za nyaako. ");
INSERT INTO eko_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","N'oovira siikhu arupayiini Nuuhi khufukula ettakha ya aaraka etile aattaliyeeyo. ");
INSERT INTO eko_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Khumfukulela nakhuku khusala avava azukulelaka mpakha maati ovwa. ");
INSERT INTO eko_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Elottelanaka khufukulela jiwa yoori yoone nkhama maati avwa vatuniya. ");
INSERT INTO eko_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ila jiwa etile khuhisikani puuro yoomorela khurutela mmwaaraka, mwaasa yoori tuniya nalelo yaari ehinavuuwe. Jiwa khurutela wa Nuuhi, khusarula nkhono awe khukhola jiwa etile khuvirisa mmwaaraka. ");
INSERT INTO eko_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nuuhi khuvira awejaka mpakha siikhu sapa, khuruma jiwa ethiitile swaafu yaphiiri. ");
INSERT INTO eko_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Khuruti njuwa-looveva elumiye nthapa liwishi l'ooluveera, aphano Nuuhi nawoona khujuwa yoori maati avwa vatuniya. ");
INSERT INTO eko_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Khuweja theenya siikhu sapa khuruma jiwa ethiitile opheya, ila swaafu eti khuhiruti. ");
INSERT INTO eko_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Siikhu yamonsi ya mweezi wa mfunko monsi wakathi Nuuhi aarinaavo nyaakha miiya sitha na mmote, maati apale aazamisiyeeyo tuniya khukakhamela. Nuuhi khufunula tarato ya aaraka khoona yoori nshaka wooma. ");
INSERT INTO eko_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Siikhu eshiriini na sapa ya mweezi waphiiri, tuniya khuuma saaneene. ");
INSERT INTO eko_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Aphano Nnyizinku khumuuza Nuuhi yoori: ");
INSERT INTO eko_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Wiishukhemo mmwaaraka mpho weeyo, muukhaawo, aanaawo na aakhaaya. ");
INSERT INTO eko_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Wiishushe nyama zooshi oriinaazo waaza anyannyi, nyama na epi zinjipurulaaye vathi. Osarule zimwazeyele vatuniya, zittheerelane zaattelane.” ");
INSERT INTO eko_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nuuhi na muukhaawe, aanaawe na aakhaaya khwiishukha mmwaaraka mphule. ");
INSERT INTO eko_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Khusarulamo nyama epile zooshi zinjipurulaaye vathi, anyannyi ooshi, na zooshi etthiipile zineettettaaye vatuniya, wakhula moote na jaati yaya. ");
INSERT INTO eko_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nawiisha, Nuuhi khunjeka alitaari woorettavo twaha yoomwinkha kafwara Nnyizinku. Ye khuthawula nyama epile kinoko zaya za halaali, na anyannyi a halaali akinoko aya, khushija, khulawa khuretta twaha yoolukuziwa vaalitaari. ");
INSERT INTO eko_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Nnyizinku khusiila arufu yonkhurunusha rooho khulupa mwennyeweru yoori: “Akinteela orutela theenya olaani tuniya mwaasa wa pinaatamu, eeyaru pure wootakhala rooho ovokoliwa-wene. Akinteela orutela opwetecha zumpe zooshi nkhama nanna eti kirettiyeezo. ");
INSERT INTO eko_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Mmana olumwenku wiiyakavo oniiyana wakathi woozala na wa wuurula, woozizima na wa haari, elimwe na mwiita, nthana na osikhu, vitthu epo khinteela wiisha.” ");
INSERT INTO eko_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Nluku khumparikhiya Nuuhi na aanaawe awoozaka yoori: “Mwivokolelane mwaattelane mwiitaale voolumwenku. ");
INSERT INTO eko_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Nyama zooshi za voolumwenku, epi za ntthuttu, anyannyi o'otulu, epi zinjipurulaaye vathi, na swi za mpahari, zinttela wiiya zoowoovani mweeyo channu. Zooshi epo mwinttela oshintta. ");
INSERT INTO eko_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Zooshi zinoonaaye na zineettettaaye zinttela wiiya etthu-yooja yenu, nkhama etthiipo kiwinkhiyeenini mathapa, zooshi kawinkhani. ");
INSERT INTO eko_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ila mwihije nyama na taamu yaya, maana taamu ohaayi. ");
INSERT INTO eko_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Wakhula nyama enimuulaaye ntthu, na pinaatamu animuulaaye nzaawe, anttela ojipu mmakhono Mwaka. ");
INSERT INTO eko_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","‘Mwaasa yoori Nluku amumpa pinaatamu ajilattanisaka mwennyewe, otule animuulaaye pinaatamu na-ye ontta wuuliwa ti pinaatamu.’ ");
INSERT INTO eko_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ila mweeyo mwivokolelane mwaattelane mwiitaale voolumwenku.” ");
INSERT INTO eko_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Aphano Nluku khumuuza Nuuhi vamote na aanaawe araka: ");
INSERT INTO eko_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Nasaapi eti Kinretta wahati aka na-weyo na peewu yawo, ");
INSERT INTO eko_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","na zooshi ziriinaazo ohaayi opakhuwaniyeeyo mmwaaraka ziriiye vamote na-weyo: anyannyi, mifuwo, nyama za ntthuttu na zumpe zooshi za ntuniya. ");
INSERT INTO eko_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Kinretta wahati aka na-mweyo; akinteela opwetecha theenya zumpe zooshi na maati a nnyeri, wala tuniya khinteela ozama theenya na maati a nnyeri.” ");
INSERT INTO eko_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Nluku khulupa theenya: “Eti alama ya wahati aka miiyo na-weyo na zumpe zooshi ziriiye vamote na-weyo, khwa mileele: ");
INSERT INTO eko_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","katthaamo nkhankanyama mmawiku yoori wiiye alama ya wahati miiyo na tuniya. ");
INSERT INTO eko_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Amana kifinikha pinku na mawiku, khupuwa nkhankanyama, ");
INSERT INTO eko_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","phi kinttelaaye wuupuwela wahati aka miiyo na-weyo na zumpe zooshi. Khanrutela theenya maati a nnyeri ozamisa zumpe zooshi z'oohaayi. ");
INSERT INTO eko_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Nkhankanyama n'oopuwa mmawiku, nka kifikhiraka wahati opule kirettiyeeyo wa mileele miiyo na zumpe zooshi z'oohaayi ziriiye vatuniya.” ");
INSERT INTO eko_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Nawiisha Nluku khumuuza Nuuhi yoori: “Eti alama ya wahati kirettiyeeyo miiyo na zumpe zooshi ziriiye vatuniya.” ");
INSERT INTO eko_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Aana a Nuuhi aapakhuwaniyeeyo mmwaaraka mphule pi apa: Sheemu, Haamu na Yafeeti. Haamu aari paapa wa Kanaani. ");
INSERT INTO eko_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Apa attatthu aari aana a Nuuhi, atthu ooshi amwazeyeliyeeyo vatuniya avokoliwa khwa yo. ");
INSERT INTO eko_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuuhi aari namalima, ye ti tthakuzi woozala mirayi za wuuva. ");
INSERT INTO eko_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Siikhu moote, khunywa viinyu ya nshumo opule khunhapala khuvuleya kuwo zawe zooshi nheema mwawe. ");
INSERT INTO eko_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Haamu, paapa wa Kanaani, khuvira nheema khoona owaazu wa papaawe. Khulawa khuwooza attwiize apale awiri aari vaje. ");
INSERT INTO eko_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Aphano khulankha Sheemu na Yafeeti khuthuulaza juupa khuvikela mmafuzi mwaya khusala eettetta na enyokonyoko yoori ahoone owaazu wa papaaya n'oofiya khumfinikha. ");
INSERT INTO eko_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Wakathi Nuuhi emwaamuwiyeevo viinyu etile, khujuwa mattakhuzi aaviriseliweeyo ti mwanawe otu w'eefutti. ");
INSERT INTO eko_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Aphano ye khuri: “Woolaanikha ti Kanaani, onttela wiiya mwiitthwaana wa amwiitthwaana a attwiize.” ");
INSERT INTO eko_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Theenya khuri: “Asifwiwe Mbwana Nnyizinku wa Sheemu, anrette Kanaani wiiya mwiitthwaana wa Sheemu. ");
INSERT INTO eko_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Nnyizinku anwulise Yafeeti; khapila yawe yiiye vamote na ya Sheemu, Kanaani eeye mwiitthwaana aya.” ");
INSERT INTO eko_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Paata yawiisha nnyeri, Nuuhi eekhaliye nyaakha miiya ttatthu na hamusiini. ");
INSERT INTO eko_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nuuhi afwa arina nyaakha miiya tiisiya na hamusiini. ");
INSERT INTO eko_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Eti warakha ya peewu ya Sheemu, Haamu na Yafeeti, aana a Nuuhi. Yo aawaapatthiye aana wakathi opule wiishiyeevo nnyeri. ");
INSERT INTO eko_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Aana a Yafeeti aari apa: Komeeri, Makooku, Matayi, Yavani, Tupaali, Mesheki na Tirasi. ");
INSERT INTO eko_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Aana a Komeeri aari apa: Ashikenazi, Rifwathi na Tokaama. ");
INSERT INTO eko_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Aana a Yavani aari apa: Elisha, Tarishishi, Kitimu na Rotanimu. ");
INSERT INTO eko_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Khwa aana atthaapo, atthu khumwazeyela nkerekhere wa nttima na mvisura. Eti peewu ya Yafeeti wakhula khapila na lihimo laya na nti aya na luuka yaya. ");
INSERT INTO eko_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Aana a Haamu aari apa: Kuushi, Misuri, Puuti na Kanaani. ");
INSERT INTO eko_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Aana a Kuushi aari apa: Seepa, Havila, Saapita, Raama na Sapiteeka. Aana a Raama aari apa: Sheepa na Tetaani. ");
INSERT INTO eko_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuushi khunvokola theenya Ninrooti, otu ti ye aaziyeeyo wiiya ntthu wooshintta vathi apha. ");
INSERT INTO eko_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ye aari namasaya wookhomaala omaasho wa Nnyizinku. Ti eto enlupiwaaye yoori “Ntthu nkhama Ninrooti, namasaya wookhomaala omaasho wa Nnyizinku”. ");
INSERT INTO eko_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ofwalume awe waaza nti wa Babeeli, Ereki na Akati, zooshi epo zaari nti wa Shinaari. ");
INSERT INTO eko_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Khulankha nti wa Shinaari khulawa mpakha Ashuuru khujeka sitati ya Neniive, ya Rehopoothi-Yiiri na ya Kaala, ");
INSERT INTO eko_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","na sitati ya Reseeni, sitati khuluyeene yaari vakatthi wa sitati ya Neniive na ya Kaala. ");
INSERT INTO eko_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misuri khunvokola Aluti, Anaamu, Alehaapi, Anafituhi, ");
INSERT INTO eko_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Apaturusi na Akasuluhi (apa pa yo awaavokoliyeeyo Afiliishiti) na Akafitoori. ");
INSERT INTO eko_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaani khunvokola Sitooni mwanawe wa mwanzo na Ahiiti, ");
INSERT INTO eko_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","theenya na Ayepuzi, Amoori na Akirikashi, ");
INSERT INTO eko_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Ahivi, Ariki, Asiini, ");
INSERT INTO eko_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Aravati, Azemaari na Ahamati. Khwa etthiipo lihimo la Akanaani khumwazeya. ");
INSERT INTO eko_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Mwiinano wa Akanaani waaziye Sitooni olawaka Keraari, mpakha Gaaza, na phantte ya Sotooma na Komoora, Atima na Sepooyimu mpakha Laasha. ");
INSERT INTO eko_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Apa aari aana a Haamu na mahimo aya, luuka zaya, miti zaya na khapila zaya. ");
INSERT INTO eko_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sheemu nttunkhulu wa Yafeeti, na-ye aawaavokoliye aana; Sheemu aari pwaapu wa aana a Heebere. ");
INSERT INTO eko_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Aana a Sheemu aari apa: Elamu, Ashuuru, Arifwakisaati, Luthi na Aramu. ");
INSERT INTO eko_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aana a Aramu aari apa: Wuuzi, Huuli, Keteeri na Maashi. ");
INSERT INTO eko_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arifwakisaati khunvokola Sheela, na-ye Sheela khunvokola Heebere. ");
INSERT INTO eko_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Heebere khuwaavokola aana awiri: mmote khuntthaja nzina la Peleekhi mwaasa yoori siikhu zawe tuniya yeettiye waawanyiwa. Otu waphiiri khuntthaja nzina la Yokitaani. ");
INSERT INTO eko_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokitaani khunvokola Alimotathi, Shelefu, Hazarimawethi, Yeera, ");
INSERT INTO eko_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hatoramu, Yuzaali, Tiikala, ");
INSERT INTO eko_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Opaali, Apimayeeli, Sheepa, ");
INSERT INTO eko_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofiiri, Havila na Yopaapu, ooshi apa aana a Yokitaani. ");
INSERT INTO eko_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Apa aari wiikhala waaza nti wa Meesha mpakha nnyaako phantte ya malawa-juwa nti wa Sefaari. ");
INSERT INTO eko_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Apa aari aana a Sheemu na mahimo aya, luuka zaya, miti zaya na khapila zaya. ");
INSERT INTO eko_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Opu ojama wa aana a Nuuhi, waawanyeyiyeeyo khapila khwa khapila na peewu yaya paata yawiisha nnyeri. Khapila zooshi zimwazeyeliyeeyo voolumwenku zalankha voojama otthuupo. ");
INSERT INTO eko_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Wakathi aya opo olumwenku wooshi waarina luuka moote na nanna moote yoottakhula. ");
INSERT INTO eko_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Atthu aalankhiye malawa-juwa khusikana nttapo la Shinaari khwiikhala attaapho. ");
INSERT INTO eko_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Khusiilana yoori: “Nlaweni nuupe thizolo nooche saaneene.” Thizolo epile khuretta wiiya mawe, piriniisi khunretta wiiya mattakha. ");
INSERT INTO eko_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Theenya khuri: “Nlaweni nijeke sitati yawiiyana korofwa khuluyeene enkomaaye pinku, yoori nzina letthu liiye loojuwanikha, nihiiye woomwazeyela olumwenku wooshi.” ");
INSERT INTO eko_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Paata ya toole, Nnyizinku khwiishukha yoori oone sitati ya korofwa etile aari ojekaaye atthu apale. ");
INSERT INTO eko_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ye khuri: “Moone! Atthu apa amoteru, ooshi anttakhula luuka moote. Eti arettiyeeyo eetta waaza, khaavo anttelaaye owaakarawela etile awaziyeeyo. ");
INSERT INTO eko_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Nlaweni niishukhe navirikanise luuka anttakhulaaye yoori ahisala asiilana mmote na nzaawe.” ");
INSERT INTO eko_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ethiito, khukaraweleya ojekiwa sitati etile, Nnyizinku khuwaamwazela olumwenku wooshi. ");
INSERT INTO eko_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ti eto sitati etile khutthajiwa nzina la “Babeeli”, mwaasa wa Nnyizinku ovirikanisa luuka ya anaatamu ooshi. Attaapho, Nnyizinku khuwaamwazela olumwenku wooshi. ");
INSERT INTO eko_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Eti peewu ya Sheemu. Sheemu afiiyeevo nyaakha miiya khunvokola mwanawe Arifwakisaati, nyaakha miwiri paata ya nnyeri ovira. ");
INSERT INTO eko_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","N'onvokola Arifwakisaati, eekhaliye nyaakha miiya thaanu, khuwaavokola theenya aana aalume na aakha. ");
INSERT INTO eko_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arifwakisaati afiiyeevo nyaakha talaathiini na mithaanu, khunvokola Sheela. ");
INSERT INTO eko_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Paata yonvokola Sheela, eekhaliye nyaakha miiya nne na mittatthu, khuwaavokola theenya aana aalume na aakha. ");
INSERT INTO eko_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sheela afiiyeevo nyaakha talaathiini khunvokola Heebere. ");
INSERT INTO eko_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","N'onvokola Heebere, eekhaliye nyaakha miiya nne na mittatthu, khuwaavokola theenya aana aakha na aalume. ");
INSERT INTO eko_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Heebere afiiyeevo nyaakha miiya nne na talaathiini khunvokola Peleekhi. ");
INSERT INTO eko_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","N'onvokola Peleekhi, eekhaliye nyaakha miiya nne na talaathiini, khuwaavokola theenya aana aalume na aakha. ");
INSERT INTO eko_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleekhi afiiyeevo nyaakha talaathiini khunvokola Reewu. ");
INSERT INTO eko_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","N'onvokola Reewu, eekhaliye nyaakha miiya piiri na tiisiya, khuwaavokola theenya aana aalume na aakha. ");
INSERT INTO eko_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reewu afiiyeevo nyaakha talaathiini na miwiri khunvokola Serukhi. ");
INSERT INTO eko_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","N'onvokola Serukhi, eekhaliye nyaakha miiya piiri na sapa khuwaavokola theenya aana aakha na aalume. ");
INSERT INTO eko_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serukhi afiiyeevo nyaakha talaathiini khunvokola Nahoori. ");
INSERT INTO eko_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","N'onvokola Nahoori, eekhaliye nyaakha miiya piiri khuwaavokola theenya aana aalume na aakha. ");
INSERT INTO eko_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahoori afiiyeevo nyaakha eshiriini na tiisiya khunvokola Teera. ");
INSERT INTO eko_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","N'onvokola Teera, eekhaliye nyaakha miiya na khumi na tiisiya, khuwaavokola theenya aana aalume na aakha. ");
INSERT INTO eko_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Teera afiiyeevo nyaakha sapiini, khunvokola Eburamu, Nahoori na Hara. ");
INSERT INTO eko_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Eti peewu ya Teera. Teera khunvokola Eburamu, Nahoori na Hara. Hara khunvokola Loothi. ");
INSERT INTO eko_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Hara khufwa sitati ya Wuuri, nti wa Babilooniya tuniya aavokoliweewo, ila papaawe khusala ari haayi. ");
INSERT INTO eko_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Eburamu na Nahoori khuloola. Muukha wa Eburamu aari wiitthiwa Suhuriiya, na-ye muukha wa Nahoori nzina lawe aari Miilika, mwaana wa Hara, aarina mwaana nkina theenya aari wiitthiwaaye Ishika. ");
INSERT INTO eko_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ila Suhuriiya khaarina aana mwaasa woohiina mavokozi. ");
INSERT INTO eko_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Teera khulankha sitati ya Wuuri, nti wa Babilooniya, eettaka Kanaani. Alawaka khunthuula mwanawe Eburamu na ntuuluwe Loothi, mwaana wa Hara, vamote na nkhwewe Suhuriiya, muukha wa Eburamu. Ila afiiyeevo sitati ya Harani khuhivikani, khwiikhala ottuukho. ");
INSERT INTO eko_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Teera khufwa Harani arina nyaakha miiya piiri na mithaanu. ");
INSERT INTO eko_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Siikhu moote, Nnyizinku khumuuza Eburamu araka: “Olikhe tuniya yawo, na ajamaazo, na vaje wa apapazo olawe tuniya kinttelaaye wuuthoonyeza. ");
INSERT INTO eko_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Kinteela wuuretta wiiya paapa wa peewu ya waatta, kinteela wuuparikhiya na onteela wiiya woojuwanikha, kinteela owaaparikhiya atthu akina mwaasa wa weeyo. ");
INSERT INTO eko_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Kiniwaaparikhiya apale anuuparikhiyaaye, na kininlaani otule anuulaanaaye. Khwa weyo enteela wiiya zooparikhiyiwa khapila zooshi za voolumwenku.” ");
INSERT INTO eko_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Eburamu khulankha khusala alawa nkhama etthiipo Nnyizinku anrumiyeezo. Ye aalawiye vamote na Loothi, wakathi aaliiyeewo Harani aari oretta arina nyaakha sapiini na mithaanu. ");
INSERT INTO eko_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Khunthuula muukhaawe Suhuriiya na Loothi mwaana wa ttwiiye, na mali zawe zooshi aariinaazo, vamote na amwiitthwaana awe aawaapatthiyeeyo Harani, khusala alawa tuniya ya Kanaani. N'oofiya tuniya ya Kanaani, ");
INSERT INTO eko_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ye khuvira eettettaka tuniya aya etile, khulawa mpakha Shekemu, phantte ya Moore ohali waariiwo muutthi nwulweene. Wakathi aya opule Akanaani aari oretta eekhalaka tuniya ethiitile. ");
INSERT INTO eko_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Nnyizinku khunteela Eburamu, khumuuza yoori: “Tuniya eti kinteela winkha peewu yawo”. Aphano Eburamu khunjekela alitaari Nnyizinku attaaphale. ");
INSERT INTO eko_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Eeshiyeevo, khusala eetta phantte ya kusini onyaako wa malawa-juwa ya Beetele. N'oofiya onyaako okhule, khweemesa heema yawe. Beetele yaari okhu lintupweelaawo njuwa, Aayi yaari okhu lintthamuwaawo njuwa. Ye khunjekela alitaari Nnyizinku khwaaputu nzina la Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Aphano, ye khusala avira alawaka mpakha Nikeepu, phantte ya kusini ya Kanaani. ");
INSERT INTO eko_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Tuniya ya Kanaani yaapuwiyewo jala ya waatta, aphano Eburamu khulankha khusala alawa tuniya ya Misuri yoori eekhalewo siikhu vattitthiiru. ");
INSERT INTO eko_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Asaleelaka ofiya, khumuuza muukhaawe Suhuriiya yoori: “Osiileze, miiyo kajuwacha yoori weeyo o muukha wooshapweya. ");
INSERT INTO eko_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Amisuri n'oowoona anttela olupa yoori weeyo o muukhaaka, antta okuula yoori weeyo osale na-yo. ");
INSERT INTO eko_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Amana wuuzeliwa olupe yoori nlupwaaka, ahikuule na akikhole saana mwaasa wa weeyo.” ");
INSERT INTO eko_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Wakathi Eburamu afiiyeevo, Amisuri khumoona Suhuriiya yoori aari muukha wooshapweya channu. ");
INSERT INTO eko_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Mifwalume za Firawuuna, amooniyeevo muukha otule, khulawa omuuza Firawuuna yoori amoona muukha wooshapweya. Pi apho khunthuula khunlawana wa Firawuuna. ");
INSERT INTO eko_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Eburamu aakholiwe saana ti Firawuuna mwaasa wa muukha otule, khwinkhiwa pwittipwitthi, mompe, amwiitthwaana aalume na aakha, apuuru na khavalo. ");
INSERT INTO eko_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ila Nnyizinku khunhukhumu Firawuuna, khuntiisela pala ya waatta na ajamaaze, mwaasa wa Suhuriiya muukha wa Eburamu. ");
INSERT INTO eko_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Aphano, Firawuuna khunkhuwelisa Eburamu, khumuuzela yoori: “Mwaasa aya niini okirettelaka toono? Wahaakuuziye yoori otu muukhaawo? ");
INSERT INTO eko_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Khi apho waari olupaaye yoori ti nlupuwo? Mwaasa wa weeyo ori nlupuwo, ti eto yaakipatthisiyeeyo onrala. Apho muukhaawo otu, onthuule olawe!” ");
INSERT INTO eko_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Aphano Firawuuna khuwaaruma atthu awe omperekha Eburamu yoori aleemo mmuti mphule na muukhaawe na vitthu zawe zooshi. ");
INSERT INTO eko_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Aphano Eburamu khulaawo Misuri khweetta phantte ya kashikhazini khulawa mpakha Nikeepu, ye na muukhaawe na vitthu zawe zooshi, vamote na Loothi. ");
INSERT INTO eko_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Eburamu aari thaajiri nwulweene. Aarina nyama za waatta, na feeta na thahapu. ");
INSERT INTO eko_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ye khulaawo Nikeepu, khulawa phantte ya kashikhazini ajeettettelaka wakhula phantte mpakha nti wa Beetele, attaaphale eemesiyeevo heema yawe omwanzo, nakatthi-nakatthi ya Beetele na Aayi. ");
INSERT INTO eko_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Attaaphale anjekiyeevo alitaari, ye khwaaputu nzina la Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Na-ye Loothi otule aari weettettanaaye Eburamu, aarina pwittipwitthi, mompe na heema za waatta. ");
INSERT INTO eko_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Khayaari owaheya wiikhala vamote mwaasa yoori nti opule khawaarina tthuttu yoofiyela ojisa nyama zaya. ");
INSERT INTO eko_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Pi apho, khupuwa onyakulisana amakhampuzi a Eburamu na amakhampuzi a Loothi. Wakathi aya opo Akanaani na Aperizi aari oretta eekhalaka nti otthuupule. ");
INSERT INTO eko_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Eburamu khumuuza Loothi yoori: “Ohiiyevo ohisiilani miiyo na-weyo, wala amakhampuzi aka na awo, mwaasa yoori ojama etthu mmote. ");
INSERT INTO eko_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Tuniya yooshi khiri mmakhono mwawo? Nlawe nimwazeyane, othawule phantte ontakhaaye olawa. Weeyo weettaru nkhono-nkha, miiyo kintta nkhono-nlume, weettaru nkhono-nlume miiyo kintta nkhono-nkha.” ");
INSERT INTO eko_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Loothi khulansa maasho awe khoona nttapo la muuttho Yorotaani lihiniishaaye maati liri looripelela mpakha nti wa Zowaari. Nttapo ntthile laari nkhama woorotha wa Eeteni, na loolattanana tuniya ya Misuri. Wakathi aya opo Nnyizinku aarettiye ahinapweche nti wa Sotooma na Komoora. ");
INSERT INTO eko_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Aphano, Loothi khuthawula nttapo la Yorotaani, khumwazeyana na Eburamu, khusala alawa phantte ya malawa-juwa. ");
INSERT INTO eko_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Eburamu khusala eekhala tuniya ya Kanaani, Loothi khweemesa heema zawe waattamana na Sotooma, kharipu na sitati za nkerekhere wa nttapo la Yorotaani. ");
INSERT INTO eko_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ila atthu a Sotooma aari ootakhala rooho, aari annya-twampi ooziti mmakhono wa Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Paata ya Loothi olawa, Nnyizinku khumuuza Eburamu araka: Olanse maasho awo attaapho oriivo, weekese kashikhazini na kusini, na okhu lintthamuwaawo njuwa mpakha lintupweelaawo. ");
INSERT INTO eko_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Tuniya eto yooshi onoonaaye kinteela owinkha weeyo na peewu yawo khwa mileele. ");
INSERT INTO eko_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Kinteela waattisa peewu yawo nkhama mishaka za voolumwenku, nkhama etthiipo ahinteelaaye wiiyavo ntthu wa waalaka mishaka za voolumwenku, na peewu yawo khinteela waalakeya. ");
INSERT INTO eko_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Olankhe ozukulele tuniya eti woone olepa waya na owula waya, mwaasa yoori kinttela owinkha weeyo. ");
INSERT INTO eko_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Aphano Eburamu khuthamisa heema zawe, khulawa khwiikhala aphale zaariivo miitthi miwulu-miwulu nti wa Manre sitati ya Heporooni. Attaaphale ye khunjekela alitaari Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Wakathi aya opo Amirafeele aari mfwalume wa Shinaari, Ariyookho mfwalume wa Elazaari, Ketorilameeri mfwalume wa Elamu, na Titaali mfwalume wa Koyiimu, ");
INSERT INTO eko_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","khulankhaza olawa wuumanana viittha Peera mfwalume wa Sotooma, Piirisha mfwalume wa Komoora, Shinaapu mfwalume wa Aatima, Shemeepere mfwalume wa Zeboyimu, na mfwalume wa sitati ya Peela, yaari wiitthiwaaye Zowaari. ");
INSERT INTO eko_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Afwalume apa athaanu khuwaakusanya anajanka aya nttapo la Siitimu (liiyiyeeyo ntthatta la maati majiphwaani). ");
INSERT INTO eko_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Mfwalume Ketorilameeri, aawaashinttiye afwalume apale athaanu khwa nyaakha khumi na miwiri, ila mwaakha wakhuumi na ttaatthu aya khunzukuluwelaza. ");
INSERT INTO eko_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mwaakha wakhuumi na nne Ketorilameeri khuta vamote na afwalume apale aaphakanyeyaniyeeyo, khuwaashintta Arefayi o'Ashiteroothi-Karinayimu, Azuuzimu o'Haamu, na Aheemi o'Shave-Kiriyatayimu. ");
INSERT INTO eko_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Theenya khuwaashintta Ahoori omwaako wa Seyiiri, khuwiikarisa mpakha Paraani ohali yaaziyeewo yaara. ");
INSERT INTO eko_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Arutaka khuviraza Kateeshi waari wiittheliwakaawo Emishipathi, khuwaattapwattha atthu ooshi a nti wa Amalekiita na theenya Amoori aari wiikhalaaye nti wa Hazaazoni-Tamara. ");
INSERT INTO eko_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Aphano khulankha mfwalume wa Sotooma, mfwalume wa Komoora, mfwalume wa Atima, mfwalume wa Zeboyimu, na mfwalume wa sitati ya Peela (eti yaari wiitthiwaaye Zowaari), khulankha olawa wuumanisa viittha nttapo la Siitimu. ");
INSERT INTO eko_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Aari wuumanaza na Ketorilameeri mfwalume wa Elamu, Titaali mfwalume wa Koyiimu, Amirafeele mfwalume wa Shinaari, na Ariyookho mfwalume wa Elazaari. Aari afwalume athaanu aari wuumananaaye afwalume wane. ");
INSERT INTO eko_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Nttapo la Siitimu laarina milipu za waatta za piriniisi. Wakathi aari otthiraavo afwalume a Sotooma na Komoora, anajanka aya eetta okwela mmilipu, apale akinoko aya khutthirela nnyaako. ");
INSERT INTO eko_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Afwalume apale wane aashinttiyeeyo khuthuula maali zooshi za Sotooma na Komoora na vitthu-zooja zaya khulawaza. ");
INSERT INTO eko_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Na theenya khunthuula Loothi, mwaana wa ttwiiye Eburamu na mali zawe zooshi, mwaasa aya ye aari wiikhala Sotooma. ");
INSERT INTO eko_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Aarivo mwinyi mmote oosurukhiyeeyo, ye khulawa khumweeleza zooshi Eburamu Mwiibereewu, aari wiikhalaaye kharipu na miitthi miwulu-miwulu za Manre Mmori. Manre na attwiize, Sikhoole na Aneeri, aari atthu oosiilana na Eburamu. ");
INSERT INTO eko_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Asiiliyeevo Eburamu oriwa ntuuluwe akholiwa, khuwaathuula alume miiya ttatthu na khumi na wanaane aawaakhupaliyeeyo, oovokoliwa vaje vawe, khusala aweekarisa afwalume apale wane mpakha nti wa Daani. ");
INSERT INTO eko_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ye khuwaawanya alume apale khuntti-khuntti, khuumanisa viittha osikhu mpakha owaashintta maatuwi aya, khuweekarisa mpakha nti wa Hoopa, phantte ya kashikhazini ya Tamaashiku. ");
INSERT INTO eko_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Khuwaanyakanya maali zooshi aathuuliyeeyo, khunthuula Loothi ntuuluwe na mali zawe, vamote na aakha na atthu akinoko aakholiweeyo khuwaarutisa. ");
INSERT INTO eko_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Wakathi Eburamu anshinttiyeevo mfwalume Ketorilameeri na afwalume aaphakanyeyaniyeeyo, mfwalume wa Sotooma khusala alawa ompokherela nttapo la muuttho Shaawe liniittheliwaaye “Nttapo la Mfwalume”. ");
INSERT INTO eko_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Aarivo mfwalume wa nti wa Salemu, aari wiitthiwaaye Melikiseetekhi. Khutiisa phaawu na viinyu. Ye aari haakhimu wa tiini ya Nluku Nwulu wa Pinkuuni, ");
INSERT INTO eko_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","khumparikhiya Eburamu araka: “Aparikhiyiwe Eburamu ti Nluku Nwulu wa Pinkuuni, otu ompiye pinku na vathi. ");
INSERT INTO eko_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Woottitthimisiwa eeye Nluku Nwulu wa Pinkuuni, otu awinkhiyeeyo owaashintta maatuwi awo.” Aphano, Eburamu khulaza lifunku lakhuumi khwa zooshi epile aataniyeezo, khumwinkha Melikiseetekhi. ");
INSERT INTO eko_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mfwalume wa Sotooma khumuuza yoori: “Miiyo okinkhe atthu paasi. Maali zooshi osalane weeyo.” ");
INSERT INTO eko_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Eburamu khunjipu mfwalume araka: “Kalansa makhono aka kinlanselaka Nnyizinku, Nluku Nwulu wa Pinkuuni ompiye pinku na vathi, ");
INSERT INTO eko_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","na kinlapha yoori akinsalana hatha etthu yaawo, wala luuzi wala nliiza wa jampali, ohiri nawiikhala, olupa yoori ‘Eburamu kanreelisa’. ");
INSERT INTO eko_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Miiyo khina etthu moote kintakhaaye, yoohiiyi etile ajiiye atthu aka. Ila apale aaphakanyeyiyeeyo na-miyo, Aneeri, Sikhoole na Manre, apa ana ya wiiyana lifunku laya”. ");
INSERT INTO eko_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Paata ya vitthu epile, Nnyizinku anttakhulaniye Eburamu nkatthi wa ezimu amuuzaka yoori: “Eburamu ohoove! Miiyo ki namwaakisa awo, na tthuvo yawo enteela wiiya yooziti owula.” ");
INSERT INTO eko_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Eburamu khujipu: “Mbwanaaka Nnyizinku ontakha okinkha-ni na miiyo akina hatha mwaana wa waarithi aka? Antakhaaye orithi vaje vaka ti Elizeeri wa Tamaashiku. ");
INSERT INTO eko_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Khukinkheeni mwaana; apho, karumeya wa vaje vaka ti ye anttelaaye orithi vitthu zaka.” ");
INSERT INTO eko_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Aphano Nnyizinku khunjipu: “Namarithi vitthu zawo khanttela wiiya oto, ila mwaana woovokoliwa ti weyo ti anttelaaye orithi.” ");
INSERT INTO eko_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Khunsarulamo nheema mwawe khumuuza yoori: “Weekese otulu, waalake matthottowa nkhama anaalakeya. Peewu yawo enteela wiiya etthiipo.” ");
INSERT INTO eko_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ye khumwaamini Nnyizinku, na-ye khukhupaliwa ti Nnyizinku wiiya ntthu wa shariya. ");
INSERT INTO eko_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Nnyizinku khumuuza Eburamu theenya: “Miiyo ki Nnyizinku kuulaziyeeyo Wuuri nti wa Babilooniya yoori kiwinkhe tuniya eti orithi.” ");
INSERT INTO eko_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Eburamu khumuuzela yoori: “Oo Mbwanaaka Nnyizinku, kihakikhi toovi yoori kinteela orithi tuniya eti?” ");
INSERT INTO eko_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Nnyizinku khujipu: “Okitiisele mwaana wa mompe, wa puuzi, na wa pwittipwitthi, zooshi za wiiyana nyaakha mittatthu, na theenya likhoko na jiwa moote”. ");
INSERT INTO eko_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ye khutiisa nyama epile zooshi, khusala ashija vakatthi wakhula nyama n'oothata wakhula erikitthili omaasho wa erikitthili kiina yaya. Ila likhoko na jiwa khuhishiji vakatthi. ");
INSERT INTO eko_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Mirepo khusala ziishukhela mphule zaariimo nyama epile zooshijiwa, ila Eburamu khusala eekara. ");
INSERT INTO eko_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Njuwa leettelaka otupweela, Eburamu khunkhola osikizi wa waatta khusala oona yiiza ya waatta na woova. ");
INSERT INTO eko_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Aphano Nnyizinku khumuuza yoori: “Ojuwache yoori peewu yawo enteela omaka nti woohiiyi waaya, enteela orettiwa omwiitthwaana na ohoochiwa nyaakha miiya nne. ");
INSERT INTO eko_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ila miiyo kinteela owaahukhumu atthu apo anttelaaye oretta omwiitthwaana, na enteela olaawo na maali za waatta. ");
INSERT INTO eko_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Weeyo onttela wuuluvala ori wooparikhiyiwa na onteela ofwa na heeri. ");
INSERT INTO eko_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Paata yoovira nyaakha epo miiya nne, peewu yawo enteela orutela tuniya eti, amana Amoori apa aniikhalaaye nttumphu atepa oretta vitthu zootakhala, miiyo kinteela owaahukhumu na kiweekare.” ");
INSERT INTO eko_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Litupweeliyeevo njuwa, waariipiye vathi khupuwa loosi la njocho na mweeke wa moottho khuvira vakatthi wa virikitthili za nyama epile zaashijiweezo. ");
INSERT INTO eko_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Siikhu ethiitile, Nnyizinku khuretta wahati na Eburamu, khumuuza yoori: “Tuniya eti kinteela winkha peewu yawo, waaza muuttho wa Misuri mpakha muuttho nwulu oniitthiwaaye Efwarathi, ");
INSERT INTO eko_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","otthaamo nti wa Akeni, wa Akenizi, wa Akatemoni, ");
INSERT INTO eko_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","wa Ahiiti, wa Aperizi, wa Arefayi, ");
INSERT INTO eko_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","wa Amoori, wa Akanaani, wa Akirikashi na wa Ayepuzi.” ");
INSERT INTO eko_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Wakathi aya opo, Suhuriiya muukha wa Eburamu khaari ovokola. Ye aarina njaazi mmote wa Misuri aari wiitthiwaaye Hajira. ");
INSERT INTO eko_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Siikhu moote, Suhuriiya khumuuza mannawe Eburamu yoori: “Nnyizinku khanikinkha mwaana, apho orapalelane njaazi aka, khinjuweya kimpatthaka mwaana khwa ye.” Asiiliyeevo toole, Eburamu khukhupalela mattakhuzi apale a muukhaawe. ");
INSERT INTO eko_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Suhuriiya khunthuula njaazi otule khumwinkha Eburamu yoori eeye muukhaawe waphiiri. Vitthu epi zarettikhana Eburamu arina nyaakha khumi eekhalaka tuniya ya Kanaani. ");
INSERT INTO eko_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Eburamu khurapalela na Hajira, ye khwiiya wa wiimittha. Ooniyeevo yoori eemittha khwaaza ontwayifu nhano awe. ");
INSERT INTO eko_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Suhuriiya khumuuza Eburamu yoori: “Miiyo kanthuula njaazi aka khuwinkha, ye n'oojuwa yoori eemittha aaza okitwayifu. Okitwayifusha opu anikirettelaaye Hajira, khahi etthu ya shariya, ti weyo onintakhelaaye. Nnyizinku ti aniphuke miiyo na-weyo.” ");
INSERT INTO eko_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Eburamu khunjipu Suhuriiya yoori: “Ye nalelo njaazi awo, onrettele khwa nanna ontakhaazo.” Aphano Suhuriiya khwaaza ontarawu Hajira mpakha khufiyelela otthira. ");
INSERT INTO eko_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Nlayikha la Nnyizinku khunsikana Hajira n'yaara eemeliye kharipu na naattuuttu wa maati aattameliyeeyo tarikhi ya Shuuri. ");
INSERT INTO eko_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Nlayikha ntthile khumuuzela liraka: “Weeyo Hajira njaazi wa Suhuriiya! Onlankha vayi wala ontta vayi?” Ye khujipu: “Keetta otthira vaje wa nhano aka Suhuriiya othuuto.” ");
INSERT INTO eko_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Nlayikha khumuuza yoori: “Orutele wa nhano awo, wanshututele.” ");
INSERT INTO eko_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Khumuuza theenya yoori: “Kinteela waattisa peewu yawo khwa nanna ehinaalakeyaaye. ");
INSERT INTO eko_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Apho wiimitthiyeevo onteela ompattha mwaana ontthaje nzina la Esumayila, mwaasa yoori Nnyizinku oona ohoowa wawo. ");
INSERT INTO eko_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ye onteela wiiya woohisiilaneyi nkhama nyama ya ntthuttu; onteela wiiya muumani wa atthu ooshi, na-yo anteela wuumana na ye, na onteela wiiya wa waattuwana na attwiize.” ");
INSERT INTO eko_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hajira khujuuzela mwennyeweru yoori: “Kamoona Nluku, nalelo kiri haayi?” Aphano khunkhuwelela Nnyizinku nzina liriina maana a “Nluku anikoonaaye”. ");
INSERT INTO eko_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Pi apho nlipu aya opule oniittheliwa “Peeri-Lahayi-Rooyi”. Nlipu aya opu ori enakatthi-nakatthi ya Kateeshi na Peereti. ");
INSERT INTO eko_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hajira khumpattha mwaana wa Eburamu. Eburamu khuntthaja mwaana otule nzina la Esumayila. ");
INSERT INTO eko_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Wakathi Hajira ampatthiyeevo mwaana otule, Eburamu aarettiye arina nyaakha thamaaniini na sitha. ");
INSERT INTO eko_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Wakathi Eburamu afiiyeevo nyaakha tiisiini na tiisiya, Nnyizinku anteeliye khusala amuuza araka: “Miiyo ki Nluku Woowahi Zooshi: weettettele mwentto kintakhaaye miiyo, wiiye ntthu nkemaani, ");
INSERT INTO eko_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","yoori kirette wahati miiyo na-weyo, na kinteela owinkha peewu ya waatta.” ");
INSERT INTO eko_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Aphano Eburamu khukokhora khulawa sijita, Nluku khusala anttakhulana ye araka: ");
INSERT INTO eko_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Wahati opu kinrettanaaye weeyo, phantte yaka kiniwaahiti yoori onteela wiiya paapa wa khapila za waatta. ");
INSERT INTO eko_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Waaza leelo nzina lawo khahiyo Eburamu, ila Eburahiima ti linttelaaye wiiya nzina lawo, mwaasa yoori kinttela wuuretta opaapa wa khapila za waatta. ");
INSERT INTO eko_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Kinteela waattisa channu peewu yawo, khwa weyo kinretta khapila za waatta, akinoko aya anteela wiiya afwalume. ");
INSERT INTO eko_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Wahati opu kinrettaaye na-weyo na peewu yawo, onttela wiiya wa mileele; Miiyo ki Nluku awo na wa peewu yawo. ");
INSERT INTO eko_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Kinteela owinkha tuniya eti oniikhalaaye, weeyaru pure mmalapo. Tuniya yooshi ya Kanaani kinteela winkha peewu yawo khwa mileele, na-miyo kinteela wiiya Nluku aya.” ");
INSERT INTO eko_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Nluku khurutela omuuza yoori: “Phantte yawo ona yooshututela wahati aka, weeyo na peewu yawo khwa mileele. ");
INSERT INTO eko_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Wahati onttelaaye oshuka, waaka Miiyo na-weyo na peewu yawo pi opu: wakhula mwaana wanlume ona yookhiriyisiwa. ");
INSERT INTO eko_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Okhiriya waya opo, alama ya wahati aka miiyo na-mweyo. ");
INSERT INTO eko_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Wakhula mwaana anvokoliwaaye wanlume vakatthi wa peewu yawo, n'oofiya siikhu yanaane ona yookhiriyisiwa, hatha nkhama karumeya woovokoliwa vaje vawo, mpakha amwiitthwaana apale amalapo a wuuzanyiwa na apale oohiiyi a peewu yawo. ");
INSERT INTO eko_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Hatha nkhama pi apa oovokoliwa vaje vawo mpakha apa a wuuzanyiwa ana yookhiriyisiwa. Alama eti yookhiriya vamwiili venu, enthoonyeza wahati aka na-mweyo khwa mileele. ");
INSERT INTO eko_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Otule ahinttelaaye okhiriya eekariwemo muumathi mwenu, mwaasa yoori akattha wahati aka.” ");
INSERT INTO eko_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Nluku khumuuza Eburahiima theenya yoori: “Muukhaawo khanteela wiitthiwa theenya Suhuriiya, ila nka eetthiwaka Suhura. ");
INSERT INTO eko_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Kinteela omparikhiya na kimwinkhe mwaana wawo; khweele, miiyo kinimparikhiya na onteela wiiya maama wa khapila za waatta, afwalume anteela opuwa khwa ye.” ");
INSERT INTO eko_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Aphano Eburahiima khukokhora khusijiti, ila khusala ajitheyela nroho mwawe ajuuzelaka toono: “Nlume wa nyaakha miiya eeyane mwaana? Khi Suhura ariina nyaakha tiisiini ate ampatthe mwaana?” ");
INSERT INTO eko_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Eburahiima khumuuza Nluku: “Omparikhiye Esumayila, eeye namarithi aka.” ");
INSERT INTO eko_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ila Nluku khunjipu: “Miiyo kiniwuuza khweele yoori, muukhaawo Suhura onteela ompattha mwaana, ontthaje nzina la Esiyaakha. Kinteela oshuka wahati aka na-ye, na peewu yawe entaaye khwa mileele. ");
INSERT INTO eko_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Kasiila oveka wawo khwa Esumayila. Kinteela omparikhiya na kinteela omwinkha peewu ya waatta. Ye onteela wiiya paapa wa mifwalume khumi na awiri, khwa ye enteela opuwa theenya khapila ya waatta. ");
INSERT INTO eko_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ila wahati aka kinteela oshuka mmakhono wa Esiyaakha, otu anttelaaye ovokoliwa ti Suhura wakathi otthuupu wa mwaakhani.” ");
INSERT INTO eko_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Nawiisha ottakhula na Eburahiima, Nluku khulawa. ");
INSERT INTO eko_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Siikhu ethiitile, Eburahiima khunthuula mwanawe Esumayila na ooshi aavokoliweeyo vaje vawe na apale aawuuzanyiyeeyo. Khulawa owaakhiriyisa, nkhama etthiipo Nluku aamuuziyeezo. ");
INSERT INTO eko_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Wakathi aakhiriyaziyeevo, Eburahiima aarettiye arina nyaakha tiisiini na tiisiya ");
INSERT INTO eko_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","na mwanawe Esumayila aari oretta arina nyaakha khumi na mittatthu. ");
INSERT INTO eko_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Eburahiima na mwanawe aakhiriyiye siikhu moote, ");
INSERT INTO eko_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","vamote na apale aavokoliweeyo owawe, mpakha amalapo apale a wuuzanyiwa. ");
INSERT INTO eko_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Siikhu moote, Nnyizinku aatiiye ottakhula na Eburahiima vahali zaariivo miitthi miwulu-miwulu za Manre. Yaari elukuluku na yaarivo haari ya waatta, Eburahiima aarettiye eekhaliye vanlako wa heema yawe. ");
INSERT INTO eko_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ye khulansa maasho awe khuwoona alume attatthu eemeliye kharipu. Aphano awooniyeevo khulankhavo aphale vaya, khusala awaatthirela. Awaafiyeliyeevo khukokhora khulawa sijita. ");
INSERT INTO eko_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Khuwooza yoori: “Mbwanaaka, nkhama kinaaye sehemu mmakhono mwenu, kinuuvekelani yoori mwihivikane vaje vaka, mwihivumuleeni vattitthiiru. ");
INSERT INTO eko_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Mwiikhale vamwiivuuli wa muutthi opu mwivumule, antta otiisiwa maati vattitthiiru moose moolweenu, ");
INSERT INTO eko_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","wiiya mwavira vaje wa karumeyeenu, kintta weettela etthu ttiitthiiru mwisapeye, yoori mwipatthe kuvu yoorutela safwari yenu.” Yo khujipu yoori: “Kemaani! Erettikhane khwa nanna onlupaazo.” ");
INSERT INTO eko_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Aphano Eburahiima khutthira eettaka nheema mwawe khumuuza Suhura yoori: “Othuule miphimo miwulu mittatthu z'oofu wa tiriku yooshapweya, okhatte wooche phaawu wa waakuvavo.” ");
INSERT INTO eko_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Nawiisha, khutthirela onzizi wawe khunthuula mwaana wa mompe woonenevacha, khumwinkha karumeyaawe yoori anshije na amwiipikhe wa waakuveyavo. ");
INSERT INTO eko_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Eburahiima khuthuula mompe etile yawiipikhiwa saana, manteeka na leethi khuwenkha aletto apale, ye khweemela nshini wa muutthi kharipu na aletto apale eettaka oja. ");
INSERT INTO eko_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Yo khumuuzela: “Khi muukhaawo Suhura ori vayi?” Eburahiima khujipu: “Ori nheema mpho.” ");
INSERT INTO eko_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Mmote wa yo khuri: “N'oovira mwaakha, kinrutela vaje vawo attaapha, na muukhaawo onretta ampatthiye mwaana.” Suhura aari oretta ari vanlako wa heema onyoko wa Eburahiima, eettaka osiila mattakhuzi apale aari ottakhuliwaaye. ");
INSERT INTO eko_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Eburahiima na Suhura aari a wuuluvala na kuvu, na Suhura zanvireliye siikhu zoovokola. ");
INSERT INTO eko_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ye khusala ajitheyela nroho mwawe otthwe ajuuzelaka yoori: “Khwa nanna eti nuuluvaliyeezo miiyo na mbwanaaka, kinteela wiiyana furaha yaya eto?” ");
INSERT INTO eko_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Aphano Nnyizinku khumuuzela Eburahiima yoori: “Muukhaawo ontheya-ni? Wala alupisiwa-ni yoori ‘kinteela ompattha toovi mwaana kuuluvaliye?’ ");
INSERT INTO eko_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ewaapho etthu yoolipa mmakhono wa Nnyizinku? Nkhama etthiipo kilupiyeeyo yoori n'oovira mwaakha kinta wuuthotola, wakathi aya otthuupo Suhura onteela ompattha mwaana wanlume.” ");
INSERT INTO eko_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Mwaasa wa woova Suhura khusala akhana yoori: “Akitheyeeni.” Ye khuri: “Khahiye toowo, khweele weeyo watheya.” ");
INSERT INTO eko_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Wakathi alume apale attatthu alankhiyeevo eeshukhelaka nti wa Sotooma, Eburahiima alankhiye khusala awaaperekha alawaka oleezanana. ");
INSERT INTO eko_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Aphano Nnyizinku khujuuzela mwennyeweru yoori: “Akinta kimuuze Eburahiima etthu kinttelaaye oretta? ");
INSERT INTO eko_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Khweele-khweele Eburahiima onteela wiiya paapa w'oomathi nwulweene woowahi; khwa ye, kinteela oparikhiya khapila zooshi za voolumwenku. ");
INSERT INTO eko_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Maana miiyo kanthawula ye yoori awaanozele aanaawe na omathaawe, weettettela saana tarikhi ya Nnyizinku, arettaka etile yiiyiye ya shariya na yoolotteya, yoori miiyo Nnyizinku kirette khwa Eburahiima etile kaahitiyeeyo.” ");
INSERT INTO eko_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Nnyizinku khumuuza Eburahiima yoori; “Kinsiila nkhuwo yoori atthu a Sotooma na Komoora anretta vitthu zootakhala na twampi zaya pi zooziti. ");
INSERT INTO eko_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Kineetta ottuukhu kilawe koone khiima za twampi epo anrettaazo nkhama khweele pi etthiipo kinsiilaazo, kinttela ohakikhi.” ");
INSERT INTO eko_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Attaaphale, alume apale awiri khusala alawa Sotooma, ila Nnyizinku khusala ari vamote na Eburahiima. ");
INSERT INTO eko_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Eburahiima khunsusela Nnyizinku khumuuzela yoori: “Onttela owooleela vamote anashariya na anapaathuli? ");
INSERT INTO eko_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Khi amana eeyawo atthu hamusiini anashariya, ompwecha sitati etile? Khunteela owaaswaamihi mwaasa wa atthu apo hamusiini anashariya? ");
INSERT INTO eko_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ohiiye weeyo wooretta etthu nkhama eto, yoowuuleela vamote anashariya na anapaathuli. Khawaari oteela owaahukhumu anashariya mwaasa wa vitthu zoorettiwa pi anapaathuli. Weeyo o namaphuka w'oolumwenku wooshi, khunteela ophuka na shariya?” ");
INSERT INTO eko_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Nnyizinku khujipu araka: “Amana kifiya Sotooma kiwaasikana anashariya hamusiini ari nsitati nttumphule, kinttela oswaamihi sitati yaya etile kiiswa ya yo.” ");
INSERT INTO eko_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Eburahiima khurutela ottakhula araka: “Okiswaamihi na ruhusa kiriina yoottakhulana weeyo Mbwanaaka, keeyaru ottophe na fuutha. ");
INSERT INTO eko_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Khi amana asaleelaka athaanu yoori afiyele hamusiini, onipwecha sitati etile mwaasa wa apa ansaleelaaye?” Mbwana khuri: “Amana kiwaasikana arupayiini na athaanu akimpwecha.” ");
INSERT INTO eko_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Khumuuzela theenya; “Khi amana owaasikana arupayiini?” Mbwana khujipu: “Wala, akimpwechawo mwaasa wa apale arupayiini.” ");
INSERT INTO eko_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Khuvira amuuzelaka theenya: “Mbwanaaka, ohikatipukhe amana kirutela ottakhula: khi amana owaasikana anashariya talaathiini?” Mbwana khuri: “Amana kiwaasikanawo talaathiini akinretta hatha etthu.” ");
INSERT INTO eko_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Eburahiima khurutela olupa yoori: “Okiswaamihi na nthiti kiriinaayo la wuuttakhulana Mbwanaaka, khi amana owaasikana anashariya eshiriini?” Ye khuri: “Akimpwechawo mwaasa wa anashariya apale eshiriini.” ");
INSERT INTO eko_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Khulupa theenya Eburahiima: “Mbwanaaka, ohikatipukhe, kiniwuuzela swaafu moote ethiiti paasi; khi amana owaasikanawo anashariya khumi?” Ye khunjipu: “Akimpwechawo mwaasa wa anashariya apale khumi.” ");
INSERT INTO eko_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Nawiisha Nnyizinku ottakhula na Eburahiima, khulankha khusala alawa. Na-ye Eburahiima khurutela owawe. ");
INSERT INTO eko_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Malayikha apale mawiri khufiya Sotooma makaaripi, Loothi aarettiye eekhaliye vanlako wa sitati ethiitile, ye nawoona malayikha apale khusala athepeeza atthirelaka. N'oofiyela khukokhora khusijiti. ");
INSERT INTO eko_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Khuwooza yoori: “Ambwana zaka kookholani moolu, kintakha mwisapuwe owaka miiyo karumeyeenu; moose moolweenu na mwilale, mwilawe meesho supuyeene.” Yo khujipu yoori: “Khinhithajiya, fweeyo ninwahi olala vaparasa veetakale.” ");
INSERT INTO eko_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Loothi khuwaakhanyerela na kuvu mpakha yo okhupali olawa omaka owawe. Ye khurumisa wiipikhiwa etthu-yooja ya nnofu na khoochiwa phaawu yoohiina fwaramento, aletto apale khuja. ");
INSERT INTO eko_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ila ahinalawe olala, eetta ota alume ooshi a sitati ethiitile waaza attunkhulu mpakha mashaapu khuzukulela nyuupa ya Loothi. ");
INSERT INTO eko_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Khusala anyakula ankhuwelaka Loothi araka; “Alume apa atiiyeeyo nnyupa mwawo mphu osikhu otthuupu ari vayi? Owaasarulele vaje apha, fweeyo nintakha niwaalalane”. ");
INSERT INTO eko_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Loothi khusaruwela vaje, khufuka nlako awe afukelaka onyoko wawe. ");
INSERT INTO eko_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Khuwooza yoori: “Safwatali ajamaazaku; mwihirette etthu eto otakhala ");
INSERT INTO eko_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Mweyo! Miiyo kinaaye aanaaka awiri ahiniwaajuwaaye alume. Kintta owinkhani atthaapo, mwiwaarettele wakhula etile mwintakhaaye. Ila mwihiwaarettele etthu yootakhala aletto apa ata nnyupa mwaka, na miiyo kina yoowiinanela.” ");
INSERT INTO eko_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Yo khuri: “Oleevo apha! Weeyo o mmalapo mmuti mphu, ontakha ojinkhe ofwalume na mmuti mwetthu? Fweeyo nintta wuurettela vitthu zooziti epi naari otakhaaye owaarettela apo.” Aphano yo khunsukhuma Loothi, khusala asusela nlako awe yoori apwechaze. ");
INSERT INTO eko_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","N'ooretta toole, aletto apale khunkhola Loothi khumfutthela nnyupa khufuka nlako, ");
INSERT INTO eko_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","na khuwoola maasho alume apale a Sotooma aari vanlako wa Loothi. Waaza attunkhulu mpakha mashaapu khusala apapasela nlako khuhisala asikana. ");
INSERT INTO eko_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Alume apale khumuuzela Loothi: “Onaaye ajaama akina nsitati mphu? Oleemo, owaathuule aanaawo, akhwewo, muukhaawo na ooshi apale eeyiye aawo, ");
INSERT INTO eko_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","mwaasa aya nateela opwecha sitati eti. Nnyizinku asiila nkhuwo nwulweene wa vitthu zootakhala anrettaazo atthu a Sotooma, apha aniruma yoori nite nipweche sitati yaya eti.” ");
INSERT INTO eko_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Aphano ye khulawa owooza akhwewe, apale aari weettelaaye owaarala aanaawe yoori: “Mwileemo nsitati mphu, maana Nnyizinku onttela opwecha.” Ila akhwewe apale khusala oona nkhama nzaha. ");
INSERT INTO eko_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Lifwajiri, malayikha apale khusala amuuza Loothi antumereraka yoori: “Olankhe nasaapi ethiiti, onthuule muukhaawo na aanaawo oowiiri mwileemo mphu. N'oohiretti toowo, amana etaka hukhumu nsitati mphu mweeyo mwintta ofwa.” ");
INSERT INTO eko_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Khusala arupaza, malayikha apale khuwaakhola makhono, ye na muukhaawe na aanaawe oowiiri khuwaalawana othetekele, mwaasa wa Nnyizinku wiiyana huruma na-ye. ");
INSERT INTO eko_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Paata yoolaziwamo nsitati mphule, nlayikha limote khumuuza yoori: “Tthira wuusuru ohaayi awo, na oheekese nyuma wala oheemele hatha vahali ohifiyeeni omwaako yoori ohipwetheye.” ");
INSERT INTO eko_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Loothi khujipu; “Toowo wala safwatali ambwana zaka! ");
INSERT INTO eko_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Wakirettela saana, khukoonela huruma venkivene, khuusuru ohaayi aka. Ila onyaako khu woolepawo, opwechiwa wa sitati eti ontta okisikana kihinafiye. ");
INSERT INTO eko_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Kharipu apho ewaapho sitati ttiitthiiru, kinwahi otthirela ottuukho. Hatha nkhama yeetta opushuwa, mwikilikhe kitthirele ottuukho kuusurukhe.” ");
INSERT INTO eko_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Nlayikha khujipu yoori: “Kakhupali eto ovekiyeeyo, akinteela opwecha sitati yaya eto olupiyeeyo. ");
INSERT INTO eko_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ila waakuve olawe nasaapi ethiiti, miiyo akinretta hatha etthu, weeyo ohifiyeeni ohali onttaawo.” Ti eto sitati yaya eto eniittheliwaaye Zowaari. ");
INSERT INTO eko_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Njuwa litthamuwaka na-ye Loothi afiyaka nti wa Zowaari. ");
INSERT INTO eko_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Aphano Nnyizinku khukwisa mawe a moottho otulu, akwiselaka Sotooma na Komoora. ");
INSERT INTO eko_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Khupwecha sitati epile na miti zaattamananiyeeyo, na atthu aya apale aari wiikhalaamo na tthuttu yaya. ");
INSERT INTO eko_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ila muukha wa Loothi khuzukuluwa khweekesa onyoko ohali aari olankhaawo, khuthatuwa khwiiya sanamu ya mwiinyu. ");
INSERT INTO eko_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Supuyeene Eburahiima aalankhiye khulawa puuro etile aari ottakhulanaavo Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Khweekesa phantte ya Sotooma na Komoora na miti zooshi za shiini yaya etile, khusala oona loosi la waatta leettaka otthuwela mmuti mphule nkhama njocho lookhoziwa. ");
INSERT INTO eko_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Nkatthi woopwecha sitati zooshi za tuniya etile, Nluku khufikhiri etile aavekeliweeyo ti Eburahiima, khumuusuru Loothi vakatthi wa pala yaarettikhaniyeeyo sitati etile aari wiikhalaaye. ");
INSERT INTO eko_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Loothi eetta woova wiikhala Zowaari, khuthama na aanaawe oowiiri khusala eekhala omwaako. Oottaatthu khusala eekhala nlikurakuza. ");
INSERT INTO eko_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Siikhu moote, mwanawe otu nwulu khumuuza otu nttiitthi yoori: “Papeetthu ooluvala na nti opu niriiyo khaamo alume oonirala yoori niwaapatthe aana, nkhama enrettikhanaazo olumwenku wooshi. ");
INSERT INTO eko_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Nlawe nithuule viinyu ninnywise papeetthu ahapaliwe, niwahi orapalelana anivokolele aana, yoori peewu ya papeetthu ehiishe.” ");
INSERT INTO eko_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Osikhu otthuupule khuthuula viinyu khunnywisa papaaya, mwaana otu nwulu aya khulawa khulalana papaawe. Papantthu woohijuwi wakathi arapaleliyeevo wala alankhiyeevo. ");
INSERT INTO eko_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Mmeesho mwaya, otule nwulu khumuuza ttwiiye: “Taana osikhu karapalelana paapa, apho osikhu opu wa leelo nlawe ninhapalise na weeyo olawe warapalelane zwaamu yawo. Anivokolele aana yoori peewu ya papeetthu ehiishe”. ");
INSERT INTO eko_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Osikhu otthuupule khumwinkha papaaya viinyu swaafu yaphiiri, na-ye otu nttiitthi aya khulawa khulalana, theenya papantthu khuhijuwi wakathi arapaleliyeevo wala alankhiyeevo. ");
INSERT INTO eko_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Aana apale oowiiri khwiimittha erukulu ya papaaya. ");
INSERT INTO eko_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Otu nwulu aya khumpattha mwaana wanlume khuntthaja nzina la Mowaabu, ye paapa wa Amowaabu apa ariiwo mpakha leelo. ");
INSERT INTO eko_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Elottelanaka otule nttiitthi aya khumpattha mwaana wanlume khuntthaja nzina la Ben-Ami, ye paapa wa Amooni, apa ariiwo mpakha leelo. ");
INSERT INTO eko_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Eburahiima aalankhiye Manre khulawa nti wa Nikeepu, khwiikhala enakatthi-nakatthi ya Kateeshi na Shuuri. Khuthamela theenya nti wa Kerari. ");
INSERT INTO eko_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ottuukhule, Eburahiima aalupiye yoori Suhura nlupuwe, khupe ari muukhaawe. Aphano Apimeleekhi mfwalume wa nti aya opule, khuruma weetteliwa Suhura, ye khunthuula. ");
INSERT INTO eko_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Osikhu aya, Nluku khunteela Apimeleekhi khusala amuuza nkatthi wa jozi yoori: “Ontta ofwa mwaasa wa muukha otu onthuuliyeeyo, ye onaaye mannawe.” ");
INSERT INTO eko_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ila Apimeleekhi aari ahinarapalelane muukha otule, ye khujipu: “Mbwana, onttela okuula miiyo na atthu aka woohiivo hatha paathuli? ");
INSERT INTO eko_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ti Eburahiima aakuuziye yoori Suhura nlupuwe! Na Suhura khukuuza etthiipo yoori nlupuwe. Miiyo karetta eti na rooho y'ookemaani woohijuwivo etthu.” ");
INSERT INTO eko_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Nluku khunjipu njozi nttumphule yoori: “Miiyo kajuwa yoori vitthu epi waretta na rooho y'ookemaani. Ti eto miiyo kiwiinaneliyeeyo yoori ohikikose, pi apho kihuutakheleeni onsapa muukha oto. ");
INSERT INTO eko_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Apho, onrutisele mannawe muukha oto. Ye napiyu, ontta wuulompela yoori ohifwe, ila amana ohinrutiseli kiniwuuza khweele yoori ontta ofwa weeyo na zooshi epi ziiyiye zaawo.” ");
INSERT INTO eko_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","N'oolankha mmeesho mwaya supu, Apimeleekhi khuwaakhuwela mawaziiri awe khusala awooza epile aalotthiyeezo, yo khwiiya awoova channu. ");
INSERT INTO eko_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Nawiisha, khuruma okhuweliwa Eburahiima khusala amuuzela yoori: “Niini eti oniretteliyeeyo? Kookosela-ni okikwiselaka paathuli ya twampi khuluyeene nkhama eti, miiyo na atthu aka? Etthu okiretteliyeeyo khinrettelaniwaka. ");
INSERT INTO eko_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Woopuweliye niini okirettelaka vitthu nkhama epi?” ");
INSERT INTO eko_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Eburahiima khunjipu: “Miiyo kaari woona yoori atthu a nti opu khanimoova Nluku, antta okuula mwaasa wa muukhaaka. ");
INSERT INTO eko_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Na khweele phantte kiina nlupwaaka, mwaana wa paapa ila khahiyo mwaana wa maama. Ti nanna afiyeleliyeeyo wiiya muukhaaka. ");
INSERT INTO eko_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Wakathi Nluku akilaziyeemo mmuti wa apapazaku, kaamuuziye muukhaaka yoori: ‘Safwatali kintta wuuvekela, wakhula vahali nimfiyaavo osala olupa yoori nlupwaaka’.” ");
INSERT INTO eko_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Aphano Apimeleekhi khuthuula pwittipwitthi, mompe na amwiitthwaana aalume na aakha khumwinkha Eburahiima na theenya khunrutisela muukhaawe. ");
INSERT INTO eko_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Apimeleekhi khuri: “Nti opu pu waaka ohiiyane shaakha, wiikhale wakhula vahali ontakhaavo.” ");
INSERT INTO eko_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Khumuuza Suhura yoori; “Kamwinkha nlupuwo mizurukhu za feeta alufu, ajamaazo ooshi ajuwe yoori khutthekeeni hatha etthu, na ahiiyevo antakhaaye owaakanyerela.” ");
INSERT INTO eko_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Nnyizinku aawaarettiye aakha ooshi a vaje wa Apimeleekhi yoori ahisala avokola, mwaasa wa epile zanrettikhaneliyeeyo Suhura muukha wa Eburahiima. Aphano Eburahiima khunvekela Nluku zwaamu ya Apimeleekhi, Nluku khunvonisa vamote na muukhaawe na akarumeyaawe aakha yoori asala avokola. ");
INSERT INTO eko_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Paata ya toole, Nnyizinku khumparikhiya Suhura, khunrettela etile aamwaahitiyeeyo. ");
INSERT INTO eko_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Suhura khwiimittha khumpattha mwaana wa Eburahiima ari wa wuuluvala, wakathi otthuupule Nluku aamuuziyeeyo. ");
INSERT INTO eko_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Mwaana otule aavokoliweeyo ti Suhura, Eburahiima khuntthaja nzina la Esiyaakha. ");
INSERT INTO eko_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Siikhu yanaane, Eburahiima khunthuula mwaana otule khulawa onkhiriyisa nkhama etthiipo Nluku anrumiyeezo. ");
INSERT INTO eko_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Wakathi Eburahiima ampatthiyeevo mwanawe Esiyaakha, aarettiye arina nyaakha miiya. ");
INSERT INTO eko_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Suhura khuri: “Nluku akinkha otheya, na atthu ooshi apale anttelaaye osiila anttela otheya vamote na-miyo. ");
INSERT INTO eko_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Paani aari waakanyeraaye yoori Eburahiima aari oteela ompatthela mwaana Suhura? Na wuuluvala wawe, miiyo kampatthela mwaana!” ");
INSERT INTO eko_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mwaana otule khusala awula mpakha ofiyelela olikha nziwa. Alikhiyeevo nziwa mwaana otule, papaawe khuretta njampo la furaha. ");
INSERT INTO eko_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ila Suhura khumoona Esumayila mwaana wa Hajira mmisuri, otule aavokoliweeyo ti Eburahiima anveyisaka mwanawe. ");
INSERT INTO eko_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Suhura khulawa omuuza Eburahiima yoori: “Omwiikare njaazi otule na mwanawe. Ye khanteela orithi vamote na mwanaka Esiyaakha.” ");
INSERT INTO eko_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Eburahiima khwiiya woozinkireya na kuvu na mattakhuzi apale mwaasa wa Esumayila wiiya mwanawe. ");
INSERT INTO eko_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Aphano Nluku khumuuza Eburahiima yoori: “Ohizinkireye mwaasa wa mwanawo na njaazi awo, osiileze etile aniwuuzaaye Suhura, mwaasa yoori peewu yawo enttela olankha vakatthi wa Esiyaakha. ");
INSERT INTO eko_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mwaana wa njaazi otule onteela wiiyana omathi wa waatta mwaasa yoori na-ye peewu yawo.” ");
INSERT INTO eko_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Mmeesho mwaya, Eburahiima khuthuula phaawu na ttompwiyo ya maati, khunvikelisa Hajira khunleeza vamote na mwanawe. Yo khusala alawa ajeettettelaka n'yaara ya Beeresheba ahijuwaka ohali anttaawo. ");
INSERT INTO eko_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Wakathi amwiisheliyeevo maati nttompwiyo, ye khunlikha mwanawe nshini wa muutthi. ");
INSERT INTO eko_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Khulankha khulawa khwiikhala ohali woolepawo vattitthiiru na okhule aariiwo mwanawe, mwaasa yoori khaari otakha omoona mwanawe afwaka. Eekhaliye etthiipile, khusala alila. ");
INSERT INTO eko_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nluku khusiila theenya huula ya mwaana otule eettaka olila. Nlayikha la Nluku khukhuwa pinkuuni linkhuwelaka Hajira, khumuuza yoori: “Wakafilikhela-ni Hajira? Ohoove, Nluku asiila huula yawe mwaana oto alilaka vahali ariivo. ");
INSERT INTO eko_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Olankhe onlanse mwanawo onkholele nkhono, phantte yawe kinteela waattisa omathaawe.” ");
INSERT INTO eko_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Elottelanaka Nluku khunthoonyeza Hajira nlipu wa maati, khulawa khuttekhelela ttompwiyo yawe khunnywisa mwanawe. ");
INSERT INTO eko_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Esumayila khusala awula mmakhono wa Nluku. Ye aari wiikhala n'yaara na aari njuwi wa weesa mattetthe. ");
INSERT INTO eko_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Aari wiikhala n'yaara ya Paraani, mamaawe khumweekesela muukha wa Misuri khunlooza. ");
INSERT INTO eko_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Wakathi aya opo, Apimeleekhi aalokoziwe ti Fikhoole namalokozela wa anajanka, khumuuza Eburahiima yoori: “Nluku ori vamote na-weyo khwa wakhula etile onrettaaye. ");
INSERT INTO eko_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Nasaapi ethiiti olaphe khwa nzina la Nluku yoori khunteela okihata miiyo wala aanaaka ama otuulwaka, nkhama etthiipile kuuretteliyeezo zooshapweya, na-miyo okirettele etthiipo na mmuti mphu oniikhalaamo.” ");
INSERT INTO eko_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Khujipu Eburahiima araka: “Miiyo kinlapha”. ");
INSERT INTO eko_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Attaaphale Eburahiima khusala ajiliza mwaasa wa nlipu aanyakanyiweeyo pi akarumeyaawe Apimeleekhi. ");
INSERT INTO eko_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Apimeleekhi khunjipu: “Miiyo akaajuwiyevo etthu na khawaakuuziye, kintta osiilaru nasaapi ethiiti.” ");
INSERT INTO eko_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Aphano Eburahiima khuthuula pwittipwitthi na mompe khumwinkha Apimeleekhi. Oowiiri aya khusiilana. ");
INSERT INTO eko_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Elottelanaka Eburahiima khuphakula pwittipwitthi sapa za nliphanko lawe. ");
INSERT INTO eko_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Apimeleekhi khumuuzela yoori: “Pwittipwitthi epo sapa omphakulaaye maana aya niini?” ");
INSERT INTO eko_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Eburahiima khujipu: “Okhupalele pwittipwitthi epi sapa kiniwinkhaaye khwa lifunku looshaahiti yoori nlipu opu ti miyo kithipiyeeyo.” ");
INSERT INTO eko_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Pi apho puuro yaya eto eniitthiwaaye Beeresheba, mwaasa yoori oowiiri aya aalaphisaniye attaapho. ");
INSERT INTO eko_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Paata yawiisha oosiilana opule Beeresheba okhule aariiwo, Apimeleekhi na Fikhoole namalokozela wa anajanka, khurutela nti wa Afiliishiti. ");
INSERT INTO eko_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Eburahiima n'oosala Beeresheba okhule khuzala muutthi wa nkolokope, khumwaaputu Nnyizinku, Nluku wa Mileele. ");
INSERT INTO eko_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ye khwiikhala nti wa Afiliishiti khwa nyaakha za waatta. ");
INSERT INTO eko_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Paata yoovira nyaakha, Nluku aamweeziye Eburahiima, khunkhuwela araka: “Eburahiima!” Ye khujipu: “Lapeekha!” ");
INSERT INTO eko_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Nluku khumuuza araka: “Onthuule mwanawo Esiyaakha, othuuto mmote oriinaaye onimphetachaaye, olawe mpakha nti wa Moriya, vamwaako oriiye ottuukho kinttelaaye wuuthoonyeza, onrette twaha yoolukuziwa”. ");
INSERT INTO eko_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ye khulankha mmeesho mwaya lifwajiri khunthuula puuru awe khufukavo zaana zawe, khuwaathuula akarumeyaawe awiri na mwanawe Esiyaakha. Khurema khuuni zoolawa orettela twaha yoolukuziwa, khusala alawa ottuukhule Nluku aamuuziyeewo. ");
INSERT INTO eko_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Siikhu yattaatthu, Eburahiima khweesa maasho awe khoona puuro etile ari ohali woolepawo. ");
INSERT INTO eko_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ye khuwooza akarumeyaawe apale yoori: “Mwisale attaapha na puuru otu, miiyo na shapu otu nintta aphale, ninttela omwaaputu Nluku. Amana niisha nintta oruti nite niiye vamote na-mweyo.” ");
INSERT INTO eko_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Eburahiima khuthuula khuuni epile aari weettelaaye orettela twaha yoolukuziwa, khunttikha Esiyaakha mmafuzi mwawe. Ye khuthuula eesu na moottho khusala alawa. ");
INSERT INTO eko_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Esiyaakha khunkhuwela papaawe yoori: “Mweyo paapa!” Ye khujipu: “Lape mwanaka!” Aphano Esiyaakha khumuuzela papaawe: “Nathuula moottho na khuuni, khi pwittipwitthi yoolawa otwahi eri vayi?” ");
INSERT INTO eko_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ye khujipu araka: “Nluku ti ye anjuwaaye pwittipwitthi ninttelaaye orettela twaha yoolukuziwa mwanaka.” Yo khusala alawa vamote. ");
INSERT INTO eko_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","N'oofiya ohali okhule aathoonyeziweewo ti Nluku, khunjeka alitaari vatulu vaya khuthatelavo khuuni. Khumfuka mwanawe Esiyaakha khunttha vatulu wa khuuni. ");
INSERT INTO eko_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Khuthuula eesu, khulansa makhono awe yoori antwahi mwanawe. ");
INSERT INTO eko_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ila nlayikha la Nnyizinku khukhuwa pinkuuni liraka: “Eburahiima! Eburahiima!” Ye khujipu: “Lapeekha!” ");
INSERT INTO eko_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Khumuuza yoori: “Ohimwaavulele eesu shapu oto, na ohinrettele hatha etthu. Aphano kinjuwa yoori onimoova Nluku, mwaasa woohikikhattazi mwanawo mmote othuuto oriina.” ");
INSERT INTO eko_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Eburahiima khuzukuluwa khoona pwittipwitthi ewayiye manyaka aya valikukhu. Ye khulawa khuthuula khurettela twaha yoolukuziwa khwa zwaamu ya mwanawe. ");
INSERT INTO eko_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Aphano khutthaja nzina puuro etile “Nnyizinku ti ye anjuwaaye”. Mpakha eleelo eti oniittheliwavo yoori: “omwaako wa Nnyizinku ti ye anjuwaaye”. ");
INSERT INTO eko_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Elottelanaka, nlayikha la Nnyizinku khukhuwa theenya pinkuuni linkhuwelaka Eburahiima. ");
INSERT INTO eko_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Khumuuza yoori: “Nnyizinku ari: ‘Kinjilaphela ki mwennyeweru, mwaasa weeyo oretta etile kiwuuziyeeyo, ohikikhattazi mwanawo mmote paasi oriinaayo, ");
INSERT INTO eko_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","khweele, kinteela wuuparikhiya na kiwinkhe peewu ya waatta nkhama matthottowa o'otulu na mishaka za mmattima, yo anteela othuula nti wa maatuwi aya. ");
INSERT INTO eko_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Atthu ooshi a voolumwenku anteela oparikhiyiwa, mwaasa wa peewu yawo, maana weeyo wakishututela.’” ");
INSERT INTO eko_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Eburahiima na Esiyaakha khurutela aphale aawaalikhiyeevo akarumeyaawe. Ooshi khurutela Beeresheba ohali Eburahiima aari wiikhalaawo. ");
INSERT INTO eko_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","N'oovira vitthu epile khuuziwa Eburahiima oriwa: “Miilika avokoleliwa aana ti ttwiiyo Nahoori; ");
INSERT INTO eko_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","w'oomwanzo aya nzina lawe ti Wuuzi, na ttwiiye Buuzi, khulotteliwa ti Kemuweeli, papaawe Aramu, ");
INSERT INTO eko_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Keseeti, Haazo, Pilitashi, Yitalafu, na Betuweeli.” ");
INSERT INTO eko_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuweeli khunvokola Repeekha. Aana apo wanaane aawaavokoliye ti Miilika na Nahoori ttwiiye Eburahiima. ");
INSERT INTO eko_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahoori aarina muukha nkinoko aari wiitthiwaaye Rewuma, na-ye anvokoleliye aana; Teepa, Kahaamu, Tahaashi na Maaka. ");
INSERT INTO eko_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Suhura eekhaliye nyaakha miiya na eshiriini na sapa. ");
INSERT INTO eko_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Khufwa Kiriyati-Aarapa (oniittheliwaawo Heporooni) tuniya ya Kanaani. Eburahiima khusala alila na ojikhupanyera ofwa wa Suhura. ");
INSERT INTO eko_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ye khunlikha muukhaawe ari woofwa, khulawa ottakhulana Ahiiti yoori: ");
INSERT INTO eko_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Miiyo ki mmalapo na ki nletto mmuti mphu; ila kinuuvekelani okinkha ruhusa ya wiiyana vilalo yaka mmuti mwenu mphu, yoori kinzikhemo muukhaaka.” ");
INSERT INTO eko_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ahiiti apale khunjipu Eburahiima yoori: ");
INSERT INTO eko_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Osiileze mbwaneetthu, fweeyo niniwinkha hishima nkhama mfwalume wa Nluku. Apho olawe wanzikhe muukhaawo wakhula vilalo etile enuufwayaaye. Khaavo mmote wa fweyo antakhaaye wuukhattaza khapuri yonzikhavo muukhaawo.” ");
INSERT INTO eko_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Aphano Eburahiima khulankha khwiinama omaasho wa Ahiiti, ennyewe nti opule. ");
INSERT INTO eko_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Khuwuuza yoori: “Nkhama khweele mwinaaye niiya yookikhupalela onzikha muukhaaka, mwikivekelele Eforoni, mwaana wa Zohaari, ");
INSERT INTO eko_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","yoori akuuzanyeze likurakuza la Makhipeela liriiye mmwiinano wa nshapa lawe. Miiyo kininripha hisapu yoolikana mooshi moonaka, yoori likurakuza laya nttho liiye vilalo yoowaazikhamo ajamaazaku”. ");
INSERT INTO eko_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Eforoni, Nhiiti otule, aarettiye eekhaliye vamote na attunkhulu a sitati ethiitile, ye khunjipu Eburahiima vakatthi wa Ahiiti ooshi aari vanlako wa sitati ethiitile yoori: ");
INSERT INTO eko_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Wala mbwanaaka! Okisiileze, miiyo kiniwinkha nshapa na likurakuza liriiye nttumpho, kiniwinkha atthu ooshi apa ariiye apha eettaka woona. Olawe wanzikhe muufwi awo.” ");
INSERT INTO eko_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Eburahiima khwiinama swaafu yaphiiri, omaasho wa atthu apale a mmuti mphule. ");
INSERT INTO eko_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ye khumuuza Eforoni atthu ooshi eettaka osiila yoori: “Safwatali mwikisiileze, kintta oripha hisapu la nshapa ntthile. Okhupalele yoori kiwahi onzikhamo muukhaaka.” ");
INSERT INTO eko_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Eforoni khunjipu Eburahiima yoori: ");
INSERT INTO eko_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Okisiileze mbwanaaka! Nti aya opo pu wa mizurukhu za feeta miiya nne. Eto yaya niini miiyo na weeyo? Wanzikhemo muufwi awo.” ");
INSERT INTO eko_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Hisapu etile aalupiyeeyo Eforoni atthu ooshi asiilaka, Eburahiima khukhupalela. Khuphima miphimo miiya nne za mizurukhu wa feeta khumwinkha, nkhama etthiipo aari ophimakaazo anamuuzanyisa. ");
INSERT INTO eko_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Waaza attaapho nshapa la Eforoni laariiye Makhipeela kharipu na Manre, na likurakuza laariimo na miitthi zooshi khwinkhiwa Eburahiima. Ahiiti ooshi apale aari vanlako wa sitati etile eettaka woona. ");
INSERT INTO eko_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Wakathi enkhiweevo nti aya opule, khunthuula muukhaawe Suhura khulawa khunzikha nlikurakuza la Makhipeela kharipu na Manre eriiye Heporooni, tuniya ya Kanaani. ");
INSERT INTO eko_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Khwa etthiipo, khuhakikhiwa nshapa ntthile na likurakuza laya pi Ahiiti wiiya vilalo ya Eburahiima. ");
INSERT INTO eko_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Eburahiima aarettiye ooluvaliye arina nyaakha za waatta, Nnyizinku amparikhiyiye khwa zooshi. ");
INSERT INTO eko_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Siikhu moote, khumuuza karumeya nwulu wa vaje vawe aari weettettisaaye mali zawe zooshi aariinaazo, araka: “Othuule nkhono awo otthe vathi wa liphaja laka yoori ");
INSERT INTO eko_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","kuulaphise khwa nzina la Nnyizinku, Nluku wa pinkuuni na vathi, yoori khunteela omweekesa muukha wa nti otthuupu kiniikhalaaye wa wiiya mwaana wa Akanaani. ");
INSERT INTO eko_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ila olankhe olawe nti w'oowaka wamweekese muukha vakatthi wa ajamaazaku, ate eeye muukha wa Esiyaakha.” ");
INSERT INTO eko_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Karumeya otule khumuuzela yoori: “Khi amana muukha aya oto ahitakhi ota na-miyo mmuti mphu, kinthuule mwanawo kinlawane nti otthuupo olankhiyeeyo?” ");
INSERT INTO eko_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Eburahiima khunjipu: “Phoole! Hatha vattitthiiru ohirette onlawana mwanaka. ");
INSERT INTO eko_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Nnyizinku, Nluku wa pinkuuni akilaza vaje wa apapazaku nti wa ajamaazaku khukaahiti na olapha araka: ‘Nti opu kinttela winkha peewu yawo.’ Ye ontta operekha nlayikha lawe yoori luulokoze, omweettele muukha yoori ate araliwe ti mwanaka Esiyaakha. ");
INSERT INTO eko_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Amana muukha aya oto ahitakhi ota na-weyo, olapha wawo oniiya woofujeya. Ila ohiiye wonthuula mwanaka onlawana.” ");
INSERT INTO eko_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Aphano karumeya otule khuthuula nkhono awe khuttha vathi wa liphaja la Eburahiima mbwanaawe. Khulapha yoori aari weettela oretta etthiipile ooziweezo. ");
INSERT INTO eko_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Karumeya otule khuthuula enkamiiya khumi za mbwanaawe na majathi apale enkhiweeyo khusala alawa nti wa Mezapotaaniya sitati ya Nahoori. ");
INSERT INTO eko_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Afiiyeevo, njuwa looveva wakathi opule aakha anttelakaaye ottekha maati, khukokhorisa enkamiiya zawe epile onlipu kharipu ya sitati. ");
INSERT INTO eko_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Attaaphale khusala alompa araka: “Oh! Nnyizinku, Nluku wa mbwanaaka Eburahiima, kinuuvekela yoori siikhu eti ya leelo okiparikhiye, na onthoonyeze pheta ya waamineya mbwanaaka Eburahiima. ");
INSERT INTO eko_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Onikoonelaavo apha kiri wa weemela kharipu na nlipu, aanaakha a atthu a sitati eti antakaavo ottekha maati. ");
INSERT INTO eko_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Mwaari othuuto kinttelaaye omuuza yoori: ‘Wiinamise yuuku yawo okimeele maati kinywe,’ ye khulupa yoori: ‘Apa nywa, na kintta onywisa enkamiiya zawo,’ eeye othuuto onthawuleliyeeyo Esiyaakha. Ti etthu enttelaaye okijuwisa yoori wanthoonyeza pheta ya waamineya mbwanaaka Eburahiima.” ");
INSERT INTO eko_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ahineeshe olompa, nasaapiru onimoona Rapekha mwaana wa Betuweeli eettaka ota alankhaka nsitati athuuliye yuuku atthiye valifuzi. Betuweeli aari mwaana wa Miilika muukha wa Nahoori, ttwiiye Eburahiima. ");
INSERT INTO eko_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rapekha aari mwaari wooshapweya channu woohinjuwi nlume, ye khwiishukhela vanlipu khuttekha maati khwiitaaza yuuku yawe khuwelela. ");
INSERT INTO eko_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Karumeya otule khulankha khusala antthirela, khumuuza yoori: “Safwatali kimeele maati apo ari n'yuku mwawo kinywe.” ");
INSERT INTO eko_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ye khujipu araka: “Mwiinyi apa mwinywe.” Khurula yuuku khukholelela mmakhono khumwinkha khunywa. ");
INSERT INTO eko_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Nawiisha omwinkha maati, khumuuza yoori: “Kinttela ottekha makina theenya kinkhe enkamiiya zenu zinywe mpakha zooshi ziishe” ");
INSERT INTO eko_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Nasaapiru khwiitthela maati apale n'yopo zaari onywaamo nyama, khwaakuva khulawa vanlipu ottekha swaafu za waatta yoori zinywe enkamiiya zooshi. ");
INSERT INTO eko_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mwinyi otule khusala anyamaliye amweekesaka mwaari otule saaneene yoori ajuwe nkhama Nnyizinku aparikhiya safwari yawe ama wala. ");
INSERT INTO eko_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ziishiyeevo onywa enkamiiya epile, khulaza kharawu ya thahapu ya karaama sitha na kakhana piiri za thahapu zaari ochiraaye karaama miiya olemela waya khunwalisa mmakhono mwawe. ");
INSERT INTO eko_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Khumuuzela yoori: “Weeyo o mwaana waani? Safwatali nkakuuze nkhama wa papaawo ewaakho puuro y'oolalawo miiyo na ashirikhaaka apa.” ");
INSERT INTO eko_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ye khujipu: “Miiyo ki mwaana wa Betuweeli, mwaana wa Miilika na Nahoori. ");
INSERT INTO eko_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Onti ewaakho puuro yoolalawo mweeyo, na nyaani za waatta zooja enkamiiya zenu.” ");
INSERT INTO eko_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Aphano karumeya otule khukokhora khumwaaputu Nnyizinku, ");
INSERT INTO eko_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","araka: “Asifwiwe Nnyizinku, Nluku wa mbwanaaka Eburahiima, ahisahaweeni onthoonyeza pheta yawe ya waamineya, maana akilokoza mpakha vaje wa ajamaaze mbwanaaka.” ");
INSERT INTO eko_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Aphano mwaari otule khutthira eettaka owawe, khuwooza ajamaaze vitthu zaarettikhaniyeezo. ");
INSERT INTO eko_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rapekha aarina nlupuwe aari wiitthiwaaye Labani. Ye khutthira eettaka onlipu yoori amoone ntthu aya otule. ");
INSERT INTO eko_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Mwaasa wa woona kharawu na kakhana aawalisiweeyo nlupuwe, na khusiila vitthu ooziweeyo Rapekha ti nlume otule, ye khulankha khusala alawa omoona nlume otule ottuukhule aariiwo na enkamiiya zawe nshini wa nlipu. ");
INSERT INTO eko_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Labani khuri: “Ote okhuno, weeyo wooparikhiyiwa ti Nnyizinku! Weekhalela-ni veetakale apho? Kawaattalelela puuro onti na vahali woopwehavo enkamiiya zawo.” ");
INSERT INTO eko_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Labani khuta na karumeya otule mpakha owawe, khuruma wiishushiwa mapwattha vankamiiya epile na khwinkhiwa nyaani yoori zije. Khwinkhiwa maati yoori oose moolu awe na atthu apale aarinaaye. ");
INSERT INTO eko_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Nawiisha khutiisiwa etthu-yooja khwinkhiwa, ila karumeya otule khuri: “Akinja kihaazeeni olupa eti kaateeliyeeyo.” Labani khumuuza yoori: “Haya lupa.” ");
INSERT INTO eko_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Aphano khwaaza olupa araka: “Miiyo ki karumeya wa Eburahiima. ");
INSERT INTO eko_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Nnyizinku amparikhiya venkivene, amwinkha maali khwiiya woojuwanikha; onaaye pwittipwitthi na mompe, feeta na thahapu, akarumeya aalume na aakha, enkamiiya na apuuru. ");
INSERT INTO eko_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Suhura muukha wa mbwanaaka Eburahiima, anvokola mwaana ooluvaliye. Mwaana aya otu amwinkha vitthu zooshi ariinaazo. ");
INSERT INTO eko_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Mbwanaaka khukilaphisa araka: ‘Nti opu kiniikhalaaye ohimweekesemo muukha wa aana a Akanaani. ");
INSERT INTO eko_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ila olawe wa apapazaku vakatthi wa ajamaazaku wamweekese ottuukho muukha yoori ate araliwe ti mwanaka.’ ");
INSERT INTO eko_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Aphano miiyo khunjipu mbwanaaka: ‘Khi muukha aya oto amana ahitakhi ota na-miyo?’ ");
INSERT INTO eko_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ye khukijipu yoori: ‘Nnyizinku otu kininrumeelaaye ontta operekha nlayikha luulokoze, na ontta oparikhiya safwari yawo yoolawa omweekesa muukha wa wiiya jamaayaku na wa vaje wa apapazaku yoori ate araliwe ti mwanaka. ");
INSERT INTO eko_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Amana ofiya wa ajamaazaku yo khuhitakhi owinkha, eti koolaphisiyeeyo entta owiishela.’ ");
INSERT INTO eko_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Phi kiriyeevo n'oofiya onlipu leelo, khusala kimuuza Nnyizinku kiraka: ‘Oo Nnyizinku! Nluku wa mbwanaaka Eburahiima, nkhama safwari eti kineettaaye otakha wawo, okijaaliwe. ");
INSERT INTO eko_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Nasaapi eti miiyo kiri apha nshini wa nlipu opu wa maati; mwaari othuuto antelaaye ottekha maati amana kinvekela yoori: “Kimeele maati ariiye n'yuku mwawo,” ");
INSERT INTO eko_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ye khukuuza yoori: “Apa onywe, na kinttela ottekha makina kinkhe nyama zawo,” eeye othuuto muukha aya athawuliweeyo ti Nnyizinku yoori araliwe ti mwaana wa mbwanaaka.’ ");
INSERT INTO eko_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ahineeshevo mattakhuzi apale oolompa varoho vaka, kinimoona Rapekha athuuliye yuuku valifuzi vawe eettaka vanlipu ottekha maati, miiyo khumuuza yoori: ‘Safwatali kimeele maati kinywe.’ ");
INSERT INTO eko_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ye khwiishusha yuuku yawe nasaapiru khukuuza yoori: ‘Apa onywe, na kintta winkha enkamiiya zawo zinywe.’ Khukinkha miiyo khunywa na khwiinkha enkamiiya zaka khunywa. ");
INSERT INTO eko_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Aphano miiyo khumuuzela yoori: ‘O mwaana waani?’ Ye khujipu yoori: ‘Miiyo ki mwaana wa Betuweeli mwaana wa Nahoori na Miilika.’ Ethiito miiyo khunwalisa kharawu vaphula vawe khunwalisa kakhana makhono awe. ");
INSERT INTO eko_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Miiyo khukokhora, khwiinama khumwaaputu Nnyizinku, khunshukhurwela Nnyizinku, Nluku wa mbwanaaka Eburahiima akeettettisiyeeyo tarikhi yooshapweya yoori kimweettele mwaana wa ttwiiye mbwanaaka ate araliwe ti mwanawe. ");
INSERT INTO eko_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Aphano, nkhama mwatakha onthoonyeza pheta ya waamineya mbwanaaka Eburahiima, mwikuuze. Nkhama khamweepu, mwikuuze kijuwe etthu yooretta.” ");
INSERT INTO eko_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Labani na Betuwele khujipu araka: “Epo zalankha wa Nnyizinku, fweeyo khanina etthu yoowaza. ");
INSERT INTO eko_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rapekha aya otu ari apha, onthuule alawe eeye muukha wa mwaana wa mbwanaawo, etthiipo Nnyizinku alupiyeezo.” ");
INSERT INTO eko_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","N'oosiila mattakhuzi apale karumeya wa Eburahiima khukokhora khwiinama khufiyisa ajihi vathi omaasho wa Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Elottelanaka khusarula vitthu za feeta na za thahapu na kuwo khumwinkha Rapekha, khulaza vitthu kiina theenya za mali khumwinkha nlupuwe na mamaawe. ");
INSERT INTO eko_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Nawiisha, yo khuja na khunywela khulala mpakha supu. N'oocha karumeya otule khulupa yoori: “Mwikilikhe kirutele wa mbwanaaka.” ");
INSERT INTO eko_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ila nlupuwe Rapekha na mamaawe khumuuza yoori: “Mwaari otu eekhale attaapha na-fweyo nenkawu siikhu khumi, nawiisha osala olawa saana.” ");
INSERT INTO eko_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ye khuri: “Mwihikirupazise maana Nnyizinku ashapweyisa safwari yaka. Mwikilikhe kirutele wa mbwanaaka.” ");
INSERT INTO eko_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Aphano yo khunjipu: “Nintta onkhuwela mwaari oto nimuuzele mwennyewe.” ");
INSERT INTO eko_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Khukhuweliwa Rapekha khuuzeliwa: “Ontakha olawa na mwinyi otu?” Ye khujipu yoori: “Kakhupali.” ");
INSERT INTO eko_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ajamaaze khuleezanana Rapekha na yaaya awe na karumeya wa Eburahiima na atthu apale aataniyeeyo. ");
INSERT INTO eko_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Khuparikhiyiwa Rapekha na mattakhuzi apa: “Weeyo nlupweetthu wiiye maama wa peewu alufu alufu zene; Peewu yawo eto eshintte sitati ya maatuwi aya.” ");
INSERT INTO eko_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rapekha khulankha na akarumeyaawe a aakha khuwela enkamiiya zaya khusala alawa na nlume otule. Attaaphale karumeya khunthuula Rapekha khusala alawa. ");
INSERT INTO eko_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Esiyaakha aarettiye arutaka onlipu oniitthiwaaye Layi-Rooyi, aari wiikhala Nikeepu, phantte ya kusini ya Kanaani. ");
INSERT INTO eko_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Siikhu moote, njuwa-looveva wakathi Esiyaakha aari othepelaavo mmashapa, khulansa maasho khoona enkamiiya zeettaka ota. ");
INSERT INTO eko_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rapekha khulansa maasho khumoona Esiyaakha, ye khwiishukha vankamiiya vawe. ");
INSERT INTO eko_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Khumuuzela karumeya: “Khi mwinyi otule anlankhaaye mmashapa mphule ataka okhuno niriiwo ti paani?” Ye khujipu araka: “Ti mbwanaaka.” N'oosiila toole ye khuthuula nshukwi lawe khujifinikha. ");
INSERT INTO eko_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Karumeya khumuuza Esiyaakha zooshi epile ziviriyeezo. ");
INSERT INTO eko_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Esiyaakha khunthuula Rapekha khunttha nheema etile yaari ya mamaawe Suhura. Khunrala khwiiya muukhaawe wompheta. Aphano Esiyaakha khumpattha ntthu wonkhiza paata yoofwa mamaawe. ");
INSERT INTO eko_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Eburahiima khunrala muukha nkina aari wiitthiwaaye Khetuura. ");
INSERT INTO eko_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ye khunvokolela aana apa: Zimraani, Yokishaani, Medaani, Midiyaani, Ishibaaki na Shuuwa. ");
INSERT INTO eko_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokshaani khunvokola Sheeba na Dedaani, aana a Dedaani aari Waashuuru, Waletushi na Walewumi. ");
INSERT INTO eko_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Aana a Midiyaani aari Eefa, Eferi, Hanooki, Abiida na Eelida. Ooshi apa aari aana na atuulu a Khetuura. ");
INSERT INTO eko_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Eburahiima khumwinkha Esiyaakha vitthu zooshi aariinaazo. ");
INSERT INTO eko_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ila aanaawe apale aawaavokoleliyeeyo na aakha akina, ari haayi nalelo, khuwenkha vitthu zaya na-yo, khuweekarela phantte ya malawa-juwa yoori ahiikhale vamote na mwanawe Esiyaakha. ");
INSERT INTO eko_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Eburahiima eekhaliye nyaakha miiya na saapiini na mithaanu. ");
INSERT INTO eko_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ye afwa ari wa wuuluvala arina nyaakha za waatta, khulawa khuzikhiwa vamote na ajamaaze apa afwiiyeeyo. ");
INSERT INTO eko_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Esiyaakha na Esumayila, khunthuula khulawa khunzikha nlikurakuza la Makhipeela kharipu na Manre, nshapa la Eforoni mwaana wa Zohaari nhiiti. ");
INSERT INTO eko_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Nshapa nttintthile oozanyeziweeyo Eburahiima pi Ahiiti, pi ottuukho azikhiweewo ye na muukhaawe Suhura. ");
INSERT INTO eko_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Paata ya Eburahiima ofwa, Esiyaakha aari wiikhala nti wa Peeri-Lahayi-Rooyi, Nnyizinku khusala amparikhiya. ");
INSERT INTO eko_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Eti hatiithi ya peewu ya Esumayila mwaana wa Eburahiima, aavokoliweeyo ti Hajira wa Misuri karumeya wa Suhura. ");
INSERT INTO eko_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Apa mazina a aana aavokoliweeyo ti Esumayila: Nebayoothi, mwaana wa mwanzo wa Esumayila, Kedaari, Adibeeli, Mibisaamu. ");
INSERT INTO eko_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Miishima, Duuma na Maasa. ");
INSERT INTO eko_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadaadi, Teema, Yetuuri, Nafiishi na Kedeema. ");
INSERT INTO eko_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Apa aana Esumayila khumi na awiri, pi atthaapo aari afwalume, wakhula mwaana na lihimo lawe na nhali aari omakaamo. ");
INSERT INTO eko_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Esumayila eekhaliye nyaakha miiya na talaathiini na sapa. Khufwa khulawa khuzikhiwa vamote na ajamaaze apa afwiiyeeyo. ");
INSERT INTO eko_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Peewu yawe yeekhaliye waaza Hawila mpakha Shuuri kharipu na Misuri tarikhi yaweetta Ashuuru. Yo aari woohisiilani na ojama nkina wa Eburahiima. ");
INSERT INTO eko_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Eti hatiithi ya peewu ya Esiyaakha mwaana wa Eburahiima: Eburahiima khunvokola Esiyaakha. ");
INSERT INTO eko_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Esiyaakha n'oopattha hirimo ya nyaakha arupayiini khunrala Rapekha mwaana wa Betuweeli, nlupuwe Labani. Yo aari Araamu aari wiikhalaaye Paata-Araamu, tuniya ya Mesopotamiya. ");
INSERT INTO eko_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Mwaasa wa muukhaawe ohiina mavokozi, Esiyaakha khulompa wa shariyavo anvekelaka Nnyizinku. Ye khusiila lompa yawe Rapekha khwiimittha. ");
INSERT INTO eko_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Aana awiri khusala oomana mwiirukulu mwawe. Ye khushanka khusala ajuuzela yoori: “Niini enrettikhanaaye mwiirukulu mwaka, nkhama pi toono keemitthela-ni?” Aphano ye khumuuzela Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Nnyizinku khunjipu: “Mahimo mawiri pi ariiye mwiirukulu mwawo. Weeyo onttela ovokola khapila piiri zoohisiilani: moote enttela wiiya ya kuvu zayita eti kiina. Nttunkhulu onteela onrumeyela nsimaana.” ");
INSERT INTO eko_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Zifiiyeevo siikhu zoopattha ekumi, khuwaavokola aana a maphapo. ");
INSERT INTO eko_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Otu woovokoliwa mwanzo aari wookhuttuwa na wa waatta ovuzi, ti maana yootthajiwa nzina la Ezawu. ");
INSERT INTO eko_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Elottelanaka khuvokoliwa ttwiiye, nkhono awe okholeliye ekwakuno ya Ezawu. Ti maana yootthajiwa nzina la Yaakhumpa. Ampattikhanaru aana aya apa, Esiyaakha aarettiye arina nyaakha siithiini. ");
INSERT INTO eko_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Aana apale khuwula, Ezawu khwiiya namasaya nwulu na aari wontuvela weettetta ntthuttu, ila Yaakhumpa aari ntthu woonyamala wontuvela wiikhala vaje. ");
INSERT INTO eko_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Esiyaakha aari ompheta Ezawu, mwaasa wontuvela orafuna nyama epile aari osayaazo. Ila Rapekha aari ompheta Yaakhumpa. ");
INSERT INTO eko_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Siikhu moote, Yaakhumpa khwiipikha sekuseku, wakathi aya opo Ezawu aarettiye eettaka orutiru ntthuttu ari wookholiwa ti jala na wooshokhera. ");
INSERT INTO eko_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ye khumuuza Yaakhumpa yoori: “Okinkhe vitthu epo oniipikhaazo zookhuttuwela kije. Kintakha ofwa jala!” Ti eto Ezawu enkhiweeyo nzina la Edomu. ");
INSERT INTO eko_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yaakhumpa khumuuza yoori: “Waaze okuuzanyeza lifunku lawo l'oomwaana w'oomwanzo khapula.” ");
INSERT INTO eko_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ye khumuuza yoori: “Lina fwayita-ni lifunku laya nttho la wiiya mwaana wa mwanzo, miiyo kitakhaka ofwa jala!” ");
INSERT INTO eko_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yaakhumpa khusala ankhanyarela yoori: “Olaphe.” Ye khulapha, khumuuzanyeza Yaakhumpa lifunku lawe l'oomwaana wa mwanzo. ");
INSERT INTO eko_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Aphano ye khumwinkha Ezawu phaawu na sekuseku y'eepwiri. Khuja khunywela, khusala alawa safwari zawe. Woohooneli fwayita lifunku l'oomwaana wa mwanzo. ");
INSERT INTO eko_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Yaapuwiye jala nti opule nkhama etthiipile yaapuwiyeezo wakathi wa Eburahiima. Ti eto Esiyaakha khulawa nti wa Geraari okutthanana Apimeleekhi mfwalume wa Afiliishiti. ");
INSERT INTO eko_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Nnyizinku khunteela, khumuuza yoori: “Ohilawe tuniya ya Misuri; weekhale nti kintakhaaye owuuza. ");
INSERT INTO eko_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ottuukho miiyo kinttela wiiya vamote na-weyo na kinttela wuuparikhiya. Weeyo na peewu yawo kinttela owinkhani nti opo wooshi, kilipiselaka wahati opule kaalaphiyeeyo kimwaahitaka papaawo Eburahiima. ");
INSERT INTO eko_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Kinttela waattisa peewu yawo nkhama matthottowa o'otulu, na kinttela winkha tuniya yooshi eti. Mwaasa wa peewu yawo, khapila zooshi za tuniya zinttela wiiya zooparikhiyiwa; ");
INSERT INTO eko_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","maana Eburahiima asiileza huula yaka, ashututela oruma waka, mwentto aka, kano zaka na masomi aka.” ");
INSERT INTO eko_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Aphano Esiyaakha khusala eekhala nti wa Geraari. ");
INSERT INTO eko_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Atthu a nti opule n'oomuuzela monkoni wa muukhaawe, ye khuri: “Nlupwaaka.” Mwaasa yoori Rapekha aari wooshapweya, Esiyaakha eetta woova olupa yoori muukhaawe. Ye aari wuupuwela yoori alume a mmuti mphule eetta omuula asale na Rapekha. ");
INSERT INTO eko_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Esiyaakha eekhaliye Geraari siikhu za waatta. Siikhu moote, Apimeleekhi mfwalume wa Afiliishiti eetta othurumela veettakha khumoona Esiyaakha ampapasaka muukhaawe. ");
INSERT INTO eko_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Aphano Apimeleekhi khunkhuwela Esiyaakha khumuuza yoori: “Otu, khweele muukhaawo! Khi apho waari oraaye nlupuwo?” Ye khujipu yoori: “Kaari woova wuuliwa mwaasa wa ye.” ");
INSERT INTO eko_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Apimeleekhi khuri: “Epo zaya niini oniretteliyeeyo? Khi eriwaka ntthu mmote wa fweyo eettiye olalana, weeyo waari onittha paathuli?” ");
INSERT INTO eko_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Apimeleekhi khuwooza atthu ooshi yoori: “Wakhula otule antakhaaye onsapa mwinyi otu ama muukhaawe ontta ofwa.” ");
INSERT INTO eko_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Esiyaakha khulima nshapa lawe nti otthuupule, mwaasa wa Nnyizinku omparikhiya mwaakha otthuupo khuurula vitthu swaafu miiya zooziti epile aazaliyeezo. ");
INSERT INTO eko_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ye khureela, khusala evira zeekezeleyaka mali zawe, khwiiya thaajiri nwuulweene. ");
INSERT INTO eko_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Aarina maphanko a pwittipwitthi, puuzi, a mompe na aarina akarumeya a waatta, ti nanna Afiliishiti laawaatiyeeyo nrima. ");
INSERT INTO eko_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Milipu zooshi epile aathipiyeeyo akarumeya a Eburahiima paapa wa Esiyaakha ari haayi, khusirelaza. ");
INSERT INTO eko_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Siikhu moote Apimeleekhi khumuuza Esiyaakha yoori: “Oleemo mmuti mphu, maana wareela na kuvu waniziti fweeyo.” ");
INSERT INTO eko_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Aphano ye khuthama nti opule, khulawa khumaka nttapo la Geraari khwiikhala ottuukho. ");
INSERT INTO eko_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Khuthipa opheya milipu epile zaathipiweeyo wakathi wa Eburahiima, khusireliwa pi Afiliishiti paata yoofwa Eburahiima, Esiyaakha khwinkha mazina milipu epile atthaapale papaawe aatthajiyeeyo. ");
INSERT INTO eko_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Siikhu kiina, akarumeyaawe khuthipa mmattapo nttumphule, khunsikana naattuuttu wa maati. ");
INSERT INTO eko_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Amakhampuzi a Geraari khusala anyakulisana na amakhampuzi a Esiyaakha araka: “Maati apa pi eetthu,” ti eto Esiyaakha aatthajiyeeyo nzina la Eseki nlipu aya opule, mwaasa yoori weetta wuumaneliwa. ");
INSERT INTO eko_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Akarumeyaawe khuthipa nlipu nkina, ila amakhampuzi apale a Geraari khupuwisa wuumani theenya, ye khutthaja nzina la Sitiina (milattu). ");
INSERT INTO eko_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Aphano khulaavo aphale vaya khulawa khuthipa nlipu nkina, khuhiivo hatha ntthu mmote wa wuumanelana. Ye khutthaja nzina la Rehopoothi araka: “Aphano Nnyizinku aninkha puuro ya nafwaasi, na ninteela oruwera saaneene nti otthuupu.” ");
INSERT INTO eko_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Attaaphale Esiyaakha khulawa Beerisheba. ");
INSERT INTO eko_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Osikhu Nnyizinku khunteela khumuuza yoori: “Miiyo ki Nluku wa papaawo Eburahiima. Ohoove, kiri vamote na-weyo. Kintta wuuparikhiya kaattise peewu yawo mwaasa wa papaawo karumeyaaka.” ");
INSERT INTO eko_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Attaaphale ye khunjeka alitaari, khwaaputu nzina la Nnyizinku. Khweemesa heema yawe na akarumeyaawe khuthipavo nlipu. ");
INSERT INTO eko_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Apimeleekhi aalankhiye nti wa Geraari na shawuriiya awe Ahuzaathi na Fikhoole namalokozela wa anajanka olawa okutthanana Esiyaakha. ");
INSERT INTO eko_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Esiyaakha n'oowoona khuwooza yoori: “Mweeyo khamwintuveliwa ti miyo mweettiye okiikara mmuti mwenu. Khi mwatela-ni?” ");
INSERT INTO eko_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Yo khunjipu araka: “Neetta woona yoori Nnyizinku ori vamote na-weyo. Khuupuwela yoori enshapweya olapha na winkhana wahati weeyo na-fweyo. ");
INSERT INTO eko_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Osiilana waya pi opu: Olaphe yoori khunnirettela zootakhala nkhama etthiipo na-fweyo nihuuretteleeni, noorettela zooshapweya na khuulikha olawa na heeri. Weeyo o wooparikhiyiwa ti Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Esiyaakha khuwenkha etthu-yooja yooshapweya khuja khunywela. ");
INSERT INTO eko_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Mmeesho mwaya supuyeene khulaphisana. Esiyaakha khuwaaleeza, yo khusala alawa na heeri. ");
INSERT INTO eko_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Siikhu ethiitile khuta akarumeya a Esiyaakha oteela omuuza hapari za nlipu opule aathipiyeeyo yoori: “Napattha maati.” ");
INSERT INTO eko_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Nlipu aya opule Esiyaakha khutthaja nzina la Sheba. Mpakha leelo sitati yaya etile eniittheliwa Beeresheba. ");
INSERT INTO eko_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Wakathi Ezawu apatthiyeevo nyaakha arupayiini khunrala Yudiithi mwaana wa nhiiti aniitthiwaaye Beeri, na Basemaathi mwaana wa nhiiti nkinoko aniitthiwaaye Elooni. ");
INSERT INTO eko_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Aakha apo awiri, anshukulikhisiye Esiyaakha na Rapekha. ");
INSERT INTO eko_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Esiyaakha ooluvaliye, maasho awe aashokheriye khuhisala oona. Khunkhuwela Ezawu mwanawe otu nwulu araka “Mwanaka!” Ye khujipu: “Lape!” ");
INSERT INTO eko_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Khumuuza yoori: “Miiyo kooluvala siikhu kimfwaavo khijuweyeeni. ");
INSERT INTO eko_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Othuule nttetthe lawo olawe ntthuttu wasaye nyama. ");
INSERT INTO eko_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Wiipikhe saana wookituvelavo okitiisele kije, kuuparikhiye kihinafwe.” ");
INSERT INTO eko_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ezawu khulankha khulawa ntthuttu osaya nyama yoori antiisele papaawe. Rapekha aari onsiila Esiyaakha attakhulanaka mwanawe Ezawu, ");
INSERT INTO eko_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ye khumuuza mwanawe Yaakhumpa araka: “Weyo! Kansiila papaawo amuuzaka ttwiiyo Ezawu yoori: ");
INSERT INTO eko_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Okitiisele nyama ya wiipikhiwa wookituvelavo kije, kuuparikheye mmakhono wa Nnyizinku kihinafwe.’ ");
INSERT INTO eko_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Mwanaka, osiileze mattakhuzi apa kinuurumaaye, nasaapi eti ");
INSERT INTO eko_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","olawe oliphanko la nyama wa waathuule aana a puuzi awiri ooneneva, kite kiweepikhe saaneene anttelaaye ontuvela papaawo. ");
INSERT INTO eko_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Onlawanele aje, ooparikhiye ahinafwe.” ");
INSERT INTO eko_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yaakhumpa khunjipu mamaawe Rapekha yoori: “Ezawu ti wa waattana ovuzi, miiyo akina. ");
INSERT INTO eko_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Paapa amana akipapasela ahikisikanani ovuzi kinttela wiiya ntthu woohata, toowo khankiparikhiya ontta okilaani.” ");
INSERT INTO eko_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mamaawe khumuuza yoori: “Laana yaya eto ti ekikwele miiyo mwanaka. Ila orette eti kiwuuziyeeyo: weettele puuzi epile kuurumiyeezo.” ");
INSERT INTO eko_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ye khulawa khuthuula puuzi khuntiisela mamaawe, khwiipikha wootuvavo waari weettelaaye ontuvela papaawe. ");
INSERT INTO eko_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Aphano Rapekha khuthuula kuwo epile zooshapweya za Ezawu mwanawe otule nwulu zaari owawe, khunwalisa Yaakhumpa mwaana otu nttiitthi aya. ");
INSERT INTO eko_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Khumfinikha na shapala ya puuzi makhono awe na phantte ya mmwisiko mwawe wahaariimo ovuzi. ");
INSERT INTO eko_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Khuthuula etthu-yooja yootuva etile eepikhiyeeyo na phaawu khumwinkha mwanawe Yaakhumpa. ");
INSERT INTO eko_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ye khulawana aphale aariivo papaawe khunkhuwela: “Paapa!” Ye khujipu: “Lape! Weeyo o mwanaka-ni?” ");
INSERT INTO eko_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yaakhumpa khunjipu papaawe: “Miiyo ki Ezawu mwanenu wa mwanzo. Katiisa eti mwaakirumiyeeyo. Mwilankhe mwije nyama eti kitiisiyeeyo, nawiisha mwikiparikhiye.” ");
INSERT INTO eko_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Esiyaakha khumuuzela mwanawe yoori: “Wapattha toovi nasaapiru mwanaka?” Ye khujipu: “Nnyizinku Nluku eenu eetta okiperekheza.” ");
INSERT INTO eko_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Khumuuza yoori: “Nkakisusele apha kuupapasele, kuujuwe nkhama khweele o mwanaka Ezawu.” ");
INSERT INTO eko_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yaakhumpa khunsusela papaawe. Esiyaakha khusala ampapasela, khumuuza yoori: “Huula ti ya Yaakhumpa, ila makhono pa Ezawu.” ");
INSERT INTO eko_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ye khuhinjuwi mwaasa wa makhono awe wiiyana ovuzi nkhama apa a ttwiiye Ezawu. ");
INSERT INTO eko_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ahinamparikhiye khumuuzela theenya: “Mwanaka Ezawu ti weyeena?” Ye khujipu: “Aa, ti miyo.” ");
INSERT INTO eko_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Aphano khuri: “Okitiisele apha nyama yaya eto osayiyeeyo kije, yoori kuuparikhiye.” Yaakhumpa khumweettisela khuja na khumwinkha viinyu khunywela. ");
INSERT INTO eko_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Esiyaakha khumuuza yoori: “Okaattame mwanaka okipatikhe.” ");
INSERT INTO eko_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yaakhumpa khumwaattama papaawe khumpatikha. Esiyaakha khusiila muuru wa kuwo zawe, aphano ye khumparikhiya araka: “Muuru wa mwanaka muuru wa nshapa looparikhiyiwa ti Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Nnyizinku awinkhe mmatte wa pinkuuni na oruwera wa vathi, peewu ya waatta na viinyu ya waatta. ");
INSERT INTO eko_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Khapila za waatta zuurumeele weeyo, na mahimo a waatta ookokhorele. Wiiye mbwana wa attwiizo, na aana a mamaawo ookokhorele weeyo. Oolaanikha pi apale anttelaaye wuulaani, na ooparikhiyiwa pi apale anttelaaye wuuparikhiya.” ");
INSERT INTO eko_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Paata Yaakhumpa oparikhiyiwa ti Esiyaakha papaawe, ye alaakavo aphale, nasaapiru ttwiiye Ezawu khufiya alankhaka wuusaya. ");
INSERT INTO eko_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Na-ye khwiipikha etthu-yooja yootuva khuntiisela papaawe, khumuuza yoori: “Mwilankhe paapa mwije nyama eti keetteliyeeyo osaya mwikiparikhiye.” ");
INSERT INTO eko_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Papaawe khumuuzela: “Weeyo o paani?” Ye khuri: “Ti miyo Ezawu, mwanenu otu wa mwanzo.” ");
INSERT INTO eko_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Esiyaakha khusuthuwa channu khusala athukumela khulupa yoori: “Khi otule apatthiyeeyo nyama khukitiisela ti paani? Miiyo kaja keesha weeyo ohinate. Kamparikhiya, ti wooparikhiyiwa!” ");
INSERT INTO eko_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ezawu n'oosiila mattakhuzi apale a papaawe khwiiphiiriwa khulila venkivene, khunvekela papaawe yoori: “Na-miyo paapa mwikiparikhiye!” ");
INSERT INTO eko_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ye khulupa yoori: “Aatiiyevo ttwiiyo apha khukittettekha, khuthuula parakha yawo.” ");
INSERT INTO eko_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ezawu khulupa yoori: “Eto swaafu yaphiiri akishinttaka. Ti maana ootthajiwa nzina la Yaakhumpa. Yamwanzo akinyakanya lifunku laka l'oomwaana wa mwanzo. Apho theenya akinyakanya parakha yaka. Paapa khamwinkiparikhiya na miiyo?” ");
INSERT INTO eko_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Esiyaakha khujipu: “Miiyo kanthawaza Yaakhumpa yoori eeye mbwanaawo weeyo na ajamaazo ooshi anttela onrumeela ye. Onteela wiiyana tiriku ya waatta na viinyu. Kuurettele niini miiyo mwanaka?” ");
INSERT INTO eko_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ezawu khumuuzela papaawe: “Mweeyo paapa khamwisalaneeni hatha parakha? Na miiyo mwikiparikhiye!” Khusala alila anyakulaka. ");
INSERT INTO eko_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Aphano Esiyaakha khunjipu: “Weeyo onttela wiikhala ohali woolepelana na miti zooruweriwa, ohali woothowawo mmatte wa pinkuuni. ");
INSERT INTO eko_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Yoori weeyo opatthe meekhazi onttela wuumanana phanka yawo na onttela onrumeela ttwiiyo. Amana ojilipisa ontta olaamo nthwaapu mwaya mphu.” ");
INSERT INTO eko_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ezawu khwiiya wa wiiphiiriwa ti ttwiiye mwaasa wa parakha etile enkhiweeyo ti papaawe. Khusala oopuwela toono: “Siikhu za matthaka a paapa ziri kharipu. Amana afwa miiyo kintta omuula ttwiiyaku Yaakhumpa.” ");
INSERT INTO eko_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Wakathi asiiliyeevo Rapekha mattakhuzi apale aari ottakhulaaye mwanawe otu wa mwanzo Ezawu, ye khunkhuwela mwanawe Yaakhumpa otu nttiitthi aya khumuuza yoori: “shawuri ariinaazo Ezawu pi zootakha owuula. ");
INSERT INTO eko_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Apho weeyo mwanaka osiile eti kiniwuuzaaye. Otthire nasaapi ethiiti, weette wa nlupwaaka Labani aniikhalaaye nti wa Harani. ");
INSERT INTO eko_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Weekhale ottuukho mpakha ttwiiyo omwiishe okatipukha wawe. ");
INSERT INTO eko_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Amana omwiishela okatipukha wawe na asahawu eti onretteliyeeyo miiyo kintta wuuperekheza nhupi yoori ote. Akintakha okipwetheya aanaaka oowiiri siikhu moote!” ");
INSERT INTO eko_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Aphano Rapekha khulawa omuuza Esiyaakha yoori: “Akituveliweeni ohaayi aka wooshi mwaasa wa aakha a Ahiiti apa awaaraliyeeyo Ezawu. Amana Yaakhumpa na-ye awaarala aakha a tuniya ethiiti miiyo kinhithari ofwa.” ");
INSERT INTO eko_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Esiyaakha khunkhuwela Yaakhumpa khumparikhiya, khumuuza yoori: “Ohinrale hatha muukha mmote wa Kanaani. ");
INSERT INTO eko_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Olankhe olawe nti wa Paata-Araamu owawe Betuweeli pwapwiyo. Olawe wanrale mwaana wa Labani nlupu wa mamaawo. ");
INSERT INTO eko_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Nluku Woowahi Zooshi ooparikhiye, awinkhe mavokozi na peewu ya waatta, yoori khwa weyo epuwe khapila za waatta. ");
INSERT INTO eko_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Awinkhe weeyo na peewu yawo parakha etile aahitiweeyo Eburahiima, wiiye mwennyewe nti opu oniikhalaaye nkhama nletto enkhiweeyo Eburahiima ti Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Paata ya toole, Esiyaakha khumuuza Yaakhumpa yoori aphano etta. Ye khulawa Paata-Araamu owawe Labani mwaana wa Betuweeli Mwaaramu, nlupuwe Rapekha maama wa Yaakhumpa na Ezawu. ");
INSERT INTO eko_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ezawu aajuwiye yoori Esiyaakha amparikhiyiye Yaakhumpa, khumuuza yoori alawe nti wa Paata-Araamu, amweekese muukha w'oottuukho anrale. Na khusiila yoori papaawe amuuza Yaakhumpa yoori ahinrale muukha wa Kanaani. ");
INSERT INTO eko_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Khujuwa theenya yoori Yaakhumpa anshututela papaawe na mamaawe alawa Paata-Araamu. ");
INSERT INTO eko_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ti nanna ye ajuwiyeezo yoori papaawe khaari ontuvela aakha a Kanaani. ");
INSERT INTO eko_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Aphano Ezawu khulankha khulawa owawe Esumayila mwaana wa Eburahiima, khunrala Mahalaathi mwaana wa Esumayila, nlupu wa Nebayoothi, oohiiyi aakha apale akina aarinaaye. ");
INSERT INTO eko_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yaakhumpa khulankha Beeresheba khusala alawa Harani. ");
INSERT INTO eko_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Eettaka olawa etthiipile, n'ootupweela njuwa ye khufiya puuro yaya eto yoori alale attaapho. Khuthuula liwe laari attaaphale khuretta nsaawu khurapalela. ");
INSERT INTO eko_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Khulottha khoona yeemesiwe shikatta vathi, janka yaya yaari okomaaye pinku. Malayikha a Nnyizinku aari owela ethiito na wiishukha. ");
INSERT INTO eko_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Nnyizinku ari kharipu na-ye khumuuza araka: “Miiyo ki Nnyizinku, Nluku wa papaawo Eburahiima na wa Esiyaakha. Nti opo orapaleliyeeyo kinteela owinkha weeyo na peewu yawo yooshi. ");
INSERT INTO eko_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Peewu yawo enteela wiiya ya waatta nkhama mishaka za voolumwenku, enteela omwazeyela malawa-juwa, makaaripi, kashikhazini na kusini. Khwa weyo na peewu yawo khapila zooshi za voolumwenku enteela oparikhiyiwa. ");
INSERT INTO eko_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Woone! Miiyo kiri vamote na-weyo, kinteela owiinanela wakhula vahali oneettaavo, na kinteela wuurutisela tuniya ethiiti, akiniwanswi khihiretteeni epile zooshi kiwaahitiyeezo.” ");
INSERT INTO eko_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yaakhumpa asisimuwiyeevo aphale aari olalaavo khuri: “Khweele, Nnyizinku ori puuro ethiiti, miiyo akaajuwiye.” ");
INSERT INTO eko_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ye khwiiya wa woova channu, khulupa yoori: “Puuro eti ti yawoopisa! Nyuupa ya Nluku, na nlako wa pinkuuni.” ");
INSERT INTO eko_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Mmeesho mwaya supuyeene, Yaakhumpa khuthuula liwe ntthile aaphiteeziyeeyo, khweemesa khwiitthela mafuttha vatulu vaya. ");
INSERT INTO eko_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Khutthaja nzina puuro yaya etile, la “Beetele”, ila raku sitati yaya etile yaari wiitthiwa “Luuzhu”. ");
INSERT INTO eko_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yaakhumpa khwaahiti yoori: “Amana Nluku eeya vamote na-miyo, eenanela safwari yaka eti, khukinkha etthu-yooja na kuwo zoowala, ");
INSERT INTO eko_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","khukirutisela vaje wa paapa kiri nkumi, Nnyizinku onteela wiiya Nluku aka. ");
INSERT INTO eko_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Liwe ntthi keemesiyeeyo apha nkhama nripu linttela wiiya nyuupa ya Nluku, na wakhula etile onikinkhaaye kiwinkhaka lifunku la khuumi.” ");
INSERT INTO eko_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yaakhumpa khurutela safwari yawe khulawa mpakha nti oriiye phantte lintthamuwaawo njuwa. ");
INSERT INTO eko_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Siikhu moote, khweekesa nkerekhere wa nttapo khoona nlipu mmote ozukuleliwe ti maphanko mattatthu a pwittipwitthi zirapaleliye. Waari nlipu zaari onywisiwaavo maati, liwe laari ofinikhaniwakaaye nlipu opule laari liwululene. ");
INSERT INTO eko_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ti eto amakhampuzi aari owejelanakaaye yoori asusise liwe ntthile enkhe nyama zaya maati oonywa, nawiisha khurutiselavo liwe ntthile. ");
INSERT INTO eko_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yaakhumpa khuwoozela amakhampuzi apale araka: “Mweeyo attwiizaku, mwaavayi?” Yo khujipu araka: “Fweeyo nti etthu Harani.” ");
INSERT INTO eko_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ye khuri: “Mwininjuwa Labani ntuulu wa Nahoori?” Yo khujipu araka: “Aa, nininjuwa!” ");
INSERT INTO eko_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Khuwoozela theenya yoori: “Nkumi?” Yo khujipu yoori: “Aa, nkumi! Mwanawe Rakeele ti oto antaaye apho na pwittipwitthi za papaawe.” ");
INSERT INTO eko_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yaakhumpa khulupa yoori: “Nalelo khunaripe, khunafiye wakathi wookusanya maphanko. Mwinkhe maati pwittipwitthi epo mwilawe mwajise opheya.” ");
INSERT INTO eko_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ila yo khujipu araka: “Khaninwahi, nina yoowejela pwittipwitthi zooshi zikusanyeye attaapha nisusise liwe ntthi lifinikhaniweeyo nlipu, ninkhe pwittipwitthi zetthu maati zinywe.” ");
INSERT INTO eko_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Eettaka ottakhula etthiipile khusala ata Rakeele na pwittipwitthi za papaawe, mwaasa yoori aari nshuki. ");
INSERT INTO eko_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yaakhumpa n'oomoona Rakeele mwaana wa halwiye Labani eettaka ota na pwittipwitthi, khulawa khufunula nlipu khwinkha maati pwittipwitthi za halwiye. ");
INSERT INTO eko_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Nawiisha khumwinkha peezhu khusala alila. ");
INSERT INTO eko_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Aphano Yaakhumpa khumuuza Rakeele yoori: “Miiyo ki jaama wa papaawo, ki mwaana wa Rapekha.” Ye khutthira alawaka omuuza papaawe. ");
INSERT INTO eko_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labani n'oosiila hapari za Yaakhumpa mwaana wa nlupuwe, khusala atthira alawaka okutthanana. N'onsikana khumpatikha khumpejari, khunthuula khusala alawana owawe. Ye khumuuza Labani zooshi epile zanvireliyeezo. ");
INSERT INTO eko_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Aphano Labani khulupa yoori: “Weeyo khweele ojamaayaku, taamu yetthu moote.” Yaakhumpa khwiikhala mpakha wiisha mweezi ari ottuukho. ");
INSERT INTO eko_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Elottelanaka Labani khuri: “Hatha nkhama ojamaayaku, onakhola khaazi mahala? Kuuze phakari yawo.” ");
INSERT INTO eko_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labani aarina aanaawe awiri aakha; otu nwulu aari wiitthiwa Liiya. Nttiitthi aya aari wiitthiwa Rakeele. ");
INSERT INTO eko_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Liiya aari woosizila maasho, ila Rakeele aari wooshapweya mwiili awe na omaasho wawe. ");
INSERT INTO eko_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yaakhumpa mwaasa wootuveliwa ti Rakeele, khulupa yoori: “Kintta okhola khaazi nyaakha sapa okilooze mwanawo otu nttiitthi aya.” ");
INSERT INTO eko_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labani khujipu yoori: “Kemaani! Ti yooshapweya wuulooza weeyo zayita onlooza ntthu nkinoko. Osala wiikhala attaapha na-miyo.” ");
INSERT INTO eko_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yaakhumpa khukhola khaazi nyaakha sapa yoori anrale Rakeele. Nyaakha epile sapa ye khoona nkhama siikhu vattitthiiru mwaasa wootuveliwa channu. ");
INSERT INTO eko_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ye khumuuza Labani yoori: “Aphano kiloozeni muukhaaka, maana zafiyela siikhu naasiilaniyeezo.” ");
INSERT INTO eko_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Labani khuwaakhuwela atthu a waatta a mmuti mphule khuretta njampo. ");
INSERT INTO eko_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ila n'ooripa khunthuula mwanawe Liiya khumwinkha Yaakhumpa khurapalelana. ");
INSERT INTO eko_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labani khumwinkha karumeyaawe Ziilipa mwanawe Liiya yoori asala anrumeela. ");
INSERT INTO eko_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ochiiyeevo, Yaakhumpa khumoona yoori ti Liiya. Ye khulankha olawa omuuzela Labani yoori: “Niini epi okiretteliyeezo? Miiyo akaari okhola khaazi mwaasa wa Rakeele? Khi kiiswa yaya niini okittettekhaka?” ");
INSERT INTO eko_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labani khunjipu yoori: “Fweeyo mmuti mwetthu mphu khanizowereeni onlooza otu nttiitthi nttunkhulu ahinaraliwe. ");
INSERT INTO eko_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Amana zivira siikhu sapa za njampo ntthi, nintta wuulooza otu nkina, paata onaahitaavo okikholela khaazi theenya nyaakha sapa.” ");
INSERT INTO eko_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ye khukhupali, khuvira siikhu epile sapa za njampo la harusi ya Liiya, Labani khunthuula Rakeele khunlooza. ");
INSERT INTO eko_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Khunthuula karumeyaawe Biila khumwinkha mwanawe Rakeele yoori asala anrumeela. ");
INSERT INTO eko_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yaakhumpa khurapalelana Rakeele khwiiya wontuvela zayita Liiya. Khurutela theenya onkholela khaazi Labani mpakha nyaakha sapa. ");
INSERT INTO eko_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Nnyizinku nawoona yoori Yaakhumpa khaari otuveliwa ti Liiya, khumwinkha mavokozi. Ila Rakeele khaari ovokola. ");
INSERT INTO eko_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Liiya khwiimittha khumpattha mwaana wanlume, khuntthaja nzina la Ruubeni. Khuri: “Nnyizinku oona ohoowa waka. Aphano phi kinttelaavo ophetiwa ti mannaka.” ");
INSERT INTO eko_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Khwiimittha theenya khumpattha mwaana nkinoko, khuntthaja nzina la Simiyooni. Khulupa yoori: “Nnyizinku asiila ohituveli waka, akinkha mwaana nkina.” ");
INSERT INTO eko_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Khwiimittha theenya swaafu kiina khumpattha mwaana khuntthaja nzina la Leevi, khulupa yoori: “Aphano mannaka onttela wiiya wookusanyeya na-miyo mwaasa wompatthela aana attatthu.” ");
INSERT INTO eko_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Khurutela wiimittha theenya, khumpattha mwaana khulupa yoori: “Swaafu eti kinttela onsifu Nnyizinku.” Ti eto antthajiyeeyo nzina la Yuuda. Aphano khumwiishela mavokozi. ");
INSERT INTO eko_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rakeele ooniyeevo yoori Yaakhumpa khaari ompatthela mwaana, khusala anlilela wiivu ttwiiye. Khumuuza Yaakhumpa yoori: “Okipatthele mwaana, n'oohiiyi etthiipo kintta ofwa!” ");
INSERT INTO eko_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yaakhumpa khumwiiphiira, khumuuza yoori: “Weeyo onikoona nkhama Nluku? Ye ti ahiniwinkhaaye mavokozi.” ");
INSERT INTO eko_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rakeele khumuuza yoori: “Kinaaye karumeyaaka Biila, onthuule othuuto orapalelane yoori ampatthe mwaana zwaamu yaka, kiiye maama khwa ye.” ");
INSERT INTO eko_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Rakeele khunthuula Biila khumwinkha Yaakhumpa khwiiya muukhaawe. ");
INSERT INTO eko_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Khwiimittha khumpattha mwaana. ");
INSERT INTO eko_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rakeele khulupa yoori: “Nnyizinku akirettela wa shariyavo, asiila lompa yaka akinkha mwaana.” Khuntthaja nzina la Daani. ");
INSERT INTO eko_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Biila karumeya wa Rakeele khwiimittha theenya khumpattha mwaana waphiiri. ");
INSERT INTO eko_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rakeele khulupa yoori: “Kaarina viittha khuluyeene na nuunu, ila kanshintta.” Mwaana otule khuntthaja nzina la Nafitaali. ");
INSERT INTO eko_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Liiya nawoona yoori alikha ovokola, khunthuula karumeyaawe Ziilipa khumwinkha Yaakhumpa khwiiya muukhaawe. ");
INSERT INTO eko_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ziilipa karumeya wa Liiya, khupattheliwa mwaana ti Yaakhumpa. ");
INSERT INTO eko_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Liiya khulupa yoori: “Kashapweyiwa mwaani!” Khuntthaja nzina la Gaati. ");
INSERT INTO eko_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ziilipa karumeya wa Liiya khunvokola mwaana nkinoko theenya. ");
INSERT INTO eko_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Liiya khuri: “Kafurahi mwaani! Mpakha aakha akina anteela okuuza yoori kenkhiwa furaha!” Mwaana otule khuntthaja nzina la Asheeri. ");
INSERT INTO eko_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Wakathi wa wuurula tiriku Ruubeni aalankhiye khusala alawa omashapa, khusikana mishumo eniitthiwaaye mathunkuja, khuthuula khulawa khumwinkha Liiya mamaawe. Rakeele khunvekela araka: “Safwatali, kimeeleni mathunkuja vattitthiiru apo atiisiyeeyo mwanenu.” ");
INSERT INTO eko_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ye khujipu araka: “Wanthuula mannaka, khootosheeni? Theenya ontakha othuule mathunkuja apa atiisiyeeyo mwanaka?” Rakeele khunjipu araka: “Kemaani! Nlaweni nipatili, mwikinkhe mathunkuja apo, osikhu opu Yaakhumpa mwilawe mwarapalelane mweeyo.” ");
INSERT INTO eko_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Njuwa-looveva Yaakhumpa arutaka omashapa, Liiya khunthepeeza khusala amuuza yoori: “Leelo onttela orapalelana miiyo, maana keetta wuurentteri na mathunkuja atiisiyeeyo mwanaka.” N'ooripa Yaakhumpa khulala vamote na Liiya. ");
INSERT INTO eko_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Nnyizinku khusiila lompa ya Liiya, khwiimittha khumpattha mwaana wathaanu wa Yaakhumpa. ");
INSERT INTO eko_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Liiya khulupa yoori: “Nnyizinku akitthuva mwaasa wonthuula karumeyaaka khumwinkha mannaka.” Ti eto khuntthaja nzina la Esakhaari. ");
INSERT INTO eko_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Khwiimittha theenya khumpattha mwaana wasiitha. ");
INSERT INTO eko_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ye khuri: “Nnyizinku akinkha etthu ya fwayita, aphano mannaka onteela otuveliwa venkivene ti miyo mwaasa wompatthela aana sitha.” Ti eto mwaana otule khuntthaja nzina la Zabulooni. ");
INSERT INTO eko_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Wiishela waya Liiya khumpattha mwaana nkina wankha khuntthaja nzina la Diina. ");
INSERT INTO eko_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Nnyizinku khumuupuwela Rakeele, khusiila lompa yawe khumwinkha mavokozi. ");
INSERT INTO eko_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ye khwiimittha khumpattha mwaana. Khulupa yoori: “Nnyizinku eeshisa haaya yaka.” ");
INSERT INTO eko_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Khuntthaja nzina la Yuusufu, alupaka yoori: “Nnyizinku ti akinkhe mwaana nkina.” ");
INSERT INTO eko_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Paata ya Rakeele ompattha Yuusufu, Yaakhumpa khumuuza Labani yoori: “Kilikheni kirutele nti kivokoliweeyo. ");
INSERT INTO eko_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Mwikinkhe aakhaaka apa kiwaakholeliyeeyo khaazi na aanaaka kilawe. Mweeyo mwinjuwa khaazi kuukholeliyeenini.” ");
INSERT INTO eko_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Labani khujipu yoori: “Safwatali nkhama onikisiileza ohilawe, miiyo sako zaka zakuuza yoori Nnyizinku akiparikhiya mwaasa wa weeyo. ");
INSERT INTO eko_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Apho okuuze phakari ontakhaaye kisala kuuripha.” ");
INSERT INTO eko_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yaakhumpa khunjipu: “Mweeyo mwinjuwa khaazi kuukholeliyeenini yoori ti ya waatta na nanna kaari oshukisaazo nyama zenu mpakha waatta. ");
INSERT INTO eko_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Miiyo kihinate nyama zenu zaari vattitthiiru leelo pi za waatta: Nnyizinku ooparikhiyani mwaasa wa miiyo. Khi ajamaazaku kinttela owaatthantta lini?” ");
INSERT INTO eko_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labani khumuuzela yoori: “Kuuriphe niini?” Khujipu Yaakhumpa: “Mwihikiriphe hatha etthu. Kintta orutela oshukisa nyama zenu amana nisiilana saana. ");
INSERT INTO eko_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Leelo kinttela woona maphanko ooshi a nyama zenu, kilazakamo pwittipwitthi zooriipa, zoottweleela na za malepa, puuzi zoottweleela na za malepa. Eto ti enttelaaye wiiya phakari yaka. ");
INSERT INTO eko_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Etthiipo enttela okhweya woona okho ninttaawo nkhama ki wa waamineya. Wakathi mwinttelaaye woona nyama zaka, amana yiiyamo nliphanko mwaka puuzi yoottweleela ama yoohiina malepa ama pwittipwitthi yoohiiyi yooriipa, mwintta ojuwa yoori keetta wiiya.” ");
INSERT INTO eko_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labani khuri: “Osiilana wetthu wiiye etthiipo olupiyeezo.” ");
INSERT INTO eko_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Siikhu ethiitile, Labani khuphakula puuzi zeelume na zeekha zaariina malepa oolakala, na pwittipwitthi epile zaariina malepa ooriipa khuwenkha aanaawe oshukisa. ");
INSERT INTO eko_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Labani khuruma osusisiwa liphanko ntthile, khulawaniwa ohali woolepawo kiyasi ya siikhu ttatthu ntthu ari nsafwari na okhule aariiwo Yaakhumpa. Yaakhumpa khusala ashukisa nyama za Labani epile zaasaliyeezo. ");
INSERT INTO eko_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yaakhumpa khushija virapi piishi za miitthi mittatthu zoofwarikhana khuwaka. ");
INSERT INTO eko_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ye aajuwiye yoori vahali aari onywaavo maphanko a nyama phi vahali zaari opepheranaavo. Ti eto aari otthaakaaye puutta epile zoophaka omaasho waya amana zinywaka. ");
INSERT INTO eko_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Amana zipepherana paata yawoona puutta epile, aana zaari owaapatthaaye aari wiiya oophaka, oottweleela, na a malepa. ");
INSERT INTO eko_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yaakhumpa khuphakula nyama epile khuttha mphule zaariimo pwittipwitthi zeekha zoolakala yoori zisala zeekesa okhule ziriiwo epile zooriipa na za malepa za nliphanko la Labani. Khufuwa maphanko awe khuphakula khuhikusanyi na epile za Labani. ");
INSERT INTO eko_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Amana zipepheriwaka epile zeekha za ruthupa, ye eetta otthaka puutta omaasho waya vahali zaari onywakaavo yoori zisala ziimittha zoonaka puutta epile. ");
INSERT INTO eko_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ila nawoona yoori nyama eti ti yawootta khaari ottheela puutta. Epile za wootta zaari wiiya za Labani ila epile za ruthupa zaari wiiya za Yaakhumpa. ");
INSERT INTO eko_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Wa nanna ethiito aari orettaaye, ye khwiiya thaajiri nwulweene khwiiyana maphanko a waatta a nyama, akarumeya aakha na aalume, nkamiiya na apuuru. ");
INSERT INTO eko_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yaakhumpa khuuziwa mattakhuzi aari olupaaye aana a Labani araka: “Yaakhumpa athuula zooshi paapa aariinaazo, areela mwaasa wa maali za paapa”. ");
INSERT INTO eko_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yaakhumpa khoona yoori Labani khaari omweettettisa saana nkhama aari omweettettisaazo raku. ");
INSERT INTO eko_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Nnyizinku khumuuza Yaakhumpa yoori: “Orutele nti wa apapazo okhu ovokoliweewo, miiyo kinttela wiiya vamote na-weyo.” ");
INSERT INTO eko_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yaakhumpa khuruma okhuweliwa Rakeele na Liiya yoori alawe otthuttu okhule aari ojisaawo nyama zawe. ");
INSERT INTO eko_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","N'oofiya khuwooza yoori: “Kinoona yoori papeenu khanikeettettisa saana nkhama raku. Ila Nluku wa paapa ori vamote na-miyo siikhu zooshi. ");
INSERT INTO eko_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Mweeyo mwinjuwa yoori kakhola khaazi ya papeenu khwa kuvu zaka zooshi. ");
INSERT INTO eko_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Papeenu khukittettekha na khuzukulisa phakari yaka swaafu khumi, ila Nluku khuhintakheli yoori akirettele zootakhala. ");
INSERT INTO eko_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","N'oolupa yoori nyama epile zooshi za wiiyana malepa phakari yaka, nyama epile khusala ziwaapattha aana awiiyana malepa paasi. N'oolupa yoori nyama zoottweleela pi zaawo, nyama epile khusala ziwaapattha aana oottweleela. ");
INSERT INTO eko_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Nluku othuuto ti ye athuuliyeeyo nyama za papeenu khukinkha miiyo. ");
INSERT INTO eko_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","N'oofiya wakathi zaari wiimitthaavo nyama epile, kooniye muulottha mirurumpi zaari opepheraaye ziri za malepa, zoottweleela na zooriipa. ");
INSERT INTO eko_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Nlayikha la Nluku khukikhuwela muulottha liraka: ‘Yaakhumpa!’ Miiyo khujipu: ‘Lape!’ ");
INSERT INTO eko_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Nlayikha ntthile khulupa yoori: ‘Olanse maasho awo woone nyama zimpepheriwa pi mirurumpi za malepa, zoottweleela, na zooriipa. Miiyo koonoza mwaasa yoori kinoona zooshi epile Labani anuurettelaazo. ");
INSERT INTO eko_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Miiyo ki Nluku otule oopuweleliyeeyo Beetele okhule waavaaziyeewo mafuttha liwe na khukaahiti. Oleemo mmuti mphu nasaapi ethiiti orutele nti ovokoliweewo.’” ");
INSERT INTO eko_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rakeele na Liiya khujipu araka: “Fweeyo khanina hatha etthu yoorithi mmakhono wa papeetthu. ");
INSERT INTO eko_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Oninoona nkhama amalapo! Anuuzanyisa, nzurukhu etthu wa mahari wooshi aja. ");
INSERT INTO eko_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Maali epi zooshi Nnyizinku alaziyeeyo mmakhono wa papeetthu pi zeetthu fweeyo na aaneetthu. Apho orette zooshi epi Nnyizinku awuuziyeeyo.” ");
INSERT INTO eko_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Yaakhumpa khuwaapakhira aanaawe na aakhaawe vankamiiya. ");
INSERT INTO eko_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Khuthuula nyama zawe na mali zawe zooshi aapatthiyeeyo Paata-Araamu, khusala alawa wa papaawe Esiyaakha tuniya ya Kanaani. ");
INSERT INTO eko_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Wakathi Labani alawiyeevo okasa ovuzi wa pwittipwitthi zawe, Rakeele khwiiya sanamu za papaawe aarettiyeeyo wiiya miluku zawe. ");
INSERT INTO eko_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ti nanna Yaakhumpa anretteliyeezo Labani Mwaarameewu, khutthirawo owawe woohinleezi. ");
INSERT INTO eko_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Khutthirisa vitthu zawe zooshi arinaazo, khulokha muuttho wa Efwarathi khusala alawa nti wa nyaako Gileyaadi. ");
INSERT INTO eko_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Eviriyeevo siikhu ttatthu, Labani khuuziwa yoori Yaakhumpa atthira. ");
INSERT INTO eko_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ye khuwaathuula ajamaaze khusala amwiikarisa Yaakhumpa mpakha siikhu sapa, khunsikana onyaako wa Gileyaadi. ");
INSERT INTO eko_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Aphano Nnyizinku khunlotthisa Labani osikhu eettaka olala yoori: “Phoole! Ohimuuze etthu yooshapweya Yaakhumpa ama yootakhala.” ");
INSERT INTO eko_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labani khunsikana Yaakhumpa eemesiye heema zawe onyaako wa Gileyaadi ye na ajamaaze, n'oofiya khumaka kharipu na attaaphale aamakiyeevo Yaakhumpa. ");
INSERT INTO eko_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ye khumuuzela Yaakhumpa yoori: “Epi okiretteliyeezo niini, zookittettekha khuwaathuula aanaaka nkhama atthu ookholiwa viittha? ");
INSERT INTO eko_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Wakittettekhela-ni khutthira sirini? Okijuwisiye khaneetta oleezana na furaha niipaka maliipo, koma na tthakare? ");
INSERT INTO eko_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Weeyo khuhikiweji khapula kileezanana aanaaka na atuulwaka! Epi orettiyeezo vitthu zoololo. ");
INSERT INTO eko_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Miiyo kinaaye owahi wa wuuhoowisa, ila osikhu wa taana Nluku wa papaawo khukuuza yoori: ‘Phoole! Ohimuuze etthu yootakhala ama yooshapweya.’ ");
INSERT INTO eko_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Aphano nkhama weeyo watthira mwaasa wa wuunukhela wa papaawo, miluku zaka weeyela-ni?” ");
INSERT INTO eko_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yaakhumpa khunjipu Labani araka: “Keetta woova, kaari wuupuwela yoori mwintta okinyakanya aaneenu. ");
INSERT INTO eko_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Amana mwinsikanana ntthu miluku zenu epo, ahiiye haayi. Mashaahiti ajamaazetthu apa; n'oosikana etthu ya wiiya yeenu kirina miiyo mwithuule.” Yaakhumpa khaajuwiye yoori Rakeele ti ye eeyiyeeyo miluku epile. ");
INSERT INTO eko_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labani khuvira nheema wa Yaakhumpa na nheema wa Liiya na etile ya akarumeya apale awiri, ila khuhisikanimo. Asaruwiyeemo nheema wa Liiya, khweetta nheema wa Rakeele. ");
INSERT INTO eko_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rakeele aarettiye atthiiye vathi wa nsaawu wa enkamiiya eekhaleliye. Labani khuwaathola mmaheema wooshimo khuhiwaasikani. ");
INSERT INTO eko_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rakeele khumuuza papaawe yoori: “Mwihikatipukhe mbwanaaka mwaasa woohilankhi n'oowoonani, keetta wiiya mmweezi.” Ye khweekesa miluku zawe epile ila khuhipatthi. ");
INSERT INTO eko_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yaakhumpa khwiiphiiriwa, khusala ammaruwela Labani yoori: “Niini kitthekiyeeyo? Wala kakosa-ni yoofiyelela okiikarisa mwiri wookatipukhawene? ");
INSERT INTO eko_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Mapwattha aka ooshi mwathola, mwasikanamo niini ya wiiya yeenu? Nkhama mwasikanamo etthu yeenu mwitiise apha ariivo attwiizaku na attwiizenu aniphuke fweeyo awiri. ");
INSERT INTO eko_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Nyaakha eshiriini kiri vamote na-mweyo. Khina pwittipwitthi yenu wala puuzi yenu enaharipweye erukulu yaya na akinarafune hatha pwittipwitthi moote ya liphanko lenu. ");
INSERT INTO eko_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Akinootiseleni hatha nyama moote yoovulalisiwa khufwa: miiyo keetta oriphelaka. Mweeyo mwaari oveka oriphiwa wakhula nyama yaari wiiyiwaaye osikhu na nthana. ");
INSERT INTO eko_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Nthana keetta ohoowa mwaasa wa haari, osikhu keetta ohoowa mwaasa wookizizima, osikizi khawaari okikhola. ");
INSERT INTO eko_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ti nanna miiyo keekhaliyeeyo vaje venu nyaakha eshiriini: kookholelani khaazi nyaakha khumi na mine yoori eeye mahari a aaneenu oowiiri, na nyaakha sitha kishukisaka nyama zenu phakari yaka yiiyaka nyama etthiipo, ila mweeyo khuzukulisa phakari yaka swaafu khumi. ");
INSERT INTO eko_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Eriwaka khaari Nluku wa paapa, Nluku wa Eburahiima otu amooviyeeyo Esiyaakha, wiiya vamote na-miyo, mweetta okiikara woohikinkhi etthu. Ila Nluku khoona ohoowa waka na khaazi kikholiyeeyo, taana osikhu Ye khuulikhisani.” ");
INSERT INTO eko_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labani khunjipu Yaakhumpa yoori: “Aakha apa aanaaka, aanaaya atuulwaka, nyama epo oriina pi zaaka. Zooshi epi onoonaazo pi zaaka. Miiyo kiwaarettele niini aanaaka na aanaaya apa awaavokoliyeeyo? ");
INSERT INTO eko_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Apho, nirette wahati miiyo na-weyo, otthuupo wiiye pi oshaahiti etthu.” ");
INSERT INTO eko_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Aphano Yaakhumpa khuthuula liwe khweemesa nkhama nripu. ");
INSERT INTO eko_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ye khuwooza ajamaaze yoori: “Mwilokotthele mawe muukele.” Yo khulokotthela, khwiikhala khusala aja nshini wa mawe atthaapale ookeliyeeyo. ");
INSERT INTO eko_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labani khutthaja nzina puuro yaya etile la Yakaare Sahatuuta, na-ye Yaakhumpa khutthaja nzina la Kaleeti. ");
INSERT INTO eko_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Aphano Labani khulupa yoori: “Mawe apa nuukeliye apha leelo, oshaahiti etthu miiyo na-weyo.” Ti eto yaari wiittheliwaaye nzina la Kaleeti. ");
INSERT INTO eko_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Khusala yiitteliwa theenya nzina la Misipha, mwaasa ye woolupa araka: “Nnyizinku asala aneekesela amana naattuwana. ");
INSERT INTO eko_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Amana owaahazula aanaaka na khuweekesa aakha akina oohiiyi yo, hatha nkhama khajuweeni ntthu, wuupuwele yoori Nnyizinku shaahiti etthu.” ");
INSERT INTO eko_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labani khumuuza Yaakhumpa yoori: “Woone mawe apa ariiye apha na nripu ntthi keemesiyeeyo vakatthi vetthu miiyo na-weyo. ");
INSERT INTO eko_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Kulu eti ya mawe na nripu, oshaahiti yoori akinteela wiirukhela kaapu yawo oteela wuuharipwela, wala weeyo ohiirukhe otaaka kaapu yaka oteela okiharipwela. ");
INSERT INTO eko_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Nluku wa Eburahiima, Nluku wa Nahoori, Nluku wa papaawo ti aniphuke miiyo na-weyo.” Yaakhumpa khulapha khwa nzina la Nluku wa Esiyaakha otule aari omoovaaye. ");
INSERT INTO eko_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yaakhumpa khuretta twaha vamwaako khuwaakhuwela ajamaaze ooshi aariinaaye yoori aje vamote, n'ooja nawiisha khulala vamwaako attaapho. ");
INSERT INTO eko_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Mmeesho mwaya lifwajiri Labani khulankha khuwaapejari aanaawe na atuuluwe, khuwaaparikhiya, nawiisha khusala arutela owawe. ");
INSERT INTO eko_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yaakhumpa khulankha khusala alawa safwari yawe khukutthanana malayikha a Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ye nawoona khuri: “Eti puuro ya anajanka a Nluku.” Aphale vaya khutthajavo nzina la Manayimu. ");
INSERT INTO eko_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yaakhumpa khuwaaruma akarumeyaawe yoori alokoze wa ttwiiye Ezawu nti wa Seyiiri tuniya ya Edomu. ");
INSERT INTO eko_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Khuwaaruma yoori: “Mwilawe mwamuuze mbwanaaka Ezawu yoori karumeyaawo Yaakhumpa alupa toono: ‘Keekhala vaje wa Labani siikhu za waatta mpakha leelo. ");
INSERT INTO eko_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Kapatthawo mompe, apuuru, pwittipwitthi na puuzi, akarumeya aalume na aakha. Aphano kinimperekheza hapari epi mbwanaaka yoori akipokherele wooshapweyavo.’” ");
INSERT INTO eko_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Akarumeya apale khurutela wa Yaakhumpa khumuuza yoori: “Naalawiye mpakha wa ttwiiyo Ezawu. Nanlikha eettaka ota, ontana atthu awe miiya nne oteela okutthanana weeyo.” ");
INSERT INTO eko_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ye khwiiya wa woova na wooshukulikha, khuwaawanya atthu apale aariina na maphanko a nyama khuntti piiri, pwittipwitthi, puuzi, mompe, na enkamiiya. ");
INSERT INTO eko_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Arettaka toowo oopuweliye yoori: “Ezawu amana ata okuumanana khushintta khuntti moote, eti kiina entta otthira.” ");
INSERT INTO eko_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Aphano Yaakhumpa khulompa araka: “Nluku wa paapa Eburahiima na Nluku wa paapa Esiyaakha, Oo Nnyizinku okuuziyeeyo yoori: ‘Orutele nti wa apapazo miiyo kinttela oweettettisa saana’, ");
INSERT INTO eko_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","akinsuhi pheta yawo ya waamineya khwa nanna okikholiyeezo miiyo karumeyaawo; wakathi kaari olokhaavo muuttho Yorotaani miiyo kaathuuliye pakhora yaka paasi, aphano kapattha khuntti piiri za atthu na nyama. ");
INSERT INTO eko_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Okuusuru mmakhono wa ttwiiyaku Ezawu, maana kinimoova oteela okuula vamote na aakha apa na asimaana. ");
INSERT INTO eko_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ila weeyo wakaahiti yoori onttela okeettettisa saana, na waattise peewu yaka nkhama mishaka za mmattima epi zihinaalakeyaaye.” ");
INSERT INTO eko_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Waari osikhu, ye khulala attaaphale. Mmaphanko wa nyama zawe khuthawulamo nyama zoomwinkha ttwiiye Ezawu: ");
INSERT INTO eko_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","miiya piiri puuzi zeekha na mirurumpi eshiriini, miiya piiri za pwittipwitthi na mirurumpi eshiriini, ");
INSERT INTO eko_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","enkamiiya talaathiini zeekha na aanaaya awaamwa, mompe zeekha talaathiini na zeelume khumi, apuuru eekha eshiriini eelume khumi. ");
INSERT INTO eko_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Wakhula liphanko la nyama epile khusala amwinkha karumeya mmote, khuwooza yoori: “Mwilokozise, maphanko apa mwaattuwanise.” ");
INSERT INTO eko_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Otule aalokoziyeeyo khumuuza araka: “Weeyo onlawa wakutthanane ttwiiyaku Ezawu. Amana awuuzela yoori ‘Nyama epi pi zaani wala weeyo ontta vayi?’ ");
INSERT INTO eko_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Weeyo onjipu yoori, ‘Pi za karumeyeenu Yaakhumpa, vitthu animperekhezaaye mbwanaawe Ezawu, ye aya ontta ota nyuma wetthu.’” ");
INSERT INTO eko_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Khunruma otule waphiiri na wattaatthu na apa akinoko aya aari operekhaaye maphanko a nyama, awoozaka yoori: “Amana mwikutthanana Ezawu, mooshi mwimuuze etthu moote. ");
INSERT INTO eko_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Mwihisahawu olupa yoori: ‘Yaakhumpa karumeyeenu ontta ota onyuma wetthu okho.’” Maana Yaakhumpa aari wuupuwela yoori: “Kintta onnyamaza wiiphiiriwa wawe Ezawu mwaasa wa vitthu epi kilokozisiyeezo. Amana kikutthanana talili onteela okipwekherela saana.” ");
INSERT INTO eko_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Khulokozisa vitthu epile, ila ye khulala attaaphale aamakiyeevo. ");
INSERT INTO eko_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Osikhu otthuupule Yaakhumpa khulankha khuwaathuula aakhaawe oowiri na akarumeyaawe apale awiri aakha, na aanaawe khumi na mmote, khuwaalosa muuttho wa Yabokhi. ");
INSERT INTO eko_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Khuwaalosa atthu apale na vitthu zawe zooshi aariinaazo. ");
INSERT INTO eko_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yaakhumpa khusala otthwe, khumpuwelela nlume mmote khusala oomanana mpakha ocha. ");
INSERT INTO eko_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Nlume otule ooniyeevo yoori khaari onkhitiri khumpiya n'yuunu mwawe khukurukunyuwa liphaja lawe eettaka wuumana. ");
INSERT INTO eko_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Aphano nlume otule khuri: “Okilikhe kilawe wacha.” Ye khuri: “Akinuulikha olawa ohikiparikhiyeeni.” ");
INSERT INTO eko_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Nlume otule khumuuzela yoori: “Nzina lawo o paani?” Khujipu araka: “Miiyo ki Yaakhumpa.” ");
INSERT INTO eko_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Nlume otule khutukhuru yoori: “Khunteela wiittheliwa theenya nzina la Yaakhumpa, ila nka okhuweleliwaka Ezirayeele. Mwaasa yoori weeyo woomanana Nnyizinku na atthu, khushintta.” ");
INSERT INTO eko_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yaakhumpa khumuuza yoori: “Kakhola moolu kuuzeni nzina lenu.” Ye khujipu araka: “Ontakha oretta-nne nzina laka?” Khumparikhiya attaaphale. ");
INSERT INTO eko_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yaakhumpa khulupa yoori: “Miiyo kamoona Nnyizinku wuuso khwa wuuso ila nalelo kiri haayi.” Ti eto khutthaja nzina puuro etile la Peniyeele. ");
INSERT INTO eko_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yaakhumpa lantthamuweliye njuwa alankhaka Peniyeele eettaka okokoja muulu mmote. ");
INSERT INTO eko_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ti eto mpakha leelo atthu a Ezirayeele khanja ntika wa nyama opu onluttaaye liphaja, mwaasa yaari phantte ya mwiili wa Yaakhumpa waapiiweeyo khukurukunyuwa. ");
INSERT INTO eko_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yaakhumpa khweekesa okhule aari weettaawo khumoona Ezawu eettaka ota na atthu awe miiya nne. Khuwaawanya aanaawe khumwinkha Liiya, Rakeele na akarumeyaawe apale awiri aakha. ");
INSERT INTO eko_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Khuwaalokozisa akarumeyaawe apale na aanaaya, khusala alottiwa ti Liiya na aanaawe, khwiishela Rakeele na Yuusufu. ");
INSERT INTO eko_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yaakhumpa khuwaalokozela, khukokhora khwiinama swaafu sapa mpakha nttunkhulu awe ofiya aphale aariivo. ");
INSERT INTO eko_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ezawu khutthira khulawa khumpatikha khumpejari, oowiiri khusala alila. ");
INSERT INTO eko_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ezawu khulansa maasho khuwoona aakha na aana, ye khuuzela yoori: “Khi apa apaani?” Yaakhumpa khunjipu: “Aana apa rehema Nnyizinku amwinkhiyeeyo karumeyeenu.” ");
INSERT INTO eko_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Aphano akarumeya apale na aanaaya khumwaattama khukokhora khwiinama. ");
INSERT INTO eko_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Elottelanaka Liiya khuta attaaphale na aanaawe khukokhora khwiinama. Wa wiishela aari Yuusufu na Rakeele, na-yo khuta khukokhora khwiinama. ");
INSERT INTO eko_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ezawu khuuzela yoori: “Nyama epile zooshi kisikaniyeeyo ntarikhi ontakhela-ni?” Yaakhumpa khujipu: “Kintakha kipatthe osuhi mmakhono mwenu mbwanaaka.” ");
INSERT INTO eko_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ezawu khulupa yoori: “Miiyo kinaaye pure ttwiiyaku, epo zaawo osalane omwennyewe.” ");
INSERT INTO eko_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yaakhumpa khusala ankhanyarela araka: “Mwihikatthale! Nkhama kinsuhi mmakhono mwenu safwatali pokherani vitthu epi, maana n'oowoonani mweeyo koona nkhama kimooniye Nnyizinku khwa nanna mwituveliweezo ti miyo. ");
INSERT INTO eko_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Kinuuvekelani yoori mwipokherele vitthu epi kuutiiseliyeenini mwaasa yoori Nnyizinku akiparikhiya, akinkha zooshi epile kinhithajiyaaye.” Ye khunkhanyarela Ezawu mpakha okhupali. ");
INSERT INTO eko_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ezawu khuri: “Nlawe nivire neettettaka.” ");
INSERT INTO eko_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ila Yaakhumpa khuri: “Mbwanaaka, mwinjuwa yoori aana apa nalelo asimaana na kinaaye pwittipwitthi na mompe zinaamwisaaye. Amana kikhanyarela weettettisa channu zooshi zintta ofwa siikhu moote. ");
INSERT INTO eko_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Apho mwilokoze mbwanaaka, miiyo kintta ota vattiitthi-vattiitthi khwa mwentto wa aanaaka na nyama zaka, mpakha ofiya nti wa Seyiiri.” ");
INSERT INTO eko_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ezawu khuri: “Kintakha atthu aka akina kuulikhele weeyo.” Yaakhumpa khuuzela yoori: “Mwaasa wa niini? Khinhithajiya. Ethiiti mwikipokhereliyeeyo saana paasi.” ");
INSERT INTO eko_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Siikhu ethiitile Ezawu khulankha khusala arutela owawe Seyiiri. ");
INSERT INTO eko_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yaakhumpa khulankha khusala alawa Sokoota. Ottuukhule khujeka nyuupa yawe na mazizi a nyama zawe. Ti eto atthajiyeevo nzina la Sokoota. ");
INSERT INTO eko_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yaakhumpa arutiyeevo Paata-Araamu khufiya Shekemu tuniya ya Kanaani ari nkumi, khweemesa heema zawe kharipu ya sitati ethiitile. ");
INSERT INTO eko_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Khuuzanya phantte moote ya nshapa puuro ethiitile eemesiyeevo heema zawe, na aana a Hamori, paapa wa Shekemu, khwa hisapu miiya nzurukhu wa feeta. ");
INSERT INTO eko_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Attaaphale khunjeka alitaari khuntthaja “Nluku yoori Nluku wa Ezirayeele.” ");
INSERT INTO eko_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Siikhu moote, Tiina mwaana wa Yaakhumpa na Liiya, aalankhiye olawa owaathotola aanaakha a nti otthuupule. ");
INSERT INTO eko_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Shekemu mwaana wa Hamori nhiivi mfwalume wa nti aya opule, n'oomoona, khunkhola khunjansili. ");
INSERT INTO eko_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Erettiyeevo toole khwiiya wootuveliwa ti Tiina mwaana wa Yaakhumpa, khumpheta, khumuuza mattakhuzi oomwiitthaaza rooho. ");
INSERT INTO eko_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Shekemu khumuuza Hamori papaawe yoori: “Mwakuurele mwaari otu kinrale.” ");
INSERT INTO eko_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Wakathi Yaakhumpa asiiliyeevo yoori mwanawe Tiina ajansiliwa ti Shekemu, aarettiye aanaawe ari ntthuttu ashukisaka nyama. Ye khunyamala khusala awaaweja aanaawe mpakha oruti. ");
INSERT INTO eko_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Khulankha Hamori paapa wa Shekemu olawa ottakhulana Yaakhumpa. ");
INSERT INTO eko_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Wakathi arutiyeevo aana a Yaakhumpa ntthuttu, n'oosiila vitthu epile yo khwiiya ooshanka channu, khuweephiira mwaasa yoori Shekemu aarettiye etthu yoopatthisa haaya vakatthi wa Meezirayeele, onjansili mwaana wa Yaakhumpa; eto etthu yahaari orettiwaayo. ");
INSERT INTO eko_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamori khuwooza yoori: “Mwanaka Shekemu atuveliwa ti mwanenu, apho safwatali mwinlooze eeye muukhaawe. ");
INSERT INTO eko_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Nirette ojama; aaneenu awaarale aaneetthu, na apa eetthu awaarale eenu. ");
INSERT INTO eko_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mwiikhale vamote na-fweyo, nti opu pu weetthu mwithawule wakhula phantte mwintakhaaye. Mwiikhale nttumphu mwirette zanshara zenu mpakha muuzanye nti eenu.” ");
INSERT INTO eko_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Aphano Shekemu khumuuza papaawe Tiina na alupuwe yoori: “Safwatali mwikikhupalele mattakhuzi apa, kintta owinkhani wakhula etile mwinttelaaye olupa. ");
INSERT INTO eko_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mwilupe mahari a waatta a mwanenu na tthuvo mwintakhaaye, kintta wuuriphani khwa nanna mwintakhaazo okuuza, ila mwikilooze.” ");
INSERT INTO eko_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Aphano aana a Yaakhumpa khunjipu Shekemu na papaawe wonhatavo, mwaasa wonjansili nlupwaaya Tiina. ");
INSERT INTO eko_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Khunjipu yoori: “Khaninwahi onthuula nlupweetthu khunlooza nlume woohikhiriyi koma, enttela wiiya haaya. ");
INSERT INTO eko_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Fweeyo ninkhupali wuuloozani nlupweetthu amana alume ooshi a mmuti mwenu eeya ookhiriya koma nkhama fweeyo. ");
INSERT INTO eko_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Toowo phi ninttelaavo wuuloozani aaneetthu na-fweyo owaarala aaneenu, ninttela wiikhala vahali vamote niiye ojama mmote. ");
INSERT INTO eko_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ila amana mwihikhupali okhiriya koma, nintta onthuula mwanetthu nileemo mmuti mwenu.” ");
INSERT INTO eko_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Mattakhuzi apale Hamori na mwanawe Shekemu khukhupalela. ");
INSERT INTO eko_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Shekemu, shapu wooshitahiwa pi atthu ooshi a vaje wa papaawe, khuhirupazi khulawa khuretta etile aavekeliweeyo mwaasa wontuvela mwaana wa Yaakhumpa. ");
INSERT INTO eko_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamori na mwanawe Shekemu khulankha khulawa vanlako wa sitati ethiitile owooza alume ooshi araka: ");
INSERT INTO eko_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Atthu apa pi oosiilaneya, nlaweni niwaalikhe eekhale mmuti mwetthu mphu arettaka zanshara zaya. Nti opu nwulweene ewaamo puuro eniwaafiyelaaye, anilooze aanaaya na-fweyo niwaalooze aaneetthu. ");
INSERT INTO eko_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ila yo ankhupali wiikhala vamote na-fweyo khwiiya ajamaazetthu amana alume ooshi akhiriya koma nkhama etthiipo na-yo akhiriyiyeezo. ");
INSERT INTO eko_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Nyama zaya zooshi na mali zaya zooshi zinttela wiiya zeetthu; nlaweni nikhupalele shawuri zaya yoori eekhale vamote na-fweyo.” ");
INSERT INTO eko_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Alume ooshi apale aakusanyeyiyeeyo vanlako wa sitati khukhupalela mattakhuzi apale aalupiyeeyo Hamori na mwanawe Shekemu; alume ooshi a sitati ethiitile khukhiriya koma. ");
INSERT INTO eko_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Siikhu yattaatthu, wakathi alume apale aari woonachaavo olwaaza, aana awiri a Yaakhumpa, Simiyooni na Leevi alupuwe Tiina, khuthuula phanka zaya, khweetta nsitati mphule woohijuwiwi ti hatha ntthu. Khuwoola alume ooshi. ");
INSERT INTO eko_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Khumuula Hamori na mwanawe Shekemu. Khunthuulawo Tiina owawe Shekemu khusala alawa. ");
INSERT INTO eko_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Khuta aana a Yaakhumpa apale akina ositati ottuukhule ooliiweewo atthu, khuttapwattha vitthu za mali mwaasa woojansiliwa nlupwaaya. ");
INSERT INTO eko_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Khuthuula liphanko la pwittipwitthi, la puuzi, mompe, na apuuru, na vitthu zaari nsitati nttumphule na epile zaari omashapa. ");
INSERT INTO eko_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Yo khuwaathuula aakha na aanaaya na vitthu zooshi za mali zaari mmamanyupa mwaya. ");
INSERT INTO eko_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Aphano Yaakhumpa khumuuzela Simiyooni na Leevi yoori: “Mweeyo mwakizinkula! Mwaretta yoori atthu apa aniikhalaaye nti otthuupu, Akanaani na Apirizi asala eephiiriwa ti miyo. Fweeyo khanaatteeni, yo amana akusanyeya ateela okuumanana antta okuula na ajamaazaku.” ");
INSERT INTO eko_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Yo khujipu araka: “Ti yooshapweya yo onretta omalempe nlupweetthu?” ");
INSERT INTO eko_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Nluku khumuuza Yaakhumpa yoori: “Olankhe olawe Beetele weekhale ottuukho, wanjekewo alitaari wa Nluku otu oopuweleliyeeyo wakathi waari ontthiraavo ttwiiyo Ezawu.” ");
INSERT INTO eko_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yaakhumpa khuwooza ajamaaze na atthu apale aariina yoori: “Mweeselele okho miluku zenu epo zoohifwayi mwiriinaazo, mwijitwaharishe mwiwale kuwo kiina. ");
INSERT INTO eko_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Nilankhe nilawe Beetele, ottuukho kinlawa kanjekewo alitaari woomwaaputuvo Nluku otu aakipuweleliyeeyo siikhu epile kaari mmashakha, otu aakilokoziyeeyo tarikhi zooshi kiviriyeezo.” ");
INSERT INTO eko_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Yo khumwinkha Yaakhumpa miluku zaya zooshi epile zoohifwayi aariinaazo, na pirinku epile aawaliyeeyo aakha ooshi, ye khuthuula khuthipela nshini wa muutthi nwulweene waari nti wa Shekemu. ");
INSERT INTO eko_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Wakathi yo alankhiyeevo alawaka, Nluku khuweeshushela woova atthu a sitati epile aattamananiyeezo, mphule aari oviraamo, yo khuhiweekarisi aana a Yaakhumpa. ");
INSERT INTO eko_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yaakhumpa khufiya na atthu awe ooshi nti wa Luuzu oniitthiwaaye Beetele, tuniya ya Kanaani. ");
INSERT INTO eko_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Khunjeka alitaari, puuro yaya etile khutthajavo nzina la Nluku wa Beetele mwaasa yoori Nluku aajithoonyeziye attaaphale wakathi opule Yaakhumpa aari ontthiraavo ttwiiye. ");
INSERT INTO eko_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Deebora, yaaya wa Rapekha khufwa, khuzikhiwa kharipu ya Beetele nshini wa muutthi nwulweene oniittheliwaaye Alooni-Pakuuti. ");
INSERT INTO eko_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yaakhumpa n'ooruti Paata-Araamu, ari Beetele, Nluku ampuweleliye swaafu yaphiiri khumparikhiya. ");
INSERT INTO eko_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Khumuuza yoori: “Nzina lawo o Yaakhumpa ila waaza leelo walikha, aphano nzina lawo o Ezirayeele.” Ti nanna Nluku antthajiyeeyo nzina la Ezirayeele. ");
INSERT INTO eko_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Nluku khumuuza theenya araka: “Miiyo ki Nluku Woowahi Wooshi, mwivokolelane na mwaattelane. Khwa peewu yawo weeyo enteela opuwa khapila na khuntti ya khapila za waatta na anlawa apuwevo afwalume. ");
INSERT INTO eko_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nti kimwinkhiyeeyo Eburahiima na Esiyaakha kinteela owinkha weeyo na peewu yawo.” ");
INSERT INTO eko_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Nawiisha ottakhulana Yaakhumpa, Nluku khulawa. ");
INSERT INTO eko_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yaakhumpa khweemesa nripu la mawe vahali attaaphale aattakhulaniyeevo Nluku. Khwiitthela viinyu nripu laya ntthile na khuvaaza mafuttha. ");
INSERT INTO eko_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ye khutthaja nzina la Beetele puuro yaya etile aari ottakhulanaavo Nluku. ");
INSERT INTO eko_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yo khulankha Beetele, nalelo ahinafiye Efwarata Rakeele khwiiyana tafwawuthi khuluyeene ya woona olwaaza asaleelaka ompattha mwaana. ");
INSERT INTO eko_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Oonaka olwaaza channu, mwaatani khumuuza yoori: “Ohoove! Weeyo wampattha mwaana nkina theenya wanlume.” ");
INSERT INTO eko_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ettaka oshakhi ahinattiye phuumu, khuntthaja nzina mwaana otule la Benooni, ila papaawe na-ye khuntthaja nzina la Bejami. ");
INSERT INTO eko_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Aphano Rakeele khufwa khulawa khuzikhiwa tarikhi ya Efwarata (yiiyiye Belemu). ");
INSERT INTO eko_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yaakhumpa khutthaavo alama ya nshuhuti vakhapuri ya Rakeele, mpakha leelo eti liwaapho. ");
INSERT INTO eko_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ezirayeele khulankha khuvikana korofwa ya Eeteri khulawa khweemesa heema zawe. ");
INSERT INTO eko_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Siikhu moote, Ezirayeele eekhalaka nti otthuupule, mwanawe Ruubeni khulawa khulalana Biila, mwiitthwaana otule aari muukha nkina wa papaawe, ila hapari epile khumfiyela papantthu. Ezirayeele aarina aana khumi na awiri. ");
INSERT INTO eko_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Aana aavokoleliweeyo Liiya ti Yaakhumpa pi apa: wamwanzo ti Ruubeni, alottiwaka ti Simiyooni, Leevi, Yuuda, Esakhaari na Zabulooni. ");
INSERT INTO eko_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Aana aavokoleliweeyo Rakeele: ti Yuusufu na Bejami. ");
INSERT INTO eko_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Na-ye aana a Biila karumeya wa Rakeele pi apa: Daani na Nafitaali. ");
INSERT INTO eko_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Aana a Ziilipa karumeya wa Liiya pi apa: Gaati na Asheeri. Aari atthaapo aana a Yaakhumpa awaapatthiyeeyo nti wa Paata-Araamu. ");
INSERT INTO eko_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Aphano Yaakhumpa khurutela wa papaawe nti wa Manre kharipu na Kiriyati-Aarapa wiiyiye Heporooni, ohali aari wiikhalaawo Eburahiima na Esiyaakha. ");
INSERT INTO eko_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Esiyaakha eekhaliye nyaakha miiya na thamaaniini. ");
INSERT INTO eko_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Afwa ari wa wuuluvala arina nyaakha za waatta, aanaawe Ezawu na Yaakhumpa khunzikha. ");
INSERT INTO eko_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Eti peewu ya Ezawu anjuwaniwaaye nzina la Edomu. ");
INSERT INTO eko_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ezawu khuwaarala aakha a Kanaani. Mmote aari wiitthiwa Aada aari mwaana wa Elooni, nhiiti. Nkinoko aari wiitthiwa Olipama mwaana wa Anahi ntuulu wa Zipiyooni Nhiivi, ");
INSERT INTO eko_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","na Basemaathi mwaana wa Esumayila nlupuwe Nepayoothi. ");
INSERT INTO eko_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Aada aavokoleliwe mwaana ti Ezawu khuntthaja nzina la Elifazi, na Basemaathi khunvokola Rewele. ");
INSERT INTO eko_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Na Olipama khunvokola Yewuushi, Yalaamu na Koora. Apa aari aana Ezawu awaavokoliyeeyo tuniya ya Kanaani. ");
INSERT INTO eko_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ye khuwaathuula aakhaawe na aanaawe na atthu ooshi aari wiikhalanaaye na vitthu zooshi aapatthiiyeezo tuniya ya Kanaani waaza pwittipwitthi zawe, puuzi na mompe zawe zooshi, khumwazeyanana ttwiiye Yaakhumpa khulawa khwiikhala nti nkina. ");
INSERT INTO eko_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ye khuthama mwaasa wa nti opule aari wiikhalaaye khawaarina etthu-yooja yoofiyela oja nyama zaya zooshi, mali zaya zaari za waatta khuhisala ewaheya wiikhala vahali vamote. ");
INSERT INTO eko_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ezawu, otu aniitthiwaaye Edomu, khuthama khulawa khwiikhala onyaako wa Seyiiri. ");
INSERT INTO eko_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Eti peewu ya Ezawu paapa wa Meedomu aniikhalaaye onyaako wa Seyiiri. ");
INSERT INTO eko_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Apa mazina a aana a Ezawu: Elifazi mwaana wa Aada muukha wa Ezawu, Rewele mwaana wa Basemaathi muukha wa Ezawu. ");
INSERT INTO eko_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Apa mazina a aana a Elifazi: Teemani, Omari, Zeefo, Katamu na Kenaazi. ");
INSERT INTO eko_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Tinna, muukha nkina wa Elifazi mwaana wa Ezawu, aavokoleliwe mwaana aari wiitthiwaaye Amaleekhi. Apa atuulu a Aada muukha wa Ezawu. ");
INSERT INTO eko_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Apa aari aana a Rewele: Nahathi, Zeera, Shaama na Miiza. Apa atuulu a Basemaathi muukha wa Ezawu. ");
INSERT INTO eko_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Apa aana a Olipama muukha wa Ezawu, mwaana wa Anahi, ntuulu wa Zipiyooni: Yewuushi, Yaalamu, na Koora. ");
INSERT INTO eko_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Apa mahaakhimu a mahimo a peewu ya Ezawu: Elifazi, mwaana wamwanzo wa Ezawu, aanaawe aari apa: Haakhimu Teemani, haakhimu Omari, haakhimu Zeefo, haakhimu Kinaazi, ");
INSERT INTO eko_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","haakhimu Koora, haakhimu Katamu, na haakhimu Amaleekhi. Apo aari mahaakhimu a peewu ya Elifazi nti wa Edomu. Aari atuulu a Aada. ");
INSERT INTO eko_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Aana a Rewele, mwaana wa Ezawu aari apa: Haakhimu Nahathi, haakhimu Zeera, haakhimu Shaama na haakhimu Miiza. Apa mahaakhimu a Rewele nti wa Edomu na atuulu a Basemaathi muukha wa Ezawu. ");
INSERT INTO eko_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Aana a Olipama muukha wa Ezawu, aari apa: Haakhimu Yewuushi, haakhimu Yaalamu na haakhimu Koora. Apa mahaakhimu a peewu ya Olipama muukha wa Ezawu mwaana wa Anahi. ");
INSERT INTO eko_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ooshi apa mahaakhimu na aana a Ezawu otu anjuwaniwaaye nzina la Edomu. ");
INSERT INTO eko_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Apa aana a Seyiiri, nhoori aari wiikhalaaye nti otthuupule; Lotaani, Shobaali, Zipiyooni, Anahi, ");
INSERT INTO eko_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Diishoni, Eseeri na Diishani. Apa aari mahaakhimu a nti wa Hoori, aana a Seyiiri nti wa Edomu. ");
INSERT INTO eko_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Aana a Lotaani aari apa: Hoori, Hemani, na Tinna nlupu wa Lotaani. ");
INSERT INTO eko_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Aana a Shobaali aari apa: Aluvani, Manahati, Ebali, Shefo na Onamu. ");
INSERT INTO eko_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Aana a Zipiyooni aari apa: Aaya na Anahi othuuto ooneliyeeyo nlipu wa maati oolukuza n'yaara ashukisaka apuuru za papaawe Zipiyooni. ");
INSERT INTO eko_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Aana a Anahi aari apa: Diishoni na Olipama. ");
INSERT INTO eko_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Aana a Diishoni aari apa: Hemetaani, Eshipaani, Ethirani na Keerani. ");
INSERT INTO eko_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Aana a Eseri aari apa: Bilani, Zaawani na Akani. ");
INSERT INTO eko_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Aana a Diishani aari apa: Wuuzi na Araani. ");
INSERT INTO eko_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Apa aari mahaakhimu a Ahoori: Lootani, Shopali, Zipiyooni, Anahi, ");
INSERT INTO eko_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Diishoni, Eseeri na Diishani. Apa aari mahaakhimu a ahoori, ti nanna aawanyeyiyeezo mahimo aya nti wa Seyiiri. ");
INSERT INTO eko_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Apa afwalume aariina yenzi nti wa Edomu ahineeyevo hatha mfwalume mmote wa mwiizirayeele. ");
INSERT INTO eko_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beela mwaana wa Bewoori ti ye aathawaliyeeyo tuniya ya Edomu, sitati yawe yaari wiitthiwa Dinaapa. ");
INSERT INTO eko_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","N'oofwa Beela, khuthawala Yobaabu mwaana wa Zeera wa sitati ya Bozara. ");
INSERT INTO eko_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobaabu khufwa, khuthawala Hushaamu wa nti wa Temaani. ");
INSERT INTO eko_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Khufwa Hushaamu, khuthawala Hadaadi mwaana wa Bedaadi aawaashinttiyeeyo Amidiyaani nti wa Mowaabu. Sitati yawe yaari wiitthiwa Avithi. ");
INSERT INTO eko_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadaadi khufwa, khuthawala Samula wa nti wa Masareka. ");
INSERT INTO eko_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samula khufwa, khuthawala Shawulu wa nti wa Rohopoothi waattameliyeeyo muuttho Efwarathi. ");
INSERT INTO eko_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shawulu khufwa, khuthawala Baali-Hanani mwaana wa Akiboori. ");
INSERT INTO eko_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Afwiiyeevo Baali-Hanani mwaana wa Akiboori khuthawala Hadaari, sitati yawe yaari wiitthiwa Paawu, muukhaawe aari Mehetabeeli mwaana wa Matereeti ntuulu wa Mezahaabu. ");
INSERT INTO eko_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Mahaakhimu apa aari a peewu ya Ezawu, na mahimo aya na miti zaya: Haakhimu Tinna, Aluvani, Yeteeti, ");
INSERT INTO eko_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholipama, Elaahi, Pinoni, ");
INSERT INTO eko_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaazi, Temaani, Mibizaari, ");
INSERT INTO eko_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Makidiyeeli na Iramu. Apa aari mahaakhimu a Edomu; wakhula mmote aari wiikhala puuro etile aari othawalaaye. Meedomu ooshi peewu ya Ezawu. ");
INSERT INTO eko_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yaakhumpa aari wiikhala tuniya ya Kanaani ottuukho aasaafireliyeewo papaawe. ");
INSERT INTO eko_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Eti hatiithi ya peewu ya Yaakhumpa. Yuusufu arina nyaakha khumi na sapa, aari nshuki wa pwittipwitthi na puuzi za papaawe vamote na attwiize aana a Biila na Ziilipa, aakha a papaawe. Yuusufu eetta omuuzaka papaawe vitthu zootakhala aari orettaazo attwiize. ");
INSERT INTO eko_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ezirayeele aari ompheta Yuusufu zayita aana apale akinoko aya, mwaasa yoori ampatthiye ooluvaliye. Khunsonela ajapi ya kisawu za waatta. ");
INSERT INTO eko_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Attwiize nawoona yoori oniiya ophetiwa ti papaaya zayita yo, khwaaza wiiphiiriwa ti ye khuhisala awahi onttakhulana saana. ");
INSERT INTO eko_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Siikhu moote, Yuusufu khulottha jozi, n'oowooza attwiize yo khutepa wiiphiiriwa ti ye. ");
INSERT INTO eko_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ye khuwooza yoori: “Mwisiileze jozi kilotthiyeeyo! ");
INSERT INTO eko_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Kalottha niri mmashapa nifukaka misama za tiriku, nsama aka khweemela, misama zenu mweeyo khuzukulela khwiinamela opu waaka.” ");
INSERT INTO eko_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Attwiize khumuuzela yoori: “Apho niri weeyo onttela wiiya mfwalume etthu fweeyo? Ama niri ti weyo onttelaaye onilokozela?” Khutepa wiiphiiriwa mwaasa wa jozi etile na mattakhuzi awe. ");
INSERT INTO eko_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Khurutela olottha khuwooza attwiize yoori: “Kalottha theenya! Njuwa, mweezi na matthottowa khumi na limote zikiinameliye.” ");
INSERT INTO eko_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","N'oomuuza papaawe na attwiize, papaawe khunshowera araka: “Jozi-ni eto olotthiyeeyo? Niri miiyo, attwiizo na mamaawo ninteela wuukokhorela weeyo?” ");
INSERT INTO eko_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Waaza attaapho attwiize khuwaata nrima na-ye, papaawe khusala apheleleza vitthu epile varoho vawe. ");
INSERT INTO eko_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Siikhu moote, attwiize Yuusufu aalawiye oshukisa nyama za papaaya kharipu ya sitati ya Shekemu. ");
INSERT INTO eko_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Aphano Ezirayeele khumuuza Yuusufu araka: “Attwiizo anshukisa nyama kharipu ya Shekemu. Apho kintakha yoori weeyo olankhe olawe ottuukho.” Ye khujipu: “Kemaani, kasiila paapa.” ");
INSERT INTO eko_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Papaawe khumuuza: “Wawoone nkhama akumi na nyama zaya, ote okuuze.” Yaakhumpa oninrumaru aarettiye ari mmujokowa wa Heporooni, Yuusufu khulankha khusala alawa Shekemu. ");
INSERT INTO eko_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Asaleelaka ofiya Shekemu khuthowelela. Khusikaniwa ti mwinyi mmote eettaka ojeettettela ntthuttu khumuuzela yoori: “Weyo! Oneekesa-ni?” ");
INSERT INTO eko_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ye khunjipu araka: “Kiniweekesa attwiizaku; safwatali kuuzeni ohali anshukisaawo nyama zaya?” ");
INSERT INTO eko_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Mwinyi otule khujipu yoori: “Apha avikanavo, kawaasiila araka: ‘Nintta Dotaani.’” Yuusufu khusala aweekesa, khuwaasikana asaleelaka ofiya Dotaani. ");
INSERT INTO eko_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Attwiize n'oomoona eettaka ota, ari peetiwene ahinawaafiyele khuwaza shawuri zoomuula. ");
INSERT INTO eko_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Yo khuuzana yoori: “Ahee! Namalottha nwulu oto ontta ota! ");
INSERT INTO eko_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Aphano akhweya. Nlaweni nimuule nimweeselele valiphotto nalupe yoori eetta orafuniwa ti nyama za ntthuttu. Noone olottha wawe vahali onttelaaye wiishelavo.” ");
INSERT INTO eko_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruubeni n'oosiila khumwaakisela khulupa yoori: “Nihimwankameze!” ");
INSERT INTO eko_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Khulupa theenya yoori: “Nihimuule. Nimweeselele vanlipu oriiye n'yaara mpho, ila mwihinvulalise.” Ye alupaka toowo, aariye amuusuru ttwiiye arutele wa papaawe ari haayi. ");
INSERT INTO eko_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yuusufu n'oowaafiyela attwiize, yo khunvula ajapi etile yooshapweya aawaliiyeeyo, ");
INSERT INTO eko_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","khuntthempa khumweeselela vanlipu woohiivo hatha etthu na oohivo maati. ");
INSERT INTO eko_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Yo khwiikhala yoori aje, khuwoona annya-zanshara eettaka ota ari ohali woolepawo, annya-esumayila aari olankhaaye Kileyaati na enkamiiya zaya apakhiriye viluko, paalasamu, na mafuttha oonukhela eettaka Misuri. ");
INSERT INTO eko_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuuda khuwoozela attwiize yoori: “Ena fwayita-ni omuula ttwiiyetthu khunvitha? ");
INSERT INTO eko_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Nihimuule, niwoozanyeze annya-esumayila apo, maana ye ti ttwiiyetthu, taamu yetthu moote.” Attwiize apale akinoko aya khukhupalela. ");
INSERT INTO eko_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Khunlazavo vanlipu aphale aamweeseleliyeevo, khuwoozanyeza annya-esumayila aari oviraaye, a nti wa Midiyaani, na nzurukhu eshiriini wa feeta. Yo khunthuula khusala alawana Misuri. ");
INSERT INTO eko_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Wakathi Ruubeni aruteliyeevo vanlipu aphale, khuthurumelavo khuhinsikanivo, attaaphale khuvarula kuwo zawe athoonyezaka yoori ori nhuzuni. ");
INSERT INTO eko_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Khurutela aphale aariivo attwiize khuwooza yoori: “Mweyo! Shaapu otule khaavo vanlipu aphale! Kiri toovi?” ");
INSERT INTO eko_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Khuthuula ajapi ya Yuusufu, khuula puuzi moote, taamu yaya khuttukunttela. ");
INSERT INTO eko_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","N'ooretta toole, khuthuula ajapi etile ya waatta kisawu khumweettisela papaaya, khumuuza yoori: “Ajapi eti neetta olokottha. Nkoonani nkhama khahiyo ya mwanenu.” ");
INSERT INTO eko_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ezirayeele khufwahamu khuri: “Ajapi ya mwanaka! Khweele-khweele nyama yoohusuti yeetta omuula khunrafuna.” ");
INSERT INTO eko_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Aphano Yaakhumpa khuvarula kuwo zawe khuwala saakhu khusala anlilela mwanawe siikhu za waatta. ");
INSERT INTO eko_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Aanaawe ooshi aalume na aakha khuteela onzuru, ila ye khukatthala ozurwiwa waya alupaka yoori: “Kiniikhala woolila etthiipi mpakha olawa okutthanana mwanaka aahera.” Khwiiya wonlilela mwanawe Yuusufu. ");
INSERT INTO eko_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Wakathi aya opo Amidiyaani aarettiye amuuzanyisiye Yuusufu wa Potifwaari nttunkhulu wa anamweekesela a Firawuuna. ");
INSERT INTO eko_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Wakathi aya opo Yuuda aamwazeyananiye attwiize khusala eekhala wa mwinyi mmote aari wiitthiwaaye Hiira nti wa Atulaamu. ");
INSERT INTO eko_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ottuukho Yuuda ansikaniyeewo mwanankha mmote aari mwaana wa nkanaani aari wiitthiwaaye Shuuwa, ye khunrala. ");
INSERT INTO eko_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Khwiimittha khumpattha mwaana khuntthaja nzina la Eeri. ");
INSERT INTO eko_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Khwiimittha theenya khumpattha mwaana nkina khuntthaja nzina la Onaani. ");
INSERT INTO eko_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Khurutela theenya khumpattha mwaana khuntthaja nzina la Shela, ompattikhanaru Yuuda aarettiye ari nti wa Kezipu. ");
INSERT INTO eko_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ye khumweekesa muukha aari wiitthiwaaye Tamaara khunlooza mwanawe Eeri. ");
INSERT INTO eko_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ila Nnyizinku khuhintuveli thwapiya za Eeri, khufiyelela omuula. ");
INSERT INTO eko_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Aphano Yuuda khumuuza Onaani yoori: “Onrale muukha wa marehemu ttwiiyo, ompatthele aana yoori ttwiiyo eeyane peewu khwa weyo.” ");
INSERT INTO eko_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ila Onaani aajuwiye yoori aana aari weettelaaye opattikhana, khaari weettela wiiya awe. Ti eto, amana arapalelana muukha wa ttwiiye, zina yawe aari wiitthelaka vathi yoori ahiwaapatthe aana eeya a ttwiiye. ");
INSERT INTO eko_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Nnyizinku khuhisala zintuvela vitthu epile aari orettaazo khufiyelela omuula. ");
INSERT INTO eko_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Aphano Yuuda khumuuza Tamaara muukha wa mwanawe yoori: “Orutele wa apapazo ori nankhwele onwejaka mwanaka Shela owula.” Ye aalupiye toowo mwaasa woomoovisa mwanawe Shela ofwa. Tamaara khulawa khwiikhala wa papaawe. ");
INSERT INTO eko_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ziviriyeevo siikhu za waatta, khufwa muukha wa Yuuda mwaana wa Shuuwa, nawiisha matthaka khulankha na swaahipu awe Hiira wa nti wa Atulaani, khusala alawa owoona atthu apale ari okasaaye ovuzi wa nyama zaya nti wa Tinna. ");
INSERT INTO eko_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Khuuziwa Tamaara yoori: “Nkhwewo ontta ovira, oneetta Tinna olawa okasisa nyama zawe.” ");
INSERT INTO eko_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Khuvula kuwo zawe epile aawaliyeezo z'oonankhwele, khujifinikha nshukwi yoori ahijuwiwe, khulawa khwiikhala vanlako wa sitati ya Enayimu waattamana na tarikhi ya Tinna. Ye aarettiye toowo mwaasa woojuwa yoori Shela awula, ila khwiiya ahinalooziwe. ");
INSERT INTO eko_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuuda n'oomoona khumwaakanyerela omalempe, mwaasa yoori aajifinikhaniye nshukwi omaasho wawe. ");
INSERT INTO eko_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ye khunkhuwela araka: “Nkatu! Kinuutakha, kuulalane.” Ye ahijuwaka yoori ti nkhwewe muukha wa mwanawe. Tamaara khumuuzela yoori: “Amana kilalana weeyo onikinkha-ni?” ");
INSERT INTO eko_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yuuda khunjipu yoori: “Kintta wuuperekheza puuzi moote ya nliphanko mwaka.” Tamaara khuri: “Aayo! Kasiila. Ila okilikhele etthu kinwahaaye waamini yoori onlawa wakiperekheze puuzi yaya eto.” ");
INSERT INTO eko_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ye khumuuzela araka: “Kuulikhele niini?” Tamaara khujipu yoori: “Okilikhele peetthe yawo, mfukho awo na pakhora eto oriina mmakhono mwawo.” Yuuda khumwinkha zooshi epile anvekeliyeezo, khunlalana khwiimittha. ");
INSERT INTO eko_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Nawiisha Tamaara khurutela owawe khuvula nshukwi khuwala kuwo zawe epile z'oonankhwele. ");
INSERT INTO eko_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuuda khuthuula puuzi khumwinkha swaahipu awe Hiira yoori alawane athuule vitthu epile anlikheliyeeyo muukha otule, ila ye khuhinsikani. ");
INSERT INTO eko_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Hiira khuwoozela atthu a nti aya opule yoori: “Ori vayi malempe otule aniikhalakaaye ntarikhi?” Yo khujipu araka: “Mmuti mphu khaamo hatha malempe wa wiiya wa nttumphu.” ");
INSERT INTO eko_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ye khurutela wa swaahipu awe Yuuda, khumuuza yoori: “Akinsikaneeniwo, atthu a nti aya opule akuuza yoori khaawo hatha malempe wa wiiya wa mmuti nttumphule.” ");
INSERT INTO eko_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuuda khulupa yoori: “Ti asalane epile kimwinkhiyeezo yoori ehikikwele paathuli, miiyo kaaperekhiye puuzi yaya, ila weeyo khuhinsikani ye aya.” ");
INSERT INTO eko_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","N'oovira nyeezi mittatthu, khuuziwa Yuuda yoori: “Nkhwewo Tamaara araruwa, apha eemittha.” Ye khuri: “Athuuliwe alawe alukuziwe!” ");
INSERT INTO eko_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Athuuliweevo alawaka olukuziwa, khumperekheza nhupi nkhwewe araka: “Erukulu eti kiriina ti ya mwennyewe vitthu epi.” Khulupa theenya yoori: “Moone pakhora eti, mfukho opu na peetthe eti nkhama mwininjuwa mwennyewe.” ");
INSERT INTO eko_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuuda nawoona vitthu epile khulupa yoori: “Ye ti wa shariya zayita miiyo, maana kamwaahitiye oraliwa ti mwanaka Shela.” Na Yuuda khuhiruteli orapalelana. ");
INSERT INTO eko_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ofiiyeevo wakathi woopattha ekumi, mwiirukulu mwawe aarimo aana awiri. ");
INSERT INTO eko_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Apatthaka ekumi otu mmote aya khusarula nkhono awe mmote, mwaatani khuthuula luuzi lookhuttuwa khumfukela khuri: “Otu ti eeyiye tthakuzi woosaruwa.” ");
INSERT INTO eko_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Otule aasaruliyeeyo nkhono awe khurutiselamo, khusaruwa otule ahaasaruliyeeyo, mwaatani khuri: “Huu! Wapattha toovi tarikhi yoosaruwa?” Khuntthaja nzina la Pereezi. ");
INSERT INTO eko_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Aphano, khusaruwa ttwiiye otule aafukeliweeyo luuzi lookhuttuwa nkhono awe, khutthajiwa nzina la Zeera. ");
INSERT INTO eko_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yuusufu aathuuliwe khulawaniwa Misuri pi annya-esumayila. N'oofiya khuuzanyeziwa Potifwaari mmisuri, karumeya nwulu wa Firawuuna, namalokozela wa anamweekesela. ");
INSERT INTO eko_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Nnyizinku aari vamote na Yuusufu, khunjaaliwa eekhalaka Misuri vaje wa mbwanaawe. ");
INSERT INTO eko_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Mbwanaawe otule khoona yoori Nnyizinku ori vamote na Yuusufu, wakhula etthu aari orettaaye Nnyizinku eetta onjaaliwa, ");
INSERT INTO eko_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yuusufu khwiiya woofwayi mmakhono wa Potifwaari khumwinkha ottunkhulu wa weettettisela vaje vawe na mali zawe zooshi. ");
INSERT INTO eko_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Paata yoomwinkha ottunkhulu wa vaje vawe na wa mali zawe zooshi, Nnyizinku khuparikhiya vaje aphale mwaasa wa Yuusufu. Parakha ya Nnyizinku yeeshukheliye khwa zooshi epile aariinaazo, waaza vaje mpakha mmashapa mwawe. ");
INSERT INTO eko_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Zooshi aariinaazo nttunkhulu aya khwiiya Yuusufu, Potifwaari khaari ojali hatha etthu yoohiiyi etthu-yooja etile ari ojakaaye. Yuusufu aari wooshapweya wumpo na wa weeziwa. ");
INSERT INTO eko_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","N'oorettikhana vitthu epile, muukha wa Potifwaari khwaaza ontakha Yuusufu. Siikhu moote khumuuza yoori: “Weeyo nlawe wakilalane.” ");
INSERT INTO eko_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ye khukatthala, khumuuza muukha wa mbwanaawe yoori: “Moone! Mbwanaaka khanjali vitthu za vaje apha; zooshi ariinaazo, ziri mmakhono mwaka. ");
INSERT INTO eko_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Khaavo mmote akizitiyeeyo miiyo vaje apha, khayiivo hatha etthu moote akikhattaziyeeyo ila mweeyo wala, mwaasa yoori mwa muukhaawe. Etthu yootakhala nkhama eto, kirette mwaasa wa niini? Toowo kintta onkosa Nnyizinku!” ");
INSERT INTO eko_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Wakhula siikhu muukha otule eetta onkhanyarela yoori alawe anlalane, ila Yuusufu khuhisala ansiileza na khusala anwerawera. ");
INSERT INTO eko_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Siikhu moote, ye khuvira nnyupa olawa okhola khaazi zawe, aarettiye ahiwo hatha mwiitthwaana mmote. ");
INSERT INTO eko_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Muukha wa Potifwaari khukhola orempo awe khumuuza yoori: “Haya okilalane!” Yuusufu khunlikhela orempo awe mmakhono mwawe khutthirela vaje. ");
INSERT INTO eko_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Muukha otule ooniyeevo yoori atthira khulikha orempo awe, ");
INSERT INTO eko_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","khuwaakhuwela akarumeya khuwooza yoori: “Mmoone! Mwiibereewu otu atiisiweeyo ti mannaka aaza onitarawu. Aaviriye okatthi waka khusala atakha okilalana, ila miiyo khusala kikhuwa kinyakulaka. ");
INSERT INTO eko_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ye nawoona yoori keetta onyakula khukilikhela orempo awe khutthirela vaje.” ");
INSERT INTO eko_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ye khupweha orempo opule mpakha mbwanaawe ota. ");
INSERT INTO eko_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Wakathi atiiyeevo khumuuza mattakhuzi apale araka: “Mwiitthwaana awo otule wa mwiibereewu onitiiseliyeeyo apha, aakiteeliye khusala atakha okilalana. ");
INSERT INTO eko_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Kikhuwiyeevo ye khukilikhela orempo awe khutthira.” ");
INSERT INTO eko_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Paata yoosiila mattakhuzi apale aari wuuziwaaye ti muukhaawe, araka: “Mwiitthwaana awo vitthu akiretteliyeezo pi epo,” ye khukasirikha venkivene. ");
INSERT INTO eko_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Khuruma weetteliwa Yuusufu khulawa khutthiiwa nkalapooso, nttumpho mfwalume Firawuuna aawaafukeliyeemo atthu awe. ");
INSERT INTO eko_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ila Nnyizinku ari vamote na Yuusufu anthoonyezaka pheta ya waamineya, nttunkhulu wa anamweekesela kalapooso khunkola saana. ");
INSERT INTO eko_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Khumwinkha ottunkhulu Yuusufu wa anamfukeliwa ooshi, khwiiya namalokozela vitthu zooshi za nkalapooso mphule. ");
INSERT INTO eko_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Nttunkhulu wa anamweekesela a kalapooso etile khuhisala ajali hatha etthu, zooshi zaari mmakhono wa Yuusufu mwaasa yoori Nnyizinku aari vamote na-ye; na wakhula etile aari orettaaye aari wiiya woojaaliwa. ");
INSERT INTO eko_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Paata yoovira vitthu epile, namootela zoonywa za mfwalume na namuupa-phaawu khunkosa mbwanaaya, mfwalume wa Misuri. ");
INSERT INTO eko_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Firawuuna khwiiya wa wiiphiiriwa pi annya-khaazi awe apo awiri; nttunkhulu wa wootela zoonywa na nttunkhulu wa wuupa phaawu. ");
INSERT INTO eko_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Khuruma olawa ofukeliwa nkalapooso ya nttunkhulu wa anamweekesela, nttumphule aafukeliweemo Yuusufu. ");
INSERT INTO eko_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Nttunkhulu wa anamweekesela khumwinkha Yuusufu atthu apale awiri yoori asala awaatthantta, yo khwiikhala siikhu za waatta nkalapooso. ");
INSERT INTO eko_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Osikhu mmote oowiri khulottha, wakhula jozi yaarina maana aya, etile ya namuupa-phaawu na ya namootela zoonywa. ");
INSERT INTO eko_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Mmeesho mwaya supu Yuusufu khulawa owaathotola, khuwaasikana ari ooshukulikha. ");
INSERT INTO eko_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Aphano ye khuwoozela annya-khaazi a Firawuuna apale aafukelaniweeyo araka: “Leelo mwakafilikhela-ni?” ");
INSERT INTO eko_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Yo khunjipu yoori: “Neetta wiiyana jozi khuhiivo ntthu wootaphulela maana aya.” Yuusufu khujipu yoori: “Ila Nluku paasi ti ye anttelaaye otaphulela jozi epo, kuuzeni jozi zaya epo.” ");
INSERT INTO eko_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Nttunkhulu wa wootela zoonywa khumuuza jozi yawe Yuusufu araka: “Kaalotthiye okiteeliye nrayi wa wuuva omaasho waka. ");
INSERT INTO eko_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Orina virapi ttatthu za waaleya na khwiima mishumo zaari ottokotthaaye miwawa-miwawa. ");
INSERT INTO eko_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Pilawuri ya Firawuuna eri mmakhono mwaka. Miiyo khuthuula mishumo za wuuva khuvinyela mpilawuri mphule kimwinkha mmakhono mwawe.” ");
INSERT INTO eko_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yuusufu khuri: “Maana a jozi yawo eto pi apa: virapi ttatthu enlupa siikhu ttatthu. ");
INSERT INTO eko_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Nkatthi wa siikhu ttatthu Firawuuna ontta wuulazamo nkalapooso orutele khaazi yawo ya wootela zoonywa za mfwalume na omwinkha pilawuri mmakhono mwawe, nkhama etthiipo waari orettakaazo raku. ");
INSERT INTO eko_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ila amana zooshi ziweettettelaka saana ohikisahawu, kinuuhirimiza yoori okoonele huruma omuuze mfwalume monkoni wa miiyo, okaawuni yoori kileemo nkalapooso mphu. ");
INSERT INTO eko_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Miiyo keetta wiiyiwa nti wa Meebereewu khutiisiwa mmuti mphu khweeseleliwa nkalapooso hatha etthu kihiretteeni.” ");
INSERT INTO eko_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Asiiliyeevo nttunkhulu wa wuupa phaawu yoori Yuusufu aataphuleliye jozi etile wooshapweyavo, ye khumuuza yoori: “Na-miyo kinaaye yaaka, kalottha kipwecheriye phaawu khelenke ttatthu. ");
INSERT INTO eko_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Khelenke eti ya vatulu zaarimo wakhula nanna ya phaawu epile zontuvela Firawuuna, ila anyannyi khusala ajoropoja ziri veeshwa vaka.” ");
INSERT INTO eko_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Aphano Yuusufu khunjipu yoori: “Jozi yawo eto maana pi apa, khelenke ttatthu epo enthoonyeza siikhu ttatthu. ");
INSERT INTO eko_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Nkatthi wa siikhu ttatthu etthiipo, Firawuuna onlawa athomeye eeshwa mmutthi, mwiili awo osala ojoropojiwa pi anyannyi.” ");
INSERT INTO eko_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Siikhu yattaatthu yaari siikhu Firawuuna aari orettaaye mwaakha, ye khujisa njampo na annya-khaazi awe ooshi, khuruma okhuweliwa apale aari nkalapooso namuupa-phaawu na namootela zoonywa. ");
INSERT INTO eko_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Namootela zoonywa khurutiseliwa khaazi yawe ya wootela na yoomwinkha pilawuri Firawuuna mmakhono mwawe. ");
INSERT INTO eko_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ila Firawuuna khunthomeya namuupa-phaawu nkhama etthiipile aalupiyeezo Yuusufu. ");
INSERT INTO eko_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Aphano namootela zoonywa otule khuhinfikhiri Yuusufu khunsahawu eperepere. ");
INSERT INTO eko_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Eviriyeevo nyaakha miwiri, Firawuuna khulottha ari nshini wa muuttho oniitthiwaaye Niilu. ");
INSERT INTO eko_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Mmuttho nttumpho zivuuwakamo mompe sapa zooneneva na zooshapweya khusala zittepula nyaani. ");
INSERT INTO eko_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Elottelanaka theenya khusala zivuuwamo mmuttho Niilu mompe sapa zootakhala za wootta, khulawa khwiiya vamote na epile zaavuuwiyeeyo omwanzo. ");
INSERT INTO eko_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Epile zootakhala za wootta khurafuna epile zooshapweya zooneneva, attaaphale Firawuuna khusisimuwa. ");
INSERT INTO eko_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Khurutela olala khulottha theenya, misaasi sapa za tiriku zooshapweya za wiitaala zaari owulaaye vanchina limote. ");
INSERT INTO eko_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Elottelanaka khoona misaasi sapa za maveya a tiriku a wuuma oolukuziwa ti pheevo ya n'yaara. ");
INSERT INTO eko_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Misaasi epile sapa za maveya khumiza epile za wiitaala na zooshapweya. Firawuuna khusisimuwa khujuwa yoori eetta olottha. ");
INSERT INTO eko_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","N'oocha mmeesho mwaya supu, nafusi yawe khwiiya yooshukulikha, khurumisa olawa okhuweliwa anamajintta ooshi na anampiya sako a Misuri. Firawuuna khuwooza jozi alotthiyeeyo, ila khuhiivo hatha ntthu mmote aajuwiiyeeyo otaphulela waya. ");
INSERT INTO eko_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Aphano namootela zoonywa khumuuza Firawuuna yoori: “Leelo kafikhiri koosa zaka. ");
INSERT INTO eko_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Siikhu moote mweephirisiweeyo pi annya-khaazi eenu mwaarumisiye ofukeliwa miiyo na nttunkhulu wa wuupa phaawu nkalapooso wa nttunkhulu wa anamweekesela. ");
INSERT INTO eko_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Osikhu mmote fweeyo awiri khulottha wakhula ntthu jozi yawe, wakhula jozi yaarina maana aya. ");
INSERT INTO eko_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ila nkalapooso nttumphule aarimo shapu mmote wa mwiibereewu aari mwiitthwaana wa nttunkhulu wa anamweekesela, fweeyo khumweeleza jozi zetthu epile ye khutaphulela. ");
INSERT INTO eko_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Khurettikhana zooshi nkhama etthiipile aanuuziyeezo: miiyo khurutiseliwa khaazi yaka, otu nkina khuheyiwa.” ");
INSERT INTO eko_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Firawuuna khuruma olawa okhuweliwa Yuusufu, khulaziwamo nkalapooso nasaapiru. Khunyoola ttevu zawe khuwala kuwo kinoko khulawaniwa wa Firawuuna. ");
INSERT INTO eko_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ye khumuuza Yuusufu yoori: “Miiyo keetta olottha jozi moote khuhipuwi hatha ntthu mmote wookitaphulela. Ila khusiila yoori weeyo amana wuuziwa jozi onwahi otaphulela maana aya.” ");
INSERT INTO eko_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ye khunjipu Firawuuna araka: “Miiyo akina owahi, ila Nnyizinku onwahi wuutaphulelani wooshapweyavo.” ");
INSERT INTO eko_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Aphano Firawuuna khusala amuuza jozi etile Yuusufu yoori: “Kalottha keemeliye nshini wa Niilu. ");
INSERT INTO eko_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Mmuttho mwaya mphule khusala zivuuwamo mompe sapa zooshapweya na zooneneva khusala zittepula nyaani nshini wa Niilu. ");
INSERT INTO eko_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Theenya khuvuuwa mompe sapa za wootta zootakhala. Nti wooshi wa Misuri akinoone mompe zootakhala nkhama epo. ");
INSERT INTO eko_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Mompe zaya etthiipile zootakhala na za wootta khumiza mompe epile zooneneva na zooshapweya, ");
INSERT INTO eko_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ila khusala zumpuwa nkhama zihijeeni etthu nalelo, khwiiya za wootta na zootakhala nkhama zaariizo. Ethiito miiyo khusisimuwa. ");
INSERT INTO eko_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Khurutela olala khulottha theenya misaasi sapa za tiriku zooshapweya za wiitaala zaari owulaaye vanchina limote. ");
INSERT INTO eko_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Elottelanaka khoona misaasi sapa za maveya a tiriku a wuuma oolukuziwa ti pheevo ya n'yaara. ");
INSERT INTO eko_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Misaasi epile sapa za maveya khumiza epile za wiitaala na zooshapweya, miiyo khuwooza anamajintta ila khuhiivo hatha mmote aawahiyeeyo otaphulela.” ");
INSERT INTO eko_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Aphano Yuusufu khumuuza Firawuuna yoori: “Jozi zenu epo z'oopiri enlupa etthu moote paasi, Nluku eetta wuuthoonyezani eti anttelaaye oretta. ");
INSERT INTO eko_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Mompe epo sapa zooshapweya zinlupa nyaakha sapa. Misaasi sapa zooshapweya na-yo zinlupa nyaakha sapa. Jozi zaya epo mooteru. ");
INSERT INTO eko_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Mompe epo sapa za wootta na zootakhala zaavuuwiyeeyo ziwelela aphale zaariivo epile zooshapweya enlupa nyaakha sapa. Misaasi epo sapa za maveya zaalukuziweeyo ti pheevo ya n'yaara, khumiza epile zooshapweya enlupa nyaakha sapa za jala. ");
INSERT INTO eko_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Mattakhuzi apa kiniwuuzaanini mfwalume, Nluku eetta wuuthoonyezani etile anttelaaye oretta. ");
INSERT INTO eko_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Nyaakha sapa tuniya ya Misuri enteela oruwera venkivene. ");
INSERT INTO eko_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ila theenya zinlawa zate nyaakha sapa za jala, oruwera opo onlawa wasahawiwe. Jala yaya eto enlawa yashintte nti aya opu. ");
INSERT INTO eko_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Khunteela ofikhireliwa oruwera opule, mwaasa wa jala enttela wiiya yootepa waatta tuniya eti ya Misuri. ");
INSERT INTO eko_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Eto mwilotthisiweeyo swaafu piiri enlupa yoori Nluku alakela na onretta woohirupazi. ");
INSERT INTO eko_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Apho mweeyo mfwalume, mwinthawule ntthu mmote woojuwa na wa akhili eeye nttunkhulu wa weettettisa tuniya eti ya Misuri. ");
INSERT INTO eko_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Mwirette etthiipo, mwiwaattheemo attunkhulu mmuti mphu asala alokotthela phantte ya thaanu za vitthu zinuuruliwaazo tuniya ya Misuri, khwa nyaakha epo sapa zooruweriwa. ");
INSERT INTO eko_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Yo ana yookusanya epile anttelaazo opattha nyaakha epo zooruwera, theenya ekusanyiwe tiriku yooshi epwehiwe yiiye mmakhono wa Firawuuna, yiiye etthu-yooja ya mmasitati. ");
INSERT INTO eko_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Vitthu-zoojiwa zaya epo zinttela orumeyeliwa nyaakha epo sapa za jala enttelaaye ota tuniya ya Misuri yoori jala eto ehishintte tuniya eti.” ");
INSERT INTO eko_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Firawuuna na mashawuriiya awe khoona yoori akhili epile za Yuusufu pi zooshapweya. ");
INSERT INTO eko_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ye khuwooza mashawuriiya awe yoori: “Naari oteela ompattha ntthu nkhama otu wa weettettisiwa ti rooho ya Nluku?” ");
INSERT INTO eko_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Firawuuna khumuuza Yuusufu araka: “Wiiya Nluku oothoonyeza vitthu epi, khaavo nkinoko aya wa akhili na woojuwa nkhama weeyo. ");
INSERT INTO eko_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Weeyo ti ye onttelaaye wiiya nttunkhulu wa vaje vaka, atthu apa ariivo ooshi nka ashututelaka mattakhuzi awo, ila nkatthi woofwalume miiyo ki nttunkhulu zayita weeyo. ");
INSERT INTO eko_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Mpakha nasaapi eti kawinkha ottunkhulu wa tuniya eti ya Misuri yooshi.” ");
INSERT INTO eko_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Aphano, Firawuuna khuvula peetthe yawe khunwalisa Yuusufu, khuruma yoori awalisiwe kuwo zooshapweya na nkufu wa thahapu mmwisiko mwawe. ");
INSERT INTO eko_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Khupakhiriwa mmwikukutta opule waphiiri, khulokoza anamalaleya alupaka yoori: “Mwinkokhorele!” Yuusufu enkhiweeyo ottunkhulu wa Misuri yooshi. ");
INSERT INTO eko_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Khulupa theenya Firawuuna amuuzaka Yuusufu yoori: “Miiyo ki Firawuuna, ila khina mmote antakhaaye oretta etthu tuniya eti ya Misuri ahaazeeni wuusikana weeyo.” ");
INSERT INTO eko_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Firawuuna khuntthaja Yuusufu nzina la Zafenathi-Paneeya. Khunlooza muukha aari wiitthiwaaye Asenaathi, mwaana wa Potifweera, nttunkhulu wa tiini ya Ooni. Aphano Yuusufu khuzukulelisiwa tuniya yaya etile yooshi ya Misuri. ");
INSERT INTO eko_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Ye azaka khaazi ya mfwalume Firawuuna aarettiye arina nyaakha talaathiini na sitha, khunleeza Firawuuna khwaaza weettetta miti zooshi za Misuri. ");
INSERT INTO eko_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Nkatthi wa nyaakha sapa epile zooruwera tuniya etile khuruweriwa tiriku ya waatta. ");
INSERT INTO eko_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yuusufu khukusanya tiriku yooshi yaaruweriweeyo khwa nyaakha sapa tuniya ya Misuri khupweha mmasitati. Wakhula mashapa apale aattameliye sitati, tiriku yaari wuuruliwaaye yaari opwehiwa ottuukho. ");
INSERT INTO eko_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yuusufu khukusanya tiriku ya waatta yahaari waalakeyaaye nkhama mishaka za mmattima, khulikha waalaka mwaasa wa waatta channu. ");
INSERT INTO eko_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ehinafiye nyaakha epile za jala, muukha wa Yuusufu Asenaathi, mwaana wa Potifweera, khuwaapattha aana awiri. ");
INSERT INTO eko_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Otu wa mwanzo Yuusufu khuntthaja nzina la Manaase, alupaka yoori: “Nluku akisahawisa ohoowa waka na vaje wa apapazaku.” ");
INSERT INTO eko_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Otu waphiiri aya khuntthaja nzina la Efwarayiimu, khulupa yoori: “Nluku akirizikhiya nti opu kihoowiyeeyo.” ");
INSERT INTO eko_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Aphano nyaakha epile sapa zooruweriwa tuniya ya Misuri khwiisha. ");
INSERT INTO eko_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Khufiya nyaakha epile sapa za jala aalupiyeeyo Yuusufu. Khupuwa jala tuniya yooshi, ila miti za Misuri zaarina etthu-yoojiwa. ");
INSERT INTO eko_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Wakathi epariziyeevo jala Misuri, atthu ooshi khunvekela Firawuuna etthu-yoojiwa. Ila ye khuwooza atthu ooshi a Misuri yoori: “Mwilawe mwakutthanane Yuusufu. Wakhula etile anttelaaye owuuzani mwirette ethiito.” ");
INSERT INTO eko_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Yuusufu nawoona yoori jala yamwazeyela tuniya yooshi khufukulela tiriku etile aapwehiiyeeyo, khusala awoozanyeza Amisuri mwaasa yoori jala etile yaashinttiye. ");
INSERT INTO eko_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Atthu a tuniya kiina aari ota Misuri oteela wuuzanya tiriku wa Yuusufu, mwaasa yoori jala yaamwazeyeliye olumwenku wooshi. ");
INSERT INTO eko_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yaakhumpa n'oojuwa yoori Misuri ewaakho etthu-yoojiwa, khuwooza aanaawe araka: “Mwineekesana yoori niini? ");
INSERT INTO eko_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Kasiila oriwa Misuri ewaakho tiriku, apho mwilawe moozanye nite nijilelane nihifwe jala.” ");
INSERT INTO eko_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Aphano khulankha attwiize Yuusufu khumi khusala alawa Misuri wuuzanya tiriku. ");
INSERT INTO eko_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yaakhumpa khunkhattaza Bejami ttwiiye Yuusufu owaalotta attwiize amoovisaka ompattha etthu yootakhala. ");
INSERT INTO eko_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Aana a Yaakhumpa khulawa wuuzanya tiriku nkhama etthiipo aari olawaazo atthu akina, maana tuniya yooshi ya Kanaani yaarina jala. ");
INSERT INTO eko_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yuusufu nttunkhulu wa Misuri, ti ye aari owoozanyezaaye tiriku atthu ooshi a mmuti. Attwiize n'oofiya khunkokhorela ajihi zaya khufiisa vathi. ");
INSERT INTO eko_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Wakathi awooniyeevo khuwaajuwa, ila khumpuwa nkhama ahiwaajuweeni. Khusala awoozela awaatuturuchaka araka: “Mweeyo! Mwinlankha vayi?” Yo khunjipu “Ninlankha tuniya ya Kanaani, naateeliye wuuzanya etthu-yoojiwa.” ");
INSERT INTO eko_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yuusufu khuwaajuwa attwiize ila yo khuhinjuwi. ");
INSERT INTO eko_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ye khupayini jozi epile aawooziyeeyo khuri: “Mweeyo mw'aahankawaani! Mwaateeliye ojuwa siiri za mmuti mwetthu mphu.” ");
INSERT INTO eko_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Yo khunjipu araka: “Wala mbwaneetthu! Fweeyo akarumeyeenu naateeliye wuuzanya etthu-yoojiwa. ");
INSERT INTO eko_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Fooshi papeetthu mmote, n'aatthu awaamineya. Khahi n'aahankawaani.” ");
INSERT INTO eko_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yuusufu khusala akhanyarela owooza yoori: “Wala mweeyo mwateela ojuwa kiphenyo za mmuti mwetthu mphu.” ");
INSERT INTO eko_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Yo khuri: “Fweeyo ninlankha tuniya ya Kanaani, niri aana khumi na awiri paapa mmote. Otu w'eefutti aya nasaapi eti asala onti na paapa, ila otu nkina aya afwa.” ");
INSERT INTO eko_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Khurutela owooza araka: “Pi etthiipo kilupiyeezo! Mweeyo mw'aahankawaani! ");
INSERT INTO eko_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Apho kintakha kiwooneni. Kinlapha khwa ohaayi wa Firawuuna, yoori khamwinlaavo apha mwihintiiseeni ttwiiyenu oto w'eefutti. ");
INSERT INTO eko_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Mwinrume ntthu mmote amweettele, ila apa akina ansalaaye anttela ofukeliwa. Noone nkhama mattakhuzi apa mwilupiyeeyo pi ookhweele. Ila mmana ehiiyi toowo kinlapha khwa ohaayi wa Firawuuna yoori phi mwinttelaavo ojuweya wiiya ahankawaani.” ");
INSERT INTO eko_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ye khuwaattha nkalapooso siikhu ttatthu. ");
INSERT INTO eko_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Siikhu yattaatthu khuwooza yoori: “Miiyo kinimoova Nluku, apho nkhama mweeyo mwintakha wuusuru nafusi zenu, mwiri toono: ");
INSERT INTO eko_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","nkhama mw'aatthu awaamineya mwinlikhe ttwiiyenu mmote nkalapooso, apa akina athuule tiriku awenkhe ajamaazenu ahifwe jala. ");
INSERT INTO eko_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Mwikitiisele ttwiiyenu oto w'eefutti kihakikhi nkhama mattakhuzi enu pi ookhweele, mwirettaru toowo khamwinuuliwa. Yo khukhupalela oretta epile ooziweezo.” ");
INSERT INTO eko_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Aphano khusala oozana yoori: “Khweele ninaaye paathuli mwaasa wa ttwiiyetthu. Maana wakathi aashankiyeevo aanivekeliye yoori nimoonele huruma ila fweeyo khuhitakhi, apha t'iiti na-fweyo anipatthiyeeyo matteso apa.” ");
INSERT INTO eko_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruubeni khujipu araka: “Miiyo akaalupiye yoori shapu oto mwihinrettele vitthu zootakhala? Ila mweeyo khuhitakhi okisiileza! Apho nina yoojipu mwaasa w'oofwa wawe.” ");
INSERT INTO eko_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yo khaari ojuwa yoori Yuusufu aari osiila epile aari ottakhulaazo, mwaasa yoori attakhulaka aarivo ntthu aari otaphulelaaye. ");
INSERT INTO eko_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yuusufu khuwaasusa vattitthiiru khusala alila. Nawiisha khurutela attaaphale khusala attakhula, aphano khunthawula Simiyooni khuruma yoori afukiwe eettaka omoona. ");
INSERT INTO eko_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Elottelanaka Yuusufu khuwaaruma anakhaazi awe wiitaaza tiriku visurupa za attwiize na owaarutisela nzurukhu aya sirini atthaaka mvisurupa nttumpho, na owenkha etthu-yooja ntarikhi. Khurettiwa etthiipo. ");
INSERT INTO eko_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Khuthuula visurupa epile wakhula ntthu khuttha vapuuru vawe khusala alawa. ");
INSERT INTO eko_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","N'oofiya vahali aalaliyeevo, mmote khufukula esurupa yawe yoori alazemo etthu-yoojiwa enkhe puuru yawe, khusikana nzurukhu awe ori mwiisurupa nttumphule. ");
INSERT INTO eko_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Khuwooza attwiize yoori: “Moone! Nzurukhu aka karutiseliwa, opu ori mphu!” Aphano yo khusuthuwa khusala athukumela na woova oozelanaka yoori: “Niini epi Nluku aniretteliyeezo?” ");
INSERT INTO eko_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","N'oofiya wapapaaya Yaakhumpa tuniya ya Kanaani, khusala amuuza zooshi za waavireliyeezo araka: ");
INSERT INTO eko_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Nttunkhulu wa Misuri eetta onituturucha anuuzaka yoori n'aahankawaani. ");
INSERT INTO eko_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ila fweeyo khujipu yoori: ‘Khahi n'aahankawaani n'aatthu awaamineya. ");
INSERT INTO eko_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Niri khumi na awiri paapa mmote, mmote afwa, nkina aya w'eefutti asala onti na paapa tuniya ya Kanaani.’ ");
INSERT INTO eko_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Aphano nttunkhulu wa nti aya opule khunuuza yoori: ‘Mwinlikhe ttwiiyenu mmote attaapha, toowo phi kinttelaavo ojuwa yoori mweeyo mw'aatthu awaamineya: mwithuule etthu-yoojiwa mwilawe mwawenkhe ajamaazenu ahifwe jala. ");
INSERT INTO eko_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Mwitaaka mwintiise ttwiiyenu otu w'eefutti aya, kaamini yoori mweeyo khahi mw'aahankawaani ila mw'aatthu awaamineya. Ttwiiyenu kintta wuurutiselani, kiwinkheni ejaaza yooretta zanshara zenu mmuti mphu.’” ");
INSERT INTO eko_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Wakathi afukuliyeevo visurupa zaya, wakhula esurupa khusikanamo mfukho wa nzurukhu, yo na papaaya nawoona nzurukhu opule khusala oova. ");
INSERT INTO eko_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Aphano papaaya khulupa yoori: “Mweeyo! Mwintakha okiishisela aanaaka. Yuusufu ti otule aashikhiyeeyo, Simiyooni khaavo apha na Bejami mwintakha onthuula theenya! Zooshi epo othunku aya ti miyo kinoonaaye.” ");
INSERT INTO eko_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruubeni khumuuza papaawe yoori: “Mwikinkhe miiyo khanaashikha kininrutisa, amana kihinrutisi mwiwoole aanaaka apale awiri.” ");
INSERT INTO eko_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yaakhumpa khujipu araka: “Akinintakhisa Bejami olawa na-mweyo, Yuusufu afwa, ye ti asaliyeeyo. Amana empattha etthu yootakhala ntarikhi okho mwineettaawo, mwintta okishukhelisa aahera na pwi zaka kirina huzuni yoototheliwa ti mweyo.” ");
INSERT INTO eko_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Jala etile yeetta otepa yaattaka mmuti. ");
INSERT INTO eko_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","N'ooweeshela tiriku etile aalaziyeeyo Misuri, papaaya khuwooza yoori: “Mwirutele theenya Misuri moozanye etthu-yoojiwa.” ");
INSERT INTO eko_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ila Yuuda khujipu araka: “Kiniwuuzani khweele, nttunkhulu wa Misuri anihirimiza channu yoori nihirutelewo nihinlawaneeni ttwiiyetthu otu w'eefutti. ");
INSERT INTO eko_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Amana mwinlikha ttwiiyetthu olawa na-fweyo, ninlawa noozanye etthu-yooja yenu. ");
INSERT INTO eko_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ila amana mwihininkhi khaninlawa, maana nttunkhulu oto anuuza yoori amana nihinlawani ttwiiyetthu nihirutelewo.” ");
INSERT INTO eko_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ezirayeele khuwoozela: “Mwamuuzela-ni yoori mwinaaye ttwiiyenu nkina? Mwakitothela pala khuluyeene.” ");
INSERT INTO eko_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Yo khujipu araka: “Mwiinyi oto eetta onuuzela yoori anijuwe fweeyo na ajamaazetthu. Khuvira anuuzelaka theenya yoori: ‘Papeenu ori haayi? Mwinaaye ttwiiyenu nkina theenya?’ Fweeyo naarina yoojipu epile aari onuuzelaazo. Fweeyo naajuwiye yoori onttela oniila onlawana ttwiiyetthu?” ");
INSERT INTO eko_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Aphano Yuuda khumuuza papaawe yoori: “Mwinlikhe shapu otu kilawena miiyo nasaapi ethiiti, nihifwe jala fweeyo na-mweyo na aaneetthu. ");
INSERT INTO eko_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mwikikhupali miiyo, kinjaahiti omwiinanela na ontthantta. Amana kihinrutisi ari nkumi, kiniiyana paathuli ohaayi aka wooshi mmakhono mwenu mweeyo. ");
INSERT INTO eko_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Eriwaka khanaarupaziye nka nilawiye niruteliyewo swaafu yaphiiri.” ");
INSERT INTO eko_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Aphano Ezirayeele, papaaya khuwooza yoori: “Nkhama pi etthiipo khina nanna kiina. Mwithuule vitthu zooshapweya za mmuti mphu, waaza paalasamu, asali, viluko, mafuttha oonukhela, na vitthu kiina nkhama amentowa, mwilawe mwamwinkhe mwiinyi oto. ");
INSERT INTO eko_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Mwithuule nzurukhu wa feeta swaafu piiri na opu mwisikaniyeeyo mvisurupa mwenu mwilawane, khinjuweya eettiye ovonyela. ");
INSERT INTO eko_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Mwinthuule ttwiiyenu mwilawe mwakutthanane mwiinyi oto. ");
INSERT INTO eko_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Nluku Woowahi Wooshi amwinkhe wiiyana huruma na-mweyo, yoori oorutiseleni ttwiiyenu otu nkina na anlikhe Bejami ate. Maana, amana miiyo akaashikha aanaaka kinsala etthiipo woohiina mwaana.” ");
INSERT INTO eko_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Yo khuthuula vitthu epile enkhiweezo na nzurukhu vamote na Bejami khusala alawa Misuri wa Yuusufu. ");
INSERT INTO eko_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yuusufu n'oomoona Bejami ari vamote na attwiize khumuuza karumeyaawe nwulu yoori: “Owaathuule atthu apa owaalawane owaka, yashijiwe nyama yiipikhiwe, yo anttela oja na-miyo nthana opu.” ");
INSERT INTO eko_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ye khuretta etthiipile ooziweezo, khuwaathuula atthu apale khuwaalawana owawe Yuusufu. ");
INSERT INTO eko_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Yo n'oofiya owawe Yuusufu khusala oova oopuwelaka yoori: “Talili natiiseliwavo mwaasa wa nzurukhu opule naarutiseliweeyo swaafu etile yamwanzo mvisurupa mwetthu. Ye ontakha onihukhumu, aniphuke anirette wiiya amwiitthwaana zawe, aninyakanye apuuru etthu.” ");
INSERT INTO eko_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Khumweettela karumeya w'oowawe Yuusufu yoori anttakhulane vanlako. ");
INSERT INTO eko_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Khulupaza yoori: “Safwatali mbwaneetthu! Swaafu etile naatiiyeeyo apha yamwanzo naateeliye wuuzanya etthu-yoojiwa. ");
INSERT INTO eko_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ila n'oofiya vahali naalaliyeevo, naafukuliye visurupa zetthu wakhula mmote wa fweyo khusikanamo omilomo waya nzurukhu opule naateeliyeeyo wuuzanyela etthu-yoojiwa ori woolikana. Apha, naateeliye orutisa, ");
INSERT INTO eko_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","na theenya natana nzurukhu nkinoko yoori nuuzanyele etthu-yoojiwa. Khaninjuweeni nlupa aatthiiyeemo nzurukhu aya opu mvisurupa mwetthu.” ");
INSERT INTO eko_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Aphano karumeya otule khujipu araka: “Mwihoove na wala mwihisuthuwe. Nluku otu weenu mweeyo na otu wa papeenu ti ye atthiiyeemo nzurukhu mvisurupa mwenu, ila miiyo kaapokhereliye nzurukhu opule mwaataniyeeyo.” Karumeya khumfukulela Simiyooni khuntiisa attaaphale aariivo attwiize. ");
INSERT INTO eko_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Nawiisha khuwaathuula khuwaavirisa nnyupa wa Yuusufu, khuwenkha maati khoosa moolu aya na khwinkha etthu-yoojiwa apuuru aya. ");
INSERT INTO eko_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Attwiize Yuusufu khwaattalela tthuvo epile aataniyeezo khusala anwejela, maana aajuwiye yoori nthana aari oteela oja vamote na-ye. ");
INSERT INTO eko_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Wakathi Yuusufu afiiyeevo owawe, yo khweettela tthuvo epile aatiisiyeezo khumwinkha khukokhoraza omaasho wawe khufiisa ajihi zaya vathi. ");
INSERT INTO eko_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ye khuwenkha hapari, nawiisha khuwoozela yoori: “Papeenu otule mwaakuuziyeeyo nalelo ori haayi?” Owaakho nkumi? ");
INSERT INTO eko_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Yo khunjipu yoori: “Karumeyeenu papeetthu ori haayi, owaakho nkumi.” Yo khukokhora khwiinama. ");
INSERT INTO eko_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ye khulansa maasho awe khumoona ttwiiye Bejami mwaana wa mamaawe. Khuwoozela yoori: “Ttwiiyenu otu mwaari onlupaaye w'eefutti ti othuutu?” Ye khumuuza Bejami yoori: “Nluku awinkhe rehema mwanaka!” ");
INSERT INTO eko_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yuusufu khwiiyana furaha khuluyeene mwaasa wa ttwiiye, khusala atakha olila, nasaapiru khulaavo khweetta okatthi wawe khusala alila. ");
INSERT INTO eko_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Nawiisha, khufuushula khurutela vansana ari woojiitthaaza khulupa yoori: “Mwininkhe etthu-yoojiwa.” ");
INSERT INTO eko_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Khusaruliwa etthu-yoojiwa meeza mattatthu, mamote a Yuusufu, makina a attwiize na makina a Amisuri aari ottuukho. Mwaasa yoori yaari haraamu atthu a Misuri oja na Meebereewu. ");
INSERT INTO eko_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Attwiize Yuusufu khwiikhala vameeza kharipu na-ye, khuthataanya waaza nttunkhulu mpakha efutti, khusala eekesana mmote na nzaawe ari ooshanka. ");
INSERT INTO eko_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yuusufu khuruma winkhiwa etthu-yoojiwa ethiitile enkhiweeyo vameeza vawe, sahani ya Bejami khuziti swaafu thaanu sahani za attwiize. Yo khuja, khunywa, khufurahi vamote na Yuusufu. ");
INSERT INTO eko_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yuusufu khunruma karumeya nwulu wa vaje vawe yoori: “Wiitaaze saaneene etthu-yoojiwa visurupa za atthu apa anwahaaye othuula, ottheemo nzurukhu aya omilomo wa visurupa zaya. ");
INSERT INTO eko_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Nawiisha, othuule pilawuri yaka ya feeta otthe omilomo w'eesurupa y'ootu w'eefutti aya na nzurukhu aya opo atiisiyeeyo wuuzanyela tiriku.” Karumeya otule khuretta etthiipo ooziweezo ti Yuusufu. ");
INSERT INTO eko_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Mmeesho mwaya supuyeene, attwiize Yuusufu khunleeza khuthuula apuuru aya khusala alawa. ");
INSERT INTO eko_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","N'oolaazamo nsitati mphule ahinafiyaze peetiwene, Yuusufu khunruma karumeyaawe yoori: “Olankhe nasaapi apha owaatthirele atthu apale eettiye aphale, amana owaasikana wa woozele yoori: Oretteliwa vitthu zooshapweya mweeyo mwinripha zootakhala? ");
INSERT INTO eko_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Mweeyela-ni pilawuri ya mbwanaaka? Khahiyo ethiito annywelakaaye na anjuwanaaye vitthu zoorettikhana? Mweeyo mwaretta vitthu zootepa otakhala.” ");
INSERT INTO eko_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ye khuwaatthirela mpakha owaasikana khuwooza etthiipile ooziweezo ti Yuusufu. ");
INSERT INTO eko_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Yo khujipu araka: “Mwaasa aya niini mbwaneetthu alupaka toowo? Fweeyo akarumeyaawe khaninwahi oretta vitthu zaya epo! ");
INSERT INTO eko_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Onuupuwela yoori fweeyo nawahi orutisa nzurukhu Kanaani naasikaniyeeyo omilomo wa visurupa zetthu? Toowo n'aatthu ninwahaaye wiiya feeta ama thahapu ya vaje wa mbwanaawo? ");
INSERT INTO eko_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Apha niriivo, karumeya otule onttelaaye onsikanana pilawuri eto afwe. Fweeyo ninttela osala niri amwiitthwaana za mbwaneetthu.” ");
INSERT INTO eko_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ye khuri: “Kakhupali epo mwilupiyeezo, ila othuuto kinttelaaye onsikanana ti ye anttelaaye wiiya mwiitthwaana aka, mweeyo khamwiniiyana hatha koosa.” ");
INSERT INTO eko_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Wakhula ntthu khupakhula esurupa yawe khupweha vathi khufukula nasaapiru. ");
INSERT INTO eko_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Karumeya otule khwaaza weekesa mwiisurupa y'ootu nwulu khwiishela esurupa y'ootu w'eefutti aya. Attaaphale khusikana pilawuri etile mwiisurupa ya Bejami. ");
INSERT INTO eko_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","N'ooretta toole, khuvarula kuwo zaya, khupakhira opheya visurupa zaya vapuuru khusala arutela ositati ottuukhule. ");
INSERT INTO eko_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yuuda na attwiize n'oofiya owawe Yuusufu khunsikana ye ari ottuukho, khukokhora khwiinama attaaphale aariivo Yuusufu. ");
INSERT INTO eko_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yuusufu khuwoozela yoori: “Mwarettela-ni etthu eti? Mweeyo khamwinjuwa yoori ntthu nkhama miiyo kinwahi woona vitthu nkhama epo?” ");
INSERT INTO eko_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuuda khujipu araka: “Niwuuze niini mbwanaaka! Apho nijihakikhi toovi? Nluku avithula twampi zetthu. Aphano n'aamwiitthwaana za mbwaneetthu nkhama otule asikananiweeyo pilawuri.” ");
INSERT INTO eko_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yuusufu khulupa yoori: “Miiyo akinwahi oretta etthu aya eto! Othuuto asikananiweeyo pilawuri yaka ti ye anttelaaye wiiya mwiitthwaana aka, mweeyo mwirutele wapapeenu na heeri.” ");
INSERT INTO eko_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yuuda khunsusela Yuusufu khumuuza yoori: “Safwatali mbwanaaka! Mwinlikhe karumeyeenu awuuzeni nttakhuzi na mwihinkatipukhele, mwaasa yoori mweeyo mwiri nkhama Firawuuna mwennyeweene. ");
INSERT INTO eko_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mbwanaaka mwaawoozeliye akarumeyeenu mwiraka: ‘Mwinaaye papeenu na ttwiiyenu?’ ");
INSERT INTO eko_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Fweeyo khujipu yoori: ‘Ninaaye paapa ila ooluvala na ninaaye ttwiiyetthu w'eefutti apattikhaniyeeyo paapa ooluvaliye. Aarina ttwiiye afwa, ye asala otthwe wuumamani wawe, ti woophetiwa na kuvu ti papaawe.’ ");
INSERT INTO eko_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Mweeyo mwaawaarumiye akarumeyeenu yoori antiise mwite mwimoone khwa maasho enu. ");
INSERT INTO eko_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ila fweeyo khuujipuni mweeyo mbwanaaka: ‘Mwaana oto khanwahi olikhiwa ti papaawe. Amana ampwetheya, papantthu ontta ofwa.’ ");
INSERT INTO eko_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ila mweeyo khunuuza yoori: ‘Amana mweeyo mwihintiisi mwihirutelevo vaje vaka apha.’ ");
INSERT INTO eko_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","N'oofiya onti, fweeyo khumuuza papeetthu mattakhuzi apale mwaanuuziyeeyo mbwaneetthu. ");
INSERT INTO eko_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Nawiisha ye khuniruma yoori mwirutelewo mwilawe moozanye etthu-yoojiwa. ");
INSERT INTO eko_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Fweeyo khumuuza yoori: ‘Khaninwahi orutelawo nihilawaneeni ttwiiyetthu otu wa w'eefutti, amana nihilawani khaninlawa okutthanana mwiinyi oto.’ ");
INSERT INTO eko_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Karumeyeenu papeetthu khunuuza yoori: ‘Mweeyo mwinjuwa yoori muukhaaka akipatthela aana awiri, ");
INSERT INTO eko_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","otu mmote akaashikha mpakha leelo eti akinamoone. Kakhupali yoori ooliwa ti nyama ya ntthuttu khunrafuna. ");
INSERT INTO eko_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Amana mwinlazavo otu n'ompattha etthu yootakhala, mwintta okiishukhelisa aahera na pwi zaka kirina huzuni yoototheliwa ti mweyo.’ ");
INSERT INTO eko_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Aphano amana nirutela onti ninlikha ye, nintta omuulaana huzuni papeetthu, mwaasa yoori mwanawe animphetachaaye. Akarumeyeenu anttela ompatthisa papaaya wiishukhela aahera na pwi zawe arina huzuni. ");
INSERT INTO eko_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Olikha eto, miiyo kamwaahiti paapa yoori kininrutisa, amana kihinrutisi kookosani ohaayi aka wooshi. ");
INSERT INTO eko_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Apho kinuuvekela yoori safwatali, miiyo kintta osala kiri mwiitthwaaneenu mbwanaaka zwaamu ya shapu otu, mwinlikhe ye arutele onti na attwiize. ");
INSERT INTO eko_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Toowo kinttela orutela toovi wapaapa woohilawani shapu otu? Miiyo akinwahi woona ari mmatteso paapa.” ");
INSERT INTO eko_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Nawiisha Yuuda ottakhula, Yuusufu khusala oojeela ojilipisela. Khuwooza akarumeyaawe ooshi olaavo, khuhiivo hatha ntthu ajijuwisaka attwiize. ");
INSERT INTO eko_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ye khusala alila anyakulaka mpakha khufiyelela osiila Amisuri, hapari epile khufiya wamfwalume Firawuuna. ");
INSERT INTO eko_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ye khuwooza attwiize yoori: “Miiyo ki Yuusufu! Nkahayani, paapa ori haayi?” Attwiize khuhisala awahi onjipu mwaasa yoori aari ooshanka channu. ");
INSERT INTO eko_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Khuwooza attwiize yoori: “Mwisusele apha kiriivo.” Yo khunsusela khuwooza yoori: “Miiyo ki Yuusufu, otule mwaamuuzanyisiyeeyo khutaniwa Misuri. ");
INSERT INTO eko_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Apho mwihishanke wala mwihishowerane mwaasa wookuuzanyisa khutaniwa okhuno. Ila Nluku eettiye okilokozisa yoori muusuru nafusi zenu. ");
INSERT INTO eko_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Zavira nyaakha miwiri za jala mmamiti mphule ila zasala theenya nyaakha mithaanu atthu ahinteelaaye olima wala wuurula. ");
INSERT INTO eko_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Nluku akiperekha vakatthi venu mweeyo yoori kuusuru ohaayi eenu muulumwenku mphu na apa anttelaaye ovokoliwa. ");
INSERT INTO eko_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Khahiyo mweeyo mwikiperekhiye okhuno, ila Nluku ti ye akiperekhiye, khukiretta wiiya nkhama paapa wa Firawuuna, na nttunkhulu wa vaje vawe na tuniya ya Misuri. ");
INSERT INTO eko_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Mwaakuve mwirutele wapaapa mwamuuze yoori: Mwanenu Yuusufu alupa yoori: Nluku akinkha ottunkhulu wa Misuri yooshi. Ate okhuno, ahirupaze! ");
INSERT INTO eko_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Mwite mwiikhale nti wa Gosheni kharipu na-miyo, mweeyo na atuulwenu, aaneenu, pwittipwitthi zenu, mompe zenu, na vitthu zenu zooshi mwiriinaazo. ");
INSERT INTO eko_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ottuukho kisala kiwinkhani etile enuuhithajiyaanini, mweeyo na vaje venu na zooshi mwiriinaazo yoori mwihihoowe, maana zasala nyaakha epi mithaanu za jala. ");
INSERT INTO eko_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Mweeyo mwinikoona na maasho enu, na ttwiiyaku Bejami onikoona, yoori khweele ti miyo kinlupaaye mattakhuzi apa. ");
INSERT INTO eko_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mwilawe mwamuuze paapa owahi kiriina Misuri na zooshi epile mooniyeezo. Apho mwaakuve mwilawe mwantiise ottuukhuno.” ");
INSERT INTO eko_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yuusufu khumpatikha ttwiiye Bejami khusala alila, na-ye Bejami khumpatikha khusala alila. ");
INSERT INTO eko_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Nawiisha khuwaapejari attwiize ooshi khusala alila. Attaapho attwiize phi awahiyeevo ottakhula na-ye. ");
INSERT INTO eko_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Hapari epile khumfiyela Firawuuna, yoori attwiize Yuusufu ata. Firawuuna n'oosiila khwiiya wootuveliwa vamote na akarumeyaawe. ");
INSERT INTO eko_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Aphano Firawuuna khumuuza Yuusufu yoori: “Owooze attwiizo: Athuule nyama zaya arutele tuniya ya Kanaani. ");
INSERT INTO eko_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Amweettele papeenu na ajamaazenu ooshi ate okhuno. Miiyo kintta owenkha puuro swaafi mmuti mphu, yoori asala aja vitthu zootuva zinruweriwaaye nttumphu. ");
INSERT INTO eko_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Athuule mikukutta za Misuri ethiiti aweettele aanaaya, aakhaaya na papeenu. ");
INSERT INTO eko_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Mwihiiyane hatha shaakha na mali zenu zooshi mwiriinaazo, maana vitthu zooshapweya za tuniya yooshi ya Misuri zinttela wiiya zeenu.” ");
INSERT INTO eko_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Aana a Yaakhumpa khuretta etthiipile. Yuusufu khuwenkha mikukutta nkhama etthiipile aalupiyeezo Firawuuna, khuwenkha vitthu-zooja ntarikhi alawaka. ");
INSERT INTO eko_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Wakhula ntthu khumwinkha kuwo pheeya ila Bejami khumwinkha miiya ttatthu za nzurukhu wa feeta na kuwo thaanu pheeya. ");
INSERT INTO eko_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Khuperekha apuuru khumi zipakhiriye vitthu zaariiwo Misuri zootuva yoori alawe enkhiwe papaawe, khuperekha theenya apuuru khumi zipakhiriye tiriku na phaawu na vitthu kiina za akhipa yoori asala aja ntarikhi. ");
INSERT INTO eko_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Nawiisha, khuleezana na attwiize yo khulankha khusala alawa, ye khuwooza yoori: “Mwihishowerane ntarikhi.” ");
INSERT INTO eko_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Yo khulankha Misuri khusala alawa Kanaani wa papaaya Yaakhumpa. ");
INSERT INTO eko_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","N'oofiya khumuuza papaaya yoori: “Yuusufu nalelo ori haayi, nttunkhulu wa Misuri yooshi!” Yaakhumpa n'oosiila khuzileya mwaasa woohaamini. ");
INSERT INTO eko_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ila nawuuziwa mattakhuzi apale aalupiyeeyo Yuusufu, na khoona mikukutta epile aaperekhiyeezo yoori zilawe zanthuule papaawe, rooho yawe khutamo. ");
INSERT INTO eko_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Yaakhumpa khulupa yoori: “Mwanaka ori haayi! Kintta olawa kamoone kihinafwe.” ");
INSERT INTO eko_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ezirayeele khuthuula vitthu zawe zooshi aariinaazo, khulawa mpakha Beresheba. N'oofiya okhule, khuretta twaha anrettelaka Nluku aari omwaaputwaaye papaawe, Esiyaakha. ");
INSERT INTO eko_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Nluku anteeliye Ezirayeele osikhu nkatthi wa jozi khusala ankhuwela araka: “Yaakhumpa! Yaakhumpa!” Ye khujipu yoori: “Lapeekha!” ");
INSERT INTO eko_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ye khuri: “Miiyo ki Nluku, Nluku wa papaawo. Ohoove olawa tuniya ya Misuri, maana khwa weyo kinttela opuwisa khapila khuluyeene. ");
INSERT INTO eko_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Miiyo kinlawa vamote na-weyo Misuri na kinlawa koorutisele mmuti nttumphu. Amana ofwa Yuusufu ti ye anttelaaye ophulula maasho awo.” ");
INSERT INTO eko_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Aphano, Yaakhumpa khulankha nti wa Beresheba na aanaawe na aakhaaya na aanaaya khupakhira mmikukutta epile zaaperekhiweeyo ti Firawuuna. ");
INSERT INTO eko_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Khuthuula maphanko a nyama, na mali zaya zooshi epile aapatthiyeeyo tuniya ya Kanaani, Yaakhumpa khusala alawa Misuri na ajamaaze ooshi. ");
INSERT INTO eko_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Aanaawe aalume na aanaaya, aanaawe aakha na-yo na aanaaya, ajamaaze ooshi khuwaathuula khusala alawa Misuri. ");
INSERT INTO eko_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Apa mazina a meezirayeele, Yaakhumpa na ajamaaze aalawaniyeeyo Misuri: Ruubeni, mwaana wamwanzo wa Yaakhumpa. ");
INSERT INTO eko_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Aana a Ruubeni pi apa: Enookhi, Phaalu, Hezorooni na Khariimu. ");
INSERT INTO eko_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Aana a Simiyooni pi apa: Yemuweeli, Yamiini, Ohaati, Yakhini, Sohaari na Shawuuli mwaana wa nunu mmote wa Kanaani. ");
INSERT INTO eko_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Aana a Leevi pi apa: Geerishoni, Kohaathi na Meraari. ");
INSERT INTO eko_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Aana a Yuuda pi apa: Eeri, Onaani, Sheela, Pereezi na Zeera. Eeri na Onaani afwa tuniya ya Kanaani. Aana a Pereezi pi apa: Hezorooni na Hamuuli. ");
INSERT INTO eko_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Aana a Ezakaari pi apa: Toola, Phuuva, Yashuubu na Shimrooni. ");
INSERT INTO eko_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Aana a Zabulooni pi apa: Seredi, Elooni, na Yaleeli. ");
INSERT INTO eko_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Apa atuulu na aana a Yaakhumpa aawaavokoliyeeyo na Liiya nti wa Paata-Araamu, ohintthiimo mwanawe Tiina. Ooshi aari talaathiini na attatthu. ");
INSERT INTO eko_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Aana a Gaadi pi apa: Sefiyooni, Haaki, Shuuni, Esbooni, Eeri, Aroodi na Areeli. ");
INSERT INTO eko_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aana a Asheeri pi apa: Imunna, Eshwiiva, Eshwiivi, Beriiya na ttwiiye Zeera. Aana a Beriiya pi apa; Hepeere na Malikiyeeli. ");
INSERT INTO eko_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Apa aana a Yaakhumpa na Ziilipa, karumeya otule Labani aamwinkhiyeeyo mwanawe Liiya. Ooshi aari khumi na sitha. ");
INSERT INTO eko_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Aana a Rakeele muukha wa Yaakhumpa aari apa: Yuusufu, na Bejami. ");
INSERT INTO eko_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Asenaathi mwaana wa Potifweera, nttunkhulu wa tiini ya Ooni aavokoleliwe aana awiri ti Yuusufu tuniya ya Misuri, Manaase na Efwarayiimu. ");
INSERT INTO eko_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Aana a Bejami pi apa: Beela, Beekheri, Ashibeeli, Geera, Naamani, Eehi, Rooshi, Muupimu, Huupimu na Haridi. ");
INSERT INTO eko_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Apa aana a Rakeele aavokoleliweeyo ti Yaakhumpa, ooshi aari khumi na wane. ");
INSERT INTO eko_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Mwaana wa Daani aari Hushimu. ");
INSERT INTO eko_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Aana a Nafitaali pi apa: Yaseeli, Kuuni Yeseeri, na Shileemu. ");
INSERT INTO eko_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Apa aana a Yaakhumpa na Biila, karumeya otule Labani aamwinkhiyeeyo mwanawe Rakeele. Ooshi aari sapa. ");
INSERT INTO eko_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Atthu ooshi apale aalawaniyeeyo Yaakhumpa Misuri aari ajamaaze, ohiwaatthiimo aakha a aanaawe, aari siithiini na sitha atthweene. ");
INSERT INTO eko_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Owaatthaamo aana a Yuusufu aavokoliweeyo tuniya ya Misuri, ojama wooshi wa Yaakhumpa waari wa atthu saapiini. ");
INSERT INTO eko_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Aphano Yaakhumpa khunlokozisa Yuuda wa Yuusufu, yoori alawe amuuze anthepeeze nti wa Gosheeni. Afiiyeevo nti wa Gosheeni, ");
INSERT INTO eko_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yuusufu khuthuula nkukutta awe khusala alawa okutthana na papaawe, Ezirayeele. N'oomoona khuntthirela khulawa khumpatikha, khuvira wakathi wa waatta eettaka olila. ");
INSERT INTO eko_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Yaakhumpa khumuuza Yuusufu yoori: “Aphano kiwooniyeevo yoori ori haayi, kimfwa kihina shaakha.” ");
INSERT INTO eko_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yuusufu khuwooza attwiize na ajaama a papaawe yoori: “Kintta wa Firawuuna kamuuze yoori attwiizaku na ajamaaze paapa apa aari wiikhalaaye tuniya ya Kanaani, ata mmuti mphu. ");
INSERT INTO eko_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Kinttela omuuza yoori yo amakhampuzi, ataaka atiisa nyama zaya, pwittipwitthi, mompe na vitthu zaya zooshi ariinaazo. ");
INSERT INTO eko_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Amana Firawuuna arumisa oteela okhuweliwa mweeyo, na awuuzelani yoori ‘Mwinkhola khaazi-ni?’ ");
INSERT INTO eko_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Mwinjipu yoori: ‘Fweeyo akarumeyaawo khaazi yetthu oshukisa nyama, waaza osimaana etthu mpakha apha, nkhama etthiipo aari orettaazo apapazetthu.’ Toowo, mwintta okhupaleliwa wiikhala nti wa Gosheeni, mwaasa yoori amakhampuzi ooshi pi ootarawiwa pi a Misuri.” ");
INSERT INTO eko_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yuusufu khulankha olawa omuuza Firawuuna yoori: “Paapa na attwiizaku ata ari nti wa Gosheeni, atana maphanko a nyama, mompe, pwittipwitthi na vitthu zaya zooshi ariinaazo.” ");
INSERT INTO eko_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Khuwaathuula attwiize athaanu olawa owaajuwisa Firawuuna. ");
INSERT INTO eko_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Aphano Firawuuna khuwoozela attwiize Yuusufu araka: “Mwinkhola khaazi-ni?” Yo khunjipu yoori: “Mbwaneetthu, fweeyo khaazi yetthu oshukisa nyama nkhama apapazetthu apa aviriyeeyo. ");
INSERT INTO eko_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Fweeyo nateela wiikhala mmuti mphu siikhu vattitthiiru, mwaasa yoori tuniya ya Kanaani yeetta opuwawo jala ya waatta nyama zetthu khuhisala ziiyana etthu-yooja. Safwatali wa safwatali, mwinilikhe niikhale nti opu wa Gosheeni.” ");
INSERT INTO eko_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Aphano Firawuuna khulupa yoori: “Papaawo na attwiizo ata wiiya vamote na-weyo. ");
INSERT INTO eko_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Tuniya ya Misuri eri mmakhono mwawo. Apho, papaawo na attwiizo owenkhe Gosheeni ti yiiyiye phantte yooshapweya ya mmuti mphu, eekhale ottuukho. Na amana woona yoori vakatthi wa ajamaazo awaapho atthu ariina akhili, owenkhe ottunkhulu wa mompe zaka.” ");
INSERT INTO eko_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yuusufu khunthuula papaawe Yaakhumpa khulawa onjuwisa Firawuuna, Yaakhumpa khumparikhiya. ");
INSERT INTO eko_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Firawuuna khumuuzela Yaakhumpa araka: “Mwina nyaakha mikavi?” ");
INSERT INTO eko_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yaakhumpa khunjipu araka: “Kinaaye nyaakha miiya na talaathiini, keettaka osaafiri kijeettettelaka. Nyaakha epi kivirisiyeeyo vattitthiiru na pi zootakhala, mpakha apha akinafiye nyaakha epile eekhaliyeezo amarehemu apapazaku.” ");
INSERT INTO eko_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Aphano Yaakhumpa khumparikhiya Firawuuna, nawiisha khuruti. ");
INSERT INTO eko_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yuusufu khumwinkha meekhazi papaawe na attwiize phantte yooshapweya ya tuniya ya Misuri waattamana na nti wa Ramesesi, nkhama etthiipile Firawuuna aalupiyeezo. ");
INSERT INTO eko_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ye khumwinkha papaawe na attwiize na ajamaaze ooshi etthu-yooja, yowaafiyela wakhula ntthu na aanaawe. ");
INSERT INTO eko_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Khuthowa etthu-yooja tuniya ya Misuri mpakha Kanaani yooshi. Atthu khusala akureya mwaasa wa jala waatta. ");
INSERT INTO eko_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Aphano Yuusufu khukusanya nzurukhu wooshi, opule waari orumeeliwaaye Misuri na wa Kanaani opule waari wuuzanyeliwaaye tiriku, khulawa khupweha owawe Firawuuna. ");
INSERT INTO eko_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Wakathi wiishiyeevo nzurukhu wa Kanaani na Misuri, khulankha Amisuri khulawa onvekhela Yuusufu araka: “Safwatali, oninkhe etthu-yooja nihifwe onoonaka mwaasa woohiina nzurukhu.” ");
INSERT INTO eko_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yuusufu khujipu araka: “Nkhama mweeyo khamwina nzurukhu, mwikitiisele nyama zenu nipatili na etthu-yooja.” ");
INSERT INTO eko_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Amisuri khuthuula pwittipwitthi zaya, mompe, khavalo, na apuuru aya, khulawa khumwinkha Yuusufu, ye khuwenkha etthu-yooja aari weettelaaye oja mwaakha wooshi. ");
INSERT INTO eko_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mwaakha aya opule khwiisha, mwaakha nkina khurutelawo wa Yuusufu olawa omuuza yoori: “Mbwaneetthu khaninoona etthu yoovitha, nzurukhu etthu waniishela, nyama zetthu p'iipile niwinkhiyeenini. Khanisalaneeni hatha etthu, nasalana mwiili etthu na mashapa etthu paasi. ");
INSERT INTO eko_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ohinilikhe nifwaka na mashapa etthu apwecheyaka weettaka woona. Wuuzanye mashapa etthu na-fweyo aya, oninkhe etthu-yooja. Toowo niniiya amwiitthwaana za Firawuuna na mashapa eetthu anttela wiiya awe. Oninkhe peewu yoozala yoori nipatthe wiiyana meekhazi, nihifwe jala na nti etthu ohiiye yaara.” ");
INSERT INTO eko_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Khwa nanna ethiito Yuusufu khuuzanya mashapa ooshi a Misuri khwiiya a Firawuuna. Amisuri ooshi aarina yawuuzanyisa mashapa aya mwaasa wa jala yeetta otepa yaattaka, nti wooshi khwiiya wa Firawuuna. ");
INSERT INTO eko_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yuusufu khuwaaretta omwiitthwaana atthu ooshi a phantte yooshi ya Misuri. ");
INSERT INTO eko_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ila mashapa a attunkhulu a tiini khoozanyiye mwaasa yoori yo aari winkhiwa etthu-yooja ti Firawuuna, ti etthu ahoozanyiseliyeeyo mashapa aya. ");
INSERT INTO eko_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Aphano Yuusufu khuwooza atthu yoori: “Mwikisiileze! Kawuuzanyani mweeyo na miti zenu zooshi. Waaza leelo mweeyo na mashapa enu anttela wiiya a Firawuuna. Peewu eti mwilawe mwazale. ");
INSERT INTO eko_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Wakhula etile mwinttelaaye oruwera mwisala mwithuula lifunku la thaanu mwimwinkha Firawuuna. Mafunku apa mane mwinsalanaaye mwisala mwija mweeyo na aaneenu na atthu apale mwiniikhalanaaye. Kinoko khupweha yoori mwirette peewu.” ");
INSERT INTO eko_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Yo khujipu araka: “Weeyo mbwaneetthu wanuusuru, wanirettela vitthu zooshapweya, fweeyo nakhupali na rooho zetthu zooshi wiiya amwiitthwaana za Firawuuna.” ");
INSERT INTO eko_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yuusufu khulaleya kano moote eriivo mpakha leelo eti, yoori lifunku la thaanu la vitthu zooshi zinruweriwaazo tthi la Firawuuna. Mashapa apale paasi a attunkhulu a tiini khuhinkhiwi wiiya awe. ");
INSERT INTO eko_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Meezirayeele khuthamela Misuri nti wa Gosheeni. Ottuukho khupatthawo meekhazi khuvokolelana khwaattelana. ");
INSERT INTO eko_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yaakhumpa eekhaliye tuniya ya Misuri nyaakha khumi na sapa, nyaakha eekhaliyeezo Yaakhumpa ohaayi awe wooshi zaari miiya na arupayiini na sapa. ");
INSERT INTO eko_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ooniyeevo yoori mansha awe asala vattitthiiru khunkhuwela mwanawe Yuusufu khumuuza yoori: “Nkhama onikipheta othuule nkhono awo otthe vathi wa liphaja laka, olaphe nkhama onteela oretta na pheta ya waamineya etile kuuvekeliyeeyo, yoori ohikizikhe tuniya ethiiti ya Misuri. ");
INSERT INTO eko_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Amana kifwa okilazemo tuniya eti olawe wakizikhe nti opule azikhiweewo apapazaku, kilawe keeye vamote na-yo.” Yuusufu khujipu araka: “Kinttela oretta etthiipo mwikirumiyeezo.” ");
INSERT INTO eko_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Aphano Yaakhumpa khunkhanyerela yoori alaphe, Yuusufu khulapha, Yaakhumpa khwiinamela ovishwa w'oolili. ");
INSERT INTO eko_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Wakathi ziviriyeevo vitthu epile, khuuziwa Yuusufu oriwa: “Papaawo nlwele.” Ye khulankha khusala alawa omoona, alawaka khuwaathuula aanaawe awiri, Manaase na Efwarayiimu. ");
INSERT INTO eko_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Khuuziwa Yaakhumpa yoori: “Mwanenu Yuusufu ontta ota oteela owoona.” Ezirayeele khujilipisela khulankha khwiikhala voolili. ");
INSERT INTO eko_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Aphano Yaakhumpa khumuuza Yuusufu: “Nluku Woowahi Wooshi aakipuweleliye nti wa Luuzu tuniya ya Kanaani khukiparikhiya, ");
INSERT INTO eko_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","akuuzaka yoori: ‘Kinteela owinkha mavokozi na kaattise peewu yawo yoori khwa weyo epuwe khuntti za waatta na kinkhe nti opu peewu yawo khwa mileele.’ ");
INSERT INTO eko_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Aanaawo apa awiri avokoliweeyo Misuri miiyo kihinate, Manaase na Efwarayiimu apa aya pi aka aanaaka, nkhama etthiipo Ruubeni na Simiyooni eeyiyeezo aanaaka. ");
INSERT INTO eko_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ila apa onttelaaye owaavokola theenya anttela wiiya awo apa pa yo anttelaaye orithi zwaamu ya attwiizaya. ");
INSERT INTO eko_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Kirutaka Paata-Araamu akifwela muukhaaka Rakeele tuniya ya Kanaani, kiri ntarikhi kisaleelaka ofiya nti wa Efwarata. Miiyo khunzikha phantte ya tarikhi ya Efwarata oniitthiwaawo Belemu.” ");
INSERT INTO eko_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ezirayeele n'oowoona aana a Yuusufu khuuzela araka: “Khi apa apaani?” ");
INSERT INTO eko_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yuusufu khunjipu papaawe yoori: “Apa aana akinkhiyeeyo Nluku mmuti nttumphu.” Ezirayeele khulupa yoori: “Okitiisele apha kiriivo yoori kiwaaparikhiye.” ");
INSERT INTO eko_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Maasho awe Ezirayeele khaari woona saana mwaasa wa wuuluvala, Yuusufu khuwaathuula aana apale khumwaattamisela pwapwaaya, ye khuwaapatikha khuwaapejari. ");
INSERT INTO eko_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ezirayeele khumuuza Yuusufu yoori: “Wala akaari wuupuwela yoori kaari oteela woonanana weeyo theenya, ila Nluku akinoza mpakha aanaawo!” ");
INSERT INTO eko_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Elottelanaka Yuusufu khuwaalazavo aana apale vamakutha wa pwapwaaya khwiinama khufiyisa ajihi yawe vathi. ");
INSERT INTO eko_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yuusufu khuwaathuula aanaawe oowiiri, Efwarayiimu nkhono-nlume phantte ya nkhono-nkha wa Ezirayeele, Manaase khunthuula nkhono-nkha phantte ya nkhono-nlume wa Ezirayeele khunttha khuwaattamisela pwapwaaya. ");
INSERT INTO eko_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ezirayeele khookola nkhono awe weelume veeshwa wa Efwarayiimu, otu nttiitthi aya, nkhono-nkha khuttha veeshwa wa Manaase otu nwulu. ");
INSERT INTO eko_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Aphano khumparikhiya Yuusufu araka: “Nluku otu anrumeyeliyeeyo apapazaku, Eburahiima na Esiyaakha, Nluku otu ankishukaaye ohaayi aka wooshi mpakha leelo, ");
INSERT INTO eko_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Nlayikha ntthi likilaziyeemo nkatthi wa vitthu zootakhala, liwaaparikhiye asimaana apa. Khwa yo livuwisiwe nzina laka na mazina a apapazaku, Eburahiima na Esiyaakha, eeyane peewu ya waatta vatuniya.” ");
INSERT INTO eko_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Wakathi Yuusufu amooniyeevo papaawe athuuliye nkhono awe nlume khuttha veeshwa wa Efwarayiimu, ye khuhintuveli. Khulazavo nkhono-nlume wa papaawe veeshwa va Efwarayiimu khuttha veeshwa va Manaase. ");
INSERT INTO eko_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Khumuuza papaawe yoori: “Khahiyo toowo paapa, otu ti ye eeyiye nttunkhulu, apho nkhono-nlume mwinttheele othuuto veeshwa vawe.” ");
INSERT INTO eko_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ila papaawe khuhitakhi khuri: “Miiyo kinjuwa mwanaka etthu kinrettaaye. Manaase onttela wiiya khuntti khuluyeene na onteela wiiyana peewu ya waatta, ila ttwiiye otu nttiitthi onteela onziti ye, peewu yawe enttela wiiya khuntti za waatta.” ");
INSERT INTO eko_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Aphano khuwaaparikhiya siikhu ethiitile araka: “Atthu a Ezirayeele anteela owaaparikhiya azaaya arumeyelaka mazina enu araka: ‘Nluku ooretteni nkhama Efwarayiimu na Manaase.’” Paata ya toowo, khunwulisa Efwarayiimu zayita Manaase. ");
INSERT INTO eko_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Elottelanaka, Ezirayeele khumuuza Yuusufu yoori: “Apha miiyo nasaapi kimfwa, ila Nluku onttela wiiya vamote na-mweyo na ti ye anttelaaye wuurutiselani nti wa apapazenu. ");
INSERT INTO eko_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Apho kawinkha nti w'oonyaako wa Shekemu weeyo owaazitiyeeyo attwiizo, etile kiwaanyakanyiyeeyo amoori kuumananaka phanka yaka na mattetthe aka.” ");
INSERT INTO eko_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yaakhumpa khuwaakhuwela aanaawe khuwooza yoori: “Mwite apha kiwuuzeni vitthu zinttelaaye orettikhana siikhu epo zintaazo. ");
INSERT INTO eko_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Mwisusele apha mwisiile aana a Yaakhumpa, mwinsiileze papeenu Ezirayeele. ");
INSERT INTO eko_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Weeyo Ruubeni, mwaana woomwanzo aka, kuvu zaka, nshumo woomwanzo woojikhitiri wooshapu aka, mwanzo wooshitahiwa channu na wookhomaala. ");
INSERT INTO eko_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Weeyo o wootumpunyeya nkhama maati a mpahari, omwanzo awo wafujeya, mwaasa woolalana muukha wa papaawo, waphuja voolili wa papaawo. ");
INSERT INTO eko_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Na-ye Simiyooni na Leevi, ntthu na ttwiiye, phanka zaya puntukhi zoorettana vitthu zoohusuti. ");
INSERT INTO eko_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Shawuri zaya miiyo akeepu, na rooho yaka khiri vamote na-yo, mwaasa wa wiiphiiriwa waya awoola atthu khushija ttottopwa za mompe za watthu mwayiini. ");
INSERT INTO eko_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Woolaanikha wiiye wiiphiiriwa waya yo, maana pu woowali, woolaanikha yiiye katapu yaya yo, maana pi zookhomaala. Kinlawa kawaaphakulevo vakatthi wa khapila ya Yaakhumpa, kiwaamwazelaka vakatthi wa Ezirayeele. ");
INSERT INTO eko_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Weeyo Yuuda, attwiizo anteela wuuttottopela; onttela owaashintta maatuwi awo, aana a papaawo anlawa awiinamele weeyo. ");
INSERT INTO eko_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuuda, mwaana wa siipa, amana akhola nyama khininsuruwa; onlattanana siipa nwulweene arapaleliye, paani amminyalaaye khunlansa? ");
INSERT INTO eko_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Khweele Yuuda khanteela onyakanyiwa ofwalume awe, wala pakhora y'oofwalume eriiye mmwinyoka mwawe, mpakha ate mwennyewe ofwalume, otu anttelaaye oshututeliwa pi atthu ooshi. ");
INSERT INTO eko_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ye onteela ofukelela puuru yawe vanrayi wa wuuva, na mwaanaaya anfukelele veerapi yooshapweya ya nrayi otthuupo. Kuwo zawe nka afulanaka viinyu na ajapi yawe nka afulanaka taamu ya wuuva. ");
INSERT INTO eko_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Maasho awe anttela wiiya awaara mwaasa woonywa viinyu ya wuuva, meeno awe anttela wiiya oolakala mwaasa w'oonywa leethi. ");
INSERT INTO eko_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabulooni onttela wiikhala phantte ya phwaani, onttela wiiya patari ya makalawa; mwiinano awe onlawa mpakha nti wa Sidooni. ");
INSERT INTO eko_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ezakaari puuru wookhomaala arapaleliye vakatthi wa mapwattha mawiri. ");
INSERT INTO eko_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Wakathi ooniyeevo yoori tuniya etile yaari ya shirehe na yooshapweya ovumula, ye khwiinamisa mafuzi awe khuvikela mapwattha, khusala akhola khaazi nkhama mwiitthwaana. ");
INSERT INTO eko_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Daani, onteela ophuka washariyavo khapila yawe nkhama lihimo limote la Ezirayeele. ");
INSERT INTO eko_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ye onteela wiiya nkhama nyookha eniiyaaye nshini wa tarikhi. Nkhama evili yoovithaalela enlumaaye ekwakuno ya khavalo, namweettettisa khavalo khukwana enyokonyoko. ");
INSERT INTO eko_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Oo Mbwanaaka! Miiyo kinweja nusura yawo! ");
INSERT INTO eko_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gaadi onteela wuumananiwa pi annya-viittha ila ye eettaka owiikarisa. ");
INSERT INTO eko_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Vitthu-zoojiwa za Azeeri enttela wiiya za nnofu, ye nka avahaka etthu-yooja ethiitile ensuhaaye oja afwalume. ");
INSERT INTO eko_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nafitaali nazoro woojitaphula aniwaapatthaaye aana ooshapweya. ");
INSERT INTO eko_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yuusufu muutthi wa wiima channu waattameliyeeyo nshini wa maati, virapi zaya khurapela vatulu wa muuri. ");
INSERT INTO eko_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Maatuwi awe anlawa amuumanane amwiikarisaka na mattetthe aya, ");
INSERT INTO eko_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ila nttetthe lawe tthi lookhomaala, makhono awe pi oozivala khwa kuvu za Nwali wa Yaakhumpa, khwa kuvu za Nshuki nwulu, Mwaako wa Ezirayeele, ");
INSERT INTO eko_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","khwa kuvu za Nluku wa papaawo, Nluku Woowahi Wooshi. Ye ooparikhiye weeyo Yuusufu na parakha za pinkuuni, na parakha za mmaati ariiye vathi w'oolumwenku, na parakha za nyama za waatta na parakha zoovokola. ");
INSERT INTO eko_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Parakha za papaawo pi za waatta zayita parakha epile za nyaako epi za raku, na maali za nyaako mittiitthi za mileele. Parakha zooshi epi ziiye veeshwa wa Yuusufu mpakha vaajihi va otule athawuliweeyo vakatthi wa attwiize. ");
INSERT INTO eko_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Bejami miiji woosaya, supuyeene ontta okhola nyama na orafuna, njuwa looveva na waawanya epile zinsalaazo.” ");
INSERT INTO eko_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Pi atthaapa mahimo khumi na mawiri a Ezirayeele, na mattakhuzi aawooziyeeyo papaaya awaaparikhiyaka, na amwinkhaka wakhula ntthu parakha yawe etile yaamweeziyeeyo. ");
INSERT INTO eko_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Elottelanaka Yaakhumpa khuwooza araka: “Kinttela ofwa kilawe kazikhiwe vamote na ajamaazaku apa afwiiyeeyo. Mwakizikhe vamote na apapazaku nlikurakuza liriiye mmashapa wa Eforoni Nhiiti, ");
INSERT INTO eko_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","nttintthile liriiye Makhipeela kharipu ya Manre tuniya ya Kanaani, nttinttho Eburahiima oozanyeziweeyo ti Eforoni Nhiiti yoori yiiye vilalo yawe. ");
INSERT INTO eko_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ottuukho azikhiweewo Eburahiima na muukhaawe Suhura, na-ye Esiyaakha na muukhaawe Rapekha na theenya ottuukho phi kinzikhiyeewo Liiya. ");
INSERT INTO eko_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Nshapa laya na likurakuza laya nttho oozanyaniye Ahiiti.” ");
INSERT INTO eko_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Nawiisha mattakhuzi apale aari owoozaaye aanaawe, Yaakhumpa khurutisela moolu awe voolili khurapalela khwiittha phuumu khufwa. ");
INSERT INTO eko_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yuusufu khumwiinamela papaawe omaasho wawe khumpejari khusala alila. ");
INSERT INTO eko_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Elottelanaka khuwooza anamajisa thiipa awe yoori anvaaze thiipa ya paalasamu papaawe yoori ahivutte; yo khuretta etthiipo. ");
INSERT INTO eko_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ottukuntteliwa thiipa Ezirayeele weeshiye siikhu arupayiini, nkhama etthiipo aazowereliyeezo Amisuri. Yo eeshiye siikhu saapiini ari mmatthaka. ");
INSERT INTO eko_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Nawiisha matthaka apale, Yuusufu khuwooza attunkhulu apale aari wiikhalanaaye Firawuuna araka: “Kookholani moolu mwilawe mwamuuze Firawuuna yoori; ");
INSERT INTO eko_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Paapa ahinafwe, aakilaphisiye yoori: ‘N'oofwa kilawe kanzikhe attaapho azikheweevo ajamaaze tuniya ya Kanaani.’ Safwatali mwikilikhe kilawe kanzikhe ottuukho nawiisha kintta ota.” ");
INSERT INTO eko_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Firawuuna khunjipu araka: “Wiiya oolaphisiye etta wanzikhe papaawo.” ");
INSERT INTO eko_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Aphano Yuusufu khulankha khusala alawa onzikha papaawe vamote na attunkhulu, akarumeya ooshi a Firawuuna na mamunu-munu ooshi a tuniya ya Misuri. ");
INSERT INTO eko_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Aalawiye vamote na ajamaaze Yuusufu na attwiize, na ajaama ooshi a Yaakhumpa aasaliiyeeyo aari asimaana na pwittipwitthi na mompe. ");
INSERT INTO eko_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Atthu aalawiye mmwikukutta akina vakhavalo, atthu aalawiyeeyo aari a waatta. ");
INSERT INTO eko_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Afiiyeevo nti wa Ataati oriiye phantte ya malawa-njuwa ya muuttho Yorotaani, khwiikhala siikhu sapa Yuusufu ari mmatthaka wa papaawe eettaka olila. ");
INSERT INTO eko_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Wakathi Akanaani apale aari wiikhalaaye ottuukhule awooniyeevo Amisuri apale eettaka olila nti wa Ataati yo khuri: “Olila opu anlilaaye Amisuri apa nwulweene.” Pi apho khutthaja nzina aphale vaya la Apeele-Misurayiila, eniiyaaye malawa-njuwa ya muuttho Yorotaani. ");
INSERT INTO eko_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Aana a Yaakhumpa khuretta etthiipile aawooziyeezo ahinafwe. ");
INSERT INTO eko_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Khunthuula khunlawana tuniya ya Kanaani khulawa khunzikha nlikurakuza la Makhipeela waattamana na Manre, nshapa nttintthile Eburahiima oozanyaniyeeyo Eforoni Nhiiti yoori asala awaazikhawo ajamaaze. ");
INSERT INTO eko_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Nawiisha ozikha, Yuusufu khurutela Misuri vamote na attwiize na atthu ooshi apale aalawaniyeeyo ozikha. ");
INSERT INTO eko_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","N'oofwa papaaya, attwiize Yuusufu khuri: “Talili Yuusufu khana liphuta varoho vawe mwaasa wa vitthu epile nanretteliyeezo zootakhala, na-ye khanteela onirettela etthiipo?” ");
INSERT INTO eko_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Attwiize khumperekheza nhupi Yuusufu yoori: “Papaawo ahinafwe aanirumiye ");
INSERT INTO eko_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","yoori niwuuze toono: ‘Safwatali, owaaswaamihi attwiizo khwa koosa na twampi epile ooretteliyeezo mwaasa woohuukholi saana.’ Apho nasaapi eti ninuuvekela yoori, oniswaamihi koosa zetthu, fweeyo niiyiye akarumeya a Nluku otu aari omwaaputwaaye papaawo.” Ye n'oosiila mattakhuzi apale khusala alila. ");
INSERT INTO eko_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Aphano khuta attwiize khwiinama khukokhora anvekelaka nswammaha araka: “Nata n'aamwiitthwaana awo.” ");
INSERT INTO eko_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yuusufu khuwooza yoori: “Wala mwihikoove. Miiyo aki Nluku. ");
INSERT INTO eko_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Khweele mweeyo mwaakiwazeliye shawuri zootakhala. Ila Nluku khuzukulisa khwiiya zooshapweya. Khwa toowo Nluku awoosuru atthu a waatta mpakha leelo eti. ");
INSERT INTO eko_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Apho mwihoove. Miiyo kintta wuukholani mweeyo na aaneenu.” Khwa etthiipo Yuusufu khuwaanyamaza attwiize, mattakhuzi apale aawooziyeeyo aawaafiiye nroho mwaya. ");
INSERT INTO eko_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yuusufu aari wiikhala Misuri vamote na ajaama a papaawe, ye eekhaliye nyaakha miiya na khumi. ");
INSERT INTO eko_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Khuwoona aana a Efwarayiimu peewu yattaatthu, theenya khuwaathuula aana a Makhiiri, mwaana wa Manaase, khuwaattha vamoolu vawe. ");
INSERT INTO eko_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yuusufu ahinafwe khuwooza attwiize yoori: “Apha miiyo kinttela ofwa, ila Nluku onteela owaawunini oolazenimo mmuti mphu oolawaneni tuniya etile aamwaahitiyeeyo alaphaka yoori onteela omwinkha Eburahiima, Esiyaakha na Yaakhumpa.” ");
INSERT INTO eko_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ye khuwaalaphisa aana a Ezirayeele araka: “Kiniwuuzani khweele, Nluku onteela owaawunini. Amana zirettikhana epo zaya, mwilawaka nti aya opo mwithuule makhonkolo aka.” ");
INSERT INTO eko_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yuusufu afwa arina nyaakha miiya na khumi. Khuvaaziwa thiipa ya paalasamu mwiili awe yoori ahivutte, khutthiiwa mwiiluza khuzikhiwa tuniya ya Misuri. ");
INSERT INTO eko_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Apa mazina a aana a Yaakhumpa eettiyeeyo Misuri, wakhula ntthu na ajamaaze: ");
INSERT INTO eko_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruubeni, Simiyooni, Leevi, Yuuda; ");
INSERT INTO eko_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Ezakaari, Zebulooni, na Bejami; ");
INSERT INTO eko_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Daani, Nafitaali, Gaati, na Asheeri. ");
INSERT INTO eko_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Aana na atuuluwe Yaakhumpa ooshi aalawaniyeeyo aari sapiyiini; ila Yuusufu aari Misuri ottuukho rakuzeene. ");
INSERT INTO eko_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ziviriyeevo siikhu zawaatta, Yuusufu khufwa na attwiize apale na peewu ya etile. ");
INSERT INTO eko_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ila meezirayiilu apale aasaliyeeyo khuvokolelana khweekezeleya khwaattelana khwiiya okhomaala mpakha khufiyelela omwazeyela mmuti mphule wooshimo. ");
INSERT INTO eko_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Aphano Misuri khuthawala mfwalume nkinoko ahaari ojuwaaye hatha etthu monkoni wa Yuusufu. ");
INSERT INTO eko_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Aphano ye khuwooza atthu awe yoori: “Mwiwoone meezirayiilu pi awaattelana na ookhomaala zayita fweeyo. ");
INSERT INTO eko_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Nlaweni niwaalazele olavilavi yoori ahitepe waattelana, ehiri amana enipuwela viittha yo akusanyeya na maatuwi eetthu anirinkaanyela atthiramo mmuti mphu.” ");
INSERT INTO eko_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Aphano amisuri khuwaaretta yo wiiya anamalokozela a khaazi za nkuumu yoori apatthe owaahukhumu na khaazi zoolipa. Khwa etthiipo meezirayiilu khunjekela Firawuuna sitati piiri za sakafu zaari wiitthiwaaye Pito na Rameesi. ");
INSERT INTO eko_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Nakhataalikha zaama aari ohukhumwiwaavo, pi aari otepaavo waattelana, tiito amisuri khuwaapattha woova mwaasa wa meezirayiilu; ");
INSERT INTO eko_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","aphano amisuri khwaaza owaakholisa khaazi zoolipa. ");
INSERT INTO eko_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Khweekezela hukhumu muuhaayi mwaya, khwa owenkha khaazi zoolipa nkhama omeya ottophe na waattala thizolo, na okhola khaazi zooshi za mmashapa. Zooshi aari okholisiwa khwa oviitthwaana wootakhalavo. ");
INSERT INTO eko_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mfwalume wa Misuri khuttakhulana anamavokoza a meepereewu aariwitthiwaaye Siifwara na Puuwa yoori: ");
INSERT INTO eko_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Amana mwiwaawunaka meezirayiilu atakhaka ovokola, mwisala mwiwoona aanaaya. Eeyaru aalume, mwisala mwiwoola, ila eeyaru aakha, mwisala mwiwaalikha wiiya haayi.” ");
INSERT INTO eko_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ila anamavokoza apale khumoova Nluku khuhiretti etile ooziweeyo ti mfwalume wa Misuri, khusala awaalikha aana alume wiiya haayi. ");
INSERT INTO eko_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Aphano mfwalume wa Misuri khuwaakhuwela khuwoozela yoori: “Mwaari toovi owaalikha aana aalume wiiya haayi?” ");
INSERT INTO eko_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Anamavokoza apale khujipu yoori: “Aakha a meezirayiilu afwarikhana na apa a Misuri. Yo pi oojikhitiri, ampattha ekumi ahinafiyevo hatha namavokoza.” ");
INSERT INTO eko_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Nluku khwiiya wemaani khwa anamavokoza apale, na meezirayiilu khusala avira eekezeleyaka wookhomaalavo. ");
INSERT INTO eko_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Mwaasa wa anamavokoza apale omoova Nluku, ye khuwenkha owahi wa wiiyana ojama waya. ");
INSERT INTO eko_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Tiito Firawuuna khuwaaruma atthu awe ooshi yoori: “Wakhula mwaana wa meepereewu anvokoliwaaye eeyaru wanlume amweeselele mmuttho oniitthiwaaye Niilu, ila eeyaru wankha asala anlikha.” ");
INSERT INTO eko_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Mwinyi mmote wa lihimo la Leevi anraliye muukha wa lihimo limote na ye. ");
INSERT INTO eko_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Khumwiimitthisa khunvokolela mwaana. Amooniyeevo yoori aari wooshapweya khunvitha khwa nyeezi mittatthu. ");
INSERT INTO eko_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Nawoona yoori khayaari owaheya ovira anvithaka theenya, khuthuula khelenke ya tteketthe khumattha na piriniisi khuntthaamo mwaana otule, khulawa khunttha ntteketthe nkhome wa muuttho Niilu. ");
INSERT INTO eko_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Nlupuwe mwaana otule eemeliye toole sirini yoori oone niini yaari weettelaaye onrettikhanela. ");
INSERT INTO eko_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Mwaana wankha wa Firawuuna khwiishukhela mmuttho olawa woowa, ajaazi awe aarina khusala avira nkhome wa muuttho, ye khoona khelenke etile eri ntteketthe khunruma njaazi awe khweettela. ");
INSERT INTO eko_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Afunuliyeevo, khunsikanamo mwaana eettaka olila. Khumoonela huruma khuri: “Mwaana otu tuwa meezirayiilu.” ");
INSERT INTO eko_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Aphano, nlupuwe mwaana otule khumwaattama mwaana wa Firawuuna khumuuzela yoori: “Onuupuwela toovi? Ontakha miiyo kilawe kankhuwele nunu mmote mwiizirayiilu ate asala amwaamwisa?” ");
INSERT INTO eko_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Mwaana wa Firawuuna khunjipu yoori: “Haya etta.” Aphano mwanankha khulawa onkhuwela maama wa mwaana othuutule. ");
INSERT INTO eko_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Aphano, mwaana wa Firawuuna khumuuza yoori: “Onthuule mwaana otu omwaamwise zwaamu yaka, kintta wuuripha phakari yawo.” Nunu otule khunthuula mwaana khusala amwaamwisa. ");
INSERT INTO eko_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Paata ya mwaana otule owula khuntiisela mwaana wa Firawuuna khunretta wiiya mwanawe. Khuntthaja nzina la Munsa, araka: “Maana koolaza mmaati.” ");
INSERT INTO eko_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Siikhu moote, wakathi Munsa apatthiyeevo omwinyi, khulankha khulawa wa attwiize meepereewu khoona khaazi yoolipa aari okholisiwaaye na theenya khumoona mmisuri aari ompiyaaye na onvulalisa mwiipereewu. ");
INSERT INTO eko_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Khweekesa okhuno na okhuno nawoona yoori khaari otawo hatha ntthu, khumuula mmisuri otule khunttukuttha vanshaka. ");
INSERT INTO eko_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Siikhu yaphiiri khuwaasikana meepereewu awiri oomanaka khumuuza otule aariina paathuli yoori: “Onimpiyela-ni nzaawo?” ");
INSERT INTO eko_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ye khumuuzela yoori: “Paani awinkhiyeeyo onamalokozela weetthu ama onamaphuka? Ontakha okuule nkhama omuuliyeezo mmisuri otule?” Munsa khoova khuri: “Ee, ajuwa etthu kirettiyeeyo!” ");
INSERT INTO eko_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Firawuuna nawuuziwa vitthu epile khujilakelela omuula Munsa; ye khutthira khulawa mpakha nti wa Miitiya khwiikhala nshini wa nlipu. ");
INSERT INTO eko_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Namalokozela a tiini wa Miitiya aarina aanaawe sapa aakha, yo khuteela ottekha maati atthe n'yopo mwaya enkhe nyama za papaaya. ");
INSERT INTO eko_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Aphano khuta mishuki mikina khusala aweekara, ila attaaphale Munsa khulankha khusala awaakisa na khwinkha maati nyama zaya. ");
INSERT INTO eko_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Wakathi aruteliyeevo wa papaaya Rewele, ye khuwoozela yoori: “Leelo mwaruti supuyeene mwaasa wa niini?” ");
INSERT INTO eko_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Yo khujipu yoori: “Mmisuri mmote ti anaakisiye mmakhono wa mishuki mikina na othuuto khunittekhela maati khunywisa nyama zeetthu.” ");
INSERT INTO eko_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Khuuzeliwa ti papaaya yoori: “Apha yaya ori vayi? Mwanlikhelani? Mwankhuwele ate aje na fweeyo.” ");
INSERT INTO eko_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Munsa khukhupalela na khutakha wiikhalana mwinyi otule, mwanawe aari wiitthiwaaye Zipoora khunlooza. ");
INSERT INTO eko_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zipoora khunvokola mwaana, Munsa khuntthaja nzina la Yeerisoni alupaka yoori: “Kasaafirela nti wa malaponi.” ");
INSERT INTO eko_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ziviriyeevo siikhu zawaatta khufwa mfwalume wa Misuri; atthu a Ezirayiilu khusala asisimira na okhuwa monkoni wa oviitthwaana, nkhuwo aya opule khunfiyela Nluku. ");
INSERT INTO eko_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Nluku noosiila osisimira waya opule khufikhiri wahati aarettaniyeeyo Eburahiima, Esiyaakha na Yaakhumpa. ");
INSERT INTO eko_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nluku khuwoona meezirayiilu khumweeleya tafwawuthi aariinaayo. ");
INSERT INTO eko_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Munsa aari oshukisa nyama za nkhwewe Yeeturu, namalokozela a tiini wa Miitiya; siikhu moote khuthuula nyama khusala eettana phantte kiina ya n'yaara khufiya mpakha va mwaako wa Nluku, waari wiitthiwaaye Hereebe. ");
INSERT INTO eko_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Attaapho khumpuwelela nlayikha la Nnyizinku va nlimi la moottho waari olankhaaye vakatthi wa muutthi. Munsa khweekesa khoona yoori moottho weetta okholela ila muutthi opule khawaari olukula. ");
INSERT INTO eko_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Aphano ye khuri: “Vitthu zootikinisa kintta attaaphale kilawe koone, moottho ontta okholela ila muutthi opule khunlukula mwaasa aya niini?” ");
INSERT INTO eko_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Nnyizinku khumoona yoori ye eetta waattama muutthi opule, olawa woona, Nluku khunkhuwela enakatthi-nakatthi ya muutthi otthuupule araka: “Munsa! Munsa!” Ye khujipu araka: “Lapeekha!” ");
INSERT INTO eko_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Aphano Nnyizinku khumuuza yoori: “Ohaattamevo apha! Ovule mmoolu mpho jampali zawo maana puuro yaya eti oriivo ttakatthiifu.” ");
INSERT INTO eko_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Khurutela olupa yoori: “Miiyo ki Nluku wa papaawo, Nluku wa Eburahiima, Nluku wa Esiyaakha na Nluku wa Yaakhumpa.” Munsa khufinikha wuuso awe maana aari woova omweekesa. ");
INSERT INTO eko_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Nnyizinku khulupa yoori: “Khweele khweele kinoona nanna anhukhumwiwaazo atthu aka Misuri na kasiila nkhuwo aya mwaasa wa khaazi ankholisiwaazo pi anamalokozela a Firawuuna na kinjuwa yoori antta ohoowa; ");
INSERT INTO eko_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","tiito kiishukhiyeeyo oteela owuusuru mmakhono wa amisuri na kiwaalazakamo mphu kiwaalawanaka nti wooshapweya na nwulweene, ohali liniittikhaawo leethi na asali; ottuukho aniikhalaawo akanaani, ahiiti, amoori, aperizi, amwiivi na ayepuzi. ");
INSERT INTO eko_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Maana nkhuwo wa atthu a Ezirayiilu wakifiyela miiyo, na kinoona nanna amisuri aniwaahukhumwaazo. ");
INSERT INTO eko_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Kinuuruma nasaapi ethiiti Misuri wa Firawuuna, wawaalazewo atthu aka meezirayiilu.” ");
INSERT INTO eko_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Aphano Munsa khulupa amuuzaka Nluku yoori: “Ki paani miiyo woolawa wa Firawuuna olawa owaalazawo meezirayiilu?” ");
INSERT INTO eko_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Nluku khunjipu yoori: “Miiyo kiniiya vamote na-weyo. Eto ti alama yoori keetta wuuruma: Amana owaalazawo atthu Misuri wate vamwaako attaapha okaaputu.” ");
INSERT INTO eko_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Munsa khumuuzela Nluku yoori: “Miiyo amana kilawa vakatthi wa meezirayiilu kiwooza kiraka: ‘Nluku wa apapazenu akiruma vakatthi-venu,’ khi amana akuuzela yoori: ‘Nzina lawe paani?’ Kiwooze niini?” ");
INSERT INTO eko_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Nluku khumuuza Munsa araka: “MIIYO TI MIIYO. Owooze etthiipo meezirayiilu, yoori: ‘MIIYO TI MIIYO ti akirumiyeeyo vakatthi venu.” ");
INSERT INTO eko_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Nluku khulupa theenya amuuzaka Munsa yoori: “Wawooze meezirayiilu yoori: ‘Nnyizinku, Nluku wa apapazenu Nluku wa Eburahiima, Nluku wa Esiyaakha na Nluku wa Yaakhumpa, akiruma vakatthi ve.’ Nttho ti nzina linsalaaye kuupuwelaniwaka peewu khwa peewu mileele.” ");
INSERT INTO eko_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Olawe wawaakusanye attunkhulu a meezirayiilu, owooze yoori Nnyizinku, Nluku wa amarehemu apapazenu, Eburahiima, Esiyaakha na Yaakhumpa aakipuweleliye khukuuza yoori: ‘Khweele khweele, Miiyo kinoona tafwawuthi zenu na kinjuwa etthu anuurettelaanini a Misuri. ");
INSERT INTO eko_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Miiyo kaahiti wuulazanimo nhukhumu za amisuri kiweettaneni nti wa akanaani, wa ahiiti, wa amoori wa aperizi wa amwiivi na wa ayepuzi nti oniitthaaye leethi na asali.’ ");
INSERT INTO eko_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Attunkhulu anteela wuusiileza. Olankhe na attunkhulu a atthu aya atthaapo mwilawe wa Firawuuna wamuuze yoori: ‘Nnyizinku, Nluku wa meepereewu eettiye oniteela. Apho onilikhe nilawe neettette mwentto wa siikhu ttatthu neette n'yaara namwinkhe twaha Nnyizinku, Nluku etthu.’ ");
INSERT INTO eko_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Miiyo kinjuwa yoori mfwalume wa Misuri khanteela wuulikhani olawa woohiiyi khwa okhanyareliwa pi nkhono woowahi. ");
INSERT INTO eko_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Nakatalikha kinteela wookola nkhono aka kiwaavulaze amisuri khwa vitthu zootikinisa zooshi kinttelaazo oretta vakatthi vawo, paata ya toowo ontta wuulikhani olawa. ");
INSERT INTO eko_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Na kinteela owenkha amisuri wiiyana niiya na atthu apa na amana mwilaakawo, khamwinlaawo makhono-ru. ");
INSERT INTO eko_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Aakha ooshi ana ya owaavekela anamwaattamanana aya na apale aawaamakeliyeeyo vitthu za feeta na za tahapu, na kuwo za owaawalisa aaneenu, aalume na aakha. Khwa etthiipo mwintta ovulula maali zooshi za amisuri.” ");
INSERT INTO eko_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Munsa khunjipu Nnyizinku araka: “Wala yo khanteela okhupalela, na khanteela okisiileza, na anlupa yoori: ‘Nnyizinku khoopuweleleeni!’” ");
INSERT INTO eko_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Nnyizinku khumuuzela Munsa araka: “Eto oriina mmakhono niini?” Ye khuri: “Pakhora.” ");
INSERT INTO eko_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Aphano khumuuza yoori: “Weeselele vathi!” Ye khweesa khuthatuwa khwiiya nyookha Munsa khutthira. ");
INSERT INTO eko_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Nnyizinku khumuuza Munsa theenya yoori: “Wookole nkhono awo okhole nkhira aya.” Khookola nkhono awe khukhola, khurutela wiiya pakhora. ");
INSERT INTO eko_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“Eto ti ya owaakhupalisa yoori oopuweleliye Nnyizinku, Nluku wa amarehemu apapazaya, Nluku wa Eburahiima, Nluku wa Esiyaakha, Nluku wa Yaakhumpa.” ");
INSERT INTO eko_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Nnyizinku khumuuza theenya yoori: “Otthe nkhono awo vamweyo!” Khutthaavo, alazakavo khwiiyana maaharaja khulakala nkhama liwiku. ");
INSERT INTO eko_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Nnyizinku khumuuza theenya yoori: “Othuule nkhono awo opheya otthe vamweyo.” Khutthaavo, noolazavo khurutela wiiya sawasawa na mwiili awe wooshi. ");
INSERT INTO eko_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Nnyizinku nalelo khuvira amuuzaka araka: “Amana yo ahikhupaleli ama ahitakhi, alama yamwanzo, yaphiiri anteela okhupalela. ");
INSERT INTO eko_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ila amana nalelo eeya ahinakhupalele alama epo piiri wala khuhuusiilezi, ottekhe maati vattitthiiru a mmuttho Niilu, wiitthele tuulu, antta othatuwa maati aya apo a tuulu eeye taamu.” ");
INSERT INTO eko_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Aphano Munsa khumuuza Nnyizinku yoori: “Oo, Mbwana, thanku raku miiyo akinwahi ottakhula saana; mpakha nasaapi eti waaziyeevo ottakhulana miiyo, amana kittakhulaka kintta okukuma.” ");
INSERT INTO eko_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Nnyizinku khunjipu yoori: “Paani amwinkhiyeeyo milomo pinaatamu? Paani amwinkhiyeeyo ottakhula wala paani awuumpiyeeyo apale ohisiili? Wala apale awoona ama apale ohooni? Khahiyo miiyo Nnyizinku? ");
INSERT INTO eko_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Apho olawe, Miiyo kinttela wiiya vamote na milomo zawo na kinuunozela etthu onttelaaye ottakhula.” ");
INSERT INTO eko_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ye khujipu araka: “Oo Mbwanaaka, kinuuvekela yoori onrume ntthu nkina.” ");
INSERT INTO eko_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Aphano Nnyizinku khumpattha katapu khwa Munsa, khumuuza yoori: “Weeyo khuna ttwiiyo Arawu, nleevi? Miiyo kinjuwa yoori ye onwahi ottakhula saaneene. Nasaapi eti ye ontta ota oteela okutthanana weeyo, ye onttela wiiya woofurahi amana oosikana. ");
INSERT INTO eko_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Weeyo onttela ottakhulana omuuze mattakhuzi anttelaaye olupa; miiyo kintta owaawunini moowiiri yoori mwittakhule na kiwuuzeni etthu yooretta. ");
INSERT INTO eko_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Arawu onttela ottakhulana atthu khwa zwaamu yawo, onttela wiiya nlomo awo, weeyo onttela wiiya nkhama Nluku khwa ye. ");
INSERT INTO eko_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Othuule pakhora eti mmakhono, ti ethiiti onttelaaye orettana alama za minjuza.” ");
INSERT INTO eko_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Aphano Munsa khurutela wa nkhwewe Yeeturu khumuuza yoori: “Safwatali, kilikheni kilawe Misuri kawoone ajamaazaku nkhama nalelo ari haayi.” Yeeturu khujipu araka: “Olawe na heeri.” ");
INSERT INTO eko_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Nnyizinku aamuziye Munsa ari Miitiya yoori: “Orutele Misuri maana ooshi apale aari otakhaaye owuula afwa.” ");
INSERT INTO eko_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Aphano Munsa khunthuula muukha awe na aanaawe khuwaattha va puuru vawe khusala arutela Misuri. Mmakhono mwawe aathuuliye pakhora ya Nluku. ");
INSERT INTO eko_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Nnyizinku khumuuza theenya Munsa yoori: “Miiyo kawinkha owahi wooretta minjuza zawaatta. Amana orutelawo Misuri wiiye woojitthenka yoori orette omaasho wa mfwalume wa nti aya opule minjuza zaya epo, ila miiyo kinlawa koomise rooho yawe ahiwaalikhe atthu apo olawa. ");
INSERT INTO eko_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Omuuze Firawuuna oraka: ‘Nnyizinku alupa toono: Ezirayiilu mwanaka wamwanzo. ");
INSERT INTO eko_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Miiyo kalupa yoori: “Onlikhe mwanaka alawe akaaputu.” Ila weeyo amana okatthala kintta omuula mwanawo wamwanzo.’” ");
INSERT INTO eko_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Eettaka Misuri vahali aamakiyeevo ntarikhi Nnyizinku khunteela Munsa yoori amuule. ");
INSERT INTO eko_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Ila Zipoora khuthuula liwe loothokolowa khushija shapala ya soola ya mwanawe khupiyana moolu a Munsa. Khuri: “Weeyo omannaka miiyo khwa taamu.” ");
INSERT INTO eko_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Zipoora khuri: “Omannaka khwa taamu,” athoonyezaka okhiriya opule. Wakathi otthuupule Nnyizinku khunlikha Munsa. ");
INSERT INTO eko_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Aphano Nnyizinku khumuuza Arawu yoori: “Olawe n'yaara wakutthanane Munsa.” Ye khulawa khukutthanana va mwaako wa Nluku, khunchelisa. ");
INSERT INTO eko_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Munsa khunthatelela Arawu zooshi epile Nnyizinku anrumiyeezo omuuza, na khumuuza alama zooshi za minjuza arumiweeyo oretta. ");
INSERT INTO eko_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Aphano Munsa na Arawu khulawa khuwaakusanya attunkhulu ooshi a meezirayiilu. ");
INSERT INTO eko_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Arawu khuwooza zooshi Nnyizinku amuziyeeyo Munsa. Nawiisha naye Munsa khuretta alama za minjuza vakatthi wa atthu apale, ");
INSERT INTO eko_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","yo khukhupali. Wakathi ajuwiyeevo yoori Nnyizinku awoopuweliye meezirayiilu na aawoniye nanna aari ohoowaazo yo khwiinama khwaaputu. ");
INSERT INTO eko_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Paata ya toole Munsa na Arawu khulawa ottakhulana Firawuuna amuuzaka yoori: “Nnyizinku, Nluku wa meezirayiilu alupa toono: ‘Owaalikhe atthu aka alawe akirettele njampo n'yaara.” ");
INSERT INTO eko_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Firawuuna khujipu araka: “Nnyizinku paani wonshututela miiyo khuwaalikha olawa meezirayiilu? Akininjuwa Nnyizinku aya na akiniwaalikha meezirayiilu olaamo mphu.” ");
INSERT INTO eko_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Munsa na Arawu khukhanyarela araka: “Nluku wa meepereewu ettiye oniteela, safwatali onilikhe nilawe narette safwari ya siikhu ttatthu neettaka n'yaara, namwinkhe twaha Nnyizinku, Nluku etthu, noohiiyi etthiipo antta oniteela marati ama ontta onuula na phanka.” ");
INSERT INTO eko_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Aphano mfwalume wa Misuri khumuuza Munsa na Arawu yoori: “Mwaasa aya niini mweeyo mwiwantipwaka atthu na khaazi zaya? Haya! Mwilawe mwakhole khaazi zoolipa.” ");
INSERT INTO eko_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Theenya Firawuuna khulupa yoori: “Atthu apa pi awaatta ila mwintta owaalikhisa okhola khaazi zaya.” ");
INSERT INTO eko_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Siikhu ethiitile Firawuuna khuwenkha nrumo anamalokozela awe na masuphayi anakhaazi, araka: ");
INSERT INTO eko_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Waaza leelo ethiiti mwihirutele owenkha malala awaattalana thizolo nkhama mwaari orettaazo; asala alawa weekesa eenyewe. ");
INSERT INTO eko_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ila mwiwaakhanyarele waattala thamani ethiitile aari waattalakaaye, mwihiwaavukule hatha etthu; apa aya anamaviliwa, ti eto aaziyeeyo okhuwa araka ‘ninttela omwinkha twaha Nluku etthu.’ ");
INSERT INTO eko_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Mweekezele khaazi yaya yoolipa yoori ashikheye ahisiileze vitthu zoohatiwa.” ");
INSERT INTO eko_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Anamalokozela na masuphayi khulawa khuwooza atthu apale yoori: “Firawuuna alupa toono: ‘Nilikhe owinkhani malala. ");
INSERT INTO eko_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Mwilankhe mwilawe mwawooze yoori alawe akusanye malala nhali anwahaaye opatthamo, na khaazi yenu yoolipa khinteela ovukuwavo hatha etthu.” ");
INSERT INTO eko_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Aphano atthu apale khumwazeyela nti wooshi wa Misuri khukusanya nyaani khwa zwaamu ya malala. ");
INSERT INTO eko_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Anamalokozela a khaazi khuwaattitta awoozaka yoori: “Mwiishise khaazi khwa nanna mooziweezo okhola wakhula siikhu wakathi opule mwaari winkhiwaavo malala.” ");
INSERT INTO eko_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Khujalitiwa masuphayi ameezirayiilu apale atthomiweeyo pi anamalokozela a anakhaazi a Firawuuna, na khusala oozeliwa yoori: “Mwaasa aya niini mwihiishisaka khaazi yenu ya waattala thizolo taana wala leelo nkhama mwaari orettazo raku?” ");
INSERT INTO eko_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Aphano masuphayi a meezirayiilu khulawa ojiliza wa Firawuuna yoori: “Mwaasa aya niini owaatthanttaka toono akarumeya awo? ");
INSERT INTO eko_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Malala khaninkhiwa na ninuuziwa waattala thizolo. Woone, nintta ojalitiwa; ila atthu awo pi ariina paathuli.” ");
INSERT INTO eko_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ila Firawuuna khujipu yoori: “Anamaviliwa! Mweeyo oviliwa! Tiito mwinraaye; ‘Nintakha olawa omwinkha twaha Nnyizinku.’ ");
INSERT INTO eko_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Nasaapi ethiiti mwirutele okhaazi. Khamwinteela opokhera malala! Ila mwina yawuupa thizolo thamani ethiito mwaari wuupakaaye!” ");
INSERT INTO eko_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Masuphayi apale a meezirayiilu khujuwa yoori aari nhukhumu, mwaasa woosiila yoori ahivukule thamani ya thizolo ooziweeyo waattala wakhula siikhu. ");
INSERT INTO eko_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Paata ya masuphayi apale noolaavo aphale aariivo Firawuuna, khunsikana Munsa na Arawu eettaka owaaweja. ");
INSERT INTO eko_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Yo khulupa yoori: “Nnyizinku ti awooneni na oophukeni; maana mweeyo mwaniretta fweeyo wiiya atthu awiiphira omaasho wa Firawuuna na wa akarumeya awe khuwenkha phanka mmakhono mwaya yoori anuule.” ");
INSERT INTO eko_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Aphano Munsa khuzukuluwela wa Nnyizinku khumuuza yoori: “Oo Mbwana, wawaahukhumwelani atthu apa? Khi wakirumeliyeeni? ");
INSERT INTO eko_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Maana thanku kilawiyeevo ottakhulana Firawuuna khwa nzina lawo yoori ontta owaahukhumu atthu apa, weeyo khawaarettiye hatha etthu yoori owaataphule!” ");
INSERT INTO eko_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Nnyizinku khumuuza Munsa yoori: “Aphano attaapha ontta woona etthu kinttelaaye onrettela Firawuuna, khwa nkhono aka woowahi ontta owaalikha olawa, khwa nkhono aka woowahi ontta owiikara mmuti mwawe.” ");
INSERT INTO eko_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Nluku khumuuza theenya yoori: “Miiyo ki Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Kampuweleliye Eburahiima, Esiyaakha, na Yaakhumpa nkhama Nluku wa Owahi Wooshi, ila akiwaalikheeni okijuwana nzina la Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Na theenya kaarettaniye wahati aka wa owenkha nti wa Kanaani, nti aari wiikhalaaye ari aletto. ");
INSERT INTO eko_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Nasaapi eti kasiila ojiliza wa meezirayiilu atthaapo amisuri awaarettiyeeyo oviitthwaana na kafikhiri wahati aka karettaniyeeyo. ");
INSERT INTO eko_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Nakatalikha owooze meezirayiilu yoori: Miiyo ki Nnyizinku na kinteela owaalazamo nkatthi wa oviitthwaana arettiweeyo pi amisuri. Kiwaataphule khaazi zoolipa epo enkhiweezo na kiniwoosuru na nkhono wookhomaala na owahi nwulweene na hukhumu. ");
INSERT INTO eko_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Kinuuthuulani mwiiye atthu aka na-miyo kiiye Nluku enu, aphano pi mwinttelaavo ojuwa yoori miiyo ki Nnyizinku, Nluku enu kuulaziyeenini vathi wa khaazi zoolipa mwenkhiweeyo pi amisuri. ");
INSERT INTO eko_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Na kinuuthuulani kiweettaneni nti kaalaphiyeeyo omwinkha Eburahiima, Esiyaakha na Yaakhumpa; apho kiniwinkhani mweeyo wiiye wenu. Miiyo ki Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Munsa khuwooza etthiipo meezirayiilu, ila yo khuhitakhi onsiileza, mwaasa wa othunku na hukhumu aari woonaayo nkatthi wa oviitthwaana. ");
INSERT INTO eko_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Aphano Nnyizinku khumuuza Munsa araka: ");
INSERT INTO eko_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Olawe wamuuze Firawuuna mfwalume wa Misuri yoori awaalikhe meezirayiilu aleemu mmuti mwawe.” ");
INSERT INTO eko_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Munsa khunjipu Nnyizinku araka: “Meezirayiilu khanikisiila, khi nannani anttelaaye okisiileza Firawuuna, khupe miiyo kihijuwaka ottakhula saana?” ");
INSERT INTO eko_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ila Nnyizinku anrumiye Munsa na Arawu, yoori awooze meezirayiilu na Firawuuna, mfwalume wa Misuri, yoori etta orumiwa owaalazawo meezirayiilu Misuri. ");
INSERT INTO eko_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Attunkhulu a ojama aari apa: Aana a Ruubeni, mwaana nwulu wa Yaakhumpa aari apa: Enookhi, Phaalu, Hesherooni, na Khariimu; opu pi waari ojama wa Ruubeni ");
INSERT INTO eko_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Aana a Simiyooni aari apa: Yemuweeli, Yamiini, Ohaati, Yakhiini, Zowaari na Shawaali mwaana wa nunu mmote wa Kanaani; opu pi waari ojama wa Simiyooni. ");
INSERT INTO eko_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Apa mazina a aana a Leevi khwa ovokoliwa waya: Yeerisoni, Kowaati, na Meraari. Leevi eekhaliye nyaakha miiya na talaathiini na sapa. ");
INSERT INTO eko_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Aana a Yeerisoni khwa ojama aya pi apa, Lipiini na Simeeyi. ");
INSERT INTO eko_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Aana a Kowaati pi apa: Anraawu, Izaari, Heporooni na Uziili. Kowaati eekhaliye nyaakha miiya na talaathiini na mittatthu. ");
INSERT INTO eko_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Aana a Meraari pi apa; Mali na Muushi. Ntthi laari lihimo la Leevi khwa nanna ya ovokoliwa waya. ");
INSERT INTO eko_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Anraawu khunrala Yokipeeti nlupu wa papaawe, khunvokolela Arawu na Munsa, Anraawu eekhaliye nyaakha miiya na talaathiini na sapa. ");
INSERT INTO eko_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Aana a Izaari pi apa: Koora, Nefekhe, na Zikiiri. ");
INSERT INTO eko_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Aana a Uziili pi apa: Mizayeele, Elizaafwa, na Sithiiri. ");
INSERT INTO eko_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Arawu anraliye Elisheepa mwaana wa Aminataapi, nlupu wa Nashooni; ye khunvokolela Nataapi, Apiiwu, Elizaari na Itamaari. ");
INSERT INTO eko_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Aana a Koora pi apa: Asiiri, Elikana na Apiyasaafi; ntthi laari lihimo la Akoora. ");
INSERT INTO eko_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Elizaari, mwaana wa Arawu, khunrala mwaana mmote wa Putiyeele, khunvokola Fineeya; apa pi attunkhulu a ojama wa Leevi. ");
INSERT INTO eko_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ti Arawu na Munsa atthaapo Nnyizinku awaarumiyeeyo yoori: “Mwilazewo Misuri lihimo la meezirayiilu.” ");
INSERT INTO eko_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Pi atthaapo, Munsa na Arawu, anttakhulaniyeeyo Firawuuna mfwalume wa Misuri na niiya ya owaalazawo meezirayiilu. ");
INSERT INTO eko_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Siikhu Nnyizinku attakhulaniyeevo Munsa ari nti wa Misuri, ");
INSERT INTO eko_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Nnyizinku aamuziye yoori: “Miiyo ki Nnyizinku. Omuuze Firawuuna mfwalume wa Misuri zooshi epile kiniwuuzaaye.” ");
INSERT INTO eko_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Munsa khunjipu Nnyizinku araka: “Miiyo akinttakhula saana; Firawuuna onttela okisiila toovi?” ");
INSERT INTO eko_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Aphano Nnyizinku khumuuza Munsa yoori: “Miiyo kooretta wiiya nkhama Nluku khwa Firawuuna na ttwiiyo Arawu wiiya nkhama napiyu awo. ");
INSERT INTO eko_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Weeyo omuuze zooshi epile kuurumiyeeyo, na ttwiiyo Arawu amuuze Firawuuna awaalikhe meezirayiilu aleemo mmuti mwawe. ");
INSERT INTO eko_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ila miiyo kinteela wuumisa rooho ya Firawuuna na kinteela wenkeza alama zaka na vitthu zaka zootikinisa nti wa Misuri. ");
INSERT INTO eko_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Ye khanteela wuusilezani, ila miiyo kinteela wookola nkhono aka khwa Misuri, na khwa khaazi khuluzeene za ophuka, kinteela owaalazawo Misuri atthu a Ezirayiilu. ");
INSERT INTO eko_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Phi amisuri anttelaavo ojuwa yoori miiyo ki Nnyizinku, amana kookola nkhono aka khwa Misuri kiwaalazavo meezirayiilu vakatthi vaya.” ");
INSERT INTO eko_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Munsa na Arawu khuretta etthiipo Nnyizinku awaarumiyeezo. ");
INSERT INTO eko_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Wakathi aattakhulaniyeevo Firawuuna Munsa aarina hirimu ya nyaakha thamaaniini, Arawu aarina hirimu ya nyaakha thamaaniini na mittatthu. ");
INSERT INTO eko_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Nnyizinku khumuuza Munsa na Arawu yoori: ");
INSERT INTO eko_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Amana Firawuuna awuuzani yoori: ‘Mwirette minjuza awahi wuukhupalini,’ omuuze Arawu: ‘Athuule pakhora yawo eeselele enakatthi ya Firawuuna,’ pakhora ya eto entta othatuwa yiiye nyookha.” ");
INSERT INTO eko_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Aphano Munsa na Arawu khulawa mpakha wa Firawuuna, noofiya khuretta etthiipile Nnyizinku aawaarumiyeeyo. Arawu khuthuula pakhora etile khweeselela enakatthi ya Firawuuna na mashawuriiya awe pakhora etile khuthatuwa khwiiya nyookha. ");
INSERT INTO eko_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Aphano naye Firawuuna khuruma olawa okhuweliwa ajuwi na anamajintta; na yo khuretta etthiipo khwa majintta aya. ");
INSERT INTO eko_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Wakhula mmote wa yo khusala eesa pakhora yawe na othatuwa nyookha, ila pakhora ya Arawu khumiza pakhora epile. ");
INSERT INTO eko_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ila Firawuuna khuumisa rooho yawe khuhitakhi owaasiileza, nkhama etthiipo Nnyizinku aalupiyeezo. ");
INSERT INTO eko_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Nnyizinku khumuuza Munsa yoori: “Rooho ya Firawuuna tiya nthiti khanteela owaalikha atthu apo olawa. ");
INSERT INTO eko_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Olawe wakutthanane Firawuuna supuyeene; ye onlawa woowa omuttho. Weemele nshini wa muuttho osala onweja, olawaka othuule pakhora yawo mmakhono etile yaathatuwiyeeyo nyookha. ");
INSERT INTO eko_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Omuuze yoori: Nnyizinku, Nluku wa meezirayiilu, akiruma owuuza yoori: Owaalikhe atthu aka alawe akaaputu n'yaara, mpakha leelo khuntakha okisiileza. ");
INSERT INTO eko_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Nnyizinku alupa toono: Ethiito ti enttelaaye wuujuwisa yoori miiyo ki Nnyizinku: khwa pakhora eti kiriina mmakhono kintakha kipiye maati a Nniilu athatuwe eeye taamu. ");
INSERT INTO eko_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Swi ziriiye mmuttho zinteela ofwa zooshi, osala onukhamo woohifwayivo. Aphano amisuri ewaapatthe enanaari ya onywa maati a mmuttho mphule.” ");
INSERT INTO eko_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Nnyizinku khumuuza Munsa theenya yoori: “Omuuze Arawu athuule pakhora yawo ookolele nkhono maati a Misuri, a mmuttho na mpakha a mmatthatta na a mmazuuku athatuwe eeye taamu, Misuri yooshi yiitaale taamu, mpakha zoopo za thaapwa na za mawe.” ");
INSERT INTO eko_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Munsa na Arawu khuretta nkhama etthiipo Nnyizinku awaarumiyeezo. Arawu khushashula pakhora etile, khujapha maati a mmuttho Firawuuna ari attaapho na mashawuriiya awe, maati apale ooshi khuthatuwa taamu. ");
INSERT INTO eko_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Swi zooshi zaariimo mmuttho mphule khufwa khusala onukhamo woohifwayivo, Misuri khuhisala owahi onyweyawo maati a mmuttho mwaya mphule nti wooshi waarina taamu. ");
INSERT INTO eko_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Nayo anamajintta a Misuri khuretta etthiipo na ojuwa waya woojivitha, ila rooho ya Firawuuna nalelo khusala eri yawuuma khuhitakhi onsiileza Munsa na Arawu nkhama etthiipo Nnyizinku aalupiyeezo. ");
INSERT INTO eko_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Firawuuna khuzukuluwa khusala alawa owawe khuhijali epile zaya. ");
INSERT INTO eko_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Amisuri ooshi khulawa khuthipa nshini wa muuttho yoori apatthe maati oonywa, maana maati apale a mmuttho khaari onyweya. ");
INSERT INTO eko_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Zaaviriye siikhu sapa paata ya Nnyizinku othatusha maati apale a mmuttho. ");
INSERT INTO eko_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Nawiisha Nnyizinku khumuuza Munsa yoori: “Olawe wa Firawuuna wamuuze yoori Nnyizinku alupa toono: Owaalikhe atthu aka alawe akaaputu. ");
INSERT INTO eko_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Amana weeyo ohitakhi owaalikha olawa, kintta operekha pala ya anaphulu nti awo wooshi. ");
INSERT INTO eko_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mmuttho Niilu wooshimo anttela ottheerelanamo anaphulu awaatta, awelele afiye owawo okatthi wawo mpakha voolili vawo na mmanyupa wa mashawuriiya awo mpakha wa atthu awo ooshi na mphule enkhattiwaamo na enoochiwaamu phaawu. ");
INSERT INTO eko_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Anaphulu aya apo anttela wuuteela weeyo na mashawuriiya awo na atthu awo ooshi.” ");
INSERT INTO eko_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Aphano Nnyizinku khumuuza Munsa araka: “Omuuze Arawu yoori: Wookole nkhono awo othuule pakhora wookolele mmuttho, mmilipu na mmatthatta yoori owaawelelise anaphulu Misuri yooshi.” ");
INSERT INTO eko_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Arawu khookolela nkhono yawe maati a Misuri, anaphulu khuwelela khufinikha nti wooshi wa Misuri. ");
INSERT INTO eko_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Aphano anamajintta na ojuwa waya woojivitha khuwaapuwisa anaphulu Misuri yooshi. ");
INSERT INTO eko_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Firawuuna khuruma olawa okhuweliwa Munsa na Arawu khuwooza yoori: “Mwinvekele Nnyizinku akilaze anaphulu apa miiyo na atthu aka, yiiyaru etthiipo kintta owaalikha atthu apa alawe amwinkhe twaha Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Munsa khumuuza Firawuuna yoori: “Ruhusa ti yawo ya okuuza lini ontakhaaye yoori kuulompele weeyo na mashawuriiya awo, atthu awo ooshi, yoori weeyo na vaje vawo mwilaziwe anaphulu asale mmuttho paasi.” ");
INSERT INTO eko_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Firawuuna khujipu araka: “Meesho.” Munsa khuri: “Enttela wiiya etthiipo ojipwiyeezo opatthe ojuwa yoori khaavo anlikananaaye Nnyizinku Nluku etthu. ");
INSERT INTO eko_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Anaphulu antta wuulikha weeyo, vaje vawo, mashawuriiya awo na atthu awo; anttelaaye osala pi apale ari mmuttho paasi.” ");
INSERT INTO eko_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Aphano, Munsa na Arawu khulaavo aphale aarivo Firawuuna, Munsa khunvekela Nnyizinku mwaasa wa anaphulu, nkhama etthiipo aasilaniyeezo na Firawuuna. ");
INSERT INTO eko_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Nnyizinku khujipwelela oveka wa Munsa; anaphulu apale ooshi aari mmanyupa, vaje na mmashapa khufwa. ");
INSERT INTO eko_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Khulokottheliwa khuukeliwa nti opule khusala onukha woohifwayivo. ");
INSERT INTO eko_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ila wakathi Firawuuna ajuwiyeevo yoori avumula, khurutela wuumisa rooho yawe khuhinsiilezi theenya Munsa na Arawu, khwa epile alupiyeezo Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Nnyizinku khumuuza Munsa yoori: “Omuuze Arawu: Athuule pakhora yawo ookole nkhono ajaphe lifufu la vathi, lithatuwe liiye shaawa khwa Misuri yooshi.” ");
INSERT INTO eko_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Khuretta etthiipo; Arawu khookola nkhono awe na pakhora etile khujapha lifufu ntthile khuthatuwa khwiiya shaawa khuweetaala atthu mpakha nyama na nti aya opule wooshi khwiitaala shaawa. ");
INSERT INTO eko_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Anamajintta khweezelela etthiipo na ojuwa waya woovitheya ila khuhiwahi othatusha; shaawa epile khusala evira eweetaalaka atthu na nyama. ");
INSERT INTO eko_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Aphano anamajintta apale khumuuza Firawuuna yoori: “Eti yaala ya Nluku,” ila rooho yawe Firawuuna khuumisa khuhitakhi owaasiileza, nkhama etthiipo Nnyizinku aalupiyeezo. ");
INSERT INTO eko_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Aphano Nnyizinku khumuuza Munsa yoori: “Olankhe supuyeene wakutthanane Firawuuna ye onlawa omuttho, omuuze yoori: Nnyizinku alupa toono: Owaalikhe atthu aka alawe akaaputu. ");
INSERT INTO eko_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Amana weeyo ohiwaalikhi atthu aka olawa, kintta wuuperekheza pala ya mempe zawaatta yoori ziwiiphirise weeyo, mashawuriiya awo, atthu awo na mmavaje mwaya. Manyupa a Misuri na vathi anluwatthaavo zinttela wiitaalavo mempe. ");
INSERT INTO eko_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ila siikhu yaya etile kinttela otthantta khwa nanna yoofwarikhana nti wa Gosheeni, okhule aniikhalaawo atthu aka; khinteela opuwawo hatha pala moote ya mempe, yoori weeyo ojuwe yoori miiyo Nnyizinku kiri mmuti nttumphu. ");
INSERT INTO eko_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Kinlawa kawaafwarikhanise atthu aka na atthu awo. Meesho entta opuwa alama ya eto. ");
INSERT INTO eko_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Nnyizinku khuretta etthiipo, mempe zawaatta khwiitaala nnyupa wa Firawuuna na mmanyupa wa mashawuriiya awe, nti wooshi khwiiya wootapanyeya mwaasa wa mempe. ");
INSERT INTO eko_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Aphano Firawuuna khuruma okhuweliwa Munsa na Arawu khuwooza yoori: “Mwilawe mwamwinkhe twaha Nluku enu, mmuti nttumphu.” ");
INSERT INTO eko_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ila Munsa khujipu araka: “Khahi yoolikana fweeyo oretta toowo, maana twaha ninttelaaye omwinkha Nnyizinku Nluku eetthu, ti yoohifwayi khwa amisuri, amana niretta twaha nkhama eto anoonaaye ohifwayi, amisuri antta onuula na mawe. ");
INSERT INTO eko_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Nina yooretta safwari ya siikhu ttatthu niri ntarikhi neettaka n'yaara olawa omwinkha twaha Nnyizinku, Nluku etthu, nkhama etthiipo anuuziyeezo.” ");
INSERT INTO eko_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Aphano Firawuuna khulupa yoori: “Kintta wuulikhani mwilawe, mwamwaaputu Nnyizinku, Nluku enu n'yaara, ila mwiheette peetiwene, noofiya mwikilompele namiyo.” ");
INSERT INTO eko_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Munsa khujipu yoori: “Nasaapi eti amana kilaavo vakatthi vawo kinttela onvekela Nnyizinku; meesho mempe epo entta owaattuwa weeyo na mashawuriiya awo na atthu awo, ila safwatali ohikittettekhe theenya ohiwaalikhi atthu apa olawa omwinkha twaha Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Aphano Munsa khulaavo vakatthi wa Firawuuna khunvekela Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Nnyizinku khujipu lompa ya Munsa, mempe epile khumwaattuwa Firawuuna na mashawuriiya awe mpakha atthu awe, khuhisali hatha mempe moote. ");
INSERT INTO eko_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ila nalelo khusala ari wa wuumisa rooho, khuhitakhi owaalikha atthu apale olawa. ");
INSERT INTO eko_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Nawiisha Nnyizinku khumuuza Munsa araka: “Olawe wa Firawuuna wamuuze yoori: Nnyizinku, Nluku wa meepereewu, alupa toono: Owaalikhe atthu aka alawe akaaputu. ");
INSERT INTO eko_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Amana weeyo nalelo ohitakhi owaalikha olawa na khukhanyarela owaakhattaza, ");
INSERT INTO eko_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ojuwe yoori nkhono wa Nnyizinku ontta otiisa pala yawoopisa khwa nyama zawo ziriiye omashapa, khwa khavalo zawo, khwa apuuru awo, khwa nkamiiya zawo, khwa mompe zawo mpakha pwittipwitthi zawo. ");
INSERT INTO eko_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Na Nnyizinku onteela ophakula nyama za amisuri na epi za meezirayiilu, yoori ehifwe hatha nyama moote ya meezirayiilu.” ");
INSERT INTO eko_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Nnyizinku atthoma wakathi araka: “Meesho Nnyizinku ontta oretta mmuti mphu etile aahitiyeeyo.” ");
INSERT INTO eko_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Mmeesho mwaya Nnyizinku khuretta etthiipo: nyama za amisuri zooshi khufwa, ila za meezirayiilu hatha moote khuhifwi. ");
INSERT INTO eko_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Firawuuna khunruma ntthu olawa woona, khusikana hatha moote ya meezirayiilu ehifweeni; ye khuumisa rooho khuhitakhi owaalikha olawa atthu apale. ");
INSERT INTO eko_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Aphano Nnyizinku khumuuza Munsa na Arawu yoori: “Mwisavule fuutha ya vamafiya yawiitaala mmakhono Munsa amwazele otulu, Firawuuna ari attaapho. ");
INSERT INTO eko_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Entta othatuwa yiiye lifufu khwa nti wooshi wa Misuri, puupa entta owaapuwa atthu mpakha nyama, Misuri yooshi.” ");
INSERT INTO eko_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Yo khuthuula fuutha ya vamafiya khulawa wa Firawuuna; Munsa khumwazela fuutha etile otulu, puupa khuwaapuwa atthu mpakha nyama. ");
INSERT INTO eko_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Wala anamajintta khuhisala awahi omwaattama Munsa, mwaasa wa makhwatta, awaapatthiyeeyo vamote na amisuri ooshi. ");
INSERT INTO eko_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ila Nnyizinku khuumisa rooho ya Firawuuna, ye khuhinsiili Munsa na Arawu nkhama etthiipo Nnyizinku amuuziyeeyo. ");
INSERT INTO eko_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Nnyizinku khumuuza Munsa yoori: “Olankhe supuyeene olawe wakutthanane Firawuuna, omuuze oraka: Nnyizinku, Nluku wa meepereewu, alupa toono: “Owaalikhe atthu aka alawe akaaputu. ");
INSERT INTO eko_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Olikha toowo, swaafu eti pala yaka yooshi kinuutiisela omweenyewe, na mashawuriiya awo na atthu awo, yoori ojuwe yoori khina eeyiye nkhama miiyo olumwenku wooshi. ");
INSERT INTO eko_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Maana miiyo kinwahi wookola nkhono aka khuulwaaza weeyo na atthu awo khwa pala yaari owahaaye wuulazavo voolumwenku. ");
INSERT INTO eko_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ila miiyo kinuulikha weeyo ori haayi yoori kithoonyeze owahi waka, yoori nzina laka lilaleyiwe mmuti wooshimo. ");
INSERT INTO eko_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Nalelo ontta ojikhutupulana atthu aka, khuntakha owaalikha alawa? ");
INSERT INTO eko_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ila meesho wakathi otthuupu, kinlawa kanyise vuula ya mawe ehinanyeke nti opu wa Misuri thanku owaziwe mpakha leelo. ");
INSERT INTO eko_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Apho owaarume atthu awo alawe alokotthele nyama zawo ziriiye omashapa na vitthu zawo ziriiyo waaza atthu mpakha nyama ziriiyo. Amana ohilaziwo otana onti, khunyeliwa vuula ya mawe entta ofwa.” ");
INSERT INTO eko_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Akarumeya a Firawuuna aari woovaaye nttakhuzi la Nnyizinku khwaakuva khulawa khuwaalazawo, aviitthwaana aya mpakha nyama zaya khulawa khupwehiwa. ");
INSERT INTO eko_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ila apale ahaari woovaaye nttakhuzi la Nnyizinku khuwaalikha amwiitthwaana aya na nyama zaya omashapa. ");
INSERT INTO eko_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Aphano Nnyizinku khumuuza Munsa yoori: “Olanse makhono awo yoori ewaanyele vuula atthu, nyama, na miitthi zooshi za ntthuttu nti wooshi wa Misuri.” ");
INSERT INTO eko_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Munsa khulansa pakhora yawe khuthoonyeza otulu, Nnyizinku khuvumisa taari na vuula ya mawe, Nnyizinku khwiishusha ozerima na taari khwa nti opule wa Misuri na vuula ya mawe khusala enya. ");
INSERT INTO eko_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Vuula ya mawe na taari khuvuma yoopakhanyeya na mawe awoopisa ehinanyeke Misuri yooshi thanku ewaziwe. ");
INSERT INTO eko_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Misuri yooshi vuula etile khutapanya vitthu zaari mmashapa, waaza atthu, nyama na mathapa mpakha miitthi zooshi za ntthuttu. ");
INSERT INTO eko_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Khusala nti wa Gosheeni paasi, okhule aari wiikhalaawo meezirayiilu, okho khayaanyiyewo vuula ya mawe. ");
INSERT INTO eko_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Aphano Firawuuna khuruma olawa okhuweliwa Munsa na Arawu khuwooza yoori: “Swaafu eti kakosa. Nnyizinku ti wa shariya, ila miiyo na atthu aka, na makaafiri. ");
INSERT INTO eko_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Mwilompe wa Nnyizinku, maana ottitthima wa Nluku na mawe ankwaaye a vuula pi awaatta, miiyo kintta wuulikhani mwilawe mwiheekesele etthu kiina theenya.” ");
INSERT INTO eko_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Munsa khujipu yoori: “Amana miiyo kilaamo nsitati mphu kintta wookolela nkhono aka wa Nnyizinku. Taari enyamale na vuula yaamuse yoori weeyo ojuwe yoori olumwenku pi wa Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ila weeyo na akarumeya awo, miiyo kinjuwa yoori khamwinimoova Nnyizinku Nluku.” ");
INSERT INTO eko_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Alikutawu na ntthama zaharipweya mwaasa ntthama waarina phunje na alikutawu aaleyiye. ");
INSERT INTO eko_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Naye tiriku khayaaharipweyiye maana yaari ehinootthe. ");
INSERT INTO eko_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Munsa khulaavo aphale aariivo Firawuuna na nsitati mphule, khumookolela nkhono Nnyizinku, taari na vuula khwiisha. ");
INSERT INTO eko_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Firawuuna nawoona yoori taari na vuula zeesha khurutela okufuru oomisaka rooho yawe na mashawuriiya awe. ");
INSERT INTO eko_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ari wawuumisa rooho etthiipo, khuhiwaalikhi meezirayiilu olawa, nkhama etthiipo Nnyizinku aamuziyeezo Munsa. ");
INSERT INTO eko_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Nnyizinku khumuuza Munsa yoori: “Olawe wakutthanane Firawuuna, maana miiyo koomisa rooho yawe na rooho za mashawuriiya awe, yoori miiyo kithoonyeze alama zaka epo vakatthi vaya yo, ");
INSERT INTO eko_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","na yoori mwiwaathatelele aaneenu na atuulwenu nanna miiyo kiwaahukhumwiyeezo amisuri na minjuza zootikinisa kirettiyeezo vakatthi vaya, khwa etthiipo pi mwinttelaavo ojuwa yoori miiyo ki Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Aphano Munsa na Arawu khulawa okutthanana Firawuuna, yo khumuuza yoori: “Nnyizinku, Nluku wa meepereewu alupa toono: ‘Mpakha lini weeyo okatthalaka ojipushuwisa mmakhono mwaka miiyo? Owaalikhe atthu aka alawe akaaputu. ");
INSERT INTO eko_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Amana okhanyarela ohitakhi owaalikha atthu aka olawa, meesho kintiisa pala ya Mapalaka mmuti mwawo. ");
INSERT INTO eko_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Yo anteela ofinikha vathi ohisala wooneyavo, maana anteela orafuna zooshi epile zaalikhiweeyo ti vuula ya mawe mpakha na miitthi epile zinphutuwaazo mmashapa; ");
INSERT INTO eko_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","anttela wiitaala nnyupa mwawo na mmanyupa wa mashawuriiya awo na wa amisuri ooshi. Vitthu amarehemu apapazenu ahooneeni siikhu epo eekhaliyeezo mphu mpakha leelo.” Elottelanaka Munsa khulankha khulaavo aphale aariivo Firawuuna. ");
INSERT INTO eko_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Aphano mashawuriiya a Firawuuna khusala alupa yoori: “Mpakha lini ntthu otu anituturushaka? Owaalikhe atthu apa alawe amwaaputu Nnyizinku Nluku aya. Khiniweeleya yoori Misuri yatapanyeya?” ");
INSERT INTO eko_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Aphano khuthuuliwa Munsa na Arawu opheya khulawaniwa mpakha wa Firawuuna, ye khuwooza yoori: “Ettani mwamwaaputu Nnyizinku, Nluku enu. Oweje, anlawaaye paani?” ");
INSERT INTO eko_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Munsa khujipu yoori: “Ninlawa na mashaapu etthu, na anakhuuluvale etthu, aaneetthu, pwittipwitthi zeetthu mpakha mompe zeetthu. Maana ninttela onrettela njampo Nnyizinku eetthu.” ");
INSERT INTO eko_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Firawuuna khuwooza yoori: “Mweeyo mwinttela onhithajiya Nnyizinku amana kuulikhani olawa na aakha enu na aana enu! Eto enthoonyeza yoori mweeyo mwinwaza shawuri zootakhala. ");
INSERT INTO eko_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Khahiyo toowo! Mwilawe alume-ru mwamwaaputu Nnyizinku maana eto ti waakivekeliyeeyo.” Munsa na Arawu khwiikariwa aphale aariivo Firawuuna. ");
INSERT INTO eko_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Aphano Nnyizinku khumuuza Munsa yoori: “Wookolele nkhono nti wa Misuri yoori ate nazope vathi apha arafune mathapa ooshi ariimo na zooshi epile zaalikhiweeyo ti vuula ya mawe.” ");
INSERT INTO eko_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Munsa khookola pakhora yawe ookolelaka nti wa Misuri, Nnyizinku khutiisa pheevo ya ntulayi khuvuma nthana wooshi mpakha osikhu. Noocha pheevo etile khutana nazope. ");
INSERT INTO eko_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Misuri yooshi khwiitaala nazope-ru woohilikhi hatha vahali, aari awaatta venkivene. Aari ahinapuwewo nkhama apo na paata ya opo khapuwiyewo theenya nkhama apo. ");
INSERT INTO eko_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Maana aafinikhiye phantte zinki za Misuri mpakha nti wooshi khwiiya wooriipa. Khurafuna zooshi epile zaalikhiweeyo ti vuula ya mawe, mathapa na mishumo za miitthi woohisali hatha etthu piishi waaza mmitthi mpakha mmashapa, nti wooshi wa Misuri. ");
INSERT INTO eko_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Firawuuna khuruma olawa okhuweliwa Munsa na Arawu woohirupazi, khuwooza yoori: “Kankosa Nnyizinku, Nluku enu na kookosani mweeyo! ");
INSERT INTO eko_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Apho kinuuvekelani yoori mwikiswaamihi twampi yaka swaafu eti theenya na mwinvekele Nnyizinku, Nluku enu yoori akilaze pala eti yoofwiwa.” ");
INSERT INTO eko_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Munsa paata ya olaavo aphale vaya aariivo Firawuuna khunvekela Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Aphano Nnyizinku khuvumisa pheevo yawaatta ya phalalazi, ethiito khukhupa mapalaka ooshi khwiitthela mpahari yookhuttuwa; khuhisalimo hatha lipalaka mmote nti opule wa Misuri. ");
INSERT INTO eko_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ila nalelo Nnyizinku khuumisa rooho ya Firawuuna; ye khuhitakhi owaalikha meezirayiilu olawa. ");
INSERT INTO eko_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Aphano Nnyizinku khumuuza Munsa yoori: “Makhono awo olansele pinkuuni yoori Misuri yooshi yiiye yoofinikhiwa ti yiiza yookhomaala.” ");
INSERT INTO eko_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Munsa khookolela nkhono awe otulu, Misuri yooshi khufinikhiwa ti yiiza yookhomaala khwa siikhu ttatthu. ");
INSERT INTO eko_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Khuhisala oonana mmote na nzaawe, khaarivo mmote aaliyeevo vahali aariivo khwa siikhu ttatthu; ila meezirayiilu ooshi mmanyupa mwaya yaarimo nuuru. ");
INSERT INTO eko_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Aphano Firawuuna khunkhuwela Munsa khumuuza yoori: “Ettani mwamwaaputu Nnyizinku enu. Ila esale pwittipwitthi zenu na mompe zenu paasi; ila aakha na aana mwilawane.” ");
INSERT INTO eko_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Munsa khujipu yoori: “Weeyo ona ya oninkha nyama za orettela twaha na olukuza, yoori nimwinkhe Nnyizinku, Nluku eetthu. ");
INSERT INTO eko_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Na nyama zeetthu nilawaka nintta othuula hatha likhope khalinsala, maana ninttela orumeyela etthiipo yoori nimwaaputu Nnyizinku Nluku eetthu, khanijuweeni nyama-ni ninttelaaye omwaaputu-na Nnyizinku mpakha ofiya.” ");
INSERT INTO eko_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ila Nnyizinku khuumisa rooho ya Firawuuna, ye khuhitakhi owaalikha olawa. ");
INSERT INTO eko_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Firawuuna khumuuza Munsa yoori: “Oleevo apha na ohirutelevo theenya! Siikhu onttelaavo okoona theenya ontta ofwa.” ");
INSERT INTO eko_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Munsa khuri: “Walikanisa! Akinteela woona theenya wuuso awo.” ");
INSERT INTO eko_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Nnyizinku khumuuza Munsa yoori: “Kinimperekheza pala moote theenya Firawuuna na Misuri yooshi. Khwa ethiito ye onlawa awaalikhe olaamo mmuti mphu mpakha onlawa aweekaremo eperepere. ");
INSERT INTO eko_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Apho owooze meezirayiilu ooshi, waaza alume mpakha aakha, yoori awaavekele anamwaattamanana aya vitthu za feeta na za tahapu.” ");
INSERT INTO eko_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Nnyizinku khuwaaretta yoori atthu awe apatthe wooneliwa-vahali pi amisuri. Theenya Munsa aari nlume nwulweene nti opule wa Misuri, waaza mmaasho wa mashawuriiya a Firawuuna mpakha wa atthu ooshi. ");
INSERT INTO eko_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Munsa khuri: “Nnyizinku alupa toono: ‘Osikhu layili kinvira Mmisuri. ");
INSERT INTO eko_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Aana ooshi aalume amwanzo a nti wa Misuri anttela ofwa, waaza mwaana wa mwanzo wa Firawuuna, anttelaaye orithi khukulu ya mfwalume, mpakha mwaana wa mwanzo wa njaazi ankholaaye khaazi yoochila na aana a mwanzo a nyama zaya. ");
INSERT INTO eko_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Misuri yooshi onlawa wapuwewo olila nwulweene; waari ohinapuwewo na ohinttelaaye opuwawo theenya. ");
INSERT INTO eko_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ila khwa meezirayiilu, waaza atthu mpakha nyama, wala mwanapwa khanlawa owahowula.’ Paata ya toowo, mwinttela ojuwa yoori Nnyizinku awavirikanisa amisuri na meezirayiilu. ");
INSERT INTO eko_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Aphano mashawuriiya awo ooshi apa, anlawa akeekese na akikokhorele, akivekelaka yoori: ‘Olawe na atthu awo ooshi.’ Attaaphale miiyo kinttela olaawo!” Munsa na okatipukha wawe channu khulaavo aphale aariivo Firawuuna. ");
INSERT INTO eko_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Aphano Nnyizinku khumuuza Munsa yoori: “Firawuuna khanteela wuusiilani, yoori minjuza zaka zeekezeleye nti wa Misuri.” ");
INSERT INTO eko_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Munsa na Arawu khuretta minjuza epile zooshi khwa Firawuuna; ila Nnyizinku khukhomaaza rooho ya Firawuuna, khuhisala atakha owaalikha olaamo mmuti mphule meezirayiilu. ");
INSERT INTO eko_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Nnyizinku khumuuza Munsa na Arawu nti wa Misuri yoori: ");
INSERT INTO eko_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Opu ona ya wiiya mweezi wa mwanzo wa mwaakha khwa mweeyo. ");
INSERT INTO eko_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Munsa na Arawu ana ya olupa yoori: “Ajaama ooshi a Ezirayiilu, siikhu ya khuumi ya mweezi otthuupu, alume ooshi ana yoovalula nshapi la pwittipwitthi leelume ya wakhula liphanko ya wakhula nyuupa. ");
INSERT INTO eko_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ojama amana wiiya vattitthiiru ohinwahaaye orafuna nyama yooshi, ona yoowaalaleya anamwaattamanana aya apale a kharipu awaameele nyama enwahaaye owaafiyela khwa hisapu ya atthu aya. ");
INSERT INTO eko_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Nyama yaya enttelaaye othawuliwa ena ya wiiya yeelume ya mwaakha mmote, yoohiirakali hatha vahali. Ena ya wiiya pwittipwitthi ama puuzi. ");
INSERT INTO eko_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Mwipwehe mpakha siikhu khumi na nne ya mweezi, mpakha wakathi ajaama ooshi a meezirayiilu anttelaaye oshija njuwa leettelaka otupweela. ");
INSERT INTO eko_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Mwittukunttele taamu yaya vatulu na mpavu wa milako za manyupa, apale mweeyo mwirafuniyeemu nyama. ");
INSERT INTO eko_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Osikhu otthuupo mwina ya orafuna nyama yoomanikhiwa va moottho, na mathapa oowaawa na phaawu yoohiina fwaramento. ");
INSERT INTO eko_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Mwihirafune nyama piishi wala yawiipikhiwa, ila yoomanikhiwa va moottho waaza eeshwa, moolu na marupo aya. ");
INSERT INTO eko_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Mwihisalise hatha etthu efiya supu; amana esala mwilukuze. ");
INSERT INTO eko_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Mwiwale, nzako n'yuunu, jampali mmoolu na mwikholele pakhora mmakhono, mwirafune wawaakuvavo; otu paashikowa wa Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Maana osikhu aya otthuupo kinttela ovira nti wa Misuri na kiwoole aana ooshi amwanzo aalume waaza atthu mpakha a nyama, na kiwaahukhumu a miluku ooshi a Misuri: Nnyizinku ti Miiyo! ");
INSERT INTO eko_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Taamu mwivaziyeeyo milako zenu enttela wiiya alama yoori ethoonyeze manyupa mwiniikhalaaye, amana kiwaavulalisaka amisuri, miiyo kinttela woona taamu kisala kuuvikanani wooheemeli yoori mwihiiye wootapanyiwa ti pala yaya eto. ");
INSERT INTO eko_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Mwitthapele siikhu ethiito nkhama njampo la tiini muupuwelele yoori ti miiyo, Nnyizinku, kirettiyeeyo epo. Mweeyo na peewu yenu mwina yooretta njampo la paashikowa khwa mileele. ");
INSERT INTO eko_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Nkatthi wa siikhu sapa mwina yooja phaawu yoohiina fwaramento. Siikhu yamwanzo mwilazemo fwaramento mmanyupa mwenu, maana wakhula otule anttelaaye oja etthu yawiiyana fwaramento, ntthu aya oto ontta wiikariwa vakatthi wa meezirayiilu. ");
INSERT INTO eko_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Siikhu yamwanzo na siikhu yasaapa ona yawiiyavo nthukumano ttakatthiifu, ahiiyevo hatha ntthu mmote antakhaaye okhola khaazi siikhu zaya epo, woohiiyi wenttekhezela etthu-yoojiwa ya wakhula siikhu; mwina yooretta ethiito paasi. ");
INSERT INTO eko_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Mwirette njampo la phaawu yoohiina fwaramento, maana siikhu yaya ethiito ti kilaziyeeyo nti wa Misuri mahimo a atthu ooshi a meezirayiilu. Mwitthapele siikhu yaya eto wiiye nrumo wa mileele, waaza wa apaapa mpakha wa aana aya. ");
INSERT INTO eko_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Mwina yoorafuna phaawu yoohiina fwaramento makaaripi siikhu yakhuumi na nne ya mweezi wamwanzo mpakha makaaripi siikhu zeettettaka eshiriini na moote. ");
INSERT INTO eko_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Siikhu epi sapa ahiiyevo ntthu mmote anttelaaye wiiyana fwaramento owawe. Wakhula antakhaaye oja etthu ya wiiyana fwaramento ontta wiikariwa muujama wa meezirayiilu, hatha nkhama mmalapo ama nnyunti. ");
INSERT INTO eko_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Mwihije hatha etthu ya wiiyana fwaramento mmanyupa mwenu wooshimo, ila mwina yooja phaawu yoohiina fwaramento.” ");
INSERT INTO eko_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Munsa khuruma okhuweliwa attunkhulu a atthu ooshi a meezirayiilu khuwooza yoori: “Mwinthawule nshapi la pwittipwitthi yoori ajaama ooshi a Ezirayiilu ashije pwittipwitthi ya Paashikowa. ");
INSERT INTO eko_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Mwithuule zankalala mwinaanise na taamu eriiye mpasiya mwittukunttele milako zenu vatulu na mpavu mwaya. Ahiiyevo hatha ntthu mmote antakhaaye osaruwa nnyupa mwawe mpakha ocha. ");
INSERT INTO eko_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Maana Nnyizinku aviraka mmuti mphule yoori awoole amisuri; amana oona taamu etile mwittukuntteliyeeyo nlako enu phantte na phantte na vatulu vaya, Nnyizinku onttela ovira attaapho khanlawa onlikha namatapanya ovira mmanyupa mwenu yoori awuuleeni. ");
INSERT INTO eko_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Mwipwehe nrumo opu mweeyo na aana enu ooshi khwa mileele. ");
INSERT INTO eko_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Amana mwifiya nti opule Nnyizinku awahitiyeenini owinkhani, mwina yooretta njampo ntthi. ");
INSERT INTO eko_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Aaneenu amana awuuzelani yoori: ‘Njampo laya ntthi maana aya niini?’ ");
INSERT INTO eko_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Mwiwaajipu yoori: ‘Twaha ya Paashikowa wa Nnyizinku, aviriyeeyo vatulu wa manyupa a meezirayiilu nti wa Misuri, na khwiinanela manyupa eetthu wakathi aari owoolaavo amisuri.” Attaaphale meezirayiilu khukokhora khumwaaputu Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Meezirayiilu khulaavo, khulawa khuretta nanna ethiitile Nnyizinku amuuziyeeyo Munsa na Arawu. ");
INSERT INTO eko_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Aphano osikhu layili, Nnyizinku khuwoola aana ooshi amwanzo a misuri, waaza mwaana wamwanzo wa Firawuuna, namarithi ofwalume awe, mpakha mwaana wamwanzo wa napherezu aari nkalapooso na theenya aana amwanzo a nyama. ");
INSERT INTO eko_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Osikhu otthuupule, Firawuuna na mashawuriiya awe ooshi na amisuri ooshi khulankha na wapuwiye olila nwulweene, maana khayaarivo nyuupa yahaafwiweemo. ");
INSERT INTO eko_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Osikhu otthuupule Firawuuna khuruma okhuweliwa Munsa na Arawu khuwooza yoori: “Mwileemo nasaapi mmuti mwaka, mweeyo na meezirayiilu! Mwilawe mwamwaaputu Nnyizinku enu, nkhama etthiipo mwivekiyeezo. ");
INSERT INTO eko_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Mwithuule pwittipwitthi zenu mompe zenu na puuzi zenu, nkhama mwaalupiyeezo na mwikiparikhiye theenya.” ");
INSERT INTO eko_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Amisuri aari owaakhanyarela atthu apale yoori aleemo mmuti mphule, alupaka yoori: “Amana mwihiliimo fooshi fweeyo nintta ofwa!” ");
INSERT INTO eko_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Aphano atthu apale khuthuula tiriku yookhattiwa yoohiina fwaramento, khuputaputela pasiya yaya vakuwo khuvikela mmafuzi. ");
INSERT INTO eko_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Meezirayiilu khushututela nrumo wa Munsa, khuwaavekela amisuri vitthu za feeta za tahapu na kuwo. ");
INSERT INTO eko_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Nnyizinku khuwaaretta atthu awe wooneliwa huruma pi amisuri, khwa nanna awenkhiyeevo etile avekiyeeyo; khwa etthiipo khuvulula maali zooshi za amisuri. ");
INSERT INTO eko_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Meezirayiilu khulankha khusala alawa mwentto khuvira Rameesi eettaka Sukooti. Aari alume alufu miiya sitha, ohiwaalaki aakha na aana. ");
INSERT INTO eko_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Khuntti khuluzeene zoofwarikhana za amalapo aawaalottiye, na theenya maphanko mawulu-mawulu a nyama, mompe, pwittipwitthi na puuzi. ");
INSERT INTO eko_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Khoocha phaawu zoohiina fwaramento khwa tiriku etile aathuuliyeeyo Misuri, maana khayaarina fwaramento mwaasa wawiikariwa Misuri, khuhiwahi otthenkeza etthu-yoojiwa. ");
INSERT INTO eko_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Meezirayiilu eekhaliye Misuri nyaakha miiya nne na talaathiini. ");
INSERT INTO eko_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Siikhu ethiito afisiyeevo nyaakha miiya nne na talaathiini, atthu ooshi a Nnyizinku eetta olaawo Misuri. ");
INSERT INTO eko_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Waari osikhu wa weekesela wa Nnyizinku yoori awaalazewo meezirayiilu Misuri wooshiwo. Tiito, osikhu nkhama otthuupu na yo anttela ojeekesela na ojama aya ontaaye mileele. ");
INSERT INTO eko_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Nnyizinku khumuuza Munsa na Arawu yoori: “Epi kano za Paashikowa: ahiiyevo hatha mmalapo mmote anttelaaye onja. ");
INSERT INTO eko_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Mwiitthwaana wawuuzanyiwa ona yonja Paashikowa, amana eeya wookhiriya. ");
INSERT INTO eko_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ila apale eettiye omaka na apale aateeliye okhola khaazi ahinje. ");
INSERT INTO eko_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Mweeyo mwina yonja nnyupa nttumpho aattaliweemo, mwihithuule hatha phittula moote mwisarulelaka vaje, wala mwihipweche hatha likhonkolo la nyama mwinttelaaye orafuna. ");
INSERT INTO eko_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Atthu ooshi a Ezirayiilu ana yontthapela Paashikowa. ");
INSERT INTO eko_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Wakhula mmalapo anikhalaaye nttumphu antakhaaye oretta njampo ntthi la Paashikowa wa Nnyizinku, mwina yowaakhiriyisa alume ooshi a muujama mwaya; apo ana yontthapela nkhama aana a muujama. Ahiiyevo ntthu woohikhiriyi anttelaaye ontthapela. ");
INSERT INTO eko_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Kano ethiito enttela orumeyeliwa pi anyunti na amalapo apale amakiyeemo.” ");
INSERT INTO eko_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Meezirayiilu ooshi khuretta nkhama etthiipo Nnyizinku amuuziyeezo Munsa na Arawu. ");
INSERT INTO eko_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Siikhu ethiitile Nnyizinku khuwaalazawo meezirayiilu Misuri, khuwaatthenkeza lihimo khwa lihimo. ");
INSERT INTO eko_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Nnyizinku khumuuza Munsa yoori: ");
INSERT INTO eko_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Okithawulele aana aalume ooshi a mwanzo. Aana aalume a mwanzo a meezirayiilu pi aka, khahiyo aana-ru paasi na nyama zooshi za mwanzo zeelume.” ");
INSERT INTO eko_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Aphano Munsa khuwooza atthu yoori: “Mwifikhirele siikhu eti mweeyo mwiliyeewo Misuri, nti opule mwarettiweeyo omwiitthwaana, maana Nnyizinku oolazaniwo okhule khwa owahi wa makhono awe. Tiito mwihije hatha etthu yootthiiwa fwaramento. ");
INSERT INTO eko_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Siikhu ethiiti ya mweezi wa Habibi mweeyo mwintta olaawo Misuri. ");
INSERT INTO eko_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Amana Nnyizinku oofisani nti wa akanaani, wa ahiiti, wa amoori, wa amwiivi na wa ayepuzi nti opule alaphaniyeeyo amarehemu apapazetthu yoori aari oteela owinkhani, nti liniittikhaawo leethi na asali, mweeyo mwina yooretta njampo ntthi mweezi otthuupu. ");
INSERT INTO eko_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Nkatthi wa siikhu sapa mwina yooja phaawu yoohiina fwaramento siikhu yaya eti ya saapa mwitthapele njampo la Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Mwije phaawu yoohiina fwaramento nkatthi wa siikhu sapa epo, mwihithuule hatha etthu yawiiyana fwaramento wala mmuti mwenu ehiiyemo. ");
INSERT INTO eko_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Siikhu yaya etile wakhula mmote ona yoomuuza mwanawe yoori: “Mwaasa wa epi Nnyizinku oretteliyeenini mwilankhaka Misuri.” ");
INSERT INTO eko_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Epi enttela wiiya nkhama alama ya mmakhono mwawo na opheleleza wa mmwishwa mwawo yoori oruma wa Nnyizinku wiiye vanlimi vawo, maana Nnyizinku oolaza Misuri khwa nkhono awe woowahi. ");
INSERT INTO eko_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Mwishututele nrumo opu khwa siikhu etthomiweeyo, mwaakha khwa mwaakha. ");
INSERT INTO eko_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Amana Nnyizinku oofisani nti wa akanaani na khuwinkhani, nkhama etthiipo alaphaniyeeyo mweeyo na amarehemu apapazenu, ");
INSERT INTO eko_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","mwinthawulele Nnyizinku aana ooshi amwanzo ovokoliwa aalume. Nyama za mwanzo ovokoliwa zooshi zeelume za maphanko enu pi za Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Mwiwoosuru aana a puuru ooshi a mwanzo mwipatilanaka pwittipwitthi, ila amana mwihitakhi owoosuru waya, mwivuje siiko zaya. Mwiwoosuru theenya aana enu ooshi aalume amwanzo. ");
INSERT INTO eko_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Meesho amana aaneenu awuuzelani yoori: ‘Maana aya niini?’ Mwiwooze yoori: ‘Khwa oowahi wa nkhono awe, Nnyizinku anilazawo Misuri, nti narettiweewo oviitthwaana. ");
INSERT INTO eko_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Wakathi Firawuuna aari okhijilaaye na okatthala onilikha olaawo, Nnyizinku khuwoola aana ooshi a mwanzo aalume mpakha aana a mwanzo a nyama. Tiito kinimwinkhaaye twaha Nnyizinku aana aalume a vitthu zooshi na niniwoosuru aaneetthu ooshi a mwanzo ovokoliwa.’ ");
INSERT INTO eko_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Eto enttela wiiya nkhama alama mmakhono mwenu na nthoonyezo wa vaachihi venu yoori Nnyizinku anilaza Misuri na owahi wa nkhono awe.” ");
INSERT INTO eko_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Wakathi Firawuuna awalikhiyeevo olaawo meezirayiilu, Nluku khawaavirisiye tarikhi ya Afiliishiti, yeettiye wiiyaru tarikhi yoofupheya. Khulupa yoori: “Yo amana awoomanana, talili anttela owaza orutela Misuri.” ");
INSERT INTO eko_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Etthiipile, Nluku khuwaazukulelisa atthu apale n'yaara mphule, phantte ya pahari yookhuttuwa. Meezirayiilu khulaawo Misuri khujitthenka yoori oomane. ");
INSERT INTO eko_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Munsa khuthuula makhonkolo a Yuusufu, mwaasa aalaphisaniye na aana a meezirayiilu wakathi aalupiyeeyo yoori: “Weekhweele Nluku onta awaakiseni mweeyo, amana mwilawaka mwithuulewo makhonkolo aka.” ");
INSERT INTO eko_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Meezirayiilu khulankha Sukooti khulawa khumaka Eeta, ohali yaaziyeewo yaara. ");
INSERT INTO eko_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Nnyizinku aari vamote na yo, nthana aari owaalokoza nkhama nripu la liwiku yoori eettette saana ntarikhi; amana wiiya osikhu eetta owaalokoza na nuuru ya nripu la moottho amwasikhelaka tarikhi; etthiipo pi aari owahaaye weettetta nthana na osikhu. ");
INSERT INTO eko_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Nripu la liwiku ntthile khalaari owaasusa meezirayiilu nthana, wala nripu la moottho opule osikhu khalaari owaasusa. ");
INSERT INTO eko_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Nnyizinku khumuuza Munsa yoori: ");
INSERT INTO eko_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Owooze meezirayiilu yoori asapuwe alawe amake kharipu ya Piharoote enakatthi-nakatthi ya Mikotooli na pahari. Mwamake nshini wa pahari omaasho ya Baale-Zefooma. ");
INSERT INTO eko_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Paata ya toole Firawuuna khusala oopuwela yoori meezirayiilu antta ojeettettela athowelela n'yaara. ");
INSERT INTO eko_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Khwa etthiipo kinlawa koomise rooho ya Firawuuna, ye onlawa awiikariseni, paata ya toowo miiyo kinlawa kattitthimisiwe vakatthi wa Firawuuna na anajanka awe ooshi. Amisuri anlawa ajuwe yoori miiyo ki Nnyizinku.” Meezirayiilu khuretta etthiipo. ");
INSERT INTO eko_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ila wakathi ooziweevo mfwalume wa Misuri yoori meezirayiilu atthira, ye na anakhaazi awe khuzukulisa akhili zaya na khulupa yoori: “Niini nirettiyeeyo? Nawaalikha meezirayiilu olawa anaashikha amwiitthwaana etthu!” ");
INSERT INTO eko_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Aphano mfwalume khuruma weetteliwa nkukutta awe wa viittha na anajanka awe. ");
INSERT INTO eko_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Khuthuula theenya mikukutta miiya sitha epile zookhomaala na mikukutta zooshi za Misuri na anamalokozela ooshi. ");
INSERT INTO eko_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Nnyizinku khukhomaaza rooho ya Firawuuna mfwalume wa Misuri, khusala aweekarisa meezirayiilu aaliiyewo khwa nanna wooshinttavo. ");
INSERT INTO eko_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Firawuuna khusala aweekarisa na khavalo zawe zooshi, mikukutta zawe zooshi na anakhavalo awe na anajanka awe, khuwaasikana amakiye nshini wa pahari kharipu ya Piharoote omaasho wa Baale-Zefooma. ");
INSERT INTO eko_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Firawuuna asaleelaka owaasikana, meezirayiilu khweekesa nyuma khuwoona amisuri eettaka ota phantte etile aariiwo. Khuwaapattha woova channu, khusala ankhuwela Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Na khumuuzela Munsa yoori: “Misuri zeetta othowawo vilalo tiito onilaziyeewo yoori nite nifwele n'yaara mphu? Niini eti weeyo oniretteliyeeyo, yoonilazawo okhu? ");
INSERT INTO eko_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Tiito nawuuziyeeyo Misuri yoori: ‘Onilikhe niiye aviitthwaana amisuri! Afwataali wiiya amwiitthwaana amisuri ehiiyeeni ofwa n'yaara.” ");
INSERT INTO eko_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Munsa khuwaajipu atthu apale yoori: “Mwihoove, mwiiye wookhomaala na moone nusura Nnyizinku anttelaaye wuutiselani leelo. Maana khamwinttela owoona theenya amisuri apa mwiniwoonaaye leelo. ");
INSERT INTO eko_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Nnyizinku onttela wuumana mwaasa wa mweeyo, mwiiye woonyamala.” ");
INSERT INTO eko_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Khulupa theenya Nnyizinku amuuzaka Munsa yoori: “Mwaasa aya niini mwikikhuwelaka miiyo? Owooze meezirayiilu avire alawaka. ");
INSERT INTO eko_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Weeyo olanse pakhora yawo ojaphe maati, antta waawanyeya yoori meezirayiilu alokhe eri tuulu yawuuma. ");
INSERT INTO eko_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Miiyo kinttela wuumisa rooho za amisuri, yo anttela wuulottelelani mpahari nttumpho. Miiyo kinttela wiiya woottitthimisiwa amana kinshintta mfwalume wa Misuri na anajanka awe ooshi na mikukutta zawe zooshi za nvittha na anakhavalo awe ooshi. ");
INSERT INTO eko_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Amisuri anttela ojuwa yoori miiyo ki Nnyizinku amana kittitthimisiwa khwa Firawuuna na mikukutta zawe na anakhavalo awe.” ");
INSERT INTO eko_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Aphano nlayikha la Nluku ntthile lawaalokoziyeeyo atthu a Ezirayiilu khuwaalikha khurutela nyuma waya; theenya nripu la liwiku khuwaalikha khurutela nyuma waya, ");
INSERT INTO eko_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","khwiiya vakatthi wa amisuri na meezirayiilu. Liwiku laari wiiya looripa phantte ya amisuri khusala liwaamwasikhela meezirayiilu; mwaasa wa ethiito khuhisala liwaattamanisa meezirayiilu na amisuri osikhu wooshi. ");
INSERT INTO eko_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Munsa khookolela nkhono awe pahari, Nnyizinku khuvumisa pheevo zookhomaala za ntulayi osikhu wooshi mpakha pahari waawanyeya khupuwa mishaka zawuuma mwaasa wa waawanyeya wa maati. ");
INSERT INTO eko_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Meezirayiilu khulokha vakatthi wa maati khwa mishaka zawuuma, khupuwa muuri phantte ya nkhono nlume na nkhono nkha. ");
INSERT INTO eko_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Amisuri khusala aweekara na khavalo zaya zooshi, mikukutta zaya za nvittha na anakhavalo ooshi a Firawuuna khusala awaalotta mpakha vakatthi wa pahari. ");
INSERT INTO eko_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Osaleelaka ocha nkatthi wa nripu la moottho na la liwiku, Nnyizinku khuwoona anajanka amisuri khuwaakarawela. ");
INSERT INTO eko_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Khuretta etthu yoophara maroota za mikukutta za amisuri nkhama ahaari ojuwaaye weettettisa na khusala akhuwa araka: “Nlaweni niwaatthire meezirayiilu! Nnyizinku ontta wuumanana amisuri khwa zwaamu yaya yo.” ");
INSERT INTO eko_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Nnyizinku khumuuza Munsa yoori: “Wookolele nkhono awo khwa pahari, yoori maati awaakhutele amisuri na mikukutta zaya na anakhavalo aya.” ");
INSERT INTO eko_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Munsa khookolela nkhono awe pahari osaleelaka ocha, maati khurutela etthiipile aariizo. Wakathi amisuri aari ariiye atthire, khukutthanana maati a pahari, aphano Nnyizinku khuwaakhutela na pahari. ");
INSERT INTO eko_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Maana maati aarutiye khukhutela mikukutta na anakhavalo, na anajanka ooshi a Firawuuna eeshukheliyeeyo mpahari; hatha mmote khaarutiye. ");
INSERT INTO eko_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ila meezirayiilu khulokha pahari etile eettaka oluwatthela mishaka, maati aari nkhama muuri phantte ya nkhono nlume na phantte ya nkhono nkha. ");
INSERT INTO eko_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Etthiipile Nnyizinku khuwoosuru meezirayiilu siikhu etile mmakhono wa amisuri, na meezirayiilu khuwoona amisuri ari oofwa mmattima wa pahari etile. ");
INSERT INTO eko_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Meezirayiilu khoona owahi nwulweene wa Nnyizinku na khumoova Nnyizinku aya na khunkhupali Nnyizinku na Munsa karumeya awe. ");
INSERT INTO eko_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Aphano Munsa na aana a meezirayiilu khumwiipela liipo ntthi, Nnyizinku yoori: “Kinimwiipela Nnyizinku, mwaasa yoori ashintta wooshapweyavo, khutupweeza mpahari khavalo na anakhavalo aya. ");
INSERT INTO eko_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Nnyizinku ti kuvu yaka na liipo laka, ye ti nusura yaka! Ye ti Nluku aka na miiyo kininsifu, ti Nluku wa papaaka na miiyo kinimwaaputu! ");
INSERT INTO eko_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Nnyizinku ti naviittha, nzina lawe ti Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Khutupweeza mpahari mikukutta za nvittha na anajanka a Firawuuna; anamalokozela awe apale awaakhupaliyeeyo khukhuteliwa ti pahari yookhuttuwa. ");
INSERT INTO eko_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Maati apale awiicha khuwaakhutela khwiiya oozama nkhama mawe. ");
INSERT INTO eko_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Oo Nnyizinku, nkhono nlume awo onaaye owahi nwulweene; Oo Nnyizinku, nkhono nlume awo wawaashijela maatuwi. ");
INSERT INTO eko_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Khwa owula wa ofwalume awo wawaakhitiri maatuwi awo, katapu yawo khuwaaja nkhama malala. ");
INSERT INTO eko_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Khwa ovitelela wa phula yawo maati na mawipi ajikusanya khujakhuwa nkhama muuri, vathi wa pahari khwiiya awuuma nkhama liwe la manlela. ");
INSERT INTO eko_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Maatuwi khusala alupa yoori: ‘Niweekarise niniwaasikana niwaanyakanye maali nafusi zeetthu zinlawa zatoshiwe pi yo, nasarule phanka yeetthu na makhono eetthu niniwaatapanya.’ ");
INSERT INTO eko_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Khuperekha pheevo yawo, na pahari khuwaafinikha. Khuzama nkhama chumpwi mpahari wawiichamo. ");
INSERT INTO eko_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Khaziivo miluku zinlikananaaye weeyo oo Nnyizinku. Khaavo woottitthimisiwa woottakatthifu, wawoopisa khwa oretta vitthu zootikinisa na oretta minjuza. ");
INSERT INTO eko_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Wookoliye nkhono nlume awo nti khuwaamiza. ");
INSERT INTO eko_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Khwa pheta yawo wawaalokoza atthu awo apale owoosuruyeeyo; na kuvu zawo, khuwaattha puuro yawo yoottakatthifu. ");
INSERT INTO eko_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Khapila khusiila epile onrettaazo, khusala zithukumela na woova. Afiliishiti khuwaapattha huzuni. ");
INSERT INTO eko_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Attunkhulu a Meedomu khwiiya ooshanka na anamalokozela a amowaabu khuwaapattha othukumela; akanaani khuwaapattha otteettheya. ");
INSERT INTO eko_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Osuthuwa na woova khuwaapattha khwa owahi wa nkhono awo, khuhisala asakhinyeya nkhama mawe mpakha ovira atthu awo, Oo Nnyizinku, mpakha ovira atthu apale owoozanyiyeeyo. ");
INSERT INTO eko_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Oo Nnyizinku, weeyo oniwalawana na waweekhaze vamwaako wa eritho yawo puuro ttakatthiifu nyuupa yawo ojekiyeeyo na makhono awo. ");
INSERT INTO eko_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Nnyizinku mfwalume wa mileele.” ");
INSERT INTO eko_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Wakathi khavalo za Firawuuna na mikukutta zawe za nvittha na anakhavalo awe eettiyeevo mpahari, Nnyizinku khuwaazamisa a Misuri na maati a pahari etile; ila meezirayiilu aaviriye mwentto aluwatthelaka mishaka zawuuma vakatthi wa pahari. ");
INSERT INTO eko_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Nhupiri Miiriyamu nlupuwe Arawu khuthuula nttowu na aakha ooshi khusala anlotta eettaka opiya na wiina. ");
INSERT INTO eko_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miiriyamu aari owaajipu eettaka wiipa araka: “Nimwiipele Nnyizinku, mwaasa yoori ashintta wooshapweyavo. Khutupweeza mpahari khavalo na anakhavalo aya.” ");
INSERT INTO eko_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Aphano Munsa khuwaalokoza meezirayiilu waaza pahari yookhuttuwa mpakha n'yaara ya Shuuri. Siikhu ttatthu eettaka weettetta n'yaara ahipatthaka maati. ");
INSERT INTO eko_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Aphano khufiya Maara, ila khuhiwahi onywa maati ottuukho mwaasa wa owaawa. Ti maana aya wiittheliweeyo nzina la Maara. ");
INSERT INTO eko_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Tiito meezirayiilu khusala amwaapa Munsa araka: “Ninttela onywa-ni?” ");
INSERT INTO eko_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Munsa khunkhuwela Nnyizinku ye khuthoonyeziwa muutthi khuthuula khweeselela mmaati khwiiya ootuva. Puuro etile ya Maara Nnyizinku khuwenkha kano na oruma na khuweeza, ");
INSERT INTO eko_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","awoozaka yoori: “Mweeyo amana mwinsiileza Nnyizinku, Nluku enu na osiileza etile enintuvelaaye na khusiileza mirumo zawe na khushututela kano zawe zooshi, khamwiniiyana hatha orati opule kiwaatiseliyeeyo amisuri, maana miiyo ki Nnyizinku anvonisaaye. ");
INSERT INTO eko_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Aphano khufiya nti wa Elimu, ottuukho zaariiwo milipu khumi na miwiri na mikokonoothi sapiyiini; khumaka ottuukho khwaattamela maati. ");
INSERT INTO eko_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Mahimo a atthu a meezirayiilu khulankha nti wa Elimu khulawa mpakha yaara ya Siimu, eriiye enakatthi-nakatthi ya Elimu na Sinaayi. Zaari siikhu khumi na thaanu ya mweezi wa phiiri paata ya olaawo Misuri. ");
INSERT INTO eko_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","N'yaara mphule mahimo a atthu a meezirayiilu khusala amwaapa Munsa na Arawu. ");
INSERT INTO eko_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Alupaka yoori: “Afwataali nkhono wa Nnyizinku onuuleeliye Misuri! Maana okhu fweeyo naari wiiya nshini wa vikhalako za nyama na naari ojaka etthu-yoojiwa woohiivo hatha shaakha mpakha orupala, ila mweeyo khunitiisa n'yaara mphu yoori mwinuule jala fooshi fweeyo.” ");
INSERT INTO eko_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Aphano Nnyizinku khumuuza Munsa yoori: “Miiyo kintta okwisa etthu-yoojiwa ya pinkuuni. Atthu nka asaruwaka na olokotthela wakhula siikhu khwa khiima eniwaafiyelaaye siikhu yaya etile, khwa etthiipo kinttela oweeza yoori kiwoone nkhama yo anshututela kano yaka. ");
INSERT INTO eko_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Siikhu ya sitha mwina yoolokotthela swaafu piiri zayita epile mwinlokotthelakaaye siikhu kiina zaya.” ");
INSERT INTO eko_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Aphano Munsa na Arawu khuwooza meezirayiilu ooshi yoori: “Makaaripi mwinttela ojuwa yoori ti Nnyizinku oolaziyeenini nti wa Misuri, ");
INSERT INTO eko_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","meesho supu mwinttela woona siifwa ya Nnyizinku maana asiila waapa wenu. Fweeyo na paani mwinnaapaaye?” ");
INSERT INTO eko_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Khurutela olupa theenya araka: “Nnyizinku oniwinkhani nyama yoorafuna makaaripi na etthu-yoojiwa ya supu yoori mwirupale, maana asiila waapa wenu. Fweeyo na a paani? Mweeyo khamwinnaapa fweeyo, ila Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Munsa khumuuza Arawu yoori: “Wuuze mahimo a atthu ooshi a meezirayiilu oraka: Mweette mmakhono wa Nnyizinku, maana asiila waapa wenu”. ");
INSERT INTO eko_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Arawu eettaka ottakhulana meezirayiilu, ooshi khusala eekesa phantte ya n'yaara na siifwa ya Nnyizinku khupuwa mmawiku, ");
INSERT INTO eko_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","na Nnyizinku khumuuza Munsa yoori: ");
INSERT INTO eko_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Kinsiila waapa wa meezirayiilu, ila owaajipu yoori: ‘Njuwa leettelaka otupweela mweeyo mwinrafuna nyama, na supu mwiniiyana-yoojiwa ya wuutoshani. Toowo mwinttela ojuwa yoori miiyo ki Nnyizinku Nluku enu.” ");
INSERT INTO eko_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Makaaripi khupuwa khwaali khwiitaala aphale aamakiyeevo, supu waarivo mmatte phantte yaya etile. ");
INSERT INTO eko_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Wakathi mmatte opule wuumiyevo, vathi aphale khupuwa vitthu nkhama mavalako zoolattanana cheelu vatulu wa nshaka. ");
INSERT INTO eko_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Wakathi meezirayiilu ooniyeevo vitthu epile, khwaaza wuuzelana atthaaporu araka: “Niini epiza?” Maana khaari ojuwa etthu yaari orettikhanaaye. Elottelanaka, Munsa khuwooza yoori: “Eti etthu-yoojiwa Nnyizinku awinkhiyeenini yoori mwije. ");
INSERT INTO eko_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Nnyizinku khurumisa yoori: ‘Wakhula mmote wa mweeyo ona yookusanyela epile antakhaaye yoori aje, khwa hisapu ya atthu ariina vaje vawe, ttompwiyo piiri wakhula ntthu.” ");
INSERT INTO eko_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Meezirayiilu khuretta etthiipo ooziweezo; akina khukhupa zawaatta, akina vattitthiiru. ");
INSERT INTO eko_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Wakathi aphimiyeeyo na ttompwiyo, otule aalokottheliyeeyo zawaatta na otule alokottheliyeeyo vattitthiiru ooshi khupattha sawa-sawa. Wakhula mmote aapatthiye epile aari ohithajiyaaye oja. ");
INSERT INTO eko_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Munsa khuwooza yoori: “Ahiiyevo hatha mmote antakhaaye opweha yoori aje meesho.” ");
INSERT INTO eko_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ila yo khuhinsiilezi Munsa, akina khulikha vattitthiiru mana aya yoori aje mmeesho mwaya; ochiyeevo khwiitaala nyunku na khusala anukha. Munsa khuwaakatipukhela yo venkivene. ");
INSERT INTO eko_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Wakhula siikhu supu, yo eetta olokotthaka epile aari otakhaaye oja, maana haari ya njuwa yeetta othulushaka etile yaari osalaaye vathi. ");
INSERT INTO eko_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Siikhu ya siitha, khulokottha swaafu piiri, theenya ttompwiyo phiiri khwa wakhula ntthu; attunkhulu a atthu khulawa omuuza Munsa. ");
INSERT INTO eko_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Khuwaajipu Munsa araka; “Nnyizinku aruma yoori: ‘Meesho enttela wiiya siikhu yoovumula, Saapatu ttakatthiifu ya Nnyizinku etile mwintakhaaye wuumisa vamoottho muumise na etile mwintakhaaye wiipikha na maati, mwiipikhe, zooshi zinttelaaye osala mwipwehe mpakha mmeesho mwaya.” ");
INSERT INTO eko_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Khupweha mpakha mmeesho mwaya nkhama etthiipo Munsa aalupiyeezo; wala khuhivutti na hatha nyunku khuhiina. ");
INSERT INTO eko_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Aphano Munsa khulupa yoori: “Mwije leelo maana Saapatu ttakatthiifu ya Nnyizinku maana leelo khamwinsikanavo hatha etthu valipuwa. ");
INSERT INTO eko_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Siikhu sitha mwina yoolokotthela ila siikhu ya saapa, Saapatu, khazinteela wiiyavo.” ");
INSERT INTO eko_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Siikhu ya saapa aalankhiye atthu onlawa olokottha ila khuhisikani. ");
INSERT INTO eko_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Aphano Nnyizinku khumuuza Munsa yoori: “Mpakha lini mwikhijilaka oshututela mirumo zaka na kano zaka? ");
INSERT INTO eko_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Moone yoori Nnyizinku awinkhani Saapatu, tiito siikhu ya siitha oniwinkhani etthu-yoojiwa ya siikhu piiri yoori siikhu ya saapa wakhula ntthu eeye attaaphale aniiyaavo ahiiyevo ntthu antakhaaye weettetta.” ");
INSERT INTO eko_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Aphano atthu apale khuvumula siikhu ya saapa. ");
INSERT INTO eko_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Atthu a Ezirayiilu khutthaja etthu-yoojiwa etile nzina la mana. Zaari nkhama peewu ya phunje zoolakala zootuva nkhama mishikoto za asali. ");
INSERT INTO eko_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Munsa khulupa araka, “Nnyizinku aruma yoori: ‘Mwilokotthele mana apa ttompwiyo moote mwipwehe, yoori khapila entaaye yoone etthu-yoojiwa mwenkhiweeyo ti Nnyizinku wakathi oolaziyeenini Misuri.” ");
INSERT INTO eko_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Aphano Munsa khumuuza Arawu yoori: “Othuule ttompwiyo moote ya mana, otthe mmakhono wa Nnyizinku, yoori epweheliwe khapila eto entaaye.” ");
INSERT INTO eko_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Khwa oshututela etile Nnyizinku aamuuziyeezo Munsa, Arawu khuthuula mana apale khuttha mmakhono wa oshaahiti wa Mbwana. ");
INSERT INTO eko_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Meezirayiilu khuja mana nyaakha arupayiini mpakha ofiya nti waari wiikhaleyaaye; khuvira ajaka mpakha ofiya mmwiinano wa Kanaani. ");
INSERT INTO eko_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Mphimo waari ophimaniwaaye mana waari wiitthiwa ttompwiyo, phantte ya khuumi ya eefwa. ");
INSERT INTO eko_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Mahimo a atthu a meezirayiilu khulaamo n'yaara ya Siimutta, khusala eettetta avumulaka alawaka, nkhama etthiipo aarumiyeeyo Nnyizinku. Khumaka Refidimu ila khaariwo maati oonywa. ");
INSERT INTO eko_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Mwaasa wa ethiito khusala anyakulisana na Munsa araka: “Oninkhe maati oonywa.” Ye khuwaajipu yoori: “Mwaasa wa niini mwinyakulisanaka na miiyo? Mwinimweezelani Nnyizinku?” ");
INSERT INTO eko_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ila atthu apale aarina nnyottha khusala omwaapa Munsa araka: “Waanilazeliyeniwo Misuri? Ontakha onuula na nnyottha na aana eetthu na nyama zeetthu?” ");
INSERT INTO eko_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Aphano Munsa khunyakula ankhuwelaka Nnyizinku araka: “Kiwaarettele niini atthu apa? Ansaleela okivonya na mawe!” ");
INSERT INTO eko_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Nnyizinku khunjipu yoori: “Olokoze, olawe wawaathuule attunkhulu a atthu a meezirayiilu na wiiyane pakhora mmakhono ethiito waapiyaniyeeyo muuttho Niilu, olawe. ");
INSERT INTO eko_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Woone, Miiyo kinttela wiiya ottuukho vatulu wa liwe la Horeepe. Weeyo opiye liwe laya, nttinttho lintta olaza maati yoori atthu apo anywe.” Munsa khuretta etthiipile, attunkhulu a meezirayiilu eettaka omoona. ");
INSERT INTO eko_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Puuro yaya etile khutthaja nzina la Maasa na Mariiba, maana aphale vaya meezirayiilu aanyakulisananiye na khumweeza Nnyizinku araka: “Nnyizinku ori vamote na fweeyo ama wala?” ");
INSERT INTO eko_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Elottelanaka khuta Amalekiita oteela owoomanana meezirayiilu nti wa Refidimu. ");
INSERT INTO eko_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Aphano Munsa khumuuza Yoshuwa yoori: “Owaathawule atthu aalume oomanane Amalekiita. Meesho kinttela wiiya vatulu wa mwaako na pakhora ya Nluku mmakhono mwaka.” ");
INSERT INTO eko_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yoshuwa khulawa wuumanana Amalekiita nkhama etthiipile Munsa aalupiyeeyo. Munsa, Arawu na Huri khuwelaza vatulu wa mwaako. ");
INSERT INTO eko_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Amana Munsa alansa makhono awe meezirayiilu eetta oshintta, amana eeshusha makhono awe Amalekiita ti aari oshinttakaaye. ");
INSERT INTO eko_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Amana makhono a Munsa ashokhera, Arawu na Huri eetta othuulaka liwe yoori Munsa eekhalevo. Oowiiri khukholelela makhono a Munsa, mmote nkhono nkha nkina nkhono nlume yoori makhono a Munsa eeye aweemela mpakha njuwa otupweela. ");
INSERT INTO eko_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Yoshuwa khuwaashintta sawasawa anajanka a Amalekiita na phanka. ");
INSERT INTO eko_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Aphano Nnyizinku khumuuza Munsa yoori: “Waatikhe hapari epi nkithaapu yoori zisala zuupuweleliwa na omuuze Yoshuwa yoori Amalekiita anttela wiiya oosahawiwa khwa mileele vathi wa olumwenku.” ");
INSERT INTO eko_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Munsa khunjeka alitaari na khuntthaja yoori: “Nnyizinku akinkha oshintta”, ");
INSERT INTO eko_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","na khuri: “Nkhono mmote vakhukulu ya Nnyizinku; Nnyizinku ori nvittha na Amalekiita khapila khwa khapila.” ");
INSERT INTO eko_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Aphano Yeeturu, haakhimu wa Miitiya, nkhwewe Munsa, khusiila vitthu zooshi Nluku anretteliyeeyo Munsa vamote na atthu a Ezirayiilu khwa nanna Nnyizinku awaalaziyeewo Misuri. ");
INSERT INTO eko_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Raku, Munsa amperekhiye Zipoora muukha awe owawe nkhwewe Yeeturu, ye khumpwekherela, ");
INSERT INTO eko_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","vamote na aana awe awiri. Mmote aya aari wiitthiwa Yeerisoni, maana aalupiye yoori “Miiyo kaasafireliye nti wa malaponi”; ");
INSERT INTO eko_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","nkina aari wiitthiwa Elizeeri, maana aalupiye yoori: “Nluku wa paapa ti eeyiye awuni yaka na akaawuni khwa phanka ya Firawuuna.” ");
INSERT INTO eko_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Aphano Yeeturu nkhwewe Munsa na muukhaawe Munsa na aanaawe awiri khulawa n'yaara omwaako wa Nluku okhule Munsa aamakiyeewo. ");
INSERT INTO eko_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yeeturu khurumisa nhupi wuuziwa Munsa yoori: “Miiyo, nkhwewo, kata na muukhaawo na aanaawo awiri.” ");
INSERT INTO eko_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Aphano Munsa khumwaattama nkhwewe khumwiinamela khumpatikha, khusala oozelana hapari mmote na nzaawe eettaka ovira nheema. ");
INSERT INTO eko_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Elottelanaka Munsa khwaaza omuuza nkhwewe vitthu zooshi Nnyizinku anretteliyeeyo Firawuuna na amisuri mwaasa wa pheta ya meezirayiilu na tafwawuthi zooshi akholiyeeyo ntarikhi na nanna Nnyizinku awaataphuliyeeyo. ");
INSERT INTO eko_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yeeturu noosiila mattakhuzi apale ooshapweya Nnyizinku awaretteliyeeyo meezirayiilu, awaataphulaka mmakhono wa amisuri, khwiiya woofurahi. ");
INSERT INTO eko_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yeeturu khulupa yoori: “Woottottopeliwa eeye Nnyizinku, ootaphuliyeenini mmakhono wa amisuri na mmakhono wa Firawuuna na khuwaataphula atthu awe vathi wa nkhono wa amisuri. ");
INSERT INTO eko_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Leelo kajuwa yoori Nnyizinku nwulweene zayita miluku zooshi, maana khwa vitthu epile aari ojikhutupulanaaye atapanya.” ");
INSERT INTO eko_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Aphano Yeeturu nkhwewe Munsa, khuretta twaha yoolukuziwa khwa Nluku; khuta Arawu na attunkhulu ooshi a meezirayiilu, yoori aje etthu-yoojiwa na nkhwewe Munsa omaasho wa Nluku. ");
INSERT INTO eko_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Mmeesho mwaya Munsa khwiikhala yoori aphuke onyakulisana wa atthu, atthu apale khweemela ya supu mpakha makaripi. ");
INSERT INTO eko_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Wakathi nkhwewe ooniyeevo epile aari owaarettelaaye atthu apale, khuri: “Eto onrettaayo niini? Weekhalela-ni atthu ooshi khweemela na khuuzukulela otthowe ya supu mpakha makaripi?” ");
INSERT INTO eko_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Aphano Munsa khumuuza nkhwewe yoori: “Mwaasa aya atthu apa anikiteela miiyo okuuzela vitthu za Nluku. ");
INSERT INTO eko_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Amana eeyana milattu zaya, antta okiteela yoori kiphuke mmote na nzaawe na kiwoozaka mwentto wa Nluku na kano zawe.” ");
INSERT INTO eko_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Nkhwewe Munsa khulupa yoori: “Eto onrettaaye khahiyo yooshapweya oretta. ");
INSERT INTO eko_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Weeyo na atthu awo mwinttela oshokhera, maana khaazi yaya eto ti yoolipa channu; khunwahi oretta otthowe. ");
INSERT INTO eko_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Osiile huula yaka! Miiyo kiniwinkha shawuri na Nluku ti eeye vamote na weeyo. Wiiye weeyo namalokozela wa atthu omaasho wa Nluku na othuula tafwawuthi zaya zooshi khwa Nluku. ");
INSERT INTO eko_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Owooze mwentto na kano na owaajuwise tarikhi ya weettettela na khaazi ya okhola. ");
INSERT INTO eko_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ila weeyo vakatthi wa atthu apo, owaathawule atthu a makhaamu ooretta etthu, oomoova Nluku, atthu a haakhi eniweephiraaye ophattha fwayita ya haraamu. Owenkhe ottunkhulu wa atthu alufu wa atthu miiya wa atthu hamusiini wa atthu khumi. ");
INSERT INTO eko_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Yo anttela wiiya vakatthi wa atthu yoori asala aphuka tafwawuthi zaya. Nka ootiiselaka weeyo tafwawuthi epile zoolipa; epile zookhweya anttela waattalela ottho. Amana oretta toowo enttela wiiya yookhweya khaazi yawo, maana yo anttela wuulikhela otthowe. ");
INSERT INTO eko_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Amana weeyo oretta etthiipo, nkhama Nluku anrumaazo, nka owahaka oshintta tafwawuthi zaya epo na atthu apa ooshi eettaka orutela onti tafwawuthi zaya ziri zawaattaleliwa.” ");
INSERT INTO eko_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Munsa khukhupalela wuuziwa ti nkhwewe na khuretta etthiipile ooziweeyo ti ye. ");
INSERT INTO eko_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Khuwaathawula atthu amakhaamu vakatthi wa meezirayiilu ooshi khuwaaretta wiiya anamalokozela atthu aya apale; nttunkhulu wa atthu alufu, wa atthu miiya, wa atthu hamusiini, na wa atthu khumi. ");
INSERT INTO eko_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Apa khwiiya nkhama anamaphuka awakhula siikhu, atafwawuthi za atthu. Amana wiiya mwaasa woolipa aari weettiseliwaka Munsa, amana ziiya zookhweya aari ophukaka atthaapo. ");
INSERT INTO eko_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Aphano Munsa khuleezanana nkhwewe Yeeturu khusala arutela owawe. ");
INSERT INTO eko_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Mweezi wa ttaatthu siikhu ethiitile, paata ya aana a meezirayiilu olaawo Misuri, khufiya mpakha n'yaara ya mwaako Sinaayi. ");
INSERT INTO eko_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Noolaawo Refidimu, khulawa mpakha n'yaara ya Sinaayi, meezirayiilu khulawa khumaka ottuukho omaasho wa mwaako Sinaayi. ");
INSERT INTO eko_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Elottelanaka Munsa khuwela vamwaako yoori akutthanane Nluku. Nnyizinku khunkhuwela vamwaako attaaphale araka: “Olupe mattakhuzi apa wuuzaka peewu ya Yaakhumpa, atthu ooshi a meezirayiilu yoori: ");
INSERT INTO eko_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Mweeyo moona etthu kiwaaretteliyeeyo amisuri na nanna kiwaathamisiyeeyo nkatthi wa mapaphelo a saaka kijitiiselaka miiyo. ");
INSERT INTO eko_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Aphano, amana mwikishututela wawaamineyavo mwisiila huula yaka na khuthokorela wahati aka, mweeyo mwinttela wiiya atthu aka, ootafikhana zayita khapila kiina, maana olumwenku wooshi pi waka. ");
INSERT INTO eko_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Mweeyo mwinttela wiiya ofwalume aka wa anamalokozela a tiini na khapila ttakatthiifu.’ Apo pi mattakhuzi onttelaaye owooza meezirayiilu.” ");
INSERT INTO eko_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Munsa khuruti khulawa khuwaakhuwela attunkhulu ooshi atthu a meezirayiilu na khuwooza zooshi Nnyizinku anrumiyeeyo olupa. ");
INSERT INTO eko_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Atthu ooshi khujipu wa swaafu moote yoori: “Ninretta zooshi Nnyizinku arumiyeezo.” Aphano Munsa khulawa khumuuza Nnyizinku mattakhuzi ajipwiyeeyo atthu apale. ");
INSERT INTO eko_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Nnyizinku khumuuza Munsa yoori: “Woone! Kinttela wuuttakhulana weeyo nkatthi wa liwiku looriipa yoori atthu amana akisiila kittakhulanaka weeyo asala ookhupali khwa mileele.” Aphano Munsa khumuuza Nnyizinku mattakhuzi ooziweeyo pi atthu apale. ");
INSERT INTO eko_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Nnyizinku khurutela omuuza theenya Munsa araka: “Olawe vakatthi wa atthu apo, wawaattakatthise leelo na meesho. Yo ana ya ofula kuwo zaya, ");
INSERT INTO eko_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","yoori eeye oolikana siikhu ya ttaatthu, maana siikhu ya ttaatthu Nnyizinku onttela wiishukha vamwaako Sinaayi, mooshi mweeyo mwimoone. ");
INSERT INTO eko_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Otthe mwiinano nkerekhere wa mwaako na owooze atthu yoori: ‘Eeyane phoole ya ohiweli mwaako na ohisapi. Otule anttelaaye osapa mwaako ona ya wuuliwa; ");
INSERT INTO eko_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ohinsape na nkhono ila onvonye na mawe ama nttetthe, hatha nkhama ntthu ama nyama, khiniiya haayi.’ Ila amana nlope livuma swaafu moote apho pi anttelaavo owela.” ");
INSERT INTO eko_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Munsa khwiishukhela aphale aariivo atthu apale khuwaattakatthisa na yo khufulaza kuwo zaya. ");
INSERT INTO eko_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Khuwooza atthu apale yoori: “Mwiiye woolikana ovirisa siikhu ya ttaatthu. Ila ahiiyevo antakhaaye okutthanana muukha awe.” ");
INSERT INTO eko_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Noocha, siikhu ya ttaatthu khupuwa taari na ozerima, liwiku looriipa khufinikha mwaako na khuvumisiwa nlope channu. Atthu ooshi khuwaapattha woova aphale aarivo. ");
INSERT INTO eko_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Munsa khuwaalazavo atthu apale aphale vaya yoori akutthanane Nluku, yo khulawa khweemela waattamanana mwaako. ");
INSERT INTO eko_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Mwaako Sinaayi wooshi weetaaliye loosi, maana Nnyizinku eeshukheliye attaapho na moottho, na loosi laya leetta owela nkhama loosi la vanjocho na mwaako wooshi weetta othukumela channu. ");
INSERT INTO eko_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ovuma wa nlope weetta ovira otepaka, elottelanaka Munsa khuttakhula na huula ya Nluku khunjipu. ");
INSERT INTO eko_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Nnyizinku khwiishukhela vatulu wa mwaako Sinaayi, khunkhuwela Munsa vatulu attaaphale Munsa khuwelela khulawa. ");
INSERT INTO eko_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Nnyizinku khumuuza Munsa yoori: “Wiishukhe wawooze atthu apo yoori ahivikane mwiinano atakhaka omoona Nnyizinku. Amana avikana enkeene antta ofwa. ");
INSERT INTO eko_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Hatha nkhama anamalokozela a tiini amana amwaattamelaka Nnyizinku ana yoojittakatthisa. Amana ahijittakatthisi Nnyizinku ontta owaatapanya.” ");
INSERT INTO eko_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Aphano Munsa khumuuza Nnyizinku yoori: “Atthu khanwahi owela vamwaako Sinaayi maana weeyo waanilikhisiye oraka: ‘Mwirette mwiinano omaasho wa mwaako mwiphakule.” ");
INSERT INTO eko_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Nnyizinku khunjipu Munsa amuuzaka yoori: “Wiishukhe orutele owela theenya, operekhiwaka ti Arawu. Ila anamalokozela a tiini na atthu ahirukhe mwiinano yoori awelele apha ariivo Nnyizinku, amana aretta toowo Nnyizinku ontta owaatapanya.” ");
INSERT INTO eko_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Aphano Munsa khwiishukha khulawa owooza atthu apale. ");
INSERT INTO eko_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Nluku alupa mattakhuzi ooshi apa araka: ");
INSERT INTO eko_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Miiyo ki Nnyizinku, Nluku awo, kuulaziyeeyo nti wa Misuri ohali waarettiweewo omwiitthwaana. ");
INSERT INTO eko_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Ohiiyane miluku mikina omaasho waka miiyo. ");
INSERT INTO eko_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Ohijaattalele sanamu wala ratarato ya etthu ya otulu wala ya vathi ama vathi a mmaati. ");
INSERT INTO eko_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ohikokhorele wala ohaaputu, maana Miiyo ki Nnyizinku, Nluku awo; kintakha wiiye waka paasi, kinoonaaye twampi za apaapa na kifikhirelaka twampi zaya khwa aana aya mpakha khapila ya ttaatthu ama yanne ya apale aari okiphiirisaaye, ");
INSERT INTO eko_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ila kintthantta na tthakaraka mpakha khapila alufu epile zinikiphetaaye na zinshututelaaye mirumo zaka. ");
INSERT INTO eko_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ohilupe nzina la Nnyizinku Nluku awo mahala, maana Nnyizinku khanlawa onlikha ahinhukhumweeni otule anlupaaye nzina lawe mahala. ");
INSERT INTO eko_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Wuupuwele Saapatu yoori siikhu ttakatthiifu. ");
INSERT INTO eko_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ona yookhola khaazi zawo zooshi siikhu sitha, ");
INSERT INTO eko_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ila siikhu ya saapa Saapatu ti yomwinkha Nnyizinku Nluku awo, siikhu yaya eti ohikhole hatha khaazi moote, waaza weeyo, mwanawo wa nlume ama wankha, wala mwiitthwaana awo wala njaazi awo, wala nyama zawo wala aletto ariiye nlikokoro mwawo. ");
INSERT INTO eko_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Maana khwa siikhu sitha, Nnyizinku eetta wumpa pinku na vathi, pahari na vitthu zooshi ziriimo, ila Saapatu khuvumula. Paata ya toowo, Nnyizinku khuparikhiya Saapatu ya etile na khuttakatthisa. ");
INSERT INTO eko_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Onshitahi papaawo na mamaawo, yoori wiikhale siikhu zawaatta vathi apha Nnyizinku, Nluku awo awinkhiyeeyo. ");
INSERT INTO eko_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Ohuule. ");
INSERT INTO eko_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Ohiraruwe. ");
INSERT INTO eko_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Ohiiye. ");
INSERT INTO eko_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Ohinlokoveze nzaawo. ");
INSERT INTO eko_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Ohilazele omaashokopho vaje wa nzaawo, wala muukha wa nzaawo, wala amwiitthwaana ama ajaazi awe, wala mompe zawe ama puuru zawe na wala etthu moote etile yiiyiye yawe.” ");
INSERT INTO eko_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Wakathi atthu apale aari osiilaavo taari na ozerima na ovuma wa nlope na khoona mwaako olazaka loosi, ooshi khusala athukumela mpakha osusela petiwene. ");
INSERT INTO eko_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Khumuuza Munsa yoori: “Weeyo ottakhulane ye, fweeyo nintta osiila. Ila Nluku amana attakhulana fweeyo nintta ofwa.” ");
INSERT INTO eko_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Munsa khuwooza atthu apale yoori: “Mwihoove! Nluku aateeliye oweezani, yoori mwisala mwimoova na ooweraweriseni twampi.” ");
INSERT INTO eko_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ila atthu apale nalelo khwiiya peetiwene, Munsa khusala avira aattamelaka liwiku ntthile looriipa aariivo Nluku. ");
INSERT INTO eko_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Nnyizinku khumuuza Munsa yoori: “Owooze meezirayiilu mattakhuzi apa yoori: ‘Mweeyo moona na maasho enu yoori pinkuuni kattakhulana mweeyo. ");
INSERT INTO eko_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Mwihaattale miluku za feeta wala miluku za tahapu yoori mwikiphakanyane. ");
INSERT INTO eko_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Mwikaattalele alitaari wa mattophe mwirettevo twaha ya olukuziwa na zaakha za heeri, pwittipwitthi na mompe zenu wakhula vahali mwinrettaavo nka mwifikhirelaka nzina laka, kintta wuuteelani mweeyo na kuparikhiyeni. ");
INSERT INTO eko_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Amana mwikijekela alitaari wa mawe mwihinjekane mawe ooshijaniwa zaana, eeyaru mawe awaattaliwa saana mwintta onkufurwela. ");
INSERT INTO eko_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Mwihinwele na shikatta alitaari aka amana mwinjekaka, maana mwintta onfulamela. ");
INSERT INTO eko_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Siikhu moote Nnyizinku anrumiye Yuunusa mwaana wa Amitayi yoori: ");
INSERT INTO eko_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Olankhe olawe sitati khuulu ya Neniive, walaleye ottuukhu, yoori miiyo kinjuwa zooshi zootakhala zaya anrettaazo.” ");
INSERT INTO eko_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Ila Yuunusa asiiliyeevo toole, khuwaza otthirela tuniya yoolepelana Neniive, antthiraka Nnyizinku. Khulawa mpakha sitati ya Yoope khusikana pankaya vapatari, yaari weettaaye Taarisi. Khuripha pasaji yawe, khweetta mpankaya yoori atthirele Taarisi, antthiraka Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Aphano, alawaka, Nnyizinku khuperekha pheevo ya waatta na pahari khutakhala khusala esaleela opwecheya pankaya. ");
INSERT INTO eko_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Mamalinyero ooshi khwiiya awoova, wakhula mmote wayo khusala akhuwa anvekelaka nluku awe, yoori apatthe wuusurukha, na khusala atupweeza mapwattha aya mpahari, yoori eveyaveye pankaya yaya. Wakathi aya opo Yuunusa, aarettiye eeshukheliye mpurawu eettaka olala ajisahawiye. ");
INSERT INTO eko_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Nahota khwiishukhela mpurawu mphule aari olalaamo Yuunusa, khumuuzela yoori: “Weeyo! Onlala-ni? Olankhe onvekele nluku awo! Khinjuweya anoonelaka huruma yoori anuusuru nihifwe.” ");
INSERT INTO eko_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Paata ya toole, mamalinyero khusiilana yoori: “Nlaweni neekese nasipu, ninjuwe nlupa otu anitotheliye hasara eti.” Yo khweekesa nasipu etile, khusala emoona Yuunusa. ");
INSERT INTO eko_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Khuuzeliwa Yuunusa: “Weeyo o nlupa onitotheliyeeyo hasara eti. Nkanuuze! Weeyo onkhola khazi-ni? Wala onlankha vayi? Nti awo nti-ni? Ama lihimo lawo lihimo-ni?” ");
INSERT INTO eko_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Ye khujipu araka: “Miiyo ki Mwipereewu, kinimwaaputu Nnyizinku, Mwennyewe pinku, otu ompiye nti na pahari.” ");
INSERT INTO eko_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Elottelanaka Yuunusa khuwooza yoori aari ontthira Nnyizinku. Wakathi ajuwaziyeevo etthu yaari onrettikhanelaaye, yo khwiiya ootepa woova, na khumuuzela Yuunusa: “Apho niini orettiyeeyo!” ");
INSERT INTO eko_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Pheevo yeetta otepa yaattaka, khufiyelela mamalinyero omuuzela Yuunusa: “Yoori pheevo na pahari eshapweye, fweeyo nuurettele niini?” ");
INSERT INTO eko_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Yuunusa khujipu araka: “Miiyo kajuwa yoori pheevo eti yapuwelela mwaasa wa miiyo. Apho, mwikitthempe mwikeeselele mpahari. Mwirettaru toowo, mwintta woona pahari na pheevo zinyamaliye.” ");
INSERT INTO eko_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Ila mamalinyero apale khuhintupweezazi, khwaaza ofuttha reemu na kuvu zaya zooshi yoori afiye vathi. Khuhisala ewaheya, mwaasa yoori pahari yeetta ovira etepaka otakhala. ");
INSERT INTO eko_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Yo khukhuwa ankhuwelaka Nnyizinku araka: “Oo, Nnyizinku, ohinilikhelele nifwaka mwaasa wa pinaatamu otu, na ohinikwisele paathuli ofwa wa mwinyi otu. Zooshi zarettikhana khwa nanna olakeliyeezo.” ");
INSERT INTO eko_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Nawiisha khuntthempaza Yuunusa khumweeselela mpahari. Aphano pahari na pheevo, zooshi khunyamala. ");
INSERT INTO eko_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Ooniyeevo toole, mamalinyero ooshi khwiiya awoova channu na khumwaaputu Nnyizinku. Khunrettelaza twaha na theenya ahiti. ");
INSERT INTO eko_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Amweeselelaziyeevo mpahari, Nnyizinku khuperekha swi khuluyeene yoori emmize Yuunusa, ye khwiiya mmatthupo wa swi siikhu ttatthu nthana na osikhu. ");
INSERT INTO eko_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Ari mmatthupo wa swi, ye khwaaza olompa anshukhurwelaka Nnyizinku awe: ");
INSERT INTO eko_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","“Nhuzuni mwaka kankhuweliye Nnyizinku, na aakijipwiye. Mithili za ahera kaakhuwiye na waasiiliye huula yaka. ");
INSERT INTO eko_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Waakitupweeziye mpahari wa wiichamo, nkatthi wa khilintti, nziko wa maati khukizukulela, na mawipi awo khukikhutela. ");
INSERT INTO eko_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Miiyo khulupa yoori keekareliwa peeti-wene na omaasho wawo weeyo Nnyizinku. Kinta kirutele woona theenya nyuupa yawo yoottakatthiifu? ");
INSERT INTO eko_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Maati khukifiya vakhulo, khilintti khukizukulela na mirawa khukizokonzela eeshwa yaka. ");
INSERT INTO eko_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Khuzama mpakha vanchina la nyaako, tuniya ya vathi, puuro enimfukelaaye ntthu khwa siikhu zooshi. Ila weeyo Mbwanaaka Nnyizinku khuusuru nafusi yaka nkhapuri mphule. ");
INSERT INTO eko_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Wakathi kaari osaleelaavo ofwa, koofikhiriye weeyo Nnyizinku, khuuperekheza lompa yaka, yoori efiye nnyupa mwawo woottakatthiifu. ");
INSERT INTO eko_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Apale anaputwaaye sanamu zoohiina fwayita, antarawu tthakaraka ya Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Ila miiyo kinteela wuushukhurwela Nnyizinku na maliipo a siifwa na owinkha twaha, na kinteela oretta eti kaahitiyeeyo, maana nusura ti yaawo weeyo Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Aphano, Nnyizinku khuruma swi etile, yoori yanchuwe Yuunusa nshini wa nttima. ");
INSERT INTO eko_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Aphano Nnyizinku khunruma Yuunusa swaafu ya phiiri yoori: ");
INSERT INTO eko_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Olankhe olawe sitati khuulu ya Neniive, walaleye ottuukhu mattakhuzi apa kinuurumaaye.” ");
INSERT INTO eko_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Ye khulankha khulawa Neniive, nkhama etthiipo Nnyizinku anrumiyeezo. Neniive yaari sitati khuluyeene ntthu aari wiishishaaye siikhu ttatthu eettaka weettetta mwentto. ");
INSERT INTO eko_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Ila ye n'oofiya sitati etile eettettiye siikhu moote, alaleyaka yoori: “Nkatthi wa siikhu arupayiini Nnyizinku onteela opwecha Neniive.” ");
INSERT INTO eko_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Aneniive khwiiya wonkhupali Nluku khulaleyana yoori afuke, waaza attunkhulu mpakha asimaana, ooshi khuwalaza saakhu. ");
INSERT INTO eko_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Hapari epile za Yuunusa zamfiyeliye mfwalume wa Neniive, ye khwiishukha vakhukulu yoohaakhimu, khuvula kuwo zoofwalume khuwala saakhu na khwiikhala vafuutha. ");
INSERT INTO eko_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Aphano khuruma olaleyiwa Neniive yooshi yoori: “Khwa nzina la mfwalume na mawaziri awe: Ahiiyevo atha ntthu mmote antakhaaye oja na onywa, wala ojisa na onywisa nyama zawe, mompe zawe ama pwittipwitthi zawe. ");
INSERT INTO eko_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Atthu ooshi awale saakhu, na awalise nyama zaya, na akhuwe khwa nzina la Nluku na kuvu zaya zooshi. Attharuwe oretta vitthu zootakhala na ohusuti. ");
INSERT INTO eko_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Khinjuweya Nluku omwiishelaka wiiphiiriwa wawe, anoonele huruma yoori nihifwe.” ");
INSERT INTO eko_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Wakathi Nluku ooniyeevo yoori alikhaza oretta vitthu zootakhala, ye khulikha etile aari wuupuwelaaye owaarettela na khuhiwaahukhumu. ");
INSERT INTO eko_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Erettiyeevo toole, Yuunusa khuhintuveli etile yaya, na khwiiya wookatipukha. ");
INSERT INTO eko_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Ye khusala amuuza Nnyizinku araka: “Oo Nnyizinku aka, khahiyo eti kaalupiiye nalelo kiri onti? Ti ethiito yaakipatthisiyeeyo otthira keettaka Taarisi. Miiyo kaajuwiye yoori weeyo o Nnyizinku wa tthakaraka na wa huruma, woovilela na woopheta channu, onaahitaaye ohukhumu ila khulevelela mmana wiiyavo othupwiya. ");
INSERT INTO eko_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Aphano Mbwanaaka okilaze nafusi yaka, kinhithari ofwa kihiiyeeni wiiya haayi.” ");
INSERT INTO eko_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Ye Nnyizinku khulupa: “Weeyo onaaye shariya yookatipukha?” ");
INSERT INTO eko_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Yuunusa aalawiye khwiikhala mashaarikhi ya sitati ethiitile. Khujeka lipantta lawe, khwiikhala vamwiivuuli, khusala aweja etthu-ni yaari weettelaaye orettikhana sitati etile. ");
INSERT INTO eko_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Aphano, Nnyizinku khootthisa nrayi khurapela vatulu valipantta aphale aariivo Yuunusa, yoori eeye vamwiivuuli na aawuneye haari. Nrayi opule waamwinkhiye furaha ya waatta Yuunusa. ");
INSERT INTO eko_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Ila mmeesho mwaya supuyeene, Nluku khumperekha mwanyanyama khurafuna nrayi opule, khuuma. ");
INSERT INTO eko_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Etthamu-tthamu ya njuwa, Nluku khuperekha pheevo ya mashaarikhi yoolukuza channu, naye njuwa khusala lipiyela veeshwa vawe Yuunusa, khusala asaleela ozileya. Eviriyeevo toole, ye khusala ajitakhela ofwa, na khuri: “Toono afwataali ofwa ehiiyeeni wiiya haayi.” ");
INSERT INTO eko_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Ila Nluku khumuuzela Yuunusa: “Weeyo onaaye shariya yookatipukha mwaasa wa nrayi?” Ye khujipu: “Ayo, kinaaye! Na ki wookatipukha kintakha hatha ofwa.” ");
INSERT INTO eko_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Aphano Nnyizinku khumuuza: “Weeyo onoonela huruma nrayi opo, ohikholeleeni khaazi wala ohiwuliseeni, woottha osikhu mmote na osikhu nkina khufwa. ");
INSERT INTO eko_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Ila Neniive awaakho atthu anzitaaye eshiriini wa miiya alufu, ahinjuwaaye othawula etthu yooshapweya wala etthu yootakhala, na nyama za waatta. Miiyo akaari oteela wiiyana huruma na sitati khuluyeene etile?” ");
INSERT INTO eko_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Eti warakha ya peewu na mazina aya a amarehemu a phantte ya Yinsa Al-Masiihu, peewu ya Daawuuda na Eburahiima. ");
INSERT INTO eko_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eburahiima khunvokola Esiyaakha; Esiyaakha khunvokola Yaakhumpa; Yaakhumpa khunvokola Yuuda na attwiize; ");
INSERT INTO eko_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuuda khunvokola Pereezi na Zeera, mamaawe aari Tamaara; Pereezi khunvokola Hezorooni, Hezorooni khunvokola Arawu; ");
INSERT INTO eko_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arawu khunvokola Aminataapi; Aminataapi khunvokola Nashooni; Nashooni khunvokola Salimooni; ");
INSERT INTO eko_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimooni khunvokola Bowaazi, mamaawe aari Rahaape; Bowaazi khunvokola Obeedi, mamaawe aari Ruuti; Obeedi khunvokola Yeese; ");
INSERT INTO eko_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","na Yeese khunvokola mfwalume Daawuuda. Daawuuda khunvokola Seleyimaana, mamaawe aari muukha wa Uriiya; ");
INSERT INTO eko_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Seleyimaana khunvokola Ropowaawu; Ropowaawu khunvokola Apiiya; Apiiya khunvokola Aasa; ");
INSERT INTO eko_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aasa khunvokola Zhuzaafwa; Zhuzaafwa khunvokola Joraawu; Joraawu khunvokola Uziiya; ");
INSERT INTO eko_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziiya khunvokola Jotaawu; Jotaawu khunvokola Akaaze; Akaaze khunvokola Ezakiiya; ");
INSERT INTO eko_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezakiiya khunvokola Manaase; Manaase khunvokola Amooni; Amooni khunvokola Joziiya; ");
INSERT INTO eko_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Joziiya khunvokola Jekoniiya na attwiize, wakathi eekareliweeyo Babilooniya. ");
INSERT INTO eko_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Paata ya weettaniwa Babilooniya: Jekoniiya khunvokola Sheyalitiyeeli; Sheyalitiyeeli khunvokola Zorobabeeli; ");
INSERT INTO eko_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabeeli khunvokola Apiwuute; Apiwuute khunvokola Eliyakhiimu; Eliyakhiimu khunvokola Azoori; ");
INSERT INTO eko_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoori khunvokola Satookhi; Satookhi khunvokola Akiini; Akiini khunvokola Eliwuuti; ");
INSERT INTO eko_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliwuuti khunvokola Eliyazaari; Eliyazaari khunvokola Maata; Maata khunvokola Yaakhumpa; ");
INSERT INTO eko_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","na Yaakhumpa khunvokola Yuusufu, manna wa Mariyamu, otule anvokoliyeeyo Yinsa, othuuto aniitthiwaaye Al-Masiihu. ");
INSERT INTO eko_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Khwa etthiipo waaviriye ojama khumi na nne waaza va Eburahiima mpakha Daawuuda, na khumi na nne waaza va Daawuuda mpakha va okholiwa olawaniwa Babilooniya, na khumi na nne waaza Babilooniya mpakha va ovokoliwa wa Yinsa. ");
INSERT INTO eko_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ovokoliwa wa Yinsa Al-Masiihu pi toono. Mariyamu ari wooposiwa ti Yuusufu ahinarapalelane, khwiimittha khwa Rooho Ttakatthiifu. ");
INSERT INTO eko_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ila Yuusufu, mposi awe, khwiiya ntthu wa shariya na woohitakhi ontwayifusha, ye khulakela sirini okayiri onrala. ");
INSERT INTO eko_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ila, paata ya wuupuwela vitthu epile, khumpuwelela nlayikha la Mbwana nkatthi wa olottha, khumuuza yoori: “Yuusufu, mwaana wa Daawuuda, ohoove ompokhera Mariyamu wiiya muukhaawo, maana ye eemittha khwa Rooho Ttakatthiifu. ");
INSERT INTO eko_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ye onteela ompattha mwaana, weeyo ontthaje nzina la Yinsa, maana ye onteela owoosuru atthu awe khwa twampi zaya.” ");
INSERT INTO eko_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Zooshi epo enteela orettikhana yoori ziretteye zooshi epile Mbwana alupiyeeyo khwa napiyu yoori: ");
INSERT INTO eko_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mwaari onteela wiimittha ampatthe mwaana, anttelaaye wiitthiwa Emanuweele, enlupaaye yoori ‘Nluku ori vamote na fweeyo’.” ");
INSERT INTO eko_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Paata ya olankha, Yuusufu khuretta etile nlayikha la Mbwana laamuziyeeyo khumpokhera Mariyamu muukhaawe. ");
INSERT INTO eko_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ye khaarapalelaniye mpakha ompattha mwaana. Khuntthaja nzina la Yinsa. ");
INSERT INTO eko_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Paata ya Yinsa ovokoliwa Belemu ya Yudeya yenzi ya mfwalume Herooti, ajuwi alankhiye malawa-juwa khuta Yeruzaleemu. ");
INSERT INTO eko_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Khuuzela yoori: “Mwaana ntteetthe otu avokoliweeyo, mfwalume wa mayaahuuti ori vayi? Fweeyo noona ntthottowa lawe malawa-juwa nateela omwaaputu.” ");
INSERT INTO eko_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Wakathi mfwalume Herooti asiiliyeevo epo zaya, khwiiya woovelavela, na atthu ooshi a Yeruzaleemu. ");
INSERT INTO eko_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Aphano khuwaakusanya mahaakhimu a tiini ooshi na anamanozela a kano, khuwoozela vayi aari weettelaawo ovokoliwawo Al-Masiihu. ");
INSERT INTO eko_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yo khunjipu yoori: “Belemu ya Yudeya, maana napiyu aatikha toono: ");
INSERT INTO eko_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Weeyo Belemu, ya nti wa Yudeya, weeyo hatha vattitthiiru khahi owoohafwiifweya khwa sitati khuulu za Yuuda, maana khwa weeyo onteela opuwa mfwalume anttelaaye oweettettisa atthu aka a Ezirayiilu.’” ");
INSERT INTO eko_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herooti khuwaakhuwela ajuwi sirini khuwoozela wakathi laapuwiyeeyo ntthottowa nttho. ");
INSERT INTO eko_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Aphano khuwaaruma Belemu awoozaka yoori: “Mwilawe mweekese ojuwa saaneene monkoni wa mwaana oto, na amana mwinsikana, mwite mwikuuze yoori na miiyo kilawe kamwaaputu.” ");
INSERT INTO eko_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Paata ya onsiila mfwalume yo khusala alawa, ntarikhi khoona ntthottowa nttintthile ooniyeeyo malawa-juwa, khulokoza khulawa khweemela puuro etile aariivo mwaana. ");
INSERT INTO eko_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Noorutela woona ntthottowa ntthile, khwiiya oofurahi venkivene. ");
INSERT INTO eko_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Khuvira nnyupa mphule khunsikana mwaana na Mariyamu mamaawe, khukokhora khumwaaputu. Nawiisha, khufukula maphuta aya khumwinkha tthuvo: Thahapu, ovupa, na mafuttha oonukhela. ");
INSERT INTO eko_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Khuuziwa muulottha yoori ahirutele wa Herooti, khurutela owaya khwa tarikhi kiina. ");
INSERT INTO eko_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Paata ya ajuwi olawa, nlayikha la Mbwana khumpuwelela Yuusufu muulottha khumuuza yoori: “Olankhe, onthuule mwaana oto na mamaawe, otthirele Misuri. Weekhale ottuukho mpakha miiyo kiwuuze, maana Herooti onteela omweekesa mwaana oto yoori amuule.” ");
INSERT INTO eko_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aphano ye khulankha, khunthuula mwaana na mamaawe osikhu, khweetta Misuri. ");
INSERT INTO eko_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ottuukho eekhaliyeeyo mpakha Herooti ofwa. Khwa etthiipo khuretteya etile Mbwana alupiyeeyo khwa napiyu yoori: “Kankhuwela mwanaka aari nti wa Misuri.” ");
INSERT INTO eko_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herooti ooniyeevo yoori attettekhiwa ti ajuwi, khwiiya wookatipukha, khuruma wuuliwa aana ooshi a nyaakha miwiri zeettaka vathi, Belemu na miti zawaattamanana nkhama wakathi otthuupo ooziweeyo pi ajuwi. ");
INSERT INTO eko_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Aphano khurettikhana epile zaalupiweeyo ti napiyu Yeremiiya: ");
INSERT INTO eko_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Khusiileya huula nti wa Rama ya olila na ojikhupanyisa nwulweene; aari Rakeele awaalilelaka aana awe akatthalaka ozurwiwa, mwaasa wa ooshi ofwa.” ");
INSERT INTO eko_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Paata ya Herooti ofwa, nlayikha la Mbwana khumpuwelela Yuusufu muulottha Misuri, ");
INSERT INTO eko_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","khumuuza yoori: “Olankhe, onthuule mwaana na mamaawe, olawe Ezirayiilu, maana apale aari otakhaaye omuula afwa.” ");
INSERT INTO eko_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ye khulankha, khunthuula mwaana na mamaawe, khweetta nti wa Ezirayiilu ");
INSERT INTO eko_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ila noosiila yoori Arikileewu mwaana wa Herooti ti asalaniyeeyo ofwalume wa papaawe, khwiiya wa woova weettawo. Nawuuziwa muulottha, khweetta nti wa Kalileya. ");
INSERT INTO eko_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Khusala eekhala sitati eniitthiwaaye Nazareeti, yoori erettikhane epile zaalupiweeyo pi manapiyu araka: “Ye onteela wiitthiwa Nnazare.” ");
INSERT INTO eko_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Siikhu zaya epile khupuwa Yaahaya Namoosa, alaleyaka n'yaara ya Yudeya. ");
INSERT INTO eko_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ye aari okhuwa araka: “Mwithupwiye, Ofwalume wa pinkuuni ori kharipu.” ");
INSERT INTO eko_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Maana otu ti otule alupiweeyo ti napiyu Ezaaya yoori: “Huula enkhuwa n'yaara eraka: ‘Mwitthenkeze tarikhi ya Mbwana na mookolele miphiitelo zawe.’” ");
INSERT INTO eko_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Kuwo za Yaahaya zaattalaniwe ovuzi wa nkamiiya, na aari owalaka nzako wa shapala n'yuunu. Etthu yoojiwa yawe aari mapalaka na asali ya ntthuttu. ");
INSERT INTO eko_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Atthu a nti wa Yeruzaleemu na a Yudeya na miti zooshi za nkerekhere ya Yorotaani aari onteela ye. ");
INSERT INTO eko_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yo aari otukhuru twampi zaya, nawoosiwa ti Yaahaya mmuttho Yorotaani. ");
INSERT INTO eko_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Wakathi ye awooniyeeyo mafwarizeewu na masatukhi enkeene ataaka aphale aari woosaavo, khuwooza yoori: “Ojama wa evili! Ti paani awuuziyeeni otthira katapu entaaye? ");
INSERT INTO eko_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mwithoonyeze khwa khaazi zenu yoori weekhweele mwathupwiya twampi zenu! ");
INSERT INTO eko_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Khahiyo olupa yoori: ‘Eburahiima ti marehemu papeetthu,’ ila miiyo kiniwuuzani yoori, khwa liwe ntthi Nluku onwahi owaattala aana a Eburahiima. ");
INSERT INTO eko_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nshokha lanoliwa latthiiwa nshini wa mitathaari za miitthi. Wakhula muutthi ohiniimaaye mishumo zooshapweya ontta oshijiwa weeseleliwe va moottho. ");
INSERT INTO eko_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Miiyo kiniwoosani na maati khwa othoonyeza othupwiya wa twampi zenu. Ila paata ya miiyo onta ntthu ariinaaye owahi zayita miiyo, hatha akinsuhi shitaha yawe wala akina makhaamu oothuula jampali zawe. Ye onttela owoosani na Rooho Ttakatthiifu na moottho. ");
INSERT INTO eko_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ye ontana fosholo mmakhono mwawe onteela ophakula tiriku na maveya. Tiriku atthe va sakafu vawe, maveya akhoze va moottho ohinzimaaye.” ");
INSERT INTO eko_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Aphano Yinsa khulankha Kalileya khuta o Muuttho Yorotaani oteela woosiwa ti Yaahaya. ");
INSERT INTO eko_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yaahaya khusala atakha okatthala araka: “Miiyo ti kinhithajiya woosiwa ti weeyo, onikiteela toovi miiyo?” ");
INSERT INTO eko_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ila Yinsa khunjipu yoori: “Olikhe etthiipo, yoori erettikhane shariya yooshi.” Yaahaya khukhupalela. ");
INSERT INTO eko_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yinsa nawoosiwa, khuvuuwa, nasaapiru pinku khufukuwa, khoona Rooho Ttakatthiifu yiishukhaka nkhama jiwa khummorela. ");
INSERT INTO eko_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Huula ya olankha pinkuuni khuri: “Otu mwanaka wompheta, na wookituvela channu!” ");
INSERT INTO eko_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Aphano Yinsa khuthuuliwa ti Rooho Ttakatthiifu khweettaniwa n'yaara, yoori alawe azayiniwe ti sheethwani. ");
INSERT INTO eko_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Paata ya ofuka siikhu arupayiini nthana na osikhu, khunkhola jala ");
INSERT INTO eko_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Aphano Sheethwani khumwaattama khumuuza yoori: “Nkhama weeyo o Mwaana wa Nnyizinkhu, orume mawe apo athatuwe eeye phaawu.” ");
INSERT INTO eko_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ila Yinsa khunjipu araka: “Yaatikhiwa yoori: ‘Khahiyo phaawu paasi enimwinkhaaye ntthu ohaayi, ila nttakhuzi looshi linlankhaaye nkhanyo wa Nluku.’” ");
INSERT INTO eko_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Elottelanaka, sheethwani khumweettana sitati ttakatthiifu, khunweza phantte yawiishela olepa ya Nyuupa Yoosifwiwamo, ");
INSERT INTO eko_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","khumuuza yoori: “Nkhama o mwaana wa Nluku, ojeeselele vathi aphale. Maana yaatikhiwa yoori: ‘Ye ontta oruma malayikha awe awiinanele, atthaapo antta wuukholelela na makhono aya yoori ohikwakwanttuwe va liwe.’” ");
INSERT INTO eko_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yinsa khunjipu yoori: “Theenya yaatikhiwa yoori: ‘Ohimweeze Mbwana, Nluku awo.’” ");
INSERT INTO eko_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sheethwani khunthuula khumweettana va mwaako mmote woolepa venkivene khunthoonyeza ofwalume wooshi wa olumwenku na siifwa yaya. ");
INSERT INTO eko_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Khumuuza yoori: “Amana okikokhorela khukaaputu kintta owinkha zooshi.” ");
INSERT INTO eko_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yinsa khumuuza yoori: “Oleevo, Epiliisi! Maana yaatikhiwa yoori: ‘Omwaaputu Mbwana, Nluku awo, na onrumeyele othuuto paasi.’” ");
INSERT INTO eko_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Aphano sheethwani khumwaattuwa, khuta malayikha oteela onrumeyela. ");
INSERT INTO eko_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Wakathi Yinsa asiiliyeevo yoori Yaahaya afukiwa, khurutela Kalileya. ");
INSERT INTO eko_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Khulaawo Nazareeti khulawa khwiikhala Kafwaranaawu, yaari nshini wa pahari, nti wa Zebulooni na Nafitaali, ");
INSERT INTO eko_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","yoori erettikhane etile yaalupiweeyo ti napiyu Ezaaya yoori: ");
INSERT INTO eko_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nti wa Zebulooni, na nti wa Nafitaali, tarikhi ya pahari, kaapu ya Yorotaani, Kalileya ya amalapo! ");
INSERT INTO eko_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Atthu aari wiikhalaaye n'yiiza oona nuuru khuluyeene; khwa apale aari wiikhalaaye miti za mwiivuli wa ofwa, amwasikheliwa ti nuuru.” ");
INSERT INTO eko_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Waaza attaapho Yinsa khwaaza olaleya hapari zawe alupaka yoori: “Mwithupwiye, maana ofwalume wa pinkuuni ori kharipu.” ");
INSERT INTO eko_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Eettaka weettetta nshini wa Pahari ya Kalileya Yinsa khuwoona attwi awiri: Simawu, anitthiwaaye Pheeturu, na ttwiiye Antere. Yo aari weeselela matthavi aya mpahari, maana yo aari anamajiya. ");
INSERT INTO eko_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yinsa khuwooza yoori: “Mwikilotte, miiyo kintta wuurettani o namajiya a atthu.” ");
INSERT INTO eko_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nasaapiru yo khulikha matthavi aya khusala anlotta. ");
INSERT INTO eko_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Eettaka olawa etthiipile khuwoona attwi akina awiri: Tiyaaku, mwaana wa Zepeteewu, na Yaahaya, ttwiiye. Yo aari mmwaatiya na papaaya Zepeteewu, attalelaka matthavi aya, Yinsa khuwaakhuwela. ");
INSERT INTO eko_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nasaapiru yo khunlikha papaaya na mwaatiya, khunlotta. ");
INSERT INTO eko_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yinsa eettettiye Kalileya yooshi asomisaka mmasinakooka, atafusiraka hapari zooshapweya za ofwalume na avonisaka marati ooshi vakatthi wa atthu ");
INSERT INTO eko_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Hapari monkoni wa ye khumwazeyela Siiriya yooshi, atthu khusala awaatiisa ooshi apale aarina marati, aari olwaaziwaaye na ohoochiwa ti masheethwani, anajilejile, anasupiyaani, ye noowaavonisa. ");
INSERT INTO eko_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Atthu enkeene khusala anlottelela olankha Kalileya, Tekapooli, Yeruzaleemu, Yudeya na a nti wa phantte kiina ya Yorotaani. ");
INSERT INTO eko_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Awooniyeevo atthu apale waatta, Yinsa khuwela va mwaako na khwiikhala. Anakhiyoni awe khususela aphale aariivo, ");
INSERT INTO eko_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ye khusala awaasomisa, araka: ");
INSERT INTO eko_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ooparikhiyiwa pi apale eeyiye asikhini nroho, maana ofwalume wa pinkuuni pi waaya. ");
INSERT INTO eko_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ooparikhiyiwa pi apale anlilaaye, maana anteela ozurwiwa. ");
INSERT INTO eko_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ooparikhiyiwa pi apale oojipushuwisa, maana yo anteela orithi olumwenku. ");
INSERT INTO eko_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ooparikhiyiwa pi apale ariina jala na nnyottha la shariya, maana anteela orupala. ");
INSERT INTO eko_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ooparikhiyiwa pi apale ariina tthakaraka, maana na-yo anteela wooneliwa tthakaraka. ");
INSERT INTO eko_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ooparikhiyiwa pi apale ariina rooho yoopakusiwa, maana yo anteela omoona Nluku. ");
INSERT INTO eko_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ooparikhiyiwa pi apale oolevelela, maana anteela wiitthiwa aana a Nluku. ");
INSERT INTO eko_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ooparikhiyiwa pi apale anlupatthiwaaye mwaasa wa haakhi, maana Ofwalume wa pinkuuni pi waaya. ");
INSERT INTO eko_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ooparikhiyiwa ti mweeyo amana mwittukhaniwaka na olupatthiwa, na wakhula zootakhala empuwaaye khwa mweeyo mwaasa wa miiyo. ");
INSERT INTO eko_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mwifurahi na mwitthape, maana tthuvo yenu pinkuuni khuluyeene, maana khwa nanna etthiipo awaalupatthiye manapiyu aviriyeeyo khapula ya mweeyo. ");
INSERT INTO eko_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mweeyo mwa mwiinyu wa olumwenku. Ila amana olikha onyuunya waya, onrutiseleya toovi? Khuniiyana hatha fwayita, woohiiyi wiitthiwa khusala oluwattheliwa pi atthu. ");
INSERT INTO eko_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Mweeyo mwa nuuru ya olumwenku. Sitati yoojekiwa va mwaako khinvitheya. ");
INSERT INTO eko_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Khina ankhozaaye khantteya khuttha nyuku. Entthiiwa vahali wawooneyavo yoori ewaamwasikhele atthu apale aniiyaaye nnyupa ");
INSERT INTO eko_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nakatalikha nuuru yenu mweeyo yaare vakatthi wa atthu, yoori oone khaazi zenu ansifu Papeenu ariiye pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mwihuupuwele yoori kateela wiishisa kano za Munsa ama masomi a manapiyu, akaateeliye wiishisa, ila omarisela. ");
INSERT INTO eko_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kiniwuuzani khweele yoori: Erivo etthiipi pinku na vathi khina nanna entakhaaye waashikha nenkawu alama yiisheliye ya kano ama nttottonka, mpakha zooshi erettikhane. ");
INSERT INTO eko_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Wooshi otule anttelaaye okhijilela oruma, hatha nkhama weetta opushuwa, na khuwaanozela akinoko oretta etthiipo, onteela wiitthiwa yoori woopepheya muufwalume wa pinkuuni; ila wakhula otule anshututelaaye na khusomisa oruma waya opu, onteela wiitthiwa yoori nwulweene muufwalume wa pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Maana miiyo kiniwuuzani yoori shariya yenu amana ehiziti ya mafwarizeewu na ya anamanozela a kano, hatha vattitthiiru khamwinteela weettamo muufwalume wa pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mweeyo mwasiila vitthu ooziweeyo amarehemu apapazenu yoori: ‘Mwihuule; wakhula anuulaaye oneekesela ophukiwa.’ ");
INSERT INTO eko_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ila miiyo kiniwuuzani yoori wakhula aninkatipukhelaaye ttwiiye oneekesela ophukiwa naye, na wakhula aninttukhanaaye ttwiiye ona ya olawaniwa wa afwalume ophukiwa. Na otule animuuzaaye ttwiiye yoori: ‘nlolo!’ oninsuhi weetta vamoottho wa motthooni. ");
INSERT INTO eko_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nakatalikha, amana weettelaka winkha zaakha va alitaari khufikhiri yoori ttwiiyo ona etthu varoho na-weyo, ");
INSERT INTO eko_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","olikhe zaakha yawo va alitaari attaapho, olawe wasiilane na ttwiiyo, nawiisha ote operekhe saana zaakha yawo. ");
INSERT INTO eko_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Amana ntthu atakha wuulawana onyuupa wa anamaphuka, osiilanane saana ntthu aya oto ntarikhi mweettaka olawa, maana noohijuwi saana weeyo onttela winkheleliwa wa namaphuka, namaphuka awinkhelele wa namweekesela kalapooso na ye aweeselele nkalapooso. ");
INSERT INTO eko_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Miiyo kiniwuuza khweele yoori khunlaamo ohiripheeni nzurukhu otthuupo onttelaaye wuuziwa. ");
INSERT INTO eko_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mweeyo mwasiila elupiwaka yoori: ‘Ohiraruwe.’ ");
INSERT INTO eko_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ila miiyo kiniwuuzani khweele yoori wakhula animweekesaaye muukha na ontakha varoho vawe, anrarusha. ");
INSERT INTO eko_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nkhama liisho lawo la phantte ya nkhono nlume lintta wuukosisa, olazemo weesele oje. Afwataali wuupwetheya phantte yawo moote ya mwiili awo zayita mwiili awo wooshi weeseleliwa motthooni. ");
INSERT INTO eko_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nkhama nkhono awo nlume ontta wuukosisa, oshije weesele. Afwataali wuupwetheya phantte yawo moote ya mwiili awo woohiiyi mwiili awo wooshi weeseleliwa motthooni. ");
INSERT INTO eko_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Yaatikhiwa theenya yoori: ‘Otule animwaashaaye muukhawe ona ya omwinkha talakha.’ ");
INSERT INTO eko_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ila miiyo kiniwuuzani yoori wooshi otule animwaashaaye muukhaawe, ehiriwaka etta oraruwa, oniiyana paathuli ya onruma oraruwa, na otule aninralaaye muukha aya otule wa waashiwa ontta onrarusha. ");
INSERT INTO eko_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mweeyo mwasiila etthu ooziweeyo amarehemu apapazenu yoori: ‘Mwihilaphe woovonyeyavo, ila mweettettise olapha mwirettiyeeyo omaasho wa Mbwana.’ ");
INSERT INTO eko_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ila miiyo kiniwuuzani yoori: mwihilaphe hatha vattitthiiru wala khwa vitthu za pinkuuni maana khukulu ya Nluku; ");
INSERT INTO eko_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","wala khwa vitthu za vathi maana phi anvumulisaavo moolu awe, wala khwa Yeruzaleemu maana sitati ya Mfwalume nwulu. ");
INSERT INTO eko_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Wala ohilaphele khwa eeshwa yawo maana weeyo khunwahi olakaza wala oriipisa hatha nyuuli yawo moote. ");
INSERT INTO eko_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Entosheleza olupa yoori ‘ayo’ amana yiiya ‘ayo’, na ‘wala’ amana yiiya ‘wala’; noozitisa apho enlankha wa Sheethwani. ");
INSERT INTO eko_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mweeyo mwasiila etile elupiwe yoori: ‘Liisho khwa liisho na liino khwa liino.’ ");
INSERT INTO eko_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ila miiyo kiniwuuzani yoori: mwihikhanyarele ojiripha khwa atthu apale anuurettelaanini zootakhala. Amana ntthu oopwakula nlaku limote onzukulisele ntthi likina. ");
INSERT INTO eko_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Amana ntthu atakha wuulawana wa anamaphuka na wuuvula kameza yawo, omwinkhe theenya ajapi yawo. ");
INSERT INTO eko_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Amana ntthu ookhanyarela othuula lipwattha khwa kiyasi ya phiima alufu moote, othuule phiima alufu piiri. ");
INSERT INTO eko_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","“Amana ntthu oovekela etthu, omwinkhe; ohinnoze enyokonyoko otule anuuvekelaaye omwiipaasha. ");
INSERT INTO eko_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Mweeyo mwasiila olupiwa yoori: ‘Omphete namwaattamanani awo, omwiine atuwi awo.’ ");
INSERT INTO eko_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ila miiyo kiniwuuzani yoori, mwiwaaphete maatuwi enu na mwiwaalompele apale anuulupatthanini, ");
INSERT INTO eko_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","yoori mweeyo mwiretteye wiiya aana a Papeenu ariiye pinkuuni. Maana ye oniwaatthamushela njuwa apale anrettaaye zooshapweya na apale anrettaaye zootakhala. Na oniwenkha vuula anashariya na apale ohitakhi shariya. ");
INSERT INTO eko_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Amana mwiwaaphetaka apale anuuphetaanini paasi, tthuvo-ni mwiineekeselaaye wiiyana? Anamariphisa lumpuru nayo khanretta etthiipo? ");
INSERT INTO eko_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na amana mwiiwaachelisaka maswaahipu paasi, mwinrettani yooziti? Hatha na amalapo anretta etthiipo. ");
INSERT INTO eko_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nakataalikha mwiiye atthu khaamili, nkhama etthiipo eyiyeeyo khaamili Papeenu wa pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mwiiyane phoole na oretta khaazi zenu za shariya vahali aniiyavo atthu akina yoori mwisifwiwe pi yo. Amana mwiretta toowo, khamwiniiyana hatha tthuvo ya Papeenu wa pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Nakataalikha, amana mwinkha zimola mwihithuule nlope khusala mwilaleya, nkhama anrettaazo manaafikhi mmasinakooka na mmaliinya, atakhaka yoori asifwiwe pi akina aya. Miiyo kiniwuuza khweele yoori yo apokhera tthuvo yaya. ");
INSERT INTO eko_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ila amana weeyo winkha zimola, nkhono awo nkha ohijuwe etthu orettiyeewo nkhono nlume awo, ");
INSERT INTO eko_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","yoori zimola yawo yiiye siiri. Toowo, Papaawo otule anoonaaye epile enrettiwaaye sirini, ontta wuutthuva. ");
INSERT INTO eko_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Na amana mwilompaka, mwihiiye nkhama manaafikhi. Yo owaatuvela weemela khusala alompa nsinakooka, mmatarikhi, atakhaka yoori ooniwe pi akinoko aya. Miiyo kiniwuuzani khweele yoori yo apokhera tthuvo yaya. ");
INSERT INTO eko_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ila amana weeyo olompaka, weette okatthi wawo ofuke nlako awo, onvekele Papaawo ahinooneyaaye. Aphano, othuuto ontta wuutthuva. ");
INSERT INTO eko_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Na amana olompaka, khahiyo orutela mattakhuzi mamoteru ooheleyi swaafu zawaatta, nkhama anrettaazo amalapo. Yo anaakhipwela yoori mwaasa wa waattisa ottakhula Nluku ti aniwaasiilaavo. ");
INSERT INTO eko_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mwihiiye nkhama atthaapo, maana khapula mweeyo mwihinaveke Papeenu onretta ajuwe etthu mwinihithajiyaaye. ");
INSERT INTO eko_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nakataalikha, mweeyo amana mwilompaka mwisala mwiri toono: ‘Papeetthu oriiye pinkuuni, littitthimisiwe nzina lawo loottakatthifu, ");
INSERT INTO eko_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","wiishushe ofwalume awo, mattakhelo awo arettikhane vathi apha nkhama etthiipo enrettikhanaazo otulu! ");
INSERT INTO eko_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Oninkhe wakhula siikhu etthu-yoojiwa ninihithajiyaaye. ");
INSERT INTO eko_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Oniswaamihi koosa zeetthu nkhama etthiipi na-fweyo nininswaamihaaye wakhula otule annikosaaye, ");
INSERT INTO eko_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","na ohinilikhelele nizayiniwaka, ila nuusuru khwa ntakhali, maana ofwalume, owahi, na siifwa zooshi pi zawo, mileele. Amiina.’ ");
INSERT INTO eko_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Maana amana mwiwaaswaamihi anaatamu koosa zaya, Papeenu wa pinkuuni naye ontta wuuswaamihini, ");
INSERT INTO eko_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ila amana mwihiswaamihanaka, Papeenu wa pinkuuni naye khanuuswaamihini koosa zenu. ");
INSERT INTO eko_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Amana ofuka, ohithoonyeze wuuso wa huzuni nkhama anrettaazo manaafikhi, yo antta ozukulisa wuuso aya yoori akina aya apatthe ojuwa yoori afuka. Miiyo kiniwuuzani khweele yoori nooretta toowo apokhera tthuvo yaya. ");
INSERT INTO eko_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ila weeyo amana ofuka, osala woosa wuuso awo, na khushamula nyuuli zawo, ");
INSERT INTO eko_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","yoori akinoko ahijuwe yoori wafuka, ila Papeenu, anoonaaye vitthu za siiri, ye ontta ojuwa yoori wafuka na othuuto ontta wuutthuva. ");
INSERT INTO eko_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ohikusanye maali vathi apha, oriivo oshuwa, na kuuthu enwahaaye oharipu, na ariivo manantarawu oophenya khwiiya. ");
INSERT INTO eko_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ila okusanye maali pinkuuni, ottuukho oshuwa na kuuthu ehinwahaawo oharipu wala nantarawu ahimphenyelaawo khwiiya. ");
INSERT INTO eko_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Maana attaapho eniiyaavo maali zawo, rooho yawo nayo eniiya attaapho. ");
INSERT INTO eko_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Maasho khantteya ya mwiili. Amana maasho awo eeya ooshwapweya, mwiili awo oniiyana nuuru; ");
INSERT INTO eko_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ila amana maasho awo eeya oohishapweyi, mwiili awo wooshi oniiya n'yiiza. Nakataalikha, amana nuuru oriinaaye ezukuluwa yiiya yiiza, yiiza yaya eto eniiya khuluyeene! ");
INSERT INTO eko_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Khaavo ntthu anwahaaye owaarumeyela a mbwana awiri, mwaasa yoori ontta omwiiphiirisa mmote, antuvelise otu nkina; ama oniiya wa waamineya khwa otu mmote, antarawu otu nkina. Khinwaheya onrumeyela Nluku na nzurukhu. ");
INSERT INTO eko_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Tiito, kiniwuuzanini yoori: Mwihiiye woovelavelela ohaayi enu, khwa etthu-yoojiwa ama yoonywiwa; wala mwiili enu monkoni wa etthu ya owala. Ohaayi enu waziti etthu-yoojiwa. Na mwiili enu waziti kuwo. ");
INSERT INTO eko_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mwiwoone anyannyi otulu: Khanzala, khanuurula wala khana sakafu; ila Papeenu wa pinkuuni oniwaajisa. Nakataalikha mweeyo mwinaaye fwayita zayita anyannyi. ");
INSERT INTO eko_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Paani wa mweeyo anwahaaye weekezela mansha awe hatha nkhama eetta oshukulikhela? ");
INSERT INTO eko_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Khi mwinvelavelelani kuwo? Moone nanna enwulaazo miitthi za ntthuttu na maluwa aya: yo khazinkhola khaazi, wala khazinsona. ");
INSERT INTO eko_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ila wekhweele miiyo kiniwuuzani yoori, Seleyimaana na oshapweya wawe khawaleeni kuwo zooshapweya nkhama maluwa apa. ");
INSERT INTO eko_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Moone, Nluku onwalisa nyaani za ntthuttu leelo ziniiyaavo meesho khulukuziwa, onuuwalisani mweeyo channu atthu oopushuwa amini! ");
INSERT INTO eko_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nakataalikha mwihishukulikhe, mwiraka: ‘Ninja niini?’ Ama ‘ninnywa niini?’ Ama ‘ninwala niini?’ ");
INSERT INTO eko_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Maana amalapo pi anshukulikhelaaye vitthu nkhama epo; ila Papeenu ariiye pinkuuni onjuwa yoori enuuhithajiyani epo zaya. ");
INSERT INTO eko_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Apho, mweekese khapula Ofwalume wa Nluku na shariya yaya, zooshi epo mwintta winkhiwa. ");
INSERT INTO eko_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nakataalikha mwihishukulikhele siikhu ya meesho, maana meesho entana tafwawuthi zaya. Wakhula siikhu eniiyana otakhala waya. ");
INSERT INTO eko_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mwihimphuke nzeenu yoori mwihiphukiwe. ");
INSERT INTO eko_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Maana khwa khiima ethiito omphukanaaye, na-weyo omphukiwa khwa khiima ethiito; mphimo otthuupo onrumeyelaaye owaaphimelanaka azaawo, na-yo anuuphimelana otthuupo. ");
INSERT INTO eko_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Mwaasa aya niini woonaka etutu eriiye mmaasho wa ttwiiyo, ila khuhooni lipikhi liriiye mmaasho mwawo? ");
INSERT INTO eko_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nanna-ni onimuuzaaye ttwiiyo yoori: ‘Kintakha kuulaze etutu eriiye mmaasho mwawo,’ khupe weeyo orina lipikhi mmaasho mwawo? ");
INSERT INTO eko_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Naafikhi! Olazemo khapula lipikhi liriiye mmaasho mwawo, aphano ontta woona saaneene khuwahi olazamo etutu eriiye mmaasho wa ttwiiyo. ");
INSERT INTO eko_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Mwihiwenkhe vitthu ttakatthiifu anapwa, antta wuuzukuluwelani na oolumeni, wala mwiheeselele kuluwe mawe ootafikhana mwirettaru toowo entta oluwatthela. ");
INSERT INTO eko_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mwiveke, mwintta winkhiwa; mweekese, mwintta opattha; mwipiye nlako, mwintta ofukuleliwa. ");
INSERT INTO eko_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Maana wakhula anvekaaye oninkhiwa, aneekesaaye ompattha, ampiyaaye nlako ontta ofukuleliwa. ");
INSERT INTO eko_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Paapa-ni mmote wa mweeyo, anraaye mwanawe anvekeliye phaawu khumwinkha liwe? ");
INSERT INTO eko_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ama anvekeliye swi khumwinkha nyookha? ");
INSERT INTO eko_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mweeyo mwa atthu ootakhala rooho, mwinjuwa owenkha vitthu zooshapweya aaneenu. Papeenu ariiye pinkuuni, atepa owenkha vitthu zooshapweya apale aninvekelaaye. ");
INSERT INTO eko_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Wakhula etile enuutuvelaanini oretteliwa, na-mweyo mwiwaarettele etthiipo azeenu, maana kano na manapiyu anlupa etthiipo. ");
INSERT INTO eko_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mwivire nlako woophunyeya, maana nlako nwulweene na tarikhi yoomwazeya eninlokoza ntthu motthooni, enkeene anvira nlako otthuupo. ");
INSERT INTO eko_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tarikhi na nlako oninkhaaye ohaayi wa mileele nttithiiru, na atthu vattitthiiru ti anttelaaye oviravo. ");
INSERT INTO eko_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Phoole na manapiyu oojipanka, yo anuuteelani mweeyo awaliye shapala ya pwittipwitthi, ila nkatthi ari miiji zooluma. ");
INSERT INTO eko_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Khwa mishumo zaya mwinteela owaajuwa. Khunshumeya wuuva mmiiwa, wala mmuuyu khinshumiwamo ekhuuwa. ");
INSERT INTO eko_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Khwa etthiipo wakhula muutthi wooshapweya oniima mishumo zooshapweya, na muutthi wootakhala oniima mishumo zootakhala. ");
INSERT INTO eko_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Khinretteya muutthi wooshapweya wiima mishumo zootakhala, wala muutthi wootakhala wiima mishumo zooshapweya. ");
INSERT INTO eko_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Wakhula muutthi ohiniimaaye mishumo zooshapweya ontta oshijiwa khweeseliwa va moottho. ");
INSERT INTO eko_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Khwa etthiipo mwinteela owaajuwa khwa mishumo zaya! ");
INSERT INTO eko_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Khahiyo ooshi apale anikiitthaaye yoori: ‘Mbwana, Mbwana,’ anttelaaye weettamo muufwalume wa pinkuuni, ila otule anrettaaye matakhelo a Paapa ariiye pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Amana efiya siikhu yaya eto enkeene, anlawa akuuze yoori: ‘Mbwana, Mbwana! Fweeyo nahupiri khwa nzina lawo, neekara masheethwani khwa nzina lawo, na khwa nzina lawo naretta minjuza.’ ");
INSERT INTO eko_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Aphano miiyo kilupe saaneene yoori: ‘Akuujuweenini. Mwikisuse, anamaretta zootakhala.’ ");
INSERT INTO eko_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Wakhula otule ansiilaaye nttakhuzi laka na khushututela onlattisaniwa ntthu wa akhili ajekiye nyuupa yawe khuthipa khuttha vanchina la mawe; ");
INSERT INTO eko_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","khunya vuula, khwiitaaza nyuuttho khuvuma pheevo khusakhinya nyuupa etile, khuhikwi, maana nchina laya laari va mawe. ");
INSERT INTO eko_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Wakhula otule ansiilaaye nttakhuzi laka khuhishututeli onlattisaniwa ntthu woololo ajekiye nyuupa yawe va nshaka; ");
INSERT INTO eko_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","khunya vuula, khwiitaaza nyuuttho, khuvuma pheevo khupiya nyuupa etile, khupwaluwa, khupwecheya”. ");
INSERT INTO eko_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Wakathi Yinsa eeshiyeevo ottakhula, khuntti epile khwiiya zootikinisiwa khwa masomi awe, ");
INSERT INTO eko_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","maana aari osomisa nkhama ntthu ariinaaye ofwalume, woohiiyi nkhama anamanozela a kano. ");
INSERT INTO eko_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Wakathi eeshukhiyeevo va mwaako, khuntti khuluyeene yeetta onlotta. ");
INSERT INTO eko_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nasaapiru khuta namaaharaja mmote khumwaattama, khumwaaputu akokhoriye khulupa yoori: “Mbwana, onwahi okitwaharesha!” ");
INSERT INTO eko_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yinsa khookola nkhono awe, khunsapa khuri: “Katakha, ti otwaharesheye!” Nasaapiru ye khwiiya wootwaharesheya khwa maaharaja. ");
INSERT INTO eko_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Aphano Yinsa khumuuza yoori: “Vitthu epi ohinthatelele hatha ntthu. Ila olawe, wajithoonyeze wa namalokozela a tiini na olaze zaakha etile Munsa alupiyeeyo yoori yiiye oshaahiti.” ");
INSERT INTO eko_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Wakathi Yinsa afiiyeevo sitati ya Kafwaranaawu, eetta oteeliwa ti nttunkhulu wa anajanka, anvekelaka yoori amwaawuni. ");
INSERT INTO eko_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Khumuuza yoori: “Mbwana, karumeya aka ori onti, onaaye supiyaani, ontta ohoocheya venkivene.” ");
INSERT INTO eko_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yinsa khumuuza yoori: “Miiyo kinlawa kanvonise.” ");
INSERT INTO eko_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nttunkhulu wa anajanka otule khunjipu yoori: “Mbwana, miiyo akinsuhi wuupokherela vaje vaka. Ila olupe nttakhuzi limote paasi, karumeya aka ontta ovona. ");
INSERT INTO eko_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Maana na-miyo ki ntthu kiriiye vathi wa ofwalume na ki nlokozi wa anajanka. Kinimuuza mmote yoori: ‘Olawe,’ khulawa; khumuuza nkina yoori: ‘Ote,’ ye khuta. Kinimuuza karumeya aka yoori: ‘Orette khata,’ ye khuretta.” ");
INSERT INTO eko_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yinsa noosiila epo zaya, khushanka, khuwooza apale aari onlottaaye yoori: “Kiniwuuzani khweele: Akinsikaneeni Ezirayiilu ntthu ariina amini nkhama eti. ");
INSERT INTO eko_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Miiyo kiniwuuzani, atthu enkeene a khipula na malawa-juwa, anttela wiikhala va meeza na Eburahiima, Esiyaakha, Yaakhumpa muufwalume wa pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ila apale aari weettelaaye orithi ofwalume wa Nluku anttela weeseleliwa oje, n'yiiza nhali onttelaaye wiiyamo olila na oluma meeno.” ");
INSERT INTO eko_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yinsa khumuuza nttunkhulu wa anajanka otule yoori: “Olawe owawo, entta orettikhana nkhama etthiipo okhupaliyeezo.” Wakathi otthuupule karumeya awe khwiiya woovona. ");
INSERT INTO eko_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yinsa khweetta owawe Pheeturu ottuukho khumoona nkhwewe Pheeturu arapaleliye ari nlwele hooma. ");
INSERT INTO eko_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yinsa khunsapa nkhono awe, hooma etile khumwiisha. Khulankha khusala anrumeyela. ");
INSERT INTO eko_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Paata ya otupweela njuwa, khutiiseliwa anamasheethwani awaatta, ye khusala eekara masheethwani khwa nttakhuzi lawe khuwaavonisa alwele ooshi. ");
INSERT INTO eko_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Khwa etthiipo khurettikhana epile zaalupiweeyo ti napiyu Ezaaya yoori: “Ye athuula marati etthu na apwechera moolwele etthu.” ");
INSERT INTO eko_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yinsa noowoona atthu awaatta anzukuleliye, khuwaaruma anakhiyoni awe olokhela kaapu ya ntthatta. ");
INSERT INTO eko_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aphano namanozela wa kano mmote khumwaattama khumuuza yoori: “Mwaaliimu, kintta wuulotta wakhula vahali oneettaavo.” ");
INSERT INTO eko_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yinsa khunjipu araka: “Ananthala anaaye maphotto aya anyannyi anaaye vijaaro zaya, ila Mwaana wa Pinaatamu khana vahali woovumulisavo eeshwa yawe.” ");
INSERT INTO eko_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nakhiyoni awe mmote khuri: “Mbwana, waaze okilikha kilawe kanzikhe paapa.” ");
INSERT INTO eko_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yinsa khujipu araka: “Okilotte, owaalikhe ananfwa awaazikhe ananfwa aya eenyewe.” ");
INSERT INTO eko_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yinsa apakhiriyeevo mmwaatiya anakhiyoni awe khunlotta. ");
INSERT INTO eko_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nasaapiru, pheevo yawoopisa khusala evuma mpahari, mwaatiya khusala ozamisiwa ti mawipi, Yinsa ettaka olala. ");
INSERT INTO eko_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Anakhiyoni awe khunsusela khusala anlansa, ankhuwelaka araka: “Mbwana, onuusuru nasaleela ofwa!” ");
INSERT INTO eko_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ye khuwoozela yoori: “Mwinoovani? Atthu oopushuwa amini!” Ye khulankha khushowera pheevo etile na pahari, zooshi khunyamala. ");
INSERT INTO eko_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ooshi khusala ashankiye na khulupa yoori: “Otu aya paani hatha anrumaaye pheevo na pahari khunshututela?” ");
INSERT INTO eko_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Wakathi afiiyeevo phantte kiina, ya Jerazeenu, khunteela anamasheethwani awiri, alankhiyeeyo ovilalo. Yo aari oowali, khina aari oviraaye tarikhi ya etile. ");
INSERT INTO eko_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Aphano, yo khusala anyakula araka: “Onnitakhelani fweeyo, Mwaana wa Nluku? Wata okhuno oteela onoopopisa, ohinafiye wakathi aya?” ");
INSERT INTO eko_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kharipu ya aphale vaya laarivo liphanko la kuluwe. ");
INSERT INTO eko_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Aphano masheethwani apale khunvekela Yinsa yoori: “Nkhama onniikara, oniikarile nliphanko la kuluwe.” ");
INSERT INTO eko_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yinsa khulupa yoori: “Apho mwilawe!” Masheethwani apale khulawa khweetta nkuluwe, liphanko looshi khwiishukela va ntthatta khuttuluwa khufwa. ");
INSERT INTO eko_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Atthu apale aari oshukaaye kuluwe epile khutthira khulawa mmuti, khulupa zooshi mpakha epile zaarettikhaniyeeyo khwa anamasheethwani apale awiri. ");
INSERT INTO eko_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Atthu ooshi a mmuti mphule khusala alawa okutthanana Yinsa, nonsikana, khunvekela amuuzaka yoori aleemo mmuti mwaya. ");
INSERT INTO eko_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yinsa noopakhira mmwaatiya, khulokha ntthatta khweetta sitati ya owawe. ");
INSERT INTO eko_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Khutiisiwa nasupiyaani attattikheliwe va nrepa. Wakathi ooniyeevo amini ya atthu apale antiisiyeeyo, khumuuza nasupiyaani otule yoori: “Ominyale, mwanaka! Twampi zawo zaswaamihiwa.” ");
INSERT INTO eko_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Noolupa toowo anamanozela a kano khwaaza waapa araka: “Ntthu otu ontta okufuru!” ");
INSERT INTO eko_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yinsa noojuwa etthu aari wuupuwelaaye yo, khuwooza yoori: “Mwaasa wa niini mweeyo muupuwelaka nroho mwenu vitthu zootakhala? ");
INSERT INTO eko_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Apho yookhweya ti tiivi? Olupa yoori: ‘Waswaamihiwa twampi zawo,’ ama olupa yoori: ‘Olankhe weettette?’ ");
INSERT INTO eko_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mwijuwe yoori Mwaana wa Pinaatamu onaaye ruhusa ya oswaamihi twampi vathi apha” khumuuza nasupiyaani otule yoori: “Olankhe, othuule nrepa lawo olawe owawo.” ");
INSERT INTO eko_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Khulankha khusala alawa owawe. ");
INSERT INTO eko_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Paata ya atthu woona vitthu epile khuwaapattha woova, khunsifu Nluku, awenkhiyeeyo anaatamu ofwalume nkhama opo. ");
INSERT INTO eko_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Elottelanaka Yinsa khulaawo okhule waya, khumoona mwinyi mmote aniitthiwaaye Matewuzhu eekhaliye ariphisaka lumpuru, khumuuza yoori: “Okilotte!” Ye khulankha khunlotta. ");
INSERT INTO eko_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yinsa eekhaliyeevo va meeza owawe Matewuzhu, anamariphisa lumpuru enkeene na anatwampi aatiiye khwiikhala attaapho vamote na anakhiyoni awe. ");
INSERT INTO eko_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mafwarizeewu nawoona toole khuwoozela anakhiyoni awe araka: “Mwaasa wa niini mwaaliimu enu ajaka na anamariphisa lumpuru na anatwampi?” ");
INSERT INTO eko_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yinsa noosiila, khulupa yoori: “Akumi khaninhithajiya tothoro, ila alwele. ");
INSERT INTO eko_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mwilawe mwanozeliwe maana a nttakhuzi linlupaaye yoori: ‘Kintakha tthakaraka, khahiyo twaha.’ Maana miiyo akawaateeliye anashariya, kawaateeliye anatwampi. ");
INSERT INTO eko_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Aphano khuta anakhiyoni a Yaahaya omuuzela yoori: “Fweeyo na mafwarizeewu ninfuka, khi anakhiyoni awo ahisala afuka mwaasa wa niini?” ");
INSERT INTO eko_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yinsa khujipu yoori: “Enretteya toovi ofuka anamalaleyiwa harusi, namaposa ari attaapho? Zinlawa zafiye siikhu anttelaaye othuuliwa mposi, na siikhu zaya etthiipo anlawa afuke. ");
INSERT INTO eko_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Khina antthaaye yaapa ya tarapu pheeya kuwo ya raku, maana entta ofutthela kuwo etile evaruwe. ");
INSERT INTO eko_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Wala khinthuliwa viinyu pheeya khutthiiwa nttompwiyo ya shapala ya raku, nooretta toowo entta ophutuwa, viinyu yiittikhe, ttompwiyo yaya eharipweye. Ila viinyu pheeya entthiwa nttompwiyo pheeya, na toowo zoopiiri zintta opweheya.” ");
INSERT INTO eko_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ettaka ottakhula etthiipile, khutavo nttunkhulu wa tiini, khunkokhorela na khumuuza yoori: “Mwanaka wankha afwa nasaapi ethiiti; nlawe wanttheele nkhono ontta osisimuwa.” ");
INSERT INTO eko_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yinsa khulankha khusala anlotta na anakhiyoni awe. ");
INSERT INTO eko_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Attaaphale, aarivo muukha mmote aarina nyaakha khumi na miwiri emwiittikhaka taamu, khuta onyoko wa Yinsa khusapa ajapi yawe. ");
INSERT INTO eko_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Maana ye eettiye ojilakelela yoori: “Kisaparu ajapi yawe paasi, kintta ovona.” ");
INSERT INTO eko_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Azukuluwiyeevo Yinsa khumoona khumuuza yoori: “Ofurahi, mwanaka wankha; amini yawo yoovonisa. Wakathi otthuupule muukha otule khwiiya woovona”. ");
INSERT INTO eko_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Afiiyeevo owawe nttunkhulu wa tiini khuwaasiila atthu eepaka liipo la miifwa na enkeene ari ootapanyeya, ");
INSERT INTO eko_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yinsa khuwooza yoori: “Mwisaruwe! Otu khafweeni, ontta olala.” Ooshi khusala antheya. ");
INSERT INTO eko_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Paata ya atthu apale osusa, ye khuvira khunkholela nkhono, khunlansa. ");
INSERT INTO eko_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Hapari epile khumwazeyela nti opule wooshi. ");
INSERT INTO eko_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Noolaavo aphale vaya, ananhooni awiri khusala anlotta akhuwaka araka: “Mwaana wa Daawuuda, noonele huruma!” ");
INSERT INTO eko_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yinsa noofiya owawe, ananhooni apale khumwaattama, ye khuwoozela yoori: “Mweeyo mwinkhupali yoori miiyo kinaaye owahi wa oretta epo zaya?” Yo khujipu yoori: “Ayo, Mbwana!” ");
INSERT INTO eko_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yinsa khuwaasapa maasho aya araka: “Erettikhane khwa matakhelo amini yenu!” ");
INSERT INTO eko_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Maasho aya khwiiya oovona. Aphano Yinsa khuwooza na kuvu yoori: “Phoole ahiiyevo anttelaaye ojuwa epi.” ");
INSERT INTO eko_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yo khulawa, khumwaza hapari zawe epile nti opule wooshi. ");
INSERT INTO eko_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Paata ya olaavo aphale, namasheethwani ahaari ottakhulaaye khutiiseliwa Yinsa. ");
INSERT INTO eko_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Noomwiikara sheethwani otule, ye khwaaza ottakhula. Khuntti etile khwiiya yooshanka na khuri: “Khinarettikhane vitthu nkhama epi Ezirayiilu. ");
INSERT INTO eko_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ila mafwarizeewu aari olupa yoori: “Oniikara masheethwani khwa owahi wa mfwalume wa masheethwani.” ");
INSERT INTO eko_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yinsa aari weettetta sitati zooshi na mmwanttiwa. Ye aari osomisa mmasinakooka, na olaleya hapari monkoni wa ofwalume wa Nluku, na ovonisa wakhula nanna ya marati na moolwele mawulweene a atthu. ");
INSERT INTO eko_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Paata ya woona khuntti zawaatta, khoonela huruma, maana zaari zoovelavela na zawanswiwa, nkhama pwittipwitthi zoohiina nshuki. ");
INSERT INTO eko_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Aphano khuwooza anakhiyoni awe yoori: “Wuurula nwulweene, ila anakhaazi vattitthiiru. ");
INSERT INTO eko_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Apho, mwinvekele Mweenyewe wuurula awaaperekhe anakhaazi a wuurula.” ");
INSERT INTO eko_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Khuwaakhuwela anakhiyoni awe apale khumi na awiri, khuwenkha owahi wa wiikara masheethwani, na ovonisa moolwele na marati ooshi. ");
INSERT INTO eko_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Apa mazina a anakhiyoni khumi na awiri: Wamwanzo, Simawu, anjuwaniwaaye nzina la Pheeturu, na ttwiiye Antere; Tiyaaku, mwaana wa Zepeteewu, na Yaahaya ttwiiye; ");
INSERT INTO eko_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filiipe na Paturumeewu; Tome na Matewuzhu, namariphisa lumpuru; Tiyaaku mwaana wa Alufeeyu, na Tadeewu; ");
INSERT INTO eko_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simawu Zelooti, na Yuuda Eshikariyoote, othuuto anzinkuliyeeyo. ");
INSERT INTO eko_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yinsa khuwaaruma apale khumi na awiri na khuwooza yoori: “Mwiheette wa amalapo, wala mwiheette hatha sitati moote ya a Samariiya. ");
INSERT INTO eko_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ila khapula mweettele pwittipwitthi zawaashikha za Ezirayiilu. ");
INSERT INTO eko_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Wakhula vahali mwineettaavo, mwitafusiri hapari epi mwiraka: ‘Ofwalume wa pinkuuni ori kharipu!’ ");
INSERT INTO eko_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mwiwaavonisaka anamarati, mwiwaasisimulaka ananfwa, mwiwaatwahareshaka anamaharaja, mwiikare masheethwani. Mweeyo mwapokhera mahala na mwina yawinkha mahala. ");
INSERT INTO eko_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mwihithuule hatha thahapu, wala feeta, wala khoopiri mmwizako mwenu; ");
INSERT INTO eko_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mwihithuule hatha kuwo kiina, wala jampali, wala pakhora, maana nakhaazi eninsuhi wiiyana etthu yoojiwa yawe. ");
INSERT INTO eko_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Na wakhula sitati ama mmwanttiwa, mwimweekese ntthu woojishitahi, mwiikhale owawe othuuto mpakha malawelo enu. ");
INSERT INTO eko_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Amana mwivira nnyupa, mwichelise. ");
INSERT INTO eko_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nkhama atthu a nyuupa etile eeya oosuhi, heeri yenu mweeyo yiiye vamote na-yo; amana ahisuhi, heeri yenu ti yuuruteleni. ");
INSERT INTO eko_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Amana ntthu ahuupokherelini na khuhitakhi osiila mattakhuzi enu, mwitathe lifufu la mmoolu mwenu mwileemo nnyupa mwaya mphule ama nsitati mwaya mphule. ");
INSERT INTO eko_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Miiyo kiniwuuzani khweele yoori, siikhu ya ophukiwa enttela wiiyavo tthakaraka khwa Sotooma na Komoora zayita sitati ya eto. ");
INSERT INTO eko_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Miiyo kinuurumani mweeyo nkhama pwittipwitthi vakatthi wa miiji; nakataalikha mwiiye alavilavi nkhama nyookha na oohiina zootakhala nkhama jiwa. ");
INSERT INTO eko_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mwiiyane phoole, maana atthu anlawa oottheni nnyupa woophukaniwamo na wuujaphani mmasinakooka mwaya. ");
INSERT INTO eko_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mwaasa wa miiyo, mwinlawa mwalawaniwe vakatthi wa misatoro na afwalume, yoori wiiye oshaahiti anttelaaye orumeyela, yo na amalapo monkoni wa hapari zaka. ");
INSERT INTO eko_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ila amana oofukelani, mwihishanke etthu yoolupa, ama yooretta. Wakathi aya opo, Nluku onttela owinkhani mattakhuzi olupa, ");
INSERT INTO eko_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","maana khahiyo mweeyo mwinttelaaye ottakhula, ila Rooho ya Papeenu ti enttelaaye ottakhula khwa mweeyo. ");
INSERT INTO eko_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ttwi mmote onlawa anleve ttwiiye yoori ooliwe, na paapa onleva mwanawe; aana anlawa awaazukuluwele apapa zaya na awoole. ");
INSERT INTO eko_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Atthu ooshi anttela owiinani mwaasa wa miiyo, ila otule anttelaaye ovilela mpakha mwiisho ontta wuusurukha. ");
INSERT INTO eko_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Amana mwifiya nsitati khulupatthiwa, mwitthirele sitati kiina. Weekhweele miiyo kiniwuuzani yoori khamwinteela wiisha ozukulela Ezirayiilu yooshi Mwaana wa Pinaatamu ahiteeni. ");
INSERT INTO eko_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Nakhiyoni khaninziti mwaaliimu awe, wala karumeya khaninziti mbwana awe. ");
INSERT INTO eko_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nakhiyoni ona yoofurahi amana anfiyela mwaaliimu awe, na karumeya amana anfiyela mbwana awe. Moone, amana mweenyewe nyuupa attukhaniwa khutthajiwa Belezibuuli, khi ajamaaze khatepeeni! ");
INSERT INTO eko_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Nakataalikha mwihiwoove apo aya. Khayiivo yoottiyeleliwa ehinteelaaye othoonyeziwa wala yoovithiwa ehinteelaaye ojuwiwa. ");
INSERT INTO eko_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Eti kiniwuuzaani n'yiiza mwilupe nthana. Na etile mwisiiliyeeyo sirini mwaamuuze vatulu wa nyuupa. ");
INSERT INTO eko_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mwihimoove otule anuulaaye mwiili, ahina owahi wa wuula nafusi. Khapula mwimoove otule anwahaaye otapanya mwiili na nafusi khweeselela motthooni. ");
INSERT INTO eko_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Anyannyi awiri anuuzanyiwa nzurukhu mmote, ila khina mmote ankwelaaye vathi Papeenu ahitakheeni. ");
INSERT INTO eko_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hatha nyuuli za mmwishwa mwenu zooshi pi za waalakiwa. ");
INSERT INTO eko_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nakataalikha mwihoove! Mweeyo mwinaaye fwayita zayita anyannyi. ");
INSERT INTO eko_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Wakhula otule antukhurwaaye yoori ti waka vakatthi wa atthu, na miiyo kintukhuru khwa ye, vakatthi wa Paapa ariiye pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ila otule anikikatthalaaye vakatthi wa atthu, na miiyo kinttela onkatthala vakatthi wa Paapa ariiye pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mwihaakanyere yoori miiyo katiisa heeri voolumwenku; akitiseeni heeri, katiisa phanka. ");
INSERT INTO eko_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Miiyo kata yoori oomane mwaana na papaawe, mwaana wankha na mamaawe, namaraliwa na nkhwewe. ");
INSERT INTO eko_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Maatuwi khaamili a ntthu anlankha vakatthi wa ajamaaze. ");
INSERT INTO eko_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Otule animphetaaye mamaawe ama papaawe zayita miiyo khansuhi wiiya namalottela aka; otule animphetaaye mwanawe zayita miiyo, khansuhi wiiya namalottela aka. ");
INSERT INTO eko_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Otule ahinvikelaaye nsalapa awe akilotta, khansuhi wiiya namalottela aka. ");
INSERT INTO eko_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Otule aneekesaaye ohaayi awe ontta omwaashikha, na otule onimwaashikhaaye ohaayi awe mwaasa wa miiyo ontta opattha. ");
INSERT INTO eko_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Wakhula otule anuupwekherelaanini akipwekherela miiyo, na otule anikipwekherelaaye ampwekherela otule akirumiyeeyo. ");
INSERT INTO eko_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Otule animpwekherelaaye napiyu mwaasa wa ye wiiya napiyu, ompwekhera tthuvo ya napiyu; otule animpwekherelaaye nashariya mwaasa wa ye wiiya nashariya, ompwekhera tthuvo ya nashariya. ");
INSERT INTO eko_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Na wakhula otule animwinkhaaye nsimaana hatha nkhama koopho ya maati oozizima, mwaasa wa ye wiiya nakhiyoni aka, kiniwuuza khweele yoori oto aya onlawa apwekhere tthuvo yawe.” ");
INSERT INTO eko_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Paata ya wiisha owaanozela anakhiyoni awe khumi na awiri, Yinsa khusala alawa osomisa na otafusiri sitati za Kalileya. ");
INSERT INTO eko_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yaahaya, paata ya osiila ari nkalapooso vitthu aari orettaazo Al-Masiihu, khuwaaruma anakhiyoni awe olawa omuuzela yoori: ");
INSERT INTO eko_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Ti weeyo otule aari weettelaaye ota, ama nimweekesele nkina?” ");
INSERT INTO eko_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yinsa khuwaajipu araka: “Mwiruti mwamuuze Yaahaya epi mwinsiilaaye na mwinoonaaye: ");
INSERT INTO eko_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ananhooni anoona, anamarakala aneettetta, anamaharaja antta otwahareshiwa, ananhisiili ansiila, ananfwa ansisimuwa, na hapari zooshapweya antafusireliwa asikhini. ");
INSERT INTO eko_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ooparikhiyiwa pi apale ahinikoonanaaye hatha etthu ya owaakwakwanttula.” ");
INSERT INTO eko_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Aphano noolaavo anakhiyoni apale a Yaahaya, Yinsa khusala oozela khuntti etile monkoni wa Yaahaya yoori: “Mweetteliye woona-ni n'yaara? Tteketthe yiinisiwaka ti pheevo? ");
INSERT INTO eko_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ama, mweetteliye omoona ntthu awaliye kuwo zooshapweya? Moone, apale anwaalaaye kuwo zooshapweya aniikhala mmanyupa wa afwalume! ");
INSERT INTO eko_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nka khuuzeni, mweetteliye woona niini? Napiyu? Wekhweele, miiyo kiniwuuzani yoori anziti napiyu. ");
INSERT INTO eko_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Otu ti otule yaatikhiweeyo monkoni wa ye yoori: ‘Moone, kinlawa kamperekhe karumeya aka omaasho wawo; yoori atthenkeze tarikhi yawo.’ ");
INSERT INTO eko_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kiniwuuzani khweele yoori: Khwa aana ooshi avokoliweeyo ti aakha, khapuweenivo hatha mmote wonziti Yaahaya Namoosa. Ila woopushuwa muufwalume wa pinkuuni nwulweene zayita ye. ");
INSERT INTO eko_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Waaza siikhu za Yaahaya Namoosa mpakha leelo, Ofwalume wa pinkuuni ontta woojopholiwa, apo aya anjopholaaye anthuula. ");
INSERT INTO eko_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Maana Manapiyu ooshi na Kano za Munsa za ahupiri mpakha yenzi ya Yaahaya. ");
INSERT INTO eko_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na amana mwitakha okhupalela, ye ti Aliyaasi otule aari weettelaaye ota. ");
INSERT INTO eko_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Otule ariina mashiilo ti asiile! ");
INSERT INTO eko_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Khapila eti kilattanisane niini? Enlattanana asimaana eekhaliye va parasa eettaka osheza na onyakula na ashirikha aya: ");
INSERT INTO eko_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Fweeyo noovumiselani kuruneetha, ila mweeyo khuhiini; khwiipa liipo la huzuni, ila mweeyo khuhilili.’ ");
INSERT INTO eko_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Khuta Yaahaya woofuka na ahinnywaaye viinyu, mweeyo mwinri: ‘Ye onaaye masheethwani!’ ");
INSERT INTO eko_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ata Mwaana wa Pinaatamu anjaaye na annywaaye, mwinri: ‘Otu nsokho na nnywachi, nshirikha wa anamariphisa lumpuru na anatwampi.’ Ila ojuwa onthoonyezeya khwa khaazi onikholeliwaaye.” ");
INSERT INTO eko_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Aphano Yinsa khwaaza omaruwela sitati epile aviriyeemo khurettamo minjuza zawe zawaatta, maana atthu aari wiikhalaamo khathupwiyiye. ");
INSERT INTO eko_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Phoole weeyo, Korazini! Phoole, weeyo Betezayiita! Maana eriwaka Tiiru na Sitooni zeettiye orettiwawo minjuza epi mwiretteliweeyo mweeyo, apale aniikhalaaye ottuukho nka athupwiye raku, khuwala saakhu na khujivaaza fuutha! ");
INSERT INTO eko_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ila miiyo kiniwuuzani yoori siikhu ya ophukiwa enteela wiiyavo tthakaraka khwa Tiiru na Sitooni zayita mweeyo. ");
INSERT INTO eko_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Khi weeyo Kafwaranaawu, onttela oweziwa mpakha pinkuuni? Wala, weeyo onttela weeseleliwa motthooni! Eriwaka minjuza zirettiweeyo vakatthi vawo zeettiye orettiwa Sotooma, zaari weettela opharelela mpakha leelo. ");
INSERT INTO eko_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ila miiyo kiniwuuza yoori siikhu ya ophukiwa enteela wiiyavo tthakaraka khwa Sotooma zayita weeyo.” ");
INSERT INTO eko_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Wakathi otthuupule Yinsa khulupa yoori: “Miiyo kinuusifu Paapa, Mbwana wa pinkuuni na vathi, maana weeyo wawaavithela vitthu epi ajuwi na asomi, na khuwaathoonyeza apa attiitthi. ");
INSERT INTO eko_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Khweele, Paapa, ti nanna waatakhiyeezo. ");
INSERT INTO eko_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Vitthu zooshi kenkhiwa ti Paapa. Khina aninjuwaaye Mwaana woohiiyi Paapa, na khina aninjuwaawe Paapa woohiiyi Mwaana na otule mwaana anintakhelaaye yoori anthoonyeze. ");
INSERT INTO eko_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mwikiteele miiyo mooshi mweeyo mwiiyiye ooshokhera na oolemeliwa, miiyo kintta wuuvumulisani. ");
INSERT INTO eko_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mwithuule tthentte yaka na mwikeezele, maana miiyo kiwoonyamala na woojipushuwisa nroho, mweeyo mwintta opattha ovumula wa nafusi zenu. ");
INSERT INTO eko_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Maana tthentte yaka ti yookhweya na mapwattha aka pi ooveya.” ");
INSERT INTO eko_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Wakathi otthuupule Yinsa khusala avira mmashapa wa tiriku, siikhu ya saapatu. Anakhiyoni awe khuwaakhola jala, yo khwaaza okathula misasi za tiriku arafunaka phunje zaya. ");
INSERT INTO eko_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mafwarizeewu nawoona epile zaya, khumuuza Yinsa yoori: “Owoone anakhiyoni awo anretta etthu ekhattaziweeyo orettiwa saapatu.” ");
INSERT INTO eko_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ye khujipu araka: “Mweeyo khamwisomeeni etthu arettiyeeyo Daawuuda wakathi ye na ashirikha awe aakholiweeyo jala? ");
INSERT INTO eko_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ye eettiye Nnyupa ya Nluku, khurafuna phaawu na ashirikha awe enkhiweeyo Nluku, etthu yahaari otakhisiwaaye orettiwa, ila aariina ruhusa yooretta aari mahaakhimu a tiini paasi. ");
INSERT INTO eko_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ama mweeyo khamwisomeeni nkano za Munsa yoori saapatu, anamalokozela a tiini aavonyiye kano Nnyupa Woosifwiwamo, siikhu yaya eto, ila khuhiina hatha paathuli? ");
INSERT INTO eko_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Miiyo kiniwuuza yoori apha ata otu azitiyeeyo Nyuupa Yoosifwiwamo. ");
INSERT INTO eko_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ila eriwaka mweeyo mwaari ojuwa maana a mattakhuzi anraaye: ‘Kintakha huruma akintakha twaha,’ khamwaari onhukhumu ntthu ahina paathuli. ");
INSERT INTO eko_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Maana Mwaana wa Pinaatamu Mbwana wa saapatu.” ");
INSERT INTO eko_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Khulaavo aphale vaya khweetta nsinakooka yaaya atthaapale. ");
INSERT INTO eko_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nttumphule aarimo mwinyi mmote woorakala nkhono. Aphano atthu akina aari otakhaaye onlokoveza Yinsa yoori: “Ti ya halaali monkoni wa kano ovonisa saapatu?” ");
INSERT INTO eko_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ye khuwaajipu yoori: “Paani wa mweeyo, amana eeyana pwittipwitthi yawe ekwela valiphotto saapatu, ahinlawaaye okhola alazavo? ");
INSERT INTO eko_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ntthu ona fwayita khuluyeene zayita pwittipwitthi! Nakhataalikha ewaapho ruhusa yooretta etthu yooshapweya saapatu.” ");
INSERT INTO eko_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aphano khumuuza mwinyi otule yoori: “Wookole nkhono awo.” Ye khookola, khuvonisiwa, khwiiya sawasawa na opu nkina. ");
INSERT INTO eko_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ila mafwarizeewu apale khusaruwa khusala awaza shawuri za omuula Yinsa. ");
INSERT INTO eko_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yinsa noojuwa shawuri zaya epile, khulaawo okhule waya. Atthu enkeene khusala anlotta, ye khuwaavonisa alwele ooshi aariivo vakatthi wa atthu aya apale, ");
INSERT INTO eko_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","na khuwooza yoori ahilupe hatha etthu monkoni wa ye. ");
INSERT INTO eko_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Eto yaarettikhaniye yoori eretteye etile yaalupiweeyo ti napiyu Ezaaya yoori: ");
INSERT INTO eko_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Otu ari apha karumeya aka, kinthawuliyeeyo, mphetani aka, anfurahisaaye rooho yaka, kanttheela nafusi yaka, ye onteela olaleya ophukiwa wa atthu ooshi. ");
INSERT INTO eko_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Khanteela okeetisana wala onyakula, khina anttelaaye osiila huula yawe mmatarikhi. ");
INSERT INTO eko_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Khanteela ovuja tteketthe yoomanyeya, wala khanteela ozimisa mweeke wootthuwela, mpakha athuule oshintta khwa shariya. ");
INSERT INTO eko_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Amalapo ooshi anttela wiiyana nroromelo khwa nzina lawe.” ");
INSERT INTO eko_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Paata ya toowo, khutiiseliwa namasheethwani woohooni na khaari ottakhula, Yinsa khunvonisa, khwaaza woona na ottakhula. ");
INSERT INTO eko_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Atthu ooshi khwiiya ooshanka channu khusala oozelana yoori: “Khahi mwaana wa Daawuuda otu?” ");
INSERT INTO eko_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mafwarizeewu akina noosiila toowo khuri: “Otu oniikara masheethwani paasi khwa owahi wa Belezibuuli, mfwalume wa masheethwani.” ");
INSERT INTO eko_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Aphano Yinsa noojuwa etthu aari wuupuwelaaye yo, khuwooza yoori: “Wakhula ofwalume wa waawanyeya khusala wuumana otthuuporu oniiya wootapanyeya, na wakhula sitati ama nyuupa yawaawanyeya ethiitoru khiniiyavo. ");
INSERT INTO eko_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nkhama Epiliisi onimwiikara Epiliisi, eetta ojaawanya otthweru. Toowo ofwalume awe onteela wiiyavo toovi? ");
INSERT INTO eko_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nkhama miiyo kiniikara masheethwani khwa owahi wa Belezibuuli, khi aaneenu aniikara toovi? Tiito aaneenu atthaapo ti anttelaaye wuuphukani mweeyo. ");
INSERT INTO eko_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ila nkhama kiniikara masheethwani khwa Rooho ya Nluku, eto enthoonyeza yoori Ofwalume wa Nluku woofiyelani. ");
INSERT INTO eko_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ama ntthu onvira toovi nnyupa wa nwali khuthuulamo maali zawe ahaazeeni khapula onfuka? Toowo phi oniwahaavo wiiya vitthu za nnyupa mwawe. ");
INSERT INTO eko_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Otule ahi vamote na miiyo ontta okuumanana, na otule ahinkusanyaaye khwa miiyo ontta omwaza. ");
INSERT INTO eko_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Etthiipo miiyo kiniwuuzani yoori: Twampi na kufuru zooshi za anaatamu zinswamihiwa, ila okufurwela Rooho Ttakatthiifu khunswamihiwa. ");
INSERT INTO eko_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Wakhula otule anlupaaye nttakhuzi la omuumanana Mwaana wa Pinaatamu onswamihiwa, ila otule anttakhulaaye wawuumananavo Rooho Ttakatthiifu khanswamihiwa, waaza nasaapi eti mpakha okhu ninttaawo. ");
INSERT INTO eko_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Muutthi wooshapweya oniima mishumo zooshapweya, muutthi wootakhala oniima mishumo zootakhala, maana wakhula muutthi onjuwiwa khwa mishumo zaya. ");
INSERT INTO eko_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ojama wa nyookha, enretteya mweeyo ootakhala rooho, ottakhula vitthu zooshapweya? Maana milomo enttakhula etile eniiyaaye varoho. ");
INSERT INTO eko_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ntthu wooshapweya rooho, mmujuju mwawe ensarulamo vitthu zooshapweya, wootakhala rooho mmujuju mwawe ensarulamo vitthu zootakhala. ");
INSERT INTO eko_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ila miiyo kiniwuuzani yoori, siikhu ya ophukiwa, atthu anlawa arettiwe hisapu mwaasa wa mattakhuzi ooshi ohiina fwayita aari olupakaaye. ");
INSERT INTO eko_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Maana khwa mattakhuzi enu mwinteela wonkokha na khwa atthaapo mwinteela ohukhumwiwa.” ");
INSERT INTO eko_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Aphano mafwarizeewu akina na anamanozela a kano khulupa yoori: “Mwaaliimu, nintakha woona alama ya minjuza yoorettiwa ti weeyo.” ");
INSERT INTO eko_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ye khujipu araka: “Khapila yootakhala na yooraruwa enveka alama ya minjuza, ila khinteela winkhiwa hatha moote ya ohiiyi alama ya napiyu Yuunusa. ");
INSERT INTO eko_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Maana nkhama etthiipo Yuunusa ekhaliyeeyo siikhu ttatthu nthana na osikhu mmatthupo wa swi, khwa etthiipo Mwaana wa Pinaatamu onttela wiikhala siikhu ttatthu nkhapuri. ");
INSERT INTO eko_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Atthu a Neniive anlawa alankhe siikhu ya ophukiwa, ookwiseleni paathuli mweeyo, maana yo athupwiya twampi zaya paata ya osiila tafusiiri ya Yuunusa, na aphano ori apha otule eeyiyeeyo nwulweene zayita Yuunusa. ");
INSERT INTO eko_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","N'hano wa Kusini onlawa alankhe siikhu ya ophukiwa ookwiseleni paathuli mweeyo, maana ye alankha peetiwene oteela osiila ojuwa wa Seleyimaana, ila nasaapi otu ariiye apha anziti Seleyimaana. ");
INSERT INTO eko_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Amana sheethwani anlawa ntthu, onvira nhali woohiimo maati eekesaka vahali woovumulavo, ila amana ahipatthivo. ");
INSERT INTO eko_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Aphano onri: ‘Kinrutela nyuupa ethiitile kilankhiyeeyo.’ Noofiya khusikana nyuupa eheettiweenimo, ori wooseeliwamo wawaattaleliwamo saana. ");
INSERT INTO eko_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ontta oruti khulawa khuwaatana masheethwani sapa ootepa otakhala, khweettamo khusala eekhala nttumpho, ntthu otule khweetta wootepa khuziti khiima etile aariyeeyo raku. Na enttela orettikhana etthiipo khwa khapila eti.” ");
INSERT INTO eko_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yinsa nalelo eettaka ottakhula na khuntti etile, mamaawe na attwiize aarettiye ari vaje, antakhaka yoori anttakhulane. ");
INSERT INTO eko_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ntthu mmote khumuuza yoori: “Mamaawo na attwiizo ari vaje antakha ottakhulana weeyo.” ");
INSERT INTO eko_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ye khujipu yoori: “Maama ti paani? Wala attwiizaku ti paani”? ");
INSERT INTO eko_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Khookolela nkhono awe phantte ya anakhiyoni awe khulupa araka: “Maama na attwiizaku pi apa ariiye apha. ");
INSERT INTO eko_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Maana otule anrettaaye matakhelo a Paapa ariiye pinkuuni, oto ti ttwiiyaku, nlupwaaka na ti maama.” ");
INSERT INTO eko_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Siikhu ethiitile Yinsa khulankha owawe khulawa nshini wa ntthatta. ");
INSERT INTO eko_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Khuzukuleliwa pi atthu awaatta, aphano ye khupakhira mmwaatiya khwiikhala. Atthu apale khweemela vapatari. ");
INSERT INTO eko_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ye khusala awaasomisa khwa milikaniso, araka: “Namalima aalawiiye ozala. ");
INSERT INTO eko_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Amwazaka peewu yawe, phantte kiina khukwela nshini wa tarikhi, anyannyi khuta khuja. ");
INSERT INTO eko_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kiina khukwela vahali aariivo mawe, vahali laarivo nttophe vattitthiiru; nasaapiru khoottha, ila wiiya nttophe ntthile khaleechiye. ");
INSERT INTO eko_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Aphano noopuwa njuwa khulukula na khuuma; maana khazaarina mitathaari. ");
INSERT INTO eko_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Peewu kinoko khukwela vanyiiwa, khuwula vamote na nyiiwa, khurapeliwa pi nyiiwa. ");
INSERT INTO eko_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kiina khukwela vanshaka wooshapweya, khwiima mishumo zooshapweya, miiya, mikina siithiini na talaathiini wakhula mmote! ");
INSERT INTO eko_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Otule ariina mashiilo ti asiile.” ");
INSERT INTO eko_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Anakhiyoni awe khunsusela khumuuzela yoori: “Mwaasa aya niini atthu apa owaattakhulelaka khwa milikaniso?” ");
INSERT INTO eko_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ye khuwaajipu: “Mweeyo mwenkhiwa ojuwa siiri za Ofwalume wa pinkuuni, ila yo wala. ");
INSERT INTO eko_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Maana, otule ariina, onttela winkhiwa, oniiyana zawaatta. Ila otule ahina,hatha etile ariinaaye ontta onyakanyiwa. ");
INSERT INTO eko_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tiito miiyo kiniwoozaaye khwa milikaniso: maana yo ana maasho ila khanoona, ana mashiilo ila khansiila, na wala khiniweeleya. ");
INSERT INTO eko_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Khwa yo wamariseleya ohupiri wa Ezaaya onlupaaye yoori: ‘Hatha nkhama mwasiila khiniweeleyani; hatha nkhama moona khamwinjuwa. ");
INSERT INTO eko_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Maana rooho za atthu apa pi zookhijili, attiyela mashiilo aya na khuphunya maasho aya, eriwaka khayaari ethiito, aari owahi woona na maasho aya, na osiila na mashiilo aya na oweeleya va rooho vaya khurutela mmakhono mwaka, keetta owaavonisa.’ ");
INSERT INTO eko_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ila ooparikhiyiwa maasho enu mweeyo, maana anoona; na maashiilo enu, maana ansiila. ");
INSERT INTO eko_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Miiyo kiniwuuzani khweele yoori: manapiyu enkeene na anashariya aatakhiye woona epi mwinoonaazo, ila khuhooni, na osiila epi mwinsiilaazo ila khuhisiili. ");
INSERT INTO eko_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Nakataalikha mwisiile na mwijuwe maana a nlikaniso wa namazala: ");
INSERT INTO eko_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Amana ntthu asiila nttakhuzi la Ofwalume khuhimweeleyi, Ntakhali ti antaaye khulazavo etile yaazaliweeyo nroho mwawe. Eto peewu etile yaakweliyeeyo nshini wa tarikhi. ");
INSERT INTO eko_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Etile yaakweliyeeyo vahali aariivo mawe pi apale ansiilaaye nttakhuzi nasaapiru khupokherela na furaha. ");
INSERT INTO eko_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ila mwaasa wa ohiina mitathaari eenyeweru, anlipalipa khwa wakathi vattitthiiru. Amana epuwelela miswipa ama lupattha mwaasa wa nttakhuzi la Ofwalume anlikha nasaapiru amini yaya. ");
INSERT INTO eko_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Etile yaakweliyeeyo va nyiiwa, pi apale ansiilaaye nttakhuzi, ila mwaasa wa tafwawuthi za ohaayi, na ottettekha wa maali entta owaakhupa, ahifiyelelaka wiima mishumo. ");
INSERT INTO eko_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ila etile yaakweliyeeyo vahali wooshapweyavo pi apale ansiilaaye nttakhuzi khuweeleya, khwiima mishumo miiya, khwiima siithiini, talaathiini khwa muutthi mmote.” ");
INSERT INTO eko_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yinsa khuwooza nlikaniso nkina araka: “Ofwalume wa pinkuuni ori nkhama ntthu mmote azaliyeeyo peewu yooshapweya mmashapa mwawe. ");
INSERT INTO eko_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Osikhu mmote, atthu ooshi eettaka olala, khuta atuwi vakatthi wa tiriku khuzalavo ntakhatakha, khulawa. ");
INSERT INTO eko_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wakathi tiriku ewuliyeevo khupuwa misaasi zaya, naye ntakhatakha khupuwa misaasi zaya. ");
INSERT INTO eko_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Akarumeya a mweenyewe nshapa khulawa wa mweenyewe khumuuza yoori: ‘Mbwana, mweeyo mwaazaliye peewu yooshapweya mmashapa mwenu. Khi aphano ntakhatakha lapuwa vayi?’ ");
INSERT INTO eko_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ye khujipu yoori: ‘Atuwi ti arettiye epo zaya.’ Akarumeya apale khumuuzela yoori: ‘Mbwana mwintakha fweeyo nalazemo?’ ");
INSERT INTO eko_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ye khujipu yoori: ‘Wala, maana, amana mwikhulakamo ntakhatakha nttho, mwintta okhula vamote na tiriku. ");
INSERT INTO eko_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mwilikhe ziwulele vamote mpakha wakathi wa wuurula. Kintta owooza anamuurula yoori: “Mwikusanye khapula ntakhatakha mwifuke mashittha likhoziwe; mwikusanye tiriku mwitthe va sakafu vaka.’” ");
INSERT INTO eko_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Na khuwooza nlikaniso nkina araka: “Ofwalume wa pinkuuni ori nkhama phunje ya samuli, ntthu anthulaaye khuzala mmashapa mwawe. ");
INSERT INTO eko_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Eto ttiitthiiru zayita peewu zooshi, amana owula onziti miitthi zooshi za mmashapa, anta anyannyi ojeka vijaaro n'virapi mwaya.” ");
INSERT INTO eko_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Khuwooza nlikaniso nkina araka: “Ofwalume wa pinkuuni ori nkhama fwaramento muukha anthuulaaye khuphakanya na ofu wa tiriku wa waatta, wooshi khujakhuwa. ");
INSERT INTO eko_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yinsa aari wuuza khuntti etile, khwa nlikaniso. Weekhweele, khina etthu moote aari owoozaaye woohiiyi khwa nlikaniso. ");
INSERT INTO eko_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Eto yaari orettikhana yoori eretteye etile yaalupiweeyo ti napiyu yoori: “Kinteela ofunula milomo zaka khwa nlikaniso, na olaleya vitthu zoovitheya waaza wumpiwa wa olumwenku.” ");
INSERT INTO eko_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Aphano ye khuwaalikha atthu apale khulawa owawe. Anakhiyoni awe khumwaattama khunvekela yoori: “Oneeleze nlikaniso wa ntakhatakha.” ");
INSERT INTO eko_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ye khujipu yoori: “Otule aazaliyeeyo peewu wooshapweya ti Mwaana wa Pinaatamu. ");
INSERT INTO eko_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nshapa olumwenku, peewu yooshapweya aana a Muufwalume. Ntakhatakha aana a sheethwani. ");
INSERT INTO eko_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Atuwi aazaliyeemo ti sheethwani. Wuurula, mwiisho wa wakathi, akarumeya a wuurula malayikha. ");
INSERT INTO eko_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nkhama etthiipo ntakhatakha linuuruliwaazo khukhoziwa va moottho, enttela wiiya etthiipo mwiisho wa olumwenku. ");
INSERT INTO eko_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwaana wa Pinaatamu onttela oruma malayikha awe, alazemo muufwalume mwawe zooshi epile zookwakwanttula, na apale anrettaaye vitthu zootakhala. ");
INSERT INTO eko_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Aweeselele va njocho la moottho, attaapho onttela wiiyavo olila na oluma meeno. ");
INSERT INTO eko_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Aphano anashariya anttela waara nkhama njuwa muufwalume wa Papaaya. Ariina mashiilo, ti asiile.” ");
INSERT INTO eko_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ofwalume wa pinkuuni ori nkhama njuju loovithiwa mmashapa. Ntthu mmote, khulawa khusikana, na ye khuvitha opheya. Mwaasa woofurahi khulawa khuuzanyisa vitthu zawe zooshi aarinaazo khuuzanya nshapa ntthile. ");
INSERT INTO eko_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Theenya Ofwalume wa pinkuuni ori nkhama nakusiyanti aneekesaaye mawe ootafikhana. ");
INSERT INTO eko_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Noosikana liwe la fwayita khuluyeene, khuuzanyisa vitthu zooshi aariinaazo khuuzanya.” ");
INSERT INTO eko_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ofwalume wa pinkuuni ori nkhama ntthavi laweesiwa mpahari khuula wakhula jaati ya swi. ");
INSERT INTO eko_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Amana liitaala, anamajiya anfutthela vathi. Aphano yo khukusanya swi epile zooshapweya khuttha mmakapaja, ila epile zoohishapweyi khweesela. ");
INSERT INTO eko_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Enttela orettikhana etthiipo mwiisho wa olumwenku. Malayikha anteela owaaphakula ootakhala rooho na anashariya, ");
INSERT INTO eko_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","aweeselele va njocho la moottho apale ootakhala rooho, attaapho onttela wiiyavo olila na oluma meeno.” ");
INSERT INTO eko_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Aphano Yinsa khuwoozela yoori: “Zaweeleyani vitthu zooshi kilupiyeeyo?” Yo khujipu yoori: “Aaa!” ");
INSERT INTO eko_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ye khuwooza yoori: “Tiito wakhula namanozela a kano anozeliweeyo monkoni wa Ofwalume wa pinkuuni onlattanana mweenyewe nyuupa anlazaavo va njuju vawe vitthu pheeya na vitthu zaraku.” ");
INSERT INTO eko_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Paata ya Yinsa wiisha olupa milikaniso epile, khulaawo okhule waya. ");
INSERT INTO eko_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Khufiya sitati yawe, ohali aari wiikhalaawo. Ye khwaaza owaasomisa atthu nsinakooka. Atthu ooshi khwiiya ooshankisiwa, khusala oozela yoori: “Ojuwa opu apattha vayi na owahi wa oretta minjuza? ");
INSERT INTO eko_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Khahi mwaana wa kalapinteero? Nzina la mamaawe khahi Mariyamu? Attwiize khayi Tiyaaku, Yuusufu, Simawu na Yuuda? ");
INSERT INTO eko_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Alupuwe ooshi khaniikhala nttumphu? Khi vitthu epi apattha vayi?” ");
INSERT INTO eko_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Atthu ooshi khuhinkhupali. Ila ye khulupa yoori: “Napiyu ti wooshitahiwa phantte zooshi, ila mmuti mwawe na owawe khanshitahiwa.” ");
INSERT INTO eko_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yinsa khaarettiye minjuza zawaatta mmuti mphule, maana yo khaarina amini. ");
INSERT INTO eko_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Wakathi aya opule Herooti Antiipa, nsatoro wa Kalileya, khusiila olupiwa monkoni wa Yinsa. ");
INSERT INTO eko_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ye khuwooza akarumeya awe yoori: “Oto ti Yaahaya Namoosa; eetta osisimuwa muufwa! Tiito ariinaaye owahi wa oretta minjuza.” ");
INSERT INTO eko_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Maana aarettiye Herooti antthiiye Yaahaya nkalapooso, mwaasa wa Herotiiya, muukha wa Filiipe, ttwiiye, ");
INSERT INTO eko_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","mwaasa wa Yaahaya omuuza yoori: “Khahi halaali weeyo onrala ye.” ");
INSERT INTO eko_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herooti aari otakha omuula, ila khusala awoova atthu, maana yo aari ojuwa yoori Yaahaya napiyu. ");
INSERT INTO eko_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Va njampo la oretta mwaakha Herooti, mwaana wa Herotiiya khwiina vakatthi wa atthu ooshi, khuntuvelisa Herooti, ");
INSERT INTO eko_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ye khumwaahiti khwa olapha omwinkha wakhula etile aari weettelaaye onvekela. ");
INSERT INTO eko_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Khwa shawuri za winkhiwa ti mamaawe, mwaana otule khulupa yoori: “Mwikitiisele mparathu eeshwa ya Yaahaya Namoosa.” ");
INSERT INTO eko_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mfwalume khwiiya wooshukulikha, ila mwaasa wa olapha na mwaasa wa anamalaleyiwa, ye khuruma yoori enkhiwe etile mwaana otule avekiyeeyo. ");
INSERT INTO eko_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Khuruma olawa oshijiwa eeshwa ya Yaahaya Namoosa nkalapooso. ");
INSERT INTO eko_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Eeshwa yawe khuthuuliwa mparathu khulawa khwinkhiwa mwaana otule, ye khuthuula khulawa khumwinkha mamaawe ");
INSERT INTO eko_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Anakhiyoni a Yaahaya khuta, khuthuula mwiili awe khulawa khuzikha. Nawiisha khulawa onthatelela Yinsa. ");
INSERT INTO eko_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Noosiila vitthu zaarettikhaniyeezo, Yinsa khupakhira mmwaatiya khulaawo okhule waya, khweetta ohali yaariiwo yaara otthwe. Ila atthu noojuwa, khulankha nsitati mphule khusala anlottelela mwentto. ");
INSERT INTO eko_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yinsa noopakhuwa khuwoona atthu awaatta, khuwoonela huruma, khuwaavonisa alwele aariivo. ");
INSERT INTO eko_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Njuwa-looveva, anakhiyoni awe khunsusela khumuuza yoori: “Mphu n'yaara na ontta oripa. Owaamwaze atthu apa eette mmamuti mpho oozanye etthu yoojiwa.” ");
INSERT INTO eko_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yinsa khuwaajipu araka: “Khinihithajiya yo olawa. Mweeyo ena mwiwenkhe etthu yoojiwa.” ");
INSERT INTO eko_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yo khulupa yoori: “Fweeyo ninaaye phaawu thaanu na swi piiri.” ");
INSERT INTO eko_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Aphano ye khulupa yoori: “Mwikitiisele.” ");
INSERT INTO eko_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Khuruma yoori atthu apale eekhale va nyaani, khuthuula phaawu epile thaanu na swi epile piiri, khweekesa otulu, khuparikhiya. Khumeya phaawu epile. Khuwenkha anakhiyoni awe, yo khusala awenkha atthu. ");
INSERT INTO eko_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ooshi khuja khurupala, anakhiyoni khulokotthela khelenke khumi na piiri nyeenye zoosala. ");
INSERT INTO eko_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Atthu aajiyeeyo aari alume alufu thaanu, ohiwaatthiimo aakha na asimaana. ");
INSERT INTO eko_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nasaapiru Yinsa khuwaaruma anakhiyoni awe yoori apakhire mmwaatiya alokoze eette phantte kiina, ye aasaliye awaaleezaka atthu apale. ");
INSERT INTO eko_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Paata ya owaaleeza atthu, khuwela va mwaako olawa olompa. Khuripa ye ari attaaphale otthwe, ");
INSERT INTO eko_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ila wakathi aya opule mwaatiya waari peetiwene na vathi, weettaka opiiwa ti mawipi venkivene maana pheevo eetta wiinyula. ");
INSERT INTO eko_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Lifwajiri, Yinsa khusala eetta attaaphale aarivo anakhiyoni awe eettettaka vatulu a maati. ");
INSERT INTO eko_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Noomoona eettaka weettetta vatulu a maati yo khwiiya oosuthuwa khulupa yoori: “Opu nshitapehe!” Yo khusala anyakula na woova. ");
INSERT INTO eko_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ila Yinsa khuwooza yoori: “Mwiminyale! Ti miiyo. Mwihoove!” ");
INSERT INTO eko_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Khujipu Pheeturu yoori: “Nkhama ti weeyo khweele Mbwana, okirume kite attaapho oriivo, keettettaka vatulu a maati.” ");
INSERT INTO eko_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yinsa khunjipu, araka: “Ote.” Aphano Pheeturu khulaamo mmwaatiya, khusala eettetta vatulu a maati eettaka phantte etile aariiwo Yinsa. ");
INSERT INTO eko_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Paata ya woona khiima pheevo etile yaari ovumaazo, khoova khusala azama vattiitthi-vattiitthi, ettaka onyakula araka: “Mbwana, okuusuru!” ");
INSERT INTO eko_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nasaapiru Yinsa khookola nkhono awe khunkholelela. Khumuuza yoori: “Ntthu woopushuwa amini, ohaaminaka mwaasa aya niini?” ");
INSERT INTO eko_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Paata ya owela mmwaatiya, pheevo etile khwiisha. ");
INSERT INTO eko_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Apale aari mmwaatiya khumwaaputu alupaka yoori: “Khweele weeyo o Mwaana wa Nluku.” ");
INSERT INTO eko_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Paata ya olokha pahari, khufiya Jenezare. ");
INSERT INTO eko_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Wakathi atthu a mmuti mphule anjuwiyeevo yoori ti Yinsa, khumwazela hapari mmuti mphule wooshimo, atthu akina khusala awaatana alwele. ");
INSERT INTO eko_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Anvekelaka yoori nenkawu asape nshaka la ajapi yawe; ooshi asapiyeeyo aavoniye. ");
INSERT INTO eko_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Aphano khulankha Yeruzaleemu, Mafwarizeewu akina na anamanozela a kano khuta omuuzela Yinsa yoori: ");
INSERT INTO eko_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mwaasa aya niini anakhiyoni awo akhijilelaka zowera za attunkhulu a tiini, oja ahinaweeni?” ");
INSERT INTO eko_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yinsa khuwaajipu araka: “Mwaasa aya niini mweeyo mwikhijilelaka kano za Nluku, mwaasa wa zowera zenu? ");
INSERT INTO eko_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Maana Nluku alupa yoori: ‘Onshitahi papaawo na mamaawo’ na ‘antakhaaye onlaani papaawe na mamaawe ona ya ohukhumweliwa ofwa.’ ");
INSERT INTO eko_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ila mweeyo mwinkhupalela yoori amana ntthu amuuza papaawe ama mamaawe yoori: ‘Wakhula etthu kiniwinkhaanini miiyo zaakha ya omwinkha Nluku; ");
INSERT INTO eko_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ye khankhanyareliwa theenya onshitahi papaawe khwa nanna nkhama eto.’ Khwa etthiipo, mwaasa wa zowera zenu, mweeyo mwimpeepheyisa nttakhuzi la Nluku. ");
INSERT INTO eko_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Manaafikhi! Ezaaya ahupiri saaneene monkoni wa mweeyo araka: ");
INSERT INTO eko_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Atthu apa anikaaputu na milomo, ila rooho zaya ziri peetiwene khwa miiyo. ");
INSERT INTO eko_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mweeyo mwinikaaputu mahala, mwisomisaka zowera za anaatamu.’” ");
INSERT INTO eko_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yinsa khuwaakhuwela atthu apale khuwooza yoori: “Mwisiile na eweeleyeni. ");
INSERT INTO eko_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Khahiyo etile entthiwaaye nkhanyo eninharamushaaye ntthu; ila etile enlankhaaye nkhanyo ti eninharamushaaye.” ");
INSERT INTO eko_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Aphano anakhiyoni awe khulawa khumwaattama khumuuzela yoori: “Wajuwa yoori mafwarizeewu noosiila hapari epile eephiriwa?” ");
INSERT INTO eko_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yinsa khuwaajipu yoori: “Miitthi zooshi zihizaliweeni ti Paapa wa pinkuuni zinttela okhuliwa na mitathaari zaya. ");
INSERT INTO eko_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mwiwaalikhe, maana yo khanoona na aniweettettisa ananhooni. Amana ntthu woohooni amweettettisa nahooni nzaawe ooshi antta okwela nliphotto.” ");
INSERT INTO eko_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Aphano Pheeturu khunvekela Yinsa yoori: “Onuuze maana a nlikaniso opo.” ");
INSERT INTO eko_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yinsa khuwaajipu yoori: “Kiri na mweeyo nalelo khiniweeleyani? ");
INSERT INTO eko_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yoori zooshi zintthiwaaye nkhanyo zineetta mwiijohojoho na khunyiwa? ");
INSERT INTO eko_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ila vitthu zinlankhaaye nkhanyo zinlankha va rooho na piitthiipo eninharamushaaye pinaatamu. ");
INSERT INTO eko_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Maana nroho ti zinlankhaamo shawuri zootakhala nkhama epi: wuula, oraruwa, oshawi akhapa, wiiya, olokova na ohankawaani. ");
INSERT INTO eko_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Epo pi eninharamushaaye ntthu. Ila oja ohinaweeni khininharamusha ntthu.” ");
INSERT INTO eko_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Paata ya Yinsa olaavo aphale vaya, khusala alawa nti wa Tiiro na Sitooni. ");
INSERT INTO eko_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Muukha wa Kanaani aari wiikhalaaye nti otthuupule, khuta okutthanana Yinsa eettaka okhuwa yoori: “Mbwana, Mwaana wa Daawuuda, koonele huruma! Mwanaka etta wiiyana masheethwani na ontta ohoowa channu.” ");
INSERT INTO eko_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ila Ye khuhinjipu hatha nttakhuzi, anakhiyoni awe khulupa yoori: “Omuuze alawe, ontta onyakula nyuma wetthu.” ");
INSERT INTO eko_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yinsa khujipu yoori: “Miiyo kaperekhiwa paasi khwa pwittipwitthi epile zawaashikha za Ezirayiilu.” ");
INSERT INTO eko_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Muukha otule khuta khukokhora na khuri: “Mbwana, okaawuni!” ");
INSERT INTO eko_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Aphano Yinsa ajipwaka khuri: “Khahiyo yooshapweya othuula phaawu ya aana khuwenkha aana aanapwa.” ");
INSERT INTO eko_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Muukha otule khujipu yoori: “Khweele Mbwana, ila na aana aanapwa anja tathela zinkwaaye vameeza wa mweenyewe.” ");
INSERT INTO eko_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Aphano Yinsa khumuuza yoori: “Oo muukha, amini yawo khuluyeene! Ti erettikhane etile ontakhaaye.” Na wakathi otthuupule mwanawe khwiiya woovona. ");
INSERT INTO eko_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yinsa khulaawo okhule waya khulawa mpakha nshini wa pahari ya Kalileya. Khuwela va mwaako khwiikhala attaapho. ");
INSERT INTO eko_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Khusala ata atthu awaatta, awaatanaka anamarakala, ananhooni, anamakhumuwa, ananhittakhuli na akinoko aya, khuwaalikha nshini wa Yinsa, ye khuwaavonisa. ");
INSERT INTO eko_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Atthu khwiiya ooshanka wakathi awooniyeevo ananhittakhuli eettaka ottakhula, anamarakala ari oovona, anamakhumuwa eettaka weettetta na ananhooni eettaka woona. Yo khunsifu Nluku wa Ezirayiilu. ");
INSERT INTO eko_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yinsa khuwaakhuwela anakhiyoni awe na khuwooza yoori: “Kinaaye tthakaraka na atthu apa; zavira siikhu ttatthu ari vamote na miiyo na khana hatha etthu-yoojiwa. Akintakha owaalikha olawa na jala zaya, maana kinoona yoori antta ozileya ntarikhi.” ");
INSERT INTO eko_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Anakhiyoni awe khujipu yoori: “Ninttela opattha vayi phaawu zoofiyela, atthu apa waatta na mphu n'yaara?” ");
INSERT INTO eko_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ye khuwoozela yoori: “Mwina phaawu kavi?” Yo khujipu yoori: “Sapa, na mattaatta vattitthiiru.” ");
INSERT INTO eko_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yinsa khuruma yoori atthu apale eekhale. ");
INSERT INTO eko_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Khuthuula phaawu epile sapa na swi khushukhurwela khumeya khuwenkha anakhiyoni awe, khusala awaawanyeza atthu. ");
INSERT INTO eko_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ooshi khuja khurupala. Anakhiyoni apale khukusanya khelenke sapa za pattaasu zasaliyeeyo. ");
INSERT INTO eko_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Atthu aajiyeeyo aari alufu nne, ohiwaalaki aakha na asimaana. ");
INSERT INTO eko_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Paata ya oleezanana atthu apale, Yinsa khupakhira mmwaatiya khulokhela nti wa Makata. ");
INSERT INTO eko_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafwarizeewu na masatukhi khumwaattama Yinsa khusala amweeza anvekelaka alama moote yoolankha pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ye khuwaajipu araka: “Amana njuwa liveva, mweeyo mwinraka, ‘Onttela wiiya wakathi wooshapweya, maana pinku ti yookhuttuwa.’ ");
INSERT INTO eko_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na leelo supu, ‘Enttela opuwa pheevo, maana pinku ti yookhuttuwa na eetaalawo mawiku.’ Mweeyo mwinjuwa otaphulela nanna ya pinku, ila khamwinjuwa otaphulela alama za wakathi! ");
INSERT INTO eko_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Khapila yootakhala na yooraruwa anveka alama ya minjuza, ila hatha alama khanlawa winkhiwa yoohiiyi alama ya Yuunusa.” Aphano Yinsa khuwaalikha khulaavo aphale vaya. ");
INSERT INTO eko_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Paata ya olokhela phantte kiina ya pahari, anakhiyoni khusophela yoori asahawu othuula phaawu. ");
INSERT INTO eko_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yinsa khuwooza yoori: “Mwiiye wa woona na mwiiyane phoole na fwaramento za mafwarizeewu na za masatukhi.” ");
INSERT INTO eko_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Anakhiyoni apale khwaaza onyakulisana atthaaporu, araka “mwaasa aya ohithuuli phaawu.” ");
INSERT INTO eko_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Asiiliyeevo onyakulisana opule, Yinsa khuwooza yoori: “Atthu oopushuwa amini, mwaasa aya niini mwinnyakulisana mweeyena-ru? Mwaasa woohiina phaawu? ");
INSERT INTO eko_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nalelo khina weeleyeni? Khamwimfikhirela phaawu epile thaanu miiyo kawaawanyeziyeeyo atthu alufu thaanu? Khelenke kavi mweetaaziyeeyo? ");
INSERT INTO eko_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Wala khwa phaawu sapa aarafuniyeeyo atthu alufu nne, na zaari khelenke kavi mwilokottheliyeeyo? ");
INSERT INTO eko_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nanna-ni ehiniweeleyaanini yoori akaari owuuzani monkoni wa phaawu? Mwiiyane phoole na fwaramento ya mafwarizeewu na za masatukhi.” ");
INSERT INTO eko_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Aphano khuweeleya yoori khaari owooza wiiyana phoole na fwaramento ya phaawu, ila khwa masomi a Mafwarizeewu na masatukhi. ");
INSERT INTO eko_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yinsa afiyeevo nti wa Sezareeya ya Filiipe, khuwoozela anakhiyoni awe yoori: “Atthu aninlupeza niini Mwaana wa Pinaatamu?” ");
INSERT INTO eko_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yo khujipu yoori: “Akina anri o Yaahaya namoosa; akina, anri o Aliyaasi, akina anri o Jeremiiya ama mmote wa manapiyu.” ");
INSERT INTO eko_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Khurutela owoozela theenya yoori: “Khi mweeyo mwinri ki paani?” ");
INSERT INTO eko_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simawu Pheeturu khujipu yoori: “Weeyo o Al-Masiihu, Mwaana wa Nluku haayi.” ");
INSERT INTO eko_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yinsa khujipu yoori: “Wooshapweyiwa ti weeyo, Simawu mwaana wa Yoona! Maana vitthu zaya epi khuthoonyeziweeni ti pinaatamu, ila khwa Paapa ariiye pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Miiyo kiniwuuza yoori weeyo o Pheeturu, khwa liwe nttintthi kinjekana ojama wa Nluku na milako za motthooni khazinlawa oshintta. ");
INSERT INTO eko_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Miiyo kiniwinkha efukulo ya Ofwalume wa Pinkuuni; etile onfukaaye vathi apha na pinkuuni entta ofukiwa, na etile weeyo onfukulaaye vathi apha na pinkuuni entta ofukuliwa.” ");
INSERT INTO eko_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aphano khuwooza anakhiyoni awe yoori ahiwooze akinoko yoori ye aari Al-Masiihu. ");
INSERT INTO eko_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Waaza wakathi otthuupule, Yinsa khwaaza oweeleza anakhiyoni awe araka: Yaari ohithajiya olawa Yeruzaleemu ahoochaniwe vitthu zawaatta mmakhono wa attunkhulu a tiini, mahaakhimu a tiini na anamanozela a kano, ooliiwe, siikhu ya ttaatthu asisimuwe nkhapuri. ");
INSERT INTO eko_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Aphano Pheeturu, khunkhuwelela othetekele khusala amuuza yoori: “Wala Mbwanaaka aka! Khinteela wuurettikhanela!” ");
INSERT INTO eko_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yinsa khuzukuluwa khumuuza Pheeturu yoori: “Weette nyuma waka Sheethwani! Weeyo ori nkhama liwe liriiye ntarikhi mwaka yoori likikwakwattule, maana onuupuwela nkhama pinaatamu woohiiyi nkhama anuupuwelaazo Nluku.” ");
INSERT INTO eko_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Aphano Yinsa khuwooza anakhiyoni awe yoori: “Nkhama ntthu ontakha okilotta, ajikatthale mweenyewe, athuule nsalapa awe akilotte. ");
INSERT INTO eko_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Maana otule antakhaaye wuusuru ohaayi awe ontta ompwetheya, ila otule onimpwetheyaaye ohaayi awe mwaasa wa miiyo ontta wuusurukha. ");
INSERT INTO eko_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ena fwayita-ni ntthu opattha fwayita olumwenku wooshi na khumwaashikha ohaayi awe? Ama niini pinaatamu antakhaaye opatilana ohaayi awe? ");
INSERT INTO eko_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Apho Mwaana wa Pinaatamu onlawa ate nnuuru wa Papaawe na malayikha awe, amwinkhe phakari wakhula ntthu khwa etile arettiyeeyo. ");
INSERT INTO eko_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Miiyo kiniwuuzani khweele yoori, awaapho apha atthu akina ahinttelaaye ofwa ahimooneni khapula Mwaana wa Pinaatamu ataka nkhama mfwalume.” ");
INSERT INTO eko_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ziviriyeevo siikhu sitha, Yinsa khunthuula Pheeturu, Tiyaaku na Yaahaya ttwiiye Tiyaaku, khuwaalawana othetekele va mwaako woolepa. ");
INSERT INTO eko_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Attaaphale Yinsa khuzukulisiwa vakatthi vaya. Wuuso awe khwaara nkhama njuwa kuwo zawe khwiiya zoolakala nkhama nuuru. ");
INSERT INTO eko_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Wakathi otthuupule khupuwelela omaasho waya Munsa na Aliyaasi apiyaka mwaasa na Yinsa. ");
INSERT INTO eko_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Aphano Pheeturu khumuuza Yinsa yoori: “Mbwana, ti yooshapweya wiiya attaapha. Amana otakha, kintta ojeka heema ttatthu; moote yawo, moote ya Munsa, kiina ya Aliyaasi.” ");
INSERT INTO eko_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pheeturu eettaka ottakhula nalelo, khupuwa liwiku lawaara khuwaafinikha, nttumpho khupuwamu huula yaari oraaye: “Otu mwanaka wompheta na wookituvela channu. Mwinsiileze!” ");
INSERT INTO eko_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Asiiliyeevo mattakhuzi apale anakhiyoni awe khukokhora khufiisa ajihi zaya vathi na khuwaapattha woova. ");
INSERT INTO eko_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ila Yinsa khuwaattama, khuwaasapa na khuwooza yoori: “Mwilankhe, mwihoove!” ");
INSERT INTO eko_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Afunuliyeevo maasho khuhimooni hatha ntthu, khusala amoona Yinsa paasi. ");
INSERT INTO eko_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Eettaka wiishukha vamwaako aphale, Yinsa khuwooza yoori: “Mwihimuuze hatha ntthu epile mooniyeeyo, mpakha Mwaana wa Pinaatamu asisimuwe muufwa.” ");
INSERT INTO eko_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Anakhiyoni apale khumuuzela yoori: “Aphano mwaasa aya niini anamanozela a kano anlupaaye yoori enhithajiya Aliyaasi ota khapula?” ");
INSERT INTO eko_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yinsa khujipu yoori: “Wekhweele Aliyaasi onta arutisele vitthu zooshi. ");
INSERT INTO eko_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ila miiyo kiniwuuzani yoori Aliyaasi ata, yo khuhinjuwi, ila khunrettela zooshi epile atakhaziyeeyo. Khwa nanna etthiipo Mwaana wa Pinaatamu onttela ohoochiwa pi atthaapo.” ");
INSERT INTO eko_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Aphano anakhiyoni apale khuweeleya yoori Yinsa aari olupa monkoni wa Yaahaya namoosa. ");
INSERT INTO eko_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Wakathi afiyeevo aphale yaariivo khuntti etile ya atthu, mwinyi mmote khulawa aphale aariivo Yinsa khunkokhorela, ");
INSERT INTO eko_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","khumuuza yoori: “Mbwana, omoonele huruma mwanaka! Eetta wiiyana jilejile entta onhoocha. Swaafu zinki onkwela vamoottho ama mmaati. ");
INSERT INTO eko_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Miiyo kawaatiseliye anakhiyoni awo, ila khuhiwahi onvonisa.” ");
INSERT INTO eko_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yinsa khuwaajipu yoori: “Oo khapila yootakhala na yoohiina amini! Mpakha lini kinttelaaye wiiya vamote na mweeyo? Mpakha lini kuuvilelakani? Mwikitiisele mwanenu apha!” ");
INSERT INTO eko_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Aphano Yinsa khuruma yoori masheethwani ansaruwe, wakathi otthuupule mwaana otule khwiiya woovona. ");
INSERT INTO eko_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Paata ya toole, anakhiyoni awe khunsusela Yinsa othetekele, khumuuzela yoori: “Mwaasa aya niini nahaakhitireliyeeyo wiikara?” ");
INSERT INTO eko_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ye khuwaajipu yoori: “Maana mweeyo amini mwiriina ttiitthiiru. Miiyo kiniwuuzani khweele yoori eriwaka mweettiye wiiyana amini nkhama phunje ya samuli, mweetta owahi wuuza mwaako opu yoori: ‘Oleevo apha weette aphale’ weetta olawa, na khina etthu moote ya haari weettelaaye owaheya khwa mweeyo.” ");
INSERT INTO eko_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ila vitthu epo zinta nkatthi wa lompa na ofuka paasi. ");
INSERT INTO eko_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Siikhu moote Yinsa na anakhiyoni awe aakusanyeyiye Kalileya, ye khuwooza yoori: “Mwaana wa Pinaatamu onlawa enkheleliwe mmakhono wa atthu. ");
INSERT INTO eko_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Yo anttela omuula, siikhu ya ttaatthu asisimuwe.” Anakhiyoni awe khuwaapattha huzuni. ");
INSERT INTO eko_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Wakathi Yinsa na anakhiyoni awe afiiyeeyo Kafwaranaawu, anamariphisa lumpuru khulawa omuuzela Pheeturu yoori: “Mwaaliimu enu khanripha lumpuru la Nnyupa Woosifwiwamo?” ");
INSERT INTO eko_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pheeturu khuwaajipu yoori: “Onripha!” Nawiisha Pheeturu khuvira nnyupa, ahinattakhule hatha etthu, Yinsa khuri: “Simawu, onoona toovi? Paani anriphaaye lumpuru na tthuvo ya mfwalume wa olumwenku opu? Atthu a mmuti nttumphu ama aletto?” ");
INSERT INTO eko_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pheeturu khujipu yoori: “Aniiya aletto,” Yinsa khumuuza yoori: “Eto enthoonyeza yoori aana a mmuti ana yoohiriphi. ");
INSERT INTO eko_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ila yoori nihiweephirise, olawe mpahari wamweese nanjoolo awo. Swi ethiito ya mwanzo onttelaaye olowa, ofunule milomo zaya, ontta osikanamo nzurukhu mmote. Aphano olawe wariphe lumpuru laka na lawo.” ");
INSERT INTO eko_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Wakathi otthuupule anakhiyoni khuta aphale aariivo Yinsa khumuuzela yoori: “Nwulweene zayita akina aya, ti paani muufwalume wa pinkuuni?” ");
INSERT INTO eko_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ye khunkhuwela nsimaana khunttha vakatthi vaya, ");
INSERT INTO eko_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","khuwooza yoori: “Miiyo kiniwuuzani khweele yoori, mweeyo noohithupwiyi na khuhijiretti wiiya nkhama nsimaana otu, khamwinteela weettamo muufwalume wa pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Wekhweele anjipushuwisaaye nkhama nsimaana otu, oto ti nwulweene aya muufwalume wa pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Animpwekherelaaye nsimaana nkhama otu khwa nzina laka, onikipwekherela miiyo. ");
INSERT INTO eko_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Wakhula otule aninkosisaaye mmote wa asimaana apa akikhupaliyeeyo, afwataali ofukeleliwa liwe loovalaza mmwisiko khutupweeziwa nkhilintti ya pahari. ");
INSERT INTO eko_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Phoole olumwenku, mwaasa wa vitthu za okosisa. Maana khinivonyela ohirettikhani vitthu zaya epo, ila atakhaliwa ntthu otule anttelaaye wiiyana paathuli. ");
INSERT INTO eko_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nakataalikha nkhama nkhono awo ama muulu awo onuukosisa, oshije weesele! Maana afwataali weeyo weetta muuhaayi wa mileele ori woorakala ama woovujeya ehiiyeeni wiiyana makhono mawiri na moolu mawiri weeyo aya khweeseleliwa va moottho wa mileele. ");
INSERT INTO eko_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nkhama liisho lawo limote linuukosisa, olazemo weeselele peetiwene! Maana afwataali weeyo weetta muufwalume wa pinkuuni na liisho limote ehiiyeeni weeseleliwa motthooni na maasho mawiri. ");
INSERT INTO eko_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Phoole, mwihintarawu hatha mmote wa asimaana apa! Miiyo kiniwuuzani khweele yoori malayikha aya anoona wuuso wa Paapa wa pinkuuni wakhula wakathi. ");
INSERT INTO eko_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Wekhweele Mwaana wa Pinaatamu ateela wuusuru etile yaashikhiyeeyo. ");
INSERT INTO eko_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Niini onuupuwelaaye weeyo? Amana ntthu eeyana pwittipwitthi zawe miiya khumwaashikhavo moote, khanlikha epile tiisiya wa tiisiini omwaako alawa weekesa etile yaashikhiyeeyo? ");
INSERT INTO eko_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Miiyo kiniwuuzani khweele yoori, amana asikana oniiya woofurahi mwaasa wa pwittipwitthi yawe etile, zayita epile tiisiya wa tiisiini zoohaashikhi. ");
INSERT INTO eko_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Etthiipo theenya Paapeenu ariiye pinkuuni khanintakhela hatha nsimaana mmote waashikha. ");
INSERT INTO eko_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Amana ttwiiyo ookosa, olawe wanthoonyeze etile avonyiyeeyo, ila orette epo zaya weeyo na ye paasi. Amana ye asiila shawuri zawo, wamwaawuni ttwiiyo. ");
INSERT INTO eko_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ila amana ahuusiili, onthuule ntthu mmote ama awiri, ‘yoori khwa oshaahiti wa atthu awiri ama attatthu yoori nttakhuzi lihakikheye.’ ");
INSERT INTO eko_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Amana ye akatthala wuusiila, walupe vakatthi wa ojama wa Nluku. Amana ye akatthala osiileza theenya ojama wa Nluku, ontthantte nkhama kaafiri ama namariphisa lumpuru. ");
INSERT INTO eko_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Kiniwuuzani khweele yoori, zooshi epile mweeyo mwinfukaaye vathi apha, ziniiya zoofukiwa pinkuuni, na zooshi mwinfukulaaye vathi apha ziniiya zoofukuliwa pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","kiniwuuzani theenya yoori awiri a mweeyo amana mwikhupalelana vathi apha khwa wakhula etthu etile mwintakhaaye oveka, eniiya yoorettiwa ti Paapa ariiye pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Maana vahali ankusanyeyaavo atthu awiri ama attatthu khwa nzina laka, na miiyo kiniiya attaapho.” ");
INSERT INTO eko_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Aphano Pheeturu khumwaattama Yinsa khumuuzela yoori: “Mbwana, amana ttwiiyaku akikosa kinswamihi swafu kavi? Swaafu sapa?” ");
INSERT INTO eko_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yinsa khunjipu araka: “Miiyo kiniwuuza yoori, khahiyo swaafu sapa, ila swaafu saapiini orutela swaafu sapa. ");
INSERT INTO eko_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Khwa toowo, Ofwalume wa pinkuuni ori nkhama mfwalume aari otakhaaye waattalela vitthu zawe na karumeya awe. ");
INSERT INTO eko_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wakathi aaziyeevo waattalela, khutiiseliwa mwinyi aari omwiilaaye milikhi za nzurukhu wa feeta. ");
INSERT INTO eko_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mwaasa wa ohiina nanna yonripha mbwana awe otule aari omwiilaaye, khuruma yoori; ye na muukhaawe, aanaawe na vitthu zawe zooshi, zuuzanyisiwe ariphe teeni. ");
INSERT INTO eko_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Karumeya khukokhora omaasho wa mbwana awe khunvekela yoori: ‘Okivilele, kintta wuuripha.’ ");
INSERT INTO eko_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mbwana awe khunhurumiya, khufuja teeni etile na khunlikha olawa. ");
INSERT INTO eko_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ila karumeya otule noosaruwa khukutthanana nshirikhaawe wa vakhaazi aari omwiilaaye nzurukhu miiya paasi. Ye khunzola nshirikhaawe mmwisiko khusala anvinya araka: ‘Okiriphe!’ ");
INSERT INTO eko_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Aphano nshirikhaawe otule khukokhora khusala anvekela yoori: ‘Okivilele, kintta wuuripha.’ ");
INSERT INTO eko_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ila ye khuhikhupaleli, khurumisa olawa otthiiwa nkalapooso mpakha ariphe teeni yawe. ");
INSERT INTO eko_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Wakathi ooniyeevo akarumeya apale akinoko vitthu epile zaarettikhaniyeeyo, khukatipukha channu na khulawa khumuuza zooshi mbwana aya. ");
INSERT INTO eko_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mbwana khunkhuwela karumeya otule khumuuza yoori: ‘Karumeya woohifwayi, weeyo wakivekela miiyo khuuswaamihi teeni yawo. ");
INSERT INTO eko_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Weeyo khawaarina ya omoonela huruma nshirikhaawo nkhama miiyo kiwooneliyeezo?’ ");
INSERT INTO eko_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mbwana awe khwiiphiriwa khunttha nkalapooso yoori ahukhumwiwe mpakha ariphe teeni yawe. ");
INSERT INTO eko_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Paapa wa pinkuuni onttela oretta etthiipo, amana mweeyo mwihinswaamihi ttwiiyenu na rooho yenu yooshi.” ");
INSERT INTO eko_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yinsa eeshiyeevo olupa mattakhuzi apale, khulaawo Kalileya khweetta Yudeya kaapu kiina ya Yorotaani. ");
INSERT INTO eko_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Khuntti khuluyeene khusala enlotta, atthaapale ye khuwaavonisa alwele. ");
INSERT INTO eko_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mafwarizeewu akina khuta aphale aariivo Yinsa yoori amweeze khumuuzela yoori: “Halaali nlume omwaasha muukhawe khwa wakhula kiiswa?” ");
INSERT INTO eko_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yinsa khuwaajipu araka: “Mweeyo khamwisomeeni yoori omwanzo, Nluku amumpa nlume na muukha, ");
INSERT INTO eko_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","na khulupa yoori: ‘Tiito, nlume onlikha papaawe na mamaawe khujikusanya na muukhaawe, oowiiri khuretteya wiiya mwiili mmote’? ");
INSERT INTO eko_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Khwa etthiipo khaniiya awiri ila aniiya mwiili mmote. Aphano, etile Nluku akusanyiyeeyo ahiiyevo antakhaaye ophakula.” ");
INSERT INTO eko_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mafwarizeewu apale khumuuzela theenya yoori: “Aphano mwaasa aya niini Munsa enkhaka ruhusa ya nlume omwinkha talakha muukha awe na khumwaasha?” ");
INSERT INTO eko_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yinsa khuwaajipu yoori: “Munsa aruma yoori mweeyo mwimwaashe muukha enu mwaasa wa wuuma wa rooho zenu. Ila khazaari toowo omwanzweene. ");
INSERT INTO eko_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Miiyo kiniwuuzani yoori: wakhula otule animwaashaaye muukha awe, woohiiyi mwaasa wa oraruwa, khunrala muukha nkina ontta oraruwa.” ");
INSERT INTO eko_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Anakhiyoni a Yinsa khuri: “Nkhama pi etthiipo muukha na nlume, afwataali ohilooli.” ");
INSERT INTO eko_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yinsa khujipu yoori: “Khiriweeni atthu ooshi eetta wiiyana matakhelo ookhupalela mattakhuzi aya apa, ila otule enkhiweeyo paasi. ");
INSERT INTO eko_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Alume akinoko afwa nkuwo, maana avokoliwa etthiipo; akinoko arettisiwa pi atthu azaaya; akina eetta ojirettisa mwaasa wa Ofwalume wa pinkuuni. Otule anwahaaye okhupalela vitthu epi, ti akhupalele.” ");
INSERT INTO eko_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Paata ya vitthu epile, atthu akina khusala awaathuula asimaana nontanela Yinsa yoori awaattheele makhono na awaalompele. Ila anakhiyoni awe khusala awaamaruwela. ");
INSERT INTO eko_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Aphano Yinsa khuri: “Mwiwaalikhe akiteele miiyo asimaana wala mwihiwaakhattaze; maana Ofwalume wa pinkuuni pi wa apale eeyiye nkhama atthaapo.” ");
INSERT INTO eko_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Paata ya owaattheela makhono khulaavo aphale vaya khulawa. ");
INSERT INTO eko_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ntthu nkina khumwaattama Yinsa khumuuzela yoori: “Mwaaliimu, kirette niini yooshapweya yoori kipatthe ohaayi wa mileele?” ");
INSERT INTO eko_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yinsa khunjipu yoori: “Mwaasa aya niini weeyo okuuzelaka etthu yiiyiye yooshapweya? Owaapho ntthu mmote paasi eeyiyeeyo wooshapweya. Nkhama weeyo ontakha weetta muuhaayi wa mileele, oshututele mirumo.” ");
INSERT INTO eko_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ntthu otule khumuuzela Yinsa yoori: “Piivi?” Yinsa khunjipu araka: “Ohuule, ohiraruwe, ohiiye, ohilaze oshaahiti woovonyeya, ");
INSERT INTO eko_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","onshitahi papaawo na mamaawo, na omphete namwaattamanana awo nkhama etthiipo onjiphetaazo omweenyewe.” ");
INSERT INTO eko_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Shapu otule khujipu yoori: “Miiyo kinshututelaka mirumo zooshi. Khi niini enikisaleelaaye nalelo?” ");
INSERT INTO eko_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yinsa khunjipu yoori: “Nkhama weeyo ontakha wiiya khaamili, olawe woozanyise zooshi oriinaaye, nzurukhu aya owenkhe asikhini, orettaru toowo ontta wiiyana njuju pinkuuni. Nawiisha, ote okilotte.” ");
INSERT INTO eko_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Noosiila mattakhuzi apale shapu otule khwiiya woohuzunikha, maana aarina maali zawaatta. ");
INSERT INTO eko_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Aphano Yinsa khuwooza anakhiyoni awe araka: “Kiniwuuzani khweele yoori, ti yoolipa thaajiri weetta muufwalume wa pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ila ti yookhweya enkamiiya ovira valiphotto wa sikano zayita thajiri weetta muufwalume wa Nluku.” ");
INSERT INTO eko_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Anakhiyoni a Yinsa asiiliyeevo mattakhuzi apale, khwiiya ooshanka na khumuuzela yoori: “Khwa nanna nkhama eto paani anttelaaye wuusurukha?” ");
INSERT INTO eko_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yinsa khuweekesa na khuwaajipu yoori: “Khwa pinaatamu khinwaheya, ila wa Nluku vitthu zooshi zinwaheya.” ");
INSERT INTO eko_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Aphano Pheeturu khujipu yoori: “Fweeyo nalikha zooshi yoori nuulotte. Ninttela wiiya niini fweeyo?” ");
INSERT INTO eko_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yinsa khuwooza araka: “Miiyo kiniwuuzani khweele yoori, amana ofiya wakathi Nluku anttelaaye waattala zooshi opheeya na Mwaana wa Pinaatamu eekhala va khukulu ya siifwa zawe, mweeyo mwinikilottaaye mwinttela wiikhalela khukulu khumi na piiri yoori mwiphuke mahimo khumi na mawiri a Ezirayiilu. ");
INSERT INTO eko_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ooshi apale alikhiyeeyo vaje vaya, attwi zaya, alupu aya, apapazaya, aanaaya ama mashapa aya, mwaasa wa miiyo, anlawa apwekhere swaafu miiya na orithi ohaayi wa mileele. ");
INSERT INTO eko_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Khwa etthiipo, apale amwanzo anttela wiishela, na apale awiishela anttela wiiya amwanzo. ");
INSERT INTO eko_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Maana Ofwalume wa pinkuuni ori nkhama mweenyewe nshapa alankhiyeeyo supuyeene olawa oweekesa atthu yoori akhole khaazi mmashapa mwawe. ");
INSERT INTO eko_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ye khusiilanana yoori awaariphe nzurukhu mmote wa feeta wakhula siikhu, khuwaaruma olawa omashapa wawe. ");
INSERT INTO eko_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Wakathi opule wa sattaatthu, ye khulankha khusala alawa khuwoona atthu akina ari ohiina khaazi eekhaliye vaparasa. ");
INSERT INTO eko_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Aphano khuwooza yoori: ‘Mwilawe mweeyo theenya mwakhole khaazi mmashapa mwaka la wuuva, miiyo kintta wuuriphani etile enttelaaye wiiya ya shariya.’ ");
INSERT INTO eko_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Apale khulawa, khulankha theenya wakathi opule wa atuhuri na wakathi opule wa saakhentta, khuretta nanna nkhama etthiipile. ");
INSERT INTO eko_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Etthiipo wakathi wa sakhumi na monsi, ye khurutelawo khuwaasikana theenya akina ahaariina khaazi na khuwoozela yoori: ‘Mwaasa aya niini mweeyo mwiiyaka apha mwihikholaka khaazi siikhu yooshi?’ ");
INSERT INTO eko_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Khunjipu yoori: ‘Maana khina mmote aninkhiyeeyo khaazi’. Aphano khuwooza apale aya yoori: ‘Ettani na mweeyo mwakhole khaazi mmashapa mwaka.’ ");
INSERT INTO eko_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Weettelaka oripa, mweenyewe nshapa khumuuza waziri awe yoori: ‘Owaakhuwele anakhaazi na owaariphe phakari yaya, owaazaka apale awiishela mpakha apale a mwanzo.’ ");
INSERT INTO eko_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Khuta anakhaazi apale aattakhulaniweeyo wakathi wa saakhumi na monsi na wakhula ntthu khupwekhera nzurukhu mmote wa feeta. ");
INSERT INTO eko_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Wakathi atiiyeevo apale aattakhulaniweeyo mwanzo, aari weekesela opwekhera wawaatta, ila wakhula mmote aari opwekhera nzurukhu moote. ");
INSERT INTO eko_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Apwekheriyeevo khwaaza omwaapa mweenyewe nshapa, ");
INSERT INTO eko_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","amuuzaka yoori: ‘Mamwinyi apa wawaattakhulana yoori akhole khaazi ya wakathi mmote, weeyo mbwana onnilikanisana fweeyo nivileliyeeyo olemela wa khaazi na haari ya nthana wooshi.’ ");
INSERT INTO eko_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ila ye khujipu yoori: ‘Swaahipu, akiniwiimana shariya. Khawaakhupaleliye okhola khaazi ya opwekhera nzurukhu moote? ");
INSERT INTO eko_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Opwekhere etile yiiyiye yawo olawe. Miiyo kintakha omwinkha otule kaattakhulaniyeeyo wawiishela nkhama etthiipo kiwinkhiyeeyo. ");
INSERT INTO eko_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Akina ruhusa ya orettela etile kintakhaaye nzurukhu aka? Ama weeyo ona nrima mwaasa wa miiyo wiiya nkemaani?’ ");
INSERT INTO eko_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Aphano Yinsa khumarisa araka: Apale amwanzo anttela wiishela na apale awiishela anttela wiiya amwanzo.” ");
INSERT INTO eko_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Awelelaka Yeruzaleemu, Yinsa khuwaakhuwela othetekele anakhiyoni awe apale khumi na awiri, khuwooza yoori: ");
INSERT INTO eko_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mwisiile! Ninwelela Yeruzaleemu, Mwaana wa Pinaatamu onttela winkheleliwa mmakhono wa mahaakhimu a tiini na anamanozela a kano, yo anhukhumwele wuuliiwa, ");
INSERT INTO eko_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","enkheleliwe mmakhono wa amalapo anveyise, anjaphe na akhomeliwe. Ila siikhu ya ttaatthu asisimuwe.” ");
INSERT INTO eko_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Aphano maama wa aana a Zepeteewu khumwaattama Yinsa na khukokhora khusala anvekela. ");
INSERT INTO eko_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yinsa khumuuzela yoori: “Weeyo ontakhani?” Maama otule khujipu yoori: “Kintakha yoori muufwalume mwawo aanaaka apa awiri mmote eekhale nkhono nlume nkina nkhono nkha.” ");
INSERT INTO eko_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yinsa khunjipu yoori: “Mweeyo khamwinjuwa etthu mwinvekaaye. Mwinwahi onywela koopho ethiiti kinttelaaye onywela?” Yo khujipu, “ninwahi.” ");
INSERT INTO eko_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Aphano Yinsa khuri: “Weekhweele mweeyo mwinteela onywela koopho yaka, ila wiikhala nkhono nlume aka ama nkhono nkha khahiiyo miiyo kinlupaaye. Maana puuro eto ti yawe otule aattaleliweeyo ti Paapa.” ");
INSERT INTO eko_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wakathi apale akina khumi asiiliyeevo mattakhuzi apale, khwiiya ookasirikha khwa attwi apale awiri. ");
INSERT INTO eko_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Aphano Yinsa khuwaakhuwela khulupa yoori: “Mwijuwe yoori anamalokozela a khapila anshintta, na attunkhulu aya anthoonyeza ofwalume khwa yo. ");
INSERT INTO eko_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mweeyo mwihiiye toowo, ila otule antakhaaye wiiya wa fwayita awaarumeyele azaawe; ");
INSERT INTO eko_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","na otule antakhaaye wiiya wa mwanzo eeye mwiitthwaana enu mweeyo. ");
INSERT INTO eko_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nkhama etthiipo, Mwaana wa Pinaatamu khateleeni orumeyeliwa, ila orumeya na winkha ohaayi awe khwa owaakaphula atthu awaatta.” ");
INSERT INTO eko_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yo alankhaka Yeriko, atthu awaatta khusala awaalotta. ");
INSERT INTO eko_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Atthu awiri oohooni eekhaliye nshini wa tarikhi, wakathi asiiliyeevo yoori Yinsa ontta ovira, khwaaza onyakula araka: “Mbwana, Mwaana wa Daawuuda, noonele huruma!” ");
INSERT INTO eko_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Atthu apale awaatta khusala awaakhattaza, awaatakhelaka yoori anyamale, ila khusala atepa onyakula araka: “Mbwana, Mwaana wa Daawuuda, noonele huruma!” ");
INSERT INTO eko_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yinsa khweemela khuwaakhuwela khuwoozela yoori: “Mweeyo mwintakha yoori miiyo kuuretteleni niini?” ");
INSERT INTO eko_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Yo khujipu yoori: “Mbwana, nintakha noone.” ");
INSERT INTO eko_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yinsa khuwoonela huruma na khuwaasapa maasho aya, nasaapiru khwaaza woona khusala anlotta. ");
INSERT INTO eko_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ari kharipu ya Yeruzaleemu, khufiya Betifwaaje, va mwaako Oluveera, Yinsa khuwaaruma anakhiyoni awe awiri khuwooza yoori: ");
INSERT INTO eko_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Mwilawe nti opo mwinoonaaye omaasho wenu okho, mwinlawa mwansikane mwaana wa puuru weekha afukiwe vamote na weelume. Mwinfukule mwikitiisele. ");
INSERT INTO eko_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Amana apuwa ntthu awuuzelani, mwimuuze yoori Mbwana ontta owaatakha, ontta wuulikhani nasaapiru mwiwaathuule. ");
INSERT INTO eko_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Vitthu epo zarettikhana yoori emarisele etile alupiyeeyo napiyu yoori: ");
INSERT INTO eko_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Muuze sitati ya Siyooni yoori: ‘Omoone, mfwalume awo ontta wuuteela, woojipushuwisa, aweliye va mwaana wa puuru, nyama yoopakhira.’” ");
INSERT INTO eko_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Anakhiyoni khuretta etile aarumiweeyo ti Yinsa. ");
INSERT INTO eko_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Khuntiisa puuru yeekha na mwaana aya nttitthiiru, aphano khutthiiwavo kuwo zawe, ye khuwelavo. ");
INSERT INTO eko_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Atthu apale awaatta aari onlottaaye khusala attattikha ajapi zaya ntarikhi, akina khusala ashija virapi za miitthi na ottattikha ntarikhi. ");
INSERT INTO eko_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Apale aalokoziyeeyo na apale aari onlottaaye eetta onyakula araka: “Ozaana khwa mwaana wa Daawuuda! Wooparikhiyiwa ti otule antaaye khwa nzina la Mbwana! Ozaana wa pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Wakathi Yinsa aviriyeevo Yeruzaleemu, sitati yooshi khutapanyeya, atthu khusala oozeliwa yoori: “Paani otu aya?” ");
INSERT INTO eko_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Yo khusala ajipu yoori: “Otu ti Yinsa, napiyu wa Nazareeti ya Kalileya.” ");
INSERT INTO eko_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yinsa khuvira Nnyupa Woosifwiwamo, khuwiikaramo ooshi apale aari wuuzanyisaye na apale aari wuuzanyaaye. Khukurumula meeza a anamapatilisa nzurukhu na khateera za apale aari wuuzanyisaaye jiwa.’ ");
INSERT INTO eko_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Khuwooza araka: “Yaatikhiwa yoori; ‘Nyuupa yaka enttela wiitthiwa nyuupa yoosifwiwamo, ila mweeyo mwaretta wiiya puuro ya anamwiiya. ");
INSERT INTO eko_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ananhooni na anamarakala khumwaattama Yinsa Nnyupa Woosifwiwamo, ye khuwaavonisa. ");
INSERT INTO eko_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mahaakhimu a tiini na anamanozela a kano ooniyeevo vitthu zootikinisa Yinsa aari orettaazo na aasimana aari okhuwaaye araka: “Ozaana mwaana wa Daawuuda!” khushanka khusala oozela yoori: ");
INSERT INTO eko_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","“Onsiila epi anlupaazo apa?” Yinsa khuwaajipu yoori: “Aaa; mweeyo khamwina some yoori: ‘Khwa nlimi la asimaana na apale anamwaaye antthenkeza siifwa khaamili?’” ");
INSERT INTO eko_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yinsa khuwaalikha, khulaamo nsitati mphule khulawa Betaaniya ottuukho aalaliiyeewo. ");
INSERT INTO eko_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mmeesho mwaya supuyeene, arutelaka ositati, khunkhola jala. ");
INSERT INTO eko_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Khoona nfikeera nshini wa tarikhi, khwaattama ila khuhisikanani hatha mishumo, khusikanamo mathaparu paasi, aphano khuri: “Weeyo khunteela wiima theenya mishumo!” Nfikeera opule khuuma nasaapiru. ");
INSERT INTO eko_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Anakhiyoni awe ooniyeevo epile zaarettikhaniyeeyo, khwiiya ooshanka na ootikinisiwa alupaka yoori: “Wooma toovi nasaapiru nfikeera opu?” ");
INSERT INTO eko_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yinsa khuwaajipu yoori: “Kiniwuuzani khweele yoori, amana mwiiyana amini na woohiina nshikili, mwinttela oretta woohiiyi epi zirettikhaniyeeyo khwa nfikeera opu paasi, ila hatha wuuza mwaako opu yoori okhuleye ojeeselele mpahari, zintta orettikhana. ");
INSERT INTO eko_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Amana mwiiyana amini mwinpwekhera zooshi mwinttelaaye oveka khwa lompa. ");
INSERT INTO eko_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Paata ya Yinsa ofiya Nnyupa woosifwiwamo, eettaka osomisa, mahaakhimu a tiini na attunkhulu a tiini khumwaattama khumuuzela yoori: “Vitthu epi onrettana ofwalume-ni? Wala ti paani awinkhiyeeyo ofwalume aya opu?” ");
INSERT INTO eko_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yinsa khuwaajipu yoori: “Miiyo kintta owuuzelani theenya; amana mwikijipu, kintta owuuzani ofwalume kinrettanaaye vitthu epi. ");
INSERT INTO eko_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Woosa wa Yaahaya waari wa vayi? Wa pinkuuni ama wa anaatamu?” Yo khusala akheetisana atthaapo-ru araka: “Amana niri waari wa pinkuuni, ye ontta onuuzela yoori ‘khi mwaasa aya niini mwihikhupalelaka?’ ");
INSERT INTO eko_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ila amana nilupa yoori pi wa anaatamu, niniwoova atthu, maana ankhupalela yoori Yaahayanapiyu.” ");
INSERT INTO eko_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yo khunjipu Yinsa yoori: “Khanijuweeni.” Ye khuwooza theenya yoori: “Hatha vattitthiiru akiniwuuzani owahi kinrettanaaye vitthu epi.” ");
INSERT INTO eko_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Mwinoona toovi? Aarivo mwinyi mmote aariina aana awe awiri. Khumweettela otule wa mwanzo khumuuza yoori: ‘Mwanaka, etta wakhole khaazi leelo omashapa.’ ");
INSERT INTO eko_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Khujipu yoori: ‘Akeepu!’ Ila khuupuwela khulawa okhola khaazi etile ooziweeyo. ");
INSERT INTO eko_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Paapa otule khumwettela mwanawe otule nkina khumuuza nkhama etthiipo amuziyeeyo otule nkina. Mwaana otule khujipu yoori: ‘Kintta olawa mbwana aka!’ Ila khuhilawi. ");
INSERT INTO eko_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Khwa aana apale awiri ti tuuvi arettiyeeyo matakhelo a papaawe?” Khujipu yoori: “Otule wa mwanzo.” Yinsa khuwooza yoori: “Kiniwuuzani khweele yoori, anamariphisa lumpuru na amalempe antta weetta muufwalume wa Nluku mweeyo mwihineettemu. ");
INSERT INTO eko_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Maana Yaahaya ata yoori oothonyezeni tarikhi ya shariya, mweeyo khuhinkhupaleli, ila anamariphisa lumpuru na amalempe ankhupalela. Mweeyo moona vitthu epile khuhithupwiyi na wala khuhinkhupaleli. ");
INSERT INTO eko_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Mwisiile nlikaniso nkina: Aarivo thaajiri mmote wa mmuti nttumphule aalimiyeeyo nshapa lawe la wuuva. Khujekelela looshi, khwaattala kulaathayini ya onluwatthelamo wuuva na khujeka korofwa ya namweekesela. Khuwaalikhela anamalima apale akina, khulaamo mmuti mphule, khusala alawa safwari yawe. ");
INSERT INTO eko_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ofiyeevo wakathi wa wuurula, khuwaaperekha akarumeya awe khwa anamalima apale, yoori apwekherele mishumo zawe. ");
INSERT INTO eko_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Anamalima khuwaakhola akarumeya a mweenyewe nshapa apale; mmote khunvulalisa, nkina khumuula, wattaatthu khunvonya na mawe. ");
INSERT INTO eko_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Aphano khuwaaperekha akarumeya awe akina awaatta, anamalima apale khuwaatthantta nkhama etthiipo awaatthanttiyeezo apale akina. ");
INSERT INTO eko_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Omwiisho khumperekha mwanawe alupaka yoori: ‘Mwanaka otu antta onshitahi.’ ");
INSERT INTO eko_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ila anamalima amoniyeevo mwaana otule, khulupa yoori: ‘Otu namarithi. Mwite, nimuule nithuule eritho yawe.’ ");
INSERT INTO eko_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Attaaphale yo khunkhola khumweeselela othetekele wa nshapa khumuula. ");
INSERT INTO eko_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Amana ata mweenyewe nshapa, onttela owaarettela niini anamalima apale?” ");
INSERT INTO eko_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yo khujipu yoori: “Wekhweele ontta owoola anamalima apale ootakhala rooho na awenkhe anamalima akina nshapa laya. Apa nka amwinkhaka phantte ya mishumo wakathi wa wuurula.” ");
INSERT INTO eko_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yinsa khuwoozela yoori: “Khamwinasome zawaatikhiwa Ttakatthiifu yoori: ‘Liwe anamajeka akatthaliyeeyo, nttho tthi liyiiyeeyo liwe linkhomaazaaye; eto enta wa Mbwana, na etthu yooshapweya khwa fweeyo.’ ");
INSERT INTO eko_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Paata ya toowo kiniwuuzani yoori Ofwalume wa Nluku mwinttela onyakanyiwa enkhiwe apale animaaye mishumo za Ofwalume. ");
INSERT INTO eko_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Otule anttelaaye okwela liwe laya ntthi ontta othapateya, na otule linttelaaye onkhwela ontta othatuwa lifufu. ");
INSERT INTO eko_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mahaakhimu a tiini na mafwarizeewu, asiiliyeevo milikaniso za Yinsa, khuweeleya yoori aari ottakhula monkoni wa yo. ");
INSERT INTO eko_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Khusala eekesa nanna ya onkhola ila khusala awoova atthu, maana aari onjali nkhama napiyu. ");
INSERT INTO eko_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yinsa khurutela owooza milikaniso araka: ");
INSERT INTO eko_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ofwalume wa Pinkuuni onlattanana mfwalume mmote atthekeziyeeyo njampo la harusi ya mwanawe. ");
INSERT INTO eko_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Aphano khuwaaruma akarumeya awe olawa owaakhuwela anamalaleyiwa yoori ate onjampo; ila yo khuhitakhi ota. ");
INSERT INTO eko_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Khuwaaruma theenya akarumeya akina araka: ‘Mwawooze anamalaleyiwa yoori: Njampo lalikana; mompe zaka na aana aya ooneneva kashija na zooshi zalikana. Mwite onjampo la harusi.’ ");
INSERT INTO eko_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ila yo khuhijali khusala alawa, mmote omashapa wawe, mmote nzanshara mwawe, ");
INSERT INTO eko_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","apale asaliyeeyo khuwaakhola akarumeya khuwaahukhumu na khuwoola. ");
INSERT INTO eko_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ila mfwalume khwiiya wawiiphiriwa, khuwaaruma anajanka awe olawa owaatapanya anamahusuti apale na khulukuza sitati yaya etile. ");
INSERT INTO eko_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Aphano khuwooza akarumeya awe yoori: ‘Njampo lalikana, ila anamalaleyiwa khaari osuhi. ");
INSERT INTO eko_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mwilawe mmizukulowo za tarikhi mwawaalaleye ooshi apale mwinttelaaye owaasikana.’ ");
INSERT INTO eko_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Aphano akarumeya apale khulawa mmatarikhi na khuwaakusanya atthu ooshi apale awasikaniyeeyo, atthu ooshapweya rooho na atthu ootakhala rooho, nsana waari ojiwaavo njampo khwiiya wawiitaala pi anamalaleyiwa. ");
INSERT INTO eko_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Wakathi mfwalume aviriyeevo yoori awoone anamalaleyiwa apale, khumoona mwinyi mmote ahaawaliyeeyo kuwo za njampo. ");
INSERT INTO eko_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Khumuuzela yoori: ‘Swaahipu, wavira toovi ohiwaleeni kuwo za njampo?’ Mwinyi otule khwiiya woonyamala. ");
INSERT INTO eko_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Aphano mfwalume otule khuwaaruma akarumeyaawe yoori: ‘Mwinfuke moolu awe na makhono awe mwimweeselele vaje, n'yiiza; nttumpho oniiyamo olila na oluma meeno’. ");
INSERT INTO eko_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Maana awaatta pi ookhuweliwa, ila vattitthiiru pi oothawuliwa”. ");
INSERT INTO eko_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mafwarizeewu khulaavo aphale vaya, khusala awaza shawuri zonvithaalela khwa mmattakhuzi awe. ");
INSERT INTO eko_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Khuwaaruma anakhiyoni aya na atthu akina a khuntti ya Herooti khusala amuuza Yinsa yoori: “Mwaaliimu, fweeyo najuwa yoori weeyo onlupa khweele na onsomisa na khweele tarikhi ya Nluku, khunjilikha othowelelisiwa ti ntthu, wala khuniwaaphuka atthu khwa nanna ariizo. ");
INSERT INTO eko_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nkanuuze, ona shawuri ni? Ti ya shariya onripha lumpuru Seezari ama wala?” ");
INSERT INTO eko_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yinsa khujuwa thwapiya zaya zootakhala khuwaajipu yoori: “Manaafikhi, mwaasa aya niini mwikeezaka?” ");
INSERT INTO eko_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mwikithoonyeze nzurukhu onriphiwaaye lumpuru.” Khutiiseliwa nzurukhu mmote wa feeta. ");
INSERT INTO eko_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ye khuwoozela yoori: “Ratarato eti na nzina ntthi laatikhiweeyo apha tthi laani?” ");
INSERT INTO eko_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Khujipu yoori: “Seezari”. Aphano khuwooza yoori: “Mwimwinkhe Seezari etile yiiyiye ya Seezari na mwimwinkhe Nluku etile yiiyiye ya Nluku.” ");
INSERT INTO eko_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Asiiliyeevo mattakhuzi apale, khwiiya ootikinisiwa na khulikha wuuzela khusala alawa. ");
INSERT INTO eko_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Siikhu ethiitile, khunteela masatukhi akina anlupaaye yoori khawiivo osisimuwa, khusala amuuzela yoori: ");
INSERT INTO eko_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Mwaaliimu, Munsa alupa yoori: ‘Amana ntthu afwa, muukha awe ahinvokoleleeni mwaana, ttwiiye ona ya onrala namafweliwa ti mannawe yoori amwinkhe aana ttwiiye otule afwiiyeeyo. ");
INSERT INTO eko_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Fweeyo naari attwi sapa. Wamwanzo khuloola na khufwa. Muukha awe khanvokoleliye mwaana, khuraliwa ti ttwiiye. ");
INSERT INTO eko_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Khurettikhana nkhama zanrettikhaneliyeeyo otule wa mwanzo na wa ttaatthu mpakha otule wa saapa. ");
INSERT INTO eko_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Omwiisho waya paata ya ooshi ofwa, na muukha khufwa. ");
INSERT INTO eko_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aphano, wakathi woosisimuwa, khwa alume apale sapa ti tuuvi anttelaaye wiiya mannawe? Maana ooshi anraliye.” ");
INSERT INTO eko_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yinsa khuwaajipu yoori: “Mweeyo mwathowelela, maana khamwinjuwa Zawaatikhiwa Ttakatthiifu wala owahi wa Nluku. ");
INSERT INTO eko_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Maana wakathi woosisimuwa atthu khanloola wala khanlooziwa; anttela wiiya nkhama malayikha pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Khwa osisimuwa wa ananfwa, mweeyo khamwisomeeni etile Nluku alupiyeeyo yoori: ");
INSERT INTO eko_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Miiyo ki Nluku wa Eburahiima wa Esiyaakha na wa Yaakhumpa?’ Ye khahiyo Nluku wa ananfwa, ila wa atthu awoona.” ");
INSERT INTO eko_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Asiiliyeevo mattakhuzi apale, atthu khwiiya ooshanka khwa osomisa wawe. ");
INSERT INTO eko_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Paata ya mafwarizeewu ojuwa khuwaanyamaza masatukhi, khukusanyeya. ");
INSERT INTO eko_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mmote wa yo, namanozela kano khweeza omuuzela yoori: ");
INSERT INTO eko_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mwaaliimu, nrumo nwulu pi puuvi?” ");
INSERT INTO eko_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yinsa khunjipu yoori: “Omphete Mbwana Nluku awo khwa rooho yawo yooshi, khwa nafusi yawo yooshi na akhili zawo zooshi. ");
INSERT INTO eko_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Opu pi wiiyiyeeyo oruma wa mwanzo na wootepa owula. ");
INSERT INTO eko_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Waphiiri onlattanana otthuupu: omphete nzaawo nkhama etthiipo onjiphetaazo omweenyewe. ");
INSERT INTO eko_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kano zooshi za Munsa na masomi ooshi amanapiyu anrumeyela mirumo etthiipi miwiri.” ");
INSERT INTO eko_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mafwarizeewu apale nalelo ari okusanyeya, Yinsa khuwoozela yoori: ");
INSERT INTO eko_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mwinuupuwelani monkoni wa Al-Masiihu? Mwaana waani?” Yo khujipu yoori: “Mwaana wa Daawuuda.” ");
INSERT INTO eko_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yinsa khuwoozela theenya yoori: “Aphano, khi toovi Daawuuda khwa Rooho Ttakatthiifu omwiittha yoori Mbwana, alupaka yoori: ");
INSERT INTO eko_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Mbwana amuuza Mbwana aka yoori: “Wiikhale nkhono nlume aka mpakha maatuwi awo kiwaatthe vathi wa moolu awo?”’ ");
INSERT INTO eko_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nkhama Daawuuda onimwiittha yoori Mbwana, enrettikhana toovi eeyaka mwanawe?” ");
INSERT INTO eko_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Khuhiivo mmote awahiyeeyo onjipu, na waaza siikhu ethiitile khina nkina awahiyeeyo omuuzela theenya. ");
INSERT INTO eko_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Aphano Yinsa khuwooza atthu apale na anakhiyoni awe yoori: ");
INSERT INTO eko_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Anamanozela a kano na mafwarizeewu eekhalela khukulu ya Munsa. ");
INSERT INTO eko_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mwiwaashututele na mwithokorele zooshi epile aniwuuzaanini. Ila mwihiweezele vitthu anrettaazo. Maana khanrumeyela epile anlupaazo. ");
INSERT INTO eko_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yo anfuka maphuta oolemela na ottikha mmafuzi wa atthu, ila yo khantakha hatha oshashula na yaala. ");
INSERT INTO eko_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Zooshi anrettaazo antakha yoori ooniwe pi anaatamu. Yo anjifukela hirizi mmwishwa mwaya, na olepisa mashaka a ajapi zaya. ");
INSERT INTO eko_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Owaatuvela puuro zooshapweya za vanjampo na wiikhala wiilokozi nsinakooka, ");
INSERT INTO eko_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","owaatuvela ochelisiwa vamwanttiwa na wiitthiwa Mwaaliimu. ");
INSERT INTO eko_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mweeyo khamwinlawa wiitthiwa Mwaaliimu, maana Mwaaliimu enu mmote paasi, mweeyo mooshi mwa attwi. ");
INSERT INTO eko_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ahiiyevo vathi apha mwinttelaaye omwinkha khalamu ya ‘opaapa’, maana Papeenu ori mmote paasi, otule ari pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Wala ahiiyevo anttelaaye omwinkha khalamu ya namanozela maana namanozela ori mmote paasi, Al-Masiihu. ");
INSERT INTO eko_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ila otule eyiiye nwulu vakatthi venu eeye karumeya. ");
INSERT INTO eko_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Otule anjiwulisaaye ontta opushuwisiwa; otule anjipushuwisaaye ontta owulisiwa. ");
INSERT INTO eko_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Olaanikha pi weenu mweeyo anamanozela a kano na mafwarizeewu, manaafikhi, maana mwiniwafukela atthu Ofwalume wa pinkuuni, ila na mweeyo khuheettimo na khamwintakha owaalikha weettamo apale antakhaaye! ");
INSERT INTO eko_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Olaanikha pi wenu mweeyo anamanozela a kano na mafwarizeewu, manaafikhi, maana mwimpala maali za anamfweliwa pi amannazaya na ojitapwatelana oretta lompa zoolepa; khwa etthiipo mwinteela ohukhumwiwa saaneene. ");
INSERT INTO eko_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Olaanikha pi wenu mweeyo anamanozela a kano na mafwarizeewu, manaafikhi, maana mweeyo mwinlokha pahari na mwineettetta nti wooshi mweekesaka owaathuula atthu mwiwaatthe ntiini mwenu. Na amana mwimpattha ntthu aya oto onretteya swaafu piiri wiiya mwaana wa motthooni zayita mweeyo. ");
INSERT INTO eko_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Olaanikha pi wenu mweeyo, anamalokozela oohooni! Maana mwinlupa yoori: ‘Amana ntthu alapha khwa omwimpari, eto khina maana. Ila amana ntthu alapha khwa thahapu ya omwimpari oto ona sharuthi ya oretta etile alaphiyeeyo.’ ");
INSERT INTO eko_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Alolo oohooni! Eriina fwayita ti tiivi, thahapu ama mwimpari opule onttakatthisaaye thahapu? ");
INSERT INTO eko_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mweeyo mwinlupa theenya yoori: ‘Amana ntthu alapha khwa nzina la alitaari, olapha waya opo khuna maana, ila ntthu amana alapha khwa zaakha etile eriiye vatulu vaya, oto ona yoorumeyela olapha wawe.’ ");
INSERT INTO eko_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Atthu oohooni, eriina fwayita ti tiivi, zaakha ama alitaari anttakatthisaaye zaakha? ");
INSERT INTO eko_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nakataalikha otule anlaphaaye khwa alitaari onlapha khwa alitaari na yooshi etile eriivo. ");
INSERT INTO eko_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Amana ntthu alapha khwa mwimpari, onlapha khwa mwimpari na khwa otule aniikhalaaye nttumpho. ");
INSERT INTO eko_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na otule anlaphaaye khwa pinku onlapha khwa khukulu ya Nluku na khwa otule ekhaleliyeeyo. ");
INSERT INTO eko_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Olaanikha pi wenu mweeyo anamanozela a kano na mafwarizeewu, manaafikhi, maana mweeyo mwinimwinkha Nluku lifunku la khuumi mpakha vitthu za nwoorotha na mwinimwinkha nyaani zootuva na samuli, ila mwinkhijilela oruma wa fwayita wa kano, wiiyiye: Shariya, huruma na waamineya, nakataalikha mwaarina ya oretta epo zaya woohiweraweri epile kiina. ");
INSERT INTO eko_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Anamalokozela oohooni! Mwinshuja kuuku, ila khumiza enkamiiya. ");
INSERT INTO eko_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Olaanikha pi wenu mweeyo, anamanozela a kano na mafwarizeewu, manaafikhi, maana mweeyo mwinoosa pilawuri na parathu oje waya, ila nkatthi mwenu weetaalamo wiiya na omaashokopho. ");
INSERT INTO eko_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mafwarizeewu ohooni, moose khapula pilawuri nkatthi mwaya, aphano phantte etile ya oje entta wiiya yooshapweya. ");
INSERT INTO eko_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Olaanikha pi wenu mweeyo, anamanozela a kano na mafwarizeewu, manaafikhi, maana mweeyo mwiri nkhama vilalo yoovaaziwa khinampo, oje waya enumpuwaaye nkhama yooshapweya, ila nkatthi mwaya eetaaliyemo makhonkolo alupa ofwa na wakhula nanna ya vitthu zoovutta. ");
INSERT INTO eko_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Oje wenu mwinuupuwa nkhama anashariya, ila nkatthi mwenu mweetaala onaafikhi na vitthu zootakhala. ");
INSERT INTO eko_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Olaanikha pi wenu mweeyo, anamanozela a kano na mafwarizeewu, manaafikhi, maana mwinjeka khapuri zooshapweya za manapiyu, khuretta wiiya vilalo za akemaani. ");
INSERT INTO eko_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mwinlupa yoori: ‘Eriwaka neettiye wiiyavo wakathi wa amarehemu apapazetthu, khanaari wiiyana phantte khwa yo ya owoola manapiyu? ");
INSERT INTO eko_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Etthiipo, mweeyo mwinjilawela oshaahiti yoori mwa aana a apale awooliyeeyo manapiyu. ");
INSERT INTO eko_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mwilikhe wiitaaza mphimo wa twampi za amarehemu apapazenu. ");
INSERT INTO eko_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nyookha! Ojama wa evili! Mwinttela owerawera toovi hukhumu ya motthooni? ");
INSERT INTO eko_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tiito miiyo kooperekhezani manapiyu, ajuwi na anamanozela a kano. Akina mwiwoole, mwiwaakhomele, mwiwaajaphe nsinakooka mwenu na mwiwaalupatthe sitati khwa sitati. ");
INSERT INTO eko_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Khwa etthiipo eniwiittikhelani taamu yooshi ya anashariya yiittikheliyeeyo vathi, waaza taamu ya nashariya Apeele, mpakha taamu ya Zakariiya mwaana wa Barakiiya, mwimuuliyeeyo vakatthi wa omwimpari na alitaari. ");
INSERT INTO eko_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Miiyo kiniwuuzani khweele yoori, zooshi epo ziniwateela atthu aleelo. ");
INSERT INTO eko_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yeruzaleemu, Yeruzaleemu, weeyo oniwuula manapiyu na owaavonya apale aperekhiweeyo! Swaafu kavi miiyo kitakhaka owaakusanya aana awo nkhama mwanakhu aniwaakusanyaazo aana awe mmapaphelo, ila mweeyo khuhitakhi. ");
INSERT INTO eko_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Moone, yoori nyuupa yenu enttela wiiya yoothamiwa. ");
INSERT INTO eko_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Maana miiyo kiniwuuzani yoori, mweeyo khamwinteela okoona theenya, mpakha mwilupe yoori: ‘Wooparikhiyiwa ti otule antaaye khwa nzina la Mbwana.’” ");
INSERT INTO eko_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yinsa khusaruwa Nnyupa Woosifwiwamo, khusala alawa, anakhiyoni awe khumwaattama yoori anthoonyeze manyupa apale ooshapweya. ");
INSERT INTO eko_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yinsa khuwooza yoori: “Mweeyo mwinoona ooshi apa? Weekhweele miiyo kiniwuuzani yoori khalinsalavo apha liwe vatulu wa liwe lihinttelaaye opwechiwa.” ");
INSERT INTO eko_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Wakathi Yinsa eekhaliyeevo va mwaako Oluveera, anakhiyoni khulawa khwiitthaalana othetekele na khunvekela yoori: “Nkanuuze, zinttela orettikhana lini vitthu zaya epo, wala amana otaaka, alama-ni enttelaaye wiiyavo na alama-ni ya mwiisho wa olumwenku?” ");
INSERT INTO eko_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ye khuwaajipu yoori: “Phoole, ti ahiiyevo hatha ntthu anttelaaye wuuttettekhani! ");
INSERT INTO eko_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Maana atthu awaatta anlawa ate khwa nzina laka, alupaka yoori: ‘Miiyo ki Al-Masiihu’ na owaattettekha atthu awaatta. ");
INSERT INTO eko_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Amana mwisiila hapari za viittha ama nzuuzu la viittha, mwihoove. ");
INSERT INTO eko_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Khapila enttela wuumanana khapila kiina, ofwalume na ofwalume nkina, enttela opuwa esikinyaatthi na jala phantte zawaatta. ");
INSERT INTO eko_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Zooshi epo yaazo ya vitthu za olwaaza. ");
INSERT INTO eko_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Aphano yo anteela owinkhelelani yoori mwilupatthiwe na muuliwe, mwinlawa mweeniwe ti khapila zooshi mwaasa wa nzina laka. ");
INSERT INTO eko_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wakathi aya opo, atthu awaatta anteela wanswi amini anttela wiiya anamazinkula, na wiinana mmote na nzaawe. ");
INSERT INTO eko_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Anlawa apuwe manapiyu awaatta oojipanka na awaattettekhe atthu awaatta. ");
INSERT INTO eko_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Vitthu zootakhala zinttela weekezeleya, na pheta ya atthu awaatta enttela ovukuwa. ");
INSERT INTO eko_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ila otule anttelaaye ovilela mpakha mwiisho ontta wuusurukha. ");
INSERT INTO eko_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Enttela olaleyiwa hapari epi za Ofwalume wa Nluku olumwenku wooshi, nkhama oshaahiti khwa khapila zooshi aphano osala ota mwiisho. ");
INSERT INTO eko_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Mwinteela woona okufuru wa woopisa wa pala onttelaaye opuwa Puuro Ttakatthiifu, etile alupiyeeyo napiyu Daniyeele - osome na eweeleye. ");
INSERT INTO eko_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Aphano apale anttelaaye wiiya Yudeya atthirele omwaako. ");
INSERT INTO eko_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Otule anttelaaye wiiya vatulu wa nyuupa ahishukhe yoori alazemo etthu nnyupa mwawe, ");
INSERT INTO eko_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","na otule anttelaaye wiiya omashapa ahirutele onti weettela ajapi yawe. ");
INSERT INTO eko_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Siikhu etile ti ya woopisa khwa apale awiimittha na anaamwisaaye. ");
INSERT INTO eko_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mwilompe yoori miswipa epo ehirettikhane mwiita ama jumwa-monsi. ");
INSERT INTO eko_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Maana wakathi aya opo onlawa wapuwe ohoowa nwulweene, thanku mwanzo wa olumwenku, na khunteela opuwa nkina nkhama otthuupo. ");
INSERT INTO eko_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Eriwaka wakathi aya opo wa ohoowa khawaavukuliwe, khina aari weettelaaye wuusurukha, ila mwaasa wa apale oothawuliwa, siikhu zaya epo enttela wiiya zoovukuliwa. ");
INSERT INTO eko_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Aphano amana ntthu awuuzani yoori: ‘Otu ari apha Al-Masiihu!’ ama: ‘Otule ari okhule!’ mwihinkhupalele. ");
INSERT INTO eko_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Maana anlawa apuwe a al-Masiihu oojipanka na manapiyu oojipanka anttelaaye oretta alama khulukhulu na vitthu zootikinisa yoori awaahate hatha apale oothawuliwa. ");
INSERT INTO eko_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Miiyo kawuuzani khapula zihinarettikhane epo zaya. ");
INSERT INTO eko_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nakataalikha, amana muuziwa yoori: ‘Ori n'yaara,’ mwihilawe, ama oriwa: ‘Ori nnyupa,’ mwihikhupali. ");
INSERT INTO eko_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Maana, nkhama etthiipo taari enlankhaaye malawa-juwa, na ojithoonyeza okhu lintupweelaawo njuwa, etthiipo onttela wiiya ota wa Mwaana wa Pinaatamu. ");
INSERT INTO eko_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Vahali aniiyaavo muufwi, akhwaazi ankusanyeya attaapho. ");
INSERT INTO eko_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Paata ya mashakha a siikhu epo, njuwa linttela ozima na mweezi onttela olikha waara, matthottowa anttela okwa otulu na owahi wa pinkuuni onttela osakhinyeya. ");
INSERT INTO eko_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Aphano epuwe pinkuuni alama za Mwaana wa Pinaatamu; khapila zooshi za vatuniya enttela ojikhupanyisa na enttela omoona Mwaana wa Pinaatamu ataaka mmawiku a pinkuuni khwa owahi na siifwa yawaatta. ");
INSERT INTO eko_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ye onttela operekha malayikha awe na ovuma nwulweene wa malope, yo anttela owaakusanya ananthawuliwa aya ooshi khwa phantte nne zinlankhaawo pheevo, phantte khwa phantte kiina ya pinku. ");
INSERT INTO eko_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mwijinozele osomisa wa nfikeera: Amana virapi zaya zootthelaka mathapa mwinjuwa yoori onsaleela ofiya mwiita. ");
INSERT INTO eko_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Etthiipo na mweeyo, amana moona vitthu epo zooshi, mwijuwe yoori wakathi wafiya, ensaleela waaza. ");
INSERT INTO eko_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Weekhweele kiniwuuzani yoori, khanteela ovira atthu apa aleelo zihirettikhaneene vitthu zaya epo. ");
INSERT INTO eko_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Pinku na vathi zooshi zinteela ovira, ila mattakhuzi aka khanviraru. ");
INSERT INTO eko_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ila monkoni wa siikhu na wakathi khina anjuwaaye, wala malayikha a pinkuuni, wala Mwaana, ila Paapa paasi. ");
INSERT INTO eko_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nkhama etthiipo zaarettikhaniyeeyo wakathi wa Nuuhi, enttela wiiya etthiipo etelo ya Mwaana wa Pinaatamu. ");
INSERT INTO eko_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nkhama etthiipo siikhu ziviriyeezo za nnyeri, atthu aari oja na aari onywa, aari oralana na aari oloozana, mpakha ofiya siikhu Nuuhi eettiyeemo mmwaaraka. ");
INSERT INTO eko_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Yo kaajuwiyevo hatha etthu mpakha wakathi otiiyeevo nnyeri na khuwaathuula ooshi. Enttela wiiya etthiipo ota wa Mwaana wa Pinaatamu. ");
INSERT INTO eko_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Aphano awiri anttela wiiya omashapa; mmote athuuliwe, alikhiwe mmote. ");
INSERT INTO eko_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Aakha awiri achilaka tiriku; mmote athuuliwe, mmote alikhiwe. ");
INSERT INTO eko_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mwaasa wa ethiito, mwijeekesele, maana khamwinjuwa siikhu anttelaaye ota Mbwana enu. ");
INSERT INTO eko_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ila eweeleyeni vitthu zaya epo; maana, mweenyewe nyuupa eriwaka eetta ojuwa wakathi antaavo anamwiiya, eetta ojeekesela na khaari olikhelela opwechiwa nyuupa yawe. ");
INSERT INTO eko_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tiito, mweeyo theenya mwiiye woojilikanisa, maana wakathi antaavo Mwaana wa Pinaatamu pi opule mwihinaakhipwelaaye. ");
INSERT INTO eko_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ti tuuvi karumeya wawaamineya na waakhili, otule Mbwana awe amwinkhiyeeyo osala vaje vawe yoori asala awenkha atthu etthu-yoojiwa wakathi khaamili? ");
INSERT INTO eko_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Wooparikhiyiwa karumeya otule mbwana awe ataaka anttelaaye onsikana arettaka etthiipo. ");
INSERT INTO eko_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Weekhweele kiniwuuzani yoori onttela olikheliwa weettettisa maali zooshi za mbwana awe. ");
INSERT INTO eko_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ila karumeya otule amana eeya wootakhala rooho, ajilupezaka mweenyewe yoori: ‘Mbwana aka ontta orupaza,’ ");
INSERT INTO eko_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","na khusala awaapiya ashirikhaawe na oja na onywa na ananhapaliwa, ");
INSERT INTO eko_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","onttela ota mbwana wa karumeya otule khwa siikhu ahaari waakhipwelaaye na wakathi ahinjuwaaye. ");
INSERT INTO eko_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ye onta onhukhumu saaneene antthe puuro ya manaafikhi, ottuukho onttelaaye wiiyawo olila na oluma meeno. ");
INSERT INTO eko_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Siikhu yaya eto, Ofwalume wa pinkuuni onttela wiiya nkhama aamwari khumi athuuliye makhompe aya, khulawa okutthanana mposi. ");
INSERT INTO eko_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Athaanu khwa apale khumi aari alolo, athaanu aari akhili. ");
INSERT INTO eko_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Apale oololo khuthuula makhompe aya, khuhinthuuli patarooya, ");
INSERT INTO eko_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ila apale a akhili olikha othuula makhompe-ru khunthuula theenya patarooya nttopwiyo. ");
INSERT INTO eko_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mposi khurupaza ofiya, na ooshi khuwaakhola osikizi khulala. ");
INSERT INTO eko_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ila osikhu layili, khusiileya nkhuwo waari oraaye: ‘Mposi afiya! Mwisaruwe mwampwekherele.’ ");
INSERT INTO eko_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Aamwari apale ooshi khulankha khusala atthenkeza makhompe aya. ");
INSERT INTO eko_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Apale oololo khusala awooza apale awiiyana akhili yoori: ‘Mwinimeele patarooya enu vattitthiiru, maana makhompe eetthu antta osizila.’ ");
INSERT INTO eko_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Yo khujipu yoori: ‘Wala, khanfiyela onrumeyela mweeyo na fweeyo. Mwilawe mwamuuzanye patarooya. ");
INSERT INTO eko_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Wakathi alawiyeevo omuuzanya patarooya, mposi khufiya, aamwari apale ajitthekiyeeyo khuvira vamote na mposi olawa oja njampo la harusi na nlako khufukiwa. ");
INSERT INTO eko_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Wakathi vattitthiiru, khusala ata aamwari apale oololo khusala akhuwa araka: ‘Mbwana, mbwana, mwinifukulele nlako!’ ");
INSERT INTO eko_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ila ye khuwaajipu yoori: ‘Weekhweele kiniwuuzani yoori akinuujuwani.’ ");
INSERT INTO eko_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tiito kiniwuuzanini yoori mwijeekesele, maana mweeyo khamwinjuwa siikhu wala wakathi aya. ");
INSERT INTO eko_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Theenya Ofwalume wa pinkuuni onttela wiiya nkhama mwinyi mmote atakhaka oretta safwari, khuwaakhuwela akarumeya awe khuwaalikhela maali zawe. ");
INSERT INTO eko_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Mmote khumwinkha milikhi thaanu za nzurukhu wa feeta, nkina khumwinkha milikhi piiri, nkina theenya khumwinkha milikhi moote, wakhula ntthu amwinkhiye khwa makhaamu awe. Elottelanaka khulankha khusala alawa safwari yawe. ");
INSERT INTO eko_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Otule enkhiweeyo milikhi thaanu za nzurukhu wa feeta, khulankha nasaapiru olawa oretta zanshara khupattha milikhi thaanu kiina. ");
INSERT INTO eko_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Otule aariina mizurukhu milikhi piiri khupattha milikhi piiri teenya. ");
INSERT INTO eko_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ila otule enkhiweeyo nzurukhu milikhi moote khulankha khulawa khuthipa liphotto vathi khutthaavo khuvitha nzurukhu wa mbwana awe. ");
INSERT INTO eko_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Paata ya ovira wakathi mwinkeene, mbwana wa akarumeya apale khuruti khuretta thamani na apale aya. ");
INSERT INTO eko_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Otule aapwekheriyeeyo nzurukhu milikhi thaanu wa feeta, khutiisa theenya nzurukhu milikhi thaanu wa feeta na khuri: ‘Mbwana, waakinkhiye nzurukhu milikhi thaanu wa feeta, woona kapattha theenya fwayita ya milikhi thaanu.’ ");
INSERT INTO eko_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mbwana khunjipu yoori: ‘Kemaani, karumeya wooshapweya na wawaamineya! Weeyo waamineya khwa ttiitthiiru, apho kintta owinkha yawaatta. Ote ofurahi vamote na mbwana awo. ");
INSERT INTO eko_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Khuta theenya otule apwekheriyeeyo nzurukhu milikhi piiri wa feeta khuri: ‘Mbwana aka waakinkhiye nzurukhu milikhi piiri wa feeta, kapattha theenya milikhi piiri.’ ");
INSERT INTO eko_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mbwana awe khunjipu yoori: ‘Kemaani, karumeya wooshapweya na wawaamineya, weeyo waamineya khwa ttiitthiiru, miiyo kiniwinkha zawaatta. Ote ofurahi na Mbwana awo.’ ");
INSERT INTO eko_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Mwiisho khuta otule apwekheriyeeyo nzurukhu milikhi moote khuri: ‘Miiyo kaajuwiye yoori mbwana o ntthu woozivala, onuurulaaye na epile ohikheyeeni na okusanya epile ohizaleeni. ");
INSERT INTO eko_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tiito keetta woova, khulawa khuvitha nzurukhu awo milikhi moote wa feeta khuthipela vathi. Woone, apha opu nzurukhu awo.’ ");
INSERT INTO eko_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mbwana khunjipu yoori: ‘Karumeya wootakhala na wooviliwa! Weeyo waajuwiye yoori kinuurula na epile kihikheyeeni na kinkusanya epile kihizaleeni. ");
INSERT INTO eko_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Aphano weeyo waarina ya olawana nzurukhu aka opanko yoori amana kiruti kinkhiwe nzurukhu aka wa wiiyana fwayita. ");
INSERT INTO eko_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mwinnyakanye nzurukhu opo milikhi moote wa feeta, mwimwinkhe otule ariina milikhi khumi. ");
INSERT INTO eko_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Maana otule ariina, onttela winkhiwa theenya na oniiyana zawaatta. Ila otule ahina, hatha etile ariina ontta onyakanyiwa. ");
INSERT INTO eko_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Karumeya woohiina fwayita, mwimweeselele othetekele n'yiiza nttumpho oriimo olila na oluma meeno.’ ");
INSERT INTO eko_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Amana Mwaana wa Pinaatamu ata nsiifwa mwawe na malayikha ooshi, onttela wiikhala vakhukulu vawe ya nuuru ya pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Khapila zooshi zinttela okusanyiwa aphale ariivo, avalule khapila khwa khapila kiina nkhama nshuki avalulaka pwittipwitthi zawe vakatthi wa puuzi. ");
INSERT INTO eko_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Atthe pwittipwitthi nkhono nlume na puuzi nkhono nkha. ");
INSERT INTO eko_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Aphano Mfwalume onttela owooza apale anttelaaye wiiya nkhono nlume yoori: ‘Mwite mweeyo ooparikhiyiwa ti Paapa! Mwipwekherele Ofwalume nkhama eritho mwitthenkezeliweeyo thanku wumpiwa wa olumwenku. ");
INSERT INTO eko_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Maana miiyo yaakikholiye jala, mweeyo khukinkha etthu-yoojiwa; lakikholiye nnyottha, mweeyo khukimeela maati oonywa; kaari nletto mweeyo khukinkha puuro ya omaka. ");
INSERT INTO eko_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kathaaleliwe, mweeyo khukinkha kuwo; keetta olwaaziwa, mweeyo khukiinanela; kaari nkalapooso, mweeyo khukithotola.’ ");
INSERT INTO eko_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Aphano makhaamili anteela onjipu yoori: ‘Mbwana, lini naawoniyeevo na jala khuwinkha etthu-yoojiwa, ama lookholiye nnyottha khuumeela maati? ");
INSERT INTO eko_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Wakathi-ni nawooniyeevo ori nletto khuwinkha puuro ya omaka? Ama othaaleliwe, khuwinkha kuwo? ");
INSERT INTO eko_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Wakathi-ni nawooniyeevo ori nlwele ama nkalapooso khuta khuuthotola?’ ");
INSERT INTO eko_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mfwalume khujipu yoori: ‘Kiniwuuzani khweele yoori, etile mweeyo mwiwaaretteliyeeyo mmote wa attwiizaku apa attiitthi, mwakirettela miiyo.’ ");
INSERT INTO eko_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Aphano ye onttela owooza apale a nkhono nkha awe yoori: ‘Anamalaanikha mwikaattuwe! Mweette omoottho wa mileele, waattaleleliweeyo Sheethwani na masheethwani awe. ");
INSERT INTO eko_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Maana miiyo yaakikholiye jala, mweeyo khuhikinkhi hatha etthu-yoojiwa, laakikholiye nnyottha mweeyo khuhikinkhi hatha etthu yoonywa. ");
INSERT INTO eko_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Kaari nletto mweeyo khihikinkhi hatha puuro yoomakavo, kathaaleliwe mweeyo khuhikinkhi kuwo, keetta olwaaziwa na ofukeliwa nkalapooso, mweeyo wala okithotola.’ ");
INSERT INTO eko_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yo anjipu yoori: ‘Mbwana, nawoona lini yuukholiye jala wala luukholiye nnyottha ama ori nletto ama ohina kuwo ama olwaaziwaka na ofukeliwe, fweeyo kuhiwaawuni?’ ");
INSERT INTO eko_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ye ajipu yoori: ‘Kiniwuuzani khweele yoori, etile mwihinretteleeni mmote wa apale attiitthi, khamwikiretteleeni na miiyo.’ ");
INSERT INTO eko_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Apa aneetta ohukhumu khwa mileele, ila makhaamili anttela wiiyana ohaayi wa mileele.” ");
INSERT INTO eko_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Paata ya olupa vitthu epile, Yinsa khuwooza anakhiyoni awe yoori: ");
INSERT INTO eko_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nkhama mwinjuwaazo, ensaleela siikhu piiri ofiya siikhu ya njampo la Paashikowa, na Mwaana wa Pinaatamu onttela winkheleliwa yoori akhomeliwe.” ");
INSERT INTO eko_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Aphano mahaakhimu a tiini na attunkhulu a tiini khukusanyeya onyuupa wa haakhimu nwulu aari wiitthiwaaye Kayifwa; ");
INSERT INTO eko_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","khuwaza shawuri yoori ankhole Yinsa sirini na amuule. ");
INSERT INTO eko_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ila khusala alupa yoori: “Nihirette wakathi wa njampo yoori atthu ahipuwise nzuzu.” ");
INSERT INTO eko_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yinsa eettiye Betaaniya, owawe Simawu otule raku aariinaaye makuttula. ");
INSERT INTO eko_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Aphano muukha mmote khuta aphale aariivo Yinsa athuuliye suupha ya mafuttha oonukhela awaatta nzurukhu, khwiitthela eeshwa ya Yinsa wakathi ansikaniyeevo eekhaliye vameeza. ");
INSERT INTO eko_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Anakhiyoni ooniyeevo vitthu epile khushanka na khuri: “Mwaasa aya niini oharipwaka mafuttha apa? ");
INSERT INTO eko_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mafuttha apa ahoozanyisiwe, nzurukhu aya enkhiwa asikhini!” ");
INSERT INTO eko_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ila Yinsa ajuwiyeevo etthu aari olupaaye, khuri: “Mwinimwantipwelani muukha otu? Ye aretta etthu yooshapweya khwa miiyo. ");
INSERT INTO eko_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Maana asikhini aniiya vamote na mweeyo wakhula siikhu, ila miiyo wala. ");
INSERT INTO eko_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mafuttha apa eettheliyeeyo mwiili aka, ye aretta khwa ontthenkeza ozikhiwa waka. ");
INSERT INTO eko_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kiniwuuzani khweele yoori: Wakhula vahali entafusiriwaavo hapari zooshapweya khwa olumwenku wooshi, epi arettiyeeyo muukha otu, zeettaka olupiwa noofikhiriwa ye.” ");
INSERT INTO eko_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Aphano mmote wa apale khumi na awiri, aariwitthiwaaye Yuuda Eshikariyoote, khulawa okutthanana mahaakhimu a tiini. ");
INSERT INTO eko_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Khuwoozela yoori: “Mwinikiripha kavi amana miiyo kiwinkhelelani?” Yo khusiilana onripha nzurukhu talaathiini wa feeta. ");
INSERT INTO eko_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Waaza wakathi otthuupule Yuuda khusala eekesaka nanna ya omwinkhelela Yinsa mmakhono wa maatuwi awe. ");
INSERT INTO eko_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Siikhu ya mwanzo ya Njampo la Phaawu Yoohiina Fwaramento, anakhiyoni khumwaattama Yinsa khumuuzela yoori: “Ontakha yoori nitthenkeze vayi etthu-yoojiwa ya Paashikowa?” ");
INSERT INTO eko_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yinsa khujipu yoori: “Mwilawe nsitati mwakutthanane mwinyi mmote mwimuuze yoori: ‘Mwaaliimu alupa yoori: Wakathi aka onsaleela ofiya. Kinttela onja Paashikowa na anakhiyoni aka vaje vawo.’” ");
INSERT INTO eko_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Anakhiyoni khuretta etthiipile ooziweezo ti Yinsa na khuntthekeza Paashikowa. ");
INSERT INTO eko_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Weettelaka oripa, Yinsa khulawa khwiikhala vameeza na anakhiyoni awe apale khumi na awiri. ");
INSERT INTO eko_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Eettaka oja, khulupa yoori: “Kiniwuuzani khweele, mmote wa mweeyo onlawa akizinkule.” ");
INSERT INTO eko_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yo khwiiya oohuzunikha channu na khwaaza wuuzelana yoori: “Weekhweele khahiyo miiyo Mbwana?” ");
INSERT INTO eko_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yinsa khujipu yoori: “Nlupa anttelaaye okizinkula kinjana sahani moote. ");
INSERT INTO eko_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwaana wa Pinaatamu onlawa afwe, nkhama etthiipo yaatikhiweeyo monkoni wa ye. Ila wootakhaliwa ti otule anttelaaye onzinkula Mwaana wa Pinaatamu! Afwataali ahivokoliweeni.” ");
INSERT INTO eko_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Aphano Yuuda, namazinkula, khuri: “Talili ti miiyo Mwaaliimu? Yinsa khujipwela araka: “Ayo, ti weeyo.” ");
INSERT INTO eko_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Eettaka oja, Yinsa khuthuula phaawu, khuparikhiya, khumeya na khuwenkha anakhiyoni awe araka: “Mwithuule na mwirafune; opu mwiili aka”. ");
INSERT INTO eko_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Elottelanaka khuthuula jiikira, khushukhurwela na khuwenkha araka: “Mwinywe mooshi mweeyo. ");
INSERT INTO eko_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Eti taamu yaka ya wahati yiitthiweeyo khwa zwaamu ya atthu awaatta yoori eswaamiheliwe twampi. ");
INSERT INTO eko_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Miiyo kiniwuuzani yoori, waaza nasaapi mpakha okho ninttaawo, akinlawa onywa nshumo wa nrayi wa wuuva mpakha siikhu kinttelaaye onywa theenya nshumo wa nrayi wa wuuva na mweeyo muufwalume wa Paapa. ");
INSERT INTO eko_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Paata ya yo wiipa liipo limote, khusala alawa omwaako Oluveera. ");
INSERT INTO eko_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Aphano Yinsa khulupa yoori: “Osikhu opu, mooshi mweeyo mwinteela okitthira. Maana yaatikhiwa yoori: ‘Kininvulalisa nshuki, pwittipwitthi za liphanko lawe zimwazeye.’ ");
INSERT INTO eko_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ila paata ya osisimuwa waka, kinttela olokoza Kalileya.” ");
INSERT INTO eko_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pheeturu khujipu yoori: “Hatha nkhama ooshi eetta wuutthira, miiyo akinteela wuutthira.” ");
INSERT INTO eko_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yinsa khumuuza araka: “Weekhweele kiniwuuza yoori osikhu otthuupu, likukhuwi lihineekhe, weeyo onlawa wakikhane swaafu ttatthu.” ");
INSERT INTO eko_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pheeturu khujipu theenya yoori: “Hatha nkhama ofwa vamote na weeyo, akinteela wuukhana!” Anakhiyoni ooshi khulupa etthiipo. ");
INSERT INTO eko_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Aphano Yinsa khulawa na anakhiyoni awe puuro eniitthiwaaye Yetemaani khuwooza yoori: “Mwiikhale apha, miiyo kinttela olompa aphale.” ");
INSERT INTO eko_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Khunthuula Pheeturu na aana awiri a Zepeteewu, Yinsa khwaaza ohuzunikha na othunkuwikha. ");
INSERT INTO eko_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yinsa khuwooza yoori: “Nafusi yaka ti ya ohuzunikha venkivene, woosaleela ofwa. Apho mwisale apha na nijeekesele fooshi.” ");
INSERT INTO eko_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Khususa vattitthiiru, khukokhora khufiisa ajihi yawe vathi, khusala alompa araka: “Paapa, nkhama enwaheya, okaattuwanize jiikira eti ya ohoowa; ila ehirettikhane nkhama kintakhaazo, ila nkhama ontakhaazo. ");
INSERT INTO eko_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Paata ya toole, khurutela aphale aariivo anakhiyoni awe khuwaasikana eettaka olala. Yinsa khumuuzela Pheeturu yoori: “Mweeyo khamwiwaheeni nenkawu ojeekesela fooshi wakathi mmote paasi? ");
INSERT INTO eko_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mwijeekesele na mwilompe yoori mwihikwele muuzayiniwa. Rooho ti yookhomaala ila mwiili pi woottettheya.” ");
INSERT INTO eko_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Khurutela olawa olompa theenya khuri: “Paapa, nkhama khinwaheya okattuwananisa jiikira eti khapula kihinyweeni, ti arettikhane matakhelo awo.” ");
INSERT INTO eko_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wakathi arutiyeevo theenya khuwaasikana eettaka olala, maana maasho aya eetta owaalemela. ");
INSERT INTO eko_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Aphano khuwaalikha theenya, khulawa olompa swaafu ya ttaatthu, alupaka mattakhuzi atthaapale. ");
INSERT INTO eko_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nawiisha khurutela attaaphale aariivo anakhiyoni awe na khuwoozela yoori: “Mweeyo nalelo mwintta olala na wiitthuuwa? Wafiya wakathi! Moone yoori Mwaana wa Pinaatamu onttela winkheleliwa mmakhono wa anatwampi. ");
INSERT INTO eko_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mwilankhe, nilawe; oto antaaye apho namazinkula! ");
INSERT INTO eko_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Eettaka ottakhula etthiipile, khuta Yuuda, mmote wa apale khumi na awiri, vamote na khuntti khuluyeene athuuliye phanka na puutta, zaaperekhiweeyo ti mahaakhimu a tiini na attunkhulu a tiini. ");
INSERT INTO eko_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Namazinkula aawenkhiye alama apale aasiilananiyeeyo araka: “Otule kinttelaaye ompatikha ti othuuto, mwinkhole.” ");
INSERT INTO eko_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Wakathi Yuuda aari omwaattamaavo Yinsa khuri: “Salaama, Mwaaliimu!” Na khumpatikha. ");
INSERT INTO eko_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yinsa khumuuza yoori: “Swaahipu, etile oteeliyeeyo oretta, waakuve orette”. Attaaphale khususeliwa, khukholiwa Yinsa khufukiwa. ");
INSERT INTO eko_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mmote wa apale aarina Yinsa khookola nkhono khuthuula phanka khushija nshiilo la karumeya wa haakhimu nwulu wa tiini. ");
INSERT INTO eko_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Aphano Yinsa khuwooza anakhiyoni awe yoori: “Mwipwehe phanka! Maana wooshi otule anlipanaaye phanka, ofwa khwa phanka ethiito. ");
INSERT INTO eko_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mweeyo mwinoona yoori miiyo akinwahi onvekela Paapa khukiperekheza nasaapi khuntti khumi na piiri za malayikha? ");
INSERT INTO eko_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nkhama etthiipo enlupaaye Zawaatikhiwa Ttakatthiifu yoori vitthu zaarina ya orettikhana nkhama etthiipi?” ");
INSERT INTO eko_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Wakathi otthuupule Yinsa khuwoozela atthu apale yoori: “Mwateela okikhola na phanka na puutta, nkhama nlokozi wa anazompere? Siikhu zooshi miiyo kaari osomisa Nnyupa Woosifwiwamo, khi mweeyo ohikikholi! ");
INSERT INTO eko_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ila zooshi epi zarettikhana yoori emarisele zawaatikhiwa za manapiyu. Aphano anakhiyoni ooshi khumwanswi na khuntthira. ");
INSERT INTO eko_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Apale ankholiyeeyo Yinsa khunthuula khunlawana wa Kayifwa, haakhimu nwulu wa tiini ottuukho aakusanyeyiyeeyo anamanozela a kano na attunkhulu a tiini. ");
INSERT INTO eko_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pheeturu eetta owaalotta peetiwene mpakha vaje wa haakhimu nwulu wa tiini, khuvira khwiikhala na anamweekesela yoori oone zooshi nanna zaari weettelaaye wiishela. ");
INSERT INTO eko_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mahaakhimu a tiini na mashawuriiya ooshi aari weekesa oshaahiti woovonyeya khwa Yinsa yoori anhukhumwele ofwa. ");
INSERT INTO eko_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ila khuhinsikanani, aapuwiye-ru atthu awaatta oolaza oshaahiti woovonyeya. Omwiisho khujithoonyeza atthu awiri, ");
INSERT INTO eko_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","khulupa yoori: “Mwinyi otu alupa yoori: ‘Miiyo kinwahi opwecha Mwimpari Nluku na khujeka khwa siikhu ttatthu.”’ ");
INSERT INTO eko_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Aphano haakhimu nwulu wa tiini khulankha khumuuza Yinsa yoori: “Khunjipu epo onlupeziwaaye?” ");
INSERT INTO eko_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ila Yinsa nalelo khwiiya woonyamala. Haakhimu nwulu wa tiini khumuuza yoori: “Kinuuvekela yoori weeyo olaphe khwa Nluku woohaayi, nkhama weeyo o Al-Masiihu, mwaana wa Nluku, onuuze.” ");
INSERT INTO eko_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yinsa khujipu yoori: “Weeyo walupa. Ila miiyo kiniwuuzani mooshi mweeyo yoori: enttela ofiya siikhu mwinttelaaye omoona Mwaana wa Pinaatamu eekhaliye nkhono nlume wa nwahi zooshi, ataaka khwa mawiku a pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Aphano wakathi haakhimu nwulu wa tiini avaruliyeeyo kuwo zawe na khulupa yoori: “Akufuru! Mwaasa wa niini nihithajiyaka oshaahiti nkina theenya? Mweeyo mwasiila nasaapi okufuru wawe! ");
INSERT INTO eko_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mwinuupuwela toovi?” Khujipu yoori: “Oninsuhi ofwa!” ");
INSERT INTO eko_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Akina khusala antthemela omaasho na ompiya, akina khusala ampwakula araka: ");
INSERT INTO eko_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Onlupe, Oo Al-Masiihu, ti paani oopiyeeyo? ");
INSERT INTO eko_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pheeturu eettiye wiikhala vaje. Njaazi mmote khumwaattama khumuuza yoori: “Na-weyo waari na Yinsa nkalileya.” ");
INSERT INTO eko_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ila ye khukhana vakatthi wa atthu ooshi araka: “Akinjuwa etthu onttakhulaaye.” ");
INSERT INTO eko_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Paata ya toole khuthoonya phantte ya omilako, njaazi nkina khumoona khuwooza apale aari attaaphale yoori: “Mwinyi otu aari na Yinsa wa Nazareeti.” ");
INSERT INTO eko_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ye khukhana theenya khwa olapha araka: “Akininjuwa mwinyi aya otu!” ");
INSERT INTO eko_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Elottelanaka, apale aari attaaphale khumwaattama Pheeturu khumuuza yoori: “Weekhweele weeyo o wawe! Ottakhula wawo onthoonyeza.” ");
INSERT INTO eko_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Attaaphale ye khwaaza ojilaani na olapha araka: “Akininjuwa!” Nasaapiru likukhuwi khwiikha. ");
INSERT INTO eko_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Aphano Pheeturu khufikhiri nttakhuzi ooziweeyo ti Yinsa yoori: “Likukhuwi lihineekhe onteela okikhana swaafu ttatthu.” Noolaavo aphale vaya khulila wakatapuvo. ");
INSERT INTO eko_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Supuyeene, attunkhulu a mahaakhimu na anamalokozela a tiini khujilakelela onhukhumwela Yinsa ofwa. ");
INSERT INTO eko_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Khunfuka khunthuula khunlawana wa nsatoro Pilaatu. ");
INSERT INTO eko_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Wakathi Yuuda, otule anzinkuliyeeyo, ooniyeevo yoori Yinsa onttela ohukhumwiwa, khuthupwiya na khulawa owaarutisela attunkhulu a mahaakhimu na anamalokozela a tiini nzurukhu opule talaathiini wa feeta aathuuliyeeyo. ");
INSERT INTO eko_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Khuri: “Kakosa, khwa ozinkula taamu yoohikosi.” Yo khujipu yoori: “Fweeyo ennijali niini? Epo ti weeyo onjuwaaye.” ");
INSERT INTO eko_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Aphano Yuuda khweeselela nzurukhu omwimpari. Khusaruwa nawiisha khulawa khujiheya. ");
INSERT INTO eko_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mahaakhimu a tiini khukusanya nzurukhu opule, khuri: “Khahi halaali othuula khuttha mmwifukho wa zaakha, maana hisapu ya taamu.” ");
INSERT INTO eko_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Aphano khusiilana orumeyela nzurukhu aya opule khwa wuuzanyela nshapa la namuupa yoori lirettiwe vilalo la ozikhiwamo aletto. ");
INSERT INTO eko_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tiito nshapa laya nttho liniitthiwaaye Nshapa la Taamu mpakha siikhu epi za leelo. ");
INSERT INTO eko_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Aphano khurettikhana epile zaalupiweeyo ti napiyu Jeremiiya yoori: “Athuula nzurukhu talaathiini wa feeta, hisapu yootthiiwa pi atthu a Ezirayiilu, ");
INSERT INTO eko_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","khuuzanyela nshapa la namuupa, nkhama etthiipo Mbwana aakirumiyeezo.” ");
INSERT INTO eko_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yinsa khutthiiwa omaasho wa nsatoro ye khumuuzela yoori: “Weeyo onfwalume wa mayaahuuti?” Yinsa khujipu yoori: “Pi etthiipo olupiyeezo.” ");
INSERT INTO eko_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ila eettaka olokoveziwa etthiipile pi attunkhulu a mahaakhimu na anamalokozela a tiini, ye khuhijipu. ");
INSERT INTO eko_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Aphano Pilaatu khumuuzela yoori: “Weeyo khunsiila vitthu epo onlokoveziwaaye pi atthu apo?” ");
INSERT INTO eko_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ila Yinsa khuhijipu hatha nttakhuzi, khwa ethiito nsatoro khwiiya wooshanka. ");
INSERT INTO eko_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Amana efiya siikhu ya njampo nsatoro aazowereliye onfukulela ntthu woothawuliwa pi atthu. ");
INSERT INTO eko_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Yo wakathi aya otthuupule aarina napherezu woojuwanikha aari wiitthiwaaye Baraapa. ");
INSERT INTO eko_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pilaatu khuwoozela atthu apale athukumaniyeeyo attaaphale yoori: “Ti tuuvi khwa apa awiri mwintakhaaye yoori kinfukulele: Baraapa ama Yinsa aniitthiwaaye Al-Masiihu? ");
INSERT INTO eko_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Maana aajuwiye yoori anlawaniye okhule mwaasa nrima. ");
INSERT INTO eko_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilaatu eekhaliye onyuupa woophukiwamo, muukha awe khumperekha hapari araka: “Ohijiphakanyane apo, maana leelo muulottha kahoowa venkivene monkoni wa ye.” ");
INSERT INTO eko_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ila mahaakhimu a tiini na anamalokozela a tiini khuwaakhitiri atthu apale yoori aveke Ofukuliwa Baraapa na ooliwe Yinsa. ");
INSERT INTO eko_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Aphano Nsatoro khuuzela yoori: “Khwa atthu apa awiri mwinintakhelaaye yoori miiyo kinfukulele ti tuuvi?” Yo khujipu yoori “Baraapa!” ");
INSERT INTO eko_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilaatu khuuzela yoori: “Khi kinrettele niini Yinsa, aniitthiwaaye Al-Masiihu?” Ooshi khujipu yoori: “Akhomeliwe!” ");
INSERT INTO eko_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilaatu khuuzela yoori: “Niini arettiyeeyo yootakhala?” Ila atthu apale khusala avira atepaka onyakula araka: “Akhomeliwe!” ");
INSERT INTO eko_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Wakathi Pilaatu asopheliyeevo yoori khaari opattha hatha swamiima, ila olikha toowo khusala oona weekezeleya nzuzu, khurumisa otiiseliwa maati, khunawa omaasho wa atthu apale na khulupa yoori: “Akina paathuli khwa taamu ya ntthu otu; eto zwaamu yenu.” ");
INSERT INTO eko_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Atthu ooshi apale khujipu yoori: “Taamu yawe ti eniittikhele fweeyo na aana etthu!” ");
INSERT INTO eko_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Aphano Pilaatu khunfukulela Baraapa, khuruma ojaphiwa Yinsa na khumwinkhelela olawa okhomeliwa. ");
INSERT INTO eko_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Elottelanaka, anajanka a nsatoro khunthuula Yinsa khunlawana nyuupa khuulu ya nsatoro khukusanyeya anajanka ooshi khunzukulela. ");
INSERT INTO eko_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Khunvula kuwo zawe khunwalisa ajapi yookhuttuwa; ");
INSERT INTO eko_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","khuvaasha khaara ya miiwa, khunwalisa mmwishwa mwawe na khunttheela puutta nkhono awe nlume, khunkokhorela khusala anveyisa, araka: “Ojuusuru, mfwalume wa mayaahuuti!” ");
INSERT INTO eko_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Khusala antthemela na khunnyakanya puutta etile, khumpiyana veeshwa. ");
INSERT INTO eko_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Paata ya onveyisa, khunvula ajapi etile khunwalisa ajapi yawe. elottelanaka khusala alawa onkhomela. ");
INSERT INTO eko_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Alawaka, khukutthanana nsireene aari wiitthiwaaye Simawu, khukhanyareliwa othuula nsalapa wa Yinsa. ");
INSERT INTO eko_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Yo khufiya puuro eniitthiwaaye Kolokoota, eriina maana a puuro ya likurakuza la eeshwa, ");
INSERT INTO eko_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","khumwinkha onywa viinyu yoophakanyaniwa wamwe; ila ye wakathi ootiyeevo, khukatthala onywawa. ");
INSERT INTO eko_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Paata ya onkhomela, khwawanyana kuwo zawe khwa weekesa nasipu. ");
INSERT INTO eko_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Khwiikhala attaaphale khusala amweekesela. ");
INSERT INTO eko_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Vatulu wa eeswa yawe khutthiiwavo lipawu laatikhiweeyo khwa olokoveziwa wawe yoori: “OTU TI YINSA, MFWALUME WA MAYAAHUUTI.” ");
INSERT INTO eko_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Na aakhomelaniwe anamwiiya awiri, mmote nkhono nlume nkina nkhono nkha. ");
INSERT INTO eko_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Apale aari oviraaye eetta onttukhana na wiinisa viishwa zaya, ");
INSERT INTO eko_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","araka: “Oo weeyo waari weettelaaye opwecha Nyuupa Yoosifwiwamo na khujeka khwa siikhu ttatthu, ojuusuru! Wiishukhe vansalapa apho nkhama omwaana wa Nluku!” ");
INSERT INTO eko_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Khwa nanna etthiipo mahaakhimu a tiini, anamanozela a kano na attunkhulu a tiini eetta onveyisa, ");
INSERT INTO eko_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","araka: “Wawoosuru akina, ila khunwahi ojuusuru! Mfwalume wa Ezirayiilu! Eeshukhe nasaapi vansalapa apho, nintta onkhupali. ");
INSERT INTO eko_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ye amwaamini Nluku. Nluku ti amuusuru nasaapi ethiiti, nkhama ona huruma na ye, maana alupa yoori: ‘Ki mwaana wa Nluku!”’ ");
INSERT INTO eko_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Theenya anamwiiya apale aakhomelaniweeyo khusala anttukhana. ");
INSERT INTO eko_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yaapuwiye yiiza nti wooshi, payina ya saasiitha mpakha saakhentta. ");
INSERT INTO eko_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Paata ya ofiya saakhentta, Yinsa khukhuwa woonyakulavo, araka: “Eloohi, Eloohi, lama sabatani?” Eriina maana a “Nluku aka! Nluku aka! Mwaasa wa niini okanswaka?” ");
INSERT INTO eko_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Akina aarivo noosiila epile, khulupa yoori: “Ye oninkhuwela Aliyaasi.” ");
INSERT INTO eko_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Woohirupazi, mmote wa yo khutthirela shiponja, khunaanisa na viinyu yoonyuunya, khuttha pontha wa tteketthe na khumwinkha Yinsa yoori anywe. ");
INSERT INTO eko_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Akina khusala alupa yoori: “Mwinlikhe, nimoone nkhama Aliyaasi onteela omuusuru.” ");
INSERT INTO eko_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Aphano Yinsa khukhuwa woonyakulavo saaneene khufwa. ");
INSERT INTO eko_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Wakathi otthuupule phazira ya omwimpari khwaawanyeya vakatthi, waaza vatulu mpakha vathi. Nti khusakhinyeya na mawe khupwecheya. ");
INSERT INTO eko_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Khapuri epile khufunuwa na mwiili wa attakatthifu awaatta afwiyeeyo khusisimuwa. ");
INSERT INTO eko_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Noolaamo nkhapuri mphule, paata ya Yinsa osisimuwa, atthu apale akina asisimuwiyeeyo khweetta sitati Ttakatthiifu na khooniwa pi atthu awaatta. ");
INSERT INTO eko_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nttunkhulu wa anajanka na apale aari omweekeselaaye Yinsa, nawoona esikinyaatthi na zooshi zaarettikhaniyeeyo, khwiiya awoova channu khulupa yoori: “Khweele-khweele, ntthu otu aari mwaana wa Nluku!” ");
INSERT INTO eko_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Aakha awaatta aari attaaphale khusala oona ari peetiwene. Apale amperekhiyeeyo Yinsa waaza Kalileya yoori anrumeyele. ");
INSERT INTO eko_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Vakatthi vaya aarivo Mariyamu Mataleena, Mariyamu mamaawe Yaakhumpa na Yuusufu na Maama wa aana a Zepeteewu. ");
INSERT INTO eko_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Njuwa leettelaka oveva, khuta mwinyi mmote wa thajiri wa Arimateeya anitthiwaaye Yuusufu aari namalottela wa Yinsa. ");
INSERT INTO eko_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Khulawa wa Pilaatu, khuveka mwiili wa Yinsa. Pilaatu khuruma winkhiwa. ");
INSERT INTO eko_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yuusufu khuthuula mwiili wa Yinsa khuputaputela va joora, ");
INSERT INTO eko_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","khunttha nkhapuri pheeya, aarumiyeeyo othipiwa vamawe. Vanlako wa khapuri yaya khutthaavo liwe liwululene, khulankha khusala alawa. ");
INSERT INTO eko_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariyamu Mataleena na Mariyamu nkina, eekhaliye attaaphale omaasho wa khapuri. ");
INSERT INTO eko_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mmeesho mwaya, siikhu ya saapatu, mahaakhimu a tiini na amafwarizeewu khulawa wa Pilaatu. ");
INSERT INTO eko_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Yo khumuuza yoori: “Mbwana, ninfikhiri yoori wakathi aariiye haayi, namattettekha otule aalupiye yoori siikhu ya ttaatthu ontta osisimuwa. ");
INSERT INTO eko_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Apho orume yoori khapuri etile yeekeseliwe saaneene mpakha siikhu ya ttaatthu, yoori ehirettikhane ota anamalottela awe khupwecha khapuri na awooze atthu yoori: ‘Asisimuwa muufwa,’ linttela wiiya nzuuzu lootepa zayita la mwanzo.” ");
INSERT INTO eko_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilaatu khulupa yoori: “Apho mwawaathuule anajanka. Mwilawe mweekesele khapuri khwa nanna mwinoonaaye yoori mwinwahi.” ");
INSERT INTO eko_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yo khulawa khusoromezavo liwe ntthile lafuukaniweeyo khapuri na khuwaalikha attaaphale anajanka eekeselaka. ");
INSERT INTO eko_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Paata ya ovira lifwajiri, yeettelaka waaziwa siikhu ya mwanzo ya sumana, Mariyamu Mataleena na Mariyamu nkina khulawa woona ovilalo. ");
INSERT INTO eko_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aphano khupuwa esikinyaatthi khuluyeene, maana nlayikha la Mbwana leetta wiishukha pinkuuni khuta mpakha vakhapuri khususisa liwe ntthile laafukaniweeyo khwiikhalela. ");
INSERT INTO eko_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ozerima wawe waari nkhama taari na kuwo zawe zaari zoolakala nkhama maphovu. ");
INSERT INTO eko_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Anamweekesela khusala athukumela mwaasa wa woova khumpuwa nkhama afwiiye. ");
INSERT INTO eko_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nlayikha ntthile khuwooza aakha apale yoori: “Mwihoove, kajuwa yoori mweeyo mwinimweekesa Yinsa otule aakhomeliweeyo. ");
INSERT INTO eko_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ye khaamo mphu, asisimuwa, nkhama etthiipo aalupiyeezo. Mwite moonevo apha aattattikheliweevo. ");
INSERT INTO eko_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mwilawe mwawooze anakhiyoni awe yoori Yinsa asisimuwa muufwa na alokoza kalileya. Mwinttela omoona ottuukho. Mattakhuzi aya pi atthaapa kiwuuziyeenini.” ");
INSERT INTO eko_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Aakha apale khusaruwa nvilalo mphule na waakuva eettaka woova na arina furaha, na khusala atthira olawa owooza anakhiyoni awe. ");
INSERT INTO eko_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nasaapiru, Yinsa khuwaapuwelela na khuwooza yoori: “Salaama!” Yo khumwaattama na khupatikha moolu awe khumwaaputu. ");
INSERT INTO eko_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Aphano Yinsa khuwooza yoori: “Mwihoove, mwilawe mwawooze attwiizaku apale eette Kalileya; anttela okoona ottuukhu.” ");
INSERT INTO eko_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Aakha apale nalelo ari ntarikhi, anajanka akina aari weekeselaaye vilalo etile khurutela ositati khuwooza mahaakhimu a tiini zooshi zaarettikhaniyeeyo. ");
INSERT INTO eko_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wakathi attunkhulu a mahaakhimu aakusanyeyiyeevo na anamalokozela a tiini, khuwaza shawuri. Khuwenkha anajanka nzurukhu wawaatta, ");
INSERT INTO eko_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","awoozaka yoori: “Alupe yoori: ‘Aatiiye anakhiyoni awe osikhu khumwiiya fweeyo neettaka olala.’ ");
INSERT INTO eko_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Yoori amana zifiya omashiilo wa nsatoro, fweeyo nintta omweeleza na nintta owaakisani khwa wakhula nlattu.” ");
INSERT INTO eko_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Etthiipile, anajanka khupwekhera nzurukhu opule na khuretta etthiipo anozeliweeyo. Mattakhuzi aya apo khumwazeyela vakatthi wa mayaahuuti mpakha leelo eti. ");
INSERT INTO eko_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Maswihaapa apale khumi na mmote khulawa Kalileya, omwaako okhule Yinsa awooziyeewo. ");
INSERT INTO eko_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Wakathi amoniyeevo khumwaaputu; akina khumwakanyera. ");
INSERT INTO eko_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Aphano Yinsa khuwaattama khuwooza yoori: “Kenkhiwa miiyo ofwalume, pinkuuni na vathi. ");
INSERT INTO eko_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nakataalikha, mwilawe mwawaarette anakhiyoni khwa khapila zooshi, mwiwoosaka khwa nzina la Paapa, la Mwaana, na Rooho Ttakatthiifu, ");
INSERT INTO eko_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","mwiwaasomisaka oshututela zooshi epile kirumiyeezo. Na miiyo kinttela wiiya vamote na mweeyo mpakha mwiisho wa wakathi. ");
INSERT INTO eko_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Omwanzo wa hapari zooshapweya za Yinsa Al-Masiihu, Mwaana wa Nluku. ");
INSERT INTO eko_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yaatikhiwa khwa ohupiri wa napiyu Ezaaya yoori: “Moone, kinlawa kamperekhe omaasho wawo karumeya aka, yoori atthenkeze tarikhi yawo; ");
INSERT INTO eko_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","huula enkhuwa enyakulaka n'yaara yoori: ‘Mwitthenkeze tarikhi ya Mbwana na mookolele miphiitelo zawe. ");
INSERT INTO eko_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Aapuwiye Yaahaya namoosa n'yaara, khusala atafusiri monkoni wa woosiwa na othupwiya khwa nswammaha wa twampi. ");
INSERT INTO eko_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Atthu ooshi a nti wa Yudeya na apale a Yeruzaleemu aari ovira ataaka na otukhuru twampi zaya na yo aari wiiya a woosiwa khwa ye mmuttho Yorotaani. ");
INSERT INTO eko_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Kuwo aari owalaazo Yaahaya zaari za shapala za enkamiiya. Ye aarina nzako awe wa shapala na aari ojaka mapalaka na asali ya ntthuttu. ");
INSERT INTO eko_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Atafusiraka aari ori: “Paata ya miiyo onta otule ariina oowahi zayita miiyo, oto akinsuhi ofukula mikhoyi za jampali zawe. ");
INSERT INTO eko_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Miiyo kiniwoosani na maati, ila ye onttela owoosani na Rooho Ttakatthiifu. ");
INSERT INTO eko_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Wakathi otthuupule, khuta Yinsa wa Nazareeti ya Kalileya khoosiwa ti Yaahaya mmuttho wa Yorotaani. ");
INSERT INTO eko_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nasaapiru, eettaka ovuuwa mmaati, khoona pinku efukuwiye na Rooho Ttakatthiifu yeettaka omwiishukhela nkhama jiwa. ");
INSERT INTO eko_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aphano khuta huula pinkuuni elupaka yoori: “Weeyo o mwanaka wa wuupheta, na wookituvela channu.” ");
INSERT INTO eko_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nasaapiru, Rooho Ttakatthiifu khunthuula khunlawana n'yaara. ");
INSERT INTO eko_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nttumpho eekhaliyeemo siikhu arupayiini, eettaka ozayiniwa ti Epiliisi. Ye aari vakatthi wa nyama za ntthuttu, ila malayikha aari ovira anrumeyelaka Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Paata ya Yaahaya ofukeliwa, Yinsa khulankha khusala alawa Kalileya, alaleyaka hapari zooshapweya za Nluku, ");
INSERT INTO eko_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","alupaka yoori: “Wakathi wafiya, na ofwalume wa Nluku ori kharipu; mwithupwiye na mwikhupali hapari zooshapweya.” ");
INSERT INTO eko_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Eettaka olawa alottaka shiini ya ntthatta la Kalileya, khuwoona attwi awiri Simawu na Antere, eeselelaka matthavi aya mpahari, mwaasa yoori aari anamajiya. ");
INSERT INTO eko_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yinsa khuwooza yoori: “Mwikilotte, kintta wuurettani wiiya anamajiya a atthu.” ");
INSERT INTO eko_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aphano nasaapiru khulikha matthavi aya khusala anlotta. ");
INSERT INTO eko_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Eettaka olawa etthiipile, khumoona Yaakhumpa, mwaana wa Zepeteewu na ttwiiye Yaahaya ari mmwaatiya alazelaka matthavi aya. ");
INSERT INTO eko_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Khuwaakhuwela, nasaapiru khunlikha papaaya mmwaatiya vamote na anakhaazi awe khusala anlotta Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Paata ya toole, khulawa Kafwaranaawu. Noofiya saapatu khulawa osomisa nsinakooka. ");
INSERT INTO eko_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Khusala awaatuvela masomi awe, maana aari owaasomisa nkhama ntthu wawiiyana ofwalume na woohiiyi nkhama anamanozela a kano. ");
INSERT INTO eko_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Aphano khuta nsinakooka mphule nlume aashinttiweeyo ti sheethwani. Ye khusala akhuwa araka: ");
INSERT INTO eko_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Onnitakhelani fweeyo, Yinsa wa Nazareeti? Wata yoori onitapanye? Kajuwa yoori weeyo o Ttakatthiifu wa Nluku!” ");
INSERT INTO eko_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ila Yinsa khunmaruwela araka: “Onyamale, oleemo mmwiili wa mwinyi otu!” ");
INSERT INTO eko_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Aphano sheethwani khuntatha ntthu otule woohusutivo khusaruwa mmwiili mwawe eettaka onyakula. ");
INSERT INTO eko_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Atthu ooshi khwiiya ooshanka mpakha khufiyelela wuuzelana atthaaporu yoori: “Niini epi zaya? Masomi mapheya antanaaye ofwalume! Mpakha onruma masheethwani yo khunshututela!” ");
INSERT INTO eko_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Hapari epile monkoni wa ye khumwazeyela nasaapiru nti wooshi wa Kalileya. ");
INSERT INTO eko_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Wakathi aliiyeemo nsinakooka, khulawa na Yaakhumpa na Yaahaya owawe Simawu na Antere. ");
INSERT INTO eko_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nkhwewe Simawu eettiye orapalela voolili, yaari onlwaaza hooma, nasaapiru khuuziwa Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Aphano ye khumwaattama, khunkhola nkhono khunlansa, nasaapiru hooma khumwiisha, khwaaza owaarumeyela. ");
INSERT INTO eko_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Weettelaka oripa, paata ya otupweela njuwa, atthu khuwaathuula alwele ooshi na anamasheethwani khumweettisela Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Atthu ooshi a nsitati mphule khukusanyeya vanlako wa nyuupa ethiitile, ");
INSERT INTO eko_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ye khuwaavonisa awaatta aari ohoochiwaaye pi marati a wakhula nanna. Theenya khwiikara masheethwani awaatta. Ye khaari olikha masheethwani apale ottakhula, maana yo aari onjuwa paani Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Supuyeene, nalelo ohinache saana, Yinsa khulankha khusaruwa khulawa puuro yawiitthaaleyavo ohali aari olompaawo. ");
INSERT INTO eko_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simawu na ashirikhaawe khulawa omweekesa. ");
INSERT INTO eko_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nonsikana, khumuuza yoori: “Atthu ooshi antta oweekesa weeyo!” ");
INSERT INTO eko_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yinsa khuwaajipu yoori: “Nlaweni ohali okinoko, miti naattamananiyeeyo, yoori kilawe kalaleye, maana tithiito miiyo kiteeliyeeyo.” ");
INSERT INTO eko_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aphano ye khweettetta Kalileya yooshi eettaka otafusiri nsinakooka na wiikara masheethwani. ");
INSERT INTO eko_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Namaharaja mmote khumwaattama na khunkokhorela khunvekela yoori: “Amana otakha onwahi okitwaharesha!” ");
INSERT INTO eko_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yinsa ari wawiitaala huruma, khookola nkhono awe khunsapa na khulupa yoori: “Kintakha. Wiiye wootwahareshiwa!” ");
INSERT INTO eko_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nasaapiru maaharaja apale khwiiya omwiisha na ye khwiiya wootwahareshiwa. ");
INSERT INTO eko_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Elottelanaka Yinsa khuwaaleeza na awaaleezaka woomaruwavo, ");
INSERT INTO eko_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","aphano Yinsa khumuuza yoori: “Ohimuuze hatha ntthu, ila olawe, wanvekele haakhimu yoori awoone nkhama wavona, arette twaha etile Munsa arumiyeeyo yoori wiiye oshaahiti. ");
INSERT INTO eko_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ila mwinyi otule khusala alawa na khwaaza olaleya vitthu epile na omwaza hapari. Mwaasa wa vitthu epile, Yinsa khuhisala awahi theenya weetta nsitati, ila khwiikhala othetekele puuro yawiitthaaleyavo. Khusala ata atthu wakhula phantte oteela okutthanana Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Paata ya siikhu vattitthiiru, wakathi Yinsa aaruteliyeeyo theenya Kafwaranaawu, atthu khusiila elupiwaka yoori ye aari owawe. ");
INSERT INTO eko_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Aphano atthu awaatta khweetta ottuukhule, khwa nanna ya haariivo puuro hatha vamilako, na khusala awaatafusirela nttakhuzi la Nluku. ");
INSERT INTO eko_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Khutavo atthu akina antiisiyeeyo ntthu aarina supiyaani, athuuliwe pi alume wane. ");
INSERT INTO eko_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Khuhisala awahi onfiisa aphale aariivo Yinsa mwaasa wa atthu waatta. Elottelanaka khulawa khutamula phantte ya liphala la nyuupa, khuphenyisavo nrepa opule arapaleliyeevo nasupiyaani. ");
INSERT INTO eko_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ooniyeevo amini etile aariina, Yinsa khumuuza nasupiyaani otule yoori: “Mwanaka, twampi zawo zaswaamihiwa.” ");
INSERT INTO eko_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Eekhaliye attaaphale anamanozela a kano akina na khwaaza wuupuwela: ");
INSERT INTO eko_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Mwinyi otu onttakhula toowo mwaasa wa niini? Ontta okufuru! Anwahaaye oswaamihi twampi ti paani, woohiiyi Nluku paasi?” ");
INSERT INTO eko_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yinsa nasaapiru khumweeleya nroho mwawe yoori zaari etthiipo epile yo aari wuupuwelaaye na khuwooza yoori: “Mwaasa aya niini mweeyo muupuwelaka vitthu epo nroho mwenu? ");
INSERT INTO eko_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Etthu yookhweya omuuza nasupiyaani titiivi, omuuza yoori: ‘Twampi zawo zaswaamihiwa’ ama ‘Olankhe othuule nrepa lawo weettette?’ ");
INSERT INTO eko_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ila yoori mwijuwe yoori Mwaana wa Pinaatamu onaaye owahi wa oswaamihi twampi” khumuuza nasupiyaani ");
INSERT INTO eko_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Miiyo kiniwuuza: Olankhe, othuule nrepa lawo olawe owawo.” ");
INSERT INTO eko_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wakathi otthuupule mwinyi otule khulankha ooniwaka pi atthu ooshi, khuthuula nrepa lawe khusaruwa. Yo khwiiya ooshanka na khunttitthimisa Nluku, alupaka yoori: “Khaninoone vitthu nkhama epi!” ");
INSERT INTO eko_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yinsa khulawa theenya kharipu ya ntthatta. Atthu awaatta khumwaattama na khwaaza owaasomisa. ");
INSERT INTO eko_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Eettaka ovira etthiipile, khumoona Matewuzhu mwaana wa Alufeeyu eekhaliye ariphisaka lumpuru, khumuuza yoori: “Okilotte.” Ye khulankha khunlotta. ");
INSERT INTO eko_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wakathi wa etthu yoojiwa, Yinsa eekhaliye va meeza owawe Leevi. Vamote na anakhiyoni awe, na aarivo anamariphisa lumpuru awaatta na “anatwampi” maana atthu aari onlottaaye aari enkeene. ");
INSERT INTO eko_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Anamanozela a kano apale amafwarizeewu amooniyeevo ajaka na “anatwampi” na anamariphisa lumpuru, khuwoozela anakhiyoni a Yinsa yoori: “Mwaasa aya niini ye ajaka na anamariphisa lumpuru na anatwampi?” ");
INSERT INTO eko_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Asiiliyeevo vitthu epile, Yinsa khuwooza yoori: “Akumi khaninhithajiya tothoro, ila apale anlwaziwaaye. Miiyo akateeliye owaakhuwela anashariya, ila anatwampi.” ");
INSERT INTO eko_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Aphano anakhiyoni a Yaahaya na mafwarizeewu eetta ofuka. Atthu akina khunteela Yinsa khusala amuuzela yoori: “Mwaasa aya niini anakhiyoni a Yaahaya na amafwarizeewu ofuka, khi awo ahifukaka?” ");
INSERT INTO eko_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yinsa khujipu yoori: “Enretteya toovi ofuka anamalaleyiwa harusi, namaposa ari attaapho? Khinwaheya, ari vamote na yo.” ");
INSERT INTO eko_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ila onteela ofiya siikhu mposi anteelaaye olaziwavo, siikhu zaya epo, anlawa afuke. ");
INSERT INTO eko_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Khina antthaaye yaapa pheeya kuwo yoovutta, maana yaapa etile pheeya enttela ofutthela kuwo yoovutta etepe othaala. ");
INSERT INTO eko_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Khina antthaaye viinyu nttompwiyo ya shapala ya raku, amana aretta, viinyu entta ophutula ttompwiyo, waaza viinyu mpakha ttompwiyo zintta oharipweya. Ila mwitthe viinyu pheeya nttompwiyo ya shapala pheeya. ");
INSERT INTO eko_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Saapatu moote, Yinsa eetta ovira nshini wa nshapa la tiriku. Eettaka olawa, anakhiyoni awe khwaaza ovulula phunje zaya. ");
INSERT INTO eko_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mafwarizeewu khumuuzela Yinsa yoori: “Oniwoona, mwaasa aya niini yo arettaka etthu enkhattaziwaaye orettiwa saapatu?” ");
INSERT INTO eko_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ye khuwaajipu yoori: “Mweeyo khamwinasome etile arettiyeeyo Daawuuda wakathi ye na ashirikha awe aakholiweeyo ti jala? ");
INSERT INTO eko_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Wakathi wa haakhimu nwulu wa tiini Apiyataari, Daawuuda aaviriye Nnyupa wa Nluku khurafuna phaawu enkhiweeyo Nluku na khuwenkha ashirikhaawe, aariina ruhusa ya orafuna paasi aari anamalokozela a tiini.” ");
INSERT INTO eko_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aphano khuwooza yoori: “Saapatu yatiisiwa mwaasa wa anaatamu, ama anaatamu mwaasa wa saapatu. ");
INSERT INTO eko_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Etthiipo, Mwaana wa Pinaatamu ti Mbwana hatha na Saapatu.” ");
INSERT INTO eko_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yinsa khurutela theenya nsinakooka, nttumphule aarimo mwinyi waarakaliyeeyo nkhono awe. ");
INSERT INTO eko_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Atthu akina aari weekesa nanna ya onlokoveza Yinsa, yoori amoone nkhama aari weettela ovonisa siikhu ya saapatu. ");
INSERT INTO eko_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yinsa khumuuza mwinyi otule woorakala nkhono yoori: “Olankhe ote vakatthi apha.” ");
INSERT INTO eko_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Aphano Yinsa khuuzela yoori: “Niini entakheliwaaye orettiwa saapatu, oretta yooshapweya ama yootakhala, wuusuru ama wuula?” Ila atthu apale nalelo khwiiya oonyamala. ");
INSERT INTO eko_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yinsa khusala aweekesa ari wookatipukha na khuhituveliwi mwaasa wa wuuma rooho zaya na khumuuza mwinyi otule yoori: “Wookole nkhono awo.” Ye khookola nkhono awe na khwiiya woovonisiwa. ");
INSERT INTO eko_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Aphano mafwarizeewu apale khulankha na khwaaza owaza shawuri vamote na khuntti ya Herooti eekesaka nanna ya omuula Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yinsa na anakhiyoni awe, khulawa mpakha ontthatta la Kalileya na nyumani wawe yaari ota khuntti khuluyeene ya nti wa Kalileya. ");
INSERT INTO eko_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Wakathi asiiliyeevo vitthu zooshi aari orettaazo, atthu awaatta aari olankhaaye Yudeya, Yeruzaleemu, Itumeeya, akina akaapu wa muuttho Yorotaani na apale a Tiiro na Sitooni khuta okutthanana ye. ");
INSERT INTO eko_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Mwaasa wa khuntti khuluyeene etile, Yinsa khuwooza anakhiyoni awe yoori antthekezele mwaatiya yoori awerawere ophunyiwa. ");
INSERT INTO eko_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Maana ye awaavonisiye atthu awaatta, khwa nanna ya apale aari olwaaziwaaye aari ofiyelelaaye osukhumana yoori apatthe onsapa. ");
INSERT INTO eko_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Theenya masheethwani, amana amoona eetta onkokhorela omaasho wawe na onyakula araka: “Weeyo o Mwaana wa Nluku.” ");
INSERT INTO eko_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ila ye aari owenkha oruma wookhomaala yoori ahinlupe paani yaya. ");
INSERT INTO eko_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yinsa khuwela vakulu na khuwaakhuwela apale aari owaatakhaaye, apo aya khuta aphale aariivo. ");
INSERT INTO eko_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Khuwaathawula khumi na awiri na khuwenkha nzina la maaswihaapa yoori eeye vamote na-ye na yoori ye awaarume olaleya, ");
INSERT INTO eko_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na eeyane owahi wa wiikara masheethwani. ");
INSERT INTO eko_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Apa pi apale khumi na awiri awathawuliyeeyo aari witthiwaaye yoori: Simawu, otule amwinkhiyeeyo nzina la Pheeturu; ");
INSERT INTO eko_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Tiyaaku, mwaana wa Zepeteewu, na Yaahaya ttwiiye, atthaapo aatthajiweeyo nzina la Buneerije, liriina maana a “Aana a Ottitthima”; ");
INSERT INTO eko_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Antere, Filiipe, Barutulumeewu, Matewuzhu, Tome, Tiyaaku, mwaana wa Alufeeyu, Tadeewu, Simawu Zelooti; ");
INSERT INTO eko_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yuuda Eshikariyoote, otule ankholisiyeeyo Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Aphano, ye khulawa owawe, khukusanyeya opheya khuntti khuluyeene, khwa nanna ye na anakhiyoni awe aari woojelaavo oja. ");
INSERT INTO eko_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Wakathi ajamaaze asiiliyeevo vitthu epile, khulankha khusala alawa onthuulawo, maana aari olupa yoori: “Ye eetta ovevereya.” ");
INSERT INTO eko_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Anamanozela a kano aalankhiyeeyo Yeruzaleemu aari olupa yoori: “Ye ti wooshinttiwa ti Epiliisi! Mfwalume wa masheethwani ti othuuto aniweekaranaaye masheethwani.” ");
INSERT INTO eko_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Aphano Yinsa khuwaakhuwela khusala awaanozela nkatthi wa milikaniso yoori: “Nanna-ni Epiliisi antakhaaye omwiikara Epiliisi? ");
INSERT INTO eko_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Amana ofwalume mmote ojaawanya, khunwahi ojishintta otthuuporu. ");
INSERT INTO eko_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ama nyuupa amana ejaawanya, theenya khinwahi wiikhala ethiitoru. ");
INSERT INTO eko_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Na Sheethwani nkhama ontta ojuumanana, na amana aawanyeya, khanlawa owahi wiiyavo na wafiya mwiisho wawe. ");
INSERT INTO eko_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Weekhweele khina anwahaaye ovira nnyupa wa ntthu wookhomaala na khuthuula maali zawe aheetteeni onfuka khapula. Toowo ti anwahaaye omwiiyela nnyupa mwawe. ");
INSERT INTO eko_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Miiyo kiniwuuzani khweele yoori: Twampi zooshi na okufuru wooshi wa anaatamu onlawa waswaamihiwe, ");
INSERT INTO eko_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ila otule ankufurwelaaye Rooho Ttakatthiifu, khana nswammaha mileele, maana ona twampi ya mileele.” ");
INSERT INTO eko_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yinsa aalupiye mattakhuzi apa mwaasa wa yo aari olupa yoori: “Ona sheethwani.” ");
INSERT INTO eko_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Elottelanaka, mamaawe na attwiize Yinsa khuta. Khwiiya vaje na khuruma okhuweliwa Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Aarivo atthu awaatta eekhaliyeeyo aphale aariivo, na khuuziwa yoori: “Mamaawo na attwiizo ari vaje apho antta oweekesa.” ");
INSERT INTO eko_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yinsa khuuzela yoori: “Maama ti tuuvi, wala ttwiiyaku ti tuuvi?” ");
INSERT INTO eko_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Aphano khuweekesa apale eekhaliyeeyo aphale aariivo na khuwooza yoori: “Apha owaapho maama na attwiizaku! ");
INSERT INTO eko_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Otule anrettaaye matakhelo a Nluku, ti eeyiye ttwiiyaku, nlupwaaka na maama.” ");
INSERT INTO eko_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yinsa khurutela osomisa kharipu ya ntthatta. Khutavo atthu awaatta aphale aariivo, khusala ahithajiya weetta nkalawa na eekhale nttumpho. Kalawa yaari mpahari, atthu ooshi khwiikhala nshini wa pahari. ");
INSERT INTO eko_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ye aari owaasomisa vitthu zawaatta nkatthi wa nlikaniso, asomisaka khuri: ");
INSERT INTO eko_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mwisiile! Namalima khulawa ozala. ");
INSERT INTO eko_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wakathi aari ozalaavo peewu, phantte kiina khukwela nshini wa tarikhi anyannyi khuta khuja. ");
INSERT INTO eko_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kiina khukwela vahali aariivo mawe, vahali laarivo nttophe vattitthiiru; nasaapiru khoottha, maana nttophe ntthile khaleechiye. ");
INSERT INTO eko_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Aphano noopuwa njuwa khulukuza; maana khazaarina mitathaari, khuuma. ");
INSERT INTO eko_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Peewu kinoko khukwela vanyiiwa, khuwula vamote na nyiiwa, khurapeliwa pi nyiiwa, khwa nanna zahawahiyeeyo wiima mishumo. ");
INSERT INTO eko_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kiina khukwela vanshaka wooshapweya, khoottha, khuwula na khwiima mishumo zooshwapweya, talaathiini, siithiini na mpakha miiya wakhula mmote. ");
INSERT INTO eko_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yinsa khwiishela alupaka yoori: “Otule ariina mashiilo, ti asiile!” ");
INSERT INTO eko_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wakathi ye aari otthwe, anakhiyoni apale khumi na awiri na akinoko aari kharipu ya attaaphale khumuuzela monkoni wa nlikaniso. ");
INSERT INTO eko_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ye khuwooza yoori: “Mweeyo mwenkhiwa ojuwa kano za ofwalume wa Nluku, ila apale ari oje, zooshi anuuzaniwa nlikaniso, ");
INSERT INTO eko_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","yoori ‘hatha nkhama oona ahijuwe, hatha nkhama asiila ehiweeleye yoori ahizukulise rooho zaya aswaamihiwa!’” ");
INSERT INTO eko_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Aphano Yinsa khuwoozela yoori: “Mweeyo khuniweeleyani nlikaniso opu, nanna-ni onteela oweeleyani epi mikina? ");
INSERT INTO eko_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Namazala onzala nttakhuzi. ");
INSERT INTO eko_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Atthu akina ari nkhama peewu eriiye nshini wa tarikhi, nhali lizaliweemo nttakhuzi. Paata ya osiila, Epiliisi onta, khulazavo nttakhuzi ntthile nroho mwawe. ");
INSERT INTO eko_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Akina, ari nkhama peewu ezaliweeyo vahali wawiiyavo mawe, ansiilaaye nttakhuzi nasaapiru khupwekherela na furaha. ");
INSERT INTO eko_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ila paata ya wakathi vattitthiiru, atthu aya apo anlawa akatthale hapari maana kharetteeni wiiya nchina laya, amana ziwaapattha tafwawuthi ama lupattha mwaasa wa mattakhuzi apale antta wanswi. ");
INSERT INTO eko_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Theenya akina anlattanana na peewu ezaliweeyo vakatthi wa mwiiwa. Apo ansiila hapari, ");
INSERT INTO eko_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ila, amana ziwaapuwelelaka tafwawuthi za olumwenku opu, tuvela za maali na otakha nkina, vitthu zaya epo enshawa nttakhuzi na epo zaya khaziniimisa mishumo. ");
INSERT INTO eko_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Awaapho theenya atthu akina, anlikananaaye peewu ezaliweeyo nti wooshapweya. Apo aya ansiila nttakhuzi khukhupalela na khuttheerisa talaathiini, siithiini na mpakha miiya khwa etile aazaliyeeyo.” ");
INSERT INTO eko_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ye khuwooza yoori: “Paani ankhozaaye khantteya yawe khuttha n'yuuku ama nlivuku? Olikha toowo khampweha vahali wawooneyavo? ");
INSERT INTO eko_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Maana khayiivo hatha etthu moote ya siiri, ehinttelaaye wiiya payana na khayiivo moote yoovithiwa ehinttelaaye ovitthuliwa. ");
INSERT INTO eko_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nkhama ntthu onaaye mashiilo oosiila, asiile!” ");
INSERT INTO eko_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Aphano, khuwooza yoori: “Phoole na epile mwinsiilaaye. Na mphimo otthuupo mwinttelaaye owaaphimela azeenu, mwinttela ophimeliwa otthuupo, na theenya mwinkeene mwinlawa mweekezeliwe. ");
INSERT INTO eko_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Otule ariina, onlawa eekezeliwe; ila otule ahina hatha etile vattitthiiru ariinaaye ontta onyakanyiwa.” ");
INSERT INTO eko_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ye khurutela olupa yoori: “Ofwalume wa Nluku ori nkhama ntthu anzalaaye peewu yawe vathi. ");
INSERT INTO eko_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Hatha nkhama eetta olankha, ama hatha nkhama eetta olala, yo zinoottha na zinwula, ye woohijuwi nanna erettikhaniyeeyo. ");
INSERT INTO eko_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Otthuupo oniima mishumo zaya: yamwanzo nyaani, elottelanaka ntathi, mwiisho, phunje zawiitaala va ntathi. ");
INSERT INTO eko_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Amana peewu ekhomaala, ntthu onttela othuula eesu, maana wafiya wakathi wa wuurula.” ");
INSERT INTO eko_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yinsa khurutela olupa theenya yoori: “Ofwalume wa Nluku onlattanana niini? Nlikaniso-ni ninttelaaye orumeyela yoori nithoonyeze? ");
INSERT INTO eko_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ori nkhama phunje ya samuli, etile yiiyiye phunje yootepa opushuwa vathi apha. ");
INSERT INTO eko_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ila, paata ya ozala, zintta owula channu, zayita mathapa ooshi.” ");
INSERT INTO eko_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Khwa milikaniso zooshi zoolattana, Yinsa aari owooza monkoni wa nttakhuzi, nanna aari owahaaye oweeleya. ");
INSERT INTO eko_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Khaari owooza hatha etthu ahirumeyeleeni nlikaniso, ila amana eeya na anakhiyoni awe paasi, eetta owoozaka zooshi. ");
INSERT INTO eko_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Siikhu etile, weettelaka oripa, Yinsa khuwooza anakhiyoni awe yoori: “Nlaweni kaapu kiina.” ");
INSERT INTO eko_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Paata ya osusa khuntti etile, yo khupakhira nkalawa mphule aariimo Yinsa. Na kalawa kiina zeetta owaaperekha. ");
INSERT INTO eko_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Khwaaza ovuma pheevo yookhomaala, na mawipi khusala apiya kalawa yaya khwa nanna aari wiitaalaamo maati. ");
INSERT INTO eko_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yinsa aarettiye eettaka olala sheezi aphiteeziye nsaawu. Aphano anakhiyoni awe khunlansa na khumuuza yoori: “Mwaaliimu, khinuujali fweeyo nifwaka?” ");
INSERT INTO eko_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yinsa khulankha khunyamaza pheevo na khuuza pahari yoori: “Otthe nreke! Onyamale!” Pheevo khunyamala na zooshi khwiiya zawiitthaala. ");
INSERT INTO eko_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Aphano khuwoozela anakhiyoni awe yoori: “Mwaasa aya niini moovaka toowo? Nalelo khamwina amini?” ");
INSERT INTO eko_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Anakhiyoni apale ari awoova channu, khusala oozana yoori: “Ti paani otu aya, anshututeliwaaye ti pheevo na pahari?” ");
INSERT INTO eko_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yo khulokha pahari, khufiya Jerazeenu. ");
INSERT INTO eko_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Wakathi Yinsa apakhuwiyeevo nkalawa, mwinyi mmote aariina sheethwani khusaruwa nvilalo khuta attaaphale. ");
INSERT INTO eko_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mwinyi aya oto aari wiikhala nvilalo, khina mmote aari owahaaye onkhola, hatha ari ntthentte. ");
INSERT INTO eko_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Maana swaafu zawaatta aari wiiya ntthentte moolu awe na makhono awe, ila ye eetta opwechaka tthentte yaya na ovuja zuuma zaari otthiwaaye mmoolu mwawe. Khaarivo ntthu wookhomaala aari owahaaye onshintta. ");
INSERT INTO eko_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Osikhu na nthana ye aari weettettaka nvilalo na nnyaako na ojishija na mawe. ");
INSERT INTO eko_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Wakathi amooniyeevo Yinsa ari peetiwene, khutthira khulawa khukokhora omaasho wawe. ");
INSERT INTO eko_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Khukhuwa na huula yawe yooshi araka: “Onikitakhelani miiyo, Yinsa mwaana wa Nluku Nwulu? Kinuuvekela khwa Nluku yoori ohikoopopise!” ");
INSERT INTO eko_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Maana Yinsa aamuuziye yoori: “Oleemo mmwiili wa mwinyi otu, sheethwani.” ");
INSERT INTO eko_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aphano Yinsa khumuuzela yoori: “Nzina lawo enriwa paani?” Khujipu yoori: “Nzina laka enriwa khuntti, maana niri awaatta.” ");
INSERT INTO eko_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Khusala anvekela wonkhanyarelavo yoori ahiwaarume olaamo mmuti mwaya mphule. ");
INSERT INTO eko_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Liphanko liwululene la kuluwe laari oshukisiwaaye kharipu ya mwaako. ");
INSERT INTO eko_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Masheethwani apale khusala anvekela Yinsa yoori: “Onirume yoori neette nkuluwe mphule.” ");
INSERT INTO eko_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yinsa khwinkha ruhusa masheethwani apale, khusaruwa khweetta nkuluwe. Liphanko laarina thamani ya alufu piiri za kuluwe, khwaaza otthira zilankhaka omwaako ziishukhelaka mpahari, zooshi khuzama khufwa. ");
INSERT INTO eko_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Apale aari oshukaaye kuluwe zaya epile, khutthira khulawa olupa vitthu epile zaarettikhaniyeeyo waaza nsitati mpakha mmashapa, atthu khulankha olawa woona epile zaarettikhaniyeeyo. ");
INSERT INTO eko_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Wakathi amwaattamiyeeyo Yinsa, khumoona mwinyi otule aamwitaliyeeyo masheethwani awaatta, eekhaliye awaliye saana na atthiiyemu akhili zawe, atthu apale khwiiya awoova. ");
INSERT INTO eko_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Apale aari attaaphale, khuwooza atthu zooshi epile zanrettikhaneliyeeyo mwinyi otule aariina masheethwani, na theenya khulupa monkoni wa kuluwe. ");
INSERT INTO eko_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Aphano atthu apale khusala anvekela Yinsa yoori aleemo mmuti mwaya mphule. ");
INSERT INTO eko_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Wakathi Yinsa aari owelaaye nkalawa, mwinyi otule aariina masheethwani khunvekela Yinsa yoori anlikhe alawe na ye. ");
INSERT INTO eko_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yinsa khuhinkhupaleli, ila khumuuza yoori: “Olawe owawo wawuuze ajamaazo zooshi epile Mbwana ooretteliyeeyo na tthakaraka awooneliyeeyo.” ");
INSERT INTO eko_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Aphano, mwinyi otule khulawa na khwaaza olupa nti wa Tekapoliishi etile Yinsa anretteliyeeyo. Atthu ooshi khwiiya ooshanka. ");
INSERT INTO eko_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yinsa khupakhira theenya nkalawa alokhelaka kaapu kiina, khuntti khuluyeene khuta khwiitaala aphale aariivo Yinsa nshini wa nttima. ");
INSERT INTO eko_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Aphano khuta attaaphale namalokozela mmote wa nsinakooka aari wiitthiwaaye Yaayiru, amooniyeevo Yinsa, khukokhora nshini wa moolu awe. ");
INSERT INTO eko_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Khunvekela wookhanyarelavo yoori: “Mwanaka wankha onsaleela ofwa! Safwatali ote, wanttheele makhono yoori eeye woovona na eeye haayi. ");
INSERT INTO eko_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yinsa khusala alawa vamote na-ye, khuntti khuluyeene khusala enlotta na omphunya. ");
INSERT INTO eko_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Attaaphale, aarivo muukha aariina nyaakha khumi na miwiri eettaka ohoowa mwaasa wa omwiittikha taamu. ");
INSERT INTO eko_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ye ahoowiye channu khwa oweekesa anamavonisa na khuharipu nzurukhu awe wooshi aariina, olikha ovona khusala eetta wootepa. ");
INSERT INTO eko_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Asiiliyeevo ovuwa wa Yinsa, khuta nyuma wawe vahali wawaattiwavo na khusapa ajapi yawe. ");
INSERT INTO eko_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Maana aari wuupuwela yoori: “Miiyo kisaparu paasi ajapi yawe, kintta ovona.” ");
INSERT INTO eko_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nasaapiru yeetta olikha wiittikha taamu etile na muukha otule khoona yoori mmwiili mwawe aari wootaphuliwa ohoowa opule. ");
INSERT INTO eko_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Wakathi otthuupule, Yinsa khoona yoori wansaruwa owahi, khuzukuluwa khweekesa khuntti etile khuuzela yoori: “Paani asapiyeeyo ajapi yaka?” ");
INSERT INTO eko_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Anakhiyoni awe khujipu yoori: “Woonaka khuntti khuluyeene eti ekusanyeyiyeeyo, khusala wuuzela yoori: ‘Paani akisapiyeeyo?’” ");
INSERT INTO eko_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ila Yinsa nalelo khusala eekesaka vakatthi wa khuntti etile yoori amoone otule aarettiyeeyo etthu yaya etile. ");
INSERT INTO eko_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Aphano muukha otule, ajuwiyeevo etthu yaarettikhaniyeeyo, khumwaattama khukokhora nshini wa moolu awe eettaka othukumela mwaasa wa woova, khulupa haakhi yooshi. ");
INSERT INTO eko_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yinsa khumuuza yoori: “Mwanaka, amini yawo yoovonisa. Olawe na heeri, na wiiye wootaphuliwa ohoowa wawo.” ");
INSERT INTO eko_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nalelo Yinsa eettaka ottakhula, khutavo atthu a owawe Yaayiru, namalokozela wa nsinakooka khumuuza yoori: “Mwanawo afwa. Khinihithajiya onwuti theenya Mwaaliimu!” ");
INSERT INTO eko_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yinsa khumuuza namalokozela wa nsinakooka mphule yoori: “Ohoove; okhupali paasi.” ");
INSERT INTO eko_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Na khuhinlikhi hatha ntthu onlotta, woohiiyi Pheeturu, Tiyaaku na Yaahaya ttwiiye Tiyaaku. ");
INSERT INTO eko_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wakathi afiiyeevo owawe namalokozela wa nsinakooka, Yinsa khoona tafwawuthi na atthu eettaka olila na ojiliza na huula ya onyakula. ");
INSERT INTO eko_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yinsa khuvira nnyupa na khuuzela yoori: “Tafwawuthi yaya eti ti-ya niini na mwinjilizelani? Mwaana khafweeni, ontta olala.” ");
INSERT INTO eko_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ila ooshi khwaaza ontheya Yinsa. Ye khurumisa yoori aleemo ooshi, khunthuula papaawe na mamaawe mwaana na anakhiyoni awe apale aariina na khulawa aphale aariivo mwaana. ");
INSERT INTO eko_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Khunkhola nkhono awe khuri: “Talitha cumi!” liriina maana a “Mwanankha, miiyo kinuuruma yoori olankhe!” ");
INSERT INTO eko_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nasaapiru mwanankha otule, aariina hirimu ya nyaakha khumi na miwiri, khulankha na khwaaza weettetta. Ooshi aariivo khwiiya ooshanka. ");
INSERT INTO eko_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ila Yinsa khuwooza woosileyavo yoori: Ahiiyevo hatha ntthu anttelaaye ojuwa, na khuruma winkhiwa etthu-yoojiwa. ");
INSERT INTO eko_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yinsa khulaawo okhule waya, khweetta sitati ya owawe, anakhiyoni awe khusala amperekha. ");
INSERT INTO eko_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Noofiya saapatu, khwaaza osomisa nsinakooka, awaatta aari onsiilaaye khwiiya ooshanka, alupaka yoori: “Zininlankha vayi vitthu zaya epi?” ‘Ojuwani opu enkhiweeyo? Na onretta toovi minjuza? ");
INSERT INTO eko_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Khahiyo kalapinteero otu, mwaana wa Mariyamu, ttwiiye Tiyaaku, Yuusufu, Yuuda na Simawu! Alupuwe khari nttumphu!” Khwiiya awiiphiriwa ti Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yinsa khuwooza yoori: “Mmuti mwawe, vakatthi wa ajamaaze na vaje vawe pi attaapho napiyu ahinshitahiwaavo.” ");
INSERT INTO eko_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ye khawahiye oretta minjuza Nazareeti, woohiiyi owaavonisa alwele akina khwa owaattheela makhono. ");
INSERT INTO eko_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Khwiiya wooshanka mwaasa wa othowawo amini okhule waya. Yinsa khuvira asomisaka miti zaattameliyeeyo ottuukhule. ");
INSERT INTO eko_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Khuwaakhuwela anakhiyoni awe apale khumi na awiri, khuwaaruma awiri khwa awiri na khuwenkha owahi wa wiikara masheethwani. ");
INSERT INTO eko_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Khuwaaruma yoori: “Mwihithuule hatha etthu, yohiiyi pakhora, khamwaarina ya othuula etthu-yoojiwa wala kaapiyaka wa safwari na nzurukhu. ");
INSERT INTO eko_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mwiwale jampali, ila mwihithuule nkhumi wa phiiri. ");
INSERT INTO eko_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Amana mwifiya nyuupa moote, mwiiye attaapho mpakha siikhu mwinttelaaye olaavo. ");
INSERT INTO eko_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na miti mikinoko amana zihuupwekhereleni na khuhuusiilini, mwitathe lifufu la mmoolu mwenu mwilaakamo, nkhama oshaahiti vakatthi vaya.” ");
INSERT INTO eko_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yo khulawa na khulaleya atthu yoori athupwiye. ");
INSERT INTO eko_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yo aari wiikara masheethwani awaatta na owaavaaza mafuttha mmwishwa mwaya na owaavonisa alwele awaatta. ");
INSERT INTO eko_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mfwalume Herooti khusiila elupiwaka hapari epile, maana nzina la Yinsa laajuwiwe saaneene. Atthu akina khwaaza olupa yoori: “Yaahaya Namoosa eetta osisimuwa muufwa! Tiito zinrettikhanaaye minjuza zootikinisa khwa ye.” ");
INSERT INTO eko_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Akina aari olupa yoori: “Ye ti Aliyaasi.” Akinoko khusala olupa araka: “Ye napiyu, nkhama manapiyu apale a raku.” ");
INSERT INTO eko_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ila Herooti wakathi asiiliyeevo vitthu epile, khuri: “Yaahaya, mwinyi kinshijiyeeyo, asisimuwa muufwa!” ");
INSERT INTO eko_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Maana Herooti aarumiye yoori akholiwe Yaahaya, afukeliwe nkalapooso, mwaasa wa Herootiiya, muukha wa Filiipe ttwiiye, othuuto anraliyeeyo. ");
INSERT INTO eko_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Mwaasa wa Yaahaya aari omuuza Herooti yoori: “Khahi halaali weeyo onrala muukha wa ttwiiyo.” ");
INSERT INTO eko_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herotiiya aarina katapu khwa Yaahaya, khusala atakha omuula, ila khuhisala awahi oretta, ");
INSERT INTO eko_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","mwaasa Herooti aari omoova Yaahaya na aari omwiinanela, maana aari ojuwa yoori ye mwinyi wa shariya na ttakatthiifu. Amana ansiilaka, eetta oshanka; khwa etthiipo waari ontuvela onsiila. ");
INSERT INTO eko_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Omwiisho Herotiiya khupattha kiphenyo siikhu ya oretta mwaakha Herooti. Khuretta njampo Herooti na anamalokozela awe awulu, attunkhulu a anajanka na ooshi apale eeyiye afwalume a nti wa Kalileya. ");
INSERT INTO eko_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Wakathi mwaana wa Herotiiya aviriyeeyo khwiina, khuntuvela Herooti na apale awaakharipushiyeeyo. Mfwalume khumuuza mwanankha otule yoori: “Okivekele wakhula etile ontakhaaye kintta owinkha”. ");
INSERT INTO eko_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Khumwaahiti khwa olapha yoori: “Wakhula onikivekelaaye, kintta owinkha, mpakha phantte ya ofwalume aka.” ");
INSERT INTO eko_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mwaana otule khusaruwa khumuuza mamaawe yoori: “Kiveke niini?” Mamaawe khunjipu yoori: “Oveke eeshwa ya Yaahaya Namoosa.” ");
INSERT INTO eko_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nasaapiru mwanankha otule khwaakuva khulawa wa mfwalume khuveka yoori: “Kintakha mwikinkhe nasaapi eeshwa ya Yaahaya Namoosa mparathu.” ");
INSERT INTO eko_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mfwalume khwiiya woohuzunikha channu, ila mwaasa wa olapha opule aalaphiyeeyo na wa apale awaakharipushiyeeyo, khuhiwahi okatthala etile avekeliweeyo ti mwanankha otule. ");
INSERT INTO eko_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nasaapiru khunruma najanka khumuuza ontiisela eeshwa ya Yaahaya Namoosa. Ye khulawa okalapooso, khushija eeshwa ya Yaahaya Namoosa. ");
INSERT INTO eko_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Khuttha mparathu khumwinkha mwanankha otule na ye khumwinkha mamaawe. ");
INSERT INTO eko_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Noosiila hapari epile anakhiyoni a Yaahaya namoosa, khuta khuthuula mwiili awe khulawa khuzikha. ");
INSERT INTO eko_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Maaswihaapa khurutela aphale aariivo Yinsa khumuuza zooshi arettiyeezo na asomisiyeeyo. ");
INSERT INTO eko_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Aarivo atthu awaatta aari otaaye na olaavo, paata ya Yinsa na anakhiyoni awe woona yoori khaarina kiphenyo ya oja. Ye khuwooza yoori: “Mwite nilawe puuro yawiitthaleya navumule vattitthiiru.” ");
INSERT INTO eko_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Aphano yo khulawa nkalawa mpakha puuro yawiitthaliye. ");
INSERT INTO eko_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Atthu awaatta khuwoona alawaka paata ya owaajuwa. Atthu a miti zooshi za ottuukhule, khutthira khufiyawo yo ahinafiye. ");
INSERT INTO eko_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Eeshukhaka nkalawa Yinsa, khoona khuntti khuluyeene ya atthu, khuwoonela huruma, maana aari nkhama pwittipwitthi zoohiina makhampuzi. Aphano khwaaza owaasomisa vitthu zawaatta. ");
INSERT INTO eko_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Weettelaka oripa, anakhiyoni awe khunsusela khumuuza yoori: “Puuro eti ti yawitthaaleya, na waripa. ");
INSERT INTO eko_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Owaamwaze atthu apa yoori alawe mmashapa na miti epile naattamiyeeyo yoori oozanye etthu yoojiwa aje.” ");
INSERT INTO eko_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ila ye khuwaajipu yoori: “Mwiwenkhe mweeyo ena etthu yoojiwa.” Yo khumuuza yoori: “Atthu apa yoori aje, ninhithajiya miiya piiri za nzurukhu wa feeta!” ");
INSERT INTO eko_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yinsa khuuzela yoori: “Mwina phaawu kavi? Mwilawe moone.” Anakhiyoni apale khulawa khoona khujipu yoori: “Ninaaye phaawu thaanu na swi piiri.” ");
INSERT INTO eko_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Aphano, Yinsa khuwaaruma yoori ooshi eekhale, khuntti khwa khuntti va nyaani piishi ");
INSERT INTO eko_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Khuretta etthiipo khwaawanyeya khwa khuntti ya miiya na khuntti ya hamusiini. ");
INSERT INTO eko_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Athuuliyeevo phaawu epile thaanu na swi piiri khweekesa pinkuuni khuparikhiya. Nawiisha khumeya phaawu epile khuwenkha anakhiyoni awe yoori awaawanyeze atthu apale. Theenya khuwaawanyeza swi epile piiri ooshi aya. ");
INSERT INTO eko_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ooshi khuja khurupala, ");
INSERT INTO eko_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","na anakhiyoni khulokotthela khwiitaala khelenke khumi na piiri za nyeenye za phaawu na za swi. ");
INSERT INTO eko_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Atthu aajiyeeyo aari alufu thaanu alume ene. ");
INSERT INTO eko_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Elottelanaka, Yinsa khuwaaruma anakhiyoni awe yoori awele nkalawa alokoze Betezayiita phantte ya kaapu ya ntthatta, wakathi ye asaliyeeyo aleezananaka atthu. ");
INSERT INTO eko_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Paata ya oleezanana, khuwela vakulu yoori alompe. ");
INSERT INTO eko_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Weettelaka oripa, kalawa yaari vakatthi wa pahari na Yinsa aari otthwe vathi. ");
INSERT INTO eko_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ye khuwoona anakhiyoni awe afutthaka kaafi woovelavelavo, maana eetta wiinyula pheevo. Lifwajiri, Yinsa khulawa aphale aariivo eettettaka vatulu wa pahari, khusala asaleela owaavikana. ");
INSERT INTO eko_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Wakathi amooniyeevo eettettaka vatulu wa pahari, khusala amoona nkhama nshitapehe, aphano khusala anyakula. ");
INSERT INTO eko_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Maana ooshi aamoniyeeyo aari oosuthuwa. Ila Yinsa nasaapiru khuwooza yoori: “Mwiminyale! Ti miiyo! Mwihoove!” ");
INSERT INTO eko_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aphano Yinsa khuwela nkalawa khwiiya vamote na anakhiyoni awe, na pheevo khunyamala, na yo khwiiya ooshanka, ");
INSERT INTO eko_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","maana khazaaweleyiye minjuza za phaawu. Rooho zaya zaari zookhomaala. ");
INSERT INTO eko_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Paata ya olokha pahari, khufiya Jenezare, ottuukho khufukelela kalawa yaya. ");
INSERT INTO eko_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Wakathi apakhuwiyeevo atthu khunjuwa Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Yo aari ovira azukulelaka nti wooshi opule, na owaathuula alwele aya va nrepa awaalawanaka ohali aari osiilaawo yoori Yinsa ori ottuukho. ");
INSERT INTO eko_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Wakhula vahali aari weettaawo, mmamuti, nsitati ama mmashapa, aari othuuliwaka alwele na olawaniwa mparasa. Noovekeliwa yoori nenkawu awahi osapa nshaka la ajapi yawe; maana ooshi apale aari osapaaye aari wiiya oovona. ");
INSERT INTO eko_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mafwarizeewu na akina anamanozela a kano alankhiye Yeruzaleemu khukusanyeya na Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Khusala awoona anakhiyoni awe akina eettaka oja na makhono aharaamu, enlupaaye yoori khanaweeni. ");
INSERT INTO eko_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mafwarizeewu na mayaahuuti ooshi khanja ahinaweeni wotwahareshiwavo, alottelaka zowera za attunkhulu a tiini. ");
INSERT INTO eko_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Amana aruti oparasa, khannja ahaazeeni woosa makhono aya khapula. Anthokorela masomi makina a waatta, nkhama woosa pilawuri, mirinki, zoopo za malaatha na moolili. ");
INSERT INTO eko_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Aphano mafwarizeewu na anamanozela a kano khumuuzela Yinsa yoori: “Mwaasa aya niini anakhiyoni awo ahilottelaka zowera za attunkhulu a tiini, khusala aja ahinaweeni?’” ");
INSERT INTO eko_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ye khuwaajipu yoori: “Manaafikhi! Ezaaya ahupiri saaneene monkoni weenu mweeyo nkhama etthiipo yaatikhiweeyo yoori: ‘Atthu apa anikishitahi na malimi, ila rooho zaya ziri peetiwene na miiyo. ");
INSERT INTO eko_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Anikaaputu mahala na ansomisa mwentto wa oruma wa eenaatamu. ");
INSERT INTO eko_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mweeyo mwintarawu mirumo za Nluku na khusala mwilottela zowera za enaatamu. ");
INSERT INTO eko_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yinsa khwiishelana awoozaka yoori: “Mweeyo mwineekesa yoori mwitthe othetekele mirumo za Nluku mwaasa wa oshututela masomi enu! ");
INSERT INTO eko_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Maana Munsa alupa yoori: ‘Onshitahi papaawo na mamaawo,’ na ‘antakhaaye onlaani papaawe na mamaawe ona ya ohukhumweliwa ofwa.’ ");
INSERT INTO eko_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ila mweeyo mwinkhupalela yoori amana ntthu amuuza papaawe ama mamaawe yoori: Wakhula etthu kiniwinkhaanini miiyo zaakha ya omwinkha Nluku,’ ");
INSERT INTO eko_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","khwa nanna eto mwiwerawere ojikhanyarela omwaawuni papeenu na mameenu. ");
INSERT INTO eko_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Toowo mweeyo khamwinttha fwayita nttakhuzi la Nluku, khwa opatilana zowera zinlankhaaye wa paapa khwa aana aya. Na mwinretta vitthu zawaatta nkhama etthiipi. ");
INSERT INTO eko_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yinsa khuwaakharipusha theenya atthu apale khuwooza yoori: “Mwikisiileze mooshi na eweeleyeni epi saana yoori: ");
INSERT INTO eko_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","khina etthu moote ya oje wa pinaatamu enraaye nonvira khunttha oharaamu, ila epile zininlankhaaye nroho mwawe ti eninharamushaaye. ");
INSERT INTO eko_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nkhama ntthu onaaye mashiilo oosiila ti asiile! ");
INSERT INTO eko_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Paata ya owaalikha atthu apale olawa owaya, anakhiyoni khunvekela yoori awooze maana a nlikaniso aya opule. ");
INSERT INTO eko_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yinsa khuwoozela yoori: ‘Kiri na mweeyo khiniweeleyani? Yoori khina etthu moote eninviraaye pinaatamu eninharamushaaye? ");
INSERT INTO eko_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Maana khineetta nroho mwawe, ila mwiijohojoho mwawe, nawiisha khwiitthiwamo.” Khwa etthiipo mattakhuzi apale, Yinsa khutukhuru ottha wiiya halaali vitthu zoojiwa zooshi. ");
INSERT INTO eko_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Khurutela olupa yoori: “Etile eninsaruwaaye pinaatamu ti eninharamushaaye. ");
INSERT INTO eko_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Maana nrooho ti, enlakhaamo zawuupuweliwa zootakhala, oshawi akhapa, wiiya, wuula, ");
INSERT INTO eko_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","oraruwa, okhwiririwa,vitthu zootakhala, ohata, oralana woohiiyi wa halaali, nrima, waapa, ojoona na ololo. ");
INSERT INTO eko_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Zootakhala zooshi zinlankha nroho wa ntthu na piitthiipo zininharamushaaye pinaatamu.” ");
INSERT INTO eko_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yinsa khulaawo okhule waya khulawa phantte ya Tiiro na Sitooni, khweetta nyuupa yaya eto na khaatakhiye ojuwiwa ti ntthu, ila khuhiwahi ojittha sirini. ");
INSERT INTO eko_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ila nasaapiru muukha mmote, aarina mwanawe wa nnatti ariina sheethwani, asiiliyeevo monkoni wa ye, khuta khukokhora nshini wa moolu a Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Muukha otule aari nkereeka ya siiro-fineesiya aavokoliweewo, khusala anvekela Yinsa yoori amwikare sheethwani otule aari mmwiili wa mwanawe. ");
INSERT INTO eko_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ila Yinsa khumuuza yoori: “Owaalikhe khapula aana aje arupale. Khahi yoolotteya othuula phaawu ya aana khuwenkha anapwa.” ");
INSERT INTO eko_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Muukha otule khujipu yoori: “Khweele, Mbwana aka, ila hatha anapwa, annja tathela vathi wa meeza eniwaakwaayo asimaana. ");
INSERT INTO eko_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Aphano ye khumuuza yoori: “Mwaasa wa nanna ojipwiyeezo, weeyo, etta; sheethwani ansaruwa mwanawo.” ");
INSERT INTO eko_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Muukha otule khurutela owawe na khunsikana mwanawe arapaleliye voolili, sheethwani otule anlikhiye. ");
INSERT INTO eko_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Elottelanaka, Yinsa khulankha mmuti mphule wa Tiiro na khulokha Sitooni mpakha ntthatta la Kalileya nti wa Tekapoliishi. ");
INSERT INTO eko_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Aphano khutiiseliwa mwinyi mmote woohisiili na wookukuma, khunvekela yoori anttheele makhono ye. ");
INSERT INTO eko_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yinsa khunlazavo vakatthi wa atthu apale awaatta na khunttha zaala omashiilo wawe. Elottelanaka khutthema na khusapa nlimi la mwinyi aya otule. ");
INSERT INTO eko_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Aphano khweekesa otulu, khwiittha phuumu na khumuuza mwinyi otule yoori: “Efata” enlupaaye yoori: “Ofunule.” ");
INSERT INTO eko_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Wakathi otthuupule mashiilo a mwinyi otule khufunuwa na nlimi lawe khuveya, ye khwaaza ottakhula woohiina tafwawuthi. ");
INSERT INTO eko_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yinsa khuwooza yoori ahimuuze hatha ntthu. Ila olikha toowo, khwa nanna aari owaakhattazaavo, yo aari otepa olaleya. ");
INSERT INTO eko_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Atthu ooshi aari osiilaaye aari wiiya ootikinisiwa channu na khusala alupa yoori: “Ye onretta vitthu zooshi saana, mpakha oniwaattakhulisa apale ohittakhuli na owaasiilisa ananhisiili.” ");
INSERT INTO eko_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ziviriyeevo siikhu vattitthiiru, atthu akina awaatta khukusanyeya vamote na Yinsa. Mwaasa wa atthu apale khaarina etthu yoojiwa, khuwaakhuwela anakhiyoni awe khuwooza yoori: ");
INSERT INTO eko_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kiniwoonela huruma atthu apa, maana ana siikhu ttatthu ari vamote na miiyo na khana hatha etthu yoojiwa. ");
INSERT INTO eko_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Amana miiyo kiwooza olawa owaya najala zaya, yo antta okwa ntarikhi maana akina alankha peetiwene. ");
INSERT INTO eko_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Anakhiyoni awe khujipu yoori: “Vayi khwa puuro eti niriiyo ya wiitthaleya ntthu anwahaaye opattha phaawu zoofiyela oja atthu apa?” ");
INSERT INTO eko_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yinsa khuuzela yoori: “Mweeyo mwina phaawu kavi?” Yo khujipu yoori: “Sapa.” ");
INSERT INTO eko_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ye khuwaaruma atthu apale yoori eekhale vathi. Elottelanaka khuthuula phaawu epile sapa, khunshukhurwela Nluku, khumeya khuwenkha anakhiyoni awe yoori awawanyele atthu apale. Yo khuretta etthiipile, ");
INSERT INTO eko_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aarina theenya swi kiina ttiitthittiitthi, khuthuula, khuparikhiya na khuwooza anakhiyoni awe yoori awawanyele atthu apale. ");
INSERT INTO eko_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Atthu apale khuja mpakha orupala. Na khukusanya nyeenye zaasaliiyeeyo khwiitaala khelenke sapa. ");
INSERT INTO eko_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Aarivo thamani ya atthu alufu nne, khuleezanana. ");
INSERT INTO eko_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nasaapiru khweetta mmwaatiya na anakhiyoni awe khusala alawa nti wa Talimanuuta. ");
INSERT INTO eko_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mafwarizeewu khuta na khwaaza omuuzela Yinsa yoori amoone, na khunvekela alama ya pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ye khusisimira nkatthi-nkatthi na khuri: “Mwaasa aya niini khapila eti evekaka alama moote ya minjuza? Miiyo kinhakikhi yoori hatha alama moote khanlawa winkhiwa.” ");
INSERT INTO eko_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aphano khuwaalikha apale aya, khurutela nkalawa khusala alawa phantte kiina. ");
INSERT INTO eko_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Anakhiyoni apale eettiye osahawu othuula phaawu, aarina phaawu moote paasi nkalawa. ");
INSERT INTO eko_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yinsa khuwooza yoori: “Mwijeekesele na mwiiyane phoole na fwaramento za mafwarizeewu na ya Herooti.” ");
INSERT INTO eko_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yo khusala akheetisana araka: “Mwaasa aya woohiina phaawu.” ");
INSERT INTO eko_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yinsa ajuwiyeevo yoori antta okheetisana, khuwoozela yoori: “Mwaasa aya niini mwinkhetisanaka monkoni wa ohiina phaawu? Nalelo khiniweeleyani wala khamwinsiila? Rooho zenu mweetta wuumisa? ");
INSERT INTO eko_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mweeyo mwinaaye maasho ila Khamwinoona, mwinaaye mashiilo ila khamwinsiila, hatha khamwinfikhiri? ");
INSERT INTO eko_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Wakathi opule kaameyiyeeyo phaawu khuwenkha atthu apale alufu thaanu, khelenke kavi za nyeenye zasaliyeeyo?” Anakhiyoni apale khujipu yoori: “Khumi na piiri.” ");
INSERT INTO eko_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Khi wakathi opule kaameyiyeeyo phaawu sapa yoori kiwenkhe atthu apale alufu nne, zaasaliye khelenke kavi za nyeenye mwaakhupeliyeeyo? Anakhiyoni khujipu yoori sapa. ");
INSERT INTO eko_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ye khuwooza yoori: “Mweeyo nalelo khiniweeleyani?” ");
INSERT INTO eko_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Aphano yo khufiya Betezayiita, atthu akina ottuukhule khuntanela Yinsa ntthu woohooni, khusala anvekela yoori ansape. ");
INSERT INTO eko_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ye khunthuula ntthu otule khunlawana othetekele wa mmuti mphule, khulawa khutthemela mmaasho na khunttheela makhono. Yinsa khumuuzela yoori: “Weeyo onwahi woona etthu?” ");
INSERT INTO eko_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ntthu otule khweekesa otulu khuri: “Kiniwoona atthu anumpuwa nkhama miitthi enttaaye weettetta. ");
INSERT INTO eko_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Theenya, Yinsa khunttheela makhono ntthu otule na khufinikha maasho awe. Aphano maasho awe khufunuwa na khurutela woona zooshi saaneene. ");
INSERT INTO eko_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yinsa khunruma olawa owawe amuuzaka yoori: “Ohivire mmuti.” ");
INSERT INTO eko_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yinsa na anakhiyoni awe khulawa nti waattamananiyeeyo Sezareeya ya Filiipe. Ntarikhi eettaka olawa, khusala awoozela yoori: “Atthu anri miiyo ki paani?” ");
INSERT INTO eko_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Yo khunjipu yoori: “Akina anri weeyo o Yaahaya Namoosa, akina anri o Aliyaasi, akinoko aya anri weeyo ommote wa manapiyu.” ");
INSERT INTO eko_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yinsa khuwoozela yoori: “Khi mweeyo? Mwinri miiyo ki paani?” Pheeturu khujipu yoori: “Weeyo o Al-Masiihu!” ");
INSERT INTO eko_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yinsa khuwaaruma yoori ahimuuze hatha ntthu monkoni wawe ye. ");
INSERT INTO eko_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Aphano ye khusala owaasomisa araka: Mwaana wa Pinaatamu aarina ya ohoochiwa pi vitthu zawaatta na okatthaliwa pi mahaakhimu a tiini na attunkhulu a tiini, anamanozela a kano na ooliwe, ila siikhu ya ttaatthu asisimuwe. ");
INSERT INTO eko_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ye khulupa woosileyavo monkoni aya opo. Aphano Pheeturu khunkhuwelela othetekele khusala anshowera. ");
INSERT INTO eko_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yinsa khurutela aphale aariivo anakhiyoni awe khusala aweekesa na khunshowera Pheeturu yoori: “Osale nyuma waka, Sheethwani! Weeyo khunuupuwela vitthu za Nluku, ila vitthu za eenaatamu. ");
INSERT INTO eko_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Aphano khuwaakhuwela atthu na anakhiyoni awe khuwooza yoori: “Nkhama ntthu ontakha okilotta, ajikatthale mweenyewe, athuule nsalapa awe akilotte. ");
INSERT INTO eko_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Maana otule antakhaaye wuusuru ohaayi awe ontta omwaashikha, ila otule onimwaashikhaaye ohaayi awe, mwaasa wa miiyo na mwaasa wa hapari zooshapweya ontta wuusurukha. ");
INSERT INTO eko_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ena fwayita-ni ntthu oshintta olumwenku wooshi, mwiisho waya khumwaashikha nafusi yawe? ");
INSERT INTO eko_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ama niini ntthu anwahaaye opatili na nafusi yawe? ");
INSERT INTO eko_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Amana ntthu apatthiwa haaya khwa miiyo na mattakhuzi aka khwa khapila epi zoovonya na za twampi, Mwaana wa Pinaatamu onteela opatthiwa haaya khwa otu aya wakathi anttelaaye ota nsiifwa wa Papaawe na malayikha ttakatthiifu.” ");
INSERT INTO eko_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Khusala alupa theenya yoori: “Kiniwuuzani khweele yoori: Khwa apa ariiye apha, akina khanfwa ahooneeni ofwalume wa Nluku otakha na owahi.” ");
INSERT INTO eko_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ziviriyeevo siikhu sitha, Yinsa khunthuula Pheeturu, Tiyaaku na Yaahaya paasi, khuwaalawana vamwaako woolepa woohiivo hatha ntthu nkina. Attaaphale Yinsa khwiiya woozukulisiwa ettaka omoona. ");
INSERT INTO eko_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kuwo zawe khwiiya zoottakattha nkhama etthu yawaara ameenaatho ahinwahaaye ofula khuttakatthisa nkhama toowo. ");
INSERT INTO eko_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Khuwaapuwelela Aliyaasi na Munsa, khusala attakhulana Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Aphano Pheeturu khumuuza Yinsa yoori: “Mwaaliimu ti yooshapweya wiikhala attaapha. Nintta ojeka heema ttatthu, moote yawo, moote ya Munsa na kiina ya Aliyaasi.” ");
INSERT INTO eko_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pheeturu khaari ojuwa etthu yoolupa, maana yo aari wa woova. ");
INSERT INTO eko_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Elottelanaka khupuwa liwiku khuwaakhutela, na khusiileya huula yaari oraaye: “Otu Mwanaka wompheta waka; mwinsiileze”. ");
INSERT INTO eko_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nasaapiru, wakathi eekesiyeeyo nkerekhere, khuhimooni hatha ntthu nkina theenya woohiiyi Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Eettaka wiishukha vamwaako aphale, Yinsa khuwooza yoori ahimuuze hatha ntthu etile oniyeeyo, mpakha Mwaana wa Pinaatamu asisimuwe muufwa. ");
INSERT INTO eko_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mwaasa opule khuthokorela atthaaporu paasi, khusalana okeetisana maana a “osisimuwa muufwa”. ");
INSERT INTO eko_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Khumuuzela yoori: “Mwaasa wa niini, anamanozela a kano alupaka wiiya yoohithajiya Aliyaasi ota khapula?” ");
INSERT INTO eko_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yinsa khuwaajipu yoori: “Khweele Aliyaasi ona ya ota khapula, amana ata onrutisela opheeya vitthu zooshi. Khi mwaasa aya niini yaatikhiwaka yoori Mwaana wa Pinaatamu ona ya ohoowa channu, okatthaliwa na otarawiwa? ");
INSERT INTO eko_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ila, miiyo kiniwuuzani yoori Aliyaasi ata, yo khunrettela zooshi aatakhiyeeyo nkhama zaatikhiweezo monkoni wa ye”. ");
INSERT INTO eko_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Wakathi afiyeevo aphale aariivo anakhiyoni apale akina, khoona khuntti khuluyeene ewaazukuleliye apale na anamanozela a kano eettaka okheetisana na anakhiyoni. ");
INSERT INTO eko_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Atthu apale paata ya omoona Yinsa, khwiiya ooshanka khutthirela khunchelisa. ");
INSERT INTO eko_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yinsa khuwoozela yoori: “Mwinkhetisana niini?” ");
INSERT INTO eko_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mwinyi mmote aari vakatthi wa khuntti etile khujipu yoori: “Mwaaliimu, miiyo kootisela mwanaka ariina sheethwani aninkhattazaaye ottakhula. ");
INSERT INTO eko_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wakhula vahali aninsikanaavo, ontta onkwisela vathi. Khusala alaza maphovu na owina meeno, na wookowa. Kawaavekela anakhiyoni awo yoori amwiikare sheethwani aya oto, ila yo khuhinkhitiri. ");
INSERT INTO eko_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Aphano Yinsa khujipu yoori: “Oo, atthu oohaamini, mpakha lini kiiyaka vamote na mweeyo? Mpakha lini kuuvilelakani? Mwikitiisele shapu oto.” ");
INSERT INTO eko_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Aphano yo khuntiisa. Wakathi sheethwani amooniyeevo Yinsa, nasaapiru khuntothela mwaana otule ozoromowa woohusutivo khukwela vathi, khwaaza ojuupurusha alazaka maphovu. ");
INSERT INTO eko_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yinsa khumuuzela paapa wa mwaana otule yoori: “Zamwaaza lini epi?” Papaawe mwaana khujipu yoori: “Thanku avokoliwe. ");
INSERT INTO eko_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Swaafu zawaatta, sheethwani oto, ontta onkwisela vamoottho na mmaati yoori amuule. Ila nkhama onwahi oretta etthu, noonele huruma onaawuni.” ");
INSERT INTO eko_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“Onwahi?” Alupaka Yinsa. “Zooshi zinwaheya khwa otule ankhupalaaye.” ");
INSERT INTO eko_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nasaapiru paapa wa mwaana otule khunyakula araka: “Kinkhupali; okaawuni muuhikhupali mwaka!” ");
INSERT INTO eko_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Wakathi Yinsa ooniyeevo yoori khuntti khuluyeene yeettaka okusanyeya, khunsukisa sheethwani araka: “Sheethwani woohittakhuli na ohisiili, miiyo kinuuruma yoori onlikhe na ohinrutele theenya.” ");
INSERT INTO eko_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Sheethwani khunyakula, khunsakhinya woohusutivo khusaruwa, shapu khwiiya nkhama ntthu woofwa, khufiyelela atthu akina olupa yoori: “Afwa.” ");
INSERT INTO eko_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ila Yinsa khunkhola nkhono awe khunlansa, na khwiiya wa weemela. ");
INSERT INTO eko_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Paata ya Yinsa orutela owawe, anakhiyoni awe khumuuzela othetekele yoori: “Mwaasa aya niini nahaakhitireliyeeyo omwiikara?” ");
INSERT INTO eko_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ye khuwaajipu yoori: “Eto oniikareya khwa lompa na ofuka paasi.” ");
INSERT INTO eko_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yo khulaawo okhule aariiwo na khulokhela Kalileya. Yinsa khaatakhiye atthu ojuwa ohali aariiwo, ");
INSERT INTO eko_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","maana eetta owaasomisa anakhiyoni awe na awoozaka yoori: “Mwaana wa Pinaatamu onsaleela winkheleliwa mmakhono wa anaatamu. Yo anlawa amuule, ila siikhu ya ttaatthu onlawa asisimuwe.” ");
INSERT INTO eko_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ila yo khayaaweleyiye etthu aari otakhaaye olupa na eetta woova omuuzela. ");
INSERT INTO eko_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Khufiya Kafwaranaawu. Ari owawe, ye khuwoozela anakhiyoni awe yoori: “Ntarikhi mwaari okheetisana niini?” ");
INSERT INTO eko_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ila yo khuhilupi hatha etthu, maana aari onyakulisana yoori anjuwe paani eeyiyeeyo nwulweene channu vakathi vaya. ");
INSERT INTO eko_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Eekhaliyeevo, Yinsa khuwaakhuwela apale khumi na awiri khuwooza yoori: “Nkhama ntthu ontakha wiiya wa mwanzo, ona ya wiiya wawiishela na eeye karumeya wa ooshi.” ");
INSERT INTO eko_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Khunthuula mwaana mmote khunttha vakatthi vaya, khunkholela nkhono awe na khuwooza yoori: ");
INSERT INTO eko_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Wakhula otule animpwekherelaaye nsimaana nkhama otu, khwa nzina laka, onikipwekherela miiyo, na otule anikipwekherelaaye khanikipwekherela miiyo, ila onimpwekherela otule akiperekhiyeeyo. ");
INSERT INTO eko_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yaahaya khunkhuwela Yinsa khumuuza yoori: “Mwaaliimu, namoona mwinyi mmote eekaraka masheethwani khwa nzina lawo, fweeyo khunlikhisa mwaasa woohiiyi wa khuntti yeetthu.” ");
INSERT INTO eko_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yinsa khumuuza yoori: “Mwihinkhattaze, maana khina anrettaaye minjuza khwa nzina laka, elottelanaka khukittakhula wootakhalavo. ");
INSERT INTO eko_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Maana otule ahiniiphiriwaaye ti fweeyo, ori khwa fweeyo. ");
INSERT INTO eko_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nakatalikha, kiniwuuzani khweele yoori: Otule aniwinkhaanini maati oonywa, koopho moote khwa nzina laka, mwaasa wa mweeyo wiiya atthu a Al-Masiihu, weekhweele khinteela omwaashikha phakari yawe. ");
INSERT INTO eko_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Amana ntthu ankwisa mmote wa apa attiitthi akikhupaliyeeyo miiyo, afwataali weeseleliwa mpahari afukeliwe liwe liwululene mmwisiko. ");
INSERT INTO eko_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Na nkhono awo amana wuukosisa, oshije. Afwataali weetta muuhaayi ori woorakala, ehiiyeeni wiiyana makhono awo mawiri khweetta motthooni, ohali oriiwo moottho ohinzimaaye. ");
INSERT INTO eko_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ottuukho nyunku yaya ehinfwaaye wala moottho aya ohinzimaaye. ");
INSERT INTO eko_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na muulu awo amana wuuthowelelisa, oshije. Afwataali weetta muuhaayi ori woorakala, ehiiyeeni wiiyana moolu mawiri khweetta motthooni, ");
INSERT INTO eko_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ottuukho nyunku yaya ehinfwaaye na moottho aya ohinzimaaye. ");
INSERT INTO eko_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na amana liisho lawo limote luuthowelelisa, olazemo. Afwataali weetta muufwalume wa Nluku na liisho limote paasi ehiiyeeni wiiyana oomawiri ila khweeseleliwa motthooni, ");
INSERT INTO eko_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ottuukho nyunku yaya ehinifwaaye na moottho aya ohinzimaaye. ");
INSERT INTO eko_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Maana wakhula mmote onlawa alukaniwe moottho. ");
INSERT INTO eko_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mwiinyu pi wooshapweya; ila mwiinyu aya amana olikha onyuunya, wala khunrutiseleya! Mwiiye mwiinyu mweeyo ena, na mwiikhale na heeri mmote na nzeenu.” ");
INSERT INTO eko_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Aphano Yinsa khulaavo aphale vaya khusala alawa nti wa Yudeya na phantte kiina ya Yorotaani. Theenya khuntti moote khuta aphale aariivo. Nkhama etthiipo aazowereliyeezo khusala awaasomisa. ");
INSERT INTO eko_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mafwarizeewu akina khunsusela yoori amweeze amuuzelaka yoori: “Halaali nlume omwaasha muukha awe?” ");
INSERT INTO eko_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ye khuwaajipu yoori: “Munsa aruma niini?” ");
INSERT INTO eko_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yo khulupa yoori: “Munsa aninkha ruhusa ya waatikha talakha khumwiikara.” ");
INSERT INTO eko_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yinsa awaajipwaka khuri: Mwaasa wa wuuma rooho, tiito ye oolikheliyeeni oruma opo aatikhiyeeyo. ");
INSERT INTO eko_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ila Nluku omwanzo amumpa nlume na muukha. ");
INSERT INTO eko_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mwaasa wa ethiito, nlume oninlikha papaawe na mamaawe khujikusanya na muukhaawe, ");
INSERT INTO eko_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na oowiiri anretteya wiiya mwiili mmote paasi. Toowo, yo khaniiya awiri, ila oniiya mwiili mmote. ");
INSERT INTO eko_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nakatalikha, etile Nluku akusanyiyeeyo, ahiiyevo anvalulaaye.” ");
INSERT INTO eko_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wakathi Yinsa ari owawe, anakhiyoni awe khumuuzela theenya monkoni wa mattakhuzi atthaapale. ");
INSERT INTO eko_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ye khuwaajipu yoori: “Wakhula otule animwaashaaye muukhaawe na khunrala muukha nkina, ontta oraruwa. ");
INSERT INTO eko_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Muukha naye amana antthira mannawe khuraliwa ti nlume nkina, ontta oraruwa”. ");
INSERT INTO eko_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Atthu akina aari owaatana asimaana yoori asapiwe ti Yinsa, ila anakhiyoni awe eetta owaashoweraka. ");
INSERT INTO eko_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yinsa paata ya woona vitthu epile, khuhintuveli na khuwooza yoori: “Mwiwaalikhe asimaana akiteele miiyo, mwihiwaakhattaze; maana ofwalume wa Nluku pi waya. ");
INSERT INTO eko_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kiniwuuzani khweele yoori: Otule ahimpwekherelaaye ofwalume wa Nluku nkhama nsimaana, khanteela weettamo. ");
INSERT INTO eko_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Elottelanaka, khuwaathuula asimaana, khuwaattheela makhono na khuwaaparikhiya. ");
INSERT INTO eko_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Wakathi Yinsa aari weettelaaye osaruwa, mwinyi mmote khutthira amweettelaka khulawa khunkokhorela na khumuuzela yoori: “Mwaaliimu woosaana, kiretteniini yoori kipatthe ohaayi wa mileele?” ");
INSERT INTO eko_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yinsa khunjipu yoori: “Mwaasa aya niini okiitthaka woosaana? Khaavo woosaana, woohiiyi mmote paasi Nluku. ");
INSERT INTO eko_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Weeyo onjuwa oruma onraaye: ‘Ohuule, ohiraruwe, ohiiye, Ohilupe oshaahiti woovonyeya, ohinhate ntthu na onshitahi papaawo na mamaawo.’” ");
INSERT INTO eko_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mwinyi otule khulupa yoori: “Mwaaliimu, zooshi epo kinshututela thanku oshaapu aka.” ");
INSERT INTO eko_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yinsa khumweekesa na khumpheta. Khumuuza yoori: “Enuusaleela etthu moote. Olawe woozanyise vitthu zawo zooshi, nzurukhu aya owenkhe asikhini na weeyo ontta wiiyana njuju pinkuuni; nawiisha ote okilotte.” ");
INSERT INTO eko_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Paata ya mattakhuzi apale, shapu otule khwiiya woottettheya khulaavo ari woohuzunikha, maana aarina maali zawaatta. ");
INSERT INTO eko_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yinsa khweekesa nkerekhere khuwooza anakhiyoni awe yoori: “Nanna enlipaazo thaajiri weetta muufwalume wa Nluku.” ");
INSERT INTO eko_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Anakhiyoni awe khwiiya ooshanka khwa mattakhuzi apale. Ila Yinsa khurutela olupa theenya yoori: “Aanaaka, nanna enlipaazo weetta muufwalume wa Nluku! ");
INSERT INTO eko_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Eniiya yookhweya Enkamiiya ovira valiphotto la sikano, zayita thajiri weetta muufwalume wa Nluku.” ");
INSERT INTO eko_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Anakhiyoni awe khwiiya ooshanka, khusala oozelana mmote na nzaawe yoori: “Nkhama pi toowo, paani anttelaaye wuusurukha?” ");
INSERT INTO eko_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yinsa khuweekesa khuwooza yoori: “Khwa pinaatamu khinwaheya, ila Nluku wala; khwa Nluku vitthu zooshi zinwaheya.” ");
INSERT INTO eko_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Aphano Pheeturu khwaaza omuuza yoori: “Fweeyo nalikha zooshi yoori nuulotte.” ");
INSERT INTO eko_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yinsa khujipu araka: “Kiniwuuzani khweele yoori: khaavo anlikhaaye vaje vawe, ttwiiye, nlupuwe, mamaawe, papaawe, aana awe ama mashapa awe, mwaasa wa miiyo na hapari zooshapweya, ");
INSERT INTO eko_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ahipwekheraaye venkivene ohaayi otthuupu, swaafu miiya theenya ya manyupa, attwi, alupu, maama, paapa, aana ama mashapa na olupatthiwa. Mwiisho waya ohaayi wa mileele. ");
INSERT INTO eko_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Awaatta eeyiye amwanzo, anttela wiishela; na awiishela anttela wiiya amwanzo.” ");
INSERT INTO eko_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yo eetta owelela Yeruzaleemu, Yinsa khuwaalokoza. Anakhiyoni khwiiya onshanka, na apale aari onlottaaye khwiiya awoova. Theenya Yinsa khuwaakhuwela apale khumi na awiri na khuwooza vitthu zaari weettelaaye onrettikhanela araka: ");
INSERT INTO eko_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Moone, fweeyo ninwelela Yeruzaleemu, mwaana wa pinaatamu onlawa enkheleliwe mahaakhimu a tiini na anamanozela a kano. Yo anttela onhukhumwela ofwa na omwinkhelela mmakhono wa amalapo, ");
INSERT INTO eko_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","anttela onveyisa, ontthemela, onjapha na amuule. Paata ya siikhu ya ttatthu asisimuwe.” ");
INSERT INTO eko_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Aphano Tiyaaku na Yaahaya, aana a Zepeteewu, khumwaattama Yinsa khumuuza yoori: “Mwaaliimu, nintakha yoori oninkhe etthu ninttelaaye wuuvekela.” ");
INSERT INTO eko_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yinsa khuwoozela yoori: “Mwintakha yoori kuuretteleni niini?” ");
INSERT INTO eko_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Khujipu yoori: “Oninkhe ruhusa yoori khwa nsiifwa mwawo, fweeyo neekhale mmote nkhono nlume mmote nkhono nkha.” ");
INSERT INTO eko_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ila Yinsa khuwooza yoori: “Khamwinjuwa etthu mwinvekaaye. Mwinwahi mweeyo onywela koopho etile kinyweliyeeyo ama opwekherela woosiwa opu khoosiweeyo miiyo?” ");
INSERT INTO eko_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yo Khujipu yoori: “Ninwahi.” Yinsa khuwooza yoori: “Mweeyo mwinlawa mwanywele koopho kinyweliyeeyo na mwinlawa moosiwe nkhama khoosiweeyo miiyo; ");
INSERT INTO eko_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ila phantte eto ya wiikhala nkhono nlume aka ama nkhono nkha khahi miiyo kininkhaaye. Maana puuro yaya eto ti ya apale oothokoreliwa.” ");
INSERT INTO eko_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Noosiila vitthu epile, apale khumi khwiiya ookasirikha khwa Yaahaya na Tiyaaku. ");
INSERT INTO eko_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ila Yinsa khuwaakhuwela khwiiya vamote naye, khuwooza yoori: “Mweeyo mwinjuwa yoori apale aninkhiwaaye ofwalume wa olokozela khapila anshintta na owahi ariinaaye. ");
INSERT INTO eko_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ila vakatthi venu mweeyo ehiiye toowo. Otule antakhaaye wiiya nttunkhulu vakatthi venu mweeyo ona ya wiiya othuuto anrumeyaaye; ");
INSERT INTO eko_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","otule antakhaaye wiiya wa mwanzo vakatthi venu eeye namarumeya enu mooshi mweeyo. ");
INSERT INTO eko_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Maana Mwaana wa pinaatamu khateleeni orumeyeliwa, ila orumeya na winkha ohaayi awe khwa owaakaphula atthu awaatta. ");
INSERT INTO eko_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Khweetta Yeriko. Wakathi Yinsa na anakhiyoni awe vamote na khuntti khuluyeene yaari olankhaaye Yeriko Baritimeewu woohooni mwaana wa Timeewu nazimola eettiye wiikhala kharipu ya tarikhi. ");
INSERT INTO eko_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Noosiila yoori Yinsa wa Nazareeti ontta ovira, khwaaza okhuwa araka: “Yinsa, mwaana wa Daawuuda, koonele huruma!” ");
INSERT INTO eko_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Atthu awaatta khusala anshowera yoori eeye woonyamala, ila ye khusala akhanyarela araka: “Mwaana wa Daawuuda, koonele huruma!” ");
INSERT INTO eko_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yinsa khweemela khuri: “Mwinkhuwele.” Khukhuweliwa otule woohooni khumuuza yoori: “Ofurahi, olankhe, Ye ontta wuukhuwela!” ");
INSERT INTO eko_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Khweesela ajapi yawe toole, khwiirukha khweemela khulawa aphale aariivo Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yinsa khumuuzela yoori: “Ontakha yoori miiyo kuurettele niini?” Mwinyi otule woohooni khujipu yoori: “Mwaaliimu, miiyo kintakha woona!” ");
INSERT INTO eko_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yinsa khumuuza yoori: “Olawe! Amini yawo yawuusuru.” Nasaapiru khwaaza woona na khusala anlotta Yinsa ntarikhi mphule. ");
INSERT INTO eko_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Wakathi aattameliyeevo Yeruzaleemu, khufiya Betifwaaje na Betaaniya, kharipu ya mwaako wa oluveera, Yinsa khuwaaruma anakhiyoni awe awiri, ");
INSERT INTO eko_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","khuwooza yoori: “Mwilawe mmuti mpho mwaattameliyeemo, mwifiyaka mwininsikana mwaana wa puuru afukiwe ahinaweliweke ti hatha ntthu. Mwinfukule mwintiise. ");
INSERT INTO eko_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Amana apuwa ntthu awuuzelani yoori: ‘Mwaasa niini mwirettaka vitthu epo?’ Mwinjipu yoori: ‘Mbwana ontta onhithajiya na oninrutisa nasaapi.’” ");
INSERT INTO eko_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yo khulawa khunsikana mwaana wa puuru afukeleliwe, vanlako nwulu wa ntarikhi ya vaje, anfukulaka. ");
INSERT INTO eko_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Atthu aari attaaphale khuwoozela araka: “Eto mwinrettaaye niini ya onfukula mwaana wa puuru oto?” ");
INSERT INTO eko_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Anakhiyoni apale khujipu etthiipile Yinsa awooziyeeyo, na ye khuwaalikha olawana. ");
INSERT INTO eko_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Khuntiisela mwaana wa puuru otule Yinsa, khutthaavo kuwo zawe na khuwela. ");
INSERT INTO eko_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Atthu awaatta khusala attattikha kuwo zaya ntarikhi na akina khusala atthaamo virapi aashijiyeeyo ntthuttu. ");
INSERT INTO eko_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Apale aalokoziyeeyo na apale aari onlottaaye khusala anyakula araka: “Hosaana!” Wooparikhiyiwa ti otule antaaye khwa nzina la Mbwana!” ");
INSERT INTO eko_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Wooparikhiyiwa saana ofwalume ontaaye wa papeetthu Daawuuda!” Hosaana pinkuuni!” ");
INSERT INTO eko_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yinsa khufiya Yeruzaleemu na khulawa mpakha nnyupa woosifwiwamo. Khoona zooshi na wiiya waaripiye, khulawa Betaaniya na anakhiyoni awe apale khumi na awiri. ");
INSERT INTO eko_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mmeesho mwaya, wakathi aari olankhaaye Betaaniya, Yinsa khunkhola jala. ");
INSERT INTO eko_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ari peetiwene, khoona muutthi wa mfikeera wooripelela mathapa, khulawa woona nkhama aari osikanamo nshumo. Wakathi aattameliyeeyo, khuhisikanimo hatha etthu, woohiiyi mathapa, maana khawaari wakathi wa wiima fiiku. ");
INSERT INTO eko_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Aphano khuuza mfikeera opule yoori: “Khina anttelaaye oja theenya mishumo khwa weeyo.” Anakhiyoni awe khusiila alupaka mattakhuzi apale. ");
INSERT INTO eko_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yinsa khufiya Yeruzaleemu, khuvira nnyupa woosifwiwamo na khwaaza oweekara apale aari wuuzanyisaaye na apale aari wuuzanyaaye. Khupwalula khukulu za anamapatilisa nzurukhu na za apale aari wuuzanyisaaye jiwa. ");
INSERT INTO eko_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Khaari ontakhela ntthu oviranamo etthu yawuuzanyisa nnyupa woosifwiwamo. ");
INSERT INTO eko_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Khusala asomisa araka: “Khayaatikhiweeni yoori: ‘Nyuupa yaka enttela wiiya nyuupa yoolompiwamo khwa atthu ooshi ila mweeyo mwarettisa wiiya likurakuza la manantarawu.”’ ");
INSERT INTO eko_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Mahaakhimu a tiini na anamanozela a kano khusiila mattakhuzi apale na khwaaza weekesa nanna ya omuula, maana eetta omoova, mwaasa wa khuntti khuluyeene yaari oshankisiwa pi masomi awe. ");
INSERT INTO eko_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Weettelaka oripa, yo khulaamo nsitati mphule. ");
INSERT INTO eko_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mmeesho mwaya supuyeene, khoona mfikeera opule ori wawuuma mpakha na mitathaari zaya. ");
INSERT INTO eko_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pheeturu khuupuwela na khumuuza Yinsa yoori: “Mwaaliimu! Woone mfikeera opule waalaaniyeeyo wooma.” ");
INSERT INTO eko_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yinsa khunjipu yoori: “Wiiyane amini khwa Nluku. ");
INSERT INTO eko_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Miiyo kiniwuuzani khweele yoori, wakhula otule anttelaaye wuuza mwaako opu yoori: ‘Okhuleyevo apha waajeeselele mpahari,’ na khuhiina hatha nshikili nroho mwawo, ila khukhupalela yoori enrettikhana etile olupiyeeyo, entta oretteya. ");
INSERT INTO eko_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Apho, miiyo kiniwuuza yoori, zooshi weeyo onvekaazo khwa lompa, khukhupalela yoori apwekherela, onteela opattha. ");
INSERT INTO eko_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na amana olompaka, khwiiyana nzaawo okosiyeeyo, onswaamihi, yoori naye Paapa wa pinkuuni oswaamihi twampi zawo. ");
INSERT INTO eko_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ila mweeyo amana mwihiswaamihi, na mweeyo Paapa wa pinkuuni khanswaamihi twampi zenu. ");
INSERT INTO eko_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Khufiya theenya Yeruzaleemu, wakathi Yinsa aari oviraaye nnyupa woosifwiwamo, khususeliwa ti mahaakhimu a tiini, anamanozela a kano na attunkhulu a tiini, ");
INSERT INTO eko_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","khusala amuuzela yoori: “Vitthu epi, onrettana ofwalume waani? Paani awinkhiyeeyo ofwalume wa orettana?” ");
INSERT INTO eko_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yinsa khujipu yoori: “Miiyo kintakha kiwuuzele, amana okijipu, kintta owuuza ofwalume kinrettanaaye vitthu epi. ");
INSERT INTO eko_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nkakuuze, woosa wa Yaahaya waari wa pinkuuni ama waari wa anaatamu?” ");
INSERT INTO eko_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yo khusala anyakulisana araka: “Amana niri ‘ti-ya pinkuuni,’ ontta onuuzela yoori: ‘Aphano mwaasa aya niini mwihinkhupalelaka?’ ");
INSERT INTO eko_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ila nihijilipisane olupa yoori waari wa atthu!” Maana yo aari owoova atthu, weekhweele atthu aari ookhupali yoori Yaahaya aari napiyu. ");
INSERT INTO eko_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Aphano khunjipu Yinsa araka: “Khanijuweeni.” Yinsa zwaamu yawe khujipu yoori: “Hatha vattitthiiru, miiyo akiniwuuzani owahi kinrettanaaye vitthu epi.” ");
INSERT INTO eko_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Aphano Yinsa khwaaza ottakhula na milikaniso yoori: “Mwinyi mmote khuzala miitthi za wuuva, khujekelela khwiiya nkatthi, khuthipa kulaathayini yoori asala atthaamo wuuva na khujeka korofwa. Paata ya toole khurentteriwa anamalima ye khusaafiri. ");
INSERT INTO eko_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wakathi wa wuurula, khunruma karumeya awe khwa anamalima yoori enkhiwe phantte ya mishumo za wuuva. ");
INSERT INTO eko_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ila yo khunkhola khumpiya na khumwiikara woohimwinkhi etthu. ");
INSERT INTO eko_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Aphano khumperekha karumeya awe nkina yo khunvonya khunwozola veeshwa, na khunttukhana. ");
INSERT INTO eko_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Khumperekha theenya nkina khumuula. Khuwaaperekha theenya awaatta akina; khupiiwa na akina khuuliiwa. ");
INSERT INTO eko_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Aari osala mmote yoori amperekhe, mwanawe wompheta wawe. Mwiisho waya khumperekha na khuri: ‘Otu mwanaka antta onshitahi.’ ");
INSERT INTO eko_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ila anamalima apale khuuzana yoori: ‘Otu ti namarithi. Nlaweni nimuule, nirithi fweeyo.’ ");
INSERT INTO eko_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Aphano khunkhola mwaana otule, khumuula khumweeselela oje wa nshapa. ");
INSERT INTO eko_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yinsa khuuzela yoori: “Mweenyewe nshapa onttela owaarettela niini? Ye ontta ota awoole anamalima apale nshapa laya awenkhe anamalima akina. ");
INSERT INTO eko_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Khamwinasome etthu enlupaaye zawaatikhiwa ttakatthiifu? ‘Liwe anamajeka akatthaliyeeyo, nttho laya laretteya wiiya liwe linkhomaazaaye! ");
INSERT INTO eko_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Eto enlankha wa Mbwana na ti yootikinisa khwa fweeyo.’” ");
INSERT INTO eko_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Aphano khwaaza weekesa nanna ya onkhola, maana eettiye ojuwa yoori nlikaniso opule aalupiyeeyo waari owaalupa yo. Ila eetta owoova atthu, attaaphale khunlikha khusala alawa safwari yaya. ");
INSERT INTO eko_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Paata ya toole, khurumiwa mafwarizeewu akina na attunkhulu akina a khuntti ya Herooti olawa ottakhulana Yinsa eekesaka yoori ansikanane nttakhuzi loovonyeya. ");
INSERT INTO eko_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Wakathi afiyeevo aphale aariivo Yinsa khulupa yoori: “Mwaaliimu, ninjuwa yoori o weekhweele na khunjilikha oshawurisiwa ti ntthu. Maana khuniwaaphuka atthu khwa nanna ariizo, ila onsomisa wawaamineyavo tarikhi ya Nluku. Nkanuuze: Halaali onripha lumpuru Seezari ama wala? ");
INSERT INTO eko_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ila Yinsa khumweeleya onaafikhi waya khuwoozela yoori: “Mwaasa aya niini mweeyo mwikootootaka? Mwikitiisele nzurukhu yoori moone.” ");
INSERT INTO eko_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yo khutana nzurukhu opule, ye khuwoozela yoori: “Ratarato eti na waatikha opu pi waani?” Khujipuza yoori: “Seezari.” ");
INSERT INTO eko_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Aphano Yinsa khuri: “Mwimwinkhe Seezari etile yiiyiye ya Seezari, na ya Nluku etile yiiyiye ya Nluku.” Khwiiya onshankela. ");
INSERT INTO eko_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Masatukhi akina, apale anlupaaye yoori khawiivo osisimuwa, khuta aphale aariivo Yinsa khulupa yoori: ");
INSERT INTO eko_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mwaaliimu, Munsa anilikhela zawaatikhiwa yoori, amana afwa ttwi na khunlikha muukhaawe ahinvokoleleeni aana, alooziwe ttwiiye yoori epuwe peewu khwa zwaamu ya ttwiiye. ");
INSERT INTO eko_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Moone, aarivo attwi sapa, otu wa mwanzo khuloola na khufwa ahiwaalikheeni hatha aana. ");
INSERT INTO eko_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Waphiiri khulooziwa muukha otule aafweliweeyo ti mannawe na ye khufwa, woohinlikhi mwaana; na wattaatthu khwiiya etthiipo. ");
INSERT INTO eko_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Etthiipile oosaapa khuhiwaalikhi hatha aana. Mwiisho waya muukha otule na ye khufwa. ");
INSERT INTO eko_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Wakathi woosisimuwa, khwa ooshi apa sapa anttelaaye wiiya muukhawe tuuvi? Maana ooshi anrala!” ");
INSERT INTO eko_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yinsa khuwaajipu yoori: “Mweeyo mwattettekhiwa, maana khamwinjuwa zawaatikhiwa ttakatthiifu wala owahi wa Nluku! ");
INSERT INTO eko_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Pi toono, wakathi woosisimuwa muufwa, khamwinlawa oloola, wala olooziwa, ila mwinttela wiiya nkhama malayikha a pinkuuni. ");
INSERT INTO eko_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mweeyo khamwina some nkithaapu ya Munsa etthu yaatikhiweeyo monkoni wa osisimuwa? Wakathi aari ottakhulaaye va muutthi opule waari okholelaaye, yaatikhiwa yoori Nluku aamuuziye Munsa yoori: “Miiyo ki Nluku wa Eburahiima, wa Esiyaakha na wa Yaakhumpa.” ");
INSERT INTO eko_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Moone, Nluku khahiyo wa ananfwa, ila Nluku wa atthu haayi. Mwattettekheya venkivene. ");
INSERT INTO eko_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Namanozela wa kano mmote noowasiila akheetisanaka khunsusela, ajuwiyeevo yoori ajipu saana, khumuuzela yoori: “Khi oruma wamwanzo khwa zooshi pi puuvi?” ");
INSERT INTO eko_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yinsa khujipu yoori: “Oruma wamwanzo khwa zooshi pi opu: Osiileze, Ezirayiilu, Mbwana Nluku eetthu ti eeyiye Mbwana otthwe paasi. ");
INSERT INTO eko_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Omphete paasi Mbwana Nluku awo khwa rooho yawo yooshi na nafusi yawo yooshi na akhili zawo zooshi na kuvu zawo zooshi. ");
INSERT INTO eko_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Waphiiri pi opu: ‘Omphete nzaawo nkhama etthiipo onjiphetaazo omweenyewe. “Khawiivo nrumo nkina nwulu nkhama opu.’ ");
INSERT INTO eko_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Namanozela wa kano otule khuri: “Kemaani, Mwaaliimu, walupa na haakhi yoori ye mmote paasi, na khaavo nkina woohiiyi ye, ");
INSERT INTO eko_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","na omphete na rooho yawo yooshi na akhili zawo na kuvu zawo zooshi na omphete nzaawo nkhama etthiipo onjiphetaazo ti yooziti zaakha yoolukuziwa na twaha. ");
INSERT INTO eko_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yinsa amooniyeevo yoori ajipu waakhilivo, khumuuza yoori: “Weeyo khuri peetiwene na ofwalume wa Nluku.” Elottelanaka, khuhiivo hatha mmote aari omuuzelaaye. ");
INSERT INTO eko_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yinsa eettaka osomisa nnyupa ya Nluku, khuwoozela yoori: “Anlupa toovi anamanozela kano yoori Al-Masiihu mwaana wa Daawuuda? ");
INSERT INTO eko_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daawuuda aya alupa khwa Rooho Ttakatthiifu yoori: ‘Mbwana amuuza Mbwana aka yoori wiikhale nkhono nlume aka, mpakha miiyo kiwaatthe maatuwi awo vathi wa moolu awo.’ ");
INSERT INTO eko_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daawuuda aya onimwiittha yoori ‘Mbwana’. Toovi anttelaaye wiiya mwaanawe?” Khuntti khuluyeene yaari osiileza wootuveliwavo. ");
INSERT INTO eko_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yinsa eettaka owaasomisa, aari owooza yoori: “Phoole na anamanozela kano. Yo oniwaatuvela weettetta awaliye ajapi zoolepa na opwekherela mwacheliwa vaparasa, ");
INSERT INTO eko_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","owaatuvela wiikhala wiilokozi nsinakooka na puuro zooshitahiwa mmajampo, ");
INSERT INTO eko_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","atthaapo antapanya mmanyupa ananfweliwa pi amannazaya na ojihakikhi khwa oretta lompa zoolepa; apa aya anttela ohoowa khwa ophukiwa woolwaazavo!” ");
INSERT INTO eko_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yinsa eekhaliye waattamela puuro etile eninkhiwaavo zaakha, aari woona nanna khuntti etile yaari otthaamo nzurukhu n'yoopo ya zaakha. Mathaajiri awaatta aari otthaamo wawaatta. ");
INSERT INTO eko_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Khumoona muukha namafweliwa ti mannawe mmote wa masikhini, atthaakamo ttoosu piiri. ");
INSERT INTO eko_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yinsa khuwaakhuwela anakhiyoni awe khusala awooza yoori: “Kiniwuuzani khweele yoori namafweliwa otu ti mannawe atthaamo n'yoopo wa zaakha zayita akina aya. ");
INSERT INTO eko_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Maana ooshi enkha tathela, ila otu na osikhini awe enkha wooshi aari ororomelaaye. ");
INSERT INTO eko_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Wakathi Yinsa aari osaruwaavo nnyupa yoosifwiwamo, nakhiyoni awe mmote khumuuza yoori: “Mwaaliimu nkoona! Maweni mawulweene toono na manyupa ooshapweyisana toono!” ");
INSERT INTO eko_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yinsa khunjipu yoori: “Woona manyupa mawulumawulu apa? Khalinlawa liwe wiiya vatulu wa liwe nzaaya lihinttelaaye opwechiwa.” ");
INSERT INTO eko_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yinsa aarettiye eekhaliye vamwaako Oluveera omaasho wa nyuupa yoosifwiwamo, Pheeturu, Yaakhumpa, Yaahaya na Antere khumuuzela othetekele yoori: ");
INSERT INTO eko_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Onuuze, wakathi-ni enttelaaye orettikhana vitthu zaya epo, na enttela wiiyavo alama-ni yoothoonyeza yoori zooshi zasaleela orettikhana?” ");
INSERT INTO eko_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yinsa khuwooza yoori: “Phoole yoori mwihihatiwe ti hatha ntthu. ");
INSERT INTO eko_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Maana awaatta anta khwa nzina laka alupaka yoori: ‘Miiyo ki Al-Masiihu!’ na aniwaahata atthu awaatta. ");
INSERT INTO eko_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Amana mwisiila viittha ama hapari za viittha, mwihoove maana epo ena zoorettikhana, ila nalelo kinttela wiiya mwiisho. ");
INSERT INTO eko_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Khapila moote enlawa yoomanane khapila kiina, na ofwalume onlawa woomanane ofwalume nkina. Zinlawa zeeyevo visikinyaatthi khwa phantte zoofwarikhana na jala. Epo zaya yaazo ya vitthu za olwaaza. ");
INSERT INTO eko_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Mweeyo mwiiyane phoole, maana mwinlawa mwenkheleliwe wa anamaphuka na mwinlawa mwajaphiwe mmasinakooka, na mwilawaniwe wa misatoro na wa afwalume, mwaasa wa miiyo, yoori mwiiye mashaahiti. ");
INSERT INTO eko_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ila enihithajiya olaleyiwa hapari zooshapweya khapula khwa khapila zooshi. ");
INSERT INTO eko_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Amana mwithuuliwa olawa ofukiwa na ophukiwa, mwihishukulikhe etthu yoolupa, ila ethiito mwinttelaaye winkhiwa wakathi aya otthuupo mwilupe ethiito, maana khahiyo mweeyo mwinttakhulaaye, ila Rooho Ttakatthiifu. ");
INSERT INTO eko_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ttwi mmote onlawa anleve ttwiiye yoori ooliwe, na paapa onleva mwanawe. Aana anlawa awaazukuluwele apapa zaya awoole. ");
INSERT INTO eko_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Atthu ooshi anttela owiinani mwaasa wa miiyo. Ila otule anttelaaye ovilela mpakha mwiisho, ontta wuusurukha. ");
INSERT INTO eko_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Amana moona okufuru wa woopisa wa pala nhali woohifwayi wiiyamo (ansomaaye ti emweeleye), aphano apale anttelaaye wiiya Yudeya atthirele omwaako. ");
INSERT INTO eko_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Otule anttelaaye wiiya vatulu wa nyuupa ahiishukhevo yoori alawe owawe, wala ahivire othuula etthu ya nnyupa mwawe. ");
INSERT INTO eko_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Otule aniiyaaye ntthuttu ahirutele onti yoori athuule juupa yawe. ");
INSERT INTO eko_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ootakhaliwa aakha apale anttelaaye osikaniwa ari awiimittha ama eettaka waamwisa! ");
INSERT INTO eko_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mwinvekele Nluku yoori vitthu zaya epo ehirettikhane mwiita. ");
INSERT INTO eko_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Maana, siikhu zaya epo onttela wiiyavo ohoowa ohineeyekevo thanku Nluku ompe olumwenku, na khunteela opuwa nkina nkhama opo. ");
INSERT INTO eko_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Eriwaka Nluku khaafupheyisiye siikhu zaya epo, khaavo aari weettelaaye wiiya haayi, ila mwaasa wa apale awathawuliyeeyo, afupheyisa siikhu zaya epo. ");
INSERT INTO eko_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Aphano, amana ntthu awuuzani yoori: ‘Al-Masiihu otu ariiye apha!’ ama ‘Moone, otule ari okhule!’ mwihikhupali. ");
INSERT INTO eko_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Maana anlawa apuwe Al-Masiihu oojipanka na manapiyu oojipanka anttelaaye othoonyeza alama na vitthu zootikinisa yoori kusapi awahi owaattettekha ananthawuliwa. ");
INSERT INTO eko_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mweeyo mwiiyane phoole! Miiyo kiniwuuzani zooshi epo zihinarettikhane. ");
INSERT INTO eko_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ila siikhu zaya epo, paata ya pala eto ya ohoowa, njuwa linttela oriipa na mweezi onttela olikha waara. ");
INSERT INTO eko_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Matthottowa akhwe pinkuuni na kuvu ziriiye pinkuuni zinttela osakhinyeya. ");
INSERT INTO eko_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aphano, mwinttela omoona Mwaana wa Pinaatamu mmawiku na owahi nwulweene na siifwa. ");
INSERT INTO eko_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ye onttela oruma malayikha awe khwa phantte nne zooshi za nkerekhere wa olumwenku mpakha nkerekhere ya pinkuuni yoori awaakusanye ananthawuliwa awe. ");
INSERT INTO eko_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Mwijinozele nlikaniso wa nfikeera. Amana virapi zaya zinyoowela na mathapa khwaaza ophutuwela enthoonyeza yoori mwiita ontta waattamela. ");
INSERT INTO eko_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Etthiipo theenya mweeyo, amana moona vitthu epo zeettaka orettikhana, mwijuwe yoori ye ori kharipu ya va milako. ");
INSERT INTO eko_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Miiyo kiniwuuzani khweele yoori khapila eti kinvira vitthu epi zihirettikhaneeni. ");
INSERT INTO eko_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Pinku na vathi zooshi zinteela ovira, ila mattakhuzi aka khanviraru. ");
INSERT INTO eko_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ila monkoni wa siikhu ama wakathi khina anjuwaaye; wala malayikha pinkuuni wala Mwaana, woohiiyi Paapa. ");
INSERT INTO eko_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Phoole, mwiiye woojeekesela, maana khamwinjuwa ofiya wa wakathi aya opo. ");
INSERT INTO eko_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Eri nkhama ntthu anlikhaaye nyuupa yawe khuretta safwari ya peetiwene; ila ahinalawe, khuwaalikhela ofwalume, akarumeya awe wakhula mmote sharuthi yawe, khunruma namweekesela yoori asale aweekeselaka. ");
INSERT INTO eko_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Tiito, mwijeekesele, maana mweeyo khamwinjuwa wakathi mweenyewe nyuupa anttelaaye oruti; enttela wiiya njuwa looveva, osikhu layili, lifwajiri ama supu. ");
INSERT INTO eko_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Amana ye ata woohileezi, ti ahiwaasikane eettaka olala. ");
INSERT INTO eko_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Epile kiniwuuzaanini, kiniwuuzani mooshi: ‘Mwijeekesele!’” ");
INSERT INTO eko_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Zaari osaleela siikhu piiri paasi yoori efiye siikhu ya Paashikowa na siikhu ya Njampo la Phaawu Zoohiina Fwaramento. Mahaakhimu a tiini na anamanozela a kano aari weekesa nanna ya onkhola Yinsa sirini yoori amuule. ");
INSERT INTO eko_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yo aari olupa yoori: “Khanininkhola vanjampo yoori nihipuwise nzuuzu vakatthi wa atthu.” ");
INSERT INTO eko_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yinsa ari Betaaniya, eekhaliye vameeza owawe mwinyi mmote anitthiwaaye Simawu namaharaja, khutawo muukha aataniyeeyo suupha ya mafuttha oonukhela awaatta nzurukhu. Khupwecha suupha etile khumwiitthela Yinsa veeswa vawe. ");
INSERT INTO eko_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Apale aari attaaphale khwiiya ookatipukha khusala oozana atthaaporu yoori: “Aharipwela-ni mafuttha apale. ");
INSERT INTO eko_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Maana aari owahi wuuzanyisa miiya ttatthu za nzurukhu wa paratha, aari weettelaaye winkhiwa asikhini.” Yo khunshowera muukha otule. ");
INSERT INTO eko_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ila Yinsa khuwaalikhisa araka: “Mwinlikhe muukha otu khwa heeri, Mwanvelaveliselani? Ye akirettela miiyo etthu yooshapweya. ");
INSERT INTO eko_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Maana asikhini mwina mweeyo mileele, na mwinwahi owaawuni mwitakharu. Ila miiyo akinteela wiiya vamote na mweeyo mileele. ");
INSERT INTO eko_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ye aretta etile awahiyeeyo. Avaaza mafuttha oonukhela mwiili aka raku zeene, atthenkezaka ozikhiwa waka. ");
INSERT INTO eko_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kiniwuuzani khweele yoori: wakhula vahali lintafusiriwaavo nttakhuzi la Nluku khwa olumwenku wooshi, epi arettiyeeyo muukha otu, zeettaka olupiwa noofikhiriwa ye.” ");
INSERT INTO eko_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Aphano Yuuda Eshikariyoote, mmote wa apale khumi na awiri, khulawa wa mahaakhimu a tiini khwa shawuri za onzinkula Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yo wakathi ansiliyeevo khwiiya oofurahi na khumwaahiti Yuuda omwinkha nzurukhu. Khwa wakathi aya opo Yuuda aari weekesa kiphenyo saana yoori anzinkule. ");
INSERT INTO eko_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Siikhu ya mwanzo ya Njampo la Phaawu Yoohiina Fwaramento, wakathi waazoweriweeyo orettiwa twaha pwittipwitthi yoojeliwa paashikowa, anakhiyoni a Yinsa khumuuzela yoori: “Ontakha yoori neette vayi nootthenkesele etthu yoojiwa ya paashikowa?” ");
INSERT INTO eko_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yinsa khuwaaruma anakhiyoni awe awiri khuwooza yoori: “Mwilawe mpakha ositati, ottuukho mwinlawa mwansikane mwinyi athuuliye yuuku ya maati. Mwinlotte othuuto, ");
INSERT INTO eko_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mwimuuze mweenyewe nyuupa ethiito anttelaaye oviramo yoori ‘Mwaaliimu ontta wuuzela: Orivayi nsana aka wa omaka-vo, kinttelaaye onja-vo paashikowa na anakhiyoni aka?’ ");
INSERT INTO eko_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Aphano ye ontta wuunozani mweeyo khwa nyuupa ya vatulu nsana nwulweene na zooshi mwinihithajiyaaye. Mwitthenkeze attaapho njampo letthu.” ");
INSERT INTO eko_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Anakhiyoni apale awiri khulawa mpakha ositati, khusikana zooshi nkhama etthiipile Yinsa aalupiyeezo na khuntthekeza paashikowa. ");
INSERT INTO eko_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wakathi oripiyeevo, Yinsa khuta na anakhiyoni awe apale khumi na awiri. ");
INSERT INTO eko_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ari vameeza eettaka oja Yinsa khuri: “Weekhweele kiniwuuzani yoori mmote wa mweeyo anjaaye na miiyo onkizinkula.” ");
INSERT INTO eko_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ooshi khwiiya oohuzunikha na khwaaza wuuzela wakhula mmote khwa zwaamu yawe yoori: “Talili khahiyo miiyo?” ");
INSERT INTO eko_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yinsa khujipu yoori: “Mmote wa khumi na awiri anjanaaye miiyo parathu moote. ");
INSERT INTO eko_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mwaana wa Pinaatamu onlawa afwe, nkhama etthiipo yaatikhiweeyo monkoni wa ye. Ila wootakhaliwa ti otule anttelaaye onzinkula Mwaana wa Pinaatamu! Afwataali ahivokoliweeni!” ");
INSERT INTO eko_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Eettaka oja, Yinsa khuthuula phaawu, khuparikhiya, khumeya, khuwenkha anakhiyoni awe na khuwooza yoori: “Mwithuule; opu mwiili aka.” ");
INSERT INTO eko_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Elottelanaka, khuthuula jiikira, khushukhurwela, khuwenkha anakhiyoni awe na ooshi khunywa. ");
INSERT INTO eko_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Khuwooza yoori: “Eti ti taamu yaka ya wahati yiitthiweeyo khwa zwaamu ya atthu ooshi. ");
INSERT INTO eko_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Miiyo kiniwuuzani khweele yoori akinteela onywa theenya nshumo wa nrayi wa wuuva, mpakha siikhu kinttelaaye onywa theenya na mweeyo muufwalume wa Nluku.” ");
INSERT INTO eko_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Paata ya yo wiipa liipo, khulankha khusala alawa omwaako Oluveera. ");
INSERT INTO eko_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Aphano Yinsa khuwooza yoori: “Mooshi mweeyo mwinlawa mwakanswi. Maana yaatikhiwa yoori: ‘Kininvulalisa nshuki aya, na pwittipwitthi zaya zinttela omwazeya.’ ");
INSERT INTO eko_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ila paata ya osisimuwa waka, kinttela olokoza Kalileya.” ");
INSERT INTO eko_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Aphano Pheeturu khutukhuru araka: “Hatha nkhama ooshi eetta wuutthira, miiyo akinuutthira. ");
INSERT INTO eko_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yinsa khunjipu yoori: “Weekhweele kiniwuuza yoori leelo osikhu otthuupu, likukhuwi lihineekhe swaafu piiri, onteela okikhana swaafu ttatthu.” ");
INSERT INTO eko_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ila Pheeturu khusala akhanyarela channu araka: “Hatha nkhama kintakha wuuliwa vamote na weeyo, akinteela wuukhana.” Ooshi khulupa etthiipo. ");
INSERT INTO eko_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Aphano khulankha khulawa puuro eniitthiwaaye Yetemaani, khuwooza anakhiyoni awe yoori: “Mwiikhale apha, miiyo kinttela olompa.” ");
INSERT INTO eko_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Khunthuula Pheeturu, Tiyaaku na Yaahaya khwaaza oshukulikha, othunkuwikha na ohuzunikha. ");
INSERT INTO eko_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yinsa khuwooza yoori: “Nafusi yaka ti ya ohuzunikha venkivene woosaleela ofwa; mwisale apha na mwijeekesele.” ");
INSERT INTO eko_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yinsa khuwaasusa vattitthiiru khukokhora na khusala alompa yoori nkhama enwaheya aattuwananisiwe wakathi opu wa ohoowa. ");
INSERT INTO eko_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Aari olupa toono: Oo Paapa zooshi khwa weeyo zinwaheya. Okaattuwananise miiyo jiikira eti ya ohoowa. Ila ehirettikhane khwa matakhelo aka, ila khwa matakhelo awo. ");
INSERT INTO eko_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Apho khurutela aphale aariivo anakhiyoni awe, khuwaasikana eettaka olala. Khumuuza Pheeturu yoori: “Simawu, ontta olala? Khuwaheeni ojeekesela nenkawu wakathi mmote? ");
INSERT INTO eko_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mwijeekesele na mwilompe, yoori mwihikwele muuzayiniwa; rooho ti yookhomaala, ila mwiili pi woottettheya.” ");
INSERT INTO eko_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yinsa khuwaasusa opheya khusala alompa, arutelaka mattakhuzi mamoteru. ");
INSERT INTO eko_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wakathi arutiyeevo khuwaasikana eettaka olala theenya, mwaasa maasho aya eetta owaalemela; khaari ojuwa etthu yoojipu. ");
INSERT INTO eko_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Khuta swaafu ya ttaatthu khuwooza yoori: “Nalelo mwintta olala na ovumula? Zafiyela! Wafiya wakathi wa Mwaana wa Pinaatamu winkheleliwa mmakhono wa anatwampi. ");
INSERT INTO eko_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mwilankhe, nilawe! Mwimoone namazinkula ori kharipu. ");
INSERT INTO eko_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yinsa nalelo eettaka ottakhula, khusala ata Yuuda mmote wa anakhiyoni apale khumi na awiri. Aari ota na atthu awaatta athuuliye phanka na kolomontto, aarumiweeyo ti mahaakhimu a tiini, anamanozela a kano na attunkhulu a tiini. ");
INSERT INTO eko_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Namazinkula aawooziye alama araka: “Otule kinttelaaye ompatikha, ti othuuto; mwinkhole mwinthuule saana.” ");
INSERT INTO eko_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Wakathi afiyeevo, ye khumwaattama khumuuza yoori: “Mwaaliimu!” na khumpatikha. ");
INSERT INTO eko_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Atthu apale khunkhola Yinsa na khunkholelela. ");
INSERT INTO eko_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aphano mmote wa anakhiyoni awe aariina kharipu, khufuttha phanka khunvavela khushija nshiilo la karumeya wa haakhimu nwulu wa tiini. ");
INSERT INTO eko_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yinsa khuwooza yoori: “Mwakiteela na phanka na mikokontto yoori mwikikhole nkhama nantarawu? ");
INSERT INTO eko_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Siikhu zooshi kaari vamote na mweeyo kisomisaka Nnyupa Woosifwiwamo, khuhikikholi; ila zooshi epi zaariye yoori emarisele zawaatikhiwa ti manapiyu. ");
INSERT INTO eko_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Anakhiyoni awe ooshi khumwanswi na khutthira. ");
INSERT INTO eko_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ila shapu mmote, aajifinikhiyeeyo nkhumi woolakala paasi aari onlottaaye Yinsa. Yo khunkhola, ");
INSERT INTO eko_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ila khuvula nkhumi opule, khutthira waazu. ");
INSERT INTO eko_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Khunthuula Yinsa khunlawana wa haakhimu nwulu wa tiini na khuthukumana mahaakhimu a tiini ooshi, attunkhulu a tiini na anamanozela a kano. ");
INSERT INTO eko_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pheeturu khusala awaalotta ari peetiwene mpakha nlikokoro wa haakhimu nwulu wa tiini, na khulawa khwiikhala na anamarumeyela, ootthaka moottho. ");
INSERT INTO eko_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mahaakhimu a tiini na Mashawuriiya ooshi aari weekesa onsikanana Yinsa paathuli moote yoori anhukhumwele ofwa, ila khuhinsikanani hatha moote. ");
INSERT INTO eko_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Maana awaatta aari olawela oshaahiti woovonyeya khwa Yinsa, ila tukhuru zaya khazaari sawasawa. ");
INSERT INTO eko_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Aphano khulankha atthu akina na onlupeza vitthu zoovonyeya. ");
INSERT INTO eko_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Fweeyo nansiila alupaka yoori: ‘Kimpwecha Nyuupa eti Yoosifwiwamo yoojekiwa pi makhono a anaatamu, na siikhu ttatthu kijeke kiina, yoohijekiwi pi makhono eenaatamu.’” ");
INSERT INTO eko_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ila hatha nkhama piitthiipo, mattakhuzi aya khaari wiiya sawasawa. ");
INSERT INTO eko_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Khulankha haakhimu nwulu wa tiini khumuuzela Yinsa yoori: “Khunjipu mattakhuzi apa onlokoveziwaaye?” ");
INSERT INTO eko_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ila Yinsa khwiiya woonyamala, khuhijipu hatha etthu. Haakhimu nwulu wa tiini khurutela omuuzela theenya yoori: “Weeyo o Al-Masiihu, mwaana wa Nluku Wooparikhiyiwa?” ");
INSERT INTO eko_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yinsa khujipu yoori: “Miiyo ki othuuto, na mwinlawa mwamoone Mwaana wa Pinaatamu eekhaliye nkhono nlume wa Nluku wa owahi zooshi, na ataaka mmawiku a pinkuuni.” ");
INSERT INTO eko_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Aphano haakhimu nwulu wa tiini khuvarula kuwo zawe na khuri: “Khi ninrettanna oshaahiti nkina! ");
INSERT INTO eko_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mweeyo mwasiila okufuru wawe. Mwinuupuwela niini?” Atthu ooshi anri onsuhi wuuliwa. ");
INSERT INTO eko_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Aphano akina khwaaza ontthemela khunfinikha omaasho wawe khusala ampwakula na amuuzela yoori: “Ti paani oopiyeeyo? Onlupe!” Anamweekesela khunkhola na khumpwakula. ");
INSERT INTO eko_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pheeturu aarettiye ari vathi nlikokoro wa nyuupa etile wakathi atiyeeyo njaazi wa haakhimu nwulu wa tiini. ");
INSERT INTO eko_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Amooniyeevo Pheeturu eettaka woottha moottho khuri: “Weeyo waari na Yinsa wa Nazareeti.” ");
INSERT INTO eko_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ila Pheeturu khukhana araka: “Akininjuwa, na wala akinsiila etthu onlupaaye.” Khusaruwela nlako wa nlikokoro. ");
INSERT INTO eko_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Wakathi njaazi otule amooniyeevo theenya, khuwooza apale aariina attaaphale yoori: “Otu mmote wa atthaapo.” ");
INSERT INTO eko_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ila khukhana theenya. Oviriyeevo wakathi vattitthiiru, apale aariina atthaapale theenya khumuuza Pheeturu yoori: “Weekhweele, weeyo o mmoteru na atthaapo, maana onkalileya. ");
INSERT INTO eko_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ye khwaaza onlaani na olapha yoori: “Akininjuwa pinaatamu aya oto oninlupaaye.” ");
INSERT INTO eko_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nasaapiru likukhuwi khwiikha swaafu ya phiiri. Pheeturu khuupuwela mattakhuzi Yinsa amuuziyeeyo yoori: “Likukhuwi lihineekhe swaafu piiri, onikikhana swaafu ttatthu.” Khulaavo aphale vaya khusala alila. ");
INSERT INTO eko_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Supuyeene, khukusanyeya Mahaakhimu a tiini, attunkhulu a tiini, anamanozela a kano na Mashawuriiya ooshi, khunfuka Yinsa khunthuula khumwinkha Pilaatu. ");
INSERT INTO eko_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilaatu khumuuzela yoori: “Weeyo o mfwalume wa mayaahuuti?” Ye khujipu yoori: “Weeyo ti onlupaaye.” ");
INSERT INTO eko_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mahaakhimu a tiini khunlokoveza vitthu zawaatta Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilaatu khurutela omuuzela theenya yoori: “Weeyo khunjipu? Nkoona vitthu kavi anuulokovezaaye.” ");
INSERT INTO eko_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ila Yinsa khuhijipu hatha etthu Pilaatu khwiiya wooshanka. ");
INSERT INTO eko_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Yaari zowera yaya, wakathi wa Njampo la Paashikowa, Pilaatu onfukulela napherezu mmote, otule aari ovekiwaaye ti atthu. ");
INSERT INTO eko_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mwinyi mmote anitthiwaaye Baraba aafukeliwe vamote na anamakhijili mwaasa wa omuula ntthu wakathi wa nzuzu. ");
INSERT INTO eko_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Khuntti ya atthu etile khuta na khunvekela Pilaatu yoori arette etile awaazoweziyeeyo owaarettela. ");
INSERT INTO eko_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Aphano Pilaatu khuwoozela yoori “Mweeyo mwintakha yoori kinfukulele mfwalume wa mayaahuuti?” ");
INSERT INTO eko_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Maana ye aari ojuwa saaneene, yoori mahaakhimu a tiini anleviye Yinsa mwaasa wa nrima. ");
INSERT INTO eko_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ila mahaakhimu a tiini awaakhanyareliye atthu apale yoori anvekele Pilaatu aaze onfukulela Baraba khwa otakha waya. ");
INSERT INTO eko_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilaatu khuwoozela theenya yoori: “Kinrettele niini mwinyi otu mweeyo mwinimwiitthaaye mfwalume wa mayaahuuti?” ");
INSERT INTO eko_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yo khunyakula araka: “Akhomeliwe!” ");
INSERT INTO eko_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ila Pilaatu khuwoozela yoori: “Niini arettiyeeyo yootakhala?” Ila yo khusala atepa onyakula araka: “Akhomeliwe!” ");
INSERT INTO eko_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilaatu eekesaka otuvelisa khuntti etile ya atthu, khunfukulela Baraba na khuruma ojaphiwa Yinsa na olawa okhomeliwa. ");
INSERT INTO eko_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Anajanka khunthuula Yinsa, khunlawana nlikokoro wa nyuupa khuulu ya nsatoro khukusanya khuntti khuluyeene ya anajanka. ");
INSERT INTO eko_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Khunwalisa juupa yookhuttuwa, khuvaasha khaara ya miiwa khunwalisa mmwishwa. ");
INSERT INTO eko_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Khusala anchelisa araka: “Wiiye haayi, mfwalume wa mayaahuuti!” ");
INSERT INTO eko_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Khusala ampiya veeshwa vawe na nthala na ontthemela, akokhoraka na omwaaputu. ");
INSERT INTO eko_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Paata ya onttukhana, anajanka apale khunvula kuwo yookhuttuwa khunwalisa kuwo za wiiya zawe. Aphano khunsarulela vaje yoori alawe ankhomele. ");
INSERT INTO eko_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Khukutthanana mwinyi mmote wa Sireene aari wiitthiwaaye Simawu, papaawe Alishantere na Ruufu, aari olankhaaye omashapa. Khunkhanyarela othuula nsalapa wa Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yo khunthuula Yinsa khunlawana puuro eniitthiwaaye Kolokoota, eriina maana a puuro ya likurakuza la eeshwa. ");
INSERT INTO eko_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Khusala atakha omwinkha viinyu yoophakanyaniwa mafuttha oonukhela, ila ye khuhinywi. ");
INSERT INTO eko_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Aphano khunkhomela na khwaawanyana kuwo zawe khwa weekesa nasipu yoori ajuwe wakhula ntthu phantte ari weettelaaye osalana. ");
INSERT INTO eko_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Aakhomelaniwe wakathi wa saa-ttaatthu, supu. ");
INSERT INTO eko_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pi etthiipo yaatikhiweeyo khwa olokoveziwa wawe yoori: MFWALUME WA MAYAAHUUTI. ");
INSERT INTO eko_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Vamote na ye aakhomeliwe manantarawu awiri, mmote nkhono nlume, nkina nkhono nkha, ");
INSERT INTO eko_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","na khurettikhana epile zawaatikhiwa zaalupiyeeyo yoori: “Ye aatthanttiwe nkhama namatapanya.” ");
INSERT INTO eko_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Apale aari oviraaye attaaphale, eetta onttukhana na osakhinya viishwa zaya araka: “Haya, weeyo ompwechaaye Nyuupa Yoosifwiwamo, khwa siikhu ttatthu khujeka. ");
INSERT INTO eko_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Wiishukhe vansalapa apho na ojuusuru omweenyewe!” ");
INSERT INTO eko_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Khwa nanna etthiipile, mahaakhimu a tiini na anamanozela a kano khusala alupa atthaaporu anveyisa yoori: “Awoosuru akina, ila khanwahi ojuusuru mweenyewe. ");
INSERT INTO eko_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Wiishukhe vansalapa apho O Al-Masiihu, mfwalume wa Ezirayiilu, wiishukhe yoori niwoone na nuukhupali.” Apale aakhomeliweeyo, na yo eetta onttukhana theenya. ");
INSERT INTO eko_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Yaapuwiye yiiza olumwenku wooshi, waaza atuhuri mpakha alaasiri. ");
INSERT INTO eko_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Payina ya alaasiri, Yinsa khukhuwa na huula ya onyakula, araka: “Elooyi, Elooyi, Lama sabatani?” Eto ena maana ya “Nluku aka, Nluku aka, mwaasa aya niini okanswaka? ");
INSERT INTO eko_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wakathi atthu apale aari attaaphale asiiliyeevo mattakhuzi apale, khulupa yoori: “Mwisiile, oninkhuwela Aliyaasi!” ");
INSERT INTO eko_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mmote aari attaaphale khutthira khulawa khunaanisa shiponja na vinaakiri, khupweha va muutthi na khumwinkha Yinsa yoori anywe na khuri: “Mwinlikhe, nimoone nkhama Aliyaasi onta anlazevo aphale vaya. ");
INSERT INTO eko_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ila Yinsa khunyakula channu khwiittha phuumu. ");
INSERT INTO eko_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Phazira ya Nnyupa Woosifwiwamo khuvaruwa khwaawanyeya phantte piiri, waaza vatulu mpakha vathi. ");
INSERT INTO eko_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Wakathi namalokozela wa anajanka aariiye omaasho wa Yinsa, ooniyeevo nanna afwiyeeyo, khuri: “Wekhweele mwinyi otu aari Mwaana wa Nluku!” ");
INSERT INTO eko_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Aakha akina aari oretta eettaka woona vitthu epile zaari orettikhanaaye ari peetiwene. Khwa atthaapo aarivo Mariyamu Mataleena, Mariyamu mamaawe Tiyaaku, nsimaana wa Yuusufu, na Salome. ");
INSERT INTO eko_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Aakha aya apo amperekhiye Yinsa na omwaawuni wakathi ariiyo Kalileya. Owaalikha apo aya, aarivo aakha akina awaatta aalawaniyeeyo Yeruzaleemu. ");
INSERT INTO eko_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Njuwa leettelaka otupweela, mwaasa wa wiiya siikhu ya otthenkeza Saapatu, ");
INSERT INTO eko_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yuusufu wa Arimateeya, mwinyi wa fwayita na aari oretta phantte ya Mashawuriiya, oto naye aari oweja ota wa ofwalume wa Nluku, khulawa woominyalavo wa Pilaatu na khuveka mwiili wa Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilaatu khwiiya wooshanka noosiila yoori Yinsa afwa. Khunkhuwela namalokozela wa anajanka khumuuzela nkhama Yinsa afwa. ");
INSERT INTO eko_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Wakathi ooziweevo ti namalokozela wa anajanka, khumwinkha mwiili wa Yinsa Yuusufu. ");
INSERT INTO eko_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Aphano Yuusufu khuuzanya kuwo yoolakala yoopeepheya, khwiishusha mwiili wa Yinsa vansalapa aphale, khumputaputela va kuwo etile yoolakala na khunttha nkhapuri yaathipiweeyo va mwaako. Nawiisha, khutthaavo liwe vanlako vaya. ");
INSERT INTO eko_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariyamu Mataleena na Mariyamu mamaawe Yuusufu, aarettiye eettaka woona na khoona mwiili wa Yinsa vahali waatthiiweevo. ");
INSERT INTO eko_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Paata ya ovirisa Saapatu, Mariyamu Mataleena, Salome na Mariyamu mamaawe Tiyaaku, khuuzanya mafuttha oonukhela yoori eetthele mwiili wa Yinsa. ");
INSERT INTO eko_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Siikhu ya mwanzo ya sumana supuyeene, njuwa leettelaka opuwa, aakha apale khulawa okhapuri. ");
INSERT INTO eko_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ntarikhi khusala oozelana yoori: “Paani anttelaaye onilazelavo liwe lifukaniweeyo nlako wa khapuri?” ");
INSERT INTO eko_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Maana liwe laya laari liwululene. Ila noofiya okhule, khoona liri loolaziwavo. ");
INSERT INTO eko_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Aviriyeevo nkhapuri mphule, khumoona shaapu awaliye kuwo zoolakala eekhaliye nkhono nlume, na khwiiya awoova. ");
INSERT INTO eko_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Khuwooza yoori: “Mwihoove, mweeyo mwinimweekesa Yinsa wa Nazareeti, aakhomeliweeyo. Ye asisimuwa! Khaamo mphu, moone puuro aattattikheliwevo. ");
INSERT INTO eko_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mwilawe na mwawooze anakhiyoni awe na Pheeturu yoori: ‘Ye alokoza eettaka Kalileya.’ Ottuukho mweeyo mwinlawa mwamoone, nkhama etthiipo awuuziyeenini.” ");
INSERT INTO eko_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Eettaka othukumela na osuthuwa, aakha apale khulaawo na khutthiramu nkhapuri mphule. Na khuhimuuzi hatha ntthu, maana aari awoova. ");
INSERT INTO eko_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Wakathi Yinsa asisimuwiyeevo lifwajiri la siikhu ya mwanzo ya sumana, khumpuwelela omwanzo ene Mariyamu Mataleena, otule eekariweeyo mmwiili mwawe masheethwani sapa. ");
INSERT INTO eko_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ye khulawa owooza ashirikha awe Yinsa, maana yo aari oohuzunikha na olila. ");
INSERT INTO eko_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Wakathi asiiliyeevo yoori Yinsa ori haayi na ampuweleliye Mariyamu Mataleena yo khuhikhupali. ");
INSERT INTO eko_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Paata ya vitthu epile, Yinsa khujithoonyeza khwa wuuso nkina vakatthi wa anakhiyoni awe awiri alottaka tarikhi ya omashapa. ");
INSERT INTO eko_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Yo khuruti khuta khuwooza mattakhuzi apale azaaya; ila theenya apale khuhikhupali. ");
INSERT INTO eko_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Omwiisho waya Yinsa khuwaapuwelela apale khumi na mmote, wakathi aariiyo vameeza, na khuwaashowera mwaasa woohikhupali na wuuma rooho zaya, maana khawaasileziye apale aamoniyeeyo wakathi asisimuwiyeevo. ");
INSERT INTO eko_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Khuwooza yoori: “Mwilawe olumwenku wooshi mwawalaleyele atthu ooshi hapari zooshapweya. ");
INSERT INTO eko_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Otule ankhupalelaaye na khoosiwa ontta wuusurukha, ila otule ahinkhupalelaaye oniiyana paathuli. ");
INSERT INTO eko_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Alama epi enttela owaalokoza apale anikikhupalaaye miiyo: khwa nzina laka aniikara masheethwani, anlawa attakhule luuka pheeya, ");
INSERT INTO eko_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ankhola nyookha na onywa amali ya wuula, ila khuhiwaaretti hatha etthu na owaattheela atthu makhono khuvona.” ");
INSERT INTO eko_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Paata ya owooza mattakhuzi apale, Mbwana Yinsa khuweziwa pinkuuni khwiikhala nkhono nlume wa Nluku. ");
INSERT INTO eko_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Aphano anakhiyoni apale khulankha khulawa olaleya phantte zooshi, Mbwana aari owaawuni ahakikhaka mattakhuzi aya na alama zaari owaalottaaye. ");
INSERT INTO eko_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Weeyo Tiyoofilu woohishimiwa, atthu a waatta aajilipisiye waatikha hatiithi ya vitthu ziviriyeeyo vakatthi vetthu. ");
INSERT INTO eko_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Apale aari mashaahiti ooniyeeyo omwanzweene zirettikhanaka, khwiiya anamalaleya a hapari zooshapweya za nttakhuzi la Nnyizinku, atthaapo pi anifiseliyeeyo fweeyo. ");
INSERT INTO eko_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na miiyo zaamu yaka khusala kitholathola woohilazeli varanka epile zirettikhaniyeezo zaazaka, khulakela owaatikhela zooshi woolotteyavo, ");
INSERT INTO eko_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","yoori wiiyane nroromelo khwa mattakhuzi apa a haakhi osiiliyeeyo. ");
INSERT INTO eko_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Wakathi Herooti ari nsatoro wa Yudeya, aarivo haakhimu wa tiini mmote wa khuntti ya Abiiya aari wiitthiwaaye Zakariiya. Muukhaawe aari wiitthiwa Elizabeeti aari woojama wa mahaakhimu a tiini. ");
INSERT INTO eko_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Oowiiri aya aari atthu ookhweele nkatthi wa mwentto wa Nnyizinku na ooshututela wa waamineyavo kano na oruma wooshi wa Mbwana. ");
INSERT INTO eko_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elizabeeti khaarina mwaana mwaasa woohiina mavokozi na oowiiri aya aari awuuluvala. ");
INSERT INTO eko_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Siikhu moote Zakariiya aari okhola khaazi yoohaakhimu wa tiini Nnyuupa wa Nnyizinku Yeruzaleemu, mwaasa yoori yaari zwaamu ya khuntti yawe okhola khaazi yaya etile. ");
INSERT INTO eko_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nkhama etthiipo aazowereliyeeyo attunkhulu a tiini, ye aathawuliwe nkatthi wa nasipu yoori asala akhoza ovupa puuro ttakatthiifu ya Mbwana. ");
INSERT INTO eko_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","N'oofiya wakathi wookhoza ovupa, atthu ooshi apale aari vaje aari ovira alompaka. ");
INSERT INTO eko_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Aphano nlayikha la Mbwana khunteela Zakariiya nkhono-nlume vaalitaari onkhoziwaavo ovupa. ");
INSERT INTO eko_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Wakathi ye ooniyeevo nlayikha ntthile, khwiiya wooshanka na wa woova channu. ");
INSERT INTO eko_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nlayikha khumuuza yoori: “Ohoove Zakariiya! Nnyizinku asiila lompa yawo; muukhaawo Elizabeeti onteela ompattha mwaana. Weeyo onteela ontthaja nzina la Yaahaya. ");
INSERT INTO eko_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ye onttela wiiya furaha yootuveliwa wawo, atthu a waatta anteela ofurahela ovokoliwa wawe, ");
INSERT INTO eko_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","maana ye onteela wiiya nttunkhulu mmakhono wa Mbwana Nnyizinku. Khanteela onywa viinyu wala onywa vitthu zoohapala. Onttela wiiya wa wiitaazaniwa Rooho Ttakatthiifu ari mwiirukulu wa mamaawe. ");
INSERT INTO eko_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Onteela owaatana atthu awaatta a Ezirayeele wa Mbwana Nnyizinku aya. ");
INSERT INTO eko_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Onteela operekhiwa ti Mbwana na onttela wiiya wookhomaala na woowahi nkhama napiyu Aliyaasi, yoori azukulise rooho za apaapa eeyane osiilana na aanaaya, na yoori awaazukuluse anamakhijili eettettise haakhi, toowo phi anttelaavo ozukulisa rooho zaya yoori ampokherele Mbwana ataaka.” ");
INSERT INTO eko_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Aphano Zakariiya khuuzela nlayikha ntthile yoori: “Kinteela ohakikhi toovi etthu yaya eto? Miiyo kooluvala na muukhaaka ooluvala.” ");
INSERT INTO eko_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Khujipu nlayikha liraka: “Miiyo ki Jipiriilu, kiniiya vamote na Nnyizinku, akiruma yoori kite kiwuuze hapari epi zooshapweya. ");
INSERT INTO eko_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wiiya khukhupaleeni mattakhuzi apa kiwuuziyeezo, onttela wiiya woohittakhuli mpakha siikhu zinttelaaye orettikhana vitthu epi. Zinteela orettikhana wakathi aya otthuupo.” ");
INSERT INTO eko_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nalelo atthu aari onwejaaye Zakariiya khushanka mwaasa woorupaza Nnyupa wa Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","N'oosaruwa, khuhisala awahi ottakhulana atthu apale. Yo khujuwa yoori wanteeliye wahayi Nnyupa wa Nnyizinku. Khwiiya woohittakhuli khusala attakhula na makhono. ");
INSERT INTO eko_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wakathi eeshisiyeevo siikhu zookhola khaazi z'oottunkhulu wa Nnyupa wa Nnyizinku, khurutela owawe. ");
INSERT INTO eko_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Paata ya toole, muukhaawe Elizabeeti khwiimittha, khuhisala asaruwa nnyupa mpakha nyeezi mithaanu. ");
INSERT INTO eko_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Khuri: “Aphano Mbwana ajipu lompa yaka, eeshisa haaya etile kaariina na atthu.” ");
INSERT INTO eko_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mweezi wasiitha wa erukulu ya Elizabeeti, Nnyizinku khuruma nlayikha Jipiriilu olawa sitati ya Kalileya nti wa Nazareeti ");
INSERT INTO eko_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","yoori lilawe wa mwaari mmote woohijansiliwi aari wiitthiwaaye Mariyamu, aaposiweeyo ti shapu mmote aari wiitthiwaaye Yuusufu woojama wa mfwalume Daawuuda. ");
INSERT INTO eko_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nlayikha ntthile n'onsikana khumuuza yoori: “Heeri yiiye vamote na-weyo Mariyamu! O wooziti oshapweyiwa, Mbwana ori vamote na-weyo.” ");
INSERT INTO eko_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ye khwiiya woozinkireya mwaasa wa mattakhuzi apale, khuvira aphelelezaka maana a hapari zaya epile. ");
INSERT INTO eko_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nlayikha khurutela omuuza liraka: “Ohoove Mariyamu, wapattha rehema omaasho wa Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Onteela wiimittha ompatthe mwaana wanlume ontthaje nzina la Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ye onteela wiiya nttunkhulu, nka eetthiwaka Mwaana wa Nnyizinku Nwulu wa Pinkuuni. Mbwana Nnyizinku onteela omwinkha ofwalume wa papaawe Daawuuda. ");
INSERT INTO eko_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Na onteela wiiya mfwalume wa Ezirayeele khwa mileele, ofwalume awe khunteela wiisha.” ");
INSERT INTO eko_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Aphano Mariyamu khuuzela nlayikha yoori: “Zinttela orettikhana toovi na miiyo akininjuwa nlume?” ");
INSERT INTO eko_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nlayikha khujipu liraka: “Rooho Ttakatthiifu ontta owiishukhela, owahi wa Nnyizinku Nwulu wa Pinkuuni onttela wuufinikha na mwiivuuli awe. Ti eto Mwaana onttelaaye ompattha, onteela wiitthiwa Ttakatthiifu, Mwaana wa Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Omoone jamaayo Elizabeeti, otule yaari oriwakaaye khanvokola, ila apha na wuuluvala wawe nasaapi eti eemittha opu mweezi wasiitha. ");
INSERT INTO eko_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Maana, mmakhono wa Nnyizinku khayiivo etthu moote ehinwaheyaaye.” ");
INSERT INTO eko_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariyamu khuri: “Kiri raati miiyo karumeya wa Mbwana; mattakhuzi apa onlupaaye phi arettikhane khwa miiyo.” Nlayikha ntthile khulaavo khulawa. ");
INSERT INTO eko_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ziviriyeevo siikhu, Mariyamu khujilokotthela khusala alawa na waakuva sitati moote yaari nti wa nnyaako za Yudeya. ");
INSERT INTO eko_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","N'oofiya khuvira nnyupa owawe Zakariiya khunchelisa Elizabeeti. ");
INSERT INTO eko_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ye n'oosiila mwacheliwa etile ya Mariyamu, mwaana aari mwiirukulu mwawe khujisakhinya. Elizabeeti khwiiya wa wiitaazaniwa Rooho Ttakatthiifu. ");
INSERT INTO eko_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Khukhuwa na kuvu araka: “Wooparikhiyiwa ti weyo Mariyamu vakatthi wa aakha, na wooparikhiyiwa mwaana oto ariiye mwiirukulu mwawo! ");
INSERT INTO eko_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Miiyo ki paani wooteela wooniwa ti maama wa Mbwanaaka? ");
INSERT INTO eko_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","N'oosiila mwacheliwa yawo, mwaana ariiye mwiirukulu mwaka eetta ojisakhinya wafurahavo. ");
INSERT INTO eko_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Wooparikhiyiwa ti weyo okhupaliyeeyo yoori anteela orettikhana mattakhuzi apa wuuziweeyo a phantte ya Mbwana.” ");
INSERT INTO eko_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Aphano Mariyamu khuri: “Nafusi yaka enlaleya owula wa Mbwana, ");
INSERT INTO eko_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Rooho yaka ti yomfurahela Nnyizinku namuusuru aka, ");
INSERT INTO eko_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","mwaasa yoori Ye akuupuwela miiyo karumeyaawe woohiitaali mmaasho. Waaza attaapha, peewu za atthu ooshi zinttela okiittha yoori muukha wooparikhiyiwa, ");
INSERT INTO eko_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","mwaasa yoori Nnyizinku Woowahi aretta vitthu khuluzeene muuhaayi mwaka; nzina lawe ttakatthiifu. ");
INSERT INTO eko_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ye oniwaahurumiya atthu a peewu zooshi apale animoovaaye. ");
INSERT INTO eko_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Aretta vitthu khuluzeene na makhono awe, khuwaamwaza apale oojikhupali khwa shawuri za nroho mwaya. ");
INSERT INTO eko_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Awaalaza afwalume ohaakhimu aya khuwaalansa atthu apale oojipushuwisa. ");
INSERT INTO eko_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Aweetaaza vitthu apale ariina jala, na khuweekara mathaajiri makhonoru. ");
INSERT INTO eko_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Amwaawuni karumeyaawe Ezirayeele, oopuwelaka huruma aarinaaye ");
INSERT INTO eko_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","na Eburahiima na peewu yawe khwa mileele, nkhama etthiipo aawooziyeezo amarehemu apapazetthu.” ");
INSERT INTO eko_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariyamu eekhaliye nyeezi mittatthu wa Elizabeeti nawiisha khurutela owawe ");
INSERT INTO eko_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Khufiya wakathi wa Elizabeeti opattha ekumi, khunvokola mwaana wanlume. ");
INSERT INTO eko_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Anamwaattamanani awe na ajamaaze khusiila elupiwaka huruma khuluyeene Mbwana amooneliyeeyo Elizabeeti, khulawa khufurahi vamote na-ye. ");
INSERT INTO eko_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Efiiyeevo siikhu yanaane, mwaana otule khulawa khukhiriyisiwa khusala atakha otthajiwa nzina la papaawe Zakariiya. ");
INSERT INTO eko_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ila mamaawe khujipu araka: “Ii wala! Nzina lawe linttela wiiya Yaahaya.” ");
INSERT INTO eko_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yo khulupa yoori: “Weeyo khuna jamaayo ariina nzina laya nttho!” ");
INSERT INTO eko_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aphano khwinkhiwa alama papaawe yoori lijuwiwe nzina aari otakhaaye ontthaja mwaana otule. ");
INSERT INTO eko_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakariiya khuveka lipawu nttitthiiru, khwaatikhavo yoori: “Nzina lawe ti Yaahaya.” Atthu ooshi khushanka. ");
INSERT INTO eko_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nasaapiru Zakariiya milomo zawe khufunuwa na nlimi lawe khushashuwa, khwaaza ottakhula ansifwaka Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Anamwaattamanani awe ooshi khwiiya awoova, hapari epile khumwazeyela nti wooshi wa nnyaako wa Yudeya. ");
INSERT INTO eko_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Atthu ooshi aasiiliyeeyo khusala oopuwela oozelanaka yoori: “Mwaana aya otu onttela wiiya paani?” Nkhono wa Mbwana ori vamote na-ye. ");
INSERT INTO eko_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakariiya paapa wa mwaana otule, khumwiitaala Rooho Ttakatthiifu khwaaza olaleya mattakhuzi a Nnyizinku araka: ");
INSERT INTO eko_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Asifwiwe Mbwana Nnyizinku, Nluku wa Ezirayeele, ateeliyeeyo owaawuni na owaataphula atthu awe. ");
INSERT INTO eko_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nnyizinku aninkha nusura yookhomaala khwa ojama wa karumeyaawe mfwalume Daawuuda, ");
INSERT INTO eko_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","nkhama aalupiyeezo rakuzeene khwa manapiyu awe oottakatthiifu. ");
INSERT INTO eko_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ye aanaahitiye onuusuru nkatthi wa maatuwi etthu, anitaphulaka mmakhono wa apale aniiphiiriwaaye ti fweyo, ");
INSERT INTO eko_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","awaathoonyezaka huruma amarehemu apapazetthu, na oopuwelaka wahati woottakatthiifu aarettiyeeyo na-yo. ");
INSERT INTO eko_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Na olapha aalaphisaniyeeyo na marehemu papeetthu Eburahiima, ");
INSERT INTO eko_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","alaphaka yoori aari oteela onoopola mmakhono wa maatuwi etthu, yoori ninrumeyele Ye woohoovi, ");
INSERT INTO eko_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","woottakatthifuvo na washariyavo omaasho wawe siikhu zooshi zoohaayi etthu. ");
INSERT INTO eko_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Weeyo mwanaka onteela wiitthiwa oriwa napiyu wa Nnyizinku Nwulu wa Pinkuuni, onttela wiiya namalokozisiwa wa Mbwana yoori omwaattalelele tarikhi zawe, ");
INSERT INTO eko_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","owaalaleyelaka atthu awe nusura entaaye khwa nswammaha wa twampi zaya, ");
INSERT INTO eko_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","maana Nnyizinku etthu ti wa huruma. Onteela othoonyeza nuuru yawe vakatthi vetthu, ");
INSERT INTO eko_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ewaamwasikhele apale ari n'yiiza na vamwiivuuli woofwa, yoori eneettettise ntarikhi ya heeri.” ");
INSERT INTO eko_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwaana otule khuvira awulaka na rooho yawe khusala ekhomaala, khwiikhala makuluttu mpakha siikhu apuweleliyeevo vakatthi wa atthu a Ezirayeele. ");
INSERT INTO eko_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wakathi aya opo Seezari Akuushitu mfwalume nwulu, aarumiye yoori atthu ooshi apale a nkatthi woofwalume wa Rooma aarina yoolawa waatikhiwa nwarakha ya afwalume. ");
INSERT INTO eko_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Waatikhiwa opo wamwanzo waarettikhaniye Kureeniyo ari mfwalume wa Siiriya. ");
INSERT INTO eko_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Wakhula ntthu khusala alawa nti aavokoliweewo olawa waatikhiwa. ");
INSERT INTO eko_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yuusufu na-ye khulankha Kalileya sitati ya Nazareeti, khusala alawa Yudeya sitati ya Belemu ottuukho aavokoliweewo wa mfwalume Daawuuda. Ye eetteliye waatikhiwa maana aari woojama wa Daawuuda. ");
INSERT INTO eko_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Aalawiye na mposaawe Mariyamu ari wa wiimittha. ");
INSERT INTO eko_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Siikhu zaya epo ari Belemu ottuukhule, Mariyamu khumfiyela siikhu zoopattha ekumi. ");
INSERT INTO eko_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Khumpattha mwaana w'oomwanzo awe wanlume, khumputaputela vakuwo, khunttattikhela nkashothi zaari ojaamo nyama, mwaasa yoori khaarina puuro yoomaka. ");
INSERT INTO eko_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nti otthuupule aariwo amakhampuzi aari wiikhalaaye ntthuttu ashukisaka pwittipwitthi zaya na weekesela osikhu wooshi. ");
INSERT INTO eko_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nlayikha la Mbwana khwiishukhela attaaphale aariivo amakhampuzi apale. Nuuru ya Mbwana khuwaamwasikhela, khwiiya awoova channu. ");
INSERT INTO eko_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ila nlayikha ntthile khuwooza yoori: “Mwihoove! Miiyo kateela owuuzani hapari zooshapweya za furaha khuluyeene, enttelaaye wiiya ya atthu ooshi. ");
INSERT INTO eko_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Leelo ethiiti, sitati ya Daawuuda mwavokoleliwa Namuusuru eeyiye Al-Masiihu, Mbwana. ");
INSERT INTO eko_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Alama yenu ti eto: mwininsikana mwaana aputaputeliwe vakuwo, attattikheliwe nkashothi enjakaamo nyama.” ");
INSERT INTO eko_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nasaapiru khupuwa malayikha a waatta, khuphakanyeya na ntthile lamwanzo, khusala ansifu Nnyizinku araka: ");
INSERT INTO eko_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Asifwiwe Nnyizinku otulu, na vathi apha heeri yiiye vamote na atthu ooshi awaatakheliyeeyo osaana.” ");
INSERT INTO eko_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wakathi malayikha apale aruteliyeevo pinkuuni, amakhampuzi khuuzana yoori: “Nlaweni Belemu noone etthu erettikhaniyeewo, etile Mbwana anuuziyeeyo.” ");
INSERT INTO eko_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yo khuhirupazi, khulawa khunsikana Mariyamu na Yuusufu na mwaana otule attattikheliwe nkashothi zinjakaamo nyama. ");
INSERT INTO eko_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","N'oomoona mwaana otule, yo khusala alupa epile ooziweezo ti nlayikha monkoni wa Ye. ");
INSERT INTO eko_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ooshi apale aasiiliyeeyo hapari aari olupaaye amakhampuzi apale, khwiiya ooshanka. ");
INSERT INTO eko_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ila Mariyamu aatthiiye varoho vawe vitthu epile aari osiilaazo, khusala apheleleza maana aya. ");
INSERT INTO eko_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Paata ya toole, amakhampuzi apale khurutela ntthuttu anttitthimisaka Nnyizinku na ansifwaka khwa zooshi aasiiliyeezo na ooniiyeezo, etthiipile nlayikha laawooziyeezo. ");
INSERT INTO eko_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","N'oofiya siikhu naane, mwaana otule khukhiriyisiwa, khutthajiwa nzina la Yinsa, nttintthile aalupiyeeyo nlayikha ahineemitthiwe. ");
INSERT INTO eko_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","N'oovira siikhu zootwahareshiwa Mariyamu na Yuusufu, nkhama etthiipo zaari olupaazo kano za napiyu Munsa, khunthuula mwaana otule khunlawana Yeruzaleemu yoori enkheleliwe mmakhono wa Mbwana ");
INSERT INTO eko_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","maana yaatikhiwa nkano wa Mbwana yoori: “Mwaana wamwanzo wanlume ona yoophakuliwa khwinkhiwa Mbwana.” ");
INSERT INTO eko_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Yuusufu na Mariyamu khwinkha twaha nkhama etthiipo zinrumaazo kano za Mbwana: “makhoko mawiri ama jiwa piiri.” ");
INSERT INTO eko_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Wakathi aya opo Yeruzaleemu aariwo mwinyi mmote aari wiitthiwaaye Simiyooni, aari wa shariya na woomoova Nnyizinku. Ye aari owejela wuusurwiwa wa atthu a Ezirayeele. Rooho Ttakatthiifu yaari vamote na-ye ");
INSERT INTO eko_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","na khunthoonyeza yoori khaari ofwa ahimooneeni Al-Masiihu wa Mbwana. ");
INSERT INTO eko_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Simiyooni khweetta Nnyupa wa Nnyizinku alokoziwe ti Rooho Ttakatthiifu, wakathi apapaze antaniyeevo Yinsa yoori aretteliwe etile yaalupiweeyo nkano, ");
INSERT INTO eko_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyooni khunthuula mwaana otule mmakhono mwawe khunshukhurwela Nnyizinku araka: ");
INSERT INTO eko_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Mbwanaaka, aphano kimfwa na heeri maana yarettikhana etile waahitiyeeyo. ");
INSERT INTO eko_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Koona nusura yawo ");
INSERT INTO eko_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","owaattaleleliyeeyo atthu ooshi. ");
INSERT INTO eko_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ye nuuru yoomwaasikhela khapila zooshi za amalapo na siifwa ya atthu awe a Ezirayeele.” ");
INSERT INTO eko_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Papaawe na mamaawe khwiiya ooshanka mwaasa wa mattakhuzi apale aari onlupezaaye Simiyooni mwaana otule. ");
INSERT INTO eko_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiyooni khuwaaparikhiya, khumuuza Mariyamu maama wa mwaana yoori: “Mwaana otu Nnyizinku anthawula yoori atthu awaatta a Ezirayeele ajikwise ama awoosuru. Ye alama ya Nnyizinku ila atthu a waatta anlawa ankatthale. ");
INSERT INTO eko_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mwaasa wa ethiito, wuupuwela wa nroho wa atthu a waatta onteela osaruwa; weeyo Mariyamu enteela wuupattha huzuni khuluyeene nkhama phanka yoonoliwa yoori eshije nafusi yawo.” ");
INSERT INTO eko_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Attaaphale aarivo sharifwa mmote aari wiitthiwaaye Aana. Aari mwaana wa Fwanuweele wa lihimo la Asheeri, aari wa wuuluvala. Eekhalaniye mannawe nyaakha sapa, ");
INSERT INTO eko_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","paata yomfwela mannawe, khuhiraliwi mpakha opattha nyaakha thamaaniini na mine. Khaari olaamo Nnyupa wa Nnyizinku nthana na osikhu, khaazi yawe yaari omwaaputu Nnyizinku ofuka na olompa. ");
INSERT INTO eko_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Wakathi otthuupo khwaaza onshukhurwela Nnyizinku attakhulaka monkoni wa mwaana otule, awoozaka atthu ooshi apale aari owejelaaye wookhowa wa Yeruzaleemu. ");
INSERT INTO eko_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yuusufu na Mariyamu nawiisha oretta zooshi epile zaari orumaazo kano ya Mbwana, khurutela Kalileya sitati ya Nazareeti owaya. ");
INSERT INTO eko_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwaana khusala awula saaneene na khwiiya njuwi nwulweene, rehema ya Nnyizinku yaari vamote na-ye. ");
INSERT INTO eko_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Wakhula mwaakha Mariyamu na Yuusufu aari weettaka Yeruzaleemu onjampo la Paashikowa. ");
INSERT INTO eko_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Wakathi Yinsa apatthiyeevo nyaakha khumi na miwiri, Mariyamu na Yuusufu khulankha khusala alawa onjampo la Paashikowa nkhama etthiipile aazowereliyeezo, alawaka anthuuliye Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","N'oofiya khuretta njampo ntthile khwiisha, khusala arutela owaya. Yinsa khusala Yeruzaleemu, mamaawe na papaawe woohijuwi. ");
INSERT INTO eko_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Yo aari woona yoori ori khuntti etile yaari orutelaaye onti, khuvira siikhu ntero eettaka weettetta, aphano khwaaza omweekesa awoozelaka ajamaaze na ashirikhaawe. ");
INSERT INTO eko_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Khuhisala ampattha, khurutela Yeruzaleemu olawa omweekesa. ");
INSERT INTO eko_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Eviriyeevo siikhu ttatthu, khunsikana ari Nnyupa wa Nnyizinku eekhaliye na anamasomisa awulu a tiini eettaka onsiila na omuuzela. ");
INSERT INTO eko_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ooshi apale aari onsiilaaye khunshankela mwaasa woojuwa wawe na nanna aari owaajipwaazo. ");
INSERT INTO eko_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aphano apapaze n'oomoona khushanka, mamaawe khumuuzela araka: “Mwanaka! Niini epi oniretteliyeezo? Miiyo na papaawo naari wa wantipweya naaza raku oweekesa.” ");
INSERT INTO eko_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ye khujipu yoori: “Mwaari okeekesela-ni? Khamwaari ojuwa yoori miiyo kaarina ya wiiya Nnyupa wa Paapa?” ");
INSERT INTO eko_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yo khuhiweeleyi etthu aari olupaaye. ");
INSERT INTO eko_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yinsa khurutela nti wa Nazareeti na papaawe na mamaawe khusala awaashututela. Mamaawe aari oretta athokorelaka vitthu epile zooshi nroho mwawe. ");
INSERT INTO eko_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yinsa khusala avira awulaka nkatthi wa ojuwa, hirimu na nrehema ya Nnyizinku na atthu. ");
INSERT INTO eko_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mwaakha wakhuumi na thaanu Seezari Tibeeriyu ari mfwalume nwulu wa Rooma, Pontiyu Pilaatu ari liwaali wa Yudeya. Herooti ari nsatoro wa Kalileya na ttwiiye Filiipe na-ye ari wa Itureeya na Tarakhoniiti, Lusaaniya ari nsatoro wa Abileeni. ");
INSERT INTO eko_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anaasi na Khayiifwa aari mahaakhimu awulu a tiini. Mwaakha aya pi otthuupo enkhiweeyo mattakhuzi a Nnyizinku Yaahaya mwaana wa Zakariiya makuluttu. ");
INSERT INTO eko_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ye khuzukulela miti zooshi zaattameliyeeyo muuttho Yorotaani, awoozaka atthu yoori athupwiye twampi zaya aswaamihiwe ti Nnyizinku na oosiwe. ");
INSERT INTO eko_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nkhama etthiipo zaatikhiweezo nkithaapu ya napiyu Ezayiiya: “Owaapho ntthu ankhuwaaye n'yaara araka: ‘Mwaattalele tarikhi ya Mbwana, na mwishapweyise miphiitelo zaya. ");
INSERT INTO eko_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Makunte ooshi asireliwe, nyaako na kulu zooshi zipwejiwe, tarikhi zoonyokowa zookoleliwe, epile zoothipeya zishottheliwe. ");
INSERT INTO eko_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Atthu ooshi anteela woona nusura ya Nnyizinku.’” ");
INSERT INTO eko_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yaahaya khusala awooza atthu apale aari otaaye woosiwa araka: “Khapila za nyookha! Paani awuuziyeenini otthira hukhumu ya Nnyizinku entaaye? ");
INSERT INTO eko_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mwirette vitthu enthoonyezaaye yoori khweele mwathupwiya, khahiyo ojilupeza yoori ‘Eburahiima ti papeetthu’. Miiyo kiniwuuzani yoori khwa liwe ntthi Nnyizinku onwahi owaattala aana a Eburahiima. ");
INSERT INTO eko_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nshokha latthiiwa nshini wa mitathaari za miitthi, wakhula muutthi ohiniimaaye mishumo zooshapweya ontta oshijiwa weeseleliwe vamoottho.” ");
INSERT INTO eko_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Atthu khusala amuuzela araka: “Apho nirette niini?” ");
INSERT INTO eko_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ye khuwaajipu yoori: “Otule ariina hempe piiri, moote amwinkhe otule ahina. Otule ariina etthu-yoojiwa awaameele apale ahina.” ");
INSERT INTO eko_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Khulankha anamariphisa lumpuru yoori alawe oosiwe khumuuzela Yaahaya yoori: “Mwanliimu, khi fweeyo nirette niini?” ");
INSERT INTO eko_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ye khuwaajipu araka: “Mwihiriphise mwizitisa hisapu mwirumiweeyo.” ");
INSERT INTO eko_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Anajanka na-yo khumuuzela yoori: “Khi fweeyo niri toovi?” Khuwaajipu yoori: “Mwihiwaanyakanye atthu mwiroromelaka kuvu zenu, wala mwihiwaalokoveze vitthu zoohiiyi etthiipo, mwishukhurwele ethiito mwimpatthaaye.” ");
INSERT INTO eko_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nroromelo wa atthu khusala ovira weekezeleyaka oonaka yoori Yaahaya ti Al-Masiihu. ");
INSERT INTO eko_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ye khuwooza ooshi apale aariivo yoori: “Weekhweele miiyo kiniwoosanani maati, ila onta nkina ariina owahi wookiziti miiyo, wala akinsuhi ofukula mikhoyi za jampala zawe. Ye onteela owoosani na Rooho Ttakatthiifu na moottho. ");
INSERT INTO eko_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Onaaye fosholo mmakhono mwawe anttelaaye ophakulana tiriku na maveya. Athuule tiriku atthe vantthala vawe, maveya aya eeselele vamoottho ohinzimaaye.” ");
INSERT INTO eko_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Khwa mattakhuzi makina a waatta, Yaahaya aari owaahirimiza na owaatafusirela atthu hapari zooshapweya. ");
INSERT INTO eko_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Na khunshowera nsatoro Herooti mwaasa wonrala Herodiya muukha wa ttwiiye na oretta vitthu zootakhala za waatta. ");
INSERT INTO eko_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Elottelanaka Herooti khweekezela zooshi epile, khuruma ofukeliwa Yaahaya nkalapooso. ");
INSERT INTO eko_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wakathi Yaahaya aari owoosaavo atthu ooshi apale, Yinsa na-ye khuta attaaphale oteela woosiwa. Ye alompaka pinku khufukuwa, ");
INSERT INTO eko_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Rooho Ttakatthiifu khumwiishukhela nkhama jiwa. Khusiileya huula yoolankha pinkuuni eraka: “Weeyo o mwanaka kinuuphetachaaye na wookituvela channu.” ");
INSERT INTO eko_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yinsa wakathi aaziyeevo olaleya hapari zooshapweya, aarettiye arina nyaakha talaathiini. Ye aari mwaana wa Yuusufu nkhama etthiipo atthu aari waakanyeraazo, Yuusufu aari mwaana wa Heeli, ");
INSERT INTO eko_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heeli aari mwaana wa Mataati, Mataati aari mwaana wa Leevi, Leevi aari mwaana wa Melikhi, Melikhi aari mwaana wa Yanaayi, Yanaayi aari mwaana wa Yuusufu. ");
INSERT INTO eko_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yuusufu aari mwaana wa Matathiiya, Matathiiya aari mwaana wa Amooshi, Amooshi aari mwaana wa Nahuumu, Nahuumu aari mwaana wa Heshiili, Heshiili aari mwaana wa Nakhaayi, ");
INSERT INTO eko_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakhaayi aari mwaana wa Maathi, Maathi aari mwaana wa Matathiiya, Matathiiya aari mwaana wa Shemeeni, Shemeeni aari mwaana wa Yosheekhi, Yosheekhi aari mwaana wa Yuuda, ");
INSERT INTO eko_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yuuda aari mwaana wa Yohanaani, Yohanaani aari mwaana wa Reesa, Reesa aari mwaana wa Zorobabeeli, Zorobabeeli aari mwaana wa Sheyalitiyeeli, Sheyalitiyeeli aari mwaana wa Neeri, ");
INSERT INTO eko_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neeri aari mwaana wa Meelikhi, Meelikhi aari mwaana wa Aadi, Aadi aari mwaana wa Kosaamu, Kosaamu aari mwaana wa Elimadaamu, Elimadaamu aari mwaana wa Eeri, ");
INSERT INTO eko_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eeri aari mwaana wa Yoshuwa, Yoshuwa aari mwaana wa Eliyezeeri, Eliyezeeri aari mwaana wa Yoriimu, Yoriimu aari mwaana wa Mathaati, Mathaati aari mwaana wa Leevi, ");
INSERT INTO eko_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leevi aari mwaana wa Simiyooni, Simiyooni aari mwaana wa Yuuda, Yuuda aari mwaana wa Yuusufu, Yuusufu aari mwaana wa Yonaamu, Yonaamu aari mwaana wa Eliyakhiimu, ");
INSERT INTO eko_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakhiimu aari mwaana wa Meleeya, Meleeya aari mwaana wa Meena, Meena aari mwaana wa Matatha, Matatha aari mwaana wa Nathaani, Nathaani aari mwaana wa Daawuuda, ");
INSERT INTO eko_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daawuuda aari mwaana wa Yeese, Yeese aari mwaana wa Obeedi, Obeedi aari mwaana wa Bowaazi, Bowaazi aari mwaana wa Salimooni, Salimooni aari mwaana wa Nashooni, ");
INSERT INTO eko_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashooni aari mwaana wa Aminadabu, Aminadabu aari mwaana wa Adimiini, Adimiini aari mwaana wa Ariini, Ariini aari mwaana wa Hesherooni, Heshorooni aari mwaana wa Pereezi, Pereezi aari mwaana wa Yuuda, ");
INSERT INTO eko_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuuda aari mwaana wa Yaakhumpa, Yaakhumpa aari mwaana wa Esiyaakha, Esiyaakha aari mwaana wa Eburahiima, Eburahiima aari mwaana wa Teera, Teera aari mwaana wa Nahoori. ");
INSERT INTO eko_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahoori aari mwaana wa Serukhi, Serukhi aari mwaana wa Reewu, Reewu aari mwaana wa Peleekhi, Peleekhi aari mwaana wa Ebeeri, Ebeeri aari mwaana wa Saala, ");
INSERT INTO eko_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Saala aari mwaana wa Kayinaamu, Kayinaamu aari mwaana wa Arifwakisaati, Arifwakisaati aari mwaana wa Sheemu, Sheemu aari mwaana wa Nuuhi, Nuuhi aari mwaana wa Lameekhi, ");
INSERT INTO eko_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameekhi aari mwaana wa Methusaleemu, Methusaleemu aari mwaana wa Henookhi, Henookhi aari mwaana wa Yareeti, Yareeti aari mwaana wa Mahalaleeli, Mahalaleeli aari mwaana wa Kayinaamu. ");
INSERT INTO eko_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kayinaamu aari mwaana wa Enooshi, Enooshi aari mwaana wa Seethi, Seethi aari mwaana wa Adamu, Adamu wa Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yinsa aarutiye omuttho Yorotaani ari wa wiitaala Rooho Ttakatthiifu, aalokoziwe ti Rooho Ttakatthiifu ethiito mpakha makuluttu. ");
INSERT INTO eko_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nttumpho khuzayiniwa ti Sheethwani siikhu arupayiini. Siikhu zaya epile khaari oja etthu, nawiisha khunkhola jala. ");
INSERT INTO eko_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sheethwani khumuuza yoori: “Nkhama o mwaana wa Nnyizinku orume liwe nttho lithatuwe liiye phaawu.” ");
INSERT INTO eko_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ila Yinsa khunjipu araka: “Yaatikhiwa nkithaapu yoori: ‘Khahiyo phaawu paasi enimwinkhaaye ohaayi pinaatamu’.” ");
INSERT INTO eko_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sheethwani khunweza vatulu, nasaapiru khunnoza ofwalume wooshi w'oolumwenku. ");
INSERT INTO eko_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Khumuuza yoori: “Kintta owinkha ofwalume na siifwa z'oolumwenku opu wooshi, mwaasa yoori zooshi kenkhiwa miiyo, na miiyo kinimwinkha otule kinintakhelaaye. ");
INSERT INTO eko_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Amana okikokhorela miiyo na khukaaputu, zooshi zintta wiiya zaawo.” ");
INSERT INTO eko_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yinsa khunjipu yoori: “Nttakhuzi la Nnyizinku lalupa yoori: ‘Omwaaputu Mbwanaawo Nnyizinku na onrumeyele othuuto paasi.’” ");
INSERT INTO eko_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Aphano Sheethwani khunlawana Yeruzaleemu khunweza vatulu woolepavo wa Nyuupa ya Nnyizinku khumuuza yoori: “Nkhama o mwaana wa Nnyizinku ojeeselele vathi aphale, ");
INSERT INTO eko_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","maana yaatikhiwa nkithaapu yoori: ‘Ye ontta oruma malayikha awe awiinanele. ");
INSERT INTO eko_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Atthaapo antta wuukholelela na makhono aya yoori ohikwakwanttuwe valiwe.’” ");
INSERT INTO eko_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yinsa khunjipu yoori: “Nttakhuzi la Nnyizinku lalupa yoori: ‘Ohimweeze Mbwana Nnyizinku awo.’” ");
INSERT INTO eko_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sheethwani nawiisha onzayini wooshi, khumwaattuwa khusala awejela wakathi wonkhweyela. ");
INSERT INTO eko_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Aphano Yinsa khurutela Kalileya, owahi wa Rooho Ttakatthiifu ori vamote na-ye. Hapari zaari olupaaye monkoni wa ye khumwazeyela miti zooshi za nkerekhere. ");
INSERT INTO eko_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Aari osomisa mmanyupa woosifwiwamo Nnyizinku, atthu ooshi khusala anttottopela. ");
INSERT INTO eko_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Khulawa mpakha sitati ya Nazareeti ohali aleliweewo. Siikhu ya saapatu khweetta nnyupa woosifwiwamo Nnyizinku nkhama etthiipo aazowereliyeezo. Khulankha yoori asome. ");
INSERT INTO eko_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Khwinkhiwa kithaapu ya napiyu Ezaaya. Khufunula khusala athola khusikana vahali yaatikhiweevo yoori: ");
INSERT INTO eko_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Rooho ya Mbwana eri vamote na-miyo, akithawaza yoori kiwaatafusirele hapari zooshapweya asikhini na olaleya otaphuliwa wa anamahuzunikha, owoonisa apale oohooni, owaavumulisa apale oohukhumwiwa, ");
INSERT INTO eko_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na olaleya yoori wafiya mwaakha wa rehema ya Mbwana.” ");
INSERT INTO eko_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yinsa khufinikha kithaapu etile khumwinkha karumeya wa nnyupa woosifwiwamo Nnyizinku, Ye khwiikhala. Atthu ooshi apale aariimo khusala amweekesa. ");
INSERT INTO eko_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ye khuwooza yoori: “Leelo zarettikhana epile zaatikhiweeyo, etthiipi mwinttaaye wiisharu osiila.” ");
INSERT INTO eko_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Atthu ooshi khusala anttottopela, na khwiiya ootikinisiwa mwaasa wa mattakhuzi a rehema aari olankhaaye nkhanyo mwawe, khusala oozelana yoori: “Khahi mwaana wa Yuusufu otu?” ");
INSERT INTO eko_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yinsa khuwooza yoori: “Khweele khweele mweeyo mwinlawa mwakuuze kittaphi mmote enraaye toono: ‘Tothoro ojivonise omweenyewe! Orette mmuti mwawo mphu minjuza nisiiliyeeyo epile orettiyeezo Kafwaranawu.’” ");
INSERT INTO eko_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Khulupa theenya yoori: “Wookhweele kiniwuuzani yoori khaavo napiyu mmote ankhupaliwaaye mmuti mwawe. ");
INSERT INTO eko_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Na weekhwele wakathi wa napiyu Aliyaasi, Ezirayeele aariwo aakha oofweliwa pi amanna zaya wakathi yaafukiweevo pinku nyaakha mittatthu na nyeezi sitha, yaapuwiye jala miti zooshi. ");
INSERT INTO eko_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ila Nnyizinku khuhinrumi Aliyaasi Ezirayeele, okhule aari wiikhalaawo apale aya, khunruma Sarefathi tuniya ya Sitooni aariiwo muukha mmote woofweliwa ti mannawe. ");
INSERT INTO eko_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Siikhu za napiyu Elizeewu, Ezirayeele aariwo anamakuttula a waatta, khuhiivo hatha mmote aavonisiweeyo ila Naamani wa nti wa Siiriya ti ye aavonisiweeyo otthwe.” ");
INSERT INTO eko_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Atthu ooshi aari nnyupa woosifwiwamo Nnyizinku, n'oosiila mattakhuzi apale aari olupaaye Yinsa yo khwiiphiiriwa. ");
INSERT INTO eko_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Khwiikariwamo nsitati mphule khulawaniwa vamwaako yaajekiweevo sitati yaya etile, yoori ansukhumele vathi. ");
INSERT INTO eko_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ila Yinsa khuvira vakatthi vaya khusala alawa. ");
INSERT INTO eko_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Paata ya toole Yinsa khwiishukhela sitati ya Kafwaranawu, nti wa Kalileya, khusala awaanozela siikhu ya saapatu. ");
INSERT INTO eko_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yo aari ooshankisiwa na onozela wawe, mwaasa yoori nttakhuzi lawe laarina ofwalume. ");
INSERT INTO eko_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nnyupa woosifwiwamo Nnyizinku aarimo ntthu mmote aariina sheethwani. Aphano sheethwani khunyakula na kuvu zawe zooshi araka: ");
INSERT INTO eko_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Eeee! Onnitakhela-ni weeyo Yinsa wa Nazareeti? Wateela onankameza? Miiyo kinuujuwa weeyo yoori o Ttakatthiifu wa Nnyizinku!” ");
INSERT INTO eko_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yinsa ansukisiye sheethwani araka: “Nyamala, mwaattuwe ntthu oto!” Attaaphale sheethwani khunkwisela vathi ntthu otule atthu eettaka omoona, khuhinvulalisi khumwaattuwa. ");
INSERT INTO eko_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Atthu ooshi aari ooshankisiwa, khusala oozana atthaaporu: “Nttakhuzi-ni ntthi? Khwa ofwalume na owahi wawe otu onruma masheethwani khusaruwa!” ");
INSERT INTO eko_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Aphano siifwa ya Yinsa yaamwazeyeliye miti zooshi za nkerekhere. ");
INSERT INTO eko_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yinsa khusaruwamo nnyupa woosifwiwamo Nnyizinku khweetta owawe Simawu. Nkhwewe Simawu aari nlwele hooma, yo khunvekelaza Yinsa yoori anvonise. ");
INSERT INTO eko_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ye khwiinama khwiikara hooma etile khunlikha, nasaapiru nunu otule khulankha khusala awaarumeyela. ");
INSERT INTO eko_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Njuwa litupweelaka atthu ooshi apale aariina marati khusala atiiseliwa Yinsa, Ye n'oowaattheela makhono n'oowaavonisa. ");
INSERT INTO eko_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Theenya aarivo atthu a waatta aari owaasaruwaaye masheethwani anyakulaka araka: “Weeyo o mwaana wa Nnyizinku!” Yinsa khusala amaruwa alikhisaka masheethwani apale ottakhula, maana yo aari ojuwa yoori ye ti Al-Masiihu. ");
INSERT INTO eko_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","N'oocha Yinsa khulankha khusala alawa mmakuluttu. Atthu a waatta khusala amweekesa, n'onsikana khuhisala atakha onlikha olawa. ");
INSERT INTO eko_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ye khuwooza yoori: “Enhithajiya theenya miiyo olawa sitati kiina olaleya hapari zoofwalume wa Nnyizinku, kaperekheliwa etthiipo.” ");
INSERT INTO eko_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ye aari otafusiri mmanyupa woosifwiwamo Nnyizinku a Yudeya. ");
INSERT INTO eko_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Siikhu moote, Yinsa aari nshini wa ntthatta la Kalileya, khuzukuleliwa pi atthu a waatta yoori asiile nttakhuzi la Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ye khoona nyaatiya miwiri ziri vapatari wa ntthatta nttintthile, zaalikhiweevo pi anamajiya aari woosaaye matthavi aya. ");
INSERT INTO eko_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yinsa khupakhira mmwaatiya mmote waari wa Simawu khunvekela yoori asusisele mpahari, khwiikhala khusala awaanozela atthu. ");
INSERT INTO eko_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nawiisha onozela khumuuza Simawu yoori: “Othuule mwaatiya awo mwilawe vahali wa wiichavo mwajiye.” ");
INSERT INTO eko_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simawu ajipwaka khuri: “Mbwana, najiya osikhu na osikhu khuhipatthi etthu, wiiya walupa yoori neese, nintta weesa.” ");
INSERT INTO eko_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Yo khulawa khweesa matthavi aya khuula swi za waatta mpakha khusala avaruwa matthavi aya. ");
INSERT INTO eko_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Khuwaakhuwela ashirikhaaya aari mwaatiya nkina yoori ate arinkaanyele, khwiitaaza nyaatiya zaya zoomiwiri mpakha osaleela ozama. ");
INSERT INTO eko_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simawu Peeturu nawoona etthu etile yaarettikhaniyeeyo, khunkokhorela Yinsa amuuzaka yoori: “Mbwana, okisuse maana miiyo ki natwampi.” ");
INSERT INTO eko_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simawu na ashirikhaawe khuzinkuwa mwaasa wa swi epile za waatta apatthiyeezo. ");
INSERT INTO eko_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yaakhumpa na Yaahaya, aana a Zebedayo, ashirikha a Simawu aari ojiyanaaye khwiiya ootikinisiwa. Aphano Yinsa khumuuza Simawu yoori: “Ohoove, waaza nasaapi eti onttela wiiya namajiya wa atthu.” ");
INSERT INTO eko_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Khuwelelisa nyaatiya zaya nkulu, khulikha vitthu zaya zooshi khusala anlotta Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yinsa ari sitati moote, khuvira mwinyi mmote aariina makuttula. N'oomoona Yinsa khukokhora khusijiti khumuuza araka: “Kinuuvekela yoori nkhama watakha Mbwanaaka, kivonise.” ");
INSERT INTO eko_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ye khookola nkhono awe khunsapa khumuuza yoori: “Katakha vona!” Wakathi otthuupule khweele khuvona. ");
INSERT INTO eko_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yinsa khumuuza yoori: “Vitthu epi ohimuuze hatha ntthu, ila olawe wajithoonyeze wa haakhimu wa tiini, othuuto oorettele twaha yoovonisiwa wawo nkhama etthiipile alupiyeezo napiyu Munsa, yoori wiiye oshaahiti vakatthi wa atthu aya apale.” ");
INSERT INTO eko_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Aphano hapari zawe zaari ovira zimwazeyaka. Atthu a waatta khusala ata oteela osiila hapari, na oteela ovonisiwa marati aya. ");
INSERT INTO eko_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yinsa aari olaakavo n'oolawa makuluttu olompa. ");
INSERT INTO eko_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Siikhu moote Yinsa eetta onozela, apho vaya aari onozelaavo aarivo mafwarizeewu na anamanozela a kano aalankhiyeeyo miti mikina za Kalileya na Yudeya mpakha Yeruzaleemu. Owahi wa Mbwana waari vamote na-ye woowaavonisa alwele. ");
INSERT INTO eko_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Aphano atthu akina khuntana mwinyi aariina supiyaani anttattikheliye vanrepa, yo aari otakha omphenyisa ampwehe omaasho wa Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ila nawoona yoori khayiivo kiphenyo mwaasa wa atthu waatta, khuwela vatulu wa nyuupa khutamula liphala khumwiishushela vakatthi wa atthu omaasho wa Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ye nawoona amini aariina atthu apale, khumuuza nasupiyaani otule yoori: “Swaahipu twampi zawo zaswaamihiwa.” ");
INSERT INTO eko_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Aphano mafwarizeewu na anamanozela a kano khusala attettha araka: “Otu aya paani ankufurwaaye? Ti paani anwahaaye oswaamihi twampi woohiiyi Nnyizinku?” ");
INSERT INTO eko_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yinsa khujuwa etthu aari ofikhiraaye, khuwoozela yoori: “Mwashukulikhela-ni nroho mwenu? ");
INSERT INTO eko_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yookhweya ti tiivi omuuza yoori twampi zawo za swaamihiwa ama yoori olankhe weettette? ");
INSERT INTO eko_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Apho mwijuwe yoori Mwaana wa Pinaatamu onaaye owahi wooswaamihi twampi vathi apha.” Khumuuza nasupiyaani otule yoori: “Olankhe othuule nrepa lawo olawe owawo.” ");
INSERT INTO eko_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nasaapiru ntthu otule khulankha vakatthi wa atthu khuthuula nrepa lawe ntthile aattattikheliweevo khusala alawa owawe ansifwaka Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Atthu ooshi aariivo khwiiya ooshanka na woova channu, khusala ansifu Nnyizinku araka: “Leelo noona vitthu zootikinisa.” ");
INSERT INTO eko_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Paata yawiisha vitthu epile, Yinsa khulankha khusala alawa, khunsikana mwinyi mmote aari oriphisaaye lumpuru aari wiitthiwaaye Leevi eekhaliye vahali aari oriphisaavo malumpuru awe, khumuuza yoori: “Okilotte.” ");
INSERT INTO eko_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ye khulikha khaazi zawe zooshi khusala anlotta. ");
INSERT INTO eko_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Leevi khuretta njampo liwululene owawe vamote na Yinsa, aarivo theenya anamariphisa lumpuru akinoko aya na atthu akina eekhaliye vamote na-ye. ");
INSERT INTO eko_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mafwarizeewu na anamanozela a kano khusala a waattakhula anakhiyoni a Yinsa araka: “Mwaasa aya niini mweeyo mwijanaka na mwinywanaka anamariphisa malumpuru na anatwampi?” ");
INSERT INTO eko_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yinsa khuwaajipu araka: “Akumi khanlawaniwa wa tothoro ila alwele, ");
INSERT INTO eko_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","miiyo akaawaateeliye anashariya kaawaateeliye anatwampi yoori alikhe oretta twampi.” ");
INSERT INTO eko_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Atthu akina khumuuza Yinsa yoori: “Anakhiyoni a Yaahaya Namoosa na anakhiyoni a mafwarizeewu amfuka na anlompa, ila awo weeyo khamfuka, antta oja na onywa.” ");
INSERT INTO eko_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yinsa khuwaajipu yoori: “Enrettikhana toovi owooza anamalaleyiwa harusi ofuka namaposa arivo? ");
INSERT INTO eko_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ila onteela ofiya wakathi mposi anttelaaye olaziwavo vakatthi vaya, wakathi aya opo, anteela ofuka.” ");
INSERT INTO eko_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Elottelanaka Yinsa khulupa nlikaniso mmote araka: “Khaavo anshijaaye patakha ya kuwo pheeya yoori arette yaapa ya kuwo yoovutta, n'ooretta toowo etile pheeya entta oharipweya, mwaasa wa patakha etile ya kuwo pheeya etthiiweevo oheezani na etile yoovutta. ");
INSERT INTO eko_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Khaavo anthuulaaye viinyu pheeya ottha nttompwiyo ya shapala ya raku. N'ooretta toowo entta ophutuwa, viinyu ya yiittikhe ttompwiyo zaya ziharipweye. ");
INSERT INTO eko_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Viinyu pheeya entthiiwa nttompwiyo pheeya. ");
INSERT INTO eko_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Khaavo anraaye anywiye viinyu ya raku khutakha onywa viinyu pheeya, maana ontta olupa yoori: ‘Poora etile ya raku.’” ");
INSERT INTO eko_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Saapatu moote, Yinsa eetta ovira nshini wa nshapa la tiriku. Anakhiyoni awe khusala avurula asusuraka na makhono arafunaka phunje zaya. ");
INSERT INTO eko_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mafwarizeewu khusala awoozela yoori: “Mwaasa aya niini mwirettaka vitthu ziiyiye mwiikho orettiwa saapatu?” ");
INSERT INTO eko_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ye khuwaajipu araka: “Khamwinasome etthu aarettiyeeyo Daawuuda wakathi yankholiyeevo jala na ashirikha awe? ");
INSERT INTO eko_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ye aaviriye Nnyupa wa Nnyizinku khuthuula phaawu zoohalaalishiwa khurafuna kiina khuwenkha ashirikhaawe, ila alupa aarina ruhusa yoorafuna aari mahaakhimu a tiini paasi.” ");
INSERT INTO eko_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yinsa khulupa araka: “Mwaana wa pinaatamu ti Mbwana mwennyewe saapatu.” ");
INSERT INTO eko_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Saapatu kiina, Yinsa khuvira nnyupa woosifwiwamo Nnyizinku khusala awaanozela, aarimo mwinyi mmote waarakaliyeeyo nkhono nlume. ");
INSERT INTO eko_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Anamanozela a kano na mafwarizeewu eetta omweekesela yoori amoone Yinsa nkhama aari onvonisa siikhu ya saapatu, yoori ankwisele paathuli. ");
INSERT INTO eko_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ila ye aari ojuwa etthu aari wuupuwelaaye atthu apale. Khumuuza mwinyi otule woorakala nkhono nlume yoori: “Olankhe ote vakatthi apha.” Mwinyi khulankha khweemela. ");
INSERT INTO eko_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Aphano Yinsa khuwoozela yoori: “Ensuhaaye orettiwa saapatu ti tiivi? Yooshapweya ama yootakhala, wuusuru ama wuula?” ");
INSERT INTO eko_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Khuweekesa atthu ooshi apale aariivo khumuuza mwinyi otule yoori: “Wookole nkhono awo.” Ye khookola, khuvona. ");
INSERT INTO eko_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Anamanozela a kano na mafwarizeewu khwiiphiiriwa khusala awaza etthu yonrettela Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Siikhu zaya epile Yinsa khulankha khusala alawa omwaako olompa, khwiisha osikhu wooshi eettaka olompa. ");
INSERT INTO eko_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","N'oocha khuwaakhuwela anakhiyoni awe khuwaathawula khumi na awiri, atthaapo theenya khuwenkha nzina la owaaswihaapa. ");
INSERT INTO eko_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simawu antthajiye nzina la Pheeturu, Antere ttwiiye Simawu, Yaakhumpa, Yaahaya, Filiipe, Paturumeewu. ");
INSERT INTO eko_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateewuzhu, Tome, Yaakhumpa mwaana wa Alufayo na Simawu aniitthiwaaye Zelooti, ");
INSERT INTO eko_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuuda mwaana wa Yaakhumpa, na Yuuda Iskariyooti otule aari weettelaaye onkholisa Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yinsa khwiishukha vamwaako na maaswihaapa awe khweemela nshini wa mwaakho vahali aariivo anakhiyoni awe na khuntti ya atthu a Yudeya yooshi na a Yeruzaleemu, mpakha apale a miti za waattamela pahari, Tiiro na Sitooni. ");
INSERT INTO eko_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Apale aateeliyeeyo osiila na ovonisiwa moolwele aya, mpakha na apale aari wantipwiwaaye ti masheethwani aari ovonisiwa. ");
INSERT INTO eko_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Atthu ooshi aari otakha onsapa Yinsa mwaasa yoori waari onsaruwa owahi khusala owaavonisa ooshi. ");
INSERT INTO eko_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Aphano Yinsa khulansa maasho khuweekesa anakhiyoni awe khuwooza yoori: “Ananshapweyiwa ti mweyo mwiiyiye asikhini, maana Ofwalume wa Nnyizinku pu weenu. ");
INSERT INTO eko_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ananshapweyiwa ti mweyo enuukholaanini jala aphano, maana mwinlawa mwarupale. Ananshapweyiwa ti mweyo mwinlilaaye aphano, maana mwinteela otheya. ");
INSERT INTO eko_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ananshapweyiwa ti mweyo, mmana atthu eephiiriwaka ti mweyo, awiikarani, oottukhanani na khuwoonani ohifwayi mwaasa wonlotta Mwaana wa Pinaatamu. ");
INSERT INTO eko_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Wakathi aya otthuupo, mwiiye woofurahi na mwitthape, maana tthuvo yenu eniiya khuluyeene pinkuuni. Maana wa nanna etthiipi, apapa zaya na-yo aawaaretteliye manapiyu. ");
INSERT INTO eko_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ila olaanikha pu weenu mweeyo mwaamathaajiri, maana mwapokhera tthuvo yenu vathi attaapha. ");
INSERT INTO eko_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Olaanikha pu weenu mweeyo ziwiitaaleliyeenini vitthu-zoojiwa, maana mwinteela okholiwa ti jala. Olaanikha pu weenu mweeyo mwiriina furaha eleelo eti, maana mwinteela ojikhupanyera na olila. ");
INSERT INTO eko_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Olaanikha pu weenu mweeyo mmana mwittottopeliwaka pi atthu ooshi, maana apapa zaya aawaaretteliye etthiipo manapiyu oojipanka. ");
INSERT INTO eko_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Nakataalikha mweeyo mwinikisiilaaye, kiniwuuzani yoori mwiwaaphete maatuwi enu, mwiwaarettele saana apale aniiphiiriwaaye ti mweyo. ");
INSERT INTO eko_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mwiwaaparikhiye apale anuulaanaanini na mwiwaalompele apale anuurettelaanini zootakhala. ");
INSERT INTO eko_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nkhama ntthu oopwakula nlaku limote, na ntthi likina ontheteezele. Nkhama ntthu oovula juupa yawo, ohinkhattaze othuula hempe yawo. ");
INSERT INTO eko_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Omwinkhe wakhula otule anuuvekelaaye, nkhama ntthu athuula etile yiiyiye yaawo, ohinkhanyarele wuurutisela. ");
INSERT INTO eko_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Epile mweeyo zinuutuvelaanini oretteliwa pi azeenu, na-mweyo mwiwaarettele azeenu etthiipo. ");
INSERT INTO eko_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Amana mwiwaaphetaka apale anuuphetaanini paasi, fwayita-ni mwineekeselaaye mmakhono wa Nnyizinku? Hatha anatwampi atthaapo aniwaapheta apale na-yo aniwaaphetaayo. ");
INSERT INTO eko_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Amana mwiwaarettelaka saana apale na-yo anuurettelaanini saana paasi, fwayita-ni mwinteelaaye wiiyana? Hatha anatwampi atthaapo na-yo anretta etthiipo. ");
INSERT INTO eko_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Amana mwiweepaashaka paasi apale mwinkhupalaaye wuurutiselani, fwayita-ni mwinteelaaye wiiyana? Hatha anatwampi atthaapo aniipaashana aroromelaka orutiselana. ");
INSERT INTO eko_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mwiwaaphete maatuwi enu, mwiwaarettele zooshapweya, mwiweepaashe mwiheekeselaka wuurutiselani. Toowo tthuvo yenu enttela wiiya khuluyeene na mwinttela wiiya aana a Nnyizinku Wooziti, maana Nnyizinku oniwaashapweyela rooho hatha na apale ahininshukhurwaaye na alupa ootakhala rooho. ");
INSERT INTO eko_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mwiiye woohurumiya nkhama etthiipi Papeenu wa pinkuuni na-ye eeyiye wa huruma. ");
INSERT INTO eko_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mwihimphuke ntthu nzeenu na Nnyizinku khanuuphukani, mwihinhukhumu ntthu nzeenu na Nnyizinku khanuuhukhumuni. Mwinswaamihi ntthu nzeenu na Nnyizinku ontta wuuswaamihini. ");
INSERT INTO eko_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mwiwenkhe azeenu na Nnyizinku ontta owinkhani: na mphimo khwaamili, wookhitteleliwa na wa wiitaala mpakha wiittikha. Maana mphimo otthuupo mwimphimanaaye na-mweyo mwinteela ophimeliwa otthuupo.” ");
INSERT INTO eko_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yinsa khulupa nlikaniso mmote araka: “Atthu oohooni khanlokozana, antta okwiselana nliphotto. ");
INSERT INTO eko_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nakhiyoni khaninziti mwanliimu awe, ila wakhula otule ansomiseyaaye saana oniiya nkhama mwanliimu awe. ");
INSERT INTO eko_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Onri je woona etutu eriiye mmaasho wa nzaawo ohoonaka muutthi opule oriiye mmaasho mwawo? ");
INSERT INTO eko_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Enrettikhana toovi weeyo omuuzaka nzaawo yoori: ‘Ttwiiyaku, nkankaani kuulaze etutu eto eriiye mmaasho mwawo,’ na khupe weeyo ohiwahaka woona muutthi opule oriiye mmaasho mwawo? Naafikhi! Olazemo khapula muutthi oriiye mmaasho mwawo, toowo ontta woona saana, na phi onlazaamo etutu eriiye mmaasho wa nzaawo.” ");
INSERT INTO eko_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Khawiivo muutthi wooshapweya oniimaaye mishumo zootakhala, wala muutthi wootakhala oniimaaye mishumo zooshapweya. ");
INSERT INTO eko_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Maana wakhula muutthi onjuweya mwaasa wa mishumo zaya; nnyiiwa khinshumiwamo mishumo za muuyu, mmutthalala khanshumiwamo wuuva. ");
INSERT INTO eko_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ntthu wookemaani, nroho mwawe onsarulamo vitthu zooshapweya, na ntthu wootakhala rooho, nroho mwawe onsarulamo vitthu zootakhala, maana milomo zawe zinttakhula etthiipile ziitaaliyeeyo nroho mwawe. ");
INSERT INTO eko_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Mwinkikhuwelela-ni yoori ‘Mbwana, Mbwana’, mwihirettaka epile kiniwuuzaanini? ");
INSERT INTO eko_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Miiyo kinuuthoonyezani ntthu anlikananaaye otule ansiilaaye mattakhuzi aka na khushututela. ");
INSERT INTO eko_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Onlikanana ntthu ajekaka nyuupa yawe khuthipa khwiichisa saaneene khutha vanchina la mawe woozivalavo. Khuta nnyeri khupiya nyuupa etile ila khuhisakhinyeyi mwaasa woozivalisiwa. ");
INSERT INTO eko_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ila otule ansiilaaye mattakhuzi aka khuhishututeli onlikanana ntthu ajekiye nyuupa yawe vanshaka woohizivalivo. Khuta nnyeri khupiya nyuupa etile nasaapiru khukwa, khupwecheya khuhisali hatha etthu.” ");
INSERT INTO eko_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Eeshiyeevo mattakhuzi apale aari owoozaaye atthu, khweetta sitate ya Kafaranawu. ");
INSERT INTO eko_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ottuukho aariwo namalokozela mmote wa anajanka w'eerooma, aariina karumeyaawe wompheta aari olwaaziwaaye khusala asaleela ofwa. ");
INSERT INTO eko_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Wakathi namalokozela wa anajanka otule asiiliyeevo monkoni wa Yinsa, khuwaaperekha attunkhulu akina amayaahuuti yoori anvekele Yinsa ate anvonise. ");
INSERT INTO eko_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Yo n'onsikana khunvekela wookhanyarelavo araka: “Mwinyi oto onsuhi waawuniwa, ");
INSERT INTO eko_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","mwaasa yoori oniiya owaapheta atthu etthu na anijekela nyuupa yoosifwiwamo Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Aphano Yinsa khulankha khusala alawa vamote na-yo, asaleelaka ofiya, namalokozela otule khuwaaruma ashirikha awe olawa omuuza yoori: “Mbwana, ohijantipu khinsuhi weeyo ovira nnyupa mwaka. ");
INSERT INTO eko_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ti eto miiyo kinoona yoori akinsuhi okutthanana weeyo, ila olupe nttakhuzi limote paasi karumeyaaka ontta ovona. ");
INSERT INTO eko_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Miiyo kinaaye afwalume akizitiyeeyo, ila na miiyo theenya kinaaye anajanka ankishututelaaye. Kinimuuza najanka mmote yoori: ‘Olawe’, khulawa; nkina yoori: ‘Aruti’, khuruti. Kinimuuza karumeyaaka yoori: ‘Retta eti’, ye khuretta.” ");
INSERT INTO eko_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yinsa asiiliyeevo mattakhuzi apale khwiiya wooshanka, khuzukuluwa khuwooza atthu apale aari omperekhaaye yoori: “Hatha Ezirayeele ottuukho akooneeniwo amini nkhama eti.” ");
INSERT INTO eko_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ashirikha apale aarumiweeyo khurutela owawe namalokozela otule, khunsikana karumeya otule avoniye. ");
INSERT INTO eko_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mmeesho mwaya Yinsa khulankha khusala alawa sitati ya Nayiini, anakhiyoni awe na khuntti ya atthu a waatta khusala enlotta. ");
INSERT INTO eko_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Asaleelaka ofiya vanlako wa sitati etile, khusala asaruwa atthu aari weettelaaye ozikha. Otule aari weettelaaye ozikhiwa aari mwaana wa nunu mmote woofweliwa ti mannawe, ye aarina mwaana mmote othuuto paasi; atthu a waatta aari olawa vamote na-ye. ");
INSERT INTO eko_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Wakathi Mbwana Yinsa amooniyeevo nunu otule, khumoonela huruma khunkhuwela khumuuza yoori: “Ohilile!” ");
INSERT INTO eko_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Aphano khuwaasusela khusapa janaayiza, apale aathuuliyeeyo khweemela. Yinsa khulupa araka: “Shapu! Kinuuruma yoori olankhe!” ");
INSERT INTO eko_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Shapu otule khulankha khwiikhala khusala attakhula; Yinsa khumwinkha mamaawe. ");
INSERT INTO eko_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Atthu ooshi khwiiya awoova khusala ansifu Nnyizinku araka: “Napiyu nwulweene aniteela, ninoona yoori Nnyizinku aateeliye owuusuru atthu awe.” ");
INSERT INTO eko_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hapari epile za Yinsa khumwazeyela Yudeya yooshi mpakha miti epile zaattamananiyeeyo. ");
INSERT INTO eko_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yaahaya khuuziwa pi anakhiyoni awe vitthu epile zooshi. Ye khuwaakhuwela awiri, ");
INSERT INTO eko_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","khuwaaruma yoori alawe amuuzele Mbwana yoori: “Weeyo ti otu naari onwejaaye ama ninweje nkina?” ");
INSERT INTO eko_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Yo khulawa mpakha ottuukhule aariiwo Yinsa khumuuza yoori: “Neetta orumiwa ti Yaahaya yoori nite niwuuzele nkhama otule naari onwejaaye ti weyo, ama nivire ninwejaka nkina?” ");
INSERT INTO eko_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wakathi otthuupule Yinsa khuwaavonisa alwele a waatta, anamarakala, apale aariina masheethwani, khuwaafunula maasho apale oohooni. ");
INSERT INTO eko_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Aphano Yinsa khuwaajipu yoori: “Mwilawe mwamuuze Yaahaya etthiipo mooniyeezo na mwisiiliyeezo; apale oohooni antta woona, apale oorakala antta weettetta, anamakuttula antta otwahareshiwa, apale oohisiili ansiila, anamfwa asisimuliwa, na hapari zooshapweya antta olaleyeliwa asikhini. ");
INSERT INTO eko_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Wooshapweyiwa ti otule ahiniphiiriwaaye ti miiyo.” ");
INSERT INTO eko_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Anakhiyoni a Yaahaya n'oolaavo, Yinsa khusala owoozaka atthu monkoni wa Yaahaya yoori: “Makuluttu mweetteliye woona niini? Tteetthe yiinisiwaka ti pheevo? ");
INSERT INTO eko_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ama moona niini? Mwinyi mmote awaliye kuwo zooshapweya? Apale anwalaaye kuwo zootafikhana aniiya nraaha na aniikhala nkorofwa y'oofwalume. ");
INSERT INTO eko_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Khi moona niini? Napiyu? Pi etthiipo kiniwuuzani yoori, Yaahaya awaaziti manapiyu akinoko aya. ");
INSERT INTO eko_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Otu ti otule laari onlupaaye Nttakhuzi la Nnyizinku yoori: ‘Kinlawa kamperekhe karumeyaaka omaasho wawo yoori aattalele tarikhi yawo.’ ");
INSERT INTO eko_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Miiyo kiniwuuzani yoori vakatthi wa apale avokoliweeyo pi aakha, khina mmote anzitiyeeyo Yaahaya; ila otule eeyiye nttitthiiru muufwalume wa Nnyizinku, nwulweene zayita ye.” ");
INSERT INTO eko_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Atthu ooshi mpakha anamariphisa lumpuru khusiila mattakhuzi a Yinsa. Yo khukhupalela shariya ya Nnyizinku, maana aari awoosiwa ti Yaahaya. ");
INSERT INTO eko_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ila mafwarizeewu na anamanozela a kano khukhijilela matakhelo a Nnyizinku khuhoosiwi ti Yaahaya. ");
INSERT INTO eko_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Anaatamu apa a leelo eti kiwaalattisane niini? ");
INSERT INTO eko_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Alattanana khuntti ya asimaana eekhaliye vaparasa akhuwelanaka araka. ‘Fweeyo n'oovumiselani phivi za vaharusi mweeyo khuhiini; khwiipa liipo la huzuni mweeyo khuhilili.’ ");
INSERT INTO eko_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Khuta Yaahaya Namoosa woofuka na ahinnywaaye viinyu, mweeyo mwinri: ‘Ye onaaye masheethwani.’ ");
INSERT INTO eko_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ata Mwaana wa Pinaatamu onja na onnywa, mweeyo mwinri: ‘Mmoone nsokho otu! Nanhapaliwa, nshirikha wa anamariphisa lumpuru na anatwampi.’ ");
INSERT INTO eko_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Apale anlottaaye ojuwa wa Nnyizinku, anthoonyeza yoori pi wookhweeli.” ");
INSERT INTO eko_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mfwarizeewu mmote anvekeliye Yinsa yoori alawe aje owawe. N'oofiya Yinsa khwiikhala yoori aje. ");
INSERT INTO eko_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Omuuta otthuupule muukha mmote wa natwampi wa sitati ethiitile, khujuwa yoori Yinsa ontta oja wa mfwarizeewu, khuthuula suupha yawe ya mafuttha oonukhela. ");
INSERT INTO eko_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Khulawa khweemela onyoko wa Yinsa nshini wa moolu awe khusala alila. Mishozi zawe khusala zittonkela moolu a Yinsa. Khusala akukuttha na nyuuli zawe na opejari moolu a Yinsa avaazaka mafuttha oonukhela. ");
INSERT INTO eko_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Aphano mfwarizeewu otule nawoona vitthu epile khusala alupa nroho mwawe araka: “Otu eriwaka aari napiyu eetta ojuwa yoori mwanankha otu aninsapaaye natwampi.” ");
INSERT INTO eko_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yinsa khumuuza Simawu yoori: “Kintakha owuuza etthu.” Simawu khujipu yoori: “Kuuzeni mwanliimu.” ");
INSERT INTO eko_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yinsa khumuuza yoori: “Atthu awiri eetta wiiliwa nzurukhu ti mwinyi mmote aari wiipaashisakaaye, otu mmote aari wiiliwa miiya thaanu, otu nkina aari wiiliwa hamusiini. ");
INSERT INTO eko_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ila oowiiri khuhiivo mmote aawahiyeeyo onripha, ye khuwaaswaamihi oowiiri. Atthu apa awiri amphetachiyeeyo ti tuuvi?” ");
INSERT INTO eko_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simawu khujipu araka: “Kinoona yoori ti otule aswaamihiweeyo wa waattavo.” Yinsa khumuuza yoori: “Walikanisa.” ");
INSERT INTO eko_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ye khumuuza Simawu anthoonyezaka muukha otule araka: “Onimoona mwanankha otu? Miiyo kata vaje vawo apha khuhikinkhi hatha maati yoori koose moolu aka, ila ye oosa moolu aka na mishozi zawe khukukuttha na nyuuli zawe. ");
INSERT INTO eko_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Khukipokhereleeni na peeju, ila ye khalikheleleeni opejari moolu aka. ");
INSERT INTO eko_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Khukivaazeeni mafuttha oonukhela mmwishwa mwaka, ila otu avaaza mafuttha moolu aka. ");
INSERT INTO eko_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pi apho kiniwuuzaaye yoori twampi zawe epile za waatta ariinaazo za swaamihiwa; mwaasa woophetacha wawe. Ila otule aswaamihiweeyo vattitthiiru opheta wawe vattitthiiru.” ");
INSERT INTO eko_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yinsa khumuuza mwanankha otule yoori: “Twampi zawo za swaamihiwa.” ");
INSERT INTO eko_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Apale eekhaliyeeyo khusala oozelana yoori: “Otu paani anwahaaye owaaswaamihi twampi atthu.” ");
INSERT INTO eko_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ila Yinsa khumuuza muukha otule yoori: “Waamini wawo wa wuusuru: olawe na heeri.” ");
INSERT INTO eko_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Paata ya toole, Yinsa khusala eettetta sitati khwa sitati na nti khwa nti alaleyaka hapari zooshapweya zoofwalume wa Nnyizinku. Anakhiyoni awe apale khumi na awiri aari vamote na-ye, ");
INSERT INTO eko_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","na aakha akinoko aya apale aavonisiweeyo masheethwani na marati: Mariyamu aari wiitthiwaaye Mataleena, otule ansaruwiyeeyo masheethwani sapa, ");
INSERT INTO eko_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","na Zhuwaana muukha wa Kuuza, nsatoro wa Herooti, Suzaana na aakha akinoko aari ontthanttaaye Yinsa na vitthu zaya vamote na anakhiyoni awe. ");
INSERT INTO eko_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Phantte za waatta za miti aari otawo atthu enkeene oteela okutthanana Yinsa. Aphano ye khulupa nlikaniso mmote araka: ");
INSERT INTO eko_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Aarivo namazala mmote aalawiiye ozala peewu zawe. Amwazaka, kinoko khukwela nshini wa tarikhi, khuluwatthiwa na khujiwa pi anyannyi. ");
INSERT INTO eko_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Peewu kinoko khukwela vahali aariivo mawe, khoottha ila khuuma mwaasa woohiivo maati. ");
INSERT INTO eko_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Peewu kinoko khukwela vanyiiwa, khuwula vamote na nyiiwa, khurapeliwa pi nyiiwa khufwa. ");
INSERT INTO eko_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ila peewu kinoko khukwela vanshaka wooshapweya, khuwula khwiima mishumo miiya wakhula peewu.” Alupiyeevo toole, ye khukhuwelela araka: “Ariina mashiilo ti asiile!” ");
INSERT INTO eko_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Anakhiyoni awe khumuuzela maana a nlikaniso aya opule. ");
INSERT INTO eko_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yinsa khuwaajipu yoori: “Mweeyo mwenkhiwa ojuwa zootikinisa zoofwalume wa Nnyizinku, ila akinoko anuuzaniwa nlikaniso yoori oonaka ahisala ajuwa, asiilaka ehisala eweeleya.” ");
INSERT INTO eko_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Maana a nlikaniso opu pi toono: peewu eti enthoonyeza nttakhuzi la Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Peewu zaakweliiye ntarikhi, zinlikanisaniwa atthu apale ansiilaaye nttakhuzi la Nnyizinku ila sheethwani khulazavo varoho vaya nttakhuzi ntthile yoori ahaamini apattha wuusurukha. ");
INSERT INTO eko_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Peewu epi zaakweliiye vamawe, zinlikanisaniwa atthu apale ansiilaaye nttakhuzi la Nnyizinku khupokherela na furaha. Ila mwaasa woohiina mitathaari, wakathi vattitthiiru nawootootiwa ti sheethwani anlikha waamini waya. ");
INSERT INTO eko_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Peewu epi zaakweliiye vanyiiwa, zinlikanisaniwa atthu apale ansiilaaye nttakhuzi la Nnyizinku, ila mwaasa wooshukulikhela opattha tuvela na haali za meekhazi, yo waamini waya vattiitthi-vattiitthi onzima, ahifiyelelaka wiima mishumo. ");
INSERT INTO eko_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Peewu epi zaakweliiye vanshaka wooshapweya, zinlikanisaniwa atthu apale ansiilaaye nttakhuzi la Nnyizinku khuthokorela nroho mwaya khushututela na khwiiyana niiya, apo aniima mishumo zooshapweya. ");
INSERT INTO eko_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Khaavo ankhozaaye khantteya khufinikha na enyipo wala khupweha nlivuku. Entthiiwa vahali onooneyaavo yoori esala ewaamwasikhela apale anviraaye nnyupa. ");
INSERT INTO eko_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Khayiivo envithiwaaye ehinttelaaye osaruwela oje, zooshi epile za siiri enttela wiiya payana. ");
INSERT INTO eko_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Apho mwiyane ophoole wa nanna yoosiila, otule ariina ontta weekezeliwa, ila otule ahina hatha na etile anuupuwelelaaye wiiyana ontta onyakanyiwa. ");
INSERT INTO eko_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mamaawe na attwiize Yinsa khulankha yoori amoone, ila khuhisala ewaheya mwaasa yoori aarivo atthu a waatta. ");
INSERT INTO eko_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Khuuziwa Yinsa yoori: “Vaje apho atavo mamaawo na attwiizo.” ");
INSERT INTO eko_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ye khuwaajipu araka: “Maama na attwiizaku pi apale ansiilaaye Nttakhuzi la Nnyizinku khushututela.” ");
INSERT INTO eko_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Siikhu moote, Yinsa khuwooza anakhiyoni awe yoori: “Olawa neette phantte ya kaapu kinoko.” Khupakhira nkalawa khusala alawa. ");
INSERT INTO eko_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Aphano eettaka olawa Yinsa khusala alala, khupuwa pheevo ya waatta kalawa khusala esaleela ozama. ");
INSERT INTO eko_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Anakhiyoni apale khoova khusala anlansa Yinsa araka: “Mwanliimu, Mwanliimu nasaleela ozama!” Yinsa khulankha khunyamaza pheevo na mawipi, khupuwa nreke. ");
INSERT INTO eko_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nawiisha khuwoozela anakhiyoni awe yoori: “Waamini wenu ori vayi?” Yo khwiiya awoova na ooshanka khusala oozelana, araka: “Otu aya paani anrumaaye pheevo na mawipi khunshututela?” ");
INSERT INTO eko_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yinsa na anakhiyoni awe khulankha khulokhela Keraaza, kaapu ya Kalileya. ");
INSERT INTO eko_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Wakathi Yinsa apakhuwiweevo nkalawa, khuta nlume mmote wa sitati ethiitile aariina masheethwani a waatta. Ye eekhaliye siikhu za waatta ahiwalaka kuwo na ahiikhalaka vaje, aari wiikhala mvilalo. ");
INSERT INTO eko_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","N'oomoona Yinsa khunyakula, khunkokhorela khukhuwa araka: “Onkitakhela-ni, Yinsa mwaana wa Nnyizinku Nwulu wa Pinkuuni? Safwatali ohikihukhumu.” ");
INSERT INTO eko_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ye aalupiye mattakhuzi apa mwaasa yoori Yinsa aarumiye onsaruwa masheethwani. Masheethwani apale eekhaliye siikhu za waatta mmwiili wa nlume otule. Na afukaniwaavo makwinjili khwinkhiwa atthu oomweekesela, eetta ottumulaka n'oothuuliwa pi masheethwani n'onlawana makuluttu. ");
INSERT INTO eko_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Aphano Yinsa khumuuzela yoori: “Weeyo nzina lawo o paani?” Ye khujipu yoori: “Miiyo nzina laka ki omathi,” mwaasa yoori ntthu otule aamweettiye masheethwani a waatta mmwiili mwawe. ");
INSERT INTO eko_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Masheethwani apale khusala anvekela Yinsa yoori ahiikarele khilintti. ");
INSERT INTO eko_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Liphanko liwululene la kuluwe laari oshukisiwa vamwaako, masheethwani apale khunvekela ruhusa Yinsa yoori eette nkuluwe, ye khukhupalela. ");
INSERT INTO eko_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Wakathi aliiyeemo masheethwani apale mmwiili wa nlume otule khweetta nkuluwe, aphano kuluwe khusala zitthira ziishukhela vantthatta khutupweela. ");
INSERT INTO eko_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Apale aari oshukisaaye kuluwe epile nawoona vitthu epile zaarettikhaniyeezo, khutthira khulawa khulupa hapari epile nsitati mphule na miti mikinoko zaya. ");
INSERT INTO eko_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Khulawa atthu a waatta olawa woona vitthu epile zaarettikhaniyeezo. Wakathi amwaattamiyeeyo Yinsa, khumoona nlume otule ansaruwiyeeyo masheethwani eekhaliye nshini wa moolu a Yinsa awaliye kuwo zawe na atthiiyemo akhili zawe, yo khwiiya awoova. ");
INSERT INTO eko_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Apale ooniiyeeyo, khulawa khuwooza atthu nanna aavonisiweezo nlume otule. ");
INSERT INTO eko_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Aphano atthu ooshi apale a nti opule wa Keraaza khunvekela Yinsa yoori aleemo mmuti mwaya mwaasa wa woova channu, Ye khuwela nkalawa khulaawo. ");
INSERT INTO eko_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nlume otule ansaruwiyeeyo masheethwani khusala anvekela Yinsa amuuzaka yoori anlikhe alawe vamote na-ye. Ila Yinsa khumuuza olawa araka: ");
INSERT INTO eko_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Orutele owawo wawooze atthu etile Nnyizinku ooretteliyeeyo.” Nlume otule khulankha khusala alawa owawe alaleyaka sitati yooshi etile aaretteliweeyo ti Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Wakathi Yinsa arutiyeevo, khuntti khuluyeene ya atthu ooshi atthaapale aari onwejaaye khumpokherela na furaha. ");
INSERT INTO eko_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Aphano mwinyi mmote aari wiitthiwaaye Yayiiru namalokozela wa nyuupa yoosifwiwamo Nnyizinku, khuta khunkokhorela Yinsa nshini wa moolu awe anvekelaka yoori alawe owawe, ");
INSERT INTO eko_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","mwaasa yoori mwanawe aariina mmote paasi wa nyaakha khumi na miwiri aari osaleela ofwa. Yinsa alawaka, atthu khusala aphunyana-phunyana. ");
INSERT INTO eko_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Attaaphale khutavo muukha aariina nyaakha khumi na miwiri ari nlwele, yaari omwiittikhaaye taamu wakhula siikhu. Khuharipu nzurukhu awe wooshi aariina nkatthi wa akulukhala, ila khuhiivo mmote aawahiyeeyo onvonisa. ");
INSERT INTO eko_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ye khuta mpakha onyoko wa Yinsa khusapa ajapi yawe vattitthiiru, omuuta otthuupule khulikha wiittikha taamu etile. ");
INSERT INTO eko_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yinsa khuuzela yoori: “Paani akisapiyeeyo?” Atthu ooshi khusala akhana, Pheeturu khulupa yoori: “Mbwana, atthu pi a waatta pa yo anuuphunyaaye na wuusukhuma!” ");
INSERT INTO eko_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ila Yinsa khusala avira akhanyarelaka yoori: “Nna akisapiyeeyo keetta woona okisaruwiye owahi waka.” ");
INSERT INTO eko_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aphano muukha otule ooniyeevo yoori khaari owahi ojivitha, khuta eettaka othukumela khunkokhorela Yinsa vakatthi wa atthu ooshi khusala alupa wa nanna ansapiyeezo na avoniyeezo nasaapiru. ");
INSERT INTO eko_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Attaaphale Yinsa khumuuza yoori: “Mwanankha waamini wawo woovonisa! Olawe na heeri.” ");
INSERT INTO eko_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Attakhulaka etthiipile Yinsa, khuta karumeya mmote wa vaje vawe Yayiiru khumuuza yoori: “Ohimwantipu Mbwana olawa vamote na-weyo, maana mwanawo aya afwa.” ");
INSERT INTO eko_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yinsa n'oosiila khumuuza Yayiiru yoori: “Ohoove, wiiyane amini, mwanawo ontta wiiya nkumi.” ");
INSERT INTO eko_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","N'oofiya owawe Yayiiru, Yinsa khuhinlikhi hatha ntthu ovira nnyupa mphule, khuvira na Pheeturu, Yaahaya, Yaakhumpa, papaawe mwaana na mamaawe. ");
INSERT INTO eko_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Atthu ooshi aasaliye vaje eettaka olila, Yinsa khuwooza yoori: “Mwihilile, otu khafweeni ontta olala.” ");
INSERT INTO eko_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Yo khusala antheya Yinsa mwaasa wa ojuwa yoori afwa. ");
INSERT INTO eko_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ye khuntheteezela nkhono awe khumuuza yoori: “Mwaari, lankha!” ");
INSERT INTO eko_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Rooho yawe khunrutela khulankha nasaapiru. Aphano Yinsa khumuuza papaawe yoori amwinkhe etthu-yoojiwa. ");
INSERT INTO eko_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Papaawe na mamaawe khwiiya ooshanka, ila Yinsa khuwooza yoori mwihimuuze hatha ntthu vitthu epi zirettikhaniyeezo. ");
INSERT INTO eko_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yinsa khuwaakusanya maaswihaapa awe khumi na awiri khuwenkha owahi na ofwalume wa wiikara masheethwani a wakhula nanna na woovonisa. ");
INSERT INTO eko_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Khuwaaruma olawa olaleya ofwalume wa Nnyizinku na owaavonisa alwele. ");
INSERT INTO eko_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Khuwooza yoori: “Mwilawaka mwihithuule hatha etthu, wala pakhora, wala mfukho, wala phaawu, wala nzurukhu, wala ajapi yaphiiri. ");
INSERT INTO eko_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nyuupa ethiito mwinttelaaye opokhereliwa, mwimake attaapho mpakha olaavo. ");
INSERT INTO eko_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Amana mwihipokhereliwi saana, mwilaakamo nsitati mwaya mpho mwitathe lifufu la mmoolu mwenu khwa oshaahiti waya yo.” ");
INSERT INTO eko_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aphano yo khulankha khusala alawa aviraka mmamiti alaleyaka hapari zooshapweya na awaavonisaka alwele wakhula phantte. ");
INSERT INTO eko_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nsatoro Herooti khusiila vitthu zaari orettikhanaazo ye khwiiya wootikinisiwa mwaasa atthu akina aari olupa yoori Yaahaya ti ye asisimuwiye muufwa. ");
INSERT INTO eko_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Akina aari olupa yoori Aliyaasi ti ye awaapuweleliye, akina aari olupa yoori oto napiyu mmote wa raku eetta osisimuwa. ");
INSERT INTO eko_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ila Herooti khulupa yoori: “Yaahaya miiyo kaarumiye yoori ashijiwe, khi oto kininsiilaaye alupiwaka na anrettaaye vitthu epo ti paani?” Khusala atakhacha yoori amoone. ");
INSERT INTO eko_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Maaswihaapa apale n'ooruti khumuuza Yinsa zooshi aarettaziyeezo. Aphano, ye khuwaathuula khusala alawa sitati moote yaari wiitthiwaaye Betesayita. ");
INSERT INTO eko_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ila khuntti ya atthu n'oojuwa khusala anlotta. Ye khuwaapokherela khusala awooza monkoni woofwalume wa Nnyizinku na awaavonisaka apale aari ohithajiyaaye ovonisiwa. ");
INSERT INTO eko_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Njuwa leettelaka oveva, apale khumi na awiri khumwaattama Yinsa khumuuza yoori: “Owooze atthu apa alawe mmamiti mpho amake eekesaka etthu-yoojiwa, maana mphu niriimo makuluttu.” ");
INSERT INTO eko_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ye khuwaajipu yoori: “Mweeyeena mwiwenkhe etthu-yoojiwa.” Yo khunjipu araka: “Niriinaaye apha, phaawu thaanu na swi piiri paasi, woohiiyi olawa wuuzanya etthu-yoojiwa khiniwaafiyela atthu ooshi apa.” ");
INSERT INTO eko_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Alume aariivo aari etthu ya alufu thaanu, ila ye khuwooza anakhiyoni awe yoori: “Mwiweekhaze atthu hamusiini wakhula khuntti.” ");
INSERT INTO eko_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yo khuretta etthiipo khuweekhaza ooshi. ");
INSERT INTO eko_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Khuthuula phaawu thaanu na swi epile piiri khweekesa otulu, khuparikhiya khumeya khuwenkha anakhiyoni awe yoori awaawanyeze atthu apale. ");
INSERT INTO eko_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ooshi khuja khurupala, epile zaasaliiye khulokottheliwa khwiitaala khelenke khumi na piiri. ");
INSERT INTO eko_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Siikhu moote, Yinsa eetta olompa otthwe, anakhiyoni awe ari kharipu, nawiisha khuwoozela yoori: “Atthu anri miiyo ki paani?” ");
INSERT INTO eko_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yo khunjipu yoori: “Akina anri weeyo o Yaahaya Namoosa, akina Aliyaasi, akina theenya anlupa yoori weeyo o napiyu mmote wa raku weetta osisimuwa.” ");
INSERT INTO eko_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Khi mweeyo mwinri ki paani?” Pheeturu khujipu araka: “Weeyo o Al-Masiihu wa Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yinsa khuwaahirimiza yoori vitthu epile ahimuuze hatha ntthu. ");
INSERT INTO eko_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Khuwooza araka: “Mwaana wa Pinaatamu ona yoohoowa nkatthi wa vitthu za waatta na okatthaliwa pi anamalokozela a tiini na attunkhulu a mahaakhimu a tiini mpakha anamanozela a kano; onlawa afwe, siikhu yattaatthu asisimuwe.” ");
INSERT INTO eko_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Khuvira awoozaka atthu ooshi yoori: “Nkhama ntthu atakha okilotta miiyo, ona yoojikatthala mwennyewe, khuvikela nsalapa awe wakhula siikhu khusala akilotta. ");
INSERT INTO eko_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Amana ntthu atakha wuusuru ohaayi awe, ontta ompwetheya; ila otule onimpwetheyaaye ohaayi awe mwaasa wa miiyo, oto onteela wuusurukha. ");
INSERT INTO eko_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ona fwayita-ni ntthu opattha vitthu zooshi z'oolumwenku, ila khujipwetecha ama khujitapanya mwennyeweru? ");
INSERT INTO eko_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Otule anikoonelaaye haaya miiyo na mattakhuzi aka, na Mwaana wa Pinaatamu onteela omoonela haaya mmana ataaka nnuuru mwawe na nnuuru wa Paapa na malayikha oottakatthiifu. ");
INSERT INTO eko_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kiniwuuzani khweele yoori awaapo apha akina ahinteelaaye ofwa mpakha oone ofwalume wa Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ziviriyeevo etthu ya siikhu naane paata yoolupa mattakhuzi apale, Yinsa khunthuula Pheeturu, Yaahaya na Yaakhumpa, Ye khuwela vamwaako olawa olompa. ");
INSERT INTO eko_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Alompaka etthiipile omaasho wawe khuzukuluwawo, kuwo zawe khwiiya zoolakala na za waara nkhama ozerima. ");
INSERT INTO eko_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nasaapiru khumpuwelela atthu awiri khusala attakhulana, aari Munsa na Aliyaasi. ");
INSERT INTO eko_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Aatiiye nnuuru ya pinkuuni khusala amuuza Yinsa khwa nanna aari weettelaazo ohoowa na ofwa Yeruzaleemu nkhama etthiipo Nnyizinku asharutheliyeeyo. ");
INSERT INTO eko_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pheeturu na ashirikha awe aarettiye eettaka olala, wakathi asisimuwiyeevo khoona nuuru ya Yinsa na atthu awiri amweemeleliye. ");
INSERT INTO eko_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Atthu apale eettaka olawa Pheeturu khumuuza Yinsa yoori: “Mwanliimu, ti yooshapweya wiikhala attaapha! Nintta ojeka mapantta mattatthu, limote laawo, limote la Munsa, na limote la Aliyaasi.” Pheeturu khaari ojuwa etthu aari ottakhulaaye. ");
INSERT INTO eko_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Attakhulaka etthiipile, khuta liwiku khuwaafinikha, anakhiyoni apale khwiiya awoova wakathi ooniyeevo liwiku liwaafinikhaka atthu apale. ");
INSERT INTO eko_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mmawiku mphule khupuwamo huula yaari oraaye: “Otu mwanaka woothawuliwa; mwinsiileze etile anlupaaye.” ");
INSERT INTO eko_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Paata yoonyamala huula etile Yinsa khusalavo otthwe. Siikhu zaya epile anakhiyoni apale khwiiya oonyamala, khuhimuuzi hatha ntthu vitthu epile ooniyeezo. ");
INSERT INTO eko_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mmeesho mwaya nawiishukha vamwaako, khuta khuntti ya atthu a waatta oteela okutthanana Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Vakatthi wa khuntti ya atthu atthaapale khupuwavo mwinyi aari okhuwaaye araka: “Mwanliimu, kinuuvekela yoori wamoone mwanaka, maana kina mmote othuuto paasi. ");
INSERT INTO eko_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Sheethwani eetta onvelavelisa khusala anthukumelisa, onnyakulisa na onkwisela vathi n'oolaza maphovu, khaninlikha ahinvulaliseeni. ");
INSERT INTO eko_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kaawaavekeliye anakhiyoni awo yoori amwiikare sheethwani aya oto, yo khumoojeela.” ");
INSERT INTO eko_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yinsa khujipu araka: “Oo! Atthu oohaamini na ootakhala rooho! Mpakha lini kiiyaka vamote na-mweyo na kuuvilelakani? Ontiise apha mwanawo aya oto.” ");
INSERT INTO eko_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Alawaniwaka etthiipile, sheethwani khunkwisela vathi khusala anthukumelisa, Yinsa khumwiikara sheethwani khuvona mwaana otule, khumwinkha papaawe. ");
INSERT INTO eko_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Atthu ooshi khwiiya ooshanka mwaasa woowahi wa Nnyizinku. Yo aashankeliye vitthu epile aari orettaazo Yinsa, ye khuwooza anakhiyoni awe yoori: ");
INSERT INTO eko_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mwisiileze saana mattakhuzi apa kiniwuuzaanini: Mwaana wa Pinaatamu onttela winkheleliwa mmakhono wa anaatamu.” ");
INSERT INTO eko_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ila yo khuhisala ajuwa maana a mattakhuzi aya apale mwaasa yoori aari ovitheya yoori ahiweeleye na khusala oova omuuzela. ");
INSERT INTO eko_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Khupuwa onyakulisana vakatthi wa anakhiyoni apale eekesaka onjuwa paani wa yo aari weettelaaye wiiya nttunkhulu. ");
INSERT INTO eko_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ila Yinsa khujuwa etthu aari wuupuwelaaye yo, khunthuula mwaana khumweemesa omaasho wawe. ");
INSERT INTO eko_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Aphano khuwooza anakhiyoni awe yoori: “Otule animpokherelaaye mwaana otu khwa nzina laka, onikipokherela miiyo; otule anikipokherelaaye, onimpokherela otule akirumiyeeyo. Otule anjipushuwisaaye vakatthi venu mooshi, nttunkhulu ti othuuto.” ");
INSERT INTO eko_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yaahaya khulupa yoori: “Mwanliimu, namoona ntthu aniikaraaye masheethwani khwa nzina lenu. Fweeyo khunkhattaza mwaasa woohiiyi wa khuntti yetthu.” ");
INSERT INTO eko_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yinsa khuwooza yoori: “Mwihinkhattaze. Maana otule ahinvirikanaaye na-fweyo ori phantte yetthu.” ");
INSERT INTO eko_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Osaleelaka ofiya wakathi wa Yinsa orutela pinkuuni, khujilakelela weetta sitati ya Yeruzaleemu. ");
INSERT INTO eko_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Khuwaalokozisa akarumeya awe, yo alawaka khusapuwa nti wa Samariiya yoori amweekesele puuro yoomakavo. ");
INSERT INTO eko_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ila atthu a nti wa Samariiya khuhimpokhereli, maana aajuwiye yoori eetta ovira eettaka Yeruzaleemu. ");
INSERT INTO eko_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yaakhumpa na Yaahaya nawoona vitthu zaya epile khumuuza Yinsa yoori: “Mbwana, ontakha yoori nirume moottho wa pinkuuni owaalukuze, nkhama etthiipo Aliyaasi aaretiiyeezo?” ");
INSERT INTO eko_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ila Yinsa khuzukuluwa khuwaamaruwela araka: “Mweeyo khamwinjuwa rooho mwiriinaazo. ");
INSERT INTO eko_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Mwaana wa Pinaatamu khateeleeni opwetecha nafusi za atthu, aateeliye wuusuru.” Aphano khulankha khusala alawa nti nkina. ");
INSERT INTO eko_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Eettaka olawa ntarikhi khupuwa ntthu mmote khumuuza yoori: “Kintta wuulotta wakhula vahali oneettaavo.” ");
INSERT INTO eko_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yinsa khunjipu araka: “Ananthala anaaye maphotto aya, anyannyi anaaye vijaaro zaya, ila Mwaana wa Pinaatamu khana vahali woovumulisavo eeshwa yawe.” ");
INSERT INTO eko_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yinsa khumuuza ntthu nkina yoori: “Okilotte.” Ye khujipu araka: “Mbwana, okilikhe khapula kilawe kanzikhe paapa.” ");
INSERT INTO eko_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yinsa khumuuza yoori: “Owaalikhe anamfwa awaazikhe anamfwa aya; weeyo olawe walaleye ofwalume wa Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Khupuwa ntthu nkina theenya khumuuza Yinsa yoori: “Kintta wuulotta Mbwana, ila okilikhe khapula kawaaleeze ajamaazaku.” ");
INSERT INTO eko_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yinsa khunjipu yoori: “Otule aneesaaye makhono awe alimaka khusala eekesa nyuma khaneezela muufwalume wa Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Paata ya toole, Mbwana khuwaathawula anakhiyoni awe akinoko sapiyiini na awiri, khuwaaruma yoori alawe awiri-awiri alokoze nsitati na mmiti wooshimo mphule aari weettelaaye oviramo. ");
INSERT INTO eko_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ye khuwooza yoori: “Wuurula pu wa waatta, ila anakhaazi vattitthiiru. Mwinvekele Mwennyewe nshapa yoori awaaperekhe anakhaazi a wuurula. ");
INSERT INTO eko_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mwilawe, kinuurumani nkhama pwittipwitthi zinttaaye vakatthi wa miiji. ");
INSERT INTO eko_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mwihithuule mfukho wala napampa, ama jampali wala mwiheemele ntarikhi mwichelisa. ");
INSERT INTO eko_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Wakhula nyuupa mwimfiyaaye mwilupe khapula yoori: ‘Heeri yiiye vamote na-mweyo vaje apha.’ ");
INSERT INTO eko_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Amana eeyavo ntthu wa heeri, heeri yenu enttela wiiya vamote na othuuto; amana ahiivo entta wuurutelani. ");
INSERT INTO eko_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mwiheettette nyuupa khwa nyuupa, ila mwiikhale nyuupa ethiito mwije mwinywe wakhula etile mwinttelaaye winkhiwa, maana nakhaazi eninsuhi phakari yawe. ");
INSERT INTO eko_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Wakhula sitati mwimfiyaaye khupokhereliwa saana, mwije etthu-yoojiwa mwinttelaaye winkhiwa. ");
INSERT INTO eko_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mwiwaavonise alwele mwinttelaaye owaasikana na mwiwooze atthu yoori: ‘Ofwalume wa Nnyizinku ori kharipu na-mweyo.’ ");
INSERT INTO eko_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Wakhula sitati mwineettaaye amana mwihipokhereliwi, mwileemo mwilawe ntarikhi mwiwooze yoori: ");
INSERT INTO eko_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Lifufu la sitati yenu ntthi liniphariyeeyo mmoolu mwetthu, nootathelani mwamwennyewe; ila mwijuwe yoori ofwalume wa Nnyizinku ori kharipu na-mweyo.’” ");
INSERT INTO eko_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yinsa khuwooza theenya yoori: “Kiniwuuzani yoori siikhu ya khiyaama, Nnyizinku onteela woonela tthakaraka Sotooma zayita sitati eto. ");
INSERT INTO eko_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Olaanikha pu waawo weeyo Korazini, na weeyo Betesayita! Eriwaka minjuza epi zirettikhaniyeezo mphu, zeettiye orettikhana sitati ya Tiiro na Sidooni, athupwiyiye raku twampi zaya awala saakhu eekhala vafuutha. ");
INSERT INTO eko_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nakataalikha siikhu ya khiyaama, Nnyizinku onteela woonela tthakaraka Tiiro na Sidooni zayita mweeyo. ");
INSERT INTO eko_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Weeyo Kafwaranawu onoona yoori onsifwiwa mpakha pinkuuni? Wala! Apho onteela wiishukhela motthooni. ");
INSERT INTO eko_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Otule anuusiilezaanini, onikisiileza miiyo; otule anuukatthalaanini, onikikatthala miiyo. Otule anikikatthalaaye miiyo, oninkatthala otule akirumiyeeyo.” ");
INSERT INTO eko_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Anakhiyoni apale sapiyiini na awiri khuruti ari oofurahi khulupa yoori: “Mbwana, hatha masheethwani aari onishututela amana nittakhulaka khwa nzina lawo.” ");
INSERT INTO eko_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yinsa khuwaajipu yoori: “Miiyo kamoona Epiliisi akwaka otulu nkhama ozerima. ");
INSERT INTO eko_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mwikisiileze! Kiniwinkhani owahi wooluwattha nyookha, wenye khuhuurettini hatha etthu, na oshintta owahi wooshi wa atuwi. ");
INSERT INTO eko_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mwihifurahi mwaasa wa masheethwani wuushututelani, mwifurahele mazina enu waatikhiwa pinkuuni.” ");
INSERT INTO eko_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Wakathi otthuupule Yinsa khwiiya woofurahi nkatthi wa Rooho Ttakatthiifu, khuri: “Kinuusifu weeyo Paapa, Mbwana wa pinkuuni na vathi maana vitthu epi zeeya zoovitheya vakatthi wa ajuwi na asomi, khuwaathoonyeza asimaana; khweele Paapa, ti nanna waatakhiyeezo. ");
INSERT INTO eko_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Zooshi kenkhiwa ti Paapa; na khaavo aninjuwaaye Mwaana woohiiyi Paapa, wala aninjuwaaye Paapa woohiiyi Mwaana, na otule Mwaana anintakhelaaye yoori anjuwise.” ");
INSERT INTO eko_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Paata ya toole, khuwaakhuwela anakhiyoni aweru paasi khuwooza yoori: “Ooparikhiyiwa pi apale anoonaaye epi mwinoonaazo. ");
INSERT INTO eko_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kiniwuuzani yoori manapiyu a waatta na afwalume aari otakha woona vitthu etthiipi mwinoonaazo ila khuhooni na aari otakha osiila epi mwinsiilaazo ila khuhisiili.” ");
INSERT INTO eko_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","N'ooretta toole, namanozela mmote wa kano khulankha yoori amweeze Yinsa khuri: “Mwanliimu, kirette-ni yoori kipatthe ohaayi wa mileele?” ");
INSERT INTO eko_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yinsa khumuuzela yoori: “Yaatikhiwa niini nkithaapu ya kano wala eniweeleya toovi amana osomaka?” ");
INSERT INTO eko_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ye khujipu araka: “‘Omphete Mbwana Nnyizinku awo na rooho yawo yooshi na nafusi yawo yooshi, na kuvu zawo zooshi na akhili zawo zooshi’ na ‘omphete namwaattamanani awo nkhama etthiipo onjiphetaazo omwennyewe’.” ");
INSERT INTO eko_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Aphano Yinsa khumuuza yoori: “Wajipu saana. Orettaru etthiipo ontta opattha ohaayi wa mileele.” ");
INSERT INTO eko_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ila namanozela wa kano otule aari otakha ojihakikhi khumuuzela Yinsa theenya yoori: “Namwaattamanani aka ti paani?” ");
INSERT INTO eko_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yinsa khunjipu araka: “Aarivo ntthu mmote aari olankhaaye Yeruzaleemu eettaka Yeriko, khuvithaaleliwa pi malatarawu khunyakanyiwa vitthu zawe, khuvuliwa kuwo zawe, khupiiwa khulikhiwa asaleelaka ofwa. ");
INSERT INTO eko_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Erettiyeevo toole, khuviravo haakhimu wa tiini mmote, n'oomoona ntthu otule khunwerawera. ");
INSERT INTO eko_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Khuviravo theenya nleevi mmote, n'oomoona ntthu otule ari ntarikhi mphule khunwerawera. ");
INSERT INTO eko_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Aphano khuviravo nsamariiya mmote aari weettaaye safwari zawe, n'oomoona ntthu otule khumoonela huruma. ");
INSERT INTO eko_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Khumwaattamela khoosa makhwatta awe na mafuttha na aalikoro khufuka na alikatuura, khunthuula khunttha vapuuru vawe khunlawana onyuupa ya aletto khumwiinanela. ");
INSERT INTO eko_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mmeesho mwaya, khulaza mizurukhu miwiri za feeta aariinaazo khumwinkha mwennyewe nyuupa khumuuza yoori: ‘Omwiinanele ntthu otu mpakha wakathi kinrutaavo, wakhula etile onttelaaye oharipu khwa ye, kintta ota kuuriphe n'ooruti.’” ");
INSERT INTO eko_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Aphano Yinsa khumuuzela namanozela wa kano otule yoori: “Khwa atthu apa attatthu paani omooniyeeyo wiiya namwaattamanani awe nampiiwa pi malatarawu?” ");
INSERT INTO eko_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ye khujipu yoori: “Ti otule amooneliyeeyo huruma.” Yinsa khumuuza yoori: “Na-weyo olawe warette etthiipo.” ");
INSERT INTO eko_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yinsa na anakhiyoni awe eetta ovira alawaka khufiya mmuti, khupuwa muukha mmote aari wiitthiwaaye Maarata, khumpokherela. ");
INSERT INTO eko_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ye aarina ttwiiye aari wiitthiwaaye Mariyamu, eekhaliye nshini a moolu wa Mbwana Yinsa khusala asiila mattakhuzi apale aari olupaaye. ");
INSERT INTO eko_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ila Maarata eetta ojizukulela mwaasa wa waatta khaazi, khulawa aphale aariivo Yinsa khumuuza yoori: “Mbwana, khinuujali ttwiiyaku okilikhela khaazi za waatta otthome? Omuuze ate akikholise!” ");
INSERT INTO eko_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mbwana khunjipu yoori: “Weeyo Maarata washukulikha na wajikhaza na vitthu za waatta. ");
INSERT INTO eko_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ila eti moote ti yiiye yootafikhana. Mariyamu athawula phantte yooshapweya ahinnyakanyeyaaye.” ");
INSERT INTO eko_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Siikhu moote Yinsa eetta olompa vahali vaya apho, eeshiyeevo mmote wa anakhiyoni awe khuri: “Mbwana, oninozele olompa nkhama etthiipile Yaahaya Namoosa na-ye awaanozeliyeezo anakhiyoni awe.” ");
INSERT INTO eko_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Aphano, Yinsa khuwooza yoori: “Amana mwilompaka mwisala mwiri toono: Papeetthu, littitthimisiwe nzina lawo loottakatthifu. Wiishushe Ofwalume awo. ");
INSERT INTO eko_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Oninkhe wakhula siikhu etthu-yoojiwa ninhithajiyaaye. ");
INSERT INTO eko_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Oniswaamihi twampi zetthu, nkhama etthiipi na-fweyo nininswaamihaaye wakhula otule annikosaaye. Ohinilikhelele nizayiniwaka ti sheethwani, ila onuusuru khwa vitthu zootakhalaa.” ");
INSERT INTO eko_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yinsa khuwooza theenya yoori: “Nkaakanyerelani mmote wa-mweyo anlankhaaye osikhu layili, khulawa ompiyela nlako swaahipu awe araka: ‘Swaahipu, kiipaashe phaawu ttatthu, ");
INSERT INTO eko_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","mwaasa yoori eetta ota swaahipu aka onti na akina hatha etthu yoomwinkha.’ ");
INSERT INTO eko_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Khi amana swaahipu enu oojipuni ari nnyupa mwawe araka: ‘Ohikantipu! Miiyo kafuka milako zaka, karapalela na aanaaka alala; akinwahi olankha yoori kuupatthise phaawu zaya.’ ");
INSERT INTO eko_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Weekhweele miiyo kiniwuuzani yoori, hatha nkhama khatakheeni olankha yoori oopatthise phaawu mwaasa w'ooswaahipu, oniishela olankha na awinkhe zooshi onhithajiyaazo mwaasa wa nthiti. ");
INSERT INTO eko_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ti eto kiniwuuzaanini yoori: Mwiveke, mwintta winkhiwa; mweekese mwintta opattha; mwipiye nlako mwintta ofukuleliwa. ");
INSERT INTO eko_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Maana wakhula anvekaaye oninkhiwa, aneekesaaye ompattha, ampiyaaye nlako ontta ofukuleliwa. ");
INSERT INTO eko_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Paapa-ni mmote wa mweeyo anraaye mwanawe anvekeliye phaawu khumwinkha liwe? Ama anvekeliye swi khumwinkha nyookha? ");
INSERT INTO eko_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Wala anvekeliye laayi khumwinkha wenye? ");
INSERT INTO eko_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Moone, mweeyo wootakhala rooho mwinjuwa owenkha aaneenu vitthu zooshapweya, sapiseni Paapa wa pinkuuni khanziti owenkha Rooho Ttakatthiifu apale aninvekelaaye?” ");
INSERT INTO eko_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Siikhu moote, Yinsa aari omwiikara sheethwani mmwiili wa mwinyi mmote antotheliyeeyo ohittakhuli. Wakathi ansaruwiyeevo sheethwani otule, ye khwaaza ottakhula; apale aari omoonaaye khushanka. ");
INSERT INTO eko_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ila atthu akina khusala alupa yoori: “Ye oniikara masheethwani na owahi wa Belezibuuli, mfwalume wa masheethwani.” ");
INSERT INTO eko_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Akinoko eetta omweeza, khusala anvekela alama moote ya pinkuuni. ");
INSERT INTO eko_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yinsa khujuwa vitthu aari ofikhiraazo, khuwooza yoori: “Ofwalume woojaawanya khusala wuumana oniishelana otapanyeya, na ojama wa waawanyeya oniishelana wiisha. ");
INSERT INTO eko_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nkhama Epiliisi eetta ojaawanya, ofwalume awe onttela wiiyavo toovi? Mweeyo mwinlupa yoori miiyo kiniikara masheethwani khwa owahi wa Belezibuuli. ");
INSERT INTO eko_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nkhama pi etthiipo, khi aaneenu aniikara na owahi waani? Atthaapo pa yo anttelaaye wuuthoonyezani yoori khamwina shariya. ");
INSERT INTO eko_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ila nkhama khweele masheethwani apa kiniikhara na owahi wa Nnyizinku, eto enthoonyeza yoori ofwalume wa Nnyizinku wafiya vakatthi venu. ");
INSERT INTO eko_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ntthu woozivala na woojuumaanya, amana eekeselaka vaje vawe saaneene, mali zawe ziniiya zookholeleleya. ");
INSERT INTO eko_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ila ntthu woozivala zayita ye, amana ankukuttela khunshintta ontta onnyakanya zaana zawe anroromelaazo athuule phantte ya mali zawe. ");
INSERT INTO eko_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Otule ahina vamote na-miyo oto ona lupattha na-miyo, otule ahinkusanyaaye na-miyo ontta omwaza.” ");
INSERT INTO eko_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yinsa khurutela olupa yoori: “Sheethwani, amana alaamo mmwiili oneekesa puuro yoohiina maati yoori avumule, n'oohisikani puuro ye onlupa yoori kintta orutela mphule kaariimo. ");
INSERT INTO eko_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Amana aruti asikana nnyupa ori wooseeliwamo na wa waattaleliwamo, ");
INSERT INTO eko_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ontta oruti eettele masheethwani makinoko sapa ootepa zayita otule, aviremo asala eekhala nttumphule. Attaaphale ohaayi wa ntthu aya otule oniiya wootepa zayita omwanzo.” ");
INSERT INTO eko_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yinsa eettaka olupa mattakhuzi apale, muukha mmote aari attaaphale khunyakula araka: “Wooshapweyiwa muukha otule oovokoliyeeyo khuwaamwisa.” ");
INSERT INTO eko_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ila Yinsa khunjipu araka: “Ooshapweyiwa pi apale ansiilaaye nttakhuzi la Nnyizinku khushututela.” ");
INSERT INTO eko_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wakathi atthu akusanyeyiyeevo vahali vamote, Yinsa khusala alupa yoori: “Atthu a leelo pi ootakhala rooho, anveka woona alama ya minjuza ila khanlawa othoonyeziwa hatha alama moote, yoohiiyi etile ya napiyu Yuunusa. ");
INSERT INTO eko_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nkhama etthiipo Yuunusa eeyiyeeyo alama ya atthu a Neniive, na-ye Mwaana wa Pinaatamu onttela wiiya alama ya atthu a leelo. ");
INSERT INTO eko_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Siikhu ya khiyaama rayisi wa kusini onttela olankha awaaphuke atthu a aphano; maana ye alankha okhu wiisheliyeewo olumwenku oteela osiila ojuwa wa Seleyimaana, ila otu mwiriina apha anziti Seleyimaana. ");
INSERT INTO eko_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Siikhu ya khiyaama atthu a Neniive anttela wuuphukani mweeyo, maana yo athupwiya twampi zaya, n'oosiila tafusiiri epile aari olupaazo Yuunusa; otu mwiriina apha nasaapi anziti Yuunusa.” ");
INSERT INTO eko_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yinsa khuvira alupaka yoori: “Khaavo ntthu ankhozaaye khantteya khuvitha ama khukhutela na yuuku, ila entthiiwa vahali wa wooneyavo yoori esala ewaamwasikhela apale anviraaye nnyupa. ");
INSERT INTO eko_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Khantteya ya mwiili maasho, amana maasho awo eeya oosaana, mwiili awo wooshi oniiya wa nuuru. Ila amana maasho awo ahiiyi saana mwiili awo oniiya n'yiiza. ");
INSERT INTO eko_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Wiiyane phoole na nuuru eto oriinaaye yoori ehiiye yiiza. ");
INSERT INTO eko_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Amana mwiili awo wooshi wiiyana nuuru khuhiina hatha phantte moote ya yiiza, oniiya woomwasikheliwa nkhama khantteya yuumwasikhelaka weeyo.” ");
INSERT INTO eko_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Wakathi Yinsa eeshiyeevo ottakhula, mfwarizeewu mmote khumuuza olawa oja owawe. Ye n'oofiya khwiikhala vameeza. ");
INSERT INTO eko_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mfwarizeewu otule khushanka mwaasa woomoona Yinsa eettela oja woohinawi. ");
INSERT INTO eko_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mbwana khuwooza yoori: “Mweeyo mafwarizeewu, mwinoosa koopho na parathu oje waya, ila rooho zenu zeetaala vitthu za omaasho kopho na zoohusuti. ");
INSERT INTO eko_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Alolo! Otule aattaliyeeyo oje khahi othuuto attaliyeeyo nkatthi? ");
INSERT INTO eko_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Khapula mwaaze winkha etile eriiye nkatthi wa rooho yenu nkhama zimola, toowo mwintta woona zooshi ziwiikhaleliyeni saana. ");
INSERT INTO eko_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Olaanikha pu weenu mweeyo mafwarizeewu, maana mwininkha lifunku lakhuumi mathapa na vitthu za nwoorotha, ila khusala mwitarawu shariya na pheta ya Nnyizinku! Mweeyo mwina yooretta vitthu epo woohilikhi phantte kiina. ");
INSERT INTO eko_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Olaanikha pu weenu mweeyo mafwarizeewu, wawuutuvelani puuro ya wiilokozi nnyupa woosifwiwamo Nnyizinku na ochelisiwa wa shitahavo vamwanttiwa. ");
INSERT INTO eko_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Olaanikha pu weenu mweeyo, mwiiyiyeeyo nkhama khapuri yoohooneyi anviraavo atthu vatulu vaya khuhijuwi.” ");
INSERT INTO eko_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Aphano namanozela wa kano mmote khunjipu Yinsa araka: “Khahiyo toowo! Mattakhuzi apo kinoona yoori annithoonya fweeyo.” ");
INSERT INTO eko_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yinsa khuri: “Olaanikha pu weenu mweeyo anamanozela a kano, mwiniwaapwecherisaaye atthu mapwattha oolemela wala mweeyo mwihinwahaaye osapa na yaala yenu. ");
INSERT INTO eko_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Olaanikha pu weenu mweeyo mwiniwaajekelaaye khapuri zooshapweya manapiyu, atthaapale ooliiweeyo pi amarehemu apapazenu. ");
INSERT INTO eko_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Apho mweeyo mwinthoonyeza yoori mwinlawela oshaahiti wookhupalela epile apapazenu arettiyeeyo, yo awoola manapiyu, mweeyo khuwaajekela khapuri zooshapweya. ");
INSERT INTO eko_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ti eto Nnyizinku alupiyeeyo nkatthi woojuwa wawe yoori: ‘Kinlawa kawaaperekhe manapiyu na maaswihaapa; yo anteela owoola, akina aweekarise.’ ");
INSERT INTO eko_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Mwaasa wa manapiyu apa ooliiweeyo tokhiya olumwenku waazaka, atthu ooshi apa a leelo eti ana paathuli. ");
INSERT INTO eko_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Waaza taamu ya Apeele mpakha taamu ya Zakariya otule ooliiweeyo kharipu ya vaalitaari vaje wa nyuupa ya Nnyizinku. Kiniwuuzani yoori, atthu a leelo anlawa ahukhumwiwe mwaasa wa ethiito. ");
INSERT INTO eko_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Olaanikha pu weenu mweeyo anamanozela a kano, maana mwathuula efukulo yoojuwa, ila khuhivirimo na khuwaakhattaza apale aari otakhaaye oviramo.” ");
INSERT INTO eko_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Paata ya Yinsa olaavo aphale vaya, mafwarizeewu na anamanozela a kano khwaaza omuuzela vitthu za waatta ari ookatipukha. ");
INSERT INTO eko_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Yo aari onwazela shawuri yoori kusapi onalupa etthu, apatthe onlokoveza. ");
INSERT INTO eko_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Khuntti ya atthu khukusanyeya, mwaasa wa waatta akinoko khusala aluwatthana. Yinsa khuwooza khapula anakhiyoni awe yoori: “Phoole na thwapiya zoonaafikhi za mafwarizeewu. ");
INSERT INTO eko_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Khayiivo yoovithiwa ehinteelaaye ovithuliwa na zooshi epile zoottiyeleliwa zinteela ojuwiwa.” ");
INSERT INTO eko_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Zooshi zinlupiwaazo n'yiiza, zinlawa zasaruleliwe veetakale, na zooshi epile zinlupiwaazo sirini zinlawa zeeye payana. ");
INSERT INTO eko_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yinsa khuvira attakhulaka araka: “Miiyo kiniwuuzani ashirikha yoori: Mwihiwoove apale anuulaaye mwiili, nawiisha khuhiretteli hatha etthu. ");
INSERT INTO eko_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Miiyo kintta wuuthonyezani paani woomoova: Mwimoove Nnyizinku otule anwahaaye wuula mwiili enu, nafusi yenu khweeselela motthooni. Oto ti mwiriina yoomoova. ");
INSERT INTO eko_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Anyannyi athaanu attiitthi-attiitthi khanuuzanyisiwa sinku piiri? Ila apo aya khaavo mmote Nnyizinku aninsahawaaye. ");
INSERT INTO eko_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hatha na nyuuli za mmwishwa mwenu zooshi pi za waalakiwa. Mwihoove, mweeyo mwinaaye fwayita zayita anyannyi apo a waatta.” ");
INSERT INTO eko_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yinsa khuri: “Miiyo kiniwuuzani yoori: otule antukhurwaaye vakatthi wa atthu yoori namalottela aka, Mwaana wa Pinaatamu onteela otukhuru vakatthi wa malayikha a Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ila otule ankikatthalaaye vakatthi wa atthu, na-ye onteela okatthaliwa vakatthi wa malayikha a Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Wooshi otule anintarawaaye Mwaana wa Pinaatamu onswaamihiwa, ila otule ankufurwelaaye Rooho Ttakatthiifu khanswaamihiwa. ");
INSERT INTO eko_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Amana mwithuuliwa olawa ophukiwa nnyupa woosifwiwamo Nnyizinku ama wa afwalume, mwihiiyane shaakha khwa nanna mwinttelaaye ojaakisa ama etthu mwinttelaaye olupa. ");
INSERT INTO eko_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Wakathi otthuupo Rooho Ttakatthiifu entta wuuthoonyezani etthu yoolupa.” ");
INSERT INTO eko_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mwinyi mmote wa khuntti etile khunvekela Yinsa araka: “Mwanliimu, omuuze ttwiiyaku akaawanyele maali epile alikhiyeeyo papeetthu.” ");
INSERT INTO eko_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yinsa khunjipu araka: “Weyo, paani akirettiye wiiya namaphuka enu wala namwaawanya wa maali zenu?” ");
INSERT INTO eko_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Khuwooza yoori: “Phoole na omaashokopho wooshi wa vitthu, mwaasa yoori ohaayi wa pinaatamu khunlipa na vitthu epile ampatthaazo za waatta.” ");
INSERT INTO eko_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yinsa khulupa nlikaniso araka: “Aarivo mwinyi mmote wa thaajiri aaruweriyeeyo channu. ");
INSERT INTO eko_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ye khusala awaza toono: ‘Kirette-ni? Akina vahali wootthaavo peewu zaka epi.’ ");
INSERT INTO eko_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Khulupa yoori: ‘Aa, kajuwa etthu yooretta. Kintta opwecha matthala apa mattiitthi kijeke mawulu-mawulu yoori kittheemo peewu zaka na vitthu zaka zooshi epile kiriinaazo. ");
INSERT INTO eko_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nawiisha, kuuze nafusi yaka yoori: onaaye peewu na vitthu za waatta zintoshelezaaye nyaakha za waatta; ovumule, oje, onywe na opuhe.’ ");
INSERT INTO eko_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ila Nnyizinku khumuuza yoori: ‘Nlolo! Osikhu otthuupu ontta ofwa. Maali zawo paani anttelaaye osalana?’” ");
INSERT INTO eko_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yinsa khumarisela araka: “Ntthu oto ori nkhama atthu apale anlipanaaye maali zaya ila khuhiiyi mathaajiri mmakhono wa Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Aphano Yinsa khuwooza anakhiyoni awe araka: “Ti eto kiniwuuzaanini yoori: mwihiiyane shaakha na ohaayi enu, wala etthu mwinttelaaye oja ama etthu mwinttelaaye owala. ");
INSERT INTO eko_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Maana ohaayi ona fwayita khuluyeene zayita etthu-yoojiwa na mwiili ona fwayita khuluyeene zayita kuwo. ");
INSERT INTO eko_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mwiwoone anakhuku; khanzala wala khanuurula hatha ntthala khana loopwehavo vitthu-zoojiwa zaya, ila Nnyizinku oniwenkha etthu-yoojiwa. Mweeyo mwinaaye fwayita khuluyeene zayita anyannyi apo! ");
INSERT INTO eko_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Paani vakatthi venu anwahaaye weekezela mansha awe hatha nkhama eetta oshukulikhela? ");
INSERT INTO eko_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mweeyo khamwinwahi oshintta vitthu ttiitthi-ttiitthi, khi mwinshukulikhela toovi kinoko zaya? ");
INSERT INTO eko_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Moone nanna anwulaazo maluwa oshapweya ntthuttu, khankhola khaazi wala khanvaasha kuwo, ila kiniwuuzani yoori: Seleyimaana aari thaajiri nwulweene, ila khawaleeni kuwo zooripelela nkhama maluwa atthaapo. ");
INSERT INTO eko_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nnyizinku onwalisa nyaani ziriiye ntthuttu leelo meesho zeettelaka olukula, sapiseni mweeyo atthu a amini ttiitthiiru khatepeeni wuuwalisani? ");
INSERT INTO eko_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mwihishukulikhele etthu mwinttelaaye oja ama onywa. ");
INSERT INTO eko_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Atthu apale ahininjuwaaye Nnyizinku pa yo anshukulikhelaaye vitthu epo, ila mweeyo Papeenu onjuwa yoori enuuhithajiyani vitthu epo. ");
INSERT INTO eko_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mweekese khapula Ofwalume wa Nnyizinku, vitthu zaya epo mwintta weekezeliwa.” ");
INSERT INTO eko_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yinsa khulupa theenya araka: “Mwihoove mweeyo mwiiyiye nkhama khuntti ttiitthiiru ya pwittipwitthi, maana Papeenu ti ye atakhiye owinkhani Ofwalume awe. ");
INSERT INTO eko_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Muuzanyize zooshi mwiriinaazo nzurukhu aya mwiwenkhe asikhini, mwijaattalelele mifukho zihinvaruwaaye, toowo mwinthokorela maali pinkuuni zihiniishaawo, okhu ahimfiyaawo nantarawu wala maweephe yoori aharipu. ");
INSERT INTO eko_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Maana attaapho eniiyaavo maali zawo rooho yawo eniiya attaapho.” ");
INSERT INTO eko_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yinsa khuvira alupaka yoori: “Mwiiye anamarumeyela oojeekesela na khantteya zenu ziri zookhoziwa. ");
INSERT INTO eko_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mwina yawiiya nkhama anamarumeyela aninwejelaaye mbwanaaya yoori arutaka onjampo la harusi, amana apiya nlako amfukulele nasaapiru. ");
INSERT INTO eko_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ooshapweyiwa anamarumeyela apale mbwanaaya anttelaaye owaasikana eettaka ojeekesela. Kiniwuuzani khweele yoori mbwanaaya na-ye ontta ojiwalisa yoori arumeye, awooze wiikhala vameeza asala awaarumeyela. ");
INSERT INTO eko_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Hatha nkhama ata osikhu layili ama lifwajiri, ooshapweyiwa anamarumeyela apale mbwanaaya anttelaaye owaasikana ari oojeekesela. ");
INSERT INTO eko_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mwijuwe yoori eriwaka mwennyewe nyuupa eetta ojuwa wakathi nantarawu antaavo, toono ahinlikhaka ovira nnyupa mwawe. ");
INSERT INTO eko_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na-mweyo mwiiye woojeekesela, maana Mwaana wa Pinaatamu ataaka khaavo anjuwaaye wakathi aya.” ");
INSERT INTO eko_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Aphano Pheeturu khumuuzela Yinsa yoori: “Mbwana, nlikaniso opo pu weetthu ama pu wa atthu ooshi?” ");
INSERT INTO eko_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mbwana khujipu araka: “Paani eeyiyeeyo karumeya wa waamineya na w'aakhili, mbwanaawe amwinkhiyeeyo owaalokozela akarumeya azaawe na owenkha etthu-yoojiwa mmana ofiya wakathi? ");
INSERT INTO eko_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Wooshapweyiwa karumeya otule mbwanaawe amana ataaka anttelaaye onsikana arettaka etthiipo. ");
INSERT INTO eko_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Weekhweele, kiniwuuzani yoori onttela wiiya wa waaminiwa alikheliwe weettettisa maali zooshi. ");
INSERT INTO eko_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mwaakanyerele, karumeya otule amana alupa nroho mwawe yoori: ‘Mbwanaaka khanta nasaapi,’ khwaaza owaapiya akarumeya apale akina aakha na aalume, okhuno ajaka, anywaka na ahapaliwaka, ");
INSERT INTO eko_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","mbwanaawe onttela ota siikhu etile ye ahaari waakanyerelaaye na wakathi ahaari ofikhirelaaye, ahukhumwiwe venkivene atthiiwe puuro ya atthu oohaamineyi. ");
INSERT INTO eko_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Karumeya otule anjuwaaye matakhelo a mbwanaawe, ila khuhisala ajeekesela na khuhisala aretta epile antakhaazo mbwanaawe, onteela ohukhumwiwa na ojaphiwa venkivene. ");
INSERT INTO eko_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ila otule ahinrettaaye matakhelo a mbwanaawe mwaasa woohijuwi, onteela ojaphiwa na ohukhumwiwa vattitthiiru. Wakhula otule enkhiweeyo za waatta ona yoorutisa za waatta; na otule aaminiweeyo venkivene, onlawa avekeliwe zooziti channu.” ");
INSERT INTO eko_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yinsa khuri: “Miiyo kateela okhoza moottho vatuniya, enikituvela ovira okholelaka! ");
INSERT INTO eko_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ila yamwanzo kina yoohoowa kifwe, kina huzuni mpakha vitthu epi zirettikhane ziishe! ");
INSERT INTO eko_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mweeyo mwinaakanyera yoori miiyo katana heeri vatuniya? Wala! Kiniwuuzani khweele yoori miiyo katiisa ohisiilani. ");
INSERT INTO eko_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Waaza leelo eti mpakha okho ninttaawo, nkatthi woojama wa atthu athaanu, onteela opuwamo waawanyeya; attatthu ohisiilanani apale awiri, apale awiri ohisiilanani apale attatthu. ");
INSERT INTO eko_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Paapa wuumana na mwanawe na mwaana wuumana na papaawe. Maama wuumana na mwanawe wankha, mwaana wankha wuumana na mamaawe, namaraliwa wuumana na nkhwewe, akhwe wuumana na namaloola.” ");
INSERT INTO eko_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yinsa khuwooza atthu aakusanyeyiyeeyo yoori: “Mweeyo amana moona liwiku liwelelaka phantte y'ookhu lintupweelaawo njuwa mwinlupaka yoori: ‘Entakha onya vuula’, khweele khurettikhana. ");
INSERT INTO eko_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Amana moona pheevo ya kuusi mwinlupaka yoori: ‘Enteela opuwa haari’, khweele khurettikhana. ");
INSERT INTO eko_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Manaafikhi! Mweeyo mwinjuwa olupa alama za vatuniya na z'ootulu; aphano toovi mwihijuwaka olupa alama za wakathi opu? ");
INSERT INTO eko_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Mwaasa aya niini mwihijuwaka othawula etile yiiyiyeeyo ya shariya? ");
INSERT INTO eko_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Amana weeyo na muumani awo mwilawaka wa namaphuka, enhithajiya osiilana khapula rakuzeene mwihinalawe, maana amana ofiya wa namaphuka ontta omuuza namweekesela ootthe nkalapooso. ");
INSERT INTO eko_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Miiyo kiniwuuza khweele yoori khunlaamo ohiripheeni khapula.” ");
INSERT INTO eko_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Wakathi aya opule, atthu aariivo khumuuza Yinsa yoori Pilaatu awoola atthu akina a Kalileya wakathi aari orettaavo twaha zaya. ");
INSERT INTO eko_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yinsa khuwaajipu yoori: “Mweeyo mwinoona yoori akalileya apo aari anatwampi zayita atthu akina, mwaasa woohoowa toowo? ");
INSERT INTO eko_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Miiyo kiniwuuzani yoori: wala! Apho amana na-mweyo mwihithupwiyi twampi zenu, mooshi mwintta opwetheya nkhama yo. ");
INSERT INTO eko_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ama mweeyo mwinaakanyera yoori apale khumi na wanaane yaawaakweliyeeyo korofwa ya Siloowe aari anapaathuli zayita apale aniikhalaaye Yeruzaleemu? ");
INSERT INTO eko_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Wala! Kiniwuuzani theenya yoori amana mwihithupwiyi twampi zenu mooshi mwintta opwetheya nkhama etthiipo na-yo apwetheyiyeezo.” ");
INSERT INTO eko_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Aphano Yinsa khulupa nlikaniso opu onraaye: “Mwinyi mmote aarina mfikeera awe aazaliyeeyo mmashapa mwawe. Khulankha olawa oshuma mishumo zaya, hatha mmote khuhisikanimo. ");
INSERT INTO eko_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Aphano khumuuza namalimela nshapa ntthile yoori: ‘Kina nyaakha mittatthu kitaaka oshuma, kihisikanakamo hatha etthu. Okakatte! Mwaasa wa etthu-ni ottiyelelaka puuro ya mahala?’ ");
INSERT INTO eko_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ila karumeyaawe otule khunjipu araka: ‘Mbwana, kinuuvekelani yoori mwilikhe mfikeera opu wiiye nttumphu mpakha mwaakhani; miiyo kintta othipa nshini mwaya kisala kiitthela vitutu. ");
INSERT INTO eko_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mwaakha nkina amana wiima mishumo ti yooshapweya; amana ohiimi okakatte.’” ");
INSERT INTO eko_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Siikhu ya saapatu, Yinsa eetta osomisa nnyupa moote yoosifwiwamo Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nttumphule aarimo muukha aari ohoochiwaaye ti sheethwani khwa nyaakha khumi na minaane, aari wookhutupuwa ahaari owahaaye wookowa. ");
INSERT INTO eko_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Wakathi Yinsa amooniyeevo khunkhuwela khumuuza yoori: “Maama mwavona orati enu.” ");
INSERT INTO eko_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yinsa khunttheela makhono nunu otule omuuta otthuupule khookowa, khwaaza otthapa ansifwaka Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ila haakhimu wa nyuupa yoosifwiwamo Nnyizinku khwiiya wa wiiphiiriwa mwaasa wa Yinsa ovonisa siikhu ya saapatu, ti eto aawooziyeeyo atthu yoori: “Ziwaapho siikhu sitha zookhola khaazi; mwisala mwita siikhu etthiipo yoori mwivonisiwe, ila saapatu wala.” ");
INSERT INTO eko_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Aphano Mbwana khujipu araka: “Manaafikhi! Paani mmote wa mweyo anraaye efiiye saapatu khuhifukuli mompe zawe na apuuru awe olawa onywisa maati? ");
INSERT INTO eko_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nunu otu peewu ya Eburahiima, eettiye ofukiwa ti Epiliisi khwa nyaakha khumi na minaane, nanna-ni ahaari weettelaaye otaphuliwa mwaasa wa wiiya saapatu?” ");
INSERT INTO eko_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Alupiyeevo mattakhuzi apale, maatuwi awe Yinsa ooshi khuwaapattha haaya, atthu ooshi aariivo khwiiya oofurahi mwaasa wa vitthu zooshapweya epile aari orettaazo Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yinsa khulupa yoori: “Ofwalume wa Nnyizinku onlattana na niini, wala kilattisane niini? ");
INSERT INTO eko_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Opo ori nkhama phunje ya mfikeera, mwinyi mmote anthuulaaye khulawa khuzala mmashapa mwawe. Khuwula khwiiya muutthi nwulweene, anyannyi o'otulu khusala ajekamo vijaaro zaya nvirapi mwaya.” ");
INSERT INTO eko_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yinsa khulupa theenya araka: “Ofwalume wa Nnyizinku walattana na niini? ");
INSERT INTO eko_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Opo ori nkhama fwaramento muukha anthuulaaye khuttha ofu koopho ttatthu, khujakhuwa wooshi.” ");
INSERT INTO eko_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yinsa eetta ovira anozelaka nsitati na miti mikina za waatta eettaka Yeruzaleemu. ");
INSERT INTO eko_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ntthu mmote khumuuzela yoori: “Mbwana, vattitthiiru atthu anttelaaye wuusurukha?” ");
INSERT INTO eko_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Yinsa khunjipu araka: “Mwijilipise yoori mwivire vanlako woophunyeya, maana a waatta anlawa eekese ovira ila khanteela owahi. ");
INSERT INTO eko_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mwennyewe nyuupa amana alankha afuka nlako awe, mweeyo mwinsala vaje mwipiyaka nlako na mwivekaka yoori: ‘Mbwana mwinifukulele!’ Ye ontta wuujipuni araka: ‘Akinjuwa ohali mwinlankhaawo.’ ");
INSERT INTO eko_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Aphano mwinlawa mwalupe yoori: ‘Naja vamote, khunywa vamote na wanozela mmuti mwetthu.’ ");
INSERT INTO eko_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ila ye onlawa ajipu yoori: ‘Akinuujuwani wala ohali mwinlankhaawo akinjuwawo, mwikisuse mweeyo anamaretta zootakhala.’ ");
INSERT INTO eko_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mwinlawa mwamoone Eburahiima, Esiyaakha, Yaakhumpa na manapiyu ooshi ari muufwalume wa Nnyizinku, ila mweeyo mwiikareliwe oje. Attaapho onlawa weeyevo olila na oluma meeno. ");
INSERT INTO eko_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Atthu anttela olankha malawa-njuwa akina okhu lintupweelaawo njuwa, kusini na kashikhazini ate eekhale vameeza woofwalume wa Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Miiyo kiniwuuzani khweele yoori, awaapho amwanzo anttelaaye wiiya awiishela, na awiishela anttelaaye wiiya amwanzo.” ");
INSERT INTO eko_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wakathi otthuupule khutavo mafwarizeewu khumuuza Yinsa yoori: “Oleevo apha, maana Erooti ontakha owuula.” ");
INSERT INTO eko_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ye khuwaajipu yoori: “Mwilawe mwamuuze nanthala aya oto yoori: Leelo na meesho kiniikara masheethwani na owaavonisa alwele, siikhu yattaatthu kintta wiishisa khaazi yaka. ");
INSERT INTO eko_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Enhithajiya, leelo, meesho na nrotto ovira kilawaka; maana weekhweele khaavo napiyu amfwaaye nti nkina woohiiyi Yeruzaleemu! ");
INSERT INTO eko_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yeruzaleemu, Yeruzaleemu, oniwoolaaye manapiyu na owaavonya anamalaleya apale omperekheziwaaye! Swaafu kavi miiyo kitakhaka owaakusanya aanaawo nkhama mwanakhu aniwaakusanyaazo aanaawe mmapaphelo mwawe, ila weeyo khuhitakhi? ");
INSERT INTO eko_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Apho moone yoori nyuupa yenu enttela wiiya puuro yoohiikhaliwi. Weekhwele kiniwuuzani yoori khamwinteela okoona theenya mpakha wakathi mwinttelaaye olupa yoori: ‘Attottopeliwe otule antaaye khwa nzina la Mbwana!’” ");
INSERT INTO eko_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Saapatu moote, Yinsa aalawiye wa nttunkhulu mmote wa mafwarizeewu olawa oja, atthu aari nttumphule khusala amweekesela Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Attaaphale aariivo, arivo mwinyi aavipiyeeyo mwiili awe wooshi. ");
INSERT INTO eko_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yinsa khuwoozela mafwarizeewu na anamanozela a kano araka: “Enkhupaleliwa onvonisa nlwele saapatu ama wala?” ");
INSERT INTO eko_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ila yo khwiiya oonyamala. Attaaphale, khunkhola mwinyi otule nkhono awe, khunvonisa khumuuza olawa safwari zawe. ");
INSERT INTO eko_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Aphano khuwoozela yoori: “Paani wa mweyo anraaye amooniye mwanawe ama mompe yawe ekweliye vanlipu khuhilazivo nasaapiru eri saapatu?” ");
INSERT INTO eko_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yo khuhiwahi ojipu. ");
INSERT INTO eko_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Wakathi ajuwiyeevo yoori atthu apale aalaleyiweeyo njampo aari othawula puuro za wiilokozi, Ye khulupa nlikaniso opu: ");
INSERT INTO eko_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Amana olaleyiwa njampo la harusi, ohithawule puuro etile ya wiilokozi, maana khinjuweya alaleyiwe ntthu wootepa oshitahiwa zayita weeyo. ");
INSERT INTO eko_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","N'oota otule oolaleyiyeeyo ontta owuuza yoori: ‘Puuro eto omwinkhe otu’. Attaaphale weeyo oniiya woopatthiwa ti haaya olawaka wiikhala puuro ya wiishela. ");
INSERT INTO eko_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ila amana olaleyiwa ona yawiikhala puuro ya wiishela, n'oota otule oolaleyiyeeyo ontta owuuza yoori: ‘Swaahipu, ote wiikhale puuro eti ya wiilokozi’. Aphano, weeyo onttela wiiya woohishimiwa venkivene vakatthi wa ananlaleyiwa ooshi. ");
INSERT INTO eko_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Maana wakhula otule anjiwulisaaye ontta opushuwisiwa na otule anjipushuwisaaye ontta owulisiwa.” ");
INSERT INTO eko_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Attaaphale Yinsa khumuuza mwinyi otule anlaleyiyeeyo yoori: “Amana wiiyana etthu-yoojiwa yawo ama njampo lawo ohiwaalaleye attwiizo, ashirikhaawo, ajamaazo ama anamwaattamanani awo oothaajiri, yoori na-yo ahuulaleye wumpuwa nkhama oriphana. ");
INSERT INTO eko_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ila amana wiiyana njampo owaalaleye asikhini, anamarakala na atthu oohooni. ");
INSERT INTO eko_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Toowo oparikhiyiwa onttela wiiya wawo, maana apo aya khanlawa wiiyana etthu yawuurutisela. Oriphiwa wawo onttela ota siikhu yoosisimuliwa anashariya.” ");
INSERT INTO eko_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ntthu mmote wa atthaapale aariina vameeza asiiliyeevo mattakhuzi apale khumuuza Yinsa yoori: “Ooshapweyiwa pi apale anttelaaye oja njampo l'oofwalume wa Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Aphano Yinsa khujipu yoori: “Mwinyi mmote aarina njampo lawe khuwaalaleya atthu a waatta. ");
INSERT INTO eko_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","N'oofiya wakathi khunruma karumeyaawe olawa owooza anamalaleyiwa yoori: ‘Mwite, zalikana.’ ");
INSERT INTO eko_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ila wakhula mmote khwaaza olupa tafwawuthi zawe, wamwanzo khulupa yoori: ‘Keetta wuuzanya nshapa laka, apha kinttela woona, kinveka nswammaha.’ ");
INSERT INTO eko_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Waphiiri khulupa yoori: ‘Keetta wuuzanya mompe khumi zoolima, kintakha kilawe keezelele, kinveka nswammaha.’ ");
INSERT INTO eko_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wattaatthu khuri: ‘Kintta wiisharu oloola, akinwahi olawa.’ ");
INSERT INTO eko_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Karumeya otule khuruti khulawa khumuuza mbwanaawe vitthu epile. Mwennyewe njampo khwiiya wa wiiphiiriwa khulupa yoori: ‘Waakuve olawe mmatarikhi na mmamuti wa sitati wawaatiise anamarakala, asikhini na apale oohooni.’ ");
INSERT INTO eko_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Karumeya otule n'ooruti khulupa yoori: ‘Mbwana, karetta epile mwaakirumiyeezo, ila nalelo zinsala puuro.’ ");
INSERT INTO eko_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mbwanaawe khumuuza yoori: ‘Olawe mmatarikhi khuulu na mmamiphiitelo, wa waakhanyarele apale onttelaaye owaasikana ate eetaale vaje vaka. ");
INSERT INTO eko_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kiniwuuzani yoori khaavo khwa apale aalaleyiweeyo anttelaaye oja njampo laka.’” ");
INSERT INTO eko_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Siikhu moote, atthu a waatta eetta onlottelela Yinsa, Ye khuzukuluwa khuwooza yoori: ");
INSERT INTO eko_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Otule antakhaaye okilotta, ona yookipheta channu zayita papaawe, mamaawe, muukhaawe, aanaawe, attwiize, alupuwe, ama ohaayi awe, n'oohiretti etthiipo khaniiya nakhiyoni aka. ");
INSERT INTO eko_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Wakhula otule ahinthuulaaye nsalapa awe akilotta khaniiya nakhiyoni aka. ");
INSERT INTO eko_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Paani wa mweeyo anraaye atakhaka ojeka korofwa yawe, ahinaazaaye wiikhala khapula attheela hisapu vitthu zintakhaavo oona nkhama onwahi wiishisa? ");
INSERT INTO eko_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ahirettiru etthiipo, ye ontta waaza ila khaniishisa. Atthu apale anttelaaye omoona antta ontheya alupaka yoori: ");
INSERT INTO eko_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Mwinyi otu aaza ojeka ila khanwahi wiishisa.’ ");
INSERT INTO eko_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ama mfwalume-ni anraaye alawaka wuumana viittha na mfwalume nkina khuhaazi wiikhala khapula apheleleza na anajanka awe apale alufu khumi, nkhama anlawa awaakhitiri apale alufu eshiriini anttelaaye wuumanana? ");
INSERT INTO eko_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Amana ahiretti toowo, apale ahinafiye ari peetiwene nalelo, ontta onruma waziri awe olawa owaavekela heeri. ");
INSERT INTO eko_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Khwa nanna etthiipo wakhula mmote wa mweyo ahinlikhaaye epile ariinaazo khansuhi wiiya nakhiyoni aka. ");
INSERT INTO eko_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Mwiinyu ona fwayita, khi mmana olikha onyuunya onrutiseleya toovi onyuunya waya? ");
INSERT INTO eko_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Khunretteliwa etthu wala mmashapa ama shituruumu, ontta wiitthiwa. Otule ariina mashiilo, ti asiile.” ");
INSERT INTO eko_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Wakathi nkina anamariphisa lumpuru na anatwampi khusala ata oteela onsiila Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mafwarizeewu na anamanozela a kano khusala aapa araka: “Mwinyi otu oniwaapokherela anatwampi khusala aja vamote na-yo.” ");
INSERT INTO eko_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Aphano Yinsa khuwooza nlikaniso mmote araka: ");
INSERT INTO eko_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Paani mmote wa mweyo anraaye arina pwittipwitthi zawe miiya khumwaashikha moote, khuhilikhi ntthuttu epile tiisiini na tiisiya zisaliyeezo, eettela etile moote emwaashikhiyeeyo mpakha opattha? ");
INSERT INTO eko_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Amana asikana ontta ovikela ari woofurahi, ");
INSERT INTO eko_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","khusala arutela owawe. N'oofiya oniwaakhuwela maswaahipu zawe na anamwaattamanani awe awooze yoori: ‘Nlaweni nitthape, maana kapattha pwittipwitthi yaka etile yaakaashikhiyeeyo.’ ");
INSERT INTO eko_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Khwa nanna etthiipo kiniwuuzani yoori onttela wiiyawo otthapa nwulweene pinkuuni mwaasa wa natwampi othupwiya, zayita atthu tiisiini na tiisiya anashariya ahinhithajiyaaye othupwiya.” ");
INSERT INTO eko_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kuvira araka: “Ama muukha-ni anraaye arina nzurukhu awe khumi, khumwaashikha mmote khuhikhozi khantteya aseela nnyupa mwawe, eekesa w'aakhilivo mpakha opattha? ");
INSERT INTO eko_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Amana apattha oniwaakhuwela maswaahipu zawe na anamwaattamanani awe awooze yoori: ‘Nlaweni nitthape, maana kapattha nzurukhu aka opule waakaashikhiyeeyo.’ ");
INSERT INTO eko_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Miiyo kiniwuuzani yoori eniiyavo furaha khuluyeene vakatthi wa malayikha a Nnyizinku mwaasa wa natwampi mmote othupwiya.” ");
INSERT INTO eko_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yinsa khurutela theenya yoori: “Aarivo mwinyi mmote aariina aanaawe awiri. ");
INSERT INTO eko_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Otu nttiitthi aya khumuuza papaawe yoori: ‘Paapa, mwikinkhe lifunku la erathi yaka.’ Papaawe khuwaawanyela maali epile aanaawe. ");
INSERT INTO eko_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Oviriyeevo wakathi vattitthiiru, mwaana otule nttiitthi khuthuula maali zawe epile aawanyeliweezo khulawa tuniya kiina ya woolepawo. Ottuukho khuharipu maali zawe epile khwa mwentto woololo. ");
INSERT INTO eko_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","N'ooharipu zooshi khupuwa jala ya waatta mmuti mwaya mphule, ye khusala ahankayikha. ");
INSERT INTO eko_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Khulankha mpakha wa mwinyi mmote wa tuniya ethiitile khunvekela khaazi, ye khumwinkha oshukisa kuluwe zawe ntthuttu. ");
INSERT INTO eko_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ye aari ohithajiya oja vitthu epile zaari ojiwaazo pi kuluwe na khaavo aari omwinkhaaye etthu-yoojiwa. ");
INSERT INTO eko_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Khujipayini khuri: ‘Anakhaazi a paapa ana etthu-yoojiwa yoowaafiyela, miiyo kiri okhuno entta okikhola jala. ");
INSERT INTO eko_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kintta olankha kilawe wa paapa khamuuze yoori: Paapa, kakosa mmakhono wa Nnyizinku na mmakhono mwenu. ");
INSERT INTO eko_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Akinsuhi theenya wiitthiwa yoori ki mwanenu, mwikipokherele nkhama mmote wa anakhaazi enu.’ ");
INSERT INTO eko_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Khulankha khusala alawa mpakha wa papaawe. Nalelo ari peetiwene papaawe khumoona, khwiiyana huruma khuluyeene khusala antthirela khulawa khumpatikha na khumpejari. ");
INSERT INTO eko_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Attaaphale mwaana otule khumuuza papaawe yoori: ‘Paapa, kakosa mmakhono wa Nnyizinku na mmakhono mwenu. Akinsuhi wiitthiwa yoori ki mwanenu.’ ");
INSERT INTO eko_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ila papaawe khuwooza akarumeya awe yoori: ‘Mwaakuve, mwitiise kuwo zooziti oshapweya mwinwalise. Na peetthe mwinwalise nzaala mwawe na shapattho mmoolu mwawe. ");
INSERT INTO eko_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mwilawe onzizi mwanthuule mwaana wa mompe otule eesheliyeeyo oneneva mwite mwishije, nirette njampo la furaha. ");
INSERT INTO eko_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mwaasa yoori mwanaka otu aafwiiye apha ori haayi; aashikhiye apha apattikhana.’ Khwaaziwa njampo. ");
INSERT INTO eko_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Epo zaari orettikhana mwaana otule nwulu ari omashapa. Khuta mpakha kharipu na vaje, khusala asiila koma zeettaka ovuma na atthu eettaka wiina. ");
INSERT INTO eko_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Aphano ye khunkhuwela karumeya mmote wa vaje attaaphale khumuuzela niini yaari orettikhanaaye. ");
INSERT INTO eko_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ye khumuuza yoori: ‘Ttwiiyo ti ye arutiyeeyo, papaawo khunshijela mwaana wa mompe otule eesheliyeeyo oneneva, mwaasa wompokherela ari haayi.’ ");
INSERT INTO eko_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mwaana otule nwulu khwiiphiiriwa khuhisala atakha oviramo. Attaaphale papaawe khusaruwa khusala ankhanyarela. ");
INSERT INTO eko_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ila ye khumuuza papaawe yoori: ‘Moone! Nyaakha za waatta kuurumeyelakani, wala akinakhijilele hatha nttakhuzi lenu limote. Ila khamwinakinkhe hatha puuzi moote yoori kirette njampo na ashirikha aka. ");
INSERT INTO eko_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Arutiyeevo mwanenu oto aharipwiyeeyo vitthu zenu na amalempe, mwanshijela mwaana wa mompe otule wooneneva aya.’ ");
INSERT INTO eko_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Aphano papaawe khumuuza yoori: ‘Mwanaka! Wakhula siikhu oniiya vamote na-miyo, wakhula etile kiriina ti yaawo. ");
INSERT INTO eko_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ila yaari ohithajiya oretta njampo la furaha, mwaasa yoori ttwiiyo aafwiiye apha ori haayi, aashikhiye apha apattikhana.’” ");
INSERT INTO eko_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yinsa khuwooza anakhiyoni awe yoori: “Aarivo mwinyi mmote wa thaajiri aariina namalokozela wa anakhaazi awe, khuuziwa yoori: ‘Namalokozela otule ontta oharipu maali zawo.’ ");
INSERT INTO eko_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ye khunkhuwelisa khumuuzela yoori: ‘Niini epi kinsiilaazo onrettaazo weeyo? Otiise warakha za kontha koone etthu oretteliyeeyo nzurukhu aka. Maana khunteela orutela wiiya namalokozela wa anakhaazi.’ ");
INSERT INTO eko_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Namalokozela wa anakhaazi otule khuupuwela toono: ‘Kinttela oretta-ni mbwanaaka amana akilikhisa khaazi? Othipa akinkhitiri na olawa olola enikipattha haaya. ");
INSERT INTO eko_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aa, kajuwa etthu yooretta yoori amana kiikariwa atthu akipokherele mmavaje mwaya.’ ");
INSERT INTO eko_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Aphano ye khuwaakhuwela ooshi apale aari wiiliwaaye ti mbwanaawe. Khumuuzela otule wamwanzo yoori: ‘Oniwiila kavi mbwanaaka?’ ");
INSERT INTO eko_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ye khujipu yoori: ‘Onikiila ttompwiyo miiya za mafuttha.’ Namalokozela wa anakhaazi otule khuri: ‘Teeni yawo ti eti eriiye vawarakha apha, wiikhale waatikhe hamusiini.’ ");
INSERT INTO eko_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Elottelanaka khumuuzela otule waphiiri yoori: ‘Khi weeyo oniiliwa kavi ti mbwanaaka?’ Ye khujipu yoori: ‘Kiniiliwa miphimo miiya za tiriku.’ Namalokozela wa anakhaazi otule khumuuza yoori: ‘Teeni yawo eti eriiye vawarakha apha, waatikhe thamaaniini.’ ");
INSERT INTO eko_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Aphano mbwanaawe khunttottopela namalokozela wa anakhaazi otule woohaamineyi mwaasa wa akhili epile aariinaazo. Miiyo kiniwuuzani yoori, atthu a voolumwenku apha ana akhili za waatta mmenttezi mwaya, zayita atthu apale aneettettaaye nnuuru. ");
INSERT INTO eko_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Apho kiniwuuzani yoori: mwirumeyele maali zenu za voolumwenku apha zoohiiyi za shariya yoori mwiiwaapatthe ashirikha, amana ziwiishelani yo oopokhereleni pinkuuni. ");
INSERT INTO eko_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Otule anaamineyaaye khwa etthu ttiitthiiru onaamineya khwa etthu khuluyeene; otule ahinaamineyaaye khwa etthu ttiitthiiru hatha etthu khuluyeene khanaamineya. ");
INSERT INTO eko_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nkhama khamwaamineyeeni na maali za voolumwenku zoohiiyi za shariya, paani anttelaaye owaaminini na maali zookhweele? ");
INSERT INTO eko_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nkhama khamwaamineyeeni na vitthu za watthu, paani anttelaaye owinkhani etthu enttelaaye wiiya yeenu? ");
INSERT INTO eko_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Khaavo karumeya anwahaaye owaarumeyela a mbwana awiri, mwaasa yoori ontta omwiiphiirisa mmote, antuvelise otu nkina; ama oniiya wa waamineya khwa otu mmote, antarawu otu nkina. Khinwaheya onrumeyela Nnyizinku na Nzurukhu.” ");
INSERT INTO eko_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mafwarizeewu apale oopheta nzurukhu na kuvu, n'oosiila mattakhuzi apale khusala antheya Yinsa antarawaka. ");
INSERT INTO eko_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Aphano Ye khuwooza yoori: “Mweeyo pi apale oojoona wiiya anashariya vakatthi wa atthu, ila Nnyizinku onjuwa rooho zenu. Etile atthu anoonaaye wiiya ya fwayita, omaasho wa Nnyizinku ti yootaraweya. ");
INSERT INTO eko_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Kano na manapiyu khazilikheleleeni mpakha wakathi wa Yaahaya. Waaza wakathi otthuupo hapari za Ofwalume wa Nnyizinku zinvira zilaleyiwaka, wakhula ntthu onjilipisa yoori eettemo. ");
INSERT INTO eko_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ti yookhweya pinku na vathi wiisha zayita olaziwavo alama ttiitthiiru ya nttakhuzi la kano. ");
INSERT INTO eko_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Wakhula nlume animwaashaaye muukhaawe khunrala muukha nkina ontta oraruwa; na aninralaaye muukha otule wa waashiwa na-ye ontta oraruwa.” ");
INSERT INTO eko_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yinsa khurutela olupa theenya yoori: “Aarivo mwinyi mmote wa thaajiri aari owalaaye kuwo zooshapweya na zootafikhana, na wakhula siikhu eetta opuha, owawe yaari wiipikhiwawo etthu-yoojiwa ya nnofu. ");
INSERT INTO eko_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Vanlako wa thaajiri otule aattattikheliwevo masikhini mmote wa waatta makhwatta aari wiitthiwaaye Laazaru. ");
INSERT INTO eko_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Aari ohithajiya oja tathela zaari okwaazo vameeza wa thaajiri otule, anapwa khusala ata olapa makhwatta awe. ");
INSERT INTO eko_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Masikhini otule khufwa, khuthuuliwa pi malayikha khulawa khwiiya vamote na Eburahiima. Na-ye thaajiri otule khufwa khulawa khuzikhiwa. ");
INSERT INTO eko_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Motthooni okhule eettaka woona shaani, ye khulansa maasho awe khweekesa otulu khumoona Laazaru ari mpavu wa Eburahiima. ");
INSERT INTO eko_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ye khusala akhuwa araka: ‘Paapa Eburahiima, kooneleni huruma! Mwinrume Laazaru anaanise yaala yawe na maati ate azizimise nlimi laka, maana kintta ohukhumweya vamoottho apha kiriivo.’ ");
INSERT INTO eko_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Eburahiima khunjipu yoori: ‘Mwanaka, omfwahamu yoori muuhaayi mwawo waapokheriye vitthu zooshapweya, ila Laazaru muuhaayi mwawe eetta ohoowa. Aphano ye asithirikha, weeyo ontta ohoowa. ");
INSERT INTO eko_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Olikha eto, vakatthi vetthu yatthiiwavo khilintti khuluyeene ehinlokheyaaye ntthu olankha okhuno ataaka okho wala okho ataaka okhuno.’ ");
INSERT INTO eko_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Thaajiri khulupa yoori: ‘Paapa Eburahiima, safwatali kinuuvekelani yoori mwinrume Laazaru alawe wa ajamaazaku, ");
INSERT INTO eko_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kinaaye attwiizaku athaanu alawe awooze yoori ahipatthe ota okhuno kiriiwo woohoowiwawo.’ ");
INSERT INTO eko_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Eburahiima khunjipu yoori: ‘Attwiizo anaaye kano za Munsa na kithaapu za manapiyu, asiileze etthiipo.’ ");
INSERT INTO eko_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Thaajiri khukhanyarela araka: ‘Wala paapa Eburahiima! Amana ntthu asisimuwa muufwa alawa awooza, antta othupwiya.’ ");
INSERT INTO eko_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Eburahiima khujipu yoori: ‘Ahisiileziru kano za Munsa na za manapiyu, hatha nkhama ntthu eetta osisimuwa muufwa, yo khanteela okhupali.’” ");
INSERT INTO eko_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yinsa khuwooza anakhiyoni awe yoori: “Enteela opuwa vitthu zinteelaaye owaakwisela atthu ntwampi, ila atakhaliwa otule anttelaaye othowelela. ");
INSERT INTO eko_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Afwataali ntthu otupweeziwa mpahari afukeleliwe liwe liwululene mmwisiko, ehiiyeeni owaathowelelisa apele eeyiye oohikhomaali. ");
INSERT INTO eko_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mwiiyane ophoole: ttwiiyo amana ookosa, onshowere; amana athupwiya, onswaamihi. ");
INSERT INTO eko_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Amana ookosa swaafu sapa siikhu moote, na wakhula swaafu khusala ata olupa yoori: ‘Kathupwiya’, onswaamihi.” ");
INSERT INTO eko_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Maaswihaapa khunvekela Yinsa yoori: “Mbwana, weekezele amini yetthu!” ");
INSERT INTO eko_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mbwana khujipu araka: “Eriwaka amini yenu yeettiye wiiya nkhama phunje ttiitthiiru ya muuyu, mweetta wuuza muutthi opu yoori: ‘Okhuleye watupweele mpahari,’ opo weetta wuushututelani.” ");
INSERT INTO eko_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yinsa khuvira alupaka yoori: “Paani mmote wa mweyo anraaye nakhaazi awe woolima, ama wooshukisa pwittipwitthi ntthuttu, eettaka otaru animuuzaaye yoori: ‘Ote niikhale vameeza apha nije!’ ");
INSERT INTO eko_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kinoona yoori khaavo! Ila khapula onimuuza yoori: ‘Wiipikhe etthu-yoojiwa, owale kuwo zawo okirumeyele kijaka na kinywaka. Aphano amana kiisha na weeyo oje na onywe!’ ");
INSERT INTO eko_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Karumeya otule oninsuhi oshukhurweliwa mwaasa wooretta etile aarumiweeyo? Kinoona yoori wala! ");
INSERT INTO eko_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Etthiipo na-mweyo, amana mwiretta epile mwirumiweezo, mwina yoolupa yoori: ‘Naakarumeya oohiina maana; naretta etile naariina yooretta paasi.’” ");
INSERT INTO eko_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yinsa eettaka Yeruzaleemu, aaviriye enakatthi-nakatthi ya Samariiya na Kalileya. ");
INSERT INTO eko_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","N'oofiya nti aya opo, khuta anamakuttula khumi khweemela peetiwene ");
INSERT INTO eko_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","khusala ankhuwela araka: “Yinsa, Mwanliimu, noonele huruma!” ");
INSERT INTO eko_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ye n'oowoona khuwooza yoori: “Mwilawe mwajithoonyeze wa mahaakhimu a tiini.” Eettaka olawa etthiipile, yo khwiiya oovona. ");
INSERT INTO eko_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mmote wa apale khumi, nawoona yoori avona, khuruti ansifwaka Nnyizinku na huula yoonyakula. ");
INSERT INTO eko_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Khukokhora khufiyisa ajihi yawe vathi, khunshukhurwela Yinsa; ye aari nsamariiya. ");
INSERT INTO eko_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yinsa khumuuzela yoori: “Khahi atthu khumi avoniyeeyo? Khi apa akina tiisiya ari vayi? ");
INSERT INTO eko_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Khaavo awahiyeeyo oruti oteela onshukhurwela Nnyizinku, woohiiyi otu wa malaponi?” ");
INSERT INTO eko_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yinsa khumuuza yoori: “Olankhe olawe amini yawo yawuusuru.” ");
INSERT INTO eko_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Yinsa eetta wuuzeliwa pi a mafwarizeewu wakathi waari weettelaavo ota Ofwalume wa Nnyizinku. Ye khujipu araka: “Ofwalume wa Nnyizinku otaaka khunttela wiiya etthu enooneyaaye. ");
INSERT INTO eko_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Khina anttelaaye olupa yoori: ‘Moone, opu ori apha!’ ama ‘Opule oriiye okhule!’ Maana ofwalume wa Nnyizinku ori vakatthi venu.” ");
INSERT INTO eko_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Attaaphale khuwooza anakhiyoni awe yoori: “Onteela ofiya wakathi mwinttelaaye otakha wiiyana vamote nenkawu siikhu moote Mwaana wa Pinaatamu, ila ehisala ewaheya. ");
INSERT INTO eko_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Akinoko anlawa alupe yoori: ‘Ori okhule!’ ama ‘Ori apha!’ ila mwihilankhe olawa omweekesa. ");
INSERT INTO eko_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nkhama etthiipo taari enzerimaaye phantte moote yeettaka phantte kiina, enteela wiiya etthiipo siikhu anttelaaye ota Mwaana wa Pinaatamu. ");
INSERT INTO eko_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ila mwanzo ye ona yoohoowa venkivene na okatthaliwa pi atthu a leelo. ");
INSERT INTO eko_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nkhama zaarettikhaniyeezo wakathi opule wa Nuuhi, enttela orettikhana etthiipo wakathi wa Mwaana wa Pinaatamu. ");
INSERT INTO eko_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Atthu eetta oja na onywa, na oralana, mpakha siikhu Nuuhi aapakhiriyeeyo mmwaaraka, khuta nnyeri ooshi khufwa. ");
INSERT INTO eko_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nkhama zaarettikhaniyeezo wakathi wa Loothi. Atthu eetta oja na onywa, wuuzanya na wuuzanyisa, ozala na ojeka manyupa aya. ");
INSERT INTO eko_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Wakathi Loothi aliiyeewo Sotooma, khukwa vuula pinkuuni ya moottho na oka, khuwoola atthu ooshi. ");
INSERT INTO eko_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Enttela orettikhana etthiipo siikhu anttelaavo ota Mwaana wa Pinaatamu. ");
INSERT INTO eko_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Siikhu yaya eto, otule anttelaaye wiiya vatulu wa nyuupa ahiishukhe yoori alokotthele vitthu ziriiye nnyupa mwawe; otule anttelaaye wiiya ntthuttu ahirutele onti. ");
INSERT INTO eko_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mwimfikhirele muukha wa Loothi! ");
INSERT INTO eko_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Otule antakhaaye wuusuru ohaayi awe ontta ompwetheya, ila otule onimpwetheya ontta wuusuru. ");
INSERT INTO eko_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Miiyo kiniwuuzani yoori: osikhu wa siikhu ethiitile, atthu awiri oorapalela olili mmote, onttela othuuliwavo mmote asalevo mmote. ");
INSERT INTO eko_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Atthu awiri achilaka tiriku, onttela othuuliwavo mmote asale mmote. ");
INSERT INTO eko_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Atthu awiri ari mmashapa, onttela othuuliwavo mmote asale mmote.” ");
INSERT INTO eko_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yo khumuuzela Yinsa yoori: “Mbwana, enttela orettikhana vayi?” Yinsa khuwaajipu yoori: “Vahali aniiyaavo muufwi, anakhuku aniiya attaapho.” ");
INSERT INTO eko_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yinsa khuwooza anakhiyoni awe nlikaniso mmote yoori aarina yoolompa woohilikheleli wala woohinyoonyeyi. ");
INSERT INTO eko_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ye khulupa yoori: “Sitati moote aariwo namaphuka mmote ahaari omoovaaye Nnyizinku, wala ahaari onshitahaaye ntthu. ");
INSERT INTO eko_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Sitati ethiitile aariwo nunu mmote woofweliwa ti mannawe aalawiiyeeyo onvekela namaphuka otule araka: ‘Okaawanyele haakhi khwa muumani aka.’ ");
INSERT INTO eko_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Khunkatthalela wakathi mwinkeene, ila omwiisho waya khusala alupa nroho mwawe yoori: ‘Nakihimoovi Nnyizinku na ohinshitahi ntthu, ");
INSERT INTO eko_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nunu otu aaza raku okantipu; kintta omwaawanyela haakhi na paathuli yoori ahirutele okiwuti.’” ");
INSERT INTO eko_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mbwana Yinsa khuvira alupaka yoori: “Mwisiileze saana etthu anlupaaye namaphuka otu woohiiyi wa shariya. ");
INSERT INTO eko_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nnyizinku khaniwaawanyela shariya ananthawuliwa awe apale aninvekelaaye nthana na osikhu, hatha nkhama Ye eetta orupaza owaajipu? ");
INSERT INTO eko_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kiniwuuzani yoori Ye oniwaawanyela shariya woohirupazi. Aphano Mwaana wa Pinaatamu wakathi anrutelaavo voolumwenku apha, onteela osikanavo amini?” ");
INSERT INTO eko_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yinsa khulupa nlikaniso mmote awoozaka atthu apale aari ojoonaaye wiiya makhaamili khusala awaatarawu azaaya. Ye khuri: ");
INSERT INTO eko_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Alume awiri aaviriye Nnyupa wa Nnyizinku khusala alompa; mmote aari mfwarizeewu, nkina aari namariphisa lumpuru. ");
INSERT INTO eko_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mfwarizeewu ari wa weemela, aari olompa nkatthi-nkatthi araka: ‘Nnyizinku, miiyo kinuushukhurwela maana miiyo aki nkhama atthu, apale oheettetteli shariya, malatarawu anamararuwa, wala nkhama namariphisa lumpuru oto ariiye apho. ");
INSERT INTO eko_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Miiyo kimfuka siikhu piiri wakhula sumana na kininkha zaakha khwa lifunku lakhuumi ya wakhula etile kimpatthaaye.’ ");
INSERT INTO eko_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ila namariphisa lumpuru eemeliye peetiwene, ye hatha khaari wiinuwa yoori eekese otulu, ila ajipiyaka veefuwa aari ori: ‘Oo Nnyizinku koonele huruma, miiyo ki natwampi.’ ");
INSERT INTO eko_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Miiyo kiniwuuzani yoori, namariphisa lumpuru aalawiye owawe ari woohakikhiwa ti Nnyizinku, ila otule woojikhupali wala. Maana otule anjiwulisaaye ontta opushuwisiwa, ila otule anjipushuwisaaye ontta owulisiwa.” ");
INSERT INTO eko_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Atthu akina khusala awaatiisa asimaana yoori asapiwe ti Yinsa. Ila anakhiyoni awe n'oowoona khusala awaamaruwela. ");
INSERT INTO eko_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ila Yinsa khuwaakhuwela asimaana apale araka: “Mwiwaalikhe asimaana akiteele miiyo, mwihiwaakhattaze; maana Ofwalume wa Nnyizinku pu waaya apale eeyiye nkhama asimaana. ");
INSERT INTO eko_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Miiyo kiniwuuzani khweele yoori wakhula otule ahimpokherelaaye Ofwalume wa Nnyizinku nkhama nsimaana, khanteela weettamo.” ");
INSERT INTO eko_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nttunkhulu mmote khumuuzela Yinsa yoori: “Mwanliimu woosaana, kirette niini yoori kipatthe ohaayi wa mileele?” ");
INSERT INTO eko_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yinsa khunjipu araka: “Mwaasa wa niini okikhuwelaka yoori woosaana? Khaavo ntthu woosaana woohiiyi Nnyizinku paasi. ");
INSERT INTO eko_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Weeyo onjuwa mirumo za Nnyizinku: ohiraruwe, ohuule, ohiiye, wala ohilawele oshaahiti woovonyeya, onhishimu papaawo na mamaawo.” ");
INSERT INTO eko_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mwinyi otule khujipu yoori: “Waaza osimaana aka zooshi epo kinretta.” ");
INSERT INTO eko_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yinsa n'oosiila mattakhuzi apale khumuuza yoori: “Enuusaleela etthu moote. Wuuzanyise vitthu zawo zooshi nzurukhu aya owenkhe asikhini, toowo ontta wiiyana maali pinkuuni; nawiisha ote okilotte.” ");
INSERT INTO eko_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","N'oosiila mattakhuzi apale khwiiya woozinkuwa venkivene, mwaasa yoori ye aari thaajiri nwulweene. ");
INSERT INTO eko_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yinsa n'oomoona yoori azinkuwa khulupa yoori: “Nanna enlipaazo thaajiri weetta muufwalume wa Nnyizinku! ");
INSERT INTO eko_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ti yookhweya enkamiiya ovira valiphotto la sikano zayita thaajiri weettamo muufwalume wa Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Apale aari onsiilaaye khumuuzela yoori: “Nkhama pi toowo, paani anwahaaye wuusurukha?” ");
INSERT INTO eko_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yinsa khujipu yoori: “Etile pinaatamu ahinwahaaye Nnyizinku onwahi.” ");
INSERT INTO eko_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Aphano Pheeturu khumuuza Yinsa yoori: “Woone! Fweeyo nalikha vitthu zetthu zooshi, khusala nuulotta.” ");
INSERT INTO eko_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yinsa khujipu araka: “Miiyo kiniwuuzani khweele yoori, wakhula otule anlikhaaye nyuupa yawe ama muukhaawe, ama attwiize ama apapaze, ama aanaawe mwaasa wa Ofwalume wa Nnyizinku, ");
INSERT INTO eko_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","oto onteela opokhera venkivene vathi attaapha, na omwiisho waya apokhere ohaayi wa mileele.” ");
INSERT INTO eko_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yinsa khuwaakhuwelela othetekele anakhiyoni awe apale khumi na awiri khuwooza yoori: “Mwisiileze! Apha nintta Yeruzaleemu, ottuukho zinttelaawo orettikhana zooshi epile zaatikhiweeyo pi manapiyu monkoni wa Mwaana wa Pinaatamu. ");
INSERT INTO eko_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ye onttela winkheleliwa mmakhono wa amalapo, antheye, anveyise, antthemele, ");
INSERT INTO eko_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","anjaphe na amuule. Ila siikhu yattaatthu onttela osisimuwa.” ");
INSERT INTO eko_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Anakhiyoni awe khuhiweeleyi mattakhuzi aya apale maana aari oovitheya, yo khuhijuwi etthu aari olupaaye. ");
INSERT INTO eko_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yinsa asaleelaka ofiya Yeriko, mwinyi mmote woohooni eekhaliye nshini wa tarikhi alolaka zimola. ");
INSERT INTO eko_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","N'oosiila shintto za atthu aari oviraaye, ye khuuzela etthu yaari orettikhanaaye. ");
INSERT INTO eko_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Khuuziwa yoori: “Yinsa wa Nazareeti ti ye anviraaye.” ");
INSERT INTO eko_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aphano ye khusala akhuwa araka: “Yinsa, Mwaana wa Daawuuda, koonele huruma!” ");
INSERT INTO eko_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Atthu apale aari oviraaye khusala ammaruwela yoori anyamale, ila ye khusala atepa okhuwa araka: “Yinsa, Mwaana wa Daawuuda, koonele huruma!” ");
INSERT INTO eko_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Aphano Yinsa khweemela khuruma yoori atiiseliwe mwinyi otule. N'ootiiseliwa khumuuzela yoori: ");
INSERT INTO eko_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ontakha yoori kuurettele niini?” Ye khujipu yoori: “Mbwana, kintakha kirutele woona.” ");
INSERT INTO eko_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Attaaphale Yinsa khumuuza yoori: “Ona! Amini yawo yoovonisa.” ");
INSERT INTO eko_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nasaapiru ye khurutela woona, khusala anlotta Yinsa ansifwaka Nnyizinku. Wakathi atthu ooniyeevo etile yaarettikhaniyeeyo, khunsifu Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yinsa khuvira sitati ya Yeriko ettaka olawa. ");
INSERT INTO eko_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ottuukho aariwo mwinyi mmote aari wiitthiwaaye Zakewu, nttunkhulu wa anamariphisa lumpuru na aari thaajiri. ");
INSERT INTO eko_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ye aari otakha omoona Yinsa, ila khuhisala awahi mwaasa woofupheya channu na atthu aari enkeene. ");
INSERT INTO eko_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Aphano khutthira khulokoza khulawa khuwela mmutthi yoori awahi omoona, mwaasa yoori Yinsa aari weettela ovira attaaphale. ");
INSERT INTO eko_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yinsa n'oofiya puuro etile, khweekesa otulu khumoona khumuuza yoori: “Zakewu, waakuve wiishukhe, leelo kinttela omaka vaje vawo.” ");
INSERT INTO eko_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Attaaphale, ye khwiishukha wa waakuvavo khumpokherela Yinsa na furaha. ");
INSERT INTO eko_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Atthu apale akinoko aari woonaaye vitthu epile, khwaaza ottettha araka: “Nka mooneni otu onttela omaka vaje wa natwampi!” ");
INSERT INTO eko_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakewu khulankha khweemela khumuuza Mbwana yoori: “Woone Mbwana! Kintta owenkha asikhini phantte moote ya maali zaka na apale kaari oweeyelaaye, kintta owaarutisela swaafu nne.” ");
INSERT INTO eko_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Aphano Yinsa khulupa yoori: “Leelo vaje apha yafiyavo nusura maana otu na-ye peewu ya Eburahiima. ");
INSERT INTO eko_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mwaasa yoori Mwaana wa Pinaatamu ateela oweekesa apale aashikhiiyeeyo awoosuru.” ");
INSERT INTO eko_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yinsa aattameliyeevo Yeruzaleemu, atthu khusala oopuwela yoori Ofwalume wa Nnyizinku waari oteela orettikhana nasaapiru. Aphano Yinsa khulupa nlikaniso opu araka: ");
INSERT INTO eko_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Nlume mmote w'oojama wootafikhana, aasaafiriye khulawa nti woolepawo yoori athawaziwe ofwalume nawiisha aruti. ");
INSERT INTO eko_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ahinalawe khuwaakhuwela akarumeya awe khumi, wakhula mmote khumwinkha nzurukhu wa feeta khuwooza yoori: ‘Mwirettele zanshara mpakha miiyo oruti.’ ");
INSERT INTO eko_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ila atthu a mmuti mwawe khwiiya awiiphiiriwa, khunruma waziri onlotta olawa olupa yoori: ‘Khanimweepu wiiya mfwalume etthu.’ ");
INSERT INTO eko_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","N'oothawaziwa ofwalume khurutela owawe, khulawa khuwaakhuwela akarumeya awe apale aawenkhiyeeyo nzurukhu wa feeta yoori ajuwe fwayita apattheliyeeyo wakhula ntthu. ");
INSERT INTO eko_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Khuta otule wamwanzo khulupa yoori: ‘Mbwana, nzurukhu opule mmote mwaakinkhiyeeyo kapatthela fwayita, wafiya khumi.’ ");
INSERT INTO eko_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mbwanaawe khunjipu yoori: ‘Waretta saana, o karumeya wa waamineya. Mwaasa yoori weeyo waamineya khwa vitthu vattitthiiru, apho onttela wiiya mfwalume wa sitati khumi.’ ");
INSERT INTO eko_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Otule waphiiri khuta khulupa yoori: ‘Mbwana, nzurukhu enu opule mwaakilikheliyeeyo, kapatthela fwayita wafiya mithaanu.’ ");
INSERT INTO eko_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Khumuuza yoori: ‘Kemaani, weeyo onttela wiiya mfwalume wa sitati thaanu.’ ");
INSERT INTO eko_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Otule wa wiishela khuta khulupa yoori: ‘Mbwana, nzurukhu enu opu, miiyo kaatthiiye mmufukho khuthokorela. ");
INSERT INTO eko_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Miiyo keetta owoovani mwaasa woojuwa yoori mweeyo mwa awoopisa, mwinthuula etthu mwihithokoreleeni na mwinuurula mwihizaleeni.’ ");
INSERT INTO eko_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mbwana otule khuri: ‘Karumeya wootakhala rooho! Kintta wuuphuka khwa mattakhuzi awo atthaapo! Weeyo waajuwiye yoori ki ntthu wa woopisa, kinthuulavo etile kihithokoreleeni na kinuurula etile kihizaleeni. ");
INSERT INTO eko_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Khi wahaathuuliye nzurukhu aka ottha mpanko n'ooruti kisikana ottheerelaniye?’ ");
INSERT INTO eko_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Khuwooza apale aari attaaphale yoori: ‘Mwinnyakanye nzurukhu aya opo mwimwinkhe otule ariina khumi.’ ");
INSERT INTO eko_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Yo khujipu yoori: ‘Otu aya mwinlupaaye yoori nimwinkhe onaaye nzurukhu khumi!’ ");
INSERT INTO eko_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mbwana khulupa yoori: ‘Kiniwuuzani khweele yoori otule ariina ontta weekezeliwa, otule ahina hatha etile ariina ontta onyakanyiwa. ");
INSERT INTO eko_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Maatuwi aka apale ahaari okitakhelaaye ofwalume, mwiwaatiise apha ooliiwe kiwoonaka.’” ");
INSERT INTO eko_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Paata ya wiisha olupa mattakhuzi apale, Yinsa khusala avira awelelaka eettaka Yeruzaleemu. ");
INSERT INTO eko_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Asaleelaka ofiya nti wa Betifwaye na wa Betaaniya kharipu ya mwaako Oluveera, khuwaalokozisa anakhiyoni awe awiri. ");
INSERT INTO eko_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Khuwooza yoori: “Mwilawe mmuti mphule, mwifiyaka mwinlawa mwansikane mwaana wa puuru afukeleliwe woohaazi opakhiriwa. Mwimfukule mwintiise. ");
INSERT INTO eko_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Amana apuwa ntthu awuuzelani yoori: ‘Mwinimfukulela-ni?’ Mwinjipu yoori: ‘Mbwaneetthu ti ye anintakhaaye.’” ");
INSERT INTO eko_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Apale aawaarumiyeeyo khulawa khusikana nkhama etthiipile aalupiyeezo Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Wakathi aari omfukulaavo mwaana wa puuru otule, ennyewe khuwoozela yoori: “Mweyo! Mwaana wa puuru oto mwinimfukulela-ni?” ");
INSERT INTO eko_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Yo khujipu yoori: “Mbwaneetthu ti ye anintakhaaye.” ");
INSERT INTO eko_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Aphano khuntiisela Yinsa, yo khuttattikhavo kuwo zaya vapuuru Ye khupakhiravo. ");
INSERT INTO eko_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ataaka Yinsa, atthu khusala attattikha kuwo zaya ntarikhi. ");
INSERT INTO eko_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wakathi aattameliyeevo vamwiishukhelo wa mwaako Oluveera, khuntti ya anakhiyoni ooshi khwiiya oofurahi khwaaza onyakula ansifwaka Nnyizinku khwa minjuza epile ooniiyeezo, ");
INSERT INTO eko_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","araka: “Attottopeliwe mfwalume antaaye khwa nzina la Mbwana. Yiiyewo heeri pinkuuni na siifwa otulu.” ");
INSERT INTO eko_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mafwarizeewu apale aari vakatthi wa atthu apale khusala amuuza Yinsa yoori: “Mwanliimu, owooze anakhiyoni awo anyamale.” ");
INSERT INTO eko_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ye khuwooza yoori: “Atthu apa amana anyamala, mawe pi anttelaaye onyakula.” ");
INSERT INTO eko_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Wakathi Yinsa afiiyeevo Yeruzaleemu, nawoona sitati etile khulila, ");
INSERT INTO eko_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","araka: “Oo! Yeruzaleemu, eriwaka waari onjuwa otule aniwinkhaaye heeri leelo! Ila apho epo zaya zavitheya khwa weyo. ");
INSERT INTO eko_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Onlawa wafiye wakathi maatuwi enu anttelaaye wuukukuttelani phantte zooshi ari mmaphotto mwaya. ");
INSERT INTO eko_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Onttela ophwantteliwa vamote weeyo na aanaawo, khalinlawa osala hatha liwe vatulu wa liwe nzaaya, maana weeyo khumpokhereleeni Nnyizinku wakathi aateeliyeeyo owuusuru.” ");
INSERT INTO eko_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yinsa khuvira Nnyupa wa Nnyizinku khusala aweekara apale aari wuuzanyisaamo, ");
INSERT INTO eko_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","awoozaka yoori: “Yaatikhiwa yoori: ‘Nyuupa yaka enttela wiiya nyuupa yoolompiwamo, ila mweeyo mwarettisa wiiya puuro ya malatarawu.’” ");
INSERT INTO eko_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Wakhula siikhu Yinsa eetta onozela Nnyupa wa Nnyizinku, ila attunkhulu a mahaakhimu a tiini, anamanozela a kano na anamalokozela a atthu aari weekesa shawuri zoomuula, ");
INSERT INTO eko_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ila khuhisala apattha nanna yooretta, maana atthu ooshi aari omwiitaalela Ye n'onsiileza. ");
INSERT INTO eko_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Siikhu moote, Yinsa aari owaanozela atthu Nnyupa wa Nnyizinku na awaatafusirelaka hapari zooshapweya. Nttumphule khutamo attunkhulu a mahaakhimu a tiini, anamanozela a kano na anamalokozela a tiini. ");
INSERT INTO eko_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Yo khusala amuuzela araka: “Vitthu epi onrettana ofwalume-ni, wala ti paani awinkhiyeeyo ofwalume aya opo?” ");
INSERT INTO eko_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yinsa khuwaajipu yoori: “Na-miyo kintta owuuzelani etthu moote mwikuuze; ");
INSERT INTO eko_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","woosa wa Yaahaya waari wa pinkuuni ama wa anaatamu?” ");
INSERT INTO eko_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yo khusala oozelana atthaaporu araka: “Amana nilupa yoori waari wa pinkuuni, ontta onuuzela yoori: ‘Khi mwaasa aya niini mwihinkhupalelaka?’ ");
INSERT INTO eko_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na amana nilupa yoori waari wa anaatamu, atthu ooshi antta onivonya na mawe maana ankhupalela yoori Yaahaya napiyu.” ");
INSERT INTO eko_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Attaaphale yo khujipu yoori: “Khanijuweeni nlupa amwinkhiyeeyo ofwalume.” ");
INSERT INTO eko_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Aphano Yinsa khuwooza yoori: “Na-miyo akiniwuuzani ofwalume kinrettanaaye vitthu epi.” ");
INSERT INTO eko_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yinsa khulupa nlikaniso awoozaka atthu yoori: “Aarivo mwinyi mmote aazaliyeeyo mmashapa mwawe miitthi za wuuva, khuweekesa atthu yoori asala alimela, ye khulawa safwari yawe khwiikhala siikhu za waatta. ");
INSERT INTO eko_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","N'oofiya wakathi wa wuurula khunruma karumeyaawe mmote yoori alawe enkiwe wuuva, ila anamalima apale khumpiya, khumwiikara woohimwinkhi etthu. ");
INSERT INTO eko_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mwennyewe nshapa khunruma nkina, na oto theenya yo khunveyisa, khumpiya khumwiikara woohimwinkhi etthu. ");
INSERT INTO eko_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Aphano khunruma wattaatthu, anamalima apale khumpiya, khunvulalisa na khumwiikara. ");
INSERT INTO eko_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Paata ya toole, mwennyewe nshapa khusala oopuwela araka: ‘Kirette-ni? Aa! Kintta onruma mwanaka kinimphetachaaye, n'oomoona khweele khweele antta onhishimu.’ ");
INSERT INTO eko_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Anamalima apale wakathi amooniyeevo mwaana wa mwennyewe nshapa ntthile khulupa yoori: ‘Namarithi nshapa ntthi ti otu. Olawa nimuule, liiye leetthu.’ ");
INSERT INTO eko_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Khunsukhumela othetekele wa nshapa khumuula. Mwennyewe nshapa onttela owaarettela niini? ");
INSERT INTO eko_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ye ontta ota awoole anamalima apale, nshapa laya ntthile awenkhe atthu akina.” Atthu apale aariivo n'oosiila mattakhuzi apale khulupa yoori: “Zihirettikhane vitthu epo!” ");
INSERT INTO eko_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yinsa khuweekesa khuwoozela yoori: “Maana a mattakhuzi apa aatikhiweeyo anlupa-ni? ‘Liwe ntthile eeseliyeeyo anamajeka nyuupa, larettiwa wiiya liwe lootafikhana zayita mawe ooshi.’ ");
INSERT INTO eko_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Otule anttelaaye okwela liwe nttho ontta onyenyeya, na otule lininkwelaaye ontta osakeya eeye lifufu.” ");
INSERT INTO eko_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Attunkhulu a mahaakhimu a tiini na anamanozela a kano khusala eekesa nanna yonkhola wakathi otthuupule, maana yo aajuwiye yoori nlikaniso opule oniwaalupa yo. Ila khuhisala akholeya mwaasa woowoova atthu apale aari attaaphale. ");
INSERT INTO eko_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Aphano yo khusala anlupattha, khuwaaruma atthu aari ojinkhelelaaye wiiya anashariya onsaya sirini, yoori ansikanane paathuli ankhole anlawane wa mfwalume. ");
INSERT INTO eko_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Yo khusala amuuzela yoori: “Mwanliimu, fweeyo najuwa yoori onttakhula na onnozela epile ziiyiyeeyo za shariya, ninjuwa yoori khuninthawula ntthu, onnozela haakhi wa nanna Nnyizinku antakhaazo. ");
INSERT INTO eko_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nkanuuze, nkhama ti yooshapweya oripha lumpuru la Seezari ama wala?” ");
INSERT INTO eko_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yinsa khujuwa olavilavi aya khuwooza yoori: ");
INSERT INTO eko_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nkakitiiseleni nzurukhu apha. Ratarato eti vanzurukhu apha ti yaani?” Atthu khujipu yoori: “Ti ya Seezari!” ");
INSERT INTO eko_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Khuwooza yoori: “Mwimwinkhe Seezari etile yiiyiye ya Seezari na mwimwinkhe Nnyizinku etile yiiyiye ya Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yo khuhisala ansikanana hatha paathuli vakatthi wa atthu apale; khwiiya ootikinisiwa pi mattakhuzi apale aajipwiweeyo ti Yinsa, yo khunyamala. ");
INSERT INTO eko_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Masatukhi apale ahaari okhupalaaye osisimuwa wa anamfwa, khulawa akina khumwaattama Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Khusala alupa yoori: “Mwanliimu, Munsa aatikha yoori, nlume amana afwa, muukhaawe ahinvokoleleeni mwaana, ona yooraliwa ti ttwiiye ampatthele aana eeye a marehemu ttwiiye. ");
INSERT INTO eko_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Aarivo attwi sapa: otu nwulu aya khuloola khufwa, muukhaawe ahimpattheleeni mwaana. ");
INSERT INTO eko_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Khuraliwa ti ttwiiye, khufwa ahimpattheeni mwaana, ");
INSERT INTO eko_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","khuraliwa ti ttwiiye wattaatthu, khufwa ahimpattheleeni mwaana, ooshi apale sapa khufwa woohimpattheli mwaana. ");
INSERT INTO eko_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Omwiisho waya muukha otule khufwa. ");
INSERT INTO eko_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Siikhu yoosisimuwa onttela wiiya muukha waani maana oosaapa anraliye?” ");
INSERT INTO eko_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Aphano Yinsa khuwaajipu yoori: “Atthu a voolumwenku apha anloola na anraliwa. ");
INSERT INTO eko_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ila atthu apale anttelaaye osuhi olawa pinkuuni noosisimuwa muufwa, khanlawa oloola wala oraliwa; ");
INSERT INTO eko_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","maana khamfwa theenya, anttela wiiya nkhama malayikha na aana a Nnyizinku, mwaasa yoori asisimuleliwa muuhaayi. ");
INSERT INTO eko_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Hatha napiyu Munsa athoonyeza monkoni woosisimuwa wa anamfwa, wakathi moottho opule waari okholelaaye vamutthi nwishi, ye khunkhuwela Mbwana yoori, Nnyizinku wa Eburahiima wa Esiyaakha na wa Yaakhumpa. ");
INSERT INTO eko_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Eto enthoonyeza yoori Nnyizinku khahiyo wa anamfwa, Nnyizinku wa atthu awoona. Maana khwa Ye atthu ooshi anaaye ohaayi.” ");
INSERT INTO eko_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Anamanozela akina a kano apale aari attaaphale khumuuza yoori: “Wajipu saana Mwanliimu!” ");
INSERT INTO eko_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Khuhiivo hatha ntthu kiina wootakha omuuzela theenya. ");
INSERT INTO eko_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Elottelanaka Yinsa khuwoozela yoori: “Mwaasa aya niini atthu alupaka yoori Al-Masiihu mwaana wa Daawuuda? ");
INSERT INTO eko_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daawuuda alupa nkithaapu ya Zaapuuri yoori: ‘Mbwana Nnyizinku, amuuza Mbwanaaka yoori: “Wiikhale nkhono-nlume aka, ");
INSERT INTO eko_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mpakha miiyo kitthe moolu awo vatulu wa maatuwi awo.”’ ");
INSERT INTO eko_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nkhama Daawuuda onimwiittha Al-Masiihu yoori Mbwana, enrettikhana toovi wiiya mwanawe?” ");
INSERT INTO eko_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Atthu ooshi khusala ansiileza, Yinsa khuwooza anakhiyoni awe yoori: ");
INSERT INTO eko_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Phoole na anamanozela a kano, apale woowaatuvela owala ajapi zoolepisana, ochelisiwa vaparasa na woowaatuvela wiikhala puuro za wiilokozi nnyupa woosifwiwamo Nnyizinku na puuro za wiilokozi vanjampo, ");
INSERT INTO eko_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","aniweeyelaaye anamfweliwa pi amanna zaya vitthu zaya, ajinkhaka oretta lompa zoolepa. Apo aya anlawa apokherele hukhumu khuluyeene.” ");
INSERT INTO eko_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yinsa khuwoona mathaajiri alazaka zaakha zaya atthaaka n'yopo ya zaakha. ");
INSERT INTO eko_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Khumoona theenya nunu mmote wa masikhini woofweliwa ti mannawe, alazaka zaakha ttoosu piiri. ");
INSERT INTO eko_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yinsa khulupa yoori: “Kiniwuuzani khweele yoori nunu otu wa masikhini woofweliwa ti mannawe, enkha zayita atthu ooshi. ");
INSERT INTO eko_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Maana apale ooshi na othaajiri aya enkha tathela na khusalana, ila nunu otu na osikhini awe enkha wooshi aari ororomelaaye.” ");
INSERT INTO eko_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Anakhiyoni awe akina khusala attottopela Nyuupa ya Nnyizinku yaajekaniweeyo mawe ooshapweya na vitthu zaatthiiweemo zoolaziwa nkhama zaakha, Yinsa khuwooza yoori: ");
INSERT INTO eko_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Enlawa zafiye siikhu vitthu zaya epo mwinoonaazo zinttelaavo opwecheliwa, maana khalinlawa olikhiwa liwe vatulu wa liwe nzaaya.” ");
INSERT INTO eko_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yo khumuuzela yoori: “Mwanliimu, vitthu zaya epo zinteela orettikhana lini? Wala alama-ni enttelaaye onijuwisa yoori zasaleela orettikhana?” ");
INSERT INTO eko_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yinsa khuwaajipu yoori: “Phoole! Mwihihatiwe, maana anlawa apuwe atthu a waatta araka, ‘Al-Masiihu ti miyo!’ ama ‘Wakathi wafiya!’ Ila mwihiwaalotte apo aya. ");
INSERT INTO eko_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Amana mwisiilaka viittha ama nzuuzu mwihoove, maana epo zaya zina yoorettikhana khapula, ila wakathi aya opo khahiyo wiisha w'oolumwenku.” ");
INSERT INTO eko_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yinsa khulupa theenya yoori: “Khapila moote enlawa yoomanane na khapila kiina, na ofwalume woomanane ofwalume nzaaya. ");
INSERT INTO eko_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Phantte za waatta za miti zinlawa zapuwe visikinyaatthi khulu-khulu, jala, marati, vitthu zootikinisa na theenya alama khulu-khulu zoolankha pinkuuni. ");
INSERT INTO eko_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Khapula zihinarettikhane vitthu zaya epo, mwinlawa mwalupatthiwe, mwilawaniwe mmakhono wa afwalume na mahaakhimu, mwiphukiwe nnyupa woosifwiwamo Nnyizinku, mwifukeliwe mwaasa wookilotta miiyo. ");
INSERT INTO eko_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Enttela orettikhana yoori wiiye oshaahiti enu. ");
INSERT INTO eko_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mwiiye awiitthaaza rooho zenu, mwihishukulikhele etthu mwinttelaaye ojipu mmana ofiya wakathi aya opo. ");
INSERT INTO eko_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Maana miiyo kinlawa kawinkheni mattakhuzi na ojuwa nanna yoowaajipu maatuwi enu, ahinttelaaye owahi ozukulisa wala okheeti. ");
INSERT INTO eko_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mwinlawa mwafukisiwe wa afwalume pi apapazenu, attwiizenu, ajamaazenu na ashirikha enu, akinoko a mweeyo anlawa ooliiwe. ");
INSERT INTO eko_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Atthu awaatta anttela wiiya awiiphiiriwa ti mweyo mwaasa wa nzina laka. ");
INSERT INTO eko_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ila hatha nyuuli yenu moote khinlawa waashikha. ");
INSERT INTO eko_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mwiiye woovilela, toowo mwintta wuusurukha.” ");
INSERT INTO eko_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yinsa khulupa theenya yoori: “Amana moona sitati ya Yeruzaleemu ezukuleliwe pi anajanka, mwijuwe yoori wafiya wakathi woopwechiwa. ");
INSERT INTO eko_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Aphano apale anttelaaye wiiya nti wa Yudeya atthirele omwaako, apale anttelaaye wiiya nsitati atthiremo na apale anttelaaye wiiya ntthuttu ahirutele ositati. ");
INSERT INTO eko_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Maana siikhu zaya epo enttela wiiya siikhu za hukhumu khuluyeene yoori erettikhane zooshi epile zaatikhiweezo nkatthi wa nttakhuzi la Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Atakhaliwa muukha otule anttelaaye osikaniwa ari wa wiimittha ama eettaka waamwisa siikhu zaya epo, maana vatuniya anlawa apuwevo mashakha mawulweene na hukhumu vakatthi wa anaatamu ooshi. ");
INSERT INTO eko_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Awaatta anttela wuuliiwa na phanka, akinoko athuuliwe nkhama anapherezu eettettisiwaka miti zooshi z'oolumwenku. Yeruzaleemu enlawa yakurumuliwe pi amalapo mpakha yenzi ya amalapo wiisha.” ");
INSERT INTO eko_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yinsa khuvira awoozaka theenya yoori: “Zinlawa zeeyevo alama vanjuwa, vamweezi na vamatthottowa. Atthu a voolumwenku anteela wiiyana huzuni na woova nwulweene mwaasa woottitthima na otapanyeya wa pahari. ");
INSERT INTO eko_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Anlawa azirikhe atthu a waatta mwaasa wa woova vitthu zinttelaaye orettikhana voolumwenku, maana owahi wa pinkuuni onttela osakhinyeya. ");
INSERT INTO eko_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aphano phi anttelaavo wooneya Mwaana wa Pinaatamu ataaka enakatthi-nakatthi ya mawiku na owahi na nuuru khuluyeene. ");
INSERT INTO eko_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mmana zaazaka vitthu zaya epo, mwilankhe mwiinuwe mweekese otulu, maana wuusurukha wenu ori kharipu na-mweyo.” ");
INSERT INTO eko_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Elottelanaka Yinsa khulupa nlikaniso mmote araka: “Moone mfikeera na miitthi zooshi. ");
INSERT INTO eko_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Amana aazaka ophutuwela mathapa aya, mwinoona na mwinjuwa yoori wasaleela ofiya mwiita. ");
INSERT INTO eko_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wa nanna etthiipo, amana moona zirettikhanaka vitthu epo, mwijuwe yoori Ofwalume wa Nnyizinku wasaleela ofiya. ");
INSERT INTO eko_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Miiyo kiniwuuzani khweele yoori atthu apa aleelo khanlawa ofwa ooshi vitthu epi zihirettikhaneeni. ");
INSERT INTO eko_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Pinku na vathi zooshi zinteela ovira, ila mattakhuzi aka khanviraru.” ");
INSERT INTO eko_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yinsa khulupa yoori: “Mwiiye woojeekesela yoori rooho zenu zihipakhire vitthu zoohifwayi, ohapaliwa, ama tafwawuthi za muuhaayi mwenu, yoori siikhu yaya ethiito ehuusikaneleni. ");
INSERT INTO eko_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Maana siikhu yaya eto enttela owaatela atthu ooshi a voolumwenku nkhama nraakho. ");
INSERT INTO eko_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mwiiye woojeekesela na olompa wakhula wakathi, yoori zuuwerawereni vitthu zaya epo zinttelaaye orettikhana na yoori mwapatthe weemela omaasho wa Mwaana wa Pinaatamu amana ata.” ");
INSERT INTO eko_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yinsa wakhula siikhu aari onozela vaje wa Nyuupa ya Nnyizinku, mmana oripa aari weettaka vamwaako Oluveera khwiiya ottuukho mpakha ocha. ");
INSERT INTO eko_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Atthu ooshi supuyeene aari weettaka vaje wa Nyuupa ya Nnyizinku olawa osiila vitthu aari onozelaazo Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Osaleelaka ofiya wakathi woorettiwa njampo la phaawu yoohiina fwaramento, liniitthiwaaye Paashikowa, ");
INSERT INTO eko_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","attunkhulu a mahaakhimu a tiini na anamanozela a kano aari owaza shawuri zoomuula Yinsa sirini, khuhisala ewaheya mwaasa woowoova atthu. ");
INSERT INTO eko_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ila Epiliisi khumweetta Yuuda, aari wiittheliwaaye Shikariyooti, wa khuntti ya apale khumi na awiri. ");
INSERT INTO eko_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ye khulawa osiilanana attunkhulu a mahaakhimu a tiini na attunkhulu a anamweekesela a Nyuupa ya Nnyizinku, yoori eekese shawuri yonkholisa Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yo khuwaatuvela khumwaahiti Yuuda omwinkha nzurukhu wa feeta. ");
INSERT INTO eko_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ye khukhupali khusala eekesa kiphenyo yonkholisa Yinsa, woohiivo hatha ntthu. ");
INSERT INTO eko_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Khufiya siikhu yoorettiwa njampo la phaawu yoohiina fwaramento, siikhu yaya ethiito yaarina yootwahiwa pwittipwitthi yoojeliwa Paashikowa. ");
INSERT INTO eko_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yinsa khunruma Pheeturu na Yaahaya araka: “Mwilawe mwaattalele etthu-yoojiwa ya Paashikowa.” ");
INSERT INTO eko_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yo khumuuzela yoori: “Ontakha naattalele vayi?” ");
INSERT INTO eko_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ye khuwaajipu yoori: “N'oofiya ositati mwinlawa mwansikane mwinyi apwecheriye yuuku ya maati. Mwinlotte mpakha nyuupa anttaamo. ");
INSERT INTO eko_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mwimuuze mwennyewe nyuupa yaya eto yoori: ‘Mwanliimu eetta oniruma owuuzelani yoori puuro anttelaaye ojavo njampo la Paashikowa na anakhiyoni awe pi vayi?’ ");
INSERT INTO eko_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Othuuto ontta wuuthoonyezani nsana nwulweene wa vatulu oriina zaana zooshi, mwaattalele attaapho njampo nttho.” ");
INSERT INTO eko_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yo khulawa khusikana epile Yinsa aawooziyeezo, khwaattalela etthu-yoojiwa ya Paashikowa. ");
INSERT INTO eko_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","N'oofiya wakathi Yinsa na maaswihaapa awe khwiikhala vameeza. ");
INSERT INTO eko_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Khuwooza yoori: “Kaari ohithajiya venkivene onja Paashikowa vamote na-mweyo kihinalawe ohoowa. ");
INSERT INTO eko_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kiniwuuzani yoori akinteela oja theenya njampo ntthi mpakha linttelaavo omariseliwa muufwalume wa Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Athuuliyeevo jiikira khunshukhurwela Nnyizinku, khuwooza yoori: “Mwithuule mwaawanyena. ");
INSERT INTO eko_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kiniwuuzani yoori akinrutela onywa nshumo wa nrayi wa wuuva mpakha ontaavo Ofwalume wa Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Athuuliyeevo phaawu khunshukhurwela Nnyizinku, khumeya khuwenkha khuwooza yoori: “Opu mwiili aka onttelaaye ovahiwa khwa mweeyo, mwisala mwiretta etthiipi mwikifikhiraka miiyo.” ");
INSERT INTO eko_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Khwa nanna ethiito nawiisha oja khuthuula jiikira khulupa yoori: “Jiikira eti wahati mpheya onrettiwaaye ti taamu yaka, enttelaaye wiittikha khwa mweeyo. ");
INSERT INTO eko_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ila mwijuwe yoori, otule anttelaaye okikholisa ori vameeza attaapha vamote na-miyo. ");
INSERT INTO eko_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mwaana wa Pinaatamu onttela ofwa khwa nanna etthiipo Nnyizinku asharutheliyeezo. Ila atakhaliwa otule anttelaaye onkholisa.” ");
INSERT INTO eko_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yo khusala oozelana atthaaporu yoori anjuwe nlupa aari weettelaaye oretta etthu yaya eto. ");
INSERT INTO eko_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Aphano maaswihaapa khusala anyakulisana atakhaka onjuwa paani eezeliyeeyo ottunkhulu vakatthi vaya. ");
INSERT INTO eko_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yinsa khuwooza yoori: “Afwalume a vathi apha aniiyana oshintta vakatthi wa atthu aya, na apale aneettettisaaye ofwalume oniwaatuvela olupeziwa onamaretta saana. ");
INSERT INTO eko_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ila mweeyo mwihiiye toowo, nttunkhulu vakatthi venu eeye ti nttiitthi aya, otule anlokozelaaye eeye ti namarumeyela aya. ");
INSERT INTO eko_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nttunkhulu ti paani, ti otule aniikhalaaye vameeza ama otule anrumeyaaye? Khaniiya otule aniikhalaaye vameeza? Ila vakatthi venu mweeyo, miiyo kiri nkhama otule anrumeyaaye. ");
INSERT INTO eko_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Mweeyo ti ye mwiriiye vamote na-miyo mphule kinzayiniwaamo. ");
INSERT INTO eko_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nkhama etthiipo Paapa akinkhiyeeyo ofwalume, na miiyo kiniwinkhani mweeyo, ");
INSERT INTO eko_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","yoori mwije na mwinywe vameeza vaka muufwalume mwaka, na mwiikhale vakhukulu y'oofwalume yoori mwiphuke mahimo khumi na mawiri a Ezirayeele. ");
INSERT INTO eko_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simawu, Simawu, Epiliisi avekela yoori awootooteni nkhama empepetthiwaazo tiriku. ");
INSERT INTO eko_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ila miiyo koolompela yoori amini yawo ehiwaashikhe. Amana orutela wiiya vamote na-miyo, owaalipisele azaawo.” ");
INSERT INTO eko_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simawu khujipu yoori: “Mbwanaaka, miiyo kakhupali wuulotta hatha nkhama nkalapooso, hatha nkhama ofwa.” ");
INSERT INTO eko_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ila Yinsa khunjipu araka: “Miiyo kiniwuuza weeyo Pheeturu yoori leelo eti likukhuwi lihineekhe, onkikhana swaafu ttatthu oraka khunkijuwa.” ");
INSERT INTO eko_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Aphano Yinsa khuwooza araka: “Wakathi opule koorumiyeenini mwihina hatha mfukho wala napampa, ama shapatthu, niini yoosaleeliyeenini?” Yo khujipu yoori: “Hatha etthu khayaanisaleeliye.” ");
INSERT INTO eko_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ye khuwooza yoori: “Ila nasaapi eti otule ariina mfukho athuule na napampa awe anthuule. Otule ahina phanka oozanyise ajapi yawe oozanye. ");
INSERT INTO eko_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nkhama etthiipo Nttakhuzi la Nnyizinku linlupaazo yoori: ‘Ye onaalakiwa nkhama nanretta zootakhala.’ Miiyo kiniwuuzani khweele yoori sharuthi vitthu epi zirettikhane khwa miiyo, maana etile yaatikhiweeyo monkoni wa miiyo ena yoorettikhana.” ");
INSERT INTO eko_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Maaswihaapa apale khulupa yoori: “Fweeyo apha Mbwana ninaaye phanka piiri.” Ye khujipu araka: “Weesha mwaasa aya opo!” ");
INSERT INTO eko_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Khulankha khusala alawa vamwaako wa Oluveera nkhama etthiipo aazowereliyeezo, anakhiyoni awe khunlotta. ");
INSERT INTO eko_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","N'oofiya khuwooza yoori: “Mwilompe yoori mwihikwele muuzayiniwa.” ");
INSERT INTO eko_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ye khuwaasusa vattitthiiru khukokhora khusala alompa araka: ");
INSERT INTO eko_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Paapa amana otakha, okilaze jiikira eti yoohoowa; ila ehirettikhane otakha waka miiyo, arettikhane matakhelo awo.” ");
INSERT INTO eko_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aphano khumpuwelela nlayikha la pinkuuni khusala linlipisela. ");
INSERT INTO eko_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ari mmashakha, khusala alompa woojilipisavo, mattottonka oovujuwela wawe khuretteya wiiya taamu khusala akwela vathi. ");
INSERT INTO eko_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","N'oolaavo aphale aari olompaavo, khweetta aphale aariivo anakhiyoni awe, khuwaasikana eettaka olala mwaasa woohuzunikha. ");
INSERT INTO eko_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Khuwoozela araka: “Mwinlala-ni? Mwilankhe mwilompe yoori mwihikwele muuzayiniwa.” ");
INSERT INTO eko_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Eettaka ottakhula etthiipile, khutavo atthu a waatta alokoziwe ti mmote wa anakhiyoni apale khumi na awiri aari wiitthiwaaye Yuuda. Ye khuta aphale aariivo Yinsa yoori amwinkhe peezhu. ");
INSERT INTO eko_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Attaaphale Yinsa khuri: “Yuuda, Mwaana wa Pinaatamu oninkholisa na peezhu?” ");
INSERT INTO eko_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Anakhiyoni awe nawoona vitthu epile khulupa yoori: “Mbwana, niwoomanane na phanka?” ");
INSERT INTO eko_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Aphano nakhiyoni mmote khunshija nshiilo la nkhono-nlume mwiitthwaana wa haakhimu nwulu wa tiini. ");
INSERT INTO eko_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ila Yinsa khuri: “Onlikhe ohinrutele!” Ye khukhola nshiilo la ntthu otule khunvonisa. ");
INSERT INTO eko_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Aphano Yinsa khuwoozela attunkhulu a mahaakhimu a tiini na attunkhulu a anamweekesela a Nyuupa ya Nnyizinku na anamalokozela a tiini apale aateeliye onkhola araka: “Mwakiteela na phanka na puutta nkhama kiiyiye namalokozela wa anazompere? ");
INSERT INTO eko_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Wakhula siikhu kaari wiiya vamote na-mweyo vaje wa Nyuupa ya Nnyizinku khuhisala mwikikhola, aphano, opu wakathi enu na otule ariina ofwalume wa n'yiiza.” ");
INSERT INTO eko_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Aphano Yinsa n'ookholiwa khulawaniwa mpakha vaje wa haakhimu nwulu wa tiini. Pheeturu khusala anlottelela Yinsa woohimwaattami. ");
INSERT INTO eko_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yo khukhoza moottho vaje khusala oottha, na-ye Pheeturu khuta attaapho khwiikhala. ");
INSERT INTO eko_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Njaazi mmote aariivo n'oomoona eekhaliye nshini wa moottho khumweekesa saaneene khuri: “Otu aari vamote na Yinsa.” ");
INSERT INTO eko_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pheeturu khukhana araka: “Weyo mwanankha! Miiyo akininjuwa ntthu aya oto.” ");
INSERT INTO eko_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","N'oovira wakathi vattitthiiru, Pheeturu khooniwa ti ntthu nkina khumuuza yoori: “Weeyo o wa khuntti ethiitile.” Ila Pheeturu khukhana araka: “Mwinyi, khahiyo miiyo!” ");
INSERT INTO eko_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Oviriyeevo wakathi mmote, ntthu nkina theenya khulupachacha yoori: “Khweele-khweele otu aari vamote na-ye, maana otu aya na-ye nkalileya.” ");
INSERT INTO eko_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pheeturu khujipu araka: “Mwinyi! Miiyo akinjuwa etthu mwinlupaaye.” Eettaka ottakhula etthiipile, likukhuwi khwiikha. ");
INSERT INTO eko_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mbwana khuzukuluwa khumweekesa Pheeturu, ye khufikhiri mattakhuzi apale ooziweeyo ti Mbwana yoori: “Leelo ethiiti likukhuwi lihineekhe, onteela okikhana swaafu ttatthu.” ");
INSERT INTO eko_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pheeturu khulaavo aphale vaya khusala alila ari wookafilikha. ");
INSERT INTO eko_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Atthu apale aari omweekeselaaye Yinsa khusala anveyisa na ompiya, ");
INSERT INTO eko_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","khumfinikha omaasho wawe khusala amuuzela yoori: “Weeyo khahi o napiyu? Onlupe otu oopiyiyeeyo!” ");
INSERT INTO eko_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Khusala anlupeza mattakhuzi a waatta a mattukhano. ");
INSERT INTO eko_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","N'oocha khukusanyeya attunkhulu a mayaahuuti, attunkhulu a mahaakhimu a tiini na anamanozela a kano, khuthuuliwa Yinsa khulawaniwa nhali anthukumanaamo attunkhulu oophuka milattu. ");
INSERT INTO eko_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Khusala amuuzela yoori: “Nkahaya, nkanuuze nkhama weeyo o Al-Masiihu.” Ye khujipu araka: “Amana kiwuuzani khamwinkaamini, ");
INSERT INTO eko_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","na amana kiwuuzelani khamwinkijipu. ");
INSERT INTO eko_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ila waaza nasaapi ethiiti Mwaana wa Pinaatamu onttela wiikhala nkhono-nlume wa Nnyizinku Woowahi.” ");
INSERT INTO eko_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Aphano ooshi khumuuzela yoori: “Apho niri weeyo o Mwaana wa Nnyizinku?” Yinsa khujipu araka: “Mweeyo mwalupa yoori ti miiyo.” ");
INSERT INTO eko_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yo khulupa yoori: “Nininhithajiya shaahiti theenya? Mwennyewe alupa na nlomo awe.” ");
INSERT INTO eko_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Khulankha khuntti yooshi khunthuula Yinsa khusala anlawana wa Pilaatu. ");
INSERT INTO eko_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","N'oofiya khusala anlokoveza yoori: “Nansikana otu awaalikhisaka atthu etthu oripha lumpuru la Seezari, khusala ajilupeza yoori ti Al-Masiihu na mfwalume.” ");
INSERT INTO eko_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Aphano Pilaatu khumuuzela yoori: “Ti weeyo mfwalume wa mayaahuuti?” Yinsa khujipu yoori: “Weeyo walupa.” ");
INSERT INTO eko_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilaatu khuwooza attunkhulu a mahaakhimu a tiini apale na khuntti ya atthu etile yaariivo yoori: “Miiyo akinimoonana hatha paathuli otu.” ");
INSERT INTO eko_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Atthu apale khusala avira akhanyarelaka olupa yoori: “Otu ontta owaatapanya atthu a Yudeya yooshi eti, aaza Kalileya mpakha ofiya okhuno.” ");
INSERT INTO eko_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Paata yoosiila mattakhuzi apale, Pilaatu khuuzela yoori: “Otu aya nkalileya?” ");
INSERT INTO eko_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pilaatu ajuwiyeevo yoori Yinsa aari wa nti wa mfwalume Herooti, khuruma olawaniwa ottuukho. Wakathi aya opo Herooti na-ye aarettiye ari Yeruzaleemu. ");
INSERT INTO eko_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herooti n'oomoona Yinsa, khwiiya woofurahi venkivene maana aaziye raku otakha omoona mwaasa woosiila vitthu aari orettaazo, khusala aweeja woona minjuza arettaka. ");
INSERT INTO eko_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Aphano khusala amuuzela vitthu za waatta, ila ye khuhisala anjipu hatha etthu. ");
INSERT INTO eko_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Attunkhulu a mahaakhimu a tiini na anamanozela a kano khusala anlokoveza mattakhuzi mawulu-mawulu. ");
INSERT INTO eko_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herooti na anajanka awe khwaaza onveyisa Yinsa na ontarawu, khunwalisa ajapi y'oofwalume khuruma yoori arutiseliwe wa Pilaatu. ");
INSERT INTO eko_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herooti na Pilaatu khaari osiilanaka, ila siikhu ethiito khupuwa oshirikha. ");
INSERT INTO eko_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Aphano Pilaatu khuwaakhuwela attunkhulu a mahaakhimu a tiini, anamaphuka milattu na atthu, ");
INSERT INTO eko_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","khuwooza yoori: “Mwakitiisela otu mwinlupezaka yoori ontta owaatapanya atthu, ila miiyo kamuuzela vakatthi venu mweeyo, akimoonaneeni hatha paathuli khwa vitthu epo mwininlupezaazo. ");
INSERT INTO eko_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herooti na-ye khamoonaneeni hatha paathuli, ti eto arumiyeeyo orutiseliwa okhuno. Eto enthoonyeza yoori kharetteeni etthu yoosuhi wuuliiwa. ");
INSERT INTO eko_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Miiyo kintta oruma opiiwa nawiisha kinleve.” ");
INSERT INTO eko_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","N'oofiya siikhu ya njampo la Paashikowa, Pilaatu aarina sharuthi yoowaafukulela atthu napherezu mmote. ");
INSERT INTO eko_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Attaaphale atthu ooshi khusala anyakula araka: “Mwimuule oto! Mwinifukulele Baraba!” ");
INSERT INTO eko_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraba aafukeliwe mwaasa woolaza onazompere nsitati na khumuula ntthu. ");
INSERT INTO eko_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Aphano Pilaatu khurutela owooza atthu atakhaka onleva Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ila atthu khusala anyakula venkivene araka: “Akhomeliwe, akhomeliwe vansalapa!” ");
INSERT INTO eko_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilaatu khuwoozela swaafu yattaatthu: “Niini arettiyeeyo yootakhala? Miiyo akinimoonana hatha paathuli yoosuhi wuuliiwa. Kinruma yoori mwinhukhumu nawiisha kinleve.” ");
INSERT INTO eko_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ila yo khusala avira anyakulaka avekaka yoori Yinsa alawe akhomeliwe, akhanyarelaka onyakula. ");
INSERT INTO eko_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Aphano Pilaatu khukhupalela oretta etile aari otakhaaye atthu apale. ");
INSERT INTO eko_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ye khumfukulela Baraba otule aafukeliweeyo mwaasa woolaza onazompere na wuula, khuwenkha Yinsa otule anvekiyeeyo yoori alawe anrettele etile aari ontakhelaaye. ");
INSERT INTO eko_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yinsa khuthuuliwa khusala alawaniwa, eettaka olawaniwa etthiipile, khusikaniwa mwinyi mmote wa Sireeni aari wiitthiwaaye Simawu, aari olankhaaye omashapa. Khukholiwa khuthuulisiwa nsalapa opule yoori anlottisele Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Aari olottiwa pi atthu a waatta na aarivo aakha aari onlilelaaye ankhupanyeraka. ");
INSERT INTO eko_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yinsa khuzukuluwa khuweekesa aakha apale aari onlilelaaye khuwooza yoori: “Aakha a Yeruzaleemu, mwihikililele miiyo, ila mwijililele mweeyo na aaneenu. ");
INSERT INTO eko_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Maana zinteela ofiya siikhu mwinttelaaye olupa yoori: ‘Ashapweyiwa aakha apale oohiina mavokozi, ahinavokole na ahinaamwise.’ ");
INSERT INTO eko_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Siikhu ethiito mwinlawa mwalupe yoori: ‘Nyaako zinikwele kulu zinifinikhe!’ ");
INSERT INTO eko_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Muutthi nwishi onretteliwa toono khi wa wuuma onttela wiiya toovi?” ");
INSERT INTO eko_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Khuthuuliwa theenya anazompere awiri yoori alawe ooliiwe vamote na Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","N'oofiya puuro eniitthiwaaye Kalavaariyu, Yinsa khukhomeliwa na anazompere apale awiri, mmote nkhono-nlume nkina nkhono-nkha. ");
INSERT INTO eko_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Aphano Yinsa khulupa yoori: “Paapa, owaaswaamihi atthu apa maana khanjuwa etthu anrettaaye.” Elottelanaka yo khwaawanyelana kuwo epile za Yinsa nkatthi wa nasipu. ");
INSERT INTO eko_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Atthu aari attaaphale aari woona zooshi. Mahaakhimu a Yudeya khusala antarawu Yinsa araka: “Ye awoosuru atthu akina, mwinlikhe ajuusuru mwennyewe nkhama khweele ti Al-Masiihu nanthawuliwa ti Nnyizinku.” ");
INSERT INTO eko_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Anajanka na-yo khusala antarawu Yinsa antiiselaka viinyu yoonyuunya, ");
INSERT INTO eko_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","n'oomuuza yoori: “Nkhama khweele weeyo o mfwalume wa mayaahuuti, ojuusuru omweenyewe.” ");
INSERT INTO eko_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Vansalapa attaaphale aakhomeliweevo, khutthiiwavo lipawu laatikhiweeyo yoori: “OTU MFWALUME WA MAYAAHUUTI.” ");
INSERT INTO eko_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Anazompere apale aakhomeliweeyo vamote na Yinsa, mmote aya khusala anveyisa amuuzaka yoori: “Nkhama weeyo o Al-Masiihu, ojuusuru na onuusurwaka na-fweyo.” ");
INSERT INTO eko_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Otule nkina khujipu ammaruwelaka nzaawe araka: “Weeyo khunimoova Nnyizinku, ye na-fweyo hukhumu yetthu moote? ");
INSERT INTO eko_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Fweeyo khweele ninsuhi ohukhumweliwa epile nirettiyeezo, ila ye kharetteeni hatha etthu yootakhala.” ");
INSERT INTO eko_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aphano khulupa yoori: “Yinsa, okuupuwele amana ofiya muufwalume mwawo.” ");
INSERT INTO eko_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yinsa khujipu yoori: “Miiyo kiniwuuza khweele yoori leelo eti weeyo onttela wiiya vamote na-miyo pephooni.” ");
INSERT INTO eko_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Esaleelaka ofiya elukuluku njuwa khuzima, khupuwa yiiza olumwenku wooshi mpakha makaaripi. ");
INSERT INTO eko_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Phazira khuluyeene yaari Nnyupa wa Nnyizinku khuvaruwa vakatthi. ");
INSERT INTO eko_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Aphano Yinsa khukhuwa na kuvu araka: “Paapa, rooho yaka kininkhelela mmakhono mwawo.” N'oolupa nttakhuzi ntthile, khuttiya phuumu. ");
INSERT INTO eko_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nrooma mmote aari nttunkhulu wa anajanka, nawoona vitthu epile zaarettikhaniyeezo, khunsifu Nnyizinku araka: “Khweele-khweele otu aari ntthu aari weettettisaaye shariya.” ");
INSERT INTO eko_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ooshi apale aari attaaphale, nawoona vitthu epile zaarettikhaniyeezo, khuruti apiyaka vifuwa zaya athoonyezaka huzuni. ");
INSERT INTO eko_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ashirikha awe Yinsa ooshi na aakha apale anlottiyeeyo a Kalileya, aarettiye ari peetiwene eettaka woona vitthu epile. ");
INSERT INTO eko_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Aarivo mwinyi mmote aari wiitthiwaaye Yuusufu wa sitati ya Arumateeya nti wa Yudeya. Ye aari wooshapweya rooho na wa shariya, na aari weekeselaaye ota wa Ofwalume wa Nnyizinku. Aari wa khuntti ya mashawuriiya, ila ye khaakhupaleliye epile mashawuriiya aawaziyeezo na aarettiyeezo. ");
INSERT INTO eko_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ye khulawa wa Pilaatu oveka mwiili wa Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Khulazavo vansalapa aphale, khuputaputela vajoora khulawa khuzikha nliphotto la mwaako laari ahinazikhiwemo hatha ntthu. ");
INSERT INTO eko_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Epo zaarettikhaniye juumwa ochelaniwa jumwaa-monsi. ");
INSERT INTO eko_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Aphano, aakha apale aataniyeeyo Yinsa Kalileya, khunlottelela Yuusufu omwaako okhule eetteliyeewo ozikha mwiili wa Yinsa, olawa woona khapuri na mwiili nanna waazikhiweezo. ");
INSERT INTO eko_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nawiisha, khurutela owaya olawa waattalela mafuttha oonukhela yoori alawe avaaze mwiili wa Yinsa. Jumwaa-monsi yo khuvumula nkhama etthiipo enrumaazo kano. ");
INSERT INTO eko_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Siikhu yamwanzo ya sumana, jumwaa-phiili supuyeene, aakha apale khusala alawa okhapuri okhule aazikhiweewo Yinsa athuuliye mafuttha oonukhela apale aattaliyeeyo. ");
INSERT INTO eko_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Yo n'oofiya khoona liwe ntthile laafukaniweeyo nlako wa khapuri liri loolaziwavo. ");
INSERT INTO eko_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","N'ooviramo, mwiili wa Mbwana Yinsa khusikana ohimo. ");
INSERT INTO eko_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Khwiiya oozinkuwa venkivene, attaaphale khuwaapuwelela atthu awiri awaliye kuwo za waara. ");
INSERT INTO eko_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Aakha apale khuwaapattha woova khukokhora khufiyisa ajihi zaya vathi, atthu apale khusala awoozela yoori: “Mwinimweekesela-ni ntthu wa woona vakatthi wa alupa oofwa? ");
INSERT INTO eko_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ye khaamo mphu; asisimuwa, muupuwele mattakhuzi apale aawuuziyeenini ari nti wa Kalileya! ");
INSERT INTO eko_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Aalupiye yoori: ‘Mwaana wa Pinaatamu ona ya winkheleliwa mmakhono wa anatwampi, akhomeliwe vansalapa, siikhu yattaatthu asisimuwe.’” ");
INSERT INTO eko_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aphano aakha apale khuupuwela mattakhuzi apale aalupiyeeyo Yinsa. ");
INSERT INTO eko_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","N'ooruti okhapuri okhule, khuwooza vitthu epile zooshi maaswihaapa apale khumi na mmote na atthu apale akinoko aariivo. ");
INSERT INTO eko_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Aakha aya aari Mariyamu Mataleena, Yowaana na Mariyamu mamaawe Yaakhumpa na aakha akinoko aalawaniyeeyo ottuukhu. Yo khuwooza maaswihaapa vitthu epile. ");
INSERT INTO eko_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ila maaswihaapa khuhisala akhupali mattakhuzi aakha apale, oonaka yoori aari oololo. ");
INSERT INTO eko_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Aphano Pheeturu khulankha khusala atthira alawaka okhapuri, n'oofiya khuthurumelamo khusikanamo jooraru, khusala aruti ari wootikinisiwa khwa epile zaarettikhaniyeezo. ");
INSERT INTO eko_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Siikhu ethiitile, anakhiyoni awiri a Yinsa khulankha khusala alawa nti waari wiitthiwaaye Emawu woolepelana Yeruzaleemu kiyasi ya phiima alufu khumi na moote. ");
INSERT INTO eko_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yo aari olawa attakhulaka monkoni wa vitthu epile zaarettikhaniyeezo. ");
INSERT INTO eko_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Eettaka olawa etthiipile apiyaka mwaasa na akheetisanaka, Yinsa mwennyeweene khuwaatthoowela khusala alawa vamote na-yo. ");
INSERT INTO eko_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ila yo khumpuwa nkhama oowaariipa omaasho, khuhisala anjuwa yoori Yinsa aya aari othuutule. ");
INSERT INTO eko_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ye khuwoozela yoori: “Niini mwinnyakulisanelaaye ntarikhi mphu mweettaka weettetta?” Yo khweemela omaasho waya athoonyezaka ohuzunikha. ");
INSERT INTO eko_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mmote wa yo aari wiitthiwaaye Keleyoopa, khumuuzela Yinsa yoori: “Niri weeyo o nletto mmote paasi wa Yeruzaleemu ohinjuwaaye vitthu zirettikhaniyeezo siikhu epi?” ");
INSERT INTO eko_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yinsa khuwoozela yoori: “Niini erettikhaniyeeyo?” Yo khunjipu yoori: “Epile zinrettikhaneliyeeyo Yinsa wa Nazareeti. Ye aari napiyu woowahi khwa zooretta zawe na mattakhuzi awe vakatthi wa Nnyizinku mpakha wa atthu ooshi. ");
INSERT INTO eko_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ila attunkhulu a mahaakhimu a tiini na afwalume a mmuti mwetthu, khuruma ohukhumweliwa ofwa khulawa khukhomeliwa vansalapa. ");
INSERT INTO eko_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Fweeyo naari ororomela yoori ti ye aari weettelaaye owoosuru atthu a Ezirayeele, thanku zirettikhane vitthu zaya epo leelo siikhu yattaatthu. ");
INSERT INTO eko_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Neeya wooshanka mwaasa yoori aakha akina a nkhuntti mwetthu, aalawiye okhapuri leelo lifwajiri ");
INSERT INTO eko_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","khuhisikani mwiili awe, khuta khunuuza yoori ooniye malayikha, atthaapo pi alupiyeeyo yoori Ye asisimuwa ori haayi. ");
INSERT INTO eko_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Khulawa ashirikha etthu akina okhapuri, khusikana etthiipile aalupiyeezo aakha apale, ila yo khuhimooni.” ");
INSERT INTO eko_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Aphano Yinsa khuwooza yoori: “Atthu oorupaza weeleyiwa na oolipa waamini zooshi epi alupiyeezo manapiyu! ");
INSERT INTO eko_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Al-Masiihu khaarina yoohoowa etthiipo, yoori eette nnuuru mwawe?” ");
INSERT INTO eko_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Khusala aweeleza mattakhuzi ooshi aatikhiweeyo nkithaapu aari onlupaaye Ye, waaza kithaapu ya napiyu Munsa mpakha za manapiyu akinoko. ");
INSERT INTO eko_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Asaleelaka ofiya nti opule aari weettaaye, Yinsa khusala ompuwa nkhama aari otakhaaye owaavikana. ");
INSERT INTO eko_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ila yo khunkhanyarela araka: “Ohivikane wiiye attaapha na-fweyo, njuwa linttela otupweela waripa.” Yinsa khuvira nnyupa khwiiya vamote na-yo. ");
INSERT INTO eko_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Wakathi eekhaliyeevo vameeza vamote na atthaapale awiri, khuthuula phaawu khuparikhiya, khumeya khuwenkha. ");
INSERT INTO eko_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Attaaphale, oowiiri maasho aya khufunuwa khunjuwa yoori ti Yinsa, na-Ye khunaanela. ");
INSERT INTO eko_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Aphano khusala oozelana araka: “Wakathi opule naari ottakhulanaavo ntarikhi aneelezaka mattakhuzi a nkithaapu, rooho zetthu khazeetta onikaphula?” ");
INSERT INTO eko_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Yo khulankha nasaapiru khusala arutela Yeruzaleemu, khuwaasikana maaswihaapa apale khumi na mmote na anakhiyoni akina a Yinsa akusanyeyiye vahali vamote, ");
INSERT INTO eko_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","alupaka yoori: “Khweele Mbwana asisimuwa, ampuwelela Simawu.” ");
INSERT INTO eko_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Na-yo apale awiri khusala alupa epile ooniyeezo ntarikhi na nanna anjuwiyeezo Mbwana wakathi ameyiyeevo phaawu. ");
INSERT INTO eko_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Anakhiyoni apale nalelo eettaka ottakhula etthiipile, Yinsa khuta vakatthi vaya, khulupa yoori: “Heeri yiiye vamote na-mweyo.” ");
INSERT INTO eko_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yo khwiiya oosuthuwa na woova amoonaka nkhama nshitapehe. ");
INSERT INTO eko_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yinsa khuwoozela yoori: “Mwasuthuwa-ni? Wala mishikili ziriiye nroho mwenu pi za niini? ");
INSERT INTO eko_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Moone makhono aka na moolu aka yoori ti miyo! Mwikikhole moone, maana nshitapehe khuniiyana nyama wala makhonkolo nkhama etthiipo mweeyo mwinikoonaazo.” ");
INSERT INTO eko_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Attakhulaka etthiipile, khuwaathoonyeza makhono awe na moolu awe. ");
INSERT INTO eko_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Mwaasa wa furaha khuluyeene na oshanka, yo khuhisala aamini nalelo, aphano Yinsa khuwoozela yoori: “Mwinaaye etthu-yoojiwa mwikinkhe kije?” ");
INSERT INTO eko_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Yo khumwinkha phantte ya swi yawoochiwa. ");
INSERT INTO eko_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Khuthuula khusala arafuna attaapho yo amoonaka. ");
INSERT INTO eko_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nawiisha khulupa yoori: “Pi etthiipi kaawuuziyeenini wakathi opule kaari vamote na-mweyo, yoori zaarina yoorettikhana zooshi epile zaatikhiweeyo khwa miiyo nkithaapu ya kano ya napiyu Munsa na kithaapu za manapiyu akina na nzaapuuri.” ");
INSERT INTO eko_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Aphano Yinsa khuwaapatthisa fwahamu yoori ziweeleye zawaatikhiwa za nkithaapu. ");
INSERT INTO eko_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Khuwooza araka: “Yaatikhiwa yoori Al-Masiihu aarina yoohoowa na osisimuwa siikhu yattaatthu vakatthi wa anamfwa; ");
INSERT INTO eko_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","na khwa nzina lawe onlawa walaleyiwe othupwiya yoori ziswaamihiwe twampi, waaza Yeruzaleemu mpakha khapila zooshi za voolumwenku. ");
INSERT INTO eko_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mweeyo mwa amashaahiti wa vitthu zaya epi. ");
INSERT INTO eko_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Miiyo kinlawa kooperekhezeni etile Paapa aahitiyeeyo, mweeye Yeruzaleemu ottuukho mpakha mwiitaazaniwe owahi wa pinkuuni.” ");
INSERT INTO eko_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Aphano Yinsa khuwaathuula anakhiyoni awe khulawana Betaaniya, n'oofiya khulansa makhono awe khuwaaparikhiya. ");
INSERT INTO eko_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Awaaparikhiyaka etthiipile, khuwaasusa khusala aweziwa alawaka pinkuuni. ");
INSERT INTO eko_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yo khumwaaputu, khurutela Yeruzaleemu na furaha khuluyeene. ");
INSERT INTO eko_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Wakhula siikhu aari othukumana vaje wa Nyuupa ya Nnyizinku ansifwaka Nnyizinku. ");
INSERT INTO eko_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Omwanzo laari Nttakhuzi. Nttakhuzi laari vamote na Nluku na Nttakhuzi laari Nluku. ");
INSERT INTO eko_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ye laari vamote na Nluku omwanzo. ");
INSERT INTO eko_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Vitthu zooshi zarettiwa khwa ye; eriwaka khaari ye khayiivo moote yaari weettelaaye orettiwa. ");
INSERT INTO eko_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ohaayi waari nkatthi mwawe, ohaayi opo yaari nuuru ya anaatamu. ");
INSERT INTO eko_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nuuru enaara n'yiiza, na yiiza khuhikhitiri oshintta. ");
INSERT INTO eko_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Aarivo nlume mmote aaperekhiweeyo ti Nluku aari wiitthiwaaye Yaahaya. ");
INSERT INTO eko_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ye ata nkhama shaahiti yoori alawele oshaahiti monkoni wa nuuru, yoori atthu ooshi apatthe osiila hapari na akhupali khwa ye. ");
INSERT INTO eko_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ye khaari nuuru, ila ata nkhama shaahiti wa nuuru. ");
INSERT INTO eko_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nuuru yeekhweele, eniwaamwasikhelaaye anaatamu ooshi, yata voolumwenku. ");
INSERT INTO eko_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nttakhuzi laari voolumwenku na olumwenku wompiwa ti ye, ila olumwenku khuhinjuwi. ");
INSERT INTO eko_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Awaateliye apale eeyiyeeyo awe, yo khuhimpwekhereli. ");
INSERT INTO eko_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ila apale ampwekhereliyeeyo na akhupaliyeeyo nzina lawe, awenkha ruhusa yooretteya aana a Nluku. ");
INSERT INTO eko_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Atthaapo ahivokoliweeni khwa ephattu, wala khwa matakhelo a onaatamu wala ohiiyi makhaamu a nlume, ila avokoliwa khwa matakhelo a Nluku. ");
INSERT INTO eko_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nttakhuzi khujiretta ntthu na khwiikhala na-fweyo. Noona siifwa yawe, siifwa nkhama mwaana mmote paasi wa Paapa wawiitaala rehema na khweele. ");
INSERT INTO eko_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yaahaya alaza oshaahiti awe araka: “Otu ti otule kaari onlupaaye, aari otaaye paata ya miiyo na nwulu zayita miiyo, maana ye aarivo miiyo kihineeyevo.” ");
INSERT INTO eko_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Maana fooshi fweeyo napokherela phantte ya zooshi ariina na rehema khwa rehema. ");
INSERT INTO eko_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Maana kano zatiisiwa khwa vakatthi wa Munsa; rehema na haakhi yata khwa Yinsa Al-Masiihu. ");
INSERT INTO eko_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Khina anamoone Nluku, ila Nluku mmote paasi, othuuto ariiye mpavu wa Paapa, ti anithoonyeziyeeyo. ");
INSERT INTO eko_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Opu oshaahiti wa Yaahaya, wakathi mayaahuuti a Yeruzaleemu awaaperekhiyeevo anamalokozela a tiini na aleevi yoori amuuzele yoori: “Opaani weeyo aya.” ");
INSERT INTO eko_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ye khutukhuru na khuhikatthali, khulupa woosileyavo yoori: “Akiiyo Al-Masiihu!” ");
INSERT INTO eko_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Khumuuzela yoori: “Aphano, weeyo o paani? Ti weeyo Aliyaasi?” Khuri: “Akiiyo!” “Ti weeyo Napiyu aari weettelaaye ota?” Khujipu yoori: “Wala!” ");
INSERT INTO eko_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Khumuuzela yoori: “Khi o paani? Onijipu yoori nawooze apale anirumiyeeyo. Nanna eti onjilupezaaye omweenyewe?” ");
INSERT INTO eko_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yaahaya khujipu na mattakhuzi a napiyu Ezaaya araka: “Miiyo ki huula enkhuwaaye n'yaara eraka: ‘Mookolele tarikhi ya Mbwana.” ");
INSERT INTO eko_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Apale aarumiweeyo aari akhuntti ya mafwarizeewu, ");
INSERT INTO eko_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","khumuuzela yoori: “Khi oniwooselani atthu ohi Al-Masiihu wala Aliyaasi ama Napiyu? ");
INSERT INTO eko_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yaahaya khuwaajipu yoori: “Miiyo kinoosa na maati, ila vakatthi venu mweeyo owaapho ntthu mwihininjuwaaye, ");
INSERT INTO eko_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","antaaye paata ya miiyo na wala akinsuhi ofukula mikhoyi za jampali zawe.” ");
INSERT INTO eko_vpl VALUES ("JN1_28","073_1_28","JHN"