﻿USE sofia;
DROP TABLE IF EXISTS sofia.ekkpkp_vpl;
CREATE TABLE ekkpkp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ekkpkp_vpl WRITE;
INSERT INTO ekkpkp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","See raamat on Jeesuse, Messia, Taaveti poja ja Aabrahami poja elu üleskirjutus, alustades sugupuust: ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aabraham oli Iisaki isa; ja Iisak oli Jaakobi isa; ja Jaakob Juuda ja tema vendade isa; ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ja Juuda Peretsi ja Serahi isa (nende ema oli Taamar); ja Perets oli Hesroni isa; ja Hesron Arami isa; ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ja Aram oli Amminadabi isa; ja Amminadab Nahsoni isa; ja Nahson Salma isa; ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ja Salma oli Boase isa (tema ema oli Raahab); ja Boas oli Oobedi isa (tema ema oli Rutt); ja Oobed oli Iisai isa; ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ja Iisai kuningas Taaveti isa. Taavet oli Saalomoni isa (tema ema oli Uurija naine); ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ja Saalomon oli Rehabeami isa; ja Rehabeam Abija isa; ja Abija Aasa isa; ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ja Aasa oli Joosafati isa; ja Joosafat Joorami isa; ja Jooram Ussija isa; ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ja Ussija oli Jootami isa; ja Jootam Aahase isa; ja Aahas Hiskija isa; ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ja Hiskija oli Manasse isa; ja Manasse Aamoni isa; ja Aamon Joosija isa; ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ja Joosija oli Jekonja ja tema vendade isa, Paabeli vangipõlve ajal. ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pärast Paabeli vangipõlve oli Jekonja Sealtieli isa; ja Sealtiel Serubbaabeli isa; ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ja Serubbaabel oli Abihuudi isa; ja Abihuud Eljakimi isa; ja Eljakim Assuri isa; ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ja Assur oli Saadoki isa; ja Saadok Ahhimi isa; ja Ahhim Elihuudi isa; ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ja Elihuud oli Eleasari isa; ja Eleasar Mattani isa; ja Mattan Jaakobi isa; ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ja Jaakob oli Joosepi isa; Joosep oli selle Maarja mees, kellest sündis Jeesus, keda nimetatakse Messiaks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nõnda on kõiki põlvkondi Aabrahmist Taavetini kokku neliteist, Taavetist Paabeli vangipõlveni neliteist põlvkonda ja Paabeli vangipõlvest Messiani neliteist põlvkonda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Messia Jeesuse sündimise lugu oli selline. Tema ema Maarja oli kihlatud Joosepiga, kuid enne, kui nad koos magamiseni jõudsid, jäi Maarja Pühast Vaimust lapseootele. ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tema kihlatu Joosep oli hea mees ega tahtnud Maarjat avalikult häbistada, seega otsustas ta kihluse diskreetselt katkestada. ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kui Joosep kõige selle peale mõtles, ilmus talle unes Issanda ingel ja ütles talle: „Joosep, Taaveti poeg, ära karda Maarjaga abielluda, sest ta on lapseootel Pühast Vaimust. ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Talle sünnib poeg ja sa pead talle nimeks panema Jeesus, sest ta päästab rahva nende pattudest.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","(See kõik toimus, et täituks see, mida Issand oli prohveti kaudu öelnud: ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","„Neitsi jääb lapseootele ja toob ilmale poja. Teda hüütakse Immaanueliks,“ mis tähendab „Jumal meiega“.) ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joosep ärkas ja tegi nii, nagu Issanda ingel oli teda käskinud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Joosep abiellus Maarjaga, kuid ei maganud temaga enne, kui ta oli sünnitanud poja, kellele ta pani nimeks Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Pärast seda kui Jeesus oli sündinud Petlemmas Juudamaal kuningas Heroodese valitsemisajal, tulid targad mehed idast Jeruusalemma. ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","„Kus on juutide kuningas, kes sündis?“ küsisid nad. „Me nägime tema tähte idas ja tulime teda kummardama.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kui kuningas Heroodes sellest kuulis, muutus ta väga rahutuks ja kogu Jeruusalemm koos temaga. ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Heroodes kutsus kokku kõik ülempreestrid ja rahva vaimulikud õpetajad ning küsis neilt, kus Messias pidi sündima. ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","„Petlemmas Juudamaal,“ vastasid nad talle, „sest nii kirjutas prohvet: ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","„Petlemm Juudamaal, sa ei ole kindlasti Juuda linnadest kõige tähtsusetum, sest sinust tuleb juht, kellest saab mu rahva Iisraeli karjane.““ ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Siis kutsus Heroodes targad mehed, rääkis nendega omaette ja uuris neilt täpselt, millal täht oli ilmunud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ta saatis nad Petlemma sõnadega: „Kui te sinna jõuate, otsige laps üles. Kui te ta leiate, andke mulle teada, et ka mina saaksin minna teda kummardama.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pärast seda, kui nad olid ära kuulanud, mis kuningal öelda oli, läksid nad oma teed, ning täht, mida nad olid idas näinud, juhtis neid, kuni peatus täpselt selle paiga kohal, kus laps oli. ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kui nad nägid tähte, ei suutnud nad oma rõõmu tagasi hoida! ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nad läksid majja ja nägid last koos tema ema Maarjaga. Nad põlvitasid ja kummardasid teda. Seejärel avasid nad oma aardekotid ning andsid talle kingiks kulda, viirukit ja mürri. ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kui neid oli unenäos hoiatatud, et nad ei läheks Heroodese juurde tagasi, suundusid nad oma kodumaale teist teed mööda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pärast nende lahkumist ilmus Issanda ingel unes Joosepile ja ütles talle: „Tõuse üles, võta laps ja tema ema ning põgene Egiptusesse. Jää sinna, kuni ma sulle ütlen, sest Heroodes hakkab last otsima, et teda tappa.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nõnda tõusis Joosep üles, võttis poisi ja tema ema ning hakkas öösel Egiptuse poole minema. ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Sinna jäid nad kuni Heroodese surmani. Nii täitus see, mida Issand oli prohveti kaudu öelnud: „Ma kutsusin oma poja Egiptusest.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kui Heroodes mõistis, et targad olid teda petnud, sai ta väga vihaseks. Ta saatis mehed tapma kõiki Petlemma ja ümberkaudsete piirkondade väikseid poisse, kes olid kaheaastased ja nooremad. See tugines ajavahemikule, mille ta oli tarkadelt teada saanud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nii läks täide Jeremija prohvetikuulutus: ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","„Raamas kuuldakse kohutavat nutmist ja leinamist, Raahel nutab oma lapsi taga. Nad on surnud ja ta on lohutamatu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pärast seda kui Heroodes suri, ilmus Issanda ingel unenäos Joosepile Egiptuses ja ütles talle: ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","„Tõuse üles! Võta laps ja tema ema ning mine tagasi Iisraeli maale, sest need, kes üritasid last tappa, on surnud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nõnda siis Joosep tõusis, võttis poisi ja tema ema ning läks tagasi Iisraeli maale. ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kuid Joosep kartis sinna tagasi minna, kui ta oli teada saanud, et Arhelaos oli oma isa Heroodese järel Juudamaa kuningaks saanud. Kui Joosep oli saanud unenäos hoiatuse, läks ta Galilea piirkonda ");
INSERT INTO ekkpkp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ja seadis end sisse Naatsaretis. Nii täitus see, mida prohvetid olid öelnud: „Teda nimetatakse naatsaretlaseks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mõne aja pärast hakkas tegutsema ristija Johannes ning ta kuulutas Juuda kõrbes: ");
INSERT INTO ekkpkp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","„Parandage meelt, sest taevariik on tulnud!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tema oli see, kellest Jesaja kõneles, kui ta ütles: „Kõrbes kuuldakse häält hüüdmas: „Valmistage Issandale teed! Tehke rajad tema jaoks sirgeks!““ ");
INSERT INTO ekkpkp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Johannese riided olid tehtud kaameli karvadest ja tal oli ümber nahkvöö. Tema toiduks olid jaanikaunad ja metsmesi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Rahvas tuli tema juurde Jeruusalemmast, tervest Juudast ja kogu Jordani piirkonnast ");
INSERT INTO ekkpkp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","nad ristiti Jordani jões ning nad tunnistasid avalikult oma patte. ");
INSERT INTO ekkpkp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Aga kui Johannes nägi ristimisele tulemas palju varisere ja sadusere, ütles ta neile: „Te rästikute sigitised! Kes hoiatas teid tulevase kohtu eest põgenema? ");
INSERT INTO ekkpkp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Näidake tegudega, et olete tõeliselt meelt parandanud, ");
INSERT INTO ekkpkp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ja ärge julgege uhkelt endamisi öelda: „Aabraham on meie isa.“ Ma ütlen teile, et Jumal võib teha Aabrahamile lapsi neist kividest. ");
INSERT INTO ekkpkp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tegelikult on kirves valmis puid maha raiuma. Iga puu, mis ei kanna head vilja, raiutakse maha ja heidetakse tulle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Jah, mina ristin teid veega meeleparanduse ilmutamiseks, aga pärast mind tuleb see, kes on minust suurem. Ma ei ole väärt isegi tema sandaale lahti päästma. Tema ristib teid Püha Vaimu ja tulega. ");
INSERT INTO ekkpkp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tal on käes valmis sari. Ta puhastab rehealuse ja kogub nisu aita, kuid aganad põletab ta ära tulega, mida ei saa kustutada.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Siis tuli Jeesus Galileast Jordani jõe äärde, et lasta end Johannesel ristida. ");
INSERT INTO ekkpkp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kuid Johannes üritas tema meelt muuta. Ta ütles Jeesusele: „Mul on vaja, et sina mind ristiksid, ja sina tuled minu juurde, et ma su ristiks?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","„Palun tee seda, sest meie jaoks on hea teha seda, mis Jumala sõnul on õige,“ vastas Jeesus talle. Niisiis oli Johannes nõus seda tegema. ");
INSERT INTO ekkpkp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kohe pärast seda, kui Jeesus sai ristitud, tuli ta vest välja. Taevad avanesid ja ta nägi Jumala Vaimu nagu tuvi laskumas ja tema peale tulemas. ");
INSERT INTO ekkpkp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Hääl taevast ütles: „See on minu poeg, keda ma armastan, kellest mul on hea meel.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Siis juhtis Vaim Jeesuse kõrbesse kuradi kiusata. ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Pärast neljakümmet päeva ja ööd paastumist oli tal kõht tühi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kiusaja tuli ja ütles talle: „Kui sa tõesti oled Jumala Poeg, käsi neil kividel leivaks muutuda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jeesus vastas: „Pühakirjas on öeldud: „Inimene ei ela üksnes leivast, vaid igast sõnast, mis lähtub Jumala suust.““ ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Siis kurat viis ta pühasse linna ja asetas ta templiharjale. ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","„Kui sa tõesti oled Jumala Poeg, siis heida end siit alla,“ ütles ta Jeesusele. „Sest Pühakirjas on öeldud: „Ta annab oma inglite käsu hoida sind kõige kahju eest. Ta püüab su kinni, et sa ei komistaks kivi otsa ega kukuks.““ ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jeesus vastas: „Pühakirjas on öeldud ka: „Sa ei tohi Issandat, oma Jumalat, kiusata.““ ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Siis viis kurat Jeesuse väga kõrge mäe otsa ja näitas talle kõiki maailma kuningriike nende täies hiilguses. ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ta ütles Jeesusele: „Ma annan need kõik sulle, kui sa langed põlvedele ja mind kummardad.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","„Mine ära, Saatan!“ ütles Jeesus. „Sest Pühakirjas on öeldud: „Sa pead kummardama Issandat, oma Jumalat, ja teenima üksnes teda.““ ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Siis kurat lahkus tema juurest ning inglid tulid tema eest hoolitsema. ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kui Jeesus kuulis, et Johannes oli vahistatud, läks ta tagasi Galileasse. ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ta lahkus Naatsaretist ja seadis end sisse Kapernaumas, järve ääres Sebuloni ja Naftali aladel. ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nii täitus see, mida prohvet Jesaja ütles: ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","„Sebuloni maal ja Naftali maal, mereni viiva tee ääres, Jordani jõe taga, Galileas, kus elavad võõrad: ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","pimeduses elav rahvas nägi suurt valgust; koiduvalgus paistis nende peale, kes elavad surmavarju maal.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sellest ajast peale hakkas Jeesus kuulutama oma sõnumit, öeldes: „Parandage meelt, sest taevariik on saabunud!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kui Jeesus kõndis Galilea mere ääres, nägi ta kaht venda. Siimon, keda hüüti ka Peetruseks, ja tema vend Andreas heitsid võrke merre. Nad teenisid kalapüügiga elatist. ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","„Tulge ja järgnege mulle ning ma õpetan teid, kuidas püüda inimesi,“ ütles ta neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nad jätsid kohe oma võrgud maha ja järgnesid talle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Edasi minnes nägi ta veel kaht venda, Jaakobust ja Johannest. Nad olid paadis koos oma isa Sebedeusega ja parandasid võrke. Ta kutsus neid endale järgnema. ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nad jätsid kohe paadi ja isa maha ning järgnesid talle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jeesus rändas läbi Galilea, õpetas sünagoogides, kuulutas head sõnumit kuningriigist ning tervendas kõiki vaevusi ja haigusi, mis inimestel oli. ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Uudis temast levis läbi kogu Süüria provintsi. Tema juurde toodi kõik, kes olid haiged − haigushoogude all kannatavad, kurjadest vaimudest vaevatud, vaimselt haiged ja halvatud inimesed − ning ta tegi nad kõik terveks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Suured rahvahulgad järgnesid talle Galileast, Dekapolisest, Jeruusalemmast, Juudamaalt ja Jordani-tagusest piirkonnast. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kui Jeesus nägi rahvahulki enda järel käimas, läks ta üles mäele. Seal istus ta koos oma jüngritega maha. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ta hakkas neid õpetama ning ütles: ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","„Õnnistatud on need, kes tunnevad ära, et nad on vaimulikult vaesed, sest nende päralt on taevariik. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Õnnistatud on need, kes kurvastavad, sest neid lohutatakse. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Õnnistatud on need, kes on heatahtlikud, sest nende päralt on kogu maailm. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Õnnistatud on need, kelle suurim soov on teha seda, mis on õige, sest nende soov täidetakse. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Õnnistatud on need, kes on halastavad, sest nende suhtes ilmutatakse halastust. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Õnnistatud on need, kel on puhas süda, sest nemad näevad Jumalat. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Õnnistatud on need, kes näevad vaeva rahu loomisel, sest neid hüütakse Jumala lasteks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Õnnistatud on need, keda kiusatakse taga sellepärast, mis on õige, sest nende päralt on taevariik. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Õnnistatud olete teie, kui inimesed teid solvavad ja taga kiusavad ning süüdistavad teid minu pärast igasugustes halbades asjades. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Olge rõõmsad, olge tõesti rõõmsad, sest te saate suure tasu taevas, sest samamoodi kiusasid nad taga prohveteid, kes olid enne teid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Teie olete maa sool, aga kui sool muutub maitsetuks, kuidas saab selle jälle soolaseks teha? Sellest pole kasu millegi jaoks, nii et see visatakse välja jalgade alla tallamiseks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Teie olete maailma valgus. Mäe otsa ehitatud linn ei saa varjule jääda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Keegi ei süüta lampi ega pane seda ämbri alla. Ei, see asetatakse lambijalale ning see valgustab kõiki majas. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Samamoodi peate ka teie laskma oma valgusel paista kõigi ees, et nad näeksid häid asju, mida te teete, ning ülistaksid teie taevast Isa. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ärge arvake, et ma tulin seadust või prohvetite kirju tühistama. Ma ei tulnud neid tühistama, vaid täitma. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ma kinnitan teile, kuni taevas ja maa püsivad, ei kao seadusest ainsat tähte ega märki enne, kui kõik on täitunud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Seega, kes iganes põlgab kas või kõige tähtsusetumat käsku ja õpetab nii inimesi, seda nimetatakse taevariigis kõige tähtsusetumaks; aga kes iganes järgib ja õpetab käske, seda nimetatakse taevariigis suureks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ma ütlen teile, kui teie moraalne õigsusei ole rohkem kui vaimulike õpetajate ja variseride oma, ei saa te kunagi taevariiki. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Te olete kuulnud, et seadus ütles inimestele muiste: „Sa ei tohi tappa, ja igaüks, kes tapab, mõistetakse süüdi.“. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Aga mina ütlen teile, igaüks, kes on oma venna peale vihane, mõistetakse süüdi. Kes iganes nimetab oma venda idioodiks, peab vastust andma nõukogu ees, aga kes iganes teisi sõimab, läheb kohtutulle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kui sa oled altari juures ohvrit toomas ja sulle meenub, et su vennal on midagi sinu vastu, ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","siis jäta oma ohver altarile ja tee esmalt temaga rahu ning alles pärast tule tagasi ja too oma ohver. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kui sa oled oma vastasega teel kohtusse, siis püüa asjad kiiresti lahendada. Muidu võib su vastane anda sind kohtuniku kätte ja kohtunik annab sind kohtu ametniku kätte ning sind heidetakse vanglasse. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ma räägin teile tõtt: sa ei pääse sealt välja enne, kui oled ära maksnud oma viimasegi penni. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Te olete kuulnud, et seadus ütles: „Ära riku abielu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Aga mina ütlen teile, et igaüks, kes vaatab naist himuralt, on temaga mõttes juba abielu rikkunud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kui su parem silm juhib sind patustama, siis kisu see välja ja viska minema, sest parem on kaotada üks osa oma kehast, kui et kogu su keha visatakse kohtutulle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kui su parem käsi juhib sind patustama, siis lõika see maha ja viska minema, sest sul on parem kaotada üks jäsemetest, kui et kogu su keha visatakse kohtutulle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Seadus ütles ka: „Kui mees lahutab oma naisest, peab ta andma naisele lahutustunnistuse.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Aga mina ütlen teile, et iga mees, kes lahutab oma naisest muidu kui seksuaalse ebamoraalsuse tõttu, sunnib naist abielu rikkuma, ja kes iganes abiellub lahutatud naisega, rikub abielu. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ja veel, te olete kuulnud, et seadus ütles inimestele ammu: „Sa ei tohi valet vanduda. Hoolitse selle eest, et pead oma vandeid, mille Issandale annad.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Aga mina ütlen teile: ärge üldse vanduge. Ärge vanduge taeva juures, sest see on Jumala troon. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ärge vanduge maa juurest, sest see on Jumala jalajäri. Ärge vanduge Jeruusalemma juures, sest see on suure Kuninga linn. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ärge vanduge isegi oma pea juures, sest te ei suuda üht juuksekarvagi valgeks või mustaks teha. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Öelge lihtsalt jah või ei – mis on üle selle, on kurjast. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Te olete kuulnud, et seadus ütleb: „Silm silma vastu ja hammas hamba vastu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Aga mina ütlen teile, ära hakka vastu sellele, kes on kuri. Kui keegi lööb sind parema põse pihta, pööra talle ka teine põsk. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kui keegi tahab sind kohtusse kaevata ja võtab su särgi, anna talle ka oma kuub. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kui keegi nõuab, et kõnniksid ühe miili, mine temaga kaks miili. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Anna sellele, kes sinult palub, ja ära pöördu ära sellest, kes tahab sinult laenata. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Te olete kuulnud, et seadus ütleb: „Armasta oma ligimest ja vihka oma vaenlast.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Aga mina ütlen teile, armastage oma vaenlasi ja palvetage nende eest, kes teid taga kiusavad, ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","et te võiksite saada oma taevase Isa lasteks. Sest tema päike paistab nii heade kui halbade peale ning ta laseb vihma sadada nii nende peale, kes toimivad õigesti, kui ka nende peale, kes toimivad valesti. ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Sest kui sa armastad ainult neid, kes sind armastavad, mis tasu sa saad? Kas mitte isegi maksukogujad ei tee seda? ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kui sa kõneled lahkelt ainult oma pereliikmetega, mida enamat sa siis teed kui keegi teine? Isegi paganad teevad seda! ");
INSERT INTO ekkpkp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kasva suureks ja saa täielikult usaldusväärseks, just nagu teie taevane Isa on usaldusväärne.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","„Ära tee oma häid tegusid inimeste ees, lihtsalt selleks, et neid näha oleks. Muidu ei saa sa mingit tasu Isalt, kes on taevas. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kui sa vaestele annad, ära ole nagu silmakirjatsejad, kes puhuvad pasunaid, et teada anda, mida nad teevad sünagoogides ja tänavatel, nii et inimesed ülistaksid neid. Ma ütlen teile tõde: nad on oma tasu juba kätte saanud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kui sa annad vaestele, siis ärgu sinu vasak käsi teadku, mida su parem käsi teeb. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nii on see, mida sa annad, salajane, ja su Isa, kes näeb, mis toimub salajas, tasub sulle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Kui sa palvetad, siis ära ole nagu silmakirjatsejad, sest neile meeldib püsti tõusta ja palvetada sünagoogides ja tänavanurkadel, nii et inimesed neid näeksid. Ma luban teile, nad on oma tasu juba kätte saanud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Aga sina, kui sa palvetad, mine tuppa ja sulge uks ning palveta oma Isa poole salajas, ja su Isa, kes näeb, mis toimub salajas, tasub sulle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kui sa palvetad, siis ära lobise mõttetult nagu võõrad, kes arvavad, et neid kuuldakse kõigi nende sõnade pärast, mida nad kordavad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ärge olge nende moodi, sest teie Isa teab, mida te vajate juba enne, kui te temalt palute. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Palvetage siis nõnda: „Meie taevane Isa, austatud olgu sinu nimi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Sinu riik tulgu! Sinu tahe täitugu maa peal samamoodi nagu taevas. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Palun anna meile täna toitu, mida vajame. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Andesta meie patud, nagu meie oleme andestanud neile, kes on meie vastu pattu teinud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Palun ära lase meil kiusatusele järele anda ja päästa meid kurja käest.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Sest kui te annate andeks neile, kes teie vastu patustavad, annab ka teie taevane Isa teile andeks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Aga kui te ei anna andeks neile, kes teie vastu patustavad, siis ei anna teie taevane Isa teie patte andeks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Kui sa paastud, siis ära ole nagu silmakirjatsejad, kes teevad kurva näo ja jätavad oma välimuse hooletusse, et kõik näeksid, et nad paastuvad. Ma ütlen teile tõde: nad on oma tasu juba kätte saanud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Aga kui sina paastud, pese oma nägu ja tee välimus korda, ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","et inimesed ei näeks, et sa paastud, ning su nähtamatu Isa, kes näeb, mis toimub salajas, tasub sulle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ärge kuhjake rikkust siia maa peale, kus koi ja rooste seda rikuvad ning kus vargad sisse murravad ja selle varastavad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Selle asemel koguge oma vara taevasse, kus koid ja rooste seda ei riku ning kus vargad sisse ei murra ega seda varasta. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sest see, mida sa kõige enam hindad, näitab, kes sa tegelikult oled. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Silm on nagu lamp, mis valgustab ihu. Niisiis, kui su silm on terve, siis on kogu su ihul valgus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Aga kui su silm on kuri, on kogu su ihu pimeduses. Kui „valgus“, mis sul on, on tegelikult pimedus, kui pime see siis on! ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Keegi ei saa teenida kaht isandat. Sa kas vihkad üht ja armastad teist või oled pühendunud ühele ja põlgad teist. Te ei saa teenida Jumalat ja Raha. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Sellepärast ma ütlengi teile, et ärge muretsege oma elu pärast. Ärge muretsege sellepärast, mida süüa või mida juua või missugused rõivad selga panna. Kas elu ei ole olulisem kui toit ja ihu olulisem kui rõivad? ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pange tähele linde − nad ei külva ega lõika ega hoia toidust aitades, sest teie taevane Isa toidab neid. Kas teie ei ole rohkem väärt kui nemad? ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kes teist suudaks muretsemisega oma elule minutigi lisada? ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ja miks te muretsete rõivaste pärast? Vaadake kauneid lilli väljal. Vaadake, kuidas nad kasvavad: nad ei tee rasket tööd, nad ei ketra lõnga. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Aga ma ütlen teile, isegi Saalomon kogu oma hiilguses ei olnud riietatud nii, nagu üks neist lilledest. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Niisiis, kui Jumal ehib sedasi väljal heina, mis täna on ja homme visatakse tulle, kas ta siis ei tee palju enam teie heaks, te inimesed, kes nii vähe usaldavad? ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ärge siis muretsege, öeldes: „Mida me sööme?“ või „Mida me joome?“ või „Mida me selga paneme?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kõiki neid asju taotlevad paganad, aga teie taevane Isa teab kõike, mida teil vaja on. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Taotlege kõigepealt tema riiki ja õiget eluviisi ning teile antakse kõike. ");
INSERT INTO ekkpkp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Seega ärge muretsege homse pärast, sest homne päev suudab ise enda eest muretseda. Igas päevas on juba piisavalt halba.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","„Ärge mõistke kohut, et teie üle kohut ei mõistetaks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sest samasugust mõõdupuud, mida kasutate teiste üle kohtu mõistmiseks, kasutatakse ka teie üle kohtu mõistmiseks ning selle mõõduga, millega teie teistele mõõdate, mõõdetakse ka teile. ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Miks sa näed pindu, mis on su venna silmas? Kas sa ei näe palki, mis on su enda silmas? ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kuidas sa saad öelda oma vennale: „Luba, ma võtan selle pinnu su silmast välja“, kui su enda silmas on palk? ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Sa oled silmakirjalik! Kõigepealt kaota palk oma silmast. Siis oled võimeline selgelt nägema, et võtta oma venna silmast pind välja. ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ärge andke koertele seda, mis on püha. Ärge visake pärleid sigadele, et sead ei tallaks neid jalge alla ning koerad ei pöörduks ega ründaks teid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Paluge, ja teile antakse; otsige, ja te leiate; koputage, ja teile avatakse. ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Igaüks, kes palub, see saab; kes otsib, see leiab, ja kes koputab, sellele avatakse. ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kas keegi teist annaks oma pojale kivi, kui ta küsib leiba? ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Või annaks talle mao, kui ta küsib kala? ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Niisiis, kui isegi teie, kes olete kurjad, oskate anda häid asju oma lastele, kui palju enam annab teie taevane Isa häid asju neile, kes teda paluvad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Käitu teistega nii, nagu sa tahad, et nemad sinuga käituksid. See võtab kokku seaduse ja prohvetid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Minge sisse kitsast uksest. Sest avar on uks ja lai on tee, mis viib hukatusse, ja sellel teel käivad paljud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kuid kitsas on värav ja raske on tee, mis viib ellu, ning selle leiavad vaid vähesed. ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Olge valvel valeprohvetite suhtes, kes tulevad lambanahas, kuid kes seesmiselt on tigedad hundid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Te tunnete nad ära nende viljast. Kas kibuvitstest saadakse viinamarju või ohakatest viigimarju? ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Niisiis, iga hea puu annab head vilja, samas halb puu annab halba vilja. ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Hea puu ei saa anda halba vilja ja halb puu head vilja. ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Iga puu, mis ei kanna head vilja, raiutakse maha ja visatakse tulle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Niisiis, te tunnete nad ära nende viljast. ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mitte igaüks, kes ütleb mulle: „Issand, Issand“, ei saa taevariiki; saavad ainult need, kes täidavad mu taevase Isa tahet. ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Paljud ütlevad mulle viimsel kohtupäeval: „Issand, Issand, kas me ei kuulutanud sinu nimel prohvetlikult, kas me ei ajanud sinu nimel välja kurje vaime, kas me ei teinud sinu nimel palju imetegusid?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Siis ma ütlen neile: „Ma ei ole teid kunagi tundnud. Minge minu juurest ära, teie, kes teete kurje tegusid!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Igaüks, kes kuuleb minu sõnu ja teeb nende järgi, on nagu arukas mees, kes ehitas oma maja tugevale kaljule. ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Sadas paduvihma, tekkis üleujutus ja vali tuul puhus vastu maja, kuid sellega ei juhtunud midagi, sest selle aluseks oli tugev kalju. ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Igaüks, kes kuuleb minu sõnu, aga ei tee nende järgi, on nagu rumal mees, kes ehitas oma maja liivale. ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sadas paduvihma, tekkis üleujutus ja vali tuul puhus vastu maja ning see varises, kukkus täiesti kokku.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kui Jeesus lõpetas nende teemade selgitamise, oli rahvas tema õpetusest hämmastunud, ");
INSERT INTO ekkpkp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","sest ta õpetas nagu see, kellel on võim, mitte nagu nende vaimulikud õpetajad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Suured rahvahulgad järgisid Jeesust, kui ta mäelt alla tuli. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Üks pidalitõbine lähenes talle, tuli ja kummardas teda ning ütles: „Issand, kui sa tahad, palun tervenda mind!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jeesus sirutas käe ja puudutas teda sellega. „Ma tahan,“ ütles ta. „Saa terveks!“ Mees sai kohe pidalitõvest terveks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","„Vaata, et sa kellelegi ei räägi,“ ütles Jeesus talle. „Mine ja näita ennast preestrile ning vii avalikuks tõenduseks ohver, mida Mooses käskis.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kui Jeesus jõudis Kapernauma, tuli tema juurde sadakonnaülem ja palus abi: ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","„Issand, mu sulane on kodus pikali ega suuda liigutada. Ta on kohutavas piinas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","„Ma tulen ja teen ta terveks,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Sadakonnaülem lausus: „Issand, ma ei ole ära teeninud, et sa mu kodu külastaksid. Ütle lihtsalt sõna ja mu sulane saab terveks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Sest ma ise olen ülemate võimu all, kuigi ka minu käsutuses on sõdureid. Kui ma käsin üht: „Mine!“, siis ta läheb. Kui käsin teist: „Tule!“, siis ta tuleb. Ma ütlen oma sulasele: „Tee seda!“, ja ta teeb seda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kui Jeesus kuulis tema sõnu, oli ta jahmunud. Ta ütles neile, kes teda järgisid: „Ma ütlen teile tõtt: ma pole sellist kindlat usku leidnud kusagil Iisraelis. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ma ütlen teile, et palju tulevad idast ja läänest ning istuvad taevariigis koos Aabrahami, Iisaki ja Jaakobiga. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Aga kuningriigi pärijad heidetakse välja äärmisesse pimedusse, kus on nutmine ja hammaste kiristamine.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Siis ütles Jeesus sadakonnaülemale: „Mine koju. Kuna sa uskusid, et see võib toimuda, siis on sinu palutu täide läinud.“ Sulane sai terveks selsamal hetkel. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kui Jeesus jõudis Peetruse koju, nägi ta, et Peetruse ämm oli kõrge palavikuga voodis haige. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jeesus puudutas naise kätt ja palavik lahkus temast. Naine tõusis üles ja hakkas talle toitu valmistama. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kui saabus õhtu, tõid paljud Jeesuse juurde neid, kes olid kurjadest vaimudest vaevatud. Jeesus käskis vaime ja sundis nad lahkuma ning tegi terveks kõik, kes olid haiged. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nii täitus see, mida prohvet Jesaja ütles: „Ta tervendas meie vaevused ja vabastas meid meie haigustest.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kui Jeesus nägi enda ümber kogunenud rahvahulka, andis ta korralduse, et nad läheksid järve teisele kaldale. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Üks vaimulikest õpetajatest lähenes talle ja ütles: „Õpetaja, ma tahan järgida sind kõikjale, kuhu sa lähed!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","„Rebastel on urud ja metslindudel pesad, kuid inimese Pojal ei ole kohta, kus ta saaks pikali heita ja puhata,“ lausus Jeesus talle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Üks teine jünger ütles Jeesusele: „Issand, las ma lähen kõigepealt ja matan oma isa.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","„Järgi mind! Jäta surnud oma surnuid matma,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Siis astus Jeesus paati ja tema jüngrid läksid temaga koos. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Äkitselt puhkes äge torm ja lained lõid üle paadi, kuid Jeesus magas edasi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jüngrid läksid tema juurde ja äratasid ta üles. „Päästa meid, Issand! Me upume!“ karjusid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","„Miks te nii hirmul olete? Miks on teil nii vähe usku?“ küsis ta neilt. Seejärel tõusis ta püsti ning käskis tuulel ja lainetel vait jääda. Kõik jäi täiesti rahulikuks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jüngrid olid hämmastunud ja ütlesid: „Kes ta küll on? Isegi tuul ja lained kuulavad tema sõna!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kui ta jõudis teisele kaldale, gadaralaste piirkonda, tulid talle surnuaia poolt vastu kaks kurjadest vaimudest vaevatud meest. Nad olid nii ohtlikud, et keegi ei julgenud seda teed käia. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nad karjusid: „Mis on sul meiega tegemist, Jumala Poeg? Kas tulid meid enneaegu vaevama?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Eemal oli söömas suur seakari. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kurjad vaimud anusid teda: „Kui sa ajad meid välja, saada meid seakarja sisse.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","„Minge!“ käskis Jeesus. Kurjad vaimud lahkusid meestest ja läksid sigade sisse. Kogu kari jooksis järsust mäenõlvast alla merre ja uppus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Seakarjased jooksid minema. Nad läksid linna ja rääkisid seal rahvale kõigest, mis oli toimunud, ja sellest, mis oli juhtunud kurjadest vaimudest vaevatud meestega. ");
INSERT INTO ekkpkp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kogu linn tuli välja Jeesusele vastu. Kui nad ta leidsid, palusid nad tal nende piirkonnast lahkuda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nõnda läks siis Jeesus paadiga tagasi üle järve linna, kus ta elas. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Seal toodi tema juurde matil lamav halvatud mees. Kui Jeesus nägi nende usku, ütles ta halvatule: „Mu sõber, ära kurvasta! Sinu patud on andeks antud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Selle peale ütlesid mõned vaimulikud õpetajad isekeskis: „Ta teotab Jumalat!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kuid Jeesus teadis, mida nad mõtlevad. Ta küsis neilt: „Miks te mõtlete kurje mõtteid? ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mida on kergem öelda: „Su patud on andeks antud“ või „Tõuse üles ja kõnni“? ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Aga et veenda teid, et inimese Pojal on õigus patte andeks anda …“ Ta ütles halvatule: „Tõuse üles, võta oma matt ja mine koju!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mees tõusis üles ja läks koju. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kui rahvahulgad nägid, mis oli juhtunud, olid nad ehmunud. Siis ülistasid nad Jumalat, et ta oli andnud inimesele sellise väe. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kui Jeesus sealt edasi läks, nägi ta maksukogumispunktis istumas meest nimega Matteus. Jeesus kutsus teda: „Järgi mind!“ Ta tõusis üles ja järgnes Jeesusele. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sel ajal kui Jeesus sõi Matteuse kodus, tuli palju maksukogujaid ja patuseid ning nad istusid lauas koos Jeesuse ja tema jüngritega. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kui variserid seda nägid, küsisid nad Jeesuse jüngritelt: „Miks teie Õpetaja sööb koos maksukogujate ja patustega?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kui Jeesus seda küsimust kuulis, vastas ta: „Arsti ei vaja terved, vaid haiged. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Minge ja uurige välja, mida see tähendab: „Ma tahan halastust, mitte ohvrit. Sest ma ei tulnud kutsuma neid, kes teevad seda, mis on õige; ma tulin kutsuma patuseid.““ ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Siis tulid Johannese jüngrid ja küsisid: „Miks on nii, et meie ja variserid paastume sageli, aga sinu jüngrid ei paastu?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","„Kas pulmakülalised kurvastavad, kui peigmees on nende juures?“ vastas Jeesus. „Aga tuleb aeg, mil peigmees võetakse nende juurest ära, ja siis nad paastuvad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Keegi ei pane vanadele rõivastele uut riiet paigaks, muidu tõmbab see kokku ja rebend läheb hullemaks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Keegi ei pane uut veini vanadesse lähkritesse, muidu lähkrid rebenevad, vein voolab maha ja lähkrid on rikutud. Ei, uus vein pannakse uutesse nahklähkritesse ja mõlemad kestavad.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Sel ajal kui ta neile seda rääkis, tuli üks ülematest ja kummardus tema ees. „Mu tütar suri just,“ ütles mees Jeesusele. „Aga ma tean, et kui sa tuled ja paned oma käe tema peale, siis ta tuleb ellu tagasi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jeesus ja tema jüngrid tõusid ja läksid tema järel. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Sel hetkel tuli tema taha üks naine, kes oli kaksteist aastat veritsustõves olnud, ja puudutas tema kuube. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ta ütles endamisi: „Kui ma vaid saaksin puudutada tema kuube, siis ma saaksin terveks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jeesus pöördus ja vaatas talle otsa. „Ole rõõmus, sest sinu usk minusse on su terveks teinud,“ ütles ta naisele. Naine sai otsekohe terveks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jeesus jõudis ametniku koju. Ta nägi flöödimängijaid ja rahvahulka, mis nuttis valjusti. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","„Palun minge ära,“ ütles ta rahvale, „sest tüdruk ei ole surnud, ta vaid magab.“ Aga nad naersid ja heitsid tema üle nalja. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kuid kui rahvas oli laiali saadetud, läks Jeesus sisse, võttis tüdrukul käest kinni ja tüdruk tõusis üles. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Sõnum juhtunust levis üle kogu selle piirkonna. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kui Jeesus sealt edasi läks, järgnesid talle kaks pimedat meest, kes hüüdsid: „Taaveti Poeg, palun halasta meie peale!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kui Jeesus jõudis majja, kus ta peatus, tulid ka pimedad mehed sisse. „Kas te olete veendunud, et ma olen võimeline seda tegema?“ küsis ta neilt. „Jah, Issand,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Siis Jeesus puudutas nende silmi ja ütles: „See toimub, sest te usute minusse!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ja nad nägid jälle. Siis Jeesus hoiatas neid: „Vaadake, et keegi sellest teada ei saaks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Aga nad läksid ja rääkisid Jeesusest kõikjal. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kui Jeesus ja tema jüngrid olid lahkumas, toodi tema juurde mees, kes oli tumm ja kurjast vaimust vaevatud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kui kuri vaim oli temast välja aetud, siis tumm mees rääkis, ja rahvahulk oli hämmastuses. „Midagi seesugust pole varem Iisraelis juhtunud,“ ütlesid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Aga variserid täheldasid: „Ta ajab kurje vaime välja kurjade vaimude ülema väe abil.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jeesus käis igal pool ning külastas linnu ja külasid. Ta õpetas nende sünagoogides, rääkis head sõnumit kuningriigist ning tervendas igasuguseid haigusi ja vaevusi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kui Jeesus nägi rahvahulki, oli ta sügavalt liigutatud kaastundest nende vastu, sest nad olid mures ja abitud, nagu lambad ilma karjaseta. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ta ütles oma jüngritele: „Lõikus on suur, kuid töötegijaid on vähe. ");
INSERT INTO ekkpkp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Palvetage lõikuse Issanda poole ja paluge tal saata veel töötegijaid oma lõikust koguma.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jeesus kutsus oma kaksteist jüngrit kokku ja andis neile väe ajada välja kurje vaime ning tervendada igasuguseid haigusi ja vaevusi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Need on kaheteistkümne apostli nimed: esiteks Siimon (kutsutakse ka Peetruseks), tema vend Andreas, Jaakobus, Sebedeuse poeg, ja tema vend Johannes, ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filippus, Bartolomeus, Toomas, maksukoguja Matteus, Jaakobus, Alfeuse poeg, Taddeus, ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","revolutsionäär Siimon ja Juudas Iskariot, kes Jeesuse reetis. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jeesus saatis need kaksteist välja ja ütles neile: „Ärge minge võõramaalaste juurde ega Samaaria linnadesse. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Te peate minema Iisraeli soo kadunud lammaste juurde. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kuhu iganes te lähete, öelge inimestele: „Taevariik on lähedal.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tehke haiged terveks. Äratage surnud ellu. Tervendage pidalitõbised. Ajage kurjad vaimud välja. Tasuta olete saanud, nii et andke ka tasuta! ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ärge võtke taskus kaasa kuld-, hõbe- ega vaskmünte ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ega kotti teekonnaks ega kahte kuube, sandaale ega jalutuskeppi, sest töötegija on väärt, et teda ülal peetakse. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kuhu iganes te lähete, ükskõik missugusesse linna või külasse, küsige inimese järele, kes elab heade põhimõtete kohaselt, ja jääge sinna kuni lahkumiseni. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kui te sisenete majja, andke sellele oma õnnistus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kui maja on seda väärt, tulgu teie rahu selle peale, aga kui see pole väärt, tulgu teie rahu teile tagasi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kui keegi ei võta teid vastu ning keeldub kuulamast, mida teil on öelda, siis lahkuge sellest majast või sellest linnast ning raputage minnes selle paiga tolm oma jalgadelt maha. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ma ütlen teile tõtt: viimsel kohtupäeval on Soodomal ja Gomorral parem kui sellel linnal! ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Vaadake, ma saadan teid nagu lambaid huntide sekka. Olge siis arukad nagu maod ja kahjutud nagu tuvid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Hoiduge nende eest, kes annavad teid linnanõukogude kohtu kätte ja piitsutavad teid sünagoogides. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Teid veetakse valitsejate ja kuningate ette minu pärast, tunnistuseks neile ja võõramaalastele. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Aga kui teid kohtu alla antakse, siis ärge muretsege, kuidas peaksite kõnelema või mida ütlema, sest teile öeldakse õigel ajal, mida kosta. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Sest teie ei kõnele, vaid Isa Vaim kõneleb teie kaudu. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Vend reedab venna ja annab ta surma ning isa teeb sama oma lapsega. Lapsed hakkavad vastu oma vanematele ja saadavad nad surma. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kõik vihkavad teid sellepärast, et te järgite mind, aga kes otsani vastu peab, see päästetakse. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kui teid ühes linnas taga kiusatakse, põgenege järgmisesse. Ma ütlen teile tõtt: te ei lõpeta Iisraeli linnades käimist enne, kui inimese Poeg tuleb. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Õpilased ei ole tähtsamad kui nende õpetaja; sulased ei ole tähtsamad kui nende isand. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Õpilased peaksid rahul olema, kui nad saavad oma õpetaja sarnaseks, ja sulased oma isanda sarnaseks. Kui perepead nimetatakse peadeemon Peltsebuliks, siis on tema pereliikmed veel kurjemad vaimud! ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Niisiis, ärge kartke neid, sest midagi pole nii varjatud, et ei saaks avalikuks, ja miski pole nii peidetud, et sellest ei saadaks teada. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Seda, mida mina räägin teile pimeduses, kuulutage siis, kui on valge, ja mida kuulete kõrva sosistatavat, seda hüüdke katustelt. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ärge kartke neid, kes võivad teid füüsiliselt tappa, kuid ei saa vaimulikult tappa. Kartke hoopis teda, kes suudab teid hävitustules füüsiliselt ja vaimulikult hävitada. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kas kaks varblast ei müüda kõigest ühe penni eest? Aga ükski neist ei kuku maha, ilma et teie Isa sellest teaks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Isegi teie juuksekarvad peas on ära loetud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Seega ärge muretsege − te olete rohkem väärt kui palju varblasi! ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Igaühe eest, kes avalikult kuulutab oma pühendumisest minule, kuulutan mina pühendumisest temale oma Isa ees taevas. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Aga kes mind avalikult salgab, teda salgan minagi oma Isa ees taevas. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ärge arvake, et olen tulnud tooma rahu maa peale. Ma ei tulnud tooma rahu, vaid mõõka. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ma tulin, et „pöörata mees oma isa vastu, tütar oma ema vastu ja minia oma ämma vastu. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Teie vaenlased on teie enda pereliikmed!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Kui te armastate oma isa või ema rohkem kui mind, siis ei ole te väärt minu omad olema, ja kui te armastate oma poega või tütart rohkem kui mind, ei ole te väärt minu omad olema. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kui te ei võta oma risti ega järgne mulle, ei ole te väärt minu omad olema. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kui te üritate oma elu säästa, siis te kaotate selle, aga kui kaotate oma elu minu pärast, siis säästate selle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Need, kes võtavad vastu teid, võtavad vastu minu, ja kes võtavad vastu minu, võtavad vastu selle, kes mind läkitas. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Need, kes võtavad prohveti vastu sellepärast, et ta on prohvet, saavad sama tasu nagu prohvet. Need, kes võtavad vastu kellegi, kes toimib õigesti, saavad sama tasu nagu see, kes toimib õigesti. ");
INSERT INTO ekkpkp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma ütlen teile tõtt: see, kes annab jahedat vett juua kõige tühisemale minu jüngritest, ei jää kindlasti oma tasust ilma.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kui Jeesus oli lõpetanud oma kaheteistkümne jüngri õpetamise, läks ta ümbruskonna linnadesse õpetama ja avalikult kõnelema. ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Sel ajal kui Johannes oli vanglas, kuulis ta, mida Messias tegi, seega saatis ta oma jüngrid ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","enda nimel küsima: „Kas sina oled see, kelle tulekut pidime ootama, või peame veel kedagi teist otsima?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jeesus vastas neile: „Minge tagasi ja rääkige Johannesele, mida te kuulete ja näete. ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Pimedad näevad, jalutud kõnnivad, pidalitõbised saavad terveks, kurdid kuulevad, surnud äratatakse üles ja vaesed kuulevad head sõnumit. ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Õnnistatud on need, kes mind tagasi ei lükka!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kui nad lahkusid, hakkas Jeesus rahvale Johannesest rääkima. „Mida te lootsite näha, kui läksite välja kõrbesse? Tuule käes kõikuvat pilliroogu? ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mida te siis läksite vaatama? Uhketes rõivastes meest? Selliste rõivastega inimesed elavad kuningapaleedes. ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mida te siis läksite vaatama? Prohvetit? Jah, ja ma ütlen teile, ta on palju enam kui prohvet! ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tema on see, kellest pühakirjas on kirjutatud: „Ma saadan oma käskjala sinu eel. Ta valmistab sulle teed.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ma ütlen teile tõtt, et inimeste hulgas ei ole suuremat kui Ristija Johannes, aga isegi kõige tühisem taevariigis on temast suurem. ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ristija Johannese ajast kuni praeguseni on taevariik jätkuvalt rünnakute all ning vägivaldsed inimesed üritavad seda jõuga enda valdusesse haarata. ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Sest kõik prohvetid ja seadus kõnelesid Jumala kasuks kuni Johannese tulekuni. ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kui olete valmis seda uskuma: tema on Eelija, see, kes pidi tulema. ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kellel kõrvad on, see kuulaku! ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Millega peaksin seda põlvkonda võrdlema? See on nagu turuplatsil istuvad lapsed, kes karjuvad üksteisele: ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","„Me mängisime teile flööti ja te ei tantsinud; me laulsime laule ja te ei nutnud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Johannes ei tulnud sööma ja jooma, seepärast inimesed ütlevad: „Ta on kurjast vaimust vaevatud!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Inimese Poeg aga tuli, sõi ja jõi ning inimesed ütlevad: „Vaadake, ta on ahne ja joob liiga palju; ta on maksukogujate ja patuste sõber!“ Kuid arukus näitab, et tal on õigus, sellega, mida ta teeb …“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Siis hakkas ta noomima linnu, kus ta oli teinud kõige rohkem imetegusid, sellepärast et nad ei olnud meelt parandanud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","„Häbi sulle, Korasin! Häbi sulle, Betsaida! Kui Tüüroses ja Siidonis oleksid toimunud need imeteod, mis toimusid teie juures, oleksid nad juba ammu kotiriides ja tuhas kahetsenud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Aga ma ütlen teile, et kohtupäeval on Tüürose ja Siidoni olukord parem kui teil! ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ja kuidas on sinuga, Kapernaum? Kas sind ülendatakse taevasse? Ei, sa lähed alla manalasse! Kui Soodomas oleksid tehtud need imeteod, mis toimusid sinu juures, oleks Soodom veel tänapäevalgi alles. ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Aga ma ütlen teile, et kohtupäeval on Soodoma olukord parem kui sinul!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Siis Jeesus palvetas: „Ma kiidan sind, Isa, taeva ja maa Issand, et sa oled neid asju varjanud tarkade ja haritute eest. Selle asemel oled sa need ilmutanud tavalistele inimestele. ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jah, Isa, sa tegid seda hea meelega! ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Isa on kõik usaldanud minu kätte ja tegelikult ei mõista keegi Poega, välja arvatud Isa, ja keegi ei mõista tegelikult Isa, välja arvatud Poeg ja need, kellele Poeg otsustab teda ilmutada. ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tulge minu juurde kõik, kes te praegu heitlete ja olete koormatud. Ma annan teile rahu. ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Võtke vastu minu ike ja õppige minult, sest mina olen lahke ja alandliku südamega ning te leiate minust rahu, mida vajate. ");
INSERT INTO ekkpkp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sest minu ike on vaevu tuntav ja minu koorem on kerge.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Umbes sel ajal kõndis Jeesus hingamispäeval läbi viljapõldude. Tema jüngritel oli kõht tühi, seepärast hakkasid nad viljapäid korjama ja teri sööma. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kui variserid seda nägid, ütlesid nad Jeesusele: „Vaata oma jüngreid − nad teevad seda, mida ei ole hingamispäeval lubatud teha!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Aga Jeesus ütles neile: „Kas te ei ole lugenud, mida tegi Taavet, kui temal ja ta meestel oli kõht tühi? ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ta läks Jumala kotta ning tema ja ta mehed sõid püha leiba, mida ei olnud lubatud kellelgi peale preestrite süüa. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kas te ei ole seadusest lugenud, et hingamispäeval rikkusid preestrid templis hingamispäeva, kuid neid ei peetud süüdlaseks? ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Aga mina ütlen teile, et siin on keegi, kes on tähtsam kui tempel! ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kui te teaksite, mida tähendab Pühakirjas see lõik: „Ma tahan halastust ja mitte ohvrit“, ei oleks te süütut inimest hukkamõistnud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sest inimese Poeg on hingamispäeva Issand.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Siis Jeesus lahkus ja läks nende sünagoogi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Seal oli üks halvatud käega mees. „Kas seadus lubab hingamispäeval terveks teha?“ küsisid nad temalt, otsides põhjust teda süüdistada. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","„Oletame, et sul on lammas ja see kukub hingamispäeval maa sees olevasse auku. Kas sa ei haara temast kinni ega tõmba teda välja?“ küsis Jeesus neilt. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","„Kas te ei arva, et inimene on palju enam väärt kui lammas? Nii et jah, hingamispäeval on lubatud head teha.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Siis ütles ta mehele: „Siruta oma käsi välja!“ Mees sirutas käe välja ja see oli terveks saanud, sama terve nagu teine käsi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kuid variserid läksid välja ja sepitsesid plaani, kuidas Jeesust tappa. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Seda teades Jeesus lahkus ja suur rahvahulk järgnes talle. Ta tegi kõik terveks, ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","kuid ütles neile, et nad ei räägiks teistele, kes ta on. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nii täitus see, mida prohvet Jesaja ütles: ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","„See on mu sulane, kelle ma valisin, see, keda ma armastan ja kes on mulle meelepärane. Ma panen tema peale oma Vaimu ja ta räägib võõramaalastele, mis on õige. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ta ei vaidle, ta ei hõika valjusti, ja keegi ei kuule tema häält tänavail. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ta ei murra viga saanud pilliroogu katki ega kustuta suitsevat tahti, kuni ta on tõestanud, et tema kohtuotsus on õige, ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ja võõramaalased panevad oma lootuse tema peale.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Siis toodi Jeesuse juurde mees, kes oli kurjadest vaimudest vaevatud ning pime ja tumm. Jeesus tegi ta terveks, nii et tumm mees suutis kõneleda ja näha. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kogu rahvas oli hämmastunud ja küsis: „Kas see võib tõesti olla Taaveti poeg?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Aga kui variserid sellest kuulsid, vastasid nad: „See mees suudab kurje vaime välja ajada ainult Peltsebuli, kurjade vaimude ülema abil!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Teades, mida nad mõtlevad, ütles Jeesus neile: „Iga kuningriik, mis on seesmiselt jagunenud, hävitatakse. Ei jää püsima ükski linn ega majapidamine, mis on seesmiselt jagunenud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kui Saatan ajab Saatana välja, siis on ta seesmiselt jagunenud; kuidas saaks tema kuningriik püsida? ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kui ma ajan kurje vaime välja Peltsebuli nimel, kelle nimel ajavad siis teie omad kurje vaime välja? Teie enda inimesed tõestavad, et te eksite! ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Aga kui ma ajan kurje vaime välja Jumala Vaimu väega, siis on Jumala riik teie juurde tulnud! ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kas saab minna tugeva mehe majja ja võtta tema vara, kui sa teda enne kinni ei seo? Kui sa ta kinni seod, siis saad võtta kõik tema majast. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kes ei ole minuga, on minu vastu, ja need, kes ei kogu koos minuga, teevad vastupidist: nad puistavad laiali. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Sellepärast ma ütlengi teile, et iga patt ja jumalateotus antakse teile andeks, välja arvatud Vaimu teotamine, mida ei anta andeks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Neile, kes ütlevad midagi inimese Poja vastu, antakse andeks, aga kes ütleb midagi Püha Vaimu vastu, sellele ei anta andeks, ei selles ega järgmises elus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Otsustage ära, kas puu on hea ja selle vili on hea või on puu halb ja selle vili on halb, sest puud tuntakse tema viljast. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Te rästikute sigitis, kuidas saate teie, kes olete kurjad, öelda midagi head? Sest teie suu kõneleb lihtsalt seda, millest mõtlemisega on mõistus hõivatud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Hea inimene toob välja head oma heast tagavarast ja halb inimene toob välja halba oma halvast tagavarast. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ma ütlen teile, inimesed peavad kohtupäeval aru andma igast hooletust sõnast, mida nad ütlevad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Sest see, mida räägid, mõistab sind kas õigeks või süüdi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Siis tulid tema juurde mõned vaimulikud õpetajad ja variserid ning ütlesid: „Õpetaja, me tahame, et sa näitaksid meile tunnustähte.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","„Kurjad inimesed, kes ei usu Jumalat, on need, kes otsivad tunnustähti. Ainus tunnustäht, mis neile antakse, on prohvet Joona tunnustäht,“ ütles Jeesus neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","„Samamoodi nagu Joona oli suure kala kõhus kolm päeva ja kolm ööd, lamab inimese Poeg maa sees kolm päeva ja kolm ööd. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Niineve elanikud tõusevad kohtus koos selle põlvkonnaga esile ja nad mõistavad selle põlvkonna hukka, sest nemad parandasid Joona sõnumi peale meelt, ja nagu näete, on siin keegi, kes on suurem kui Joona! ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Lõunamaa kuninganna tuuakse kohtu ette koos selle põlvkonnaga ning ta mõistab selle põlvkonna hukka, sest ta tuli maailma otstest kuulama Saalomoni tarkust, ja nagu näete, siin on keegi, kes on suurem kui Saalomon! ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Kui kuri vaim lahkub kellestki, uitab see mahajäetud paikades, et leida asupaika, ja ta ei leia kohta, kuhu jääda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Nii ta siis ütleb: „Ma lähen tagasi sinna, kust ma lahkusin,“ ja tagasi tulles leiab ta selle paiga olevat tühja, puhta ja korras. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Siis läheb ta ja toob kaasa seitse endast kurjemat vaimu ning nad tulevad ja hakkavad seal elama. Nii on inimese olukord hullem kui alguses. Nii saab olema selle kurja põlvkonnaga.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sel ajal kui ta rahvale kõneles, tulid tema ema ja vennad ning seisid väljas, soovides temaga rääkida. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Keegi tuli ja ütles talle: „Vaata, su ema ja vennad on väljas ja tahavad sinuga rääkida.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","„Kes on mu ema? Kes on mu vennad?“ küsis Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ta osutas oma jüngrite suunas ja ütles: „Vaadake, nemad on mu ema ja mu vennad! ");
INSERT INTO ekkpkp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sest see, kes täidab mu taevase Isa tahet, on mu vend, õde ja ema!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Hiljem samal päeval lahkus Jeesus majast ja istus järve äärde õpetama. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tema ümber kogunes nii palju inimesi, et ta pidi astuma paati ja sealt istudes õpetama, sellal kui kogu rahvas seisis rannas. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ta selgitas neile paljusid teemasid ja kasutas selgitamiseks lugusid. „Külvaja läks välja külvama,“ alustas ta. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","„Kui ta külvas, siis osa seemneid kukkus teerajale. Linnud tulid ja sõid need ära. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Teine osa seemneid kukus kivisele pinnale, kus ei olnud palju mulda ja kus nad kiiresti tärkasid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Päike tõusis kõrgemale ja kõrvetas neid ning nad närbusid, sest neil ei olnud juuri. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Osa seemneid kukkus ohakate sekka, mis kasvasid suureks ja lämmatasid vilja. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Siiski kukkus osa seemneid heale pinnasele. Nad andsid saaki − mõni sada, mõni kuuskümmend ja mõni kolmkümmend korda külvatust rohkem. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kellel on kõrvad, see kuulaku!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jüngrid tulid Jeesuse juurde ja küsisid temalt: „Miks sa kasutad rahvale rääkides mõistujutte?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","„Teil on eesõigus, et teile on avaldatud taevariigi saladusi, aga neile ei ole sellist arusaamist antud,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","„Neil, kel juba on, antakse veel, rohkem kui küllalt. Aga neilt, kellel ei ole, võetakse ära seegi, mis neil on. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Sellepärast kõnelen ma neile mõistujuttudega. Sest kuigi nad näevad, nad ei näe, ja kuigi nad kuulevad, nad ei kuule ega saa aru. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Neis täitub Jesaja prohvetikuulutus: „Kuigi te kuulete, ei saa te aru, ja kuigi te näete, te ei taipa. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Neil on põikpäine hoiak, nad ei taha kuulata ja nad on oma silmad sulgenud. Kui nad ei oleks seda teinud, siis ehk suudaksid nad oma silmadega näha, kõrvadega kuulda ja mõistusega aru saada. Siis võiksid nad minu juurde tagasi tulla ja ma teeksin nad terveks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Teie silmad on õnnistatud, sest nad näevad. Ka teie kõrvad on õnnistatud, sest nad kuulevad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ma ütlen teile, paljud prohvetid ja head inimesed on igatsenud näha seda, mida teie näete, kuid ei näinud seda. Nad igatsesid kuulda seda, mida teie kuulete, kuid ei kuulnud seda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Niisiis, kuulake külvaja lugu. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kui inimesed kuulevad kuningriigi sõnumit ega mõista seda, siis tuleb vanakuri ja kisub välja selle, mis neisse külvati. See juhtub teeraja peale külvatud seemnetega. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kivisele pinnasele külvatud seemned on nagu inimesed, kes kuulevad sõnumit ja võtavad selle rõõmsalt kohe vastu. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nad peavad mõnda aega vastu, aga kuna neil ei ole juuri, siis langevad nad probleemide ja raskuste tekkides kiiresti. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ohakate sekka külvatud seemned on nagu inimesed, kes kuulevad sõnumit, kuid elu mured ja raha ahvatlus lämmatavad sõnumi, nii et nad jäävad viljatuks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Heale pinnasele külvatud seemned on inimesed, kes kuulevad sõnumit, mõistavad seda ja annavad hea saagi − mõni sada, mõni kuuskümmend ja mõni kolmkümmend korda rohkem kui külvati.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Siis jutustas ta neile veel ühe mõistujutu: „Taevariik on nagu põllumees, kes külvas oma põllule head seemet. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Aga sel ajal, kui tema töölised magasid, tuli vaenlane ja külvas nisu hulka umbrohuseemneid. Seejärel ta lahkus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kui siis nisu kasvas ja hakkas viljapäid looma, kasvas ka umbrohi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Põllumehe töölised tulid ja küsisid temalt: „Isand, kas sa ei külvanud oma põllule head seemet? Kust tuli see umbrohi?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","„Seda tegi keegi vaenlane,“ vastas peremees. „Kas tahad, et me lähme ja kisume umbrohu välja?“ küsisid töölised. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","„Ei,“ vastas isand, „sest kui tõmbate välja umbrohu, võite ka nisu välja juurida. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Las mõlemad kasvavad lõikuseni ja siis lõikuse ajal käsin ma saagikoristajatel kõigepealt koguda kokku umbrohu, siduda kimpudesse ja ära põletada ning seejärel koguda kokku nisu ja panna see aita.““ ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ta tõi neile veel ühe näite: „Taevariik on nagu sinepiseeme, mille põllumees külvas oma põllule. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kuigi see on kõige väiksem seeme, kasvab see suuremaks kui teised taimed. Õigupoolest kasvab see puuks, mis on nii suur, et linnud saavad selle okstel istuda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ta rääkis neile veel ühe mõistujutu: „Taevariik on nagu juuretis, mille naine segas suure koguse jahu sekka, kuni kogu tainas hakkas kerkima.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jeesus selgitas neid asju rahvale mõistujuttude abil. Õigupoolest ei rääkinud ta neile midagi ilma jutustusteta. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Sellega täitusid prohveti sõnad: „Ma kõnelen jutustuste abil ja selgitan asju, mis on maailma loomisest peale varjatud olnud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Siis lahkus ta rahva juurest ja läks majja. Jüngrid tulid tema juurde ja küsisid talt: „Selgita palun meile jutustust umbrohust põllul.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","„See, kes külvab head seemet, on inimese Poeg,“ selgitas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","„Põld on maailm. Hea seeme on kuningriigi lapsed. Umbrohu seeme on vanakurja lapsed. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Vaenlane, kes umbrohuseemneid külvas, on kurat. Lõikus on maailma lõpp. Saagikoristajad on inglid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Just nagu umbrohi kogutakse kokku ja põletatakse ära, on ka maailma lõpus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Inimese Poeg saadab oma inglid välja ja nad koguvad kokku kõik patuse ja kõik, kes kurja teevad, ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ning heidavad nad leegitsevasse sulatusahju, kus on nutmine ja hammaste kiristamine. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Säravad need, kes elavad õigesti, nagu päike oma Isa kuningriigis. Kellel kõrvad on, see kuulaku! ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Taevariik on nagu põllusse peidetud aare. Üks mees leidis selle, mattis uuesti maha ning läks siis rõõmsalt ja müüs ära kõik, mis tal oli, ja ostis selle põllu. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Taevariik on ka nagu häid pärleid otsiv kaupmees. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kui ta leidis kõige kallima pärli, läks ja müüs ta ära kõik, mis tal oli, ja ostis selle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Või taas, taevariik on nagu kalavõrk, mis heideti merre ja mis püüdis sisse igasuguseid kalu. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kui võrk sai täis, veeti see kaldale. Head kalad pandi korvidesse, aga halvad visati minema. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Niimoodi on ka siis, kui tuleb maailma lõpp. Inglid lähevad välja ja eraldavad halvad inimesed headest ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ning heidavad nad leegitsevasse sulatusahju, kus on nutmine ja hammaste kiristamine. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kas te nüüd saate kõigest aru?“ „Jah,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","„Iga vaimulik õpetaja, kes on taevariigi kohta õppinud, on nagu majaomanik, kes toob oma varakambrist välja uusi ja vanu aardeid,“ ütles Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pärast seda kui Jeesus lõpetas nende jutustuste rääkimise, ta lahkus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ta läks tagasi oma kodulinna ja õpetas seal sünagoogis. Inimesed olid hämmastunud ja küsisid: „Kust ta saab oma tarkuse ja imeteod? ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kas ta pole mitte puusepa poeg? Kas tema ema ei ole Maarja ning tema vennad Jaakobus, Joosep, Siimon ja Juudas? ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kas tema õed ei ela siin meie keskel? Kust saab siis tema selle kõik?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ja nad keeldusid temasse uskumast. „Prohvetit austatakse kõikjal, välja arvatud oma kodumaal ja oma perekonnas,“ ütles Jeesus neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kuna nad ei uskunud temasse, ei teinud ta seal palju imesid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sel ajal kuulis tetrarh Heroodes, mida Jeesus teeb, ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ning ta ütles oma sulastele: „Ta on ilmselt surnuist üles tõusnud Ristija Johannes, sellepärast on tal sellised võimed!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Heroodes oli Johannese vahistanud ning lasknud ta ahelates vangi panna oma venna Filippuse naise Heroodiase pärast. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Sest Johannes oli talle öelnud: „Temaga abiellumine ei ole seaduspärane.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heroodes tahtis Johannest tappa, kuid ta kartis rahva reaktsiooni, sest rahvas pidas Johannest prohvetiks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Aga Heroodese sünnipäeval tantsis Heroodiase tütar peol ja Heroodes oli selle üle rõõmus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ta tõotas vandega anda neiule, mida iganes too tahab. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ema õhutusel ütles tütar: „Anna mulle Ristija Johannese pea siin taldrikul.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Siis kuningas kahetses antud lubadust, kuid õhtusöögikülaliste ees antud vannete pärast andis ta käsu nii teha. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Käsk anti edasi ja Johannesel võeti vanglas pea maha. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Johannese pea toodi taldrikul ja anti neiule, kes viis selle oma emale. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Johannese jüngrid tulid ja võtsid tema keha ning matsid maha. Seejärel nad läksid ja rääkisid sellest Jeesusele. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kui Jeesus kuulis uudist, läks ta paadiga vaiksesse kohta, et omapead olla, aga kui rahvahulk sai teada, kus ta on, järgnesid nad linnadest talle jalgsi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kui Jeesus astus paadist välja ja nägi suurt rahvahulka, täitis teda kaastunne nende vastu ja ta tegi nende haiged terveks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kui õhtu saabus, läksid jüngrid tema juurde ja ütlesid: „See paik on kõikjalt kaugel ja aeg on hiline. Saada rahvas minema, et nad saaksid minna küladesse ja endale toitu osta.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Aga Jeesus ütles neile: „Neil ei ole vaja lahkuda. Andke teie neile midagi süüa!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","„Kõik, mis meil on, on viis leiba ja paar kala,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","„Tooge need mulle,“ ütles Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ta käskis rahval murule maha istuda. Siis võttis ta viis leiba ja kaks kala, vaatas üles taeva poole ja õnnistas neid. Seejärel murdis ta leivad tükkideks ja andis jüngritele ning jüngrid andsid leiva rahvale. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kõik sõid, kuni kõht sai täis. Pärast kogusid nad kokku jääke, mida oli kaksteist korvitäit. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Umbes viis tuhat meest sõi seda toitu, peale selle veel naised ja lapsed. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kohe pärast seda sundis ta jüngrid paati istuma ja teisele poole järve tagasi minema, samal ajal saatis ta ise rahva minema. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kui ta oli rahva ära saatnud, läks ta mägedesse palvetama. Saabus õhtu ja ta oli seal ihuüksinda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nüüdseks oli paat kaldast kaugel ning lained peksid seda, sest tuul puhus neile vastu. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Umbes kella kolme ajal öösel jõudis Jeesus neile mere peal kõndides järele. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kui jüngrid nägid teda merel kõndimas, kohkusid nad väga. Nad karjusid hirmunult: „See on tont!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Aga kohe ütles Jeesus neile: „Ärge kartke, see olen mina! Ärge tundke hirmu!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","„Issand, kui see oled tõesti sina, siis käsi mul tulla sinu juurde ja vee peal kõndida,“ vastas Peetrus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","„Tule siis,“ ütles Jeesus. Peetrus astus paadist välja ja kõndis mööda vett Jeesuse poole. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Aga kui ta nägi, kui tugev oli tuul, hakkas ta kartma ja vette vajuma. „Issand! Päästa mind!“ karjatas ta. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kohe sirutas Jeesus käe, haaras temast kinni ja ütles: „Sul on nii väike usk minusse. Miks sa kahtlesid?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kui nad paati astusid, vaibus tuul, ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ja need, kes paadis olid, kummardasid teda, öeldes: „Sa oled tõesti Jumala Poeg!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pärast järve ületamist jõudis nad Genneesaretti. ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kui sealsed inimesed mõistsid, et Jeesus on saabunud, kuulutasid nad seda kogu piirkonnas. Nad tõid tema juurde kõik, kes olid haiged, ");
INSERT INTO ekkpkp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ja anusid, et ta lubaks haigetel vaid oma kuueserva puudutada. Kõik, kes teda puudutasid, said terveks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Siis tulid mõned variserid ja vaimulikud õpetajad Jeruusalemmast Jeesuse juurde ja küsisid temalt: ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","„Miks rikuvad sinu jüngrid meie esiisade traditsiooni ega pese enne söömist käsi?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","„Miks rikute teie oma traditsiooni pärast Jumala käsku?“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","„Sest Jumal ütles: „Austa oma isa ja ema“ ja „Kes oma isa või ema neab, tuleb surma mõista“. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Aga teie ütlete, et kui keegi ütleb oma isale või emale: „Mida iganes sa lootsid minult saada, on nüüd and Jumalale“, siis ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ei pea nad oma isa austama. Nii olete tühistanud Jumala sõna oma traditsiooni tõttu. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Te silmakirjatsejad! Kui hästi kirjeldas teid Jesaja, kui ta prohvetlikult kuulutas: ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","„Need inimesed ütlevad, et nad austavad mind, kuid oma mõistuses nad ei hooli minust. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nende jumalateenistus on mõttetu. See, mida nad õpetavad, on lihtsalt inimeste väljamõeldud nõudmised.““ ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ta kutsus rahva enda juurde ja rääkis neile: „Kuulake ja mõistke seda: ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","see, mis läheb suust sisse, ei rüveta teid. See, mis tuleb suust välja, rüvetab teid.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Siis tulid Jeesuse jüngrid tema juurde ja ütlesid: „Sa ikka mõistad ju, et sinu sõnad solvasid varisere.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","„Iga taim, mida minu taevane Isa ei ole istutanud, juuritakse välja,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","„Unustage nad ära, nad on pimedad teejuhid. Kui pime juhib teist pimedat, siis kukuvad nad mõlemad auku.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Siis küsis Peetrus: „Räägi meile palun, mida sa selle illustratsiooniga mõtled.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","„Kas te ei ole veel sellest aru saanud?“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","„Kas te ei mõista, et see, mis läheb suu kaudu sisse, läheb seejärel läbi kõhu ja lahkub ihust jäätmetena? ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Aga mis tuleb suu kaudu välja, tuleb mõistusest ja see on, mis teid rüvetab. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Sest mõistusest tuleb kurje mõtteid, mõrva, abielurikkumist, seksuaalset ebamoraalsust, vargust, valetunnistust ja jumalateotust ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ning need on, mis teid rüvetavad. Pesemata kätega söömine ei rüveta teid.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jeesus lahkus ja läks Tüürose ja Siidoni aladele. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Üks selle piirkonna kaananlanna tuli karjudes: „Issand, Taaveti poeg! Halasta minu peale, sest mu tütar kannatab hirmsasti, sest teda vaevab kuri vaim!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Aga Jeesus ei vastanud üldse. Tema jüngrid tulid ta juurde ja ütlesid: „Käsi tal lõpetada meie järel käimine. Tema karjumine on tõesti häiriv!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","„Mind saadeti üksnes Iisraeli soo kadunud lammaste juurde,“ ütles Jeesus naisele. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kuid naine tuli ja põlvitas tema ette ning ütles: „Issand, palun aita mind!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","„Ei ole õige võtta laste toit ja visata see koertele,“ lausus Jeesus talle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","„Jah, Issand, aga isegi koertel lubatakse süüa purukesi, mis nende isanda laualt pudenevad,“ vastas naine. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","„Sul on suur usk minusse,“ kostis Jeesus. „Sinu soov on täidetud!“ Ja naise tütar sai jalamaid terveks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jeesus läks tagasi, Galilea merest mööda. Ta suundus lähedal asuvatesse mägedesse, kus istus maha. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tohutu rahvamass tuli tema juurde; nad tõid kaasa neid, kes olid lombakad, pimedad, vigased, tummad ja palju neid, kes olid haiged. Rahvas pani nad tema jalge ette maha ja ta tegi nad terveks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kõik olid hämmastunud, kui nägid, mis juhtus: kurdid suutsid rääkida, vigased said terveks, jalutud suutsid kõndida ja pimedad näha. Nad ülistasid Iisraeli Jumalat. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jeesus kutsus oma jüngrid enda juurde ja ütles neile: „Mul on neist kõigist väga kahju, sest nad on olnud nüüd minu juures kolm päeva ja neil ei ole midagi süüa. Ma ei taha neid näljasena minema saata, et nad koduteel ära ei nõrkeks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","„Kust me leiaks siin tühermaal piisavalt leiba, et nii suurt rahvahulka ära toita?“ pärisid jüngrid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","„Kui palju leibu teil on?“ küsis Jeesus. „Seitse, ja mõned väiksed kalad,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jeesus käskis rahval maha istuda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ta võttis seitse leiba ja kalad ning pärast toidu õnnistamist tegi selle tükkideks ja andis jüngritele ja jüngrid andsid selle rahvale. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kõik sõid, kuni kõht sai täis, ja nad kogusid jäägid kokku, neid sai seitse korvitäit. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Neli tuhat meest sõi toitu, peale selle naised ja lapsed. ");
INSERT INTO ekkpkp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Seejärel saatis ta rahva minema, astus paati ja läks Magadani piirkonda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Variserid ja saduserid tulid Jeesust proovile panema, nõudes, et ta näitaks neile tunnustähte taevast. ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jeesus vastas: „Õhtul te ütlete: „Homme tuleb ilus päev, sest taevas punab,“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","samas kui hommikul ütlete: „Täna tuleb halb ilm, sest taevas punab ja on pilves.“ Te oskate taeva järgi ilma ennustada, kuid ei tunne ära ajamärke! ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kurjad inimesed, kes ei usu Jumalasse, on need, kes otsivad imelisi tunnustähti, ja neile ei anta ühtki tunnustähte peale Joona tunnustähe.“ Ta lahkus neist ja läks ära. ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Järve teisele kaldale minnes unustasid jüngrid leiba kaasa võtta. ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","„Hoiduge variseride ja saduseride juuretise eest,“ ütles Jeesus neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jüngrid hakkasid isekeskis vaidlema. „Ta ütleb seda sellepärast, et me ei võtnud leiba kaasa,“ järeldasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jeesus teadis, mida nad räägivad, ning ütles: „Teie usk minusse on nii väike! Miks te vaidlete isekeskis sellepärast, et teil ei ole leiba? ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kas te ei ole ikka veel aru saanud? Kas te ei mäleta viit leiba, millest said söönuks viis tuhat? Mitu korvitäit järelejäänut te kokku kogusite? ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ja kuidas oli seitsme leivaga, millest sai söönuks neli tuhat? Mitu korvitäit järelejäänut te kokku kogusite? ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kas te ei ole ikka veel aru saanud, et ma ei rääkinud teile leivast? Hoiduge variseride ja saduseride juuretise eest!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Siis nad mõistsid, et ta ei hoiatanud neid leivajuuretise eest, vaid variseride ja saduseride õpetuste eest. ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kui Jeesus saabus Filippuse Kaisarea aladele, küsis ta jüngritelt: „Kelle ütlevad inimesed inimese Poja olevat?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","„Mõni ütleb, et Ristija Johannes, mõni, et Eelija, ja veel teised ütlevad, et Jeremija või üks teistest prohvetitest,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","„Aga teie?“ küsis ta neilt. „Kes ma teie arvates olen?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","„Sina oled Messias, elava Jumala Poeg,“ vastas Siimon Peetrus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","„Sa oled tõesti õnnistatud, Siimon, Johannese poeg,“ ütles Jeesus talle. „Sest seda ei ilmutanud sulle inimlik liha ja veri, vaid minu Isa, kes on taevas. ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma ütlen sulle, et sina oled Peetrus. Sellele kaljule ma rajan oma koguduse ning surmaväed ei võida seda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ma annan sulle taevariigi võtmed, ja mida iganes sa maa peal keelad, on keelatud taevas, ja mida iganes sa maa peal lubad, on lubatud taevas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Siis ta hoiatas oma jüngreid, et nad ei räägiks kellelegi, et ta on Messias. ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Sellest ajast peale hakkas Jeesus oma jüngritele selgitama, et ta peab minema Jeruusalemma ning et tal tuleb kohutavalt kannatada vanemate, ülempreestrite ja vaimulike õpetajate käes ning ta tapetaks, kuid ta tõuseb kolmandal päeval surnuist üles. ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Peetrus viis Jeesuse kõrvale ning hakkas talle rääkima, et ta ei tohiks nii kõneleda. „Jumal hoidku, Issand, et seda kunagi sinuga ei juhtuks!“ ütles ta. ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jeesus pöördus Peetruse poole ja ütles talle: „Mine minust eemale, Saatan! Sa oled lõks selleks, et ma komistaksin, sest sa mõtled inimese kombel, mitte nii, nagu mõtleb Jumal!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Siis rääkis Jeesus oma jüngritele: „Kui te tahate olla minu järelkäijad, peate ennast salgama, oma risti võtma ja mind järgima. ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sest kui tahate oma elu päästa, siis kaotate selle, ja kui kaotate oma elu minu pärast, säästate selle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mis kasu on teil sellest, kui võidate endale kogu maailma, kuid kaotate oma elu? Mida on teil anda vahetuskaubaks oma elu eest? ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Sest inimese Poeg läheb oma Isa ja tema inglite auhiilgusesse. Siis annab ta igaühele, mille nad on oma tegevusega ära teeninud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ma ütlen teile tõtt: siin seisavad mõned, kes ei sure enne, kui nad näevad inimese Poja tema kuningriigis tulevat.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kuue päeva pärast võttis Jeesus Peetruse, Jaakobuse ja tema venna Johannese endaga kaasa ja nad läksid kõrgele mäele, et omaette olla. ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Teda muudeti nende silme all. Tema nägu säras nägu päike. Tema riided muutusid valgeks nagu valgus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Siis äkitselt ilmusid nende ette Mooses ja Eelija ning vestlesid Jeesusega. ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peetrus hakkas rääkima ja ütles Jeesusele: „Issand, siin on tõesti hea olla. Kui tahad, teen kolm varjualust − ühe sulle, ühe Moosesele ja ühe Eelijale.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Sel ajal kui ta veel rääkis, tuli hiilgav pilv ja kattis nad. Pilvest kostis hääl, mis ütles: „See on minu poeg, keda ma armastan ja kellest mul on hea meel. Kuulake teda!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kui jüngrid seda kuulsid, langesid nad näoli maha ja olid äärmiselt kohkunud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jeesus läks nende juurde ja puudutas neid. „Tõuske üles,“ ütles ta neile. „Ärge kartke.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kui nad üles vaatasid, ei näinud nad kedagi peale Jeesuse. ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kui nad mäelt alla läksid, andis Jeesus neile ranged juhised. „Ärge rääkige kellelegi, mida te nägite, enne kui inimese Poeg on surnuist üles tõusnud,“ ütles ta neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","„Miks siis vaimulikud õpetajad ütlevad, et kõigepealt peab tulema Eelija?“ küsisid tema jüngrid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","„Tõsi on, et Eelija tuleb kõike korda seadma,“ vastas Jeesus, ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","„aga ma ütlen teile, et Eelija on juba tulnud ja ometi ei tundud inimesed ära, kes ta on. Nad tegid temale seda, mida iganes tahtsid. Samamoodi kannatab ka inimese Poeg nende käte läbi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Siis jüngrid mõistsid, et Jeesus viitas Ristija Johannesele. ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kui nad lähenesid rahvahulgale, tuli üks mees Jeesuse juurde ja põlvitas tema ette. ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","„Issand, palun halasta mu poja peale,“ ütles ta. „Ta kaotab mõistuse ja kannatab kohutavate krambihoogude all, mis heidavad teda sageli tulle või vette. ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ma tõin ta sinu jüngrite juurde, aga nad ei suutnud teda terveks teha.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","„Te, inimesed, keeldute minusse uskumast ja olete nii rikutud!“ vastas Jeesus. „Kui kauaks pean ma siia teie juurde jääma? Kui kaua ma pean teid taluma? Too ta minu juurde!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jeesus astus kurjale vaimule vastu ja see lahkus poisist ning poiss sai otsekohe terveks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Hiljem tulid jüngrid omaette olles Jeesuse juurde ja küsisid talt: „Miks ei suutnud meie teda välja ajada?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","„Sest teil pole piisavalt usku,“ ütles Jeesus neile. „Ma ütlen teile, isegi kui teie usk oleks sama pisike kui sinepiseeme, võiksite öelda sellele mäele: „Mine siit teise kohta!“ ja see läheks. Miski ei oleks siis teie jaoks võimatu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kui nad koos läbi Galilea kõndisid, rääkis Jeesus neile: „Inimese poeg reedetakse ja inimesed saavad tema üle võimust. ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nad tapavad ta, kuid kolmandal päeval tõuseb ta jälle üles.“ Jüngrid said väga kurvaks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kui nad jõudsid Kapernauma, siis tulid need, kes vastutasid pooleseeklise templimaksu kogumise eest, Peetruse juurde ja küsisid temalt: „Eks ole, sinu õpetaja tasub pooleseeklise maksu?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","„Jah, muidugi,“ vastas Peetrus. Kui ta jõudis tagasi sinna, kus nad peatusid, ennetas Jeesus küsimust. „Mis sa arvad, Siimon?“ küsis Jeesus temalt. „Kas selle maailma kuningad koguvad makse ja koormisi oma poegadelt või teistelt?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","„Teistelt,“ vastas Peetrus. Niisiis ütles Jeesus talle: „Sel juhul on pojad vabastatud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Aga et mitte kedagi pahandada, mine järve äärde ja viska õngenöör konksuga sisse. Tõmba välja esimene kala, mis otsa jääb, ja kui sa tema suu avad, siis leiad sealt stateeri. Võta münt ja anna see neile minu ja sinu eest.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Umbes sel ajal tulid jüngrid Jeesuse juurde ja küsisid: „Kes on suurim taevariigis?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jeesus hõikas ligi ühe väikse lapse. Ta lasi lapsel nende ette seista. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","„Ma ütlen teile tõtt: kui te ei muuda oma mõtteviisi ega saa väikeste laste sarnaseks, ei pääse te taevariiki,“ ütles ta neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","„Aga kes iganes end alandab ja saab selle väikse lapse sarnaseks, on suurim taevariigis. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kes iganes võtab seesuguse väikse lapse vastu minu nimel, võtab vastu minu. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Aga kes iganes suunab patustama ühe neist väikestest, kes minusse usuvad, sellele oleks parem, kui tema kaela seotaks suur veskikivi ja ta uputataks mere sügavustesse. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Missugune suur õnnetus on tulemas maailmale kõigi kiusatuste tõttu patustada! Kiusatused tulevad küll, kuid häda inimesele, kelle läbi kiusatus tuleb! ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kui su käsi või jalg sunnib sind patustama, siis lõika see maha ja viska minema. Parem on minna vigase või lombakana igavesse ellu kui omada kaht kätt või kaht jalga ja saada igavesse tulle heidetud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kui su silm sunnib sind patustama, siis tõmba see välja ja viska minema. Parem on minna ühe silmaga igavesse ellu kui omada kaht silma ja saada igavesse tulle heidetud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Olge hoolsad, et te ei põlgaks neid väikesi. Ma ütlen teile, et inglid taevas on alati mu taevase Isaga koos. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mida te sellest arvate? Kui ühel mehel on sada lammast ja üks neist läheb kaotsi, kas ta ei jäta siis üheksakümmend üheksa kingule ega lähe otsima seda üht, kes on kadunud? ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ja kui ta tema leiab, ma ütlen teile, ta tunneb selle lamba üle rohkem rõõmu kui üheksakümne üheksa üle, kes ei läinud kaduma. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Samamoodi ei taha mu taevane Isa, et ükski neist pisikestest kaduma läheks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Kui vend sinu vastu patustab, siis mine ja juhi tema tähelepanu eksimusele, ainult nelja silma all. Kui ta sind kuulab, oled sa oma venna enda poole võitnud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Aga kui ta ei kuula, siis võta endaga veel üks või kaks inimest, nii et tõde saaks kinnitada kaks või kolm tunnistajat. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aga kui ta ikka keeldub kuulamast, siis räägi kogudusele. Kui ta keeldub ka kogudust kuulamast, siis kohtle teda kui võõramaalast ja maksukogujat. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ma ütlen teile tõtt: mida iganes te maa peal keelate, on ka taevas keelatud, ja mida iganes te maa peal lubate, on lubatud ka taevas. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ma ütlen teile ka, et kui kaks teist on siin maa peal ühel nõul millegi pärast palvetamas, siis mu taevane Isa teeb seda teie heaks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Sest kus kaks või kolm on koos minu nimel, seal olen mina nendega koos.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Peetrus tuli Jeesuse juurde ja küsis temalt: „Mitu korda peaksin ma oma vennale andestama, kui ta minu vastu pattu teeb? Kas seitse korda?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","„Ei, mitte seitse korda. Ma ütlen, seitsekümmend korda seitse korda!“ vastas Jeesus talle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","„Sellepärast on taevariik kuninga sarnane, kes tahtis ajada arvepidamise korda sulastega, kes talle raha võlgu olid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kui ta hakkas arvepidamist uurima, toodi tema ette üks sulane, kes oli talle võlgu kümme tuhat talenti. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kuna tal ei olnud tasumiseks raha, andis isand korralduse müüa ära sulane koos naise, laste ja kogu omandiga, et võlg saaks tasutud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Sulane langes põlvedele ja ütles oma isandale: „Palun ole minuga kannatlik! Ma maksan kõik tagasi!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Isandal hakkas sulasest kahju, ta lasi sulase vabaks ja tühistas võla. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Aga kui seesama sulane läks välja, leidis ta oma kaassulase, kes oli talle võlgu kõigest sada denaari. Ta haaras tal kõrist kinni ja kägistas teda ning ütles: „Maksa tagasi, mis sa mulle võlgu oled!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tema kaassulane langes mehe jalge ette maha ja anus teda: „Palun ole minuga kannatlik! Ma maksan sulle tagasi!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Aga mees keeldus ning läks ja viskas oma kaassulase vanglasse, kuniks ta oma võla ära tasub. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kui teised sulased toimunut nägid, olid nad rabatud ja vapustatud. Nad läksid ja rääkisid isandale kõigest, mis oli juhtunud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Siis kutsus isand mehe tagasi ja ütles talle: „Sina kuri sulane! Ma kustutasin kogu su võla, sest sa anusid mind. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kas ei oleks pidanud sa halastama oma kaassulase peale samamoodi, nagu mina sinu peale halastasin?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tema isand sai pahaseks ja andis ta vangivalvurite kätte, kuni ta kogu oma võla ära tasub. ");
INSERT INTO ekkpkp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nii toimib minu taevane Isa kõigi teiega, kui te siiralt oma vendadele andeks ei anna.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kui Jeesus lõpetas kõnelemise, lahkus ta Galileast, ning läks Jordani jõe taha Juuda aladele. ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Suured rahvahulgad järgisid teda ja ta tegi terveks need, kes rahva seast haiged olid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mõned variserid tulid teda proovile panema. „Kas mehel on lubatud oma naisest mingil põhjusel lahutada?“ küsisid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jeesus vastas: „Kas te ei ole lugenud, et Jumal, kes lõi alguses inimesed, tegi nad meheks ja naiseks? ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ta ütles: „Sel põhjusel jätab mees maha oma isa ja ema ning ühineb oma naisega ja nemad kaks saavad üheks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nüüd ei ole nad enam kaks, vaid üks. Keegi ei tohi eraldada seda, mille Jumal on liitnud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","„Miks siis Mooses andis seaduse, et mees võib oma naisest lahutada, kui annab talle lahutustunnistuse, ja ta minema saata?“ küsisid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","„Teie kalgi südame pärast lubas Mooses teil oma naisest lahutada, aga alguses ei olnud see nii,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","„Ma ütlen teile, igaüks, kes lahutab oma naisest muidu kui seksuaalse ebamoraalsuse tõttu ja abiellub siis teise naisega, rikub abielu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","„Kui olukord mehe ja naise vahel on selline, siis on parem mitte abielluda!“ ütlesid ta jüngrid talle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","„Kõik ei suuda seda õpetust vastu võtta, vaid ainult need, kellele see on antud,“ lausus Jeesus neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","„Mõni on sündinud eunuhh, mõne on eunuhhiks teinud inimesed ning mõni otsustab olla eunuhh taevariigi pärast. Need, kes suudavad selle vastu võtta, peaks seda tegema.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Inimesed tõid väikesed lapsed tema juurde, et ta neid õnnistaks ja nende eest palvetaks. Kuid jüngrid keelasid neid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Aga Jeesus ütles: „Laske lastel minu juurde tulla. Ärge takistage neid. Taevariik kuulub neile, kes on nendesarnased!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ta pani oma käed nende peale ja õnnistas neid ning siis ta lahkus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Üks mees tuli Jeesuse juurde ja küsis temalt: „Õpetaja, mida head ma pean tegema, et igavest elu saada?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","„Miks sa küsid minult, mis on hea?“ vastas Jeesus. „On ainult üks, kes on hea. Aga kui tahad igavest elu saada, siis pea käske.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","„Missuguseid?“ küsis mees temalt. „Ära tapa, ära riku abielu, ära varasta, ära anna valetunnistust, ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","austa oma isa ja ema ning armasta oma kaasinimest nagu iseennast,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","„Olen kõiki neid käske pidanud,“ lausus noormees. „Mida ma veel pean tegema?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jeesus kostis talle: „Kui sa tahad täiuslik olla, siis mine ja müü oma vara ära, anna raha vaestele ja sul on aare taevas. Siis tule ja järgi mind.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kui noormees kuulis Jeesuse vastust, läks ta väga kurvalt ära, sest tal oli palju vara. ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","„Ma räägin teile tõtt,“ ütles Jeesus oma jüngritele, „rikastel inimestel on raske taevariiki siseneda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ma ütlen teile ka seda: lihtsam on kaamelil läbi nõelsilma minna, kui rikkal inimesel Jumala riiki siseneda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kui jüngrid seda kuulsid, olid nad väga üllatunud ja küsisid: „Kes võib siis päästetud saada?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jeesus vaatas neid ja ütles: „Inimlikust vaatenurgast on see võimatu, aga Jumalaga koos on kõik võimalik.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Peetrus vastas talle: „Vaata, me oleme jätnud kõik maha ja sind järginud. Mis tasu me saame?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jeesus vastas: „Ma ütlen teile tõtt: kui kõik on uueks loodud ja inimese Poeg istub oma hiilgaval troonil, siis teie, kes te olete mind järginud, istute ka kaheteistkümnel troonil ning mõistate kohut Iisraeli kaheteistkümne suguharu üle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kõik need, kes on minu pärast jätnud maha oma kodu, vennad, õed, isa, ema, lapsed ja põllud, saavad sada korda rohkem tagasi ja igavese elu. ");
INSERT INTO ekkpkp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Sest paljud, kes on esimesed, jäävad viimasteks, ja paljud, kes on viimased, saavad esimesteks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Sest taevariik on nagu maaomanik, kes läks varahommikul välja, et palgata töölisi oma viinamarjaistandusse. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ta leppis töölistega kokku, et tasub päeva eest ühe denaari, ning saatis nad viinapuuaeda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Umbes kella üheksa ajal hommikul läks ta välja ja nägi teisi ilma tööta turuplatsil seismas. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","„Minge ka teie viinamarjaistandusse tööle ja ma tasun teile, mis on sobiv,“ ütles ta neile. Nii läksid ka nemad tööle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Keskpäeva ajal ja kella kolme ajal pärastlõunal läks ta välja ja toimis samamoodi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kella viie ajal pärastlõunal läks ta välja ja leidis sealt veel inimesi seismas. „Miks te seisate siin kogu päeva ega tee midagi?“ küsis ta neilt. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","„Sest keegi ei ole meid palganud,“ vastasid nad. „Minge ka viinamarjaistandusse tööle,“ ütles ta neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kui saabus õhtu, ütles viinamarjaistanduse omanik töödejuhatajale: „Kutsu töötajad ja maksa neile palk. Alusta töölistest, kes palgati viimasena, ja seejärel liigu edasi nendeni, kes palgati esimesena.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Kui tulid need, kes oldi palgatud kella viie ajal pärastlõunal, said nad igaüks ühe denaari. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kui siis tulid need, kes olid esimesena palgatud, arvasid nad, et nemad saavad rohkem, kuid ka nemad said ühe denaari. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kui nad said palga kätte, läksid nad omanikule kaebama. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","„Need, kes viimasena palgati, töötasid ainult tund aega ja sa maksid neile sama palga nagu meile, kes me töötasime kogu päeva kõrvetavas kuumuses,“ nurisesid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Omanik vastas ühele neist: „Mu sõber, ma ei ole sind ebaõiglaselt kohelnud. Kas sa ei leppinud minuga kokku, et töötad ühe denaari eest? ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Võta oma palk ja mine. Ma tahan maksta viimasena palgatutele sama palju palka kui sulle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kas ma ei või otsustada teha oma rahaga seda, mida tahan? Miks sa heidad mulle kurje pilke sellepärast, et ma tahan teha head?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nii saavad viimased esimesteks ja esimesed viimasteks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Teel Jeruusalemma viis Jeesus kaksteist jüngrit kõndimise ajal kõrvale ja rääkis neile: ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","„Vaadake, me läheme Jeruusalemma ja inimese Poeg müüakse maha ülempreestritele ja vaimulikele õpetajatele. Nad mõistavad ta surma ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ning annavad ta võõramaalaste kätte ja teda pilgatakse, piitsutatakse ja lüüakse risti. Kuid kolmandal päeval äratatakse ta surnuist üles.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Siis tuli Sebedeuse poegade ema koos oma kahe pojaga Jeesuse juurde. Ta põlvitas Jeesuse ette, et talle palve esitada. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","„Mis see on, mida sa minult palud?“ küsis Jeesus temalt. „Palun määra nii, et mu pojad istuksid sinu kuningriigis sinu kõrval, üks sinu paremal ja teine sinu vasakul käel,“ palus naine. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","„Te ei tea, mida te palute,“ ütles Jeesus neile. „Kas te olete võimelised jooma karikast, millest mina jooma hakkan?“ „Jah, me oleme võimelised seda tegema,“ vastasid nad talle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","„Te joote kindlasti minu karikast,“ kostis ta neile, „kuid eesõigus minu paremal või vasakul käel istuda, ei ole minu anda. Minu Isa on see, kes seda otsustab.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kui ülejäänud kümme jüngrit kuulsid, mida nad olid palunud, olid nad kahe venna peale pahased. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jeesus kutsus nad kokku ja rääkis neile: „Te teate, et võõramaised valitsejad valitsevad oma alamate üle ja võimukad juhid rõhuvad neid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Teie puhul ei tohi see nii olla. Kes iganes teist soovib olla kõige tähtsam, see olgu teie teenija. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kes iganes teist soovib olla tähtsaim, olgu nagu ori. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Samamoodi ei tulnud inimese Poeg, et teda teenitaks, vaid ta tuli teenima ja andma oma elu lunarahaks paljude eest.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kui nad Jeerikost lahkusid, järgis Jeesust tohutu rahvahulk. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tee ääres istus kaks pimedat meest. Kui nad kuulsid, et Jeesus on mööda minemas, hüüdsid nad: „Halasta meie peale, Issand, Taaveti poeg!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Rahvas käskis neil vait olla, aga nad hüüdsid veel valjemini: „Halasta meie peale, Issand, Taaveti poeg!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jeesus peatus. Ta kutsus nad enda juurde ja küsis: „Mida te tahate, et ma teile teeksin?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","„Issand, palun tee meid jälle nägijateks,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jeesusel oli neist kahju ja ta puudutas nende silmi. Kohe nägid nad jälle ja järgisid teda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jeesus ja tema jüngrid läksid Jeruusalemma. Lähemale jõudes tulid nad Betfage küla juurde Õlimäel. Jeesus saatis kaks jüngrit ette ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ja ütles neile: „Minge külla. Sealsamas leiate te kinni seotult eesli koos säluga. Siduge nad lahti ja tooge mulle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kui keegi küsib, mida te teete, siis öelge talle: „Issandal on neid vaja“, ja nad saadavad nad jalamaid.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nii pidi täituma see, mida oli öelnud prohvet: ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","„Öelge Siioni tütrele: „Vaata, sinu Kuningas tuleb su juurde. Ta on alandlik ning ratsutab eesli ja eeslisälu seljas.““ ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jüngrid läksid ja tegid nii, nagu Jeesus oli õpetanud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nad tõid kaasa eesli ja sälu. Nad panid nende peale oma ülekuued ja ta istus nende peale. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Paljud rahva hulgas laotasid oma ülekuued tee peale, samal ajal teised lõikasid puude otsast oksi ja panid need tee peale. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Rahvas, kes käis tema ees, ja need, kes tulid tema järel, hüüdsid kõik: „Hosanna Taaveti pojale! Õnnistatud on see, kes tuleb Issanda nimel! Hosanna kõrgustes!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kui Jeesus saabus Jeruusalemma, oli kogu linn elevil. „Kes see on?“ küsiti. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","„See on Jeesus, prohvet Galilea Naatsaretist,“ vastas rahvahulk. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jeesus läks templisse ja viskas välja kõik inimesed, kes ostsid ja müüsid. Ta lükkas kummuli rahavahetajate lauad ja tuvimüüjate toolid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ta ütles neile: „Pühakiri ütleb: „Minu koda peab hüütama palvekojaks“, aga teie olete selle muutnud röövlikoopaks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Pimedad ja lombakad tulid templisse Jeesuse juurde ja ta tegi nad terveks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aga kui ülempreestrid ja vaimulikud õpetajad nägid imetegusid, mida ta tegi, ja lapsi templis hüüdmas: „Hosanna Taaveti pojale!“, olid nad haavunud. „Kas sa kuuled, mida need lapsed ütlevad?“ küsisid nad talt. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","„Jah,“ vastas Jeesus. „Kas te ei ole kunagi lugenud Pühakirja, kus on öeldud: „Sa oled korraldanud nii, et lapsed ja imikud ülistavad sind täiuslikult“?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jeesus lahkus neist ja läks linnast välja, et peatuda Betaanias. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Järgmisel hommikul, kui ta oli teel tagasi linna, tundis ta nälga. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ta nägi tee ääres üht viigipuud, nii läks ta selle juurde, kuid ei leidnud vilju, ainult lehti. Ta ütles viigipuule: „Et sa enam kunagi vilja ei kannaks!“ Viigipuu närbus jalamaid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jüngrid olid seda nähes hämmastunud. „Kuidas see viigipuu nii äkitselt ära närbus?“ küsisid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","„Ma ütlen teile tõtt,“ vastas Jeesus, „Kui teil oleks tõesti kindel usk Jumalasse ja te ei kahtleks temas, ei suudaks te teha üksnes seda, mis juhtus viigipuuga, vaid palju enamat. Kui te ütleksite sellele mäele: „Tõuse ja heida ennast merre!“, siis nii sünniks! ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Te saate kõike, mida te palves palute, kui teil on kindel usk Jumalasse.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jeesus läks templisse. Ülempreestrid ja valitsevad rahvavanemad tulid tema juurde, kui ta õpetas, ja küsisid: „Mis õigusega sa neid asju teed? Kes sulle selleks õiguse andis?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","„Mina esitan ka teile küsimuse,“ vastas Jeesus. „Kui te vastate mulle, siis ütlen teile, mis õigusega ma neid asju teen. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kust oli Johannese ristimine pärit? Kas see oli taevast või inimestelt?“ Nad vaidlesid omavahel. „Kui me ütleme: „See oli taevast“, siis küsib ta, miks me temasse ei uskunud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aga kui ütleme: „See oli inimestelt“, siis pöördub rahvas meie vastu, sest kõik peavad Johannest prohvetiks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Niisiis vastasid nad Jeesusele: „Me ei tea.“ „Siis ei ütle ma teile, mis õigusega ma neid asju teen,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","„Aga mida te arvate sellest näitest? Elas kord mees, kellel oli kaks poega. Ta läks esimese poja juurde ja ütles: „Poeg mine täna viinapuuaeda tööle.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Poeg vastas: „Ei lähe“, kuid pärast oli tal kahju sellepärast, mida ta oli öelnud, ja ta läks tööle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mees läks teise poja juurde ja ütles talle sama. Poeg vastas: „Ma lähen,“, aga ei läinud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kumb neist kahest pojast tegi seda, mida isa soovis?“ „Esimene,“ vastasid nad. „Ma räägin teile tõtt: maksukogujad ja prostituudid sisenevad Jumala riiki enne teid,“ ütles Jeesus neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","„Johannes tuli, et näidata teile, kuidas elada Jumalale vastuvõetavalt, ja te ei uskunud teda, kuid maksukogujad ja prostituudid uskusid teda. Hiljem, kui te nägite, mis juhtus, ei kahetsenud ega uskunud te ikkagi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Siin on veel üks näitlik lugu. Elas kord üks mees, maaomanik, kes istutas viinapuuaja. Ta pani selle ümber tara, valmistas surutõrre ja ehitas vahitorni. Ta andis selle mõnedele renditalunikele rendile ja lahkus siis, et minna teise riiki. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Lõikuseajal saatis ta oma sulased talunike juurde, et koguda saak, mis kuulus talle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kuid talunikud ründasid tema sulaseid. Üht nad peksid, teise tapsid ja kolmandat viskasid kividega. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Niisiis saatis ta veel sulaseid, aga talunikud tegid nendega sama. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Siis saatis ta oma poja. „Nad austavad mu poega,“ mõtles ta endamisi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Aga kui talunikud nägid poega, ütlesid nad üksteisele: „Siin on pärija! Tulge! Tapame ta ära, nii et saame tema pärandi endale võtta!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nad haarasid temast kinni, viskasid ta viinapuuaiast välja ja tapsid ta. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kui viinapuuaia omanik tagasi tuleb, mida ta siis nende talunikega teeb?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ülempreestrid ja vanemad ütlesid Jeesusele: „Ta mõistab need kurjad mehed kõige kohutavamasse surma ning annab viinapuuaia rendile teistele talunikele, kes annavad talle kindlasti lõikuseajal saaki.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","„Niisiis, kas te ei ole seda Pühakirjast lugenud?“ küsis Jeesus neilt. „„Kivi, mille ehitajad välja praakisid, on saanud peamiseks nurgakiviks. Issand on seda teinud ja see on meie silmis imeline.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Sellepärast ma räägingi, et Jumala riik võetakse teilt ära. See antakse inimestele, kes kannavad õiget vilja. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Igaüks, kes langeb selle kivi peale, puruneb, aga kelle peale see kivi langeb, purustatakse täielikult.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kui ülempreestrid ja variserid kuulsid tema näitlikke lugusid, mõistsid nad, et ta räägib neist. ");
INSERT INTO ekkpkp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nad tahtsid ta vahistada, kuid kartsid seda, mida rahvas võib teha, sest rahvas uskus, et ta on prohvet. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jeesus kõneles neile veel näitlikke lugusid kasutades. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","„Taevariik on nagu kuningas, kes korraldas oma pojale pulmapeo,“ selgitas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","„Ta saatis oma sulased välja kõigi juurde, kes olid pulma kutsutud, et nad tuleksid kohale, kuid nad keeldusid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nii saatis ta välja veel sulaseid, korraldusega: „Öelge kutsutuile, et ma olen pulma peolaua valmis saanud. Härjad ja nuumvasikad on tapetud, kõik on valmis. Nii et tulge pulma!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kuid nad eirasid kutset ja lahkusid. Üks läks oma põllule, teine äri eest hoolt kandma. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ülejäänud võtsid kuninga sulased kinni, kohtlesid neid halvasti ja tapsid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kuningas sai maruvihaseks. Ta saatis oma sõdurid neid mõrvareid hävitama ja nende linna maha põletama. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Siis ütles kuningas oma sulastele: „Pulma peolaud on valmis, aga need, kes olid kutsutud, ei olnud väärt osa saama. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Minge tänavatele ja kutsuge pulma kõiki, keda leiate.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Siis läksid sulased välja tänavatele ja tõid kaasa kõik, kelle leidsid, nii häid kui ka halbu. Peosaal sai täis. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Aga kui kuningas tuli külalistega kohtuma, märkas ta üht meest, kellel ei olnud pulmarõivast seljas. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kuningas küsis mehelt: „Mu sõber, kuidas sa ilma pulmarõivata siia sisse said?“ Mehel ei olnud midagi öelda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Siis kuningas käskis oma sulaseid: „Siduge ta käed ja jalad kinni ning heitke ta pimedusse, kus on nutmine ja hammaste kiristamine.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sest paljud on kutsutud, aga vähesed on valitud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Siis variserid lahkusid ja tulid kokku, et sepitseda plaani, kuidas nad saaksid tema sõnadega ta lõksu püüda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nad saatsid oma jüngrid tema juurde koos Heroodese pooldajatega. „Õpetaja, me teame, et sa oled ausameelne inimene ja et sa õpetad, et Jumala tee on tõde,“ alustasid nad. „Sa ei lase end kellelgi mõjutada ja sa ei hooli auastmest ega seisusest. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Anna siis meile teada oma arvamus. Kas on õige maksta keisrile makse või mitte?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jeesus teadis, et nende ajendid olid kurjad. Ta küsis neilt: „Miks te üritate mind lõksu püüda, te silmakirjatsejad? ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Näidake mulle münti, mida kasutatakse maksu tasumiseks.“ Nad tõid talle ühe denaari näha. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","„Kelle pilt ja kelle tiitel on siia graveeritud?“ küsis ta neilt. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","„Keisri,“ vastasid nad. „Keisrile tuleb anda tagasi see, mis keisrile kuulub, ja Jumalale see, mis Jumalale kuulub,“ ütles ta neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kui nad Jeesuse vastust kuulsid, olid nad jahmunud. Nad läksid ära ja jätsid ta rahule. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Hiljem samal päeval tulid tema juurde mõned saduserid. (Nemad on need, kes ütlevad, et ülestõusmist ei ole.) ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Nad küsisid talt: „Õpetaja, Mooses ütles, et kui abielus mees sureb ilma lapsi saamata, peaks ta vend tema lesega abielluma ja oma venna jaoks lapsi saama. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Meie kandis elas kord seitse venda. Esimene abiellus ja suri ning kuna tal ei olnud lapsi, jättis ta oma lese oma vennale. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Sama juhtus teise ja kolmanda vennaga, kuni seitsmendani välja. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Lõpuks suri ka see naine. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kui nüüd ülestõusmine tuleb, kelle naiseks ta neist seitsmest vennast saab, sest ta oli abielus nende kõigiga?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jeesus vastas: „Teie viga on, et te ei tunne Pühakirja ega seda, mida Jumal suudab teha. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sest ülestõusmises ei võeta naisi ega minda mehele − siis ollakse nagu taeva inglid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mis puutub surnute ülestõusmisesse, siis kas te ei ole lugenud, mida Jumal teile ütles: ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","„Mina olen Aabrahami Jumal ja Iisaki Jumal ja Jaakobi Jumal“? Ta ei ole surnute, vaid elavate Jumal.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kui rahvahulgad tema sõnu kuulsid, olid nad tema õpetusest hämmastuses. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kui variserid kuulsid, et ta oli saduseride suu sulgenud, tulid nad kokku ja esitasid veel küsimusi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nende hulgast üks, kes oli seadusetundja, esitas talle küsimuse, üritades teda lõksu püüda: ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","„Õpetaja, missugune on tähtsaim käsk seaduses?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jeesus ütles neile: „„Armasta Issandat, oma Jumalat, kõiges, mida sa mõtled, kõiges, mida sa tunned, ja kõiges, mida sa teed.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","See on tähtsaim käsk, esimene käsk. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Teine on üsna samasugune: „Armasta oma kaasinimest nagu iseennast.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kogu piibellik seadus ja prohvetite kirjutised tuginevad neile kahele käsule.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kuna variserid olid sinna kogunenud, esitas Jeesus neile küsimuse. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","„Mida te arvate Messiast?“ küsis ta. „Kelle poeg ta on?“ „Taaveti poeg,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","„Aga kuidas saab Taavet inspireeritult nimetada teda Issandaks?“ küsis Jeesus neilt. „Ta ütleb: ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","„Issand ütles minu Issandale: istu mu paremale käele, kuni ma su vaenlased võidan.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Kui Taavet nimetas teda Issandaks, kuidas saab ta siis tema poeg olla?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Keegi ei osanud talle vastata ja nüüdsest peale ei söandanud keegi enam talle küsimusi esitada. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Siis Jeesus kõneles rahvahulgale ja oma jüngritele: ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","„Vaimulikud õpetajad ja variserid kui Moosese seaduse tõlgendajad on vastutavad, ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","nii et kuuletuge neile ja tehke kõike, mida nad teid käsivad. Kuid ärge tehke selle järgi, mida nad teevad, sest nad ei täida seda, mida nad õpetavad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nad seovad kokku raskeid koormaid ja asetavad need inimeste õlgadele, kuid ise ei liiguta nad sõrmeotsagi, et neid aidata. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kõike, mida nad teevad, teevad nad selleks, et neid märgataks. Nad teevad endale kandmiseks suured palvekarbid ja pikad tutid oma rõivaste külge. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nad armastavad aukohti pidusöökidel ja parimaid kohti sünagoogides. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Neile meeldib, kui neid tervitatakse turuplatsil lugupidavalt ja kui inimesed ütlevad neile „Rabi“. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ärge laske inimestel öelda endale „Rabi“. Ainult üks on teie Ülemõpetaja ja teie kõik olete vennad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ärge nimetage siin maa peal kedagi tiitliga „Isa“. Ainult üks on teie Isa, kes on taevas. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ärge laske inimestel öelda teile „Õpetaja“. Ainult üks on teie Õpetaja − Messias. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tähtsaim teie hulgas on teie teenija. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Need, kes ennast ise tähtsaks teevad, alandatakse, ja need, kes ennast ise alandavad, tehakse tähtsaks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Aga missugune häda on teile tulemas, vaimulikud õpetajad ja variserid, te silmakirjatsejad! Te lööte inimeste nina ees taevariigi ukse kinni. Ise te sinna sisse ei lähe, kuid ei lase sinna ka kedagi teist, kes üritab sisse minna. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Missugune häda on teile tulemas, vaimulikud õpetajad ja variserid, te silmakirjatsejad! Sest te rändate läbi maa ja mere, et ühtainust hinge pöörata, ja kui te sellega hakkama saate, teete temast kaks korda hullema pimeduse poja, kui te ise olete. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Missugune häda on tulemas teile, kes te ütlete: „Kui sa vannud templi nimel, siis ei lähe see arvesse, aga kui sa vannud templi kulla nimel, siis pead oma vannet pidama.“ Kui rumalad ja pimedad te olete! ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mis on tähtsam, kas kuld või tempel, mis muudab kulla pühaks? ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Te ütlete: „Kui sa vannud altari nimel, siis ei lähe see arvesse, aga kui sa vannud ohvri nimel, mis on altari peal, siis pead oma vannet pidama.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kui pimedad te olete! Mis on tähtsam, kas ohver või altar, mis muudab ohvri pühaks? ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kui te vannute altari nimel, vannute selle nimel ja kõige nimel, mis selle peal on. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kui vannute templi nimel, vannute selle nimel ja kõigi nimel, kes selles elavad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kui vannute taeva nimel, vannute Jumala trooni nimel ja selle nimel, kes seal istub. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Missugune häda on teile tulemas, vaimulikud õpetajad ja variserid, te silmakirjatsejad! Te maksate kümnist mündist, aniisist ja vürtsköömnest, kuid jätate unarusse seaduse elutähtsad osad − heategemise, halastuse, usu. Jah, kümnist tuleb maksta, kuid neid teisi asju ei tohi unustada. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Te pimedad teejuhid, te kurnate seda, mida joote, et hoida eemal kärbes, kuid siis neelate alla kaameli! ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Missugune häda on teile tulemas, vaimulikud õpetajad ja variserid, te silmakirjatsejad! Te puhastate karikat ja vaagnat väljastpoolt, kuid seestpoolt olete täis ahnust ja isekust. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Te pimedad variserid! Puhastage kõigepealt karika ja vaagna sisemus, nii et need saaks ka väljastpoolt puhtaks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Missugune häda on teile tulemas, vaimulikud õpetajad ja variserid, te silmakirjatsejad! Te olete nagu lubjaga võõbatud hauakoopad, mis näevad väljast head välja, kuid seest on täis luukeresid ja igasugust kõdu. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Te olete täpselt samasugused. Väljastpoolt paistate te teistele head inimesed, kuid seesmiselt olete täis silmakirjalikkust ja nurjatust. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Missugune häda on teile tulemas, vaimulikud õpetajad ja variserid, te silmakirjatsejad! Te ehitate hauakambreid prohvetite mälestusmärkideks ja kaunistate heade inimeste hauakääpaid ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ning ütlete: „Kui me oleks esivanemate ajal elanud, ei oleks me nendega prohvetite vere valamisel ühinenud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Aga seda öeldes tunnistate te iseenda vastu, tõestades, et kuulute nende hulka, kes on tapnud prohveteid! ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nii et jätkake seda − lõpetage see kõik oma esiisade meetodeid kasutades! ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Te maod, te rästikute sigitis, kuidas te pääsete hukka mõistvast kohtust? ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Sellepärast läkitan ma teie juurde prohveteid, tarku mehi ja õpetajaid. Mõned neist te tapate, mõned neist lööte risti ning mõnda neist te piitsutate sünagoogides, ajades neid taga linnast linna. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Selle tagajärjel peetakse teid vastutavaks kõigi heade inimeste vere eest, mis on maa peal valatud − Abelist, kes tegi seda, mis on õige, kuni Sakarja poja Berekjani, kelle te tapsite templi ja altari vahel. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ma ütlen teile, kõige selle tagajärjed langevad sellele põlvkonnale. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jeruusalemm, Jeruusalemm, sina, kes sa tapad prohvetid ja viskad kividega surnuks need, kes on sinu juurde läkitatud! Nii sageli olen soovinud koguda su lapsi nagu kanaema kogub oma pojad tiibade alla, aga te ei ole lasknud mul seda teha. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Vaadake nüüd − teie koda jäetakse maha, täiesti tühjaks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ma ütlen teile seda: te ei näe mind enne, kui ütlete: „Õnnistatud on see, kes tuleb Issanda nimel.““ ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kui Jeesus oli templist lahkumas, tulid jüngrid tema juurde ja osutasid uhkelt templi hoonetele. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Aga Jeesus vastas: „Kas näete kõiki neid hooneid? Ma ütlen teile tõtt: neis ei jää üht kivi teise peale. Iga viimane kui üks variseb raginal maha!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kui Jeesus istus Õlimäel, tulid jüngrid omaette olles tema juurde ja küsisid: „Räägi meile palun, millal see toimub. Mis on sinu tulemise ja maailma lõpu märk?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","„Ärge laske kellelgi end eksitada,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","„Paljud väidavad end minu olevat, öeldes: „Mina olen Messias“, ja petavad paljusid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Te kuulete sõdadest ja kuuldusi sõdadest, kuid ärge olge ärevil. See kõik peab toimuma, kuid see ei ole lõpp. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Rahvad ründavad teisi rahvaid ja kuningriigid võitlevad teiste kuningriikide vastu. Paljudes paikades on näljahäda ja maavärinaid, ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","kuid kõik see on alles sünnitusvalude algus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Siis teid vahistatakse, kiusatakse taga ja tapetakse. Kõik vihkavad teid minu pärast. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sel ajal loobuvad paljud usklikud uskumast. Nad reedavad ja vihkavad üksteist. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Palju valeprohveteid tuleb ja nad petavad paljusid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Suureneva kurjuse tõttu jahtub paljude armastus, ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","aga kes lõpuni vastu peavad, need saavad päästetud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Head sõnumit kuningriigist kuulutatakse kogu maailmas, nii et kõik võivad seda kuulda, ja siis tuleb lõpp. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Nii et kui te näete pühas paigas seisvat „rüvetavat ebajumalust“, millest prohvet Taaniel rääkis (kes seda loeb, mõelgu hoolikalt järele), ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","siis need, kes elavad Juudamaal, peaksid põgenema mägedesse. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","See, kes on katusel, ei tohi tulla alla majast midagi ära tooma. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","See, kes on väljas põllul, ei tohi minna tagasi kuube võtma. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kui kohutav on see neile, kes on sel ajal lapseootel või imetavad! ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Palvetage, et teil ei oleks vaja põgeneda talvel ega hingamispäeval. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sest sel ajal on kohutav tagakiusamine, kohutavam kui miski, mis on toimunud maailma algusest kuni selle ajani, ja mida ei juhtu enam kunagi uuesti. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kui neid päevi ei lühendataks, ei pääseks keegi, aga valitute pärast lühendatakse seda aega. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nii et kui keegi ütleb teile: „Vaata, siin on Messias!“ või „Vaata, seal!“, ärge uskuge seda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sest valemessiaid ilmub ja ka valeprohveteid ning nad teevad uskumatuid tunnustähti ja imetegusid, et petta ära ka valitud, kui see oleks võimalik. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pange tähele, et ma rääkisin teile sellest enne, kui see toimub. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nii et kui öeldakse: „Vaata, ta on väljas kõrbes!“, ärge minge sinna vaatama; või kui öeldakse: „Vaata, ta on salaja siin!“, ärge uskuge seda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sest inimese Poja tulemine on nagu välk, mis sähvatab eredalt idast läände. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","„Kus on korjus, sinna kogunevad raisakotkad.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Aga kohe pärast seda tagakiusamise aega läheb päike pimedaks, kuu ei sära, tähed langevad taevast ja taeva vägesid kõigutatakse. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Siis ilmub taevasse inimese Poja tunnustäht ja kõik maailma rahvas leinab. Nad näevad inimese Poega tulemas taeva pilvedel väe ja särava hiilgusega. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pasunahäälega läkitab ta inglid koguma oma valituid igalt poolt, ühest taeva ja maa otsast teiseni. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Õppige näitlikku õppetundi viigipuust. Kui puul kasvavad õrnad võsud ja lehed hakkavad võrsuma, siis teate, et suvi on tulemas. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Samamoodi kui te näete kõike seda toimumas, siis teadke, et tema tulemine on lähedal, õigupoolest on see otse ukse taga! ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ma ütlen teile tõtt: see põlvkond ei kao enne, kui kõik see on toimunud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Taevas ja maa võivad kaduda, aga minu sõnad ei kao. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Aga keegi ei tea päeva ega tundi, millal see toimub, ei inglid taevas ega Poeg. Ainult Isa teab. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kui inimese Poeg tuleb, on see nagu Noa ajal. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","See on nagu enne veeuputust, kui nad sõid ja jõid, võtsid naisi ja läksid mehele, lausa päevani, mil Noa läks laeva. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nad ei mõistnud, mis hakkab toimuma, kuni tuli uputus ja pühkis nad kõik minema. Nii on ka inimese Poja tulemine. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kaks meest töötavad põllul. Üks võetakse, teine jäetakse maha. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kaks naist jahvatavad veskiga vilja. Üks võetakse, teine jäetakse maha. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nii et olge valvsad, sest te ei tea, mis päeval teie Issand tuleb. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Aga võtke arvesse seda: kui majaomanik teaks aega, mil varas tuleb, oleks ta valvel. Ta ei laseks oma majja sisse murda ja sealt röövida. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ka teie peate olema valmis, sest inimese Poeg tuleb ajal, mil te teda ei oota. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Sest kes on usaldusväärne ja tähelepanelik sulane? See on see, kelle isand paneb oma majapidamise eest hoolitsema, et ta varustaks neid toiduga õigel ajal. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kui hea on selle sulase jaoks, kui isand tagasi tulles leiab ta seda tegemas! ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ma ütlen teile tõtt: isand paneb selle sulase vastutama kõige eest, mis tal on. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Aga kui see sulane oleks nurjatu, ütleks ta endale: „Mu isandal läheb kaua aega“, ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ning ta hakkaks teisi sulaseid peksma, pidutsema ning joobnutega jooma. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Siis selle sulase isand tuleb tagasi siis, kui sulane ei oota, ajal, mil ta ei tea. ");
INSERT INTO ekkpkp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ta raiub ta tükkideks ja kohtleb samamoodi nagu silmakirjatsejaid, saates ta paika, kus on nutmine ja hammaste kiristamine. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Taevariik on nagu kümme neidu, kes võtsid oma lambid kaasa ja läksid peigmehega kohtuma. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Viis olid rumalad ja viis targad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Rumalad neiud võtsid oma lambid, kuid ei võtnud kaasa õli, ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","samal ajal targad neiud võtsid kaasa nii õlinõud kui ka lambid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Peigmehe tulek viibis ning kõik neiud jäid uniseks ja uinusid magama. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Keskööl kõlas hüüd: „Vaadake, peigmees on kohal! Tulge välja temaga kohtuma!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kõik neiud ärkasid ja kohendasid oma lampide tahti. Rumalad neiud ütlesid tarkadele: ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","„Andke meile veidi oma õli, sest meie lambid kustuvad.“ Aga targad neiud vastasid: ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","„Ei, sest muidu ei jaguks sellest ei teile ega meile. Minge poodnike juurde ja ostke endale õli.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Sel ajal kui nad läksid õli ostma, jõudis peigmees kohale, ja need, kes olid valmis, läksid koos temaga sisse pulmapeole, ja uks pandi lukku. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Teised neiud tulid hiljem. „Isand, isand!“ hüüdsid nad. „Ava meile uks!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kuid peigmees vastas: „Ma ütlen teile tõtt: ma ei tunne teid.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nii et olge valvsad, sest te ei tea päeva ega tundi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","See on nagu mees, kes läks ära reisile. Ta kutsus kokku oma sulased ja usaldas nende kätte oma vara. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ühele sulasele andis ta viis talenti, teisele kaks ja kolmandale ühe, vastavalt nende erinevatele võimetele. Siis ta lahkus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Viis talenti saanu läks kohe ja investeeris need ärisse ning sai juurde veel viis talenti. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Samamoodi sai kaks talenti saanu veel kaks juurde. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Aga mees, kes oli saanud ühe talendi, läks ja kaevas augu ning peitis oma isanda raha ära. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kaua aega hiljem tuli nende sulaste isand tagasi ja õiendas nendega arved. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Viis talenti saanu tuli ja tõi kaasa veel viis talenti. „Isand,“ ütles ta, „sa andsid mulle viis talenti. Vaata, ma sain viis talenti kasu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Isand ütles talle: „Sa oled hästi teinud, sa oled hea ja ustav sulane. Sa tõestasid, et oled usaldusväärne väikestes asjades, nii et ma panen sind nüüd paljude asjade eest vastutama. Ole rõõmus, sest ma olen tõesti sinuga rahul!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tuli ka see, kes oli saanud kaks talenti. „Isand,“ ütles ta, „sa andsid mulle kaks talenti. Vaata, ma sain kaks talenti kasu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Isand ütles talle: „Sa oled hästi teinud, sa oled hea ja ustav sulane. Sa tõestasid, et oled usaldusväärne väikestes asjades, nii et ma panen sind nüüd paljude asjade eest vastutama. Ole rõõmus, sest ma olen tõesti sinuga rahul!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Siis tuli ühe talendiga mees. „Isand,“ ütles ta, „ma tean, et sa oled karm mees. Sa lõikad sealt, kuhu sa pole külvanud, ja kogud saaki sealt, kuhu sa pole istutanud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kuna ma kartsin sind, läksin ma ja matsin su talendi maa sisse. Vaata, sa saad tagasi selle, mis sulle kuulub.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Aga isand vastas talle: „Sina nurjatu ja laisk sulane! Kui sa arvad, et ma lõikan sealt, kuhu ma pole külvanud, ja kogun saaki sealt, kuhu ma pole istutanud, ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","siis oleksid pidanud mu hõbeda panka hoiule andma, et ma koju tulles oleksin saanud oma raha intressiga tagasi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Võtke talent temalt ära ja andke sellele, kellel on kümme talenti. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sest igaühele, kellel on, sellele antakse veel rohkem, ja igaühelt, kellel pole midagi, võetakse ära seegi, mis tal on. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nüüd heitke see kasutu sulane välja pimedusse, kus on nutmine ja hammaste kiristamine.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Aga kui inimese Poeg tuleb oma hiilguses ja kõik inglid koos temaga, siis istub ta oma suursugusele troonile. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kõik tuuakse tema ette. Ta eraldab nad üksteisest, nagu karjane eraldab lambad kitsedest. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ta paneb lambad oma paremale käele ja kitsed vasakule käele. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Siis ütleb kuningas neile, kes on tema paremal käel: „Tulge siia, mu Isa õnnistatud, ja pärige kuningriik, mis on teile valmistatud maailma algusest peale. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Sest mul oli nälg ja te andsite mulle süüa. Mul oli janu ja te andsite mulle juua. Ma olin võõras ja te kutsusite mu sisse. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ma olin alasti ja te riietasite mind. Ma olin haige ja te hoolitsesite minu eest. Ma olin vangis ja te külastasite mind.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Siis need, kes on temast paremal, vastavad: „Issand, millal me nägime sind näljasena ja toitsime sind, või janusena ja jootsime sind? ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Millal nägime sind võõrana ja kutsusime sind sisse või alasti ja riietasime sind? ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Millal nägime sind haigena või vangis ja külastasime sind?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kuningas lausub neile: „Ma ütlen teile tõtt: mida iganes te tegite ühele neist, kes on kõige tähtsusetumad, seda tegite mulle.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Samuti pöördub ta nende poole, kes on tema vasakul käel, ja ütleb: „Minge minu juurest ära, te hukkamõistetud, igavesse tulle, mis on valmistatud kuradi ja tema inglite jaoks! ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sest mul oli nälg ja te ei andud mulle midagi süüa. Mul oli janu ja te ei andnud mulle juua. ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma olin võõras ja te ei kutsunud mind sisse. Ma olin alasti ja te ei riietanud mind. Ma olin haige ja vangis ja te ei külastanud mind.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Siis vastavad ka nemad: „Issand, millal me nägime sind näljase või janusena, võõrana või alasti, haigena või vangis, ega hoolitsenud sinu eest?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Siis kostab ta neile: „Ma ütlen teile tõtt: mida iganes te ei teinud ühele neist, kes on kõige tähtsusetumad, seda ei teinud te mulle.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nad lähevad ära igavesse hukkamõistu, aga need, kes on head, lähevad igavesse ellu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pärast seda, kui Jeesus oli kõike seda rääkinud, ütles ta oma jüngritele: ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","„Te teate, et kahe päeva pärast on paasapüha ja inimese Poeg antakse nende kätte, kes ta risti löövad.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Siis kogunesid ülempreestrid ja rahvavanemad ülempreester Kaifase hoovi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Seal sepitsesid nad plaani, et vahistada Jeesus mõne valeliku ettekäände abil ja ta tappa. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kuid nad ütlesid: „Ärgem tehkem seda pühade ajal, et rahvas mässama ei hakkaks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Sel ajal kui Jeesus peatus pidalitõbise Siimona majas Betaanias, ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","tuli tema juurde üks naine, kaasas alabasternõu väga kalli parfüümiga. Ta valas selle Jeesusele pähe, kui Jeesus istus ja sõi. Aga kui jüngrid nägid, mida naine tegi, ärritas see neid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","„Missugune kohutav raiskamine!“ protestisid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","„Selle parfüümi oleks võinud suure raha eest ära müüa ja raha vaestele anda!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jeesus teadis, mis toimus, ja ta ütles neile: „Miks te selle naise peale pahandate? Ta tegi minu heaks midagi imelist! ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Vaeseid on teie juures alati, aga mind ei ole teil alati. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Seda parfüümi mu ihule valades valmistas ta mind ette matmiseks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ma ütlen teile tõtt: kus iganes maailmas seda head sõnumit kuulutatakse, räägitakse ka lugu sellest, mida see naine tegi, tema mälestuseks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Siis Juudas Iskariot, üks kaheteistkümnest jüngrist, läks ülempreestrite juurde ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ja küsis neilt: „Kui palju te mulle maksate, kui annan Jeesuse teie kätte?“ Nad maksid talle kolmkümmend hõbemünti. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Sellest ajast peale otsis ta võimalust, et Jeesus nende kätte anda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hapnemata leibade püha esimesel päeval tulid jüngrid Jeesuse juurde ja küsisid talt: „Kus sa tahad, et me valmistaksime sulle söömiseks paasapüha söömaaja?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jeesus ütles neile: „Minge linna ja leidke see konkreetne mees ning öelge talle, et Õpetaja ütleb: „Minu aeg on lähedal. Ma tulen koos jüngritega paasapüha tähistama sinu majja.““ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jüngrid tegid, nagu Jeesus oli käskinud, ja nad valmistasid seal paasapüha söömaaja. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kui õhtu saabus, istus ta koos kaheteistkümnega maha sööma. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Söömise ajal rääkis ta neile: „Ma ütlen teile tõtt: üks teist reedab mu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nad olid äärmiselt vapustatud. Üksteise järel küsisid nad talt: „Issand, ega see mina ole?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","„Minu reedab see, kes kastis oma käe koos minuga vaagnasse,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","„Inimese Poeg sureb täpselt nii, nagu temast on prohvetlikult ette kuulutatud, aga häda sellele inimesele, kes inimese Poja reedab! Sellel inimesel oleks parem, kui ta poleks kunagi sündinud!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Juudas − see, kes kavatses Jeesuse reeta − küsis: „Ega see mina ole, rabi?“ „Seda ütlesid sina,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Söömise ajal võttis Jeesus veidi leiba ja õnnistas seda. Siis murdis ta seda ja andis tükid oma jüngritele. „Võtke ja sööge seda, sest see on minu ihu,“ ütles Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Siis võttis ta karika, õnnistas seda ja andis neile. „Jooge kõik sellest,“ ütles ta neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","„Sest see on minu kokkuleppe veri, mis on valatud välja paljude eest pattude andeksandmiseks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kuid ma ütlen teile, et ma ei joo sellest viinapuu viljast kuni päevani, mil ma joon seda värskena koos teiega oma Isa riigis.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pärast seda kui nad laulsid ühe laulu, läksid nad välja Õlimäele. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","„Te kõik jätate mu täna öösel maha,“ rääkis Jeesus neile. „Nagu Pühakiri ütleb: „Ma löön karjast ja lambakari pillutatakse laiali.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Aga pärast seda, kui ma olen üles tõusnud, lähen ma teie eel Galileasse.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kuid Peetrus protestis: „Isegi kui kõik teised sind maha jätavad, siis mina ei jäta sind kunagi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","„Ma ütlen teile tõtt,“ ütles Jeesus talle, „Täna öösel, enne kui kukk kireb, salgad sa mind kolm korda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","„Isegi kui pean sinuga koos surema, ei salga ma sind!“ jäi Peetrus endale kindlaks. Ja kõik jüngrid ütlesid sama. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Siis Jeesus läks koos oma jüngritega paika, mida nimetatakse Ketsemaniks. Ta ütles neile: „Istuge siin, sel ajal kui ma lähen sinna ja palvetan.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ta võttis Peetruse ja kaks Sebedeuse poega endaga kaasa. Teda hakkas vaevama piinav südamevalu ja ahastus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Siis ütles ta neile: „Mind valdab võrreldamatu kurbus. Oodake siin ja valvake koos minuga.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ta läks veidi maad edasi, langes näoli maha ja palvetas. „Mu Isa, kui on võimalik, palun lase see kannatuste karikas minult ära võtta,“ palvetas Jeesus. „Sellegipoolest ärgu sündigu see, mida mina tahan, vaid see, mida tahad sina.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ta läks tagasi jüngrite juurde ja leidis nad magamas. Ta ütles Peetrusele: „Kas sa ei suutnud ühtainsat tundigi minuga koos ärkvel püsida? ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Olge valvsad ja palvetage, et te ei langeks kiusatusse. Jah, vaim on valmis, aga ihu on nõrk.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ta läks teist korda eemale ja palvetas. „Mu Isa, kui seda karikat ei saa minult ära võtta, ilma et ma sellest jooksin, siis täitugu sinu tahe,“ ütles ta. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ta läks tagasi ja leidis nad magamas, sest nad lihtsalt ei suutnud ärkvel püsida. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Niisiis läks ta veelkord nende juurest ära eemale ja palvetas kolmandat korda, samu asju korrates. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Siis naasis ta jüngrite juurde ja ütles neile: „Kuidas te saate ikka veel magada ja puhata? Vaadake, aeg on käes. Inimese Poeg antakse kohe patuste kätte! ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tõuske üles, lähme! Näete, see, kes mu ära annab, on kohale jõudnud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kui ta seda ütles, jõudis kohale Juudas, üks kaheteistkümnest, ja temaga koos suur mõõkade ja nuiadega relvastatud jõuk, mille olid saatnud ülempreestrid ja rahvavanemad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Äraandja oli andnud neile märguande: „See, keda ma suudlen, ongi tema, võtke ta kinni,“ ütles ta neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Juudas tuli kohe Jeesuse juurde ja ütles: „Tere, rabi,“ ja suudles teda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","„Mu sõber, tee seda, mida sa tegema tulid,“ ütles Jeesus Juudasele. Nii nad siis tulid, haarasid Jeesusest kinni ja vahistasid ta. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Üks neist, kes oli Jeesusega, sirutas käe mõõga järele ja tõmbas selle välja. Ta lõi ülempreestri sulast ja lõikas ta kõrva maha. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Aga Jeesus ütles talle: „Pane oma mõõk ära. Igaüks, kes võitleb mõõgaga, sureb mõõga läbi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Sa ei arva ju, et ma ei võiks paluda oma Isa, et ta saadaks kohe rohkem kui kaksteist leegioni ingleid? ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Aga kuidas siis täituks Pühakiri, mis ütleb, et see peab nii toimuma?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Siis ütles Jeesus jõugule: „Kas te tulite mind vahistama mõõkade ja nuiadega, nagu oleksin ma mingisugune ohtlik kurjategija? Ma istusin iga päev templis õpetades ja te ei vahistanud mind siis. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Aga kõik see toimub, et läheks täide see, mida prohvetid kirjutasid.“ Siis kõik jüngrid jätsid ta maha ja jooksid minema. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Need, kes Jeesuse vahistasid, viisid ta ülempreester Kaifase majja, kuhu olid kogunenud vaimulikud õpetajad ja vanemad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peetrus järgnes talle eemalt ja läks ülempreestri hoovi. Seal istus ta koos valvuritega, et näha, kuidas kõik lõpeb. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ülempreestrid ja kogu nõukogu üritasid leida Jeesuse vastu mingeid valetõendeid, et nad saaksid ta surma mõista. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Aga nad ei suutnud midagi leida, kuigi valetunnistajaid astus esile. Lõpuks astusid ette kaks tunnistajat ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ja teatasid: „See mees ütles: „Ma suudan Jumala templi hävitada ja kolme päevaga üles ehitada.““ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ülempreester tõusis ja küsis Jeesuselt: „Kas sul ei ole vastust? Mida on sul enda kaitseks öelda?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kuid Jeesus vaikis edasi. Ülempreester ütles Jeesusele: „Ma panen su elava Jumala nimel vande alla. Ütle meile, kas sa oled Messias, Jumala Poeg!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","„Seda ütlesid sina,“ vastas Jeesus. „Ja ma ütlen sulle ka seda, et tulevikus näed sa inimese Poega Kõigeväelise paremal käel istumas ja taeva pilvede peal tulemas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Siis käristas ülempreester oma rõivad lõhki ja ütles: „Ta teotab Jumalat! Milleks on meil üldse tunnistajaid vaja? Vaadake, nüüd olete ise tema jumalateotust kuulnud! ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Missugune on teie otsus?“ „Süüdi! Ta on surma väärt!“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Siis nad sülitasid talle näkku ja peksid teda. Mõned lõid teda käega ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ja ütlesid: „Kuuluta meile prohvetlikult, sina „Messias“! Kes sind just lõi?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Samal ajal istus Peetrus väljas hoovis. Üks teenijatüdruk tuli tema juurde ja ütles: „Sina olid ka koos galilealase Jeesusega!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Aga ta salgas seda kõigi ees. „Ma ei tea, millest sa räägid,“ ütles ta. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kui ta läks tagasi hoovi sissepääsu juurde, nägi teda üks teine teenijatüdruk ja ütles sealsetele inimestele: „See mees oli koos Naatsareti Jeesusega.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Taaskord salgas ta seda ja ütles vandega kinnitades: „Ma ei tunne teda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Veidi aja pärast tulid seal seisvad inimesed Peetruse juurde ja ütlesid: „Sa oled kindlasti üks neist. Sinu aktsent reedab sind.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Siis hakkas ta vanduma: „Olgu ma neetud, kui ma valetan! Ma ei tunne seda meest!“ Otsekohe kires kukk. ");
INSERT INTO ekkpkp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Siis meenus Peetrusele, mida Jeesus oli talle öelnud: „Enne kui kukk kireb, salgad sa kolm korda, et sa mind tunned.“ Ta läks välja ja nuttis kibedasti. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Varahommikul pidasid kõik ülempreestrid ja rahvavanemad koos nõu ja otsustasid Jeesuse surma saata. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nad sidusid ta kinni, viisid ära ja andsid üle maavalitseja Pilaatusele. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kui Juudas, kes oli Jeesuse reetnud, nägi, et Jeesus oli surma mõistetud, kahetses ta seda, mida oli teinud, ning andis kolmkümmend hõbemünti ülempreestritele ja vanematele tagasi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","„Ma olen pattu teinud! Olen ära andnud süütu vere!“ ütles ta neile. „Mis on sel meiega pistmist?“ vastasid nad. „See on sinu probleem!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Juudas viskas hõbemündid pühamusse ja lahkus. Ta läks ära ja poos enese üles. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ülempreestrid võtsid hõbemündid ja ütlesid: „See on vereraha, nii et ei ole seaduslik seda templi varakambrisse panna.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nii leppisid nad kokku, et ostavad pottsepa põllu kohaks, kuhu matta võõramaalasi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Sellepärast nimetatakse seda välja veel tänapäeval Verepõlluks. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Sellega täitus Jeremija kaudu esitatud prohvetikuulutus: „Nad võtsid kolmkümmend hõbemünti − selle inimese „väärtuse“, kes osteti mõnede Iisraeli laste määratud hinnaga − ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ja kasutasid neid, et maksta pottsepa põllu eest, täpselt nii nagu Issand käskis mul teha.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jeesus viidi maavalitseja Pilaatuse ette, kes küsis temalt: „Kas sina oled juutide kuningas?“ „Seda ütlesid sina,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Aga kui ülempreestrid ja vanemad tema vastu süüdistusi esitasid, siis Jeesus ei vastanud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","„Kas sa ei kuule, kui palju süüdistusi neil sinu vastu on?“ küsis Pilaatus talt. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kuid Jeesus ei öelnud midagi, ei ühtki sõna. See üllatas maavalitsejat väga. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Maavalitsejal oli tava vabastada rahvale pühade ajal vang, keda nad tahavad. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sel ajal oli vanglas kurikuulus vang, mees nimega Barabas. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nii küsis Pilaatus kokku tulnud rahvahulgalt: „Keda te tahate, et ma teile vabaks lasen? Barabase või Jeesuse, keda nimetatakse Messiaks?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(Ta oli mõistnud, et Jeesus oli tema ette kohtumõistmiseks toodud kadeduse tõttu.) ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sel ajal kui ta istus kohtunikutoolil, saatis tema naine talle sõnumi, milles ütles: „Ära tee sellele süütule mehele midagi, sest ma olen täna unenäo tõttu tema pärast kohutavalt kannatanud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kuid ülempreestrid ja vanemad veensid rahvast küsima Barabast ja laskma Jeesus hukata. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kui maavalitseja küsis neilt: „Kumma neist kahest te tahate vabaks saada?“, vastasid nad: „Barabase.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","„Mida ma teen siis Jeesuse, Messiaga?“ küsis ta neilt. Nad kõik karjusid: „Lase ta risti lüüa!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","„Miks? Mis kuriteo ta siis on teinud?“ küsis Pilaatus. Aga nad karjusid veel valjemini: „Löö ta risti!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kui Pilaatus nägi, et asi on lootusetu ja et tekkimas on mäss, võttis ta vett ja pesi rahva ees käsi. „Mina olen selle mehe verest puhas. See tuleb teie pea peale!“ ütles ta neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kogu rahvas vastas: „Olgu tema veri meie ja meie laste peal!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Siis laskis ta neile Barabase vabaks, kuid Jeesust lasi ta piitsutada ja saatis ristilöömisele. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Maavalitseja sõdurid viisid Jeesuse pretooriumi ja kogu salk ümbritses teda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nad võtsid ta alasti ja panid talle sarlakpunase mantli õlgadele. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nad tegid okaspõõsast krooni ja asetasid talle pähe ning pistsid tema paremasse kätte kepi. Nad põlvitasid tema ette maha ja pilkasid teda, öeldes: „Me tervitame sind, juutide kuningas!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nad sülitasid tema peale, võtsid kepi ja peksid teda sellega vastu pead. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kui nad olid tema mõnitamise lõpetanud, võtsid nad kuue ära ja pandi talle tema enda rõivad selga tagasi. Siis viisid nad ta ära, et ta risti lüüa. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Teel leidsid nad mehe nimega Siimon, kes oli Küreenest pärit, ja sundisid teda Jeesuse risti kandma. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kui nad jõudsid Kolgatale, mis tähendab „Pealuu ase“, ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","andsid nad talle sapiga segatud veini. Aga kui ta oli seda maitsnud, keeldus ta seda joomast. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pärast seda kui nad olid ta risti löönud, veeretasid nad täringuid, et tema riided omavahel ära jaotada. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Siis istusid nad maha ja valvasid teda seal. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nad panid ta pea kohale sildi tema vastu esitatud süüdistusega. Sildil oli kirjas: „See on Jeesus, juutide kuningas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Koos temaga lõid nad risti kaks kurjategijat, ühe temast paremale ja teise temast vasakule. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Möödujad karjusid talle solvanguid ja ütlesid pead raputades: ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","„Sina, kes sa lubasid templi hävitada ja kolme päevaga üles ehitada, miks sa ennast ei päästa? Kui sa tõesti oled Jumala Poeg, siis tule risti pealt maha.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ülempreestrid pilkasid teda samamoodi koos vaimulike õpetajate ja vanematega. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","„Teisi inimesi ta päästis, aga ennast ta ei suuda päästa!“ ütlesid nad. „Kui ta tõesti on Iisraeli kuningas, tulgu ta risti pealt maha ja siis me usume teda! ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ta usaldab Jumalat nii veendunult − las siis Jumal päästab ta nüüd, kui tahab, sest ta väitis: „Ma olen Jumala Poeg.““ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kurjategijad, kes olid koos temaga risti löödud, solvasid teda samamoodi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Keskpäevast kuni kella kolmeni kattis kogu riiki pimedus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Umbes kella kolme ajal karjus Jeesus valju häälega: „Eli, Eli, lama sabachthani?“, mis tähendab: „Mu Jumal, mu Jumal, miks sa oled mind maha jätnud?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kui mõned seal seisjaist seda kuulsid, ütlesid nad: „Ta kutsub Eelijat!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Otsekohe jooksis üks neist, haaras käsna, kastis selle äädikasse, pani kepi otsa ja andis seda Jeesusele juua. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Aga teised ütlesid: „Jätke ta rahule. Vaatame, kas Eelija tuleb teda päästma.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jeesus karjatas taas valju häälega ja tegi viimase hingetõmbe. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Täpselt siis kärises templi eesriie ülevalt alla lõhki. Maapind värises, kaljud lõhenesid ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ja hauad avanesid. Paljud neist, kes olid elanud head elu ja surmaunne jäänud, äratati ellu. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pärast Jeesuse ülestõusmist läksid nad surnuaedadest pühasse linna, kus paljud neid nägid. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kui tsentuurio ja need, kes koos temaga Jeesust valvasid, nägid maavärinat ja seda, mis juhtus, olid nad kohkunud ja ütlesid: „See oli tõesti Jumala Poeg!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ka paljud naised jälgisid eemalt, need, kes olid Jeesust Galileast saadik järginud ja olid teda toetanud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nende hulgas olid Maarja Magdaleena, Jaakobuse ja Joosepi ema Maarja ning Sebedeuse poegade ema. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kui saabus õhtu, läks Arimaatiast pärit rikas mees nimega Joosep (kes oli ka Jeesuse jünger) ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilaatuse juurde ja küsis Jeesuse surnukeha. Pilaatus andis korralduse see temale üle anda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Joosep võttis surnukeha ja mähkis selle uude linasesse riidesse ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ning asetas selle oma uude hauda, mis oli kaljusse tahutud. Ta veeratas haua sissepääsu ette suure kivi ja lahkus. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maarja Magdaleena ja teine Maarja istusid seal, haua vastas. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Järgmisel päeval, pärast valmistuspäeva, läksid ülempreestrid ja variserid koos Pilaatuse juurde. ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Nad ütlesid talle: „Isand, meile meenub, et see petis ütles veel elus olles: „Ma tõusen kolme päeva pärast surnuist üles.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Anna korraldus valvata hauda kuni kolmanda päevani. Nii ei saa tema jüngrid tulla ja ta keha varastada ning rahvale öelda, et ta tõusis surnuist üles. Muidu oleks pettus lõpuks hullem kui alguses.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","„Ma annan teile sõdurite vahtkonna,“ ütles Pilaatus neile. „Minge nüüd ja kindlustage seda nii hästi kui võimalik.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nii nad läksid ja kindlustasid haua, panid sissepääsu ees olevale kivile pitseri ja seadsid sõdurid valvepostile. ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pärast hingamispäeva, nädala esimese päeva koidikul, läksid Maarja Magdaleena ja teine Maarja hauda vaatama. ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Äkitselt toimus kohutav maavärin, sest Issanda ingel tuli taevast alla, veeretas kivi ära ja istus selle peale. ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tema nägu lõõmas nagu välk ja tema riided olid valged nagu lumi. ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Valvurid vappusid hirmust ja kukkusid justkui surnuna maha. ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ingel ütles naistele: „Ärge kartke! Ma tean, et te otsite Jeesust, kes löödi risti. ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ta ei ole siin. Ta tõusis surnuist üles, just nagu ta enne ütles. Tulge ja vaadake, kus Issand lamas. ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Minge nüüd kiiresti ja rääkige tema jüngritele, et ta on surnuist üles tõusnud ja et ta läheb teie eel Galileasse. Te näete teda seal, ma luban teile!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nad lahkusid kiiresti haua juurest, olles samaaegselt hirmul ja väga õnnelikud, ning läksid jooksuga jüngritele rääkima. ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Järsku tuli Jeesus neile vastu ja tervitas neid. Nad läksid tema juurde, võtsid tema jalgade ümbert kinni ja kummardasid teda. ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Siis Jeesus ütles neile: „Ärge kartke! Minge ja öelge mu vendadele, et nad läheksid Galileasse, ja seal nad näevad mind.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kui nad lahkusid, läksid mõned valvuritest linna ja jutustasid ülempreestritele kõigest, mis oli juhtunud. ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pärast seda kui ülempreestrid olid vanematega kohtunud ja plaani välja mõelnud, andsid nad sõduritele altkäemaksuks palju raha. ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","„Öelge, et jüngrid tulid öösel ja varastasid ta ära sel ajal, kui meie magasime,“ ütlesid nad sõduritele. ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","„Ja kui maavalitseja sellest kuuleb, siis me räägime temaga ja teil pole vaja muretseda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Niisiis võtsid sõdurid raha ja tegid nii, nagu neile oli öeldud. Seda lugu levitatakse juutide hulgas tänase päevani. ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Aga üksteist jüngrit läksid Galileasse, sellele mäele, kuhu Jeesus oli käskinud neil minna. ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kui nad teda nägid, siis nad kummardasid teda, kuigi mõni kahtles. ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jeesus tuli nende ja juurde ja ütles neile: „Kogu võim taevas ja maa peal on antud mulle. ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nii et minge ja tehke jüngreid kõigist rahvustest inimesi ning ristige neid Isa ja Poja ja Püha Vaimu nimesse. ");
INSERT INTO ekkpkp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Õpetage neid järgima kõiki käske, mille mina olen teile andnud. Pidage meeles, ma olen alati teie juures, maailma lõpuni.“");
INSERT INTO ekkpkp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Sellega algab hea sõnum Jeesusest Kristusest, Jumala Pojast. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Täpselt nagu prohvet Jesaja kirjutas: „Ma läkitan oma käskjala sinu eel sulle teed valmistama. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Hääl hüüab kõrbes: „Valmistage Issandale teed! Tehke sirgeks tema teerajad.““ ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Johannes tuli kõrbesse ristima ja kuulutas meeleparanduse ristimist pattude andeksandmiseks. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kogu rahvas Juudamaalt ja Jeruusalemmast läks tema juurde. Nad tunnistasid avalikult oma patte ja nad ristiti Jordani jões. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Johannese riided olid tehtud kaamelikarvadest ja riiete peal kandis ta nahkvööd. Ta sõi jaanikaunu ja metsmett. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Tema sõnum kõlas nii: „Pärast mind tuleb see, kes on minust suurem. Ma ei ole väärt, et kummarduda ja tema sandaale lahti päästa. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mina ristin teid veega, kuid tema ristib teid Püha Vaimuga.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Siis tuli Jeesus Naatsaretist Galileasse ja Johannes ristis ta Jordani jões. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kui Jeesus veest välja tuli, nägi ta taevast avanevat ja Püha Vaimu tuvi kujul enda peale laskuvat. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Hääl taevast ütles: „Sina oled mu poeg, keda ma armastan. Mul on sinu üle väga hea meel.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kohe pärast seda saatis Vaim ta kõrbesse, ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","kus Saatan teda nelikümmend päeva kiusas. Ta oli koos metsloomadega ja inglid hoolitsesid tema eest. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Hiljem − pärast seda, kui Johannes vangistati − läks Jeesus Galileasse ja kuulutas Jumala head sõnumit. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","„Ettekuulutatud aeg on saabunud,“ ütles ta. „Jumala riik on käes! Parandage meelt ja uskuge head sõnumit.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kui Jeesus kõndis Galilea mere ääres, nägi ta Siimonat ja tema venda Andreast võrku vette heitmas, sest nad teenisid elatist kalapüügiga. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","„Tulge ja järgnege mulle,“ ütles ta neile, „ja ma panen teid inimesi püüdma.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nad jätsid otsekohe oma võrgud sinnapaika ja järgnesid talle. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ta läks veidi edasi ning nägi Jaakobust ja tema venda Johannest − Sebedeuse poegi. Nad olid paadis ja parandasid võrke. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Viivitamatult kutsus ta neid endale järgnema. Nad jätsid oma isa Sebeduse koos palgalistega paati ja järgnesid Jeesusele. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nad suundusid Kapernauma; hingamispäeval läks Jeesus sünagoogi ja õpetas seal. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Rahvas oli tema õpetusest hämmastunud, sest erinevalt nende vaimulikest õpetajatest kõneles ta mõjukalt. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Äkitselt hakkas sealsamas sünagoogis üks kurjast vaimust vaevatud mees karjuma: ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","„Naatsareti Jeesus, miks sa meid tülitad? Kas tulid meid hävitama? Ma tean, kes sa oled! Sa oled Jumala Püha!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jeesus segas kurjale vaimule vahele ja ütles: „Ole vait! Tule temast välja!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kuri vaim kisendas, raputas meest krampidega ja tuli temast välja. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kõik olid juhtunust jahmunud. „Mis see on?“ küsisid nad üksteiselt. „Mis uus õpetus see on, mis on nii mõjuvõimas? Isegi kurjad vaimud kuulavad tema sõna!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Uudis temast levis kiiresti kogu Galilea piirkonnas. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Seejärel lahkusid nad sünagoogist ja läksid koos Jaakobuse ja Johannesega Siimona ja Andrease koju. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Siimona ämm oli palavikuga voodis, nii et nad rääkisid Jeesusele temast. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jeesus läks naise juurde, võttis tal käest kinni ja aitas ta üles. Koheselt lahkus palavik naisest ja ta valmistas neile süüa. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Samal õhtul pärast päikeseloojangut toodi Jeesuse juurde haigeid ja kurjadest vaimudest vaevatuid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kogu linn kogunes maja juurde. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ta tervendas palju mitmesuguste haigustega inimesi ja ajas välja palju kurje vaime. Ta ei lubanud kurjadel vaimudel kõneleda, sest nad teadsid, kes ta on. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Hommikul väga vara, kui oli veel pime, tõusis Jeesus üles ja läks üksinda vaiksesse paika palvetama. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Siimon ja teised läksid teda otsima. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kui nad ta leidsid, ütlesid nad talle: „Kõik otsivad sind.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Aga Jeesus vastas: „Peame minema ümbruskonna teistesse linnadesse, et ma saaksin ka neile head sõnumit rääkida, sest sellepärast ma ju tulingi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nii käis ta läbi kogu Galilea, kõneles sünagoogides ja ajas kurje vaime välja. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Üks pidalitõbine tuli tema juurde abi paluma. See mees põlvitas Jeesuse ette ja ütles: „Palun sind, kui sa tahad, suudad sa mind terveks teha!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kaastundlikult sirutas Jeesus käe, puudutas meest ja ütles: „Ma tahan. Saa terveks!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Pidalitõbi lahkus temast samal hetkel ja mees sai terveks. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jeesus saatis ta minema tõsise hoiatusega. ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","„Vaata, et sa sellest mitte kellelegi ei räägi,“ ütles ta mehele. „Mine preestri juurde ja näita end talle. Too ohver, mis on Moosese seaduses sellise puhtakssaamise korral nõutud, nii et inimestel oleks tõend.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kuid tervekssaanud pidalitõbine läks ja rääkis juhtunust kõigile. Seetõttu ei saanud Jeesus enam avalikult neisse linnadesse minna, vaid pidi jääma maapiirkonda, kuhu rahvas kogu ümbruskonnast tema juurde tuli. ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mõne päeva pärast naasis Jeesus koju Kapernamas ja levis kuuldus, et ta on seal. ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Majja kogunes nii palju rahvast, et see oli tulvil täis, seisti lausa ukse taga, ning Jeesus kuulutas neile sõnumit. ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Neli meest olid toonud kaasa ühe halvatud mehe, ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","kuid nad ei pääsenud rahvahulga tõttu Jeesuse lähedale. Niisiis ronisid nad üles katusele ja võtsid selle lahti. Kui nad olid Jeesuse kohale ava teinud, lasksid nad sealt alla mati, mille peal lamas halvatud mees. ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kui Jeesus nägi nende meeste kindlat usku, ütles ta halvatule: „Sõber, sinu patud on andeks antud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mõned seal istunud vaimulikud õpetajad mõtlesid endamisi: ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","„Miks ta niimoodi räägib? Ta teotab Jumalat! Kes saab patte andeks anda? Ainult Jumal saab seda teha!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jeesus teadis kohe, mida nad mõtlesid. Ta ütles neile: „Miks te nii mõtlete? ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kumb on lihtsam: kas öelda halvatule „Sinu patud on andeks antud“ või „Tõuse üles, võta oma matt ja kõnni? ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aga et veenda teid, et inimese Pojal on õigus patte andeks anda, ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ütlen ma sulle (halvatule): tõuse üles, võta oma matt ja mine koju.““ ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mees tõusis, võttis oma mati ja läks kõigi silme all välja. Kõik olid hämmastunud, ülistasid Jumalat ning ütlesid: „Me ei ole kunagi midagi seesugust näinud!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jeesus läks veel kord välja mere äärde ja õpetas inimesi, kes tema juurde tulid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kui ta kõndis, nägi ta Leevit, Alfeuse poega, maksukoguja putkas istumas. „Järgne mulle,“ ütles Jeesus talle. Leevi tõusis ja järgnes Jeesusele. ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Sel õhtul sõi Jeesus õhtust Leevi majas. Koos Jeesuse ja tema jüngritega tuli sööma palju maksukogujaid ja „patuseid“, sest nende hulgas oli palju neid, kes Jeesusele järgnesid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kui variseride vaimulikud juhid nägid Jeesust selliste inimestega koos söömas, küsisid nad Jeesuse jüngritelt: „Miks ta sööb koos maksukogujate ja patustega?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kui Jeesus seda kuulis, ütles ta neile: „Arsti ei vaja terved, vaid haiged. Ma ei ole tulnud kutsuma neid, kes elavad õigesti, vaid neid, kes ei ela õigesti − patuseid.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Johannese jüngrid ja variserid paastusid. Mõned neist tulid Jeesuse juurde ja küsisid talt: „Miks on nii, et Johannese jüngrid ja variserid paastuvad, kuid sinu jüngrid ei paastu?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","„Kas pulmakülalised paastuvad sel ajal, kui peigmees on nende juures?“ küsis neilt Jeesus. „Ei. Sel ajal kui peigmees on nende juures, ei saa/või nad paastuda. ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Aga tuleb aeg, mil peigmees võetakse nende juurest ära ja siis nad paastuvad. ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Keegi ei pane vanale rõivale paika, mis ei ole vanunud. Muidu uus riidetükk tõmbab vana rõiva peal kokku ja rebib augu suuremaks. ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Keegi ei pane uut veini vanadesse nahklähkritesse. Muidu rebestab vein lähkrid ja nii vein kui ka lähkrid lähevad raisku. Ei, uus vein pannakse uutesse lähkritesse.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ühel hingamispäeval, kui Jeesus läks läbi viljapõllu, hakkasid jüngrid kõndides viljapäid korjama. ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Variserid küsisid Jeesuselt: „Vaata! Miks nad teevad seda, mis on hingamispäeval keelatud?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","„Kas te ei ole kunagi lugenud, mida tegi Taavet, kui temal ja ta meestel oli nälg ja süüa ei olnud?“ küsis Jeesus neilt. ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","„Nad läksid Jumala kotta, kui Ebjatar oli ülempreester, ning sõid pühitsetud leiba, mida ei tohtinud süüa keegi peale preestrite, ning ta andis seda ka oma meestele. ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Hingamispäev tehti teie jaoks, mitte teie hingamispäeva jaoks,“ vastas ta neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","„Niisiis on inimese Poeg hingamispäeva Isand.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jeesus läks taas sünagoogi. Seal oli üks mees, kellel oli vigane käsi. ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Seal oli ka neid, kes jälgisid, kas Jeesus teeb mehe hingamispäeval terveks, sest nad otsisid põhjust, et teda seaduserikkumises süüdistada. ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jeesus ütles vigase käega mehele: „Tule ja seisa siia kõikide ette.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","„Kas hingamispäeval on seaduslik teha head või halba? Kas peaks elu säästma või tapma?“ küsis ta neilt. Kuid nemad ei vastanud sõnagi. ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ta vaatas neid ärritunult ja nende halastamatuse pärast ägestudes. Seejärel ütles ta mehele: „Siruta käsi välja.“ Mees sirutas käe välja ja käsi sai terveks. ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Variserid lahkusid ja hakkasid kohe Heroodese pooldajatega salaplaane pidama, kuidas nad saaksid Jeesuse tappa. ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Vahepeal läks Jeesus tagasi mere äärde ja suur hulk rahvast järgnes talle. Nad olid pärit Galileast, Juudamaalt, ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jeruusalemmast, Idumeast, Jordani-taguselt alalt ning Tüürose ja Siidoni piirkonnast. Nii palju rahvast tuli teda vaatama sellepärast, et nad olid kuulnud kõigest, mida ta teeb. ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jeesus käskis oma jüngritel väikese paadi valmis panna juhuks, kui rahvas talle väga peale tungib, ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","sest ta oli nii paljud terveks teinud, et haiged tunglesid tema poole, et nad saaksid teda puudutada. ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Iga kord kui kurjad vaimud teda nägid, langesid nad tema ette maha ja kisendasid: „Sina oled Jumala Poeg!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kuid ta keelas neil avaldada, kes ta on. ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Seejärel läks Jeesus mägismaale. Ta kutsus need, keda ta soovis, enda juurde, ja nad tulid tema juurde. ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ta valis neist kaksteist, kes oleksid temaga koos, ja nimetas nad apostliteks. Nad pidid olema temaga koos ning ta kavatses nad saata välja head sõnumit kuulutama ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ja nad pidid saama voli kurje vaime välja ajada. ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Need on kaksteist, kelle ta valis: Siimon (kelle ta nimetas Peetruseks), ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedeuse poeg Jaakobus ja tema vend Johannes (kelle kohta ta ütles Boanerges, mis tähendab „kõuepojad“), ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andreas, Filippus, Bartolomeus, Matteus, Toomas, Alfeuse poeg Jaakobus, Taddeus, revolutsionäär Siimon ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ja Juudas Iskariot (kes ta reetis). ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jeesus läks koju, kuid taas kogunes nii suur rahvahulk, et temal ja ta jüngritel ei olnud isegi aega süüa. ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kui Jeesuse perekond sellest kuulis, tulid nad talle järele, öeldes: „Ta on aru kaotanud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ent Jeruusalemma vaimulikud juhid ütlesid: „Ta on Peltsebuli võimuses! Ta ajab kurje vaime välja kurjade vaimude valitseja abil!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Aga Jeesus kutsus nad enda juurde ning näitlikku selgitust kasutades küsis neilt: „Kuidas saab Saatan Saatanat välja ajada? ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kuningriik, mis on iseendaga sõjajalal, ei jää püsima. ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Riidlev leibkond on hukule määratud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kui Saatan on iseendaga riius ja sõjajalal, ei kesta ta kaua − peagi oleks tal lõpp. ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kindel on see, et kui keegi murrab tugeva mehe majja ja üritab tema asju võtta, ei jõua ta röövsaagiga kaugele, kui ta seda tugevat meest kõigepealt kinni ei seo. ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ma räägin teile tõtt: kõik patud ja jumalateotus on võimalik andeks saada, ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","aga kui inimesed teotavad Jumalat sellega, et lükkavad tagasi Püha Vaimu, siis ei saa nad kunagi andeks, sest nad on süüdi igaveses patus.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Jeesus ütles nii sellepärast, et nad ütlesid: „Tal on kuri vaim.“) ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Seejärel jõudsid kohale Jeesuse ema ja vennad. Nad ootasid väljas ja saatsid talle teate, milles palusid tal välja tulla. ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tema ümber istuv rahvas ütles talle: „Sinu ema ja vennad küsivad väljas sinu järele.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","„Kes on mu ema? Kes on mu vennad?“ vastas ta. ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Heitnud pilgu kõigile, kes istusid tema ümber ringis, ütles ta: „Siin on mu ema! Siin on mu vennad! ");
INSERT INTO ekkpkp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kes iganes teeb seda, mis on Jumala tahtmine, on minu vend, õde ja ema.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jeesus hakkas taas mere ääres õpetama. Teda tuli kuulama nii palju rahvast, et ta astus paati ja istus vee peal paadis, sel ajal kui rahvas kuulas teda kaldal. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ta näitlikustas oma õpetusi paljude lugudega. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","„Kuulake,“ ütles ta. „Üks külvaja läks välja külvama. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kui ta külvates seemneid laiali puistas, kukkus osa teerajale, linnud tulid ja sõid seemned sealt ära. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Osa seemneid pudenes kivisele pinnale, kus ei olnud eriti mulda. Madalas mullakihis hakkasid taimed kiiresti kasvama, aga kuna mullakiht ei olnud sügav, ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","kõrvetas päike taimi. Kuna neil ei olnud päris juuri, närbusid taimed peagi. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Osa seemneid pudenes ohakate sekka. Ohakad kasvasid suureks ja lämmatasid tärkava orase, nii et sellest ei tulnud midagi. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Osa seemneid langes heale pinnasele, kus nad idanesid ja kasvasid ning andsid saagiks mõni kolmkümmend, mõni kuuskümmend ja mõni sada korda külvatust rohkem. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kui teil on kuulmiseks kõrvad, siis kuulake, mida ma teile räägin.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kui Jeesus oli omapead, küsisid kaksteist jüngrit ja teised, kes olid koos temaga, mida need võrdlused tähendasid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ta ütles neile: „Teie saate Jumala riigi mõistatusest aru. Kuid kõrvalseisjatel on ainult lood, ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","nii et kuigi nad näevad, nad tegelikult ei „näe“, ja kuigi nad kuulevad, nad ei mõista, muidu pöörduksid nad minu poole ja saaksid andeks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","„Kas te ei saa sellest loost aru?“ küsis Jeesus neilt. „Kui ei saa, kuidas te siis kõigist ülejäänud lugudest aru saate? ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Külvaja külvab sõna. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Seemned rajal, kuhu sõna külvati, kujutavad neid, kes kuulevad sõnumit, kuid siis tuleb kohe Saatan ja võtab ära sõna, mis neisse on külvatud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Samal kombel kujutab kivine pind, kuhu seemned langesid, neid, kes kuulevad sõna ja võtavad selle kohe rõõmuga vastu. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Aga kuna neil ei ole päris juuri, jäävad nad püsima ainult veidikeseks ajaks, kuni tulevad probleemid või tagakiusamine, ja siis langevad nad kiiresti. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ohakate sekka külvatu kujutab neid, kes kuulevad sõna, ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kuid selle maailma mured, rikkuse ahvatlus ja muud segavad asjaolud lämmatavad sõna kasvu ja see ei kanna vilja. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ent heale pinnasele külvatud seemned kujutavad neid, kes kuulevad sõna, võtavad selle vastu ja kannavad vilja, andes kolmkümmend, kuuskümmend ja sada korda rohkem kui külvati. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kes paneb lambi ämbri või voodi alla?“ küsis Jeesus neilt. „Ei, lamp pannakse üles lambijalale. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kõik, mis on varjatud, tuleb ilmsiks ja kõik, mis on salajas, saab avalikuks. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kui teil on kõrvad kuulmiseks, siis kuulake, mida ma räägin! ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Pange tähele seda, mida te kuulete,“ ütles ta neile, „sest teile antakse vastavalt sellele, kui palju tahate vastu võtta, mõõt mõõdu eest. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Neile, kel juba on arusaamine, antakse rohkem, kuid neilt, kes ei taha teada, võetakse ära seegi vähene arusaamine, mis neil on. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jumala riik on nagu mees, kes külvab põllule seemet,“ ütles Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","„Ta läheb magama ja tõuseb varakult üles ja nii iga päev, kuid ta ei tea, kuidas seeme idaneb ja tärkab. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Maa annab saaki iseenesest. Kõigepealt tuleb välja oras, seejärel viljapea ja siis küpse viljaga pea. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kui vili on küps, koristab põllumees selle sirbiga, sest saak on valmis. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Millega võrrelda Jumala riiki? Missugust näidet kasutada?“ küsis ta. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","„See on nagu sinepiseeme − kõige pisem seeme. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Aga kui see maha külvata, siis kasvab sellest taim, mis on suurem kui teised taimed. Selle oksad on piisavalt suured, nii et linnud saavad seal varjus olla.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jeesus kasutas rahvale kõneledes palju selliseid näitlikke lugusid, et nad mõistaksid võimalikult hästi. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Õigupoolest kasutas ta avalikult rääkides üksnes jutustusi, kuid omaette olles selgitas ta oma jüngritele kõike. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Samal päeval hiljem − õhtul − ütles ta oma jüngritele: „Lähme üle mere teisele poole.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jätnud rahvahulga maha, läksid jüngrid koos Jeesusega paati. Nende juures oli veel teisigi paate. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Peagi hakkas möllama kohutav torm, lained paiskusid vastu paati ja lõid vett sisse. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jeesus magas ahtris, pea padjale toetatud. Jüngrid äratasid ta kisendades: „Õpetaja, kas sa ei hooli sellest, et me oleme uppumas?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jeesus ärkas. Ta käskis tuulel vaibuda ja ütles lainetele: „Rahunege! Ärge möllake!“ Tuul vaibus ja vesi jäi täiesti tüüneks. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","„Miks te nii väga kohkusite? Kas te ei ole õppinud mind usaldama?“ küsis ta neilt. ");
INSERT INTO ekkpkp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nad olid jahmunud ja ehmunud. Nad küsisid üksteiselt: „Kes ta ometi on? Isegi tuul ja lained kuuletuvad talle!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nad jõudsid järve teisele kaldale gerasalaste maa-alale. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kui Jeesus astus paadist välja, tuli surnuaialt temale vastu mees, kellel oli kuri vaim. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","See mees elas haudade vahel ning teda ei olnud enam võimalik kinni siduda, isegi mitte ahelatega. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Teda oli sageli pandud ahelaisse ja raudadesse, kuid ta rebis ahelad lihtsalt katki ning purustas käe- ja jalarauad tükkideks. Kellelgi ei olnud jõudu, et temast jagu saada. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Päeval ja ööl kisendas ta haudade vahel ja lähedal asuvates mägedes ning lõikus ennast teravate kividega. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nähes Jeesust kaugelt, jooksis ta vastu ja langes tema ees põlvili. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ta hüüdis valju häälega: „Mis on sul minuga tegemist, Jeesus, kõigevägevama Jumala Poeg? Vannu Jumala nimel, et sa ei piina mind!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Sest Jeesus oli juba käskinud kurjal vaimul mehest lahkuda. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Siis küsis Jeesus temalt: „Mis su nimi on?“ „Mu nimi on Leegion, sest meid on palju!“ vastas ta. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ta anus Jeesust pidevalt, et Jeesus ei saadaks teda kaugele. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Läheduses mäenõlval oli söömas suur seakari. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kurjad vaimud palusid Jeesust: „Saada meid sigadesse, et saaksime nende sisse minna.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jeesus lubas neil seda teha. Kurjad vaimud lahkusid mehest ja läksid sigade sisse. Kogu kari − umbes kaks tuhat siga − tormas järsust kaljust alla merre ja uppus. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Seakarjused jooksid minema ning levitasid seda uudis kõikjal linnas ja maal. Rahvas tuli välja vaatama, et näha, mis oli juhtunud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kui nad leidsid Jeesuse, nägid nad meest, kes oli olnud kurjade vaimude võimuses, sealsamas istumas, riietatult ja täie mõistuse juures − sedasama meest, kellel oli olnud leegion kurje vaime − , ja nad kohkusid! ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Siis need, kes olid näinud, mis juhtus mehega, kes oli olnud kurjade vaimude meelevallas, ja sigadega, jutustasid teistele. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nad hakkasid paluma, et Jeesus nende piirkonnast lahkuks. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kui Jeesus astus paati, siis mees, kes oli olnud kurjade vaimude võimuses, anus, et võiks temaga kaasa minna. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Aga Jeesus keeldus ja ütles talle: „Mine koju omade juurde ja räägi neile, kui palju Issand on sinu heaks teinud ja kuidas ta sinu peale halastas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nii läks see mees oma teed ja hakkas Kümnelinnamaal kuulutama kõigest, mida Jeesus oli tema heaks teinud, ja kõik olid hämmastuses. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jeesus läks paadiga jälle tagasi järve teisele kaldale, kus kogunes tema ümber suur rahvahulk. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tema juurde tuli sünagoogi ülem − mees nimega Jairus. Kui ta Jeesust nägi, langes ta tema jalge ette maha ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ja palus, öeldes: „Minu tütreke on suremas. Palun tule ja pane oma käed tema peale, et ta võiks terveks saada ja elada.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Niisiis läks Jeesus temaga kaasa. Kogu rahvas järgnes, rüseledes ja tõugeldes. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Seal oli üks naine, kes oli kaksteist aastat veritsustõve all kannatanud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ta oli paljude arstide käe läbi märkimisväärselt kannatanud ning kulutanud ära kõik, mis tal oli. Kuid miski ei olnud teda aidanud, õigupoolest oli olukord ainult kehvemaks läinud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ta oli kuulnud Jeesusest, seega tuli ta rahvahulgas tema selja taha ja puudutas tema ülekuube. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ta ütles endale: „Kui ma ainult saan tema kuube puudutada, siis saan ma terveks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Veritsemine lõppes viivitamatult ja ta tundis, et tema keha on haigusest terveks saanud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jeesus, kes tajus kohe, et temast läks vägi välja, pöördus rahvahulgas ümber ja küsis: „Kes puudutas mu kuube?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jüngrid vastasid: „Vaata, kuidas rahvas sulle peale tungib. Mis mõttes sa küsid: kes mind puudutas?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kuid Jeesus vaatas ikkagi ringi, et näha, kes seda tegi. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Naine, kes mõistis, mis temaga oli juhtunud, tuli ja langes tema ette maha ning rääkis talle kogu loo. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","„Mu tütar, sinu kindel usk minusse tegi sind terveks. Mine rahus. Sa oled oma haigusest täielikult tervenenud,“ ütles Jeesus talle. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sel ajal kui ta veel rääkis, tulid mõned inimesed sünagoogi ülema kodust. „Su tütar on surnud,“ ütlesid nad. „Pole enam vaja Õpetajat tüüdata.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Aga Jeesus ei pööranud nende sõnadele tähelepanu. Ta ütles sünagoogi ülemale: „Ära karda, usu lihtsalt minusse.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ta ei võtnud endaga kaasa kedagi, välja arvatud Peetruse, Jaakobuse ja Jaakobuse venna Johannese. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kui nad jõudsid sünagoogi ülema maja juurde, nägi Jeesus segadust ja rahutust, inimesed nutsid ja halisesid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ta läks sisse ja küsis neilt: „Miks te nutate ja halisete? Tüdrukuke ei ole surnud, vaid lihtsalt magab.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nad naersid tema üle põlastavalt. Jeesus käskis kõigil lahkuda. Seejärel läks ta koos lapse isa ja ema ning kolme jüngriga tuppa, kus tüdrukuke lamas. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tüdruku kätt võttes ütles ta: „Talita kuum“, mis tähendab: „Tüdruk, tõuse üles!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tüdruk, kes oli kaheteistkümneaastane, tõusis kohe üles ja hakkas kõndima. Nad olid juhtunust täielikus jahmatuses. ");
INSERT INTO ekkpkp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jeesus keelas neid karmilt, et nad ei räägiks sellest kellelegi, ning käskis tüdrukukesele midagi süüa anda. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jeesus lahkus ja läks koos oma jüngritega koju Naatsaretti. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Hingamispäeval hakkas ta sünagoogis õpetama ja paljud kuulajaist olid üllatunud. „Kust ta need mõtted saab?“ küsisid nad. „Mis tarkus on talle antud? Kust ta saab väe imesid teha? ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kas ta pole mitte see puusepp, Maarja poeg, Jaakobuse, Joosepi, Juuda ja Siimona vend? Kas tema õed ei ela meie juures?“ Nad haavusid ja hülgasid ta. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","„Prohvetist peetakse lugu kõikjal, välja arvatud tema enda kodulinnas, oma sugulaste ja pereliikmete hulgas,“ ütles Jeesus neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Seepärast ei saanud Jeesus teha seal mingeid imetegusid, ta ainult tervendas mõned haiged. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ta oli nende usupuuduse tõttu hämmastunud. Jeesus rändas mööda külasid ja õpetas ringi käies. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ta kutsus kokku kaksteist jüngrit ja hakkas neid kahekaupa välja saatma, andes neile meelevalla kurjade vaimude üle. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ta ütles, et nad ei võtaks peale jalutuskepi midagi kaasa − ei leiba, kotti ega raha vöötaskus. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nad võisid kanda sandaale, kuid ei tohtinud lisasärki kaasa võtta. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","„Kui teid kutsutakse majja, siis jääge sinna kuni lahkumiseni,“ ütles ta neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","„Kui teid vastu ei võeta ega kuulata, siis puistake lahkudes oma jalgadelt tolm maha märgiks, et olete nad nende enda hooleks jätnud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nii nad siis käisid ringi ja käskisid inimestel meelt parandada. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nad ajasid välja palju kurje vaime ning tegid õliga võides terveks palju haigeid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ka kuningas Heroodes kuulis Jeesusest, kuna ta oli tuntuks saanud. Mõned ütlesid: „See on surnuist ülestõusnud Ristija Johannes. Sellepärast tal on nii imelised võimed.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Teised ütlesid: „See on Eelija.“ Veel mõned ütlesid: „Ta on prohvet, nagu üks mineviku prohvetitest.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Aga kui Heroodes sellest kuulis, ütles ta: „See on Johannes, kellel ma pea maha võtsin! Ta on surnuist üles tõusnud!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Sest Heroodes oli andnud korralduse Johannes vahistada ja vangi panna oma venna Filippuse naise Heroodiase pärast, kellega Heroodes oli abiellunud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Johannes oli Heroodesele öelnud: „Oma venna naisega abiellumine on seaduse vastu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Seepärast pidas Heroodias Johannese vastu vimma ja tahtis teda tappa, kuid tal ei olnud võimalik seda korraldada, ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","sest Heroodes teadis, et Johannes on püha mees, kes tegi seda, mis on õige. Heroodes kaitses Johannest ja kuigi Johannese sõnad häirisid teda väga, oli ta ikkagi hea meelega kuulanud, mis Johannesel öelda oli. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Heroodiase võimalus tuli Heroodese sünnipäeval. Heroodes korraldas suure peo ülikutele, sõjapealikutele ja Galilea tähtsatele juhtidele. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Heroodiase tütar tuli sisse ja tantsis neile. Tema esinemine rõõmustas Heroodest ja teisi, kes temaga peol olid, nii väga, et ta ütles neiule: ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","„Palu mult ükskõik mida ja ma annan selle sulle.“ Ta kinnitas oma lubadust vandega: „Ma annan sulle kas või pool oma kuningriigist.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Neiu läks välja ja küsis oma ema käest: „Mida ma peaksin paluma?“ „Ristija Johannese pead,“ vastas ema. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tüdruk kiirustas sisse tagasi ja ütles kuningale: „Ma tahan, et sa annaksid mulle kohe Ristija Johannese pea kandikul.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kuningas oli vapustatud, aga kuna ta oli oma külaliste ees vande andnud, ei tahtnud ta palvest keelduda. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Seega saatis ta kohe timuka Johannese pead tooma. Pärast seda, kui timukas oli vanglas Johannesel pea maha võtnud, ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","tõi ta pea kandikul kohale ja andis selle tüdrukule ning tüdruk andis selle emale. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kui Johannese jüngrid juhtunust kuulsid, tulid nad ja viisid tema keha hauakambrisse. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apostlid tulid tagasi ja kogunesid Jeesuse ümber. Nad rääkisid talle kõigest, mida nad olid teinud ja õpetanud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","„Tulge minuga, oleme omapead. Lähme vaiksesse kohta ja puhkame veidi,“ ütles Jeesus neile, sest tulijaid ja minejaid oli nii palju, et neil ei olnud isegi aega süüa. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nii läksid nad paadiga vaiksesse kohta, et omapead olla. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Aga rahvas nägi neid lahkumas ja tundis nad ära. Seega jooksis rahvas kõigist ümbruskonna linnadesse ette ja jõudis enne neid kohale. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kui Jeesus paadist välja tuli ja suurt rahvahulka nägi, tundis ta neile kaasa, sest nad olid nagu karjaseta lambad. Nii hakkas ta neile paljudest asjadest õpetama. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Päev kaldus õhtusse ning jüngrid tulid Jeesuse juurde ja ütlesid talle: „Me oleme küladest kaugel ja aeg on juba hiline. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Sa peaks rahvale ütlema, et nad läheksid ja ostaksid küladest ja maakoha elanikelt endale midagi süüa.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ent Jeesus vastas: „Andke teie neile midagi süüa.“ „Mida? Kõigile neile inimestele leiva ostmiseks oleks meil vaja rohkem kui kuue kuu palka,“ vastasid jüngrid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","„Kui palju leiba teil siis on?“ küsis Jeesus. „Minge ja vaadake.“ Nad läksid ja uurisid ning ütlesid talle: „Viis leiba ja paar kala.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jeesus käskis kõigil rühmade kaupa rohelisele murule maha istuda. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nad istusid sajastes ja viiekümnestes rühmades. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Seejärel võttis Jeesus viis leiba ja kaks kala. Taeva poole vaadates õnnistas ta toitu ja murdis leiva tükkideks. Siis andis ta leiva jüngritele, et nad annaksid rahvale, ning jagas neile kõigile ka kala. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kõik sõid, kuni kõht sai täis. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Siis kogusid nad leiva ja kala jäägid kokku − kaksteist korvitäit. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Toidust sai söönuks viis tuhat meest ja nende perekonnad. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kohe pärast seda käskis Jeesus jüngritel minna tagasi paati. Nad pidid suunduma järve teisel kaldal asuvasse Betsaidasse, Jeesus saatis sel ajal rahva laiali. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kui ta oli inimestega hüvasti jätnud, läks ta üles mägedesse palvetama. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Hiljem samal õhtul oli paat keset järve, sel ajal kui Jeesus oli veel üksinda maal. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ta nägi, kuidas lained paati hüpitasid, kui nad tugevalt aerutasid, sest tuul puhus vastu. Varahommikustel tundidel tuli Jeesus nende juurde vett pidi kõndides. Ta oleks võinud neist mööda minna, ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","aga kui nad nägid teda vett pidi kõndimas, pidasid nad teda lummutiseks. Nad karjusid, ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","sest nad kõik nägid teda ja olid väga kohkunud. Jeesus ütles neile kohe: „Ärge kartke, see olen mina! Ärge kohkuge!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ta läks nende juurde ja ronis paati ning tuul vaibus. Nad olid täiesti rabatud, ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","sest nad ei olnud oma kangekaelse, põikpäise hoiaku tõttu toidu jagamise ime tähendust mõistnud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pärast mere ületamist jõudsid nad Genneesaretti ja panid paadi ankrusse. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kui nad välja ronisid, tundsid inimesed otsekohe Jeesuse ära. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nad jooksid kogu piirkonda laiali, et tuua kõik haiged mattidel sinna, kus nad olid kuulnud Jeesuse olevat. ");
INSERT INTO ekkpkp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kuhu iganes Jeesus läks − küladesse, linnadesse või maapiirkonda −, toodi haiged turuplatsidele ja paluti, et Jeesus laseks haigetel kas või oma rõivaserva puudutada. Kõik, kes teda puudutasid, said terveks. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Variserid ja vaimulikud juhid, kes olid tulnud Jeruusalemmast alla, et Jeesusega kohtuda, ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","märkasid, et mõned tema jüngritest sõid „ebapuhaste“ (pesemata) kätega. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Variserid ja ükski juut ei söö enne, kui on oma esivanemate traditsiooni järgides käsi pesnud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Samuti ei söö nad turult tulles enne, kui on pesnud. Nad järgivad veel paljusid muidki rituaale, näiteks kruuside, kannude ja kastrulite pesemine.) ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nii küsisid variserid ja vaimulikud juhid Jeesuselt: „Miks ei järgi sinu jüngrid meie esivanemate traditsiooni? Nad söövad toitu ebapuhaste kätega.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jeesus vastas: „Jesajal oli teie, silmakirjatsejate, suhtes õigus, kui ta ütles: „See rahvas ütleb, et austab mind, kuid oma mõtetes on nad minust kaugel. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nende jumalateenistusel ei ole mingit mõtet, sest see, mida nad doktriinidena õpetavad, on üksnes inimeste reeglid.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Te eirate Jumala seadust ja järgite selle asemel hoolikalt hoopis inimeste traditsioone,“ rääkis ta neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","„Kui osavalt te jätate Jumala seaduse kõrvale, et saaksite vääramatult kinni pidada oma traditsioonidest! ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mooses ütles: „Austa oma isa ja ema“ ja „Kes iganes oma isa või ema neab, peab surema“. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Aga teie ütlete, et kui keegi ütleb oma isale või emale: „Kõik, mille sa oleks võinud minult saada, on nüüd korban,“ (see tähendab Jumalale pühendatud), ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","siis ei luba te tal enam edaspidi oma ema ja isa heaks midagi teha. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Selle traditsiooni kaudu, mida te edasi annate, teete Jumala sõna tühiseks ja kehtetuks. Te teete veel palju selliseid asju.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jeesus kutsus rahva jälle enda juurde ja ütles neile: „Palun kuulake mind ja saage aru. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ebapuhtaks ei tee see, mis on väljas ja läheb sisse. Ebapuhtaks teeb see, mis tuleb välja.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Siis läks Jeesus sisse, et rahvahulga eest pääseda, ja tema jüngrid küsisid talt selle illustratsiooni kohta. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","„Kas ka teie ei saa aru?“ küsis ta neilt. „Kas te ei mõista, et see, mida te sööte, ei tee teid ebapuhtaks? ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","See ei lähe teie mõistusesse, vaid kõhtu ja väljub siis ihust. Nii on kogu toit tseremoniaalselt puhas. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ebapuhtaks teeb see, mis teist välja tuleb. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Seestpoolt, inimese mõistusest, tulevad kurjad mõtted: seksuaalne ebamoraalsus, vargused, mõrvad, abielurikkumine, ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ahnus, õelus, valelikkus, sündsusetus, kadedus, laim, uhkus, hoolimatus − ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","kõik need pahed tulevad seestpoolt ja rüvetavad inimese.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Siis Jeesus lahkus ja läks Tüürose piirkonda. Ta ei tahtnud, et keegi teaks, et ta seal viibib, kuid ta ei suutnud seda saladuses hoida. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kui naine, kelle väikesel tütrel oli kuri vaim, kuulis Jeesusest, tuli ta kohe ja langes Jeesuse jalgade ette. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","See naine oli kreeklanna, sündinud Sürofoiniikias. Ta palus, et Jeesus ajaks tema tütrest kurja vaimu välja. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","„Kõigepealt peavad lapsed saama kõhu täis süüa,“ vastas Jeesus. „Ei ole õige võtta laste toit ja visata see koertele.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","„Õige, isand,“ kostis naine, „aga isegi koerad laua all söövad lastest järelejäänud raasukesi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jeesus ütles talle: „Tänu sellisele vastusele võid sa minna − kuri vaim on su tütrest lahkunud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Naine läks koju ja leidis lapse voodis lamamas, kuri vaim aga oli ära läinud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tüürose piirkonnast lahkudes läks Jeesus läbi Siidoni ja seejärel Galilea mere äärde ja Kümnelinnamaale. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Seal toodi tema juurde kurt mees, kes ei suutnud ka korralikult rääkida. Toojad palusid Jeesusel meest oma käega puudutada ja ta terveks teha. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kui Jeesus oli mehe rahvast eemale viinud, pani ta oma sõrmed kurdi mehe kõrvadesse. Seejärel puudutas ta mehe keelt süljega. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jeesus vaatas üles taevasse ja ütles ohates: „Effata,“ mis tähendab: „Avane!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mehe kõrvad avanesid, tema kõnehäire oli kadunud ja ta hakkas korralikult rääkima. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jeesus keelas rangelt sellest kellelegi rääkida, aga mida enam ta keelas, seda rohkem uudis levis. ");
INSERT INTO ekkpkp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Rahvas oli äärmiselt hämmastunud ja ütles: „Kõik, mida ta teeb, on imestusväärne. Ta paneb isegi kurdid kuulma ja tummad rääkima.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Umbes sel ajal oli seal suur rahvahulk, kellel ei olnud midagi süüa. Jeesus kutsus jüngrid enda juurde ja ütles neile: ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","„Mul on rahvast kahju, sest nad on minu juures olnud juba kolm päeva ja neil ei ole midagi süüa. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kui saadan nad ilma toiduta koju, nõrkevad nad teel ära. Mõned on väga kaugelt tulnud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","„Kust võiks siin tühermaal leida piisavalt leiba, et neid kõiki toita?“ küsisid jüngrid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","„Mitu leiba teil on?“ küsis Jeesus. „Seitse,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jeesus käskis rahval maha istuda. Seejärel võttis ta seitse leiba ja tänas. Ta murdis leiba ja andis tükid jüngritele, et nemad rahvale annaksid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Neil olid ka mõned kalad. Kui Jeesus oli neid õnnistanud, ütles ta: „Võtke ja jagage ka need.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Rahvas sõi, kuni kõht sai täis, ja siis koguti kokku seitse korvitäit jääke. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Seal oli neli tuhat inimest. Kui Jeesus oli rahva ära saatnud, ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","astus ta koos jüngritega paati ja läks Dalmanuuta piirkonda. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Variserid tulid sinna ja hakkasid temaga vaidlema; nad tahtsid, et ta annaks neile imelise märgi taevast, et end neile tõestada. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jeesus ohkas sügavalt ja küsis: „Miks tahate teie, rahvas, märki? Ma räägin teile tõtt: ma ei anna teile märki.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nii jättis ta nad maha, astus paati ja läks üle järve. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kuid jüngrid olid unustanud leiba kaasa võtta. Kõik, mis neil paadis oli, oli üks leib. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","„Ettevaatust, hoiduge variseride ja Heroodese juuretise eest!“ hoiatas ta neid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","„Ta ütleb seda sellepärast, et meil ei ole leiba,“ järeldasid jüngrid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jeesus teadis, mida nad räägivad, ja ütles: „Miks te räägite, et teil ei ole leiba? Kas te ikka veel ei mõtle ega saa aru? Kas olete oma mõistuse sulgenud? ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Teil on silmad, et näha, eks ole? Ja kõrvad, et kuulda? ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kas teil ei ole meeles see, kui ma jagasin viis leiba viiele tuhandele? Mitu korvitäit jääke te kokku korjasite?“ „Kaksteist,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","„Ja seitse leiba jagasin neljale tuhandele. Mitu korvitäit jääke te kokku korjasite?“ „Seitse,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","„Kas te ei saa ikka veel aru?“ küsis ta neilt. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nad läksid Betsaidasse, kus Jeesuse juurde toodi pime mees. Toojad palusid, et Jeesus puudutaks teda ja tervendaks ta. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jeesus võttis pimeda mehe käe kõrvale ja viis ta külast välja. Jeesus sülitas mehe silmadele ja puudutas teda kätega. Seejärel küsis Jeesus temalt: „Kas sa näed midagi?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mees vaatas ringi ja ütles: „Ma näen inimesi, aga nad paistavad nagu kõndivad puud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nii puudutas Jeesus veel kord mehe silmi. Nüüd nägi ta korralikult − ta oli tervendatud ja nägemine oli selge. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jeesus saatis mehe koju ja ütles talle: „Ära mine tagasi läbi küla.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jeesus ja tema jüngrid lahkusid, et minna Filippuse Kaisarea küladesse. Teel küsis ta oma jüngritelt: „Mida inimesed ütlevad selle kohta, kes ma olen?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","„Mõned ütlevad, et Ristija Johannes, mõned, et Eelija, teised ütlevad, et üks prohvetitest,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","„Aga kes ma teie arvates olen?“ küsis ta neilt. „Sina oled Messias!“ vastas Peetrus. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jeesus hoiatas neid, et nad ei räägiks temast kellelegi. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Siis hakkas Jeesus neile selgitama, et inimese Poeg peab palju kannatama ning et vanemad, ülempreestrid ja vaimulikud õpetajad hülgavad ta. Ta tapetakse, kuid ta tõuseb kolme päeva pärast surnuist üles. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jeesus selgitas seda neile väga selgelt, kuid Peetrus viis Jeesuse kõrvale ja hakkas teda räägitu pärast noomima. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jeesus pöördus ümber ja jüngreid vaadates noomis Peetrust: „Tagane minust, saatan,“ ütles ta. „Sa ei mõtle nii, nagu mõtleb Jumal, vaid nagu inimesed.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jeesus kutsus rahva ja oma jüngrid enda juurde ja rääkis neile: „Kui te tahate minu järgi käia, siis peate iseendast loobuma, võtma oma risti ja mind järgima. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kui tahate oma elu säästa, siis kaotate selle, aga kui kaotate oma elu minu ja hea sõnumi pärast, siis säästate selle. ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mis kasu on teil sellest, kui saavutate kogu maailmas kõik, kuid kaotate oma elu? ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mida annaksite vahetuskaubaks oma elu eest? ");
INSERT INTO ekkpkp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kui te häbenete tunnistada mind ja seda, mida ma selle ustavusetu ja patuse rahva ees räägin, siis häbeneb inimese Poeg tunnistada teid, kui ta tuleb oma Isa hiilguses koos pühade inglitega.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jeesus ütles neile: „Ma ütlen teile tõtt: mõni neist, kes siin seisab, ei sure enne, kui näeb Jumala riigi võimsat tulekut.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kuue päeva pärast võttis Jeesus Peetruse, Jaakobuse ja Johannese endaga kaasa ja viis nad kõrgele mäele, et omaette olla. Tema välimus muutus täiesti. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tema riided särasid erevalgelt, valgemalt, kui keegi maa peal suudab riiet pleegitada. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Siis ilmusid nende ette ka Eelija ja Mooses ning vestlesid Jeesusega. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peetrus hakkas rääkima ja ütles: „Rabi, meil on siin nii hea olla! Peaksime varjualused tegema − ühe sinule, ühe Moosesele ja ühe Eelijale.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Tegelikult ei teadnud ta, mida öelda, sest nad kõik olid väga kohkunud!) ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Siis kattis neid pilv ja pilvest kostis hääl, mis ütles: „See on minu Poeg, keda ma armastan. Kuulake teda!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Seejärel, kui nad jälgisid, ei olnud järsku enam kedagi. Ainult Jeesus oli nendega koos. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kui nad mäe otsast alla tulid, ütles Jeesus, et nad ei räägiks nähtust mitte kellelegi enne, kui nad on näinud inimese Poja surnuist üles tõusvat. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nad jätsid selle enda teada, kuid nad vaidlesid omavahel, mida tähendas surnuist üles tõusmine. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","„Miks väidavad vaimulikud õpetajad, et kõigepealt peab tulema Eelija?“ küsisid nad tema käest. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","„Tõsi on, et Eelija tuleb kõigepealt, et kõik ette valmistada,“ vastas Jeesus. „Aga miks siis öeldakse Pühakirjas, et inimese Poeg peab nii palju kannatama ja teda põlatakse? ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Aga ma ütlen teile, et Eelija on tulnud ja nad ahistasid teda, kuidas tahtsid, just nad Pühakiri ette kuulutas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kui nad teiste jüngrite juurde tagasi jõudsid, nägid nad, et nende ümber oli suur rahvahulk ja mõned vaimulikud õpetajad vaidlesid nendega. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kohe kui rahvas Jeesust nägi, haaras neid täielik aukartus ja nad jooksid teda tervitama. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","„Mille üle te nendega vaidlete?“ küsis Jeesus neilt. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Üks inimene rahva seast vastas: „Rabi, ma tõin oma poja sinu juurde. Tal on kuri vaim, kes ei lase tal rääkida. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kui vaim ta enda võimusesse haarab, heidab ta tema maha, nii et ta ajab suust vahtu välja, kiristab hambaid ja jääb kangeks. Palusin su jüngritel kurja vaimu temast välja ajada, aga nad ei suutnud seda teha.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","„Sina uskmatu rahvas!“ vastas Jeesus. „Kui kaua ma pean siin teie keskel olema? Kui kaua ma pean teid taluma? Tooge ta siia minu juurde!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Niisiis tõid nad ta Jeesuse juurde. Kui kuri vaim nägi Jeesust, heitis ta poisi kohe krampides maha, kus poiss keerles ja ajas suust vahtu välja. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","„Kui kaua tal see juba on?“ küsis Jeesus poisi isalt. „Väikesest peale,“ vastas isa. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","„Vaim heidab ta sageli tulle, et teda surnuks põletada, või vette, et teda ära uputada. Palun halasta meie peale ja aita, kui sa suudad.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","„Miks sa ütled „kui sa suudad“?“ vastas Jeesus. „Kes usub, selle päralt on kõik vägi!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","„Ma usun sinusse,“ hüüdis mees kohe. „Aita, et ma ei oleks uskmatu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jeesus, nähes, et rahvahulk lähenes, käskis kurja vaimu: „Sina, vaim, kes teed inimese kurdiks ja tummaks: ma käsin sul tulla temast välja ja mitte kunagi enam tagasi tulla.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Vaim karjatas ja heitis poisi rasketes krampides maha. Siis tuli vaim poisist välja ja poiss jäi temast maha nagu surnu, nii et paljud arvasid, et ta on surnud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kuid Jeesus võttis poisil käest ja aitas ta üles ning poiss tõusis püsti. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Hiljem, kui Jeesus oli läinud majja sisse, küsisid jüngrid temalt omaette olles: „Miks meie ei suutnud kurja vaimu välja ajada?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","„Seda sugu ei saa muidu välja ajada kui vaid palvega,“ ütles Jeesus neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nad lahkusid ja läksid läbi Galilea. Jeesus ei tahtnud, et keegi teaks, kus ta on, ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","sest ta õpetas oma jüngreid. „Inimese Poeg reedetakse ja antakse ametivõimude kätte,“ rääkis ta neile. „Ta tapetakse, kuid kolme päeva pärast tõuseb ta jälle surnuist üles.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nad ei saanud aru, mida see tähendas, ning nad olid liiga hirmul, et temalt selle kohta küsida. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nad jõudsid Kapernauma ja kui nad olid majas, kus nad peatusid, küsis Jeesus neilt: „Millest te tee peal rääkisite?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Aga nad ei öelnud midagi, sest nad olid vaielnud selle üle, kes on kõige tähtsam. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jeesus istus maha ja kutsus kaksteist jüngrit kokku. „Kui keegi tahab olla esimene, peab ta olema viimane, kõigi teiste teenija,“ rääkis ta neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ta võttis väikese lapse ja pani lapse nende keskele seisma. Siis võttis ta lapse sülle ja kallistas teda ning ütles jüngritele: ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","„Kes iganes võtab sellise lapse minu nimel vastu, võtab vastu mind, ja kes võtab vastu minu, ei võta vastu mind, vaid selle, kes minu on läkitanud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Johannes ütles Jeesusele: „Rabi, me nägime kedagi sinu nimel kurje vaime välja ajamas. Üritasime teda takistada, sest ta ei ole meie hulgast.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","„Ärge takistage teda,“ vastas Jeesus. „Sest mitte keegi, kes teeb minu nimel imetegusid, ei saa samal ajal mind needa. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kes ei ole meie vastu, on meie poolt. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kes iganes annab karikatäie vett minu nimel, sest te kuulute Kristusele, ei jää oma tasust ilma, uskuge mind. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Aga kui keegi sunnib ühe neist väikestest, kes minusse usub, patustama, siis oleks talle parem, kui talle seotaks suur veskikivi kaela ja ta heidetaks merre. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kui su käsi sunnib sind patustama, lõika ta maha! Parem on minna vigasena igavesse ellu kui jõuda mõlema käega Gehennasse, tulle, mida ei saa kustutada. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kui su jalg sunnib sind patustama, lõika ta maha! Parem on minna lombakana igavesse ellu kui jõuda kahel jalal Gehennasse. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kui su silm paneb sind patustama, õngitse ta välja! Parem on minna ainult ühe silmaga Jumala riiki, kui lasta end mõlema silmaga Gehennasse heita, ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","kus uss ei sure ja tuli ei kustu. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kõiki „soolatakse“ tulega. ");
INSERT INTO ekkpkp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sool on hea, aga kui see kaotab oma maitse, kuidas saab see jälle soolaseks? Te peate olema nagu sool ning elama üksteisega rahus.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jeesus lahkus Kapernaumast ning läks Juudamaale ja teisele poole Jordanit. Taas kogunes rahvas tema juurde ja ta õpetas neid nagu alati. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mõned variserid tulid tema juurde. Nad üritasid teda proovile panna küsimusega: „Kas lahutus on seaduspärane?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","„Mida Mooses käskis teha?“ küsis ta vastuseks. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","„Mooses lubas mehel kirjutada lahutustunnistuse ja naise minema saata,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Siis ütles Jeesus neile: „Mooses kirjutas selle määruse teile teie kõva südame tõttu. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kuid alguses, loomisel, tegi Jumal meessoost ja naissoost inimese. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Sellepärast jätab mees maha oma isa ja ema ning ühineb abielus oma naisega ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ja neist kahest saab üks ihu. Nad ei ole enam kaks, vaid üks. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ärgu keegi lahutagu seda, mille Jumal on ühendanud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kui nad olid tagasi majas, hakkasid jüngrid talle selle kohta küsimusi esitama. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","„Iga mees, kes lahutab oma naisest ja abiellub uuesti, rikub abielu oma naisega,“ rääkis ta neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","„Ja kui naine lahutab oma mehest ja abiellub uuesti, rikub ta abielu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mõned tõid oma lapsi Jeesuse juurde, et ta saaks neid õnnistada, kuid jüngrid käskisid neil ära minna ning lapsed Jeesusest eemal hoida. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Aga kui Jeesus nägi, mida nad teevad, sai ta väga pahaseks ja ütles neile: „Laske lastel minu juurde tulla! Ärge takistage neid, sest Jumala riik kuulub sellistele, kes on nagu need lapsed. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ma räägin teile tõtt: igaüks, kes ei võta Jumala riiki vastu nagu laps, ei saa sinna sisse.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ta kallistas lapsi, pani oma käed nende peale ja õnnistas neid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kui Jeesus asutas end teele, tuli üks mees jooksuga ja põlvitas Jeesuse ette maha. „Hea õpetaja, mida ma peaksin tegema, et ma kindlasti igavese elu saaksin?“ küsis ta. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","„Miks sa nimetad mind heaks?“ küsis Jeesus temalt. „Keegi peale Jumala ei ole hea. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Sa tead käske: sa ei tohi tappa, sa ei tohi abielu rikkuda, sa ei tohi varastada, sa ei tohi anda valetunnistust, sa ei tohi petta, sa pead oma isa ja ema austama …“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","„Õpetaja,“ vastas mees, „kõiki neid käske olen ma täitnud lapsest saadik.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jeesus vaatas teda armastusega ja ütles: „Sul on puudu ainult üks asi. Mine ja müü ära kõik, mis sul on, ja anna raha vaestele ning sul on varandus taevas. Siis tule ja järgi mind.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Selle peale vajus mees näost ära ja lahkus väga kurvalt, sest ta oli väga jõukas. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jeesus vaatas ringi ja ütles oma jüngritele: „Jõukad inimesed saavad Jumala riiki ainult suurte raskustega!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jüngrid olid sellest vapustatud. Kuid Jeesus jätkas: „Mu sõbrad, Jumala riiki on raske pääseda. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Lihtsam on kaamelil minna läbi nõelasilma kui rikkal Jumala riiki saada.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jüngrid olid veelgi suuremas segaduses. „Kes siis üldse maa peal päästetud saab?“ küsisid nad üksteiselt. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Neile otsa vaadates vastas Jeesus: „Inimlikust vaatenurgast on see võimatu, aga mitte Jumala jaoks. Jumalal on kõik võimalik.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peetrus hakkas rääkima: „Me oleme kõik maha jätnud, et sind järgida …“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","„Ma räägin teile tõtt,“ vastas Jeesus, „igaüks, kes on minu ja hea sõnumi pärast maha jätnud oma kodu või vennad või õed või ema või isa või lapsed või maa, ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","saab omal ajal vastu sada korda rohkem kodusid ja vendi ja õdesid ja lapsi ja maid, aga ka rohkem tagakiusamist. Tulevases maailmas saavad nad igavese elu. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ent paljudest esimestest saavad viimased ja viimastest esimesed.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nad jätkasid oma teed Jeruusalemma poole ja Jeesus kõndis ees. Jüngrid olid ärevad ja teised järelkäijad hirmul. Nii võttis Jeesus jüngrid kõrvale ja hakkas neile selgitama, mis pidi temaga juhtuma. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","„Me lähme Jeruusalemma,“ rääkis ta neile, „ja inimese Poeg antakse ülempreestrite ja vaimulike õpetajate kätte. Nad mõistavad ta surma ning annavad võõramaalaste kätte. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nad pilkavad teda, sülitavad tema peale, piitsutavad teda ja tapavad ta. Kuid kolme päeva pärast tõuseb ta jälle surnuist üles.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jaakobus ja Johannes, Sebedeuse pojad, tulid tema juurde. „Õpetaja,“ ütlesid nad, „me tahame, et sa teeksid meile seda, mida me sinult palume.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","„Mida te siis tahate, et ma teile teeksin?“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","„Kui sa võidad ja istud oma troonile, siis hoolitse selle eest, et meie istuksime sinu kõrval, üks paremal, teine vasakul pool,“ ütlesid nad talle. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","„Te ei tea, mida te palute,“ vastas Jeesus. „Kas te suudate juua karikast, millest mina joon? Kas te suudate saada ristitud valuristimisega, mida mina kannatan?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","„Jah, me suudame,“ kostsid nad. „Te joote sellest karikast, millest mina joon, ja teid ristitakse sama ristimisega millega mind,“ ütles Jeesus neile, ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","„aga minu määrata ei ole, kes istub minu paremal või vasakul pool. Need kohad on reserveeritud neile, kelle jaoks need on valmistatud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kui ülejäänud kümme jüngrit sellest kuulsid, olid nad Jaakobuse ja Johannese peale pahased. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jeesus kutsus jüngrid kokku ja rääkis neile: „Te mõistate, et need, kellel on võim rahvaste üle, rõhuvad oma rahvast. Valitsejad käituvad nagu türannid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Aga teiega ei ole nõnda. Igaüks teist, kes tahab olla valitseja, peab olema teie teenija, ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ja igaüks, kes tahab olla esimeste hulgas, peab olema teie kõigi ori. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Sest isegi inimese Poeg ei tulnud selleks, et lasta ennast teenida, vaid ise teenima ja andma oma elu lunarahaks paljude eest.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jeesus ja tema jüngrid läksid läbi Jeeriko ning kui nad olid linnast suure rahvahulga saatel lahkumas, istus tee ääres pime kerjus Bartimeus. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kui ta kuulis, et see oli Jeesus Naatsaretist, hakkas ta hüüdma: „Jeesus, Taaveti poeg, halasta mu peale!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Paljud käskisid tal vait olla, aga selle peale hakkas ta veel rohkem hüüdma: „Jeesus, Taaveti poeg, halasta mu peale!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jeesus peatus ja ütles: „Öelge talle, et ta tuleks siia.“ Nii kutsuti ta kohale sõnadega: „Hea uudis! Tõuse üles, ta kutsub sind.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartimeus hüppas püsti, viskas kuue maha ja tormas Jeesuse poole. ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","„Mida sa tahad, et ma sinu heaks teeksin?“ küsis Jeesus talt. „Õpetaja,“ vastas ta Jeesusele, „ma tahan näha!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","„Võid minna. Sinu usk minusse on su tervendanud.“ Kohe suutis Bartimeus näha ja järgis Jeesust tema teel. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kui nad lähenesid Jeruusalemmale ning olid Betfage ja Betaania lähedal Õlimäe kõrval, saatis Jeesus oma jüngritest kaks ette. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ta ütles neile: „Minge eespool olevasse külla. Kohe kui te külla jõuate, leiate kinniseotult ühe sälu, kellega ei ole veel keegi ratsutanud. Päästke ta lahti ja tooge siia. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kui keegi teilt küsib, mida te teete, siis vastake: „Issandal on teda vaja ja ta saadab ta varsti tagasi.““ ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Niisiis asusid nad teele, leidsid tänaval ukse juurde seotud sälu ja päästsid ta lahti. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mõned lähedal seisvad inimesed küsisid: „Miks te selle sälu lahti päästate?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jüngrid vastasid täpselt nii, nagu Jeesus oli käskinud, ja inimesed lasid neil minna. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nad tõid sälu Jeesuse juurde, panid oma ülekuued sälu selga ja Jeesus istus sinna peale. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Paljud inimesed laotasid oma ülekuued tee peale, teised aga panid teele leherikkaid oksi, mille nad põldudelt lõikasid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Need, kes läksid ees, ja need, kes tulid järel, hüüdsid kõik: „Hosanna! Õnnistatud olgu see, kes tuleb Issanda nimel. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Õnnistatud olgu meie isa Taaveti kuningriik, mis on tulemas! Hosanna kõrgustes!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jeesus sisenes Jeruusalemma ja läks templisse. Ta vaatas ümber, pani kõike tähele ja kuna aeg oli hiline, läks ta koos kaheteistkümne jüngriga Betaaniasse tagasi. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kui nad järgmisel päeval Betaaniast lahkusid, oli Jeesusel kõht tühi. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ta nägi eemal lehtedega viigipuud, seepärast läks ta selle juurde, et näha, kas puu küljes on vilja. Aga kui ta kohale jõudis, ei leidnud ta muud kui lehti, sest ei olnud veel viigimarjade aeg. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ta ütles puule: „Et keegi enam kunagi sinu viljast süüa ei saaks.“ Tema jüngrid kuulsid neid sõnu. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nad jõudsid jälle Jeruusalemma ja Jeesus läks templisse. Ta hakkas välja ajama inimesi, kes templis ostsid ja müüsid. Ta lükkas ümber rahavahetajate lauad ja tuvimüüjate toolid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ta takistas kõiki, kes kandsid läbi templi asju. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ta selgitas neile: „Kas Pühakirjas ei ole siis öeldud: „Mu koda nimetatakse palvekojaks kõigile rahvastele“? Aga teie olete selle muutnud röövlikoopaks!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ülempreestrid ja vaimulikud õpetajad kuulsid, mis oli juhtunud, ning üritasid leida võimalust Jeesuse tapmiseks. Aga nad kartsid teda, sest tema õpetused avaldasid kõigile sügavat muljet. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kui saabus õhtu, lahkus Jeesus koos jüngritega linnast. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kui nad järgmisel hommikul tagasi tulid, nägid nad viigipuud, mis oli juurteni ära närtsinud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peetrusele meenus, mida Jeesus oli teinud, ja ta ütles: „Rabi, vaata, viigipuu, mida sa needsid, on ära närtsinud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","„Usu Jumalasse,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","„Usu mind, kui sa ütleksid sellele mäele: „Mine siit ära ja heida end merre“ ja sa ei kahtleks oma südames, vaid oleksid veendunud selles, mida sa ütled, siis see juhtub! ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ma ütlen sulle, et mille pärast iganes sa palvetad, mida iganes sa palud, usu, et sa saad selle, ja nii toimub. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Aga kui sa palvetad ja kui sul on midagi kellegi vastu, anna talle andeks, et su Isa, kes on taevas, võiks ka sulle sinu patud andestada.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nad läksid tagasi Jeruusalemma ja kui ta astus templisse, tulid tema juurde ülempreestrid, vaimulikud õpetajad ja juhid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","„Missuguste volitustega sa seda kõike teed?“ nõudsid nad. „Kes andis sulle õiguse?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","„Lubage, ma esitan teile küsimuse,“ ütles Jeesus neile. „Teie vastake mulle ja mina ütlen, kelle volitusel ma neid asju teen. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Johannese ristimine − kas see oli taevast või inimestest?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nad arutasid seda asja isekeskis. Nad ütlesid: „Kui me ütleme, et see on taevast, vastab ta: „Miks te siis ei uskunud temasse?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Aga kui me ütleme, et see on inimliku päritoluga, siis …“ Nad kartsid rahvast, sest kõik uskusid, et Johannes oli tõeline prohvet. ");
INSERT INTO ekkpkp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Niisiis vastasid nad Jeesusele: „Me ei tea.“ „Siis ma ei ütle, kelle volitusel ma neid asju teen,“ kostis Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Siis hakkas Jeesus kõnelema näitlikke jutustusi kasutades. „Kord oli üks mees, kes istutas viinapuuaia. Ta pani selle ümber tara, kaevas augu surutõrre jaoks ja ehitas valvetorni. Siis andis ta selle mõnedele põllumeestele rendile ja läks reisile. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kui jõudis kätte saagikoristuse aeg, saatis ta ühe oma sulastest rentike juurde, et koguda viinapuuaiast mõned viinamarjad. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Aga nad haarasid temast kinni, peksid teda ja saatsid ta tühje käsi minema. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Siis saatis mees järgmise sulase. Nad peksid teda näkku ja teotasid teda. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ta saatis veel ühe sulase ja selle tapsid nad ära. Ta saatis palju sulaseid veel ning osasid neist nad peksid ja teised tapsid ära. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Lõpuks oli alles jäänud ainult tema poeg, keda ta armastas, ning viimaks saatis ta poja, arvates, et nad tema poega austavad. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kuid põllumehed rääkisid isekeskis: „See on omaniku pärija − kui me ta tapame, saame endale selle, mille tema oleks pärinud!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nii võtsid nad ta kinni ja tapsid ära ning viskasid viinapuuaiast välja. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Mida see viinapuuaia omanik nüüd teeb? Ta tuleb ja tapab ära need põllumehed ning annab viinapuuaia teistele rendile. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kas te ei ole seda Pühakirja teksti lugenud: „Kivi, mille ehitajad kõrvale heitsid, on saanud peamiseks nurgakiviks. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Issandalt on see tulnud ja ilmaime silmale!“?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Juudi juhid üritasid teda kinni võtta, sest nad mõistsid, et näide käis nende pihta, kuid nad kartsid rahvast. Seega jätsid nad ta rahule ja läksid ära. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pärastpoole saatsid nad mõned variserid koos Heroodese pooldajatega Jeesuse juurde, et üritada teda tema sõnade tõttu lõksu püüda. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nad jõudsid kohale ja ütlesid: „Õpetaja, me teame, et sa oled tõtt armastav inimene, sest sa ei hooli seisundist ega positsioonist. Selle asemel õpetad sa Jumala teed kooskõlas tõega. Kas siis on õige maksta maksu Rooma keisrile või mitte? ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kas peaksime maksma või peaksime sellest keelduma?“ Mõistes, kui silmakirjalikud nad olid, küsis Jeesus neilt: „Miks te üritate mind lõksu püüda? Tooge mulle münt näha.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nad andsid talle mündi. „Kelle pilt see on ja kelle kiri?“ küsis Jeesus neilt. „Rooma keisri,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","„Andke siis keisrile tagasi see, mis kuulub keisrile, ja Jumalale see, mis kuulub Jumalale,“ ütles Jeesus neile. Nad olid tema vastusest hämmastuses. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Siis tulid saduserid, kes ei tunnista ülestõusmist, ja esitasid küsimuse: ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","„Õpetaja, Mooses õpetas, et kui mees sureb ja jätab naise lasteta lesena maha, siis peab tema vend naisega abielluma ja naisele oma venna jaoks lapsi andma. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kord oli seitse venda. Esimene abiellus ja suri siis ilma lapsi saamata. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Teine abiellus venna lesega ja suri siis ilma lapsi saamata. Kolmanda vennaga juhtus sama. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tegelikult surid kõik seitse, ilma et oleks lapsi saanud. Lõpuks suri ka see naine. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kelle naiseks ta siis ülestõusmisel saab, sest ta oli kõigi seitsme venna naine olnud?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jeesus kostis neile: „See tõestab, et te eksite ja et te ei tunne Pühakirja ega Jumala väge. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kui surnud üles ärkavad, siis nad ei võta naisi ega lähe mehele. Nad on nagu taeva inglid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Aga mis puutub ülestõusmisse, kas te ei ole lugenud Moosese kirjadest põleva põõsa lugu, kus Jumal kõneles Moosesega ja ütles talle: „Mina olen Aabrahami Jumal ja Iisaki Jumal ja Jaakobi Jumal?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ta ei ole surnute, vaid elavate Jumal. Te olete täiesti eksiteel!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Üks vaimulikest õpetajatest tuli ja kuulis neid vaidlemas. Ta tundis, et Jeesus oli neile hea vastuse andnud. Seega küsis ta: „Missugune on kõigist kõige tähtsam käsk?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jeesus vastas: „Esimene käsk on: „Kuule, Iisrael, meie Jumal Issand on ainus Jumal. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Armasta Issandat, oma Jumalat kogu oma südame, kogu oma vaimu, kogu oma mõistuse ja kogu oma jõuga.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Teine on: „Armasta oma kaasinimest nagu iseennast.“ Neist olulisemat käsku ei ole.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","„Just nii, Õpetaja,“ vastas mees. „See on õige. Nagu sa ütlesid, Jumal on üksainus ja ühtki teist ei ole. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Me peame armastama teda kogu oma südame, kogu oma mõistuse ja kogu oma jõuga ning me peame armastama oma kaasinimest nagu iseennast. See on palju olulisem kui annid ja ohvrid.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jeesus nägi, et ta andis mõistliku vastuse, ning ütles: „Sa ei ole Jumala riigist kaugel.“ Pärast seda ei julgenud enam keegi temale küsimusi esitada. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Templis õpetades küsis Jeesus: „Miks väidavad vaimulikud õpetajad, et Kristus on Taaveti poeg? ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Sest Taavet ise kirjutas Püha Vaimu sisendusel, et Issand ütles minu Issandale: „Istu mu paremale käele, kuni ma panen su vaenlased su jalge alla.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kuna Taavet ise nimetab teda Issandaks, kuidas saab ta olla Taaveti poeg?“ Suur rahvahulk kuulas Jeesuse sõnu suure heameelega. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jeesus jätkas õpetamist ja ütles: „Hoiduge vaimulike õpetajate eest! Neile meeldib käia ringi pikas rüüs ja lasta end turuplatsil lugupidavalt tervitada. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Neile meeldib istuda sünagoogis kõige tähtsamal kohal ja pidusöögil parimal kohal. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nad petavad leskedelt välja selle, mis neil on, ja varjavad paljusõnaliste palvetega seda, missugused inimesed nad tegelikult on. Kohtupäeval saab nende osaks karm hukkamõist.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jeesus istus rahakogumiskasti vastas ja jälgis, kuidas inimesed münte sisse viskasid. Paljud rikkad viskasid sisse pillavalt palju raha. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Siis tuli üks vaene lesknaine ja pani sisse ainult kaks väikest münti. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jeesus kutsus oma jüngrid kokku ja rääkis neile: „Ma räägin teile tõtt: see vaene lesknaine pani sinna sisse rohkem kui kõik ülejäänud kokku. ");
INSERT INTO ekkpkp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kõik nad andsid oma jõukusest, mis neil oli, kuid tema andis oma vaesusest seda, mida tal ei olnud. Ta pani kasti kõik selle, millest ta elama pidi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kui Jeesus oli templist lahkumas, ütles üks jüngritest talle: „Õpetaja, vaata neid massiivseid kive ja suurejoonelisi hooneid!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","„Kas näete kõiki neid uhkeid hooneid?“ vastas Jeesus. „Siin ei jäeta ühtki kivi teise peale. Kõik kisutakse maha.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kui Jeesus istus Õlimäel ja vaatas alla templi poole, küsisid Peetrus, Jaakobus, Johannes ja Andreas omaette olles temalt: ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","„Ütle meile: millal see toimub? Mis on selle kõige täitumise märgiks?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jeesus hakkas neile rääkima: „Ärge laske end petta. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Paljud tulevad minu nimel ja ütlevad: „Mina olen Kristus.“ Nad petavad paljusid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ärge muretsege, kui te kuulete sõdadest lähemal ja kaugemal. Kõik see peab toimuma, kuid see pole lõpp. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Rahvas võitleb rahva vastu ja riik riigi vastu. Paljudes paikades on maavärinaid ja ka näljahädasid. Need on maailma sünnitusvalude algus. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Olge valvel! Teid antakse kohtute kätte. Teid pekstakse sünagoogides. Minu pärast peate seisma valitsejate ja kuningate ees ning te olete neile tunnistajateks. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Head sõnumit peab kõigepealt kuulutatama kõigile rahvastele. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kui teid võetakse kinni ja viiakse kohtusse, siis ärge muretsege sellepärast, mida öelda. Rääkige lihtsalt seda, mida teile siis öeldakse, sest kõnelejaks ei ole teie, vaid Püha Vaim. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Vend annab venna surma ja isa reedab oma lapse. Lapsed pöörduvad oma vanemate vastu ja lasevad nad surma mõista. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kõik vihkavad teid minu pärast, aga kes lõpuni vastu peab, see päästetakse. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Aga kui te näete „ebajumalaid, mis rüvetavad“, seismas seal, kus ei tohiks (saagu lugeja aru), siis peaksid need, kes on Juudamaal, põgenema mägedesse. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Need, kes on katusel − ärge minge tagasi majja sisse midagi võtma. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Need, kes on väljas põllul − ärge minge koju kuube võtma. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kui raske on see nende jaoks, kes tol ajal on lapseootel või last imetamas! ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Palvetage, et see ei juhtuks talvisel ajal. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Sest siis on selline hädaaeg, mida ei ole olnud Jumala loodu algusest kuni tänapäevani ja mida ei tule enam kunagi. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kui Jumal ei lühenda seda aega, ei jää keegi elama. Kuid nende pärast, kelle Jumal on valinud, lühendab ta seda aega. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Niisiis, kui keegi ütleb teile: „Vaata, siin on Messias!“ või „Vaata, ta on seal!“, siis ärge seda uskuge. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sest valemessiaid ja valeprohveteid ilmub välja ning nad teevad imelisi tunnustähti ja imetegusid, et petta ka Jumala valituid, kui see oleks võimalik. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Olge valvel! Ma olen teile rääkinud kõigest, enne kui see toimub. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Pärast neid hädasid toimub järgnev: „Päike läheb pimedaks, kuu ei sära enam, ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","tähed langevad taevast alla ja taeva vägesid kõigutatakse.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Siis nähakse inimese Poega, kui ta tuleb pilvedes suure väe ja hiilgusega. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ta saadab välja inglid ja kogub kokku kõik oma valitud sealt, kus iganes nad on, maailma kõige kaugemast osast kuni taeva kaugeima punktini. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Õppige õppetundi viigipuust. Kui selle okstele tulevad kasvud ja võrsuvad lehed, siis teate, et suvi on lähedal. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Samamoodi on ka siis, kui näete neid asju toimuvat − teadke, et see lähedal, juba ukse ees! ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ma räägin teile tõtt: see põlvkond ei lõpe enne, kuni kõik need asjad on toimunud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Taevas ja maa saavad otsa, kuid minu õpetused mitte. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Mitte keegi ei tea päeva ega tundi, mil see toimub − isegi mitte inglid taevas, isegi mitte Poeg, vaid ainult Isa teab. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Olge valvel! Püsige ärkvel! Sest te ei tea, millal see toimub. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nagu üks mees läks ära reisile. Ta läks oma kodust ära ja andis igale sulasele volitused teha seda, mida ta käskis neil teha. Ta käskis uksehoidjal valvel olla. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Seega olge valvel, sest te ei tea, millal majaomanik tagasi tuleb. See võib olla õhtul, keset ööd, enne koitu või hommikul. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Te ei taha, et teid tabataks magamast, kui ta ootamatult tagasi tuleb. ");
INSERT INTO ekkpkp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Seda, mida ma ütlen teile, ütlen ma kõigile: valvake!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Paasapüha ja hapnemata leibade pühani oli jäänud kaks päeva. Ülempreestrid ja vaimulikud juhid üritasid leida salajast võimalust, et Jeesus kinni võtta ja tappa. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","„Aga mitte paasapüha ajal,“ rääkisid nad isekeskis, „muidu võib rahvas mässama hakata.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Vahepeal oli Jeesus Betaanias ja sõi lauas pidalitõbise Siimona kojas. Üks naine tuli alabasternõuga, milles oli väga kallis ja puhas nardiõli. Ta purustas nõu ja valas õli Jeesusele pea peale. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mõned kohalviibijaist ärritusid ja ütlesid: „Milleks raisata seda parfüümi? ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Selle oleks saanud aastapalga eest maha müüa ja raha vaestele anda.“ Nad olid naise peale pahased. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kuid Jeesus vastas: „Jätke ta rahule! Miks te kritiseerite teda selle eest, et ta teeb minu heaks midagi ilusat? ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Vaeseid on alati teie juures ja te saate neid aidata, millal iganes soovite. Kuid mina ei ole alati teie juures. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ta tegi, mida oskas: ta võidis ennetavalt mu ihu matmise jaoks. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ma räägin teile tõtt: kus iganes maailmas head sõnumit kuulutatakse, meenutavad inimesed seda, mida ta tegi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Siis Juudas Iskariot, üks kaheteistkümnest jüngrist, läks ülempreestrite juurde ja leppis kokku, et annab Jeesuse nende kätte. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kui nad seda kuulsid, olid nad rõõmsad ja lubasid talle tasuda. Nii hakkas Juudas otsima võimalust Jeesust reeta. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Hapnemata leibade püha esimesel päeval, ajal kui paasatall ohverdati, küsisid Jeesuse jüngrid temalt: „Kuhu me peaksime minema sulle paasasöömaaega valmistama?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ta saatis kaks jüngrit ja ütles neile: „Minge linna ja seal näete üht meest veekannu kandmas. Minge tema kannul ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ja kui ta läheb majja sisse, küsige selle omanikult, kus saaksin ma koos oma jüngritega paasapüha tähistada. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ta viib teid suurde ülemise korruse tuppa, mis on sisustatud ja valmis. Saate seal meie jaoks ettevalmistused teha.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jüngrid läksid linna ja leidsid kõik nii, nagu ta oli kirjeldanud. Nad valmistasid paasasöömaaja. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Õhtul läks Jeesus koos kaheteistkümne jüngriga sinna. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kui nad istusid ja sõid, ütles Jeesus: „Ma räägin teile tõtt: üks teist reedab mu. Üks neist, kes praegu minuga koos söövad.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nad olid vapustatud ja igaüks küsis: „Ega see mina pole?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","„See on üks kaheteistkümnest, kes minuga koos sellest toidust osa saab,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","„Inimese Poeg sureb, just nagu Pühakiri ette kuulutas. Aga kui kohutav on see selle inimese jaoks, kes inimese Poja reedab! Sellel inimesel oleks parem, kui ta poleks kunagi sündinud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Söömise ajal võttis Jeesus kätte leiva, õnnistas seda ja andis neile. „Võtke. See on minu ihu,“ ütles ta neile. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Seejärel võttis ta karika, õnnistas seda ja andis neile. Nad kõik jõid selle seest. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","„See on minu veri,“ ütles ta neile, „kokkulepe, mis on välja valatud paljude eest. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ma räägin teile tõtt: ma ei joo viinapuu viljast kuni selle päevani, mil ma joon seda värskelt Jumala riigis.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pärast seda, kui nad olid psalmi laulnud, asusid nad teele Õlimäe poole. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","„Te kõik jätate mu maha,“ ütles Jeesus neile. „Sest nagu Pühakirjas on öeldud: „Ma ründan karjast ja lambad pillutatakse täiesti laiali.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Aga pärast seda, kui ma olen surnuist üles tõusnud, lähen ma teie eel Galileasse.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","„Ma ei jäta sind maha isegi siis, kui kõik teised seda teevad,“ vastas Peetrus. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jeesus lausus talle: „Ma ütlen sulle tõtt, et täna, selsamal ööl, enne kui kukk kaks korda kireb, salgad sa kolm korda, et sa mind üldse tunned.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kuid Peetrus oli täiesti järeleandmatu ja ütles: „Isegi kui pean sinuga koos surema, ei salga ma sind kunagi.“ Kõik nad ütlesid sama. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nad jõudsid paika, mida nimetati Ketsemaniks, kus Jeesus ütles oma jüngritele: „Istuge siin, sel ajal kui mina lähen ja palvetan.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ta võttis Peetruse, Jaakobuse ja Johannese endaga kaasa. Ta muutus väga rahutuks ja murelikuks. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jeesus ütles neile: „Minu ahastus on nii piinarikas, et mul on tunne, et ma suren. Palun jääge siia ja olge valvsad.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ta läks veidi eemale ja langes siis maha. Ta palvetas ja palus, et kui oleks võimalik, säästetaks teda ajast, mis oli tulemas. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","„Abba, Isa! Sina suudad kõike,“ ütles ta. „Palun võta see kannatustekarikas minult ära. Siiski mitte minu tahte järgi, vaid selle järgi, mida sina tahad.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Siis tuli Jeesus tagasi ja leidis jüngrid magamas. „Siimon, kas sa magad?“ küsis ta Peetruselt. „Kas sa ei suutnud ühtki tundi ärkvel püsida? ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ole valvas ja palveta, et sa kiusatusse ei satuks. Vaim on valmis, aga ihu on nõrk.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ta läks veel kord nende juurest ära ja palvetas samade sõnadega. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Seejärel tuli ta tagasi ja leidis nad jälle magamas, sest nad ei suutnud silmi lahti hoida. Nad ei teadnud, mida öelda! ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ta tuli kolmandat korda tagasi ja küsis neilt: „Kas te ikka veel magate? Kas te ikka veel puhkate? Sellest piisab, sest aeg on käes! Vaadake, inimese Poeg antakse kohe patuste kätte. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tõuske üles! Lähme! Näete, sealt tuleb mu äraandja.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kui ta veel rääkis, siis jõudis kohale Juudas − üks kaheteistkümnest jüngrist − koos mõõkade ja nuiadega varustatud jõuguga, kelle olid saatnud ülempreestrid, vaimulikud juhid ja vanemad. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Äraandja oli nendega kokku leppinud märgi: „Ta on see, keda ma suudlen. Võtke ta kinni ja viige valve all minema.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Juudas läks otse Jeesuse juurde. „Rabi,“ ütles ta ja suudles teda armastavalt. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Niisiis haarasid nad Jeesusest ja võtsid ta kinni. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kuid üks sealviibijaist tõmbas oma mõõga välja ja lõi ülempreestri sulast nii, et lõikas tal kõrva maha. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","„Kas ma olen mingi mässaja, et tulite mind mõõkade ja nuiadega kinni võtma?“ küsis Jeesus neilt. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","„Ma olin teiega koos ja õpetasin iga päev templis. Miks te siis mind kinni ei võtnud? Aga kõik see toimub selleks, et Pühakiri täide läheks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Siis jätsid kõik jüngrid Jeesuse maha ja põgenesid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","(Üks tema järelkäijatest oli noor mees, kellel oli seljas üksnes linane rüü. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Nad haarasid temast kinni, kuid ta jooksis minema ja jättis oma rõiva maha.) ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jeesus viidi ülempreestri majja, kuhu olid kogunenud kõik ülempreestrid, vanemad ja vaimulikud õpetajad. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peetrus järgnes talle eemalt ning läks ülempreestri maja hoovi. Ta istus koos valvuritega maha ja soojendas end tule ääres. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sees üritasid ülempreestrid ja kogu kokkutulnud nõukogu leida mingit tõendit, et saaks Jeesuse surma mõista, kuid nad ei suutnud midagi leida. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Paljud andsid tema vastu valetunnistusi, kuid nende väited ei sobinud kokku. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mõned neist tõusid Jeesuse vastu valet rääkima. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","„Me kuulsime teda ütlemas: „Ma hävitan selle templi, mis on inimkätega ehitatud, ning ehitan selle kolme päevaga üles ilma käsi kasutamata.““ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kuid isegi siin ei läinud nende tunnistus ühte. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Siis tõusis ülempreester nõukogu ees püsti ja küsis Jeesuselt: „Kas sul ei ole midagi öelda vastuseks nendele süüdistustele, mis on sinu vastu esitatud?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Aga Jeesus vaikis edasi ega vastanud. Nii küsis ülempreester uuesti: „Kas sina oled Messias, Õndsa Poeg?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","„Jah, olen,“ vastas Jeesus, „ja te näete inimese Poega Kõikväelise paremal käel istumas ning taeva pilvedega tulemas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ülempreester käristas oma riided lõhki ja küsis: „Miks on meil veel tunnistajaid vaja? ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Te kuulsite jumalateotust! Missugune on teie vastus?“ Nad kõik leidsid ta süüdi olevat ja mõistsid ta surma. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Siis hakkasid mõned neist tema peale sülitama. Keegi sidus tal silmad kinni, lõi teda rusikatega ja ütles: „Kuuluta siis meile prohvetlikult, „prohvet“!“ Valvurid viisid ta ära ja peksid ta vaeseomaks. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Samal ajal oli Peetrus all õues. Üks ülempreestri teenijatüdrukutest möödus ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ja nähes Peetrust end soojendamas, vaatas talle otsa ja ütles: „Sina olid ka koos Naatsareti Jeesusega!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kuid Peetrus salgas seda. „Ma ei tea, millest sa räägid või mida sa mõtled,“ vastas ta. Seejärel läks ta välja eesõue ja kukk kires. ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Teda seal nähes kordas teenijatüdruk ümberolijatele: „See mees on üks neist!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Taas kord eitas Peetrus seda. Veidi hiljem öeldi Peetrusele uuesti: „Sa oled kindlasti üks neist, sest ka sina oled galilealane!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Peetrus kutsus taeva enda tunnistajaks ja vandus: „Ma ei tunne seda meest, kellest te räägite.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Samal hetkel kires kukk teist korda. Siis meenus Peetrusele, mida Jeesus oli talle öelnud: „Enne kui kukk kaks korda kireb, salgad sina mind kolm korda.“ Kui ta mõistis, mida ta oli teinud, puhkes ta nutma. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Järgmisel hommikul vara jõudsid ülempreester, vanemad ja vaimulikud õpetajad − kogu valitsev nõukogu − otsusele. Nad lasid Jeesuse kinni siduda ja saatsid ta minema, et anda ta üle Pilaatusele. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilaatus küsis temalt: „Kas sina oled juutide kuningas?“ „Seda ütlesid sina,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ülempreestrid jätkasid tema vastu paljude süüdistuste esitamist. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilaatus küsitles teda uuesti: „Kas sa ei kavatsegi vastata? Näed, kui palju süüdistusi nad sinu vastu esitavad!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Aga Pilaatuse suureks üllatuseks ei andnud Jeesus enam ühtki vastust. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilaatusel oli tava lasta paasapüha ajal rahvale vabaks üks vang, keda iganes nad soovisid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Üks vangidest oli mees nimega Barabas, kes kuulus ülestõusu käigus mõrva sooritanud mässuliste grupi hulka. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Rahvas läks Pilaatuse juurde ja palus tal vabastada vang vastavalt tema tavalisele kombele. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","„Kas tahate, et lasen teile vabaks juutide kuninga?“ küsis ta neilt, ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","sest ta mõistis, et ülempreestrid olid Jeesuse tema juurde toonud kadedusest Jeesuse vastu. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kuid ülempreestrid õhutasid rahvast nõudma temalt hoopis Barabase vabastamist. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","„Mida ma pean siis tegema sellega, keda te nimetate juutide kuningaks?“ küsis ta neilt. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","„Löö ta risti!“ karjus rahvas vastuseks. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","„Miks? Mis kuriteo on ta toime pannud?“ küsis Pilaatus neilt. „Löö ta risti!“ karjusid nad veel valjemini vastu. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Soovides märatsevale rahvahulgale meele järele olla, vabastas Pilaatus neile Barabase. Kõigepealt laskis ta Jeesust piitsutada ja andis ta siis üle ristilöömiseks. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sõdurid viisid ta eemale pretooriumi õue, kuhu kutsuti välja kogu kohort. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Talle asetati õlgadele kuninglik purpurne rüü ja valmistati okaskroon, mis pandi talle pähe. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Siis tervitasid nad teda sõnadega: „Ole tervitatud, juutide kuningas!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nad lõid teda korduvalt kepiga vastu pead, sülitasid tema peale ja langesid tema ette põlvedele nagu kummardades. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kui nad olid tema pilkamise lõpetanud, võtsid nad ära purpurrüü ja panid talle tema enda riided selga tagasi. Siis viisid nad ta ära ristilöömiseks. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nad sundisid möödujat, Siimonat Küreenest, kes oli maalt linna tulemas, tema risti kandma. Siimon oli Aleksandri ja Rufuse isa. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jeesus viidi paika, mida nimetati Kolgataks, mis tähendab „Pealuu ase“. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nad pakkusid talle mürriga segatud veini, kuid ta keeldus sellest. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Siis lõid nad ta risti. Nad jaotasid tema riideid ja heitsid täringuid, et otsustada, kes mida saab. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","See oli hommikul kella üheksa ajal, kui nad ta risti lõid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tema vastu esitatud süüdistusega sildil oli kirjas: „Juutide kuningas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Temaga koos löödi risti kaks kurjategijat, üks temast vasakule ja teine paremale. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Möödujad karjusid talle solvanguid, raputasid pead ja ütlesid: „Ahaa! Sina, kes sa väitsid, et hävitad templi ja ehitad selle kolme päevaga üles, ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","päästa ennast ja astu ristilt maha!“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Samamoodi pilkasid teda ülempreestrid ja vaimulikud juhid ning ütlesid üksteisele: „Teisi ta päästis, aga ennast ei suuda ta päästa. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kui ta tõesti on Messias, Iisraeli kuningas, siis miks ei astu ta ristilt alla, et me näeksime ja usuksime!“ Isegi need, kes olid koos temaga risti löödud, solvasid teda. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Keskpäeval langes kogu maale pimedus kuni kella kolmeni pärastlõunal. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kella kolme ajal karjatas Jeesus: „Eloi, Eloi, lama sabahtani,“ mis tähendab: „Mu Jumal, mu Jumal, miks sa oled mind maha jätnud?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mõned sealseisjaist kuulsid seda ja ütlesid: „Ta kutsub Eelijat.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Üks mees jooksis, täitis käsna äädikaga, pani kepi otsa ja üritas sellega Jeesusele juua anda. „Jätke ta rahule,“ ütles ta. „Vaatame, kas Eelija tuleb teda ristilt maha võtma.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Siis oigas Jeesus valjusti ja suri. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Templi eesriie kärises ülevalt alla kaheks. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kui tsentuurio, kes seisis Jeesuse ees, nägi, kuidas ta suri, ütles ta: „See mees oli tõesti Jumala Poeg.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mõned naised jälgisid eemalt, nende hulgas Maarja Magdaleena, Jaakobus noorema ja Joosese ema Maarja ning Salome. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nad olid järgnenud Jeesusele ja hoolitsenud tema eest, kui ta oli Galileas. Paljud teised naised, kes olid koos temaga Jeruusalemmas olnud, olid ka seal. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Oli reede, päev enne hingamispäeva. Kui jõudis õhtu, ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","siis Joosep Arimaatiast − juhtiva nõukogu liige, kes ootas Jumala riiki − oli nii julge, et läks Pilaatuse juurde ja küsis Jeesuse surnukeha endale. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilaatus oli üllatunud, et Jeesus oli nii kiiresti surnud, seepärast kutsus ta tsentuurio ja küsis temalt, kas Jeesus oli juba surnud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kui Pilaatus oli tsentuuriolt kinnituse saanud, andis ta Joosepile loa surnukeha võtta. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joosep ostis linase kanga. Seejärel võttis ta Jeesuse surnukeha ristilt alla, mähkis linasse ja asetas hauakambrisse, mis oli kaljusse raiutud. Siis veeratas ta sissepääsu ette raske kivi. ");
INSERT INTO ekkpkp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maarja Magdaleena ja Joosese ema Maarja jälgisid, kuhu Jeesuse surnukeha pandi. ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kui hingamispäev oli läbi saanud, võtsid Maarja Magdaleena, Jaakobuse ema Maarja ja Salome healõhnalisi salve, et minna Jeesuse surnukeha võidma. ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nad läksid hauakambri juurde väga vara pühapäeva hommikul, täpselt päikesetõusu ajal. ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nad arutasid isekeskis: „Kes veeretab meie jaoks hauakambri sissepääsu eest kivi ära?“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Aga kui nad kohale jõudsid ja ringi vaatasid, nägid nad, et väga suur ja raske kivi oli juba ära veeretatud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kui nad hauakambrisse sisenesid, nägid nad paremal pool istumas üht noort meest, kel oli seljas pikk valge rüü. Nad kohkusid väga. ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","„Ärge kartke,“ ütles mees neile. „Te otsite Naatsareti Jeesust, kes risti löödi. Ta on surnuist üles tõusnud. Ta ei ole siin. ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Vaadake, siin on koht, kuhu ta puhkama pandi. Minge nüüd ja rääkige tema jüngritele ja Peetrusele, et ta läheb teie eel Galileasse. Te näete teda seal, täpselt nagu ta teile ütles.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nad läksid hauakambrist välja ja jooksid minema, ise värisedes ja segaduses. Nad ei öelnud kellelegi midagi, sest nad olid liiga hirmunud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kui Jeesus tõusis pühapäeva hommikul surnuist üles, ilmus ta kõigepealt Maarja Magdaleenale, kellest ta oli seitse kurja vaimu välja ajanud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maarja läks ja rääkis neile, kes olid Jeesusega koos olnud; nad leinasid ja nutsid. ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kui nad kuulsid, et Jeesus on elus ja et Maarja oli teda näinud, ei uskunud nad seda. ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hiljem ilmus Jeesus erineval kujul kahele jüngrile, kes olid lahkunud, et maale minna. ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nad läksid linna tagasi ja rääkisid teistele, kuid ka neid ei usutud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pärast seda ilmus ta üheteistkümnele jüngrile sel ajal, kui nad sõid. Ta noomis neid nende usupuuduse ja kangekaelsuse pärast, sest nad ei olnud uskunud neid, kes olid teda pärast ülestõusmist näinud. ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Seejärel ütles ta neile: „Minge kogu maailma ja kuulutage head sõnumit kõigile. ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Igaüks, kes minusse usub ja keda ristitakse, see päästetakse, aga igaüks, kes otsustab mitte uskuda, mõistetakse hukka. ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nendega koos, kes minusse usuvad, käivad järgmised tunnustähed: nad ajavad minu nimel kurje vaime välja, nad kõnelevad uutes keeltes; ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","nad suudavad toime tulla madudega; kui nad joovad midagi mürgist, ei saa nad kahju; nad panevad oma käed haigete peale ja haiged saavad terveks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kui Issand Jeesus oli lõpetanud nendega rääkimise, võeti ta üles taevasse, kus ta istus Jumala paremale käele. ");
INSERT INTO ekkpkp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jüngrid läksid välja ja kuulutasid head sõnumit kõikjal ning Issand tegutses nende kaudu ja kinnitas kuulutust sellega kaasnevate imetegudega.");
INSERT INTO ekkpkp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nagu sa tead, on paljud teised üritanud kirja panna seda, mis on täide läinud ja puudutab ka meid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nende jutustused põhinesid esimeste pealtnägijate ja Sõna kuulutajate tõenditel ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ja ka mina otsustasin, et kuna olen kõike seda algusest peale väga hoolikalt jälginud, oleks hea mõte kõigest toimunust kirja panna täpne jutustus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Tegin seda, kallis Teofilos, et sa võiksid olla kindel, et see, mida sulle õpetati, on täiesti usaldusväärne. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sel ajal kui Heroodes oli Juudamaa kuningas, oli üks preester nimega Sakarias, kes oli pärit Abija preesterlikust rühmast. Ta oli abielus Eliisabetiga, kes põlvnes samuti preester Aaronist. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nad mõlemad tegid, mis oli Jumala ees õige, ning järgisid hoolikalt kõiki Issanda käske ja määrusi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Neil ei olnud lapsi, sest Eliisabet ei olnud selleks suuteline, ja nad mõlemad olid juba vanad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kui Sakarias teenis preestrina Jumala ees oma preesterlikus rühmas, ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","valiti ta vastavalt preestrite tavale liisu heitmisega Issanda templisse sisenema ja suitsutusrohtu põletama. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Suitsutusohvri toomise ajal palvetas väljas suur hulk rahvast. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Issanda ingel ilmus Sakariasele ja seisis suitsutusohvrialtari kõrval paremal pool. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kui Sakarias nägi inglit, oli ta rabatud ja hakkas kartma. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Aga ingel ütles talle: „Ära karda, Sakarias! Sinu palvet on kuuldud ja su naine Eliisabet sünnitab sulle poja ja sa pead talle nimeks panema Johannes. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ta toob sulle rõõmu ja heameelt ning tema sünd rõõmustab paljusid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ta saab suureks Issanda silmis. Ta ei joo veini ega muid alkohoolseid jooke. Teda täidab Püha Vaim juba enne sündimist. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ta pöörab paljud iisraellased tagasi Issanda, nende Jumala juurde. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ta läheb Issanda eel Eelija vaimus ja väes, et panna isad taas oma laste peale mõtlema, ning tuua need, kes on mässumeelsed, tagasi õige arusaamise juurde, et valmistada rahvas ette Issanda jaoks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","„Kuidas ma saan selles kindel olla?“ küsis Sakarias inglilt. „Ma olen vana mees ja ka mu naine on eakas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","„Mina olen Gabriel,“ vastas ingel. „Ma seisan Jumala juures ning mind saadeti sinuga rääkima ja sulle seda head uudist tooma. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Aga kuna sa ei uskunud seda, mida ma sulle rääkisin, jääd sa tummaks ega saa kõneleda kuni määratud hetkeni, mil mu sõnad täide lähevad.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Väljas ootas rahvas Sakariast ja imestas, miks tal templis nii kaua aega läheb. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kui ta lõpuks välja tuli, ei saanud ta nendega rääkida. Nad mõistsid, et ta oli templis näinud nägemust, sest kuigi ta suutis teha žeste, ei suutnud ta üldse rääkida. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pärast seda, kui ta oma teenistusaja oli lõpetanud, läks ta koju tagasi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mõne aja pärast jäi tema naine Eliisabet lapseootele. Ta jäi koju viieks kuuks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","„Issand on seda mulle teinud,“ ütles ta. „Nüüd on ta võtnud ära mu häbi teiste silmis.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Eliisabeti lapseootuse kuuendal kuul saatis Jumal ingel Gabrieli noore neiu juurde, kelle nimi oli Maarja ja kes elas Galileas Naatsareti linnas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ta oli kihlatud Joosepi-nimelise mehega. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ingel tervitas teda. „Sul on eriline eesõigus,“ ütles ta neiule. „Issand on sinuga.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maarja oli neist sõnadest hämmelduses ja juurdles, mida selline tervitus tähendab. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","„Ära karda, Maarja,“ jätkas ingel, „sest Jumal on osutanud sinu suhtes armulikkust. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Sa jääd lapseootele ja tood ilmale poja. Sa pead talle nimeks panema Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ta saab väga tähtsaks ja teda nimetatakse Kõigekõrgema Pojaks. Issand Jumal annab talle tema isa Taaveti trooni ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ja ta valitseb igavesti Jaakobi järeltulijate üle. Tema kuningriik ei lõpe iial.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","„Kuidas see võimalik on?“ küsis Maarja. „Ma olen alles neitsi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ingel vastas: „Püha Vaim tuleb sinu peale ja Kõigekõrgema vägi varjab sind. Laps, kes sünnib, on püha, ja teda hüütakse Jumala pojaks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ja su sugulane Eliisabet on oma vanas eas samuti lapseootel. Naine, kelle kohta öeldi, et ta ei ole võimeline lapsi saama, on kuuendat kuud lapseootel. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Jumala jaoks ei ole miski võimatu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","„Siin ma olen, valmis olema Issanda teenija,“ ütles Maarja. „Sündigu minuga just nii, nagu sa ütlesid.“ Seejärel ingel lahkus tema juurest. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Veidi aja pärast pani Maarja end valmis ja kiirustas Juudamaa mägedesse, linna, kus oli ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sakariase maja. Sisse astudes hõikas ta Eliisabetti. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kohe kui Eliisabet kuulis Maarja häält, hüppas laps tema ihus rõõmu pärast. Püha Vaim täitis Eliisabeti ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ja ta hüüdis valju häälega: „Kui õnnistatud oled sina naiste hulgas ja kui õnnistatud on laps, kes sinust sünnib! ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Miks mind nõnda austatakse, et mu Issanda ema mind külastab? ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kui ma kuulsin sind tervitust hüüdmas, hüppas laps mu ihus rõõmu pärast. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kui õnnelik sa oled, sest sa oled veendunud, et Issand teeb seda, mida ta sulle tõotas!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maarja vastas: „Kuidas ma ülistan Issandat! ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Olen väga õnnelik Jumalas, mu Päästjas, ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","sest ta otsustas, et mina, tema teenija, olen oma tagasihoidlikust taustast hoolimata tema silmis väärtuslik. Nüüdsest peale ütlevad kõik põlvkonnad, et ma olen õnnistatud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kõigeväeline Jumal on teinud mulle suuri asju, tema nimi on püha. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tema halastus kestab põlvest põlve nendele, kes teda austavad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Oma suure jõuga on ta lõhkunud tükkideks need, kes ülbelt ennast targaks peavad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ta kisub mõjukad nende troonidelt maha ja ülendab need, kes on alandlikud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ta annab näljastele häid asju süüa ja saadab rikkad tühje käsi minema. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ta on aidanud oma sulast Iisraeli ja pidanud teda halastuses meeles, ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","just nagu ta meie isadele, Aabrahamile ja tema järeltulijatele, igaveseks ajaks tõotas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maarja jäi Eliisabeti juurde kolmeks kuus ja naasis siis koju. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Eliisabetil jõudis sünnitamise aeg kätte ja ta tõi ilmale poja. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Naabrid ja sugulased kuulsid, kuidas Issand oli talle oma suurt headust osutanud, ning nad tähistasid seda koos temaga. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kaheksa päeva pärast tulid nad poissi ümber lõikama. Nad kavatsesid talle isa järgi nimeks panna Sakarias. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","„Ei,“ ütles Eliisabet. „Tema nimeks peab saama Johannes.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","„Aga teie sugulaste hulgas pole kedagi, kellel see nimi oleks,“ ütlesid nad talle. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Žestide abil küsisid nad Sakariaselt, poisi isalt, mis nime tahaks ta oma pojale panna. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakarias andis märku, et talle antaks midagi, mille peale kirjutada. Kõigi üllatuseks kirjutas ta: „Tema nimi on Johannes.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kohe suutis ta jälle rääkida ja hakkas Jumalat ülistama. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kõiki läheduses elavaid inimesi täitis juhtunu tõttu aukartus ning kuuldus sellest levis kogu Juuda mägismaal. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Igaüks, kes seda kuulis, mõtles, mida see peaks tähendama. „Kes sellest poisist saab?“ küsisid nad, sest oli selge, et ta oli Jumala jaoks väga eriline. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tema isa Sakarias täitus Püha Vaimuga ja kuulutas prohvetlikult: ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","„Issand, Iisraeli Jumal, on imeline, sest ta on tulnud oma rahva juurde ja nad vabastanud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ta on andnud meile suure Päästja oma sulase Taaveti järglaste hulgast, ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","nagu ta tõotas ammu aega tagasi oma pühade prohvetite kaudu. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ta tõotas päästa meid meie vaenlaste käest, nende käest, kes meid vihkavad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ta halastas meie isade peale ja pidas meeles oma püha lepingut − ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","tõotust, mille ta oli andnud meie isale Aabrahamile. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ta vabastab meid hirmust ja päästab meid meie vaenlaste käest, ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","et saaksime teda teenida ning teha kogu oma elu seda, mis on hea ja õige. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kuigi sa oled alles väike laps, hüütakse sind Kõigekõrgema prohvetiks, sest sa lähed Issanda eel valmistama talle teed ja ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kuulutama tema rahvale teadmisi päästest pattude andestuse kaudu. ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tänu Jumala hoolitsevale headusele laseb taevas meile koiduvalgust paista, ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","et see säraks neile, kes elavad pimeduses ja surma varjus, ning juhiks meid rahu teel.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Poiss Johannes kasvas ja sai vaimulikult tugevaks. Ta elas kõrbes, kuni jõudis kätte aeg avalikult Iisraeli teenida. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sel ajal andis keiser Augustus välja seaduse, et Rooma impeeriumis tuleb kõiki hõlmav rahvaloendus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","See oli esimene rahvaloendus Süüria maavalitseja Küreeniuse ajal. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Niisiis läks igaüks oma linna end kirja panema. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joosep põlvnes kuningas Taavetist, seepärast lahkus ta Galileas asuvast Naatsaretist, et minna Juudamaale Petlemma, Taaveti linna. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ta läks end sinna kirja panema koos Maarjaga, kes oli temaga kihlatud ja lapseootel. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kui nad seal olid, jõudis kätte lapsesaamise aeg. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Maarja tõi ilmale oma esmasündinud poja, mähkis ta riidelappidesse ja asetas sõime, sest võõrastemajas ei olnud vabu tube. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Seal lähedal olid mõned karjased öösel väljadel ja valvasid oma karja. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Neile ilmus Issanda ingel ja Issanda hiilgus paistis nende ümber. Nad kohkusid üliväga! ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","„Ärge kartke!“ ütles ingel neile. „Tulin teile tooma head uudist, mis rõõmustab kõiki inimesi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Täna sündis teile siin, Taaveti linnas, Päästja. Ta on Messias, Issand. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Te tunnete ta ära selle märgi järgi: te leiate lapse riidelappidesse mähitud ja sõimes lebamas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Äkki ilmus palju taevaseid olevusi, kes ülistasid Jumalat, öeldes: ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","„Au olgu taeva Jumalale ja maa peal rahu inimestele, kes on talle meele järele!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pärast seda kui inglid olid lahkunud ja tagasi taevasse läinud, ütlesid karjased üksteisele: „Lähme Petlemma ja vaatame, mis on toimunud sellega seoses, millest Issand meile rääkis.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nad kiirustasid sinna ning leidsid Maarja, Joosepi ja lapse, kes lamas sõimes. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kui nad olid seda ise näinud, siis levitasid nad uudist toimunust ja sellest, mida oli neile selle lapse kohta räägitud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kõik, kes seda kuulsid, olid karjaste jutust hämmastunud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kuid Maarja pidas hoolikalt meeles kõik, mis oli juhtunud, ning mõtles selle peale sageli. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Karjased läksid tagasi oma karja valvama ning ülistasid ja tänasid Jumalat kõige eest, mida nad olid kuulnud ja näinud, sest kõik oli just nii, nagu neile oli öeldud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kaheksa päeva pärast oli aeg laps ümber lõigata ja talle pandi nimeks Jeesus. See oli nimi, mille ingel oli andnud enne, kui ema oli lapseootele jäänud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kui nende puhastusaeg vastavalt Moosese seadusele lõppes, viisid Joosep ja Maarja ta Jeruusalemma, et teda Issanda ette tuua, ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","nagu Issanda seadus ütleb: „Kõik esmasündinud pojad tuleb Issandale pühitseda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Seal tõid nad ohvri, nagu Jumala seadus määrab, „paari turteltuvisid või kaks noort tuvi“. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tol ajal elas Jeruusalemmas mees nimega Siimeon. Siimeon tegi seda, mis oli hea, ja ta oli väga vaga. Ta ootas pikisilmi Iisraeli lootust ja Püha Vaim oli tema peal. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Püha Vaim oli talle näidanud, et ta ei sure enne, kui on näinud Issanda Messiat. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Vaimu juhtimist järgides läks ta templisse. Kui Jeesuse vanemad tõid väikese poisi, et teda pühendada, nagu Seadus nõudis, ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","võttis Siimeon Jeesuse sülle, tänas Jumalat ja ütles: ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","„Issand ja Õpetaja, nüüd saad oma sulasel lasta rahus surra, nagu sa tõotasid, ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","sest ma olen ise näinud sinu päästet, ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","mille sa oled kõigi jaoks valmistanud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ta on valgus, mis näitab rahvastele sind, sinu rahva Iisraeli hiilgust.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jeesuse isa ja ema olid rabatud sellest, mida Siimeon tema kohta ütles. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Seejärel Siimeon õnnistas neid ja ütles Jeesuse emale Maarjale: „Määratud on, et selle lapse tõttu paljud Iisraelis langevad ja paljud tõusevad. Ta on märk Jumalalt, mille paljud hülgavad, ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","näidates sellega, mida nad tegelikult mõtlevad. Aga sina tunned, nagu tungiks mõõk otse sinust läbi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Jeruusalemmas elas ka naisprohvet Hanna. Ta oli Aaseri suguharust, Penueli tütar, ning ta oli väga vana. Ta oli olnud abielus seitse aastat ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ning oli siis leseks jäänud. Ta oli kaheksakümne nelja aastane. Ta veetis aega templis Jumalat ülistades, paastudes ja palvetades. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Just siis tuli ta nende juurde ja hakkas Jumalat kiitma. Ta kõneles Jeesusest kõigile, kes ootasid seda aega, mil Jumal Jeruusalemma vabastab. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kui nad olid täitnud kõik, mida Jumala seadus nõudis, läksid nad tagasi oma kodulinna Naatsaretti Galileas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Laps kasvas tugevaks ja oli väga arukas. Jumala õnnistus oli temaga. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jeesuse vanemad rändasid igal aastal paasapühaks Jeruusalemma. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kui Jeesus oli kaheteistkümneaastane, läksid nad pühadele nagu alati. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kui pühad olid läbi ja oli aeg koju naasta, jäi poiss Jeesus Jeruusalemma, kuid tema vanemad ei teadnud seda. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nad oletasid, et ta oli koos kõigi teistega koju rändamas. Kui päev oli möödunud, hakkasid nad teda sõprade ja sugulaste juurest otsima. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kui nad ei suutnud teda leida, läksid nad tagasi Jeruusalemma, et teda seal otsida. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Alles kolme päeva pärast leidsid nad ta templist. Ta istus vaimulike õpetajate keskel, kuulas neid ja esitas neile küsimusi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kõik, kes kuulsid teda rääkimas, olid tema arusaamisest ja vastustest üllatunud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tema vanemad olid täiesti segaduses, kui nad nägid, mida ta teeb. Ema küsis talt: „Poeg, miks sa meiega niimoodi käitusid? Su isa ja mina oleme end haigeks muretsenud! Oleme sind igalt poolt otsinud!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","„Miks te mind otsisite?“ vastas Jeesus. „Kas te ei teadnud, et ma peaksin olema siin, oma Isa kojas?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Aga nad ei saanud aru, mida ta sellega mõtles. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Siis läks ta koos nendega tagasi Naatsaretti ja tegi seda, mida tal kästi. Tema ema pani hoolega tähele kõike, mis oli juhtunud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jeesus kasvas ja sai järjest targemaks ja tugevamaks ning oli Jumala ja inimeste soosingus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nüüdseks oli Tibeerius olnud keiser viisteist aastat. Pontius Pilaatus oli Juuda maavalitseja. Heroodes oli Galilea valitseja, tema vend Filippus oli Iturea ja Trahhoniitise valitseja ning Lüsaanias Abileene valitseja. ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hannas ja Kaifas olid hetkel ülempreestrid. See oli aeg, mil Jumala sõna tuli Johannesele, Sakariase pojale, kes elas kõrbes. ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ta käis läbi kogu Jordani piirkonna ja kuulutas kõigile, et nad peaksid laskma end ristida, näitamaks, et nad on kahetsenud ja nende patud on andestatud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nagu prohvet Jesaja kirjutas: „Kõrbes kuuldakse häält hüüdvat: „Valmistage Issandale teed, tehke tasaseks tema teerajad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Täitke kõik orud ja tasandage kõik mäed ja künkad. Tehke kõver sirgeks ja konarlik tee siledaks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Iga inimene näeb Jumala päästet.““ ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Johannes pöördus rahvahulga poole, kes oli tulnud tema juurde, et ristitud saada. „Te rästikute sigitised! Kes hoiatas teid, et te põgeneksite tulevase kohtu eest?“ küsis ta. ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","„Tõestage, et olete tõeliselt meelt parandanud. Kas te ei ürita ennast õigustada, öeldes: „Me oleme Aabrahami järeltulijad.“ Ma ütlen teile, Jumal võib luua Aabrahamile lapsi neist kividest. ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kirves on valmis, et alustada juurte juurest puu raiumist. Iga puu, mis ei kanna head vilja, raiutakse maha ja visatakse tulle.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","„Mida me peame siis tegema?“ küsis rahvas temalt. ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","„Kui sul on kaks kuube, siis jaga seda kellegagi, kellel pole ühtegi. Kui sul on toitu, jaga seda nendega, kellel ei ole,“ rääkis ta neile. ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mõned maksukogujad tulid, et end ristida lasta. „Õpetaja, mida me peame tegema?“ küsisid ka nemad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","„Ärge koguge rohkem maksu, kui on ette nähtud,“ vastas ta. ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","„Aga meie?“ küsisid mõned sõdurid. „Mida meie peame tegema?“ „Ärge nõudke raha vägivallaga ähvardades. Ärge esitage süüdistusi, mis pole tõsi. Olge rahul oma palgaga,“ vastas ta. ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Rahvas oli lootusrikas ja juurdles, kas Johannes ise võiks Messias olla. ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Johannes vastas ja selgitas kõigile: „Jah, mina ristin teid vees. Aga see, kes tuleb, on palju tähtsam kui mina, ja mina pole väärt, et tema sandaale lahti päästa. Tema ristib teid Püha Vaimu ja tulega. ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tuulamishark on tal käes ja ta on valmis oma rehealuses nisu aganatest eraldama. Ta kogub nisu aita, kuid aganad põletab ära tulega, mida ei saa kustutada.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Johannes esitas veel palju selliseid hoiatusi, kui ta rahvale head sõnumit kuulutas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aga kui Johannes noomis valitseja Heroodest sellepärast, et ta abiellus oma vennanaise Heroodiasega, ja kõigi halbade asjade pärast, mida ta teinud oli, ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","lisas Heroodes oma kuritegude hulka veel selle, et lasi Johannese vanglasse heita. ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kui nüüd kõik olid saanud ristitud, ristiti ka Jeesus. Kui ta palvetas, avanes taevas ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ja Püha Vaim laskus tuvi kujul tema peale. Taevast kostis hääl, mis ütles: „Sina oled mu poeg, keda ma armastan. Olen sinu üle väga rõõmus.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jeesus oli umbes kolmekümneaastane, kui ta oma avalikku teenimistööd alustas. Inimesed oletasid, et ta oli Joosepi poeg. Joosep oli Eeli poeg, ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","kes oli Mattati poeg, kes oli Leevi poeg, kes oli Malki poeg, kes oli Jannai poeg, kes oli Joosepi poeg, ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","kes oli Mattitjahu poeg, kes oli Aamose poeg, kes oli Nahumi poeg, kes oli Hesli poeg, kes oli Naggai poeg, ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","kes oli Mahati poeg, kes oli Mattitjahu poeg, kes oli Simei poeg, kes oli Jooseki poeg, kes oli Jooda poeg, ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","kes oli Joohanani poeg, kes oli Reesa poeg, kes oli Serubbaabeli poeg, kes oli Sealtieli poeg, kes oli Neeri poeg, ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","kes oli Melki poeg, kes oli Addi poeg, kes oli Koosami poeg, kes oli Elmadami poeg, kes oli Eeri poeg, ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","kes oli Jeesuse poeg, kes oli Elieseri poeg, kes oli Joorimi poeg, kes oli Mattati poeg, kes oli Leevi poeg, ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","kes oli Siimeoni poeg, kes oli Juuda poeg, kes oli Joosepi poeg, kes oli Joonami poeg, kes oli Eljakimi poeg, ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","kes oli Melea poeg, kes oli Menna poeg, kes oli Mattata poeg, kes oli Naatani poeg, kes oli Taaveti poeg, ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","kes oli Iisai poeg, kes oli Oobedi poeg, kes oli Boase poeg, kes oli Salma poeg, kes oli Nahsoni poeg, ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","kes oli Amminadabi poeg, kes oli Admini poeg, kes oli Arni poeg, kes oli Hesroni poeg, kes oli Peretsi poeg, kes oli Juuda poeg, ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","kes oli Jaakobi poeg, kes oli Iisaki poeg, kes oli Aabrahami poeg, kes oli Terahi poeg, kes oli Naahori poeg, ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","kes oli Serugi poeg, kes oli Reu poeg, kes oli Pelegi poeg, kes oli Eeberi poeg, kes oli Selahi poeg, ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","kes oli Keenani poeg, kes oli Arpaksadi poeg, kes oli Seemi poeg, kes oli Noa poeg, kes oli Lemeki poeg, ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","kes oli Metuusala poeg, kes oli Eenoki poeg, kes oli Jeredi poeg, kes oli Mahalaleli poeg, kes oli Keenani poeg, ");
INSERT INTO ekkpkp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","kes oli Enose poeg, kes oli Seti poeg, kes oli Aadama poeg, kes oli Jumala poeg. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jeesus, täis Püha Vaimu, tuli Jordani jõe äärest tagasi ja Vaim juhtis ta kõrbesse, ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","kus kurat teda nelikümmend päeva kiusas. Kogu selle aja jooksul ei söönud ta midagi, nii et lõpuks oli tal nälg. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kurat ütles talle: „Kui sa oled Jumala Poeg, käsi sel kivil leivaks muutuda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","„Pühakirjas on kirjutatud: „Inimene ei ela üksnes leivast,““ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kurat viis ta üles kõrgesse kohta ja näitas talle põgusalt kõiki maailma kuningriike. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Seejärel ütles kurat Jeesusele: „Ma annan sulle võimu kõigi nende üle ja nende hiilguse. See võim on antud mulle ja mina võin anda selle, kellele tahan. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kummarda maani ja teeni mind ning sa võid kõik selle saada.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","„Pühakirjas on kirjutatud: „Sina pead kummardama Issandat, oma Jumalat, ja üksnes teda teenima,““ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kurat viis Jeesuse Jeruusalemma, asetas ta templi katusele ja ütles talle: „Kui sa oled Jumala Poeg, siis hüppa! ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Sest Pühakirjas on kirjutatud: „Ta käsib oma inglitel sinu eest hoolitseda ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ja sind kaitsta, et sa kivi otsa ei komistaks“.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","„Pühakirjas on kirjutatud: „Sa ei tohi Issandat, oma Jumalat, kiusata,““ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kui kurat oli kõik oma kiusatused lõpetanud, jäi ta järgmist võimalust ootama. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jeesus läks Vaimu väega täidetult Galileasse tagasi. Kuuldused temast levisid kõikjal. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jeesus õpetas nende sünagoogides ja kõik ülistasid teda. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kui ta jõudis Naatsaretti, kus ta oli üles kasvanud, läks ta hingamispäeval sünagoogi nagu tavaliselt. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Talle ulatati prohvet Jesaja rullraamat. Jeesus keeras kirjarulli lahti ja leidis koha, kus on kirjutatud: ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","„Issanda Vaim on minu peal, sest ta on mind võidnud kuulutama head sõnumit vaestele. Ta on saatnud mind teatama, et vangid vabastatakse, pimedad näevad, rõhutud vabanevad, ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kuulutama välja Issandale meelepärast aega.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ta keeras pärgamendirulli kokku ja andis teenrile tagasi. Siis istus ta maha. Kõik sünagoogis vaatasid tema poole. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","„See Pühakirja tekst, mida te just kuulsite, on täna täide läinud!“ ütles ta neile. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kõik väljendasid oma heakskiitu ja olid hämmastunud neist meeldivatest sõnadest, mis tema huulilt tulid. „Kas see pole Joosepi poeg?“ imestasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jeesus vastas: „Olen kindel, et kordate mulle seda vanasõna: „Arst, ravi ennast!“, ja küsite: „Miks ei tee sa siin, oma kodulinnas, seda, mida sa kuuldavasti Kapernaumas tegid?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Aga ma ütlen teile tõtt, ühtki prohvetit ei tunnustata tema kodulinnas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Olen kindel, et Eelija ajal oli Iisraelis palju lesknaisi, kui kolm ja pool aastat oli põud, mis põhjustas riigis suure näljahäda. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ometi ei saadetud Eelijat ühegi juurde neist. Ta saadeti lesknaise juurde Sareptas, Siidoni piirkonnas! ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kuigi Eliisa ajal oli Iisraelis palju pidalitõbiseid, oli ainus, kes terveks sai, süürlane Naaman!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kui sünagoogis viibijad seda kuulsid, said nad kõik maruvihaseks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nad hüppasid püsti ja viskasid ta linnast välja. Siis vedasid nad ta künka otsa, mille peale linn oli ehitatud, et teda kaljult alla visata. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Aga tema kõndis otse nende vahelt läbi ja läks oma teed. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jeesus läks alla Kapernauma, ühte Galilea linna. Hingamispäeval hakkas ta neid õpetama. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nad olid hämmastunud sellest, mida ta neile õpetas, sest ta kõneles mõjuvõimsalt. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Sünagoogis oli üks mees, kes oli kurja vaimu valduses. Ta hüüdis: ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","„Mida sa meist tahad, Naatsareti Jeesus? Kas sa tulid meid hävitama? Ma tean, kes sa oled: Jumala Püha!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jeesus katkestas teda ja ütles: „Ole vait!“ Seejärel käskis ta kurja vaimu: „Tule temast välja!“ Kuri vaim heitis mehe nende ette maha ja lahkus temast, ilma teda vigastamata. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nad kõik olid hämmastuses ja küsisid üksteiselt: „Mis õpetus see on? Ta käsib väe ja võimuga kurjadel vaimudel lahkuda ja nad teevad seda!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kuuldused Jeesusest levisid kogu ümbruskonnas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sünagoogist lahkudes läks Jeesus Siimona koju. Siimona ämm oli kõrges palavikus haige ja need, kes seal viibisid, palusid Jeesuselt abi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jeesus läks ja seisis tema juurde. Ta käskis palavikul naisest lahkuda ja nii sündis. Naine tõusis kohe püsti ja valmistas neile süüa. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kui päike loojus, tõid nad tema juurde kõik, kes olid haiged, kes kannatasid mitmesuguste vaevuste all. Jeesus pani oma käed üksteise järel nende peale ja tegi nad terveks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Paljudest inimestest tulid kurjad vaimud välja ja karjusid: „Sa oled Jumala Poeg!“ Aga Jeesus takistas neid ega lasknud neil rääkida, sest nad teadsid, et ta on Kristus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Jeesus lahkus järgmisel hommikul vara , et leida mõni rahulik ja vaikne koht. Kuid rahvahulk läks välja teda otsima ja lõpuks ka leidis. Nad üritasid tema lahkumist takistada, sest nad ei tahtnud, et ta ära läheks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kuid tema ütles neile: „Ma pean minema teistesse linnadesse, et rääkida ka neile head sõnumit Jumala riigist, sest selleks on mind läkitatud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nii rändas Jeesus ringi ja õpetas Juudamaa sünagoogides head sõnumit. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ühel päeval, kui Jeesus seisis Galilea mere ääres, tunglesid inimesed tema ümber, et Jumala sõna kuulda. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jeesus märkas kaldal kaht paati, mille olid jätnud sinna kalurid, kes oma võrke pesid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jeesus astus paati, sellesse, mis kuulus Siimonale, ja palus tal paadi vette tõugata, kaldast veidi eemale. Siis Jeesus istus paadis maha ja õpetas sealt rahvast. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pärast seda kui ta kõnelemise oli lõpetanud, ütles ta Siimonale: „Mine välja sügavamasse vette ja lase oma võrgud püüdmiseks sisse.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","„Õpetaja, nägime kogu öö tõsist vaeva, kuid ei püüdnud midagi. Aga kui sa nii ütled, siis lasen võrgud sisse,“ vastas Siimon. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kui võrgud olid vees, täitis suur kalaparv võrgud nii, et need olid rebenemas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nad andsid märku kaaslastele teises paadis ja palusid neil appi tulla. Teised tulid ja mõlemad paadid said kalu täis. Paadid olid nii täis, et hakkasid vajuma. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kui Siimon Peetrus nägi, mis oli juhtunud, langes ta Jeesuse ette põlvili. „Issand, hoia palun minust eemale, sest ma olen patune inimene!“ hüüatas ta. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Sest tema ja kõik, kes olid temaga koos, olid maale tõmmatud kalasaagist hämmastuses. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jaakobus ja Johannes, Sebedeuse pojad, Siimona kaaskalurid, tundsid sama. „Ära karda,“ ütles Jeesus Siimonale. „Sest nüüdsest peale püüad sa inimesi!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nõnda siis vedasid nad paadid kaldale, jätsid kõik maha ja järgnesid Jeesusele. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kord kui Jeesus külastas üht linna, kohtus ta mehega, kel oli väga raske pidalitõbi. Mees heitis näoli maha ja anus Jeesust: „Palun, Issand, kui sa tahad, võid sa mind puhtaks teha.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jeesus sirutas käe ja puudutas meest. „Ma tahan,“ ütles ta. „Saa puhtaks!“ Pidalitõbi kadus otsekohe. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","„Ära kellelgi midagi ütle,“ õpetas Jeesus teda. „Mine ja näita end preestrile ja too oma tervenemise tõestuseks Moosese seaduses nõutud tseremoniaalohvrid.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ikkagi levisid kuuldused Jeesusest üha enam ja enam. Suured rahvahulgad tulid Jeesust kuulama ja oma haigustest terveks saama. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Aga sageli tõmbus Jeesus vaiksesse paika ja palvetas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ühel päeval, kui Jeesus õpetas, istusid seal ka variserid ja vaimulikud õpetajad, kes olid tulnud kogu Galileast, Juudamaalt ja Jeruusalemmast. Issanda vägi tervendada oli temaga, nii et ta suutis inimesi terveks teha. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mõned mehed tulid ja kandsid mati peal halvatud meest. Nad üritasid teda sisse viia, et teda Jeesuse ette asetada. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kuid nad ei suutnud läbi rahva teed leida, seega läksid nad üles katusele ja tegid katusekivide vahele augu. Seejärel lasksid nad mehe koos matiga alla, otse rahva sekka, Jeesuse ette. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kui Jeesus nägi, missugune usk oli neil temasse, ütles ta mehele: „Sinu patud on andeks antud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Vaimulikud õpetajad ja variserid hakkasid selle üle arutlema. „Kes ta on, et niimoodi Jumalat teotab?“ küsisid nad. „Kes võib patte andeks anda? Ainult Jumal võib seda teha!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jeesus teadis, mida nad arutlevad, seepärast küsis ta neilt: „Miks te seda kahtluse alla seate? ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mis on lihtsam? Kas öelda, et sinu patud on andeks antud või „Tõuse püsti ja kõnni!“? ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kuid ma tõestan teile, et inimese Pojal on õigus siin maa peal patte andeks anda.“ Seejärel ütles ta halvatud mehele: „Ma ütlen sulle: tõuse üles, võta oma matt ja mine koju.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jalamaid tõusis mees nende ees püsti. Ta võttis mati, mille peal ta oli lamanud, ning läks Jumalat ülistades koju. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kõik olid juhtunust täielikult jahmunud ning suures aukartuses ülistasid nad Jumalat, öeldes: „See, mida me täna nägime, oli hämmastav!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Hiljem, kui Jeesus oli linnast lahkumas, nägi ta maksukogujat nimega Leevi oma tolliputkas istumas. „Järgne mulle,“ ütles Jeesus talle. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Leevi tõusis püsti, jättis kõik sinnapaika ja järgnes Jeesusele. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Leevi korraldas oma kodus Jeesuse auks suure pidusöögi. Rahva hulgas, kes koos nendega sõi, oli palju maksukogujaid ja teisi. Kuid variserid ja vaimulikud õpetajad kurtis Jeesuse jüngritele, öeldes: ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","„Miks te sööte ja joote koos maksukogujate ja patustega?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","„Arsti ei vaja terved, vaid haiged,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","„Ma ei tulnud kutsuma meeleparandusele neid, kes elavad õigesti. Ma tulin kutsuma patuseid.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","„Aga Johannese jüngrid paastuvad sageli ja palvetavad ning variseride jüngrid samuti. Kuid sinu jüngrid seda ei tee, nad käivad söömas ja joomas,“ ütlesid nad talle. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","„Kas peiupoisid peaksid paastuma sel ajal, kui peigmees on nende juures?“ küsis Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","„Ei, aga tuleb aeg, mil peigmees võetakse nende juurest ära. Küll nad siis paastuvad.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Siis esitas ta neile näitliku selgituse: „Uute rõivaste küljest ei rebita paika, et vanu rõivaid lappida. Muidu oleks uued rõivad rikutud ja uuelt pärit paik ei sobiks vanale. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Värsket veini ei panda vanadesse nahklähkritesse, sest kui seda teha, rebeneksid vanad lähkrid värske veini tõttu. Siis läheks raisku nii vein kui ka veinilähkrid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Värske vein pannakse uutesse lähkritesse. ");
INSERT INTO ekkpkp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ja pärast vana veini joomist ei soovi keegi värsket veini, sest öeldakse, et „vana maitseb hästi“.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ühel hingamispäeval, kui Jeesus läks läbi viljapõldude, hakkasid tema jüngrid viljapäid korjama, hõõrusid neid käte vahel ja sõid teri. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mõned variserid küsisid temalt: „Miks te teete seda, mida ei ole hingamispäeval lubatud teha?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jeesus vastas: „Kas te ei ole lugenud, mida tegi Taavet, kui tal ja tema meestel kõht tühi oli? ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kuidas nad läksid Jumala kotta ja võtsid pühitsetud leiba? Ta sõi seda ja andis ka oma meestele. See ei olnud samuti lubatud. Pühitsetud leib on üksnes preestrite jaoks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Siis ütles ta neile: „Inimese Poeg on hingamispäeva Issand.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ühel teisel hingamispäeval läks ta sünagoogi õpetama. Seal oli üks mees, kelle parem käsi oli vigane. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Vaimulikud õpetajad ja variserid jälgisid Jeesust teraselt, et näha, kas ta teeb hingamispäeval terveks. Nad tahtsid leida midagi, milles teda süüdistada. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kuid Jeesus teadis, mida nad mõtlesid. Ta ütles vigase käega mehele: „Tõuse püsti ja seisa siia kõigi ette.“ Mees tõusis ja jäi seisma. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Seejärel pöördus Jeesus nende poole ja ütles: „Ma küsin teilt midagi. Kas on seaduspärane teha hingamispäeval head või halba? Elu päästa või seda hävitada?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ta vaatas kõiki, kes olid seal tema ümber. Siis ütles ta mehele: „Siruta käsi välja.“ Mees tegi seda ja tema käsi sai nagu uueks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Aga nad said maruvihaseks ning hakkasid arutama, mida nad saaksid Jeesusega teha. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ühel päeval üsna varsti pärast seda läks Jeesus üles mäele palvetama. Ta jäi sinna kogu ööks ja palvetas Jumala poole. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kui saabus hommik, kutsus ta kokku oma jüngrid ja valis neist välja kaksteist. Need on apostlite nimed: ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Siimon (keda Jeesus hüüdis ka Peetruseks), tema vend Andreas, Jaakobus, Johannes, Filippus, Bartolomeus, ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matteus, Toomas, Alfeuse poeg Jaakobus, revolutsionäär Siimon, ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jaakobuse poeg Juudas ja Juudas Iskariot (kellest sai äraandja). ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jeesus läks koos nendega mäelt alla ja peatus kohas, kus oli veidi tasast maad. Sinna oli kogunenud rahvahulk tema jüngritest ja paljudest teistest inimestest kogu Juudamaalt, Jeruusalemmast ning mere äärest Tüürosest ja Siidonist, et teda kuulata ja oma haigustest terveks saada. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Need, keda vaevasid kurjad vaimud, said ka terveks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kõik rahva hulgast üritasid teda puudutada, sest temast lähtus vägi ja tervendas nad kõik. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Oma jüngreid vaadates ütles Jeesus neile: ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","„Kui õnnelikud olete teie, kes olete vaesed, sest Jumala riik on teie päralt! Kui õnnelikud olete teie, kellel praegu on nälg, sest te saate süüa nii palju kui vaja! Kui õnnelikud olete teie, kes te praegu nutate, sest te saate naerda! ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kui õnnelikud te olete, kui inimesed teid vihkavad, teid kõrvale jätavad, solvavad ja teie nimega kurja vannuvad minu, inimese Poja pärast. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kui tuleb see päev, olge õnnelikud. Hüpake rõõmust, sest suur on teie tasu taevas. Ärge unustage, et nende esiisad kohtlesid prohveteid täpselt samamoodi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Aga kui kurvad olete teie, kes olete rikkad, sest te olete oma tasu juba kätte saanud! ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kui kurvad olete teie, kel praegu on kõht täis, sest te hakkate nälga tundma! Kui kurvad olete teie, kes te praegu naerate, sest te hakkate leinama ja nutma! ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kui kurvad olete teie, kui kõik teid ülistavad! Ärge unustage, et teie esiisad ülistasid valeprohveteid täpselt samamoodi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Aga ma ütlen teile, kes te kuulate: armastage oma vaenlasi. Tehke head neile, kes teid vihkavad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Õnnistage neid, kes teid neavad. Palvetage nende eest, kes teid halvasti kohtlevad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kui keegi lööb sind ühe põse peale, pööra ette teine põsk. Kui keegi võtab su kuue, siis ära takista tal ka sinu särki võtta. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Anna igaühele, kes sinult küsib. Kui keegi võtab sinult midagi, ära küsi seda tagasi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tehke teistele seda, mida soovite, et nad teile teeksid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kui armastate neid, kes teid armastavad, miks peaksite selle eest mingit tunnustust saama? Isegi patused armastavad neid, kes neid armastavad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kui teete head neile, kes teile head teevad, miks oleksite siis mingit tunnustust väärt? Patused teevad samamoodi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kui laenate raha ja ootate, et see tagasi makstakse, siis miks oleksite selle eest tunnustust väärt? Ka patused laenavad teistele patustele ja ootavad, et laenatu tagasi makstakse. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ei, armastage oma vaenlasi, tehke neile head ja laenake ilma tagasimaksmist ootamata. Siis saate suure tasu ja te olete Kõigekõrgema Jumala lapsed, sest tema on tänamatute ja õelatega lahke. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Olge kaastundlikud, nagu teie Isa on kaastundlik. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ärge mõistke kohut, siis ei mõisteta ka teie üle kohut; ärge mõistke hukka, siis ei mõisteta ka teid hukka; andke andeks, siis antakse ka teile andeks; ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","andke, siis antakse teile heldelt tagasi. Kui teile antavat välja mõõdetakse, siis surutakse see kokku, et saaks rohkem lisada, nii et see voolab üle ääre ja pudeneb teile sülle! Sest see, kui palju te annate, määrab ära, kui palju te saate.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Seejärel illustreeris ta mõtet: „Kas pime inimene saab teist juhtida? Kas nad mõlemad ei kukuks auku? ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kas õpilased teavad rohkem kui õpetaja? Ainult siis, kui nad on kõik ära õppinud, siis on nad nagu nende õpetaja. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Miks sa oled nii mures pinnu pärast oma venna silmas, kui sa isegi ei märka palki omaenda silmas? ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kuidas sa saad öelda oma vennale: „Vend, luba ma võtan su silmast pinnu välja“, kui sa isegi ei näe palki, mis on su enda silmas? Silmakirjatseja! Võta kõigepealt oma silmast palk välja ja siis suudad piisavalt hästi näha, et oma venna silmast pind välja võtta. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Hea puu ei anna halba vilja ega halb puu head vilja. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Puu tunneb ära tema viljast. Viigimarju ei nopita kibuvitsapõõsast ega viinamarju murakapõõsast. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Head inimesed toovad välja head sellest heast, mida nad väärtuslikuks peavad ja on endas talletanud. Halvad inimesed toovad välja halba sellest halvast, mida nad on endas talletanud. See, mis täidab mõtteid, pudeneb sõnades välja. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Miks te siis vaevute hüüdma mind „Issand, Issand“, kui te ei tee seda, mida ma ütlen? ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ma toon teile näite inimesest, kes tuleb minu juurde, kuulab mu õpetusi ja järgib neid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","See inimene on nagu maja ehitav mees. Ta kaevab sügavale ja rajab vundamendi kõvale kaljule. Kui jõgi tungib üle kallaste ja tulvavesi paiskub vastu maja, siis maja ei saa kahju, sest on nii hästi ehitatud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Inimene, kes mind kuuleb, aga ei tee, mida ma ütlen, on nagu mees, kes ehitab ilma vundamendita maja. Kui tulvavesi paiskub maja vastu, variseb see silmapilkselt kokku − see hävib täielikult.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kui Jeesus lõpetas rahvale kõnelemise, läks ta Kapernauma. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Seal elas üks sadakonnaülem, kel oli tema jaoks väga väärtuslik sulane, kes oli suremas haige. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kui sadakonnaülem kuulis Jeesusest, saatis ta mõned juuda vanemad tema juurde, et paluda tal tulla ja tema sulane terveks teha. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kui vanemad tulid Jeesuse juurde, palusid nad teda väga, öeldes: „Palun tule ja tee, mida ta palub. Ta on sinu abi väärt, ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","sest ta armastab meie rahvast ja ehitas meile sünagoogi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jeesus läks nendega kaasa ja kui nad majale lähenesid, saatis sadakonnaülem mõned sõbrad Jeesusele vastu talle ütlema: „Issand, ära tee endale vaeva minu majja tulemisega, sest ma ei ole seda väärt. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ma ei pidanud ennast isegi nii palju väärt olevat, et sinu juurde tulla. Anna lihtsalt käsk ja mu sulane saab terveks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Sest ma ise olen kõrgemate ohvitseride võimu all ning ka minu võimu all on sõdureid. Ma käsin ühel minna, ja ta läheb, ning teisel tulla, ja ta tuleb. Ma käsin oma sulasel midagi teha, ja ta teeb seda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kui Jeesus seda kuulis, oli ta rabatud. Ta pöördus teda järgiva rahva poole ja ütles: „Ma ütlen teile, ma ei ole sellist usku leidnud isegi Iisraelist.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Siis läksid sadakonnaülema sõbrad tagasi koju ja leidsid sulase hea tervise juures olevat. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Varsti pärast seda läks Jeesus linna nimega Nain, temaga kaasas olid tema jüngrid ja suur rahvahulk. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kui ta linnaväravale lähenes, tuli sealt vastu matuserongkäik. Mees, kes oli surnud, oli lesknaise ainus poeg, ning naisega oli kaasas üsna suur hulk rahvast. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kui Issand naist nägi, täitis teda kaastunne naise vastu. „Ära nuta,“ ütles ta naisele. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jeesus läks kirstu juurde ja puudutas seda ning kirstukandjad peatusid. Jeesus ütles: „Noormees, ma ütlen sulle, tõuse üles!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Surnud mees tõusis istukile ja hakkas rääkima ning Jeesus andis ta tema emale tagasi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Aukartus täitis kõiki sealviibijaid ja nad ülistasid Jumalat, öeldes: „Meie hulgast on tõusnud suur prohvet“ ja „Jumal on oma rahva juures käinud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kuuldused Jeesusest levisid üle kogu Juudamaa ja kaugemalegi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Johannese jüngrid rääkisid Johannesele kõigest sellest. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Johannes kutsus oma kaks jüngrit ning käskis neil minna Jeesuse juurde ja küsida: „Kas sina oled see, keda oleme oodanud, või peaksime ootama kedagi teist?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kui nad Jeesuse juurde tulid, ütlesid nad: „Ristija Johannes saatis meid sinu juurde küsima: „Kas sina oled see, keda oleme oodanud, või peaksime ootama kedagi teist?““ ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Just sel ajal tegi Jeesus palju inimesi terveks nende haigustest, vaevustest ja kurjadest vaimudest ning tegi pimedaid nägijaks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jeesus vastas Johannese jüngritele: „Minge ja jutustage Johannesele, mida te olete näinud ja kuulnud. Pimedad näevad, jalutud kõnnivad, pidalitõbised saavad terveks, kurdid kuulevad, surnud ärkavad ellu, vaestele kuulutatakse head sõnumit. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kui hea on see neile, kes minu pärast ei solvu!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pärast Johannese käskjalgade lahkumist hakkas Jeesus rahvale rääkima: „Johannesest: mida te ootasite, kui läksite välja kõrbesse teda vaatama? Tuule käes õõtsuvat pilliroogu? ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kas tulite vaatama uhketesse rõivastesse riietatud meest? Ei, need, kel on toredad rõivad ja kes elavad luksuslikult, on paleedes. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kas te otsisite prohvetit? Jah, seda ta on, ja ma ütlen teile, ta on palju rohkem kui prohvet. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Pühakirjas on tema kohta kirjutatud: „Vaata, ma saadan oma käskjala sinu eel sulle teed valmistama.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ma ütlen teile, ükski naisest sündinu ei ole Johannesest suurem, aga isegi kõige tähtsusetum inimene Jumala riigis on temast suurem!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kui nad kuulsid seda, siis nad kõik − isegi maksukogujad − järgisid seda, mis Jumala sõnul on hea ja õige, sest Johannes oli neid ristinud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kuid variserid ja vaimulikud õpetajad hülgasid selle, mida Jumal soovis, et nad teeksid, sest nad ei olnud lasknud end Johannesel ristida. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","„Millega peaksin neid inimesi võrdlema?“ küsis Jeesus. „Missugused nad on? ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nad on nagu turuplatsil istuvad lapsed, kes ütlevad üksteisele: „Me mängisime teile flööti, aga te ei tantsinud; me laulsime, aga te ei nutnud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kui Ristija Johannes tuli, ei söönud leiba ega joonud veini, siis te ütlesite, et ta on kurjast vaimust vaevatud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nüüd on siin inimese Poeg, sööb ja joob koos inimestega, aga teie ütlete: „Vaadake, ta veedab oma aega liiga palju süües ja liiga palju veini juues. Pealegi on ta maksukogujate ja patuste sõber.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ometi tõestavad Jumala teede mõistlikkust kõik, kes teda järgivad!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Üks variseridest kutsus Jeesuse enda juurde sööma. Jeesus läks variseri majja ja istus maha sööma. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Üks selle linna naine, kes oli patune, sai teada, et Jeesus sööb variseri kodus. See naine läks sinna, kaasas alabasternõu parfüümiga. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ta põlvitas Jeesuse kõrvale, kastis oma pisaratega ta jalad märjaks ja kuivas neid oma juustega. Ta suudles tema jalgu ja valas siis neile parfüümi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kui variser, kes oli Jeesuse kutsunud, nägi seda, ütles ta endamisi: „Kui see mees oleks tõesti prohvet, siis ta teaks, kes on see naine, kes teda puudutab, ja missugune inimene ta on − et ta on patune!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jeesus hakkas kõnelema ja ütles: „Siimon, mul on sulle midagi öelda.“ „Räägi, Õpetaja,“ vastas Siimon. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","„Ükskord olid kaks inimest rahalaenajale võlgu. Üks oli võlgu viissada denaari, teine ainult viiskümmend. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kumbki ei suutnud võlga tagasi maksta, seega laenaja kustutas võlad. Kumb neist teda rohkem armastab?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","„See, kellel suurem võlg kustutati, ma arvan,“ vastas Siimon. „Sul on täiesti õigus,“ ütles Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Naise poole pöördudes ütles ta Siimonale: „Kas näed seda naist? Kui ma tulin sinu majja, ei andnud sa mulle vett jalgade pesemiseks. Kuid tema on pesnud mu jalgu oma pisaratega ja oma juustega neid kuivatanud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Sa ei suudelnud mind, kuid sellest ajast peale, kui ma sisse tulin, ei ole tema lakanud mu jalgu suudlemast. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Sa ei võidnud mu pead õliga, kuid tema valas mu jalgadele parfüümi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nii et ma ütlen sulle, tema paljud patud on andeks antud, sellepärast ta nii väga armastabki. Aga kellele on vähe andeks antud, armastab ainult vähe.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Siis ütles Jeesus naisele: „Sinu patud on sulle andeks antud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Need, kes koos temaga istusid ja sõid, hakkasid isekeskis rääkima ja ütlesid: „Kes ta on, et annab koguni patte andeks?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kuid Jeesus ütles naisele: „Sinu usk on sind päästnud, mine rahus.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Varsti pärast seda käis Jeesus ringi linnades ja külades ning kuulutas head sõnumit Jumala riigist. Kaksteist jüngrit käisid koos temaga, ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","peale selle hulga naisi, kelle ta oli kurjadest vaimudest ja haigustest terveks teinud: Maarja, keda hüütakse Magdaleenaks, kellest ta oli seitse kurja vaimu välja ajanud; ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Johanna, Heroodese kojaülema Kuusase naine; Susanna ja veel paljud teised, kes teda oma isiklike vahenditega toetasid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kord, kui oli kogunenud suur hulk inimesi, kes olid tulnud paljudest linnadest teda vaatama, hakkas Jeesus neile kõnelema ja kasutas näitlikustamiseks jutustust. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","„Üks põllumees läks välja külvama. Kui ta seemet laiali puistas, kukkus osa sellest tee peale, kus inimesed selle jalgade alla trampisid ja linnud ära sõid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Osa seemnest kukkus kivisele pinnale ja kui seeme oli idanenud, närbusid võrsed niiskuse puudumise tõttu. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Osa seemneid kukkus ohakate sekka ja kui mõlemad kasvasid, lämmatasid ohakad vilja ära. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Osa seemnest kukkus hea maa peale ning andis hiljem saaki sada korda rohkem sellest, mis oli külvatud.“ Kui ta oli seda rääkinud, hüüdis ta: „Kui teil on kõrvad, siis kuulake!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Aga tema jüngrid küsisid talt: „Mida see mõistujutt tähendab?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jeesus vastas: „Teile on antud võimalus heita pilk Jumala riigi saladustesse, kuid ülejäänutele on antud mõistujutud, et „isegi kui nad näevad, siis nad tegelikult ei näe, ja kuigi nad kuulevad, ei saa nad tegelikult aru.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Selle mõistujutu tähendus on järgmine: seeme on Jumala sõna. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Seemned, mis kukuvad tee peale, on need, kes kuulevad sõnumit, kuid kurat tuleb ja näppab tõe nende mõistusest ära, nii et nad ei usu Jumalasse ega saa päästetud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Seemned, mis kukuvad kivisele pinnale, on need, kes kuulevad sõnumit ja võtavad selle rõõmuga vastu, kuid neil ei ole juuri. Mõnda aega nad usuvad, aga kui tulevad rasked ajad, annavad nad alla. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Seemned, mis kukuvad ohakate sekka, on need, kes kuulevad sõnumit, kuid selle elu asjad − mured, rikkus, lõbud − lämmatavad selle, nii et nad ei kanna vilja. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Heasse mulda külvatud seemned on need, kes on siirad ja teevad seda, mis on õige. Nad kuulevad tõesõnumit, haaravad sellest kinni ning annavad püsivuse tõttu head saaki. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ei süüdata lampi, et seda siis ämbriga katta või voodi alla peita. Ei, lamp asetatakse lambijalale, et kõik, kes sisse tulevad, näeksid selle valgust. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sest ei ole midagi varjatut, mis ei saaks avalikuks; ei ole midagi salajast, mis ei saaks teatavaks ja selgeks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nii et pange tähele, kuidas te kuulete. Neile, kes on vastu võtnud, antakse juurde; neilt, kes vastu ei võta, võetakse ära isegi see, mis neil enda arvates on!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Siis jõudsid kohale Jeesuse ema ja vennad, kuid nad ei pääsenud läbi rahvahulga tema juurde. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Jeesusele öeldi: „Su ema ja vennad on väljas. Nad tahavad sind näha.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","„Mu ema ja vennad on need, kes kuulevad Jumala sõna ja teevad, mida see käsib,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ühel päeval ütles Jeesus oma jüngritele: „Lähme üle järve teisele kaldale.“ Nii astusid nad paati ja asusid teele. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kui nad seilasid, jäi Jeesus magama ja alla järvele tuli torm. Paat hakkas veega täituma ja oli oht põhja minna. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nad läksid Jeesuse juurde ja äratasid ta üles „Õpetaja, õpetaja, me upume!“ ütlesid nad. Jeesus ärkas üles ning käskis tuulel ja tormistel lainetel vaikida. Nii juhtuski ja kõik oli rahulik. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","„Kus on teie usk?“ küsis ta neilt. Kohkunult ja hämmastunult ütlesid nad üksteisele: „Kes see siis on? Ta käsib tuuli ja vett ja need kuuletuvad talle!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nad seilasid üle järve gerasalaste territooriumile, mis asub Galilea vastaskaldal. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kui Jeesus astus paadist välja kaldale, tuli talle linnast vastu kurjast vaimust vaevatud mees. Pikka aega ei olnud ta riideid kandnud ega majas elanud. Ta elas hauakambrites. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kui ta Jeesust nägi, hakkas ta karjuma, langes Jeesuse jalge ette maha ja küsis valju häälega: „Mida sa minust tahad, Jeesus, Kõigekõrgema Jumala Poeg? Ära piina mind, ma anun sind!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Sest Jeesus oli juba käskinud kurjal vaimul mehest lahkuda. See oli sageli teda oma valdusesse võtnud ning hoolimata sellest, et teda oli kettide ja vangiraudadega kinni pandud, lõhkus ta ketid ning kuri vaim oli teda kõrbesse kihutanud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","„Mis su nimi on?“ küsis Jeesus talt. „Leegion,“ vastas ta, sest temasse oli sisenenud palju kurje vaime. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nad palusid, et Jeesus ei käsiks neil minna tühjusesse. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Lähedal asuval mäenõlval oli söömas suur seakari ja kurjad vaimud anusid teda, et ta lubaks neil sigadesse minna. Jeesus andis neile loa, ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","seega lahkusid kurjad vaimud mehest ja sisenesid sigadesse. Kari tormas järsku nõlva pidi alla järve ja uppus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kui seakarjused nägid, mis juhtus, jooksid nad minema ning kuulutasid seda linnas ja maal. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Rahvas läks välja vaatama, mis oli juhtunud. Kui nad tulid Jeesuse juurde, leidsid nad mehe, kes oli kurjadest vaimudest vabastatud. Ta istus Jeesuse jalgade juures, kandis riideid ja oli terve mõistuse juures. Rahvas hakkas kartma. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Need, kes olid juhtunut näinud, selgitasid, kuidas kurjadest vaimudest vaevatud mees oli terveks saanud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Siis kõik Gerasa ümbruskonna rahvas palus Jeesusel lahkuda, sest neid valdas hirm. Nii astus ta paati ja läks tagasi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mees, kes oli deemonitest vabaks saanud, palus, et ta võiks kaasa minna, kuid Jeesus saatis ta minema. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","„Mine koju tagasi ja räägi inimestele kõigest, mida Jumal on sinu heaks teinud,“ käskis Jeesus. Nõnda siis mees läks ja kõneles kogu linnas kõigest, mida Jeesus oli tema heaks teinud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kui Jeesus tagasi tuli, oli kogunenud teda vastu võtma rahvahulk, kes teda innukalt ootas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Üks neist oli mees nimega Jairus, sünagoogi ülem, kes tuli ja langes Jeesuse jalge ette. Ta anus, et Jeesus tuleks tema koju, ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","sest tema ainus tütar oli suremas. Ta oli umbes kaheteistkümneaastane. Sel ajal kui Jeesus oli teel sinna, tungles tema ümber rahvahulk. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Rahva seas oli üks naine, kes oli kaksteist aastat veritsemise all kannatanud. Ta oli kulutanud kogu oma vara arstide peale, kuid keegi neist ei olnud suutnud teda aidata. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ta lähenes Jeesusele selja tagant ja puudutas tema rüüd. Kohe lõppes veritsemine. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","„Kes mind puudutas?“ küsis Jeesus. Kõik ümberolijad eitasid puudutamist. „Aga, õpetaja,“ ütles Peetrus, „sinu ümber tungleb rahvas ja nad müksavad sind kogu aeg.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","„Keegi puudutas mind,“ vastas Jeesus. „Ma tean, sest vägi läks minust välja.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kui naine mõistis, et ta ei saa märkamatuks jääda, astus ta värisedes esile ja langes Jeesuse jalge ette maha. Seal kõigi ees selgitas ta põhjust, miks ta oli Jeesust puudutanud, ja et ta oli silmapilkselt terveks saanud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jeesus lausus talle: „Tütar, su usk on su terveks teinud, mine rahus.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sel ajal kui ta alles rääkis, tuli keegi sünagoogi ülema kodust, et talle öelda: „Sinu tütar on surnud. Sul pole vaja enam Õpetajat tülitada.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Aga kui Jeesus seda kuulis, ütles ta Jairusele: „Ära karda. Kui sa usud, saab ta terveks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kui Jeesus maja juurde jõudis, ei lubanud ta sisse kedagi peale Peetruse, Johannese ja Jaakobuse ning tüdruku isa ja ema. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Seal nutsid ja leinasid kõik inimesed tüdruku pärast. „Ärge nutke,“ ütles Jeesus neile. „Ta ei ole surnud, ta lihtsalt magab.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nad naersid tema üle, sest nad teadsid, et tüdruk on surnud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kuid Jeesus võttis tüdrukul käest kinni ja ütles valju häälega: „Mu laps, tõuse üles!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tüdruk ärkas ellu ja tõusis kohe püsti. Jeesus käskis neil talle midagi süüa anda. ");
INSERT INTO ekkpkp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tüdruku vanemad olid toimunust jahmunud, kuid Jeesus ütles, et nad ei räägiks sellest kellelegi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jeesus kutsus kaksteist jüngrit kokku. Ta andis neile väe ja mõjuvõimu kõigi kurjade vaimude üle ning võime haigustest terveks teha. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Siis saatis ta nad Jumala riigist kuulutama ja haigeid terveks tegema. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","„Ärge võtke midagi teekonnale kaasa,“ ütles ta neile. „Ei käimiskeppi ega kotti, ei leiba ega raha, isegi mitte teisi riideid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kuhu majja te iganes sisenete, sinna jääge, ja kui lahkute sellest majast, siis lahkuge sellest paigast. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kui inimesed keelduvad teid vastu võtmast, siis raputage linnast lahkudes tolm oma jalgadelt hoiatuseks nende vastu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nad lahkusid ja läksid ümberkaudsetesse küladesse, kuulutasid head sõnumit ja tegid haigeid terveks kõikjal, kuhu nad läksid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nelivürst Heroodes kuulis kõigest, mis toimus, ja ta oli väga hämmeldunud. Mõned ütlesid, et Johannes on surnuist üles tõusnud, ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","teised, et Eelija on ilmunud ning mõned, et üks vanaaja prohvetitest on tagasi tulnud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Heroodes ütles: „Ma olen kindel, et lasin Johannesel pea maha võtta. Kes siis on see mees? Ma kuulen tema kohta kõiki neid asju.“ Ja ta üritas leida võimalust Jeesusega kohtumiseks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kui apostlid tagasi tulid, rääkisid nad Jeesusele, mida nad olid teinud. Seejärel lahkus ta koos nendega ja läks linna nimega Betsaida. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kuid rahvas sai teada, kuhu ta läks, ning järgnes talle sinna. Ta võttis nad vastu ja selgitas neile Jumala riiki ning tegi terveks need, kes vajasid tervendamist. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Õhtupoole tulid kaksteist jüngrid tema juurde ja ütlesid: „Sa peaksid rahva nüüd ära saatma, et nad saaksid minna lähedal asuvatesse küladesse ja majapidamistesse ning otsida endale ööbimiskoha ja toitu. Siin, kus me oleme, ei ole midagi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","„Andke teie neile midagi süüa!“ ütles Jeesus. „Kõik, mis meil siin on, on viis leiba ja kaks kala. Kui sa just ei taha, et me läheksime kõigile süüa ostma,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kohal oli umbes viis tuhat meest. „Pange nad umbes viiekümnestesse rühmadesse istuma,“ käskis ta oma jüngreid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jüngrid tegid nii, ja kõik istusid maha. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jeesus võttis viis leiba ja kaks kala ning taeva poole vaadates õnnistas toitu ja tegi selle tükkideks. Ta andis jüngritele järjest toitu, et nad jagaksid seda rahvale. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kõik sõid, kuni kõht sai täis, ja seejärel koguti kokku kaksteist korvitäit jääke. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Üks teine kord, kui Jeesus palvetas omaette ja temaga koos olid ainult tema jüngrid, küsis ta neilt: „Kes ma kogu selle rahvahulga arvates olen?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","„Mõni arvab, et Ristija Johannes, teised arvavad, et Eelija, ning mõned ütlevad, et üks vanaaja prohvetitest on surnuist üles tõusnud,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","„Aga kuidas on teiega?“ küsis ta. „Kes ma teie arvates olen?“ „Jumala Messias,“ vastas Peetrus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jeesus keelas neil rangelt sellest kellelegi rääkida. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","„Inimese Poeg peab kogema kohutavaid kannatusi,“ ütles ta. „Rahva vanemad, ülempreestrid ja vaimulikud õpetajad hülgavad ta. Ta surmatakse, kuid kolmandal päeval tõuseb ta surnuist üles.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","„Kui keegi tahab mind järgida, siis peab ta ennast salgama, iga päev oma risti võtma ja mind järgima,“ rääkis Jeesus neile kõigile. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","„Sest kui tahate oma elu säästa, siis kaotate selle; ja kui kaotate oma elu minu pärast, päästate selle. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mis kasu oleks teil kogu maailmast, kui oleksite lõpuks kadunud või hävitatud? ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kui te häbenete mind ja minu sõnumit, häbeneb inimese Poeg teid, kui ta tuleb oma hiilguses ning Isa ja pühade inglite hiilguses. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ma räägin teile tõtt: mõned siinseisjaist ei maitse surma enne, kui näevad Jumala riiki.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Umbes kaheksa päeva pärast sellest rääkimist võttis Jeesus Peetruse, Johannese ja Jaakobuse kaasa ning läks üles mäele palvetama. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Sel ajal kui ta palvetas, muutus tema näo välimus ning riided muutusid pimestavalt valgeks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Säravas hiilguses ilmus kaks meest. Need olid Mooses ja Eelija. Nad hakkasid Jeesusega rääkima. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nad kõnelesid tema surmast, mis pidi peagi Jeruusalemmas aset leidma. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peetrus ja teised magasid. Kui nad ärkasid, nägid nad Jeesust hiilguses ja kaht meest tema kõrval seismas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kui kaks meest hakkasid lahkuma, ütles Peetrus Jeesusele: „Õpetaja, siin on hea olla. Teeme mõne varjualuse: ühe sulle, ühe Moosesele ja ühe Eelijale.“ Tegelikult ei teadnud ta, mida ta räägib. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kui ta alles rääkis, tuli pilv ja laienes nende üle. Nad olid pilvesse sisenedes kohkunud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pilvest kõneles hääl, mis ütles: „See on minu Poeg, Valitu. Kuulake teda!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kui hääl kõnelemise lõpetas, oli Jeesus seal üksinda. Nad hoidsid selle enda teada ega rääkinud tol ajal kellelegi, mida nad olid näinud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Järgmisel päeval, kui nad mäelt alla tulid, ootas Jeesust tohutu suur rahvahulk. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Üks mees rahva seast hüüdis: „Õpetaja, palun vaata mu poega! Ta on mu ainus laps. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Üks vaim vaevab teda ja ta hakkab siis karjuma. See vaim tekitab talle krampe ja laseb suust vahtu välja voolata. See ei jäta teda üldse rahule ja tekitab palju valu. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ma palusin su jüngritel see vaim välja ajada, aga nad ei suutnud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","„Missugune uskmatu ja rikutud rahvas te olete! Kui kauaks pean ma siia teie juurde jääma ja teid taluma?“ ütles Jeesus. „Too oma poeg siia!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kohe kui poiss tuli, tekitas kuri vaim talle krambid ja heitis ta maha. Kuid Jeesus segas vahele, noomis kurja vaimu ja tervendas poisi ning andis ta tema isale tagasi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kõik olid sellest Jumala väe ilmingust jahmunud. Aga kuigi kõik olid sellest hämmastunud, hoiatas Jeesus oma jüngreid: ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","„Kuulake tähelepanelikult, mida ma teile räägin: inimese Poeg antakse ära inimeste kätte.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Aga nad ei saanud aru, mida ta sellega mõtles. Selle tähendus oli nende eest varjatud, nii et nad ei mõistnud selle mõtet ning nad kartsid temalt selle kohta küsida. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Siis tekkis jüngrite keskel vaidlus, kes neist on suurim. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kuid Jeesus, teades, mille üle nad vaidlesid, valis ühe väikese lapse ja võttis ta enda kõrvale. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Seejärel ütles ta neile: „Igaüks, kes võtab selle väikese lapse vastu minu nimel, võtab vastu minu, ja kes võtab vastu minu, võtab vastu selle, kes mind läkitas. Kes iganes on teie seas väikseim, on suurim.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Johannes hakkas kõnelema ja ütles: „Õpetaja, me nägime, et keegi ajas sinu nimel välja kurje vaime, ja me püüdsime teda takistada, sest ta ei ole üks meist.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","„Ärge takistage teda,“ vastas Jeesus. „Igaks, kes ei ole teie vastu, on teie poolt.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kui Jeesuse taevasse minemise aeg lähenes, otsustas ta minna Jeruusalemma. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ta läkitas käskjalad enda eel Samaaria küladesse, et asjad tema jaoks valmis panna. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kuid inimesed ei võtnud teda vastu, sest ta oli otsustanud tõtata Jeruusalemma. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kui Jaakobus ja Johannes nägid seda, küsisid nad Jeesuselt: „Õpetaja, kas tahad, et kutsume tule taevast alla, et see põletaks nad ära?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kuid Jeesus pöördus ja noomis neid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Siis läksid nad edasi järgmisesse külasse. ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sel ajal kui nad kõndisid, ütles üks mees Jeesusele: „Ma järgnen sulle, kuhu iganes sa lähed!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jeesus lausus mehele: „Rebastel on urud ja lindudel pesad, kuid inimese Pojal ei ole kohta, kuhu oma pead toetada.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ta ütles ühele teisele mehele: „Järgne mulle!“ Aga mees vastas: „Õpetaja, las ma lähen kõigepealt koju ja matan oma isa.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","„Las surnud matavad oma surnud,“ vastas Jeesus. „Sina mine ja kuuluta Jumala riiki.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Veel üks mees ütles: „Issand, ma tahan sind järgida! Aga las ma kõigepealt lähen koju ja jätan oma perega hüvasti.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kuid Jeesus ütles talle: „Mitte keegi, kes on kord kündmist alustanud ja vaatab siis tagasi, ei kõlba Jumala riiki.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pärast seda määras Issand veel seitsekümmend jüngrit ja saatis nad paarides kõigisse linnadesse ja paikadesse, mida tal oli plaanis külastada. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","„Lõikus on suur, aga tööliste arv on väike,“ ütles ta neile. „Paluge lõikuse Issandat, et ta saadaks välja töölisi oma põldudelt saaki koguma. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nii et asuge teele: ma läkitan teid nagu lambaid huntide keskele. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ärge võtke kaasa raha ega kotti ega lisasandaale ning ärge veetke aega lobisedes inimestega, keda kohtate. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kuhu majja te iganes astute, öelge kõigepealt: „Rahu olgu sellele majale.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kui seal elab rahumeelne inimene, siis jääb teie rahu tema peale; kui mitte, tuleb see teie juurde tagasi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Jääge sellesse majja, sööge ja jooge, mida teile antakse, sest tööline on tasu väärt. Ärge käige majast majja. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kui lähete linna ja sealsed elanikud võtavad teid vastu, siis sööge, mis teie ette pannakse, ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ning tehke terveks need, kes on haiged. Öelge neile: „Jumala riik on teie juurde tulnud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Aga kui sisenete linna ja sealsed elanikud ei võta teid vastu, käige läbi linnatänavate ja öelge: ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","„Me pühime maha isegi tolmu, mis teie linnast on meie jalgade külge jäänud, et näidata teile oma hukkamõistu. Aga te peaksite ära tundma selle: Jumala riik on tulnud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ma ütlen teile, kohtupäeval on Soodoma põli parem kui sellisel linnal. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Häbi olgu sul, Korasin! Häbi olgu sul, Betsaida! Sest kui need imed, mida olete teie näinud, oleksid juhtunud Tüüroses ja Siidonis, oleksid nad juba ammu kahetsenud ning kotiriides ja tuhas istunud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Sellepärast on kohtus Tüürosel ja Siidonil parem kui teil. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ja sina, Kapernaum, sind ei ülendata taevasse, sa lähed alla manalasse. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Igaüks, kes teid kuuleb, see kuuleb mind, ja igaüks, kes teid põlgab, see põlgab mind. Aga igaüks, kes mind põlgab, see põlgab seda, kes mind läkitas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Seitsekümmend jüngrit tulid tagasi suure vaimustusega ja rääkisid: „Issand, isegi kurjad vaimud teevad seda, mida me neid sinu nimel käsime!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jeesus vastas: „Ma nägin Saatanat otsekui välku taevast alla langemas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Jah, ma olen andnud teile võime astuda madude ja skorpionide peale ning võita kõik vaenlase väed ja miski ei tee teile kahju. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kuid ärge rõõmustage selle üle, et vaimud teevad seda, mida käsite; olge lihtsalt rõõmsad, et teie nimed on taevas kirja pandud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sel hetkel täitus Jeesus Püha Vaimu rõõmuga ja ütles: „Ma tänan sind, Isa, taeva ja maa Issand, et sa varjad neid asju mõistlike ja tarkade eest ning avaldad need lastele! Jah, Isa, sa oled nii toiminud oma heameele järgi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mu Isa on andnud minu kätte kõik. Keegi ei mõista Poega, välja arvatud Isa, ja keegi ei mõista Isa, välja arvatud Poeg ning need, kellele Poeg otsustab teda ilmutada.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kui nad olid omapead, pöördus Jeesus jüngrite poole ja ütles neile: „Need, kes näevad seda, mida teie näete, peaksid väga õnnelikud olema! ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ma ütlen teile, paljud prohvetid ja kuningad on tahtnud näha seda, mida teie näete, kuid ei ole näinud, ning tahtnud kuulda seda, mida teie kuulete, kuid ei ole kuulnud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kord tõusis püsti üks vaimuliku seaduse tundja ja üritas Jeesust lõksu püüda. „Õpetaja,“ küsis ta, „mida ma pean tegema, et saada igavene elu?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","„Mis on seaduses kirjas? Kuidas sa sealt loed?“ küsis Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","„Armasta Issandat, oma Jumalat, kogu oma südame ja kogu oma vaimu ja kogu oma jõu ja kogu oma mõistusega ning armasta oma kaasinimest nagu iseennast,“ vastas mees. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","„Sul on õigus,“ ütles Jeesus talle. „Tee seda ja sa elad.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kuid mees soovis end õigustada ja küsis seega Jeesuselt: „Ja kes on siis mu kaasinimene?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jeesus vastas, öeldes: „Üks mees läks Jeruusalemmast alla Jeerikosse. Teda ründasid röövlid, kes varastasid ta paljaks ja peksid teda ning jätsid ta teda surnuks pidades maha. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Siis juhtus, et üks preester tuli sama teed pidi. Ta nägi meest, kuid möödus temast teist teeäärt pidi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Seejärel tuli üks leviit. Aga kui ta jõudis sellesse kohta ja nägi meest, läks ka tema teist teeäärt pidi temast mööda. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Viimaks tuli üks samaarlane. Kui ta möödumas oli, nägi ta meest ja tal hakkas temast kahju. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ta läks tema juurde, määris haavu õli ja veiniga ja sidus haavad kinni. Siis asetas ta mehe oma eesli selga ja viis ta võõrastemajja, kus hoolitses tema eest. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Järgmisel päeval andis ta võõrastemaja peremehele kaks denaari ja ütles: „Hoolitse tema eest ja kui kulutad sellest rohkem, siis tasun sulle selle tagasi tulles.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kes neist kolmest oli sinu arvates selle mehe kaasinimene, keda röövlid ründasid?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","„See, kes talle head tegi,“ vastas mees. „Mine ja tee niisamuti,“ ütles Jeesus talle. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kui nad olid teel, jõudis Jeesus ühte külla ning naine nimega Marta kutsus ta enda koju. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tal oli õde nimega Maarja, kes istus Issanda jalge ees ja kuulas tema õpetusi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta oli mures kõige selle pärast, mida oli vaja toidu valmistamiseks teha, seepärast tuli ta Jeesuse juurde ja ütles: „Õpetaja, kas sa ei hooli sellest, et mu õde on jätnud mu kogu tööd üksi ära tegema? Käsi tal tulla ja mind aidata!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","„Marta, Marta,“ vastas Issand, „sa oled kõige selle pärast mures ja endast väljas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Aga tõeliselt vajalik on ainult üks asi. Maarja on selle õige valinud ja seda ei võeta temalt ära.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kord oli Jeesus ühes kohas palvetamas. Kui ta lõpetas, küsis üks ta jüngritest temalt: „Issand, palun õpeta meid palvetama, nagu Johannes õpetas oma jüngreid.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jeesus ütles neile: „Kui te palvetate, siis öelge: „Isa, olgu su nimi pühana austatud. Sinu riik tulgu. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Anna meile iga päev toitu, mida vajame. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Anna andeks meie patud, nagu meie andestame kõigile, kes meie vastu patustavad. Hoia meid kiusatuse eest.““ ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jeesus rääkis neile veel: „Oletame, et sul on sõber ja sa lähed keset ööd tema juurde ja küsid: „Mu sõber, laena mulle kolm pätsi leiba, ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","sest mu sõber tuli mulle külla ja mul pole talle midagi süüa anda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Su sõber majas võib vastasta: „Ära tüüta mind, uks on juba lukus ning mina ja mu lapsed oleme juba voodis. Ma ei saa praegu üles tõusta, et sulle midagi anda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ma ütlen teile, isegi kui ta keeldub tõusmast ja sulle midagi andmast sellepärast, et oled tema sõber, siis tõuseb ta ometi ja annab sulle kõik, mida vajad, kui sa talle peale käid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ma ütlen teile: paluge, ja te saate; otsige, ja te leiate; koputage, ja uks avatakse teile. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sest igaüks, kes palub, see saab, kes otsib, see leiab, ja kes koputab, sellele avatakse uks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kui su poeg palub kala, kes teist, isadest, annaks talle selle asemel mao? ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Või kui ta palub muna, annaks talle skorpioni? ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Niisiis, kui teie, kuigi te olete kurjad, oskate oma lastele häid ande anda, kui palju enam annab taevane isa Püha Vaimu neile, kes temalt paluvad?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jeesus ajas välja kurja vaimu, kes muutis mehe tummaks. Kui kuri vaim oli lahkunud, siis mees, kes oli tumm, kõneles, ja rahvas oli hämmastunud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Aga mõned neist ütlesid: „Ta ajab kurje vaime välja Peltsebuli, kurjade vaimude valitseja väe abil.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Teised üritasid Jeesuse proovile panna, nõudes imelisi märke taevast. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jeesus teadis, mida nad mõtlevad, ning ütles: „Iga kuningriik, mis on iseendaga riius, variseb kokku. Iga perekond, mis on iseendaga riius, langeb. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kui Saatan on iseendaga riius, kuidas saab tema riik püsida? Te ütlete, et ma ajan kurje vaime välja Peltsebuli väge kasutades. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Aga kui mina ajan kurje vaime välja Peltsebuli väe abil, kelle väega ajavad teie inimesed neid välja? Nad ise tunnistavad, et te eksite! ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Aga kui mina ajan kurje vaime välja Jumala väe abil, siis tõestab see, et Jumala riik on saabunud. See on siinsamas, teie keskel! ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kui tugev, täies relvastuses mees valvab oma maja, siis on kogu tema omand kaitstud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Aga kui tuleb tugevam mees ja saab temast jagu ning võtab talt ära kõik relvad, millele ta lootis, siis saab ta ära viia kogu tema vara. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Igaüks, kes ei ole minu poolt, on minu vastu, ja igaüks, kes koos minuga ei ehita, see lammutab kõik maha. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kui kuri vaim lahkub kellestki, käib ta läbi kõnnumaa, otsides kohta, kuhu jääda. Kui ta seda kusagilt ei leia, ütleb ta: „Ma lähen tagasi majja, kust ma lahkusin.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kui ta tagasi tuleb, leiab ta, et tema endine kodu on puhtaks pühitud ja korras. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Seega läheb ta ja otsib veel seitse vaimu, kes on temast kurjemad, ning nad lähevad ja elavad seal. Lõpuks on see mees hullem kui enne.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kui ta kõneles, hüüdis üks naine rahva hulgast: „Õnnistatud on üsk, kust sa välja tulid, ja rinnad, mis sind imetasid!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Aga Jeesus ütles: „Veel rohkem on õnnistatud need, kes kuulevad Jumala sõna ja toimivad selle järgi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kui rahvas Jeesuse ümber kogunes, hakkas ta neile kõnelema: „See on üks kuri põlvkond, sest otsib mõnd imelist tunnustähte, kuid neile ei anta ühtki muud tunnustähte peale Joona tunnustähe. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Samamoodi nagu Joona oli Niineve rahva jaoks tunnustäht, on ka inimese Poeg tunnustäht selle põlvkonna jaoks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Lõunamaa kuninganna tõuseb kohtupäeval üles koos selle põlvkonna rahvaga ning mõistab nad hukka, sest tema tuli maailma otsast kuulama Saalomoni tarkust, aga siin on praegu keegi, kes on suurem kui Saalomon! ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Niineve elanikud tõusevad kohtupäeval üles koos selle põlvkonnaga ja mõistab nad hukka, sest nemad kahetsesid, kui kuulsid Joona sõnumit, aga siin on praegu keegi, kes on suurem kui Joona! ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Keegi ei süüta lampi ega peida siis seda ega aseta vaagna alla. Ei, lamp asetatakse lambijalale, et need, kes majja sisenevad, näeksid valgust. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Silm on ihule valguseks. Kui silm on hea, on kogu ihu valgust täis. Aga kui silm on halb, on kogu ihu pimeduses. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hoolitsege siis selle eest, et teis olev valgus ei oleks tegelikult pimedus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kui kogu ihu on valgust täis ja pimedusel ei ole ruumi, siis on ihu täielikult valgustatud, samamoodi nagu särav lamp annab valgust.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pärast seda kui Jeesus oli kõnelemise lõpetanud, kutsus üks variser ta enda juurde sööma. Nõnda siis Jeesus läks ja istus maha sööma. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Variser oli üllatunud, et Jeesus ei pesnud enne söömist käsi, nagu tseremoniaalselt oli nõutud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Seepärast ütles Issand talle: „Teie, variserid, puhastate karika ja vaagna väljastpoolt, kuid seestpoolt olete täis ahnust ja õelust. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Te olete nii rumalad! Kas te ei arva, et see, kes tegi välise, tegi ka sisemise? ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kui te seesmiselt ajendatuna tegutsedes teete teistele head, siis on teie jaoks kõik puhas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Häbi teil olgu, variserid! Te maksate kümnist ürtidest ja taimedest, kuid jätate hooletusse Jumala õigluse ja armastuse. Esimest ei tohi tegemata jätta, kuid samas peate tähelepanu pöörama ka viimasele. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Häbi teil olgu, variserid! Te armastate parimaid istekohti sünagoogides ja austavat tervitamist turuplatsil. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Häbi teil olgu! Te olete nagu tähistamata hauad, millest inimesed üle kõnnivad, ise seda teadmata.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Üks vaimuliku seaduse tundjatest vastas, öeldes: „Õpetaja, kui sa niimoodi räägid, siis sa solvad ka meid!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jeesus kostis: „Häbi olgu ka teil, seadusetundjad! Te asetate inimestele koormad, mis on kandmiseks liiga rasked, kuid ise ei liiguta sõrmegi, et neid aidata. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Häbi teil olgu! Te ehitate hauamonumente prohvetite auks, kuid teie enda isad tapsid nad! ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nii tehes olete tunnistajad, kes näitavad, et on nõus sellega, mida teie isad tegid. Nad tapsid prohvetid ja teie ehitate monumendid! ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Sellepärast on Jumal oma tarkuses öelnud: „Ma saadan neile prohveteid ja apostleid; mõned neist nad tapavad ja teisi kiusavad nad taga.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Järelikult peetakse seda põlvkonda vastutavaks kõigi prohvetite vere eest, mis on valatud maailma algusest peale, ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","alates Aabeli verest kuni Sakarja vereni, kes tapeti altari ja pühamu vahel. Jah, ma ütlen teile, see põlvkond peab kõige selle eest vastutama. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Häbi teil olgu, seadusetundjad! Te olete teadmiste võtme ära võtnud. Ise te sisse ei läinud ja teistel ei lasknud te ka sisse minna.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kui Jeesus oli lahkumas, hakkasid vaimulikud õpetajad ja variserid teda agressiivselt ründama, esitades tema provotseerimiseks küsimusi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Nad lootsid ta tabada, üritades sundida teda ütlema midagi, mida saaks tema vastu kasutada. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Vahepeal oli kogunenud nii palju tuhandeid inimesi, et nad astusid üksteisele peale. Jeesus hakkas kõnelema esmalt oma jüngritele. „Hoidke end variseride juuretise − silmakirjalikkuse − eest. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sest pole midagi varjatut, mis ei saaks avalikuks, ega midagi salajast, millest ei saadaks teada. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Seda, mida olete pimedas öelnud, kuuldakse valges; mida olete salajas sosistanud, seda kuulutatakse katustelt. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ma ütlen teile, mu sõbrad, ärge kartke neid, kes ihu tapavad, sest kui nad on seda teinud, ei saa nad enam midagi rohkem teha. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Lubage, et ma selgitan, keda te peaksite kartma. Te peaks kartma seda, kellel on võim teid pärast tapmist Gehennasse heita. Tema on see, keda peaksite kartma. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kas mitte viis varblast ei müüda kahe penni eest? Kuid Jumal ei unusta neist ühtki. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Isegi juuksekarvad teie peas on ära loetud. Ärge kartke, te olete rohkem väärt kui palju varblasi! ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ma räägin teile tõtt: kes avalikult tunnistavad, et nad kuuluvad mulle, nende kohta tunnistab ka inimese Poeg Jumala inglite ees, et nad kuuluvad talle, ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","aga kes mind salgavad, neid salatakse Jumala inglite ees. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Igaühele, kes kõneleb inimese Poja vastu, antakse andeks, aga kes teotab Püha Vaimu, sellele ei anta andeks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Kui teid tuuakse kohtusse sünagoogide, ülemate ja valitsejate ette, siis ärge muretsege sellepärast, kuidas end kaitsta või mida peaksite ütlema. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Püha Vaim õpetab teile sel hetkel, mida on oluline öelda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Keegi rahva hulgast küsis Jeesuselt: „Õpetaja, palun ütle mu vennale, et ta jagaks minuga pärandust.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","„Mu sõber,“ vastas Jeesus, „kes määras mind teie kohtumõistjaks otsustama, kuidas teie pärandus tuleks jagada?“ Ta ütles rahvale ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","„Olge valvel ja hoiduge kõigist ahnetest mõtetest ja tegudest, sest inimese elu ei olene asjadest, mida ta omab.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Seejärel jutustas ta neile näitlikustamiseks ühe loo. „Elas kord üks rikas mees, kellel oli väga viljakas maa. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mees arutles endamisi: „Mida ma peaksin tegema? Mul pole kusagil oma vilja hoida. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ma tean, mida ma teen,“ otsustas ta. „Ma lõhun oma aidad maha ja ehitan suuremad aidad, siis on mul ruumi, kus hoida kogu oma vilja ja kõike, mis mul on. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Siis ütlen endale: sul on piisavalt, et elada palju aastaid, nii et võta elu rahulikult: söö, joo ja tunne rõõmu!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Aga Jumal ütles talle: „Sina rumal mees! Selsamal ööl nõutakse su elu tagasi ja kes saab siis kõik selle, mida sa oled varunud?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nii juhtub inimestega, kes kuhjavad endale vara, kuid ei ole rikkad Jumalas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jeesus rääkis oma jüngritele: „Sellepärast ma ütlen teile, et ärge muretsege oma elu pärast, mida süüa, ega oma rõivaste pärast, mida kanda. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Elu on palju enam kui toit ja ihu enam kui rõivaste kandmine. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Vaadake ronki. Nad ei külva ega lõika, neil ei ole ladu ega aita, kuid Jumal toidab neid. Ja teie olete palju väärtuslikumad kui linnud! ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kas suudate elu pärast muretsemisega lisada oma elule tunnigi? ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kui te ei suuda nii väikest asja, miks siis ülejäänu pärast muretseda? ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mõelge liiliatele ja sellele, kuidas nad kasvavad. Nad ei tööta ega ketra lõnga rõivaste jaoks, aga ma ütlen teile, et isegi Saalomon kogu oma hiilguses ei olnud nii kaunilt riietatud kui üks neist. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nii et kui Jumal rüütab väljad nii kaunite lilledega, mis täna on siin, aga homme kadunud, kui nad põletatakse tules, et ahju kütta, kui palju enam riietab Jumal teid, kellel on nii vähe usku! ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ärge olge mures sellepärast, mida te sööte või joote − ärge muretsege sellepärast. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kõigi nende asjade pärast muretsevad inimesed maailmas, kuid teie Isa teab, et te neid vajate. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Otsige Jumala riiki ja teile antakse ka kõike seda. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ära karda, väike kari, sest teie Isa annab teile hea meelega kuningriigi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Müüge ära, mis teil on, ja andke raha vaestele. Hankige endale kukrud, mis ei kulu, aare taevas, mis ei saa iial otsa, kus varas ei saa seda varastada ega koi hävitada. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sest see, mida te väärtuslikuks peate, näitab, kes te tegelikult olete. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Olge riietatud ja valmis ning hoidke lambid põlemas, ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","nagu oma isandat pulma pidusöögilt tagasi ootavad sulased, kes on valmis ukse nobedalt avama, kui isand tuleb ja koputab. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nende sulaste jaoks on hea, kui isand leiab nad valvamas, kui tagasi tuleb. Ma räägin teile tõtt: ta paneb riidesse, laseb neil söögilauda istuda ning tuleb ja teenib neid ise! ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Isegi kui ta tuleb keskööl või vahetult enne koitu − kui hea on see sulaste jaoks, kui isand leiab, et nad valvavad ja on valmis! ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Aga pidage meeles seda: kui isand teaks, millal varas tuleb, siis oleks ta valvel ega laseks oma majja sisse murda. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ka teie peate valmis olema, sest inimese Poeg tuleb siis, kui te ei oska arvatagi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","„Kas sa räägid selle loo ainult meile või kõigile?“ küsis Peetrus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Issand vastas: „Kes on siis usaldusväärne ja arukas kojaülem, see inimene majapidamises, kelle isand paneb vastutama õigel ajal toidu väljajagamise eest? ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Selle sulase jaoks on hea, kui isand tagasi tulles leiab, et ta teeb seda, mida peab. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ma räägin teile tõtt: isand paneb selle sulase kõige eest vastutama. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Aga mis siis, kui see sulane ütleks endamisi: „Mu isandal läheb tulemisega kaua aega,“ ning ta hakkaks teisi sulaseid ja teenijatüdrukuid peksma, pidutsema ja purjutama? ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Selle sulase isand tuleks ootamatult ühel päeval tagasi, ajal, mil ta ei oota, ning karistaks teda rängalt, koheldes teda nagu täielikult ebausaldusväärset. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","See sulane, kes teadis, mida tema isand tahab, ja ometi ei olnud valmis ega järginud isanda juhiseid, saab kõvasti peksa; ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","aga sulane, kes ei teadnud ja tegi karistust väärt asju, saab ainult vähe peksa. Kellele on antud palju, sellelt ka oodatakse palju, ja kellele on usaldatud rohkem, sellelt nõutakse rohkem. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ma olen tulnud maad süütama ja ma tõesti soovin, et see juba põleks! ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Aga ma pean minema läbi ristimise, ma olen ahastuses ja soovin, et see oleks läbi! ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kas te arvate, et ma tulin maa peale rahu tooma? Ei, ma ütlen teile, ma toon lahkmeelt. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nüüdsest peale on nii, et kui peres on viis liiget, on nad lahkarvamusel: kolm on kahe vastu ja kaks kolme vastu. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nad kõik on üksteise vastu − isa poja vastu ja poeg isa vastu, ema tütre vastu ja tütar ema vastu, ämm minia vastu ja minia ämma vastu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Siis kõneles Jeesus rahvale. „Kui te näete läänest pilve tõusmas, ütlete te kohe: „Vihmasadu on tulemas,“ ja nii toimub. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kui puhub lõunatuul, ütlete te: „Läheb palavaks,“ ja nii on. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Te silmakirjatsejad, kuidas see nii on, et te oskate õigesti tõlgendada ilma, kuid te ei oska tõlgendada praegust aega? ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Miks te oma peaga ei mõtle ega otsusta, mida on õige teha? ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kui lähete koos oma süüdistajaga kohtuniku juurde, siis peaksite teel olles püüdma lahendust leida. Muidu veetakse teid kohtu ette ja kohtunik annab teid ametniku kätte ja ametnik heidab teid vanglasse. ");
INSERT INTO ekkpkp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ma ütlen teile, te ei pääse enne välja, kui olete oma viimase penni ära maksnud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Umbes sel ajal räägiti Jeesusele, et Pilaatus tappis mõned galilealased sel ajal, kui nad tõid templis ohvreid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","„Kas te arvate, et kuna need galilealased kannatasid seda, olid nad hullemad patused kui ükskõik missugused teised galilealased?“ küsis Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","„Ma ütlen teile, ei. Aga kui te meelt ei paranda, siis hukkute ka teie kõik. ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kuidas on nende kaheksateistkümne inimesega, kes said surma, kui Siiloahi torn neile peale kukkus? Kas te arvate, et nad olid kõige hullemad inimesed kogu Jeruusalemmas? ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ma ütlen teile, ei. Aga kui te meelt ei paranda, siis hukkute ka teie kõik.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Siis jutustas ta neile näitlikustamiseks selle loo. „Elas kord mees, kellel oli viinapuuaeda istutatud viigipuu. Ta tuli puu otsast vilja otsima, kuid ei leidnud midagi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nii ütles ta aednikule: „Vaata, kolm aastat olen käinud selle viigipuu otsast vilja otsimas ega ole midagi leidnud. Raiu see maha! Miks ta peaks siin ruumi raiskama?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","„Isand,“ vastas mees, „palun jäta ta veel ainult üheks aastaks. Ma kaevan ta ümber mulda ja panen sinna väetist. ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kui ta annab vilja, siis on hästi. Kui mitte, siis raiu see maha.““ ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ühel hingamispäeval õpetas Jeesus sünagoogis ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ja seal oli naine, keda kuri vaim oli kaheksateist aastat vigasena hoidnud. Naine oli küürus ega saanud sirgelt seista. ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kui Jeesus teda nägi, kutsus ta naise enda juurde ja ütles talle: „Sa oled oma haigusest vabastatud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Siis pani ta käe naise peale; kohe ajas naine end sirgu ja ülistas Jumalat. ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kuid sünagoogi ülem oli pahane, et Jeesus oli hingamispäeval terveks teinud. Ta ütles rahvale: „Kuus päeva on töö jaoks. Tulge neil päevadel ja laske end terveks teha, mitte hingamispäeval.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Aga Issand vastas talle: „Te silmakirjatsejad! Kas igaüks teist ei päästa oma härga või eeslit tallist lahti ega vii teda jooma? ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Miks ei tohiks see naine, see Aabrahami tütar, keda Saatan on kaheksateist aastat sidunud, saama sel hingamispäeval lahti seotud ja vabastatud?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tema öeldu pani kõik vastased häbenema, kuid rahva seas tundsid kõik rõõmu neist imelistest asjadest, mida ta tegi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Seejärel küsis Jeesus: „Missugune on siis Jumala riik? Millega peaksin seda võrdlema? ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","See on nagu sinepiseeme, mille mees oma aeda külvas. See kasvas puuks ning linnud tulid ja tegid selle okstele pesa.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ta küsis taas: „Millega peaksin Jumala riiki võrdlema? ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","See on nagu juuretis, mille naine võttis ja segas kolme mõõdu jahu hulka ning see pani kogu taina kerkima.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Teel Jeruusalemma käis Jeesus ringi linnades ja külades õpetades. ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Keegi küsis talt: „Issand, kas ainult vähesed saavad päästetud?“ Jeesus vastas: ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","„Püüdke väga tõsiselt sisse minna kitsast uksest, sest ma ütlen teile, et paljud püüavad sisse minna, kuid see ei õnnestu neil. ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kui majaomanik tõuseb ja ukse suleb, seisate väljas, koputate uksele ja ütlete: „Isand, palun tee meile uks lahti!“ Aga tema vastab: „Ma ei tunne teid ega tea, kust te pärit olete.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Siis te ütlete: „Aga me sõime ja jõime koos sinuga ja sina õpetasid meie tänavatel!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Tema vastab: „Ma ütlen teile, ma ei tunne teid ega tea, kust te pärit olete. Minge minu juurest minema kõik, kes te ei tee seda, mis on hea!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Siis on nutmine ja hammaste kiristamine, kui näete Aabrahami, Iisakit, Jaakobit ja kõiki prohveteid Jumala riigis, aga teie olete välja heidetud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Inimesed tulevad idast ja läänest, põhjast ja lõunast ning istuvad maha, et Jumala riigis süüa. ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sest viimased saavad esimesteks ja esimesed viimasteks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sel hetkel tulid Jeesuse juurde mõned variserid ja ütlesid talle: „Sa pead siit lahkuma. Heroodes tahab sind tappa!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jeesus vastas: „Minge öelge sellele rebasele, et ma jätkan kurjade vaimude väljaajamist ja inimeste tervendamist täna ja homme ning kolmandal päeval viin lõpule selle, mida ma tegema tulin. ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Igatahes pean jätkama oma teed täna ja homme ja ülehomme. Sest prohvetil ei oleks õige surra väljaspool Jeruusalemma! ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Oh Jeruusalemm, Jeruusalemm, sa tapad prohvetid ja viskad kividega surnuks need, kes on sinu juurde läkitatud! Kui sageli olen tahtnud koguda kõiki su lapsi nagu kana kogub tibud oma tiibade alla, aga te ei ole tahtnud! ");
INSERT INTO ekkpkp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Vaadake, teie koda jäetakse maha ja ma ütlen teile, et te ei näe mind enne, kui ütlete: „Õnnistatud on see, kes tuleb Issanda nimel.““ ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ühel hingamispäeval läks Jeesus einestama ühe variseride ülema koju, kus nad teda hoolikalt jälgisid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Seal oli üks mees, kelle käed ja jalad olid tursunud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Niisiis küsis Jeesus vaimuliku seaduse tundjatelt ja variseridelt: „Kas seadus lubab hingamispäeval terveks teha või mitte?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Aga nad vaikisid. Jeesus puudutas meest, tegi ta terveks ja saatis oma teed. ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Siis ütles Jeesus neile: „Kui teie poeg või härg kukuks juhtumisi hingamispäeval kaevu, kas te ei tõmbaks teda siis kohe välja?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nad ei suutnud vastust anda. ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nii rääkis ta loo külalistele, sest ta märkas, kuidas nad olid valinud istumiseks aukohti. ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","„Kui sind on kutsutud pulmapeole, siis ära istu aukohale, sest võib-olla on kutsutud keegi, kes on sinust tähtsam,“ alustas ta. ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","„Sinu võõrustaja, kes on teid mõlemat kutsunud, tuleb ja ütleb sulle: „Anna oma koht sellele inimesele.“ Siis pead sa piinlikkust tundes minema kohale, mis on järele jäänud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kui sind on kutsutud, siis vali hoopis kõige tagasihoidlikum koht, nii et kui su võõrustaja tuleb sisse, ütleb ta sulle: „Mu sõber, palun mine paremale kohale.“ Siis oleksid sa austatud kõigi külaliste ees, kes koos sinuga istuvad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sest neid, kes end ise ülendavad, alandatakse, ja neid, kes end ise alandavad, ülendatakse.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Seejärel ütles ta mehele, kes oli teda kutsunud: „Kui sa korraldad lõuna- või õhtusöögi, siis ära kutsu oma sõpru, vendi, sugulasi või rikkaid naabreid, et nad võiksid omakorda sind kutsuda ja nii saaksid sa tasu. ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kui sa korraldad pidusöögi, kutsu hoopis vaeseid, vigaseid, sante ja pimedaid, ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ning sa saad õnnistatud, sest neil ei ole sulle millegagi tasuda, ja sa saad tasu heade ülestõusmisel.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kui üks neist, kes koos Jeesusega lauas sõi, kuulis seda, ütles ta Jeesusele: „Kui imetore on neil, kes söövad peolauas Jumala riigis!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","„Elas kord üks mees, kes valmistas suure pidusöögi ja kutsus palju külalisi,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","„Kui saabus söögiaeg, saatis ta oma sulased kõigile kutsutuile ütlema: „Tulge, sest pidusöök on valmis!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Aga nad kõik hakkasid vabandusi esitama. Esimene ütles: „Ostsin just põllu ja pean minema seda vaatama. Palun vabanda mind.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Teine ütles: „Ostsin just viis paari härgi ja ma pean minema neid katsetama. Palun vabanda mind.“ Kolmas ütles: ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","„Võtsin just naise, nii et ma ei saa tulla.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Sulane läks tagasi ja rääkis oma isandale, mida nad olid öelnud. Majaisand sai pahaseks ja ütles oma sulasele: „Mine ruttu välja linna tänavatele ja kõrvaltänavatele ning too sisse vaesed, vigased, pimedad ja sandid.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Siis ütles sulane: „Isand, ma tegin nii, nagu sa käskisid, aga ikka on veel tühje kohti.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nii käskis isand sulast: „Mine välja maanteedele ja külatänavatele ning sunni inimesi tulema. Ma tahan, et koda saaks täis. ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ma ütlen sulle, ükski neist kutsututest ei saa mu pidusööki maitsta.““ ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jeesusega käis kaasas suur rahvahulk. Ta pöördus ja ütles neile: ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","„Kui te tahate mind järgida, kuid ei vihka oma isa ja ema, naist ja lapsi, vendi ja õdesid − koguni oma elu −, ei saa te mu jüngrid olla. ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kui te ei võta oma risti ega järgne mulle, ei saa te mu jüngrid olla. ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kui kavatsete torni ehitada, kas ei arvuta te kõigepealt, kui palju see maksma läheb, ega vaata, kas teil on piisavalt raha selle lõpetamiseks? ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kui te pärast vundamendi rajamist ei suuda seda valmis teha, siis naeraksid kõik, kes teid näevad, ja ütleksid: ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","„Vaadake teda: ta alustas ehitamist, kuid ei suutnud lõpetada.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Missugune kuningas läheb teise kuningaga sõtta, ilma et istuks enne koos nõuandjatega maha ega arvutaks, kas tema ja ta kümme tuhat meest suudavad võita tema vastu marssivad kakskümmend tuhat? ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kui ta ei suuda, saadab ta esindajad rahu paluma siis, kui teine kuningas on veel väga kaugel. ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Samamoodi on igaühega teist: kes ei loobu kõigest, ei saa minu jünger olla. ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sool on hea, aga kui see kaotab oma maitse, kuidas saab selle taas soolaseks muuta? ");
INSERT INTO ekkpkp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sellest pole kasu mulla ega väetisena – te viskate selle lihtsalt välja. Kellel kõrvad on, see kuulaku!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Maksukogujad ja teised „patused“ tulid sageli Jeesust kuulama. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Selletõttu kurtsid variserid ja vaimulikud õpetajad: „See mees võtab patuseid vastu ja sööb koos nendega.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Seega jutustas Jeesus neile näitlikustamiseks selle loo. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","„Kujutage ette meest, kel oli sada lammast ja ta kaotas ühe neist. Kas ta ei jätaks üheksakümmend üheksa karjamaale ega läheks otsima seda üht, kes on kadunud, kuni ta tema leiab? ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kui ta lamba leiab, paneb ta lamba rõõmsalt oma õlgadele. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kui ta koju jõuab, kutsub ta kokku oma sõbrad ja naabrid ning ütleb: „Tulge tähistage koos minuga! Ma leidsin oma kadunud lamba!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ma ütlen teile, et taevas on ühe meelt parandava patuse üle suurem rõõm kui üheksakümne üheksa hea inimese üle, kel ei ole meeleparandust vaja. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kujutage ette naist, kel on kümme hõbemünti, ja ta kaotab neist ühe. Kas ta ei süütaks lampi ega pühiks maja, otsides hoolikalt, kuni ta mündi leiab? ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kui ta selle leiab, kutsub ta oma sõbrad ja naabrid kokku ning ütleb: „Tulge tähistage koos minuga! Ma leidsin hõbemündi, mille ma ära kaotasin.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ma ütlen teile, et Jumala inglite juures on rõõm ühe patuse üle, kes meelt parandab. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Elas kord üks mees, kellel oli kaks poega,“ rääkis Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","„Noorem poeg ütles isale: „Isa, anna mu pärandus kohe kätte.“ Nõnda jagas siis mees oma vara poegade vahel. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mõne päeva pärast pani noorem poeg kokku kõik, mis tal oli, ja läks kaugele maale. Seal raiskas ta mõtlematut elu elades kogu raha ära. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pärast seda, kui ta kõik oli ära kulutanud, tabas seda maad raske näljahäda ja ta jäi nälga. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nii läks ta ja sai tööd ühe talumehe juures, kes saatis ta põllule sigu karjatama. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tema kõht oli nii tühi, et ta oleks söönud kas või sigade toitu, aga keegi ei andnud talle midagi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kui ta mõtlema hakkas, ütles ta endamisi: „Kõigil mu isa töölistel on süüa rohkem kui küllalt, miks mina siin näljast suremas olen? ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ma lähen oma isa juurde! Ma ütlen talle: isa, ma olen pattu teinud taeva ja sinu vastu. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ma ei ole enam väärt, et mind su pojaks nimetatakse. Palun kohtle mind nagu üht oma palgatöölistest.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nii ta siis lahkus ja läks koju oma isa juurde. Kuigi ta oli alles kaugel, nägi isa teda tulemas ja tema süda sai liigutatud. Ta jooksis pojale vastu, kallistas ja suudles teda. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Poeg ütles talle: „Isa, ma olen pattu teinud taeva ja sinu vastu. Ma ei ole enam väärt, et mind su pojaks nimetatakse.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kuid isa ütles oma sulastele: „Ruttu! Tooge parim kuub ja pange talle selga. Pange talle sõrmus sõrme ja sandaalid jalga. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tooge vasikas, keda oleme nuumanud, ning tapke see. Korraldame tähistamiseks pidusöögi, ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","sest see on minu poeg, kes oli surnud, kuid ärkas ellu; ta oli kadunud, aga nüüd on ta leitud.“ Niisiis hakkasid nad tähistama. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Vanem poeg aga oli väljas põllul tööl. Kui ta maja poole kõndis, kuulis ta muusikat ja tantsimist. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Seepärast kutsus ta ühe sulastest ja küsis, mis toimub. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","„Su vend on tagasi,“ vastas sulane, „ja su isa on tapnud nuumvasika, sest su vend on elusa ja tervena kodus.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Vend sai pahaseks ja keeldus sisse minemast. Siis tuli isa välja, et teda ümber veenda. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ta ütles isale: „Vaata, kõik need aastad olen ma sind teeninud, ma pole kunagi sõnakuulmatu olnud, aga sa pole mulle kunagi andnud kitsetallegi, et oleksin saanud oma sõpradega peo teha. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nüüd tuleb see sinu poeg tagasi, kui ta on sinu raha prostituutidele kulutanud, ja sina tapad tema jaoks nuumvasika!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","„Poeg,“ vastas isa, „sa oled alati siin minu juures. Kõik, mis on minu oma, on ka sinu oma. ");
INSERT INTO ekkpkp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Aga me peaksime olema rõõmsad ja tähistama! See on sinu vend, kes oli surnud, kuid ärkas ellu; ta oli kadunud, aga nüüd on ta leitud!““ ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jeesus jutustas oma jüngritele selle loo. „Elas kord üks rikas mees, kelle kojaülemat süüdistati oma isandale kuuluva vara raiskamises. ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Seega kutsus rikas mees oma kojaülema ja küsis temalt: „Mida ma sinu kohta kuulen? Esita oma aruanded, sest sa ei jätka enam kojaülema ametis.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kojaülem ütles endamisi: „Mida ma nüüd teen, kui mu isand kavatseb mu töölt lahti lasta? Ma pole piisavalt tugev, et kaevata, ning kerjata on mul häbi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ma tean, mida ma teen, et siis, kui mind kojaülema kohalt lahti lastakse, võtaksid inimesed mind hea meelega oma koju vastu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nõnda siis kutsus ta kõik need, kes tema isandale võlgu olid, enda juurde. Ta küsis esimeselt: „Kui palju sa mu isandale võlgu oled?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Mees vastas: „Sada mõõtu õli.“ Ta ütles temale: „Istu ruttu maha. Võta oma võlakiri ja muuda see viiekümneks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Siis küsis ta teiselt: „Kui palju sina võlgu oled?“ Mees vastas: „Sada mõõtu nisu.“ Ta ütles temale: „Võta võlakiri ja muuda see kaheksakümneks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Rikas mees kiitis oma ebaausat kojaülemat tema leidliku idee eest. Selle maailma lapsed on üksteise suhtes leidlikumad kui valguse lapsed. ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ma ütlen teile, kasutage selle maailma vara, et leida endale sõpru, nii et kui see on läbi, siis võetaks teid igavesse koju vastu. ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kui teie kätte võib usaldada väga vähest, võib teile usaldada ka palju; kui olete ebaausad vähesega, olete ebaausad ka paljuga. ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kui teid ei saa usaldada ilmaliku vara mõttes, kes usaldaks teile siis tõelise rikkuse? ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ja kui teid ei saa usaldada sellega, mis kuulub kellelegi teisele, kes usaldaks siis teile teie oma? ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Üks sulane ei saa kuuletuda kahele isandale. Ta kas vihkab üht ja armastab teist või on pühendunud ühele ja põlgab teist. Te ei saa teenida mõlemat, Jumalat ja raha.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Variserid, kes armastasid raha, kuulsid, mida Jeesus ütles, ja naersid tema üle. ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Aga Jeesus ütles neile: „Te paistate inimestele vagad, aga Jumal teab, mida te mõtlete. Jumal põlgab seda, mida inimesed kõrgelt hindavad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Seadusesse ja prohvetitesse kirjutatust jätkus Johanneseni. Sellest ajast alates on levitatud head sõnumit Jumala riigist ja kõik pingutavad, et sinna sisse minna. ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kuid taeval ja maal on lihtsam lõppeda kui Seaduse väikseimal punktil kaduda. ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Iga mees, kes lahutab oma naisest ja abiellub teisega, rikub abielu, ning mees, kes abiellub lahutatud naisega, rikub abielu. ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Elas kord üks mees, kes oli rikas. Ta kandis purpurrõivaid ja peenlinast ning nautis luksuslikku elu. ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tema värava juures istus enamasti üks kerjus nimega Laatsarus. Ta oli haavanditega kaetud ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ja soovis süüa rikka mehe laualt jäävaid jääke. Isegi koerad tulid ja lakkusid tema haavu. ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Siis kerjus suri ja inglid kandis ta Aabrahami juurde. Ka rikas mees suri ja maeti. ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Allilmas, kus ta oli piinades, vaatas ta üles ja nägi kaugelt Aabrahami ja Laatsarust tema kõrval. ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","„Isa Aabraham,“ hüüdis ta, „halasta mu peale ja saada Laatsarus, et ta kastaks oma sõrme vette ja jahutaks mu keelt, sest ma hõõgun piinas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Aga Aabraham vastas: „Mu poeg, meenuta, et sa nautisid elus häid asju, samal ajal kui Laatsarusel oli väga kehv elu. Nüüd leiab tema lohutust, samas sina kannatad piinu. ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Peale selle on meie ja teie vahel laiumas suur kuristik. Mitte keegi, kes tahab, ei saa minna siit üle sinna teie juurde, ja mitte keegi ei saa tulla üle sealt meie juurde.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Rikas mees ütles: „Siis anun sind, isa, palun saada ta mu isa majja. ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Sest mul on viis venda ja ta võib neid hoiatada, et nemadki ei lõpetaks siin piinapaigas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kuid Aabraham vastas: „Neil on Mooses ja prohvetid. Nad peaksid neid kuulama.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","„Ei, isa Aabraham,“ ütles mees. „Aga nad parandaksid meelt, kui nende juurde läheks keegi surnutest!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aabraham ütles talle: „Kui nad ei kuula Moosest ja prohveteid, ei veena neid ka see, kui keegi surnuist tagasi tuleks.““ ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jeesus ütles oma jüngritele: „Kiusatused on möödapääsmatud, aga häda neile, kelle läbi need tulevad! ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Sellistel inimestel oleks parem, kui neil oleks veskikivi ümber kaela ja nad heidetaks merre, kui et nad ässitaksid neid väikesi patustama. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nii et olge hoolsad selles, mida te teete. Kui su vend patustab, siis hoiata teda; ja kui ta kahetseb, andesta talle. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Isegi kui ta patustab sinu vastu seitse korda päevas ning tuleb seitse korda tagasi ja ütleb sulle: „Anna andeks!“, siis andesta talle.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apostlid ütlesid Issandale: „Aita, et meil oleks suurem usk!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Issand vastas: „Kui teie usk oleks kas või nii pisike kui sinepiseeme, võiksite öelda sellele mooruspuule: „Juuri end välja ja istuta end merre!“ ja puu kuuletuks teile. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Oletame, et sul on sulane, kes künnab või on karjas. Kui ta tuleb töölt, kas sa ütled talle: „Tule sisse ja istu siia sööma“? ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ei. Sa ütled talle: „Valmista mulle toit, pane end riidesse ja teeninda mind, kuni olen söömise lõpetanud. Pärast seda võid ise süüa.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ja kas sa tänad sulast selle eest, et ta teeb seda, mida käskisid tal teha? Ei. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Samamoodi on siis, kui olete teinud kõik, mida teil kästi, peaksite lihtsalt ütlema: „Me oleme vääritud sulased. Me täitsime üksnes oma kohust.““ ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Kui Jeesus jätkas teekonda Jeruusalemma, läks ta piki Samaaria ja Galilea piiri. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kui ta sisenes ühte külla, tulid talle vastu kümme pidalitõbist ja seisid eemal. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Nad hüüdsid: „Jeesus, Õpetaja, palun halasta meie peale!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kui Jeesus neid nägi, ütles ta neile: „Minge ja näidake end preestritele.“ Teel sinna said nad terveks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Üks neist nägi, et ta oli terveks saanud, ning ta tuli Jumalat ülistades Jeesuse juurde tagasi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ta langes Jeesuse jalge ette, et teda tänada. Ta oli samaarlane. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","„Kas mitte kümme pidalitõbist ei saanud terveks?“ küsis Jeesus. „Kus on ülejäänud üheksa? ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kas keegi teine peale selle võõramaalase ei tulnud tagasi Jumalat ülistama?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jeesus ütles mehele: „Tõuse püsti ja mine oma teed. Su usk on su terveks teinud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Kord kui variserid tulid ja küsisid, millal tuleb Jumala riik, vastas Jeesus: „Jumala riik ei tule nähtavate märkidega, et saaksite seda jälgida. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ei saa öelda: „Vaata, see on siin!“ või „Vaata, see on seal!“, sest Jumala riik on teie seas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Siis Jeesus rääkis jüngritele: „Tuleb aeg, mil igatsete näha päeva, mil inimese Poeg tuleb, kuid te ei näe seda. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Teile öeldakse: „Vaata, ta on seal!“ või „Vaata, ta on siin!“, aga ärge jookske nende järel. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Päev, mil inimese Poeg tuleb, on justkui välk, mis sähvatab ja lööb taeva valgeks ühest äärest teiseni. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Aga kõigepealt peab ta palju kannatama ning see põlvkond hülgab ta. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Inimese Poja tulemise aeg on samasugune, nagu oli Noa aeg. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Inimesed muudkui sõid ja jõid, võtsid naisi ja läksid mehele kuni selle päevani, mil Noa läks laeva. Siis tuli uputus ja hävitas nad kõik. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","See on samamoodi, nagu oli Loti ajal. Inimesed muudkui sõid ja jõid, ostsid ja müüsid, istutasid ja ehitasid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Aga sel päeval, kui Lott Soodomast lahkus, sadas taevast alla tuld ja väävlit ning hävitas nad kõik. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Päeval, mil inimese Poeg ilmub, on olukord just selline. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kui olete sel päeval katusel, ärge minge alla oma asju võtma; ja kui olete põllul, ärge samuti koju tagasi minge. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ärge unustage Loti naist! ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kui üritate oma elust kinni hoida, siis kaotate selle; aga kui kaotate elu, siis päästate selle. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ma ütlen teile, sel ajal on kaks öösel voodis – üks võetakse ja teine jäetakse. ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kaks naist jahvatavad vilja − üks võetakse ja teine jäetakse.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","„Kus, Issand?“ küsisid nad. „Kus on korjus, sinna kogunevad raisakotkad,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jeesus rääkis neile selle loo, et julgustada neid palvetama igal ajal, et nad meelt ei heidaks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","„Elas kord ühes linnas kohtunik, kes ei austanud Jumalat ega hoolinud inimestest,“ selgitas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","„Samas linnas elas lesknaine, kes käis ikka ja jälle kohtuniku juures, öeldes: „Mõista mulle õigust juhtumis mu vastase vastu!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mõnda aega ei tahtnud kohtunik selles suhtes midagi ette võtta, aga viimaks ütles ta endamisi: „Kuigi ma ei austa Jumalat ega hooli inimestest, ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","on see lesknaine nii tüütu, et ma hoolitsen selle eest, et õiglus seatakse jalule. Siis ei tüüta ta mind enam ega käi nii sageli mu juures.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kuulake, mida otsustas üks ebaõiglane kohtunik,“ ütles Issand. ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","„Kas te ei arva, et Jumal hoolitseb, et tema valitud rahva osaks saaks õiglus, nende osaks, kes hüüavad tema poole päeval ja ööl? Kas ta laseks neil teie arvates oodata? ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ei, ma ütlen teile, ta mõistaks neile õigust kiiresti. Aga kui inimese Poeg tuleb, kas ta leiab maa pealt inimesi, kes temasse usuvad?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ta rääkis ka loo neist, kes on väga kindlad, et elavad õigesti, ning kes halvustavad teisi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","„Kaks meest läks templisse palvetama. Üks oli variser ja teine maksukoguja. ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Variser seisis sirgelt ja palvetas endamisi: „Jumal, ma tänan, et ma ei ole niisugune nagu teised inimesed − petised, kurjategijad, abielurikkujad või kas või samasugune nagu see maksukoguja. ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ma paastun kaks korda nädalas ja maksan oma sissetulekust kümnist.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Aga maksukoguja seisis eemal. Ta ei vaadanud isegi taeva poole. Selle asemel lõi ta endale vastu rindu ja palvetas: „Jumal, palun ole mulle armuline. Ma olen patune.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ma ütlen teile, et see mees läks koju Jumala silmis õigena, mitte see teine. Sest kes ennast ise ülendab, seda alandatakse, samas aga neid, kes end alandavad, ülendatakse.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Vanemad tõid oma väikesi lapsi Jeesuse juurde, et ta neid oma puudutusega õnnistaks. Kui jüngrid toimuvat nägid, üritasid nad neid takistada. ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kuid Jeesus kutsus lapsed enda juurde. „Laske väikestel lastel minu juurde tulla,“ ütles ta. „Ärge takistage neid, sest Jumala riik kuulub neile, kes on nagu nemad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ma räägin teile tõtt: mitte keegi, kes ei võta Jumala riiki vastu nagu väike laps, ei saa sinna sisse.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Üks ülematest tuli Jeesuse juurde ja küsis talt: „Hea Õpetaja, mida ma pean tegema, et pärida igavene elu?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","„Miks sa mind heaks nimetad?“ vastas Jeesus. „Keegi ei ole hea peale Jumala. ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Sa tead käske: ära riku abielu, ära tapa, ära varasta, ära anna valetunnistust, austa oma isa ja ema.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","„Ma olen lapsest saadik kõiki neid käske pidanud,“ vastas mees. ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kui Jeesus seda kuulis, ütles ta mehele: „Sul on puudu veel üks asi. Mine ja müü ära kõik, mis sul on, anna raha vaestele ja sul on varandus taevas. Siis tule ja järgi mind!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Aga kui mees seda kuulis, jäi ta väga kurvaks, sest ta oli väga jõukas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kui Jeesus nägi tema reaktsiooni, ütles ta: „Kui raske on rikastel minna Jumala riiki! ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Lihtsam on kaamelil nõelasilmast läbi minna kui rikkal Jumala riiki siseneda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Need, kes kuulsid seda, imestasid: „Kes võib siis päästetud saada?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jeesus vastas: „Mis on inimlikus mõttes võimatu, on Jumala jaoks võimalik.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peetrus ütles: „Me jätsime kõik maha, et sulle järgneda!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","„Ma räägin teile tõtt,“ ütles Jeesus neile, „igaüks, kes jätab Jumala riigi pärast maha oma kodu, naise, vennad, vanemad või lapsed, ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","saab palju tagasi selles elus ja igavese elu tulevases maailmas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jeesus viis kaksteist jüngrit kõrvale ja ütles neile: „Me lähme Jeruusalemma ja kõik see, mida prohvetid inimese Poja kohta kirjutasid, läheb täide. ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ta antakse võõramaalaste kätte, teda mõnitatakse ja solvatakse ning tema peale sülitatakse. ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nad piitsutavad teda ja tapavad ta, kuid kolmandal päeval tõuseb ta surnuist üles.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kuid nad ei saanud aru millestki, mida Jeesus neile rääkis. Tähendus oli nende eest varjatud ja nad ei mõistnud, millest ta rääkis. ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kui Jeesus lähenes Jeerikole, istus tee ääres kerjates üks pime mees. ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ta kuulis rahvast mööda minemas, seepärast küsis ta, mis toimub. ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Talle öeldi: „Naatsareti Jeesus läheb mööda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mees hüüdis: „Jeesus, Taaveti poeg, halasta mu peale!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Need, kes olid rahvahulga ees, käskisid tal karjumise lõpetada ja vait jääda, kuid tema karjus üksnes valjemini: „Taaveti Poeg, halasta mu peale!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jeesus peatus ja käskis pimeda mehe enda juurde tuua. Kui mees tuli, küsis Jeesus talt: ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","„Mida sa tahad, et ma sinu heaks teeksin?“ „Issand, ma tahan jälle näha,“ anus ta. ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","„Siis näe!“ ütles Jeesus talle. „Sinu usk minusse on su terveks teinud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Silmapilkselt suutis mees näha. Ta järgnes Jeesusele ja ülistas Jumalat. Kõik sealviibijad, kes toimunut nägid, ülistasid samuti Jumalat. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jeesus sisenes Jeerikosse ja kõndis läbi linna. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Seal oli üks mees nimega Sakkeus, maksukogujate ülem. Ta oli väga rikas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ta tahtis näha, kes Jeesus on, aga kuna ta oli lühike, ei näinud ta rahvast üle. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Niisiis jooksis ta ette ja ronis ühe viigipuu otsa, et näha Jeesust, kui ta mööda läheb. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kui Jeesus sinna jõudis, vaatas ta üles ja ütles: „Sakkeus, tule kiiresti alla! Mul on vaja täna sinu majja jääda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakkeus ronis kiiresti alla ja oli väga õnnelik, et sai Jeesuse oma kodus vastu võtta. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kui rahvas seda nägi, siis nad kõik kurtsid: „Ta läks sellise patuse juurde!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Aga Sakkeus tõusis püsti ja ütles Issanda ees: „Vaata, ma annan pool oma varast vaestele ja kui olen kedagi petnud, maksan selle neljakordselt tagasi!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Selle peale ütles Jeesus: „Täna on sellele majale pääste tulnud, sest see mees on näidanud, et ka tema on Aabrahami poeg. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Sest inimese Poeg tuli otsima ja päästma neid, kes on kadunud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kui nad veel tähelepanelikud olid, jutustas Jeesus neile ühe loo, sest nad olid Jeruusalemma lähedal ja rahvas arvas, et Jumala riigist saab üsna kohe reaalsus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","„Elas kord üks aadlik, kes lahkus kodust ja läks kaugele maale, et seal kuningaks kroonitud saada ja siis tagasi tulla. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ta kutsus oma sulastest kümme, jagas nende vahel võrdselt raha ja ütles neile: „Investeerige see raha minu tagasitulekuni.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kuid tema omad vihkasid teda ja saatsid delegatsiooni talle järele, et öelda: „Me ei taha, et see mees saaks meie üle kuningaks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pärast seda kui ta oli kuningaks kroonitud, tuli ta tagasi. Ta käskis oma sulased enda juurde tuua. Ta tahtis teada, mis kasu nad olid saanud tema antud raha investeerimisest. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Esimene sulane tuli sisse ja ütles: „Isand, sinu raha teenis kümme korda nii palju juurde.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","„Tubli! Sa oled hea sulane,“ ütles kuningas. „Kuna sa oled tõestanud, et oled väga väheses usaldusväärne, annan ma sinu alluvusse kümme linna.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Teine sulane tuli sisse ja ütles: „Isand, sinu raha teenis viis korda nii palju juurde.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","„Ma annan sinu alluvusse viis linna,“ ütles kuningas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Veel üks sulane tuli sisse ja ütles: „Isand, vaata, siin on su raha, saad selle tagasi. Hoidsin seda kindlas kohas, riide sisse mässitult. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ma kartsin sind, sest sa oled karm mees. Sa võtad seda, mis ei kuulu sulle, ja lõikad sealt, kuhu sa ei ole külvanud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","„Ma mõistan su üle kohut su enda sõnade järgi,“ vastas kuningas. „Sa tead, et ma olen karm mees, sinu sõnul võtan ma seda, mis ei kuulu mulle, ja lõikan sealt, kuhu ma ei ole külvanud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Miks sa siis ei hoiustanud mu raha pangas, et oleksin tagasi tulles saanud oma raha intressiga kätte?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kuningas ütles neile, kes tema juures seisid: „Võtke raha temalt ära ja andke sellele, kes oli raha kümnekordistanud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","„Aga, isand, tal on juba kümme korda rohkem,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kuningas ütles: „Ma ütlen teile, et neile, kellel on, antakse juurde, aga neilt, kellel ei ole, võetakse ära seegi, mis neil on. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ja mis puutub mu vaenlastesse, kes ei tahtnud, et ma nende üle kuningas oleksin: tooge nad siia ja surmake minu silma all.““ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pärast seda kui Jeesus oli selle loo jutustamise lõpetanud, suundus ta Jeruusalemma poole ja kõndis edasi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kui ta jõudis Õlimäele Betfage ja Betaania lähedal, saatis ta kaks jüngrit külla ja ütles neile: ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","„Minge kaugemal asuvasse külla. Kui sinna jõuate, siis leiate kinniseotult sälu, kellega ei ole veel keegi ratsutanud. Päästke ta lahti ja tooge siia. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kui keegi teilt küsib: „Miks te sälu lahti päästate?“, siis öelge lihtsalt: „Issandal on teda vaja.““ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nõnda siis kaks jüngrit läksid ja leidsid, et kõik oli täpselt nii, nagu Jeesus oli öelnud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kui nad sälgu lahti päästsid, küsisid tema omanikud neilt: „Miks te sälu lahti päästate?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Jüngrid vastasid: „Issandal on teda vaja.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nad tõid sälu Jeesusele. Siis heitsid nad oma kuued sälu peale ja Jeesus istus talle selga. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kui ta edasi ratsutas, laotasid inimesed oma rõivaid tee peale. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kui ta Jeruusalemmale lähenes, siis just seal, kus tee hakkab Õlimäelt laskuma, hakkas kogu jüngrite hulk täiesti kõrist hüüdma rõõmsat ülistust Jumalale kõigi nende imede eest, mida nad olid näinud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","„Õnnistatud on kuningas, kes tuleb Issanda nimel,“ hüüdsid nad. „Rahu taevas ja hiilgus kõrgeimas taevas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mõned variseridest, kes olid rahva hulgas, ütlesid Jeesusele: „Õpetaja, ära luba oma jüngritel nii öelda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Aga Jeesus vastas: „Ma ütlen teile, et kui nemad oleksid vait, hakkaksid kivid kisendama!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Aga kui ta lähemale jõudis, nägi ta linna ja nuttis linna pärast. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","„Ma tõesti soovin täna, et sina, isegi sina, oleksid tundnud teed, mis viib rahusse!“ ütles ta. „Aga nüüd on see sinu pilgu ees varjatud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tuleb aeg, mil su vaenlased piiravad sind, ehitavad sinu ründamiseks rampe ja ümbritsevad sind igast küljest. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nad teevad su maatasa, sinu ja su lapsed koos sinuga. Nad ei jäta sinus kivi kivi peale, sest sa keeldusid vastu võtmast päästet, kui see sinu juurde tuli.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jeesus sisenes templisse ja hakkas välja ajama kõik inimesi, kes seal kaubitsesid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ta ütles neile: „Pühakirjas on öeldud, et „mu koda on palvekoda,“ aga teie olete selle muutnud röövlikoopaks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ta õpetas templis iga päev. Ülempreestrid, vaimulikud õpetajad ja rahvajuhid üritasid teda tappa. ");
INSERT INTO ekkpkp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Aga nad ei suutnud leida võimalust selle tegemiseks, sest kõik pidasid temast lugu ja kuulasid iga tema sõna. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kord kui Jeesus õpetas rahvast templis ja rääkis neile head sõnumit, tulid mõned ülempreestrid ja vaimulikud õpetajad koos vanematega. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nad küsisid talt: „Ütle meile, kelle volitusel teed sa seda, mida teed? Kes andis sulle õiguse seda teha?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","„Lubage, ma esitan ka teile küsimuse,“ vastas Jeesus. „Öelge mulle: ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","kas Johannese ristimine oli taevast või üksnes inimesest?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nad arutlesid seda isekeskis: „Kui me ütleme, et see oli taevast, küsib ta: „Miks te siis ei uskunud teda?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Aga kui me ütleme, et see oli üksnes inimesest, viskavad kõik meid kividega, sest nad on kindlad, et Johannes oli prohvet.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nii nad siis vastasid: „Me ei tea, millest see oli.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jeesus vastas: „Siis ei ütle ma teile, kelle volitusel teen ma seda, mida teen.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Siis hakkas ta rahvale üht lugu jutustama. „Elas kord üks mees, kes istutas viinapuuaia, rentis selle mõnedele põllumeestele ja läks kauaks ajaks teise riiki elama. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Lõikuse ajal saatis ta sulase rentnike juurde, et oma osa saagist koguda, kuid põllumehed peksid sulast ja saatsid ta tühje käsi minema. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Niisiis saatis omanik järgmise sulase, kuid ka teda nad peksid ja häbistasid ning saatsid tühje käsi minema. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Seega saatis ta kolmanda sulase, kuid nad vigastasid teda ja viskasid ta välja. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Viinapuuistanduse omanik küsis endalt: „Mida ma peaksin tegema? Ma tean! Ma saadan oma poja, keda ma armastan. Ehk austavad nad teda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Aga kui põllupidajad nägid teda tulemas, ütlesid nad üksteisele: „See on omaniku pärija. Tapame ta ära! Nii saame tema päranduse endale.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nad heitsid ta viinapuuaiast välja ja tapsid ta. Mida teeb nüüd viinapuuistanduse omanik nendega? ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ta tuleb ja surmab need põllupidajad ning annab viinapuuaia teiste kätte.“ Kui nad seda lugu kuulsid, ütlesid nad: „Et seda kunagi ei juhtuks!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Aga Jeesus vaatas neile otsa ja ütles: „Miks on siis Pühakirjas kirjutatud: „Kivi, mille ehitajad kõrvale heitsid, on nüüd saanud peamiseks nurgakiviks“? ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Igaüks, kes sellele kivile langeb, puruneb tükkideks; igaüks, kelle peale see kivi kukub, purustatakse.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Otsekohe tahtsid vaimulikud õpetajad ja ülempreestrid ta vahistada, sest nad mõistsid, et lugu, mille Jeesus rääkis, oli adresseeritud neile, kuid nad kartsid, mida rahvas võiks teha. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Võimalust otsides saatsid nad nuhid, kes teesklesid, et on siirad. Nad üritasid püüda Jeesust lõksu millegagi, mida ta ütleb, nii et nad saaksid ta anda maavalitseja võimu ja volituste alla. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nad ütlesid: „Õpetaja, me teame, et sina räägid ja õpetad seda, mis on hea ja õige, ning et sa ei lase end teiste arvamusest kõigutada. Sa õpetad tõesti Jumala teed. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kas me siis peaksime keisrile makse maksma või mitte?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Aga Jeesus nägi nende kavala võtte läbi ja ütles neile: ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","„Näidake mulle münti − üht denaari. Kelle pilt ja kiri selle peal on?“ „Keisri,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","„Siis andke keisrile tagasi see, mis kuulub keisrile, ja Jumalale see, mis kuulub Jumalale,“ ütles ta neile. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nad ei suutnud teda lõksu püüda sellega, mida ta rahvale rääkis. Nad olid tema vastusest jahmunud ning jäid vait. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Seejärel tulid Jeesuse juurde saduserid, kes eitavad ülestõusmist, ja esitasid küsimuse: ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","„Õpetaja,“ alustasid nad, „Mooses andis meile seaduse, et kui abielumees surres jätab naise lasteta, siis peab mehe vend abielluma lesega ja saama oma surnud venna jaoks lapsi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Elasid kord seitse venda. Esimene vend võttis naise ja suri lapsi saamata. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Teine vend ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ja siis ka kolmas vend abiellusid temaga. Lõpuks olid kõik seitse venda temaga abiellunud ja siis lapsi saamata surnud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Viimaks suri ka naine. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kelle naiseks ta siis nüüd ülestõusmisel saab, sest kõik seitse venda on temaga abielus olnud?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","„Siin, praegusel ajastul, võtavad inimesed naisi ja lähevad mehele,“ selgitas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","„Aga need, keda arvatakse olema väärt osa saama tulevasest ajastust ja surnute ülestõusmisest, ei võta naisi ega lähe mehele. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nad ei saa enam surra, nad on nagu inglid ja Jumala lapsed, kuna nad on ülestõusmise lapsed. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Aga küsimuse kohta, kas surnud üles tõusevad, on isegi Mooses tõestuse andnud, kui ta kirjutas põlevast põõsast, nimetades Issandat „Aabrahami Jumalaks, Iisaki Jumalaks ja Jaakobi Jumalaks“. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ta ei ole surnute Jumal, vaid elavate Jumal, sest tema jaoks on kõik elus.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mõned vaimulikud õpetajad vastasid: „See oli hea vastus, Õpetaja.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pärast seda ei söandanud enam keegi temale rohkem küsimusi esitada. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Siis küsis Jeesus neilt: „Miks on öeldud, et Kristus on Taaveti poeg? ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Sest Taavet ise ütleb Psalmide raamatus: Issand ütles mu Issandale: „Istu mu paremale käele, ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kuni ma panen kõik su vaenlased su jalgealuseks järiks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Taavet ütleb talle „Issand“, nii et kuidas ta saab siis olla Taaveti poeg?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kui kõik tähelepanelikud olid, ütles ta oma jüngritele: ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","„Hoiduge vaimulike õpetajate eest, kes käivad ringi pikkades rüüdes, kellele meeldib, kui neid turgudel lugupidamisega tervitatakse ning kui neil on parimad kohad sünagoogides ja aukohad pidusöökidel. ");
INSERT INTO ekkpkp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nad petavad lesknaistelt välja nende omandi ja varjavad oma tegelikku olemust paljusõnaliste palvetega. Nad saavad kohtupäeval karmi hukkamõistu osaliseks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ringi vaadates jälgis Jeesus, kuidas jõukad inimesed panid oma annetusi kogumiskasti. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ta nägi ka, kuidas üks väga vaene lesknaine pani sinna kaks pisikest münti. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","„Ma räägin teile tõtt,“ ütles ta, „see vaene lesknaine pani kasti rohkem kui kõik ülejäänud kokku. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kõik nad andsid oma jõukusest, mis neil oli, kuid tema andis oma vaesusest kõik, millest ta pidi elama.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mõned neist seal rääkisid templist, selle peenelt tahutud kividest ja suurepärastest annetustest, mida nad andnud olid. Aga Jeesus ütles: ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","„Nende asjade kohta, mida te silmas peate: tuleb aeg, mil ei jäeta üht kivi teise peale, kõik hävitatakse!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","„Õpetaja, millal see toimub?“ küsisid nad talt. „Missugune on märk, et need asjad hakkavad toimuma?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","„Veenduge, et teid ei petetaks,“ hoiatas Jeesus neid. „Paljud tulevad ja väidavad, et nad on mina, öeldes: „Siin ma olen!“ ja „Aeg on käes!“, aga ärge neid järgige. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kui te kuulete sõdadest ja revolutsioonidest, ärge ehmuge, sest kõigepealt peavad need asjad toimuma, kuid lõpp ei tule kohe. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Rahvas sõdib rahvaga ja kuningriik kuningriigiga,“ ütles ta neile. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","„Paljudes maades on ränki maavärinaid, näljahädasid ja haiguste epideemiaid ning erakordseid märke taevas, mis kohutavad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Aga enne kõike seda võtavad nad teid kinni ja kiusavad taga. Nad veavad teid sünagoogide ette ja heidavad vanglasse, nad viivad teid minu pärast kohtusse kuningate ja maavalitsejate ette. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Aga see annab teile võimaluse kõneleda nende ees minust. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Niisiis, otsustage juba ette, et te ei muretse sellepärast, kuidas end kaitsta, ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","sest mina annan teile tarkusesõnad, mida teie vaenlased ei suuda vaidlustada ega ümber lükata. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Teid reedavad isegi teie vanemad, vennad ja sõbrad ning nad tapavad teist mõned. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kõik vihkavad teid minu pärast. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Aga teie peast ei lähe kaotsi ainsatki juuksekarva. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kindlalt seistes võidate oma elu. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Aga kui te näete, et sõjaväed piiravad Jeruusalemma ümber, siis teate, et selle hävitus on lähedal. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kes on Juudamaal, peaksid põgenema mägedesse, ja kes on Jeruusalemmas, peaksid lahkuma, ning need, kes on maal, ei tohiks linna minna. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sest need on karistuse päevad, mis täidavad kõik, mida on kirjutatud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kui raske on neil, kes on sel ajal lapseootel või imetavad! Sest kohutav kitsikus on tulemas maa peale ja karistus selle elanikele. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kõik rahvad tapavad neid mõõgaga ja viivad neid vangi. Võõrad rahvad tallavad Jeruusalemma maha, kuni nende aeg täis saab. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Päikeses, kuus ja tähtedes on märke ning rahvad maa peal on ahastuses ja segaduses mere lainetuse ja pealetungimise tõttu. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Inimesed on hirmust nõrgad ning kohkunud sellest, mis maailmas toimub, sest taeva vägesid kõigutatakse. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Siis näevad nad inimese Poega tulemas pilves väe ja suure hiilgusega. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Aga kui see kõik juhtub, siis tõuske ja vaadake üles, sest varsti olete te päästetud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Siis jutustas ta neile näitlikustamiseks selle loo. „Vaadake viigipuud või mõnda muud puud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kui te näete uusi lehti ilmumas, siis pole vaja teile öelda, et suvi on lähedal. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Samamoodi siis, kui te näete neid asju toimumas, ei ole teile vaja öelda, et Jumala riik on lähedal. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ma räägin teile tõtt: see põlvkond ei lõpe enne, kui see kõik toimub. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Taevas ja maa kaovad, aga minu sõnad ei kao. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Olge ettevaatlikud, et pidutsemine või purjutamine või selle elu mured teie tähelepanu kõrvale ei juhiks, nii et see päev tabaks teid üllatusena. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sest see päev tabab kõiki, kes elavad maa peal. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Olge alati valvel ja palvetage, et te oleksite võimelised pääsema kõigest, mis toimub, ja seisma inimese Poja ees.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Iga päev õpetas Jeesus templis ja igal õhtul läks ta ning jäi Õlimäele. ");
INSERT INTO ekkpkp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kogu rahvas tuli hommikul vara teda templisse kuulama. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nüüd oli lähenemas hapnemata leibade püha, mida nimetati ka paasapühaks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ülempreestrid ja vaimulikud õpetajad otsisid võimalust Jeesuse tapmiseks, aga nad kartsid, mida teeks siis rahvas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Saatan läks Juuda sisse, kelle liignimi oli Iskariot ja kes oli üks kaheteistkümnest jüngrist. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ta läks ja arutles ülempreestrite ja valvuritega, kuidas ta saaks Jeesuse ära anda. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Neil oli hea meel ja nad pakkusid talle raha. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ta oli nõus, ning hakkas otsima võimalust, et anda Jeesus nende kätte siis, kui rahvast ei ole ligi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hapnemata leibade päev saabus siis, kui tuli ohverdada paasatall. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jeesus saatis Peetruse ja Johannese ning ütles neile: „Minge ja valmistage paasapüha söömaaeg, nii et me saaksime seda koos süüa.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nad küsisid talt: „Kus sa tahad, et me selle sulle valmistaksime?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ta vastas: „Kui te jõuate linna, kohtate üht veekannu kandvat meest. Minge talle järele ja astuge majja, kuhu ta sisse läheb. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Öelge majaomanikule, et Õpetaja küsib talt: „Kus on söögituba, kus ma saaksin koos oma jüngritega paasapüha söömaaega süüa?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ta näitab teile suurt ülemise korruse tuba, kus on vajalik sisustus juba olemas. Valmistage söömaaeg seal.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nad läksid ja leidsid, et kõik oli täpselt nii, nagu ta neile öelnud oli, ning nad valmistasid seal paasapüha söömaaja. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kui jõudis kätte aeg, istus ta lauda koos oma apostlitega. Ta ütles neile: ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","„Ma olen tõesti oodanud, et saaksin koos teiega seda paasapüha söömaaega süüa, enne kui mu kannatused algavad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ma ütlen teile, ma ei söö seda enam uuesti, kuni aeg saab täis Jumala riigis.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jeesus võttis karika, ja kui ta oli tänanud, ütles ta: „Võtke see ja jagage omavahel. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ma ütlen teile, et ma ei joo viinapuu viljast enam enne, kui Jumala riik tuleb.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ta võttis veidi leiba, ja kui ta oli tänanud, murdis selle tükkideks ja andis neile. „See on minu ihu, mis on antud teie eest; tehke seda, et mind meeles pidada,“ ütles Jeesus neile. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Samamoodi võttis ta pärast õhtusöögi lõpetamist karika ja ütles: „See karikas on uus leping minu veres, mis on teie eest välja valatud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","„Hoolimata sellest istub mu äraandja siinsamas lauas minuga koos. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Sest on määratud, et inimese Poeg sureb, aga kui hukatuslik on see tema äraandja jaoks!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nad hakkasid isekeskis arutlema, et kes see võiks olla ja kes suudaks seda teha. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Samal ajal hakkasid nad ka vaidlema, kes neist on kõige tähtsam. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jeesus rääkis neile: „Võõramaa kuningad valitsevad oma alamate üle ja need, kellel on võim, tahavad, et inimesed nimetaksid neid heategijaks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Aga teiega ei tohiks nii olla! Kes iganes on teie hulgas kõrgeim, see peaks olema madalaim, ja juht peaks olema nagu teenija. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kes on suurem: kas see, kes istub lauas, või see, kes teenib? Kas mitte see, kes istub lauas? Aga mina olen teie keskel nagu see, kes teenib. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Te olete jäänud minuga mu katsumuste keskel. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ja just nagu minu Isa andis mulle õiguse valitseda, annan ma ka teile selle õiguse, ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","nii et te võiksite süüa ja juua mu kuningriigis minu lauas ning istuda troonil ja mõista kohut Iisraeli kaheteistkümne suguharu üle.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","„Siimon, Siimon, Saatan on tahtnud lasta teid kõiki sõeluda nagu nisu, ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","aga ma olen sinu eest palunud, et su usk minusse ei lõpeks. Ja kui sa pöördud, siis julgusta oma vendi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peetrus ütles: „Issand, ma olen valmis minema sinuga koos vanglasse ja surma!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jeesus vastas: „Ma ütlen sulle, Peetrus, enne kui kukk täna kireb, salgad sa kolm korda, et sa mind üldse tunned.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jeesus küsis neilt: „Kui ma läkitasin teid välja ilma raha, koti ja varusandaalideta, kas teil oli siis millestki puudus?“ „Ei, mitte millestki,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","„Aga nüüd, kui teil on raha, peaksite selle võtma, samuti koti, ja kui teil ei ole mõõka, müüge kuub ära ja ostke mõõk. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ma ütlen teile, et see väide minu kohta Pühakirjas peab täide minema: „Ta arvati patuste hulka.“ Nüüd läheb täide see, mida on minu kohta öeldud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","„Vaata, Issand, siin on kaks mõõka,“ ütlesid nad. „Sellest piisab,“ vastas ta. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jeesus lahkus ja läks nagu tavaliselt koos oma jüngritega Õlimäele. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kui nad kohale jõudsid, ütles ta neile: „Palvetage, et te kiusatusele järele ei annaks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Siis lahkus ta neist ja läks umbes kiviviske kaugusele, kus ta põlvitas maha ja palvetas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","„Isa,“ palvetas ta, „kui sa tahad, siis palun võta see kannatuste karikas minult ära. Aga ma tahan teha seda, mida tahad sina, mitte seda, mida tahan mina.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Siis ilmus taevast ingel, et talle jõudu anda. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Suures ängistuses palvetas Jeesus veel enam ning tema higi langes maapinnale nagu verepiiskadena. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ta lõpetas palvetamise, tõusis püsti ja läks jüngrite juurde. Ta leidis nad kurvastusest väsinuna magamas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","„Miks te magate?“ küsis ta neilt. „Tõuske üles ja palvetage, et te kiusatusse ei langeks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kui ta alles rääkis, ilmus välja rahvahulk, keda juhtis Juudas, üks kaheteistkümnest jüngrist. Juudas läks Jeesuse juurde, et teda suudelda. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Aga Jeesus küsis temalt: „Juudas, kas sa annad inimese Poja suudlusega ära?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jeesuse järelkäijad küsisid talt: „Issand, kas peaksime neid mõõkadega ründama?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ja üks neist lõi ülempreestri sulast, nii et lõikas tema parema kõrva küljest ära. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","„Lõpetage! Aitab sellest!“ ütles Jeesus. Ta puudutas mehe kõrva ja tegi ta terveks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Seejärel rääkis Jeesus ülempreestrite, templivalvurite ja vanematega. „Kas ma olen mingisugune kurjategija, et pidite tulema mõõkade ja nuiadega?“ küsis ta. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","„Te ei võtnud mind kinni varem, kui ma olin iga päev koos teiega templis. Aga see on praegu teie hetk, aeg, mil pimedus võimutseb.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nad võtsid ta kinni ja viisid ülempreestri majja. Peetrus järgnes eemalt. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nad tegid õue keskele tule ja istusid selle juurde. Peetrus oli seal nende hulgas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kui ta seal istus, märkas üks teenijatüdruk teda tule valgel, vaatas ainiti ja ütles: ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","„See mees oli temaga koos.“ Kuid Peetrus salgas seda. „Naine, ma ei tunne teda!“ ütles ta. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Veidi aega hiljem vaatas teda keegi teine ja ütles: „Sina oled ka üks neist.“ „Ei, ei ole!“ vastas Peetrus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Umbes tunni aja pärast väitis järgmine inimene: „Ma olen kindel, et ka tema oli koos temaga – ta on galilealane.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","„Mul pole aimugi, millest sa räägid!“ vastas Peetrus. Just siis, kui ta alles rääkis, kires kukk. Issand pöördus ja vaatas Peetrusele otsa. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ja Peetrusele tuli meelde, mida Issand oli öelnud, kuidas ta oli talle rääkinud: „Enne kui kukk täna kireb, salgad sa mind kolm korda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Peetrus läks välja ja nuttis kibedasti. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jeesust valvavad mehed hakkasid teda mõnitama ja peksma. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nad sidusid ta silmad kinni ja küsisid siis talt: „Kui sa oskad prohvetlikult kuulutada, siis ütle meile, kes sind seekord lõi!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ja nad karjusid talle palju teisi solvanguid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Hommikul vara kogunes vanemate nõukogu koos ülempreestrite ja vaimulike õpetajatega. Jeesus viidi nõukogu ette. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","„Kui sa tõesti oled Messias, siis ütle meile,“ ütlesid nad. „Isegi kui ma teile ütleksin, ei usuks te mind,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","„Ja kui ma esitaksin teile küsimuse, siis te ei vastaks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Aga nüüdsest peale istub inimese Poeg vägeva Jumala paremal käel.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nad kõik küsisid: „Nii et sa oled Jumala poeg?“ „Teie ütlete, et ma olen,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","„Miks on meil veel tunnistajaid vaja?“ ütlesid nad. „Oleme seda ise tema enda suust kuulnud!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kogu nõukogu tõusis ja viis ta Pilaatuse juurde. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Seal hakkasid nad teda süüdistama. „Me avastasime, et see mees petab meie rahvast. Ta ütleb inimestele, et nad ei maksaks keisrile makse, ja ta väidab, et ta on Messias, kuningas,“ ütlesid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","„Kas sa oled juutide kuningas?“ küsis Pilaatus talt. „Nii ütled sina,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Siis ütles Pilaatus ülempreestritele ja rahvale: „Ma ei leia, et see mees oleks üheski kuriteos süüdi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Aga nad jäid endale kindlaks ja ütlesid: „Ta õhutab oma õpetustega mässu kogu Juudamaal, Galileast kuni siia, Jeruusalemmani.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kui Pilaatus seda kuulis, küsis ta: „Kas see mees on galilealane?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kui ta avastas, et Jeesus on pärit Heroodese kohtupiirkonnast, saatis ta tema Heroodese juurde, kes oli ka sel ajal Jeruusalemmas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heroodesel oli väga hea meel Jeesust nähes, sest ta oli tahtnud juba ammu temaga kokku saada. Ta oli Jeesusest kuulnud ja lootis näha, kuidas ta imet teeb. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ta esitas Jeesusele palju küsimusi, kuid Jeesus ei vastanud talle üldse. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ülempreestrid ja vaimulikud õpetajad seisid sealsamas ja süüdistasid teda vihaselt. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heroodes ja tema sõdurid kohtlesid Jeesust põlgusega ja mõnitasid teda. Siis asetasid nad talle õlgadele kuningliku rüü ja saatsid Pilaatuse juurde tagasi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Sellest päevast peale olid Heroodes ja Pilaatus sõbrad; enne seda olid nad vaenlased olnud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilaatus kutsus kokku ülempreestrid, ülemad ja rahva ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ning ütles neile: „Te tõite minu ette selle mehe ja süüdistasite teda rahva mässule õhutamises. Uurisin teda hoolikalt teie juuresolekul ega leidnud teda süüdi olevat selles, milles te teda süüdistasite. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Seda ei leidnud ka Heroodes, sest ta saatis ta meie juurde tagasi. Ta ei ole teinud midagi, mis nõuaks surmamõistmist. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nii et ma lasen teda piitsutada ja siis vabastan ta.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Aga nad kõik karjusid koos: „Tapa see mees ja lase meile Barabas vabaks!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas oli pandud vangi linnas mässus osalemise ja mõrva eest.) ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilaatus tahtis Jeesust vabaks lasta, seega rääkis ta nendega uuesti. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Aga nemad muudkui karjusid: „Löö ta risti! Löö ta risti!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilaatus küsis neilt kolmandat korda: „Aga miks? Mis kuriteo on ta teinud? Ma ei leia mingit põhjust, et teda hukata. Nii et ma lasen teda piitsutada ja siis vabastan ta.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kuid nad jätkasid valjult karjudes nõudmist, et ta tuleb risti lüüa. Nende karjumine saavutas edu ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ja Pilaatus andis nõutud kohtuotsuse välja. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ta vabastas mässu ja mõrva eest vangistatud mehe, kuid vastavalt rahva nõudmisele saatis ta Jeesuse hukkamisele. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kui sõdurid ta minema viisid, pidasid nad kinni Küreenest pärit mehe nimega Siimon, kes oli tulnud maalt linna. Nad panid risti talle selga ja sundisid seda Jeesuse taga kandma. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Suur rahvahulk järgnes talle koos naistega, kes leinasid ja halasid tema pärast. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jeesus pöördus nende poole ja ütles: „Jeruusalemma tütred, ärge nutke minu pärast. Nutke iseenda ja oma laste pärast. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sest tuleb aeg, mil öeldakse: „Õnnelikud on need, kel pole lapsi, ja need, kel pole lapsi olnud, ja need, kes pole kunagi imetanud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Siis öeldakse mägedele: „Langege meie peale!“ ja küngastele: „Varjake meid!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Sest kui nii juhtub rohelise puuga, mis juhtub siis, kui puu on kuivanud?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nad võtsid kaasa ka kaks teist, kes olid kurjategijad, et need koos temaga hukata. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kui nad jõudsid paika, mida nimetatakse Koljuks, lõid nad ta risti koos kurjategijatega, üks neist temast paremal ja teine temast vasakul. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jeesus ütles: „Isa, anna neile andeks, sest nad ei tea, mida nad teevad.“ Nad jaotasid tema riideid, heites nende pärast täringut. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Rahvas seisis ja vaatas ning juhid irvitasid Jeesuse üle. „Teisi ta päästis, päästku nüüd ennast, kui ta tõesti on Jumala Messias, see Valitu,“ ütlesid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ka sõdurid pilkasid teda; nad tulid tema ligi, pakkusid talle veiniäädikat ja ütlesid: ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","„Kui sa oled juutide kuningas siis päästa ennast!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jeesuse kohal oli silt, kuhu oli kirjutatud: „See on juutide kuningas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Üks seal rippuvatest kurjategijatest ühines Jeesuse solvamisega. „Kas sa polegi Messias?“ küsis ta. „Siis päästa ennast ja ka meid!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kuid teine kurjategija ei olnud nõus ja vaidles temaga: „Kas sa ei karda Jumalat, kuigi sa kannad sama karistust?“ küsis ta. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","„Meie puhul on kohtuotsus õige, sest meid karistatakse selle eest, mida me tegime, aga see mees pole midagi valesti teinud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Siis ütles ta: „Jeesus, pea mind meeles, kui sa oma kuningriiki tuled.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jeesus vastas: „Ma luban sulle täna, et sa oled koos minuga paradiisis.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Selleks ajaks oli käes umbes keskpäev ja pimedus langes üle kogu maa kuni kella kolmeni pärastlõunal. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Päikesevalgus kustus ja templi eesriie kärises kaheks. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jeesus hüüdis valju häälega: „Isa, ma annan end sinu kätesse!“ Kui ta seda öelnud oli, tegi ta oma viimase hingetõmbe. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kui sadakonnaülem nägi, mis juhtus, ülistas ta Jumalat ja ütles: „See mees oli kindlasti süütu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kui kogu rahvas, kes oli tulnud vaatama, nägi, mis juhtus, läksid nad koju ja lõid kurvastuses vastu rindu. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Aga kõik need, kes tundsid Jeesust, kaasa arvatud naised, kes olid talle Galileast saadik järgnenud, jälgisid seda eemalt. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Oli üks mees nimega Joosep, kes oli hea ja aus. Ta oli nõukogu liige, ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","kuid ta ei olnud nende otsuste ja tegudega nõus olnud. Ta oli pärit Juuda linnast Arimaatiast ning ootas innukalt Jumala riiki. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Joosep läks Pilaatuse juurde ja küsis Jeesuse surnukeha. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kui ta oli selle alla võtnud, mässis ta selle linasesse riidesse. Ta asetas Jeesuse kasutamata hauda, mis oli kaljusse raiutud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Oli valmistuspäev ja hingamispäev oli peagi algamas. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Naised, kes olid tulnud koos Jeesusega Galileast, olid Joosepile järgnenud ning näinud hauda, kuhu Jeesuse surnukeha oli pandud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nad läksid koju tagasi ning valmistasid lõhnataimi ja salve. Aga hingamispäeval nad puhkasid käsu järgi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nädala esimese päeva hommikul vara läksid naised haua juurde, kaasas valmistatud lõhnaained. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nad leidsid, et kivi oli haua sissepääsu eest ära veeretatud, ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","aga kui nad sisse läksid, ei leidnud nad Issanda Jeesuse ihu. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kui nad seal imestasid, mis toimub, ilmus äkitselt kaks meest, kes olid riietatud eredalt hiilgavatesse rõivaetesse. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Naised kohkusid ja kummardusid näoli maha. Nad ütlesid naistele: „Miks te otsite elavat surnute juurest? ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ta ei ole siin, ta on surnuist üles tõusnud! Meenutage, mida ta teile rääkis, kui te olite alles Galileas: ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","„Inimese Poeg antakse kurjade inimeste kätte ja lüüakse risti, aga kolmandal päeval tõuseb ta surnuist üles.““ ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Siis meenus neile, mida ta oli öelnud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kui nad haua juurest tagasi tulid, rääkisid nad kõigest juhtunust üheteistkümnele jüngrile ja kõigile teistele. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Need, kes juhtunust apostlitele rääkisid, olid Maarja Magdaleena, Johanna, Jaakobuse ema Maarja ja teised nendega koos olnud naised. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kuid neile tundus see rumalusena, seega ei uskunud nad naisi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Aga Peetrus tõusis ja jooksis haua juurde. Ta kummardus ja vaatas sisse ning nägi ainult haualinu. Nii läks ta tagasi koju, ise imestades, mis küll oli juhtunud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Samal päeval oli kaks jüngrit teel külasse nimega Emmaus, mis asub Jeruusalemmast umbes seitsme miili kaugusel. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nad rääkisid kõigest, mis oli juhtunud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kui nad arutlesid ja vaidlesid, tuli Jeesus ja hakkas nendega koos kõndima. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Aga neil ei lastud teda ära tunda. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","„Mille üle te siin teed käies arutlete?“ küsis ta neilt. Nad peatusid kurva näoga. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Üks neist, keda hüüti Kleopaseks, vastas: „Kas sa oled Jeruusalemmas ainult külas? Sa oled ilmselt ainus inimene, kes ei tea viimastel päevadel juhtunust.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","„Millest siis?“ küsis Jeesus. „Naatsareti Jeesusest,“ vastasid nad. „Ta oli prohvet, kes rääkis mõjuvõimsalt ning tegi suuri imetegusid Jumala ja kogu rahva ees. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kuid meie ülempreestrid ja juhid andsid ta surmamõistmiseks ja lõid ta risti. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Me lootsime, et tema on see, kes päästab Iisraeli. Kõigest juhtunust on nüüd möödas kolm päeva. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Aga mõned naised meie grupist üllatasid meid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Nad läksid koidikul haua juurde ega leidnud tema surnukeha. Nad tulid tagasi ja ütlesid, et olid näinud nägemust inglitest, kes ütlesid neile, et ta elab. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mõned meist läksid haua juurde ja leidsid, et kõik oli täpselt nii, nagu naised ütlesid, kuid nad ei näinud teda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jeesus ütles neile: „Te olete nii töntsi arusaamisega! Kui pikaldased olete te uskuma kõike seda, mida prohvetid on öelnud! ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kas Messias ei pidanud kannatama enne, kui sai hiilgusesse minna?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Seejärel alustas ta Moosesest ja kõigist prohvetitest ning selgitas neile kõike, mida oli tema kohta Pühakirjas öeldud. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kui nad lähenesid külale, kuhu nad teel olid, tegi Jeesus, nagu läheks ta edasi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Aga nad käisid talle peale, öeldes: „Tule ja jää meie juurde. On juba hilja, päev on peaaegu õhtus.“ Nii läks ta siis nende juurde sisse. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kui ta istus koos nendega sööma, võttis ta leiva, tänas, murdis ja andis neile. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nende silmad avati ja nad tundsid ta ära. Siis kadus ta nende silmist. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kaks jüngrit ütlesid teineteisele: „Kui ta meile Pühakirja selgitas, kas see ei sütitanud siis meid?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nad tõusid kohe püsti ja läksid Jeruusalemma tagasi. Nad leidsid üksteist jüngrid ja need, kes olid nendega koos, ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ütlesid: „Issand on tõesti surnuist üles tõusnud! Ta ilmus Siimonale.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Siis need, kes olid just saabunud, jutustasid teistele jüngritele, mis oli nendega teed käies juhtunud ja kuidas nad olid Jeesuse ära tundnud, kui ta leiba murdis. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kui nad alles rääkisid, seisis Jeesus ise nende keskel ja ütles: „Rahu olgu teile!“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nad olid jahmunud ja ehmunud ning arvasid, et näevad kummitust. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","„Miks te olete kohkunud? Miks te kahtlete?“ küsis ta neilt. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","„Vaadake mu käsi ja jalgu – te näete, et see olen mina. Katsuge mind, siis olete kindlad, sest kummitusel ei ole liha ega luid, nagu näete minul olevat.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kui ta seda oli öelnud, näitas ta neile oma käsi ja jalgu. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kuid nad ei suutnud ikka veel uskuda, sest nad olid elevil ja hämmastuses. Ta küsis neilt: „Kas teil on midagi süüa?“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nad andsid talle tüki küpsetatud kala, ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ta võttis selle ja sõi seda nende silme all. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Siis ütles Jeesus neile: „Seda ma selgitasin teile siis, kui olin veel teie juures. Kõik, mis minust on kirjutatud Moosese seaduses, prohvetites ja psalmides, pidi täide minema.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Seejärel avas ta nende mõistuse, nii et nad suutsid Pühakirja mõista. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ta ütles neile: „Kirjutatud on, et Messias kannatab ja tõuseb kolmandal päeval surnuist üles ning tema nimel ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","kuulutatakse meeleparandust pattude andeksandmiseks kõigile rahvastele, alates Jeruusalemmast. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Te olete kõige selle tunnistajad. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nüüd saadan ma teile selle, mida mu Isa on tõotanud, aga oodake linnas, kuni saate väe taevast.“ ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Siis viis ta nad välja, kuni nad olid Betaania lähedal, ning tõstnud käed, õnnistas ta neid. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sel ajal kui ta neid õnnistas, lahkus ta neist ja ta võeti üles taevasse. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nad kummardasid teda ja läksid siis rõõmsana Jeruusalemma tagasi. ");
INSERT INTO ekkpkp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nad veetsid kogu oma aja templis Jumalat ülistades.");
INSERT INTO ekkpkp_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Alguses oli Sõna juba olemas. Sõna oli Jumala juures ja Sõna oli Jumal. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Alguses oli ta Jumala juures. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kõik on tekkinud tema kaudu; ilma temata ei ole tekkinud midagi. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Temas oli elu, see elu, mis on kõigi valgus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Valgus paistab pimedusse ja pimedus ei ole seda kustutanud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Jumal saatis mehe nimega Johannes. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ta tuli tunnistajana selgitama valgust, et kõik võiksid tema kaudu uskuda. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Tema ise ei olnud valgus, vaid ta tuli valgusest tunnistama. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tõeline valgus oli tulemas maailma, et valgustada kõiki. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ta oli maailmas, ja kuigi maailm oli tehtud tema kaudu, ei tundud maailm, kes ta on. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ta tuli omade juurde, kuid nad ei võtnud teda omaks. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kuid kõigile neile, kes ta vastu võtsid ja temasse uskusid, andis ta õiguse saada Jumala lapseks. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Need lapsed ei ole sündinud tavalisel moel, mitte inimese soovi või isa otsuse tulemusena, vaid nad on sündinud Jumalast. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Sõna sai inimeseks ja elas meie keskel ning me nägime tema au, Isa ühe ja ainsa Poja au, täis armu ja tõde. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Johannes tunnistas temast, hüüdes rahvale: „See on tema, kellest ma teile rääkisin, kui ütlesin: „See, kes tuleb pärast mind, on minust tähtsam, sest tema oli olemas juba enne mind.““ ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Me kõik oleme saanud osa tema heldusest, ühe armulise kingi teise järel. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Seadus anti Moosese kaudu; arm ja tõde tulid Jeesuse Kristuse kaudu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kuigi keegi ei ole eales Jumalat näinud, on üks ja ainus Jumal, kes on Isa lähedal, näidanud meile, missugune on Jumal. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Seda teatas Johannes avalikult, kui juudi juhid saatsid Jeruusalemmast preestreid ja leviite temalt küsima: „Kes sa oled?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Johannes kuulutas lihtsalt ja selgelt, ilma kõhklemata: „Ma ei ole Messias.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","„Kes sa siis oled?“ küsisid nad. „Kas Eelija?“ „Ei, ei ole,“ vastas ta. „Kas sa oled see prohvet?“ „Ei,“ kostis ta. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","„Kes sa siis oled?“ küsisid nad. „Me peame andma vastuse neile, kes meid saatsid. Mida sa enda kohta ütled?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","„Ma olen hääl, mis hüüab kõrbes: „Tehke Issanda tee sirgeks!““ ütles ta prohvet Jesaja sõnu kasutades. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Variseride saadetud preestrid ja leviidid ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","küsisid talt: „Miks sa siis ristid, kui sa ei ole Messias, Eelija ega see prohvet?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Johannes vastas: „Mina ristin veega, kuid teie keskel seisab see, keda te ei tunne. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tema tuleb pärast mind, aga ma ei ole väärt isegi tema sandaale lahti päästma.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","See kõik toimus teiselpool Jordanit Betaanias, kus Johannes ristis. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Järgmisel päeval nägi Johannes Jeesust lähenemas ja ütles: „Vaadake, Jumala Tall, kes võtab ära maailma patu! ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tema on see, kellest ma rääkisin, kui ütlesin: „Pärast mind tuleb minust tähtsam mees, sest tema oli olemas juba enne mind.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ma ise ei teadnud, kes ta on, kuid mina tulin ristima veega, et tema saaks Iisraelile ilmutatud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Johannes andis tunnistust temast, öeldes: „Ma nägin taevast laskumas Vaimu nagu tuvi ja tema peale jäämas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ma ei oleks teda tundud, kui see, kes läkitas mind veega ristima, ei oleks mulle öelnud: „See, kelle peale sa näed Vaimu laskumas ja sinna jäämas, on see, kes ristib Püha Vaimuga.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ma nägin seda toimumas ja kinnitan, et see on Jumala Poeg.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Järgmisel päeval seisis Johannes koos oma kahe jüngriga. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ta nägi Jeesust mööda minemas ja ütles: „Vaadake! See on Jumala Tall!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kui kaks jüngrit kuulsid tema sõnu, läksid nad ja järgisid Jeesust. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jeesus pöördus ja nägi neid järgnemas. „Mida te otsite?“ küsis ta neilt. „Rabi (mis tähendab „Õpetaja“), kus sa peatud?“ küsisid nad vastu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","„Tulge ja vaadake,“ ütles ta neile. Nii nad siis läksid koos temaga ja nägid, kus ta peatus. Kell oli umbes neli pärastlõunal, ja nad veetsid ülejäänud päeva temaga koos. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andreas, Siimon Peetruse vend, oli üks neist kahest jüngrist, kes olid kuulnud, mida Johannes ütles, ja oli Jeesust järginud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ta läks kohe otsima oma venda Siimonat ja ütles talle: „Me leidsime Messia!“ (mis tähendab „Kristus“). ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ta viis tema Jeesuse juurde. Siimonale otsa vaadates ütles Jeesus: „Sina oled Siimon, Johannese poeg. Aga nüüd hüütakse sind Keefaseks“ (mis tähendab „Peetrus“). ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Järgmisel päeval otsustas Jeesus minna Galileasse. Jeesus leidis sealt Filippuse ja ütles talle: „Järgne mulle.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filippus oli pärit Betsaidast, samast linnast, kust Andreas ja Peetruski. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filippus leidis Naatanaeli ja ütles talle: „Me leidsime tema, kellest Mooses kirjutas seaduses ja ka prohvetid − Naatsaretist pärit Jeesuse, Joosepi poja.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","„Naatsaretist? Kas sealt saab tulla midagi head?“ imestas Naatanael. „Lihtsalt tule ja vaata,“ vastas Filippus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kui Jeesus nägi Naatanaeli lähenemas, ütles ta tema kohta: „Vaadake, siin on õige iisraellane! Temas ei ole midagi väärat.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","„Kuidas sa tead, kes ma olen?“ küsis Naatanael. „Ma nägin sind seal viigipuu all, enne kui Filippus sind kutsus,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","„Rabi, sina oled Jumala Poeg, Iisraeli kuningas!“ hüüatas Naatanael. ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","„Kas sa usud seda lihtsalt sellepärast, et ma ütlesin sulle, et nägin sind viigipuu all?“ ütles Jeesus. „Sa saad näha veel palju rohkem kui see!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Seejärel lausus Jeesus: „Ma räägin teile tõtt: te kõik näete taeva olevat avatud ja Jumala inglid käimas üles ja alla inimese Poja peal.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kahe päeva pärast toimus Galileas Kaanas pulmapidu ning Jeesuse ema oli seal. ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jeesus ja tema jüngrid olid samuti pulma kutsutud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Vein sai otsa ja Jeesuse ema ütles Jeesusele: „Neil ei ole enam veini.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","„Ema, miks sa mind sellesse segad? Minu aeg ei ole veel tulnud,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tema ema ütles teenijatele: „Mida iganes ta teile ütleb, seda tehke.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Seal lähedal seisis kuus kivianumat, mida juudid kasutasid tseremoniaalsel pesemisel, igaüks neist mahutas ligi sada liitrit. ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","„Täitke anumad veega,“ ütles Jeesus neile. Nad täitsid need kohe. ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Seejärel ütles ta neile: „Valage veidi välja ja viige see pulmavanemale.“ Nad viisidki talle veidi proovida. ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Pulmavanem ei teadnud, kust see pärit on, ainult teenijad teadsid. Aga kui ta maitses vett, mis oli veiniks muutunud, kutsus ta peigmehe kõrvale. ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","„Kõik pakuvad kõigepealt parimat veini,“ ütles ta peigmehele, „ja kui inimesed on juba palju joonud, siis võtavad nad välja odavama veini. Kuid sina oled parima veini lõpuks hoidnud!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","See oli Jeesuse kõige esimene tunnustäht ja selle tegi ta Galilea Kaanas. Siin ilmutas ta oma auhiilgust ja tema jüngrid hakkasid temasse uskuma. ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pärast seda lahkus Jeesus koos oma ema, vendade ja jüngritega Kapernaumast, kus nad olid mõne päeva viibinud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kuna oli peaaegu juutide paasapüha aeg, läks Jeesus Jeruusalemma. ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Templist leidis ta inimesed veiseid, lambaid ja tuvisid müümas ning rahavahetajad laudade taga istumas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ta keerutas nööridest piitsa ja ajas kõik templist välja koos lammaste ja veistega, puistas rahavahetajate mündid laiali ja keeras nende lauad kummuli. ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ta käskis tuvimüüjaid: „Viige need asjad siit ära! Ärge muutke mu Isa koda turuplatsiks!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tema jüngritele meenusid Pühakirja sõnad: „Kiindumus sinu kojasse on mu sees nagu kõrvetav tuli!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Juudi juhid võtsid seepeale sõna ja küsisid talt: „Mis õigus on sul seda teha? Näita selle tõendamiseks mõnd tunnustähte!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jeesus vastas: „Hävitage see tempel ja ma taastan selle kolme päevaga!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","„Selle templi ehitamiseks kulus nelikümmend kuus aastat ja sina kavatsed selle kolme päevaga taastada?“ ütlesid juudi juhid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Aga tempel, millest Jeesus rääkis, oli tema ihu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Pärast seda, kui ta oli surnuist üles tõusnud, meenusid jüngritele tema sõnad ja nad uskusid Pühakirja ja Jeesuse sõnu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Imetegude tõttu, mida Jeesus Jeruusalemmas paasapüha ajal tegi, uskusid temasse paljud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kuid Jeesus ei usaldanud neid, sest ta teadis inimestest kõike. ");
INSERT INTO ekkpkp_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tal ei olnud vaja, et keegi talle inimloomusest räägiks, sest ta tundis inimeste mõtteviisi. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Oli üks mees nimega Nikodeemos, variser ja juutide valitseva nõukogu liige. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ta tuli öösel sinna, kus Jeesus oli, ja ütles: „Rabi, me teame, et sa oled Jumala juurest tulnud õpetaja, sest keegi ei suudaks teha tunnustähti, mida sina teed, kui Jumal ei oleks temaga.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","„Ma räägin sulle tõtt,“ vastas Jeesus, „kui sa pole uuesti sündinud, ei saa sa Jumala riiki kogeda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","„Kuidas saab vana inimene uuesti sündida?“ küsis Nikodeemos. „Ei saa ju minna tagasi emaüska ja teist korda sündida!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","„Ma räägin sulle tõtt: sa ei saa Jumala riiki, kui sa ei ole sündinud veest ja Vaimust,“ lausus Jeesus talle. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","„Mis ihust on sündinud, on ihu, ja mis Vaimust on sündinud, on Vaim. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ära üllatu, kui ma ütlen sulle: „Te peate uuesti sündima.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tuul puhub, kust tahab, ja sa kuuled ainult tema häält, kuid ei tea, kust ta tuleb või kuhu läheb; nii on igaühega, kes on Vaimust sündinud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","„Kuidas see võimalik on?“ küsis Nikodeemos. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","„Sa oled Iisraelis kuulus õpetaja, aga ikkagi ei mõista sa selliseid asju?“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","„Ma räägin sulle tõtt: me kõneleme sellest, mida teame, ja tunnistame sellest, mida oleme näinud, kuid sina keeldud meie tunnistust vastu võtmast. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kui sa ei usu seda, mida räägin sulle maistest asjadest, kuidas usuksid sa seda, kui räägiksin sulle taevastest asjadest? ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Keegi ei ole taevani jõudnud, kuid inimese Poeg tuli taevast alla. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Samamoodi nagu Mooses tõstis mao kõrbes üles, tõstetakse ka inimese Poeg üles, ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","et igaühel, kes temasse usub, oleks igavene elu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Sest Jumal armastas maailma nii väga, et andis oma ühe ja ainsa Poja, et igaüks, kes temasse usub, ei peaks surema, vaid tal oleks igavene elu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Jumal ei saatnud Poega maailma, et maailma hukka mõista, vaid et maailm tema kaudu päästa. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Neid, kes usuvad temasse, ei mõisteta hukka, kuid need, kes temasse ei usu, on juba hukka mõistetud, sest nad ei ole uskunud Jumala ühtainsat Poega. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Otsus tehakse nii: valgus tuli maailma, kuid inimesed armastasid pigem pimedust, mitte valgust, sest nende teod olid kurjad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kõik, kes teevad kurja, vihkavad valgust ega tule valguse kätte, sest nad ei taha, et nende teod avalikuks saaksid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Aga need, kes teevad head, tulevad valguse kätte, et saaks avalikuks see, mida Jumal neis teeb.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pärast seda läks Jeesus koos oma jüngritega Juudamaale ning oli seal mõnda aega koos rahvaga ja ristis neid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ka Johannes ristis Ainonis Salimi lähedal, sest seal oli rohkelt vett ja inimesed tulid, et ristitud saada. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(See oli enne Johannese vangistamist.) ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Johannese jüngrite ja ühe juudi vahel tekkis vaidlus tseremoniaalse puhastamise pärast. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nad läksid Johannese juurde ja ütlesid talle: „Rabi, see mees, kellega sa teiselpool Jordani jõge koos olid, see, kelle toetuseks sa tunnistasid, vaata, see ristib nüüd ja kõik lähevad tema juurde!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","„Keegi ei võta midagi vastu, kui seda ei anta talle taevast,“ vastas Johannes. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","„Te ise võite tunnistada, et ma ütlesin: „Mina ei ole Messias. Ma olen saadetud talle teed valmistama.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Peigmees on see, kellel on pruut! Isamees kuulatab peigmehe tulekut oodates ja ta on väga rõõmus, kui kuuleb peigmehe häält − samamoodi on minu rõõm nüüd täielik. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tema peab saama tähtsamaks ja mina muutuma vähem tähtsaks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","See, kes tuleb ülevalt, on kõigist suurem; see, kes tuleb maa pealt, kuulub maa peale ja räägib maistest asjadest. See, kes tuleb taevast, on kõigist suurem. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tema tunnistab sellest, mida ta on näinud ja kuulnud, kuid keegi ei võta tema sõnu vastu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kuid igaüks, kes tema sõnad vastu võtab, kinnitab, et Jumal on õige. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Sest see, kelle Jumal on läkitanud, kõneleb Jumala sõnu, sest Jumal ei piira Vaimu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Isa armastab Poega ja on kõik andnud tema kätte. ");
INSERT INTO ekkpkp_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Igaühel, kes usub Pojasse, on igavene elu, aga see, kes keeldub Poega uskumast, ei saa igavest elu, vaid tema osaks saab Jumala hukkamõist. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kui Jeesus mõistis, et variserid olid avastanud, et ta võidab poolehoidu ja ristib rohkem jüngreid kui Johannes ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(kuigi Jeesus ise ei ristinud, vaid tema jüngrid), ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","lahkus ta Juudamaalt ja läks tagasi Galileasse. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Teekonnal pidi ta läbi Samaaria minema. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nii jõudis ta Samaaria linna Sühhari juurde, mis asub selle põllu lähedal, mille Jaakob oli oma pojale Joosepile andnud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jaakobi kaev oli seal, ja Jeesus, kes oli teekonnast väsinud, istus otse kaevu kõrvale maha. Oli umbes keskpäev. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Üks samaaria naine tuli vee järele. Jeesus ütles talle: „Palun anna mulle juua!“, ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","sest tema jüngrid olid läinud linna toitu ostma. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","„Sina oled juut ja mina samaaria naine. Kuidas saad sa minult juua küsida?“ vastas naine, sest juudid ei suhtle samaarlastega. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jeesus vastas talle: „Kui sa ainult tunneksid ära Jumala anni ja selle, kes sinult küsib: „Palun anna mulle juua“, siis küsiksid sa temalt ja tema annaks sulle eluvett.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","„Isand, sul ei ole ämbrit ja kaev on sügav. Kust sa kavatsed eluvee saada?“ kostis naine. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","„Meie isa Jaakob andis meile kaevu. Ta jõi sellest ise, samuti ta pojad ja kariloomad. Kas sa oled temast parem?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jeesus vastas: „Igaühel, kes sellest kaevust vett joob, tuleb jälle janu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Aga sellel, kes joob vett, mille mina annan, ei tule enam kunagi janu. Vesi, mille mina annan, saab tema sees pulbitsevaks veeallikaks, mis annab talle igavese elu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","„Isand,“ vastas naine, „palun anna mulle seda vett, et mul ei oleks enam janu ja ma ei peaks tulema vee järele!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","„Mine kutsu oma mees ja tulge siia tagasi,“ ütles Jeesus talle. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","„Mul ei ole meest,“ vastas naine. „Sul on õigus, kui ütled, et sul ei ole meest,“ lausus Jeesus talle. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","„Sul on olnud viis meest ja see, kellega sa praegu elad, ei ole sinu mees. Nii et su sõnad on õiged.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","„Isand, ma näen, et sa oled prohvet,“ vastas naine. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","„Ütle mulle seda: meie esivanemad teenisid Jumalat sellel mäel, aga teie ütlete, et Jumalat tuleb teenida Jeruusalemmas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jeesus vastas: „Naine, usu mind, tuleb aeg, mil te ei kummarda Isa ei sellel mäel ega Jeruusalemmas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Te tõesti ei tunne Jumalat, keda te kummardate, kuid meie teenime Jumalat, keda me tunneme, sest pääste tuleb juutidelt. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kuid tuleb aeg − ja õigupoolest on see juba käes −, mil tõelised jumalateenijad teenivad Isa vaimus ja tões, sest Isa soovib selliseid teenijaid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Jumal on Vaim, nii et Jumala teenijad peavad teenima vaimus ja tões.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Naine ütles: „Ma tean, et Messias tuleb.“ (See, keda nimetatakse Kristuseks). „Kui ta tuleb, siis selgitab ta meile kõike.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jeesus vastas: „MINA OLEN − seesama, kes sinuga räägib.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Just siis tulid jüngrid tagasi. Nad olid rabatud, et Jeesus räägib naisega, kuid keegi neist ei küsinud: „Mida sa teed?“ ega „Miks sa temaga räägid?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Naine jättis veekruusi maha, jooksis tagasi linna ja rääkis rahvale: ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","„Tulge ja tutvuge mehega, kes rääkis mulle kõigest, mida ma olen kunagi teinud! Kas see võiks Messias olla?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Niisiis läksid inimesed linnast välja teda vaatama. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Vahepeal soovitasid jüngrid Jeesusele: „Rabi, söö ometi midagi!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kuid Jeesus vastas: „Mul on toitu, millest te midagi ei tea.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","„Kas keegi tõi talle süüa?“ küsisid jüngrid üksteiselt. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jeesus ütles neile: „Minu toit on täita tema tahtmist, kes mu läkitas, ja tema töö lõpule viia. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kas teil pole mitte ütlus: „Lõikuseni on veel neli kuud?“ Avage silmad ja vaadake ringi! Vili põldudel on küps, lõikuseks valmis. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Lõikajale on tasutud ja ta kogub vilja igaveseks eluks, et mõlemad, nii külvaja kui ka lõikaja, saaksid rõõmustada. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nii et vanasõna „Üks külvab, teine lõikab“ on õige. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ma saadan teid koguma saaki, mille nimel te ei ole tööd teinud. Teised tegid raske töö ja teie lõikate kasu sellest, mida nad tegid.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Paljud selle linna samaarlased uskusid temasse naise sõnade tõttu: „Ta rääkis mulle kõigest, mida ma olen kunagi teinud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kui nad siis tulid teda vaatama, anusid nad, et ta nende juurde jääks. Ta jäi sinna kaheks päevaks ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ja tema kõneletu tõttu uskusid temasse veel paljud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nad ütlesid naisele: „Nüüd me ei usu temasse lihtsalt sinu sõnade tõttu, vaid me ise oleme teda kuulnud. Oleme veendunud, et ta on tõesti maailma Päästja.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kahe päeva pärast läks ta edasi Galilea poole. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jeesus ise oli teinud märkuse, et prohvetit ei austata tema oma kodumaal. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Aga kui ta saabus Galileasse, võtsid inimesed ta heal meelel vastu, sest ka nemad olid käinud paasapühal ja näinud kõike, mida ta oli Jeruusalemmas teinud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ta külastas taas Galileas asuvat Kaanat, kus ta oli vee veiniks muutnud. Lähedal asuvas Kapernauma linnas elas kuninga ametnik, kelle poeg oli väga haige. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kui ta kuulis, et Jeesus oli tulnud Juudamaalt tagasi Galileasse, läks ta Jeesuse juurde ja palus teda, et ta tuleks ja teeks terveks tema poja, kes oli suremas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","„Kui te ei näe tunnustähti ja imetegusid, siis te ei usu mind,“ ütles Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","„Issand, lihtsalt tule enne, kui mu laps sureb!“ anus ametnik. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","„Mine koju,“ ütles Jeesus talle. „Su poeg jääb elama!“ Mees uskus, mida Jeesus oli talle öelnud, ning läks kodu poole. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kui ta oli alles teel, tulid sulased talle vastu uudisega, et tema poeg on elus ja paraneb. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ta küsis neilt, mis ajal oli tema pojal parem hakanud. „Eile kella ühe ajal päeval lahkus temast palavik,“ ütlesid nad talle. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Siis isa mõistis, et see oli täpselt see aeg, mil Jeesus oli talle öelnud: „Su poeg jääb elama!“ Siis uskusid tema ja kõik ta kodakondsed Jeesusesse. ");
INSERT INTO ekkpkp_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","See oli teine imeline tunnustäht, mille Jeesus tegi pärast Juudamaalt Galileasse tulemist. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pärast seda oli juutide püha, nii et Jeesus läks Jeruusalemma. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jeruusalemmas Lambavärava lähedal on tiik, mida heebrea keeles nimetatakse Betsataks ja mille kõrval on viis sammaskoda. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Haigete inimeste hulgad lamasid neis sammaskodades − pimedad, vigased ja halvatud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Üks mees, kes oli seal, oli kolmkümmend kaheksa aastat haige olnud. Jeesus vaatas talle otsa, teades, et ta oli seal kaua aega lamanud, ja küsis talt: ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","„Kas sa tahad terveks saada?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","„Isand,“ vastas haige mees, „mul ei ole kedagi, kes mind vette aitaks, kui vett segatakse. Sel ajal, kui ma sinna üritan minna, jõuab alati keegi minust ette.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","„Tõuse püsti, võta oma matt ja kõnni!“ ütles Jeesus talle. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kohe sai mees terveks. Ta võttis oma mati ja hakkas kõndima. Päev, mil see juhtus, oli hingamispäev. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Niisiis ütlesid juudid terveks saanud mehele: „Täna on hingamispäev! Seadus ei luba matti kanda!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","„Mees, kes mu terveks tegi, käskis mul mati võtta ja kõndida,“ vastas ta. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","„Kes see inimene on, kes sul käskis mati võtta ja kõndida?“ küsisid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kuid terveks saanud mees ei teadnud, kes see oli, sest Jeesus oli ümbritseva rahvahulga sisse lipsanud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Hiljem leidis Jeesus mehe templist ja ütles talle: „Vaata, sa oled nüüd terveks saanud. Ära siis tee enam pattu, muidu võib sinuga midagi hullemat juhtuda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mees läks juutide juurde ja ütles neile, et see oli Jeesus, kes oli ta terveks teinud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nii hakkasid juudid Jeesust kimbutama, sest ta tegi asju hingamispäeval. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Aga Jeesus ütles neile: „Minu isa tegutseb ikka veel ja nii ka mina.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Seetõttu üritasid juudid veel enam teda tappa, sest lisaks hingamispäeva rikkumisele nimetas ta Jumalat oma Isaks, tehes ennast Jumalaga võrdseks. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Niisiis selgitas Jeesus neile: „Ma räägin teile tõtt: Poeg ei saa iseenesest midagi teha; ta saab teha ainult seda, mida näeb Isa tegemas. Mida teeb Isa, seda teeb ka Poeg. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Sest Isa armastab Poega ja ilmutab talle, mida ta teeb; ja Isa näitab talle veel uskumatumaid asju, mis teid täielikult hämmastavad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Sest samamoodi nagu Isa annab elu neile, kelle ta surnuist üles äratab, annab ka Poeg elu neile, kellele tahab. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Isa ei mõista kellegi üle kohut. Kõik õigused kohut mõista on ta andnud Pojale, ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","et kõik austaksid Poega, nagu nad austavad Isa. Kes ei austa Poega, ei austa Isa, kes on Poja läkitanud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ma räägin teile tõtt: neil, kes järgivad, mida ma ütlen, ja usuvad temasse, kes minu on läkitanud, on igavene elu. Neid ei mõisteta hukka, vaid nad on läinud surmast ellu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ma räägin teile tõtt: tuleb aeg − õigupoolest on see juba käes −, kui surnud kuulevad Jumala Poja häält, ja need, kes kuulevad, elavad! ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Just nagu Isal on eluandev vägi iseeneses, on ta andnud sama eluandva väe Pojale. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Isa on andnud talle ka õiguse kohut mõista, sest ta on inimese Poeg. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ärge üllatuge sellest, sest tuleb aeg, mil kõik, kes on hauas, kuulevad tema häält ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ja tõusevad üles: need, kes on teinud head, elu ülestõusmiseks, ja need, kes on teinud kurja, hukkamõistmise ülestõusmiseks. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ma ei suuda iseenesest midagi teha. Ma mõistan kohut selle põhjal, mida on mulle öeldud, ja mu otsus on õige, sest ma ei täida enda tahet, vaid tema tahet, kes mu läkitas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kui ma väidaksin midagi enda kohta, ei oleks need väited kehtivad, ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","vaid keegi teine tunnistab minust ja ma tean, et see, mida ta minu kohta ütleb, on õige. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Te küsisite Johanneselt minu kohta ja ta rääkis tõtt, ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","kuid mul ei ole vaja inimeste heakskiitu. Ma selgitan seda teile, et te võiksite päästetud saada. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Johannes oli nagu eredalt põlev lamp ja te olite valmis mõnda aega tema valgust nautima. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Aga tunnistus, mida mina annan, on suurem kui Johannese oma, sest ma teen tööd, mille Isa andis mulle teha, ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ning see on tõend, et Isa läkitas mu. Isa, kes mu läkitas, räägib ise minu eest. Te ei ole kunagi tema häält kuulnud, te ei ole näinud, missugune ta välja näeb, ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ja te ei võta vastu, mida ta ütleb, sest te ei usu sellesse, kelle ta läkitas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Te uurite pühi kirju, sest arvate, et saate nende abil igavese elu. Kuid need tunnistavad minu toetuseks! ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ja ometi ei taha te minu juurde tulla, et võiksite elada. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ma ei taotle inimeste heakskiitu ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","− ma tunnen teid ja tean, et teie sees ei ole Jumala armastust. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Sest ma olen tulnud oma Isa esindama ja te ei võtnud mind vastu; aga kui tuleb keegi, kes esindab iseennast, siis võtate ta vastu! ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kuidas te saate minusse uskuda, kui taotlete kiitust üksteiselt ega taotle kiitust ainsalt tõeliselt Jumalat? ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Aga ärge arvake, et ma süüdistan teid Isa ees. Teid süüdistab Mooses, keda te nii väga usaldate. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Sest kui te tõesti usuksite Moosest, siis usuksite ka minusse, sest tema kirjutas minust. ");
INSERT INTO ekkpkp_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Aga kuna te ei usu, mida ta on öelnud, miks peaksite uskuma seda, mida ütlen mina?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mõne aja pärast asutas Jeesus end minema Galilea järve (tuntud ka kui Tibeeriase järv) teisele kaldale. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Suur rahvahulk järgnes talle, sest nad olid näinud tema tervendamisimesid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jeesus läks üles mäele ja istus sinna koos jüngritega maha. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Juutide paasapüha aeg oli lähenemas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kui Jeesus üles vaatas, ja nägi suurt rahvahulka enda poole tulemas, küsis ta Filippuselt: „Kust saame osta leiba, et neid inimesi toita?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ta küsis seda ainult sellepärast, et näha, kuidas Filippus vastab, sest Jeesus juba teadis, mida ta teha kavatseb. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","„Kahesaja hõbemündiga ei saa osta piisavalt leiba, et igaühele veidikenegi anda,“ vastas Filippus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Üks tema jüngritest, Andreas, Siimon Peetruse vend, võttis sõna. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","„Siin on üks poiss, kellel on viis odraleiba ja paar kala, aga mis kasu sellest on, kui inimesi on nii palju?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","„Pange kõik istuma,“ ütles Jeesus. Seal oli palju rohumaad, nii et kõik istusid maha, mehi oli umbes viis tuhat. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jeesus võttis leiva, tänas ja jagas selle inimestele, kui nad istusid. Sama tegi ta kaladega, hoolitsedes selle eest, et inimesed saaksid nii palju, kui tahavad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kui nad olid kõhu täis saanud, ütles Jeesus jüngritele: „Koguge ülejäägid kokku, et midagi raisku ei läheks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nii nad korjasid ja said kaksteist korvitäit viie odraleiva tükke, mida inimesed olid söönud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kui inimesed nägid seda imet, ütlesid nad: „Muidugi on tema see prohvet, kes pidi maailma tulema.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jeesus mõistis, et nad kavatsesid ta vägisi kuningaks teha, seega lahkus ta neist ja läks mägedesse, et üksinda olla. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kui saabus õhtu, läksid jüngrid alla järve äärde, ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","astusid paati ja suundusid üle vee Kapernauma poole. Nüüdseks oli öö ja Jeesus ei olnud veel nende juures. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tugev tuul hakkas puhuma ja järv muutus tormiseks. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kui nad olid viis-kuus kilomeetrit sõudnud, nägid nad Jeesust vee peal kõndimas ja paadi poole tulemas. Nad kohkusid väga. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","„Ärge kartke!“ ütles ta neile. „See olen mina.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Siis võtsid nad ta rõõmsalt paati ja kohe jõudsid nad kaldale, kuhu nad olid minemas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Järgmisel päeval märkas rahvas, kes oli jäänud järve teisele kaldale, et seal oli ainult üks paat ja et Jeesus ei olnud koos jüngritega paati läinud, vaid nad olid ilma temata lahkunud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Siis saabusid teised paadid Tibeeriaselt, maabudes selle koha lähedal, kus nad olid söönud leiba pärast seda, kui Issand oli seda õnnistanud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kui rahvas mõistis, et seal ei olnud ei Jeesust ega tema jüngreid, astusid nad paati ja läksid Kapernauma Jeesust otsima. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kui nad leidsid ta järve teiselt kaldal, küsisid nad temalt: „Rabi, millal sa siia jõudsid?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","„Ma räägin teile tõtt,“ vastas Jeesus, „te otsite mind sellepärast, et sõite nii palju leiba, kui tahtsite, mitte sellepärast, et mõisate imetegusid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ärge olge mures toidu pärast, mis ei kesta, vaid keskenduge igavese elu kestvale toidule, mida inimese Poeg teile annab, sest Jumal Isa on temale oma heakskiidu pitseri pannud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Siis nad küsisid temalt: „Mida me peaks tegema, et teha seda, mida Jumal soovib?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jeesus vastas: „Jumal tahab, et usuksite temasse, kelle ta läkitas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","„Missuguse imeteo sa meie jaoks teed, et saaksime sind uskuda? Mida sa oled võimeline tegema?“ küsisid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","„Meie esiisad sõid kõrbes mannat, nii täitus pühakirjatekst: „Ta andis neile taevast leiba süüa.““ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","„Ma räägin teile tõtt: Mooses ei andnud teile leiba taevast,“ vastas Jeesus. „See on mu Isa, kes annab teile tõelist leiba taevast. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sest Jumala leib on see, kes tuleb taevast ja annab oma elu maailmale.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","„Issand, palun anna meile kogu aeg sellist leiba!“ ütlesid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","„Mina olen eluleib,“ vastas Jeesus. „Kes minu juurde tuleb, sel ei ole enam kunagi nälga, ja kes minusse usub, ei tunne enam kunagi janu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aga nagu ma teile varem selgitasin: te olete mind näinud, kuid te ikka ei usu mind. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kõik, kelle Isa annab mulle, tulevad minu juurde ja ma ei lükka neist kedagi tagasi. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sest ma ei tulnud taevast alla tegema oma tahtmist, vaid seda, mida tahab see, kes mu läkitas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ta tahab, et ma ei kaotaks kedagi neist, kelle ta on mulle andnud, vaid et ma ärataks nad viimsel päeval üles. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Mu Isa tahab, et igaüks, kes näeb Poega ja usub temasse, saaks igavese elu ja et ma ärataksin ta viimsel päeval üles.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Siis hakkasid juudid tema üle nurisema, sest ta oli öelnud: „Mina olen leib mis tuli taevast alla.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nad ütlesid: „Kas ta pole see Jeesus, Joosepi poeg? Me teame tema isa ja ema. Kuidas ta saab siis nüüd meile öelda: „Ma tulin taevast alla“?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","„Jätke see nurin isekeskis,“ ütles Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","„Keegi ei saa tulla minu juurde, kui Isa, kes mu läkitas, teda ei tõmba; ja mina äratan ta viimsel päeval üles. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nagu on prohvetid Pühakirjas kirjutanud: „Kõik on Jumala õpilased.“ Igaüks, kes kuulab Isa ja õpib Isalt, tuleb minu juurde. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mitte et keegi oleks Jumalat näinud, välja arvatud see, kes on Jumala juurest; tema on Isa näinud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ma räägin teile tõtt: igaühel, kes minusse usub, on igavene elu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mina olen eluleib. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Teie esiisad sõid kõrbes mannat, kuid surid ikkagi. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Aga see on leib, mis tuleb taevast, ja mitte keegi, kes seda sööb, ei sure. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mina olen eluandev leib taevast ja igaüks, kes sööb seda leiba, elab igavesti. Leib on mu ihu, mille ma annan selleks, et maailm võiks elada.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Siis vaidlesid juudid ägedalt isekeskis. „Kuidas saab see mees anda meile süüa oma liha?“ küsisid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jeesus ütles neile: „Ma räägin teile tõtt: kui te ei söö inimese Poja liha ega joo tema verd, ei saa te tõeliselt elada. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Neil, kes söövad minu liha ja joovad minu verd, on igavene elu ja ma äratan nad viimsel päeval üles. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Sest minu liha on tõeline toit ja minu veri tõeline jook. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kes sööb minu liha ja joob mu verd, jääb minusse ja mina jään temasse. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nagu eluandev Isa läkitas mind ja ma elan Isa tõttu, samamoodi elab minu tõttu igaüks, kes minust toitub. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","See on see leib, mis tuli taevast alla, mitte see, mida teie esiisad sõid ja ikkagi surid. Kes sööb seda leiba, elab igavesti.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jeesus selgitas seda ajal, kui ta õpetas Kapernauma sünagoogis. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Paljud tema jüngritest ütlesid seda kuuldes: „Seda on raske omaks võtta! Kes suudab seda järgida?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jeesus nägi, et tema jüngrid kurtsid selle üle, seepärast küsis ta neilt: „Kas see pahandab teid? ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mis oleks siis, kui näeksite Poega minemas üles sinna, kus ta varem oli? ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Vaim annab elu, füüsiline ihu ei anna midagi. Sõnad, mis ma teile rääkinud olen, on vaim ja elu! ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Siiski on teie hulgas mõned, kes mind ei usu.“ (Jeesus oli algusest peale teadnud, kes teda ei usu ja kes ta reedab.) ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jeesus lisas: „Sellepärast ma ütlengi teile, et keegi ei saa minu juurde tulla, kui Isa ei ole seda võimalikuks teinud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Sellest ajast peale loobusid paljud Jeesuse jüngrid ega järginud enam teda. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Siis küsis Jeesus kaheteistkümnelt jüngrilt: „Kuidas teiega on? Kas teiegi tahate ära minna?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Siimon Peetrus vastus: „Issand, keda me järgiks? Sina oled ainus, kellel on igavese elu sõnad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Me usume sinusse ja oleme veendunud, et sa oled Jumala Püha.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jeesus vastas: „Kas ma ei valinud teid, kahtteistkümmet jüngrit? Siiski on üks teist kurat.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Jeesus viitas Juudale, Siimon Iskarioti pojale. Ta oli kaheteistkümnest see üks, kes Jeesuse ära andis.) ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pärast seda veetis Jeesus aega Galileas ühest paigast teise käies. Ta ei tahtnud nii teha Juudamaal, sest juudid olid plaani võtnud ta tappa. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Aga kui oli peaaegu juutide lehtmajapüha aeg, ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ütlesid tema vennad talle: „Sa peaksid lahkuma ja minema Juudamaale, et su järelkäijad näeksid, missuguseid imesid sa suudad teha. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Keegi, kes tahab kuulus olla, ei hoia oma tehtut salajas. Kui sa suudad selliseid imesid teha, siis näita ennast maailmale!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Sest isegi tema enda vennad ei uskunud tõeliselt temasse. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jeesus üles neile: „Mul ei ole veel aeg minna, aga teie võite minna, millal iganes soovite, sest teie jaoks on iga aeg õige. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Maailmal ei ole põhjust teid vihata, kuid mind ta vihkab, sest ma ütlen selgelt välja, et tema teguviis on halb. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Teie minge pühadele. Ma ei lähe neile pühadele, sest minu jaoks ei ole veel õige aeg.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Pärast selle ütlemist jäi ta Galileasse. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pärast seda kui Jeesuse vennad läksid pühadele, läks ka Jeesus, kuid mitte avalikult − ta hoidis end pilkude eest varjul. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nüüd pühade ajal otsisid juudi juhid teda ja küsisid muudkui: „Kus ta on?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Paljud rahva hulgast kurtsid tema peale. Mõned ütlesid: „Ta on hea inimene,“, samas teised vaidlesid vastu: „Ei! Ta petab inimesi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Aga mitte keegi ei julgenud temast avalikult rääkida, sest nad kartsid, mida juudi juhid neile teeks. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kui pühad olid poole peal, läks Jeesus templisse ja hakkas õpetama. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Juudi juhid olid üllatunud ja küsisid: „Kuidas on sel mehel nii palju teadmisi, kui ta pole haridust saanud?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jeesus vastas: „Minu õpetus ei ole minult, vaid temalt, kes mu läkitas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Igaüks, kes otsustab järgida seda, mida Jumal tahab, teab, kas mu õpetus on pärit Jumalalt või räägin ma ainult iseenesest. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Need, kes räägivad iseenesest, tahavad ennast ülistada, aga see, kes ülistab teda, kes on ta läkitanud, on õige ja mitte valelik. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mooses andis ju teile seaduse, kuid keegi teist ei pea seadust! Miks te üritate mind tappa?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","„Sa oled kurja vaimu mõju all!“ vastas rahvas. „Keegi ei ürita sind tappa!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","„Tegin ühe imeteo ja te kõik olete sellest šokeeritud,“ lausus Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","„Aga kuna Mooses käskis teil ümber lõigata − tegelikult ei pärine see Mooseselt, vaid teie esiisadelt enne teda −, siis teete ümberlõikuse hingamispäeval. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kui hingamispäeval ümberlõikuse teete, et mitte Moosese seadust rikkuda, miks te siis olete minu peale vihased sellepärast, et teen kellegi hingamispäeval terveks? ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ärge hinnake näilise järgi; otsustage, mis on õige!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Siis mõned neist, kes olid Jeruusalemmast, hakkasid arutlema: „Kas tema pole mitte see, keda nad tappa üritavad? ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Aga vaadake, kui avalikult ta räägib ja nad ei ütle talle midagi. Mis te arvate, kas võimukandjad usuvad, et ta on Messias? ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kuid see pole võimalik, sest me teame, kust ta pärit on. Kui Messias tuleb, ei tea keegi, kust ta tuleb.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Templis õpetades hüüdis Jeesus valju häälega: „Nii et te arvate, et tunnete mind ja teate, kust ma pärit olen? Ma ei tulnud aga iseenda pärast. See, kes mu läkitas, on tõeline. Te ei tunne teda, ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","aga mina tunnen teda, sest ma tulen tema juurest ja ta läkitas mu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Siis üritasid nad ta kinni võtma, aga keegi ei pannud kätt talle külge, sest tema aeg ei olnud veel tulnud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kuid paljud rahva hulgast hakkasid temasse uskuma. „Kui Messias ilmub, kas ta teeb siis rohkem tunnustähti, kui see inimene on teinud?“ ütlesid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kui variserid kuulsid rahvast temast sosistamas, siis saatsid nad koos ülempreestritega valvurid Jeesust kinni võtma. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Siis rääkis Jeesus rahvale: „Ma olen teie juures veel veidi aega, aga siis lähen tagasi selle juurde, kes mu läkitas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Te otsite mind, kuid ei leia, ning te ei saa tulla sinna, kuhu ma lähen.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Juudid ütlesid üksteisele: „Kuhu saaks ta minna, et me teda leida ei suudaks? Kas ta kavatseb minna nende juurde, kes on võõramaalaste sekka hajutatud ja võõramaalasi õpetada? ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mida ta mõtleb, kui ütleb: „Te otsite mind, kuid ei leia, ning te ei saa tulla sinna, kuhu ma lähen“?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pühade viimasel ja kõige tähtsamal päeval tõusis Jeesus püsti ja hüüdis valju häälega: „Kellel on janu, see tulgu minu juurde ja joogu! ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kui te usute minusse, siis voolab teist välja eluandev vesi, nagu Pühakirjas on öeldud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ta vihjas Vaimule, kelle pidid hiljem saama need, kes temasse usuvad. Vaimu ei olnud veel antud, sest Jeesust ei olnud veel austatud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kui nad neid sõnu kuulsid, ütlesid mõned: „See mees on kindlasti see Prohvet!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Teised ütlesid: „Ta on Messias!“ Veel mõned ütlesid: „Kuidas saab Messias tulla Galileast? ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kas Pühakiri ei ütle, et Messias tuleb Taaveti soost ja Taaveti kodulinnast Petlemmast?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nii olid rahva seas tema suhtes väga tugevad eriarvamused. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mõned tahtsid ta kinni võtta, kuid keegi ei pannud talle kätt külge. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Siis läksid valvurid tagasi ülempreestrite ja variseride juurde, kes küsisid neilt: „Miks te teda siia ei toonud?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","„Keegi ei ole kunagi nii rääkinud nagu see inimene,“ vastasid valvurid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","„Kas ka teid on ära petetud?“ küsisid variserid neilt. ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","„Kas ükski ülematest või variseridest on temasse uskunud? Ei! ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Aga see rahvas, kes ei tea midagi seaduse õpetustest − nad on niikuinii neetud!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodeemos, kes oli varem Jeesusega kohtumas käinud, oli üks neist ja ta küsis neilt: ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","„Kas meie seadus mõistab inimese hukka ilma kohtuistungita ja välja uurimata, mida ta tegelikult teinud on?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","„Nii et ka sina oled galilealane?“ küsisid nad vastu. „Kontrolli Pühakirjast ja sa leiad, et Galileast ei tule ühtki prohvetit!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Siis läksid nad kõik ära koju, ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jeesus aga läks Õlimäele. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Varahommikul läks ta tagasi templisse, kus tema ümber kogunes palju inimesi; ta istus maha ja õpetas neid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Vaimulikud õpetajad ja variserid tõid ühe abielurikkumiselt tabatud naise ja panid ta kõigi ette seisma. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nad ütlesid Jeesusele: „Õpetaja, see naine tabati abielurikkumiselt. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moosese seadus käsib sellised naised kividega surnuks visata. Mida ütled sina?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nad ütlesid seda selleks, et Jeesus proovile panna ja lõksu püüda, et nad saaksid ta süüdi mõista. Kuid Jeesus kummardus maha ja kirjutas sõrmega maapinnale. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nad nõudsid jätkuvalt vastust, seega tõusis ta püsti ja ütles neile: „See, kes teist ei ole kunagi pattu teinud, võib tema pihta esimese kivi visata.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Siis kummardus ta taas maha ja jätkas maa peale kirjutamist. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kui nad seda kuulsid, hakkasid nad ükshaaval lahkuma, alates vanimast, ning jätsid Jeesuse üksinda rahva keskele koos naisega, kes ikka veel seisis seal. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jeesus ajas end sirgu ja küsis naiselt: „Kus nad on? Kas keegi ei jäänud sind surma mõistma?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","„Ei keegi, isand,“ vastas naine. „Ega minagi sind surma mõista,“ ütles Jeesus talle. „Mine, ja ära tee enam pattu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jeesus hakkas uuesti rahvale rääkima ja ütles: „Mina olen maailma valgus. Kui te järgite mind, ei käi te pimeduses, sest teil on eluandev valgus.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Variserid vastasid: „Sa ei või iseenda tunnistaja olla! Sinu sõnad ei tõesta midagi!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","„Isegi kui ma olen iseenda tunnistaja, on mu tunnistus tõsi,“ ütles Jeesus neile, „sest ma tean, kust ma tulen ja kuhu ma lähen. Aga teie ei tea, kust ma tulin või kuhu ma lähen. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Te otsustate tüüpilisel inimlikul moel, aga mina ei otsusta kellegi üle. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Isegi kui ma otsustaksin, oleks minu otsus õige, sest ma ei tee seda üksi. Isa, kes mu läkitas, on minuga. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Teie enda seadus ütleb, et kahe tunnistaja tunnistus on kehtiv. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mina ise olen enda tunnistaja ja mu teine tunnistaja on mu Isa, kes mu läkitas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","„Kus su isa on?“ küsisid nad temalt. „Te ei tunne mind ega mu Isa,“ vastas Jeesus. „Kui te tunneksite mind, tunneksite ka mu Isa.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jeesus selgitas seda templi varakambri lähedal õpetades. Siiski ei võtnud keegi teda kinni, sest tema aeg ei olnud veel tulnud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jeesus ütles neile jälle: „Ma lahkun ja te otsite mind, aga te surete oma patus. Te ei saa tulla sinna, kuhu mina lähen.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Juudid imestasid valjuhäälselt: „Kas ta kavatseb end ära tappa? Kas ta seda mõtleb, kui ütleb: „Te ei saa tulla sinna, kuhu mina lähen“?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jeesus ütles neile: „Te olete alt, mina ülevalt. Te olete sellest maailmast, mina ei ole sellest maailmast. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Sellepärast ma ütlesin teile, et te surete oma pattudes. Sest kui te ei usu minusse, et „mina olen“, surete oma pattudes.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Siis nad küsisid temalt: „Kes sa oled?“ „Täpselt see, keda alguses ütlesin end olevat,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","„Ma võiksin teie kohta veel palju öelda ja palju hukka mõista. Aga see, kes mu läkitas, räägib tõtt, ja see, mida mina teile siin selles maailmas räägin, on see, mida ma temalt kuulen.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nad ei saanud aru, et ta rääkis neile Isast. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Niisiis Jeesus selgitas neile: „Kui olete inimese Poja üles tõstnud, siis teate, et mina olen „ma olen“ ja et ma ei tee iseenesest midagi, vaid räägin ainult seda, mida Isa mulle õpetab. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","See, kes minu läkitas, on minuga; ta ei ole mind maha jätnud, sest ma teen alati seda, mis on talle meele järele.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Paljud, kes kuulsid Jeesust neid asju rääkimas, hakkasid temasse uskuma. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Siis Jeesus ütles neile juutidele, kes temasse uskusid: „Kui te järgite mu õpetust, siis olete tõesti minu jüngrid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Te tunnete ära tõe ja tõde teeb teid vabaks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","„Me oleme Aabrahami järeltulijad! Me pole kunagi kellegi orjad olnud,“ vastasid nad. „Kuidas saad sa öelda, et me saame vabaks?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jeesus vastas: „Ma räägin teile tõtt: igaüks, kes pattu teeb, on patu ori. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Orjal ei ole perekonnas alatist kohta, kuid poeg on igavesti perekonna osa. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kui Poeg teid vabaks teeb, siis olete tõeliselt vabad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ma tean, et te olete Aabrahami järeltulijad, kuid ometi üritate mind tappa, sest te keeldute mu sõnu vastu võtmast. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ma räägin teile seda, mida Isa on mulle ilmutanud, samal ajal teete teie seda, mida teie isa teid käsib.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","„Meie isa on Aabraham,“ vastasid nad. „Kui te tõesti oleksite Aabrahami lapsed, siis te teeksite seda, mida Aabraham tegi,“ ütles Jeesus neile. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","„Aga te üritate mind praegu tappa, sest ma räägin teile tõtt, mida ma Jumalalt kuulen. Aabraham ei oleks iial seda teinud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Te teete seda, mida teeb teie isa.“ „Meie ei ole väljaspool abielu sündinud,“ kostsid nad. „Ainult Jumal on meie isa!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jeesus vastas: „Kui Jumal oleks tõesti teie isa, siis te armastaksite mind. Ma tulin Jumala juurest ja olen nüüd siin. Otsust ei teinud mina, vaid see, kes mu läkitas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Miks te ei suuda mõista, mida ma räägin? Sellepärast, et te keeldute mu sõnumit kuulmast! ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Teie isa on kurat, ja teile meeldib oma isa kurje soove järgida. Ta oli algusest peale mõrtsukas. Ta pole kunagi tõe eest seisnud, sest temas ei ole tõde. Kui ta valetab, ilmutab ta oma tõelist olemust, sest ta on valetaja ja valede isa. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Niisiis sellepärast, et ma räägin teile tõtt, te ei usu mind! ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kas keegi teist suudab tõestada, et ma olen patus süüdi? Kui ma räägin teile tõtt, miks te ei usu mind? ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Igaüks, kes kuulub Jumalale, kuulab, mida Jumal räägib. Põhjus, miks te ei kuula, on see, et te ei kuulu Jumalale.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","„Kas meil pole õigus, kui nimetame sind kurjast vaimust vaevatud samaarlaseks?“ küsisid juudid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","„Ei, mul ei ole kurja vaimu,“ vastas Jeesus. „Ma austan oma Isa, aga teie teotate mind. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ma ei ole siin endale ülistust otsimas. Aga on keegi kes teeb seda minu eest ja kes mõistab kohut minu kasuks. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ma räägin teile tõtt: kes järgib minu õpetust, see ei sure.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","„Nüüd me teame, et sa oled kurjast vaimust vaevatud,“ ütlesid juudid. „Aabraham suri ja prohvetid ka ning sina ütled meile: „Kes järgib minu õpetust, see ei sure“! ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kas sa oled suurem kui meie isa Aabraham? Tema suri ja prohvetid surid. Kes sa oma arust oled?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jeesus vastas: „Kui ma ülistaksin iseennast, ei tähendaks see midagi. Aga Jumal ise on see, kes mind ülistab, tema, kelle kohta te väidate: „Ta on meie Jumal.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Teie ei tunne teda, aga mina tunnen. Kui ma ütleksin: „Ma ei tunne teda“, oleksin ma valetaja nagu teie. Aga ma tunnen teda ja teen seda, mida ta ütleb. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Teie isa Aabraham ootas rõõmuga, et näha minu tulekut, ja ta oli väga õnnelik, kui seda nägi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Juudid vastasid: „Sa ei ole isegi mitte viiekümneaastane ja oled Aabrahami näinud?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","„Ma räägin teile tõtt: enne kui Aabraham sündis, olen mina,“ ütles Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Selle peale võtsid nad kive, et teda kividega surnuks visata, kuid Jeesus peideti nende eest ja ta lahkust templist. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Kui Jeesus oli möödumas, nägi ta üht pimedana sündinud meest. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jüngrid küsisid temalt: „Rabi, miks see mees pimedana sündis? Kas tema tegi pattu või ta vanemad?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jeesus vastas: „See ei ole ei selle mehe ega tema vanemate pattude tõttu. Aga et tema elus võiks ilmneda see, mida Jumal suudab teha, ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","peame jätkuvalt tegema selle tegusid, kes mu läkitas, kuni on veel päev. Tuleb öö, mil keegi ei saa tööd teha. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Sel ajal kui mina siin maailmas olen, olen ma maailma valgus.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kui Jeesus seda oli öelnud, sülitas ta maha ja tegi süljega veidi pori, mille ta määris mehe silmadele. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Siis ütles Jeesus mehele: „Mine ja pese end Siiloahi tiigis (mis tähendab „läkitatu“).“ Niisiis mees läks ja pesi ning kui ta koju läks, siis ta nägi. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tema naabrid ja need, kes olid tundnud teda kerjusena, küsisid: „Kas see pole mitte see mees, kes tavaliselt istus ja kerjas?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mõned ütlesid, et ta on see, samas teised ütlesid: „Ei, see on lihtsalt keegi, kes näeb tema moodi välja.“ Kuid mees kordas: „See olen mina!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","„Kuidas sa siis näed?“ küsisid nad temalt. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ta vastas: „Üks mees nimega Jeesus tegi veidi pori, määris mu silmadele ja käskis: „Mine ja pese end Siiloahi tiigis.“ Nii ma läksin ja pesin ja nüüd ma näen.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","„Kus ta on?“ küsisid nad. „Ma ei tea,“ vastas ta. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nad viisid mehe, kes oli olnud pime, variseride juurde. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Oli ju hingamispäev, kui Jeesus oli teinud pori ja avanud pimeda mehe silmad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Seega küsisid ka variserid, kuidas ta näeb. Mees vastas neile: „Ta määris mu silmadele pori, ma pesin ja nüüd ma näen.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mõned variserid ütlesid: „Mees, kes seda tegi, ei saa olla Jumalast, sest ta ei pea hingamispäeva.“ Aga teised imestasid: „Kuidas saaks patune selliseid imesid teha?“ Nii olid nad lahkarvamusel. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Siis jätkasid nad mehe küsitlemist. „Mida arvad siis sina temast, ta avas ju sinu silmad,“ küsisid nad. „Kindlasti on ta prohvet,“ vastas mees. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Juudi juhid keeldusid ikkagi uskumast, et mees, kes oli olnud pime, näeb nüüd, kuni nad kutsusid kohale mehe vanemad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nad küsisid neilt: „Kas see on teie poeg, kes teie sõnul sündis pimedana? Kuidas ta siis nüüd näeb?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tema vanemad vastasid: „Me teame, et see on meie poeg, kes suri pimedana. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Aga meil pole aimugi, kuidas ta nüüd näeb või kes ta terveks tegi. Küsige talt endalt, ta on piisavalt vana. Ta saab ise enda eest rääkida.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Põhjus, miks tema vanemad nii ütlesid, oli see, et nad kartsid, mida juudi juhid teha võivad. Juudi juhid olid juba teatanud, et igaüks, kes kuulutab, et Jeesus on Messias, visatakse sünagoogist välja. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Sellepärast ta vanemad ütlesidki: „Küsige talt endalt, ta on piisavalt vana.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Veelkord kutsusid nad sisse mehe, kes oli olnud pime, ja ütlesid talle: „Austa Jumalat! Me teame, et see mees on patune.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mees vastas: „Kas ta on patune või mitte, seda ma ei tea. Tean vaid, et ma olin pime ja nüüd ma näen.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Siis küsisid nad talt: „Mida ta sulle tegi? Kuidas ta su silmad avas?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mees vastas: „Ma juba rääkisin teile. Kas te ei kuulanud? Miks te tahate seda uuesti kuulda? Ega teiegi taha tema jüngriteks saada?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nad sõimasid teda valjusti ja ütlesid: „Sina oled selle mehe jünger. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Meie oleme Moosese jüngrid. Me teame, et Jumal rääkis Moosesega, aga selle inimese kohta me ei tea isegi, kust ta pärit on.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mees vastas: „See on uskumatu! Te ei tea, kust ta pärit on, aga ta avas mu silmad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Me teame, et Jumal ei kuule patuseid, kuid ta kuuleb igaüht, kes teenib teda ja täidab tema tahtmist. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Iialgi varem ajaloos ei ole keegi kuulnud, et pimedana sündinu saaks terveks. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kui see mees ei oleks Jumalast, ei suudaks ta midagi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","„Sa oled täielikult patusena sündinud ja ometi üritad meid noomida,“ vastasid nad. Ja nad heitsid ta sünagoogist välja. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kui Jeesus kuulis, et ta oli välja visatud, läks ta ja otsis mehe üles ning küsis temalt: „Kas sa usud inimese Pojasse?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mees vastas: „Ütle mulle, kes ta on, isand, et ma saaksin temasse uskuda.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","„Sa oled teda juba näinud. Tema see on, kes sinuga praegu räägib!“ ütles Jeesus talle. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","„Ma usun sind, Issand!“ ütles mees ja põlvitas kummardades Jeesuse ette. ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Siis ütles Jeesus talle: „Ma olen tulnud tooma maailmale kohtuotsust selleks, et need, kes on pimedad, võiksid näha, ja need, kes näevad, saaksid pimedaks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mõned variserid, kes olid koos Jeesusega, küsisid talt: „Ega meiegi pimedad ole?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jeesus vastas: „Kui te oleksite pimedad, ei oleks teil süüd. Aga nüüd, kui te ütlete, et näete, jääb teie süü alles.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","„Ma räägin teile tõtt: igaüks, kes ei tule lambatarasse värava kaudu, vaid ronib sisse muul moel, on varas ja röövel. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","See, kes tuleb sisse värava kaudu, on lammaste karjane. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Väravavaht avab talle ja lambad vastavad tema häälele. Ta hüüab oma lambaid nimepidi ja juhib nad välja. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kui ta on nad välja viinud, kõnnib ta nende ees ja lambad järgnevad talle, sest nad tunnevad tema häält. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Võõrale nad ei järgneks. Õigupoolest põgenevad nad võõra eest, sest nad ei tunne võõraste häält.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Kui Jeesus esitas selle illustratsiooni, siis kuulajad ei mõistnud, mida ta sellega mõtles. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Niisiis selgitas Jeesus uuesti: „Ma räägin teile tõtt: mina olen lammaste värav. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kõik, kes tulid enne mind, olid vargad ja röövlid, kuid lambad ei kuulanud neid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mina olen värav. Igaüks, kes tuleb sisse minu kaudu, saab tervendatud. Nad saavad tulla ja minna ning vajalikku toidust leida. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Varas tuleb ainult varastama, tapma ja hävitama. Mina olen tulnud teile tooma elu – elu, mis on pilgeni täis. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Mina olen hea karjane. Hea karjane jätab oma elu lammaste eest. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Lambaid valvama palgatud inimene ei ole karjane ja ta põgeneb, kui näeb hunti tulemas. Ta jätab lambad maha, sest nad pole tema omad, ning hunt ründab karja ja pillutab selle laiali, ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","sest mees töötab üksnes palga pärast ega hooli lammastest. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Mina olen hea karjane. Mina tunnen omi ja nemad tunnevad mind, ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","just nagu Isa tunneb mind ja mina tunnen teda. Ma jätan oma elu lammaste eest. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mul on teisi lambaid, kes ei ole selles taras. Ma pean nemadki siia tooma. Nad kuulavad mu häält ja siis on üks kari ühe karjasega. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Sellepärast Isa armastab mind, et ma jätan oma elu, et saaksin selle jälle võtta. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Keegi ei võta seda minult; mina otsustasin selle jätta. Mul on õigus see jätta ja õigus see tagasi võtta. See on käsk, mille mu Isa mulle andis.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nende sõnade pärast olid juudid taas Jeesuse suhtes lahkarvamusel. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Paljud neist ütlesid: „Ta on kurjast vaimust vaevatud! Ta on hullumeelne! Miks te teda kuulate?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Teised ütlesid: „Kurjast vaimust vaevatu ei räägi selliseid sõnu. Pealegi, kuri vaim ei suuda pimedate silmi avada.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Oli talv ja Jeruusalemmas templi pühitsemise püha aeg. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jeesus kõndis templis Saalomoni sammaskäigus. Juudid ümbritsesid teda ja küsisid: ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","„Kui kaua sa hoiad meid teadmatuses? Kui sa oled Messias, siis ütle meile otse!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jeesus vastas: „Ma juba ütlesin teile, aga te keeldute uskumast. Imeteod, mida ma oma Isa nimel teen, tõendavad, kes ma olen. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Te ei usu mind, sest te pole minu lambad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Minu lambad tunnevad mu häält; ma tunnen neid ja nad järgnevad mulle. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ma annan neile igavese elu; nad ei lähe eales kaotsi ja keegi ei saa neid minult ära kahmata. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Minu Isa, kes nad mulle andis, on kõigist suurem; keegi ei saa neid temalt ära kahmata. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mina ja Isa oleme üks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Taaskord haarasid juudid kivid, et ta kividega surnuks visata. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jeesus ütles neile: „Te olete näinud palju häid tegusid, mida ma olen Isalt teinud. Millise eest neist te mind kividega viskate?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Juudid vastasid: „Me ei viska sind kividega hea tegemise pärast, vaid jumalateotuse pärast, sest sa oled kõigest inimene, kuid väidad, et oled Jumal.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jeesus vastas neile: „Kas teie seaduses pole kirjutatud: „Ma ütlesin: Te olete jumalad“? ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ta nimetas neid inimesi jumalateks − inimesteks, kellele tuli Jumala sõna − ja Pühakirja ei või muuta. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Miks te siis ütlete, et see, kelle Isa välja valis ja maailma läkitas, teotab Jumalat, sest ma ütlesin „Ma olen Jumala Poeg“? ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kui ma ei tee seda, mida teeb mu Isa, siis ärge mind uskuge. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Aga kui ma seda teen, siis isegi kui te mind ei usu, peaksite uskuma tõendite pärast, mida ma olen teinud. Nii saate teada ja mõista, et Isa on minus ja mina Isas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Taaskord üritasid nad teda kinni võtta, kuid ta pääses nende käest. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ta läks tagasi üle Jordani jõe kohta, kus Johannes oli ristimist alustanud, ja jäi sinna. ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tema juurde tuli palju inimesi ja nad ütlesid: „Johannes ei teinud imetegusid, aga kõik, mida ta selle mehe kohta rääkis, on täide läinud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Paljud, kes seal olid, hakkasid Jeesusesse uskuma. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Üks mees nimega Laatsarus oli haige. Ta elas Betaanias koos oma õdede Maarja ja Martaga. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maarja oli see, kes oli Issandat lõhnaainega võidnud ja tema jalgu oma juustega kuivatanud. Tema vend Laatsarus oli haige. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Õed saatsid siis Jeesusele sõnumi: „Issand, su lähedane sõber on haige.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kui Jeesus uudist kuulis, ütles ta: „Selle haiguse lõpptulemus ei ole surm. Selle kaudu ilmneb Jumala au, et Jumala Poeg saaks austatud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Kuigi Jeesus armastas Martat, Maarjat ja Laatsarust ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ning oli kuulnud, et Laatsarus on haige, jäi ta veel kaheks päevaks sinna, kus ta oli. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Siis ütles ta jüngritele: „Lähme tagasi Juudamaale.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Jüngrid vastasid: „Rabi, alles mõne päeva eest üritasid juudid sind kividega surnuks visata. Kas sa tõesti tahad praegu sinna tagasi minna?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","„Eks ole päevas kaksteist tundi?“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","„Kui kõnnid päeval, siis sa ei komista, sest sa näed selle maailma valguses, kuhu sa lähed. Aga kui sa kõnnid öösel, siis sa komistad, sest sul ei ole valgust.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pärast selle rääkimist ütles ta: „Meie sõber Laatsarus on magama jäänud, aga ma lähen sinna ja äratan ta üles!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jüngrid ütlesid: „Issand, kui ta magab, siis hakkab tal parem.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jeesus oli vihjanud Laatsaruse surmale, kuid jüngrid arvasid, et ta mõtleb tegelikku magamist. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Niisiis ütles Jeesus neile otse: „Laatsarus on surnud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Teie pärast olen ma rõõmus, et mind polnud seal, sest nüüd saate minusse uskuda. Lähme teda vaatama.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kaksik Toomas ütles oma kaasjüngritele: „Lähme ka, et võiksime koos temaga surra.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kui Jeesus kohale jõudis, sai ta teada, et Laatsarus oli nelja päeva eest hauda pandud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betaania asus Jeruusalemmast ainult kolme kilomeetri kaugusel ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ja paljud juudid olid tulnud Maarjat ja Martat venna kaotuse pärast lohutama. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kui Marta sai teada, et Jeesus tuleb, läks ta välja temaga kohtuma, kuid Maarja jäi majja. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta ütles Jeesusele: „Issand, kui sa oleksid siin olnud, siis mu vend ei oleks surnud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Aga ma olen kindel, et isegi nüüd annab Jumal sulle, mida iganes sa palud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jeesus ütles talle: „Sinu vend tõuseb surnuist üles.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","„Ma tean, et ta tõuseb surnuist üles viimsepäeva ülestõusmisel,“ vastas Marta. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jeesus ütles: „Mina olen ülestõusmine ja elu. Kes minusse usub, see elab, isegi kui ta sureb. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Mitte keegi, kes elab minus ja usub minusse, ei sure. Kas sa usud seda?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","„Jah, Issand,“ vastas Marta, „ma usun, et sina oled Messias, Jumala Poeg, see, kes pidi siia maailma tulema.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kui Marta seda oli öelnud, läks ta ja ütles oma õele Maarjale salaja: „Õpetaja on siin ja tahab sind näha.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kohe kui Maarja seda kuulis, tõusis ta kiiresti ja läks Jeesusele vastu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jeesus ei olnud veel külasse jõudnud. Ta oli ikka veel selles kohas, kus Marta temaga oli kohtunud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Juudid, kes olid olnud Maarjat majas lohutamas, nägid, kuidas ta kiiresti tõusis ja lahkus. Nad järgnesid talle, arvates, et ta läheb haua juurde nutma. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kui Maarja jõudis paika, kus Jeesus oli, ja ta nägi Jeesust, langes ta tema jalge ette ja ütles: „Issand, kui sa siin oleksid olnud, siis mu vend ei oleks surnud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kui Jeesus nägi teda nutmas ja juute, kes tulid samuti temaga koos nutma, läks ta endast välja. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","„Kuhu te ta panite?“ küsis ta. Nad vastasid: „Issand, tule ja vaata.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Siis nuttis ka Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","„Näete, kui väga ta teda armastas,“ ütlesid juudid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Aga mõned neist ütlesid: „Kui ta suutis pimeda mehe silmad avada, kas ta ei oleks suutnud hoida Laatsarust suremast?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Endast väljas olles läks Jeesus haua juurde. See oli koobas, mille suu ette oli pandud suur kivi. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","„Eemaldage kivi,“ käskis Jeesus. Kuid Marta, surnud mehe õde, ütles: „Issand, seal on nüüd kohutav hais, sest ta on neli päeva surnud olnud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","„Kas ma ei öelnud sulle, et kui sa usuksid minusse, näeksid sa Jumala au?“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Niisiis eemaldasid nad kivi. Jeesus vaatas taeva poole ja ütles: „Isa, ma tänan sind, et sa mind kuuled. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ma tean, et sa kuuled mind alati. Ütlen seda siin seisva rahva pärast, et nad usuksid, et sina läkitasid mu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pärast neid sõnu hüüdis Jeesus: „Laatsarus, tule välja!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Surnud mees tuli välja, käed ja jalad linaste ribadega kinni seotud ning riie näo ümber. „Siduge ta lahti ja laske ta vabaks,“ käskis Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Selle tulemusena hakkasid Jeesusesse uskuma paljud juudid, kes olid tulnud Maarjat lohutama ja nägid, mida Jeesus tegi. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kuid teised läksid variseride juurde ja jutustasid neile, mida Jeesus oli teinud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Seejärel kutsusid ülempreestrid ja variserid kokku valitseva nõukogu koosoleku. „Mida me peame tegema?“ küsisid nad. „See mees teeb palju imetegusid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kui me laseme tal jätkata, hakkavad kõik temasse uskuma ning siis hävitavad roomlased nii templi kui ka meie rahva.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","„Te ei saa millestki aru!“ ütles Kaifas, kes oli tol aastal ülempreester. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","„Kas te ei mõista, et teile on parem, et üks inimene sureb rahva eest, nii et kogu rahvast ei hävitataks?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ta ei öelnud seda iseenesest, vaid tolle aasta ülempreestrina kuulutas ta prohvetlikult, et Jeesus sureb rahva eest. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ja mitte ainult juudi rahva eest, vaid kõigi hajutatud Jumala laste eest, et nad saaksid kokku kogutud ja üheks. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Sellest ajast peale tegid nad plaane, kuidas nad saaksid Jeesust tappa. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Seega ei rännanud Jeesus avalikult juutide hulgas, vaid läks kõrbelähedases piirkonnas asuvasse Efraimi linna ja jäi oma jüngritega sinna. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Oli peaaegu juutide paasapüha aeg ja palju rahvast läks maalt Jeruusalemma, et end paasapüha jaoks puhastada. ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Inimesed otsisid Jeesust ja rääkisid temast, kui nad templis seisid. „Mida te arvate?“ küsisid nad üksteiselt. „Kas ta tuleb pühadele?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ülempreestrid ja variserid olid andnud korralduse, et igaüks, kes teab, kus Jeesus on, peab sellest teatama, et nad saaksid ta kinni võtta. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Kuus päeva enne paasapüha läks Jeesus Betaaniasse Laatsaruse juurde, kes oli surnuist üles äratatud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Seal korraldati tema auks pidusöök. Marta aitas toitu serveerida, samal ajal istus Laatsarus koos Jeesuse ja teiste külalistega laua ääres. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maarja tõi umbes pool liitrit puhast nardiõli, võidis Jeesuse jalgu ja kuivatas neid oma juustega. Parfüümi lõhn täitis kogu maja. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Aga üks jüngritest, Juudas Iskariot, kes hiljem Jeesuse ära andis, küsis: ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","„Miks ei müüdud seda parfüümi ära ega antud raha vaestele? See oli väärt kolmsada denaari.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ta ei öelnud seda sellepärast, et ta hoolis vaestest, vaid sellepärast, et ta oli varas. Tema oli see, kes hoolitses jüngrite raha eest ja ta võttis sageli sellest endale. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","„Ärge arvustage teda,“ vastas Jeesus. „Ta tegi seda minu matusepäevaks valmistudes. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Vaeseid on teie juures alati, kuid mind ei ole siin alati.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Suur hulk juute oli avastanud, et ta on seal. Nad tulid sinna mitte ainult Jeesust vaatama, vaid nad tahtsid näha ka Laatsarust, meest, kelle Jeesus oli surnuist üles äratanud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Niisiis kavatsesid ülempreestrid tappa ka Laatsaruse, ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kuna tema pärast ei järginud nii paljud enam juudi juhte, vaid hakkasid Jeesusesse uskuma. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Järgmisel päeval kuulsid paasapühale tulnud rahvahulgad, et Jeesus on teel Jeruusalemma. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nad lõikasid palmioksi ja läksid teda tervitama, hüüdes: „Hosanna! Õnnistatud on see, kes tuleb Issanda nimel. Õnnistatud on Iisraeli kuningas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jeesus leidis noore eesli ja ratsutas selle seljas, nagu öeldakse Pühakirjas: ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","„Ära karda, Siioni tütar. Vaata, su kuningas tuleb, ratsutab eeslisälu seljas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Sel ajal Jeesuse jüngrid ei mõistnud, mida need asjad tähendavad. Alles pärast tema ülendamist nad mõistsid, et juhtunu oli prohvetite poolt ette kuulutatud ja käis tema kohta. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Paljud rahva seast olid näinud, kuidas Jeesus kutsus Laatsaruse hauast välja ja äratas ta surnuist üles ning nad jutustasid seda lugu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","See oli põhjus, miks nii paljud läksid Jeesusega kohtuma − sest nad olid kuulnud sellest imeteost. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Variserid ütlesid üksteisele: „Vaadake, me ei jõua kuhugi. Kõik jooksevad tema järel.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ka mõned kreeklased olid tulnud pühadele Jumalat teenima. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nad tulid Galilea Betsaidast pärit Filippuse juurde ja ütlesid: „Isand, me tahaksime Jeesust näha.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filippus läks ja rääkis Andreasele. Siis läksid nad koos Jeesuse juurde ja rääkisid talle. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jeesus vastas: „Inimese Pojal on tulnud aeg, et ta saaks austatud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ma räägin teile tõtt: kui nisutera ei külvata mulda ja ta ei sure, jääb ta lihtsalt üheks teraks. Aga kui ta sureb, annab ta veel palju nisuteri. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kui te armastate oma elu, siis te kaotate selle, aga kui te ei armasta oma elu selles maailmas, siis hoiate oma elu igavesti. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kui tahate mind teenida, peate mind järgima. Minu teenijad on seal, kus olen mina, ja mu Isa austab igaüht, kes mind teenib. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Nüüd olen ma murelik. Mida peaksin ütlema? „Isa, säästa mind sellest tulevasest kannatuste ajast?“ Ei, sest sellepärast ma tulingi − et minna läbi selle kannatuste aja. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Isa, näita mulle oma iseloomu au.“ Taevast kostis hääl, mis ütles: „Ma olen juba selle au näidanud ja näitan seda veel.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Rahvas, kes seal seisis, kuulis seda. Mõned ütlesid, et see oli kõuemürin, teised ütlesid, et ingel rääkis temaga. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jeesus ütles neile: „See hääl ei kõnelenud minu, vaid teie pärast. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nüüd on selle maailma kohus; nüüd heidetakse selle maailma vürst välja. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Aga kui mind maa pealt üles tõstetakse, tõmban ma kõik enda juurde.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Ta ütles seda, et viidata, missugust surma pidi ta surema.) ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Rahvas vastas: „Seadus ütleb, et Messias elab igavesti, kuidas sa saad siis öelda, et inimese Poeg „tõstetakse üles“? Kes on „inimese Poeg“?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jeesus vastas: „Valgus on siin teie juures veidi aega. Kõndige, kuni teil on valgus, et pimedus ei tabaks teid ootamatult. Need, kes kõnnivad pimeduses, ei tea, kuhu nad lähevad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Uskuge valgusesse, kuni see teil on, et te saaksite valguse lasteks.“ Kui Jeesus oli neile seda öelnud, siis ta lahkus ja peitis end nende eest. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Aga hoolimata kõigist imetegudest, mida Jeesus oli nende juuresolekul teinud, ei uskunud nad ikkagi Jeesusesse. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nii läks täide prohvet Jesaja sõnum: „Issand, kes on uskunud seda, mida neile rääkisime? Kellele on Issanda vägi ilmutatud?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nad ei suutnud temasse uskuda ja nii täitsid nad selle, mida Jesaja on veel öelnud: ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","„Ta pimestas nende silmad ja tegi nende mõistuse nüriks, et nende silmad ei näeks ja mõistus ei mõtleks ja nad ei pöörduks minu poole, sest kui nad seda teeksid, siis ma tervendaksin nad.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jesaja nägi Jeesuse au ja ütles seda temale viidates. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Isegi palju juhte uskus temasse. Kuid nad ei tunnistanud seda avalikult, sest ei tahtnud, et variserid nad sünagoogist välja heidaks, ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","sest nad armastasid inimeste imetlust rohkem kui Jumala heakskiitu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jeesus hüüdis: „Kui te usute minusse, siis ei usu te ainult minusse, vaid ka temasse, kes mu läkitas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kui te näete mind, näete teda, kes mu läkitas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ma olen tulnud nagu valgus, mis paistab maailmas, nii et kui usute minusse, ei jää te pimedusse. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ma ei mõista kohut kellegi üle, kes kuuleb mu sõnu, kuid ei tee nende järgi. Ma tulin maailma päästma, mitte selle üle kohut mõistma. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kes mu tagasi lükkab ja kes ei võta mu sõnu vastu, selle üle mõistetakse kohut lõpuaja kohtus vastavalt sellele, mida ma olen öelnud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Sest ma ei räägi enda nimel, vaid Isa nimel, kes mu läkitas. Tema on see, kes õpetab mind, mida ja kuidas öelda. ");
INSERT INTO ekkpkp_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ma tean, et see, mida tema käsib mul öelda, toob igavese elu; nii et kõik, mida ma räägin, on see, mida Isa mind käsib.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Oli päev enne paasapüha; Jeesus teadis, et oli tulnud aeg lahkuda siit maailmast ja minna oma Isa juurde. Ta oli armastanud maailmas neid, kes olid tema omad, ning nüüd ilmutas ta täielikku armastust nende vastu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Oli õhtusöögi aeg ja kurat oli juba pannud Juuda, Siimon Iskarioti poja pähe mõtte Jeesus ära anda. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jeesus teadis, et Isa oli andnud kõik tema võimusesse ja et ta oli tulnud Jumala juurest ja pidi Jumala juurde tagasi minema. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Niisiis tõusis Jeesus õhtusööki söömast üles, võttis ära oma kuue ja pani endale rätiku ümber vöö. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ta valas vett kaussi, hakkas pesema oma jüngrite jalgu ja kuivatas neid enda ümber mähitud rätikuga. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ta tuli Siimon Peetruse juurde, kes küsis talt: „Issand, kas sa kavatsed mu jalgu pesta?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jeesus vastas: „Praegu ei saa sa aru, mida ma sinu heaks teen, aga ühel päeval sa mõistad.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","„Ei!“ protestis Peetrus. „Sa ei pese iial mu jalgu!“ Jeesus kostis: „Kui ma sind ei pese, ei ole sul osa minuga.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","„Issand, siis pese ka mu käsi ja pead, mitte ainult jalgu!“ hüüatas Siimon Peetrus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jeesus vastas: „Neil, kes on end pesnud, on vaja ainult jalgu pesta ja siis on nad üleni puhtad. Te olete puhtad, aga mitte kõik teist.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Sest ta teadis, kes ta ära annab. Sellepärast ta ütleski: „Kõik teist ei ole puhtad.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pärast seda kui Jeesus oli nende jalad pesnud, pani ta uuesti kuue selga ja istus maha. „Kas te saate aru, mida ma teile tegin?“ küsis ta neilt. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","„Te nimetate mind õpetajaks ja Issandaks ning teete õigesti, sest see ma olen. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kui nüüd mina, teie Õpetaja ja Issand, pesin teie jalgu, peaksite teiegi üksteise jalgu pesema. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Olen näidanud teile eeskuju, nii et te peaksite tegema sama mida mina. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ma räägin teile tõtt: teenijad ei ole tähtsamad kui nende isand ja läkitatu ei ole suurem kui läkitaja. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nüüd, mil te seda mõistate, olete õnnistatud, kui te seda ka teete. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ma ei räägi teist kõigist; ma tean neid, kelle ma olen valinud. Aga see on selleks, et täituks Pühakiri: „See, kes jagab minuga toitu, on minu vastu pöördunud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ma räägin seda teile praegu, enne kui see toimub, nii et kui see toimub, oleksite te veendunud, et ma olen see, kes ma olen. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ma räägin teile tõtt: kes iganes võtab vastu selle, kelle ma läkitan, võtab vastu minu, ja kes iganes võtab vastu minu, võtab vastu selle, kes mu läkitas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Kui Jeesus seda oli öelnud, oli ta sügavalt mures ja teatas: „Ma räägin teile tõtt: üks teist annab mu ära.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jüngrid vaatasid üksteisele otsa ja nuputasid, kellest neist Jeesus räägib. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jünger, keda Jeesus armastas, istus lauas Jeesuse kõrval ja nõjatus tema lähedale. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Siimon Peetrus andis talle märku, et ta küsiks Jeesuselt, kellest ta räägib. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Siis ta kallutas end Jeesuse poole ja küsis: „Issand, kes see on?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jeesus vastas: „See on tema, kellele ma annan sissekastetud leivatüki.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pärast leivatüki sissekastmist andis ta selle Juudale, Siimon Iskarioti pojale. Kui Juudas võttis leiva vastu, sisenes temasse Saatan. „Tee kiiresti seda, mida sa teha kavatsed,“ ütles Jeesus talle. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mitte keegi lauas ei mõistnud, mida Jeesus sellega mõtles. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kuna Juudas vastutas raha eest, arvasid mõned, et Jeesus käskis tal minna ja osta midagi paasapühaks vajalikku või annetada midagi vaestele. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Juudas lahkus kohe pärast seda, kui oli leivatüki võtnud, ning läks välja öhe. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Pärast tema lahkumist ütles Jeesus: „Nüüd on inimese Poeg austatud ja tema kaudu on austatud Jumal. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kui Jumal on tema kaudu austatud, siis austab Jumal Poega ennast ja ta austab teda kohe. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mu lapsed, olen teiega ainult veidi aega veel. Te otsite mind, aga ma ütlen teile sama, mida ma ütlesin juutidele: te ei saa tulla sinna, kuhu mina lähen. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ma annan teile uue käsu: armastage üksteist. Armastage üksteist samamoodi, naga mina olen teid armastanud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kui te armastate üksteist, tõestate kõigile, et olete minu jüngrid.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Siimon Peetrus küsis talt: „Kuhu sa lähed, Issand?“ Jeesus vastas: „Praegu ei saa sa tulla sinna, kuhu ma lähen. Sa järgned mulle hiljem.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","„Issand, miks ma ei saa praegu sulle järgneda?“ küsis Peetrus. „Ma jätan oma elu sinu eest.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","„Kas sa tõesti oled valmis minu pärast surema? Ma räägin sulle tõtt: enne kui kukk kireb, salgad sa mind kolm korda,“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","„Ärge laske oma meeltel ärevil olla. Uskuge Jumalasse ja uskuge ka minusse. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Minu Isa majas on palju ruumi. Kui see nii ei oleks, siis oleksin teile öelnud. Ma lähen teile kohta ette valmistama. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kui ma olen läinud ja teile koha valmistanud, tulen ma tagasi ja võtan teid endaga kaasa, nii et ka teie saaksite seal koos minuga olla. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Te teate teed sinna, kuhu ma lähen.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toomas ütles talle: „Issand, me ei tea, kuhu sa lähed. Kuidas me saame teada teed?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jeesus vastas: „Mina olen tee ja tõde ja elu. Keegi ei tule Isa juurde muidu, kui ainult minu kaudu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kui te oleksite mind tundnud, tunneksite ka mu Isa. Nüüdsest peale te tunnete teda ja olete teda näinud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filippus ütles: „Issand, näita meile Isa, siis oleme kindlad.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jeesus vastas: „Filippus, ma olen nii kaua teie juures olnud ja te ei tunne mind ikka veel? Kes on näinud mind, on näinud Isa. Kuidas te saate öelda: „Näita meile Isa“? ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kas te ei usu, et ma elan Isas ja Isa elab minus? Sõnad, mis ma kõnelen, ei ole minu omad; Isa, kes minus elab, teeb oma tööd. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Uskuge mind, kui ma ütlen teile, et ma elan Isas ja Isa elab minus, või vähemalt uskuge kõigi mu tegude tõttu, mis seda tõendavad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ma räägin teile tõtt: kes usub minusse, teeb sama, mida teen mina. Õigupoolest teeb ta isegi suuremaid asju, sest mina lähen Isa juurde. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ma teen seda, mida iganes te minu nimel palute, et Isa saaks Poja kaudu austatud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mida iganes te minu nimel palute, seda ma teen. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kui te mind armastate, siis peate mu käske. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ma palun Isa ja ta saadab teile teise Lohutaja, ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","tõe Vaimu, kes on alati teie juures. Maailm ei saa teda vastu võtta, sest ta ei otsi teda ega tunne teda. Aga teie tunnete teda, sest ta elab teie juures ja on teie sees. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ma ei jäta teid maha nagu vaeslapsi: ma tulen teie juurde tagasi. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Peagi maailm ei näe mind enam, aga teie näete. Kuna mina elan, elate ka teie. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Sel päeval saate teada, et ma elan Isas, teie elate minus ja mina elan teis. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kes minu käske peavad, on need, kes mind armastavad; kes mind armastavad, neid armastab mu Isa. Ka mina armastan neid ja ilmutan end neile.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Juudas (mitte Iskariot) vastas: „Issand, miks sa ilmutad end meile ja mitte maailmale?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jeesus vastas: „Kes mind armastab, teeb nii, nagu ma ütlen. Minu Isa armastab neid ja me tuleme ja teeme tema juurde oma kodu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kes mind ei armasta, ei tee nii, nagu ma ütlen. Need sõnad ei ole minult, need on Isalt, kes mu läkitas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ma selgitan seda teile sel ajal, kui ma olen veel siin teie juures. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Aga kui isa saadab minu asemel Lohutaja, Püha Vaimu, siis ta õpetab teile kõike ja tuletab teile meelde kõik, mida ma teile rääkisin. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Rahu ma jätan teile; oma rahu annan ma teile. Rahu, mille mina teile annan, ei ole selline, nagu maailm annab. Ärge laske oma meeltel ärevil olla ja ärge kartke. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Te kuulsite, et ma ütlesin teile: „Ma lähen ära, aga ma tulen teie juurde tagasi.“ Kui te tõesti mind armastaksite, oleksite rõõmsad, et ma lähen Isa juurde, sest Isa on suurem kui mina. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Olen seda teile selgitanud praegu, enne kui see toimub, et kui see toimub, siis te usuksite kindlalt. ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ma ei saa teiega enam kauem rääkida, sest selle maailma vürst on tulemas. Tal ei ole võimu mind valitseda, ");
INSERT INTO ekkpkp_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","aga ma teen seda, mida mu Isa käskis mul teha, et maailm teaks, et ma armastan Isa. Tõuske nüüd, hakkame minema.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","„Mina olen tõeline viinapuu ja mu isa on aednik. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ta lõikab ära iga mu oksa, mis vilja ei kanna. Ta kärbib iga oksa, mis vilja kannab, et see saaks veel rohkem vilja kanda. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Teie olete juba kärbitud ja saanud puhtaks selle kaudu, mida ma olen teile rääkinud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Jääge minusse, ja mina jään teisse. Just nagu oks ei saa vilja kanda, kui ta on viinapuust lahus, samamoodi on teiega: te ei saa vilja kanda, kui te minusse ei jää. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Mina olen viinapuu, teie olete oksad. Kes jääb minusse ja mina temasse, see kannab külluslikult vilja, sest ilma minuta ei suuda te midagi teha. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kes ei jää minusse, on nagu oks, mis on välja visatud ja kuivab ära. Sellised oksad kogutakse kokku, visatakse tulle ja põletatakse ära. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kui te jääte minusse ja minu sõnad jäävad teisse, siis paluge, mida iganes tahate, ja see antakse teile. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Minu Isa on austatud, kui te kannate külluslikult vilja ja tõestate sellega, et olete minu jüngrid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ma olen teid armastanud samamoodi, nagu Isa armastab mind. Jääge minu armastusse. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kui te teete, mida ma ütlen, siis jääte minu armastusse, just nagu mina teen seda, mida mu Isa ütleb, ja jään tema armastusse. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Olen seda teile selgitanud, et minu rõõm võiks olla teis ja teie rõõm võiks olla täielik. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","See on minu käsk: armastage üksteist nii, nagu mina olen armastanud teid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ei ole suuremat armastust kui anda elu oma sõprade eest. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Teie olete minu sõbrad, kui teete seda, mida ma teid käsin. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ma ei nimeta teid enam sulasteks, sest sulased ei ole oma isanda saladustesse pühendatud. Ma nimetan teid sõpradeks, sest olen selgitanud teile kõike, mida Isa mulle on öelnud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Teie ei valinud mind, vaid mina valisin teid. Olen andnud teile kohustuse minna ja kanda kestvat vilja. Nii annab Isa teile, mida iganes te minu nimel palute. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","See on minu käsk teile: armastage üksteist. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kui maailm teid vihkab, siis meenutage, et enne teid vihkas ta mind. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kui te oleksite selle maailma osa, siis armastaks maailm teid nagu omi. Aga te ei ole selle maailma osa ja mina olen teid maailmast valinud − sellepärast maailm vihkab teid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pidage meeles, mida ma teile rääkisin: teenijad ei ole oma isandast tähtsamad. Kui nad kiusasid taga mind, kiusavad nad taga teidki. Kui nad oleksid teinud seda, mida mina käskisin, teeksid nad ka seda, mida teie neile ütlete. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Aga kõike seda teevad nad teile minu pärast, sest nad ei tunne seda, kes mu läkitas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kui ma ei oleks tulnud ja neile rääkinud, ei oleks nad patus süüdi, aga nüüd ei ole neil oma patule ettekäänet. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kes vihkab mind, see vihkab ka mu Isa. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kui ma ei oleks andnud neile selliseid tõendeid tegude kaudu, mida keegi ei olnud varem teinud, ei oleks nad patus süüdi, kuid vaatamata sellele, et nad nägid seda kõike, vihkasid nad mind ja mu Isa. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Aga just see täidab Pühakirja sõnad: „Nad vihkasid mind täiesti põhjuseta.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Kuid ma saadan teile Isa juurest Lohutaja. Kui tema tuleb, toob ta minu kohta tunnistuse. Ta on tõe Vaim, kes tuleb Isa juurest. ");
INSERT INTO ekkpkp_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ka teie annate minust tunnistust, sest te olete algusest peale minu juures olnud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Olen seda teile rääkinud, et teie usk minusse ei kaoks. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Nad heidavad teid sünagoogidest välja; õigupoolest tuleb aeg, mil need, kes teid tapavad, arvavad, et teevad Jumalale teene. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nad teevad seda, sest nad ei ole kunagi tundnud Isa ega mind. Olen teile seda rääkinud, et kui see toimub, tuleks teile meelde, mida ma teile rääkisin. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mul ei olnud vaja seda teile kohe alguses rääkida, sest siis jäin ma teie juurde. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Aga nüüd lähen ma tema juurde, kes mu läkitas, ja ometi ei küsi teist keegi: „Kuhu sa lähed?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Muidugi olete praegu, mil ma teile rääkisin, südamevaluga täidetud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Aga ma räägin teile tõtt: teile on parem, et ma lähen ära, sest kui ma ei läheks, ei tuleks teie juurde Lohutaja. Kui ma ära lähen, saadan ma tema teie juurde. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kui ta tuleb, veenab ta neid, kes on maailmas, et nad on valesti aru saanud patust, õigusest ja kohtust: ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","patust, et nad ei uskunud minusse; ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","õigusest, et ma lähen Isa juurde ja te ei näe mind enam; ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","kohtust, et selle maailma valitseja on juba surma mõistetud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","On veel palju, mida ma tahan teile selgitada, kuid te ei suuda seda praegu taluda. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Aga kui tõe Vaim tuleb, õpetab ta teile kogu tõde. Ta ei räägi iseenesest, vaid ta kõneleb ainult seda, mida kuuleb, ning räägib teile, mis hakkab toimuma. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ta toob au mulle, sest ta õpetab teile seda, mida minult saab. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kõik, mis kuulub Isale, on minu oma. Sellepärast ma ütlesin, et Vaim õpetab teile seda, mida minult saab. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Veidi aja pärast ei näe te mind enam, aga siis veidi aja pärast te näete mind.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Mõned tema jüngritest ütlesid üksteisele: „Mida ta mõtleb sellega: „Veidi aja pärast ei näe te mind enam, aga siis veidi aja pärast te näete mind“ ja „Sest ma lähen Isa juurde“?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nad küsisid: „Mida ta mõtleb selle „veidi aja pärast“ all? Me ei tea, millest ta räägib.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jeesus sai aru, et nad tahtsid temalt selle kohta küsida. Niisiis küsis ta neilt: „Kas te ei saa aru minu ütlusest: „Veidi aja pärast ei näe te mind enam, aga siis veidi aja pärast te näete mind“? ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ma räägin teile tõtt: te nutate ja leinate, aga maailm rõõmustab. Te kurvastate, aga teie kurvastus muutub rõõmuks. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Sünnitav naine kannatab valu, sest tema aeg on tulnud, aga kui laps on sündinud, unustab ta valu rõõmu tõttu, et laps on maailma sündinud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jah, praegu te kurvastate, aga ma näen teid jälle; siis te rõõmustate ja keegi ei võta teie rõõmu ära. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Kui see aeg kätte jõuab, ei ole teil vaja minult midagi küsida. Ma räägin teile tõtt: Isa annab teile, mida iganes te minu nimel palute. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Seni ei ole te midagi minu nimel palunud, nii et paluge, ja te saate, ja teie õnn on täielik. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Olen rääkinud teile piltlikku keelt kasutades. Aga varsti ei kasuta ma enam teiega rääkides sellist piltlikku keelt. Selle asemel selgitan teile Isa väga lihtsalt. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Siis te palute minu nimel. Ma ei ütle, et ma palun Isa juures teie eest, ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","sest Isa ise armastab teid, sest te armastate mind ja usute, et ma tulin Jumala juurest. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ma lahkusin Isa juurest ja tulin maailma; nüüd lahkun ma maailmast ja lähen tagasi oma Isa juurde.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Siis ütlesid jüngrid: „Nüüd räägid sa väga lihtsalt ega kasuta piltlikku keelt. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nüüd oleme kindlad, et sina tead kõike, ja et sa ei pea inimestelt küsima, et teada saada, millele nad mõtlevad. See veenab meid, et sa tulid Jumala juurest.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","„Kas te olete nüüd tõesti veendunud?“ küsis Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","„Tuleb aeg − õigupoolest on see kohe käes −, kui teid pillutatakse laiali, igaüks oma koju, ja te kõik jätate mu üksi. Aga ma ei ole tegelikult üksinda, sest Isa on minuga. ");
INSERT INTO ekkpkp_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Olen rääkinud teile kõike seda, et teil võiks olla rahu, sest te olete üks minuga. Selles maailmas on teil kannatusi, aga olge julged − mina olen maailma võitnud!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kui Jeesus need sõnad oli öelnud, vaatas ta üles taeva poole ja ütles: „Isa, aeg on käes. Austa oma Poega, et Poeg võiks austada sind. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Sest sina andsid talle mõjuvõimu kõigi inimeste üle, et ta võiks anda igavese elu kõigile neile, kelle sa oled temale andnud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Igavene elu on see: tunda sind, ainsat tõelist Jumalat, ja Jeesust Kristust, kelle sa läkitasid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Olen austanud sind siin maa peal ja lõpetanud töö, mille sa andsid mulle teha. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nüüd, Isa, austa mind oma ligiolus auga, mis mul oli sinu juures enne maailma algust. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ma olen ilmutanud sinu iseloomu neile, kelle sa mulle maailmast andsid. Nad kuulusid sulle; sina andsid nad mulle, ja nad on teinud, mida sa ütlesid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nüüd nad teavad, et kõik, mille sa oled mulle andnud, on sinult pärit. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Olen andnud neile sõnumi, mille sina mulle andsid. Nad võtsid selle vastu, nad veendusid täielikult, et ma olen sinu juurest tulnud, ning nad usuvad, et sina läkitasid mu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ma palvetan nende pärast; mitte maailma pärast, vaid nende pärast, kelle sa mulle andsid, sest nad on sinu omad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kõik, kes kuuluvad mulle, on sinu omad, ja need, kes kuuluvad sulle, on minu omad, ning ma olen nende kaudu austatud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ma lahkun maailmast, kuid nemad jäävad maailma; ma tulen sinu juurde. Püha Isa, kaitse neid enda nimel, mille sa mulle andsid, et nad võiksid olla üks, nagu meie oleme üks. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Sel ajal, kui ma olin nende juures, kaitsesin ma neid sinu nimel, mille sa mulle andsid. Ma valvasin nende üle, nii et ükski neist ei läinud kaotsi, välja arvatud hukule määratu, nii et Pühakiri läks täide. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nüüd ma tulen sinu juurde; ma räägin seda kõike ajal, mil olen veel siin maailmas, et nad võiksid täielikult minu rõõmust osa saada. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ma andsin neile sinu sõnumi ja maailm vihkab neid sellepärast, et nad ei ole maailmast, nagu minagi ei ole maailmast. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ma ei palu, et sa võtaksid nad maailmast ära, vaid et sa kaitseksid neid kurja eest. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nad ei ole maailmast, nagu minagi ei ole maailmast. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pühitse neid tões − sinu sõna on tõde. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Samamoodi nagu sina läkitasid mu maailma, läkitan mina nemad maailma. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ma pühitsen end nende eest, et ka nemad võiksid olla tõeliselt pühad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ma ei palveta üksnes nende eest, vaid ma palun ka nende eest, kes nende kuulutuse tõttu minusse usuvad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ma palun, et nad kõik võiksid olla üks, just nagu sina, Isa, elad minus, ja mina elan sinus, et ka nemad võiksid meis elada, nii et maailma usuks, et sina läkitasid mu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Olen andnud neile au, mille sa andsid mulle, et nad võiksid olla üks, nagu meie oleme üks. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mina elan neis ja sina elad minus. Et nad võiksid olla täielikult üks, nii et kogu maailm teaks, et sina läkitasid mu, ja et sa armastad neid, nagu sa armastad mind. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Isa, ma tahan, et need, kelle sa oled mulle andnud, oleksid koos minuga seal, kus olen mina, et nad näeksid au, mille sa oled mulle andnud, sest sa armastasid mind enne maailma loomist. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Hea Isa, maailm ei tunne sind, aga mina tunnen sind, ja nemad siin minu juures teavad, et sina mu läkitasid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ma olen ilmutanud neile sinu iseloomu ja näitan seda jätkuvalt, et armastus, mis sul on minu vastu, oleks neis, ja mina elaksin neis.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Pärast seda kui Jeesus oli kõnelemise lõpetanud, läks ta koos jüngritega üle Kidroni oja oliivisallu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Äraandja Juudas teadis seda paika, sest Jeesus oli oma jüngritega seal sageli käinud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Juudas võttis siis endaga kaasa sõduritesalga koos ülempreestrite ja variseride valvuritega. Nad tulid sinna tõrvikute, laternate ja relvadega. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jeesus teadis kõike, mis pidi temaga toimuma. Ta läks neile vastu ja küsis: „Keda te otsite?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","„Kas sa oled Naatsareti Jeesus?“ küsisid nad. „Ma olen,“ vastas Jeesus neile. Äraandja Juudas seisis nende hulgas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kui Jeesus ütles: „Ma olen“, taganesid nad ja kukkusid maha. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Siis küsis ta neilt uuesti: „Keda te otsite?“ „Kas sa oled Naatsareti Jeesus?“ küsisid nad taas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","„Ma juba ütlesin teile, et ma olen,“ vastas Jeesus. „Kui nüüd mina olen see, keda te otsite, siis laske neil teistel minna.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nende sõnadega täitus see, mida ta oli varem öelnud: „Ma ei ole kaotanud kedagi neist, kelle sa mulle andsid.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Siis tõmbas Siimon Peetrus mõõga, lõi ülempreestri sulast Malkust ja lõikas tema parema kõrva maha. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jeesus ütles Peetrusele: „Pane mõõk ära! Kas sa arvad, et ma ei peaks jooma karikast, mille Isa on mulle andnud?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Seejärel võtsid sõdurid, nende pealik ja juutide valvurid Jeesuse kinni ja sidusid ta käed. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kõigepealt viisid nad ta Annase juurde, kes oli tollase ülempreestri Kaifase äi. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaifas oli see, kes oli juutidele öelnud: „Parem on ühel inimesel rahva eest surra.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Siimon Peetrus järgnes Jeesusele, ja ka teine jünger tegi sama. See jünger oli ülempreestri juures tuttav ja nii sisenes ta koos Jeesusega ülempreestri hoovi. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peetrus pidi jääma välja ukse juurde. Teine jünger, kes oli ülempreestri juures tuttav, läks ja rääkis ust valvava teenijatüdrukuga ja tõi Peetruse sisse. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tüdruk küsis Peetruselt: „Kas sa ei ole mitte üks selle mehe jüngritest?“ „Mina? Ei, ei ole,“ vastas ta. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Oli jahe ning teenijad ja valvurid seisid end soojendades tule juures, mille nad olid teinud. Peetrus läks ja seisis nende juurde end soojendama. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Siis küsis ülempreester Jeesuselt tema jüngrite ja selle kohta, mida ta õpetab. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","„Ma olen avalikult kõigile rääkinud,“ vastas Jeesus. „Olen alati õpetanud sünagoogides ja templis, kus kõik juudid koos käivad. Ma ei ole midagi salajas rääkinud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Miks sa siis mind küsitled? Küsi inimestelt, kes on kuulnud, mida ma neile olen rääkinud. Nad teavad, mida ma olen öelnud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kui ta seda ütles, lõi üks lähedal seisvatest valvuritest Jeesust ja ütles: „Kas nii räägitakse ülempreestriga?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jeesus vastas: „Kui ma midagi valesti ütlesin, räägi kõigile, mis valesti oli. Aga kui ma õigust rääkisin, miks sa siis mind lõid?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Annas saatis endiselt kinniseotud kätega Jeesuse ülempreester Kaifase juurde. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Siis kui Siimon Peetrus seisis end soojendades tule juures, küsisid inimesed seal tema käest: „Kas sa ei ole mitte üks tema jüngritest?“ Peetrus salgas seda ja ütles: „Ei, ma ei ole.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Üks ülempreestri sulastest, see, kelle sugulasel oli Peetrus kõrva maha lõiganud, küsis Peetruselt: „Kas ma ei näinud sind koos temaga oliivisalus?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peetrus salgas seda jälle, ja kohe kires kukk. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Varahommikul viidi Jeesus Kaifase juurest Rooma maavalitseja paleesse. Juudi juhid ei sisenenud paleesse, sest kui nad oleksid seda teinud, oleksid nad tseremoniaalselt ebapuhtaks saanud, aga nad tahtsid paasasöömaaega süüa. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Niisiis tuli Pilaatus välja nendega kohtuma. „Mis süüdistuse te selle mehe vastu esitate?“ küsis ta. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","„Kui ta ei oleks kurjategija, ei oleks me teda sinu juurde toonud,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","„Siis võtke ta ja mõistke tema üle kohut oma seaduse alusel,“ ütles Pilaatus neile. „Meil ei ole luba kedagi hukata,“ vastasid juudid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nii täitus see, mida Jeesus oli oma suremise kohta öelnud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilaatus läks tagasi maavalitseja paleesse. Ta kutsus Jeesuse ja küsis temalt: „Kas sina oled juutide kuningas?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","„Kas sa tulid selle küsimuse peale ise või rääkisid sulle minust teised?“ vastas Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","„Kas ma olen juut?“ küsis Pilaatus vastu. „Su oma rahvas ja ülempreestrid andsid su minu kätte. Mida sa teinud oled?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jeesus vastas: „Minu kuningriik ei ole sellest maailmas. Kui see oleks sellest maailmast, siis mu alamad võitleksid selle eest, et mind ei antaks juutide kätte. Aga mu kuningriik ei ole siit.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Siis küsis Pilaatus: „Nii et sa ikkagi oled kuningas?“ „Sina ütled, et ma olen kuningas,“ vastas Jeesus. „Ma sündisin ja tulin maailma, et anda tunnistust tõest. Kõik, kes võtavad tõe vastu, panevad tähele, mida ma ütlen.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","„Mis on tõde?“ küsis Pilaatus. Seda öelnud, läks Pilaatus tagasi välja juutide juurde ja ütles neile: „Ma ei mõista teda süüdi üheski kuriteos. ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Aga mul on kombeks teile paasapühadeks üks vang vabaks lasta. Kas lasen juutide kuninga vabaks?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","„Ei, mitte teda! Me tahame hoopis Barabast!“ karjusid nad vastu. Barabas oli mässaja. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Siis Pilaatus võttis Jeesuse ja lasi teda piitsutada. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sõdurid tegid okaspõõsast krooni ja panid selle talle pähe ning asetasid talle õlgadele purpurrüü. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ikka ja jälle läksid nad tema juurde ja ütlesid: „Ole tervitatud, juutide kuningas!“ ja lõid talle vastu nägu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilaatus läks veel kord välja ja ütles neile: „Ma toon ta siia välja teie juurde, et te teaks, et ma ei mõista teda süüdi üheski kuriteos.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Siis Jeesus tuli välja, okaskroon peas ja purpurrüü üll. „Vaadake, siin on see inimene,“ ütles Pilaatus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kui ülempreestrid ja valvurid nägid Jeesust, karjusid nad: „Löö ta risti! Löö ta risti!“ „Võtke teie ja lööge ta risti,“ vastas Pilaatus. „Mina ei mõista teda süüdi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Juudi juhid vastasid: „Meil on seadus ja selle seaduse järgi peab ta surema, sest ta on väitnud, et on Jumala Poeg.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kui Pilaatus seda kuulis, kartis ta veel rohkem kui enne ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ja läks tagasi maavalitseja paleesse. Ta küsis Jeesuselt: „Kust sa pärit oled?“ Aga Jeesus ei vastanud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","„Kas sa keeldud minuga rääkimast?“ küsis Pilaatus talt. „Kas sa ei saa aru, et mul on võim sind vabaks lasta või risti lüüa?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","„Sul ei oleks minu üle mingit võimu, kui seda ei oleks sulle antud ülalt,“ vastas Jeesus. „Seepärast on see, kes mu sinu kätte andis, suuremas patus süüdi.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kui Pilaatus seda kuulis, üritas ta Jeesust vabaks lasta, kuid juudi juhid karjusid: „Kui sa selle mehe vabaks lased, ei ole sa keisri sõber. Kes laseb vabaks end kuningaks tõstva inimese, see mässab keisri vastu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kui Pilaatus seda kuulis, tõi ta Jeesuse välja ja istus kohtunikutoolile kohas, mida nimetatakse Kivisillutiseks (heebrea keeles Gabbata). ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Oli umbes paasapühale eelneva valmistuspäeva keskpäev. „Vaadake, siin on teie kuningas,“ ütles ta juutidele. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","„Hukka ära! Hukka ära! Löö ta risti!“ karjusid nad. „Kas tahate, et löön teie kuninga risti?“ küsis Pilaatus. „Meie ainus kuningas on keiser,“ vastasid ülempreestrid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Nii andis ta Jeesuse nende kätte, et ta risti lüüa. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nad viisid ära Jeesuse, kes kandis ise oma risti, ja läksid välja paika, mida nimetatakse Pealuuks (heebrea keeles Kolgata). ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nad lõid ta seal risti, ja veel kaks meest koos temaga, ühe kummalegi poole, nii et Jeesus jäi nende vahele. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilaatus oli teinud sildi ja pani selle risti külge. Sellele oli kirjutatud: „Naatsareti Jeesus, juutide kuningas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Paljud lugesid seda silt, sest koht, kus Jeesus risti löödi, asus linna lähedal, ning silt oli kirjutatud heebrea, ladina ja kreeka keeles. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Siis tulid ülempreestrid Pilaatuse juurde ja palusid teda: „Ära kirjuta „juutide kuningas“, vaid „see mees ütles, et on juutide kuningas“.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilaatus vastas: „Kirjutasin seda, mida kirjutasin.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kui sõdurid olid Jeesuse risti löönud, võtsid nad tema riided ja jagasid neljaks, et iga sõdur saaks oma osa. Seal oli ka tema kuub, mis oli ühest tükist kootud, ilma õmblusteta. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Seepärast ütlesid nad üksteisele: „Ärme rebi seda katki, vaid otsustame täringut heites, kes selle endale saab.“ Nii täitus see, mis on Pühakirjas öeldud: „Nad jaotavad mu rõivad omavahel ja veeretavad täringut mu kehakatte pärast.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Seda need sõdurid tegidki. Risti lähedal olid Jeesuse ema ja tema ema õde, Kloopase naine Maarja ja Maarja Magdaleena. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kui Jeesus nägi oma ema ja tema kõrval jüngrit, keda ta armastas, ütles ta emale: „Naine, see on sinu poeg.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Seejärel ütles ta jüngrile: „See on sinu ema.“ Sellest ajast peale võttis jünger ta enda juurde. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jeesus mõistis nüüd, et ta oli lõpetanud kõik, mida ta oli tegema tulnud. Et täituks Pühakiri, ütles ta: „Mul on janu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Seal seisis üks kruus veiniäädikaga; nad kastsid käsna äädikasse, panid selle iisopivarre otsa ja hoidsid seda tema huulte vastas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kui Jeesus oli äädikat võtnud, ütles ta: „See on lõpetatud!“ Siis langetas ta pea ja tegi viimase hingetõmbe. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Oli valmistuspäev, ja juudi juhid ei tahtnud ristilööduid jätta hingamispäevaks (õigupoolest oli see eriline hingamispäev) ristile, seepärast palusid nad Pilaatusel murda neil jalad, et nad saaks alla võtta. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Siis tulid sõdurid ning murdsid kahe koos Jeesusega ristilöödud mehe jalad, ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","aga kui nad tulid Jeesuse juurde, nägid nad, et ta oli juba surnud, seega ei murdnud nad tema jalgu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kuid üks sõduritest torkas talle külje sisse oda ja välja voolas veega segunenud veri. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Sellest tunnistas see, kes seda nägi, ning tema tunnistus on tõsi. Ta on kindel, et see, mida ta nägi, on tõsi, nii et ka teie võiksite seda uskuda. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nii toimus, et läheks täide see, mis on Pühakirjas kirjutatud: „Ühtki tema luud ei murta,“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ja nagu teises kohas on öeldud: „Nad näevad seda, kelle nad läbi torkasid.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pärast seda küsis Arimaatia Joosep Pilaatuselt, kas ta võib Jeesuse surnukeha alla võtta, ning Pilaatus andis talle loa. Joosep oli Jeesuse jünger, kuid salajas, sest ta kartis juute. Niisiis tuli Joosep ja viis surnukeha ära. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Temaga koos oli Nikodeemos, mees, kes oli esmalt käinud Jeesuse juures öösel. Ta tõi kaasa umbes kolmkümmend kilo mürri ja aaloe segu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nad võtsid Jeesuse surnukeha ja mähkisid selle koos vürtside seguga linasesse riidesse, vastavalt juutide matmiskommetele. Selle paiga lähedal, kus Jeesus risti löödi, oli üks aed, ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ja aias oli uus, kasutamata hauakoobas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kuna oli juutide valmistuspäev ja hauakoobas oli lähedal, panid nad Jeesuse sinna puhkama. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nädala esimese päeva varahommikul, kui oli veel pime, läks Maarja Magdaleena hauakoopa juurde ja nägi, et kivi oli sissepääsu eest ära liigutatud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Jooksuga läks ta, et öelda Siimon Peetrusele ja teisele jüngrile, keda Jeesus armastas: „Issand on hauast ära viidud ja me ei tea, kuhu ta pandud on.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Siis läksid Peetrus ja teine jünger haua juurde. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nad jooksid koos, aga teine jünger jooksis kiiremini ja jõudis haua juurde esimesena. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ta kummardus alla ja sisse vaadates nägi ta matmisriideid seal olevat, kuid ta ei läinud sisse. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Siis jõudis pärast teda kohale Siimon Peetrus ja läks kohe hauakambrisse sisse. Ta nägi seal matmislinasid ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ja seda, et riiet, mis oli olnud Jeesuse pea peal, ei olnud teiste matmislinade juures, vaid see oli kokku volditud ja eraldi asetatud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Seejärel läks hauakoopasse sisse ka teine jünger, kes oli haua juurde esimesena jõudnud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ta vaatas ringi ja uskus, et see on tõsi − sest seni ei olnud nad mõistnud Pühakirja, et Jeesus pidi surnuist üles tõusma. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Siis läksid jüngrid tagasi sinna, kus nad peatusid. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kuid Maarja jäi haua juurde nutma, ja kui ta seal nuttis, kummardus ta ja vaatas hauakoopasse sisse. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ta nägi kaht valgesse riietatud inglit, üks istumas peatsis ja teine jalutsis, seal, kus Jeesuse surnukeha oli lebanud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","„Miks sa nutad?“ küsisid nad talt. Ta vastas: „Sellepärast et mu Issand on ära viidud ja ma ei tea, kuhu ta pandud on.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kui ta seda oli öelnud, pöördus ta ja nägi Jeesust seal seismas, kuid ta ei tundud ära, et see on Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","„Miks sa nutad?“ küsis ta naiselt. „Keda sa otsid?“ Arvates, et see on aednik, ütles Maarja talle: „Isand, kui sina viisid ta ära, ütle mulle, kuhu sa ta panid, et saaksin minna ja ta ära tuua.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jeesus ütles talle: „Maarja!“ Ta pöördus Jeesuse poole ja ütles: „Rabbuuni,“ mis tähendab heebrea keeles „õpetaja“. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","„Ära hoia mind kinni,“ ütles Jeesus talle, „sest ma pole veel läinud üles oma Isa juurde. Aga mine mu vendade juurde ja ütle neile, et ma lähen üles oma Isa ja teie Isa, oma Jumala ja teie Jumala juurde.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maarja Magdaleena läks siis ja rääkis jüngritele: „Ma nägin Issandat,“ ja ta selgitas neile, mida Issand oli talle öelnud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Samal õhtul, nädala esimesel päeval, kui jüngrid olid koos lukustatud uste taga, sest nad kartsid juute, tuli Jeesus, seisis nende keskel ja ütles: „Rahu olgu teile!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pärast seda tervitust näitas ta neile oma käsi ja külge. Issandat nähes täitis jüngreid rõõm. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","„Rahu olgu teile!“ ütles Jeesus neile uuesti. „Samamoodi nagu Isa minu läkitas, läkitan mina teid.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Seda öelnud, puhus ta nende peale ja lausus: „Võtke vastu Püha Vaim. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kui te andestate kellegi patud, siis on need andeks antud; kui te neid andeks ei anna, jäävad need andeks andmata.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Üks kaheteistkümnest jüngrist, Toomas, keda hüüti Kaksikuks, ei olnud nendega koos, kui Jeesus tuli. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Teised jüngrid rääkisid siis talle: „Me nägime Issandat.“ Aga tema vastas: „Ma ei usu, kui ma ei näe naelajälgi tema kätes ega pane oma sõrme neisse ega katsu oma käega tema külge.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nädala pärast olid jüngrid majas koos ja Toomas oli ka nendega. Uksed olid suletud, ja Jeesus tuli ja seisis nende keskel. „Rahu olgu teile!“ ütles ta. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Siis ütles ta Toomasele: „Pane oma sõrm siia ja vaata mu käsi. Pane oma käsi mu külje haava sisse. Ära kahtle, vaid usu minusse!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","„Minu Issand ja minu Jumal!“ vastas Toomas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","„Sa usud minusse, sest nägid mind,“ ütles Jeesus talle. „Õnnelikud on need, kes ei ole mind näinud, kuid siiski usuvad minusse.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jeesus tegi oma jüngritega olles veel palju tunnustähti, mida ei ole selles raamatus kirjas. ");
INSERT INTO ekkpkp_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kuid need on siia kirja pandud, et te võiksite uskuda, et Jeesus on Messias, Jumala Poeg, ja et uskudes temasse nagu ta on, oleks teil elu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Hiljem ilmus Jeesus jüngritele veel Galilea järve ääres. See juhtus nõnda. ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Siimon Peetrus, Kaksik Toomas, Galilea Kaanast pärit Naatanael, Sebedeuse pojad ja veel kaks jüngrit olid koos. ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","„Ma lähen kalale,“ ütles Siimon Peetrus neile. „Me tuleme sinuga kaasa,“ vastasid nad. Nii läksid nad välja paati, kuid kogu öö ei püüdnud nad midagi. ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kui koidik saabus, seisis kaldal Jeesus, kuid jüngrid ei teadnud, et see on tema. ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jeesus hüüdis neile: „Sõbrad, kas olete midagi püüdnud?“ „Ei,“ vastasid nad. ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","„Heitke võrk välja paadist paremale ja te leiate kala,“ ütles ta neile. Nõnda nad heitsid võrgu välja ega suutnud seda vedada, sest selles oli nii palju kalu. ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jünger, keda Jeesus armastas, ütles Peetrusele: „See on Issand.“ Kui Peetrus kuulis, et see on Issand, pani ta mõned riided selga, kuna ta oli alasti, ja hüppas järve. ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Teised jüngrid järgnesid paadis, vedades kalu täis võrku, sest nad ei olnud kaldast kaugel, ainult umbes sada meetrit. ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kui nad randusid, nägid nad tuld, mille peal küpses kala, ja leiba. ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jeesus ütles neile: „Tooge mõni kala, mille te just püüdsite.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Siimon Peetrus läks paati ja tõmbas kalu täis võrgu kaldale. Seal oli 153 suurt kala, kuid võrk ei olnud siiski rebenenud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","„Tulge ja sööge hommikusööki,“ ütles Jeesus neile. Keegi jüngritest ei julgenud talt küsida: „Kes sa oled?“ Nad teadsid, et see on Issand. ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jeesus võttis leiva ja andis selle neile ja ka kala. ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","See oli kolmas kord, mil Jeesus oli pärast surnuist ülesäratamist jüngritele ilmunud. ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pärast hommikusööki küsis Jeesus Siimon Peetruselt: „Siimon, Johannese poeg, kas sa armastad mind rohkem kui neid?“ „Jah, Issand,“ vastas ta, „sa tead, et ma armastan sind.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","„Hoolitse mu tallede eest,“ ütles Jeesus talle. „Siimon, Johannese poeg, kas sa armastad mind?“ küsis ta teist korda. „Jah, Issand,“ vastas ta, „sa tead, et ma armastan sind.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","„Kanna hoolt mu lammaste eest,“ ütles Jeesus talle. „Siimon, Johannese poeg, kas sa armastad mind?“ küsis ta kolmandat korda. Peetrus kurvastas, et Jeesus küsis talt kolmandat korda, kas ta armastab teda. „Issand, sina tead kõike. Sa tead, et ma armastan sind,“ vastas Peetrus talle. „Hoolitse mu lammaste eest,“ ütles Jeesus. ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","„Ma räägin sulle tõtt,“ ütles Jeesus, „kui sa olid noor, riietasid sa end ise ja läksid sinna, kuhu tahtsid. Aga kui oled vana, sirutad sa käed ja keegi teine riietab sind, ning viib sind sinna, kuhu sa ei taha minna.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jeesus ütles seda, et selgitada, missuguse surmaga pidi ta Jumalat austama. Siis ütles ta Peetrusele: „Järgne mulle.“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Kui Peetrus ümber pööras, nägi ta neile järgnemas jüngrit, keda Jeesus armastas, seda, kes oli õhtusöögi ajal end Jeesuse poole kallutanud ja küsinud: „Issand, kes su ära annab?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peetrus küsis Jeesuselt: „Aga mis temast saab, Issand?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jeesus ütles talle: „Kui ma tahan, et ta jääks siia elama kuni mu tagasitulekuni, miks on see sinu mure? Sina järgne mulle!“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Sellepärast levis usklike hulgas ütlus, et see jünger ei sure. Aga Jeesus ei öelnud talle, et ta ei sure, vaid lihtsalt: „Kui ma tahan, et ta jääks siia elama kuni mu tagasitulekuni, miks on see sinu mure?“ ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","See jünger kinnitab juhtunut ja kirjutas selle kõik üles. Me teame, et tema sõnad on õiged. ");
INSERT INTO ekkpkp_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jeesus tegi veel palju asju, ja kui kõik see üles kirjutada, siis ma kahtlen, kas kogu maailm mahutaks ära kõik raamatud, mis tuleks kirjutada.");
INSERT INTO ekkpkp_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","See kiri on Pauluselt, Jeesuse Kristuse sulaselt. Mind kutsus apostliks Jumal. Jumal määras mind kuulutama head sõnumit, ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","mida ta eelnevalt on? Pühakirjas oma prohvetite kaudu tõotanud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Hea sõnum on tema Pojast, kelle inimesest esiisa oli Taavet, ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","kuid kes sai avalikuks kui Jumala Poeg, kui ta Püha Vaimu väel surnuist üles tõusis. Tema on Jeesus Kristus, meie Issand. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Tema kaudu sain eesõiguse olla apostel, et kutsuda kõiki rahvaid kuulekalt temasse uskuma. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ka teie olete nende hulgas, keda kutsuti Jeesusele Kristusele kuuluma. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ma kirjutan teile kõigile, kes olete Roomas, keda Jumal armastab ja keda ta on oma eriliseks rahvaks kutsunud. Armu ja rahu teile Jumalalt, meie Isalt, ja Issandalt Jeesuselt Kristuselt! ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Lubage, et ma kõigepealt tänan oma Jumalat Jeesuse Kristuse kaudu teie kõigi eest, sest sellest, kuidas te Jumalasse usute, räägitakse kogu maailmas. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Ma palvetan alati teie eest, nagu võib kinnitada Jumal − see Jumal, keda ma teenin kogu oma olemusega, kui jagan head sõnumit tema Pojast. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Oma palvetes palun ma alati, et võiksin lõpuks tulla ja teiega kohtuda, kui Jumal seda tahab. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ma tõesti tahan teid külastada ja jagada teiega vaimulikku õnnistust teie kinnitamiseks. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Nii saame koos julgustust üksteise usust Jumalasse, nii teie usust kui ka minu omast. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Mu vennad ja õed, ma tahan, et te teaksite, et olen sageli teinud plaane teie külastamiseks, kuid mind ei ole seni lastud tulla. Ma tahan näha teie keskel häid vaimulikke tulemusi, nagu ma olen näinud teiste inimeste hulgas. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Sest mul on kohustus töötada nii tsiviliseeritute kui ka tsiviliseerimatute, nii haritute kui ka harimatute heaks. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Sellepärast soovin ma tõesti innukalt tulla Roomasse ja jagada teiega head sõnumit. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Kindlasti ei häbene ma head sõnumit, sest see on Jumala vägi päästa igaüht, kes temasse usub − kõigepealt juute ja siis ka kõiki teisi. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Sest hea sõnum näitab Jumalat kui head ja õiget, usaldusväärset algusest lõpuni. Nagu Pühakiri ütleb: „Kes on õiged Jumala ees, elavad teda uskudes.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Jumala vastumeelsust ilmutatakse taevast nende vastu, kes on jumalatud ja kes ei ole moraalselt õiged, nende vastu, kes summutavad tõde halvaga, mida nad teevad. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","See, mida on võimalik Jumala kohta teada, on ilmne, sest ta on selle neile väga selgeks teinud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Juba alates maailma loomisest on Jumala nähtamatu olemus − tema igavene vägi ja jumalikkus − selgelt nähtav selles, mida ta on teinud. Sellistel inimestel ei ole vabandust, ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","sest kuigi nad tundsid Jumalat, ei kiitnud ega ülistanud nad teda, vaid selle asemel muutus nende arvamus Jumalast täielikuks rumaluseks ning nende tühja mõistust täitis pimedus. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Kuigi nad väitsid, et on targad, said nad rumalaks. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Nad vahetasid surematu Jumala hiilguse surelike inimeste, lindude, loomade ja roomajate kujutiste vastu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Niisiis jättis Jumal nad nende rikutud mõistuse kurjade soovide küüsi ja nad tegid üksteisele häbiväärseid, alandavaid asju. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Nad vahetasid Jumala tõe vale vastu ning kummardasid ja teenisid loodolevusi, mitte Loojat, kes on väärt kiitust igavesti. Aamen. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Sellepärast jättis Jumal nad nende kurjade soovide küüsi. Nende naised vahetasid loomupärase seksuaalsuse ebaloomuliku vastu, ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ning samamoodi loobusid mehed seksist naistega ja põlesid himust üksteise vastu. Mehed tegid üksteisega sündsusetuid asju ning selle tulemusena tabasid neid nende loomuvastasuse paratamatud tagajärjed. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Kuna nad ei pidanud väärtuslikuks Jumala tundmaõppimist, jättis ta neid nende väärtusetu, usaldamatu mõtteviisi küüsi, tegema seda, mida ei tohiks kunagi teha. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Nad täitsid end kõigega, mis on vale: kurjuse, ahnuse, vihkamise, kadeduse, mõrvamise, tülitsemise, petmise, kuritahtlikkuse ja tagarääkimisega. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Nad on tagaselja halvustavad ja Jumala vihkajad. Nad on ülbed, uhked ja hooplevad. Nad leiutavad uusi viise patustamiseks. Nad hakkavad oma vanematele vastu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Nad ei taha aru saada, nad ei pea lubadusi, nad ei ilmuta mingit lahkust ega kaastunnet. ");
INSERT INTO ekkpkp_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Kuigi nad mõistavad täpselt, mida Jumal nõuab, teevad nad seda, mis on surma väärt. Nad ei tee seda mitte ainult ise, vaid nad toetavad selles ka teisi. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Kui te mõistate teiste üle kohut, ei ole teil vabandust, ükskõik kes te olete! Sest nagu te mõistate teisi hukka, mõistate kohut ka teie enda üle, sest te teete samu asju. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Me teame, et Jumala kohtuotsus nende kohta, kes selliseid asju teevad, põhineb tõel. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Kui te nende üle kohut mõistate, kas arvate tõesti, et saate vältida Jumala kohut? ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Või suhtute tema imelisse headusse, sallivusse ja kannatlikkusse põlgusega ega mõista, et Jumal püüab oma headuses teid meeleparandusele juhtida? ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Oma kangekaelse suhtumisega ja meeleparandusest keeldudes teete asjad enda jaoks palju hullemaks õiglase tasu päeval, kui selgub, et Jumala kohtuotsus on täiesti õige. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Jumal hoolitseb selle eest, et igaüks saaks, mida ta on ära teeninud vastavalt sellele, mida ta on teinud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Need, kes on jätkuvalt püüdnud teha seda, mis on hea ja õige, saavad hiilguse ja au, surematuse ja igavese elu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Aga nende osaks, kes mõtlevad ainult iseendale, hülgavad tõe ja otsustavad sihilikult teha kurja, saab karistus ja raevukas vaenulikkus. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Igaüht, kes teeb kurja, tabavad häda ja kannatused − kõigepealt juute ja siis ka kõiki võõramaalasi. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Kuid kõigi osaks − kõigepealt juutide ja siis ka võõramaalaste osaks −, kes teevad head, on hiilgus, au ja rahu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Jumalal ei ole lemmikuid. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Need, kes teevad pattu, kuid neil ei ole kirjutatud seadust, lähevad ikkagi hukka, kuid need, kes teevad pattu ja kel on kirjutatud seadus, mõistetakse hukka selle seaduse järgi. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Üksnes seaduse kuulamine ei tee teid Jumala silmis õigeks. Õigeks tehakse need, kes teevad seda, mida seadus ütleb. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Võõramaalastel ei ole kirjutatud seadust, aga kui nad instinktiivselt teevad seda, mida seadus ütleb, järgivad nad seadust isegi ilma kirjutatud seadust omamata. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Niimoodi näitavad nad, kuidas toimib nende mõistusesse kirjutatud seadus. Kui nad mõtlevad, mida teevad, siis nende südametunnistus kas süüdistab neid valesti toimimises või kaitseb neid, kui nad teevad seda, mis on õige ja hea. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Hea sõnum, mida ma jagan, on see, et tuleb päev, mil Jumal mõistab Jeesuse Kristuse läbi kohut igaühe salajaste mõtete üle. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Kuidas on teiega, kes nimetate end juudiks? Te toetute kirjutatud seadusele ja hooplete, et teil on eriline suhe Jumalaga. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Te teate, mida ta tahab; te teete, mis on õige, sest teid on seaduse järgi õpetatud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Te olete absoluutselt kindlat, et suudate juhtida pimedaid ja et olete valguseks neile, kes on pimeduses. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Te arvate, et võite suunata asjatundmatud õigele teele, olla „laste“ õpetaja, sest te tunnete seadusest kogu tõde, mida on võimalik tunda. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Kui te olete nii hõivatud teiste õpetamisega, miks ei õpeta te iseennast? Te ütlete inimestele, et ei tohi varastada, kuid kas te ise varastate? ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Te ütlete inimestele, et abielu ei tohi rikkuda, kuid kas te ise rikute abielu? Te ütlete inimestele, et ebajumalaid ei tohi kummardada, kuid kas te rüvetate templit? ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Te hooplete, et teil on seadus, aga kas te seda rikkudes ei esita Jumalat vääriti? ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Nagu Pühakirjas on öeldud: „Jumala iseloomu laimatakse võõramaalaste hulgas teie pärast.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ümberlõigatud olemisel on väärtus ainult siis, kui teete seda, mida seadus ütleb. Aga kui te rikute seadust, siis on teie ümberlõikus väärtusetu nagu neil, kes ei ole üldse ümber lõigatud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Kui mees, kes ei ole ümber lõigatud, järgib seadust, tuleb teda arvestada kui ümberlõigatut, kuigi ta ei ole ümber lõigatud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ümberlõikamata võõramaalased, kes järgivad seadust, mõistavad teid hukka, kui rikute seadust, kuigi teil on kirjutatud seadus ja ümberlõikamine. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Välispidine ei tee teist juuti; selleks ei ole ümberlõikamise füüsiline märk. ");
INSERT INTO ekkpkp_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Juudiks teeb teid see, mis on sees, „südame ümberlõikamine“ − süda, mis ei järgi seaduse kirjatähte, vaid vaimsust. Selline inimene ootab kiitust Jumalalt, mitte inimestelt. ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Kas siis juudil on mingi eelis? Kas ümberlõikamine annab mingi eesõiguse? ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Jah, palju eesõigusi! Kõigepealt usaldati Jumala sõnum neile. ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Mis siis, kui mõni neist ei uskunud Jumalasse? Kas see, et neil puudub usk Jumalasse, kaotab Jumala usaldusväärsuse? ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Muidugi mitte! Isegi kui tuleb välja, et kõik teised valetavad, räägib Jumal alati tõtt. Nagu Pühakiri ütleb: „See, mida sina ütled, osutub õigeks, ja kui su üle kohut mõistetakse, võidad sa oma kohtuasja.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Aga kui fakt, et meie eksime, aitab näidata, et Jumalal on õigus, mida peaksime siis järeldama? Et Jumal eksib meie üle kohtuotsust langetades? (Ma räägin siin inimlikust perspektiivist.) ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Muidugi mitte! Kuidas muidu saaks Jumal maailma üle kohut mõista? ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Keegi ütleks: „Miks ma olen ikkagi süüdi mõistetud kui patune, kui minu valede kõrval muutuvad Jumala tõde ja Tema au veel ilmselgemaks?“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Kas nii, et „Las patt toob kaasa head“? Mõned inimesed on laimavalt süüdistanud meid, nagu oleksime seda öelnud. Nad tuleks õigusega hukka mõista! ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Niisiis, kas meie, juudid, oleme paremad kui teised? Kindlasti mitte! Tuletage meelde, et oleme juba tõendanud, et mõlemad, nii juudid kui ka võõramaalased, on patu kontrolli all. ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Nagu Pühakiri ütleb: „Keegi ei tee seda, mis on õige, mitte üksainuski. ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Keegi ei mõista, keegi ei otsi Jumalat. ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Kõik on talle selja pööranud; kõik teevad seda, mis on täiesti vale. Keegi ei tee seda, mis on hea, mitte üksainuski. ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Nende kurk on nagu avatud haud, nende keel levitab pettust, nende huuled nõretavad maomürgist. ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Nende suu on täis meelekibedust ja needusi, ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ja nad on nobedad valu ja surma põhjustama. ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Nende tee viib hävingusse ja õnnetusse; ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","nad ei oska rahus elada. ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Nad ei hooli üldse Jumala austamisest.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","On selge, et kõik seaduses kehtib nende kohta, kes elavad seaduse all, nii et kellelgi ei saaks olla vabandust, ja et kindlustada, et kõik kogu maailmas on Jumala ees vastutavad. ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Sest seaduse nõuete täitmise kaudu ei saa keegi Jumala ees õigeks. Seadus üksnes aitab meil ära tunda, mis on tegelikult patt. ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Aga nüüd on Jumala iseloomu headus ja õigsus nähtavaks saanud. See pole üldse seotud seaduse järgimisega, kuigi sellest räägivad seadus ja prohvetid. ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","See Jumala hea ja õige iseloom tuleb igaühele, kes usub Jeesusesse Kristusesse, neile, kes teda usaldavad. Ei ole tähtis, kes me oleme: ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","me kõik oleme pattu teinud ja meist keegi ei küündi Jumala aulise ideaalini. ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Kuid oma tasuta armu anni kaudu teeb Jumal meid õigeks Kristuses, kes meid vabastab. ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Jumal andis Jeesuse avalikult kui kingituse, mis toob rahu neile, kes temasse usuvad, ja kes valas oma vere. Jumal tegi seda, et näidata, et ta on tõesti hea ja õiglane, sest eelnevalt oli ta viivitanud ja patud tähelepanuta jätnud, ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","kuid nüüd, praegusel ajal, tõestab Jumal, et ta on õiglane ja teeb seda, mis on õige, ning et ta teeb õigeks need, kes usuvad Jeesusesse. ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Niisiis, kas meil on midagi, mille üle kiidelda? Üldsegi mitte, selle jaoks ei ole kohta! Ja miks siis? Sellepärast, et järgime seadust nõudeid täites? Ei, me järgime seadust Jumalasse uskudes. ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Me järeldame, et inimesed saavad õigeks Jumala ees nende usu kaudu temasse, mitte seaduse järgimise tõttu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Kas Jumal on üksnes juutide Jumal? Kas ta ei ole mitte ka teiste inimeste Jumal? Muidugi on! ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","On ainult üks Jumal, ja tema teeb meid moraalselt õigeks temasse uskumise kaudu, ükskõik kas oleme juudid või võõramaalased. ");
INSERT INTO ekkpkp_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Kas see tähendab, et Jumalasse uskudes kõrvaldame seaduse? Muidugi mitte! Tegelikult me kinnitame seaduse tähtsust. ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Võtame näiteks Aabrahami. Inimlikust vaatepunktist on ta meie rahva isa. Küsigem: „Missugune oli tema kogemus?“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Sest kui Aabraham oleks tehtud õigeks selle järgi, mida ta tegi, oleks tal olnud millegagi kiidelda, kuid mitte Jumala silmis. ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Aga mida ütleb Pühakiri? „Aabraham uskus Jumalat, seega peeti teda heaks inimeseks, kes teeb õigust.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Kes teeb tööd, saab palka; seda ei peeta kingituseks, vaid ta on oma palga välja teeninud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Kuid Jumal, kes teeb patused õigeks, peab neid õigeks mitte sellepärast, et nad on selle nimel tööd teinud, vaid sellepärast, et nad usuvad temasse. Sellepärast ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","kõneleb Taavet nende õnnest, keda Jumal peab õigeks, ja mitte sellepärast, et nad selle nimel vaeva oleksid näinud: ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","„Kui õnnelikud on need, kelle ülekohus on andeks antud ja kelle patud on kinni kaetud! ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Kui õnnelikud on need, keda Issand ei pea patuseks!“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Kas see õnnistus on nüüd siis ainult juutide jaoks või on see ka teiste jaoks? Eelnevalt selgus, et Aabraham tunnistati heaks ja õigeks, sest ta uskus Jumalat. ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Aga millal see juhtus? Kas siis, kui Aabraham oli juut, või enne seda? ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Tegelikult oli see enne seda, kui temast sai juut ümberlõikamise teel, mis kinnitas tema usku Jumala võimesse teha teda õigeks. See juhtus enne, kui ta sai ümber lõigatud, nii et ta on kõigi nende isa, kes usuvad Jumalasse ja keda Jumal peab õigeks, isegi kui nad ei ole ümberlõigatud juudid. ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ta on ka ümberlõigatud juutide isa, mitte üksnes sellepärast, et nad on ümber lõigatud, vaid sellepärast, et nad järgivad Aabrahami eeskuju Jumalasse uskumises enne ümberlõikamist. ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Jumala tõotus Aabrahamile ja tema järeltulijatele, et maailm kuulub neile, ei tuginenud tema seaduse täitmisele, vaid sellele, et ta sai õigeks usu läbi Jumalasse. ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Sest kui tõotatud pärand tugineks seaduse täitmisele, siis ei oleks Jumala uskumise teema vajalik ja tõotus oleks mõttetu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Sest seadus toob kaasa karistuse, aga kui seadust ei ole, siis ei saa seda rikkuda. ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Seega tugineb tõotus Jumalasse uskumisele. See antakse tasuta anniga, mis on garanteeritud kõigile Aabrahami lastele, mitte üksnes neile, kes seadust järgivad, vaid ka neile, kes usuvad nagu Aabraham, meie kõigi isa. ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Nagu Pühakiri ütleb: „Ma olen teinud su paljude rahvaste isaks.“ Sest Jumala ligiolus uskus Aabraham Jumalasse, kes teeb surnud elavaks ja kutsub sõnaga esile selle, mida enne ei olnud olemas. ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Vastu kõiki ootusi usaldas Aabraham Jumalat, nii et temast võis saada paljude rahvaste isa, just nagu Jumal oli talle tõotanud: „Nii palju saad sa järeltulijaid!“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Tema usku Jumalasse ei nõrgestanud isegi see, et tema arvates oli ta ihu praktiliselt surnud (ta oli ligikaudu sada aastat vana), ja ta teadis, et Saara oli laste saamiseks liiga vana. ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ta hoidis kinni Jumala tõotusest − ta ei kahelnud selles. Tema usk Jumalasse muutus hoopis tugevamaks ja ta ülistas Jumalat. ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Ta oli täielikult veendunud, et Jumalal on vägi teha seda, mida ta oli tõotanud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Sellepärast pidas Jumal Aabrahami õigeks. ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Sõnad „Aabrahami peeti õigeks“ ei olnud kirja pandud üksnes tema kasuks. ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Need olid ka meie jaoks, keda peetakse õigeks, kuna me usume Jumalasse, kes äratas meie Issanda Jeesuse surnuist üles. ");
INSERT INTO ekkpkp_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Jeesus anti surma meie pattude pärast ja ta äratati ellu, et meid õigeks teha. ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Nüüd kui oleme Jumalasse uskumise kaudu tema ees õigeks saanud, on meil rahu temaga tänu meie Issandale Jeesusele Kristusele. ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Jeesuse kaudu − temasse uskudes − oleme saanud juurdepääsu sellele armu asupaigale, kus me praegu oleme ning ootame rõõmu ja kindlustundega Jumala auhiilgusest osasaamist. ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Mitte ainult seda, vaid me jääme kindlaks ka siis, kui tulevad probleemid, sest me teame, et probleemide kogemine arendab vaimulikku vastupidavust. ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Vaimulik vastupidavus omakorda arendab küpset iseloomu ning see küps iseloom annab lõpuks kindla lootuse. ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Kuna meil on see lootus, ei pettu me kunagi, sest Jumala armastus on valatud meisse Püha vaimu kaudu, kelle ta meile on andnud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Kui olime täiesti abitud, siis just õigel ajal suri Kristus meie, jumalakartmatute inimeste eest. ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Kes sureks teise inimese eest, isegi selle eest, kes teeb, mis on õige? (Kuigi ehk oleks keegi piisavalt vapper, et surra tõeliselt hea inimese eest.) ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Kuid Jumal näitab oma armastust meie vastu sellega, et Kristus suri meie eest sel ajal, kui me veel patused olime. ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Nüüd, kui oleme tema surma kaudu õigeks saanud, võime olla täielikult kindlad, et ta päästab meid tulevasest kohtust. ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Sel ajal kui olime tema vaenlased, tegi Jumal meist enda sõbrad oma Poja surma kaudu, ja seega saame olla täiesti kindlad, et ta päästab meid Poja elu kaudu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Peale selle tähistame nüüd seda, mida Jumal on teinud meie Issanda Jeesuse Kristuse kaudu, et meid lepitada ja meid tema sõbraks teha. ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Sest ühe inimese kaudu tuli patt maailma ja patt tõi kaasa surma. Nii tuli surm kõigile, sest kõik on pattu teinud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Juba enne seda, kui seadus anti, oli patt maailmas, kuigi seda ei peetud patuks, sest ei olnud seadust. ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Kuid surm valitses siiski Aadamast kuni Mooseseni, isegi nende üle, kes ei patustanud samamoodi nagu Aadam. Aadam oli ettetähendus sellele, kes pidi tulema. ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Kuid Jeesuse and ei ole nagu Aadama patt. Kuigi paljud inimesed surid ühe inimese patu pärast, on Jumala arm niivõrd palju suurem ja seda on jagatud väga paljudele tema armulise anni kaudu Jeesuse Kristuse isikust. ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Anni tulemus ei ole selline nagu patul. Aadama patu tagajärg oli kohus ja hukkamõist, kuid and teeb meid Jumala ees õigeks, vaatamata meie paljudele pattudele. ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Ühe inimese patu tagajärjena valitses surm tema tõttu. Kuid Jumala arm on nii palju suurem ja tema and teeb meid õigeks, et igaüks, kes selle vastu võtab, püsib elus Jeesuse Kristuse isiku kaudu! ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Täpselt nagu üks patt tõi hukkamõistu kõigile, andis üks õige tegu kõigile võimaluse õigesti elada. ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Just nagu ühe inimese sõnakuulmatuse tõttu said paljud patuseks, saavad ühe inimese sõnakuulelikkuse kaudu paljud Jumala ees õigeks. ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Kui seadus tarvitusele võeti, sai patt veelgi selgemaks. Aga kuigi patt sai palju selgemaks, sai arm veelgi selgemaks! ");
INSERT INTO ekkpkp_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Samamoodi nagu patt valitses meid ja tõi meile surma, valitseb nüüd arm ning teeb meid õigeks Jumala ees ja annab meile igavese elu Jeesuse Kristuse, meie Issanda kaudu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Missugune on siis meie vastus? Kas peaksime jätkama patustamist, et saaksime veel rohkem armu? ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Muidugi mitte! Kuna oleme juba patule surnud, kuidas saaksime jätkuvalt patus elada? ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Kas te ei tea, et me kõik, kes oleme Kristusesse Jeesusesse ristitud, oleme ristitud tema surmasse? ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Ristimise kaudu maeti meid koos temaga surmas, nii et samamoodi, nagu Isa au äratas Kristuse surnuist, saaksime ka meie uue elu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Kui oleme saanud temaga üheks surmas nagu tema, siis äratatakse meidki üles nagu teda. ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Me teame, et meie vana mina löödi koos temaga risti, et hävitada patu surnud ihu, et me ei oleks enam patu orjad. ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Igaüks, kes on surnud, on patust vabastatud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Kuna me surime koos Kristusega, on meil kindlus, et me ka elame temaga koos, ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","sest me teame, et kuna Kristus äratati surnuist üles, ei sure ta kunagi, sest surmal ei ole tema üle enam mingit võimu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Ta suri patule üks kord ja lõplikult ja ta elab Jumalale! ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Täpselt samamoodi peaksite pidama ka teie ennast patule surnuks, kuid elavaks Jumalale Kristuse Jeesuse kaudu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Ärge laske patul valitseda oma sureliku ihu üle, ärge andke selle kiusatustele järele ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ja ärge kasutage ühtki oma kehaosa patu kurja tööriistana. Selle asemel pühendage end Jumalale kui need, kes on surmast toodud tagasi ellu, ning kasutage kõiki oma kehaosi vahenditena Jumala jaoks millegi hea tegemisel. ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Patt ei valitse teie üle, sest te ei ole seaduse all, vaid armu all. ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Niisiis, kas peaksime patustama, sest me ei ole seaduse all, vaid armu all? Muidugi mitte! ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Kas te ei saa aru, et kui teete end kellegi orjaks tema korraldustele kuuletudes, siis olete selle orjad, kelle sõna te kuulete? Kui olete patu orjad, on tulemuseks surm; kui kuuletute Jumalale, siis selle tulemusena saate tema ees õigeks. ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Tänu Jumalale, et kuigi kord olite patu orjad, valisite puhtsüdamlikult, et otsustate järgida teada saadud tõde Jumala kohta. ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Nüüd kui te olete patust vabastatud, olete saanud moraalselt õigesti toimimise orjaks. ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Kasutan seda argielulist näidet, sest teie inimlik mõtlemine on piiratud. Samamoodi nagu te kord andsite end ebamoraalsuse orjaks, kuhjates pattu patu otsa, peate nüüd tegema end selle orjaks, mis on puhas ja õige. ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Kui te oleksite patu orjad, ei nõutaks teilt selle tegemist, mis on õige. ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Aga missugused olid tagajärjed siis? Kas te ei häbene neid asju, mida tegite? Sellised asjad viivad surma! ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Aga nüüd, kui olete patust vabastatud ja Jumala orjaks saanud, on tulemuseks puhas elu ning lõpuks igavene elu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Patu palk on surm, aga Jumala tasuta and on igavene elu Kristuse Jeesuse, meie Issanda kaudu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Vennad ja õed, (ma räägin siin inimestele, kes tunnevad seadust), kas te ei näe, et seadusel on volitused kellegi üle ainult siis, kui ta on elus? ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Näiteks abielunaine on seaduse järgi oma abikaasaga seotud sel ajal, kui abikaasa on elus, aga kui mees sureb, siis saab naine vabaks oma seaduslikust kohustusest mehe ees. ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Seega, kui naine elab teise mehega sel ajal, kui tema abikaasa elab, rikub naine abielu. Aga kui naise mees sureb ja ta abiellub seejärel teise mehega, siis ei ole ta abielurikkumises süüdi. ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Samamoodi, mu sõbrad, olete surnud seadusele Kristuse ihu kaudu ning seega kuulute nüüd kellelegi teisele − Kristusele, kes äratati surnuist üles −, et me võiksime elada viljakat elu Jumalale. ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Sel ajal kui meid valitses vana olemus, tegutsesid meis patused ihad (nagu nähtub seadusest) ja tõid kaasa surma. ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Aga nüüd oleme seadusest vabastatud ning oleme surnud sellele, mis hoiab meid ahelais, et me saaksime teenida vaimu uudsuses ja mitte seaduse vana kirjatähte. ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Mida me siis järeldame? Et seadus on patt? Muidugi mitte! Ma ei oleks teadnud, mis on patt, kui seadus ei oleks seda määratlenud. Ma ei oleks mõistnud, et teiste inimeste asjade endale tahtmine on vale, kui ei oleks seadust, mis ütleb: „Ära ihalda endale seda, mis kuulub kellelegi teisele.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Kuid selle käsu kaudu leidis patt võimaluse õhutada minus igasuguseid isekaid soove, sest ilma seaduseta on patt surnud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Ma elasin, mõistmata, mida seadus tegelikult tähendab, aga kui sain aru käsu tähendusest, ärkas patt taas ellu ja ma surin. ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Ma avastasin, et seesama käsk, mis oli mõeldud elu toomiseks, tõi hoopis surma, ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","sest patt leidis käsu kaudu mooduse minu petmiseks ja kasutas käsku minu tapmiseks! ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Siiski on seadus püha ja käsk püha, õige ja hea. ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Kas nüüd miski, mis on hea, tapab mind? Muidugi mitte! Kuid patt ilmutab end patuna, kasutades head minu surma põhjustamiseks. Niisiis ilmneb käsu abil, kui halb on patt tegelikult. ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Me mõistame, et seadus on vaimulik, kuid ma olen liigagi inimlik, patu ori. ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ma tõesti ei saa aru, mis toimub. Ma teen seda, mida ma ei taha teha, ja ma vihkan seda, mida ma teen! ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Aga kui ma ütlen, et ma teen seda, mida ma ei taha, näitab see, et ma tunnistan, et seadus on hea ja õige. ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Seega ei ole see enam mina, kes seda teeb, vaid minus elav patt, ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","sest ma tean, et minus ei ole midagi head selles osas, mis puutub minu patusesse inimolemusse. Kuigi ma tahan teha head, ei ole ma selleks võimeline. ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Head, mida ma teha tahan, ma ei tee; samal ajal halba, mida ma ei taha teha, seda ma just teen! ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ometi kui ma teen seda, mida ma ei taha teha, siis ei tee seda mina, vaid minus elav patt. ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","See on põhimõte, mille olen avastanud: kui ma tahan teha seda, mis on hea, on alati olemas ka halb. ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Minu sisemisele olemusele valmistab Jumala seadus rõõmu, ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","kuid ma näen enda sees tegutsemas teistsugust seadust, mis on sõjajalal seadusega, mida mu mõistus on otsustanud järgida, ja nii olen ma minu sees oleva patu seaduse vang. ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Olen äärmiselt õnnetu! Kes päästab mind sellest ihust, mis põhjustab mu surma? Tänu Jumalale, Sest tema teeb seda Jeesuse Kristuse, meie Issanda kaudu! ");
INSERT INTO ekkpkp_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Olukord on selline: kuigi ma ise otsustan mõistusega kuuletuda Jumala seadusele, järgib mu inimloomus patu seadust. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Niisiis ei ole nüüd mingit hukkamõistu neile, kes on Kristuses Jeesuses. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Elu vaimu seadus Kristuses Jeesuses on vabastanud mind patu ja surma seadusest. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Mida seadus ei suutnud teha, sest see oli meie patuse loomuse, tõttu võimetu, oli võimeline tegema Jumal! Jumal tegeles kogu patu probleemiga, saates oma Poja inimkujul, ja purustas patu võimu meie patuses inimloomuses. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Nii saaksime täita seaduse head nõuded Vaimu, mitte oma patust loomust järgides. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Need, kes järgivad oma patust loomust, on patuste asjadega hõivatud, aga need, kes järgivad Vaimu, keskenduvad vaimulikele asjadele. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Patuse inimliku mõtteviisi lõpptulemus on surm, kuid Vaimu juhitud mõtteviis toob elu ja rahu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Patune inimlik mõtteviis on vaenulik Jumala suhtes, sest see keeldub Jumala seadusele kuuletumast. Õigupoolest see ei suudagi, ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ja need, kes järgivad oma patust loomust, ei suuda iial Jumalale meelepärased olla. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Kuid teie ei järgi oma patust loomust, vaid Vaimu – kui on tõsi, et Jumala Vaim elab teis. Sest need, kelles ei ole Kristuse Vaim, ei kuulu talle. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Aga kui Kristus on teie sees, siis kuigi teie ihu sureb patu tõttu, annab Vaim teile elu, sest nüüd olete Jumala ees õiged. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Teie sees elab tema Vaim, kes äratas Jeesuse surnuist üles. Tema, kes äratas Jeesuse surnuist üles, annab elu ka teie surnud ihule oma Vaimu kaudu, kes teis elab. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Niisiis, vennad ja õed, me ei pea järgima oma patust loomust, mis tegutseb vastavalt meie inimlikele soovidele. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Sest kui te elate oma patuse loomuse valitsemise all, siis te surete. Aga kui te järgite Vaimu teguviisi ja surmate kurja, mida teete, siis te elate. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Kõik, keda Jumala Vaim juhib, on Jumala lapsed. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Teile ei ole antud vaimu, mis teid veel kord orjastaks ja kohutaks. Ei, see Vaim, mille saite, teeb teist lapsed Jumala perekonnas. Nüüd võime valjusti hüüda: „Jumal on meie Isa!“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Vaim ise on meiega nõus, et me oleme Jumala lapsed. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Kui oleme tema lapsed, siis oleme tema pärijad. Me oleme Jumala pärijad ja koos Kristusega kaaspärijad. Aga kui tahame osa saada tema auhiilgusest, peame osa saama tema kannatustest. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Siiski olen veendunud, et see, mida praegu kannatame, ei ole midagi, võrreldes tulevase auhiilgusega, mis meile ilmutatakse. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Kogu loodu ootab kannatlikult ja igatseb, et Jumal avalikustaks oma lapsed. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Sest Jumal lubas loomise eesmärgil nurja minna. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Kuid loodu ise ootab lootuses aega, mil ta vabaneb lagunemise orjusest ja saab osa Jumala laste aulisest vabadusest. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Me teame, et kogu loodu ägab igatsusest ja kannatab sünnitusvalusid tänaseni. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Mitte ainult loodu, vaid ka meie, kel on Vaimu eelmaitse, ägame sisemiselt, kui ootame oma ihu lunastamist, et Jumal meid „lapsendaks“. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Sest meid päästeti lootuse kaudu. Kuid lootus, mida on juba näha, ei ole üldse lootus. Kes loodab seda, mida ta juba näeb? ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Kuna loodame seda, mida me ei ole veel näinud, siis ootame seda kannatlikult. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Samamoodi aitab Vaim meid meie nõrkuses. Me ei tea, kuidas Jumalaga rääkida, aga Vaim ise palub koos meiega ja meie kaudu ägamistega, mida ei ole võimalik sõnadesse panna. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Tema, kes uurib läbi kõigi mõtteviisi, teab Vaimu ajendeid, sest Vaim kaitseb usklike ees Jumala huve. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Me teame, et Jumal tegutseb kõiges nende heaks, kes teda armastavad, keda ta on kutsunud oma plaanist osa saama. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Sest Jumal, kes neid ette valis, eraldas neid olema nagu tema Poeg, et Poeg oleks paljudest vendadest ja õdedest esimene. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Keda ta valis, neid ta ka kutsus, ning keda ta kutsus, tegi ta ka õigeks, ning neid, kelle ta õigeks tegi, on ta ka austanud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Missugune on siis meie vastus kõigele sellele? Kui Jumal on meie poolt, kes võib olla meie vastu? ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Kas siis Jumal, kes oma Poegagi tagasi ei hoidnud, vaid andis ta meie kõigi eest, ei anna heldelt meile ka kõike muud? ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Kes võib Jumala erilist rahvast milleski süüdistada? Jumal on see, kes teeb meid õigeks, ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","nii et kes saab meid hukka mõista? Kristus Jeesus, kes suri – mis veelgi olulisem, kes surnuist üles äratati –, seisab Jumala paremal käel ja esindab meie juhtumit. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Kes saab meid lahutada Kristuse armastusest? Kas rõhumine, kitsikus või tagakiusamine? Või nälg, vaesus, oht ja vägivald? ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Just nagu Pühakiri ütleb: „Sinu pärast oli meil kogu aeg oht saada tapetud. Meid koheldi nagu tapale viidavaid lambaid.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ei, kõiges, mis meiega juhtub, oleme rohkem kui võitjad tema kaudu, kes meid armastab. ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Olen täiesti veendunud, et ei elu ega surm, ei inglid ega kurjad vaimud, ei olevik ega tulevik, ei võimud, ");
INSERT INTO ekkpkp_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ei kõrgus ega sügavus, tegelikult mitte miski kogu loodus ei saa meid lahutada Jumala armastusest, mis on Kristuses Jeesuses, meie Issandas. ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Mina olen Kristuses ja see, mida ma räägin, on tõsi. Ma ei valeta! Minu südametunnistus ja Püha Vaim kinnitavad, ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","kui kohutavalt kurb ma olen, kui otsatu valu on mu südames ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","mu oma rahva, mu vendade ja õdede pärast. Ma oleksin pigem ise neetud ja Kristusest lahutatud, kui see neid aitaks. ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Nad on mu kaasiisraellased, Jumala valitud rahvas. Jumal ilmutas neile oma auhiilgust ja tegi nendega lepingud, andis neile seaduse, õige jumalateenistuse ja tõotused. ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Nad on meie esiisad, inimlikult öeldes selle Kristuse esivanemad, kes valitseb kõige üle, kes on igavesti õnnistatud Jumal. Aamen. ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Jumala tõotus ei ole puudulikuks osutunud. Sest iga iisraellane ei ole õige iisraellane, ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ja kõik need, kes põlvnevad Aabrahamist, ei ole tema õiged lapsed. Sest Pühakiri ütleb: „Sinu järglasi arvestatakse Iisaki kaudu,“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","nii et Jumala lasteks ei arvestata mitte Aabrahami tegelikke lapsi, vaid ainult Jumala tõotuse lapsi peetakse tema õigeteks järeltulijateks. ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Tõotus oli selline: „Ma tulen järgmisel aastal tagasi ja Saaral on poeg.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Lisaks oli Rebeka kaksikutel poegadel sama isa, meie esiisa Iisak. ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Aga isegi enne, kui lapsed sündisid, ja enne, kui nad jõudsid teha midagi õiget või valet (et Jumala plaan saaks jätkuda, tõestades, et Jumala kutsumine ei põhine inimeste sooritusel), ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","öeldi talle: „Vanem vend teenib nooremat.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Nagu Pühakiri ütleb: „Ma valisin Jaakobi, kuid Eesavi heitsin ma kõrvale.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Mida peaksime siis järeldama? Et Jumal on ebaõiglane? Kindlasti mitte! ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Nagu ta ütles Moosesele: „Ma olen armuline sellele, kellele peaksin armulikkust osutama, ja halastan sellele, kellele peaksin halastust osutama.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Niisiis ei sõltu see meie tahtmisest ega meie enda pingutustest, vaid Jumala halastusrikkast olemusest. ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Pühakirjas on jäädvustatud Jumala sõnad vaaraole: „Ma panen su siia põhjusega, et saaksin sinu kaudu ilmutada oma väge ja et minu nimi saaks tuntuks kogu maailmas.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Seega halastab Jumal nende peale, kelle peale tahab, ja paadutab hoiaku neil, kellel tahab. ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Nüüd te vaidlete minuga ja küsite: „Miks ta siis meid süüdistab? Kes saab Jumala tahtele vastu panna?“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Nii ei sobi kõneleda, sest kes olete teie − tühipaljad surelikud −, et Jumalale vastu rääkida? Kas loodu võib oma loojale öelda: „Miks sa mind selliseks tegid?“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Kas pottsepal ei ole õigust kasutada sama savikamakat, et valmistada dekoratiivne kauss ja igapäevane kruus? ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Nagu oleks Jumal, soovides näidata oma vastuseisu patule ja ilmutada oma väge, kannatlik nende „hävitusele määratud anumatega“, ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","nii et ta võiks avaldada oma auhiilguse suurust nende „halastuse anumate“ kaudu, mille ta on eelnevalt au jaoks valmistanud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Need me olemegi − inimesed, kelle ta on kutsunud mitte üksnes juutide hulgast, vaid ka võõramaalaste seast ... ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Nagu Jumal ütles Hoosea raamatus: „Neid, kes ei ole minu rahvas, ma nimetan oma rahvaks, ja neid, keda ei ole armastatud, ma nimetan armastatuteks“, ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ja: „See juhtub kohas, kus neile öeldi: „Te ei ole minu rahvas“, seal nimetatakse neid elava Jumala lasteks.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Jesaja hüüatab Iisraeli kohta: „Isegi kui Iisraeli lapsed on saanud arvukaks nagu mereliiv, päästetakse üksnes väike hulk. ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Sest Issand lõpetab kiiresti ja täielikult oma kohtumõistmise töö maa peal.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Nagu Jesaja varem ütles: „Kui Kõigeväeline Issand ei oleks meile mõningaid järglasi jätnud, oleksime olnud täpselt nagu Soodom ja Gomorra.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Mida peaksime siis järeldama? Et kuigi võõramaalased ei püüdnud toimida õigesti, mõistsid nad, mis on õige, ning usu kaudu Jumalasse tegid seda, mis on moraalselt õige. ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Kuid Iisraeli rahvas, kes ootas, et seadus teeks neid Jumala ees õigeks, ei saavutanud edu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Miks mitte? Sest nad toetusid pigem oma tegudele kui usule Jumalasse. Nad komistasid vastu komistuskivi, ");
INSERT INTO ekkpkp_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","just nagu Pühakiri ette kuulutas: „Vaata, ma panen Siionisse komistuskivi, kivi, mis pahandab inimesi. Aga kes temasse usub, see ei pettu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Mu vennad ja õed, mu südamesoov − mu palve Jumalale − on Iisraeli rahva pääste! ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Ma võin tunnistada nende innukast pühendumisest Jumalale, kuid selle aluseks ei ole teadmine, kes ta tegelikult on. ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Nad ei saa aru, kuidas teeb Jumal nad enda ees õigeks, ja nad üritavad end ise õigeks teha. Nad ei võta omaks seda, kuidas Jumal inimesed õigeks teeb. ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Sest Kristus on seaduse täitumine. Kõik, kes temasse usuvad, tehakse õigeks. ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Mooses kirjutas: „Igaüks, kes teeb seadusele kuuletudes õigust, elab.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Kuid usust tuleneva õiguse täitmise hoiak ütleb nii: „„Ärge küsige „kes läheb taevasse?“ (paludes tuua Kristust alla)“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ega „kes läheb surnute asupaika?“ (paludes tuua Kristust surnuist tagasi).“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Tegelikult ütleb Pühakiri: „Sõnum on teile väga lähedal − see on see, millest te räägite ja mis on teie mõtteis.“ Õigupoolest põhineb see sõnum usul, mida esitame. ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Sest kui kuulutate, et võtate Jeesuse Issandana vastu, ja olete oma meeltes veendunud, et Jumal äratas ta surnuist üles, siis saate päästetud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Teie usk Jumalasse teeb teid õigeks ja heaks ning teid päästab see, et tunnistate avalikult Jumala vastuvõtmist. ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Nagu Pühakiri ütleb: „Kes temasse usuvad, ei pettu.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Ei ole mingit vahet juudil ja kreeklasel, sest sama Issand on kõigi Issand ja tema annab heldelt igaühele, kes temalt palub. ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Sest „igaüks, kes Issanda nimele toetub, päästetakse“. ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Aga kuidas saavad inimesed toetuda kellelegi, kellesse nad ei usu? Kuidas saavad nad uskuda kellessegi, kellest nad kuulnud ei ole? Kuidas saavad nad kuulda, kui neile ei räägita? ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Kuidas saavad nad minna välja ja teistele rääkida, kui neid ei läkitata? Just nagu Pühakiri ütleb: „Kes toovad hea uudise, on tõeliselt oodatud!“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Aga mitte kõik ei võta head uudist vastu. Nagu Jesaja küsib: „Issand, kes on uskunud sõnumit, mida nad meilt on kuulnud?“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Usk Jumalasse tuleb kuulmisest, Kristuse sõnumi kuulmisest. ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Asi ei ole selles, nagu poleks nad kuulnud. Hoopis vastupidi: „Nende hääli, kes kõnelevad Jumalast, on kuulda üle kogu maa − nende sõnum läks välja kogu maailma.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Seega on mu küsimus: „Kas Iisrael ei teadnud?“ Kõigepealt ütleb Mooses: „Ma muudan su kadedaks, kasutades inimesi, kes pole isegi mitte rahvus; ma muudan su vihaseks, kasutades asjatundmatuid võõramaalasi!“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Jesaja ütles seda siis veel karmimalt: „Mind leidsid inimesed, kes mind isegi ei otsinud; ma ilmutasin end inimestele, kes isegi minu järele ei küsinud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Nagu ütleb Jumal Iisraelile: „Kogu päeva sirutasin ma oma käsi sõnakuulmatu ja kangekaelse rahva poole.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Aga ma küsin siis: „Kas Jumal on oma rahva hüljanud?“ Muidugi mitte! Mina ise olen iisraellane, Benjamini suguharust. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Jumal ei ole oma valitud rahvast hüljanud. Kas te ei mäleta, mida Pühakiri ütleb Eelija kohta? Kuidas ta kurtis Jumalale Iisraeli pärast ja ütles: ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","„Issand, nad on tapnud su prohvetid ja hävitanud su altarid. Mina olen ainus, kes on järele jäänud, ja nad püüavad ka mind tappa!“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Kuidas Jumal talle vastas? „Mul on veel alles seitse tuhat, kes ei ole Baali kummardanud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Tänapäeval on olukord täpselt sama: ikka veel on alles mõned ustavad inimesed, kes on Jumala armust valitud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Ja kuna see on armust, siis ilmselgelt ei põhine see inimeste tegudel, muidu arm ei oleks arm! ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Mida me siis järeldame? Et Iisraeli rahvas ei saavutanud seda, mille poole nad püüdlesid, vaid ainult valitud saavutasid, kuna ülejäänute süda muutus kõvaks. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Nagu Pühakiri ütleb: „Jumal nüristas nende mõistuse, nii et nende silmad ei näinud ja kõrvad ei kuulnud kuni sellesama päevani.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Taavet lisab: „Saagu nende peod neile lõksuks, võrguks, mis nad kinni püüab, kiusatuseks, mis toob karistuse. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Saagu nende silmad pimedaks, et nad ei näeks, ja olgu nad alati rõhutud meeleolu tõttu küüru vajunud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Kas ma siis ütlen, et nad komistasid ja kukkusid seetõttu täielikult läbi? Üldsegi mitte! Aga nende vigade tagajärjel tuli pääste teistele rahvastele ja „muutis nad kiivaks“. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Kui nüüd isegi nende läbikukkumisest on maailmale kasu ja nende kahjust on tulu võõramaalastele, kui palju kasulikum oleks olnud, kui nad oleksid täitnud täielikult selle, missugused nad oleksid pidanud olema. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Lubage, ma kõnelen nüüd teile, võõramaalased. Niivõrd kui ma olen võõramaalaste misjonär, kiitlen ma oma tegevusest, ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","et ma kuidagi saaksin muuta oma rahva kadedaks ja päästa mõned neist. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Kui seetõttu, et nemad hülgavad Jumala, saab maailm Jumalaga sõbraks, siis ärkaksid surnud ellu seetõttu, kui nad Jumala vastu võtaksid! ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Kui ohvrianniks antud leivataigna esimene osa on püha, siis on ka ülejäänu püha; kui puu juured on pühad, on pühad ka oksad. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Kui nüüd mõni oks on ära murtud ja teie − metsik õlipuuvõsu − olete külge poogitud ja saate koos nendega kasulikku toidust õlipuu juurtest, ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","siis ei tohi te teisi oksi põlata. Kui teil on kiusatus kiidelda, tuletage meelde, et teie ei hoia üleval juuri, vaid juured teid. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Te võite väita: „Oksad murti ära, et mind saaks külge pookida.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Olgu pealegi, aga nad murti ära, sest nad ei uskunud Jumalasse, ja teie püsite, sest usute Jumalasse. Ärge olge endast heal arvamusel, vaid olge aupaklikud, ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","sest kui Jumal ei säästnud algseid oksi, ei säästa ta teidki. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Te peaksite tunnustama Jumala headust ja karmust − ta oli karm langenutega, kuid Jumal on hea teiega, kuni usute tema headusesse −, muidu eemaldatakse ka teid. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Kui nad enam ei keeldu Jumalasse uskumast, võivad ka nemad külge poogitud saada, sest Jumal suudab nad taas puu külge pookida. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Kui teid oli võimalik metsõlipuu küljest ära lõigata ja siis kultuurõlipuu külge pookida, kui palju kergem oleks neid tagasi pookida puu külge, mis oli loomult nende enda puu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Ma ei taha, et teie, mu vennad ja õed, jätaksite tähelepanuta selle varasemalt varjatud tõe, muidu võite upsakaks muutuda. Osa Iisraeli rahvast muutus kõvasüdameliseks, kuni võõramaalaste sissetulemine on lõpetatud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Nii saab päästetud kogu Iisrael. Nagu Pühakiri ütleb: „Päästja tuleb Siionist ja tema pöörab Jaakobi ära vastuhakust Jumalale. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Minu tõotus neile on, et ma võtan ära nende patud.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Kuigi nad on hea sõnumi vaenlased − ja seda teie kasuks −, on nad ikkagi valitud rahvas ja nende esiisade tõttu armastatud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Jumala ande ja tema kutsumist ei saa tagasi võtta. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Kunagi olite Jumalale sõnakuulmatud, aga nüüd on Jumal osutanud teile teie sõnakuulmatuse tulemusena halastust. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Täpselt samamoodi, nagu nad on praegu sõnakuulmatud, nagu olite teie, ilmutatakse ka neile samasugust halastust, mis sai teie osaks. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Sest Jumal kohtles kõiki vangidena nende sõnakuulmatuse tõttu, et ta saaks kõigi peale halastada. ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Oh kui sügavad on Jumala küllus, tarkus ja teadmine! Kui hämmastavad on tema otsused, kui kujuteldamatud tema teguviisid! ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Kes saab teada Jumala mõtteid? Kes saab talle nõu anda? ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Kes on kunagi andnud Jumalale midagi, mida Jumalal on kohustus tagasi maksta? ");
INSERT INTO ekkpkp_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Kõik tuleb temalt, kõik eksisteerib tema kaudu ja kõik on tema jaoks. Au olgu talle igavesti, aamen! ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Seega, ma julgustan teid, mu vennad ja õed, Jumala kaastunde pärast teie suhtes, pühendama Jumalale oma ihu kui elava ohvri, mis on püha ja meelepärane. See on mõistlik jumalateenistus. ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Ärge järgige selle maailma kombeid; selle asemel muutuge meele vaimuliku uuendamisega, nii et saaksite ilmutada, missugune on Jumala tahe tegelikult − hea, meeldiv ja täiuslik. ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Lubage, et ma selgitan teile kõigile − mulle antud armu kaudu −, et keegi ei tohi ennast pidada paremaks kui peaks. Te peate hindama end realistlikult, vastavalt usu määrale, mida Jumal on teile jaganud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Just nagu ühel ihul on palju kehaosi, kuid kõik need ei tee sama, ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","oleme ka meie üks ihu Kristuses, kuigi meid on palju, ja me kõik kuulume üksteisega kokku. ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Meil on isesugused annid, mis erinevad vastavalt meile antud armule. Nii et kui see on Jumala nimel kõnelemine, siis peaksite seda tegema, olenevalt sellest, kui palju on teil usku Jumalasse. ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Kui see on teenimistöö, siis peaksite teenima; kui õpetamine, siis peaksite õpetama; ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","kui julgustus, siis peaksite julgustama; kui andmine, siis peaksite heldelt andma; kui juhtimine, siis peaksite pühendunult juhtima; kui halastustöö, siis peaksite seda rõõmuga tegema. ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Armastus peab olema tõeline. Vihkamine on kurjast; hoidke kõvasti kinni sellest, mis on hea. ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Olge täielikult üksteisele pühendunud kui perekond oma armastuses; pidage teisi väärtuslikumaks kui iseennast. ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Ärge olge tõrksad tõsiselt töötama; teenige Issandat innuka meelsusega. ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Püsige rõõmsameelsed lootuses, mis teil on, taluge raskusi, mis tulevad, jätkake palvetamist. ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Võtke osa Jumala rahva vajaduste täitmisest ja võtke võõrad külalislahkelt vastu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Õnnistage neid, kes teid taga kiusavad − õnnistage neid, ja ärge neid needke. ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Olge rõõmsad koos rõõmsatega, nutke koos nutjatega. ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Mõelge üksteise peale. Ärge pidage end teistest tähtsamaks; elage alandlikult. Ärge olge ennast täis. ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Ärge tasuge kellelegi kurja kurjaga. Hoolitsege selle eest, et näitaksite kõigile, et see, mida teete, on hea, ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ja nii palju kui teist sõltub, elage rahus kõigiga. ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Mu armsad sõbrad, ärge taotlege kättemaksu, vaid jätke kohtuotsuse täideviimine Jumala hoolde, nagu Pühakirjas öeldakse: „„Mina jagan õiglust, mina tasun kätte,“ ütleb Issand.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Kui need, kes teid vihkavad, on näljas, andke neile süüa; kui neil on janu, andke neile juua, sest nii tehes kuhjate nende pea peale tuliseid süsi. ");
INSERT INTO ekkpkp_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Ärge laske kurjal võitu saada, võitke kuri ära heaga. ");
INSERT INTO ekkpkp_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Igaüks peab kuuletuma ametivõimudele, sest kellelgi ei ole võimu valitseda, kui Jumal luba ei anna. Need ametivõimud on sinna pannud Jumal. ");
INSERT INTO ekkpkp_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Kes ametivõimudele vastu paneb, hakkab vastu sellele, mille Jumal on kohale määranud, ja kes nii teeb, selle osaks saab vastav kohtuotsus. ");
INSERT INTO ekkpkp_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Sest valitsejad ei hirmuta neid, kes teevad õigesti, vaid neid, kes teevad valesti. Kui te ei taha elada hirmus ametivõimude ees, siis tehke seda, mis on õige, ja te saate nende heakskiidu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Võimul olevad inimesed on Jumala teenrid, määratud kohale teie heaolu jaoks. Kui toimite valesti, peategi hirmunud olema − ega ametivõimudel pole põhjuseta volitust karistada! Nad on Jumala teenrid, kes karistavad üleastujaid. ");
INSERT INTO ekkpkp_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Niisiis on oluline, et teeksite, nagu kästud, mitte üksnes karistuse ähvardusel, vaid sellepärast, mida südametunnistus teile ütleb. ");
INSERT INTO ekkpkp_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Sellepärast peate maksma makse, sest ametivõimud on Jumala teenrid, kes selliste asjade eest hoolitsevad. ");
INSERT INTO ekkpkp_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Tasuge, mida iganes võlgu olete: maksud maksuametnikele, tasud tasukogujatele; pidage lugu neist, kellest tuleb lugu pidada; austage neid, keda tuleb austada. ");
INSERT INTO ekkpkp_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Ärge jääge kellelegi midagi võlgu, välja arvatud armastust üksteise vastu, sest need, kes armastavad kaasinimest, täidavad seadust. ");
INSERT INTO ekkpkp_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","„Sa ei tohi abielu rikkuda, sa ei tohi tappa, sa ei tohi varastada, sa ei tohi kiivalt endale asju tahta“ − need ja teised käsud on kokku võetud ühes lauses: „Armasta oma kaasinimest nagu iseennast.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Armastus ei tee kellelegi ülekohut, järelikult täidab armastus seadust. ");
INSERT INTO ekkpkp_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Te peaksite nii toimima, sest te mõistate, kui pakiline on aeg − et teil on ülim aeg unest ärgata. Sest pääste on meile nüüd lähemal kui siis, kui me alguses Jumalasse uskuma hakkasime. ");
INSERT INTO ekkpkp_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Öö on varsti läbi, päev on peaaegu kohal! Kõrvaldagem siis pimeduseteod ja pangem ülle valguse soomusrüü. ");
INSERT INTO ekkpkp_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Käitugem korralikult ja näidakem, et oleme inimesed, kes elavad valguses. Me ei tohi veeta aega metsikutel pidudel ega purjutamisel, meil ei tohi olla afääre ja me ei tohi amoraalselt käituda, kaklustes osaleda ega kade olla. ");
INSERT INTO ekkpkp_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Selle asemel riietuge Issanda Jeesuse Kristusega ja unustage oma patuste soovide järgimine. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Võtke vastu need, kellel on veel raskusi Jumalasse uskumisega, ja ärge astuge vaidlusse isiklike arvamuste üle. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Üks inimene võib arvata, et ta võib kõike süüa, samal ajal teine, kelle usk on nõrk, sööb ainult aedvilju. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Need, kes söövad kõike, ei tohi halvustada neid, kes ei söö, ja need, kes ei söö, ei tohi arvustada neid, kes söövad, sest Jumal võtab nad mõlemad vastu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Mis õigust on teil kellegi teise teenija üle kohut mõista? Tema enda isand on see, kes otsustab, kas ta teeb õigesti või valesti. Issanda abiga suudavad nad õiguse poolel seista. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Mõned peavad mõnda päeva olulisemaks kui teisi, samas kui teised peavad kõiki päevi ühesuguseks. Igaüks peaks oma mõtteis täielikult veendunud olema. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Need, kes austavad erilist päeva, teevad seda Issandale; ja need, kes söövad ilma muretsemata, teevad seda Issandale, sest nad tänavad Jumalat. Samal ajal need, kes väldivad teatud asjade söömist, teevad seda Issandale ja ka nemad annavad tänu Jumalale. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Keegi meist ei ela iseendale ega sure iseendale. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Kui elame, siis elame Issandale, või kui sureme, siis sureme Issandale − seega kas me elame või sureme, me kuulume Issandale. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Sel põhjusel Kristus suri ja ärkas jälle ellu − et ta saaks olla nii surnute kui ka elavate Issand. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Miks te siis arvustate oma kaasusklikke? Miks te põlgate oma kaasusklikke? Sest me kõik seisame Jumala kohtutrooni ees. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Sest Pühakiri ütleb: „„Sama kindlalt kui ma elan,“ ütleb Issand, „peavad kõik põlved kummarduma minu ees ja iga keel kuulutab, et ma olen Jumal.““ ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Seega peab igaüks meist oma teguviisi Jumala ees selgitama. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Seepärast ärgem enam mõistkem üksteise üle kohut, vaid otsustagem hoopis, et me ei pane takistusi oma kaasusklike teele ega sunni neid langema. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Ma olen kindel − mind on veennud Issand Jeesus −, et miski ei ole iseenesest tseremoniaalselt ebapuhas. Aga kui keegi peab seda ebapuhtaks, siis on see tema jaoks ebapuhas. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Kui teie kaasusklikku haavab teie toiduküsimus, siis ei käitu te enam armastavalt. Ärge hävitage kedagi, kelle eest Kristus suri, toiduga, mida valite söömiseks. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Ärge laske head, mida teete, vääriti kujutada, ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","sest Jumala riik ei ole söömine ja joomine, vaid õigesti elamine ning rahu ja rõõmu omamine Pühas Vaimus. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Igaüks, kes teenib Kristust niimoodi, on Jumalale meelepärane ja teised tunnustavad teda. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Käigem siis rahurajal ja leidkem võimalusi üksteise julgustamiseks. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Ärge hävitage Jumala tööd vaidlustega toidu üle. Kõik on puhas, kuid on vale süüa ja teisi haavata. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Parem on mitte süüa liha ja mitte juua veini ega teha midagi muud, mis paneks kaasuskliku komistama. ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","See, mida te isiklikult usute, on teie ja Jumala vaheline asi. Õnnelikud on need, kes ei mõista end hukka, tehes seda, mida nad õigeks peavad! ");
INSERT INTO ekkpkp_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Aga kui teil on kahtlusi, kas millegi söömine on õige või vale, siis ei peaks sööma, sest te pole veendunud, et see on õige. Mis ei põhine kindlal veendumusel, on patt. ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Need meie hulgas, kes on vaimulikult tugevad, peaksid toetama neid, kes on vaimulikult nõrgad. Me ei tohiks ainult oma tahtmise järgi talitada. ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Me kõik peaksime julgustama teisi tegema seda, mis on moraalselt õige, ja neid innustama. ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Kristus ei elanud selleks, et oma tahtmise järgi talitada, vaid nagu Pühakiri tema kohta ütleb: „Nende solvangud, kes on sind teotanud, on langenud minu peale.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Need Pühakirja tekstid pandi minevikus kirja, et aidata meil mõista ja et meid julgustada, et suudaksime kannatlikult lootuses oodata. ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Aidaku Jumal, kes annab kannatlikkust ja julgustust, olla isekeskis täielikult ühel nõul, kui te järgite Kristust Jeesust, ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","nii et te saaksite ühel meelel ja ühel häälel koos austada Jumalat, meie Issanda Jeesus Kristuse Isa! ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Nõnda siis võtke üksteist vastu, nagu Kristus on teid vastu võtnud, ja andke au Jumalale. ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Ma püsin arvamuse juures, et Kristus tuli teenijana juutide juurde, et näidata, et Jumal räägib tõtt ja peab tõotusi, mille ta nende esiisadele andis. ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Ta tuli ka selleks, et võõramaalased võiksid ülistada Jumalat tema halastuse eest, nagu Pühakiri ütleb: „Seepärast ma ülistan sind võõramaalaste keskel; ma laulan kiitust sinu nimele.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Ja samuti: „Võõramaalased, ülistage koos tema rahvaga!“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Ja veel: „Kõik te võõramaalased, ülistage Issandat, ülistagu teda kõik rahvad.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Ja veel ütleb Jesaja: „Iisai järeltulija hakkab rahvaid valitsema ja võõramaalased panevad temale oma lootuse.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Täitku lootuse Jumal teid täielikult kogu rõõmu ja rahuga, kui te usute temasse, nii et teie lootus oleks Püha Vaimu väes ülevoolav! ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Olen veendunud, et teie, mu vennad ja õed, olete täis headust ning igasuguseid teadmisi, nii et olete hästi võimelised üksteist õpetama. ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Olen teile mõnest teemast kirjutades olnud otsekohene, kuid see on üksnes teile meelde tuletamiseks. Sest Jumal andis mulle armu ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","olla Kristuse Jeesuse teenija võõramaalaste jaoks, nagu preester, kes jagab Jumala head sõnumit, nii et nad võiksid saada vastuvõetavaks ohvrianniks, mille teeb pühaks Püha Vaim. ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Niisiis, isegi kui mul on midagi, millest Jumala teenimise tõttu kiidelda ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","(ma ei söandaks rääkida millestki sellisest, välja arvatud sellest, mida Kristus on minu kaudu teinud), olen juhtinud võõramaalased sõnakuulmise juurde oma õpetuse ja näitliku selgituse abil ning ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","tunnustähtede ja imetegude väe abil, mis on tehtud Püha Vaimu väega. Jeruusalemmast kuni Illüüriani − igal pool olen täielikult jaganud Kristuse head sõnumit. ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Õigupoolest olin innukas jagama head sõnumit kohtades, kus Kristuse nime ei olnud veel kuuldud, et ma ei ehitaks sellele, mida teised olid varem teinud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Nagu Pühakiri ütleb: „Need, kellele ei olnud head sõnumit räägitud, leiavad ta, ja need, kes ei olnud kuulnud, saavad aru.“ ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Seepärast on nii palju kordi mind takistatud, et ma teie juurde ei tuleks. ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Aga nüüd, kui siin kusagil ei ole jäänud tööd teha ja kuna ma olen igatsenud palju aastaid teid külastada, ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","loodan ma Hispaaniasse reisides teid möödaminnes näha. Ehk saate anda mulle abi mu teekonnaks, kui oleme saanud mõnda aega rõõmsalt koos olla. ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Hetkel olen teel Jeruusalemma, et aidata sealseid usklikke, ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","sest usklikud Makedoonias ja Ahhaias arvasid, et on hea mõte saata annetus vaestele Jeruusalemma usklike hulgas. ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Nad tegid seda hea meelega, sest nad on nende võlglased. Nüüd, kui võõramaalased saavad osa nende vaimulikest eesõigustest, on nad selle eest võlgu juudi usklikele, et aidata neid materiaalsete asjadega. ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Niisiis, kui olen saanud selle tehtud ja olen selle annetuse turvaliselt nendeni toimetanud, tulen Hispaaniasse teel olles teile külla. ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Ma tean, et kui ma tulen, annab Kristus meile täieliku õnnistuse. ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Ma tahan julgustada teid, mu vennad ja õed, meie Issanda Jeesuse Kristuse kaudu ja Vaimu armastuse kaudu ühinema koos minu eest tõsiselt palvetama. ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Palvetage, et ma võiksin olla Juudamaal uskmatute eest kaitstud. Palvetage, et Jeruusalemma usklikud võtaksid mu sealse töö hea meelega vastu. ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Palvetage, et tuleksin teie juurde rõõmuga, kui Jumal tahab, et võiksime üksteise seltskonnast rõõmu tunda. ");
INSERT INTO ekkpkp_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Olgu rahu Jumal teie kõikidega. Aamen. ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Ma usaldan teie hoolde õde Foibe, kes on Kenkrea koguduse diakoniss. ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Palun võtke ta vastu Issandas, nagu usklikele kohane, ja aidake teda, milles iganes tal abi vaja on, sest temast on olnud suur abi paljudele, kaasa arvatud mulle. ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Andke mu tervitused edasi Priskale ja Akvilale, mu kaastöölistele Kristuses Jeesuses, ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","kes riskisid minu pärast oma eluga. Peale minu on neile väga tänulikud ka kõik võõramaalaste kogudused. ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Samuti palun andke edasi mu tervitused kogudusele, kes käib koos nende kodus. Andke edasi mu parimad soovid mu heale sõbrale Epainetosele, esimesele inimesele, kes Aasia provintsis hakkas Kristust järgima. ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Andke mu tervitused edasi Maarjale, kes on teie heaks tõsiselt tööd teinud, ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ja ka Andronikosele ja Juniasele, kes on mu kaasmaalased ja kaasvangid. Nad on apostlite hulgas hästi tuntud ja neist said Kristuse järelkäijad enne mind. ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Tervitage minu poolt Ampliatust, mu head sõpra Issandas; ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Urbanust, meie kaastöölist Kristuses, ja mu armast sõpra Stahhüst. ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Minu tervitused Apellesele, usaldusväärsele mehele Kristuses. Tervitused Aristobulose perele, ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","mu kaasmaalasele Heroodionile ja neile Narkissose perest, kes kuuluvad Issandale. ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Mu parimad soovid Trüfainale ja Trüfoosale, tõsistele Issanda heaks töötajatele, ja mu sõbrale Persisele, kes on väga palju Issandas teinud. ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Andke mu tervitused edasi Ruufusele, erakordsele töölisele, ja tema emale, keda ma pean ka enda emaks. ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Tervitused Asünkritosele, Flegonile, Hermesele, Patrobasele, Hermasele ja kaasusklikele, kes on nendega koos. ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Parimad soovid Filologosele ja Juuliale, Neereusele ja tema õele, Olümpasele ning kõigile usklikele, kes on koos nendega. ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Tervitage üksteist südamlikult. Kõik Kristuse kogudused saadavad teile tervitusi. ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Nüüd ma palun teid, mu kaasusklikud: olge ettevaatlikud nende suhtes, kes põhjustavad vaidlusi ja ajavad inimesi segadusse õpetuste suhtes, mida olete õppinud. Hoidke neist eemale! ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Need inimesed ei teeni Kristust, meie Issandat, vaid oma himusid ning petavad pahaaimamatuid inimesi oma libeda jutu ja meeldivate sõnadega. ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Kõik teavad, kui ustavad te olete. See rõõmustab mind väga. Kuid ma soovin, et oleksite arukad selles, mis on hea, ja võhikud kõiges halvas. ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Rahu Jumal purustab varsti Saatana väe ja alistab ta teile. Olgu meie Issanda Jeesuse Kristuse arm teiega. ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Minu kaastööline Timoteos saadab tervitusi, samuti mu kaasmaalased Luukius, Jaason ja Soosipatros. ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Tertius − kes selle kirja kirjutas − saadab teile samuti tervitusi Issandas. ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Minu võõrustaja Gaius ja kogu kogudus siin saadavad teile tervitusi. Linna varahoidja Erastos saadab oma parimad soovid, samuti meie kaasusklik Kvartus. ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Nüüd olgu temale, kes suudab teha teid tugevaks hea sõnumi kaudu, mida ma kuulutan, ja Jeesuse Kristuse sõnumi kaudu, vastavalt tõe saladusele, mis on ilmutatud, igavesti varjatud tõe saladusele, ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","mis nüüd on nähtavaks saanud prohvetite kirjutiste kaudu ja igavese Jumala käsku järgides, tõe saladusele, mis on teatavaks tehtud kõigile igal pool, et nad saaksid temasse uskuda ja talle kuuletuda, ");
INSERT INTO ekkpkp_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","sellele ainsale targale Jumalale, Jeesuse Kristuse kaudu − temale olgu au igavesti. Aamen.");
ALTER TABLE ekkpkp_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
