﻿USE sofia;
DROP TABLE IF EXISTS sofia.ekk_vpl;
CREATE TABLE ekk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ekk_vpl WRITE;
INSERT INTO ekk_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jeesuse Messia, Aabrahami poja, Taaveti poja sugupuu: ");
INSERT INTO ekk_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aabrahamile sündis Iisak, Iisakile sündis Jaakob, Jaakobile sündisid Juuda ja tema vennad. ");
INSERT INTO ekk_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juudale sündisid Taamariga Perets ja Serah, Peretsile sündis Hesron, Hesronile sündis Aram, ");
INSERT INTO ekk_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramile sündis Amminadab, Amminadabile sündis Nahson, Nahsonile sündis Salma, ");
INSERT INTO ekk_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmale sündis Raahabiga Boas, Boasele sündis Rutiga Oobed, Oobedile sündis Iisai, ");
INSERT INTO ekk_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Iisaile sündis kuningas Taavet. Taavetile sündis Uurija naisega Saalomon, ");
INSERT INTO ekk_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Saalomonile sündis Rehabeam, Rehabeamile sündis Abija, Abijale sündis Aasa, ");
INSERT INTO ekk_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aasale sündis Joosafat, Joosafatile sündis Jooram, Jooramile sündis Ussija, ");
INSERT INTO ekk_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ussijale sündis Jootam, Jootamile sündis Aahas, Aahasele sündis Hiskija, ");
INSERT INTO ekk_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hiskijale sündis Manasse, Manassele sündis Aamon, Aamonile sündis Joosija, ");
INSERT INTO ekk_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Joosijale sündisid Jekonja ja tema vennad Paabeli vangipõlve ajal. ");
INSERT INTO ekk_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pärast Paabeli vangipõlve sündis Jekonjale Sealtiel, Sealtielile sündis Serubbaabel, ");
INSERT INTO ekk_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubbaabelile sündis Abihuud, Abihuudile sündis Eljakim, Eljakimile sündis Assur, ");
INSERT INTO ekk_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Assurile sündis Saadok, Saadokile sündis Ahhim, Ahhimile sündis Elihuud, ");
INSERT INTO ekk_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elihuudile sündis Eleasar, Eleasarile sündis Mattan, Mattanile sündis Jaakob. ");
INSERT INTO ekk_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jaakobile sündis Maarja mees Joosep ja Maarjast sündis Jeesus, keda hüütakse Messiaks. ");
INSERT INTO ekk_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Seega on Aabrahamist Taavetini kokku neliteist sugupõlve, Taavetist Paabeli vangipõlveni neliteist sugupõlve ja Paabeli vangipõlvest Messiani neliteist sugupõlve. ");
INSERT INTO ekk_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ent Jeesuse, Messia, sündimisega oli nõnda. Tema ema Maarja oli kihlatud Joosepiga, kuid enne abiellumist ja kokkusaamist selgus, et ta on lapseootel Pühast Vaimust. ");
INSERT INTO ekk_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joosep oli õiglane mees ega tahtnud Maarjat avalikult häbistada, seepärast otsustas ta temast vaikselt lahutada. ");
INSERT INTO ekk_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Aga kui ta seda mõtet kaalus, ilmus talle unenäos Issanda ingel, kes ütles: „Joosep, Taaveti poeg, ära karda Maarjat naiseks võtta! Laps tema ihus on eostunud Pühast Vaimust. ");
INSERT INTO ekk_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Maarja sünnitab poja, kellele sina paned nimeks Jeesus, sest tema päästab oma rahva nende pattudest.“ ");
INSERT INTO ekk_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","See kõik sündis, et läheks täide, mis Issand oli öelnud prohveti suu läbi: ");
INSERT INTO ekk_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","„Pange tähele, neitsi jääb lapseootele ja sünnitab poja, ning talle pannakse nimeks Immanuel“ – mis tähendab „Jumal on meiega“. ");
INSERT INTO ekk_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kui Joosep unest ärkas, tegi ta nii, nagu Issanda ingel oli käskinud. Ta võttis Maarja endale naiseks ja viis ta koju, ");
INSERT INTO ekk_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","kuid ei puutunud temasse, kuni poeg oli sündinud. Ja ta pani temale nimeks Jeesus. ");
INSERT INTO ekk_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Pärast Jeesuse sündimist Petlemmas Juudamaal, kuningas Heroodese valitsusajal, saabusid hommikumaalt pärit tähetargad Jeruusalemma. ");
INSERT INTO ekk_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","„Kus on see laps, kes sündis juutide kuningaks?“ küsisid nad. „Me nägime ta tähte tõusmas ja tulime teda kummardama.“ ");
INSERT INTO ekk_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Seda kuuldes läks kuningas Heroodes ärevile ja kogu Jeruusalemm koos temaga. ");
INSERT INTO ekk_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ta kutsus kokku kõik juutide ülempreestrid ja kirjatundjad ning päris nende käest, kus Messias pidi sündima. ");
INSERT INTO ekk_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Need vastasid talle: „Juudamaa linnas Petlemmas, sest nõnda on prohvet kirjutanud: ");
INSERT INTO ekk_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","„Sina, Petlemm Juudamaal, ei ole vähim Juuda valitsejate seas, sest sinust võrsub Valitseja, kes mu rahvast Iisraeli karjatseb.“ “ ");
INSERT INTO ekk_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Siis kutsus Heroodes tähetargad salaja enda juurde ja uuris neilt välja aja, millal täht oli paistma hakanud. ");
INSERT INTO ekk_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Seejärel läkitas ta nad Petlemma, öeldes: „Minge ja otsige last. Kui te ta leiate, siis teatage mulle, et minagi võiksin minna teda kummardama!“ ");
INSERT INTO ekk_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tähetargad kuulasid kuninga ära ja asusid teele. Ja ennäe, täht, mille tõusu nad olid jälginud, juhatas neid, kuni jäi seisma selle paiga kohal, kus asus laps. ");
INSERT INTO ekk_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Seda nähes rõõmustasid tähetargad väga. ");
INSERT INTO ekk_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nad astusid majja ja nägid last koos tema ema Maarjaga ning kummardusid ta ette maha. Siis avasid nad oma varalaekad ja andsid talle kinke: kulda, viirukit ja mürri. ");
INSERT INTO ekk_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ja saanud unenäos Jumalalt hoiatuse, et nad ei läheks enam Heroodese juurde, pöördusid nad teist teed pidi tagasi oma maale. ");
INSERT INTO ekk_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kui tähetargad olid lahkunud, ilmus Issanda ingel unenäos Joosepile ja ütles: „Tõuse üles, võta kaasa laps ja tema ema! Põgene Egiptusesse ja ole seal, kuni ma sulle ütlen; sest Heroodes hakkab otsima last, et teda hukata.“ ");
INSERT INTO ekk_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Joosep tõusis, võttis kaasa lapse ja tema ema ning põgenes öösel Egiptusesse. ");
INSERT INTO ekk_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Seal viibis ta Heroodese surmani, et läheks täide, mida Issand oli öelnud prohveti kaudu: „Ma kutsusin oma poja Egiptusest.“ ");
INSERT INTO ekk_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kui Heroodes nägi, et tähetargad olid teda petnud, sattus ta suurde raevu. Ta andis käsu hukata kõik poisslapsed Petlemmas ja kogu selle ümbruses: kaheaastased ja alla selle, vastavalt ajale, mille ta oli tähetarkadelt välja uurinud. ");
INSERT INTO ekk_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nii läks täide, mis oli öeldud prohvet Jeremija suu läbi: ");
INSERT INTO ekk_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","„Raamas on kuulda häält, rohket nuttu ja hala. Raahel nutab taga lapsi ega lase end lohutada, sest neid ei ole enam.“ ");
INSERT INTO ekk_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ent pärast Heroodese surma ilmus Issanda ingel Egiptuses viibivale Joosepile unenäos ");
INSERT INTO ekk_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ja ütles: „Tõuse üles, võta kaasa laps ja tema ema ning mine Iisraelimaale! Need, kes lapse elu kallale kippusid, on nüüd surnud!“ ");
INSERT INTO ekk_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Joosep võttis lapse ja tema ema ning läks Iisraelimaale. ");
INSERT INTO ekk_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Aga kui ta kuulis, et Arhelaos valitseb Juudamaad kuningana oma isa Heroodese asemel, kartis ta sinna minna. Ja saanud Jumalalt unenäos hoiatuse, suundus ta Galilea aladele ");
INSERT INTO ekk_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ning asus elama Naatsareti linna. Nii läks täide, mis oli öeldud prohvetite suu läbi: „Teda hüütakse Naatsaretlaseks.“ ");
INSERT INTO ekk_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Neil päevil tuli Ristija Johannes, kes kuulutas Juuda kõrbes ");
INSERT INTO ekk_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ja ütles: „Parandage meelt, sest taevariik on lähedal!“ ");
INSERT INTO ekk_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Temast rääkiski prohvet Jesaja: „Hüüdja hääl on kõrbes: „Valmistage Issandale tee, tehke tasaseks tema teerajad!“ “ ");
INSERT INTO ekk_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Johannesel olid seljas kaamelikarvadest rõivad ja nahkvöö vööl, aga toiduks olid tal rohutirtsud ja metsmesi. ");
INSERT INTO ekk_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Siis läks Jeruusalemma, kogu Juudamaa ja Jordani ümbruskonna rahvas tema juurde. ");
INSERT INTO ekk_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nad tunnistasid üles oma patud ja ta ristis nad Jordani jões. ");
INSERT INTO ekk_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Aga kui ta nägi, kui palju varisere ja sadusere tema juurde ristimisele tuli, ütles ta neile: „Rästikute sugu! Kes teile andis märku põgeneda saabuva viha eest? ");
INSERT INTO ekk_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Seepärast kandke meeleparandusele kohast vilja ");
INSERT INTO ekk_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ja ärge mõtelge endamisi: „Meie isa on Aabraham!“ Sest ma ütlen teile, Jumal võib nendest kividest äratada lapsi Aabrahamile. ");
INSERT INTO ekk_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kirves on juba pandud puude juurte külge. Iga puu, mis ei kanna head vilja, raiutakse maha ja visatakse tulle. ");
INSERT INTO ekk_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mina ristin teid veega meeleparanduseks, aga kes tuleb pärast mind, on minust vägevam. Mina pole väärt tema sandaalegi lahti siduma. Tema ristib teid Püha Vaimu ja tulega. ");
INSERT INTO ekk_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tal on tuulamiskühvel käes ja ta teeb puhtaks oma rehealuse. Ta kogub nisu aita, aga aganad ta põletab ära kustumatu tulega.“ ");
INSERT INTO ekk_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sel ajal saabus Jeesus Galileast Jordani äärde, et Johannes teda ristiks. ");
INSERT INTO ekk_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Johannes püüdis keelduda, öeldes: „Mul on vaja, et sina mind ristiksid, aga sina tuled hoopis minu juurde!“ ");
INSERT INTO ekk_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jeesus aga vastas talle: „Las praegu olla nii! Nõnda on meil kohane täita kõike, mis on õige!“ Siis Johannes andis talle järele. ");
INSERT INTO ekk_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kui Jeesus oli ristitud, väljus ta kohe veest, ja ennäe, taevas avanes ning ta nägi Jumala Vaimu otsekui tuvi alla laskumas ja tema peale tulemas. ");
INSERT INTO ekk_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ning taevast kostis hääl: „See on minu armas Poeg, kelle üle mul on hea meel!“ ");
INSERT INTO ekk_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Siis juhtis Vaim Jeesuse kõrbe kuradi kiusata. ");
INSERT INTO ekk_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kui ta oli nelikümmend päeva ja nelikümmend ööd paastunud, tuli talle nälg. ");
INSERT INTO ekk_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Talle lähenes kiusaja ning ütles: „Kui sa oled Jumala Poeg, siis käsi sellel kivil siin muutuda leivaks!“ ");
INSERT INTO ekk_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jeesus vastas: „Kirjutatud on: „Inimene ei ela üksnes leivast, vaid igast sõnast, mis lähtub Jumala suust.“ “ ");
INSERT INTO ekk_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Siis viis kurat ta pühasse linna, pani seisma templi katusele ");
INSERT INTO ekk_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ja ütles: „Kui sa oled Jumala Poeg, siis kukuta end siit alla! Sest kirjutatud on: „Sinu pärast annab ta oma inglitele käsu ja nemad kannavad sind kätel, et sa oma jalga vastu kivi ei lööks.“ “ ");
INSERT INTO ekk_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jeesus vastas talle: „Samuti on kirjutatud: „Ära pane Issandat, oma Jumalat, proovile!“ “ ");
INSERT INTO ekk_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Veel võttis kurat ta kaasa väga kõrge mäe otsa ja näitas talle kõiki maailma kuningriike ja nende hiilgust. ");
INSERT INTO ekk_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","„Need kõik ma annan sulle,“ ütles ta, „kui sa ainult maha langed ja mind ülistad.“ ");
INSERT INTO ekk_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Siis ütles Jeesus talle: „Hoia minust eemale, saatan! Kirjutatud on: „Kummarda Issandat, oma Jumalat, ja teeni ainult teda!“ “ ");
INSERT INTO ekk_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Siis jättis kurat ta rahule. Seejärel tulid tema juurde inglid ja teenisid teda. ");
INSERT INTO ekk_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kui Jeesus kuulis, et Johannes on kinni võetud, läks ta tagasi Galileasse. ");
INSERT INTO ekk_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ta lahkus Naatsaretist ja asus elama Kapernauma, mis on järve ääres Sebuloni ja Naftali aladel. ");
INSERT INTO ekk_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nõnda läks täide, mis oli öeldud prohvet Jesaja suu läbi: ");
INSERT INTO ekk_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","„Sebulonimaa ja Naftalimaa, teel mere äärde, piki Jordanit, rahvaste Galilea, ");
INSERT INTO ekk_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","rahvas, kes elab pimeduses, on suurt valgust näinud; neile, kes on elanud surma varjus, on koitnud valgus.“ ");
INSERT INTO ekk_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sellest ajast peale hakkas Jeesus kuulutama: „Parandage meelt, sest taevariik on lähedal!“ ");
INSERT INTO ekk_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kõndides Galilea mere rannal, nägi Jeesus kaht venda, Siimonit, hüüdnimega Peetrus, ja tema venda Andreast võrku merre heitmas, sest nad olid kalurid. ");
INSERT INTO ekk_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jeesus ütles neile: „Järgnege mulle ja ma teen teist inimestepüüdjad!“ ");
INSERT INTO ekk_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nad jätsid kohe oma võrgud ja järgnesid talle. ");
INSERT INTO ekk_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sealt edasi minnes nägi ta veel kaht venda, Sebedeuse poega Jaakobust ja tema venda Johannest koos isaga paadis võrke parandamas. Jeesus kutsus ka neid. ");
INSERT INTO ekk_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kohe jätsid nad paadi ja isa maha ning järgnesid talle. ");
INSERT INTO ekk_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ja Jeesus rändas ringi kogu Galileas, õpetas sünagoogides, kuulutas evangeeliumi Kuningriigist ning tervendas rahvast igasugustest haigustest ja hädadest. ");
INSERT INTO ekk_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kuuldus temast levis kogu Süürias ning tema juurde toodi kõik, kes kannatasid mitmesuguste haiguste ja valude käes, kurjadest vaimudest vaevatuid, langetõbiseid ja halvatuid – ning tema tegi nad terveks. ");
INSERT INTO ekk_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ja Jeesuse kannul käis suur rahvahulk Galileast, Dekapolisest, Jeruusalemmast, Juudamaalt ja Jordani tagant. ");
INSERT INTO ekk_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kui Jeesus nägi rahvahulka, läks ta üles mäele, ja kui ta oli maha istunud, tulid jüngrid tema juurde. ");
INSERT INTO ekk_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ta hakkas neid õpetama: ");
INSERT INTO ekk_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","„Õnnistatud on vaimust vaesed, sest nende päralt on taevariik. ");
INSERT INTO ekk_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Õnnistatud on kurvad, sest neid lohutatakse. ");
INSERT INTO ekk_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Õnnistatud on tasased, sest nemad pärivad maa. ");
INSERT INTO ekk_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Õnnistatud on need, kellel on nälg ja janu õiguse järele, sest nad saavad külluslikult. ");
INSERT INTO ekk_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Õnnistatud on halastajad, sest nende peale halastatakse. ");
INSERT INTO ekk_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Õnnistatud on puhtad südamelt, sest nemad näevad Jumalat. ");
INSERT INTO ekk_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Õnnistatud on rahutegijad, sest neid hüütakse Jumala lasteks. ");
INSERT INTO ekk_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Õnnistatud on need, keda õiguse pärast taga kiusatakse, sest nende päralt on taevariik. ");
INSERT INTO ekk_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Õnnistatud olete teie, kui teid minu pärast teotatakse, taga kiusatakse ja teie kohta kõiksugu kurje asju valetatakse. ");
INSERT INTO ekk_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Rõõmutsege ja hõisake, sest teie tasu on suur taevas! Samal viisil on taga kiusatud ka prohveteid enne teid. ");
INSERT INTO ekk_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Teie olete maa sool. Aga kui sool kaotab maitse, kuidas teha seda soolaseks? See ei kõlba enam millekski ja visatakse välja inimeste tallata. ");
INSERT INTO ekk_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Teie olete maailma valgus. Linn, mis on mäe otsas, ei jää märkamatuks. ");
INSERT INTO ekk_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Samuti ei süüta keegi lampi, et panna see vaka alla, vaid ikka lambijalale; siis särab see kõigile majasolijatele. ");
INSERT INTO ekk_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nõnda paistku teiegi valgus inimestele, et nad näeksid teie häid tegusid ja kiidaksid teie Isa, kes on taevas. ");
INSERT INTO ekk_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ärge arvake, et ma olen tulnud Seadust või Prohveteid tühistama – ma ei ole tulnud neid tühistama, vaid täide viima! ");
INSERT INTO ekk_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tõesti, ma ütlen teile, enne kaovad taevas ja maa, aga Seadusest ei kao ükski täht ega kriips, enne kui kõik on sündinud. ");
INSERT INTO ekk_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Seepärast, kes vähimatki käsusõnadest rikub ja õpetab teisi sama tegema, seda hüütakse vähimaks taevariigis; aga kes neid täidab ja õpetab, seda hüütakse suureks taevariigis. ");
INSERT INTO ekk_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ma ütlen teile, kui teie pole kirjatundjatest ja variseridest õigemad, siis te ei pääse taevariiki. ");
INSERT INTO ekk_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Te olete kuulnud, et muistsele põlvele on öeldud: „Sa ei tohi tappa! Ja igaüks, kes tapab, peab minema kohtu alla.“ ");
INSERT INTO ekk_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kuid mina ütlen teile, et igaüks, kes oma venna peale viha kannab, peab minema kohtu alla. Aga kes oma vennale ütleb: „Tühine!“, peab minema ülemkohtu alla, ja kes ütleb: „Loll!“, peab minema põrgutulle. ");
INSERT INTO ekk_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Seepärast, kui sa oma anni ohvrialtarile tood ja seal sulle meenub, et su vennal on midagi sinu vastu, ");
INSERT INTO ekk_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","siis jäta oma ohver altari ette ja mine lepi enne ära oma vennaga. Alles siis tule ja too oma ohvriand. ");
INSERT INTO ekk_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ole järeleandlik oma vastasega, kes sind kohtusse viib. Lepi temaga ära, kuni te veel teel olete, et ta ei annaks sind kohtuniku kätte ja kohtunik kohtuteenri kätte ja sind ei heidetaks vangi! ");
INSERT INTO ekk_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tõesti, ma ütlen sulle, sa ei pääse sealt enne, kuni sa oled tagasi maksnud viimsegi veeringu. ");
INSERT INTO ekk_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Te olete kuulnud, et on öeldud „Sa ei tohi abielu rikkuda!“ ");
INSERT INTO ekk_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kuid mina ütlen teile, et igaüks, kes võõrast naist vaatab teda himustades, on oma südames temaga juba abielu rikkunud. ");
INSERT INTO ekk_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kui aga su parem silm ahvatleb sind patule, siis võta see välja ja viska ära. Sul on parem kaotada üks ihuliige kui olla terve ihuga heidetud põrgusse. ");
INSERT INTO ekk_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ja kui su parem käsi ahvatleb sind patule, siis raiu see küljest ja viska ära, sest sul on parem kaotada üks ihuliige kui minna terve ihuga põrgusse. ");
INSERT INTO ekk_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Öeldud on: „Kes oma naisest lahutab, andku talle lahutustunnistus!“ ");
INSERT INTO ekk_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kuid mina ütlen teile, et igaüks, kes lahutab oma naisest muul põhjusel kui abielurikkumine, teeb temast abielurikkuja. Ja kes abiellub lahutatud naisega, rikub abielu. ");
INSERT INTO ekk_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Samuti olete kuulnud, et muistsele põlvele on öeldud: „Ära murra oma vandetõotusi, vaid täida oma lubadused Issandale!“ ");
INSERT INTO ekk_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kuid mina ütlen teile, et te ei vannuks üldse: ei taeva nimel, sest see on Jumala troon; ");
INSERT INTO ekk_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ega maa nimel, sest see on tema jalgealune järg; ega Jeruusalemma nimel, sest see on suure Kuninga linn! ");
INSERT INTO ekk_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ära vannu ka oma pea nimel, sest ise ei saa ühtegi juuksekarva mustaks või valgeks teha. ");
INSERT INTO ekk_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Teie „jah“ olgu „jah“ ja teie „ei“ olgu „ei“. Kõik, mis sellele lisatakse, on kurjast. ");
INSERT INTO ekk_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Te olete kuulnud, et on öeldud: „Silm silma ja hammas hamba vastu!“ ");
INSERT INTO ekk_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kuid mina ütlen teile, ärge hakake vastu inimesele, kes teile kurja teeb! Kui keegi lööb sind paremale põsele, keera ka vasak tema poole! ");
INSERT INTO ekk_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ja sellele, kes tahab sind kohtusse kaevata ja su särgi võtta, anna ka kuub! ");
INSERT INTO ekk_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ja kui keegi sunnib sind käima ühe miili, mine temaga kaks! ");
INSERT INTO ekk_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Anna, kui sinult palutakse, ja ära keeldu, kui sinult tahetakse laenata! ");
INSERT INTO ekk_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Te olete kuulnud, et on öeldud: „Armasta oma ligimest ja vihka oma vaenlast!“ ");
INSERT INTO ekk_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kuid mina ütlen teile, armastage oma vaenlasi ja palvetage nende eest, kes teid taga kiusavad. ");
INSERT INTO ekk_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Siis te olete tõesti oma taevase Isa lapsed; sest tema laseb oma päikesel tõusta nii kurjade kui heade üle ning vihma sadada ühtviisi õiglaste ja ülekohtuste peale. ");
INSERT INTO ekk_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Sest kui te armastate neid, kes teid armastavad, mis tasu te siis ootate? Eks maksukogujad tee ju sama? ");
INSERT INTO ekk_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ja kui te ainult oma sõpru lahkelt tervitate, mis selles erilist on? Eks paganadki tee sedasama? ");
INSERT INTO ekk_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Seepärast olge täiuslikud, nagu teie taevane Isa on täiuslik! ");
INSERT INTO ekk_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Vaadake, et te oma häid tegusid ei teeks inimestele näitamise pärast, muidu ei ole teil tasu oma Isalt, kes on taevas! ");
INSERT INTO ekk_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kui sa nüüd annad neile, kel puudus, siis ära kuuluta sellest pasunahüüuga, nagu silmakirjatsejad teevad sünagoogides ja tänavail, et inimesed neid kiidaksid. Tõesti, ma ütlen teile, neil on oma tasu juba käes! ");
INSERT INTO ekk_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aga kui sina annad, ärgu su vasak käsi teadku, mida su parem käsi teeb! ");
INSERT INTO ekk_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Jäägu su heategu salajasse, ja su Isa, kes näeb salajasse, tasub sulle. ");
INSERT INTO ekk_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ja kui te palvetate, siis ärge olge nagu silmakirjatsejad, kes armastavad palvetada sünagoogides ja tänavanurkadel, et olla inimestele nähtavad! Tõesti, ma ütlen teile, neil on oma tasu juba käes! ");
INSERT INTO ekk_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Aga kui sina palvetad, siis mine oma kambrisse, sule uks ja palveta oma Isa poole salajas. Ja sinu Isa, kes näeb salajasse, tasub sulle! ");
INSERT INTO ekk_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Palvetades ärge lobisege nagu paganad, kes arvavad, et neid võetakse kuulda nende sõnarohkuse tõttu. ");
INSERT INTO ekk_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ärge saage nende sarnaseks! Teie Isa ju teab, mida te vajate, enne kui te temalt palute. ");
INSERT INTO ekk_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Palvetage siis nõnda: Meie Isa, kes sa oled taevas! Pühitsetud olgu sinu nimi! ");
INSERT INTO ekk_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Sinu riik tulgu, sinu tahtmine sündigu nagu taevas, nõnda ka maa peal! ");
INSERT INTO ekk_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Meie igapäevast leiba anna meile tänapäev! ");
INSERT INTO ekk_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ja anna meile andeks meie võlad, nagu meiegi andeks anname oma võlglastele! ");
INSERT INTO ekk_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ja ära saada meid kiusatusse, vaid päästa meid ära kurjast! Sest sinu päralt on riik ja vägi ja au igavesti. Aamen. ");
INSERT INTO ekk_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Sest kui te annate teistele andeks nende eksimused, siis annab ka teie Isa, kes on taevas, teile andeks. ");
INSERT INTO ekk_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kui te aga ei anna teistele andeks, siis ei anna ka teie Isa teie eksimusi teile andeks. ");
INSERT INTO ekk_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Kui te paastute, siis ärge olge mornid nagu silmakirjatsejad, kes teevad sellise näo, et inimestele oleks nähtav nende paastumine. Tõesti, ma ütlen teile, neil on oma tasu juba käes! ");
INSERT INTO ekk_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Aga kui sina paastud, siis korrasta oma juuksed ja pese nägu, ");
INSERT INTO ekk_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","et su paastumine ei oleks nähtav inimestele, vaid su Isale, kes on varjatud. Ja su Isa, kes näeb varjatutki, tasub sulle avalikult! ");
INSERT INTO ekk_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ärge koguge endale varandust maa peale, kus koi ja rooste seda hävitavad ja kuhu vargad sisse murravad ja varastavad! ");
INSERT INTO ekk_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Koguge endile varandust taevasse, kus koi ega rooste seda ei hävita ja kuhu vargad sisse ei murra ega varasta. ");
INSERT INTO ekk_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sest kus on su varandus, seal on ka su süda! ");
INSERT INTO ekk_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Silm on ihu lamp. Kui su silm on hea, on su ihu täidetud valgusega. ");
INSERT INTO ekk_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Aga kui su silm on kuri, on su ihu täidetud pimedusega. Kui valgus sinu sees on pime, kui suur on siis pimedus? ");
INSERT INTO ekk_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Keegi ei saa teenida kahte isandat, sest ta kas vihkab üht ja armastab teist või kiindub ühesse ja jälestab teist. Teiegi ei saa teenida korraga Jumalat ja mammonat. ");
INSERT INTO ekk_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Seepärast ma ütlen teile, ärge muretsege oma elu pärast, mida süüa või juua, ega ihu pärast, mida selga panna! Eks elu ole enam kui toit ja ihu enam kui rõivad? ");
INSERT INTO ekk_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Vaadake linde taevas! Nad ei külva ega lõika ega kogu aita saaki, ning teie taevane Isa toidab neid. Kui palju enam väärt nendest olete teie! ");
INSERT INTO ekk_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aga kes teie seast suudaks muretsemisega ennast ühe küünragi pikemaks teha? ");
INSERT INTO ekk_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ja miks te muretsete riiete pärast? Pange tähele, kuidas kasvavad lilled aasal! Nad ei näe vaeva ketramisega, ");
INSERT INTO ekk_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","kuid ma ütlen teile, et isegi Saalomon kogu oma hiilguses ei olnud riietatud nii nagu igaüks neist. ");
INSERT INTO ekk_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kui aga Jumal riietab rohu väljal nii, mis täna on siin ja homme heidetakse tulle, kui palju enam ta riietab siis teid, te nõdrausulised! ");
INSERT INTO ekk_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ärge siis enam muretsege, öeldes: „Mida me sööme?“ või „Mida me joome?“ või „Mida me selga paneme?“ ");
INSERT INTO ekk_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Selle pärast muretsevad paganad. Teie taevane Isa teab ju, et te seda kõike vajate. ");
INSERT INTO ekk_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Aga otsige esmalt Jumala riiki ja tema õigust, siis seda kõike antakse teile pealegi! ");
INSERT INTO ekk_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ärge siis muretsege homse pärast, sest homme muretseb ise enda eest. Igale päevale piisab oma vaevast. ");
INSERT INTO ekk_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ärge mõistke kohut, et teie üle ei mõistetaks kohut! ");
INSERT INTO ekk_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sest samamoodi, nagu teie teiste üle kohut mõistate, mõistetakse kohut teiegi üle, ja nõnda nagu teie teistele mõõdate, mõõdetakse teile. ");
INSERT INTO ekk_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Miks sa näed pindu oma venna silmas, aga palki enda silmas ei märka? ");
INSERT INTO ekk_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Või kuidas sa võid oma vennale öelda: „Lase ma tõmban pinnu sinu silmast välja!“ ja sul endal on silmas palk? ");
INSERT INTO ekk_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Silmakirjatseja, tõmba esmalt palk oma silmast välja, ja siis sa näed ka pindu oma venna silmast välja tõmmata! ");
INSERT INTO ekk_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ärge andke koertele seda, mis on püha, ärge heitke oma pärleid sigade ette! Et nad neid ei tallaks jalgade alla ega pöörduks tagasi ja teid tükkideks ei rebiks! ");
INSERT INTO ekk_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Küsige, ja teile antakse; otsige, ja te leiate; koputage uksele, ja teile avatakse! ");
INSERT INTO ekk_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Igaüks, kes palub, see saab; kes otsib, see leiab; ja kes koputab, sellele avatakse. ");
INSERT INTO ekk_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kas teie seas on kedagi, kes annaks oma pojale kivi, kui poeg palub temalt leiba? ");
INSERT INTO ekk_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Või annaks mao, kui poeg palub temalt kala? ");
INSERT INTO ekk_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kui nüüd teie, kes te olete kurjad, oskate anda häid ande oma lastele, kui palju enam teie Isa taevas annab häid asju neile, kes teda paluvad! ");
INSERT INTO ekk_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kõike siis, mida te iganes tahate, et inimesed teile teeksid, tehke ka neile! See ongi Seaduse ja Prohvetite sõnumi sisu. ");
INSERT INTO ekk_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Minge sisse kitsast väravast, sest lai on värav ja avar on tee, mis viib hukatusse, ja palju on neid, kes sealtkaudu lähevad. ");
INSERT INTO ekk_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kuid väike on värav ja kitsas on tee, mis viib ellu, ja vähe on neid, kes selle leiavad. ");
INSERT INTO ekk_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Hoiduge valeprohvetitest, kes tulevad teie juurde lambanahas, aga tegelikult on nad aplad hundid. ");
INSERT INTO ekk_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Te tunnete nad ära nende viljast. Ei korjata ju viinamarju kibuvitstest ega viigimarju ohakaist? ");
INSERT INTO ekk_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nii kannab siis iga hea puu head vilja, aga halb puu halba vilja. ");
INSERT INTO ekk_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Hea puu ei saa kanda halba vilja ega halb puu kanda head vilja. ");
INSERT INTO ekk_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Iga puu, mis ei kanna head vilja, raiutakse maha ja visatakse tulle. ");
INSERT INTO ekk_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Seega te tunnete nad ära nende viljast! ");
INSERT INTO ekk_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mitte igaüks, kes mulle ütleb: „Issand, Issand!“, ei saa taevariiki. Saab vaid see, kes teeb mu Isa tahtmist, kes on taevas. ");
INSERT INTO ekk_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Paljud ütlevad mulle sel päeval: „Issand, Issand, kas me ei ole sinu nimel prohveteerinud ega ajanud sinu nimel välja kurje vaime ega teinud sinu nimel palju imesid?“ ");
INSERT INTO ekk_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Siis ma tunnistan neile: „Ma ei ole teid kunagi tundnud. Minge ära, te ülekohtutegijad!“ ");
INSERT INTO ekk_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Seepärast igaüks, kes neid mu sõnu kuuleb ja nende järgi teeb, on kui arukas mees, kes ehitas oma maja kaljule. ");
INSERT INTO ekk_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kui sadas paduvihma, tõusid marutuul ja tulvavesi ning langesid selle maja peale, siis see ei varisenud, sest see oli rajatud kaljule. ");
INSERT INTO ekk_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ent igaüks, kes neid mu sõnu kuuleb, aga nende järgi ei tee, on võrreldav rumala mehega, kes ehitas oma maja liivale. ");
INSERT INTO ekk_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kui sadas paduvihma, tõusid marutuul ja tulvavesi ning langesid maja peale, siis see varises ja selle häving oli suur.“ ");
INSERT INTO ekk_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kui Jeesus need kõned lõpetas, oli rahvas tema õpetusest vapustatud, ");
INSERT INTO ekk_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","sest ta õpetas nagu see, kellel on meelevald, aga mitte nagu kirjatundjad. ");
INSERT INTO ekk_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kui Jeesus tuli mäelt alla, järgnes talle suur rahvahulk. ");
INSERT INTO ekk_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tema juurde astus pidalitõbine, põlvitas ta ette ja ütles: „Issand, kui sa tahad, siis sa võid mu puhtaks teha!“ ");
INSERT INTO ekk_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jeesus sirutas käe, puudutas teda ja ütles: „Ma tahan, saa puhtaks!“ Ja mees sai otsekohe pidalitõvest puhtaks. ");
INSERT INTO ekk_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Siis ütles Jeesus talle: „Vaata, et sa sellest kellelegi ei räägi, vaid mine näita ennast preestrile ja vii neile tunnistuseks ohvriand, nagu Mooses on käskinud!“ ");
INSERT INTO ekk_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kui Jeesus jõudis Kapernauma, tuli ta juurde sadakonna ülem ja palus abi: ");
INSERT INTO ekk_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","„Issand, mu teener lebab kodus halvatuna suurtes piinades!“ ");
INSERT INTO ekk_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","„Kas ma pean tulema ja ta terveks tegema?“ küsis Jeesus. ");
INSERT INTO ekk_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","„Issand,“ vastas sadakonna ülem talle, „ma ei ole väärt, et sina minu katuse alla tuleksid. Anna vaid käsk ja mu teener paraneb! ");
INSERT INTO ekk_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mina ise olen ju samuti võimu alla seatud ja minule alluvad sõdurid. Kui ma ütlen ühele neist: „Mine!“, siis ta läheb. Ma ütlen teisele: „Tule!“ ja ta tuleb. Ma ütlen oma teenrile: „Tee seda!“ ja ta teeb.“ ");
INSERT INTO ekk_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Seda kuuldes Jeesus imestas ja ütles neile, kes ta järel käisid: „Tõesti, ma ütlen teile, sellist usku ei ole ma leidnud Iisraelis veel kellelgi. ");
INSERT INTO ekk_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ma ütlen teile, et paljud tulevad idast ja läänest ning istuvad taevariigis pidulauda koos Aabrahami, Iisaki ja Jaakobiga. ");
INSERT INTO ekk_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kuningriigi sünnijärgsed alamad aga heidetakse välja pimedusse, kus on ulgumine ja hammaste kiristamine.“ ");
INSERT INTO ekk_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nüüd ütles Jeesus sadakonna ülemale: „Mine! Sündigu sulle nõnda, nagu sa oled uskunud!“ Ülema teener sai samal tunnil terveks. ");
INSERT INTO ekk_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kui Jeesus jõudis Peetruse majja, nägi ta tema ämma voodis lebamas palavikus. ");
INSERT INTO ekk_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jeesus võttis naisel käest kinni, ja palavik lahkus temast, ning ta tõusis üles ja kattis talle laua. ");
INSERT INTO ekk_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Õhtu saabudes toodi Jeesuse juurde palju kurjadest vaimudest vaevatuid, ja ta ajas neist vaimud välja sõnaga ning tegi terveks kõik haiged. ");
INSERT INTO ekk_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nii läks täide, mis oli öeldud prohvet Jesaja suu läbi: „Ta võttis enese peale meie haigused ja kandis meie tõved.“ ");
INSERT INTO ekk_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nähes rahvahulka enda ümber, käskis Jeesus sõita järve teisele kaldale. ");
INSERT INTO ekk_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Üks kirjatundja astus tema juurde ja ütles: „Õpetaja, ma järgnen sulle, kuhu sa iganes lähed!“ ");
INSERT INTO ekk_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jeesus vastas talle: „Rebastel on urud ja lindudel pesad, aga Inimese Pojal ei ole, kuhu oma pead panna.“ ");
INSERT INTO ekk_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Üks teine jünger ütles Jeesusele: „Issand, luba mul esmalt minna isa matma!“ ");
INSERT INTO ekk_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jeesus ütles talle: „Järgne mulle, las surnud matta ise oma surnuid!“ ");
INSERT INTO ekk_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Siis astus Jeesus paati ja ta jüngrid järgnesid talle. ");
INSERT INTO ekk_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Äkki tõusis järvel suur torm, nii et lained lõid üle paadi; Jeesus aga magas. ");
INSERT INTO ekk_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jüngrid tulid tema juurde ja äratasid ta üles, hüüdes: „Issand, päästa meid, me upume!“ ");
INSERT INTO ekk_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","„Teie nõdrausulised, miks te nii hirmul olete?“ vastas Jeesus. Siis tõusis ta üles, sõitles tuult ja laineid ning kõik jäi täiesti vaikseks. ");
INSERT INTO ekk_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Inimesed aga imestasid, öeldes: „Mis mees see küll on, et isegi tuul ja lained talle kuuletuvad?“ ");
INSERT INTO ekk_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kui Jeesus jõudis teisele kaldale gerasalaste maale, tulid talle vastu kaks hauakoopaist väljunud kurjast vaimust vaevatud meest, kes olid nii vägivaldsed, et keegi ei julgenud seda teed käia. ");
INSERT INTO ekk_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Need karjusid: „Mis on sul meiega asja, Jumala Poeg? Kas sa oled tulnud meid piinama enne määratud aega?“ ");
INSERT INTO ekk_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aga eemal oli suur seakari söömas. ");
INSERT INTO ekk_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kurjad vaimud anusid Jeesust: „Kui sa meid välja ajad, siis saada meid selle seakarja sisse!“ ");
INSERT INTO ekk_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","„Minge!“ ütles Jeesus neile. Need tulid välja ja läksid sigadesse. Ja ennäe, kogu kari tormas järsakult järve ja uppus! ");
INSERT INTO ekk_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Karjased aga põgenesid, läksid linna ja rääkisid kõigest, ka sellest, mis oli juhtunud kurjast vaimust vaevatud meestega. ");
INSERT INTO ekk_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ja kogu linnarahvas tuli Jeesusele vastu. Teda nähes palusid nad, et ta nende aladelt lahkuks. ");
INSERT INTO ekk_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jeesus astus paati, sõitis teisele poole järve ja läks oma kodulinna. ");
INSERT INTO ekk_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Seal toodi tema juurde halvatu, kes lamas oma magamisasemel. Nähes nende usku, ütles Jeesus halvatule: „Ole julge, poeg! Sinu patud on sulle andeks antud!“ ");
INSERT INTO ekk_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Siis mõned kirjatundjad mõtlesid endamisi: „See mees teotab Jumalat!“ ");
INSERT INTO ekk_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jeesus aga, teades nende mõtteid, küsis neilt: „Miks te mõtlete kurja oma südames? ");
INSERT INTO ekk_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kumb on kergem, kas öelda „Sinu patud on andeks antud“ või „Tõuse üles ja kõnni“? ");
INSERT INTO ekk_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Aga teadke, et Inimese Pojal on meelevald patte andeks anda maa peal.“ Ja ta ütles halvatule: „Tõuse üles, võta oma ase ja mine koju!“ ");
INSERT INTO ekk_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ning mees tõusis ja läks koju. ");
INSERT INTO ekk_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Seda nähes oli rahvas hämmastuses ja nad ülistasid Jumalat, kes on andnud inimestele sellise meelevalla. ");
INSERT INTO ekk_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Sealt edasi minnes nägi Jeesus meest nimega Matteus maksukoguja pingil istumas ning ütles talle: „Järgne mulle!“ Ja ta tõusis ja järgnes talle. ");
INSERT INTO ekk_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kui siis Jeesus istus lauas tema kodus, tuli sinna palju maksukogujaid ja patuseid ning sõid koos Jeesuse ja tema jüngritega. ");
INSERT INTO ekk_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Seda nähes küsisid variserid tema jüngritelt: „Miks teie õpetaja sööb koos maksukogujate ja patustega?“ ");
INSERT INTO ekk_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Seda kuuldes ütles Jeesus: „Arsti ei vaja terved, vaid haiged. ");
INSERT INTO ekk_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Minge ja õppige, mida tähendab „Ma soovin halastust, mitte ohvrit“. Mina ei ole tulnud kutsuma õigeid, vaid patuseid.“ ");
INSERT INTO ekk_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Siis tulid Johannese jüngrid Jeesuse juurde ja küsisid: „Miks meie ja variserid paastume, aga sinu jüngrid ei paastu?“ ");
INSERT INTO ekk_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jeesus vastas neile: „Ei sobi pulmalistel leinata ajal, kui peigmees on nendega. Ent tuleb aeg, mil peigmees neilt ära võetakse, küll nad siis paastuvad. ");
INSERT INTO ekk_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Keegi ei paika vanutamata riidetükiga vana kuube. Säärane paik rebeneks küljest ja käristaks augu veel suuremaks. ");
INSERT INTO ekk_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Samuti ei valata värsket veini vanadesse nahklähkritesse, muidu lähkrid lõhkevad, vein voolab maha ja lähkreid ei saa enam kasutada. Värske vein valatakse uutesse lähkritesse, siis säilivad mõlemad.“ ");
INSERT INTO ekk_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Kui ta seda neile rääkis, tuli tema juurde sünagoogi ülem, põlvitas ta ette ja ütles: „Just praegu suri mu tütar, aga tule, pane oma käsi ta peale, siis ta ärkab ellu!“ ");
INSERT INTO ekk_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jeesus tõusis ja järgnes talle koos oma jüngritega. ");
INSERT INTO ekk_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ja näe, üks naine, kes oli kannatanud verejooksu juba kaksteist aastat, lähenes Jeesusele selja tagant ja puudutas ta kuue serva, ");
INSERT INTO ekk_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","öeldes endamisi: „Kui ma võiksin puudutada kasvõi tema kuube, siis ma saaksin terveks!“ ");
INSERT INTO ekk_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jeesus aga pöördus ümber, nägi teda ja ütles: „Ole julge, tütar! Sinu usk on sind terveks teinud!“ Ja sellest tunnist alates oli naine terve. ");
INSERT INTO ekk_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kui nüüd Jeesus jõudis sünagoogi ülema majja ning nägi flöödimängijaid ja häälekat rahvahulka, ");
INSERT INTO ekk_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ütles ta: „Minge ära! Tüdruk ei ole surnud, vaid magab!“ Aga nad naersid tema üle. ");
INSERT INTO ekk_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ent kui rahvahulk oli välja aetud, astus Jeesus tuppa, võttis tüdruku käest kinni ja ta ärkas üles. ");
INSERT INTO ekk_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ja kuuldus sellest levis kogu ümbruskonnas. ");
INSERT INTO ekk_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kui Jeesus läks sealt edasi, järgnesid talle kaks pimedat, kes hüüdsid: „Taaveti Poeg, halasta meie peale!“ ");
INSERT INTO ekk_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kui Jeesus oli majja astunud, tulid pimedad tema juurde ja ta küsis neilt: „Kas te usute, et ma suudan seda teha?“ „Jah, Issand,“ vastasid nad talle. ");
INSERT INTO ekk_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Siis Jeesus puudutas nende silmi ja ütles: „Teile sündigu teie usku mööda!“ ");
INSERT INTO ekk_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ja nende silmad avanesid. Nüüd Jeesus hoiatas neid karmilt: „Vaadake, et keegi sellest teada ei saa!“ ");
INSERT INTO ekk_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nemad aga läksid ja rääkisid sellest terves ümbruskonnas. ");
INSERT INTO ekk_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kui nad olid lahkunud, siis toodi tema juurde tumm mees, kes oli kurjast vaimust vaevatud. ");
INSERT INTO ekk_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jeesus ajas kurja vaimu välja ja tumm hakkas rääkima. „Sellist asja pole Iisraelis veel nähtud!“ imestas rahvas. ");
INSERT INTO ekk_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Variserid aga ütlesid: „Ta ajab kurje vaime välja kurjade vaimude valitseja abil!“ ");
INSERT INTO ekk_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ja Jeesus käis läbi kõik linnad ja külad, õpetades sünagoogides, kuulutas evangeeliumi Kuningriigist ning tervendas igasugustest haigustest ja hädadest. ");
INSERT INTO ekk_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Rahvahulki nähes tundis ta neile kaasa, sest nad olid rõhutud ja räsitud nagu lambad, kellel pole karjast. ");
INSERT INTO ekk_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Siis ta ütles oma jüngritele: „Lõikus on suur, aga töötegijaid on vähe. ");
INSERT INTO ekk_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Seepärast paluge lõikuse Issandat, et ta saadaks töötegijaid välja oma lõikusele!“ ");
INSERT INTO ekk_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jeesus kutsus oma kaksteist jüngrit enda juurde ja andis neile meelevalla rüvedaid vaime välja ajada ning parandada kõiki haigusi ja hädasid. ");
INSERT INTO ekk_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nende kaheteistkümne apostli nimed olid: kõigepealt Siimon, keda hüüti Peetruseks, ja tema vend Andreas, siis Sebedeuse poeg Jaakobus ja tema vend Johannes, ");
INSERT INTO ekk_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filippus ja Bartolomeus, Toomas ja maksukoguja Matteus, Alfeuse poeg Jaakobus ja Taddeus, ");
INSERT INTO ekk_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Siimon Kaanalane ja Juudas Iskariot – Jeesuse äraandja. ");
INSERT INTO ekk_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jeesus läkitas välja need kaksteist, juhendades neid nõnda: „Ärge minge teiste rahvaste sekka ega astuge ühessegi samaarlaste linna. ");
INSERT INTO ekk_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Vaid minge kadunud lammaste, Iisraeli rahva juurde! ");
INSERT INTO ekk_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Minnes kuulutage: „Taevariik on lähedal!“ ");
INSERT INTO ekk_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tehke terveks haiged, äratage üles surnud, tehke puhtaks pidalitõbised, ajage välja kurjad vaimud! Ilma olete saanud, ilma ka andke! ");
INSERT INTO ekk_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ärge võtke kaasa kuld-, hõbe- ega vaskraha oma vöö vahele, ");
INSERT INTO ekk_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ei reisipauna ega teist särki ega jalatseid ega keppi. Sest töötegija on oma ülalpidamist väärt! ");
INSERT INTO ekk_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kui te lähete mõnda külasse või linna, siis kuulake järele, kes on selles paigas väärt teid võõrustama, ja tema juurde jääge, kuni te lahkute. ");
INSERT INTO ekk_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Majja sisenedes tervitage seda! ");
INSERT INTO ekk_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ja kui maja on seda väärt, jätke oma rahu selle peale, aga kui ei ole, tulgu teie rahu tagasi teie juurde. ");
INSERT INTO ekk_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Aga kui keegi teid vastu ei võta ja teie sõnumit ei kuula, siis sellest kodust või linnast lahkudes raputage maha selle koha tolmgi oma jalgadelt. ");
INSERT INTO ekk_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tõesti, ma ütlen teile, isegi Soodomal ja Gomorral läheb kohtupäeval kergemini kui sellel linnal. ");
INSERT INTO ekk_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ma saadan teid otsekui lambaid huntide sekka. Olge siis arukad nagu maod ja süütud kui tuvid! ");
INSERT INTO ekk_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Olge valvsad inimeste suhtes, sest nad annavad teid kohtute kätte ja lasevad piitsutada sünagoogides. ");
INSERT INTO ekk_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Minu pärast viiakse teid valitsejate ja kuningate ette, et te saaksite neile ja rahvastele tunnistada. ");
INSERT INTO ekk_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kui nad teid kinni võtavad, siis ärge muretsege, mida või kuidas rääkida. Sel tunnil antakse teile see, mida öelda, ");
INSERT INTO ekk_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","sest te ei räägi ise, vaid teie Isa Vaim kõneleb teie kaudu. ");
INSERT INTO ekk_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Vend saadab surma venna ja isa lapse ning lapsed tõusevad vanemate vastu ja lasevad nad surmata. ");
INSERT INTO ekk_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Minu nime pärast olete te kõigi poolt vihatud, ent kes peab vastu lõpuni, see pääseb. ");
INSERT INTO ekk_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kui teid ühes linnas taga kiusatakse, põgenege teise! Tõesti, ma ütlen teile, te ei jõua Iisraeli linnu läbi käia, enne kui Inimese Poeg tuleb. ");
INSERT INTO ekk_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Jünger ei ole üle õpetajast ega teener parem oma isandast. ");
INSERT INTO ekk_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jünger olgu rahul, kui ta käsi käib nagu tema õpetajal, ja teener olgu rahul, kui ta käsi käib nagu isandal. Kui nad juba peremeest nimetasid Peltsebuliks, kui palju enam siis tema pereliikmeid! ");
INSERT INTO ekk_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Seepärast ärge kartke neid! Midagi ei ole varjatut, mida ei paljastataks, ega salajast, mis teatavaks ei saaks. ");
INSERT INTO ekk_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mida mina räägin teile pimedas, ütelge valges, ja mida te kuulete kõrva sosistatavat, kuulutage katustelt! ");
INSERT INTO ekk_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ärge kartke neid, kes ihu tapavad, aga hinge tappa ei suuda. Pigem kartke teda, kes võib nii hinge kui ka ihu põrgus hukata! ");
INSERT INTO ekk_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Eks kaks varblast müüda ühe penni eest? Ometi ükski neist ei lange maha ilma teie Isa loata. ");
INSERT INTO ekk_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ent teie juuksekarvadki on kõik ära loetud. ");
INSERT INTO ekk_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ärge siis kartke, te olete rohkem väärt kui palju varblasi. ");
INSERT INTO ekk_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Igaüht nüüd, kes mind tunnistab inimeste ees, teda tunnistan ka mina oma Isa ees, kes on taevas. ");
INSERT INTO ekk_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Aga seda, kes salgab mind inimeste ees, salgan minagi oma Isa ees, kes on taevas. ");
INSERT INTO ekk_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ärge arvake, et ma olen tulnud rahu tooma maa peale! Ma ei tulnud tooma rahu, vaid mõõka! ");
INSERT INTO ekk_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ma tulin pöörama „meest tema isa vastu, tütart tema ema vastu ja miniat tema ämma vastu. ");
INSERT INTO ekk_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ja mehe vaenlaseks saavad tema pereliikmed“. ");
INSERT INTO ekk_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Kes isa või ema armastab rohkem kui mind, ei ole mind väärt. Kes poega või tütart armastab rohkem kui mind, ei ole mind väärt. ");
INSERT INTO ekk_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ja kes ei võta oma risti ega järgne mulle, ei ole mind väärt. ");
INSERT INTO ekk_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kes oma elu hoiab, kaotab selle, ja kes oma elu kaotab minu pärast, leiab selle. ");
INSERT INTO ekk_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Kes teid vastu võtab, võtab vastu minu, ja kes minu vastu võtab, võtab vastu selle, kes minu saatis. ");
INSERT INTO ekk_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kes prohveti vastu võtab kui prohveti, saab prohveti tasu, ja kes õiglase mehe vastu võtab, sest ta on õiglane, saab õiglase inimese tasu. ");
INSERT INTO ekk_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kes iganes pakub kruusitäie jahedat vett ühele neist väikestest, kes on minu jünger – tõesti, ma ütlen teile, ta ei jää oma tasust ilma.“ ");
INSERT INTO ekk_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kui Jeesus oli lõpetanud juhiste jagamise oma kaheteistkümnele jüngrile, läks ta sealt edasi õpetama ja kuulutama Galilea linnadesse. ");
INSERT INTO ekk_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kui nüüd Johannes vanglas olles kuulis Messia tegudest, saatis ta kaks oma jüngritest ");
INSERT INTO ekk_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","temalt küsima: „Kas sina oled see, kes pidi tulema, või me peame ootama kedagi teist?“ ");
INSERT INTO ekk_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jeesus vastas neile: „Minge ja teatage Johannesele, mida te kuulete ja näete: ");
INSERT INTO ekk_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","pimedad saavad nägijaks, jalust vigased kõnnivad, pidalitõbised saavad puhtaks, kurdid kuulevad, surnud tõusevad üles, vaestele kuulutatakse evangeeliumi. ");
INSERT INTO ekk_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Õnnistatud on igaüks, kes minu pärast ei pahanda.“ ");
INSERT INTO ekk_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kui Johannese jüngrid olid lahkunud, hakkas Jeesus rahvale temast rääkima: „Mida te käisite kõrbes vaatamas? Kas tuules kõikuvat kõrt? ");
INSERT INTO ekk_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Või mida te tahtsite välja minnes näha? Kas peenetes rõivastes meest? Need, kes kannavad peeneid rõivaid, on kuningakodades. ");
INSERT INTO ekk_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mida te siis tahtsite näha? Kas prohvetit? Jah, ma ütlen teile, palju enam kui prohvetit! ");
INSERT INTO ekk_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tema on see, kellest on kirjutatud: „Vaata, ma saadan sinu ees oma saadiku, kes valmistab sinu tee su ees!“ ");
INSERT INTO ekk_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tõesti, ma ütlen teile, naisest sündinute seast ei ole tõusnud esile kedagi suuremat kui Ristija Johannes, ent kõige pisemgi taevariigis on temast suurem. ");
INSERT INTO ekk_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ristija Johannese päevist tänini rünnatakse taevariiki ja ründajad kisuvad selle endale. ");
INSERT INTO ekk_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kogu Seadus ja Prohvetid on ette kuulutanud Johanneseni, ");
INSERT INTO ekk_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ja kui teada tahate, siis tema ongi Eelija, kes pidi tulema. ");
INSERT INTO ekk_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kellel kõrvad on, see kuulgu! ");
INSERT INTO ekk_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Aga millega ma võrdleksin praegust sugupõlve? Nad on nagu lapsed, kes turuplatsil istuvad ja vastastikku hüüavad: ");
INSERT INTO ekk_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","„Meie mängisime teile vilepilli, aga teie ei tantsinud! Meie itkesime kurvalt, aga teie ei leinanud!“ ");
INSERT INTO ekk_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Sest Johannes tuli, ei söönud ega joonud, ja nad ütlevad: „Tal on kuri vaim!“ ");
INSERT INTO ekk_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Inimese Poeg tuli ning sööb ja joob, ja siis te ütlete: „Vaadake, see inimene on õgard ja joodik, maksukogujate ja patuste sõber!“ Ometi tunnistatakse tarkus õigeks tema tegudest.“ ");
INSERT INTO ekk_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Siis hakkas Jeesus sõitlema linnu, kus oli tehtud enamus ta imetegudest, sest nad ei parandanud meelt: ");
INSERT INTO ekk_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","„Häda sulle, Korasin! Häda sulle, Betsaida! Kui Tüüroses ja Siidonis oleksid sündinud need imeteod, mis teie juures sündisid, siis oleksid nad ammugi kotiriides ja tuhas meelt parandanud. ");
INSERT INTO ekk_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tõepoolest, ma ütlen teile, Tüürosel ja Siidonil läheb kohtupäeval kergemini kui teil. ");
INSERT INTO ekk_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ja sina, Kapernaum, kas sind peaks ülendatama taevani? Sa langed alla põrgupõhja! Sest kui Soodomas oleksid sündinud imeteod, mis sündisid sinus, siis oleks ta püsinud tänase päevani. ");
INSERT INTO ekk_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tõepoolest, ma ütlen teile, Soodomal läheb kohtupäeval kergemini kui sinul.“ ");
INSERT INTO ekk_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Selsamal tunnil ütles Jeesus veel: „Ma ülistan sind, Isa, taeva ja maa Issand, et sa selle oled pannud varjule tarkade ja arusaajate eest, kuid ilmutanud lapsemeelsetele! ");
INSERT INTO ekk_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jah, Isa, nõnda on see olnud sulle meelepärane. ");
INSERT INTO ekk_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kõik on mu Isa andnud minu kätte. Keegi ei tunne Poega peale Isa, ja keegi ei tunne Isa peale Poja ja nende, kellele Poeg soovib teda ilmutada. ");
INSERT INTO ekk_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tulge minu juurde, kõik kurnatud ja koormatud, ja mina annan teile hingamise! ");
INSERT INTO ekk_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Võtke kanda minu ike ja õppige minult, sest mina olen tasane ja südamelt alandlik; siis te leiate rahu oma hingele; ");
INSERT INTO ekk_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","sest minu ike on hea ja minu koorem on kerge!“ ");
INSERT INTO ekk_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Selsamal ajal läks Jeesus hingamispäeval läbi viljapõldude. Ent ta jüngrid olid näljased ja hakkasid noppima viljapäid ning sööma. ");
INSERT INTO ekk_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kui variserid seda nägid, ütlesid nad Jeesusele: „Vaata, sinu jüngrid teevad seda, mida ei tohi teha hingamispäeval!“ ");
INSERT INTO ekk_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jeesus vastas: „Kas te ei ole lugenud, mida tegi Taavet, kui temal ja ta kaaslastel oli nälg? ");
INSERT INTO ekk_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ta läks Jumala kotta ja sõi ära ohvrileivad, mida ei olnud luba süüa ei temal ega ta kaaslastel, vaid ainult preestritel. ");
INSERT INTO ekk_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Või kas te pole lugenud Seadusest, et preestrid rikuvad templis hingamispäeva kohuseid täites hingamispäeva, kuid on ometi süüta? ");
INSERT INTO ekk_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kuid ma ütlen teile, siin on keegi, kes on suurem kui tempel! ");
INSERT INTO ekk_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kui te mõistaksite, mida tähendab „Ma soovin halastust, mitte ohvrit“, siis te ei oleks mõistnud hukka süütuid. ");
INSERT INTO ekk_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sest Inimese Poeg on hingamispäeva Issand!“ ");
INSERT INTO ekk_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Sealt edasi minnes astus Jeesus ühte nende sünagoogi. ");
INSERT INTO ekk_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Seal oli mees, kelle käsi oli kärbunud. Otsides põhjust Jeesust süüdistada, küsisid nad temalt: „Kas hingamispäeval tohib tervendada?“ ");
INSERT INTO ekk_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jeesus vastas neile: „Kui kellelgi teie seast oleks üksainuke lammas ja see kukuks hingamispäeval auku, eks ta võtaks temast kinni ja tõmbaks ta välja? ");
INSERT INTO ekk_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ent kui palju on lambast väärtuslikum inimene! Seepärast on hingamispäeval lubatud teha head.“ ");
INSERT INTO ekk_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Siis ta ütles mehele: „Siruta välja oma käsi!“ Ta sirutas käe ja see sai terveks nagu teinegi. ");
INSERT INTO ekk_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Variserid aga läksid välja nõu pidama, kuidas Jeesust tappa. ");
INSERT INTO ekk_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kui Jeesus sai sellest teada, lahkus ta sealt. Ja paljud järgnesid talle ning ta tervendas kõik nende haiged, ");
INSERT INTO ekk_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","keelates neil rääkimast, kes ta on. ");
INSERT INTO ekk_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nõnda, et läheks täide prohvet Jesaja suu läbi öeldu: ");
INSERT INTO ekk_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","„See on mu sulane, mu valitu, mu armastatu, mu hinge rõõm. Ma panen oma Vaimu tema peale ja ta kuulutab rahvaste üle õigust. ");
INSERT INTO ekk_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ta ei riidle ega karju, ka ei kuulda tänaval ta häält. ");
INSERT INTO ekk_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Rudjutud roogu ei murra ta katki, hõõguvat tahti ei kustuta ära, kuni viib õiguse võidule. ");
INSERT INTO ekk_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tema nime peale loodavad rahvad.“ ");
INSERT INTO ekk_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Siis toodi tema juurde kurjast vaimust vaevatu, pime ja tumm mees, ning Jeesus tegi ta terveks, nii et ta rääkis ja nägi jälle. ");
INSERT INTO ekk_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kogu rahvas aga küsis hämmastunult: „Kas tema ehk ongi Taaveti Poeg?“ ");
INSERT INTO ekk_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kui variserid seda kuulsid, ütlesid nad: „See mees ei aja kurje vaime välja muidu kui kurjade vaimude valitseja Peltsebuli abiga.“ ");
INSERT INTO ekk_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jeesus aga, teades nende mõtteid, kostis neile: „Ükski riik, mis on omavahel tülis lõhenenud, ei jää püsima. Ükski linn või kodu, mis on omavahel riius, ei jää püsima. ");
INSERT INTO ekk_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kui saatan ajab välja saatana, on ta iseendaga tülis. Kuidas saab tema riik siis püsida? ");
INSERT INTO ekk_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kui mina peaksin kurje vaime välja ajama Peltsebuli abil, kelle abil siis teie kasvandikud neid välja ajavad? Seepärast mõistku nemad kohut teie üle! ");
INSERT INTO ekk_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Aga kui mina ajan Jumala Vaimuga kurje vaime välja, siis on Jumala riik saabunud teie juurde. ");
INSERT INTO ekk_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Või kuidas saab keegi tungida vägimehe majja ta asju röövima, kui ta esmalt vägimeest ei seo kinni? Alles siis saab ta tema maja röövida. ");
INSERT INTO ekk_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kes ei ole minuga, on minu vastu, ja kes ei kogu minuga, pillub laiali. ");
INSERT INTO ekk_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Seepärast ma ütlen teile, et inimestele antakse andeks igasugune patt ja pühaduseteotus, aga Püha Vaimu teotamist ei anta andeks. ");
INSERT INTO ekk_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kui keegi ütleb midagi Inimese Poja vastu, antakse see talle andeks, aga kui keegi ütleb midagi Püha Vaimu vastu, ei andestata talle ei käesoleval ega tulevasel ajastul. ");
INSERT INTO ekk_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tehke puu heaks, siis on ta vili hea, või tehke puu halvaks, ja ta vili on halb; sest puud tuntakse tema viljast. ");
INSERT INTO ekk_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Rästikute sugu, kuidas te saaksitegi rääkida head, kui te olete kurjad? Sest suu räägib seda, mida süda on täis. ");
INSERT INTO ekk_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Hea inimene toob südame heast tagavarast välja head, ja kuri inimene toob kurjast tagavarast välja kurja. ");
INSERT INTO ekk_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Aga ma ütlen teile, et inimesed peavad kohtupäeval aru andma igast tühjast sõnast, mida nad on rääkinud; ");
INSERT INTO ekk_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","sest su sõnadest mõistetakse sind õigeks ja su sõnadest mõistetakse sind süüdi.“ ");
INSERT INTO ekk_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Siis mõned kirjatundjad ja variserid ütlesid talle: „Õpetaja, me tahame sinult näha tunnustähte!“ ");
INSERT INTO ekk_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jeesus vastas: „See kuri ja abielurikkuja sugupõlv nõuab tunnustähte, aga talle ei anta muud kui prohvet Joona tunnustäht. ");
INSERT INTO ekk_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nii nagu Joona viibis kolm päeva ja kolm ööd hiidkala kõhus, nõnda peab ka Inimese Poeg olema maapõues kolm päeva ja kolm ööd. ");
INSERT INTO ekk_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Niineve mehed astuvad kohtupäeval üles selle sugupõlve vastu ja mõistavad ta süüdi, sest nemad parandasid meelt Joona kuulutuse peale, aga siin on nüüd üks, kes on suurem kui Joona. ");
INSERT INTO ekk_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Lõunamaa kuninganna tõuseb kohtupäeval üles selle sugupõlve vastu ja mõistab ta süüdi, sest tema tuli maailma otsast kuulama Saalomoni tarkust, ja nüüd on siin keegi suurem kui Saalomon! ");
INSERT INTO ekk_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Kui rüve vaim väljub inimesest, hulgub ta põuastes paikades ja otsib hingamist, kuid ei leia seda. ");
INSERT INTO ekk_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Siis ta ütleb: „Ma pöördun tagasi oma majja, kust ma välja tulin.“ Ja tulles leiab ta selle tühja olevat ning puhtaks pühitud ja ehitud. ");
INSERT INTO ekk_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Siis võtab ta kaasa veel seitse vaimu, kes on kurjemad kui ta ise, ning asub sinna elama. Ja selle inimese hilisem olukord läheb halvemaks kui varasem. Samuti on lugu selle kurja sugupõlvega!“ ");
INSERT INTO ekk_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Kui Jeesus alles rahvale kõneles, seisid ta ema ja vennad eemal, soovides temaga rääkida. ");
INSERT INTO ekk_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Jeesusele öeldi: „Su ema ja vennad seisavad seal ja tahavad sinuga rääkida!“ ");
INSERT INTO ekk_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jeesus aga vastas ütlejale: „Kes on mu ema ja kes on mu vennad?“ ");
INSERT INTO ekk_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ja sirutades käed oma jüngrite poole, ütles ta: „Näe, siin on minu ema ja minu vennad! ");
INSERT INTO ekk_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sest kes iganes teeb minu taevase Isa tahtmist, see on mu vend ja õde ja ema.“ ");
INSERT INTO ekk_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Samal päeval läks Jeesus majast välja ja istus mere äärde. ");
INSERT INTO ekk_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tema juurde kogunes nii suur rahvahulk, et ta pidi astuma paati ja istuma seal, samal ajal kui rahvas seisis kaldal. ");
INSERT INTO ekk_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ja ta rääkis neile palju asju tähendamissõnadega, öeldes: „Põllumees läks välja külvama. ");
INSERT INTO ekk_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kui ta külvas, kukkus osa seemet teeveerele ning linnud tulid ja nokkisid selle. ");
INSERT INTO ekk_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Osa kukkus kivisele pinnale, kus ei olnud palju mulda, ja tärkas kohe, sest muld ei olnud sügav. ");
INSERT INTO ekk_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ent kui päike tõusis ja kõrvetas, kuivasid taimed ära, sest neil ei olnud juurt. ");
INSERT INTO ekk_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ja osa seemet kukkus ohakate sekka ning ohakad sirgusid ja lämmatasid selle. ");
INSERT INTO ekk_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Aga osa seemet kukkus heasse mulda ja kandis vilja – mõni sada, mõni kuuskümmend ja mõni kolmkümmend korda rohkem kui külvati. ");
INSERT INTO ekk_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kellel kõrvad on, see kuulgu!“ ");
INSERT INTO ekk_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","„Miks sa räägid neile tähendamissõnadega?“ tulid jüngrid Jeesuselt küsima. ");
INSERT INTO ekk_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jeesus vastas: „Teile on antud teada taevariigi saladusi, neile aga ei ole. ");
INSERT INTO ekk_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kellel on, sellele antakse rohkem, ja tal on küllaga; aga kellel ei ole, sellelt võetakse ära seegi, mis tal on. ");
INSERT INTO ekk_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Sellepärast räägin ma neile tähendamissõnadega: „Kuigi nad vaatavad, nad ei näe; kuigi nad kuulevad, nad ei mõista.“ ");
INSERT INTO ekk_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nende kohta läheb tõesti täide prohvet Jesaja ettekuulutus: „Te küll kuulate, aga ei mõista, te küll vaatate, aga ei näe. ");
INSERT INTO ekk_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Selle rahva süda on kalestunud ja nende kõrvakuulmine on nüri ja nad on sulgenud oma silmad. Muidu nad näeksid oma silmadega ja kuuleksid oma kõrvadega ja mõistaksid südamega ning pöörduksid, ja ma teeksin nad terveks.“ ");
INSERT INTO ekk_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Aga õnnistatud on teie silmad, et need näevad, ja teie kõrvad, et need kuulevad. ");
INSERT INTO ekk_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tõesti, ma ütlen teile, paljud prohvetid ja õiged on igatsenud näha seda, mida teie näete, ega ole näinud, ja kuulda, mida teie kuulete, ega ole kuulnud. ");
INSERT INTO ekk_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kuulake, kuidas mõista tähendamissõna külvajast! ");
INSERT INTO ekk_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Igaühe juurde, kes sõnumit Kuningriigist kuuleb, kuid ei mõista, tuleb kurat ja röövib külvatu ta südamest. See on seeme, mis teeveerele külvati. ");
INSERT INTO ekk_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Seeme, mis kivisele maale külvati, on inimene, kes sõna kuuleb ja selle kohe rõõmuga vastu võtab. ");
INSERT INTO ekk_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Aga kuna tal endas ei ole juurt, püsib ta lühikest aega. Kui teda tabab mure või tagakius, langeb ta kiiresti ära. ");
INSERT INTO ekk_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ohakaisse külvatud seeme on inimene, kes sõnumit küll kuuleb, ent ajaliku elu mured ja rikkuse petlik võlu lämmatavad selle ja see jääb viljatuks. ");
INSERT INTO ekk_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Heasse mulda külvatud seeme on aga inimene, kes sõnumit kuuleb ja mõistab. Tema on see, kes vilja kannab ja saaki annab: kes sada, kes kuuskümmend, kes kolmkümmend korda rohkem kui külvati.“ ");
INSERT INTO ekk_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ta rääkis neile veel teise tähendamissõna: „Taevariik on kui mees, kes külvas oma põllule head seemet. ");
INSERT INTO ekk_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Aga kui kõik magasid, tuli ta vaenlane, külvas raiheina nisuseemne sekka ja läks minema. ");
INSERT INTO ekk_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kui oras võrsus ja looma hakkas, ilmus ka raihein nähtavale. ");
INSERT INTO ekk_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Peremehe sulased tulid nüüd tema juurde ja küsisid: „Isand, eks sa külvanud ju oma põllule head seemet. Kust siis tuli sinna raihein?“ ");
INSERT INTO ekk_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tema aga vastas neile: „See on vaenlase töö.“ „Kas sa tahad, et me läheme ja need välja korjame?“ küsisid sulased. ");
INSERT INTO ekk_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","„Ei,“ vastas peremees, „sest raiheina korjates te kisuksite üles ka nisu. ");
INSERT INTO ekk_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Las mõlemad kasvavad lõikuseni ja siis ma ütlen lõikajaile: korjake esmalt raihein, siduge kimpu põletamiseks, vili aga koguge mu aita!“ “ ");
INSERT INTO ekk_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ta rääkis neile veel ühe tähendamissõna: „Taevariik on kui sinepiseeme, mille mees võttis ja külvas oma põllule. ");
INSERT INTO ekk_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kuigi see on väikseim kõigist seemneist, kasvab aiataimedest suurimaks ja sirgub puuks, mille okstele tulevad linnud ja teevad pesa.“ ");
INSERT INTO ekk_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ta rääkis neile veel ühe tähendamissõna: „Taevariik on kui juuretis, mille naine võttis ja segas umbes kolmekümne kilogrammi jahu sekka, kuni kogu taigen läks hapnema.“ ");
INSERT INTO ekk_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Seda kõike rääkis Jeesus rahvale tähendamissõnades, ja tähendamissõnu kasutamata ei rääkinud ta neile midagi. ");
INSERT INTO ekk_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nõnda läks täide, mis on öeldud prohveti suu läbi: „Ma hakkan kõnelema tähendamissõnadega, ütlen välja asju, mis on varjatud maailma loomisest peale.“ ");
INSERT INTO ekk_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Siis saatis Jeesus rahva minema ja tuli koju. Jüngrid tulid tema juurde ja ütlesid: „Seleta meile tähendamissõna raiheinast põllul!“ ");
INSERT INTO ekk_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jeesus vastas: „Hea seemne külvaja on Inimese Poeg. ");
INSERT INTO ekk_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Põld on maailm, hea seeme tähistab kuningriigi inimesi. Raihein on kurjad inimesed, ");
INSERT INTO ekk_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ja vaenlane, kes neid külvab, on kurat. Lõikusaeg on ajastu lõpp, lõikajad on inglid. ");
INSERT INTO ekk_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nõnda nagu raihein korjatakse ja tules põletatakse, nii on ka selle ajastu lõpul. ");
INSERT INTO ekk_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Inimese Poeg läkitab oma inglid, kes korjavad tema Kuningriigist kõik, mis põhjustab pattu ja kes teevad kurja ");
INSERT INTO ekk_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ja heidavad need põlevasse ahju; seal on ulgumine ja hammaste kiristamine. ");
INSERT INTO ekk_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Siis säravad õiged otsekui päike oma Isa Kuningriigis. Kellel kõrvad on, see kuulgu! ");
INSERT INTO ekk_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Taevariik on kui põllumaasse peidetud aare, mille inimene leidis. Ta peitis selle jälle ning läks ja müüs rõõmuga maha kõik, mis tal oli, ning ostis selle põllu. ");
INSERT INTO ekk_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Veel on taevariik kui kaupmees, kes otsis ilusaid pärleid. ");
INSERT INTO ekk_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kui ta oli leidnud ühe eriti hinnalise pärli, läks ta ja müüs ära kõik, mis tal oli, ning ostis endale selle. ");
INSERT INTO ekk_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Veel on taevariik kui noot, mis heideti järve ja püüdis mitmesuguseid kalu. ");
INSERT INTO ekk_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kui noot sai täis, tõmbasid kalurid selle kaldale, istusid maha ja kogusid head kalad korvidesse, halvad aga viskasid ära. ");
INSERT INTO ekk_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nõnda on ka selle ajastu lõpul: inglid tulevad ja eraldavad õelad õigete keskelt ");
INSERT INTO ekk_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ning heidavad nad põlevasse ahju; seal on ulgumine ja hammaste kiristamine. ");
INSERT INTO ekk_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kas te saite aru sellest kõigest?“ küsis Jeesus. „Jah,“ vastasid nad. ");
INSERT INTO ekk_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ja ta ütles neile: „Seepärast on iga kirjatundja, kellest on saanud taevariigi jünger, kui majaperemees, kes toob oma varakambrist välja uusi ja vanu aardeid.“ ");
INSERT INTO ekk_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kui Jeesus oli need tähendamissõnad lõpetanud, lahkust ta sealt. ");
INSERT INTO ekk_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ta läks oma kodulinna ja õpetas sealses sünagoogis, nii et inimesed küsisid hämmastunult: „Kust on saanud see mees säärase tarkuse ja imelise väe? ");
INSERT INTO ekk_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Eks ta ole see puusepa poeg? Eks ta ema nimi ole Maarja ning ta vennad Jaakobus, Joosep, Siimon ja Juudas? ");
INSERT INTO ekk_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ja eks ta õed ela kõik siin meie juures? Kust ta siis kõik selle on saanud?“ ");
INSERT INTO ekk_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ja nad said tema peale vihaseks. Jeesus aga ütles neile: „Kuskil ei peeta prohvetist nii vähe lugu kui tema kodukohas ja ta oma majas!“ ");
INSERT INTO ekk_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ja ta ei teinud seal kuigi palju imetegusid nende uskmatuse tõttu. ");
INSERT INTO ekk_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sel ajal jõudsid nelivürst Heroodese kõrvu kuuldused Jeesusest. ");
INSERT INTO ekk_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","„See on Ristija Johannes,“ ütles ta oma kaaskondlastele. „Tema on üles äratatud surnuist, seepärast ongi tal vägi neid imesid teha.“ ");
INSERT INTO ekk_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Heroodes oli ju Johannese kinni võtnud, aheldanud ja vangi pannud oma venna Filippuse naise Heroodiase pärast, ");
INSERT INTO ekk_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","sest Johannes oli talle öelnud: „Sul pole õigust teda omada!“ ");
INSERT INTO ekk_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heroodes oleks tahtnud Johannest tappa, kuid kartis rahvast, kes pidas Johannest prohvetiks. ");
INSERT INTO ekk_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Aga kui peeti Heroodese sünnipäeva, tantsis Heroodiase tütar nende ees ja see meeldis Heroodesele. ");
INSERT INTO ekk_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ta tõotas tüdrukule anda, mida ta iganes palub. ");
INSERT INTO ekk_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tüdruk aga ütles oma ema õhutusel: „Anna mulle siinsamas kandikul Ristija Johannese pea!“ ");
INSERT INTO ekk_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kuningas kurvastas, kuid piduliste kuuldes antud vande pärast käskis ta soovi täita ");
INSERT INTO ekk_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ja laskis Johannesel vanglas pea maha raiuda. ");
INSERT INTO ekk_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Pea toodi kandikul ja anti tüdrukule, kes viis selle oma emale. ");
INSERT INTO ekk_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Siis tulid Johannese jüngrid, võtsid ta surnukeha ja matsid maha ning läksid ja teatasid sellest Jeesusele. ");
INSERT INTO ekk_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kui Jeesus sai sellest kuulda, lahkus ta paadiga kõrvalisse paika, et olla omaette. Sellest kuuldes järgnes rahvas talle jalgsi linnadest. ");
INSERT INTO ekk_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kui Jeesus astus paadist kaldale ja nägi suurt rahvahulka, hakkas tal neist kahju; ja ta tegi terveks nende haiged. ");
INSERT INTO ekk_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Õhtu hakul tulid jüngrid tema juurde ja ütlesid: „See paik on üksildane ja aeg juba hiline. Saada rahvas minema, et nad läheksid küladesse endale süüa ostma!“ ");
INSERT INTO ekk_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","„Neil pole tarvis ära minna,“ vastas Jeesus. „Andke teie neile süüa!“ ");
INSERT INTO ekk_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","„Meil pole siin rohkem kui viis leiba ja kaks kala,“ kostsid jüngrid. ");
INSERT INTO ekk_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","„Tooge need siia minu kätte!“ ütles Jeesus. ");
INSERT INTO ekk_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ta käskis rahval istuda rohule, võttis need viis leiba ja kaks kala, vaatas üles taevasse, õnnistas ja murdis ning ulatas jüngritele, need aga omakorda rahvale. ");
INSERT INTO ekk_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kõik sõid ja said söönuks ning ülejäänud palukesi korjati kaksteist korvitäit. ");
INSERT INTO ekk_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Sööjaid oli seal ligi viis tuhat meest, arvestamata naisi ja lapsi. ");
INSERT INTO ekk_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ja Jeesus saatis kohe jüngrid paati, et nad enne teda teisele kaldale läheksid, sellal kui tema rahval minna laseb. ");
INSERT INTO ekk_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Saatnud rahva ära, läks ta üles mäele üksipäini palvetama. Hilisõhtul oli ta seal üksinda. ");
INSERT INTO ekk_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Paat aga oli juba kaldast kaugel lainete pillutada vastutuule pärast. ");
INSERT INTO ekk_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Neljanda öövalvekorra ajal tuli Jeesus nende suunas järve peal kõndides. ");
INSERT INTO ekk_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Aga Jeesust järve peal kõndimas nähes ütlesid jüngrid kohkunult: „See on vaim!“ ja kisendasid hirmust. ");
INSERT INTO ekk_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jeesus aga kõnetas neid: „Olge julged, see olen mina! Ärge kartke!“ ");
INSERT INTO ekk_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peetrus vastas talle: „Issand, kui see oled sina, siis käsi mul vee peal sinu juurde tulla!“ ");
INSERT INTO ekk_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","„Tule!“ ütles Jeesus. Peetrus astus paadist välja, kõndis vee peal ja tuli Jeesuse poole. ");
INSERT INTO ekk_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kuid tuule tugevust nähes lõi ta kartma ning hüüdis vajuma hakates: „Issand, päästa mind!“ ");
INSERT INTO ekk_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jeesus sirutas kohe käe, võttis temast kinni ja ütles talle: „Miks sa kahtlesid, sa nõdrausuline?“ ");
INSERT INTO ekk_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ja kui nad astusid paati, rauges tuul. ");
INSERT INTO ekk_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Paadisolijad aga ülistasid Jeesust, öeldes: „Tõesti, sina oled Jumala Poeg!“ ");
INSERT INTO ekk_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kui nad olid ületanud järve, tulid nad maale Genneesaretis. ");
INSERT INTO ekk_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ja kui selle paiga mehed Jeesuse ära tundsid, läkitasid nad sõna kogu ümbruskonda ja tema juurde toodi kõik haiged. ");
INSERT INTO ekk_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Need anusid teda, et nad saaksid puudutada kasvõi tema kuuepalistust. Ja kes iganes teda puudutasid, said terveks. ");
INSERT INTO ekk_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Siis tulid mõned variserid ja kirjatundjad Jeruusalemmast Jeesuse juurde ning küsisid: ");
INSERT INTO ekk_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","„Miks sinu jüngrid astuvad üle esivanemate pärimusest? Nad ei pese enne sööki käsi.“ ");
INSERT INTO ekk_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jeesus vastas neile: „Miks te ise astute üle Jumala käsust oma pärimuse pärast? ");
INSERT INTO ekk_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Jumal on ju öelnud: „Austa oma isa ja ema!“ ning „Kes oma isa või ema neab, peab surema.“ ");
INSERT INTO ekk_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kuid teie ütlete, et kui keegi ütleb oma isale või emale: „Selle toetuse, mis sa pidid minu käest saama, ma annan ohvrianniks Jumalale,“ ");
INSERT INTO ekk_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","siis ta ei pea oma isa austama. Te olete teinud Jumala sõna tühjaks oma pärimusega! ");
INSERT INTO ekk_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Te silmakirjatsejad, eks ole prohvet Jesaja õigesti kuulutanud teie kohta: ");
INSERT INTO ekk_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","„See rahvas austab mind oma huultega, nende süda on aga minust kaugel. ");
INSERT INTO ekk_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ilmaaegu nad teenivad mind, õpetades õpetusi, mis on vaid inimeste reeglid.“ “ ");
INSERT INTO ekk_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ja Jeesus kutsus rahva enda juurde ning ütles: „Kuulge ja mõistke! ");
INSERT INTO ekk_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Inimest ei rüveta mitte see, mis suust sisse läheb, vaid see, mis suust välja tuleb – see rüvetab inimest.“ ");
INSERT INTO ekk_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Siis jüngrid tulid tema juurde ja ütlesid: „Kas sa tead, et variserid vihastasid, kui nad seda kuulsid?“ ");
INSERT INTO ekk_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jeesus aga vastas neile: „Iga taim, mida minu taevane Isa pole istutanud, juuritakse välja. ");
INSERT INTO ekk_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Laske neil olla! Nad on pimedate pimedad teejuhid. Kui pime juhib pimedat, kukuvad mõlemad auku.“ ");
INSERT INTO ekk_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","„Seleta meile seda tähendamissõna!“ palus Peetrus. ");
INSERT INTO ekk_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","„Kas ka teie veel ei mõista?“ küsis Jeesus. ");
INSERT INTO ekk_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","„Kas te ei saa aru, et kõik, mis suust sisse läheb, liigub edasi kõhtu ja heidetakse taas välja? ");
INSERT INTO ekk_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Aga mis suust väljub, tuleb südamest ja see rüvetab inimest. ");
INSERT INTO ekk_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Sest südamest lähtub kurje mõtteid – mõrva, abielurikkumist, hoorust, vargust, valetunnistusi ja laimu. ");
INSERT INTO ekk_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Need rüvetavad inimest, aga pesemata kätega söömine ei rüveta.“ ");
INSERT INTO ekk_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ja Jeesus lahkus sealt ning läks Tüürose ja Siidoni aladele. ");
INSERT INTO ekk_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Üks neist paigust pärit Kaanani naine tuli ja hüüdis: „Issand, Taaveti Poeg, halasta minu peale! Mu tütar vaevleb rängalt kurja vaimu käes!“ ");
INSERT INTO ekk_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kuid Jeesus ei vastanud sõnagi. Siis jüngrid astusid tema juurde ja palusid teda: „Saada ta minema, sest ta karjub meie kannul!“ ");
INSERT INTO ekk_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jeesus vastas: „Mind on läkitatud üksnes Iisraeli rahva kadunud lammaste juurde.“ ");
INSERT INTO ekk_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ent naine tuli ja põlvitas Jeesuse ette, öeldes: „Issand, aita mind!“ ");
INSERT INTO ekk_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","„Ei sobi võtta laste leiba ja visata koertele,“ kostis Jeesus. ");
INSERT INTO ekk_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","„Jah, Issand,“ ütles naine, „ometi söövad koerad raasukesi, mis nende isandate laualt pudenevad.“ ");
INSERT INTO ekk_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","„Naine, sinu usk on suur!“ vastas Jeesus, „Sündigu sulle, nagu sa soovid!“ Ja tema tütar sai terveks samal tunnil. ");
INSERT INTO ekk_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jeesus lahkus sealt ja jõudis Galilea mere äärde. Ta läks üles mäele ja istus maha. ");
INSERT INTO ekk_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tema juurde tuli palju rahvast, tuues kaasa halvatuid, pimedaid, vigaseid, tummi ja palju teisi. Nad panid haiged Jeesuse jalge ette ja ta tegi nad terveks, ");
INSERT INTO ekk_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","nõnda et inimesed imestasid, nähes tummi rääkimas, vigaseid tervena, halvatuid kõndimas ja pimedaid nägemas. Ning nad ülistasid Iisraeli Jumalat. ");
INSERT INTO ekk_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jeesus aga kutsus oma jüngrid enese juurde ja ütles: „Mul on rahvast kahju. Nad on juba kolm päeva minu juures olnud ja neil pole midagi süüa. Ma ei taha neid näljastena ära saata, muidu võivad nad teel nõrkeda.“ ");
INSERT INTO ekk_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","„Kust me saaksime siin inimtühjas kohas leiba nii suure rahvahulga toitmiseks?“ küsisid jüngrid. ");
INSERT INTO ekk_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","„Mitu leiba teil on?“ küsis Jeesus neilt. „Seitse. Ja mõned kalakesed ka,“ vastasid nad. ");
INSERT INTO ekk_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Siis käskis Jeesus rahval maha istuda, ");
INSERT INTO ekk_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","võttis seitse leiba ja kalad, tänas, murdis need ja ulatas jüngritele, jüngrid andsid aga rahvale. ");
INSERT INTO ekk_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kõik sõid ja said söönuks ning ülejäänud palukesi koguti kokku seitse korvitäit. ");
INSERT INTO ekk_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Sööjaid oli seal neli tuhat meest, arvestamata naisi ja lapsi. ");
INSERT INTO ekk_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ja kui Jeesus oli rahva minema saatnud, astus ta paati ja suundus Magdala alale. ");
INSERT INTO ekk_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Variserid ja saduserid tulid Jeesuse juurde kiuslike küsimustega ning nõudsid, et ta näitaks neile tunnustähte taevast. ");
INSERT INTO ekk_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ta vastas neile: „Õhtul te ütlete: „Ilus ilm tuleb, sest taevas on punane.“ ");
INSERT INTO ekk_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ja varahommikul: „Kisub tormile, sest taevas on punane ja pilves.“ Taeva ilmeid te oskate küll eristada, aga ajamärke näha ei suuda! ");
INSERT INTO ekk_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","See kuri ja abielurikkuja sugupõlv nõuab tunnustähte, aga talle ei anta muud kui prohvet Joona tunnustäht.“ Ja Jeesus jättis nad sinna ja lahkus. ");
INSERT INTO ekk_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kui nad läksid üle järve, unustasid jüngrid leiba kaasa võtta. ");
INSERT INTO ekk_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","„Vaadake ette!“ ütles Jeesus neile. „Hoiduge variseride ja saduseride juuretisest!“ ");
INSERT INTO ekk_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nad arutasid seda omavahel ja ütlesid: „Ta räägib sellest, et me ei võtnud leiba kaasa!“ ");
INSERT INTO ekk_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jeesus ütles seda märgates: „Te nõdrausulised, miks te tülitsete omavahel, et te leiba kaasa ei võtnud? ");
INSERT INTO ekk_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kas te ikka veel ei mõista? Kas te ei mäleta neid viit leiba viiele tuhandele ja mitu korvitäit te kogusite, ");
INSERT INTO ekk_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ega neid seitset leiba neljale tuhandele ja mitu korvitäit te siis kogusite? ");
INSERT INTO ekk_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kuidas te siis ei mõista, et ma ei rääkinud teile leivast? Kuid hoiduge variseride ja saduseride juuretisest.“ ");
INSERT INTO ekk_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Siis said jüngrid aru, et ta oli käskinud neil hoiduda mitte leiva juuretisest, vaid variseride ja saduseride õpetusest. ");
INSERT INTO ekk_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kui siis Jeesus tuli Filippuse Kaisarea aladele, küsis Jeesus oma jüngritelt: „Kelle ütlevad inimesed Inimese Poja olevat?“ ");
INSERT INTO ekk_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jüngrid vastasid: „Mõned ütlevad Ristija Johannese, mõned Eelija, mõned Jeremija või ühe prohveteist.“ ");
INSERT INTO ekk_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","„Aga teie? Kelle teie ütlete mind olevat?“ küsis Jeesus. ");
INSERT INTO ekk_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","„Sina oled Messias, elava Jumala Poeg!“ vastas Siimon Peetrus. ");
INSERT INTO ekk_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jeesus vastas: „Sa oled õnnistatud, Siimon, Joona Poeg! Sest seda ei ole avaldanud sulle inimene, vaid minu Isa, kes on taevas. ");
INSERT INTO ekk_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ja mina ütlen sulle, sina oled Peetrus ja sellele kaljule ma ehitan oma koguduse, ning põrgu väravad ei pea teda. ");
INSERT INTO ekk_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ma annan sulle taevariigi võtmed; ja mis iganes sa seod maa peal, seotakse ka taevas, ja mida iganes sa lahti päästad maa peal, päästetakse lahti ka taevas.“ ");
INSERT INTO ekk_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Siis Jeesus keelas jüngreid, et nad kellelegi ei ütleks, et tema on Messias. ");
INSERT INTO ekk_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Sellest ajast peale hakkas Jeesus oma jüngritele selgitama, et ta peab minema Jeruusalemma ja palju kannatama rahvavanemate, ülempreestrite ja kirjatundjate käes; et ta tapetakse ning kolmandal päeval äratatakse üles. ");
INSERT INTO ekk_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kuid Peetrus viis ta kõrvale ja hakkas teda noomima: „Ei iialgi, Issand! Ärgu seda sulle mitte kunagi sündigu!“ ");
INSERT INTO ekk_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jeesus aga pöördus tema poole ja ütles: „Tagane minust, saatan! Sa oled mulle takistuseks, sest sa ei mõtle Jumala, vaid inimese viisil.“ ");
INSERT INTO ekk_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","„Kui keegi tahab käia minu järel,“ ütles Jeesus oma jüngritele, „siis salaku ta end maha, võtku oma rist ja järgnegu mulle! ");
INSERT INTO ekk_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sest kes tahab päästa oma elu, kaotab selle, aga kes kaotab oma elu minu pärast, leiab selle. ");
INSERT INTO ekk_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Sest mis kasu on inimesel, kui ta võidaks terve maailma, oma hingele teeks aga kahju? Või mis oleks inimesel anda oma hinge eest? ");
INSERT INTO ekk_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Sest Inimese Poeg tuleb Isa auhiilguses oma inglite saatel ja siis ta tasub igaühele tema tegude järgi. ");
INSERT INTO ekk_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tõesti, ma ütlen teile, siin seisavad mõned, kes ei maitse surma enne, kui näevad Inimese Poega oma Kuningriigis tulemas.“ ");
INSERT INTO ekk_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kuue päeva pärast võttis Jeesus endaga kaasa Peetruse, Jaakobuse ja tema venna Johannese ning viis nad üles kõrgele mäele. ");
INSERT INTO ekk_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Seal Jeesus muudeti nende nähes. Ta pale säras otsekui päike ja ta riided said valgeks otsekui valgus. ");
INSERT INTO ekk_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Siis Mooses ja Eelija ilmusid neile ja rääkisid Jeesusega. ");
INSERT INTO ekk_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peetrus ütles Jeesusele: „Issand, siin on meil hea olla! Kui sa soovid, siis ma teen siia kolm telki: sulle ühe, Moosesele ühe ja Eelijale ühe.“ ");
INSERT INTO ekk_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kui ta alles rääkis, siis helendav pilv kattis neid ja pilvest kostis hääl: „See on minu armas Poeg, kellest mul on hea meel. Teda kuulake!“ ");
INSERT INTO ekk_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Seda kuuldes langesid jüngrid hirmunult silmini maha; ");
INSERT INTO ekk_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","aga Jeesus astus nende juurde, puudutas neid ja ütles: „Tõuske üles, ärge kartke!“ ");
INSERT INTO ekk_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kui nad siis pilgu tõstsid, ei näinud nad kedagi muud kui ainult Jeesust. ");
INSERT INTO ekk_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mäelt alla laskudes keelas Jeesus neid: „Ärge rääkige sellest nägemusest kellelegi, enne kui Inimese Poeg on üles tõusnud surnuist!“ ");
INSERT INTO ekk_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","„Miks siis kirjatundjad ütlevad, et enne peab tulema Eelija?“ küsisid jüngrid temalt. ");
INSERT INTO ekk_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","„Eelija tuleb tõepoolest ja seab kõik korda,“ vastas Jeesus. ");
INSERT INTO ekk_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","„Aga ma ütlen teile, Eelija on juba tulnud, ent nad ei ole teda ära tundnud, vaid on temale teinud, mida nad tahtsid. Niisamuti peab ka Inimese Poeg kannatama nende käes.“ ");
INSERT INTO ekk_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Siis jüngrid said aru, et ta rääkis neile Ristija Johannesest. ");
INSERT INTO ekk_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kui nad rahva juurde jõudsid, lähenes Jeesusele üks mees, põlvitas ta ette ");
INSERT INTO ekk_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ja ütles: „Issand, halasta mu poja peale! Ta on langetõbine ja vaevleb hirmsasti. Ta kukub sageli tulle ja sageli vette! ");
INSERT INTO ekk_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ma tõin ta sinu jüngrite juurde, aga nemad ei suutnud teda tervendada.“ ");
INSERT INTO ekk_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","„Oh uskmatu ja rikutud sugupõlv,“ vastas Jeesus, „kui kaua ma pean teie juures olema? Kui kaua ma pean teiega kannatama? Tooge ta minu juurde!“ ");
INSERT INTO ekk_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ja Jeesus sõitles kurja vaimu, nii et see läks poisist välja ja samal tunnil sai poiss terveks. ");
INSERT INTO ekk_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kui nad siis olid omaette, astusid jüngrid Jeesuse juurde ja ütlesid: „Miks meie ei suutnud seda kurja vaimu välja ajada?“ ");
INSERT INTO ekk_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","„Sest teil on nii vähe usku!“ vastas Jeesus. „Tõesti, ma ütlen teile, kui teil oleks usku kasvõi sinepiseemne jagu, siis võiksite öelda sellele mäele: „Mine siit sinna!“, ja ta läheb. Miski ei oleks teile siis võimatu. ");
INSERT INTO ekk_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","See sugu ei lähe muidu välja kui aga palve ja paastumisega.“ ");
INSERT INTO ekk_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kui nad Galileas kokku said, ütles Jeesus neile: „Inimese Poeg antakse ära inimeste kätte ");
INSERT INTO ekk_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ja nad tapavad tema ning kolmandal päeval äratatakse ta üles.“ Ja jüngrid kurvastasid väga. ");
INSERT INTO ekk_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Aga kui Jeesus ja jüngrid Kapernauma jõudsid, tulid Peetruse juurde templimaksu kogujad ja küsisid: „Kas teie Õpetaja templimaksu ei maksa?“ ");
INSERT INTO ekk_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","„Maksab küll,“ vastas ta. Kui Peetrus majja tuli, alustas Jeesus juttu: „Mis sa arvad, Siimon, kelle käest võtavad maailma kuningad tolli ja maksu? Kas oma lastelt või võõrastelt?“ ");
INSERT INTO ekk_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","„Võõrastelt,“ vastas Peetrus. „Järelikult on lapsed sellest vabad,“ ütles Jeesus. ");
INSERT INTO ekk_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","„Aga et me neid ei pahandaks, mine järvele, viska õng vette ja tõmba välja esimene kala, mis otsa tuleb. Ja kui sa tema suu avad, leiad hõberaha. Anna see maksuks minu ja teie eest!“ ");
INSERT INTO ekk_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Sel ajal tulid jüngrid Jeesuse juurde ja küsisid: „Kes on siis suurim taevariigis?“ ");
INSERT INTO ekk_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jeesus kutsus enda juurde ühe lapse, pani nende keskele seisma ");
INSERT INTO ekk_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ja ütles: „Tõesti, ma ütlen teile, kui te ei pöördu ega saa selliseks nagu lapsed, ei pääse te taevariiki! ");
INSERT INTO ekk_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kes nüüd iseennast alandab nagu see laps, see ongi suurim taevariigis. ");
INSERT INTO ekk_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ja kes iganes ühe niisuguse lapse võtab vastu minu nimel, see võtab vastu minu. ");
INSERT INTO ekk_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Kes iganes ahvatleb patule ühe neist väikestest, kes minusse usuvad, sellele oleks parem, et veskikivi talle kaela seotaks ja ta uputataks mere sügavusse. ");
INSERT INTO ekk_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Häda maailmale ahvatluste pärast! On küll paratamatu, et ahvatlused tulevad, kuid häda sellele, kelle kaudu need tulevad. ");
INSERT INTO ekk_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Aga kui su käsi või jalg sunnib sind pattu tegema, raiu see ära ja viska minema! Sul on parem minna käteta või jalutuna ellu kui kahe käe ja kahe jalaga olla visatud igavesse tulle. ");
INSERT INTO ekk_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ja kui su silm ahvatleb sind patule, kisu see välja ja viska minema! Sul on parem ühe silmaga minna ellu kui kahe silmaga olla visatud põrgutulle. ");
INSERT INTO ekk_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Vaadake, et te ühtki neist pisikestest ei põlgaks! Sest ma ütlen teile, et nende inglid taevas näevad alati minu taevase Isa palet. ");
INSERT INTO ekk_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Sest Inimese Poeg on tulnud päästma kadunut. ");
INSERT INTO ekk_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mis teie arvate: kui kellelgi on sada lammast ja üks neist ära eksib, eks ta jäta need üheksakümmend üheksa mägedesse ja lähe otsima eksinut? ");
INSERT INTO ekk_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ja kui ta selle üles leiab, siis tõesti, ma ütlen teile, ta rõõmustab tema üle rohkem kui nende üheksakümne üheksa üle, kes ei olnud eksinud. ");
INSERT INTO ekk_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Samuti ei taha teie taevane Isa, et ükski neist pisikestest hukkuks. ");
INSERT INTO ekk_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Kui su vend teeb pattu, siis mine ja noomi teda nelja silma all. Kui ta sind kuulab, siis oled oma venna tagasi võitnud. ");
INSERT INTO ekk_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Aga kui ta sind ei kuula, siis võta enesega veel üks või kaks inimest, sest iga asi tuleb kinnitada kahe või kolme tunnistaja ütlusega. ");
INSERT INTO ekk_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aga kui ta ka neid ei kuula, siis räägi kogudusele. Ja kui ta isegi koguduse sõna ei kuula, siis olgu ta sinu jaoks nagu pagan või maksukoguja! ");
INSERT INTO ekk_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Tõesti, ma ütlen teile, mis te iganes kinni seote maa peal, on seotud ka taevas, ja mis te iganes lahti päästate maa peal, on päästetud lahti ka taevas. ");
INSERT INTO ekk_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Tõesti, taas ma ütlen teile, kui maa peal on kaks teie seast ühel meelel mingi asja suhtes, mida nad iganes paluvad, siis minu Isa, kes on taevas, annab selle neile. ");
INSERT INTO ekk_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Sest kus kaks või kolm on minu nimel koos, seal olen mina nende keskel.“ ");
INSERT INTO ekk_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Siis Peetrus astus tema juurde ja ütles: „Issand, mitu korda ma peaksin oma vennale andestama, kui ta mu vastu patustab? Kas kuni seitse korda?“ ");
INSERT INTO ekk_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jeesus vastas: „Ma ütlen sulle, mitte seitse, vaid seitsekümmend korda seitse. ");
INSERT INTO ekk_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Seepärast on taevariik kuninga sarnane, kes otsustas oma sulastega arved korda seada. ");
INSERT INTO ekk_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kui ta sellega algust tegi, toodi ta ette üks, kes võlgnes talle kümme tuhat talenti. ");
INSERT INTO ekk_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Et tal seda maksta ei olnud, käskis isand müüa maha tema, ta naise, lapsed ja kogu ta vara, ning tasuda sellega. ");
INSERT INTO ekk_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Sulane aga langes põlvili ta ette ja anus: „Kannata veel minuga ja ma maksan sulle kõik tagasi!“ ");
INSERT INTO ekk_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Isandal hakkas temast hale, ta laskis ta vabaks ja kustutas ta võla. ");
INSERT INTO ekk_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Aga kui see sulane oli välja läinud, leidis ta ühe kaassulase, kes võlgnes talle sada teenarit. Ta haaras temast kinni, hakkas teda kägistama ja ütles: „Maksa ära, mis sa mulle võlgned!“ ");
INSERT INTO ekk_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Siis see sulane langes tema jalge ette maha ja anus: „Kannata veel minuga ja ma maksan sulle tagasi!“ ");
INSERT INTO ekk_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tema aga ei olnud nõus, vaid laskis ta heita vanglasse, kuni ta oma võla tasub. ");
INSERT INTO ekk_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kui teised sulased nägid, mis sündis, olid nad väga nördinud ning rääkisid isandale kõik ära. ");
INSERT INTO ekk_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Siis kutsus isand mehe enese juurde ja ütles talle: „Sina nurjatu! Mina kustutasin kogu sinu võla, sest sa anusid mind. ");
INSERT INTO ekk_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Eks siis sinagi pidanud halastama oma kaassulase peale, nõnda nagu mina sinu peale halastasin?“ ");
INSERT INTO ekk_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ja ta isand vihastas ning andis ta vangivalvurite kätte piinata, kuni ta tasub kogu oma võla. ");
INSERT INTO ekk_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nõnda teeb ka minu taevane Isa teiega, kui teie kogu südamest ei anna andeks oma vennale.“ ");
INSERT INTO ekk_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kui Jeesus oli need kõned lõpetanud, lahkus ta Galileast ja tuli Juudamaa alale teisele poole Jordanit. ");
INSERT INTO ekk_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Talle järgnes suur rahvahulk, ja ta tegi neid seal terveks. ");
INSERT INTO ekk_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Jeesuse juurde tuli varisere, kes küsisid temalt kiusliku mõttega: „Kas mehel on luba lahutada oma naisest ükskõik mis põhjusel?“ ");
INSERT INTO ekk_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","„Kas te ei ole lugenud,“ vastas Jeesus, „et alguses „tegi Looja nad meheks ja naiseks?“ ");
INSERT INTO ekk_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ning ütles: „Seepärast jätab mees maha oma isa ja ema ning hoiab oma naise poole ja need kaks saavad üheks.“ ");
INSERT INTO ekk_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Siis nad ei ole enam kaks, vaid üks liha. Mis nüüd Jumal on ühte pannud, seda ärgu inimene lahutagu!“ ");
INSERT INTO ekk_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","„Miks siis Mooses on käskinud mehel lahutustunnistus anda, et naine minema saata?“ küsisid nad. ");
INSERT INTO ekk_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","„Teie kõva südame pärast lubas Mooses teil naise endast lahutada,“ ütles Jeesus, „aga alguses ei olnud see nõnda. ");
INSERT INTO ekk_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mina ütlen teile, et igaüks, kes lahutab oma naisest muul põhjusel kui abielurikkumine ja võtab teise, rikub abielu ja kes abiellub lahutatud naisega, rikub abielu.“ ");
INSERT INTO ekk_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","„Kui abielus on selline olukord mehe ja naise vahel, siis on parem mitte abielluda,“ arvasid jüngrid. ");
INSERT INTO ekk_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","„Mitte igaüks ei suuda leppida sellega, mida ma nüüd ütlen,“ vastas Jeesus, „vaid üksnes need, kellele see on antud: ");
INSERT INTO ekk_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","on kohitsetuid, kes on sellised emaüsast saadik, ja on neid, kes on inimeste poolt kohitsetud, ja on neid, kes elavad justkui kohitsetud taevariigi pärast. Kes suudab sellega leppida, see leppigu!“ ");
INSERT INTO ekk_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Siis toodi Jeesuse juurde lapsi, et ta paneks oma käed nende peale ja palvetaks; jüngrid aga tõrelesid toojatega. ");
INSERT INTO ekk_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Aga Jeesus ütles: „Laske lapsed minu juurde tulla, ärge keelake neid! Sest selliste päralt on taevariik.“ ");
INSERT INTO ekk_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ja kui ta oli neile käed peale pannud, läks ta sealt ära. ");
INSERT INTO ekk_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kord tuli tema juurde mees ja küsis: „Õpetaja, mis head ma pean tegema, et saada igavest elu?“ ");
INSERT INTO ekk_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jeesus ütles talle: „Miks sa minult pärid hea kohta? On vaid üks, kes on hea. Kui tahad ellu pääseda, siis pea kinni käskudest.“ ");
INSERT INTO ekk_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","„Millistest?“ küsis noormees. Jeesus vastas: „Ära tapa, ära riku abielu, ära varasta, ära anna valetunnistust, ");
INSERT INTO ekk_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","austa oma isa ja ema ning armasta oma ligimest nagu iseennast!“ ");
INSERT INTO ekk_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","„Seda kõike ma olen pidanud,“ vastas noormees. „Mis mul veel puudub?“ ");
INSERT INTO ekk_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","„Kui sa tahad olla täiuslik,“ ütles Jeesus, „siis müü ära kõik, mis sul on, ja jaga vaestele, ja sul on siis aare taevas, ning tule, järgne mulle!“ ");
INSERT INTO ekk_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Aga kui noormees neid sõnu kuulis, lahkus ta kurvana, sest tal oli palju vara. ");
INSERT INTO ekk_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jeesus aga ütles oma jüngritele: „Tõesti, ma ütlen teile, rikkal on raske pääseda taevariiki. ");
INSERT INTO ekk_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Taas ma ütlen teile, et hõlpsam on kaamelil minna läbi nõelasilma kui rikkal minna Jumala riiki.“ ");
INSERT INTO ekk_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Seda kuuldes jüngrid kohkusid väga. „Kes siis üldse võib saada päästetud?“ küsisid nad. ");
INSERT INTO ekk_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jeesus vaatas neile otsa ja ütles: „Inimestel ongi see võimatu, kuid Jumalal on kõik võimalik!“ ");
INSERT INTO ekk_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Siis vastas Peetrus: „Vaata, meie oleme jätnud kõik maha ja järgnenud sulle. Mis me sellest nüüd saame?“ ");
INSERT INTO ekk_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jeesus ütles neile: „Tõesti, ma ütlen teile, et teie, kes te olete mind järginud, uuestisündimises, kui Inimese Poeg istub oma auhiilguse troonile, istute ka ise kaheteistkümnele troonile ja mõistate kohut kaheteistkümne Iisraeli suguharu üle! ");
INSERT INTO ekk_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ja igaüks, kes on jätnud maha majad või vennad või õed või isa või ema või lapsed või põllud minu pärast, saab nad tagasi sajakordselt ning pärib igavese elu. ");
INSERT INTO ekk_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ent paljud esimesed jäävad viimasteks ja viimased saavad esimesteks.“ ");
INSERT INTO ekk_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","„Taevariik on kui peremees, kes läks hommikul vara värbama töölisi oma viinamäele. ");
INSERT INTO ekk_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kui ta oli nendega päevapalgaks kokku leppinud ühe teenari, läkitas ta nad viinamäele. ");
INSERT INTO ekk_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kolmanda tunni paiku läks ta välja ja nägi turuplatsil teisi jõude seismas. ");
INSERT INTO ekk_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","„Minge teiegi viinamäele!“ ütles ta neile. „Ma annan teile õiglase tasu!“ ");
INSERT INTO ekk_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ja nad läksid. Kuuendal ja üheksandal tunnil toimis peremees samamoodi. ");
INSERT INTO ekk_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Aga kui ta üheteistkümnendal tunnil välja läks, leidis ta veel töölisi seismas ja ütles neilegi: „Miks teie siin kogu päeva ilma tööta seisate?“ ");
INSERT INTO ekk_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","„Meid ei ole keegi palganud,“ vastasid nad. „Minge ka teie tööle mu viinamäele!“ käskis peremees. ");
INSERT INTO ekk_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kui õhtu kätte jõudis, ütles viinamäe isand töödejuhatajale: „Kutsu töölised ja maksa neile välja palk, alustades viimastest ja lõpetades esimestega!“ ");
INSERT INTO ekk_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Need, kes olid üheteistkümnendal tunnil palgatud, tulid ning said igaüks ühe teenari. ");
INSERT INTO ekk_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Aga kui tuli esimeste kord, arvasid nemad, et nad saavad rohkem, aga nemadki said igaüks ühe teenari. ");
INSERT INTO ekk_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ja nad nurisesid peremehe üle: ");
INSERT INTO ekk_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","„Need viimased tegid ainult ühe tunni tööd, ent sina oled nad teinud võrdseks meiega, kes me talusime päeva raskust ja palavust!“ ");
INSERT INTO ekk_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Peremees aga vastas ühele neist: „Sõber, ma ei tee sulle ülekohut! Kas sa ei leppinud minuga kokku ühe teenari peale? ");
INSERT INTO ekk_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Võta oma palk ja mine! Ja kui ma tahan maksta sellele viimasele sama palju kui sulle, ");
INSERT INTO ekk_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","kas ma ei tohi toimida oma varaga, nagu soovin? Või oled sa kade, et mina olen helde?“ ");
INSERT INTO ekk_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nõnda saavad viimased esimesteks ja esimesed jäävad viimasteks. Sest paljud on kutsutud, aga vähesed on valitud.“ ");
INSERT INTO ekk_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kui Jeesus läks üles Jeruusalemma, viis ta kaksteist jüngrit kõrvale ja ütles neile: ");
INSERT INTO ekk_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","„Me läheme üles Jeruusalemma ja Inimese Poeg antakse ülempreestrite ja kirjatundjate kätte. Need mõistavad ta surma ");
INSERT INTO ekk_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ja annavad tema uskmatute kätte mõnitada, piitsutada ja risti lüüa. Aga kolmandal päeval ta äratatakse üles.“ ");
INSERT INTO ekk_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Siis astus Sebedeuse poegade ema koos oma poegadega Jeesuse juurde ning kummardas ta ette, et temalt midagi paluda. ");
INSERT INTO ekk_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","„Mida sa soovid?“ küsis Jeesus. „Luba, et need mu kaks poega istuvad sinu Kuningriigis üks su paremal ja teine vasakul käel!“ ütles ta. ");
INSERT INTO ekk_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","„Teie ei tea, mida te palute,“ vastas Jeesus. „Kas te suudate juua karikast, mida minul tuleb juua?“ „Suudame küll!“ vastasid nad. ");
INSERT INTO ekk_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","„Tõepoolest te joote minu karikast,“ ütles Jeesus, „kuid kohta mu paremal ja vasakul käel ei saa ma teile anda. See kuulub neile, kellele mu Isa on selle valmistanud.“ ");
INSERT INTO ekk_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kui ülejäänud kümme sellest kuulsid, said nad pahaseks nende kahe venna peale. ");
INSERT INTO ekk_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ent Jeesus kutsus nad enese juurde ja ütles: „Te teate, et uskmatute valitsejad peremehetsevad nende üle ja võimukandjad kasutavad nende kallal jõudu. ");
INSERT INTO ekk_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kuid nõnda ärgu olgu see teie seas, vaid kes iganes teie seas tahab saada suureks, olgu teie teenija, ");
INSERT INTO ekk_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ning kes iganes teie seas tahab olla esimene, olgu teie sulane – ");
INSERT INTO ekk_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","nii nagu Inimese Poeg ei tulnud, et lasta ennast teenida, vaid et ise teenida ja anda oma elu lunastuseks paljude eest!“ ");
INSERT INTO ekk_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kui Jeesus ja jüngrid olid Jeerikost lahkumas, järgnes neile suur rahvahulk. ");
INSERT INTO ekk_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kaks pimedat istusid tee ääres ja kui nad kuulsid, et Jeesus läheb mööda, hüüdsid nad: „Halasta meie peale, Issand, Taaveti Poeg!“ ");
INSERT INTO ekk_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Rahvas hurjutas neid, et nad vait jääksid, aga nemad kisendasid seda kõvemini: „Halasta meie peale, Issand, Taaveti Poeg!“ ");
INSERT INTO ekk_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jeesus jäi seisma, kutsus nad lähemale ja küsis: „Mida te tahate, et ma teile teeksin?“ ");
INSERT INTO ekk_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","„Issand, et meie silmad avaneksid!“ ütlesid pimedad. ");
INSERT INTO ekk_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jeesusel hakkas neist kahju ja ta puudutas nende silmi. Ja kohe nad nägid ning järgnesid talle. ");
INSERT INTO ekk_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kui nad jõudsid Jeruusalemma lähedale ja tulid Betfage juurde Õlimäel, läkitas Jeesus kaks jüngrit ");
INSERT INTO ekk_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ja ütles: „Minge külla, mis on teie ees, ja kohe te leiate seal kinniseotud eesli koos säluga. Siduge nad lahti ja tooge mulle! ");
INSERT INTO ekk_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kui keegi teile midagi ütleb, siis vastake, et Issand vajab neid ja ta läkitab nad peatselt tagasi.“ ");
INSERT INTO ekk_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Aga see on sündinud, et läheks täide, mida on öeldud prohveti suu läbi: ");
INSERT INTO ekk_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","„Teatage Siioni tütrele: „Vaata, su kuningas tuleb sinu juurde, alandlikult eesli seljas, veolooma poja, sälu seljas.“ “ ");
INSERT INTO ekk_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jüngrid läksid ja tegid, nagu Jeesus oli juhatanud. ");
INSERT INTO ekk_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nad tõid eesli ja sälu, katsid nad oma kuubedega ning Jeesus istus sinna. ");
INSERT INTO ekk_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Väga suur rahvahulk aga laotas oma rõivad tee peale, teised lõikasid oksi puudelt ja laotasid tee peale. ");
INSERT INTO ekk_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Aga rahvahulgad, kes kõndisid Jeesuse eel ja järel, hüüdsid: „Hoosanna Taaveti Pojale!“ „Õnnistatud olgu, kes tuleb Issanda nimel!“ „Hoosanna kõrgeimas taevas!“ ");
INSERT INTO ekk_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kui Jeesus Jeruusalemma jõudis, läks kogu linn elevile. „Kes see on?“ küsisid nad. ");
INSERT INTO ekk_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","„Tema on prohvet Jeesus Naatsaretist Galileas!“ vastas rahvahulk. ");
INSERT INTO ekk_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jeesus aga läks templisse, ajas välja kõik, kes ostsid ja müüsid seal ning lükkas kummuli rahavahetajate lauad ja tuvimüüjate pingid. ");
INSERT INTO ekk_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ta ütles neile: „Kirjutatud on: „Minu koda hüütagu palvekojaks,“ aga teie olete teinud selle röövlikoopaks!“ ");
INSERT INTO ekk_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Templis tuli Jeesuse juurde pimedaid ja jalutuid ja ta tegi nad terveks. ");
INSERT INTO ekk_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kui ülempreestrid ja kirjatundjad nägid Jeesuse imetegusid ning lapsi, kes templis hüüdsid: „Hoosanna Taaveti Pojale!“, siis nad said vihaseks ");
INSERT INTO ekk_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ja küsisid temalt: „Kas sa kuuled, mida need lapsed ütlevad?“ „Jah,“ vastas Jeesus. „Kas te pole kunagi lugenud: „väikelaste ja imikute suust sina, Issand, lased kõlada kiitust“?“ ");
INSERT INTO ekk_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ja jättes nad sinnapaika, läks ta linnast välja Betaaniasse ja ööbis seal. ");
INSERT INTO ekk_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Varahommikul linna tagasi pöördudes tundis Jeesus nälga, ");
INSERT INTO ekk_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ja nähes viigipuud tee ääres, läks ta selle juurde. Ent leidmata sealt midagi peale lehtede, ütles ta viigipuule: „Ära iialgi enam kanna vilja!“ Ja viigipuu kuivas otsekohe ära. ");
INSERT INTO ekk_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kui jüngrid seda nägid, küsisid nad imestades: „Kuidas see viigipuu nii kiiresti ära kuivas?“ ");
INSERT INTO ekk_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Aga Jeesus vastas: „Tõesti, ma ütlen teile, kui teil on usku ja te ei kahtle, siis te ei tee üksnes nii nagu mina viigipuuga, vaid ütlete sellele mäele: „Tõuse paigast ja lange merre!“, ja see sünnib. ");
INSERT INTO ekk_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kui te usute, siis te saate kõike, mida te palves küsite!“ ");
INSERT INTO ekk_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jeesus tuli templisse, ja kui ta hakkas õpetama, astusid ülempreestrid ja rahvavanemad tema juurde ja küsisid: „Millise meelevallaga sa seda kõike teed? Ja kes on sulle andnud selle meelevalla?“ ");
INSERT INTO ekk_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Aga Jeesus vastas neile: „Ka mina küsin teilt midagi. Kui te mulle vastate, ütlen minagi teile, millise meelevallaga ma seda teen. ");
INSERT INTO ekk_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kust pärines Johannese ristimine: kas taevast või inimestest?“ „Kui me ütleme, et taevast,“ arutasid nad omavahel, „küsib ta meilt: „Miks te siis ei uskunud teda?“ ");
INSERT INTO ekk_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kui me aga ütleme, et inimestest, siis tuleb meil karta rahvast, sest kõik peavad Johannest prohvetiks.“ ");
INSERT INTO ekk_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ja nad vastasid Jeesusele: „Me ei tea!“ Tema vastas omakorda: „Ega minagi ütle teile, millise meelevallaga ma seda teen. ");
INSERT INTO ekk_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Aga mis te sellest arvate? Ühel mehel oli kaks poega. Ta läks esimese juurde ja ütles: „Poeg, mine täna tööle viinamäele!“ ");
INSERT INTO ekk_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","„Ma ei lähe,“ vastas ta, aga hiljem muutis ta meelt ja läks. ");
INSERT INTO ekk_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Isa läks teise poja juurde ja ütles talle sedasama. „Ma lähen, isand,“ vastas poeg, kuid ta ei läinud. ");
INSERT INTO ekk_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kumb neist kahest täitis isa tahet?“ „Esimene,“ vastasid nad. „Tõesti, ma ütlen teile,“ ütles Jeesus, „maksukogujad ja hoorad pääsevad enne teid Jumala riiki! ");
INSERT INTO ekk_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Sest Johannes tuli teie juurde õiguse teed näitama, aga teie ei uskunud teda, kuid maksukogujad ja hoorad uskusid. Ja ehk te küll seda nägite, ei parandanud te meelt ega uskunud teda. ");
INSERT INTO ekk_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kuulake veel ühte tähendamissõna. Oli kord mees, kes istutas viinamäe. Ta piiras selle aiaga, õõnestas kaljusse surutõrre ja ehitas valvetorni. Siis ta andis viinamäe rentnike kätte ja reisis ära. ");
INSERT INTO ekk_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kui saagiaeg kätte jõudis, saatis ta sulaseid rentnike juurde oma saagiosa vastu võtma. ");
INSERT INTO ekk_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Aga rentnikud võtsid ta sulased kinni – ühte nad peksid, teise tapsid, kolmanda viskasid kividega surnuks. ");
INSERT INTO ekk_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nüüd saatis peremees teised sulased, rohkem kui eelmisel korral, aga rentnikud tegid nendega samamoodi. ");
INSERT INTO ekk_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Viimaks ta läkitas nende juurde oma poja. „Minu poega nad austavad!“ mõtles ta. ");
INSERT INTO ekk_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kuid rentnikud rääkisid poega nähes omavahel: „Tema ongi pärija. Lähme, tapame ta ära, siis saame ta pärandi endale!“ ");
INSERT INTO ekk_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nad võtsid ta kinni, viskasid viinamäelt välja ja tapsid ära. ");
INSERT INTO ekk_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kui nüüd viinamäe isand tuleb, mida ta teeb nende rentnikega?“ ");
INSERT INTO ekk_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","„Ta hukkab need kurjad kurjal kombel,“ ütlesid nad, „ja annab viinamäe teiste rentnike kätte, kes tasuvad ta saagiosa õigel ajal.“ ");
INSERT INTO ekk_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","„Kas te ei ole kunagi lugenud Pühakirjast,“ ütles Jeesus neile, „ „Kivi, mille ehitajad pidasid kõlbmatuks, on saanud nurgakiviks. See tuli Issandalt ja on imeline meie silmis.“ ");
INSERT INTO ekk_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Seepärast ma ütlen teile, Jumala riik võetakse teie käest ära ja antakse rahvale, kes selle vilja kannab. ");
INSERT INTO ekk_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kes selle kivi peale kukub, kukub end puruks, ja kelle peale see kivi langeb, selle see purustab.“ ");
INSERT INTO ekk_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kui ülempreestrid ja variserid seda Jeesuse tähendamissõna kuulsid, mõistsid nad, et ta räägib seda nende kohta. ");
INSERT INTO ekk_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ja nad otsisid võimalust teda kinni võtta, kuid kartsid rahvahulka, sest need pidasid Jeesust prohvetiks. ");
INSERT INTO ekk_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jeesus rääkis neile veel tähendamissõnades ja ütles: ");
INSERT INTO ekk_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","„Taevariik on kui kuningas, kes korraldas oma pojale pulmapeo. ");
INSERT INTO ekk_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ta läkitas oma sulased juba kutsutuid pulmapeole paluma, aga nemad keeldusid. ");
INSERT INTO ekk_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Taas ta läkitas teisi sulaseid ja käskis kutsutuile öelda: „Ma olen pidusöögi valmistanud. Mu härjad ja nuumvasikad on tapetud ja kõik on valmis. Tulge pulma!“ ");
INSERT INTO ekk_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nemad aga ei teinud sellest väljagi ja läksid, kes põllule, kes äriasju ajama. ");
INSERT INTO ekk_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Mõned aga võtsid sulased kinni, mõnitasid neid jõhkralt ja tapsid nad ära. ");
INSERT INTO ekk_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kuningas sai väga vihaseks. Ta saatis oma sõjaväe, hukkas need mõrtsukad ja põletas maha nende linna. ");
INSERT INTO ekk_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Siis ta ütles oma sulastele: „Pulmapidu on ette valmistatud, aga kutsutud ei olnud väärt tulema. ");
INSERT INTO ekk_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Seepärast minge tänavanurkadele ja kutsuge pulma, keda te iganes leiate!“ ");
INSERT INTO ekk_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ja sulased läksid välja teedele ja tõid kokku kõik, keda leidsid, nii häid kui halbu, ning pulmasaal sai täis külalisi. ");
INSERT INTO ekk_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Aga kui kuningas astus sisse külalisi vaatama, märkas ta meest, kellel ei olnud pulmariideid seljas. ");
INSERT INTO ekk_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","„Sõber,“ ütles ta temale, „kuidas sina oled tulnud siia ilma pulmariieteta?“ See aga ei suutnud midagi vastata. ");
INSERT INTO ekk_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Siis kuningas ütles oma teenritele: „Siduge kinni tema jalad ja käed ning visake ta välja pimedusse, kus on ulgumine ja hammaste kiristamine!“ ");
INSERT INTO ekk_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sest paljud on kutsutud, aga vähesed valitud.“ ");
INSERT INTO ekk_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Siis variserid läksid ja pidasid nõu, kuidas Jeesus tema sõnadest lõksu püüda. ");
INSERT INTO ekk_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nad läkitasid ta juurde oma jüngreid koos heroodeslastega. „Õpetaja,“ ütlesid nad, „me teame, et sina oled aus ja otsekohene ning õpetad Jumala teed tões ega lase end mõjutada kellestki, sest sa ei tee inimestel vahet. ");
INSERT INTO ekk_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Seepärast ütle meile oma arvamus. Kas on õige maksta keisrile maksu või mitte?“ ");
INSERT INTO ekk_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kuid Jeesus, teades nende alatust, ütles: „Miks te mind kiusate, silmakirjatsejad? ");
INSERT INTO ekk_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Näidake mulle maksumünti!“ Nad tõid talle teenari, ");
INSERT INTO ekk_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ja ta küsis neilt: „Kelle pilt ja nimi sellel on?“ ");
INSERT INTO ekk_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","„Keisri,“ vastasid nad. Siis Jeesus ütles neile: „Andke siis keisrile, mis kuulub keisrile, ja Jumalale, mis kuulub Jumalale!“ ");
INSERT INTO ekk_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Seda kuuldes nad hämmastusid, jätsid ta rahule ja lahkusid. ");
INSERT INTO ekk_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Samal päeval tulid Jeesuse juurde saduserid, kes eitavad surnuist ülestõusmist, ja küsisid temalt: ");
INSERT INTO ekk_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","„Õpetaja, Mooses on meile öelnud, et kui mees sureb lapsi saamata, siis peab tema vend abielluma lesega ja talle järglasi kasvatama. ");
INSERT INTO ekk_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Meie hulgas oli seitse venda. Esimene võttis naise ja suri. Kuna tal ei olnud järglasi, jättis ta naise oma vennale. ");
INSERT INTO ekk_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Samuti juhtus teise ja kolmandaga, kuni kõik seitse venda olid surnud. ");
INSERT INTO ekk_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kõige viimasena suri naine. ");
INSERT INTO ekk_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kui nüüd tuleb ülestõusmine, kelle naine neist seitsmest ta siis on? Ta on ju olnud abielus nende kõikidega.“ ");
INSERT INTO ekk_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jeesus vastas neile: „Te eksite, kuna ei tunne Pühakirja ega Jumala väge. ");
INSERT INTO ekk_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ülestõusmises ei võeta naisi ega minda mehele, vaid ollakse nagu inglid taevas. ");
INSERT INTO ekk_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Aga mis puutub surnute ülestõusmisse – kas te ei ole lugenud, mida Jumal teile on rääkinud: ");
INSERT INTO ekk_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","„Mina olen Aabrahami Jumal ja Iisaki Jumal ja Jaakobi Jumal!“ Jumal ei ole surnute, vaid elavate Jumal.“ ");
INSERT INTO ekk_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Seda kuuldes rahvas hämmastus tema õpetusest. ");
INSERT INTO ekk_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kui variserid kuulsid, et Jeesus oli sulgenud saduseridel suu, kogunesid nad sinna ");
INSERT INTO ekk_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ning üks kirjatundja nende seast küsis Jeesuselt teda proovile pannes: ");
INSERT INTO ekk_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","„Õpetaja, milline käsk Seaduses on suurim?“ ");
INSERT INTO ekk_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jeesus vastas: „ „Armasta Issandat, oma Jumalat, kogu oma südamest, kogu oma hingest ja kogu oma mõistusest!“ ");
INSERT INTO ekk_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","See on suurim ja ülim käsk. ");
INSERT INTO ekk_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ja teine on selle sarnane: „Armasta oma ligimest nagu iseennast!“ ");
INSERT INTO ekk_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Neis kahes käsus on koos kogu Seadus ja Prohvetid.“ ");
INSERT INTO ekk_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pöördudes kokku tulnud variseride poole, küsis Jeesus neilt: ");
INSERT INTO ekk_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","„Mida te arvate Messia kohta: kelle poeg ta on?“ „Taaveti poeg,“ vastasid nad. ");
INSERT INTO ekk_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","„Miks siis Taavet nimetab teda Pühas Vaimus rääkides Issandaks?“ küsis Jeesus. „Ta ütleb ju: ");
INSERT INTO ekk_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","„Issand ütles minu Issandale: „Istu mu paremale käele, kuni ma panen sinu vaenlased su jalge alla.“ “ ");
INSERT INTO ekk_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Kui nüüd Taavet hüüab teda Issandaks, kuidas ta siis on tema poeg?“ ");
INSERT INTO ekk_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ja ükski ei suutnud Jeesusele vastata sõnagi ning keegi ei söandanud sellest päevast alates temalt midagi rohkem küsida. ");
INSERT INTO ekk_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jeesus rääkis rahvale ja oma jüngritele: ");
INSERT INTO ekk_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","„Moosese asemele on ennast pannud kirjatundjad ja variserid,“ ütles ta. ");
INSERT INTO ekk_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","„Kõike nüüd, mis nad iganes teile ütlevad, seda tehke ja pidage, aga nende tegude järgi ärge tehke, sest nad ütlevad küll, aga ise ei tee. ");
INSERT INTO ekk_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nad seovad kokku raskeid koormaid ja panevad neid inimeste õlgadele, aga ise ei taha sõrmeotsagagi neid liigutada. ");
INSERT INTO ekk_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kõiki oma tegusid teevad nad selleks, et inimesed neid vaataksid. Nad teevad oma palvevööd laiemaks ja ääretutid oma rüüdel suuremaks. ");
INSERT INTO ekk_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nad armastavad aukohti pidulauas ja esimesi istmeid sünagoogides, ");
INSERT INTO ekk_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","tervitusi turuplatsidel ja inimeste suust austavat nimetust „rabi“. ");
INSERT INTO ekk_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Teie ärge laske endid hüüda rabiks, sest teil on ainult üks Õpetaja ja teie kõik olete vennad. ");
INSERT INTO ekk_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ja ärge hüüdke kedagi siin maa peal isaks, sest ainult üks on teie Isa, kes on taevas. ");
INSERT INTO ekk_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Samuti ärge laske end hüüda juhatajaks, sest ainult üks on teie Juhataja – Messias! ");
INSERT INTO ekk_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Aga suurim teie seast olgu teie teenija! ");
INSERT INTO ekk_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sest kes ennast ise ülendab, seda alandatakse, ja kes ennast ise alandab, seda ülendatakse! ");
INSERT INTO ekk_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Kuid häda teile, kirjatundjad ja variserid, te silmakirjatsejad, et te lukustate taevariigi ukse inimeste eest! Ise te ei lähe sinna sisse ega lase sisse ka neid, kes tahavad minna. ");
INSERT INTO ekk_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Häda teile, kirjatundjad ja variserid, te silmakirjatsejad, et te neelate alla lesknaiste majad ja silmakirjaks venitate palvetused pikaks! Seda rängem on teie kohtuotsus. ");
INSERT INTO ekk_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Häda teile, kirjatundjad ja variserid, te silmakirjatsejad! Te käite läbi mered ja maad, et pöörata ühtainustki oma usku. Ja kui see teil korda läheb, siis te teete temast kaks korda hullema põrgu lapse kui te ise olete! ");
INSERT INTO ekk_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Häda teile, pimedad teejuhid, kes ütlete: „Kes iganes vannub templi juures, selle vanne ei loe midagi. Aga kes iganes vannub templi kulla juures, siis tuleb vannet pidada.“ ");
INSERT INTO ekk_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Te pimedad narrid! Kumb on tähtsam – kas kuld või tempel, mis kulla pühitseb? ");
INSERT INTO ekk_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Te ütlete: „Kes iganes vannub altari juures, selle vanne ei loe midagi. Aga kes iganes vannub altaril oleva ohvri juures, see on kohustatud vannet täitma.“ ");
INSERT INTO ekk_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Te pimedad! Kumb siis on tähtsam: kas ohvriand või altar, mis ohvrianni pühitseb? ");
INSERT INTO ekk_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Seepärast, kes vannub altari juures, vannub nii altari kui kõige juures, mis on altaril, ");
INSERT INTO ekk_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ja kes vannub templi juures, vannub nii templi kui ka tema juures, kes templis elab, ");
INSERT INTO ekk_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ja kes vannub taeva juures, vannub nii Jumala trooni kui troonil istuja juures. ");
INSERT INTO ekk_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Häda teile, kirjatundjad ja variserid, te silmakirjatsejad! Te maksate kümnist mündist, tillist ja köömnest, kuid jätate kõrvale kaalukama osa Seaduses – õigluse, halastuse ja ustavuse. Seda oleksite pidanud täitma ja ülejäänut mitte unarusse jätma! ");
INSERT INTO ekk_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Te pimedad teejuhid, te sõelute välja sääsed, kuid kaamelid neelate alla! ");
INSERT INTO ekk_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Häda teile, kirjatundjad ja variserid, te silmakirjatsejad! Te puhastate karika ja vaagna väljastpoolt, aga seest on need täis ahnust ja isekust. ");
INSERT INTO ekk_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Pime variser! Puhasta esmalt karika sisemus, et see ka väljast saaks puhtaks! ");
INSERT INTO ekk_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Häda teile, kirjatundjad ja variserid, te silmakirjatsejad! Te olete nagu lubjatud hauad, mis paistavad väljastpoolt kenad, aga seestpoolt on täis surnuluid ja kõike roojast. ");
INSERT INTO ekk_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nõnda paistate ka teie inimestele õigetena, aga seestpoolt olete täis silmakirjatsemist ja ülekohut. ");
INSERT INTO ekk_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Häda teile, kirjatundjad ja variserid, te silmakirjatsejad! Te ehitate prohvetitele haudu ja kaunistate õigete mälestusmärke. ");
INSERT INTO ekk_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Te ütlete: „Kui meie oleksime elanud oma esiisade päevil, siis meie küll ei oleks koos nendega prohvetite verd valanud.“ ");
INSERT INTO ekk_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nõnda te tunnistate ise eneste kohta, et olete prohvetite tapjate lapsed. ");
INSERT INTO ekk_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Täitke siis teiegi oma esiisade patu mõõt! ");
INSERT INTO ekk_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Te ussid! Te rästikute sugu! Kuidas te võiksite põgeneda ära karistuse eest põrgus? ");
INSERT INTO ekk_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Seepärast ma läkitan teie juurde prohveteid ja tarku ja õpetajaid. Mõned neist te tapate ja lööte risti, teisi te piitsutate oma sünagoogides ja jälitate linnast linna. ");
INSERT INTO ekk_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Et teie peale tuleks kõik õigete veri, mis on valatud maa peal alates õige Aabeli verest kuni Berekja poja Sakarja vereni, kelle te tapsite templi ja altari vahel. ");
INSERT INTO ekk_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tõesti, ma ütlen teile, see kõik tuleb selle sugupõlve peale! ");
INSERT INTO ekk_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jeruusalemm, Jeruusalemm, kes sa tapad prohveteid ja viskad kividega surnuks sinu juurde läkitatuid! Kui sageli olen ma soovinud su lapsed kokku koguda, otsekui kana kogub oma pojad tiibade alla, kuid teie ei ole tahtnud! ");
INSERT INTO ekk_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Pange tähele, teie maja jäetakse teile tühjana! ");
INSERT INTO ekk_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Sest mina ütlen teile, teie ei näe mind nüüdsest enam, kuni te ütlete: „Õnnistatud olgu, kes tuleb Issanda nimel!“ “ ");
INSERT INTO ekk_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jeesus väljus templist ja sammus edasi. Jüngrid aga astusid tema juurde, et talle templi hooneid näidata. ");
INSERT INTO ekk_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","„Eks te näe seda kõike?“ küsis Jeesus. „Tõesti, ma ütlen teile, ei jäeta siin kivi kivi peale, mida maha ei kistaks!“ ");
INSERT INTO ekk_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kui Jeesus istus Õlimäel, astusid jüngrid tema juurde ja küsisid omavahel olles: „Ütle meile, millal see kõik tuleb ja mis on sinu tulemise ja selle ajastu lõpu tunnustäht?“ ");
INSERT INTO ekk_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jeesus vastas neile: „Vaadake, et keegi teid ei eksitaks! ");
INSERT INTO ekk_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sest paljud tulevad minu nimel, öeldes: „Mina olen Messias!“ ja eksitavad paljusid. ");
INSERT INTO ekk_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Aga kui te kuulete sõdadest ja kuulujutte sõjast, siis ärge heituge. Sest need asjad peavad sündima, kuid see ei ole veel lõpp. ");
INSERT INTO ekk_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Sest rahvas tõuseb rahva vastu ja kuningriik kuningriigi vastu ning paljudes paikades on maavärinaid ja näljahäda. ");
INSERT INTO ekk_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","See kõik on aga sünnitusvalude algus. ");
INSERT INTO ekk_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Siis antakse teid viletsusse ja teid tapetakse ja te saate kõigi rahvaste vihaaluseks minu nime pärast. ");
INSERT INTO ekk_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sellel ajal taganevad paljud usust ning reedavad ja vihkavad üksteist. ");
INSERT INTO ekk_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Palju valeprohveteid tõuseb esile ja need eksitavad paljusid. ");
INSERT INTO ekk_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ja et ülekohus kasvab, jahtub paljude armastus. ");
INSERT INTO ekk_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Aga kes peab vastu lõpuni, see pääseb. ");
INSERT INTO ekk_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ja seda Kuningriigi evangeeliumi kuulutatakse kogu maailmas, tunnistuseks kõigile rahvastele, ja siis saabub lõpp. ");
INSERT INTO ekk_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Kui te siis näete pühas paigas seismas hävituse koletist, millest on rääkinud prohvet Taaniel – et lugeja mõistaks! –, ");
INSERT INTO ekk_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","siis need, kes on Juudamaal, põgenegu mägedesse. ");
INSERT INTO ekk_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kes on katusel, ärgu tulgu alla oma majast midagi võtma, ");
INSERT INTO ekk_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ja kes on põllul, ärgu pöördugu tagasi võtma oma kuube! ");
INSERT INTO ekk_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Häda neile, kes on lapseootel, ja neile, kes imetavad sellel ajal! ");
INSERT INTO ekk_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Palvetage, et teie põgenemine ei juhtuks talvel ega hingamispäeval! ");
INSERT INTO ekk_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sest siis on nii suur ahistus, mille sarnast pole olnud maailma algusest kuni praeguse ajani ega tule enam iial. ");
INSERT INTO ekk_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ja kui neid päevi ei lühendataks, siis ei pääseks ükski. Kuid Jumala valitute pärast lühendatakse neid päevi. ");
INSERT INTO ekk_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kui siis keegi teile ütleb: „Näe, Messias on siin!“ või „Ta on seal!“, siis ärge uskuge! ");
INSERT INTO ekk_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sest tõuseb valemessiaid ja valeprohveteid ja need teevad suuri tunnustähti ja imesid, et eksitada, kui võimalik, isegi valituid. ");
INSERT INTO ekk_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Vaata, mina olen teid ette hoiatanud! ");
INSERT INTO ekk_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kui keegi teile siis ütleb: „Ta on seal, kõrbes!“, ärge siis minge välja; või: „Ta on siin, salakambris!“, siis ärge uskuge! ");
INSERT INTO ekk_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sest otsekui välk sähvatab idast ja paistab läände, nõnda on Inimese Poja tulemine. ");
INSERT INTO ekk_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kus iganes on korjus, sinna kogunevad raisakotkad. ");
INSERT INTO ekk_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Kohe pärast selle aja viletsust „pimeneb päike ja kuu ei anna oma valgust, tähed kukuvad taevast ja taeva vägesid kõigutatakse“. ");
INSERT INTO ekk_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Siis saab nähtavaks Inimese Poja tunnustäht taevas; ja siis tõstavad hädakisa maa peal kõik rahvad, kui nad näevad Inimese Poega tulemas taeva pilvede peal väe ja suure kirkusega. ");
INSERT INTO ekk_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ja tema läkitab oma inglid valju pasunahäälega ja need koguvad kokku tema valitud nelja tuule poolt, igast taevakaarest. ");
INSERT INTO ekk_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ent õppige viigipuult! Kui selle okstele tärkavad võrsed ja ajavad lehti, siis te teate, et suvi on lähedal. ");
INSERT INTO ekk_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nõnda ka teie, kui te näete kõike seda sündimas, siis teadke, et tema on lähedal, ukselävel. ");
INSERT INTO ekk_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tõesti, ma ütlen teile, see sugupõlv ei kao, kuni kõik see on sündinud. ");
INSERT INTO ekk_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Taevas ja maa kaovad, kuid minu sõnad ei kao iial. ");
INSERT INTO ekk_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ent seda päeva ja tundi ei tea keegi, ei inglid taevas ega Poeg, vaid Isa üksi. ");
INSERT INTO ekk_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Sest nii nagu olid Noa päevad, nii on ka Inimese Poja tulemine. ");
INSERT INTO ekk_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Neil päevil enne veeuputust inimesed sõid ja jõid, võtsid naisi ja läksid mehele selle päevani, mil Noa läks laeva. ");
INSERT INTO ekk_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nad ei teadnud midagi, enne kui tuli veeuputus ja võttis nad kõik ära. Nõnda on ka Inimese Poja tulemine. ");
INSERT INTO ekk_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Siis on kaks põllul – üks võetakse vastu ja teine jäetakse maha. ");
INSERT INTO ekk_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kaks naist on veskil jahvatamas – üks võetakse vastu ja teine jäetakse maha. ");
INSERT INTO ekk_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Seepärast valvake, sest teie ei tea, mis tunnil teie Issand tuleb! ");
INSERT INTO ekk_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Küllap te mõistate, et kui peremees teaks, millisel öötunnil varas tuleb, siis ta valvaks ega laseks oma majja sisse murda. ");
INSERT INTO ekk_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Seepärast olge ka teie valmis, sest Inimese Poeg tuleb tunnil, mil te ei arvagi! ");
INSERT INTO ekk_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Kes siis on ustav ja arukas sulane, kelle ta isand on seadnud oma majapidamise üle teenijatele õigel ajal toitu andma? ");
INSERT INTO ekk_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Õnnistatud on sulane, kelle ta isand tulles leiab nõnda tegevat! ");
INSERT INTO ekk_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tõesti, ma ütlen teile, ta annab tema hoolde kogu oma vara. ");
INSERT INTO ekk_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Aga kui sulane on halb ja mõtleb: „Mu isanda tulek viibib,“ ");
INSERT INTO ekk_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ning hakkab peksma kaassulaseid, sööma ja jooma koos purjutajatega, ");
INSERT INTO ekk_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","siis selle sulase isand tuleb päeval, mil ta ei oota, ja tunnil, mida ta ei tea. ");
INSERT INTO ekk_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ta raiub sulase tükkideks ja annab talle sama koha silmakirjatsejatega seal, kus on ulgumine ja hammaste kiristamine. ");
INSERT INTO ekk_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Siis on taevariik kui kümme neitsit, kes võtsid oma lambid ja läksid peigmehele vastu. ");
INSERT INTO ekk_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Viis neist olid rumalad ja viis arukad. ");
INSERT INTO ekk_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Rumalad võtsid kaasa küll lambid, kuid ei võtnud õli. ");
INSERT INTO ekk_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Arukad võtsid aga lampidele lisaks kaasa õlianumad. ");
INSERT INTO ekk_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kui peigmehe tulek viibis, jäid nad kõik uniseks ja uinusid magama. ");
INSERT INTO ekk_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Keskööl aga kõlas hüüd: „Peigmees tuleb! Minge talle vastu!“ ");
INSERT INTO ekk_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Siis ärkasid kõik need neitsid ja hakkasid lampe kohendama. ");
INSERT INTO ekk_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ja rumalad ütlesid arukatele: „Andke meile osa oma õlist, sest meie lambid kustuvad!“ ");
INSERT INTO ekk_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kuid arukad vastasid: „Ei mingil juhul! Sellest ei jätku meile ja teile! Minge parem kaupmeeste juurde ja ostke enestele ise!“ ");
INSERT INTO ekk_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ent kui nad olid teel õli ostma, tuli peigmees, ja kes olid valmis, sisenesid temaga pulmamajja, ja uks suleti. ");
INSERT INTO ekk_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Hiljem tulid ka need teised neitsid ja ütlesid: „Isand, isand, ava meile!“ ");
INSERT INTO ekk_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tema aga vastas neile: „Tõesti, ma ütlen teile, ma ei tunne teid.“ ");
INSERT INTO ekk_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Seepärast valvake, sest te ei tea seda päeva ega tundi! ");
INSERT INTO ekk_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ja jälle, taevariik on kui mees, kes pidi minema reisile. Ta kutsus oma sulased ja usaldas vara nende hoolde. ");
INSERT INTO ekk_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ühele ta andis viis talenti, teisele kaks ja kolmandale ühe, igaühele tema suutlikkust mööda, ning reisis ära. ");
INSERT INTO ekk_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kohe läks see, kes oli saanud viis talenti, paigutas need ärisse ja teenis veel viis talenti. ");
INSERT INTO ekk_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nõndasamuti ka kaks talenti saanu sai teist kaks juurde. ");
INSERT INTO ekk_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Aga kes oli saanud ühe, läks ja kaevas maasse augu ning peitis ära oma isanda raha. ");
INSERT INTO ekk_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Pika aja pärast tuli nende sulaste isand tagasi ja päris neilt aru. ");
INSERT INTO ekk_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tema ette astus see, kes oli saanud viis talenti, lisas sellele veel viis talenti ja ütles: „Isand, sa usaldasid mulle viis talenti. Vaata, ma olen teeninud teist viis talenti!“ ");
INSERT INTO ekk_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Isand ütles talle: „Hästi tehtud, sa tubli ja ustav sulane! Sa oled olnud ustav pisku üle, ma panen su palju üle. Tule sisse ja saa osa oma isanda rõõmust!“ ");
INSERT INTO ekk_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tuli ka see, kes oli saanud kaks talenti, ja ütles: „Isand, sa usaldasid mulle kaks talenti. Vaata, ma olen teeninud veel kaks!“ ");
INSERT INTO ekk_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Isand ütles tallegi: „Hästi tehtud, sa tubli ja ustav sulane! Sa oled olnud ustav pisku üle, ma panen su palju üle. Tule sisse ja saa osa oma isanda rõõmust!“ ");
INSERT INTO ekk_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tuli ka see, kes oli saanud ühe talendi. Ta ütles: „Isand, ma tean, et sa oled vali mees. Sa lõikad sealt, kuhu sa ei ole külvanud, ja kogud sealt, kuhu sa ei ole seemet puistanud. ");
INSERT INTO ekk_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ma kartsin, läksin ja peitsin sinu talendi maa sisse. Vaata, siin on sinu oma!“ ");
INSERT INTO ekk_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tema isand aga vastas talle: „Sa halb ja laisk sulane! Sa teadsid, et ma lõikan sealt, kuhu ma ei ole külvanud, ja kogun sealt, kuhu ma ei ole seemet puistanud! ");
INSERT INTO ekk_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Siis sa oleksid pidanud mu raha panema panka, ja tulles ma oleksin saanud selle tagasi kasuga. ");
INSERT INTO ekk_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Seepärast võtke nüüd tema käest talent ära ja andke sellele, kellel on kümme talenti! ");
INSERT INTO ekk_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sest igaühele, kellel on, antakse, ja tal on rohkem kui küllalt, kellel aga ei ole, selle käest võetakse ära seegi, mis tal on. ");
INSERT INTO ekk_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ja see vääritu sulane visake välja pimedusse! Seal on ulgumine ja hammaste kiristamine.“ ");
INSERT INTO ekk_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Aga kui Inimese Poeg tuleb oma auhiilguses kõigi inglite saatel, siis ta istub oma auhiilguse troonile. ");
INSERT INTO ekk_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ja tema ette kogutakse kõik rahvad ja ta eraldab nad üksteisest, nagu karjane eraldab lambad sikkudest, ");
INSERT INTO ekk_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ja seab lambad oma paremale, sikud aga vasakule käele. ");
INSERT INTO ekk_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Siis ütleb Kuningas neile, kes on ta paremal käel: „Tulge teie, keda mu Isa on õnnistanud! Võtke vastu oma pärand, Kuningriik, mis teile on valmis pandud maailma loomisest peale! ");
INSERT INTO ekk_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Sest mul oli nälg ja te andsite mulle süüa; mul oli janu ja te andsite mulle juua; ma olin võõras ja te võtsite mu vastu; ");
INSERT INTO ekk_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ma olin alasti ja te riietasite mind; ma olin haige ja te tulite mind vaatama; ma olin vangis ja te tulite minu juurde.“ ");
INSERT INTO ekk_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Siis küsivad õiged temalt: „Issand, millal me nägime sind näljasena ja toitsime sind, või janusena ja jootsime sind? ");
INSERT INTO ekk_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Millal me nägime sind võõrana ja võtsime sind vastu, või alasti ja riietasime sind? ");
INSERT INTO ekk_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Millal me nägime sind haigena või vangis ja külastasime sind?“ ");
INSERT INTO ekk_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ja kuningas vastab neile: „Tõesti, ma ütlen teile, mida te iganes olete teinud kellele tahes mu kõige pisematest vendadest, seda te olete teinud mulle!“ ");
INSERT INTO ekk_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Siis ütleb ta neile, kes on ta vasakul käel: „Minge ära minu juurest, te neetud, igavesse tulle, mis on pandud valmis kuradile ja tema inglitele! ");
INSERT INTO ekk_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sest mul oli nälg ja te ei andnud mulle süüa; mul oli janu ja te ei andnud mulle juua; ");
INSERT INTO ekk_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ma olin võõras ja te ei võtnud mind vastu; ma olin alasti ja te ei riietanud mind; ma olin haige ja vangis ja te ei tulnud mind vaatama.“ ");
INSERT INTO ekk_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Siis küsivad temalt ka nemad: „Issand, millal me nägime sind näljasena või janusena või võõrana või alasti või haigena või vangis, ega aidanud sind?“ ");
INSERT INTO ekk_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Siis ta vastab neile: „Tõesti, ma ütlen teile, mida te iganes olete jätnud tegemata kellele tahes mu kõige pisematest vendadest, seda te olete jätnud tegemata minulegi.“ ");
INSERT INTO ekk_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ja need lähevad igavesse karistusse, õiged aga igavesse ellu.“ ");
INSERT INTO ekk_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kui Jeesus oli kõik need kõned lõpetanud, ütles ta oma jüngritele: ");
INSERT INTO ekk_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","„Te teate, et kahe päeva pärast on paasapüha ja Inimese Poeg antakse ära risti lüüa.“ ");
INSERT INTO ekk_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Siis kogunesid ülempreestrid ja rahvavanemad ülempreester Kaifase paleesse ");
INSERT INTO ekk_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ja pidasid nõu Jeesus kavalusega kinni võtta ja ära tappa. ");
INSERT INTO ekk_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ent nad arutasid: „Mitte pidustuste ajal, et rahvas ei hakkaks mässama.“ ");
INSERT INTO ekk_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Aga kui Jeesus istus Betaanias pidalitõbise Siimoni kodus, ");
INSERT INTO ekk_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","astus ta juurde naine, kellel oli alabasternõu ülihinnalise lõhnasalviga, ja valas selle temale pähe, kui ta oli laua ääres. ");
INSERT INTO ekk_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kui jüngrid nägid seda, said nad pahaseks ja ütlesid: „Milleks küll see raiskamine? ");
INSERT INTO ekk_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Selle salvi oleks võinud müüa kalli hinna eest ja raha jagada vaestele.“ ");
INSERT INTO ekk_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jeesus märkas seda ja ütles neile: „Miks te tülitate seda naist? Ta on teinud minu heaks kauni teo. ");
INSERT INTO ekk_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Vaeseid on teie juures alati, mind aga ei ole teil alati. ");
INSERT INTO ekk_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Sest seda salvi minu ihu peale kallates tegi tema seda minu matuseks. ");
INSERT INTO ekk_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tõesti, ma ütlen teile, kus iganes kogu maailmas seda evangeeliumi kuulutatakse, kõneldakse ka tema mälestuseks sellest, mis ta on teinud.“ ");
INSERT INTO ekk_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Siis läks Juudas Iskariot, üks neist kaheteistkümnest, ülempreestrite juurde ");
INSERT INTO ekk_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ja küsis: „Mis te mulle maksate, kui ma Jeesuse teie kätte annan?“ Nad lugesid talle kolmkümmend hõberaha, ");
INSERT INTO ekk_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ja sellest alates otsis Juudas sobivat võimalust Jeesuse äraandmiseks. ");
INSERT INTO ekk_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Aga hapnemata leibade püha esimesel päeval astusid jüngrid Jeesuse juurde ja küsisid: „Kus sa tahad, et me sulle paasasöögi ette valmistaksime?“ ");
INSERT INTO ekk_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","„Minge linna selle-ja-selle juurde,“ vastas Jeesus, „ja öelge talle, et õpetaja saadab sõna: „Minu aeg on lähedal, sinu juures ma pean paasasöögi oma jüngritega!“ “ ");
INSERT INTO ekk_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jüngrid tegid nõnda, nagu Jeesus oli neid juhendanud, ja valmistasid paasasöögi. ");
INSERT INTO ekk_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Õhtu saabudes istus Jeesus lauda koos oma kaheteistkümne jüngriga, ");
INSERT INTO ekk_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ja kui nad juba sõid, ütles ta: „Tõesti, ma ütlen teile, üks teie seast annab mu ära!“ ");
INSERT INTO ekk_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ja nad said väga kurvaks ning hakkasid talle üksteise järel ütlema: „Ega sa mind ei mõtle, Issand?“ ");
INSERT INTO ekk_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jeesus vastas neile: „See, kes on pannud käe minuga samasse kaussi, annab mu ära. ");
INSERT INTO ekk_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Inimese Poeg läheb küll ära, nõnda nagu tema kohta on kirjutatud, aga häda sellele inimesele, kes Inimese Poja ära annab! Talle oleks parem, kui ta ei oleks sündinud!“ ");
INSERT INTO ekk_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Siis küsis ka äraandja Juudas: „Ega sa mind ei mõtle, rabi?“ „Need on sinu sõnad,“ vastas Jeesus. ");
INSERT INTO ekk_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ja kui nad sõid, võttis Jeesus leiva, õnnistas, murdis, ulatas jüngritele ja ütles: „Võtke, sööge! See on minu ihu!“ ");
INSERT INTO ekk_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Siis ta võttis karika, tänas ja ulatas neile, öeldes: „Jooge kõik selle seest! ");
INSERT INTO ekk_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Sest see on minu lepinguveri, mis valatakse paljude eest pattude andeksandmiseks! ");
INSERT INTO ekk_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Aga ma ütlen teile: mina ei joo siitpeale sellest viinapuu viljast kuni päevani, mil ma joon koos teiega uut oma Isa Kuningriigis.“ ");
INSERT INTO ekk_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ja kui nad olid laulnud kiituslaulu, läksid nad välja Õlimäele. ");
INSERT INTO ekk_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Siis Jeesus ütles neile: „Te kõik hülgate minu täna öösel, sest kirjutatud on: „Ma löön karjast ja karja lambad pillutatakse laiali.“ ");
INSERT INTO ekk_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kuid pärast oma ülesäratamist lähen ma teie ees Galileasse.“ ");
INSERT INTO ekk_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peetrus vastas talle: „Kui ka kõik sind hülgavad, ei hülga mina sind iialgi!“ ");
INSERT INTO ekk_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","„Tõesti, ma ütlen sulle,“ vastas Jeesus, „täna öösel veel enne kukelaulu salgad sina mind kolm korda!“ ");
INSERT INTO ekk_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","„Isegi kui ma peaksin koos sinuga surema, mina ei salga sind iial!“ ütles Peetrus. Samamoodi ütlesid ka kõik teised jüngrid. ");
INSERT INTO ekk_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Siis Jeesus tuli koos jüngritega paika, mida hüütakse Ketsemaniks, ja ütles neile: „Istuge siin, kuni ma lähen sinna ja palvetan!“ ");
INSERT INTO ekk_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ta võttis enesega kaasa Peetruse ja kaks Sebedeuse poega ning teda haaras sügav kurbus ja ahastus. ");
INSERT INTO ekk_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Siis ta ütles neile: „Mu hing on väga kurb surmani, jääge siia ja valvake koos minuga!“ ");
INSERT INTO ekk_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ja ta läks pisut eemale, langes silmili maha ja palvetas: „Minu Isa, kui see on võimalik, siis mingu see karikas minust mööda! Ometi ärgu sündigu nõnda, nagu mina tahan, vaid nagu tahad sina!“ ");
INSERT INTO ekk_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Siis Jeesus tuli tagasi jüngrite juurde ja leidis nad magamast. „Kas te ei suutnud ainsatki tundi koos minuga valvata?“ küsis ta Peetruselt. ");
INSERT INTO ekk_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","„Valvake ja palvetage, et te ei satuks kiusatusse! Vaim on küll valmis, aga liha on nõder.“ ");
INSERT INTO ekk_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ta läks teist korda eemale ja palvetas: „Minu Isa, kui see karikas ei saa minust mööda minna nii, et ma sellest ei joo, siis sündigu sinu tahtmine!“ ");
INSERT INTO ekk_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kui ta tuli tagasi, leidis ta jüngrid taas magamast, sest nende silmalaud olid unest rasked. ");
INSERT INTO ekk_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ta jättis nad sinna, läks veel kord ära ja palvetas kolmandat korda, öeldes uuesti needsamad sõnad. ");
INSERT INTO ekk_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Siis Jeesus tuli tagasi jüngrite juurde ja ütles neile: „Teie aina magate ja puhkate! Vaata, tund on tulnud ja Inimese Poeg antakse patuste kätte! ");
INSERT INTO ekk_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tõuske üles, lähme! Mu äraandja on lähedal!“ ");
INSERT INTO ekk_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kui Jeesus alles rääkis, jõudis sinna Juudas, üks tema kaheteistkümnest jüngrist. Temaga oli kaasas suur hulk mehi mõõkade ja nuiadega, saadetud ülempreestrite ja rahvavanemate poolt. ");
INSERT INTO ekk_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aga tema äraandja oli andnud neile märgi: „Tema on see, keda ma suudlen; võtke ta kinni!“ ");
INSERT INTO ekk_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ja otsekohe astus Juudas Jeesuse juurde ja ütles: „Tervitus sulle, rabi!“ ning suudles teda. ");
INSERT INTO ekk_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jeesus ütles talle: „Tee seda, milleks sa tulid, sõber.“ Siis teised astusid samuti ligi, haarasid Jeesusest kinni ja vahistasid ta. ");
INSERT INTO ekk_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aga üks Jeesuse kaaslastest tõmbas tupest oma mõõga ja lõi ülempreestri sulast, raiudes ära ta kõrva. ");
INSERT INTO ekk_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","„Pista oma mõõk tuppe tagasi!“ käskis Jeesus. „Sest kõik, kes mõõga tõmbavad, mõõga läbi hukkuvad! ");
INSERT INTO ekk_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kas sa arvad, et ma ei või oma Isa appi hüüda, ja ta saadaks mulle kohe rohkem kui kaksteist leegioni ingleid? ");
INSERT INTO ekk_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Aga kuidas siis saaks täide minna Pühakirja ettekuulutus, et see nii peab sündima?“ ");
INSERT INTO ekk_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Selsamal tunnil ütles Jeesus rahvahulgale: „Kas ma juhin mässu, et te olete tulnud mõõkade ja nuiadega mind kinni võtma? Ma olen päevast päeva istunud templis ja õpetanud, ja te ei ole mind kinni võtnud. ");
INSERT INTO ekk_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Aga see kõik on sündinud, et prohvetite kirjad läheksid täide.“ Siis jätsid kõik jüngrid ta maha ja põgenesid. ");
INSERT INTO ekk_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Aga Jeesuse vangistajad viisid ta ülempreester Kaifase ette, kuhu olid kogunenud kirjatundjad ja rahvavanemad. ");
INSERT INTO ekk_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peetrus järgnes talle eemalt kuni ülempreestri õueni, läks sinna sisse ja istus valvurite juurde, et näha, kuidas asi lõpeb. ");
INSERT INTO ekk_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Aga ülempreestrid ja terve Suurkohus otsisid valetunnistust Jeesuse vastu, et teda surma mõista, ");
INSERT INTO ekk_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","kuid ei leidnud, ehkki paljud tulid valetunnistust andma. Lõpuks astusid ette kaks, ");
INSERT INTO ekk_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","kes väitsid: „Tema on öelnud: „Ma võin Jumala templi lammutada ja kolme päevaga üles ehitada.“ “ ");
INSERT INTO ekk_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Siis ülempreester tõusis püsti ja ütles Jeesusele: „Kas sa ei vasta midagi selle kohta, mida nad sinu vastu tunnistavad?“ ");
INSERT INTO ekk_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kuid Jeesus vaikis. Siis ülempreester ütles talle: „Ma vannutan sind elava Jumala juures, ütle meile, kas sina oled Messias, Jumala Poeg?“ ");
INSERT INTO ekk_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","„Need on sinu sõnad,“ vastas Jeesus. „Ometi ma ütlen teile: siitpeale te näete Inimese Poega istumas Kõigeväelise paremal käel ja tulemas taeva pilvede peal.“ ");
INSERT INTO ekk_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Siis ülempreester käristas oma riided lõhki ja ütles: „Ta on teotanud pühadust! Mis tunnistajaid meil veel on vaja! Nüüd te olete ise kuulnud pühaduseteotust! ");
INSERT INTO ekk_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mis teie arvate?“ „Tema on surma väärt!“ vastasid nad. ");
INSERT INTO ekk_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Siis nad sülitasid talle näkku ja peksid teda rusikatega, aga mõned lõid lahtise käega, ");
INSERT INTO ekk_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","öeldes: „Prohveteeri meile, Messias, kes sind praegu lõi?“ ");
INSERT INTO ekk_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Peetrus istus aga siseõues. Seal astus tema juurde üks teenijatüdruk ja ütles: „Ka sina olid Galilea Jeesusega!“ ");
INSERT INTO ekk_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kuid Peetrus salgas kõikide ees: „Ma ei tea, millest sa räägid!“ ");
INSERT INTO ekk_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kui ta läks aga värava poole, nägi teda teine teenijatüdruk ja ütles seal teistele: „See mees oli koos Naatsareti Jeesusega.“ ");
INSERT INTO ekk_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Taas salgas Peetrus vandega: „Ma ei tunne seda inimest!“ ");
INSERT INTO ekk_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pisut hiljem astusid mõned sealviibijad tema juurde ja ütlesid: „Tõesti, ka sina oled üks nende hulgast, sest su kõneviis paljastab sind.“ ");
INSERT INTO ekk_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Seepeale hakkas Peetrus sajatama ja vanduma: „Ma ei tunne seda meest!“ Ja kohe kires kukk ");
INSERT INTO ekk_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ning Peetrusele meenusid Jeesuse sõnad: „Veel enne kui kukk kireb, salgad sina mind kolm korda.“ Ta läks välja ja nuttis kibedasti. ");
INSERT INTO ekk_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Koidikul võtsid kõik ülempreestrid ja rahvavanemad vastu otsuse, et Jeesus tuleb surmata. ");
INSERT INTO ekk_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nad sidusid ta kinni, viisid ära ja andsid maavalitseja Pilaatuse kätte. ");
INSERT INTO ekk_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kui nüüd tema äraandja Juudas nägi, et Jeesus oli mõistetud süüdi, kahetses ta ja viis need kolmkümmend hõbeseeklit ülempreestritele ja vanematele tagasi. ");
INSERT INTO ekk_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","„Ma olen teinud pattu,“ ütles ta, „sest ma andsin ära süütu vere.“ „Mis meil sellest?“ vastasid nemad. „See on su oma asi.“ ");
INSERT INTO ekk_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Juudas viskas raha templisse maha ja läks ära. Siis ta läks ja poos end üles. ");
INSERT INTO ekk_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ülempreestrid aga võtsid raha üles ja ütlesid: „Seaduse järgi ei tohi seda templikassasse panna, sest see on vere hind.“ ");
INSERT INTO ekk_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nii nad otsustasid kasutada seda raha pottsepa põllu ostmiseks võõraste matmispaigaks. ");
INSERT INTO ekk_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Seepärast hüütakse seda põldu Verepõlluks tänaseni. ");
INSERT INTO ekk_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nii läks täide, mis prohvet Jeremija suu läbi on öeldud: „Nad võtsid kolmkümmend hõberaha, hinna, mille vääriliseks Iisraeli lapsed ta olid hinnanud, ");
INSERT INTO ekk_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ja maksid selle pottsepa põllu eest, nii nagu Issand mind oli käskinud.“ ");
INSERT INTO ekk_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jeesus aga seisis maavalitseja ees. „Kas sina oled juutide kuningas?“ küsis maavalitseja temalt. „Need on sinu sõnad,“ vastas Jeesus. ");
INSERT INTO ekk_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ent kui ülempreestrid ja rahvavanemad teda süüdistasid, ei vastanud ta midagi. ");
INSERT INTO ekk_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Siis küsis Pilaatus temalt: „Kas sa ei kuule, mida kõike nad sinu vastu tunnistavad?“ ");
INSERT INTO ekk_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ent Pilaatuse suureks imestuseks ei vastanud Jeesus enam sõnagi. ");
INSERT INTO ekk_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Maavalitsejal oli kombeks paasapühade ajal vabastada üks vang, keda rahvas soovis. ");
INSERT INTO ekk_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tookord oli vangis kurikuulus mees nimega Jeesus Barabas. ");
INSERT INTO ekk_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kui siis rahvas oli kogunenud, küsis Pilaatus neilt: „Kumma te tahate, et ma lasen teile vabaks: Jeesus Barabase või Jeesuse, keda hüütakse Messiaks?“ ");
INSERT INTO ekk_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Sest ta teadis, et nad olid Jeesuse kadeduse pärast tema kätte andnud. ");
INSERT INTO ekk_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Aga kui Pilaatus istus kohtujärjel, saatis ta naine temale sõna: „Ärgu olgu sul midagi tegemist selle süütu mehega, sest ma olen täna öösel und nähes tema pärast rängalt kannatanud!“ ");
INSERT INTO ekk_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kuid ülempreestrid ja rahvavanemad keelitasid rahvast, et nad nõuaksid Barabast, Jeesuse aga laseksid hukata. ");
INSERT INTO ekk_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Siis maavalitseja küsis neilt veel kord: „Kumma neist kahest te tahate, et ma vabaks laseksin?“ „Barabase!“ vastasid nad. ");
INSERT INTO ekk_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","„Mida ma siis teen Jeesusega, keda hüütakse Messiaks?“ küsis Pilaatus. „Löö ta risti!“ hüüdsid kõik. ");
INSERT INTO ekk_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","„Mispärast? Mis kurja ta on teinud?“ küsis Pilaatus. Nemad aga karjusid veel enam: „Löö ta risti!“ ");
INSERT INTO ekk_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kui Pilaatus nägi, et ta midagi ei saavuta, vaid rahva rahutus üha kasvas, võttis ta vett, pesi rahva ees oma käed ja ütles: „Mina olen süütu selle mehe verest! See on teie vastutus!“ ");
INSERT INTO ekk_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ja kogu rahvas kostis talle: „Tema veri tulgu meie ja meie laste peale!“ ");
INSERT INTO ekk_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Siis Pilaatus vabastas neile Barabase, Jeesust aga laskis piitsutada ja andis ta sõdurite kätte risti lüüa. ");
INSERT INTO ekk_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Siis viisid maavalitseja sõdurid Jeesuse pretooriumisse ja kogusid tema ümber terve väesalga. ");
INSERT INTO ekk_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nad kiskusid ära ta riided ja panid talle selga punase mantli. ");
INSERT INTO ekk_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ja nad punusid kibuvitstest pärja, surusid talle pähe ning andsid kätte pillirookepi. Siis põlvitasid nad tema ette maha ja mõnitasid teda: „Tervitus, juutide kuningas!“ ");
INSERT INTO ekk_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nad sülitasid ta peale, võtsid pillirookepi ja peksid teda pähe. ");
INSERT INTO ekk_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ja kui nad olid teda küllalt mõnitanud, võtsid nad tal mantli seljast, panid ta oma riided selga tagasi ja viisid ta ära ristilöömiseks. ");
INSERT INTO ekk_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Välja minnes kohtasid nad Küreene meest nimega Siimon. Nad sundisid teda kandma Jeesuse risti. ");
INSERT INTO ekk_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ja kui nad jõudsid paika nimega Kolgata (mis tähendab Pealuu koht), ");
INSERT INTO ekk_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","pakkusid nad Jeesusele sapiga segatud veini. Kui ta oli seda maitsnud, keeldus ta joomast. ");
INSERT INTO ekk_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Aga kui nad tema olid risti löönud, jagasid nad liisku heites ta riided omavahel ");
INSERT INTO ekk_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ja istusid sinna teda valvama. ");
INSERT INTO ekk_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ta pea kohale kinnitati silt tema süüga: See on Jeesus, juutide kuningas. ");
INSERT INTO ekk_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Siis nad lõid koos Jeesusega risti kaks kurjategijat, üks temast paremale ja teine vasakule käele. ");
INSERT INTO ekk_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Möödakäijad aga pilkasid teda päid vangutades: ");
INSERT INTO ekk_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","„Noh, templi lammutaja ja kolme päevaga üles ehitaja! Päästa nüüd iseennast! Kui sa oled Jumala Poeg, siis astu ristilt alla!“ ");
INSERT INTO ekk_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Samamoodi pilkasid teda ka ülempreestrid koos kirjatundjate ja vanematega: ");
INSERT INTO ekk_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","„Teisi on ta päästnud, aga iseennast ei suuda ta päästa. Ta on ju Iisraeli kuningas! Astugu nüüd ristilt alla ja me usume temasse! ");
INSERT INTO ekk_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ta on lootnud Jumala peale. Las Jumal ta nüüd päästab, kui ta teda tahab, ta ju ütleb, et ta on Jumala Poeg.“ ");
INSERT INTO ekk_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Samamoodi pilkasid teda ka koos temaga risti löödud kurjategijad. ");
INSERT INTO ekk_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kuuendal tunnil langes pimedus üle kogu maa ja kestis üheksanda tunnini. ");
INSERT INTO ekk_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Üheksandal tunnil kisendas Jeesus valju häälega: „Elii, elii, lemaa sabahtani?“ – see tähendab „Mu Jumal, mu Jumal, miks sa mu maha jätsid?“ ");
INSERT INTO ekk_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Aga mõned sealseisjatest ütlesid seda kuuldes: „Ta hüüab Eelijat!“ ");
INSERT INTO ekk_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ja kohe jooksis üks nendest ja tõi hapu veiniga immutatud käsna, pistis selle kepi otsa ja andis Jeesusele juua. ");
INSERT INTO ekk_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Teised aga ütlesid: „Aitab küll! Saame näha, kas Eelija tuleb teda päästma!“ ");
INSERT INTO ekk_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Aga Jeesus kisendas jälle suure häälega ja heitis hinge. ");
INSERT INTO ekk_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Siis rebenes templi eesriie ülalt alla kaheks, maapind rappus, kaljud lõhenesid ");
INSERT INTO ekk_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ja hauad läksid lahti. Ja ärkas üles palju magama uinunud pühade ihusid ");
INSERT INTO ekk_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ja need tulid hauakambritest välja ja läksid pärast tema surnuist ülesäratamist pühasse linna, kus paljud neid nägid. ");
INSERT INTO ekk_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kui sadakonna ülem ja need, kes Jeesust koos temaga valvasid, nägid maavärinat ja kõike, mis sündis, lõid nad väga kartma. „Tõepoolest, see mees oli Jumala Poeg!“ ütlesid nad. ");
INSERT INTO ekk_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Aga seal oli toimuvat eemalt vaatamas palju naisi. Nad olid järgnenud Jeesusele Galileast alates ja hoolitsenud tema eest. ");
INSERT INTO ekk_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nende seas olid Maarja Magdaleena ja Jaakobuse ja Joosepi ema Maarja ning Sebedeuse poegade ema. ");
INSERT INTO ekk_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Õhtu hakul tuli Arimaatiast rikas mees nimega Joosep, kes oli samuti Jeesuse jünger. ");
INSERT INTO ekk_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tema läks Pilaatuse juurde ja palus ta käest Jeesuse surnukeha, ning Pilaatus käskis selle temale anda. ");
INSERT INTO ekk_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Joosep võttis surnukeha, mähkis selle puhtasse linariidesse ");
INSERT INTO ekk_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ja pani oma uude kaljusse raiutud hauakambrisse. Siis veeretas ta haua sissekäigu ette suure kivi ja läks minema. ");
INSERT INTO ekk_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Aga Maarja Magdaleena ja teine Maarja istusid seal haua vastas. ");
INSERT INTO ekk_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Järgmisel päeval, pärast pühade ettevalmistuspäeva, tulid ülempreestrid ja variserid üheskoos Pilaatuse juurde. ");
INSERT INTO ekk_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","„Isand,“ ütlesid nad, „meil on meeles, et see eksitaja ütles, kui ta alles elas: „Mind äratatakse kolme päeva pärast üles!“ ");
INSERT INTO ekk_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Seepärast käsi hoida tema hauda kuni kolmanda päevani kindlalt suletuna, et jüngrid ei tuleks ja teda ära ei varastaks ega ütleks rahvale, et ta on üles äratatud. Siis oleks see viimane pettus hullem kui esimene.“ ");
INSERT INTO ekk_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","„Võtke valvesalk,“ ütles Pilaatus neile, „minge ning pidage valvet, nii kindlalt kui oskate!“ ");
INSERT INTO ekk_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nemad läksid ja võtsid haua valve alla, pannes kivi pitseriga kinni ja seades sinna valvurid. ");
INSERT INTO ekk_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pärast hingamispäeva, nädala esimese päeva koidikul, tulid Maarja Magdaleena ja teine Maarja hauda vaatama. ");
INSERT INTO ekk_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Äkki sündis võimas maavärin, sest üks Issanda ingel laskus taevast alla, tuli haua juurde ja veeretas kivi eest ja istus selle peale. ");
INSERT INTO ekk_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Aga ta nägu oli nagu välk ja ta rõivad valged nagu lumi. ");
INSERT INTO ekk_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ning hirmust tema ees valvurid vabisesid ja langesid maha nagu surnud. ");
INSERT INTO ekk_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aga ingel pöördus naiste poole ja ütles: „Teie ärge kartke! Ma tean, et te otsite ristilöödud Jeesust. ");
INSERT INTO ekk_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Teda ei ole siin; ta on üles äratatud, nõnda nagu ta ütles. Tulge, vaadake kohta, kus ta lamas, ");
INSERT INTO ekk_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ja minge ruttu, öelge tema jüngritele, et ta on üles äratatud surnuist ja läheb teie ees Galileasse. Seal te saate teda näha. Pidage meeles, ma olen seda teile öelnud!“ ");
INSERT INTO ekk_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Naised lahkusid haua juurest ehmunult ja suure rõõmuga ja jooksid rutuga viima jüngritele teadet. ");
INSERT INTO ekk_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Korraga tuli Jeesus ise neile vastu ja ütles: „Olge tervitatud!“ Nad astusid tema juurde, haarasid ta jalge ümbert kinni ja kummardasid teda. ");
INSERT INTO ekk_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jeesus ütles neile: „Ärge kartke! Minge, teatage mu vendadele, et nad läheksid Galileasse! Seal nad saavad mind näha.“ ");
INSERT INTO ekk_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kui naised olid juba teel, tulid mõned valvesalgast linna ja teatasid ülempreestritele kõik, mis oli sündinud. ");
INSERT INTO ekk_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ja ülempreestrid tulid koos vanematega kokku ja võtsid nõuks anda sõduritele palju raha ");
INSERT INTO ekk_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ja ütlesid neile: „Te peate ütlema, et Jeesuse jüngrid tulid öösel ja varastasid tema ära, sellal kui teie magasite. ");
INSERT INTO ekk_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ja kui see lugu peaks maavalitseja kõrvu jõudma, siis me rahustame teda, nii et teil pole tarvis muretseda.“ ");
INSERT INTO ekk_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sõdurid võtsid raha vastu ja tegid, nagu neid oli õpetatud. Ning see jutt on levinud juutide seas tänase päevani. ");
INSERT INTO ekk_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Üksteist jüngrit läksid aga Galileasse sinna mäele, kuhu Jeesus neid oli käskinud minna. ");
INSERT INTO ekk_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ja kui nad teda nägid, kummardasid nad teda, aga mõned kahtlesid. ");
INSERT INTO ekk_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Siis Jeesus astus nende juurde ja rääkis nendega: „Minu kätte on antud kõik meelevald taevas ja maa peal. ");
INSERT INTO ekk_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Minge siis ja tehke jüngriteks kõik rahvad, ristides neid Isa ja Poja ja Püha Vaimu nimel ");
INSERT INTO ekk_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ja õpetades neid järgima kõike, mida mina teid olen käskinud! Pidage meeles, et mina olen iga päev koos teiega kuni selle ajastu lõpuni!“");
INSERT INTO ekk_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jeesuse Messia, Jumala Poja evangeeliumi algus, ");
INSERT INTO ekk_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","nagu sellest on kirjutatud prohvet Jesaja raamatus: „Vaata, ma saadan sinu ees oma saadiku, kes valmistab sulle teed. ");
INSERT INTO ekk_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Hüüdja hääl on kõrbes: „Valmistage Issandale tee, tehke tasaseks tema teerajad!“ “ ");
INSERT INTO ekk_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ja nõnda Ristija Johannes oli kõrbes ja kuulutas meeleparandusristimist pattude andeksandmiseks. ");
INSERT INTO ekk_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tema juurde läks kogu Juudamaa ja kõik Jeruusalemma inimesed. Nad tunnistasid üles oma patud ja ta ristis nad Jordani jões. ");
INSERT INTO ekk_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Johannesel olid kaamelikarvadest rõivad ja nahkvöö vööl ning ta sõi rohutirtse ja metsmett. ");
INSERT INTO ekk_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ta kuulutas: „Pärast mind tuleb minust vägevam, kelle sandaalegi ma ei ole väärt maha kummardudes lahti siduma. ");
INSERT INTO ekk_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mina ristin teid veega, tema ristib teid Püha Vaimuga.“ ");
INSERT INTO ekk_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Neil päevil tuli Jeesus Naatsaretist Galileamaalt ja Johannes ristis ta Jordanis. ");
INSERT INTO ekk_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kui Jeesus veest välja tuli, nägi ta taevast avanemas ja Vaimu kui tuvi laskumas tema peale. ");
INSERT INTO ekk_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ja taevast kostis hääl: „Sina oled mu armas Poeg, sinu üle on mul hea meel!“ ");
INSERT INTO ekk_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ning kohe viis Vaim ta kõrbe. ");
INSERT INTO ekk_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kõrbes oli ta nelikümmend päeva saatana kiusata. Ta oli metsloomade seas ning inglid teenisid teda. ");
INSERT INTO ekk_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pärast Johannese vangistamist tuli Jeesus Galileasse ja kuulutas Jumala evangeeliumi: ");
INSERT INTO ekk_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","„Aeg on käes ja Jumala riik on lähedal, parandage meelt ja uskuge evangeeliumisse!“ ");
INSERT INTO ekk_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kui Jeesus kõndis Galilea mere kaldal, nägi ta Siimonit ja tema venda Andreast võrku merre heitmas, sest nad olid kalurid. ");
INSERT INTO ekk_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ja Jeesus ütles neile: „Järgnege mulle ja teist saavad inimestepüüdjad!“ ");
INSERT INTO ekk_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nad jätsid kohe oma võrgud ja järgnesid talle. ");
INSERT INTO ekk_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kui ta oli pisut edasi läinud, nägi Jeesus Sebedeuse poega Jaakobust ja tema venda Johannest paadis võrke parandamas ");
INSERT INTO ekk_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ja otsekohe kutsus ka neid. Nemad jätsid oma isa Sebedeuse koos palgalistega paati ning järgnesid talle. ");
INSERT INTO ekk_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ja nad läksid Kapernauma. Järgmisel hingamispäeval läks Jeesus sünagoogi ja hakkas õpetama. ");
INSERT INTO ekk_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Rahvas aga jahmus tema õpetusest, sest ta õpetas mitte nagu kirjatundjad, vaid nagu see, kellel on meelevald. ");
INSERT INTO ekk_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Parajasti oli sünagoogis keegi mees, kes oli rüveda vaimu poolt vallatud. See kisendas: ");
INSERT INTO ekk_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","„Mis on meil asja sinuga, Naatsareti Jeesus? Kas sa oled tulnud meid hävitama? Ma tean küll, kes sa oled – Jumala Püha!“ ");
INSERT INTO ekk_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jeesus sõitles teda: „Jää vait ja mine temast välja!“ ");
INSERT INTO ekk_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ja rüve vaim väljus mehest teda raputades ja valjusti kisendades. ");
INSERT INTO ekk_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Sellest olid kõik nii vapustatud, et nad arutasid omavahel: „Mis see siis on? Kas uus õpetus, ja sellise meelevallaga? Tema käsutab rüvedaid vaime, ja need kuulavad tema sõna!“ ");
INSERT INTO ekk_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ning kuuldus temast levis kiiresti kõikjale Galilea ümbruskonda. ");
INSERT INTO ekk_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pärast sünagoogist lahkumist tulid nad koos Jaakobuse ja Johannesega Siimoni ja Andrease majja. ");
INSERT INTO ekk_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Aga Siimoni ämm lamas palavikuga voodis, ja otsekohe räägiti temast Jeesusele. ");
INSERT INTO ekk_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jeesus läks tema juurde, võttis tal käest kinni ja aitas üles. Palavik lahkus Siimoni ämmast ning ta tõusis ja kattis neile laua. ");
INSERT INTO ekk_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Sel õhtul pärast päikeseloojangut toodi Jeesuse juurde kõik haiged ja kurjast vaimust vaevatud. ");
INSERT INTO ekk_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Terve linn kogunes maja ukse ette ");
INSERT INTO ekk_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ja Jeesus tervendas paljusid, kellel olid mitmesugused haigused. Samuti ajas ta välja palju kurje vaime ega lubanud kurjadel vaimudel rääkida, sest need teadsid, kes ta on. ");
INSERT INTO ekk_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Hommikul vara enne valget tõusis Jeesus üles, lahkus majast ja läks üksildasse paika, kus ta palvetas. ");
INSERT INTO ekk_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Siimon ja ta kaaslased ruttasid talle järele, ");
INSERT INTO ekk_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ja kui nad ta üles leidsid, hüüdsid nad: „Kõik otsivad sind!“ ");
INSERT INTO ekk_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jeesus aga vastas neile: „Lähme kuhugi mujale, ümberkaudsetesse küladesse, et ma saaksin ka seal kuulutada! Selleks olen ma tulnud!“ ");
INSERT INTO ekk_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ja Jeesus käis läbi kogu Galilea, kuulutades nende sünagoogides ja ajades välja kurje vaime. ");
INSERT INTO ekk_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jeesuse juurde tuli pidalitõbine, laskus põlvili ja palus teda: „Kui sa tahad, siis sa võid mu puhtaks teha!“ ");
INSERT INTO ekk_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jeesusel hakkas temast kahju, ta sirutas oma käe, puudutas teda ja ütles: „Ma tahan, saa puhtaks!“ ");
INSERT INTO ekk_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Sedamaid lahkus pidalitõbi temast ja ta sai puhtaks. ");
INSERT INTO ekk_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jeesus saatis ta kohe minema, teda rangelt hoiatades: ");
INSERT INTO ekk_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","„Vaata, et sa kellelegi sellest ei räägi, vaid mine näita ennast preestrile ja ohverda puhtakssaamise eest, mis Mooses on käskinud, neile tunnistuseks!“ ");
INSERT INTO ekk_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kuid mees läks ja hakkas igal pool jutustama ja seda lugu levitama, nii et Jeesus ei saanud enam avalikult minna ühtegi linna, vaid pidi viibima väljas kõrvalistes kohtades, kuid inimesed tulid siiski kõikjalt tema juurde. ");
INSERT INTO ekk_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mõni päev hiljem tuli Jeesus taas Kapernauma. Kui saadi kuulda, et ta on kodus, ");
INSERT INTO ekk_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","kogunes palju rahvast, nii et isegi väljas ukse ees ei olnud enam ruumi. Ja Jeesus kõneles neile Jumala sõna. ");
INSERT INTO ekk_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Siis tulid tema juurde neli meest, kes kandsid halvatut. ");
INSERT INTO ekk_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ja kui nad rahvarohkuse tõttu ei pääsenud halvatuga talle ligi, tegid nad Jeesuse pea kohal katusesse avause ja lasksid alla magamisaseme, millel halvatu lamas. ");
INSERT INTO ekk_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nende usku nähes ütles Jeesus halvatule: „Poeg, sinu patud on sulle andeks antud!“ ");
INSERT INTO ekk_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Aga seal istusid mõned kirjatundjad ja need mõtlesid iseeneses: ");
INSERT INTO ekk_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","„Kuidas see mees võib öelda nõnda? Ta teotab Jumalat! Kes veel võib patte andeks anda kui vaid Jumal üksi?“ ");
INSERT INTO ekk_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kuid Jeesus teadis kohe oma vaimus, et nad niimoodi oma südames mõtlevad, ja ta ütles neile: „Miks te nõnda mõtlete? ");
INSERT INTO ekk_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kumb on kergem, kas öelda halvatule „Sinu patud on andeks antud“ või öelda talle „Tõuse üles, võta oma ase ja kõnni“? ");
INSERT INTO ekk_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aga teadke, et Inimese Pojal on meelevald patte andeks anda maa peal!“ Ja ta ütles halvatule: ");
INSERT INTO ekk_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","„Tõuse üles, võta oma ase ja mine koju!“ ");
INSERT INTO ekk_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Sedamaid tõusis mees üles, võttis oma magamisaseme ja väljus kõigi nähes, nii et kõik hämmastusid ja ülistasid Jumalat, öeldes: „Midagi sellist pole me kunagi näinud!“ ");
INSERT INTO ekk_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jeesus läks taas välja järve äärde ja ta juurde kogunes rahvahulk ja ta õpetas neid. ");
INSERT INTO ekk_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Edasi minnes nägi ta Leevit, Alfeuse poega, maksukoguja pingil istumas ja ütles talle: „Järgne mulle!“ Ja Leevi tõusis ja järgnes talle. ");
INSERT INTO ekk_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kui siis Jeesus istus lauas tema kodus, oli ka hulk maksukogujaid ja patuseid söömas koos tema ja ta jüngritega, sest paljud järgnesid talle. ");
INSERT INTO ekk_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ja kui variseride kirjatundjad nägid, et Jeesus sööb koos patuste ja maksukogujatega, ütlesid nad tema jüngritele: „Miks ta sööb koos maksukogujate ja patustega?“ ");
INSERT INTO ekk_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Seda kuuldes ütles Jeesus neile: „Arsti ei vaja terved, vaid haiged. Ma pole tulnud kutsuma õigeid, vaid patuseid.“ ");
INSERT INTO ekk_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Johannese jüngrid ja variserid pidasid aga parajasti paastu. Siis tulid mõned inimesed Jeesuse juurde ja küsisid: „Miks Johannese jüngrid ja variseride jüngrid paastuvad, aga sinu jüngrid ei paastu?“ ");
INSERT INTO ekk_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jeesus vastas neile: „Ei sobi pulmalistel leinata ajal, kui peigmees on nende juures! Niikaua kui peigmees on nende juures, nad ei või paastuda. ");
INSERT INTO ekk_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kuid tuleb aeg, mil peigmees neilt ära võetakse, küll nad siis sel päeval paastuvad. ");
INSERT INTO ekk_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Keegi ei õmble vanutamata riidetükki paigaks vanale rõivale, muidu rebeneb vana rõivas uue paiga servast ja auk läheb suuremaks. ");
INSERT INTO ekk_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ka ei vala keegi värsket veini vanadesse nahklähkritesse, muidu vein pressib lähkrid lõhki ning siis ollakse ilma nii veinist kui lähkritest. Värske vein valatakse uutesse nahklähkritesse.“ ");
INSERT INTO ekk_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ühel hingamispäeval juhtus Jeesus minema läbi viljapõldude ja ta jüngrid hakkasid teed käies viljapäid katkuma. ");
INSERT INTO ekk_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ja variserid ütlesid Jeesusele: „Vaata neid! Miks nad teevad seda, mida hingamispäeval teha ei tohi?“ ");
INSERT INTO ekk_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jeesus vastas neile: „Kas te pole kunagi lugenud, mida tegi Taavet, kui tal oli puudus ning tema ja ta kaaslased olid näljas? ");
INSERT INTO ekk_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ta läks Jumala kotta ülempreester Ebjatari päevil ning sõi ära ohvrileivad, mida oli lubatud süüa ainult preestritel. Ja ta andis ka oma kaaslastele.“ ");
INSERT INTO ekk_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ja Jeesus ütles neile: „Hingamispäev on seatud inimese jaoks, mitte inimene hingamispäeva jaoks. ");
INSERT INTO ekk_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Seepärast on Inimese Poeg ka hingamispäeva Issand!“ ");
INSERT INTO ekk_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ühel teisel korral, kui Jeesus läks sünagoogi, oli seal kärbunud käega mees. ");
INSERT INTO ekk_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aga mõned seal jälgisid tähelepanelikult, kas ta tervendab hingamispäeval, et oleks põhjust tema süüdistamiseks. ");
INSERT INTO ekk_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Siis Jeesus ütles kärbunud käega mehele: „Seisa meie ette!“ ");
INSERT INTO ekk_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ja ta küsis neilt: „Kumb on hingamispäeval lubatud: kas teha head või kurja, päästa elu või tappa?“ Kuid nad ei vastanud talle. ");
INSERT INTO ekk_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ta vaatas vihaselt nende peale, olles ühtlasi ahastuses nende kalkide südamete pärast, ja ütles mehele: „Siruta välja oma käsi!“ Mees sirutas, ja see sai kohe terveks. ");
INSERT INTO ekk_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Sedamaid läksid variserid välja ja hakkasid koos heroodeslastega plaanima, kuidas Jeesus tappa. ");
INSERT INTO ekk_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jeesus läks oma jüngritega eemale järve äärde ja neile järgnes suur rahvahulk Galileast. ");
INSERT INTO ekk_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Kui nad kuulsid kõigest, mis ta tegi, tuli palju inimesi tema juurde Juudamaalt, Jeruusalemmast, Idumeast, sealtpoolt Jordanit ning Tüürose ja Siidoni ümbrusest. ");
INSERT INTO ekk_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ta ütles oma jüngritele, et nad paneksid väikese paadi tema jaoks valmis inimeste pärast, et need talle peale ei pressiks. ");
INSERT INTO ekk_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kuna ta tegi terveks paljusid, surusid tema peale kõik haiged, et teda puudutada. ");
INSERT INTO ekk_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ja kui rüvedad vaimud nägid Jeesust, langesid nad ta ette maha ja kisendasid: „Sina oled Jumala Poeg!“ ");
INSERT INTO ekk_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Aga Jeesus keelas neid karmilt rääkimast, kes ta on. ");
INSERT INTO ekk_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Siis Jeesus läks üles mäele ja kutsus enese juurde, keda ta soovis, ja nemad tulid ta juurde. ");
INSERT INTO ekk_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ta nimetas kaksteist, keda ta nimetas apostliteks, et need oleksid koos temaga ja ta võiks nad läkitada kuulutama ");
INSERT INTO ekk_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ning et neil oleks meelevald kurje vaime välja ajada. ");
INSERT INTO ekk_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Need on kaksteist, kelle ta nimetas: Siimon (ja pani talle nimeks Peetrus), ");
INSERT INTO ekk_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jaakobus, Sebedeuse poeg, ja Jaakobuse vend Johannes (ja andis neile nimeks Boanerges, see on Kõuepojad), ");
INSERT INTO ekk_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ja Andreas, Filippus, Bartolomeus, Matteus, Toomas, Jaakobus, Alfeuse poeg, Taddeus, Siimon Kaanalane, ");
INSERT INTO ekk_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ja Juudas Iskariot, kes tema ära andis. ");
INSERT INTO ekk_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Siis Jeesus tuli koju ja taas kogunes rahvahulk, nii et tema ja jüngrid ei saanud mahti süüagi. ");
INSERT INTO ekk_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kui ta omaksed sellest kuulsid, tulid nad teda enda hoole alla võtma, sest nad ütlesid: „Ta on arust ära!“ ");
INSERT INTO ekk_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ent kirjatundjad, kes olid tulnud Jeruusalemmast, ütlesid: „Temas on Peltsebul! Ta ajab kurje vaime välja kurjade vaimude valitseja abil!“ ");
INSERT INTO ekk_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Siis Jeesus kutsus nad enese juurde ja rääkis neile tähendamissõnadega: „Kuidas saab saatan ajada välja saatanat? ");
INSERT INTO ekk_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kui kuningriik on omavahelises riius lõhenenud, siis see kuningriik ei püsi. ");
INSERT INTO ekk_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kui perekond on omavahelises riius lõhenenud, siis see perekond ei püsi. ");
INSERT INTO ekk_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kui saatan tõuseb iseenese vastu ja on lõhenenud, ei saa ta püsida, vaid tema lõpp on käes. ");
INSERT INTO ekk_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Keegi ei saa tungida vägimehe majja ta asju röövima, kui ta esmalt ei seo vägimeest kinni, ja alles siis saab ta tema maja röövida. ");
INSERT INTO ekk_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Tõesti, ma ütlen teile, inimestele antakse andeks kõik patud ja pühaduseteotused, kuidas nad iganes ka oleksid teotanud, ");
INSERT INTO ekk_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","aga kes peaks teotama Püha Vaimu, ei saa andeks iialgi, vaid ta on süüdi igaveses patus!“ ");
INSERT INTO ekk_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jeesus ütles seda, sest nad ütlesid, et Jeesusel on rüve vaim. ");
INSERT INTO ekk_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Siis tulid Jeesuse ema ja ta vennad, ja väljas seistes saatsid kellegi Jeesust kutsuma. ");
INSERT INTO ekk_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ja rahvahulk istus Jeesuse ümber, kui talle öeldi: „Su ema, vennad ja õed on väljas ja otsivad sind.“ ");
INSERT INTO ekk_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jeesus aga vastas neile: „Kes on mu ema ja vennad?“ ");
INSERT INTO ekk_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ta silmitses enda ümber istujaid ning ütles: „Siin on mu ema ja mu vennad! ");
INSERT INTO ekk_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sest kes iganes teeb Jumala tahtmist, see on mu vend ja õde ja ema.“ ");
INSERT INTO ekk_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jeesus hakkas taas õpetama järve ääres. Tema juurde kogunes nii palju rahvast, et ta pidi astuma paati ja istuma selles järvel, samal ajal kui inimesed seisid piki kallast vee serval. ");
INSERT INTO ekk_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ta õpetas neile palju asju tähendamissõnadega ja rääkis neile oma õpetuses: ");
INSERT INTO ekk_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","„Kuulake! Põllumees läks välja külvama. ");
INSERT INTO ekk_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kui ta külvas, kukkus osa seemet teeveerele ning linnud tulid ja nokkisid selle. ");
INSERT INTO ekk_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Osa kukkus kivisele maale, kus ei olnud palju mulda, ja see idanes kohe, sest muld ei olnud sügav. ");
INSERT INTO ekk_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Aga kui päike tõusis, kuivasid taimed ära, sest neil ei olnud juurt. ");
INSERT INTO ekk_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Osa seemet kukkus ohakate sekka, ning ohakad sirgusid ja lämmatasid taimed, nii et need ei kandnud vilja. ");
INSERT INTO ekk_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Aga osa seemet kukkus heasse mulda. See idanes ja kasvas ja kandis vilja: mõni kolmkümmend, mõni kuuskümmend, mõni sada korda rohkem.“ ");
INSERT INTO ekk_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ja ta ütles: „Kellel kõrvad on kuulda, see kuulgu!“ ");
INSERT INTO ekk_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kui Jeesus üksi oli, küsisid kaksteist jüngrit, ja teised tema ümber, temalt seletust tähendamissõnade kohta. ");
INSERT INTO ekk_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ta ütles neile: „Teie kätte on antud Jumala riigi saladus, aga neile, kes on väljas, räägitakse kõike tähendamissõnadega, ");
INSERT INTO ekk_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","„et nad vaataksid ega näeks ja kuuleksid ega mõistaks, sest muidu nad pöörduksid, ja neile antaks andeks.“ “ ");
INSERT INTO ekk_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Siis ütles Jeesus neile: „Kas te ei mõista selle tähendamissõna tähendust? Kuidas te siis võiksite mõista ühtki tähendamissõna? ");
INSERT INTO ekk_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Külvaja külvab sõna. ");
INSERT INTO ekk_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mõned inimesed on nagu teeveered, kuhu sõna langeb. Niipea kui nad seda kuulevad, tuleb saatan ja võtab ära neisse külvatud sõna. ");
INSERT INTO ekk_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kivisele maale külvatu sarnased on need, kes sõna kuuldes võtavad selle kohe rõõmuga vastu, ");
INSERT INTO ekk_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ent neil pole juurt ja nad püsivad lühikest aega. Kui siis sõna pärast tuleb tüli või tagakius, langevad nad kiiresti. ");
INSERT INTO ekk_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ohakate sekka külvatu sarnased on need, kes sõna küll kuulevad, ");
INSERT INTO ekk_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ent elumured ja rikkuse petlik ahvatlus ja mitmesugused muud soovid tulevad ja lämmatavad sõna nii, et see jääb viljatuks. ");
INSERT INTO ekk_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kuid heasse mulda külvatu on need, kes sõna kuulevad ja selle vastu võtavad ja vilja kannavad: mõni kolmkümmend, mõni kuuskümmend, mõni sada korda rohkem.“ ");
INSERT INTO ekk_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jeesus ütles neile: „Kas lamp tuuakse tuppa selleks, et see panna vaka või voodi alla? Eks panda see pigem lambijalale? ");
INSERT INTO ekk_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Sest kõik peidetu on olemas vaid avalikuks saamiseks, kõik varjatu vaid ilmsiks tulemiseks. ");
INSERT INTO ekk_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kui kellelgi on kõrvad kuulda, see kuulgu!“ ");
INSERT INTO ekk_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ja Jeesus ütles neile: „Pange tähele, mida te kuulete! Mis mõõduga teie mõõdate, sellega mõõdetakse ka teile, ja enamgi veel. ");
INSERT INTO ekk_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kellel on, sellele antakse, ja kellel ei ole, selle käest võetakse seegi, mis tal on.“ ");
INSERT INTO ekk_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jeesus ütles ka: „Just selline on Jumala riik: mees viskab seemne mulda. ");
INSERT INTO ekk_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ta heidab magama või ärkab üles, öösel ja päeval, ning seeme idaneb ja kasvab, kuid ta ei tea, kuidas. ");
INSERT INTO ekk_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Maa kannab vilja iseenesest, esmalt orast, siis päid, siis täit tera viljapea sees. ");
INSERT INTO ekk_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Aga niipea kui vili on küps, saadab ta sirbi, sest lõikusaeg on käes.“ ");
INSERT INTO ekk_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ja Jeesus ütles: „Millega võiks võrrelda Jumala riiki või millise tähendamissõnaga seda kujutada? ");
INSERT INTO ekk_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","See on nagu sinepiseeme, mis on väikseim kõigist seemneist maa peal. ");
INSERT INTO ekk_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ent kui see on külvatud, siis see võrsub ja kasvab suuremaks kõigist aiataimedest ja kasvatab suured oksad, nii et taeva linnud võivad pesitseda selle varjus.“ ");
INSERT INTO ekk_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ja Jeesus rääkis neile Jumala sõna paljude selliste tähendamissõnadega, nii palju kui nad suutsid mõista. ");
INSERT INTO ekk_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Aga ilma tähendamissõnata ei rääkinud ta neile midagi. Kuid omavahel olles seletas ta jüngritele kõike. ");
INSERT INTO ekk_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Samal päeval õhtu jõudes ütles Jeesus jüngritele: „Lähme vastaskaldale!“ ");
INSERT INTO ekk_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nad jätsid rahvahulga maha ning võtsid Jeesuse kaasa, nii nagu ta paadis oli; ka teisi paate oli temaga. ");
INSERT INTO ekk_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Järsku tõusis tugev raju ja lained lõid üle paadi, nii et paat juba täitus veest. ");
INSERT INTO ekk_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Aga Jeesus magas paadipäras, pea padjal. „Õpetaja, kas sa ei hooli sellest, et me upume?“ hüüdsid jüngrid teda üles äratades. ");
INSERT INTO ekk_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jeesus tõusis püsti, sõitles tuult ja ütles lainetele: „Vait! Olge tasa!“ Ja tuul rauges ning järvepind muutus täiesti tasaseks. ");
INSERT INTO ekk_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jeesus ütles jüngritele: „Miks te olete nii hirmul? Kuidas teil ei ole usku?“ ");
INSERT INTO ekk_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Neid valdas aga suur aukartus ja nad küsisid üksteiselt: „Kes see mees küll on, et isegi tuul ja lained kuuletuvad talle?“ ");
INSERT INTO ekk_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nad jõudsid järve vastaskaldale gerasalaste maale. ");
INSERT INTO ekk_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kui Jeesus paadist välja astus, tuli tema juurde hauakoobastest tulnud rüveda vaimuga mees. ");
INSERT INTO ekk_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","See mees elas haudades ja keegi ei olnud suutnud teda isegi ahelatega kinni hoida. ");
INSERT INTO ekk_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Teda oli korduvalt käsist ja jalust aheldatud, kuid ta oli katki rebinud ahelad ja purustanud jalarauad. Keegi ei olnud suutnud teda kinni hoida. ");
INSERT INTO ekk_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ööl ja päeval viibis ta hauakoobastes ja mägedes, röökis ning tagus end kividega. ");
INSERT INTO ekk_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kui mees märkas kaugelt Jeesust, jooksis ta ja langes põlvili ta ette maha. ");
INSERT INTO ekk_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ta kisendas valju häälega: „Mida sa minust tahad, Jeesus, Kõigekõrgema Jumala Poeg? Jumala nimel, ära piina mind!“ ");
INSERT INTO ekk_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Sest Jeesus oli öelnud temale: „Rüve vaim, mine temast välja!“ ");
INSERT INTO ekk_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","„Mis su nimi on?“ küsis Jeesus temalt. „Mu nimi on Leegion, sest meid on palju,“ vastas ta ");
INSERT INTO ekk_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ja anus väga, et Jeesus neid ära ei ajaks sellelt maalt. ");
INSERT INTO ekk_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Seal lähedal oli mäeveerul suur seakari söömas. ");
INSERT INTO ekk_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Rüvedad vaimud anusid Jeesust: „Saada meid sigadesse, luba, et me läheksime neisse!“ ");
INSERT INTO ekk_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ta andis neile loa ning rüvedad vaimud lahkusid mehest ja läksid sigadesse. Seakari, kokku umbes kaks tuhat looma, tormas järsakust alla järve ja uppus. ");
INSERT INTO ekk_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ja seakarjused põgenesid ning rääkisid sellest linnas ja maal ning inimesed tulid vaatama, mis oli juhtunud. ");
INSERT INTO ekk_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kui nad tulid Jeesuse juurde ja nägid kurjast vaimust vaevatud meest, kelles oli olnud terve Leegion, istumas seal riietatuna ja täie mõistuse juures, valdas neid hirm. ");
INSERT INTO ekk_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Pealtnägijad kirjeldasid, mis oli juhtunud kurjast vaimust vaevatud mehe ja sigadega, ");
INSERT INTO ekk_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ja inimesed hakkasid paluma Jeesust, et ta nende piirkonnast lahkuks. ");
INSERT INTO ekk_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ja kui Jeesus oli paati astumas, palus mees, kes oli olnud kurjast vaimust vaevatud, luba minna koos temaga. ");
INSERT INTO ekk_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ent Jeesus ei lubanud, vaid ütles: „Mine koju omade juurde ja tunnista neile, mida Issand on sinu heaks teinud ja kuidas ta sinu peale on halastanud.“ ");
INSERT INTO ekk_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mees läks ära ja hakkas Dekapolises kuulutama, mida Jeesus oli talle teinud. Ja kõik panid seda imeks. ");
INSERT INTO ekk_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ja kui Jeesus oli sõitnud paadiga taas vastaskaldale, kogunes suur rahvahulk tema ümber, kui ta alles oli järve ääres. ");
INSERT INTO ekk_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Siis tuli Jairus, üks sünagoogi ülemaist, ja langes Jeesuse ette maha. ");
INSERT INTO ekk_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ta palus teda tungivalt: „Mu tütreke on suremas! Tule ometi ja pane käed tema peale, et ta saaks terveks ja jääks ellu!“ ");
INSERT INTO ekk_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ja Jeesus läks temaga. Suur rahvahulk käis tema järel ja tungles tema ümber. ");
INSERT INTO ekk_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nende hulgas oli kaksteist aastat verejooksu käes kannatanud naine, ");
INSERT INTO ekk_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","kes oli palju pidanud vaevlema arstide käes ja ära kulutanud kogu oma vara, kuid polnud saanud abi, vaid haigus oli läinud aina hullemaks. ");
INSERT INTO ekk_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","See naine oli kuulnud lugusid Jeesusest ning tuli nüüd rahvahulga seas Jeesuse selja taha ja puudutas tema kuube, ");
INSERT INTO ekk_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","sest ta arvas: „Kui ma saaksin kasvõi tema rõivaid puudutada, siis ma paraneksin!“ ");
INSERT INTO ekk_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kohe lakkaski verejooks ning ta tundis oma ihus, et ta oli vabastatud kannatustest. ");
INSERT INTO ekk_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Samal hetkel tundis Jeesus, kuidas vägi temast väljus, ta pööras rahvahulga seas ümber ja küsis: „Kes puudutas mu kuube?“ ");
INSERT INTO ekk_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ta jüngrid ütlesid talle: „Sa näed ju, milline tunglemine on su ümber, ja küsid veel: „Kes mind puudutas?“ “ ");
INSERT INTO ekk_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ent Jeesus vaatas ringi, et näha, kes seda oli teinud. ");
INSERT INTO ekk_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Naine, mõistes, mis talle oli sündinud, tuli kartlikult värisedes ning langes Jeesuse jalge ette maha ja rääkis talle kogu tõe. ");
INSERT INTO ekk_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jeesus lausus talle: „Tütar, sinu usk on sind terveks teinud, mine rahus ja ole vaba oma kannatustest!“ ");
INSERT INTO ekk_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kui Jeesus alles rääkis, tuldi sünagoogi ülema kodust ja öeldi: „Su tütar on surnud, ära enam ilmaaegu Õpetajat tülita!“ ");
INSERT INTO ekk_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ent Jeesus ei hoolinud nende jutust, vaid ütles sünagoogi ülemale: „Ära karda, usu vaid!“ ");
INSERT INTO ekk_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ta ei lubanud kedagi enesega kaasa tulla peale Peetruse, Jaakobuse ja tema venna Johannese. ");
INSERT INTO ekk_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kui nad saabusid sünagoogi ülema majja, nägi Jeesus käratsemist ja valjult nutvaid ja halisevaid inimesi. ");
INSERT INTO ekk_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ta astus sisse ja küsis neilt: „Miks te käratsete ja nutate? Laps ei ole surnud, vaid magab!“ ");
INSERT INTO ekk_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ja nad naersid tema üle. Aga kui ta oli nad kõik välja saatnud, võttis ta kaasa lapse isa ja ema ja oma kaaslased ja astus lapse juurde. ");
INSERT INTO ekk_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ta võttis kinni lapse käest ja ütles talle: „Talitaa kuum!“ See tähendab „Tüdruk, tõuse üles!“ ");
INSERT INTO ekk_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ja tüdruk tõusis otsekohe püsti ja kõndis ringi; ta oli juba kaheteistkümneaastane. Ja neid kõiki valdas tohutu hämmastus. ");
INSERT INTO ekk_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Aga Jeesus keelas neid karmilt sellest rääkimast, ja käskis anda tüdrukule süüa. ");
INSERT INTO ekk_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Siis Jeesus lahkus sealt ja läks jüngritega oma kodulinna. ");
INSERT INTO ekk_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Hingamispäeva saabudes hakkas ta õpetama sünagoogis ja paljud, kes teda kuulsid, olid hämmastunud. „Kust see mees sai selle kõik?“ küsisid nad. „Mis tarkus see küll on, mis talle on antud? Mida tähendavad need imed, mida ta teeb? ");
INSERT INTO ekk_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Eks tema ole see puusepp, Maarja poeg ning Jaakobuse, Joosese, Juudase ja Siimoni vend? Ja eks ka tema õed ole siin meie juures?“ Ja nad said tema peale vihaseks. ");
INSERT INTO ekk_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Aga Jeesus ütles neile: „Kuskil ei peeta prohvetist vähem lugu kui ta oma kodukohas, oma sugulaste juures ja ta oma majas!“ ");
INSERT INTO ekk_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ja ta ei saanud seal teha ainsatki imetegu peale mõne haige tervendamise, kui ta oli pannud käed nende peale. ");
INSERT INTO ekk_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ja ta imestas nende uskmatuse üle. Siis Jeesus rändas ümberkaudsetes külades ja õpetas. ");
INSERT INTO ekk_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ta kutsus kaksteist jüngrit enese juurde ja hakkas välja läkitama kahekaupa ja andis neile meelevalla rüvedate vaimude üle. ");
INSERT INTO ekk_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Need olid tema juhised: „Ärge võtke tee peale kaasa midagi peale kepi: ei leiba, kotti ega raha vöö vahel. ");
INSERT INTO ekk_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kandke sandaale, kuid teist särki ärge võtke. ");
INSERT INTO ekk_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kuhu majja te iganes astute, sinna jääge, kuni sellest linnast lahkumiseni! ");
INSERT INTO ekk_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ja kui mõnes kohas teid vastu ei võeta ega kuulata, siis minge edasi ja raputage maha selle koha tolm oma jalgadelt neile tunnistuseks.“ ");
INSERT INTO ekk_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nad läksid välja ja kuulutasid, et inimesed parandaksid meelt. ");
INSERT INTO ekk_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nad ajasid välja palju kurje vaime ja võidsid paljusid haigeid õliga ja tegid nad terveks. ");
INSERT INTO ekk_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kuningas Heroodes sai kuulda Jeesusest, sest ta nimi oli saanud tuntuks. Mõned ütlesid: „Ristija Johannes on üles äratatud surnuist ja sellepärast toimivad temas imelised väed.“ ");
INSERT INTO ekk_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Teised ütlesid: „Tema on Eelija!“ Ja veel teised ütlesid: „Ta on nagu üks muistsetest prohvetitest!“ ");
INSERT INTO ekk_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Aga kui Heroodes seda kuulis, ütles ta: „Johannes, kelle pea ma lasksin maha raiuda, on surnuist üles tõusnud!“ ");
INSERT INTO ekk_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Sest Heroodes ise oli lasknud Johannese kinni võtta, ahelatesse panna ja vangi heita. Ta tegi seda Heroodiase, oma venna Filippuse naise pärast, kelle ta oli endale naiseks võtnud. ");
INSERT INTO ekk_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Johannes oli talle öelnud: „Sul ei ole seaduse järgi õigust võtta oma venna naist!“ ");
INSERT INTO ekk_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Seepärast pidas Heroodias Johannese peale viha ja soovis teda tappa, ent ei saanud, ");
INSERT INTO ekk_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","sest Heroodes kartis Johannest. Ta teadis, et Johannes on õige ja püha mees, ning kaitses teda. Ta ka kuulas Johannest meeleldi, kuigi tema kõned viisid ta kimbatusse. ");
INSERT INTO ekk_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ent lõpuks saabus sobilik aeg. Heroodes korraldas oma sünnipäeval pidusöögi kõrgetele ametimeestele, sõjaväeülematele ja Galilea juhtidele. ");
INSERT INTO ekk_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Heroodiase tütar tuli sisse ja tantsis. See meeldis Heroodesele ja pidulistele, nii et kuningas ütles tüdrukule: „Palu mu käest, mida sa iganes soovid, ja ma annan sulle!“ ");
INSERT INTO ekk_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ta lubas vandega: „Mida sa iganes palud, ma annan sulle, olgu või pool minu kuningriiki!“ ");
INSERT INTO ekk_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ja tüdruk läks välja ja küsis emalt nõu: „Mida ma peaksin paluma?“ „Ristija Johannese pead!“ vastas ema. ");
INSERT INTO ekk_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tüdruk tõttas kuninga juurde tagasi ja ütles: „Ma soovin, et sa otsekohe annaksid mulle kandikul Ristija Johannese pea!“ ");
INSERT INTO ekk_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kuningas sai väga kurvaks, kuid piduliste kuuldes antud vande pärast ei saanud ta tüdruku soovi tagasi lükata. ");
INSERT INTO ekk_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ta saatis kohe timuka käsuga tuua Johannese pea. Timukas läks vanglasse, lõi Johannesel pea otsast, ");
INSERT INTO ekk_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","tõi selle kandikul ja ulatas tüdrukule, kes andis selle oma emale. ");
INSERT INTO ekk_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kui Johannese jüngrid sellest kuulsid, tulid nad ja viisid ta surnukeha ära ning asetasid hauda. ");
INSERT INTO ekk_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apostlid aga kogunesid Jeesuse juurde ja andsid talle aru kõigest, mis nad olid teinud ja õpetanud. ");
INSERT INTO ekk_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jeesus ütles neile: „Lähme omaette kõrvalisse kohta ja puhkame pisut!“ Sest inimesi tuli ja läks kogu aeg, nii et neil ei olnud aega süüagi. ");
INSERT INTO ekk_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nad sõudsid paadiga kõrvalisse paika omaette. ");
INSERT INTO ekk_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kuid nende minekut märgati ja mitmed tundsid nad ära. Inimesed jooksid sinna kokku kõigist linnadest ja olid kohal enne neid. ");
INSERT INTO ekk_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kui Jeesus astus paadist kaldale ja nägi suurt rahvahulka, hakkas tal neist kahju, sest nad olid nagu lambad, kellel ei ole karjast. Ja ta hakkas neile õpetama paljusid asju. ");
INSERT INTO ekk_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kui aeg oli juba hiline, tulid jüngrid Jeesuse juurde ja ütlesid: „Paik on üksildane ja aeg juba hiline. ");
INSERT INTO ekk_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Lase inimestel minna, et nad läheksid ümberkaudsetesse asulatesse ja küladesse ning ostaksid endale midagi süüa!“ ");
INSERT INTO ekk_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jeesus vastas: „Andke teie neile süüa!“ Jüngrid küsisid: „See võtaks rohkem kui poole aasta palga! Kas peaksime minema ja kulutama nii palju leivale ning andma seda neile süüa?“ ");
INSERT INTO ekk_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jeesus ütles neile: „Minge vaadake, mitu leiba teil on!“ Nad vaatasid ja ütlesid: „Viis leiba ja kaks kala.“ ");
INSERT INTO ekk_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Siis Jeesus käskis panna kõik inimesed rühmakaupa rohule istuma. ");
INSERT INTO ekk_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Inimesed istusid maha sajaste ja viiekümneste rühmade kaupa. ");
INSERT INTO ekk_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ja Jeesus võttis need viis leiba ja kaks kala, vaatas üles taevasse, õnnistas ja murdis leivad ning andis jüngrite kätte rahvale jagamiseks; samuti jagas need kaks kala. ");
INSERT INTO ekk_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ja kõik sõid ja said söönuks. ");
INSERT INTO ekk_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ent leibadest ja kaladest ülejäänud palukesi korjati kokku kaksteist korvitäit. ");
INSERT INTO ekk_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Sööjaid oli aga viis tuhat meest. ");
INSERT INTO ekk_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jeesus käskis kohe seejärel oma jüngritel astuda paati ning sõita vastaskaldale Betsaidasse, samal ajal kui tema laseb rahvahulgal minna. ");
INSERT INTO ekk_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ta saatis nad teele ning läks mäele palvetama. ");
INSERT INTO ekk_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Õhtu saabudes oli paat keset järve ja Jeesus üksinda maal. ");
INSERT INTO ekk_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kui ta nägi jüngreid raskustes sõudmas, sest tuul oli vastu, tuli ta neljanda valvekorra ajal nende juurde järve peal kõndides. Ta tahtis neist mööduda, ");
INSERT INTO ekk_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","aga Jeesust järve peal kõndimas nähes arvasid nad, et see on vaim. Nad hakkasid kisendama, ");
INSERT INTO ekk_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","sest nad kõik nägid teda ja ehmusid. Kuid Jeesus sõnas neile: „Olge julged, see olen mina! Ärge kartke!“ ");
INSERT INTO ekk_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ja ta astus nende juurde paati ja tuul rauges. Jüngrid hämmastusid üliväga. ");
INSERT INTO ekk_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nad ei olnud leibade loost midagi mõistnud, sest nende südamed olid tuimad. ");
INSERT INTO ekk_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kui nad olid ületanud järve, randusid nad Genneesaretis ja jäid sinna ankrusse. ");
INSERT INTO ekk_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ja kui nad paadist maale astusid, tunti Jeesus kohe ära. ");
INSERT INTO ekk_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Inimesed jooksid läbi kogu ümbruskonna ning kandsid haigeid magamisasemetel sinna, kus iganes nad kuulsid Jeesuse olevat. ");
INSERT INTO ekk_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kuhu ta iganes läks, olgu küladesse, linnadesse või maakohtadesse, asetati haiged turuplatsidele. Need anusid teda, et nad saaksid puudutada kasvõi tema kuuepalistust, ja kes iganes teda puudutasid, said terveks. ");
INSERT INTO ekk_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kui siis variserid ja mõned Jeruusalemmast tulnud kirjatundjad kogunesid Jeesuse juurde, ");
INSERT INTO ekk_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","märkasid nad mõnda tema jüngritest pühitsemata, see tähendab pesemata kätega söömas. ");
INSERT INTO ekk_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Variserid, nagu kõik juudid, söövad ju alles pärast seda, kui on peotäie veega käsi pesnud, pidades nõnda kinni esivanemate pärimusest. ");
INSERT INTO ekk_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nad ei söö ka midagi turult toodut enne, kui on seda veega pesnud, ja nad peavad kinni veel mitmetest muudest tavadest: karikate, kannude ja vaskkatelde pesemisest.) ");
INSERT INTO ekk_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nüüd variserid ja kirjatundjad küsisid Jeesuselt: „Miks sinu jüngrid ei toimi esivanemate pärimuse järgi, vaid söövad leiba pühitsemata kätega?“ ");
INSERT INTO ekk_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jeesus vastas: „Jesajal oli õigus, kui ta teie, silmakirjatsejate, kohta ennustas; nõnda nagu on kirjutatud: „See rahvas austab mind oma huultega, nende süda on aga minust kaugel. ");
INSERT INTO ekk_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ilmaaegu nad teenivad mind, õpetades õpetusi, mis on vaid inimeste reeglid.“ ");
INSERT INTO ekk_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Te jätate kõrvale Jumala käsud ja järgite inimeste kombeid.“ ");
INSERT INTO ekk_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ja ta jätkas: „Kui osavalt te heidate Jumala käsud kõrvale, et järgida oma pärimust! ");
INSERT INTO ekk_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mooses ütles ju: „Austa oma isa ja ema!“ ning „Kes oma isa või ema neab, peab surema.“ ");
INSERT INTO ekk_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kuid teie ütlete, et kui keegi kuulutab oma isale või emale: „Mis toetust sa iganes minu käest saad, on korban“ (see tähendab templile pühendatud ohvriandi), ");
INSERT INTO ekk_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ei lase teie neil enam midagi oma isa või ema heaks teha. ");
INSERT INTO ekk_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Te teete Jumala sõna tühjaks oma pärimuse kaudu, mille te olete pärinud. Ja te teete veel palju muudki niisugust!“ ");
INSERT INTO ekk_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ja kui Jeesus oli taas rahva enda juurde kutsunud, ütles ta neile: „Kuulge mind kõik ja mõistke! ");
INSERT INTO ekk_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Miski, mis läheb väljastpoolt inimest tema sisse, ei või teda rüvetada; aga mis läheb inimesest välja, see rüvetab inimest. ");
INSERT INTO ekk_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kellel kõrvad on, see kuulgu!“ ");
INSERT INTO ekk_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kui Jeesus läks rahva juurest ära ühte majja, küsisid jüngrid temalt selle tähendamissõna mõtet. ");
INSERT INTO ekk_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jeesus ütles neile: „Kas teiegi olete taipamatud? Kas te ei saa aru, et miski väljast inimesse tulev ei saa teda rüvetada, ");
INSERT INTO ekk_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","sest see ei lähe tema südamesse, vaid kõhtu, ja heidetakse jälle välja?“ Sel viisil kuulutas Jeesus puhtaks kõik toidud. ");
INSERT INTO ekk_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Aga ta ütles veel: „Mis inimesest välja tuleb, see rüvetab teda. ");
INSERT INTO ekk_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sest seest, inimese südamest, lähtuvad kurjad mõtted, kõlvatu suguelu, vargused, mõrvad, ");
INSERT INTO ekk_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","abielurikkumine, ahnus, kurjus, kavalus, nilbus, kadedus, laim, ülbus, rumalus. ");
INSERT INTO ekk_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kõik need pahed tulevad seestpoolt ja rüvetavad inimest.“ ");
INSERT INTO ekk_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ja Jeesus läks sealt Tüürose alale. Ta astus sisse ühte majja, soovides, et keegi sellest teada ei saaks, kuid ta ei saanud jääda märkamatuks. ");
INSERT INTO ekk_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Temast kuulis keegi naine, kelle väikest tütart vaevas rüve vaim, ja ta tuli otsekohe ning langes Jeesuse jalge ette. ");
INSERT INTO ekk_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ta oli kreeklanna, pärit Sürofoiniikiast. Naine palus Jeesust, et ta ajaks kurja vaimu tema tütrest välja. ");
INSERT INTO ekk_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kuid Jeesus ütles talle: „Lase esmalt lastel saada söönuks! Ei sobi võtta laste leiba ja visata see koertele!“ ");
INSERT INTO ekk_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Naine aga vastas: „Jah, Issand, aga koerad söövad ju laua all laste raasukesi!“ ");
INSERT INTO ekk_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","„Kui sa nii ütled, siis mine!“ ütles Jeesus. „Kuri vaim on sinu tütrest välja läinud!“ ");
INSERT INTO ekk_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ja naine läks koju ning leidis lapse voodis magamas. Kuri vaim oli temast lahkunud. ");
INSERT INTO ekk_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jeesus lahkus Tüürose alalt ja tuli Siidoni kaudu Galilea mere äärde Dekapolise aladele. ");
INSERT INTO ekk_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tema juurde toodi kurt, kes vaevu rääkida suutis, ning paluti, et ta paneks oma käe tema peale. ");
INSERT INTO ekk_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jeesus viis mehe rahvahulgast eemale, pistis oma sõrmed ta kõrvadesse, sülitas ja puudutas ta keelt ");
INSERT INTO ekk_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ning üles taeva poole vaadates õhkas ja ütles talle: „Effataa!“, see tähendab „Mine lahti!“ ");
INSERT INTO ekk_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mehe kõrvad avanesid sedamaid ja ta keel pääses kütkest valla ning ta rääkis korralikult. ");
INSERT INTO ekk_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jeesus ei lubanud neil sellest kellelegi rääkida. Aga mida enam ta neid keelas, seda enam nad jutustasid. ");
INSERT INTO ekk_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ning kuulajad ütlesid suures hämmastuses: „Kõik on ta teinud hästi! Ta paneb isegi kurdid kuulma ja keeletud rääkima!“ ");
INSERT INTO ekk_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Neil päevil oli taas suur rahvahulk kokku tulnud. Ja kuna neil ei olnud midagi süüa, kutsus Jeesus jüngrid enese juurde ning ütles neile: ");
INSERT INTO ekk_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","„Mul on rahvast kahju. Nad on juba kolm päeva minu juures olnud ja neil pole midagi süüa. ");
INSERT INTO ekk_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kui ma lasen nad koju minna näljastena, siis nad nõrkevad teel, sest mõned neist on tulnud kaugelt.“ ");
INSERT INTO ekk_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jüngrid vastasid talle: „Kust peaks keegi siin kõrvalises paigas leiba saama kõigi nende inimeste toitmiseks?“ ");
INSERT INTO ekk_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","„Mitu leiba teil on?“ küsis Jeesus. „Seitse,“ vastasid nad. ");
INSERT INTO ekk_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jeesus käskis rahval maha istuda. Ta võttis need seitse leiba, tänas, murdis ja andis oma jüngritele jagamiseks, ja nemad viisid rahvale. ");
INSERT INTO ekk_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Neil olid ka mõned väikesed kalad ja Jeesus õnnistas neid ning käskis samuti jagada rahvale. ");
INSERT INTO ekk_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Inimesed sõid ja said söönuks. Ja jüngrid korjasid ülejäänud palukesi seitse korvitäit. ");
INSERT INTO ekk_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Sööjaid oli aga umbes neli tuhat meest. Siis Jeesus laskis neil minna. ");
INSERT INTO ekk_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ta astus kohe koos oma jüngritega paati ja suundus Dalmanuuta aladele. ");
INSERT INTO ekk_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Variserid tulid ja hakkasid Jeesust küsitlema. Et teda proovile panna, nõudsid nad temalt tunnustähte taevast. ");
INSERT INTO ekk_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jeesus ohkas sügavalt ja ütles: „Miks see sugupõlv nõuab tunnustähte? Tõesti, ma ütlen teile, sellele sugupõlvele ei anta tunnustähte!“ ");
INSERT INTO ekk_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ning ta jättis nad maha, astus taas paati ning siirdus vastaskaldale. ");
INSERT INTO ekk_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ent jüngrid olid unustanud kaasa võtta toitu, neil ei olnud paadis kaasas muud kui üksainuke leib. ");
INSERT INTO ekk_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","„Vaadake ette, hoiduge variseride juuretisest ja Heroodese juuretisest!“ hoiatas neid Jeesus. ");
INSERT INTO ekk_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nemad aga arutasid omavahel: „Ta räägib sellest, et meil ei ole leiba!“ ");
INSERT INTO ekk_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Seda märgates ütles Jeesus neile: „Miks te leiva puudumise üle arutate? Kas te ikka veel ei taipa ega saa aru? Kas teie süda on ikka veel tuim? ");
INSERT INTO ekk_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kas teil on silmad, aga te ei näe, kas teil on kõrvad, aga te ei kuule? Kas teil ei ole meeles, ");
INSERT INTO ekk_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","kui ma viis leiba murdsin viiele tuhandele? Mitu korvitäit palukesi jäi üle?“ „Kaksteist,“ vastasid nemad. ");
INSERT INTO ekk_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","„Kui ma seitse leiba murdsin neljale tuhandele, mitu korvitäit palukesi siis jäi üle?“ Nad vastasid: „Seitse.“ ");
INSERT INTO ekk_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","„Kas te ikka veel ei saa aru?“ küsis Jeesus. ");
INSERT INTO ekk_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nii nad saabusid Betsaidasse. Tema juurde toodi pime mees ja anuti, et Jeesus teda puudutaks. ");
INSERT INTO ekk_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jeesus talutas kättpidi mehe külast välja, sülitas tema silmadesse, pani käed ta peale ja küsis: „Kas sa näed midagi?“ ");
INSERT INTO ekk_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Pime vaatas üles ja ütles: „Ma näen inimesi, nad on nagu puud, mis kõnnivad.“ ");
INSERT INTO ekk_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Seejärel pani Jeesus uuesti käed ta silmadele ja ta sai täiesti terveks ja nägi kõike selgesti. ");
INSERT INTO ekk_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jeesus käskis tal minna koju, öeldes: „Ära minegi külasse!“ ");
INSERT INTO ekk_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Siis Jeesus ja ta jüngrid läksid edasi Filippuse Kaisarea küladesse. Teel küsis ta jüngritelt: „Kelle ütlevad inimesed mind olevat?“ ");
INSERT INTO ekk_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","„Mõned ütlevad Ristija Johannese, mõned Eelija, mõned ühe prohveteist,“ vastasid nad talle. ");
INSERT INTO ekk_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","„Aga teie?“ küsis Jeesus. „Kelle teie ütlete mind olevat?“ Peetrus vastas talle: „Sina oled Messias!“ ");
INSERT INTO ekk_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Aga Jeesus hoiatas neid rangelt, et nad sellest kellelegi ei räägiks. ");
INSERT INTO ekk_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Siis Jeesus hakkas neid õpetama, et Inimese Poeg peab palju kannatama ning hüljatama vanemate ja ülempreestrite ja kirjatundjate poolt ja tapetama ning kolme päeva pärast üles tõusma. ");
INSERT INTO ekk_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ta rääkis sellest avalikult. Peetrus aga viis ta kõrvale ja hakkas teda noomima. ");
INSERT INTO ekk_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ent Jeesus pöördus, ja vaadates oma jüngreid, sõitles Peetrust: „Tagane minust, saatan! Sa oled mulle takistuseks, sest sa ei mõtle Jumala, vaid inimese viisil.“ ");
INSERT INTO ekk_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ja Jeesus kutsus rahvahulga koos oma jüngritega enese juurde ja ütles neile: „Kui keegi tahab käia minu järel, siis salaku ta end maha, võtku oma rist ja järgnegu mulle! ");
INSERT INTO ekk_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sest kes tahab päästa oma elu, kaotab selle, aga kes kaotab oma elu minu ja evangeeliumi pärast, päästab selle. ");
INSERT INTO ekk_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Sest mis kasu on inimesel sellest, kui ta võidaks terve maailma, aga teeks kahju oma hingele? ");
INSERT INTO ekk_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Sest mis oleks inimesel anda oma hinge eest? ");
INSERT INTO ekk_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Jah, kes iganes häbeneb mind ja minu sõnu selle abielurikkuja ja patuse sugupõlve ees, seda häbeneb ka Inimese Poeg, kui ta tuleb oma Isa auhiilguses koos pühade inglitega.“ ");
INSERT INTO ekk_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ja ta ütles neile: „Tõesti, ma ütlen teile, siin seisavad mõned, kes ei maitse surma enne, kui näevad Jumala riiki tulnud olevat väega.“ ");
INSERT INTO ekk_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kuue päeva pärast võttis Jeesus endaga kaasa Peetruse, Jaakobuse ja Johannese ning viis nad üles kõrgele mäele. Ja Jeesust muudeti nende silme all. ");
INSERT INTO ekk_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tema rõivad hakkasid erevalgena hiilgama, selliseks ei suuda ükski maapealne pesija neid valgendada. ");
INSERT INTO ekk_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ja Eelija koos Moosesega ilmus neile, ja nad kõnelesid Jeesusega. ");
INSERT INTO ekk_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Siis Peetrus ütles Jeesusele: „Rabi, siin on meil hea olla. Teeme kolm telki: sinule ühe, Moosesele ühe ja Eelijale ühe.“ ");
INSERT INTO ekk_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ta ei teadnud, mida öelda, sest neid valdas suur hirm. ");
INSERT INTO ekk_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Siis ilmus pilv, mis nende üle laskus, ja pilvest kostis hääl: „See on minu armas Poeg, teda kuulake!“ ");
INSERT INTO ekk_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ja samal hetkel, kui nad ringi vaatasid, ei näinud nad enam kedagi muud kui ainult Jeesust üksi nende juures. ");
INSERT INTO ekk_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mäelt alla laskudes keelas Jeesus neid, et nad kellelegi nähtust ei räägiks, enne kui Inimese Poeg on üles tõusnud surnuist. ");
INSERT INTO ekk_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nii nad tegidki, ent omavahel arutasid, mida võib tähendada surnuist ülestõusmine. ");
INSERT INTO ekk_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ja nad küsisid Jeesuselt: „Miks kirjatundjad ütlevad, et enne peab tulema Eelija?“ ");
INSERT INTO ekk_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","„Eelija tulebki esimesena,“ vastas ta, „ja seab taas kõik korda. Ent Inimese Pojast on kirjutatud, et tema peab palju kannatama ja teda põlatakse. ");
INSERT INTO ekk_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Aga Eelija kohta ma ütlen teile, et ta on juba tulnud, ent nad on talle teinud, mida nad tahtsid, nõnda nagu temast on kirjutatud.“ ");
INSERT INTO ekk_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kui nad tulid teiste jüngrite juurde, nägid nad suurt rahvahulka nende ümber ja kirjatundjaid nendega vaidlemas. ");
INSERT INTO ekk_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Niipea kui rahvahulk Jeesust märkas, olid nad kõik hämmastuses ja jooksid tema juurde teda tervitama. ");
INSERT INTO ekk_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jeesus küsis neilt: „Mille üle te nendega vaidlete?“ ");
INSERT INTO ekk_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Keegi rahva hulgast vastas talle: „Õpetaja, ma tõin sinu juurde oma poja. Tema kallal on kuri vaim, kes ei lase tal rääkida. ");
INSERT INTO ekk_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kus iganes see teda haarab, paiskab see poisi maha ning ta ajab vahtu suust, kiristab hambaid ja kangestub. Ma palusin su jüngreid, et nad ajaksid selle välja, kuid nad ei suutnud.“ ");
INSERT INTO ekk_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jeesus vastas neile: „Oh uskmatu sugupõlv! Kui kaua ma pean teie juures olema? Kui kaua ma pean teiega kannatama? Tooge poiss minu juurde!“ ");
INSERT INTO ekk_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nad tõid ta Jeesuse juurde. Kui vaim nägi Jeesust, raputas see sedamaid poissi, nii et ta kukkus ja vähkres maas vahtu suust välja ajades. ");
INSERT INTO ekk_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jeesus küsis poisi isalt: „Kui kaua see temaga nõnda on?“ „Lapsest saadik,“ vastas isa. ");
INSERT INTO ekk_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","„See on teda sageli maha paisanud, isegi tulle ja vette, et teda surmata. Aga kui sa nüüd midagi teha suudad, siis tunne meile kaasa ja aita meid!“ ");
INSERT INTO ekk_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jeesus lausus: „Sa ütled „kui sa suudad“? Kõik on võimalik sellele, kes usub!“ ");
INSERT INTO ekk_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Sedamaid hüüatas lapse isa: „Ma usun! Aita mind üle mu uskmatusest!“ ");
INSERT INTO ekk_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kui Jeesus nägi, et rahvahulk kokku jookseb, sõitles ta rüvedat vaimu: „Sina kurt ja tumm vaim, ma käsin sind, mine temast välja ja ära tule kunagi enam tema sisse!“ ");
INSERT INTO ekk_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Vaim läks välja kisendades ja teda tugevasti raputades ning poiss jäi otsekui surnuks, nii et paljud ütlesid, et ta on nüüd surnud. ");
INSERT INTO ekk_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kuid Jeesus võttis poisi käest kinni, aitas ta üles, ja poiss tõusis püsti. ");
INSERT INTO ekk_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kui nad sisse läksid, küsisid ta jüngrid Jeesuselt omavahel olles: „Miks meie ei suutnud seda välja ajada?“ ");
INSERT INTO ekk_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jeesus ütles neile: „See tõug ei lähe välja teisiti kui palve ja paastuga.“ ");
INSERT INTO ekk_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nad lahkusid sealt ja rändasid läbi Galilea. Jeesus ei tahtnud, et keegi saaks teada, ");
INSERT INTO ekk_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","sest ta õpetas oma jüngreid. Ta ütles neile: „Inimese Poeg antakse inimeste kätte ja nad tapavad tema, ja ta tõuseb kolmandal päeval surnuist üles!“ ");
INSERT INTO ekk_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Aga nemad ei saanud aru, mida ta sellega mõtles, ja nad kartsid temalt seletust küsida. ");
INSERT INTO ekk_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Seejärel tulid nad Kapernauma. Ja kui nad jõudsid koju, küsis Jeesus neilt: „Mille üle te tee peal vaidlesite?“ ");
INSERT INTO ekk_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nemad aga jäid vait, sest nad olid teel omavahel vaielnud, kes neist on suurim. ");
INSERT INTO ekk_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jeesus istus maha, kutsus kaksteist jüngrit ja ütles neile: „Kui keegi tahab olla esimene, siis ta olgu viimane, ja kõikide teenija!“ ");
INSERT INTO ekk_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ja ta võttis ühe väikese lapse ja pani nende keskele seisma. Teda kätele võttes ta ütles: ");
INSERT INTO ekk_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","„Kes iganes ühe sellise lapse vastu võtab minu nimel, võtab vastu minu, ja kes vastu võtab minu, võtab vastu mitte minu, vaid tema, kes mind on läkitanud.“ ");
INSERT INTO ekk_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Johannes ütles Jeesusele: „Õpetaja, me nägime üht meest sinu nimel kurje vaime välja ajamas ja me keelasime teda, sest ta ei järgi meiega koos sind.“ ");
INSERT INTO ekk_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Aga Jeesus vastas: „Ärge keelake teda, sest ükski, kes teeb minu nimel vägeva teo, ei saa samal ajal rääkida minust halvasti. ");
INSERT INTO ekk_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Sest kes ei ole meie vastu, see on meie poolt. ");
INSERT INTO ekk_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tõesti, ma ütlen teile, kes iganes annab teile juua klaasitäie vett, sellepärast et te Messiale kuulute, ei jää kindlasti oma tasust ilma. ");
INSERT INTO ekk_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kes iganes ahvatleb patule ühe neist väikestest, kes minusse usuvad, sellele oleks parem, kui talle seotaks veskikivi kaela ja ta visataks merre. ");
INSERT INTO ekk_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kui su käsi ahvatleb sind patule, raiu see küljest, sest sul on parem minna vigasena ellu kui kahe käega põrgusse kustumatusse tulle, ");
INSERT INTO ekk_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","kus nende uss ei sure ja nende tuli ei kustu. ");
INSERT INTO ekk_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ja kui su jalg sind ahvatleb patustama, raiu see maha, sest sul on parem minna jalutuna ellu kui kahe jalaga olla heidetud põrgusse, ");
INSERT INTO ekk_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","kus nende uss ei sure ja nende tuli ei kustu. ");
INSERT INTO ekk_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ja kui su silm ahvatleb sind patule, rebi see välja, sest sul on parem minna ühe silmaga Jumala riiki kui olla kahe silmaga heidetud põrgusse, ");
INSERT INTO ekk_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","„kus nende uss ei sure ja nende tuli ei kustu!“ ");
INSERT INTO ekk_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Sest kõiki soolatakse tulega. ");
INSERT INTO ekk_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sool on hea; aga kui sool läheb magedaks, millega te seda siis maitsestate? Olgu teil soola enestes ja pidage rahu üksteisega!“ ");
INSERT INTO ekk_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jeesus lahkus sealt ja tuli Juudamaa aladele sealpool Jordanit. Jälle kogunes hulk rahvast tema juurde ja ta õpetas neid, nagu tal oli kombeks. ");
INSERT INTO ekk_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Jeesuse juurde tulid mõned variserid, et teda proovile panna, ja küsisid: „Kas mehel on luba oma naisest lahutada?“ ");
INSERT INTO ekk_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jeesus küsis neilt: „Kuidas Mooses teid käskis?“ ");
INSERT INTO ekk_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nad vastasid: „Mooses lubas kirjutada lahutustunnistuse ja naise minema saata.“ ");
INSERT INTO ekk_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jeesus ütles neile: „Teie kõva südame pärast kirjutas ta teile selle käsu. ");
INSERT INTO ekk_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Aga loomise algul lõi Jumal nad meheks ja naiseks. ");
INSERT INTO ekk_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Seepärast jätab mees maha oma isa ja ema ning hoiab oma naise poole ");
INSERT INTO ekk_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ja need kaks saavad üheks. Siis nad ei ole enam kaks, vaid üks liha. ");
INSERT INTO ekk_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mis nüüd Jumal on ühte pannud, seda ärgu inimene lahutagu!“ ");
INSERT INTO ekk_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kodus küsisid jüngrid uuesti temalt selle kohta ");
INSERT INTO ekk_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ja Jeesus ütles neile: „Kes lahutab oma naisest ja abiellub teisega, rikub temaga abielu. ");
INSERT INTO ekk_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ja kui naine on maha jätnud oma mehe ja abiellub teisega, rikub ta abielu.“ ");
INSERT INTO ekk_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jeesuse juurde toodi väikesi lapsi, et ta neid puudutaks. Jüngrid aga tõrelesid toojatega, ");
INSERT INTO ekk_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","kuid Jeesus sai seda nähes pahaseks ja ta ütles neile: „Laske lapsed minu juurde tulla, ärge keelake neid, sest selliste päralt on Jumala riik. ");
INSERT INTO ekk_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tõesti, ma ütlen teile, kes Jumala riiki vastu ei võta nagu laps, ei pääse sinna sisse.“ ");
INSERT INTO ekk_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ta võttis lapsed sülle ja õnnistas neid, pannes käed nende peale. ");
INSERT INTO ekk_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kui Jeesus asus teele, jooksis üks mees tema juurde ja langes ta ette põlvili, küsides: „Hea Õpetaja, mida ma pean tegema, et ma päriksin igavese elu?“ ");
INSERT INTO ekk_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jeesus vastas talle: „Miks sa nimetad mind heaks? Keegi muu ei ole hea kui üks – Jumal. ");
INSERT INTO ekk_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Käske sa tead: ära tapa, ära riku abielu, ära varasta, ära anna valetunnistust, ära peta, austa oma isa ja ema!“ ");
INSERT INTO ekk_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mees aga vastas talle: „Õpetaja, seda kõike olen ma pidanud poisieast alates.“ ");
INSERT INTO ekk_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jeesus aga vaatas talle otsa, tundis armastust tema vastu ja ütles: „Üks asi puudub sul. Mine müü ära kõik, mis sul on, ja jaga vaestele, ja sul on siis aare taevas, ning tule, järgne mulle!“ ");
INSERT INTO ekk_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kui noormees neid sõnu kuulis, lahkus ta kurvana, sest tal oli palju vara. ");
INSERT INTO ekk_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jeesus vaatas enda ümber ja ütles oma jüngritele: „Kui raske on rikastel pääseda Jumala riiki!“ ");
INSERT INTO ekk_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Aga jüngrid hämmastusid tema sõnade peale; ja Jeesus ütles jälle: „Lapsed, kui raske on minna Jumala riiki! ");
INSERT INTO ekk_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Hõlpsam on kaamelil minna läbi nõelasilma kui rikkal minna Jumala riiki.“ ");
INSERT INTO ekk_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jüngrid aga jahmusid veelgi enam ja küsisid üksteiselt: „Kes siis võib saada päästetud?“ ");
INSERT INTO ekk_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jeesus ütles neile otsa vaadates: „Inimesel on see võimatu, aga mitte Jumalal. Jumalal on kõik võimalik!“ ");
INSERT INTO ekk_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peetrus hakkas rääkima: „Vaata, meie oleme jätnud kõik maha, et järgneda sulle!“ ");
INSERT INTO ekk_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jeesus ütles: „Tõesti, ma ütlen teile, ei ole kedagi, kes on maha jätnud maja, vennad või õed, ema, isa või lapsed või põllud minu pärast ja evangeeliumi pärast ");
INSERT INTO ekk_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ega saaks vastu nüüd, praegusel ajal, sajavõrra maju, vendi ja õdesid, emasid ja lapsi ja põlde tagakiusamise kestelgi, ning tuleval ajastul igavest elu. ");
INSERT INTO ekk_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Aga paljud esimesed jäävad viimasteks ja viimased saavad esimesteks.“ ");
INSERT INTO ekk_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kui nad olid teel üles Jeruusalemma, kõndis Jeesus nende ees. Jüngrid olid ehmunud, aga kaasaminejaid valdas hirm. Jeesus viis kaksteist jüngrit taas kõrvale ja hakkas neile rääkima, mis teda ees ootab: ");
INSERT INTO ekk_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","„Me läheme üles Jeruusalemma ja Inimese Poeg antakse ülempreestrite ja kirjatundjate kätte. Need mõistavad ta surma ja annavad üle uskmatuile. ");
INSERT INTO ekk_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Need mõnitavad teda ja sülitavad ta peale, piitsutavad teda ja tapavad ta ära. Kuid kolme päeva pärast tõuseb ta surnuist üles.“ ");
INSERT INTO ekk_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ja Sebedeuse pojad Jaakobus ja Johannes astusid Jeesuse juurde. „Õpetaja,“ ütlesid nad talle, „me tahame, et sa meile teeksid, mida me iganes küsime!“ ");
INSERT INTO ekk_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","„Mida te tahate, et ma teile teeksin?“ küsis Jeesus. ");
INSERT INTO ekk_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nad vastasid: „Luba meile, et me istuksime sinu auhiilguses üks sinu paremal ja teine sinu vasakul käel!“ ");
INSERT INTO ekk_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kuid Jeesus ütles neile: „Teie ei tea, mida te palute. Kas te võite juua karikast, mida mina joon, või saada ristitud selle ristimisega, millega mind ristitakse?“ ");
INSERT INTO ekk_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","„Võime küll!“ vastasid nad. Jeesus ütles neile: „Küllap te joote karikast, millest mina joon, ja teid ristitakse ristimisega, millega mind ristitakse. ");
INSERT INTO ekk_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kuid kes istub mu paremal või vasakul käel, ei ole minu määrata, vaid see antakse neile, kellele see on valmistatud.“ ");
INSERT INTO ekk_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kui need kümme sellest kuulsid, vihastasid nad Jaakobuse ja Johannese peale. ");
INSERT INTO ekk_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jeesus kutsus nad enese juurde ja ütles neile: „Te teate, et rahvaste valitsejad peremehetsevad nende üle ja võimukandjad kasutavad nende kallal jõudu. ");
INSERT INTO ekk_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nõnda ärgu olgu teie seas, vaid kes iganes teie seas tahab saada suureks, olgu teie teenija, ");
INSERT INTO ekk_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ning kes iganes teie seas tahab olla esimene, olgu kõigi sulane. ");
INSERT INTO ekk_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Sest ka Inimese Poeg ei ole tulnud, et lasta ennast teenida, vaid et ise teenida ja anda oma elu lunastuseks paljude eest!“ ");
INSERT INTO ekk_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Seejärel jõudsid nad Jeerikosse. Kui Jeesus koos jüngrite ja suure rahvahulgaga linnast lahkus, istus tee ääres pime kerjus Bartimeus (mis tähendab Timeuse poega). ");
INSERT INTO ekk_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kui ta kuulis, et Naatsareti Jeesus on lähedal, hakkas ta karjuma: „Jeesus, Taaveti Poeg, halasta minu peale!“ ");
INSERT INTO ekk_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mitmed pahandasid temaga, et ta jääks vait, kuid tema karjus veel kõvemini: „Taaveti Poeg, halasta minu peale!“ ");
INSERT INTO ekk_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jeesus seisatas ja ütles: „Kutsuge ta siia!“ Ja nad kutsusid pimedat: „Ole julge! Tõuse üles, tema kutsub sind!“ ");
INSERT INTO ekk_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Pime viskas kuue seljast, hüppas püsti ja tuli Jeesuse juurde. ");
INSERT INTO ekk_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jeesus küsis temalt: „Mida sa tahad, et ma sulle teeksin?“ Aga pime vastas: „Rabi, ma tahan näha!“ ");
INSERT INTO ekk_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jeesus ütles talle: „Mine, sinu usk on su terveks teinud!“ Ja kohe nägi pime jälle ning läks Jeesusega teele kaasa. ");
INSERT INTO ekk_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kui nad lähenesid Jeruusalemmale ning tulid Betfagesse ja Betaaniasse Õlimäe juurde, läkitas Jeesus kaks oma jüngritest ");
INSERT INTO ekk_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","sõnadega: „Minge külla, mis on teie ees. Kohe sinna jõudes te leiate kinniseotud sälu, kelle seljas ei ole istunud veel keegi. Siduge ta lahti ja tooge siia! ");
INSERT INTO ekk_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ja kui keegi küsib, miks te seda teete, siis öelge, et Issand vajab teda ja saadab ta peatselt tagasi!“ ");
INSERT INTO ekk_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jüngrid läksid, leidsid sälu ukse külge seotuna tänaval ja päästsid ta lahti. ");
INSERT INTO ekk_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mõned sealseisjatest küsisid: „Miks te sälu köidikuist vabastate?“ ");
INSERT INTO ekk_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ja jüngrid vastasid neile nõnda, nagu Jeesus oli käskinud, ja neil lasti minna. ");
INSERT INTO ekk_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nad tõid sälu Jeesuse juurde, heitsid oma kuued ta peale ning Jeesus istus sälu selga. ");
INSERT INTO ekk_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ja paljud laotasid tee peale oma rõivaid, ja teised väljadelt lõigatud oksi. ");
INSERT INTO ekk_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ja need, kes käisid Jeesuse eel ja järel, hüüdsid: „Hoosanna!“ „Õnnistatud olgu, kes tuleb Issanda nimel!“ ");
INSERT INTO ekk_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","„Õnnistatud olgu meie isa Taaveti saabuv kuningriik!“ „Hoosanna kõrgeimas taevas!“ ");
INSERT INTO ekk_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jeesus saabus Jeruusalemma. Ta sisenes templisse ja silmitses kõike ümberringi, kuid kuna aeg oli juba hiline, läks ta koos nende kaheteistkümnega Betaaniasse. ");
INSERT INTO ekk_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ja järgmisel päeval Betaaniast lahkumisel tundis Jeesus nälga. ");
INSERT INTO ekk_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nähes eemal lehis viigipuud, läks ta vaatama, kas seal ka vilju on. Puu juurde jõudes ei leidnud ta aga midagi peale lehtede, sest ei olnud viigimarjade aeg. ");
INSERT INTO ekk_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jeesus ütles puule: „Ärgu keegi enam iialgi söögu sinu vilja!“ Ja ta jüngrid kuulsid seda. ");
INSERT INTO ekk_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jeruusalemma jõudes läks Jeesus templisse ning hakkas välja ajama neid, kes seal müüsid ja ostsid. Ta lükkas kummuli rahavahetajate lauad ja tuvimüüjate pingid ");
INSERT INTO ekk_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ega lubanud, et keegi kannaks kaupa läbi pühakoja. ");
INSERT INTO ekk_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ta õpetas neid: „Eks ole kirjutatud: „Minu koda hüütagu palvekojaks kõigile rahvastele“? Aga teie olete teinud selle röövlikoopaks!“ ");
INSERT INTO ekk_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ülempreestrid ja kirjatundjad said sellest kuulda ning otsisid võimalust Jeesust tappa, sest nad kartsid teda, kuna kogu rahvas oli vapustatud tema õpetusest. ");
INSERT INTO ekk_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Õhtu saabudes läksid Jeesus ja jüngrid linnast välja. ");
INSERT INTO ekk_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Varahommikul nägid nad viigipuust möödudes, et see oli juurteni ära kuivanud. ");
INSERT INTO ekk_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peetrusele meenus, mis oli juhtunud, ja ta ütles Jeesusele: „Rabi, vaata! Viigipuu, mille sa needsid, on ära kuivanud!“ ");
INSERT INTO ekk_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jeesus vastas neile: „Olgu teil usku Jumalasse! ");
INSERT INTO ekk_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tõesti, ma ütlen teile, kui keegi ütleb sellele mäele: „Tõuse paigast ja lange merre!“ ega kõhkle oma südames, vaid usub, et see, mis ta ütleb, sünnib, siis see saabki talle! ");
INSERT INTO ekk_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Seepärast ma ütlen teile, kõike, mida te palves palute – uskuge, et te olete selle saanud, ja see saabki teile! ");
INSERT INTO ekk_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ja kui te olete palvetamas, siis andke andeks, kui teil on midagi kellegi vastu, et ka teie Isa, kes on taevas, annaks teie eksimused teile andeks. ");
INSERT INTO ekk_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kui te aga ei anna andeks, siis ei anna ka teie Isa, kes on taevas, teie eksimusi teile andeks.“ ");
INSERT INTO ekk_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nad tulid taas Jeruusalemma. Kui Jeesus kõndis templis, astusid ülempreestrid, kirjatundjad ja rahvavanemad tema juurde. ");
INSERT INTO ekk_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nad nõudsid temalt: „Millise meelevallaga sa seda kõike teed? Kes on andnud sulle selle meelevalla neid asju teha?“ ");
INSERT INTO ekk_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jeesus vastas: „Minagi küsin teilt midagi. Teie vastake mulle, ja siis ma ütlen teile, millise meelevallaga ma seda teen. ");
INSERT INTO ekk_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kas Johannese ristimine oli taevast või inimestest? Öelge mulle!“ ");
INSERT INTO ekk_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nad arutasid omavahel: „Kui me ütleme, et taevast, siis ta ütleb: „Miks te siis ei uskunud teda?“ ");
INSERT INTO ekk_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Aga kui me ütleme, et inimestest…“ (Nad kartsid rahvast, sest kõikide meelest oli Johannes tõepoolest olnud prohvet.) ");
INSERT INTO ekk_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nii nad vastasid Jeesusele: „Me ei tea!“ „Ega siis minagi ütle teile, millise meelevallaga ma seda teen,“ ütles Jeesus. ");
INSERT INTO ekk_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Siis Jeesus hakkas neile tähendamissõnadega rääkima: „Üks mees istutas viinamäe, piiras aiaga, õõnestas kaljusse surutõrre ja ehitas valvetorni. Ta andis viinamäe rentnike kätte ja reisis ära. ");
INSERT INTO ekk_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Viljakoristamise ajal läkitas ta sulase rentnike juurde, et see võtaks nende käest vastu tema osa viinamäe saagist. ");
INSERT INTO ekk_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kuid rentnikud võtsid sulase kinni, peksid teda ning saatsid minema tühjade kätega. ");
INSERT INTO ekk_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Siis isand läkitas nende juurde teise sulase. Seda nad lõid pähe ja teotasid teda. ");
INSERT INTO ekk_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ta läkitas järgmise ja selle nad tapsid. Ja nii oli paljude teistega, mõnda nad peksid ja mõne tapsid. ");
INSERT INTO ekk_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Üks oli tal veel, tema armas poeg. Lõpuks ta läkitas nende juurde poja, mõeldes: „Minu poega nad austavad!“ ");
INSERT INTO ekk_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kuid rentnikud rääkisid omavahel: „Tema ongi see pärija! Lähme, tapame ta ära, siis pärand saab meile!“ ");
INSERT INTO ekk_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nad võtsid ta kinni, tapsid ta ära ja viskasid viinamäelt välja. ");
INSERT INTO ekk_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Mida teeb nüüd viinamäe isand? Ta tuleb ja hukkab need rentnikud ja annab viinamäe teiste kätte. ");
INSERT INTO ekk_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kas te pole lugenud seda kirjakohta: „Kivi, mille ehitajad pidasid kõlbmatuks, on saanud nurgakiviks. ");
INSERT INTO ekk_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","See tuli Issandalt ja on imeline meie silmis.“ “ ");
INSERT INTO ekk_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Siis ülempreestrid, kirjatundjad ja vanemad otsisid võimalust teda kinni võtta, sest nad teadsid, et Jeesus oli selle tähendamissõna rääkinud nende kohta. Aga kuna nad kartsid rahvast, jätsid nad ta rahule ja läksid minema. ");
INSERT INTO ekk_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Hiljem saadeti Jeesuse juurde mõned variserid ja heroodeslased, et teda tema sõnadest püüda. ");
INSERT INTO ekk_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nad tulid ja ütlesid talle: „Õpetaja, me teame, et sa oled aus mees. Teised ei saa sind mõjutada, sest sulle pole oluline, kes nad on. Sa õpetad Jumala teed kooskõlas tõega. Kas on õige maksta keisrile impeeriumi maksu? ");
INSERT INTO ekk_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kas peame maksma või ei pea?“ Aga Jeesus, teades nende silmakirjalikkust, ütles neile: „Miks te mind kiusate? Tooge mulle teenar näha!“ ");
INSERT INTO ekk_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nad tõidki ja ta küsis neilt: „Kelle pilt ja nimi siin on?“ „Keisri,“ vastasid nad talle. ");
INSERT INTO ekk_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jeesus ütles neile: „Andke siis keisrile, mis kuulub keisrile, ja Jumalale, mis kuulub Jumalale!“ Ja nad imestasid tema üle. ");
INSERT INTO ekk_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jeesuse juurde tulid saduserid, kes eitavad surnuist ülestõusmist, ja küsisid: ");
INSERT INTO ekk_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","„Õpetaja, Mooses on meile kirjutanud, et kui mehe vend sureb ja maha jääb naine, aga ei jää last, siis peab see mees abielluma lesega ja oma vennale järglasi kasvatama. ");
INSERT INTO ekk_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Oli seitse venda. Vanim võttis naise ja surres ei jätnud last järele. ");
INSERT INTO ekk_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Siis teine abiellus lesega ja temagi suri last jätmata, samuti kolmas. ");
INSERT INTO ekk_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Need seitse võtsid ta naiseks ja ükski neist ei jätnud järele last. Kõige viimasena suri ka naine. ");
INSERT INTO ekk_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kui nad ülestõusmisel surnuist üles tõusevad, siis kelle naine ta nende seast on? Ta on ju olnud abielus seitsmega.“ ");
INSERT INTO ekk_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jeesus vastas neile: „Kas te mitte ei eksi, sellepärast et te ei tunne Pühakirja ega Jumala väge? ");
INSERT INTO ekk_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kui surnud üles tõusevad, siis nad ei võta naisi ega lähe mehele, vaid on nagu inglid taevas. ");
INSERT INTO ekk_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Aga mis puutub surnute ülestõusmisse, kas te ei ole lugenud Moosese raamatust kibuvitsapõõsa loost, kuidas Jumal ütles Moosesele: „Mina olen Aabrahami Jumal, Iisaki Jumal ja Jaakobi Jumal.“ ");
INSERT INTO ekk_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Jumal ei ole surnute, vaid elavate Jumal. Te eksite rängalt!“ ");
INSERT INTO ekk_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Üks kirjatundjatest tuli ja kuulis neid vaidlemas. Mõistes, et Jeesus oli neile hästi vastanud, küsis ta: „Milline on kõige tähtsam käsk?“ ");
INSERT INTO ekk_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jeesus vastas: „Kõige tähtsam on: „Kuule, Iisrael, Issand, meie Jumal, on üks Issand. ");
INSERT INTO ekk_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Armasta Issandat, oma Jumalat, kogu oma südamest ja kogu oma hingest ja kogu oma mõistusest ja kogu oma jõust!“ ");
INSERT INTO ekk_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Teine on see: „Armasta oma ligimest nagu iseennast!“ Neist suuremat käsku ei ole.“ ");
INSERT INTO ekk_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","„Hästi öeldud, Õpetaja,“ vastas see mees. „Sul on õigus, kui sa ütled, et Jumal on Üks ja ei ole teist peale tema. ");
INSERT INTO ekk_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ja armastada teda kogu oma südamest ja kogu oma mõistmisest ja kogu oma jõust ning armastada ligimest nagu iseennast on palju tähtsam kui kõik põletusohvrid ja muud ohvrid.“ ");
INSERT INTO ekk_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ja Jeesus, nähes, et kirjatundja vastas arukalt, ütles talle: „Sa ei ole kaugel Jumala riigist.“ Ja keegi ei julgenud Jeesuselt enam midagi küsida. ");
INSERT INTO ekk_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Templis õpetades küsis Jeesus: „Miks kirjatundjad ütlevad, et Messias on Taaveti poeg? ");
INSERT INTO ekk_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Taavet ise ütles Pühas Vaimus rääkides: „Issand ütles minu Issandale: „Istu mu paremale käele, kuni ma panen sinu vaenlased su jalge alla.“ “ ");
INSERT INTO ekk_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Taavet ise nimetab teda Issandaks. Kuidas siis Messias saab olla Taaveti poeg?“ Ja suur rahvahulk kuulas Jeesust meeleldi. ");
INSERT INTO ekk_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ja ta ütles neid õpetades: „Hoiduge kirjatundjate eest! Neile meeldib ringi jalutada pikkades kuubedes ja saada aupaklikke tervitusi turuplatsidel, ");
INSERT INTO ekk_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","sünagoogides on neil kõige tähtsamad istekohad ja pidulaudades aukohad. ");
INSERT INTO ekk_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nad neelavad alla lesknaiste majad ja silmakirjaks peavad pikki palveid. Nad saavad seda rängema karistuse.“ ");
INSERT INTO ekk_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ohvrirahakirstu vastas istudes vaatas Jeesus, kuidas rahvas paneb sinna raha. Mitmed rikkad andsid palju. ");
INSERT INTO ekk_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Siis tuli üks vaene lesknaine ja pani kaks leptonit, see on ühe veeringu. ");
INSERT INTO ekk_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jeesus kutsus oma jüngrid enese juurde ja ütles neile: „Tõesti, ma ütlen teile, see vaene lesknaine pani rohkem kui ükski teine. ");
INSERT INTO ekk_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sest nemad panid oma küllusest, tema pani aga oma vaesusest kõik, mis tal oli, kogu oma elatise.“ ");
INSERT INTO ekk_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kui Jeesus oli templist lahkumas, ütles üks ta jüngreid talle: „Õpetaja, vaata, millised võimsad kivid ja millised vägevad hooned!“ ");
INSERT INTO ekk_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","„Kas sa imetled neid vägevaid hooneid?“ küsis Jeesus, „Siin ei jäeta kivi kivi peale, kõik kistakse maha!“ ");
INSERT INTO ekk_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kui Jeesus istus Õlimäel pühakoja vastas, küsisid Peetrus, Jaakobus, Johannes ja Andreas temalt omavahel olles: ");
INSERT INTO ekk_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","„Ütle meile, millal see kõik sünnib ja mis on tunnustäheks, kui kõik see hakkab täituma?“ ");
INSERT INTO ekk_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jeesus ütles neile: „Vaadake, et keegi teid ei eksitaks! ");
INSERT INTO ekk_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Paljud tulevad minu nimel, öeldes: „Mina olen tema!“ ja eksitavad paljusid. ");
INSERT INTO ekk_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Aga kui te kuulete sõdadest ja kuulujutte sõdadest, ärge heituge. Need asjad peavad sündima, kuid veel ei ole lõpp käes. ");
INSERT INTO ekk_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Sest rahvas tõuseb rahva vastu ja kuningriik kuningriigi vastu, paljudes paikades on maavärinaid ja näljahäda. See on sünnitusvalude algus. ");
INSERT INTO ekk_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Teie aga olge valvel! Minu pärast antakse teid ära võimude kätte ja teid pekstakse sünagoogides. Teil tuleb seista maavalitsejate ja kuningate ees, neile minust tunnistades. ");
INSERT INTO ekk_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kuid kõigile rahvaile peab enne kuulutatama evangeeliumi. ");
INSERT INTO ekk_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kui nad teid kinni võtavad ja kohtusse annavad, ärge muretsege ette, mida rääkida. Rääkige seda, mida teile antakse sel hetkel, sest teie pole rääkijad, vaid Püha Vaim. ");
INSERT INTO ekk_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Vend saadab surma venna ja isa lapse ning lapsed tõusevad vanemate vastu ja lasevad nad surmata. ");
INSERT INTO ekk_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Minu nime pärast olete te kõigi poolt vihatud, ent kes peab vastu lõpuni, see pääseb. ");
INSERT INTO ekk_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Aga kui te näete hävituse koletist seismas seal, kuhu ta ei kuulu – et lugeja mõistaks – siis need, kes on Juudamaal, põgenegu mägedesse. ");
INSERT INTO ekk_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kes on katusel, ärgu mingu majast midagi võtma, ");
INSERT INTO ekk_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ja kes on väljal, ärgu pöördugu tagasi võtma oma kuube! ");
INSERT INTO ekk_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Aga häda neile, kes on lapseootel, ja neile, kes imetavad sellel ajal! ");
INSERT INTO ekk_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Palvetage, et see ei juhtuks talvel, ");
INSERT INTO ekk_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","sest neil päevil on selline viletsus, millist ei ole olnud loomise algusest, Jumala loomistööst kuni praeguse ajani, ega tulegi enam. ");
INSERT INTO ekk_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ja kui Issand ei oleks seda aega lühendanud, siis ei pääseks ükski inimene. Aga väljavalitute pärast, keda tema on valinud, on ta neid päevi lühendanud. ");
INSERT INTO ekk_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ja kui sel ajal siis keegi teile ütleb: „Näe, Messias on siin!“ või „Vaata, ta on seal!“, siis ärge uskuge! ");
INSERT INTO ekk_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sest tõuseb valemessiaid ja valeprohveteid ja nad teevad tunnustähti ja imesid, et eksitada, kui võimalik, isegi valituid. ");
INSERT INTO ekk_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Teie olge valvel! Ma olen teile kõik ette öelnud! ");
INSERT INTO ekk_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Kuid neil päevil pärast seda viletsust „päike pimeneb ja kuu ei anna valgust ");
INSERT INTO ekk_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ning tähed kukuvad taevast ja taeva vägesid kõigutatakse.“ ");
INSERT INTO ekk_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ja sel ajal näevad rahvad Inimese Poega tulemas pilvedes suure väe ja kirkusega. ");
INSERT INTO ekk_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ja siis ta läkitab inglid ja kogub kokku oma valitud neljast ilmakaarest, maa äärest taeva ääreni. ");
INSERT INTO ekk_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ent õppige viigipuult! Kui selle okstele tärkavad võrsed ja ajavad lehti, siis te teate, et suvi on lähedal. ");
INSERT INTO ekk_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nõnda ka teie, kui te näete seda sündimas, siis teadke, et tema on lähedal, ukselävel! ");
INSERT INTO ekk_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tõesti, ma ütlen teile, see sugupõlv ei kao enne, kui kõik see on sündinud. ");
INSERT INTO ekk_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Taevas ja maa kaovad, kuid minu sõnad ei kao iial. ");
INSERT INTO ekk_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Seda päeva või tundi ei tea keegi, ei inglid taevas ega Poeg, vaid Isa üksi. ");
INSERT INTO ekk_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Olge valvel! Pange tähele! Te ei tea, millal see aeg on käes! ");
INSERT INTO ekk_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nii nagu inimene, kes läks reisile ja jättis oma maja, andes oma sulastele meelevalla, igaühele tema töö, ja käskis uksehoidjal valvata. ");
INSERT INTO ekk_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Seepärast valvake, sest teie ei tea, millal majaisand tuleb, kas õhtul, keskööl, kukelaulu ajal või varahommikul, ");
INSERT INTO ekk_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","et ta äkitselt tulles ei leiaks teid magamas. ");
INSERT INTO ekk_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Aga mida ma ütlen teile, ütlen kõigile: „Valvake!“ “ ");
INSERT INTO ekk_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kahe päeva pärast oli paasa- ja hapnemata leibade püha. Ülempreestrid ja kirjatundjad otsisid võimalust, kuidas Jeesust kavalusega kinni võtta ja tappa. ");
INSERT INTO ekk_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","„Teda ei saa kinni võtta keset pühi, sest rahvas hakkaks mässama!“ ütlesid nad. ");
INSERT INTO ekk_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jeesus oli Betaanias pidalitõvest paranenud Siimoni majas. Kui ta istus lauas, tuli naine, kellel oli alabasternõu puhta ja ülihinnalise nardisalviga. Ta murdis alabasternõu katki ja valas salvi Jeesusele pähe. ");
INSERT INTO ekk_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ent mõned nurisesid naise teo üle: „Milleks küll see raiskamine? ");
INSERT INTO ekk_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Selle salvi oleks võinud ju müüa rohkem kui kolmesaja teenari eest ja raha anda vaestele.“ Ja nad hurjutasid naist. ");
INSERT INTO ekk_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kuid Jeesus ütles: „Jätke ta rahule! Miks te tülitate teda? Ta on teinud mulle kauni teo. ");
INSERT INTO ekk_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Vaeseid on teie juures alati, ja te võite neile head teha millal tahes. Mind aga ei ole teil alati. ");
INSERT INTO ekk_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ta on teinud, mis ta võis: ta on ette võidnud mu ihu matmiseks. ");
INSERT INTO ekk_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tõesti, ma ütlen teile, kus iganes kogu maailmas evangeeliumi kuulutatakse, kõneldakse tema mälestuseks ka sellest, mida ta on teinud.“ ");
INSERT INTO ekk_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Aga Juudas Iskariot, üks neist kaheteistkümnest, läks ülempreestrite juurde, et teda neile reeta. ");
INSERT INTO ekk_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Seda kuuldes ülempreestrid rõõmustasid ja lubasid anda talle raha. Nüüd Juudas otsis võimalust, kuidas Jeesust reeta. ");
INSERT INTO ekk_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Hapnemata leibade püha esimesel päeval, kui paasatalle tapetakse, küsisid jüngrid Jeesuselt: „Kus sa tahad, et me sulle paasasöögi ette valmistaksime?“ ");
INSERT INTO ekk_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ta läkitas kaks oma jüngrit ja ütles neile: „Minge Jeruusalemma ja te kohtate veekannu kandvat meest. Järgnege talle, ");
INSERT INTO ekk_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ja kuhu ta ka sisse astub, selle maja peremehele öelge: „Õpetaja küsib: „Kus on mu külalistetuba, kus ma võiksin süüa paasat oma jüngritega?“ “ ");
INSERT INTO ekk_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tema näitab teile suurt tuba ülemisel korrusel, kus kõik on valmis seatud. Seal valmistage meile kõik ette.“ ");
INSERT INTO ekk_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jüngrid lahkusid ja läksid linna ning leidsid kõik täpselt nii, nagu Jeesus oli neile öelnud. Ja nad valmistasid paasasöögi. ");
INSERT INTO ekk_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Õhtu saabudes tuli Jeesus kaheteistkümne jüngriga. ");
INSERT INTO ekk_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kui nad lauas istusid ja sõid, ütles Jeesus: „Tõesti, ma ütlen teile, üks teie seast annab mu ära, üks, kes koos minuga sööb!“ ");
INSERT INTO ekk_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jüngrid muutusid väga murelikuks ja hakkasid üksteise järel temalt küsima: „Ega sa mind ei mõtle?“ ");
INSERT INTO ekk_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jeesus vastas neile: „Üks teist kaheteistkümnest, kes kastab oma leiva minuga samasse kaussi. ");
INSERT INTO ekk_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Inimese Poeg läheb küll ära, nõnda nagu tema kohta on kirjutatud, aga häda sellele inimesele, kes Inimese Poja ära annab! Talle oleks parem, kui ta ei oleks sündinud!“ ");
INSERT INTO ekk_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ja kui nad sõid, võttis Jeesus leiva, õnnistas, murdis ja andis neile ning ütles: „Võtke, see on minu ihu!“ ");
INSERT INTO ekk_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Siis ta võttis karika, tänas Jumalat ja andis selle neile, ja nad kõik jõid sellest. ");
INSERT INTO ekk_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jeesus ütles neile: „See on minu lepinguveri, mis valatakse paljude eest. ");
INSERT INTO ekk_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tõesti, ma ütlen teile, mina ei joo enam viinapuu viljast kuni selle päevani, mil ma joon uut Jumala riigis.“ ");
INSERT INTO ekk_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ja kui nad olid laulnud kiituslaulu, läksid nad välja Õlimäele. ");
INSERT INTO ekk_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jeesus ütles neile: „Te kõik hülgate minu, sest kirjutatud on: „Ma löön karjast ja karja lambad pillutatakse laiali.“ ");
INSERT INTO ekk_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kuid pärast minu ülesäratamist lähen ma teie ees Galileasse.“ ");
INSERT INTO ekk_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Aga Peetrus ütles talle: „Kui ka kõik sind hülgavad, siis ometi mitte mina!“ ");
INSERT INTO ekk_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","„Tõesti, ma ütlen sulle, täna, selsamal ööl, enne kui kukk kaks korda kireb, salgad sina mind kolm korda maha!“ vastas Jeesus. ");
INSERT INTO ekk_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ent Peetrus sõnas veel tungivamalt: „Kui ma ka peaksin koos sinuga surema, mina ei salga sind maha!“ Sama kinnitasid ka kõik teised. ");
INSERT INTO ekk_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nad tulid paika, mida kutsuti Ketsemaniks, ja Jeesus ütles oma jüngritele: „Istuge siin, kuni ma palvetan!“ ");
INSERT INTO ekk_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ta võttis enesega kaasa Peetruse, Jaakobuse ja Johannese. Jeesus langes sügavasse ahastusse ja vaeva. ");
INSERT INTO ekk_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ta ütles neile: „Mu hing on väga kurb surmani. Jääge siia ja valvake!“ ");
INSERT INTO ekk_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ta läks pisut eemale, heitis näoli maha ja palvetas, et kui on võimalik, siis see tund läheks temast mööda. ");
INSERT INTO ekk_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ta ütles: „Abba, Isa! Sinul on kõik võimalik! Võta see karikas minult ära! Kuid ärgu sündigu see, mida mina tahan, vaid mida sina tahad!“ ");
INSERT INTO ekk_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Siis Jeesus tuli tagasi jüngrite juurde ja leidis nad magamast. Ta sõnas Peetrusele: „Siimon, kas sa magad? Kas sa ei jaksa ühtki tundi valvata? ");
INSERT INTO ekk_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Valvake ja palvetage, et te ei satuks kiusatusse! Vaim on küll valmis, kuid liha on nõder.“ ");
INSERT INTO ekk_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ta läks uuesti eemale ja palvetas, lausudes samad sõnad. ");
INSERT INTO ekk_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tagasi tulles leidis ta jüngrid taas magamas, sest nende silmad olid rasked unest. Nad ei teadnud, mida talle vastata. ");
INSERT INTO ekk_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Siis tuli Jeesus kolmandat korda ja ütles neile: „Teie aina magate ja puhkate! Küllalt! Tund on saabunud, Inimese Poeg antakse patuste kätte! ");
INSERT INTO ekk_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tõuske üles, lähme! Mu äraandja on lähedal!“ ");
INSERT INTO ekk_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ja kui ta kõneles, saabuski Juudas, üks kaheteistkümnest. Ja ühes temaga ülempreestrite, kirjatundjate ja rahvavanemate saadetud, nuiade ja mõõkadega relvastatud jõuk. ");
INSERT INTO ekk_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jeesuse äraandja oli andnud neile märgi: „Tema on see, keda ma suudlen. Võtke ta kinni ja viige valve all ära!“ ");
INSERT INTO ekk_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ja Juudas tuli, astus kohe Jeesuse juurde ja sõnas: „Rabi!“ ning suudles teda tervituseks. ");
INSERT INTO ekk_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mehed haarasid Jeesusest ja võtsid ta kinni. ");
INSERT INTO ekk_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ent üks juuresolijaist tõmbas mõõga ja lõi ülempreestri sulast nõnda, et raius tal kõrva peast. ");
INSERT INTO ekk_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","„Kas ma juhin mässu,“ küsis Jeesus, „et te olete tulnud mind mõõkade ja nuiadega kinni võtma? ");
INSERT INTO ekk_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ma olin iga päev teiega templis õpetamas, ja te ei võtnud mind kinni! Aga Pühakiri peab täide minema!“ ");
INSERT INTO ekk_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kõik Jeesusega koos olnud põgenesid ja jätsid ta maha. ");
INSERT INTO ekk_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jeesusele järgnes keegi nooruk, kes kandis linast särki. Nad püüdsid teda kinni võtta, ");
INSERT INTO ekk_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","aga ta jättis särgi maha ja põgenes alasti. ");
INSERT INTO ekk_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nad viisid Jeesuse ülempreestri ette. Ja kõik ülempreestrid, rahvavanemad ja kirjatundjad tulid kokku. ");
INSERT INTO ekk_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peetrus järgnes Jeesusele eemalt, kuni jõudis ülempreestri sisehoovi. Ta istus koos valvuritega ja soojendas ennast tule ääres. ");
INSERT INTO ekk_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ülempreestrid ja kogu Suurkohus otsisid tunnistust Jeesuse surmamiseks, kuid ei leidnud. ");
INSERT INTO ekk_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Paljud küll tunnistasid valet tema vastu, kuid nende tunnistused olid vastuolus. ");
INSERT INTO ekk_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Siis tõusid püsti mõned, kes andsid tema vastu valetunnistuse: ");
INSERT INTO ekk_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","„Me oleme kuulnud teda ütlemas: „Mina kisun maha selle kätega tehtud templi ja ehitan kolme päevaga teise, mis ei ole kätega tehtud.“ “ ");
INSERT INTO ekk_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Aga ka selles ei läinud nende tunnistus kokku. ");
INSERT INTO ekk_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Siis ülempreester tõusis nende ees püsti ja küsis Jeesuselt: „Kas sa ei vasta midagi selle kohta, mida nad sinu vastu tunnistavad?“ ");
INSERT INTO ekk_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kuid Jeesus vaikis ega vastanud midagi. Taas küsis temalt ülempreester: „Kas sina oled Messias, Õnnistatu Poeg?“ ");
INSERT INTO ekk_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ja Jeesus vastas: „Mina olen. Ja te näete Inimese Poega istumas Kõigeväelise paremal käel ja tulemas taeva pilvede peal.“ ");
INSERT INTO ekk_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ülempreester käristas oma riided lõhki ja ütles: „Mis tunnistajaid meil veel vaja on? ");
INSERT INTO ekk_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Te olete ise kuulnud jumalateotust. Mis te arvate?“ Nad kõik otsustasid, et ta väärib surma. ");
INSERT INTO ekk_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Siis mõned hakkasid sülitama Jeesuse peale, katsid ta näo kinni, peksid teda rusikatega ning ütlesid talle: „Prohveteeri!“ Ja valvurid peksid teda. ");
INSERT INTO ekk_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peetrus oli all hoovis. Sinna tuli üks ülempreestri teenijatüdruk ");
INSERT INTO ekk_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ja, märganud Peetrust ennast soojendamas, vaatas teda tähelepanelikult. Ta ütles: „Sina olid ka selle Naatsaretlase, Jeesusega.“ ");
INSERT INTO ekk_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kuid Peetrus salgas: „Ma ei tea ega mõista, millest sa räägid!“ Ja läks sealt välja eeshoovi. ");
INSERT INTO ekk_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Teenijatüdruk nägi teda seal uuesti ja taas ütles Peetruse kohta: „See mees on üks nende hulgast!“ ");
INSERT INTO ekk_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Aga Peetrus salgas taas. Pisut hiljem sõnas keegi sealolijatest Peetrusele: „Tõesti, sina oled nende seast, sinagi oled ju galilealane.“ ");
INSERT INTO ekk_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Peetrus hakkas sajatama ja vanduma: „Ma ei tunne seda meest, kellest teie räägite!“ ");
INSERT INTO ekk_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ja kohe kires kukk teist korda. Siis Peetrusele meenusid sõnad, mida Jeesus oli talle öelnud: „Enne kui kukk kaks korda kireb, salgad sina mind kolm korda maha!“ Ja ta puhkes nutma. ");
INSERT INTO ekk_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Hommikul vara langetasid ülempreestrid koos vanemate ja kirjatundjate ja kogu Suurkohtuga otsuse. Nad sidusid Jeesuse kinni, viisid ta minema ja andsid Pilaatuse kätte. ");
INSERT INTO ekk_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilaatus küsis Jeesuselt: „Kas sina oled juutide kuningas?“ „Need on sinu sõnad!“ vastas Jeesus. ");
INSERT INTO ekk_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ülempreestrid süüdistasid teda paljus. ");
INSERT INTO ekk_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilaatus küsis Jeesuselt: „Kas sa midagi ei vasta? Kuula, kui paljudes asjades nad sind süüdistavad!“ ");
INSERT INTO ekk_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kuid Pilaatuse imestuseks ei vastanud Jeesus enam midagi. ");
INSERT INTO ekk_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Paasapühade ajal oli maavalitsejal tavaks vabastada üks vang, keda rahvas nõudis. ");
INSERT INTO ekk_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mees nimega Barabas oli vangis koos mässajatega, kes olid ülestõusu ajal toime pannud tapmise. ");
INSERT INTO ekk_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Rahvahulk tuli ja hakkas paluma, et Pilaatus teeks, nagu ta ikka oli teinud. ");
INSERT INTO ekk_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilaatus küsis: „Kas te tahate, et ma lasen teile vabaks juutide kuninga?“ ");
INSERT INTO ekk_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","teades, et ülempreestrid olid kadedusest Jeesuse tema kätte andnud. ");
INSERT INTO ekk_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ent ülempreestrid ässitasid rahvahulka nõudma, et ta pigem laseks neile vabaks Barabase. ");
INSERT INTO ekk_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilaatus küsis neilt veel kord: „Mis ma siis pean tegema temaga, keda te nimetate juutide kuningaks?“ ");
INSERT INTO ekk_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","„Löö ta risti!“ karjusid nad taas. ");
INSERT INTO ekk_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilaatus küsis neilt: „Mis ta kurja on teinud?“ Kuid rahvahulk karjus aina valjemini: „Löö ta risti!“ ");
INSERT INTO ekk_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ja Pilaatus, tahtes olla rahvale meelepärane, laskis neile vabaks Barabase. Ent Jeesust laskis piitsutada ja andis ta risti lüüa. ");
INSERT INTO ekk_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sõdurid juhatasid Jeesuse paleesse (see on pretooriumisse) ja kutsusid kokku terve väesalga. ");
INSERT INTO ekk_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ja nad riietasid ta purpurrüüga ja punusid kibuvitstest pärja ning panid temale pähe. ");
INSERT INTO ekk_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ja nad hakkasid teda teretama: „Tervitus, juutide kuningas!“ ");
INSERT INTO ekk_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nad tagusid talle pillirookepiga pähe, sülitasid ta peale ning kummardasid teda maha põlvitades. ");
INSERT INTO ekk_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ja kui nad olid teda küllalt mõnitanud, võtsid nad temalt purpurrüü seljast ja riietasid ta oma rõivastesse. Nad viisid Jeesuse välja ristilöömiseks. ");
INSERT INTO ekk_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Üks Küreene mees nimega Siimon, Aleksandrose ja Ruufuse isa, tuli just maalt linna ja oli parasjagu möödumas. Nad sundisid teda kandma Jeesuse risti. ");
INSERT INTO ekk_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ja nad viisid Jeesuse paika, mida hüüti Kolgataks (mis tähendab Pealuu koht). ");
INSERT INTO ekk_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Talle pakuti mürriga segatud veini, aga ta ei võtnud seda vastu. ");
INSERT INTO ekk_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nad lõid ta risti ja jagasid ta rõivad omavahel, heites liisku nende üle, kes mida saab. ");
INSERT INTO ekk_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Oli kolmas tund, kui nad Jeesuse risti lõid. ");
INSERT INTO ekk_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tema süütahvlilt võis lugeda: Juutide kuningas. ");
INSERT INTO ekk_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Koos temaga lõid nad risti kaks kurjategijat: ühe ta paremale ja teise vasakule käele. ");
INSERT INTO ekk_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nii läks täide kiri, mis ütleb: „Ta on ülekohtuste sekka arvatud.“ ");
INSERT INTO ekk_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Möödujad aga pilkasid teda päid vangutades: „Noh, templi lammutaja ja kolme päevaga üles ehitaja! ");
INSERT INTO ekk_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Päästa nüüd iseennast ja astu ristilt alla!“ ");
INSERT INTO ekk_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nõndasamuti pilkasid teda isekeskis ka ülempreestrid koos kirjatundjatega, üteldes: „Teisi on ta päästnud, aga iseennast ei suuda ta päästa! ");
INSERT INTO ekk_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Messias, Iisraeli kuningas, astugu nüüd ristilt alla, et me näeksime ja usuksime!“ Ka need, kes temaga koos olid risti löödud, pilkasid teda. ");
INSERT INTO ekk_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kuuendal tunnil langes pimedus üle kogu maa ja kestis üheksanda tunnini. ");
INSERT INTO ekk_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Üheksandal tunnil kisendas Jeesus valju häälega: „Eloii, eloii, lemaa sabahtani?“, see tähendab „Mu Jumal, mu Jumal, miks sa mu maha jätsid?“ ");
INSERT INTO ekk_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mõned juuresseisjaist ütlesid seda kuuldes: „Kuulete, ta hüüab Eelijat!“ ");
INSERT INTO ekk_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Siis jooksis keegi, immutas käsna veiniäädikaga, pistis selle pilliroo otsa ja pakkus talle juua, sõnades: „Vaatame, kas Eelija tuleb teda maha võtma!“ ");
INSERT INTO ekk_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Aga Jeesus kisendas valju häälega ja heitis hinge. ");
INSERT INTO ekk_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ja templi eesriie rebenes ülalt alla kaheks. ");
INSERT INTO ekk_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Aga Jeesuse vastas seisev sadakonna ülem, nähes teda nõnda suremas, ütles: „See inimene oli tõesti Jumala Poeg!“ ");
INSERT INTO ekk_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Aga seal oli ka naisi eemalt vaatamas, nende seas Maarja Magdaleena ning teine Maarja (Jaakobus Noorema ja Joosese ema) ning Saloome. ");
INSERT INTO ekk_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nad olid Jeesusele järgnenud ja tema eest hoolitsenud Galileast saadik. Seal oli veel mitmeid naisi, kes olid koos Jeesusega tulnud Jeruusalemma. ");
INSERT INTO ekk_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Õhtu oli kätte jõudmas ja käes oli pühade valmistuspäev, see on hingamispäevaeelne päev. ");
INSERT INTO ekk_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Siis tuli Joosep Arimaatiast, nõukogu lugupeetud liige, kes ka ise ootas Jumala riiki. Ta astus julgelt Pilaatuse juurde ning palus enesele Jeesuse surnukeha. ");
INSERT INTO ekk_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilaatus imestas, et Jeesus on juba surnud, ja kutsus enda juurde sadakonna ülema ning küsis temalt, kas Jeesus tõesti juba suri. ");
INSERT INTO ekk_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kui sadakonna ülem seda kinnitas, andis ta surnukeha Joosepile. ");
INSERT INTO ekk_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joosep ostis linase kanga, võttis Jeesuse ristilt maha, mähkis linasse ning asetas kaljusse raiutud hauda. Siis veeretas ta kivi hauakambri uksele. ");
INSERT INTO ekk_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Aga Maarja Magdaleena ja Joosese ema Maarja nägid, kuhu Jeesus pandi. ");
INSERT INTO ekk_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kui hingamispäev oli möödas, ostsid Maarja Magdaleena, Jaakobuse ema Maarja ja Saloome lõhnarohte, et tulla Jeesust võidma. ");
INSERT INTO ekk_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ja nädala esimesel päeval väga vara, kui päike oli just tõusmas, tulid nad haua juurde. ");
INSERT INTO ekk_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nad ütlesid üksteisele: „Kes küll veeretab meil kivi hauakambri ukse eest ära?“ ");
INSERT INTO ekk_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ja sinna vaadates nägid nad, et kivi oli ära veeretatud. Aga see oli väga suur kivi. ");
INSERT INTO ekk_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ja hauakambrisse sisenedes nägid nad paremal pool istumas noort meest, pikk valge rüü seljas. Naised kohkusid. ");
INSERT INTO ekk_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nooruk ütles neile: „Ärge kartke! Te otsite ristilöödud Naatsareti Jeesust. Ta on üles tõusnud! Teda ei ole siin! Vaadake, siin on paik, kuhu ta pandi! ");
INSERT INTO ekk_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ent minge öelge tema jüngritele ja Peetrusele, et ta läheb teie ees Galileasse. Seal te saate teda näha, nõnda nagu ta teile ütles.“ ");
INSERT INTO ekk_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Naised tulid välja ja põgenesid haua juurest hirmust värisedes ja segaduses. Nad ei öelnud kellelegi midagi, sest nad kartsid. ");
INSERT INTO ekk_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ja kui Jeesus nädala esimesel päeval vara oli surnuist üles tõusnud, ilmus ta esmalt Maarja Magdaleenale, kellest ta oli seitse kurja vaimu välja ajanud. ");
INSERT INTO ekk_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maarja läks ja kuulutas neile, kes olid käinud koos Jeesusega, nüüd aga leinasid ja nutsid. ");
INSERT INTO ekk_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ja nemad ei uskunud, kui said kuulda, et Jeesus elab, ja et Maarja Magdaleena oli teda elusana näinud. ");
INSERT INTO ekk_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pärast seda ilmus Jeesus teisel kujul kahele teekäijale nende seast, kes olid minemas maale. ");
INSERT INTO ekk_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ja need tulid tagasi ja kuulutasid teistele, aga nad ei uskunud neidki. ");
INSERT INTO ekk_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Viimaks ilmus Jeesus neile üheteistkümnele, kui nad lauas istusid. Ta noomis neid uskmatuse ja tõrksuse pärast, et nad ei olnud uskunud neid, kes olid teda näinud pärast ta ülesäratamist. ");
INSERT INTO ekk_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ja Jeesus ütles neile: „Minge kõike maailma ja kuulutage evangeeliumi kogu loodule! ");
INSERT INTO ekk_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kes usub ja on ristitud, see päästetakse, aga kes ei usu, mõistetakse hukka. ");
INSERT INTO ekk_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kuid uskujaid saadavad sellised tunnustähed: minu nimel ajavad nad välja kurje vaime ja räägivad uusi keeli. ");
INSERT INTO ekk_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nad tõstavad paljaste kätega üles mürkmadusid, ja kui nad mõnd surmavat mürki joovad, siis ei tee see neile kahju. Haigete peale nad panevad käed, ja need saavad terveks.“ ");
INSERT INTO ekk_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ja kui Issand Jeesus oli nendega rääkinud, võeti ta üles taevasse ja ta istus Jumala paremale käele. ");
INSERT INTO ekk_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Aga jüngrid läksid välja ja kuulutasid kõikjal, ning Issand töötas koos nendega ning kinnitas oma sõna tunnustähtedega.");
INSERT INTO ekk_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Juba mitmed on võtnud ette koostada ülevaadet neist asjust, mis meie seas on täide viidud, ");
INSERT INTO ekk_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","kooskõlas sellega, kuidas pealtnägijad ja sulased need on meile edasi andnud. ");
INSERT INTO ekk_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nõnda olen minagi otsustanud, kuna ma olen algusest peale kõik täpselt järele uurinud, kirjutada korralik ülevaade sulle, kõrgesti austatud Teofilos, ");
INSERT INTO ekk_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","et sa teaksid, kui usaldusväärne on sulle antud õpetus. ");
INSERT INTO ekk_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Juuda kuninga Heroodese ajal elas Sakariase nimeline preester, Abija teenistuskorrast. Tema naine oli Aaroni järeltulija ja naise nimi oli Eliisabet. ");
INSERT INTO ekk_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nad mõlemad olid õiged Jumala silmis, elades laitmatult kõigis Issanda käskudes ja korraldustes. ");
INSERT INTO ekk_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Aga neil ei olnud last, sest Eliisabet oli viljatu, ja nad mõlemad olid eakad. ");
INSERT INTO ekk_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kord aga, kui Sakarias oli oma teenistuskorra ajal preestritalituses Jumala ees, ");
INSERT INTO ekk_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","langes talle liisk minna preestrite kombe kohaselt Issanda templisse viirukit suitsutama. ");
INSERT INTO ekk_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ja kui viiruki suitsutamise aeg saabus, palvetas kokku tulnud rahvahulk väljas. ");
INSERT INTO ekk_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Siis ilmus talle Issanda ingel, seistes suitsutusaltari paremal pool. ");
INSERT INTO ekk_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Teda nähes Sakarias ehmus ja teda valdas hirm. ");
INSERT INTO ekk_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kuid ingel ütles talle: „Ära karda, Sakarias, sest su palvet on kuuldud. Su naine Eliisabet sünnitab sulle poja, ja sa paned talle nimeks Johannes. ");
INSERT INTO ekk_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Sul on temast rõõmu ja hõiskamist ning paljud rõõmustavad tema sündimisest, ");
INSERT INTO ekk_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","sest ta saab suureks Issanda silmis. Ta ei tohi juua veini ega teisi kääritatud jooke, ja ta täidetakse Püha Vaimuga juba enne sündimist emaihus. ");
INSERT INTO ekk_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ta pöörab palju Iisraeli rahvast tagasi Issanda, nende Jumala poole. ");
INSERT INTO ekk_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ta kõnnib Issanda ees Eelija vaimus ja väes, et pöörata vanemate südamed nende laste poole ja sõnakuulmatud õigete tarkusse, et valmistada rahvas ette Issanda jaoks.“ ");
INSERT INTO ekk_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakarias küsis inglilt: „Kuidas ma saan selles kindel olla? Ma olen juba vana mees ja mu nainegi on eakas.“ ");
INSERT INTO ekk_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ingel vastas talle: „Mina olen Gaabriel, kes seisab Jumala ees, ja mind on läkitatud sinuga rääkima ja kuulutama sulle seda rõõmusõnumit. ");
INSERT INTO ekk_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nüüdsest jääd sa tummaks ega saa rääkida päevani, mil need asjad sünnivad, sest sa ei uskunud mu sõnu, mis lähevad täide määratud ajal.“ ");
INSERT INTO ekk_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Samal ajal ootas rahvas Sakariast ja pani imeks, et ta nii kaua templis viibib. ");
INSERT INTO ekk_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kui ta lõpuks välja tuli, siis ei saanud ta nendega rääkida. Nad mõistsid, et ta oli templis näinud nägemust, sest ta viipas neile käega, kuid ei suutnud rääkida. ");
INSERT INTO ekk_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kui Sakariase teenistuskord läbi sai, läks ta koju. ");
INSERT INTO ekk_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mõne aja pärast jäi ta naine Eliisabet lapseootele ja tõmbus viieks kuuks üksindusse. Ta ütles: ");
INSERT INTO ekk_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","„Nõnda on Issand mulle neil päevil teinud, et ta näitas mulle oma soosingut ning võttis ära mu häbi inimeste ees.“ ");
INSERT INTO ekk_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kuue kuu pärast läkitas Jumal ingel Gaabrieli Naatsareti linna Galileas, ");
INSERT INTO ekk_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","neitsi juurde, kelle nimi oli Maarja. Maarja oli kihlatud Joosepiga, kes põlvnes Taaveti soost. ");
INSERT INTO ekk_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gaabriel läks tema juurde ja ütles: „Ole tervitatud, sa armuleidnu! Issand on sinuga!“ ");
INSERT INTO ekk_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maarja kohkus väga neist sõnadest ja mõtles, mida see tervitus võiks tähendada. ");
INSERT INTO ekk_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Aga ingel ütles talle: „Ära karda, Maarja, sest sa oled leidnud armu Jumala silmis! ");
INSERT INTO ekk_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Sa jääd lapseootele ja sünnitad poja ja paned talle nimeks Jeesus. ");
INSERT INTO ekk_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tema saab suureks ja teda kutsutakse Kõigekõrgema Pojaks ning Issand Jumal annab talle tema esiisa Taaveti trooni. ");
INSERT INTO ekk_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ta valitseb kuningana Jaakobi soo üle igavesti ning tema valitsus ei lõpe iialgi.“ ");
INSERT INTO ekk_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maarja küsis inglilt: „Kuidas see võimalik on, kui ma olen neitsi?“ ");
INSERT INTO ekk_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ingel vastas talle: „Püha Vaim tuleb sinu peale ja Kõigekõrgema vägi katab sind. Seepärast on laps, kes sinust sünnib, Püha, ja teda kutsutakse Jumala Pojaks. ");
INSERT INTO ekk_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Isegi su sugulane Eliisabet on pojaootel oma vanas eas ja see on kuues kuu temal, keda öeldi olevat viljatu. ");
INSERT INTO ekk_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Sest Jumala käes ei ole ükski asi võimatu.“ ");
INSERT INTO ekk_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maarja ütles: „Mina olen Issanda teenija, sündigu mulle nii, nagu sa ütlesid!“ Ja ingel läks tema juurest ära. ");
INSERT INTO ekk_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Neil päevil asus Maarja teele ja ruttas mäestikku Juuda linna. ");
INSERT INTO ekk_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ta läks Sakariase majja ja tervitas Eliisabetti. ");
INSERT INTO ekk_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kui Eliisabet kuulis Maarja tervitust, hüppas laps tema üsas ja Eliisabet sai täis Püha Vaimu. ");
INSERT INTO ekk_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ta hüüdis valju häälega: „Õnnistatud oled sina naiste seas ja õnnistatud on laps, keda sa kannad! ");
INSERT INTO ekk_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aga miks saab mulle osaks selline arm, et mu Issanda ema tuleb minu juurde? ");
INSERT INTO ekk_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Niipea kui su tervituse hääl mu kõrvu kostis, hüppas laps mu ihus rõõmu pärast. ");
INSERT INTO ekk_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Õnnistatud on see, kes on uskunud, et Issand täidab oma tõotused, mis ta on lubanud!“ ");
INSERT INTO ekk_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maarja ütles: „Mu hing ülistab Issandat ");
INSERT INTO ekk_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ja mu vaim hõiskab Jumalas, minu Päästjas, ");
INSERT INTO ekk_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","sest ta on pannud tähele oma sulase alandlikku olekut. Siitpeale hüüavad mind õnnistatuks kõik sugupõlved, ");
INSERT INTO ekk_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","sest mulle on suuri asju teinud Vägev. Tema nimi on püha, ");
INSERT INTO ekk_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","tema halastus ulatub nendeni, kes teda kardavad, sugupõlvest sugupõlveni. ");
INSERT INTO ekk_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ta on teinud vägevaid tegusid oma käega, ta on pillutanud laiali need, kes on uhked oma mõtetes. ");
INSERT INTO ekk_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ta on tõuganud maha valitsejad aujärgedelt ja ülendanud alandlikke. ");
INSERT INTO ekk_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Näljased on ta täitnud heade andidega, ent rikkad saatnud tühjalt minema. ");
INSERT INTO ekk_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ta on kandnud hoolt oma sulase Iisraeli eest, ja osutanud halastust, ");
INSERT INTO ekk_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","nõnda nagu ta on lubanud meie esivanematele, Aabrahamile ja tema järeltulijatele igavesti.“ ");
INSERT INTO ekk_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maarja jäi Eliisabeti juurde umbes kolmeks kuuks ja pöördus siis tagasi koju. ");
INSERT INTO ekk_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kui Eliisabetil tuli aeg sünnitada, tõi ta ilmale poja. ");
INSERT INTO ekk_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tema naabrid ja sugulased kuulsid, et Issand oli osutanud talle suurt halastust, ja nad rõõmustasid koos temaga. ");
INSERT INTO ekk_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nad tulid kaheksandal päeval lapse ümberlõikamisele ja tahtsid panna talle tema isa nime Sakarias. ");
INSERT INTO ekk_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kuid lapse ema ütles: „Ei, tema nimi peab olema Johannes!“ ");
INSERT INTO ekk_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nad ütlesid talle: „Su suguvõsas pole kedagi sellenimelist!“ ");
INSERT INTO ekk_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ja nad viipasid lapse isale, küsides, mis nime tema tahab lapsele panna. ");
INSERT INTO ekk_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakarias küsis tahvlit ning kirjutas kõigi imestuseks: „Tema nimi on Johannes!“ ");
INSERT INTO ekk_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Samal hetkel pääsesid ta keelepaelad valla ja ta hakkas rääkima, kiites Jumalat. ");
INSERT INTO ekk_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Aukartus valdas kõiki naabreid ja neist asjust räägiti kogu Juuda mägismaal. ");
INSERT INTO ekk_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kõik, kes sellest kuulsid, imestasid ja küsisid: „Mis küll saab sellest lapsest?“ Sest Issanda käsi oli temaga. ");
INSERT INTO ekk_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Lapse isa Sakarias sai täis Püha Vaimu ja prohveteeris: ");
INSERT INTO ekk_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","„Kiidetud olgu Issand, Iisraeli Jumal, et ta on tulnud oma rahva hulka ja nad lunastanud. ");
INSERT INTO ekk_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ta on meile üles tõstnud päästesarve oma sulase Taaveti soost, ");
INSERT INTO ekk_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","nagu ta on rääkinud ajastute algusest oma pühade prohvetite suu kaudu, ");
INSERT INTO ekk_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","pääste meie vaenlaste käest ja kõigi vihameeste käest, ");
INSERT INTO ekk_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","et armu anda meie vanematele ja pidada meeles oma püha lepingut, ");
INSERT INTO ekk_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","vannet, mille ta on vandunud meie esiisale Aabrahamile: ");
INSERT INTO ekk_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","päästa meid meie vaenlaste käest ja lubada meil teda kartmatult teenida ");
INSERT INTO ekk_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","pühaduses ja õigluses tema ees kõik meie elupäevad. ");
INSERT INTO ekk_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ja sind, minu laps, hüütakse Kõigekõrgema prohvetiks, sest sa lähed Issanda ees temale teed valmistama, ");
INSERT INTO ekk_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","et anda tema rahvale teada päästest nende pattude andeksandmises, ");
INSERT INTO ekk_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","meie Jumala südamliku halastuse läbi, millega meile tuleb päikesetõus taevast, ");
INSERT INTO ekk_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","et paista nende peale, kes elavad pimeduses ja surma varjus ja juhtida meie jalgu rahuteele.“ ");
INSERT INTO ekk_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Aga laps kasvas ja sai tugevaks vaimus. Ta elas kõrbes selle päevani, mil ta astus avalikult Iisraeli ette. ");
INSERT INTO ekk_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Neil päevil andis keiser Augustus käsu kirjutada üles kogu Rooma riigi rahvas. ");
INSERT INTO ekk_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","See oli esimene üleskirjutus, mis toimus ajal, kui Küreenius oli Süüria maavalitseja. ");
INSERT INTO ekk_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Igaüks läks enda kirjapanekuks oma sünnilinna. ");
INSERT INTO ekk_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nii läks ka Joosep Galileast Naatsareti linnast üles Juudamaale Taaveti linna, mida hüütakse Petlemmaks, sest ta oli Taaveti soost ja pärusmaalt. ");
INSERT INTO ekk_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ta läks sinna, et end kirja panna koos Maarjaga, oma kihlatuga, kes ootas last. ");
INSERT INTO ekk_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Seal olles saabus lapse sündimise aeg ning Maarja ");
INSERT INTO ekk_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","tõi ilmale oma esmasündinud poja. Ta mähkis lapse mähkmetesse ja asetas sõime, sest nende jaoks ei olnud majas enam kohta. ");
INSERT INTO ekk_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Seal olid karjased väljadel ja valvasid öösel oma karja. ");
INSERT INTO ekk_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Järsku ilmus neile Issanda ingel ja Issanda auhiilgus säras nende ümber ja nad olid hirmunud. ");
INSERT INTO ekk_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kuid ingel ütles neile: „Ärge kartke! Ma kuulutan teile head sõnumit, mis toob palju rõõmu kogu rahvale! ");
INSERT INTO ekk_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Teile on täna sündinud Taaveti linnas Päästja, kes on Messias, Issand. ");
INSERT INTO ekk_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ja see on teile tunnustäheks, et te leiate mähitud lapse sõimes magamas.“ ");
INSERT INTO ekk_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ühtäkki oli ingliga koos suur taevane väehulk Jumalat kiitmas: ");
INSERT INTO ekk_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","„Au olgu Jumalale kõrgeimas taevas ja maa peal rahu nendele, kelle peal on tema soosing!“ ");
INSERT INTO ekk_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kui inglid olid nende juurest läinud tagasi taevasse, ütlesid karjased üksteisele: „Mingem siis Petlemma ja vaadakem seda, mis on sündinud, mida Issand on meile teatanud!“ ");
INSERT INTO ekk_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nad läksid rutates ja leidsid Maarja ja Joosepi ja sõimes lebava lapse. ");
INSERT INTO ekk_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Seda nähes nad jutustasid, mida neile oli lapse kohta öeldud. ");
INSERT INTO ekk_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kõik, kes karjaste lugu kuulsid, panid seda imeks, ");
INSERT INTO ekk_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","aga Maarja talletas kõik need lood ning mõtiskles nende üle oma südames. ");
INSERT INTO ekk_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Karjased pöördusid tagasi, ülistades ja kiites Jumalat kõige eest, mida nad olid kuulnud ja näinud. Kõik oli olnud nii, nagu neile oli räägitud. ");
INSERT INTO ekk_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kaheksa päeva hiljem, kui laps ümber lõigati, pandi talle nimeks Jeesus – nimi, mille ingel oli andnud enne lapse eostamist. ");
INSERT INTO ekk_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kui Moosese Seaduses nõutud puhastuspäevad täis said, viisid Joosep ja Maarja lapse Jeruusalemma, et teda Issanda ette seada, ");
INSERT INTO ekk_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","nii nagu on Issanda Seaduses kirjutatud: „Iga esmasündinud poeg on pühitsetud Issandale.“ ");
INSERT INTO ekk_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ka tuli neil ohverdada paar turteltuvi või kaks tuvipoega, nii nagu Issanda Seaduses on öeldud. ");
INSERT INTO ekk_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jeruusalemmas oli mees nimega Siimeon. Ta oli õiglane ja vaga ning ootas Iisraeli lohutust, ja Püha Vaim oli tema peal. ");
INSERT INTO ekk_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Püha Vaim oli talle ilmutanud, et ta ei sure enne, kui on näinud Issanda Messiat. ");
INSERT INTO ekk_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Siimeon tuli Vaimu ajel templisse, ja kui Jeesuse vanemad tõid lapse sinna, et toimida temaga nii, nagu Seadus nõudis, ");
INSERT INTO ekk_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","võttis ta lapse sülle, kiitis Jumalat ja ütles: ");
INSERT INTO ekk_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","„Issand, nagu sa oled lubanud, võid sa nüüd lasta oma sulasel rahus minna, ");
INSERT INTO ekk_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","sest mu silmad on näinud sinu päästet, ");
INSERT INTO ekk_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","mille sa oled valmistanud kõikidele rahvastele: ");
INSERT INTO ekk_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","valgust, mis ilmub uskmatutele, ja auhiilgust sinu Iisraeli rahvale.“ ");
INSERT INTO ekk_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jeesuse isa ja ema panid imeks, mida lapse kohta räägiti. ");
INSERT INTO ekk_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Siimeon õnnistas neid ja ütles Maarjale, ta emale: „Vaata, see laps on seatud languseks ja tõusuks paljudele Iisraelis ja tunnustäheks, mille vastu räägitakse, ");
INSERT INTO ekk_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","et saaksid avalikuks paljude südamete mõtted. Ja mõõk läbistab ka sinu enda hinge.“ ");
INSERT INTO ekk_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Seal oli ka prohvet Anna, Aaseri suguharust pärit Penueli tütar. Ta oli kõrges eas; ta oli elanud oma mehega seitse aastat pärast abiellumist ");
INSERT INTO ekk_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ja oli nüüd kaheksakümne nelja aastane lesk. Ta ei lahkunud kunagi templist, vaid ülistas Jumalat ööd ja päevad paastumise ja palvetamisega. ");
INSERT INTO ekk_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Just sel ajal tuli ta sinna ja kiitis Jumalat ning kõneles Jeesusest kõigile, kes ootasid Jeruusalemma lunastust. ");
INSERT INTO ekk_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kui Joosep ja Maarja olid täitnud kõik, mida Issanda Seadus nõuab, pöördusid nad tagasi Galileasse, oma kodulinna Naatsaretti. ");
INSERT INTO ekk_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Laps kasvas, sai tugevaks ja täitus tarkusega. Jumala arm oli tema peal. ");
INSERT INTO ekk_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jeesuse vanemad läksid igal aastal paasapühadeks Jeruusalemma. ");
INSERT INTO ekk_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kui ta oli saanud kaheteistkümneaastaseks, läksid nad sinna pühadeaja kombe järgi üheskoos. ");
INSERT INTO ekk_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pärast pühi, kui tema vanemad läksid tagasi koju, oli poiss Jeesus jäänud vanemate teadmata Jeruusalemma. ");
INSERT INTO ekk_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Arvates ta olevat teekaaslaste hulgas, käisid nad ära ühe päeva tee ning hakkasid alles siis teda sugulaste ja tuttavate juurest otsima. ");
INSERT INTO ekk_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ja kui nad Jeesust ei leidnud, pöördusid nad teda otsides tagasi Jeruusalemma. ");
INSERT INTO ekk_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kolme päeva pärast leidsid nad Jeesuse templis istumas õpetajate keskel neid kuulamas ja küsimusi esitamas. ");
INSERT INTO ekk_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kõik, kes teda kuulsid, olid hämmastunud tema arusaamisest ja vastustest. ");
INSERT INTO ekk_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jeesuse vanemad olid teda nähes jahmunud ning ta ema ütles talle: „Poeg, miks sa oled meile nõnda teinud? Su isa ja mina oleme sind suure ahastusega otsinud.“ ");
INSERT INTO ekk_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kuid tema vastas neile: „Miks te olete mind otsinud? Kas te siis ei teadnud, et ma pean olema oma Isa majas?“ ");
INSERT INTO ekk_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kuid nad ei saanud aru, mida ta tahtis neile öelda. ");
INSERT INTO ekk_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jeesus läks koos nendega alla Naatsaretti ning oli neile kuulekas. Kuid ta ema talletas kõik need lood oma südames. ");
INSERT INTO ekk_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ja Jeesus kasvas tarkuses ja pikkuses ning leidis soosingut Jumala ja inimeste juures. ");
INSERT INTO ekk_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Oli keiser Tiberiuse viieteistkümnes valitsusaasta. Pontius Pilaatus oli Juudamaa maavalitseja ja Heroodes Galilea nelivürst, tema vend Filippus Iturea ja Trakoniitise nelivürst ja Lüsaanias Abileene nelivürst ");
INSERT INTO ekk_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ning ülempreestrid olid Hannas ja Kaifas. Sel ajal tuli Jumala sõna kõrbes Sakariase pojale Johannesele. ");
INSERT INTO ekk_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ta käis läbi kogu Jordani ümbruskonna ja kuulutas meeleparandusristimist pattude andeksandmiseks. ");
INSERT INTO ekk_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nõnda nagu on kirjutatud prohvet Jesaja sõnade raamatusse: „Hüüdja hääl on kõrbes: „Valmistage Issandale tee, tehke tasaseks tema teerajad! ");
INSERT INTO ekk_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kõik orud täidetagu ning kõik mäed ja kingud tasandatagu, kõverad teed saagu sirgeks ja konarlikud rajad tasaseks. ");
INSERT INTO ekk_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ja kõik inimesed saavad näha Jumala päästet.“ “ ");
INSERT INTO ekk_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Johannes ütles nüüd rahvale, kes oli tulnud, et lasta ennast temal ristida: „Rästikute sugu, kes teile andis märku põgeneda saabuva viha eest? ");
INSERT INTO ekk_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Seepärast kandke meeleparandusele kohast vilja ja ärge hakake endamisi ütlema: „Meie isa on Aabraham!“ Sest ma ütlen teile, Jumal võib nendest kividest äratada lapsi Aabrahamile. ");
INSERT INTO ekk_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kirves on ka juba pandud puude juurte külge. Iga puu, mis ei kanna head vilja, raiutakse maha ja visatakse tulle.“ ");
INSERT INTO ekk_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Inimesed küsisid Johanneselt: „Mida me siis peame tegema?“ ");
INSERT INTO ekk_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ta vastas: „Kellel on kaks särki, andku sellele, kellel ei ole, ning kellel on toitu, tehku samuti.“ ");
INSERT INTO ekk_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Isegi maksukogujaid tuli, et lasta ennast ristida. Nad küsisid: „Õpetaja, mida me peame tegema?“ ");
INSERT INTO ekk_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Johannes ütles neile: „Ärge võtke rohkem, kui teile on määratud!“ ");
INSERT INTO ekk_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ja temalt küsisid ka sõdurid: „Ja meie, mida meie peame tegema?“ Ta vastas neile: „Ärge pressige raha välja ja ärge süüdistage inimesi alusetult, olge rahul oma palgaga!“ ");
INSERT INTO ekk_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Rahvas oli täis ootust ja kõik arvasid oma südames, et ehk Johannes ongi Messias. ");
INSERT INTO ekk_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Siis vastas ta kõikidele: „Mina ristin teid veega, kuid tuleb minust vägevam, kelle sandaalegi ma pole väärt lahti siduma. Tema ristib teid Püha Vaimu ja tulega. ");
INSERT INTO ekk_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tal on tuulamiskühvel käes ja ta teeb puhtaks oma rehealuse. Ta kogub nisu aita, aga aganad ta põletab ära kustumatu tulega.“ ");
INSERT INTO ekk_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ja veel paljude muude sõnadega manitses Johannes inimesi ja kuulutas neile head sõnumit. ");
INSERT INTO ekk_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aga kui nelivürst Heroodes sai Johannese käest noomida oma venna Filippuse naise Heroodiase ja kõige muu kurja pärast, mida ta oli teinud, ");
INSERT INTO ekk_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","tegi Heroodes veel sedagi, et pani Johannese vangi. ");
INSERT INTO ekk_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kui kogu rahvast ristiti, siis ristiti ka Jeesus. Ja kui ta palvetas, avanes taevas ");
INSERT INTO ekk_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ja Püha Vaim laskus tema peale ihulikul kujul kui tuvi. Ja taevast kostis hääl: „Sina oled minu Poeg, keda ma armastan, sinu üle on mul hea meel!“ ");
INSERT INTO ekk_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jeesus oli oma tegevust alustades umbes kolmkümmend aastat vana. Ta oli – nagu arvati – Joosepi poeg, Joosep oli Eeli poeg, ");
INSERT INTO ekk_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","tema oli Mattati, tema oli Leevi, tema oli Melki, tema oli Jannai, tema oli Joosepi, ");
INSERT INTO ekk_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","tema oli Mattitjahu, tema oli Aamose, tema oli Nahumi, tema oli Hesli, tema oli Naggai, ");
INSERT INTO ekk_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","tema oli Mahati, tema oli Mattitjahu, tema oli Simei, tema oli Jooseki, tema oli Jooda, ");
INSERT INTO ekk_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","tema oli Joohanani, tema oli Reesa, tema oli Serubbaabeli, tema oli Sealtieli, tema oli Neeri, ");
INSERT INTO ekk_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","tema oli Melki, tema oli Addi, tema oli Koosami, tema oli Elmadami, tema oli Eeri, ");
INSERT INTO ekk_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","tema oli Jeesuse, tema oli Elieseri, tema oli Joorimi, tema oli Mattati, tema oli Leevi, ");
INSERT INTO ekk_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","tema oli Siimeoni, tema oli Juuda, tema oli Joosepi, tema oli Joonami, tema oli Eljakimi, ");
INSERT INTO ekk_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","tema oli Melea, tema oli Menna, tema oli Mattata, tema oli Naatani, tema oli Taaveti, ");
INSERT INTO ekk_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","tema oli Iisai, tema oli Oobedi, tema oli Boase, tema oli Salma, tema oli Nahsoni, ");
INSERT INTO ekk_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","tema oli Amminadabi, tema oli Raami, tema oli Hesroni, tema oli Peretsi, tema oli Juuda, ");
INSERT INTO ekk_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","tema oli Jaakobi, tema oli Iisaki, tema oli Aabrahami, tema oli Terahi, tema oli Naahori, ");
INSERT INTO ekk_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","tema oli Serugi, tema oli Reu, tema oli Pelegi, tema oli Eeberi, tema oli Selahi, ");
INSERT INTO ekk_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","tema oli Keenani, tema oli Arpaksadi, tema oli Seemi, tema oli Noa, tema oli Lemeki, ");
INSERT INTO ekk_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","tema oli Metuusala, tema oli Eenoki, tema oli Jeredi, tema oli Mahalaleli, tema oli Keenani, ");
INSERT INTO ekk_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","tema oli Enose, tema oli Seti, tema oli Aadama, tema oli Jumala poeg. ");
INSERT INTO ekk_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jeesus, täis Püha Vaimu, tuli tagasi Jordani äärest ja Vaim viis ta kõrbe, ");
INSERT INTO ekk_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","kus kurat teda nelikümmend päeva kiusas. Ta ei söönud midagi neil päevil ja kui see aeg oli möödunud, tundis ta nälga. ");
INSERT INTO ekk_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ja kurat ütles talle: „Kui sa oled Jumala Poeg, siis käsi sellel kivil siin muutuda leivaks.“ ");
INSERT INTO ekk_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jeesus vastas talle: „Kirjutatud on: „Inimene ei ela üksnes leivast.“ “ ");
INSERT INTO ekk_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Siis viis kurat Jeesuse kõrgele ja näitas talle ühe hetkega kõiki maailma kuningriike ");
INSERT INTO ekk_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ning ütles: „Ma annan sulle meelevalla kõigi nende üle ning nende hiilguse, sest see on minu kätte antud ja mina võin selle anda, kellele ma tahan. ");
INSERT INTO ekk_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kui sa ülistad mind, siis on see kõik sinu päralt.“ ");
INSERT INTO ekk_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jeesus vastas talle: „Kirjutatud on: „Kummarda Issandat, oma Jumalat, ja teeni ainult teda!“ “ ");
INSERT INTO ekk_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Seejärel viis kurat Jeesuse Jeruusalemma, pani ta seisma templi katusele ja ütles: „Kui sa oled Jumala Poeg, siis kukuta end siit alla. ");
INSERT INTO ekk_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Sest kirjutatud on: „Sinu pärast ta käsib oma ingleid, et nad sind hoiaksid. ");
INSERT INTO ekk_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nad kannavad sind kätel, et sa oma jalga vastu kivi ei lööks.“ “ ");
INSERT INTO ekk_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kuid Jeesus vastas talle: „On öeldud: „Ära pane Issandat, oma Jumalat, proovile!“ “ ");
INSERT INTO ekk_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kui kurat oli kiusamise lõpetanud, jättis ta Jeesuse mõneks ajaks rahule. ");
INSERT INTO ekk_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jeesus tuli Vaimu väes tagasi Galileasse ja kuuldus temast levis kogu ümbruskonnas. ");
INSERT INTO ekk_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ta õpetas nende sünagoogides, ja kõik tunnustasid teda. ");
INSERT INTO ekk_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jeesus suundus Naatsaretti, kus ta oli üles kasvanud, ja läks nagu tavaliselt hingamispäeval sünagoogi. Ja kui ta tõusis lugema, ");
INSERT INTO ekk_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","anti prohvet Jesaja raamat tema kätte. Ta avas rullraamatu ja leidis koha, kuhu oli kirjutatud: ");
INSERT INTO ekk_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","„Issanda Vaim on minu peal, sellepärast on ta mind võidnud kuulutama vaestele rõõmusõnumit. Ta on läkitanud mind kuulutama vangidele vabakslaskmist ja pimedatele nägemist, laskma vabadusse rõhutuid, ");
INSERT INTO ekk_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kuulutama Issanda meelepärast aastat.“ ");
INSERT INTO ekk_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ja keeranud rullraamatu kokku, andis Jeesus selle sünagoogi teenri kätte ja istus maha. Nüüd vaatasid sünagoogis kõik teda üksisilmi. ");
INSERT INTO ekk_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ta hakkas neile rääkima: „Täna on see kirjakoht teie kuuldes täide läinud.“ ");
INSERT INTO ekk_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kõik tunnustasid teda ja imestasid, et tema suust tulid sellised armulikud sõnad, ning ütlesid: „Eks tema ole Joosepi poeg?“ ");
INSERT INTO ekk_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kuid ta sõnas neile: „Kindlasti te tuletate mulle meelde vanasõna „Arst, aita iseennast!“. Ja ütlete: „Tee seda ka siin, oma kodukohas, mida oleme kuulnud sündivat Kapernaumas!“ “ ");
INSERT INTO ekk_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jeesus jätkas: „Tõesti, ma ütlen teile: ükski prohvet ei ole tunnustatud oma kodukohas. ");
INSERT INTO ekk_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kuid tõepoolest, ma kinnitan teile, palju lesknaisi oli Iisraelis Eelija päevil, kui taevas oli suletud kolm aastat ja kuus kuud, nii et kogu maale tuli suur nälg. ");
INSERT INTO ekk_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ometi ei saadetud Eelijat kellegi juurde nende hulgast, vaid Sareptasse Siidonimaal ühe lesknaise juurde. ");
INSERT INTO ekk_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ja palju pidalitõbiseid oli Iisraelis prohvet Eliisa ajal, kuid keegi neist ei saanud puhtaks, vaid hoopis süürlane Naaman.“ ");
INSERT INTO ekk_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Seda kuuldes läksid raevu kõik sünagoogis viibijad, ");
INSERT INTO ekk_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","tõusid püsti ja kihutasid Jeesuse linnast välja. Nad viisid ta üles mäeseljale, mille peale oli ehitatud nende linn, et teda järsakust alla tõugata. ");
INSERT INTO ekk_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ent Jeesus kõndis rahvahulgast läbi ja läks oma teed. ");
INSERT INTO ekk_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jeesus läks alla Kapernauma Galilea linna. Ta õpetas seal hingamispäeviti ");
INSERT INTO ekk_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ja nad olid vapustatud tema õpetusest, sest tema sõnadel oli meelevald. ");
INSERT INTO ekk_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Sünagoogis oli mees, kellel oli kuri vaim. See kisendas valju häälega: ");
INSERT INTO ekk_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","„Mine minema! Mis on meil asja sinuga, Naatsareti Jeesus? Kas sa oled tulnud meid hävitama? Ma tean küll, kes sa oled – Jumala Püha!“ ");
INSERT INTO ekk_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jeesus sõitles teda: „Jää vait ja mine temast välja!“ Siis kuri vaim paiskas mehe nende keskele maha ja läks temast välja ega teinud talle midagi viga. ");
INSERT INTO ekk_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ühtäkki olid kõik hämmastunud ja ärevil ning rääkisid omavahel: „Mida see veel tähendab? Ta käsutab meelevalla ja väega rüvedaid vaime, ja need lähevadki välja!“ ");
INSERT INTO ekk_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kuuldus temast levis kogu ümbruskonnas. ");
INSERT INTO ekk_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Aga Jeesus tõusis, lahkus sünagoogist ja tuli Siimoni majja. Siimoni ämm oli kõrges palavikus, ja nad palusid Jeesust teda aidata. ");
INSERT INTO ekk_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jeesus astus ta peatsi juurde, sõitles palavikku ning see lahkus temast. Naine tõusis otsekohe üles ja kattis neile laua. ");
INSERT INTO ekk_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Päikeseloojangul toodi kõik need, kellel olid mitmesugused haigused, Jeesuse juurde. Ta pani oma käed neist igaühe peale ja tegi nad terveks. ");
INSERT INTO ekk_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ka kurjad vaimud läksid paljudest välja, ise kisendades: „Sina oled Jumala Poeg!“ Jeesus sõitles kurje vaime ja keelas neil rääkida, sest nad teadsid, et tema on Messias. ");
INSERT INTO ekk_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Päeva hakul Jeesus väljus ja läks tühermaale. Inimesed otsisid teda, ja kui nad tema juurde jõudsid, püüdsid nad teda kinni pidada, et ta nende juurest ära ei läheks. ");
INSERT INTO ekk_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Aga tema ütles neile: „Ma pean ka teistele linnadele kuulutama evangeeliumi Jumala riigist, sest selleks on mind läkitatud.“ ");
INSERT INTO ekk_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ja ta jätkas kuulutamist Juudamaa sünagoogides. ");
INSERT INTO ekk_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kord, kui Jeesus seisis Genneesareti järve ääres, kogunes rahvas tema ümber ja kuulas Jumala sõna. ");
INSERT INTO ekk_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ta nägi kaht paati kaldaserval, mille olid sinna jätnud kalamehed, kes ise võrke pesid. ");
INSERT INTO ekk_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ta astus paati, mis kuulus Siimonile, ja palus teda kaldast pisut eemale sõuda. Ning ta istus ja õpetas rahvast paadist. ");
INSERT INTO ekk_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kui ta lõpetas kõnelemise, sõnas ta Siimonile: „Sõua sügavasse vette, lase oma võrgud sisse ja vaata, kas näkkab!“ ");
INSERT INTO ekk_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Siimon vastas talle: „Õpetaja, me oleme terve öö rüganud ega ole midagi saanud! Aga sinu sõna peale ma lasen võrgud vette.“ ");
INSERT INTO ekk_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kui nad olid seda teinud, said nad nii suure hulga kalu, et nende võrgud rebenesid. ");
INSERT INTO ekk_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nad viipasid oma kaasosanikele teises paadis, et nad tuleksid neile appi. Nad tulid ja täitsid mõlemad paadid, nii et need hakkasid vajuma. ");
INSERT INTO ekk_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kui Siimon Peetrus seda nägi, langes ta Jeesuse jalge ette ja ütles: „Mine minu juurest ära, Issand, sest ma olen patune mees!“ ");
INSERT INTO ekk_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Sest tema ja kõik ta kaaslased olid hämmastunud kalasaagist, mis nad olid püüdnud, ");
INSERT INTO ekk_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ja samamoodi olid Sebedeuse pojad Johannes ja Jaakobus, kes olid Siimoni kaasosanikud. Jeesus ütles Siimonile: „Ära karda! Nüüdsest peale hakkad sa püüdma inimesi!“ ");
INSERT INTO ekk_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ja nii nad tõmbasid paadid kaldale, jätsid kõik maha ja järgnesid talle. ");
INSERT INTO ekk_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kui Jeesus viibis ühes linnas, tuli nende lähedale pidalitõbine mees. Jeesust nähes langes ta silmili maha ja anus teda: „Issand, kui sa tahad, siis sa võid mu puhtaks teha!“ ");
INSERT INTO ekk_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jeesus sirutas käe, puudutas teda ja ütles: „Ma tahan, saa puhtaks!“ Kohe lahkus pidalitõbi mehest. ");
INSERT INTO ekk_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jeesus keelas teda juhtunust kellelegi rääkimast ja ütles: „Mine, näita ennast preestrile ja ohverda puhtakssaamise eest, mis Mooses on käskinud, neile tunnistuseks!“ ");
INSERT INTO ekk_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ent sõnum Jeesusest levis seda enam ning suur rahvahulk tuli kokku teda kuulama ja oma haigustest terveks saama. ");
INSERT INTO ekk_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kuid Jeesus tõmbus tihti üksildastesse paikadesse palvetama. ");
INSERT INTO ekk_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ühel päeval oli Jeesus õpetamas ja seal istusid ka variserid ja kirjatundjad. Nad olid tulnud igast Galilea ja Juudamaa külast ning Jeruusalemmast. Ja Issanda vägi oli Jeesuse peal haigete tervendamiseks. ");
INSERT INTO ekk_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mõned mehed kandsid magamisasemel halvatut ja püüdsid teda viia majja, et Jeesuse ette asetada. ");
INSERT INTO ekk_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ja kui nad rahvahulga pärast ei leidnud selleks võimalust, läksid nad üles katusele, võtsid ära osa katusekive ning lasksid ta asemel alla rahva keskele otse Jeesuse ette. ");
INSERT INTO ekk_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nende usku nähes ütles Jeesus: „Sõber, sinu patud on sulle andeks antud!“ ");
INSERT INTO ekk_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Seepeale mõtlesid kirjatundjad ja variserid: „Kes see selline küll on, kes räägib Jumalat teotades? Kes muu saab patte andeks anda kui vaid Jumal üksi?“ ");
INSERT INTO ekk_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jeesus teadis, mida nad mõtlesid, ja küsis: „Miks te mõtlete selliseid asju oma südames? ");
INSERT INTO ekk_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kumb on kergem, kas öelda „Sinu patud on sulle andeks antud“ või „Tõuse üles ja kõnni“? ");
INSERT INTO ekk_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Aga teadke, et Inimese Pojal on meelevald patte andeks anda maa peal.“ Ta sõnas halvatule: „Sulle ma ütlen: tõuse üles, võta oma ase ja mine koju!“ ");
INSERT INTO ekk_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kohe tõusis mees üles nende nähes, võttis oma magamisaseme ja läks koju Jumalat ülistades. ");
INSERT INTO ekk_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kõiki valdas hämmastus ja nad ülistasid Jumalat. Aukartlikult ütlesid nad: „Me oleme täna imelisi asju näinud!“ ");
INSERT INTO ekk_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pärast seda läks Jeesus välja ja nägi maksukogujat, nimega Leevi, istumas maksukoguja pingil. Jeesus ütles talle: „Järgne mulle!“ ");
INSERT INTO ekk_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ja Leevi tõusis, jättis kõik maha ja järgnes talle. ");
INSERT INTO ekk_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Leevi tegi Jeesusele oma kodus suure pidusöögi. Lauas oli nendega koos palju maksukogujaid ja hulk teisigi. ");
INSERT INTO ekk_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Variserid ja kirjatundjad, kes nende hulka kuulusid, pahandasid Jeesuse jüngritega: „Miks te sööte ja joote koos maksukogujate ja patustega?“ ");
INSERT INTO ekk_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jeesus vastas neile: „Arsti ei vaja terved, vaid haiged. ");
INSERT INTO ekk_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ma ei ole tulnud kutsuma õigeid, vaid patuseid meeleparandusele.“ ");
INSERT INTO ekk_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nemad aga ütlesid Jeesusele: „Johannese jüngrid paastuvad sageli ja palvetavad, samuti ka variseride jüngrid, kuid sinu omad söövad ja joovad!“ ");
INSERT INTO ekk_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jeesus vastas neile: „Kas te saate peigmehe sõpru panna paastuma ajal, kui peigmees on nendega? ");
INSERT INTO ekk_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tuleb aeg, mil peigmees võetakse neilt ära, küll nad siis paastuvad.“ ");
INSERT INTO ekk_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ta rääkis neile ka selle tähendamissõna: „Keegi ei rebi tükki uue rõiva küljest, et paigata vana, muidu see käristab ka uue katki ning paik uue küljest ei sobi vanale rõivale. ");
INSERT INTO ekk_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ja keegi ei vala värsket veini vanadesse nahklähkritesse, muidu värske vein rebestab lähkrid lõhki ja voolab maha ning lähkrid muutuvad kõlbmatuks. ");
INSERT INTO ekk_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Värske vein tuleb valada ikka uutesse lähkritesse. ");
INSERT INTO ekk_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ja keegi, kes on joonud vana veini, ei soovi uut, vaid ütleb: „Vana on parem!“ “ ");
INSERT INTO ekk_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ühel hingamispäeval, kui Jeesus läks läbi viljapõldude, katkusid ta jüngrid viljapäid, hõõrusid neid käte vahel ja sõid. ");
INSERT INTO ekk_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ent mõned variserid küsisid: „Miks te teete seda, mida ei tohi teha hingamispäeval?“ ");
INSERT INTO ekk_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jeesus vastas neile: „Kas te ei ole lugenud, mida tegi Taavet, kui temal ja ta kaaslastel oli nälg? ");
INSERT INTO ekk_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kuidas ta läks Jumala kotta ja võttis ohvrileibu, sõi ja andis oma meestele, ehkki neid ei ole lubatud süüa kellelgi peale preestrite?“ ");
INSERT INTO ekk_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jeesus ütles neile: „Inimese Poeg on hingamispäeva Issand!“ ");
INSERT INTO ekk_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ühel teisel hingamispäeval, kui Jeesus oli läinud sünagoogi ja õpetas, juhtus seal olema mees, kelle parem käsi oli kärbunud. ");
INSERT INTO ekk_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kirjatundjad ja variserid otsisid põhjust, et Jeesust süüdistada, ja nõnda nad jälgisid, kas ta tervendab hingamispäeval. ");
INSERT INTO ekk_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jeesus teadis nende mõtteid. Ta lausus mehele, kellel oli kärbunud käsi: „Tõuse püsti ja seisa meie ette!“ Ta tõusis ja jäi seisma. ");
INSERT INTO ekk_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jeesus ütles neile: „Ma küsin teilt, mida on hingamispäeval lubatud teha: head või halba, päästa elu või see hävitada?“ ");
INSERT INTO ekk_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ta vaatas neist igaühele otsa ja ütles mehele: „Siruta oma käsi!“ Mees tegi seda ja ta käsi sai täiesti terveks. ");
INSERT INTO ekk_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kirjatundjad ja variserid läksid aga raevu ja hakkasid arutama, mida nad võiksid Jeesusele teha. ");
INSERT INTO ekk_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mõni aeg hiljem läks Jeesus mäele palvetama ja veetis kogu öö Jumalat paludes. ");
INSERT INTO ekk_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Päeva saabudes kutsus ta jüngrid enese juurde ja valis nende hulgast kaksteist, keda ta määras ka apostliteks. Need olid: ");
INSERT INTO ekk_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Siimon, keda ta nimetas Peetruseks, tema vend Andreas, Jaakobus, Johannes, Filippus, Bartolomeus, ");
INSERT INTO ekk_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matteus, Toomas, Jaakobus, Alfeuse poeg, Siimon, keda kutsutakse Selooteseks, ");
INSERT INTO ekk_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Juudas, Jaakobuse poeg, ja Juudas Iskariot, kes sai äraandjaks. ");
INSERT INTO ekk_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kui Jeesus oli tulnud nendega koos mäelt alla, peatus ta tasases paigas. Seal oli suur hulk tema jüngreid ja arvukalt rahvast kogu Juudamaalt, Jeruusalemmast ning Tüürose ja Siidoni rannikualalt, ");
INSERT INTO ekk_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","kes olid tulnud teda kuulama ja oma haigustest terveks saama. Paranesid ka rüvedatest vaimudest piinatud inimesed. ");
INSERT INTO ekk_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kõik püüdsid teda puudutada, sest temast tuli vägi välja ja see tervendas neid kõiki. ");
INSERT INTO ekk_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jeesus vaatas oma jüngrite poole ja ütles: „Õnnistatud olete teie, kes te olete vaesed, sest teie päralt on Jumala riik! ");
INSERT INTO ekk_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Õnnistatud olete teie, kes te praegu nälgite, sest teid toidetakse! Õnnistatud olete teie, kes te praegu nutate, sest teie saate naerda! ");
INSERT INTO ekk_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Õnnistatud olete teie, kui inimesed teid vihkavad ja teid endi hulgast välja heidavad, kui nad teid teotavad ja teie nime põlgavad Inimese Poja pärast! ");
INSERT INTO ekk_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Olge rõõmsad sel päeval ja hüpake, sest teie tasu on suur taevas! Just samuti tegid nende esivanemad prohvetitega. ");
INSERT INTO ekk_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ent häda teile, kes te olete rikkad, sest teil on lohutus juba käes! ");
INSERT INTO ekk_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Häda teile, kes te praegu olete hästi toidetud, sest teie saate veel nälgida! Häda teile, kes te praegu naerate, sest teie saate leinata ja nutta! ");
INSERT INTO ekk_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Häda teile, kui kõik inimesed räägivad teist hästi, sest samuti tegid ju nende esivanemad valeprohvetitele! ");
INSERT INTO ekk_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Kuid ma ütlen teile, kes kuulete: armastage oma vaenlasi, tehke head neile, kes teid vihkavad. ");
INSERT INTO ekk_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Õnnistage neid, kes teid neavad, palvetage nende eest, kes teid laimavad. ");
INSERT INTO ekk_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kui keegi lööb sind ühele põsele, pööra tema poole ka teine, ja kui keegi võtab sinult kuue, sellele ära keela ka särki! ");
INSERT INTO ekk_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Anna igaühele, kes sinult küsib, ja kes võtab sinu oma, sellelt ära nõua tagasi! ");
INSERT INTO ekk_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tehke teistele seda, mida soovite, et nad ka teile teeksid! ");
INSERT INTO ekk_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kui te armastate neid, kes teid armastavad, mis kasu te sellest ootate? Isegi patused armastavad neid, kes neid armastavad. ");
INSERT INTO ekk_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ja kui te teete head neile, kes teile head teevad, mis tunnustust te selle eest ootate? Isegi patused teevad sedasama. ");
INSERT INTO ekk_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kui te laenate neile, kellelt te loodate tagasi saada, mis tunnustust te selle eest ootate? Ka patused laenavad patustele, et nad samavõrra tagasi saaksid. ");
INSERT INTO ekk_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Armastage oma vaenlasi, tehke head ja laenake neile ilma midagi tagasi lootmata. Siis on teie tasu suur ja te olete Kõigekõrgema lapsed, sest tema on hea tänamatute ja kurjade vastu! ");
INSERT INTO ekk_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Olge armulised, nagu teie Isa on armuline! ");
INSERT INTO ekk_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ärge mõistke kohut, ja ka teie üle ei mõisteta kohut! Ärge mõistke hukka, ja ka teid ei mõisteta hukka! Andke andeks, ja teile antakse andeks! ");
INSERT INTO ekk_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Andke, ja teile antakse – hea, tihedaks vajutatud, kokku raputatud, kuhjaga mõõt antakse teie rüppe. Selle mõõduga, millega teie mõõdate, mõõdetakse teile tagasi.“ ");
INSERT INTO ekk_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ta rääkis neile ka tähendamissõna: „Kas pime saab juhtida pimedat? Eks nad mõlemad kuku auku? ");
INSERT INTO ekk_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ei ole jünger õpetajast üle, kuid iga väljaõppe saanu on nagu tema õpetaja. ");
INSERT INTO ekk_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Miks sa näed pindu oma venna silmas, aga palki enda silmas ei märka? ");
INSERT INTO ekk_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kuidas sa võid oma vennale öelda: „Vend, lase ma tõmban välja pinnu sinu silmast!“ ja ise ei näe palki oma silmas? Silmakirjatseja, tõmba esmalt palk oma silmast välja, ja siis sa näed ka pindu oma venna silmast välja tõmmata! ");
INSERT INTO ekk_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ükski hea puu ei kanna halba vilja, ega halb puu head. ");
INSERT INTO ekk_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Iga puud tuntakse tema viljast. Viigimarju ei korjata kibuvitstelt ega koguta viinamarjakobaraid ohakailt. ");
INSERT INTO ekk_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Hea inimene toob välja head oma südame heast tagavarast ja kuri inimene toob kurjusest välja kurja. Sest ta suu räägib sellest, mida ta süda on täis. ");
INSERT INTO ekk_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Aga miks te mind hüüate: „Issand, Issand!“ ega tee, mida ma ütlen? ");
INSERT INTO ekk_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ma näitan teile, milline on inimene, kes minu juurde tulles kuuleb mu sõnu ja teeb nende järgi. ");
INSERT INTO ekk_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ta on inimese sarnane, kes maja ehitades kaevas sügavale ja ladus alusmüüri kaljule. Kui tuli üleujutus, sööstis tulvavesi vastu maja, kuid ei suutnud seda kõigutada, sest see oli ehitatud hästi. ");
INSERT INTO ekk_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Aga kes kuuleb ega tee, see on inimese sarnane, kes ehitas maja maapinnale ilma alusmüürita. Tulvavesi sööstis vastu maja ja see varises kokku ning hävis täielikult.“ ");
INSERT INTO ekk_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kui Jeesus oli kõnelenud kõike seda teda kuulanud rahvale, läks ta Kapernauma. ");
INSERT INTO ekk_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ühe sadakonna ülema sulane oli haige ja suremas. Sadakonna ülem hindas oma sulast väga ");
INSERT INTO ekk_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ning, kuulnud Jeesusest, läkitas ta juutide vanemad tema juurde palvega, et Jeesus tuleks ja teeks terveks tema sulase. ");
INSERT INTO ekk_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nad tulid Jeesuse juurde ja palusid teda tungivalt: „See mees väärib sinu abi, ");
INSERT INTO ekk_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","sest ta armastab meie rahvast. Ta on ehitanud meile ka sünagoogi.“ ");
INSERT INTO ekk_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ja Jeesus läks nendega kaasa. Ta ei olnud enam kuigi kaugel sellest majast, kui sadakonna ülem saatis oma sõbrad talle ütlema: „Issand, ära tee enesele rohkem tüli, sest ma ei ole väärt, et sina minu katuse alla tuled! ");
INSERT INTO ekk_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Seepärast ma ei ole ka ennast arvanud väärt sinu juurde tulema. Anna vaid käsk ja mu teener paraneb! ");
INSERT INTO ekk_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mina ise olen ju samuti võimu alla seatud ja minule alluvad sõdurid. Kui ma ütlen ühele neist: „Mine!“, siis ta läheb. Ma ütlen teisele: „Tule!“ ja ta tuleb. Ma ütlen oma teenrile: „Tee seda!“ ja ta teeb.“ ");
INSERT INTO ekk_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Seda kuuldes Jeesus imestas ta üle, ja pöördudes rahvahulga poole, kes käis temaga kaasas, sõnas: „Ma ütlen teile, isegi Iisraelis ei ole ma leidnud nii suurt usku!“ ");
INSERT INTO ekk_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ja kui saadikud majja tagasi pöördusid, leidsid nad sulase tervena. ");
INSERT INTO ekk_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mõni aeg hiljem läks Jeesus Naini linna ning temaga läksid kaasa ta jüngrid ja suur rahvahulk. ");
INSERT INTO ekk_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Aga kui ta linnaväravale lähenes, kanti sealt välja surnut. See oli ema ainus poeg, ja ema oli lesk. Teda saatis suur hulk linnarahvast. ");
INSERT INTO ekk_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kui Issand nägi ema, siis tal hakkas temast kahju ja ta ütles: „Ära nuta!“ ");
INSERT INTO ekk_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ta astus ligi, puudutas surnuraami, ning kandjad jäid seisma. Jeesus ütles: „Noormees, ma ütlen sulle, tõuse üles!“ ");
INSERT INTO ekk_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Surnu tõusis istuli ja hakkas rääkima. Jeesus andis poja ta emale. ");
INSERT INTO ekk_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Neid kõiki täitis aukartus ja nad ülistasid Jumalat. Nad ütlesid: „Meie seas on tõusnud suur prohvet!“ ja „Jumal on tulnud aitama oma rahvast!“ ");
INSERT INTO ekk_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ja jutt Jeesusest levis kogu Juudamaal ja selle ümbruskonnas. ");
INSERT INTO ekk_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Kõigest sellest jutustasid Johannesele tema jüngrid. Ja Johannes kutsus kaks oma jüngritest enda juurde ");
INSERT INTO ekk_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ja saatis nad Issanda käest küsima: „Kas sina oled see, kes pidi tulema, või me peame ootama kedagi teist?“ ");
INSERT INTO ekk_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Mehed tulid Jeesuse juurde ja ütlesid: „Ristija Johannes läkitas meid sinu käest küsima, kas sina oled see, kes pidi tulema, või me peame ootama kedagi teist?“ ");
INSERT INTO ekk_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Samal tunnil tegi Jeesus paljud terveks haigustest, vaevadest ja kurjadest vaimudest ning paljudele pimedatele andis nägemise. ");
INSERT INTO ekk_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ja Jeesus vastas neile: „Minge ja teatage Johannesele, mida te olete näinud ja kuulnud: pimedad saavad nägijaks, jalust vigased kõnnivad, pidalitõbised saavad puhtaks, kurdid kuulevad, surnud ärkavad üles, vaestele kuulutatakse evangeeliumi ");
INSERT INTO ekk_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ning õnnistatud on igaüks, kes minu pärast ei pahanda.“ ");
INSERT INTO ekk_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kui Johannese saadikud olid ära läinud, hakkas Jeesus rahvale rääkima Johannesest: „Mida te käisite kõrbes vaatamas? Kas tuules kõikuvat kõrt? ");
INSERT INTO ekk_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Või mida te tahtsite välja minnes näha? Kas peenetes rõivastes meest? Need, kes kannavad kalleid rõivaid ja elavad toretsemises, on kuningakodades. ");
INSERT INTO ekk_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mida te siis tahtsite näha? Kas prohvetit? Jah, ma ütlen teile, palju enam kui prohvetit! ");
INSERT INTO ekk_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tema on see, kellest on kirjutatud: „Vaata, ma saadan sinu ees oma saadiku, kes valmistab sinu tee su ees!“ ");
INSERT INTO ekk_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ma ütlen teile, ei ole naisest sündinute seas keegi suurem kui Johannes, ent vähim Jumala riigis on temast suurem. ");
INSERT INTO ekk_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kogu rahvas, kes teda kuulis, ja isegi maksukogujad tunnistasid, et Jumala tee on õige, ning lasid endid ristida Johannese ristimisega. ");
INSERT INTO ekk_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kuid variserid ja kirjatundjad lükkasid tagasi Jumala kavatsuse eneste kohta sellega, et ei lasknud Johannesel ennast ristida. ");
INSERT INTO ekk_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kellega ma võiksin võrrelda selle sugupõlve inimesi? Kelle sarnased nad on? ");
INSERT INTO ekk_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nad on laste sarnased, kes turuplatsil istuvad ja üksteisele nõnda hõikavad: „Meie mängisime teile vilepilli, aga teie ei tantsinud! Meie itkesime kurvalt, aga teie ei nutnud!“ ");
INSERT INTO ekk_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Sest Ristija Johannes tuli, ta ei söö leiba ega joo veini, ja teie ütlete: „Tal on kuri vaim!“ ");
INSERT INTO ekk_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Inimese Poeg on tulnud, sööb ja joob, ning siis te ütlete: „Vaadake, see inimene on õgard ja joodik, maksukogujate ja patuste sõber!“ ");
INSERT INTO ekk_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kuid tarkust kinnitavad kõik tema lapsed.“ ");
INSERT INTO ekk_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Üks variseridest kutsus Jeesuse enda juurde sööma. Ta läks variseri koju ja istus lauda. ");
INSERT INTO ekk_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Linnas oli keegi naine, kes elas patust elu. Kui ta sai teada, et Jeesus istub variseri majas lauas, tuli naine sinna alabasternõus lõhnasalviga. ");
INSERT INTO ekk_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ta astus Jeesuse taha ta jalgade juurde, niisutas nuttes tema jalgu pisaratega ja kuivatas neid oma juustega, suudles ta jalgu ja võidis neid lõhnasalviga. ");
INSERT INTO ekk_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kui variser, kes oli Jeesuse külla kutsunud, seda nägi, mõtles ta endamisi: „Kui ta oleks prohvet, siis ta taipaks, missugune naine see on, kes teda puudutab, et see naine on patune.“ ");
INSERT INTO ekk_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kuid Jeesus ütles talle: „Siimon, mul on sulle midagi öelda!“ „Räägi, Õpetaja!“ vastas ta. ");
INSERT INTO ekk_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","„Ühel rahalaenajal oli kaks võlglast. Üks neist oli võlgu viissada teenarit, teine viiskümmend. ");
INSERT INTO ekk_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kuna neil ei olnud raha talle tagasi maksta, siis ta kustutas nende mõlema võla. Kumb neist nüüd teda rohkem armastab?“ ");
INSERT INTO ekk_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Siimon vastas: „Ma arvan, et see, kelle võlg oli suurem.“ Jeesus ütles talle: „Sa arvasid õigesti.“ ");
INSERT INTO ekk_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Pöördudes naise poole, lausus ta Siimonile: „Kas sa näed seda naist? Ma tulin sinu majja. Sina ei andnud mu jalgade pesuks vett, kuid tema on oma pisaratega mu jalgu niisutanud ja juustega kuivatanud. ");
INSERT INTO ekk_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Sina ei suudelnud mind tervituseks, kuid tema ei ole sellest ajast peale, kui ta sisse astus, lakanud mu jalgu suudlemast. ");
INSERT INTO ekk_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Sina ei võidnud mu pead õliga, kuid tema on võidnud mu jalgu lõhnasalviga. ");
INSERT INTO ekk_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Seetõttu ma ütlen sulle, et tema paljud patud on talle andeks antud, nagu tema suur armastus on näidanud. Aga kellele antakse andeks pisut, see ka armastab pisut.“ ");
INSERT INTO ekk_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ja ta ütles naisele: „Su patud on sulle andeks antud.“ ");
INSERT INTO ekk_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Lauasolijad küsisid isekeskis: „Kes see on, kes isegi patte andeks annab?“ ");
INSERT INTO ekk_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jeesus ütles naisele: „Sinu usk on sind päästnud. Mine rahus!“ ");
INSERT INTO ekk_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pärast seda rändas Jeesus linnast linna ja külast külla, kuulutades evangeeliumi Jumala riigist. Kaksteist jüngrit olid koos temaga ");
INSERT INTO ekk_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ja samuti mõned naised, keda ta oli vabastanud kurjadest vaimudest ja haigustest. Need olid Maarja, keda kutsutakse Magdaleenaks, kellest oli seitse kurja vaimu välja läinud; ");
INSERT INTO ekk_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Johanna, Heroodese majapidaja Kuusase naine; Susanna ja paljud teised. Need naised toetasid neid oma varaga. ");
INSERT INTO ekk_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Samal ajal kui suur rahvahulk kogunes ja paljudest linnadest Jeesuse juurde tuli, rääkis ta neile tähendamissõna: ");
INSERT INTO ekk_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","„Külvaja läks välja seemet külvama. Külvamisel kukkus osa seemet teeveerde, selle peal tallati ja linnud sõid selle ära. ");
INSERT INTO ekk_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Osa kukkus kivisele pinnale, ja tärgates see kuivas, sest seal ei olnud niiskust. ");
INSERT INTO ekk_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Osa seemet kukkus ohakate sekka, ja kasvavad ohakad lämmatasid selle. ");
INSERT INTO ekk_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Aga osa kukkus heasse mulda ja kandis saaki sada korda rohkem kui külvati.“ Kui ta oli seda öelnud, hüüdis Jeesus: „Kellel kõrvad on, see kuulgu!“ ");
INSERT INTO ekk_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jeesuse jüngrid küsisid temalt, kuidas seda tähendamissõna mõista. ");
INSERT INTO ekk_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jeesus ütles: „Teile on antud teada Jumala riigi saladusi, aga teistele räägitakse tähendamissõnades, et nad „vaadates ei näeks ja kuuldes ei mõistaks.“ ");
INSERT INTO ekk_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Tähendamissõna tuleb mõista nii: seeme on Jumala sõna. ");
INSERT INTO ekk_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Teeveered on need, kes kuulevad, aga siis tuleb kurat ja võtab sõna ära nende südamest, et nad ei usuks ega pääseks. ");
INSERT INTO ekk_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kivisele pinnale külvatud on need, kes kuuldes võtavad sõna rõõmuga vastu, kuid neil ei ole juurt. Nad usuvad lühikest aega, aga katsumuste ajal nad langevad ära. ");
INSERT INTO ekk_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ohakatesse kukkunud seeme on aga need, kes küll kuulevad, kuid siis lämmatavad neid elumured, rikkus ja naudingud ning nad ei saa küpseks. ");
INSERT INTO ekk_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kuid heas mullas seeme on need, kellel on üllas ja hea süda, kes sõna kuuldes seda hoiavad ning kannatlikkuses vilja kannavad. ");
INSERT INTO ekk_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Mitte keegi, kes on süüdanud lambi, ei kata seda savipotiga ega pane seda ka voodi alla, vaid paneb selle lambijalale, et sisenejad näeksid valgust. ");
INSERT INTO ekk_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sest ei ole midagi varjatut, mis ei tuleks ilmsiks, ega midagi salajast, mis ei saaks teatavaks ega tehtaks avalikuks. ");
INSERT INTO ekk_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Seetõttu kaaluge hoolikalt, kuidas te kuulate! Kellel on, sellele antakse, ja kellel ei ole, sellelt võetakse ära seegi, mida ta arvab enesel olevat.“ ");
INSERT INTO ekk_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jeesuse juurde tulid ta ema ja vennad, kuid ei saanud temaga rahvahulga tõttu kokku. ");
INSERT INTO ekk_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Keegi ütles talle: „Su ema ja vennad seisavad väljas ja tahavad sind näha.“ ");
INSERT INTO ekk_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ta vastas: „Minu ema ja mu vennad on need, kes Jumala sõna kuulevad ja selle järgi teevad.“ ");
INSERT INTO ekk_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ühel päeval ütles Jeesus oma jüngritele: „Sõidame üle järve teisele kaldale.“ Nii nad astusid paati ja asusid teele. ");
INSERT INTO ekk_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Purjetamise ajal jäi ta magama. Kuid järvel tõusis raju, paat läks vett täis ja nad olid suures ohus. ");
INSERT INTO ekk_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jüngrid läksid ta juurde, öeldes: „Õpetaja, Õpetaja, me upume!“ Ta ärkas üles, sõitles tuult ja mässavaid laineid. Torm vaibus ja kõik oli rahulik. ");
INSERT INTO ekk_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jeesus küsis jüngritelt: „Kus on teie usk?“ Nemad lõid kartma ja küsisid üksteiselt imestades: „Kes see mees küll on, et ta käsutab isegi tuuli ja vett ning need kuuletuvad talle?“ ");
INSERT INTO ekk_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nad purjetasid gerasalaste maale, mis on Galileast teisel pool järve. ");
INSERT INTO ekk_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kui Jeesus maale astus, oli tal vastas kurjast vaimust vaevatud mees, kes oli tulnud linnast. See mees ei kandnud ammu enam rõivaid ega elanud majas, vaid haudades. ");
INSERT INTO ekk_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jeesust nähes hakkas ta karjuma, langes tema jalge ette maha ja kisendas: „Mida sa minust tahad, Jeesus, Kõigekõrgema Jumala Poeg? Ma anun sind, ära piina mind!“ ");
INSERT INTO ekk_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jeesus oli ju käskinud rüvedal vaimul mehest välja minna. See oli teda palju kordi oma valdusse haaranud. Ja kuigi teda oli kätest ja jalgadest aheldatud ning valve all hoitud, oli ta ahelad katki rebinud ning kuri vaim oli teda kihutanud tühermaale. ");
INSERT INTO ekk_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","„Mis su nimi on?“ küsis Jeesus. Mees vastas: „Leegion.“ Sest temasse oli läinud palju kurje vaime. ");
INSERT INTO ekk_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Need palusid Jeesust korduvalt, et ta ei käsiks neid sügavikku minna. ");
INSERT INTO ekk_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Aga seal oli suur seakari mäe peal söömas. Kurjad vaimud palusid teda, et ta lubaks neil minna sigade sisse, ja Jeesus lubas. ");
INSERT INTO ekk_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kui nad olid mehest väljunud, läksid nad sigadesse ning kari tormas järsakust alla järve ja uppus. ");
INSERT INTO ekk_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kui karjused nägid, mis oli sündinud, põgenesid nad ja jutustasid sellest linnas ja maal. ");
INSERT INTO ekk_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Inimesed tulid vaatama, mis oli juhtunud. Kui nad jõudsid Jeesuse juurde ja leidsid mehe, kellest kurjad vaimud olid välja läinud, rõivastatult ja selge aruga Jeesuse jalge ees istumas, lõid nad kartma. ");
INSERT INTO ekk_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Pealtnägijad kirjeldasid neile, kuidas kurjast vaimust vaevatu oli terveks tehtud. ");
INSERT INTO ekk_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kõik gerasalaste piirkonna elanikud palusid Jeesust, et ta lahkuks nende juurest, sest suur hirm valdas neid. Jeesus astus siis paati ning pöördus tagasi. ");
INSERT INTO ekk_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Aga mees, kellest kurjad vaimud olid välja läinud, anus Jeesust, et ta võiks minna koos temaga. Kuid Jeesus saatis ta minema, öeldes: ");
INSERT INTO ekk_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","„Mine tagasi oma koju ja räägi, kui palju Jumal sinu heaks on teinud.“ Siis mees läks ja kuulutas kogu linnas, mida Jeesus oli talle teinud. ");
INSERT INTO ekk_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kui nüüd Jeesus tagasi jõudis, võttis teda vastu rahvahulk, sest nad kõik ootasid teda. ");
INSERT INTO ekk_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Sinna tuli mees, nimega Jairus, kes oli sünagoogi ülem. Ta langes Jeesuse jalge ette ning palus teda tulla oma koju. ");
INSERT INTO ekk_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Sest ta ainus laps, umbes kaheteistkümneaastane tütar, oli suremas. Kui Jeesus oli teel sinna, pressis rahvas talle peale. ");
INSERT INTO ekk_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nende hulgas oli naine, kes oli kannatanud kaksteist aastat verejooksu. Ta oli arstide peale kulutanud kogu oma vara, kuid keegi ei olnud suutnud teda terveks teha. ");
INSERT INTO ekk_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","See naine läks Jeesuse selja taha ja puudutas ta kuue serva. Otsekohe verejooks lakkas. ");
INSERT INTO ekk_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jeesus küsis: „Kes puudutas mind?“ Kui kõik eitasid, ütles Peetrus: „Õpetaja, rahvas tungleb ja pressib sulle peale.“ ");
INSERT INTO ekk_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ent Jeesus ütles: „Keegi puudutas mind, sest ma tundsin väge enesest välja minevat.“ ");
INSERT INTO ekk_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kui naine nägi, et ta ei saa tähelepandamatuks jääda, tuli ta värisedes ja langes Jeesuse jalge ette. Ja ta jutustas kogu rahva ees, miks ta oli Jeesust puudutanud ja kuidas ta otsekohe oli terveks saanud. ");
INSERT INTO ekk_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jeesus ütles naisele: „Tütar, sinu usk on sind terveks teinud, mine rahus!“ ");
INSERT INTO ekk_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kui Jeesus alles rääkis, tuli keegi sünagoogi ülema majast ja ütles: „Su tütar on surnud. Ära tülita enam Õpetajat!“ ");
INSERT INTO ekk_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Seda kuuldes ütles Jeesus Jairusele: „Ära karda! Usu ainult, ja ta saab terveks!“ ");
INSERT INTO ekk_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jairuse majja jõudes ei lubanud ta kedagi endaga koos sisse tulla peale Peetruse, Johannese, Jaakobuse ning lapse isa ja ema. ");
INSERT INTO ekk_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kõik inimesed nutsid ja halasid, kuid Jeesus ütles: „Ärge nutke! Ta ei ole surnud, vaid magab!“ ");
INSERT INTO ekk_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ja nad naersid tema üle, sest nad teadsid, et tüdruk on surnud. ");
INSERT INTO ekk_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kuid Jeesus võttis ta käest kinni ja hüüdis: „Lapsuke, tõuse üles!“ ");
INSERT INTO ekk_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ja vaim pöördus tüdrukusse tagasi ja ta tõusis kohe üles ning Jeesus käskis talle süüa anda. ");
INSERT INTO ekk_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tüdruku vanemad olid hämmastunud, kuid Jeesus keelas neid kellelegi kõnelemast, mis oli sündinud. ");
INSERT INTO ekk_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Kutsunud kokku kaksteist jüngrit, andis Jeesus neile väe ja meelevalla välja ajada kurje vaime ja ravida haigusi ");
INSERT INTO ekk_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ning läkitas nad kuulutama Jumala riiki ja tervendama haigeid. ");
INSERT INTO ekk_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ta ütles neile: „Ärge võtke midagi teele kaasa, ei keppi ega reisipauna ega leiba ega raha ega teist särki! ");
INSERT INTO ekk_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kuhu majja te ka sisse astute, sinna jääge, kuni te linnast lahkute. ");
INSERT INTO ekk_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kus teid vastu ei võeta, sellest linnast lahkuge ja raputage selle koha tolm oma jalgelt maha tunnistuseks nende vastu!“ ");
INSERT INTO ekk_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nad asusid teele ja käisid külast külla, kuulutasid evangeeliumi ja tegid haigeid terveks kõikjal. ");
INSERT INTO ekk_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nelivürst Heroodes sai kuulda kõigest toimunust ja oli kimbatuses, sest mõned ütlesid, et Johannes on üles äratatud surnuist, ");
INSERT INTO ekk_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","teised aga, et Eelija on ilmunud ja kolmandad, et keegi muistsetest prohvetitest on üles tõusnud! ");
INSERT INTO ekk_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kuid Heroodes ütles: „Johannese pea lasksin ma maha raiuda. Kes on aga siis see, kellest ma kuulen sääraseid asju?“ Ja ta püüdis Jeesust näha saada. ");
INSERT INTO ekk_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kui apostlid pöördusid tagasi, jutustasid nad Jeesusele, mida nad olid teinud. Jeesus võttis nad kaasa ja eraldus koos nendega linna, mida kutsuti Betsaidaks. ");
INSERT INTO ekk_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Aga kui rahvas sellest teada sai, järgnesid nad talle. Jeesus võttis nad vastu ning rääkis neile Jumala riigist ja tervendas need, kes tervendamist vajasid. ");
INSERT INTO ekk_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Päev hakkas õhtusse jõudma ja ta juurde astusid kaksteist jüngrit ja ütlesid: „Saada rahvas minema, et nad läheksid ümberkaudsetesse linnadesse ja asulatesse toitu ja öömaja otsima, sest me oleme siin inimtühjas paigas.“ ");
INSERT INTO ekk_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kuid Jeesus ütles neile: „Andke teie neile midagi süüa!“ Nad vastasid: „Meil ei ole rohkem kui viis leiba ja kaks kala, kui me just ei lähe ega osta toitu kogu sellele rahvale.“ ");
INSERT INTO ekk_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Seal oli umbes viis tuhat meest. Siis ütles Jeesus oma jüngritele: „Seadke nad istuma gruppidesse umbes viiekümne kaupa.“ ");
INSERT INTO ekk_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jüngrid tegid nõnda ja kõik istusid maha. ");
INSERT INTO ekk_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jeesus võttis need viis leiba ja kaks kala, vaatas üles taevasse, õnnistas neid ja murdis ning andis jüngrite kätte rahvale jagamiseks. ");
INSERT INTO ekk_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nad sõid ja kõikide kõhud said täis. Ja neist üle jäänud palukesi korjati kokku kaksteist korvitäit. ");
INSERT INTO ekk_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kord, kui Jeesus oli üksi palvetamas ja ta jüngrid olid temaga, küsis ta neilt: „Kelle ütlevad inimesed mind olevat?“ ");
INSERT INTO ekk_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nad vastasid talle: „Mõned ütlevad Ristija Johannese, mõned Eelija ja mõned kellegi muistsetest prohvetitest, kes on üles tõusnud.“ ");
INSERT INTO ekk_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jeesus küsis neilt: „Aga teie? Kelle teie ütlete mind olevat?“ Peetrus vastas: „Jumala Messia!“ ");
INSERT INTO ekk_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Aga Jeesus hoiatas neid ja keelas sellest kellelegi rääkimast. ");
INSERT INTO ekk_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ja ta ütles: „Inimese Poeg hüljatakse ning ta peab palju kannatama rahvavanemate, ülempreestrite ja kirjatundjate käes; ta tapetakse ning kolmandal päeval äratatakse üles.“ ");
INSERT INTO ekk_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jeesus ütles kõikidele: „Kui keegi tahab olla minu jünger, siis ta salaku end maha ja kandku iga päev oma risti ja järgnegu mulle! ");
INSERT INTO ekk_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sest kes tahab päästa oma elu, kaotab selle, kuid kes kaotab oma elu minu pärast, see päästab selle. ");
INSERT INTO ekk_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mis kasu on inimesel, kui ta võidaks kogu maailma, oma hingele teeks aga kahju? ");
INSERT INTO ekk_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Igaüks, kes häbeneb mind ja minu sõnu, seda häbeneb ka Inimese Poeg, kui ta tuleb oma auhiilguses ning Isa ja pühade inglite auhiilguses. ");
INSERT INTO ekk_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kuid tõesti, ma ütlen teile, siin seisavad mõned, kes ei maitse surma, enne kui nad näevad Jumala riiki.“ ");
INSERT INTO ekk_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Umbes nädal pärast seda võttis Jeesus kaasa Peetruse, Johannese ja Jaakobuse ning läks üles mäele palvetama. ");
INSERT INTO ekk_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Palvetamise ajal muutus tema pale ja ta riided muutusid säravaks kui välgu valgus. ");
INSERT INTO ekk_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ja ennäe, kaks meest, Mooses ja Eelija, kõnelesid temaga. ");
INSERT INTO ekk_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nad ilmusid auhiilguses ja kõnelesid tema lahkumisest, mille ta pidi täide viima Jeruusalemmas. ");
INSERT INTO ekk_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peetrus ja tema kaaslased olid väsimusest uinunud, aga kui nad ärkasid, nägid nad Jeesuse auhiilgust ja kahte meest tema juures seisvat. ");
INSERT INTO ekk_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kui Mooses ja Eelija olid Jeesuse juurest lahkumas, ütles Peetrus: „Õpetaja, siin on meil hea olla. Teeme kolm telki: ühe sulle, ühe Moosesele ja ühe Eelijale.“ ");
INSERT INTO ekk_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kui Peetrus kõneles, tuli pilv ja varjas neid. Jüngrid kartsid, kui pilv neid kattis. ");
INSERT INTO ekk_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pilve seest kostis hääl: „See on minu Poeg, kelle ma olen valinud. Teda kuulake!“ ");
INSERT INTO ekk_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kui hääl oli rääkinud, nägid nad, et Jeesus oli üksi. Jüngrid hoidsid selle enese teada ega rääkinud sel ajal kellelegi, mida nad olid näinud. ");
INSERT INTO ekk_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Järgmisel päeval, kui nad mäelt laskusid, tuli Jeesusele vastu suur rahvahulk. ");
INSERT INTO ekk_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ja üks mees rahva hulgast kisendas: „Õpetaja, ma anun sind, vaata mu poja peale, sest ta on mu ainus laps! ");
INSERT INTO ekk_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Vaim haarab temast kinni ja poiss karjatab äkki. Vaim heidab ta krampidesse, nii et ta suust tuleb välja vahtu. Ta ei jäta teda peaaegu mitte kunagi ja hävitab ta. ");
INSERT INTO ekk_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ma anusin sinu jüngreid, et nad ajaksid ta välja, aga nad ei suutnud.“ ");
INSERT INTO ekk_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jeesus vastas: „Oh uskmatu ja rikutud sugupõlv! Kui kaua ma pean teie juures olema ja teid välja kannatama? Too oma poeg siia!“ ");
INSERT INTO ekk_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kui poiss oli alles lähenemas, virutas kuri vaim ta krampides maha ja kägistas teda. Jeesus aga sõitles rüvedat vaimu, tegi poisi terveks ning andis isale tagasi. ");
INSERT INTO ekk_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kõik jahmusid Jumala vägevusest. Aga kui kõik panid imeks Jeesuse tegusid, siis ütles ta oma jüngritele: ");
INSERT INTO ekk_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","„Kuulake tähelepanelikult, mida ma teile ütlen – Inimese Poeg antakse inimeste kätte!“ ");
INSERT INTO ekk_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Aga nemad ei saanud aru, mida ta sellega mõtles. See oli nende eest varjatud, et nad ei saaks aru, ja nad kartsid Jeesuselt selle kohta küsida. ");
INSERT INTO ekk_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jüngrite hulgas tõusis tüli selle üle, kes neist on suurim. ");
INSERT INTO ekk_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kuid Jeesus, teades nende mõtteid, võttis ühe lapse, pani ta enese kõrvale seisma ");
INSERT INTO ekk_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ja ütles neile: „Kes iganes võtab sellise lapse vastu minu nimel, võtab vastu minu. Ja kes iganes võtab vastu minu, võtab vastu selle, kes mind on läkitanud. Sest kes on väikseim teie hulgas, on suurim.“ ");
INSERT INTO ekk_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Siis ütles Johannes: „Õpetaja, me nägime üht meest sinu nimel kurje vaime välja ajamas ja me keelasime teda, sest ta ei järgi meiega koos sind.“ ");
INSERT INTO ekk_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kuid Jeesus ütles talle: „Ärge keelake teda, sest kes ei ole teie vastu, see on teie poolt!“ ");
INSERT INTO ekk_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kui Jeesuse taevasse võtmise aeg kätte jõudis, hakkas ta otsustavalt Jeruusalemma poole minema. ");
INSERT INTO ekk_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ja ta saatis enese ees sõnumitoojad, kes läksid ühte samariitlaste külla tema jaoks öömaja valmis seadma. ");
INSERT INTO ekk_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kuid külarahvas ei võtnud teda vastu, sest ta oli teel Jeruusalemma. ");
INSERT INTO ekk_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Seda nähes ütlesid jüngrid Jaakobus ja Johannes: „Issand, kas sa tahad, et me käsime tulel taevast alla langeda ja nad ära hävitada?“ ");
INSERT INTO ekk_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jeesus aga pöördus ümber ja sõitles neid. ");
INSERT INTO ekk_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ja ta läks koos jüngritega edasi teise külla. ");
INSERT INTO ekk_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kui nad olid teed käimas, ütles keegi Jeesusele: „Ma järgnen sulle, kuhu sa iganes lähed!“ ");
INSERT INTO ekk_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jeesus kostis talle: „Rebastel on urud ja lindudel pesad, aga Inimese Pojal ei ole, kuhu oma pead panna.“ ");
INSERT INTO ekk_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ja ühele teisele ütles Jeesus: „Järgne mulle!“ Ent see vastas: „Issand, luba mul esmalt minna isa matma!“ ");
INSERT INTO ekk_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jeesus ütles talle: „Las surnud matta ise oma surnuid, sina aga mine ja kuuluta Jumala riiki!“ ");
INSERT INTO ekk_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ja veel keegi ütles: „Issand, ma tahan sulle järgneda, kuid luba mul esmalt jätta hüvasti oma perega.“ ");
INSERT INTO ekk_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kuid Jeesus vastas: „Ükski, kes on pannud käe adra külge ja siis vaatab tagasi, ei kõlba Jumala riigi teenistusse!“ ");
INSERT INTO ekk_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pärast seda määras Issand veel seitsekümmend kaks jüngrit ja saatis nad kahekaupa enda ees igasse linna ja paika, kuhu ta oli minemas. ");
INSERT INTO ekk_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ta ütles neile: „Lõikus on suur, aga töötegijaid on vähe. Seepärast paluge lõikuse Issandat, et ta saadaks töötegijaid välja oma lõikusele! ");
INSERT INTO ekk_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Minge! Ma saadan teid otsekui tallekesi huntide sekka. ");
INSERT INTO ekk_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ärge võtke rahakotti ega kotti ega sandaale ja ärge tervitage kedagi teel! ");
INSERT INTO ekk_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kui te sisenete majja, öelge kõigepealt: „Rahu sellele kojale!“ ");
INSERT INTO ekk_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ja kui seal on rahulaps, jääb teie rahu tema peale, aga kui mitte, pöördub rahu teie juurde tagasi. ");
INSERT INTO ekk_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Jääge sinna majja, sööge ja jooge kõike, mida nad teile pakuvad, sest töötegija on oma palka väärt. Ärge käige ühest majast teise! ");
INSERT INTO ekk_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kui te lähete linna ja teid võetakse vastu, sööge, mis teie ette pannakse. ");
INSERT INTO ekk_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tervendage sealseid haiged ja öelge neile: „Jumala riik on teie lähedal!“ ");
INSERT INTO ekk_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Aga kui te lähete linna ja teid ei võeta vastu, minge linnaväljakule ja öelge: ");
INSERT INTO ekk_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","„Isegi teie linna tolmu, mis on meie jalgadel, pühime me ära teile hoiatuseks. Kuid teadke seda: Jumala riik on lähedal!“ ");
INSERT INTO ekk_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ma ütlen teile, Soodomal läheb sel päeval kergemini kui sellel linnal. ");
INSERT INTO ekk_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Häda sulle, Korasin! Häda sulle, Betsaida! Kui Tüüroses ja Siidonis oleksid sündinud need imeteod, mis teie juures sündisid, siis oleksid nad ammugi kotiriides ja tuhas meelt parandanud. ");
INSERT INTO ekk_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Aga Tüürosel ja Siidonil läheb kohtupäeval kergemini kui teil. ");
INSERT INTO ekk_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ja sina, Kapernaum, kas sind peaks ülendatama taevani? Sa langed alla põrgupõhja! ");
INSERT INTO ekk_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kes iganes teid kuulab, see kuulab mind, kes teid ära tõukab, see tõukab ära minu; aga kes minu ära tõukab, tõukab ära tema, kes mind läkitas.“ ");
INSERT INTO ekk_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Seitsekümmend kaks jüngrit saabusid tagasi rõõmsatena ja ütlesid: „Issand, isegi kurjad vaimud alluvad meile sinu nimes!“ ");
INSERT INTO ekk_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ta vastas: „Ma nägin saatanat kui välku taevast langemas. ");
INSERT INTO ekk_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ma olen andnud teile meelevalla tallata madude ja skorpionite peal ja kogu vaenlase väe peal. Miski ei tee teile kahju. ");
INSERT INTO ekk_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kuid ärge rõõmustage, et vaimud teile alistuvad, vaid rõõmustage, et teie nimed on taevasse kirja pandud!“ ");
INSERT INTO ekk_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Selsamal ajal täitus Jeesus rõõmuga Pühas Vaimus ja ütles: „Ma ülistan sind, Isa, taeva ja maa Issand, et sa selle oled pannud varjule tarkade ja arusaajate eest, kuid ilmutanud lapsemeelsetele! Jah, Isa, nõnda on see olnud sulle meelepärane. ");
INSERT INTO ekk_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kõik on mu Isa andnud minu kätte. Keegi ei tea, kes on Poeg, kui ainult Isa, ja kes on Isa, kui vaid Poeg, ja see, kellele Poeg soovib teda ilmutada.“ ");
INSERT INTO ekk_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ja omavahel olles Jeesus pöördus jüngrite poole ja ütles: „Õnnistatud on silmad, mis näevad seda, mida teie näete. ");
INSERT INTO ekk_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Sest ma ütlen teile, paljud prohvetid ja kuningad tahtsid näha seda, mida teie näete, ega ole näinud, ja kuulda, mida teie kuulete, ega ole kuulnud.“ ");
INSERT INTO ekk_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kord tõusis üks kirjatundja püsti, et Jeesust proovile panna. „Õpetaja,“ küsis ta, „mida ma pean tegema, et pärida igavest elu?“ ");
INSERT INTO ekk_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","„Mis on Seaduses kirjas?“ küsis ta. „Kuidas sa seda mõistad?“ ");
INSERT INTO ekk_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ta vastas: „Armasta Issandat, oma Jumalat, kogu oma südamest ja kogu oma hingest ning kogu oma jõust ja kogu oma mõistusest, ja armasta oma ligimest nagu iseennast!“ ");
INSERT INTO ekk_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","„Sa oled õigesti vastanud,“ vastas Jeesus. „Tee seda, ja sa jääd elama!“ ");
INSERT INTO ekk_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Aga tahtes ennast õigustada, küsis ta Jeesuselt: „Ja kes on minu ligimene?“ ");
INSERT INTO ekk_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jeesus ütles vastuseks: „Üks mees läks Jeruusalemmast alla Jeerikosse, kui ta sattus röövlite kätte. Nad röövisid ta riided, peksid teda ja läksid ära, jättes ta poolsurnuna maha. ");
INSERT INTO ekk_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sama teed juhtus minema keegi preester ja meest nähes möödus temast teisel pool teed. ");
INSERT INTO ekk_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nõndasamuti ka leviit: kui ta selle kohani jõudis ja teda nägi, läks teisele poole teed. ");
INSERT INTO ekk_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ka üks samaarlane jõudis samasse kohta, ja kui ta nägi meest, oli tal temast hale. ");
INSERT INTO ekk_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ta läks mehe juurde, sidus tema haavad ning valas neile õli ja veini. Siis ta pani mehe oma eesli selga, viis öömajale ja hoolitses tema eest. ");
INSERT INTO ekk_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Järgmisel päeval võttis ta kaks teenarit ja andis need peremehele: „Kanna tema eest hoolt, ja kui ma tulen tagasi, hüvitan lisakulud, mida sa tema pärast tegid.“ ");
INSERT INTO ekk_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Milline neist kolmest oli sinu arvates ligimene sellele mehele, kes röövlite kätte langes?“ ");
INSERT INTO ekk_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Kirjatundja vastas: „See, kes tema vastu armuline oli.“ Jeesus ütles: „Mine ja tee samamoodi!“ ");
INSERT INTO ekk_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kui Jeesus ja ta jüngrid olid teel, jõudsid nad külla, kus üks naine, Marta, ta vastu võttis. ");
INSERT INTO ekk_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tal oli õde nimega Maarja, kes istus Issanda jalge ees ja kuulas, mida ta rääkis. ");
INSERT INTO ekk_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Aga Marta oli mures kõigi toimetuste pärast, mis ta pidi tegema. Ta tuli Jeesuse juurde ja küsis: „Issand, kas sa ei hooli, et mu õde jättis kogu töö ainult minu kanda? Ütle talle, et ta mind aitaks!“ ");
INSERT INTO ekk_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","„Marta, Marta,“ vastas Issand, „sa oled mures ja rahulolematu paljude asjade pärast, ");
INSERT INTO ekk_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kuid tarvis on vaid üht. Maarja on valinud selle, mis on parem, ja seda ei võeta temalt ära.“ ");
INSERT INTO ekk_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jeesus oli ühes paigas palvetamas. Kui ta lõpetas, ütles üks tema jüngritest talle: „Issand, õpeta meid palvetama, nii nagu Johannes õpetas oma jüngreid!“ ");
INSERT INTO ekk_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ta ütles neile: „Kui te palvetate, siis ütelge: „Isa! Pühitsetud olgu sinu nimi! Sinu riik tulgu! ");
INSERT INTO ekk_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Meie igapäevast leiba anna meile iga päev. ");
INSERT INTO ekk_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Anna meile andeks meie patud, nõnda nagu meie andestame igaühele, kes patustab meie vastu! Ja ära saada meid kiusatusse.“ “ ");
INSERT INTO ekk_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jeesus ütles neile: „Oletame, et ühel teist on sõber, kes tuleb keskööl tema juurde ja ütleb: „Sõber, anna mulle kolm pätsi leiba, ");
INSERT INTO ekk_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","sest mu sõber on reisilt tulnud minu juurde ja mul ei ole midagi talle süüa pakkuda.“ ");
INSERT INTO ekk_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ja seesolija vastab: „Ära tüüta mind. Uks on juba lukus ja lapsed on minuga voodis. Ma ei saa üles tõusta ja sulle anda!“ ");
INSERT INTO ekk_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ma ütlen teile, et kui ta ei tõuse leiba andma tema sõpruse pärast, siis teeb ta seda tema järjekindluse pärast ja annab talle nii palju, kui vaja. ");
INSERT INTO ekk_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nii ma ütlen teile: küsige, ja teile antakse; otsige, ja te leiate; koputage uksele, ja teile avatakse! ");
INSERT INTO ekk_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Igaüks, kes palub, see saab; kes otsib, see leiab; ja kes koputab, sellele avatakse! ");
INSERT INTO ekk_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Aga missugune isa teie seast, kellelt poeg palub kala, annaks talle kala asemel mao? ");
INSERT INTO ekk_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Või kui ta küsib muna, annaks talle skorpioni? ");
INSERT INTO ekk_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kui nüüd teie, kes te olete kurjad, oskate anda häid ande oma lastele, kui palju enam teie Isa taevas annab Püha Vaimu nendele, kes teda paluvad!“ ");
INSERT INTO ekk_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kord ajas Jeesus välja kurja vaimu, kes oli keeletu. Kui kuri vaim oli lahkunud, hakkas tumm mees rääkima ja rahvas oli imestunud. ");
INSERT INTO ekk_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Aga mõned neist ütlesid: „Ta ajab kurje vaime välja kurjade vaimude valitseja Peltsebuli abil!“ ");
INSERT INTO ekk_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Teised panid teda aga proovile, küsides tunnustähte taevast. ");
INSERT INTO ekk_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jeesus teadis nende mõtteid ja ütles neile: „Iga kuningriik, mis on riius lõhenenud, laastatakse, ja maja, mis on lõhenenud, hävitatakse. ");
INSERT INTO ekk_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kui saatan on riius iseendaga, kuidas saab tema kuningriik püsida? Teie ju ütlete, et ma ajan kurje vaime välja Peltsebuliga. ");
INSERT INTO ekk_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kui mina peaksin kurje vaime välja ajama Peltsebuli abil, kelle abil siis teie kasvandikud neid välja ajavad? Seepärast mõistku nemad kohut teie üle! ");
INSERT INTO ekk_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Aga kui mina ajan Jumala sõrmega kurje vaime välja, siis on Jumala riik saabunud teie juurde. ");
INSERT INTO ekk_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kui vägimees valvab täies relvastuses oma maja, on tema vara kaitstud. ");
INSERT INTO ekk_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Aga kui keegi veel tugevam teda ründab ja ta alistab, siis võtab ta ära tema relvastuse ja jagab laiali temalt saadud saagi. ");
INSERT INTO ekk_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Kes ei ole minuga, on minu vastu, ja kes ei kogu minuga, pillub laiali. ");
INSERT INTO ekk_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kui rüve vaim väljub inimesest, hulgub ta põuastes paikades ja otsib hingamist, kuid ei leia seda. Siis ta ütleb: „Ma pöördun tagasi oma majja, kust ma ära tulin.“ ");
INSERT INTO ekk_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tulles leiab ta selle tühjana, puhtaks pühitud ja ehitud. ");
INSERT INTO ekk_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Siis võtab ta kaasa veel seitse vaimu, kes on kurjemad kui ta ise, ning asub sinna elama. Selle inimese hilisem olukord läheb halvemaks kui varasem.“ ");
INSERT INTO ekk_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kui Jeesus seda kõike rääkis, tõstis üks naine rahva hulgas häält: „Õnnistatud on ema, kes su sünnitas ja sind imetas.“ ");
INSERT INTO ekk_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ta vastas: „Pigem on õnnistatud need, kes Jumala sõna kuulevad ja sellele kuuletuvad.“ ");
INSERT INTO ekk_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Aga kui rahvahulk kasvas, ütles Jeesus: „See sugupõlv on kuri. Ta nõuab tunnustähte, aga talle ei anta muud kui Joona tunnustäht. ");
INSERT INTO ekk_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nii nagu Joona sai tunnustäheks Niineve rahvale, nii on ka Inimese Poeg sellele sugupõlvele. ");
INSERT INTO ekk_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Lõunamaa kuninganna tõuseb üles kohtupäeval koos selle sugupõlvega ja mõistab ta süüdi, sest tema tuli maailma otsast kuulama Saalomoni tarkust, ja nüüd on siin keegi suurem kui Saalomon! ");
INSERT INTO ekk_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Niineve mehed astuvad kohtupäeval üles selle sugupõlve vastu ja mõistavad ta süüdi, sest nemad parandasid meelt Joona kuulutuse peale, aga siin on nüüd üks, kes on suurem kui Joona. ");
INSERT INTO ekk_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Keegi ei süüta lampi ja peida seda ära või pane vaka alla. Ta paneb selle lambijalale, et sisseastuja näeks valgust. ");
INSERT INTO ekk_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Silm on ihu lamp. Kui su silm on hea, on su ihu täidetud valgusega. Aga kui see on kuri, on ihu täis pimedust. ");
INSERT INTO ekk_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Vaata siis, et valgus su sees ei oleks pimedus! ");
INSERT INTO ekk_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Seepärast, kui kogu su ihu on valgust täis ja ükski osa pole pimeduses, siis on ta sama valgusküllane nagu siis, kui lamp sind valgustaks!“ ");
INSERT INTO ekk_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kui Jeesus oli rääkimise lõpetanud, kutsus keegi variser teda enda juurde sööma. Ta läks ja istus lauda. ");
INSERT INTO ekk_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Aga variser oli üllatunud, et Jeesus enne sööki käsi ei pesnud. ");
INSERT INTO ekk_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Issand ütles talle: „Teie, variserid, puhastate karika ja kausi väljastpoolt, aga seestpoolt olete täidetud kadeduse ja kurjusega. ");
INSERT INTO ekk_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Te mõistmatud inimesed! Kas mitte tema, kes tegi välise, ei teinud ka sisemise? ");
INSERT INTO ekk_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ent andke kausis olev vaestele, ja siis on teie jaoks kõik puhas! ");
INSERT INTO ekk_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Häda teile, variserid, et te annate kümnist mündist, ruudist ja igast maitsetaimest, aga te ei hooli õiglusest ja Jumala armastusest. Te peaksite tegema teist, jätmata esimest unarusse. ");
INSERT INTO ekk_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Häda teile, variserid, et te armastate tähtsaid istmeid sünagoogides ja tervitusi turuplatsidel. ");
INSERT INTO ekk_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Häda teile, et te olete kui tähistamata hauad, millel inimesed teadmata kõnnivad.“ ");
INSERT INTO ekk_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Üks kirjatundja vastas talle: „Õpetaja, seda öeldes sa solvad ka meid.“ ");
INSERT INTO ekk_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jeesus aga vastas: „Häda ka teile, kirjatundjad, sest te rõhute inimesi koormatega, mida nad vaevu suudavad kanda, ja te ise ei liiguta nende aitamiseks sõrmegi! ");
INSERT INTO ekk_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Häda teile, sest te ehitate prohvetitele haudu, teie esiisad on nad aga tapnud! ");
INSERT INTO ekk_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nii te ise tunnistate, et kiidate heaks oma esiisade teod. Nemad tapsid prohvetid, aga teie ehitate neile hauad. ");
INSERT INTO ekk_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Seepärast ütleb Jumal oma tarkuses: „Ma saadan neile prohvetid ja apostlid, osa neist nad tapavad ja teisi kiusavad taga.“ ");
INSERT INTO ekk_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Sellepärast vastutab see sugupõlv kõigi prohvetite vere eest, mis on valatud maailma algusest peale, ");
INSERT INTO ekk_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aabeli verest kuni Sakarja vereni, kes tapeti altari ja templi vahel. Jah, ma ütlen teile, see sugupõlv vastutab kõige selle eest! ");
INSERT INTO ekk_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Häda teile, kirjatundjad, sest te olete ära võtnud teadmise võtme. Ise te sisse ei läinud, aga olete takistanud neid, kes tahavad minna!“ ");
INSERT INTO ekk_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kui Jeesus sealt lahkus, hakkasid variserid ja kirjatundjad talle vihaselt vastu teda küsimustega rünnates ja ");
INSERT INTO ekk_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","oodates, et ta ütleks midagi, millest kinni hakata. ");
INSERT INTO ekk_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Vahepeal, kui kokku oli kogunenud mitmetuhandeline rahvahulk, nii et üksteise peal tallati, kõneles Jeesus esmalt oma jüngritele: „Olge valvel variseride juuretise pärast, mis on silmakirjalikkus! ");
INSERT INTO ekk_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Midagi ei ole varjatut, mida ei paljastataks, ega salajast, mis teatavaks ei saaks. ");
INSERT INTO ekk_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mis te olete pimedas öelnud, saab kuuldavaks valges, ja mida te kõrva sosistate salakambrites, seda kuulutatakse katustelt. ");
INSERT INTO ekk_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ma ütlen teile, sõbrad, ärge kartke neid, kes ihu tapavad ja pärast seda ei saa midagi teha! ");
INSERT INTO ekk_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Aga ma näitan teile, keda te peate kartma: kartke teda, kellel on meelevald teid pärast tapmist heita põrgusse! Jah, ma ütlen teile, teda kartke! ");
INSERT INTO ekk_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kas ei müüda viit varblast kahe penni eest? Ometi pole Jumal unustanud ühtki neist. ");
INSERT INTO ekk_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ent teie juuksekarvadki on kõik ära loetud. Ärge kartke, te olete rohkem väärt kui palju varblasi. ");
INSERT INTO ekk_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ma ütlen teile, et igaüks, kes mind tunnistab inimeste ees, teda tunnistab ka Inimese Poeg Jumala inglite ees. ");
INSERT INTO ekk_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Aga kes mind ära salgab inimeste ees, salatakse ära ka Jumala inglite ees. ");
INSERT INTO ekk_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Igaühele, kes ütleb sõna Inimese Poja vastu, antakse andeks, aga kes teotab Püha Vaimu, sellele ei andestata. ");
INSERT INTO ekk_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Kui teid viiakse sünagoogidesse ning võimude ja valitsejate ette, siis ärge muretsege, kuidas end kaitsta või mida öelda, ");
INSERT INTO ekk_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","sest sel hetkel õpetab Püha Vaim teile, mida te peate ütlema.“ ");
INSERT INTO ekk_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Keegi rahva seast ütles talle: „Õpetaja, käsi mu vennal jagada pärandus minuga!“ ");
INSERT INTO ekk_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jeesus vastas: „Kes mind on määranud teie vahele kohtunikuks või õigusemõistjaks?“ ");
INSERT INTO ekk_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Siis ta ütles neile: „Olge valvel igasuguse ahnuse pärast, sest inimese elu ei seisne tema omandi külluses.“ ");
INSERT INTO ekk_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ja siis ta rääkis neile tähendamissõna: „Ühe rikka mehe põld andis hea saagi. ");
INSERT INTO ekk_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ta mõtles endamisi: „Mida ma pean tegema? Mul pole kuhugi oma saaki panna.“ ");
INSERT INTO ekk_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ja ta ütles: „Ma teen nii: ma lõhun maha oma aidad ja ehitan suuremad, kuhu ma kogun vilja ülejäägi. ");
INSERT INTO ekk_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ja ma ütlen iseendale: „Sul on kõrvale pandud külluses vara paljudeks aastateks. Puhka, söö, joo ja ole rõõmus!“ “ ");
INSERT INTO ekk_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Aga Jumal ütles talle: „Sina rumal! Selsamal ööl võetakse sinult su elu. Aga kes saab siis selle, mis sa oled endale soetanud?“ ");
INSERT INTO ekk_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nii on igaühega, kes kogub asju enda jaoks, kuid ei ole rikas Jumalas.“ ");
INSERT INTO ekk_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Siis Jeesus ütles jüngritele: „Seepärast ma ütlen teile, ärge muretsege oma elu pärast, mida süüa, ega ihu pärast, mida selga panna, ");
INSERT INTO ekk_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","sest elu on enam kui toit ja ihu enam kui rõivad. ");
INSERT INTO ekk_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Vaadake kaarnaid – nad ei külva ega lõika, neil ei ole hoiuruumi ega aita, ometi Jumal toidab neid. Kui palju enam väärt lindudest olete teie! ");
INSERT INTO ekk_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Aga kes teie seast suudaks muretsemisega ennast ühe küünragi pikemaks teha? ");
INSERT INTO ekk_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ja kui te seda väikest asja ei suuda, milleks siis teiste asjade pärast muretseda! ");
INSERT INTO ekk_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Vaadake, kuidas lilled kasvavad! Nad ei tööta ega ketra. Siiski ma ütlen teile, isegi Saalomon kogu oma hiilguses ei olnud riietatud nii nagu igaüks neist. ");
INSERT INTO ekk_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kui aga Jumal niimoodi riietab väljal rohtu, mis täna on, aga homme heidetakse tulle, kui palju enam ta riietab siis teid, te nõdrausulised! ");
INSERT INTO ekk_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ärge muretsege selle pärast, mida süüa või juua, ärge vaevake ennast sellega. ");
INSERT INTO ekk_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sest kõigi nende asjade järel jookseb paganlik maailm, kuid teie Isa ju teab, et te seda vajate. ");
INSERT INTO ekk_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pigem otsige tema kuningriiki, ja see kõik antakse teile samuti! ");
INSERT INTO ekk_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ära karda, väike karjake, sest teie Isal on hea meel anda teile kuningriik! ");
INSERT INTO ekk_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Müüge enda omand ja andke tulu vaestele! Varuge enesele kulumatud kukrud ja soetage püsiv varandus taevas, kuhu varas ei tule ja mida koi ei riku. ");
INSERT INTO ekk_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sest kus on su varandus, seal on ka su süda! ");
INSERT INTO ekk_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Olge riietatud teenimiseks ja hoidke oma lambid põlemas ");
INSERT INTO ekk_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","nagu inimesed, kes ootavad isandat pulmapeolt koju. Et kui ta tuleb ja koputab, on nad otsekohe valmis talle ust avama. ");
INSERT INTO ekk_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Õnnistatud on need sulased, kelle isand saabudes leiab nad ootamas. Ma kinnitan teile: ta riietab end teenimiseks, paneb nad lauda istuma ja toidab neid. ");
INSERT INTO ekk_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Õnnistatud on need sulased, kelle isand leiab nad valvamas, isegi kui ta tuleb teise või kolmanda vahikorra ajal öösel. ");
INSERT INTO ekk_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Küllap te mõistate, et kui peremees teaks, millisel öötunnil varas tuleb, ei laseks ta oma majja sisse murda. ");
INSERT INTO ekk_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ka teie olge valmis, sest Inimese Poeg tuleb tunnil, mil te ei arvagi!“ ");
INSERT INTO ekk_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peetrus küsis: „Issand, kas sa räägid seda tähendamissõna meile või kõikidele?“ ");
INSERT INTO ekk_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Issand vastas: „Kes küll on ustav ja arukas majapidaja, kelle isand seab oma sulaste üle neid õigel ajal toitma? ");
INSERT INTO ekk_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Õnnistatud on sulane, kelle ta isand tulles leiab nõnda tegevat! ");
INSERT INTO ekk_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tõesti, ma ütlen teile, ta annab tema hoolde kogu oma vara. ");
INSERT INTO ekk_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Aga kui see sulane mõtleb: „Mu isanda tulek viibib,“ ning hakkab peksma teisi sulaseid ja tüdrukuid, sööma ja jooma ja purjutama, ");
INSERT INTO ekk_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","siis selle sulase isand tuleb päeval, mil ta ei oota, ja tunnil, mida ta ei tea. Ta raiub sulase tükkideks ja annab talle sama koha uskmatutega. ");
INSERT INTO ekk_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","See sulane, kes küll teab oma isanda tahtmist, kuid ei valmistu ega tee tema tahtmise järgi, saab palju peksa. ");
INSERT INTO ekk_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kuid kes ei tea, aga teeb karistamist väärivaid asju, saab peksa vähem. Igaühelt, kellele on antud palju, nõutakse palju, ja kellele on usaldatud palju, sellelt küsitakse palju rohkem. ");
INSERT INTO ekk_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Tuld olen ma tulnud tooma maa peale, ja kuidas ma soovin, et see oleks juba süttinud! ");
INSERT INTO ekk_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Aga mul on vaja läbi minna ristimisest! Ja millise koorma all ma olen, kuni see on lõpetatud! ");
INSERT INTO ekk_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kas te arvate, et ma tulin rahu tooma maa peale? Ei, üldse mitte, vaid lahkmeelt. ");
INSERT INTO ekk_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nüüdsest on ühes peres viis üksteise vastu lahkmeeles: kolm kahe vastu ja kaks kolme vastu. ");
INSERT INTO ekk_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Lahkmeeles on isa poja vastu ja poeg isa vastu, ema tütre vastu ja tütar ema vastu, ämm minia vastu ja minia ämma vastu.“ ");
INSERT INTO ekk_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jeesus ütles ka rahvahulgale: „Kui te näete pilve tõusmas läänest, ütlete kohe: „Läheb vihmale.“ Ja nii ta läheb. ");
INSERT INTO ekk_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ja kui puhub lõunatuul, siis te ütlete: „Läheb palavaks.“ Ja nõnda see on. ");
INSERT INTO ekk_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Te silmakirjatsejad! Maa ja taeva ilmeid te teate, kuidas tõlgendada! Aga kuidas te siis praegust aega ei oska tõlgendada? ");
INSERT INTO ekk_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Miks te ise ei otsusta, mis on õige? ");
INSERT INTO ekk_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kui sa oma vastasega lähed valitseja ette, püüa temaga ruttu teel olles ära leppida, et ta sind ei veaks kohtuniku juurde ja kohtunik ei annaks sind kohtuteenri kätte ja kohtuteener ei heidaks sind vanglasse. ");
INSERT INTO ekk_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ma ütlen sulle, sa ei pääse sealt enne, kui sa oled tagasi maksnud viimsegi veeringu.“ ");
INSERT INTO ekk_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Samal ajal olid seal mõned, kes rääkisid Jeesusele galilealastest, kelle verd oli Pilaatus seganud nende ohvriandide sisse. ");
INSERT INTO ekk_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jeesus vastas: „Kas te arvate, et need galilealased olid patusemad kui teised, et nad niimoodi kannatasid? ");
INSERT INTO ekk_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ma ütlen teile – ei. Kui teie ei paranda meelt, hukkute ka teie. ");
INSERT INTO ekk_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Või need kaheksateist, kes said surma, kui Siiloahi torn nende peale langes – kas te arvate, et nad olid rohkem süüdi kui kõik teised, kes Jeruusalemmas elavad? ");
INSERT INTO ekk_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ma ütlen teile – ei! Aga kui te meelt ei paranda, hukkute samamoodi.“ ");
INSERT INTO ekk_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Siis ta rääkis neile tähendamissõna: „Ühel mehel oli viigipuu istutatud viinamäele ja ta läks selle juurde vilja otsima, kuid ei leidnud. ");
INSERT INTO ekk_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Siis ta ütles aednikule: „Juba kolm aastat käin ma sellelt viigipuult vilja otsimas, kuid ei leia. Raiu see maha! Mis ta raiskab mulda!“ ");
INSERT INTO ekk_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","„Isand,“ vastas mees, „las see olla veel üks aasta: ma kaevan selle ümber ja panen sõnnikut. ");
INSERT INTO ekk_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Võib-olla kannab see järgmisel aastal vilja. Kui mitte, siis raiun ta maha!“ “ ");
INSERT INTO ekk_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jeesus oli õpetamas ühes sünagoogis hingamispäeval ");
INSERT INTO ekk_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ja seal oli naine, keda vaim oli hoidnud kaheksateist aastat haigena. Ta käis kõveras ega saanud ennast sirgu ajada. ");
INSERT INTO ekk_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Teda nähes kutsus Jeesus ta enda juurde ja ütles talle: „Naine, sind on tehtud vabaks su haigusest!“ ");
INSERT INTO ekk_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ja ta pani käed tema peale ning otsekohe läks ta sirgeks ja kiitis Jumalat. ");
INSERT INTO ekk_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sünagoogi ülem oli vihane sellepärast, et Jeesus tervendas hingamispäeval, ja ta ütles inimestele: „Kuus päeva on töö tegemiseks. Tulge ja saage terveks nendel päevadel, mitte hingamispäeval!“ ");
INSERT INTO ekk_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Issand vastas talle: „Te silmakirjatsejad! Eks igaüks teist vabasta ka hingamispäeval oma härja või eesli sõime küljest ja vii teda jooma? ");
INSERT INTO ekk_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kas siis ei peaks see naine, Aabrahami tütar, keda saatan juba kaheksateist aastat on hoidnud seotuna, saama vabaks sellest hingamispäeval?“ ");
INSERT INTO ekk_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Selle ütlusega said tema vastased häbistatud, aga rahvas rõõmustas auliste tegude pärast, mida ta korda saatis. ");
INSERT INTO ekk_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Siis Jeesus küsis: „Mille sarnane on Jumala riik? Millega ma peaksin seda võrdlema? ");
INSERT INTO ekk_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","See on kui sinepiseeme, mille mees võttis ja oma aeda istutas. See kasvas ja sai puuks ja linnud pesitsesid selle okstes.“ ");
INSERT INTO ekk_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ja jälle ta küsis: „Millega ma veel peaksin võrdlema Jumala riiki? ");
INSERT INTO ekk_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","See on kui juuretis, mille naine võttis ja segas umbes kolmekümne kilogrammi jahu sekka, kuni kogu taigen läks hapnema.“ ");
INSERT INTO ekk_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jeesus käis läbi linnade ja külade, õpetades ja jätkates teed vaatega Jeruusalemmale. ");
INSERT INTO ekk_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Keegi küsis temalt: „Issand, kas ainult vähesed saavad päästetud?“ Ta ütles neile: ");
INSERT INTO ekk_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","„Tehke kõik selleks, et minna sisse kitsast uksest, sest paljud, ma ütlen teile, püüavad siseneda, aga ei suuda! ");
INSERT INTO ekk_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Pärast seda, kui majaperemees üles tõuseb ja ukse sulgeb, seisate te väljas ja palute: „Issand, ava meile uks!“ Aga ta vastab: „Ma ei tea, kes te olete või kust te tulete.“ ");
INSERT INTO ekk_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Siis te ütlete: „Me sõime ja jõime koos sinuga ja sa õpetasid meie tänavatel.“ ");
INSERT INTO ekk_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Aga tema vastab: „Ma ei tea, kes te olete või kust te tulete. Minge minema, kõik te ülekohtused!“ ");
INSERT INTO ekk_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Seal on ulgumine ja hammaste kiristamine, kui te näete Aabrahami, Iisakut ja Jaakobit ja kõiki prohveteid Jumala riigis, teie aga olete välja tõugatud. ");
INSERT INTO ekk_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Inimesed tulevad idast ja läänest, põhjast ja lõunast ning istuvad pidulauda Jumala riigis. ");
INSERT INTO ekk_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tõesti, seal saavad viimased esimesteks, ja esimesed jäävad viimasteks.“ ");
INSERT INTO ekk_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Samal ajal tulid mõned variserid Jeesuse juurde ja ütlesid: „Lahku siit ja mine kuhugi mujale. Heroodes tahab sind tappa!“ ");
INSERT INTO ekk_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Aga tema vastas: „Minge ja öelge sellele rebasele: „Ma ajan kurje vaime välja ja teen inimesi terveks täna ja homme ning kolmandal päeval jõuan oma eesmärgini.“ ");
INSERT INTO ekk_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Igal juhul pean ma jätkama täna ja homme ja järgmisel päeval, sest tõepoolest, ükski prohvet ei saa surra väljaspool Jeruusalemma. ");
INSERT INTO ekk_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jeruusalemm, Jeruusalemm, kes sa tapad prohveteid ja viskad kividega surnuks sinu juurde läkitatuid! Kui tihti ma olen soovinud koguda su lapsi, nii nagu kana kogub oma poegi tiibade alla, aga te ei ole tahtnud! ");
INSERT INTO ekk_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Vaata, teie koda on maha jäetud. Ma ütlen teile, te ei näe mind enne, kui te ütlete: „Õnnistatud olgu, kes tuleb Issanda nimel!“ “ ");
INSERT INTO ekk_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ühel hingamispäeval, kui Jeesus läks tuntud variseri koju sööma, jälgiti teda tähelepanelikult. ");
INSERT INTO ekk_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tema ees oli üks mees, kes kannatas vesitõve käes. ");
INSERT INTO ekk_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jeesus küsis variseridelt ja kirjatundjatelt: „Kas hingamispäeval tohib tervendada või mitte?“ ");
INSERT INTO ekk_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nemad aga vaikisid. Ta puudutas meest, tegi ta terveks ja saatis ära. ");
INSERT INTO ekk_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Siis ta küsis neilt: „Kui teist kellegi poeg või härg kukub kaevu hingamispäeval, kas te siis ei tõmba teda kohe välja?“ ");
INSERT INTO ekk_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ja neil ei olnud midagi öelda. ");
INSERT INTO ekk_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kui ta märkas külalisi laua ääres aulisemaid istekohti valimas, rääkis ta neile tähendamissõna: ");
INSERT INTO ekk_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","„Kui sind keegi kutsub pulma, ära võta endale aulist kohta, sest võib-olla on keegi kutsutu sinust auväärsem. ");
INSERT INTO ekk_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ja siis tuleb peremees, kes teid mõlemaid kutsus, sinu juurde ja ütleb: „Anna koht temale!“ Ja sa pead häbistatuna võtma kõige viimase koha. ");
INSERT INTO ekk_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Aga kui sa oled kutsutud, siis võta kõige tagasihoidlikum koht, et kui peremees tuleb ja sulle ütleb: „Sõber, tule paremale kohale!“, siis sind austatakse kõigi teiste külaliste juuresolekul. ");
INSERT INTO ekk_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sest igaüht, kes ennast ise ülendab, alandatakse, ja kes ennast ise alandab, seda ülendatakse!“ ");
INSERT INTO ekk_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Siis ütles Jeesus oma võõrustajale: „Kui sa pakud lõuna- või õhtusööki, siis ära kutsu oma sõpru, vendi ja õdesid, sugulasi või rikkaid naabreid, sest kui sa seda teed, võivad nad tasuks sind vastu kutsuda. ");
INSERT INTO ekk_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Vaid kui sa pakud pidusööki, siis kutsu vaeseid ja vigaseid ja jalutuid ja pimedaid, ");
INSERT INTO ekk_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ja sa saad õnnistatud. Sest nemad ei saa sulle tasuda, vaid see tasutakse sulle õigete ülestõusmisel.“ ");
INSERT INTO ekk_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kui aga üks nendest lauas istujatest seda kuulis, ütles ta Jeesusele: „Õnnistatud on see, kes sööb pidulauas Jumala riigis!“ ");
INSERT INTO ekk_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jeesus vastas: „Üks mees valmistas suure pidusöögi ja kutsus palju külalisi. ");
INSERT INTO ekk_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Määratud tunnil saatis ta sulased kutsutuile ütlema: „Tulge! Kõik on valmis!“ ");
INSERT INTO ekk_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Aga nemad kõik hakkasid vabandama. Esimene ütles: „Ma just ostsin põllu ja pean minema seda vaatama. Palun vabanda!“ ");
INSERT INTO ekk_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Teine ütles: „Ma just ostsin viis paari härgi ja lähen neid proovima. Palun vabanda mind!“ ");
INSERT INTO ekk_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ja veel üks ütles: „Ma just abiellusin ega saa tulla!“ ");
INSERT INTO ekk_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Siis sulane tuli tagasi ja teatas sellest peremehele. Majaperemees vihastas ja ütles sulasele: „Mine ruttu linna väljakutele ja tänavatele ja too siia vaesed, vigased, pimedad ja jalutud!“ ");
INSERT INTO ekk_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","„Isand,“ ütles sulane, „mis sa käskisid, on tehtud, aga veel on ruumi.“ ");
INSERT INTO ekk_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ja peremees ütles: „Mine välja teedele ja radadele ja veena inimesi tulema, et mu maja oleks täis!“ ");
INSERT INTO ekk_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ma ütlen teile, ükski kutsutuist ei saa minu pidusööki maitsta!“ ");
INSERT INTO ekk_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jeesust saatis suur rahvahulk. Ta ütles nende poole pöördudes: ");
INSERT INTO ekk_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","„Kui keegi minu juurde tuleb ega vihka oma isa ja ema, naist ja lapsi, vendi ja õdesid, ega tõepoolest ka omaenese elu, see ei saa olla minu jünger. ");
INSERT INTO ekk_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kes ei kanna oma risti ega järgne mulle, ei saa olla minu jünger. ");
INSERT INTO ekk_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kui keegi teie seast tahaks ehitada torni, kas ta ei istuks esmalt maha, et arvutada välja maksumus, ja kas tal selle lõpetamiseks raha jätkub? ");
INSERT INTO ekk_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Sest kui ta rajab vundamendi, aga ei suuda ehitust lõpetada, hakkab igaüks seda nähes teda pilkama: ");
INSERT INTO ekk_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","„See mees hakkas ehitama, aga ei suutnud lõpetada!“ ");
INSERT INTO ekk_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Või kui kuningas läheb sõtta teise kuninga vastu. Eks ta siis istu esmalt maha ja mõtle, kas ta on võimeline minema kümne tuhandega selle vastu, kes talle peale tuleb kahekümne tuhandega? ");
INSERT INTO ekk_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ja kui ta ei ole võimeline, eks ta läkita saadikuid paluma rahutingimusi, kui vastane on veel kaugel. ");
INSERT INTO ekk_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Samamoodi ei saa ükski teie seast, kes ei loobu kõigest, mis tal on, olla minu jünger. ");
INSERT INTO ekk_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sool on küll hea, aga kui sool kaotab maitse, kuidas siis sellele maitse tagasi anda? ");
INSERT INTO ekk_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","See ei kõlba mulda ega sõnnikuhunnikusse. See visatakse ära. Kel kõrvad on kuulda, see kuulgu!“ ");
INSERT INTO ekk_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kõik maksukogujad ja patused kogunesid teda kuulama. ");
INSERT INTO ekk_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Aga variserid ja kirjatundjad nurisesid: „See mees võtab vastu patuseid ja sööb koos nendega!“ ");
INSERT INTO ekk_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Siis Jeesus rääkis neile tähendamissõna: ");
INSERT INTO ekk_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","„Kui kellelgi teie hulgast oleks sada lammast ja ta ühe neist kaotaks, kas ta ei jätaks üheksakümmend üheksat tühermaale ega läheks kadunut otsima, kuni ta tema leiab? ");
INSERT INTO ekk_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ja kui ta on tema leidnud, võtab ta tema rõõmuga oma õlgadele ");
INSERT INTO ekk_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ja läheb koju. Ta kutsub kokku sõbrad ja naabrid ning ütleb: „Rõõmustage koos minuga, sest ma olen leidnud oma kadunud lamba!“ ");
INSERT INTO ekk_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ma ütlen teile, samamoodi on taevas ühe meelt parandanud patuse pärast rohkem rõõmu kui üheksakümne üheksa õige pärast, kellele ei ole vaja meeleparandust. ");
INSERT INTO ekk_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Või naine, kellel on kümme hõbemünti ja ta kaotab neist ühe. Kas ta ei süüta lampi ega pühi kogu maja ega otsi tähelepanelikult, kuni ta selle leiab? ");
INSERT INTO ekk_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ja kui ta selle on leidnud, kutsub ta kokku sõbrad ja naabrid ning ütleb: „Rõõmustage koos minuga, sest ma olen leidnud oma kadunud mündi!“ ");
INSERT INTO ekk_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Samamoodi, ma ütlen teile, rõõmustatakse Jumala inglite ees ühe patuse pärast, kes meelt parandab.“ ");
INSERT INTO ekk_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jeesus jätkas: „Ühel mehel oli kaks poega. ");
INSERT INTO ekk_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Noorem ütles isale: „Isa, anna mulle kätte minu osa pärandist!“ Ja ta jagas vara nende vahel. ");
INSERT INTO ekk_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mõne päeva pärast kogus noorem poeg kõik kokku ning läks kaugele maale ja raiskas prassides oma vara. ");
INSERT INTO ekk_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kui ta oli kõik ära kulutanud, tuli suur näljahäda sellele maale, ja talle tuli puudus kätte. ");
INSERT INTO ekk_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nii ta läks ühe kohaliku inimese juurde, kes saatis ta oma väljadele sigu karjatama. ");
INSERT INTO ekk_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ta igatses kõhtu täita kaunadega, mida sead sõid; aga ükski ei andnud talle. ");
INSERT INTO ekk_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kui ta arusaamisele tuli, ütles ta: „Kui paljudel minu isa palgalistel on toitu küllaga, aga mina suren siin nälga! ");
INSERT INTO ekk_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ma asun teele ja lähen tagasi oma isa juurde ja ütlen talle: „Isa, ma olen pattu teinud taeva vastu ja sinu vastu. ");
INSERT INTO ekk_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ma ei ole enam väärt, et mind su pojaks hüütaks! Tee mind üheks oma palgalistest!“ “ ");
INSERT INTO ekk_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nii ta tõusis ja läks oma isa juurde. Aga kui ta veel kaugel oli, nägi isa teda ja tal oli temast kahju. Ta jooksis pojale vastu, langes talle kaela ja suudles teda. ");
INSERT INTO ekk_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Poeg ütles talle: „Isa, ma olen teinud pattu taeva vastu ja sinu vastu. Ma ei ole enam väärt, et mind su pojaks hüütaks!“ ");
INSERT INTO ekk_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Aga isa ütles oma sulastele: „Ruttu! Tooge parim rüü ja pange talle selga! Pange sõrmus ta sõrme ja sandaalid talle jalga! ");
INSERT INTO ekk_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tooge nuumvasikas ja tapke see! Tehkem pidusöök ja rõõmustagem! ");
INSERT INTO ekk_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sest mu poeg oli surnud, aga ta elab jälle; ta oli kadunud, ja on leitud!“ Ja nii nad hakkasid pidutsema. ");
INSERT INTO ekk_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Samal ajal oli vanem poeg põllul. Kui ta kodule lähenes, kuulis ta muusikat ja tantsu. ");
INSERT INTO ekk_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ta kutsus ühe sulastest ja küsis, mis lahti on. ");
INSERT INTO ekk_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","„Su vend on tulnud koju,“ vastas ta, „ja su isa on tapnud nuumvasika, sest ta on tervena tagasi.“ ");
INSERT INTO ekk_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ent vanem vend vihastas ja keeldus sisse minemast. Siis tuli isa välja ja veenis teda. ");
INSERT INTO ekk_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tema aga vastas isale: „Vaata! Kõik need aastad olen ma orjanud ega ole kunagi astunud üle su käsust. Aga mulle pole sa andnud isegi noort sikku, et ma võiksin oma sõpradega pidutseda! ");
INSERT INTO ekk_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Aga kui see sinu poeg tuleb koju, kes su varanduse on hooradega ära raisanud, tapad sa talle nuumvasika!“ ");
INSERT INTO ekk_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","„Mu poeg,“ vastas isa, „sina oled alati minu juures, ja kõik, mis on mul, kuulub ka sulle. ");
INSERT INTO ekk_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nüüd aga oli meil tarvis pidutseda ja olla rõõmsad, sest see su vend oli surnud ja ta elab jälle, ta oli kadunud ja on leitud.“ “ ");
INSERT INTO ekk_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jeesus rääkis oma jüngritele: „Oli üks rikas mees, kelle majapidajat süüdistati tema vara raiskamises. ");
INSERT INTO ekk_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mees kutsus majapidaja ja küsis: „Mis see on, mis ma sinu kohta kuulen? Anna aru oma tööst, sest sa ei saa enam majapidaja olla!“ ");
INSERT INTO ekk_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Majapidaja mõtles: „Mis ma nüüd teen? Peremees võtab mu töö ära! Ma ei ole nii tugev, et kraavi kaevata ja mul on häbi kerjata; ");
INSERT INTO ekk_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ma tean, mida ma teen, et inimesed kutsuksid mind oma kodudesse, kui ma kaotan siin oma töö!“ ");
INSERT INTO ekk_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nii ta kutsus enda juurde kõik peremehe võlgnikud. Ta küsis esimese käest: „Kui palju sa oled võlgu mu peremehele?“ ");
INSERT INTO ekk_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","„Sada tünni oliiviõli,“ vastas see. Majapidaja ütles talle: „Võta oma arveraamat, istu kähku maha ja kirjuta selle asemel kaheksakümmend!“ ");
INSERT INTO ekk_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Siis ta küsis teise käest: „Aga kui palju sina võlgned?“ „Kolmkümmend vakka nisu,“ ta vastas. Ta ütles temale: „Võta oma arveraamat ja kirjuta selle asemel kakskümmend neli!“ ");
INSERT INTO ekk_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Peremees kiitis ebaausat majapidajat, sest ta oli nutikalt toiminud. Sest selle maailma inimesed on omasuguste suhtes nutikamad kui valguse lapsed. ");
INSERT INTO ekk_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ma ütlen teile, kasutage maist vara, et endale sõpru leida, et kui see on läinud, teid võetaks vastu igavesse kodusse. ");
INSERT INTO ekk_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kes on ustav piskus, see on ustav ka paljus, ja kes on ebaaus piskus, see on ebaaus ka paljus. ");
INSERT INTO ekk_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kui te nüüd maist vara käsutades ei ole olnud ustavad, kes usaldaks teile siis tõelised rikkused? ");
INSERT INTO ekk_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ja kui te võõra varaga ei ole olnud ustavad, kes annaks siis teie kätte teie oma vara? ");
INSERT INTO ekk_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ükski sulane ei või teenida kahte isandat: ta kas vihkab üht ja armastab teist või kiindub ühesse ja jälestab teist. Teiegi ei saa teenida korraga Jumalat ja mammonat!“ ");
INSERT INTO ekk_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Aga seda kõike kuulsid variserid, kes olid ahned, ja irvitasid Jeesuse üle. ");
INSERT INTO ekk_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ta ütles neile: „Teie olete need, kes õigustavad endid inimeste ees, aga Jumal teab teie südameid. Mida inimesed hindavad kõrgelt, on Jumala silmis jälestusväärne. ");
INSERT INTO ekk_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Seadust ja Prohveteid kuulutati kuni Johanneseni. Sellest ajast peale kuulutatakse Jumala riiki ja igaüks pressib sinna sisse. ");
INSERT INTO ekk_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Maa ja taevas kaovad kergemini kui üksainus kriips Seadusest. ");
INSERT INTO ekk_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Igaüks, kes lahutab oma naisest ja abiellub teisega, rikub abielu, ja mees, kes abiellub lahutatud naisega, rikub abielu. ");
INSERT INTO ekk_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Oli üks rikas mees, kes kandis purpurist ja peenest linasest rõivaid ja elas luksuslikult iga päev. ");
INSERT INTO ekk_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tema värava ees lamas kerjus nimega Laatsarus, kes oli täis paiseid ");
INSERT INTO ekk_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ja igatses süüa seda, mis rikka mehe laualt maha pudenes. Isegi koerad tulid ja lakkusid tema paiseid. ");
INSERT INTO ekk_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Saabus aeg, kui kerjus suri ja inglid kandsid ta Aabrahami sülle. Rikas mees suri samuti ja maeti maha. ");
INSERT INTO ekk_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Põrgus piineldes vaatas ta üles ja nägi Aabrahami kaugelt ja Laatsarust tema süles. ");
INSERT INTO ekk_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ta hüüdis talle: „Isa Aabraham, ole mulle armuline ja saada Laatsarus, et ta kastaks oma sõrme vette ja jahutaks mu keelt, sest ma piinlen selles tules!“ ");
INSERT INTO ekk_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Aga Aabraham vastas: „Poeg, kas sa mäletad, et sa said oma hea põlve eluajal kätte, samal ajal kui Laatsarus halva; nüüd lohutatakse teda siin, sina aga oled piinas. ");
INSERT INTO ekk_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Lisaks sellele on meie ja teie vahele seatud suur kuristik, et need, kes tahavad siit teie juurde minna, ei saa, ega tulda ka sealt siia.“ ");
INSERT INTO ekk_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ta vastas: „Siis ma anun sind, isa, saada Laatsarus mu isa majja, ");
INSERT INTO ekk_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","sest mul on viis venda. Las ta hoiatab neid, et ka nemad ei satuks sellesse piinakohta!“ ");
INSERT INTO ekk_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kuid Aabraham vastas: „Neil on Mooses ja Prohvetid, kuulaku neid!“ ");
INSERT INTO ekk_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","„Ei, isa Aabraham,“ ütles ta, „vaid kui keegi surnuist nende juurde läheks, siis parandaksid nad meelt!“ ");
INSERT INTO ekk_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aabraham aga ütles talle: „Kui nad ei kuula Moosest ja Prohveteid, ei veena neid isegi see, kui keegi surnuist üles tõuseks!“ “ ");
INSERT INTO ekk_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jeesus rääkis oma jüngritele: „On võimatu, et ei tuleks ahvatlusi patule, aga häda sellele, kelle kaudu need tulevad. ");
INSERT INTO ekk_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Talle oleks parem, kui ta merre heidetaks veskikivi kaelas, kui et ta ahvatleb üht neist väikestest patule. ");
INSERT INTO ekk_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Vaadake ette! Kui su vend teeb pattu, manitse teda! Ja kui ta meelt parandab, anna talle andeks! ");
INSERT INTO ekk_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Isegi kui ta seitse korda päevas sinu vastu patustab ja seitse korda tuleb tagasi ja ütleb: „Ma kahetsen!“, andesta ikka talle!“ ");
INSERT INTO ekk_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apostlid ütlesid Issandale: „Suurenda meie usku!“ ");
INSERT INTO ekk_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Issand vastas: „Kui teie usk oleks väike nagu sinepiseeme, võiksite öelda sellele mooruspuule: „Juuri end välja ja istuta merre!“ ja see kuuletub teile. ");
INSERT INTO ekk_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kui kellelgi teist oleks sulane kündmas või karja hoidmas, kas ta ütleks väljalt tulnud sulasele „Tule nüüd, istu maha ja söö“? ");
INSERT INTO ekk_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Eks ta pigem ütleks „Valmista mulle õhtusöök, sea end valmis ning teeni mind, kuni ma söön ja joon, ning pärast seda söö ja joo ise“. ");
INSERT INTO ekk_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kas ta sulast selle eest tänab, et ta tegi, mida kästi? ");
INSERT INTO ekk_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nii ka teie: kui te olete teinud kõik, mida teil on kästud, siis öelge: „Me oleme tühised sulased ja täitsime ainult oma kohust.“ “ ");
INSERT INTO ekk_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Teel Jeruusalemma läks Jeesus mööda Samaaria ja Galilea vahelist piiri. ");
INSERT INTO ekk_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ühte külla minnes oli ta teel kümme pidalitõbist. Nad seisid eemal ");
INSERT INTO ekk_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ja hüüdsid valju häälega: „Jeesus, Õpetaja, halasta meie peale!“ ");
INSERT INTO ekk_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Neid nähes ütles Jeesus: „Minge näidake endid preestritele!“ Ja nii kui nad läksid, said nad puhtaks. ");
INSERT INTO ekk_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Üks neist tuli tagasi, kui ta nägi, et ta on tervendatud, ja kiitis valju häälega Jumalat. ");
INSERT INTO ekk_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ta langes Jeesuse jalge ette teda tänades. See mees oli samaarlane. ");
INSERT INTO ekk_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jeesus küsis: „Eks kõik kümme ole tehtud puhtaks? Kus on ülejäänud üheksa? ");
INSERT INTO ekk_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kas ühtki ei ole leidunud, kes annaks au Jumalale, peale selle võõramaalase?“ ");
INSERT INTO ekk_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ja ta ütles talle: „Tõuse üles ja mine! Sinu usk on sind tervendanud!“ ");
INSERT INTO ekk_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Aga kui variserid temalt küsisid, millal saabub Jumala riik, vastas Jeesus: „Jumala riik ei ole midagi, mida saab vaadelda, ");
INSERT INTO ekk_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ega ka öelda: „See on siin!“ või „Seal!“ sest vaata, Jumala riik on teie sees!“ ");
INSERT INTO ekk_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Aga oma jüngritele ütles ta: „Tuleb aeg, mil te igatsete näha üht Inimese Poja päevadest, kuid ei näe. ");
INSERT INTO ekk_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Siis öeldakse teile: „Ta on siin!“ või „Ta on seal!“ Ärge jookske nende järel! ");
INSERT INTO ekk_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sest Inimese Poeg on oma päeval otsekui välgusähvatus, mis valgustab taevast ühest servast teise. ");
INSERT INTO ekk_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kuid enne peab ta palju kannatama ja see sugupõlv hülgab ta. ");
INSERT INTO ekk_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nõnda nagu oli Noa päevil, saab olema ka Inimese Poja päevil: ");
INSERT INTO ekk_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","inimesed sõid ja jõid, võtsid naisi ja läksid mehele selle päevani, mil Noa läks laeva. Siis tuli veeuputus ja hävitas nad kõik. ");
INSERT INTO ekk_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Samamoodi oli ka Loti päevil. Inimesed sõid ja jõid, ostsid ja müüsid, istutasid ja ehitasid. ");
INSERT INTO ekk_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Aga sel päeval, mil Lott lahkus Soodomast, sadas taevast tuld ja väävlit ning hävitas nad kõik. ");
INSERT INTO ekk_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Täpselt samamoodi on sel päeval, mil Inimese Poeg ilmub. ");
INSERT INTO ekk_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kes sel päeval on katusel ja ta asjad on majas, ärgu mingu alla neid võtma. Samuti ärgu mingu väljal olija koju tagasi! ");
INSERT INTO ekk_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Meenutage Loti naist! ");
INSERT INTO ekk_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kes iganes oma elu püüab hoida, kaotab selle, ja kes iganes oma elu kaotab, leiab selle. ");
INSERT INTO ekk_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ma ütlen teile, sel ööl on kaks ühes voodis – üks võetakse ära, teine jäetakse maha. ");
INSERT INTO ekk_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kaks naist jahvatavad üheskoos – üks võetakse ära, teine jäetakse maha. ");
INSERT INTO ekk_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kaks meest on väljal – üks võetakse ära ja teine jäetakse maha.“ ");
INSERT INTO ekk_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nad küsisid: „Kuhu, Issand?“ Ta vastas: „Kus on korjus, sinna kogunevad raisakotkad!“ ");
INSERT INTO ekk_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jeesus rääkis oma jüngritele tähendamissõna sellest, et nad peavad alati palvetama ja mitte alla andma. ");
INSERT INTO ekk_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ta ütles: „Ühes linnas oli kohtunik, kes ei kartnud Jumalat ega hoolinud inimeste arvamusest. ");
INSERT INTO ekk_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Selles linnas oli ka lesknaine, kes tuli alatasa tema juurde palvega: „Anna mulle õigus mu vastase üle!“ ");
INSERT INTO ekk_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mõnda aega kohtunik keeldus. Aga lõpuks ta mõtles endamisi: „Kuigi ma ei karda Jumalat ega hooli inimeste arvamusest, ");
INSERT INTO ekk_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","siis kuna see lesk mind tüütab, vaatan, et ta saaks õiguse. Muidu vaevab ta mind oma mangumisega ära!“ “ ");
INSERT INTO ekk_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ja Issand ütles: „Kuulake, mida ebaõiglane kohtunik ütleb! ");
INSERT INTO ekk_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kas siis Jumal ei peaks tegema õigust oma valitutele, kes tema poole kisendavad päevad ja ööd? Kas ta peaks viivitama neile vastamisega? ");
INSERT INTO ekk_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ma ütlen teile, küll ta vaatab, et nad peagi õiguse saavad! Ometi, kui Inimese poeg tuleb, kas ta siis leiab usku maa pealt?“ ");
INSERT INTO ekk_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Mõnele neist, kes olid kindlad, et nad on Jumala silmis laitmatud ja seetõttu suhtusid teistesse üleolevalt, rääkis Jeesus selle tähendamissõna: ");
INSERT INTO ekk_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","„Kaks meest läksid templisse palvetama, üks oli variser ja teine maksukoguja. ");
INSERT INTO ekk_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Variser tõusis püsti ja palvetas: „Jumal, ma tänan sind, et mina ei ole selline nagu muud inimesed: röövlid ja kurjategijad, abielurikkujad, ega ka selline nagu see maksukoguja. ");
INSERT INTO ekk_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mina paastun kaks korda nädalas ja maksan kümnist kõigest, mis ma saan.“ ");
INSERT INTO ekk_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Aga maksukoguja seisis eemal. Ta ei julgenud isegi taevasse vaadata, vaid lõi endale vastu rinda ja ütles: „Oh Jumal, ole mulle patusele armuline!“ ");
INSERT INTO ekk_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ma ütlen teile, tema läks koju õigeks mõistetuna Jumala ees, mitte teine. Sest igaüht, kes ennast ise ülendab, alandatakse; aga kes ennast alandab, seda ülendatakse!“ ");
INSERT INTO ekk_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Inimesed tõid ka Jeesuse juurde lapsi, et ta neid puudutaks. Aga seda nähes jüngrid sõitlesid neid. ");
INSERT INTO ekk_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ent Jeesus kutsus lapsed enese juurde ja ütles: „Laske lapsed minu juurde tulla, ärge keelake neid, sest selliste päralt on Jumala riik. ");
INSERT INTO ekk_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tõesti, ma ütlen teile, kes Jumala riiki vastu ei võta nagu laps, ei pääse sinna sisse.“ ");
INSERT INTO ekk_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Üks valitseja küsis Jeesuselt: „Hea Õpetaja, mida ma pean tegema, et ma päriksin igavese elu?“ ");
INSERT INTO ekk_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","„Miks sa nimetad mind heaks?“ vastas Jeesus, „Keegi muu ei ole hea kui üks – Jumal. ");
INSERT INTO ekk_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Käske sa tead: ära riku abielu, ära tapa, ära varasta, ära anna valetunnistust, austa oma isa ja ema!“ ");
INSERT INTO ekk_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tema aga ütles: „Seda kõike olen ma pidanud poisieast alates.“ ");
INSERT INTO ekk_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Seda kuuldes ütles Jeesus talle: „Üks asi on sul veel puudu: müü ära kõik, mis sul on, ja jaga vaestele, ja sul on siis aare taevas, ning tule, järgne mulle!“ ");
INSERT INTO ekk_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Aga seda kuuldes muutus ta kurvaks, sest ta oli väga rikas. ");
INSERT INTO ekk_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jeesus vaatas teda ja ütles: „Kui raske on rikastel pääseda Jumala riiki! ");
INSERT INTO ekk_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Hõlpsam on kaamelil minna läbi nõelasilma kui rikkal minna Jumala riiki.“ ");
INSERT INTO ekk_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ent kuulajad küsisid: „Kes siis võib saada päästetud?“ ");
INSERT INTO ekk_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jeesus vastas: „Mis inimestele on võimatu, on Jumalale võimalik!“ ");
INSERT INTO ekk_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peetrus ütles: „Me oleme kõigest loobunud, et sulle järgneda.“ ");
INSERT INTO ekk_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","„Tõesti, ma ütlen teile,“ vastas Jeesus, „ei ole kedagi, kes on loobunud kodust või naisest või vendadest ja õdedest või vanematest või lastest Jumala riigi pärast, ");
INSERT INTO ekk_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kes mitmekordselt tagasi ei saaks sellel ajal ja tuleval ajastul igaveses elus.“ ");
INSERT INTO ekk_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jeesus võttis endaga kaksteist jüngrit ja ütles neile: „Me läheme üles Jeruusalemma ja seal täitub kõik see, mis prohvetid on kirjutanud Inimese Poja kohta! ");
INSERT INTO ekk_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ta antakse rahvaste kätte. Teda teotatakse, solvatakse ja tema peale sülitatakse, ");
INSERT INTO ekk_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","nad peksavad teda ja tapavad ta. Ja kolmandal päeval tõuseb ta üles.“ ");
INSERT INTO ekk_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jüngrid ei mõistnud sellest midagi. See sõna oli nende eest varjatud ja nad ei teadnud, millest ta räägib. ");
INSERT INTO ekk_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Aga kui Jeesus Jeerikole lähenes, istus üks pime mees tee ääres ja kerjas. ");
INSERT INTO ekk_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kui ta kuulis rahvahulka möödumas, päris ta, mis lahti on. ");
INSERT INTO ekk_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nad teatasid: „Naatsareti Jeesus läheb mööda!“ ");
INSERT INTO ekk_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ja ta hüüdis: „Jeesus, Taaveti Poeg, halasta minu peale!“ ");
INSERT INTO ekk_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Möödujad sõitlesid teda ja käskisid tal vait olla, aga tema hüüdis seda enam: „Taaveti Poeg, halasta minu peale!“ ");
INSERT INTO ekk_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jeesus peatus ja käskis pimeda enda juurde tuua. Aga kui pime lähemale tuli, küsis Jeesus temalt: ");
INSERT INTO ekk_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","„Mida sa tahad, et ma sulle teeksin?“ „Issand, ma tahan näha!“ vastas ta. ");
INSERT INTO ekk_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jeesus ütles talle: „Võta vastu oma nägemine! Sinu usk on su terveks teinud!“ ");
INSERT INTO ekk_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Otsekohe nägi ta jälle ja järgnes Jeesusele Jumalat kiites. Kui inimesed seda nägid, kiitsid ka nemad Jumalat. ");
INSERT INTO ekk_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Kui Jeesus jõudis Jeerikosse, läks ta sealt läbi. ");
INSERT INTO ekk_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Seal oli mees nimega Sakkeus; ta oli maksukogujate ülem ja ta oli rikas. ");
INSERT INTO ekk_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Sakkeus tahtis näha, kes Jeesus on, aga ei näinud üle rahvahulga, sest ta oli lühikest kasvu. ");
INSERT INTO ekk_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ta jooksis ettepoole ja ronis metsviigipuu otsa, et teda näha, sest Jeesus pidi sealtkaudu minema. ");
INSERT INTO ekk_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kui Jeesus selle kohani jõudis, vaatas ta üles ja ütles: „Sakkeus, tule kohe alla! Ma pean täna sinu kodus peatuma!“ ");
INSERT INTO ekk_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakkeus tuli alla ja võttis ta rõõmsalt vastu. ");
INSERT INTO ekk_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Seda nähes nurisesid kõik: „Tema on patuse mehe juurde külla läinud!“ ");
INSERT INTO ekk_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kuid Sakkeus ütles Issanda ette astudes: „Vaata, Issand! Siin ja praegu annan ma poole oma varandusest vaestele, ja kui oma olen kelleltki midagi välja petnud, maksan selle neljakordselt tagasi.“ ");
INSERT INTO ekk_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Siis Jeesus ütles temale: „Pääste on tulnud täna sellesse majja, sest ka see mees on Aabrahami poeg. ");
INSERT INTO ekk_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Sest Inimese Poeg on tulnud otsima ja päästma kadunut.“ ");
INSERT INTO ekk_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kui nad teda kuulasid, rääkis Jeesus veel ühe tähendamissõna, sest ta oli Jeruusalemma lähedal ja inimesed arvasid, et Jumala riik saabub kohe. ");
INSERT INTO ekk_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ta ütles: „Üks kõrgest soost mees reisis kaugele maale, et lasta end seal määrata kuningaks ja siis tulla tagasi. ");
INSERT INTO ekk_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Niisiis ta kutsus kümme oma sulastest ja andis neile kümme naela raha: „Kaubelge seni, kuni ma tagasi tulen!“ ");
INSERT INTO ekk_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Aga tema alamad vihkasid teda ja läkitasid saadikud talle järele ütlema: „Me ei taha seda meest endale kuningaks!“ ");
INSERT INTO ekk_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Aga ta sai kuningaks ja läks tagasi koju. Ta käskis kutsuda need sulased, kellele ta oli raha andnud, et näha, kui palju nad olid teeninud. ");
INSERT INTO ekk_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Esimene tuli ja ütles: „Isand, sinu nael on kümme juurde teeninud.“ ");
INSERT INTO ekk_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","„Hästi tehtud, mu hea sulane!“ vastas peremees. „Kuna sa oled olnud ustav nii väheses, siis annan sulle meelevalla kümne linna üle.“ ");
INSERT INTO ekk_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Teine tuli ja ütles: „Isand, sinu nael on viis juurde teeninud.“ ");
INSERT INTO ekk_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Peremees vastas sellelegi: „Sina valitse viie linna üle!“ ");
INSERT INTO ekk_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Siis tuli järgmine sulane ja ütles: „Isand, siin on sinu nael, mida ma olen hoidnud taskurätikus. ");
INSERT INTO ekk_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ma kartsin sind, sest sa oled karm mees. Sa võtad sealt, kuhu ei ole pannud, ja lõikad, mida sa ei külvanud.“ ");
INSERT INTO ekk_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ta isand vastas: „Sinu enda sõnade põhjal ma mõistan su üle kohut, sa nurjatu sulane! Sa teadsid, et ma olen karm mees: võtan, kuhu ma ei ole pannud, ja lõikan, mida ma ei ole külvanud. ");
INSERT INTO ekk_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Miks sa siis ei pannud mu raha panka, et ma oleksin selle tagasi tulles kasuga tagasi saanud!“ ");
INSERT INTO ekk_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ja ta ütles juuresolijaile: „Võtke tema nael tema käest ära ja andke sellele, kellel on kümme naela!“ ");
INSERT INTO ekk_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","„Isand,“ ütlesid nemad, „tal on juba kümme!“ ");
INSERT INTO ekk_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ta vastas: „Ma ütlen teile, et igaühele, kellel on, antakse juurde, aga kellel ei ole, sellelt võetakse ära ka see, mis tal on. ");
INSERT INTO ekk_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aga need minu vaenlased, kes mind ei tahtnud enda kuningaks, tooge siia ja surmake minu ees!“ “ ");
INSERT INTO ekk_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ja kui Jeesus oli seda kõnelnud, jätkas ta teed Jeruusalemma. ");
INSERT INTO ekk_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nii kui ta jõudis Betfage ja Betaania lähedale mäe juurde, mida nimetatakse Õlimäeks, läkitas ta kaks oma jüngritest ning ütles: ");
INSERT INTO ekk_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","„Minge külla, mis on teie ees. Seal te leiate kinniseotud sälu, kelle seljas ei ole keegi istunud. Siduge see lahti ja tooge siia! ");
INSERT INTO ekk_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kui keegi teilt küsib: „Miks te selle lahti seote?“, siis öelge: „Issandal on teda tarvis!“ “ ");
INSERT INTO ekk_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Läkitatud läksid ja leidsid kõik täpselt nii, nagu Jeesus neile oli öelnud. ");
INSERT INTO ekk_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Aga kui nad sälu lahti sidusid, küsisid selle omanikud neilt: „Miks te sälu lahti seote?“ ");
INSERT INTO ekk_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ja nad vastasid: „Issand vajab teda!“ ");
INSERT INTO ekk_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nad tõid ta Jeesuse juurde, heitsid oma kuued sälu peale ja panid Jeesuse tema selga istuma. ");
INSERT INTO ekk_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kui ta edasi liikus, laotasid inimesed oma rõivad tee peale. ");
INSERT INTO ekk_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Aga kui ta jõudis kohani, kus tee läheb alla Õlimäe juurde, hakkas kogu jüngrite hulk rõõmustades valju häälega Jumalat kiitma kõigi imede eest, mida nad olid näinud: ");
INSERT INTO ekk_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","„Õnnistatud olgu kuningas, kes tuleb Issanda nimel!“ „Rahu taevas ja au kõige kõrgemal!“ ");
INSERT INTO ekk_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mõned variserid rahva hulgast ütlesid Jeesusele: „Õpetaja, sõitle oma jüngreid!“ ");
INSERT INTO ekk_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","„Ma ütlen teile,“ vastas ta, „kui nemad vaikiksid, hakkaksid kivid kisendama!“ ");
INSERT INTO ekk_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nii kui Jeesus Jeruusalemma lähedale jõudis ja linna nägi, nuttis ta tema pärast ");
INSERT INTO ekk_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ja ütles: „Kui ometi sinagi oleksid ära tundnud, mis sulle rahu toob – ent nüüd on see sinu silmade eest varjatud. ");
INSERT INTO ekk_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Sest päevad tulevad sinu peale, mil su vaenlased rajavad sinu ümber valli ja piiravad su sisse ja ahistavad sind igast küljest. ");
INSERT INTO ekk_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nad teevad su maatasa, sinu ja su lapsed koos müüridega. Nad ei jäta kivi kivi peale, sest sa ei tundnud ära aega, millal Jumal sinu juurde tuli.“ ");
INSERT INTO ekk_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jeesus läks templisse ja hakkas välja ajama neid, kes seal ostsid ja müüsid. ");
INSERT INTO ekk_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ta ütles neile: „Kirjutatud on: „Minu koda peab olema palvekoda“, aga teie olete teinud selle röövlikoopaks!“ ");
INSERT INTO ekk_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jeesus õpetas templis päevast päeva; aga ülempreestrid, kirjatundjad ja rahvavanemad otsisid võimalust teda tappa. ");
INSERT INTO ekk_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Siiski ei leidnud nad ühtki viisi, sest inimesed olid kogu aeg tema ümber tähelepanelikult kuulamas. ");
INSERT INTO ekk_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ühel päeval, kui Jeesus rahvast templis õpetas ja evangeeliumi kuulutas, tulid ülempreestrid ja kirjatundjad koos vanematega tema juurde ");
INSERT INTO ekk_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ja küsisid: „Ütle, millise meelevallaga sa neid asju teed? Kes sulle selle meelevalla on andnud?“ ");
INSERT INTO ekk_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jeesus vastas: „Mina tahan ka teie käest midagi küsida: ");
INSERT INTO ekk_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","kas Johannese ristimine oli taevast või inimestest?“ ");
INSERT INTO ekk_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nad aga arutasid omavahel: „Kui me ütleme, et taevast, siis ta küsib: „Miks te siis ei uskunud teda?“ ");
INSERT INTO ekk_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Aga kui me ütleme, et inimestest, siis rahvas viskab meid kividega surnuks, sest nemad on veendunud, et Johannes oli prohvet.“ ");
INSERT INTO ekk_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nii nad vastasid: „Me ei tea, kust see oli.“ ");
INSERT INTO ekk_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jeesus ütles: „Ega minagi ütle teile, millise meelevallaga ma seda teen.“ ");
INSERT INTO ekk_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ta jätkas ja rääkis rahvale selle tähendamissõna: „Üks mees istutas viinamäe ja andis selle rentnike kätte ja reisis ära. ");
INSERT INTO ekk_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Viljakoristamise ajal läkitas ta sulase tööliste juurde, et need annaksid talle osa tema viinamäe viljast. Aga rentnikud peksid teda ja saatsid ta minema tühjade kätega. ");
INSERT INTO ekk_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ta saatis veel teise sulase, aga ka teda nad peksid, käitusid häbiväärselt ning saatsid minema tühjade kätega. ");
INSERT INTO ekk_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ta saatis veel kolmandagi, aga nad haavasid ka teda ja tõukasid välja. ");
INSERT INTO ekk_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Siis mõtles viinamäe omanik: „Mis ma nüüd teen? Ma saadan oma armsa poja, ehk nad austavad teda.“ ");
INSERT INTO ekk_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Aga teda nähes arutasid rentnikud omavahel: „See on pärija! Tapame ta ära, et pärand saaks meile!“ ");
INSERT INTO ekk_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nii nad viskasid ta viinamäelt välja ja tapsid. Mida nüüd viinamäe omanik teeb nendega? ");
INSERT INTO ekk_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ta tuleb ja tapab need rentnikud ja annab viinamäe teiste kätte.“ Seda kuuldes nad ütlesid: „Seda ei tohi juhtuda!“ ");
INSERT INTO ekk_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jeesus küsis neile otsa vaadates: „Mida siis tähendab see kirjasõna: „Kivi, mille ehitajad pidasid kõlbmatuks, on saanud nurgakiviks?“ ");
INSERT INTO ekk_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Igaüks, kes selle kivi peale kukub, kukub end puruks, ja kelle peale see kivi langeb, selle see purustab.“ ");
INSERT INTO ekk_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kirjatundjad ja ülempreestrid otsisid võimalust teda kinni võtta, kuid nad kartsid inimesi. Nad said aru, et Jeesus oli selle tähendamissõna rääkinud nende kohta. ");
INSERT INTO ekk_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ja nad läkitasid Jeesust varitsema nuhid, kes teesklesid siiraid inimesi, et teda tabada sõnadelt ja teda ära anda maavalitseja võimusesse ja meelevalda. ");
INSERT INTO ekk_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ja nuhid küsitlesid teda: „Õpetaja, me teame, et sa räägid ja õpetad õigesti ega ole erapoolik, vaid õpetad Jumala teed kooskõlas tõega. ");
INSERT INTO ekk_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kas on õige maksta keisrile maksu või mitte?“ ");
INSERT INTO ekk_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Aga Jeesus nägi nende salakavaluse läbi ja ütles ta neile: ");
INSERT INTO ekk_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","„Näidake mulle teenarit! Kelle pilt ja kiri sellel on?“ „Keisri,“ vastasid nemad. ");
INSERT INTO ekk_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jeesus ütles neile: „Andke siis keisrile, mis kuulub keisrile, ja Jumalale, mis kuulub Jumalale!“ ");
INSERT INTO ekk_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ja nad ei saanud teda lõksu püüda sellega, mis ta oli avalikult öelnud. Ja olles hämmastunud tema vastusest, jäid nad vait. ");
INSERT INTO ekk_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Jeesuse juurde astusid mõned saduserid, kes eitavad surnuist ülestõusmist, ja küsisid temalt: ");
INSERT INTO ekk_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","„Õpetaja, Mooses on meile kirjutanud, et kui mehe vend sureb ja maha jääb naine, aga ei jää lapsi, siis peab see mees abielluma lesega ja vennale järglasi kasvatama. ");
INSERT INTO ekk_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Oli kord seitse venda. Esimene neist võttis naise ja suri lasteta. ");
INSERT INTO ekk_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Siis teine ");
INSERT INTO ekk_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ja kolmas abiellusid temaga ja samamoodi kõik seitse surid, jätmata järele ühtki last. ");
INSERT INTO ekk_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Lõpuks suri ka naine. ");
INSERT INTO ekk_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kuidas on surnute ülestõusmisel: kelle naine ta on, sest kõik seitse olid temaga abielus?“ ");
INSERT INTO ekk_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jeesus vastas: „Selle maailma inimesed võtavad naisi ja lähevad mehele. ");
INSERT INTO ekk_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kuid need, keda peetakse vääriliseks olema tulevases ajastus ja surnute ülestõusmises, ei võta naisi ega lähe mehele, ");
INSERT INTO ekk_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","sest nad ei saa ka enam surra; nad on inglite sarnased. Nemad on Jumala lapsed, sest nad on ülestõusmise lapsed. ");
INSERT INTO ekk_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Aga et surnud tõusevad üles, seda näitas isegi Mooses põleva põõsa loos, kui ta ütleb, et Issand on Aabrahami Jumal, Iisaki Jumal ja Jaakobi Jumal. ");
INSERT INTO ekk_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Jumal ei ole surnute, vaid elavate Jumal, sest tema jaoks on kõik elus.“ ");
INSERT INTO ekk_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Siis mõned kirjatundjad kostsid: „Hästi öeldud, Õpetaja!“ ");
INSERT INTO ekk_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ja keegi ei tihanud rohkem midagi küsida. ");
INSERT INTO ekk_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Siis Jeesus ütles neile: „Miks öeldakse, et Messias on Taaveti poeg? ");
INSERT INTO ekk_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Taavet ise ütleb Laulude raamatus: „Issand ütles minu Issandale: „Istu mu paremale käele, ");
INSERT INTO ekk_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kuni ma panen sinu vaenlased su jalge alla jalajäriks.“ “ ");
INSERT INTO ekk_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Taavet hüüab teda Issandaks, kuidas ta siis on tema poeg?“ ");
INSERT INTO ekk_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Aga ta ütles kogu rahva kuuldes jüngritele: ");
INSERT INTO ekk_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","„Hoiduge kirjatundjate eest! Neile meeldib kõndida lendlevates kuubedes ja nad armastavad aupaklikke tervitusi turuplatsidel ja esimesi istmeid sünagoogides ja aukohti pidulauas. ");
INSERT INTO ekk_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nad neelavad alla lesknaiste majad ja silmakirjaks peavad pikki palveid. Nad saavad seda rängema karistuse.“ ");
INSERT INTO ekk_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kui Jeesus tõstis pilgu, nägi ta rikkaid oma ande templi ohvrikasti panemas. ");
INSERT INTO ekk_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ta nägi ka üht vaest lesknaist, kes pani sinna kaks leptonit. ");
INSERT INTO ekk_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","„Tõesti, ma ütlen teile,“ ütles ta, „see vaene lesknaine andis rohkem kui keegi teine. ");
INSERT INTO ekk_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sest nemad panid oma küllusest, tema aga oma vaesusest kogu elatise, mis tal oli.“ ");
INSERT INTO ekk_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mõned tema jüngritest rääkisid templi kohta, et see on imeilusate kivide ning hinnaliste kingitustega Jumala jaoks kaunistatud. Jeesus ütles: ");
INSERT INTO ekk_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","„Tuleb aeg, kui sellest kõigest, mida te näete, ei jäeta kivi kivi peale, vaid kõik kistakse maha!“ ");
INSERT INTO ekk_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","„Õpetaja,“ küsisid nad, „millal see siis sünnib? Ja mis on tunnustäheks, et aeg on käes?“ ");
INSERT INTO ekk_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ta vastas: „Vaadake, et teid ei petetaks! Sest paljud tulevad minu nimel, kinnitades: „Mina olen see!“ ja „Aeg on lähedal!“ Ärge minge nende järel! ");
INSERT INTO ekk_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Aga kui te kuulete sõdadest ja rahutustest, siis ärge kartke! Need asjad peavad enne sündima, kuid lõpp ei ole veel käes.“ ");
INSERT INTO ekk_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Siis ta ütles neile: „Rahvas tõuseb rahva vastu ja kuningriik kuningriigi vastu. ");
INSERT INTO ekk_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tuleb suuri maavärinaid ja näljahäda ja katku ning hirmsaid sündmusi ja tunnustähti taevast. ");
INSERT INTO ekk_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Aga enne seda kõike panevad nad oma käed teie külge ja kiusavad teid taga. Nad annavad teid ära sünagoogidesse ja vanglatesse, teid viiakse kuningate ja valitsejate ette minu nime pärast. ");
INSERT INTO ekk_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ja nii te saate minust tunnistada. ");
INSERT INTO ekk_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ärge muretsege enneaegu oma südames, mida vastata enda kaitseks. ");
INSERT INTO ekk_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Sest mina annan teile sõnad ja tarkuse, mille vastu ei suuda seista ega rääkida ükski teie vastane. ");
INSERT INTO ekk_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ka teie vanemad, vennad ja õed, sugulased ja sõbrad annavad teid ära ning tapavad mõned teie seast. ");
INSERT INTO ekk_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ja teid vihkavad kõik inimesed minu nime pärast. ");
INSERT INTO ekk_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ent ükski juuksekarv ei hävi teie peast! ");
INSERT INTO ekk_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Seiske kindlalt, ja te võidate elu. ");
INSERT INTO ekk_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Aga kui te näete Jeruusalemma vaenlase vägede poolt piiratuna, siis teadke, et häving on lähedal. ");
INSERT INTO ekk_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Siis need, kes on Juudamaal, põgenegu mägedesse, ja need, kes on linnas, lahkugu kiiresti, ja need, kes on maal, ärgu mingu linna. ");
INSERT INTO ekk_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sest need on kättemaksupäevad, et läheks täide, mis on kirjutatud. ");
INSERT INTO ekk_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Häda neile, kes on lapseootel, ja neile, kes imetavad sellel ajal! Sest suur häda on maa peal ja viha selle rahva vastu! ");
INSERT INTO ekk_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ja nad langevad mõõga läbi ja nad viiakse vangi kõigi rahvaste sekka. Jeruusalemm jääb rahvaste tallata, kuni rahvaste aeg saab täis. ");
INSERT INTO ekk_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Päikeses, kuus ja tähtedes nähakse ennustuse märke. Maa peal aga on rahvad ahastuses ja hädas mere möirgamise ja veevoogude pärast. ");
INSERT INTO ekk_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Inimesed nõrkevad õudusest maa peale tulevate õnnetuste kartuses, sest taeva vägesid kõigutatakse. ");
INSERT INTO ekk_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ja sellel ajal nad näevad Inimese Poega tulemas pilvedes väe ja suure kirkusega. ");
INSERT INTO ekk_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Aga kui see kõik hakkab sündima, siis sirutage ennast ja tõstke oma pead, sest teie lunastus läheneb!“ ");
INSERT INTO ekk_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ta rääkis neile tähendamissõna: „Vaadake viigipuud ja kõiki puid! ");
INSERT INTO ekk_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kui pungad pakatavad, siis te võite ise näha, et suvi on lähedal. ");
INSERT INTO ekk_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nõnda ka teie, kui te näete kõike seda sündimas, siis teadke, et Jumala riik on lähedal. ");
INSERT INTO ekk_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Tõesti, ma ütlen teile, see sugupõlv ei kao, kuni kõik see on sündinud. ");
INSERT INTO ekk_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Taevas ja maa kaovad, kuid minu sõnad ei kao iial. ");
INSERT INTO ekk_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Hoidke end, et teie süda ei oleks koormatud liigsöömise, joomingute ega elumuredega, et see päev ei püüaks teid ootamatult lõksu. ");
INSERT INTO ekk_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sest see langeb kõikide peale, kes maa peal elavad! ");
INSERT INTO ekk_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Valvake ja palvetage kogu aeg, et teid arvataks väärt põgenema kõige selle eest, mis tuleb, ja seisma Inimese Poja ees!“ ");
INSERT INTO ekk_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jeesus õpetas iga päev templis, õhtuti läks ta välja ning ööbis mäel, mida kutsutakse Õlimäeks, ");
INSERT INTO ekk_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ja kõik inimesed tulid varahommikul teda templisse kuulama. ");
INSERT INTO ekk_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Saabumas oli hapnemata leibade püha, mida kutsutakse paasapühaks, ");
INSERT INTO ekk_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ning ülempreestrid ja kirjatundjad otsisid viisi, kuidas Jeesusest lahti saada, sest nad kartsid rahvast. ");
INSERT INTO ekk_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Siis sisenes saatan Juudasesse, keda kutsuti Iskariotiks, kes oli üks kaheteistkümnest. ");
INSERT INTO ekk_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ja Juudas läks ülempreestrite ja templivalvurite juurde ning arutas nendega, kuidas ta saaks Jeesuse ära anda nende kätte. ");
INSERT INTO ekk_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Neil oli selle üle hea meel ja nad leppisid kokku, et nad annavad talle raha. ");
INSERT INTO ekk_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Juudas nõustus ning hakkas otsima Jeesuse äraandmiseks võimalust, mil rahvast ei ole lähedal. ");
INSERT INTO ekk_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Saabus hapnemata leibade püha, mil tuli ohverdada paasatall. ");
INSERT INTO ekk_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jeesus läkitas Peetruse ja Johannese ning ütles: „Minge ja tehke ettevalmistusi, et saaksime süüa paasa õhtusööki!“ ");
INSERT INTO ekk_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","„Kus sa tahad, et me selle valmistaksime?“ küsisid nad. ");
INSERT INTO ekk_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ta vastas: „Kui te lähete linna sisse, tuleb teile vastu mees, kes kannab veekannu. Minge tema järel majja ");
INSERT INTO ekk_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ja öelge peremehele: „Õpetaja küsib: Kus on külalistetuba, kus ma võiksin süüa paasat oma jüngritega?“ ");
INSERT INTO ekk_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ta näitab teile suurt ülemist tuba kõige vajalikuga. Valmistage seal kõik ette!“ ");
INSERT INTO ekk_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nad läksid ja leidsid asjad täpselt nii, nagu Jeesus neile oli öelnud. Ja nad valmistasid paasasöögi. ");
INSERT INTO ekk_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kui see tund saabus, istusid Jeesus ja tema apostlid lauda. ");
INSERT INTO ekk_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ta ütles neile: „Ma olen väga igatsenud seda paasasööki süüa koos teiega enne oma kannatusi. ");
INSERT INTO ekk_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Sest ma ütlen teile, ma ei söö seda enam, kuni kõik on läinud täide Jumala riigis!“ ");
INSERT INTO ekk_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Siis võttis ta karika, tänas ja ütles: „Võtke see ning jagage eneste vahel! ");
INSERT INTO ekk_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Sest ma ütlen teile, mina ei joo enam viinapuu viljast, enne kui tuleb Jumala riik.“ ");
INSERT INTO ekk_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ja ta võttis leiva, tänas ja murdis ning andis selle neile ja ütles: „See on minu ihu, mis teie eest antakse; seda tehke minu mälestuseks!“ ");
INSERT INTO ekk_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Selsamal kombel võttis ta pärast sööki karika ja ütles: „See karikas on uus leping minu veres, mis teie eest valatakse. ");
INSERT INTO ekk_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Aga selle käsi, kes mu ära annab, on minuga lauas. ");
INSERT INTO ekk_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Inimese poeg läheb küll ära, nii nagu see on määratud, aga häda sellele, kes ta ära annab!“ ");
INSERT INTO ekk_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nad hakkasid üksteiselt küsima, kes see küll peaks nende seast olema, kes seda teeb. ");
INSERT INTO ekk_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Samuti tõusis nende seas vaidlus selle üle, kes neist on suurim. ");
INSERT INTO ekk_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jeesus ütles neile: „Rahvaste kuningad peremehetsevad nende üle ja nende kallal võimutsejaid kutsutakse heategijaiks. ");
INSERT INTO ekk_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Aga teie ei tohi sellised olla! Vaid suurim teie hulgas olgu nagu noorim, ja juht nagu see, kes teenib. ");
INSERT INTO ekk_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sest kumb on suurem, kas see, kes istub lauas, või see, kes teenib? Eks see, kes istub lauas? Ent mina olen teie hulgas nii nagu see, kes teenib. ");
INSERT INTO ekk_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Teie olete need, kes on minu kõrval olnud minu katsumustes. ");
INSERT INTO ekk_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ja mina annan teile Kuningriigi, nõnda nagu minu Isa mulle on andnud, ");
INSERT INTO ekk_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","et te sööksite ja jooksite minu lauas minu riigis ja istuksite aujärgedel ja mõistaksite kohut Iisraeli kaheteistkümne suguharu üle! ");
INSERT INTO ekk_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Siimon, Siimon, saatan on nõudnud luba sõeluda teid kõiki nagu nisu! ");
INSERT INTO ekk_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Aga mina olen sinu eest palunud, Siimon, et su usk ära ei lõpeks, ja kui sa pärast pöördud, siis kinnita oma vendi!“ ");
INSERT INTO ekk_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Aga ta vastas: „Issand, ma olen valmis sinuga minema vanglasse ja surma!“ ");
INSERT INTO ekk_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jeesus vastas: „Ma ütlen sulle, Peetrus, enne kui kukk täna kireb, oled sa kolm korda salanud, et mind tunned!“ ");
INSERT INTO ekk_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Siis Jeesus küsis nende käest: „Kui ma läkitasin teid kukruta, kotita ja sandaalideta, kas teil oli millestki puudus?“ „Mitte millestki,“ vastasid nad. ");
INSERT INTO ekk_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Siis ta ütles neile: „Aga nüüd, kellel on kukkur, võtku see kaasa, samuti kott, ja kellel ei ole, see müügu ära oma kuub ja ostku mõõk! ");
INSERT INTO ekk_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sest ma ütlen teile, et minus peab minema täide, mis on kirjutatud: „Ta on ülekohtuste sekka arvatud.“ Jah, mis minu kohta on kirjutatud, on täitumas.“ ");
INSERT INTO ekk_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jüngrid ütlesid: „Issand, siin on kaks mõõka!“ „Sellest piisab!“ vastas ta. ");
INSERT INTO ekk_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Välja minnes läks Jeesus nagu tavaliselt Õlimäele ja jüngrid järgnesid talle. ");
INSERT INTO ekk_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kui ta jõudis kohale, ütles ta neile: „Palvetage, et te ei satuks kiusatusse!“ ");
INSERT INTO ekk_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ta läks neist eemale kiviviske kaugusele, pani põlved maha ja palvetas: ");
INSERT INTO ekk_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","„Isa, kui sa tahad, võta see karikas minult ära; ometi täitugu mitte minu, vaid sinu tahtmine!“ ");
INSERT INTO ekk_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Siis ilmus ingel taevast ja kinnitas teda. ");
INSERT INTO ekk_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ja ahastuses olles palvetas ta veelgi pingsamalt, ja ta higi muutus nagu maha tilkuvateks verepiiskadeks. ");
INSERT INTO ekk_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kui ta palvetamast tõusis ja jüngrite juurde tagasi läks, leidis ta nad magamas kurbusest kurnatuna. ");
INSERT INTO ekk_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","„Miks te magate?“ küsis ta neilt. „Tõuske üles ja palvetage, et te ei satuks kiusatusse!“ ");
INSERT INTO ekk_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kui Jeesus alles rääkis, tuli üles rahvajõuk, ja see mees, keda kutsuti Juudaseks, üks neist kaheteistkümnest, juhtis neid. Ta astus Jeesuse juurde ja suudles teda. ");
INSERT INTO ekk_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Aga Jeesus küsis temalt: „Juudas, kas sa annad Inimese Poja suudlusega ära?“ ");
INSERT INTO ekk_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kui Jeesuse jüngrid nägid, mis on tulemas, küsisid nad: „Issand, kas me peaksime neid mõõkadega lööma?“ ");
INSERT INTO ekk_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ja üks neist lõigi ülempreestri sulast, raiudes ära tema parema kõrva. ");
INSERT INTO ekk_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jeesus vastas: „Aitab sellest!“ Ta puudutas mehe kõrva ja tegi selle terveks. ");
INSERT INTO ekk_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Siis Jeesus ütles ülempreestritele, templivalvuritele ja rahvavanematele, kes olid talle järele tulnud: „Kas ma juhin mässu, et te olete tulnud mõõkade ja keppidega? ");
INSERT INTO ekk_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ma olin iga päev teiega templis ja te ei pannud käsi mu külge. Kuid see on teie tund, kus valitseb pimedus.“ ");
INSERT INTO ekk_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nad võtsid Jeesuse kinni, viisid ta ära ja tõid ülempreestri majja. Peetrus järgnes eemalt. ");
INSERT INTO ekk_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Aga kui mõned inimesed sisehoovis tule süütasid ja maha istusid, istus ka Peetrus nende sekka. ");
INSERT INTO ekk_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Üks teenijatüdruk nägi teda tulevalgel istumas. Ta vaatas teda tähelepanelikult ja ütles: „See mees oli koos Jeesusega.“ ");
INSERT INTO ekk_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Aga Peetrus salgas: „Naine, ma ei tunne teda.“ ");
INSERT INTO ekk_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pisut hiljem nägi keegi teine teda ja ütles: „Ka sina oled üks neist.“ „Mees, mina ei ole,“ vastas Peetrus. ");
INSERT INTO ekk_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Umbes tund aega hiljem kinnitas keegi teine: „Kindlasti oli see mees temaga, ta on ju galilealane.“ ");
INSERT INTO ekk_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Peetrus vastas: „Mees, ma ei tea, millest sa räägid.“ Ja otsekohe, kui ta alles rääkis, kires kukk. ");
INSERT INTO ekk_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ning Issand pöördus ja vaatas Peetrusele otsa. Siis tuli Peetrusele meelde sõna, mis Issand oli talle öelnud: „Enne kui täna kukk kireb, salgad sina mu kolm korda ära.“ ");
INSERT INTO ekk_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ja ta läks välja ja nuttis kibedasti. ");
INSERT INTO ekk_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Aga mehed, kes Jeesust valvasid, pilkasid ja peksid teda. ");
INSERT INTO ekk_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nad katsid kinni ta silmad ja nõudsid: „Prohveteeri! Kes sind praegu lõi?“ ");
INSERT INTO ekk_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ja palju muid solvavaid sõnu ütlesid nad talle. ");
INSERT INTO ekk_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Koidikul kogunesid rahvavanemad, ülempreestrid ja kirjatundjad ning Jeesus viidi nende ette. ");
INSERT INTO ekk_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","„Kui sina oled Messias,“ nõudsid nad, „siis ütle seda meile!“ Jeesus aga vastas: „Kui ma teile ütleksin, siis te ei usuks mind, ");
INSERT INTO ekk_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ja kui ma teie käest küsiksin, siis te ei vastaks. ");
INSERT INTO ekk_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Aga siitpeale istub Inimese Poeg Kõigeväelise Jumala paremal käel.“ ");
INSERT INTO ekk_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Aga nad kõik küsisid: „Kas siis sina oled Jumala Poeg?“ Ta vastas: „Need on teie sõnad, et mina olen.“ ");
INSERT INTO ekk_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nemad aga ütlesid: „Mis tunnistust meil veel on vaja? Me oleme seda tema enese suust kuulnud!“ ");
INSERT INTO ekk_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ja terve nõukogu tõusis püsti ning viis Jeesuse Pilaatuse juurde. ");
INSERT INTO ekk_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nad hakkasid teda süüdistama: „Me oleme leidnud, et see mees õõnestab meie rahvast. Ta on keisrile maksude maksmise vastu ja väidab, et tema on Messias, kuningas.“ ");
INSERT INTO ekk_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilaatus küsis Jeesuselt: „Kas sina oled juutide kuningas?“ „Need on sinu sõnad,“ vastas Jeesus. ");
INSERT INTO ekk_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Siis Pilaatus teatas ülempreestritele ja rahvale: „Ma ei näe põhjust selle mehe süüdimõistmiseks.“ ");
INSERT INTO ekk_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nemad aga pressisid peale: „Ta keerab oma õpetusega rahva üles kogu Juudamaal. Ta alustas Galileas ja on tulnud kogu tee siia.“ ");
INSERT INTO ekk_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Seda kuuldes küsis Pilaatus, kas see mees on galilealane. ");
INSERT INTO ekk_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kui ta sai teada, et Jeesus on Heroodese valitsuse all, saatis ta tema Heroodese juurde, kes ka viibis neil päevil Jeruusalemmas. ");
INSERT INTO ekk_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heroodesel oli Jeesust nähes hea meel, sest ta oli juba tükk aega tahtnud teda näha. Ta oli temast palju kuulnud ja lootis näha teda imet tegemas. ");
INSERT INTO ekk_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ta pinnis teda paljude küsimustega, aga Jeesus ei vastanud. ");
INSERT INTO ekk_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ent ülempreestrid ja kirjatundjad seisid sealsamas teda ägedalt süüdistades. ");
INSERT INTO ekk_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Siis pilkasid teda ka Heroodes ja tema sõdurid. Nad riietasid ta uhkesse rüüsse ja saatsid tagasi Pilaatuse juurde. ");
INSERT INTO ekk_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Sel päeval said Pilaatus ja Heroodes sõpradeks, sest enne seda olid nad olnud vaenlased. ");
INSERT INTO ekk_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilaatus kutsus kokku ülempreestrid, valitsejad ja rahva ");
INSERT INTO ekk_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ning ütles neile: „Te olete toonud minu juurde selle mehe ja väidate, et ta õhutab rahvast mässama. Ma olen teda küsitlenud teie ees ega ole tema vastu leidnud ühtki süüd, mida teie tema peale kaebate. ");
INSERT INTO ekk_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Niisamuti pole ka Heroodes, sest ta saatis tema tagasi meie juurde. Nagu näete, ta pole teinud midagi, mis vääriks surma. ");
INSERT INTO ekk_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ma karistan teda ja lasen tal minna.“ ");
INSERT INTO ekk_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Sest ta pidi ühe neist pühade puhul vabaks laskma. ");
INSERT INTO ekk_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Aga kogu rahvas karjus ühel häälel: „Võta see mees! Vabasta meile Barabas!“ ");
INSERT INTO ekk_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas oli vangi pandud linnas sündinud mässu ja tapmise pärast. ");
INSERT INTO ekk_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilaatus pöördus uuesti nende poole, tahtes vabastada Jeesust. ");
INSERT INTO ekk_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Aga need karjusid: „Löö ta risti! Löö ta risti!“ ");
INSERT INTO ekk_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tema rääkis neile kolmandat korda: „Miks? Mis kuriteo on see mees siis teinud? Ma ei ole tema surmamõistmiseks põhjust leidnud. Sellepärast ma karistan teda ja lasen ta vabaks.“ ");
INSERT INTO ekk_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nemad aga nõudsid valjult karjudes tema ristilöömist, ja nende kisa jäi peale. ");
INSERT INTO ekk_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Siis Pilaatus otsustas teha nende tahtmist. ");
INSERT INTO ekk_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ta vabastas mehe, kes mässamise ja tapmise pärast oli vangi heidetud, nagu nad palusid, aga Jeesuse andis ta nende meelevalla alla. ");
INSERT INTO ekk_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kuid teda ära viies said nad kätte Siimoni Küreenest, kes just tuli maalt linna, ja nad panid risti tema selga, et ta kannaks seda Jeesuse järel. ");
INSERT INTO ekk_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Suur hulk rahvast käis nende järel tema pärast leinates ja nuttes. ");
INSERT INTO ekk_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jeesus aga ütles nende poole pöördudes: „Jeruusalemma tütred, ärge nutke minu pärast, nutke iseendi ja oma laste pärast! ");
INSERT INTO ekk_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sest tuleb aeg, kui te ütlete: „Õnnistatud on viljatud naised, kelle ihu pole kunagi last ilmale kandnud ja rinnad imetanud!“ ");
INSERT INTO ekk_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Siis nad ütlevad mägedele: „Langege meie peale!“ ja küngastele: „Katke meid!“ ");
INSERT INTO ekk_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Sest kui seda tehakse toore puuga, mis saab veel siis kuivaga?“ ");
INSERT INTO ekk_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kaks teist kurjategijat viidi hukkamisele koos temaga. ");
INSERT INTO ekk_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kui nad jõudsid kohani, mida kutsutakse Pealuuks, siis nad lõid Jeesuse seal risti koos kurjategijatega, üks temast paremal ja teine vasakul pool. ");
INSERT INTO ekk_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jeesus ütles: „Isa, anna neile andeks, sest nad ei tea, mida nad teevad!“ Ja nad jagasid liisku heites omavahel ära tema riided. ");
INSERT INTO ekk_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Inimesed vaatasid sealsamas pealt ja isegi valitsejad irvitasid Jeesuse üle. Nad ütlesid: „Teisi on ta päästnud, las ta nüüd päästab iseennast, kui ta on tõesti äravalitu, Jumala Messias!“ ");
INSERT INTO ekk_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ka sõdurid pilkasid teda. Nad astusid ta juurde, pakkusid talle veiniäädikat ");
INSERT INTO ekk_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ja ütlesid: „Kui sina oled juutide kuningas, siis päästa iseennast!“ ");
INSERT INTO ekk_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ja tema kohal oli sildile kirjutatud: See on juutide kuningas. ");
INSERT INTO ekk_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Üks ristil rippuvatest kurjategijatest teotas Jeesust: „Kas sa ei ole siis Messias? Päästa iseennast ja meid!“ ");
INSERT INTO ekk_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Aga teine sõitles teda. „Kas sinagi ei karda Jumalat?“ küsis ta, „Kuna sa ise oled sellesama karistuse all! ");
INSERT INTO ekk_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Meid karistatakse õiglaselt, sest me saame, mis me välja teenisime. Kuid see mees pole midagi valesti teinud.“ ");
INSERT INTO ekk_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Siis ta ütles: „Jeesus, hoia mind meeles, kui sa tuled oma Kuningriiki!“ ");
INSERT INTO ekk_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jeesus vastas talle: „Tõesti, ma ütlen sulle, juba täna oled sa koos minuga paradiisis.“ ");
INSERT INTO ekk_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Saabunud oli kuues tund, kui pimedus langes üle kogu maa kuni üheksanda tunnini, ");
INSERT INTO ekk_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","sest päike pimenes. Ja templi eesriie rebenes kaheks. ");
INSERT INTO ekk_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jeesus kisendas valju häälega: „Isa, sinu kätte ma annan oma vaimu!“ Ja kui ta seda oli öelnud, heitis ta hinge. ");
INSERT INTO ekk_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kui sadakonna ülem juhtunut nägi, andis ta Jumalale au ja ütles: „See inimene oli tõesti õige!“ ");
INSERT INTO ekk_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ja need inimesed, kes olid kokku tulnud seda vaatama, lõid sündivat nähes endale vastu rindu ja läksid minema. ");
INSERT INTO ekk_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Aga kõik, kes Jeesust tundsid, ja naised, kes olid teda Galileast peale saatnud, seisid eemal ja nägid seda. ");
INSERT INTO ekk_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Seal oli üks nõukogu liige, kelle nimi oli Joosep, hea ja õiglane mees, ");
INSERT INTO ekk_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","kes ei olnud nõus nende otsuse ja tegevusega. Ta oli pärit Juuda linnast Arimaatiast ja ta ootas Jumala riiki. ");
INSERT INTO ekk_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ta läks Pilaatuse juurde ja küsis enesele Jeesuse surnukeha. ");
INSERT INTO ekk_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ja ta võttis selle alla, mähkis linast kangasse ja asetas kaljusse raiutud hauda, kuhu polnud veel kedagi maetud. ");
INSERT INTO ekk_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ja see oli valmistumispäev, ning hingamispäev oli algamas. ");
INSERT INTO ekk_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Naised, kes olid Jeesusega koos tulnud Galileast, läksid Joosepi järel ning nägid hauakambrit ja seda, kuidas tema ihu sinna pandi. ");
INSERT INTO ekk_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Siis nad läksid koju ja panid valmis lõhnarohte ja salvi. Ja hingamispäeval puhkasid nad käsu järgi. ");
INSERT INTO ekk_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nädala esimese päeva varahommikul võtsid naised kaasa lõhnarohud, mis nad olid valmis pannud, ja läksid hauale. ");
INSERT INTO ekk_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nad leidsid kivi haua eest ära lükatuna, ");
INSERT INTO ekk_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","aga kui nad hauda sisse läksid, ei leidnud nad sealt Issanda Jeesuse ihu. ");
INSERT INTO ekk_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ja kui nad selle üle pead murdsid, seisid järsku nende kõrval kaks meest välguna helkivates riietes. ");
INSERT INTO ekk_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Aga kui naised hirmunult näoga vastu maad kummardasid, ütlesid mehed neile: „Miks te otsite elavat surnute juurest?“ ");
INSERT INTO ekk_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Teda ei ole siin! Ta on üles tõusnud! Tuletage meelde, mida ta teile ütles veel Galileas olles: ");
INSERT INTO ekk_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","„Inimese Poeg tuleb anda patuste kätte ja risti lüüa ja kolmandal päeval ta tõuseb jälle üles.“ ");
INSERT INTO ekk_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Siis neile meenusid Jeesuse sõnad. ");
INSERT INTO ekk_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kui nad pöördusid haua juurest tagasi, kuulutasid nad kõike seda neile üheteistkümnele ja kõigile teistele. ");
INSERT INTO ekk_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Need olid Maarja Magdaleena ja Johanna ja Maarja, Jaakobuse ema, ja teised naised koos nendega, kes rääkisid sellest apostlitele. ");
INSERT INTO ekk_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Aga nad ei uskunud nende juttu, see tundus neile kui mõttetus. ");
INSERT INTO ekk_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Peetrus aga tõusis püsti ja jooksis haua juurde. Ja kummargil sisse vaadates nägi ta surilinu ning ta läks ära pead murdes selle üle, mis oli sündinud. ");
INSERT INTO ekk_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Selsamal päeval läksid kaks nendest külla nimega Emmaus, see on Jeruusalemmast umbes üheteistkümne kilomeetri kaugusel. ");
INSERT INTO ekk_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nad vestlesid omavahel kõigest, mis oli juhtunud. ");
INSERT INTO ekk_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ja kui nad vestlesid ning neid asju arutasid, tuli nende juurde Jeesus ise ja kõndis nendega kaasa, ");
INSERT INTO ekk_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","aga nad ei tundnud teda ära. ");
INSERT INTO ekk_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jeesus küsis nende käest: „Mida te siin omavahel kõndides arutate?“ Nad seisid vaikselt ja vaatasid kurvalt maha. ");
INSERT INTO ekk_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Üks neist, Kleopas, küsis tema käest: „Sa oled vist ainus külaline Jeruusalemmas, kes veel ei tea, mis neil päevil seal on juhtunud?“ ");
INSERT INTO ekk_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","„Mis siis?“ küsis ta. „See, mis juhtus Naatsareti Jeesusega,“ vastasid nemad. „Ta oli prohvet, vägev sõnalt ja tegudelt Jumala ja kõigi inimeste ees. ");
INSERT INTO ekk_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ülempreestrid ja meie valitsejad andsid ta ära surmamõistmiseks ja lõid ta risti, ");
INSERT INTO ekk_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","aga meie lootsime, et tema ongi see, kes Iisraeli lunastab. Ja veel enam, täna on kolmas päev, kui see kõik juhtus. ");
INSERT INTO ekk_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Lisaks panid mõned naised meid hämmastuma. Nad käisid täna hommikul haua juures, ");
INSERT INTO ekk_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kuid ei leidnud tema ihu. Naised tulid ja rääkisid meile, et olid näinud nägemust inglitest, kes ütlesid, et Jeesus on elus. ");
INSERT INTO ekk_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Siis mõned meie kaaslastest läksid haua juurde ja leidsid selle täpselt, nagu naised olid öelnud; teda ennast nad aga ei näinud.“ ");
INSERT INTO ekk_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ja tema ütles neile: „Kui taipamatud te olete ja kui aeglased oma südames uskuma kõike, mida prohvetid on rääkinud! ");
INSERT INTO ekk_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kas Messias ei pidanud seda kõike kannatama ja oma kirkusesse astuma?“ ");
INSERT INTO ekk_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ning alustades Moosesest ja kõikidest prohvetitest, seletas Jeesus neile, mida Pühakiri tema kohta ütles. ");
INSERT INTO ekk_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ja kui nad lähenesid külale, kuhu nad olid minemas, tegi Jeesus, nagu ta läheks edasi. ");
INSERT INTO ekk_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Aga nad käisid talle peale: „Jää meie juurde, sest peagi on õhtu. Päev on kohe lõppemas!“ Ja tema läks sisse ja jäi nendega. ");
INSERT INTO ekk_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kui ta nendega lauas istus, võttis ta leiva, õnnistas ja murdis ning andis neile. ");
INSERT INTO ekk_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Siis avati nende silmad ja nad tundsid ta ära! Ja ta kadus nende silmist. ");
INSERT INTO ekk_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nad küsisid üksteiselt: „Eks meie südamed põlenud meie sees, kui ta tee peal meiega rääkis ja meile Pühakirja avas?“ ");
INSERT INTO ekk_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nad tõusid ja läksid tagasi Jeruusalemma. Seal nad leidsid üksteist jüngrit ja teised koos nendega, ");
INSERT INTO ekk_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","kes ütlesid: „See on tõsi! Issand on tõesti üles tõusnud ja Siimonile ilmunud!“ ");
INSERT INTO ekk_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Siis need kaks rääkisid, mis oli tee peal sündinud ja kuidas nad Jeesuse leiva murdmisest ära tundsid. ");
INSERT INTO ekk_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kui nad sellest alles rääkisid, seisis Jeesus ise nende keskel ja ütles: „Rahu olgu teiega!“ ");
INSERT INTO ekk_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nad olid jahmunud ja hirmul, arvates, et nad näevad vaimu. ");
INSERT INTO ekk_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ta ütles neile: „Miks te olete ärevuses ja miks on kahtlus tõusnud teie meeltesse? ");
INSERT INTO ekk_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Vaadake mu käsi ja mu jalgu. See olen mina! Puudutage mind ja vaadake, sest vaimul ei ole liha ja luid, aga te näete, et minul on!“ ");
INSERT INTO ekk_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ja seda öeldes näitas Jeesus neile oma käsi ja jalgu. ");
INSERT INTO ekk_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Aga kui nad rõõmu pärast ikka veel ei uskunud ja imestasid, küsis ta nende käest: „Kas teil on siin midagi süüa?“ ");
INSERT INTO ekk_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nad andsid talle tüki küpsetatud kala ja meekärge, ");
INSERT INTO ekk_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ja Jeesus võttis ja sõi nende ees. ");
INSERT INTO ekk_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ta ütles neile: „Need on mu sõnad, mis ma teile ütlesin, kui ma olin veel teiega: kõik peab täide minema, mis Moosese Seaduses, prohvetites ja lauludes on minu kohta kirjutatud.“ ");
INSERT INTO ekk_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Siis ta avas nende mõistuse, et nad saaksid Pühakirjast aru. ");
INSERT INTO ekk_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ja ütles neile: „Nõnda on kirjutatud, et Messias pidi kannatama ja kolmandal päeval üles tõusma surnuist, ");
INSERT INTO ekk_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ja tema nimel peab kuulutatama meeleparandust pattude andeksandmiseks kõigi rahvaste seas, alates Jeruusalemmast. ");
INSERT INTO ekk_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Teie olete nende asjade tunnistajad. ");
INSERT INTO ekk_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mina läkitan teie peale oma Isa tõotuse! Teie aga jääge sellesse linna seni, kuni teid on riietatud taevase väega!“ ");
INSERT INTO ekk_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jeesus viis nad välja Betaania lähedale, tõstis oma käed ja õnnistas neid. ");
INSERT INTO ekk_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ja neid õnnistades lahkus Jeesus nende juurest ja võeti üles taevasse. ");
INSERT INTO ekk_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nemad aga kummardasid teda ja pöördusid suure rõõmuga tagasi Jeruusalemma. ");
INSERT INTO ekk_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ja viibisid püsivalt templis Jumalat kiites.");
INSERT INTO ekk_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Alguses oli Sõna. Sõna oli Jumala juures ja Sõna oli Jumal. ");
INSERT INTO ekk_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tema oli alguses koos Jumalaga. ");
INSERT INTO ekk_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tema läbi on tekkinud kõik, ilma temata ei ole tekkinud midagi. ");
INSERT INTO ekk_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mis on tekkinud temas, oli elu, ja elu oli kogu inimkonna valgus. ");
INSERT INTO ekk_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","See valgus paistab pimeduses, aga pimedus ei suuda seda vastu võtta. ");
INSERT INTO ekk_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Oli Jumala läkitatud mees, kelle nimi oli Johannes. ");
INSERT INTO ekk_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ta tuli tunnistajana tunnistama valgusest, selleks, et kõik võiksid tema läbi uskuda. ");
INSERT INTO ekk_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Tema ise ei olnud valgus, tema tuli vaid tunnistama valgusest. ");
INSERT INTO ekk_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tõeline valgus, mis valgustab iga inimest, oli tulemas maailma. ");
INSERT INTO ekk_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ta tuli maailma, ja kuigi maailm oli tema läbi loodud, ei tundnud maailm teda ära. ");
INSERT INTO ekk_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ta tuli sellesse, mis oli tema oma, kuid tema enda omad ei võtnud teda vastu. ");
INSERT INTO ekk_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Aga kõigile, kes tema vastu võtsid, andis ta meelevalla saada Jumala lasteks, neile, kes usuvad tema nimesse, ");
INSERT INTO ekk_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","kes ei ole sündinud verest, ei liha otsusest ega mehe tahtest, vaid Jumalast. ");
INSERT INTO ekk_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Sõna sai lihaks ja elas meie keskel. Me oleme näinud tema au – ühe ja ainsa Poja au, kes tuli Isa juurest täis armu ja tõde. ");
INSERT INTO ekk_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Johannes tunnistas temast ja kuulutas avalikult: „Tema kohta ma ütlesin: „See, kes tuleb minu järel, on minust ülem, sest tema oli enne mind.“ “ ");
INSERT INTO ekk_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tema täiusest oleme me kõik saanud armu armu peale. ");
INSERT INTO ekk_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Sest Jumal andis Seaduse Moosese kaudu, arm ja tõde on aga ilmunud Jeesuse Kristuse kaudu. ");
INSERT INTO ekk_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Keegi pole iial näinud Jumalat, kui ainult Poeg, kes ise on Jumal. Tema on Isa läheduses ja on meile teda ilmutanud. ");
INSERT INTO ekk_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","See oli Johannese tunnistus, kui juutide juhid Jeruusalemmast saatsid preestreid ja leviite, et nad uuriksid temalt, kes ta on. ");
INSERT INTO ekk_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Johannes vastas neile salgamata, tunnistades avalikult: „Mina ei ole Messias.“ ");
INSERT INTO ekk_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nemad aga küsisid: „Kes sa siis oled? Oled sa Eelija?“ Ja ta vastas: „Mina ei ole.“ „Oled sa prohvet?“ Ta vastas: „Ei.“ ");
INSERT INTO ekk_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Siis nad küsisid temalt: „Kes sa oled? Me peame viima vastuse neile, kes meid läkitasid. Mida sa ütled enda kohta?“ ");
INSERT INTO ekk_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Johannes kostis prohvet Jesaja sõnadega: „Mina olen hääl, kes hüüab kõrbes: „Tehke tasaseks Issanda tee!“ “ ");
INSERT INTO ekk_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Läkitatute seas oli ka varisere ");
INSERT INTO ekk_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ja need küsisid temalt: „Miks sa siis ristid, kui sa ei ole ei Messias ega Eelija ega prohvet?“ ");
INSERT INTO ekk_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","„Mina ristin teid veega,“ vastas Johannes, „kuid teie keskel seisab see, keda te ei tunne, ");
INSERT INTO ekk_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","tema, kes tuleb pärast mind. Mina ei ole väärt tema sandaalegi lahti siduma.“ ");
INSERT INTO ekk_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","See kõik juhtus teisel pool Jordanit Betaanias, kus Johannes oli ristimas. ");
INSERT INTO ekk_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Järgmisel päeval nägi Johannes Jeesust enda poole tulemas ja ütles: „Ennäe, Jumala Tall, kes võtab ära maailma patu! ");
INSERT INTO ekk_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tema on see, kelle kohta ma ütlesin: „Pärast mind tuleb mees, kes on üle minu, sest tema oli enne mind.“ ");
INSERT INTO ekk_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Minagi ei tundnud teda, aga just selleks olen ma tulnud veega ristima, et ta saaks Iisraelile nähtavaks.“ ");
INSERT INTO ekk_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Johannes tunnistas: „Ma nägin Jumala Vaimu otsekui tuvi taevast alla laskumas ja tema peale jäämas. ");
INSERT INTO ekk_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ma ei oleks teadnud, kes ta on, aga see, kes läkitas mind veega ristima, ütles mulle: „Kelle peale sa näed Vaimu laskumas ja jäämas, see ristib Püha Vaimuga!“ ");
INSERT INTO ekk_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ma olen näinud ja kuulutan avalikult, et tema on Jumala Poeg.“ ");
INSERT INTO ekk_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Järgmisel päeval seisis Johannes seal jälle koos kahe oma jüngriga ");
INSERT INTO ekk_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ning, nähes Jeesust möödumas, ütles ta: „Ennäe, see on Jumala Tall!“ ");
INSERT INTO ekk_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kui need kaks jüngrit seda kuulsid, järgnesid nad Jeesusele. ");
INSERT INTO ekk_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jeesus aga pöördus ümber ja, nähes neid enda järel tulemas, küsis: „Mida te tahate?“ Nad ütlesid: „Rabi (mis tähendab Õpetajat), kus sa peatud?“ ");
INSERT INTO ekk_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","„Tulge ja vaadake!“ vastas Jeesus. Oli umbes kümnes tund. Nad läksid, nägid, kus ta peatus, ja jäid selleks päevaks temaga. ");
INSERT INTO ekk_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andreas, Siimon Peetruse vend, oli üks neist kahest, kes oli Johannest kuulnud ja Jeesusele järgnenud. ");
INSERT INTO ekk_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ta otsis nüüd kõigepealt üles oma venna Siimoni ja teatas talle: „Me oleme leidnud Messia!“ (See tähendab Kristuse.) ");
INSERT INTO ekk_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ta tõi venna Jeesuse juurde. Jeesus vaatas talle otsa ja ütles: „Sina oled Siimon, Johannese poeg. Sinu nimeks saab Keefas.“ ");
INSERT INTO ekk_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Järgmisel päeval otsustas Jeesus minna Galileasse. Ta leidis Filippuse ja ütles talle: „Järgne mulle!“ ");
INSERT INTO ekk_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filippus oli pärit Betsaidast, samast linnast, kust Andreas ja Peetrus. ");
INSERT INTO ekk_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filippus otsis üles Naatanaeli ja ütles talle: „Me oleme leidnud tema, kellest kirjutatakse Moosese Seaduses ja prohvetite raamatutes: Jeesuse, Joosepi poja Naatsaretist!“ ");
INSERT INTO ekk_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","„Kas Naatsaretist võib tulla midagi head?“ küsis Naatanael. „Tule ja vaata!“ vastas Filippus. ");
INSERT INTO ekk_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nähes Naatanaeli lähenemas, ütles Jeesus: „See on tõeline iisraellane, kelles ei ole pettust!“ ");
INSERT INTO ekk_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","„Kust sa mind tunned?“ imestas Naatanael. „Ma nägin sind, kui sa olid viigipuu all, enne kui Filippus sind kutsus,“ ütles Jeesus. ");
INSERT INTO ekk_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","„Rabi,“ vastas Naatanael talle, „sina oled Jumala Poeg, sina oled Iisraeli kuningas!“ ");
INSERT INTO ekk_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","„Sa usud, kuna ma ütlesin, et ma nägin sind viigipuu all?“ ütles Jeesus. „Sa saad näha suuremaid asju kui see. ");
INSERT INTO ekk_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tõesti, tõesti, ma ütlen teile, te näete taevast avatuna ning Jumala ingleid tõusmas ja laskumas Inimese Poja juurde.“ ");
INSERT INTO ekk_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kolmandal päeval peeti pulmi Kaanas Galileamaal. Ka Jeesuse ema oli seal ");
INSERT INTO ekk_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ning Jeesus oma jüngritega oli samuti pulmapeole kutsutud. ");
INSERT INTO ekk_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kui vein otsa sai, ütles ema Jeesusele: „Neil on vein otsas!“ ");
INSERT INTO ekk_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kuid Jeesus vastas talle: „Naine, mis see minusse puutub? Minu aeg ei ole veel tulnud!“ ");
INSERT INTO ekk_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ta ema aga käskis teenijaid: „Mida iganes ta teile ütleb, seda tehke!“ ");
INSERT INTO ekk_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Seal oli kuus kivist veeanumat juudi puhastustalituste tarvis, igaüks neist mahutas kaheksakümmend kuni sada kakskümmend liitrit. ");
INSERT INTO ekk_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","„Täitke need anumad veega!“ käskis Jeesus, ja nad täitsid need ääreni. ");
INSERT INTO ekk_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Siis ta ütles neile: „Ammutage nüüd sellest ja viige pulmavanemale!“ Nad tegid seda, ");
INSERT INTO ekk_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ja pulmavanem maitses vett, mis oli veiniks muutunud. Ta ei teadnud, kust see toodud oli, kuid teenijad, kes olid vee valanud, teadsid. Ta kutsus peigmehe kõrvale ");
INSERT INTO ekk_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ja ütles talle: „Iga peoperemees pakub esmalt parimat veini ja kui on joodud küllalt, siis kehvemat. Sina aga oled hoidnud parimat siiani!“ ");
INSERT INTO ekk_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Selle tunnustähega Kaanas Galileamaal ilmutas Jeesus esmakordselt oma jumalikku au, ning ta jüngrid uskusid temasse. ");
INSERT INTO ekk_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Seejärel peatus ta oma ema, vendade ja jüngritega mõne päeva Kapernaumas. ");
INSERT INTO ekk_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juutide paasapühad olid tulemas ja Jeesus läks Jeruusalemma. ");
INSERT INTO ekk_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nähes templiõues veiste, lammaste ja tuvide müüjaid ning rahavahetajaid laudade taga, ");
INSERT INTO ekk_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","tegi ta nööridest piitsa ja kihutas templist välja kõik, nii veised kui ka lambad. Ta puistas laiali rahavahetajate mündid ja keeras kummuli nende lauad. ");
INSERT INTO ekk_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ja ta käskis tuvimüüjaid: „Viige need siit minema! Ärge tehke mu Isa koda laadaplatsiks!“ ");
INSERT INTO ekk_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tema jüngritele meenus siis, et on kirjutatud: „Kiivus su koja pärast neelab mu ära!“ ");
INSERT INTO ekk_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Seepeale nõudsid juudid Jeesuse käest: „Kas sul on näidata meile mingit tunnustähte, mis kinnitaks, et sul on meelevald teha sääraseid asju?“ ");
INSERT INTO ekk_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jeesus vastas neile: „Lõhkuge see tempel, ja ma taastan selle kolme päevaga!“ ");
INSERT INTO ekk_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nemad vastasid: „Seda templit on ehitatud nelikümmend kuus aastat, ja sina taastad selle kolme päevaga?“ ");
INSERT INTO ekk_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kuid tempel, millest Jeesus rääkis, oli tema ihu. ");
INSERT INTO ekk_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Pärast tema ülestõusmist surmast meenus jüngritele, et ta seda oli öelnud, ning nad uskusid Pühakirja ja Jeesuse sõnu. ");
INSERT INTO ekk_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Kui Jeesus paasapühade ajal Jeruusalemmas tunnustähti andis, hakkasid paljud temasse uskuma. ");
INSERT INTO ekk_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Tema aga ei usaldanud ennast nende kätte, sest ta tundis inimesi. ");
INSERT INTO ekk_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tal polnud vaja tunnistust inimeste kohta, sest ta teadis, mis on iga inimese sees. ");
INSERT INTO ekk_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Seal oli variser, mees nimega Nikodeemos, kes oli üks juutide ülemaid. ");
INSERT INTO ekk_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ta läks öösel Jeesuse juurde ja ütles: „Rabi, me teame, et sina oled Õpetaja, kes on Jumala juurest tulnud. Ükski inimene ei suuda anda selliseid tunnustähti, kui Jumal pole temaga.“ ");
INSERT INTO ekk_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jeesus vastas: „Tõesti, tõesti, ma ütlen sulle, kui inimene ei sünni uuesti, ei või ta näha Jumala riiki.“ ");
INSERT INTO ekk_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","„Kuidas saab inimene sündida, kui ta on juba täiskasvanud?“ imestas Nikodeemos. „Ta ei saa ju minna tagasi emaüsasse ja teist korda sündida?“ ");
INSERT INTO ekk_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","„Tõesti, tõesti, ma ütlen sulle,“ vastas Jeesus, „kui inimene ei sünni veest ja Vaimust, ei pääse ta Jumala riiki! ");
INSERT INTO ekk_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Inimesest sündinu on inimene, Vaimust sündinu on vaim. ");
INSERT INTO ekk_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ära imesta, et ma ütlesin sulle: „Te peate uuesti sündima!“ ");
INSERT INTO ekk_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tuul puhub, kuhu ta tahab. Sa kuuled ta häält, aga ei tea, kust ta tuleb ja kuhu läheb. Samuti on igaühega, kes on sündinud Vaimust.“ ");
INSERT INTO ekk_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","„Kuidas on see võimalik?“ küsis Nikodeemos. ");
INSERT INTO ekk_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","„Sina oled õpetaja Iisraelis, aga ei mõista seda?“ vastas Jeesus. ");
INSERT INTO ekk_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","„Tõesti, tõesti, ma ütlen sulle, me räägime sellest, mida me teame, ja tunnistame avalikult, mida oleme näinud, ja siiski te ei usu meie tunnistust. ");
INSERT INTO ekk_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kui te ei usu, mida ma olen teile rääkinud maapealsetest asjadest, kuidas te usute siis, kui ma räägin teile taevastest asjadest? ");
INSERT INTO ekk_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ei ole ju keegi teine olnud ülal taevas kui vaid see, kes on tulnud taevast alla – Inimese Poeg. ");
INSERT INTO ekk_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nii nagu Mooses tõstis kõrbes üles pronksmao, nõnda peab ka Inimese Poeg kõrgele tõstetama, ");
INSERT INTO ekk_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","et igaühel, kes temasse usub, oleks igavene elu. ");
INSERT INTO ekk_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Sest nõnda on Jumal maailma armastanud, et ta andis oma ainusündinud Poja, et ükski, kes temasse usub, ei hukkuks, vaid et tal oleks igavene elu. ");
INSERT INTO ekk_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Jumal ei saatnud ju Poega maailma üle kohut mõistma, vaid et maailm võiks tema läbi pääseda. ");
INSERT INTO ekk_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kes iganes usub Pojasse, seda ei mõisteta süüdi, aga kes ei usu, on juba süüdi mõistetud, sest ta ei ole uskunud Jumala ainsasse Pojasse. ");
INSERT INTO ekk_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nende süü seisneb selles: valgus tuli maailma, aga inimesed armastasid pimedust rohkem kui valgust, sest nende teod olid kurjad. ");
INSERT INTO ekk_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kõik, kes teevad kurja, vihkavad valgust ega tule valguse kätte hirmust, et nende tegusid ei paljastataks. ");
INSERT INTO ekk_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Aga need, kes elavad tões, tulevad valguse kätte, nõnda et oleks selgelt näha, mida nad on teinud, sest see on tehtud Jumala silma all.“ ");
INSERT INTO ekk_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pärast seda läks Jeesus oma jüngritega Juudamaale. Ta viibis seal mõnda aega koos nendega ja ristis inimesi. ");
INSERT INTO ekk_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Samal ajal ristis ka Johannes Ainonis Salimi lähedal, kuna seal oli palju vett. Inimesed tulid ta juurde ja lasid end ristida. ");
INSERT INTO ekk_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","See oli veel enne Johannese vangistamist. ");
INSERT INTO ekk_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kord tõusis Johannese jüngritel ühe juudiga vaidlus puhastustalituse üle. ");
INSERT INTO ekk_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nad läksid Johannese juurde ja ütlesid talle: „Rabi, see mees, kes oli koos sinuga Jordani taga ja kellest sa tunnistasid, temagi ristib nüüd, ja kõik lähevad tema juurde.“ ");
INSERT INTO ekk_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Johannes vastas: „Inimene ei saa võtta endale midagi, kui see ei ole talle antud taevast. ");
INSERT INTO ekk_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Te võite ise kinnitada, et ma ütlesin: „Mina ei ole Messias, mind on läkitatud tema ees.“ ");
INSERT INTO ekk_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pruut kuulub peigmehele. Peiupoiss ootab ja kuulab teda ning on rõõmus, kui ta kuuleb peigmehe häält. See on minu rõõm ja nüüd on see täielikuks saanud. ");
INSERT INTO ekk_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tema peab kasvama, aga mina pean kahanema. ");
INSERT INTO ekk_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Kes tuleb ülalt, on üle kõikide. Kes pärineb maa pealt, on maine ja räägib maistest asjadest. Kes tuleb taevast, on üle kõikide, ");
INSERT INTO ekk_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ta tunnistab sellest, mida ta on näinud ja kuulnud, kuid tema tunnistust ei usuta. ");
INSERT INTO ekk_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kes usub tema tunnistust, kinnitab, et Jumalas on tõde. ");
INSERT INTO ekk_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kelle Jumal on läkitanud, räägib Jumala sõnu, sest Jumal annab talle Vaimu piiramatult. ");
INSERT INTO ekk_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Isa armastab Poega ja on andnud kõik tema kätte. ");
INSERT INTO ekk_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kes usub Pojasse, sellel on igavene elu. Kes Pojale vastu hakkab, sellele ei anta elu, vaid ta jääb Jumala viha alla.“ ");
INSERT INTO ekk_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jeesus sai teada, et variserideni on jõudnud kuuldus, nagu oleks ta kogunud ja ristinud rohkem jüngreid kui Johannes. ");
INSERT INTO ekk_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Kuid tegelikult Jeesus ise ei ristinud, vaid tema jüngrid. ");
INSERT INTO ekk_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ta lahkus Juudamaalt ja suundus uuesti tagasi Galileasse. ");
INSERT INTO ekk_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Selleks pidi ta minema läbi Samaaria. ");
INSERT INTO ekk_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nii jõudis ta Samaaria linnani nimega Sühhar, selle maavalduse lähedale, mille Jaakob oli kinkinud oma pojale Joosepile. ");
INSERT INTO ekk_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Sealsamas asub ka Jaakobi kaev, mille kõrvale Jeesus istuski teekäigust väsinuna. Oli kuues tund. ");
INSERT INTO ekk_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Peagi tuli üks samaaria naine vett võtma. „Anna mulle juua!“ palus Jeesus teda. ");
INSERT INTO ekk_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Sest Jeesuse jüngrid olid läinud linna toitu hankima. ");
INSERT INTO ekk_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","„Kuidas sina, juut, palud vett minult, Samaaria naiselt?“ imestas naine. (Sest juutidel ei tohtinud samaarlastega midagi tegemist olla.) ");
INSERT INTO ekk_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jeesus vastas talle: „Kui sa ainult teaksid, mida Jumalal on anda ja kes see on, kes küsib sinult juua, siis sa oleksid teda palunud ja ta oleks sulle elavat vett andnud.“ ");
INSERT INTO ekk_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","„Isand, sul ei ole ju ämbrit, millega vett ammutada,“ ütles naine, „ja see kaev on sügav. Kust sa siis saad seda elavat vett? ");
INSERT INTO ekk_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Või oled sa suurem kui meie isa Jaakob, kes andis meile kaevu, jõi sellest ise ning jõid ka tema pojad ja kariloomad?“ ");
INSERT INTO ekk_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","„Igaüks, kes joob seda vett,“ vastas Jeesus talle, „tunneb varsti jälle janu. ");
INSERT INTO ekk_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Aga kes joob vett, mida mina annan, ei tunne enam iialgi janu. Minu antud vesi muutub tema sees veeallikaks, millest voolab vett igaveseks eluks.“ ");
INSERT INTO ekk_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","„Isand, anna mulle seda vett,“ ütles naine, „et ma ei peaks janu tundma ega käima siit vett toomas!“ ");
INSERT INTO ekk_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","„Mine kutsu oma mees ja tule tagasi!“ käskis Jeesus. ");
INSERT INTO ekk_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","„Mul pole meest,“ vastas naine. „Sa ütlesid õigesti, et sul pole meest,“ ütles Jeesus. ");
INSERT INTO ekk_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","„Sest viis meest on sul olnud ja see, kes sul praegu on, ei ole sinu mees. See on tõsi!“ ");
INSERT INTO ekk_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","„Isand, ma näen, et sa oled prohvet,“ ütles naine. ");
INSERT INTO ekk_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","„Meie esiisad ülistasid Jumalat sellel mäel, aga teie, juudid, ütlete, et Jeruusalemm on koht, kus peab Jumalat ülistama.“ ");
INSERT INTO ekk_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","„Usu mind, naine,“ ütles Jeesus. „Tuleb aeg, mil te ei kummarda Isa enam sellel mäel ega Jeruusalemmas. ");
INSERT INTO ekk_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Teie, samaarlased, kummardate seda, keda te ei tunne. Meie teame, keda me kummardame, sest pääste tuleb juutidelt. ");
INSERT INTO ekk_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tuleb aeg, ja see on juba tulnud, mil tõelised ülistajad teenivad Isa vaimus ja tões. Just sääraseid ülistajaid otsib Isa. ");
INSERT INTO ekk_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Jumal on Vaim ja kes teda ülistab, peab seda tegema vaimus ja tões.“ ");
INSERT INTO ekk_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Naine ütles: „Ma tean, et tuleb Messias“ (keda kutsutakse Kristuseks). „Kui tema tuleb, siis ta seletab meile kõik.“ ");
INSERT INTO ekk_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","„Mina, kes ma sinuga räägin, olengi see,“ ütles Jeesus talle. ");
INSERT INTO ekk_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Just siis jõudsid jüngrid tagasi ja olid üllatunud, nähes Jeesust naisterahvaga rääkimas. Siiski ei küsinud ükski neist: „Mis tal vaja on?“ või „Miks sa temaga räägid?“ ");
INSERT INTO ekk_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ent naine jättis oma veekannu kaevu juurde, tõttas linna ja rääkis kõigile: ");
INSERT INTO ekk_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","„Tulge vaatama meest, kes ütles mulle kõik, mis ma iial olen teinud! Kas ehk tema ongi Messias?“ ");
INSERT INTO ekk_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Seepeale tulid teisedki selle linna elanikud Jeesuse juurde. ");
INSERT INTO ekk_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Samal ajal käisid jüngrid Jeesusele peale, öeldes: „Rabi, söö midagi!“ ");
INSERT INTO ekk_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Tema aga ütles neile: „Mul on toitu, millest teie midagi ei tea.“ ");
INSERT INTO ekk_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Siis arutasid jüngrid isekeskis: „Kas keegi on talle süüa toonud?“ ");
INSERT INTO ekk_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jeesus ütles neile: „Minu toit on see, et ma täidan selle tahtmist, kes mind on läkitanud, ja viin lõpule tema töö. ");
INSERT INTO ekk_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kas teil ei ole ütlust „Veel on neli kuud, ja alles siis tuleb lõikus“? Aga mina ütlen teile, avage oma silmad ja vaadake põlde! Need on lõikuseks küpsed! ");
INSERT INTO ekk_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Juba praegu saab lõikaja palka ja kogub vilja igavesse ellu, et külvaja ja lõikaja võiksid rõõmustada üheskoos. ");
INSERT INTO ekk_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ega ilmaasjata öelda, et üks külvab, aga teine lõikab. ");
INSERT INTO ekk_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mina saadan teid lõikama sealt, kus teie ei ole vaeva näinud. Teised on näinud vaeva, teie lõikate nende töö vilja.“ ");
INSERT INTO ekk_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Aga paljud samaarlased sellest linnast hakkasid uskuma Jeesusesse temaga rääkinud naise tunnistuse pärast: „Ta ütles mulle kõik, mis ma iial olen teinud!“ ");
INSERT INTO ekk_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kui samaarlased nüüd Jeesuse juurde tulid, käisid nad talle peale, et ta jääks nende linna. Ja Jeesus jäigi sinna kaheks päevaks, ");
INSERT INTO ekk_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ning veel paljud hakkasid uskuma, kui nad tema sõnu kuulsid. ");
INSERT INTO ekk_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Naisele, kes oli rääkinud neile Jeesusest, ütlesid nad: „Nüüd me usume mitte enam sinu jutu pärast, vaid me oleme teda ise kuulnud ja teame, et tema on tõepoolest maailma Päästja.“ ");
INSERT INTO ekk_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kahe päeva pärast läks Jeesus edasi Galileasse. ");
INSERT INTO ekk_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ta oli varem ise öelnud, et ühtki prohvetit ei tunnustata tema kodumaal. ");
INSERT INTO ekk_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kui ta nüüd Galileasse tuli, tervitasid inimesed teda rõõmuga, sest nad olid käinud paasapühade ajal Jeruusalemmas ja näinud kõike, mida Jeesus oli teinud. ");
INSERT INTO ekk_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jeesus läks uuesti Kaanasse Galileamaal, kus ta oli muutnud vee veiniks. Samal ajal oli seal keegi kuninga ametnik, kelle poeg oli Kapernaumas haige. ");
INSERT INTO ekk_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kuuldes, et Jeesus on tulnud Juudamaalt Galileasse, läks ta tema juurde ja palus, et Jeesus tuleks Kapernauma ja teeks terveks tema poja, kes oli suremas. ");
INSERT INTO ekk_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jeesus ütles: „Ükski teist ei usu muidu, kui ta ei näe tunnustähti ja imesid!“ ");
INSERT INTO ekk_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ametnik aga palus: „Issand, tule enne, kui mu laps sureb!“ ");
INSERT INTO ekk_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","„Mine koju, su poeg jääb ellu,“ vastas Jeesus talle. Mees uskus tema sõna ja läks koju. ");
INSERT INTO ekk_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Juba tee peal tulid sulased talle vastu ning teatasid, et ta poeg elab. ");
INSERT INTO ekk_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Siis ta uuris nende käest, millal poiss oli paranema hakanud. „Eile seitsmendal tunnil kadus tal äkki palavik,“ vastasid nad. ");
INSERT INTO ekk_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nüüd meenus poisi isale, et just sel ajal oli Jeesus talle öelnud: „Sinu poeg jääb ellu!“ Nii sai usklikuks see ametnik ja kogu ta pere. ");
INSERT INTO ekk_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","See oli Jeesuse teine tunnustäht, mille ta andis pärast Juudamaalt Galileasse tulekut. ");
INSERT INTO ekk_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pärast seda läks Jeesus juudi pühadeks Jeruusalemma. ");
INSERT INTO ekk_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jeruusalemmas Lambavärava lähedal on tiik heebreakeelse nimega Betsata, mille juurde kuulub viis sammaskäiku. ");
INSERT INTO ekk_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nende juures lebas palju haigeid: pimedaid, jalutuid, halvatuid, kes ootasid vee liikumist. ");
INSERT INTO ekk_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Sest aeg-ajalt laskus Issanda ingel alla tiiki ja segas vett. Kes siis pärast vee segamist esimesena tiiki astus, tervenes, ükskõik millisest haigusest. ");
INSERT INTO ekk_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Seal oli mees, kes oli juba kolmkümmend kaheksa aastat haige olnud. ");
INSERT INTO ekk_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jeesus nägi teda lamamas, ja kuulnud tema pikaaegsest haigusest, küsis ta mehelt: „Kas sa tahad terveks saada?“ ");
INSERT INTO ekk_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","„Isand,“ vastas haige talle, „mul ei ole kedagi, kes mind tiiki aitaks, kui vett liigutatakse. Iga kord, kui ma minema hakkan, jõuab keegi minust ette.“ ");
INSERT INTO ekk_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","„Tõuse,“ ütles Jeesus talle, „võta oma ase ja kõnni!“ ");
INSERT INTO ekk_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Otsekohe sai mees terveks, võttis oma aseme ja kõndis. See päev oli aga hingamispäev. ");
INSERT INTO ekk_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Seepärast ütlesid juutide ülemad tervenenule: „Täna on hingamispäev, sul on keelatud magamisaset kanda!“ ");
INSERT INTO ekk_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ent tema vastas neile: „See, kes mu terveks tegi, käskis mind: „Võta oma ase ja kõnni!“ “ ");
INSERT INTO ekk_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","„Kes on see mees, kes käskis sul selle võtta ja kõndida?“ nõudsid ülemad temalt. ");
INSERT INTO ekk_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kuid tervenenu ei teadnud, kes oli ta tervendaja, sest Jeesus oli kadunud rahva hulka. ");
INSERT INTO ekk_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Hiljem kohtas Jeesus teda templis ja ütles talle: „Nüüd, kus sa oled saanud terveks, ära tee enam pattu, et sind ei tabaks midagi halvemat!“ ");
INSERT INTO ekk_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tema läks seepeale tagasi ja teatas juutide ülemaile, et ta tervendaja oli Jeesus. ");
INSERT INTO ekk_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kuna aga Jeesus oli tervendanud hingamispäeval, hakkasid need nüüd Jeesust taga kiusama. ");
INSERT INTO ekk_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jeesus ütles neile enda kaitseks: „Minu Isa teeb tööd tänase päevani ja ka mina töötan!“ ");
INSERT INTO ekk_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Seepeale hakkasid juutide ülemad veel enam otsima võimalust teda tappa. Sest ta oli rikkunud mitte ainult hingamispäeva, vaid ka nimetanud Jumalat oma Isaks, tehes end Jumalaga võrdseks. ");
INSERT INTO ekk_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jeesus aga vastas: „Tõesti, tõesti, ma ütlen teile, Poeg ei saa teha midagi omapäi, ta teeb vaid seda, mida näeb Isa ees tegevat. Mida iganes Isa teeb, seda teeb ka Poeg, ");
INSERT INTO ekk_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","sest Isa armastab Poega ja näitab talle kõike, mida ta ise teeb. Ja ta näitab talle veel suuremaid tegusid kui need, mida te olete näinud, nii et te hämmastute. ");
INSERT INTO ekk_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nõnda nagu Isa äratab üles surnuid ja teeb nad elavaks, annab ka Poeg elu neile, kellele soovib anda. ");
INSERT INTO ekk_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Enamgi veel – Isa ei mõista kohut kellegi üle, vaid on kogu kohtumõistmise usaldanud Poja kätte, ");
INSERT INTO ekk_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","et kõik võiksid austada Poega, nagu nad austavad Isa. Kes keeldub austamast Poega, ei austa ka Isa, kes tema on läkitanud. ");
INSERT INTO ekk_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Tõesti, tõesti, ma ütlen teile, kes võtab kuulda minu sõnu ja usub mu Läkitajat, sellel on igavene elu ja teda ei mõisteta süüdi, vaid ta on läinud surmast ellu. ");
INSERT INTO ekk_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tõesti, tõesti, ma ütlen teile, tuleb aeg, ja see on juba käes, mil surnud kuulevad Jumala Poja häält ja need, kes kuulevad, elavad. ");
INSERT INTO ekk_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Sest nõnda nagu Isal on elu iseendas, on ta andnud elu ka Pojale. ");
INSERT INTO ekk_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ja ta on andnud temale meelevalla kohut mõista, sest ta on Inimese Poeg. ");
INSERT INTO ekk_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ärge hämmastuge, tuleb aeg, mil kõik, kes on haudades, kuulevad tema häält ");
INSERT INTO ekk_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ja tõusevad üles: need, kes on teinud head – selleks et elada, ning need, kes on teinud halba – selleks et kanda karistust. ");
INSERT INTO ekk_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mina ei saa teha midagi omapäi; ma mõistan kohut nii, nagu mulle öeldakse. Minu kohtumõistmine on õiglane, sest ma ei püüa teha enese tahtmist, vaid oma Läkitaja tahtmist. ");
INSERT INTO ekk_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kui ma annaksin tunnistust iseenda kohta, ei oleks mu tunnistus tõde. ");
INSERT INTO ekk_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Aga keegi teine tunnistab minu kasuks, ja ma tean, et tema tunnistus on tõde. ");
INSERT INTO ekk_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Teie saatsite käskjalgu Johannese juurde ja tema on tunnistanud tõest. ");
INSERT INTO ekk_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mitte et ma võtan vastu inimlikku tunnistust, aga ma räägin seda selleks, et teie saaksite päästetud. ");
INSERT INTO ekk_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Johannes oli lamp, mis läideti ja andis valgust, ning mõnda aega te rõõmustasite tema valguse üle. ");
INSERT INTO ekk_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Minul on tunnistus, mis on mõjuvam Johannese omast: töö, mille Isa on andnud mulle lõpule viia. Need teod, mida mina teen, tõendavad, et Isa on minu läkitanud. ");
INSERT INTO ekk_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Isa, kes mind saatis, on ise minu kohta tunnistusi andnud. Teie ei ole kunagi kuulnud ta häält ega näinud ta kuju, ");
INSERT INTO ekk_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","teie südames ei ole kohta tema sõnale, sest te ei usu teda, kelle tema on läkitanud. ");
INSERT INTO ekk_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Te uurite küll hoolega Pühakirja, sest arvate, et see annab teile igavese elu. Aga seesama Pühakiri tunnistab minust! ");
INSERT INTO ekk_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ja siiski ei taha te tulla minu juurde, et saada elu. ");
INSERT INTO ekk_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ma ei vaja austust inimestelt, ");
INSERT INTO ekk_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","aga ma tunnen teid. Ma tean, et teil ei ole südames Jumala armastust. ");
INSERT INTO ekk_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mina olen tulnud oma Isa nimel, aga teie ei võta mind vastu. Samas kui mõni tuleb iseenda nimel, siis tema te võtate vastu. ");
INSERT INTO ekk_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kuidas te võiksitegi uskuda, kui te võtate vastu austust üksteiselt, aga ei otsi seda austust, mis tuleb ainsalt Jumalalt. ");
INSERT INTO ekk_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ometi ärge arvake, et mina hakkan teid Isa ees süüdistama. Teie süüdistaja on hoopis Mooses, kelle peale te loodate. ");
INSERT INTO ekk_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kui te tõepoolest usuksite Moosest, siis te usuksite ka mind, sest tema on minust kirjutanud. ");
INSERT INTO ekk_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Aga kui te isegi tema kirjutatut ei usu, kuidas te siis saate uskuda minu sõnu?“ ");
INSERT INTO ekk_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pärast seda läks Jeesus teisele poole Galilea merd (ehk Tibeeria merd). ");
INSERT INTO ekk_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Talle järgnes suur rahvahulk, sest nad olid näinud tunnustähti, mida ta oli haigeid tervendades teinud. ");
INSERT INTO ekk_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jeesus aga läks üles mäeseljale ja istus seal koos oma jüngritega maha. ");
INSERT INTO ekk_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Juutide paasapühad olid lähedal. ");
INSERT INTO ekk_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kui ta nüüd ringi vaatas, nägi ta suurt rahvahulka enda poole tulemas, ja Jeesus küsis Filippuselt: „Kust peaksime me leiba ostma, et neile süüa anda?“ ");
INSERT INTO ekk_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Kuid seda küsis Jeesus, et teda proovile panna, sest ta teadis, mida ta kavatses teha. ");
INSERT INTO ekk_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filippus vastas: „Isegi kui me ostaksime leiba kasvõi kahesaja teenari eest, ei jätkuks igaühele ikka üht suutäitki.“ ");
INSERT INTO ekk_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Siis ütles teine jünger, Siimon Peetruse vend Andreas: ");
INSERT INTO ekk_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","„Siin on poisike, kellel on viis odrakakku ja kaks kala. Aga kui kauaks sellest sellise rahvahulga jaoks jagub?“ ");
INSERT INTO ekk_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","„Seadke inimesed istuma!“ käskis Jeesus. Kõik istusidki maha haljale rohule; ainuüksi mehi oli kokku umbes viis tuhat. ");
INSERT INTO ekk_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Siis võttis Jeesus leivad, tänas Jumalat ning jagas inimestele nii palju, kui nad soovisid. Samamoodi tegi ta kaladega. ");
INSERT INTO ekk_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kui kõigil said kõhud täis, ütles Jeesus jüngritele: „Korjake ülejääk kokku, et midagi raisku ei läheks!“ ");
INSERT INTO ekk_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Siis nad korjasid viiest odraleivast ülejäänud palukesed kokku ja said kaksteist korvitäit. ");
INSERT INTO ekk_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Pärast seda, kui inimesed nägid Jeesuse antud tunnustähte, hakkasid nad rääkima: „Tõesti, tema on see prohvet, kes on siia maailma tulnud.“ ");
INSERT INTO ekk_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jeesus aga teadis, et rahvas tahab tulla ja teda vägisi kuningaks teha. Seepärast pöördus ta üksi tagasi mägedesse. ");
INSERT INTO ekk_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kui õhtu kätte jõudis, läksid jüngrid alla järve äärde, ");
INSERT INTO ekk_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","astusid paati ning sõitsid üle järve Kapernauma. Väljas oli juba pime ja Jeesus ei olnud tulnud nende juurde. ");
INSERT INTO ekk_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Puhus kõva tuul ja tõusid tormilained. ");
INSERT INTO ekk_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Olles sõudnud kolm või neli miili, nägid jüngrid Jeesust järvel kõndimas ja paadile lähenemas, ning neid haaras hirm. ");
INSERT INTO ekk_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","„See olen mina,“ hüüdis Jeesus, „ärge kartke!“ ");
INSERT INTO ekk_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nad kutsusid ta paati, ja kohe oligi paat kaldal, kuhu nad olid tahtnud jõuda. ");
INSERT INTO ekk_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Järgmisel päeval sai teisele poole järve jäänud rahvahulk teada, et kaldal oli olnud ainult üks paat, kuid Jeesus ei olnud läinud sellesse koos jüngritega, vaid jüngrid olid lahkunud ilma temata. ");
INSERT INTO ekk_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Siis maabusid mõned teised paadid Tibeeriast selle paiga lähedal, kus nad olid söönud Issanda õnnistatud leiba. ");
INSERT INTO ekk_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kui nüüd inimesed nägid, et Jeesust ega ta jüngreid seal ei olnud, astusid nad paatidesse ja sõitsid teda Kapernauma otsima. ");
INSERT INTO ekk_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nad leidsid ta järve teiselt kaldalt ja küsisid: „Rabi, millal sina siia tulid?“ ");
INSERT INTO ekk_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","„Tõesti, tõesti, ma ütlen teile,“ vastas Jeesus, „te ei otsi mind mitte sellepärast, et nägite tunnustähti, vaid et te sõite leiba ja saite kõhud täis! ");
INSERT INTO ekk_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ärge töötage toidu nimel, mis rikneb, vaid hankige toitu, mis säilib igaveseks eluks – mida Inimese Poeg teile annab. Sest tema peale on Jumal Isa pannud oma heakskiidu pitseri.“ ");
INSERT INTO ekk_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","„Mida me peame tegema, et meie teod oleksid Jumalale meelepärased?“ küsisid nad temalt. ");
INSERT INTO ekk_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","„Jumalale meelepärane tegu on see,“ vastas Jeesus, „et te usute sellesse, kelle tema on läkitanud.“ ");
INSERT INTO ekk_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nemad ütlesid: „Millise tunnustähe sa meile annad, et me võiksime sind uskuda? Mis teo sa teed? ");
INSERT INTO ekk_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Meie esivanemad sõid kõrbes mannat, nagu Pühakirjas öeldakse: „Ta andis neile taevast leiba süüa.“ “ ");
INSERT INTO ekk_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","„Tõesti, tõesti, ma ütlen teile,“ vastas Jeesus, „mitte Mooses ei andnud teile taevast leiba, vaid minu Isa; tema annab teile ka nüüd tõelise leiva taevast. ");
INSERT INTO ekk_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sest Jumala leib on see, kes tuleb taevast alla ja annab maailmale elu.“ ");
INSERT INTO ekk_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Siis ütlesid nad talle: „Issand, anna meile alati seda leiba!“ ");
INSERT INTO ekk_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","„Mina olengi eluleib,“ vastas Jeesus. „Kes tuleb minu juurde, ei tunne iial nälga; kes usub minusse, ei tunne iial janu. ");
INSERT INTO ekk_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aga ma ju ütlesin, te olete mind näinud, kuid siiski te ei usu. ");
INSERT INTO ekk_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kõik, kelle Isa mulle annab, tulevad minu juurde, ja seda, kes minu juurde tuleb, ei tõuka ma ära. ");
INSERT INTO ekk_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sest mina ei ole tulnud taevast, et teha oma tahtmist, vaid oma Läkitaja tahtmist. ");
INSERT INTO ekk_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ent minu Läkitaja tahtmine on see, et ma ei kaotaks ühtki neist, keda tema on mulle andnud, vaid tõstaksin nad üles viimasel päeval. ");
INSERT INTO ekk_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Sest minu Isa tahtmine on, et igaühel, kes näeb Poega ja usub temasse, oleks igavene elu. Ja mina tõstan nad üles viimasel päeval.“ ");
INSERT INTO ekk_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Siis hakkasid juudid tema üle nurisema, kuna ta oli öelnud: „Mina olen taevast tulnud leib.“ ");
INSERT INTO ekk_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nad ütlesid: „Eks see ole ju Jeesus, Joosepi poeg, kelle isa ja ema me tunneme? Kuidas ta siis nüüd ütleb „Mina olen taevast alla tulnud“?“ ");
INSERT INTO ekk_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jeesus vastas neile: „Lõpetage see omavaheline nurisemine! ");
INSERT INTO ekk_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Keegi ei saa tulla minu juurde, kui teda ei tõmba Isa, minu Läkitaja; ning mina tõstan ta üles viimasel päeval. ");
INSERT INTO ekk_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Prohvetite raamatutes on kirjutatud: „Siis õpetab neid kõiki Jumal.“ Kõik, kes on kuulnud Isa ja temalt õppinud, tulevad minu juurde. ");
INSERT INTO ekk_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mitte keegi pole Isa näinud peale selle, kes on tulnud Jumala juurest – tema on Isa näinud. ");
INSERT INTO ekk_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tõesti, tõesti, ma ütlen teile, kes usub, sellel on igavene elu! ");
INSERT INTO ekk_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mina olen eluleib. ");
INSERT INTO ekk_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Teie esivanemad sõid kõrbes mannat, aga surid siiski. ");
INSERT INTO ekk_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","See on leib, mis taevast alla tuleb, et inimene seda sööks ega sureks. ");
INSERT INTO ekk_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mina olen taevast tulnud elav leib. Kes seda leiba sööb, elab igavesti. Leib, mille mina annan selleks, et maailm võiks elada, on minu liha.“ ");
INSERT INTO ekk_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Siis puhkes kuulajate seas äge vaidlus. „Kuidas saab see mees anda meile süüa oma liha?“ küsisid nad. ");
INSERT INTO ekk_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jeesus aga vastas neile: „Tõesti, tõesti, ma ütlen teile, kui te ei söö Inimese Poja liha ega joo tema verd, siis teis ei ole elu. ");
INSERT INTO ekk_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kes sööb minu liha ja joob minu verd, sellel on igavene elu, ja mina äratan ta üles viimasel päeval. ");
INSERT INTO ekk_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Sest minu liha on tõeline söök ja minu veri on tõeline jook. ");
INSERT INTO ekk_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kes sööb minu liha ja joob minu verd, jääb minusse, ja mina jään temasse. ");
INSERT INTO ekk_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nii nagu Isa on mind saatnud ja ma elan Isa pärast, elab minu pärast see, kes minust sööb. ");
INSERT INTO ekk_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","See ongi leib, mis on alla tulnud taevast. Teie esivanemad sõid mannat ja surid, aga kes iganes seda leiba sööb, elab igavesti.“ ");
INSERT INTO ekk_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Nii õpetas Jeesus Kapernauma sünagoogis. ");
INSERT INTO ekk_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Seda kuuldes ütlesid paljud ta jüngritest: „See õpetus on raske. Kes suudab seda vastu võtta?“ ");
INSERT INTO ekk_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jeesus teadis, et jüngrid nurisevad tema üle, ning ütles neile: „Kas teid pahandab see, mida ma rääkisin? ");
INSERT INTO ekk_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mis te veel siis teete, kui te näete Inimese Poega minevat üles sinna, kus ta oli kõigepealt? ");
INSERT INTO ekk_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Vaim on see, kes annab elu. Lihast ei ole abi. Sõnad, mis ma teile rääkisin, on täis Vaimu ja elu. ");
INSERT INTO ekk_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kuid teie seas on mõned, kes ei usu.“ Sest Jeesus teadis ju algusest peale, kes temasse ei usu ja kes ta lõpuks ära annab. ");
INSERT INTO ekk_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ta ütles veel: „Seepärast ma ütlesingi teile, et keegi ei saa tulla minu juurde, kui seda ei ole talle andnud Isa.“ ");
INSERT INTO ekk_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Sellest ajast alates pöörasid paljud jüngrid talle selja ja loobusid talle järgnemast. ");
INSERT INTO ekk_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Siis küsis Jeesus oma kaheteistkümnelt: „Kas teiegi tahate lahkuda?“ ");
INSERT INTO ekk_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Talle vastas Siimon Peetrus: „Issand, kelle juurde oleks meil minna? Sinul on igavese elu sõnad! ");
INSERT INTO ekk_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Me usume ja teame, et sina oled Jumala Püha.“ ");
INSERT INTO ekk_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jeesus vastas neile: „Eks valinud ju mina teid kahtteistkümmet. Aga üks teie seast on kurat.“ ");
INSERT INTO ekk_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Seda ütles ta Juudase, Siimon Iskarioti poja kohta, sest see, üks kaheteistkümnest, andis ta hiljem ära. ");
INSERT INTO ekk_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pärast seda käis Jeesus Galileas ringi. Ta ei tahtnud liikuda Juudamaal, sest juutide juhid otsisid võimalust teda tappa. ");
INSERT INTO ekk_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kuna saabumas oli juutide lehtmajadepüha, ");
INSERT INTO ekk_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ütlesid Jeesuse vennad temale: „Lahku siit ja mine Juudamaale, et su jüngrid näeksid su suuri tegusid. ");
INSERT INTO ekk_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kes tahab tegutseda avalikult, ei saa olla salajas. Kui sa juba teed sääraseid asju, siis näita end kogu maailmale!“ ");
INSERT INTO ekk_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Sest isegi Jeesuse vennad ei uskunud temasse. ");
INSERT INTO ekk_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jeesus vastas neile: „Minu aeg ei ole veel saabunud, aga teile on iga hetk ühtviisi sobiv. ");
INSERT INTO ekk_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Maailmal ei ole põhjust teid vihata, kuid mind ta vihkab, sest ma tunnistan, et ta teod on kurjad. ");
INSERT INTO ekk_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Minge teie pühi pidama. Mina ei lähe neile pidustustele, sest minu aeg ei ole veel käes.“ ");
INSERT INTO ekk_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Seda öelnud, jäi ta Galileasse. ");
INSERT INTO ekk_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ent kui ta vennad olid läinud pidustustele, läks ka Jeesus, aga mitte avalikult, vaid salaja. ");
INSERT INTO ekk_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Juutide ülemad otsisid Jeesust piduliste hulgast, küsides: „Kus ta siis on?“ ");
INSERT INTO ekk_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Rahva seas oli tema kohta palju sosistamist. Ühed arvasid: „Ta on hea inimene.“ Teised vaidlesid vastu: „Ei ole, ta eksitab rahvast.“ ");
INSERT INTO ekk_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kuid keegi ei rääkinud temast avalikult hirmust juhtide ees. ");
INSERT INTO ekk_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kui pühadenädal oli juba poole peal, läks Jeesus templisse ja hakkas õpetama. ");
INSERT INTO ekk_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","„Kuidas see õppimata mees on säärase õpetuse saanud?“ imestasid juutide ülemad. ");
INSERT INTO ekk_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jeesus vastas neile: „Minu õpetus ei pärine minult endalt, vaid mu Läkitajalt. ");
INSERT INTO ekk_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kõik, kes otsustavad teha Jumala tahtmist, näevad, kas minu õpetus tuleb Jumalalt või kõnelen ma iseenesest. ");
INSERT INTO ekk_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Iseenesest rääkijad teevad seda selleks, et endale au saada. Aga kes otsib tema au, kes teda saatis, kannab tõde. Temas pole midagi valelikku. ");
INSERT INTO ekk_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Eks ole Mooses andnud teile Seaduse. Kuid keegi teist ei pea Seadust. Miks te tahate mind tappa?“ ");
INSERT INTO ekk_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Siis öeldi rahva hulgast: „Sinus on kuri vaim. Kes sind tappa tahab?“ ");
INSERT INTO ekk_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jeesus vastas neile: „Ma tegin ühe ime ja te kõik olete imestunud. ");
INSERT INTO ekk_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Eks ole, Mooses andis teile ümberlõikamiskäsu (ehkki see ei pärine Mooseselt, vaid esiisadelt) ja seepärast te lõikate inimese ümber ka hingamispäeval. ");
INSERT INTO ekk_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kui isegi hingamispäeval tuleb inimene ümber lõigata, et Moosese Seadust ei rikutaks, miks te siis mulle pahaks panete, et ma tegin kogu inimese terveks hingamispäeval? ");
INSERT INTO ekk_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ärge hinnake välise järgi, vaid hinnake õiglaselt!“ ");
INSERT INTO ekk_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Siis arutasid mõned jeruusalemlased omavahel: „Kas see pole sama mees, keda tahetakse tappa? ");
INSERT INTO ekk_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ja näe, nüüd kõneleb ta avalikult ja talle ei öelda midagi. Ega ometi võimumehed ole jõudnud järeldusele, et tema ongi Messias? ");
INSERT INTO ekk_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Aga meie ju teame, kust ta on pärit. Kui Messias tuleb, ei tea keegi, kust ta on.“ ");
INSERT INTO ekk_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Siis hüüdis Jeesus templis õpetades: „Teie teate mind ja minu päritolu? Mina ei ole tulnud iseenda nimel. Mul on tõeline Läkitaja, keda teie ei tunne. ");
INSERT INTO ekk_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Kuid mina tunnen teda, sest ma olen tulnud tema juurest ja tema on mind saatnud.“ ");
INSERT INTO ekk_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Siis tahtsid nad teda kinni võtta, kuid keegi ei puutunud teda, sest tema tund ei olnud veel käes. ");
INSERT INTO ekk_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ent paljud rahva seast uskusid temasse, öeldes: „Kui Messias tuleb, kas ta peaks andma rohkem tunnustähti, kui see mees on teinud?“ ");
INSERT INTO ekk_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kui variserid kuulsid, mida rahvas Jeesuse kohta sosistas, saatsid nemad ja ülempreestrid mõned templivalvurid teda vahistama. ");
INSERT INTO ekk_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jeesus aga rääkis: „Veel pisut aega olen ma teie juures ja siis lähen tagasi oma Läkitaja juurde. ");
INSERT INTO ekk_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Te otsite mind, aga ei leia. Ja kus mina olen, sinna teie ei saa tulla.“ ");
INSERT INTO ekk_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Siis arutasid juudid omavahel: „Kuhu ta mõtleb minna, et me teda ei leia? Ega ta ometi lähe võõrsil kreeklaste seas elavate juutide juurde, et hakata õpetama kreeklasi? ");
INSERT INTO ekk_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mida see tähendab, kui ta ütles „Te otsite mind, aga ei leia“ ja „Kus mina olen, sinna teie ei saa tulla“?“ ");
INSERT INTO ekk_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pidustuste viimasel, kõige tähtsamal päeval seisis Jeesus, hüüdes: „Kellel on janu, see tulgu minu juurde ja joogu! ");
INSERT INTO ekk_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kes iganes usub minusse, sellest voolavad elava vee jõed, nagu Pühakirjas on öeldud.“ ");
INSERT INTO ekk_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Seda ütles ta Jumala Vaimu kohta, kelle pidid hiljem saama need, kes temasse usuvad. Vaimu ei olnud veel antud, sest Jeesus ei olnud veel ausse tõstetud. ");
INSERT INTO ekk_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Neid sõnu kuuldes kostsid mõned rahva seast: „See mees on tõesti prohvet!“ ");
INSERT INTO ekk_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Teised arvasid: „Tema on Messias!“ „Kindlasti mitte,“ vaidlesid kolmandad, „ega siis Messias tule Galileast? ");
INSERT INTO ekk_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Pühakirjas ju öeldakse, et Messias tuleb Taaveti soost ja Petlemma külast, kus Taavet sündis.“ ");
INSERT INTO ekk_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nii läksid rahva arvamused tema kohta lahku. ");
INSERT INTO ekk_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mõned neist tahtsid teda kinni võtta, kuid siiski ei puutunud teda keegi. ");
INSERT INTO ekk_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nüüd läksid templivalvurid tagasi ülempreestrite ja variseride juurde, kes küsisid neilt: „Miks te teda kaasa ei toonud?“ ");
INSERT INTO ekk_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","„Ükski inimene pole ealeski kõnelenud nõnda nagu tema,“ vastasid valvurid. ");
INSERT INTO ekk_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","„Kas teiegi lasite end eksitada?“ küsisid variserid. ");
INSERT INTO ekk_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","„On siis keegi valitsejatest või variseridest uskunud temasse? ");
INSERT INTO ekk_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Aga see rahvahulk, kes ei tunne Seadust, on neetud!“ ");
INSERT INTO ekk_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Siis võttis sõna üks nende seast, Nikodeemos, seesama, kes oli käinud varem Jeesuse juures. Ta ütles: ");
INSERT INTO ekk_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","„Meie Seadus ei mõista ju kedagi süüdi enne, kui on kuulanud ta üle ja uurinud välja, mida ta on teinud.“ ");
INSERT INTO ekk_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nemad aga vastasid talle: „Kas ehk sinagi oled Galileast? Uuri järele ja sa näed, et Galileast ei võrsu prohvetit!“ ");
INSERT INTO ekk_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Siis läksid nad kõik koju. ");
INSERT INTO ekk_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Aga Jeesus läks Õlimäele. ");
INSERT INTO ekk_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Varahommikul tuli ta tagasi templisse ning tema ümber kogunes suur rahvahulk. Ta istus ja hakkas neid õpetama. ");
INSERT INTO ekk_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Siis tõid kirjatundjad ja variserid sinna naise, kes oli tabatud abielurikkumiselt. Nad panid ta kõigi ette seisma ");
INSERT INTO ekk_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ja ütlesid Jeesusele: „Õpetaja, see naine tabati äsja abielurikkumiselt. ");
INSERT INTO ekk_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moosese Seadus käsib meil säärased naised kividega surnuks visata, aga mida ütled sina?“ ");
INSERT INTO ekk_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Selle küsimusega püüdsid nad teda lõksu meelitada, et saada alust tema süüdistamiseks. Ent Jeesus kummardas maha ja kirjutas sõrmega maapinnale. ");
INSERT INTO ekk_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kui nad aga küsimist ei jätnud, ajas ta enese sirgu ja ütles: „Kes teie seast on patuta, visaku esimesena kivi!“ ");
INSERT INTO ekk_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Siis kummardas ta jälle ja kirjutas maapinnale. ");
INSERT INTO ekk_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ent need, kes olid kuulnud ta sõnu, lahkusid üksteise järel, alates vanimast, kuni kohale jäid vaid Jeesus ja naine, kes ikka veel seisis. ");
INSERT INTO ekk_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jeesus ajas enese sirgu ja küsis: „Naine, kus nad siis on? Kas keegi ei mõistnudki sind surma?“ ");
INSERT INTO ekk_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","„Ei keegi, Issand!“ vastas naine. „Minagi ei mõista sind surma,“ ütles Jeesus. „Mine, ja siitpeale ära tee enam pattu!“ ");
INSERT INTO ekk_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kui Jeesus rääkis taas rahvale, ütles ta: „Mina olen maailma valgus. Kes järgneb mulle, ei kõnni iialgi pimeduses, vaid tal on elu valgus.“ ");
INSERT INTO ekk_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Variserid ütlesid talle: „Sa tunnistad iseenda kohta. Sinu tunnistus ei kehti.“ ");
INSERT INTO ekk_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","„Isegi kui ma tunnistan iseenda kohta,“ vastas Jeesus, „on minu tunnistus tõene, sest ma tean, kust ma olen tulnud ja kuhu ma lähen. Teie aga ei tea, kust ma olen tulnud ja kuhu ma lähen. ");
INSERT INTO ekk_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Teie mõistate kohut inimliku arusaamise kohaselt, mina aga ei mõista kellelegi üle kohut. ");
INSERT INTO ekk_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ja kui ma mõistaksingi kohut, oleks minu otsus õige, sest ma ei ole üksi, vaid minuga on Isa, kes mind saatis. ");
INSERT INTO ekk_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Samamoodi on ju ka teie Seaduses kirjas, et kahe tunnistaja ütlus on tõsi. ");
INSERT INTO ekk_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mina tunnistan enesest ja minust tunnistab Isa, kes on mind saatnud.“ ");
INSERT INTO ekk_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","„Kus on sinu isa?“ küsisid nad siis temalt. „Teie ei tunne mind ega minu Isa,“ vastas Jeesus. „Kui te tunneksite mind, siis te tunneksite ka minu Isa.“ ");
INSERT INTO ekk_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Seda rääkis Jeesus templis varalaeka juures õpetades. Kuid keegi ei võtnud teda kinni, sest tema tund ei olnud veel tulnud. ");
INSERT INTO ekk_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Siis ütles Jeesus neile: „Mina lähen ära ja te otsite mind taga ning surete oma patus. Sinna, kuhu mina lähen, ei saa teie järele tulla.“ ");
INSERT INTO ekk_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Juudid küsisid üksteiselt: „Ega ta end ometi tappa kavatse, et ta ütleb „Kuhu mina lähen, sinna ei saa teie järele tulla“?“ ");
INSERT INTO ekk_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jeesus ütles neile: „Teie olete pärit alt, mina olen pärit ülalt. Teie olete sellest maailmast, mina ei ole sellest maailmast. ");
INSERT INTO ekk_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ma ütlesin teile, et te surete oma pattudesse. Kui te ei usu, et mina olen tema, siis te tõesti surete oma pattudesse.“ ");
INSERT INTO ekk_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","„Kes sa siis oled?“ küsisid nemad. „Mida ma olen teile algusest peale rääkinud?“ vastas Jeesus. ");
INSERT INTO ekk_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","„Mul on palju teie süüdimõistmiseks öelda. Tema, kes mu saatis, on usaldusväärne, ja mida ma temalt olen kuulnud, räägin ma maailmale.“ ");
INSERT INTO ekk_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nad ei mõistnud, et ta rääkis neile Isast. ");
INSERT INTO ekk_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jeesus ütles neile: „Kui te olete Inimese Poja ülendanud, siis te mõistate, et mina olen see, ja et mina ei tee midagi omapäi, vaid räägin nõnda, nagu Isa mind on õpetanud. ");
INSERT INTO ekk_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Minu Läkitaja on minuga; ta ei ole iial jätnud mind üksi, sest ma teen alati seda, mis talle meeldib.“ ");
INSERT INTO ekk_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Seda kuuldes uskusid paljud temasse. ");
INSERT INTO ekk_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Siis ütles Jeesus temasse uskuma hakanud juutidele: „Kui te jääte minu õpetusse, olete te tõepoolest minu jüngrid. ");
INSERT INTO ekk_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Siis te tunnetate tõe, ja tõde teeb teid vabaks.“ ");
INSERT INTO ekk_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","„Meie oleme Aabrahami järeltulijad,“ kostsid need talle, „ega ole iial kedagi orjanud. Kuidas sa siis ütled, et me saame vabaks?“ ");
INSERT INTO ekk_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","„Tõesti, tõesti, ma ütlen teile,“ vastas neile Jeesus, „igaüks, kes teeb pattu, on patu ori. ");
INSERT INTO ekk_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Aga ori ei jää peresse alatiseks, kuid poeg jääb alatiseks. ");
INSERT INTO ekk_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kui nüüd Poeg teid vabastab, siis te olete ka tõeliselt vabad. ");
INSERT INTO ekk_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ma tean, et te olete Aabrahami järeltulijad. Ometi te tahate mind tappa, sest teie südames ei ole kohta minu sõnadele. ");
INSERT INTO ekk_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mina räägin seda, mida olen näinud oma Isa juures. Teie aga teete seda, mida olete kuulnud oma isa käest.“ ");
INSERT INTO ekk_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nad vastasid: „Meie isa on Aabraham!“ „Kui te oleksite Aabrahami lapsed,“ ütles Jeesus, „siis te teeksite Aabrahami tegusid. ");
INSERT INTO ekk_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nüüd aga tahate tappa mind, inimest, kes on rääkinud teile tõtt, mida ta on Jumala käest kuulnud. Aabraham ei teinud nõnda. ");
INSERT INTO ekk_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Teie teete oma isa tegusid.“ „Meie ei ole sündinud abielurikkumisest,“ ütlesid nad, „meil on üks isa – Jumal.“ ");
INSERT INTO ekk_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","„Kui Jumal oleks teie isa,“ vastas Jeesus, „siis te armastaksite mind. Sest mina olen Jumala juurest siia tulnud. Ma ei ole tulnud omapäi, vaid tema on mu saatnud. ");
INSERT INTO ekk_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Miks te mu jutust aru ei saa? Sellepärast, et te olete võimetud sellest aru saama. ");
INSERT INTO ekk_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Teie olete oma isa, kuradi, lapsed ja teete pigem seda, mida tema soovib. Tema on olnud algusest peale mõrvar ega ole iial sallinud tõde, sest tema sees ei ole tõde. Kui ta valetab, räägib ta oma emakeeles, sest ta on valetaja ja valede isa. ");
INSERT INTO ekk_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Aga kuna mina räägin tõtt, siis te mind ei usu. ");
INSERT INTO ekk_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kes teie seast saab tõestada minu süüd üheski patus? Kui ma aga tõtt räägin, miks te siis mind ei usu? ");
INSERT INTO ekk_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kes on Jumala oma, kuuleb Jumala sõnu. Teie ei kuule, sest teie ei ole Jumala omad.“ ");
INSERT INTO ekk_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Siis vastasid juudid talle: „Eks me ütle õigesti, et sa oled samaarlane ja sinus on kuri vaim?“ ");
INSERT INTO ekk_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","„Kurja vaimu minus ei ole,“ vastas Jeesus. „Ma lihtsalt austan oma Isa, teie aga teotate mind. ");
INSERT INTO ekk_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mina ei otsi austust iseendale. Aga on üks, kes seda otsib, ja tema on kohtunik. ");
INSERT INTO ekk_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tõesti, tõesti, ma ütlen teile, kes minu sõnu järgib, ei sure iialgi.“ ");
INSERT INTO ekk_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Juudid ütlesid talle: „Nüüd me oleme kindlad, et sinus on kuri vaim. Aabraham suri ja prohvetid samuti, ent sina ütled: „Kes minu sõnu järgib, ei maitse surma iialgi!“ ");
INSERT INTO ekk_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kas sina oled siis suurem kui meie isa Aabraham, kes on surnud? Ja prohvetidki on surnud. Kelleks sa ennast ometi pead?“ ");
INSERT INTO ekk_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","„Kui ma iseennast austaksin,“ vastas Jeesus, „ei oleks mu austus midagi väärt. Mind austab minu Isa, keda teie nimetate oma Jumalaks. ");
INSERT INTO ekk_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ja siiski te ei tunne teda! Aga mina tunnen. Kui mina ütleksin, et mina teda ei tunne, oleksin sama valelik nagu teie. Kuid mina tunnen teda ja järgin tema sõnu. ");
INSERT INTO ekk_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Teie isa Aabraham juubeldas, et saab näha minu päeva. Ta nägigi seda ja oli väga rõõmus.“ ");
INSERT INTO ekk_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Juudid ütlesid talle: „Sa pole veel viiskümmend aastatki vana ja oled näinud Aabrahami?“ ");
INSERT INTO ekk_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","„Tõesti, tõesti, ma ütlen teile,“ vastas Jeesus, „enne kui Aabraham sündis, olen mina!“ ");
INSERT INTO ekk_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Seepeale haarasid nad kive, et teda visata. Jeesus aga peitis end ära ja lahkus templist. ");
INSERT INTO ekk_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Edasi minnes nägi Jeesus meest, kes oli sünnist saadik pime. ");
INSERT INTO ekk_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","„Rabi,“ küsisid jüngrid temalt, „kelle patu pärast sündis ta pimedana: kas tema enda või ta vanemate?“ ");
INSERT INTO ekk_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","„Ei ole pattu teinud tema ega ta vanemad,“ vastas Jeesus. „See on sündinud, et temas saaks nähtavaks Jumala töö. ");
INSERT INTO ekk_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kuni kestab päev, peame tegema selle töid, kes mind saatis. Öö on saabumas, kui keegi ei saa midagi teha. ");
INSERT INTO ekk_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kuni mina olen maailmas, olen ma maailma valgus.“ ");
INSERT INTO ekk_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Seda öelnud, sülitas Jeesus maha ja tegi süljest muda, määris seda pimeda silmadele ");
INSERT INTO ekk_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ja ütles talle: „Mine pese ennast Siiloahi tiigis!“ (Siiloah tähendab läkitatut.) Mees läks, pesi ja naasis nägijana. ");
INSERT INTO ekk_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Siis imestasid tema naabrid ja need, kes olid varem näinud teda kerjamas: „Kas mitte seesama mees ei istunud siin kerjates?“ ");
INSERT INTO ekk_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ühed kinnitasid: „Seesama,“ teised vaidlesid: „Ei, vaid tema sarnane.“ Mees ise aga ütles: „Ma olen seesama mees!“ ");
INSERT INTO ekk_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Siis pärisid nad temalt: „Kuidas su silmad nägema hakkasid?“ ");
INSERT INTO ekk_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ta vastas: „Mees nimega Jeesus tegi muda, määris mu silmadele ning käskis minna Siiloahi tiigi juurde ja ennast seal pesta. Ma läksin, pesin ja saingi nägijaks.“ ");
INSERT INTO ekk_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","„Kus on see mees praegu?“ küsisid nad temalt. „Ma ei tea,“ vastas ta. ");
INSERT INTO ekk_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nad viisid mehe, kes oli pime olnud, variseride juurde. ");
INSERT INTO ekk_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nimelt oli Jeesus hingamispäeval muda teinud ja ta silmad avanud. ");
INSERT INTO ekk_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nüüd küsisid variserid temalt, kuidas ta oli saanud nägijaks. Ta rääkis: „Jeesus pani muda mu silmadele, ma pesin ennast ja nüüd ma näen!“ ");
INSERT INTO ekk_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Siis ütlesid mõned variserid: „Too mees ei ole Jumalast, sest ta ei pea hingamispäeva.“ Teised aga küsisid: „Kuidas saaks patune inimene anda selliseid tunnustähti?“ Ja nad ei leidnud üksmeelt. ");
INSERT INTO ekk_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Lõpuks küsitlesid nad nägijakssaanut uuesti: „Mida ütled sina selle inimese kohta? Kas ta avas sinu silmad?“ „Ta on prohvet,“ vastas tema. ");
INSERT INTO ekk_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Siis ei tahtnud juutide ülemad uskuda, et ta oli olnud pime ja saanud nägijaks ning kutsusid kohale ta vanemad. ");
INSERT INTO ekk_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nad küsisid neilt: „Kas see on teie poeg, kelle te väidate olevat sündinud pimedana? Kuidas ta nüüd siis näeb?“ ");
INSERT INTO ekk_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tema vanemad vastasid: „Meie teame nii palju, et see on meie poeg ja ta sündis pimedana. ");
INSERT INTO ekk_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kuidas ta aga nüüd on nägema hakanud, seda meie ei tea, ega tea ka, kes ta nägijaks tegi. Küsige tema enda käest! Ta on täisealine, ta oskab ise enda eest rääkida.“ ");
INSERT INTO ekk_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nii vastasid nad seepärast, et kartsid juutide ülemaid. Need olid omavahel juba kokku leppinud, et kes iganes tunnistab Jeesuse Messiaks, see heidetakse sünagoogist välja. ");
INSERT INTO ekk_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Seepärast ütlesidki ta vanemad: „Ta on täisealine. Küsige tema enda käest!“ ");
INSERT INTO ekk_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nüüd kutsusid variserid pimedana sündinu taas enese ette ja ütlesid talle: „Anna Jumalale au tõtt rääkides. Me teame, et see inimene on patune.“ ");
INSERT INTO ekk_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","„Kas ta on patune või mitte, seda ma ei tea,“ vastas too. „Mina tean vaid, et olin pime, aga nüüd ma näen!“ ");
INSERT INTO ekk_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","„Mida ta sinuga tegi?“ küsisid nad. „Kuidas ta su silmad avas?“ ");
INSERT INTO ekk_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","„Ma ju rääkisin teile,“ vastas mees, „aga te poleks nagu kuulnudki. Miks te tahate seda uuesti kuulda? Kas ka teie tahate saada tema jüngriteks?“ ");
INSERT INTO ekk_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nüüd nad sõimasid ta läbi ja ütlesid: „Sina ise oled tema jünger! Meie oleme Moosese jüngrid. ");
INSERT INTO ekk_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Meie teame, et Jumal on rääkinud Moosesega. Aga kust see mees pärit on, seda me ei tea.“ ");
INSERT INTO ekk_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","„Just see panebki imestama,“ kostis endine pime, „et teie ei tea, kust see mees pärit on. Ja ometi tema tegi mu nägijaks! ");
INSERT INTO ekk_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Me ju teame, et Jumal ei võta kuulda patuseid. Aga kui keegi on jumalakartlik ja täidab tema tahtmist, siis teda võtab ta kuulda. ");
INSERT INTO ekk_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Aegade algusest peale pole kuuldud, et keegi oleks teinud nägijaks pimedana sündinu. ");
INSERT INTO ekk_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kui see mees ei oleks Jumalast, ei suudaks ta midagi säärast teha.“ ");
INSERT INTO ekk_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","„Kas sina, kes sa oled sündinud üleni pattudes,“ kurjustasid variserid, „tuled meid õpetama?“ Ja nad viskasid ta sünagoogist välja. ");
INSERT INTO ekk_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kuuldes, mis oli juhtunud, otsis Jeesus ta üles ja ütles talle: „Kas sa usud Inimese Pojasse?“ ");
INSERT INTO ekk_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","„Kes see on, Issand?“ küsis ta. „Räägi mulle, et ma võiksin temasse uskuda!“ ");
INSERT INTO ekk_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jeesus vastas: „Just praegu sa teda näedki. Tema on see, kes sinuga räägib.“ ");
INSERT INTO ekk_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","„Ma usun, Issand,“ ütles too ning põlvitas Jeesuse ette. ");
INSERT INTO ekk_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","„Mina olen maailma tulnud kohut mõistma,“ ütles Jeesus, „et pimedad võiksid näha ja nägijad jääda pimedaks.“ ");
INSERT INTO ekk_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Seal olid mõned variserid, kes seda kuuldes Jeesuselt küsisid: „Kas see tähendab, et ka meie oleme pimedad?“ ");
INSERT INTO ekk_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","„Kui te oleksite pimedad,“ vastas Jeesus, „ei oleks teil pattu. Aga et te nüüd ütlete: „Meie näeme“, siis ei vabasta miski teid patust.“ ");
INSERT INTO ekk_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","„Tõesti, tõesti, ma ütlen teile, kes ei sisene lambatarasse väravast, vaid ronib sisse mujalt, on varas ja röövel. ");
INSERT INTO ekk_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Väravast siseneja on lammaste karjane. ");
INSERT INTO ekk_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Temale avab värava valvur ja lambad kuulavad ta häält. Ta kutsub oma lambaid nimepidi ja juhib nad tarast välja. ");
INSERT INTO ekk_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kui ta on viinud välja kogu oma karja, käib ta nende ees ja lambad järgnevad talle, sest nad tunnevad ta häält. ");
INSERT INTO ekk_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Võõrale nad ei järgne, vaid põgenevad tema eest, sest võõraste häält nad ei tunne.“ ");
INSERT INTO ekk_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Sellise tähendamissõna rääkis Jeesus neile, variserid aga ei taibanud, mida ta tahtis öelda. ");
INSERT INTO ekk_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Seepärast rääkis Jeesus uuesti: „Tõesti, tõesti, ma ütlen teile, mina olen lammaste värav. ");
INSERT INTO ekk_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Vargaid ja röövleid on tulnud enne mind, kuid lambad ei ole neid kuulanud. ");
INSERT INTO ekk_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mina olen värav. Kes siseneb minu kaudu, see päästetakse. Nad käivad sisse ja välja ning leiavad karjamaa. ");
INSERT INTO ekk_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Varas tuleb vaid selleks, et riisuda, tappa ja hävitada. Mina olen tulnud selleks, et neil oleks elu kogu selle täiuses. ");
INSERT INTO ekk_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Mina olen hea karjane. Hea karjane annab oma elu lammaste eest. ");
INSERT INTO ekk_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Palgaline aga ei ole karjane ega pea lambaid omaks. Kui ta näeb hunti tulemas, jätab ta lambad maha ja põgeneb. Hunt tungib neile kallale ja ajab karja laiali. ");
INSERT INTO ekk_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Palgaline põgeneb, sest tema töötab tasu pärast ega hooli lammastest. ");
INSERT INTO ekk_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Mina olen hea karjane. Mina tunnen oma lambaid ja nemad tunnevad mind, ");
INSERT INTO ekk_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","nagu Isa tunneb mind ja mina tunnen Isa. Ja ma annan oma elu lammaste eest. ");
INSERT INTO ekk_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mul on veel teisi lambaid, kes ei ole sellest tarast. Ma pean neidki karjatama. Ka nemad kuulavad mu häält. Siis on üks kari ja üks karjane. ");
INSERT INTO ekk_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Isa armastab mind, sest ma annan oma elu, et see uuesti tagasi võtta. ");
INSERT INTO ekk_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Keegi ei võta seda minult vägisi. Ma ise annan selle. Mul on meelevald see ära anda ja mul on meelevald see tagasi võtta. Nõnda on Isa mul käskinud teha.“ ");
INSERT INTO ekk_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nende sõnade peale läksid juutide arvamused lahku. ");
INSERT INTO ekk_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Paljud ütlesid: „Temas on kuri vaim. Ta ajab segast juttu. Miks teda üldse kuulata?“ ");
INSERT INTO ekk_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Teised ütlesid: „See ei ole kurjast vaimust vaevatu jutt. Ega siis kuri vaim saa pimedaid nägijaiks teha!“ ");
INSERT INTO ekk_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Siis jõudis Jeruusalemmas kätte templipuhastuspüha. Oli talv ");
INSERT INTO ekk_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ja Jeesus kõndis ringi templis Saalomoni sammaskäigus. ");
INSERT INTO ekk_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Seal kogunesid juudid tema ümber ja ütlesid talle: „Kaua sa hoiad meid veel teadmatuses? Kui sina oled Messias, siis ütle seda meile otse!“ ");
INSERT INTO ekk_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","„Ma olen teile öelnud, aga te ei usu,“ vastas Jeesus. „Minust tunnistavad teod, mida ma teen oma Isa nimel. ");
INSERT INTO ekk_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Aga teie ei usu, sest te ei kuulu mu lammaste hulka. ");
INSERT INTO ekk_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Minu lambad kuulavad mu häält. Mina tunnen neid ja nad järgnevad mulle. ");
INSERT INTO ekk_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mina annan neile igavese elu ja nad ei hukku iial. Keegi ei saa neid minu käest röövida. ");
INSERT INTO ekk_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Minu Isa, kes andis nad mulle, on suurim kõigist – Isa käest ei saa neid keegi röövida. ");
INSERT INTO ekk_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mina ja Isa oleme üks.“ ");
INSERT INTO ekk_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jälle tahtsid juudid kive tuua, et teda nendega surnuks visata, ");
INSERT INTO ekk_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","aga Jeesus küsis neilt: „Ma olen teile näidanud palju häid tegusid Isalt. Millise teo eest te tahate mind kividega visata?“ ");
INSERT INTO ekk_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","„Me ei viska sind kividega heade tegude eest,“ vastasid nad, „vaid jumalateotuse pärast, et sina, olles inimene, nimetad ennast Jumalaks.“ ");
INSERT INTO ekk_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jeesus vastas neile: „Eks ole ju teie Seaduses kirjutatud: „Ma ütlesin: „Te olete jumalad.“ “ ");
INSERT INTO ekk_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kui seal on nimetatud jumalateks neid, kelle kätte anti Jumala sõna – ja Pühakirja ei saa kõrvale heita –, ");
INSERT INTO ekk_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","siis kuidas te süüdistate jumalateotuses mind, keda Isa on pühitsenud ja läkitanud maailma, kuna ma ütlesin „mina olen Jumala Poeg“? ");
INSERT INTO ekk_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kui ma ei tee oma Isa tegusid, siis ärge uskuge mind! ");
INSERT INTO ekk_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kui ma aga teen, siis uskuge neid tegusid, isegi kui te mind ei usu. Ja te mõistate, et Isa on minus ja mina olen Isas.“ ");
INSERT INTO ekk_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Seepeale tahtsid nad jälle teda kinni võtta, kuid ta pääses nende käest. ");
INSERT INTO ekk_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nüüd läks Jeesus taas teisele poole Jordanit ning peatus paigas, kus Johannes oli algul ristinud. ");
INSERT INTO ekk_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tema juurde tuli rohkesti rahvast, kes ütlesid: „Johannes ei teinud küll ühtki imetegu, aga kõik, mis ta selle mehe kohta ütles, oli õige.“ ");
INSERT INTO ekk_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ja paljud seal hakkasid Jeesusesse uskuma. ");
INSERT INTO ekk_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Siis jäi haigeks üks mees – Laatsarus Betaaniast, Maarja ja tema õe Marta külast. ");
INSERT INTO ekk_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maarja oli seesama, kes oli võidnud Issandat hinnalise lõhnasalviga ja kuivatanud ta jalgu oma juustega – tema vend Laatsarus oligi jäänud haigeks. ");
INSERT INTO ekk_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Seepärast saatsid õed Jeesusele sõna: „Issand, su sõber, keda sa armastad, on haige.“ ");
INSERT INTO ekk_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Seda kuuldes ütles Jeesus: „See haigus ei ole surmaks, vaid Jumala auks, et austada selle läbi Jumala Poega.“ ");
INSERT INTO ekk_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jeesus armastas Martat ja ta õde ja Laatsarust. ");
INSERT INTO ekk_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Kuigi ta kuulis Laatsaruse haigestumisest, jäi Jeesus veel kaheks päevaks sinna, kus ta viibis, ");
INSERT INTO ekk_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","enne kui ütles oma jüngritele: „Lähme tagasi Juudamaale!“ ");
INSERT INTO ekk_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","„Rabi!“ vastasid need. „Alles see oli, kui juudid tahtsid sind kividega surnuks visata, ja juba lähed sa tagasi!“ ");
INSERT INTO ekk_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","„Eks igas päevas ole kaksteist tundi?“ ütles Jeesus. „Kui keegi kõnnib päeval, siis ta ei komista, sest ta näeb selle ilma valgust. ");
INSERT INTO ekk_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kui aga keegi kõnnib öösel, siis ta komistab, sest tal pole valgust.“ ");
INSERT INTO ekk_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Seda öelnud, lausus ta: „Meie sõber Laatsarus on uinunud. Aga ma lähen teda üles äratama.“ ");
INSERT INTO ekk_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","„Issand,“ vastasid jüngrid, „kui ta magab, on tal varsti parem!“ ");
INSERT INTO ekk_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ent Jeesus oli rääkinud Laatsaruse surmast, nemad aga arvasid, et ta mõtles tavalist und. ");
INSERT INTO ekk_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nüüd ütles Jeesus neile otse: „Laatsarus on surnud, ");
INSERT INTO ekk_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ja teie pärast ma olen rõõmus, et mind ei olnud seal, et te võiksite uskuda. Lähme tema juurde!“ ");
INSERT INTO ekk_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Siis ütles jünger nimega Toomas ehk Kaksik oma kaaslastele: „Lähme ka meie, et surra koos temaga!“ ");
INSERT INTO ekk_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kohale jõudes leidis Jeesus, et Laatsarus oli juba neli päeva hauas lamanud. ");
INSERT INTO ekk_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betaania asus Jeruusalemma lähedal, vaid kolme kilomeetri kaugusel. ");
INSERT INTO ekk_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Paljud juudid olid tulnud Marta ja Maarja kodusse, et lohutada neid venna surma pärast. ");
INSERT INTO ekk_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kui Marta kuulis, et Jeesus on tulemas, läks ta temale vastu. Maarja aga jäi koju. ");
INSERT INTO ekk_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","„Issand, kui sina oleksid olnud siin,“ ütles Marta Jeesusele, „ei oleks mu vend surnud. ");
INSERT INTO ekk_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Aga ma tean nüüdki, et Jumal annab sulle, mida sa iganes temalt palud.“ ");
INSERT INTO ekk_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","„Sinu vend tõuseb üles,“ ütles Jeesus. ");
INSERT INTO ekk_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","„Ma tean, ta tõuseb üles viimase päeva ülestõusmises,“ vastas Marta. ");
INSERT INTO ekk_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","„Mina olen ülestõusmine ja elu,“ ütles Jeesus. „Kes minusse usub, see elab, ehkki ta sureb. ");
INSERT INTO ekk_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ükski, kes elab ja kes usub minusse, ei sure iial. Usud sa seda?“ ");
INSERT INTO ekk_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","„Jah, Issand,“ vastas Marta. „Ma tõesti usun, et sina oled Messias, Jumala Poeg, kes pidi maailma tulema.“ ");
INSERT INTO ekk_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Seda öelnud, läks Marta koju ja kutsus vaikselt oma õde Maarjat: „Õpetaja on kohal ja ta kutsub sind!“ ");
INSERT INTO ekk_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nende sõnade peale tõusis Maarja ruttu ja läks Jeesuse juurde. ");
INSERT INTO ekk_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jeesus aga ei olnud veel jõudnud külasse, vaid viibis seal, kuhu Marta oli talle vastu läinud. ");
INSERT INTO ekk_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Kui Maarjat lohutama tulnud juudid nägid, kui kärmesti ta tõusis ja majast väljus, järgnesid nad talle, arvates, et ta läheb haua juurde nutma. ");
INSERT INTO ekk_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kuid Maarja läks sinna, kus oli Jeesus, ja langes ta jalge ette sõnadega: „Issand, kui sa oleksid olnud siin, ei oleks mu vend surnud!“ ");
INSERT INTO ekk_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nähes Maarjat ja temaga kaasa tulnud juute nutmas, oli Jeesus vaimus vihane ja küsis ärritunult: ");
INSERT INTO ekk_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","„Kuhu te ta panite?“ Nemad vastasid: „Tule ja vaata, Issand!“ ");
INSERT INTO ekk_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jeesus nuttis. ");
INSERT INTO ekk_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Seepeale tähendasid juudid üksteisele: „Vaadake, kuidas ta teda armastas!“ ");
INSERT INTO ekk_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kuid mõned neist küsisid: „Kas tema, kes tegi pimeda nägijaks, ei oleks võinud hoida Laatsarust suremast?“ ");
INSERT INTO ekk_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jeesus, olles veelkord vihane, tuli hauakambri juurde. See oli koobas, millele oli kivi sissekäigu ette pandud. ");
INSERT INTO ekk_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","„Veeretage kivi kõrvale!“ käskis Jeesus. „Issand,“ vastas surnu õde Marta, „ta juba lehkab. Täna on neljas päev pärast matust.“ ");
INSERT INTO ekk_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jeesus vastas: „Kas ma ei öelnud sulle, et kui sa usud, siis sa saad näha Jumala au?“ ");
INSERT INTO ekk_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nüüd veeretati kivi kõrvale. Jeesus tõstis pilgu taeva poole ja ütles: „Isa, ma tänan sind, et sa oled mind kuulnud. ");
INSERT INTO ekk_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mina tean, et sa kuuled mind alati. Ütlen seda vaid inimeste pärast, kes siin seisavad, et nad usuksid, et sina oled minu läkitanud.“ ");
INSERT INTO ekk_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Seda öelnud, hüüdis Jeesus valjusti: „Laatsarus, tule välja!“ ");
INSERT INTO ekk_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ja surnu tuli hauast välja, käed ja jalad linasesse riidesse mähitud, higirätik näo ümber. „Siduge ta lahti ja laske tal minna!“ käskis Jeesus. ");
INSERT INTO ekk_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Seetõttu hakkasid temasse uskuma paljud juudid, kes olid tulnud Maarjale külla ja näinud, mis oli sündinud. ");
INSERT INTO ekk_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kuid mõned neist läksid variseride juurde ja rääkisid neile, mis Jeesus oli teinud. ");
INSERT INTO ekk_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Siis kutsusid ülempreestrid ja variserid kokku Suurkohtu. „Mida me ette võtame?“ arutasid nad. „See inimene annab palju tunnustähti. ");
INSERT INTO ekk_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kui me jätame ta rahule, hakkavad kõik temasse uskuma, ning siis tulevad roomlased ja pühivad maa pealt ära nii meie templi kui ka rahva.“ ");
INSERT INTO ekk_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ent üks nende seast, mees nimega Kaifas, kes oli sel aastal ülempreester, ütles: „Te ei tea midagi! ");
INSERT INTO ekk_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Te ei mõista, et teie jaoks on parem, kui üks inimene sureb rahva eest, kui et kogu rahvas hukkub.“ ");
INSERT INTO ekk_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Neid sõnu ei öelnud ta omast peast, vaid selle aasta ülempreestrina kuulutas ta ette, et Jeesus peab surema juudi rahva eest, ");
INSERT INTO ekk_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ja mitte ainult nende eest, vaid üle kogu maailma pillutatud Jumala laste eest, tuues nad kokku ja tehes nad üheks. ");
INSERT INTO ekk_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Sellest päevast peale otsustasid juutide ülemad Jeesuse ära tappa. ");
INSERT INTO ekk_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Seepärast ei liikunud Jeesus Juudamaal enam avalikult ringi, vaid siirdus kõrbeäärsesse piirkonda, Efraimi külla, ning peatus seal oma jüngritega. ");
INSERT INTO ekk_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ent juutide paasapühad olid tulemas ning palju maarahvast läks pühade eel aegsasti Jeruusalemma, et võtta osa puhastustalitustest. ");
INSERT INTO ekk_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nad otsisid Jeesust ja arutasid templis seistes: „Mis te arvate? Kas ta ei tulegi pühadeks?“ ");
INSERT INTO ekk_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Sest ülempreestrid ja variserid olid saatnud laiali korraldused, et kui keegi teab Jeesuse asukohta, peab ta sellest neile teatama, et nad saaksid ta kinni võtta. ");
INSERT INTO ekk_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Kuus päeva enne paasapühi jõudis Jeesus Betaaniasse, kus elas Laatsarus, kelle ta oli surnuist üles äratanud. ");
INSERT INTO ekk_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Seal korraldati Jeesuse auks pidusöök. Marta kattis laua ning Laatsarus oli koos teistega Jeesuse juures laua ümber. ");
INSERT INTO ekk_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Siis võttis Maarja umbes poole kilogrammi jagu ehtsat ja hinnalist nardisalvi, võidis Jeesuse jalgu ja kuivatas neid oma juustega. Kogu maja täitus nardisalvi lõhnaga. ");
INSERT INTO ekk_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Kuid Juudas Iskariot, üks Jeesuse jüngritest – see, kes ta hiljem ära andis – küsis: ");
INSERT INTO ekk_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","„Miks pigem ei müüdud seda salvi kolmesaja teenari eest ega jagatud raha vaestele?“ ");
INSERT INTO ekk_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ent seda ta ei öelnud sellepärast, et ta vaestest hoolis, vaid et ta oli varas. Laekahoidjana võttis ta endale osa sellest, mis laekasse pandi. ");
INSERT INTO ekk_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jeesus vastas talle: „Jäta ta rahule! Ta pidi selle salvi minu matmise päevaks hoidma. ");
INSERT INTO ekk_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Vaeseid on alati teie juures, aga mind ei ole teil alati.“ ");
INSERT INTO ekk_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Siis sai suur hulk juute teada Jeesuse sealviibimisest ja nad tulid sinna – mitte ainult Jeesuse pärast, vaid ka selleks, et näha Laatsarust, kelle ta oli surnuist üles tõstnud. ");
INSERT INTO ekk_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Seepärast võtsid ülempreestrid nõuks tappa ka Laatsaruse, ");
INSERT INTO ekk_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","sest tema tõttu läksid paljud juudid Jeesuse poole üle ning uskusid temasse. ");
INSERT INTO ekk_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Järgmisel päeval kuulis pühadeks tulnud suur rahvahulk, et Jeesus on teel Jeruusalemma. ");
INSERT INTO ekk_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nad võtsid kätte palmioksi, läksid talle vastu ja hüüdsid: „Hoosanna! Õnnistatud olgu, kes tuleb Issanda nimel! Iisraeli kuningas!“ ");
INSERT INTO ekk_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jeesus aga leidis eeslisälu ja istus selle selga, nõnda nagu on kirjutatud: ");
INSERT INTO ekk_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","„Ära karda, Siioni tütar! Vaata, su kuningas tuleb, sõites eeslisälu seljas!“ ");
INSERT INTO ekk_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Sellest ei saanud Jeesuse jüngrid algul aru, aga kui Jeesus oli läinud tagasi taevasesse ausse, meenus neile, et nii oli temast kirjutatud Pühakirjas ning see oli nüüd täide läinud. ");
INSERT INTO ekk_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Rahva seas oli ka neid, kes olid oma silmaga näinud, kuidas Jeesus Laatsaruse hauast välja kutsus ja surnuist üles äratas. Need rääkisid nüüd sellest kõigile avalikult. ");
INSERT INTO ekk_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Seepärast läkski rahvahulk talle tee peale vastu, et nad olid kuulnud sellest tunnustähest. ");
INSERT INTO ekk_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Siis rääkisid variserid isekeskis: „Näete, te ei suuda midagi! Kogu maailm jookseb tema järel!“ ");
INSERT INTO ekk_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ent pühadeks Jeruusalemma palvetama tulnud inimeste seas olid ka mõned kreeklased. ");
INSERT INTO ekk_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Need pöördusid Filippuse poole, kes oli pärit Betsaidast Galileast, ja palusid teda: „Isand, me tahaksime kohtuda Jeesusega!“ ");
INSERT INTO ekk_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filippus läks ja rääkis seda Andreasele; Andreas ja Filippus läksid siis ja rääkisid seda Jeesusele. ");
INSERT INTO ekk_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jeesus vastas: „Tund on tulnud, et Inimese Poega austataks. ");
INSERT INTO ekk_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tõesti, tõesti, ma ütlen teile, kui nisuiva ei lange mulda ega sure, siis see jääb üksi. Kui ta aga sureb, kannab see palju vilja. ");
INSERT INTO ekk_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kes oma elu armastab, kaotab selle, ja kes oma elu põlgab selles ilmas, hoiab selle igaveseks eluks. ");
INSERT INTO ekk_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kui keegi tahab mind teenida, siis ta järgnegu mulle. Kus olen mina, seal on ka mu teener. Minu Isa austab seda, kes mind teenib. ");
INSERT INTO ekk_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Nüüd on mu hing ärevil. Mida ma peaksin ütlema? Isa, päästa mind sellest tunnist! Ei, selle tunni pärast ma olengi tulnud. ");
INSERT INTO ekk_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Isa, austa oma nime!“ Ja taevast vastas hääl: „Ma olen seda austanud ja austan veel!“ ");
INSERT INTO ekk_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mõned juuresolijaist arvasid, et nad kuulevad kõuemürinat, teised ütlesid: „Ingel kõneles temaga!“ ");
INSERT INTO ekk_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jeesus aga ütles: „See hääl ei kostnud mitte minu, vaid teie pärast. ");
INSERT INTO ekk_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nüüd mõistetakse kohut selle maailma üle, nüüd tõugatakse välja selle maailma vürst. ");
INSERT INTO ekk_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kui mind tõstetakse maa pealt üles, tõmban ma kõik inimesed enda juurde.“ ");
INSERT INTO ekk_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ta ütles seda, et näidata, millisesse surma ta peab surema. ");
INSERT INTO ekk_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Rahvahulk aga vastas: „Meie oleme Seadusest kuulnud, et Messias jääb igaveseks. Miks sina siis ütled, et Inimese Poeg tõstetakse üles? Kes see Inimese Poeg on?“ ");
INSERT INTO ekk_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","„Veel pisut aega on valgus teie keskel,“ ütles Jeesus. „Käige valguses, kuni teil seda on, et teid ei haaraks pimedus. Pimedas käija ei tea, kuhu ta läheb. ");
INSERT INTO ekk_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kuni teil on valgus, uskuge valgusesse, et te saaksite valguse lasteks!“ Kui ta seda oli rääkinud, lahkus ta ja hoidis end nende eest varjul. ");
INSERT INTO ekk_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kuigi Jeesus oli andnud nende nähes palju tunnustähti, ei uskunud inimesed ikka veel temasse, ");
INSERT INTO ekk_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","et läheks täide prohvet Jesaja ettekuulutus: „Issand, kes on uskunud meie kuulutust ja kellele on ilmutatud Issanda käsivart?“ ");
INSERT INTO ekk_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Seepärast ei suutnud nad uskuda, sest nagu Jesaja veel on öelnud: ");
INSERT INTO ekk_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","„Ta on löönud pimedusega nende silmi ja mõistmatusega nende südant, et nad silmadega ei näeks ja südamega ei mõistaks ega pöörduks, et ma saaksin neid tervendada.“ ");
INSERT INTO ekk_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Seda ütles Jesaja, sest ta nägi Jeesuse auhiilgust ja rääkis temast. ");
INSERT INTO ekk_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kõigele vaatamata uskusid isegi paljud ülemad Jeesusesse, ent kartusest variseride ees ei rääkinud nad sellest avalikult, et neid sünagoogist välja ei heidetaks. ");
INSERT INTO ekk_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nad pidasid inimlikku kiitust tähtsamaks Jumala kiitusest. ");
INSERT INTO ekk_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Aga Jeesus hüüdis: „Kes usub minusse, ei usu ainult minusse, vaid ka sellesse, kes minu on läkitanud. ");
INSERT INTO ekk_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kes näeb mind, näeb ka minu Läkitajat. ");
INSERT INTO ekk_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mina olen tulnud maailma valguseks, et ükski, kes usub minusse, ei jääks pimedusse. ");
INSERT INTO ekk_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kes kuuleb mu sõnu ega pea neid, selle üle ei mõista mina kohut, sest mina ei tulnud maailma üle kohut mõistma, vaid seda päästma. ");
INSERT INTO ekk_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kes hülgab minu ega võta kuulda mu sõnu, sellel on kohtumõistja olemas. Sõna, mida ma olen kuulutanud, mõistab ta hukka viimasel päeval. ");
INSERT INTO ekk_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Sest mina ei ole seda rääkinud iseenda nimel, vaid Isa, kes minu saatis, on mind käskinud öelda kõike seda, mida ma olen rääkinud. ");
INSERT INTO ekk_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ja ma tean, et tema käsk viib igavesse ellu. Mida mina räägin, on see, mida Isa on mul käskinud rääkida.“ ");
INSERT INTO ekk_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Paasapühade saabudes teadis Jeesus, et kätte on jõudnud tund, kui ta läheb siit maailmast Isa juurde. Armastanud omaenda inimesi, kes olid maailmas, armastas ta neid lõpuni. ");
INSERT INTO ekk_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jeesus sõi jüngritega õhtusööki ja kurat oli juba pannud Juudas Iskarioti, Siimoni poja südamesse, et ta tema reedaks. ");
INSERT INTO ekk_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jeesus teadis, et Isa on tema kätte kõik andnud ning et ta on tulnud Jumala juurest ja läheb tagasi Jumala juurde. ");
INSERT INTO ekk_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Niisiis tõusis Jeesus söömast, võttis kuue seljast, sidus rätiku vööle, ");
INSERT INTO ekk_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","valas vett kaussi ja hakkas pesema jüngrite jalgu, kuivatades neid oma vööl oleva rätikuga. ");
INSERT INTO ekk_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kui ta Siimon Peetruse juurde jõudis, ütles Peetrus talle: „Issand, kas sina tahad pesta minu jalgu?“ ");
INSERT INTO ekk_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","„Praegu sa ei mõista seda, mida ma teen,“ vastas Jeesus. „Aga hiljem saad sa aru.“ ");
INSERT INTO ekk_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","„Eluilmaski ei pese sina mu jalgu!“ ütles Peetrus. Jeesus vastas: „Kui mina sind ei pese, ei ole sul osadust minuga.“ ");
INSERT INTO ekk_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Siimon Peetrus ütles: „Issand, ära pese siis ainult mu jalgu, vaid ka mu käsi ja pead!“ ");
INSERT INTO ekk_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jeesus vastas: „See, kes on end äsja pesnud, on üleni puhas ega vaja muud kui jalgade pesemist. Teiegi olete puhtad, aga mitte kõik.“ ");
INSERT INTO ekk_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jeesus ju teadis, kes tema ära annab, seepärast ta ütleski: „Teie ei ole kõik puhtad.“ ");
INSERT INTO ekk_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kui Jeesus oli pesnud jüngrite jalgu, võttis ta kuue ja tuli oma kohale tagasi. „Kas te mõistate, mida ma teile tegin?“ küsis ta neilt. ");
INSERT INTO ekk_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","„Te kutsute mind Õpetajaks ja Issandaks, ja hästi teete, sest seda ma olen. ");
INSERT INTO ekk_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kui nüüd mina, teie Issand ja Õpetaja, olen pesnud teie jalgu, siis peate teiegi pesema üksteise jalgu. ");
INSERT INTO ekk_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ma olen jätnud teile eeskuju, et teiegi teeksite nõnda, nagu mina olen teinud teile. ");
INSERT INTO ekk_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tõesti, tõesti, ma ütlen teile, ei ole teener suurem oma isandast ega sõnumitooja suurem oma läkitajast. ");
INSERT INTO ekk_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kui te seda teate, olete te õnnistatud, kui te nõnda ka teete. ");
INSERT INTO ekk_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ma ei räägi seda teie kõigi kohta. Ma ju tean, keda ma olen valinud. Ma räägin, et läheks täide Pühakirja ettekuulutus: „Mees, kes sööb leiba koos minuga, on pöördunud minu vastu.“ ");
INSERT INTO ekk_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ma räägin seda teile juba praegu, et kui see juhtub, siis te võiksite uskuda, et mina olen see, kes ma olen. ");
INSERT INTO ekk_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tõesti, tõesti, ma ütlen teile, kes iganes võtab vastu selle, kelle mina läkitan, võtab vastu minu. Ja see, kes võtab vastu minu, võtab vastu selle, kes minu on läkitanud.“ ");
INSERT INTO ekk_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Seda öelnud, tundis Jeesus vaimus sügavat ängi ja tunnistas: „Tõesti, tõesti, ma ütlen teile, üks teie seast annab mu ära!“ ");
INSERT INTO ekk_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jüngrid vahetasid nõutult pilke ega osanud arvata, kellest ta räägib. ");
INSERT INTO ekk_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Üks neist – jünger, keda Jeesus armastas – oli laua ääres tema kõrval. ");
INSERT INTO ekk_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Talle andis Siimon Peetrus märku ja ütles: „Küsi temalt, kes see on.“ ");
INSERT INTO ekk_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","See jünger kallutas end Jeesuse rinnale ja küsis: „Issand, kes see on?“ ");
INSERT INTO ekk_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jeesus vastas: „See, kelle jaoks ma kastan leivatüki kastmesse ja ulatan talle.“ Ta kastis leivatüki kastmesse ja ulatas selle Juudasele, Siimon Iskarioti pojale. ");
INSERT INTO ekk_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Koos leivatükiga läks saatan Juudase sisse. Siis ütles Jeesus Juudasele: „Mida sa teed, tee kiiresti!“ ");
INSERT INTO ekk_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Lauasolijad ei saanud aru, mille kohta ta seda ütles. ");
INSERT INTO ekk_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kuna Juudas oli laekahoidja, siis mõned arvasid, et Jeesus käskis tal osta, mis pühadeks tarvis on või midagi vaestele jagada. ");
INSERT INTO ekk_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Kui Juudas oli võtnud leivatüki, lahkus ta kohe. Oli öö. ");
INSERT INTO ekk_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Kui nüüd Juudas oli lahkunud, ütles Jeesus: „Nüüd austatakse Inimese Poeg ja Jumal austatakse temas. ");
INSERT INTO ekk_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kui Jumal on temas austatud, siis austab Jumal Pojas ka ennast ja ta austab teda kohe. ");
INSERT INTO ekk_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Lapsed, mina olen teie juures veel pisut aega. Te hakkate mind otsima, ja nagu ma ütlesin juutidele, ütlen nüüd teilegi: „Kuhu mina lähen, sinna ei saa teie tulla.“ ");
INSERT INTO ekk_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ma annan teile uue käsu: armastage üksteist! Nii nagu mina olen teid armastanud, armastage teiegi üksteist! ");
INSERT INTO ekk_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Sellest tunnevad kõik, et te olete minu jüngrid, kui te üksteist armastate.“ ");
INSERT INTO ekk_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","„Issand, kuhu sa siis lähed?“ küsis nüüd temalt Siimon Peetrus. „Kuhu mina lähen,“ vastas Jeesus, „sinna ei saa sina mulle praegu järgneda. Aga sa järgned hiljem.“ ");
INSERT INTO ekk_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","„Issand, miks ei saa ma sulle praegu järgneda?“ küsis Peetrus. „Ma olen valmis andma sinu eest oma elu!“ ");
INSERT INTO ekk_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","„Kas sina oled valmis andma minu eest oma elu?“ ütles Jeesus. „Tõesti, tõesti, ma ütlen sulle, veel enne kui kukk kireb, salgad sa mind maha kolm korda!“ ");
INSERT INTO ekk_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","„Ärge laske ärevust oma südameisse! Uskuge Jumalasse ja uskuge minusse. ");
INSERT INTO ekk_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Minu Isa majas on palju tube. Kui see nii ei oleks, kas ma oleksin siis öelnud, et ma lähen teile kodu ette valmistama? ");
INSERT INTO ekk_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ja kui ma olen läinud ja teile kodu ette valmistanud, tulen ma tagasi ja võtan teid kaasa enese juurde. Siis olete teiegi seal, kus olen mina. ");
INSERT INTO ekk_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ja te teate teed sinna, kuhu ma lähen.“ ");
INSERT INTO ekk_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toomas ütles temale: „Issand, me ei tea ju, kuhu sa lähed, kuidas me võime teada teed?“ ");
INSERT INTO ekk_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jeesus vastas: „Mina olen tee ja tõde ja elu. Keegi ei tule Isa juurde muidu kui minu kaudu. ");
INSERT INTO ekk_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kui te olete õppinud tundma mind, siis olete te õppinud tundma ka minu Isa. Nüüdsest te juba tunnetegi teda ja olete teda näinud.“ ");
INSERT INTO ekk_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","„Issand, näita meile Isa,“ palus Filippus, „ja me jääme rahule!“ ");
INSERT INTO ekk_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","„Kas sa ei tunne mind, Filippus?“ vastas Jeesus, „Isegi pärast seda, kui ma olen nii kaua koos teiega olnud? Kes on näinud mind, on näinud Isa. Kuidas sa võid öelda „Näita meile Isa“? ");
INSERT INTO ekk_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kas sa siis ei usu, et mina olen Isas ja Isa on minus? Ma ei räägi ju midagi iseenda nimel, vaid Isa, kes elab minus, teeb oma tööd. ");
INSERT INTO ekk_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Uskuge mind, et mina olen Isas ja Isa on minus. Kui te ei usu muidu, siis uskuge mu tegude tõttu. ");
INSERT INTO ekk_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tõesti, tõesti, ma ütlen teile, kes usub minusse, teeb samasuguseid tegusid, nagu mina teen, ja teeb neist suuremaidki – sest mina lähen Isa juurde. ");
INSERT INTO ekk_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ja mida iganes te palute minu nimel, seda ma teen, sest nii saab Isa austatud Pojas. ");
INSERT INTO ekk_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Võite paluda minult ükskõik mida minu nimel, ja ma teen seda. ");
INSERT INTO ekk_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kui te armastate mind, siis pidage mu käske! ");
INSERT INTO ekk_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ja mina palun Isa ning tema annab teile teise abistaja, kes jääb teie juurde alatiseks – ");
INSERT INTO ekk_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tõe Vaimu, keda maailm ei saa vastu võtta, kuna ta ei näe ega tunne teda. Teie aga tunnete teda, sest ta jääb teie juurde ja on teie sees. ");
INSERT INTO ekk_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ma ei jäta teid orbudeks, ma tulen teie juurde tagasi. ");
INSERT INTO ekk_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Veel pisut, ja maailm ei näe mind enam, aga teie näete, sest mina elan ja teiegi peate elama. ");
INSERT INTO ekk_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Sel päeval te tunnete ära, et mina olen Isas ja teie olete minus ja mina olen teis. ");
INSERT INTO ekk_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kes on võtnud omaks minu käsud ja järgib neid, see armastab mind. Aga kes armastab mind, seda armastab minu Isa, ja minagi armastan teda ja näitan ennast talle.“ ");
INSERT INTO ekk_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Juudas, mitte Iskariot, küsis temalt: „Issand, miks sa kavatsed ennast ilmutada meile, aga mitte maailmale?“ ");
INSERT INTO ekk_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jeesus vastas: „Kui keegi armastab mind, siis ta peab mu õpetust. Minu Isa armastab teda ja me tuleme ja rajame kodu koos temaga. ");
INSERT INTO ekk_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kes mind ei armasta, ei pea minu õpetust. Need sõnad, mida te kuulete, ei kuulu mulle. Need kuuluvad Isale, kes mu saatis. ");
INSERT INTO ekk_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Seda ma olen teile rääkinud teie juures viibides. ");
INSERT INTO ekk_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Aga Abistaja, Püha Vaim, kelle Isa läkitab minu nimel, tema õpetab teile kõik ning tuletab meelde kõik, mida ma olen teile öelnud. ");
INSERT INTO ekk_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Rahu jätan ma teile, oma rahu ma annan teile. Mina ei anna seda nõnda, nagu annab maailm. Ärge laske ärevust oma südamesse ja ärge kartke! ");
INSERT INTO ekk_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Te ju kuulsite, et ma ütlesin teile: „Ma lähen ära ja tulen tagasi teie juurde.“ Kui te mind armastaksite, siis te rõõmustaksite, et ma lähen Isa juurde, sest Isa on minust suurem. ");
INSERT INTO ekk_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ma olen seda teile öelnud nüüd, enne neid sündmusi, et te võiksite uskuda, siis kui see kõik sünnib. ");
INSERT INTO ekk_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ma ei ütle teile palju enamat, sest selle maailma valitseja on tulemas. Aga tal pole minu üle mingit voli. ");
INSERT INTO ekk_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Aga ta tuleb, et maailm võiks teada, et mina armastan Isa ja teen täpselt nii, nagu Isa on käskinud. Tulge nüüd, lähme siit ära!“ ");
INSERT INTO ekk_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","„Mina olen tõeline viinapuu ja minu Isa on aednik. ");
INSERT INTO ekk_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Iga viljatu oksa lõikab ta minu küljest ära. Iga viljakandvat oksa ta puhastab, et see kannaks veel enam vilja. ");
INSERT INTO ekk_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Teie olete juba puhtad õpetuse tõttu, mille ma olen teile andnud. ");
INSERT INTO ekk_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Jääge minusse, ja mina jään teisse. Nagu oks ei saa kanda vilja omaette; ta peab jääma viinapuu külge. Nii ka teie ei kanna vilja, kui te ei jää minusse. ");
INSERT INTO ekk_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Mina olen viinapuu, teie olete oksad. Kes jääb minusse ja mina temasse, see kannab palju vilja, sest minust lahus ei saa te midagi teha. ");
INSERT INTO ekk_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kes ei jää minusse, on nagu äravisatud oks – ta kuivab. Need korjatakse kokku, visatakse tulle ja põletatakse ära. ");
INSERT INTO ekk_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kui te jääte minusse ja minu sõnad jäävad teisse, siis paluge, mida te iganes soovite, ja see sünnib teile. ");
INSERT INTO ekk_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","See toob au minu Isale, kui te kannate palju vilja näidates, et te olete minu jüngrid. ");
INSERT INTO ekk_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nõnda nagu Isa on armastanud mind, olen mina armastanud teid. Jääge minu armastusse! ");
INSERT INTO ekk_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kui te peate kinni minu käskudest, siis te jääte minu armastusse, nagu mina olen pidanud kinni oma Isa käskudest ja jään tema armastusse. ");
INSERT INTO ekk_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Seda ma olen rääkinud teile, et minu rõõm oleks teis ja teie rõõm oleks täielik. ");
INSERT INTO ekk_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Minu käsk on see: armastage üksteist, nii nagu mina olen teid armastanud! ");
INSERT INTO ekk_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ei ole suuremat armastust kui see, et keegi loovutab elu oma sõprade eest. ");
INSERT INTO ekk_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Teie olete mu sõbrad, kui te teete, mida ma teid käsin. ");
INSERT INTO ekk_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ma ei nimeta teid enam sulasteks. Sulane ju ei tea, mida ta isand teeb. Ma nimetan teid sõpradeks, sest ma olen teile teada andnud kõik, mida ma olen kuulnud oma Isalt. ");
INSERT INTO ekk_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Teie ei ole valinud mind. Mina olen valinud teid ja määranud nii, et te läheksite välja ja kannaksite vilja, mis jääb kestma. Ja mida iganes te minu nimel palute, seda Isa annab teile. ");
INSERT INTO ekk_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","See on mu käsk: armastage üksteist! ");
INSERT INTO ekk_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kui maailm teid vihkab, siis teadke, et mind on ta vihanud enne teid. ");
INSERT INTO ekk_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kui te kuuluksite maailmale, küll maailm siis armastaks teid kui omi. Aga et te ei kuulu maailmale, vaid mina olen teid maailmast välja valinud, seepärast maailm vihkab teid. ");
INSERT INTO ekk_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tuletage meelde, mis ma teile ütlesin: „Ei ole teener suurem oma isandast.“ Kui nad on mind taga kiusanud, siis nad hakkavad ka teid taga kiusama. Kui nad aga on pidanud kinni minu õpetusest, siis peavad nad kinni ka teie omast. ");
INSERT INTO ekk_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nad teevad seda teile minu nime pärast, kuna nad ei tunne teda, kes mind saatis. ");
INSERT INTO ekk_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kui ma ei oleks tulnud ja nendega rääkinud, siis ei oleks nad ka süüdi patus. Nüüd aga ei saa nad vabandada oma pattu. ");
INSERT INTO ekk_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kes vihkab mind, vihkab ka minu Isa. ");
INSERT INTO ekk_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kui ma ei oleks nende nähes teinud tegusid, mida ei ole teinud keegi teine, siis poleks nad patus süüdi. Nüüd aga on nad näinud neid tegusid ning vihanud nii mind kui ka minu Isa. ");
INSERT INTO ekk_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nõnda läheb täide, mis on kirjas nende Seaduses: „Nad on vihanud mind ilma põhjuseta.“ ");
INSERT INTO ekk_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ent kui tuleb Abistaja, kelle ma teile Isa juurest saadan, Tõe Vaim, kes lähtub Isast, siis tema tunnistab minust. ");
INSERT INTO ekk_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ja teiegi peate tunnistama, sest te olete olnud koos minuga algusest peale. ");
INSERT INTO ekk_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Seda kõike olen ma rääkinud selleks, et te ära ei langeks. ");
INSERT INTO ekk_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Nad viskavad teid sünagoogist välja ja tuleb aeg, mil igaüks, kes teid tapab, arvab, et täidab sellega oma kohust Jumala ees. ");
INSERT INTO ekk_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ja seda nad teevad, kuna nad ei tunne minu Isa ega mind. ");
INSERT INTO ekk_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ma olen seda rääkinud selleks, et kui saabub aeg, tuleb teile meelde, et ma olen teid nende eest hoiatanud. Ma ei rääkinud seda teile alguses, sest ma olin ise koos teiega, ");
INSERT INTO ekk_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","vaid nüüd, kui ma lähen tema juurde, kes mind saatis. Ja keegi teist ei küsi minu käest: „Kuhu sa lähed?“ ");
INSERT INTO ekk_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Te olete kurbusega täidetud, sest ma olen neid asju rääkinud. ");
INSERT INTO ekk_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Aga tõesti ma ütlen teile, teile on hea, et ma lahkun. Sest kui ma ei lahkuks, ei tuleks Abistaja teie juurde. Aga kui ma ära lähen, siis ma saadan tema teie juurde. ");
INSERT INTO ekk_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kui ta tuleb, siis ta tõestab, et maailm on ekslik patu, õiguse ja kohtumõistmise suhtes: ");
INSERT INTO ekk_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","patu suhtes, sest inimesed ei usu minusse; ");
INSERT INTO ekk_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","õiguse suhtes, sest ma lähen Isa juurde, kus te mind enam ei näe; ");
INSERT INTO ekk_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ja kohtumõistmise suhtes, sest selle maailma valitseja on nüüd süüdi mõistetud. ");
INSERT INTO ekk_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Mul on teile veel palju öelda, rohkem kui te praegu suudate välja kannatada. ");
INSERT INTO ekk_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Aga kui tuleb Tõe Vaim, siis tema juhib teid kogu tõe sisse. Sest tema ei räägi iseenesest, vaid ta räägib, mida kuuleb, ja ta kuulutab teile tulevasi asju. ");
INSERT INTO ekk_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tema austab mind, sest ta saab minu käest, mida teile kuulutab. ");
INSERT INTO ekk_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kõik, mis kuulub Isale, on minu oma. Seepärast ma ütlesingi, et ta saab minu käest ja kuulutab teile.“ ");
INSERT INTO ekk_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jeesus rääkis edasi ja ütles: „Veel natuke aega, ja te ei näe mind enam, ja taas natuke aega, ja te näete mind jälle.“ ");
INSERT INTO ekk_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Siis küsisid jüngrid üksteiselt: „Mida ta mõtleb sellega, et veel natuke aega, ja me ei näe teda enam, ja siis varsti näeme teda jälle, ning et ta läheb Isa juurde?“ ");
INSERT INTO ekk_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nad ütlesid: „Mida tähendab see „natuke aega“? Me ei mõista, millest ta räägib.“ ");
INSERT INTO ekk_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jeesus sai aru, et nad tahtsid seda temalt küsida, ning ütles neile: „Kas te arutate omavahel mu sõnade üle „Veel natuke aega, ja te ei näe mind enam, ja taas natuke aega, ja te näete mind jälle“? ");
INSERT INTO ekk_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tõesti, tõesti, ma ütlen teile, te nutate ja leinate, aga maailm rõõmustab. Teie leinate, kuid teie lein pöördub rõõmuks. ");
INSERT INTO ekk_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Sünnitusel tunneb naine valu, sest ta aeg on kätte jõudnud, aga kui laps on sündinud, ei mõtle ta enam oma vaevale, vaid rõõmustab lapse ilmaletulekust. ");
INSERT INTO ekk_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nii on ka teiega. Teil tuleb kannatada valu, aga kui ma näen teid jälle, on teie süda rõõmus ja seda rõõmu ei võta teilt keegi ära. ");
INSERT INTO ekk_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Sel päeval ei küsi te minult enam midagi. Tõesti, tõesti, ma ütlen teile, mida iganes te Isalt palute minu nimel, seda ta annab teile. ");
INSERT INTO ekk_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Seni ei ole te midagi palunud minu nimel – paluge, ja te saate, et teie rõõm võiks olla täielik! ");
INSERT INTO ekk_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Seda kõike olen ma teile rääkinud kujundlikult. Tuleb aeg, mil ma ei räägi teiega enam sel viisil, vaid kuulutan teile oma Isast otse. ");
INSERT INTO ekk_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Sel päeval te palute minu nimel. Ma ei ütle teile, et mina palun Isa teie pärast. ");
INSERT INTO ekk_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Isa ise armastab teid, sest te olete armastanud mind ja uskunud, et mina olen tulnud Jumala juurest. ");
INSERT INTO ekk_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ma tulin Isa Juurest ja tulin maailma. Nüüd olen ma maailmast lahkumas ja lähen tagasi Isa juurde.“ ");
INSERT INTO ekk_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Seepeale ütlesid jüngrid: „Nüüd räägid sa tõesti otse ega ütle midagi kujundlikult. ");
INSERT INTO ekk_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nüüd me saame aru, et sina tead kõike ja meil pole vaja sulle küsimusi esitada. Seetõttu me usume, et sa tulid Jumala juurest.“ ");
INSERT INTO ekk_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","„Kas te nüüd usute?“ küsis Jeesus. ");
INSERT INTO ekk_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","„Kätte on jõudmas tund – ja see ongi juba käes –, et teid pillutatakse igaüks ise kohta. Te jätate mu üksi. Aga mina ei ole üksi, sest Isa on koos minuga. ");
INSERT INTO ekk_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Seda ma olen teile rääkinud, et teil oleks rahu minus. Maailmas on teil viletsust, aga olge julged: mina olen maailma ära võitnud!“ ");
INSERT INTO ekk_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pärast neid sõnu tõstis Jeesus pilgu taeva poole ja ütles: „Isa, tund on kätte jõudnud, austa oma Poega, et Poeg võiks austada sind! ");
INSERT INTO ekk_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Sest sa oled andnud talle meelevalla kõigi inimeste üle, et ta annaks igavese elu kõigile, kelle sa oled talle andnud. ");
INSERT INTO ekk_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Igavene elu aga on see, kui nad tunnevad sind, ainsat tõelist Jumalat, ning Jeesust Kristust, kelle sina oled läkitanud. ");
INSERT INTO ekk_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ma olen austanud sind maa peal, viies lõpule töö, mille sa andsid mulle teha. ");
INSERT INTO ekk_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nüüd, Isa, austa mind enda juures austusega, mis kuulus mulle enne maailma algust sinu juures! ");
INSERT INTO ekk_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ma olen näidanud sind inimestele, keda sa oled andnud mulle maailmast. Nad kuulusid sulle, sina andsid nad mulle ja nad on kuulanud su sõna. ");
INSERT INTO ekk_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nüüd nad teavad, et kõik, mis sina oled andnud minule, tuleb sinult. ");
INSERT INTO ekk_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Sest ma olen andnud neile sõnad, mis sa mulle andsid, ja nad on need vastu võtnud. Nad teadsid kindlalt, et ma tulin sinu juurest, ja nad uskusid, et sina saatsid mu. ");
INSERT INTO ekk_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nende pärast ma palun. Maailma pärast ma ei palu, küll aga nende pärast, keda sa oled mulle andnud, sest nad kuuluvad sulle. ");
INSERT INTO ekk_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kõik, kes on minu päralt, on sinu päralt, ja kes on sinu päralt, on minu päralt. Nende kaudu olen ma austatud. ");
INSERT INTO ekk_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ma ei jää enam kauemaks maailma. Nemad on veel maailmas, aga mina tulen sinu juurde. Püha Isa, hoia neid oma nime väega, selle nime, mis sa mulle andsid, et nad saaksid olla üks nagu mina ja sina oleme üks. ");
INSERT INTO ekk_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Niikaua kui ma olin nendega koos, kaitsesin ja hoidsin ma neid sinu nimes, mis sa mulle andsid. Ükski neist ei läinud kaduma peale ühe, kes läks hukatusse selleks, et Kiri läheks täide. ");
INSERT INTO ekk_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ma tulen nüüd sinu juurde, aga räägin neid sõnu veel maailmas olles, et minu rõõm neis oleks täielik. ");
INSERT INTO ekk_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mina olen andnud neile sinu sõna ja maailm on neid vihanud, sest nad ei ole maailmast, nii nagu minagi ei ole maailmast. ");
INSERT INTO ekk_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ma ei palu, et sa nad maailmast ära võtaksid, vaid et sa hoiaksid neid kurja eest. ");
INSERT INTO ekk_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nemad ei ole maailmast, nii nagu minagi ei ole maailmast. ");
INSERT INTO ekk_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pühitse neid tões: sinu sõna on tõde! ");
INSERT INTO ekk_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nagu sina läkitasid minu maailma, nii olen mina saatnud maailma nemad. ");
INSERT INTO ekk_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nende pärast pühitsen ma ennast, et nemadki oleksid tõeliselt pühitsetud. ");
INSERT INTO ekk_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Kuid ma ei palu ainult nende, vaid kõikide pärast, kes nende sõnumi läbi hakkavad minusse uskuma, ");
INSERT INTO ekk_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","et nad kõik oleksid üks. Nagu sina, Isa, oled minus ja mina olen sinus, nõnda olgu nemadki meis. Et maailm usuks, et sina oled mu läkitanud. ");
INSERT INTO ekk_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mina olen andnud neile selle au, mille sina andsid mulle, et nad oleksid üks, nagu meiegi oleme üks, ");
INSERT INTO ekk_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","mina neis ja sina minus. Nii et nad võiksid saada täiesti üheks. Siis maailm teab, et sina saatsid minu ja oled armastanud neid, nii nagu sa oled armastanud mind. ");
INSERT INTO ekk_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Isa, ma tahan, et ka need, keda sa oled mulle andnud, oleksid minuga seal, kus mina olen, ja näeksid mu au, mille sa oled andnud mulle, sest sa oled mind armastanud enne maailma loomist. ");
INSERT INTO ekk_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Õiglane Isa, kuigi maailm sind ei tunne, tunnen mina sind ja nemad on ära tundnud, et sina oled minu läkitanud. ");
INSERT INTO ekk_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ma olen neile näidanud sind ja teen seda veelgi, et armastus, millega sa mind oled armastanud, oleks ka nendes ja mina oleksin nendes.“ ");
INSERT INTO ekk_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Kui ta oli palvetamise lõpetanud, läks Jeesus koos oma jüngritega ära. Nad läksid läbi Kidroni oru õlipuuaeda, mis oli teisel pool orgu. ");
INSERT INTO ekk_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Juudas, kes ta ära andis, teadis seda kohta, sest Jeesus oli seal tihti jüngritega kokku saanud. ");
INSERT INTO ekk_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nüüd tuli Juudas sinna, juhatades sõdurite salka, valvureid ülempreestrite juurest ja varisere, kõigil kaasas laternad, tõrvikud ja relvad. ");
INSERT INTO ekk_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Teades kõike, mis teda ees ootab, läks Jeesus neile vastu ja küsis: „Keda te otsite?“ ");
INSERT INTO ekk_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","„Naatsareti Jeesust,“ vastasid need. „Mina olen see,“ ütles Jeesus. Ka äraandja Juudas seisis sealsamas koos nendega. ");
INSERT INTO ekk_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kui Jeesus ütles: „Mina olen see,“ kohkusid nad tagasi ja kukkusid maha. ");
INSERT INTO ekk_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Siis küsis ta neilt uuesti: „Keda te otsite?“ „Naatsareti Jeesust,“ kordasid nad. ");
INSERT INTO ekk_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","„Ma ju ütlesin teile, et mina olen see,“ vastas Jeesus. „Kui te mind otsite, siis laske neil teistel minna.“ ");
INSERT INTO ekk_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nõnda läks täide ta ettekuulutus: „Ma ei ole kaotanud ühtki nendest, keda sa mulle andsid!“ ");
INSERT INTO ekk_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ent Siimon Peetrus, kellel oli mõõk, tõmbas selle nüüd välja ja lõi ülempreestri sulast, raiudes ära ta parema kõrva. (Sulase nimi oli Malkus.) ");
INSERT INTO ekk_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jeesus ütles Peetrusele: „Pane oma mõõk tuppe! Kas ma peaksin keelduma karikast, mille Isa mulle annab?“ ");
INSERT INTO ekk_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Siis võtsid sõdurid oma ülema juhtimisel ja juudi valvurite abil Jeesuse kinni ja panid ta köidikuisse. ");
INSERT INTO ekk_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kõigepealt viisid nad ta Hannase juurde, kes oli sel aastal ülempreestri ametit pidava Kaifase äi. ");
INSERT INTO ekk_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Just Kaifas oli andnud juutide juhtidele nõu, et on parem, kui üks inimene sureb rahva eest. ");
INSERT INTO ekk_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Siimon Peetrus ja üks teine jünger järgnesid Jeesusele. Kuna see teine jünger oli ülempreestri tuttav, võis ta siseneda ülempreestri sisehoovi koos Jeesusega. ");
INSERT INTO ekk_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peetrus aga jäi ukse taha. Siis läks teine jünger, kes oli tuttav ülempreestrile, rääkis teenijatüdrukuga ning viis ka Peetruse sisse. ");
INSERT INTO ekk_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Teenijatüdruk küsis Peetruselt: „Eks sinagi ole üks selle mehe jüngritest?“ Peetrus vastas: „Ei, mina ei ole!“ ");
INSERT INTO ekk_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Aga et väljas oli külm, olid sulased ja valvurid süüdanud sütest lõkke, mille ääres nad end soojendasid. Ja Peetrus seisis nende seas end soojendades. ");
INSERT INTO ekk_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Samal ajal küsitles ülempreester Jeesust tema jüngrite ja õpetuse kohta. ");
INSERT INTO ekk_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jeesus vastas: „Ma olen avalikult maailmale rääkinud, ma olen alati õpetanud sünagoogis ja templis, kus kõik juudid kogunevad, ega ole midagi rääkinud salaja. ");
INSERT INTO ekk_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Miks sa minu käest küsid? Küsi kuulajatelt, mida ma olen rääkinud. Küll nad teavad, mida ma olen öelnud.“ ");
INSERT INTO ekk_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nende sõnade peale lõi üks juures seisnud valvuritest talle käega näkku, öeldes: „Kas nõnda vastad sa ülempreestrile?“ ");
INSERT INTO ekk_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jeesus kostis: „Kui ma midagi valesti ütlesin, siis ütle, mis see oli. Kui ma aga tõtt rääkisin, siis miks sa mind peksad?“ ");
INSERT INTO ekk_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Seepeale saatis Hannas Jeesuse kinniseotuna ülempreester Kaifase juurde. ");
INSERT INTO ekk_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Siimon Peetrus aga seisis lõkke ääres ja soojendas end. Korraga küsiti temalt: „Kas sinagi oled üks selle mehe jüngritest?“ „Ei, mina ei ole,“ salgas ta. ");
INSERT INTO ekk_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Siis ütles talle ülempreestri sulane, kelle sugulase kõrva oli Peetrus ära raiunud: „Ma ju nägin sind õlipuuaias koos selle mehega!“ ");
INSERT INTO ekk_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peetrus salgas taas, ja kohe kires kukk. ");
INSERT INTO ekk_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Siis viisid nad Jeesuse Kaifase juurest Rooma maavalitseja kohtukotta. Oli varahommik. Juudid ise ei astunud majja sisse, et mitte rüvetada end uskmatute hoones viibimisega – muidu nad poleks võinud süüa paasatoitu. ");
INSERT INTO ekk_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Seepärast tuli Pilaatus nende juurde välja ja küsis: „Milles te seda inimest süüdistate?“ ");
INSERT INTO ekk_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","„Kui ta ei oleks kurjategija,“ vastasid nad talle, „ei annaks me teda sinu kätte.“ ");
INSERT INTO ekk_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilaatus ütles neile: „Võtke teie ta ja mõistke ise tema üle kohut oma Seaduse järgi!“ „Meil ei ole luba kedagi surmata,“ kostsid juudid. ");
INSERT INTO ekk_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nii läks täide Jeesuse ettekuulutus selle kohta, millist surma ta pidi surema. ");
INSERT INTO ekk_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Siis läks Pilaatus tagasi kohtukotta. Ta kutsus Jeesuse enese ette ja küsis temalt: „Kas sina oled juutide kuningas?“ ");
INSERT INTO ekk_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","„Kas see on sinu enda mõte,“ küsis Jeesus vastu, „või on sulle keegi teine seda minu kohta öelnud?“ ");
INSERT INTO ekk_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","„Kas ma olen juut?“ vastas Pilaatus. „Su oma rahvas ja ülempreestrid andsid su minu kätte. Mida sa teinud oled?“ ");
INSERT INTO ekk_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","„Minu Kuningriik ei ole sellest maailmast,“ ütles Jeesus. „Kui mu Kuningriik oleks sellest maailmast, siis mu sulased oleksid võidelnud, et mind ei oleks antud juudi ülemate kätte. Aga minu Kuningriik ei ole siit.“ ");
INSERT INTO ekk_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","„Sina oled siis ikkagi kuningas?“ küsis Pilaatus. „Sina ise ütled, et mina olen kuningas,“ vastas Jeesus. „Mina olen selleks sündinud ja tulnud maailma, et tunnistada tõest. Igaüks, kes on tõe poolel, kuulab mind.“ ");
INSERT INTO ekk_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","„Mis on tõde?“ küsis Pilaatus. Seda öelnud, läks ta jälle juutide juurde välja, kes olid sinna kogunenud, ning teatas: „Mina ei leia temal ühtki süüd. ");
INSERT INTO ekk_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Aga teil on kombeks, et ma lasen teile paasapühadel ühe vangi vabaks. Kas te soovite, et ma lasen vabaks juutide kuninga?“ ");
INSERT INTO ekk_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","„Mitte tema, vaid Barabase!“ karjusid nad. Ent Barabas oli osalenud mässus. ");
INSERT INTO ekk_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Siis viis Pilaatus Jeesuse ära ja laskis teda piitsutada. ");
INSERT INTO ekk_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sõdurid panid talle pähe kibuvitstest punutud pärja ning selga purpurpunase rüü. ");
INSERT INTO ekk_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nad astusid ta ette, öeldes: „Tervitus, juutide kuningas!“ ning lõid talle vastu nägu. ");
INSERT INTO ekk_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilaatus tuli taas välja ja ütles: „Vaadake, ma toon ta teie ette teile teadmiseks, et mina ei leia temal ühtki süüd!“ ");
INSERT INTO ekk_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Siis tuli Jeesus välja, kandes peas kibuvitsapärga ja seljas purpurpunast rüüd. „Siin on see mees!“ ütles Pilaatus neile. ");
INSERT INTO ekk_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Jeesust nähes karjusid ülempreestrid ja valvurid: „Löö ta risti, löö ta risti!“ „Võtke teie ta ja lööge ise risti,“ ütles Pilaatus. „Mina ei leia temal ühtki süüd.“ ");
INSERT INTO ekk_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","„Meil on Seadus,“ vastasid juudid, „ja Seaduse järgi peab ta surema, sest ta on kuulutanud ennast Jumala Pojaks.“ ");
INSERT INTO ekk_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Seda kuuldes hakkas Pilaatus tõsiselt kartma. ");
INSERT INTO ekk_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ta läks tagasi kohtukotta ja küsis Jeesuselt: „Kust sa pärit oled?“ Aga Jeesus ei vastanud. ");
INSERT INTO ekk_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Siis ütles Pilaatus talle: „Kas sa keeldud minuga rääkimast? Kas sa ei mõista, et minu võimuses on sind vabaks lasta või risti lüüa?“ ");
INSERT INTO ekk_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","„Sul ei oleks minu üle mingit võimu,“ vastas Jeesus, „kui see ei oleks sulle antud ülalt. Seepärast on suurem süü sellel, kes mind sinu kätte andis.“ ");
INSERT INTO ekk_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Sellest alates üritas Pilaatus Jeesust vabaks lasta. Ent juudid karjusid: „Kui sa tema vabaks lased, ei ole sa keisri sõber. Igaüks, kes kuulutab ennast kuningaks, on keisri vastane.“ ");
INSERT INTO ekk_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Seda kuuldes tõi Pilaatus Jeesuse välja ning istus kohtunikutoolile paigas, mille nimi on Kivipõrand, heebrea keeles Gabbatha. ");
INSERT INTO ekk_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Oli paasapühade ettevalmistuspäev, lõunaaeg. „Siin on teie kuningas!“ ütles Pilaatus juutidele. ");
INSERT INTO ekk_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","End need karjusid vastu: „Vii ta minema! Vii ta minema! Löö ta risti!“ „Kas ma pean teie kuninga risti lööma?“ küsis Pilaatus. „Meil ei ole muud kuningat kui keiser,“ vastasid ülempreestrid. ");
INSERT INTO ekk_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Siis andis Pilaatus Jeesuse ristilöömiseks sõdurite kätte. Sõdurid võtsid Jeesuse kaasa. ");
INSERT INTO ekk_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Oma risti kandes läks ta Pealuuks hüütud paika, mis on heebrea keeles Kolgata. ");
INSERT INTO ekk_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Seal lõid nad risti Jeesuse ja veel kaks meest koos temaga: teine teisele poole ja tema nende vahele. ");
INSERT INTO ekk_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilaatus lasi kirjutada ja ristile kinnitada sildi. Seal olid sõnad: Naatsareti Jeesus, juutide kuningas ");
INSERT INTO ekk_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Seda silti luges palju juute, sest Jeesuse ristilöömise paik oli linna lähedal. Kirjutatud oli heebrea, ladina ja kreeka keeles. ");
INSERT INTO ekk_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Juutide ülempreestrid palusid Pilaatust: „Ära kirjuta „Juutide kuningas“, vaid: „Tema on öelnud: „Mina olen juutide kuningas.“ “ “ ");
INSERT INTO ekk_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Kuid Pilaatus vastas: „Mida ma olen kirjutanud, seda ma olen kirjutanud.“ ");
INSERT INTO ekk_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kui sõdurid olid Jeesuse risti löönud, võtsid nad ta riided ja jagasid nelja sõduri vahel ära. Nad võtsid ka särgi, mis oli ilma õmblusteta, ülalt alla ühes tükis kootud. ");
INSERT INTO ekk_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Seepärast ütlesid nad üksteisele: „Ärme tee seda katki, vaid heidame liisku, kellele see saab!“ Nii sündis, et läheks täide Pühakirja sõna: „Nad on jaotanud omavahel mu riided ja heitnud liisku mu rõivaste üle.“ Seda sõdurid tegidki. ");
INSERT INTO ekk_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jeesuse risti juures seisid ka tema ema, ema õde, Kloopase naine Maarja ning Maarja Magdaleena. ");
INSERT INTO ekk_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kui Jeesus nägi oma ema ja tema kõrval seismas jüngrit, keda ta armastas, ütles ta emale: „Naine, see on sinu poeg!“ ");
INSERT INTO ekk_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Siis ütles ta oma jüngrile: „See on sinu ema!“ Sellest ajast võttis jünger Jeesuse ema enda juurde elama. ");
INSERT INTO ekk_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pärast seda ütles Jeesus, teades, et nüüd on kõik lõpetatud, ja et Pühakiri läheks täide: „Mul on janu!“ ");
INSERT INTO ekk_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Seal seisis anum hapu veiniga. Nad panid veini kastetud käsna iisopivarre otsa ja tõstsid ta suu juurde. ");
INSERT INTO ekk_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kui nüüd Jeesus oli võtnud veini, ütles ta: „See on lõpetatud!“ Siis langetas ta pea ja heitis hinge. ");
INSERT INTO ekk_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ent juudid ei tahtnud, et hukatud jääksid ristile hingamispäevaks – paasanädalal oli see suur püha. Seepärast palusid nad Pilaatust, et ta käsiks murda ristilöödute jalaluud ja võtta nad maha. ");
INSERT INTO ekk_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Sõdurid tulidki ja murdsid jalaluud mõlemal mehel, kes olid risti löödud koos Jeesusega. ");
INSERT INTO ekk_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kui nad Jeesuse juurde jõudsid ja nägid, et ta on juba surnud, jätsid nad tema jalaluud murdmata. ");
INSERT INTO ekk_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Selle asemel torkas üks sõdureist odaga ta küljesse ning sealt voolas välja verd ja vett. ");
INSERT INTO ekk_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Üks pealtnägija on seda tunnistanud ja see tunnistus on õige. Ta teab, et ta räägib tõtt – et teiegi võiksite uskuda. ");
INSERT INTO ekk_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nii läks täide Pühakirja ettekuulutus: „Ühtki tema luud ei purustata.“ ");
INSERT INTO ekk_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ja nagu üks teine ettekuulutus ütleb: „Nad saavad näha seda, kelle nad on läbi torganud.“ ");
INSERT INTO ekk_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pärast seda pöördus Joosep Arimaatiast Pilaatuse poole palvega, et ta võiks Jeesuse surnukeha ristilt maha võtta. Joosep oli Jeesuse jünger, aga mitte avalikult, sest ta kartis juute. Pilaatuse loal ta tuli ja võttis surnukeha maha. ");
INSERT INTO ekk_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nüüd saabus ka Nikodeemos, kes oli kord öösel Jeesuse juures käinud, ja tõi umbes kolmekümne nelja kilogrammi jagu aaloega segatud mürri. ");
INSERT INTO ekk_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Siis võtsid nad Jeesuse surnukeha ja mähkisid ta koos lõhnarohtudega linasesse kangasse, nagu on juutide matusekomme. ");
INSERT INTO ekk_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ristilöömise kohas oli aed ja seal asus uus haud, kuhu ei olnud veel kedagi maetud. ");
INSERT INTO ekk_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Et hingamispäev oli algamas ja haud oli lähedal, siis panid nad Jeesuse sinna. ");
INSERT INTO ekk_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nädala esimese päeva varahommikul, kui väljas oli veel pime, läks Maarja Magdaleena Jeesuse hauale ja nägi, et kivi on hauasuult kõrvale lükatud. ");
INSERT INTO ekk_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ta tuli jooksuga Siimon Peetruse ja teise jüngri juurde, keda Jeesus armastas, ning ütles neile: „Nad on Issanda hauast ära viinud ja me ei tea, kuhu nad on ta pannud!“ ");
INSERT INTO ekk_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kiiruga asusid Peetrus ja see teine jünger haua poole teele. ");
INSERT INTO ekk_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nad jooksid koos, ent see teine jünger jooksis Peetrusest kiiremini ja jõudis haua juurde esimesena. ");
INSERT INTO ekk_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kummargil sisse vaadates nägi ta surilinu, ent sisse ta ei astunud. ");
INSERT INTO ekk_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Seejärel jõudis kohale ka Siimon Peetrus. Tema läks hauakoopasse sisse ning nägi maas lebavaid mähiseid ");
INSERT INTO ekk_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ja higirätikut, mis oli olnud ümber Jeesuse pea; see ei lebanud mähiste juures, vaid oli kokkulapituna oma kohal. ");
INSERT INTO ekk_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kui nüüd teine jünger, kes oli jõudnud haua juurde esimesena, samuti sisse läks, siis ta nägi ja uskus, ");
INSERT INTO ekk_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","sest seni ei olnud nad veel mõistnud Pühakirja ettekuulutust, mille kohaselt Jeesus pidi surnuist üles tõusma. ");
INSERT INTO ekk_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Siis läksid jüngrid tagasi sinna, kus nad peatusid. ");
INSERT INTO ekk_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maarja aga seisis haua juures väljas ja nuttis. Nuttes kummardus ta vaatama hauakoopasse ");
INSERT INTO ekk_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ja nägi kaht valgeis riideis inglit istumas seal, kus oli lebanud Jeesuse surnukeha, üks peatsis ja teine jalutsis. ");
INSERT INTO ekk_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","„Naine, miks sa nutad?“ küsisid nad temalt. „Nad on mu Issanda ära viinud,“ vastas Maarja, „ja ma ei tea, kuhu nad on ta pannud.“ ");
INSERT INTO ekk_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Seda öelnud, vaatas ta selja taha ja nägi Jeesust, kes seal seisis, aga ta ei saanud aru, et see oli Jeesus. ");
INSERT INTO ekk_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","„Naine, miks sa nutad?“ küsis Jeesus temalt. „Keda sa otsid?“ Pidades teda aednikuks, vastas Maarja: „Isand, kui sina ta minema viisid, siis ütle mulle, kuhu sa ta panid, ja ma toon ta ära.“ ");
INSERT INTO ekk_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","„Maarja!“ ütles Jeesus talle. Nüüd pöördus Maarja ringi ja hüüatas heebrea keeles: „Rabbuuni!“ (See tähendab Õpetajat.) ");
INSERT INTO ekk_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","„Ära puuduta mind!“ ütles Jeesus talle. „Sest ma ei ole veel läinud üles oma Isa juurde. Aga mine mu vendade juurde ja ütle neile, et ma lähen üles oma Isa ja teie Isa ning oma Jumala ja teie Jumala juurde!“ ");
INSERT INTO ekk_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maarja Magdaleena läks ja teatas jüngritele: „Ma nägin Issandat!“ ja ta rääkis neile, mis Jeesus oli öelnud. ");
INSERT INTO ekk_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Selsamal õhtul, nädala esimesel päeval, olid jüngrid koos lukus uste taga, sest nad kartsid juudi ülemaid. Järsku ilmus sinna Jeesus, jäi seisma nende keskele ja ütles: „Rahu olgu teiega!“ ");
INSERT INTO ekk_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Seda öelnud, näitas ta neile oma käsi ja külge. Rõõm täitis jüngreid, kui nad Issandat nägid. ");
INSERT INTO ekk_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jeesus ütles taas: „Rahu teile! Nagu Isa on läkitanud minu, nii läkitan mina nüüd teid.“ ");
INSERT INTO ekk_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Seejärel hingas ta nende peale ja ütles: „Võtke vastu Püha Vaim! ");
INSERT INTO ekk_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kellele iganes te patud andeks annate, neile on need andeks antud. Kelle patte te andeks ei anna, neile ei ole andeks antud.“ ");
INSERT INTO ekk_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Aga Toomas, üks kaheteistkümnest, hüüdnimega Kaksik, ei olnud teistega, kui Jeesus tuli. ");
INSERT INTO ekk_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Teised jüngrid ütlesid talle: „Me nägime Issandat!“ Tema aga vastas: „Ma ei usu enne, kui näen naelajälgi ta kätes ja panen oma sõrme naelaarmidesse ja oma käe tema küljehaava.“ ");
INSERT INTO ekk_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nädal hiljem olid jüngrid jälle koos suletud ruumis ja ka Toomas oli nendega. Kuigi uksed olid lukus, tuli Jeesus, jäi seisma nende keskele ja ütles: „Rahu teile!“ ");
INSERT INTO ekk_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Seejärel ütles ta Toomasele: „Siruta oma sõrm siia ja vaata mu käsi! Siruta oma käsi ja pane mu küljehaava! Ära kahtle, vaid usu!“ ");
INSERT INTO ekk_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toomas vastas talle: „Minu Issand ja minu Jumal!“ ");
INSERT INTO ekk_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","„Sa usud, sest sa oled näinud,“ ütles Jeesus. „Õnnistatud on need, kes pole näinud, aga siiski usuvad.“ ");
INSERT INTO ekk_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jeesus andis jüngrite nähes veel palju muid tunnustähti, mida aga ei ole kirjutatud sellesse raamatusse. ");
INSERT INTO ekk_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ent need siin on kirjutatud üles, et te usuksite, et Jeesus on Messias, Jumala Poeg, ning et teil uskudes oleks elu temas. ");
INSERT INTO ekk_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pärast seda ilmus Jeesus jüngritele veel Galilea mere ääres. See juhtus nõnda. ");
INSERT INTO ekk_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Koos olid Siimon Peetrus, Toomas, hüüdnimega Kaksik, Naatanael Kaanast Galileast, Sebedeuse pojad ja veel kaks Jeesuse jüngrit. ");
INSERT INTO ekk_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Siimon Peetrus ütles: „Ma lähen kala püüdma.“ Teised vastasid: „Me tuleme sinuga kaasa.“ Nad läksid paadiga välja, kuid ei saanud sel ööl midagi. ");
INSERT INTO ekk_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kui koidik oli juba käes, seisis Jeesus kaldal, aga jüngrid ei saanud aru, et see oli Jeesus. ");
INSERT INTO ekk_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","„Sõbrad, on teil mõni kala?“ hüüdis Jeesus. „Ei ole,“ vastasid nad. ");
INSERT INTO ekk_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jeesus ütles: „Heitke võrk paremale poole paati ja te leiate mõne!“ Nad heitsidki võrgu paremale poole ega suutnud seda enam välja tõmmata: seal oli nii palju kalu! ");
INSERT INTO ekk_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Siis ütles Peetrusele see jünger, keda Jeesus armastas: „See on Issand!“ Kui Siimon Peetrus kuulis, et see on Issand, pani ta kuue selga – sest ta oli selle ära võtnud – ja hüppas vette. ");
INSERT INTO ekk_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Teised jüngrid tulid paadiga võrku järel vedades – nad olid kaldast umbes kahesaja küünra kaugusel. ");
INSERT INTO ekk_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kui nad kaldale jõudsid, nägid nad lõkkeaset hõõguvate sütega, sellel küpsevat kala ja leiba. ");
INSERT INTO ekk_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","„Tooge neid kalu ka, mis te praegu püüdsite!“ ütles Jeesus. ");
INSERT INTO ekk_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Siimon Peetrus läks tagasi paati ja tõmbas võrgu maale, seal oli kokku sada viiskümmend kolm suurt kala. Ja kuigi kalu oli nõnda palju, ei rebenenud võrk katki. ");
INSERT INTO ekk_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","„Tulge hommikust sööma!“ kutsus Jeesus neid. Keegi jüngritest ei söandanud küsida temalt: „Kes sa oled?“ sest nad teadsid, et ta on Issand. ");
INSERT INTO ekk_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jeesus tuli, võttis leiba ja ulatas neile, samuti kala. ");
INSERT INTO ekk_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","See oli juba kolmas kord, kui ta ilmus jüngritele pärast surnuist ülestõusmist. ");
INSERT INTO ekk_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kui nad olid söönud, ütles Jeesus Siimon Peetrusele: „Siimon, Johannese poeg, kas sa armastad mind rohkem kui nemad?“ „Jah, Issand, sina tead, et ma armastan sind,“ vastas Peetrus. „Toida mu tallekesi!“ ütles Jeesus talle. ");
INSERT INTO ekk_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Siis küsis Jeesus temalt teist korda: „Siimon, Johannese poeg, kas sa armastad mind?“ „Jah, Issand, sina tead, et ma armastan sind,“ vastas Peetrus. „Hoia mu lambaid!“ ütles Jeesus talle. ");
INSERT INTO ekk_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Siis küsis Jeesus temalt kolmandat korda: „Siimon, Johannese poeg, kas sa armastad mind?“ Peetrus jäi kurvaks, et Jeesus temalt kolmandat korda küsis: „Kas sa armastad mind?“ „Issand, sina tead kõike,“ vastas ta. „Sina tead, et ma armastan sind.“ „Toida mu lambaid!“ ütles Jeesus talle. ");
INSERT INTO ekk_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","„Tõesti, tõesti, ma ütlen sulle, kui sa veel noorem olid, sidusid sa ise oma vöö vööle ja läksid, kuhu tahtsid. Aga kui sa vanaks saad, siis sa sirutad käed välja, ning keegi teine riietab su ja viib sinna, kuhu sa ei taha minna.“ ");
INSERT INTO ekk_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Nende sõnadega andis Jeesus mõista, millise surmaga Peetrus pidi Jumalale au tooma. Seejärel ütles ta Peetrusele: „Järgne mulle!“ ");
INSERT INTO ekk_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Selja taha vaadates nägi Peetrus enda järel jüngrit, keda Jeesus armastas, sedasama, kes oli toetunud õhtusöögi ajal Jeesuse rinnale ja küsinud: „Issand, kes on sinu äraandja?“ ");
INSERT INTO ekk_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nähes teda, küsis Peetrus Jeesuselt: „Issand, aga tema?“ ");
INSERT INTO ekk_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jeesus vastas: „Kui ma tahan, et ta jääb minu tagasitulekuni, mis sinul sellest? Sina järgne mulle!“ ");
INSERT INTO ekk_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nii levis vendade seas jutt, nagu ei sureks see jünger kunagi. Aga Jeesus ei öelnud talle, et ta ei sure, vaid: „Kui ma tahan, et ta jääb minu tagasitulekuni, mis sinul sellest?“ ");
INSERT INTO ekk_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","See on see jünger, kes tunnistab neist asjadest ja on need kirja pannud. Me teame, et tema tunnistus on tõsi. ");
INSERT INTO ekk_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jeesus tegi veel palju muid asju. Ma arvan, et terves maailmas poleks ruumi kõigi raamatute jaoks, kui see kõik üles kirjutataks.");
INSERT INTO ekk_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Oma varasemas raamatus, Teofilos, ma kirjutasin kõigest, mida Jeesus hakkas tegema ja õpetama, ");
INSERT INTO ekk_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kuni selle päevani, mil ta võeti taevasse pärast seda, kui ta oma väljavalitud apostlitele oli Püha Vaimu läbi andnud korraldusi. ");
INSERT INTO ekk_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Pärast oma kannatusi näitas ta end nendele elavana ja tegi seda veenvalt. Ta ilmus neile neljakümne päeva jooksul ja kõneles Jumala Kuningriigist. ");
INSERT INTO ekk_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ühel korral, kui ta koos nendega sõi, andis ta neile käsu: „Ärge lahkuge Jeruusalemmast, vaid oodake mu Isa tõotust, millest te olete minult kuulnud. ");
INSERT INTO ekk_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Sest Johannes ristis veega, aga mõne päeva pärast ristitakse teid Püha Vaimuga.“ ");
INSERT INTO ekk_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kui nad jälle kokku tulid, küsisid nad temalt: „Issand, kas sa sel ajal taastad Iisraeli kuningriigi?“ ");
INSERT INTO ekk_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ta vastas: „Teile ei ole teada antud aegu ja ajastuid, mis Isa on oma meelevallas määranud. ");
INSERT INTO ekk_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Aga te saate Püha Vaimu väe, kes tuleb teie peale, ja peate olema minu tunnistajad Jeruusalemmas ja kõigel Juuda- ja Samaariamaal ja maailma otsani!“ ");
INSERT INTO ekk_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kui ta seda oli öelnud, võeti ta nende nähes üles ja pilv varjas ta nende silme eest. ");
INSERT INTO ekk_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kui nad üksisilmi taevasse vaatasid tema lahkumist, ennäe, siis seisis järsku nende kõrval kaks valgeis riideis meest. ");
INSERT INTO ekk_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nad ütlesid imestunud jüngritele: „Galilea mehed, miks te seisate ja vaatate üles taeva poole? See Jeesus, kes teilt üles võeti taevasse, tuleb samal kombel kui te nägite teda taevasse minevat!“ ");
INSERT INTO ekk_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Apostlid pöördusid Õlimäelt tagasi Jeruusalemma, mis oli linnast vaid hingamispäeva teekonna kaugusel. ");
INSERT INTO ekk_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kui nad sinna jõudsid, läksid nad ülemisse tuppa, kus nad peatusid. Seal olid: Peetrus, Jaakobus, Johannes, Andreas, Filippus, Toomas, Bartolomeus, Matteus, Jaakobus Alfeuse poeg, seloot Siimon ja Juudas, Jaakobuse poeg. ");
INSERT INTO ekk_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nemad kõik olid ühel meelel lakkamatus palves ja anumises. Nendega olid naisjüngrid ja Maarja, Jeesuse ema, ja tema vennad. ");
INSERT INTO ekk_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Neil päevil tõusis Peetrus usklike hulgas püsti (rahvast oli koos umbes sada kakskümmend inimest) ");
INSERT INTO ekk_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ja ütles: „Mehed-vennad, täide pidi minema kirjasõna, mis Püha Vaim on Taaveti suu läbi kõnelenud Juudase kohta, kes juhatas Jeesuse kinnivõtjaid – ");
INSERT INTO ekk_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","tema oli üks meie hulgast ja valitud samasse ametisse. ");
INSERT INTO ekk_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ta ostis ülekohtu palga eest põllu, ja kui ta pea ees alla kukkus, rebis lõhki oma kõhu ja kogu ta sisikond valgus välja. ");
INSERT INTO ekk_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Igaüks Jeruusalemmas teab, mis temaga juhtus. Sellepärast kutsutaksegi seda põldu nende keeles Hakeldamaks, see tähendab Verepõlluks. ");
INSERT INTO ekk_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Sest lauludes on kirjutatud: „Nende telklaager saagu lagedaks: ärgu olgu nende telkides elanikke!“ Ja samuti: „Tema amet saagu teisele!“ ");
INSERT INTO ekk_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Nõnda on tarvis valida tema asendaja nende hulgast, kes on meiega olnud kogu selle aja, mil Issand Jeesus meiega sisse ja välja kõndis, ");
INSERT INTO ekk_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","alates Johannese ristimisest kuni ajani, mil Jeesus meilt võeti üles. Üks neist peab saama Jeesuse ülestõusmise tunnistajaks koos meiega.“ ");
INSERT INTO ekk_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nõnda nad pakkusid välja kaks meest: Joosepi, keda kutsuti Barsabaseks (tuntud ka kui Justus), ja Mattiase. ");
INSERT INTO ekk_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Siis nad palvetasid: „Issand, sina tead iga inimese südant. Näita meile, kumma neist kahest mehest sina oled valinud ");
INSERT INTO ekk_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","selleks teenistuseks, mille Juudas jättis, et minna sinna, kuhu ta kuulub.“ ");
INSERT INTO ekk_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nad heitsid liisku ja liisk langes Mattiasele. Nõnda lisati ta üheteistkümne apostli hulka. ");
INSERT INTO ekk_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kui nelipühapäev kätte jõudis, olid nad kõik ühel meelel samas paigas. ");
INSERT INTO ekk_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Järsku tuli taevast võimas kohin, nagu torm oleks tulnud, ja see täitis kogu maja, kus nad viibisid. ");
INSERT INTO ekk_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nad nägid tulekeeli, mis eraldusid ja jäid iga üksiku peale puhkama. ");
INSERT INTO ekk_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ja nad kõik täideti Püha Vaimuga ning hakkasid kõnelema teistes keeltes, nõnda nagu Vaim neile andis rääkida. ");
INSERT INTO ekk_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jeruusalemma oli tulnud elama jumalakartlikke juute kõigi rahvaste keskelt taeva all. ");
INSERT INTO ekk_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kui nad seda häält kuulsid, jooksis rahvas hämmelduses kokku, sest igaüks kuulis neid rääkimas omaenese keeles. ");
INSERT INTO ekk_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Jahmununa küsisid nad üksteiselt: „Eks need mehed, kes räägivad, ole kõik Galileast? ");
INSERT INTO ekk_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kuidas siis nii on, et meist igaüks kuuleb omaenda keelt? ");
INSERT INTO ekk_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Partlased, meedlased ja eelamlased; Mesopotaamia, Juudamaa, Kappadookia, Pontose ja Aasia, ");
INSERT INTO ekk_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Früügia ja Pamfüülia, Egiptuse ja Küreene-äärse Liibüa elanikud. Need, kes tulnud Roomast ");
INSERT INTO ekk_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(juudid ja juudiusku pöördunud), kreetalased ja araablased – me kuuleme neid kuulutamas meie endi keeles Jumala imelisi asju.“ ");
INSERT INTO ekk_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Hämmastuses ja segaduses pärisid nad üksteise käest: „Mida see küll tähendab?“ ");
INSERT INTO ekk_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Teised aga pilkasid neid ja ütlesid: „Nad on täis magusat värsket veini.“ ");
INSERT INTO ekk_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Siis tõusis Peetrus koos üheteistkümne apostliga püsti, tõstis häält ja pöördus rahvahulga poole: „Juudid ja kõik, kes te olete Jeruusalemma tulnud, pange tähele minu sõnu ja olgu see teile teadmiseks, ");
INSERT INTO ekk_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","et need mehed ei ole purjus, nagu te mõtlete, sest on alles kolmas tund. ");
INSERT INTO ekk_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Vaid see on, mida prohvet Joel on öelnud: ");
INSERT INTO ekk_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","„Viimseil päevil, ütleb Jumal, sünnib, et ma valan oma Vaimu välja kõigi inimeste peale. Teie pojad ja tütred prohveteerivad ja teie noored mehed näevad nägemusi ja teie vanad mehed näevad unenägusid. ");
INSERT INTO ekk_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ning oma teenijate – nii meeste kui naiste peale – ma valan neil päevil oma Vaimu ja nad prohveteerivad. ");
INSERT INTO ekk_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ma teen imesid ülal taevas ja annan tunnustähti all maa peal: verd ja tuld ja suitsusambaid. ");
INSERT INTO ekk_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Päike muutub pimedaks ja kuu vereks, enne kui saabub suur ja vägev Issanda päev, ");
INSERT INTO ekk_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ja igaüks, kes hüüab appi Issanda nime, päästetakse.“ ");
INSERT INTO ekk_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Iisraeli mehed, kuulake neid sõnu: Naatsareti Jeesus, mees Jumala juurest, näitas teile väge ja imesid ja tunnustähti, mida Jumal tema läbi tegi, nagu te isegi teate. ");
INSERT INTO ekk_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","See mees anti teile üle Jumala seatud eesmärgil ja eelteadmisel; ja teie tapsite ta ristil ülekohtuste käte läbi. ");
INSERT INTO ekk_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sellesama äratas Jumal üles surnuist, vabastades ta surma kannatustest, sest surmal ei olnud väge teda hoida. ");
INSERT INTO ekk_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nõnda nagu Taavet ütles tema kohta: „Ma näen Issandat kogu aeg enese ees. Ta on mu paremal käel ja ma ei kõigu. ");
INSERT INTO ekk_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ja nõnda mu süda rõõmustab ja keel hõiskab, sest mu ihu saab elama lootuses. ");
INSERT INTO ekk_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Sest sa ei jäta mind surmavalda, ega lase oma Pühal näha kõdunemist. ");
INSERT INTO ekk_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Sest sa oled mulle andnud teada elu tee ja sinu ees olemine täidab mind rõõmuga.“ ");
INSERT INTO ekk_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Mehed-vennad, lubage mul öelda teile otse, et meie esiisa Taavet on surnud ja on maha maetud ja tema haud on tänaseni siin. ");
INSERT INTO ekk_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Aga ta oli prohvet ja teadis, et Jumal oli talle vandega tõotanud tõsta troonile ühe tema järeltulija. ");
INSERT INTO ekk_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Niisiis nägi Taavet ette, mida Jumal teeb, ja ta kõneles Messia ülestõusmisest, et teda ei jäetud surmavalda, ega näinud tema ihu kõdunemist. ");
INSERT INTO ekk_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Selle Jeesuse äratas Jumal üles, meie kõik oleme selle tunnistajad. ");
INSERT INTO ekk_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Et ta on ülendatud Jumala paremale käele, siis ta on saanud Isalt tõotatud Püha Vaimu ning on ta välja valanud, nagu nüüd kuulete ja näete. ");
INSERT INTO ekk_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Taavet ei tõusnud ju taevasse, kuid siiski ta ütles: „Issand ütles minu Issandale: „Istu mu paremale käele, ");
INSERT INTO ekk_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kuni ma panen sinu vaenlased su jalge alla jalajäriks.“ “ ");
INSERT INTO ekk_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Andke siis teada kogu Iisraelile: Jumal on teinud selle Jeesuse, kelle teie risti lõite, nii Issandaks kui Messiaks!“ ");
INSERT INTO ekk_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kui rahvas seda kuulis, lõikas see neil südameisse ja nad ütlesid Peetrusele ja teistele apostlitele: „Mehed-vennad, mida me peame tegema?“ ");
INSERT INTO ekk_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peetrus vastas neile: „Parandage meelt ja laske ennast ristida Jeesuse Kristuse nimesse oma pattude andekssaamiseks, ja siis te saate Püha Vaimu anni. ");
INSERT INTO ekk_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","See tõotus on teile ja teie lastele ja kõikidele, kes on kaugel, keda Issand, meie Jumal, enese juurde kutsub.“ ");
INSERT INTO ekk_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Veel paljude teistegi sõnadega kinnitas Peetrus neid ja anus: „Päästke endid sellest korrumpeerunud põlvkonnast!“ ");
INSERT INTO ekk_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Kes selle sõnumi vastu võtsid, need ristiti, ja umbes kolm tuhat hinge lisati nende hulka sel päeval. ");
INSERT INTO ekk_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nad pühendasid endid apostlite õpetusele, osadusele, leivamurdmisele ja palvele. ");
INSERT INTO ekk_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jumalakartus langes iga hinge peale ning palju imetegusid ja tunnustähti sündis apostlite läbi. ");
INSERT INTO ekk_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kõik usklikud olid üheskoos ja jagasid omavahel kõike, mis neil oli. ");
INSERT INTO ekk_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Omandi ja vara müüsid nad ära ja andsid igaühele, nagu keegi vajas. ");
INSERT INTO ekk_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nad kogunesid päevast päeva templis, murdsid leiba kodudes ja sõid üheskoos rõõmsalt ja siiraste südametega, ");
INSERT INTO ekk_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","kiites Jumalat ja kogedes inimeste poolehoidu. Issand aga lisas päästetuid iga päev kogudusele. ");
INSERT INTO ekk_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ühel päeval läksid Peetrus ja Johannes üles templisse palvusele, mida peeti üheksandal tunnil. ");
INSERT INTO ekk_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Üks mees, kes oli sünnist saadik halvatud, toodi iga päev templi värava juurde, mida kutsuti Ilusaks, sisenejailt almust paluma. ");
INSERT INTO ekk_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kui ta nägi Peetrust ja Johannest sisenemas, palus ta neilt almust. ");
INSERT INTO ekk_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Aga Peetrus ja Johannes vaatasid teda üksisilmi. ");
INSERT INTO ekk_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Peetrus ütles talle: „Vaata meie poole.“ Ja ta pööras neile tähelepanu, lootes neilt midagi saada. ");
INSERT INTO ekk_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Peetrus ütles: „Kulda ja hõbedat mul ei ole, aga mis mul on, selle ma sulle annan – Jeesuse Kristuse, Naatsaretlase nimel, tõuse ja kõnni!“ ");
INSERT INTO ekk_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ta võttis kinni tema paremast käest ja aitas ta üles ja silmapilkselt tehti tema jalad ja pahkluud tugevaks. ");
INSERT INTO ekk_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ja ta hüppas püsti ja hakkas kõndima. Siis ta läks koos nendega templisse – kõndides, hüpates ja Jumalat kiites. ");
INSERT INTO ekk_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kui inimesed nägid teda kõndimas ja Jumalat kiitmas, ");
INSERT INTO ekk_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","tundsid nad ära temas mehe, kes oli istunud templi Ilusa Värava ees, ja nad olid kohkunud ja imestunud sellest, mis temaga oli sündinud. ");
INSERT INTO ekk_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kui halvatu, kes oli terveks saanud, hoidis Peetruse ja Johannese lähedale, oli kogu rahvas hämmelduses ja jooksis nende juurde paika, mida kutsuti Saalomoni sammaskäiguks. ");
INSERT INTO ekk_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kui Peetrus seda nägi, ütles ta neile: „Iisraeli mehed, mispärast see teid üllatab? Miks te vahite meid, justkui meie oleksime omaenda väe või vagadusega selle mehe pannud kõndima? ");
INSERT INTO ekk_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Aabrahami, Iisaki ja Jaakobi Jumal, meie isade Jumal on kirgastanud oma sulast Jeesust. Teie andsite ta ära tapmiseks ja salgasite ta maha Pilaatuse ees, kuigi too oli otsustanud tema vabastada. ");
INSERT INTO ekk_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Teie lükkasite ära Püha ja Õige ning küsisite tema asemel endale mõrtsuka. ");
INSERT INTO ekk_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Teie tapsite Elu Rajaja, kuid Jumal äratas ta üles surnuist ja selle tunnistajad oleme meie. ");
INSERT INTO ekk_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Usu läbi Jeesuse nimesse tehti see mees, keda näete ja teate, tugevaks. Jeesuse nimi ning usk, mis tema läbi tuleb, on andnud talle täieliku tervenemise teie kõigi nähes. ");
INSERT INTO ekk_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ja nüüd, vennad, ma tean, et te olete seda teinud teadmatusest, just nagu ka teie juhid. ");
INSERT INTO ekk_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Jumal on aga sellega täide saatnud, mida ta on kõigi prohvetite läbi ette kuulutanud, et Messias peab kannatama. ");
INSERT INTO ekk_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Seepärast parandage meelt ja pöörduge Jumala poole, et teie patud kustutataks, nii et Issandalt tuleksid kosumisajad ");
INSERT INTO ekk_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ja ta läkitaks teie jaoks määratud Messia Jeesuse. ");
INSERT INTO ekk_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tema peab jääma taevasse selle ajani, kui taastatakse kõik, millest Jumal on rääkinud oma pühade prohvetite suu kaudu aegade algusest peale. ");
INSERT INTO ekk_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Sest Mooses on öelnud: „Issand, teie Jumal, tõstab teile Prohveti teie rahva seast, sellise nagu mina. Teda kuulake kõiges, mida ta teile ütleb. ");
INSERT INTO ekk_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Iga hing, kes seda Prohvetit ei kuula, hävitatakse rahva hulgast ära.“ ");
INSERT INTO ekk_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Tõepoolest, alates Saamuelist on kõik prohvetid, kes on rääkinud, neid päevi ette kuulutanud. ");
INSERT INTO ekk_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Teie olete prohvetite ja selle lepingu pärijad, mille Jumal sõlmis teie isadega, kui ta Aabrahamile ütles: „Sinu järeltulijate läbi õnnistatakse kõiki rahvaid maa peal.“ ");
INSERT INTO ekk_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Jumal on esmalt teie jaoks oma poja Jeesuse üles äratanud ja teie juurde saatnud teid õnnistama, kui te pöördute oma kurjusest.“ ");
INSERT INTO ekk_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Aga kui nad rahvale rääkisid, astusid Peetruse ja Johannese juurde preestrid, templi korravalvurite kapten ja saduserid. ");
INSERT INTO ekk_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Neid ärritas, et apostlid õpetasid inimesi ja kuulutasid surnuist ülestõusmist Jeesuses. ");
INSERT INTO ekk_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nad võtsid Peetruse ja Johannese kinni ja kuna oli juba õhtu, panid nad järgmise päevani vangi. ");
INSERT INTO ekk_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kuid paljud neist, kes sõnumit kuulsid, uskusid; ja meeste arv kasvas umbes viie tuhandeni. ");
INSERT INTO ekk_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ja nõnda sündis, et järgmisel päeval kogunesid juutide juhid, vanemad ja kirjatundjad Jeruusalemmas. ");
INSERT INTO ekk_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ka ülempreester Hannas oli seal, samuti Kaifas, Johannes ja Aleksandros ja teised mehed ülempreestri perekonnast. ");
INSERT INTO ekk_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ja nad panid apostlid endi keskele seisma ja pärisid: „Millise meelevallaga või kelle nimel te olete seda teinud?“ ");
INSERT INTO ekk_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Siis Peetrus, täis Püha Vaimu, ütles neile: „Rahva juhid ja Iisraeli vanemad, kuulake! ");
INSERT INTO ekk_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Kui meie oleme täna kutsutud aru andma halvatule tehtud heateost ja kelle läbi ta on terveks tehtud, ");
INSERT INTO ekk_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","siis olgu teile kõigile ja kogu Iisraeli rahvale teada, et Jeesuse Kristuse, Naatsaretlase nimel, kelle teie lõite risti ja kelle Jumal on üles äratanud surnuist, et tema läbi seisab see mees siin teie ees tervena. ");
INSERT INTO ekk_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Tema on: „Kivi, mille ehitajad pidasid kõlbmatuks, mis on saanud nurgakiviks.“ ");
INSERT INTO ekk_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ja üheski teises ei ole päästet, sest taeva all ei ole antud inimestele ühtegi teist nime, kelle läbi meid päästetaks!“ ");
INSERT INTO ekk_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kui nad nägid Peetruse ja Johannese julgust ja aru said, et nad on lihtsad, koolitamata mehed, olid nad hämmastunud ja mõistsid, et need kaks olid olnud koos Jeesusega. ");
INSERT INTO ekk_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ja kuna tervendatud mees seisis seal koos nendega, ei olnud neil midagi enam öelda. ");
INSERT INTO ekk_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nõnda nad käskisid neid Suurkohtust lahkuda ja pidasid seejärel koos nõu: ");
INSERT INTO ekk_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","„Mis me peaksime nende meestega tegema? Sest igaüks teab, kes Jeruusalemmas elab, et tunnustäht on sündinud, ja me ei saa seda salata. ");
INSERT INTO ekk_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Aga et see kaugemale ei leviks rahva hulgas, peame neid mehi ähvardama, et nad enam ühelegi inimesele ei räägiks sellest nimest.“ ");
INSERT INTO ekk_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ja nad kutsusid apostlid tagasi ning keelasid neil rääkida ja õpetada Jeesuse nimel. ");
INSERT INTO ekk_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Aga Peetrus ja Johannes vastasid neile: „Otsustage ise, kas Jumala ees on õige alluda pigem teile või Jumalale? ");
INSERT INTO ekk_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Me ei saa jätta rääkimata seda, mida me oleme kuulnud ja näinud!“ ");
INSERT INTO ekk_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Aga nad ähvardasid neid veelgi ja lasksid apostlid vabaks. Sest nad ei leidnud viisi, kuidas neid karistada, kuna kõik kiitsid Jumalat selle eest, mis oli sündinud. ");
INSERT INTO ekk_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Sest mees, kes oli imepäraselt terveks tehtud, oli üle neljakümne aasta vana. ");
INSERT INTO ekk_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pärast vabanemist läksid Peetrus ja Johannes omade juurde ja jutustasid, mis ülempreestrid ja vanemad olid öelnud. ");
INSERT INTO ekk_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Seda kuuldes tõstsid nad üheskoos häält Jumala poole palves: „Issand, sina oled Jumal, kes on teinud taeva ja maa ja mere ja kõik, mis on nende sees, ");
INSERT INTO ekk_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","kes oled Püha Vaimu läbi meie isa Taaveti, oma sulase suu kaudu öelnud: „Miks paganad möllavad ja rahvad mõtlevad tühja? ");
INSERT INTO ekk_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ilmamaa kuningad on astunud üles ja valitsejad on kogunenud ühte paika Issanda vastu ning tema Võitu vastu!“ ");
INSERT INTO ekk_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Siin linnas on Heroodes ja Pontius Pilatus kogunenud salanõu pidama paganatega ja Iisraeli rahvaga sinu sulase Jeesuse vastu, keda sa oled võidnud, ");
INSERT INTO ekk_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","et teha seda, mis sinu käsi ja nõu olid ette määranud sündima. ");
INSERT INTO ekk_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ja nüüd, Issand, vaata nende ähvarduste peale ja anna oma sulastele kõige julgusega rääkida sinu sõna. ");
INSERT INTO ekk_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Siruta välja oma käsi, et tervekssaamised ning imed ja tunnustähed sünniksid sinu püha sulase Jeesuse nime läbi!“ ");
INSERT INTO ekk_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ja kui nad olid palvetanud, rappus paik, kus nad koos olid. Ja nad kõik said täidetud Püha Vaimuga ja kuulutasid Jumala sõna julgesti. ");
INSERT INTO ekk_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ja usklike hulk oli üks süda ja üks hing. Keegi ei öelnud oma vara kohta, et see on tema oma, vaid nad jagasid kõike, mis neil oli. ");
INSERT INTO ekk_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apostlid tunnistasid suure väega Issanda Jeesuse ülestõusmist. Ja Jumala arm tegutses nii võimsalt neis kõigis, ");
INSERT INTO ekk_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","nii et nende seas ei olnud abivajajaid. Kellel olid maad ja majad, müüsid need ära ning tõid müügist saadud raha ");
INSERT INTO ekk_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ja panid apostlite jalge ette, ja seda jagati igaühele, kes seda vajas. ");
INSERT INTO ekk_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Aga Joosep, leviit Küproselt, keda apostlid kutsusid Barnabaseks (mis tähendab Julgustuse poega), ");
INSERT INTO ekk_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","müüs ära oma põllu ning tõi raha apostlite jalge ette. ");
INSERT INTO ekk_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Keegi mees nimega Ananias ja tema naine Safiira olid samuti müünud maatüki. ");
INSERT INTO ekk_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ta hoidis osa rahast naise teadmisel endale, ülejäänu ta tõi ja pani apostlite jalge ette. ");
INSERT INTO ekk_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Aga Peetrus ütles: „Ananias, kuidas on saatan nõnda täitnud su südame, et sa valetasid Pühale Vaimule ja hoidsid enesele osa maa eest saadud rahast? ");
INSERT INTO ekk_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Eks see kõik ju kuulunud sulle, enne kui see müüdi? Ja pärastki oli see raha ikka sinu käsutuses. Mis sind on pannud mõtlema, et sellist asja teha? Sa ei ole valetanud inimestele, vaid Jumalale.“ ");
INSERT INTO ekk_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Neid sõnu kuuldes kukkus Ananias maha ja suri. Ja suur hirm haaras kõiki, kes sellest kuulsid. ");
INSERT INTO ekk_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Noored mehed astusid ette, mähkisid ta linasse, kandsid välja ja matsid maha. ");
INSERT INTO ekk_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Umbes kolm tundi hiljem saabus Ananiase naine, kes ei olnud veel kuulnud, mis oli sündinud. ");
INSERT INTO ekk_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peetrus küsis ta käest: „Ütle mulle, kas te müüsite maatüki sellise hinnaga?“ „Jah,“ kostis Safiira, „selle hinnaga.“ ");
INSERT INTO ekk_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peetrus ütles talle: „Mispärast on teil üks nõu olnud kiusata Issanda Vaimu? Vaata! Nende jalad, kes su mehe matsid, on ukse taga ja nad kannavad ka sinu välja.“ ");
INSERT INTO ekk_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Samal silmapilgul kukkus naine tema jalge ette ja suri. Ja kui noored mehed sisse tulid, leidsid nad ta surnuna. Nad kandsid ta välja ja matsid ta mehe kõrvale. ");
INSERT INTO ekk_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Jumalakartus tuli terve koguduse peale ja kõikide peale, kes sellest kuulsid. ");
INSERT INTO ekk_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apostlite käte läbi sündis palju tunnustähti ja imesid rahva hulgas. Ja kõik usklikud olid koos ühel meelel Saalomoni sammaskäigus. ");
INSERT INTO ekk_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ehkki muudest inimestest ei julgenud keegi nendega ühineda, olid apostlid rahva hulgas kõrgelt hinnatud. ");
INSERT INTO ekk_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Siiski lisati nende hulka üha enam mehi ja naisi, kes Issandasse uskusid. ");
INSERT INTO ekk_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nii et haiged toodi tänavatele ja seati vooditele ja asemetele, et Peetruse möödudes kasvõi tema varigi langeks mõne peale neist. ");
INSERT INTO ekk_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ka tuli rahvast kokku Jeruusalemma ümbruse linnadest, tuues haigeid ja kurjadest vaimudest vaevatuid, kes kõik tehti terveks. ");
INSERT INTO ekk_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Aga ülempreester ja kõik ta kaaslased saduseride sektist muutusid kadedaks. ");
INSERT INTO ekk_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nad võtsid apostlid kinni ja heitsid nad üldvanglasse. ");
INSERT INTO ekk_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Öösel tuli aga Issanda ingel, avas vangimaja uksed ja viis nad välja. ");
INSERT INTO ekk_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ingel ütles neile: „Minge templisse ja kuulutage rahvale kõik selle elu sõnad!“ ");
INSERT INTO ekk_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Päikesetõusu ajal läksid nad templisse, nagu neile oli öeldud, ja hakkasid õpetama. Aga kui ülempreester ja tema kaaslased saabusid, kutsusid nad kokku Suurkogu – Iisraeli vanematekogu. Ja nad andsid käsu tuua apostlid vangimajast kogu ette. ");
INSERT INTO ekk_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kuid vanglasse jõudes ei leidnud sulased neid sealt. Nad pöördusid tagasi ja teatasid: ");
INSERT INTO ekk_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","„Me leidsime vangla kindlalt lukustatuna ja valvurid ustel valvamas. Aga kui me ukse avasime, ei leidnud seest kedagi.“ ");
INSERT INTO ekk_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Seda aruannet kuuldes olid preester, templivalvurite kapten ja ülempreestrid segaduses, mõeldes, mis küll võis juhtuda. ");
INSERT INTO ekk_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Siis tuli keegi ja teatas: „Vaadake! Mehed, kelle te panite vangi, seisavad templis ja õpetavad rahvast!“ ");
INSERT INTO ekk_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Selle peale läks kapten sulastega kaasa ja tõi apostlid ära. Nad ei kasutanud jõudu, sest kartsid, et rahvas viskab nad kividega surnuks. ");
INSERT INTO ekk_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nad tõid siis apostlid Suurkohtu ette ülempreestrile küsitlemiseks: ");
INSERT INTO ekk_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","„Eks me ole teid rangelt keelanud õpetamast selle nimel? Selle asemel te olete Jeruusalemma oma õpetusega täitnud ja kavatsete selle mehe surma tuua meie peale.“ ");
INSERT INTO ekk_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peetrus ja teised apostlid vastasid: „Jumalale tuleb rohkem kuuletuda kui inimestele. ");
INSERT INTO ekk_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Meie esiisade Jumal on surnuist üles äratanud Jeesuse, kelle teie olete tapnud, riputades ta ristipuu külge. ");
INSERT INTO ekk_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Jumal ülendas ta oma paremale käele kui Juhi ja Päästja, andma Iisraelile meeleparandust ja pattude andeksandmist. ");
INSERT INTO ekk_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Meie oleme kõige selle tunnistajad ja nõnda on ka Püha Vaim, kelle Jumal on andnud neile, kes talle kuuletuvad.“ ");
INSERT INTO ekk_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kui nad seda kuulsid, said nad vihaseks ja tahtsid neid hukata. ");
INSERT INTO ekk_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Aga variser nimega Gamaliel, Seaduse õpetaja, keda kõik inimesed austasid, tõusis Suurkohtus püsti ja käskis mehed hetkeks välja saata. ");
INSERT INTO ekk_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Siis ta pöördus Suurkohtu poole: „Iisraeli mehed, mõelge hästi järele, mida te kavatsete nende meestega teha. ");
INSERT INTO ekk_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mõni aeg tagasi ilmus välja Teudas ja väitis enese kellegi olevat ja ligi nelisada inimest järgis teda. Ta tapeti ja kõik tema järgijad aeti laiali ja sellest kõigest ei tulnud midagi. ");
INSERT INTO ekk_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pärast teda tõusis rahvaloenduse ajal üles galilealane Juudas ja õhutas inimesi mässama. Ka tema tapeti ja ta järgijad aeti laiali. ");
INSERT INTO ekk_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Seepärast praegusel juhul ma soovitan teile: jätke need mehed rahule! Laske neil minna! Sest kui nende eesmärk või tegevus on inimesest, siis see kukub läbi. ");
INSERT INTO ekk_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Aga kui see on Jumalast, ei suuda teie neid peatada, vaid teist saavad võitlejad Jumala vastu!“ ");
INSERT INTO ekk_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tema kõne veenis neid. Nad kutsusid apostlid sisse ja peksid neid. Siis nad keelasid neid rääkida Jeesuse nimel ning lasid neil minna. ");
INSERT INTO ekk_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Apostlid lahkusid Suurkohtu eest, rõõmustades, et neid oli väärt arvatud kannatama alandust selle Nime pärast. ");
INSERT INTO ekk_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ja nad ei lakanud iga päev templis olles ja majast majja käies õpetamast ja kuulutamast evangeeliumi Jeesusest Messiast. ");
INSERT INTO ekk_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Neil päevil, kui jüngrite arv kasvas, hakkasid Kreeka päritolu juudid kurtma Heebrea päritolu juutide üle, et igapäevase toidu jagamisel nende leskedega ei arvestata. ");
INSERT INTO ekk_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Siis kutsusid need kaksteist kokku kõik jüngrid ja sõnasid: „See ei oleks õige, kui jätaksime Jumala sõnaga teenimise unarusse, et teenida toidulauas. ");
INSERT INTO ekk_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Seepärast, vennad ja õed, valige endi hulgast seitse meest, kes on täis Püha Vaimu ja tarkust. Me anname selle vastutuse neile üle ");
INSERT INTO ekk_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ja pühendume ise palvele ja sõna teenimisele.“ ");
INSERT INTO ekk_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","See ettepanek meeldis kõigile. Nad valisid Stefanose, mehe täis usku ja Püha Vaimu, samuti Filippuse, Prokorose, Nikanori, Timoni, Parmenase ja Nikolase Antiookiast, kes oli pöördunud juudiusku. ");
INSERT INTO ekk_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Need mehed tõid nad apostlite ette, ja kui nad palvetasid, panid nad oma käed nende peale. ");
INSERT INTO ekk_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nõndaviisi levis Jumala sõna. Jüngrite arv Jeruusalemmas kasvas väga suureks; ka paljud preestrid võtsid usu omaks. ");
INSERT INTO ekk_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Aga Stefanos, täis Jumala armu ja väge, tegi imetegusid ja suuri tunnustähti inimeste hulgas. ");
INSERT INTO ekk_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Aga vastuseis kasvas vabakslastute sünagoogi liikmete hulgas, kelle seas olid juudid Küreenest ja Aleksandriast, samuti Kiliikia ja Aasia provintsidest. Need mehed püüdsid Stefanosega vaielda, ");
INSERT INTO ekk_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ent ei suutnud vastu seista tarkusele ega Vaimule, kes tema läbi rääkis. ");
INSERT INTO ekk_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Siis nad ärgitasid mõndasid ütlema: „Me oleme kuulnud Stefanost rääkivat teotavaid sõnu Moosese ja Jumala vastu.“ ");
INSERT INTO ekk_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ja nõnda nad ässitasid rahvast, vanemaid ja kirjatundjaid. Nad võtsid Stefanose kinni ja viisid ta Suurkohtu ette. ");
INSERT INTO ekk_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nad tõid kohale valetunnistajaid, kes kinnitasid: „See mees ei lakka rääkimast püha paiga ja Seaduse vastu, ");
INSERT INTO ekk_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","sest me oleme kuulnud teda ütlemas, et Naatsareti Jeesus hävitab selle koha ja muudab ära Moosese antud kombed.“ ");
INSERT INTO ekk_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ja kui kõik Suurkohtus istujad Stefanost tähelepanelikult vaatasid, nägid nad tema palge olevat otsekui inglil. ");
INSERT INTO ekk_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ülempreester küsis temalt: „Kas need süüdistused vastavad tõele?“ ");
INSERT INTO ekk_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Aga Stefanos vastas: „Mehed, vennad ja isad, kuulake mind! Au Jumal ilmus meie isale Aabrahamile, kui ta elas Mesopotaamias, enne Haaranisse siirdumist. ");
INSERT INTO ekk_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","„Lahku oma maalt ja oma rahva hulgast,“ ütles Jumal, „ja mine sinna maale, mida ma sulle näitan!“ ");
INSERT INTO ekk_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nõnda ta lahkus kaldealaste maalt ja seadis end sisse Haaranis. Pärast tema isa surma saatis Jumal tema sealt siia maale, kus teie nüüd elate. ");
INSERT INTO ekk_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Jumal ei andnud Aabrahamile siin jalatäitki maad pärandiks. Aga tõotas selle maa anda omandiks talle ja ta järeltulijatele ajal, mil tal lapsi ei olnud. ");
INSERT INTO ekk_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Jumal rääkis nõnda: „Tema järeltulijad elavad võõrana võõral maal ja nad tehakse orjadeks ja neile tehakse kurja nelisada aastat. ");
INSERT INTO ekk_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ja rahvast, keda nad orjavad, mina karistan,“ ütles Jumal, „ja pärast seda nad lähevad välja ja teenivad mind selles paigas.“ ");
INSERT INTO ekk_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ja Jumal andis Aabrahamile ümberlõikamislepingu. Ja Aabrahamile sündis Iisak ja ta lõikas tema ümber kaheksandal päeval. Ja Iisakile sündis Jaakob, ja Jaakobile need kaksteist patriarhi. ");
INSERT INTO ekk_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Kuna patriarhid olid Joosepi peale kadedad, müüsid nad ta Egiptusesse orjaks. Ent Jumal oli temaga ");
INSERT INTO ekk_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ja päästis ta kõigist tema hädadest. Ta andis Joosepile armu ja tarkust vaarao, Egiptuse kuninga ees, ning tema tõstis ta kogu Egiptuse ja terve oma koja valitsejaks. ");
INSERT INTO ekk_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Siis tabas Egiptust ja Kaananit nälg, mis tõi kaasa suuri kannatusi, ja meie isad ei leidnud enam toitu. ");
INSERT INTO ekk_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Aga kui Jaakob kuulis, et Egiptuses on vilja, läkitas ta meie isad sinna esimest korda. ");
INSERT INTO ekk_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ja teisel korral rääkis Joosep vendadele, kes ta on, ja vaarao sai teada Joosepi päritolu. ");
INSERT INTO ekk_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Pärast seda laskis Joosep enda juurde tuua oma isa Jaakobi ja kogu oma suguvõsa, seitsekümmend viis hinge. ");
INSERT INTO ekk_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ja Jaakob läks Egiptusesse, kus tema ja meie isad surid. ");
INSERT INTO ekk_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nende põrmud viidi Sekemisse ja pandi hauda, mille Aabraham oli hõbeda eest ostnud Hamori poegadelt Sekemis. ");
INSERT INTO ekk_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Kui lähenes aeg Jumalal täita Aabrahamile antud tõotus, kasvas meie rahvas jõudsasti Egiptuses. ");
INSERT INTO ekk_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kuni tõusis Egiptuse valitsejaks teine kuningas, kes Joosepist midagi ei teadnud. ");
INSERT INTO ekk_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Tema käitus salakavalalt meie rahvaga ja tegi kurja meie esiisadele, sundides neid vastsündinud lapsi ära heitma, et nad sureksid. ");
INSERT INTO ekk_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Sel ajal sündis Mooses ja ta meeldis Jumalale. Tema eest hoolitseti kolm kuud tema isa majas. ");
INSERT INTO ekk_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Aga kui ta oli ära heidetud, võttis vaarao tütar tema ja kasvatas enesele pojaks. ");
INSERT INTO ekk_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ja Moosesele õpetati kogu egiptlaste tarkust ja tema oli vägev sõnadelt ja tegudelt. ");
INSERT INTO ekk_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Kui Mooses oli nelikümmend aastat vana, tuli talle südamesse minna vaatama oma vendade, Iisraeli laste olukorda. ");
INSERT INTO ekk_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ja nähes ühele ülekohut tehtavat, läks ta teda kaitsma ja lõi egiptlase maha. ");
INSERT INTO ekk_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mooses arvas, et ta inimesed mõistavad, kuidas Jumal teda kasutab nende päästeks, aga nad ei mõistnud. ");
INSERT INTO ekk_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Järgmisel päeval kohtas Mooses kaht riidlevat iisraellast. Ta püüdis neid lepitada, öeldes: „Mehed, te olete vennad, miks te tahate üksteisele haiget teha?“ ");
INSERT INTO ekk_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Aga mees, kes teist halvasti kohtles, tõukas ta eemale ja sõnas: „Kes sind on määranud meile valitsejaks ja kohtumõistjaks? ");
INSERT INTO ekk_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kas sa tahad ka mind tappa, nagu sa eile tapsid egiptlase?“ ");
INSERT INTO ekk_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nende sõnade peale Mooses põgenes ja elas võõrana Midjanimaal, ja talle sündis kaks poega. ");
INSERT INTO ekk_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ja kui nelikümmend aastat sai täis, ilmus Moosesele ingel Siinai mäe lähedal kõrbes põlevas kibuvitsapõõsas. ");
INSERT INTO ekk_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mooses oli vaatepildist hämmastunud. Ja kui ta läks seda lähemalt uurima, kuulis ta Issanda häält: ");
INSERT INTO ekk_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","„Mina olen sinu isade Jumal, Aabrahami, Iisaki ja Jaakobi Jumal.“ Mooses värises hirmust ega julgenud vaadata. ");
INSERT INTO ekk_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Siis ütles Issand talle: „Võta sandaalid jalast, sest paik, kus sa seisad, on püha maa! ");
INSERT INTO ekk_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ma olen küllalt näinud oma rahva rõhumist Egiptuses. Ma olen kuulnud nende oigamist ning olen alla tulnud neid vabastama. Tule nüüd, ma läkitan sind Egiptusesse!“ ");
INSERT INTO ekk_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Sellesama Moosese, kelle nad olid hüljanud sõnadega: „Kes sind on määranud meile valitsejaks ja kohtumõistjaks?“, sellesama läkitas Jumal neile valitsejaks ja lunastajaks ingli läbi, kes talle oli ilmunud kibuvitsapõõsas. ");
INSERT INTO ekk_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mooses juhtis nad Egiptusest välja, tehes imesid ja tunnustähti Egiptuses, Punases meres ja kõrbes neljakümne aasta jooksul. ");
INSERT INTO ekk_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ja nii ütles Mooses Iisraeli poegadele: „Jumal tõstab teile teie rahva seast Prohveti, sellise nagu mina.“ ");
INSERT INTO ekk_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Tema oli kõrbes koos ingliga, kes kõneles talle Siinai mäel, ja meie isadega, ning ta võttis vastu elavad sõnad meile edasiandmiseks. ");
INSERT INTO ekk_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Aga meie isad keeldusid talle allumast. Nad tõukasid ta eemale ja pöördusid oma südames tagasi Egiptusesse. ");
INSERT INTO ekk_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nad ütlesid Aaronile: „Tee meile jumalaid, kes käiksid meie ees. Aga mis puutub vend Moosesesse, kes meid Egiptusest välja tõi, siis me ei tea, mis temaga juhtunud on!“ ");
INSERT INTO ekk_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","See oli aeg, kui nad tegid vasika kuju. Nad viisid ebajumalale ohvreid ja pidutsesid oma käte tegude üle. ");
INSERT INTO ekk_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kuid Jumal pöördus neist ära ja jättis nad teenima taeva vägesid. Nõnda on ka prohvetite raamatus kirjutatud: „Kas teie, Iisraeli sugu, tõite mulle ohvreid ja ande nelikümmend aastat kõrbes olles? ");
INSERT INTO ekk_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ei, vaid te võtsite Mooloki telgi ja oma jumala Raifa tähe, kujud, mis te olite teinud kummardamiseks. Seepärast pagendan ma teid teisele poole Paabelit.“ ");
INSERT INTO ekk_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Meie esiisadel oli tunnistustelk kõrbes. Nõnda nagu oli juhatanud Jumal, kes Moosesel käskis selle teha eeskuju järgi, mida ta oli näinud. ");
INSERT INTO ekk_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Selle telgi tõid meie isad Joosua juhtimisel endaga kaasa, kui nad võtsid maa rahvastelt, kelle Jumal nende eest minema ajas. Nii see oli Taaveti päevini, ");
INSERT INTO ekk_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","kes elas Jumala soosingus ja palus, et ta leiaks eluaseme Jaakobi soole. ");
INSERT INTO ekk_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","See oli aga Saalomon, kes ehitas temale koja. ");
INSERT INTO ekk_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Kuid Kõigekõrgem ei ela kätega tehtud kodades. Nõnda nagu prohvet ütleb: ");
INSERT INTO ekk_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","„Taevas on minu troon ja maa minu jalajäri. Millise koja teie tahate mulle ehitada, ütleb Issand, või kus on mu puhkepaik? ");
INSERT INTO ekk_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Eks minu käsi ole selle kõik teinud?“ ");
INSERT INTO ekk_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Te kangekaelsed ja ümberlõikamatud südamelt ja kõrvadelt! Teie seisate alati vastu Pühale Vaimule, nii nagu teie isad, nõnda olete ka teie. ");
INSERT INTO ekk_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kas on olnud prohvetit, keda teie isad ei ole taga kiusanud? Nad on tapnud isegi need, kes kuulutasid ette Õige tulemist. Ja nüüd olete teie ta ära andnud ja tapnud, ");
INSERT INTO ekk_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","kes saite Seaduse inglite kaudu, ent ei ole seda pidanud.“ ");
INSERT INTO ekk_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Aga kui Suurkohtu liikmed seda kuulsid, lõikas see neil südamesse ja nad kiristasid hambaid. ");
INSERT INTO ekk_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Stefanos aga, täis Püha Vaimu, vaatas taevasse ja nägi Jumala kirkust ning Jeesust seismas Jumala paremal käel. ");
INSERT INTO ekk_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","„Vaata,“ ütles ta, „ma näen taevast avatuna ja Inimese Poega seismas Jumala paremal käel!“ ");
INSERT INTO ekk_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Selle peale nad karjusid valju häälega ja oma kõrvu kätega kinni kattes tormasid nad tema kallale. ");
INSERT INTO ekk_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nad tirisid ta linnast välja ja viskasid teda kividega. Samal ajal panid tunnistajad oma rõivad ühe noormehe jalge ette, kelle nimi oli Saulus. ");
INSERT INTO ekk_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ja nad viskasid kividega Stefanost, kes valjusti palvetas: „Issand Jeesus, võta mu vaim vastu!“ ");
INSERT INTO ekk_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Siis ta laskus põlvili ja hüüdis valju häälega: „Issand, ära arva seda pattu neile süüks!“ Ja kui ta seda oli öelnud, uinus ta. ");
INSERT INTO ekk_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulus oli seal ja kiitis tema surma heaks. Sel päeval algas Jeruusalemmas suur koguduse tagakiusamine ja kõik peale apostlite pillutati laiali Juudamaal ja Samaarias. ");
INSERT INTO ekk_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Jumalakartlikud mehed matsid Stefanose ja nutsid valjult tema pärast. ");
INSERT INTO ekk_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ent Saulus hakkas hävitama kogudust. Majast majja liikudes tiris ta välja nii mehi kui naisi ja pani nad vangi. ");
INSERT INTO ekk_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Need, kes olid laiali pillutatud, kuulutasid sõna igal pool, kuhu nad läksid. ");
INSERT INTO ekk_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filippus läks alla ühte Samaaria linna ja kuulutas seal Messiat. ");
INSERT INTO ekk_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Rahvas kuulas Filippust, nad panid tähele tema sõnu ja nägid tunnustähti, mida ta tegi. ");
INSERT INTO ekk_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Sest paljudest lahkusid kurjad vaimud kisendades, palju halvatuid ja jalutuid aga sai terveks. ");
INSERT INTO ekk_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Suur rõõm oli kogu linnas. ");
INSERT INTO ekk_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Juba mõnda aega oli seal linnas elanud mees nimega Siimon, kes tegeles nõidumisega ja pani Samaaria inimesi jahmuma. Ta pidas ennast tähtsaks. ");
INSERT INTO ekk_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Talle pöörasid tähelepanu kõik inimesed, nii kõrged kui madalad, ning kuulutasid: „Seda meest nimetatakse Jumala Suureks Väeks!“ ");
INSERT INTO ekk_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nad järgisid teda, sest ta oli neid oma nõiakunstiga kaua aega hämmastanud. ");
INSERT INTO ekk_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Aga kui nad hakkasid uskuma Filippust, kes neile kuulutas evangeeliumi Jumala riigist ja Jeesuse Kristuse nimest, siis ristiti nii mehi kui naisi. ");
INSERT INTO ekk_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ka Siimon uskus ja sai ristitud. Ta hoidis Filippuse ligi kõikjal, olles hämmastunud tema läbi sündinud vägevatest tunnustähtedest ja imedest. ");
INSERT INTO ekk_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kui apostlid kuulsid Jeruusalemmas, et Samaaria oli Jumala sõna vastu võtnud, läkitasid nad nende juurde Peetruse ja Johannese. ");
INSERT INTO ekk_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Sinna jõudes palvetasid nad samaarlaste eest, et nad saaksid Püha Vaimu. ");
INSERT INTO ekk_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Sest Vaim ei olnud veel langenud kellegi peale neist, nad oli üksnes ristitud Issanda Jeesuse nimesse. ");
INSERT INTO ekk_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Siis panid Peetrus ja Johannes oma käed nende peale ja nad said Püha Vaimu. ");
INSERT INTO ekk_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aga kui Siimon nägi, et Vaim antakse apostlite käte pealepanemise kaudu, pakkus ta neile raha ");
INSERT INTO ekk_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ja ütles: „Andke mulle ka see meelevald, et igaüks saaks Püha Vaimu, kelle peale ma oma käed panen!“ ");
INSERT INTO ekk_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Peetrus vastas: „Hävigu su hõbe koos sinuga, et sa mõtled Jumala andi saada raha eest! ");
INSERT INTO ekk_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Sul ei ole mingit osa sellest sõnast, sest su süda ei ole õige Jumala ees. ");
INSERT INTO ekk_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Seepärast paranda meelt oma kurjusest ja anu Issandat. Ehk ta andestab sulle, et oled säärast mõtet oma südames mõelnud. ");
INSERT INTO ekk_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Sest ma näen sind kibeduses ja ebaõigluse kammitsais.“ ");
INSERT INTO ekk_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Siimon aga vastas: „Paluge teie Issandat minu pärast, et minu peale ei langeks midagi sellest, mis te olete öelnud!“ ");
INSERT INTO ekk_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Kui apostlid olid tunnistanud ja rääkinud Issanda sõna, pöördusid nad tagasi Jeruusalemma ja kuulutasid evangeeliumi paljudes Samaaria külades. ");
INSERT INTO ekk_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Issanda ingel ütles Filippusele: „Tõuse ja mine lõuna poole seda teed, mis läheb Jeruusalemmast alla Gazasse, see on kõrbetee!“ ");
INSERT INTO ekk_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Nõnda ta asus teele. Ja vaata, oma teel kohtas ta Etioopia eunuhhi, kes valitses etiooplaste kuninganna Kandake kogu varanduse üle. See mees oli tulnud Jeruusalemma Jumalat kummardama ");
INSERT INTO ekk_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ning oli tagasi pöördumas koju ja istus oma kaarikus ja luges prohvet Jesaja raamatut. ");
INSERT INTO ekk_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Jumala Vaim ütles Filippusele: „Mine kaariku juurde ja püsi selle lähedal!“ ");
INSERT INTO ekk_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filippus jooksis kaariku juurde ja kuulis meest lugemas prohvet Jesaja raamatut. „Kas sa ka mõistad, mida sa loed?“ küsis Filippus. ");
INSERT INTO ekk_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","„Kuidas ma saan mõista,“ ta ütles, „ilma et keegi mulle selgitaks?“ Ja ta kutsus Filippuse üles enda kõrvale istuma. ");
INSERT INTO ekk_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Eunuhh oli parasjagu lugemas seda kirjakohta: „Nagu lammas viidi ta tappa, ja nagu tall oma niitja ees on vait, nõnda ei avanud ta oma suud! ");
INSERT INTO ekk_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tema alandamisega on tema õigus ära võetud. Kes jõuab tema suguvõsast jutustada? Sest ta elu võetakse ära maa pealt.“ ");
INSERT INTO ekk_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Eunuhh küsis Filippuselt: „Palun ütle mulle, kellest prohvet siin räägib, kas endast või kellestki teisest?“ ");
INSERT INTO ekk_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ja Filippus alustas samast kirjakohast ja kuulutas talle evangeeliumi Jeesusest. ");
INSERT INTO ekk_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Kui nad teed mööda edasi sõitsid, jõudsid nad veekoguni ja eunuhh ütles: „Vaata, vesi! Mis takistab mind saama ristitud?“ ");
INSERT INTO ekk_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filippus vastas: „Kui sa usud kogu südamest, siis on see võimalik!“ Mees vastas: „Mina usun, et Jeesus Kristus on Jumala Poeg!“ ");
INSERT INTO ekk_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ja ta käskis kaariku peatada. Nii Filippus kui eunuhh astusid vette ja Filippus ristis tema. ");
INSERT INTO ekk_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Aga kui nad veest välja tulid, võttis Issanda Vaim Filippuse ära, ja eunuhh ei näinud teda enam; kuid ta läks oma teed edasi rõõmuga. ");
INSERT INTO ekk_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Aga Filippus leiti Asdodist, ja ta kuulutas evangeeliumi kõigile linnadele, kuni ta jõudis Kaisareasse. ");
INSERT INTO ekk_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Samal ajal paiskas Saulus ikka veel tapmisähvardusi Issanda jüngrite vastu. Ta läks ülempreestri juurde ");
INSERT INTO ekk_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ja küsis temalt kirju sünagoogide jaoks Damaskuses, et kui ta leiab sealt usuteel käijaid, olgu mehi või naisi, võiks ta need inimesed vangidena Jeruusalemma tuua. ");
INSERT INTO ekk_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Kui ta teel olles Damaskusele lähenes, sähvatas äkitselt taevast tema ümber valgus. ");
INSERT INTO ekk_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ta kukkus maha ja kuulis häält talle ütlemas: „Saul, Saul, miks sa mind taga kiusad?“ ");
INSERT INTO ekk_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","„Kes sa oled, Issand?“ küsis Saulus. „Mina olen Jeesus, keda sa taga kiusad. Sul on raske astla vastu takka üles lüüa,“ vastas Issand. ");
INSERT INTO ekk_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Värisedes ja hämmastuses küsis ta: „Issand, mida ma pean tegema?“ Ja Issand ütles: „Tõuse nüüd üles ja mine linna, seal öeldakse sulle, mis sul tuleb teha!“ ");
INSERT INTO ekk_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Aga mehed, kes koos Saulusega reisisid, seisid ehmunult; nad kuulsid küll häält, kuid ei näinud kedagi. ");
INSERT INTO ekk_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Aga Saulus tõusis maast üles, ja kui ta silmad avas, ei näinud ta enam. Nõnda ta talutati kättpidi Damaskusesse. ");
INSERT INTO ekk_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kolm päeva oli ta pime, ei söönud ega joonud. ");
INSERT INTO ekk_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ent Damaskuses oli jünger nimega Ananias. Issand kutsus teda nägemuses: „Ananias!“ „Issand, vaata, siin ma olen!“ vastas Ananias. ");
INSERT INTO ekk_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Issand ütles talle: „Mine Sirgel tänaval Juudase majja ja küsi Tarsosest pärit Sauluse järele, sest ta on seal palvetamas. ");
INSERT INTO ekk_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ta on näinud nägemuses, kuidas mees nimega Ananias tuli tema juurde ja pani käed tema peale, et ta nägemise tagasi saaks!“ ");
INSERT INTO ekk_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","„Issand,“ vastas Ananias, „ma olen paljudelt kuulnud, kui palju kurja see mees on teinud sinu pühadele Jeruusalemmas. ");
INSERT INTO ekk_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ja nüüd on ta siin ülempreestri volitusel aheldamas kõiki, kes sinu nime appi hüüavad!“ ");
INSERT INTO ekk_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Aga Issand vastas Ananiasele: „Mine! See mees on minu valitud tööriist, et kanda minu nimi rahvaste ja kuningate ja Iisraeli rahva ette. ");
INSERT INTO ekk_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Sest mina tahan talle näidata, kui palju ta peab kannatama minu nime pärast!“ ");
INSERT INTO ekk_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Siis Ananias läks sinna majja. Ja kui ta oma käed oli Sauluse peale pannud, ütles ta: „Vend Saul, Issand Jeesus on mind läkitanud, tema, kes sulle ilmus tee peal, et sa jälle näeksid ja saaksid täis Püha Vaimu.“ ");
INSERT INTO ekk_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Otsekohe langes Sauluse silmadelt justkui soomuseid ja ta nägi jälle. Ta tõusis püsti ja laskis ennast ristida, ");
INSERT INTO ekk_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ja pärast kehakinnitust tema jõud taastus. Saulus veetis mitu päeva Damaskuses jüngritega. ");
INSERT INTO ekk_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ja otsekohe hakkas ta sünagoogides kuulutama Kristusest, et tema on Jumala Poeg. ");
INSERT INTO ekk_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Aga kõik, kes teda kuulsid, ehmusid ning küsisid: „Eks tema ole seesama, kes Jeruusalemmas hävitas selle nime appihüüdjaid? Ja kes on siia tulnud selleks, et neid viia kinniseotuna ülempreestrite juurde?“ ");
INSERT INTO ekk_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ometi muutus Saulus üha võimsamaks ja ajas segadusse Damaskuses elavad juudid ning tõestas, et Jeesus on Messias. ");
INSERT INTO ekk_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ja kui hulk päevi oli möödunud, kavatsesid juudid ta tappa. ");
INSERT INTO ekk_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Aga Saulus sai nende plaanist teada. Nad panid päevaks ja ööks isegi linnaväravate juurde valvurid, et teda tappa. ");
INSERT INTO ekk_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kuid ühel ööl lasksid jüngrid ta korvi sees müüriava kaudu alla. ");
INSERT INTO ekk_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kui ta jõudis Jeruusalemma, püüdis Saulus jüngritega liituda, kuid kõik kartsid teda ega uskunud, et ta on jünger. ");
INSERT INTO ekk_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Aga Barnabas võttis Sauluse, viis ta ja apostlite juurde ja rääkis neile, kuidas Saulus teel olles oli kohanud Issandat ja temaga kõnelnud ja kuidas ta oli Damaskuses kartmatult Jeesuse nimel kuulutanud. ");
INSERT INTO ekk_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nii jäi Saulus nende juurde ja liikus vabalt Jeruusalemmas, kuulutades julgelt Issanda Jeesuse nimel. ");
INSERT INTO ekk_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ta rääkis ja vaidles ka Kreeka päritolu juutidega, aga need püüdsid teda tappa. ");
INSERT INTO ekk_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ent kui usklikud sellest teada said, viisid nad ta alla Kaisareasse ja läkitasid Tarsosesse. ");
INSERT INTO ekk_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Nüüd oli kogudusel rahu kogu Juudamaal, Galileas ja Samaarias, see kasvas ja edenes Issanda kartuses ning Püha Vaimu julgustusel. ");
INSERT INTO ekk_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peetrus käis läbi kogu maa ja läks ka Lüddas elavate pühade juurde. ");
INSERT INTO ekk_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Seal leidis ta mehe nimega Aineas, kes oli olnud halvatuna voodis maas kaheksa aastat. ");
INSERT INTO ekk_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","„Aineas,“ ütles Peetrus talle, „Jeesus Kristus teeb su terveks: tõuse ja sea oma ase korda!“ Ja Aineas tõusis sedamaid. ");
INSERT INTO ekk_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kõik Lüdda ja Saaroni elanikud nägid teda ja pöördusid Issanda poole. ");
INSERT INTO ekk_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Aga Joppes oli naisjünger nimega Tabiita (mis tõlkes tähendab Dorkas); ta tegi palju head ja aitas vaeseid. ");
INSERT INTO ekk_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ja neil päevil sündis, et ta jäi haigeks ja suri. Tema ihu pesti ja pandi ülemisse tuppa. ");
INSERT INTO ekk_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Aga Lüdda oli Joppe lähedal. Kui jüngrid kuulsid, et Peetrus on seal, läkitasid nad kaks meest tema juurde palvega: „Tule otsekohe!“ ");
INSERT INTO ekk_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Peetrus tõusis ja läks nendega. Joppesse jõudes juhatati ta ülemisse tuppa. Koguduse lesknaised tulid tema juurde, nutsid ja näitasid talle alussärke ja ülerõivaid, mis Dorkas nendega olles oli teinud. ");
INSERT INTO ekk_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Aga Peetrus saatis nad kõik toast välja, laskus põlvili ja palvetas. Ta pöördus surnukeha poole ja ütles: „Tabiita, tõuse üles!“ Tema avas oma silmad ja tõusis Peetrust nähes istuma. ");
INSERT INTO ekk_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peetrus võttis tal käest ja aitas ta jalule. Ta kutsus pühad ja lesknaised ning näitas teda neile elavana. ");
INSERT INTO ekk_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","See sai teatavaks kogu Joppes ja paljud uskusid Issandasse. ");
INSERT INTO ekk_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ja Peetrus jäi mõneks ajaks Joppesse nahkur Siimoni juurde. ");
INSERT INTO ekk_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kaisareas elas üks mees nimega Korneelius, kes oli sadakonna ülem Itaalia rügemendis. ");
INSERT INTO ekk_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tema ja kogu ta perekond olid vagad ja jumalakartlikud. Ta jagas abivajajatele heldelt ande ja palus järjekindlalt Jumalat. ");
INSERT INTO ekk_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kui ta ühel päeval umbes üheksandal tunnil palvetas, sai ta selge nägemuse. Ta nägi, et tema juurde tuli Jumala ingel ja ütles: „Korneelius!“ ");
INSERT INTO ekk_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Korneelius vaatas teda hirmunult ja küsis: „Mis on, isand?“ Ingel vastas: „Sinu palved ja annetused vaestele on tõusnud Jumala ette sind meelde tuletama. ");
INSERT INTO ekk_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Läkita nüüd mehed Joppesse, et tuua siia mees nimega Siimon, keda kutsutakse Peetruseks. ");
INSERT INTO ekk_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ta peatub nahkur Siimoni juures, kelle maja on mere ääres. Tema räägib sulle, mida sul on vaja teha.“ ");
INSERT INTO ekk_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kui temaga rääkinud ingel oli lahkunud, kutsus Korneelius kaks teenrit ja ühe ustava sõduri nende hulgast, kes alati ta juures olid. ");
INSERT INTO ekk_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ta jutustas neile kõigest ning läkitas nad Joppesse. ");
INSERT INTO ekk_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Aga järgmisel päeval umbes kuuendal tunnil, kui nad teed käies lähenesid linnale, läks Peetrus katusele palvetama. ");
INSERT INTO ekk_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Talle tuli nälg ja ta tahtis süüa. Aga samal ajal kui talle toitu valmistati, läks ta otsekui enesest ära. ");
INSERT INTO ekk_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ta nägi taeva olevat avatud ja sealt laskus alla anum, nagu suur palverätik, mida neljast nurgast seotuna alla maa peale lasti. ");
INSERT INTO ekk_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Selle sees oli igasuguseid ilmamaa neljajalgseid ja roomajaid ja taeva linde. ");
INSERT INTO ekk_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ja talle ütles hääl: „Tõuse, Peetrus! Ohverda ja söö!“ ");
INSERT INTO ekk_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","„Kindlasti mitte, Issand!“ vastas Peetrus, „Ma ei ole kunagi söönud midagi keelatut või roojast!“ ");
INSERT INTO ekk_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Hääl ütles talle teist korda: „Mida Jumal on puhtaks kuulutanud, seda sina ära pea roojaseks!“ ");
INSERT INTO ekk_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","See sündis kolm korda, ja kohe võeti anum tagasi taevasse. ");
INSERT INTO ekk_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Samal ajal kui Peetrus juurdles nägemuse tähenduse üle, olid Korneeliuse läkitatud mehed juba Siimoni maja üles otsinud ja seisid all värava taga. ");
INSERT INTO ekk_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nad hüüdsid ning küsisid, kas Siimon, kes on tuntud kui Peetrus, peatub seal. ");
INSERT INTO ekk_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peetrus alles mõtles nägemuse üle, kui Vaim ütles talle: „Vaata, Siimon, kolm meest küsivad sinu järele. ");
INSERT INTO ekk_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tõuse üles ja mine alla! Ära kõhkle nendega kaasa minemast, sest mina olen nad saatnud!“ ");
INSERT INTO ekk_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Peetrus läks alla meeste juurde ja ütles: „Mina olen see, keda te otsite. Mis asja pärast te olete tulnud?“ ");
INSERT INTO ekk_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Mehed vastasid: „Me oleme tulnud sadakonna ülema Korneeliuse juurest. Ta on õiglane ja jumalakartlik mees, keda kõik juudid austavad. Tema sai pühalt inglilt käsu sind oma majja kutsuda ja kuulata sinu sõnu.“ ");
INSERT INTO ekk_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Siis Peetrus kutsus mehed sisse oma külalisteks. Järgmisel päeval asus Peetrus nendega teele ja mõned Joppe usklikud ühes temaga. ");
INSERT INTO ekk_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Järgmisel päeval saabusid nad Kaisareasse. Korneelius ootas neid juba. Ta oli sugulased ja lähedased sõbrad kokku kutsunud. ");
INSERT INTO ekk_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kui Peetrus sisse astus, läks Korneelius talle vastu ja kummardus ta jalge ette maha. ");
INSERT INTO ekk_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Aga Peetrus palus tal püsti tõusta ja ütles: „Tõuse üles, ka mina olen vaid inimene!“ ");
INSERT INTO ekk_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ja temaga vesteldes astus Peetrus sisse ja leidis eest suure hulga inimesi. ");
INSERT INTO ekk_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ta ütles neile: „Te kindlasti teate, et juudi jaoks on seadusevastane käia läbi võõramaalasega või minna talle külla. Aga Jumal on mulle näidanud, et ühtegi inimest ei tohi pidada halvaks ega roojaseks. ");
INSERT INTO ekk_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Sellepärast olen ma ka igasuguse vastupanuta tulnud, kui mind kutsuti. Nüüd ma küsin, mis põhjusel te olete mind kutsunud.“ ");
INSERT INTO ekk_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korneelius vastas: „Neli päeva tagasi ma olin üheksandal tunnil oma majas palvetamas. Järsku seisis minu ees üks mees säravas rõivas ");
INSERT INTO ekk_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ning ütles: „Korneelius, sinu palvet on kuuldud ja su annid on Jumalale meelde tulnud. ");
INSERT INTO ekk_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Läkita nüüd mehed Joppesse Siimoni järele, keda kutsutakse Peetruseks. Tema on võõrsil nahkur Siimoni kojas mere ääres. Kui ta siia jõuab, räägib ta sinuga.“ ");
INSERT INTO ekk_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nõnda ma saatsin otsekohe sinu järele ja on hea, et sa tulid. Nüüd me oleme siin üheskoos Jumala ees kuulamas kõike, mis Issand sind on käskinud!“ ");
INSERT INTO ekk_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Siis Peetrus hakkas rääkima: „Tõepoolest, nüüd ma mõistan, et Jumal ei eelista kedagi, ");
INSERT INTO ekk_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","vaid võtab kõigi rahvaste hulgast vastu selle, kes teda kardab ja teeb õigust. ");
INSERT INTO ekk_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","See on sõna, mille Jumal on läkitanud Iisraeli rahvale, kuulutades evangeeliumi rahust Jeesuse Kristuse kaudu, kes on kõikide Issand. ");
INSERT INTO ekk_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Te teate seda, mis on sündinud tervel Juudamaal, alates Galileast pärast ristimist, mida Johannes kuulutas, ");
INSERT INTO ekk_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","kuidas Jumal Naatsareti Jeesuse võidis Püha Vaimu ja väega ning kuidas tema käis mööda maad head tehes ja tervendades kõiki kuradi rõhutuid, sest Jumal oli temaga. ");
INSERT INTO ekk_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Meie oleme kõige selle tunnistajad, mis ta on teinud Juudamaal ja Jeruusalemmas. Nad tapsid tema ristile riputades. ");
INSERT INTO ekk_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Sellesama on Jumal kolmandal päeval üles äratanud surnuist ja lasknud tal saada avalikuks. ");
INSERT INTO ekk_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mitte kõigele rahvale, vaid Jumala ettemääratud tunnistajaile, meile, kes me oleme temaga koos söönud ja joonud pärast seda, kui ta oli üles tõusnud surnuist. ");
INSERT INTO ekk_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ja tema on käskinud meid rahvale kuulutada ja tunnistada, et tema on Jumala poolt määratud elavate ja surnute kohtumõistja. ");
INSERT INTO ekk_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Temast tunnistavad kõik prohvetid, et igaüks, kes temasse usub, saab tema nime läbi pattude andeksandmise!“ ");
INSERT INTO ekk_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Kui Peetrus alles neid sõnu rääkis, langes Püha Vaim kõikide peale, kes seda sõnumit kuulsid. ");
INSERT INTO ekk_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ja kõik need ümber lõigatud usklikud, kes olid Peetrusega kaasa tulnud, jahmusid sellest, et Püha Vaimu and valati välja ka teiste rahvaste peale. ");
INSERT INTO ekk_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Sest nad kuulsid neid võõraid keeli rääkimas ja Jumalat ülistamas. Siis Peetrus ütles: ");
INSERT INTO ekk_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","„Kas keegi võib vett keelata, et ei ristitaks neid, kes on saanud Püha Vaimu täpselt nagu meie?“ ");
INSERT INTO ekk_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ja ta käskis neid ristida Jeesuse Kristuse nimesse. Siis nad palusid Peetrust jääda veel mõneks päevaks nende juurde. ");
INSERT INTO ekk_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Juudamaal elavad apostlid ja usklikud kuulsid, et ka teised rahvad olid Jumala sõna vastu võtnud. ");
INSERT INTO ekk_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ja kui Peetrus tuli üles Jeruusalemma, riidlesid ümberlõigatud usklikud temaga: ");
INSERT INTO ekk_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","„Sina oled läinud ümberlõikamata meeste juurde ja söönud koos nendega!“ ");
INSERT INTO ekk_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Siis Peetrus parandas nende arusaama ja seletas neile asja algusest peale: ");
INSERT INTO ekk_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","„Mina olin Joppe linnas palvetamas ja nägin otsekui enesest ära olles nägemust: seal laskus alla anum, nagu suur palverätik, mida nelja nurka pidi lasti alla taevast, ja see tuli otse minu juurde. ");
INSERT INTO ekk_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ja kui ma seda tähelepanelikult vaatasin, nägin ma ilmamaa neljajalgseid loomi, metsloomi, roomajaid ja taeva linde. ");
INSERT INTO ekk_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ja ma kuulsin ka häält mulle ütlemas: „Tõuse, Peetrus! Ohverda ja söö!“ ");
INSERT INTO ekk_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Aga mina ütlesin: „Kindlasti mitte, Issand! Sest ma pole kunagi suu sisse võtnud midagi keelatut või roojast!“ ");
INSERT INTO ekk_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Siis vastas mulle teist korda hääl taevast: „Mida Jumal on puhtaks kuulutanud, seda sina ära pea roojaseks!“ ");
INSERT INTO ekk_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","See sündis kolm korda, ja kõik tõmmati jälle taevasse. ");
INSERT INTO ekk_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ja vaata, samal hetkel seisid maja ees need kolm meest, kes olid Kaisareast läkitatud minu juurde. ");
INSERT INTO ekk_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Vaim ütles mulle, et ma läheksin nendega kaasa kõhklemata. Minuga tulid ka need kuus venda ja me läksime selle mehe majja. ");
INSERT INTO ekk_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ja ta jutustas meile, kuidas ta oli näinud inglit oma majas seismas ja ütlemas: „Läkita neli inimest Joppesse Siimoni järele, keda kutsutakse Peetruseks. ");
INSERT INTO ekk_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ta toob sulle sõnumi, mille läbi sina ja kogu su pere saate päästetud.“ ");
INSERT INTO ekk_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nii kui ma hakkasin rääkima, langes Püha Vaim nende peale nii nagu meiegi peale alguses. ");
INSERT INTO ekk_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Siis meenus mulle Issanda sõna, kuidas ta ütles: „Johannes ristis küll veega, aga teid ristitakse Püha Vaimuga.“ ");
INSERT INTO ekk_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kui nüüd Jumal on andnud neile sama anni kui meilegi, kes me usume Issandasse Jeesusesse Kristusesse, kes olen siis mina, et Jumalat keelata?“ ");
INSERT INTO ekk_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Seda kuuldes polnud neil enam vastuväiteid ja andsid Jumalale au, öeldes: „Siis on Jumal ka teistele rahvastele andnud meeleparanduse eluks!“ ");
INSERT INTO ekk_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Need, kes olid Stefanose pärast tekkinud tagakiusu ajal laiali pillutatud, käisid mööda maad Foiniikiani, Küprose saareni ja Antiookiani, kuulutades sõna ainult juutidele. ");
INSERT INTO ekk_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Nende hulgas oli ka Küprose ja Küreene mehi, need rääkisid pärast Antiookiasse jõudmist ka kreeklastele, kuulutades neile evangeeliumi Issandast Jeesusest. ");
INSERT INTO ekk_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Issanda käsi oli nendega ning suur hulk uskus ja pöördus Issanda poole. ");
INSERT INTO ekk_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Aga jutt nendest jõudis Jeruusalemma koguduse kõrvu ja nad läkitasid Barnabase Antiookiasse. ");
INSERT INTO ekk_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Kui ta sinna jõudis ja Jumala armu nägi, sai ta rõõmsaks ja julgustas kõiki jääma oma südameis Issandale ustavaks. ");
INSERT INTO ekk_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ta oli hea mees, täis Püha Vaimu ja usku. Ja palju inimesi toodi Issanda juurde. ");
INSERT INTO ekk_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Siis läks Barnabas Tarsosesse Saulust otsima, ");
INSERT INTO ekk_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ja kui ta leidis tema, tõi ta Antiookiasse. Ja nad käisid terve aasta koos koguduses ja õpetasid suurt hulka rahvast. Ja Antiookias hakati jüngreid esimest korda nimetama kristlasteks. ");
INSERT INTO ekk_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Neil päevil tuli prohveteid Jeruusalemmast alla Antiookiasse. ");
INSERT INTO ekk_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Üks neist, Agabos nimi, tõusis püsti ja andis Vaimu läbi teada, et suur nälg on tulemas üle Rooma valduste. (Nõnda ka sündis keiser Klaudiuse valitsemise ajal.) ");
INSERT INTO ekk_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Siis iga jünger otsustas saata Juudamaal elavatele vendadele abi vastavalt oma võimalustele. ");
INSERT INTO ekk_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Seda nad tegidki, läkitades annetused Barnabase ja Sauluse kaudu koguduste vanematele. ");
INSERT INTO ekk_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Aga sel ajal pistis kuningas Heroodes käe mõnede külge kogudusest, et neile kurja teha. ");
INSERT INTO ekk_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ta tappis mõõgaga Jaakobuse, Johannese venna. ");
INSERT INTO ekk_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kui ta nägi, et see juutidele meeldis, mõtles ta kinni võtta ka Peetruse. See oli hapnemata leibade pühal. ");
INSERT INTO ekk_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Heroodes vahistas Peetruse ja heitis ta vangi, andes ta nelja neljamehelise sõdurite salga valvata. Heroodes kavatses ta pärast paasapühi kohtumõistmiseks rahva ette tuua. ");
INSERT INTO ekk_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nõnda siis oli Peetrus vangis, aga kogudus palvetas tuliselt Jumala poole tema pärast. ");
INSERT INTO ekk_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ööl enne seda, kui Heroodes tahtis ta kohtu ette tuua, magas Peetrus kahe sõduri vahel kahe ketiga aheldatult, ja tunnimehed valvasid sissepääsu juures. ");
INSERT INTO ekk_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ja vaata, järsku ilmus Issanda ingel ja valgus säras vangikongis. Ingel lõi Peetrust vastu külge ja äratas ta üles. „Ruttu, tõuse üles!“ ütles ta ja ahelad langesid Peetruse randmetelt. ");
INSERT INTO ekk_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Siis ingel ütles talle: „Pane riided selga ja sandaalid jalga.“ Ja Peetrus tegi nii. „Pane kuub endale ümber ja järgne mulle,“ ütles ingel. ");
INSERT INTO ekk_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Peetrus tuli tema järel vanglast välja ega teadnud, et see, mis ingel tegi, päriselt sündis; ta mõtles, et ta nägi nägemust. ");
INSERT INTO ekk_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nad möödusid esimesest ja teisest valvepostist ja jõudsid linna viiva raudvärava juurde. See avanes neile iseenesest ja nad väljusid. Kui nad olid kõndinud ühe tänavapikkuse, jättis ingel ta järsku maha. ");
INSERT INTO ekk_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Siis Peetrus tuli enesesse tagasi ja ütles: „Nüüd ma tean ilma igasuguse kahtluseta, et Issand on läkitanud oma ingli ja on mind päästnud Heroodese käest ja kõigest, mida juudi rahvas ootas.“ ");
INSERT INTO ekk_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ja märgates, kus ta on, tuli ta Maarja maja juurde, kes on Markuseks hüütava Johannese ema. Sinna oli palju inimesi kogunenud palvetama. ");
INSERT INTO ekk_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peetrus koputas väravale ja teenijatüdruk nimega Roode tuli sinna kuulatama. ");
INSERT INTO ekk_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kui ta Peetruse hääle ära tundis, oli ta nii rõõmus, et jooksis tagasi ust avamata ja hüüdis: „Peetrus on värava juures!“ ");
INSERT INTO ekk_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","„Sa oled arust ära,“ ütlesid nad talle. Aga kui ta kinnitas, et see on nõnda, ütlesid nad: „See on tema ingel!“ ");
INSERT INTO ekk_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Aga Peetrus koputas edasi. Kui nad ukse avasid, nägid nad teda ja jahmusid. ");
INSERT INTO ekk_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Peetrus aga viipas käega, et nad vait oleksid, ja jutustas neile, kuidas Issand oli ta vanglast välja toonud. „Rääkige sellest Jaakobusele ja vendadele!“ ütles ta ja läks sealt ära teise kohta. ");
INSERT INTO ekk_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Aga hommikul oli suur segadus sõdurite hulgas, kui nad püüdsid aru saada, mis Peetrusega oli juhtunud. ");
INSERT INTO ekk_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ja kui Heroodes laskis paiga põhjalikult läbi otsida ja teda ei leidnud, kuulas ta vangivalvurid üle ja käskis nad hukata. Siis läks Heroodes Juudamaalt Kaisareasse ja jäi sinna mõneks ajaks. ");
INSERT INTO ekk_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ent Heroodes kandis viha Tüürose ja Siidoni rahva peale. Need tulid ühel meelel tema juurde ja, saanud kuninga kambriülema Blastose poolehoiu, palusid rahu; sest nad said oma toidu kuninga aladelt. ");
INSERT INTO ekk_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Määratud päeval istus Heroodes kuninglikku rüüd kandes oma troonil ja pidas rahvale kõne. ");
INSERT INTO ekk_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Rahvas hüüdis: „See ei ole inimese, vaid jumala hääl!“ ");
INSERT INTO ekk_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Aga otsekohe lõi teda Issanda ingel, sest et ta ei andnud au Jumalale. Ja ussidest sööduna ta suri. ");
INSERT INTO ekk_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Aga Jumala sõna kasvas ja levis. ");
INSERT INTO ekk_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ja Barnabas ja Saulus tulid tagasi Jeruusalemmast, kui nad olid täitnud oma ülesande, ning võtsid enestega ühes ka Johannese, keda hüüti Markuseks. ");
INSERT INTO ekk_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Aga Antiookias olevas koguduses oli prohveteid ja õpetajaid: Barnabas, Siimeon, keda kutsuti Nigeriks, Luukius Küreenest, Manaeen (kes oli kasvanud üles koos nelivürst Heroodesega) ja Saulus. ");
INSERT INTO ekk_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Kui nad olid parasjagu Issandat teenimas ja paastumas, ütles Püha Vaim: „Eraldage minule Barnabas ja Saulus tööle, milleks ma olen nad kutsunud!“ ");
INSERT INTO ekk_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Siis nad paastusid ja palvetasid, panid oma käed nende peale ning saatsid nad teele. ");
INSERT INTO ekk_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kui Püha Vaim oli nad teele läkitanud, tulid nad kahekesi Seleukeiasse ja purjetasid Küprosele. ");
INSERT INTO ekk_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ja kui nad jõudsid Salamisesse, kuulutasid nad Jumala sõna juudi sünagoogides. Neil oli ka Johannes abiliseks. ");
INSERT INTO ekk_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nad käisid läbi terve saare Pafosest saadik. Seal kohtasid nad juudi nõida ja valeprohvetit, Barjeesus nimi, ");
INSERT INTO ekk_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","kes oli prokonsul Sergius Pauluse saatja. Prokonsul, terane mees, kutsus Barnabase ja Sauluse enese juurde, sest ta soovis kuulata Jumala sõna. ");
INSERT INTO ekk_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Aga nõid Elümas (sest seda tema nimi tähendab) oli nende vastu ja püüdis prokonsulit usust kõrvale kallutada. ");
INSERT INTO ekk_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Aga Saulus, keda hüütakse ka Pauluseks, täis Püha Vaimu, vaatas teravalt Elümase peale ja ütles: ");
INSERT INTO ekk_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","„Sa oled kuradi poeg ja kõige õiguse vaenlane! Sa oled täis valet ja kõiksugu trikke. Kas sa kunagi ei lakka Issanda sirgeid teid väänamast? ");
INSERT INTO ekk_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ja nüüd, vaata, Issanda käsi tuleb sinu peale. Sa jääd pimedaks ega näe päikest tükil ajal!“ Otsekohe langes tema peale udu ja pimedus, ja ta kobas enda ümber, otsides talutajaid. ");
INSERT INTO ekk_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kui prokonsul nägi, mis juhtus, uskus ta ja oli hämmastunud Issanda õpetusest. ");
INSERT INTO ekk_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulus ja tema kaaslased purjetasid edasi Pafosest Pergesse Pamfüülias, kus Johannes lahkus neist ja pöördus tagasi Jeruusalemma. ");
INSERT INTO ekk_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Aga nemad läksid Pergest edasi Pisiidia Antiookiasse. Hingamispäeval nad läksid sünagoogi ja istusid maha. ");
INSERT INTO ekk_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Pärast Seaduse ja Prohvetite ettelugemist saatsid sünagoogi juhid neile sõna: „Mehed-vennad, kui teil on julgustav sõnum rahva jaoks, siis öelge!“ ");
INSERT INTO ekk_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Siis tõusis Paulus püsti, viipas käega ja ütles: „Iisraeli mehed ja teie, kes te kardate Jumalat, kuulge! ");
INSERT INTO ekk_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Iisraeli rahva Jumal valis meie isad ja tõstis üles selle rahva, kui nad Egiptuses elasid, ja tõi nad sealt välja kõrgele tõstetud käsivarrega; ");
INSERT INTO ekk_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ja neljakümne aasta jooksul ta talus nende käitumist kõrbes; ");
INSERT INTO ekk_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ja ta hävitas seitse rahvast Kaananimaal ja andis nende maa oma rahvale pärandiks. ");
INSERT INTO ekk_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kõik see võttis umbes nelisada viiskümmend aastat. Ja pärast seda andis Jumal neile kohtumõistjaid prohvet Saamueli ajani. ");
INSERT INTO ekk_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ja seejärel nad palusid endale kuningat, ja Jumal andis neile neljakümneks aastaks Sauli, Kishi poja Benjamini suguvõsast. ");
INSERT INTO ekk_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pärast Sauli eemaldamist tõstis ta neile kuningaks Taaveti. Tema kohta ta tunnistas: „Ma olen leidnud Taaveti, Iisai poja, minu südame järgi mehe, kes teeb kõik mu tahtmist mööda.“ ");
INSERT INTO ekk_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Sellesama mehe järeltulijate hulgast on Jumal oma tõotust mööda tõstnud Jeesuse Iisraelile Päästjaks. ");
INSERT INTO ekk_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Enne Jeesuse tulekut kuulutas Johannes meeleparanduse ristimist kogu Iisraeli rahvale. ");
INSERT INTO ekk_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kui Johannes oli oma tööd lõpetamas, ütles ta: „Mina ei ole see, kelle teie arvate minu olevat. Pärast mind tuleb tema, kelle sandaale ei ole mina väärt lahti siduma.“ ");
INSERT INTO ekk_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Mehed-vennad, Aabrahami soo lapsed, ja need teie hulgas, kes Jumalat kardavad: meile on läkitatud see päästesõna. ");
INSERT INTO ekk_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Sest Jeruusalemma elanikud ja nende ülemad ei tundnud teda ära, ja saatsid nõnda oma kohtuotsusega täide prohvetite ütlused, mida igal hingamispäeval loetakse. ");
INSERT INTO ekk_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ja ühtegi surmasüüd leidmata palusid nad Pilaatust, et ta hukataks. ");
INSERT INTO ekk_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ja kui nad olid täide saatnud kõik, mis temast oli kirjutatud, võtsid nad ta ristipuult maha ja panid hauda. ");
INSERT INTO ekk_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Jumal aga äratas ta surnuist üles. ");
INSERT INTO ekk_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ja tema ilmus palju päevi neile, kes temaga olid tulnud Galileast üles Jeruusalemma. Needsamad on nüüd tema tunnistajad rahva ees. ");
INSERT INTO ekk_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ja meie kuulutame teile rõõmusõnumit isadele antud tõotusest, ");
INSERT INTO ekk_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","et Jumal Jeesust üles äratades on täielikult täitnud tõotuse nende lastele, meile – nagu ka teises laulus on kirjutatud: „Sina oled minu Poeg, täna ma sünnitasin sinu.“ ");
INSERT INTO ekk_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Et Jumal tema on surnuist üles äratanud, nii et tal iialgi ei ole tarvis kõduneda, sellest on ta öelnud nõnda: „Mina täidan teile need Taavetile antud pühad ja kindlad tõotused!“ ");
INSERT INTO ekk_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Sellepärast ta ütleb ka teises paigas: „Sina ei lase oma Pühal näha kõdunemist!“ ");
INSERT INTO ekk_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Kui Taavet oli täitnud oma sugupõlve ajal Jumala eesmärgi, uinus ta magama ja maeti oma esivanemate juurde ning ta ihu kõdunes. ");
INSERT INTO ekk_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Aga see, kelle Jumal on üles äratanud, ei kõdunenud. ");
INSERT INTO ekk_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Seepärast, mehed-vennad, olgu teile teada, et tema kaudu kuulutatakse teile teie pattude andeksandmist, ");
INSERT INTO ekk_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ja et igaüks, kes usub, mõistetakse õigeks tema sees kõigest sellest, millest te ei võinud õigeks saada Moosese käsuõpetuse kaudu. ");
INSERT INTO ekk_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Vaadake siis, et teile ei juhtuks, mis on öeldud prohvetite kirjades: ");
INSERT INTO ekk_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","„Vaadake, te põlastajad, ja imestage ja hävige. Sest ma teen ühe teo teie päevil, teo, mida te ei usuks, kui keegi seda teile jutustaks.“ “ ");
INSERT INTO ekk_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Aga kui juudid olid sünagoogist lahkumas, paluti apostleid ka järgmisel hingamispäeval neid asju rääkima. ");
INSERT INTO ekk_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kui kogudus sünagoogist lahkus, järgis palju juute ja juudiusku pöördunud jumalakartlikke Paulust ja Barnabast, kes nendega kõnelesid ja kutsusid neid jääma Jumala armusse. ");
INSERT INTO ekk_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Järgmisel hingamispäeval kogunes peaaegu kogu linn Issanda sõna kuulama. ");
INSERT INTO ekk_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Rahvahulki nähes muutusid juudid väga kadedaks ja vaidlesid pilgates vastu Pauluse sõnadele. ");
INSERT INTO ekk_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Paulus ja Barnabas aga vastasid neile julgelt: „Meie pidime kõnelema Jumala sõna esmalt teile. Aga kuna teie lükkasite selle tagasi ega arva end igavest elu väärivat, siis me pöördume nüüd teiste rahvaste poole. ");
INSERT INTO ekk_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Sest nõnda on Issand meid käskinud: „Ma olen pannud sind rahvastele valguseks, et sa oleksid päästeks maailma otsani.“ “ ");
INSERT INTO ekk_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Seda kuuldes mittejuudid rõõmustasid ja ülistasid Issanda sõna ja said usklikuks, nii palju kui neid oli määratud igaveseks eluks. ");
INSERT INTO ekk_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ja Issanda sõna levis kogu piirkonnas. ");
INSERT INTO ekk_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Aga juudid ässitasid kõrgemast seisusest jumalakartlikke naisi ja linna tähtsaid mehi, õhutades neid taga kiusama Paulust ja Barnabast, ning ajasid nad välja oma piirkonnast. ");
INSERT INTO ekk_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nemad aga raputasid tolmu oma jalgadelt nende peale ja tulid Ikoonioni. ");
INSERT INTO ekk_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Aga jüngrid said täis rõõmu ja Püha Vaimu. ");
INSERT INTO ekk_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikoonionis läksid Paulus ja Barnabas nagu tavaliselt juudi sünagoogi. Nad kõnelesid seal nõnda, et suur hulk juute ja kreeklasi sai usklikuks. ");
INSERT INTO ekk_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Aga uskmatud juudid õhutasid üles ja ärritasid teiste rahvaste meeled vihale vendade vastu. ");
INSERT INTO ekk_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Nõnda jäid Paulus ja Barnabas sinna kauemaks, kuulutades julgesti Issandat, kes andis tunnistust oma armusõnale ja laskis sündida nende käte läbi tunnustähti ja imetegusid. ");
INSERT INTO ekk_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Aga linna elanikud jagunesid kaheks: mõned olid juutide, teised apostlite poolt. ");
INSERT INTO ekk_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Teised rahvad ja juudid tahtsid koos oma ülematega apostleid teotada ja nad kividega surnuks visata. ");
INSERT INTO ekk_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Aga nad said sellest teada ja põgenesid Lükaoonia linnadesse Lüstrasse ja Derbesse ja nende ümbruskonda, ");
INSERT INTO ekk_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","kus nad jätkasid evangeeliumi kuulutamist. ");
INSERT INTO ekk_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ja Lüstras istus maas üks mees, kes oli sünnist saati jalust halvatud ja polnud kunagi kõndinud. ");
INSERT INTO ekk_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ta kuulis Paulust kõnelemas. Kui Paulus talle otsa vaadates nägi, et tal oli usku terveks saada, ");
INSERT INTO ekk_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","hüüdis ta: „Tõuse püsti oma jalgadele!“ Ja mees hüppas kohe püsti ja kõndis. ");
INSERT INTO ekk_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kui rahvahulgad nägid, mis Paulus oli teinud, tõstsid nad häält Lükaoonia keeles: „Jumalad on inimeste kujul alla tulnud meie juurde!“ ");
INSERT INTO ekk_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnabast nad kutsusid Zeusiks ja Paulust Hermeseks, sest tema pidas kõnet. ");
INSERT INTO ekk_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ja linna ääres asuva Zeusi templi preester tõi pullid ja lillevanikud linnaväravate juurde, sest ta tahtis koos rahvaga neile ohvrit tuua. ");
INSERT INTO ekk_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Aga kui apostlid Barnabas ja Paulus seda kuulsid, käristasid nad oma rõivad katki ja tormasid rahva hulka, hüüdes: ");
INSERT INTO ekk_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","„Mehed, miks te seda teete? Meiegi oleme teiesugused inimesed. Me kuulutame teile evangeeliumi, et te neist kasututest asjadest pöörduksite elava Jumala poole, kes on teinud taeva ja maa ja mere ja kõik, mis on nende sees. ");
INSERT INTO ekk_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Varasematel aegadel on ta lasknud rahvastel oma teed minna. ");
INSERT INTO ekk_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ja ometi ei ole jätnud andmata tunnistust iseendast, näidates oma headust: ta on andnud teile vihma taevast ja saaki nende aastaaegadel, andnud teile külluslikult toitu ja täitnud teie südant rõõmuga.“ ");
INSERT INTO ekk_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Isegi nende sõnadega oli neil raske hoida tagasi rahvahulka, et see neile ei ohverdaks. ");
INSERT INTO ekk_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Siis Antiookiast ja Ikoonionist tulid mõned juudid ja võitsid rahvahulga enda poole. Nad loopisid Paulust kividega ning lohistasid ta linnast välja, pidades teda surnuks. ");
INSERT INTO ekk_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Aga kui jüngrid olid kogunenud tema ümber, tõusis Paulus üles ja läks tagasi linna. Järgmisel päeval lahkusid tema ja Barnabas Derbesse. ");
INSERT INTO ekk_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ja kui nad selles linnas olid evangeeliumi kuulutanud ja suur hulk oli jüngriteks saanud, pöördusid nad tagasi Lüstrasse, Ikoonioni ja Antiookiasse, ");
INSERT INTO ekk_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","kinnitades jüngrite hingi, julgustades neid jääma ususse. „Me peame sisenema Jumala Kuningriiki läbi paljude katsumuste,“ ütlesid nad. ");
INSERT INTO ekk_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ja kui Paulus ja Barnabas neile igas koguduses olid määranud vanemad, jätsid nad palvetades ja paastudes nemad Issanda hooleks, kellesse nad nüüd uskusid. ");
INSERT INTO ekk_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pärast Pisiidia läbimist jõudsid nad Pamfüüliasse, ");
INSERT INTO ekk_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ja kui nad Perges olid sõna kuulutanud, läksid nad Ataaliasse. ");
INSERT INTO ekk_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ataaliast nad purjetasid Antiookiasse, kus nad olid usaldatud Jumala armu alla töö jaoks, mille nad nüüd olid lõpetanud. ");
INSERT INTO ekk_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Sinna jõudes kogusid nad koguduse kokku ja andsid aru kõigest, mis Jumal oli nende läbi teinud, ja et ta rahvastele oli avanud usu ukse. ");
INSERT INTO ekk_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ja nad jäid sinna jüngritega kauemaks ajaks. ");
INSERT INTO ekk_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Mõned mehed tulid Juudamaalt alla Antiookiasse ja õpetasid vendi: „Kui te ei lase endid Moosese kombe kohaselt ümber lõigata, siis te ei saa päästetud.“ ");
INSERT INTO ekk_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Sellest tõusis tüli ning Paulusel ja Barnabasel oli nendega suur vaidlus. Siis määrati nii, et Paulus ja Barnabas lähevad koos mõne teise usklikuga Jeruusalemma selles asjas apostlite ja vanematega kohtuma. ");
INSERT INTO ekk_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kogudus saatis nad teele ja kui nad reisisid läbi Foiniikia ja Samaaria, jutustasid nad üksikasjalikult, kuidas mittejuudid olid pöördunud. See sõnum rõõmustas vendi väga. ");
INSERT INTO ekk_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ja kui nad Jeruusalemma saabusid, võtsid kogudus, apostlid ja vanemad nad südamlikult vastu, kellele nad andsid teada kõigest, mis Jumal oli nende läbi teinud. ");
INSERT INTO ekk_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Siis mõned variseride hulgast, kes olid saanud usklikuks, tõusid püsti ja ütlesid: „Neid tuleb ümber lõigata ja nõuda Moosese Seaduse pidamist.“ ");
INSERT INTO ekk_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Apostlid ja vanemad tulid kokku asja arutama. ");
INSERT INTO ekk_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pärast pikka vaidlust tõusis Peetrus püsti ja ütles: „Vennad, te teate, et mõni aeg tagasi tegi Jumal teie hulgas valiku, et minu suu läbi kuuleksid teised rahvad evangeeliumi sõna ja usuksid. ");
INSERT INTO ekk_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ja südametundja Jumal näitas, et ta on nad vastu võtnud, andes neile Püha Vaimu nagu meilegi. ");
INSERT INTO ekk_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ta ei ole teinud vahet meie ja nende vahel, sest ta puhastas usu läbi nende südamed. ");
INSERT INTO ekk_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mispärast te nüüd kiusate Jumalat, soovides panna jüngrite kaela iket, mida ei ole suutnud kanda ei meie isad ega meie? ");
INSERT INTO ekk_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ent meie usume, et me oleme Issanda Jeesuse armu läbi päästetud samal kombel nagu nemadki!“ ");
INSERT INTO ekk_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kogudus jäi vaikseks, kui nad kuulasid, kuidas Barnabas ja Paulus jutustasid imelistest tunnustähtedest ja imedest, mida Jumal oli teinud rahvaste hulgas nende läbi. ");
INSERT INTO ekk_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Kui nad olid jutu lõpetanud, võttis Jakoobus sõna: „Vennad, kuulake mind! ");
INSERT INTO ekk_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Siimon on meile selgitanud, kuidas Jumal esmalt võttis eesmärgiks valida oma nimele rahvast paganate hulgast. ");
INSERT INTO ekk_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Sellega lähevad kokku prohvetite sõnad, nagu on kirjutatud: ");
INSERT INTO ekk_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","„Pärast seda ma tulen tagasi ja ehitan üles Taaveti langenud telgi. Ja ehitan üles selle varemed ja taastan selle uuesti, ");
INSERT INTO ekk_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","et muudki inimesed otsiksid Issandat ja kõik rahvad, kelle üle on nimetatud minu nimi, ütleb Issand, kes teeb seda, ");
INSERT INTO ekk_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","mis on teada igavikust alates.“ ");
INSERT INTO ekk_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Seepärast otsustan mina, et me ei teeks seda raskeks neile, kes teiste rahvaste seast pöörduvad Jumala poole. ");
INSERT INTO ekk_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Vaid selle asemel kirjutaksime neile, et nad hoiduksid ebajumalate ohvrilihast, sugukõlvatusest, lämbunud loomade lihast ja verest. ");
INSERT INTO ekk_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Sest Moosest on ammustest aegadest alates kuulutatud igas linnas ning loetud igal hingamispäeval sünagoogides.“ ");
INSERT INTO ekk_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Siis apostlid ja vanemad ühes kogudusega otsustasid valida endi hulgast mõned mehed ja saata need Antiookiasse koos Barnabase ja Paulusega. Nad valisid Juudase (Barsabaseks kutsutu) ja Siilase, kaks meest, kes mõlemad olid juhid vendade hulgas. ");
INSERT INTO ekk_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Nendega nad saatsid järgmise kirja: Apostlid ja vanemad, teie vennad, Teiste rahvaste päritolu vendadele ja õdedele, kes elavad Antiookias, Süürias ja Kiliikias: Tervitused. ");
INSERT INTO ekk_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Me oleme kuulnud, et mõned meie hulgast on välja läinud ilma meie heakskiiduta ja oma kõnedega teid segadusse ajanud ja teie hinge rahutuks teinud. ");
INSERT INTO ekk_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nõnda me oleme otsustanud valida mõned mehed ja saata need teie juurde koos meie kallite sõprade Barnabase ja Paulusega, ");
INSERT INTO ekk_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","meestega, kes on pannud oma elu kaalule meie Issanda Jeesuse Kristuse nime pärast. ");
INSERT INTO ekk_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Seepärast me läkitasime Juudase ja Siilase kinnitama suusõnal seda, mida me kirjutame. ");
INSERT INTO ekk_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Sest Püha Vaim ja meie oleme arvanud heaks, et teid ei tohi koormata millegagi peale nende nõudmiste: ");
INSERT INTO ekk_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","te peate hoiduma ebajumalate ohvrilihast, verest, lämbunud loomade lihast ja sugukõlvatusest. Te teete hästi, kui te neist hoidute. Jumalaga! ");
INSERT INTO ekk_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Nii nad saadeti teele ja nad tulid alla Antiookiasse, kutsusid kokku koguduse ja andsid kirja üle. ");
INSERT INTO ekk_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Kui nad seda olid lugenud, said nad rõõmsaks selle julgustava sõnumi üle. ");
INSERT INTO ekk_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Juudas ja Siilas, kes ka ise olid prohvetid, julgustasid usklikke mitmete sõnadega ja kinnitasid neid. ");
INSERT INTO ekk_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Aga kui nad seal olid mõnda aega viibinud, saatsid usklikud nad rahu õnnistustega minema nende juurde, kes neid olid läkitanud. ");
INSERT INTO ekk_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ja see tundus hea, et Siilas jääb sinna. ");
INSERT INTO ekk_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Aga Paulus ja Barnabas jäid Antiookiasse, õpetades ja kuulutades Issanda sõna. ");
INSERT INTO ekk_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mõni aeg hiljem ütles Paulus Barnabasele: „Lähme jälle vaatama usklikke kõikides linnades, kus me oleme kuulutanud Issanda sõna, kuidas neil läheb.“ ");
INSERT INTO ekk_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas tahtis võtta kaasa ka Johannese, keda kutsutakse Markuseks, ");
INSERT INTO ekk_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","aga Paulus ei pidanud seda õigeks, sest ta oli neid Pamfüülias maha jätnud ega olnud ühes nendega läinud tööle. ");
INSERT INTO ekk_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Sellest tekkis äge vaidlus, nii et nad läksid lahku ning Barnabas võttis kaasa Markuse ja purjetas Küprosele. ");
INSERT INTO ekk_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulus valis aga Siilase ja läks teele, jättes usklikud Issanda armu hooleks. ");
INSERT INTO ekk_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ta käis läbi Süüria ja Kiliikia, kinnitades kogudusi. ");
INSERT INTO ekk_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulus saabus Derbesse ja seejärel Lüstrasse. Ja ennäe, seal elas jünger, Timoteos nimeks, uskliku juuditari poeg. Tema isa oli kreeklane. ");
INSERT INTO ekk_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tema kohta andsid Lüstra ja Ikoonioni usklikud hea tunnistuse. ");
INSERT INTO ekk_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulus soovis teda teekonnale kaasa võtta ja ta lõikas tema ümber kohalike juutide pärast, sest need kõik teadsid, et Timoteose isa oli kreeklane. ");
INSERT INTO ekk_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Kui nad käisid linnast linna, andsid nad kogudustele järgimiseks need korraldused, mis apostlid ja vanemad olid Jeruusalemmas otsustanud. ");
INSERT INTO ekk_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Sel viisil said kogudused tugevaks usus ja nende arv kasvas iga päevaga. ");
INSERT INTO ekk_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulus ja tema kaaslased käisid läbi Früügia ja Galaatia alade, sest Püha Vaim oli keelanud neil sõna kuulutada Aasia provintsides. ");
INSERT INTO ekk_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kui nad jõudsid Müüsia piiri äärde, püüdsid nad matkata Bitüüniasse, kuid Jumala Vaim keelas neid. ");
INSERT INTO ekk_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Nii tulid nad Müüsiast möödudes alla Troasesse. ");
INSERT INTO ekk_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Paulus nägi öösel nägemust Makedoonia mehest, kes seisis ja palus teda: „Tule Makedooniasse ja aita meid!“ ");
INSERT INTO ekk_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nii kui Paulus oli nägemust näinud, seadsime endid kohe Makedooniasse minekuks valmis, sest me mõistsime, et Jumal on meid kutsunud neile evangeeliumi kuulutama. ");
INSERT INTO ekk_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Me läksime Troases merele ja purjetasime otse Samotraakesse, ja järgmisel päeval Neapolisse. ");
INSERT INTO ekk_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Sealt läksime Filippisse, mis on Rooma asundus ja tähtis linn selles Makedoonia osas. Sinna linna me jäime mitmeks päevaks. ");
INSERT INTO ekk_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Hingamispäeval me läksime linnaväravast välja jõe äärde, kus me lootsime leida sobivat paika palvetamiseks. Me istusime maha ja hakkasime juttu rääkima sinna kokku tulnud naistega. ");
INSERT INTO ekk_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Üks neist oli Lüüdia, purpurkanga müüja Tüatiira linnast, kes armastas Jumalat. Issand avas tema südame, nii et ta pani tähele Pauluse sõnumit. ");
INSERT INTO ekk_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Aga kui Lüüdia ja ta pere olid ristitud, palus ta meil tulla tema koju. „Kui te peate mind Issandale ustavaks,“ ütles ta, „siis tulge ja peatuge minu majas!“ Ja ta käis meile peale. ");
INSERT INTO ekk_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Üks kord kohtasime palvepaika minnes orjatari, kellel oli lausuja vaim. Ta teenis oma isandatele suurt raha tuleviku ennustamisega. ");
INSERT INTO ekk_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","See tüdruk käis Pauluse ja meie kannul ja karjus: „Need mehed on kõigekõrgema Jumala sulased, kes kuulutavad teile, kuidas saada päästetud.“ ");
INSERT INTO ekk_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Seda tegi ta palju päevi. Lõpuks tüütas ta Pauluse nii ära, et too pööras ümber ja ütles vaimule: „Ma käsin sind Jeesuse Kristuse nimel: mine temast välja!“ Ja selsamal tunnil vaim lahkus temast. ");
INSERT INTO ekk_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kui nüüd orjatari isandad said aru, et nende lootus raha teenida on lõppenud, võtsid nad Pauluse ja Siilase kinni ja tirisid nad turuplatsile linnavõimude ette. ");
INSERT INTO ekk_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Nad viisid nad linnavanemate ette ja ütlesid: „Need mehed on juudid ja nad tekitavad meie linnas segadust, ");
INSERT INTO ekk_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","levitades kombeid, mida seadus ei luba meil kui roomlastel vastu võtta ega järgida.“ ");
INSERT INTO ekk_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ja rahvahulk ühines rünnakuga Pauluse ja Siilase vastu. Linnavanemad käskisid neid alasti võtta ja kaigastega peksta. ");
INSERT INTO ekk_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ja kui nad olid neid rängalt peksnud, heitsid nad apostlid vanglasse ja käskisid vangivalvurit neid hoolsalt valvata. ");
INSERT INTO ekk_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Saanud sellised ranged korraldused, heitis valvur nad sisemisse vangikongi ja pani nende jalad pakku. ");
INSERT INTO ekk_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Umbes südaöö paiku Paulus ja Siilas palvetasid ja laulsid ülistust Jumalale, ja teised vangid kuulasid neid. ");
INSERT INTO ekk_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ja järsku sündis nii suur maavärin, et vangla alusmüürid värisesid. Ja otsekohe avanesid kõik uksed ja kõikide ahelad purunesid. ");
INSERT INTO ekk_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kui nüüd vangivalvur üles ärkas ja nägi vanglauksi lahti olevat, võttis ta mõõga ja kavatses end tappa, arvates, et vangid on põgenenud. ");
INSERT INTO ekk_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Aga Paulus hüüdis: „Ära tee enesele kurja! Me oleme kõik siin!“ ");
INSERT INTO ekk_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Valvur lasi tuua tuld, tormas sisse ja langes värisedes Pauluse ja Siilase ette maha. ");
INSERT INTO ekk_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Siis juhatas ta nad välja ja küsis: „Isandad, mis ma pean tegema, et saada päästetud?“ ");
INSERT INTO ekk_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Nad ütlesid: „Usu Issandasse Jeesusesse, siis saad päästetud sina koos oma perega!“ ");
INSERT INTO ekk_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ja nad kuulutasid Issanda sõna temale ja kõigile, kes olid tema majas. ");
INSERT INTO ekk_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Vangivalvur võttis Pauluse ja Siilase selsamal öötunnil endaga kaasa ja pesi nende haavad. Siis ristiti tema, ta pere ja kõik ta kodakondsed. ");
INSERT INTO ekk_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ta tõi nad oma koju ja kattis neile laua. Ta oli väga rõõmus, et ta kogu perekonnaga oli hakanud uskuma Jumalasse. ");
INSERT INTO ekk_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Päeva saabudes läkitasid linnavanemad kohtuteenreid vangivalvurile ütlema: „Vabasta need mehed!“ ");
INSERT INTO ekk_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Vangivalvur teatas Paulusele: „Linnavanemad on käskinud sinu ja Siilase vabaks lasta! Te võite rahus minna!“ ");
INSERT INTO ekk_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Aga Paulus ütles neile: „Nad on meid avalikult peksnud ilma kohut mõistmata, kuigi me oleme Rooma kodanikud; nad on meid vangi heitnud ja tahavad nüüd meist salaja lahti saada? Ei! Las nad tulevad ja saadavad meid ise välja.“ ");
INSERT INTO ekk_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Kohtuteenrid kandsid sellest linnavanematele ette, ja kui need kuulsid, et Paulus ja Siilas on Rooma kodanikud, lõid nad kartma. ");
INSERT INTO ekk_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nad tulid ja palusid neilt vabandust, tõid nad vanglast välja ja palusid linnast lahkuda. ");
INSERT INTO ekk_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Siis tulid Paulus ja Siilas vanglast välja ja läksid Lüüdia juurde, kus nad kohtusid vendadega ja julgustasid neid. Siis nad lahkusid. ");
INSERT INTO ekk_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Kui nad olid läinud läbi Amfipolise ja Apolloonia, jõudsid nad Tessaloonikasse, kus oli juudi sünagoog. ");
INSERT INTO ekk_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ja Paulus läks, nagu tal kombeks oli, nende juurde sünagoogi, ja arutles nendega kolmel hingamispäeval Jumala sõna üle, ");
INSERT INTO ekk_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","selgitades ja tõestades, et Messias pidi kannatama ja surnuist üles tõusma. „See Jeesus, keda mina teile kuulutan, ongi Messias!“ ütles ta. ");
INSERT INTO ekk_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Mõned neist lasksid end veenda ja ühinesid Pauluse ja Siilasega, samuti ühines suur hulk jumalakartlikke kreeklasi ja rohkesti suursuguseid naisi. ");
INSERT INTO ekk_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Aga õpetuse vastu seisvad juudid said kadedaks, nad võtsid turuplatsilt kaasa mõningaid kurje mehi ja rahvahulki üles kihutades korraldasid linnas mässu. Nad ründasid Jaasoni maja, otsides Paulust ja Siilast, et neid välja rahva ette tuua. ");
INSERT INTO ekk_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Aga kui nad neid ei leidnud, vedasid nad Jaasoni ja mõned teised usklikud linna valitsejate ette ja karjusid: „Need mehed, kes kogu ilma on pea peale pööranud, on nüüd siia tulnud ");
INSERT INTO ekk_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ja Jaason on nad vastu võtnud. Nad rikuvad keisri korraldusi, rääkides ühest teisest kuningast, keda kutsutakse Jeesuseks!“ ");
INSERT INTO ekk_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Seda kuuldes rahvahulk ja linna valitsejad ärritusid, kuid ");
INSERT INTO ekk_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","saades Jaasonilt ja teistelt tagatise, lasksid neil minna. ");
INSERT INTO ekk_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Usklikud saatsid Pauluse ja Siilase öö saabudes Beroiasse. Sinna jõudes läksid nad juudi sünagoogi. ");
INSERT INTO ekk_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beroias olid inimesed mõistlikumad kui Tessaloonikas; nemad võtsid sõna vastu innukalt ja uurisid iga päev Pühakirjast, kas Paulus rääkis õigust. ");
INSERT INTO ekk_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Paljud juudid hakkasid uskuma, samuti rohkesti kõrgemast seisusest kreeka naisi ja mehi. ");
INSERT INTO ekk_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Aga kui Tessaloonika juudid said teada, et Paulus ka Beroias kuulutab Jumala sõna, tulid nad ka sinna rahvahulka üles kihutama. ");
INSERT INTO ekk_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Siis usklikud saatsid Pauluse otsekohe mere äärde, Siilas ja Timoteos jäid aga Beroiasse. ");
INSERT INTO ekk_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pauluse saatjad viisid ta Ateenani ja lahkusid pärast seda, kui nad olid saanud Siilase ja Timoteose jaoks juhtnöörid, et need võimalikult ruttu tuleksid Pauluse juurde. ");
INSERT INTO ekk_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Aga kui Paulus neid Ateenas ootas, siis ta ärritus vaimus, sest linn oli täis iidolite kujusid. ");
INSERT INTO ekk_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ta arutles nüüd sünagoogis juutide ja jumalakartlike kreeklastega ning turuplatsil iga päev nendega, kes juhtusid seal olema. ");
INSERT INTO ekk_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Aga mõned epikuurlaste ja stoikute mõttetargad vaidlesid temaga. Mõned küsisid: „Mida see lobasuu tahab öelda?“ Teised arvasid: „Tema näib kuulutavat võõraid jumalusi!“ Sest Paulus kuulutas neile evangeeliumi Jeesusest ja ülestõusmisest. ");
INSERT INTO ekk_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Nad võtsid ta kinni ja viisid Areopaagile ning ütlesid: „Kas me võime teada saada, mis uus õpetus see on, millest sa kõneled? ");
INSERT INTO ekk_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Sa tood meie kõrvu võõrastavaid mõtteid. Me tahame teada, mis asjad need on.“ ");
INSERT INTO ekk_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Kõik ateenlased ja seal elavad võõramaalased veetsid oma aega jutustades ja uudiseid kuulates.) ");
INSERT INTO ekk_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Aga Paulus seisis keset Areopaagi ning ütles: „Ateena mehed! Ma näen, et te olete väga jumalakartlikud. ");
INSERT INTO ekk_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kui ma käisin läbi teie linna ja vaatasin paiku, mida te kummardate, märkasin ka üht altarit kirjaga: Tundmatule jumalale. Keda teie nüüd tundmatuna kummardate, teda kuulutan mina teile. ");
INSERT INTO ekk_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Jumal, kes on teinud maailma ja kõik selle sees, kes taeva ja maa Issandana ei ela inimkätega tehtud pühakodades, ");
INSERT INTO ekk_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ega lase ennast inimkätega teenida, justkui tal oleks midagi vaja, sest tema ise annab kõikidele elu ja hingamise ja kõik. ");
INSERT INTO ekk_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Tema on teinud ühestainsast terve inimkonna kõige maa peale elama ning on neile seadnud ettemääratud ajad ja nende asukohtade piirid. ");
INSERT INTO ekk_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ja Jumal soovis, et inimesed teda otsiksid, et nad teda tunneksid ja leiaksid. Sest ta on meile kõigile väga lähedal. ");
INSERT INTO ekk_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Tema tõttu me elame ja liigume ja temas on meie olemine. Sest nagu mõned teie enda luuletajad on öelnud: „Meie oleme tema sugu.“ ");
INSERT INTO ekk_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kui me nüüd oleme Jumala sugu, ei tohiks me arvata, et jumalikkus on nagu kuld-, hõbe- ja kivikujutised, mille on loonud inimesed oma leidlikkuse ja oskusega. ");
INSERT INTO ekk_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Jumal on küll sellisest teadmatusest minevikus mööda vaadanud, kuid nüüd käsib ta kõigil inimestel kõigis paigus meelt parandada. ");
INSERT INTO ekk_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Sest ta on seadnud päeva, mil ta mõistab õiglaselt kohut kogu maailma üle mehe läbi, kelle ta on määranud, ja ta on andnud kõigile tõestuse sellega, et on tema üles äratanud surnuist.“ ");
INSERT INTO ekk_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kui need kuulsid surnute ülestõusmisest, hakkasid mõned neist irvitama, teised aga ütlesid: „Me tahame sind selles asjas kuulda uuesti!“ ");
INSERT INTO ekk_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Nõnda lahkus Paulus nende juurest. ");
INSERT INTO ekk_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ent mõned mehed ühinesid temaga ja said usklikuks; nende hulgas oli Areopaagi liige Dionüüsios, samuti üks naine nimega Damaris, ja mitmed teised. ");
INSERT INTO ekk_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pärast neid sündmusi lahkus Paulus Ateenast ja tuli Korintosesse. ");
INSERT INTO ekk_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Seal ta kohtus Akvilaga, Pontosest pärit juudiga, kes oli hiljuti tulnud Itaaliast oma naise Priskillaga, sest keiser Klaudius oli käskinud kõigil juutidel Roomast lahkuda. Nende juurde tuli Paulus, ");
INSERT INTO ekk_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ja kuna ta oli telgimeister nagu nemadki, jäi ta sinna ja töötas koos nendega. ");
INSERT INTO ekk_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Igal hingamispäeval Paulus väitles sünagoogis, püüdes veenda juute ja kreeklasi. ");
INSERT INTO ekk_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kui Siilas ja Timoteos Makedooniast sinna jõudsid, pühendus Paulus täielikult sõna kuulutamisele ja tunnistas juutidele, et Jeesus on Messias. ");
INSERT INTO ekk_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Aga kui juudid talle vastu olid ja hakkasid teda teotama, raputas ta tolmu oma rõivastelt ja ütles neile: „Teie veri tulgu teie eneste peale! Mina olen puhas! Nüüdsest lähen ma teiste rahvaste juurde.“ ");
INSERT INTO ekk_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Siis lahkus Paulus sünagoogist Titius Justuse juurde, kes oli jumalakartlik mees ja kelle maja asus sünagoogi kõrval. ");
INSERT INTO ekk_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Sünagoogi ülem Krispus hakkas uskuma Issandat kogu oma perega ja palju korintlasi hakkas Paulust kuulates uskuma ja nad ristiti. ");
INSERT INTO ekk_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ühel öösel Issand kõneles Paulusele nägemuses: „Ära karda, jätka kõnelemist ja ära ole vait! ");
INSERT INTO ekk_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Sest mina olen sinuga ja keegi ei ründa sind ega tee sulle kurja, sest mul on palju inimesi selles linnas.“ ");
INSERT INTO ekk_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Paulus jäi sinna pooleteiseks aastaks ja õpetas nende hulgas Jumala sõna. ");
INSERT INTO ekk_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Sel ajal kui Gallio oli Ahhaia prokonsul, tõusid juudid ühiselt Pauluse vastu ja viisid ta kohtu ette. ");
INSERT INTO ekk_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","„See mees,“ süüdistasid nad, „meelitab inimesi Jumalat kummardama Moosese seaduse vastaselt.“ ");
INSERT INTO ekk_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Aga kui Paulus avas suu vastamiseks, lausus Gallio meile: „Kui teie, juudid, esitaksite kaebuse mõne väärteo või raske kuriteo kohta, peaksin ma teid ära kuulama. ");
INSERT INTO ekk_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Aga kuna see hõlmab küsimusi sõnade ja nimedega teie endi seadustes, siis lahendage see asi omavahel. Neis asjus ei ole mina kohtumõistja.“ ");
INSERT INTO ekk_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ja ta ajas nad ära. ");
INSERT INTO ekk_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Nemad aga pöördusid sünagoogi ülema Soostenese vastu ja peksid teda Gallio ees, aga ta ei hoolinud sellest üldse. ");
INSERT INTO ekk_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulus jäi Korintosesse veel mõneks ajaks. Siis lahkus ta vendadest ja purjetas koos Priskilla ja Akvilaga Süüriasse. Enne purjetama minemist oli ta Kenkreas lasknud oma juuksed maha lõigata tõotuse pärast, mille ta oli andnud. ");
INSERT INTO ekk_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Nad saabusid Efesosse, kuhu ta Priskilla ja Akvila jättis. Ta ise läks aga sünagoogi ning vestles juutidega. ");
INSERT INTO ekk_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Aga kui nad palusid tal jääda kauemaks, Paulus keeldus. ");
INSERT INTO ekk_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Lahkumisel ta lubas: „Pühad on tulemas ja ma pean sel ajal olema Jeruusalemmas. Ma tulen tagasi, kui see on Jumala tahe.“ Ja ta lahkus Efesosest. ");
INSERT INTO ekk_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kui ta Kaisareas oli maabunud, läks ta üles Jeruusalemma, tervitas kogudust ja läks siis alla Antiookiasse. ");
INSERT INTO ekk_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Kui ta oli seal mõnda aega olnud, asus Paulus teele ja käis järgemööda läbi Galaatia ja Früügia alad, julgustades kõiki jüngreid. ");
INSERT INTO ekk_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Samal ajal tuli Efesosse Aleksandriast pärit juut Apollos. Ta oli õppinud mees ja tundis hästi Pühakirja. ");
INSERT INTO ekk_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Teda oli õpetatud tundma Issanda teed ja vaimult tulisena rääkis ja õpetas õigesti Jeesusest, kuigi ta teadis ainult Johannese ristimist. ");
INSERT INTO ekk_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ta hakkas sünagoogis julgelt rääkima. Kui Priskilla ja Akvila teda kuulsid, kutsusid nad ta oma koju ja selgitasid talle täpsemalt Jumala teed. ");
INSERT INTO ekk_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Aga kui Apollos tahtis minna Ahhaiasse, julgustasid teda vennad ja õed ning kirjutasid sealsetele jüngritele, et nad ta vastu võtaksid. Sinna jõudes oli ta suureks abiks neile, kes olid hakanud uskuma armu läbi. ");
INSERT INTO ekk_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Sest ta lükkas avalikes aruteludes osavalt ümber juutide väited, tõestades Pühakirjast, et Jeesus on Messias. ");
INSERT INTO ekk_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Sel ajal kui Apollos oli Korintoses, sündis, et Paulus käis läbi sisemaa ja tuli Efesosse. Leides sealt mõned jüngrid, küsis ta neilt: ");
INSERT INTO ekk_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","„Kast te võtsite vastu Püha Vaimu, kui te saite usklikuks?“ Nad vastasid: „Me pole isegi kuulnud, et Püha Vaim on.“ ");
INSERT INTO ekk_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ja ta küsis neilt: „Millesse siis teie olete ristitud?“ Nemad vastasid: „Johannese ristimisse.“ ");
INSERT INTO ekk_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Aga Paulus ütles: „Johannes tõepoolest ristis meeleparandusristimisega, öeldes rahvale, et nad usuksid sellesse, kes tuleb pärast teda, see on Messias Jeesusesse.“ ");
INSERT INTO ekk_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Seda kuuldes lasksid nad end ristida Issanda Jeesuse nimesse. ");
INSERT INTO ekk_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ja kui Paulus pani käed nende peale, tuli neile Püha Vaim ja nad rääkisid võõraid keeli ja prohveteerisid. ");
INSERT INTO ekk_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Seal oli kokku umbes tosin meest. ");
INSERT INTO ekk_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulus läks siis sünagoogi ja rääkis julgesti kolm kuud, väideldes ja veendes neid Jumala riigi asjus. ");
INSERT INTO ekk_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Aga kui mõned tegid oma südame kõvaks ega uskunud, vaid rahva ees halvustasid usuteed, läks ta ära nende juurest ja eraldas neist ka jüngrid ning pidas iga päev arutlusi Türannose koolis. ");
INSERT INTO ekk_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","See kestis kaks aastat, nõnda et kõik, kes Aasias elasid, nii juudid kui kreeklased, said kuulda Issanda Jeesuse sõna. ");
INSERT INTO ekk_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ja Jumal tegi erakordseid imesid Pauluse käte läbi, ");
INSERT INTO ekk_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","nii et ka tema ihu pealt võetud higirätikuid ja põllesid viidi haigete peale ja haigused lahkusid neist ning kurjad vaimud läksid välja. ");
INSERT INTO ekk_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Aga mõned juudid, kes rännates kurje vaime välja ajasid, hakkasid kasutama Issanda Jeesuse nime, üteldes: „Ma käsin teil välja tulla selle Jeesuse nimel, keda Paulus kuulutab!“ ");
INSERT INTO ekk_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ja need olid ühe juudi ülempreestri Skeua seitse poega, kes seda tegid. ");
INSERT INTO ekk_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ent kuri vaim ütles: „Jeesust ma tunnen ja Paulust ma tean, aga kes teie olete?“ ");
INSERT INTO ekk_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ja mees, kelles oli kuri vaim, hüppas neile peale ja sai võimust nende üle. Ja ta andis neile niimoodi peksa, et nad alasti ja haavatuna põgenesid sellest majast. ");
INSERT INTO ekk_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","See lugu sai teatavaks kõigile juutidele ja kreeklastele, kes elasid Efesoses. Hirm langes nende kõikide peale ja Issanda Jeesuse nime hoiti suure au sees. ");
INSERT INTO ekk_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ja paljud usklikud tulid ning tunnistasid üles oma teod. ");
INSERT INTO ekk_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Paljud neist, kes olid tegelenud nõiakunstiga, tõid oma raamatud kokku ja põletasid need ära kõikide silme all. Ja kui nad arvutasid kokku nende väärtuse, oli see viiskümmend tuhat hõbetükki. ");
INSERT INTO ekk_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Nõnda võimsalt kasvas ja avaldas oma väge Issanda sõna. ");
INSERT INTO ekk_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Pärast kõiki neid sündmusi otsustas Paulus Makedoonia ja Ahhaia kaudu Jeruusalemma minna. „Kui ma seal olen ära käinud,“ ütles ta, „pean ma nägema ka Roomat.“ ");
INSERT INTO ekk_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ta läkitas Makedooniasse kaks oma abilist, Timoteose ja Erastose, ise jäi aga veel mõneks ajaks Aasiasse. ");
INSERT INTO ekk_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Sel ajal tekkis suur tüli õpetuse pärast. ");
INSERT INTO ekk_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Sest üks hõbesepp nimega Demeetrios, kes tegi hõbedast Artemise templi kujukesi, tõi sealsetele käsitöölistele rohkesti tööd. ");
INSERT INTO ekk_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ta kutsus kokku kõik, kes selles ametis olid, ja ütles neile: „Mehed, te teate, et meie heaolu sõltub sellest tööst. ");
INSERT INTO ekk_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ja te näete ja kuulete, et see Paulus veenab ja pöörab ümber palju inimesi mitte ainult Efesoses, vaid peaaegu kogu Aasias, öeldes, et need ei ole jumalad, mis kätega tehakse. ");
INSERT INTO ekk_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ja nõnda ähvardab põlu alla sattumine mitte ainult meie äri, vaid ka suure jumalanna Artemise templit võidakse põlata ja selle toredus hävitada, ehkki seda kummardab kogu Aasia.“ ");
INSERT INTO ekk_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Seda kuuldes läksid nad raevu ja hüüdsid: „Suur on efeslaste Artemis!“ ");
INSERT INTO ekk_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ja terve linn täitus segadusega ja nad tungisid teatrisse, vedades kaasa makedoonlased Gaiuse ja Aristarhose, Pauluse reisikaaslased. ");
INSERT INTO ekk_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ja kui Paulus tahtis rahva ette minna, ei lubanud jüngrid teda. ");
INSERT INTO ekk_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Isegi mõned provintsi ametnikud, kes olid ta sõbrad, saatsid talle sõnumi paludes, et ta ei läheks teatrisse. ");
INSERT INTO ekk_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Rahvakogu oli segaduses, sest ühed karjusid üht ja teised teist ja enamik ei teadnud, mis põhjusel nad olid kokku tulnud. ");
INSERT INTO ekk_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Siis toodi rahva seast esile Aleksandros, kelle juudid ette lükkasid. Aleksandros viipas käega, tahtes pidada rahva ees kaitsekõnet. ");
INSERT INTO ekk_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Aga kui nad said aru, et ta on juut, karjusid kõik ühehäälselt kaks tundi: „Suur on efeslaste Artemis!“ ");
INSERT INTO ekk_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Aga linnakirjutaja vaigistas rahvahulga ja ütles: „Efesose mehed, milline mees ei teaks, et efeslaste linn on suure jumalanna Artemise templi ja tema taevast Zeusi käest maha langenud kuju hoidja? ");
INSERT INTO ekk_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Seepärast, kuna need faktid on vaieldamatud, peaksite olema vait ja mitte midagi tegema kiirustades. ");
INSERT INTO ekk_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Te olete toonud need mehed siia, kuigi nad ei ole rüüstanud templit ega teotanud meie jumalannat. ");
INSERT INTO ekk_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Kui nüüd Demeetriosel ja teistel käsitöölistel on midagi kellegi vastu, siis kohtud on avatud ja seal on prokonsulid; kaevaku nad seal üksteise peale. ");
INSERT INTO ekk_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ja kui teil on veel nõudmisi, siis seletatagu asi korralise rahvakogu ees. ");
INSERT INTO ekk_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Sest meil on oht sattuda tänase kära pärast uurimise alla, ja pole ühtegi põhjust, millega sellist korratut kogunemist õigustada.“ ");
INSERT INTO ekk_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ja kui ta seda oli öelnud, saatis ta rahvakoosoleku laiali. ");
INSERT INTO ekk_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kui rahutused olid lõppenud, kutsus Paulus jüngrid enese juurde, ja olles neid julgustanud, jättis ta nendega hüvasti ning asus teele Makedooniasse. ");
INSERT INTO ekk_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ta käis läbi selle piirkonna, rääkis inimestele palju julgustavaid sõnu ja jõudis lõpuks Kreekasse. ");
INSERT INTO ekk_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ta jäi sinna kolmeks kuuks. Kuna juudid kavandasid tema vastu kurja samal ajal, kui tema valmistus purjetama Süüriasse, otsustas ta tagasi pöörduda Makedoonia kaudu. ");
INSERT INTO ekk_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Temaga koos olid Soopatros, Pürrose poeg Bereast, Aristarhos ja Sekundus Tessaloonikast, Gaius Derbest, samuti Timoteos, ning Tühhikos ja Trofimos Aasia maakonnast. ");
INSERT INTO ekk_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Need mehed läksid ette ja ootasid meid Troases. ");
INSERT INTO ekk_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Meie aga purjetasime pärast hapnemata leibade pühi Filippist ära ja ühinesime teistega viis päeva hiljem Troases. Me jäime sinna seitsmeks päevaks. ");
INSERT INTO ekk_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Nädala esimesel päeval me kogunesime leiba murdma. Paulus kõneles inimestele. Ja kuna ta plaanis järgmisel päeval lahkuda, jätkas ta kõnelemist südaööni. ");
INSERT INTO ekk_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ent mitu lampi põles ülemises toas, kus me koos olime. ");
INSERT INTO ekk_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Aknal istus noormees nimega Eutühhos, kes vajus sügavasse unne, kui Paulus rääkis ja rääkis. Kui ta oli sügavalt magama jäänud, kukkus ta kolmandalt korruselt alla ja kui ta üles tõsteti, oli ta surnud. ");
INSERT INTO ekk_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paulus läks alla, heitis ennast noormehe peale ja haaras ta ümbert kinni. „Ärge kartke,“ ütles ta, „ta on elus!“ ");
INSERT INTO ekk_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Siis ta läks üles, murdis leiba ja sõi. Kui ta oli kõnelnud kaua, kuni koiduni, ta lahkus. ");
INSERT INTO ekk_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Aga rahvas viis noormehe koju elusana ja tundis suurt lohutust. ");
INSERT INTO ekk_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Meie aga läksime varem laeva ja purjetasime Assosesse, kus me pidime Pauluse peale võtma. Ta oli niiviisi korraldanud, sest ta tahtis sinna jalgsi tulla. ");
INSERT INTO ekk_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Kui ta meiega Assoses kokku sai, võtsime ta laeva ja tulime Mitüleenesse. ");
INSERT INTO ekk_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Sealt me purjetasime järgmisel päeval edasi ja jõudsime Kiose saare lähedale. Teisel päeval aga purjetasime Samose saarele ja sellele järgneval päeval saabusime Mileetosesse. ");
INSERT INTO ekk_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Sest Paulus oli otsustanud Efesosest mööda purjetada, et mitte Aasia provintsis aega viita, sest ta kiirustas, et kui vähegi võimalik, nelipühapäevaks jõuda Jeruusalemma. ");
INSERT INTO ekk_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mileetosest saatis Paulus sõna Efesosse ja kutsus kogudusevanemad enese juurde. ");
INSERT INTO ekk_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kui nad saabusid, ütles ta neile: „Te teate, kuidas alates esimesest päevast, mil ma Aasia maakonda saabusin, ma kogu selle aja teie juures olen elanud. ");
INSERT INTO ekk_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ma teenisin Issandat suure alandlikkusega ja pisaratega ja ränkade katsumustega juutide kurjade vastuplaanide keskel. ");
INSERT INTO ekk_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Te teate, et ma pole kõhelnud teile kuulutada ühtki asja, mis võiks teile kasulik olla, vaid olen õpetanud avalikult ja majast majja käies. ");
INSERT INTO ekk_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ma tunnistasin nii juutidele kui kreeklastele, et nad peavad meeleparanduseks pöörduma Jumala poole ja uskuma Issandasse Jeesusesse. ");
INSERT INTO ekk_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ja nüüd lähen ma Vaimust ajendatuna Jeruusalemma ega tea, mis minuga seal võib juhtuda. ");
INSERT INTO ekk_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Tean ainult seda, mida Püha Vaim igas linnas hoiatab ja ütleb, et vangistused ja raskused ootavad mind. ");
INSERT INTO ekk_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Siiski ma ei pea oma elu endale kalliks. Minu ainus eesmärk on lõpetada võidujooks ja täita ülesanne, mille Issand Jeesus on mulle andnud: tunnistada Jumala armu evangeeliumi. ");
INSERT INTO ekk_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ma tean, et mitte keegi teist, kelle hulgas ma olen kuningriiki kuulutanud, ei näe mind enam kunagi. ");
INSERT INTO ekk_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Seetõttu tunnistan ma teile tänasel päeval, et mina olen puhas kõikide verest. ");
INSERT INTO ekk_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Sest ma pole kartnud teile kuulutada kogu Jumala tahet. ");
INSERT INTO ekk_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Sellepärast pange tähele iseennast ja kõike karja, mille ülevaatajaks Püha Vaim on teid pannud. Olge karjased Jumala kogudusele, mille ta on saanud iseenese vere läbi. ");
INSERT INTO ekk_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ma tean, et pärast minu lahkumist tulevad teie sekka julmad hundid, kes karja ei säästa. ");
INSERT INTO ekk_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Isegi teie eneste seast tõusevad mehed ja moonutavad tõde, et meelitada jüngreid eneste järele. ");
INSERT INTO ekk_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Sellepärast valvake ja mõelge sellele, et ma kolm aastat ööd ja päevad ei ole lakanud silmaveega manitsemast igaüht teie seast. ");
INSERT INTO ekk_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Nüüd ma jätan teid Jumala ja tema armusõna hooleks; tema ehitab teid üles ja annab teile pärandi kõigi pühitsetute seas. ");
INSERT INTO ekk_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Kellegi hõbedat ega kulda ega rõivaid ei ole ma kadestanud. ");
INSERT INTO ekk_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Te teate, et need mu käed on teinud tööd ja teeninud minule ja minu kaaslastele seda, mis vajalik. ");
INSERT INTO ekk_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Kõiges, mida ma tegin, näitasin teile, et sellise raske tööga peame aitama nõrgemaid, pidades meeles sõnu, mida Issand Jeesus ise ütles: „Õndsam on anda kui võtta!“ “ ");
INSERT INTO ekk_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Kui Paulus oli kõne lõpetanud, põlvitas ta nende kõikidega maha ja palvetas. ");
INSERT INTO ekk_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Siis puhkesid kõik valjusti nutma ja kallistasid Paulust ja andsid talle suud. ");
INSERT INTO ekk_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Kõige rohkem kurvastas neid väide, et nad ei näe tema nägu enam kunagi. Siis saatsid nad ta laevale. ");
INSERT INTO ekk_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Kui me olime neist lahkunud ja merele läinud, purjetasime otsekohe Koosi saarele. Järgmisel päeval aga Roodosele ja sealt edasi Patarasse. ");
INSERT INTO ekk_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Seal me leidsime laeva, mis oli teel Foiniikiasse. Astusime laevale ja sõitsime minema. ");
INSERT INTO ekk_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Pärast seda, kui Küpros meile paistma hakkas, möödusime sellest lõuna poolt ja purjetasime Süüriasse. Ma randusime Tüüroses, kus pidi laev lossitama. ");
INSERT INTO ekk_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Seal me leidsime jüngreid ja jäime nende juurde seitsmeks päevaks. Nad ütlesid Paulusele Vaimu mõjul, et ta ei läheks Jeruusalemma. ");
INSERT INTO ekk_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kui aeg kätte jõudis, lahkusime ja jätkasime oma teed. Ja nemad kõik naiste ja lastega saatsid meid linnast välja, ja me põlvitasime ranna ääres ning palvetasime. ");
INSERT INTO ekk_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Pärast seda, kui me olime üksteisega hüvasti jätnud, astusime laeva, nemad aga pöördusid tagasi koju. ");
INSERT INTO ekk_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Meie jätkasime aga reisi Tüürosest Ptolemaisi, kus me tervitasime vendi ja õdesid ning jäime üheks päevaks nende juurde. ");
INSERT INTO ekk_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Järgmisel päeval me lahkusime sealt, jõudsime Kaisareasse ja peatusime evangelist Filippuse kodus. Filippus oli üks neist seitsmest. ");
INSERT INTO ekk_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Tal oli neli vallalist tütart, kes kõnelesid prohvetlikult. ");
INSERT INTO ekk_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Kui olime seal mitu päeva olnud, tuli Juudamaalt alla prohvet Agabos. ");
INSERT INTO ekk_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ta tuli meie juurde, võttis Pauluse vöö, sidus sellega kinni oma käed ja jalad ning ütles: „Nii ütleb Püha Vaim: mehe, kelle oma on see vöö, seovad juudid Jeruusalemmas kinni ja annavad üle rahvaste kätte!“ ");
INSERT INTO ekk_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kui me seda kuulsime, püüdsime meie ja ka teised veenda Paulust, et ta ei läheks üles Jeruusalemma. ");
INSERT INTO ekk_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Seepeale vastas Paulus: „Miks te nutate ja murrate mu südant? Ma olen valmis mitte üksnes laskma ennast Jeruusalemmas aheldada, vaid ka surema Issanda Jeesuse nime pärast.“ ");
INSERT INTO ekk_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Aga kui ta ei võtnud meid kuulda, me loobusime ja ütlesime: „Issanda tahtmine sündigu!“ ");
INSERT INTO ekk_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Pärast seda alustasime oma teed Jeruusalemma. ");
INSERT INTO ekk_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Meid saatsid mõned jüngrid Kaisareast ja viisid meid Mnaasoni koju, kus me pidime peatuma. Ta oli Küproselt pärit mees ja üks varajastest jüngritest. ");
INSERT INTO ekk_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kui me Jeruusalemma jõudsime, võtsid vennad ja õed meid soojalt vastu. ");
INSERT INTO ekk_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Järgmisel päeval läks Paulus meiega Jaakobuse juurde ja kõik vanemad tulid ka sinna. ");
INSERT INTO ekk_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paulus tervitas neid ja kirjeldas üksikasjalikult, mida Jumal tema teenimise läbi oli teiste rahvaste seas teinud. ");
INSERT INTO ekk_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Seda kuuldes ülistasid nad Jumalat. Ja nad ütlesid Paulusele: „Näed, vend, kui mitmed tuhanded juudid on saanud usklikuks, ja nad kõik on Seaduse pidajad! ");
INSERT INTO ekk_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Neile on räägitud, et sa õpetavat võõraste rahvaste seas elavaid juute Moosesest ära taganema, öeldes, et neil ei ole vaja oma lapsi ümber lõigata ega elada meie kommete kohaselt. ");
INSERT INTO ekk_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Mida nüüd teha? Kindlasti saavad nad teada, et sa oled tulnud, ");
INSERT INTO ekk_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","seepärast tee nüüd seda, mis me sulle ütleme. Meil on neli meest, kes on andnud tõotuse. ");
INSERT INTO ekk_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Võta need mehed enesega ning puhasta ennast koos nendega ja kata nende kulud, et nad saaksid oma juuksed maha ajada. Siis näevad kõik, et see on tühi jutt, mis nad sinust on kuulnud, ja et ka sina elad Seadust pidades. ");
INSERT INTO ekk_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Mis puudutab usklikke teiste rahvaste hulgast, siis neile oleme saatnud kirja oma otsusest, et neil on vaja hoiduda ebajumalate ohvrilihast, verest, lämbunud loomade lihast ja sugukõlvatusest.“ ");
INSERT INTO ekk_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Järgmisel päeval võttis Paulus mehed ja laskis ennast koos nendega puhastada. Siis läks ta templisse, et teatada, millal puhastuspäevad lõpevad ja nende igaühe eest tuuakse ohver. ");
INSERT INTO ekk_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Kui seitse päeva hakkasid jõudma lõpule, nägid Aasia maakonnast pärit juudid Paulust templis. Nad ässitasid üles kogu rahva ja võtsid ta kinni, ");
INSERT INTO ekk_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","hüüdes: „Iisraeli mehed, tulge appi! Siin on mees, kes igal pool õpetab meie rahva ja Seaduse ja selle paiga vastu! Ja lisaks on ta toonud kreeklased templisse ja selle püha paiga rüvetanud!“ ");
INSERT INTO ekk_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Sest nad olid enne näinud linnas Paulusega koos efeslast Trofimust ja arvasid, et Paulus oli ta toonud templisse. ");
INSERT INTO ekk_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ja kogu linn tõusis liikvele ning inimesi tuli joostes igast suunast. Ja nad võtsid Pauluse kinni ning vedasid ta templist välja, ja otsekohe lukustati väravad. ");
INSERT INTO ekk_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Samal ajal, kui nad püüdsid teda tappa, läks sõnum Rooma vägede ülemani, et kogu Jeruusalemm on möllamas. ");
INSERT INTO ekk_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ta võttis sedamaid sõdureid ja pealikke kaasa ja tuli joostes alla rahva juurde. Kui märatsejad nägid ülempealikku ja tema sõdureid, lõpetasid nad Pauluse peksmise. ");
INSERT INTO ekk_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ülempealik vahistas Pauluse ja käskis ta kahe ketiga aheldada. Ja siis ta küsis, et kes ta on ja mis ta on teinud. ");
INSERT INTO ekk_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Aga rahva hulgast hüüdsid ühed üht ja teised teist, ja kuna ülempealik ei suutnud lärmi pärast midagi selgemalt teada saada, siis käskis ta Pauluse viia kindlusse. ");
INSERT INTO ekk_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Aga kui Paulus jõudis treppide juurde, tuli sõduritel rahva vägivaldse käitumise pärast teda kätel kanda. ");
INSERT INTO ekk_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Sest nende järel käiv rahvahulk karjus: „Hukka ta ära!“ ");
INSERT INTO ekk_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kui sõdurid olid Paulust kindlusse viimas, küsis ta ülempealikult: „Kas ma tohin sulle midagi öelda?“ „Kas sa räägid kreeka keelt?“ vastas tema, ");
INSERT INTO ekk_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","„Kas sa ei olegi see egiptlane, kes mõni aeg tagasi mässu alustas ja viis kõrbe neli tuhat mõrtsukat?“ ");
INSERT INTO ekk_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulus ütles: „Mina olen juut Tarsosest, kuulsa Kiliikia linna kodanik. Ma palun sind väga, luba mul rahvale kõnelda!“ ");
INSERT INTO ekk_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Saanud ülempealiku nõusoleku, astus Paulus trepiastmeile ja viipas rahvale käega. Kui kõik jäid vait, hakkas ta heebrea keeles kõnet pidama ja ütles: ");
INSERT INTO ekk_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","„Vennad ja isad, kuulake nüüd, mida ma teile enese kaitseks räägin!“ ");
INSERT INTO ekk_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kui nad kuulsid teda heebrea keeles rääkimas, jäid nad väga vaikseks. Ja Paulus ütles: ");
INSERT INTO ekk_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","„Mina olen juut, sündinud Tarsoses Kiliikiamaal ja üles kasvanud siin selles linnas. Ma õppisin Gamalieli käe all ja sain põhjaliku väljaõppe meie esivanemate Seadusest. Ma olin pühendunud Jumalale nagu igaüks teist on täna. ");
INSERT INTO ekk_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ja sellisena ma kiusasin taga usutee järgijaid kuni nende surmani, pannes ahelaisse ja heites vanglasse nii mehi kui naisi, ");
INSERT INTO ekk_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","nagu ülempreester ja kogu nõukogu võivad teile tunnistada. Nende käest ma sain isegi kirju nende kaaslaste jaoks Damaskuses, ja ma läksin sinna kavatsusega tuua ka need inimesed vangidena Jeruusalemma, et neid karistataks. ");
INSERT INTO ekk_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Lõuna paiku Damaskuse lähedale jõudes välgatas äkitselt mu ümber ere valgus taevast. ");
INSERT INTO ekk_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ma kukkusin maha ja kuulsin üht häält mulle ütlemas: „Saul! Saul! Miks sa mind taga kiusad?“ ");
INSERT INTO ekk_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","„Kes sa oled, Issand?“ küsisin ma. „Mina olen Naatsareti Jeesus, keda sa taga kiusad!“ vastas ta. ");
INSERT INTO ekk_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Minu kaaslased nägid küll valgust, aga nad ei kuulnud tema häält, kes minuga rääkis. ");
INSERT INTO ekk_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","„Mida pean ma tegema, Issand?“ küsisin ma. „Tõuse üles,“ ütles Issand, „ja mine Damaskusesse. Seal öeldakse sulle, mis sul on määratud teha.“ ");
INSERT INTO ekk_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kuna ma selle ereda valguse pärast ei näinud, juhtisid mu kaaslased mind kättpidi Damaskusesse. ");
INSERT INTO ekk_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Minu juurde tuli mees nimega Ananias. Ta oli pühendunud Seaduse järgija ja kõrgelt austatud kõigi seal elavate juutide poolt. ");
INSERT INTO ekk_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ta seisatas minu kõrval ja ütles: „Vend Saul, näe jälle!“ Ja selsamal hetkel ma nägin teda. ");
INSERT INTO ekk_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Siis ta ütles: „Meie esivanemate Jumal on sind valinud tundma tema tahet ja nägema seda Õiget ning kuulma sõnu tema suust. ");
INSERT INTO ekk_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Sina oled tema tunnistaja kõikidele inimestele selles, mida sa oled näinud ja kuulnud. ");
INSERT INTO ekk_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ja mida sa nüüd ootad? Tõuse üles, lase ennast ristida ja oma patud ära pesta, appi hüüdes tema nime!“ ");
INSERT INTO ekk_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Aga kui ma tagasi pöördusin Jeruusalemma ja templis palvetasin, olin ma nagu enesest ära ");
INSERT INTO ekk_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ja nägin Issandat minuga rääkimas: „Ruttu!“ ütles ta, „Lahku kohe Jeruusalemmast, sest siinsed inimesed ei võta vastu sinu tunnistust minu kohta.“ ");
INSERT INTO ekk_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","„Issand,“ vastasin mina, „nad ju teavad, et ma viisin vangi ja peksin sünagoogides neid, kes sinusse usuvad. ");
INSERT INTO ekk_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ja kui sinu märtri Stefanose verd valati, olin ma seal juures ja kiitsin selle heaks ning valvasin nende rõivaid, kes teda tapsid.“ ");
INSERT INTO ekk_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ja Issand ütles mulle: „Mine, ma läkitan su kaugele võõraste rahvaste sekka!“ “ ");
INSERT INTO ekk_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Kuni selle sõnani rahvas kuulas teda. Siis aga tõstsid nad häält ja karjusid: „Hukka niisugune ära maa pealt, tema ei tohi ellu jääda!“ ");
INSERT INTO ekk_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ja kui nad karjusid ja viskasid maha oma kuued, tolmu üles pildudes, ");
INSERT INTO ekk_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","käskis ülempealik Pauluse viia kindlusse. Ta käskis teda peksta ja välja uurida, miks inimesed tema peale sellisel kombel karjusid. ");
INSERT INTO ekk_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Aga kui nad ta peksmiseks pikali tõmbasid, ütles Paulus tema juures seisvale sadakonna ülemale: „Kas see on seaduslik, et te peksate Rooma kodanikku, keda pole süüdi mõistetud?“ ");
INSERT INTO ekk_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kui sadakonna ülem seda kuulis, läks ta ja kandis ülempealikule ette. „Mida sa kavatsed teha?“ küsis ta, „See mees on Rooma kodanik!“ ");
INSERT INTO ekk_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ülempealik tuli Pauluse juurde ja küsis: „Ütle mulle, kas sa oled Rooma kodanik?“ „Jah, olen!“ vastas Paulus. ");
INSERT INTO ekk_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ülempealik vastas: „Mina olen endale kodakondsuse hankinud suure raha eest.“ „Aga mina olen sellesse sündinud,“ vastas Paulus. ");
INSERT INTO ekk_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Sedamaid lahkusid need, kes olid teda üle kuulanud. Ülempealik lõi ise aga kartma, kui ta sai teada, et ta oli pannud Pauluse, Rooma kodaniku, ahelaisse. ");
INSERT INTO ekk_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Aga järgmisel päeval, tahtes teada saada, milles täpselt juudid Paulust süüdistavad, vabastas ta tema ahelatest ja käskis ülempreestritel ja kõigil Suurkohtu liikmetel kokku tulla. Ja ta viis Pauluse nende ette. ");
INSERT INTO ekk_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulus vaatas aga otse Suurkohtu poole ja ütles: „Mu vennad, mina olen oma kohust Jumala ees täitnud tänini ausa südametunnistusega.“ ");
INSERT INTO ekk_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Selle peale ülempreester Ananias käskis Pauluse lähedalseisjaid lüüa talle vastu suud. ");
INSERT INTO ekk_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Siis Paulus ütles talle: „Küll Jumal lööb ka sind, sa lubjatud sein! Sina istud siin, et minu üle kohut mõista Seaduse järgi, ise aga rikud Seadust sellega, et käsid mind lüüa!“ ");
INSERT INTO ekk_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Lähedalseisjad aga küsisid: „Kuidas sa julged solvata Jumala ülempreestrit?“ ");
INSERT INTO ekk_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulus vastas: „Vennad, ma ei saanud aru, et ta on ülempreester; sest on ju kirjutatud: „Ärge rääkige oma rahva valitsejatest halvasti.“ “ ");
INSERT INTO ekk_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Kuna Paulus teadis, et osa neist olid saduserid ja teine osa variserid, siis ta kuulutas Suurkohtus: „Mu vennad, mina olen variser, olen variseri poeg. Ma seisan kohtu ees surnuist ülestõusmise lootuse pärast.“ ");
INSERT INTO ekk_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Niipea kui ta seda oli öelnud, tõusis variseride ja saduseride vahel tüli ja kogu jagunes kaheks. ");
INSERT INTO ekk_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Saduserid usuvad, et ülestõusmist ei ole ja pole ka ingleid ega vaime, kuid variserid usuvad seda kõike.) ");
INSERT INTO ekk_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Siis tõusis suur lärm, ja mõned kirjatundjad variseride hulgast tõusid püsti ja vaidlesid jõuliselt. „Meie ei leia midagi valet selles mehes,“ ütlesid nad. „Mis siis, kui vaim või ingel ongi temaga rääkinud?“ ");
INSERT INTO ekk_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Aga vaidlus muutus vägivaldseks ja ülempealik kartis, et nad võivad Pauluse tükkideks rebida. Ta saatis väeüksuse välja, et Paulus nende käest jõuga ära võtta ja kindlusse viia. ");
INSERT INTO ekk_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Järgmisel ööl seisis Issand Pauluse juures ning ütles: „Ole julge! Nagu sa minust oled tunnistanud Jeruusalemmas, nõnda pead sa tunnistama ka Roomas!“ ");
INSERT INTO ekk_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Järgmisel hommikul pidasid juudid salaplaani ja vandusid vastastikku, et nad ei söö ega joo, enne kui nad Pauluse on tapnud. ");
INSERT INTO ekk_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Selle kokkuleppega oli seotud rohkem kui nelikümmend meest. ");
INSERT INTO ekk_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Nad läksid ülempreestrite ja vanemate juurde ja ütlesid: „Me oleme vandunud, et me ei söö ega joo, enne kui me Pauluse oleme tapnud. ");
INSERT INTO ekk_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Teie pöörduge nüüd Suurkohtuga väeülema poole palvega tuua ta enda ette põhjusel, et tema juhtumit täpsemalt uurida. Meie aga oleme valmis teda tapma, enne kui ta siia jõuab.“ ");
INSERT INTO ekk_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pauluse õepoeg sai sellest vandenõust kuulda, ta läks kindlusse ning teatas Paulusele. ");
INSERT INTO ekk_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paulus kutsus ühe sadakonna ülema enese juurde ja ütles talle: „Vii see noormees ülempealiku juurde. Tal on midagi temale teatada!“ ");
INSERT INTO ekk_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","See viis ta ülema juurde. Sadakonna ülem ütles: „Vang Paulus kutsus mind enese juurde ja palus tuua selle noore mehe sinu ette, sest tal on midagi sulle rääkida.“ ");
INSERT INTO ekk_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ülempealik võttis noormehel käest kinni, viis ta kõrvale ja küsis: „Mis sa tahad mulle öelda?“ ");
INSERT INTO ekk_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Tema ütles: „Juudid on leppinud kokku teid paluda, et te homme tooksite Pauluse Suurkohtu ette põhjusel, nagu sooviksite tema kohta saada täpsemat teavet. ");
INSERT INTO ekk_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ärge teie andke neile järele, sest rohkem kui nelikümmend meest varitsevad, et teda rünnata. Nad on andnud vande, et ei söö ega joo, enne kui on ta tapnud. Nad on juba valmis, oodates vaid teie nõusolekut.“ ");
INSERT INTO ekk_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ülempealik saatis noormehe ära, hoiatades teda: „Ära räägi kellelegi, et sa sellest mulle teada andsid.“ ");
INSERT INTO ekk_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Siis ta kutsus enese juurde kaks sadakonna ülemat ning käskis: „Pange valmis kakssada sõdurit, seitsekümmend ratsanikku ja kakssada odameest Kaisareasse minekuks täna öösel kolmandal tunnil. ");
INSERT INTO ekk_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ja varuge Pauluse jaoks hobused, et ta ohutult maavanem Feeliksi ette viia.“ ");
INSERT INTO ekk_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ta kirjutas ka järgmise kirja: ");
INSERT INTO ekk_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Klaudius Lüüsias, Kõrgesti austatud maavanem Feeliksile: Tervitused. ");
INSERT INTO ekk_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Selle mehe olid juudid kinni võtnud ja tahtsid teda tappa, aga ma tulin oma vägedega ja päästsin ta, sest olin teada saanud, et ta on Rooma kodanik. ");
INSERT INTO ekk_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Tahtes aru saada, milles nad teda süüdistavad, viisin ma ta Suurkohtu ette. ");
INSERT INTO ekk_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Siis ma leidsin, et teda süüdistatakse nende Seaduse vaidlusküsimustes, kuid ei olnud sellist süüd, mis väärinuks surma või vangistust. ");
INSERT INTO ekk_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Et ma aga kuulsin vandenõust selle mehe vastu, siis ma saadan ta otsekohe sinu juurde. Samuti käsin süüdistajatel sinule esitada tema vastu tõendid. ");
INSERT INTO ekk_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Seda käsku täites võtsid sõdurid Pauluse ja viisid ta öösel Antipatriseni. ");
INSERT INTO ekk_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Järgmisel päeval pöördusid nad tagasi kindlusse, ratsanikud läksid aga temaga edasi. ");
INSERT INTO ekk_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Need tulid Kaisareasse, toimetasid kirja maavanema kätte ja andsid ka Pauluse temale üle. ");
INSERT INTO ekk_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Maavanem luges kirja läbi ja päris, mis maakonnast ta on. Kuuldes, et ta on Kiliikiast, ");
INSERT INTO ekk_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ütles ta: „Ma kuulan su ära, kui su süüdistajad siia jõuavad.“ Ja ta käskis Paulust valvata Heroodese kindluses. ");
INSERT INTO ekk_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Viis päeva hiljem tuli alla Kaisareasse ülempreester Ananias koos mõne vanema ja advokaadiga, keda hüüti Tertulluseks, ning nad esitasid maavanemale Pauluse vastu süüdistuse. ");
INSERT INTO ekk_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Kui Paulus oli sisse kutsutud, alustas Tertullus süüdistuskõnet Feeliksi ees: „Meie oleme sinu valitsuse all, auline Feeliks, nautinud pikka aega rahu ja sinu ettenägelikkus on toonud muutust meie rahva hulgas. ");
INSERT INTO ekk_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ja seda me tunnustame igal pool ja igal viisil sügava tänuga. ");
INSERT INTO ekk_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Et sind aga kauem mitte väsitada, siis palun sind, et sa oma lahkuses meie asja lühidalt ära kuulad. ");
INSERT INTO ekk_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Sest me oleme leidnud, et see mees tekitab tüli, õhutades mässu kõigi juutide seas kogu maailmas. Ta on Naatsaretlaste usulahu juht ");
INSERT INTO ekk_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ja ta on püüdnud isegi templit rüvetada. Sellepärast me ta kinni võtsimegi et tema üle kohut mõista meie Seaduse järgi. ");
INSERT INTO ekk_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ülempealik Lüüsias tuli aga vahele ning võttis ta suure vägivallaga meie käest ära, ");
INSERT INTO ekk_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","käskides süüdistajaid tulla sinu juurde. Kui sa teda ise üle kuulad, siis saad teada, et meie esitatud süüdistused tema vastu on tõde.“ ");
INSERT INTO ekk_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ja juudid ühinesid sellega, kinnitades, et see on nõnda. ");
INSERT INTO ekk_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Kui maavanem Paulusele märku andis rääkida, vastas ta: „Ma tean, et sa oled palju aastaid olnud selle rahva kohtunik; nii et ma kaitsen end julgesti. ");
INSERT INTO ekk_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Nagu sa võid teada saada, ei ole rohkem kui kaksteist päeva sellest, kui ma läksin üles Jeruusalemma Jumalat kummardama. ");
INSERT INTO ekk_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Minu süüdistajad ei ole näinud mind templis kellegagi vaidlemas või rahvast üles ässitamas, ei sünagoogis ega ka kusagil mujal linnas. ");
INSERT INTO ekk_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Nad ei suuda ka tõestada seda, milles nad mind süüdistavad. ");
INSERT INTO ekk_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Aga ma võtan omaks, et ma usuteed mööda, mida nemad kutsuvad lahkusuks, teenin meie esivanemate Jumalat. Ma usun kõike, mis Seadusesse ja prohvetite raamatutesse on kirjutatud, ");
INSERT INTO ekk_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ja mul on sama lootus Jumala peale nagu nendel meestel, et tuleb nii õigete ja kui ka ülekohtuste ülestõusmine. ");
INSERT INTO ekk_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Just sellepärast püüan ma alati hoida puhast südametunnistust Jumala ja inimeste ees. ");
INSERT INTO ekk_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Pärast mitmeaastast äraolekut tulin Jeruusalemma, et tuua annetusi oma rahvale ja ohverdada. ");
INSERT INTO ekk_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Just seda leidsid mind mõned juudid templis tegemast. Minuga ei olnud ühtegi rahvahulka ega mingit korratust. ");
INSERT INTO ekk_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Aga Aasia maakonnast olid mõned juudid, kes peaksid siin sinu ees olema ja süüdistusi esitama, kui neil on midagi minu vastu. ");
INSERT INTO ekk_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Või ütelgu need mehed siin ise, mis süüd nad minust leidsid, kui ma seisin Suurkohtu ees. ");
INSERT INTO ekk_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Kui see just pole see üks asi, mis ma nende ees seistes hüüdsin: te mõistate täna minu üle kohut surnute ülestõusmise pärast?“ ");
INSERT INTO ekk_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feeliks aga, olles usuteega hästi kursis, lükkas kohtuasja edasi ja ütles: „Kui ülempealik Lüüsias tuleb, siis ma otsustan teie asja!“ ");
INSERT INTO ekk_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ta andis sadakonna ülemale korralduse hoida Paulust vahi all, kuid jätta talle mõned vabadused ning lubada ta sõpradel teda teenida. ");
INSERT INTO ekk_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Mõne päeva pärast tuli Feeliks oma naise Drusillaga, kes oli juuditar. Ta kutsus Pauluse ja kuulas ta kõnet usust Jeesusesse Kristusesse. ");
INSERT INTO ekk_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Aga kui Paulus kõneles õiglusest, enesekontrollist ja tulevasest kohtust, lõi Feeliks kartma ja vastas: „See on selleks korraks kõik! Sa võid ära minna. Kui mul on rohkem aega, siis ma lasen sind jälle kutsuda.“ ");
INSERT INTO ekk_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Samal ajal ta lootis, et Paulus pakub talle altkäemaksu. Seepärast kutsus ta teda tihti enese juurde ja vestles temaga. ");
INSERT INTO ekk_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ent kui kaks aastat sai täis, tuli Feeliksi asemele Porkius Festus. Ja et Feeliks tahtis olla juutidele meelepärane, jättis ta Pauluse vangi. ");
INSERT INTO ekk_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Kolm päeva pärast ametisse astumist läks Festus Kaisareast üles Jeruusalemma, ");
INSERT INTO ekk_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","kus ülempreestrid ja juutide juhid astusid tema ette ja esitasid süüdistuse Pauluse vastu. ");
INSERT INTO ekk_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Nad palusid Festust hea tahte märgiks saata Paulus Jeruusalemma, sest nad plaanisid teda tee peal rünnata ja tappa. ");
INSERT INTO ekk_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Aga Festus vastas: „Paulust hoitakse Kaisareas ja ma ise lähen ka varsti sinna. ");
INSERT INTO ekk_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Tulgu mõni teie juhtidest minuga kaasa ja esitagu tema vastu süüdistus seal, kui ta on midagi valesti teinud.“ ");
INSERT INTO ekk_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Kui Festus oli seitse või kaheksa päeva nende juures olnud, läks ta alla Kaisareasse. Järgmisel päeval kutsus ta kokku kohtu ja käskis Pauluse tema ette tuua. ");
INSERT INTO ekk_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Kui Paulus sisse astus, piirasid ta ümber Jeruusalemmast tulnud juudid. Nad esitasid talle palju tõsiseid süüdistusi, kuid ei suutnud neid tõestada. ");
INSERT INTO ekk_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Siis kaitses Paulus ennast: „Ma ei ole teinud midagi valesti ei juutide Seaduse ega templi ega keisri vastu.“ ");
INSERT INTO ekk_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festus aga, soovides olla juutidele meelepärane, küsis: „Kas sa oled nõus minema nende süüdistustega üles Jeruusalemma ja astuma minu ette kohtus?“ ");
INSERT INTO ekk_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulus vastas: „Mina seisan praegu keisri kohtujärje ees, kus mu üle peab kohut mõistetama. Juutide vastu ma ei ole eksinud, nagu sa isegi hästi tead. ");
INSERT INTO ekk_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Kui ma olen siiski süüdi selles, et olen teinud midagi surma väärivat, ei keeldu ma surmast. Kuid kui nende poolt minu vastu esitatud süüdistused ei vasta tõele, ei ole kellelgi õigust mind neile välja anda. Mina nõuan keisri kohut!“ ");
INSERT INTO ekk_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Pärast seda, kui Festus oli arutanud oma nõunikega, ta vastas: „Keisri kohut oled sa nõudnud, keisri ette sa lähed!“ ");
INSERT INTO ekk_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Mõni päev hiljem saabusid Kaisareasse kuningas Agrippa ja Berenike Festust tervitama. ");
INSERT INTO ekk_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ja kuna nad veetsid seal mitu päeva, rääkis Festus kuningale Pauluse juhtumist. Ta ütles: „Feeliks on jätnud vangi ühe mehe. ");
INSERT INTO ekk_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Kui ma läksin Jeruusalemma, esitasid juudi ülempreestrid ja rahvavanemad tema vastu süüdistuse ja nõudsid tema surmamõistmist. ");
INSERT INTO ekk_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ma vastasin neile, et Roomas ei ole kombeks kedagi välja anda, enne kui süüdistatav saab seista vastamisi süüdistajatega ja ennast süüdistuste vastu kaitsta. ");
INSERT INTO ekk_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kui nad koos minuga siia tulid, ei lükanud ma kohtuasja edasi, vaid kutsusin kohtu järgmisel päeval kokku ja käskisin mehe sisse tuua. ");
INSERT INTO ekk_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Aga kui tema süüdistajad rääkima hakkasid, ei esitanud nad temale süüdistust üheski sellises kuriteos, nagu mina ootasin. ");
INSERT INTO ekk_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Selle asemel oli neil temaga vaidlus nende oma usu ja kellegi surnud Jeesuse suhtes, kelle kohta Paulus väitis, et ta on elus. ");
INSERT INTO ekk_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ma olin nõutu, kuidas selliseid asju uurida; nii et ma küsisin, kas ta on valmis minema Jeruusalemma ja astuma seal nendes süüdistustes kohtu ette. ");
INSERT INTO ekk_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Aga kui Paulus nõudis, et see asi tuleb üle anda keisrile otsutamiseks, siis ma käskisingi teda kinni pidada, kuni ma võin ta saata keisri juurde.“ ");
INSERT INTO ekk_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Siis ütles Agrippa Festusele: „Ma tahaksin seda meest ise kuulda.“ Ta vastas: „Homme saad teda kuulda.“ ");
INSERT INTO ekk_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Järgmisel päeval tulid Agrippa ja Berenike kogu oma vürstlikus hiilguses ja astusid kohtusaali koos kõrgete väepealike ja linna tähtsate meestega. Siis toodi Festuse käsul Paulus. ");
INSERT INTO ekk_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus ütles: „Kuningas Agrippa ja kõik, kes te siin meiega olete, te näete seda meest! Terve juudi kogukond on nõudnud minult Jeruusalemmas ja siin, Kaisareas, karjudes, et ta ei tohi enam elada. ");
INSERT INTO ekk_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Mina aga leidsin, et ta pole teinud midagi surma väärivat, kuid kuna ta ise nõudis keisri kohut, siis ma otsustasin ta sinna saata. ");
INSERT INTO ekk_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Aga mul pole midagi tema kohta Tema Majesteedile kirjutada. Seepärast ma olen toonud ta teie ette ja eriti sinu ette, kuningas Agrippa, et mul pärast juurdlust oleks midagi kirjutada. ");
INSERT INTO ekk_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Sest mulle tundub mõttetu saata vang Rooma ilma süüdistuste loetelu esitamata.“ ");
INSERT INTO ekk_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Aga Agrippa ütles Paulusele: „Sul on luba enese eest rääkida.“ Paulus viipas käega ja alustas oma kaitsekõnet: ");
INSERT INTO ekk_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","„Ma pean end õnnelikuks, kuningas Agrippa, et ma saan täna sinu ees seista ja kõigi juutide esitatud süüdistuste vastu ennast kaitsta, ");
INSERT INTO ekk_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","sest sina tunned hästi juutide kombeid ja vaidlusküsimusi. Seepärast ma palun, et sa mind kannatlikult ära kuulaksid! ");
INSERT INTO ekk_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Kõik juudid teavad, kuidas ma olen lapsest saati elanud, oma elu algul omal kodumaal ja samuti Jeruusalemmas. ");
INSERT INTO ekk_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Nad tunnevad mind juba pikka aega ja võivad soovi korral tunnistada, et ma olen elanud variserina meie kõige rangema usulahu nõuete järgi. ");
INSERT INTO ekk_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ja nüüd ma olen täna kohtu all lootuse pärast selle tõotuse peale, mille Jumal on andnud meie esiisadele. ");
INSERT INTO ekk_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Selle tõotuse täitumist loodavad näha meie kaksteist suguharu, teenides Jumalat siiralt ööd ja päevad. Kuningas Agrippa, selle lootuse pärast süüdistavadki mind juudid. ");
INSERT INTO ekk_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Miks peaks keegi teist uskumatuks pidama, et Jumal surnuid üles äratab? ");
INSERT INTO ekk_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Ka mina olin veendunud, et pean tegema kõik, mis võimalik, et seista vastu Naatsareti Jeesuse nimele. ");
INSERT INTO ekk_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ja täpselt seda ma tegin Jeruusalemmas. Ülempreestrite meelevalla all ma panin palju Issanda pühi inimesi vangi ja kui neid tapeti, andsin oma hääle selle poolt. ");
INSERT INTO ekk_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ja ma karistasin neid sageli, käies ühest sünagoogist teise, ja püüdsin sundida neid Jumalat teotama. Ma olin nende tagakiusamisest nii haaratud, et jahtisin neid isegi võõrastes linnades. ");
INSERT INTO ekk_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Ühel neist rännakutest suundusin ülempreestrite volituse ja ülesandega Damaskusesse. ");
INSERT INTO ekk_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Umbes keskpäeva paiku tee peal, kuningas Agrippa, nägin ma päikesest eredamat valgust taevast, säramas minu ja minu kaaslaste ümber. ");
INSERT INTO ekk_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Me kõik kukkusime maha ja ma kuulsin häält minuga kõnelemas heebrea keeles: „Saul, Saul, miks sa mind taga kiusad? Raskeks läheb sul astla vastu takka üles lüüa!“ ");
INSERT INTO ekk_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Mina aga küsisin: „Kes sa oled, Isand?“ „Mina olen Jeesus, keda sa taga kiusad,“ vastas Issand. ");
INSERT INTO ekk_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","„Aga nüüd tõuse üles ja seisa jalgadele. Ma olen sulle ilmunud selleks, et sind määrata sulaseks ja tunnistajaks sellele, mida sa minust oled näinud ja saad veel nägema. ");
INSERT INTO ekk_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ma päästan sind su rahva ja paganate käest. Nende juurde ma sind nüüd läkitan, ");
INSERT INTO ekk_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","avama nende silmi, et nad pöörduksid pimedusest valguse poole ja saatana meelevalla alt Jumala poole, et nad saaksid patud andeks ja koha nende seas, kes on pühitsetud usu kaudu minusse.“ ");
INSERT INTO ekk_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Niisiis, kuningas Agrippa, ma ei ole olnud sõnakuulmatu taevase nägemuse suhtes. ");
INSERT INTO ekk_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ma kuulutasin esmalt neile, kes olid Damaskuses, siis Jeruusalemmas ja kogu Juudamaal, ning seejärel kuulutasin mittejuudi rahvastele, et nad peavad meelt parandama ja Jumala poole pöörduma ning näitama meeleparandust oma tegudega. ");
INSERT INTO ekk_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Sellepärast on juudid mind templis kinni võtnud ja püüdnud tappa. ");
INSERT INTO ekk_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Aga et Jumal on mind aidanud tänase päevani, siis ma seisan ja tunnistan nii väikestele kui suurtele, ega ütle midagi enamat kui seda, mida prohvetid ja Mooses on rääkinud, mis sünnib: ");
INSERT INTO ekk_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","et Messias pidi kannatama ja esimesena surnuist üles tõusma ning kuulutama sõnumit valgusest nii juutidele kui kõikidele rahvastele.“ ");
INSERT INTO ekk_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Siinkohal katkestas Festus Pauluse kaitsekõne. „Sa ole arust ära, Paulus,“ hüüdis ta, „sa oled suurest õppimisest hulluks läinud!“ ");
INSERT INTO ekk_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","„Ma ei ole hull, üliauline Festus,“ vastas Paulus. „Kõik, mis ma räägin, on tõsine ja arukas. ");
INSERT INTO ekk_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kuningas teab neid asju ja ma võin temaga julgesti rääkida. Olen veendunud, et ta on kõike seda tähele pannud, sest see ei ole ju kuskil nurga taga toimunud. ");
INSERT INTO ekk_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kuningas Agrippa, kas sa usud prohveteid? Ma tean, et sa usud!“ ");
INSERT INTO ekk_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Aga Agrippa ütles Paulusele: „Kas sa arvad, et suudad mind meelitada selle lühikese ajaga hakkama kristlaseks?“ ");
INSERT INTO ekk_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","„Lühike või pikk aeg – ma palun Jumalat, et mitte ainult sina vaid teie kõik, kes te mind täna kuulate, võiksite saada selliseks, nagu mina olen, välja arvatud need ahelad!“ ");
INSERT INTO ekk_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Kuningas ja maavanem ja Berenike ja need, kes nendega istusid, tõusid püsti. ");
INSERT INTO ekk_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Kui nad olid saalist lahkunud, rääkisid nad üksteisele: „See mees ei tee midagi, mis vääriks surma või vangistust.“ ");
INSERT INTO ekk_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agrippa ütles Festusele: „Selle mehe oleks võinud vabaks lasta, kui ta ei oleks nõudnud keisri kohut!“ ");
INSERT INTO ekk_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Kui oli otsustatud, et me purjetame Itaaliasse, anti Paulus ja mõned teised vangid üle sadakonna ülemale Juuliusele, kes kuulus keiserlikku väesalka. ");
INSERT INTO ekk_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Me astusime Adramüttionist laeva peale, mis pidi sõitma Aasia provintsi ranniku sadamatesse, ja me lahkusime merele. Meiega oli Tessaloonikast pärit makedoonlane Aristarhos. ");
INSERT INTO ekk_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Järgmisel päeval me randusime Siidonis; ja Juulius kohtles Paulust lahkesti ning lubas tal minna oma sõprade juurde, et need saaksid tema eest hoolt kanda. ");
INSERT INTO ekk_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Sealt me läksime uuesti merele ja purjetasime Küprose varjus, sest tuuled olid vastu. ");
INSERT INTO ekk_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kui olime Kiliikia ja Pamfüülia ranniku lähedal üle avamere purjetanud, saabusime Müürasse Lüükias. ");
INSERT INTO ekk_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ja kui sadakonna ülem leidis sealt Aleksandria laeva, mis purjetas Itaaliasse, pani ta meid selle pardale. ");
INSERT INTO ekk_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Palju päevi liikusime vaevaliselt edasi ja meil oli raskusi saada Knidose kohale. Ja kui tuul ei lasknud meid randa, siis me purjetasime Kreeta varju Salmoone kohal. ");
INSERT INTO ekk_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Liikusime vaevaga mööda rannajoont ning jõudsime paika, mida kutsutakse Heaks Sadamaks ja mille lähedal on Lasaia linn. ");
INSERT INTO ekk_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Me olime kaotanud palju aega ja laevasõit oli muutunud ohtlikuks, sest lepituspäev oli möödas. Nii hoiatas Paulus neid: ");
INSERT INTO ekk_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","„Mehed, ma näen, et meie reis saab olema katastroofiline ja toob suurt kahju laevale ja lastile ning ka meie enda elule.“ ");
INSERT INTO ekk_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Kuid sadakonna ülem järgis tüürimehe ja laevaomaniku nõuandeid, selle asemel et Paulust kuulata. ");
INSERT INTO ekk_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ja et sadam oli talvitamiseks kõlbmatu, otsustas enamus, et peaksime edasi sõitma, lootes jõuda Fööniksisse ja seal talvituda. See oli Kreetal asuv sadam, mis oli avatud edelasse ja loodesse. ");
INSERT INTO ekk_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Aga kui õrn lõunatuul hakkas puhuma, nägid nad oma võimalust. Nad hiivasid ankru ja liikusid mööda Kreeta rannajoont. ");
INSERT INTO ekk_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Aga üsna pea sööstis saare poolt alla marutuul, mida hüütakse kirdemaruks. ");
INSERT INTO ekk_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","See kiskus laeva endaga kaasa. Kuna kursil püsimine oli võimatu, siis lihtsalt triivisime. ");
INSERT INTO ekk_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Väikese Kauda saare varjus oli torm natuke vaiksem ja me suutsime hädavaevu toime tulla päästepaadiga. ");
INSERT INTO ekk_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Mehed tõmbasid selle pardale. Seejärel tõmmati köied laeva alt läbi, et seda koos hoida. Ja kuna kardeti paiskuda Sürtise liivaribadel madalikule, võeti purjed maha ja jäeti laev triivima. ");
INSERT INTO ekk_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Aga laev sai tormist nii palju vintsutada, et järgmisel päeval loopisid nad osa lasti merre. ");
INSERT INTO ekk_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Kolmandal päeval heitsid nad oma kätega üle parda ka laeva varustuse. ");
INSERT INTO ekk_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Aga kui mitu päeva ei paistnud ei päikest ega tähti ja maru läks väga kangeks, kaotasime lõpuks lootuse jääda ellu. ");
INSERT INTO ekk_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Pärast seda, kui nad olid pikka aega olnud söömata, tõusis Paulus nende ette ja ütles: „Mehed, te oleksite pidanud minu sõna kuulama ja Kreetalt mitte väljuma. Siis te oleks vältinud neid purustusi ja kahju. ");
INSERT INTO ekk_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Nüüd ma aga kutsun teid olema julged, sest keegi teie seast ei hukku, hukkub ainult laev. ");
INSERT INTO ekk_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Täna öösel seisis minu kõrval selle Jumala ingel, kelle oma ma olen ja keda ma ka teenin ");
INSERT INTO ekk_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ja ütles: „Ära karda, Paulus! Sa pead jõudma keisri ette; ja Jumal on sulle kinkinud kõigi nende elud, kes koos sinuga sõidavad.“ ");
INSERT INTO ekk_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Seepärast, mehed, olge julged, sest ma usun Jumalat, et kõik sünnib täpselt nii, nagu mulle on öeldud! ");
INSERT INTO ekk_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Sellegipoolest peame ühel saarel maale minema.“ ");
INSERT INTO ekk_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Neljateistkümnendal ööl triivisime me ikka veel Aadria merel, kui südaöö paiku tajusid meremehed, et me läheneme maale. ");
INSERT INTO ekk_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Loodimisel nad leidsid, et vesi oli umbes nelikümmend meetrit sügav. Kui nad natukese aja pärast olid edasi jõudnud, loodisid nad uuesti ja leidsid, et vesi oli kolmkümmend meetrit sügav. ");
INSERT INTO ekk_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Kartes, et me paiskume karile, heitsid nad laeva ahtrist välja neli ankrut ja jäid ootama päevavalgust. ");
INSERT INTO ekk_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Aga kui meremehed püüdsid laevast põgeneda ja hakkasid päästepaati merre laskma, teesklesid nad, nagu tahaksid nad veel mõne ankru laeva ninast sisse lasta. ");
INSERT INTO ekk_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Siis Paulus ütles sadakonna ülemale: „Kui need mehed ei jää laeva, siis te ei pääse eluga!“ ");
INSERT INTO ekk_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Siis lõikasid sõdurid katki köied, mis päästepaati hoidsid, ja lasid sellel minema triivida. ");
INSERT INTO ekk_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Vahetult enne päikesetõusu kutsus Paulus neid kõiki sööma. „Viimased neliteist päeva,“ ütles ta, „olete te olnud pinge all ja ilma toiduta – te pole midagi söönud. ");
INSERT INTO ekk_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nüüd soovitan teil midagi süüa. Te peate ellu jääma. Mitte keegi teist ei kaota peast ühtki juuksekarva!“ ");
INSERT INTO ekk_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Kui ta seda oli öelnud, võttis ta leiva, tänas Jumalat nende kõikide ees, murdis ja hakkas sööma. ");
INSERT INTO ekk_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Siis nende kõikide meel läks heaks ja nad võtsid ka leiba. ");
INSERT INTO ekk_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Kokku oli meid laeval kakssada seitsekümmend kuus inimest. ");
INSERT INTO ekk_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kui nende kõhud said täis, kergendasid nad veel laeva, heites vilja merre. ");
INSERT INTO ekk_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kui valgeks läks, siis nad ei tundnud, mis maa see on; aga nad nägid liivase rannaga lahte, kuhu nad otsustasid, kui nad suudavad, laeva ajada. ");
INSERT INTO ekk_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Nad raiusid ankrud lahti ja jätsid need merre; samal ajal sidusid lahti tüüriaerude köied ja seadsid esipurje tuulde ning püüdsid juhtida laeva ranna poole. ");
INSERT INTO ekk_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ent nad sattusid liivaseljakule ja ajasid laeva sinna kinni. Laeva käil tungis sinna sisse ja jäi kinni, ahter purunes aga lainte möllus tükkideks. ");
INSERT INTO ekk_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Sõdurid kavatsesid vangid ära tappa, et ükski neist ei pääseks ujudes põgenema. ");
INSERT INTO ekk_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Aga sadakonna ülem tahtis päästa Pauluse elu ja takistas neil plaani täide viimast. Ta käskis neil, kes oskavad ujuda, üle parda hüpata ja maale ujuda. ");
INSERT INTO ekk_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Teised pidid sinna jõudma plankudel või muudel laevaosadel. Sel viisil jõudsid kõik tervelt maale. ");
INSERT INTO ekk_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Kui me olime tervelt maale pääsenud, saime teda, et saart hüütakse Maltaks. ");
INSERT INTO ekk_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Saare elanikud osutasid meile ebatavalist lahkust. Nad süütasid lõkke ja võtsid meid selle äärde, sest sadas vihma ja oli külm. ");
INSERT INTO ekk_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulus korjas hunniku hagu, ja kui ta selle tulle pani, tuli kuumusest välja rästik, kes ta kätte kinni hakkas. ");
INSERT INTO ekk_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Kui saare elanikud nägid ussi tema käe küljes rippumas, ütlesid nad üksteisele: „See mees peab küll mõrtsukas olema! Õiguse jumalanna ei luba tal siin elada, kuigi ta on merest pääsenud.“ ");
INSERT INTO ekk_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Paulus aga viskas ussi tulle ja tal ei juhtunud mingit häda. ");
INSERT INTO ekk_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Rahvas ootas, et ta paistetab üles või kukub surnult maha, aga kui nad nägid, et Paulusega ei juhtu midagi ebatavalist, mõtlesid nad ümber ja ütlesid, et ta on jumal. ");
INSERT INTO ekk_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Selle paiga lähedal oli mõis, mis kuulus saare valitsejale Publiusele. Tema võttis meid vastu ja võõrustas meid heldelt kolm päeva. ");
INSERT INTO ekk_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publiuse isa lamas aga palaviku ja kõhutõvega voodis. Paulus läks tema juurde ja pani palvetades käed tema peale ning tegi ta terveks. ");
INSERT INTO ekk_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Kui see oli sündinud, tulid sinna ka teised saarel olevad haiged, ja said terveks. ");
INSERT INTO ekk_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ja nemad austasid meid mitmel viisil, ja kui me olime valmis merele minema, andsid nad meile teekonna jaoks kõik vajaliku. ");
INSERT INTO ekk_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Kolme kuu pärast me läksime sealt merele Aleksandria laevaga, mis oli saarel olnud ületalve ja mille tunnuseks oli Dioskuuride kuju. ");
INSERT INTO ekk_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Me randusime Sürakuusas ja jäime sinna kolmeks päevaks. ");
INSERT INTO ekk_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Sealt me sõitsime edasi ja saabusime Reegiumi. Ja kui järgmisel päeval tõusis lõunatuul, jõudsime teisel päeval Puteolisse. ");
INSERT INTO ekk_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Sealt me leidsime vendi ja õdesid, kelle kutsel jäime nende juurde seitsmeks päevaks. Ja nii me tulime Rooma. ");
INSERT INTO ekk_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ja kui sealsed vennad ja õed meist kuulda said, tulid nad meile vastu Appiuse Foorumini ja Tres Tabernani. Neid inimesi nähes tänas Paulus Jumalat ning sai julgustust. ");
INSERT INTO ekk_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kui me olime saabunud Rooma, lubati Paulusel omaette elada ühe sõduri valve all. ");
INSERT INTO ekk_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Kolm päeva hiljem kutsus Paulus kokku juutide juhid. Kui need olid kogunenud, ütles Paulus neile: „Mu vennad, kuigi mina ei ole teinud midagi meie rahva ja esivanemate kommete vastu, vahistati mind Jeruusalemmas ja anti üle roomlaste kätte. ");
INSERT INTO ekk_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ja kui need mind üle kuulasid, tahtsid nad mind vabaks lasta, sest mul ei olnud ühtki surmasüüd. ");
INSERT INTO ekk_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Aga kui juudid olid selle vastu, olin ma sunnitud pöörduma keisri poole. Mul polnud mingit kavatsust oma rahva vastu süüdistust esitada. ");
INSERT INTO ekk_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Sel põhjusel palusin teid näha ja teiega rääkida. Iisraeli lootuse pärast ma olen kinni ahelates.“ ");
INSERT INTO ekk_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Aga nemad vastasid: „Me ei ole saanud Juudamaalt ühtegi kirja sinu kohta ega ole tulnud siia ühtegi inimest, kes sinust oleks midagi paha teatanud või rääkinud. ");
INSERT INTO ekk_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Aga me tahame siiski sinu käest kuulda, mida sa mõtled, sest me teame, et selle lahkusu vastu räägitakse kõikjal.“ ");
INSERT INTO ekk_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Nad korraldasid ühel päeval Paulusega kokkusaamise ja siis tuli veel rohkem inimesi sinna, kus ta viibis. Neile ta tunnistas ja seletas hommikust õhtuni Jumala riigist ning veenis Moosese Seaduse ja Prohvetite põhjal uskuma Jeesusesse. ");
INSERT INTO ekk_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Mõned lasksid end öeldust veenda, teised aga ei suutnud uskuda. ");
INSERT INTO ekk_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Jõudmata ühisele nõule, lahkusid nad pärast seda, kui Paulus oli öelnud oma viimase sõna: „Püha Vaim rääkis tõtt prohvet Jesaja kaudu teie esivanematele: ");
INSERT INTO ekk_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","„Mine selle rahva juurde ja ütle: „Te küll kuulate, aga ei mõista, te küll vaatate, aga ei näe.“ ");
INSERT INTO ekk_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Selle rahva süda on kalestunud ja nende kõrvakuulmine on nüri ja nad on sulgenud oma silmad. Muidu nad näeksid oma silmadega ja kuuleksid oma kõrvadega ja mõistaksid südamega ning pöörduksid, ja ma teeksin nad terveks.“ ");
INSERT INTO ekk_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Siis olgu teile teada, et see Jumala pääste on läkitatud teistele rahvastele ja nemad võtavad seda kuulda!“ ");
INSERT INTO ekk_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Kui ta seda oli öelnud, läksid juudid ära omavahel ägedalt vaieldes. ");
INSERT INTO ekk_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paulus jäi kaheks aastaks oma üürimajja ja võttis vastu kõiki, kes tema juurde tulid. ");
INSERT INTO ekk_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ta kuulutas Jumala riiki ning õpetas Issandast Jeesusest Kristusest julgelt ja takistusteta!");
INSERT INTO ekk_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Pauluselt, Kristuse Jeesuse sulaselt, kes on kutsutud apostliks ja valitud levitama Jumala evangeeliumi, ");
INSERT INTO ekk_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","mida Jumal on oma prohvetite kaudu Pühakirjas ette tõotanud, ");
INSERT INTO ekk_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","sõnumit tema Pojast – kes maises elus pärines Taaveti soost ");
INSERT INTO ekk_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ja on pühaduse Vaimu väes kinnitatud Jumala Pojaks pärast surnuist ülestõusmist – Jeesusest Kristusest, meie Issandast. ");
INSERT INTO ekk_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Tema läbi me oleme saanud armu ja apostliameti, et levitada usukuulekust tema nime auks mittejuutide keskel, ");
INSERT INTO ekk_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","kelle hulgas teiegi olete kutsutud kuuluma Jeesusele Kristusele. ");
INSERT INTO ekk_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Kõigile Jumala armastatuile Roomas, teile, keda tema on kutsunud pühaks rahvaks: Armu ja rahu teile meie Isalt Jumalalt ja Issandalt Jeesuselt Kristuselt! ");
INSERT INTO ekk_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Kõigepealt ma tänan oma Jumalat Jeesuse Kristuse kaudu teie kõigi eest, sest teie usust kõneldakse kogu maailmas. ");
INSERT INTO ekk_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Sest Jumal, keda ma oma vaimus teenin, levitades evangeeliumi tema Pojast, võib tunnistada, kuidas ma teid alatasa meenutan ");
INSERT INTO ekk_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","oma palveis igal ajal ja anun, et mul Jumala tahtel ehk lõpuks ometi läheks korda teid külastada. ");
INSERT INTO ekk_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ma ju igatsen teid näha, et võiksin anda teile vaimulikult midagi, mis teeb teid tugevaks; ");
INSERT INTO ekk_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","see tähendab, et saaksime vastastikku julgustust üksteiselt – teie minu ja mina teie usu läbi. ");
INSERT INTO ekk_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Ärgu olgu teil teadmata, vennad ja õed, et ma olen palju kordi kavatsenud teid külastada, et mul võiks olla vilja ka teie keskel, nii nagu teiste mittejuutide seas, aga siiani on mind ikka takistatud. ");
INSERT INTO ekk_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ma olen ju võlglane nii kreeklaste kui võõramaalaste, nii tarkade kui rumalate ees; ");
INSERT INTO ekk_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","seepärast olen täis tahtmist kuulutada evangeeliumi ka teie juures Roomas. ");
INSERT INTO ekk_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ma ei häbene evangeeliumi, sest see on Jumala vägi päästeks igaühele, kes usub – esmalt juudile, siis ka mittejuudile. ");
INSERT INTO ekk_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Sest evangeeliumis avaldub see, kuidas Jumal inimesi õigeks teeb – algusest lõpuni usu alusel, nõnda nagu on kirjutatud: „Õige jääb usust elama!“ ");
INSERT INTO ekk_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Kuid Jumala viha avaldub taevast inimeste kogu kurjuse ja ülekohtu vastu, mida nad teevad, lämmatades tõde ülekohtuga. ");
INSERT INTO ekk_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Sest see, mida on võimalik teada Jumalast, on nende keskel avalik – Jumal on selle neile avaldanud. ");
INSERT INTO ekk_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Tema nähtamatu olemus, tema muutumatu vägi ja jumalikkus on ju maailma loomisest peale selgesti näha, arusaadavad tema tööde põhjal. Nõnda ei ole neil mingit vabandust, ");
INSERT INTO ekk_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","sest tundes Jumalat, ei ole nad teda ülistanud ja tänanud kui Jumalat, vaid on andunud tühistele targutustele ja nende mõistmatu süda on mattunud pimedusse. ");
INSERT INTO ekk_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Väites end olevat targad, on nad muutunud rumalaks ");
INSERT INTO ekk_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ning kadumatu Jumala kirkuse vahetanud kaduva inimese, lindude, neljajalgsete ja roomajate kujutise vastu. ");
INSERT INTO ekk_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Seepärast on Jumal nad andnud nende südame himudes rüveduse kütkesse, isekeskis oma keha häbistama. ");
INSERT INTO ekk_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Nad on Jumala tõe vahetanud vale vastu ning ülistanud ja teeninud loodut Looja asemel, kes on kiidetud igavesti! Aamen. ");
INSERT INTO ekk_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Seepärast on Jumal andnud nad häbiväärsete himude meelevalda: nende naised on asendanud loomuliku vahekorra loomuvastasega. ");
INSERT INTO ekk_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Samamoodi on mehed loobunud loomulikust vahekorrast naisega ning oma himus süttinud üksteisest; käitunud sündmatult mees mehega ja iseenestes saanud kätte kohase karistuse oma eksimuse eest. ");
INSERT INTO ekk_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Veel enam, kuna nad ei pidanud väärtuslikuks Jumala tundmist, andis Jumal nad kõlvatu mõtteviisi meelevalda tegema seda, mis on väär. ");
INSERT INTO ekk_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Nad on täis kõikvõimalikku ebaõiglust, kurjust, ahnust ja halba; täis kadedust, mõrvu, riidu, kavalust ja pahatahtlikkust. Nad on keelepeksjad, ");
INSERT INTO ekk_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","laimajad, Jumala vihkajad, vägivaldsed, ülbed, hooplejad, leidlikud kurjale, vastuhakkajad vanemaile, ");
INSERT INTO ekk_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","mõistmatud, sõnamurdjad, kalgi südamega, halastamatud. ");
INSERT INTO ekk_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Nad küll teavad hästi Jumala otsust, et need, kes selliseid asju teevad, on surma väärt, kuid ei tee mitte ainult sedasama, vaid kiidavad heaks ka need, kes nii teevad. ");
INSERT INTO ekk_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Seepärast ei ole sinulgi mingit vabandust, kes sa ka iganes oled, sina, kes mõistad kohut! Sest milles sa teise üle kohut mõistad, selles mõistad sa süüdi ka ennast, sest sina, kes sa kohut mõistad, teed sedasama! ");
INSERT INTO ekk_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Me teame, et Jumala kohtuotsus sääraste tegude tegijale on õige. ");
INSERT INTO ekk_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Sina aga, kes teiste üle kohut mõistad, ise aga sedasama teed, kas sa arvad, et sa saad põgeneda Jumala kohtu eest? ");
INSERT INTO ekk_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Või põlgad sa tema helduse, sallivuse ja pika meele rohkust? Kas sa ei saa aru, et Jumala heldus juhib sind meelt parandama? ");
INSERT INTO ekk_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Sa kogud enesele viha oma südame kanguse ja kahetsuseta südamega Jumala viha päevaks, kui tema õiglane kohus saab avalikuks. ");
INSERT INTO ekk_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Jumal „tasub igaühele ta tegude järgi“: ");
INSERT INTO ekk_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","igavest elu neile, kes püsiva heategemise kaudu püüdlevad kirkust, au ja kadumatust, ");
INSERT INTO ekk_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ent viha ja raevu neile, kes on isekad, põlgavad ära tõe ja järgivad kurja. ");
INSERT INTO ekk_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Valu ja vaev saab osaks igale inimhingele, kes teeb kurja – esmalt juudile, siis mittejuudile, ");
INSERT INTO ekk_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","kuid kirkus, au ja rahu igaühele, kes teeb head – esmalt juudile, siis mittejuudile. ");
INSERT INTO ekk_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Sest Jumal ei tee vahet isikute vahel! ");
INSERT INTO ekk_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Kes teevad pattu Seadust tundmata, ka hukkuvad Seadust tundmata, ja kes teevad pattu seadusealustena, mõistetakse süüdi Seaduse alusel. ");
INSERT INTO ekk_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Ei ole ju Seaduse kuuljad õiged Jumala ees, vaid Seaduse täitjad mõistetakse õigeks. ");
INSERT INTO ekk_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Seepärast kui mittejuudid, kellel Seadust ei ole, loomusunnil teevad seda, mida Seadus nõuab, on nad Seadust omamata iseendale seaduseks. ");
INSERT INTO ekk_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Nad näitavad, et Seaduse nõuded on kirjutatud neile südamesse. Seda kinnitab ka nende südametunnistus, kui mõtted neid vaheldumisi süüdistavad või kaitsevad. ");
INSERT INTO ekk_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Minu evangeeliumi kohaselt sünnib see päeval, kui Jumal Jeesuse Kristuse läbi mõistab kohut inimeste saladuste üle. ");
INSERT INTO ekk_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Kuidas on lugu sinuga, kes sa nimetad end juudiks? Sa loodad Seadusele, sa kiitled Jumalast, ");
INSERT INTO ekk_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","sa tunned tema tahet ja oskad eristada olulist, sest sa oled seda Seadusest õppinud. ");
INSERT INTO ekk_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Sul on kindel veendumus, et sina oled pimedate teejuht, pimeduses olijate valgus, ");
INSERT INTO ekk_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","arutute juhendaja, väetimate õpetaja, sest on ju teadmine ja tõde sinu päralt Seaduse kujul. ");
INSERT INTO ekk_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Kuidas siis sina, kes sa õpetad teisi, ennast ei õpeta? Sa kuulutad: „Ära varasta!“, aga ise varastad? ");
INSERT INTO ekk_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Sa ütled: „Ära riku abielu!“, aga ise rikud abielu? Sa jälestad ebajumalaid, aga riisud Templit? ");
INSERT INTO ekk_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Sa uhkustad Seadusega, aga oma üleastumisega Seadusest sa heidad halba varju Jumalale! ");
INSERT INTO ekk_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Sest nagu Pühakirjas öeldakse: „Teie pärast teotatakse Jumala nime mittejuutide seas!“ ");
INSERT INTO ekk_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ümberlõikamisest on ju tõesti kasu, kui sa toimid Seaduse järgi. Aga kui sa Seadust rikud, ei ole sa millegi poolest parem ümberlõikamatuist. ");
INSERT INTO ekk_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Seepärast, kui mõni ümberlõikamatu Seaduse nõudeist kinni peab, eks loeta siis ta võrdseks ümberlõigatutega? ");
INSERT INTO ekk_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ja see ihu poolest ümberlõikamatu, kes järgib Seadust, mõistab kord kohut sinu üle, kes sa rikud Seadust kirjatähest ja ümberlõikamisest hoolimata. ");
INSERT INTO ekk_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Sest juut ei ole ju see, kes seda on väliselt, ja ümberlõikamine see, mida ihul võib näha, ");
INSERT INTO ekk_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","vaid juut on see, kes seda on sisemiselt, ja ümberlõikamine on südame ümberlõikamine Vaimu läbi, mitte kirjutatud käsu läbi. Selline saab kiituse mitte inimestelt, vaid Jumalalt. ");
INSERT INTO ekk_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Mis eelis on siis juudil või mis kasu on ümberlõikamisest? ");
INSERT INTO ekk_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Palju ja igas suhtes! Kõigepealt, nende kätte usaldati Jumala sõnumid. ");
INSERT INTO ekk_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ja mis siis, kui mõned pole olnud ustavad? Kas nende ebaustavus tühistab Jumala ustavuse? ");
INSERT INTO ekk_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Kaugeltki mitte! Jumal on sõnapidaja, olgugi iga inimene valelik; sest nagu Pühakirjas öeldakse: „Et su sõnad osutuksid õigeks ja sa võidaksid kohtumõistmisel!“ ");
INSERT INTO ekk_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Aga kui meie ebaõiglus toob esile Jumala õigluse, mida siis öelda? Kas ehk Jumal on ebaõiglane – ma räägin inimlikust seisukohast –, kui ta meid karistab vihas? ");
INSERT INTO ekk_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Kaugeltki mitte! Sest kuidas saaks Jumal sel juhul üldse mõista kohut maailma üle? ");
INSERT INTO ekk_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Aga kui Jumala tõde minu valelikkuse läbi saab üha rohkem temale kirkuseks, miks mina siiski kohtu alla lähen patusena? ");
INSERT INTO ekk_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Miks mitte öelda: „Tehkem kurja, et sellest võiks sündida head!“, nagu mõned laimajad on väitnud mind rääkivat? Nemad ei jää ilma oma teenitud karistusest! ");
INSERT INTO ekk_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Mis me sellest järeldame? Kas meil on eeliseid? Üldsegi mitte! Oma süüdistuskõnes eelpool oleme me juba selgeks teinud, et nii juudid kui mittejuudid on patu võimu all. ");
INSERT INTO ekk_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Sest on ju kirjutatud: „Ei ole ühtki õiget, ei ühtainustki. ");
INSERT INTO ekk_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ei ole ühtki, kes mõistaks, ei ühtki, kes otsiks Jumalat. ");
INSERT INTO ekk_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Kõik on kaldunud kõrvale, läinud koguni raisku. Ei ole ühtki, kes teeks head, ei ühtainustki.“ ");
INSERT INTO ekk_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","„Nende kõri on lahtine haud, oma keelega nad petavad.“ „Nende huulte taga on madude mürk.“ ");
INSERT INTO ekk_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","„Nende suu on täis needmist ja kibedust.“ ");
INSERT INTO ekk_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","„Nende jalad ruttavad valama verd, ");
INSERT INTO ekk_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","häving ja viletsus on kõigil nende teedel, ");
INSERT INTO ekk_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ja rahu teed nad ei tunne.“ ");
INSERT INTO ekk_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","„Jumalakartust ei ole nende silme ees.“ ");
INSERT INTO ekk_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Aga me teame, et kõik Seaduse sõnad on suunatud neile, kes on Seaduse all, et keegi ei saaks ennast õigustada ja kogu maailm saaks vastutavaks Jumala ees. ");
INSERT INTO ekk_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Sest Seadusest kinnipidamise alusel ei mõisteta ühtki inimest õigeks tema ees; Seaduse kaudu saame me teadlikuks patust. ");
INSERT INTO ekk_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Nüüd aga on Seadusest lahus saanud avalikuks Jumala tee õigeksmõistmisele, millest tunnistavad Seadus ja Prohvetid. ");
INSERT INTO ekk_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","See õigeksmõistmine Jumala poolt kuulub Jeesusesse Kristusesse uskumise alusel kõigile usklikele. Sest ei ole mingit vahet juudil ja mittejuudil: ");
INSERT INTO ekk_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","kõik on pattu teinud ja on Jumala aust ilma, ");
INSERT INTO ekk_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","kuid mõistetakse õigeks tema armust täiesti muidu, Kristuses Jeesuses oleva lunastuse kaudu. ");
INSERT INTO ekk_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Et osutada oma õigust, on Jumal seadnud Jeesuse kõigile kättesaadavaks lepitusohvriks, mis toimib usu kaudu tema surmasse. Sest oma kannatlikkuses oli ta jätnud varasemad patud karistamata, ");
INSERT INTO ekk_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","et osutada oma õigust praegusel ajal, sest tema ise on õige ja mõistab õigeks igaühe, kes usub Jeesusesse. ");
INSERT INTO ekk_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Kuhu jääb nüüd kiitlemine? See on välistatud. Millise seaduse pärast? Kas selle, mis nõuab tegusid? Ei, vaid usu seaduse pärast. ");
INSERT INTO ekk_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Sest meie seisukoht on, et inimene mõistetakse õigeks usu läbi, sõltumata Seaduse tegudest. ");
INSERT INTO ekk_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Või ehk on Jumal ainult juutide Jumal? Eks ole ta ka Jumal mittejuutidele? Jah, ta on ka mittejuutide Jumal! ");
INSERT INTO ekk_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Jumal on üksainus, kes mõistab usu läbi õigeks nii ümberlõigatu kui ümberlõikamatu. ");
INSERT INTO ekk_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Kas me siis tühistame Seaduse usuga? Kaugeltki mitte! Me hoopis kinnitame Seadust. ");
INSERT INTO ekk_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Mis me siis ütleme oma lihase esivanema Aabrahami kohta? Milline oli tema kogemus? ");
INSERT INTO ekk_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Kui Aabraham oleks tegude alusel õigeks mõistetud, siis oleks tal põhjust kiitlemiseks, aga mitte Jumala ees. ");
INSERT INTO ekk_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Sest mida Pühakirjas öeldakse? „Aabraham uskus Jumalat, ja see arvati talle õiguseks.“ ");
INSERT INTO ekk_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Sellele, kes teeb tegusid, ei arvestata tasu mitte armust, vaid võlgnevuse tõttu temale. ");
INSERT INTO ekk_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ent kui keegi tegusid tegemata usub temasse, kes jumalatu õigeks mõistab, siis arvestatakse õigeksmõistmise alusena tema usku. ");
INSERT INTO ekk_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Samuti nimetab Taavet õnnistatuks inimest, keda Jumal arvestab õigeksmõistetuks tegudest sõltumata: ");
INSERT INTO ekk_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","„Õnnistatud on need, kelle ülekohus on andeks antud ja kelle patud on kinni kaetud. ");
INSERT INTO ekk_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Õnnistatud on inimene, kelle pattu Issand ei arvesta.“ ");
INSERT INTO ekk_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Kas see õndsus kuulub siis ainult ümberlõigatuile, või ehk ka ümberlõikamatuile? Me ju ütleme: „Aabrahami usk arvati talle õiguseks.“ ");
INSERT INTO ekk_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Mis olukorras seda siis arvati? Kas sellal, kui ta oli ümberlõigatu või kui ta oli veel ümber lõikamata? Ta ei olnud siis ümber lõigatud, vaid oli tõesti veel ümber lõikamata! ");
INSERT INTO ekk_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ning ta võttis vastu ümberlõikamise märgi selle õigeksmõistmise kinnituseks, mis tal oli juba ümberlõikamatuna oma usu tõttu. Nõnda sai ta kõigi nende esiisaks, kes on ümber lõikamata, aga kes usuvad, ning seda arvestatakse nende õigeksmõistmise alusena. ");
INSERT INTO ekk_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Samuti sai ta nende ümberlõigatute esiisaks, kes on mitte ainult ümber lõigatud, vaid ka elavad selle usu eeskujul, mis oli meie esiisal Aabrahamil juba enne ümberlõikamist. ");
INSERT INTO ekk_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Sest tõotust, et temast saab maailma pärija, ei antud Aabrahamile ega ta järelsoole mitte Seaduse kaudu, vaid usu põhjal omistatud õigeksmõistmise kaudu. ");
INSERT INTO ekk_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Kui pärimine toimuks Seadusest kinnipidamise alusel, siis kaotaks usk sisu ja tõotus kehtivuse, ");
INSERT INTO ekk_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","sest Seaduse tõttu tuleb viha; aga kus pole seadust, seal pole ka üleastumist. ");
INSERT INTO ekk_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Seepärast toimub pärimine usu alusel, et see oleks armust, ja et tõotus kehtiks kindlalt kogu Aabrahami järelsoole – mitte ainult neile, kel on Seadus, vaid ka neile, kes usuvad nõnda nagu Aabraham. On ju tema meie kõigi isa, ");
INSERT INTO ekk_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","nagu Pühakirjas öeldakse: „Ma olen sind seadnud paljude rahvaste isaks!“ Selle tunnistajaks on Jumal, keda ta uskus, Jumal, kes teeb surnud elavaks ja kutsub esile olematuid asju otsekui olevaid. ");
INSERT INTO ekk_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Lootes üle loodetava, uskus Aabraham, et temast saab paljude rahvaste isa, nagu talle oli öeldud: „Nii saavad olema sinu järeltulijad!“ ");
INSERT INTO ekk_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Tema usk ei raugenud teadmisest, et tema ligi saja-aastane keha oli samahästi kui surnud ja Saara üsast polnud iial sündinud elu. ");
INSERT INTO ekk_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ta ei kahelnud Jumala tõotuses uskmatuna, vaid sai tugevaks usus, austades Jumalat ");
INSERT INTO ekk_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","kindla veendumusega, et Jumal suudab oma tõotuse ka täita. ");
INSERT INTO ekk_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Sellepärast see arvati talle õiguseks. ");
INSERT INTO ekk_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Aga et see temale arvati õiguseks, on pandud kirja mitte üksnes tema, ");
INSERT INTO ekk_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","vaid ka meie pärast, kellele see samuti arvestatakse õiguseks, sest me usume temasse, kes äratas surnuist üles meie Issanda Jeesuse, ");
INSERT INTO ekk_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","kes anti surma meie eksimuste pärast ja äratati üles meie õigeksmõistmiseks. ");
INSERT INTO ekk_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Seepärast, kuna meid on õigeks mõistetud usu alusel, siis on meil rahu Jumalaga meie Issanda Jeesuse Kristuse läbi. ");
INSERT INTO ekk_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Tema läbi me oleme usus saanud ka ligipääsu sellele armule, milles me püsime, ja võime julgelt rõõmutseda lootuse üle saada osa Jumala kirkusest. ");
INSERT INTO ekk_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Aga mitte ainult seda – me rõõmutseme ka kannatuste üle, sest me teame, et kannatusest sünnib vastupidavus, ");
INSERT INTO ekk_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","vastupidavusest iseloomukindlus ja iseloomukindlusest lootus. ");
INSERT INTO ekk_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Ja see lootus ei jäta häbisse, sest Jumala armastus on välja valatud meie südameisse Püha Vaimu läbi. ");
INSERT INTO ekk_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Sest Kristus on, kui me alles nõdrad olime, ettenähtud ajal surnud jumalatute eest. ");
INSERT INTO ekk_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Vaevalt sureb ju keegi isegi õiglase inimese eest, ehk küll mõnel võib olla julgust surra hea inimese eest, ");
INSERT INTO ekk_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","aga Jumal näitab oma armastust meie vastu sellega, et Kristus suri meie eest, kui me olime alles patused. ");
INSERT INTO ekk_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Aga kui meid nüüd on tema vere hinnaga õigeks mõistetud, siis seda enam päästetakse meid tema kaudu ka viha eest. ");
INSERT INTO ekk_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Sest kui meid juba Jumala vaenlastena lepitati temaga ta Poja surma läbi, siis seda enam päästetakse meid tema elu läbi nüüd, kus me oleme lepitatud. ");
INSERT INTO ekk_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Aga mitte ainult seda, vaid me ka rõõmutseme julgesti Jumala üle meie Issanda Jeesuse Kristuse läbi, kelle kaudu me nüüd oleme võtnud vastu lepituse. ");
INSERT INTO ekk_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Seepärast, nii nagu ühe inimese kaudu on patt tulnud maailma ja patu kaudu surm, samal viisil on ka surm tulnud kõigile inimestele, sest kõik on pattu teinud. ");
INSERT INTO ekk_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Oli ju patt maailmas ka enne Seadust, aga kui Seadust ei ole, siis pattu ei arvestata. ");
INSERT INTO ekk_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Siiski valitses surm Aadamast Mooseseni ka nende üle, kes ei teinud pattu käsust üle astudes nagu Aadam, kes oli eeltähenduseks temast, kes pidi tulema. ");
INSERT INTO ekk_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Kuid Jumala armuanniga ei ole lugu nii nagu üleastumisega! Sest kui ühe inimese eksimus on toonud surma paljudele, siis on paljudele võrratult rohkem osaks saanud Jumala arm ja and ühe Inimese, Jeesuse Kristuse armu kaudu. ");
INSERT INTO ekk_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Jumala and on tõesti erinev sellest, mis juhtus ühe inimese patustamise tõttu. Sest selle ühe eksimuse järel tulnud kohtuotsus tõi süüdimõistmise, aga paljude eksimuste järel tulnud and tõi õigeksmõistmise. ");
INSERT INTO ekk_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Sest kui surm sai ühe inimese eksimuse tõttu selle ühe kaudu võimule, siis kui palju enam neile, kes võtavad vastu Jumala õigeksmõistmise küllusliku armuanni, kuulub elu ja valitsus selle ühe – Jeesuse Kristuse – kaudu! ");
INSERT INTO ekk_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Niisiis, nagu ühe eksimuse läbi tuli kõigile inimestele hukkamõistmine, nõnda on ka selle ühe õige teo läbi kõigile inimestele saanud õigeksmõistmine eluks. ");
INSERT INTO ekk_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Sest nii nagu ühe inimese sõnakuulmatuse läbi tehti paljud patuseks, nõnda tehakse ühe inimese sõnakuulelikkuse läbi paljud Jumala ees õigeks. ");
INSERT INTO ekk_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Seadus aga on lisandunud selleks, et eksimus suureneks. Ent kus patt on suurenenud, seal on ka arm saanud ülikülluslikuks, ");
INSERT INTO ekk_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","et nii nagu patt on valitsenud surmas, valitseks nüüd ka arm õigeksmõistmise läbi, mis viib igavesse ellu meie Issanda Jeesuse Kristuse läbi. ");
INSERT INTO ekk_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Mis me siis ütleme? Kas peaksime püsima patus, et arm suureneks? ");
INSERT INTO ekk_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Kaugeltki mitte! Kuidas võiksime meie, kes oleme patule surnud, veel patus elada? ");
INSERT INTO ekk_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Või kas te ei tea, et kõik, kes me oleme Kristusesse Jeesusesse ristitud, oleme ristitud tema surmasse? ");
INSERT INTO ekk_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Seepärast on meid koos temaga ka hauda maetud ristimise kaudu surmasse, et nii nagu Kristus on äratatud surnuist üles Isa kirkuse toimel, nõnda võime meiegi käia uues elus. ");
INSERT INTO ekk_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Sest kui meid on liidetud tema surma sarnasusse, siis liidetakse meid ka tema ülestõusmisse. ");
INSERT INTO ekk_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Me teame, et meie vana loomus on koos Kristusega risti löödud, et meie patune ihu häviks ja me ei peaks enam orjama pattu; ");
INSERT INTO ekk_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","sest surres vabanetakse patu võimu alt. ");
INSERT INTO ekk_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Aga kui me oleme surnud koos Kristusega, siis usume, et me ka elame koos Kristusega. ");
INSERT INTO ekk_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Me ju teame, et nüüd, kui Kristus on surnuist üles äratatud, ei sure ta enam; surmal pole võimu tema üle. ");
INSERT INTO ekk_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Sest surres suri ta patule üks kord ja alatiseks, kuid elades elab ta Jumalale. ");
INSERT INTO ekk_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Samuti arvestage ka teie, et olete surnud patule, kuid elate Jumalale Kristuses Jeesuses. ");
INSERT INTO ekk_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Seepärast ärge laske patul valitseda oma surelikus ihus, kuuletudes selle ihadele. ");
INSERT INTO ekk_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Ärge andke oma ihuliikmeid ülekohtu relvadeks patule, vaid nõnda kui need, kes on äratatud surnuist üles, andke end Jumala teenistusse ja oma ihuliikmed õiguse relvadeks temale! ");
INSERT INTO ekk_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Sest patt ei valitse enam teie üle; te ei kuulu enam Seaduse, vaid armu alla. ");
INSERT INTO ekk_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Mis me sellest järeldame? Kas peaksime tegema pattu, kuna me ei kuulu Seaduse, vaid armu alla? Kaugeltki mitte! ");
INSERT INTO ekk_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Kas te ei tea, et kelle teenistusse te end orjana kuuletudes annate, selle orjad te olete ja selle sõna kuulate – kas siis patu orjad surmaks või kuulekuse orjad õiguseks. ");
INSERT INTO ekk_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Aga tänu Jumalale, et teie, kes te varem olite patu orjad, olete nüüd südames kuuletunud sellele õpetusele, mille hoolde teid anti. ");
INSERT INTO ekk_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Patust vabastatuina olete saanud õiguse teenriteks. ");
INSERT INTO ekk_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Teie inimliku nõrkuse tõttu kasutan ma neid võrdlusi igapäevaelust. Nii nagu te enne andsite oma liikmed orjaks rüvedusele ja üha kasvavale ülekohtule, nii andke nad nüüd õiguse teenritena pühitsuse jaoks. ");
INSERT INTO ekk_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Jah, kui te pattu orjasite, siis te olite vabad õigusest. ");
INSERT INTO ekk_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Mis vilja te kandsite siis? Sellist, mille pärast te nüüd häbenete, sest selle tulemus on surm. ");
INSERT INTO ekk_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Aga nüüd, olles vabastatud patu võimust ja saanud Jumala teenriteks, te kannate vilja pühitsuseks. Selle tulemuseks on igavene elu. ");
INSERT INTO ekk_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Sest patu palk on surm, aga Jumala armuand on igavene elu Kristuses Jeesuses, meie Issandas. ");
INSERT INTO ekk_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Vennad ja õed, kas te ei tea – ma räägin neile, kes tunnevad seadust –, et seadusel on võim inimese üle vaid seni, kuni too elab. ");
INSERT INTO ekk_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Abielunaine on seaduslikult seotud oma mehega ta eluajal. Aga kui mees sureb, vabaneb naine kohustustest mehe ees. ");
INSERT INTO ekk_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Seepärast, kui ta mehe eluajal on teise mehega, nimetatakse teda abielurikkujaks. Aga kui mees sureb, on naine vaba seaduse alt, nii et ta ei ole teisele mehele minnes abielurikkuja. ");
INSERT INTO ekk_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Seega, mu vennad ja õed, teiegi olete surmatud Seadusele Kristuse ihu kaudu, et te kuuluksite teisele, kes on üles äratatud surnuist, et me kannaksime vilja Jumalale. ");
INSERT INTO ekk_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Sest kui me veel rikutud loomuse võimuses elasime, toimisid me liikmeis patused kired, mis said tugevaks Seaduse tõttu, ja me kandsime vilja surmale. ");
INSERT INTO ekk_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Aga nüüd me oleme vabanenud Seaduse võimusest, sest me surime sellele, mis meid kinni pidas. Enam ei teeni me Jumalat vanal viisil, kirjatähe järgi, vaid uuel viisil, Vaimus. ");
INSERT INTO ekk_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Mis me siis ütleme? Kas Seadus on patt? Kaugeltki mitte! Siiski, ma ei oleks tundnud pattu muidu kui Seaduse kaudu. Ma ei oleks teadnud, mida tähendab himustamine, kui Seadus poleks öelnud: „Ära himusta!“ ");
INSERT INTO ekk_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Aga patt, saades tõuget käsust, tekitas minus kõikvõimalikke himusid. Sest ilma Seaduseta on patt surnud. ");
INSERT INTO ekk_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Mina elasin kord lahus Seadusest. Kui nüüd käsk tuli, ärkas patt ellu ");
INSERT INTO ekk_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ja mina surin. Seadus, mis pidi olema mulle eluks, osutus mulle surmaks. ");
INSERT INTO ekk_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Sest kui patt oli saanud käsusõnast tõuke, pettis ta mind ja tappis mind käsu abil. ");
INSERT INTO ekk_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Seega on Seadus püha ning käsk on püha, õiglane ja hea. ");
INSERT INTO ekk_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Kas nüüd see hea on mulle saanud surmaks? Kaugeltki mitte. Aga et patt oleks nähtav patuna, on see toonud selle hea kaudu mulle surma. Nii sai patt käsu abil ülimalt patuseks. ");
INSERT INTO ekk_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Me ju teame, et Seadus on vaimulik, mina aga lihalik, müüdud orjaks patu võimusesse. ");
INSERT INTO ekk_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Sest ma ei mõista oma tegusid. Ma ei tee seda, mida tahan, vaid ma teen, mida vihkan. ");
INSERT INTO ekk_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Aga kui ma teen, mida ma ei taha, siis ma nõustun, et Seadus on hea. ");
INSERT INTO ekk_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Nii ei tee seda enam mina, vaid minus pesitsev patt. ");
INSERT INTO ekk_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Sest ma tean, et minus, see tähendab mu rikutud loomuses, ei peitu midagi head. Tahet mul on, aga head teha ma ei suuda. ");
INSERT INTO ekk_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Sest ma ei tee head, mida ma tahan, vaid üksnes halba, mida ma ei taha. ");
INSERT INTO ekk_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Aga kui ma teen just seda, mida ma ei taha, siis ei ole see enam mina, kes tegutseb, vaid minus pesitsev patt. ");
INSERT INTO ekk_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Seega avastan ma seaduse: kuigi ma tahan teha head, on mulle omane teha kurja. ");
INSERT INTO ekk_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Sest oma sisemise inimesega ma tunnen rõõmu Jumala Seadusest, ");
INSERT INTO ekk_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","kuid oma liikmetes näen ma teist seadust, mis sõdib vastu minu mõistuse seadusele ja võtab mind vangi mu liikmeis oleva patu seaduse alla. ");
INSERT INTO ekk_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Oh mind armetut inimest! Kes päästab mind sellest surmale määratud ihust? ");
INSERT INTO ekk_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Aga tänu Jumalale, meie Issanda Jeesuse Kristuse läbi! Niisiis, ma teenin mõistusega küll Jumala Seadust, aga oma rikutud loomusega patu seadust. ");
INSERT INTO ekk_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Nõnda siis ei ole nüüd mingit hukkamõistmist neile, kes on Kristuses Jeesuses. ");
INSERT INTO ekk_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Sest elu Vaimu seadus Kristuses Jeesuses on vabastanud su patu ja surma seadusest. ");
INSERT INTO ekk_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Mis Moosese Seadusele oli võimatu – sest tal polnud jõudu inimloomuse vastu – seda tegi Jumal. Ta läkitas oma Poja patuse liha sarnasuses patuohvrina ja karistas pattu surmaga tema inimkehas. ");
INSERT INTO ekk_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Ta tegi seda selleks, et Seaduse õigusenõuded oleksid täidetud meis, kes me ei ela mitte oma rikutud loomuses, vaid kooskõlas Vaimuga. ");
INSERT INTO ekk_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Sest need, kes elavad iseka loomuse järgi, mõtlevad lihalikke mõtteid, aga kes elavad Vaimu järgi, need mõtlevad sellele, mida Vaim tahab. ");
INSERT INTO ekk_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Lihalik mõtteviis on surm, Vaimu mõtteviis aga elu ja rahu. ");
INSERT INTO ekk_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Sest lihalik mõtteviis on vaen Jumala vastu; see ei allu Jumala Seadusele ega suudagi seda teha. ");
INSERT INTO ekk_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Kes on oma liha meelevallas, ei saa meeldida Jumalale. ");
INSERT INTO ekk_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Kuid teie ei ela oma loomuses, vaid Vaimus, kui Jumala Vaim tõepoolest elab teie sees. Aga kellel ei ole Kristuse Vaimu, see ei ole tema oma. ");
INSERT INTO ekk_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Aga kui Kristus on teie sees, siis on küll ihu patu tõttu surnud, aga Vaim on õigeksmõistmise tõttu elus. ");
INSERT INTO ekk_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ja kui teis elab selle Vaim, kes Jeesuse surnust üles äratas, siis tema, kes Kristuse surnust üles äratas, teeb teiegi surelikud kehad elavaks oma Vaimu läbi, kes teis elab. ");
INSERT INTO ekk_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Nõnda siis, vennad ja õed, me ei ole võlgu oma rikutud loomusele, et peaksime selle järgi elama – ");
INSERT INTO ekk_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","sest kui te oma loomuse järgi elate, siis te surete. Aga kui te Vaimu abil ihu teod surmate, siis te elate. ");
INSERT INTO ekk_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Sest kõik, keda iganes Jumala Vaim juhib, on Jumala lapsed. ");
INSERT INTO ekk_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Te ei ole ju saanud orjastavat vaimu, et peaksite jälle kartma, vaid olete saanud lapseõiguse Vaimu, kelles me hüüame: „Abba! Isa!“ ");
INSERT INTO ekk_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Seesama Vaim tunnistab koos meie vaimuga, et me oleme Jumala lapsed. ");
INSERT INTO ekk_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Aga kui me oleme lapsed, siis oleme ka pärijad, nii Jumala pärijad kui Kristuse kaaspärijad; kui me koos temaga kannatame, siis meid ka koos temaga kirgastatakse. ");
INSERT INTO ekk_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Ma leian, et käesoleva aja kannatused ei ole kõneväärt võrreldes kirkusega, mis meis peab avalikuks saama. ");
INSERT INTO ekk_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Sest kogu loodu ootab pikisilmi Jumala laste avalikukssaamist. ");
INSERT INTO ekk_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","On ju kogu loodu allutatud kaduvusele – mitte omal valikul, vaid allutaja tahtel, lootuses, ");
INSERT INTO ekk_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","et ka loodu ise vabastatakse kord lagunemise orjusest ning tuuakse Jumala laste kirkuse vabadusse. ");
INSERT INTO ekk_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Me ju teame, et kogu loodu ägab üheskoos sünnitusvaludes tänini. ");
INSERT INTO ekk_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Aga veel enam, ka meie, kes me oleme saanud esimese annina Püha Vaimu, meiegi ägame endamisi, oodates lapseõigust, oma ihu lunastust. ");
INSERT INTO ekk_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Sest me oleme päästetud lootuses. Ent juba nähtava lootmine ei ole lootus. Sest kes loodab veel seda, mis juba on näha? ");
INSERT INTO ekk_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Aga kui me loodame seda, mida ei näe, siis me ootame seda kannatlikult. ");
INSERT INTO ekk_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Samuti tuleb ka Vaim appi meie nõtruses: me ju ei tea, mille eest me peame palvetama, kuid Vaim ise palub meie eest sõnatu ägamisega. ");
INSERT INTO ekk_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ja tema, kes uurib meie südameid, mõistab Vaimu mõtteid, sest Jumala tahtmise järgi palub ta pühade eest. ");
INSERT INTO ekk_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Ent me teame, et neile, kes Jumalat armastavad, laseb Jumal kõik tulla heaks – neile, kes on tema kavatsuse kohaselt kutsutud. ");
INSERT INTO ekk_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Sest neid, keda Jumal on eelnevalt valinud, on ta ka eelnevalt määranud saama tema Poja sarnaseks, et tema oleks esmasündinu paljude vendade seas. ");
INSERT INTO ekk_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ja keda ta on eelnevalt määranud, neid on ta ka kutsunud; ja keda ta on kutsunud, need on ta ka õigeks teinud; ja keda ta on õigeks teinud, neid on ta ka kirgastanud. ");
INSERT INTO ekk_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Mis me siis ütleme, arvestades kõike seda? Kui Jumal on meie poolt, kes suudab olla meie vastu? ");
INSERT INTO ekk_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Tema, kes oma Poegagi ei säästnud, vaid loovutas tema meie kõikide eest, kuidas ta ei peaks siis koos Pojaga meile kõike muud kinkima? ");
INSERT INTO ekk_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Kes võiks süüdistada Jumala valituid? Jumal on see, kes õigeks teeb! ");
INSERT INTO ekk_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Kes võib meid hukka mõista? Kristus Jeesus on, kes suri, kuid veel enam, kes üles äratati, kes on Jumala paremal käel ja kes palub meie eest! ");
INSERT INTO ekk_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Kes võiks lahutada meid Kristuse armastusest? Kas viletsus või ahistus või tagakiusamine või nälg või alastiolek või hädaoht või hukkamine? ");
INSERT INTO ekk_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Nagu on kirjutatud: „Sinu pärast seisame me surmasuus päev otsa, me oleme kui lambad, kes on määratud tapmisele.“ ");
INSERT INTO ekk_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Kuid selles kõiges me võidame ülivõimsalt tema läbi, kes meid on armastanud. ");
INSERT INTO ekk_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Sest ma olen veendunud, et ei surm ega elu, ei inglid ega valitsused, ei miski praegu ega tulevikus, ei väed, ");
INSERT INTO ekk_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ei kõrgus ega sügavus ega miski muu loodu ei suuda lahutada meid Jumala armastusest, mis on Kristuses Jeesuses, meie Issandas. ");
INSERT INTO ekk_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ma räägin tõtt Kristuses, mu südametunnistus koos Püha Vaimuga kinnitab, et ma ei valeta: ");
INSERT INTO ekk_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","mul on südames suur kurbus ja lakkamatu ahastus. ");
INSERT INTO ekk_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Sest ma soovin pigem, et ma ise oleksin neetud ja Kristusest ära lõigatud oma rahva, oma suguvõsa, ");
INSERT INTO ekk_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Iisraeli rahva pärast. Nende päralt on lapseõigus, kirkus ja lepingud, seadustik, templiteenistus ja tõotused. ");
INSERT INTO ekk_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Neile kuuluvad esiisad ja nende hulgast põlvneb Messia ihulikult, kes on Jumal üle kõige, igavesti kiidetav! Aamen. ");
INSERT INTO ekk_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","See pole nii, nagu oleks Jumala sõna ebaõnnestunud. Kaugel sellest! Sest mitte kõik, kes põlvnevad Iisraelist, ei ole Iisrael ");
INSERT INTO ekk_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ja mitte kõik ei ole Aabrahami lapsed sellepärast, et nad on tema järeltulijad. Vastupidi: „Sinu sugu loetakse Iisakist.“ ");
INSERT INTO ekk_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Teisisõnu, mitte lihased lapsed ei ole Jumala lapsed, vaid Aabrahami järglasteks arvatakse tõotuse lapsed. ");
INSERT INTO ekk_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Sest selline oli tõotussõna: „Järgmisel aastal samal ajal tulen ma su juurde ja siis on Saaral poeg!“ ");
INSERT INTO ekk_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Aga see pole ainus näide. Rebeka pojad sündisid ühest ja samast, meie esiisast Iisakist. ");
INSERT INTO ekk_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Kuid Jumala kava pidi teostuma endiselt valiku põhjal, sõltudes mitte inimeste tegudest, vaid kutsujast. Seepärast, veel enne, kui Rebeka pojad sündisid ja midagi head või halba tegid, kuulutati talle: „Vanem orjab nooremat!“ ");
INSERT INTO ekk_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Nagu Pühakirjas öeldakse: „Jaakobit ma armastasin, Eesavit aga vihkasin.“ ");
INSERT INTO ekk_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Mis me siis ütleme? Kas Jumala juures on ebaõiglust? Kaugeltki mitte! ");
INSERT INTO ekk_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Sest ta ütleb Moosesele: „Ma olen armuline, kellele olen armuline, ja halastan, kellele halastan.“ ");
INSERT INTO ekk_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Nõnda siis ei sõltu see inimese tahtest või pingutusest, vaid Jumalast, kes halastab. ");
INSERT INTO ekk_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Sest vaaraole öeldakse Pühakirjas: „Just selleks olen ma sind esile tõstnud, et näidata sinu varal oma väge, ja et minu nime kuulutataks üle kogu maa.“ ");
INSERT INTO ekk_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Nõnda siis Jumal annab armu, kellele tahab, ja kalestab, keda tahab. ");
INSERT INTO ekk_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","„Miks ta siis veel etteheiteid teeb?“ ütled sa nüüd mulle. „Sest kes on iial saanud seista vastu tema tahtele?“ ");
INSERT INTO ekk_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Ent kes oled sina, oh inimene, et arvustad Jumalat? Ei ütle ju vormitud kuju oma vormijale: „Miks sa mind selliseks tegid?“ ");
INSERT INTO ekk_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Või kas pole pottsepal voli valmistada samast savikamakast üks anum ülemaks ja teine alamaks otstarbeks? ");
INSERT INTO ekk_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Aga kui Jumal selliselt tegutseb? Tahtes ilmutada oma viha ja avaldada oma väge, on ta ülima kannatlikkusega talunud hävitamiseks tehtud vihaanumaid, ");
INSERT INTO ekk_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","et avaldada oma rikkalikku kirkust halastuseanumaile, mida ta on ette valmistanud kirkuseks. ");
INSERT INTO ekk_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Selleks ongi ta kutsunud meid mitte ainult juutide, vaid ka mittejuutide seast. ");
INSERT INTO ekk_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Nagu ka Hoosea raamatus öeldakse: „Ma kutsun oma rahvaks teda, kes ei olnud minu rahvas, ja armastatuks teda, kes ei olnud armastatud.“ ");
INSERT INTO ekk_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Ja, „Paigas, kus neile öeldi: „Teie ei ole mu rahvas!“ seal kutsutakse neid elava Jumala lasteks!“ ");
INSERT INTO ekk_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Aga Jesaja hüüab Iisraeli kohta: „Kuigi iisraellasi oleks nõnda palju nagu mereliiva, päästetakse neist ainult jääk, ");
INSERT INTO ekk_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","sest lõplikult ja kiiresti teeb Issand tõeks oma sõna maa peal.“ ");
INSERT INTO ekk_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Ja nagu Jesaja on ette kuulutanud: „Kui vägede Issand ei oleks jätnud meile järelsugu, siis oleksime kadunud nagu Soodom ja hävinud nagu Gomorra.“ ");
INSERT INTO ekk_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Mis me siis ütleme? Et mittejuudid, kes õigeksmõistmist ei taotlenud, on kätte saanud õigeksmõistmise usu kaudu; ");
INSERT INTO ekk_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","aga Iisrael, kes taotles õigeksmõistmist Seaduse järgi, ei ole Seaduse täitmist saavutanud. ");
INSERT INTO ekk_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Mispärast? Sest nad ei lähtunud usust, vaid arvasid õigeks saavat tegudest. Nad komistasid vastu komistuskivi, ");
INSERT INTO ekk_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","nagu Pühakirjas öeldakse: „Vaata, ma panen Siionisse kivi, mis paneb inimesed komistama, ja kalju, mis paneb nad kukkuma, ja kes temasse usub, ei jää häbisse!“ ");
INSERT INTO ekk_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Vennad ja õed, minu südame igatsus ja palve Jumala poole on, et nad pääseksid! ");
INSERT INTO ekk_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Ma tunnistan nende kasuks, et neil on agarust Jumala asjus, aga see ei põhine selgel arusaamisel tõest. ");
INSERT INTO ekk_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Kuna nad ei tunne Jumala teed õigeksmõistmiseks ja püüavad kehtestada õigeksmõistmist omal viisil, ei ole nad allunud Jumala õigeksmõistmisele. ");
INSERT INTO ekk_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Sest Seaduse lõpp on Kristus, õigeksmõistmiseks igaühele, kes usub. ");
INSERT INTO ekk_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Sest Mooses kirjutab Seadusest tuleneva õigeksmõistmise kohta: „Igaüks, kes seda täidab, elab selle järgi.“ ");
INSERT INTO ekk_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Kuid usul põhinev õigeksmõistmine räägib nõnda: „Ära ütle oma südames: „Kes läheb üles taevasse?“ “ (see on – Kristust alla tooma) ");
INSERT INTO ekk_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","„või: „Kes läheb alla sügavikku?“ “ (see on – Kristust surnuist üles tooma). ");
INSERT INTO ekk_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Selle asemel ütleb ta: „Sõna on su lähedal, sinu suus ja su südames!“ See on ususõna, mida me kuulutame. ");
INSERT INTO ekk_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Sest kui sa oma suuga tunnistad, et Jeesus on Issand, ja oma südamega usud, et Jumal on ta üles äratanud surnuist, siis sind päästetakse. ");
INSERT INTO ekk_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Sest südamega usutakse õigeksmõistmiseks ja suuga tunnistatakse päästeks. ");
INSERT INTO ekk_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Sest Pühakiri ütleb: „Igaüks, kes temasse usub, ei jää häbisse.“ ");
INSERT INTO ekk_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Seega ei ole vahet juudil ja mittejuudil; seesama Issand on kõikide Issand, rikas kõikide heaks, kes teda appi hüüavad. ");
INSERT INTO ekk_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Sest „igaüks, kes hüüab appi Issanda nime, päästetakse“. ");
INSERT INTO ekk_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Ent kuidas nad siis saavad appi hüüda teda, kellesse nad ei ole uskunud? Ja kuidas nad saaksid uskuda temasse, kellest nad ei ole kuulnud? Ja kuidas nad saavad kuulda, kui pole kuulutajat? ");
INSERT INTO ekk_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Ja kuidas nad võivad kuulutada, kui neid ei ole läkitatud? Nõnda nagu on kirjutatud: „Kui kaunid on nende jalad, kes toovad head sõnumit!“ ");
INSERT INTO ekk_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Siiski mitte kõik ei ole evangeeliumile kuuletunud. Jesaja ju ütleb: „Issand, kes on uskunud meie kuulutust?“ ");
INSERT INTO ekk_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Niisiis, usk tuleb kuuldust, aga kuuldu Kristuse sõna kaudu. ");
INSERT INTO ekk_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Aga ma küsin, kas nad ei ole siis kuulnud? On küll! „Nende hääl on läinud üle kogu maa, nende sõnum maailma äärteni.“ ");
INSERT INTO ekk_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Aga ma küsin uuesti, kas Iisrael ei saanud aru? Kõigepealt ütleb Mooses: „Ma teen teid kadedaks nende peale, kes ei ole rahvas, ma ärritan teid vihale rahva peale, kellel ei ole arusaamist.“ ");
INSERT INTO ekk_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Ning Jesaja kuulutab julgelt: „Ma lasin end leida neil, kes mind ei otsinud; ma tegin end tuntuks neile, kes mu järele ei küsinud.“ ");
INSERT INTO ekk_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Aga Iisraeli kohta ta ütleb: „Kogu päeva olen ma sirutanud oma käsi sõnakuulmatu ja tõrkuva rahva poole!“ ");
INSERT INTO ekk_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Niisiis, ma küsin – kas Jumal on oma rahva kõrvale heitnud? Olen ju minagi iisraellane, Aabrahami järglane, Benjamini suguharust! ");
INSERT INTO ekk_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Jumal ei ole oma rahvast, keda ta ette teadis, ära tõuganud. Pühakiri ütleb selles kohas Eelija kohta, kus ta anub Jumalat Iisraeli pärast: ");
INSERT INTO ekk_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","„Issand, nad on tapnud su prohvetid, lõhkunud maha su altarid! Mina üksi olen järgi jäänud ja nad püüavad mind tappa!“ ");
INSERT INTO ekk_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Kuid mida Jumal talle vastas? „Ma olen jätnud endale seitse tuhat meest, kes ei ole kummardanud Baali ees.“ ");
INSERT INTO ekk_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Samuti on siis ka praegusel ajal olemas jääk, keda Jumal on armu tõttu valinud. ");
INSERT INTO ekk_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Kui aga armust, siis mitte tegudest, sest muidu ei oleks arm enam arm. ");
INSERT INTO ekk_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Mis me järeldame? Mida Iisrael taotleb, seda ta ei ole saanud kätte, aga äravalitud on selle kätte saanud. Ülejäänud on kalestunud, ");
INSERT INTO ekk_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","nagu on kirjutatud: „Jumal on andnud neile tardumuse vaimu, silmad, mis ei näe, ja kõrvad, mis ei kuule, kuni tänase päevani.“ ");
INSERT INTO ekk_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Ja Taavet ütleb: „Nende pidulaud saagu neile silmuseks ja lõksuks, püüniseks ja kättemaksuks! ");
INSERT INTO ekk_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Löö nende silmi pimedusega, et nad ei näeks! Kõverda nende selg jäädavalt!“ ");
INSERT INTO ekk_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Seepärast ma küsin – kas Iisrael on komistanud, et kukkuda lõplikult? Kaugeltki mitte! Nende eksimuse tõttu on pääste saanud osaks mittejuutidele, et äratada Iisraelis kadedust. ");
INSERT INTO ekk_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Aga kui nende eksimus tähendab rikkust kogu maailmale ja nende kaotamine rikkust mittejuutidele, siis kui palju suuremat rikkust toob nende täielik kaasamine? ");
INSERT INTO ekk_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Ma räägin seda teie seas olevatele mittejuutidele. Kuna ma olen apostel mittejuutidele, olen ma uhke oma teenistuse üle, ");
INSERT INTO ekk_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","lootuses, et ma suudan ehk kuidagi äratada kadedust oma hõimlastes ning mõned neist päästa. ");
INSERT INTO ekk_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Sest kui juba nende eemale tõukamine tõi maailmale lepituse, mida muud toob nende vastuvõtmine, kui elu tõusmist surmast? ");
INSERT INTO ekk_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Aga kui uudsevili on püha, siis on seda kogu taigen. Ja kui juur on püha, siis on seda ka oksad. ");
INSERT INTO ekk_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Aga kui mõned oksad on küljest murtud, sina aga kui metsõlipuu oled nende asemele poogitud ja saad osa õige õlipuu mahlakast juurest, ");
INSERT INTO ekk_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","siis ära hoople okste ees. Ja kui sa hoopled, siis pea meeles, et mitte sina ei kanna juurt, vaid juur kannab sind. ");
INSERT INTO ekk_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Sina ehk ütled: „Oksad murti küljest, et mind asemele pookida.“ ");
INSERT INTO ekk_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Õige küll! Nemad murti küljest uskmatuse pärast, sina püsid puu küljes aga usu läbi. Ära mõtle kõrgilt, vaid karda! ");
INSERT INTO ekk_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Kui Jumal ei jätnud karistamata loomupäraseid oksi, ei säästa ta sindki! ");
INSERT INTO ekk_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Seepärast, pane tähele Jumala lahkust ja karmust: karmust nende suhtes, kes langevad, aga lahkust sinu vastu, kui sa püsid tema lahkuses; vastasel korral raiutakse sindki maha. ");
INSERT INTO ekk_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Aga ka iisraellased, kui nad ei jää oma uskmatusse, poogitakse puu külge, sest Jumal suudab neid tagasi pookida. ");
INSERT INTO ekk_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Sest kui juba sind metsõlipuu küljest lahti raiuti ja vastupidiselt loomulikule aedõlipuu külge poogiti, eks poogita loomupärased oksad seda enam nende oma puu külge. ");
INSERT INTO ekk_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Vennad ja õed, et te ei oleks enda meelest targad, tahan ma teile teada anda saladuse: üht osa Iisraeli on tabanud kalestumine seni, kuni mittejuutide koguarv on sisse astunud. ");
INSERT INTO ekk_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Ja nõnda päästetakse kogu Iisrael. Nagu on kirjutatud: „Siionist saabub Päästja, kes kõrvaldab Jaakobist jumalakartmatuse. ");
INSERT INTO ekk_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","See on minu leping nendega, kui ma kustutan ära nende patud.“ ");
INSERT INTO ekk_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Evangeeliumi seisukohalt on nad Jumala vaenlased teie heaks, aga Jumala valiku seisukohalt on nad armastatud esiisade pärast, ");
INSERT INTO ekk_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","sest Jumal ei võta tagasi oma armuande ja kutsumist! ");
INSERT INTO ekk_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Sest nõnda nagu teie kord olite Jumalale sõnakuulmatud, aga nüüd olete armu saanud nende sõnakuulmatuse tõttu, ");
INSERT INTO ekk_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","nii on nüüd ka nemad muutunud sõnakuulmatuks teile osaks saanud halastuse pärast, et nendegi peale halastataks. ");
INSERT INTO ekk_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Sest Jumal on kõik inimesed kinni pannud sõnakuulmatuse alla, et kõikide peale halastada. ");
INSERT INTO ekk_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Kui mõõtmatu on Jumala rikkuse, tarkuse ja teadmise sügavus! Kui läbiuurimatud on tema otsused ja kui mõistatuslikud on tema teed! ");
INSERT INTO ekk_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","„Sest kes on ära tundnud Issanda meele? Kes on olnud tema nõuandjaks?“ ");
INSERT INTO ekk_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","„Kes on midagi kunagi Jumalale andnud, et ta peaks talle tagasi maksma?“ ");
INSERT INTO ekk_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Sest temast on tekkinud kõik, tema kaudu ja tema jaoks on olemas kõik. Temale kuulub kirkus igavesti! Aamen. ");
INSERT INTO ekk_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Seepärast, vennad ja õed, et Jumal on meie vastu nii halastav, siis ma kutsun teid üles: andke oma ihud Jumalale elavaks, pühaks ja meelepäraseks ohvriks! See on tõeline ja õige viis teenida Jumalat. ");
INSERT INTO ekk_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Ärge muganduge praeguse ajaga, vaid muutuge teiseks oma meele uuendamise teel, et te tunneksite ära, mis on Jumala tahtmine – mis on hea, talle meelepärane ja täiuslik. ");
INSERT INTO ekk_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Mulle antud armu tõttu ütlen ma igaühele teie seast: ärge olge endast paremal arvamusel kui on kohane, vaid suhtuge endasse kainelt, igaüks vastavalt usu määrale, mille Jumal talle on jaganud. ");
INSERT INTO ekk_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Sest nii nagu meil on ühes ihus palju liikmeid, aga kõigil liikmeil ei ole sama ülesanne, ");
INSERT INTO ekk_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","nõnda me oleme ka paljukesi üks ihu Kristuses, üksikult aga igaüks üksteise liikmed. ");
INSERT INTO ekk_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Vastavalt meile antud armule on meil erinevad anded. Kui sinu and on prohvetlik kõne, prohveteeri vastavalt oma usule; ");
INSERT INTO ekk_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","kui see on teenimine, siis teeni; kui õpetamine, siis õpeta; ");
INSERT INTO ekk_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","kui julgustamine, siis julgusta; kui andmine, anna lahkelt; kui juhtimine, siis juhi hoolikalt; kui aitad teistel kanda muresid, tee seda rõõmuga. ");
INSERT INTO ekk_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Armastus olgu siiras! Vihake kurja, kiinduge heasse! ");
INSERT INTO ekk_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Pühenduge üksteisele vennalikus armastuses. Hinnake üksteist kõrgemalt, kui iseennast! ");
INSERT INTO ekk_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Ärge olge viitsimatud hoolsuses; olge tulised vaimus; teenige Issandat! ");
INSERT INTO ekk_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Olge rõõmsad lootuses, kannatlikud katsumustes, ustavad palves! ");
INSERT INTO ekk_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Aidake täita Jumala rahva vajadusi, võtke külalislahkus endale eesmärgiks! ");
INSERT INTO ekk_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Õnnistage neid, kes teid taga kiusavad; õnnistage ja ärge needke! ");
INSERT INTO ekk_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Olge rõõmsad koos rõõmsatega, nutke koos nutjatega! ");
INSERT INTO ekk_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Elage kooskõlas üksteisega! Ärge olge kõrgid, vaid seltsige alandlikega! Ärge olge eneste meelest targad! ");
INSERT INTO ekk_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Ärge tasuge kellelegi kurja kurjaga; mõtelge ikka sellele, mis hea on kõigi inimeste suhtes! ");
INSERT INTO ekk_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Niivõrd kui see on teie võimuses, elage rahus kõigi inimestega! ");
INSERT INTO ekk_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Armsad, ärge makske ise kätte enda eest, vaid andke maad Jumala vihale, sest on kirjutatud: „Mulle kuulub kättemaks, minu käest tuleb karistus,“ ütleb Issand. ");
INSERT INTO ekk_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Seevastu, „kui su vaenlasel on nälg, toida teda, ja kui tal on janu, jooda teda; sest seda tehes sa kuhjad põlevaid süsi tema pea peale!“ ");
INSERT INTO ekk_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Ära lase kurjusel võitu saada enese üle, vaid võida sina kurjus ära heaga! ");
INSERT INTO ekk_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Iga inimhing allugu võimudele, kes on tema üle. Sest ei ole võimu, mis poleks seatud Jumalast; ja olemasolevad võimud on pandud ametisse tema poolt. ");
INSERT INTO ekk_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Niisiis, kes paneb vastu võimule, hakkab vastu sellele, mis Jumal on seadnud; ja vastuhakkajaid tabab kohtumõistmine. ");
INSERT INTO ekk_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Sest valitsejad ei ole hirmuks neile, kes teevad head, vaid neile, kes teevad kurja. Kui sa võimukandja ees hirmu tunda ei taha, siis tee head, ja sa saad temalt kiita. ");
INSERT INTO ekk_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Ta on ju Jumala teener sinu heaks. Aga kui sa kurja teed, siis karda, sest ta ei kanna mõõka asjata. Ta on Jumala teener, tema viha jagaja, tuues õiglast karistust kurjategijaile. ");
INSERT INTO ekk_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Seepärast on alistumine vajalik, seda mitte ainult karistuse, vaid ka südametunnistuse pärast. ");
INSERT INTO ekk_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Samal põhjusel te maksate ka makse; sest võimukandjad on Jumala teenrid, kes selleks peavad oma ametit. ");
INSERT INTO ekk_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Andke igaühele seda, mis te talle võlgnete: kui te võlgnete maksu, siis maksu; kui lõivu, siis lõivu; kartust sellele, kes kutsub esile kartust; kellele võlgnete austust, andke austust. ");
INSERT INTO ekk_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Ärgu olgu teil ühtki muud võlga kellegi ees, kui jätkuv armastuse võlg üksteise vastu. Sest kes teist inimest armastab, on Seaduse täitnud. ");
INSERT INTO ekk_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Sest käsud „Ära riku abielu“, „Ära mõrva“, „Ära varasta“, „Ära himusta“ ja mis tahes muu käsk on kokku võetud selles käsus: „Armasta oma ligimest nagu iseennast!“ ");
INSERT INTO ekk_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Armastus ei tee ligimesele kurja, seetõttu on armastus Seaduse täitmine. ");
INSERT INTO ekk_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Tehke seda, mõistes käesoleva hetke tähendust: teil on aeg unest ärgata, sest nüüd on meie pääste lähemal kui usklikuks saades. ");
INSERT INTO ekk_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Öö on möödumas, peagi koidab päev. Seepärast heitkem enestest ära pimeduse teod ja pangem selga valguse sõjavarustus! ");
INSERT INTO ekk_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Elagem sündsalt nagu päeva ajal, mitte pidutsemistes ja purjuspäi, mitte kiimaluses ja kõlvatuses, mitte riius ja armukadeduses. ");
INSERT INTO ekk_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Pigem rõivastuge Issanda Jeesuse Kristusega ja ärge muutke ihu eest hoolitsemist himude ärritamiseks. ");
INSERT INTO ekk_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Võtke lahkesti vastu usus nõdrad ja ärge vaielge erimeelsuste üle. ");
INSERT INTO ekk_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Üks usub, et süüa võib kõike, aga kes on nõder, sööb ainult taimetoitu. ");
INSERT INTO ekk_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Kes sööb, ärgu põlastagu seda, kes ei söö. Ja kes ei söö, ärgu mõistku kohut selle üle, kes sööb, sest Jumal on tema vastu võtnud. ");
INSERT INTO ekk_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Kes oled sina, et mõistad kohut võõra sulase üle? Oma isanda ees ta seisab või langeb. Aga ta jääb seisma, sest Issand suudab teda püsti hoida. ");
INSERT INTO ekk_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Mõni peab üht päeva teisest paremaks, teine aga kõiki päevi ühesuguseks. Olgu igaüks oma otsuses kindel! ");
INSERT INTO ekk_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Kes tähistab mingit päeva, tähistab seda Issandale; ja kes sööb, sööb Issandale, sest ta tänab Jumalat; samuti see, kes jätab söömata, teeb seda Issandale ja tänab Jumalat. ");
INSERT INTO ekk_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Sest ükski meist ei ela iseenesele ja ükski ei sure iseendale. ");
INSERT INTO ekk_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Kui me elame, siis elame Issandale, ja kui me sureme, siis sureme Issandale. Seepärast, ükskõik, kas me elame või sureme, oleme ikka Issanda omad! ");
INSERT INTO ekk_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Just selleks on ju Kristus surnud ja saanud jälle elavaks, et ta oleks nii surnute kui elavate Issand. ");
INSERT INTO ekk_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Aga miks sina mõistad kohut oma venna või õe üle? Või miks sina neid põlastad? Eks tuleb meil kõigil kord seista Jumala kohtujärje ees, ");
INSERT INTO ekk_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","nagu on kirjutatud: „ „Nii tõesti kui mina elan,“ ütleb Issand, „minu ees peab nõtkuma iga põlv, ja iga suu peab kiitma Jumalat.“ “ ");
INSERT INTO ekk_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Nõnda peab siis igaüks meist enda kohta Jumalale aru andma. ");
INSERT INTO ekk_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Ärgem siis mõistkem enam kohut üksteise üle! Pigem otsustagem hoiduda saamast vennale komistuseks ja pahanduseks. ");
INSERT INTO ekk_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Ma tean ja olen veendunud Issandas Jeesuses, et midagi ei ole ebapüha iseenesest, vaid on ebapüha üksnes sellele, kes midagi peab ebapühaks. ");
INSERT INTO ekk_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Sest kui su vend või õde tunneb piina sellepärast, mis sa sööd, siis ei käitu sa enam kooskõlas armastusega. Ära hävita oma toiduga kedagi, kelle eest Kristus on surnud! ");
INSERT INTO ekk_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Sellepärast ärgu saagu hea, mis teil on, pilgatavaks. ");
INSERT INTO ekk_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Sest Jumala riik ei ole mitte söömine ega joomine, vaid õigus ja rahu ja rõõm Pühas Vaimus. ");
INSERT INTO ekk_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Igaüks, kes selliselt teenib Kristust, on Jumalale meelepärane ja tunnustatud inimeste poolt. ");
INSERT INTO ekk_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Nõnda siis taotlegem seda, mida on vaja rahuks ja üksteise ülesehitamiseks! ");
INSERT INTO ekk_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Ära lammuta toidu pärast Jumala tööd! Kõik toit on küll puhas, aga on vale süüa seda, mis teise komistama paneb! ");
INSERT INTO ekk_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Parem on mitte süüa liha ega juua veini ega teha midagi sellist, mille tõttu su vend või õde kiusatusse satub. ");
INSERT INTO ekk_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Mida iganes sa nende asjade kohta usud, hoia see enese ja Jumala vahel! Õnnistatud on see, kes ei süüdista end asjade pärast, mis ta heaks kiidab. ");
INSERT INTO ekk_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Aga kes kahtleb ja siiski sööb, on süüdi, sest see ei tule usust. Aga kõik, mis ei tule usust, on patt. ");
INSERT INTO ekk_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Ent meie, kes me oleme tugevad, peame kandma nõrkade puudusi ja mitte tegema vaid seda, mis meile meeldib. ");
INSERT INTO ekk_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Igaüks meist olgu ligimese heaks meelepärane tema ülesehitamiseks. ");
INSERT INTO ekk_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Kristuski ei elanud enese meele heaks, vaid nagu on kirjutatud: „Sinu pilkajate pilked on tabanud mind!“ ");
INSERT INTO ekk_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Sest kõik, mis on varem kirja pandud, on kirjutatud meile õpetuseks, et meil kannatlikkuse ja Pühakirja julgustuse abil oleks lootust. ");
INSERT INTO ekk_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Ja annaks Jumal teile, kelle käest see kannatlikkus ja julgustus tuleb, sellesama suhtumise üksteisesse, mis Kristusel Jeesusel oli ");
INSERT INTO ekk_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","selleks, et te ühel meelel ja ühel häälel ülistaksite Jumalat, meie Issanda Jeesuse Kristuse Isa! ");
INSERT INTO ekk_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Seepärast võtke lahkesti vastu üksteist, nagu Kristus on teid vastu võtnud Jumala kirkuseks. ");
INSERT INTO ekk_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Sest ma ütlen, et Jumala ustavuse pärast on Kristus saanud ümberlõigatute teenriks, et kinnitada esiisadele antud tõotusi, ");
INSERT INTO ekk_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ja et ka mittejuudid võiksid Jumalat kiita halastuse eest, nagu on kirjutatud: „Seepärast ma ülistan sind mittejuutide seas ja laulan kiitust sinu nimele.“ ");
INSERT INTO ekk_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Ja veel on öeldud: „Rõõmutsege, mittejuudid, koos tema rahvaga!“ ");
INSERT INTO ekk_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Ja veel: „Kiitke Issandat, kõik mittejuudid; temale toogu kiitust kõik rahvad!“ ");
INSERT INTO ekk_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Ja Jesaja ütleb veel: „Iisai juur tuleb ja see, kes tõuseb valitsema rahvaid; tema peale panevad mittejuudid lootuse.“ ");
INSERT INTO ekk_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Aga lootuse Jumal täitku teid kõige rõõmu ja rahuga usuelus, et teil oleks küllaga lootust Püha Vaimu väes! ");
INSERT INTO ekk_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Vennad ja õed, ma olen teie suhtes veendunud, et te olete täis headust, igati tulvil tõetundmist ja oskate ka ise üksteist juhatada. ");
INSERT INTO ekk_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Aga siiski olen ma kirjutanud teile üsna julgelt mõnest asjast, et teile neid uuesti meenutada, sest selle armu läbi, mis Jumal minu vastu üles näitas, ");
INSERT INTO ekk_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","olen ma mittejuutide teenija Kristuses Jeesuses. Ta andis mulle preestrikohustuse kuulutada Jumala evangeeliumi, et mittejuudid saaksid Jumalale vastuvõetavaks ohvrianniks, pühitsetuna Pühas Vaimus. ");
INSERT INTO ekk_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Seepärast on mul Kristuses Jeesuses põhjust kiidelda Jumala töö üle. ");
INSERT INTO ekk_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Ma ei julgeks rääkida millestki muust, kui vaid sellest, mida Kristus on minu kaudu teinud, juhtides mittejuute Jumalale kuuletuma selle kaudu, mida ma olen öelnud ja teinud, ");
INSERT INTO ekk_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","tunnustähtede ja imetegude väe läbi, Jumala Vaimu väe läbi. Alustades Jeruusalemmast ja liikudes ümberringi kuni Illüüriani, olen Kristuse evangeeliumi kuulutamise lõpuni viinud. ");
INSERT INTO ekk_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Nõnda ma püüan alati kuulutada evangeeliumi seal, kus Kristust veel ei tunta, et ma ei ehitaks teiste rajatud vundamendile. ");
INSERT INTO ekk_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Vaid nagu on kirjutatud: „Need, kellele ei ole temast räägitud, näevad ja need, kes ei ole kuulnud, hakkavad mõistma.“ ");
INSERT INTO ekk_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","See ongi mind iga kord takistanud teie juurde tulemast. ");
INSERT INTO ekk_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Aga et mul nüüd ei ole enam neis piirkondades kohta, ja ma olen juba mitmeid aastaid igatsenud teid külastada, ");
INSERT INTO ekk_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","mõtlen seda teha, kui lähen Hispaaniasse. Loodan teid näha, kui sealt läbi tulen, ja saada teilt abi edasiminekuks pärast seda, kui olen pisut teie külalislahkust maitsnud. ");
INSERT INTO ekk_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Aga nüüd ma lähen Jeruusalemma Jumala rahva teenijana, ");
INSERT INTO ekk_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","sest Makedoonia ja Ahhaia kogudused on otsustanud teha korjanduse vaeste jaoks Jeruusalemma pühade hulgas. ");
INSERT INTO ekk_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Nad tegid seda hea meelega; ja eks nad olegi seda neile võlgu. Sest kui mittejuudid on saanud osa juutide vaimsest rikkusest, siis on nende kohus juutidele jagada ka osa oma maisest rikkusest. ");
INSERT INTO ekk_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Kui ma olen selle ülesande täitnud ja kindel, et nad on selle vilja kätte saanud, siis suundun ma teie kaudu Hispaaniasse. ");
INSERT INTO ekk_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Aga ma tean, kui ma teie juurde tulen, siis ma tulen Kristuse täieliku õnnistusega. ");
INSERT INTO ekk_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Kuid ma palun tungivalt teid, vennad ja õed, meie Issanda Jeesuse Kristuse nimel ja Püha Vaimu armastuse läbi, koos minuga võidelda palvetega minu eest Jumala poole, ");
INSERT INTO ekk_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","et ta päästaks mind uskmatute käest Juudamaal ja et mu teenimistöö Jeruusalemma heaks oleks Jumala rahvale vastuvõetav, ");
INSERT INTO ekk_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","nii et ma Jumala tahtel võiksin rõõmuga tulla teie juurde ja teie keskel saada kosutust. ");
INSERT INTO ekk_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Olgu rahu Jumal teie kõikidega! Aamen. ");
INSERT INTO ekk_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Ma annan teile soovituse meie õe Foibe kohta, kes on Kenkreas asuva koguduse teenistuses. ");
INSERT INTO ekk_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Võtke ta vastu Issanda osaduses Jumala rahva vääriliselt, ja aidake teda kõiges, milles ta teie abi vajab, sest ta on paljusid toetanud, ka mind ennast. ");
INSERT INTO ekk_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Tervitage mu kaastöölisi Kristuses Jeesuses, Priskat ja Akvilat, ");
INSERT INTO ekk_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","kes seadsid minu pärast ohtu oma elu. Mitte üksnes mina, vaid ka kõik mittejuutide kogudused on neile tänulikud. ");
INSERT INTO ekk_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Tervitage ka nende kodus tegutsevat kogudust! Tervitage minu armast Epainetost. Tema oli Aasias esimene, kes hakkas uskuma Kristusesse! ");
INSERT INTO ekk_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Tervitage Maarjat, kes on teie heaks palju vaeva näinud! ");
INSERT INTO ekk_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Tervitage Andronikost ja Juniast, minu sugulasi, kes minuga koos vangis olid. Nad on lugupeetud apostlite hulgas ja olid kristlased juba enne mind! ");
INSERT INTO ekk_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Tervitage Ampliatust, mu armast venda Issandas! ");
INSERT INTO ekk_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Tervitage Urbanust, meie kaastöölist Kristuses, ja mu armast venda Stahhüst! ");
INSERT INTO ekk_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Tervitage Apellest, läbi katsutud venda Kristuses! Tervitage Aristobulose pereliikmeid! ");
INSERT INTO ekk_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Tervitage mu sugulast Heroodioni! Tervitage Narkissose pereliikmeid, kes kuuluvad Issandale! ");
INSERT INTO ekk_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Tervitage õdesid Trüfainat ja Trüfoosat, kes näevad tublisti vaeva Issanda töös! Tervitage armast õde Persist, kes on näinud palju vaeva Issanda töös! ");
INSERT INTO ekk_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Tervitage Ruufust, valitud venda Issandas, ja tema ema, kes on olnud mullegi ema eest! ");
INSERT INTO ekk_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Tervitage Asünkritost, Flegonit, Hermest, Patrobast, Hermast ning teisi vendi ja õdesid, kes on nendega! ");
INSERT INTO ekk_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Tervitage Filologost ja Juuliat, Neereust ja ta õde ning Olümpast ja kõiki pühasid, kes on nendega! ");
INSERT INTO ekk_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Tervitage üksteist püha suudlusega! Kõik Kristuse kogudused tervitavad teid! ");
INSERT INTO ekk_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Ma manitsen teid, vennad ja õed, pidama silmas neid, kes tekitavad lõhesid ja panevad raskusi teie ette vastupidiselt sellele õpetusele, mis te olete saanud. Hoiduge neist eemale, ");
INSERT INTO ekk_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","sest niisugused inimesed ei teeni mitte meie Issandat Kristust, vaid omaenda kõhtu. Ilusate sõnade ja meelitustega petavad nad lihtsameelseid inimesi. ");
INSERT INTO ekk_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Aga teie sõnakuulelikkus on ju kõigile teada. Seepärast ma rõõmustan teie üle ja soovin, et oleksite targad heale, kuid kohtlased kurjale. ");
INSERT INTO ekk_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Küll rahu Jumal purustab peagi saatana teie jalge all! Meie Issanda Jeesuse arm olgu teiega! ");
INSERT INTO ekk_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Teid tervitavad minu kaastööline Timoteos ning mu sugulased Luukius, Jaason ja Soosipatros. ");
INSERT INTO ekk_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Teid tervitan mina, Tertius, selle kirja üleskirjutaja ja vend Issandas! ");
INSERT INTO ekk_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Teid tervitab Gaius, kes on osutanud külalislahkust minule ja tervele kogudusele. Teid tervitavad linna varahoidja Erastos ja vend Kvartus. ");
INSERT INTO ekk_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Meie Issanda Jeesus Kristuse arm olgu teie kõikidega! Aamen. ");
INSERT INTO ekk_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Ent temale, kes teid võib kinnitada vastavalt minu evangeeliumile ja kuulutusele Jeesusest Kristusest, kooskõlas selle saladuse ilmutusega, mida hoiti varjul pikki ajastuid, ");
INSERT INTO ekk_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","aga mis nüüd on tehtud avalikuks ja saanud teatavaks prohvetlike kirjutiste kaudu igavese Jumala korraldusel, et kõik mittejuudid võiksid tulla sõnakuulelikkusele, mis tuleneb usust, ");
INSERT INTO ekk_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","ainsale targale Jumalale kuulugu au igavesti Jeesuse Kristuse läbi! Aamen.");
INSERT INTO ekk_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Pauluselt, kelle Jeesus Kristus on Jumala tahtel kutsunud apostliks, ja meie vennalt Soosteneselt, ");
INSERT INTO ekk_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Korintoses asuvale Jumala kogudusele, Jeesuses Kristuses pühitsetuile, Jumala pühadele ning kõigile neile, kes mitmel pool appi hüüavad meie Issandat Jeesust Kristust: ");
INSERT INTO ekk_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Armu ja rahu teile Jumalalt, meie Isalt, ning Issandalt Jeesuselt Kristuselt! ");
INSERT INTO ekk_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Ma tänan alati oma Jumalat selle armu eest, mida ta on osutanud teile Jeesuses Kristuses, ");
INSERT INTO ekk_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","kelles te olete rikkaks saanud igasuguses õpetuses ja tunnetuses, ");
INSERT INTO ekk_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","kuivõrd Kristuselt saadav tunnistus on kinnitunud teie sees, ");
INSERT INTO ekk_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","nii et teil pole puudu ühestki armuannist ja te ootate pikisilmi meie Issanda Jeesuse Kristuse tagasitulekut. ");
INSERT INTO ekk_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Tema hoiab teid tugevana lõpuni, et te oleksite laitmatud meie Issanda Jeesuse Kristuse päeval. ");
INSERT INTO ekk_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Ustav on Jumal, kes on kutsunud teid osadusse oma Poja Jeesuse Kristuse, meie Issandaga. ");
INSERT INTO ekk_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Vennad ja õed, ma palun teid, meie Issanda Jeesuse Kristuse pärast, et te kõik räägiksite ühtviisi ega oleks teie seas lõhesid ning te oleksite ühtsed meelsuse ja mõtteviisi poolest. ");
INSERT INTO ekk_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Sest ma olen Kloe pererahvalt kuulnud tülidest teie hulgas, mu vennad ja õed. ");
INSERT INTO ekk_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Pean silmas seda, et mõni teist ütleb: „Mina olen Pauluse poolt!“ või „Mina olen Apollose poolt!“ või „Mina olen Keefase poolt!“ või „Mina olen Kristuse poolt!“ ");
INSERT INTO ekk_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Kas Kristus on jagatud osadeks? Kas Paulus löödi risti teie eest? Või ristiti teid Pauluse nimesse? ");
INSERT INTO ekk_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Ma tänan Jumalat, et ma ei ole ristinud teie seast kedagi peale Krispuse ja Gaiuse. ");
INSERT INTO ekk_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Nii ei saa keegi öelda, nagu oleks teid ristitud minu nimesse. ");
INSERT INTO ekk_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Jah, tõesti, ma ristisin veel ka Stefanase pere, aga kedagi teist ma ei tea, et oleksin ristinud. ");
INSERT INTO ekk_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Sest Kristus ei saatnud mind ristima, vaid evangeeliumi kuulutama – ja seda mitte inimlikult targa kõnega, et Kristuse risti tähendust ei vähendataks. ");
INSERT INTO ekk_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Sest sõnum ristist on rumalus neile, kes hukkuvad, aga meile, kes päästetakse, on see Jumala vägi. ");
INSERT INTO ekk_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Sest kirjutatud on: „Ma hävitan tarkade tarkuse ja tühistan mõistlike mõistuse.“ ");
INSERT INTO ekk_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Kus on tark? Kus kirjatundja? Kus on selle ajastu filosoof? Eks Jumal ole pööranud maailma tarkuse rumaluseks! ");
INSERT INTO ekk_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Nõnda nagu Jumal oli tarkuses seadnud, et maailm oma tarkuses ei saa teda tunda, oli Jumala hea nõu rumaluse kuulutamise läbi päästa need, kes usuvad. ");
INSERT INTO ekk_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Sest kui juudid nõuavad tunnustähti ja kreeklased tarkust, ");
INSERT INTO ekk_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","siis meie kuulutame ristilöödud Kristust, kes on komistuskivi juutidele ja rumalus teistele rahvastele. ");
INSERT INTO ekk_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Aga neile, keda Jumal on kutsunud, nii juutidele kui kreeklastele, on Kristus Jumala vägi ja Jumala tarkus. ");
INSERT INTO ekk_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Sest Jumala rumalus on targem kui inimeste tarkus ja Jumala nõtrus tugevam kui inimeste tugevus. ");
INSERT INTO ekk_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Ärge unustage, vennad ja õed, millistena Jumal teid kutsus. Ei olnud teie seas palju neid, kes inimlikus mõttes oleksid targad, vägevad või kõrgest soost. ");
INSERT INTO ekk_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Ent Jumal on valinud välja maailma meelest rumalad, et häbistada tarku, on valinud maailma meelest nõrgad, et häbistada tugevaid, ");
INSERT INTO ekk_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","on valinud need, kes maailma meelest on madalast soost ja põlatud, lausa eimiski, et teha tühiseks need, kes midagi on. ");
INSERT INTO ekk_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Nii ei saa ükski inimene kiidelda Jumala ees. ");
INSERT INTO ekk_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Tänu temale olete teie nüüd Jeesuses Kristuses, kes on saanud meile tarkuseks Jumalalt ning õiguseks ja pühitsuseks ja lunastuseks, ");
INSERT INTO ekk_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","et läheks täide, nagu on kirjutatud: „Kes kiitleb, see kiidelgu Issandast!“ ");
INSERT INTO ekk_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Ja nõnda on ka minuga, vennad ja õed. Tulles teie juurde kuulutama Jumala saladust, ei tulnud ma kaunite sõnade või inimliku tarkusega. ");
INSERT INTO ekk_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Ma ei tahtnud teie keskel teada muust kui Jeesusest Kristusest ja tema ristisurmast. ");
INSERT INTO ekk_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Saabusin teie juurde nõtruses ja kartuse värinaga ");
INSERT INTO ekk_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","ning mu kõne ja kuulutus ei toetunud tarkadele ja veenvatele sõnadele, vaid Püha Vaimu väe osutamisele, ");
INSERT INTO ekk_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","et teie usk oleks rajatud Jumala väele, mitte inimtarkusele. ");
INSERT INTO ekk_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Tarkusest me räägime täiuslike seas; ent mitte käesoleva ajastu ja selle surelike valitsejate tarkusest, ");
INSERT INTO ekk_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","vaid me anname edasi Jumala salajast ja varjatud tarkust, mille Jumal on määranud meie kirkuseks enne ajastute algust ");
INSERT INTO ekk_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ja mida ei ole mõistnud ükski käesoleva ajastu valitsejatest, sest kui nad oleksid mõistnud, ei oleks nad kirkuse Issandat risti löönud. ");
INSERT INTO ekk_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Siiski on kirjutatud: „Mida ükski silm pole näinud, mida ükski kõrv ei ole kuulnud, ja mis ei ole inimesele mõttessegi tulnud,“ asjad, mida Jumal on valmistanud neile, kes teda armastavad – ");
INSERT INTO ekk_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","seda on Jumal meile ilmutanud oma Vaimu kaudu, sest Vaim uurib läbi kõik, ka Jumala sügavad saladused. ");
INSERT INTO ekk_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Kes muu teab, mis on inimeses, kui vaid inimese vaim? Samuti ei tunne keegi, mis on Jumalas, kui vaid Jumala Vaim. ");
INSERT INTO ekk_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Meie aga ei ole saanud maailma vaimu, vaid Vaimu, kes on Jumalast, et võiksime teada, mida Jumal meile heldesti kingib. ");
INSERT INTO ekk_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Sellest me räägime sõnadega, mida ei ole õpetanud inimlik tarkus, vaid Jumala Vaim, selgitades vaimseid tõdesid vaimsel viisil. ");
INSERT INTO ekk_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Kuid maine inimene ei võta vastu, mis on Jumala Vaimust. Tema jaoks on see rumalus; ta ei võigi aru saada, sest seda tuleb mõista vaimselt. ");
INSERT INTO ekk_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Vaimne inimene aga mõistab kõike, ent teda ennast ei mõista keegi. ");
INSERT INTO ekk_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","„Kes on ära tundnud Issanda meele, et temale nõu anda?“ Kuid meil on Kristuse meel! ");
INSERT INTO ekk_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Nii ei saanud minagi, vennad ja õed, rääkida teiega kui vaimulikult küpsetega, vaid kui ebaküpsetega, kui lapsukestega Kristuses. ");
INSERT INTO ekk_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Ma toitsin teid piimaga, mitte tahke toiduga, sest te ei suutnud seda veel süüa ega suuda praegugi, ");
INSERT INTO ekk_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","sest te olete ikka veel lihalikud. On ju nii, et kuni teie seas on kadedust ja riidu, siis te olete lihalikud ja elate nõnda nagu muudki inimesed? ");
INSERT INTO ekk_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Sest kui üks ütleb: „Mina olen Pauluse poolt“ ja teine „Mina Apollose poolt“ eks ole te nagu inimesed ikka? ");
INSERT INTO ekk_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Kes on siis Apollos? Või kes on Paulus? Ainult teenijad, kes aitasid teid tulla usule, sedamööda kuidas Issand igaühele on andnud. ");
INSERT INTO ekk_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Mina istutasin, Apollos kastis, aga Jumal laskis kasvada. ");
INSERT INTO ekk_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Nõnda siis ei ole tähtis ei istutaja ega kastja, vaid Jumal, kes kasvatab. ");
INSERT INTO ekk_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Istutaja ja kastja on üheväärsed, kumbki neist saab palga vastavalt oma töövaevale. ");
INSERT INTO ekk_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Sest meie oleme Jumala kaastöölised, teie aga olete Jumala põllumaa, Jumala hoone. ");
INSERT INTO ekk_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Selle anniga, mille Jumal mulle on kinkinud, olen mina kui oskuslik ehitusmeister pannud paika vundamendi, millele keegi teine ehitab edasi. Ent igaüks kaalugu hoolikalt, kuidas ta sellele ehitab! ");
INSERT INTO ekk_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Keegi ei saa rajada teist alust selle kõrvale, mis on juba olemas, ja see on Jeesus Kristus. ");
INSERT INTO ekk_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Kas siis keegi ehitab sellele vundamendile hoone kullast, hõbedast, kalliskividest, puust, heintest või õlgedest – ");
INSERT INTO ekk_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","kord saab igaühe töö nähtavaks, Issanda päev teeb selle avalikuks, sest see ilmub tules. Tules katsutakse läbi igaühe töö väärtus. ");
INSERT INTO ekk_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Kui kellegi töö, mis ta on ehitanud, jääb püsima, siis ta saab tasu. ");
INSERT INTO ekk_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Kelle töö põleb ära, jääb tasust ilma. Ta ise küll pääseb, aga otsekui läbi tule. ");
INSERT INTO ekk_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Eks teie tea, et te olete Jumala tempel ja teie sees elab Jumala Vaim? ");
INSERT INTO ekk_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Kui keegi rikub Jumala templi, siis Jumal rikub tema. Sest Jumala tempel on püha ja seda olete ka teie. ");
INSERT INTO ekk_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Ärge petke ennast! Kui keegi teie seast peab ennast targaks selle ajastu kohaselt, siis ta saagu esmalt rumalaks, et saada tõesti targaks! ");
INSERT INTO ekk_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Sest selle maailma tarkus on Jumala silmis rumalus. Sest kirjutatud on: „Ta püüab targad nende kavaluses kinni.“ ");
INSERT INTO ekk_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Ja veel: „Issand tunneb tarkade arutlusi ja teab, et need on tühised.“ ");
INSERT INTO ekk_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Ärgu siis ükski kiidelgu inimestest! Sest kõik on teie päralt: ");
INSERT INTO ekk_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","olgu Paulus või Apollos või Keefas, olgu maailm või elu või surm, olgu olevik või tulevik – kõik on teie päralt! ");
INSERT INTO ekk_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Teie aga olete Kristuse päralt ja Kristus on Jumala päralt! ");
INSERT INTO ekk_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Niisiis, kuidas te peaksite meisse suhtuma: kui Kristuse sulastesse ja majapidajatesse, kellele on usaldatud Jumala ilmutatud saladused. ");
INSERT INTO ekk_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Aga majapidajailt nõutakse, et nad oleksid ustavad. ");
INSERT INTO ekk_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Mulle ei loe see eriti palju, kui minu üle mõistaksite kohut teie või ükskõik milline inimlik kohtukogu. Ka mina ise ei mõista enda üle kohut. ");
INSERT INTO ekk_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Tõsi, ma ei tea, et mul oleks mingit süüd, aga see iseenesest ei mõista mind veel õigeks. Minu kohtumõistja on Issand. ");
INSERT INTO ekk_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Niisiis, ärge mõistke kohut enne õiget aega, enne kui tuleb Issand, kes toob valguse kätte kõik, mida pimedus peidab, ja paljastab inimsüdamete kavatsused. Siis saab igaüks temale kohase kiituse Jumalalt. ");
INSERT INTO ekk_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Teie pärast, vennad ja õed, olen ma kõnelnud neist asjust iseenda ja Apollose näitel, et te õpiksite meie eeskujust, mida tähendab ütlus: „Ärge minge kaugemale sellest, mis on kirjutatud“. Siis te enam ei hoople ühe inimese poolt ja teise vastu. ");
INSERT INTO ekk_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Sest kes on teinud sind teisest ülemaks? On sul midagi, mis ei ole saadud Jumalalt? Aga kui see on saadud temalt, miks sa siis kiitled, nagu oleks sul midagi iseenesest? ");
INSERT INTO ekk_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Juba on teil kõike küllaga! Juba te olete rikkaks saanud! Olete hakanud valitsema kuningatena ilma meieta! Oh, oleks te juba tõesti kuningad, et meiegi võiksime valitseda koos teiega! ");
INSERT INTO ekk_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Sest mulle tundub, et Jumal on seadnud meid, apostleid, järjekorras viimasteks, otsekui surmamõistetuiks areenil kogu maailmale vaadata, nii inglitele kui inimestele. ");
INSERT INTO ekk_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Meie oleme arutud Kristuse pärast, aga teie olete ju mõistlikud Kristuses! Meie oleme nõrgad, aga teie olete tugevad! Teid austatakse, aga meie põlatakse! ");
INSERT INTO ekk_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Praeguse tunnini me kannatame nälga ja janu, riietatud kaltsudesse, meid pekstakse ja me oleme kodutud. ");
INSERT INTO ekk_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Me teeme väsitavat tööd oma kätega. Kui meid neetakse, siis me õnnistame, kui meid taga kiusatakse, siis me kannatame ära, ");
INSERT INTO ekk_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","kui meid laimatakse, siis vastame lahkesti. Me oleme maailma saast, prügi kõikide jaoks tänapäevani. ");
INSERT INTO ekk_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Ma ei kirjuta seda teie häbistamiseks, vaid manitsedes teid nagu oma armsaid lapsi. ");
INSERT INTO ekk_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Sest kui teil oleks ka kümme tuhat juhendajat Kristuses, ei ole teil mitut isa, sest evangeeliumi läbi sain mina teie isaks Kristuses Jeesuses. ");
INSERT INTO ekk_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Seepärast ma õhutan teid võtma mind eeskujuks! ");
INSERT INTO ekk_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Selleks ma saatsin teie juurde Timoteose, oma armsa ja ustava poja Issandas. Tema tuletab teile meelde minu eluviisi Kristuses, nõnda nagu ma õpetan igal pool kõigis kogudustes. ");
INSERT INTO ekk_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Mõned teist on läinud ülbeks, arvates, et ma ei tulegi enam teie juurde. ");
INSERT INTO ekk_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Aga kui Issand tahab, siis ma tulen peagi ja saan selguse mitte ülbitsejate sõnade, vaid ka selle kohta, kui palju neil väge on. ");
INSERT INTO ekk_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Sest Jumala riik ei ole mitte sõnades, vaid väes! ");
INSERT INTO ekk_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Mida te eelistate? Kas pean tulema teie juurde karistava vitsaga või armastuse ja leebusega? ");
INSERT INTO ekk_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Olen kuulnud mitmelt poolt, et teie keskel on sugukõlvatust, ja veel sellist kõlvatust, mida ei esine isegi paganate seas, et keegi magab oma isa naisega. ");
INSERT INTO ekk_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Ja teie olete veel uhked! Te peaksite pigem leinama ja endi keskelt eemaldama mehe, kes seda on teinud. ");
INSERT INTO ekk_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Kuigi ma olen ihulikult eemal, olen ma vaimus kohal. Ja sel moel teie juures viibides teinud otsuse meie Issanda Jeesuse nimel selle üle, kes on seda teinud. ");
INSERT INTO ekk_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Kui te olete kokku tulnud ja mina olen teiega vaimus ja meie Issanda Jeesuse vägi on kohal, ");
INSERT INTO ekk_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","andke see mees saatana kätte ihu hävitamiseks, et tema vaim võiks pääseda Issanda päeval. ");
INSERT INTO ekk_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Teie kiitlemine on kohatu! Kas te siis ei tea, et pisut juuretist paneb käärima kogu taigna? ");
INSERT INTO ekk_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Puhastage end vanast juuretisest, et te oleksite uus taigen, hapnemata, nagu te ju tegelikult oletegi. Sest ka meie paasatall Kristus on tapetud. ");
INSERT INTO ekk_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Pidutsegem siis siiruse ja tõe hapnemata leivaga, mitte aga vana leivaga, mis on hapendatud kurjuse ja tigedusega! ");
INSERT INTO ekk_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Ma kirjutasin teile oma kirjas, et te ei teeks tegemist sugukõlvatutega, ");
INSERT INTO ekk_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","sugugi mitte mõeldes selle maailma kõlvatuid, ahneid ja riisujaid või ebajumalateenijaid, sest muidu tuleks teil maailmast üldse ära minna. ");
INSERT INTO ekk_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Ma tahtsin öelda, et te ei teeks tegemist ühegagi, kes nimetab end vennaks või õeks, kristlaseks, kuid on sugukõlvatu, ahne, ebajumalateenija, laimaja, joodik või riisuja. Sellisega ärge isegi koos sööge! ");
INSERT INTO ekk_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Sest kas minu asi on mõista kohut nende üle, kes on kogudusest väljas? Kas te ei peaks kohut mõistma nende üle, kes on koguduses? ");
INSERT INTO ekk_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Väljas olijate üle mõistab kohut Jumal. Heitke kurjad välja eneste keskelt! ");
INSERT INTO ekk_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Kuidas söandab keegi teie seast, kel on tüliküsimus teisega, minna kohtusse uskmatute ette, mitte Jumala pühade ette? ");
INSERT INTO ekk_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Või on teile teadmata, et kord tuleb Jumala pühadel mõista kohut kogu maailma üle? Ja kui teie peate mõistma kohut kogu maailma üle, kas ei kõlba te siis lahendama väiksemaid küsimusi? ");
INSERT INTO ekk_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Kas te siis ei tea, et kord tuleb meil mõista kohut inglitegi üle, rääkimata argistest asjadest? ");
INSERT INTO ekk_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Kui teil on tarvis arutada argielu küsimusi, kuidas te võite võtta kohtunikuks neid, kel puudub lugupidamine koguduses! ");
INSERT INTO ekk_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Seda ütlen ma teile häbiks. Kas siis teie seas ei ole ühtegi küllalt arukat, kes suudaks lahendada kahe venna tüliküsimust? ");
INSERT INTO ekk_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Selle asemel käib vend kohut vennaga, ja veel uskmatute ees! ");
INSERT INTO ekk_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Juba see on halb, et te üksteist kohtusse kaebate. Miks te pigem ei kannata ülekohut? Miks te end pigem ei lase riisuda? ");
INSERT INTO ekk_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Aga teie ise teete ülekohut ja riisute, pealegi veel oma vendi ja õdesid! ");
INSERT INTO ekk_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Või te ei tea, et ülekohtutegijad ei päri Jumala riiki? Lõpetage enesepett! Sugukõlvatud, ebajumalateenijad, abielurikkujad, mehed, kes käivad suguliselt läbi teiste meestega, ");
INSERT INTO ekk_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","vargad, ahnitsejad, joodikud, laimajad, petised ei päri Jumala riiki. ");
INSERT INTO ekk_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Ja sellised olid mõned teie seast. Aga teie olete puhtaks pestud, teid on pühitsetud Jumalale ja õigeks tehtud Issanda Jeesuse Kristuse nimes ja meie Jumala Vaimus. ");
INSERT INTO ekk_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Te ütlete „Mulle on kõik lubatud“ – aga kõigest ei ole kasu. „Mulle on kõik lubatud“ – aga miski ei tohi saada meelevalda minu üle. ");
INSERT INTO ekk_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Te ütlete „Toit on kõhu jaoks ja kõht toidu jaoks, ja Jumal teeb lõpu nii sellele kui teisele.“ Aga ihu ei ole hooruse jaoks, vaid Issanda jaoks, ja Issand ihu jaoks. ");
INSERT INTO ekk_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Ent Jumal on Issanda üles äratanud ja äratab oma väe läbi üles ka meid. ");
INSERT INTO ekk_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Kas te ei tea, et teie ihud on Kristuse ihu liikmed? Kas ma võiksin võtta Kristuse ihu liikmed ja ühendada nad hooraga? Mitte mingil juhul! ");
INSERT INTO ekk_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Või kas te ei tea, et see, kes hoiab hoora poole, on temaga üks ihu? Sest on ju öeldud „need kaks saavad üheks lihaks“. ");
INSERT INTO ekk_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Aga kes hoiab Issanda poole, on temaga üks vaim. ");
INSERT INTO ekk_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Põgenege kõlvatuse eest! Mis tahes patt, mida inimene iial teeb, on väljaspool tema ihu. Kuid kes hoorab, see patustab omaenda ihu vastu. ");
INSERT INTO ekk_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Või kas te ei tea, et teie ihu on teis oleva Püha Vaimu tempel, kelle te olete saanud Jumalalt, ja et te ei ole iseeneste omad; ");
INSERT INTO ekk_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","te olete kalli hinnaga ostetud. Austage siis Jumalat oma ihus! ");
INSERT INTO ekk_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Nüüd aga sellest, mida te kirjutasite: mehele on parem hoiduda seksuaalsuhtest naisega. ");
INSERT INTO ekk_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Aga et te ei satuks sugukõlvatusse, olgu igal abielumehel seksuaalsuhted oma naisega ja igal abielunaisel oma mehega. ");
INSERT INTO ekk_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Mees täitku oma abielukohustust naise ees ja samamoodi naine mehe ees. ");
INSERT INTO ekk_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Naisel ei ole meelevalda oma ihu üle, vaid ta annab selle oma mehele. Samamoodi ei ole mehel meelevalda oma keha üle, vaid ta annab selle oma naisele. ");
INSERT INTO ekk_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Ärge keelake end teineteisele, muidu kui vaid kokkuleppel mõneks ajaks, et pühenduda palvetamisele. Kuid pärast seda saage jälle ühte, et saatan ei saaks teid patule ahvatleda teie puuduliku enesekontrolli pärast. ");
INSERT INTO ekk_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Ma ei ütle seda mitte käsuna, vaid mööndusena. ");
INSERT INTO ekk_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Ma soovin, et te kõik oleksite nõnda nagu mina. Kuid igaühel teist on oma and Jumalalt; ühel selline and, teisel teine. ");
INSERT INTO ekk_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Kuid vallalistele ja leskedele ma ütlen, et neil oleks parem jääda abielutuks, nagu minagi olen. ");
INSERT INTO ekk_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Kui nad aga ei suuda end taltsutada, siis nad abiellugu! Parem on abielluda kui himudes põleda. ");
INSERT INTO ekk_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Ent abielus olijaid ei käsi mina, vaid Issand: naine ärgu jätku maha oma meest! ");
INSERT INTO ekk_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Kui ta seda aga siiski teeb, siis jäägu üksikuks või leppigu oma mehega ära. Ja mees ärgu hüljaku naist. ");
INSERT INTO ekk_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Ülejäänutele aga ütlen mina, mitte Issand: kui usklikul mehel on uskmatu naine, kes on nõus jätkuvalt koos temaga elama, siis ärgu mees temast lahutagu! ");
INSERT INTO ekk_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Ja kui usklikul naisel on uskmatu mees, kes on nõus jätkuvalt koos temaga elama, siis ärgu naine temast lahutagu! ");
INSERT INTO ekk_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Sest uskmatu mees on pühitsetud Jumalale uskliku naise läbi ja uskmatu naine pühitsetud Jumalale uskliku mehe läbi. Muidu oleksid teie lapsed rüvedad, aga nüüd on nad pühad. ");
INSERT INTO ekk_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Ent kui uskmatu lahkub, siis olgu nii! Sellisel juhul ei ole vend või õde temaga enam seotud. Jumal on kutsunud meid elama rahus. ");
INSERT INTO ekk_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Sest kuidas sina, naine, tead, et sa oma mehe päästad? Või kuidas võid sina, mees, teada, et sa oma naise päästad? ");
INSERT INTO ekk_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Muidu aga elagu igaüks edasi nõnda, nagu Issand on talle osaks andnud ja nagu Jumal on teda kutsunud. Seda õpetan ma kõigis kogudustes. ");
INSERT INTO ekk_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Kui keegi on saanud usklikuks ümberlõigatuna, siis ärgu ta seda varjaku. Kui keegi on saanud usklikuks ümberlõikamatuna, siis ärgu lasku end ümber lõigata. ");
INSERT INTO ekk_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Oluline ei ole ümberlõikamine või ümberlõikamatus, vaid Jumala käskude pidamine. ");
INSERT INTO ekk_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Igaüks püsigu selles kutses, milles Jumal on teda kutsunud. ");
INSERT INTO ekk_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Kui sind kutsuti orjana, ära tee sellest väljagi! Aga kui sul on võimalus saada vabaks, siis kasuta seda kindlasti! ");
INSERT INTO ekk_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Sest keda Issand on kutsunud orjana, on Issanda vabakslastu, ja keda ta on kutsunud vabana, on Kristuse ori. ");
INSERT INTO ekk_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Te olete kallilt ostetud – ärge saage inimeste orjaks! ");
INSERT INTO ekk_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Vennad ja õed, jäägu igaüks Jumala ees sellesse, milles ta on kutsutud! ");
INSERT INTO ekk_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Neitsite kohta mul ei ole Issanda korraldust, aga ma ütlen oma arvamuse kui inimene, kellele Issand on andnud armu olla usaldusväärne. ");
INSERT INTO ekk_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Niisiis ma leian, et eeloleva viletsuse pärast on parem jääda nii, nagu keegi parajasti on. ");
INSERT INTO ekk_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Kui sul on naine, ära püüa temast vabaneda! Kui oled vallaline, ära otsi endale naist! ");
INSERT INTO ekk_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Aga kui sa ka abiellud, ei tee sa pattu. Ja kui neitsi läheb mehele, ei tee ta pattu. Siiski saavad nad tunda maise elu vaevasid, millest mina tahaksin teid säästa. ");
INSERT INTO ekk_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Sellega ma mõtlen, vennad ja õed, et aeg on piiratud! Seepärast olgu nüüd need, kellel on naine, nii nagu ei oleks neil naist; ");
INSERT INTO ekk_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","ja need, kes leinavad, nii nagu ei oleks neil leina; ja kes rõõmustavad, nii nagu ei olekski neil rõõmu; ja kes ostavad vara, nii nagu ei oleks nad omanikud; ");
INSERT INTO ekk_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","ja kes seda maailma kasutavad, nii nagu ei saaks nad seda kasutada täielikult. Sest see maailm oma praegusel kujul kaob. ");
INSERT INTO ekk_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Ma tahan, et te liigselt ei muretseks. Vallaline mees muretseb Issandale kuuluva pärast, püüdes meeldida Issandale, ");
INSERT INTO ekk_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","aga abielumees muretseb maailma asjade pärast, püüdes meeldida oma naisele. ");
INSERT INTO ekk_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","Ta on otsekui lõhestatud. Samuti muretseb vallaline naine või neitsi Issandale kuuluva pärast, et olla püha nii ihu kui ka vaimu poolest. Abielunaine aga muretseb maailma asjade pärast, püüdes meeldida oma mehele. ");
INSERT INTO ekk_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Ma räägin seda teie endi kasuks: mitte selleks, et teha teile kitsendusi, vaid õhutada väärikalt käituma ja jagamatult pühenduma Issandale. ");
INSERT INTO ekk_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Aga kui keegi leiab, et ta käitub vääritult neitsi suhtes, kellega ta on kihlatud, kuna see on küps abieluks ja nõnda peaks sündima, siis ta toimigu, nagu soovib. Ta ei tee pattu, kui nad abielluvad. ");
INSERT INTO ekk_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Aga kes jääb enesele kindlaks ega ole seotud kohustusega, vaid ta valitseb oma tahte üle ja on otsustanud neitsiga mitte abielluda, ka see teeb hästi. ");
INSERT INTO ekk_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Niisiis, kes oma kihlatuga abiellub, teeb hästi, aga kes ei abiellu, teeb paremini. ");
INSERT INTO ekk_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Naine on seotud oma mehega niikaua, kui ta elab. Pärast mehe surma on ta vaba abielluma kellega tahab, kuid see sündigu Issanda juhtimisel. ");
INSERT INTO ekk_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Minu hinnangul aga oleks ta õnnelikum, jäädes nõnda, nagu ta on. Ja ma arvan, et minulgi on Jumala Vaim. ");
INSERT INTO ekk_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Nüüd ebajumala ohvrilihast. Me teame, et meil kõigil on teadmised. Teadmised teeb suureliseks, kuid armastus ehitab. ");
INSERT INTO ekk_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Kui keegi arvab, et ta midagi teab, siis ei tea ta seda veel nii, kuidas peab teadma. ");
INSERT INTO ekk_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Aga kes armastab Jumalat, selle on Jumal ära tundnud. ");
INSERT INTO ekk_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Kui nüüd rääkida ebajumala ohvriliha söömisest, siis me teame, et maailmas ei ole mingeid ebajumalaid, on ainult üks Jumal. ");
INSERT INTO ekk_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Sest kui olekski palju neid, keda hüütakse jumalaiks, kas siis maa peal või taevas, nagu ongi ju palju jumalaid ja palju isandaid, ");
INSERT INTO ekk_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","on meil üksainus Jumal, Isa, kellest on sündinud kõik ja kelle jaoks me elame, ning üks Issand, Jeesus Kristus, kelle läbi on sündinud kõik ja kelle läbi me elame. ");
INSERT INTO ekk_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Kuid mitte kõikidel ei ole seda teadmist. Mõned söövad harjumusest ebajumalatega siiani seda liha nii nagu ohvrit ebajumalale ning nende nõrk südametunnistus määrdub. ");
INSERT INTO ekk_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Ent söök ei vii meid Jumalale lähemale. Seetõttu ei kaota me midagi söömata jätmisega ega saavuta midagi söömisega. ");
INSERT INTO ekk_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Aga vaadake, et teie otsustamisõigus ei saaks kuidagi komistuseks usus nõrkadele! ");
INSERT INTO ekk_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Sest kui sind, kellel on see teadmine, näeb ebajumala templis söömas keegi nõrga südametunnistusega, eks siis tema saa julgustust ebajumalatele ohverdatu söömiseks? ");
INSERT INTO ekk_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Siis hukutab ju sinu tõde selle nõdra venna või õe, kelle pärast Kristus on surnud! ");
INSERT INTO ekk_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Nii ei tee te pattu üksnes nende vastu ega haava ainult nende nõrka südametunnistust, vaid te teete pattu ka Kristuse vastu. ");
INSERT INTO ekk_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Seepärast, kui mu söök venda või õde patule ahvatleb, siis ma loobun lihasöömisest kasvõi alatiseks, et mitte ahvatleda teda patule. ");
INSERT INTO ekk_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Eks ma ole vaba? Eks ma ole apostel? Eks ma ole näinud meie Issandat Jeesust? Eks teie ole minu töö vili Issandas? ");
INSERT INTO ekk_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Kui ma ka teistele ei ole apostel, siis teile olen ometi. Teie olete minu apostliameti pitser Issandas. ");
INSERT INTO ekk_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","See on minu kaitsekõne neile, kes mind arvustavad. ");
INSERT INTO ekk_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Kas meil ei ole õigust süüa ja juua? ");
INSERT INTO ekk_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Kas meil ei ole õigust võtta usklikku naist, nagu on teistel apostlitel, Issanda vendadel ja Keefasel? ");
INSERT INTO ekk_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Või oleme mina ja Barnabas ainsad, kel pole õigust elada tööd tegemata? ");
INSERT INTO ekk_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Milline sõdur teenib omal kulul? Kes rajab viinamäe ja ei söö viinamarju? Milline karjus ei joo oma karja piima? ");
INSERT INTO ekk_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Kas ma räägin seda inimliku meelevallaga? Kas Seadus ei ütle sedasama? ");
INSERT INTO ekk_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Moosese Seaduses on kirjutatud: „Ära seo kinni pahmast tallava härja suud!“ Kas Jumal peab silmas härga? ");
INSERT INTO ekk_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Või ütleb ta seda pigem meie pärast? Jah, meie pärast on kirjutatud, et nii kündja kui rehepeksja peavad töötama lootuses saada osa. ");
INSERT INTO ekk_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Kui me oleme teie seas külvanud vaimulikku seemet, kas seda on siis palju, kui lõikame teilt materiaalset saaki? ");
INSERT INTO ekk_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Kui teistel on see õigus teie toetusele, eks meil ole seda veel enam? Kuid meie ei ole seda õigust kasutanud, vaid me talume raskusi, et meie ei saaks kuidagi takistuseks Kristuse evangeeliumi levikule. ");
INSERT INTO ekk_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Eks teie tea, et need, kes templis töötavad, saavad templist ka oma toidu, ja need, kes altari juures teenivad, saavad osa altaril ohverdatust? ");
INSERT INTO ekk_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Nii on ka Issand seadnud, et evangeeliumi kuulutajad saaksid evangeeliumist elatise. ");
INSERT INTO ekk_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Mina aga ei ole neist õigustest kasutanud midagi. Ma ei kirjuta ka selleks, et seda tulevikus teha. Pigem ma sureksin. Keegi ei saa võtta minult mu kiitlemise alust! ");
INSERT INTO ekk_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Sest kui ma evangeeliumi kuulutan, ei saa ma sellega kiidelda. Mulle on ju pandud kohustus seda teha. Seepärast häda mulle, kui ma evangeeliumi ei kuuluta! ");
INSERT INTO ekk_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Kui ma teen oma tööd vabal valikul, siis ma saan selle eest tasu. Aga kui ma teen seda sunniviisil, siis on see ometi mulle usaldatud ülesanne. ");
INSERT INTO ekk_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Mis siis on minu tasu? Just see, et evangeeliumi kuulutades kuulutan ma seda tasuta ega kasuta oma õigust, mis käib evangeeliumiga koos. ");
INSERT INTO ekk_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Sest olles küll vaba ja sõltumatu kõigist, olen ma hakanud kõikide orjaks, et võita Kristusele võimalikult paljud. ");
INSERT INTO ekk_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Juutidele olen ma nagu juut, et võita juute Kristusele; Moosese seaduse all olijaile nagu seadusealune (kuigi ma seda ei ole), et võita seadusealuseid. ");
INSERT INTO ekk_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Väljaspool käsuseadust olijaile olen ma nagu väljaspool käsuseadust (ehkki ma ei ole tegelikult väljaspool Jumala seadust, vaid Kristuse seaduse all), et võiksin võita seaduseväliseid. ");
INSERT INTO ekk_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Nõrkadele olen ma nõrk, et võita nõrku. Ma olen kõikidele kõigeks, et päästa kasvõi mõned. ");
INSERT INTO ekk_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","Seda kõike teen ma evangeeliumi pärast, et minulgi oleks osa selle õnnistustest. ");
INSERT INTO ekk_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Eks te tea, et võidujooksu jooksevad küll kõik, kuid auhinna saab ainult üks? Siis jookske nii, et teie saate selle auhinna! ");
INSERT INTO ekk_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Iga võistleja allutab end rangele treeningule. Nad teevad seda närtsiva võidupärja pärast. Meid aga ootab pärg, mis ei närtsi iialgi. ");
INSERT INTO ekk_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Nõnda siis ei jookse ma sihitult ega võitle nagu tuult pekstes, ");
INSERT INTO ekk_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","vaid ma kohtlen oma ihu karmilt ja sunnin teda endale alluma, et teistele kuulutades ma ise ei muutuks kõlbmatuks. ");
INSERT INTO ekk_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Ärgu olgu teil teadmata, vennad ja õed, et kõik meie esiisad rändasid pilvesamba all ja kõik läksid kuiva jalaga läbi mere. ");
INSERT INTO ekk_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","Nad kõik ristiti Moosesesse pilvesambas ja meres. ");
INSERT INTO ekk_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Nad kõik sõid sedasama vaimulikku toitu ");
INSERT INTO ekk_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ning jõid sedasama vaimulikku jooki. Sest nad jõid sellest samast vaimulikust kaljust, mis neid saatis ja see kalju oli Kristus. ");
INSERT INTO ekk_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Kuid enamikuga neist Jumal ei olnud rahul ja nad löödi maha kõrbes. ");
INSERT INTO ekk_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","See juhtus meile hoiatuseks, et meie ei himustaks kurja, nagu nemad seda tegid. ");
INSERT INTO ekk_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Ärge olge ebajumalateenijad, nagu mõned neist olid, sest on kirjutatud: „Rahvas istus maha sööma ja jooma ning tõusis üles lusti lööma.“ ");
INSERT INTO ekk_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Ärgem tehkem kõlvatusi, nagu mõned neist tegid, ja nõnda suri neist ühe päevaga kakskümmend kolm tuhat. ");
INSERT INTO ekk_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Ärgem pangem Kristust proovile, nagu mõned neist panid ning said surma madude läbi. ");
INSERT INTO ekk_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Ärge ka nurisege, nagu mõned neist tegid ning tapeti hävitusingli poolt. ");
INSERT INTO ekk_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Need asjad sündisid neile kui näited ja pandi kirja hoiatuseks meile, kes me elame ajastute lõpul. ");
INSERT INTO ekk_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Niisiis, kes enese arvab seisvat, vaadaku, et ta ei langeks! ");
INSERT INTO ekk_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Teid ei ole veel tabanud muud kui inimlik kiusatus. Aga ustav on Jumal, kes ei lase teid rohkem kiusata, kui te suudate kanda, vaid ühes kiusatusega valmistab ka väljapääsu, nõnda et te suudaksite kanda. ");
INSERT INTO ekk_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Seepärast, mu armsad, põgenege ebajumalateenistuse eest! ");
INSERT INTO ekk_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Ma räägin teile kui arukatele inimestele. Otsustage ise, kas mu jutt on õige! ");
INSERT INTO ekk_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Õnnistuse karikas, mida me õnnistame, eks see ole Kristuse vere osadus? Leib, mida me murrame, eks see ole Kristuse ihu osadus? ");
INSERT INTO ekk_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Et leib on üks, siis oleme meie, keda on palju, üks ihu, sest me kõik saame osa sellest ühest leivast. ");
INSERT INTO ekk_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Mõelge neile, kes on Iisraeli rahvas vere poolest. Eks need, kes söövad altaril ohverdatut, ole altari osaduses? ");
INSERT INTO ekk_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Mida ma siis tahan öelda? Kas seda, et ebajumalaohver iseenesest on midagi või et ebajumal on midagi? ");
INSERT INTO ekk_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Ei ole, aga paganad toovad oma ohvreid mitte Jumalale, vaid kurjadele vaimudele. Ja mina ei taha, et teil oleks osa kurjade vaimude teenistusest. ");
INSERT INTO ekk_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Te ei või juua Issanda karikast ja kurjade vaimude karikast, te ei või osaleda Issanda lauas ja kurjade vaimude lauas. ");
INSERT INTO ekk_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Või tahame Issandat ajada vihale? Kas meie oleme temast tugevamad? ");
INSERT INTO ekk_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","Öeldakse „Kõik on lubatud“ – aga kõigest ei ole kasu. „Kõik on lubatud“ – aga kõik ei ehita kogudust. ");
INSERT INTO ekk_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Ärgu ükski otsigu oma kasu, vaid teise kasu! ");
INSERT INTO ekk_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Sööge kõike, mida lihaturul müüakse, südametunnistusest hoolimata, ");
INSERT INTO ekk_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","sest „Issanda oma on maa ja kõik selle annid“. ");
INSERT INTO ekk_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Kui uskmatu kutsub teid sööma ja te tahate minna, siis sööge kõike, mida teile pakutakse, südametunnistusest hoolimata. ");
INSERT INTO ekk_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Kui aga keegi peaks teile ütlema: „See on ohvriliha!“, siis jätke see söömata nii ütleja enda pärast kui ka südametunnistuse pärast. ");
INSERT INTO ekk_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Ent mina ei räägi sinu, vaid teise südametunnistusest. Sest milleks peaks teise südametunnistus otsustama minu vabaduse üle? ");
INSERT INTO ekk_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","Kui mina toidu tänuga vastu võtan, miks mind siis laidetakse selle pärast, mille eest ma Jumalat tänan? ");
INSERT INTO ekk_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Niisiis, kas te sööte, joote või mida iganes te teete, tehke seda Jumala auks! ");
INSERT INTO ekk_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Ärge olge komistuseks ei juutidele, kreeklastele ega Jumala kogudusele, ");
INSERT INTO ekk_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","nii nagu minagi püüan olla igati vastuvõetav kõigile. Ma ei otsi oma, vaid paljude kasu, et nad päästetaks. ");
INSERT INTO ekk_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Võtke mind eeskujuks, nagu mina võtan Kristuse! ");
INSERT INTO ekk_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Ma kiidan teid selle eest, et te mind alati meeles peate ning hoiate kinni õpetustest, mis ma teile edasi andsin. ");
INSERT INTO ekk_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Aga ma tahan, et te teaksite: Kristus on iga mehe pea, aga mees on naise pea, ja Jumal on Kristuse pea. ");
INSERT INTO ekk_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Iga mees, kes kaetud peaga palvetab või prohvetlikult räägib, häbistab oma pead. ");
INSERT INTO ekk_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Ja naine, kes katmata peaga palvetab või prohvetlikult räägib, häbistab oma pead, sest see on sama hea, nagu oleks ta pea paljaks aetud. ");
INSERT INTO ekk_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Kui naine ei kata oma pead, siis lõigaku juba ka juuksed maha! Ent kui naisele on häbiks lasta juukseid lõigata või pead paljaks pügada, siis ta katku oma pea kinni. ");
INSERT INTO ekk_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Mehel pole vaja pead katta, sest ta on Jumala kujutis ja tema au peegeldus. Naine aga on mehe au peegeldus. ");
INSERT INTO ekk_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Mees ei ole ju naisest, vaid naine mehest. ");
INSERT INTO ekk_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Ka ei ole mees loodud naise pärast, vaid naine mehe pärast. ");
INSERT INTO ekk_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Seetõttu, ja ka inglite pärast, peab naine kandma meelevalla tunnust pea peal. ");
INSERT INTO ekk_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Ometi ei ole Issanda ees mees ilma naiseta midagi ega naine ilma meheta midagi. ");
INSERT INTO ekk_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Sest naine on võetud mehest ja mees tuleb ilmale naise kaudu; aga kõigi asjade algus on Jumalas. ");
INSERT INTO ekk_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Otsustage ise: kas naisel sobib paluda Jumalat katmata peaga? ");
INSERT INTO ekk_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Eks õpeta ju looduski teile, et mehele on häbiks pikad juuksed, ");
INSERT INTO ekk_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","aga naisele on need auks, sest pikad juuksed on temale antud katte eest. ");
INSERT INTO ekk_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Kui keegi tahab selle üle vaielda, siis ta teadku, et meil ega Jumala kogudustel ei ole seesugust kommet. ");
INSERT INTO ekk_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Neid korraldusi jagades ma ei kiida teid, sest teie koosviibimistest on rohkem kahju kui kasu. ");
INSERT INTO ekk_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Kõigepealt, ma olen kuulnud, et kui te kogudusena kokku tulete, on teie seas lõhesid, ja osalt ma usungi seda. ");
INSERT INTO ekk_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Kahtlemata peab teie vahel olema erimeelsusi, et näha, kellel teist on Jumala heakskiit. ");
INSERT INTO ekk_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","Kui te siis kokku tulete, ei tähista te mitte Issanda õhtusöömaaega, ");
INSERT INTO ekk_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","sest igaüks võtab sööma asudes ette omaenda õhtusöögi. Selle tagajärjel jääb üks inimene nälga ja teine jääb purju. ");
INSERT INTO ekk_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","Kas teil ei ole kodasid, kus süüa ja juua? Või põlgate te Jumala kogudust ja tahate häbistada vaeseid? Mis ma pean teile ütlema? Kas kiidusõnu? Selle eest ma teid küll ei kiida. ");
INSERT INTO ekk_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Sest mina olen Issandalt saanud, mida ma ka teile andsin: „Sel ööl, mil Issand Jeesus ära anti, võttis ta leiva, ");
INSERT INTO ekk_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","ja kui ta oli tänanud, murdis selle ja ütles: „See on minu ihu, mis murtakse teie eest. Tehke seda minu mälestuseks!“ ");
INSERT INTO ekk_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Samuti võttis ta pärast söömist veinikarika ja ütles: „See karikas on uus leping minu veres. Nii tihti, kui te seda joote, tehke seda minu mälestuseks!“ “ ");
INSERT INTO ekk_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Sest iga kord, kui te seda leiba sööte ja karikast joote, kuulutate te Issanda surma kuni tema tagasitulekuni. ");
INSERT INTO ekk_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Kes iganes seda leiba sööb või Issanda karikast joob vääritul viisil, on süüdi patus Issanda ihu ja vere vastu. ");
INSERT INTO ekk_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Seepärast katsuge ennast läbi ja alles siis sööge sellest leivast ja jooge sellest karikast! ");
INSERT INTO ekk_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Sest kes sööb ja joob, see sööb ja joob enesele karistust, kui ta ei anna aru sellest ihust. ");
INSERT INTO ekk_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Seetõttu ongi teie seas palju põduraid ja jõuetuid ning mitmed on ära surnud. ");
INSERT INTO ekk_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Aga kui me ennast läbi katsume, ei satu me sellise kohtu alla. ");
INSERT INTO ekk_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Kui me eneste üle mõistame kohut, siis Issand kasvatab meid, et meid koos maailmaga hukka ei mõistetaks. ");
INSERT INTO ekk_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Seepärast, vennad ja õed, kui te tulete kokku sööma, siis oodake üksteist. ");
INSERT INTO ekk_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Kui kellelgi on kõht tühi, siis ta söögu enne kodus, et teie kokkutulek ei tooks kaasa karistust. Muud asjad ma korraldan, kui ma tulen. ");
INSERT INTO ekk_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Nüüd aga vaimuandidest, vennad ja õed. Selles osas ei taha ma jätta teid teadmatusse. ");
INSERT INTO ekk_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Te teate, et kui te veel paganad olite, lasite ennast mõjutada ning ühel või teisel viisil juhtida tummade ebajumalate juurde. ");
INSERT INTO ekk_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Seepärast ma tahan, et te teaksite – keegi ei ütle Jumala Vaimus rääkides: „Neetud olgu Jeesus!“ ning keegi ei suuda öelda: „Jeesus on Issand!“ muidu kui Pühas Vaimus. ");
INSERT INTO ekk_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Andides on küll erinevusi, aga neid jagab sama Vaim. ");
INSERT INTO ekk_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Teenimisviisides on erinevusi, aga Issand on seesama. ");
INSERT INTO ekk_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","Ja väeavaldustes on erinevusi, aga sama on Jumal, kes teeb kõike kõikide sees. ");
INSERT INTO ekk_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Igaühele antakse Vaimu avaldus ühiseks kasuks. ");
INSERT INTO ekk_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Nii antakse ühele Vaimu läbi tarkusesõna, teisele tunnetusesõna sama Vaimu läbi. ");
INSERT INTO ekk_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","Ühele usku samas Vaimus, teisele tervendamise ande samas Vaimus. ");
INSERT INTO ekk_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","Ühele väge imetegudeks, teisele prohvetlikku kõnelemist, kolmandale võimet vaimude eristamiseks. Ühele rääkida mitmesuguseid võõraid keeli, teisele aga keelte tõlgitsemist. ");
INSERT INTO ekk_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","Kõike seda teeb aga üks ja seesama Vaim, kes jagab neid igaühele nii, nagu ta on otsustanud. ");
INSERT INTO ekk_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Sest nii nagu ihu on üks tervik ja seal on palju liikmeid, nõnda on ka Kristus. ");
INSERT INTO ekk_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Sest me kõik oleme ühe Vaimuga ristitud ühte ihusse, olgu juudid või kreeklased, orjad või vabad – me kõik oleme joodetud ühe Vaimuga. ");
INSERT INTO ekk_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Ihu ei koosne ju ühest liikmest, vaid paljudest. ");
INSERT INTO ekk_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","Kui jalg ütleks: „Kuna mina ei saa olla käsi, ei ole ma ihu osa,“ kas ta seepärast ei kuulu ihusse? ");
INSERT INTO ekk_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","Ja kui kõrv ütleks: „Kuna mina ei saa olla silm, ei ole ma enam ihu osa,“ kas ta seepärast ei kuulu ihusse? ");
INSERT INTO ekk_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","Kui kogu ihu oleks silm, kuidas saaks ta kuulda? Kui kogu ihu tegeleks kuulmisega, kuidas saaks ta tunda lõhna? ");
INSERT INTO ekk_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Jumal on seadnud iga liikme ihusse nõnda, nagu tema on otsustanud. ");
INSERT INTO ekk_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Kui kõik oleksid üks liige, siis kus oleks ihu? ");
INSERT INTO ekk_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Meil on aga palju liikmeid, ent üks ihu. ");
INSERT INTO ekk_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Silm ei või öelda käele: „Ma ei vaja sind!“ või pea öelda jalgadele: „Ma ei vaja teid!“ ");
INSERT INTO ekk_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Otse vastupidi, nõrgemana tunduvad ihuliikmed on hädavajalikud ");
INSERT INTO ekk_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","ning vähem auväärseks peetavad liikmed me riietame suurema auga. Nendesse liikmetesse, mida ei sobi näidata, suhtume suurema tagasihoidlikkusega, ");
INSERT INTO ekk_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","meie teised liikmed aga ei vaja seda. Kuid Jumal on ihu kokku ühendades andnud suurema au nendele liikmetele, kellel sellest muidu vajaka jääb, ");
INSERT INTO ekk_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","et ihus ei tekiks lõhenemist, vaid kõik liikmed hooliksid üksteisest ühtmoodi. ");
INSERT INTO ekk_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","Kui üks liige kannatab, siis kannatavad koos temaga kõik liikmed. Kui üht liiget austatakse, siis rõõmustavad sellest kõik liikmed. ");
INSERT INTO ekk_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Teie olete aga Kristuse ihu ja igaüks teist on selle liige. ");
INSERT INTO ekk_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","Jumal on seadnud koguduses esmalt mõned apostliteks, teiseks prohvetiteks, kolmandaks õpetajateks; seejärel määranud need, kes teevad imesid, tervendavad haigeid, abistavad hoolekandes, korraldavad koguduse elu, räägivad mitmesuguseid keeli. ");
INSERT INTO ekk_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Ega kõik ole apostlid? Ega kõik prohvetid? Ega kõik õpetajad? Ega kõik tee imesid? ");
INSERT INTO ekk_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","Ega kõigil ole tervendamisande? Ega kõik räägi keeli? Ega kõik tõlgitse neid? ");
INSERT INTO ekk_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","Teie aga taotlege suuremaid ande! Ja ma näitan teile tee, mis on üle kõige. ");
INSERT INTO ekk_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","Kui ma räägiksin inimeste ja inglite keeli, aga mul puuduks armastus, siis ma oleksin kõmisev gong või kõlksuv vasktaldrik. ");
INSERT INTO ekk_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","Ja kui mul oleks prohvetiand ja ma mõistaksin kõiki saladusi ning tunnetaksin kõike ja mul oleks täielik usk, nii et võiksin mägesid teisaldada, aga mul ei oleks armastust, siis poleks ma midagi. ");
INSERT INTO ekk_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","Kui ma kogu oma vara ära jagaksin ja oma ihu annaksin tuleleekidele, aga mul ei oleks armastust, siis ma ei saavutaks midagi. ");
INSERT INTO ekk_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Armastus on pika meelega, armastus on helde, ta ei ole kade, ta ei hoople ega ole ennast täis, ");
INSERT INTO ekk_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","ta ei käitu ebasündsalt, ta ei ole isekas, ta ei ärritu ega pea arvet halva üle, ");
INSERT INTO ekk_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","ta ei rõõmusta ülekohtust, vaid tunneb rõõmu tõe üle. ");
INSERT INTO ekk_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","Ta toetab alati, usaldab alati, loodab alati, talub kõike. ");
INSERT INTO ekk_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Armastus ei hääbu kunagi! Aga prohvetikuulutused – need lakkavad; keeled – need vaikivad; tunnetus – see ammendub. ");
INSERT INTO ekk_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","Sest poolikult me tunnetame ja meie prohvetisõnumidki on poolikud. ");
INSERT INTO ekk_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","Aga kui tuleb täiuslik, siis kaob see, mis on poolik. ");
INSERT INTO ekk_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","Kui ma olin veel väeti laps, siis ma rääkisin nagu väeti laps, arvasin nagu väeti laps, arutlesin nagu väeti laps. Aga kui ma sain meheks, minetasin ma lapse kombed. ");
INSERT INTO ekk_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","Praegu me näeme ainult nagu peegeldust peeglist, siis näeme aga palgest palgesse. Praegu ma tunnetan poolikult, aga siis ma tunnetan täiesti, nagu minagi olen täiesti tunnetatud. ");
INSERT INTO ekk_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","Ent nüüd jääb usk, lootus, armastus, need kolm; aga suurim neist on armastus. ");
INSERT INTO ekk_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","Taotlege armastust, igatsege vaimuandeid, eriti aga prohvetlikku kõnelemist! ");
INSERT INTO ekk_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","Sest keeltes kõneleja ei räägi inimestele, vaid Jumalale. Sest teised ei saa temast aru, ta räägib Vaimu mõjul saladusi. ");
INSERT INTO ekk_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","Aga kes prohvetlikult kõneleb, see räägib inimestele kin